﻿USE sofia;
DROP TABLE IF EXISTS sofia.kans_vpl;
CREATE TABLE kans_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kans_vpl WRITE;
INSERT INTO kans_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ಜೆಜು ಕ್ರಿಸ್ತಾಚಿ ವಂಶಾವಳಿ ಹಿ. ಜೆಜು ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ಪಿಳ್ಗಿತ್ಲ್ಯಾ ದಾವಿದಾಚ್ಯಾ ಪಿಳ್ಗಿಚೊ: ");
INSERT INTO kans_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ಅಬ್ರಾಹಾಮ್ ಇಸಾಕಾಚೊ ಬಾಬಾ, ಇಸಾಕ್ ಜಾಕೊಬಾಚೊ ಬಾಬಾ, ಅನಿ ಜಾಕೊಬ್ ಜುದಾ ಅನಿ ತೆಚ್ಯಾ ಭಾವಾಂಚೊ ಬಾಬಾ, ");
INSERT INTO kans_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ಜುದಾ ಫೆರೆಜಾಚೊ ಅನಿ ಜೆರಾಚೊ ಬಾಬಾ ಅನಿ ಹೆಂಚ್ಯಾ ಬಾಯ್ಚೆ ನಾವ್ ತಾಮಾರ್, ಫೆರೆಜ್ ಹೆಸ್ರೊನಾಚೊ ಬಾಬಾ ಅನಿ ಹೆಸ್ರೊನ್ ಆರಾಮಾಚೊ ಬಾಬಾ, ");
INSERT INTO kans_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ಆರಾಮ್ ಅಮಿನಾದಾಬಾಚೊ ಬಾಬಾ ಅನಿ ಅಮಿನಾದಾಬ್ ನಾಆಸೊನಾಚೊ ಬಾಬಾ ಅನಿ ನಾಆಸೊನ್ ಸಾಲ್ಮೊನಾಚೊ ಬಾಬಾ, ");
INSERT INTO kans_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ಸಾಲ್ಮೊನ್ ಬೊಆಜಾಚೊ ಬಾಬಾ ಅನಿ ಬೊಆಜಾಚ್ಯಾ ಬಾಯ್ಚೆ ನಾವ್ ರಾಹಾಬ್, ಬೊಆಜ್ ಒಬೆದಾಚೊ ಬಾಬಾ ಅನಿ ರುತ್ ಒಬೆದಾಚಿ ಬಾಯ್, ಒಬೆದ್ ಯೆಸ್ಸೆಚೊ ಬಾಬಾ ಅನಿ ಯೆಸ್ಸೆ ದಾವಿದ್ ರಾಜಾಚೊ ಬಾಬಾ, ");
INSERT INTO kans_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ದಾವಿದ್ ರಾಜಾ ಸಾಲ್ಮಾವಾಚೊ ಬಾಬಾ ಅನಿ ಸಾಲ್ಮಾವಾಚಿ ಬಾಯ್ ಅದ್ದಿ ಉರಿಯಾ ಮನ್ತಲ್ಲ್ಯಾ ಎಕಾ ಮಾನ್ಸಾಚಿ ಬಾಯ್ಕೊ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ಸಾಲ್ಮಾವ್ ರೆಹೊಬೊಆಮಾಚೊ ಬಾಬಾ, ರೆಹೊಬೊಆಮ್ ಅಬಿಯಾಚೊ ಬಾಬಾ, ಅಬಿಯಾ ಆಸಾಚೊ ಬಾಬಾ. ");
INSERT INTO kans_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ಆಸಾ ಯೊಸಾಫಾತಾಚೊ ಬಾಬಾ, ಯೊಸಾಫಾತ್ ಯೊರಾಮಾಚೊ ಬಾಬಾ, ಅನಿ ಯೊರಾಮ್ ಒಸ್ಸಿಯಾಚೊ ಬಾಬಾ, ");
INSERT INTO kans_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ಒಸ್ಸಿಯಾ ಯೊತಾಮಾಚೊ ಬಾಬಾ, ಯೊತಾಮ್ ಆಖಾಜಾಚೊ ಬಾಬಾ, ಅನಿ ಆಖಾಜ್ ಹಿಜ್ಕಿಯಾಚೊ ಬಾಬಾ, ");
INSERT INTO kans_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ಹಿಜ್ಕಿಯಾ ಮಾನಾಸ್ಸೆಚೊ ಬಾಬಾ, ಮಾನಾಸ್ಸೆ ಆಮೊಸಾಚೊ ಬಾಬಾ, ಅನಿ ಅಮೊಸ್ ಯೊಸಿಯಾಚೊ ಬಾಬಾ ");
INSERT INTO kans_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ಯೊಸಿಯಾ ಯೆಕೊನಿಯಾಚೊ ಅನಿ ಭಾವಾಂಚೊ ಬಾಬಾ. ಹೆಂಚ್ಯಾ ಕಾಲಾತ್ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಾಬಿಲೊನಾಕ್ ಧರುನ್ ಘೆವ್ನ್ ಗೆಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಾಬಿಲೊನಾಕ್ ಧರುನ್ ಘೆವ್ನ್ ಗೆಲ್ಲ್ಯಾಚ್ಯಾ ಮಾನಾಚಿ ವಂಶಾವಳಿ ಹಿ: ಯೆಕೊನಿಯಾ ಶಅಲ್ತಿಯೆಲಾಚೊ ಬಾಬಾ, ಅನಿ ಶೆಅಲ್ತಿಯೆಲ್ ಯೆರುಬಾಬೆಲಾಚೊ ಬಾಬಾ, ");
INSERT INTO kans_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ಯೆರುಬಾಬೆಲ್ ಅಬಿಯುದಾಚೊ ಬಾಬಾ, ಅಬಿಯುದ್ ಎಲಿಯಾಕಿಮಾಚೊ ಅನಿ ಎಲಿಯಾಕಿಮ್ ಆಜೊರಾಚೊ ಬಾಬಾ, ");
INSERT INTO kans_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ಆಜೊರ್ ಸಾದೊಕಾಚೊ ಅನಿ ಸಾದೊಕ್ ಆಖಿಮಾಚೊ ಅನಿ ಅಖಿಮ್ ಎಲಿಯುದಾಚೊ ");
INSERT INTO kans_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ಎಲಿಯುದ್ ಎಲೆಯಾಜರಾಚೊ, ಎಲೆಯಾಜರ್ ಮಾಥಾನಾಚೊ, ಅನಿ ಮಾಥಾನ್ ಜಾಕೊಬಾಚೊ ಬಾಬಾ, ");
INSERT INTO kans_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ಜಾಕೊಬ್ ಜುಜೆಚೊ ಬಾಬಾ, ಜುಜೆಚಿ ಬಾಯ್ಕೊ ಮರಿ ಅನಿ ಮಾನಾ ಮರಿಚ್ಯಾ ಪೊಟಾನ್ ಜಲಮಲ್ಲೊ “ಜೆಜು” ತೆಕಾ ಸುಟ್ಕಾದಿನಾರೊ ಕ್ರಿಸ್ತ್: ಮನ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ಆಸೆ ಅಬ್ರಾಹಾಮಾಕ್ನಾ ದಾವಿದಾ ಪತರ್ ಚೆವ್ದಾ ಟಕ್ಲಿ, ದಾವಿದಾಕ್ನಾ ಬಾಬಿಲೊನಾಕ್ ಧರುನ್ ಘೆವ್ನ್ ಗೆಲ್ಲ್ಯಾ ಕಾಲಾ ಪತರ್ ಚೆವ್ದಾ ಟಕ್ಲಿ, ಅನಿ ಬಾಬಿಲೊನಾಕ್ ಧರುನ್ ಘೆವ್ನ್ ಗೆಲ್ಲ್ಯಾಕ್ನಾ ಕ್ರಿಸ್ತಾ ಪತರ್ ಚೆವ್ದಾ ಟಕ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ಜೆಜು ಕ್ರಿಸ್ತಾಚೊ ಜಲ್ಮ್ ಅಸೊ ಹೊಲೊ: ತೆಚಿ ಬಾಯ್ ಮರಿಚೆ ಜುಜೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಇಡೆ ಹೊಲ್ಲೆ, ಖರೆ ತೆಂಚೆ ಲಗಿನ್ ಹೊವ್ಚ್ಯಾ ಅದ್ದಿಚ್ ಮರಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಗರ್‍ವಾರ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ಜುಜೆ ಕನ್ನಾಬಿ ಖಲೆ ಸಮಾ ಹಾಯ್ ತೆಚ್ ಕರ್ನಾರೊ ಮಾನುಸ್, ಖರೆ ಮರಿಕ್ ಲೊಕಾಂಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಅವ್ಮಾನ್ ಕರುಕ್ ತೆಕಾ ಮನ್ ನತ್ತೊ, ತಸೆ ಮನುನ್ ಕೊನಾಕ್ಬಿ ಕಳಿನಸ್ತಾನಾ ತಿಕಾ ಸೊಡುನ್ ದಿವ್ಚೆ ಮನುನ್ ತೊ ಯವ್ಜುಕ್ ಲಾಗಲ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ಅಶೆ ತೊ ಯವಜ್ತಾನಾ, ತೆಚ್ಯಾ ಸಪ್ನಾತ್ ದೆವಾಚೊ ಎಕ್ ದುತ್ ದಿಸ್ಲೊ ಅನಿ, “ದಾವಿದಾಚ್ಯಾ ಘರಾನ್ಯಾಚ್ಯಾ ಜುಜೆ ಮರಿಕ್ ತುಜಿ ಬಾಯ್ಕೊ ಕರುನ್ ಘೆವ್ಕ್ ಭಿಂವ್‍ನಕೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನಿ ಗರ್‍ವಾರ್ ಹೊಲಾ. ");
INSERT INTO kans_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ತಿ ಎಕ್ ಝಿಲ್ಗ್ಯಾಕ್ ಜಲಮ್ ದಿತಾ, ತೆಕಾ ತಿಯಾ ‘ಜೆಜು’ ಮನುನ್ ನಾವ್ ಥವ್ಕ್ ಪಾಜೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಅಪ್ನಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ತೆಂಚ್ಯಾ ಪಾಪಾನಿತ್ನಾ ಸುಟ್ಕಾ ದಿತಾ”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ಪ್ರವಾದ್ಯಾಚ್ಯಾ ತೊಂಡಾತ್ನಾ ಸರ್ವೆಸ್ವರಾನ್ ಸಾಂಗಲ್ಲೆ ಸಗ್ಳೆ ಖರೆ ಹೊವ್‍ಸಾಟ್ನಿ ಮನುನ್ ಹೆ ಸಗ್ಳೆ ಅಶೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ಎಕ್ ನಿಂಬೆ ಚೆಡು ಗರ್‍ವಾರ್ ಹೊತಾ, ಅನಿ ಎಕ್ ಪೊರಾಕ್ ಜಲಮ್ ದಿತಾ ಅನಿ ತೆಕಾ ‘ಇಮ್ಮಾನುಎಲ್’ ಮನುನ್ ಬಲ್ವುತ್ಯಾತ್, ತಸೆ ಮಟ್ಲ್ಯಾರ್ ದೆವ್ ಅಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಯ್”. ");
INSERT INTO kans_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ಜುಜೆ ನಿಜೆತ್ನಾ ಉಟಲ್ಲ್ಯಾ ತನ್ನಾ ಸರ್ವೆಸ್ವರಾಚ್ಯಾ ದುತಾನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಮರಿಕ್ಡೆ ಲಗಿನ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ಖರೆ ಮರಿ ಪೊರಾಕ್ ಜಲಮ್ ದಿ ಪತರ್ ಜುಜೆನ್ ತಿಚೆಕ್ಡೆ ಸಮಂದ್ ಕರುಕ್ ನಾ, ಅನಿ ಜುಜೆನ್ ತ್ಯಾ ಪೊರಾಕ್ ಜೆಜು ಮನುನ್ ನಾವ್ ಥವ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ಜೆಜು ಜುದೆಯಾ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾಚ್ಯಾ ಬೆತ್ಲೆಹೆಮ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಜಲಮ್ಲೊ. ತನ್ನಾ ಥೈ ಹೆರೊದ್ ಮನ್ತಲೊ ರಾಜಾ ರಾಜ್ವಡ್ಕಿ ಚಾಲ್ವುಲಾಗಲ್ಲೊ. ತನ್ನಾ ದಿಸ್ ಉಗಾವ್ತಲ್ಯಾ ದಿಕ್ಕಾಕ್ನಾ ಚಿಕ್ಕಿಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಶಿಕಲ್ಲಿ ಬುದ್ವಂತ್ ಲೊಕಾ ಜೆರುಜಲೆಮಾಕ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ಅನಿ “ಜುದೆವ್ ಲೊಕಾಂಚೊ ರಾಜಾ ಹೊವ್ಕ್ ಮನುನ್ ಜಲಮಲ್ಲೊ ಪೊರ್ ಖೈ ಹಾಯ್? ದಿಸ್ ಉಗಾವ್ತಲ್ಯಾ ದಿಕ್ಕಾಕ್ ತೆಚೆ ಚಿಕ್ಕಿ ವೈರ್ ಯೆಲ್ಲೆ ಅಮಿ ಬಗಟ್ಲಾವ್, ಅನಿ ತೆಕಾ ಮಾನ್ ಕರುಕ್ ಮನುನ್ ಅಮಿ ಯೆಲಾವ್.” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ಹೆ ಆಯ್ಕುನ್ ಹೆರೊದ್ ರಾಜಾ ಲೈ ಬೆಜಾರ್ ಹೊಲೊ ಅನಿ ಜೆರುಜಲೆಮಾತ್ ಸಗ್ಳೆ ಜಾನಾ ಭಿಯಾನ್ ಭರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ಹೆರೊದಾನ್ ಸಗ್ಳ್ಯಾ ಮುಖ್ಯ ಯಾಜಕಾಕ್ನಿ ಅನಿ ಮೊಯ್ಜೆಚಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾಕ್ನಿ ಎಕಾಕ್ಡೆ ಬಲ್ವುಕ್ ಲಾವ್ಲ್ಯಾನ್, ಅನಿ “ಕ್ರಿಸ್ತ್ ಖೈ ಜಲಮ್ತಲೊ ಹಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ತನ್ನಾ ತೆನಿ “ಜುದೆಯಾಚ್ಯಾ ಬೆತ್ಲೆಹೆಮ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್” ಮಟ್ಲ್ಯಾನಿ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಪ್ರವಾದ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ಜುದೆಯಾಚ್ಯಾ ಬೆತ್ಲೆಹೆಮಾ, ಜುದಾಚ್ಯಾ ಅದಿಕಾರಾತ್ ತಿಯಾ ಬಾರಿಕ್ ಮನುನ್ ಯವ್ಜುನಕೊ. ತುಜ್ಯಾ ಭುತ್ತುರ್ನಾ ಯೆತಾ ಎಕ್ ಫುಡಾರಿ ಮಾಜ್ಯಾ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಚಾಲ್ವುನ್ ಘೆವ್ನ್ ಜಾತಲೊ. ಮನುನ್ ಲಿವಲ್ಲೆ ಹಾಯ್, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ತನ್ನಾ ಹೆರೊದ್ ರಾಜಾನ್ ತ್ಯಾ ಭೆಟುಕ್ ಯೆಲ್ಲ್ಯಾಕ್ನಿ ಕಡೆಕ್ ಬಲ್ವುನ್ ಘುಟಾನ್ ತೆ ಚಿಕ್ಕಿ ದಿಸಲ್ಲೊ ಎಳ್ ಇಚಾರುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ಮಾನಾ ತೆನಿ ತೆಂಕಾ “ಜಾವಾ ಅನಿ ತ್ಯಾ ಪೊರಾಕ್ ಬರೆ ಕರುನ್ ಹುಡ್ಕುನ್ ಕಾಡಾ ಅನಿ ಮಾಕಾಬಿ ಯೆವ್ನ್ ಸಾಂಗಾ, ಮಿಯಾಬಿ ಜಾವ್ನ್ ತೆಕಾ ಮಾನ್ ಕರುಕ್ ಪಾಜೆ” ಮನುನ್ ಸಾಂಗುನ್ ಬೆತ್ಲೆಹೆಮಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ರಾಜಾನ್ ಸಾಂಗಲ್ಲೆ ಆಯ್ಕುನ್ ತೆನಿ ಭಾಯ್ರ್ ಯೆಲೆ, ತನ್ನಾ ದಿಸ್ ಉಗಾವ್ತಲ್ಯಾ ದಿಕ್ಕಾಕ್ ದಿಸಲ್ಲಿ ತಿ ಚಿಕ್ಕಿ ತೆಂಕಾ ದಿಸ್ಲಿ, ತಿ ಚಿಕ್ಕಿ ತೆಂಚ್ಯಾ ಫಿಡೆ-ಫಿಡೆ ಜಾವ್ಕ್ ಲಾಗಲ್ಲಿ, ಅನಿ ತೊ ಪೊರ್ ಹೊತ್ತ್ಯಾ ಜಾಗ್ಯಾಕ್ ಜಾವ್ನ್ ಇಬೆ ರ್‍ಹಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ತಿ ಚಿಕ್ಕಿ ಬಗುನ್ ತೆಂಕಾ ಲೈ ಕುಶಿ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ತೆನಿ ತ್ಯಾ ಘರಾತ್ ಗೆಲ್ಯಾನಿ ಅನಿ ತೆಚ್ಯಾ ಬಾಯ್ ಮರಿಕ್ಡೆ ಹೊತ್ತ್ಯಾ ಪೊರಾಕ್ ಬಗುನ್ ಡೊಗ್ಲಾ ಟೆಕುನ್ ತೆಕಾ ಮಾನ್ ಕರ್‍ಲ್ಯಾನಿ. ಮಾನಾ ಅಪ್ನಿ ಹಾನಲ್ಲೆ ಸೊನೆ, ಧುಪ್ ಅನಿ ರಗಾತ್ಬೊಳ್ ಕಾನಿಕ್ ಮನುನ್ ತ್ಯಾ ಪೊರಾಕ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ಹೆರೊದ್ ರಾಜಾಕ್ಡೆ ಪರ್ತುನ್ ಜವ್ನಕಾಸಿ ಮನುನ್ ದೆವಾನ್ ತೆಂಕಾ ಸಪ್ನಾತ್ ಯೆವ್ನ್ ತಾಕಿತ್ ದಿಲ್ಲ್ಯಾನ್, ತಸೆ ಮನುನ್ ತೆನಿ ದುಸ್ರಿಚ್ ವಾಟ್ ಧರುನ್ ತೆಂಚ್ಯಾ ದೆಸಾಕ್ನಿ ಪರ್ತುನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ತಿ ಭೆಟುಕ್ ಎಲ್ಲಿ ಲೊಕಾ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಸರ್ವೆಸ್ವರಾಚೊ ಎಕ್ ದುತ್ ಜುಜೆಕ್ ಸಪ್ನಾತ್ ದಿಸ್ಲೊ, ಅನಿ, “ಉಟ್, ಹೆರೊದ್ ಬಾಳ್ಶ್ಯಾಚೊ ಜಿವ್ ಕಾಡುಕ್ ಮನುನ್ ಹುಡ್ಕುನ್ಗೆತ್ ಯೆನಾರ್ ಹಾಯ್, ಬಾಳ್ಶ್ಯಾಕ್ ಅನಿ ತೆಚ್ಯಾ ಅವ್ಸಿಕ್ ಘೆ ಅನಿ ಇಜಿಪ್ತಾಕ್ ಪಳುನ್ ಜಾ, ಅನಿ ಮಿಯಾ ಸಾಂಗಿ ಪತರ್ ಥೈಚ್ ರ್‍ಹಾ,” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ಜುಜೆ ಉಟ್ಲೊ, ಅನಿ ಬಾಳ್ಶ್ಯಾಕ್ ಅನಿ ಅವ್ಸಿಕ್ ಘೆವ್ನ್ ರಾತೊ-ರಾತ್ ಇಜಿಪ್ತಾಕ್ ಪಳುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ಹೆರೊದ್ ರಾಜಾ ಮರಿ ಪತರ್ ತೆನಿ ಇಜಿಪ್ತಾತುಚ್ ರ್‍ಹಾಲ್ಯಾನಿ. ಅಶೆ ಸರ್ವೆಸ್ವರಾನ್ ಪ್ರವಾದ್ಯಾಚ್ಯಾ ತೊಂಡಾನಿತ್ನಾ “ಇಜಿಪ್ತಾತ್ನಾ ಮಿಯಾ ಮಾಜ್ಯಾ ಲೆಕಾಕ್ ಬಲ್ವುತಾ” ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಖರೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ತ್ಯಾ ಭೆಟುಕ್ ಯೆಲ್ಲ್ಯಾನಿ ಅಪ್ನಾಕ್ ಪಸ್ವುಲ್ಯಾನಿ ಮನುನ್ ಹೆರೊದಾಕ್ ಕಳ್ಳೆ, ತನ್ನಾ ಹೆರೊದ್ ರಾಜಾಕ್ ಕಡ್ಕಡುನ್ ರಾಗ್ ಯೆಲೊ ತ್ಯಾ ಭೆಟುಕ್ ಯೆಲ್ಲ್ಯಾನಿಕ್ನಾ ಆಯ್ಕುನ್ ಘೆಟಲ್ಲ್ಯಾ ಎಳಾಚೊ ಅಂದಾಜ್ ಕರುನ್ ಘೆವ್ನ್ ಬೆತ್ಲೆಹೆಮಾತ್ ಅನಿ ಭೊತ್ಯಾನಿ ಹೊತ್ತ್ಯಾ ಗಾವಾನಿತ್ಲ್ಯಾ ದೊನ್ ವರ್ಸಾಚ್ಯಾ ಭುತ್ತುರ್‍ಲ್ಯಾ ಝಿಲ್ ಪೊರಾಕ್ನಿ ಜಿವಾನಿ ಮಾರಾ ಮನುನ್ ಅಪ್ನಾಚ್ಯಾ ಸೈನಿಕಾಕ್ನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ಅನಿ ತೆನಿ ಸಗ್ಳ್ಯಾ ಪೊರಾಕ್ನಿ ಜಿವಾನಿ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ಅಶೆ ಜೆರೆಮಿಯಾ ಪ್ರವಾದ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ರಾಮಾ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್, ಎಕ್ ಬೊಬ್ ಆಯ್ಕೊ ಯೆಲಿ, ಎಗ್ದಮ್ ತರಾಸಾಚೊ ವಿಪ್ಳಾಪ್ ಅನಿ ರಡ್ನ್ಯಾಚೊ ಅವಾಜ್ ತೊ, ರಾಖ್ಹೆಲ್ ಅಪ್ನಾಚ್ಯಾ ಪೊರಾಂಚ್ಯಾಸಾಟ್ನಿ ರಡುಲಾಗಲ್ಲಿ ತಿಚಿ ಪೊರಾ ಮರಲ್ಲಿ, ತಿಕಾ ಕವ್ಡೆ ಸಮಾದಾನ್ ಸಾಂಗ್ಲ್ಯಾರ್‍ಬಿ ತಿ ಆಯ್ಕುಕ್ ತಯಾರ್ ನತ್ತಿ. ಮನುನ್. ಸಾಂಗಲ್ಲೆ ಖರೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ಹೆರೊದ್ ರಾಜಾ ಮರಲ್ಲ್ಯಾ ತನ್ನಾ ಸರ್ವೆಸ್ವರಾಚೊ ದುತ್ ಅನಿ ಎಗ್ದಾ ಇಜಿಪ್ತಾತ್ ಜುಜೆಕ್ ಸಪ್ನಾತ್ ದಿಸ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ಅನಿ, “ಉಟ್ ಅನಿ ಬಾಳ್ಶ್ಯಾಕ್ ಅನಿ ಅವ್ಸಿಕ್ ಘೆವ್ನ್ ಇಸ್ರಾಯೆಲ್ ದೆಶಾಕ್ ಜಾ, ಪೊರಾಚೊ ಜಿವ್ ಕಾಡುಕ್ ಮನುನ್ ಹುಡಕ್ತಲಿ ಲೊಕಾ ಅತ್ತಾ ಮರುನ್ ಗೆಲಿ.” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ತನ್ನಾ ಜುಜೆ ಬಾಳ್ಶ್ಯಾಕ್ ಅನಿ ತೆಚ್ಯಾ ಅವ್ಸಿಕ್ ಮರಿಕ್ ಘೆವ್ನ್ ಇಸ್ರಾಯೆಲಾಕ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ಖರೆ ಹೆರೊದಾಚ್ಯಾ ಜಾಗ್ಯಾರ್ ತೆಚೊ ಲೆಕ್ ಅರ್‍ಖೆಲಾವ್ ಜುದೆಯಾಚೊ ರಾಜಾ ಹೊಲಾ ಮನುನ್ ಆಯ್ಕುನ್ ಜುಜೆ ಬೆತ್ಲೆಹೆಮಾಕ್ ಜಾವ್ಕ್ ಭಿಂಯಾಲೊ, ಅನಿ ಸಪ್ನಾತ್ ತೆಕಾ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಗಾಲಿಲಿಯಾ ಪ್ರಾಂತ್ಯಾಕ್ ತೊ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ಅನಿ ಥೈ ನಜರೆತ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ರ್‍ಹಾಲೊ. ಅಶೆ “ತೆಕಾ ನಜರೆತ್‍ಕಾರ್ ಮನುನ್ ಬಲ್ವುತ್ಯಾತ್” ಮನುನ್ ಪ್ರವಾದ್ಯಾನಿ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗಟಲ್ಲೆ ಖರೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ತ್ಯಾ ಎಳಾರ್ ಜುದೆಯಾ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ ಜುವಾಂವ್ ಬಾವ್ತಿಸ್ ಹೊತ್ತೊ, ತೊ ಡಂಗ್ಳಿತ್ ಶಿಕ್ವುಲಾಲೊ, ");
INSERT INTO kans_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ತೊ “ತುಮ್ಚೆ ಪಾಪಾಚೆ ಜಿವನ್ ಸೊಡಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸರ್ಗಾಚೊ ರಾಜ್ ಜಗ್ಗೊಳ್ ಯೆಲಾ.” ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ಡಂಗ್ಳಿತ್ ಎಕ್ ಮಾನುಸ್ ಬೊಬ್ ಮಾರ್‍ತಲೆ ಆಯ್ಕೊ ಯೆತಾ, “ಧನಿಯಾಕ್ ಎಕ್ ವಾಟ್ ತಯಾರ್ ಕರಾ,” ತೊ ಯೆತಲೊ ಹಾಯ್ ತೆಕಾ ಯೆವ್ಕ್ ರಸ್ತೊ ನಿಟ್ ಕರಾ ಮನುನ್ ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾನ್ ಸಾಂಗಟಲ್ಲೆ ಜುವಾಂವಾಚ್ಯಾಚ್ ವಿಶಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ಜುವಾಂವಾಕ್ ಒಂಟೆಚ್ಯಾ ಕೆಸಾನಿ ಕರಲ್ಲೆ ಕಪ್ಡೆ ನೆಸಲ್ಲ್ಯಾನ್, ಅನಿ ಕಂಬ್ರೆಕ್ ಚಮ್ಡ್ಯಾಚೊ ಪಟ್ಟೊ ಭಾಂದಲ್ಲ್ಯಾನ್, ಟುಪ್ಪುನ್ಯಾ ಅನಿ ಡಂಗ್ಳಿತ್ಲೆ ಮ್ಹಾವ್ ಖಾವ್ನ್ ತೊ ಜಿವನ್ ಕರುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ತನ್ನಾ ಜೆರುಜಲೆಮ್ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ನಾ ಜುದೆಯಾ ಮನ್ತಲ್ಯಾ ಇಡಿ ಪ್ರಾಂತ್ಯಾತ್ನಾ, ಅನಿ ಜೊರ್ದಾನ್ ನ್ಹಯ್ಚ್ಯಾ ಅಜು-ಬಾಜುಕ್ ಹೊತ್ತ್ಯಾ ಗಾವಾನಿತ್ನಾ ಲೊಕಾ ಜುವಾಂವಾಕ್ಡೆ ಯೆಲಿ, ");
INSERT INTO kans_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ಅನಿ ತ್ಯಾ ಲೊಕಾನಿ ಅಪ್ನಿ ಕರಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಪಾಪ್ ವಳ್ಕುನ್ ಘೆಟ್ಲ್ಯಾನಿ ತನ್ನಾ ಜುವಾಂವಾಕ್ ತೆಂಕಾ ಬಾಲ್ತಿಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ಸುಮಾರ್ ಸಾದುಸೆವಾ ಅನಿ ಫಾರಿಜೆವಾ ಬಾಲ್ತಿಮ್ ಘೆವ್ಕ್ ಯೆತಲೆ ಬಗುನ್ ಜುವಾಂವ್ “ಅರೆ! ಸಾಪಾಚ್ಯಾ ಪಿಲ್ಲಾನೊ, ಫಿಡೆ ಯೆತಲ್ಯಾ ನಾಸಾತ್ನಾ ಚುಕ್ವುನ್ ಘೆವ್ಕ್ ತುಮ್ಕಾ ಉಶಾರ್ಕಿ ಕೊನ್ ದಿಲ್ಯಾನಿ? ");
INSERT INTO kans_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ತಸೆ ಹೊಲ್ಯಾರ್ ತುಮ್ಚೆ ಪಾಪಾಚೆ ಜಿವನ್ ಅತ್ತಾ ಬದಲ್ಲಾ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತಲಿ ಕಾಮಾ ಕರಾ” ");
INSERT INTO kans_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ಅಮಿ ಅಬ್ರಾಮಾಚ್ಯಾ ಘರಾನ್ಯಾಚೆ ಮನುನ್ ತುಮಿ ದೆವಾಚ್ಯಾ ಝಡ್ತಿತ್ನಾ ಬಚಾವ್ ಹೊತ್ಯಾಶಿ ಮನುನ್ ಚಿಂತುನಕಾಸಿ, ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗುಚೆ ಜಾಲ್ಯಾರ್ ಹ್ಯಾ ಗುಂಡ್ಯಾತ್ನಾಬಿ ಅಬ್ರಾಹಾಮಾಕ್ ಪೊರಾ ದಿ ಸರ್ಕಿ ತಾಕತ್ ದೆವಾಕ್ ಹಾಯ್, ");
INSERT INTO kans_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ಝಾಡಾಚ್ಯಾ ಮುಳಾತ್ ಕುರಾಡ್ ಥವ್ನ್ ಹೊಲ್ಲಿ ಹಾಯ್, ಜೆ ಖಲೆ ಝಾಡ್ ಬರಿ ಫಳಾ ದಿ ನಾ ತೆ ಹರಿ ಎಕ್ ಝಾಡ್ ಮುಳಾತ್ನಾಚ್ ತೊಡುನ್ ಆಗಿತ್ ಟಾಕುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ತುಮಿ ಪಾಪ್ ಕರ್‍ತಲೆ ಸೊಡ್ಲ್ಯಾಶಿ ಮನುನ್ ಎಕ್ ವಳಕ್ ಮನುನ್ ಮಿಯಾ ತುಮ್ಕಾ ಪಾನಿಯಾನ್ ಬಾಲ್ತಿಮ್ ದಿವ್ಲಾ, ಖರೆ ಮಾಜ್ಯಾ ಮಾನಾ ಅನಿ ಎಕ್ಲೊ ಯೆತಲೊ ಹಾಯ್ ತೊ ಮಾಜ್ಯಾನ್ಕಿ ಮೊಟೊ, ತೆಚ್ಯಾ ಪಾಯಾತ್ಲಿ ವ್ಹಾನಾ ಕಾಡುಕ್ ಸೈತ್ ಮಿಯಾ ಯೊಗ್ಯ್ ನ್ಹಯ್. ತೊ ತುಮ್ಕಾ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಅನಿ ಆಗಿನ್ ಬಾಲ್ತಿಮ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ಅಪ್ನಾಚೆ ಸುಪ್ಪ್ ತೆನಿ ಹಾತಾತ್ ಧರ್‍ಲ್ಯಾನಾಯ್, ಅನಿ ತೊ ಅಪ್ನಾಚೆ ಖಳ್ಯಾತ್ಲೆ ದಾನೆ ವಾರೆ ದಿವ್ನ್ ಮಾಳ್ ಕರ್‍ತಾ, ಬರೆ ಅಸಲ್ಲೆ ದಾನೆ ತೊ ಅಪ್ನಾಚ್ಯಾ ತಟ್ಟ್ಯಾತ್ ಭರುನ್ ಥವ್ತಾ, ಅನಿ ಜೊಳ್ಳ್ ಕನ್ನಾಬಿ ಇಜಿನಸಲ್ಲ್ಯಾ ಆಗಿತ್ ಘಾಲುನ್ ಜಾಳ್ವುತಾ. ");
INSERT INTO kans_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ತ್ಯಾ ಎಳಾರ್ ಜೆಜು ಗಾಲಿಲಿಯಾ ಪ್ರಾಂತ್ಯಾತ್ನಾ ಜೊರ್ದಾನ್ ನ್ಹಯ್‌ಕ್ಡೆ ಜುಂವಾವಾಕ್ನಾ ಬಾಲ್ತಿಮ್ ಘೆವ್ಕ್ ಮನುನ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ಖರೆ “ಮಿಯಾ ತುಜೆಕ್ನಾ ಬಾಲ್ತಿಮ್ ಘೆವ್ಕ್ ಪಾಜೆ, ಅನಿ ತಿಯಾ ಮಾಜ್ಯಾ ಹಾತಾನಿ ಬಾಲ್ತಿಮ್ ಘೆತಲೆ ಕಶೆ?” ಮನುನ್ ಜುವಾಂವ್ ಜೆಜುಕ್ ಅಡ್ವುಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ತನ್ನಾ ಜೆಜುನ್ “ಅತ್ತಾ ಸದ್ದ್ಯಾಕ್ ಕಶೆ ಹಾಯ್ ತಸೆಚ್ ರ್‍ಹಾಂವ್ದಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಅಶೆ ರ್‍ಹಾಲ್ಯಾರುಚ್ ದೆವಾನ್ ಕಾಯ್ ಕರುಚೆ ಮನುನ್ ಯವಜ್ಲ್ಯಾನಾಯ್ ತೆ ಅಮಿ ಕರುಕ್ ಹೊತಾ.” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಜುವಾಂವ್ ಜೆಜುಕ್ ಬಾಲ್ತಿಮ್ ದಿವ್ಕ್ ತಯಾರ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ಜೆಜು ಬಾಲ್ತಿಮ್ ಘೆವ್ನ್ ಪಾನಿಯಾತ್ನಾ ವೈರ್ ಉಟುನ್ ಇಬೆ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ಮಳಬ್ ಉಗಡ್ಲ್ಯಾ ಸರ್ಕೊ ಹೊಲೊ ಅನಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ಪಾರಿವಾಳಾಚ್ಯಾ ರುಪಾರ್ ಅಪ್ನಾ ವರ್‍ತಿ ಉತ್ರುನ್ ಯೆತಲೊ ಜೆಜುನ್ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ಅನಿ “ಹ್ಯೊ ಮಾಜೊ ಅಪುರ್‍ಬಾಯೆಚೊ ಲೆಕ್ ಹೆಚ್ಯಾಸಾಟ್ನಿ ಮಾಕಾ ಲೈ ಕುಶಿ ಹಾಯ್.” ಮನುನ್ ಮಳ್ಬಾತ್ನಾ ಎಕ್ ಧನ್ ಆಯ್ಕೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ಗಿರೊ ಪರಿಕ್ಷಾ ಕರುಕ್ ಮನುನ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಜೆಜುಕ್ ಡಂಗ್ಳಿತ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ಚಾಳಿಸ್ ದಿಸಾ ಅನಿ ಚಾಳಿಸ್ ರ್‍ಹಾತಾ ಉಪ್ಪಾಸಿ ರಾವ್ನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜುಕ್ ಲೈ ಭುಕ್ ಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ತನ್ನಾ ಸೈತಾನ್ ಜೆಜುಚಿ ಪರಿಕ್ಷಾ ಕರುಕ್ ಮನುನ್ ತೆಚೆಕ್ಡೆ ಯೆಲೆ ಅನಿ “ತಿಯಾ ದೆವಾಚೊ ಲೆಕ್ ಹೊಲ್ಯಾರ್ ಹ್ಯಾ ಗುಂಡ್ಯಾಕ್ನಿ ಭಾಕ್ರಿಯಾ ಹೊವ್ಕ್ ಹುಕುಮ್ ದಿ.” ಮನುನ್ ಸಾಂಗುಕ್ಲಾಗ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ಖರೆ ಜೆಜುನ್, “ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಸಾಂಗ್ತಾ, ಮಾನುಸ್ ಖಾಲಿ ಭಾಕ್ರಿ ವೈನಾ ಎವ್ಡೆಚ್ ಜಿವನ್ ಕರಿನಾ, ಖರೆ ದೆವಾನ್ ಬೊಲಲ್ಲ್ಯಾ ಹರಿಎಕ್ ಗೊಸ್ಟಿಯಾಂಚ್ಯಾ ವೈನಾ ತೊ ಜಿವನ್ ಕರ್‍ತಾ.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ತನ್ನಾ ಗಿರೊ ಜೆಜುಕ್ ಪವಿತ್ರ್ ಶಾರ್ ಜೆರುಜಲೆಮಾಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್, ಅನಿ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ಎಗ್ದಮ್ ವೈಲ್ಯಾ ಜಾಗ್ಯಾ ವರ್‍ತಿ ನ್ಹೆಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ಅನಿ ತೆಕಾ ತಿಯಾ ದೆವಾಚೊ ಲೆಕ್ ಜಾಲ್ಯಾರ್, ಹಿತ್ನಾ ಖಾಲ್ತಿ ಹುಡಿ ಮಾರ್, ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಸಾಂಗ್ತಾ, ದೆವ್ ಅಪ್ನಾಚ್ಯಾ ದುತಾಕ್ನಿ ಹುಕುಮ್ ದಿತಾ; ತುಜೆ ತಳ್‍ಪಾಯ್ ಸೈತ್ ಗುಂಡ್ಯಾಕ್ನಿ ಅದ್ಳಿ ನಸಿ ಸರ್ಕೆ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಹಾತಾನಿ ತುಕಾ ಉಕ್ಲುನ್ ಧರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ತನ್ನಾ ಜೆಜುನ್, “ಖರೆ ಪವಿತ್ರ್ ಪುಸ್ತಕ್, ಸರ್ವೆಸ್ವರಾಚಿ ತುಜ್ಯಾ ದೆವಾಚಿ ಪರಿಕ್ಷಾ ಕರುನಕೊ ಮನುನ್ಬಿ ಸಾಂಗ್ತಾ”, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ತನ್ನಾ ಸೈತಾನಾನ್ ಜೆಜುಕ್ ಎಕ್ ಲೈ ಮೊಟ್ಯಾ ಮಡ್ಡಿ ವರ್‍ತಿ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್, ಅನಿ ದುನಿಯಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ರಾಜಾಂಚೊ ವೈಭವ್ ದಾಕ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ಅನಿ, “ತಿಯಾ ಡೊಗ್ಲಾ ಘಾಲುನ್ ಮಾಜ್ಯಾ ಪಾಯಾ ಪಡ್ಲ್ಯಾರ್, ಹೆ ಸಗ್ಳೆ ಮಿಯಾ ತುಕಾ ದಿತಾ” ಮನುನ್ ಸೈತಾನಾನ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ತನ್ನಾ ಜೆಜುನ್, “ಸೈತಾನಾ ಮಾಜ್ಯಾಕ್ನಾ ಧುರ್ ಜಾ, ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಸಾಂಗ್ತಾ, ಸರ್ವೆಸ್ವರಾ ತುಜ್ಯಾ ದೆವಾಚೆ ಎಕ್ಲ್ಯಾಚೆಚ್ ಪಾಯ್ ಪಡ್, ಅನಿ ತೆಚಿ ಎಕ್ಲ್ಯಾಚಿಚ್ ಸೆವಾ ಕರ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ತನ್ನಾ ಗಿರೊ ಜೆಜುಕ್ ಸೊಡುನ್ ಗೆಲೊ; ತನ್ನಾ ದೆವಾಚಿ ದುತಾ ಯೆಲಿ, ಅನಿ ತೆಚಿ ಮಜತ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ಜೆಜುನ್ ಜುವಾಂವಾಕ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಘಾಟ್ಲ್ಯಾನಿ ಮನ್ತಲೆ ಆಯಿಕ್ಲ್ಯಾನ್, ತನ್ನಾ ಜೆಜು ಗಾಲಿಲಿಯಾ ಪ್ರಾಂತ್ಯಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ತೊ ನಜರೆತ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ರ್‍ಹಾವ್ಕ್ ನಾ. ತೊ ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಹೊತ್ತ್ಯಾ ಜಬುಲುನ್ ಅನಿ ನಫ್ತಾಲಿ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ ಹೊತ್ತ್ಯಾ ಕಫರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಮೊಟ್ಯಾ ಗಾಂವಾತ್ ಜಾವ್ನ್ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ಅಶೆ ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾನ್ ಸಾಂಗಲ್ಲೆ ಖರೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ಸಮುಂದರಾಚ್ಯಾ ರಸ್ತ್ಯಾ ವರ್‍ತಿ ಜೊರ್ದಾನ್ ನ್ಹಯ್ಚ್ಯಾ ತಿಕುಲ್ಯಾ ಬಾಜುಕ್ ಹೊತ್ತ್ಯಾ ಜಬುಲುನ್ ಅನಿ ನಫ್ತಾಲಿಚ್ಯಾ ಪ್ರಾಂತ್ಯಾ, ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಗಾಲಿಲಿಯಾ! ");
INSERT INTO kans_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ಕಾಳ್ಕಾತ್ ಜಿವನ್ ಕರ್‍ತಲ್ಯಾ ಲೊಕಾನಿ ಎಕ್ ಮೊಟೊ ಉಜ್ವೊಡ್ ಬಗಟ್ಲ್ಯಾನಿ, ಮರ್‍ನಾಚ್ಯಾ ಕಾಳ್ಕಾತ್ ಜಿವನ್ ಕರ್‍ತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿ ಉಜ್ವೊಡ್ ಫಾಕ್ಲೊ”. ");
INSERT INTO kans_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ತನ್ನಾಚ್ಯಾನ್ ಜೆಜು ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್‍ಲಾಲೊ. ಅನಿ, “ತುಮ್ಚೆ ಪಾಪಾಚೆ ಜಿವನ್ ಸೊಡಾ, ಸರ್ಗಾಚೊ ರಾಜ್ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಪಾವ್ಲಾ,” ಮನುನ್ ಸಾಂಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ಅಶೆ ಜೆಜು ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆನ್ ಚಲುನ್ಗೆತ್ ಜಾತಾನಾ, ಮಾಸೊಳ್ಯಾ ಧರ್‍ತಲೆ ಕಾಮ್ ಕರ್‍ತಲ್ಯಾ ದೊಗೆ ಜಾನಾ ಭಾವಾಕ್ನಿ, ಪೆದ್ರು ಮನ್ತಲ್ಯಾ ಸಿಮಾವಾಕ್, ಅನಿ ತೆಚ್ಯಾ ಭಾವಾಕ್ ಅಂದ್ರುಕ್ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ತೆನಿ ಸಮುಂದರಾತ್ ಜಾಳೆ ಘಾಲುನ್ ಮಾಸೊಳ್ಯಾ ಧರುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ಜೆಜುನ್ ತೆಂಕಾ, “ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆವಾ, ಮಿಯಾ ತುಮ್ಕಾ ಮಾನ್ಸಾಕ್ನಿ ದೆವಾಚ್ಯಾ ರಾಜಾಕ್ಡೆ ಹಾನ್ತಲೆ ಕಶೆ ಮನುನ್ ಶಿಕ್ವುತಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ತನ್ನಾಚ್ ಸಿಮಾವಾನ್ ಅನಿ ಆಂದ್ರುನ್ ತೆಂಚಿ ಜಾಳಿ ಥೈಚ್ ಸೊಡ್ಲ್ಯಾನಿ ಅನಿ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ತೊ ಅನಿ ಉಲ್ಲೆ ಫಿಡೆ ಗೆಲೊ, ಥೈ ಜೆಬೆದೆವಾಚಿ ಪೊರಾ ಜಾಕೊಬ್ ಅನಿ ಜುವಾಂವ್ ಮನ್ತಲೆ ದೊಗೆ ಜಾನಾ ಭಾವ್-ಭಾವ್ ತೆಕಾ ದಿಸ್ಲೆ, ತೆನಿ ಢೊನಿತ್ ಬಸುನ್ ಅಪ್ನಾಚೊ ಬಾಬಾ ಜೆಬೆದೆವಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಅಪ್ನಾಚಿ ಜಾಳಿ ಸಮಾ ಕರುಕ್ ಲಾಗಲ್ಲ್ಯಾನಿ, ಜೆಜುನ್ ತೆಂಕಾ ಬಲ್ವುಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೆನಿ ಢೊನ್ ಅನಿ ಬಾಬಾಕ್ ಥೈಚ್ ಸೊಡ್ಲ್ಯಾನಿ ಅನಿ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ಜೆಜು ದೆವಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗಿತ್, ಸಿನಾಗೊಗಾತ್ನಿ ಶಿಕ್ವುನ್ಗೆತ್, ಅನಿ ಸಗ್ಳ್ಯಾ ಥರಿಚಿ ರೊಗಾ ಅಸಲ್ಲ್ಯಾಕ್ನಿ, ಅನಿ ಸಿಕ್ ಅಸಲ್ಲ್ಯಾಕ್ನಿ ಗುನ್ ಕರಿತ್ ಸಗ್ಳ್ಯಾ ಗಾಲಿಲಿಯಾ ಪ್ರಾಂತ್ಯಾತ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ಲಿ ಖಬರ್ ಸಿರಿಯಾ ಮನ್ತಲ್ಯಾ ದೆಶಾತ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಫರ್ಗಟ್ಲಿ, ತಸೆ ಮನುನ್ ತ್ಯಾ ಲೊಕಾನಿ ಸಗ್ಳ್ಯಾ ಅರಾಮ್ ನಸಲ್ಲ್ಯಾಕ್ನಿ, ಸಗ್ಳ್ಯಾ ಥರಿಚ್ಯಾ ರೊಗಾನಿ, ಅನಿ ದುಕ್ನ್ಯಾನಿ ತರಾಸ್ ಕರುನ್ ಘೆತಲ್ಯಾಕ್ನಿ: ಗಿರೊಲಾಗಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ, ಫೆಪ್ರೆ ಯೆತಲೊ ರೊಗ್ ಹೊತ್ತ್ಯಾಕ್ನಿ, ಅನಿ ಆರ್‍ಮಾರಲ್ಲ್ಯಾಕ್ನಿ, ತೆಚೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ, ಅನಿ ಜೆಜುನ್ ತೆಂಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ಗಾಲಿಲಿಯಾತ್ನಾ, ಧಾ ಶಾರಾನಿತ್ನಾ, ಜೆರುಜಲೆಮಾತ್ನಾ, ಜುದೆಯಾತ್ನಾ, ಜೊರ್ದಾನ್ ನ್ಹಯ್ಚ್ಯಾ ತಿಕುಲ್ಯಾ ಬಾಜುಚ್ಯಾ ಜಾಗ್ಯಾತ್ನಾ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾಂಚೊ ಮೊಟೊ ತಾಂಡೊ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ಜೆಜುನ್ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ನಿ ಬಗಟ್ಲ್ಯಾನ್ ಅನಿ ತೊ ಎಕ್ ಬಾರಿಕ್ಲ್ಯಾ ಮಡ್ಡಿ ವರ್‍ತಿ ಚಡ್ಲೊ ಅನಿ ಥೈ ಬಸ್ಲೊ. ತೆಚಿ ಶಿಸಾ ತೆಚ್ಯಾ ಭೊತ್ಯಾನಿ ಯೆವ್ನ್ ಗೊಳಾ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ತನ್ನಾ ತೆನಿ ತೆಂಕಾ ಶಿಕ್ವುಕ್ ಚಾಲು ಕರ್‍ಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ಜೆ ಕೊನಾಕ್ ಅಪ್ನಿ ಆತ್ಮಿಕ್ ರಿತಿನ್ ಗರಿಬ್ ಹಾತ್ ಮನುನ್ ಗೊತ್ತ್ ಹಾಯ್ ತೆನಿ ಸುಖಿ; ಸರ್‍ಗಾಚೆ ರಾಜ್ ತೆಂಚೆಚ್! ");
INSERT INTO kans_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ಜೆ ಕೊನ್ ತರಾಸಾತ್ ಹಾತ್ ತೆನಿ ಕವ್ಡೆ ಸುಖಿ; ದೆವುಚ್ ತೆಂಕಾ ಸಮಾದಾನ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ಜೆ ಕೊನ್ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಹಾತ್ ತೆನಿ ಕವ್ಡೆ ಸುಖಿ; ದೆವಾನ್ ತೆಂಕಾ ದಿತಾ ಮನುನ್ ಗೊಸ್ಟ್ ದಿಲ್ಲೆ ತೆನಿ ಘೆತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ದೆವಾಕ್ ಕಾಯ್ ಪಾಜೆ ತೆ ಕರ್‍ತಲೆಚ್ ಅಪ್ನಾಚಿ ಮೊಟಿ ಆಶಾ ಕರುನ್ ಘೆಟಲ್ಲಿ ಲೊಕಾ ಕವ್ಡಿ ಸುಖಿ; ದೆವ್ ತೆಂಚಿ ಸಗ್ಳಿ ಆಶಾ ಪುರಾ ಹೊಯ್ ಸರ್ಕೆ ಕರ್‍ತಾ! ");
INSERT INTO kans_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ದುಸ್ರ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ದಯಾ ದಾಕ್ವುತಲಿ ಲೊಕಾ ಕವ್ಡಿ ಸುಖಿ; ದೆವ್ ತೆಂಚಿ ದಯಾ ಕರ್‍ತಾ! ");
INSERT INTO kans_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ಬರ್‍ಯಾ ಮನಾಚಿ ಲೊಕಾ ಕವ್ಡಿ ಸುಖಿ; ತೆನಿ ದೆವಾಕ್ ಬಗ್ತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ಸಮಾದಾನ್ ಹಾನುಸಾಟ್ನಿ ರಾಬ್ತಲಿ ಲೊಕಾ ಕವ್ಡಿ ಸುಖಿ; ದೆವ್ ತೆಂಕಾ ಅಪ್ನಾಚಿ ಪೊರಾ ಮನುನ್ ಬಲ್ವುತಾ! ");
INSERT INTO kans_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ದೆವಾಕ್ ಕಾಯ್ ಪಾಜೆ ತೆ ಕರಲ್ಲ್ಯಾಸಾಟಿ ದುಸ್ರ್ಯಾನಿ ದಿಲ್ಲೊ ತರಾಸ್ ಸೊಸ್ತಲಿ ಲೊಕಾ ಕವ್ಡಿ ಸುಖಿ; ಸರ್‍ಗಾಚೊ ರಾಜ್ ತೆಂಚೊಚ್! ");
INSERT INTO kans_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ತುಮಿ ಮಾಜೆ ವಾಂಗ್ಡಿ ಮನುನ್ ಲೊಕಾನಿ ತುಮ್ಕಾ ತರಾಸ್ ದಿಲ್ಯಾರ್, ಬುರ್ಶ್ಯಾ-ಬುರ್ಶ್ಯಾ ಝುಟ್ಯಾ ಗೊಸ್ಟಿಯಾ ತುಮ್ಚ್ಯಾ ವಿರೊದ್ ಬೊಲ್ಲ್ಯಾರ್, ತುಮ್ಚಿ ಮರ್‍ಯಾದ್ ಕಾಡ್ಲ್ಯಾರ್, ತುಮಿ ಕವ್ಡೆ ಸುಖಿ. ");
INSERT INTO kans_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ಕುಸಿ ಹೊವಾ ಅನಿ ಸಂತೊಸಾನ್ ರ್‍ಹಾವಾ, ಸರ್‍ಗಾತ್ ತುಮ್ಕಾ ಮೊಟೆ ಭೊಮಾನ್ ತಯಾರ್ ಕರುನ್ ಥವಲ್ಲೆ ಹಾಯ್. ತುಮ್ಚ್ಯಾನ್ಕಿ ಅದ್ದಿ ಜಿವನ್ ಕರಲ್ಲ್ಯಾ ಪ್ರವಾದ್ಯಾಕ್ನಿಬಿ ಲೊಕಾನಿ ಅಸೊಚ್ ತರಾಸ್ ದಿಲ್ಯಾನಾತ್ . ");
INSERT INTO kans_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ತುಮಿ ಜಗಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಮಿಟ್ಟ್ ಹೊತ್ತ್ಯಾ ಬಾಸೆನ್, ಖರೆ ಮಿಟ್ಟಾನ್ ಅಪ್ನಾಚಿ ರುಚಿ ಕಳ್ದುನ್ ಘೆಟ್ಲ್ಯಾನ್ ತರ್ ತೆಕಾ ಅನಿ ಪರ್ತುನ್ ರುಚಿ ಯೈಸರ್ಕೆ ಕರುಕ್ ಹೊಯ್ನಾ. ತನ್ನಾ ತೆಕಾ ಕಾಯ್ಬಿ ಕಿಮ್ಮತ್ ರ್‍ಹಾಯ್ನಾ. ತೆಚೆಸಾಟ್ನಿ ತೆ ಭಾಯ್ರ್ ಟಾಕ್ತ್ಯಾತ್ ಅನಿ ಲೊಕಾ ತೆ ತುಡ್ವುನ್ಗೆತ್ ಫಿರುನ್ ಖೆಳ್ತಾತ್.” ");
INSERT INTO kans_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“ತುಮಿ ಸಗ್ಳ್ಯಾ ಜಗಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಉಜ್ವೊಡ್ ಅಸ್ಲ್ಯಾ ಬಾಸೆನ್. ಎಕ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಭಾಂದಲ್ಲೆ ಮೊಟೆ ಗಾಂವ್ ನಿಪುನ್ ರ್‍ಹಾವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ಕೊನ್ಬಿ ದಿವೊ ಪೆಟ್ವುನ್ ಭೊಗುನ್ಯಾಚ್ಯಾ ಬುಡಿ ಥೈನಾ; ಘರಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಉಜ್ವೊಡ್ ದಿವ್ಕ್ ಮನುನ್ ದಿವೊ ಥವ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ವೈರ್ ಥವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ತಸೊಚ್ ತುಮ್ಚೊ ಉಜ್ವೊಡ್ಬಿ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಪೆಟುಂದಿ. ಅಶೆ ತುಮಿ ಕರ್‍ತಲಿ ಬರಿ ಕಾಮಾ ಬಗುನ್ ತೆನಿ ದೆವಾಕ್ ಸರ್ಗಾ ವೈಲ್ಯಾ ತುಮ್ಚ್ಯಾ ಬಾಬಾಕ್ ಹೊಗ್ಳುಂದಿತ್”. ");
INSERT INTO kans_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ಮಿಯಾ ಮೊಯ್ಜೆನ್ ದಿಲ್ಲೆ ಖಾಯ್ದೆ ಹೊಂವ್ದಿ, ಪ್ರವಾದ್ಯಾನಿ ಶಿಕ್ವಲ್ಲೆ ಹೊಂವ್ದಿ ಕಾಡುನ್ ಟಾಕುಕ್ ಯೆಲಾ ಮನುನ್ ಯವ್ಜುನಕಾಶಿ. ಮಿಯಾ ತೆ ಕಾಡುನ್ ಟಾಕುಕ್ ಯೆವ್ಕ್ ನಾ ತೆನಿ ಶಿಕ್ವಲ್ಲೆ ಸಗ್ಳೆ ಪುರಾ ಕರುಕ್ ಮನುನ್ ಯೆಲಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಕವ್ಡೆ ಪತರ್ ಜಗ್ ಅನಿ ಸರ್ಗ್ ಹಾಯ್, ತವ್ಡೆ ಪತರ್ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾನಿತ್ಲೆ ಎಕ್ ಅಕ್ಷಾರ್ ಹೊಂವ್ದಿ ಎಕ್ ಟಿಕ್ಕೊ ಹೊಂವ್ದಿ ಪುಸುನ್ ಜಾಯ್‌ ನಸ್ತಾನಾ ತೆನಿ ಸಾಂಗಲ್ಲೆ ಸಗ್ಳೆ ಪುರಾ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ತಸೆ ಮನುನ್, ಜೆ ಕೊನ್ ಹ್ಯಾತುರ್‍ಲೊ ಎಕ್ ಎಗ್ದಮ್ ಬಾರಿಕ್ಲೊ ಖಾಯ್ದೊಬಿ ಮೊಡ್ತಾ, ಅನಿ ಖಾಯ್ದೊ ಮೊಡುಕ್ ದುಸ್ರ್ಯಾಕ್ನಿ ಶಿಕ್ವುತಾ ತೆಕಾ ಸರ್ಗಾಚ್ಯಾ ರಾಜಾತ್ ಎಗ್ದಮ್ ಕಿಳ್ ಮನುನ್ ಲೆಕ್ಕ್ ಕರ್‍ತ್ಯಾತ್. ಅನಿ ಜೆ ಕೊನ್ ಖಾಯ್ದೆ ಬರೆ ಕರುನ್ ಪಾಳ್ತಾ, ಅನಿ ದುಸ್ರ್ಯಾಕ್ನಿಬಿ ಪಾಳುಕ್ ಶಿಕ್ವುತಾ ತೊ ಸರ್ಗಾಚ್ಯಾ ರಾಜಾತ್ ಲೈ ಮೊಟೊ ಹೊವ್ನ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಲೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, ದೆವಾಕ್ ಕಾಯ್ ಪಾಜೆ ತೆ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾಂಚ್ಯಾ ಅನಿ ಫಾರಿಜೆವಾಂವಾಚ್ಯಾನ್ಕಿ ಬರೆ ತುಮಿ ಕರ್ಲ್ಯಾ ಸಿವಾಯ್ ಸರ್ಗಾಚ್ಯಾ ರಾಜಾತ್ ತುಮ್ಕಾ ಗುಸುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ಅದ್ದಿ ಲೊಕಾ “ಜಿವಾನಿ ಮಾರುಚೆ ನ್ಹಯ್” ಮನುನ್ ಸಾಂಗ್ತಲೆ ತುಮಿ ಆಯಿಕ್ಲ್ಯಾಶಿ, ತಸೆ ಕರಲ್ಲ್ಯಾಕ್ ಝಡ್ತಿ ಕರುಕ್ ಘೆವ್ನ್ ಯೆವ್ಚೆ, ");
INSERT INTO kans_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ಖರೆ ಅತ್ತಾ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ: ಜೊ ಕೊನ್ ಅಪ್ನಾಚ್ಯಾ ಭಾವಾಚ್ಯಾ ವರ್‍ತಿ ರಾಗಾನ್ ಹಾಯ್, ತೆಕಾ ಇಚಾರ್‍ನಿ ಕರುಕ್ ಘೆವ್ನ್ ಯೆವ್ಚೆ, ಜೊ ಕೊನ್ ಅಪ್ನಾಚ್ಯಾ ಭಾವಾಕ್ ತಿಯಾ ಕಾಯ್ ಕಾಮಾಕ್‍ ಯೆಯ್ ನಸಲ್ಲೊ! ಮನುನ್ ಬಲ್ವುತಾ ತೆಕಾ ಜುದೆವ್ ಲೊಕಾಂಚ್ಯಾ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಮದ್ದಿ ಹಾನುನ್ ಇಬೆ ಕರುಚೆ, ಅನಿ ಜೊ ಕೊನ್ ಅಪ್ನಾಚ್ಯಾ ಭಾವಾಕ್ ಕಸ್ಲ್ಯಾಬಿ ಫಾಯ್ದ್ಯಾಕ್ ಯೆಯ್ ನಸಲ್ಲ್ಯಾ ಪಿಶ್ಯಾ ಮನ್ತಾ ತೊ ನರ್‍ಕಾಚ್ಯಾ ಭಯಾನಕ್ ಆಗಿತ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ತೆಚೆಸಾಟ್ನಿ ತಿಯಾ ದೆವಾಕ್ ಕಾನಿಕ್ ದಿವ್ಕ್ ಮನುನ್ ಅಲ್ತಾರಿಕ್ಡೆ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ತುಜ್ಯಾ ಭಾವಾಚ್ಯಾ ವಿರೊದ್ ಕಾಯ್ತರ್ ಹಾಯ್ ಮನುನ್ ತುಕಾ ಯಾದ್ ಯೆಲ್ಯಾರ್, ");
INSERT INTO kans_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ತುಜಿ ಕಾನಿಕ್ ಥೈಚ್ ಅಲ್ತಾರಿಕ್ಡೆ ಸೊಡ್ ಅನಿ ತುಜ್ಯಾ ಭಾವಾಕ್ಡೆ ಜಾ ಅನಿ ತೆಚೆ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊ ಅನಿ ಪರ್ತುನ್ ಯೆವ್ನ್ ತುಜಿ ಕಾನಿಕ್ ದೆವಾಕ್ ದಿ. ");
INSERT INTO kans_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ಕೊನ್ ತರ್ ತುಜ್ಯಾ ವಿರೊದ್ ಪಿರ್ಯಾದ್ ದಿವ್ನ್ ತುಕಾ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಘೆವ್ನ್ ಜವ್ಚ್ಯಾ ಅದ್ದಿಚ್ ತೆಚ್ಯಾಕ್ನಾ ರಾಜಿ ಹೊ. ಎಗ್ದಾ ತಿಯಾ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಜಾವ್ನ್ ಪಾವ್ಲೆ ತರ್, ತೊ ತುಕಾ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಹಾತಿತ್ ದಿತಾ, ಅನಿ ತೊ ತುಕಾ ಅದಿಕಾರ್‍ಯಾಂಚ್ಯಾ ಹಾತಿತ್ ದಿತಾ, ಅನಿ ತುಕಾ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಲ್ತ್ಯಾತ್.” ");
INSERT INTO kans_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ತುಜ್ಯಾ ದಂಡಾಚೊ ಎಕ್-ಎಕ್ ಪೈಸೊ ಸೈತ್ ಭರುನ್ ಹೊಯ್ ಪತರ್ ತಿಯಾ ಥೈಚ್ ರ್‍ಹಾತೆಯ್. ");
INSERT INTO kans_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ವೆಭಿಚಾರ್ ಕರುನಕಾಸಿ” ಮನುನ್ ಸಾಂಗಲ್ಲೆ ತುಮಿ ಆಯಿಕ್ಲ್ಯಾಶಿ, ");
INSERT INTO kans_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ: ಕೊನ್ತರ್ ಎಕ್ಲ್ಯಾನ್ ಎಕ್ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಬಗುನ್ ಬುರ್ಶಿ ಆಶಾ ಕರ್ಲ್ಯಾರ್, ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಮನಾತುಚ್ ತಿಚೆಕ್ಡೆ ವೆಭಿಚಾರ್ ಕರ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ತುಜೊ ಉಜ್ವ್ಯಾ ಬಾಜುಚೊ ಡೊಳೊ ತುಕಾ ಪಾಪ್ ಕರುಕ್ ಕಾರನ್ ಹೊತಾ ಜಾಲ್ಯಾರ್, ತೊ ಮೆಟ್ಟುನ್ ಕಾಡ್ ಅನಿ ಧುರ್ ಟಾಕ್. ತುಜೆ ಸಗ್ಳೆ ಆಂಗ್ ನರ್‍ಕಾತ್ ನ್ಹೆವ್ನ್ ಟಾಕ್ತಲ್ಯಾಚ್ಯಾನ್ಕಿ ತುಜ್ಯಾ ಆಂಗಾಚೊ ಖಲೊಬಿ ಎಕ್ ಭಾಗ್ ನಸ್ತಾನಾ ರ್‍ಹಾತಲೆ ತುಕಾ ಕವ್ಡೆಕಿ ಬರೆ. ");
INSERT INTO kans_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ತುಜೊ ಉಜ್ವೊ ಹಾತ್ ತುಕಾ ಪಾಪ್ ಕರುಕ್ ಕಾರನ್ ಹೊತಾ ಜಾಲ್ಯಾರ್, ತೊ ಕಾತ್ರುನ್ ಕಾಡ್ ಅನಿ ಧುರ್ ನ್ಹೆವ್ನ್ ಟಾಕ್. ತುಜೆ ಸಗ್ಳೆ ಆಂಗ್ ನರ್‍ಕಾತ್ ನ್ಹೆವ್ನ್ ಟಾಕ್ತಲ್ಯಾಚ್ಯಾನ್ಕಿ ತುಜೊ ಎಕ್ ಹಾತ್ ನಸ್ತಾನಾ ರ್‍ಹಾತಲೆ ತುಕಾ ಕವ್ಡೆಕಿ ಬರೆ. ");
INSERT INTO kans_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ಕೊನ್ ತರ್ ಎಕ್ಲೊ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಸೊಡುಚೆ ಜಾಲ್ಯಾರ್ ಸೊಡ್ ಪತ್ತರ್ ಲಿವ್ನ್ ದಿವ್ನ್ ಸೊಡುಕ್ ಹೊತಾ, ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ಖರೆ ಅತ್ತಾ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ: ಬಾಯ್ಕೊ ವ್ಯೆಬಿಚಾರಾಚ್ಯಾ ಬುರ್ಶ್ಯಾ ಚಾಲಿತ್ ಪಡಲ್ಲೆ ಸೊಡುನ್ ಅನಿ ಕಸ್ಲ್ಯಾಬಿ ಕಾರನಾನ್ ಎಕ್ ಘೊಮನ್ಸಾನ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಸೊಡ್ಲ್ಯಾರ್ ತೊ ತಿ ಬಾಯ್ಕೊಮನುಸ್ ವ್ಯೆಬಿಚಾರಾಚ್ಯಾ ಬುರ್ಶ್ಯಾಪಾನಾತ್ ಪಡಿ ಸರ್ಕೆ ಕರ್‍ತಾ. ಜರ್‍ಕಡತ್ ತಿ ಬಾಯ್ಕೊಮನುಸ್ ಅನಿಎಕ್ಲ್ಯಾಕ್ ಲಗಿನ್ ಹೊಲ್ಯಾರ್ ತಿ ವ್ಯೆಬಿಚಾರ್ ಕರ್‍ತಾ ಅನಿ ತಿಕಾ ಲಗಿನ್ ಹೊಲ್ಲೊ ಘೊಮನುಸ್‍ಬಿ ವ್ಯೆಬಿಚಾರ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ದಿಲ್ಲಿ ಗೊಸ್ಟ್ ಮೊಡುನಕೊ ಅನಿ ಆನ್ ಘಾಲುನ್ ಸರ್ವೆಸ್ವರಾಕ್ ತಿಯಾ ಕಾಯ್ಬಿ ಸಾಂಗ್ಲೆ ಜಾಲ್ಯಾರ್ ತೆ ಪುರಾ ಕರ್.” ಮನುನ್ ಲೊಕಾನಿ ಸಾಂಗಲ್ಲೆ ತುಮಿ ಆಯಿಕ್ಲ್ಯಾಶಿ ");
INSERT INTO kans_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ಖರೆ ಅತ್ತಾ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ: ತುಮಿ ಕಸ್ಲಿಬಿ ಗೊಸ್ಟ್ ದಿತಾನಾ ಆನ್ ಘಾಲುನಕಾಶಿ, ಸರ್ಗಾಚ್ಯಾ ನಾವಾನ್ ಆನ್ ಘಾಲುನಕಾಶಿ, ದೆವಾಚೆ ಸಿವಾಸನ್ ತೆ; ");
INSERT INTO kans_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ಜಿಮ್ನಿಚ್ಯಾ ನಾವಾನ್‍ಬಿ ಆನ್ ಘಾಲುನಕಾಶಿ, ತೆಚೆ ಪಾಯ್ ಥವ್ತಲೊ ಮ್ಹನಿ ತಿ; ಜೆರುಜಲೆಮಾಚ್ಯಾ ನಾವಾನ್ ಆನ್ ಘಾಲುನಕಾಶಿ, ಮೊಟ್ಯಾ ರಾಜಾಚೆ ಶಾರ್ ತೆ. ");
INSERT INTO kans_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ತುಮ್ಚ್ಯಾ ಟಕ್ಲ್ಯಾರ್ ಹಾತ್ ಥವ್ನ್ ಸೈತ್ ಆನ್ ಘಾಲುನಕಾಶಿ, ಕಸ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಎಕುಚ್ಎಕ್ ಕೆಸ್ ಸೈತ್ ಕಾಳೆ ನಾ ತರ್ ಫಾಂಡ್ರೆ ಕರುಕ್ ತುಮ್ಚ್ಯಾನ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ಖಾಲಿ ಹೊಯ್ ನಾ ತರ್ ನಾ ಮನುನ್ ಸಾಂಗಾ, ಅನಿ ಜಾಸ್ತಿಚೆ ಜೆ ಕಾಯ್ ತುಮಿ ಸಾಂಗ್ತ್ಯಾಶಿ ತೆ ಸಗ್ಳೆ ಸೈತಾನಾಕ್ನಾ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ಡೊಳ್ಯಾಚ್ಯಾ ಬದ್ಲಾಕ್ ಡೊಳೊ ಅನಿ ದಾತಾಚ್ಯಾ ಬದ್ಲಾಕ್ ದಾತ್” ಮನುನ್ ಸಾಂಗಲ್ಲೆ ತುಮಿ ಆಯಿಕ್ಲ್ಯಾಶಿ, ");
INSERT INTO kans_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ಖರೆ ಅತ್ತಾ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ: ತುಮ್ಕಾ ಕೊನ್ ತರ್ ವಾಯ್ಟ್ ಕರ್‍ಲ್ಯಾನಾತ್ ಜಾಲ್ಯಾರ್ ತೆಚೊ ಶೆಡ್ ಕಾಡುನ್ ಘೆವ್‌ನಕಾಶಿ, ಕೊನ್ಬಿ ತುಮ್ಚ್ಯಾ ಉಜ್ವ್ಯಾ ಗಾಲಾರ್ ಮಾರ್‍ಲ್ಯಾರ್, ತುಜ್ಯಾ ರೊಡ್ಡ್ಯಾ ಬಾಜುಚ್ಯಾ ಗಾಲಾರ್‍ಬಿ ತೆಕಾ ಮಾರುಕ್ ಸೊಡ್. ");
INSERT INTO kans_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ಅನಿ ಕೊನ್ ತರ್ ತುಜ್ಯಾ ಭುತ್ತುರ್‍ಲಿ ಅಂಗಿ ಸಾಟಿಚ್ ತುಕಾ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ನ್ಹೆವ್ಕ್ ತಯಾರ್ ಹೊತಾ ಜಾಲ್ಯಾರ್, ತೆಕಾ ವೈಲಿ ಅಂಗಿಬಿ ಕಾಡುನ್ ದಿವಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ಎಕ್ ಸೈನಿಕಾನ್ ಅಪ್ನಾಚೆ ವಜ್ಜೆ ಘೆವ್ನ್ ಎಕ್ ಮೈಲ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆ ಮನುನ್ ಲೈ ಸಾಂಗುಕ್ ಲಾಗ್ಲ್ಯಾರ್,ದೊನ್ ಮೈಲ್ ಜಾವಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ಕೊನ್ ತರ್ ಕಾಯ್ತರ್ ತುಮ್ಚೆಕ್ಡೆ ಮಾಗ್ಲ್ಯಾರ್ ತೆ ತನ್ನಾಚ್ ತೆಕಾ ದಿವಾ; ಕೊನ್ ತರ್ ತುಮ್ಚೆಕ್ಡೆ ಕಾಯ್ತರ್ ಉಸ್ನೆ ಮಾಗ್ಲ್ಯಾರ್ ತೆ ತೆಂಕಾ ದಿವಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ತುಮ್ಚ್ಯಾ ದೊಸ್ತಾಂಚೊ ಪ್ರೆಮ್ ಕರ್ ಅನಿ ತುಮ್ಚ್ಯಾ ದುಸ್ಮನಾಕ್ನಿ ಬರೆ ಕರುನಕಾಸಿ ಮನುನ್ ಸಾಂಗಲ್ಲೆ ತುಮಿ ಆಯಿಕ್ಲ್ಯಾಶಿ; ");
INSERT INTO kans_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ಖರೆ ಅತ್ತಾ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ: ತುಮ್ಚ್ಯಾ ದುಸ್ಮನಾಚೊ ಪ್ರೆಮ್ ಕರಾ, ಅನಿ ತುಮ್ಕಾ ತರಾಸ್ ದಿತಲ್ಯಾಚ್ಯಾಸಾಟ್ನಿ ಮಾಗ್ನಿ ಕರಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ಅಶೆ ತುಮಿ ಸರ್ಗಾ ವೈಲ್ಯಾ ತುಮ್ಚ್ಯಾ ಬಾಬಾಚಿ ಪೊರಾ ಹೊತ್ಯಾಶಿ, ತೊ ಬರ್‍ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿಬಿ ಬುರ್ಶಾ ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿಬಿ ಅಪ್ನಾಚೊ ದಿಸ್ ಉಗಿಸರ್ಕೆ ಕರ್‍ತಾ. ಅನಿ ಬರೆ ಕರ್‍ತಲ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿಬಿ ಬುರ್ಶೆ ಕರ್‍ತಲ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿಬಿ ಪಾವ್ಸ್ ಧಾಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ತುಮ್ಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಲ್ಯಾಂಚೊಚ್ ತುಮಿ ಪ್ರೆಮ್ ಕರ್‍ಲ್ಯಾರ್ ದೆವಾನ್ ತುಮ್ಕಾ ಕಶ್ಯಾಕ್ ಪ್ರತಿಫಳ್ ದಿವ್ಚೆ? ತೆರ್‍ಗಿ ವಸುಲಿ ಕರ್ತಲೆಬಿ ತಸೆಚ್ ಕರ್‍ತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ತುಮ್ಚ್ಯಾ ದೊಸ್ತಾಕ್ನಿ ಎವ್ಡೆಚ್ ತುಮಿ ಮರ್‍ಯಾದ್ ದಿಲ್ಯಾರ್, ತುಮಿ ಕಾಯ್ ಕರ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊಲೆ? ದೆವಾಕ್ ವಳ್ಕಿನಸಲ್ಲಿ ಲೊಕಾಬಿ ತಸೆಚ್ ಕರ್‍ತ್ಯಾತ್ ನ್ಹಯ್! ");
INSERT INTO kans_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ಕಸೊ ಸರ್‍ಗಾ ವೈಲೊ ತುಮ್ಚೊ ಬಾಬಾ ಸಗ್ಳ್ಯಾ ರಿತಿನ್ ಪರಿಪುರ್ನ್, ತಸೆ ತುಮಿಬಿ ಸಗ್ಳ್ಯಾ ರಿತಿನ್ ಪರಿಪುರ್ನ್ ಹೊವ್ನ್ ರ್‍ಹಾವಾ!. ");
INSERT INTO kans_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ತುಮ್ಚಿ ಬರಿ ಕಾಮಾ ಲೊಕಾಕ್ನಿ ದಿಸಿ ಸರ್ಕೆ ಕರುನಕಾಸಿ, ಅಶೆ ತುಮಿ ಕಾಯ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ ಮನುನ್ ಲೊಕಾಕ್ನಿ ಕಳ್ತಾ. ತುಮಿ ಅಶೆ ಕರ್ಲ್ಯಾರ್ ಸರ್ಗಾ ವೈಲ್ಯಾ ತುಮ್ಚ್ಯಾ ಬಾಬಾಕ್ನಾ ತುಮ್ಕಾ ಕಾಯ್ಬಿ ಭೊಮಾನ್ ಗಾವಿನಾ. ");
INSERT INTO kans_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ತೆಚೆಸಾಟ್ನಿ ಕನ್ನಾಬಿ ಎಕ್ ಗರ್ಜೆತ್ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾಕ್ ತುಮಿ ಕಾಯ್ಬಿ ದಿತಾನಾ, ಕುಸ್ಡ್ಯಾ ಲೊಕಾನಿ ಲೊಕಾಕ್ನಿ ದಾಕ್ವುಕ್ ಮನುನ್ ಸಿನಾಗೊಗಾತ್ನಿ ಅನಿ ವನಿಯಾತ್ನಿ ಕರ್‍ಲ್ಯಾ ಸರ್ಕೆ ಕರುನಕಾಸಿ. ತೆನಿ ಅಶೆ ಕರಲ್ಲ್ಯಾ ತನ್ನಾ ತಿ ಮಾನ್ಸಾ ತೆಂಕಾ ಹೊಗಳ್ತ್ಯಾತ್. ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ತೆಂಚೆ ಭೊಮಾನ್ ತೆಂಕಾ ಗಾವುನ್ ಹೊಲಾ. ");
INSERT INTO kans_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ಖರೆ ತುಮಿ ಎಕ್ ಗರ್ಜೆತ್ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಮಜತ್ ಕರ್‍ತಾನಾ, ತುಮ್ಚ್ಯಾ ಉಜ್ವ್ಯಾ ಹಾತಾನ್ ದಿಲ್ಲೆ ರೊಡ್ಡ್ಯಾ ಹಾತಿಕ್ ಸೈತ್ ಕಳುಕ್ ದಿ ನಸ್ತಾನಾ ಕರಾ. ");
INSERT INTO kans_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ತನ್ನಾ ತೆ ಕೊನಾಕ್ಬಿ ಗೊತ್ತ್ ನಸ್ತಾನಾ ಕರ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊತಾ, ಅನಿ ತುಮಿ ಕೊನಾಕ್ಬಿ ಕಳ್ವಿನಸ್ತಾನಾ ಕರಲ್ಲೆ ಬಗುನ್ ತುಮ್ಚೊ ಸರ್‍ಗಾ ವೈಲೊ ಬಾಬಾ ತುಮ್ಕಾ ತ್ಯಾ ಕಾಮಾಚೊ ಪ್ರತಿಫಳ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ತುಮಿ ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ, ಕುಸ್ಡ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸರ್ಕೆ ಕರುನಕಾಸಿ! ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ಬಗಿ ಸರ್ಕೆ ಸಿನಾಗೊಗಾತ್ನಿ, ಅನಿ ವನಿಯಾತ್ನಿ ಇಬೆ ರ್‍ಹವ್ನ್ ಮಾಗ್ನಿ ಕರುಕ್ ತೆಂಕಾ ಲೈ ಕುಶಿ. ಮಿಯಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ತೆಂಚೆ ಭೊಮಾನ್ ತೆಂಕಾ ಅದ್ದಿಚ್ ಗಾವುನ್ ಹೊಲಾ, ");
INSERT INTO kans_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ಖರೆ ತುಮಿ ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ, ತುಮ್ಚ್ಯಾ ಖೊಲಿತ್ ಭುತ್ತುರ್ ಜಾವಾ ದಾರ್ ಧಾಪಾ, ಅನಿ ದಿಸಿನಸಲ್ಲ್ಯಾ ತುಮ್ಚ್ಯಾ ಬಾಬಾಕ್ಡೆ ಮಾಗಾ, ಅನಿ ತುಮಿ ಕೊನಾಕ್ಬಿ ಗೊತ್ತ್ ನಸ್ತಾನಾ ಕರಲ್ಲೆ ಬಗಟಲ್ಲೊ ಸರ್‍ಗಾ ವೈಲೊ ತುಮ್ಚೊ ಬಾಬಾ ತುಮ್ಕಾ ಪ್ರತಿಫಳ್ ದಿತಾ.” ");
INSERT INTO kans_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ತುಮಿ ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ, ತ್ಯಾ ದೆವಾಕ್ ವಳ್ಕಿನಸಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸರ್ಕೆ ಅರ್ತ್‍ ನಸಲ್ಲಿ ಲೈ-ಲೈ ಶಬ್ದಾ ವಾಪ್ರುನಕಾಶಿ, ಲಾಂಬ್-ಲಾಂಬ್ಲ್ಯಾ ಮಾಗ್ನಿಯಾ ಕರ್ಲ್ಯಾರ್ ದೆವ್ ತೆಂಚ್ಯಾ ಮಾಗ್ನಿಯಾ ಆಯಿಕ್ತಾ ಮನುನ್ ತೆನಿ ಯವಜ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ತೆಂಚೆ ಸರ್ಕೆ ಕರುನಕಾಸಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತುಮಿ ಮಾಗುಚ್ಯಾ ಅದ್ದಿಚ್ ತುಮ್ಕಾ ಕಾಚಿ-ಕಾಚಿ ಗರಜ್ ಹಾಯ್ ಮನುನ್ ತುಮ್ಚ್ಯಾ ಬಾಬಾಕ್ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ತುಮಿ ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ ಅಸೆ ಮಾಗ್ನಿ ಕರುಚೆ: “ಸರ್‍ಗಾ ವೈಲ್ಯಾ ಅಮ್ಚ್ಯಾ ಬಾಬಾ; ತುಜ್ಯಾ ಪವಿತ್ರ್ ನಾವಾಕ್ ಲೈ ಮರ್‍ಯಾದ್ ಗಾವುಂದಿ; ");
INSERT INTO kans_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ತುಜೊ ರಾಜ್ ಯೆಂವ್ದಿತ್; ಕಶೆ ಸರ್‍ಗಾ ವರ್‍ತಿ ಸಗ್ಳೆ ತುಜ್ಯಾ ಮನಾ ಸರ್ಕೆ ಹೊತಾ, ತಸೆಚ್ ಹ್ಯಾ ಜಗಾತ್‍ಬಿ ಹೊಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ಅಮ್ಕಾ ಫಿರೆ ಹೊಯ್ ಸರ್ಕೆ ಖಾನ್ ಆಜ್ ಅಮ್ಕಾ ದಿ, ");
INSERT INTO kans_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ಕಶೆ ದುಸ್ರ್ಯಾನಿ ಕರಲ್ಲ್ಯಾ ಚುಕಾ ಅಮಿ ಮಾಪ್ ಕರ್‍ತಾವ್, ತಸೆ ಅಮಿ ಕರಲ್ಲ್ಯಾ ಚುಕಾಬಿ ಮಾಪ್ ಕರ್, ");
INSERT INTO kans_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ಲೈ ಕಟಿನ್ ಪರಿಕ್ಷಾತ್ ಅಮ್ಕಾ ಘಾಲುನಕೊ, ಸೈತಾನಾಕ್ನಾ ಅಮ್ಕಾ ರಾಕ್”. ");
INSERT INTO kans_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ತುಮ್ಚ್ಯಾ ವಿರೊದ್ ಚುಕ್ ಕರಲ್ಲ್ಯಾಕ್ನಿ ತುಮಿ ಮಾಪ್ ಕರ್ಲ್ಯಾರ್, ಸರ್‍ಗಾ ವೈಲೊ ತುಮ್ಚೊ ಬಾಬಾಬಿ ತುಮ್ಚ್ಯಾ ಚುಕಾ ಮಾಪ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ತುಮಿ ದುಸ್ರ್ಯಾಕ್ನಿ ಮಾಪ್ ಕರಿನಸ್ಲ್ಯಾರ್, ತುಮ್ಚೊ ಸರ್‍ಗಾ ವೈಲೊ ಬಾಬಾಬಿ ತುಮಿ ಕರಲ್ಲ್ಯಾ ಚುಕಾ ಮಾಪ್ ಕರಿನಾ”. ");
INSERT INTO kans_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ತುಮಿ ಉಪಾಸ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ, ಕುಸ್ಡ್ಯಾ ಲೊಕಾನಿ ಕರ್ಲ್ಯಾ ಸರ್ಕೆ ತುಮ್ಚೆ ತೊಂಡ್ ಬಾವ್ಲ್ಯಾ ಸರ್ಕೆ ಕರುನ್ ಘೆವ್ನ್ ರ್‍ಹಾವ್‍ನಕಾಸಿ, ಸಗ್ಳೆಜಾನಾಕ್ನಿ ಅಪ್ನಿ ಉಪಾಸ್ ಕರುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಕಳುಕ್ ಪಾಜೆ ಮನುನ್ ತೆನಿ ತಸೆ ಕರುನ್ ಘೆವ್ನ್ ರ್‍ಹಾತ್ಯಾತ್. ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ತೆಂಚೆ ಸಗ್ಳೆ ಪ್ರತಿಫಳ್ ತೆಂಕಾ ಗಾವುನ್ ಹೊಲಾ. ");
INSERT INTO kans_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ತುಮಿ ಉಪಾಸ್ ಕರ್‍ತಾನಾ , ತುಮ್ಚೆ ತೊಂಡ್ ಧುವ್ನ್ ಘೆವಾ ಅನಿ ಟಕ್ಲ್ಯಾಕ್ ತೆಲ್ ಲಾವುನ್ ಘೆವಾ, ");
INSERT INTO kans_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ಅಶೆ ತುಮಿ ಉಪಾಸ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ ಮನುನ್ ಕೊನಾಕ್ಬಿ ದಿಸಿನಸಲ್ಲ್ಯಾ ತುಮ್ಚ್ಯಾ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ಬಾಬಾಕ್ ಸೊಡುನ್ ಅನಿ ಕೊನಾಕ್ಬಿ ಕಳುಕ್ ನಸ್ತಾನಾ ರ್‍ಹಾಂವ್ದಿ, ಅನಿ ಕೊನಾಕ್ಬಿ ಕಳಿನಸ್ತಾನಾ ಉಪಾಸ್ ಕರಲ್ಲೆ ಬಗಟಲ್ಲೊ ತುಮ್ಚೊ ಸರ್‍ಗಾ ವೈಲೊ ಬಾಬಾ ತುಮ್ಕಾ ತೆಚೊ ಪ್ರತಿಫಳ್ ದಿತಾ”. ");
INSERT INTO kans_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ಹಿತ್ತೆ ಹ್ಯಾ ಜಗಾತ್ ತುಮ್ಚೆಸಾಟ್ನಿ ಬದಿಕ್ ಗೊಳಾ ಕರುನ್ ಥವ್ನಕಾಶಿ, ಹಿತ್ತೆ ತೆಕಾ ವಾಳ್ಟಿ ಲಾಗ್ತಾ ಅನಿ ಜಂಗ್‍ಲಾಗುನ್ ಹಾಳ್ ಹೊವ್ನ್ ಜಾತಾ, ಅನಿ ಚೊರಾ ಘರಾ ಫೊಡುನ್ ಕಾಡುನ್ ಚೊರುನ್ ಘೆವ್ನ್ ಜಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ತಸೆಮನುನ್, ಸರ್‍ಗಾ ವರ್‍ತಿ ತುಮ್ಚೆ ಬದಿಕ್ ಗೊಳಾ ಕರುನ್ ಥವಾ, ಥೈ ವಾಳ್ಟಿ ಲಾಗಿನಾ ಅನಿ ಜಂಗ್‍ಲಾಗುನ್ ಹಾಳ್ ಹೊಯ್ನಾ, ಅನಿ ಚೊರಾನಿ ಫೊಡುನ್ ಕಾಡುನ್ ಚೊರುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ತುಮ್ಚೆ ಬದಿಕ್ ಖೈ ರ್‍ಹಾತಾ ಥೈಚ್ ತುಮ್ಚೊ ಮನ್‍ಬಿ ರ್‍ಹಾತಾ”. ");
INSERT INTO kans_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ಡೊಳೆ ಆಂಗಾಕ್ ದಿವೆ ಹೊತ್ತ್ಯಾ ಸರ್ಕೆ, ತುಮ್ಚೆ ಡೊಳೆ ಜರ್ ಬರೆ ಹಾತ್ ತರ್ ತುಮ್ಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಆಂಗ್‌ಬರ್ ಉಜ್ವೊಡ್ ರ್‍ಹಾತಾ; ");
INSERT INTO kans_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ಜರ್‍ಕಡತ್ ತುಮ್ಚೆ ಡೊಳೆ ಸಮಾ ನಾತ್ ತುಮ್ಚೆ ಆಂಗ್ ಕಾಳ್ಕಾತ್ ರ್‍ಹಾತಾ. ತೆಚೆಸಾಟ್ನಿ ತುಮ್ಚ್ಯಾ ಭುತ್ತುರ್‍ಲೊ ಉಜ್ವೊಡುಚ್ ಕಾಳೊಕ್ ಹೊಲೊ ತರ್ ತೊ ಕಾಳೊಕ್ ಕವ್ಡೊ ದಾಟ್ ರ್‍ಹಾತಾ ಅಸಿಲ್!” ");
INSERT INTO kans_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ಕೊನ್ಬಿ ಎಕ್ಲ್ಯಾನ್ ದೊನ್ ಧನಿಯಾಂಚಿ ಸೆವಾ ಕರುಕ್ ಹೊಯ್ನಾ; ತೊ ಎಕ್ಲ್ಯಾಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ಅನಿ ಅನಿಎಕ್ಲ್ಯಾಚೊ ರಾಗ್ ಕರ್‍ತಾ; ಎಕ್ಲ್ಯಾಚಿ ತೊ ಬರಿ ಕರುನ್ ಸೆವಾ ಕರ್‍ತಾ, ಅನಿ ಅನಿಎಕ್ಲ್ಯಾಚಿ ಬರಬ್ಬರ್ ಸೆವಾ ಕರಿನಾ. ತುಮಿ ದೆವಾಚಿ ಅನಿ ಪೈಸ್ಯಾಂಚಿ ದೊಗ್ಯಾಂಚಿಬಿ ಸೆವಾ ಕರುಕ್ ಹೊಯ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ತುಮಿ ಬಾಳ್ವಿ ಕರುಕ್ ಪೊಟಾಕ್ ಖಾತಲ್ಯಾ ಅನಿ ಫಿತಲ್ಯಾ ವಿಶಯಾತ್, ನಾಜಾಲ್ಯಾರ್ ಆಂಗಾರ್ ನೆಸ್ತಲ್ಯಾ ಕಪ್ಡ್ಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಯವ್ಜುನಕಾಶಿ, ಖಾತಲ್ಯಾಚ್ಯಾನ್ಕಿ ಜಿವ್ ಕವ್ಡ್ಯಾಕಿ ಕಿಮ್ತಿಚೊ ಹೊಯ್ ಕಾಯ್ ನ್ಹಯ್? ಅನಿ ಕಪ್ಡ್ಯಾಂಚ್ಯಾನ್ಕಿ ಆಂಗ್ ಕವ್ಡ್ಯಾಕಿ ಕಿಮ್ತಿಚೆ ಹೊಯ್ ಕಾಯ್ ನ್ಹಯ್? ");
INSERT INTO kans_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ಬಗಾ ತ್ಯಾ ಫಾಂಕ್ರಾಕ್ನಿ: ತೆನಿ ಭ್ಹಿಂಯ್ ಪೆರಿನ್ಯಾತ್, ನಾ ಪಿಕ್ಕ್ ಕಾತ್ರಿನಾತ್ ಪಿಕ್ಕ್ ಗೊಳಾ ಕರುನ್ ತಟ್ಟ್ಯಾತ್ನಿ ಥವ್ನ್ ಘೆಯ್‍ನ್ಯಾತ್; ಜಾಲ್ಯಾರ್‍ಬಿ ತುಮ್ಚೊ ಸರ್‍ಗಾ ವೈಲೊ ಬಾಬಾ ತೆಂಕಾ ಬಾಳಗ್ತಾ! ಫಾಕ್ರಾಂಚ್ಯಾನ್ಕಿ ಕವ್ಡೆಕಿ ಕಿಮ್ತಿಚೆ ತುಮಿ, ಹೊಯ್ ಕಾಯ್ ನ್ಹಯ್? ");
INSERT INTO kans_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ಕೊನ್ ತರ್ ಎಕ್ಲ್ಯಾನ್ ಯವ್ಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಜಿವನಾಚಿ ಅವ್ದಿ ಎಕ್ ಉಲ್ಲಿ ತರ್‍ಬಿ ಜಾಸ್ತಿ ಕರುನ್ ಘೆವ್ಕ್ ಹೊತಾ ಕಾಯ್?” ");
INSERT INTO kans_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ಅನಿ ಕಪ್ಡ್ಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ಕಶ್ಯಾಕ್ ಯವಜ್ತ್ಯಾಶಿ? ಬಗಾ ತಿ ಶೆತಾತ್ಲಿ ಫುಲ್ಲಾ ತಿ ಕಸೆ ಉಗಾವ್ತ್ಯಾತ್; ತಿ ಕಾಮ್ ಕರಿನ್ಯಾತ್, ನಾ ಅಪ್ನಾಸಾಟ್ನಿ ಕಪ್ಡೆ ತಯಾರ್ ಕರಿನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ: ಸಾಲ್ಮಾವ್ ರಾಜಾನ್ ಸೈತ್ ಅಪ್ನಾಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಸಾವ್ಕಾರ್‍ಕಿನ್ ಹ್ಯಾ ಫುಲ್ಲಾನಿತ್ಲ್ಯಾ ಎಕ್ ಫುಲ್ಲಾ ಸರ್ಕೆ ಸುಂದರ್ ದಿಸಿ ಸರ್ಕೆ ಕಪ್ಡೆ ನೆಸುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ಅನಿ ಆಜ್ ರ್‍ಹವ್ನ್ ಉದ್ದ್ಯಾ ನಾಪತ್ತೊ ಹೊವ್ನ್ ಜಾತಲ್ಯಾ, ಆಗಿತ್ ಘಾಲುನ್ ಜಾಳ್ವುನ್ ಟಾಕ್ತಲ್ಯಾ ಹ್ಯಾ ಡಂಗಳ್ ಗವ್ತಾಕ್ ಜರ್‍ಕಡತ್ ದೆವ್ ಎವ್ಡೆ ಬರೆ ಕರುನ್ ನೆಸ್ವುತಾ ತರ್ ತುಮ್ಕಾ ತೊ ಕವ್ಡೆ ಬರೆ ಕರುನ್ ನೆಸ್ವಿನಾ? ಕವ್ಡೊ ಕಮಿ ವಿಶ್ವಾಸ್ ತುಮ್ಕಾ ಹಾಯ್!” ");
INSERT INTO kans_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“ತೆಚೆಸಾಟ್ನಿ ಅಮಿ ಕಾಯ್ ಖಾತಲೆ? ಕಾಯ್ ಫಿತಲೆ? ಕಾಯ್ ನೆಸ್ತಲೆ? ಮನುನ್ ಯವ್ಜುನಕಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ಹೆ ಸಗ್ಳೆ ದೆವಾಕ್ ವಳ್ಕುನಸಲ್ಲಿ ಲೊಕಾ ಯವಜ್ತಲೆ. ಹೆ ಸಗ್ಳೆ ತುಮ್ಕಾ ಪಾಜೆ ಮನುನ್ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ತುಮ್ಚ್ಯಾ ಬಾಬಾಕ್ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ಅದ್ದಿ ತುಮಿ ದೆವಾಕ್ ಕಾಯ್ ಪಾಜೆ ತೆ ಕರಾ, ಅನಿ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾಚಿ ವಾಟ್ ಹುಡ್ಕಾ. ತನ್ನಾ ತುಮ್ಕಾ ಗರಜ್ ಹೊತ್ತೆ ಸಗ್ಳೆಬಿ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ತಸೆಮನುನ್ ಉದ್ದ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಯವ್ಜನ್ ಕರುನಕಾಸಿ, ಹರಿಎಕ್ ದಿಸಾಚಿ ಅಪ್ನಾಚಿಚ್ ಮಟಲ್ಲಿ ಕವ್ಡಿಕಿ ಕಸ್ಟಾ ಹಾತ್. ಉದ್ದ್ಯಾಚ್ಯಾ ದಿಸಾಕ್ ಮನುನ್ ಹೊತ್ತಿ ಯವ್ಜನ್ ಉದ್ದ್ಯಾಕ್ ಹಾಯ್”. ");
INSERT INTO kans_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ದುಸ್ರ್ಯಾಂಚಿ ನಿತ್ ಕರುನಕಾಸಿ, ತನ್ನಾ ತುಮ್ಚಿಬಿ ನಿತ್ ಕರುನ್ ಹೊತಾ, ");
INSERT INTO kans_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ದುಸ್ರ್ಯಾಕ್ನಿ ನ್ಯಾಯ್ ಕರುಕ್ ತುಮಿ ಖಲೊ ಮಾಪ್ ವಾಪರ್‍ತ್ಯಾಶಿ, ತೊಚ್ ಮಾಪ್ ದೆವ್ ತುಮ್ಚಿ ನ್ಯಾಯ್ ಕರ್‍ತಾನಾಬಿ ವಾಪರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ತುಜ್ಯಾ ಡೊಳ್ಯಾತ್ನಿ ಹೊತ್ತ್ಯಾ ನಾಕ್ಡಾಕ್ಡೆ ಧ್ಯಾನ್ ದಿತಲೆ ಸೊಡುನ್, ತುಜ್ಯಾ ಭಾವಾಚ್ಯಾ ಡೊಳ್ಯಾತ್ಲ್ಯಾ ಬಾರಿಕ್ಲ್ಯಾ ಕಚ್ರ್ಯಾಕ್ಡೆ ತಿಯಾ ಕಶ್ಯಾಕ್ ಬಗ್ತೆಯ್? ");
INSERT INTO kans_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ತುಜ್ಯಾ ಡೊಳ್ಯಾತ್ ನಾಕ್ಡಾಚೊ ತುಕ್ಡೊಚ್ ರ್‍ಹಾತಾನಾ, ತುಜ್ಯಾ ಭಾವಾಕ್ ತುಜ್ಯಾ ಡೊಳ್ಯಾತ್ಲೊ ಬಾರಿಕ್ಲೊ ಕಚ್ರೊ ಕಾಡ್ತಾ ಯೆ ಮನುನ್ ತಿಯಾ ಕಶೆ ಸಾಂಗುಕ್ ಹೊತಾ?” ");
INSERT INTO kans_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ಕುಸ್ಡ್ಯಾ! ಅದ್ದಿ ತುಜ್ಯಾ ಡೊಳ್ಯಾತ್ ಹೊತ್ತೊ ನಾಕ್ಡಾಚೊ ತುಕ್ಡೊ ಕಾಡುನ್ ಘೆ, ಮಾನಾ ತುಜ್ಯಾ ಭಾವಾಚ್ಯಾ ಡೊಳ್ಯಾತ್ಲೊ ಬಾರಿಕ್ಲೊ ಕಚ್ರೊ ತುಕಾ ಬರೊ ದಿಸ್ತಾ, ತನ್ನಾ ತಿಯಾ ತೊ ಕಾಡುಕ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ಜೆ ಕಾಯ್ ಪವಿತ್ರ್ ಹಾಯ್, ತೆ ಕುತ್ತ್ಯಾಂಚ್ಯಾ ಫಿಡ್ಯಾತ್ ದಿವ್‍ನಕಾಶಿ, ತಿ ಪರ್ತುನ್ ತುಮ್ಕಾ ಚಾವುಕ್ ಫಾಟ್ ಲಾಗ್ತ್ಯಾತ್, ತುಮ್ಚಿ ಮೊತಿಯಾ ಡುಕ್ರಾಂಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಟಾಕುನಕಾಶಿ. ತಿ ತೆಂಕಾ ಪಾಯಾತ್ನಿ ಘಾಲುನ್ ತುಡ್ವುತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ಮಾಗಾ ಅನಿ ತುಮಿ ಘೆತ್ಯಾಶಿ; ಹುಡ್ಕಾ ಅನಿ ತುಮ್ಕಾ ಗಾವ್ತಾ; ಬಡ್ವಾ ಅನಿ ತುಮ್ಕಾ ದಾರ್ ಉಗಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ಮಾಗ್ತಲೆ ಸಗ್ಳೆ ಜಾನಾ ಘೆತ್ಯಾತ್, ಜೊ ಕೊನ್ ಹುಡಕ್ತಾ ತೆಕಾ ಗಾವ್ತಾ, ಅನಿ ಜೆ ಕೊನ್ ದಾರ್ ಬಡ್ವುತಾ ತೆಕಾ ದಾರ್ ಉಗಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ತುಮ್ಚ್ಯಾ ಮದ್ಲೊ ಕೊನ್‍ ತರ್ ಎಕ್ಲೊ ಬಾಬಾ ತುಮ್ಚ್ಯಾ ಪೊರಾನ್ ಭಾಕ್ರಿ ಮಾಗ್ಲ್ಯಾರ್ ತೆಕಾ ಗುಂಡೊ ದಿಸಿಲಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ನಾಹೊಲ್ಯಾರ್ ಮಾಸೊಳಿ ಇಚಾರ್ಲ್ಯಾರ್ ಸಾಪ್ ದಿಸಿಲಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ತುಮಿ ಬುರ್ಶೆ ಹೊಲ್ಯಾರ್ಬಿ ತುಮ್ಚ್ಯಾ ಪೊರಾಕ್ನಿ ಬರೆ ಖಲೆ ಹಾಯ್ ತೆಚ್ ದಿತ್ಯಾಶಿ, ತರ್ ಸರ್‍ಗಾ ವೈಲೊ ತುಮ್ಚೊ ಬಾಬಾ ಅಪ್ನಾಕ್ಡೆ ಮಾಗಲ್ಲ್ಯಾಕ್ನಿ ಕವ್ಡೆ ಬರೆ ಬರೆ ದಿತಾ ಅಸಿಲ್!” ");
INSERT INTO kans_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“ದುಸ್ರ್ಯಾನಿ ತುಮ್ಕಾ ಕಶೆ ಕರುಚೆ ಮನುನ್ ತುಮಿ ಯವಜ್ತ್ಯಾಶಿ, ತಸೆಚ್ ತುಮಿಬಿ ದುಸ್ರ್ಯಾಕ್ನಿ ಕರಾ; ಮೊಯ್ಜೆನ್ ದಿಲ್ಲ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚೊ ಅನಿ ಪ್ರವಾದ್ಯಾನಿ ಶಿಕ್ವಲ್ಲ್ಯಾಚೊ ಅರ್ತ್‍ ಹ್ಯೊಚ್”. ");
INSERT INTO kans_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ಬಾರಿಕ್ಲ್ಯಾ ದಾರಾತ್ನಾ ಭುತ್ತುರ್ ಜಾಂವಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ನರ್ಕಾಕ್ ಜಾತಲೆ ದಾರ್ ಲೈ ರುಂದ್ ಥೈ ಜಾತಲೊ ರಸ್ತೊಬಿ ಲೈ ಸಸಾರಾಚೊ, ಅನಿ ಲೈ ಜಾನಾ ತ್ಯಾ ರಸ್ತ್ಯಾನ್ ಜಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ಖರೆ ಮರಾನ್ ನಸಲ್ಲ್ಯಾ ಜಿವನಾಕ್ ಜಾತಲೆ ದಾರ್ ಲೈ ಬಾರಿಕ್, ಅನಿ ತಿ ವಾಟ್ ಲೈ ತರಾಸಾಚಿ, ಅನಿ ಖಾಲಿ ಉಲ್ಲ್ಯಾಸ್ಯಾಚ್ ಲೊಕಾಕ್ನಿ ತಿ ವಾಟ್ ಗಾವ್ತಾ”. ");
INSERT INTO kans_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ಝುಟ್ಯಾ ಪ್ರವಾದ್ಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ; ತೆನಿ ಯೆತಾನಾ ಬಕ್ರ್ಯಾ ಸರ್ಕೆ ಸುದ್ದುಳೆ ದಿಸ್ತ್ಯಾತ್, ಖರೆ ಭುತ್ತುರ್ನಾ ತೆನಿ ಝುಲ್‍ ಕುತ್ರ್ಯಾ ಸರ್ಕೆ ರ್‍ಹಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ತೆನಿ ಚಲ್ತಲ್ಯಾ ಚಲ್ನುಕಾನಿಚ್ ತೆನಿ ಕೊನ್ ಮನುನ್ ತುಮ್ಕಾ ಕಳುನ್ ಯೆತಾ. ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಾಡಾಕ್ ದ್ರಾಕ್ಷಿಚಿ ಹನ್ನಾ ದಿವ್ಕ್ ಹೊಯ್ನಾ, ಅನಿ ಬುರ್‍ಲಾಚಿ ಝಾಡಾ ಅಂಜುರಾಚಿ ಹನ್ನಾ ದಿನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ಎಕ್ ಬರೆ ಝಾಡ್ ಬರಿಚ್ ಫಳಾ ದಿತಾ, ಎಕ್ ರೊಗೆಸಿ ಝಾಡ್ ಬರಿಲಿ ಫಳಾ ದಿ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ಎಕ್ ಬರ್‍ಯಾ ಝಾಡಾನ್ ಬುರ್ಶಿ ಫಳಾ ದಿವ್ಕ್ ಹೊಯ್ನಾ, ಅನಿ ಎಕ್ ರೊಗೆಸಿ ಝಾಡಾನ್ ಬರಿಲಿ ಫಳಾ ದಿವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ಅನಿ ಖಲೆ ಝಾಡ್ ಬರಿ ಫಳಾ ದಿ ನಾ, ತೆ ತೊಡುನ್ ಆಗಿತ್ ಘಾಲುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ತೆಚೆಸಾಟ್ನಿ ತೆಂಚ್ಯಾ ಚಲ್ನುಕಿ ವೈನಾಚ್ ತೆನಿ ಝುಟೆ ಪ್ರವಾದಿ ಮನುನ್ ತುಮಿ ವಳಕ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ಮಾಕಾ ಧನಿಯಾ, ಧನಿಯಾ ಮನುನ್ ಬಲ್ವುತಲೆ ಸಗ್ಳೆ ಜಾನಾ ಸರ್ಗಾಚ್ಯಾ ರಾಜಾತ್ ಭುತ್ತುರ್ ಜವ್ಕ್ ಹೊಯ್ನಾ, ಜೆ ಕೊನ್ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ಯವ್ಜನಿ ಸರ್ಕೆ ಹಾಯ್ ತೆಚ್ ಕರ್‍ತಾ ತೊ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾತ್ ಭುತ್ತುರ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ಝಡ್ತಿ ದಿತಲೊ ದಿಸ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಲೈ ಜಾನಾ, ಧನಿಯಾ, ಧನಿಯಾ, ತುಜ್ಯಾ ನಾವಾನ್ ಅಮಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲಾಂವ್, ತುಜ್ಯಾ ನಾವಾನ್ ಅಮಿ ಗಿರೆ ಕಾಡ್ಲಾಂವ್ ಅನಿ ಲೈ ಅಜಾಪಾ ಕರ್ಲಾಂವ್! ಮನುನ್ ಸಾಂಗ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ತನ್ನಾ ಮಿಯಾ ತೆಂಕಾ,ತುಮಿ ಕೊನ್ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ನಾ. ಬುರ್ಶ್ಯಾ ಲೊಕಾನು ಮಾಜೆಕ್ನಾ ಧುರ್ ಜಾವಾ! ಮನುನ್ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ಜೆ ಕೊನ್ ಹಿ ಮಾಜಿ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತಾ ಅನಿ ತೆಚ್ಯಾ ಸರ್ಕೆ ಚಲ್ತಾ ತೊ ಗುಂಡ್ಯಾ ವರ್‍ತಿ ಘರ್ ಭಾಂದ್ತಲ್ಯಾ ಎಕ್ ಶಾನ್ಯಾ ಮಾನ್ಸಾ ಸರ್ಕೊ. ");
INSERT INTO kans_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ಪವ್ಸ್ ವೊತ್ಲೊ, ನ್ಹಯ್ಯಾ ಭರುನ್ ವೊತ್ಲ್ಯಾ, ಮೊಟೊ ವಾರೊ ಉಟ್ಲೊ ಅನಿ ತ್ಯಾ ವಾರ್‍ಯಾನ್ ಘರಾಕ್ ಮಾರ್‍ಲ್ಯಾನ್. ಖರೆ ತೆ ಘರ್ ಕೊಸ್ಳುನ್ ಪಡುಕ್ನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆ ಘರ್ ಗುಂಡ್ಯಾ ವರ್‍ತಿ ಭಾಂದಲ್ಲೆ ಹೊತ್ತೆ”. ");
INSERT INTO kans_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ಖರೆ ಜೆ ಕೊನ್ ಹಿ ಮಾಜಿ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತಾ ಅನಿ ತೆಚೆ ಸರ್ಕೆ ಚಲಿನಾ ತೊ ರೆತಿ ವರ್‍ತಿ ಘರ್ ಭಾಂದ್ತಲ್ಯಾ ಎಕ್ ಪಿಶ್ಯಾ ಮಾನ್ಸಾ ಸರ್ಕೊ. ");
INSERT INTO kans_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ಪಾವ್ಸ್ ಯೆಲೊ, ನ್ಹಯ್ಯಾ ಭರುನ್ ವೊತ್ಲ್ಯಾ ಅನಿ ಮೊಟೊ ವಾರೊ ಉಟ್ಲೊ ಅನಿ ತ್ಯಾ ಘರಾಕ್ ಮಾರ್‍ಲ್ಯಾನ್, ಅನಿ ತೆ ಘರ್ ಕೊಸ್ಳುನ್ ಪಡುನ್ ಗೆಲೆ. ಕವ್ಡೆ ಭಯಾನಕ್ ಪಡ್ನೆ ಅಶಿಲ್ ಹೆ!” ");
INSERT INTO kans_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ಜೆಜುನ್ ಹೆ ಸಗ್ಳೆ ಸಾಂಗುನ್ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ ಲೊಕಾಂಚೆ ತಾಂಡೆ ತೆನಿ ಶಿಕ್ವುತಲಿ ರಿತ್ ಬಗುನ್ ಲೈ ಅಜಾಪ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ಮೊಯ್ಜೆಚಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾಂಚ್ಯಾ ಸರ್ಕೆ ಶಿಕ್ವಿನಶಿ, ಎಕ್ ಅದಿಕಾರ್ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾ ಸರ್ಕೆ ಶಿಕ್ವುಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ಜೆಜು ಮಡ್ಡಿ ವೈನಾ ಉತ್ರುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಲೊಕಾಂಚೆ ಮೊಟೆ-ಮೊಟೆ ತಾಂಡೆ ತೆಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ತನ್ನಾ ಕುಸ್ಟ್‌ ರೊಗ್‍ ಲಾಗಲ್ಲೊ ಎಕ್ ಮಾನುಸ್ ತೆಚೆಕ್ಡೆ ಯೆಲೊ ಅನಿ ಡೊಗ್ಲಾ ಟೆಕುನ್ “ಧನಿಯಾ, ತಿಯಾ ಮನ್ ಕರ್ಲ್ಯಾರ್, ಮಾಕಾ ಗುನ್ ಕರುಕ್ ಹೊತಾ”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ಜೆಜುನ್ ಅಪ್ನಾಚೊ ಹಾತ್ ಲಾಂಬ್ ಕರುನ್ ತೆಕಾ ಲಾವ್ಲ್ಯಾನ್, ಅನಿ, “ಮಾಕಾ ಮನ್ ಹಾಯ್, ತಿಯಾ ಪವಿತ್ರ್ ಹೊ”. ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೆಚೊ ರೊಗ್ ಗುನ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ, “ಹಿತ್ತೆ ಆಯ್ಕ್! ಹೆ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕೊ, ನಿಟ್ಟ್ ಯಾಜಕಾಕ್ಡೆ ಜಾ, ಅನಿ ತೊ ತುಕಾ ತಪಾಸುನ್ ಬಗುಂದಿ. ಅನಿ ಮಾನಾ ತಿಯಾ ಗುನ್ ಹೊಲೆ ಮನುನ್ ಸಗ್ಳ್ಯಾಕ್ನಿ ಕಳುಸಾಟ್ನಿ ಮೊಯ್ಜೆನ್ ಸಾಂಗಲ್ಲಿ ದೆನ್ಗಿ ದಿ”. ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ಜೆಜು ಕಪರ್‍ನವ್ ಮನ್ತಲ್ಲ್ಯಾ ಗಾಂವಾತ್ ಗುಸಲ್ಲ್ಯಾ ತನ್ನಾಚ್ ರೊಮಾಚ್ಯಾ ಸೆಂಬರ್ ಸೈನಿಕಾಂಚೊ ಎಕ್ ಅದಿಕಾರಿ ಜೆಜುಕ್ ಭೆಟ್ಲೊ, ಅನಿ ಮಜತ್ ಮಾಗುನ್ಗೆತ್, ");
INSERT INTO kans_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ಧನಿಯಾ, ಮಾಜೊ ಆಳ್ ವಾರ್‍ಯಾನ್‍ ಮಾರುನ್ ಹಾತ್ರಾನಾತ್ ಪಡ್ಲಾ, ತೊ ಲೈ ತರಾಸ್ ಕರುನ್ ಘೆವ್ಲಾ”. ಮನುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ,“ಮಿಯಾ ಯೆವ್ನ್ ತೆಕಾ ಬರೊ ಕರ್‍ತಾ”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ತನ್ನಾ ತ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಜೆಜುಕ್, “ಧನಿಯಾ, ತಿಯಾ ಮಾಜ್ಯಾ ಘರಾಕ್ ಯೆವ್ಕ್ ಮಿಯಾ ಯೊಗ್ಯ್ ನ್ಹಯ್, ತಿಯಾ ಹಿತ್ನಾಚ್ ಮಾಜೊ ಆಳ್ ಆರಾಮ್ ಹೊಂವ್ದಿ ಮನುನ್ ಸಾಂಗ್ ತೊ ಆರಾಮ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮಿಯಾಬಿ ಮಾಜ್ಯಾನ್ ಮೊಟ್ಯಾ ಅದಿಕಾರ್‍ಯಾಚ್ಯಾ ಹಾತಿ ಖಾಲ್ತಿ ಹಾಂವ್. ಅನಿ ಮಾಜ್ಯಾ ಹಾತಿ ಖಾಲ್ತಿಬಿ ಲೈ ಸೈನಿಕಾ ಹಾತ್. ಎಕ್ಲ್ಯಾಕ್ ಮಿಯಾ ಜಾ! ಮಟ್ಲ್ಯಾರ್ ತೊ ಜಾತಾ: ಅನಿ ಯೆ! ಮಟ್ಲ್ಯಾರ್ ಯೆತಾ, ಅನಿ ಮಾಜ್ಯಾ ಆಳಾಕ್ ಹೆ ಕರ್! ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾರ್ ತೊ ಕರ್‍ತಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ಹೆ ಆಯ್ಕುನ್ ಜೆಜುಕ್ ಅಜಿಪ್ ದಿಸ್ಲೆ, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಜೆಜುನ್ “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಇಸ್ರಾಯೆಲಾತ್ ಎವ್ಡೊ ಮೊಟೊ ವಿಶ್ವಾಸ್ ಹೊತ್ತೊ ಮಾನುಸ್ ಮಾಕಾ ಖೈಬಿ ಗಾವುಕ್ ನಾ”. ");
INSERT INTO kans_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ಮಿಯಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ದಿಸ್ ಉಗಾವ್ತಲ್ಯಾ ದಿಕ್ಕಾಕ್ನಾ ಅನಿ ದಿಸ್ ಬುಡ್ತಲ್ಯಾ ದಿಕ್ಕಾಕ್ನಾ ಲೈ ಲೊಕಾ ಯೆತ್ಯಾತ್ ಅನಿ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾತ್ ಅಬ್ರಾಹಾಮಾಚ್ಯಾ, ಇಸಾಕಾಚ್ಯಾ ಅನಿ ಜಾಕೊಬಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಸನಾಚ್ಯಾ ಜೆವ್ನಾಕ್ ಬಸ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ಖರೆ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ರ್‍ಹಾವ್ಕ್ ಮನುನ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಭಾಯ್ರ್ ಘಾಲುನ್ ಕಾಳ್ಕಾತ್ ಟಾಕುನ್ ಹೊತಾ, ಥೈ ತೆನಿ ಬೊಬ್ ಮಾರ್‍ತ್ಯಾತ್ ಅನಿ ಕಟ್‍ಕಟ್‍ ದಾತಾ ಚಾವ್ತ್ಯಾತ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ಮಾನಾ ಜೆಜುನ್ ತ್ಯಾ ಅದಿಕಾರ್‍ಯಾಕ್, “ತಿಯಾ ತುಜ್ಯಾ ಘರಾಕ್ ಜಾ, ಅನಿ ತಿಯಾ ವಿಶ್ವಾಸ್ ಕರಲ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊಲ್ಲೆ ರ್‍ಹಾತಾ”. ಮಟ್ಲ್ಯಾನ್. ಅನಿ ತನ್ನಾಚ್ ತ್ಯಾ ಅದಿಕಾರ್‍ಯಾಚೊ ಆಳ್ ಗುನ್ ಹೊಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ಮಾನಾ ಜೆಜು ಪೆದ್ರುಚ್ಯಾ ಘರಾಕ್ ಗೆಲೊ, ಥೈ ಪೆದ್ರುಚಿ ಮಾಮಿ ತಾಪ್ ಯೆವ್ನ್ ಹಾತ್ರಾನಾತ್ ನಿಜಲ್ಲೆ ಹೊತ್ತೆ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ತೆನಿ ತಿಚೊ ಹಾತ್ ಧರುನ್ ತಿಕಾ ಉಟ್ವುಲ್ಯಾನ್. ತನ್ನಾಚ್ ತಿಚೊ ತಾಪ್ ತಿಕಾ ಸೊಡುನ್ ಗೆಲೊ. ತಿ ಉಟ್ಲಿ ಅನಿ ಜೆಜುಚಿ ಚಾಕ್ರಿ ಕರುಕ್ಲಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ಸಾಂಜ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಲೊಕಾನಿ ಗಿರೆಲಾಗಲ್ಲ್ಯಾಕ್ನಿ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾನಿ ತೆಂಚೆ ಸಗ್ಳ್ಯಾಂಚೆ ಗಿರೆ ಭಾಯ್ರ್ ಕಾಡ್ಲ್ಯಾನ್, ಅನಿ ಸಿಕ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಆರಾಮ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾನ್, “ತೆನಿ ಅಮ್ಚಿ ದುಕ್ನಿ ಅಪ್ನಾಚ್ಯಾ ವರ್‍ತಿ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ಅಮ್ಚಿ ರೊಗಾ ಅಪ್ನಾ ವರ್‍ತಿ ವಾವುನ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್.” ಮನುನ್ ಸಾಂಗಟಲ್ಲೆ ಪುರಾ ಹೊವ್‍ಸಾಟ್ನಿ ತೆನಿ ಅಶೆ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ಅಪ್ನಾಚ್ಯಾ ಭೊತ್ಯಾನಿ ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಬಗುನ್, ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಜಾವಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ತನ್ನಾ ಎಕ್ಲೊ ಮೊಯ್ಜೆಚಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲೊ ತೆಚ್ಯೆಕ್ಡೆ ಯೆಲೊ, ಅನಿ, “ಗುರುಜಿ. ತಿಯಾ ಖೈ-ಖೈ ಜಾತೆ ಥೈ ಥೈ ಮಿಯಾ ತುಜ್ಯಾ ಫಾಟ್ನಾ ಯೆವ್ಕ್ ತಯಾರ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ, “ಕೊಲ್ಯಾಕ್ನಿ ಢುರೆ ಹಾತ್ ಮಳ್ಬಾ ವೈಲ್ಯಾ ಫಾಂಕ್ರಾಕ್ನಿ ಘಂಟೆ ಹಾತ್, ಖರೆ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮನುನ್ ಬಲ್ವುತಲ್ಯಾ ಮಾಕಾ ಟಕ್ಲೆ ಟೆಕುಕ್ ಸೈತ್ ಜಾಗೊ ನಾ”. ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ಅನಿ ಎಕ್ಲೊ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ ಮಾನುಸ್, “ಧನಿಯಾ, ಘರಾಕ್ ಜಾವ್ನ್ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ ಮಾಟಿ ದಿವ್ನ್ ಯೆವ್ಕ್ ಮಾಕಾ ಪುರ್ಸತ್ ದಿ”. ಮನುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ತೆಕಾ ಜೆಜುನ್, “ಮರಲ್ಲೆಚ್ ಮರಲ್ಲ್ಯಾಕ್ನಿ ಮಾಟಿ ದಿಂವ್ದಿತ್, ತಿಯಾ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆ”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ ಢೊನಿತ್ನಾ ಜಾವ್‍ಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ತನ್ನಾ ಎಗ್ದಮ್ ಸಮುಂದಾರಾತ್ ಮೊಟೊ ವಾರೊ ಪವ್ಸ್ ಉಟ್ಲೊ. ಢೊನ್ ಹಾಲುನ್- ಹಾಲುನ್ ಬುಡುಕ್ ಯೆಲ್ಲಿ. ಖರೆ ಜೆಜು ನಿಜಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ಶಿಸಾ ಜೆಜುಕ್ಡೆ ಗೆಲಿ, ಅನಿ ತೆಕಾ ಉಟ್ವುನ್, “ಧನಿಯಾ, ಅಮ್ಕಾ ಹುರ್‍ವುನ್ ಘೆ! ಅಮಿ ಬುಡುನ್ ಮರ್‍ತಾವ್!” ಮನುನ್ ಸಾಂಗುಕ್‍ಲಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ತುಮಿ ಎವ್ಡೆ ಲೈ ಕಶ್ಯಾಕ್ ಭಿಂವ್ಲ್ಯಾಶಿ? ಕವ್ಡೊ ಕಮಿ ವಿಶ್ವಾಸ್ ತುಮ್ಚೊ!” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೊ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾಲೊ ಅನಿ ವಾರ್ಯಾಕ್ ಅನಿ ಲ್ಹಾಟಾಕ್ನಿ ಗಪ್ ರ್‍ಹಾವಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್, ತನ್ನಾ ಸಗ್ಳೆ ಎಗ್ದಮ್ ಶಾಂತ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ತೆನಿ ಸಗ್ಳೆ ಜಾನಾ ಅಜಾಪ್ ಹೊಲೆ, ಅನಿ, “ಹ್ಯೊ ಕಸ್ಲೊ ಮಾನುಸ್ ಅಸಿಲ್? ವಾರೊ ಅನಿ ಲ್ಹಾಟಾ ಸೈತ್ ಹೆಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತ್ಯಾತ್!” ಮನುನ್ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ಜೆಜು ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ಬಾಜುನ್ ಗೆದರಾ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಯವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ಲೊಕಾಕ್ನಿ ಮಾಟಿ ದಿತಲ್ಯಾ ಸಮಾದ್ಯಾನಿತ್ನಾ ದೊಗೆ ಜಾನಾ ಗಿರೆಲಾಗಲ್ಲಿ ಮಾನ್ಸಾ ಭಾಯ್ರ್ ಯೆವ್ನ್ ತೆಕಾ ಭೆಟ್ಲಿ. ತೆನಿ ಲೈ ಭಯನಾಕ್ ಹೊತ್ತ್ಯಾನಿ, ತಸೆಮನುನ್ ಕೊನ್‍ಬಿ ತ್ಯಾ ವಾಟೆನ್ ಫಿರುನ್ ಖೆಳಿನಸಿತ್. ");
INSERT INTO kans_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ತೆನಿ ಎಗ್ದಮ್, “ದೆವಾಚ್ಯಾ ಲೆಕಾ ಅಮ್ಚ್ಯಾಕ್ನಾ ತುಕಾ ಕಾಯ್‍ ಪಾಜೆ? ಅಮ್ಚೊ ಎಳ್ ಯೆವ್ಚ್ಯಾ ಅದ್ದಿಚ್ ಅಮ್ಕಾ ಶಿಕ್ಷಾ ದಿವ್ಕ್ ಯೆಲೆ ಕಾಯ್?” ಮನುನ್ ಕಿಂಚ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ಥೈ ಉಲ್ಲೆಸೆ ಧುರ್ ಎಕ್ ಡುಕ್ರಾಂಚೊ ಮೊಟೊ ಹಿಂಡ್ ಚರುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ತ್ಯಾ ಗಿರ್‍ಯಾನಿ ಜೆಜುಕ್, “ತಿಯಾ ಅಮ್ಕಾ ಭಾಯ್ರ್ ಕಾಡುಕ್ ಯೆಲೆ ಜಾಲ್ಯಾರ್, ತ್ಯಾ ಡುಕ್ರಾತ್ನಿ ಅಮ್ಕಾ ಧಾಡುನ್ ದಿ.” ಮನುನ್ ಮಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ಜೆಜುನ್ ತೆಂಕಾ, “ಜಾವಾ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆ ಗಿರೆ ಜಾವ್ನ್ ತ್ಯಾ ಡುಕ್ರಾಂಚ್ಯಾ ಹಿಂಡಾತ್ ಗುಸ್ಲೆ ತನ್ನಾ ತೊ ಡುಕ್ರಾಂಚೊ ಸಗ್ಳೊ ಹಿಂಡ್ ಮಡ್ಡಿ ವೈನಾ ಸಮುಂದರಾತ್ ಹುಡಿ ಮಾರುನ್ ಬುಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ತನ್ನಾ ತ್ಯಾ ಡುಕ್ರಾಕ್ನಿ ರಾಕುಲಾಗಲ್ಲಿ ಲೊಕಾ ಶಾರಾತ್ನಿ ಪಳುನ್ ಗೆಲಿ ಅನಿ ತ್ಯಾ ಗಿರೆಲಾಗಲ್ಲ್ಯಾಕ್ನಿ ಕಾಯ್-ಕಾಯ್ ಹೊಲೆ ತಿ ಸಗ್ಳಿ ಕಾನಿ ಲೊಕಾಕ್ನಿ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ತನ್ನಾ ಶಾರಾತ್ಲೆ ಸಗ್ಳೆ ಜಾನಾ ಜೆಜುಕ್ಡೆ ಯೆಲ್ಯಾನಿ. ಅನಿ ತೆಕಾ ಭೆಟುನ್ ತೆನಿ ತೆಂಚೆ ಪ್ರಾಂತ್ಯ್ ಸೊಡುನ್ ಜಾವ್ಚೆ ಮನುನ್ ತೆಚ್ಯಾಕ್ಡೆ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ಜೆಜು ಢೊನಿತ್ ಚಡ್ಲೊ ಅನಿ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ಬಾಜುಕ್ ಅಪ್ನಾಚ್ಯಾ ಸ್ವಂತ್ ಶಾರಾಕ್ ಪರ್ತುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ತನ್ನಾ ಉಲ್ಲ್ಯಾ ಮಾನ್ಸಾನಿ ಎಕ್ಲ್ಯಾ ವಾರ್‍ಯಾನ್‍ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಹಾತ್ರಾನಾ ಸಮೆತ್ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ತೆಂಚೊ ವಿಶ್ವಾಸ್ ಬಗುನ್ ಜೆಜುನ್ ತ್ಯಾ ವಾರ್‍ಯಾನ್‍ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್, “ಮಾಜ್ಯಾ ಪೊರಾ! ಧೈರೊ ಘೆ! ತುಜಿ ಸಗ್ಳೆ ಪಾಪ್ ಮಾಪ್ ಹೊಲೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ಉಲ್ಲೆ ಮೊಯ್ಜೆಚಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲೆ ಥೈ ಹೊತ್ತೆ. ತೆನಿ “ಹ್ಯೊ ಮಾನುಸ್ ದೆವಾಚಿ ನಿಂದ್ಯಾ ಕರುಕ್ ಲಾಗ್ಲಾ”. ಮನುನ್ ಅಪ್ನಾಚ್ಯಾ ಮದ್ದಿ ಬೊಲುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ಜೆಜುನ್ ತೆನಿ ಕಾಯ್ ಯವ್ಜುಕ್ ಲಾಗ್ಲ್ಯಾತ್ ಮನುನ್ ಕಳ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ತೆನಿ ತೆಂಕಾ, “ತುಮಿ ತುಮ್ಚ್ಯಾ ಮನಾತ್ನಿ ಅಶೆ ಚುಕ್ ಕಶ್ಯಾಕ್ ಯೌಜುಲ್ಯಾಸಿ?” ");
INSERT INTO kans_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“ತುಜೆ ಪಾಪ್ ಮಾಪ್ ಹೊಲೆ; ಮನ್ತಲೆ ಸಸಾರ್ ಕಾಯ್? ಉಟ್ ಅನಿ ಚಲ್ ಮನ್ತಲೆ ಸಸಾರ್!” ");
INSERT INTO kans_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ತಸೆಜಾಲ್ಯಾರ್ ಹ್ಯಾ ಜಗಾತ್ ಪಾಪ್ ಮಾಪ್ ಕರ್‍ತಲೊ ಅದಿಕಾರ್ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಹಾಯ್ ಮನ್ತಲೆ ಖರೆ ಕರುನ್ ಮಿಯಾ ತುಮ್ಕಾ ದಾಕ್ವುನ್ ದಿತಾ ಮನುನ್ ಸಾಂಗುನ್, ತ್ಯಾ ವಾರ್‍ಯಾನ್‍ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್, “ವೈರ್ ಉಟ್, ತುಜೆ ಹಾತ್ರಾನ್ ಘೆ, ಅನಿ ತುಜ್ಯಾ ಘರಾಕ್ ಚಲ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ತನ್ನಾ ತೊ ಮಾನುಸ್ ಉಟ್ಲೊ ಅನಿ ಘರಾಕ್ ಗೆಲೊ, ");
INSERT INTO kans_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ಹೆ ಬಗಟಲ್ಲಿ ಲೊಕಾ ಭಿಂಯಾಲಿ, ಅನಿ ಅಸ್ಲೊ ಅದಿಕಾರ್ ದೆವಾನ್ ಮಾನ್ಸಾಕ್ ದಿಲ್ಲ್ಯಾಸಾಟ್ನಿ ದೆವಾಕ್ ಹೊಗಳ್ಳ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್ ಚಲುನ್ಗೆತ್ ಜಾತಾನಾ, ತೆರ್‍ಗಿ ವಸುಲಿ ಕರುಕ್ ಅಪ್ನಾಚ್ಯಾ ಜಾಗ್ಯಾರ್ ಬಸಲ್ಲ್ಯಾ ಮಾತೆವ್ ಮನ್ತಲ್ಯಾ ತೆರ್‍ಗಿ ವಸುಲಿ ಕರ್‍ತಲ್ಯಾಕ್ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್, ಜೆಜುನ್ ತೆಕಾ “ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಮಾತೆವ್ ಉಟ್ಲೊ ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ಜೆಜು ಮಾತೆವಾಚ್ಯಾ ಘರಾತ್ ಜೆವಾನ್ ಕರ್‍ತಾನಾ, ಲೈ ತೆರ್‍ಗಿ ವಸುಲಿ ಕರ್‍ತಲಿ ಲೊಕಾ, ಅನಿ ಪಾಪಿ ಲೊಕಾಬಿ ಜೆಜು ಅನಿ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವ್ನಾಚ್ಯಾ ಪಂಗ್ತಿರ್ ಬಸಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ತನ್ನಾ ಉಲ್ಲ್ಯಾ ಫಾರಿಜೆವಾನಿ ಜೆಜುಚ್ಯಾ ಶಿಸಾಕ್ನಿ, “ತುಮ್ಚೊ ಗುರುಜಿ; ಪಾಪಿ ಅನಿ ತೆರ್‍ಗಿ ವಸುಲಿ ಕರ್‍ತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಸುನ್ ಕಶ್ಯಾಕ್ ಜೆವ್ತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ಜೆಜುನ್ ತೆನಿ ಇಚಾರ್‍ತಲೆ ಆಯಿಕ್ಲ್ಯಾನ್, ಅನಿ ತೆಂಕಾ “ಅರಾಮ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ವಗ್ದುಳ್ಯಾಚಿ ಗರಜ್ ನಾ. ಜೆ ಕೊನ್ ಶಿಕ್ ಹಾತ್ ತೆಂಕಾ ಎವ್ಡಿಚ್ ವಗ್ದುಳ್ಯಾಚಿ ಗರಜ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ಜಾವಾ, ಅನಿ ಪವಿತ್ರ್ ಪುಸ್ತಕ್, ಮಾಕಾ ದಯಾ ಪಾಜೆ, ಜನಾವರಾಂಚಿ ಬಲಿ ನಕ್ಕೊ ಮನುನ್ ಸಾಂಗಲ್ಲ್ಯಾಚೊ ಅರ್ತ್‍ ಕಾಯ್ ಮನುನ್ ಹುಡ್ಕುನ್‍ ಕಾಡಾ. ಮಿಯಾ ಧರ್ಮಾನಿ ಚಲ್ತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಯೆವ್ಕ್ ನಾ, ಪಾಪಿ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಯೆಲಾ”. ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ತನ್ನಾ ಜುವಾಂವ್ ಬಾವ್ತಿಸಾಚಿ ಶಿಸಾ ಜೆಜುಕ್ಡೆ ಯೆಲಿ, ಅನಿ ಜೆಜುಕ್, “ಅಮಿ ಅನಿ ಫಾರಿಜೆವಾ ತನ್ನಾ-ತನ್ನಾ ಉಪಾಸ್ ಕರ್‍ತಾವ್, ಖರೆ ತುಜಿ ಶಿಸಾ ಉಪಾಸ್ ಕರಿನ್ಯಾತ್ ಕಶ್ಯಾಕ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ಲಗ್ನಾಚೊ ನ್ಹವ್ರೊ ವಾಂಗ್ಡಾ ರ್‍ಹಾತಾನಾ, ಲಗ್ನಾಕ್ ಯೆಲ್ಲ್ಯಾ ಸೊಯ್ರ್ಯಾನಿ ಬೆಜಾರಾತ್ ರ್‍ಹಾವ್ಕ್ ಹೊತಾ ಕಾಯ್? ನಾ, ಹೊಯ್ನಾ! ಖರೆ ತೆಂಚ್ಯಾ ಮದ್ನಾ ನ್ಹವ್ರ್ಯಾಕ್ ಕಾಡುನ್ ಘೆವ್ನ್ ಜಾತಲೊ ಎಳ್ ಯೆತಾ, ತನ್ನಾ ತೆನಿ ಉಪಾಸ್ ಕರ್‍ತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ಕೊನ್‍ಬಿ ಪಿಂಜಲ್ಲ್ಯಾ ಜುನ್ನ್ಯಾ ಅಂಗಿಕ್ ನ್ಹವ್ಯಾ ಫಾಳಿಚೊ ತುಕ್ಡೊ ಲಾವುನ್ ಶಿವಿನಾ, ತೊ ನ್ಹವೊ ಫಾಳಿಚೊ ತುಕ್ಡೊ ಮುದ್ದೊ ಹೊತಾ, ಅನಿ ತಿ, ಪಿಂಜಲ್ಲಿ ಅಂಗಿ ಅನಿ ಉಲ್ಲಿ ಜಾಸ್ತಿಚಿ ಪಿಂಜ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ನಾಹೊಲ್ಯಾರ್ ಕೊನ್‍ಬಿ ನ್ಹವೊ ವಾಯ್ನ್ ಜುನ್ನ್ಯಾ ಚಮ್ಡ್ಯಾಚ್ಯಾ ಪಿಸ್ವಿಯಾತ್ನಿ ವೊತಿನಾ. ತಸೆ ಕರ್ಲ್ಯಾರ್, ತಿ ಚಮ್ಡ್ಯಾಚಿ ಪಿಸ್ವಿ ಫುಟ್ತಾ, ಅನಿ ವಾಯ್ನ್ ಗಳುನ್ ಪಡುನ್ ಹಾಳ್ ಹೊತಾ. ಚಮ್ಡ್ಯಾಚ್ಯಾ ಪಿಸ್ವಿಯಾಬಿ ಹಾಳ್ ಹೊತ್ಯಾತ್. ನ್ಹವಿ ವಾಯ್ನ್ ನ್ಹವ್ಯಾ ಚಮ್ಡ್ಯಾಚ್ಯಾ ಪಿಸ್ವಿಯಾತ್ನಿ ಭರ್‍ತ್ಯಾತ್, ತನ್ನಾ ಪಿಸ್ವಿಬಿ ವಾಯ್ನ್ ಬಿ ಹಾಳ್ ಹೊಯ್‍ನಸ್ತಾನಾ ಬರೆಚ್ ರ್‍ಹಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ಜೆಜು, ಹೆ ಸಾಂಗುನ್ಗೆತುಚ್ ಹೊತ್ತೊ, ತನ್ನಾ ಎಕ್ ಜುದೆವಾಂಚೊ ಅದಿಕಾರಿ ಜೆಜುಕ್ಡೆ ಯೆಲೊ, ಅನಿ ಡೊಗ್ಲಾ ಘಾಲುನ್ ಜೆಜುಕ್, “ ಮಾಜಿ ಲೆಕ್ ಅತ್ತಾ-ಅತ್ತಾಚ್ ಮರ್ಲಿ. ಖರೆ ತಿಯಾ ಯೆವ್ನ್ ತಿಚೆ ವರ್‍ತಿ ಹಾತ್ ಥವ್ ತಿ ಹುರ್ತಾ”. ಮನುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ತನ್ನಾ ಜೆಜು ಉಟ್ಲೊ, ಅನಿ ತೆಚ್ಯಾ ಫಾಟ್ನಾ ಜಾವ್ಕಲಾಲೊ, ಅನಿ ಶಿಸಾಬಿ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ಬಾರಾ ವರ್ಸಾಕ್ನಾ ರಗಾತ್ ಜಾತಲೊ ರೊಗ್ ಹೊತ್ತಿ ಎಕ್ ಬಾಯ್ಕೊಮನುಸ್ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಯೆಲಿ ಅನಿ ತೆನಿ ತೆಚ್ಯಾ ಕಪ್ಡ್ಯಾಂಚ್ಯಾ ತುದಿಚ್ಯಾ ಘೊಂಡ್ಯಾಕ್ ಅಪಡ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ತೆನಿ “ಮಿಯಾ ಖಾಲಿ ಜೆಜುಚ್ಯಾ ಕಪ್ಡ್ಯಾಕ್ನಿ ಹಾತ್ ಲಾವ್ಲ್ಯಾರ್ ಫಿರೆ, ಮಿಯಾ ಅರಾಮ್ ಹೊತಾ” ಮನುನ್ ಘೆಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ಜೆಜುನ್ ಫಾಟಿ ಪರ್ತುನ್ ತಿಕಾ ಬಗಟ್ಲ್ಯಾನ್ ಅನಿ, “ಮಾಜ್ಯಾ ಲೆಕಿ, ಧೈರೊ ಘೆ! ತುಜ್ಯಾ ವಿಶ್ವಾಸಾನ್ ತಿಯಾ ಬರಿ ಹೊಲೆ”. ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತಿಚೊ ರೊಗ್ ಅರಾಮ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ಮಾನಾ ಜೆಜು ಅದಿಕಾರ್‍ಯಾಚ್ಯಾ ಘರಾತ್ ಗೆಲೊ, ಅನಿ ಮರ್‍ನಾಚ್ಯಾ ಎಳಾರ್ ವಾಜ್ಪಾ ವಾಜ್ವುತಲೆ, ಅನಿ ಧಾಂದಲ್ ಕರ್‍ತಲ್ಯಾ ಲೊಕಾಕ್ನಿ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ತನ್ನಾ ಜೆಜುನ್,“ಸಗ್ಳೆ ಜಾನಾ ಭಾಯ್ರ್ ಪಡಾ ತೆ ಚೆಡು ಮರುಕ್‍ ನಾ, ತಿ ನಿಜ್ಲಾ!” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ಸಗ್ಳ್ಯಾನಿ ಜೆಜುಕ್ ಹಾಸ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ಖರೆ ಲೊಕಾಕ್ನಿ ಭಾಯ್ರ್ ಧಾಡುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜು ತ್ಯಾ ಚೆಡ್ವಾಚ್ಯಾ ಖೊಲಿತ್ ಗೆಲೊ, ಅನಿ ತೆನಿ ತ್ಯಾ ಚೆಡ್ವಾಚೊ ಹಾತ್ ಧರ್‍ಲ್ಯಾನ್, ಅನಿ ತೆ ಚೆಡು ಉಟ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ಹಿ ಖಬರ್ ತ್ಯಾ ದೆಸಾತ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಜಾವ್ನ್ ಪಾವ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್ ಚಲುನ್ಗೆತ್ ಜಾತಾನಾ, ದೊಗೆ ಜಾನಾ ಕುಡ್ಡೆ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಯೆವ್ನಗೆತ್ “ಜೆಜು, ದಾವಿದಾಚ್ಯಾ ಲೆಕಾ ಅಮ್ಚಿ ದಯಾ ಕರ್” ಮನುನ್ ಬೊಬ್ ಮಾರುಕ್‍ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ಜೆಜು ಥೈ ಘರಾತ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ದೊಗೆಬಿ ಕುಡ್ಡೆ ಜೆಜುಕ್ಡೆ ಯೆಲೆ. ಜೆಜುನ್ ತೆಂಕಾ, “ಮಿಯಾ ತುಮ್ಕಾ ದಿಸ್ಟ್ ದಿವ್ಕ್ ಹೊತಾ ಮನುನ್ ತುಮ್ಕಾ ವಿಶ್ವಾಸ್ ಹಾಯ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ “ಹೊಯ್ ಧನಿಯಾ,” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಚ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ಹಾತ್ ಲಾವ್ಲ್ಯಾನ್, ಅನಿ “ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಲ್ಲ್ಯಾ ಸರ್ಕೆ ತುಮ್ಕಾ ಹೊಂವ್ದಿತ್”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೆಂಚ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ದಿಸ್ಟ್ ಯೆಲಿ. ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ಹೆ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕಾಸಿ!” ಮನುನ್ ತಾಕಿತ್ ದಿವ್ನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ಖರೆ ತೆನಿ ಜಾವ್ನ್ ತ್ಯಾ ದೆಶಾತ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ಲಿ ಖಬರ್ ಮಾಳ್ಬರ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ತಿ ಡೊಳ್ಯಾಂಚಿ ದಿಸ್ಟ್ ಯೆಲ್ಲಿ ಮಾನ್ಸಾ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಎಕ್ ಮುಕ್ಕ್ಯಾ ಮಾನ್ಸಾಕ್ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ, ತೆಕಾ ಗಿರೊಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ಖರೆ ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ ತ್ಯಾ ಮಾನ್ಸಾತ್ನಾ ಕಾಡಲ್ಲ್ಯಾ ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೊ ಮುಕ್ಕೊ ಬೊಲುಕ್‍ಲಾಲೊ, ಅನಿ ಸಗ್ಳೆ ಜಾನಾ ಅಜಾಪ್ ಹೊಲ್ಯಾನಿ. ತೆನಿ “ಅಮಿ ಅಸ್ಲೆ ಕಾಯ್ಬಿ ಕನ್ನಾಬಿ ಇಸ್ರಾಯೆಲಾತ್ ಬಗುಕ್ನಾವ್!” ಮನುನ್ ತೆನಿ ಬೊಲುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ಖರೆ ಫಾರಿಜೆವಾನಿ, ಗಿರ್‍ಯಾಂಚೊ ಮುಖಂಡ್, ಜೆಜುಕ್ ಗಿರೆ ಭಾಯ್ರ್ ಕಾಡ್ತಲೊ ಬಳ್ ದಿತಾ ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ಜೆಜು ಸಗ್ಳ್ಯಾ ಶಾರಾತ್ನಿ ಅನಿ ಗಾಂವಾತ್ನಿ ಗೆಲೊ, ಸಿನಾಗೊಗಾತ್ನಿ ತೆನಿ ಶಿಕ್ವುಲ್ಯಾನ್ ಅನಿ ದೆವಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನ್, ಅನಿ ಸಗ್ಳ್ಯಾ ಸಿಕ್ ಲೊಕಾಕ್ನಿ, ಅನಿ ದುಕ್ನಿಲಾಗಲ್ಲ್ಯಾಕ್ನಿ ಅರಾಮ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ಖರೆ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ನಿ ಬಗುನ್, ಜೆಜುಕ್ ತೆಂಚೊ ಪಾಪ್ ದಿಸ್ಲೊ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತಿ ಲೊಕಾ ಬೆಜಾರಾನ್ ಅನಿ ಕಾಯ್ಬಿ ಅದಾರ್ ‍ನಸ್ತಾನಾ ರಾಕ್ವಾಲಿನಸಲ್ಲ್ಯಾ ಬಕ್ರ್ಯಾಂಚ್ಯಾ ಸರ್ಕೆ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ತಸೆಮನುನ್, ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ, ಪಾಜೆ ತವ್ಡೆ ಪಿಕ್ಕ್ ಯೆಲಾ, ಖರೆ ಕಾಮ್ ಕರ್‍ತಲಿ ಲೊಕಾ ಲೈ ಕಮಿ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ತೆಚೆಸಾಟ್ನಿ, ಪಿಕ್ಕಾಚ್ಯಾ ಮಾಲ್ಕಾ ದೆವಾಕ್ಡೆ ತುಜೆ ಪಿಕ್ಕ್ ಭುತ್ತುರ್ ಘಾಲುಕ್ ಕಾಮಾಚಿ ಲೊಕಾ ಧಾಡುನ್ ದಿ ಮನುನ್ ಮಾಗ್ನಿ ಕರಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಬಾರಾ ಶಿಸಾಕ್ನಿ ಎಕಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್, ಅನಿ ತೆಂಕಾ ಗಿರೆ ಕಾಡ್ತಲೊ, ಅನಿ ಸಗ್ಳಿ ರೊಗಾ, ಅನಿ ದುಕ್ನಿ ಅರಾಮ್ ಕರ್‍ತಲೊ ಅದಿಕಾರ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ಬಾರಾ ಜಾನಾ ಅಪೊಸ್ತಲಾಂಚಿ ನಾವಾ ಹಿ, ಸಿಮಾವ್ ಹೆಕಾ ಪೆದ್ರು ಮನ್ತ್ಯಾತ್, ಅನಿ ತೆಚೊ ಭಾವ್ ಅಂದ್ರು, ಜಾಕೊಬ್, ಅನಿ ತೆಚೊ ಭಾವ್ ಜುವಾಂವ್ ಹೆನಿ ಜೆಬೆದೆವಾಚಿ ಪೊರಾ; ");
INSERT INTO kans_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ಫಿಲಿಪ್, ಅನಿ ಬಾರ್‍ತೊಲೊಮೆವ್; ಥೊಮಸ್, ಅನಿ ತೆರ್‍ಗಿ ವಸುಲ್ ಮಾತೆವ್, ಅಲ್ಫೆವಾಚೊ ಲೆಕ್ ಜಾಕೊಬ್,ತಾದ್ದೆವ್, ");
INSERT INTO kans_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ದೆಸ್‍ಭಕ್ತ್ ಸಿಮಾವ್; ಅನಿ ಜೆಜುಕ್ ಘಾತ್‍ ಕರಲ್ಲೊ ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತ್. ");
INSERT INTO kans_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ಹ್ಯಾ ಬಾರಾ ಜಾನಾ ಶಿಸಾಕ್ನಿ ಜೆಜುನ್ ಸುಚ್ನಾ ದಿವ್ನ್, “ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ನಾಹೊಲ್ಯಾರ್ ಸಮಾರಿಯಾಚ್ಯಾ ಗಾಂವಾತ್ನಿ ಜಾವ್‍ನಕಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ತುಮಿ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾನಿಕ್ನಿ ಜಾವಾ, ತೆನಿ ಚುಕುನ್ ಗೆಲ್ಲ್ಯಾ ಬಕ್ರ್ಯಾಂಚ್ಯಾ ಸರ್ಕೆ ಹಾತ್, ");
INSERT INTO kans_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ಜಾಂವಾ, ಅನಿ ಸರ್ಗಾಚೊ ರಾಜ್ ಜಗ್ಗೊಳ್ ಯೆಲಾ!” ಮನುನ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಸಾಂಗಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ಶಿಕ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಬರೆ ಕರಾ, ಮರಲ್ಲ್ಯಾಕ್ನಿ ಝಿತ್ತೆ ಕರಾ, ಕುಸ್ಟ್‌ ರೊಗ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಗುನ್ ಕರಾ, ಅನಿ ಗಿರೆ ಭಾಯ್ರ್ ಕಾಡಾ, ತುಮ್ಕಾ ಫುಕೊಟ್ ಗಾವ್ಲಾ, ತಸೆಮನುನ್ ತುಮಿಬಿ ಫುಕೊಟ್ ದಿವಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ತುಮ್ಚ್ಯಾ ಕಿಶ್ಯಾತ್ನಿ ಸೊನ್ಯಾಚೆ, ಚಾಂದಿಚೆ, ನಾಹೊಲ್ಯಾರ್ ತಾಂಬ್ಯಾಚೆ ಪೈಸೆ ಘೆವ್‍ನಕಾಶಿ; ");
INSERT INTO kans_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ವಾಟೆಕ್ ಮನುನ್ ಪಿಸ್ವಿ ಹೊಂವ್ದಿತ್, ನಾಹೊಲ್ಯಾರ್ ಜಾಸ್ತಿಚಿ ಅಂಗಿ ನಾಹೊಲ್ಯಾರ್ ಹೊನಾಯಾ ನಾಹೊಲ್ಯಾರ್ ದಾಂಡೊ ಘೆವ್‍ನಕಾಶಿ. ಕಾಮ್‍ಕಾರಾಕ್ ತೆಕಾ ಪಾಜೆ ಹೊಲ್ಲಿ ಮಜುರಿ ದಿವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ಎಕ್ ಶಾರಾಕ್ ನಾಜಾಲ್ಯಾರ್ ಗಾಂವಾತ್ ತುಮಿ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮ್ಕಾ ಕೊನ್‍ ತರ್ ಅಪ್ನಾಚ್ಯಾ ಘರಾತ್ ಸ್ವಾಗತ್ ಕರ್‍ತಾ ಕಾಯ್ ಬಗಾ, ಅನಿ ತೆ ಗಾಂವ್ ಸೊಡುನ್ ಜಯ್ ಸಗೊಳ್ ತ್ಯಾಚ್ ಘರಾತ್ ರ್‍ಹಾವಾ”, ");
INSERT INTO kans_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ಎಕ್ ಘರಾತ್ ತುಮಿ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ “ಶಾಂತಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹವ್ನದಿತ್” ಮನಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ತ್ಯಾ ಘರಾತ್ಲ್ಯಾ ಲೊಕಾನಿ ತುಮ್ಕಾ ಸ್ವಾಗತ್ ಕರ್ಲ್ಯಾರ್, ತುಮಿ ದಿಲ್ಲಿ ಶಾಂತಿ ಥೈಚ್ ರ್‍ಹಾವ್ಕ್ ಸೊಡಾ; ಅಕಾಸ್ಮಾತ್ ತೆನಿ ತುಮ್ಕಾ ಮರ್‍ಯಾದ್ ದಿನಸ್ಲ್ಯಾರ್ ತುಮ್ಚಿ ಶಾಂತಿ ತುಮ್ಚೆಕ್ಡೆ ಫಾಟಿ ಪರ್ತುನ್ ಯೆಂವ್ದಿತ್, ");
INSERT INTO kans_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ಅನಿ ಜರ್ ಎಕ್ ಗಾವಾತ್ಲ್ಯಾ ಲೊಕಾನಿ ನಾಹೊಲ್ಯಾರ್ ಘರಾತ್ಲ್ಯಾ ಲೊಕಾನಿ ತುಮ್ಕಾ ಮರ್‍ಯಾದ್ ದಿನಸ್ಲ್ಯಾರ್, ಅನಿ ತುಮಿ ಸಾಂಗಲ್ಲೆ ಆಯ್ಕಿನಸ್ಲ್ಯಾರ್ ತೊ ಜಾಗೊ ಸೊಡುನ್ ಫಿಡೆ ಚಲಾ, ಅನಿ ಜಾತಾನಾ ತುಮ್ಚ್ಯಾ ಪಾಯಾಂಚಿ ಧುಳ್ ಫಾಪ್ಡಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, “ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ ದೆವ್ ಸೊದೊಮ್, ಅನಿ ಗೊಮೊರ್ ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ನಿ ಜಾಸ್ತಿ ದಯಾ ದಾಕ್ವಿಲ್ ಖರೆ ತ್ಯಾ ಗಾವಾಕ್ ದಯಾ ದಾಕ್ವಿನಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ಆಯ್ಕಾ! ಝುಲ್ ಕುತ್ರ್ಯಾಂಚ್ಯಾ ಮದ್ದಿ ಬಕ್ರ್ಯಾಕ್ನಿ ಧಾಡಲ್ಲ್ಯಾ ಸರ್ಕೆ ಮಿಯಾ ತುಮ್ಕಾ ಧಾಡ್ತಾ. ತುಮಿ ಸಾಪಾ ಸರ್ಕೆ ಉಶಾರ್ ಅನಿ ಪಾರಿವಾಳಾಂಚ್ಯಾ ಸರ್ಕೆ ಭೊಳೆ ಹೊವ್ನ್ ರ್‍ಹಾವಾ”. ");
INSERT INTO kans_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ಯಾದ್ ರ್‍ಹಂವ್ದಿ, ಥೈ ತುಮ್ಕಾ ಲೊಕಾ ಧರುನ್ ಝಡ್ತಿ ಕರ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ವೊಡುನ್ ಘೆವ್ನ್ ಜಾತ್ಯಾತ್, ಅನಿ ಸಿನಾಗೊಗಾತ್ನಿ ನ್ಹೆವ್ನ್ ಕಾಟ್ಯಾಂಚ್ಯಾ ಬಾರ್‍ಕೊಲಾನಿ ಮಾರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ಮಾಜೆಸಾಟಿ ತುಮ್ಕಾ ಅದಿಕಾರ್‍ಯಾಂಚ್ಯಾ, ಅನಿ ರಾಜಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ವೊಡುನ್ ಘೆವ್ನ್ ಜಾತ್ಯಾತ್, ಅಶೆ ಹೆ ಸಗ್ಳೆ ತೆಂಕಾ, ಅನಿ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಸಾಕ್ಷಿ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ಖರೆ ತೆನಿ ತುಮ್ಕಾ ಇಚಾರ್‍ನಿ ಕರುಕ್ ಘೆವ್ನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತುಮಿ ಕಾಯ್ ಸಾಂಗ್ತಲೆ ಕಶೆ ಸಾಂಗ್ತಲೆ ಮನುನ್ ಚಿಂತಾ ಕರುನಕಾಸಿ, ತ್ಯಾ ಎಳಾರ್ ಕಾಯ್ ಬೊಲ್ತಲೆ ಮನುನ್ ತುಮ್ಕಾ ದಿಲ್ಲೆ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ತನ್ನಾ ತುಮಿ ಬೊಲ್ತಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ತುಮ್ಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ನ್ಹಯ್ ತ್ಯಾ ಗೊಸ್ಟಿಯಾ ತುಮ್ಚ್ಯಾ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ಬಾಬಾಚೊ ಪವಿತ್ರ್ ಅತ್ಮೊಚ್ ತುಮ್ಚ್ಯಾ ತೊಂಡಾನಿತ್ನಾ ಬೊಲ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ಭಾವ್ ಅಪ್ನಾಚ್ಯಾ ಭಾವಾಕ್ನಿಚ್ ಜಿವಾನಿ ಮಾರುಕ್ ಮನುನ್ ಧರುನ್ ದಿತ್ಯಾತ್, ಅನಿ ಬಾಬಾ ಅಪ್ನಾಚ್ಯಾ ಪೊರಾಕ್ನಿ ಜಿವಾನಿ ಮಾರುಕ್ ಧರುನ್ ದಿತ್ಯಾತ್; ಪೊರಾ ತೆಂಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಚ್ಯಾ ವರ್‍ತಿ ಹುರ್‍ಪಾಟಿ ಹೊತ್ಯಾತ್ ಅನಿ ತೆಂಕಾ ಜಿವಾನಿ ಮಾರುಕ್ ದಿತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","“ತುಮಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತ್ಯಾ ಸಾಟ್ನಿ ಲೊಕಾ ತುಮ್ಕಾ ಕಿಮ್ಮತ್ ದಿನ್ಯಾತ್, ಖರೆ ಜೊ ಕೊನ್ ಸರ್ತ್ಯಾ ಎಳಾರ್ ಸಗೊಳ್ ಘಟ್ ರ್‍ಹಾತಾ ತೊ ಬಚಾವ್ ಹೊತಾ”. ");
INSERT INTO kans_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“ಎಕ್ ಶಾರಾತ್ ಲೊಕಾನಿ ತುಮ್ಕಾ ತರಾಸ್ ದಿಲ್ಯಾರ್, ದುಸ್ರ್ಯಾ ಶಾರಾಕ್ ಪಳುನ್ ಜಾವಾ, ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆಯ್ ಸಗೊಳ್ ಇಸ್ರಾಯೆಲಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಶಾರಾತ್ನಿ ತುಮಿ ಕರ್‍ತಲೆ ತುಮ್ಚೆ ಕಾಮ್ ಕರುನ್ ಸರಿನಾ”. ");
INSERT INTO kans_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ಎಕ್ ಶಿಕ್ತಲೊ ಅಪ್ನಾಕ್ ಶಿಕ್ವುತಲ್ಯಾ ಮಾಸ್ತರಾಚ್ಯಾಕ್ನಿ ಮೊಟೊ ನ್ಹಯ್, ಸೆವಕ್ ಅಪ್ನಾಚ್ಯಾ ಧನಿಯಾನ್ಕಿ ಮೊಟೊ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ಖರೆ ಎಕ್ ಶಿಕ್ತಲ್ಯಾಕ್ ಬರೆ ಕರುನ್ ಶಿಕುನ್ ಮಾಸ್ತರಾ ಸರ್ಕೊ ಹೊವ್ಕ್ ಹೊತಾ, ಅನಿ ಎಕ್ ಸೆವಕಾಕ್ ಧನಿಯಾ ಸರ್ಕೊ ಹೊವ್ಕ್ ಹೊತಾ. ಘರಾಚ್ಯಾ ವಡ್ಲಾಕುಚ್, ಗಿರ್‍ಯಾಚೊ ಮುಖಂಡ್ ಬೆಎಲ್ಜೆಬುಲ್, ಮನುನ್ ಬಲ್ವುಲ್ಯಾರ್, ಘರಾತ್ಲ್ಯಾ ಹುರಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಕವ್ಡೆ ಬುರ್ಶ್ಯಾ ನಾವಾನ್ ಬಲ್ವುಲ್ಯಾತ್ ಅಸಿಲ್!” ");
INSERT INTO kans_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ತೆಚೆಸಾಟ್ನಿ ಮಾನ್ಸಾಕ್ನಿ ತುಮಿ ಭಿಂವ್‍ನಕಾಶಿ, ಜೆ ಕಾಯ್ ಧಾಪುನ್ ಥವಲ್ಲೆ ಹಾಯ್ ತೆ ಉಗ್ಡುನ್ ಹೊತಾ, ಅನಿ ಘುಟಾನ್ ಹೊತ್ತೆ ಸಗ್ಳೆ ಸಗ್ಳ್ಯಾಕ್ನಿ ಕಳ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ಮಿಯಾ ಕಾಯ್ ಕಾಳ್ಕಾತ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ತೆ ತುಮಿ ದಿಸಾಚ್ಯಾ ಮೊಟ್ಯಾ ಉಜ್ವೊಡಾತ್ ಸಾಂಗುಕ್ ಪಾಜೆ, ಅನಿ ಜೆ ಕಾಯ್ ತುಮಿ ಕಡೆಕ್ ಎಗ್ಳೆಚ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ಆಯ್ಕುಲ್ಯಾಶಿ ತೆ ತುಮಿ ಹುಜರಾತಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಇದ್ರಾಕ್ ಸಾಂಗುಕ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ತುಮ್ಚ್ಯಾ ಹ್ಯಾ ಆಂಗಾಚೊ ಜಿವ್ ಕಾಡ್ತಲ್ಯಾಕ್ ಭಿಂವ್‍ನಕಾಶಿ, ತೆನಿ ತುಮ್ಚ್ಯಾ ಅತ್ಮ್ಯಾಕ್ ಕಾಯ್-ಬಿ ಕರುಕ್ ಹೊಯ್ನಾ. ಖರೆ ಆಂಗ್ ಅನಿ ಆತ್ಮೊ ದೊನಿಬಿ ನರ್‍ಕಾತ್ ಘಾಲ್ತಲೊ ಅದಿಕಾರ್ ಹೊತ್ತ್ಯಾ ದೆವಾಕ್ ಭಿವಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ಎಕುಚ್ಎಕ್ ಪೈಸ್ಯಾಕ್ ದೊನ್ ಗುಬ್ಬಿಯಾ ಇಕಾತ್ ಗಾವ್ತ್ಯಾತ್ ಹೊಯ್‍ ಕಾಯ್ ನ್ಹಯ್, ಖರೆ ತುಮ್ಚ್ಯಾ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ಬಾಬಾಕ್ ಕಳಿನಸ್ತಾನಾ ಎಕ್‍ಬಿ ಗುಬ್ಬಿಕ್ ಖಾಲ್ತಿ ಪಡುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ತುಜೆಸಾಟ್ನಿ ಮನುನ್ ತುಜ್ಯಾ ಟಕ್ಲ್ಯಾಚಿ ಕೆಸಾ ಸೈತ್ ಮೆಜುನ್ ಥವಲ್ಲಿ ಹಾತ್”. ");
INSERT INTO kans_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ತಸೆಮನುನ್ ತುಮಿ ಭಿಂಯಾತಲಿ ಗರಜ್ ನಾ, ಗುಬ್ಬಿಯಾಂಚ್ಯಾನ್ಕಿ ತುಮ್ಚಿ ಕಿಮ್ಮತ್ ಲೈ. ");
INSERT INTO kans_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ಜೆ ಕೊನಾಕ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಮಾಜೊ ಮನುನ್ ಸಾಂಗ್ತ್ಯಾತ್, ತೆಕಾ ಮಿಯಾಬಿ ಸರ್ಗಾಚ್ಯಾ ರಾಜಾತ್ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ಇದ್ರಾಕ್ ಮಾಜೊಚ್ ಮನುನ್ ಘೆತಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ಖರೆ ಜೆ ಕೊನ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಮಾಕಾ ಸ್ವಿಕಾರ್ ಕರಿನಾ, ತೆಕಾ ಮಿಯಾಬಿ ಸರ್‍ಗಾತ್ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ಇದ್ರಾಕ್ ಸ್ವಿಕಾರ್ ಕರಿನಾ”. ");
INSERT INTO kans_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ಮಿಯಾ ಹ್ಯಾ ಜಗಾತ್ ಸಮಾದಾನ್ ಹಾನುಕ್ ಯೆಲಾ ಮನುನ್ ಯವ್ಜುನಕಾಶಿ, ಸಮಾದಾನ್ ನ್ಹಯ್ ಎಕಾಮೆಕಾಚ್ಯಾಮದ್ದಿ ಆಗ್ ಲಾವುಕ್ ಮನುನ್ ಯೆಲಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ಲೆಕಾಕ್ನಿ ತೆಂಚ್ಯಾ ಬಾಬಾಂಚ್ಯಾ ವಿರೊದ್, ಲೆಕಿಯಾಕ್ನಿ ತೆಂಚ್ಯಾ ಅವ್ಸಿಯಾಂಚ್ಯಾ ವಿರೊದ್, ಅನಿ ಸುನ್ನಾಕ್ನಿ ತೆಂಚ್ಯಾ ಮಾಮ್ಜಿಯಾಂಚ್ಯಾ ವಿರೊದ್ ಕರುಕ್ ಯೆಲಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ತುಮ್ಚ್ಯಾ ಕುಟ್ಮಾಚಿಚ್ ಲೊಕಾ ತುಮ್ಚೆ ಮೊಟೆ ದುಸ್ಮಾನ್ ಹೊತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ಜೊ ಕೊನ್ ಮಾಜೆನ್ಕಿ ಜಾಸ್ತಿ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಚೊ ನಾಹೊಲ್ಯಾರ್ ಬಾಬಾಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ತೊ ಮಾಜೊ ಶಿಸ್ ಹೊವ್ಕ್ ಯೊಗ್ಯ್ ನ್ಹಯ್. ಜೊ ಕೊನ್ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಚೊ ನಾಹೊಲ್ಯಾರ್ ಲೆಕಿಚೊ ಮಾಜೆನ್ಕಿ ಜಾಸ್ತಿ ಪ್ರೆಮ್ ಕರ್‍ತಾ ತೊ ಮಾಜೊ ಶಿಸ್ ಹೊವ್ಕ್ ಯೊಗ್ಯ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ಜೊ ಕೊನ್ ಅಪ್ನಾಚೊ ಕಸ್ಟ್ ಸೊಸುನ್ ಘೆವ್ನ್ ಮಾಜ್ಯಾ ಪಾವ್ಲಾತ್ನಿ ಪಾವ್ಲಾ ಥವ್ನ್‌ಗೆತ್ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆಯ್ನಾ ತೊ ಮಾಜೊ ಶಿಸ್ ಹೊವ್ಕ್ ಯೊಗ್ಯ್ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ಜೊ ಕೊನ್ ಅಪ್ನಾಚೊ ಜಿವ್ ರಾಕುನ್ ಘೆವ್ಕ್ ಬಗ್ತಾ ತೊ ಕಳ್ದುನ್ ಘೆತಾ, ಜೊ ಕೊನ್ ಮಾಜೆಸಾಟಿ ಅಪ್ನಾಚೊ ಜಿವ್ ಕಳ್ದುನ್ ಘೆತಾ ತೊ ಅಪ್ನಾಚೊ ಜಿವ್ ಹುರ್ವುನ್ ಘೆತಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ಜೆ ಕೊನ್ ತುಮ್ಕಾ ಸ್ವಾಗತ್ ಕರ್‍ತಾ ತೊ ಮಾಕಾಚ್ ಸ್ವಾಗತ್ ಕರ್‍ತಾ; ಅನಿ ಜೊ ಕೊನ್ ಮಾಕಾ ಸ್ವಾಗತ್ ಕರ್‍ತಾ ತೊ ಮಾಕಾ ಧಾಡಲ್ಲ್ಯಾ ದೆವಾಕುಚ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ಜೊ ಕೊನ್ ದೆವಾಚಿ ಖಬರ್ ಸಾಂಗ್ತಲ್ಯಾಕ್ ತೊ ದೆವಾಚಿ ಖಬರ್ ಸಾಂಗ್ತಲೊಚ್ ಮನುನ್ ಸ್ವಾಗತ್ ಕರ್‍ತಾ ತೆಕಾ ತ್ಯಾ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ತಲ್ಯಾಚ್ಯಾ ಭೊಮಾನಾತ್ಲೊ ವಾಟೊ ಗಾವ್ತಾ. ಅನಿ ಕೊನ್ ತರ್ ಎಕಾ ಬರ್‍ಯಾ ಮಾನ್ಸಾಕ್ ತೊ ಬರೊ ಮಾನುಸ್ ಮನುನ್ ಸ್ವಾಗತ್ ಕರ್‍ತಾ ಹೊಲ್ಯಾರ್, ತ್ಯಾ ಬರ್‍ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಭೊಮಾನಾತ್ಲೊ ವಾಟೊ ತೆಕಾ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ತುಮ್ಕಾ ಗೊತ್ತ್ ರ್‍ಹಾಂವ್ದಿ, ಹ್ಯಾ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ರ್‍ಹಾತಲ್ಯಾತ್ಲ್ಯಾ ಎಕ್ ಬಾರಿಕ್ಲ್ಯಾಕ್ ಸೈತ್ ತೊ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ರ್‍ಹಾತಲೊ ಮನುನ್ ಗೊತ್ತ್ ರ್‍ಹವ್ನಬಿ ತೆಕಾ ಫಿವ್ಕ್ ಎಕ್ ಘುಟುಕ್‍ ಬರ್ ಸೈತ್ ಪಾನಿ ದಿಲ್ಯಾರ್, ತೆಕಾ ತೆಚೊ ಭೊಮಾನ್ ಗಾವುನುಚ್ ಗಾವ್ತಾ”. ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್, ಅನಿ ತೆಂಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ಹೆ ಸಗ್ಳೆ ಅಪ್ನಾಚ್ಯಾ ಬಾರಾ ಜಾನಾ ಶಿಸಾಕ್ನಿ ಸಾಂಗುನ್ ಸರಲ್ಲ್ಯಾ ಮಾನಾ, ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್ ಥೈ ಹೊತ್ತ್ಯಾ ಜಗೊಳ್‍ಲ್ಯಾ ಶಾರಾತ್ನಿ ಶಿಕ್ವುಕ್ ಅನಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ಬಂಧಿಖಾನ್ಯಾತ್ ಹೊತ್ತ್ಯಾ ಜುವಾಂವ್ ಬಾವ್ತಿಸಾನ್, ಕ್ರಿಸ್ತ್ ಕಸ್ಲಿ-ಕಸ್ಲಿ ಕಾಮಾ ಕರುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಮನ್ತಲೆ ಆಯಿಕ್ಲ್ಯಾನ್, ತಸೆಮನುನ್ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ತೆಚೆಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ಜುವಾಂವಾಚ್ಯಾ ಶಿಸಾನಿ ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್, ಜುವಾಂವಾನ್ ಯೆತಲೊ ಹಾಯ್ ಮನುನ್ ಸಾಂಗಟಲ್ಲೊ ಸುಟ್ಕಾದಿನಾರೊ ತಿಯಾಚ್ ಕಾಯ್, ಅಮಿ ಅನಿ ಎಕ್ಲ್ಯಾಚಿ ವಾಟ್ ಬಗುಚಿ? ಮನುನ್ ಅಮ್ಕಾ ಸಾಂಗ್. ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ತನ್ನಾ ಜೆಜುನ್,“ಪರ್ತುನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮಿ ಕಾಯ್ ಬಗಟ್ಲ್ಯಾಶಿ ಅನಿ ಆಯಿಕ್ಲ್ಯಾಶಿ ತೆ ಜುವಾಂವಾಕ್ ಸಾಂಗಾ. ");
INSERT INTO kans_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ಕುಡ್ಡ್ಯಾಕ್ ದಿಸ್ತಾ ಸೊಟ್ಟೊ ಚಲ್ತಾ, ಜೆ ಕೊನಾಕ್ ಕುಸ್ಟ್ ರೊಗ್ ಹಾಯ್ ತೊ ಪವಿತ್ರ್ ಹೊವ್ಲಾ, ಕಿಂವ್ಡೊ ಆಯ್ಕುಲಾ, ಮರಲ್ಲಿ ಲೊಕಾ ಝಿತ್ತಿ ಹೊವ್ಕ್ ಲಾಗ್ಲ್ಯಾತ್, ಅನಿ ಗರಿಬಾಕ್ನಿ ಬರಿ ಖಬರ್ ಸಾಂಗುನ್ ಹೊವ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಸಂಶೆವ್ ಕರಿನಸಲ್ಲಿ ಲೊಕಾ ಕವ್ಡಿ ಸುಖಿ!” ಮನುನ್ ತೆಂಕಾ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ಜುಂವಾವಾಚಿ ಶಿಸಾ ಥೈತ್ನಾ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜು ಜುವಾಂವಾಚ್ಯಾ ವಿಶಯಾತ್ ಲೊಕಾನಿಕ್ಡೆ ಬೊಲುಕ್‍ಲಾಗ್ಲೊ. “ಡಂಗ್ಳಿತ್ ಜುವಾಂವಾಕ್ಡೆ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಕಾಯ್ ಬಗುಕ್ ಮನುನ್ ಗೆಲ್ಲ್ಯಾಶಿ? ವಾರ್‍ಯಾನ್ ಹಾಲ್ತಲಿ ಎಕ್ ಕರಾಡಾಚಿ ಕಾಡಿ? ");
INSERT INTO kans_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ಕಾಯ್ ಬಗುಕ್ ಗೆಲ್ಲ್ಯಾಶಿ ತುಮಿ? ಬರೆ ಕಪ್ಡೆ ನೆಸಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಕಾಯ್? ಬರೆ-ಬರೆ ಕಪ್ಡೆ ನೆಸ್ತಲಿ ಲೊಕಾ ಅರಮನೆತ್ ರ್‍ಹಾತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ಸಾಂಗಾ ಮಾಕಾ, ಕಾಯ್ ಬಗುಕ್ ಥೈ ಗೆಲ್ಲ್ಯಾಶಿ? ಎಕ್ ಪ್ರವಾದ್ಯಾಕ್? ಹೊಯ್ ಖರೆಚ್ ತೆ, ಖರೆ ಎಕ್ ಪ್ರವಾದ್ಯಾನ್ಕಿ ಮೊಟೆ ತುಮಿ ಥೈ ಬಗಟ್ಲ್ಯಾಶಿ”. ");
INSERT INTO kans_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ಜುವಾಂವ್ ಕೊನ್ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ದೆವ್ ತೆಚ್ಯಾ ವಿಶಯಾತ್ ಮನ್ತಾ, “ತುಜಿ ವಾಟ್ ತಯಾರ್ ಕರುಕ್ ಮಿಯಾ ಮಾಜಿ ಬಾತ್ಮಿ ಸಾಂಗ್ತಲ್ಯಾಕ್ ತುಜ್ಯಾ ಫಿಡೆ-ಫಿಡೆ ಧಾಡುನ್ ದಿತಾ.” ");
INSERT INTO kans_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಆಜ್ ಸಗೊಳ್ ಜಲ್ಮಲ್ಲ್ಯಾ ಮಾನ್ಸಾತ್ನಿ ಜುವಾಂವಾ ತವ್ಡೊ ಮೊಟೊ ಕೊನ್ ಬಿ ನಾ. ಖರೆ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾತ್ ಎಗ್ದಮ್ ಬಾರಿಕ್ ಮನುನ್ ಹೊತ್ತೊಬಿ ಜುವಾಂವ್ ಬಾವ್ತಿಸಾಚ್ಯಾನ್ ಮೊಟೊ. ");
INSERT INTO kans_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ಜುವಾಂವ್ ಬಾವ್ತಿಸಾನ್ ಅಪ್ನಿ ಸಾಂಗ್ತಲಿ ಖಬರ್ ಸಾಂಗಲ್ಲ್ಯಾಕ್ನಾ ಆಜ್ ಪತರ್‍ಬಿ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜ್ ಘಟ್ ಹೊವ್ನಗೆತ್ ಹಾಯ್, ಅನಿ ತರಾಸ್ ದಿತಲಿ ಲೊಕಾ ತೆ ಅಪ್ನಾಚೆ ಕರುನ್ ಘೆವ್ಕ್ ಬಗುಲ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ಜುವಾಂವಾಚ್ಯಾ ಕಾಲಾಪತರ್ ಸಗ್ಳ್ಯಾ ಪ್ರವಾದ್ಯಾನಿ ಅನಿ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾನಿ ದೆವಾಚ್ಯಾ ರಾಜಾಚ್ಯಾ ವಿಶಯಾತುಚ್ ಬೊಲ್ಲ್ಯಾನಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ಅನಿ ತುಮಿ ತೆಂಚ್ಯಾ ಗೊಸ್ವಿಯಾಂಚ್ಯಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಕರುಕ್ ಮನುನ್ ಯೌಜುಲ್ಯಾಸಿ ಜಾಲ್ಯಾರ್ ಯೆತಲೊ ಹಾಯ್ ಮನುನ್ ಸಾಂಗಲ್ಲೊ ಎಲಿಯಾ ಜುವಾಂವುಚ್. ");
INSERT INTO kans_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ಜೆ ಕೊನಾಕ್ ಕಾನಾ ಹಾತ್, ತೊ ಆಯ್ಕುಂದಿತ್! ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ಖರೆ ಅತ್ತಾಚ್ಯಾ ಕಾಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಮಿಯಾ ಕಶ್ಯಾಕ್ ಸಮಾ ಕರು? ತೆನಿ ಬಾಜಾರಾತ್ ಬಸಲ್ಲ್ಯಾ ಪೊರಾಂಚ್ಯಾ ಸರ್ಕೆ, ಎಕ್ ತಾಂಡೊ ಅನಿ ಎಕ್ ತಾಂಡ್ಯಾಕ್ ಬೊಬ್ ಮಾರುನ್ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ಅಮಿ ತುಮ್ಚೆಸಾಟ್ನಿ ಲಗ್ನಾಚೆ ವಾಜಾಪ್ ವಾಜ್ವುಲಾವ್, ಖರೆ ತುಮಿ ನಾಚುಕ್ನ್ಯಾಶಿ! ಅಮಿ ಮರ್‍ನಾಚ್ಯಾ ಗಿತಾ ಮಟ್ಲ್ಯಾವ್, ಜಾಲ್ಯಾರ್‍ಬಿ ತುಮಿ ರಡುಕ್ನ್ಯಾಶಿ!” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜುವಾಂವ್ ಯೆಲೊ ಅನಿ ತೆನಿ ಉಪಾಸ್ ಕರ್‍ಲ್ಯಾನ್ ಅನಿ ವಾಯ್ನ್ ಫಿವ್ಕ್ ನಾ. ತನ್ನಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ಗಿರೊಲಾಗ್ಲಾ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಖಾಲ್ಯಾನ್ ಅನಿ ಫಿಲ್ಯಾನ್, ತನ್ನಾ ತೆಕಾ ಲೊಕಾನಿ, ಹ್ಯಾ ಮಾನ್ಸಾಕ್ ಉಲ್ಲೆ ಬಗಾ, ಹ್ಯೊ ಫಿದೊಡೊ ಅನಿ ಬಕಾಸುರ್, ಅನಿ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲ್ಯಾಂಚೊ ಅನಿ ಪಾಪಿ ಲೊಕಾಂಚೊ ದೊಸ್ತ್! ಮಟ್ಲ್ಯಾನಿ. ಖರೆ ದೆವಾಚಿ ಬುದ್ವಂತ್ಕಿ ಅಪ್ನಾಚ್ಯಾ ಕಾಮಾನಿಚ್ ಅಪ್ನಾಚೆ ಖರೆಪಾನ್ ದಾಕ್ವುನ್ ದಿತಾ. ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ಜೆಜುನ್ ಅಪ್ನಿ ಮೊಟಿ-ಮೊಟಿ ವಿಚಿತ್ರ್ ಕಾಮಾ ತ್ಯಾ ಶಾರಾತ್ನಿ ಕರಲ್ಲ್ಯಾನ್, ಜಾಲ್ಲ್ಯಾರ್‍ಬಿ ತ್ಯಾ ಶಾರಾನಿತ್ಲ್ಯಾ ಲೊಕಾನಿ ಅಪ್ನಾಚೆ ಮನ್ ದೆವಾಕ್ಡೆ ಪರ್‍ತುನತ್ತ್ಯಾನಿ. ಜೆಜುನ್ ತ್ಯಾ ಶಾರಾಕ್ನಿ ಖಂಡನ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ಅನಿ,ಖೊರಾಜಿನಾ, ಮಿಯಾ ತುಜಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಬೆತ್ಸಾಯಿದಾ, ತುಜಿಬಿ ಗತ್ ಮಿಯಾ ಕಾಯ್ ಸಾಂಗು! ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಕರಲ್ಲಿ ತವ್ಡಿ ವಿಚಿತ್ರ್ ಕಾಮಾ ಮಿಯಾ ತಿರ್ ಅನಿ ಸಿದೊನಾತ್ ಕರ್ಲ್ಯಾರ್ ಥೈತ್ಲಿ ಲೊಕಾ ಅಪ್ನಿ ಪಾಪಾನಿತ್ನಾ ದೆವಾಕ್ಡೆ ಪರತ್ಲಾವ್ ಮನುನ್ ದಾಕ್ವುಕ್ ಕನ್ನಾಚ್ಕಿ ಆಂಗಾರ್ ಗೊನಿಚಿಲ್ ಘಾಲುನ್ ಘೆವ್ನ್ ರಕ್ಕಾ ಆಂಗಾ ವರ್‍ತಿ ಸಿಪ್ಡುನ್ ಘೆಯ್ ಹೊತ್ತಿ ಕಾಯ್ಕಿ. ");
INSERT INTO kans_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ ದೆವ್ ತುಮ್ಚೆನ್ಕಿ ಜಾಸ್ತಿ ತಿರ್ ಅನಿ ಶಿದೊನಾಕ್ ಲೈ ದಯಾ ದಾಕ್ವುತಾ! ");
INSERT INTO kans_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ಅನಿ ತಿಯಾ ಕಫರ್‍ನವ್; ತಿಯಾ ತುಕಾಚ್ ಸರ್‍ಗಾ ವರ್‍ತಿ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಬಗುಲೆ ಕಾಯ್? ತಿಯಾ ನರ್‍ಕಾತುಚ್ ಜಾನಾರ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತುಜ್ಯಾ ಭುತ್ತುರ್ ಕರಲ್ಲಿ ತವ್ಡಿ ವಿಚಿತ್ರ್ ಕಾಮಾ, ಸೊದಾಮಾತ್ ಕರಲ್ಲಿ ರ್‍ಹಾಲ್ಯಾರ್, ತೆ ಶಾರ್ ಆಜ್ ಪತರ್ ತಸೆಚ್ ರ್‍ಹಾಯ್ ಹೊತ್ತೆ ಅಸಿಲ್! ");
INSERT INTO kans_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ತಿಯಾ ಯಾದ್ ಥವ್ನ್ ಘೆ, ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ ದೆವ್ ತುಜೆನ್ಕಿ ಜಾಸ್ತಿ ಸೊದೊಮಾ ವರ್‍ತಿ ದಯಾ ದಾಕ್ವುತಾ! ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ತ್ಯಾ ಎಳಾರ್ ಜೆಜುನ್,“ಬಾಬಾ, ಸರ್‍ಗಾ ಅನಿ ಜಿಮ್ನಿಚ್ಯಾ ಧನಿಯಾ; ಮಿಯಾ ತುಕಾ ಧನ್ಯವಾದ್ ದಿತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಬುದ್ವಂತಾ ಅನಿ ಶಾನ್ಯಾ ಲೊಕಾನಿಕ್ನಾ ನಿಪ್ವುನ್ ಥವಲ್ಲೆ, ಬಾರಿಕ್ ಪೊರಾಂಚ್ಯಾ ಸರ್ಕಿ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ತಿಯಾ ದಾಕ್ವುಲೆಯ್”. ");
INSERT INTO kans_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ಹೊಯ್, ಬಾಬಾ, ತುಕಾ ಕಶೆ ಪಾಜೆ ಹೊತ್ತೆ, ತಸೆ ತೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ಸಗ್ಳೆ ದಿಲ್ಯಾನಾಯ್, ಬಾಬಾಕ್ ಸೊಡುನ್ ಕೊನಾಕ್ಬಿ ಲೆಕಾಚ್ಯಾ ವಿಶಯಾತ್ ಗೊತ್ತ್ ನಾ, ಅನಿ ಲೆಕಾನ್ ಬಾಬಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಗ್ಳ್ಯಾಕ್ನಿ ಕಳ್ವುಕ್ ಮನುನ್ ಎಚುನ್ ಕಾಡಲ್ಯಾಕ್ನಿ ಸೊಡುನ್ ಕೊನಾಕ್‍ ಬಿ ಬಾಬಾಚ್ಯಾ ವಿಶಯಾತ್ ಗೊತ್ತ್ ನಾ”. ");
INSERT INTO kans_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ಮೊಟಿ-ಮೊಟಿ ವಜ್ಜಿ ವಾವುನ್ ಘೆವ್ನ್ ಹಾರುನ್ ಗೆಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾನು, ಮಾಜೆಕ್ಡೆ ಯೆವಾ, ಅನಿ ಮಿಯಾ ತುಮ್ಕಾ ಅರಾಮ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ಮಾಜೊ ಜುವ್ ಘೆವಾ, ಅನಿ ಖಾಂಜ್ಯಾರ್ ಥವ್ನ್ ಘೆವಾ ಅನಿ ಮಾಜೆಕ್ನಾ ಶಿಕಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಚಲ್ತಲ್ಯಾ ಮನಾಚೊ ಅನಿ ಭೊಳೊ; ಅನಿ ತುಮ್ಕಾ ಆರಾಮ್ ಘೆವ್ಕ್ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ತುಮ್ಕಾ ದಿತಲೊ ಜು ಲೈ ಸಸಾರಾಚೊ, ಅನಿ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವರ್‍ತಿ ವಾವ್ತಲೆ ವಜ್ಜೆ ಹಗ್ಗುರ್”. ");
INSERT INTO kans_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ತ್ಯಾ ದಿಸಾತ್ನಿ ಎಗ್ದಾ ಜೆಜು ಜುದೆವ್ ಲೊಕಾ ಆರಾಮ್ ಘೆತಲ್ಯಾ ದಿಸಿ ಮಟ್ಲ್ಯಾರ್ ಸಬ್ಬಾತಾಚ್ಯಾ ದಿಸಿ, ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಘೆವ್ನ್ ಶೆತಾನ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಜಾವ್‍ಲಾಗಲ್ಲೊ. ತನ್ನಾ ತೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಭುಕ್‍ಲಾಗಲ್ಲಿ; ತಸೆಮನುನ್ ತೆನಿ ಘಂವಾಚಿ ಕನ್ಸಾ ಮೊಡುನ್ ಘೆವ್ನ್ ಘಂವಾಚೆ ದಾನೆ ಖಾವ್‍ಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ಹೆ ಫಾರಿಜೆವಾನಿ ಬಗಟ್ಲ್ಯಾನಿ, ಅನಿ ಜೆಜುಕ್, ಬಗ್, ತುಜ್ಯಾ ಶಿಸಾನಿ ಕರ್‍ತಲೆ, ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ವಿರೊದ್ ಹಾಯ್! ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ದಾವಿದಾಕ್ ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾಕ್ನಿ, ಭುಕ್‍ ಲಾಗಲ್ಲ್ಯಾ ತನ್ನಾ ದಾವಿದಾನ್ ಕಾಯ್ ಕರ್‍ಲ್ಯಾನ್ ಮನುನ್ ತುಮಿ ಕನ್ನಾಬಿ ವಾಚ್ವುಕ್ನ್ಯಾಸಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ತೊ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಗೆಲೊ. ಅನಿ ದೆವಾಕ್ ಭೆಟ್ವಲ್ಲ್ಯಾ ಭಾಕ್ರಿಯಾ ಯಾಜಕಾನಿ ಸೊಡುನ್ ಅನಿ ಕೊನ್‍ಬಿ ಖಾತಲೆ ನಾ ಮನುನ್ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ ಸಾಂಗಲ್ಲೆ ಹಾಯ್ ಜಾಲ್ಯಾರ್‍ಬಿ ತೆನಿ ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಿಯಾನಿ ತ್ಯಾ ಭಾಕ್ರಿಯಾ ಖಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ನಾಹೊಲ್ಯಾರ್, ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ ಎಕ್ ಯಾಜಕಾನ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಅರಾಮ್ ಘೆತಲ್ಯಾ ದಿಸಾಚೊ ಮಟ್ಲ್ಯಾರ್ ಸಬ್ಬಾತಾಚೊ ಖಾಯ್ದೊ ಮೊಡ್ಲ್ಯಾರ್‍ಬಿ, ತೆಚಿ ಚುಕ್‍ ನಾ, ಮನುನ್ ವಾಚ್ವುಕ್ನ್ಯಾಸಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ದೆವಾಚ್ಯಾ ಗುಡಿನ್ಕಿ ಮೊಟೊ ಕೊನ್ಕಿ ಹಿತ್ತೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಸಾಂಗ್ತಾ, ಮಾಕಾ ದಯಾ ಪಾಜೆ, ಜನಾವರಾಂಚಿ ಬಲಿ ಮಾಕಾ ನಕ್ಕೊ, ಹೆಚೊ ಅರ್ತ್‍ ತುಮ್ಕಾ ಗೊತ್ತ್ ರ್‍ಹಾಲ್ಯಾರ್, ತುಮಿ ಚುಕ್ ಕರುನಸಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಬೊಟ್ ಕರುನ್ ದಾಕ್ವಿನಶಿ ಹೊತ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮನುನ್ ಬಲ್ವುತಲೊ ಮಿಯಾ ಅರಾಮ್ ಕರ್‍ತಲ್ಯಾ ದಿಸಾಚೊ ಮಟ್ಲ್ಯಾರ್ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಾಚೊಬಿ ಧನಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್ ಜುದೆವ್ ಲೊಕಾ ಸಿನಾಗೊಗಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ಥೈ ವಾರ್‍ಯಾನ್‍ಮಾರಲ್ಲ್ಯಾ ಹಾತಾಚೊ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ. ಉಲ್ಲಿ ಲೊಕಾ ಜೆಜು ಕಾಯ್ತರ್ ಚುಕ್ ಕರ್‍ತಾ ಕಾಯ್ ಬಗುನ್ ತೆಚೆ ವರ್‍ತಿ ಝುಟೊ ಅಪ್ವಾದ್ ಘಾಲುಚೆ ಮನುನ್ ರಾಕುಂಗೆತ್ ಹೊತ್ತಿ. ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ಜೆಜುಕ್, “ಅರಾಮ್ ಘೆತಲ್ಯಾ ದಿಸಿ ಮಟ್ಲ್ಯಾರ್ ಸಾಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಎಕ್ಲ್ಯಾಕ್ ಗುನ್ ಕರ್‍ತಲೆ ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಚುಕ್ ನ್ಹಯ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ತನ್ನಾ ಜೆಜುನ್,“ತುಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್ಡೆ ಎಕ್ ಬಕ್ರೆ ಹಾಯ್, ಅನಿ ಅರಾಮ್ ಘೆತಲ್ಯಾ ದಿಸಿ ತೆ ಬಕ್ರೆ ಎಕ್ ಮೊಟ್ಯಾ ತಗ್ಗಾತ್ ಪಡ್ತಾ, ತನ್ನಾ ತೊ ಕಾಯ್ ಕರ್‍ತಾ? ತ್ಯಾ ಬಕ್ರ್ಯಾಕ್ ತ್ಯಾತುರ್‍ನಾ ಭಾಯ್ರ್ ಕಾಡಿನಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ಎಕ್ ಮಾನುಸ್ ಬಕ್ರ್ಯಾಚ್ಯಾನ್ಕಿ ಕವ್ಡೊಕಿ ಕಿಮ್ತಿಚೊ! ತಸೆಹೊಲ್ಯಾರ್, ಅಮ್ಚೊ ಖಾಯ್ದೊ ಅರಾಮ್ ಘೆತಲ್ಯಾ ದಿಸಿ, ಅನಿಎಕ್ಲ್ಯಾಚೆ ಬರೆ ಕರುಚೆ ಮನುನ್ ಮನ್ತಾ ಮನುನ್ ಹೊಲೆ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ತನ್ನಾ ತ್ಯಾ ವಾರ್‍ಯಾನ್‍ಮಾರಲ್ಲ್ಯಾ ಹಾತಾಚ್ಯಾ ಮಾನ್ಸಾಕ್, ಜೆಜುನ್,“ತುಜೊ ಹಾತ್ ಲಾಂಬ್ ಸೊಡ್” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ಹಾತ್ ಲಾಂಬ್ ಸೊಡ್ಲ್ಯಾನ್ ಅನಿ ತೆಚೊ ಹಾತ್ ಅನಿಎಕ್ ಹಾತಿ ಸರ್ಕೊ ಬರೊ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ತನ್ನಾ ಫಾರಿಜೆವಾ ಥೈತ್ನಾ ಭಾಯ್ರ್ ಗೆಲಿ ಅನಿ ಜೆಜುಕ್ ಕಶೆ ಜಿವಾನಿ ಮಾರ್‍ತಲೆ, ಮನುನ್ ಬೊಲುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ಜೆಜುಕ್ ತ್ಯಾ ಲೊಕಾಂಚೊ ಘಾತ್ ಕಳ್ಳೊ, ತಸೆಮನುನ್ ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್ ಥೈತ್ನಾ ಧುರ್ ಗೆಲೊ, ಅನಿ ಲೊಕಾಂಚೊ ಮೊಟೊ ತಾಂಡೊ ತೆಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತೊ. ತೆನಿ ಸಿಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ಅನಿ ಅಪ್ನಾಚ್ಯಾ ವಿಶಯಾತ್ ದುಸ್ರ್ಯಾಕ್ನಿ ಸಾಂಗುನಕಾಸಿ ಮನುನ್ ಲೊಕಾಕ್ನಿ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾಕ್ನಾ ದೆವಾನ್ ಸಾಂಗಲ್ಲೆ ಖರೆ ಹೊವ್‍ಸಾಟ್ನಿ ಮನುನ್ ತೆನಿ ಅಶೆ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ತೆ, ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, ಹ್ಯೊ, ಮಾಜೊ ಅಪುರ್‍ಬಾಯೆಚೊ ಸೆವಕ್. ತೆಚೊ ಮಿಯಾ ಪ್ರೆಮ್ ಕರ್‍ತಾ, ಅನಿ ತೆಚ್ಯಾ ವಿಶಯಾತ್ ಮಿಯಾ ಖುಶಿ ಹಾವ್, ತೆಚ್ಯಾ ವರ್‍ತಿ ಮಿಯಾ ಮಾಜೊ ಪವಿತ್ರ್ ಆತ್ಮೊ ಧಾಡುನ್ ದಿತಾ. ಅನಿ ತೊ ಸಗ್ಳ್ಯಾ ದೆಶಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ನ್ಯಾಯ್ ಕರುನ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ತೊ ವಾದ್ ಘಾಲ್ತಲೆ, ನಾಹೊಲ್ಯಾರ್ ಬೊಬ್ ಮಾರ್‍ತಲೆ, ನಾಹೊಲ್ಯಾರ್ ಬೊಲುನ್‍ಗೆತ್ ಬಾಶಾನ್ ಸಾಂಗ್ತಲೆ ಹೆ ಸಗ್ಳೆ ಕರಿನಾ. ವನಿಯಾತ್ನಿ ತೆಚೊ ಧನ್ ಆಯ್ಕೊ ಯೆಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ಬಾಗಲ್ಲಿ ಕರಾಡಾಚಿ ಖಾಟಿ, ತೊ ಮೊಡಿನಾ, ಝೆಮ್ತಲಿ ಚಿಮ್ನಿ, ತೊ ಇಜ್ವಿನಾ, ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ನ್ಯಾಯ್ ಗಾವಿ ಪತರ್ ತೊ ಹಟ್ ಧರುನ್ ಘೆವ್ನ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ಅನಿ ಸಗ್ಳಿ ಲೊಕಾ ತೆಚ್ಯಾ ವರ್‍ತಿ ಬರೊ ಬರೊಸೊ ಥವ್ನ್ ಘೆವ್ನ್ ರ್‍ಹಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ತನ್ನಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ, ಎಕ್ ಕುಡ್ಡ್ಯಾ ಅನಿ ಮುಕ್ಕ್ಯಾ ಮಾನ್ಸಾಕ್ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ತೆಕಾ ಗಿರೊಲಾಗಲ್ಲೊ ಹೊತ್ತೊ. ಜೆಜುನ್ ತೆಕಾ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್ ತನ್ನಾ ತೊ ಬೊಲುಕ್‍ಲಾಲೊ ಅನಿ ತೆಕಾ ದಿಸುಕ್‍ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ಜೆಜುನ್ ಹೆ ಕರಲ್ಲೆ ಬಗುನ್ ಥೈ ಹೊತ್ತಿ ಲೊಕಾ ಅಜಾಪ್ ಹೊಲಿ. ಅನಿ,“ಹ್ಯೊ ದಾವಿದಾಚೊ ಲೆಕುಚ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ಹೆ ಆಯ್ಕುನ್ ಫಾರಿಜೆವಾನಿ, “ಗಿರ್‍ಯಾಂಚೊ ಮುಖಂಡ್ ಬೆಎಲ್ಜೆಬುಲ್ ತೆಕಾ ಬಳ್ ದಿತಾ, ತ್ಯಾ ಬಳಾನ್ ತೊ ಗಿರೆ ಸೊಡ್ಸುತಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ಜೆಜುಕ್ ತೆನಿ ಯವಜ್ತಲೆ ಕಳ್ಳೆ. ತಸೆಮನುನ್ ತೆನಿ ತೆಂಕಾ,“ಖಲೊಬಿ ಎಕ್ ದೆಸ್ ದೊನ್ ಭಾಗ್ ಹೊವ್ನ್ ಎಕಾಮೆಕಾ ಮದ್ದಿ ಝಗ್ಡುನ್ಗೆತ್ ರ್‍ಹಾಲ್ಯಾರ್, ತೊ ದೆಸ್ ಲೈ ದಿಸ್ ಠಿಕಿನಾ. ಅನಿ ಎಕ್ ಮೊಟೆ ಗಾಂವ್ ನಾಹೊಲ್ಯಾರ್ ಎಕ್ ಕುಟುಮ್‍ ದೊನ್ ಭಾಗ್ ಹೊವ್ನ್ ಝಗ್ಡುನ್ಗೆತ್ ರ್‍ಹಾಲ್ಯಾರ್, ತೆ ನಾಸುಚ್ ಹೊವ್ನ್ ಜಾತಾ”. ");
INSERT INTO kans_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ತಸೆಚ್ ಸೈತಾನಾಚ್ಯಾ ರಾಜಾತ್ ದೊನ್ ಭಾಗ್ ಹೊವ್ನ್ ಎಕಾಮೆಕಾಕ್ಡೆ ಝಗ್ಡುನ್ಗೆತ್ ರ್‍ಹಾಲ್ಯಾರ್, ತೆಚೊ ರಾಜ್ ಲಗ್ಗುನಾಚ್ ನಾಸ್ ಹೊವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ಮಾಕಾ ಗಿರೆ ಸೊಡ್ಸುಕ್ ಗಿರ್‍ಯಾಂಚೊ ಮುಖಂಡ್ ಬೆಲುಲ್ಜೆಬುಲ್ ತಾಕತ್ ದಿತಾ ಮನುನ್ ತುಮಿ ಮನುಲ್ಯಾಶಿ, ತಸೆ ಜಾಲ್ಯಾರ್ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಿಯಾಕ್ನಿ ಗಿರೆ ಕಾಡ್ತಲಿ ತಾಕತ್ ಖೈತ್ನಾ ಯೆತಾ? ತುಮ್ಚೆ ವಾಂಗ್ಡಿಚ್ ತುಮಿ ಚುಕ್ ಯೌಜುಲ್ಯಾಸಿ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ಗಿರ್‍ಯಾಂಚೊ ಮುಖಂಡ್ ಬೆಎಲ್ಜೆಬುಲ್ ನ್ಹಯ್, ಪವಿತ್ರ್ ಆತ್ಮೊ ಮಾಕಾ ಗಿರೆ ಸೊಡ್ಸುತಲಿ ತಾಕತ್ ದಿತಾ, ಅನಿ ಅಶೆ, ಹೆ ಸಗ್ಳೆ ದೆವಾಚೆ ರಾಜ್ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಯೆವ್ನ್ ಹೊಲಾ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ಎಕ್ ಘರಾತ್ಲ್ಯಾ ಘಟ್ಮುಟ್ ಮಾನ್ಸಾಕ್ ಭಾಂದುನ್ ಘಾಲುಚ್ಯಾ ಅದ್ದಿ ತೆಚ್ಯಾ ಘರಾತ್ಲೆ ಸಾಮಾನ್ ಚೊರುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಹೊತಾ ಕಾಯ್? ಹೊಯ್ನಾ, ತೆಕಾ ಘಟ್ ಭಾಂದುನ್ ಘಾಲುನ್ ಮಾನಾ ತೆಚಿ ಸಾಮಾನಾ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ಜೊ ಕೊನ್ ಮಾಜೆ ವಾಂಗ್ಡಾ ನಾ, ತೊ ಮಾಜ್ಯಾ ವಿರೊದುಚ್; ಜೊ ಕೊನ್ ಮಾಕಾ ಗೊಳಾ ಕರುಕ್ ಮಜತ್ ಕರಿನಾ ತೊ ಮಾಳ್ಬರ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ತಸೆಮನುನ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಕೊನ್ಬಿ ಬುರ್ಶೆ ಬೊಲ್ಲ್ಯಾರ್ ನಾಹೊಲ್ಯಾರ್ ಪಾಪಾ ಕರಲ್ಲ್ಯಾಕ್ನಿ ಮಾಪಿ ಗಾವ್ತಾ, ಖರೆ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚ್ಯಾ ವಿರೊದ್ ಬುರ್ಶೆ ಬೊಲ್ತಾ ತೆಕಾ ಕನ್ನಾಚ್ ಮಾಪಿ ಗಾವಿನಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಚ್ಯಾ ವಿರೊದ್ ಬೊಲಲ್ಲ್ಯಾಕ್ನಿ ತರ್‍ಬಿ ಮಾಪಿ ಗಾವಿಲ್, ಖರೆ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚ್ಯಾ ವಿರೊದ್ ಜೆ ಕೊನ್ ಬೊಲ್ತಾ ತೆಕಾ ಅತ್ತಾ ಹೊಂವ್ದಿತ್, ಕನ್ನಾಬಿ ಹೊಂವ್ದಿತ್ ಮಾಪಿ ಗಾವಿನಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ಬರಿ ಫಳಾ ಗಾವುಚಿ ತರ್, ಬರೆ ಝಾಡ್ ರ್‍ಹಾವ್ಕ್ ಪಾಜೆ , ಜರ್ ಝಾಡ್ ರೊಗೆಸಿ ಹಾಯ್, ತರ್ ತುಕಾ ಬರಿ ಫಳಾ ಗಾವಿನ್ಯಾತ್. ಫಳಾಂಚ್ಯಾ ವೈನಾಚ್ ಎಕ್ ಝಾಡ್ ಕಸ್ಲೆ ಮನುನ್ ವಳ್ಕುಕ್ ಹೊತಾ,” ");
INSERT INTO kans_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ಸಾಪಾಚ್ಯಾ ಪಿಲ್ಲಾನೊ! ತುಮಿ ಬುರ್ಶೆ ರ್‍ಹಾತಾನಾ, ಬರೆ ಕಶೆ ಬೊಲುಕ್ ಹೊತಾ? ಜೆ ಕಾಯ್ ಮನಾತ್ ಹಾಯ್, ತೆಚ್ ತೊಂಡ್ ಬೊಲ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ಎಕ್ ಬರೊ ಮಾನುಸ್, ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ನಾ ಬರೆಚ್ ಭಾಯ್ರ್ ಕಾಡ್ತಾ. ಎಕ್ ಬುರ್ಸೊ ಮಾನುಸ್ ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ನಾ ಬುರ್ಶೆಚ್ ಭಾಯ್ರ್ ಕಾಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ತುಮ್ಕಾ ಯಾದ್ ರ್‍ಹಂವ್ದಿತ್, ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ ಸಗ್ಳೆ ಜಾನಾ ಉಪೆಗಾಕ್ ಪಡಿನಸಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ಬೊಲಲ್ಲ್ಯಾಚೊ ಲೆಕ್ಕ್ ದಿತಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ತುಮಿ ಚುಕ್ ಕರ್ಲ್ಯಾಸಿ ಕಾಯ್ ಚುಕ್ ಕರಿನಸ್ತಾನಾ ಹಾಸಿ ಮನುನ್ ದಾಕ್ವುನ್ ದಿವ್‍ಸಾಟಿ ತುಮ್ಚಿ ಝಡ್ತಿ ಕರ್‍ತಾನಾ ತುಮ್ಚ್ಯಾಚ್ ಗೊಸ್ಟಿಯಾಚ್ ವಾಪ್ರುನ್ ಹೊತ್ಯಾತ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ತನ್ನಾ ಉಲ್ಲೆ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲೆ ಅನಿ ಉಲ್ಲೆ ಫಾರಿಜೆವ್, “ಗುರುಜಿ, ಅಮ್ಕಾ ತಿಯಾ ಎಕ್ ಮೊಟೆ ವಿಚಿತ್ರ್ ಕರಲ್ಲೆ ಬಗುಕ್ ಪಾಜೆ,” ಮನುನ್ ಸಾಂಗುಕ್‍ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ತನ್ನಾ ಜೆಜುನ್ “ಹ್ಯಾ ಕಾಲಾಚಿ ಬುರ್ಶಿ ಅನಿ ದೆವಸ್ಪಾನ್‍ನಸಲ್ಲಿ ಲೊಕಾ ವಿಚಿತ್ರ್ ಇಚಾರ್‍ತ್ಯಾತ್, ಖರೆ ಜೊನಾ ಪ್ರವಾದ್ಯಾಚ್ಯಾ ವಿಚಿತ್ರಾ ಶಿವಾಯ್ ದುಸ್ರೆ ವಿಚಿತ್ರ್ ಹೆಂಕಾ ದಿವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ಜೊನಾ ತಿನ್ ದಿಸ್ ಅನಿ ತಿನ್ ರಾತ್ ಕಶೆ ಮಾಸೊಳಿಚ್ಯಾ ಪೊಟಾತ್ ರ್‍ಹಾಲೊ, ತಸೆಚ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್‍ಬಿ ತಿನ್ ದಿಸ್ ಅನಿ ತಿನ್ ರಾತ್ ಜಿಮ್ನಿಚ್ಯಾ ಭುತ್ತುರ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ ನಿನಿವೆಚಿ ಲೊಕಾ ಇಬೆ ರ್‍ಹಾವ್ನ್ ಹಿ ಪಿಳ್ಗಿ ಚುಕಿದಾರ್ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತ್ಯಾತ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜೊನಾನ್ ಸಾಂಗಟಲ್ಲೆ ತೆನಿ ಆಯಿಕ್ಲ್ಯಾನಿ, ಅನಿ ಪಾಪಾನಿತ್ನಾ ದೆವಾಕ್ಡೆ ಪರತ್ಲ್ಯಾನಿ, ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಹಿತ್ತೆ ಜೊನಾಚ್ಯಾನ್ಕಿ ಮೊಟೊ ಹಾಯ್!” ");
INSERT INTO kans_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ “ಶೆಬಾ ಮನ್ತಲ್ಯಾ ದೆಸಾಚಿ ರಾನಿ ಇಬೆ ರ್‍ಹಾವ್ನ್, ಹಿ ಪಿಳ್ಗಿ ಚುಕಿದಾರ್ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಅಪ್ನಾಚ್ಯಾ ದೆಸಾಕ್ನಾ ಸಗ್ಳಿ ವಾಟ್‍ಬರ್ ಚಲುನ್ಗೆತ್ ತಿ ಸಾಲ್ಮಾವಾಚ್ಯಾ ಶಾನ್‍ಪಾನಾಚೆ ಶಿಕಾಪ್ ಆಯ್ಕುಕ್ ಮನುನ್ ಯೆಲ್ಲಿ, ಖರೆ ಮಿಯಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಹಿತ್ತೆ ಸೊಲೊಮೊನಾಚ್ಯಾನ್ಕಿ ಮೊಟೊ ಎಕ್ಲೊ ಹಾಯ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ಗಿರೊ ಎಕ್ ಮಾನ್ಸಾತ್ನಾ ಭಾಯ್ರ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತೊ ಸಗ್ಳಾಕ್ಡೆ ವಾಳ್ಕ್ಯಾ ಜಾಗ್ಯಾ ವೈನಿ ಜಾತಾ ಅನಿ ಅಪ್ನಾಕ್ ರ್‍ಹಾವ್ಕ್ ಜಾಗೊ ಹುಡಕ್ತಾ. ತೆಕಾ ಖೈಬಿ ಜಾಗೊ ಗಾವಿನಸ್ಲ್ಯಾರ್, ");
INSERT INTO kans_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ತೊ ಗಿರೊ ಮಿಯಾ ಅನಿ ಪರ್ತುನ್ ಮಾಜ್ಯಾ ಘರಾಕ್ ಜಾತಾ ಮನ್ತಾ, ಅನಿ ಪರ್ತುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆಕಾ ಜಾಗೊ ಖಾಲಿ ದಿಸ್ತಾ ಅನಿ ಪವಿತ್ರ್ ಅನಿ ಬರೊ ದಿಸ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ತನ್ನಾ ತೊ ಗಿರೊ ಪರ್ತುನ್ ಜಾತಾ ಅನಿ ಅಪ್ನಾಚ್ಯಾನ್ಕಿ ಬುರ್ಶ್ಯಾ,ಸತ್ತ್ ಗಿರ್‍ಯಾಕ್ನಿ ವಾಂಗ್ಡಾ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಯೆತಾ. ಅನಿ ತಿ ಥೈ ರ್‍ಹಾತ್ಯಾತ್. ಸಗ್ಳೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ತೊ ಮಾನುಸ್ ಅದ್ದಿ ಹೊತ್ತ್ಯಾಚ್ಯಾನ್ಕಿ ಬುರ್ಶ್ಯಾ ಸ್ಥಿತಿಕ್ ಪಾವ್ತಾ. ಅತ್ತಾಚ್ಯಾ ಬುರ್ಶ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಸೆಚ್ ಹೊತಾ. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ಜೆಜು ಲೊಕಾನಿಕ್ಡೆ ಬೊಲುನ್ಗೆತುಚ್ ಹೊತ್ತೊ, ತನ್ನಾ ತೆಚಿ ಬಾಯ್‍ ಅನಿ ಭಾವಾ ಥೈ ಯೆಲಿ. ತೆಚೆಕ್ಡೆ ಬೊಲುಕ್ ಪಾಜೆ ಮನುನ್ ತೆನಿ ಭಾಯ್ರುಚ್ ಇಬೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ತಸೆಮನುನ್, ಲೊಕಾನಿತ್ಲೊ ಎಕ್ಲೊ ಜೆಜುಕ್ \"ತುಜಿ ಬಾಯ್ ಅನಿ ಭಾವಾ ಭಾಯ್ರ್ ಯೆವ್ನ್ ಇಬೆ ರ್‍ಹಾಲ್ಯಾತ್, ತೆಂಕಾ ತುಜೆಕ್ಡೆ ಬೊಲುಕ್ ಪಾಜೆ ಮನಿ, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ಜೆಜುನ್ ತೆಕಾ ಮಾಜಿ ಬಾಯ್ ಕೊನ್? ಮಾಜಿ ಭಾವಾ ಕೊನ್? ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ತನ್ನಾ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ದಾಕ್ವುನ್ಗೆತ್, ಅಬಕ್! ಹಿತ್ತೆ ಹಾಯ್ ಮಾಜಿ ಬಾಯ್, ಅನಿ ಮಾಜಿ ಭಾವಾ! ");
INSERT INTO kans_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ಜೆ ಕೊನ್ ಸರ್ಗಾ ವೈಲ್ಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ ಕಶೆ ಪಾಜೆ ತಸೆ ಕರ್‍ತಾ, ತೊಚ್ ಮಾಜೊ ಭಾವ್, ಮಾಜಿ ಭೆನ್, ಅನಿ ಮಾಜಿ ಬಾಯ್, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ತ್ಯಾಚ್ ದಿಸಿ ಜೆಜು ಘರಾತ್ನಾ ಭಾಯ್ರ್ ಗೆಲೊ ಅನಿ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆಕ್ ಜಾವ್ನ್ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ಥೈ ಗೊಳಾ ಹೊಲ್ಲೊ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಲೈ ಮೊಟೊ ಹೊತ್ತೊ ತಸೆಮನುನ್ ಜೆಜು ಎಕ್ ಢೊನಿತ್ ಚೆಡುನ್ ಬಸ್ಲೊ. ತನ್ನಾ ಲೊಕಾ ದಂಡೆಕ್ ಇಬೆ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ಸುಮಾರ್ ವಿಶಯಾ ಸಾಂಗುಕ್ ಮನುನ್ ತೊ ಕಾನಿಯಾ ವಾಪ್ರಿ. ತನ್ನಾ ತೆನಿ, “ಎಗ್ದಾ ಎಕ್ ಶೆತ್ಕಾರಿ ಹೊತ್ತೊ ತೊ ಭ್ಹಿಂಯ್ ಸಿಪ್ಡುಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ತೊ ಶೆತಾತ್ ಭ್ಹಿಂಯ್ ಸಿಪುನ್ಗೆತ್ ಜಾತಾನಾ ತ್ಯಾತುರ್‍ಲೆ ಉಲ್ಲೆ ಭ್ಹಿಂಯ್ ವಾಟೆಚ್ಯಾ ದಂಡೆಕ್ ಪಡ್ಲೆ. ಫಾಂಕ್ರಾ ಯೆಲಿ ಅನಿ ತೆ ಭ್ಹಿಂಯ್ ಖಾವ್ನ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ಅನಿ ಉಲ್ಲೆಸೆ ಭ್ಹಿಂಯ್ ಗುಂಡ್ಯಾಚೊ ತಳಾಪ್ ಹೊತ್ತ್ಯಾ ಜಿಮ್ನಿರ್ ಪಡ್ಲೆ ಥೈ ಮಾಟಿ ಲೈ ಪಾತೊಳ್ ಹೊತ್ತಿ. ಥೈ ವೈಲ್ಯಾ-ವೈರ್ ಮಾಟಿ ಹೊತ್ತಿ ತಸೆಮನುನ್ ಬಿ ಲಗ್ಗುನಾಚ್ ತೆ ಉಗಾವ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ಖರೆ ನಿಂಬಾರ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತಿ ಕವ್ಳಿ ಝಾಡಾ ಭಾಜುನ್ ಗೆಲಿ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಂಚಿ ಮುಳಾ ಮಾಟಿತ್ ಭುತ್ತುರ್ ಉತ್ರುಕ್‍ನತ್ತಿ, ತಸೆಮನುನ್ ತಿ ಝಾಡಾ ಬಾಡುನ್ ವಾಳುನ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ಉಲ್ಲೆಸೆ ಭ್ಹಿಂಯ್ ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಪಡ್ಲೆ, ತೆ ಭ್ಹಿಂಯ್ ಉಗಾವ್ಲೆ, ಖರೆ ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಗಾವುನ್ ಚಿರ್ಡುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ಅನಿ ಅನಿಉಲ್ಲೆಸೆ ಭ್ಹಿಂಯ್, ಬರ್‍ಯಾ ಮಾಟಿತ್ ಪಡ್ಲೆ, ಅನಿ ಝಾಡಾ ಹೊಲಿ, ಝಾಡಾಕ್ನಿ ಕನ್ಸಾ ಹೊಲಿ. ಉಲ್ಲ್ಯಾ ಬಿಯ್ಯಾನ್ ಸೆಂಬರ್ ದಾನೆ ದಿಲ್ಯಾನ್, ಉಲ್ಲ್ಯಾನ್ ಸಾಟ್, ಅನಿ ಉಲ್ಲ್ಯಾನ್ ತಿಸ್ ದಾನೆ ದಿಲ್ಯಾನ್”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ಅನಿ “ತುಮ್ಕಾ ಆಯ್ಕುಕ್ ಕಾನಾ ರ್‍ಹಾಲ್ಯಾರ್, ಆಯ್ಕಾ!” ಮನುನ್ ಸಾಂಗುನ್ ಜೆಜುನ್ ಕಾನಿ ಮುಗಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ತನ್ನಾ ಶಿಸಾ ಜೆಜುಕ್ಡೆ ಯೆಲಿ ಅನಿ ಜೆಜುಕ್, “ ತಿಯಾ ಲೊಕಾನಿಕ್ನಾ ಬೊಲ್ತಾನಾ ಕಾನಿಯಾಂಚ್ಯಾ ವೈನಾಚ್ ಕಶ್ಯಾಕ್ ಬೊಲ್ತೆಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾಚ್ಯಾ ವಿಶಯಾತ್ ಹೊತ್ತ್ಯಾ ಘುಟಾಚಿ ಬುದ್ವಂತ್ಕಿ, ತುಮ್ಕಾ ಎವ್ಡಿಚ್ ದಿಲ್ಲಿ ಹಾಯ್, ತೆಂಕಾ ದಿಲ್ಲಿ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ಜ್ಯಾ ಮಾನ್ಸಾಕ್ಡೆ ಉಲ್ಲೆಸೆಬಿ ಶಾನ್ಪಾನ್ ಹಾಯ್ ತೆಕಾ ಜಾಸ್ತಿಚೆ ಶಾನ್ಪಾನ್ ದಿವ್ನ್ ಹೊತಾ, ತೆಚೆಸಾಟ್ನಿ ತೆಚೆಕ್ಡೆ ತೆಕಾ ಫಿರೆ ಹೊವ್ನ್ ಜಾಸ್ತಿಚೆ ಶಾನ್ಪಾನ್ ರ್‍ಹಾತಾ; ಖರೆ ಜೆ ಖಲ್ಯಾ ಮಾನ್ಸಾಕ್ಡೆ ಉಲ್ಲೆಬಿ ಶಾನ್ಪಾನ್ ನಾ ತೆಚೆಕ್ಡೆ ಹೊತ್ತೆಬಿ ಉಲ್ಲೆಸೆ ಕಾಡುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ಮಿಯಾ ತೆಂಚ್ಯಾಕ್ಡೆ ಕಾನಿಯಾಂಚ್ಯಾ ವೈನಾ ಕಶ್ಯಾಕ್ ಬೊಲ್ತಾ ಮಟ್ಲ್ಯಾರ್, ತೆನಿ ಬಗ್ತ್ಯಾತ್, ಖರೆ ತೆಂಕಾ ದಿಸಿನಾ, ಅನಿ ತೆನಿ ಆಯಿಕ್ತ್ಯಾತ್ ಖರೆ ತೆಂಕಾ ಕಳಿನಾ”. ");
INSERT INTO kans_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“ತೆಚೆಸಾಟ್ನಿ ದೆವಾನ್ ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾಚ್ಯಾ ಮುಕಾಂತ್ರ್ ಸಾಂಗಲ್ಲೆ ಪುರಾ ಹೊತಾ, ಹಿ ಲೊಕಾ ಆಯಿಕ್ತ್ಯಾತ್ ಅನಿ ಆಯಿಕ್ತ್ಯಾತ್, ಖರೆ ತೆಂಕಾ ಕನ್ನಾಚ್ ಕಳಿನಾ; ತೆನಿ ಬಗ್- ಬಗ್ತ್ಯಾತ್ ಖರೆ, ತೆಂಕಾ ದಿಸಿನಾ, ");
INSERT INTO kans_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆಂಚಿ ಟಕ್ಲಿ ಮಡ್ಡ್ ಹೊವ್ನ್ ಗೆಲ್ಯಾತ್, ಅನಿ ತೆನಿ ಆಯಿಕ್ತಲೆ ಬಂದ್ ಕರುನ್ ಸೊಡ್ಲ್ಯಾನಾತ್, ಅನಿ ತೆನಿ ಅಪ್ನಾಚೆ ಡೊಳೆ ಧಾಪುನ್ ಘೆಟ್ಲ್ಯಾನಾತ್. ನಾಹೊಲ್ಯಾರ್, ತೆಂಚ್ಯಾ ಡೊಳ್ಳಾಕ್ನಿ ದಿಸಿ ಹೊತ್ತೆ, ತೆಂಚ್ಯಾ ಕಾನಾಕ್ನಿ ಆಯ್ಕಿ ಹೊತ್ತೆ. ತೆಂಕಾ ಅರ್ತ್‍ ಕರುನ್ ಘೆವ್ಕ್ ಹೊಯ್ ಹೊತ್ತೆ, ಅನಿ ತೆನಿ ಮಾಜೆಕ್ಡೆ ಪರ್‍ತಿ ಹೊತ್ತೆ. ಅನಿ ಮಿಯಾ ತೆಂಕಾ ಮಾಪ್ ಕರಿ ಹೊತ್ತೊ”. ");
INSERT INTO kans_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ಖರೆ ತುಮಿ, ಕವ್ಡೆ ಸುಖಿ! ತುಮ್ಚ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ದಿಸ್ತಾ ಅನಿ ತುಮ್ಚ್ಯಾ ಕಾನಾಕ್ನಿ ಆಯಿಕ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಲೈ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಅನಿ ದೆವಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ, ತುಮಿ ಬಗಟಲ್ಲೆ ಬಗುಕ್ ಅನಿ ಆಯ್ಕುಕ್ ಮನ್ ಹೊತ್ತೊ. ಖರೆ ತೆಂಕಾ ಬಗುಕ್ ಅನಿ ಆಯ್ಕುಕ್ ಹೊವ್ಕ್ ನಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ಆಯ್ಕಾ ತರ್, ಭ್ಹಿಂಯ್ ಸಿಪ್ತಲ್ಯಾಚ್ಯಾ ಕಾನಿಚೊ ಅರ್ತ್‍ ಕಾಯ್ ಮನುನ್ ಕಳ್ವುನ್ ಘೆವಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಆಯಿಕ್ತ್ಯಾತ್, ಖರೆ ತೆಂಕಾ ಅರ್ತ್‍ ಹೊಯ್ನಾ. ಹಿ ಲೊಕಾ ವಾಟೆಚ್ಯಾ ದಂಡೆಕ್ ಪಡಲ್ಲ್ಯಾ ಭ್ಹಿಂಯಾ ಬಾಸೆನ್. ಸೈತಾನ್ ಯೆತಾ ಅನಿ ತೆಂಚ್ಯಾ ಮನಾತ್ ಸಿಪಡಲ್ಲೆ ಭ್ಹಿಂಯ್ ಕಾಡುನ್ ಘೆವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ಗುಂಡ್ಯಾಚೊ ತಳಾಪ್ ಹೊತ್ತ್ಯಾ ಜಾಗ್ಯಾರ್ ಪಡಲ್ಲೆ ಭ್ಹಿಂಯ್ ಮಟ್ಲ್ಯಾರ್, ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಕುಶಿನ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಬಾಸೆನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ಖರೆ ತ್ಯಾ ಗೊಸ್ಟಿಯಾ ತೆಂಚ್ಯಾ ಮನಾತ್ ಎಗ್ದಮ್ ಭುತ್ತುರ್ ಗೆಲ್ಲ್ಯಾ ರ್‍ಹಾಯ್ನಾ, ಅಶೆ ತೆನಿ ಲೈ ಎಳ್ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿ ಸರ್ಕೆ ಚಲಿನ್ಯಾತ್. ದೆವಾಚ್ಯಾ ಬರ್‍ಯಾ ಖಬ್ರೆಸಾಟ್ನಿ ಕಸ್ಟ್ ನಾ ತರ್ ತರಾಸ್ ತೆಂಕಾ ಯೆಲೊ ತರ್, ಎಗ್ದಮ್ ತೆನಿ ತೆ ಸೊಡುನ್ ಸೊಡ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಪಡಲ್ಲೆ ಭ್ಹಿಂಯ್ ಮಟ್ಲ್ಯಾರ್, ಜಿ ಲೊಕಾ ದೆವಾಚೆ ಉತರ್ ಆಯಿಕ್ತ್ಯಾತ್; ಖರೆ ಹ್ಯಾ ಬಾಳ್ವಿಚ್ಯಾ ಯವ್ಜನ್ಯಾ ಅನಿ ಸಾವ್ಕಾರ್ಕಿ ಜೊಡ್ತಲಿ ಆಶಾ ದೆವಾಚ್ಯಾ ಬರ್‍ಯಾ ಖಬ್ರೆಕ್ ದಡ್ಪುನ್ ಧರ್‍ತಾ, ಅನಿ ತೆಂಕಾ ಫಳ್ ದಿವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ಬರ್‍ಯಾ ಮಾಟಿತ್ ಸಿಪಡಲ್ಲೆ ಭ್ಹಿಂಯ್ ಮಟ್ಲ್ಯಾರ್, ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಆಯ್ಕುನ್ ಅರ್ತ್‍ ಕರುನ್ ಘೆಟಲ್ಲಿ ಲೊಕಾ. ತೆಂಚ್ಯಾತ್ಲಿ ಉಲ್ಲಿ ಲೊಕಾ, ಸೆಂಬರಾಕ್ ಸೆಂಬರ್ ಫಳ್ ದಿತ್ಯಾತ್, ಉಲ್ಲೆ ಜಾನಾ ಸಾಟ್, ಅನಿ ಉಲ್ಲೆ ಜಾನಾ ತಿಸ್”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ಮಾನಾ ಜೆಜುನ್ ತೆಂಕಾ ಅನಿ ಎಕ್ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್. ಸರ್ಗಾಚೊ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್, ಎಕ್ ಮಾನ್ಸಾನ್ ಅಪ್ನಾಚ್ಯಾ ಶೆತಾತ್ ಬರೆ ಭ್ಹಿಂಯ್ ಪೆರಲ್ಲ್ಯಾ ಸರ್ಕೆ. ");
INSERT INTO kans_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ಎಕ್ ದಿಸ್ ರಾಚ್ಚೆ ಸಗ್ಳೆ ಜಾನಾ ನಿಜಲ್ಲ್ಯಾ ತನ್ನಾ ದುಸ್ಮಾನ್ ಯೆತಾ ಅನಿ ಘಂವಾಚ್ಯಾ ಮದ್ದಿ ಕಳ್ಯಾಂಚೆ ಭ್ಹಿಂಯ್ ಸಿಪ್ಡುನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ಝಾಡಾ ಮೊಟಿ ಹೊವ್ನ್ ಕನ್ಸಾ ಯೆವ್ನ್ ಪಿಕುಕ್ ತಯಾರ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಕಳೆ ದಿಸುಕ್‍ ಲಾಗ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾಚಿ ಅಳಾ ಯೆಲಿ. ಅನಿ “ಧನಿಯಾಕ್, ತುಮ್ಚ್ಯಾ ಶೆತಾತ್ ತುಮಿ ಬರೆ ಭ್ಹಿಂಯ್ ಪೆರಲ್ಲ್ಯಾಶಿ ನ್ಹಯ್; ತರ್ ಕಳೆ ಖೈತ್ನಾ ಯೆಲೆ?” ಮನುನ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ತನ್ನಾ ತೆನಿ “ಕೊನ್ಕಿ ದುಸ್ಮಾನಾನ್ ಕರಲ್ಲೆ ಕಾಮ್ ತೆ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ಆಳಾನಿ, “ಅಮಿ ಜಾವ್ನ್ ತಿ ಕಳ್ಯಾಂಚಿ ಝಾಡಾ ಉಪ್ಸುನ್ ಕಾಡುಚೆ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ತನ್ನಾ ಧನಿಯಾನ್ “ನಕ್ಕೊ ಕಳೆ ಉಪ್ಸುನ್ ಕಾಡ್ತಾನಾ, ಘವಾಚಿ ಝಾಡಾಬಿ ಉಪ್ಸುನ್ ಕಾಡ್ಸಿಲಾ, ");
INSERT INTO kans_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ಸುಗ್ಗಿ ಯೆಯ್‍ ಪತರ್ ಕಳೆಬಿ ಘವ್‍ಬಿ ವಾಂಗ್ಡಾಚ್ ರ್‍ಹಂವ್ದಿ, ತನ್ನಾ ಸುಗ್ಗಿಚ್ಯಾ ದಿಸಿ ಕಾಮ್ ಕರ್‍ತಲ್ಯಾಕ್ನಿ ಮಿಯಾ ಅದ್ದಿ ಕಳೆ ಉಪ್ಸುನ್ ಕಾಡುನ್ ಜಾಳ್ವುನ್ ಟಾಕುಸಾಟ್ನಿ ಪೆಂಡಿಯಾ ಭಾಂದಾ ಅನಿ ಮಾನಾ ಘವ್ ಗೊಳಾ ಕರಾ ಅನಿ ಮಾಜ್ಯಾ ತಟ್ಟ್ಯಾತ್ ಭರುನ್ ಥವಾ ಮನುನ್ ಮಿಯಾ ಸಾಂಗ್ತಾ”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ಜೆಜುನ್ ತೆಂಕಾ ಅನಿಎಕ್ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್, “ಸರ್ಗಾಚೊ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್, ಎಕ್ ಮಾನುಸ್ ಎಕ್ ಸಾಸಾವಾಚಿ ಭ್ಹಿಂಯ್ ಘೆತಾ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಶೆತಾತ್ ಉಗಾತ್ ಘಾಲ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ಹೆ ಭ್ಹಿಂಯ್ ಸಗ್ಳಾಂಚ್ಯಾನ್ಕಿ ಬಾರಿಕ್ ಖರೆ ತೆ ಮೊಟೆ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಸಗ್ಳ್ಯಾ ಝಾಡಾಂಚ್ಯಾನ್ಕಿ ಮೊಟೆ ಝಾಡ್ ಹೊತಾ. ತಸೆಮನುನ್ ಮಳ್ಬಾ ವೈಲಿ ಫಾಂಕ್ರಾ ಯೆತ್ಯಾತ್ ಅನಿ ತೆಚ್ಯಾ ಟಾಳಿಯಾಕ್ನಿ ಘಂಟೆ ಭಾಂದ್ತ್ಯಾತ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ಜೆಜುನ್ ತೆಂಕಾ, ಅನಿಎಕ್ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್: “ಸರ್ಗಾಚೊ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್, ಎಕ್ ಬಾಯ್ಕೊಮನುಸ್ ಸೊಡಾ ಘೆತಾ ಅನಿ ತಿನ್ ಶೆರ್ ಪಿಟ್ಟಾತ್ ಘಾಲುನ್ ಥವ್ತಾ ಅನಿ ತೆ ಪಿಟ್ಟ್ ಸಗ್ಳೆ ಫುಗ್ತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ಹೆ ಸಗ್ಳೆ ಸಾಂಗುಕ್ ಜೆಜು ಕಾನಿಯಾಚ್ ವಾಪ್ರಿ. ತೊ ಕಾನಿನಸ್ತಾನಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಕಾಯ್ಬಿ ಹೊಂವ್ದಿ ಸಾಂಗಿನಸಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ತುಮ್ಚ್ಯಾಕ್ಡೆ ಬೊಲ್ತಾನಾ ಮಿಯಾ ಕಾನಿಯಾ ವಾಪರ್‍ತಾ. ಜಗ್ ರಚಲ್ಲ್ಯಾಕ್ನಾ ನಿಪುನ್ ಹೊತ್ತೆ ಸಗ್ಳೆ ಮಿಯಾ ತೆಂಕಾ ಸೊಡ್ಸುನ್ ಸಾಂಗ್ತಾ. ಮನುನ್ ಪ್ರವಾದ್ಯಾನಿ ಸಾಂಗಟಲ್ಲೆ ಖರೆ ಮನುನ್ ದಾಕ್ವುಸಾಟ್ನಿ ತೆನಿ ಅಶೆ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ಜೆಜು ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಸೊಡುನ್ ಭುತ್ತುರ್ ಘರಾತ್ ಗೆಲೊ. ತನ್ನಾ ತೆಚಿ ಶಿಸಾ ತೆಚೆಕ್ಡೆ ಯೆಲಿ. ಅನಿ,“ಶೆತಾತ್ಲ್ಯಾ ಕಳ್ಯಾಂಚ್ಯಾ ಕಾನಿಚೊ ಅರ್ತ್‍ ಅಮ್ಕಾ ಸಾಂಗ್.” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ಜೆಜುನ್ ತೆಂಕಾ, “ಬರೆ ಭ್ಹಿಂಯ್ ಪೆರ್‍ತಲೊ ಮಟ್ಲ್ಯಾರ್, ಮಾನ್ಸಾಚೊ ಲೆಕ್. ");
INSERT INTO kans_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ಶೆತ್ ಮಟ್ಲ್ಯಾರ್ ಹ್ಯೊ ಜಗ್ ಬರೆ ಭ್ಹಿಂಯ್ ಮಟ್ಲ್ಯಾರ್, ದೆವಾಚ್ಯಾ ರಾಜಾಕ್ ಸಮಂದ್‍ ಪಡಲ್ಲಿ ಲೊಕಾ. ಕಳೆ ಮಟ್ಲ್ಯಾರ್, ಸೈತಾನಾಕ್ ಸಮಂದ್‍ ಪಡಲ್ಲಿ ಲೊಕಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ಅನಿ ಕಳೆ ಪೆರ್‍ತಲೊ ದುಸ್ಮಾನ್ ಮಟ್ಲ್ಯಾರ್, ಗಿರೊ. ಸುಗ್ಗಿಚೊ ಕಾಲ್ ಮಟ್ಲ್ಯಾರ್ ಜಗಾಚೊ ಅಕ್ರಿಚೊ ಕಾಲ್. ಸುಗ್ಗಿಚ್ಯಾ ಕಾಲಾಚೆ ಕಾಮ್ಗಾರಿ ಮಟ್ಲ್ಯಾರ್, ದೆವಾಚಿ ದುತಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ಕಶೆ ಕಳೆ ಕಾಡುನ್ ಆಗಿತ್ ಘಾಲುನ್ ಜಾಳ್ವುನ್ ಹೊತಾ, ಹ್ಯಾ ಜಗಾಚ್ಯಾ ಅಕ್ರಿಚ್ಯಾ ಕಾಲಾತ್‍ಬಿ ತಸೆಚ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಅಪ್ನಾಚ್ಯಾ ದುತಾಕ್ನಿ ಧಾಡುನ್ ಅಪ್ನಾಚ್ಯಾ ರಾಜಾತ್ಲ್ಯಾ ಪಾಪಾಕ್ ಕಾರನ್ ಹೊಲ್ಲ್ಯಾ ಅನಿ ಬುರ್ಶಿ ಕಾಮಾ ಕರಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಗೊಳಾ ಕರುಕ್ ಲಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ಅನಿ ತಿ ದೆವಾಚಿ ದುತಾ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಜಳ್ತಲ್ಯಾ ಆಗಿತ್ ಟಾಕ್ತ್ಯಾತ್. ಥೈ ತೆನಿ ರಡ್ತ್ಯಾತ್ ಅನಿ ಕಟ್‍ಕಟ್‍ ದಾತಾ ಚಾವ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ತನ್ನಾ ದೆವಾಚಿ ಲೊಕಾ ತೆಂಚ್ಯಾ ದೆವಾ ಬಾಬಾಚ್ಯಾ ರಾಜಾತ್ ದಿಸ್ ಹೊಳಾವ್ತಲ್ಯಾ ಸರ್ಕೆ ಹೊಳ್ವುತ್ಯಾತ್. ಕೊನಾಕ್ ಕಾನಾ ತೆನಿ ಆಯ್ಕುಂದಿತ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ಸರ್ಗಾಚೊ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್ ಅಶೆ, ಎಕ್ ಮಾನ್ಸಾಕ್ ಎಕ್ ಶೆತಾತ್ ಬದಿಕ್ ಗಾವ್ತಾ, ತೊ ತೆ ಅನಿ ಪರ್ತುನ್ ಧಾಪುನ್ ಥವ್ತಾ, ತೆಚೆಸಾಟ್ನಿ ತೊ ಲೈ ಕುಶಿ ಹೊತಾ ಅನಿ ಜಾವ್ನ್ ಅಪ್ನಾಚೆ ಹೊತ್ತೆ ಸಗ್ಳೆ ಇಕ್ತಾ ಅನಿ ಯೆವ್ನ್ ತೆ ಶೆತ್ ತೊ ಇಕಾತ್ ಘೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ಸರ್ಗಾಚೊ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್ ಅಸೆಬಿ ಮನುಕ್ ಹೊತಾ. ಎಕ್ ಮೊತಿಯಾಂಚೊ ಯಾವಾರ್ ಕರ್‍ತಲೊ ಮಾನುಸ್ ಎಗ್ದಮ್ ಬರ್‍ಯಾ ಮೊತಿಯಾ ಹುಡ್ಕುನ್ಗೆತ್ ಜಾತಾ , ");
INSERT INTO kans_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ಅನಿ ತೆಕಾ ಬರಿಲಿ ಮೊತಿ ಗಾವ್ತಾ. ತನ್ನಾ ತೊ ಜಾವ್ನ್ ಅಪ್ನಾಚೆ ಸಗ್ಳೆ ಇಕ್ತಾ ಅನಿ ತಿ ಮೊತಿ ಇಕಾತ್ ಘೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ಸರ್‍ಗಾಚೆ ರಾಜ್ ಅಸೆಬಿ ಮನುಕ್ ಹೊತಾ. ಉಲ್ಲೆ ಮಾಸೊಳ್ಯಾಕಾರ್ ಸಮುಂದರಾತ್ ಮಾಸೊಳ್ಯಾ ಧರುಕ್ ಮನುನ್ ಜಾಳೆ ಸೊಡ್ತ್ಯಾತ್ ಅನಿ ತ್ಯಾ ಜಾಳ್ಯಾತ್ ಸಗ್ಳ್ಯಾ ಜಾತಿಚ್ಯಾ ಮಾಸೊಳ್ಯಾ ಶಿರಕ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ಜಾಳೆ ಭರಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ತೆ ಜಾಳೆ ವೊಡುನ್ ಭಾಯ್ರ್ ದಂಡೆಕ್ ಹಾನ್ತ್ಯಾತ್ ಅನಿ ಸಗ್ಳ್ಯಾ ಮಾಸೊಳ್ಯಾ ಎಗ್ಳುನ್ ಕಾಡ್ತ್ಯಾತ್. ಬರ್‍ಯಾ ಮಾಸೊಳ್ಯಾ ತೆಂಚ್ಯಾ ಭುಟ್ಟಿತ್ ಘಾಲ್ತ್ಯಾತ್ ಅನಿ ನಕ್ಕೊ ಹೊಲ್ಲ್ಯಾ ಮಾಸೊಳ್ಯಾ ಧುರ್ ಟಾಕುನ್ ಹೊತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ಜಗಾಚ್ಯಾ ಅಕ್ರಿಚ್ಯಾ ಕಾಲಾತ್ ಅಸೆಚ್ ಹೊತಾ. ದೆವಾಚಿ ದುತಾ ಯೆವ್ನ್ ಬರ್‍ಯಾ ಲೊಕಾಂಚ್ಯಾ ಮದ್ದಿ ಹೊತ್ತ್ಯಾ, ಬುರ್ಶ್ಯಾ ಲೊಕಾಕ್ನಿ ಎಚುನ್ ಕಾಡ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ಅನಿ ತೆಂಕಾ ಪೆಟ್ತಲ್ಯಾ ಆಗಿತ್ ಟಾಕ್ತ್ಯಾತ್. ಥೈ ತೆನಿ ರಡುನ್ಗೆತ್ ಬೊಬ್ ಮಾರ್‍ತ್ಯಾತ್ ಅನಿ ಕಟ್‍ಕಟ್ ದಾತಾ ಚಾವ್ತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ತನ್ನಾ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ, ಹೆ ಸಗ್ಳೆ ತುಮ್ಕಾ ಕಳ್ಳೆ ಕಾಯ್? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ಶಿಸಾನಿ “ಹೊಯ್,” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ತನ್ನಾ ಜೆಜುನ್, “ತಸೆಮಟ್ಲ್ಯಾರ್, ತನ್ನಾ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾತ್ ಹರಿ ಎಕ್ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲೊ ಎಕ್ ಸಿಸ್ ಹೊತಾ ದೆವಾಚ್ಯಾ ರಾಜಾಚೆ ಮನುನ್ ಹೊತ್ತೆ ಸಾಮಾನಾ ಥವ್ತಲ್ಯಾ ಖೊಲಿತ್ನಾ ನ್ಹವಿ ಅನಿ ಜುನ್ನಿ ಸಾಮಾನಾ ಭಾಯ್ರ್ ಕಾಡ್ತಲ್ಯಾ ಘರಾಚ್ಯಾ ವ್ಹಡಿಲಾ ಸರ್‍ಕೊ,” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ಹ್ಯಾ ಸಗ್ಳ್ಯಾ ಕಾನಿಯಾ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್ ");
INSERT INTO kans_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ಅಪ್ನಾಚ್ಯಾ ಸ್ವಂತ್ ಗಾವಾಕ್ ಗೆಲೊ. ಥೈ ಸಿನಾಗೊಗಾತ್, ತೆನಿ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುಲ್ಯಾನ್, ಅನಿ ತೆನಿ ಶಿಕ್ವುತಲೆ ಆಯ್ಕಲ್ಲಿ ಲೊಕಾ ಅಜಾಪ್ ಹೊಲಿ. ಅನಿ, “ಎವ್ಡೆ ಸಗ್ಳೆ ಶಾನ್‍ಪಾನ್ ಹೆಕಾ ಖೈತ್ನಾ ಗಾವ್ಲೆ? ಅನಿ ಹ್ಯೊ ಎವ್ಡಿ ಮೊಟಿ ವಿಚಿತ್ರ್ ಕಾಮಾ ಕಶೆ ಕರುನ್ ಕರ್‍ತಾ? ");
INSERT INTO kans_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ಹ್ಯೊ ಎಕ್ ಬಡಗಿಯಾಚೊ ಲೆಕ್ ನ್ಹಯ್ ಕಾಯ್? ಮರಿ ಹೆಚಿ ಬಾಯ್, ಅನಿ ಜಾಕೊಬ್, ಜುಜೆ, ಸಿಮಾವ್, ಅನಿ ಜುದಾಸ್ ಹೆಚಿ ಭಾವಾ ನ್ಹಯ್ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ಹೆಚ್ಯಾ ಭೆನಿಯಾ ಹಿತ್ತೆಚ್ ರ್‍ಹಯ್‌ನ್ಯಾತ್ ಕಾಯ್? ಹೆ ಸಗ್ಳೆ ಹೆಕಾ ಖೈತ್ನಾ ಗಾವ್ಲೆ?” ಮನುನ್ ಎಕಾಮೆಕಾಕ್ ಇಚಾರುನ್ ಘೆವ್ಕ್‌ಲಾಗ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ಅಶೆ ತ್ಯಾ ಲೊಕಾ ಜೆಜುಕ್ ಕಿಮ್ಮತ್ ದಿವ್ಕನ್ಯಾತ್. ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ಅಪ್ನಾಚೆ ಗಾಂವ್ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಘರ್‍ಚ್ಯಾ ಲೊಕಾತ್ನಿ ಸೊಡುನ್ ಎಕ್ ಪ್ರವಾದಿ ಖೈಬಿ ಜಾಂವ್ದಿತ್, ಸಗ್ಳ್ಯಾಕ್ಡೆ ತೆಕಾ ತೆಚಿ ಮರ್‍ಯಾದ್ ಗಾವ್ತಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ತೆಂಕಾ ವಿಶ್ವಾಸ್‍ ನಸಲ್ಲ್ಯಾಸಾಟ್ನಿ ಜೆಜುನ್ ಥೈ ಲೈ ವಿಚಿತ್ರ್ ಕಾಮಾ ಕರುಕ್‍ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ತ್ಯಾ ಎಳಾರ್ ಗಾಲಿಲಿಯಾಚೊ ರಾಜಾ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ಹೆರೊದಾನ್ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಆಯಿಕ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ತನ್ನಾ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಕ್ನಿ, “ತೊ ಖರೆಚ್ ಜುವಾಂವ್ ಬಾವ್ತಿಸ್ ಮರಲ್ಲೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಯೆಲಾ, ತಸೆ ಮನುನ್ ತೆಕಾ ಮೊಟಿ ವಿಚಿತ್ರ್ ಕಾಮಾ ಕರ್‍ತಲಿ ತಾಕತ್ ಹಾಯ್,” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ಅದ್ದಿ ಹೆರೊದಾನ್ ಜುವಾಂವಾಕ್ ಧರುನ್ ಹಾನುಕ್ ಹುಕುಮ್ ದಿಲ್ಲ್ಯಾನ್ ಅನಿ ತೆಕಾ ಸರ್‍ಪೊಳಿನಿ ಭಾಂದುನ್ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಟಲ್ಲ್ಯಾನ್. ತೆಚ್ಯಾ ಭಾವಾಚ್ಯಾ ಪಿಲಿಪಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಹೆರೊದಿಯಾಸಾಕ್ ಲಾಗುನ್ ತೆನಿ ಅಶೆ ಕರಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ಎಕ್ ಉಲ್ಲೆಂದಾ ಜುವಾಂವ್ ಬಾವ್ತಿಸ್ ಹೆರೊದಾಕ್, “ತಿಯಾ ಹೆರೊದಿಯಾಸಾಕ್ಡೆ ನಗಿನ್ ಹೊತಲೆ ಖಾಯ್ದ್ಯಾಚ್ಯಾ ವಿರೊದ್ ಹಾಯ್”. ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ಹೆರೊದ್ ಜುವಾಂವಾಕ್ ಜಿವಾನಿ ಮಾರುಕ್ ಬಗಿ, ಖರೆ ತೊ ಜುದೆವ್ ಲೊಕಾಕ್ನಿ ಭಿಂವಲ್ಲೊ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಜುವಾಂವ್ ಎಕ್ ಪ್ರವಾದಿ ಮನುನ್ ಮಾನುನ್ ಘೆಯ್ತ್. ");
INSERT INTO kans_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ಹೆರೊದಾಚ್ಯಾ ಜಲ್ಮಾಚ್ಯಾ ದಿಸಿ ಹೆರೊದಿಯಾಸಾಚ್ಯಾ ಲೆಕಿನ್ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ನಾಚ್ಲಿನ್ ತಸೆಮನುನ್ ಹೆರೊದಾಕ್ ಲೈ ಕುಶಿ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ತನ್ನಾ ಹೆರೊದಾನ್ ತಿಕಾ,“ಹೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ಆನ್ ಘಾಲುನ್ ಸಾಂಗ್ತಾ ತಿಯಾ ಕಾಯ್ ಮಾಗಟ್ಲ್ಯಾರ್‍ಬಿ, ಮಿಯಾ ತುಕಾ ದಿತಾ”. ಮನುನ್ ಗೊಸ್ಟ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್‍ಕಡೆ ಇಚಾರುನ್ ಘೆಟ್ಲಿನ್. ತನ್ನಾ ತೆನಿ ರಾಜಾಕ್ಡೆ, “ ಹಿತ್ತೆ ಅತ್ತಾಚ್ ಮಾಕಾ ಜುವಾಂವ್ ಬಾವ್ತಿಸಾಚೆ ಟಕ್ಲೆ ಎಕ್ ಆಯ್ದಾನಾತ್ನಾ ಪಾಜೆ!” ಮನುನ್ ಮಾಗಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ರಾಜಾಕ್ ಬೆಜಾರ್ ದಿಸ್ಲೊ. ಖರೆ ಸಗ್ಳ್ಯಾ ಯೆಲ್ಲ್ಯಾ ಸೊಯ್ರ್ಯಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ದಿಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಕ್‍ಲಾಗುನ್ ತ್ಯಾ ಚೆಡ್ವಾನ್ ಇಚಾರಲ್ಲೆ ಕರುಕ್ ಸೈನಿಕಾಕ್ನಿ ಹುಕುಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ಅಶೆ ತೆನಿ ಬಂದಿಖಾನ್ಯಾತುಚ್ ಜುವಾಂವಾಚೆ ಚಂಡ್ ತೊಡುಕ್ ಲಾವ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ಅಶೆ ತೆ ಟಕ್ಲೆ ಎಕ್ ಆಯ್ದಾನಾತ್ನಾ ಹಾನುನ್ ತ್ಯಾ ಚೆಡ್ವಾಚ್ಯಾ ಹಾತಿತ್ ದಿವ್ನ್ ಹೊಲೆ. ತ್ಯಾ ಚೆಡ್ವಾನ್ ತೆ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್‍ಕಡೆ ನ್ಹೆವ್ನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ಜುಂವಾವಾಚಿ ಶಿಸಾ ಯೆವ್ನ್ ಜುವಾಂವಾಚೆ ಮಡೆ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ ಅನಿ ಮಾಟಿ ದಿಲ್ಯಾನಿ. ಮಾನಾ ತೆನಿ ಜೆಜುಕ್ಡೆ ಗೆಲೆ ಅನಿ ಹೆ ಸಗ್ಳೆ ಜೆಜುಕ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ಜುಂವಾವಾಚಿ ಹಿ ಖಬರ್ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜು ಎಕ್ ಢೊನಿತ್ ಚಡ್ಲೊ. ಅನಿ ತೊ ಅಪ್ನಾಚ್ಯಾ ಎವ್ಡ್ಯಾಕ್ ಎಕ್ ಕೊನ್‍ಬಿ ನಸಲ್ಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಗೆಲೊ. ಹೆ ಆಯ್ಕಲ್ಲಿ ಲೊಕಾ ಅಪ್ನಾಚ್ಯಾ ಗಾವಾನಿತ್ನಾ ಯೆವ್ನ್ ಪಾಯ್ ವಾಟಾನಿ ಚಲುನ್ಗೆತ್ ಜೆಜುಚ್ಯಾ ಫಾಟೊ-ಫಾಟ್ ಜೆಜು ಹೊತ್ತ್ಯಾಕ್ಡೆ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ಜೆಜು ಢೊನಿತ್ನಾ ಭಾಯ್ರ್ ಯೆಲೊ ಅನಿ ಹ್ಯಾ ಎವ್ಡ್ಯಾ ಮೊಟ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಬಗುನ್ ತೆಕಾ ತೆಂಚ್ಯಾ ವರ್‍ತಿ ದಯಾ ಯೆಲಿ. ತೆನಿ ತ್ಯಾತುರ್‍ಲ್ಯಾ ಆರಾಮ್‍ನತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಆರಾಮ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ತ್ಯಾಚ್ ದಿಸ್ ಸಾಂಚೆಕ್ಡೆ ತೆಚಿ ಶಿಸಾ ಯೆಲಿ. ಅನಿ, “ಅತ್ತಾ ಬಗಟ್ಲ್ಯಾರ್ ಲೈ ಎಳ್ ಹೊಲೊ ಹ್ಯೊ ಜಾಗೊ ಬಗಟ್ಲ್ಯಾರ್ ಎಕ್ ನಮುನಿ ಭಾಯ್ರ್ ಕಾಡುನ್ ಟಾಕ್ಲ್ಯಾ ಸರ್ಕೊ ಹಾಯ್, ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ದಿ. ತೆನಿ ಗಾಂವಾತ್ನಿ ಜಾವ್ನ್ ಜೆವ್ನಾಕ್ ಇಕಾತ್ ಹಾನುನ್ದಿತ್.” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ಜೆಜುನ್ ತೆಂಕಾ, “ಲೊಕಾ ಹಿತ್ನಾ ಜಾತಲೆ ನಕ್ಕೊ. ತುಮಿಚ್ ತೆಂಕಾ ಕಾಯ್ತರ್ ಖಾವ್ಕ್ ದಿವಾ!” ಮಟ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ತನ್ನಾ ತೆನಿ “ಅಮ್ಚೆಕ್ಡೆ ಖಾಲಿ ಪಾಚ್ ಭಾಕ್ರಿಯಾ ಅನಿ ದೊನ್ ಮೊಸೊಳ್ಯಾ ಹಾತ್.” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ತನ್ನಾ ಜೆಜುನ್, “ತೆ ಮಾಜೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆವಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ತೆನಿ ಲೊಕಾಕ್ನಿ ಜಿಮ್ನಿರ್ ಗವ್ತಾ ವರ್‍ತಿ ಬಸುಕ್ ಸಾಂಗ್ಲ್ಯಾನ್; ತನ್ನಾ ತೆನಿ ಪಾಚ್ ಭಾಕ್ರಿಯಾ ಅನಿ ದೊನ್ ಮೊಸೊಳ್ಯಾ ಹಾತಿತ್ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ವೈರ್ ಸರ್‍ಗಾಕ್ ಅಪ್ನಾಚಿ ನದರ್ ಲಾವ್ಲ್ಯಾನ್ ಅನಿ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿವ್ನ್ ಭಾಕ್ರಿಯಾ ಮೊಡ್ಲ್ಯಾನ್ ಅನಿ ಶಿಸಾನಿಕ್ಡೆ ದಿಲ್ಯಾನ್ ತನ್ನಾ ಶಿಸಾನಿ ಲೊಕಾಕ್ನಿ ವಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ಪೊಟ್‍ಭರ್ ಜೆವ್ಲ್ಯಾನಿ. ಮಾನಾ ಹುರಲ್ಲೆ ಶಿಸಾನಿ ಗೊಳಾ ಕರ್‍ಲ್ಯಾನಿ ತನ್ನಾ ಬಾರಾ ಭುಟಿಯಾ ಭರ್‍ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ಜೆವಾನ್ ಕರಲ್ಲ್ಯಾ ಲೊಕಾತ್ನಿ ಸುಮಾರ್ ಪಾಚ್ ಹಜಾರ್ ಘೊಮನ್ಸಾಚ್ ಹೊತ್ತಿ. ಬಾಯ್ಕೊಮನ್ಸಾ ಅನಿ ಪೊರಾ ಕವ್ಡಿ ಹೊತ್ತಿ ಮನುನ್ ಮೆಜಲ್ಲೆ ನತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ಲೊಕಾಕ್ನಿ ಧಾಡ್ತಾನಾ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ ಢೊನಿತ್ ಚೆಡುಕ್ ಲಾವ್ಲ್ಯಾನ್. ಶಿಸಾ ಢೊನಿತ್ ಚಡ್ಲಿ ಅನಿ ತೆಂಕಾ ಫಿಡೆ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಧಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ತೊ ಎಕ್ಲೊಚ್ ಮಾಗ್ನಿ ಕರುಕ್ ಮನುನ್ ಎಕ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಗೆಲೊ. ತನ್ನಾ ಕಾಳೊಕ್ ಹೊವ್ನಗೆತ್ ಯೆಲ್ಲೊ; ತನ್ನಾ ಥೈ ಜೆಜು ಎಕ್ಲೊಚ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ತನ್ನಾ ತಿ ಢೊನ್ ಜಮಿನ್ ಸೊಡುನ್ ಸಮುಂದರಾತ್ ಸುಮಾರ್ ಭುತ್ತುರ್ ಪಾವಲ್ಲಿ. ವಾರೊ ಢೊನ್ ಜಾತಲ್ಯಾ ವಿರೊದ್ ದಿಕ್ಕಾಕ್ ಮಾರಿ ತಸೆಮನುನ್ ಲ್ಹಾಟಾತ್ನಿ ಗಾವುನ್ ಢೊನ್ ವೈರ್-ಖಾಯ್ಲ್ ಹೊಯ್. ");
INSERT INTO kans_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ಸಕ್ಕಾಳ್ಚೆ ಕೊಂಬೊ ಭೊಕ್ತಲ್ಯಾ ಏಳಾರ್ ಜೆಜು ಪಾನಿಯಾ ವರ್‍ತಿ ಚಲುನ್ಗೆತ್ ಶಿಸಾಂಚ್ಯಾಕ್ಡೆ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ಜೆಜು ಪಾನಿಯಾ ವರ್‍ತಿ ಚಲುನ್ ಯೆತಲೆ ಬಗುನ್ ಶಿಸಾ ವಾಯ್ಟ್ ಭಿಂಯಾಲೆ. ಅನಿ “ಭುತ್”, ಮನುನ್ ಭಿಯಾನಿ ತೆನಿ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ತನ್ನಾ ಎಗ್ದಮ್ ಜೆಜುನ್ ತೆಂಕಾ,“ಧೈರೊ ಕರಾ, ಭಿಂವ್‍ನಕಾಶಿ. ಮಿಯಾ ತೊ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ತನ್ನಾ ಪೆದ್ರುನ್,“ಧನಿಯಾ, ಖರೆಚ್ ತಿಯಾ ಹೊಯ್ ಹೊಲ್ಯಾರ್ ಪಾನಿಯಾ ವೈನಾ ಚಲುನ್ ತುಜೆಕ್ಡೆ ಯೆ ಮನುನ್ ಮಾಕಾ ಬಲ್ವು!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ಜೆಜುನ್ ತೆಕಾ,“ಯೆ, ತರ್!” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ಪೆದ್ರು ಢೊನಿತ್ನಾ ಪಾನಿಯಾ ವರ್‍ತಿ ಯೆಲೊ ಅನಿ ಪಾನಿಯಾ ವರ್‍ತಿ ಚಲುನ್ಗೆತ್ ಜೆಜುಕ್ಡೆ ಯೆವ್‍ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ಖರೆ ಭೊತ್ಯಾನಿ ಹೊತ್ತ್ಯಾ ಮೊಟ್ಯಾ ವಾರ್‍ಯಾಕ್ ಬಗುನ್ ತೊ ಭಿಂಯಾಲೊ ಅನಿ ಪಾನಿಯಾತ್ ಬುಡುಕ್‍ಲಾಲೊ. ಅನಿ,“ಧನಿಯಾ, ಮಾಕಾ ಹುರ್‍ವುನ್ ಘೆ!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ಜೆಜು ತೆಚೆಕ್ಡೆ ಯೆಲೊ ಅನಿ ತೆಕಾ ಧರ್‍ಲ್ಯಾನ್. ಅನಿ, “ಕವ್ಡೊ ಕಮಿ ವಿಶ್ವಾಸ್ ತುಜೊ! ತಿಯಾ ಕಶ್ಯಾಕ್ ಸಂಶೆವ್ ಕರ್‍ಲೆ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ತೆನಿ ದೊಗೆಬಿ ಢೊನಿತ್ ಚೆಡ್ಲ್ಯಾನಿ. ತನ್ನಾ ವಾರೊ ಬಂದ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ತನ್ನಾ ಢೊನಿತ್ಲ್ಯಾ ಶಿಸಾನಿ ಜೆಜುಚೆ ಆರಾದನ್ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ “ತಿಯಾ ಖರೆಚ್ ದೆವಾಚೊ ಲೆಕ್.” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ತೆನಿ ಸಮುಂದರ್ ದಾಟುನ್ ಗೆನಜರೆತ್ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಯೆವ್ನ್ ಪಾವ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ಥೈತ್ಲ್ಯಾ ಲೊಕಾನಿ ಜೆಜುಕ್ ವಳಕ್ಲ್ಯಾನಿ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ದೆಸಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಶಿಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ತೆನಿ ಶಿಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ತುಜ್ಯಾ ಅಂಗಿಚ್ಯಾ ತುದಿಚ್ಯಾ ಘೊಂಡ್ಯಾಕ್ ತರ್‍ಬಿ ಹಾತ್ ಲಾವಿ ಸರ್ಕೊ ಅವ್ಕಾಸ್ ಕರುನ್ ದಿ ಮನುನ್ ಮಾಗ್ಲ್ಯಾನಿ. ಅನಿ ಕೊನ್ ಕೊನ್ ತೆಚ್ಯಾ ಅಂಗಿಕ್ ಅಪಡ್ಲ್ಯಾನಿ ತೆನಿ ಬರೆ ಹೊಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ತನ್ನಾ ಫಾರಿಜೆವಾ ಅನಿ ಮೊಯ್ಜೆಚೆ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲಿ ಲೊಕಾ ಜೆರುಜಲೆಮಾತ್ನಾ ಜೆಜುಕ್ಡೆ ಯೆಲಿ. ಅನಿ, ");
INSERT INTO kans_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ತುಜಿ ಶಿಸಾ ಅದ್ಲ್ಯಾ ಲೊಕಾನಿ ಕರಲ್ಲ್ಯಾ ಪದ್ದತಿಯಾ ಕಶ್ಯಾಕ್ ಮೊಡ್ತ್ಯಾತ್? ತೆನಿ ಜೆವ್ನಾಚ್ಯಾ ಅದ್ದಿ ಅಪ್ನಾಚಿ ಹಾತಾ ಧುವ್ನ್ ಘೆಯ್‌ನ್ಯಾತ್.” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ಜೆಜುನ್ ತೆಂಕಾ, ತುಮಿ ದೆವಾಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಕಶ್ಯಾಕ್ ಚಲಿನ್ಯಾಶಿ? ತುಮ್ಚೆಚ್ ಖಾಯ್ದೆ ಕಶ್ಯಾಕ್ ಪಾಳ್ತ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ದೆವ್ ಮನ್ತಾ. ತುಮ್ಚ್ಯಾ ಬಾಯ್ ಬಾಬಾಕ್ನಿ ಮಾನ್ ದಿವಾ. ಜೆ ಕೊನ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ನಿ ಸರಾಪ್ತಾ ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿವ್ಚಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ಖರೆ ತುಮಿ ಎಕ್ ಮಾನ್ಸಾಕ್ಡೆ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕ್ ನಾ ತರ್ ಬಾಬಾಕ್ ಮಜತ್ ಕರುಕ್ ಮನುನ್ ವಾಪ್ರುಕ್ ಜೆ ಕಾಯ್ ಹಾಯ್.ತೆ ತೆನಿ ಸಗ್ಳೆ ದೆವಾಕ್‍ ಭೆಟ್ವುನ್ ದಿಲ್ಲೆ ಹಾಯ್ ಮನುನ್ ಮಟ್ಲ್ಯಾರ್. ");
INSERT INTO kans_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ತೆನಿ ತ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ ಮಾನ್ ದಿತಲಿ ಗರಜ್ ನಾ ಮನುನ್ ತುಮಿ ಶಿಕ್ವುತ್ಯಾಶಿ. ಅಶೆ ತುಮಿ ತುಮ್ಚೆ ಖಾಯ್ದೆ ಪಾಳುಸಾಟ್ನಿ ಮನುನ್ ದೆವಾಚೆ ಖಾಯ್ದೆ ಸೊಡುನ್ ಸೊಡ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ಕುಸ್ಡೆ ತುಮಿ! ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾನ್ ದೆವ್ ತುಮ್ಚ್ಯಾ ವಿಶಯಾತ್ ಕಾಯ್ ಮನ್ತಾ ಮನುನ್ ಬರಬ್ಬರ್ ಪ್ರವಾದ್ ಕರ್‍ಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ತೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, ಹಿ ಲೊಕಾ ಖಾಲಿ ತೆಂಚ್ಯಾ ಗೊಸ್ಟಿಯಾನಿ ಎವ್ಡೆಚ್ ಮಾಕಾ ಮಾನ್ ದಿತ್ಯಾತ್. ಖರೆ ತೆಂಚಿ ಮನಾ ಮಾಜೆಕ್ನಾ ಲೈ ಧುರ್ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ತೆನಿ ಮಾಜೆ ಆರಾದನ್ ಕರುನ್ ಫಾಯ್ದೊ ನಾ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಮಾಜೆ ಖಾಯ್ದೆ ಸೊಡುನ್ ಮಾನ್ಸಾನ್ ಕರಲ್ಲೆ ಖಾಯ್ದೆ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ತನ್ನಾ ಜೆಜುನ್ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್. ಅನಿ “ಆಯ್ಕಾ ಅನಿ ಕಳ್ವುನ್ ಘೆವಾ! ");
INSERT INTO kans_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ಜೆ ಕಾಯ್ ಮಾನ್ಸಾಚ್ಯಾ ತೊಂಡಾತ್ನಾ ಭುತ್ತುರ್ ಜಾತಾ ತೆ ತೆಕಾ ಅಶುದ್ದ್ ಕರಿನಾ. ಜೆ ಕಾಯ್ ಮಾನ್ಸಾಚ್ಯಾ ತೊಂಡಾತ್ನಾ ಭಾಯ್ರ್ ಯೆತಾ ತೆ ತೆಕಾ ಅಶುದ್ದ್ ಕರ್‍ತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ತನ್ನಾ ಶಿಸಾ ತೆಚೆಕ್ಡೆ ಯೆಲಿ, ಅನಿ, “ತಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿನಿ ಫಾರಿಜೆವಾಂಚ್ಯಾ ಮನಾಕ್ ದುಕ್ತಾ ಮನುನ್ ತುಕಾ ಗೊತ್ತ್ ಹಾಯ್ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ತನ್ನಾ ಜೆಜುನ್,“ಮಾಜ್ಯಾ ಸರ್‍ಗಾಚ್ಯಾ ಬಾಬಾನ್ ಜಮ್ನಿ ವರ್‍ತಿ ಲಾವಿನಸಲ್ಲೆ ಹರ್ ಎಕ್ ಝಾಡ್ ಮುಳಾತ್ನಾ ಉಪ್ಸುನ್ ಕಾಡುನ್ ಟಾಕುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ತೆಂಚ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ಚಿಂತಾ ಕರುನಕಾಸಿ. ಕುಡ್ಡ್ಯಾ ಲೊಕಾಕ್ನಿ ವಾಟ್ ದಾಕ್ವುತಲಿ ಕುಡ್ಡಿ ಮುಖಂಡಾ ತೆನಿ. ಎಕ್ ಕುಡ್ಡ್ಯಾ ಮಾನ್ಸಾನ್ ಅನಿ ಎಕ್ ಕುಡ್ಡ್ಯಾಕ್ ವಾಟ್ ದಾಕ್ವುಕ್ ಗೆಲ್ಯಾರ್ ತೆನಿ ದೊಗೆಬಿ ಖಡ್ಡ್ಯಾತ್ ಪಡ್ತ್ಯಾತ್.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ತನ್ನಾ ಪೆದ್ರುನ್,“ಹ್ಯಾ ಕಾನಿಚೊ ಅರ್ತ್‍ ಅಮ್ಕಾ ಉಲ್ಲೊ ಸೊಡ್ಸುನ್ ಸಾಂಗ್,” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ,“ತುಮಿ ಅಜುನ್‍ಬಿ ದುಸ್ರ್ಯಾ ಲೊಕಾಂಚ್ಯಾನ್ಕಿ ಉಶಾರ್ ಹೊವ್ಕ್‌ನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ತುಮ್ಕಾ ಕಳಿನಾ ಕಾಯ್? ಮಾನ್ಸಾಚ್ಯಾ ತೊಂಡಾತ್ನಾ ಜೆ ಕಾಯ್ ಭುತ್ತುರ್ ಜಾತಾ ತೆ ಮಾನ್ಸಾಚ್ಯಾ ಪೊಟಾತ್ ಜಾತಾ ಅನಿ ಮಾನಾ ಭಾಯ್ರ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ಖರೆ ಜೆ ಕಾಯ್ ಮಾನ್ಸಾಚ್ಯಾ ತೊಂಡಾತ್ನಾ ಭಾಯ್ರ್ ಯೆತಾ ತೆ ತೆಚ್ಯಾ ಮನಾತ್ನಾ ಯೆತಾ, ಅನಿ ಹೆ, ಮಾನ್ಸಾಕ್ ಅಪ್ಪಡ್-ಸಿಪ್ಡಡ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ತೆಚ್ಯಾ ಮನಾತ್ನಾ ಬುರ್ಶ್ಯಾ ಯವ್ಜನ್ಯಾ ಅನಿ ತ್ಯಾ ಯವ್ಜನ್ಯಾ ತೆಕಾ, ಅನಿಎಕ್ಲ್ಯಾಕ್ ಜಿವಾನಿ ಮಾರಿ ಸರ್ಕೆ ಕರ್‍ತ್ಯಾತ್ ವೆಭಿಚಾರ್ ಕರಿ ಸರ್ಕೆ ಕರ್‍ತ್ಯಾತ್, ಅನಿ ಬುರ್ಶಿ ಕಾಮಾ ಕರಿ ಸರ್ಕೆ ಕರುಕ್ ಲಾವ್ತ್ಯಾತ್, ಚೊರಿ ಸರ್ಕೆ ಕರ್‍ತ್ಯಾತ್, ಝಟೆ ಬೊಲಿ ಸರ್ಕೆ ಕರ್‍ತ್ಯಾತ್ ಅನಿ ದುಸ್ರ್ಯಾಕ್ನಿ ಗಾಳಿಯಾ ದಿತಲೆ ಸರ್ಕೆ ಕರ್‍ತ್ಯಾತ್ ");
INSERT INTO kans_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ಹೆ ಸಗ್ಳೆ ಎಕ್ ಮಾನ್ಸಾಕ್ ಅಪ್ಪಡ್- ಸಿಪ್ಪಡ್ ಕರ್‍ತಾ. ಹಾತ್ ದುಯ್ ನಸ್ತಾನಾ ಜೆವಾನ್ ಕರ್ತಲೆ ಮಾನ್ಸಾಕ್ ಅಪ್ಪಡ್-ಸಿಪ್ವಡ್ ಕರಿನಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್ ತಿರ್ ಅನಿ ಸಿದೊನ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್‍ಲ್ಯಾ ಪ್ರಾಂತ್ಯಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ಅನಿ ಎಕ್ ಕಾನಾನ್ ಮನ್ತಲ್ಯಾ ದೆಸಾಚಿ ಬಾಯ್ಕೊಮನುಸ್ ತ್ಯಾ ಥಳಾತ್ ಜಿವನ್ ಕರಿ, ತಿ ಜೆಜುಕ್ಡೆ ಯೆಲಿ, ಅನಿ “ಧನಿಯಾ; ದಾವಿದಾಚ್ಯಾ ಲೆಕಾ, ಮಾಜೆ ವರ್‍ತಿ ದಯಾ ದಾಕ್ವು; ಮಾಜ್ಯಾ ಲೆಕಿಕ್ ಎಕ್ ಗಿರೊ ಲಾಗ್ಲಾ ಅನಿ ತಿ ಲೈ ತರಾಸ್ ಕರುನ್ ಘೆವ್ಲಾ!” ಮನುನ್ ರಡುಕ್‍ಲಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ಖರೆ ಜೆಜುನ್ ತಿಚೆಕ್ಡೆ ಎಕ್ ಸಂಬದ್ ಸೈತ್ ಬೊಲುಕ್ನಾ, ತೆಚಿ ಶಿಸಾ ಫಿಡೆ ಯೆಲಿ ಅನಿ, “ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಹಿತ್ನಾ ಧಾಡುನ್ ದಿ. ಝುಟುಚ್ ಬೊಬ್ ಮಾರುನ್ಗೆತ್ ತಿ ಅಮ್ಚ್ಯಾ ಫಾಟ್ನಾಚ್ ಯೆವ್ಲಾ!” ಮನುನ್ ಜೆಜುಕ್ಡೆ ಲೈ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ತನ್ನಾ ಜೆಜುನ್,“ ದೆವಾನ್ ಮಾಕಾ ಖಾಲಿ ಕಳ್ದುನ್ ಬಕ್ರ್ಯಾಂಚ್ಯಾ ಸರ್ಕೆ ಅಸಲ್ಲ್ಯಾ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಮನುನ್ ಧಾಡುನ್ ದಿಲ್ಲೆ ಹಾಯ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ತನ್ನಾ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್ ಫಿಡೆ ಯೆವ್ನ್ ಜೆಜುಚ್ಯಾ ಪಾಯಾ ಪಡ್ಲಿನ್ ಅನಿ, “ಧನಿಯಾ ಮಾಜಿ ಮಜತ್ ಕರ್!” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ಜೆಜುನ್ ತಿಕಾ,“ಪೊರಾಂಚೆ ಜೆವಾನ್ ಘೆವ್ನ್ ಕುತ್ರ್ಯಾಕ್ನಿ ಟಾಕ್ತಲೆ ಸಮಾ ನ್ಹಯ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ತನ್ನಾ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್,“ತಿಯಾ ಸಾಂಗ್ತಲೆ ಸಮಾ ಹಾಯ್ ಧನಿಯಾ; ಖರೆ ಅಪ್ನಾಚ್ಯಾ ಧನಿಯಾಚೆ ಹುರಲ್ಲೆ ಉಸ್ಟೆ ತರ್‍ಬಿ ಕುತ್ರಿ ಖಾತ್ಯಾತ್ ನ್ಹಯ್”. ಮನುನ್ ಜಬಾಬ್ ದಿಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ತೆಚೆಸಾಟ್ನಿ ಜೆಜುನ್ ತಿಕಾ,“ತಿಯಾ ಎಕ್ ಘಟ್ ವಿಶ್ವಾಸ್ ಹೊತ್ತಿ ಬಾಯ್ಕೊಮನುಸ್! ತುಕಾ ಕಾಯ್ ಪಾಜೆ ಹೊಲ್ಲೆ ಹಾಯ್ ತೆ ಹೊಂವ್ದಿತ್!” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತಿಚಿ ಲೆಕ್ ಗುನ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ಜೆಜು ಥೈತ್ನಾ, ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಗೆಲೊ, ಅನಿ ಎಕ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಚೆಡುನ್ ಥೈ ತೊ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ಎಕ್ ಮೊಟೊ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಜೆಜುಕ್ಡೆ ಯೆಲೊ, ತೆನಿ ಕುಡ್ಡ್ಯಾಕ್ನಿ, ಹಾತ್-ಪಾಯ್ ನಸಲ್ಲ್ಯಾಕ್ನಿ ,ಕಿಂವ್ಡ್ಯಾಕ್ನಿ, ಸೊಟ್ಟ್ಯಾಕ್ನಿ, ಮುಕ್ಕ್ಯಾಕ್ನಿ ಜೆಜುಚ್ಯಾಕ್ನಿ ಪಾಯಾನಿತ್ನಿ ಘೆವ್ನ್ ಯೆವ್‍ಲಾಗಲ್ಲ್ಯಾನಿ. ಅನಿ ಜೆಜುನ್ ತೆಂಕಾ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ಮುಕ್ಕೆ ಬೊಲ್ತಲೆ, ಬಾಗ್ವುನ್ ಗೆಲ್ಲೆ ನಿಟ್ ಹೊತಲೆ, ಸೊಟ್ಟೆ ಚಲ್ತಲೆ, ಅನಿ ಕುಡ್ಡೆ ಬಗ್ತಲೆ, ಬಗುನ್ ಸಗ್ಳಿ ಲೊಕಾ ಆಜಾಪ್ ಹೊಲಿ, ಅನಿ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ದೆವಾಕ್ ತೆನಿ ಹೊಗಳ್ಳ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್ ಅನಿ, “ಹ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಗುನ್ ಮಾಜ್ಯಾ ಮನಾಕ್ ಬೆಜಾರ್ ಹೊವ್ಲಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿನ್ ದಿಸಾ ಹೊಲಿ ತೆನಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಹಾತ್, ಅನಿ ಅತ್ತಾ ತೆಂಚೆಕ್ಡೆ ಜೆವ್ಕ್ ಕಾಯ್ಬಿ ನಾ ತೆಂಕಾ ಜೆವಾನ್ ದಿ ನಸ್ತಾನಾ ಧಾಡುನ್ ದಿವ್ಕ್ ಮಾಕಾ ಮನ್ ನಾ ತೆನಿ ವಾಟೆರ್ ಜಾತಾನಾ ಖೈಬಿ ಚಕ್ಕರ್ ಯೆವ್ನ್ ಪಡ್ತಿಲ್.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ತನ್ನಾ ಶಿಸಾನಿ “ಹ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಫಿರೆ ಹೊಯ್ ಸರ್ಕೆ ಜೆವಾನ್ ಹ್ಯಾ ಡಂಗ್ಳಿತ್ ಅಮ್ಕಾ ಖೈ ಗಾವ್ತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ಜೆಜುನ್ ತೆಂಕಾ, “ತುಮ್ಚ್ಯಾಕ್ಡೆ ಕವ್ಡ್ಯಾ ಭಾಕ್ರಿಯಾ ಹಾತ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್ ತೆನಿ ತೆಕಾ, “ಸಾತ್ ಭಾಕ್ರಿಯಾ, ಅನಿ ಉಲ್ಲ್ಯಾಸ್ಯಾ ಬಾರಿಕ್ಲ್ಯಾ ಮೊಸೊಳ್ಯಾ ಹಾತ್ ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ತನ್ನಾ ಜೆಜುನ್ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಜಿಮ್ನಿ ವರ್‍ತಿ ಬಸಾ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ತನ್ನಾ ಜೆಜುನ್ ಸಾತ್ ಭಾಕ್ರಿಯಾ ಅನಿ ತ್ಯಾ ಮೊಸೊಳ್ಯಾ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿವ್ನ್ ಮೊಡ್ಲ್ಯಾನ್ ಲೊಕಾಕ್ನಿ ವಾಟುಕ್ ಮನುನ್ ಶಿಸಾಂಚ್ಯಾ ಹಾತಾತ್ ದಿಲ್ಯಾನ್, ಅನಿ ಶಿಸಾನಿ ಲೊಕಾಕ್ನಿ ವಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ತೆನಿ ಸಗ್ಳೆ ಜಾನಾ ಪೊಟ್‍ಬರ್ ಖಾಲ್ಯಾನಿ, ತನ್ನಾ ಶಿಸಾನಿ ಹುರಲ್ಲೆ ತುಕ್ಡೆ ಗೊಳಾ ಕರ್‍ಲ್ಯಾನಿ ಸಾತ್ ಭುಟಿಯಾ ಭರ್‍ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ಥೈ ಜೆವಾನ್ ಕರಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ಘೊಮನ್ಸಾಚ್ ಚಾರ್ ಹಜಾರ್ ಹೊತ್ತಿ ಬಾಯ್ಕೊಮನ್ಸಾ ಅನಿ ಪೊರಾ ಮೆಜಲ್ಲಿ ನತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ಮಾನಾ ಜೆಜು ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ದಿವ್ನ್ ಢೊನಿತ್ ಚಡ್ಲೊ ಅನಿ ಮಗ್ದಾನ್ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ಉಲ್ಲೆ ಫಾರಿಜೆವ್ ಅನಿ ಸಾದುಸೆವ್ ಜೆಜುಚಿ ಪರಿಕ್ಷಾ ಕರುಸಾಟಿ ಮನುನ್ ಯೆಲೆ. ಅನಿ, “ತಿಯಾ ಸರ್ಗಾತ್ನಾ ಯೆಲ್ಲೊ ಮಾನುಸ್ ಮನುನ್ ದಾಕ್ವುಕ್ ಎಕ್ ಮೊಟೆ ವಿಚಿತ್ರ್ ಕಾಮ್ ಕರುನ್ ದಾಕ್ವು.” ಮನುನ್ ಜೆಜುಕ್ಡೆ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ,“ದಿಸ್ ಬುಡ್ತಾನಾ ಅತ್ತಾ ಬರೆ ವಾತಾವರನ್ ಹಾಯ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಳಬ್ ತಾಂಬ್ಡೊ ಹೊಲಾ.” ಮನ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","“ಅನಿ ಸಕ್ಕಾಳಿ ಫಿಡೆ ಮಳಬ್ ತಾಂಬ್ಡೊ ಅನಿ ಎಕ್ ನಮುನಿ ಕಾಳೊಕ್ ಹೊಲ್ಲ್ಯಾ ಸರ್ಕೊ ಹೊವ್ನ್ ರ್‍ಹಾಲ್ಯಾರ್, ‘ಪಾವ್ಸ್ ಯೆನಾರ್ ಹಾಯ್.’” ಮನ್ತ್ಯಾಶಿ. ಮಳ್ಬಾಕ್ ಬಗುಕ್ ವಾತಾವರನ್ ಕಶೆ ಹಾಯ್ ಮನುನ್ ತುಮಿ ಕಳ್ವುನ್ ಘೆತ್ಯಾಶಿ, ಖರೆ ಹ್ಯಾ ದಿಸಾಂಚಿ ವಳಕ್ ತುಮ್ಕಾ ವಳ್ಕುನ್ ಘೆವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ಹ್ಯಾ ಕಾಲಾಚಿ ದೆವಸ್ಪಾನ್‍ನಸಲ್ಲಿ ಅನಿ ಬುರ್ಶಿ ಲೊಕಾ! ಮಾಜೆಕ್ಡೆ ವಿಚಿತ್ರ್ ಕಾಮ್ ಇಚಾರ್‍ತ್ಯಾತ್? ನಾ, ಹೆ ಕರುನ್ ದಾಕ್ವುಕ್ ಹೊಯ್ನಾ, ತುಮ್ಕಾ ಎಕುಚ್ ಎಕ್ ವಿಚಿತ್ರ್ ದಿಲ್ಲೆ ಹಾಯ್ ತೆ ಜೊನಾಚ್ಯಾ ಜಿವನಾತ್ಲೆ ವಿಚಿತ್ರ್. ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್, ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ತೆಂಕಾ ಥೈಚ್ ಸೊಡ್ಲ್ಯಾನ್ ಅನಿ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ತೆನಿ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್‍ ಜಾತಾನಾ ಶಿಸಾನಿ ಭಾಕ್ರಿ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಘೆವ್ಕ್ ಇಸರಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ಜೆಜುನ್ ತೆಂಕಾ, “ಫಾರಿಜೆವಾಂಚ್ಯಾ ಅನಿ ಸಾದುಸೆವಾಂಚ್ಯಾ ಸೊಡ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಉಶ್ಯಾರ್ಕಿನ್‍ ರ್‍ಹಾವಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ತನ್ನಾ ಶಿಸಾನಿ,“ಅಮ್ಚೆಕ್ಡೆ ಎಕ್‍ಬಿ ಭಾಕ್ರಿ ನಾ. ಮನುನ್ ತೊ ಅಶೆ ಮನುಲಾ ಕಾಯ್ಕಿ.” ಮನುನ್ ಅಪ್ನಾ-ಅಪ್ನಾ ಮದ್ದಿಚ್ ಬೊಲುಕ್‍ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ತೆನಿ ಕಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲ್ಯಾತ್ ಮನುನ್ ಜೆಜುಕ್ ಕಳ್ಳೆ. ತಸೆಮನುನ್ ತೆನಿ ತೆಂಕಾ,“ಎಕ್‍ಬಿ ಭಾಕ್ರಿ ತುಮ್ಚ್ಯಾಕ್ಡೆ ನಸಲ್ಲ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ಕಶ್ಯಾಕ್ ಬೊಲುಲಾಲ್ಯಾಶಿ? ಕವ್ಡೊ ಕಮಿ ವಿಶ್ವಾಸ್! ತುಮ್ಚೊ ");
INSERT INTO kans_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ತುಮ್ಕಾ ಅಜುನ್‍ಬಿ ಕಳಿನಾ ಕಾಯ್? ಮಿಯಾ ಪಾಚ್ ಭಾಕ್ರಿಯಾ ಪಾಚ್‍ ಹಜಾರ್ ಘೊಮನ್ಸಾಂಚ್ಯಾಸಾಟಿ ಮೊಡುನ್ ದಿಲ್ಲೊ ತನ್ನಾ ಕವ್ಡ್ಯಾ ಭುಟಿಯಾ ತುಮಿ ಭರಲ್ಲ್ಯಾಶಿ, ತುಮ್ಕಾ ಯಾದ್ ನಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ಅನಿ ಸಾತ್ ಭಾಕ್ರಿಯಾ ಚಾರ್ ಹಜಾರ್ ಲೊಕಾಕ್ನಿ ಮೊಡುನ್ ದಿಲ್ಲ್ಯಾ ತನ್ನಾ ಕಾಯ್ ಹೊಲೆ? ಕವ್ಡ್ಯಾ ಭುಟಿಯಾ ತುಮಿ ಭರಲ್ಲ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ತಸೆಜಾಲ್ಯಾರ್ ತುಮ್ಕಾ ಮಿಯಾ ಭಾಕ್ರಿಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲಿನಾ ಹೊಲಾ ಮನುನ್ ತುಮ್ಕಾ ಅಜುನ್ಬಿ ಕಶ್ಯಾಕ್ ಕಳಿನಾ? ಫಾರಿಜೆವಾಂಚ್ಯಾ ಅನಿ ಸಾದುಸೆವಾಂಚ್ಯಾ ಸೊಡ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ! ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ತನ್ನಾ ಜೆಜು ಭಾಕ್ರಿತ್ ಘಾಲ್ತಲ್ಯಾ ಸೊಡ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ ಮನುನ್ ಸಾಂಗಿನಾ ಹೊಲಾ. ಫಾರಿಜೆವಾ ಅನಿ ಸಾದುಸೆವಾ ಶಿಕ್ವುತಲ್ಯಾ ಶಿಕಾಪಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಶಿಸಾಕ್ನಿ ಕಳ್ಳೆ. ");
INSERT INTO kans_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ಜೆಜು ಸೆಜರಿಯಾ ಫಿಲಿಪ್ಪಿ ಮನ್ತಲ್ಯಾ ಶಾರಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ಲ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ ಪಾವಲ್ಲೊ, ತನ್ನಾ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ,“ಲೊಕಾ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಕೊನ್ ಮನುನ್ ಮನ್ತ್ಯಾತ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ತೆನಿ ತೆಕಾ, ಉಲ್ಲಿ ಲೊಕಾ ಜುವಾಂವ್ ಬಾವ್ತಿಸ್ ಮನ್ತ್ಯಾತ್, ಅನಿ ಉಲ್ಲೆ ಜಾನಾ ಎಲಿಯಾ ಮನ್ತ್ಯಾತ್, ಅನಿ ಉಲ್ಲೆ ಜಾನಾ ಜೆರೆಮಿಯಾ ನಾಹೊಲ್ಯಾರ್ ಅನಿ ದುಸ್ರೊ ಖಲೊ ತರ್ ಪ್ರವಾದಿ,ಮನ್ತ್ಯಾತ್ ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ಖರೆ ತುಮಿ ಮಿಯಾ ಕೊನ್ ಮನುನ್ ಮನ್ತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ತನ್ನಾ ಸಿಮಾವ್ ಪೆದ್ರುನ್, “ತಿಯಾ ಝಿತ್ತ್ಯಾ ದೆವಾಚೊ ಲೆಕ್ ಕ್ರಿಸ್ತ್,” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ತನ್ನಾ ಜೆಜುನ್,“ಸಿಮಾವ್ ಯೊನಾಚ್ಯಾ ಲೆಕಾ ತಿಯಾ ಧನ್ಯ್, ಹೆ ಖರೆ, ತುಜ್ಯಾ ಮನಾಚ್ಯಾ ಭುತ್ತುರ್ ಖಲ್ಯಾಬಿ ರಗ್ತಾ ಮಾಸಾನಿ ಉಪಾಜಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ನಾ ಯೆವ್ಕ್ ನಾ; ಹೆ ಮಾಜ್ಯಾ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ಬಾಬಾನ್ ತುಜ್ಯಾ ಮನಾತ್ ಘಾಟ್ಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ತೆಚೆಸಾಟ್ನಿ ಪೆದ್ರು ಮಿಯಾ ತುಕಾ ಸಾಂಗ್ತಾ, ತಿಯಾ ಎಕ್ ಮೊಟೊ ಖಡಾಪ್ ಅನಿ ಹ್ಯಾ ಖಡ್ಪಾ ವರ್‍ತಿ ಮಿಯಾ ಮಾಜ್ಯಾ ವಿಶ್ವಾಸಾಚ್ಯಾ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಭಾಂದ್ತಾ, ಅನಿ ನರ್‍ಕಾಚ್ಯಾ ಬಳಾಕ್ ಸೈತ್ ಕನ್ನಾಬಿ ಹ್ಯಾ ಮಾಜ್ಯಾ ತಾಂಡ್ಯಾಕ್ ನಾಸ್ ಕರುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ಮಿಯಾ ತುಕಾ ಸರ್ಗಾಚ್ಯಾ ರಾಜಾಚ್ಯಾ ಚಾವಿಯಾ ದಿತಾ; ಜೆ ಖಲ್ಯಾಕ್ ತಿಯಾ ಹ್ಯಾ ಜಗಾತ್ ಪರವಾನ್ಗಿ ದಿತೆಯ್ ತೆಕಾ ಸರ್‍ಗಾ ವರ್‍ತಿಬಿ ಪರವಾನ್ಗಿ ದಿವ್ನ್ ಹೊತಾ. ಅನಿ ಜೆ ಖಲ್ಯಾಕ್ ತಿಯಾ ಹ್ಯಾ ಜಗಾತ್ ಪರ್‍ವಾನ್ಗಿ ದಿನೆಯ್ ತೆಕಾ ಸರ್‍ಗಾ ವರ್‍ತಿಬಿ ಪರ್‍ವಾನ್ಗಿ ದಿವ್ನ್ ಹೊಯ್ನಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ಮಾನಾ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಮಿಯಾಚ್ ಕ್ರಿಸ್ತ್ ಮನುನ್ ಕೊನಾಕ್‍ಬಿ ಸಾಂಗುನಕಾಸಿ ಮನುನ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ತ್ಯಾ ದಿಸಾಕ್ನಾ ಪಿಢೆ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ, “ಮಿಯಾ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್ಕ್ ಪಾಜೆ ಅನಿ ಥೈ ಮುಖಂಡಾನಿಕ್ನಾ, ಮುಖ್ಯ ಯಾಜಕಾನಿಕ್ನಾ ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾನಿಕ್ನಾ ಮಿಯಾ ಲೈ ತರಾಸ್ ಸೊಸುಕ್ ಪಾಜೆ. ಮಾಕಾ ಜಿವಾನಿ ಮಾರುನ್ ಹೊತಾ; ಖರೆ ತಿನ್ ದಿಸಾಂಚ್ಯಾ ಮಾನಾ ಮಿಯಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆತಾ.” ಮನುನ್ ಕಾಯ್ಬಿ ಧಾಪುನ್ ಘೆಯ್ನಸ್ತಾನಾ ಫೊಡುನ್ ಸಾಂಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ತನ್ನಾ ಪೆದ್ರುನ್ ಜೆಜುಕ್ ಕಡೆಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್. ಅನಿ, “ಧನಿಯಾ, ದೆವ್ ಅಶೆ ಕರುನಸುಂದಿ. ಹೆ ಸಗ್ಳೆ ತುಕಾ ಹೊತಲೆಚ್ ನಕ್ಕೊ!” ಮನುನ್ ಜೊರ್ ಕರುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ತನ್ನಾ ಜೆಜು ಪೆದ್ರುಕ್ಡೆ ಪರತ್ಲೊ. ಅನಿ,“ಸೈತಾನಾ; ಮಾಜೆಕ್ನಾ ಧುರ್ ಚಲ್! ತಿಯಾ ಮಾಜ್ಯಾ ವಾಟೆಕ್‍ ಎಕ್ ಅಡ್ಕಳ್ ಹೊವ್ಲೆ, ಕಶ್ಯಾಕ್ ಹೆ ತಿಯಾ ಯವಜ್ತಲೆ ದೆವಾಕ್ನಾ ಯೆವ್ಕ್ ‘ನಾ’ ಮಾನ್ಸಾಚ್ಯಾ ಸ್ವಬಾವಾತ್ನಾ ಯೆತಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ, ಜೆ ಕೊನಾಕ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆವ್ಕ್ ಮನ್ ಹಾಯ್ ತರ್ ತೆನಿ ಅಪ್ನಾಕುಚ್ ಇಸ್ರುನ್, ಕಸ್ಟ್ ಸೊಸುಕ್ ಅನಿ ಮರುಕ್ ಸೈತ್ ತಯಾರ್ ರ್‍ಹಾವ್ಚೆ, ಅನಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ಜೆ ಕೊನ್ ಅಪ್ನಾಚೊ ಜಿವ್‍ ರಾಕುನ್ ಘೆವ್ಕ್ ಬಗ್ತಾ, ತೊ ತೆ ಕಳ್ದುನ್ ಘೆತಾ; ಖರೆ ಜೆ ಕೊನ್ ಅಪ್ನಾಚೊ ಜಿವ್ ಮಾಜೆಸಾಟಿ ಕಳ್ದುನ್ ಘೆತಾ ತೆಕಾ ತೊ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ಲೊಕಾನಿ ಹ್ಯೊ ಸಗ್ಳೊ ಜಗುಚ್ ಜಿಕುನ್ ಘೆವ್ನ್ ಅಪ್ನಾಚೊ ಜಿವ್ ನಾಸ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾರ್, ತೆಂಕಾ ಕಾಯ್ ತರ್ ಫಾಯ್ದೊ ಹಾಯ್ ಕಾಯ್? ಕಾಯ್ಬಿ ಫಾಯ್ದೊ ನಾ! ಕಳ್ದುಗೆಲ್ಲೊ ತೆಂಚೊ ಜಿವ್ ಅನಿ ಪರ್ತುನ್ ಘೆವ್ಕ್ ಮನುನ್ ದಿವ್ಕ್ ತೆಂಚೆಕ್ಡೆ ಕಾಯ್ಬಿ ರ್‍ಹಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾಚ್ಯಾ ಮಹಿಮೆನ್ ಭರುನ್ ದೆವಾಚ್ಯಾ ದುತಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆತಲೊ ಹಾಯ್ ಅನಿ ತನ್ನಾ ತೊ ಸಗ್ಳ್ಯಾಕ್ನಿ ತೆಂಚ್ಯಾ ಕರ್ನಾಂಚ್ಯಾ ಪರ್‍ಕಾರ್ ತೆಂಕಾ-ತೆಂಕಾ ಭೊಮಾನ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಹಿತ್ತೆ ಹೊತ್ತೆ ಉಲ್ಲೆ ಜಾನಾ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಸಗ್ಳ್ಯಾಂಚೊ ರಾಜಾ ಹೊವ್ನ್ ಯೆತಲೆ ಬಗಟ್ಲ್ಯಾ ಶಿವಾಯ್ ಮರಿನ್ಯಾತ್. ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ಸಾ ದಿಸಾ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜು ಪೆದ್ರುಕ್, ಜಾಕೊಬಾಕ್ ಅನಿ ತೆಚ್ಯಾ ಭಾವಾಕ್ ಜುವಾಂವಾಕ್ ಘೆವ್ನ್ ಎಕ್ ಉಪ್ಪರ್ಲ್ಯಾ ಮಡ್ಡಿ ವರ್‍ತಿ ಗೆಲೊ. ಥೈ ತೆನಿ ಎವ್ಡೆಚ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ತೆನಿ ಬಗ್ತಾ-ಬಗ್ತಾನಾಚ್ ಜೆಜುಚೊ ರುಪ್ ಬದಲ್ಲೊ. ತೆಚೆ ತೊಂಡ್ ದಿಸಾಚ್ಯಾ ಸರ್ಕೆ ಹೊಳ್ವಳುಲಾಗಲ್ಲೆ. ಅನಿ ತೆಚೆ ಕಪ್ಡೆ ಫಾಂಡ್ರೆ ಖಡ್ಡೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ತನ್ನಾ ತಿನಿಬಿ ಶಿಸಾನಿ ಮೊಯ್ಜೆ ಅನಿ ಎಲಿಯಾ ಜೆಜುಕ್ಡೆ ಬೊಲ್ತಲೆ ಬಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ತಸೆಮನುನ್ ಪೆದ್ರುನ್ ಜೆಜುಕ್,“ಧನಿಯಾ, ಅಮಿ ಹಿತ್ತೆ ಹೊತ್ತೆ ಕವ್ಡೆ ಬರೆ ಹಾಯ್! ತಿಯಾ ಸಾಂಗ್ಲ್ಯಾರ್ ಮಿಯಾ ಹಿತ್ತೆ ತಿನ್ ಝೊಪ್ಡಿ ಘಾಲ್ತಾ. ಎಕ್ ತುಕಾ ಎಕ್ ಮೊಯ್ಜೆಕ್, ಅನಿ ಎಕ್ ಎಲಿಯಾಕ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ತೊ ಬೊಲ್ತಾ-ಬೊಲ್ತಾನಾಚ್ ತೆಂಚೆ ವರ್‍ತಿ ಫಾಂಡ್ರೆ ಮೊಡ್ ಯೆಲೆ ಅನಿ ತೆಂಕಾ ಧಾಪ್ಲ್ಯಾನ್. ಅನಿ ತ್ಯಾ ಮೊಡಾತ್ನಾ“ಹ್ಯೊ ಮಾಜೊ ಅಪುರ್‍ಬಾಯೆಚೊ ಲೆಕ್, ಮಾಜ್ಯಾ ಮನಾ ಸರ್ಕೊ, ತೆನಿ ಸಾಂಗ್ತಲೆ ತುಮಿ ಆಯ್ಕಾ!” ಮನುನ್ ಬೊಲ್ತಲೊ ಧನ್ ಆಯ್ಕೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ಹ್ಯೊ ಧನ್ ಆಯ್ಕುನ್ ಶಿಸಾ ವಾಯ್ಟ್ ಭಿಂಯಾಲೆ, ಅನಿ ತೆನಿ ಜಮ್ನಿ ವರ್‍ತಿ ಡಬ್ ಪಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ತನ್ನಾ ಜೆಜು ತೆಂಚೆಕ್ಡೆ ಯೆಲೊ ಅನಿ ತೆಂಕಾ ಅಪ್ಡುನ್, “ಉಟಾ; ಭಿಂವ್‍ನಕಾಶಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ತನ್ನಾ ತೆನಿ ವೈರ್ ಉಟುನ್ ಬಗಟ್ಲ್ಯಾನಿ ತನ್ನಾ ತೆಂಕಾ ಜೆಜು ಎಕ್ಲೊಚ್ ಸೊಡುನ್ ಅನಿ ಕೊನ್ಬಿ ದಿಸುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ತೆನಿ ಮಡ್ಡಿ ವೈನಾ ಉತ್ರುನ್ ಯೆತಾನಾ, ತುಮಿ ಮಡ್ಡಿ ವರ್‍ತಿ ಬಗಟಲ್ಲೆ, ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮರುನ್ ಝಿತ್ತೊ ಹೊಯ್ ಪತರ್ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕಾಸಿ ಮನುನ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ತನ್ನಾ ಶಿಸಾನಿ ಜೆಜುಕ್,“ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲೆ ಕ್ರಿಸ್ತ್ ಯೆವ್ಚ್ಯಾ ಅದ್ದಿ ಎಲಿಯಾನ್ ಯೆವ್ಕ್ ಪಾಜೆ ಮನುನ್ ಕಶ್ಯಾಕ್ ಸಾಂಗ್ತ್ಯಾತ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ತನ್ನಾ ಜೆಜುನ್,“ ಎಲಿಯಾ ಅದ್ದಿ ಯೆತಲೆ ಖರೆ ಹಾಯ್, ಅನಿ ತೊ ಯೆವ್ನ್ ಸಗ್ಳೆ ತಯಾರ್ ಕರುನ್ ಥವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಎಲಿಯಾ ಕನ್ನಾಕಿಚ್ ಯೆವ್ನ್ ಹೊಲೆ ಖರೆ ಲೊಕಾನಿ ತೆಕಾ ವಳ್ಕುಕ್‍ನ್ಯಾತ್. ತೆಂಚ್ಯಾ ಮನಾಕ್‍ ಯೆತಾ ತಸೆ ತೆಕಾ ತರಾಸ್ ದಿಲ್ಯಾನಿ, ತಸೆಚ್ ತೆನಿ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್‍ಬಿ ತರಾಸ್ ದಿತ್ಯಾತ್.”ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ತನ್ನಾ ಜೆಜು ಜುವಾಂವ್ ಬಾವ್ತಿಸಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲಾ ಮನುನ್ ಶಿಸಾಕ್ನಿ ಕಳ್ಳೆ. ");
INSERT INTO kans_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ಜೆಜು ಅನಿ ಶಿಸಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ಡೆ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಎಕ್ ಮಾನುಸ್ ಜೆಜುಕ್ಡೆ ಯೆಲೊ ಅನಿ ಜೆಜುಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಡೊಗ್ಲಾ ಘಾಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ಅನಿ,“ಧನಿಯಾ, ಮಾಜ್ಯಾ ಲೆಕಾಚಿ ದಯಾ ಕರ್! ತೆಕಾ ಫೆಪ್ರೆ ಯೆತಲೊ ರೊಗ್ ಹಾಯ್ ತೊ ಲೈ ತರಾಸ್ ಕರುನ್ ಘೆವ್ಲಾ , ಅನಿ ತನ್ನಾ-ತನ್ನಾ ತೊ ಪಾನಿಯಾತ್ ನಾಹೊಲ್ಯಾರ್ ಆಗಿತ್ ಪಡುನ್ಗೆತ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ಮಿಯಾ ತೆಕಾ ತುಜ್ಯಾ ಶಿಸಾಂಚ್ಯಾಕ್ಡೆ ಘೆವ್ನ್ ಯಲ್ಲೊ, ಖರೆ ತೆಂಚೆನ್ ತೆಕಾ ಗುನ್ ಕರುಕ್ ಹೊವ್ಕ್ ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ತನ್ನಾ ಜೆಜುನ್,“ಯೆ,ವಿಶ್ವಾಸ್ ನಸಲ್ಲ್ಯಾ ಬುರ್ಶ್ಯಾ ಪಿಳ್ಗಿಚ್ಯಾನು, ಅನಿ ಕವ್ಡೆ ದಿಸ್ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಯಾ ರ್‍ಹಾವ್ಚೆ? ಅನಿ ಕವ್ಡೆ ಪತರ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಂಬಾಳುನ್ ಘೆವ್ನ್ ಜವ್ಚೆ? ತ್ಯಾ ಪೊರಾಕ್ ಮಾಜೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆವಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ಜೆಜುನ್ ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ ಭಾಯ್ರ್ ಯೆವ್ಕ್ ಸಾಂಗ್ಲ್ಯಾನ್ ಅನಿ ತೊ ಗಿರೊ ತ್ಯಾ ಪೊರಾತ್ನಾ ಭಾಯ್ರ್ ಗೆಲೊ, ಅನಿ ತಾಬೊಡ್ತೊಬ್ ತೊ ಪೊರ್ ಗುನ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ತನ್ನಾ ಶಿಸಾ ಕಡೆಕ್ ಯೆಲಿ ಅನಿ ಜೆಜುಕ್, “ಹ್ಯಾ ಗಿರ್‍ಯಾಕ್ ಅಮ್ಚ್ಯಾನ್ ಕಶ್ಯಾಕ್ ಸೊಡ್ವುಕ್ ಹೊವ್ಕ್ ನಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ತನ್ನಾ ಜೆಜುನ್, “ವಿಶ್ವಾಸ್ ಕಮಿ ಹೊತ್ತ್ಯಾಕ್ ತುಮ್ಕಾ ಸೊಡ್ಸುಕ್ ಹೊವ್ಕ್ ನಾ. ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಎಕ್ ಸಾಸಾವಾಚ್ಯಾ ಭ್ಹಿಂಯಾ ತವ್ಡೊ ವಿಶ್ವಾಸ್ ತುಮ್ಕಾ ರ್‍ಹಾಲ್ಯಾರ್ ತುಮಿ ಹ್ಯಾ ಮಡ್ಡಿಕ್ ಹಿತ್ನಾ-ಥೈ ಜಾವ್ನ್ ರ್‍ಹಾ! ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾರ್ ತಿ ಜಾತಾ, ತುಮಿ ಕಾಯ್ ಪಾಜೆ ತೆ ಕರುಕ್ ಹೊತಾ,” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ಮಾಗ್ನಿ ಅನಿ ಉಪಾಸ್ ಸೊಡುನ್ ಅನಿ ಕೆಚ್ಯಾನ್ಬಿ ಅಸ್ಲ್ಯಾ ಗಿರ್‍ಯಾಕ್ನಿ ಬಾಯ್ರ್ ಘಾಲುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ಸಗ್ಳಿ ಶಿಸಾ ಗಾಲಿಲಿಯಾತ್ ಎಕಾಕ್ಡೆ ಯೆವ್ನ್ ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುನ್ ತೆಂಕಾ, “ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಲೊಕಾಂಚ್ಯಾ ಹಾತಿತ್ ಧರುನ್ ದಿತಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ತೆನಿ ತೆಕಾ ಜಿವಾನಿ ಮಾರ್‍ತ್ಯಾತ್, ಖರೆ ತಿನ್ ದಿಸಾ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ತೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಶಿಸಾಕ್ನಿ ಲೈ ಬೆಜಾರ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ ಕಪರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ದೆವಾಚ್ಯಾ ಗುಡಿಚಿ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲೆ ಪೆದ್ರುಕ್ಡೆ ಯೆಲೆ. ಅನಿ, ಗುರುಜಿ. ದೆವಾಚ್ಯಾ ಗುಡಿಚಿ ತೆರ್‍ಗಿ ಭರಿನಾ ಮನಿ ಕಾಯ್ ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ತನ್ನಾ ಪೆದ್ರುನ್, “ಹೊಯ್, ಕಶ್ಯಾಕ್ ಭರಿನಾ;” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ಪೆದ್ರು ಘರಾತ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್,“ಸಿಮಾವ್ ತಿಯಾ ಕಾಯ್ ಮನ್ತೆ? ಹ್ಯಾ ಜಗಾಚ್ಯಾ ರಾಜಾಕ್ನಿ ತೆರ್‍ಗಿ ಕೊನ್ ದಿವ್ಕ್ ಪಾಜೆ? ತೆಂಚ್ಯಾ ದೆಸಾಚ್ಯಾ ಲೊಕಾನಿ ಕಾಯ್ ದುಸ್ರ್ಯಾ ದೆಸಾಚ್ಯಾ ಲೊಕಾನಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ತನ್ನಾ ಪೆದ್ರುನ್, “ದುಸ್ರ್ಯಾ ದೆಸಾಚ್ಯಾ ಲೊಕಾನಿ.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ಜೆಜುನ್ , “ತಸೆ ಜಾಲ್ಯಾರ್, ಹ್ಯಾ ದೆಸಾತ್ಲ್ಯಾನಿ ತೆರ್‍ಗಿ ಭರ್‍ತಲೆ ನಾ ಮನುನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ಖರೆ ಅಮಿ ತೆಂಚೊ ಮನ್ ದುಕ್ವುತಲೊ ನಕ್ಕೊ. ತೆಚೆಸಾಟ್ನಿ ಸಮುಂದರಾಕ್ ಜಾ ಅನಿ ಗರಿ ಟಾಕ್ ಗರಿಕ್‍ಲಾಗಲ್ಲಿ ಪಯ್ಲಿಚಿ ಮಾಸೊಳಿ ಕಾಡ್. ತ್ಯಾ ಮಾಸೊಳಿಚ್ಯಾ ತೊಂಡಾತ್ ದೆವಾಚ್ಯಾ ಗುಡಿಚಿ ಅನಿ ಅಮ್ಚಿ ತೆರ್‍ಗಿ ಭರಿಸರ್ಕ್ಯಾ ಕಿಮ್ತಿಚೊ ಎಕ್ ಪೈಸೊ ಗಾವ್ತಾ. ತೊ ಘೆ ಅನಿ ತೆಂಕಾ ಅಮ್ಚಿ ತೆರ್‍ಗಿ ಮನುನ್ ದಿ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ತನ್ನಾ ಶಿಸಾ ಜೆಜುಕ್ಡೆ ಯೆಲಿ, ಅನಿ, “ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾತ್ ಕೊನ್ ಮೊಟೊ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ತನ್ನಾ ಜೆಜುನ್ ಎಕ್ ಬಾರಿಕ್ ಪೊರಾಕ್ ಬಲ್ವುಲ್ಯಾನ್, ಅನಿ ತೆಂಚ್ಯಾ ಇದ್ರಾಕ್ ಇಬೆ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ಅನಿ, “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ತುಮಿ ತುಮ್ಚೆ ಮನ್ ಬದ್ಲುನ್, ಎಕ್ ಬಾರಿಕ್ ಪೊರಾ ಸರ್ಕೆ ಹೊಯ್ನಸ್ಲ್ಯಾರ್ ತುಮ್ಕಾ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾತ್ ಭುತ್ತುರ್ ಗುಸುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ಜೊ ಕೊನ್ ಅಪ್ನಾಕುಚ್ ಎಕ್ ಬಾರಿಕ್ ಪೊರಾ ಸರ್ಕೆ ಖಾಲ್ತಿ ಕರ್‍ತಾ, ತೊ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾತ್‍ ಲೈ ಮೊಟೊ. ");
INSERT INTO kans_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ಅನಿ ಅಸ್ಲ್ಯಾ ಎಕ್ ಬಾರಿಕ್ ಪೊರಾಕ್ ಮಾಜ್ಯಾ ನಾವಾನ್ ಜೆ ಕೊನ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ, ತೊ ಮಾಕಾಚ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ.” ");
INSERT INTO kans_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ಜರ್ ತರ್ ಕೊನ್ಬಿ ಎಕ್ಲೊ, ಹ್ಯಾ ಬಾರಿಕ್ಲ್ಯಾ ಲೊಕಾನಿತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್ ಸೈತ್ ಮಾಜೆ ವೈಲೊ ವಿಶ್ವಾಸ್ ಕಳ್ದುನ್ ಘೆಯ್‍ ಸರ್ಕೆ ಕರುಕ್ ಕಾರನ್ ಹೊತಾ, ತ್ಯಾ ಮಾನ್ಸಾನ್ ಅಪ್ನಾಚ್ಯಾ ಗಳ್ಯಾತ್ ಎಕ್ ಮೊಟೊ ಜಾತ್ಯಾಚೊ ಗುಂಡೊ ಭಾಂದುನ್ ಘೆವ್ನ್ ಖೊಲ್ ಹೊತ್ತ್ಯಾ ಸಮುಂದರಾತ್ ಹುಡಿ ಮಾರುನ್ ಬುಡಲ್ಲೆ ಬರೆ. ");
INSERT INTO kans_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ಹ್ಯಾ ಜಗಾಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಲೊಕಾನಿ ಅಪ್ನಾಚೊ ವಿಶ್ವಾಸ್ ಕಳ್ದುನ್ ಘೆವ್ಕ್ ಕಾರನ್ ಹೊತಲ್ಯಾ ಹ್ಯಾ ಸಂಗ್ತಿಯಾ ಕನ್ನಾಬಿ ಹೊವ್ನ್‌ಗೆತುಚ್ ರ್‍ಹಾತ್ಯಾತ್. ಖರೆ ತ್ಯಾ ಸಂಗ್ತಿಯಾ ಹೊಯ್ ಸರ್ಕೆ ಕರುಕ್ ಕಾರನ್ ಹೊತಲ್ಯಾಂಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು!” ");
INSERT INTO kans_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ತುಮ್ಚೊ ಹಾತ್ ನಾಹೊಲ್ಯಾರ್ ಪಾಯ್ ವಿಶ್ವಾಸ್ ಕಳ್ದುನ್ ಘೆವ್ಕ್ ಕಾರನ್ ಹೊತಾ ಹೊಲ್ಯಾರ್, ತೊ ಕಾತ್ರುನ್ ಧುರ್ ನ್ಹೆವ್ನ್ ಟಾಕಾ! ದೊನಿಬಿ ಹಾತಾ ನಾಹೊಲ್ಯಾರ್ ಪಾಯಾ ಘೆವ್ನ್ ತುಮಿ ಕನ್ನಾಬಿ ಇಜಿನಸಲ್ಲ್ಯಾ ಆಗಿತ್ ಜಾತಾಲ್ಯಾಚ್ಯಾನ್ಕಿ, ಎಕ್ ಹಾತ್ ನಾ ತರ್ ಪಾಯ್‍ ನಸ್ತಾನಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲ್ಯಾ ಜಿವನಾಕ್ ಗೆಲ್ಲೆ ಕವ್ಡೆಕಿ ಬರೆ. ");
INSERT INTO kans_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ತುಮ್ಚೊ ಡೊಳೊ ತುಮ್ಚೊ ವಿಶ್ವಾಸ್ ಕಳ್ದುನ್ ಘೆವ್ಕ್ ಕಾರನ್ ಹೊತಾ ಜಾಲ್ಯಾರ್, ತೊ ಮೆಟ್ಟುನ್ ಕಾಡುನ್ ಧುರ್ ನ್ಹೆವ್ನ್ ಟಾಕಾ, ದೊನ್ ಡೊಳೆ ಥವ್ನ್ ಘೆವ್ನ್, ನರ್‍ಕಾತ್ ಆಗಿತ್ ಪಡ್ತಲ್ಯಾಚ್ಯಾನ್ಕಿ ಎಕ್ ಡೊಳೊ ನಸ್ತಾನಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲ್ಯಾ ಜಿವನಾಕ್ ಜಾತಲೆ ತುಮ್ಕಾ ಕವ್ಡೆಕಿ ಬರೆ.” ");
INSERT INTO kans_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ಅಬಕಾ, ಹ್ಯಾ ಬಾರಿಕ್ಲ್ಯಾತ್ಲ್ಯಾ ಕೊನಾಕ್ಬಿ ತುಮಿ ಕಿಮ್ಮತ್‍ನಾ ಮನುನ್ ಯವ್ಜುನಕಾಶಿ. ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ತೆಂಚೆಸಾಟ್ನಿ ಮನುನ್ ಹೊತ್ತಿ ದೆವಾಚಿ ದುತಾ ಕನ್ನಾಬಿ ಸರ್‍ಗಾರ್ ಬಾಬಾಚ್ಯಾ ಇದ್ರಾಕುಚ್ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಕಳ್ದುನ್ ಗೆಲ್ಲ್ಯಾಕ್ನಿ ಬಚಾವ್ ಕರುಕ್ ಮನುನ್ ಯೆಲಾ” ");
INSERT INTO kans_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ಎಕ್ ಸೆಂಬರ್ ಬಕ್ರಿ ಹೊತ್ತೊ ಮಾನುಸ್, ತ್ಯಾತುರ್‍ಲೆ ಎಕ್ ಬಕ್ರೆ ಕಳ್ದುನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತೊ ಕಾಯ್ ಕರ್‍ತಾ ಮನುನ್ ತುಮಿ ಮನ್ತ್ಯಾಶಿ? ಹುರಲ್ಲ್ಯಾ ನ್ಹವದಾ‍ರ್ ನ್ಹವ್ ಬಕ್ರ್ಯಾಕ್ನಿ ತೊ, ಚರ್‍ತಲ್ಯಾಕ್ಡೆ ಥೈಚ್ ಸೊಡ್ತಾ, ಅನಿ ಕಳ್ದುನ್ ಗೆಲ್ಲ್ಯಾ ಎಕ್ ಬಕ್ರ್ಯಾಕ್ ಹುಡ್ಕುಕ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ಮಿಯಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ,ತೆಕಾ ತೆ ಬಕ್ರೆ ಗಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ಹುರಲ್ಲ್ಯಾ ನ್ಹವದಾರ್ ನ್ಹವ್ ಬಕ್ರ್ಯಾಂಚ್ಯಾನ್ಕಿ ಹೆ ಕಳ್ದಲ್ಲೆ ಎಕ್ ಬಕ್ರೆ ಗಾವಲ್ಲ್ಯಾ ಸಾಟ್ನಿ ತೊ ಲೈ ಮಟ್ಲ್ಯಾರ್ ಲೈ ಕುಶಿ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ತಸೆಚ್ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ತುಮ್ಚ್ಯಾ ಬಾಬಾಕ್ ಹ್ಯಾ ಬಾರಿಕ್ಲ್ಯಾನಿತ್ಲೊ ಎಕ್ಲೊ ಸೈತ್ ಪಾಪಾತ್ ಪಡುನ್ ನರ್ಕಾತ್ ಜಾತಲೆ ನಕ್ಕೊ. ");
INSERT INTO kans_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ಜರ್ ತರ್ ಎಕ್ ಭಾವಾನ್, ತುಮ್ಚ್ಯಾ ವಿರೊದ್ ಜಾವ್ನ್ ಪಾಪ್ ಕರ್ಲ್ಯಾರ್, ತೆಕಾ ಕಡೆಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ತೆಚಿ ಚುಕ್ ತೆಕಾ ದಾಕ್ವುನ್ ದಿವಾ, ತೆನಿ ತುಮಿ ಸಾಂಗಲ್ಲೆ ಆಯಿಕ್ಲ್ಯಾನ್ ತರ್ ತಿಯಾ ತುಜ್ಯಾ ಭಾವಾಕ್ ಜಿಕ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ಜರ್ ತೊ ತುಮಿ ಸಾಂಗಟಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಕ್ ಆಯ್ಕಿನಸ್ಲ್ಯಾರ್ ತರ್ ಎಕ್ ದೊಗೆ ಜಾನಾಕ್ನಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಜಾಂವಾ, ಅನಿ ತೆಕಾ ಸಾಂಗಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಖಲ್ಯಾಬಿ ಚುಕೆಕ್ ದೊಗೆ ಜಾನಾ ಸಾಕ್ಷಿ ರ್‍ಹಾಲ್ಯಾರ್ ತಿ ಚುಕ್ ಖರಿ ಮನುನ್ ಮಾನುನ್ ಘೆವ್ಕ್ ಹೊತಾ. ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ತೆಕಾಬಿ ತೊ ಅಯ್ಕಿನಸ್ಲ್ಯಾರ್ ಹೊಲ್ಲೆ ಸಗ್ಳೆ ವಿಶಯ್, ತುಮ್ಚ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಸಾಂಗಾ. ಆಕ್ರಿಕ್ ತೊ ತುಮ್ಚ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿಬಿ ಅಯ್ಕಿನಸ್ಲ್ಯಾರ್, ಎಕ್ ತೆರ್‍ಗಿ ವಸುಲಿ ಕರ್‍ತಲೊ ಮಾನುಸ್, ನಾಹೊಲ್ಯಾರ್ ಎಕ್ ದೆವಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಥೈ ನಸಲ್ಲೊ ಮಾನುಸ್ ಮನುನ್ ಯವ್ಜುನ್, ತೆಕಾ ಸೊಡುನ್ ಸೊಡಾ. ");
INSERT INTO kans_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ತೆಚೆಸಾಟ್ನಿ ತುಮ್ಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಮಿಯಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಹ್ಯಾ ಜಗಾತ್ ತುಮಿ ಖಲ್ಯಾಕ್ ಪರ್‍ವಾನ್ಗಿ ದಿನ್ಯಾಶಿ, ತೆಕಾ ಸರ್ಗಾ ವರ್‍ತಿಬಿ ಪರವಾನ್ಗಿ ದಿವ್ನ್ ಹೊಯ್ನಾ, ಅನಿ ಹ್ಯಾ ಜಗಾತ್ ತುಮಿ ಖಲ್ಯಾಕ್ ಪರವಾನ್ಗಿ ದಿತ್ಯಾಶಿ ತೆಕಾ ಸರ್‍ಗಾ ವರ್‍ತಿ ಪರವಾನ್ಗಿ ದಿವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“ಅನಿ ಜಾಸ್ತಿಚೆ ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗುಚೆ ಜಾಲ್ಯಾರ್, ಹ್ಯಾ ಜಗಾತ್ ಕನ್ನಾಬಿ ತುಮಿ ದೊಗೆ ಜಾನಾ ಎಕುಚ್ ಮನಾಚೆ ಹೊವ್ನ್ ಕಸ್ಲ್ಯಾಸಾಟ್ನಿಬಿ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾರ್, ಸರ್ಗಾ ವರ್‍ತಿಬಿ ಮಾಜೊ ಸರ್‍ಗಾ ವೈಲೊ ಬಾಬಾ ತೆ ತುಮ್ಕಾ ಕರುನ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ಜೆ ಖೈ ದೊಗೆ ಜಾನಾ ನಾಜಾಲ್ಯಾರ್ ತಿಗೆಜಾನಾ ಮಾಜ್ಯಾ ನಾವಾನ್ ಗೊಳಾ ಹೊತ್ಯಾತ್, ಥೈ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಯಾಚ್ ಹಾಜರ್ ರ್‍ಹಾತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ತನ್ನಾ ಪೆದ್ರು ಜೆಜುಕ್ಡೆ ಯೆಲೊ, ಅನಿ ಧನಿಯಾ, ಮಾಜೊ ಭಾವ್ ಚುಕ್ ಕರುನ್ಗೆತುಚ್ ರ್‍ಹಾಲ್ಯಾರ್, ಮಿಯಾ ಕವ್ಡೆಂದಾ, ತೆಕಾ ಮಾಪ್ ಕರುಚೆ? ಸಾತ್ ದಾ ಕಾಯ್ ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ತನ್ನಾ ಜೆಜುನ್, “ಸಾತ್ ದಾ ನ್ಹಯ್, ಸಾತಾಚೆ ಸತ್ತರ್ ಪಟಿ ಮಾಪ್ ಕರುಚೆ.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ಕಶ್ಯಾಕ್ ಸರ್ಗಾಚೊ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್, ಅಶೆ ಎಗ್ದಾ ಎಕ್ ರಾಜಾ ಹೊತ್ತೊ, ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಆಳಾಂಚೊ ಲೆಕ್ಕ್ ಇಚಾರುಚೆ ಮನುನ್ ನಿರ್‍ದಾರ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ತೆನಿ ಲೆಕ್ಕ್ ಕರುಕ್ ಚಾಲು ಕರಲ್ಲ್ಯಾ ತನ್ನಾ , ರಿನ್ ದಿತಲ್ಯಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್ ತೆಚೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ ತೆನಿ ಕರೊಡಾನಿ ರಿನ್ ಫೆಡ್ತಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ತ್ಯಾ ಅಳಾಕ್ಡೆ ತೆ, ಫೆಡುಕ್ ಹೊಯ್ ಸರ್ಕೆ ಪೈಸೆ ನತ್ತೆ. ತಸೆಮನುನ್ ರಾಜಾನ್ ತೆಚೆ ರಿನ್ ಭರುನ್ ಘೆವ್‍ಸಾಟ್ನಿ ತ್ಯಾ ಅಳಾಕ್, ಅನಿ ತೆಚ್ಯಾ ಬಾಯ್ಕೊ ಪೊರಾಕ್ನಿ ಗುಲಾಮ್ ಕರುನ್ ಇಕಾ ಮನುನ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ತನ್ನಾ ತೊ ಆಳ್ ರಾಜಾಚ್ಯಾ ಪಾಯಾ ಪಡುನ್, \"ಮಾಕಾ ಉಲ್ಲೊ ಎಳ್ ದಿ, ಮಿಯಾ ತುಮ್ಚೆ ರಿನ್ ಸಗ್ಳೆ ಫೆಡ್ತಾ! ಮನುನ್ ಮಾಗುನ್ಗೆತ್ ರಡುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ರಾಜಾಕ್ ತ್ಯಾ ಸೆವಕಾಚೊ ಪಾಪ್ ದಿಸ್ಲೊ. ತೆಚೆಸಾಟ್ನಿ ರಾಜಾನ್ ತೆಚೆ ಸಗ್ಳೆ ರಿನ್ ಸುಟ್ ಕರ್‍ಲ್ಯಾನ್ ಅನಿ ತೆಕಾ ಸೊಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ತನ್ನಾ ತೊ ಸೆವಕ್ ಭಾಯ್ರ್ ಗೆಲೊ, ಅನಿ ಜಾತಾನಾ ತೆಕಾ ತೆಚ್ಯಾ ವಾಂಗುಡ್ಚೊ ಎಕ್ ಆಳ್ ಗಾವ್ಲೊ. ತೆನಿ ತೆಕಾ ಎಕ್ ಸೆಂಬರ್ ರುಪಯ್ ರಿನ್ ದಿತಲೆ ಹೊತ್ತೆ. ತನ್ನಾ ತೆನಿ ತೆಕಾ ಧರ್‍ಲ್ಯಾನ್, ಅನಿ ತೆಚೊ ನರ್‍ಡೊ ಹಿಚ್ಕುನ್, ಮಾಜೆ ದಿತಲೆ ಹಾಯ್ ತೆ ಅತ್ತಾಚ್ ಮಾಕಾ ದಿ. ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ತೊ ವಾಂಗುಡ್ಚೊ ಆಳ್ “ಮಾಕಾ ಉಲ್ಲೊಸೊ ಎಳ್ ದಿ ಮಿಯಾ ತುಜೆ ಪೈಸೆ ದಿತಾ;” ಮನುನ್ ಮಾಗುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ಜಾಲ್ಯಾರ್‍ಬಿ ತೊ ಆಯ್ಕುಕ್ ನಾ ತೆನಿ ಅಪ್ನಾಚೆ ರಿನ್ ದಿವ್ಕ್ ನಾ ಮನುನ್ ತೆಕಾ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ಹೆ ಬಗುನ್ ಹುರಲ್ಲ್ಯಾ ಆಳಾಕ್ನಿ ಲೈ ವಾಯ್ಟ್ ದಿಸ್ಲೆ. ತೆನಿ ಜಾವ್ನ್ ಹೆ ರಾಜಾಕ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ತನ್ನಾ ರಾಜಾನ್ ತ್ಯಾ ಆಳಾಕ್ ಬಲ್ವುಲ್ಯಾನ್ ಅನಿ,ಕಿಮ್ಮತ್ ನಸಲ್ಲ್ಯಾ ಸೆವಕಾ ತಿಯಾ ಇಚಾರಲ್ಲ್ಯಾ ಸಾಟ್ನಿ ಸಗ್ಳೆ ತುಜೆ ರಿನ್ ಮಿಯಾ ಸುಟ್ ಕರ್‍ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ಮಿಯಾ ಕಶೆ ತುಜ್ಯಾ ವರ್‍ತಿ ದಯಾ ದಾಕ್ವುಲೊ, ತಸೆ ತಿಯಾ ತುಜ್ಯಾ ವಾಂಗುಡ್ಚ್ಯಾ ಆಳಾಕ್ ದಯಾ ದಾಕ್ವುಚೆ. ");
INSERT INTO kans_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ರಾಜಾಕ್ ಲೈ ರಾಗ್ ಯೆಲೊ, ಅನಿ ಸಗ್ಳೆ ರಿನ್ ಫೆಡಿ ಪತರ್ ತೆನಿ ತ್ಯಾ ಆಳಾಕ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಘಾಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ತನ್ನಾ ಜೆಜುನ್ ತಸೆಚ್ ತುಮಿಬಿ ತುಮ್ಚ್ಯಾ ಭಾವಾಕ್ ತುಮ್ಚ್ಯಾ ಮನಾತ್ನಾ ಮಾಪ್ ಕರಿನಸ್ಲ್ಯಾರ್, ಸರ್‍ಗಾ ವೈಲೊ ಮಾಜೊ ಬಾಬಾಬಿ ತುಮ್ಕಾ ಮಾಪ್ ಕರಿನಾ. ಮನುನ್ ಕಾನಿ ಮುಗಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ಹೆ ಸಗ್ಳೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜು ಗಾಲಿಲಿಯಾ ಸೊಡುನ್ ಜೊರ್ದಾನ್ ನ್ಹಯ್ಚ್ಯಾ ತಿಕುಲ್ಯಾ ಬಾಜುಕ್ ಹೊತ್ತ್ಯಾ ಜುದೆಯಾ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ರ್ಯಾಕ್ ಯೆವ್ನ್ ಪಾವ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ಲೊಕಾಂಚೊ ಎಕ್ ಮೊಟೊ ತಾಂಡೊ ತೆಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತೊ, ತೆನಿ ಥೈ ಶಿಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ಉಲ್ಲೆಸೆ ಫಾರಿಜೆವ್ ತೆಚೆಕ್ಡೆ ಯೆಲೆ. ಅನಿ ತೆಕಾ ಚುಕೆತ್ ಪಾಡ್ವುಸಾಟ್ನಿ ಮನುನ್, “ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್, ಕಸ್ಲ್ಯಾಬಿ ಕಾರನಾಕ್ ಲಾಗುನ್ ಎಕ್ ಘೊಮನ್ಸಾನ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಸೊಡ್ ಪತ್ತರ್ ದಿವ್ಕ್ ಹೊತಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, ತುಮಿ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್. ರಚ್ತಲ್ಯಾನ್ ಅದ್ದಿ ರಚ್ತಾನಾ ಬಾಯ್ಕೊಮನುಸ್, ಅನಿ ಘೊಮನುಸ್ ಮನುನ್ ರಚ್ಲ್ಯಾನ್, ಮನುನ್ ವಾಚ್ವುಕ್‍ನ್ಯಾಶಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ಅನಿ ದೆವ್ ಮನ್ತಾ,ಹೆಚೆಸಾಟ್ನಿ ಎಕ್ ಘೊಮನುಸ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕ್, ಅನಿ ಬಾಬಾಕ್ ಸೊಡ್ತಾ, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ಡೆ ಎಕ್ ಹೊತಾ, ಅನಿ ತೆನಿ ದೊಗೆಬಿ ಎಕುಚ್ ಆಂಗ್ ಹೊತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ತೆಚೆಸಾಟ್ನಿ ತೆನಿ, ಅನಿ ಫಿಡೆ ದೊಗೆ ನ್ಹಯ್ ಎಕುಚ್ ಆಂಗ್. ಅಶೆ ರ್‍ಹಾತಾನಾ ದೆವಾನ್ ಜೊಡಲ್ಲೆ ಖಲ್ಯಾಬಿ ಮಾನ್ಸಾನ್ ಎಗ್ಳುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ತನ್ನಾ ಫಾರಿಜೆವಾನಿ,“ತರ್ ಎಕ್ ಘೊಮನ್ಸಾನ್ ಸೊಡ್‍ ಚಿಟಿ ಲಿವ್ನ್ ದಿವ್ನ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಸೊಡುಕ್ ಹೊತಾ ಮನುನ್ ಮೊಯ್ಜೆನ್ ಅಪ್ನಾಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ ಕಶ್ಯಾಕ್ ಲಿವ್ನ್ ಥವ್ಲ್ಯಾನಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ಜೆಜುನ್ ತೆಂಕಾ,“ತುಮ್ಚ್ಯಾ ಮಂಡ್‍ಪಾನಾಕ್ ಲಾಗುನ್ ಮೊಯ್ಜೆನ್ ತುಮ್ಕಾ ಸೊಡ್ ಪತ್ತರ್ ದಿವ್ನ್ ಬಾಯ್ಕೊಕ್ ಸೊಡುಕ್ ಹೊತಾ ಮನುನ್ ಸಾಂಗಲ್ಲೆ, ಖರೆ ರಚ್ತಲ್ಯಾ ಏಳಾರ್ ಹೆ ತಸೆ ನತ್ತೆ.” ");
INSERT INTO kans_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","“ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಎಕ್ ಮಾನುಸ್ ಅಪ್ನಾಚಿ ಬಾಯ್ಕೊ ದುಸ್ರ್ಯಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಬುರ್ಸೊ ಸಮಂದ್ ಅಸಲ್ಲ್ಯಾ ಕಾರನಾಕ್ ಸೊಡುನ್, ದುಸ್ರ್ಯಾ ಕಸ್ಲ್ಯಾಬಿ ಕಾರನಾಸಾಟಿ ತೊ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಸೊಡ್ತಾ ಅನಿ ದುಸ್ರ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ಡೆ ಲಗಿನ್ ಹೊತಾ. ತರ್ ತೊ ವೆಭಿಚಾರ್ ಕರ್‍ತಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ತನ್ನಾ ತೆಚ್ಯಾ ಶಿಸಾನಿ ತೆಕಾ,“ಜರ್ ತರ್ ಘೊವಾಚ್ಯಾ ಅನಿ ಬಾಯ್ಕೊಚ್ಯಾ ಮದ್ದಿ ಅಸ್ಲೆ ಸಗ್ಳೆ ರ್‍ಹಾತಾ. ತರ್ ನಗಿನ್ ಹೊಯ್‍ನಸ್ತಾನಾ ರಾಲ್ಲೆಚ್ ಬರೆ, ಕಾಯ್ಕಿ.” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ,“ಹೆ ಮಿಯಾ ಶಿಕ್ವುತಲೆ ಸಗ್ಳ್ಯಾಕ್ನಿಬಿ ಸಮಂದ್ ಪಡಿನಾ, ಜೆ ಕೊನಾಕ್ ದೆವಾನ್ ತೆ ದಿಲ್ಯಾನಾಯ್, ತೆಂಕಾ ಎವ್ಡೆಚ್ ಸಮಂದ್ ಪಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ಮಾನುಸ್ ನಗಿನ್ ಹೊಯ್‍ನಸ್ತಾನಾ ರ್‍ಹಾವ್ಕ್ ದುಸ್ರೆ- ದುಸ್ರೆ ಕಾರನ್ ಹಾತ್. ಉಲ್ಲಿ ಲೊಕಾ, ಹಿಜ್ಡೆ ಹೊವ್ನ್ ಉಪಾಜ್ತಾತ್ , ಅನಿ ಉಲ್ಲ್ಯಾಸ್ಯಾ ಲೊಕಾಕ್ನಿ ಮಾನ್ಸಾನಿ ಹಿಜ್ಡೆ ಕರುನ್ ಥವ್ಲ್ಯಾನಾತ್, ಅನಿ ಉಲ್ಲಿ ಲೊಕಾ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾ ಸಾಟ್ನಿ ಹಿಜ್ಡೆ ಹೊವ್ನ್ ಹಾತ್. ಜೊ ಕೊನ್ ಹೆ ಶಿಕಾಪ್ ಮಾನುನ್ ಘೆವ್ಕ್ ತಯಾರ್ ಹಾಯ್ ತೊ ತೆ, ಮಾನುನ್ ಘೆಂವ್ದಿತ್.” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ಉಲ್ಲ್ಯಾಸ್ಯಾ ಲೊಕಾನಿ ಪೊರಾಂಚ್ಯಾ ವರ್‍ತಿ ಹಾತ್ ಥವ್ನ್ ಮಾಗ್ನಿ ಕರುನ್ ಘೆವ್‍ಸಾಟ್ನಿ ಮನುನ್ ಜೆಜುಕ್ಡೆ ಯೆಲ್ಯಾನಿ. ಖರೆ ಶಿಸಾನಿ ಲೊಕಾಕ್ನಿ ಅಡ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ,“ಬಾರಿಕ್ ಪೊರಾಕ್ನಿ ಮಾಜೆಕ್ಡೆ ಯೆವ್ಕ್ ಸೊಡಾ, ತೆಂಕಾ ಅಡ್ವುನಕಾಶಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸರ್‍ಗಾಚೆ ರಾಜ್ ಬಾರಿಕ್ ಪೊರಾಂಚ್ಯಾ ಸರ್ಕೆ ಹೊತ್ತ್ಯಾಂಚೆಚ್.” ಮಟ್ಲ್ಯಾನ್ ಅನಿ, ");
INSERT INTO kans_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ತೆನಿ ತೆಂಚೆ ವರ್‍ತಿ ಹಾತ್ ಥವ್ನ್ ಆಶಿರ್ವಾದ್ ದಿಲ್ಯಾನ್ ಅನಿ ಥೈತ್ನಾ ತೊ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ಎಗ್ದಾ ಎಕ್ ಮಾನುಸ್ ಜೆಜುಕ್ಡೆ ಯೆಲೊ. ಅನಿ “ಗುರುಜಿ, ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಮಾಕಾ ಗಾವುಚೆ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಕಾಯ್ ಬರೆ ಕಾಮ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ತನ್ನಾ ಜೆಜುನ್,“ಬರೆ ಕಾಮಾಚ್ಯಾ ವಿಶಯಾತ್ ಮಾಕಾ ಕಶ್ಯಾಕ್ ಇಚಾರ್‍ತೆ? ಬರೊ ಮನುನ್ ಹೊತ್ತೊ ದೆವ್ ಎಕ್ಲೊಚ್. ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವುಚೆ ತರ್, ಜಾ ಅನಿ ಖಾಯ್ದೆ ಪಾಳ್.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“ಖಲಿ ಹುಕುಮಾ?” ಮನುನ್ ತೆನಿ ಇಚಾರ್‍ಲ್ಯಾನ್ ತನ್ನಾ ಜೆಜುನ್,“ ಜಿವಾನಿ ಮಾರುನಕೊ, ವೆಭಿಚಾರ್ ಕರುನಕೊ, ಚೊರುನಕೊ, ಝುಟಿ ಸಾಕ್ಷಿ ಸಾಂಗುನಕೊ, ");
INSERT INTO kans_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ತುಜ್ಯಾ ಬಾಬಾಕ್ ಮಾನ್ ದಿ, ಅನಿ ತುಜೊ ತಿಯಾ ಪ್ರೆಮ್ ಕರ್ಲ್ಯಾ ಸರ್ಕೆ ತುಜ್ಯಾ ಅಜು-ಬಾಜುಚ್ಯಾ ಲೊಕಾಂಚೊ ಪ್ರೆಮ್ ಕರ್.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ತನ್ನಾ ತ್ಯಾ ದಾಂಡ್ಗ್ಯಾ ಮಾನ್ಸಾನ್,“ಹಿ ಸಗ್ಳಿ ಹುಕುಮಾ ಮಿಯಾ ಪಾಳುನ್ಗೆತುಚ್ ಯೆಲಾ, ಅನಿ ಜಾಸ್ತಿಚೆ ಮಿಯಾ ಕಾಯ್ ಕರುಕ್ ಪಾಜೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ಜೆಜುನ್ ತೆಕಾ,“ತಿಯಾ ಸಗ್ಳೊ ಸಂಪುರ್ನ್ ಹೊವ್ಚೆ ಮಟ್ಲ್ಯಾರ್, ಜಾ ಅನಿ ತುಜೆ ಮನುನ್ ಕಾಯ್ ಹಾಯ್ ತೆ ಸಗ್ಳೆ ಇಕ್ ಅನಿ ಯೆಲ್ಲೆ ಪೈಸೆ ಗರಿಬಾಕ್ನಿ ದಿ. ಸರ್‍ಗಾ ವರ್‍ತಿ ತುಕಾ ಮೊಟಿ ಸಾವ್ಕಾರ್ಕಿ ತಯಾರ್ ರ್‍ಹಾತಾ. ಮಾನಾ ಯೆ ಅನಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ರ್‍ಹಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ಹೆ ಆಯ್ಕುನ್ ತ್ಯಾ ದಾಂಡ್ಗ್ಯಾ ಮಾನ್ಸಾಕ್ ಲೈ ಬೆಜಾರ್ ಹೊಲೊ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಲೈ ಸಾವ್ಕಾರ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ, “ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಎಕ್ ಸಾವ್ಕಾರ್ ಮಾನ್ಸಾಕ್ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾತ್ ಜಾವ್ನ್ ಪಾವುಚೆ ಮಟ್ಲ್ಯಾರ್ ಲೈ ಕಸ್ಟ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ಅನಿ ಮಿಯಾ ಸಾಂಗ್ತಾ, ಎಕ್ ಒಂಟೆ ಎಕ್ ಸುಯೆಚ್ಯಾ ಡೊಳ್ಯಾತ್ನಾ ಪಾರ್ ಹೊಯ್ಲ್, ಖರೆ ಎಕ್ ಸಾವ್ಕಾರ್ ಮಾನುಸ್ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಗುಸುಚೆ ಮಟ್ಲ್ಯಾರ್ ತೆಕಾ ಲೈ ತರಾಸ್ ಹಾಯ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಶಿಸಾ ಎಗ್ದಮ್ ಅಜಾಪ್ ಹೊಲಿ, ಅನಿ,“ ತಸೆ ಜಾಲ್ಯಾರ್ ಪಾಪಾತ್ನಾ ಸುಟ್ಕಾ ಹೊತಲೆ ಕೊನ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ಜೆಜುನ್ ನಿಟ್ಟ್ ತೆಂಚೆಕ್ಡೆ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ,“ ಮಾನ್ಸಾಕ್ ಹೆ ಕರುಕ್ ಹೊಯ್ನಾ ತೆ ಖರೆ ಹಾಯ್, ಖರೆ ದೆವಾಕ್ ಸಗ್ಳೆ ಕರುಕ್ ಹೊತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ತನ್ನಾ ಪೆದ್ರುನ್, ಬಗ್, ಅಮಿ ತರ್ ಸಗ್ಳೆ-ಸಗ್ಳೆ ಸೊಡುನ್ ದಿವ್ನ್, ತುಜ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಹಾಂವ್. ಅಮ್ಕಾ ಕಾಯ್ ಗಾವ್ತಾ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ಜೆಜುನ್ ತೆಂಕಾ,“ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮಹಿಮೆನ್ ಅಪ್ನಾಚ್ಯಾ ಸಿವಾಸನಾ ವರ್‍ತಿ ಬಸಲ್ಲ್ಯಾ ತನ್ನಾ ಸಗ್ಳೆ ನ್ಹವೆ ಕರ್‍ತಾ. ತನ್ನಾ ತುಮಿ ಬಾರಾ ಜಾನಾ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೆ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಬಾರಾ ಘರಾನ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ರಾಜ್ ಚಾಲ್ವುಕ್ ಬಾರಾ ಸಿವಾಸನಾಂಚ್ಯಾ ವರ್‍ತಿ ಬಸ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ಅನಿ ಮಾಜೆಸಾಟಿ ಜೆ ಕೊನ್ ಘರಾಕ್ನಿ, ಭಾವಾಕ್ನಿ, ಭೆನಿಯಾಕ್ನಿ, ಬಾಬಾಕ್, ಬಾಯ್ಕ್, ಪೊರಾಕ್ನಿ, ಶೆತಾಕ್ನಿ ಸೊಡ್ತಾ, ತೆಂಕಾ ಸೆಂಬರ್ ವಾಟ್ಯಾನಿ ಘೆತಾ, ಅನಿ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್‍ಬಿ ತೆಕಾ ದಿವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ಖರೆ ಅತ್ತಾ ಫಿಡೆ ಹೊತ್ತಿ ಲೈ ಲೊಕಾ ಫಾಟಿಕ್ಡೆ ಹೊತ್ಯಾತ್, ಅನಿ ಫಾಟಿಕ್ಡೆ ಹೊತ್ತಿ ಲೊಕಾ ಫಿಡೆ ಹೊತ್ಯಾತ್.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ತನ್ನಾ ಜೆಜುನ್, ಸರ್ಗಾಚೊ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್ ಅಶೆ. ಎಗ್ದಾ ಎಕ್ ಮಾನುಸ್ ಸಕ್ಕಾಳಿ ಫಿಡೆ ಅಪ್ನಾಚ್ಯಾ ದರಾಕ್ಷಿಚ್ಯಾ ಮಳ್ಯಾತ್ ಕಾಮಾಕ್ ಯೆತಲಿ ಆಳಾ ಹುಡ್ಕುಕ್ ಮನುನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ತೆನಿ ತ್ಯಾ ಆಳಾಕ್ನಿ ಎಕ್ ದಿಸಾಕ್ ಎಕ್ ಚಾಂದಿಚೊ ಪೈಸೊ ದಿತಾ ಮನುನ್ ಸಾಂಗುನ್ ಅಪ್ನಾಚ್ಯಾ ಶೆತಾತ್ ಕಾಮಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ಮಾನಾ ಅನಿ ಎಗ್ದಾ ನ್ಹವ್ ಘಂಟ್ಯಾಕ್ ತೊ ಬಾಜಾರಾತ್ ಗೆಲೊ. ಅನಿ ಕಾಯ್ಬಿ ಕಾಮ್ ನಸ್ತಾನಾ ಇಬೆ ಹೊತ್ತ್ಯಾ ಉಲ್ಲ್ಯಾಸ್ಯಾ ಲೊಕಾಕ್ನಿ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ತೆಂಕಾ, ತುಮಿ ಬಿ ಮಾಜ್ಯಾ ಶೆತಾತ್ ಕಾಮಾಕ್ ಚಲಾ, ತುಮ್ಚಿ ಕಾಯ್ ತಿ ಮಜುರಿ ಮಿಯಾ ತುಮ್ಕಾ ದಿತಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ತನ್ನಾ ತೆನಿ ಗೆಲೆ. ಮಾನಾ ದೊಪಾರ್ಚೆ ಬಾರಾ ಘಂಟ್ಯಾಕ್ ಅನಿ ತಿನ್ ಘಂಟ್ಯಾಕ್ ತೆನಿ ಭಾಯ್ರ್ ಜಾವ್ನ್ ಅಪ್ನಾಚ್ಯಾ ಶೆತಾತ್ ಕಾಮ್ ಕರುಕ್ ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ಸಾದಾರನ್ ಪಾಚ್ ಘಂಟ್ಯಾಕ್ ತೊ ಅನಿ ಎಗ್ದಾ ಬಾಜಾರಾತ್ ಗೆಲೊ ಅನಿ ಕಾಯ್ಬಿ ಕಾಮ್ ನಸ್ತಾನಾ ಇಬೆ ಹೊತ್ತ್ಯಾ ಅನಿ ಉಲ್ಲ್ಯಾಸ್ಯಾ ಲೊಕಾಕ್ನಿ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ಅನಿ ತೆಂಕಾ, ದಿಸ್ ಬರ್ ಕಾಮ್ ಕರಿನಸ್ತಾನಾ ಕಶ್ಯಾಕ್ ಎಳ್ ಹಾಳ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ ತುಮಿ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ತನ್ನಾ ತೆನಿ, ಅಮ್ಕಾ ಕೊನ್ಬಿ ಕಾಮಾಕ್ ಬಲ್ವುಕ್‍ನ್ಯಾತ್. ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ತನ್ನಾ ತೆನಿ ತೆಂಕಾ,ತಸೆ ಜಾಲ್ಯಾರ್ ತುಮಿಬಿ ಜಾವಾ ಅನಿ ಮಾಜ್ಯಾ ಶೆತಾತ್ ಕಾಮಾಕ್‍ಲಾಗಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ಸಾಂಚೆಕ್ಡೆ ತ್ಯಾ ಮಳ್ಯಾಚ್ಯಾ ಮಾಲ್ಕಾನ್ ಅಪ್ನಾಚ್ಯಾ ಮಕಾದಮಾಕ್ ಬಲ್ವುಲ್ಯಾನ್. ಅನಿ, ಅದ್ದಿ ಬಲ್ವಲ್ಲ್ಯಾಕ್ನಾ ಧರುನ್ ಆಕ್ರಿಕ್ ಬಲ್ವಲ್ಲ್ಯಾ ಪತರ್ ಸಗ್ಳ್ಯಾಕ್ನಿ ತೆಂಚಿ-ತೆಂಚಿ ದಿಸಾಚಿ ಮಜುರಿ ವಾಟುನ್ ದಿ. ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ಪಾಚ್ ಘಂಟ್ಯಾಕ್ ಕಾಮಾಕ್ ಯೆವ್ನ್ ಲಾಗಲ್ಲ್ಯಾಕ್ನಿ ಸೈತ್ ಎಕ್ ಚಾಂದಿಚೊ ಪೈಸೊಚ್ ಮಜುರಿ ಗಾವ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ತನ್ನಾ ಸಕ್ಕಾಳಿ ಫಿಡೆ ಯೆಲ್ಲ್ಯಾಂಚಿ ಪಾಳಿ ಯೆಲಿ. ತೆನಿ ತೆಂಕಾ ಜಾಸ್ತಿಚಿ ಮಜುರಿ ಗಾವ್ತಾ ಮನುನ್ ಯವಜಲ್ಲ್ಯಾನಿ. ಖರೆ ತೆಂಕಾಬಿ ಎಕುಚ್ ಚಾಂದಿಚೊ ಪೈಸೊ ಗಾವ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ತೆನಿ ತೆ ಘೆಟ್ಲ್ಯಾನಿ ಅನಿ ಮಾಲ್ಕಾಚ್ಯಾ ವರ್‍ತಿ ಪುರ್‍ವುರುಕ್‍ಲಾಗ್ಲ್ಯಾನಿ.ಅನಿ, ");
INSERT INTO kans_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“ಅಮಿ ಸಕ್ಕಾಳ್ಚ್ಯಾನ್ ನಿಂಬ್ರಾತ್ ಅನಿ ಗರ್‍ಮಿತ್ ಕಾಮ್ ಕರ್ಲಾಂವ್, ಅನಿ ಹೆನಿ ಖಾಲಿ ಎಕುಚ್ ಎಕ್ ತಾಸ್ ಕಾಮ್ ಕರ್‍ಲ್ಯಾನಾತ್ ತೆಕಾಬಿ ಅಮ್ಕಾಬಿ ತವ್ಡಿಚ್ ಮಜುರಿ ದಿಲೆ”. ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ತನ್ನಾ ತ್ಯಾ ಮಾಲ್ಕಾನ್, ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್, ಮಾಜ್ಯಾ ದೊಸ್ತಾ, ಮಿಯಾ ತುಕಾ ಅನ್ನ್ಯಾಯ್ ಕರುಕ್ ನಾ. ಎಕ್ ದಿಸಾಚಿ ಮಜುರಿ ಎಕ್ ಚಾಂದಿಚೊ ಪೈಸೊ ಮನುನ್ ಮಿಯಾ ತುಕಾ ಸಾಂಗಟಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ಅತ್ತಾ ತುಜಿ ಸಾಂಗಲ್ಲಿ ಮಜುರಿ ಘೆ ಅನಿ ಘರಾಕ್ ಜಾ; ಆಕ್ರಿಕ್ ಯೆಲ್ಲ್ಯಾ ಹೆಕಾಬಿ ತುಕಾ ದಿಲ್ಲಿ ತವ್ಡಿಚ್ ಮಜುರಿ ದಿತಲಿ ಮಾಜಿ ಕುಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ಮಾಜೆ ಸ್ವತಾಚೆ ಪೈಸೆ ಮಿಯಾ ಮಾಕಾ ಪಾಜೆ ತಸೆ ಕರುಕ್ ಮಾಕಾ ಹಕ್ಕ್ ನಾ ಕಾಯ್? ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ಬರೆ ಕರ್‍ತಲೆ ಬಗುನ್ ಪೊಟಾತ್ ಜಳುಲಾ ಕಾಯ್‍? ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ತನ್ನಾ ಜೆಜುನ್,“ ಜೆ ಕೊನ್ ಫಿಡೆ ಹಾತ್ ತೆನಿ ಫಾಟಿ ಹೊತ್ಯಾತ್, ಅನಿ ಜೆ ಕೊನ್ ಫಾಟಿ ಹಾತ್ ತೆನಿ ಫಿಡೆ ಹೊತ್ಯಾತ್” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ಜೆಜು ಜೆರುಜಲೆಮಾಕ್ಡೆ ಜವ್‍ಲಾಗಲ್ಲೊ. ತನ್ನಾ ತೆಚಿ ಬಾರಾ ಶಿಸಾಬಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ. ಜಾತಾಜಾನಾಚ್ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಎವ್ಡೆಚ್ ಕಡೆಕ್ ಬಲ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ತೆಂಕಾ, ");
INSERT INTO kans_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ಆಯ್ಕಾ! ಅತ್ತಾ ಅಮಿ ಜೆರುಜಲೆಮಾ ಪತರ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾಂವ್. ಥೈ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಧರುನ್ ಮುಖ್ಯ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾಂಚ್ಯಾ ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾಂಚ್ಯಾ ಹಾತಾತ್ ದಿತ್ಯಾತ್. ತೆನಿ ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ಅನಿ ಮಾನಾ ತೆನಿ ತೆಕಾ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಹಾತಾತ್ ದಿತ್ಯಾತ್. ತೆನಿ ತೆಕಾ ಎಡ್ಸಡ್ತಾತ್, ಬಾರ್‍ಕೊಲಾನಿ ಮಾರ್‍ತ್ಯಾತ್ ಅನಿ ಕುರ್ಸಾರ್ ಮಾರ್‍ತ್ಯಾತ್. ಖರೆ ತಿನ್ ದಿಸಾಂಚ್ಯಾ ಮಾನಾ ತೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ಮಾನಾ ಜೆಬೆದೆವಾಚಿ ಬಾಯ್ಕೊ ಅಪ್ನಾಚ್ಯಾ ದೊನ್ ಲೆಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್ ತೆಚ್ಯಾ ಇದ್ರಾಕ್ ಮಾನ್ ಬಾಗ್ವುಲಿನ್ , ಅನಿ ಎಕ್ ಉಪ್ಕಾರ್ ಇಚಾರ್‍ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ತನ್ನಾ ಜೆಜುನ್ ತಿಕಾ “ಕಾಯ್ ತೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ಜೆಜುಕ್,“ತಿಯಾ ರಾಜಾ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಹ್ಯಾ ಮಾಜ್ಯಾ ದೊನಿಬಿ ಲೆಕಾಕ್ನಿ ಎಕ್ಲ್ಯಾಕ್ ತುಜ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ಡಾವ್ಯಾ ಬಾಜುಕ್ ಬಸ್ವುತಾ ಮನುನ್ ಮಾಕಾ ಗೊಸ್ಟ್ ದಿ.” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ತನ್ನಾ ತಿಚ್ಯಾ ಲೆಕಾಕ್ನಿ ಜೆಜುನ್,“ ತುಮಿ ಕಾಯ್ ಇಚಾರುಲ್ಯಾಶಿ, ಮನುನ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್ ಕಾಯ್? ಮಿಯಾ ಫಿತಲೆ ಹಾಯ್ ತ್ಯಾ ಕಸ್ಟಾಚ್ಯಾ ಆಯ್ದಾನಾತ್ಲೆ ತುಮ್ಚ್ಯಾನ್ ಫಿವ್ಕ್ ಹೊತಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ “ ಹೊಯ್ ಅಮ್ಕಾ ಫಿವ್ಕ್ ಹೊತಾ.” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ,“ ತುಮಿ ಮಿಯಾ ಫಿತಲ್ಯಾ ಕಸ್ಟಾಚ್ಯಾ ಆಯ್ದಾನಾತ್ಲೆ ತುಮಿ ಫಿತ್ಯಾಶಿ ತೆ ಖರೆ ಹಾಯ್. ಖರೆ ಕೊನ್ ಮಾಜ್ಯಾ ಉಜ್ವ್ಯಾಬಾಜುಕ್ ಅನಿ ರೊಡ್ಡ್ಯಾ ಬಾಜುಕ್ ಬಸ್ತಲೆ ಮನುನ್ ಎಚುನ್ ಕಾಡ್ತಲೊ ಅದಿಕಾರ್ ಮಾಕಾ ನಾ. ಜೆ ಕೊನಾಕ್ ತೊ ಜಾಗೊ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ತಯಾರ್ ಕರುನ್ ಥವ್ಲ್ಯಾನಾಯ್ ತೆಂಕಾ ತೊ ಗಾವ್ತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ಹುರಲ್ಲ್ಯಾ ಧಾ ಶಿಸಾನಿ ಹೆ ಆಯಿಕ್ಲ್ಯಾನಿ. ತನ್ನಾ ತೆಕಾ ಹ್ಯಾ ದೊನ್ ಭಾವಾಂಚ್ಯಾ ವರ್‍ತಿ ರಾಗ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ತೆಚೆಸಾಟ್ನಿ ಜೆಜುನ್ ತೆಂಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಎಕಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್. ಅನಿ “ಖಲ್ಯಾಬಿ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತೆ ಅದಿಕಾರಿ ಅಪ್ನಾ ವರ್‍ತಿ ಎಕ್ ಅದಿಕಾರ್ ಹಾಯ್ ಅನಿ ತೆಂಚ್ಯಾ ಮುಖಂಡಾಕ್ನಿ ಸಗ್ಳೆ ಕರ್‍ತಲೊ ಅದಿಕಾರ್ ಹಾಯ್ ಮನುನ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ಖರೆ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ತಸೆ ಹೊವ್ಚೆ ನ್ಹಯ್, ಜರ್ ತುಮ್ಚ್ಯಾತ್ಲೊ ಕೊನ್‍ಬಿ ಮೊಟೊ ಹೊವ್ಚೆ ಮನುನ್ ಯವಜ್ತಾ, ತೆನಿ ಹುರಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾಂಚೊ ಸೆವಕ್ ಹೊವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ಅನಿ ತುಮ್ಚ್ಯಾತ್ಲೊ ಜೊ ಕೊನ್ ಪಯ್ಲೆ ಹೊವ್ಚೆ ಮನುನ್ ಯವಜ್ತಾ ತೊ ದುಸ್ರ್ಯಾಂಚೊ ಗುಲಾಮ್ ಹೊವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಲೊಕಾನಿಕ್ನಾ ಸೆವಾ ಕರುನ್ ಘೆವ್ಕ್ ಮನುನ್ ಯೆವ್ಕ್ ನಾ. ತೊ ಸೆವಾ ಕರುಕ್ ಅನಿ ಲೈ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಜಿವ್ ದಿವ್ನ್ ತೆಂಕಾ ಸುಟ್ಕಾ ದಿವ್ಚೆ ಮನುನ್ ಯೆಲಾ!” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ ಜೆರಿಕೊ ಸೊಡುನ್ ಜಾತಾನಾ. ಲೊಕಾಂಚೊ ಎಕ್ ಮೊಟೊ ತಾಂಡೊ ತೆಂಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ಥೈ ರಸ್ತ್ಯಾಚ್ಯಾ ದಂಡೆಕ್ ಬಸಲ್ಲ್ಯಾ ದೊಗ್ಯಾ ಕುಡ್ಡ್ಯಾನಿ ಜೆಜು ಹಿತ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನ್ತಲೆ ಆಯ್ಕುನ್, “ಧನಿಯಾ, ದಾವಿದಾಚ್ಯಾ ಲೆಕಾ ಅಮ್ಚೆ ವರ್‍ತಿ ದಯಾ ದಾಕ್ವು!” ಮನುನ್ ಬೊಬ್ ಮಾರುಕ್ ಚಾಲು ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ಲೊಕಾನಿ ತೆಂಕಾ ಜೊರ್ ಕರುನ್ “ಗಪ್ ರ್‍ಹಾವಾ.” ಮಟ್ಲ್ಯಾನಿ. ಖರೆ ತೆನಿ ಅನಿ ಉಲ್ಲೆ ಜೊರಾನಿ, “ಧನಿಯಾ, ದಾವಿದಾಚ್ಯಾ ಲೆಕಾ ಅಮ್ಚೆ ವರ್‍ತಿ ದಯಾ ದಾಕ್ವು!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ತನ್ನಾ ಜೆಜು ಇಬೆ ರ್‍ಹಾಲೊ ಅನಿ ತೆಂಕಾ ಬಲ್ವುನ್, “ಮಿಯಾ ತುಮ್ಚ್ಯಾಸಾಟ್ನಿ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ತನ್ನಾ ತ್ಯಾ ಕುಡ್ಡ್ಯಾನಿ, “ಧನಿಯಾ, ಅಮ್ಕಾ ದಿಸಿ ಸರ್ಕೆ ಕರ್.” ಮನುನ್ ತೆಕಾ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಚೆ ವರ್‍ತಿ ದಯಾ ದಾಕ್ವುಲ್ಯಾನ್ ಅನಿ ತೆಂಚ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ಅಪಡ್ಲ್ಯಾನ್. ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೆಂಕಾ ದಿಸುಕ್‍ ಲಾಗ್ಲೆ. ತನ್ನಾ ತೆನಿ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾಚ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ಜೆಜು ಅನಿ ಶಿಸಾ ಜೆರುಜಲೆಮಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಭೆತ್ಪಗೆ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಒಲಿವ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಯೆಲ್ಯಾನಿ. ಥೈ ಜೆಜುನ್ ಶಿಸಾನಿತ್ಲ್ಯಾ ದೊಗೆ ಜಾನಾಕ್ನಿ ಬಲ್ವುಲ್ಯಾನ್ ಅನಿ ಫಿಡೆ ಧಾಡುನ್, ");
INSERT INTO kans_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ತುಮ್ಕಾ ಫಿಡೆ ದಿಸ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಜಾವಾ ಅನಿ ಗಾಂವಾತ್ ಭುತ್ತುರ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾಚ್ ಪೆಟ್ಯಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಭಾಂದಲ್ಲೆ ಎಕ್ ಗಾಡಾವ್ ತುಮ್ಕಾ ಗಾವ್ತಾ. ತೆಂಕಾ ಸೊಡಾ ಅನಿ ಮಾಜೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆವಾ. ");
INSERT INTO kans_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ಅನಿ ತುಮ್ಕಾ ಕೊನ್‍ಬಿ ಕಾಯ್ಬಿ ಇಚಾರ್ಲ್ಯಾರ್ ತೆಂಚ್ಯಾ ಧನಿಯಾಕ್ ತಿ ಪಾಜೆ ಹೊಲ್ಯಾತ್ ಅನಿ ಮಾನಾ ಲಗ್ಗುನಾಚ್ ತೊ ತೆಂಕಾ ಧಾಡುನ್ ದಿತಾ. ಮನುನ್ ಸಾಂಗಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ಪ್ರವಾದ್ಯಾನ್ ಸಾಂಗಟಲ್ಲೆ ಪುರಾ ಹೊವ್‍ಸಾಟ್ನಿ ಹೆ ಸಗ್ಳೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ಅಬಕ್, ತುಜೊ ರಾಜಾ ತುಜ್ಯಾ ಭುತ್ತುರ್ ಯೆವ್ಲಾ ತೊ ಖಾಯ್ಲ್ ಹೊವ್ನ್ ಚಲ್ತಲೊ, ಅನಿ ಗಾಡ್ವಾಚ್ಯಾ ಪೆಟ್ಯಾ ವರ್‍ತಿ ಬಸುನ್ ತೊ ಯೆತಾ. ಮನುನ್ ಸಿಯೊನ್ ಶಾರಾಕ್ ಸಾಂಗ್!” ");
INSERT INTO kans_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ತನ್ನಾ ಶಿಸಾ ಗೆಲಿ ಅನಿ ಜೆಜುನ್ ಕಾಯ್-ಕಾಯ್ ಕರುಕ್ ಸಾಂಗಲ್ಲ್ಯಾನ್ ತೆ ಸಗ್ಳೆ ತೆನಿ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ತೆನಿ ತ್ಯಾ ಗಾಡ್ವಾಕ್ ಅನಿ ಪೆಟ್ಯಾಕ್ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ ಅನಿ ತೆಂಚೆ ವರ್‍ತಿ ಅಪ್ನಾಚೆ ಕಪ್ಡೆ ಟಾಕ್ಲ್ಯಾನಿ. ಜೆಜು ತೆಚ್ಯಾ ವರ್‍ತಿ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ಲೊಕಾನಿ ಅಪ್ನಾಚೆ ಕಪ್ಡೆ ರಸ್ತ್ಯಾ ವರ್‍ತಿ ಹಾತರ್‍ಲ್ಯಾನಿ. ಅನಿ ಹುರಲ್ಲ್ಯಾನಿ ಝಾಡಾಂಚ್ಯಾ ಕವ್ಳ್ಯಾ ಟಾಳಿಯಾ ಮೊಡುನ್ ರಸ್ತ್ಯಾ ವರ್‍ತಿ ಘಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ಜೆಜುಚ್ಯಾ ಫಿಡೆ ಅನಿ ಫಾಟಿ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ. “ದಾವಿದಾಚ್ಯಾ ಲೆಕಾಕ್ ಹೊಗ್ಳಾಪ್! ಧನಿಯಾಚ್ಯಾ ನಾವಾನ್ ಯೆತಲ್ಯಾಕ್ ದೆವ್ ಆಶಿರ್ವಾದ್ ದಿಂವ್ದಿ! ದೆವಾಕ್ ಹೊಗ್ಳಾಪ್!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ಜೆಜು ಜೆರುಜಲೆಮಾತ್ ಭುತ್ತುರ್ ಗುಸಲ್ಲ್ಯಾ ತನ್ನಾ ಸಗ್ಳೆ ಶಾರ್ ಅವಾಜಾನ್ ಹಾಲುಲಾಗಲ್ಲೆ. ಅನಿ ಲೊಕಾನಿ “ ಹ್ಯೊ ಕೊನ್ ” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ತನ್ನಾ ತ್ಯಾ ತಾಂಡ್ಯಾತ್ಲ್ಯಾ ಲೊಕಾನಿ,“ಹ್ಯೊ ಗಾಲಿಲಿಯಾಚ್ಯಾ ನಜರೆತಾತ್ಲೊ ಜೆಜು ಎಕ್ ಪ್ರವಾದಿ.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ದಾರಾತ್ ಗೆಲೊ ಅನಿ ಇಕ್ತಲೆ, ಇಕಾತ್ ಘೆತಲೆ ಕರ್‍ತಲ್ಯಾಕ್ನಿ ಭಾಯ್ರ್ ಘಾಟ್ಲ್ಯಾನ್. ಪೈಸ್ಯಾಂಚೊ ಯಾವಾರ್ ಕರ್‍ತಲ್ಯಾಂಚಿ ಮೆಜಾ ತೆನಿ ಪಾಡ್ವುನ್ ಘಾಟ್ಲ್ಯಾನ್ ಅನಿ ಪಾರಿವಾಳಾ ಇಕ್ತಲ್ಯಾಂಚ್ಯಾ ಕುರ್‍ಚಿಯಾಬಿ ಪಾಡ್ವುನ್ ಘಾಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ಅನಿ ತೆಂಕಾ,“ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ದೆವ್‍ ಮನ್ತಾ, ಮಾಜಿ ಗುಡಿ ಮಾಗ್ನಿ ಕರ್‍ತಲೆ ಘರ್ ಮನ್ತ್ಯಾತ್. ಮನುನ್ ಲಿವಲ್ಲೆ ಹಾಯ್. ಖರೆ ತುಮಿ ತೆ ಚೊರಾನಿ ನಿಪುನ್ ರ್‍ಹಾತಲೊ ಜಾಗೊ ಕರುನ್ ಟಾಕ್ಲ್ಯಾಶಿ!” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ತನ್ನಾ ಕುಡ್ಡೆ ಅನಿ ಸೊಟ್ಟೆ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ತೆಚೆಕ್ಡೆ ಯೆಲೆ ಅನಿ ತೆನಿ ತೆಂಕಾ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ಹಿ ಸಗ್ಳಿ ವಿಚಿತ್ರ್ ಕಾಮಾ ಕರ್‍ತಲೆ ಬಗುನ್, ಅನಿ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಪೊರಾ, “ದಾವಿದಾಚ್ಯಾ ಲೆಕಾಕ್ ಹೊಗ್ಳಾಪ್!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ತಲೆ ಆಯ್ಕುನ್ ಮುಖ್ಯ ಯಾಜಕಾಕ್ನಿ ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾಕ್ನಿ ಲೈ ರಾಗ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ಜೆಜುಕ್,“ತೆನಿ ಕಾಯ್ ಮನುಲ್ಯಾತ್ ತುಕಾ ಆಯ್ಕೊ ಯೆವ್ಲಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ಕಾಯ್ ಕರುಕ್ ಹೊತಾ. ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್, ತುಮಿ ಪೊರಾಕ್ನಿ ಅನಿ ದುದ್ ಫಿತಲ್ಯಾ ಬಾಳ್‌ಶ್ಯಾಕ್ನಿ ಎಗ್ದಮ್ ಸಮಾ ರಿತಿನ್ ಹೊಗ್ಳಾಪ್ ದಿವ್ಚೆ ಮನುನ್ ಶಿಕ್ವುಲ್ಯಾಶಿ; ಮನುನ್ ವಾಚ್ವುಕ್‍ನ್ಯಾಶಿ ಕಾಯ್?” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ಮಾನಾ ಜೆಜು ತೆಂಕಾ ಥೈಚ್ ಸೊಡುನ್ ಭೆಥನಿ ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ ಗೆಲೊ ಅನಿ ಪುರಾ ರಾತ್ ಥೈಚ್ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ದುಸ್ರೆಂದಿಸ್ ಸಕ್ಕಾಳಿ ಫಿಡೆ ಜೆಜು ಅನಿ ಶಿಸಾ ಜೆರುಜಲೆಮಾಕ್ ಯೆತಾನಾ ವಾಟೆರ್ ಜೆಜುಕ್ ಭುಕ್‍ಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ತನ್ನಾ ರಸ್ತ್ಯಾಚ್ಯಾ ಬಾಜುಕ್ ಹೊತ್ತೆ ಅಂಜುರಾಚೆ ಝಾಡ್ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ಅನಿ ತೊ ತ್ಯಾ ಝಾಡಾಕ್ಡೆ ಹನ್ನಾ ಖಾವ್ಕ್ ಗೆಲೊ. ಖರೆ ತ್ಯಾ ಝಾಡಾಕ್ ಪಾನಾ ಸೊಡುನ್ ಎಕ್ ಸೈತ್ ಹನ್ನ್ ತೆಕಾ ಗಾವುಕ್ನಾ. ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ತ್ಯಾ ಝಾಡಾಕ್,“ಅನಿ ಫಿಡೆ ತುಕಾ ಕನ್ನಾಬಿ ಫಳಾ ಹೊಯ್‍ನಸ್ತಾನಾ ರ್‍ಹಾಂವ್ದಿತ್.” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆ ಅಂಜುರಾಚೆ ಝಾಡ್ ವಾಳುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ಶಿಸಾ ಹೆ ಬಗುನ್ ಅಜಾಪ್ ಹೊಲಿ. ಅನಿ,“ ಹೆ ಅಂಜುರಾಚೆ ಝಾಡ್ ಎವ್ಡ್ಯಾ ಲಗ್ಗುನಾ ಕಶೆ ವಾಳ್ಳೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ಜೆಜುನ್ ತೆಂಕಾ,“ ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ. ಮನಾತ್ ಸಂಶೆವ್ ಕರಿನಸ್ತಾನಾ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾರ್, ಮಿಯಾ ಹ್ಯಾ ಅಂಜುರಾಚ್ಯಾ ಝಾಡಾಕ್ ಕರ್ಲ್ಯಾ ಸರ್ಕೆ ತುಮಿಬಿ ಕರುಕ್ ಹೊತಾ. ಅನಿ ಎವ್ಡೆಚ್ ನ್ಹಯ್ ತುಮಿ ಎಕ್ ಮಡ್ಡಿಕ್ ಉಟ್ ಅನಿ ಸಮುಂದರಾತ್ ಜಾವ್ನ್ ಪಡ್. ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾರ್ ತುಮಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ಜರ್ ತರ್ ತುಮ್ಕಾ ವಿಶ್ವಾಸ್ ಹಾಯ್ ತರ್ ತುಮಿ ಮಾಗಲ್ಲೆ ಸಗ್ಳೆ ತುಮಿ ಘೆತ್ಯಾಶಿ.”ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ ಯೆಲೊ ಅನಿ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುಕಲಾಲೊ. ತನ್ನಾ ಮುಖ್ಯ ಯಾಜಕಾ ಅನಿ ಜಾನ್ತಿ ಲೊಕಾ ಜೆಜುಕ್ಡೆ ಯೆಲಿ. ಅನಿ ಜೆಜುಕ್,“ಹೆ ಸಗ್ಳೆ ಕರುಕ್ ತುಕಾ ಕಾಯ್ ಹಕ್ಕ್ ಹಾಯ್? ಹ್ಯೊ ಹಕ್ಕ್ ತುಕಾ ಕೊನ್ ದಿಲಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ಜೆಜುನ್ ತೆಂಕಾ,“ ಮಿಯಾ ತುಮ್ಕಾ ಎಕ್ ಸವಾಲ್ ಇಚಾರ್ತಾ ತೆಕಾ ತುಮಿ ಜಬಾಬ್ ದಿಲ್ಯಾರ್, ಹೆ ಸಗ್ಳೆ ಕರುಕ್ ಮಾಕಾ ಕೊನ್ ಹಕ್ಕ್ ದಿಲೊ, ಮನುನ್ ಮಿಯಾ ಸಾಂಗ್ತಾ.” ಮಟ್ಲ್ಯಾನ್, ಅನಿ, ");
INSERT INTO kans_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“ಜುವಾಂವ್ ಬಾವ್ತಿಸಾಕ್ ಬಾಲ್ತಿಮ್ ದಿತಲೊ ಹಕ್ಕ್ ಖೈತ್ನಾ ದಿಲ್ಲೊ ಹೊತ್ತೊ ಮಾನ್ಸಾಕ್ನಾ ಕಾಯ್ ಸರ್ಗಾತ್ನಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ಎಕಾಮೆಕಾತ್ನಿ ಬೊಲುನ್ ಘೆವ್ನ್, “ಅಮಿ ಕಾಯ್ ಸಾಂಗುವಾ? ದೆವಾಕ್ನಾ ಮಟ್ಲ್ಯಾರ್, ‘ತುಮಿ ಜುವಾಂವಾ ವರ್‍ತಿ ಕಶ್ಯಾಕ್ ವಿಶ್ವಾಸ್ ಕರುಕ್‍ನ್ಯಾಶಿ?’ ಮನುನ್ ತೊ ಇಚಾರ್ತಾ?” ");
INSERT INTO kans_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ಅನಿ ಅಮಿ ಮಾನ್ಸಾಕ್ನಾ ಮನುನ್ ಸಾಂಗ್ಲಾಂವ್ ತರ್ ಲೊಕಾ ಅಮ್ಕಾ ಕಾಯ್ ಕರ್‍ತ್ಯಾತ್ ಕಾಯ್ಕಿ ಮಟ್ಲ್ಯಾನಿ ಅನಿ ತೆನಿ ಲೊಕಾಕ್ನಿ ಭಿಂಯಾಲೆ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಲೊಕಾ ಜುವಾಂವ್ ಎಕ್ ಪ್ರವಾದಿ ಮನುನ್ ಮಾನಿತ್. ");
INSERT INTO kans_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ಜೆಜುಕ್, ಅಮ್ಕಾ ಗೊತ್ತ್ ನಾ ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ, ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ,“ತಸೆ ಜಾಲ್ಯಾರ್ ಮಿಯಾಬಿ ಕಸ್ಲ್ಯಾ ಹಕ್ಕಾನಿ ಹೆ ಸಗ್ಳೆ ಕರುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ತುಮ್ಕಾ ಸಾಂಗಿನಾ”. ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ಅತ್ತಾ ತುಮಿ ಕಾಯ್ ಮನ್ತ್ಯಾಶಿ? ಎಗ್ದಾ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೆಕಾ ದೊನ್ ಲೆಕಾ ಹೊತ್ತಿ. ತೊ ಮೊಟ್ಯಾ ಲೆಕಾಕ್ಡೆ ಜಾತಾ ಅನಿ,“ಲೆಕಾ ಆಜ್ ತಿಯಾ ದರಾಕ್ಷಿಚ್ಯಾ ಮಳ್ಯಾತ್ ಜಾ ಅನಿ ಕಾಮ್ ಕರ್”. ಮನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ತನ್ನಾ ತೊ ಲೆಕ್ ಮಿಯಾ ಜಾಯ್ನಾ ಮನ್ತಾ. ಖರೆ ಮಾನಾ ತೊ ಅಪ್ನಾಚೊ ಮನ್ ಬದಲ್ತಾ ಅನಿ ಬಾಬಾನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಕಾಮಾಕ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ಮಾನಾ ಬಾಬಾ ಅನಿ ಎಕ್ಲ್ಯಾ ಲೆಕಾಕ್ಡೆ ಜಾತಾ. ಅನಿ ತಸೆಚ್ ಸಾಂಗ್ತಾ. ತನ್ನಾ ತೊ ಲೆಕ್ ಹು ಬಾಬಾ ಮಿಯಾ ಜಾತಾ ಮನ್ತಾ. ಖರೆ ತೊ ಜಾಯ್ಚ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“ತರ್ ಹ್ಯಾ ದೊಗ್ಯಾನಿತ್ಲ್ಯಾ ಖಲ್ಯಾ ಲೆಕಾನ್ ಬಾಬಾಕ್ ಪಾಜೆ ಹೊಲ್ಲೆ ಕಾಮ್ ಕರ್‍ಲ್ಯಾನ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ,“ಪಯ್ಲೆಚ್ಯಾ ಲೆಕಾನ್.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ತೆಚೆಸಾಟ್ನಿ ಜೆಜುನ್ ತೆಂಕಾ,“ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲೆ ಅನಿ ವೈಬಿಚಾರ್ ಕರ್‍ತಲಿ ಲೊಕಾ ತುಮ್ಚ್ಯೆನ್ಕಿ ಅದ್ದಿ ದೆವಾಚ್ಯಾ ರಾಜಾತ್‍ ಜಾವ್ನ್ ಪಾವ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ಜುವಾಂವ್ ಬಾವ್ತಿಸ್ ತುಮ್ಕಾ ಬರಿ ವಾಟ್ ದಾಕ್ವುಕ್ ಮನುನ್ ಯೆಲೊ, ಖರೆ ತುಮಿ ತೆಚೆ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಕರುಕ್ನ್ಯಾಶಿ, ಖರೆ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲ್ಯಾನಿ ಅನಿ ವೆಭಿಚಾರ್ ಕರ್‍ತಲ್ಯಾ ಲೊಕಾನಿ ತೆಚೆ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನಿ. ಹೆ ಸಗ್ಳೆ ಬಗುನ್ಬಿ ತುಮಿ ತುಮ್ಚಿ ಮನಾ ಬದ್ಲುನ್‍ ತೆಚೆ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಕರುಕ್‍ನ್ಯಾಶಿ.” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ಜೆಜುನ್ “ಅನಿಎಕ್ ಕಾನಿ ಆಯ್ಕಾ” ಮಟ್ಲ್ಯಾನ್. ಎಗ್ದಾ ಎಕ್ ಶೆತಾಚೊ ಮಾಲಿಕ್ ಹೊತ್ತೊ. ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಶೆತಾತ್ ದ್ರಾಕ್ಷಿಚಿ ಝಾಡಾ ಲಾವ್ಲ್ಯಾನ್ ಭೊತ್ಯಾನಿ ಖುಪ್ ಘಾಟ್ಲ್ಯಾನ್, ಅನಿ ದ್ರಾಕ್ಷಿ ಮಳುಕ್ ಘಾನ್ಯಾಚೊ ಖಡ್ಡೊ ಖಂಡ್ಲ್ಯಾನ್. ಅನಿ ಶೆತ್ ರಾಕುಕ್ ಎಕ್ ಘಟ್ಮುಟ್ ಮಾಳೊ ಭಾಂದ್ಲ್ಯಾನ್. ಮಾನಾ ತೆ ಶೆತ್ ಗುತ್ಕೆ ಧರ್‍ತಲ್ಯಾಕ್ನಿ ಗುತ್ಕ್ಯಾನಿ ದಿಲ್ಯಾನ್ ಅನಿ ತೊ ಧುರ್‍ಲ್ಯಾ ದೆಸಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ದರಾಕ್ಷಿ ಗೊಳಾ ಕರ್‍ತಲೊ ಎಳ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಅಪ್ನಾಚೊ ಸುಗ್ಗಿಚೊ ವಾಟೊ ಘೆವ್ನ್ ಯೆವ್ಕ್ ಅಪ್ನಾಚ್ಯಾ ಆಳಾಕ್ನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ಗುತ್ಕೆ ಧರಲ್ಲ್ಯಾನಿ ತ್ಯಾ ಆಳಾಕ್ನಿ ಧರ್‍ಲ್ಯಾನಿ, ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ಮಾರ್ ಘಾಟ್ಲ್ಯಾನಿ, ದುಸ್ರ್ಯಾಕ್ ಜಿವಾನಿಚ್ ಮಾರ್‍ಲ್ಯಾನಿ, ಅನಿ ಅನಿಎಕ್ಲ್ಯಾಕ್ ಗುಂಡ್ಯಾನಿ ಮಾರ್‍ಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ಅನಿಬಿ ತ್ಯಾ ಮಾನ್ಸಾನ್ ಅನಿ ಎಗ್ದಾ ಲೈ ಆಳಾಕ್ನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ಖರೆ ತ್ಯಾ ಗುತ್ಕೆ ಧರಲ್ಲ್ಯಾನಿ ತೆಕಾಬಿ ಅದ್ದಿ ಕರಲ್ಲ್ಯಾಕ್ನಿ ಕರಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ಸಗ್ಳೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಆಕ್ರಿಕ್ ಮಾಜ್ಯಾ ಲೆಕಾಕ್ ತರ್‍ಬಿ ತೆನಿ ಆಯಿಕ್ತ್ಯಾತ್ ಮನುನ್ ಅಪ್ನಾಚ್ಯಾ ಎಕ್ಲ್ಯಾಚ್ ಲೆಕಾಕ್ ತೆನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ಖರೆ ತ್ಯಾ ಗುತ್ಕೆ ಧರಲ್ಲ್ಯಾನಿ ತೆಚ್ಯಾ ಲೆಕಾಕ್ ಬಗುನ್, ಹ್ಯೊ ಹ್ಯಾ ಶೆತಾಚ್ಯಾ ಮಾಲ್ಕಾಚೊ ಲೆಕ್, ಹೆಕಾ ಅಮಿ ಜಿವಾನಿಚ್ ಮಾರುವ್ವಾ. ಮಾನಾ ಹಿ ಸಗ್ಳಿ ಅಸ್ತಿ ಅಮ್ಕಾಚ್ ಹೊತಾ. ಮಟ್ಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ತನ್ನಾ ತೆನಿ ತೆಕಾ ಧರ್‍ಲ್ಯಾನಿ ಅನಿ ಶೆತಾತ್ನಾ ಭಾಯ್ರ್ ನ್ಹೆವ್ನ್ ಜಿವಾನಿ ಮಾರುನ್ ಟಾಕ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ತನ್ನಾ ಜೆಜುನ್, “ಅತ್ತಾ ತ್ಯಾ ಶೆತಾಚೊ ಮಾಲಿಕ್ ಯೆವ್ನ್ ತ್ಯಾ ಗುತ್ಕೆ ಧರಲ್ಲ್ಯಾಚೆ ಕಾಯ್ ಕರ್‍ತಾ ಮನುನ್ ತುಮಿ ಮನ್ತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ತನ್ನಾ ತೆನಿ, “ತೊ ಯೆವ್ನ್ ತ್ಯಾ ಬುರ್ಶ್ಯಾ ಗುತ್ಕೆ ಧರಲ್ಲ್ಯಾಕ್ನಿ ಖರೆಚ್ ಜಿವಾನಿ ಮಾರ್‍ತಾ ಅನಿ ಅಪ್ನಾಚೆ ಶೆತ್ ಸುಗ್ಗಿಕ್ ಅಪ್ನಾಚೊ ವಾಟೊ ದಿತಲ್ಯಾ ದುಸ್ರ್ಯಾ ಗುತ್ಕೆ ಧರ್‍ತಲ್ಯಾಕ್ನಿ ಗುತ್ಕ್ಯಾಕ್ ದಿತಾ.” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ಜೆಜುನ್ ತೆಂಕಾ,“ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಕಾಯ್ ಮನ್ತಾ ಮನುನ್ ತುಮಿ ವಾಚ್ವುಕ್‍ನ್ಯಾಶಿ ಕಾಯ್? ಭಾಂದ್ತಲ್ಯಾನಿ ಕಾಮಾಕ್ ಪಡಿನಸಲ್ಲೊ ಮನುನ್ ಟಾಕಲ್ಲೊ, ಗುಂಡೊಚ್ ಎಗ್ದಮ್ ಲೈ ಮಹತ್ವಾಚೊ ಗುಂಡೊ ಹೊಲೊ. ಸರ್ವೆಸ್ವರಾನ್ ಕರಲ್ಲೆ ಕಾಮ್ ಹೆ ಬಗುಕ್ ಹೆ ಕವ್ಡೆ ವಿಚಿತ್ರ್ ದಿಸ್ತಾ” ");
INSERT INTO kans_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ದೆವಾಚೊ ರಾಜ್ ತುಮ್ಚ್ಯಾಕ್ನಾ ಕಾಡುನ್ ಘೆವ್ನ್ ದೆವಾಕ್ ಪಾಜೆ ತಸೆ ಚಲ್ತಲ್ಯಾ ಲೊಕಾಕ್ನಿ ದಿವ್ನ್ ಹೊತಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ಹ್ಯಾ ಗುಂಡ್ಯಾ ವರ್‍ತಿ ಜೊ ಕೊನ್ ಪಡ್ತಾ. ತೊ ತುಕ್ಡೆ-ತುಕ್ಡೆ ಹೊತಾ, ಅನಿ ಹ್ಯೊ ಗುಂಡೊಚ್ ಕೊನಾ ವರ್‍ತಿ ತರ್ ಪಡ್ಲ್ಯಾರ್ ತೊ ಬುಕ್ನಾಚ್ ಹೊವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ಮುಖ್ಯ ಯಾಜಕಾನಿ ಅನಿ ಫಾರಿಜೆವಾನಿ ಜೆಜುನ್ ಸಾಂಗಲ್ಲಿ ಹಿ ಕಾನಿ ಆಯಿಕ್ಲ್ಯಾನಿ. ಅನಿ ತೊ ಅಪ್ನಾಕುಚ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ತೆಂಕಾ ಕಳ್ಳೆ. ");
INSERT INTO kans_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ತೆಕಾ ಧರುನ್ ಭಾಂದುಕ್ ಬಗಟ್ಲ್ಯಾನಿ. ಖರೆ ಲೊಕಾ ಜೆಜುಕ್ ಎಕ್ ಪ್ರವಾದಿ ಮನುನ್ ಮಾನುನ್ ಘೆಯ್ತ್ ತಸೆಮನುನ್ ತೆನಿ ಲೊಕಾಕ್ನಿ ಭಿಂಯಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ಅನಿ ಲೊಕಾಂಚ್ಯಾಕ್ಡೆ ಬೊಲ್ತಾನಾ ಜೆಜುನ್ ಕಾನಿಯಾ ವಾಪರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ಸರ್‍ಗಾಚೆ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್ ಅಶೆ. ಎಗ್ದಾ ಎಕ್ ರಾಜಾನ್ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಚ್ಯಾ ಲಗ್ನಾಚಿ ಮೊಟೆ ಜೆವಾನ್ ತಯಾರ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ಅನಿ ಮಾನಾ ಅಪ್ನಾಚ್ಯಾ ಸೈರ್‍ಯಾಕ್ನಿ ಲಗ್ನಾಚ್ಯಾ ಕಾರೆವಾಕ್ ಯೆವಾ ಮನುನ್ ಬಲ್ವುಕ್ ಅಪ್ನಾಚ್ಯಾ ಆಳಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ಖರೆ ತ್ಯಾ ಸೈರ್‍ಯಾಕ್ನಿ ತ್ಯಾ ಲಗ್ನಾಕ್ ಯೆವ್ಕ್ ಮನುಚ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ತಸೆಮನುನ್ ಅನಿ ಎಗ್ದಾ ತ್ಯಾ ರಾಜಾನ್ ಅಪ್ನಾಚ್ಯಾ ಆಳಾಕ್ನಿ, “ಜಾವಾ ಅನಿ ತ್ಯಾ ಸೈರ್‍ಯಾಕ್ನಿ ಬಕ್ರಿ ಅನಿ ಪಾಡ್ಕಾ ಕಾತ್ರುನ್ ಗರ್‍ದಿಚೆ ಜೆವಾನ್ ರಾಂದುನ್ ತಯಾರ್ ಕರುನ್ ಹೊಲಾ. ಜೆವ್ನಾಕ್ ಯೆವಾ ಮನುನ್ ಸಾಂಗಾ.” ಮನುನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ಖರೆ ಬಲ್ವಲ್ಲ್ಯಾ ಸೈರ್‍ಯಾನಿ ಬಲ್ವಲ್ಲ್ಯಾಕ್ ಧ್ಯಾನುಚ್ ದಿವ್ಕನ್ಯಾತ್, ತೆನಿ ತೆಂಚ್ಯಾ-ತೆಂಚ್ಯಾ ಧಂದ್ಯಾಕ್ನಿ ತೆನಿ ಗೆಲ್ಯಾನಿ; ಎಕ್ಲೊ ಅಪ್ನಾಚ್ಯಾ ಶೆತಾಕ್ಡೆ ಗೆಲೊ, ಅನಿ ಎಕ್ಲೊ ಅಪ್ನಾಚ್ಯಾ ದುಕಾನಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ಅನಿ ಹುರಲ್ಲ್ಯಾನಿ ಬಲ್ವುಕ್ ಯೆಲ್ಲ್ಯಾ ಆಳಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬುರ್ಶೆ ಕರ್‍ಲ್ಯಾನಿ, ಧರ್‍ಲ್ಯಾನಿ ಅನಿ ಜಿವಾನಿಚ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ತನ್ನಾ ರಾಜಾಕ್ ಲೈ ರಾಗ್ ಯೆಲೊ; ತಸೆಮನುನ್ ರಾಜಾನ್ ಅಪ್ನಾಚ್ಯಾ ಸೈನಿಕಾಕ್ನಿ ಧಾಡುನ್ ತ್ಯಾ ಖುನಿಗಾರಾಕ್ನಿ ಜಿವಾನಿ ಮಾರುಕ್ ಲಾವುನ್ ತೆಂಚೆ ಶಾರುಚ್ ಜಾಳ್ವುನ್ ಟಾಕ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ಮಾನಾ ಅಪ್ನಾಚ್ಯಾ ಆಳಾಕ್ನಿ ಬಲ್ವುಲ್ಯಾನ್ ಅನಿ ತೆಂಕಾ, “ಮಾಜೆ ಲಗ್ನಾಚೆ ಜೆವಾನ್ ತಯಾರ್ ಹಾಯ್, ಖರೆ ಮಿಯಾ ಬಲ್ವಲ್ಲ್ಯಾ ಸೊಯ್ರ್ಯಾಕ್ನಿ ತೆ ನಕ್ಕೊ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ಅತ್ತಾ ತುಮಿ ಮೊಟ್ಯಾ-ಮೊಟ್ಯಾ ವನಿಯಾತ್ನಿ ಜಾವಾ ಅನಿ ಕವ್ಡಿ ಗಾವ್ತಾತ್ ತವ್ಡ್ಯಾ ಲೊಕಾಕ್ನಿ ಗರ್‍ದಿಚ್ಯಾ ಜೆವ್ನಾಕ್ ಬಲ್ವುನ್ ಹಾನಾ.” ಮನುನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ಅಶೆ ಆಳಾ ವನಿಯಾತ್ನಿ ಗೆಲಿ, ಅನಿ ಬರ್‍ಯಾಕ್ನಿ, ಬುರ್ಶ್ಯಾಕ್ನಿ ಮನಿನಸ್ತಾನಾ ಗಾವ-ಗಾವಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಗೊಳಾ ಕರುನ್ ಬಲ್ವುನ್ ಹಾನ್ಲ್ಯಾನಿ. ಅಶೆ ಲಗ್ನಾಚೊ ಮಾಟವ್ ಲೊಕಾನಿ ಭರ್‍ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ರಾಜಾ ಲಗ್ನಾಕ್ ಯೆಲ್ಲ್ಯಾ ಸೊಯ್ರ್ಯಾಕ್ನಿ ಬಗುಕ್ ಯೆಲೊ ತನ್ನಾ ಲಗ್ನಾಕ್ ಮನುನ್ ನೆಸ್ತಲೆ ಕಪ್ಡೆ ನೆಸುನಸಲ್ಲೊ ಎಕ್ ಮಾನುಸ್ ತೆಕಾ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ರಾಜಾನ್ ತೆಕಾ “ದೊಸ್ತಾ, ಲಗ್ನಾಕ್ ನೆಸ್ತಲೆ ಕಪ್ಡೆ ನೆಸಿನಸ್ತಾನಾ ತಿಯಾ ಹಿತ್ತೆ ಕಸೊ ಭುತ್ತುರ್ ಯೆಲೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ಖರೆ ತ್ಯಾ ಮಾನ್ಸಾನ್ ತೆಕಾ ಕಾಯ್ಬಿ ಸಾಂಗುಕ್‍ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ತನ್ನಾ ರಾಜಾನ್ ಅಪ್ನಾಚ್ಯಾ ಆಳಾಕ್ನಿ “ಹ್ಯಾ ಮಾನ್ಸಾಚೆ ಹಾತ್-ಪಾಯ್ ಭಾಂದಾ ಅನಿ ಭಾಯ್ರ್ ಕಾಳ್ಕಾತ್ ಟಾಕಾ. ಥೈ ತೊ ರಡ್ತಾ ಅನಿ ದಾತಾ ಚಾವ್ತಾ,” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“ಅಶೆ ಲೈ ಜಾನಾಕ್ನಿ ಬಲ್ವಲ್ಲೆ ಹಾಯ್. ಖರೆ ಉಲ್ಲ್ಯಾಕ್ನಿ ತವ್ಡೆಚ್ ಎಚುನ್ ಕಾಡಲ್ಲೆ ಹಾಯ್.” ಮನುನ್ ಸಾಂಗುನ್ ಜೆಜುನ್ ಕಾನಿ ಮುಗಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ಫಾರಿಜೆವಾನಿ ಜಾವ್ನ್ ಜೆಜುಕ್ ಸವಾಲಾತ್ನಿ ಸಿರ್ಕುನ್ ಘಾಲುಚೆ ಮನುನ್ ಬೊಲುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಉಲ್ಲ್ಯಾ ಶಿಸಾಕ್ನಿ ಅನಿ ಹೆರೊದಾಚ್ಯಾ ಪಕ್ಷಾಚ್ಯಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುನ್ ಜೆಜುಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ. ತೆನಿ ಜಾವ್ನ್ ಜೆಜುಕ್, “ಗುರುಜಿ, ತಿಯಾ ಕೊನಾಚ್ಯಾ ಮೊಟೆಪಾನಾಕ್-ಗಿನಾಕ್ ಲೆಕ್ಕ್ ಕರಿನಸ್ತಾನಾ ದೆವಾಚ್ಯಾ ಮನಾ ಸರ್ಕೆ ಕಾಯ್ ಖರೆ ಹಾಯ್ ತೆಚ್ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುತೆ ಅನಿ ಸಾಂಗ್ತೆ ತೆ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿಯಾ ಕೊನಾಕ್ಬಿ ಭಿಯಾತಲೊ ಮಾನುಸ್ ನ್ಹಯ್.” ");
INSERT INTO kans_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ತರ್ ಅಮ್ಕಾ“ಅಮಿ ರೊಮಾಚ್ಯಾ ಚಕ್ರವರ್ತಿಕ್ ತೆರ್‍ಗಿ ದಿತಲೆ ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಸಮಾ ಕಾಯ್ ಚುಕ್ ಮನ್ತೆಯ್? ಸಾಂಗ್” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ತೆಂಚಿ ಬುರ್ಶಿ ಯವ್ಜನ್ ಕಾಯ್ ಮನುನ್ ಜೆಜುಕ್ ಗೊತ್ತ್ ಹೊತ್ತೆ. ತಸೆಮನುನ್ ತೆನಿ,“ತುಮಿ ಕುಸ್ಡ್ಯಾನು! ಮಾಕಾ ಗೊಂದ್ಳುನ್ ಘಾಲುಚೆ ಮನುನ್ ತುಮಿ ಕಶ್ಯಾಕ್ ಯೌಜುಲ್ಯಾಸಿ? ");
INSERT INTO kans_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ತೆರ್‍ಗಿ ಭರ್‍ತಲಿ ಎಕ್ ಪೈಸ್ಯಾಚಿ ಗಾಲಿ ಮಾಕಾ ದಾಕ್ವಾ ಬಗುವಾ!” ಮಟ್ಲ್ಯಾನ್. ತೆನಿ ಎಕ್ ಪೈಸ್ಯಾಚಿ ಗಾಲಿ ತೆಕಾ ಹಾನುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ತೆನಿ ತೆಂಕಾ,“ ಹೆಚ್ಯಾ ವರ್‍ತಿ ಕೊನಾಚೆ ನಾವ್ ಅನಿ ಚಿತ್ತರ್ ಹಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ತನ್ನಾ ತೆನಿ, “ಚಕ್ರವರ್ತಿಚೆ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ,“ತಸೆಹೊಲ್ಯಾರ್, ಜೆ ಕಾಯ್ ಚಕ್ರವರ್ತಿಕ್ ಸಮಂದ್‍ ಪಡಲ್ಲೆ ಹಾಯ್, ತೆ ಚಕ್ರವರ್ತಿಕ್ ದಿವಾ, ಅನಿ ಜೆ ಕಾಯ್ ದೆವಾಕ್ ಸಮಂದ್‍ ಪಡಲ್ಲೆ ಹಾಯ್ ತೆ ದೆವಾಕ್ ದಿವಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ಹೆ ಆಯ್ಕುನ್ ತೆನಿ ಅಜಾಪ್ ಹೊಲ್ಯಾನಿ ಅನಿ ತೆಕಾ ಸೊಡುನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ತ್ಯಾಚ್ ದಿಸಿ ಉಲ್ಲೆ ಸಾದುಸೆವ್ ಜೆಜುಕ್ಡೆ ಯೆಲೆ, ಅನಿ ಲೊಕಾ ಮರುನ್ ಮರ್‍ನಾತ್ನಾ ಝಿತ್ತಿ ಹೊವ್ನ್ ಉಟಿನಾತ್ ಮನುನ್ ಸಾಂಗುಕ್‍ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ತೆನಿ ಜೆಜುಕ್,“ಗುರುಜಿ, ಮೊಯ್ಜೆನ್ ಎಕ್ ಮಾನುಸ್ ಪೊರಾ ನಸ್ತಾನಾ ಮರ್ಲ್ಯಾರ್ ತೆಚ್ಯಾ ಭಾವಾನ್ ತೆಚ್ಯಾ ಬಾಯ್ಕೊಕ್ಡೆ ಲಗಿನ್ ಕರುನ್ ಘೆವ್ಚೆ. ಅನಿ ತೆಂಕಾ ಜಲಮಲ್ಲಿ ಪೊರಾ ತ್ಯಾ ಮರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಚಿ ಪೊರಾ ಮನುನ್ ಲೆಕ್ಕ್, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ತಸೆಹೊಲ್ಯಾರ್, ಎಗ್ದಾ ಸಾತ್ ಜಾನಾ ಭಾವಾ ಹೊತ್ತಿ. ಥೊರ್‍ಲೊ ಭಾವ್ ಲಗಿನ್ ಹೊಲೊ ಅನಿ ಪೊರಾ ನಸ್ತಾನಾ ಮರ್ಲೊ. ಅಶೆ ತ್ಯಾ ಮರಲ್ಲ್ಯಾಚೊ ಭಾವ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ಡೆ ಲಗಿನ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ದೊನ್ವೆಚ್ಯಾಕ್‍ಬಿ ತಸೆಚ್ ಹೊಲೆ. ತಿನ್ವೆಚ್ಯಾಕ್‍ಬಿ, ಅಶೆ ಸಾತ್ ಭಾವಾಕ್ನಿಬಿ ತಸೆಚ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ತೆಂಚ್ಯಾ ಮಾನಾ ತಿ ಬಾಯ್ಕೊಮನುಸ್‍ಬಿ ಮರ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ತೆನಿ ಸಾತ್ ಜಾನಾಬಿ ತಿಚೆಕ್ಡೆ ಲಗಿನ್ ಹೊಲ್ಲೆ ನ್ಹಯ್. ತರ್, ಮರಲ್ಲೆ ಝಿತ್ತೆ ಹೊವ್ನ್ ಉಟುನ್ ಯೆತಾನಾ, ತಿ ಬಾಯ್ಕೊಮನುಸ್ ಕೊನಾಚಿ ಬಾಯ್ಕೊ ಹೊತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ಜೆಜುನ್ ತೆಂಕಾ,“ತುಮಿ ಕವ್ಡೆ ಚುಕ್ ಯವ್ಜುನ್ ಘೆವ್ನ್ ಹಾಸಿ! ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾಚಿ ನಾಹೊಲ್ಯಾರ್ ದೆವಾಚ್ಯಾ ತಾಕ್ತಿಚ್ಯಾ ವಿಶಯಾತ್ ತುಮ್ಕಾ ಕಾಯ್ಬಿ ಗೊತ್ತ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ಮರ್‍ನಾತ್ನಾ ಝಿತ್ತೆ ಹೊವ್ನ್ ಉಟುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಸರ್‍ಗಾತ್ ದೆವಾಚ್ಯಾ ದುತಾ ಸರ್ಕೆ ಹೊತ್ಯಾತ್, ಅನಿ ಲಗಿನ್ ಕರುನ್ ಘೆಯ್‍ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ಮರಲ್ಲೆ ಝಿತ್ತೆ ಹೊತಲ್ಯಾ ವಿಶಯಾತ್ ದೆವಾನ್ ಕಾಯ್ ಮಟ್ಲ್ಯಾನಾಯ್ ಮನುನ್ ತುಮಿ ವಾಚ್ವುಕ್‍ನ್ಯಾತ್ ಕಾಯ್? ದೆವ್ ಮನ್ತಾ, ");
INSERT INTO kans_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ಮಿಯಾ ಅಬ್ರಾಹಾಮಾಚೊ ದೆವ್, ಇಸಾಕಾಚೊ ದೆವ್, ಅನಿ ಜಾಕೊಬಾಚೊ ದೆವ್. ಅಶೆ ಮಟ್ಲ್ಯಾರ್ ಝಿತ್ತ್ಯಾಂಚೊ ದೆವ್ ತೊ ಮರಲ್ಲ್ಯಾಂಚೊ ನ್ಹಯ್.” ");
INSERT INTO kans_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ಹೆ ಅಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ತೊ ಸಿಕ್ವುತಲೆ ಆಯ್ಕುನ್ ಲೊಕಾ ಲೈ ಅಜಾಪ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ಜೆಜುನ್ ಸಾದುಸೆವಾನಿ ತೊಂಡಾ ಧಾಪಿ ಸರ್ಕೆ ಕರಲ್ಲೆ ಬಗುನ್ ಫಾರಿಜೆವಾ ಎಕಾಕ್ಡೆ ಗೊಳಾ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾ ಮೊಯ್ಜೆಚೆ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾನ್ ಜೆಜುಕ್ ಗೊಂದ್ಳುನ್ ಘಾಲುಸಾಟ್ನಿ ಮನುನ್ ಸವಾಲ್ ಇಚಾರುನ್ ಖಟ್ಪಟುನ್ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ತೆನಿ ಜೆಜುಕ್,“ಗುರುಜಿ, ಖಾಯ್ದ್ಯಾತ್ನಿ ಸಗ್ಳ್ಯಾಂಚ್ಯಾನ್ ಮೊಟೊ ಉಪಾದೆಸ್ ಖಲೊ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ, “ತುಜ್ಯಾ ಪುರಾ ಕಾಳ್ಜಾನ್, ತುಜ್ಯಾ ಪುರಾ ಜಿವಾನ್, ಅನಿ ತುಜ್ಯಾ ಪುರಾ ಮನಾನ್ ಸರ್ವೆಸ್ವರಾಚೊ, ತುಜ್ಯಾ ದೆವಾಚೊ ಪ್ರೆಮ್ ಕರ್. ");
INSERT INTO kans_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ಹ್ಯೊ ಸಗ್ಳ್ಯಾನ್ ಮೊಟೊ ಅನಿ ಲೈ ಗರ್ಜೆಚೊ ಖಾಯ್ದೆ ");
INSERT INTO kans_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ದೊನ್ವೆಚೊ ಲೈ ಗರ್ಜೆಚೊ ಉಪಾದೆಸ್ ಮಟ್ಲ್ಯಾರ್, ತುಜೊಚ್ ತಿಯಾ ಕಸೊ ಪ್ರೆಮ್ ಕರ್‍ತೆ ತಸೊ ತುಜ್ಯಾ ಸೆಜಾರ್‍ಯಾಚೊ ಪ್ರೆಮ್ ಕರ್ ");
INSERT INTO kans_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ಸಗ್ಳೆ ಮೊಯ್ಜೆಚೆ ಖಾಯ್ದೆ ಅನಿ ಪ್ರವಾದ್ಯಾಂಚೆ ಶಿಕಾಪ್ ಹ್ಯಾ ದೊನ್ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿಚ್ ಠಿಕುನ್ ಹಾತ್.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ಉಲ್ಲಿ ಫಾರಿಜೆವಾ ಎಕಾಕ್ಡೆ ಗೊಳಾ ಹೊಲ್ಲಿ ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, ");
INSERT INTO kans_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ಕ್ರಿಸ್ತಾಚ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ಕಾಯ್ ಮನ್ತ್ಯಾಶಿ? ತೊ ಕೊನಾಚ್ಯಾ ಘರಾನ್ಯಾಚೊ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತೆನಿ “ತೊ ದಾವಿದಾಚ್ಯಾ ಘರಾನ್ಯಾಚೊ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ತನ್ನಾ ಜೆಜುನ್, “ತಸೆಹೊಲ್ಯಾರ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ದಾವಿದಾಕ್ ಕ್ರಿಸ್ತಾಕ್ ಧನಿ ಮನುನ್ ಬಲ್ವಿ ಸರ್ಕೆ ಕಶ್ಯಾಕ್ ಕರ್‍ಲ್ಯಾನ್?” ದಾವಿದ್ ಮನ್ತಾ, ");
INSERT INTO kans_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ಧನಿಯಾನ್ ಮಾಜ್ಯಾ ಧನಿಯಾಕ್ ಸಾಂಗ್ಲ್ಯಾನ್: ತುಜ್ಯಾ ದುಸ್ಮಾನಾಕ್ನಿ ತುಜ್ಯಾ ಪಾಯಾ ಖಾಲ್ತಿ ಘಾಲಿ ಪತರ್, ಹಿತ್ತೆ ಮಾಜ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಬಸ್. ");
INSERT INTO kans_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ಜರ್ ದಾವಿದ್ ಕ್ರಿಸ್ತಾಕ್ ಧನಿ ಮನುನ್ ಬಲ್ವುತಾ ತರ್, ಕ್ರಿಸ್ತ್ ದಾವಿದಾಚ್ಯಾ ಘರಾನ್ಯಾಚೊ ಕಸೊ ಹೊವ್ಕ್ ಹೊತಾ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ಹಿತ್ತೆ ಜೆಜುಕ್ ಜಬಾಬ್ ದಿವ್ಕ್ ಕೊನಾಕ್ಬಿ ಹೊವ್ಕ್ ನಾ. ತ್ಯಾ ದಿಸಾಕ್ನಾ ಜೆಜುಕ್ ಸವಾಲ್ ಇಚಾರುಕ್ ಕೊನಾಕ್ಬಿ ಧೈರೊ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ತನ್ನಾ ಜೆಜುನ್ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ಡೆ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾಕ್ಡೆ ಬೊಲುನ್ಗೆತ್ ಅಶೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಅನಿ ಫಾರಿಜೆವಾಕ್ನಿ ಮೊಯ್ಜೆಚೆ ಖಾಯ್ದೆ ಸೊಡ್ಸುನ್ ಸಾಂಗುಕ್ ಅನಿ ಶಿಕ್ವುಕ್ ನೆಮಸಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ತಸೆಮನುನ್ ತೆನಿ ಕಾಯ್ ಕರುಚೆ ಮನುನ್ ಸಾಂಗ್ತ್ಯಾತ್ ತೆ ಸಗ್ಳೆ ತುಮಿ ಕರಾ ಅನಿ ಪಾಳಾ; ಖರೆ ತೆಂಚ್ಯಾ ಚಲ್ನುಕಿ ಸರ್ಕೆ ತುಮಿ ಚಲುನಕಾಶಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಶಿಕ್ವುತಾತ್ ಖರೆ ತೆಚ್ಯಾ ಸರ್ಕೆ ಚಲಿನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ಲೊಕಾಕ್ನಿ ಡುಬ್ರಿರ್ ವಾವುನ್ ಘೆವ್ಕ್ ತರಾಸ್ ಹೊತಾ ತಸ್ಲಿ ವಜ್ಜಿ ತೆನಿ ಭಾಂದ್ತ್ಯಾತ್, ಖರೆ ತೆ ವಜ್ಜೆ ವಾವುಕ್ ಮಜತ್ ಕರುಕ್ ಮನುನ್ ಎಕ್ ಬೊಟ್ ಸೈತ್ ಲಾವುಕ್ ತೆನಿ ಮನ್ ಕರಿನಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ಲೊಕಾಕ್ನಿ ದಾಕ್ವುಸಾಟ್ನಿ ಮನುನ್ ತೆನಿ ಸಗ್ಳೆ ಕರುನ್ ದಾಕ್ವುತ್ಯಾತ್. ತೆಂಚ್ಯಾ ಕಪಾಳಾ ವೈನಿ ಅನಿ ರಟ್ಟ್ಯಾಕ್ನಿ ಭಾಂದಲ್ಲ್ಯಾ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ಲಿವಲ್ಲ್ಯಾ ಪಟ್‍ಯಾ ಬಗಾ, ತ್ಯಾ ಕವ್ಡ್ಯಾ ಮೊಟ್ಯಾ-ಮೊಟ್ಯಾ ಹಾತ್ ಮನುನ್ ಉಲ್ಲೆ ತರಕ್ ದಿವ್ನ್ ಬಗಾ! ತೆಂಚ್ಯಾ ಝಗ್ಯಾಕ್ನಿ ಹೊತ್ತೆ ಘೊಂಡೆ ಬಗಾ ಕವ್ಡೆ ಲಾಂಬ್-ಲಾಂಬ್ ಹಾತ್! ");
INSERT INTO kans_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ಸನಾಕ್ ಗೆಲ್ಲ್ಯಾಕ್ಡೆ ಅನಿ ಸಿನಾಗೊಗಾತ್ ಬರ್‍ಯಾ-ಬರ್‍ಯಾ ಜಾಗ್ಯಾ ವೈನಿ ಬಸುಕ್ ತೆಂಕಾ ಲೈ ಕುಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ಬಾಜಾರಾತ್ನಿ ಲೊಕಾನಿಕ್ನಾ ನಮಸ್ಕಾರ್ ಕರುನ್ ಘೆತಲೆ ಅನಿ ಗುರು ಮನುನ್ ಬಲ್ವುನ್ ಘೆತಲಿ ತೆಂಕಾ ಲೈ ಕುಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ತುಮಿ ಗುರು ಮನುನ್ ಕೊನಾಕ್‍ಬಿ ಬಲ್ವುತಲೆ ನಕ್ಕೊ. ತುಮಿ ಸಗ್ಳೆ ಜಾನಾ ಎಕಾಮೆಕಾಚೆ ಭಾವ್- ಭೆನಿಯಾ ಅನಿ ತುಮ್ಚೊ ಗುರು ಎಕ್ಲೊಚ್. ");
INSERT INTO kans_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ತುಮಿ ಹಿತ್ತೆ ಹ್ಯಾ ಜಗಾತ್ ಕೊನಾಕ್ಬಿ ಬಾಬಾ ಮನುನ್ ಬಲ್ವುತಲೆ ನಕ್ಕೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸರ್‍ಗಾ ವೈಲೊ ದೆವ್ ಎಕ್ಲೊಚ್ ತುಮ್ಚೊ ಬಾಬಾ. ");
INSERT INTO kans_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ತುಮಿ ಮುಖಂಡ್ ಮನುನ್ ಬಲ್ವುನ್ ಘೆತಲೆಬಿ ನಕ್ಕೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಕ್ರಿಸ್ತ್ ಎಕ್ಲೊಚ್ ತುಮ್ಚೊ ಮುಖಂಡ್. ");
INSERT INTO kans_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ತುಮ್ಚ್ಯಾತ್ ಮೊಟೊ ಮನುನ್ ಹೊತ್ತೊ ತುಮ್ಚೊ ಆಳ್ ಹೊಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ಜೊ ಕೊನ್ ಅಪ್ನಾಕುಚ್ ಖಾಲ್ತಿ ಕರ್‍ತಾ ತೆಕಾ ವರ್‍ತಿ ಕರುನ್ ಹೊತಾ. ಜೊ ಕೊನ್ ಅಪ್ನಾಕುಚ್ ವರ್‍ತಿ ಕರ್‍ತಾ ತೆಕಾ ಖಾಲ್ತಿ ಕರುನ್ ಹೊತಾ.” ");
INSERT INTO kans_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ಫಾರಿಜೆವಾನು ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನು ಮಿಯಾ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಕುಸ್ಡೆ ತುಮಿ! ಲೊಕಾ ಸರ್‍ಗಾಚ್ಯಾ ರಾಜಾತ್ ಜಾತಾನಾ ತುಮಿ ತೆಂಕಾ ದಾರ್ ಬಂದ್ ಕರುನ್ ಥವ್ತ್ಯಾಶಿ, ತುಮಿಬಿ ತ್ಯಾತುರ್ ಭುತ್ತುರ್ ಗುಸಿನ್ಯಾಸಿ ಅನಿ ಗುಸುಕ್ ಮನುನ್ ಖಟ್ಪಟ್ತಲ್ಯಾಕ್ನಿಬಿ ತ್ಯಾತುರ್ ಭುತ್ತುರ್ ಗುಸುಕ್ ದಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ಫಾರಿಜೆವಾನು ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನು ಮಿಯಾ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಕುಸ್ಡೆ ತುಮಿ! ತುಮಿ ಘೊ ಮರಲ್ಲ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾಕ್ನಿ ಮೊಸ್ ಕರುನ್ ತೆಂಚ್ಯಾ ಘರಾನಿತ್ಲೆ ಸಗ್ಳೆ ಕಾಡುನ್ ಘೆತ್ಯಾಶಿ ಅನಿ ಲಾಂಬ್-ಲಾಂಬ್ ಮಾಗ್ನಿಯಾ ಕರುನ್ ಅಪ್ನಿ ಬರಿ ಲೊಕಾ ಮನುನ್ ದಾಕ್ವುತ್ಯಾಶಿ! ಹೆಚೆಸಾಟ್ನಿ ತುಮ್ಕಾ ಮೊಟಿ ಶಿಕ್ಷಾ ರಾಕುನ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ಫಾರಿಜೆವಾನು ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನು ಮಿಯಾ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಕುಸ್ಡೆ ತುಮಿ! ಎಕ್ ಮಾನ್ಸಾಕ್ ತುಮ್ಚ್ಯಾ ಶಾಸ್ತರಾ ಸರ್ಕೆ ಚಲಿ ಸರ್ಕೆ ಕರುಕ್ ಮನುನ್ ಸಮುಂದರಾಂಚಿ ಸಮುಂದರಾ ದಾಟುನ್ ತುಮಿ ಜಾತ್ಯಾಶಿ, ಅನಿ ಕೊನ್ಬಿ ಎಕ್ಲೊ ಗಾವ್ಲೊ ತರ್ ತೆಕಾಬಿ ತುಮ್ಚ್ಯಾನ್ ದೊನ್‍ಪಟ್ ನರ್‍ಕಾತ್ ತೆಕಾ ಶಿಕ್ಷಾ ಗಾವುಚಿ ತವ್ಡೆ ಬುರ್ಶೆಪಾನ್ ಶಿಕ್ವುತ್ಯಾಶಿ!” ");
INSERT INTO kans_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ಲೊಕಾಕ್ನಿ ವಾಟ್ ದಾಕ್ವುತಲ್ಯಾ ಕುಡ್ಡ್ಯಾನು ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಕೊನ್ ತರ್ ದೆವಾಚ್ಯಾ ಗುಡಿ ವರ್‍ತಿ ಆನ್ ಘಾಲುನ್ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾರ್ ತೆನಿ ತಿ ಮಾಗ್ನಿ ಪುರಾ ಕರುಚಿ ಮನುನ್ ನಾ, ಖರೆ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ಲ್ಯಾ ಸೊನ್ಯಾಚ್ಯಾ ವರ್‍ತಿ ಆನ್ ಘಾಲುನ್ ಮಾಗುನ್ ಘೆಟಲ್ಲೆ ರ್‍ಹಾಲ್ಯಾರ್ ತೆನಿ ತಿ ಮಾಗ್ನಿ ಪುರಾ ಕರುಚಿಚ್ ಮನುನ್ ತುಮಿ ಶಿಕ್ವುತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ಪಿಶ್ಯಾ ಕುಡ್ಡ್ಯಾನು! ಖಲೆ ಲೈ ಮೊಟೆ ಸೊನ್ಯಾಕ್ ಪವಿತ್ರ್ ಕರ್ತಲಿ ದೆವಾಚಿ ಗುಡಿ ಮೊಟಿ ಕಾಯ್ ಸೊನೆ ಮೊಟೆ?” ");
INSERT INTO kans_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ಅನಿ ಅಲ್ತಾರಿಚ್ಯಾ ನಾವಾನ್ ಆನ್ ಘಾಲುನ್ ಮಾಗುನ್ ಘೆಟಲ್ಲೆ ಪುರಾ ಕರುಚೆ ಮನುನ್ ನಾ, ಖರೆ ಅಲ್ತಾರಿ ವರ್‍ತಿ ಥವಲ್ಲ್ಯಾ ಖಲ್ಯಾಬಿ ದೆನ್ಗಿಚ್ಯಾ ವರ್‍ತಿ ಆನ್ ಘಾಲುನ್ ಮಾಗುನ್ ಘೆಟಲ್ಲೆ ರ್‍ಹಾಲ್ಯಾರ್ ತಿ ಮಾಗ್ನಿ ಪುರಾ ಕರುಚಿ ಮನುನ್ಬಿ ತುಮಿ ಶಿಕ್ವುತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ಕವ್ಡೆ ಕುಡ್ಡೆ ಹಾಸಿ ತುಮಿ! ಖಲೆ ಲೈ ಮೊಟೆ ದೆನ್ಗಿ ಪವಿತ್ರ್ ಕರ್‍ತಾ ತಿ ಅಲ್ತಾರ್ ಮೊಟಿ, ಕಾಯ್ ದೆನ್ಗಿ ಮೊಟಿ? ");
INSERT INTO kans_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ಜೆ ಕನ್ನಾ ಎಕ್ ಮಾನುಸ್ ಅಲ್ತಾರಿಚ್ಯಾ ನಾವಾನ್ ಆನ್ ಘಾಲ್ತಾ ತನ್ನಾ ತೊ ತೆಚ್ಯಾ ವರ್‍ತಿ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಸಾಮಾನಾಂಚ್ಯಾ ವೈನಿಬಿ ಆನ್ ಘಾಲ್ತಾ; ");
INSERT INTO kans_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ಅನಿ ಜೆ ಕೊನ್ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ನಾವಾನ್ ಆನ್ ಘಾಲ್ತಾ, ತೊ ತ್ಯಾ ಗುಡಿತ್ ವಸ್ತಿ ಕರ್‍ತಲ್ಯಾ ದೆವಾಚ್ಯಾ ನಾವಾನ್‍ಬಿ ಆನ್ ಘಾಲ್ತಾ; ");
INSERT INTO kans_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ಅನಿ ಜೆ ಕೊನ್ ಸರ್‍ಗಾಚ್ಯಾ ನಾವಾನ್ ಆನ್ ಘಾಲ್ತಾ ತೊ ದೆವಾಚ್ಯಾ ಬಸ್ತಲ್ಯಾ ಕುರ್ಚಿಚ್ಯಾ ನಾವಾನ್ ಅನಿ ತೆಚ್ಯಾ ವರ್‍ತಿ ಬಸ್ತಲ್ಯಾ ದೆವಾಚ್ಯಾ ನಾವಾನ್ ಆನ್ ಘಾಲ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ಫಾರಿಜೆವಾನು ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನು ಮಿಯಾ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಕುಸ್ಡೆ ತುಮಿ! ತುಮಿ ಪುದಿನಾ, ಸಬ್ಜಾಚೊಪಾಲೊ, ಅನಿ ಜಿರೆ ಅಸ್ಲ್ಯಾ ಬಾರಿ-ಬಾರಿಕ್ಲ್ಯಾ ಝಾಡಾಂಚೊ ಸೈತ್ ಧಾ ತ್ಲೊ ಎಕ್ ವಾಟೊ ದೆವಾಕ್ ಮನುನ್ ದಿತ್ಯಾಶಿ, ಖರೆ ಶಾಸ್ತರಾನಿತ್ಲ್ಯಾ ಗರ್ಜೆಚಿ ಮಟ್ಲ್ಯಾರ್, ನ್ಯಾಯ್‍ನಿತ್, ದಯಾ, ಅನಿ ಪ್ರಾಮಾನಿಕ್‍ಪಾನಾಚ್ಯಾ ಶಿಕಾಪಾಕ್ನಿ ತುಮಿ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಚಲಿನ್ಯಾಶಿ. ಹ್ಯಾ ಶಾಸ್ತರಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹ್ಯಾ ಶಾಸ್ತರಾಂಚ್ಯಾ ತಕ್ ಚಲ್ತಲೆಬಿ ತುಮಿ ಶಿಕುಚೆ. ");
INSERT INTO kans_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ವಾಟ್ ದಾಕ್ವುತಲ್ಯಾ ಕುಡ್ಡ್ಯಾನು! ತುಮ್ಚ್ಯಾ ಫಿತಲ್ಯಾ ಪಾನಿಯಾನಿತ್ಲೆ ಬಾರಿಕ್ ಮಾಸುಕ್ ಸೈತ್ ತುಮಿ ಗಾಳುನ್ ಕಾಡ್ತ್ಯಾಸಿ ಖರೆ ಒಂಟೆಚೆ-ಒಂಟೆಚ್ ತುಮಿ ಗಿಳ್ತ್ಯಾಶಿ! ");
INSERT INTO kans_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ಫಾರಿಜೆವಾನು ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನು ಮಿಯಾ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಕುಸ್ಡೆ ತುಮಿ! ತುಮ್ಚಿ ವಾಟ್ಕಿಯಾ ಅನಿ ಆಯ್ದಾನಾ ಭಾಯ್ನಾ ತುಮಿ ಧುವ್ನ್ ಪವಿತ್ರ್ ಕರ್ತ್ಯಾಶಿ, ಖರೆ ಭುತ್ತುರ್ನಾ ತ್ಯಾತುರ್‍ನಿ ತುಮಿ ಮೊಸಾನ್ ಅನಿ ಗರುಕಿನ್ ಕಮ್ವಲ್ಲಿ ಸಾಮಾನಾ ಭರಲ್ಲಿ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ಫಾರಿಜೆವಾನು ಕುಡ್ಡ್ಯಾನು! ವಾಟ್ಕಿತ್ ಭುತ್ತುರ್ ಹೊತ್ತೆ ಅದ್ದಿ ಧುವ್ನ್ ಪವಿತ್ರ್ ಕರಾ ತನ್ನಾ ಭಾಯ್ಲೆಬಿ ಪವಿತ್ರ್ ಹೊತಾ! ");
INSERT INTO kans_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ಫಾರಿಜೆವಾನು ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನು ಮಿಯಾ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಕುಸ್ಡೆ ತುಮಿ! ತುಮಿ ಬರೆ ಕರುನ್ ಚುನ್ನೊ ಮಾರಲ್ಲ್ಯಾ ಸಾರಿ ಸರ್ಕೆ ಹಾಸಿ. ತ್ಯಾತುರ್ ಭುತ್ತುರ್ ಸಗ್ಳೆ ಹಡ್ಡಾ ಅನಿ ಕುಸ್ಕೆ-ಮಸ್ಕೆ ಭರಲ್ಲೆ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ತುಮಿಬಿ ತಸೆಚ್ ಭಾಯ್ನಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಬರೆ ದಿಸ್ತ್ಯಾಶಿ, ಖರೆ ತುಮ್ಚ್ಯಾ ಭುತ್ತುರ್ ಕುಸ್ಡೆಪಾನ್ ಅನಿ ಪಾಪ್ ಭರಲ್ಲೆ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ಫಾರಿಜೆವಾನು ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನು ಮಿಯಾ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಕುಸ್ಡೆ ತುಮಿ! ತುಮಿ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಬರ್‍ಯಾ-ಬರ್‍ಯಾ ಸಮಾದಿಯಾ ಭಾಂದ್ತ್ಯಾಶಿ, ಅನಿ ಬರ್‍ಯಾ ಮಾನ್ಸಾಂಚ್ಯಾ ಯಾದಿಸಾಟ್ನಿ ಹೊತ್ತ್ಯಾ ಗೊರಿಯಾಕ್ನಿ ಸಿನ್‌ಗಾರ್ ಕರ್‍ತ್ಯಾಶಿ; ");
INSERT INTO kans_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ಅನಿ ಅಮಿ ಅಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಎಳಾರ್ ರ್‍ಹಾಲ್ಯಾರ್ ತೆನಿ ಕರಲ್ಲ್ಯಾ ಸರ್ಕೆ ಕರಿನಸಿತ್ತಾಂವ್ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಜಿವಾನಿ ಮಾರಿನಸಿ ಹೊತ್ತಾವ್ ಮನುನ್ ಮನ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ಅಶೆ, ತನ್ನಾ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾಂಚ್ಯಾಚ್ ಘರಾನ್ಯಾಚೆ ತುಮಿ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತ್ಯಾಶಿ! ");
INSERT INTO kans_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ಚಲಾ ತರ್, ತುಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಲೊಕಾನಿ ಸುರು ಕರಲ್ಲೆ ತುಮಿ ಅತ್ತಾ ಫಿಡೆ ಚಾಲ್ವುನ್ಗೆತ್ ಜಾವಾ! ");
INSERT INTO kans_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ಸಾಪಾ ಸರ್ಕೆ ತುಮಿ, ಅನಿ ಸಾಪಾಚಿ ಪಿಳ್ಗಿ ತುಮಿ! ನರ್‍ಕಾತ್ ಜಾತಲ್ಯಾ ಶಿಕ್ಷಾತ್ನಾ ಚುಕ್ವುನ್ ಘೆವ್ಕ್ ಹೊತಾ ಮನುನ್ ತುಮ್ಚ್ಯಾನ್ ಯೌಜುಕ್ ತರ್ ಕಶೆ ಹೊತಾ? ");
INSERT INTO kans_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಪ್ರವಾದ್ಯಾಕ್ನಿ, ಬುದ್ವಂತಾಕ್ನಿ, ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾಕ್ನಿ ಮಿಯಾ ಧಾಡುನ್ ದಿತಾ; ತುಮಿ ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾಕ್ನಿ ಜಿವಾನಿಚ್ ಮಾರ್‍ತ್ಯಾಶಿ, ಹುರಲ್ಲ್ಯಾಕ್ನಿ ಕುರ್ಸಾ ವರ್‍ತಿ ಮಾರ್‍ತ್ಯಾಶಿ, ಅನಿ ಉಲ್ಲ್ಯಾಕ್ನಿ ಸಿನಾಗೊಗಾತ್ನಿ ನ್ಹೆವ್ನ್ ಬಾರ್‍ಕೊಲಾನಿ ಮಾರ್‍ತ್ಯಾಶಿ, ಅನಿ ಎಕಾ ಗಾವಾನಿತ್ನಾ ಅನಿಎಕ್ ಗಾವಾಕ್ನಿ ತೆಂಕಾ ಪಳ್ಸುನ್ ಘಾಲ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ತೆಚೆಸಾಟ್ನಿ, ಕಾಯ್ಬಿ ಚುಕ್ ಕರಿನಸಲ್ಲ್ಯಾ ಅಬೆಲಾಕ್ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾಕ್ನಾ ಧರುನ್ ದೆವಾಚಿ ಗುಡಿ ಅನಿ ಅಲ್ತಾರಿಚ್ಯಾ ಮದ್ದಿ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾ ಬೆರಾಕಿಯಾಚ್ಯಾ ಲೆಕಾ ಜೆಕರಿಯಾ ಪತರ್ ಚುಕ್ ಕರಿನಸ್ತಾನಾ ಖಾಲಿ ಫುಕೊಟ್ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾಂಚಿ ಶಿಕ್ಷಾ ತುಮ್ಚೆ ವರ್‍ತಿ ಪಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ತಸೆಮಟ್ಲ್ಯಾರ್ ಹ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾಚಿ ಶಿಕ್ಷಾ ಅತ್ತಾಚ್ಯಾ ಕಾಲಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿ ಪಡ್ತಾ!” ");
INSERT INTO kans_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ಜೆರುಜಲೆಮಾ, ಜೆರುಜಲೆಮಾ! ದೆವಾನ್ ಧಾಡಲ್ಲ್ಯಾ ಪ್ರವಾದ್ಯಾಕ್ನಿ ತಿಯಾ ಜಿವಾನಿ ಮಾರ್‍ತೆಯ್ ಅನಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ತಲ್ಯಾಕ್ನಿ ಗುಂಡ್ಯಾನಿ ಮಾರ್‍ತೆಯ್! ಕವ್ಡೆಂದಾ ಎಕ್ ಕೊಂಬ್ಡಿನ್ ಅಪ್ನಾಚ್ಯಾ ಪಿಲ್ಲಾಕ್ನಿ ಅಪ್ನಾಚ್ಯಾ ಫಾಕಾಟ್ಯಾತ್ನಿ ಧಾಪುನ್ ಧರ್‍ಲ್ಯಾ ಸರ್ಕೆ ತುಜ್ಯಾ ಭುತ್ತುರ್ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಭೊತ್ಯಾನಿ ಮಾಜಿ ಹಾತಾ ಘಾಲುನ್ ಧರುಕ್ ಮನುನ್ ಮಿಯಾ ಬಗಟ್ಲೊ, ಖರೆ ತಸೆ ಕರುಕ್ ತಿಯಾ ಮಾಕಾ ಸೊಡುಕ್‍ನೆಯ್! ");
INSERT INTO kans_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ತಸೆಮನುನ್ ತುಜ್ಯಾ ಗುಡಿತ್ ಕಾಯ್ಬಿ ಬರೆಪಾನ್ ಹುರಿನಾ. ಅನಿ ತೆ ಪಾಡ್ ಪಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ಮಿಯಾ ತುಕಾ ಸಾಂಗ್ತಾ, ಹಿತ್ನಾ ಫಿಡೆ ಸರ್ವೆಸ್ವರಾಚ್ಯಾ ನಾವಾನ್ ಯೆತಲ್ಯಾಕ್ ಆಶಿರ್ವಾದ್ ಹೊಂವ್ದಿ. ಮನುನ್ ತಿಯಾ ಮನಿ ಪತರ್ ಮಾಕಾ ತಿಯಾ ಬಗಿನೆಯ್. ");
INSERT INTO kans_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ನಾ ಜಾವ್‍ಲಾಗಲ್ಲೊ ತನ್ನಾ ತೆಚ್ಯಾ ಶಿಸಾನಿ ಬಲ್ವುನ್ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ಭಾಂದ್ಪಾಕ್ಡೆ ಧ್ಯಾನ್ ದಿವ್ಕ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ತೆನಿ ತೆಂಕಾ,“ಸಗ್ಳೆ ಬರೆ-ಬರೆ ತುಮ್ಕಾ ಅತ್ತಾ ದಿಸುಕ್ ಲಾಗ್ಲಾ ಹೊಯ್. ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ಹೆಂಚ್ಯಾತ್ಲೊ ಎಕ್ ಸೈತ್ ಗುಂಡೊ ಅಪ್ನಾಚ್ಯಾ ಜಾಗ್ಯಾ ವರ್‍ತಿ ರ್‍ಹಾಯ್ನಾ; ಹರ್ ಎಕ್ ಗುಂಡೊ ಕೊಸ್ಳುನ್ ಪಾಡ್ವುನ್ ಹೊತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ಮಾನಾ ಜೆಜು ಒಲಿವ್ ಮನ್ತಲ್ಯಾ ಮಡ್ಡಿ ವರ್‍ತಿ ಬಸಲ್ಲೊ, ತನ್ನಾ ಶಿಸಾ ಎವ್ಡಿಚ್ ಕಡೆಕ್ ಜೆಜುಕ್ಡೆ ಯೆಲಿ ಅನಿ ತೆನಿ ಜೆಜುಕ್ “ಹೆ ಸಗ್ಳೆ ಕನ್ನಾ ಹೊತಾ, ಅನಿ ಹ್ಯೊಚ್ ಸರ್‍ತೊ ಕಾಲ್ ಅನಿ ತಿಯಾ ಯೆತಲೊ ಕಾಲ್ ಮನುನ್ ದಾಕ್ವುನ್ ದಿವ್ಕ್ ತನ್ನಾ ಕಾಯ್-ಕಾಯ್ ಹೊತಾ.” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ಜೆಜುನ್ ತೆಂಕಾ,“ಕೊನ್ಬಿ ತುಮ್ಕಾ ಚುಕ್ ವಾಟೆಕ್ ನ್ಹೆಯ್‍ ನಸಿ ಸರ್ಕೆ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ.” ");
INSERT INTO kans_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ಲೈ ಲೊಕಾ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಬೊಲ್ತ್ಯಾತ್ ಅನಿ ಮಾಜ್ಯಾ ನಾವಾನ್ ಯೆತಾತ್ ಅನಿ “ಮಿಯಾಚ್ ಕ್ರಿಸ್ತ್!” ಮನುನ್ ಸಾಂಗುನ್ ಲೈ ಲೊಕಾಕ್ನಿ ತೆನಿ ಚುಕ್ ವಾಟೆಕ್ ನ್ಹೆತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ತುಮ್ಚ್ಯಾ ಜಗ್ಗೊಳ್ ತುಮ್ಕಾ ಝಗ್ಡ್ಯಾಂಚೊ ಅವಾಜ್ ಆಯ್ಕೊ ಯೆತಾ ಅನಿ ಧುರ್‍ಲ್ಯಾ ಝಗ್ಡ್ಯಾಂಚಿ ಬಾತ್ಮಿಯಾ ತುಮ್ಕಾ ಆಯ್ಕುಕ್ ಗಾವ್ತಾತ್; ಖರೆ ತುಮಿ ಭಿವ್‍ನಕಾಶಿ. ಅಸ್ಲಿ ಸಗ್ಳಿ ಘಡಿತಾ ಘಡುಕುಚ್ ಪಾಜೆ ತೆಚೊ ಅರ್ತ್‍ ಸರ್‍ತೊ ಕಾಲ್ ಯೆಲೊ ಮನುನ್ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ದೆಸಾ ಎಕಾಮೆಕಾಕ್ಡೆ ಝಗ್ಡೆ ಕರುನ್ ಘೆತ್ಯಾತ್, ಅನಿ ರಾಜಾಬಿ ಎಕಾಮೆಕಾ ವರ್‍ತಿ ಝಗ್ಡುನ್ಗೆತ್ ರ್‍ಹಾತ್ಯಾತ್, ಬರಗಾಲಾ ಪಡ್ತ್ಯಾತ್, ಅನಿ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಭುಕಂಪಾ ಹೊತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ಹಿ ಸಗ್ಳಿ ಘಡಿತಾ ಖಾಲಿ ಎಕಾ ಪೊರಾಕ್ ಜಲಮ್ ದಿತಾನಾ ಯೆತಲ್ಯಾ ಪಯ್ಲೆಚ್ಯಾ ಯೆನಾಂಚ್ಯಾ ಸರ್ಕಿ. ");
INSERT INTO kans_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ತನ್ನಾ ತುಮ್ಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಧರುನ್ ಹೊತಾ ಅನಿ ಶಿಕ್ಷಾ ದಿವ್ನ್ ಹೊತಾ, ಅನಿ ಜಿವಾನಿ ಮಾರುನ್ ಹೊತಾ. ಮಾಕಾ ಲಾಗುನ್ ಸಗ್ಳ್ಯಾ ದೆಸಾಂಚಿ ಲೊಕಾ ತುಮ್ಕಾ ಧುರ್ ಕರ್‍ತಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ಲೈ ಜಾನಾ ವಿಶ್ವಾಸ್ ಸೊಡುನ್ ಸೊಡ್ತ್ಯಾತ್; ತೆನಿ ಎಕಾಮೆಕಾಕ್ ಘಾತ್ ಕರ್‍ತಾತ್ ಅನಿ ಎಕಾಮೆಕಾಂಚ್ಯಾ ವರ್‍ತಿ ದುಸ್ಮನ್ಕಿನ್ ರ್‍ಹಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ತನ್ನಾ ಲೈ ಝುಟೆ ಪ್ರವಾದಿ ಉಟ್ತಾತ್ ಅನಿ ಲೊಕಾಕ್ನಿ ಪಿಶೆ ಕರ್‍ತಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ಬುರ್ಶೆಪಾನ್ ಯೆವ್ಡೆ ಫರ್ಗಟ್ತಾ ಕಿ ಮಟ್ಲ್ಯಾರ್, ಸುಮಾರ್ ಲೊಕಾಂಚೊ ಪ್ರೆಮುಚ್ ಥಂಡ್ ಹೊವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ಖರೆ ಜೆ ಕೊನ್ ಅಕ್ರಿ ಪತರ್ ಘಟ್ ರ್‍ಹಾತಾ ತೊ ಹುರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ಅನಿ ಹಿ ದೆವಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಜಗಾತ್ ಸಗ್ಳ್ಯಾ ಬಾಶಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಎಕ್ ಸಾಕ್ಷಿ ಸರ್ಕೆ ಸಾಂಗುನ್ ಹೊತಾ, ತನ್ನಾ ಅಂತ್ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ದಾನಿಯೆಲ್ ಪ್ರವಾದ್ಯಾನ್ ಸಾಂಗಲ್ಲಿ ಸತ್ತ್ಯಾನಾಸ್ ಕರ್‍ತಲಿ ಬುರ್ಶಿ ಸಂಗತ್” ತುಮ್ಕಾ ದಿಸ್ತಾ. ತಿ ಎಕ್ ಪವಿತ್ರ್ ಜಾಗ್ಯಾರ್ ಇಬೆ ರ್‍ಹಾತಾ. ವಾಚ್ವುತಲ್ಯಾಕ್ ಸೂಚನಾ: ಅಶೆ ಮಟ್ಲ್ಯಾರ್ ಕಾಯ್ ಮನುನ್ ಕಳ್ವುನ್ ಘೆ! ");
INSERT INTO kans_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ತನ್ನಾ ಜೆ ಕೊನ್ ಜುದೆಯಾತ್ ಹಾತ್ ತೆನಿ ಮಡ್ಡಿಯಾ ವೈನಿ ಪಳುನ್ ಜಾವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","“ಜೆ ಕೊನ್ ಅಪ್ನಾಚ್ಯಾ ಘರಾಚ್ಯಾ ವರ್‍ತಿ ಮ್ಹಾಳ್ಗಿರ್ ಹಾತ್, ತೆನಿ ಘರಾತ್ ಜಾವ್ನ್ ಅಪ್ನಾಚಿ ಸಾಮಾನಾ ಹಾನುಕ್ ಮನುನ್ ಜಾವ್ನ್ ಎಳ್ ಕರುನಸುಂದಿ”. ");
INSERT INTO kans_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ಜೆ ಕೊನ್ ಶೆತಾತ್ ಹಾಯ್ ತೊ ಅಪ್ನಾಚಿ ವೈಲಿ ಅಂಗಿ ಹಾನುಕ್ ಮನುನ್ ಫಾಟಿ ಘರಾಕ್ ಜಯ್‌ನಸ್ತಾನಾ ರ್‍ಹಾಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ಹ್ಯಾ ದಿಸಾತ್ನಿ ಗರ್‍ವಾರ್ ಹೊತ್ತ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾಂಚಿ ಅನಿ ಥಾನ್ ಫಿತಲಿ ಪೊರಾ ಹೊತ್ತ್ಯಾ ಅವ್ಸಿಯಾಂಚಿ ಗತ್ ಕಾಯ್ ಅಸಿಲ್! ");
INSERT INTO kans_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ಥಂಡಾಚ್ಯಾ ದಿಸಾತ್ನಿ ನಾ ಹೊಲ್ಯಾರ್ ಜುದೆವಾನಿ ಆರಾಮ್ ಕರ್‍ತಲ್ಯಾ ದಿಸಿ ಹಿ ಪಳಾಪಳಿ ಯೆವ್‍ನಸುಂದಿ ಮನುನ್ ದೆವಾಕ್ಡೆ ಮಾಗ್ನಿ ಕರಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತನ್ನಾ ಯೆತಲೊ ಕಸ್ಟ್ ಲೈ ಮೊಟೊ ಕಸ್ಟ್ ತೊ. ಹ್ಯೊ ಜಗ್ ರಚಲ್ಲ್ಯಾಕ್ನಾ ಆಜ್ ಪತರ್ ಅಸ್ಲೊ ಕಸ್ಟ್ ಯೆವ್ಕ್ ನಾ. ಅನಿ ಅನಿ ಫಿಡೆಬಿ ಯೆಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ಅನಿ ಹೆ ಸಂಕಟಾಚೆ ದಿಸ್ ಕಮಿ ಕರಿನಸ್ಲ್ಯಾರ್ ಎಕ್ ಸೈತ್ ಮಾನುಸ್ ವಾಚುನ್ ಹುರಿನಸಿ ಹೊತ್ತೊ. ಖರೆ ಅಪ್ನಾಚ್ಯಾ ಎಚುನ್ ಕಾಡಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ದೆವ್ ತಿ ದಿಸಾ ಕಮಿ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ತನ್ನಾ ಕೊನ್ಬಿ ತುಮ್ಕಾ“ಅಬಕ್ ಕ್ರಿಸ್ತ್ ಹಿತ್ತೆ ಹಾಯ್! ತೊ ಥೈ ಹಾಯ್ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾರ್‍ಬಿ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರುನಕಾಸಿ.” ");
INSERT INTO kans_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಝುಟಿ ಮಾನ್ಸಾ ಯೆವ್ನ್ ಅಪ್ನಿಚ್ ಕ್ರಿಸ್ತ್ ನಾಹೊಲ್ಯಾರ್ ಪ್ರವಾದಿ ಮನುನ್ ಸಾಂಗ್ತ್ಯಾತ್ ಅನಿ ಅಪ್ನಾಚ್ಯಾನ್ ಸಾದ್ಯ್ ಹೊಲ್ಯಾರ್ ದೆವಾನ್ ಎಚುನ್ ಕಾಡಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಸೈತ್ ಮೊಟಿ ವಿಚಿತ್ರ್ ಕಾಮಾ ಕರುನ್ ದಾಕ್ವುನ್ ಪಸ್ವುಕ್ ಬಗ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ಬಗಾ, ಅದ್ದಿಚ್ ಮಿಯಾ ತುಮ್ಕಾ ಉಶಾರ್ಕಿ ದಿಲಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ತಸೆಮನುನ್ ಅಬಕ್ ಕ್ರಿಸ್ತ್ ಡಂಗ್ಳಿತ್ ಹಾಯ್ ಮನುನ್ ಕೊನ್ಬಿ ಸಾಂಗ್ಲ್ಯಾರ್ ತುಮಿ ಜಾವ್‍ನಕಾಶಿ ನಾಹೊಲ್ಯಾರ್: ಅಬಕ್ ತೊ ಭುತ್ತುರ್‍ಲ್ಯಾ ಖೊಲಿತ್ ನಿಪುನ್ ಹಾಯ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾರ್‍ಬಿ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರುನಕಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಎಗ್ದಮ್ ಎಕ್ ದಿಕ್ಕಾಕ್ನಾ ಅನಿ ಎಕ್ ದಿಕ್ಕಾ ಪತರ್ ಮಿಂಚ್ ಹೊಳ್‍ಹೊಳ್ತಾ ತಸೆ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ಖೈ ಮಡಿ ಪಡಲ್ಲಿ ಹಾತ್ ಥೈ ಹಳಿಹಡ್ಡಾ ಗೊಳಾ ಹೊತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ತ್ಯಾ ದಿಸಾಂಚೊ ಕಸ್ಟ್ ಸರಲ್ಲ್ಯಾ ತನ್ನಾಚ್, ದಿಸಾ ವರ್‍ತಿ ಕಾಳೊಕ್ ಪಡ್ತಾ, ಅನಿ ಚಂದ್ರಾಮ್ ಉಡ್ವೊಡ್ ದಿ ನಾ, ಚಿಕಿಯಾ ಮಳ್ಬಾ ವೈನಾ ಖಾಲ್ತಿ ಪಡ್ತಾತ್, ಅನಿ ಮಳ್ಬಾ ವೈಲಿ ಸಗ್ಳಿ ಸಾಮಾನಾ ಹಾಲ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ತನ್ನಾ ಮಳ್ಬಾ ವರ್‍ತಿ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಚಿ ಎಕ್ ವಳಕ್ ದಿಸುಕ್‍ ಲಾಗ್ತಾ, ತನ್ನಾ ಜಗಾತ್ಲಿ ಸಗ್ಳಿ ಲೊಕಾ ಭಿಂಯಾನ್ ರಡ್ತ್ಯಾತ್. ಅನಿ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮೊಟ್ಯಾ ಪದ್ವಿನ್ ಅನಿ ಮಹಿಮೆನ್ ಮಳ್ಬಾ ವೈಲ್ಯಾ ಮೊಡಾಂಚ್ಯಾ ವರ್‍ತಿ ಯೆತಲೊ ಬಗ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ಮೊಟ್ಯಾ ಪಂವ್ಯಾಚ್ಯಾ ವಾಜ್ಪಾಚ್ಯಾ ವಾಂಗ್ಡಾಚ್ ತೊ ಅಪ್ನಾಚ್ಯಾ ದುತಾಕ್ನಿ ಧಾಡುನ್ ದಿತಾ, ಅನಿ ತೆನಿ ಜಗಾಚ್ಯಾ ಚಾರಿ ದಿಕ್ಕಾಕ್ನಿ ಪತರ್ ಜಾವ್ನ್ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾನ್ ಎಚುನ್ ಕಾಡಲ್ಲ್ಯಾಕ್ನಿ ಗೊಳಾ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ಅಂಜುರಾಚ್ಯಾ ಝಾಡಾ ವೈನಾ ಹ್ಯೊ ಪಾಠ್ ಶಿಕಾ; ತೆಚ್ಯಾ ಟಾಳಿಯಾ ಮ್ಹವ್ ಹೊವ್ನ್ ಚಿಗುರ್ ಫುಟುಕ್ ಚಾಲು ಹೊಲೊ ತರ್ ನಿಂಬ್ರಾಚಿ ದಿಸಾ ಜಗ್ಗೊಳ್ ಯೆಲಿ ಮನುನ್ ತುಮಿ ಕಳ್ವುನ್ ಘೆತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ತಸೆಚ್ ಹೆ ಸಗ್ಳೆ ಹೊತಲೆ ಬಗ್ತಾನಾ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆತಲೊ ಎಳ್ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಪಾವ್ಲಾ ಮನುನ್ ಕಳ್ವುನ್ ಘೆವಾ ಅನಿ ತಯಾರಿತ್ ರ್‍ಹಾವಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ,\"ಹಿ ಸಗ್ಳಿ ಘಡಿತಾ ಹೊಯ್ ಪತರ್ ಹಿ ಅತ್ತಾಚಿ ಲೊಕಾ ಮರಿನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ಮಳಬ್ ಅನಿ ಜಿಮಿನ್ ಸರುನ್ ಜಾಯ್ಲ್, ಖರೆ ಮಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ಕನ್ನಾಚ್ ಸರಿನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ಖರೆ ತೊ ದಿಸ್ ಅನಿ ತೊ ಎಳ್ ಕನ್ನಾ ಯೆತಾ ಮನುನ್ ದೆವಾ ಬಾಬಾಕ್ ಎಕ್ಲ್ಯಾಕ್ ಸೊಡುನ್, ಅನಿ ಕೊನಾಕ್‍ಬಿ, ಸರ್ಗಾ ವೈಲ್ಯಾ ದುತಾಕ್ನಿ ಹೊಂವ್ದಿ, ದೆವಾಚ್ಯಾ ಲೆಕಾಕ್ ಸೈತ್ ಗೊತ್ತ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ನೊಯೆಚ್ಯಾ ಕಾಲಾತ್ ಕಶೆ ಘಡ್ಲೆ ತಸೆಚ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆತಲ್ಯಾ ಕಾಲಾತ್‍ಬಿ ಘಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ಕಶೆ ಹ್ಯೊ ಜಗ್‍ ಸಗ್ಳೊ ಪಾನಿಯಾನಿ ಬುಡುಚ್ಯಾ ಅದ್ದಿ ನೊಯೆ ಢೊನಿತ್ ಗುಸ್ಲೊ ತ್ಯಾ ದಿಸಾ ಪತರ್ ಲೊಕಾ ಖಾವ್ನಗೆತ್ ಫಿವ್ನಗೆತ್, ಲಗ್ನಾ ಕರುನ್ ಘೆವ್ನ‍ಗೆತ್-ಲಗ್ನಾ ಕರುನ್ ದಿವ್ನಗೆತ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ಅಶೆ ಸಗ್ಳ್ಯಾ ಜಿಮ್ನಿರ್ ಪಾನಿಭರುನ್ ಸಗ್ಳೆ ಹೊವ್ನ್ ಜಾಯ್ ಪತರ್‍ಬಿ ತೆಂಕಾ ಕಾಯ್ಬಿ ಕಳುಕ್ ನಾ. ತಸೆಚ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆತಲ್ಯಾ ಎಳಾರ್‍ಬಿ ಘಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ತನ್ನಾ ಶೆತಾತ್ ಹೊತ್ತ್ಯಾ ದೊನ್ ಘೊಮನ್ಸಾನಿತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ, ಎಕ್ಲ್ಯಾಕ್ ಥೈಚ್ ಸೊಡುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ಜಾತ್ಯಾ ವರ್‍ತಿ ದಳುಕ್ ಬಸಲ್ಲ್ಯಾ ದೊಗ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾನಿತ್ಲ್ಯಾ ಎಕ್ಲಿಕ್ ಸೊಡುನ್, ಎಕ್ಲಿಕ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ತಸೆಮನುನ್ ತುಮಿ ಉಶಾರ್‍ಕಿನ್ ರ್‍ಹಾವಾ; ಖಲ್ಯಾ ದಿಸಿ ತುಮ್ಚೊ ಧನಿ ಯೆತಾ ಮನ್ತಲೆ ತುಮ್ಕಾ ಗೊತ್ತ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ಯಾದ್ ಥವ್ನ್ ಘೆವಾ, ಹ್ಯಾಚ್ ಎಳಾರ್ ಚೊರ್ ಯೆತಾ ಮನುನ್ ಘರಾಚ್ಯಾ ಮಾಲ್ಕಾಕ್ ಗೊತ್ತ್ ರ್‍ಹಾಲ್ಯಾರ್ ತೊ ಜಾಗೊ ರ್‍ಹಾವ್ನ್ ರಾಕುನ್ಗೆತ್ ರ್‍ಹಾತಾ ಅನಿ ಕನ್ನಾಬಿ ಅಪ್ನಾಚೆ ಘರ್ ಫೊಡುನ್ ಚೊರುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ದಿ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ತೆಚೆಸಾಟ್ನಿ ತುಮಿ ತಯಾರಿತ್ ರ್‍ಹಾವಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತುಮಿ ಚಿಂತಿನಸಲ್ಲ್ಯಾ ಎಳಾರ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ತಸೆ ಜಾಲ್ಯಾರ್ ಮಾಲ್ಕಾನ್ ಅಪ್ನಾಚ್ಯಾ ಹುರಲ್ಲ್ಯಾ ಆಳಾಂಚಿ ಜವಾಬ್ದಾರಿ ಘೆವ್ಕ್ ಅನಿ ತೆಂಕಾ ಎಳಾ-ಎಳಾರ್ ತೆಂಚೆ ಜೆವಾನ್ ವಾಟುನ್ ದಿವ್ಕ್ ಮನುನ್ ನೆಮಸಲ್ಲೊ ವಿಶ್ವಾಸಾಚೊ, ಅನಿ ಶಾನೊ ಸೆವಕ್ ಕೊನ್ ತೊ? ");
INSERT INTO kans_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ಅಪ್ನಾಚೊ ಮಾಲಕ್ ಪರ್ತುನ್ ಘರಾಕ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಅಪ್ನಾಚೆ ಕಾಮ್ ಕರುಂಗೆತ್ ಹೊತ್ತ್ಯಾ ಸೆವಕಾಚೆ ಕವ್ಡೆ ಬರೆ! ");
INSERT INTO kans_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ತೊ ಮಾಲಿಕ್ ಅಪ್ನಾಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಅಸ್ತಿಚಿ ಅನಿ ಬದ್‍ಕಾಚಿ ಜವಾಬ್ದಾರಿ ತೆಚ್ಯಾ ವರ್‍ತಿ ಸೊಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ಖರೆ ತೊ ಎಕ್ ವಿಶ್ವಾಸ್‍ ನಸಲ್ಲೊ ಸೆವಕ್ ಹೊವ್ನ್ ತೊ ಅಪ್ನಾಕುಚ್ ಮಾಲಿಕ್ ಯೆವ್ಕ್ ಅಜುನ್ ಲೈ ಎಳ್ ಹಾಯ್ ಮನುನ್ ಘೆತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ಅನಿ ತೊ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗುಡ್ಚ್ಯಾ ಅಳಾಕ್ನಿ ಮಾರುಕ್ ಲಾಗ್ತಾ, ಅನಿ ಫಿದೊಡ್ಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಖಾತಲೆ-ಫಿತಲೆ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ತನ್ನಾ ತ್ಯಾ ಜವಾಬ್ದಾರಿಚ್ಯಾ ಆಳಾನ್ ಮಾಲಿಕ್ ಯೆತಾ ಮನುನ್ ಚಿಂತುನಸಲ್ಲ್ಯಾ ದಿಸಿ ತೆಕಾ ಗೊತ್ತ್ ನಸಲ್ಲ್ಯಾ ಎಳಾರ್ ತೊ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ಮಾಲಿಕ್ ತ್ಯಾ ವಿಶ್ವಾಸಾನ್ ನಸಲ್ಲ್ಯಾ ಆಳಾಕ್ ಮಾರುನ್ ಭಾಯ್ರ್ ಘಾಲ್ತಾ ಅನಿ ಕುಸ್ಡ್ಯಾಕ್ನಿ ಮನುನ್ ಹೊತ್ತ್ಯಾ ಜಾಗ್ಯಾರ್ ತೆಕಾ ಢಕ್ಲುನ್ ಘಾಲ್ತಾ. ಥೈ ಹೊತಾ ಕನ್ನಾಬಿ ರಡ್ನೆ ಅನಿ ತರಾಸಾನಿ ದಾತಾ ಚಾವ್ತಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ತನ್ನಾ ಸರ್ಗಾಚೊ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್ ಅಸೊ. ಎಕ್ದಾ ಧಾ ಧೆಡ್ನಿಯಾ ಅರ್‍ತಿಯಾ ಘೆವ್ನ್ ನ್ಹವ್ರ್ಯಾಕ್ ಭೆಟುಕ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ತ್ಯಾತುರ್ ಪಾಂಚ್ ಜಾನಾ ಬುದ್ದ್ ಅಸಲ್ಲ್ಯಾ ಅನಿ ಪಾಂಚ್ ಜಾನಾ ಬುದ್ದ್ ನಸಲ್ಲ್ಯಾ ಧೆಡ್ನಿಯಾ ಹೊತ್ತ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ಬುದ್ದ್ ನಸಲ್ಲ್ಯಾನಿ ತೆಂಚ್ಯಾ ಅರ್‍ತಿಯಾ ಘೆಟ್ಲ್ಯಾನಿ ಖರೆ ವಾಂಗ್ಡಾ ಜಾಸ್ತಿಚೆ ತೆಲ್ ಘೆವ್ಕ್‌ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ಬುದ್ದ್ ಅಸಲ್ಲ್ಯಾನಿ ತೆಂಚ್ಯಾ ಆರ್‍ತಿಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಡಬ್ಬ್ಯಾತ್ನಾ ಜಾಸ್ತಿಚೆ ತೆಲ್ ಬಿ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ನ್ಹವ್ರೊ ಯೆವ್ಕ್ ಎಳ್ ಹೊಲ್ಲ್ಯಾಕ್ ತೆನಿ ಸಗ್ಳೆ ಜಾನಾ ಝೆಮುನ್ಗೆತ್-ಝೆಮುನ್ಗೆತ್ ನಿಜುನ್ ಪಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ಖರೆ ಮದ್ಯಾನ್ ರಾಚ್ಚೆ, ಅಬಗಾ, ನ್ಹೊವ್ರೊ ಯೆಲೊ, ತೆಕಾ ಮಿಳುಕ್ ಯೆವಾ. ಮನುನ್ ಕೊನ್‍ ಕಿ ಬೊಬ್ ಮಾರ್‍ತಲೆ ಆಯಿಕ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ತನ್ನಾ ತ್ಯಾ ಧಾ ಧೆಡ್ನಿಯಾ ಉಟ್ಲ್ಯಾ ಅನಿ ಅಪ್ನಾ-ಅಪ್ನಾಚ್ಯಾ ಅರ್‍ತಿಯಾ ಸಮಾ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ತನ್ನಾ ಬುದ್ದ್ ನಸಲ್ಲ್ಯಾ ಧೆಡ್ನಿಯಾನಿ ಬುದ್ದ್ ಅಸಲ್ಲ್ಯಾ ಧೆಡ್ನಿಯಾಕ್ನಿ ಜಾವ್ನ್, ತುಮ್ಚ್ಯಾಕ್ಡೆ ಹೊತ್ತ್ಯಾ ತೆಲಾತ್ಲೆ ಉಲ್ಲೆ ತೆಲ್ ಅಮ್ಕಾಬಿ ದಿವಾ, ಅಮ್ಚ್ಯಾ ಆರ್‍ತಿಯಾ ಇಜುನ್ ಜಾವ್ಲ್ಯಾತ್. ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ತನ್ನಾ ಬುದ್ದ್ ಅಸಲ್ಲ್ಯಾ ಧೆಡ್ನಿಯಾನಿ, ನಾ ನಾ, ಅಮ್ಚೆಕ್ಡೆ ಹೊತ್ತೆ ತೆಲ್ ತುಮ್ಕಾ ದಿಲ್ಯಾರ್ ಅಮ್ಕಾಬಿ ಪಾವಿನಾ ಹೊಯ್ಲ್. ತುಮಿ ಇಕ್ತಲ್ಯಾಂಚ್ಯಾಕ್ಡೆ ಜಾವ್ನ್ ಇಕಾತ್ ಘೆಟಲ್ಲೆ ಬರೆ. ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ತೆಚೆಸಾಟ್ನಿ ಬುದ್ದ್ ನಸಲ್ಲ್ಯಾ ಪಾಂಚ್ ಧೆಡ್ನಿಯಾ ಇಕ್ತಲ್ಯಾಂಚ್ಯಾಕ್ನಾ ತೆಲ್ ಇಕಾತ್ ಮನುನ್ ಗೆಲ್ಯಾನಿ: ತವ್ಡ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ನ್ಹವ್ರೊ ಯೆಲೊ, ಅನಿ ತಯಾರ್ ಹೊತ್ತೆ ಸಗ್ಳೆ ಜಾನಾ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಲಗ್ನಾಚ್ಯಾ ಘರಾತ್ ಭುತ್ತುರ್ ಗುಸ್ಲೆ ಮಾನಾ ದಾರ್ ಧಾಪ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ಮಾನಾ ಹುರಲ್ಲ್ಯಾ ಪಾಂಚ್ ಧೆಡ್ನಿಯಾ ಯೆಲ್ಯಾ ಅನಿ,ಸಾಯ್ಬಾನು, ಸಾಯ್ಬಾನು! ದಾರ್ ಉಗ್ಡಾ! ಮನುನ್ ಮೊಟ್ಯಾನ್ ಬಲ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ಖರೆ ನ್ಹವ್ರ್ಯಾನ್ ಭುತ್ತುರ್‍ನಾ ಜಬಾಬ್ ದಿವ್ನ್. ನಾ ಹೊಯ್ನಾ! ತುಮಿ ಕೊನ್ ಮನುನ್ ಮಾಕಾ ಖರೆಚ್‍ಬಿ ಗೊತ್ತ್ ನಾ. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ತೆಚೆಸಾಟ್ನಿ ತುಮಿ ಕನ್ನಾಬಿ ಉಶಾರ್ಕಿತ್ ರ್‍ಹಾವಾ, ಕಸ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆತಲೊ ದಿಸ್ ನಾಹೊಲ್ಯಾರ್ ಎಳ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ನಾ. ಮನುನ್ ಜೆಜುನ್ ಮುಗಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ಸರ್‍ಗಾಚೊ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್ ಅಶೆ ಮನುಕ್ ಹೊತಾ. ಎಗ್ದಾ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೊ ಧುರ್‍ಲ್ಯಾ ದೆಸಾಕ್ ಜಾನಾರ್ ಹೊತ್ತೊ ತನ್ನಾ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಆಳಾಕ್ನಿ ಬಲ್ವುಲ್ಯಾನ್ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಆಸ್ತಿಚಿ ಜವಾಬ್ದಾರಿ ತೆಂಕಾ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ತೆನಿ ತೆಂಕಾ ತೆಂಚ್ಯಾ ತಾಕ್ತಿ ಪರ್‌ಕಾರ್ ಎಕ್ಲ್ಯಾಕ್ ಪಾಂಚ್ ಹಜಾರ್, ಎಕ್ಲ್ಯಾಕ್ ದೊನ್ ಹಜಾರ್ ಅನಿ ಅನಿಎಕ್ಲ್ಯಾಕ್ ಎಕ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಪೈಸ್ಯಾಂಚ್ಯಾ ಗಾಲಿಯಾ ದಿಲ್ಯಾನ್. ಮಾನಾ ತೊ ಧುರ್‍ಲ್ಯಾ ದೆಸಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ಪಾಂಚ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಪೈಸ್ಯಾಂಚ್ಯಾ ಗಾಲಿಯಾ ಘೆಟಲ್ಲೊ ಗೆಲೊ ಅನಿ ತೆ ಪೈಸೆ ಯಾವಾರಾತ್ ಘಾಟ್ಲ್ಯಾನ್. ಅನಿ ಅನಿ ಪಾಚ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಪೈಸೆ ಖಮ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ತಸೆಚ್ ದೊನ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಪೈಸ್ಯಾಂಚ್ಯಾ ಗಾಲಿಯಾ ಘೆಟಲ್ಲ್ಯಾನ್, ಅನಿ ದೊನ್ ಹಜಾರ್ ಪೈಸ್ಯಾಂಚ್ಯಾ ಗಾಲಿಯಾ ಕಮ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ಖರೆ ಎಕ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಪೈಸ್ಯಾಂಚ್ಯಾ ಗಾಲಿಯಾ ಘೆಟಲ್ಲ್ಯಾನ್, ಜಾವ್ನ್ ಜಿಮಿನ್ ಖಂಡುನ್ ಅಪ್ನಾಚ್ಯಾ ಮಾಲ್ಕಾನ್ ದಿಲ್ಲೆ ಪೈಸೆ ನಿಪ್ವುನ್ ಥವ್ಲ್ಯಾನ್”. ");
INSERT INTO kans_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ಲೈ ದಿಸಾಂಚ್ಯಾ ಮಾನಾ ತ್ಯಾ ಆಳಾಂಚೊ ಮಾಲಿಕ್ ಪರ್ತುನ್ ಯೆಲೊ, ಅನಿ ತೆನಿ ತೆಂಚ್ಯಾಕ್ಡೆ ಲೆಕ್ಕ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ಪಾಂಚ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಗಾಲಿಯಾ ಘೆಟಲ್ಲೊ ಫಿಡೆ ಯೆಲೊ ಅನಿ ಅನಿ ಪಾಂಚ್ ಹಜಾರ್ ಗಾಲಿಯಾ ದಿವ್ನ್, ಮಾಲಿಕ್, ತುಮಿ ಮಾಕಾ ಪಾಂಚ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಗಾಲಿಯಾ ದಿಲ್ಲ್ಯಾಶಿ, ಖರೆ ಮಿಯಾ ಅನಿ ಪಾಂಚ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಗಾಲಿಯಾ ಕಮ್ವುಲಾ. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ತನ್ನಾ ಮಾಲ್ಕಾನ್, ಶಬ್ಬಾಸ್, ಮಾಜ್ಯಾ ಬರ್‍ಯಾ ಅನಿ ವಿಶ್ವಾಸಾಚ್ಯಾ ಆಳಾ! ಬಾರಿಕ್ಲ್ಯಾ ಕಾಮಾತುಚ್ ತಿಯಾ ವಿಸ್ವಾಸಾಚೊ ಮನುನ್ ದಾಕ್ವುನ್ ದಿಲೆಯ್. ತಸೆಮನುನ್ ಮಿಯಾ ತುಕಾ ಲೈ ಮೊಟ್ಯಾ ಜವಾಬ್ದಾರಿಚೆ ಕಾಮ್ ದಿತಾ. ಯೆ ಅನಿ ಮಾಜ್ಯಾ ಕುಶಿತ್ ಭಾಗ್ ಘೆ! ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ತನ್ನಾ ದೊನ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಗಾಲಿಯಾ ದಿಲ್ಲೊ ಫಿಡೆ ಯೆಲೊ. ಅನಿ, ಮಾಲಿಕ್, ತುಮಿ ಮಾಕಾ ದೊನ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಗಾಲಿಯಾ ದಿಲ್ಲ್ಯಾಶಿ. ಅಬಗಾ, ಮಿಯಾ ಅನಿ ದೊನ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಗಾಲಿಯಾ ಕಮ್ವುಲಾ. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ತನ್ನಾ ಮಾಲ್ಕಾನ್, ಶಬ್ಬಾಸ್, ಮಾಜ್ಯಾ ಬರ್‍ಯಾ ಅನಿ ವಿಶ್ವಾಸಾಚ್ಯಾ ಆಳಾ! ಬಾರಿಕ್ಲ್ಯಾ ಕಾಮಾತುಚ್ ತಿಯಾ ವಿಶ್ವಾಸಾಚೊ ಮನುನ್ ದಾಕ್ವುಲೆಯ್. ತಸೆಮನುನ್ ಮಿಯಾ ತುಕಾ ಮೊಟ್ಯಾ ಕಾಮಾಚಿ ಜವಾಬ್ದಾರಿ ದಿತಾ. ಯೆ ಅನಿ ಮಾಜ್ಯಾ ಕುಶಿತ್ ಭಾಗ್ ಘೆ! ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ಮಾನಾ ಎಕ್ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಗಾಲಿಯಾ ಘೆಟಲ್ಲೊ ಫಿಡೆ ಯೆಲೊ ಅನಿ, ಧನಿಯಾ, ತಿಯಾ ಲೈ ಕಟೊರ್ ಮಾನುಸ್ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್. ಪೆರುನಸಲ್ಲ್ಯಾಕ್ಡೆ ತಿಯಾ ಕಾತರ್‍ತೆ ಅನಿ ಸಿಪ್ಡುನಸಲ್ಲ್ಯಾಕ್ಡೆ ರಾಸ್ ಘಾಲ್ತೆಯ್. ");
INSERT INTO kans_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ಮಿಯಾ ಭಿಂಯಾಲೊ. ತಸೆಮನುನ್ ಮಿಯಾ ಗೆಲೊ ಅನಿ ತುಜೆ ಪೈಸೆ ಜಿಮ್ನಿತ್ ಎಕ್ ಖಡ್ಡೊ ಕಾಡುನ್ ಧಾಪುನ್ ಥವ್ಲೊ. ಅಬಗ್! ತುಜೆ ಪೈಸೆ ತುಕಾ ಪಾವ್ಲೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ತನ್ನಾ ತೆಚ್ಯಾ ಧನಿಯಾನ್ ಆಳ್ಸಿ ಅನಿ ಬುರ್ಶ್ಯಾ ಆಳಾ! ಮಿಯಾ ಪೆರಿನಸಲ್ಯಾಕ್ಡೆ ಕಾತರ್‍ತಾ ಅನಿ ಸಿಪ್ಡುನಸಲ್ಲ್ಯಾಕ್ಡೆ ರಾಸ್ ಘಾಲ್ತಾ ಮನುನ್ ತುಕಾ ಗೊತ್ತ್ ಹೊತ್ತೆ ನ್ಹಯ್? ");
INSERT INTO kans_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ತಸೆಹೊಲ್ಯಾರ್, ತಿಯಾ ಮಾಜೆ ಪೈಸೆ ಪೈಸ್ಯಾಂಚೊ ಯಾವಾರ್ ಕರ್‍ತಲ್ಯಾಕ್ನಿ ಬಡ್ಡಿನ್ ಕಶ್ಯಾಕ್ ದಿವ್ಕ್‌ನೆಯ್, ಮಿಯಾ ಪರ್ತುನ್ ಯೆಲ್ಲ್ಯಾತನ್ನಾ ಸಗ್ಳೆ ಬಡ್ಡಿ ಸಮೆತ್ ತೆಂಚ್ಯಾಕ್ನಾ ಕಾಡುನ್ ಘೆಯ್‍ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ತೆಚೆಕ್ಡೆ ಹೊತ್ತೆ ಪೈಸೆ ಕಾಡುನ್ ಘೆವಾ, ಅನಿ ಧಾ ಹಜಾರ್ ಸೊನ್ಯಾಚ್ಯಾ ಗಾಲಿಯಾ ಹೊತ್ತ್ಯಾಕ್ ದಿವಾ. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ಕೊನಾಕ್ಡೆ ಉಲ್ಲೆಸೆ ಹಾಯ್ ತೆಂಕಾ ಅನಿ ಜಾಸ್ತಿಚೆ ದಿವ್ನ್ ಹೊತಾ ಅನಿ ತೆಚೆಕ್ಡೆ ಭರ್‍ಪುರ್ ರ್‍ಹಾತಾ. ಖರೆ ಜೆ ಕೊನಾಕ್ಡೆ ಕಾಯ್ಬಿ ನಾ. ತೆಂಚ್ಯಾಕ್ಡೆ ಹೊತ್ತೆ ಉಲ್ಲೆಸೆಬಿ ಕಾಡುನ್ ಘೆವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ತ್ಯಾ ಕಾಮಾಕ್ ಯೆವ್ ನಸಲ್ಲ್ಯಾ ಆಳಾಕ್ ಭಾಯ್ರ್ ಕಾಳ್ಕಾತ್ ಢಕ್ಲುನ್ ಘಾಲಾ; ಥೈ ತೊ ಬೊಬ್ ಮಾರ್‍ತಾ ಅನಿ ತರಾಸಾನ್ ದಾತಾ ಚಾವ್ತಾ. ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ಮಾನ್ಸಾಚೊ ಲೆಕ್ ರಾಜಾಚಿ ಪದ್ವಿ ಘೆವ್ನ್ ಯೆತಾನಾ, ಸಗ್ಳಿ ದೆವಾಚಿ ದುತಾ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾತ್ಯಾತ್ ಅನಿ ತೊ ಅಪ್ನಾಚ್ಯಾ ಮಹಿಮೆಚ್ಯಾ ಸಿವಾಸನಾ ವರ್‍ತಿ ಬಸ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ಅನಿ ಸಗ್ಳ್ಯಾ ಬಾಶಾಂಚಿ ಲೊಕಾ ತೆಚ್ಯಾ ಇದ್ರಾಕ್ ಜಮಾ ಹೊತ್ಯಾತ್. ತನ್ನಾ ಕುರ್‍ಬುರಾ ಕಶೆ ಶೆಳಿಯಾಕ್ನಿ ಅನಿ ಬಕ್ರ್ಯಾಕ್ನಿ ಎಗಳ್ತ್ಯಾತ್ ತಸೆ ತೊ ಥೈ ಜಮಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ದೊನ್ ತಾಂಡೆ ಕರುನ್ ಎಗಳ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ಮಾನಾ ಬರ್‍ಯಾ ವಾಟೆನ್ ಚಲಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಪ್ನಾಚ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಅನಿ ಬರ್‍ಯಾ ವಾಟೆನ್ ಚಲಿನಸಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ರೊಡ್ಡ್ಯಾ ಬಾಜುಕ್ ಇಬೆ ರ್‍ಹಾವ್‍ಸುತಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ತನ್ನಾ ರಾಜಾ ಅಪ್ನಾಚ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಹೊತ್ತ್ಯಾಕ್ನಿ,ಮಾಜ್ಯಾ ಬಾಬಾಚೊ ಆಶಿರ್ವಾದ್ ಹೊತ್ತ್ಯಾನು ಯೆವಾ! ಜಗ್ ರಚುಚ್ಯಾ ಅದ್ದಿಚ್ಯಾನ್ ತುಮ್ಚ್ಯಾಸಾಟ್ನಿ ತಯಾರ್ ಕರುನ್ ಥವಲ್ಲೊ ರಾಜ್ ತುಮ್ಚಿ ಆಸ್ತಿ ಕರುನ್ ಘೆವಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ಮಿಯಾ ಭುಕೆನ್ ಹೊತ್ತೊ ತುಮಿ ಮಾಕಾ ಜೆವಾನ್ ದಿಲ್ಯಾಶಿ. ಮಿಯಾ ಸೊಸೆನ್ ಹೊತ್ತೊ ಮಾಕಾ ತುಮಿ ಪಿವ್ಕ್ ದಿಲ್ಯಾಶಿ, ಮಿಯಾ ಪರ್‌ದೆಶಿ ಹೊಲ್ಲೊ ತುಮಿ ಮಾಕಾ ತುಮ್ಚ್ಯಾ ಘರಾತ್ನಿ ಅಸ್ರೊ ದಿಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ಮಿಯಾ ನಾಗ್ಡೊ ಹೊತ್ತೊ ತುಮಿ ಮಾಕಾ ನೆಸುಕ್ ದಿಲ್ಯಾಶಿ, ಮಿಯಾ ಶಿಕ್ ಪಡಲ್ಲೊ ತನ್ನಾ ಮಾಜಿ ಕಾಳ್ಜಿ ಕರ್‍ಲ್ಯಾಶಿ, ಮಿಯಾ ಬಂದಿಖಾನ್ಯಾತ್ ಹೊತ್ತೊ, ತನ್ನಾ ತುಮಿ ಮಾಕಾ ಭೆಟುಕ್ ಯೆಲ್ಲ್ಯಾಶಿ. ಮನುನ್ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ತನ್ನಾ ತ್ಯಾ ಬರ್‍ಯಾ ವಾಟೆನ್ ಚಲಲ್ಲ್ಯಾ ಲೊಕಾನಿ, ಧನಿಯಾ ಅಮಿ ಕನ್ನಾ ತುಕಾ ತಿಯಾ ಭುಕೆನ್ ಹೊತ್ತೆ ಬಗುನ್ ಜೆವಾನ್ ದಿಲಾವ್ ಅನಿ ಸೊಸೆನ್ ಹೊತ್ತೆ ಬಗುನ್ ಫಿವ್ಕ್ ದಿಲಾವ್? ");
INSERT INTO kans_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ಕನ್ನಾ ಅಮಿ ತುಕಾ ಪರ್‌ದೆಶಿ ಹೊತ್ತೆ ಬಗುನ್ ಅಮ್ಚ್ಯಾ ಘರಾತ್ನಿ ಅಸ್ರೊ ದಿಲಾವ್, ಅನಿ ನಾಗ್ಡೊ ಹೊತ್ತೊ ಬಗುನ್ ನೆಸುಕ್ ದಿಲಾವ್? ");
INSERT INTO kans_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ಕನ್ನಾ ಅಮಿ ತಿಯಾ ಶಿಕ್ ಹೊತ್ತೆ ಬಗುನ್, ಅನಿ ಬಂದಿಖಾನ್ಯಾತ್ ಹೊತ್ತೆ ಬಗುನ್ ತುಕಾ ಭೆಟುಕ್ ಯೆಲ್ಲಾವ್? ಮನುನ್ ಜಬಾಬ್ ದಿತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ತನ್ನಾ ರಾಜಾ ತೆಂಕಾ, ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗ್ತಾ, ಜೆ ಕಾಯ್ ತುಮಿ ಮಾಜ್ಯಾ ಹ್ಯಾ ಭಾವಾನಿತ್ಲ್ಯಾ ಎಕ್ ಬಾರಿಕ್ಲ್ಯಾ ಭಾವಾಕ್‍ ಸೈತ್ ಕರ್ಲ್ಯಾಶಿ ತೆ ಮಾಕಾಚ್ ಕರ್‍ಲ್ಯಾಶಿ! ಮನುನ್ ಜಬಾಬ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ಮಾನಾ ತೊ ಅಪ್ನಾಚ್ಯಾ ರೊಡ್ಡ್ಯಾ ಬಾಜುಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ, ಜಾವಾ ತುಮಿ ಸರಾಪ್ ಪಡಲ್ಲ್ಯಾನು ಮಾಜ್ಯಾ ಇದ್ರಾಕ್ನಾ ಧುರ್ ಜಾವಾ, ಗಿರೊ ಅನಿ ತೆಚ್ಯಾ ದುತಾಕ್ನಿ ತಯಾರ್ ಕರಲ್ಲ್ಯಾ ಕನ್ನಾಚ್ ಇಜಿ ನಸಲ್ಲ್ಯಾ ಆಗಿತ್ ಜಾವಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಭುಕೆನ್ ಹೊತ್ತೊ ತನ್ನಾ ತುಮಿ ಮಾಕಾ ಜೆವ್ಕ್ ದಿವ್ಕನ್ಯಾಶಿ, ಮಿಯಾ ಸೊಸೆನ್ ಹೊತ್ತೊ ತನ್ನಾ ತುಮಿ ಮಾಕಾ ಫಿವ್ಕ್ ದಿವ್ಕನ್ಯಾಶಿ; ");
INSERT INTO kans_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ಮಿಯಾ ಪರ್‌ದೆಶಿ ಹೊತ್ತೊ ತನ್ನಾ ತುಮಿ ಮಾಕಾ ತುಮ್ಚ್ಯಾ ಘರಾತ್ನಿ ಅಸ್ರೊ ದಿವ್ಕನ್ಯಾಶಿ, ಮಿಯಾ ನಾಗ್ಡೊ ಹೊತ್ತೊ ತನ್ನಾ ತುಮಿ ಮಾಕಾ ನೆಸುಕ್ ಕಪ್ಡೆ ದಿವ್ಕನ್ಯಾಶಿ. ಶಿಕ್ ಹೊತ್ತೊ ಅನಿ ಬಂದಿಖಾನ್ಯಾತ್ ಹೊತ್ತೊ ತನ್ನಾ ತುಮಿ ಮಾಜಿ ಕಾಳ್ಜಿ ಕರುಕ್‍ನ್ಯಾಶಿ. ಮನುನ್ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ತನ್ನಾ ತೆನಿ, ಧನಿಯಾ, ಕನ್ನಾ ಅಮಿ ತುಕಾ ಭುಕೆನ್ ಹೊತ್ತೊ ನಾಹೊಲ್ಯಾರ್ ಸೊಸೆನ್ ಹೊತ್ತೊ. ಪರ್‌ದೆಶಿ ಹೊತ್ತೊ ನಾಹೊಲ್ಯಾರ್ ನಾಗ್ಡೊ ಹೊತ್ತೊ. ಶಿಕ್ ಹೊತ್ತೊ ನಾಹೊಲ್ಯಾರ್ ಬಂದಿಖಾನ್ಯಾತ್ ಹೊತ್ತೊ ಬಗಟ್ಲಾವ್. ಅನಿ ತುಕಾ ಮಜತ್ ಕರಿನಸ್ತಾನಾ ರ್‍ಹಾಲಾವ್? ಮನುನ್ ಜಬಾಬ್ ದಿತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ತನ್ನಾ ರಾಜಾ, ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಕನ್ನಾ ತುಮಿ ಮಾಜ್ಯಾ ಹ್ಯಾ ಭಾವಾನಿತ್ಲ್ಯಾ ಎಕ್ ಬಾರಿಕ್ಲ್ಯಾ ಭಾವಾಕ್ ಮಜತ್ ಕರಿನಸ್ತಾನಾ ರ್‍ಹಾಲ್ಯಾಶಿ, ತನ್ನಾ ಮಾಕಾಚ್ ಮಜತ್ ಕರಿನಸ್ತಾನಾ ರ್‍ಹಾಲ್ಯಾಶಿ. ಮನುನ್ ಮನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ತನ್ನಾ ಹ್ಯಾ ಬರ್‍ಯಾ ವಾಟೆನ್ ಚಲಿನಸಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಖಾಯಮ್ಚ್ಯಾ ಶಿಕ್ಷೆತ್ ಧಾಡುನ್ ಹೊತಾ ಅನಿ ಬರ್‍ಯಾ ವಾಟೆನ್ ಚಲಲ್ಲಿ ಲೊಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲ್ಯಾ ಜಿವನಾಕ್ ಜಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ಜೆಜುನ್ ಹೆ ಸಗ್ಳೆ ಶಿಕ್ವುನ್ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ತುಮ್ಕಾ ಗೊತ್ತ್ ಹೊತ್ತ್ಯಾ ಸರ್ಕೆ ದೊನ್ ದಿಸಾಂಚ್ಯಾ ಮಾನಾ ಪಾಸ್ಕಾಚೊ ಸನ್ ಹಾಯ್ ಅನಿ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಕುರ್ಸಾರ್ ಮಾರುಕ್ ಮನುನ್ ಧರುನ್ ದಿವ್ನ್ ಹೊತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ತನ್ನಾ ಮುಖ್ಯ ಯಾಜಕಾ ಅನಿ ಜಾನ್ತಿ ಲೊಕಾ ಕಾಯಿಫಾಸ್ ಮನ್ತಲ್ಯಾ ಮಹಾಯಾಜಕಾಚ್ಯಾ ಘರಾಕ್ಡೆ ಜಮ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ಅನಿ ಕೊನಾಕ್ಬಿ ಕಳಿನಸ್ತಾನಾ ಜೆಜುಕ್ ಧರುನ್ ಜಿವಾನಿ ಮಾರ್‍ತಲೆ ಕಶೆ ಮನುನ್ ಯವ್ಜನ್ ಘಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ತನ್ನಾ ತೆನಿ,“ಸನಾಚ್ಯಾ ದಿಸಾತ್ನಿ ಹೆ ಸಗ್ಳೆ ಕರ್‍ತಲೆ ನಕ್ಕೊ ಲೊಕಾ ಡಂಗೊ ಉಟ್ವುತಿಲ್.” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ಜೆಜು ಬೆಥನಿ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಎಕ್ ಕಾಲಾತ್ ಕುಸ್ಟ್ ರೊಗ್ ಲಾಗುನ್ ತರಾಸ್ ಕರುನ್ ಘೆಟಲ್ಲ್ಯಾ ಸಿಮಾವಾಚ್ಯಾ ಘರಾತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ಜೆಜು ಜೆವಾನ್ ಕರುನ್ಗೆತ್ ಬಸಲ್ಲ್ಯಾ ತನ್ನಾ ಎಕ್ ಬಾಯ್ಕೊಮಾನುಸ್ ಲೈ ಮ್ಹಾಗ್ರೆ ಬರಿ ವಾಸ್ ಯೆತಲೆ ತೆಲ್ ಅಲಾಬಾಸ್ಟರ್ ಮನ್ತಲ್ಯಾ ಗುಂಡ್ಯಾನಿ ಕರಲ್ಲ್ಯಾ ಭರ್‍ನಿ ಘೆವ್ನ್ ಯೆಲಿ ಅನಿ ತೆ ತೆಲ್ ಜೆಜುಚ್ಯಾ ಟಕ್ಲ್ಯಾ ವರ್‍ತಿ ವೊತ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ಜೆಜುಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಹೆ ಬಗುನ್ ರಾಗ್ ಯೆಲೊ, ಅನಿ ತೆನಿ, “ಕಶ್ಯಾಕ್ ಹೆ ಎವ್ಡೆ ಸಗ್ಳೆ ಹಾಳ್ ಘಾಲ್ತಲೆ? ");
INSERT INTO kans_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ಹೆ ತೆಲ್ ಜಾಸ್ತಿ ಪೈಸ್ಯಾಕ್ನಿ ಇಕುನ್ ತೆ ಪೈಸೆ ಗರಿಬಾಕ್ನಿ ದಿಲ್ಯಾರ್ ಹೊಯ್‍ ಹೊತ್ತೆ ನ್ಹಯ್!” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ಜೆಜುಕ್ ತೆನಿ ಕಾಯ್ ಮನುಲ್ಯಾತ್ ಮನ್ತಲೆ ಕಳ್ಳೆ. ತಸೆಮನುನ್ ತೆನಿ ತೆಂಕಾ,“ಕಶ್ಯಾಕ್ ಮನುನ್ ತುಮಿ ಹ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ತರಾಸ್ ದಿವ್ಕ್ ಲಾಗ್ಲ್ಯಾಶಿ? ತೆನಿ ಮಾಜೆಸಾಟ್ನಿ ಎಕ್ ಬರೆ ಕಾಮ್ ಕರ್‍ಲಿನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ಗರಿಬ್ ಲೊಕಾ ಕನ್ನಾಬಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾತ್ಯಾತ್, ಖರೆ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಕನ್ನಾಬಿ ರ್‍ಹಾಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ತೆನಿ ಮಾಜ್ಯಾ ಆಂಗಾ ವರ್‍ತಿ ತೆಲ್ ವೊತುನ್ ಮಾಕಾ ಮಾಟಿ ದಿವ್ಕ್ ಮನುನ್ ತಯಾರ್ ಕರ್‍ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಖೈ ಹ್ಯಾ ಜಗಾತ್ ಬರಿ ಖಬರ್ ಸಾಂಗುನ್ ಹೊತಾ, ಥೈ ಥೈ ತೆನಿ ಕರಲ್ಲ್ಯಾ ಕಾಮಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗುನ್ ತಿಚಿ ಯಾದ್ ಕರುನ್ ಹೊತಾ.” ");
INSERT INTO kans_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ಬಾರಾ ಜಾನಾ ಶಿಸಾನಿತ್ಲೊ ಎಕ್ಲೊ ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತ್ ಮನ್ತಲೊ ಮುಖ್ಯ ಯಾಜಕಾನಿಕ್ಡೆ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ಅನಿ, “ಮಿಯಾ ಜೆಜುಕ್ ಧರುನ್ ದಿಲ್ಯಾರ್ ತುಮಿ ಮಾಕಾ ಕಾಯ್ ದಿತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ತಿಸ್ ಚಾಂದಿಚೆ ಪೈಸೆ ಮೆಜುನ್ ತೆಕಾ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ತನ್ನಾಚ್ಯಾನ್ ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತ್ ಜೆಜುಕ್ ಧರುನ್ ದಿತಲೊ ಬರೊ ಅವ್ಕಾಸ್ ಹುಡ್ಕುನ್ಗೆತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ಫುಗ್ ಯೆಯ್ ನಸಲ್ಲ್ಯಾ ಭಾಕ್ರಿಚ್ಯಾ ಸನಾಚ್ಯಾ ಪಯ್ಲೆಚ್ಯಾ ದಿಸಿ, ಶಿಸಾ ಜೆಜುಕ್ಡೆ ಯೆಲಿ ಅನಿ ತೆಕಾ,“ ಅಮಿ ಪಾಸ್ಕಾಚೆ ಜೆವಾನ್ ಖೈ ತಯಾರ್ ಕರುಚೆ ಮನುನ್ ತಿಯಾ ಮನ್ತೆಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ,“ಶಾರಾತ್ಲ್ಯಾ ಅಮುಕ್‌ ಹ್ಯಾ ಮಾನ್ಸಾಕ್ಡೆ ಜಾವಾ, ಅನಿ,‘ಗುರುಜಿ, ಮಾಜೊ ಎಳ್ ಜಗ್ಗೊಳ್ ಯೆಲಾ; ಮಿಯಾ ಮಾಜ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ತುಜ್ಯಾ ಘರಾತ್ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚೆ ಜೆವಾನ್ ಕರ್‍ತಾ,’ ಮನುಲಾ ಮನುನ್ ಸಾಂಗಾ.” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ಶಿಸಾನಿ ಜೆಜುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ಕರ್‍ಲ್ಯಾನಿ ಅನಿ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚೆ ಜೆವಾನ್ ತಯಾರ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ಸಾಂಜ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜು ಅನಿ ಬಾರಾ ಜಾನಾ ಶಿಸಾ ಜೆವ್ನಾಕ್ ಬಸ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ತೆನಿ ಜೆವಾನ್ ಕರ್‍ತಾನಾ ಜೆಜುನ್,“ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ. ತುಮ್ಚ್ಯಾತ್ಲೊ ಎಕ್ಲೊ ಮಾಕಾ ವಿಶ್ವಾಸ್‍ ಘಾತ್ ಕರ್‍ನಾರ್ ಹಾಯ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ಹೆ ಆಯ್ಕುನ್ ಶಿಸಾಕ್ನಿ ಲೈ ಬೆಜಾರ್ ಹೊಲೊ ಅನಿ ತೆನಿ ಎಕೆಕ್ಲೊಚ್ ಜೆಜುಕ್, “ಧನಿಯಾ, ಮಿಯಾ ತರ್ ನ್ಹಯ್, ನ್ಹಯ್?” ಮನುನ್ ಇಚಾರುಕ್‍ ಲಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ,“ಜೆ ಕೊನ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಆಯ್ದಾನಾತ್ ಅಪ್ನಾಕ್ಲ್ಯಾ ಭಾಕ್ರಿಚೊ ತುಕ್ಡೊ ಬುಡ್ವುತಾ, ತೊಚ್ ತೊ ಮಾಕಾ ವಿಶ್ವಾಸ್ ಘಾತ್ ಕರ್‍ತಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮರುಕುಚ್ ಮಾಜೆ, ಅನಿ ತೊ ಮರ್‍ತಾಚ್ ಖರೆ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ವಿಶ್ವಾಸ್ ಘಾತ್ ಕರ್‍ತಲ್ಯಾಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ತೊ ಉಪ್ಜುಕುಚ್ ನಸ್ಲ್ಯಾರ್ ತ್ಯಾ ಮಾನ್ಸಾಕುಚ್ ಬರೆ ಹೊತ್ತೆ!” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ವಿಶ್ವಾಸ್ ಘಾತ್ ಕರ್‍ತಲೊ ಜುದಾಸ್ ಬೊಲುಲಾಲೊ ಅನಿ “ಗುರುಜಿ, ಖರೆಬಿ ಮಿಯಾ ತರ್ ನ್ಹಯ್, ನ್ಹಯ್ ತೊ?” ಮನುನ್ ಜೆಜುಕ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ಜೆಜುನ್, “ತಿಯಾ ಸಾಂಗ್ಲೆ ತಸೆಚ್.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ತೆನಿ ಜೆವಾನ್ ಕರ್‍ತಾನಾ ಜೆಜುನ್ ಎಕ್ ಭಾಕ್ರಿ ಘೆವ್ನ್ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನ್, ಅನಿ ಮೊಡುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ದಿವ್ನ್. “ಹೆ ಘೆವಾ ಅನಿ ಖಾವಾ. ಹೆ ಮಾಜೆ ಆಂಗ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ಮಾನಾ ತೆನಿ ಕಟೊರೊ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ಅನಿಎಗ್ದಾ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನ್, ಅನಿ ಶಿಸಾಕ್ನಿ ದಿವ್ನ್, “ಹೆ ಘೆವಾ ಅನಿ ತುಮಿ ಸಗ್ಳೆ ಜಾನಾ ಫಿವಾ.” ");
INSERT INTO kans_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ಹೆ ದೆವಾಚ್ಯಾ ನವ್ಯಾ ಕರಾರಾಚ್ಯಾ ವರ್‍ತಿ ಛಪ್ಪೊ ಮಾರ್‍ತಲೆ ಮಾಜೆ ರಗಾತ್, ಲೈ ಜಾನಾಂಚ್ಯಾ ಪಾಪಾಂಚ್ಯಾ ಮಾಪಿ ಸಾಟ್ನಿ ವೊತಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ರಾಜಾತ್ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ನ್ಹವಿ ವಾಯ್ನ್ ಫಿತಲ್ಯಾ ದಿಸಾ ಪತರ್ ಹಿ ವಾಯ್ನ್ ಮಿಯಾ ಅನಿ ಕನ್ನಾಚ್ ಫಿ ನಾ. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ಮಾನಾ ತೆನಿ ಎಕ್ ಗಿತ್ ಗಾವ್ಲ್ಯಾನಿ ಅನಿ ಒಲಿವ್ ಮನ್ತಲ್ಯಾ ಮಡ್ಡಿಕ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ತನ್ನಾ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ,“ ಆಜ್ ಹ್ಯಾಚ್ ರಾತ್ತಿನ್ ತುಮಿ ಸಗ್ಳೆ ಜಾನಾ ಮಾಕಾ ಸೊಡುನ್ ಪಳುನ್ ಜಾತ್ಯಾಶಿ. ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ದೆವ್ ಮನ್ತಾ, ಮಿಯಾ ಕುರ್‍ಬುರಾಕ್ ಜಿವಾನಿ ಮಾರ್‍ತಾ ಅನಿ ತಾಂಡ್ಯಾತ್ಲಿ ಬಕ್ರಿ ಸಗ್ಳಿ ಮಾಳ್ಬರ್ ಹೊತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ಖರೆ ಮಿಯಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮ್ಚ್ಯಾನ್ಕಿ ಅದ್ದಿ ಗಾಲಿಲಿಯಾ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಜಾತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ತನ್ನಾ ಪೆದ್ರು ಜೆಜುಕ್, “ಸಗ್ಳೆ ಜಾನಾ ತುಕಾ ಸೊಡುನ್ ಗೆಲ್ಯಾರ್‍ಬಿ, ಮಿಯಾ ತರ್ ತುಕಾ ಸೊಡುನ್ ಜಾಯ್ನಾ.” ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ತನ್ನಾ ಜೆಜುನ್ ಪೆದ್ರುಕ್,“ಮಿಯಾ ತುಕಾ ಸಾಂಗ್ತಾ ಆಜ್ ರಾಚ್ಚೆ ಕೊಂಬೊ ಭೊಕುಚ್ಯಾ ಅದ್ದಿ ತಿಯಾ ತಿನ್ ದಾ ಮಾಜಿ ತುಕಾ ವಳಕುಚ್ ನಾ ಮನುನ್ ಸಾಂಗ್ತೆಯ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ತನ್ನಾ ಪೆದ್ರುನ್, “ಮಾಕಾ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ಮರ್‍ತಲಿ ಪರಿಸ್ತಿತಿ ಯೆಲ್ಯಾರ್‍ಬಿ, ಅಶೆ ಕನ್ನಾಚ್ ಮನಿ ನಾ!” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ಅನಿ ಹುರಲ್ಲ್ಯಾ ಶಿಸಾನಿಬಿ ಅಸೆಚ್ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ಮಾನಾ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆತ್ಸೆಮನಿ ಮನ್ತಲ್ಯಾ ಮಳ್ಯಾಕ್ ಗೆಲೊ, ಅನಿ ತೆಂಕಾ,“ಮಿಯಾ ಉಲ್ಲೆ ಫಿಡೆ ಜಾವ್ನ್ ಮಾಗ್ನಿ ಕರ್‍ತಾ ತುಮಿ ಹಿತ್ತೆಚ್ ಬಸಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ಪೆದ್ರುಕ್ ಅನಿ ಜೆಬೆದೆವಾಚ್ಯಾ ದೊಗ್ಯಾ ಲೆಕಾಕ್ನಿ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಲ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್. ದುಕ್ ಅನಿ ವಳ್ವಳೊ ತೆಚ್ಯಾ ಭುತ್ತುರ್ ಭರಲ್ಲೊ ಹೊತ್ತೊ, ");
INSERT INTO kans_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ತೆನಿ ತೆಂಕಾ,“ಮಾಜ್ಯಾ ಜಿವಾಚೊ ಹ್ಯೊ ಮೊಟೊ ಸಂಕಟ್ ಮಾಕಾ ಚಿರ್ಡುನ್ ಮಾರುನ್ ಟಾಕ್ತಾ ಸರ್ಕೆ ಹೊವ್ಲಾ, ತುಮಿ ಹಿತ್ತೆ ಇಬೆ ರ್‍ಹಾವಾ ಅನಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಜಾಗೆ ರ್‍ಹಾವಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ತೊ ಉಲ್ಲೆ ಫಿಡೆ ಗೆಲೊ ಅನಿ ಜಮ್ನಿ ವರ್‍ತಿ ಡಬ್ ಪಡುನ್, “ಮಾಜ್ಯಾ ಬಾಬಾ, ಹೊತಾ ಜಾಲ್ಯಾರ್, ಹೆ ಕಸ್ಟಾಚೆ ಆಯ್ದಾನ್ ಮಾಜ್ಯಾ ವೈನಾ ಕಾಡುನ್ ಘೆ! ಖರೆ ಮಾಜ್ಯಾ ಮನಾ ಸರ್ಕೆ ನ್ಹಯ್, ತುಜ್ಯಾ ಮನಾ ಸರ್ಕೆ ಹೊಂವ್ದಿತ್,” ಮನುನ್ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ಮಾನಾ ತೊ ಪರ್ತುನ್ ತಿಗ್ ಜಾನಾ ಶಿಸಾನಿಕ್ಡೆ ಯೆಲೊ. ತೆನಿ ನಿಜೆನ್ ಝೆಮುಲಾಗಲ್ಲೆ. ತನ್ನಾ ಜೆಜುನ್ ಪೆದ್ರುಕ್, “ತುಮ್ಕಾ ತಿಗ್ಯಾಕ್ನಿ ಮಾಜೆಸಾಟ್ನಿ ಎಕ್ ತಾಸ್‍ಬರ್ ಸೈತ್ ಜಾಗೆ ರ್‍ಹಾವ್ಕ್ ಹೊಯ್ನಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ಜಾಗೆ ರ್‍ಹಾವಾ ಅನಿ ತುಮಿ ಪಾಪಾತ್ ಪಡ್ತಲ್ಯಾ ವಿಶಯಾತ್ನಿ ಪಡಿನಸ್ತಾನಾ ರ್‍ಹವ್‍ಸಾಟ್ನಿ ಮಾಗ್ನಿ ಕರಾ. ಅತ್ಮ್ಯಾಕ್ ಮನ್ ಹಾಯ್ ಹೊಯ್ ಖರೆ ಆಂಗಾಕ್ ತವ್ಡೊ ಬಳ್ ನಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ಅನಿ ಎಗ್ದಾ ಜೆಜು ಫಿಡೆ ಗೆಲೊ ಅನಿ, “ಮಾಜ್ಯಾ ಬಾಬಾ, ಹೆ ಕಸ್ಟಾಚೆ ಆಯ್ದಾನ್ ಮಿಯಾ ಫಿಲ್ಯಾ ಸಿವಾಯ್ ಧುರ್ ಕರುಕ್ ಹೊಯ್ನಾ ಮನುನ್ ರ್‍ಹಾಲ್ಯಾರ್, ತುಜ್ಯಾ ಮನಾ ಸರ್ಕೆಚ್ ಹೊಂವ್ದಿತ್.” ಮನುನ್ ಮಾಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ತೊ ಅನಿ ಪರ್ತುನ್ ಶಿಸಾನಿಕ್ಡೆ ಗೆಲೊ ತನ್ನಾ ತೆಂಕಾ ಭರ್‍ತಿ ನಿಜ್‍ ಯೆಲ್ಲಿ; ನಿಜೆನ್ ತೆಂಚೆ ಡೊಳೆ ಉಗ್ಡಿನಸಿತ್. ");
INSERT INTO kans_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ಅನಿ ಪರ್ತುನ್ ಜೆಜು ತೆಂಕಾ ಸೊಡುನ್ ಫಿಡೆ ಗೆಲೊ ಅನಿ ತಿನ್ವೆಪಟಿಬಿ ತೆನಿ ತಸೆಚ್ ಮನುನ್ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ತನ್ನಾ ತೊ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾನಿಕ್ಡೆ ಪರ್ತುನ್ ಯೆಲೊ, ಅನಿ. “ಅಜುನ್‍ಬಿ ತುಮಿ ನಿಜುನ್ ಅರಾಮ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ? ಅಬಕಾ! ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಧರುನ್ ಪಾಪಿ ಲೊಕಾಂಚ್ಯಾ ಹಾತಿತ್ ಒಪಸ್ತಲೊ ಎಳ್ ಯೆಲೊ”. ");
INSERT INTO kans_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","“ಉಟಾ ಅಮಿ ಜಾಂವಾ. ಅಬಕಾ, ಮಾಕಾ ವಿಶ್ವಾಸ್‍ ಘಾತಾನ್ ಧರುನ್ ದಿತಲೊ ಮಾನುಸ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ಅಶೆ ಜೆಜು ಬೊಲುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾಚ್ ಜುದಾಸ್ ಮನ್ತಲೊ ಬಾರಾ ಜಾನಾ ಶಿಸಾನಿತ್ಲೊ ಎಕ್ಲೊ ಥೈ ಯೆವ್ನ್ ಪಾವ್ಲೊಚ್. ತೆಚ್ಯಾ ಫಾಟ್ನಾ ಕೊಯ್ತೆ ಅನಿ ಟೊನೆ ಘೆವ್ನ್ ಎಕ್ ಮೊಟೊ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಹೊತ್ತೊ. ಮುಖ್ಯ ಯಾಜಕಾನಿ ಅನಿ ಜುದೆವಾಂಚ್ಯಾ ಜಾನ್ತ್ಯಾನಿ ತೆಂಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ಘಾತಾನ್ ಧರುನ್ ದಿತಲ್ಯಾನ್. \"ಮಿಯಾ ಕೊನಾಕ್ ಉಪ್ಪಾ ದಿತಾ ತೊಚ್ ತೊ ತೆಕಾ ತುಮಿ ಧರಾ.\" ಮನುನ್ ಎಕ್ ವಳಕ್ ಅದ್ದಿಚ್ ತೆಂಕಾ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ಜುದಾಸ್ ಯೆಲ್ಲೊಚ್ ನಿಟ್ ಜೆಜುಕ್ಡೆ ಗೆಲೊ, ಅನಿ “ಗುರುಜಿ ಶಾಂತಿ ತುಮ್ಕಾ,” ಮಟ್ಲ್ಯಾನ್ ಅನಿ ಜೆಜುಚಿ ಉಪ್ಪಾ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ಜೆಜುನ್ ತೆಕಾ, “ಮಾಜ್ಯಾ ದೊಸ್ತಾ, ತಿಯಾ ಕಾಯ್ ಕರುಚೆ ಮನುನ್ ಯೆಲೆ ತೆ ಕಾಮ್ ಲಗ್ಗುನಾಚ್ ಕರುನ್ ಸಾರ್,” ಮಟ್ಲ್ಯಾನ್. ತವ್ಡ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತ್ಯಾ ಲೊಕಾನಿ ಯೆವ್ನ್ ಜೆಜುಕ್ ಧರುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ತನ್ನಾ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ಎಕ್ಲ್ಯಾನ್ ಅಪ್ನಾಚೊ ಮೊಟೊ ಚಾಕು ಕಾಡುನ್ ಮೊಟ್ಯಾ ಯಾಜಕಾಚ್ಯಾ ಎಕ್ ಆಳಾಚ್ಯಾ ಕಾನಾಕ್ ಮಾರ್‍ಲ್ಯಾನ್, ತೆಚೊ ಕಾನುಚ್ ತುಟುನ್ ಪಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ತನ್ನಾ ಜೆಜುನ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ “ತುಜೊ ಮೊಟೊ ಚಾಕು ತುಜ್ಯಾ ಪಿಸ್ವಿತ್ ಘಾಲ್, ಜೆ ಕೊನ್ ಮೊಟೊ ಚಾಕು ಘೆತ್ಯಾತ್ ತೆನಿ ಚಾಕ್ವಾನಿಚ್ ನಾಸ್ ಹೊವ್ನ್ ಜಾತ್ಯಾತ್.” ");
INSERT INTO kans_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","“ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ಡೆ ಮಾಗಟ್ಲ್ಯಾರ್ ತೊ ಮಾಜ್ಯಾ ಮಜತಿಕ್ ಮನುನ್ ಸೈನಿಕಾಂಚ್ಯಾ ಬಾರಾ ತಾಂಡ್ಯಾಂನ್ಚ್ಯಾನ್ಕಿ ಜಾಸ್ತಿ ದೆವಾಚ್ಯಾ ದುತಾಕ್ನಿ ಧಾಡಿನಸ್ತಾನಾ ರ್‍ಹಾತಾ ಮನುನ್ ತಿಯಾ ಚಿಂತ್ಲೆ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ಖರೆ ಅಶೆ ಹೊಲ್ಯಾರ್, ಹೊವ್ಕುಚ್ ಪಾಜೆ ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲೆ ಪುರಾ ಹೊತಲೆ ಕಶೆ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ತನ್ನಾ ಜೆಜುನ್ ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್, “ಎಕ್ ಚೊರಾಕ್ ಧರುಕ್ ಯೆಲ್ಯಾ ಸರ್ಕೆ ಕೊಯ್ತೆ ಅನಿ ಟೊನೆ ಘೆವ್ನ್ ತುಮಿ ಮಾಕಾ ಧರುಕ್ ಯೆಲ್ಯಾಶಿ? ಸದ್ದಿಚ್ ಮಿಯಾ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ತುಮ್ಚ್ಯಾ ಮದ್ದಿಚ್ ಬಸುನ್ ತುಮ್ಕಾ ಶಿಕ್ವಿ, ತನ್ನಾ ತುಮಿ ಮಾಕಾ ಧರುಕ್‍ನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ಖರೆ ಪ್ರವಾದ್ಯಾನಿ ಅಪ್ನಾಚ್ಯಾ ಪುಸ್ತಕಾತ್ನಿ ಸಾಂಗಲ್ಲೆ ಪುರಾ ಹೊವ್‍ಸಾಟ್ನಿ ಅಶೆ ಸಗ್ಳೆ ಹೊಲೆ.” ಮಟ್ಲ್ಯಾನ್. ತವ್ಡ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸಗ್ಳಿ ಶಿಸಾ ಜೆಜುಕ್ ಸೊಡುನ್ ಪಳುನ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ಜೆಜುಕ್ ಧರುನ್ ಘೆವ್ನ್ ಯೆಲ್ಲ್ಯಾನಿ, ತೆಕಾ ಮಹಾಯಾಜಕಾ ಕಾಯಿಫಾಸಾಚ್ಯಾ ಘರಾಕ್ಡೆ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ಥೈ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲಿ ಲೊಕಾ ಅನಿ ಜಾನ್ತಿ ಲೊಕಾ ಜಮಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ಪೆದ್ರು ಧುರ್-ಧುರ್‍ನಾಚ್ ತೆಂಚ್ಯಾ ಫಾಟ್ನಾ ಮಹಾಯಾಜಕಾಚ್ಯಾ ಘರಾಚ್ಯಾ ದಾರಾತ್ ಪತರ್ ಯೆಲೊ, ತೊ ದಾರಾತ್ ಭುತ್ತುರ್ ಗುಸ್ಲೊ ಅನಿ ಕಾಯ್ ಕಾಯ್ ಹೊತಾ ಬಗುಸಾಟ್ನಿ ಮನುನ್ ರಾಕ್ವಾಲ್ಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ತನ್ನಾ ಮುಖ್ಯ ಯಾಜಕಾ ಅನಿ ಸಗ್ಳಿ ಜುದೆವಾಂಚಿ ನ್ಯಾಯ್ ನಿರ್‍ನಯ್ ಕರ್‍ತಲಿ ಸಭಾ ಮಿಳುನ್ ಜೆಜುಚ್ಯಾ ವಿರೊದ್ ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿ ಸರ್ಕಿ ಕಸ್ಲಿಬಿ ಝುಟಿ ಸಾಕ್ಷಿ ಗಾವ್ತಾ ಕಾಯ್ ಮನುನ್ ಹುಡಕ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ಖರೆ ತೆಂಕಾ ಎಕ್‍ಬಿ ಸಾಕ್ಷಿ ಗಾವುಕ್ನಾ; ಜಾಲ್ಯಾರ್‍ಬಿ ಲೈ ಲೊಕಾ ತೆಚ್ಯಾ ವಿಶಯಾತ್ ಝುಟ್ಯಾ ಸಾಕ್ಷಿಯಾ ಸಾಂಗುಕ್ ಫಿಡೆ ಯೆಲಿ. ಆಕ್ರಿಕ್ ದೊಗೆ ಫಿಡೆ ಯೆವ್ನ್, ");
INSERT INTO kans_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ಹ್ಯೊ ಮಾನುಸ್, ದೆವಾಚಿ ಗುಡಿ ಪಾಡ್ವುನ್ ತಿನ್ ದಿಸಾತ್ನಿ ಅನಿಪರ್‍ತುನ್ ಭಾಂದ್ತಾ ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ.” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ತನ್ನಾ ಮಹಾಯಾಜಕ್ ಇಬೆ ರ್‍ಹಾಲೊ ಅನಿ,“ ಹೆನಿ ತುಜೆ ವರ್‍ತಿ ಘಾಲ್ತಲ್ಯಾ ಹ್ಯಾ ಅಪ್ವಾದಾಚ್ಯಾ ವಿಶಯಾತ್ ತಿಯಾ ಕಾಯ್ಬಿ ಸಾಂಗಿನೆಯ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ಖರೆ ಜೆಜು ಗಪ್ಪುಚ್ ಹೊತ್ತೊ. ತನ್ನಾ ಮಹಾಯಾಜಕಾನ್, “ಮಿಯಾ ಝಿತ್ತ್ಯಾ ದೆವಾಚ್ಯಾ ಆನೆನ್ ತುಕಾ ಇಚಾರುಲಾ, ತಿಯಾ ದೆವಾಚೊ ಲೆಕ್ ಕ್ರಿಸ್ತ್ ಹೊಲ್ಯಾರ್ ಅಮ್ಕಾ ಸಾಂಗ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ತನ್ನಾ ಜೆಜುನ್, “ಹೊಯ್,ತಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್. ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಸಾಂಗ್ತಾ, ಅತ್ತಾಚ್ಯಾನ್ ತುಮಿ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಪರಮೊನ್ನತ್ ದೆವಾಚ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಬಸಲ್ಲೊ ಅನಿ ಸರ್‍ಗಾಚ್ಯಾ ಮೊಡಾಂಚ್ಯಾ ವೈನಾ ಯೆತಲೊ ಬಗ್ತ್ಯಾಶಿ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ತನ್ನಾ ಮಹಾಯಾಜಕಾನ್ ರಾಗಾನ್ ಅಪ್ನಾಚೆ ಕಪ್ಡೆ ಪಿಜುನ್ ಘೆವ್ನ್, “ಹಿ ದೆವಾಚಿ ನಿಂದಾ ಹೊಲಿ! ಅನಿ ಜಾಸ್ತಿಚಿ ಮೊಟಿ ಸಾಕ್ಷಿ ಅಮ್ಕಾ ಪಾಜೆ ಮನುನ್ ನಾ! ತೆನಿ ಬೊಲಲ್ಲಿ ದೆವಾಚಿ ನಿಂದ್ಯಾ ತುಮಿಚ್ ಆಯಿಕ್ಲ್ಯಾಶಿ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ಅನಿ, “ಹೆಕಾ ತುಮಿ ಕಾಯ್ ಮನ್ತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ, “ತೊ ಎಕ್ ಚುಕಿದಾರ್, ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ಹೊವ್ಕುಚ್ ಪಾಜೆ.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ತನ್ನಾ ತೆನಿ ತೆಚ್ಯಾ ತೊಂಡಾರ್ ಥುಕ್ಲ್ಯಾನಿ, ಅನಿ ಮುಟ್ಕ್ಯಾನಿ ಮಾರ್‍ಲ್ಯಾನಿ; ಅನಿ ತೆಕಾ ಠಪ್ರಾಕ್ಯಾ ಮಾರುನ್, ");
INSERT INTO kans_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ಕ್ರಿಸ್ತಾ!, ತುಕಾ ಮುಟ್ಕೊ ಮಾರಲ್ಲೊ ಕೊನ್ ಮನುನ್ ಪ್ರವಾದ್ ಕರುನ್ ಸಾಂಗ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ಹಿಕ್ಡಿನ್ ಪೆದ್ರು, ಭಾಯ್ರ್ ದಾರಾತ್ ಬಸಲ್ಲೊ ಹೊತ್ತೊ, ತನ್ನಾ ಮಹಾಯಾಜಕಾಚ್ಯಾ ಘರಾತ್ ಕಾಮ್ ಕರ್‍ತಲಿ ಎಕ್ ಬಾಯ್ಕೊಮನುಸ್ ತೆಚೆಕ್ಡೆ ಯೆಲಿ, ಅನಿ,“ತಿಯಾಬಿ ಗಾಲಿಲಿಯಾಚ್ಯಾ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೆ ನ್ಹಯ್!” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ಖರೆ ಪೆದ್ರುನ್ ತಿರಸ್ಕಾರ್ ಕರುನ್, “ತಿಯಾ ಖಚ್ಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲೆಯ್ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ನಾ.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ಅನಿ ಮಹಾಯಾಜಕಾಚ್ಯಾ ದಾರಾತ್ ಯೆತಲ್ಯಾ ವಾಟೆಕ್ಡೆ ಗೆಲೊ. ಥೈ ಅನಿ ಎಕ್ ಕಾಮಾಚ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್ ತೆಕಾ ಥೈ ಬಗಟ್ಲಿನ್. ಅನಿ ಥೈ ಹೊತ್ತ್ಯಾ ಘೊಮನ್ಸಾಕ್ನಿ,“ಹ್ಯೊಬಿ ನಜರೆತಾಚ್ಯಾ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ಅನಿಬಿ ಪೆದ್ರುನ್ ತಿರಸ್ಕಾರ್ ಕರುನ್, “ಆನ್ ಘಾಲುನ್ ಮಿಯಾ ಸಾಂಗ್ತಾ ತೊ ಕೊನ್ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ನಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ಎಕ್ ಉಲ್ಲೊ ಎಳ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಥೈ ಇಬೆ ಹೊತ್ತಿ ಘೊಮನ್ಸಾ ಪೆದ್ರುಕ್ಡೆ ಯೆಲಿ. “ಖರೆಚ್ ತಿಯಾಬಿ ತೆಂಚ್ಯಾತ್ಲೊ ಎಕ್ಲೊ, ತುಜ್ಯಾ ಬೊಲ್ನ್ಯಾ ವೈನಾಚ್ ಕಳುಕ್ ಲಾಗ್ಲಾ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ತನ್ನಾ ಪೆದ್ರುನ್, “ಮಿಯಾ ಖರೆಬಿ ಖರೆಚ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ. ಮಿಯಾ ಝುಟೆ ಬೊಲುಲಾ ಹೊಲ್ಯಾರ್ ದೆವ್ ಮಾಕಾ ಶಿಕ್ಷಾ ದಿಂವ್ದಿತ್. ಮಿಯಾ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ವಳ್ಕಿಚ್ ನಾ!” ಮಟ್ಲ್ಯಾನ್. ತವ್ಡ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಕೊಂಬೊ ಭೊಕ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ತನ್ನಾ ಪೆದ್ರುಕ್ ಜೆಜುನ್ “ಕೊಂಬೊ ಭೊಕುಚ್ಯಾ ಅದ್ದಿ ತಿನ್‍ದಾ ತಿಯಾ ಮಾಜಿ ವಳಕುಚ್‍ ನಾ ಮನುನ್ ಸಾಂಗ್ತೆಯ್.” ಮನುನ್ ಸಾಂಗಲ್ಲಿ ಯಾದ್ ಯೆಲಿ. ತನ್ನಾ ತೊ ಭಾಯ್ರ್ ಗೆಲೊ ಅನಿ ಗಳ್ಗಳುನ್ ರಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ಸಕ್ಕಾಳಿ ಫಿಡೆ ಸಗ್ಳ್ಯಾ ಮುಖ್ಯ ಯಾಜಕಾನಿ ಅನಿ ಜುದೆವ್ ಲೊಕಾಂಚ್ಯಾ ಜಾನ್ತ್ಯಾನಿ ಮಿಳುನ್ ಜೆಜುಕ್ ಕಶೆ ಜಿವಾನಿ ಮಾರ್‍ತಲೆ ಮನುನ್ ಯವ್ಜನ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ತೆಕಾ ಸರ್‍ಪೊಳ್ಯಾನಿ ಭಾಂದ್ಲ್ಯಾನಿ ಅನಿ ನ್ಹೆವ್ನ್ ರೊಮಾಚೊ ಅದಿಕಾರಿ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ಪಿಲಾತಾಚ್ಯಾ ತಾಬೆತ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ಜೆಜುಕ್ ವಾಯ್ಟ್ ಕರ್‍ತಲೆ ತೆಕಾ ಘಾತ್ ಕರುನ್ ಧರುನ್ ದಿಲ್ಲ್ಯಾ ಜುದಾಸಾನ್ ಬಗಟ್ಲ್ಯಾನ್, ತನ್ನಾ ತೆಕಾ ಲೈ ವಾಯ್ಟ್ ದಿಸ್ಲೆ ಅನಿ ತೊ ಬದಲ್ಲೊ, ತೆ ತಿಸ್ ಚಾಂದಿಚೆ ಪೈಸೆ ಘೆವ್ನ್ ಮುಖ್ಯ ಯಾಜಕಾ ಅನಿ ಜಾನ್ತ್ಯಾನಿಕ್ಡೆ ಯೆಲೊ. ಅನಿ, ");
INSERT INTO kans_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ಎಕ್ ಚುಕ್ ನಸಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಜಿವಾನಿ ಮಾರುಕ್ ಧರುನ್ ದಿವ್ನ್ ಮಿಯಾ ಚುಕ್ ಕರ್‍ಲೊ!” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ,“ಅಮಿ ಕಶ್ಯಾಕ್ ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಚಿಂತಾ ಕರುಚೆ? ತುಜೆ ಸಮಸ್ಯೆ ತೆ ತಿಯಾಚ್ ಬಗುನ್ ಘೆ!” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ತನ್ನಾ ಜುದಾಸ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಗೆಲೊ ಅನಿ ತೆ ಪೈಸೆ ಥೈಚ್ ಟಾಕುನ್ ಭಾಯ್ರ್ ಗೆಲೊ ಅನಿ ಪಾಸಿ ಘಾಲುನ್ ಘೆವ್ನ್ ಮರ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ಮುಖ್ಯ ಯಾಜಕಾನಿ ಹೆ ಪೈಸೆ ಯೆಚುನ್ ಘೆಟ್ಲ್ಯಾನಿ ಅನಿ, “ಎಕಾ ಮಾನ್ಸಾಚೊ ಜಿವ್ ಕಾಡುಕ್ ಮನುನ್ ದಿಲ್ಲೆ ಪೈಸೆ ಹೆ ಅನಿ ಹೆ ಪೈಸೆ ಕಾನಿಕಿಚ್ಯಾ ಡಬ್ಬ್ಯಾತ್ ಥವ್ತಲೆ ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಚುಕ್ ಹೊತಾ.”ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ಮಾನಾ ತೆನಿ ಎಕ್ ನಿರ್ದಾರಾಕ್ ಯೆವ್ನ್ ಕುಂಬಾರಾಚೆ ಶೆತ್ ಮನ್ತಲೊ ಜಾಗೊ ಇಕಾತ್ ಘೆಟ್ಲ್ಯಾನಿ, ಅನಿ ಹ್ಯೊ ಜಾಗೊ ದುಸ್ರ್ಯಾ ದೆಸಾತ್ನಾ ಯೆಲ್ಲಿ ಲೊಕಾ ಹ್ಯಾ ದೆಸಾತ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಮರ್ಲ್ಯಾರ್ ತೆಂಕಾ ಮಾಟಿ ದಿವ್ಕ್ ವಾಪರ್ತಲೊ ಮನುನ್ ನಿರ್‍ದಾರ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ಹೆಚೆಸಾಟ್ನಿ ತ್ಯಾ ಶೆತಾಕ್ ಆಜ್ ಪತರ್‍ಬಿ, “ರಗ್ತಾಚೆ ಶೆತ್” ಮನುನ್ ನಾವ್ ಪಡಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ಅಶೆ ಜೆರೆಮಿಯಾ ಪ್ರವಾದ್ಯಾನ್, “ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ದಿವ್ಕ್ ಮನುನ್ ನಿರ್‍ದಾರ್ ಕರಲ್ಲೆ ತಿಸ್ ಚಾಂದಿಚೆ ಪೈಸೆ ಘೆಟ್ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ಅನಿ ಧನಿಯಾನ್ ಮಾಕಾ ದಿಲ್ಲ್ಯಾ ಹುಕುಮಾ ಪರ್ಕಾರ್ ಕುಂಬಾರಾಚೆ ಶೆತ್ ಇಕಾತ್ ಘೆವ್ಕ್ ವಾಪರ್‍ಲ್ಯಾನಿ.” ಮನುನ್ ಸಾಂಗಲ್ಲಿ ಗೊಸ್ಟ್ ಪುರಾ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ತನ್ನಾ ಜೆಜು ರೊಮಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾ ಪಿಲಾತಾಚ್ಯಾ ಇದ್ರಾಕ್ ಇಬೆ ರ್‍ಹಾಲೊ, ತನ್ನಾ ತೆನಿ ಜೆಜುಕ್,“ ತಿಯಾ ಜುದೆವಾಂಚೊ ರಾಜಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ “ತಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್” ಮನುನ್ ಜೆಜುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ಖರೆ ಮುಖ್ಯ ಯಾಜಕಾನಿ ಅನಿ ಜಾನ್ತ್ಯಾನಿ ತೆಚೆ ವರ್‍ತಿ ಅಪ್ವಾದಾ ಘಾಲ್ತಾನಾ ತೆನಿ ಕಾಯ್ಬಿ ಜಬಾಬ್ ದಿವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ತನ್ನಾ ಪಿಲಾತಾನ್ ಜೆಜುಕ್,“ ಹೆನಿ ತುಜೆ ವರ್‍ತಿ ಘಾಲ್ತಲಿ ಅಪ್ವಾದಾ ತುಕಾ ಆಯ್ಕೊ ಯೆಯ್ ನಾ ಹೊಲ್ಯಾತ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ಖರೆ ತೆನಿ ಎಕ್ ಸೈತ್ ಶಬ್ದ್ ಬೊಲುಕ್ನಾ. ಹೆ ಬಗಟಲ್ಲೊ ಪಿಲಾತ್ ಮನ್ತಲೊ ಅದಿಕಾರಿ ಅಜಾಪ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ಹರ್ ಎಕ್ ವರ್ಸಾ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚ್ಯಾ ಎಳಾರ್ ಲೊಕಾನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಎಕ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಸೊಡುನ್ ದಿತಲಿ ರೊಮಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಚಿ ಎಕ್ ಪದ್ದತ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ತ್ಯಾ ಎಳಾರ್ ಸಗ್ಳ್ಯಾಕ್ನಿ ಗೊತ್ತ್ ಹೊತ್ತೊ ಬಾರಾಬ್ಬಾಸ್ ಮನ್ತಲೊ ಎಕ್ ಮಾನುಸ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ತೆಚೆಸಾಟ್ನಿ ಲೊಕಾ ಥೈ ಜಮಾ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಪಿಲಾತಾನ್ ತೆಂಕಾ, “ತುಮ್ಚ್ಯಾಸಾಟ್ನಿ ಮಿಯಾ ಕೊನಾಕ್ ಸೊಡುನ್ ದಿವ್ಚೆ? ಬಾರಾಬ್ಬಾಸಾಕ್ ಕಾಯ್ ಕ್ರಿಸ್ತ್ ಮನ್ತಲ್ಯಾ ಜೆಜುಕ್ ಸೊಡುನ್ ದಿವ್ಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಕುಸ್ಡೆಪಾನಾನಿ ಜೆಜುಕ್ ಧರುನ್ ಹಾನಲ್ಲ್ಯಾನಿ ಮನುನ್ ಪಿಲಾತಾಕ್ ಗೊತ್ತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ಪಿಲಾತ್ ನ್ಯಾಯ್‍ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಬಸಲ್ಲೊ ಹೊತ್ತೊ ತನ್ನಾ ತೆಚ್ಯಾ ಬಾಯ್ಕೊನ್,“ತಿಯಾ ತ್ಯಾ ಚುಕೆತ್ ನಸಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಕಾಯ್ಬಿ ಕರುಕ್ ಜಾವ್‍ನಕೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ರಾತ್ತಿ ಸಪ್ನಾತ್ ಮಿಯಾ ಹೆಚ್ಯಾ ಬದಲ್ ಲೈ ಕಾಯ್ ಕಾಯ್‍ಕಿ ಸೊಸ್ಲಾ” ಮನುನ್ ಖಬರ್ ಧಾಡುನ್ ದಿಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ಹಿಕ್ಡಿ ಮುಖ್ಯ ಯಾಜಕಾನಿ ಅನಿ ಜಾನ್ತ್ಯಾನಿ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್, ಬಾರಾಬ್ಬಾಸಾಕ್ ಸೊಡ್ ಅನಿ ಜೆಜುಕ್ ಕುರ್ಸಾರ್ ಮಾರ್ ಮನುನ್ ಪಿಲಾತಾಕ್ಡೆ ಮಾಗಾ ಮನುನ್ ಸಾಂಗುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ಖರೆ ಪಿಲಾತಾನ್ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್, “ಹ್ಯಾ ದೊಗ್ಯಾನಿತ್ಲ್ಯಾ ಕೊನಾಕ್ ತುಮ್ಚ್ಯಾಸಾಟ್ನಿ ಸೊಡುನ್ ದಿವ್ಚೆ ಮನ್ತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ, “ಬಾರಾಬ್ಬಾಸಾಕ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ತನ್ನಾ ಪಿಲಾತಾನ್,“ತಸೆ ಜಾಲ್ಯಾರ್ ಕ್ರಿಸ್ತ್ ಮನ್ತಲ್ಯಾ ಹ್ಯಾ ಜೆಜುಕ್ ಮಿಯಾ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ತೆಂಕಾ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ಸಗ್ಳ್ಯಾನಿ,“ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್!” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ಖರೆ ಪಿಲಾತಾನ್,“ತೆನಿ ಕಾಯ್ ಚುಕ್ ಕರ್‍ಲ್ಯಾನಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ಜೊರಾನಿ “ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ಹೆ ಬಗುನ್ ಪಿಲಾತಾನ್ ಅನಿ ಫಿಡೆ ಬೊಲುನ್ ಉಪ್‌ಯೊಗ್ ನಾ, ಬೊಲ್ಲ್ಯಾರ್ ಡಂಗೊ ಉಟ್ಲ್ಯಾರ್‍ಬಿ ಉಟ್ಲೊ ಮನುನ್ ಯವ್ಜುನ್, ತೆನಿ ಉಲ್ಲೆ ಪಾನಿ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಇದ್ರಾಕ್ ಅಪ್ನಾಚಿ ಹಾತಾ ಧುವ್ನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ, “ಹ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಮರ್‍ನಾಕ್ ಮಿಯಾ ಕಾರನ್ ನ್ಹಯ್! ತುಮಿಚ್ ತೆ ಬಗುನ್ ಘೆವಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ತನ್ನಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ,“ಹೆಚ್ಯಾ ಮರ್‍ನಾಚಿ ಜವಾಬ್ದಾರಿ ಅಮ್ಚ್ಯಾ ವರ್‍ತಿ ಅನಿ ಅಮ್ಚ್ಯಾ ಪೊರಾಂಚ್ಯಾ ವರ್‍ತಿ ಪಡುಂದಿತ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ತನ್ನಾ ಪಿಲಾತಾನ್ ಲೊಕಾಂಚ್ಯಾ ಮನಾ ಸರ್ಕೆ ಬಾರಾಬ್ಬಾಸಾಕ್ ಸೊಡುನ್ ದಿಲ್ಯಾನ್, ಅನಿ ಜೆಜುಕ್ ಬಾರ್‍ಕೊಲಾನಿ ಮಾರುಕ್ ಲಾವುನ್ ಕುರ್ಸಾರ್ ಮಾರುಕ್ ಮನುನ್ ಒಪ್ಸುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ತನ್ನಾ ಪಿಲಾತಾಚ್ಯಾ ಸೈನಿಕಾನಿ ಜೆಜುಕ್ ಪಿಲಾತಾಚ್ಯಾ ಘರಾತ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ, ಸೈನಿಕಾಂಚೊ ಸಗ್ಳೊ ತಾಂಡೊ ತೆಚ್ಯಾ ಭೊತ್ಯಾನಿ ಗೊಳಾ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ತೆನಿ ಜೆಜುಚೆ ಕಪ್ಡೆ ವೊಡುನ್ ಕಾಡ್ಲ್ಯಾನಿ ಅನಿ ತೆಕಾ ತಾಂಬ್ಡೊ ಗುಂಜ್ಲೊ ಎಕ್ ಝಗೊ ನೆಸ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ತನ್ನಾ ತೆನಿ ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಎಕ್ ಕಿರಿಟ್ ಕರುನ್ ತೆಚ್ಯಾ ಟಕ್ಲ್ಯಾ ವರ್‍ತಿ ಘಾಟ್ಲ್ಯಾನಿ. ಅನಿ ತೆಚ್ಯಾ ಉಜ್ವ್ಯಾ ಹಾತಿತ್ ಎಕ್ ದಾಂಡೊ ದಿಲ್ಯಾನಿ. ಅನಿ ತೆಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಡಿಂಬಿಯಾ ಘಾಲುನ್, “ಜುದೆವಾಂಚ್ಯಾ ರಾಜಾಕ್ ಜೈ ಹೊಂವ್ದಿ!” ಮನುನ್ ಎಡ್ಸಡುನ್ ದಾಕ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ತೆನಿ ತೆಚ್ಯಾ ತೊಂಡಾರ್ ಥುಕ್ಲ್ಯಾನಿ ಅನಿ ಖಾಟಿ ಘೆವ್ನ್ ತೆಚೆ ಟಕ್ಲೆ-ಟಕ್ಲೆ ಧರುನ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ತೆಂಚೆ ಎಡ್ಸಡುನ್ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ತೆಕಾ ನೆಸ್ವಲ್ಲೊ ತಾಂಬ್ಡೊ ಝಗೊ ವೊಡುನ್ ಕಾಡ್ಲ್ಯಾನಿ ಅನಿ ತೆಚೆ ಅದ್ದಿಚೆಚ್ ಕಪ್ಡೆ ತೆಕಾ ನೆಸ್ವುಲ್ಯಾನಿ. ಮಾನಾ ತೆನಿ ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರುಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ತೆನಿ ಶಾರಾತ್ನಾ ಭಾಯ್ರ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಸಿರೆನ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಚೊ ಸಿಮಾವ್ ಮನ್ತಲೊ ಎಕ್ ಮಾನುಸ್ ತೆಂಕಾ ಗಾವ್ಲೊ. ಸೈನಿಕಾನಿ ತೆಕಾ ‍ಜಬರ್‍ದಸ್ತಿನಿ ಜೆಜುಚೊ ಕುರಿಸ್ ವಾವುನ್ ನ್ಹೆವ್ಕ್ ಲಾವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ಅಶೆ ತೆನಿ ಗೊಲ್ಗೊಥಾ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಯೆವ್ನ್ ಪಾವ್ಲೆ, ಗೊಲ್ಗೊಥಾ ತಸೆ ಮಟ್ಲ್ಯಾರ್, ಬುರ್‍ಡ್ಯಾಚೊ ಜಾಗೊ ಮನುನ್ ಅರ್ತ್‍. ");
INSERT INTO kans_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ಥೈ ತೆನಿ ಜೆಜುಕ್ ಕೊಡು ಮಿಸಳಲ್ಲಿ ವಾಯ್ನ್ ಫಿವ್ಕ್ ದಿಲ್ಯಾನಿ, ಖರೆ ತಿ ಚಾಟುನ್ ರುಚಿ ಬಗಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ ತಿ ವಾಯ್ನ್ ಫಿವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ಮಾನಾ ತೆನಿ ತೆಕಾ ಕುರ್ಸಾ ವರ್‍ತಿ ಮಾರ್‍ಲ್ಯಾನಿ ಅನಿ ಚಿಟಿಯಾ ಘಾಲುನ್ ತೆಚೆ ಕಪ್ಡೆ ತೆನಿ ವಾಟುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ಮಾನಾ ತೆನಿ ಥೈಚ್ ಬಸುನ್ ತೆಕಾ ರಾಕ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ತೆಚ್ಯಾ ಟಕ್ಲ್ಯಾಚ್ಯಾ ವೈಲ್ಯಾ ಬಾಜುಕ್ ತೆಚೊ ಅಪ್ವಾದ್ ಮನುನ್ , “ಹ್ಯೊ ಜೆಜು ಜುದೆವಾಂಚೊ ರಾಜಾ” ಮನುನ್ ಲಿವ್ನ್ ಲಾವಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ಮಾನಾ ತೆನಿ ದೊನ್ ಚೊರಾಕ್ನಿ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಕುರ್ಸಾರ್ ಮಾರ್‍ಲ್ಯಾನಿ ಎಕ್ಲ್ಯಾಕ್ ತೆಚ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಅನಿ ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ತೆಚ್ಯಾ ಡಾವ್ಯಾ ಬಾಜುಕ್. ");
INSERT INTO kans_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ಥೈತ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಜಾತಲ್ಯಾ ಲೊಕಾನಿ ಜೆಜುಕ್ ಎಡ್ಸಡುನ್ಗೆತ್ ಟಕ್ಲೆ ಹಾಲ್ವುನ್: ");
INSERT INTO kans_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ತಿಯಾ ದೆವಾಚಿ ಗುಡಿ ಮೊಡುನ್ ತಿನ್ ದಿಸಾತ್ನಿ ಮಟ್ಲ್ಯಾರ್ ಭಾಂದ್‍ನಾರ್ ಹೊತ್ತೆ ನ್ಹಯ್! ತಿಯಾ ದೆವಾಚೊ ಲೆಕ್ ರ್‍ಹಾಲ್ಯಾರ್ ತುಕಾಚ್ ಹುರ್‍ವುನ್ ಘೆ! ಕುರ್ಸಾ ವೈನಾ ಉತ್ರುನ್ ಯೆ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ಮುಖ್ಯ ಯಾಜಕಾನಿ, ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನಿ ಅನಿ ಜಾನ್ತ್ಯಾ ಲೊಕಾನಿಬಿ ಅಸೆಚ್ ಜೆಜುಕ್ ಎಡ್ಸಡ್ಲ್ಯಾನಿ: ");
INSERT INTO kans_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ತೆನಿ ದುಸ್ರ್ಯಾಕ್ನಿ ಹುರ್‍ವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಖರೆ ಅತ್ತಾ ಅಪ್ನಾಕುಚ್ ಹುರ್‍ವುನ್ ಘೆವ್ಕ್ ತೆಕಾ ಹೊಯ್ನಾ ಹೊಲಾ! ಇಸ್ರಾಯೆಲಾಚೊ ರಾಜಾ ನ್ಹಯ್ ಹ್ಯೊ? ತೊ ಕುರ್ಸಾ ವೈನಾ ಉತ್ರುನ್ ಯೆಲ್ಯಾರ್, ಅಮಿ ತೆಚ್ಯಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾವ್! ");
INSERT INTO kans_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ತೊ ದೆವಾ ವರ್‍ತಿ ಹೊಂದುನ್ ರ್‍ಹಾತಾ ಅನಿ ಅಪ್ನಿಚ್ ದೆವಾಚೊ ಲೆಕ್ ಮನುನ್ ಘೆತಾ. ತಸೆಹೊಲ್ಯಾರ್ ದೆವ್ ಯೆವ್ನ್ ತೆಕಾ ಅತ್ತಾ ಹುರ್‍ವುತಾ ಕಾಯ್ ಮನುನ್ ಅಮಿಬಿ ಬಗ್ತಾವ್‍!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ತೆಚ್ಯಾ ಅಜು-ಬಾಜುಕ್ ಕುರ್ಸಾರ್ ಮಾರಲ್ಲ್ಯಾ ಚೊರಾನಿಬಿ ತೆಕಾ ತಸೆಚ್ ಮನುನ್ ಎಡ್ಸಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ಅತ್ತಾ ದೊಪಾರ್ ಹೊಲ್ಲಿ. ಖರೆ ಬಾರಾ ಘಂಟ್ಯಾಕ್ನಾ ತಿನ್ ಘಂಟ್ಯಾ ಪತರ್ ಸಗ್ಳ್ಯಾ ದೆಶಾತ್ ಕಾಳೊಕ್ ಪಡಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ಸುಮಾರ್ ತಿನ್ ಘಂಟ್ಯಾಕ್ ಜೆಜುನ್,“ಎಲಿ ಎಲಿ ಲಾಮಾ ಸಬಾಕ್ತಾನಿ?” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್. ತಸೆಮಟ್ಲ್ಯಾರ್, ಮಾಜ್ಯಾ ದೆವಾ, ಮಾಜ್ಯಾ ದೆವಾ ತಿಯಾ ಮಾಕಾ ಕಶ್ಯಾಕ್ ಇಸರ್‍ಲೆ? ಮನುನ್ ಅರ್ತ್‍. ");
INSERT INTO kans_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾ ಉಲ್ಲ್ಯಾನಿ ಹೆ ಆಯ್ಕುನ್, “ತೊ ಎಲಿಯಾಕ್ ಬಲ್ವುಲಾ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ತನ್ನಾ ತೆಂಚ್ಯಾತ್ಲೊ ಎಕ್ಲೊ ತಾಬೊಡ್ತೊಬ್ ಪಳುನ್ ಗೆಲೊ ಅನಿ ಎಕ್ ನಮುನ್ಯಾಚೆ ಕಾಪುಸ್ ಸರ್ಕೆ ಘೆವ್ನ್ ಅಂಬೊಟ್ಲ್ಯಾ ವಾಯ್ನಾತ್ ಬುಡ್ವುಲ್ಯಾನ್ ಅನಿ ಝೆಲ್ಲೆಕ್ ಲಾವುನ್ ಜೆಜುಕ್ ತೆ ಪಾಜ್ವುಕ್ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ಖರೆ ಅನಿ ಹುರಲ್ಲ್ಯಾ ಲೊಕಾನಿ, “ರ್‍ಹಾಮಾ, ಎಲಿಯಾ ತೆಕಾ ಹುರ್‍ವುಕ್ ಯೆತಾ ಕಾಯ್ ಬಗುವಾ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ತನ್ನಾ ಜೆಜುನ್ ಅನಿಎಗ್ದಾ ಮೊಟ್ಯಾನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್ ಅನಿ ಜಿವ್ ಸೊಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ತನ್ನಾ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಭಾಂದಲ್ಲೊ ಫಡ್ದೊ ವೈನಾ ಖಾಯ್ಲ್ ಪತರ್ ಪಿಂಜುನ್ ದೊನ್ ಭಾಗ್ ಹೊಲೊ. ಸಗ್ಳಿ ಜಿಮಿನ್ ಹಾಲ್ಲಿ ಅನಿ ಮೊಟ್ಯಾ-ಮೊಟ್ಯಾ ಗುಂಡ್ಯಾಕ್ನಿ ಬಿರ್‍ಕಾ ಪಡ್ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ಸಾರಿಯಾ ಫುಟುನ್ ಉಗಡ್ಲ್ಯಾ, ಅನಿ ಸುಮಾರ್ ಮರಲ್ಲಿ ದೆವಾಚಿ ಲೊಕಾ ಝಿತ್ತಿ ಹೊವ್ನ್ ಉಟ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ಜೆಜು ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟಲ್ಲ್ಯಾ ತೆನಿ ತೆಂಕಾ ಮಾಟಿ ದಿಲ್ಲ್ಯಾ ಸಾರಿಯಾ ಸೊಡುನ್ ಉಟ್ಲ್ಯಾನಿ ಅನಿ ಪವಿತ್ರ್ ಶಾರಾಕ್ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲ್ಯಾನಿ. ಥೈ ಸುಮಾರ್ ಲೊಕಾನಿ ತೆಂಕಾ ಬಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ಜೆಜುಕ್ ರಾಕುಕ್ ಮನುನ್ ಹೊತ್ತ್ಯಾ ಸೈನಿಕಾನಿ ಅನಿ ಸೆಂಬರ್ ಸೈನಿಕಾಂಚ್ಯಾ ಮುಖಂಡಾನ್ ಭುಕಂಪ್ ಹೊಲ್ಲೆ ಅನಿ ಥೈ ಕಾಯ್ ಕಾಯ್ ಹೊಲ್ಲೆ ಸಗ್ಳೆ ಬಗಟ್ಲ್ಯಾನಿ, ತೆನಿ ಭಿಂವ್ನ್ ಗೆಲ್ಯಾನಿ, ಅನಿ, “ಖರೆಚ್ ತೊ ದೆವಾಚೊ ಲೆಕ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ಥೈ ಸುಮಾರ್ ಬಾಯ್ಕಾಮಾನ್ಸಾಬಿ ಹೊತ್ತ್ಯಾ ತೆನಿ ಗಾಲಿಲಿಯಾತ್ನಾ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಯೆಲ್ಲ್ಯಾನಿ ಅನಿ ಜೆಜುಕ್ ಮಜತ್ ಕರಲ್ಲ್ಯಾನಿ. ತೆನಿ ಹೆ ಸಗ್ಳೆ ಧುರ್‍ನಾಚ್ ಬಗುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ತೆಂಚ್ಯಾ ಮದ್ದಿ, ಮರಿ ಮಾಗ್ದೆಲಿನ್, ಜಾಕೊಬ್ ಅನಿ ಜುಜೆಚಿ ಬಾಯ್ ಮರಿ, ಅನಿ ಜೆಬೆದೆವ್ ಮನ್ತಲ್ಯಾಚಿ ಬಾಯ್ಕೊ ಹೊತ್ತ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ಸಾಂಜ್ ಹೊವ್ನಗೆತ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಅರೆಮಾತಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಚೊ ಎಕ್ ಸಾವ್ಕಾರ್ ಮಾನುಸ್ ಥೈ ಯೆಲೊ, ತೆಚೆ ನಾವ್ ಜುಜೆ. ಅನಿ ತೊ ಎಕ್ ಜೆಜುಚೊ ಶಿಸ್ ಹೊವ್ನ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ತೊ ಪಿಲಾತಾಕ್ಡೆ ಗೆಲೊ ಅನಿ ಜೆಜುಚೆ ಮಡೆ ಇಚಾರುನ್ ಘೆಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಪಿಲಾತಾನ್ ಜೆಜುಚೆ ಮಡೆ ಜುಜೆಕ್ ದಿವ್ಕ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ತನ್ನಾ ಜುಜೆನ್ ಜೆಜುಚೆ ಮಡೆ ಕಾಡುನ್ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ಎಕ್ ನ್ಹವ್ಯಾ ಲೈ ಕಿಮ್ತಿಚ್ಯಾ ಕಪ್ಡ್ಯಾತ್ ಲಪಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ಅನಿ ತನ್ನಾಚ್ ಎಕ್ ಗುಂಡ್ಯಾತ್ ಪೊಕರಲ್ಲ್ಯಾ ಅಪ್ನಾಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ನ್ಹವ್ಯಾ ಸಮಾದಿತ್ ನ್ಹೆವ್ನ್ ತೆ ಥವ್ಲ್ಯಾನ್. ಮಾನಾ ತೆನಿ ತ್ಯಾ ಸಮಾದಿಚ್ಯಾ ದಾರಾರ್ ಎಕ್ ಮೊಟೊ ಗುಂಡೊ ಲೊಟುನ್ ಧಾಪುನ್ ಅನಿ ತೊ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ಮರಿ ಮಾಗ್ದೆಲಿನಾ ಅನಿ ತಿ ಅನಿ ಎಕ್ಲಿ ಮರಿ ಥೈಚ್ ಸಮಾದಿಕ್ಡೆ ಬಗುನ್ಗೆತ್ ಬಸಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ದುಸ್ರೆಂದಿಸಿ. ಆರಾಮಾಚೊ ದಿಸ್ ಹೊತ್ತೊ. ಮುಖ್ಯ ಯಾಜಕಾ ಅನಿ ಫಾರಿಜೆವಾ ಪಿಲಾತಾಕ್ ಭೆಟ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ಅನಿ, “ಸಾಯ್ಬಾನು, ಅಮ್ಕಾ ಯಾದ್ ಹಾಯ್ ತೊ ಝುಟೊ ಮಾನುಸ್ ಝಿತ್ತೊ ರ್‍ಹಾತಾನಾ, ತಿನ್ ದಿಸಾಂಚ್ಯಾ ಮಾನಾ ಮಿಯಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆತಾ.” ಮನುನ್ ಸಾಂಗಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ತಸೆಮನುನ್ ತಿನ್ ದಿಸಾ ಪತರ್ ತೆಚ್ಯಾ ಸಮಾದಿಕ್ ರಾಕುಕ್ ಹುಕುಮ್ ಅಮ್ಕಾ ದಿವಾ. ತೆಚಿ ಶಿಸಾ-ಗಿಸಾ ಜಾವ್ನ್ ತೆಚೆ ಮಡೆ ಚೊರುನ್ ಘೆವ್ನ್ ಜಾತಿಲ್ ಅನಿ ಲೊಕಾಕ್ನಿ ತೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟ್ಲಾ ಮನುನ್ ಸಾಂಗ್ತಿಲ್. ಹಿ ಝುಟಿ ಖಬರ್ ಪಯ್ಲೆಚ್ಯಾ ಖಬ್ರೆಚ್ಯಾನ್ಕಿ ಜಾಸ್ತಿಚಿ ಮೊಟಿ ಝುಟಿ ಖಬರ್ ಹೊತಲಿ ನಕ್ಕೊ. ಮನುನ್ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ತನ್ನಾ ಪಿಲಾತಾನ್, “ರಾಕ್ವಾಲ್ಯಾಕ್ನಿ ಘೆವಾ ಅನಿ ತುಮ್ಕಾ ಕಶೆ ಪಾಜೆ ತಸೆ ಸಮಾದಿಚಿ ರಾಕನ್ ಕರಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ಅಶೆ ತೆನಿ ಗೆಲ್ಯಾನಿ ಅನಿ ಸಮಾದಿ ರಾಕುಸಾಟ್ನಿ ತಿಚ್ಯಾ ದಾರಾಕ್ ಹೊತ್ತ್ಯಾ ಗುಂಡ್ಯಾಕ್ ಬಂದೊಬಸ್ತ್ ಕರ್‍ಲ್ಯಾನಿ ಅನಿ ಸಮಾದಿ ರಾಕುಕ್ ರಾಕ್ವಾಲ್ಯಾಕ್ನಿ ಥವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ಜುದೆವಾಂಚೊ ಆರಾಮಾಚೊ ದಿಸ್ ಸರಲ್ಲ್ಯಾ ಮಾನಾ ಮಟ್ಲ್ಯಾರ್ ಆಯ್ತಾರ್‍ಚೆ ಸಕ್ಕಾಳಿ ನಸ್ಕಾತ್ ಮರಿ ಮಾಗ್ದೆಲಿನ್ ಅನಿ ದುಸ್ರಿ ಅನಿ ಎಕ್ಲಿ ಮರಿ ಸಮಾದಿತ್ ಬಗುಕ್ ಮನುನ್ ಯೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ತನ್ನಾ ಎಗ್ದಮ್ ಮೊಟೆ ಭುಕಂಪ್ ಹೊಲೆ; ಧನಿಯಾಚೊ ಎಕ್ ದುತ್ ಸರ್‍ಗಾ ವೈನಾ ಉತ್ರುನ್ ಯೆಲೊ, ಸಮಾದಿಚ್ಯಾ ದಾರಾರ್ ಹೊತ್ತ್ಯಾ ಗುಂಡ್ಯಾಕ್ ಕಡೆಕ್ ಗುಳ್ವುನ್ ತೆಚೆ ವರ್‍ತಿ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ತೆಚೆ ತೊಂಡ್ ಮಿಂಚಾ ಸರ್ಕೆ ದಿಸಿ ಅನಿ ತೆಚೆ ಕಪ್ಡೆ ಭರ್‍ಪಾಚ್ಯಾ ಸರ್ಕೆ ಫಾಂಡ್ರೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ರಾಕ್ವಾಲಿ ಭಿಂಯಾಲೆ ಅನಿ ಮರಲ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊವ್ನ್ ಪಡ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ತನ್ನಾ ದೆವಾಚ್ಯಾ ದೆವ್‍ದುತಾ ತ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾಕ್ನಿ, ತುಮಿ ಭಿಂಯಾತಲಿ ಗರಜ್ ನಾ, ತುಮಿ ಕುರ್ಸಾ ವರ್‍ತಿ ಮಾರಲ್ಲ್ಯಾ ಜೆಜುಕ್ ಹುಡ್ಕುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ತೊ ಹಿತ್ತೆ ನಾ, ತೊ ಅಪ್ನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಮರಲ್ಲೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟ್ಲಾ. ಹಿತ್ತೆ ಯೆವ್ನ್ ತೆಚೆ ಮಡೆ ಥವಲ್ಲೊ ಜಾಗೊ ಬಗಾ ಯೆವಾ. ");
INSERT INTO kans_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ಅತ್ತಾ ಲಗ್ಗುನಾ ಜಾವಾ ಅನಿ ತೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ತೊ ಮರಲ್ಲೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟ್ಲಾ ಮನುನ್ ಸಾಂಗಾ, ಅನಿ ತೊ ಅತ್ತಾ ತುಮ್ಚ್ಯಾನ್ಕಿ ಅದ್ದಿ ಗಾಲಿಲಿಯಾಕ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ; ಥೈ ತುಮಿ ತೆಕಾ ಬಗ್ತ್ಯಾಶಿ! ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗಲ್ಲೆ ಯಾದ್ ಥವ್ನ್ ಘೆವಾ. ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ತನ್ನಾ ತೆನಿ ಗಡ್ಬಡಿನ್ ಭಿಂವ್ನಗೆತ್ ಅನಿ ಉಲ್ಲೆ ಕುಶಿ ಹೊವ್ನ್ ತೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಹಿ ಖಬರ್ ಸಾಂಗುಕ್ ಸಮಾದಿಕ್ನಾ ಪಳುನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ತನ್ನಾ ಎಗ್ದಮ್ ಜೆಜು ತೆಂಕಾ ಭೆಟ್ಲೊ, ಅನಿ,“ಶಾಂತಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಂವ್ದಿತ್” ಮಟ್ಲ್ಯಾನ್. ತೆನಿ ತೆಚ್ಯಾ ಪತರ್ ಯೆಲ್ಯಾನಿ. ತೆಚೆ ಪಾಯ್ ಧರ್‍ಲ್ಯಾನಿ ಅನಿ ತೆಚ್ಯಾ ಆರಾದನ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ಜೆಜುನ್ ತೆಂಕಾ,“ಭಿಂವ್‌ನಕಾಶಿ, ಜಾವಾ ಅನಿ ಮಾಜ್ಯಾ ಭಾವಾಕ್ನಿ ಗಾಲಿಲಿಯಾಕ್ ಜಾವಾ ಮನುನ್ ಸಾಂಗಾ. ಥೈ ತೆಂಕಾ ಮಿಯಾ ಬಗುಕ್ ಗಾವ್ತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ತ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಸಮಾದಿ ರಾಕುಕ್ ಹೊತ್ತ್ಯಾ ರಾಕ್ವಾಲ್ಯಾನಿತ್ಲೆ ಉಲ್ಲೆ ಜಾನಾ ಶಾರಾತ್ ಗೆಲೆ ಅನಿ ಹಿತ್ತೆ ಚಲಲ್ಲೆ ಸಗ್ಳೆ ಮುಖ್ಯ ಯಾಜಕಾಕ್ನಿ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ಯಾಜಕಾಂಚಿ ಮುಖಂಡಾ ಜುದೆವಾಂಚ್ಯಾ ಜಾನ್ತ್ಯಾಕ್ನಿ ಜಾವ್ನ್ ಭೆಟ್ಲ್ಯಾನಿ ಅನಿ ತೆನಿ ವಾಂಗ್ಡಾ ಮಿಳುನ್ ಎಕ್ ಉಪಾಯ್ ಕರ್‍ಲ್ಯಾನಿ; ತೆನಿ ರಾಕ್ವಾಲ್ಯಾಕ್ನಿ ಭರ್‍ಪುರ್ ಪೈಸೆ ದಿಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ಅನಿ ತೆಂಕಾ,“ ತುಮಿ ಅಮಿ ರಾಚ್ಚೆ ನಿಜಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಚ್ಯಾ‍ ಶಿಸಾನಿ ಯೆವ್ನ್ ತೆಚೆ ಮಡೆ ಚೊರುನ್ ನ್ಹೆಲ್ಯಾನಿ ಮನುನ್ ಸಾಂಗುಚೆ. ");
INSERT INTO kans_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ಹಿ ಖಬರ್ ದೆಸಾಚ್ಯಾ ಮೊಟ್ಯಾ ಅದಿಕಾರ್‍ಯಾಚ್ಯಾ ಕಾನಾತ್ ಪಡ್ಲಿ ತರ್, ಹ್ಯಾತುರ್ ತುಮ್ಚಿ ಕಾಯ್ ಚುಕ್ ನಾ ಮನುನ್ ಅಮಿ ತೆಕಾ ಸಮಾದಾನ್ ಕರ್‍ತಾವ್. ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ತುಮ್ಕಾ ಟಕ್ಲೆ ನಾಸ್ವುನ್ ಘೆವ್ಚೆ ಮನುನ್ ನಾ.” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ತ್ಯಾ ರಾಕ್ವಾಲ್ಯಾನಿ ತೆ ಪೈಸೆ ಘೆಟ್ಲ್ಯಾನಿ ಅನಿ ತೆನಿ ತೆಂಕಾ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ಕರ್‍ಲ್ಯಾನಿ. ತೆಚೆಸಾಟ್ನಿಚ್ ಅಜುನ್‍ಬಿ ಜುದೆವ್ ಲೊಕಾ ಹಿಚ್ ಖಬರ್ ಖರಿ ಮನುನ್ ಮಾನುನ್ ಘೆತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ಅತ್ತಾ ಅಕ್ರಾ ಜಾನಾ ಶಿಸಾ ಗಾಲಿಲಿಯಾಕ್ ಜೆಜುನ್ ಯೆವ್ಕ್ ಸಾಂಗಲ್ಲ್ಯಾ ಮಡ್ಡಿ ವರ್‍ತಿ ಯೆವ್ನ್ ಪಾವ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ಥೈ ಜೆಜುಕ್ ಬಗುನ್ ತೆನಿ ತೆಚೆ ಆರಾದನ್ ಕರ್‍ಲ್ಯಾನಿ. ಖರೆ ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಉಲ್ಲೊ ಸಂಶೆವ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ತನ್ನಾ ಜೆಜುನ್ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್, “ಸಗ್ಳ್ಯಾ ಸರ್‍ಗಾ ವರ್‍ತಿ ಅನಿ ಜಿಮ್ನಿ ವರ್‍ತಿ ಸಗ್ಳೊ ಅದಿಕಾರ್ ಮಾಕಾ ದಿಲ್ಲೊ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ತಸೆಮನುನ್ ತುಮಿ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಸಗ್ಳ್ಯಾ ದೆಸಾಂಚ್ಯಾ ಲೊಕಾನಿಕ್ನಿ ಜಾವಾ ಅನಿ ತೆಂಕಾ ಮಾಜಿ ಶಿಸಾ ಕರಾ: ಅನಿ ತೆಂಕಾ ಬಾಬಾಚ್ಯಾ ಲೆಕಾಚ್ಯಾ ಅನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚ್ಯಾ ನಾವಾನ್ ಬಾಲ್ತಿಮ್ ದಿವಾ. ");
INSERT INTO kans_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ಅನಿ ತೆಂಕಾ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಚಲುಕ್ ಶಿಕ್ವಾ, ಕನ್ನಾಬಿ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಂವ್. ಹ್ಯಾ ಜಗಾಚ್ಯಾ ಅಕ್ರಿ ಪತರ್‍ಬಿ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾತಾ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್.");
INSERT INTO kans_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ದೆವಾಚ್ಯಾ ಲೆಕಾಚಿ, ಜೆಜು ಕ್ರಿಸ್ತಾಚಿ ಬರಿ ಖಬರ್ ಹಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾನ್ ಲಿವಲ್ಲ್ಯಾಸರ್ಕಿ ಅಸೆ ಚಾಲು ಹೊತಾ. “ದೆವ್ ಮನ್ತಾ ‘ಅಬಕ್!’ ಮಿಯಾ ಮಾಜಿ ಖಬರ್ ಸಾಂಗ್ತಲ್ಯಾಕ್ ತುಜೆನ್ಕಿ ಅದ್ದಿ ಧಾಡುನ್ ದಿತಾ, ಅನಿ ತೊ ತುಜಿ ವಾಟ್ ತಯಾರ್ ಕರ್‍ತಾ” ");
INSERT INTO kans_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ಧನಿಯಾಕ್ ಎಕ್ ವಾಟ್ ತಯಾರ್ ಕರಾ, ತೆಕಾ ಯೆವ್ಕ್ ವಾಟ್ ನಿಟ್ ಕರಾ!. ಅಶೆ ಮನುನ್‍ ಡಂಗ್ಳಿತ್ ಎಕ್ ಮಾನುಸ್ ಬೊಬ್ ಮಾರ್‍ತಲೆ ಆಯ್ಕೊ ಯೆತಾ! ಮನುನ್ ");
INSERT INTO kans_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾನ್ ಅಪ್ನಾಚ್ಯಾ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲ್ಯಾ ಬಾಸೆನ್. ಜುವಾಂವ್ ಎಕ್ ಮರುಭುಮಿತ್ ದಿಸುನ್ “ತುಮ್ಚೆ ಪಾಪಾಚೆ ಜಿವನ್ ಬದ್ಲಾ ಅನಿ ಬಾಲ್ತಿಮ್ ಘೆವಾ, ಅನಿ ದೆವ್ ತುಮ್ಚೆ ಪಾಪ್ ಮಾಪ್ ಕರ್‍ತಾ” ಮನುನ್ ಲೊಕಾಕ್ನಿ ಸಾಂಗುನ್ಗೆತ್ ಬಾಲ್ತಿಮ್ ದಿವ್ಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ಜುದೆಯಾ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾಚ್ಯಾ ಸಾಂದಿ-ಮುಲ್ಲ್ಯಾನಿತ್ನಾ, ಅನಿ ಜೆರುಜಲೆಮಾತ್ನಾ ಲೈ ಲೊಕಾ ಜುವಾಂವಾಕ್ಡೆ ಯೆವ್ನ್, ಅಪ್ನಾಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಚುಕಾ ಒಳ್ಕುನ್ ಘೆವ್ನ್, ಜೊರ್ದಾನ್ ನ್ಹಯ್ತ್, ಜುಂವಾವಾಕ್ನಾ ಬಾಲ್ತಿಮ್‍ ಘೆವ್‍ಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ಜುವಾಂವ್ ಒಂಟೆಚ್ಯಾ ಕೆಸಾನಿ ಕರಲ್ಲ್ಯಾ ಫಾಳಿಯಾ ನೆಸಿ, ಅನಿ ಕಂಬ್ರೆಕ್ ಚಮ್ಡ್ಯಾಚೊ ಪಟ್ಟೊ ಲಪ್ಟುನ್ ಘೆಯ್, ಅನಿ ಟುಪ್ಪುನ್ಯಾ ಅನಿ ಮಾಂವ್ ಖಾವ್ನ್ ತೊ ಜಿವನ್ ಕರಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ಅನಿ ಮಾಜೆನ್ಕಿ ಲೈ ಬಳ್‍ಹೊತ್ತೊ, ಎಕ್ಲೊ ಯೆತಲೊ ಹಾಯ್. ಡೊಗ್ಲಾ ಘಾಲುನ್ ತೆಚ್ಯಾ ಪಾಂಯಾತ್ಲ್ಯಾ ವ್ಹಾನಾಂಚಿ ನಾಡಿ ಸೊಡ್ತಲಿ ಸೈತ್ ಮಾಜಿ ಮರ್ಯಾದ್‍ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ಮಿಯಾ ತುಮ್ಕಾ ಪಾನಿಯಾನ್ ಬಾಲ್ತಿಮ್ ದಿವ್ಲಾ, ಖರೆ, ತೊ ತುಮ್ಕಾ ದೆವಾಚ್ಯಾ ಅತ್ಮ್ಯಾನುಚ್ ಬಾಲ್ತಿಮ್ ದಿತಾ.\" ಮನುನ್ ಥೈ ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ತೊ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ತ್ಯಾ ದಿಸಾತ್ನಿ, ಎಕ್‍ ದಿಸ್ ಜೆಜು ಗಾಲಿಲಿಯಾ ಪ್ರಾಂತ್ಯಾತ್ಲ್ಯಾ, ನಜರೆತ್ ಮನ್ತಲ್ಯಾ ಗಾವಾತ್ನಾ, ಜುವಾಂವ್ ಹೊತ್ತ್ಯಾಕಡೆ, ಯೆವ್ನ್ ಪಾವ್ಲೊ. ಜುವಾಂವಾಕ್, ಜೆಜುಕ್ ಜೊರ್ದಾನ್ ನ್ಹಯ್ತ್ ಬಾಲ್ತಿಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ಜೆಜು ಬಾಲ್ತಿಮ್ ಘೆವ್ನ್ ಪಾನಿಯಾತ್ನಾ ವೈರ್ ಇಬೆ ಹೊತ್ತ್ಯಾ ತನ್ನಾ, ಎಗ್ದಮ್ ಸರ್ಗ ಉಗ್ಡುನ್, ದೆವಾಚೊ ಆತ್ಮೊ ಪಾರಿವಾಳಾಚ್ಯಾ ರುಪಾರ್, ಅಪ್ನಾಚ್ಯಾ ವರ್‍ತಿ ಉತ್ರುನ್ ಯೆತಲೊ ಜೆಜುನ್ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ತನ್ನಾ ಸರ್ಗಾವೈನಾ “ತಿಯಾ ಮಾಜೊ ಲೈ ಅಪುರ್‍ಬಾಯೆಚೊ ಲೆಕ್. ಮಾಜ್ಯಾ ಮನಾ ಸರ್ಕೊ” ಮನುನ್ ಮನ್ತಲೊ ಎಕ್ ಧನ್ ಅಯ್ಕೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ತನ್ನಾಚ್ ದೆವಾಚ್ಯಾ ಆತ್ಮ್ಯಾನ್ ಜೆಜುಕ್ ಎಕ್ ಮರುಭುಮಿಕ್ ಜಾಯ್ ಸರ್ಕೆ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ಜೆಜು ಚಾಳಿಸ್ ದಿಸಾ, ತ್ಯಾ ಮರುಭುಮಿತ್ ಜಿವಾಕ್ ಅಪಾಯ್ ಕರ್‍ತಲ್ಯಾ ಜನಾವರಾಂಚ್ಯಾ ಮದ್ದಿ ರ್‍ಹಾಲೊ, ಥೈ ಸೈತಾನ್ ಜೆಜುಕ್ ಪಾಪ್ ಕರಿ ಸರ್ಕೆ ಕರುಕ್ ಕಸ್ರತ್ ಕರ್‍ತಾ. ಖರೆ, ಸೈತಾನಾಕ್ ಜೆಜುನ್ ಪಾಪ್ ಕರಿ ಸರ್ಕೆ ಕರುಕ್ ಹೊವುಕ್ನಾ. ಮಾನಾ ದೆವಾಚ್ಯಾದುತಾನಿ ಯೆವ್ನ್ ಜೆಜುಚಿ ಸೆವಾ ಚಾಕ್ರಿ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ಜುವಾಂವಾಕ್‍ ಬಂಧಿಖಾನ್ಯಾತ್ ಘಾಟಲ್ಲ್ಯಾನಿ, ತನ್ನಾ ಜೆಜು ಗಾಲಿಲಿಯಾಕ್ ಬರಿ ಖಬರ್ ಪರ್‍ಚಾರ್ ಕರುಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ಅನಿ “ಎಳ್ ಯೆಲೊ,ದೆವಾಚೆ ರಾಜ್ ಜಗ್ಗೊಳ್ ಯೆಲಾ, ತುಮ್ಚೆ ಪಾಪ್ ಒಳ್ಕುನ್ ಘೆವಾ, ಅನಿ ದೆವಾಕ್ಡೆ ಫಾಟಿ ಪರ್ತಾ, ಅನಿ ದೆವಾಚ್ಯಾ ಬರ್ಯಾ ಖಬ್ರೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಾ” ಮನುನ್ ದೆವಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಲೊಕಾಕ್ನಿ ಸಾಂಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ಜೆಜು ಗಾಲಿಲಿಯಾ ಮನ್ತಲ್ಯಾ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆನ್ ಅಸೆಚ್ ಚಲುನ್ಗೆತ್ ಜವ್‍ಲಾಗಲ್ಲೊ. ಥೈ ಸಿಮಾವ್, ಅನಿ ತೆಚೊ ಧಾಕ್ಲೊ ಭಾವ್ ಅಂದ್ರು, ತೆಕಾ ದಿಸ್ಲೆ. ಹೆನಿ ಮಾಸೊಳ್ಯಾ ಧರ್ತಲಿ ಮಾನ್ಸಾ, ಮಾಸೊಳ್ಯಾ ಧರುಕ್ ಮನುನ್ ತೆನಿ ಸಮುಂದರಾತ್ ಜಾಳೆ ಸೊಡುಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ತನ್ನಾ ಜೆಜುನ್ “ತುಮಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆವಾ, ಮಿಯಾ ತುಮ್ಕಾ ಮಾನ್ಸಾಕ್ನಿ ದೆವಾಚಿ ಮಾನ್ಸಾ ಕರ್‍ತಲೆ ಕಶೆ ಮನುನ್ ಶಿಕ್ವುತಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ಹೆ ಅಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾಚ್, ಸಿಮಾವ್ ಅನಿ ಅಂದ್ರು, ಅಪ್ನಾಚಿ ಜಾಳಿ ಥೈಚ್ ಸೊಡುನ್ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ಜೆಜು ಥೈತ್ನಾ ಅನಿ ಉಲ್ಲೆ ಫಿಡೆ ಗೆಲೊ, ತನ್ನಾ ತೆಕಾ ಜೆಬೆದೆವಾಚಿ ಪೊರಾ, ಜಾಕೊಬ್ ಅನಿ ತೆಚೊ ಭಾವ್ ಜುವಾಂವ್ ದಿಸ್ಲೆ. ತೆನಿ ಢೊನಿತ್ ಬಸುನ್, ಅಪ್ಲಿ ಜಾಳಿ ಸಮಾ ಕರುಕ್ ಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ಜೆಜು ತೆನಿ ಢೊನಾತ್ ಹೊತ್ತ್ಯಾಕ್ಡೆ ಗೆಲೊ ಅನಿ “ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆವಾ” ಮನುನ್ ತೆಂಕಾ ಬಲ್ವುಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾಕ್ ಆಳಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಥೈಚ್ ಸೊಡ್ಲ್ಯಾನಿ, ಅನಿ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ ಕಪರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ ಗೆಲೆ. ಥೈ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ, ಜೆಜು ಎಕ್ ಸಿನಾಗೊಗಾತ್ ಗೆಲೊ, ಅನಿ ಲೊಕಾಕ್ನಿ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಶಿಕ್ವುಕ್‍ಲಾಲೊ ");
INSERT INTO kans_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ಜೆಜು ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ, ಎವ್ಡೆ ಬರೆ ಸಾಂಗ್ತಲೆ ಆಯ್ಕುನ್, ಲೊಕಾ ಅಜಾಪ್ ಹೊಲಿ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ತೆಂಚ್ಯಾ ಖಾಯ್ದೆ ಸಿಕ್ವುತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸರ್ಕೆ ಶಿಕ್ವಿನಸಿ, ಎಕ್ ಅದಿಕಾರ್ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾ ಸರ್ಕೆ ಶಿಕ್ವುಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ತನ್ನಾ ತ್ಯಾ ಸಿನಾಗೊಗಾತ್ ಗಿರೊಲಾಗಲ್ಲೊ ಎಕ್ ಮಾನುಸ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ಅನಿ ಜೆಜುಕ್ ಬಗುನ್ “ನಜರೆತಾಚ್ಯಾ ಜೆಜು! ತಿಯಾ ಅಮ್ಚ್ಯಾ ಖಬ್ರೆಕ್ ಕಶ್ಯಾಕ್ ಯೆಲೆ? ಅಮ್ಕಾ ನಾಸ್ ಕರುಕ್ ಮನುನ್ ಯೆಲೆ ಕಾಯ್? ತಿಯಾ ಕೊನ್ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್. ತಿಯಾ ದೆವಾಕ್ನಾ ಯೆಲ್ಲೊ ಎಕ್ಲೊ ಪವಿತ್ರ್” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ತನ್ನಾ ಜೆಜುನ್ “ಗಪ್ ರ್‍ಹಾ! ಅನಿ ತ್ಯಾ ಮಾನ್ಸಾತ್ನಾ ಭಾಯ್ರ್ ಯೆ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ತನ್ನಾ ತೊ ಗಿರೊ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ತಳ್ಮಳಿ ಸರ್ಕೆ ಕರುನ್, ಮೊಟ್ಯಾನಿ ಕಿಂಚುನ್ಗೆತ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಸೊಡುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ಸಗ್ಳಿ ಲೊಕಾ ಹೆ ಬಗುನ್ ಅಜಾಪ್ ಹೊಲಿ, ಅನಿ \" ಹೆ ಕಾಯ್? ಹ್ಯೊ ಮಾನುಸ್ ಅದಿಕಾರ್‍ಯಾನ್ ಭರಲ್ಲ್ಯಾ ನ್ಹವ್ಯಾಚ್ ರಿತಿನ್ ಶಿಕ್ವುತಾ! ಅನಿ ಗಿರೆ ಸೈತ್, ತೆನಿ ಸಾಂಗಟಲ್ಲೆ ಸಗ್ಳೆ ಆಯಿಕ್ತ್ಯಾತ್. ಮನುನ್ ಎಕಾಮೆಕಾಕ್ನಿ ಬೊಲುಕ್‍ಲಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ಜೆಜುಚಿ ಖಬರ್ ಗಾಲಿಲಿಯಾ ಪ್ರಾಂತ್ಯಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಜಾವ್ನ್ ಪಾವ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ, ಸಿನಾಗೊಗಾತ್ನಾ ಬಾಯ್ರ್ ಪನ್, ಸಿಮಾವ್ ಅನಿ ಅಂದ್ರುಚ್ಯಾ ಘರಾಕ್ ಗೆಲೆ. ಜಾಕೊಬ್ ಅನಿ ಜುವಾಂವ್ ಬಿ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ಸಿಮಾವಾಚಿ ಮಾಮಿ ತಾಪ್ ಯೆವ್ನ್ ಹಾತ್ರಾನಾತ್ ನಿಜಲ್ಲಿ, ಥೈ ಜಾವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾಚ್, ಲೊಕಾನಿ ಜೆಜುಕ್ ಹಿ ಖಬರ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ಜೆಜು, ತಿ ನಿಜಲ್ಲ್ಯಾಕ್ಡೆ ಗೆಲೊ, ಅನಿ ತಿಕಾ ಹಾತಾಕ್ ಧರುನ್ ಉಟ್ವುನ್ ಬಸ್ವುಲ್ಯಾನ್. ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತಿಚೊ ತಾಪ್ ಗೆಲೊ, ಅನಿ ತಿ ಉಟುನ್ ತೆಂಚಿ ಸೆವಾ ಕರುಕ್‍ ಲಾಗ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ತ್ಯಾ ದಿಸ್ ಸಾಂಜ್ ಹೊಂವ್ಗೆತ್ ಯೆತಾನಾ, ಥೈತ್ಲ್ಯಾ ಲೊಕಾನಿ, ಸಗ್ಳ್ಯಾ ಸಿಕ್ ಹೊತ್ತ್ಯಾಕ್ನಿ, ಅನಿ ಗಿರೊಲಾಗಲ್ಲ್ಯಾಕ್ನಿ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ಶಾರಾತ್ಲಿ ಸಗ್ಳಿ ಲೊಕಾ ತ್ಯಾ ಘರಾಚ್ಯಾ ಇದ್ರಾಕ್ ಗೊಳಾ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ದುಸ್ರಿ-ದುಸ್ರಿ ರೊಗಾಲಾಗಲ್ಲ್ಯಾ ಲೈ ಲೊಕಾಕ್ನಿ ಜೆಜುನ್ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ಲೈ ಲೊಕಾಂಚೆ ಗಿರೆ ಸೊಡ್ಸುಲ್ಯಾನ್. ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ನಿ ಜೆಜು ಕೊನ್ ಮನುನ್ ಗೊತ್ತ್ ಹೊತ್ತೆ, ತಸೆ ಮನುನ್ ತೆನಿ ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ನಿ ಬೊಲುಕುಚ್ ದಿವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ಜೆಜು ದುಸ್ರೆಂದಿಸಿ ಸಕ್ಕಾಳ್‍ಫಿಡೆ ಉಟ್ಲೊ, ಅನಿ ಕೊನ್ಬಿನಸಲ್ಲ್ಯಾ ಶಾಂತ್ ಜಾಗ್ಯಾರ್ ಗೆಲೊ. ಅನಿ ಥೈ ಮಾಗ್ನಿ ಕರುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ಖರೆ ಹಿಕ್ಡಿ, ಸಿಮಾವ್ ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ ಲೊಕಾ, ಜೆಜುಕ್ ಹುಡ್ಕುನ್ಗೆತ್ ");
INSERT INTO kans_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ಜೆಜು ಹೊತ್ತ್ಯಾಕ್ಡೆ ಯೆವ್ನ್ ಪಾವ್ಲಿ, ಅನಿ “ಸಗ್ಳೆ ಜಾನಾ ತುಜಿ ವಾಟ್ ಬಗುನ್ಗೆತ್ ಹಾತ್” ಮನುನ್ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ತನ್ನಾ ಜೆಜುನ್, “ಅಮಿ ಹಿತ್ಲ್ಯಾ ಅಜು-ಬಾಜುಚ್ಯಾ ಗಾವಾಕ್ನಿ ಜಾವ್ಕ್ ಪಾಜೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಥೈಬಿ ಮಿಯಾ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಪಾಜೆ; ತೆಚೆ ಸಾಟಿಚ್ ಮಿಯಾ ಯೆಲಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ಅಶೆ ಜೆಜುನ್ ಗಾಲಿಲಿಯಾ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಫಿರುನ್, ಸಿನಾಗೊಗಾತ್ನಿ ಜಾವ್ನ್, ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನ್, ಅನಿ ಗಿರೊಲಾಗಲ್ಲ್ಯಾಂಚಿ ಗಿರೆ ಸೊಡ್ಸುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ಎಕ್ ದಿಸ್ ಎಕ್ ಕುಸ್ಟ್ ರೊಗ್‍ ಲಾಗಲ್ಲೊ ಮಾನುಸ್ ಜೆಜುಚ್ಯಾ ಪಾಂಯಾತ್ ಡೊಗ್ಲಾ ಘಾಲುನ್ “ಜೆಜು ತಿಯಾ ಮನ್ ಕರ್ಲ್ಯಾರ್, ಮಾಕಾ ಗುನ್ ಕರುಕ್ ಹೊತಾ” ಮನುನ್ ರಡುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ಜೆಜುಕ್ ತೆಚೊ ಪಾಪ್‍ ದಿಸ್ಲೊ, ಜೆಜುನ್ ತೆಕಾ ಅಪ್ನಾಚ್ಯಾ ಹಾತಾನಿ ಅಪ್ಡುನ್ “ಮಾಕಾ ಮನ್ ಹಾಯ್. ತಿಯಾ ಪವಿತ್ರ್ ಹೊ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ತನ್ನಾಚ್ ತೆಚೊ ರೊಗ್ ತೆಕಾ ಸೊಡುನ್ ಗೆಲೊ, ಅನಿ ತೊ ಪವಿತ್ರ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ಅನಿ ಜೆಜುನ್ ತೆಕಾ ಫುರಾ ಗುನ್ ಕರ್ಲ್ಯಾನ್ ಅನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ಜೆಜುನ್ ತೆಕಾ “ಮಿಯಾ ತುಕಾ ಗುನ್ ಕರಲ್ಲ್ಯಾ ವಿಶಯಾತ್ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕೊ, ಸಿದಾ ಯಾಜಕಾಂಚಾಕ್ಡೆ ಜಾ, ಅನಿ ತುಜೆ ಆಗ್ ತೆಂಕಾ ದಾಕ್ವು. ತಿಯಾ ಗುನ್ ಹೊಲ್ಲ್ಯಾಸಾಟಿ, ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ, ದೆವಾಚಿ ದೆನ್ಗಿ ದಿ, ಹೆ ತಿಯಾ ಗುನ್ ಹೊಲೆ ಮನುನ್ ಸಗ್ಳ್ಯಾಕ್ನಿ ಎಕ್ ವಳಕ್ ಹೊಂವ್ದಿ” ಮನುನ್ ತಾಕಿತ್ ದಿವ್ನ್ ಧಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ಖರೆ ತೊ ಥೈತ್ನಾ ಗೆಲೊ, ಅನಿ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಹಿ ಖಬರ್ ಸಾಂಗುನ್ಗೆತ್ ಗೆಲೊ. ತಸೆ ಮನುನ್ ಜೆಜುಕ್, ಖಲ್ಯಾಬಿ ಗಾಂವಾತ್ ಬಹಿರಂಗ್ ಫಿರುಕ್ ಹೊವುಕ್ನಾ. ತೆಕಾ ಕೊನ್ ಲೊಕಾ ನಸಲ್ಲೆ ಜಾಗೆ ಬಗುನ್, ರ್‍ಹಾತಲೆ ಪಡ್ಲೆ. ಜಾಲ್ಯಾರ್‍ಬಿ ಸಗ್ಳ್ಯಾಕ್ನಾ ಲೊಕಾ ಜೆಜುಕ್ಡೆ ಯೆಂವ್ಗೆತುಚ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ಎಕ್ ಉಲ್ಲಿ ದಿಸಾ ಹೊಲ್ಲ್ಯಾಮಾನಾ, ಜೆಜು ಕಫರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ ಪರ್ತುನ್ ಯೆಲೊ. ತೊ ಥೈ, ಎಕ್ ಘರಾತ್ ಹಾಯ್ ಮನ್ತಲಿ ಖಬರ್, ಲೊಕಾಕ್ನಿ ಗಾವ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ಥೈ ಎವ್ಡಿ ಲೊಕಾ ಗೊಳಾ ಹೊಲ್ಲಿಕಿ ಮಟ್ಲ್ಯಾರ್, ತ್ಯಾ ಘರಾಚ್ಯಾ ದಾರಾತ್ ಪಾಯ್ ಥವ್ಕ್ ಸೈತ್ ಜಾಗೊ ನತ್ತೊ. ಜೆಜು ಥೈ ಗೊಳಾಹೊಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ, ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ತನ್ನಾ ಚಾರ್ ಮಾನ್ಸಾನಿ ಎಕ್ಲ್ಯಾ ವಾರ್‍ಯಾನ್‍ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ಲೊಕಾಂಚ್ಯಾ ಅಡ್ಚನಿಕ್‍ ಲಾಗುನ್, ತೆಂಕಾ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಹೊವ್ಕ್ನಾ. ತಸೆ ಮನುನ್, ತೆನಿ ತ್ಯಾ ವಾರ್‍ಯಾನ್‍ ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಘೆವ್ನ್ ಜೆಜು ಹೊತ್ತ್ಯಾ ಘರಾ ವರ್‍ತಿ ಚೆಡ್ಲ್ಯಾನಿ, ಅನಿ ಜೆಜು ಹೊತ್ತ್ಯಾಕ್ಡೆ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಉತ್ರುಕ್ ಹೊಯ್ಸರ್ಕಿ ವಾಟ್ ಕರುನ್ ತ್ಯಾ ವಾರ್‍ಯಾನ್‍ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್, ಹಾತ್ರಾನಾಸಮೆತ್ ಜೆಜು ಹೊತ್ತ್ಯಾಕ್ಡೆ ಉತರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ಹ್ಯಾ ಲೊಕಾಂಚೊ ವಿಶ್ವಾಸ್ ಬಗುನ್, ಜೆಜುನ್ ವಾರ್‍ಯಾನ್‍ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ “ಮಾಜ್ಯಾ ಪೊರಾ, ತುಜೆ ಸಗ್ಳೆ ಪಾಪ್ ಮಾಪ್ ಹೊಲೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ಥೈ ಉಲ್ಲೆ ಖಾಯ್ದೆ ಸಿಕ್ವುತಲೆ ಬಸಲ್ಲೆ ಹೊತ್ತೆ, ಜೆಜುನ್ ಅಶೆ ಮಟಲ್ಲೆ ಆಯ್ಕುನ್, ");
INSERT INTO kans_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ಅರೆ, ಹ್ಯೊ ಮಾನುಸ್ ಅಸೊ ಕಶ್ಯಾಕ್ ಬೊಲುಲಾ, ಹೆ, ದೆವಾಚಿ ನಿಂದ್ಯಾ ಕರ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊಲೆ! ದೆವಾಕ್ ಎಕ್ಲ್ಯಾಕ್ ಸೊಡುನ್, ಕೊನಾಕ್ಬಿ ಕೊನಾಚೆಬಿ ಪಾಪ್ ಮಾಪ್ ಕರುಕ್ ಹೊಯ್ನಾ” ಮನುನ್ ಅಪ್ಲ್ಯಾ ಮನಾತುಚ್ ಯವಜ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ತ್ಯಾ ಮಾನ್ಸಾನಿ ಯೌಜುಲಾಗಲ್ಲೆ ಜೆಜುಕ್ ಕಳ್ಳೆ, ತನ್ನಾ “ತುಮಿ ತುಮ್ಚ್ಯಾ ಮನಾತುಚ್ ಅಶೆ ಕಾಯ್ ಯೌಜುಲ್ಯಾಸಿ? ");
INSERT INTO kans_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ಖಲೆ ಸಸಾರ್ ತುಜೆ ಪಾಪ್ ಮಾಪ್ ಹೊಲೆ ಮನ್ತಲೆ ಕಾಯ್ ಉಟ್ ಅನಿ ತುಜೆ ಹಾತ್ರಾನ್ ಘೆವ್ನ್ ಚಲ್ ಮನ್ತಲೆ? ");
INSERT INTO kans_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಪಾಪ್ ಮಾಪ್ ಕರ್‍ತಲೊ ಅದಿಕಾರ್‍ಬಿ ಹಾಯ್ ಮನುನ್ ತುಮ್ಕಾ ಕಳುಕ್ ಪಾಜೆ” ಮನುನ್ ಮಟ್ಲ್ಯಾನ್. ಅನಿ ತ್ಯಾ ವಾರ್‍ಯಾನ್‍ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ");
INSERT INTO kans_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ಉಟ್, ಅನಿ ತುಜೆ ಹಾತ್ರಾನ್ ಘೆವ್ನ್ ತುಜ್ಯಾ ಘರಾಕ್ ಚಲ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೊ ಮಾನುಸ್ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾಲೊ, ಅನಿ ಅಪ್ನಾಚೆ ಹಾತ್ರಾನ್ ಘೆವ್ನ್ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಇದ್ರಾಕ್ನಾಚ್ ಚಲುನ್ಗೆತ್ ಗೆಲೊ, ಹೆ ಬಗಟಲ್ಲಿ ಸಗ್ಳಿ ಲೊಕಾ ಅಜಾಪ್ ಹೊಲಿ, ಅನಿ “ದೆವಾ, ಹೆ ಕಸ್ಲೆ ಅಜಾಪ್ ಅಮಿ ಬಗಿ ಸರ್ಕೆ ಕರ್‍ಲೆ!” ಮನುನ್ ದೆವಾಕ್ ಹೊಗಳ್ಳ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ಅನಿ ಎಗ್ದಾ ಜೆಜು ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆಕ್ ಗೆಲೊ. ತನ್ನಾ ಲೊಕಾಂಚೊ ಎಕ್ ತಾಂಡೊಬಿ ತೆಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತೊ. ತೊ ತೆಂಕಾ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಸಿಕ್ವುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ಅಶೆ ಅನಿಫಿಡೆ ಚಲುನ್ಗೆತ್ ಜಾತಾನಾ, ತೆರ್‍ಗಿ ವಸುಲ್ ಕರುನ್ಗೆತ್, ತೆರ್‍ಗಿ ವಸುಲ್ ಕರುಕ್ ಬಸ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಬಸಲ್ಲ್ಯಾ, ಅಲ್ಫೆವಾಚ್ಯಾ ಲೆಕಾಕ್ ಲೆವಿಕ್ ಜೆಜುನ್ ಬಗಟ್ಲ್ಯಾನ್. ಅನಿ ಜೆಜುನ್ ತೆಕಾ “ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಲೆವಿ ಉಟ್ಲೊ ಅನಿ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ಹೆಚ್ಯಾ ಮಾನಾ, ಜೆಜು ಲೆವಿಚ್ಯಾ ಘರಾತ್ ಜೆವಾನ್ ಕರುಕ್ ಲಾಗಲ್ಲೊ. ಥೈ ಸುಮಾರ್ ತೆರ್‍ಗಿ ವಸುಲಿ ಕರ್‍ತಲಿ ಲೊಕಾ ಅನಿ ಪಾಪಿ ಲೊಕಾ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತಿ. ತ್ಯಾತುರ್‍ಲಿ ಉಲ್ಲಿ ಲೊಕಾ, ಜೆಜು ಅನಿ ತೆಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವ್ನಾಚ್ಯಾ ಪಂಗ್ತಿರ್ ಬಸುನ್ ಜೆವಾನ್ ಕರುಕ್ ಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ಹ್ಯಾ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲ್ಯಾ ಅನಿ ಪಾಪಿ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಸುನ್ ಜೆಜು ಜೆವಾನ್ ಕರ್‍ತಲೆ ಬಗುನ್, ಮೊಯ್ಜೆಚೆ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾ ಫಾರಿಜೆವಾನಿ “ತೊ ಪಾಪಿ ಲೊಕಾಂಚ್ಯಾ ಅನಿ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲ್ಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಸುನ್, ಕಶ್ಯಾಕ್ ಜೆವಾನ್ ಕರ್‍ತಾ?” ಮನುನ್ ತೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ಹೆ ಆಯ್ಕುನ್ ಜೆಜುನ್ “ಅರಾಮ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ವಗ್ದುಳ್ಯಾಚಿ ಗರಜ್ ನಾ. ಅರಾಮ್ ನಸಲ್ಯಾಕ್ನಿ ವಗ್ದುಳ್ಯಾಚಿ ಗರಜ್ ರ್‍ಹಾತಾ. ಮಿಯಾ ಬರ್‍ಯಾ ಲೊಕಾಕ್ನಿ ನ್ಹಯ್, ಪಾಪಿ ಲೊಕಾಕ್ನಿ ಬಲ್ವುಕ್ ಮನುನ್ ಯೆಲಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ಜುಂವಾವಾಚಿ ಶಿಸಾ, ಅನಿ ಫಾರಿಜೆವ್ ಉಪಾಸ್ ಕರಿತ್. ಥೈಹೊತ್ತ್ಯಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ, ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್ “ಜುಂವಾವಾಚಿ ಶಿಸಾ ಅನಿ ಫಾರಿಜೆವಾಂಚಿ ಶಿಸಾ ಉಪಾಸ್ ಕರ್‍ತ್ಯಾತ್, ಖರೆ, ತುಜಿ ಶಿಸಾ ಕಶ್ಯಾಕ್ ಉಪಾಸ್ ಕರಿನ್ಯಾತ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ತನ್ನಾ ಜೆಜುನ್ “ಲಗ್ನಾಚೊ ನ್ಹವ್ರೊ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ರಾತಾನಾ, ಲಗ್ನಾಕ್ ಯೆಲ್ಲ್ಯಾ ಸೊಯ್ರ್ಯಾನಿ ಉಪಾಸ್ ಕರುಕ್ ಹೊತಾ ಕಾಯ್? ಹೊಯ್ನಾ! ");
INSERT INTO kans_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ಖರೆ ಎಕ್ ದಿಸ್ ತೊ ನ್ಹವ್ರೊ, ತೆಂಕಾ ಸೊಡುನ್ ಜಾತಲೊ ಎಳ್ ಯೆತಾ, ತನ್ನಾ ತೆನಿ ಉಪಾಸ್ ಕರ್‍ತ್ಯಾತ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ಕೊನ್ಬಿ ಮಾನುಸ್, ಜುನ್ನ್ಯಾ ಅಂಗಿಕ್ ನ್ಹವ್ಯಾ ಫಾಳಿಚೊ ತುಕ್ಡೊ ಲಾವುನ್ ಶಿವಿನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ನ್ಹವೊ ತುಕ್ಡೊ ಮುದ್ದಾ ಹೊವ್ನ್ ತಿ ಅಂಗಿ ಅನಿ ಉಲ್ಲಿ ಪಿಂಜ್ತಾ. ಅನಿ ಪಿಂಜಲ್ಲೊ ಜಾಗೊ ಅನಿ ಉಲ್ಲೊ ಮೊಟೊ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ಕೊನ್‍ಬಿ, ನ್ಹವೊ ವಾಯ್ನ್ ಜುನ್ನ್ಯಾ ಚಮ್ಡ್ಯಾಚ್ಯಾ ಪಿಸ್ವಿತ್ ಭರುನ್ ಥೈನಾತ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜುನ್ನಿ ಚಮ್ಡ್ಯಾಚಿ ಪಿಸ್ವಿ ಪಿಂಜುನ್ ಸಗ್ಳೊ ವಾಯ್ನ್ ಪಡುನ ಹಾಳ್ ಹೊತಾ. ತಸೆ ಮನುನ್ ಲೊಕಾ ಕನ್ನಾಬಿ, ನ್ಹವೊ ವಾಯ್ನ್ ನ್ಹವ್ಯಾ ಚಮ್ಡ್ಯಾಚ್ಯಾ ಪಿಸ್ವಿತ್ ಭರುನ್ ಥವ್ತ್ಯಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ಎಕ್ ದಿಸ್, ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ, ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ, ಎಕ್ ಶೆತಾನ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಯೆವ್‍ಲಾಗಲ್ಲೊ. ತನ್ನಾ ಜೆಜುಚ್ಯಾ ಶಿಸಾನಿ, ಖಾವ್ಕ್ ಮನುನ್, ಕನ್ಸಾ ಮೊಡುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ಹೆ ಫಾರಿಜೆವಾನಿ ಬಗಟ್ಲ್ಯಾನಿ ಅನಿ “ತುಜಿ ಶಿಸಾ ಅಶೆ ಕರ್‍ತಲೆ, ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾಚ್ಯಾ ಪರ್‍ಕಾರ್ ಚುಕ್ ನ್ಹಯ್ ಕಾಯ್?” ಮನುನ್ ಜೆಜುಕ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ತನ್ನಾ ಜೆಜುನ್ “ದಾವಿದಾಕ್ ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಿಯಾಕ್ನಿ ಭುಕ್‍ಲಾಗಲ್ಲಿ, ತನ್ನಾ ತೆಂಕಾ ಖಾವ್ಕ್ ಕಾಯ್ಬಿ ನಸಲ್ಲೆ, ತನ್ನಾ ದಾವಿದಾನ್ ಕಾಯ್ ಕರ್‍ಲ್ಯಾನ್ ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ವಾಚುಕ್ನ್ಯಾಸಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ಅಭಿಯಾತರ್ ಮಹಾಯಾಜಕ್ ಹೊತ್ತ್ಯಾ ಕಾಲಾತ್, ದಾವಿದ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಗೆಲೊ ಅನಿ ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಯಾಜಕಾನಿ ಸೊಡುನ್, ಅನಿ ಕೊನಾಕ್ಬಿ ಖಾವ್ಕ್ ಪರ್ವಾನ್ಗಿ ನಸಲ್ಲ್ಯಾ, ದೆವಾಕ್ ಭೆಟ್ವಲ್ಲ್ಯಾ ಭಾಕ್ರಿಯಾ ಖಾಲ್ಯಾನ್, ಅನಿ ಅಪ್ಲ್ಯಾ ವಾಂಗ್ಡಿಯಾಕ್ನಿಬಿ ಹಾನುನ್ ದಿಲ್ಯಾನ್.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ಮಾನಾ ಜೆಜುನ್ ಫಾರಿಜೆವಾಕ್ನಿ, “ಸಬ್ಬಾತಾಚೊ ದಿಸ್, ಮಾನ್ಸಾಕ್ ಮಜತ್ ಕರುಕ್ ಮನುನ್ ಕರಲ್ಲೊ ಹಾಯ್. ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಾನ್ ಮಾನ್ಸಾಚ್ಯಾ ವರ್‍ತಿ ಅದಿಕಾರ್ ಚಾಲ್ವುಕ್ ಮನುನ್ ಕರಲ್ಲೊ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ತೆಚೆಸಾಟ್ನಿ, ಮಾನ್ಸಾಚೊ ಲೆಕ್, ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಾಚೊಬಿ ಧನಿ,” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ಎಕ್ ದಿಸ್ ಜೆಜು ಸಿನಾಗೊಗಾತ್ ಗೆಲೊ, ಥೈ ಅಕಡಲ್ಲ್ಯಾ ಹಾತಾಚೊ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ಥೈ ಹೊತ್ತಿ ಜುದೆವಾಂಚಿ ಉಲ್ಲಿ ಮಾನ್ಸಾ, ಜೆಜು ತ್ಯಾ ಅಕಡಲ್ಲ್ಯಾ ಹಾತಾಚ್ಯಾ ಮಾನ್ಸಾಕ್ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ, ಗುನ್ ಕರ್‍ತಾ ಕಾಯ್ ಬಗುವಾ? ಅನಿ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್ ತರ್, ತೆಚೆ ವರ್‍ತಿ ಎಕ್ ಝುಟೆ ಅಪ್ವಾದ್ ಘಾಲುವಾ, ಮನುನ್ ರಾಕುನ್ಗೆತ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ಜೆಜುನ್ ತ್ಯಾ ಅಕಡಲ್ಲ್ಯಾ ಹಾತಾಚ್ಯಾಕ್ “ಉಟುನ್ ಫಿಡೆ ಯೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ಅನಿ ಥೈ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ “ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಪಾಳ್ತಲೊ ಖಾಯ್ದೊ, ಬರೆ ಕರುಚೆ ಮನ್ತಾ, ಕಾಯ್ ವಾಯ್ಟ್ ಕರುಚೆ ಮನ್ತಾ? ಎಕ್ ಮಾನ್ಸಾಚೊ ಜಿಂವ್ ಹುರ್‍ವುಚೆ, ಮನ್ತಾ? ಕಾಯ್ ಜಿವ್ ಕಾಡುಚೆ ಮನ್ತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ಹ್ಯಾ ಪ್ರಸ್ನ್ಯಾಕ್ ಕೊನ್ಬಿ ಕಾಯ್‍ ಜಬಾಬ್ ದಿವ್ಕನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ತನ್ನಾ ರಾಗಾನ್, ಜೆಜುನ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಎಗ್ದಾ ಅಪ್ನಾಚೆ ಡೊಳೆ ಫಿರ್ವುನ್ ಬಗಟ್ಲ್ಯಾನ್. ತೆಂಚೆ ಮಂಡ್‍ಪಾನ್ ಬಗುನ್ ತೆಕಾ ಬೆಜಾರ್ ಹೊಲೊ. ತನ್ನಾ ಜೆಜುನ್ ತ್ಯಾ “ಮಾನ್ಸಾಕ್ ತುಜೊ ಹಾತ್ ಲಾಂಬ್ ಸೊಡ್” ಮಟ್ಲ್ಯಾನ್. ತೆನಿ ಹಾತ್ ಲಾಂಬ್ ಸೊಡ್ಲ್ಯಾನ್, ತನ್ನಾಚ್ ತೆಚೊ ಹಾತ್ ಬರೊ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ತನ್ನಾ ಫಾರಿಜೆವಾ ಭಾಯ್ರ್ ಗೆಲಿ, ಅನಿ ಹೆರೊದಾಚ್ಯಾ ಪಕ್ಷಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಳುನ್, ಜೆಜುಕ್ ಕಶೆ ಕರುನ್ ಜಿವಾನಿ ಮಾರ್‍ತಲೆ ಮನುನ್ ಯವ್ಜನ್ ಘಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ತೆಚ್ಯಾ ಮಾನಾ, ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆಕ್ ಗೆಲೊ. ಥೈ ಲೊಕಾಂಚೊ ಎಕ್ ಮೊಟೊ ತಾಂಡೊ ಜೆಜುಚ್ಯಾ ಭೊತ್ಯಾನಿ ಗೊಳಾಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ಗಾಲಿಲಿಯಾ, ಜುದೆಯಾ, ಅನಿ ಇದುಮೆಯಾ, ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾನಿತ್ನಾ, ಜೆರುಜಲೆಮ್, ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ನಾ, ಅನಿ ಜೊರ್ದಾನ್ ನ್ಹಯ್ಚ್ಯಾ ತಿಕುಲ್ಲ್ಯಾ ಬಾಜುಕ್ನಾ, ತಿರ್ ಅನಿ ಸಿದೊನ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಂಚ್ಯಾ ಅಜು-ಬಾಜುಚ್ಯಾ ಗಾವಾನಿತ್ನಾ, ಜೆಜುನ್ ಕರಲ್ಲ್ಯಾ ಬರ್‍ಯಾ ಕಾಮಾಂಚಿ ಖಬರ್ ಆಯ್ಕುನ್, ಹಿ ಲೊಕಾ ಥೈ ಯೆವ್ನ್ ಗೊಳಾ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆಕ್ ಜೆಜು ಲೊಕಾಕ್ನಿ ಸಿಕ್ವುತಲೆ ಜೆಜು ಹಿ ಲೊಕಾ ಅಪ್ನಾಚ್ಯಾ ಆಂಗಾರ್ ಪಡುನ್ ಮಾಕಾ ಹಿಚಕ್ತಿಲ್, ಮನುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ, ಅಪ್ನಾಕ್ ಬಸುಕ್ ಎಕ್ ಢೊನ್ ಹಾನುನ್, ತಯಾರ್ ಕರುನ್ ಥವ್ಕ್ ಲಾವ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ಜೆಜುನ್, ಸುಮಾರ್ ಅರಾಮ್ ನತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಗುನ್ ಕರಲ್ಲ್ಯಾನ್. ತಸೆ ಮನುನ್, ಹರ್‍ಎಕ್ ಅರಾಮ್ ನತ್ತೊ ಮಾನುಸ್, ಲೊಕಾಕ್ನಿ ಢಕ್ಲುನ್ಗೆತ್, ಜೆಜುಕ್ ಅಪಡ್ತಲೊ ಅವ್ಕಾಸ್ ಹುಡ್ಕುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ಗಿರೊಲಾಗಲ್ಲಿ ಲೊಕಾಬಿ ಥೈ ಹೊತ್ತಿ. ತೆನಿ ಜೆಜುಕ್ ಬಗುನ್, ತೆಚ್ಯಾ ಇದ್ರಾಕ್ ಪಡುನ್ “ತಿಯಾ ದೆವಾಚೊ ಲೆಕ್” ಮನುನ್ ಬೊಬ್ ಮಾರಿತ್. ");
INSERT INTO kans_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ಖರೆ ತೊ ಕೊನ್ ಮನುನ್ ಕೊನಾಕ್ಬಿ ಸಾಂಗ್ತಲೆ ನಕ್ಕೊ ಮನುನ್, ಜೆಜುನ್ ಗಿರ್‍ಯಾಕ್ನಿ ಖಡಕ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ತನ್ನಾ ಜೆಜುನ್, ಎಕ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಚಡುನ್, ಅಪ್ನಾಕ್ ಕೊನ್-ಕೊನ್ ಪಾಜೆ ತೆಂಕಾ ಬಲ್ವುಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ತೆಚೆಕ್ಡೆ ಯೆಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ಜೆಜುನ್ ಬಾರಾ ಜಾನಾಕ್ನಿ ಎಚುನ್ ಕಾಡ್ಲ್ಯಾನ್, ತೆಂಕಾ “ಅಪೊಸ್ತಲಾ” ಮನುನ್ ನಾವ್ ದಿಲ್ಯಾನ್. ಅನಿ “ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾವ್ಕ್, ಮನುನ್ ಮಿಯಾ ತುಮ್ಕಾ ಎಚುನ್ ಕಾಡ್ಲಾ, ಸಗ್ಳ್ಯಾಕ್ಡೆ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಮಿಯಾ ತುಮ್ಕಾ ಧಾಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ಅನಿ ಗಿರೆ ಸೊಡ್ವುತಲೊ ಅದಿಕಾರ್ ತುಮ್ಕಾ ದಿತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ಜೆಜುನ್ ಎಚುನ್ ಕಾಡಲ್ಲ್ಯಾ ಬಾರಾ ಜಾನಾಂಚಿ ನಾವಾ ಹಿ - ಸಿಮಾವ್ ಹೆಕಾ ಜೆಜುನ್, ಪೆದ್ರು ಮನುನ್ ನಾವ್ ದಿಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ಜೆಬೆದೆವಾಚಿ ಪೊರಾ, ಜಾಕೊಬ್ ಅನಿ ತೆಚೊ ಭಾವ್ ಜುವಾಂವ್ ಹೆಂಕಾ ಜೆಜುನ್ “ಬೊವನೆರ್ಗೆಸ್” ತಸೆ ಮಟ್ಲ್ಯಾರ್, ಗುಡ್ಗುಡ್ಯಾಚಿ ಮಾನ್ಸಾ, ಮನುನ್ ನಾವ್ ಥವ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ಅಂದ್ರು, ಫಿಲಿಪ್, ಬಾರ್‍ತೊಲೊಮೆವ್, ಮಾತೆವ್, ಥೊಮಸ್, ಅಲ್ಫೆವಾಚೊ ಲೆಕ್ ಜಾಕೊಬ್ , ತಾದ್ದೆವ್,ದೆಶ್‍ಭಕ್ತ್ ಸಿಮಾವ್, ");
INSERT INTO kans_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ಅನಿ ಜೆಜುಕ್ ಘಾತ್‍ಕರುನ್ ಧರುನ್ ದಿಲ್ಲೊ, ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತ್. ");
INSERT INTO kans_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ತನ್ನಾ ಜೆಜು ಘರಾಕ್ಡೆ ಗೆಲೊ, ಥೈ ಲೈ ಲೊಕಾ ಗೂಳಾ ಹೊಲ್ಲಿ, ತಸೆ ಮನುನ್ ಜೆಜುಕ್ ಅನಿ ತೆಚ್ಯಾ‍ ಶಿಸಾಕ್ನಿ ಜೆವಾನ್‍ ಕರುಕ್ ಸೈತ್ ಎಳ್ ಗಾವುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ಜೆಜುಚ್ಯಾ ಘರಾತ್ಲ್ಯಾ ಲೊಕಾನಿ “ತೆಕಾ ಪಿಶೆ ಲಾಗ್ಲಾ” ಮನುನ್, ಲೊಕಾ ಮನ್ತಲೆ ಆಯಿಕ್ಲ್ಯಾನಿ ಅನಿ ಜೆಜುಕ್, ಘರಾಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಮನುನ್ ಗೆಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ಜೆರುಜಲೆಮಾತ್ನಾ ಯೆಲ್ಲೆ, ಖಾಯ್ದೆ ಸಿಕ್ವುತಲೆ, “ತೆಚ್ಯಾ ಆಂಗಾತ್ ಗಿರ್‍ಯಾಂಚೊ ವಡಿಲ್ ಬೆಎಲ್ಜೆಬುಲ್ ಹಾಯ್. ತ್ಯಾ ಗಿರ್‍ಯಾಚ್ಯಾ ಬಳಾನ್ ತೊ ಲೊಕಾಕ್ನಿಲಾಗಲ್ಲಿ ಗಿರೆ ಸೊಡ್ಸುತಾ,” ಮನುಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, ಜಗ್ಗೊಳ್ ಬಲ್ವುಲ್ಯಾನ್, ಅನಿ ಕಾನಿಯಾಂಚ್ಯಾ ವೈನಾ ಸಾಂಗುನ್ಗೆತ್: ಸೈತಾನಾನ್, ಗಿರ್‍ಯಾಕ್ ಭಾಯ್ರ್ ಘಾಲುಕ್ ಹೊತಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ಎಕ್ ರಾಜ್ ದೊನ್ ತಾಂಡೆ ಹೊವ್ನ್ ಎಕಾಮೆಕಾಚ್ಯಾ ವಿರೊದ್ ಝಗ್ಡುನ್ಗೆತ್ ರ್‍ಹಾಲ್ಯಾರ್, ತೊ ರಾಜ್ ನಾಸ್ ಹೊವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ಎಕ್ ಘರಾತ್ಲಿ ಲೊಕಾ ದೊನ್ ತಾಂಡೆ ಹೊವ್ನ್ ಝಗ್ಡುನ್ಗೆತ್ ರ್‍ಹಾಲ್ಯಾರ್, ತೆ ಘರಾನೆಚ್ ನಾಸ್ ಹೊವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ತಸೆಚ್ ಸೈತಾನಾಬಿ ದೊನ್ ತಾಂಡೆ ಕರುನ್ ಘೆವ್ನ್, ಝಗ್ಡುನ್ಗೆತ್ ರ್‍ಹಾಲ್ಯಾರ್, ಸೈತಾನಾಚೊ ರಾಜ್ ಸರುನುಚ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ಎಕ್ ಘಟ್ಮುಟ್ ಮಾನ್ಸಾಚ್ಯಾ ಘರಾತ್ಲಿ ಸಾಮಾನಾ, ಚೊರುಚೆ ಮಟ್ಲ್ಯಾರ್, ಅದ್ದಿ ತ್ಯಾ ಮಾನ್ಸಾಕ್, ಘಟ್ ಭಾಂದುಕ್ ಪಾಜೆ, ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಘರಾತ್ಲೆ ಚೊರುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ಖರೆಚ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಮಾನ್ಸಾನಿ ಕರಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಪಾಪಾಂಚಿ, ಅನಿ ದೆವಾಚ್ಯಾ ವರ್‍ತಿ ಬೊಲಲ್ಲ್ಯಾ ನಿಂದ್ಯಾಂಚಿ, ಮಾಪಿ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ಖರೆ ದೆವಾಚ್ಯಾ ಆತ್ಮ್ಯಾಚ್ಯಾ ವಿರೊದ್ ನಿಂದ್ಯಾ ಬೊಲಲ್ಲ್ಯಾಕ್, ಕನ್ನಾಚ್ ಮಾಪಿ ಗಾವಿನಾ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ಕನ್ನಾಬಿ ಮಾಪ್ ಕರಿನಸಲ್ಲ್ಯಾ ಪಾಪಾತ್ ಪಡ್ತಾ.” ");
INSERT INTO kans_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“ಹೆಕಾ ಗಿರೊಲಾಗ್ಲಾ” ಮನುನ್ ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಮಟ್ಲ್ಯಾನಿ, ತಸೆ ಮನುನ್ ಜೆಜುನ್ ಅಶೆ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ತವ್ಡ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜೆಜುಚಿ ಬಾಯ್, ಅನಿ ಭಾವಾ, ಥೈ ಯೆವ್ನ್ ಪಾವ್ಲ್ಯಾನಿ. ತೆನಿ ಘರಾಚ್ಯಾ ಭಾಯ್ರ್ ಇಬೆ ರ್‍ಹಾವ್ನ್, ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಖಬರ್ ಘೆವ್ನ್ ಯೆವ್ಕ್ ಸಾಂಗುನ್ ಧಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ಜೆಜುಚ್ಯಾ ಭೊತ್ಯಾನಿ ಲೈ ಲೊಕಾ ಬಸಲ್ಲಿ ಹೊತ್ತಿ. ತೆನಿ ಜೆಜುಕ್ “ತುಜಿ ಬಾಯ್, ಅನಿ ತುಜಿ ಭಾವಾ, ಅನಿ ಭೆನಿಯಾ, ತುಕಾ ಭಾಯ್ರ್ ಹುಡ್ಕುಕ್ ಲಾಗ್ಲ್ಯಾತ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ತನ್ನಾ ಜೆಜುನ್, “ಮಾಜಿ ಬಾಯ್, ಅನಿ ಭಾವಾ, ಅನಿ ಭೆನಿಯಾ ಕೊನ್ ಗೊತ್ತ್ ಹಾಯ್?” ");
INSERT INTO kans_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ಅಪ್ನಾಚ್ಯಾ ಭೊತ್ಯಾನಿ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಗುನ್ಗೆತ್ “ಹಿ ಲೊಕಾಚ್, ಮಾಜಿ ಬಾಯ್, ಅನಿ ಮಾಜೆ ಭಾವ್‍ ಭೆನಿಯಾ! ");
INSERT INTO kans_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ದೆವಾಚ್ಯಾ ಯವ್ಜನಿ ಸರ್ಕೆ ಕರ್‍ತಲಿ ಲೊಕಾಚ್, ಮಾಜಿ ಬಾಯ್ ಅನಿ ಮಾಜೆ ಭಾವ್‍ ಭೆನಿಯಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ಅನಿ ಜೆಜು, ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆಕ್ ಜಾವ್ನ್ ಸಿಕ್ವುಕ್ಲಾಗ್ಲೊ. ಥೈ ಲೈ ಲೊಕಾ ತೆಚೆಕ್ಡೆ ಯೆವ್ನ್ ಗೊಳಾ ಹೊಲಿ. ತಸೆ ಮನುನ್ ಜೆಜು ಸಮುಂದರಾತ್ ಇಬೆ ಕರಲ್ಲ್ಯಾ ಢೊನಿತ್ ಚಡುನ್ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ಅನಿ ಪಾನಿಯಾಚ್ಯಾ ದಂಡೆ ಪತರ್ ಲೊಕಾ ಜಿಮ್ನಿರ್ ಬಸಲ್ಲಿ. ತನ್ನಾ ಜೆಜುನ್ ಕಾನಿಯಾಂಚ್ಯಾ ವೈನಾಚ್, ಸುಮಾರ್ ವಿಶಯ್ ಶಿಕ್ವುಲ್ಯಾನ್. ಶಿಕ್ವುತಾನಾ ಜೆಜುನ್ ಹಿ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ಬರೆ ಕರುನ್ ಆಯ್ಕಾ! ಎಕ್ ಮಾನುಸ್ ಶೆತಾತ್ ಭ್ಹಿಂಯ್ ಸಿಪ್ಡುಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ತೊ ಸಿಪ್ಡುನ್ಗೆತ್ ಜಾತಾನಾ, ಉಲ್ಲೆ ಭ್ಹಿಂಯ್, ವಾಟೆಚ್ಯಾ ದಂಡೆಕ್ ಪಡ್ಲೆ, ತೆ, ಫಾಂಕ್ರಾನಿ ಯೆವ್ನ್ ಖಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ಅನಿ ಉಲ್ಲೆ ಭ್ಹಿಂಯ್, ಗುಂಡ್ಯಾಚೊ ತಳಾಪ್ ಹೊತ್ತ್ಯಾ ಜಿಮ್ನಿರ್ ಪಡ್ಲೆ, ಥೈ ವೈಲ್ಯಾ ವೈರ್, ಉಲ್ಲಿ ಮಾಟಿ ಹೊತ್ತಿ, ತಸೆ ಮನುನ್, ತೆ, ಲಗ್ಗುನಾಚ್ ಉಗ್ವುನ್ ಯೆಲೆ, ");
INSERT INTO kans_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ಸೂರ್ಯಾ ಉಗ್ವುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತಿ ಝಾಡಾ ವಾಳುನ್ ಗೆಲಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆಂಚಿ ಬೆರಾ ಭುತ್ತುರ್ ಜಾವ್ಕನತ್ತಿ. ತಸೆ ಮನುನ್, ತಿ ಝಾಡಾ, ವಾಳುನ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ಅನಿ ಉಲ್ಲೆ ಭ್ಹಿಂಯ್, ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಪಡ್ಲೆ, ತೆ ಉಗಾವ್ಲೆ, ಅನಿ ತ್ಯಾ ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಾಡಾಂಚ್ಯಾ ಅಡ್ಚನಿತ್ ಗಾವುನ್, ತೆನಿ ಫಳ್ ದಿವ್ಕ್ ನಾ . ");
INSERT INTO kans_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ಅನಿ ಉಲ್ಲೆ ಭ್ಹಿಂಯ್, ಬರ್‍ಯಾ ಮಾಟಿತ್ ಪಡ್ಲೆ, ತೆ ಉಗಾವ್ಲೆ, ಝಾಡಾ ಮೊಟಿ ಹೊವ್ನ್ ಫಳ್ ದಿಲ್ಯಾನಿ; ಉಲ್ಲ್ಯಾನ್ ತಿಸ್ ದಾನೆ, ಉಲ್ಲ್ಯಾನಿ ಸಾಟ್ , ಅನಿ ಉಲ್ಲ್ಯಾನ್ ಸೆಂಬರಾಕ್ ಸೆಂಬರ್. ");
INSERT INTO kans_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ಮಾನಾ ಜೆಜುನ್ “ತುಮ್ಕಾ ಕಾನಾ ಹಾತ್ ಜಾಲ್ಯಾರ್, ಮಿಯಾ ಸಾಂಗ್ತಲೆ ಧ್ಯಾನ್ ದಿವ್ನ್ ಆಯ್ಕಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ಜೆಜು ಎಕ್ಲೊಚ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ, ಕಾನಿ ಆಯ್ಕಲ್ಲಿ ಉಲ್ಲಿ ಲೊಕಾ, ಬಾರಾ ಜಾನಾ ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ, ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್, ತಿ ಕಾನಿ ಅಮ್ಕಾ ಸೊಡ್ಸುನ್ ಸಾಂಗ್, ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ತನ್ನಾ ಜೆಜುನ್ “ದೆವಾಚ್ಯಾ ರಾಜಾಚೊ ಖರೊ ಘುಟ್, ತುಮ್ಕಾ ದಿಲ್ಲೊ ಹಾಯ್, ಖರೆ, ದುಸ್ರಿ ಲೊಕಾ ತೆ, ಕಾನಿಚ್ಯಾ ವೈನಾ ಆಯಿಕ್ತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ತೆಚ್ಯಾ ಸಾಟ್ನಿ “ತೆನಿ ಬಗಟ್ಲ್ಯಾರ್ಬಿ, ತೆಂಕಾ ದಿಸಿನಾ, ತೆನಿ ಅಯಿಕ್‍ಲ್ಯಾರ್ಬಿ, ತೆಂಕಾ ಕಳಿನಾ, ತೆನಿ ಅಶೆ ಕರ್ಲ್ಯಾರ್, ತೆನಿ ದೆವಾಕ್ಡೆ ಪರ್ತುನ್ ಯೆತಿಲ್, ಅನಿ ತೊ ತೆಂಕಾ ಮಾಪ್ ಕರಿಲ್ ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ತನ್ನಾ ಜೆಜುನ್ “ಹಿ ಕಾನಿ ತುಮ್ಕಾ ಅರ್ತ್‍ ಹೊವುಕ್ನಾ ಕಾಯ್? ತರ್‍, ಖಲಿಬಿ ಕಾನಿ, ತುಮಿ ಕಶೆ ಅರ್ತ್‍ ಕರುನ್ ಘೆತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“ಸಿಪಡ್ತಲೊ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಸಿಪಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ಉಲ್ಲಿ ಲೊಕಾ ತ್ಯಾ ವಾಟೆಚ್ಯಾ ದಂಡೆರ್ ಪಡಲ್ಲ್ಯಾ ಭ್ಹಿಂಯಾ ಸರ್ಕಿ, ತೆನಿ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾಚ್, ಸೈತಾನ್ ಯೆತಾ, ಅನಿ ತ್ಯಾ ಗೊಸ್ಟಿಯಾ ಕಾಡುನ್ ಘೆವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ಅನಿ ಉಲ್ಲೆ ಜಾನಾ ಗುಂಡ್ಯಾಚ್ಯಾ ತಳ್ಪಾರ್ ಪಡಲ್ಲ್ಯಾ ಬಿಂಯಾಂಚ್ಯಾ ಬಾಸೆನ್; ತೆನಿ, ಗೊಸ್ಟಿಯಾ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ, ತ್ಯಾ ಗೊಸ್ಟಿಯಾ ಕುಶಿನ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ಖರೆ, ತೆಂಚ್ಯಾ ಭುತ್ತುರ್ ತ್ಯಾ ಗೊಸ್ಟಿಯಾ ಖೊಲಾತ್ ಜಾಯ್ನಸಲ್ಲ್ಯಾಸಾಟ್ನಿ, ತ್ಯಾ, ತೆಂಚೆಕ್ಡೆ ಲೈ ಎಳ್ ರೈನಾತ್. ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಲಾಗುನ್ ತರಾಸ್, ನಾಜಾಲ್ಯಾರ್, ಕಸ್ಟ್, ಯೆಲ್ಲ್ಯಾತನ್ನಾ ತೆನಿ ತ್ಯಾ ಗೊಸ್ಟಿಯಾ ಸೊಡುನ್ ಸೊಡ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ಅನಿ ಉಲ್ಲೆ ಜಾನಾ ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಪಡಲ್ಲ್ಯಾ ಬಿಂಯಾಂಚ್ಯಾ ಬಾಸೆನ್, ಹೆನಿ, ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ಖರೆ, ಹ್ಯಾ ಜಿವನಾಚ್ಯಾ ವಿಶಯಾತ್ಲಿ ಯವ್ಜನ್, ಪಯ್ಸ್ಯಾಂಚಿ ಆಶ್ಯಾ, ಅನಿ ಅಸ್ಲ್ಯಾ ಲೈ ಯೌಜನ್ಯಾತ್ನಿ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಗುಸ್ಮಟುನ್ ಪಿಕ್ಕ್ ದಿವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ಖರೆ ಅನಿಹುರಲ್ಲಿ ಲೊಕಾ, ಬರ್‍ಯಾ ಮಾಟಿತ್ ಪಡಲ್ಲ್ಯಾ ಬಿಂಯಾಂಚ್ಯಾ ಬಾಸೆನ್. ತೆನಿ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಅಯಿಕ್ತ್ಯಾತ್, ಸ್ವಿಕಾರ್ ಕರ್‍ತ್ಯಾತ್, ಅನಿ ಪಿಕ್ಕ್ ದಿತ್ಯಾತ್. ಥೊಡೆ ತಿಸ್, ಸಾಟ್, ಅನಿ ಸೆಂಬರ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ಜೆಜುನ್ ಅನಿಫಿಡೆ, “ಕೊನ್‍ಬಿ, ದಿವೊ ಪೆಟ್ವುನ್, ಭೊಗುನ್ಯಾಚ್ಯಾ ಬುಡಿ, ನಾಹೊಲ್ಯಾರ್, ನಿಜ್ತಲ್ಯಾ ಮಾಚ್ಯಾಚ್ಯಾ ಬುಡಿ ಥವ್ತಾ ಕಾಯ್? ನಾ. ತೊ,ತೊ ದಿವೊ, ದಿವೊ ಥವ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ವೈರ್ ಥವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ಜೆ ಕಾಯ್ ಲಿಪುನ್ ಹಾಯ್, ತೆ ಮಾಳಾಕ್ ಹಾನುನ್ ಹೊತಾ,ಅನಿ ಜೆ ಕಾಯ್ ಧಾಪುನ್ ಥವಲ್ಲೆ ಹಾಯ್, ತೆ ಉಗ್ಡುನ್ ಹೊತಾ.” ");
INSERT INTO kans_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“ತುಮಿ ಆಯ್ಕುಲ್ಯಾಶಿ ಜಾಲ್ಯಾರ್, ಮಿಯಾ ಸಾಂಗ್ತಲೆ ಧ್ಯಾನ್ ದಿವ್ನ್ ಆಯ್ಕಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ತನ್ನಾ ತೆನಿ “ತುಮಿ ಆಯ್ಕಲ್ಯಾಸಿ ತೆಕಾ ಧ್ಯಾನ್ ದಿವಾ! ತುಮಿ ದುಸ್ರ್ಯಾಕ್ನಿ ಖಲ್ಯಾ ಖಾಯ್ದ್ಯಾನ್ ನ್ಯಾಯ್ ಕರ್ತ್ಯಾಶಿ, ತ್ಯಾಚ್ ಖಾಯ್ದ್ಯಾನ್ ದೆವ್ ತುಮ್ಕಾ ನ್ಯಾಯ್ ಕರ್‍ತಾ-ಅನಿ ತೆಚೆನ್ಕಿ ಕಟಿನ್ ಮಾಪಾನ್ . ");
INSERT INTO kans_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ಕೊನಾಕ್ಡೆ ಹಾಯ್, ತೆಕಾ ಜಾಸ್ತಿಚೆಚ್ ದಿವ್ನ್ ಹೊತಾ. ಅನಿ ಕೊನಾಕ್ಡೆ ನಾ ತೆಚೆಕ್ಡೆ ಹೊತ್ತೆ ಉಲ್ಲೆಬಿ ಕಾಡುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ” ಮನುನ್ಬಿ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ಅನಿ ಫಿಡೆ ಜೆಜುನ್ “ದೆವಾಚೆ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್, ಅಶೆ, ಎಕ್ ಮಾನುಸ್ ಅಪ್ಲ್ಯಾ ಶೆತಾತ್ ಭ್ಹಿಂಯ್ ಪೆರ್ತಾ, ");
INSERT INTO kans_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ತೊ ರಾಚ್ಚೆ ನಿಜ್ತಲೆ, ದಿಸಾಂಚೆ ಉಟ್ತಲೆ ಕರಿತ್ ರ್‍ಹಾತಾ, ಖರೆ, ತೆ ಭ್ಹಿಂಯ್ ಉಗಾವ್ತಾ, ಅನಿ ವಾಡ್ತಾ, ಅನಿ ಹೆ ಕಶೆ ಹೊತಾ, ಮನುನ್ ತೆಕಾ ಗೊತ್ತ್ ರ್‍ಹಾಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ಮಾಟಿ ಅಪ್ಲ್ಯಾ ಅಪ್ನಿಚ್ ತ್ಯಾ ಭ್ಹಿಂಯಾಕ್ ಉಗ್ವುನ್ ಪಿಕ್ಕ್ ದಿ ಸರ್ಕೆ ಕರ್‍ತಾ, ಅದ್ದಿ ಪಾಲ್ವಿ, ಮಾನಾ ಕನ್ಸಾ,ಮಾನಾ ದಾನ್ಯಾನಿ ಭರಲ್ಲಿ ಕನ್ಸಾ. ");
INSERT INTO kans_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ಖರೆ ಪಿಕ್ಕ್ ಪಿಕುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆ ಪಿಕ್ಕ್ ಪಿಕುನ್ ಯೆಲಾ ಮನುನ್, ತೊ ಮಾನುಸ್ ಇಳೊ ಘೆವ್ನ್ ಕಾಪ್ತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತನ್ನಾ ಸುಗ್ಗಿಚೊ ಕಾಲ್ ಯೆಲ್ಲೊ ರ್‍ಹಾತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“ದೆವಾಚೆ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್, ಅನಿ ಖಚ್ಚ್ಯಾಕ್ ಸಮಾ ಕರುಕ್ ಹೊತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್ “ಹೆ, ಸೊಡ್ಸುನ್ ಸಾಂಗುಕ್, ಅಮಿ ಕಲಿ ಕಾನಿ ವಾಪ್ರುಕ್ ಹೊತಾ? ");
INSERT INTO kans_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ಹೆ, ಅಶೆ. ಎಕ್ ಮಾನುಸ್, ಎಕ್ ಸಾಸಾಂವಾಚಿ ಭ್ಹಿಂಯ್ ಘೆತಾ, ಜಗಾತ್ ಎಗ್ದಮ್ ಬಾರಿಕ್‍ ಭ್ಹಿಂಯ್ ತಿ, ತಿ ಭ್ಹಿಂಯ್, ತೊ ಜಮ್ನಿತ್ ಘಾಲ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ಉಲ್ಲೊ ಎಳ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ತೆ ವಾಡ್ತಾ, ಅನಿ ಸಗ್ಳ್ಯಾ ಝಾಡಾಂಚ್ಯಾನ್ಕಿ ಮೊಟೆ ಹೊತಾ. ತೆಚ್ಯೆ ಟಾಳಿಯಾ ಎವ್ಡೆ ಮೊಟೆ ಹೊತ್ಯಾತ್ ಕಿ, ಮಳ್ಬಾತ್ ಹುಡ್ತಲಿ ಫಾಂಕ್ರಾ ಯೆವ್ನ್ ತೆಚ್ಯಾ ಸಾವ್ಳಿಕ್ ಘಂಟೆ ಭಾಂದ್ತ್ಯಾತ್.”ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ಅಸ್ಲ್ಯಾ ಸುಮಾರ್ ಕಾನಿಯಾ ವಾಪ್ರುನ್, ಜೆಜು, ಲೊಕಾಕ್ನಿ, ಕವ್ಡೆ ಹೊತಾ ತವ್ಡೆ ಕಳಿ ಸರ್ಕೆ, ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ಕಾನಿ ನಸ್ತಾನಾ, ತೊ, ತೆಂಚ್ಯಾಕ್ಡೆ ಬೊಲಿನಸಿ, ಖರೆ, ಕಡೆಕ್ ಅಪ್ಲ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ಲೊಚ್ ರಾತಾನಾ ಕಾನಿಯಾಂಚೊ ಅರ್ತ್‍ ಸೊಡ್ಸುನ್ ಸಾಂಗಿ. ");
INSERT INTO kans_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ತ್ಯಾ ದಿಸ್, ಸಾಂಜ್ ಹೊತಾನಾ, ಜೆಜುನ್ ಅಪ್ಲ್ಯಾ ಶಿಸಾಕ್ನಿ“ಅಮಿ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಜಾಂವಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ತಸೆ ಮನುನ್, ಶಿಸಾ ಲೊಕಾಕ್ನಿ ಸೊಡುನ್, ಜೆಜು ಬಸುನ್ ಹೊತ್ತ್ಯಾ ಡೊನಿತ್ ಚಡ್ಲಿ, ಅನಿ ತಸೆಚ್ ತೆಕಾ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ದುಸ್ರ್ಯಾ ಢೊನಾಬಿ, ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ತೆನಿ ಜಾತಾನಾ, ಎಕಾಎಕಿಚ್ ಸಮುಂದರಾತ್ ಮೊಟೊ ವಾರೊ ಉಟ್ಲೊ, ಅನಿ ಪಾನಿಯಾಚಿ ಲ್ಹಾಟಾ ಮಾರುನ್, ಢೊನಿತ್ ಪಾನಿ ಭರುನ್,ಢೊನ್ ಬುಡುಕ್‍ಲಾಗಲ್ಲಿ, ");
INSERT INTO kans_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ಖರೆ ಜೆಜು, ಢೊನಿತ್, ಫಾಟಿಕ್ಡೆ ಉಶ್ಯಾ ವರ್‍ತಿ ಟಕ್ಲೆ ಥವ್ನ್ ಘೆವ್ನ್ ನಿಜಲ್ಲೊ. ಶಿಸಾನಿ ತೆಕಾ ಉಟ್ವುಲ್ಯಾನಿ, ಅನಿ “ಗುರುಜಿ, ಅಮಿ ಮರುನ್ ಗೆಲ್ಲ್ಯಾರ್‍ಬಿ, ತುಕಾ ಕಾಯ್ ಪರ್ವಾ ನಾ ಕಾಯ್?” ಮನುನ್ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ಜೆಜುನ್ ಉಟುನ್, ವಾರ್ಯಾಕ್ ಆಜ್ಞಾ ಕರುನ್ “ಗಪ್ ರ್‍ಹಾಮ್!” ಮಟ್ಲ್ಯಾನ್. ಅನಿ ಸಮುಂದರಾಚ್ಯಾ ಲ್ಹಾಟಾಕ್ನಿ “ಹಾಲುನಕಾಸಿ!” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೊ ಮೊಟೊ ವಾರೊ ಬಂದ್ ಹೊಲೊ. ಅನಿ ಸಗ್ಳೆ ಶಾಂತ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ಲ್ಯಾ ಶಿಸಾಕ್ನಿ “ತುಮಿ ಕಶ್ಯಾಕ್ ಭಿವ್‍ಲ್ಯಾಶಿ? ತುಮ್ಕಾ ಅಜುನ್ಬಿ ವಿಶ್ವಾಸ್‍ ನಾ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ತೆನಿ ಲೈ ಭಿಂವ್ನ್ ಗೆಲ್ಲೆ, ಅನಿ ಎಕಾಮೆಕಾಕ್ “ಹ್ಯೊ ಮಾನುಸ್ ಕೊನ್? ವಾರೊ ಅನಿ ಲ್ಹಾಟಾಸೈತ್ ಹೆನಿ ಸಾಂಗಟಲ್ಲೆ ಅಯಿಕ್ತ್ಯಾತ್!”ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ಜೆಜು, ಅನಿ ತೆಚಿ ಶಿಸಾ, ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್, ಗೆರಸೆನಾಂಚ್ಯಾ ಪ್ರಾಂತ್ಯಾಕ್ ಯೆವ್ನ್ ಪಾವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ಜೆಜು, ಢೊನಿತ್ನಾ ಉತ್ರುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಎಕ್ ಮಾನುಸ್ ಮಸಂಕಿತ್ನಾ ಭಾಯ್ರ್ ಯೆಲೊ, ಅನಿ ಜೆಜುಕ್ ಭೆಟ್ಲೊ. ತ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಆಂಗಾತ್ ಗಿರೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ತೊ, ತ್ಯಾ ಮಸಂಕಿತುಚ್ ರ್‍ಹಾಯ್, ತೆಕಾ ಸರ್‍ಪೊಳ್ಯಾನಿ ಭಾಂದುನ್ ಘಾಲುಕ್ ಕೊನಾಚ್ಯಾನ್‍ಬಿ ಹೊಯ್ನಶಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ಲೈಂದಾ ಸರ್‍ಪೊಳ್ಯಾನಿ, ತೆಚೆ ಹಾತ್-ಪಾಯ್ ಭಾಂದ್ಲ್ಯಾನಿ, ಖರೆ, ತೊ, ಸಗ್ಳೆಂದಾ ಸರ್ಪೊಳ್ಯಾ ತೊಡಿ, ಅನಿ ಪಾಂಯಾಕ್ನಿ ಘಾಟಲ್ಲ್ಯಾ ಬೆಡಿಯ್ಯಾ, ತೊಡುನ್ ಟಾಕಿ, ತೆಕಾ ಲೈ ಬಳ್ ಹೊತ್ತೊ. ತಸೆ ಮನುನ್, ತೆಕಾ ಸಂಬಾಳುಕ್ ಕೊನಾಕ್ಬಿ ಹೊಯ್ನಶಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ತೊ ಮಾನುಸ್, ರಾತ್ -ದಿಸ್ ಸಮಾದ್ಯಾತ್ನಿ ಅನಿ ಮಡ್ಡ್ಯಾಂಚ್ಯಾ ವೈನಿ ಎಕ್‍ ನಮುನಿ ವದ್ರುನ್ಗೆತ್ ಫಿರಿ, ಅನಿ ಅಪ್ನಾಕುಚ್, ಗುಂಡ್ಯಾನಿ ಮಾರುನ್ ಘೆವ್ನ್, ದುಕ್ಕಾ ಕರುನ್ ಘೆಯ್. ");
INSERT INTO kans_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ತೆನಿ, ಧುರ್‍ನಾಚ್ ಜೆಜುಕ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ಪಳುನ್ ಯೆವ್ನ್, ಜೆಜುಚ್ಯಾ ಇದ್ರಾಕ್ ಡೊಗ್ಲಾ ಘಾಟ್ಲ್ಯಾನ್, ಅನಿ ");
INSERT INTO kans_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“ಜೆಜು ಪರಮೊನ್ನತ್ ದೆವಾಚ್ಯಾ ಲೆಕಾ! ತಿಯಾ ಮಾಜ್ಯಾ ಖಬ್ರೆಕ್ ಕಶ್ಯಾಕ್ ಯೆಲೆ? ತಿಯಾ, ಮಾಕಾ ಶಿಕ್ಷಾ ದಿವ್‍ನಕೊ, ಮನುನ್ ದೆವಾಚ್ಯಾ ನಾಂವಾನ್, ಮಿಯಾ ತುಜ್ಯಾಕ್ಡೆ ಮಾಗ್ತಾ!” ಮನುನ್ ಬೊಬ್ ಮಾರುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ “ಗಿರೊ! ಹ್ಯಾ ಮಾನ್ಸಾತ್ನಾ ಭಾಯ್ರ್ ಪಡ್” ಮನುನ್, ಜೆಜುನ್ ತೆಕಾ ಮಟ್ಲ್ಯಾನ್, ತಸೆ ಮನುನ್, ತೆನಿ ಅಶೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ತೆಚೆಸಾಟ್ನಿ ಜೆಜುನ್ ತೆಕಾ “ತುಜೆ ನಾವ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತ್ಯಾ ಮಾನ್ಸಾನ್ “ಮಾಜೆ ನಾವ್ ಗಿರ್‍ಯಾಂಚೊ ತಾಂಡೊ” “ಅಮಿ ಲೈಜಾನಾ ಹಾಂವ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ಅನಿ ತೊ, ಗಿರ್‍ಯಾಕ್ನಿ ತ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ನಾ ಭಾಯ್ರ್ ಘಾಲುನಕೊ ಮನುನ್ ಜೆಜುಕ್ಡೆ ಮಾಗುಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ಥೈ ಜಗ್ಗೊಳುಚ್ ಹೊತ್ತ್ಯಾ, ಮಡ್ಡಿ ವರ್‍ತಿ ಡುಕ್ರಾಂಚೊ ಎಕ್ ಮೊಟೊ ತಾಂಡೊ ಚರುಕ್ ಲಾಗಲ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ತ್ಯಾ ಗಿರ್‍ಯಾನಿ “ಅಮ್ಕಾ ತ್ಯಾ ಡುಕ್ರಾಂಚ್ಯಾ ಆಂಗಾತ್ನಿ ಜಾವ್ಕ್ ಸೊಡ್, ಅನಿ ಅಮಿ ತೆಂಚ್ಯಾ ಭುತ್ತುರ್ ಗುಸ್ತಾಂವ್ ” ಮನುನ್ ಜೆಜುಕ್ಡೆ ಮಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ತೆನಿ ತೆಂಕಾ, ಜಾವ್ಕ್ ಸೊಡ್ಲ್ಯಾನ್, ತಿ ಗಿರೊ, ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಸೊಡುನ್, ಡುಕ್ರಾಂಚ್ಯಾ ಆಂಗಾತ್ನಿ ಜಾವ್ನ್ ಗುಸ್ಲಿ, ಅನಿ ಸುಮಾರ್ ದೊನ್ ಹಜಾರ್ ಡುಕ್ರಾಂಚೊ, ಸಗ್ಳೊ ತಾಂಡೊ ಸಮುಂದರಾತ್ ಹುಡಿ ಮಾರುನ್ ಬುಡುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ಡುಕ್ರಾ ಚಾರ್‍ವುತಲ್ಯಾನಿ, ಪಳುನ್ ಜಾವ್ನ್ ಶಾರಾತ್, ಅನಿ ಶೆತಾತ್ನಿ, ಹಿ ಖಬರ್ ಫರ್ಗಟ್ಲ್ಯಾನಿ, ತನ್ನಾ ಲೊಕಾ, ಕಾಯ್ ಹೊಲೆ ಮನುನ್ ಬಗುಕ್, ಥೈ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ತೆನಿ, ಜೆಜುಕ್ಡೆ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತ್ಯಾ ಗಿರ್‍ಯಾಂಚೊ ತಾಂಡೊ ಲಾಗಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಬಗಟ್ಲ್ಯಾನಿ, ತೊ ಥೈ ಬಸಲ್ಲೊ, ತೆನಿ ಬರೆ ಕಪ್ಡೆ ನೆಸಲ್ಲ್ಯಾನ್, ತೊ ಬರ್‍ಯಾ ಬುದ್ದಿನಿ ಬಸಲ್ಲೊ; ಅನಿ ತೆನಿ, ಸಗ್ಳೆ ಜಾನಾ ಭಿಂವ್ನ್ ಗೆಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ಥೈ ಕಾಯ್ ಹೊಲ್ಲೆ ಬಗಟಲ್ಲ್ಯಾನಿ, ತ್ಯಾ ಗಿರೊಲಾಗಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಕಾಯ್ ಹೊಲೆ, ಅನಿ ಡುಕ್ರಾಂಚಿ ಖಬರ್ ಕಾಯ್ ಹೊಲಿ, ಮನುನ್ ಲೊಕಾಕ್ನಿ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ತಸೆ ಮನುನ್, ತ್ಯಾ ಲೊಕಾನಿ, ಜೆಜುಕ್ ತೆಂಚೆ ಪ್ರಾಂತ್ಯ್ ಸೊಡುನ್ ಜಾವ್ಚೆ ಮನುನ್, ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ಜೆಜು ಢೊನಿತ್ ಚಡ್ತಾನಾ, ಗಿರೆ ಸುಟುನ್ ಬರೊ ಹೊಲ್ಲೊ ಮಾನುಸ್, ಜೆಜುಕ್ “ಮಿಯಾ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆತಾ” ಮನುನ್ ಮಾಗುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ಖರೆ, ಜೆಜು ಕಬುಲ್ ಹೊವ್ಕ್ ನಾ, ತೆಕಾ “ತಿಯಾ ತುಜ್ಯಾ ಘರಾಕ್ ಜಾ, ತುಜ್ಯಾ ಘರ್‍ಚ್ಯಾ ಲೊಕಾಕ್ನಿ, ದೆವಾನ್ ಅಪ್ನಾಚ್ಯಾ ಮೊಟ್ಯಾ ದಯೆನ್, ತುಕಾ ಕಾಯ್ ಕರ್‍ಲ್ಯಾನ್, ಮನುನ್ ಸಾಂಗ್” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ತಸೆ ಮನುನ್, ತೊ ಮಾನುಸ್ ಗೆಲೊ, ಅನಿ ಜೆಜುನ್ ಅಪ್ನಾಕ್ ಕಾಯ್ ಕರ್‍ಲ್ಯಾನ್ ಮನುನ್, ಧಾ ಶಾರಾತ್ನಿ ಸಾಂಗುನ್ಗೆತ್ ಗೆಲೊ, ಹೆ ಆಯ್ಕಲ್ಲಿ ಲೊಕಾ ಅಜಾಪ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ಜೆಜು, ಅನಿ ಪರ್ತುನ್ ಢೊನಾತ್ನಾ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಗೆಲೊ, ಥೈ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆರುಚ್ ಲೊಕಾಂಚೊ ಎಕ್ ಮೊಟೊ ತಾಂಡೊ ಜೆಜುಚ್ಯಾ ಭೊತ್ಯಾನಿ ಗೊಳಾ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ಎಕ್ಲೊ ಸಿನಾಗೊಗಾಚೊ ಅದಿಕಾರ್‍ಯಾ ಹೊತ್ತೊ, ತೆಚೆ ನಾವ್ ಜಾಯಿರ್ ತೊ ಜೆಜು ಹೊತ್ತ್ಯಾಕ್ಡೆ ಯೆಲೊ, ಅನಿ ಜೆಜುಚ್ಯಾ ಪಾಂಯಾತ್ ಪಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ಅನಿ “ಮಾಜಿ ಅಪುರ್ಬಾಯೆಚಿ ಲೆಕ್ ಶಿಕ್ ಹಾಯ್, ದಯಾ ಕರುನ್ ತಿಯಾ ಯೆವ್ನ್, ತಿಚ್ಯಾ ವರ್‍ತಿ ಹಾತ್ ಥವ್, ಹೆಚ್ಯಾನಿ, ತಿ ಬರಿ ಹೊತಾ, ಅನಿ ತಿ, ಹುರ್ತಾ” ಮನುನ್ ಲೈ ಮಾಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ಜೆಜು ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲೊ, ಸುಮಾರ್ ಲೊಕಾ, ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾವ್‍ಲಾಗಲ್ಲಿ. ಅನಿ ತೆಚ್ಯಾ ಭೊತ್ಯಾನಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ಥೈ, ಬಾರಾ ವರ್ಸಾಕ್ನಾ, ರಗಾತ್-ಜಾತಲೊ ರೊಗ್ ಹೊತ್ತಿ, ಎಕ್ ಬಾಯ್ಕೊಮನುಸ್ ಹೊತ್ತಿ, ");
INSERT INTO kans_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ತೆನಿ, ಲೈ ಕಸ್ಟ್ ಸೊಸಲ್ಲಿನ್, ಸಗ್ಳ್ಯಾ ವಗ್ದುಳ್ಯಾನಿಕ್ನಿ, ತಿ ಗೆಲಿ, ಖರೆ, ಕಾಯ್ಬಿ ಪ್ರಯೊಜನ್ ಹೊವಕ್ನಾ. ತಿಚೆಕ್ಡೆ ಹೊತ್ತೆ, ಸಗ್ಳೆ ಪೈಸೆ ತೆನಿ ಸಾರ್ಲಿನ್, ಖರೆ, ತಿಚೊ ರೊಗ್ ಅನಿ ಉಲ್ಲೊ ಜಾಸ್ತಿಚ್ ಹೊಯ್, ಖರೆ, ಕಮಿ ಹೊಯ್ನಶಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ತಿಕಾ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಖಬರ್ ಗಾವ್ಲಿ, ಅನಿ ತಿ ಮಿಯಾ ತೆಜೆ ಕಪ್ಡೆ ಅಪಡ್ಲ್ಯಾರ್ ಫಿರೆ ಆರಾಮ್ ಹೊತಾ ಮನುನ್ ಚಿಂತುನ್ , ತೆಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತ್ಯಾ ತಾಂಡ್ಯಾತ್ ಯೆವ್ನ್ ಗುಸ್ಲಿ, ");
INSERT INTO kans_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ಅನಿ ತೆನಿ, “ಮಿಯಾ ಜೆಜುಚ್ಯಾ ಫಾಳಿಯಾಕ್ನಿ ಹಾತ್‍ಲಾವ್ಲೊ ತರ್, ಮಿಯಾ ಹ್ಯಾ ರೊಗಾತ್ನಾ ಬರಿ ಹೊತಾ” ಮನುನ್ ಯವಜ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ತೆನಿ, ಜೆಜುಚ್ಯಾ ಫಾಳ್‍ಯಾಕ್ನಿ ಹಾತ್‍ಲಾವಲ್ಲ್ಯಾ ತನ್ನಾಚ್, ತಿಚೆ, ರಗಾತ್‍ ಜಾತಲೆ, ಬಂದ್‍ಹೊಲೆ. ತಿಕಾ, ಅಪ್ನಿ ಆರಾಮ್ ಹೊವ್ನ್, ಹ್ಯಾ ಕಸ್ಟಾತ್ನಾ ಭಾಯ್ರ್ ಪಡ್ಲೊ, ಮನುನ್ ಕಳ್ಳೆ. ");
INSERT INTO kans_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ತನ್ನಾಚ್ ಜೆಜುಕ್ ಅಪ್ನಾತ್ನಾ, ಬಳ್ ಭಾಯ್ರ್ ಗೆಲೊ, ಮನುನ್ ಕಳ್ಳೆ, ತನ್ನಾ, ಫಾಟಿ ಪರ್ತುನ್ ತಾಂಡ್ಯಾಕ್ ಬಗುನ್,“ಮಾಜ್ಯಾ ಫಾಳ್‍ಯಾಕ್ನಿ ಕೊನ್ ಅಪಡ್ಲೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ತನ್ನಾ ಶಿಸಾನಿ, “ಸಗ್ಳಿ ಲೊಕಾ ತುಜ್ಯಾ ಆಂಗಾರ್ ಯೆವ್ನ್ ಪಡುಲ್ಯಾತ್, ಅನಿ ತುಕಾ ಕೊನ್ ಹಾತ್‍ಲಾವ್ಲ್ಯಾನಿ ಮನುನ್, ಇಚಾರುಲೆ ಅನಿ?” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ಖರೆ, ಜೆಜು ಅನಿಬಿ, ಮಾಕಾ ಕೊನ್ ಹಾತ್‍ಲಾವ್ಲೆ, ಮನುನ್ ಹುಡ್ಕುನ್ಗೆತುಚ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ಅಪ್ನಾಕ್ ಅರಾಮ್ ಹೊಲ್ಲೆ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಕಳಲ್ಲೆ, ತಸೆ ಮನುನ್ ಭಿಂವುನ್ ಕಾಪುಂಗೆತ್ ತಿ ಬಾಯ್ಕೊಮನುಸ್ ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್ ತೆಚ್ಯಾ ಪಾಂಯಾತ್ ಪಡ್ಲಿ, ಅನಿ ಅಪ್ನಾಕ್ ಖರೆಚ್ ಕಾಯ್-ಕಾಯ್ ಹೊಲೆ ತೆ ಸಗ್ಳೆ ತೆನಿ ಜೆಜುಕ್ ಸಾಂಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ತನ್ನಾ ಜೆಜುನ್ “ಬಾಯಿ! ತುಜ್ಯಾ ವಿಶ್ವಾಸಾನ್ ತಿಯಾ ಅರಾಮ್ ಹೊಲೆ, ಸಮಾದಾನಾನ್ ಜಾ ಅನಿ ತುಜೊ ಕಸ್ಟ್ ಸರ್ಲೊ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ಅಶೆ ಜೆಜು ಬೊಲುನ್ಗೆತ್ ರಾತಾನಾ ಜಾಯಿರಾಚ್ಯಾ ಘರಾಕ್ನಾ ಥೊಡ್ಯಾ ಲೊಕಾನಿ ಯೆವ್ನ್ ಜಾಯಿರಾಕ್ “ಅತ್ತಾ ತುಜಿ ಲೆಕ್ ಮರ್ಲಿ ಅನಿ ತಿಯಾ ಗುರುಜಿಕ್ ತರಾಸ್ ಕರುಕ್ ನಕ್ಕೊ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ಖರೆ ಜೆಜುನ್ ತೆನಿ ಸಾಂಗ್ತಾಲ್ಲ್ಯಾಕ್ ಧ್ಯಾನ್ ದಿವ್ನಸ್ತಾನಾ ತ್ಯಾ ಅದಿಕಾರ್‍ಯಾ “ತಿಯಾ ಕಾಯ್ ಭಿಂವ್‍ನಕೊ, ವಿಶ್ವಾಸಾನ್ ರ್‍ಹಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ತನ್ನಾ ಪೆದ್ರು, ಜಾಕೊಬ್ ಅನಿ ತೆಚ್ಯಾ ಭಾವಾ ಜುವಾಂವಾಕ್ ಸೊಡುನ್ ಕೊನಾಕ್ಬಿ ಅಪ್ನಾಚ್ಯಾ ವಾಗ್ಡಾ ಯೆವ್ಕ್ ದಿವ್ಕನಾ. ");
INSERT INTO kans_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ತೆನಿ ಜಾಯಿರಾಚ್ಯಾ ಘರಾಕ್ ಯೆಲೆ, ಥೈ ಲೊಕಾ ಜೊರಾನಿ ರಡ್ತಲೆ ಅನಿ ಗೊಳಾಡ್ತಲೆ ಜೆಜುನ್ ಬಗಟ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ಜೆಜು ತ್ಯಾ ಘರಾತ್ ಭುತ್ತುರ್ ಗೆಲೊ ಅನಿ ತ್ಯಾ ರಡ್ತಲ್ಯಾ ಲೊಕಾಕ್ನಿ “ಅರೆ! ತುಮಿ ಕಶ್ಯಾಕ್ ರಡುಲ್ಯಾಸಿ? ಎವ್ಡಿ ಲೈ ಧಾಂದಲ್ ಕಶ್ಯಾಕ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ? ತೆ ಚೆಡು ಮರುಕ್ನಾ, ನಿದ್ಲಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ಜೆಜು ಅಶೆ ಸಾಂಗ್ತಲೆ ಆಯ್ಕುನ್; ಲೊಕಾ ಜೆಜುಕ್ ಬಗುನ್ ಹಾಸುಕ್ ಲಾಗ್ಲಿ. ಜೆಜುನ್ ಥೈ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಭಾಯ್ರ್ ಧಾಡ್ಲ್ಲ್ಯಾನ್ ಅನಿ ತ್ಯಾ ಚೆಡ್ವಾಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ ಅನಿ ಅಪ್ಲ್ಯಾ ಶಿಸಾಕ್ನಿ ಘೆವ್ನ್, ತ್ಯಾ ಚೆಡ್ವಾಕ್ ನಿಜ್ವಲ್ಲ್ಯಾ ಖೊಲಿತ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ಥೈ ಜೆಜು ಫಿಡೆ ಗೆಲೊ ಅನಿ ತ್ಯಾ ಚೆಡ್ವಾಚೊ ಹಾತ್ ಧರುನ್ “ತಾಲಿಥಾಕುಮ್” ಮಟ್ಲ್ಯಾನ್ ತಸೆ ಮಟ್ಲ್ಯಾರ್ “ಚೆಡ್ವಾ ಮಿಯಾ ತುಕಾ ಉಟ್ ಮನುಲಾ”. ");
INSERT INTO kans_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ತನ್ನಾ ತೆ ಚೆಡು ಉಟ್ಲೆ ಅನಿ ಫಿರುನ್-ಖೆಳುಕ್ ಲಾಗ್ಲೆ ಬಾರಾ ವರ್ಸಾಚೆ ಚೆಡು ಹೊತ್ತೆ ತೆ. ಹೆ ಬಗುನ್ ತೆನಿ ಅಜಾಪ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ಮಾನಾ ಜೆಜುನ್ ಹಿ ಖಬರ್ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕಾಸಿ ಮನುನ್ ತೆಂಕಾ ಖಡಕ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್ ಅನಿ “ತ್ಯಾ ಚೆಡ್ಬಾಕ್ ಕಾಯ್ ತರ್ ಖಾವ್ಕ್ ದಿವಾ”,ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ತೊ ಜಾಗೊ ಸೊಡುನ್ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಘೆವ್ನ್ ಅಪ್ನಾಚ್ಯಾ ಸ್ವಂತ್ ಗಾವಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಸಿನಾಗೊಗಾತ್ ಜೆಜು ಸಿಕ್ವುಕ್ಲಾಗ್ಲೊ. ಥೈ, ಲೈ ಲೊಕಾ ಹೊತ್ತಿ. ಲೊಕಾ ತೆಚಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುನ್ ಅಜಾಪ್ ಹೊಲಿ, ಅನಿ ತೆನಿ “ಹ್ಯಾ ಗೊಸ್ಟಿಯಾ ಹೆಕಾ ಖೈತ್ನಾ ಗಾವ್ಲ್ಯಾ? ಹೆಕಾ ಕಸ್ಲೆ ಜ್ಞಾನ್ ದಿಲ್ಲೆ ಹಾಯ್? ಅನಿ ಹ್ಯೊ ಅಜಾಪಾ ಕಸೆ ಕರುನ್ ಕರ್‍ತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“ಮರಿಚೊ ಲೆಕ್ ಬಡಗಿ ನ್ಹಯ್ ಕಾಯ್ ಹ್ಯೊ? ಹೆಚೆ ಭಾವ್ ಜಾಕೊಬ್, ಜುಜೆ, ಜುದಾಸ್ ಅನಿ ಸಿಮಾವ್. ಹೆಚ್ಯಾ ಭೆನಿಯಾ ಹಿತ್ತೆಚ್ ರಾಯ್ನಾತ್ ಕಾಯ್?” ಅಶೆ ಮನುನ್ ತೆನಿ ಜೆಜುಕ್ ಅವ್ಮಾನ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ಜೆಜುನ್ ತೆಂಕಾ “ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಸಾಂಗ್ತಲ್ಯಾಕ್, ಅಪ್ನಾಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಗಾಂವಾತ್, ಅಪ್ನಾಚ್ಯಾ ಲೊಕಾತ್ನಿ ಅನಿ ತೆಚಾ ಪಾವ್ನ್ಯಾ-ಸೊಯ್ರ್ಯಾತ್ನಿ ಸೊಡುನ್ ದುಸ್ರ್ಯಾಕ್ಡೆ ಲೈ ಮಾನ್ ಗಾವ್ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ಎಕ್ ಉಲ್ಲ್ಯಾ ಶಿಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿ ಹಾತ್ ಥವ್ನ್ ತೆಂಚಿ ದುಖ್ನಿ ಬರೆ ಕರಲ್ಲೆ ಸೊಡುನ್ ಜಾಸ್ತಿಚಿ ಅಜಾಪಾ ಜೆಜುಕ್ ತ್ಯಾ ಗಾಂವಾತ್ ಕರುಕ್ ಹೊವ್ಕ್ ನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ವಿಶ್ವಾಸ್ ನತ್ತೊ, ");
INSERT INTO kans_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ತ್ಯಾ ಲೊಕಾಕ್ನಿ ವಿಶ್ವಾಸ್ ನಸಲ್ಲೆ ಬಗುನ್ ಜೆಜು ಅಜಾಪ್ ಹೊಲೊ. ತನ್ನಾ ಜೆಜು ಅಜು-ಬಾಜುಚ್ಯಾ ಗಾಂವಾತ್ನಿ ಗೆಲೊ ಅನಿ ಸಿಕ್ವುಕ್ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ಜೆಜುನ್ ಎಕ್ ದಿಸ್ ಬಾರಾ ಜಾನಾ ಶಿಸಾಕ್ನಿ ಎಕಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್ ಅನಿ ದೊಗ್ಯಾ-ದೊಗ್ಯಾಕ್ನಿ ವಾಂಗಡ್ ಕರುನ್ ಧಾಡ್ಲ್ಯಾನ್ ಅನಿ ತೆಂಕಾ ಗಿರ್‍ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ಅದಿಕಾರ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ಅನಿ ತೆನಿ ತೆಂಕಾ “ ತುಮಿ ಜಾತಾನಾ ವಾಟೆಕ್ ತುಮ್ಚ್ಯಾ ಹಾತಾತ್ಲೆ ದಾಂಡೆ ಸೊಡುನ್ ಕಾಯ್ಬಿ ಘೆವ್‍ನಕಾಶಿ. ಭಾಕ್ರಿ ಹೊಂವ್ದಿ,ಪಿಸ್ವಿ ಹೊಂವ್ದಿ ,ತುಮ್ಚ್ಯಾ ಕಿಶ್ಯಾತ್ನಿ ಪೈಸೆ ಸೈತ್ ಘೆವ್‍ನಕಾಶಿ”. ");
INSERT INTO kans_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ಪಾಂಯಾತ್ನಿ ವ್ಹಾನಾ ಘಾಲುನ್ ಘೆವಾ ಖರೆ ಆಂಗಾ ವಯ್ಲೆ ಸೊಡುನ್,ಅನಿ ಕಪ್ಡೆ ಸೈತ್ ಘೆವ್‍ನಕಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ಅನಿ ತೆನಿ ತೆಂಕಾ “ಖಲ್ಯಾ ಘರಾತ್ ತುಮ್ಕಾ ಸ್ವಾಗತ್ ಕರ್‍ತ್ಯಾತ್, ತೆ ಗಾಂವ್ ಸೊಡುನ್ ಜಯ್ ಸಗೊಳ್ ತುಮಿ ತ್ಯಾಚ್ ಘರಾತ್ ರ್‍ಹಾವಾ. ");
INSERT INTO kans_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ಅನಿ ಖಲ್ಯಾಬಿ ಗಾವಾತ್ಲ್ಯಾ ಲೊಕಾನಿ ತುಮ್ಕಾ ಸ್ವಾಗತ್ ಕರಿನಸ್ತಾನಾ,ತುಮಿ ಸಾಂಗಲ್ಲೆ ಆಯ್ಕುನಸ್ಲ್ಯಾರ್, ತುಮ್ಚ್ಯಾ ತಳ್‍ಪಾಂಯಾಂಚಿ ಧುಳ್ ಫಾಪ್ಡಾ ಅನಿ ತೆ ಗಾಂವ್ ಸೊಡುನ್ ಜಾಂವಾ, ಹೆ ತೆಂಕಾ ಎಕ್ ಉಶಾರ್ಕಿ ಹೊಂವ್ದಿ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ಹೆಚೆ ಸಾಟ್ನಿ ತೆನಿ ಭಾಯ್ರ್ ಗಾಂವಾತ್ನಿ ಗೆಲ್ಯಾನಿ ಅನಿ ತೆನಿ ಲೊಕಾಕ್ನಿ ತುಮಿ ಪಾಪ್ ಕರ್‍ತಲೆ ಸೊಡಾ ಮನುನ್ ಸಾಂಗುಕ್ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ತೆನಿ ಸುಮಾರ್ ಲೊಕಾಂಚಿ ಗಿರೆ ಕಾಡ್ಲ್ಯಾನಿ ಅನಿ ಆರಾಮ್ ನಸಲ್ಲ್ಯಾಕ್ನಿ ಒಲಿವ್ ತೆಲ್ ಲಾವ್ಲ್ಯಾನಿ ಅನಿ ತೆಂಕಾ ಆರಾಮ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ಹೆರೊದ್ ರಾಜಾನ್ ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಆಯ್ಕ್ಲ್ಯಾನ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಜೆಜುಚಿ ಖಬರ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಫರ್ಗಟಲ್ಲಿ. ಥೊಡೆಜಾನಾ “ಬಾಲ್ತಿಮ್‍ ದಿತಲೊ ಜುವಾಂವ್ ಮರಲ್ಲೊ ಅನಿ ಝಿತ್ತೊ ಹೊವ್ನ್ ಯೆಲಾ! ತಸೆ ಮನುನ್ ತೆಕಾ ಅಜಾಪಾ ಕರ್‍ತಲೊ ಬಳ್ ಹಾಯ್” ಮನುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ಅನಿ ಉಲ್ಲೆ ಜಾನಾ “ತೊ ಎಲಿಯಾ ಮನ್ತಲೊ ಪ್ರವಾದಿ” ಮನುಲಾಗಲ್ಲ್ಯಾನಿ. ಅನಿ ಹುರಲ್ಲೆ “ತೊ ಅದ್ಲ್ಯಾ ಕಾಲಾತ್ಲ್ಯಾ ಪ್ರವಾದ್ಯಾಂಚ್ಯಾ ಬಾಸೆನ್ ಎಕ್ ಪ್ರವಾದಿ” ಮನುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ಹೆರೊದಾನ್ ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ “ತೊ ಬಾಲ್ತಿಮ್‍ ದಿತಲೊ ಜುವಾಂವ್! ಮಿಯಾ ತೆಚೆ ಚಂಡ್ ತೊಡುಕ್ ಲಾವಲ್ಲೊ, ಖರೆ ತೊ ಅತ್ತಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಯೆಲಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ಹೆರೊದಾನ್ ಅಪ್ನಿಚ್ ಜುವಾಂವಾಕ್ ಧರುನ್ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಲುಕ್ ಸಾಂಗಟಲ್ಲ್ಯಾನ್. ಹೆರೊದಿಯಾಸಾಕ್ ಲಾಗುನ್ ತೆನಿ ಅಶೆ ಕರ್‍ತಲೆ ಪಡ್ಲೆ. ತಿ ಅಪ್ಲ್ಯಾ ಭಾವಾಚಿ-ಫಿಲಿಪ್ಪಾಚಿ ಬಾಯ್ಕೊ! ಜಾಲ್ಯಾರ್‍ಬಿ ತೊ ತಿಚೆಕ್ಡೆ ಲಗಿನ್ ಹೊಲ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ಜುವಾಂವ್ ಹೆರೊದಾಕ್ “ತಿಯಾ ತುಜ್ಯಾ ಭಾವಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಲಗಿನ್ ಕರುನ್ ಘೆವ್ನ್ ಥವ್ನ್ ಘೆಟಲ್ಲೆ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಸಮಾ ನ್ಹಯ್!” ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ತೆಚ್ಯಾ ಸಾಟ್ನಿ ಹೆರೊದಿಯಾಸಾಕ್ ಜುವಾಂವಾ ವರ್‍ತಿ ರಾಗ್ ಹೊತ್ತೊ, ತಿ ತೆಕಾ ಜಿವಾನಿ ಮಾರುಚೆ ಮನುನ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ಖರೆ ಹೆರೊದ್ ಭಿಂವ್ ಲಾಗಲ್ಲೊ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಜುವಾಂವ್ ಎಕ್ ಬರೊ ಅನಿ ಪವಿತ್ರ್ ಮಾನುಸ್ ಮನುನ್ ತೆಕಾ ಗೊತ್ತ್ ಹೊತ್ತೆ,ತಸೆ ಮನುನ್ ತೊ ತೆಕಾ ಕಾಯ್ಬಿ ತರಾಸ್ ಹೊವ್ಕ್ ದಿ ನಸಿ, ತೊ ಸಾಂಗ್ತಾನಾ ತೆಕಾ ತರಾಸ್ ಹೊಲ್ಯಾರ್ಬಿ, ತೊ ಕುಶಿನ್ ತೆಚೆ ಆಯ್ಕಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ಆಕ್ರಿಕ್, ಹೆರೊದಿಯಾಸಾಕ್ ಎಕ್ ಬರೊ ಅವ್ಕಾಸ್ ಗಾವ್ಲೊ, ಹೆರೊದಾನ್ ಅಪ್ನಾಚ್ಯಾ ಜಲ್ಮಾಚ್ಯಾ ದಿಸಿ, ಅಪ್ನಾಚ್ಯಾ ರಾಜಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಅದಿಕಾರ್‍ಯಾಕ್ನಿ, ಸೈನಿಕಾಂಚ್ಯಾ ಮುಖಂಡಾಕ್ನಿ ಅನಿ ಗಾಲಿಲಿಯಾಚ್ಯಾ ಮೊಟ್ಯಾ-ಮೊಟ್ಯಾ ಲೊಕಾಕ್ನಿ ಎಕ್ ಮೊಟೆ ಜೆವಾನ್ ಥವಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ತನ್ನಾ ಹೆರೊದಿಯಾಸಾಚ್ಯಾ ಲೆಕಿನ್ ಬರೆ ಕರುನ್ ನಾಚ್ಲಿನ್, ಹೆ ಬಗುನ್ ರಾಜಾಕ್ ಅನಿ ಯೆಲ್ಲ್ಯಾ ಸಯ್ರ್ಯಾಕ್ನಿ ಲೈ ಕುಶಿ ಹೊಲಿ. ತೆಚೆ ಸಾಟ್ನಿ ರಾಜಾನ್ ಚೆಡ್ವಾಕ್ “ತುಕಾ ಕಾಯ್ ಪಾಜೆ ಮಾಗ್, ಮಿಯಾ ತುಕಾ ದಿತಾ,” ");
INSERT INTO kans_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ಅನಿ ಆನ್ ಘಾಲುನ್ “ಮಿಯಾ ತುಕಾ ಕಾಯ್ ಪಾಜೆ ತೆ, ಮಾಜ್ಯಾ ರಾಜಾತ್ಲಿ ಅರ್ದಿ ಅಸ್ತಿ ಮಾಗ್ಲ್ಯಾರ್ಬಿ ದಿತಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ತನ್ನಾ ತೆ ಚೆಡು ಅಪ್ಲ್ಯಾ ಬಾಯ್‍ಕ್ಡೆ ಗೆಲೆ ಅನಿ “ಬಾಯ್ ಮಿಯಾ ಕಾಯ್ ಮಾಗುಚೆ?” ಮುನುನ್ ಇಚಾರ್‍ಲಿನ್. ತನ್ನಾ ತಿಚ್ಯಾ ಬಾಯ್ನ್. “ಬಾಲ್ತಿಮ್‍ದಿತಲ್ಯಾ ಜುವಾಂವಾಚೆ ಟಕ್ಲೆ ಮಾಗ್” ಮನುನ್ ಸಾಂಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ತನ್ನಾ ತ್ಯಾ ಚೆಡ್ವಾನ್ ಲಗ್ಗುನಾ ರಾಜಾಕ್ಡೆ ಜಾವ್ನ್ “ಅತ್ತಾಚ್ ಎಕ್ ತಾಟಾತ್ನಾ, ಬಾಲ್ತಿಮ್‍ದಿತಲ್ಯಾ ಜುವಾಂವಾಚೆ ಟಕ್ಲೆ ಮಾಕಾ ಹಾನುನ್ ದಿವಾ” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ಹೆ ಆಯ್ಕುನ್ ರಾಜಾಕ್ ಲೈ ಬೆಜಾರ್ ಹೊಲೊ,ಖರೆ ಯೆಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಬೊಲಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಚ್ಯಾ ಮುಲಾಜಾಕ್ ಪಡುನ್, ತೆಕಾ ತಿರಸ್ಕಾರ್ ಕರುಕ್ ಹೊವುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ತೆಚೆ ಸಾಟ್ನಿ ತೆನಿ “ಜುವಾಂವಾಚೆ ಟಕ್ಲೆ ಎಕ್ ಅಯ್ದಾನಾತ್ನಾ ತಿಕಾ ಹಾನುನ್ ದಿ” ಮನುನ್ ಅಪ್ಲ್ಯಾ ಸೈನಿಕಾಕ್ ಸಾಂಗ್ಲ್ಯಾನ್. ತನ್ನಾ ತ್ಯಾ ಸೈನಿಕಾನ್ ಜಾವ್ನ್ ಜುವಾಂವಾಚೊ ಚಂಡ್ ತೊಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ಅನಿ ಜುವಾಂವಾಚೆ ಟಕ್ಲೆ ಆಯ್ದಾನಾತ್ನಾ ಘೆವ್ನ್ ಯೆಲ್ಯಾನ್ ಅನಿ ತ್ಯಾ ಚೆಡ್ವಾಚ್ಯಾ ಹಾತಿತ್ ದಿಲ್ಯಾನ್. ತೆನಿ ತೆ ಅಪ್ಲ್ಯಾ ಬಾಯ್ಚ್ಯಾ ಹಾತಿತ್ ದಿಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ಹಿ ಖಬರ್ ಜುವಾಂವಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಗಾವ್ಲಿ, ತನ್ನಾ ತೆನಿ ತೆಚೆ ಮಡೆ ಘೆವ್ನ್ ಜಾವ್ನ್ ಸಮಾದಿತ್ ಥವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ಜೆಜುಚಿ ಅಪೊಸ್ತಲಾ ಪರ್ತುನ್ ಯೆವ್ನ್ ಜೆಜುಕ್ ಭೆಟ್ಲ್ಯಾನಿ, ಅನಿ ಅಪ್ನಿ ಕಾಯ್-ಕಾಯ್ ಕರ್‍ಲ್ಯಾನಿ ಅನಿ ಕಾಯ್-ಕಾಯ್ ಶಿಕ್ವುಲ್ಯಾನಿ ತೆ ಸಗ್ಳೆ ತೆನಿ ಜೆಜುಕ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ಲೈ ಲೊಕಾ ಯೆವ್ನ್ಗೆತ್-ಜಾವ್ನ್ಗೆತ್ ಹೊತ್ತಿ ಜೆಜುಕ್ ಅನಿ ತೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಜೆವಾನ್ ಕರುಕ್ ಸೈತ್ ಎಳ್ ನತ್ತೊ. ತಸೆ ಮನುನ್ ಜೆಜುನ್ ತೆಂಕಾ “ಚಲಾ ಅಮ್ಚ್ಯಾ ಎವ್ಡ್ಯಾಕ್ ಅಮಿ ಎಕ್ ಲೊಕಾನಸಲ್ಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಜಾಂವಾ, ತನ್ನಾ ತುಮ್ಕಾ ಉಲ್ಲೆ ಆರಾಮ್ ಘೆವ್ಕ್ ಹೊತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ತನ್ನಾ ತೆನಿ ಎಕ್ ಢೊನಿತ್ ಚಡುನ್ ಕೊನ್ಬಿ ನಸಲ್ಲ್ಯಾ ಶಾಂತ್ ಜಾಗ್ಯಾಕ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ಹೆ ಸುಮಾರ್ ಲೊಕಾಕ್ನಿ ಗೊತ್ತ್ ಹೊವ್ನ್ ಸಗ್ಳ್ಯಾ ಶಾರಾನಿತ್ನಾ ಪಾಯ್ ವಾಟಾನಿ ಹೊವ್ನ್ ಜೆಜು ಅನಿ ಶಿಸಾಂಚ್ಯಾ ಅದ್ದಿ ಲೊಕಾಚ್ ಥೈ ಜಾವ್ನ್ ಪಾವ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ಢೊನಿತ್ನಾ ಉತ್ರುನ್ ಯೆತಾನಾ ಜೆಜುನ್ ಹ್ಯೊ ಮೊಟೊ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಬಗಟ್ಲ್ಯಾನ್. ತೆಂಚೊ ತೆಕಾ ಪಾಪ್ ದಿಸ್ಲೊ,ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ರಾಕ್ವಾಲಿನಸಲ್ಲ್ಯಾ ಬಕ್ರ್ಯಾಂಚ್ಯಾ ಬಾಸೆನ್ ಹೊತ್ತೆ,ತಸೆ ಮನುನ್ ತೊ ತೆಂಕಾ ಸುಮಾರ್ ವಿಶಯ್ ಶಿಕ್ವುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ಎಳ್ ಹೊಂವ್ನ್ಗೆತ್ ಯಲ್ಲ್ಯಾತನ್ನಾ ಶಿಸಾನಿ “ಅದ್ದಿಚ್ ಎಳ್ ಹೊಲಾ, ಹ್ಯೊ ಬಗ್ಲ್ಯಾರ್ ಕೊನ್ನಸಲ್ಲೊ ಜಾಗೊ ");
INSERT INTO kans_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ದಿ, ತೆನಿ ಜಗೊಳ್ಲ್ಯಾ ಗಾಂವಾತ್ನಿ, ಶೆತಾತ್ನಿ ಜಾಂವ್ದಿ ಅನಿ ತೆಂಕಾ ಕಾಯ್ತರ್ ಖಾವ್ಕ್ ಇಕಾತ್ ತರ್ಬಿ ಘೆಂವ್ದಿತ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ತನ್ನಾ ಜೆಜುನ್ “ತುಮಿಚ್ ತೆಂಕಾ ಜೆವಾನ್ ದಿವಾ ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ” ದೊನ್ಸೆ ಚಾಂದಿಚ್ಯಾ ಪೈಸ್ಯಾನಿ ತೆಂಕಾ ಖವ್ಕ್ ಬಾಕ್ರಿಯಾ ಹಾನುನ್ ದಿವ್ಚ್ಯೆ ಕಾಯ್? ಮಟ್ಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ತನ್ನಾ ಜೆಜುನ್ “ತುಮ್ಚ್ಯಾಕ್ಡೆ ಕವ್ಡಿ ಭಾಕ್ರಿಯಾ ಹಾತ್? ಮನುನ್ ಜಾವ್ನ್ ಬಗಾ” ಮಟ್ಲ್ಯಾನ್. ತೆನಿ ಬಗುನ್ ಯೆವ್ನ್“ಅಮ್ಚ್ಯಾಕ್ಡೆ ಪಾಂಚ್ ಭಾಕ್ರಿಯಾ ಅನಿ ದೊನ್ ಮಾಸೊಳ್ಯಾ ಹಾತ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ಜೆಜುನ್ ಅಪ್ಲ್ಯಾ ಶಿಸಾಕ್ನಿ “ಲೊಕಾಕ್ನಿ ಹಿಂರ್ವ್ಯಾಂ ಗವ್ತಾಚ್ಯಾ ವರ್‍ತಿ ತಾಂಡೆ-ತಾಂಡೆ ಕರುನ್ ಬಸ್ವಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ತಸೆ ಮನುನ್ ಲೊಕಾ ಶೆಂಬರ್ ಅನಿ ಪನ್ನಾಸ್ ಲೊಕಾಂಚೆ ತಾಂಡೆ ಕರುನ್ ಘೆವ್ನ್ ಬಸ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ಮಾಗಿರ್ ಜೆಜುನ್ ಪಾಂಚ್ ಭಾಕ್ರಿಯಾ ಅನಿ ದೊನ್ ಮಾಸೊಳ್ಲ್ಯಾ ಘೆವ್ನ್ ವೈರ್ ಬಗ್ಲ್ಯಾನ್ ಅನಿ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಲ್ಯಾನ್ ಅನಿ ಮೊಡುನ್ ವಾಟಾ ಮನುನ್ ಶಿಸಾಂಚ್ಯಾ ಹಾತಾತ್ನಿ ದಿಲ್ಲ್ಯಾನ್, ಅನಿ ದೊನ್ ಮಾಸೊಳ್ಯಾಬಿ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಮೊಡುನ್ ದಿಲ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ಸಗ್ಳ್ಯಾನಿ ಪೊಟ್ಭರ್ ಜೆವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ಹುರಲ್ಲ್ಯಾ ಮಾಸೊಳ್ಯಾ ಅನಿ ಭಾಕ್ರಿಯಾ ಶಿಸಾನಿ ಗೊಳಾ ಕರ್ಲ್ಯಾರ್, ಬಾರಾ ಭುಟಿಯಾ ಭರ್‍ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ಥೈ ಸುಮಾರ್ ಪಾಂಚ್ ಹಜಾರ್ ಘೊಮಾನ್ಸಾಚ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಜೆಜುನ್ ಅಪ್ಲ್ಯಾ ಶಿಸಾಕ್ನಿ ಢೊನಿತ್ ಚಡುನ್ ತಿಕುಲ್ಲ್ಯಾ ದಂಡೆಕ್ ಬೆತ್ಸಾಯಿದಾ ಮನ್ತಲ್ಲ್ಯಾ ಗಾವಾಕ್ ಜಾವ್ಕ್ ಸಾಂಗ್ಲ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ಮಾನಾ ಜೆಜು ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ದಿವ್ನ್ ಮಾಗ್ನಿ ಕರುಕ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ದಿಸ್ ಬುಡಲ್ಲ್ಯಾ ತನ್ನಾ ಢೊನ್ ಸಮುಂದರಾಚ್ಯಾ ಮದ್ದಿ ಪಾವಲ್ಲಿ, ತನ್ನಾ ಜೆಜು ಎಕ್ಲೊಚ್ ದಂಡೆಕ್ ಹೊತ್ತೊ, ");
INSERT INTO kans_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ಶಿಸಾ ಸಮುಂದರಾತ್ ತರಾಸ್ ಕರುನ್ ಘೆತಲೆ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ವಾರ್ಯಾಚ್ಯಾ ವಿರೊದ್ ಆವ್ಲೊ ಮಾರಿತ್. ರಾಚ್ಚ್ಯಾ ತಿನ್ ಘಂಟ್ಯಾಕ್ನಾ ಸಾ ಘಂಟ್ಯಾಚ್ಯಾ ಮದ್ದಿ ತೊ ಪಾನಿಯಾ ವರ್‍ತಿ ಚಲುನ್ಗೆತ್ ತೆಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ತೆಂಕಾ ದಾಟುನ್ ಫಿಡೆ ಜವ್‍ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ತೊ ಪಾನಿಯಾ ವರ್‍ತಿ ಚಲ್ತಲೆ ಬಗುನ್ ತೆನಿ “ಅಬಕ್ ಭುತ್!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ತೆನಿ ತೆಕಾ ಬಗುನ್ ಭಿವ್ನ್ ಗೆಲ್ಲ್ಯಾನಿ, ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ಭಿಂವ್ನಕಾಸಿ, ಮಿಯಾಚ್ ತೊ, ಧೈರ್‍ಯಾನ್ ರ್‍ಹಾವಾ,” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ಮಾನಾ ತೊ ಢೊನಿತ್ ಚಡ್ಲೊ ತನ್ನಾ ವಾರೊ ಥಂಡ್ ಹೊಲೊ ತನ್ನಾ ತೆನಿ ಅಜಾಪ್ ಹೊಲೆ, ");
INSERT INTO kans_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ಪಾಂಚ್ ಹಜಾರ್ ಲೊಕಾಕ್ನಿ ಜೆವಾನ್ ದಿಲ್ಲ್ಯಾ ವಿಶಯಾಚೊ ಖರೊ ಅರ್ತ್‍, ತೆಂಕಾ ಹೊವ್ಕ್ ನತ್ತೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆಂಚಿ ಕಾಳ್ಜಾ ಘಟ್ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ತೆನಿ ಸಮುಂದರ್ ದಾಟುನ್ ಗೆನಜರೆತ್ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಯೆಲ್ಯಾನಿ, ಥೈ ತೆನಿ ಡೊನ್ ಭಾಂದ್ಲ್ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ತೆನಿ ಢೊನಿತ್ನಾ ಉತರ್ತಾನಾಚ್ ಲೊಕಾನಿ ಜೆಜುಚಿ ವಳಕ್ ಧರ್‍ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ಲೊಕಾನಿ ತ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಪಳುನ್ ತೊ ಖೈಯ್ ಹಾಯ್ ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ ಅನಿ ಥೈ ಹಾತ್ರಾನಾತ್ನಿ ನಿಜಲ್ಲ್ಯಾ ಶಿಕ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಹಾತ್ರಾನಾ ಸಮೆತ್ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ಜೆಜು ಖೈ-ಖೈ ಗೆಲೊ, ತ್ಯಾ ಗಾಂವಾತ್ನಿ, ಶಾರಾತ್ನಿ, ಶೆತಾತ್ನಿ, ಗೆಲೊ ತ್ಯಾ ಜಾಗ್ಯಾನಿತ್ಲ್ಯಾ ಬಾಜಾರಾತ್ನಿ ಶಿಕ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ ಅನಿ ತುಜೆ ಕಪ್ಡೆ ತರ್ಬಿ ಅಪ್ಡುಕ್ ತೆಂಕಾ ಅವ್ಕಾಸ್ ದಿ ಮನುನ್ ಮಾಗ್ಲ್ಯಾನಿ ಅನಿ ಕೊನ್-ಕೊನ್ ಅಪಡ್ಲ್ಲ್ಯಾನಿ ತೆನಿ ಆರಾಮ್ ಹೊಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ಥೊಡೆ ಫಾರಿಜೆವ್ ಅನಿ ಥೊಡೆ ಖಾಯ್ದೆ ಪಾಳ್ತಲೆ ಶಾಸ್ತ್ರಿ ಜೆರುಜಲೆಮಾತ್ನಾ ಜೆಜು ಹೊತ್ತ್ಯಾಕ್ಡೆ ಯೆವ್ನ್ ಜಮಾ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ತನ್ನಾ ಜೆಜುಚಿ ಶಿಸಾ ಹಾತ್ ಧುಯ್‍ನಸ್ತಾನಾ ಮ್ಹೆಳ್ಕ್ಯಾ ಹಾತಾನಿ ಜೆವಾನ್ ಕರ್‍ತಲೆ ತೆನಿ ಬಗಟ್ಲ್ಯಾನಿ.ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಹಾತ್ ಧುವ್ನಸಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ಫಾರಿಜೆವ್‍ ಅನಿ ಜುದೆವ್ ಧರ್ಮಾಚಿ ಲೊಕಾ ತೆಂಚ್ಯಾ ಅದ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಪದ್ದತಿ ಪರ್‍ಕಾರ್ ಹಾತ್ ಧುಯ್ನಾಸ್ತಾನಾ ಜೆವಾನ್ ಕರಿನಸಿತ್. ");
INSERT INTO kans_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ಅನಿ ಬಾಜಾರಾಕ್ನಾ ಖಾವ್ಕ್ ಹಾನಲ್ಲೆ ತರ್ ಧುಯ್ನಾಸ್ತಾನಾ ಖಾಯ್ನಸಿತ್. ವಾಟ್ಕಿ,ಗಾಡ್ಗಿ, ತಾಂಬ್ಯಾ, ಆಯ್ದಾನಾ, ಹಾತ್ರಾನಾ ಧುತಲೆ, ಅಸ್ಲಿ ಲೈ ಪದ್ದತಿಯಾ ಪಾಳಿತ್. ");
INSERT INTO kans_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ತೆಚೆ ಸಾಟ್ನಿ ಫಾರಿಜೆವಾನಿ ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನಿ ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್ “ತುಜಿ ಶಿಸಾ ಅದ್ಲ್ಯಾ ಲೊಕಾನಿ ಕರಲ್ಲ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್ಕಾರ್ ಚಲಿನಸ್ತಾನಾ ಮ್ಹೆಳ್ಕ್ಯಾ ಹಾತಾನಿ ಜೆವಾನ್ ಕರ್‍ತ್ಯಾತ್ ಕಶ್ಯಾಕ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ತನ್ನಾ ಜೆಜು ಕುಸ್ಡ್ಯಾ ಲೊಕಾನು, ಇಸಾಯಿಯಾನ್ ತುಮ್ಚ್ಯಾ ವಿಶಯಾತ್ ಹಿ ಲೊಕಾ ಅಪ್ನಾಚ್ಯಾ ತೊಂಡಾಂಚ್ಯಾ ಗೊಸ್ಟಿಯಾನಿ ಮಾಕಾ ಮಾನ್ ಕರ್‍ತ್ಯಾತ್, ಖರೆ ತೆಂಚಿ ಕಾಳ್ಜಾ ಮಾಜೆಕನ್ನಾ ಲೈ ದುರ್ ಹಾತ್‍, ");
INSERT INTO kans_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ಹಿ ಮಾನ್ಸಾ ಮಾಜಿ ಭಜನ್ ಕರುನ್ ಕಾಯ್ ಫಾಯ್ದೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ದೆವಾಚೆ ಖಾಯ್ದೆ ಸೊಡುನ್ ಮಾನ್ಸಾನಿ ಕರಲ್ಲೆ ಖಾಯ್ದೆ ಹೆನಿ ಸಗ್ಳ್ಯಾಕ್ನಿ ಶಿಕ್ವುತ್ಯಾತ್.ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಖರೆ ಹಾಯ್, ");
INSERT INTO kans_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ತುಮಿ ದೆವಾನ್ ಸಾಂಗಲ್ಲೆ ಖಾಯ್ದೆ ಸೊಡುನ್, ಮಾನ್ಸಾನಿ ಕರಲ್ಲ್ಯಾ ಪದ್ಧತಿಯಾ ಪಾಳುನ್ಗೆತ್ ರ್‍ಹಾತ್ಯಾಶಿ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ಅನಿ ಫಿಡೆ ಬೊಲುನ್ಗೆತ್ ಜೆಜುನ್ “ತುಮಿ ತುಮ್ಚೆ ಖಾಯ್ದೆ ಪಾಳು ಸಾಟ್ನಿ ದೆವಾಚೆ ಖಾಯ್ದೆ ತಿರಸ್ಕಾರ್ ಕರ್‍ತಲ್ಯಾತ್ ಉಶಾರ್ ಹಾಸಿ!”ಮಟ್ಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“ತುಮ್ಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ನಿ ಮಾನ್ ದಿವಾ, ಕೊನ್ ತರ್ ಎಕ್ಲೊ ಮಾನುಸ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ನಿ ಸರಾಪ್ಲ್ಯಾರ್, ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿವ್ಕ್ ಪಾಜೆ ಮನುನ್” ಮೊಯ್ಜೆನ್ ಸಾಂಗ್ಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ಜರ್ ಎಕ್ಲೊ ಮಾನುಸ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ -ಬಾಬಾಕ್ ಅದಾರ್ ದಿವ್ಕ್ ಮನುನ್ ಹೊತ್ತೆ ಸಗ್ಳೆ ದೆವಾಕ್ ದೆನ್ಗಿ ಮನುನ್ ದಿಲಾ, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾರ್, ");
INSERT INTO kans_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ತಸ್ಲ್ಯಾ ಮಾನ್ಸಾನ್ ಅನಿ ಫಿಡೆ ತೆಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ ಕಸ್ಲೊಬಿ ಆಧಾರ್ ದಿವ್ಕ್ ತುಮಿ ಸೊಡಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ಅಶೆ ತುಮಿ ಶಿಕ್ವುತಾನಾ ದೆವಾಚ್ಯಾ ಬರ್ಯಾ ಖಬ್ರೆಚಿ ತಿರಸ್ಕಾರ್ ಕರುನ್ ತುಮ್ಚೆಚ್ ಖಾಯ್ದೆ ಶಿಕ್ವುತ್ಯಾಸಿ. ಅನಿ ಅಸ್ಲಿ ಲೈ ಕಾಮಾ ತುಮಿ ಕರ್ತ್ಯಾಶಿ. ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ಜೆಜುನ್ ಅನಿ ಎಗ್ದಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುನ್.ಕಾಯ್ ಸಾಂಗ್ಲ್ಯಾನ್ ಮಟ್ಲ್ಯಾರ್ “ಮಿಯಾ ಸಾಂಗ್ತಲೆ ಆಯ್ಕಾ ಅನಿ ಕಳ್ವುನ್ ಘೆವಾ ");
INSERT INTO kans_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ಜೆ ಕಾಯ್ ಭಾಯ್ನಾ ಎಕ್ ಮಾನ್ಸಾಚ್ಯಾ ಭುತ್ತುರ್ ಜಾತಾ ತೆ ಕಾಯ್ಬಿ ಮಾನ್ಸಾಕ್ ಅಶುದ್ದ್ ಕರಿನಾ, ಮಾನ್ಸಾಚ್ಯಾ ತೊಂಡಾತ್ನಾ ಜೆ ಕಾಯ್ ಭಾಯ್ರ್ ಯೆತಾ ತೆ ಮಾನ್ಸಾಕ್ ಅಶುದ್ದ್ ಕರ್ತಾ”, ");
INSERT INTO kans_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ಹಿ ಗೊಸ್ಟ್ ಮುಳಾಚ್ಯಾ ಜಾಸ್ತಿಚ್ಯಾ ಪ್ರತಿಯಾತ್ನಿ ನಾ.ತೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್ ಕೊನಾಕ್ ತರ್ ಆಯ್ಕುಕ್ ಕಾನಾ ರ್‍ಹಾಲ್ಯಾರ್ ಆಯ್ಕುಂದಿತ್,ಮನ್ತಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ಮಾನಾ ಜೆಜು ಲೊಕಾಕ್ನಿ ಸೊಡುನ್ ಘರಾತ್ ಗೆಲೊ. ತನ್ನಾ ಶಿಸಾನಿ ಜೆಜುಕ್ ತೆನಿ ಸಾಂಗಟಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ತನ್ನಾ ಜೆಜುನ್ “ತುಮಿ ದುಸ್ರ್ಯಾಚ್ಯಾನ್ಕಿ ಬುದ್ದ್ವಂತ್ ನ್ಹಯ್? ಅನಿ ತುಮ್ಕಾ ಕಳಿನಾ ಕಾಯ್? ಎಕ್ ಮಾನ್ಸಾಚ್ಯಾ ಭುತ್ತುರ್ ಜಾತಲೆ ಕಾಯ್ಬಿ ತೆಕಾ ಮ್ಹೆಳ್ಯಿ ನಾ.” ");
INSERT INTO kans_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ಜೆವಾನ್, ಖಾತಲೆ ಖಾನ್ ಮಾನ್ಸಾಚ್ಯಾ ಕಾಳ್ಜಾತ್ ಜಾಯ್ನಾ, ಪೊಟಾತ್ ಜಾತಾ. ಅನಿ ಮಾನಾ ಭಾಯ್ರ್ ಜಾತಾ.ಮಟ್ಲ್ಯಾನ್. ಅಶೆ, ಸಗ್ಳೆ ಖಾತಲೆ ಮನುನ್ ಅಸಲ್ಲೆ ಬರೆಚ್ ಮನುನ್ ಜೆಜುನ್ ದಾಕ್ವುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ಅನಿ ಫಿಡೆ ಜೆಜುನ್ “ಎಕ್ ಮಾನ್ಸಾಚ್ಯಾ ಭುತ್ತುರ್ನಾ ಜೆ ಕಾಯ್ ಭಾಯ್ರ್ ಯೆತಾ, ತೆ, ತೆಕಾ ಮ್ಹೆಳ್ವುತಾ”. ");
INSERT INTO kans_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ಎಕಾ ಮಾನ್ಸಾಚ್ಯಾ, ಕಾಳ್ಜಾತ್ ಹಿ ಸಗ್ಳಿ ಬುರ್ಶಿ ಕಾಮಾ ಉಪಾಜ್ತ್ಯಾತ್ ಅನಿ ತೆಕಾ ಬುರ್ಶಿ ಕಾಮಾ ಕರುಕ್ ಉತ್ತೆಜನ್ ಕರ್‍ತ್ಯಾತ್. ತಿ ಖಲಿ ಕಾಮಾ ಮಟ್ಲ್ಯಾರ್, ಬುರ್ಶಿ ಯೆವ್ಜನ್ಯಾ, ರಾಂಡ್ಗೆಪಾನ್, ಚೊರಿ ಕರ್‍ತಲೆ, ಜಿವಾನಿ ಮಾರ್‍ತಲೆ, ");
INSERT INTO kans_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ವ್ಯೆಭಿಚಾರ್ ಜಾಸ್ತಿಚಿ ಆಶ್ಯಾ, ಅಸಂ, ಝುಟೆ ಬೊಲ್ತಲೆ, ಬುರ್ಶೆಪಾನ್, ಕುಸ್ಡೆಪಾನ್, ಚಾಡ್ಗೆಪಾನ್, ಪಿಶೆಪಾನ್, ಅನಿ ಅಹಂಕಾರ್ ಹಿ ಸಗ್ಳಿ ಬುರ್ಶ್ಯಾ ಕಾಮಾ ಮಾನ್ಸಾಕ್ ಮ್ಹೆಳ್ಕೊ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ಹೆ ಸಗ್ಳೆ ಮಾನ್ಸಾಚ್ಯಾ ಭುತ್ತುರ್ನಾ ಭಾಯ್ರ್ ಯೆತಾ ಅನಿ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಮ್ಹೆಳ್ಕೊ ಕರ್‍ತಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್, ತಿರ್ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾಕ್ ಗೆಲೊ. ಥೈ ತೊ ಎಕ್ ಘರಾತ್ ಗೆಲ್ಲೊ, ಅಪ್ನಿ ಥೈ ಹೊತ್ತೆ ಕೊನಾಕ್ಬಿ ಕಳ್ತಲೆ ತೆಕಾ ನಕ್ಕೊ ಮನುನ್ ಘೆವ್ನ್ ಹೊತ್ತೊ. ಖರೆ ತೆಕಾ ಲೊಕಾನಿಕ್ನಾ ನಿಪುನ್ ರ್‍ಹಾವ್ಕ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ಎಕ್ ಬಾಯ್ಕೊಮನ್ಸಿಚ್ಯಾ ಲೆಕಿಕ್ ಗಿರೊಲಾಗಲ್ಲೊ, ಜೆಜು ತ್ಯಾ ಘರಾತ್ ಅಸಲ್ಲೆ ತಿಕಾ ಕಳ್ಳೆ, ತಸೆ ಮನುನ್ ತಿ ತನ್ನಾಚ್ ಜೆಜುಕ್ಡೆ ಯೆಲಿ ಅನಿ ತೆಚ್ಯಾ ಪಾಂಯಾತ್ ಪಡ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ತಿ ಎಕ್ “ಗ್ರಿಕ್” ಬಾಯ್ಕೊಮನುಸ್, ಸಿರಿಯಾಚ್ಯಾ ಪೊಯಿನಿಕ್ಯಾ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಜಲಮಲ್ಲಿ, ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಿಕ್ ಲಾಗಲ್ಲೊ ಗಿರೊ ಕಾಡ್ ಮನುನ್ ಜೆಜುಕ್ಡೆ ಮಾಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ತನ್ನಾ ಜೆಜುನ್ “ಪೊರಾಕ್ನಿ ದಿತಲಿ ಭಾಕ್ರಿ ಕುತ್ರ್ಯಾಕ್ನಿ ತಾಕ್ತಲೆ ಸಮಾ ನ್ಹಯ್, ಅದ್ದಿ ಪೊರಾ ಖಾಂವ್ದಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ತನ್ನಾ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್ “ತೆ ಖರೆ ಮಾಜ್ಯಾ ಧನಿಯಾ, ಖರೆ ಪೊರಾ ಖಾತಾನಾ ಪಡಲ್ಲೆ ಭಾಕ್ರಿಚೆ ತುಕ್ಡೆ ತರ್ಬಿ ಕುತ್ರಿ ಖಾತ್ಯಾತ್ ನ್ಹಯ್!” ಮನುನ್ ಉತ್ತರ್ ದಿಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ತನ್ನಾ ಜೆಜುನ್ “ತಿಯಾ ಲೈ ಬರಿ ಜಾಬ್ ದಿಲೆ,ತುಜ್ಯಾ ಲೆಕಿಚೊ ಗಿರೊ ತಿಕಾ ಸೊಡುನ್ ಗೆಲೊ ಅತ್ತಾ ತಿಯಾ ತುಜ್ಯಾ ಘರಾಕ್ ಜಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ತಿ ಘರಾಕ್ ಜಾವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ತಿಚಿ ಲೆಕ್ ಹಾತ್ರಾನಾತ್ ಆರಾಮ್ ಆಡ್ ಪಡಲ್ಲಿ ತಿಕಾ ದಿಸ್ಲಿ, ತಿಕಾ ಲಾಗಲ್ಲೊ ಗಿರೊ ಸೊಡುನ್ ಗೆಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ಮಾನಾ ಜೆಜು ತಿರ್ ಶಾರಾಚೊ ಜಾಗೊ ಸೊಡುನ್, ಸಿದೊನ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಜಾತಲ್ಯಾ ವಾಟೆನ್ ಹೊವ್ನ್ ದೆಕಾಪೊಲಿ ಧಾ ಶಾರಾಂಚೆ ಗಾಂವ್ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾ ವೈನಾ ಪಾರ್ ಹೊವ್ನ್ ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾಕ್ಡೆ ಜವ್‍ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ತನ್ನಾ ಎಕ್ ಉಲ್ಲಿ ಲೊಕಾ ಎಕ್ ತೊದಲ್ತಲ್ಯಾ ಅನಿ ಕಿಂವ್ಡ್ಯಾ ಮಾನ್ಸಾಕ್ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆವ್ನ್ ತೆಚೆ ವರ್‍ತಿ ಹಾತ್ ಥವ್ನ್ ತೆಕಾ ಗುನ್ಕರ್ ಮನುನ್ ಮಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ತನ್ನಾ ಜೆಜುನ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಲೊಕಾನಿಕ್ನಾ ಕಡೆಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್, ಅನಿ ಅಪ್ಲಿ ಬೊಟಾ ತೆಚ್ಯಾ ಕಾನಾತ್ ಘಾಟ್ಲ್ಯಾನ್, ಅನಿ ಥುಕುನ್ ತೆಚ್ಯಾ ಜಿಬ್ಲಿಕ್ ಅಪಡ್ಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ಸರ್‍ಗಾಕ್ ದಿಸ್ಟ್ ಲಾವುನ್ ಉಸ್ಕಾರುನ್ “ಎಫ್ಫತಾ” ಮಟ್ಲ್ಯಾನ್ ಮಟ್ಲ್ಯಾರ್ ಉಗಡ್ ");
INSERT INTO kans_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ತನ್ನಾಚ್ ತೆಚಿ ಕಾನಾ ಉಗಡ್ಲಿ ಅನಿ ತೆಚಿ ಜಿಬ್ ಸಡಲ್ ಹೊಲಿ ತೊ ಸ್ಪಸ್ಟ್ ಬೊಲುಕ್ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ಹಿ ಖಬರ್ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕಾಸಿ ಮನುನ್ ಜೆಜುನ್ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಸಾಂಗ್ಲ್ಯಾನ್ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ವಿಶಯಾತ್ ಕವ್ಡೆ ಸಾಂಗುನಕಾಸಿ ಮನುನ್ ಸಾಂಗಿ, ತವ್ಡೆ ಲೊಕಾ ತೆಚಿ ಖಬರ್ ಫರ್ಗಟಿತ್. ");
INSERT INTO kans_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ಹೆ ಸಗ್ಳೆ ಆಯ್ಕಲ್ಲಿ ಲೊಕಾ ಲೈ ಅಜಾಪ್ ಹೊಲಿ ಹ್ಯೊ ಸಗ್ಳೆ ಬರೆ ಕರ್‍ತಾ! ಕಿಂವ್ಡ್ಯಾನಿ ಆಯ್ಕಿ ಸರ್ಕೆ ಕರ್‍ತಾ, ಮುಕ್ಕ್ಯಾನಿ ಬೊಲಿ ಸರ್ಕೆ ಕರ್‍ತಾ ಮನುನ್ ಮನುಕ್ಲಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ತ್ಯಾಚ್ ದಿಸಾತ್ನಿ ಅನಿ ಎಕ್ ಲೊಕಾಂಚೊ ಮೊಟೊ ತಾಂಡೊ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ. ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಜೆವ್ನಾಕ್ ಕಾಯ್ಬಿ ನತ್ತೆ. ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಬಲ್ವುನ್, ");
INSERT INTO kans_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ಹ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಗುನ್ ಮಾಕಾ ಪಾಪ್ ದಿಸುಕ್ ಲಾಗ್ಲಾ, ತಿನ್ ದಿಸಾ ಹೊಲಿ ಹಿ ಲೊಕಾ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಹಾತ್, ತೆಂಚ್ಯಾಕ್ಡೆ ಜೆವ್ನಾಕ್ ಕಾಯ್ಬಿ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ಹ್ಯಾ ಲೊಕಾಕ್ನಿ ಉಪ್ಪಾಸಿ ಧಾಡ್ಲ್ಯಾರ್ ಹ್ಯಾತುರ್ಲಿ ಉಲ್ಲಿ ಲೊಕಾ ಲೈ ಧುರ್‍ನಾ ಯೆಲ್ಲಿ ಹಾತ್, ಭುಕೆನ್ ಖೈ ತರ್ ಪಡ್ತಿಲ್,” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ತನ್ನಾ ಶಿಸಾನಿ “ಹಿತ್ತೆ ಜಗ್ಗೊಳ್ ಎಕ್‍ಬಿ ಗಾಂವ್ ನಾ ಕಾಯ್ನಾ, ಎವ್ಡ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಫಿರೆ ಹೊಯ್ಸರ್ಕ್ಯಾ ಭಾಕ್ರಿಯಾ ಖೈತ್ನಾ ಹಾನ್ತಲ್ಯಾ ಅತ್ತಾ?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ತನ್ನಾ ಜೆಜುನ್ “ತುಮ್ಚ್ಯಾಕ್ಡೆ ಕವ್ಡ್ಯಾ ಭಾಕ್ರಿಯಾ ಹಾತ್” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ಶಿಸಾನಿ “ಸಾತ್ ಭಾಕ್ರಿಯಾ ಹಾತ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ತನ್ನಾ ಜೆಜುನ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಸಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ಮಾನಾ ತ್ಯಾ ಸಾತ್ ಭಾಕ್ರಿಯಾ ಹಾತಿತ್ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನ್ ಅನಿ ಭಾಕ್ರಿಯಾ ಮೊಡುನ್ ಲೊಕಾಕ್ನಿ ವಾಟಾ ಮನುನ್ ಅಪ್ಲ್ಯಾ ಶಿಸಾಂಚ್ಯಾಕ್ಡೆ ದಿಲ್ಯಾನ್, ಶಿಸಾನಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ವಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ತೆಂಚ್ಯಾಕ್ಡೆ ಉಲ್ಲ್ಯಾ ಬಾರಿಕ್ಲ್ಯಾ ಮಾಸೊಳ್ಯಾಬಿ ಹೊತ್ತ್ಯಾ, ತ್ಯಾ ಮಾಸೊಳ್ಯಾಬಿ ಜೆಜುನ್ ಅಪ್ಲ್ಯಾ ಹಾತಿತ್ ಘೆವ್ನ್ ಧನ್ಯಾವಾದ್ ದಿವ್ನ್ ಲೊಕಾಕ್ನಿ ವಾಟಾ ಮನುನ್ ಶಿಸಾಂಚ್ಯಾ ಹಾತಾತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ಪೊಟ್‍ಬರ್ ಜೆವ್ಲ್ಯಾನಿ, ಮಾನಾ ಶಿಸಾನಿ ಹುರಲ್ಲೆ ಭಾಕ್ರಿಯಾಂಚೆ ತುಕ್ಡೆ ಗೊಳಾ ಕರ್‍ಲ್ಯಾನಿ, ತನ್ನಾ ಸಾತ್ ಭುಟಿಯಾ ಭರ್‍ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ಥೈ ಜೆವಾನ್ ಕರಲ್ಲಿ ಸುಮಾರ್ ಚಾರ್ ಹಜಾರ್ ಲೊಕಾ ಹೊತ್ತಿ. ತೆಂಚೆ ಜೆವಾನ್ ಕರುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ತೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜು ಡೊನಿತ್ ಚಡುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ “ದಲ್ಮನುಥ” ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ಫಾರಿಜೆವ್ ಯೆಲೆ ಅನಿ ಕಾಯ್ತರ್ ಚುಕ್ ಹುಡ್ಕುಕ್ ಮನುನ್, ತಿಯಾ ದೆವಾಕ್ನಾ ಯೆಲ್ಲೊ ಮನುನ್ ದಾಕ್ವುಕ್ ಸರ್‍ಗಾ ವೈನಾ ಎಕ್ ಮೊಟೊ ವಳಕ್ ಕರುನ್ ದಾಕ್ವು ಮನುನ್ ತೆಚೆಕ್ಡೆ ವಾದ್ ಕರುಕ್ ಲಾಗ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ಜೆಜು ಉಸ್ಕಾರ್ಲೊ ಅನಿ “ಹ್ಯಾ ಕಾಲಾಚಿ ಲೊಕಾ ವಳಕ್ ಕಶ್ಯಾಕ್ ಇಚಾರ್‍ತ್ಯಾತ್? ಮಿಯಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ ಹ್ಯಾ ಲೊಕಾಕ್ನಿ ಘುರುತ್ ಕರುನ್ ದಾಕ್ವುಕ್ ಹೊಯ್ನಾ,” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ಮಾನಾ ತೊ ಥೈತ್ನಾ ಢೊನಿತ್ ಚಡುನ್ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ಶಿಸಾನಿ ಪಾಜೆ ಹೊಲ್ಲ್ಯಾ ತವ್ಡ್ಯಾ ಭಾಕ್ರಿಯಾ ಹಾನ್ತಲೆ ಇಸರಲ್ಲ್ಯಾನಿ, ಢೊನಿತ್ ತೆಂಚೆಕ್ಡೆ ಎಕುಚ್ ಎಕ್ ಭಾಕ್ರಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಫಾರಿಜೆವಾಂಚ್ಯಾ ಅನಿ ಹೆರೊದಿಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸೊಡ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಉಶಾರ್ ರ್‍ಹಾವಾ, ಮನುನ್ ಉಶಾರ್ಕಿ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ತನ್ನಾ ತೆನಿ “ಅಮ್ಚೆಕ್ಡೆ ಭಾಕ್ರಿಯಾ ನಾತ್ ಮನುನ್ ತೆನಿ ತಸೆ ಮಟ್ಲ್ಯಾನ್ ಕಾಯ್ಕಿ ” ಮನುನ್ ತೆಂಚ್ಯಾ-ತೆಂಚ್ಯಾ ಮದ್ದಿ ಬೊಲುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ತೆನಿ ಬೊಲ್ತಲೆ ಜೆಜುಕ್ ಕಳ್ಳೆ ತನ್ನಾ ಜೆಜುನ್ “ತುಮಿ ಭಾಕ್ರಿಯಾನಾತ್ ಮನುನ್ ಕಶ್ಯಾಕ್ ಬೊಲುಲ್ಯಾಸಿ? ಅಜುನ್ ತುಮ್ಕಾ ಕಳುಕ್ ನಾ? ತುಮ್ಚಿ ಟಕ್ಲಿ ತೌಡಿಬಿ ಮಡ್ಡ್ ಹೊಲ್ಯಾತ್ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ಡೊಳೆ ರ್‍ಹಾವ್ನ್‌ಬಿ ತುಮ್ಕಾ ದಿಸಿನಾ ಕಾಯ್? ಕಾನಾ ರ್‍ಹಾವ್ನ್‌ಬಿ ತುಮ್ಕಾ ಆಯ್ಕಿನಾ ಕಾಯ್? ಅನಿ ತುಮ್ಕಾ ಯಾದ್ ನಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ಮಿಯಾ ಪಾಂಚ್ ಭಾಕ್ರಿಯಾ ಪಾಂಚ್ ಹಜಾರ್ ಲೊಕಾಕ್ನಿ ವಾಟಾ ಮನುನ್ ದಿಲ್ಲೊ ತನ್ನಾ ಭಾಕ್ರಿಯಾಂಚೆ ತುಕ್ಡೆ ಕವ್ಡ್ಯಾ ಭುಟಿಯಾ ಭರ್ಲ್ಯಾಸಿ?” ಮನುನ್ ಶಿಸಾಕ್ನಿ ಇಚಾರ್‍ಲ್ಯಾನ್. ತೆನಿ “ಬಾರಾ ಭುಟಿಯಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ಮಿಯಾ ಸಾತ್ ಭಾಕ್ರಿಯಾ ಚಾರ್ ಹಜಾರ್ ಲೊಕಾಕ್ನಿ ಮೊಡುನ್ ದಿಲ್ಲ್ಯಾ ತನ್ನಾ ಕವ್ಡ್ಯಾ ಭುಟಿಯಾ ಭಾಕ್ರಿಯಾಂಚೆ ತುಕ್ಡೆ ಹುರಲ್ಲೆ ಸಾತ್ ಭುಟಿಯಾ ಮಟ್ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ತನ್ನಾ ಜೆಜುನ್ “ಅನಿ ಅಜುನ್ಬಿ ತುಮ್ಕಾ ಕಳಿನಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ ಬೆತ್ಸಾಯಿದಾ ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ ಯೆಲ್ಯಾನಿ.ಥೈ ಲೊಕಾನಿ ಎಕ್ ಕುಡ್ಡ್ಯಾಕ್ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ ಅನಿ ತೆಕಾ ಅಪಡ್ ಮನುನ್ ಮಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ತನ್ನಾ ಜೆಜುನ್ ತ್ಯಾ ಕುಡ್ಡ್ಯಾಕ್ ಹಾತ್ ಧರುನ್ ಗಾಂವಾಂಚ್ಯಾ ಭಾಯ್ರ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್ ಅನಿ ತೆಚ್ಯಾ ಡೊಳ್ಯಾ ವೈನಿ ಥುಕುನ್ ತೆಚ್ಯಾ ವರ್‍ತಿ ಹಾತ್ ಥವ್ಲ್ಯಾನ್, ಅನಿ “ಅತ್ತಾ ತುಕಾ ದಿಸುಕ್ ಲಾಗ್ಲಾ ಕಾಯ್ ನಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ತ್ಯಾ ಕುಡ್ಡ್ಯಾನ್ ಟಕ್ಲೆ ವೈರ್ ಕರುನ್ ಬಗುನ್ “ಹೊಯ್ ಮಾಕಾ ದಿಸುಕ್ ಲಾಗ್ಲಾ, ಖರೆ ಮಾನ್ಸಾ ಚಲ್ತಲ್ಯಾ ಝಾಡಾಂಚ್ಯಾ ಸರ್ಕಿ ದಿಸುಕ್ ಲಾಗ್ಲ್ಯಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ಜೆಜುನ್ ಅನಿ ಎಗ್ದಾ ಅಪ್ಲೊ ಹಾತ್ ತೆಚ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ಲಾವ್ಲ್ಯಾನ್. ತೆಕಾ ಬರೆ ದಿಸುಕ್ ಲಾಗ್ಲೆ ತೆಚೆ ಡೊಳೆ ಸಮಾ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ತಿಯಾ ತುಮ್ಚ್ಯಾ ಘರಾಕ್ ಜಾ, ಗಾಂವಾತ್ ಜವ್ನಕೊ” ಮನುನ್ ಖಡಕ್ ತಾಕಿತ್ ದಿವ್ನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ತನ್ನಾ ಜೆಜು ಅನಿ ಶಿಸಾ ಸೆಜರಿಯಾ ಫಿಲಿಪ್ಪಿ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಹೊತ್ತ್ಯಾ ಗಾಂವಾತ್ನಿ ಗೆಲ್ಲೆ. ವಾಟೆನ್ ಜಾತಾನಾ ಜೆಜುನ್ “ಲೊಕಾ ಮಿಯಾ ಕೊನ್ ಮನುನ್ ಮನ್ತ್ಯಾತ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ತನ್ನಾ ಶಿಸಾನಿ ಉಲ್ಲೆ ಜಾನಾ ತುಕಾ ಬಾಲ್ತಿಮ್‍ ದಿತಲೊ ಜುವಾಂವ್ ಮನ್ತ್ಯಾತ್, ಅನಿ ಉಲ್ಲೆ ಜಾನಾ “ಎಲಿಯಾ” ಮನ್ತ್ಯಾತ್, ಅನಿ ಉಲ್ಲೆ ಜಾನಾ; ಎಕ್ಲೊ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗ್ತಲೊ; ಮನ್ತ್ಯಾತ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ತನ್ನಾ ಜೆಜುನ್ ತುಮಿ ಮಾಕಾ ಕಾಯ್ ಮನುನ್ ಯವಜ್ತ್ಯಾಶಿ? “ತುಮಿ ಮಾಕಾ ಕೊನ್ ಮನುನ್ ಮನ್ತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ಪೆದ್ರುನ್ “ತಿಯಾ ಕ್ರಿಸ್ತ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ತನ್ನಾ ಜೆಜುನ್ ಮಿಯಾ “ಕ್ರಿಸ್ತ್” ಮನುನ್ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕಾಸಿ ಮನುನ್ ತೆಂಕಾ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ಲ್ಯಾ ಶಿಸಾಕ್ನಿ \"ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಕಸ್ಟ್ ಸೊಸುಕುಚ್ ಪಾಜೆ, ಜಾನ್ತ್ಯಾ ಲೊಕಾನಿ, ಮೊಟ್ಯಾ ಯಾಜಕಾನಿ ಅನಿ ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನಿ ತೆಕಾ ತಿರಸ್ಕಾರ್ ಕರುಕುಚ್ ಪಾಜೆ. ಅನಿ ತೊ ಮರುಕ್ ಪಾಜೆ, ಖರೆ, ತೊ ತಿನ್ವ್ಯಾ ದಿಸಿ ಮರಲ್ಲ್ಯಾತ್ನಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆತಾ.\"ಮನುನ್ ಸಾಂಗುಕ್ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ಫಿಡೆ ಅಪ್ನಾಕ್ ಕಾಯ್-ಕಾಯ್ ಹೊತಲೆ ಹಾಯ್ ತೆ ಸಗ್ಳೆ ನಿಪ್ವುನ್ ಥೈ ನಸ್ತಾನಾ ತೆನಿ ತೆಂಕಾ ಸಾಂಗಟ್ಲ್ಯಾನ್. ಹೆ ಆಯ್ಕುನ್ ಪೆದ್ರುನ್ ಜೆಜುಕ್ ಕಡೆಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್, ಅನಿ “ಹೆ ಸಗ್ಳೆ ತುಕಾ ಹೊತಲೆ ನಕ್ಕೊ” ಮನುನ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ಖರೆ ಜೆಜುನ್ ಶಿಸಾಂಚ್ಯಾಕ್ಡೆ ಪರ್ತುನ್ ಪೆದ್ರುಕ್ “ಮಾಜ್ಯಾಕ್ನಾ ಧುರ್ ಚಲ್ ಸೈತಾನಾ! ತಿಯಾ ಮಾನ್ಸಾನ್ ಯೆವಜಲ್ಲ್ಯಾ ಬಾಸೆನ್ ಯೆವಜ್ತೆ, ದೆವಾನ್ ಯವಜಲ್ಲ್ಯಾ ಬಾಸೆನ್ ಯೆವ್ಜುನ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ತನ್ನಾ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ ಅನಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್ ಅನಿ “ತುಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಕೊನಾಕ್ ತರ್‍ಬಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆವ್ಕ್ ಮನ್ ರ್‍ಹಾಲ್ಲ್ಯಾರ್, ತೊ ಅಪ್ನಾಕುಚ್ ಇಸ್ರುಂದಿ, ಅಪ್ನಾಚೊ ಕುರಿಸ್ ಘೆಂವ್ದಿತ್, ಅನಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆಂವ್ದಿ” ");
INSERT INTO kans_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜೊ ಕೊನ್ ಅಪ್ನಾಚೊ ಜಿವ್ ಹುರ್‍ವುನ್ ಘೆವ್ಕ್ ಬಗ್ತಾ, ತೊ ಕಳ್ದುನ್ ಘೆತಾ, ಅನಿ ಜೊ ಕೊನ್ ಮಾಜೆ ಸಾಟ್ನಿ ಅನಿ ದೆವಾಚ್ಯಾ ಬರ್‍ಯಾ ಖಬ್ರೆಸಾಟ್ನಿ ಅಪ್ನಾಚೊ ಜಿವ್ ಕಳ್ದುನ್ ಘೆತಾ ತೊ ಅಪ್ನಾಚೊ ಜಿವ್ ಹುರ್‍ವುನ್ ಘೆತಾ, ");
INSERT INTO kans_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ಕೊನ್ ತರ್ ಎಕ್ಲ್ಯಾನ್ ಹಿ ಸಗ್ಳಿ ದುನಿಯಾಚ್ ಜಿಕುನ್ ಘೆವ್ನ್, ಅಪ್ನಾಚೊ ಅತ್ಮೊಚ್ ನಾಸ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾರ್ ತೆಕಾ ಕಾಯ್ ಫಾಯ್ದೊ ಹೊಲ್ಯಾ ಸರ್ಕೆ ಹೊಲೆ? ಕಾಯ್ಬಿ ಫಾಯ್ದೊ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ಅಪ್ನಾಚೊ ಜಿವ್ ಕಮ್ವುನ್ ಘೆವ್ಕ್ ತೆನಿ ಕಾಯ್ಬಿ ದಿವ್ಕ್ ಹೊಯ್ನಾ, ");
INSERT INTO kans_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ಹ್ಯಾ ಬುರ್ಶ್ಯಾ ಅನಿ ಪಾಪಿ ದಿಸಾತ್ನಿ, ಕೊನ್ ತರ್ ಎಕ್ಲೊ ಮಾನುಸ್ ಮಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಬರ್‍ಯಾ ಗೊಸ್ಟಿಯಾಂಚ್ಯಾಸಾಟಿ ನಾಜಾಲ್ಯಾರ್ ಮಾಜೆಸಾಟಿ ಲಜ್ತಾ ಹೊಲ್ಯಾರ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾಚ್ಯಾ ಮಹಿಮೆನ್ ದೆವಾಚ್ಯಾ ದುತಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಚೆಸಾಟ್ನಿ ಲಜ್ತಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ಅನಿ ತೆನಿ “ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ತುಮ್ಚ್ಯಾ ಮದ್ಲೆ ಉಲ್ಲೆ ಜಾನಾ ದೆವಾಚೆ ರಾಜ್ ಅಪ್ನಾಚ್ಯಾ ಅದಿಕಾರಾ ಸಮೆತ್ ಯೆತಲೆ ಬಗ್ಲ್ಯಾ ಸಿವಾಯ್ ಮರಿನ್ಯಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ಸಾ ದಿಸ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಜೆಜು ಪೆದ್ರುಕ್, ಜಾಕೊಬಾಕ್ ಅನಿ ಜುವಾಂವಾಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್, ಎಕ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಗೆಲೊ. ಥೈ ತೆನಿ ಎವ್ಡೆಚ್ ಹೊತ್ತೆ. ತೆನಿ ಜೆಜು ವರ್‍ತಿ ನದರ್ ಮಾರುನ್ ಬಗಟಲ್ಲ್ಯಾನಿ ತನ್ನಾ ತೆಚೆ ವರ್‍ತಿ ಹೊಲ್ಲಿ ಬದ್ಲಾವನ್ ತೆಂಕಾ ದಿಸ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ಜೆಜುಚ್ಯಾ ಅಂಗಾ ವೈಲ್ಯಾ ಫಾಳಿಯಾ ಎವ್ಡ್ಯಾ ಫ್ಹಾಂಡ್ರೆ ಖಡ್ ಹೊಲ್ಲ್ಯಾಕಿ, ಹ್ಯಾ ದುನಿಯಾತ್ ಕೊನ್ಬಿ ಧುವ್ನ್ ತವ್ಡೆ ಫ್ಹಾಂಡ್ರೆ ಕರುಕ್ ಸಾದ್ಯ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ತನ್ನಾ ಎಲಿಯಾ ಅನಿ ಮೊಯ್ಜೆ ಜೆಜುಕ್ಡೆ ಬೊಲ್ತಲೆ ತಿನಿಬಿ ಶಿಸಾನಿ ಬಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ತನ್ನಾ ಪೆದ್ರುನ್ ಜೆಜುಕ್ “ಗುರುಜಿ! ಅಮಿ ಹಿತ್ತೆ ರ್‍ಹಲ್ಲೆ ಕವ್ಡೆ ಬರೆ ಹಾಯ್ ನ್ಹಯ್! ಹಿತ್ತೆ ಅಮಿ ತಿನ್ ಝೊಪ್ಡಿ ಘಾಲುವಾ, ಎಕ್ ತುಕಾ, ಎಕ್ ಮೊಯ್ಜೆಕ್, ಅನಿ ಎಕ್ ಎಲಿಯಾಕ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ಪೆದ್ರು ಅನಿ ಹುರಲ್ಲಿ ಶಿಸಾ ಎವ್ಡೆ ಭಿಂಯಾವಲ್ಲಿ ಕಿ ಕಾಯ್ ಬೊಲುಚೆ ಮನುನ್ ತೆಕಾಚ್ ಕಳಿನಸಿ. ");
INSERT INTO kans_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ತನ್ನಾ ಎಕ್ ಮೊಡ್ ಯೆಲೆ ಅನಿ ತೆಚ್ಯಾ ಸಾವ್ಳಿನ್ ತೆಂಕಾ ಧಾಪ್ಲಿನ್, ಅನಿ ಮೊಡಾತ್ನಾ “ಹ್ಯೊ, ಮಾಜೊ ಲೈ ಅಪುರ್‍ಬಾಯೆಚೊ ಲೆಕ್, ತೆನಿ ಸಾಂಗಟಲ್ಲೆ ಆಯ್ಕಾ!” ಮನುನ್ ಧನ್ ಅಯ್ಕೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ತನ್ನಾ ಎಗ್ದಮ್ ತೆನಿ ಫಿರುನ್ ಬಗ್ಲ್ಯಾರ್, ಜೆಜು ಎಕ್ಲೊಚ್ ತೆಂಕಾ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ತೆನಿ ಮಡ್ಡಿ ವೈಯ್ನಾ ಉತ್ರುನ್ ಯೆತಾನಾ “ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮರುನ್, ಅನಿ ಪರ್ತುನ್ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆಯ್ ಪತರ್ ತುಮಿ ಮಡ್ಡಿ ವರ್‍ತಿ ಬಗಟಲ್ಲೆ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕಾಸಿ” ಮನುನ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ತೆನಿ ಜೆಜುಚ್ಯಾ ಹ್ಯಾ ಗೊಸ್ಟಿಕ್ ಖಾಲ್ತಿ ಹೊಲ್ಯಾನಿ, “ಖರೆ ಮರುನ್ ಅನಿ ಝಿತ್ತೆ ಹೊತಲೆ, ಮಟ್ಲ್ಯಾರ್ ಕಾಯ್?” ಮನುನ್ ಅಪ್ನಾಚ್ಯಾ ಮದ್ದಿಚ್ ಬೊಲುನ್ ಘೆವ್ಕ್‌ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ಅನಿ ತೆನಿ ಜೆಜುಕ್ “ಅದ್ದಿ ಎಲಿಯಾ ಯೆವ್ಕ್ ಪಾಜೆ ಮನುನ್ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲೆ, ಕಶ್ಯಾಕ್ ಸಾಂಗ್ತ್ಯಾತ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ತನ್ನಾ ಜೆಜುನ್ “ಸಗ್ಳೆ ತಯಾರ್ ಕರುಕ್ ಮನುನ್ ಅದ್ದಿ ಎಲಿಯಾ ಯೆವ್ಕ್ ಪಾಜೆ, ಜಾಲ್ಯಾರ್‍ಬಿ, ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾನ್ ಲೈ ಕಸ್ಟ್ ಸೊಸುಕ್ ಪಾಜೆ, ಅನಿ ತಿರಸ್ಕರಿತ್ ಹೊವ್ಕ್ ಪಾಜೆ, ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಕಶ್ಯಾಕ್ ಮನ್ತಾ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, “ಎಲಿಯಾ ಅದ್ದಿಚ್ ಯೆವ್ನ್ ಹೊಲೊ, ಖರೆ ಲೊಕಾನಿ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಅಪ್ನಾಚ್ಯಾ ಮನಾಕ್ ಯೆತಾ ತವ್ಡ್ಯಾ ಬುರ್ಶ್ಯಾ ರಿತಿನ್ ತೆಕಾ ಚಾಲ್ವುಲ್ಯಾನಿ.” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ತೆನಿ ಹುರಲ್ಲ್ಯಾ ಶಿಸಾತ್ನಿ ಯೆವ್ನ್ ಮಿಳ್ತಾನಾ ತ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ಭೊತ್ಯಾನಿ ಲೈ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಜಮಲ್ಲೊ ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲೆ ತೆಂಚ್ಯಾಕ್ಡೆ ವಾದ್ ಕರುನ್ಗೆತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ಲೊಕಾ ಜೆಜುಕ್ ಬಗುನ್ ಅಜಾಪ್ ಹೊಲಿ ಅನಿ ತೆಚ್ಯಾಕ್ಡೆ ಪಳುನ್ ಜಾವ್ನ್ ತೆಕಾ ಸ್ವಾಗತ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ತನ್ನಾ ಜೆಜುನ್ “ಕಾಚ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ತೆಂಚಾಕ್ನಾ ವಾದಿಕ್-ವಾದ್ ಕರುನ್ ಖೆಳುಕ್ ಲಾಗಲ್ಲ್ಯಾಸಿ?” ಮನುನ್ ಶಿಸಾಕ್ನಿ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ತನ್ನಾ ತ್ಯಾ ಲೊಕಾನಿತ್ಲ್ಯಾ ಎಕ್ ಮಾನ್ಸಾನ್ “ಗುರುಜಿ,ಮಾಜ್ಯಾ ಲೆಕಾಕ್ ಮಿಯಾ ತುಜೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲಾ, ತೆಕಾ ಗಿರೊಲಾಗ್ಲಾ ತೆಕಾ ಬೊಲುಕ್ ಹೊಯ್ನಾ.” ಮನುನ್ ಜೆಜುಕ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ತೊ ಗಿರೊ ತೆಕಾ ಅಂಗಾತ್ ಚಡಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ಜಿಮ್ನಿಕ್ ಪಾಡ್ವುತಾ, ತೊ ತೊಂಡಾತ್ನಾ ಫೆನ್ ಕಾಡ್ತಾ ಅನಿ ಕಟ್ಕಟ್ ದಾತಾ ಚಾವ್ತಾ, ತೆಚೆ ಆಂಗ್ ಶೆಡ್ದುನ್ ಘಟ್ ಹೊತಾ. ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ ಕಾಡಾ ಮನುನ್ ತುಜ್ಯಾ ಶಿಸಾಕ್ನಿ ಮಿಯಾ ಸಾಂಗ್ಲೊ, ಖರೆ ತೆ ತೆಂಚೆನ್ ಹೊವ್ಕ್ ನಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ತನ್ನಾ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ“ತುಮ್ಕಾ ವಿಶ್ವಾಸುಚ್ ನಾ! ಅಜುನ್‍ಬಿ ಕವ್ಡೊ ಎಳ್ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹವ್ಚೆ? ಮಿಯಾ ಕವ್ಡೊ ಎಳ್ ತುಮ್ಕಾ ಸೊಸುನ್ ಘೆವ್ನ್ ಜವ್ಚೆ? ತ್ಯಾ ಪೊರಾಕ್ ಮಾಜೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆವಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ತನ್ನಾ ತೆನಿ ತ್ಯಾ ಪೊರಾಕ್ ತೆಚೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ಜೆಜುಕ್ ಬಗಟಲ್ಲೆಚ್ ತ್ಯಾ ಗಿರ್‍ಯಾನ್ ತೆಕಾ ಕಡ್ಕಡಿ ಸರ್ಕೆ ಕರ್‍ಲ್ಯಾನ್ , ತ್ಯಾ ಪೊರಾಕ್ ಜಿಮ್ನಿಕ್ ಪಾಡ್ವುಲ್ಯಾನ್ ತನ್ನಾ ತೊ ಪೊರ್ ಖಾಲ್ತಿ ಪಡುನ್ ತೊಂಡಾತ್ನಾ ಫೆನ್ ಕಾಡುನ್ಗೆತ್ ತಳ್ಮಳುಕ್ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“ಹೆಕಾ ಕನ್ನಾಚ್ಯಾನ್ ಅಶೆ ಹೊವ್ಲಾ?” ಮನುನ್ ಜೆಜುನ್ ತ್ಯಾ ಪೊರಾಂಚ್ಯಾ ಬಾಬಾಕ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತೆನಿ “ತೊ ಬಾರಿಕ್ ಹೊತ್ತೊ ತನ್ನಾಚ್ಯಾನುಚ್ ತೆಕಾ ಅಶೆ ಹೊವ್ಲಾ,” ಮನುನ್ ಸಾಂಗುನ್ ");
INSERT INTO kans_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ಲೈಂದಾ ತ್ಯಾ ಗಿರ್‍ಯಾನ್ ತೆಚೊ ಜಿವ್ ಕಾಡುಸಾಟಿ ಮನುನ್ ಆಗಿತ್, ಪಾನಿಯಾತ್ ನ್ಹೆವ್ನ್ ಪಾಡ್ವುಕ್ ಕಸ್‍ರತ್ ಕರಲ್ಲೆ ಹಾಯ್, ದಯಾ ಕರುನ್ ತುಕಾ ಸಾದ್ಯ್ ಹೊಲ್ಯಾರ್ ಅಮ್ಕಾ ಮಜತ್ ಕರ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ತನ್ನಾ ಜೆಜುನ್ “ತುಕಾ ಸಾದ್ಯ್ ಹೊಲ್ಯಾರ್! ವಿಶ್ವಾಸ್ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಸಗ್ಳೆ ಸಾದ್ಯ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ತನ್ನಾ ತ್ಯಾ ಪೊರಾಂಚ್ಯಾ ಬಾಬಾನ್ “ಮಾಕಾ ವಿಶ್ವಾಸ್ ಹಾಯ್, ಖರೆ ತೊ ಫಿರೆ ಹೊಯ್ನಾ, ವಿಶ್ವಾಸ್ ಕರುಕ್ ತಿಯಾಚ್ ಮಾಕಾ ಅದಾರ್ ದಿ!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ಲೊಕಾಂಚೊ ತಾಂಡೊ ಅಪ್ನಾಕ್ಡೆ ಯೆವ್ನ್ ಜಮ್ತಲೆ ಜೆಜುನ್ ಬಗಟ್ಲ್ಯಾನ್. ತಸೆ ಮನುನ್ ತೆನಿ ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ “ಯೆ, ಬೊಲಿನಸಿ ಸರ್ಕೆ ಅನಿ ಆಯ್ಕಿನಸಿ ಸರ್ಕೆ ಕರ್‍ತಲ್ಯಾ ಗಿರ್‍ಯಾ, ಹ್ಯಾ ಪೊರಾತ್ನಾ ಭಾಯ್ರ್ ಪಡ್ ಅನಿ ಕನ್ನಾಬಿ ತೆಚ್ಯಾ ಭುತ್ತುರ್ ಜವ್ನಕೊ!” ಮನುನ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ತ್ಯಾ ಗಿರ್‍ಯಾನ್ ಜೊರಾನಿ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್ ಅನಿ ತ್ಯಾ ಝಿಲ್ಗ್ಯಾಕ್ ಜಿಮ್ನಿಕ್ ಪಾಡ್ವುನ್, ತಳ್ಮಳಿಸರ್ಕೆ ಕರ್‍ಲ್ಯಾನ್ ಅನಿ ತೆಚಾತ್ನಾ ಭಾಯ್ರ್ ಗೆಲೊ, ತೊ ಝಿಲ್ಗೊ ಹಾಲಿನಸ್ತಾನಾ ಪಡ್ಲೊ. ತನ್ನಾ ಸಗ್ಳ್ಯಾನಿ ತೊ ಮರ್‍ಲೊಚ್ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ಖರೆ ಜೆಜುನ್ ತ್ಯಾ ಝಿಲ್ಗ್ಯಾಕ್ ಹಾತ್ ಧರುನ್ ಉಟ್ವುಲ್ಯಾನ್, ತನ್ನಾ ತೊ ಝಿಲ್ಗೊ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ಮಾನಾ ಜೆಜು ಘರಾತ್ ಭುತ್ತುರ್ ಗೆಲೊ, ಶಿಸಾನಿ ತೊ ಎಕ್ಲೊ ಹೊತ್ತ್ಯಾ ತನ್ನಾ “ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ ಭಾಯ್ರ್ ಕಾಡುಕ್ ಅಮ್ಕಾ ಕಶ್ಯಾಕ್ ಹೊವ್ಕ್ ನಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ತನ್ನಾ ಜೆಜುನ್ “ತಸ್ಲ್ಯಾಕ್ನಿ ಖಾಲಿ ಮಾಗ್ನಿ ಸೊಡುನ್ ಅನಿ ಕಾಚೆನ್ಬಿ ಭಾಯ್ರ್ ಕಾಡುಕ್ ಹೊಯ್ನಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ ತೊ ಜಾಗೊ ಸೊಡುನ್ ಗಾಲಿಲಿಯಾತ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಜಾವ್‍ಲಾಗಲ್ಲ್ಯಾನಿ, ಅಪ್ನಿ ಖೈ ಹಾವ್ ಮನುನ್ ಲೊಕಾಕ್ನಿ ಕಳ್ತಲೆ ಜೆಜುಕ್ ನಕ್ಕೊ ಹೊತ್ತೆ, ");
INSERT INTO kans_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಶಿಸಾಕ್ನಿ ಶಿಕ್ವುಲಾಗಲ್ಲೊ. ತನ್ನಾ ಜೆಜುನ್ “ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಧರುನ್ ಲೊಕಾಂಚ್ಯಾ ಹಾತಾತ್ ದಿತ್ಯಾತ್, ಅನಿ ತಿ ಲೊಕಾ ತೆಕಾ ಜಿವಾನಿ ಮಾರ್‍ತ್ಯಾತ್, ಜಾಲ್ಯಾರ್‍ಬಿ ತಿನ್ವ್ಯಾ ದಿಸಿ ತೊ ಅನಿ ಪರ್ತುನ್ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆತಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ಖರೆ ಶಿಸಾಕ್ನಿ ತೆಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಅರ್‍ತುಚ್ ಹೊವ್ಕ್‌ನ್ಯಾತ್, ಜಾಲ್ಯಾರ್‍ಬಿ ಜೆಜುಕ್ ಹ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚೊ ಅರ್ತ್‍ ಕಾಯ್ ಮನುನ್ ಇಚಾರುಕ್ ತೆಂಕಾ ಧೈರೊ ಹೊವ್ಕ್‌ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ಜೆಜು ಅನಿ ಶಿಸಾ ಕಫರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ ಯೆಲ್ಯಾನಿ. ತೆನಿ ಎಕ್ ಘರಾತ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ಲ್ಯಾ ಶಿಸಾಕ್ನಿ “ಆಜ್ ತುಮಿ ಯೆತಾನಾ ವಾಟೆ ವರ್‍ತಿ ಕಾಯ್ ವಾದ್ ಕರುಕ್ ಲಾಗಲ್ಲ್ಯಾಸಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ತನ್ನಾ ಶಿಸಾನಿ ಕಾಯ್ಬಿ ಜಬಾಬ್ ದಿವ್ಕನ್ಯಾತ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಅಮ್ಚ್ಯಾ ಮದ್ದಿ ಕೊನ್ ಮೊಟೊ ಮನುನ್ ತೆನಿ ವಾದ್ ಕರುಕ್ ಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ಜೆಜು ಬಸ್ಲೊ ಅನಿ ಬಾರಾ ಜಾನಾಕ್ನಿಬಿ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುನ್ “ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಕೊನಾಕ್ ಮೊಟೊ ಮನುನ್ ಘೆವ್ಕ್ ಮನ್ ಹಾಯ್, ತೊ ಹುರಲ್ಲೆ ಸಗ್ಳೆ ಜಾನಾ ಅಪ್ನಾಚ್ಯಾನ್ಕಿ ಮೊಟೆ ಮನುನ್ ಯೌಜುಕ್ ಪಾಜೆ, ಅನಿ ತೆಂಚೊ ಸೆವಕ್ ಹೊವ್ಚೊ,” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ಮಾನಾ ಜೆಜುನ್ ಎಕ್ ಬಾರಿಕ್ಲ್ಯಾ ಪೊರಾಕ್ ಬಲ್ವುನ್ ಶಿಸಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಇಬೆ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ತ್ಯಾ ಪೊರಾಕ್ ಯ್ಯಾಂಗ್ ಮಾರುನ್ ");
INSERT INTO kans_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ಜೊ ಮಾನುಸ್ ಎಕ್ ಬಾರಿಕ್ ಪೊರಾಕ್ ಮಾಜ್ಯಾ ನಾವಾನ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ, ತೊ ಮಾಕಾಚ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ, ಮಾಕಾ ಜೊ ಕೊನ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ ತೊ ಮಾಕಾ ಎವ್ಡೆಚ್ ನ್ಹಯ್, ಮಾಕಾ ಧಾಡಲ್ಲ್ಯಾಕುಚ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ಜುವಾಂವಾನ್ ಜೆಜುಕ್ “ಗುರುಜಿ, ಕೊನ್ಕಿ ಎಕ್ಲೊ ತುಜ್ಯಾ ನಾವಾನ್ ಗಿರೆ ಕಾಡ್ತಲೆ ಅಮಿ ಬಗಟ್ಲಾವ್, ತೊ ಅಮ್ಚೊ ಮಾನುಸ್ ನ್ಹಯ್, ತಸೆ ಮನುನ್ ತುಜೆ ನಾವ್ ಘೆವ್ನ್ ಹೆ ಸಗ್ಳೆ ಕರುನಕೊ ಮನುನ್ ಅಮಿ ತೆಕಾ ಸಾಂಗ್ಲಾಂವ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ತನ್ನಾ ಜೆಜುನ್ “ತೆಕಾ ಅಡ್ವುನಕಾಶಿ, ಮಾಜ್ಯಾ ನಾವಾನ್ ಅಜಾಪಾ ಕರ್‍ತಲೊ ತನ್ನಾಚ್ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಬುರ್ಶೆ ಸಾಂಗುಕ್ ಸಾದ್ಯ್ ನಾ, ");
INSERT INTO kans_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ಜೆ ಕೊನ್ ಅಮ್ಕಾ ವಿರೊದ್ ನಾ ತೊ ಅಮ್ಚೊ ದೊಸ್ತುಚ್. ");
INSERT INTO kans_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ಖರೆಚ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ತುಮಿ ಮಾಜ್ಯೆ ಮನುನ್ ಕಳುನ್, ಕೊನ್ ತರ್ ತುಮ್ಕಾ ಎಕ್ ತಾಂಬ್ಯಾ ಪಾನಿ ದಿಲ್ಯಾರ್ಬಿ, ತೆಂಕಾ ತೆಚೊ ಪ್ರತಿಫಳ್ ಖರೆಚ್ ವಾವುನುಚ್ ಗಾವ್ತಾ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ಮಾಜೆ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಥವ್ತಲ್ಯಾ ಹ್ಯಾ ಬಾರಿಕ್ಲ್ಯಾತ್ನಿ, ಎಕ್ಲ್ಯಾಕ್ ಸೈತ್ ವಿಶ್ವಾಸ್ ಕಳ್ದುನ್ ಘೆವ್ಕ್ ಕೊನ್ ಕಾರನ್ ಹೊತಾ, ತೆಚಾ ಗಳ್ಯಾತ್ ಎಕ್ ಮೊಟೊ ಜಾತ್ಯಾಚೊ ಗುಂಡೊ ಭಾಂದುನ್ ಸಮುಂದರಾತ್ ತಾಕಲ್ಲೆ ಬರೆ, ");
INSERT INTO kans_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ತುಜೊ ಹಾತ್ ತುಜೊ ವಿಶ್ವಾಸ್ ಕಳ್ದುನ್ ಘೆವ್ಕ್ ಕಾರನ್ ಹೊತಾ ಜಾಲ್ಯಾರ್, ತೊ ಕಾತ್ರುನ್ ಕಾಡುನ್ ಸೊಡ್, ದೊನ್ ಹಾತಾ ಘೆವ್ನ್ ಕನ್ನಾಚ್ ಇಜಿನಸಲ್ಲಿ ಆಗ್ ಹೊತ್ತ್ಯಾ ನರ್ಕಾತ್ ಜಾತಲ್ಯಾಚ್ಯಾನ್ಕಿ, ಎಕ್ ಹಾತ್ ನಸ್ತಾನಾ ನಿರಂತರ್ ಜಿವನಾಕ್ ಜಾತಲೆ ಕವ್ಡೆಕಿ ಬರೆ. ");
INSERT INTO kans_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ಉಲ್ಲ್ಯಾ ಗ್ರಿಕ್ ಪ್ರತಿಯಾತ್ನಿ ಚಾಳಿಸಾರ್ ಚಾರ್ವೆವೆಚಿ ಗೊಸ್ಟ್ ಹಾಯ್, ತೆ ಚಾಳಿಸಾರ್ ಆಟ್ವೆಚಿ ಗೊಸ್ಟ್ ಅಸಲ್ಲ್ಯಾ ಸರ್ಕೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ತುಜೊ ಪಾಯ್ ತುಜೊ ವಿಶ್ವಾಸ್ ಕಳ್ದುನ್ ಘೆವ್ಕ್ ಕಾರನ್ ಹೊತಾ ಜಾಲ್ಯಾರ್, ತೊ ಪಾಯ್ ಕಾತ್ರುನ್ ಕಾಡ್, ದೊನ್ ಪಾಯಾ ಘೆವ್ನ್ ಕನ್ನಾಚ್ ಇಜಿನಸಲ್ಲಿ ಆಗ್ ಹೊತ್ತ್ಯಾ ನರ್ಕಾಕ್ ಜಾತಲ್ಲ್ಯಾಚ್ಯಾನ್ಕಿ ಎಕ್ ಪಾಯ್ ನಸ್ತಾನಾ ಸೊಟ್ಟೊ ಹೊವ್ನ್ ನಿರಂತರ್ ಜಿವನಾಕ್ ಜಾತಲೆ ಬರೆ. ");
INSERT INTO kans_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ಉಲ್ಲ್ಯಾ ಗ್ರಿಕ್ ಪ್ರತಿಯಾತ್ನಿ 46 ವೆಚಿ ಗೊಸ್ಟ್ ಹಾಯ್, ತಿ ಗೊಸ್ಟ್ 48 ವೆಚಿ ಗೊಸ್ಟ್ ಹೊತ್ತ್ಯಾ ಸರ್ಕಿಚ್ ಹಾಯ್ . ");
INSERT INTO kans_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ಅನಿ ತುಜೊ ಡೊಳೊ ತುಜೊ ವಿಶ್ವಾಸ್ ಕಳ್ದುನ್ ಘೆವ್ಕ್ ಕಾರನ್ ಹೊತಾ ಜಾಲ್ಯಾರ್, ತೊ ಡೊಳೊ ಕಾಡುನ್ ಟಾಕ್, ದೊನ್ ಡೊಳೆ ಥವ್ನ್ ಘೆವ್ನ್ ನರ್ಕಾತ್ ಜಾತಲ್ಯಾನ್ಕಿ ಎಕ್ ಡೊಳೊ ಘೆವ್ನ್ ದೆವಾಚ್ಯಾ ರಾಜ್ಜ್ಯಾಕ್ ಜಾತಲೆ ಕವ್ಡೆಕಿ ಬರೆ. ");
INSERT INTO kans_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ನರ್ಕಾತ್ ತೆಂಕಾ ಚಾಂವ್ತಲೊ ಕಿಡೊ ಕನ್ನಾಚ್ ಮರಿನಾ, ಅನಿ ತೆಂಕಾ ಜಾಳ್ವುತಲಿ ಆಗ್ ಕನ್ನಾಚ್ ಇಜಿನಾ.” ");
INSERT INTO kans_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ಬಲಿ ಮಿಟ್ಟಾನ್ ಪವಿತ್ರ್ ಕರ್ಲ್ಯಾ ಸರ್ಕೆ ಸಗ್ಳ್ಯಾ ಜಾನಾಕ್ನಿ ಆಗಿನ್ ಪವಿತ್ರ್ ಕರುನ್ ಹೊತಾ.” ");
INSERT INTO kans_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ಮಿಟ್ ಬರೆ ಹೊಯ್, ಖರೆ ಮಿಟ್ಟಾನುಚ್ ಅಪ್ನಾಚಿ ರುಚಿ ಕಳ್ದುನ್ ಘೆಟ್ಲ್ಯಾನ್ ತರ್ ತೆಕಾ ಖಾರ್ಪಾನ್ ಖೈತ್ನಾ ಹಾಂತ್ಯಾಸಿ? ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಮಿಟಾ ಸಾರ್ಕೊ ಪ್ರೆಮ್ ರ್‍ಹಂವ್ದಿತ್, ಎಕಾಮೆಕಾಕ್ ಸಮಾದಾನಾನ್ ರ್‍ಹಾವಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ಮಾನಾ ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್ ಜುದೆಯಾ ಪ್ರಾತ್ಯಾಕ್ ಅನಿ ಜೊರ್ದಾನ್ ನ್ಹಯ್ಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಗೆಲೊ.ಅನಿಬಿ ಸುಮಾರ್ ಲೊಕಾ ತೆಚ್ಯಾ ಫಾಟ್ನಾ ಯೆಲಿ. ಸದ್ದಿಚ್ಯಾ ಬಾಸೆನ್ ಜೆಜುನ್ ತೆಂಕಾ ಶಿಕ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ಥೈ ಉಲ್ಲಿ ಫಾರಿಜೆವಾ ಯೆವ್ನ್, ಜೆಜುಚಿ ಪರಿಕ್ಷಾ ಕರುಕ್ ಮನುನ್ “ಎಕ್ ಘೊಮನ್ಸಾನ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಸೊಡ್ತಲ್ಯಾ ವಿಶಯಾತ್ ಅಮ್ಚೊ ಖಾಯ್ದೊ ಕಾಯ್ ಸಾಂಗ್ತಾ?” ಮನುನ್ ತೆಕಾ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ತನ್ನಾ ಜೆಜುನ್ “ಮೊಯ್ಜೆನ್ ತುಮ್ಕಾ ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಕಾಯ್ ಮನುನ್ ಖಾಯ್ದೊ ದಿಲ್ಯಾನಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ತನ್ನಾ ಫಾರಿಜೆವಾನಿ “ಎಕ್ಲ್ಯಾನ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಸೊಡ್ ಪತ್ರ್ ಲಿವ್ನ್ ದಿವ್ನ್ ಸೊಡುನ್ ದಿವ್ಕ್ ಹೊತಾ ಮನುನ್ ಮೊಯ್ಜೆನ್ ಸಾಂಗ್ಲ್ಯಾನಾಯ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ತನ್ನಾ ಜೆಜುನ್ “ತುಮ್ಚ್ಯೆ ಮಂಡ್ಪಾನಾಕ್ ಬಗುನ್ ಮೊಯ್ಜೆನ್ ತುಮ್ಕಾ ತೊ ಖಾಯ್ದೊ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ಖರೆ, ದೆವಾನ್ ಹಿ ಸಗ್ಳಿ ದುನಿಯಾ ರಚ್ತಾನಾ ಮಾನ್ಸಾಕ್ನಿ ಘೊಮಾನುಸ್ ಅನಿ ಬಾಯ್ಕೊಮನುಸ್ ಕರುನ್ ರಚ್ಲ್ಯಾನ್.” ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ಹೆಚೆ ಸಾಟ್ನಿ ಎಕ್ ಘೊಮನುಸ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ ಸೊಡ್ತಾ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಚ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊತಾ, ");
INSERT INTO kans_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ಅನಿ ತೆನಿ ದೊಗೆಬಿ ಎಕ್ ಶರಿರ್ ಹೊತ್ಯಾತ್, ತಸೆ ಮನುನ್ ತೆನಿ ದೊಗೆ ಜಾನಾ ನ್ಹಯ್, ತೆನಿ ಎಕುಚ್, ");
INSERT INTO kans_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","“ಅಶೆ ರಾತಾನಾ ದೆವಾನ್ ಜೊಡ್ವಲ್ಲೆ ಮಾನ್ಸಾನ್ ಮೊಡುಚೆ ನ್ಹಯ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ಘರಾಕ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಶಿಸಾನಿ ಜೆಜುಕ್ ಹ್ಯಾ ವಿಶಯಾತ್ ಇಚಾರ್‍ಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ತನ್ನಾ ಜೆಜುನ್ “ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಸೊಡುನ್ ದುಸ್ರ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ಡೆ ಲಗಿನ್ ಹೊಲ್ಲೊ ಮಾನುಸ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಚ್ಯಾ ವಿರೊದ್ ವೆಭಿಚಾರ್ ಕರ್‍ತಾ,” ");
INSERT INTO kans_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","“ತಸೆಚ್ ಎಕ್ ಬಾಯ್ಕೊಮನುಸ್ ಘೊವಾಕ್ ಸೊಡುನ್ ದುಸ್ರ್ಯಾ ಮಾನ್ಸಾಕ್ಡೆ ಲಗಿನ್ ಹೊಲ್ಯಾರ್, ತಿ ಬಿ ವೆಭಿಚಾರ್ ಕರ್‍ತಾ” ಮನುನ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ಥೊಡ್ಯಾನಿ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಪೊರಾಂಚ್ಯಾ ವರ್‍ತಿ ಹಾತ್ ಥವ್ಕ್ ಮನುನ್ ತೆಂಚ್ಯಾ ಪೊರಾಕ್ನಿ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ, ಖರೆ ಶಿಸಾನಿ ತೆಂಕಾ ಅಡ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ಹೆ ಬಗುನ್ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವರ್‍ತಿ ರಾಗ್ ಹೊಲೊ ಅನಿ “ಪೊರಾಕ್ನಿ ಮಾಜೆಕ್ಡೆ ಯೆವ್ಕ್ ಸೊಡಾ, ತೆಂಕಾ ಅಡ್ವುನಕಾಶಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ದೆವಾಚೆ ರಾಜ್ ಅಸ್ಲ್ಯಾಂಚೆಚ್,” ");
INSERT INTO kans_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ಖರೆಚ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ “ಎಕ್ ಪೊರಾಂಚ್ಯಾ ಬಾಸೆನ್, ಬರ್‍ಯಾ ಮನಾನ್ ಜೆ ಕೊನ್ ದೆವಾಚೆ ರಾಜ್ ಸ್ವಿಕಾರ್ ಕರಿನಾ, ತೊ ಕನ್ನಾಚ್ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಜಾವ್ನ್ ಪಾವುಕ್ ಹೊಯ್ನಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ಮಾನಾ ಜೆಜುನ್ ಪೊರಾಕ್ನಿ ಅಪ್ನಾಚ್ಯಾ ಹಾತಿನಿ ಯಾಂಗ್ ಮಾರುನ್ ಧರುನ್ ಅಪ್ಲೊ ಹಾತ್ ತೆಂಚ್ಯಾ ಟಕ್ಲ್ಯಾ ವರ್‍ತಿ ಥವ್ನ್ ತೆಂಕಾ ಆಶಿರ್ವಾದ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ಜೆಜು ಥೈತ್ನಾ ಜಾವ್ಕ್ ಮನುನ್ ತಯಾರ್ ಹೊವ್ಕ್ ಲಾಗಲ್ಲೊ, ತನ್ನಾ ಎಕ್ ಮಾನುಸ್ ಪಳುನ್ ಯೆವ್ನ್ ಜೆಜುಚ್ಯಾ ಇದ್ರಾಕ್ ಡೊಗ್ಲಾ ಟೆಕುನ್ “ಬರ್‍ಯಾ ಗುರುಜಿ, ನಿರಂತರ್ ಜಿವನ್ ಮಾಕಾ ಗಾವುಚೆ ತರ್, ಮಿಯಾ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ಜೆಜುನ್ ತೆಕಾ “ಮಾಕಾ ಬರೊ ಮನುನ್ ಕಶ್ಯಾಕ್ ಬಲ್ವುತೆ, ದೆವಾಕ್ ಸೊಡುನ್ ಕೊನ್ಬಿ ಬರೊ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ತುಕಾ ಖಾಯ್ದೆ ಗೊತ್ತ್ ಹಾತ್; ಜಿವಾನಿ ಮಾರುನಕೊ, ವೆಭಿಚಾರ್ ಕರುನಕೊ, ಚೊರುನಕೊ, ಅನಿ ಎಕ್ಲ್ಯಾವರ್ತಿ ಝುಟೆ ಅಪ್ವಾದ್ ಘಾಲುನಕೊ, ಮೊಸ್ ಕರುನಕೊ, ಅನಿ ತುಜ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ ಮಾನ್‍ ದಿ.” ");
INSERT INTO kans_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾನ್ “ಗುರುಜಿ, ಮಿಯಾ ಬಾರಿಕ್ ಅಸ್ತಾನಾಚ್ಯಾನ್ ಹೆ ಸಗ್ಳೆ ಖಾಯ್ದೆ ಪಾಳುನ್ಗೆತ್ ಹಾಂವ್,” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ಜೆಜುನ್ ಪ್ರೆಮಾನ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಬಗಟ್ಲ್ಯಾನ್ ಅನಿ “ತಿಯಾ ಎಕ್ ಕರ್‍ತಲೆ ಹಾಯ್, ಜಾ ಅನಿ ತುಜೆಕ್ಡೆ ಹೊತ್ತೆ ಸಗ್ಳೆ ಇಕ್, ಅನಿ ಯೆಲ್ಲೆ ಪೈಸೆ ಗರಿಬಾಕ್ನಿ ದಿ, ಅನಿ ಸರ್‍ಗಾತ್ ತುಕಾ ಖರಿ ಸಾವ್ಕಾರ್ಕಿ ರ್‍ಹಾತಾ, ಮಾನಾ ಯೆ ಅನಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆ,” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ಹೆ ಆಯ್ಕುನ್ ತೆಚೆ ತೊಂಡ್ ಬಾಡ್ಲೆ, ಅನಿ ತೊ ಬೆಜಾರಾನ್ ಥೈತ್ನಾ ಗೆಲೊ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಲೈ ಸಾವ್ಕಾರ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ಮಾನಾ ಜೆಜುನ್ ಭೊತ್ಯಾನಿ ಬಗುನ್ ಶಿಸಾಕ್ನಿ “ಎಕ್ ಸಾವ್ಕಾರಾಕ್ ದೆವಾಚ್ಯಾ ರಾಜ್ಜ್ಯಾತ್ ಪ್ರವೆಸ್ ಕರ್‍ತಲೆ ಕವ್ಡೆ ಕಸ್ಟ್ ಹಾಯ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ಜೆಜುನ್ ಅಶೆ ಮಟಲ್ಲೆ ಆಯ್ಕುನ್ ಶಿಸಾ ಅಜಾಪ್ ಹೊಲಿ. ಅನಿಬಿ ಜೆಜುನ್ “ಮಾಜ್ಯಾ ಪೊರಾನೊ, ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಜಾತಲೆ ಮಟ್ಲ್ಯಾರ್ ಕವ್ಡೊ ಕಸ್ಟ್! ");
INSERT INTO kans_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ಎಕ್ ಒಂಟೆ ಸುಯಿಚ್ಯಾ ಡೊಳ್ಯಾತ್ನಾ ಅರಾಮ್ ಪಾರ್ ಹೊಯ್ಲ್, ಖರೆ ಎಕ್ ಸಾವ್ಕಾರ್ ಮಾನ್ಸಾಕ್ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಗುಸುಚೆ ಮಟ್ಲ್ಯಾರ್ ತವ್ಡೆ ಸಸಾರ್ ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ಶಿಸಾ ಅನಿ ಉಲ್ಲಿ ಅಜಾಪ್ ಹೊಲಿ ಅನಿ “ತಸೆ ಹೊಲ್ಯಾರ್, ಕೊನ್ ರಕ್ಷನ್ ಹೊತಾ?” ಮನುನ್ ಬೊಲುನ್ಗೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಬಗುನ್ “ಮಾನ್ಸಾಕ್ ಹೆ ಸಾದ್ಯ್ ನಾ ಹೊಯ್, ಖರೆ ದೆವಾಕ್ ಅಸಾದ್ಯ ಮನ್ತಲೆ ಕಾಯ್‍ ಬಿ ನಾ” ದೆವಾಕ್ ಸಗ್ಳೆಬಿ ಸಾದ್ಯ್, ");
INSERT INTO kans_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ತನ್ನಾ ಪೆದ್ರುನ್ “ಅಮಿ ಜಾಲ್ಯಾರ್ ಅಮ್ಚೆ ಸಗ್ಳೆ ಸೊಡುನ್ ತುಜ್ಯಾ ಫಾಟ್ನಾ ಹಾಂವ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ತನ್ನಾ ಜೆಜುನ್ “ಹೊಯ್, ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಮಾಜೆ ಸಾಟ್ನಿ ಅನಿ ದೆವಾಚ್ಯಾ ಬರ್ಯಾ ಖಬ್ರೆ ಸಾಟ್ನಿ, ಅಪ್ನಾಚೆ ಘರ್ ಹೊಂವ್ದಿ, ಭಾವಾಕ್ನಿ-ಭೆನಿಯಾಕ್ನಿ ಹೊಂವ್ದಿ, ಬಾಯ್ಕ್-ಬಾಬಾಕ್ ಹೊಂವ್ದಿ, ಪೊರಾಕ್ನಿ ಹೊಂವ್ದಿ, ಶೆತ್ ಹೊಂವ್ದಿ, ಜೊ ಮಾನುಸ್ ಸೊಡುನ್ ಯೆತಾ, ");
INSERT INTO kans_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ತೆಕಾ ಶೆಂಬರ್ ವಾಟ್ಯಾನಿ ಗಾವ್ತಾ, ತವ್ಡೆಚ್ ನ್ಹಯ್ ಹ್ಯಾ ದುನಿಯಾತ್ ಪಾಜೆ ತವ್ಡಿ ಘರಾ, ಭಾವಾ, ಭೆನಿಯಾ, ಅವ್ಸಿಯಾ, ಪೊರಾ ಅನಿ ಶೆತ್ ಗಾಂವ್ತಾ ಅನಿ ಹೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ತರಾಸ್ಬಿ ಹಾಯ್. ಅನಿ ಹೆ ಸೊಡ್ಲ್ಯಾರ್ ಫಿಡೆ ಯೆತಲ್ಯಾ ಕಾಲಾತ್ ನಿರಂತರ್ ಜಿವನ್ಬಿ ತೆಕಾ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ಅತ್ತಾ ಜೆ ಕೊನ್ ಲೈ ಖಾಯ್ಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಹಾತ್ ತೆನಿ ಎಗ್ದಮ್ ವೈರ್ ಹೊತ್ಯಾತ್, ಅನಿ ಅತ್ತಾ ಕೊನ್ ವೈಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಹಾತ್ ತೆನಿ ಖಾಲ್ತಿ ಹೊತ್ಯಾತ್.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ಜೆಜು ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ ಲೊಕಾ ಜೆರುಜಲೆಮಾಚ್ಯಾ ವಾಟೆನ್ ಜಾವ್ನಗೆತ್ ರಾತಾನಾ, ಜೆಜು ಶಿಸಾಂಚ್ಯಾ ಫಿಡೆ-ಫಿಡೆ ಜಾವ್ನಗೆತ್ ಹೊತ್ತೊ, ಶಿಸಾ ಭಿಂಯಾವಲ್ಲ್ಯಾ ಸರ್ಕಿ ಹೊಲ್ಲಿ, ಅನಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ ಲೊಕಾ ಭಿಂಯಾವಲ್ಲಿ. ಅನಿ ಎಗ್ದಾ ಜೆಜು ಬಾರಾ ಜಾನಾ ಶಿಸಾಕ್ನಿ ಕಡೆಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ");
INSERT INTO kans_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“ಆಯ್ಕಾ, ಅಮಿ ಅತ್ತಾ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾಂವ್, ಥೈ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಮಹಾಯಾಜಕಾಂಚ್ಯಾ ಅನಿ ಶಾಸ್ತರಾ ಸಾಂಗ್ತಲ್ಯಾಂಚ್ಯಾ ಹಾತಿತ್ ಧರುನ್ ದಿತ್ಯಾತ್. ಮಾನಾ ತೆಚೆ ವರ್‍ತಿ ಅಪ್ವಾದ್ ಘಾಲುನ್ ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿವ್ನ್ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಹಾತಾತ್ ದಿತ್ಯಾತ್, ");
INSERT INTO kans_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ತಿ ಲೊಕಾ, ತೆಕಾ ಎಡ್ಸಡ್ತ್ಯಾತ್, ತೆಕಾ ಥುಕ್ತ್ಯಾತ್, ತೆಕಾ ಬಾರ್‍ಕೊಲಾನಿ ಮಾರ್‍ತ್ಯಾತ್. ಅನಿ ತೆಕಾ ಜಿವಾನಿಚ್ ಮಾರ್‍ತ್ಯಾತ್. ಖರೆ ತಿನ್ವ್ಯಾ ದಿಸಿ ತೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆತಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ಜೆಬೆದೆವಾಚಿ ಪೊರಾ ಜಾಕೊಬ್ ಅನಿ ಜುವಾಂವ್ ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್ “ಗುರುಜಿ, ಅಮ್ಚಿ ಎಕ್ ವಿನಂತಿ ಹಾಯ್ ತಿ ತಿಯಾ ಕರುನ್ ದಿವ್ಚೆ,” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ತನ್ನಾ ಜೆಜುನ್ “ಕಾಯ್ ತೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ತನ್ನಾ ತೆನಿ “ತಿಯಾ ವೈಭವಾನ್ ತುಜ್ಯಾ ರಾಜ್ಜ್ಯಾತ್ ಸಿವಾಸನಾರ್ ಬಸ್ತಾನಾ, ಅಮ್ಕಾ ದೊಗ್ಯಾಕ್ನಿ ಎಕ್ಲ್ಯಾಕ್ ತುಜ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಅನಿ ಅನ್ಯೆಕ್ಲ್ಯಾಕ್ ಡಾವ್ಯಾ ಬಾಜುಕ್ ಬಸುಕ್ ಅವ್ಕಾಸ್ ಕರುನ್ ದಿ” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ತನ್ನಾ ಜೆಜುನ್ ತುಮಿ ಕಾಯ್ ಇಚರುಲ್ಯಾಸಿ ಮನುನ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ನಾ, ಮಿಯಾ ಫಿತಲೆ ಹಾಯ್ ತ್ಯಾ ಸಂಕಟಾಚ್ಯಾ ಆಯ್ದಾನಾತ್ಲೆ ತುಮ್ಚ್ಯಾನ್ ಫಿವ್ಕ್ ಹೊತಾ ಕಾಯ್? ಮಿಯಾ ಘೆತಲೆ ಹಾಯ್ ತೆ ಬಾಲ್ತಿಮ್ ತುಮ್ಚ್ಯಾನ್ ಘೆವ್ಕ್ ಹೊತಾ ಕಾಯ್?\" ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ತೆನಿ “ಹೊಯ್ ಹೆ ಅಮಿ ಕರುಕ್ ಹೊತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ಮಿಯಾ ಫಿತಲ್ಯಾ ಆಯ್ದಾನಾತ್ಲೆ ತುಮಿ ಫಿತ್ಯಾಶಿ ಅನಿ ಮಿಯಾ ಘೆತಲೆ ಬಾಲ್ತಿಮ್ ತುಮಿ ಘೆತ್ಯಾಶಿ ತೆ ಖರೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ಖರೆ ಮಾಜ್ಯಾ ಉಜ್ವ್ಯಾಕ್ ಅನಿ ಮಾಜ್ಯಾ ಡಾವ್ಯಾಕ್ ಕೊನ್-ಕೊನ್ ಬಸ್ತಲೆ ಮನುನ್ ನಿರ್‍ದಾರ್ ಘೆತಲೊ ಅದಿಕಾರ್ ಮಾಕಾ ನಾ, ಜೆ ಕೊನಾಕ್ ತೆ ಜಾಗೆ ತಯಾರ್ ಕರುನ್ ಥವಲ್ಲೆ ಹಾತ್, ತೆಂಕಾ ತೆ ಜಾಗೆ ರಾಕುನ್ ಥವಲ್ಲೆ ಹಾತ್, ತೆ ದೆವುಚ್ ತೆಂಕಾ ದಿತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ಹುರಲ್ಲಿ ಧಾ ಶಿಸಾ ಹೆ ಆಯ್ಕುನ್ ಜುವಾಂವ್ ಅನಿ ಜಾಕೊಬಾಚ್ಯಾ ವರ್‍ತಿ ರಾಗ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ಮಾನಾ ಜೆಜುನ್ ಸಗ್ಳ್ಯಾ ಶಿಸಾಕ್ನಿ ಜಗ್ಗೊಳ್ ಬಲ್ವುನ್ “ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಅದಿಕಾರ್‍ಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್, ತೆ ಅದಿಕಾರಿ ಅಪ್ನಾಕ್ ಹೊತ್ತೊ ಅದಿಕಾರ್ ಲೊಕಾಕ್ನಿ ದಾಕ್ವುಕ್ ಲೈ ಕುಶಿ ಹೊತ್ಯಾತ್.ಅನಿ ತೆಂಕಾ ತೆಂಚ್ಯಾ ವರ್‍ತಿ ಸಗ್ಳೊ ಅದಿಕಾರ್ ದಿಲ್ಲೊ ಹಾಯ್, ");
INSERT INTO kans_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ತೆ ರಾಂವ್ದಿತ್, ಖರೆ ತುಮ್ಚ್ಯೆ ಮದ್ದಿ ತಸೆ ರ್‍ಹಾವ್ಚೆ ನ್ಹಯ್, ತುಮ್ಚ್ಯೆ ಮದ್ದಿ ಕೊನ್ ಮೊಟೊ ಹೊವ್ಚೆ ಮನುನ್ ಯವಜ್ತಾ ತೊ ಸಗ್ಳ್ಯಾಂಚೊ ಸೆವಕ್ ಹೊವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಕೊನ್ ಮೊಟೊ ಹೊವ್ಚೆ ಮನುನ್ ಯವಜ್ತಾ, ತೊ ಸಗ್ಳ್ಯಾಂಚೊ ಗುಲಾಮ್ ಹೊವ್ನ್ ರಾವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ತಸೆಚ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಲೊಕಾನಿಕ್ನಾ ಸೆವಾ ಕರುನ್ ಘೆವ್ಕ್ ಯೆವ್ಕ್ ನಾ, ಸೆವಾ ಕರುಕ್ ಅನಿ ಅಪ್ನಾಚೊ ಜಿವ್ ದಿವ್ನ್ ಸುಮಾರ್ ಜನಾಕ್ನಿ ಸುಟ್ಕಾ ಕರುಕ್ ಮನುನ್ ಯೆಲಾ”. ");
INSERT INTO kans_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ತೆನಿ ಜೆರಿಕೊ ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ ಯೆಲ್ಯಾನಿ. ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾವ್ಕ್ ಲಾಗಲ್ಲಿ ತನ್ನಾ ಲೊಕಾಂಚೊ ಮೊಟೊ ತಾಂಡೊ ತೆಂಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತೊ, ತಿಮೆವಾಚೊ ಲೆಕ್ ಬಾರ್ತಿಮೆವ್ ಮನ್ತಲ್ಯಾ ನಾವಾಚೊ ಎಕ್ ಕುಡ್ಡೊ ಭಿಕಾರಿ ತ್ಯಾ ರಸ್ತ್ಯಾಚ್ಯಾ ದಂಡೆಕ್ ಬಸಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ನಜರೆತಾಚೊ ಜೆಜು ಥೈತ್ನಾ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಆಯ್ಕುನ್, “ಜೆಜು! ದಾವಿದಾಚ್ಯಾ ಲೆಕಾ! ಮಾಜಿ ದಯಾ ಕರ್!” ಮನುನ್ ಜೊರಾನ್ ಬೊಬ್ ಮಾರುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ತನ್ನಾ ಲೊಕಾ ತೆಕಾ “ಗಪ್ ರ್‍ಹಾ” ಮನುನ್ ಜೊರ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾರ್ಬಿ ತೊ “ದಾವಿದಾಚ್ಯಾ ಲೆಕಾ ಮಾಜಿ ದಯಾ ಕರ್!” ಮನುನ್ ಅನಿಬಿ ಜೊರಾನ್ ಬೊಬ್ ಮಾರುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ಜೆಜು ಇಬೆ ರ್‍ಹಾಲೊ ಅನಿ “ತೆಕಾ ಹಿತ್ತೆ ಬಲ್ವಾ” ಮಟ್ಲ್ಯಾನ್. ತೆಚೆ ಸಾಟ್ನಿ ತೆನಿ ತ್ಯಾ ಮಾನ್ಸಾಕ್ “ಕುಶಿ ಹೊ” “ಉಟ್, ತೊ ತುಕಾ ಬಲ್ವುಲಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ತೊ ಅಪ್ನಾಚೆ ಕಾಮ್ರಾನ್ ಟಾಕುನ್, ಹುಡಿಯಾ ಮಾರುನ್ಗೆತ್ ಜೆಜುಕ್ಡೆ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ಜೆಜುನ್ ತೆಕಾ “ಮಿಯಾ ತುಕಾ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತ್ಯಾ ಕುಡ್ಡ್ಯಾನ್ “ಗುರುಜಿ, ಮಿಯಾ ಅನಿ ಬಗುಕ್ ಪಾಜೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ತುಜ್ಯಾ ವಿಶ್ವಾಸಾನುಚ್ ತುಕಾ ಬರೆ ಕರ್‍ಲ್ಯಾನ್, ಜಾ” ಮಟ್ಲ್ಯಾನ್, ತನ್ನಾಚ್ ತೆಚಿ ದಿಸ್ಟ್ ಯೆಲಿ ಅನಿ ತೊ ತ್ಯಾ ರಸ್ತ್ಯಾನಿ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ತೆನಿ ಜೆರುಜಲೆಮಾಚ್ಯಾ ಜಗ್ಗೊಳ್, ಬೆತ್ಫಗೆ ಅನಿ ಬೆಥನಿ ಮನ್ತಲ್ಯಾ ಶಾರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಥೈತ್ನಾ ಒಲಿವಾಚ್ಯಾ ಝಾಡಾಂಚ್ಯಾ ಮಡ್ಡಿ ವರ್‍ತಿ ಯೆಲ್ಲ್ಯಾನಿ. ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ಲ್ಯಾ ದೊಗೆ ಜಾನಾ ಶಿಸಾಕ್ನಿ, ಅಶೆ ಸಾಂಗುನ್ ಫಿಡೆ ಧಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ಥೈ ದಿಸುಕ್ ಲಾಗ್ಲಾ ತ್ಯಾ ಗಾಂವಾತ್ ಜಾಂವಾ. ತುಮಿ ತ್ಯಾ ಗಾಂವಾತ್ ಗುಸಲ್ಲ್ಯಾತನ್ನಾ, ಕೊನ್ಬಿ ಬಸುನಸಲ್ಲೊ ಎಕ್ ಗಾಡ್ವಾಚೊ ಪೆಟೊ ಥೈ ಭಾಂದಲ್ಲೊ ತುಮ್ಕಾ ಗಾವ್ತಾ, ತೆಕಾ ಸೊಡ್ವುನ್ ಮಾಜೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆವಾ. ");
INSERT INTO kans_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ಕೊನ್ ತರ್ ಗಾಡ್ವಾಕ್ ಕಶ್ಯಾಕ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಲ್ಯಾಸಿ ಮನುನ್ ಇಚಾರ್ಲ್ಯಾರ್ ಧನಿಯಾಕ್ ತೆಚಿ ಗರಜ್ ಹಾಯ್ ಅನಿ ಲಗ್ಗುನಾಚ್ ತೊ ತೆಕಾ ಫಾಟಿ ಧಾಡುನ್ ದಿತಾ ಮನುನ್ ಸಾಂಗಾ”. ");
INSERT INTO kans_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ತೆನಿ ತ್ಯಾ ಗಾಂವಾತ್ ಜಾವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ಥೈ ಎಕ್ ಘರಾಚ್ಯಾ ದಾರಾಕ್ ಭಾಂದುನ್ ಘಾಟಲ್ಲೆ ಗಾಡಾವ್ ತೆಂಕಾ ದಿಸ್ಲೆ. ತೆನಿ ಜಾವ್ನ್ ತ್ಯಾ ಗಾಡ್ವಾಕ್ ಸೊಡ್ಸುತಾನಾ ");
INSERT INTO kans_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ “ತುಮಿ ಗಾಡ್ವಾಕ್ ಕಶ್ಯಾಕ್ ಸೊಡ್ವುಲ್ಯಾಸಿ?” ಮನುನ್ ತೆಂಕಾ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ತೆನಿ ತೆಂಕಾ ಜೆಜುನ್ ಸಾಂಗಟ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ, ಅನಿ ತ್ಯಾ ಲೊಕಾನಿ ತೆಂಕಾ ಜಾವ್ಕ್ ಸೊಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ತೆನಿ ಗಾಡ್ವಾಚ್ಯಾ ಪೆಟ್ಯಾಕ್ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ, ಅನಿ ತ್ಯಾ ಜನಾವರಾಚ್ಯಾ ವರ್‍ತಿ ಫಾಳಿಯಾ ಘಾಟ್ಲ್ಯಾನಿ. ಜೆಜು ತೆಚೆ ವರ್‍ತಿ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ಸುಮಾರ್ ಲೊಕಾನಿ ತೆಂಚೆ ಕಪ್ಡೆ ರಸ್ತ್ಯಾ ವರ್‍ತಿ ಹಾತರ್‍ಲ್ಯಾನಿ. ಅನಿ ಹುರಲ್ಲ್ಯಾನಿ ಮ್ಹಳ್ಯಾನಿತ್ನಾ ಝಾಡಾಂಚಿ ಟಾಳಿಯಾ ಮೊಡುನ್ ಹಾನುನ್ ರಸ್ತ್ಯಾ ವರ್‍ತಿ ಘಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ಜೆಜುಚ್ಯಾ ಫಿಡೆ ಹೊತ್ತಿ ಅನಿ ಫಾಟ್ನಾ ಯೆತಲಿ ಲೊಕಾ ಜೊರಾನಿ ಬೊಬ್ ಮಾರುನ್ಗೆತ್ “ದೆವಾಕ್ ಮಹಿಮಾ! ಧನ್ಯಾಚ್ಯಾ ನಾವಾನ್ ಯೆತಾ ತೆಕಾ ದೆವ್ ಆಶಿರ್ವಾದ್ ದಿಂವ್ದಿ! ");
INSERT INTO kans_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ದೆವ್ ಅಮ್ಚ್ಯಾ ಬಾಬಾ ದಾವಿದಾಚೆ ರಾಜಾಕ್ ಅಶಿರ್ವಾದ್ ದಿಂವ್ದಿ! ತೆ ರಾಜ್ ಯೆವ್ಲಾ, ಸರ್‍ಗಾ ವೈಲ್ಯಾ ದೆವಾಕ್ ಮಹಿಮಾ ಹೊಂವ್ದಿ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ಜೆಜು ಅಶೆ ಜೆರುಜಲೆಮಾತ್ ಯೆವ್ನ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಗೆಲೊ ಅನಿ ಥೈ ತೆನಿ ಸಗ್ಳೆ ಬಗಟ್ಲ್ಯಾನ್. ಖರೆ ಲೈ ಎಳ್ ಹೊಲ್ಲೊ ಮನುನ್ ತೊ ಅಪ್ಲ್ಯಾ ಬಾರಾ ಜಾನಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೆಥನಿಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ದುಸ್ರೆಂದಿಸಿ, ತೆನಿ ಬೆಥಾನಿಯಾತ್ನಾ ಯೆತಾನಾ ಜೆಜುಕ್ ಲೈ ಭುಕ್ಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ಥೈ ವಾಟೆಚ್ಯಾ ದಂಡೆಕ್ ಎಕ್ ಪಾನಾನಿ ಭರಲ್ಲೆ ಅಂಜುರಾಚೆ ಝಾಡ್ ಹೊತ್ತೆ, ಥೈ ಕಾಯ್ ತರ್ ಗಾವ್ತಾ ಕಾಯ್ಕಿ ಮನುನ್ ಜೆಜು ತ್ಯಾ ಝಾಡಾಕ್ಡೆ ಗೆಲೊ, ಬಗಟ್ಲ್ಯಾರ್ ತ್ಯಾ ಝಾಡಾಕ್ ಪಾನಾ ಸೊಡುನ್ ಎಕ್ ಸೈತ್ ಹನ್ನ್ ನತ್ತೆ,ಖಾಲಿ ಪಾನಾ ಎವ್ಡಿಚ್ ಹೊತ್ತಿ.ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿ ಅಂಜುರಾಚಿ ಹನ್ನಾ ಹೊತಲಿ ದಿಸಾ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ತಸೆ ಮನುನ್ ಜೆಜುನ್ ತ್ಯಾ ಝಾಡಾಕ್ “ಹೆಚೆನ್ ಫಿಡೆ ತುಜಿ ಹನ್ನಾ ಕೊನ್ಬಿ ಖಾವ್ನಸುಂದಿತ್ ” ಮಟ್ಲ್ಯಾನ್. ಹೆ ಜೆಜುಚ್ಯಾ ಶಿಸಾನಿಬಿ ಆಯ್ಕಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ತೆನಿ ಜೆರುಜಲೆಮಾಕ್ ಯೆವ್ನ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಗೆಲ್ಯಾನಿ, ಥೈ ಲೊಕಾ ಸಾಮಾನಾ ಇಕ್ತಲೆ ಅನಿ ಘೆತಲೆ ಯಾಪಾರ್ ಕರುನ್ಗೆತ್ ಹೊತ್ತಿ. ಜೆಜುನ್ ತೆಂಕಾ ಗುಡಿತ್ನಾ ಭೈರ್ ಪಳ್ಸುನ್ ಘಾಟ್ಲ್ಯಾನ್. ಪಯ್ಸ್ಯಾಂಚೊ ಯಾಪಾರ್ ಕರ್‍ತಲ್ಯಾಂಚಿ ಮೆಜಾ ಅನಿ ಪಾರಿವಾಳಾ ಇಕ್ತಲ್ಯಾಂಚಿ ಕುರ್ಚಿಯಾ ಪಾಡ್ವುನ್ ಘಾಟ್ಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ಅನಿ ಗುಡಿಚ್ಯಾ ದಾರಾತ್ನಾ ಕಸ್ಲೆಬಿ ಸಾಮಾನ್ ವಾವುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಪರ್ವಾನ್ಗಿ ದಿವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ಮಾನಾ ಲೊಕಾಕ್ನಿ ಸಿಕ್ವುನ್ಗೆತ್ “ಮಾಜಿ ಗುಡಿ ಸಗ್ಳ್ಯಾ ದೆಸಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಮಾಗ್ನಿ ಕರ್‍ತಲೆ ಘರ್ ಮನುನ್ ಬಲ್ವುತ್ಯಾತ್ ”ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲೆ ಹಾಯ್ “ಖರೆ ತುಮಿ ತೆ ಚೊರಾಂಚೊ ಅಡ್ಡೊ ಕರುನ್ ಥವ್ಲ್ಯಾಶಿ.” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ಯಾಜಕಾಂಚಿ ಮುಖಂಡಾ ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾನಿ ಜೆಜುಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುನ್, ತೆಕಾ ಕಶೆ ಕರುನ್ ಜಿವಾನಿ ಮಾರುಚೆ ಮನುನ್ ವಾಟ್ ಹುಡ್ಕುಕ್ ಲಾಗಲ್ಲ್ಯಾನಿ. ಖರೆ ಲೊಕಾ, ಜೆಜು ಸಿಕ್ವುತಲೆ ಮಾನುನ್ ಘೆಯ್ತ್ ಅನಿ ಅಜಾಪ್ ಹೊಯ್ತ್. ತಸೆ ಮನುನ್ ತೆನಿ ತೆಕಾ ಭಿಂಯ್ತ್. ");
INSERT INTO kans_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ಮಾನಾ ಸಾಂಜ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ ಜೆರುಜಲೆಮ್ ಶಹರ್ ಸೊಡುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ಸಕ್ಕಾಳ್ಚೆ ತೆನಿ ವಾಟೆನ್ ಜಾತಾನಾ ಅದ್ಲ್ಯಾ ದಿಸಿ ಜೆಜುನ್ ಸರಾಪ್ ದಿಲ್ಲ್ಯಾ ಅಂಜುರಾಚ್ಯಾ ಝಾಡಾಕ್ ಬಗಟ್ಲ್ಯಾನಿ ತೆ ಝಾಡ್ ಬೆರಾ ಸಮೆತ್ ವಾಳುನ್ ಗೆಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ಪೆದ್ರುನ್ “ಗುರುಜಿ, ಎಬಕ್! ಕಾಲ್ ತಿಯಾ ಸರಾಪ್ ದಿಲ್ಲೆ ಝಾಡ್ ವಾಳುನ್ ಗೆಲಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ತನ್ನಾ ಜೆಜುನ್ “ದೆವಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಥವಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ತುಮ್ಚ್ಯಾತ್ಲೊ ಕೊನ್ಬಿ, ಹ್ಯಾ ಮಡ್ಡಿಕ್ ಸಮುಂದರಾತ್ ಜಾವ್ನ್ ಪಡ್ ಮನುನ್, ತುಮ್ಚ್ಯಾ ಮನಾತ್ ಸಂಶೆವ್ ಕರಿನಾಸ್ತಾನಾ ಸಾಂಗ್ಲ್ಯಾರ್, ತೆ, ದೆವ್, ತೆಂಚೆ ಸಾಟ್ನಿ ಕರ್‍ತಾ, ");
INSERT INTO kans_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ತಸೆ ಮನುನ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ತುಮಿ ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ ಮಾಗಲ್ಲೆ ಗಾವ್ಲಾಚ್ ಮನುನ್ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾರ್, ಮಾಗಲ್ಲೆ ಸಗ್ಳೆ ತುಮ್ಕಾ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ತುಮಿ ಮಾಗ್ನಿ ಕರುಕ್ ಜಾತಾನಾ, ಕಸ್ಲ್ಯಾಬಿ ಕಾರನಾಕ್ ಲಾಗುನ್ ಕೊನಾ ವರ್‍ತಿ ತರ್ ತುಮ್ಕಾ ರಾಗ್ ಹೊತ್ತೆ ಯಾದ್ ಯೆಲ್ಯಾರ್. ತೆಕಾ ತುಮಿ ಮಾಪ್ ಕರುನ್ ಸೊಡಾ, ತನ್ನಾ ಸರ್ಗಾವಯ್ಲೊ ತುಮ್ಚೊ ಬಾಬಾಬಿ ತುಮ್ಚೆ ಸಗ್ಳೆ ಚುಕಾ ಮಾಪ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ಖರೆ ತುಮಿ ದುಸ್ರ್ಯಾಕ್ನಿ ಮಾಪ್ ಕರಿನಸ್ಲ್ಯಾರ್ ಸರ್‍ಗಾ ವೈಲೊ ತುಮ್ಚೊ ಬಾಬಾ ತುಮ್ಚಿಬಿ ಚುಕಾ ಮಾಪ್ ಕರಿನಾ. ");
INSERT INTO kans_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ತೆನಿ ಅನಿ ಜೆರುಜಲೆಮಾಕ್ ಯೆಲ್ಯಾನಿ. ಜೆಜು ಗುಡಿತ್ ಫಿರುನ್ಗೆತ್ ಹೊತ್ತೊ, ತನ್ನಾ ಯಾಜಕಾಂಚಿ ಮುಖಂಡಾ, ಖಾಯ್ದೆ ಸಿಕ್ವುತಲೆ ಅನಿ ವ್ಹಡಿಲಾ ತೆಚಾಕ್ಡೆ ಯೆಲ್ಯಾನಿ ಅನಿ ");
INSERT INTO kans_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ಹೆ ಸಗ್ಳೆ ತಿಯಾ ಕಸ್ಲ್ಯಾ ಅದಿಕಾರಾನ್ ಕರುಕ್ ಲಾಗ್ಲೆ? ಹೆ ಸಗ್ಳೆ ಕರುಕ್ ತುಕಾ ಕೊನ್ ಅದಿಕಾರ್ ದಿಲಾ?” ಮನುನ್ ಸಾಂಗ್ ಅಮ್ಕಾ! ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ತೆಕಾ ಜೆಜುನ್ “ಮಿಯಾ ತುಮ್ಕಾ ಎಕ್ ಪ್ರಸ್ನೆ ಇಚಾರ್ತಾ, ತೆಕಾ ತುಮಿ ಉತ್ತರ್ ದಿವಾ, ಮಾನಾ ಮಿಯಾ ಕಸ್ಲ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಹೆ ಸಗ್ಳೆ ಕರುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ಮಾಕಾ ಸಾಂಗಾ, ಜುವಾಂವ್ ಲೊಕಾಕ್ನಿ ದೆವಾಕ್ನಾ ಯೆಲ್ಲ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಬಾಲ್ತಿಮ್ ದಿವ್ಕ್ ಲಾಗಲ್ಲೊ? ಕಾಯ್ ಮಾನ್ಸಾನ್ ದಿಲ್ಲ್ಯಾ ಅದಿಕಾರಾನ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ತನ್ನಾ ತೆನಿ ಎಕಾಮೆಕಾತ್ನಿ ಚರ್ಚಾ ಕರುಕ್ ಚಾಲು ಕರುನ್, ಅಮಿ ಕಾಯ್ ಸಾಂಗುವಾ? “ಜರ್ ತರ್, ದೆವಾಕ್ನಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾಂವ್ ತರ್, ತುಮಿ ಜುವಾಂವಾಕ್ ಕಶ್ಯಾಕ್ ವಿಶ್ವಾಸ್ ಕರುಕ್ನ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ಅನಿ ಅಮಿ ಮಾನ್ಸಾಕ್ನಾ ಯೆಲ್ಲ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಮನುನ್ ಮಟ್ಲ್ಯಾರ್ ಲೊಕಾ ಅಮ್ಚ್ಯಾ ವಿರೊದ್ ಹೊತ್ಯಾತ್ ತೆನಿ ಭಿಂಯಾಲ್ಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಜುವಾಂವ್ ಎಕ್ ಪ್ರವಾದಿ ಮನುನ್ ಲೊಕಾ ಮಾನಿತ್ ");
INSERT INTO kans_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ತಸೆ ಮನುನ್ ತೆನಿ ಜೆಜುಕ್ “ಅಮ್ಕಾ ಗೊತ್ತ್ ನಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ತಸೆ ಜಾಲ್ಯಾರ್ ಮಿಯಾಬಿ ಹೆ ಸಗ್ಳೆ ಕಸ್ಲ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಕರುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ತುಮ್ಕಾ ಸಾಂಗಿನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ಮಾನಾ ಜೆಜು ತೆಂಚೆಕ್ಡೆ ಕಾನಿಯಾಂಚ್ಯಾ ವೈನಾ ಬೊಲುಕ್ಲಾಗ್ಲೊ. ಎಕ್ ಮಾನ್ಸಾನ್ ದ್ರಾಕ್ಷಿಚೊ ಮ್ಹಳೊ ಕರುನ್, ಭೊತ್ಯಾನಿ ಕುಪ್ ಘಾಟ್ಲ್ಯಾನ್, ದ್ರಾಕ್ಷಿಚೊ ರೊಸ್ ಕಾಡುಕ್ ಘಾನ್ಯಾಚೊ ಖಡ್ಡೊ ಖಂಡ್ಲ್ಯಾನ್, ಅನಿ ಶೆತ್ ರಾಕುಕ್ ಮನುನ್ ಶೆತಾತ್ ಎಕ್ ಬರೊ ಮಾಳೊ ಭಾಂದ್ಲ್ಯಾನ್, ಮಾನಾ ತೆ ಶೆತ್ ರೈತಾಕ್ನಿ ಗುತ್ಕ್ಯಾನಿ ದಿಲ್ಯಾನ್ ಅನಿ ತೊ ಧುರ್‍ಲ್ಯಾ ದೆಸಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ದರಾಕ್ಷಿ ಗೊಳಾ ಕರ್‍ತಲಿ ಸುಗ್ಗಿಚಿ ದಿಸಾ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ; ಅಪ್ನಾಚೊ ವಾಟೊ ಮಾಗುನ್ ಹಾನುಕ್ ಮನುನ್ ತ್ಯಾ ಮಳ್ಯಾಚ್ಯಾ ಸಾವ್ಕಾರಾನ್ ಅಪ್ನಾಚ್ಯಾ ಎಕ್ ಸೆವಕಾಕ್ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ಖರೆ ತ್ಯಾ ರೈತಾನಿ ತ್ಯಾ ಸೆವಕಾಕ್ ದರುನ್ ಬರೆ ಮಾರ್ ಘಾಟ್ಲ್ಯಾನಿ ಅನಿ ಖಾಲಿ ಹಾತಿನಿ ಫಾಟಿ ಧಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ಮಾನಾ ತ್ಯಾ ಸಾವ್ಕಾರಾನ್ ಅನಿ ಎಕ್ ಸೆವಕಾಕ್ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾನ್ ತೆನಿ ತೆಕಾ ಧರುನ್ ತೆಚೆ ಟಕ್ಲೆ-ಟಕ್ಲೆ ಧರುನ್ ಮಾರ್‍ಲ್ಯಾನಿ ಅನಿ ತೆಚಿ ಮರ್ಯ್ಯಾದ್ ಕಾಡಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ತಸೆ ಮನುನ್ ಸಾವ್ಕಾರಾನ್ ಅನಿ ಎಕ್ ಸೆವಕಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್ ತ್ಯಾ ಸೆವಕಾಕ್ ಧರುನ್ ಜಿವಾನಿಚ್ ಮಾರುನ್ ಟಾಕ್ಲ್ಯಾನಿ. ಅಸೆಚ್ ತೆನಿ ಥೊಡ್ಯಾಕ್ನಿ ಮಾರ್ ಘಾಟ್ಲ್ಯಾನಿ, ಅನಿ ಥೊಡ್ಯಾಕ್ನಿ ಜಿವಾನಿಚ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ಅತ್ತಾ ತ್ಯಾ ರೈತಾಂಚಾಕ್ಡೆ ಧಾಡುಕ್ ತ್ಯಾ ಸಾವ್ಕಾರಾಚೊ ಅಪುರ್‍ಬಾಯೆಚೊ ಲೆಕ್ ಎಕ್ಲೊಚ್ ಹುರಲ್ಲೊ, ರೈತಾ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಕ್ ತರ್ಬಿ ಮಾನ್ ದಿತಿಲ್ ಮನುನ್ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಕ್ ತೆಂಚೆಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ಖರೆ ತ್ಯಾ ಗುತ್ಕೆ ಘೆಟಲ್ಲ್ಯಾನಿ ತೆಕಾ ಬಗುನ್,“ಹ್ಯೊ ಸಾವ್ಕಾರಾಚೊ ಲೆಕ್, ಹ್ಯಾ ಅಸ್ತಿಚೊ ವಾರಿಸ್ದಾರ್, ಹೆಕಾ ಜಿವಾನಿ ಮಾರುನ್ ಟಾಕುವಾ, ತನ್ನಾ ಹಿ ಆಸ್ತಿ ಅಮ್ಕಾಚ್ ಹೊತಾ” ಮನುನ್ ಬೊಲುನ್ ಘೆವ್ನ್ ");
INSERT INTO kans_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ತ್ಯಾ ಸಾವ್ಕಾರಾಚ್ಯಾ ಲೆಕಾಕ್ ಧರುನ್ ಜಿವಾನಿ ಮಾರುನ್ ತೆಚೆ ಮಡೆ ಮಳ್ಯಾಚ್ಯಾ ಭಾಯ್ರ್ ಟಾಕ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ಅಸೆಹೊಲ್ಲ್ಯಾತನ್ನಾ, ತೊ ದರಾಕ್ಷಿಚ್ಯಾ ಮಳ್ಯಾಚೊ ಸಾವ್ಕಾರ್ ಯೆವ್ನ್ ಕಾಯ್ ಕರಿಲ್ ಮನುನ್ ತುಮಿ ಮನ್ತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್, ತೊ ಸಾವ್ಕಾರ್ ಯೆತಾ ಅನಿ ತ್ಯಾ ಮಾನ್ಸಾಕ್ನಿ ಜಿವಾನಿ ಮಾರುನ್ ತೊ ಮಳೊ ದುಸ್ರ್ಯಾಕ್ನಿ ಗುತ್ಕ್ಯಾಕ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ತುಮಿ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್, “ಘರ್ ಭಾಂದ್ತಲ್ಯಾನಿ ನಕ್ಕೊ ಮನುನ್ ಟಾಕಲ್ಲೊ ಗುಂಡೊಚ್ ಮಹತ್ವಾಚೊ ಗುಂಡೊ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ಹೆ ದೆವಾನ್ ಕರಲ್ಲೆ ಕಾಮ್, ಅಮ್ಕಾ ಹೆ ಅಜಾಪ್ ಸರ್ಕೆ ದಿಸ್ತಾ. ಮನುನ್ ವಾಚ್ವುಕ್‍ನ್ಯಾಶಿ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ಜೆಜು ಹಿ ಕಾನಿ ಸಾಂಗ್ತಾನಾ ಥೈ ಹೊತ್ತೆ ಜುದೆವಾಂಚ್ಯಾ ವಡಿಲಾನಿ ಹಿ ಕಾನಿ ತೊ ಅಪ್ನಾಚ್ಯಾಚ್ ವಿರೊದ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಯವ್ಜುನ್ ತೆಕಾ ಧರುಕ್ ಕಸ್ರತ್ ಕರ್‍ಲ್ಯಾನಿ, ಖರೆ ಥೈ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಭಿಂವ್ನ್, ತೆಕಾ ಧರಿನಸ್ತಾನಾ ತೆಕಾ ಸೊಡುನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ಜೆಜುಕ್ ತೆಚ್ಯಾಚ್ ಗೊಸ್ಟಿಯಾತ್ನಿ ಗೊಂದ್ಳುನ್ ಘಾಲುವಾ ಮನ್ತಲ್ಯಾ ಉದ್ದೆಶಾನ್ ಥೊಡಿ ಫಾರಿಜೆವಾ ಅನಿ ಥೊಡಿ ಹೆರೊದಾಚ್ಯಾ ಪಕ್ಷಾಚಿ ಲೊಕಾ ಜೆಜುಕ್ಡೆ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ಅನಿ “ಗುರುಜಿ, ತಿಯಾ ಲೊಕಾ ಕಾಯ್ ಯೌವಜ್ತ್ಯಾತ್ ಮನುನ್ ಪರ್ವಾ ಕರಿನಸ್ತಾನಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗ್ತೆ, ಅನಿ ಕೊನಾಚೆ ತೊಂಡ್ ಬಗಿನಸ್ತಾನಾ ಬೊಲ್ತೆ, ತಿಯಾ ಮಾನ್ಸಾ ಸಾಟ್ನಿ ದೆವಾಚಿ ಯವ್ಜನ್ ಕಾಯ್ ಮನುನ್ ಅಮ್ಕಾ ಸಾಂಗ್, ಅಮಿ ರೊಮಾಚ್ಯಾ ಚಕ್ರವರ್ತಿಕ್ ತೆರ್‍ಗಿ ದಿತಲೆ ಅಮ್ಚ್ಯಾ ಧರ್ಮಾಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್ಕಾರ್ ಸಮಾ ಹಾಯ್ ಕಾಯ್, ನಾ?” ಮನುನ್ ತೆಕಾ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ಜೆಜುನ್ ತೆಂಚೊ ಘಾತ್ ಕಳ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ “ತುಮಿ ಮಾಕಾಚ್ ಗೊಂದ್ಳುನ್ ಘಾಲುವಾ ಮನುನ್ ಕಶ್ಯಾಕ್ ಯವ್ಜುಕ್ ಲಾಗ್ಲ್ಯಾಸಿ? ಎಕ್ ಚಾಂದಿಚಿ ಪೈಸ್ಯಾಚಿ ಗಾಲಿ ಮಾಜ್ಯಾಕ್ಡೆ ದಿವಾ ಬಗುವಾ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ತನ್ನಾ ತೆನಿ ಎಕ್ ಚಾಂದಿಚಿ ಪಯ್ಸ್ಯಾಚಿ ಗಾಲಿ ತೆಕಾ ದಿಲ್ಯಾನಿ, ತನ್ನಾ ಜೆಜುನ್ “ಹ್ಯಾ ಚಾಂದಿಚ್ಯಾ ಪಯ್ಸ್ಯಾಚ್ಯಾ ವರ್‍ತಿ ಕೊನಾಚೆ ತೊಂಡ್ ಹಾಯ್ ಅನಿ ಕೊನಾಚೆ ನಾವ್ ಲಿವಲ್ಲೆ ಹಾಯ್?” ಮನುನ್ ತೆಂಕಾ ಇಚಾರ್‍ಲ್ಯಾನ್. ತೆಕಾ ತೆನಿ ಚಕ್ರವರ್ತಿಚೆ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ಚಕ್ರವರ್ತಿಚೆ ಚಕ್ರವರ್ತಿಕ್ ದಿವಾ ಅನಿ ದೆವಾಚೆ ದೆವಾಕ್ ದಿವಾ” ಮಟ್ಲ್ಯಾನ್. ತೆನಿ ಜೆಜುಚಿ ಗೊಸ್ಟ್ ಆಯ್ಕುನ್ ಅಜಾಪ್ ಹೊಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ಮರಲ್ಲೆ ಅನಿ ಪರ್ತುನ್ ಝಿತ್ತೆ ಹೊತಲೆ ಸಾಧ್ಯ್ ನಾ ಮನುನ್ ಯವಜ್ತಲೆ ಸಾದುಸೆವ್ ಜೆಜುಕ್ಡೆ ಯೆಲೆ ಅನಿ ");
INSERT INTO kans_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ಗುರುಜಿ,ಎಕ್ಲೊ ಮಾನುಸ್ ಪೊರಾ ನಸ್ತಾನಾ ಮರ್ಲ್ಯಾರ್ ತೆಚ್ಯಾ ಧಾಕ್ಲ್ಯಾ ಭಾವಾನ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ಡೆ ನಗಿನ್ ಕರುನ್ ಘೆವ್ಚೆ, ಅಸೆ ತೆಂಕಾ ಪೊರಾ ಹೊವ್ನ್ ತೆಚ್ಯಾ ಮೊಟ್ಯಾ ಭಾವಾಕ್ ಪಿಳ್ಗಿ ಕರುನ್ ದಿವ್ಚಿ ಮನುನ್ ಮೊಯ್ಜೆನ್ ಅಪ್ಲ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ ಲಿವುನ್ ಥವ್ಲ್ಯಾನಾಯ್; ");
INSERT INTO kans_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ಎಗ್ದಾ ಸತ್‍ ಜಾನಾ ಭಾವಾ ಹೊತ್ತಿ ಅನಿ ಥೊರ್‍ಲೊ ಭಾವ್ ನಗಿನ್ ಹೊವ್ನ್, ಪೊರಾನಸ್ತಾನಾ ಮರ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ತನ್ನಾ ದೊನ್ವೆಚೊ ತಿಚೆಕ್ಡೆ ನಗಿನ್ ಹೊಲೊ ಅನಿ ತೊಬಿ ಪೊರಾ ನಸ್ತಾನಾ ಮರ್ಲೊ ಅನಿ ತಿನ್ವೆಚ್ಯಾಕ್ ಬಿ ತಸೆಚ್ ಹೊಲೆ”. ");
INSERT INTO kans_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ಅಶೆ ಎಕ್ಲ್ಯಾಚ್ಯಾ ಫಾಟ್ನಾ ಅನಿ ಎಕ್ಲೊ ಸತ್ ಜಾನಾ ಭಾವಾಬಿ ಪೊರಾ ನಸ್ತಾನಾ ಮರ್ಲಿ, ಮಾನಾ ತೆಂಚ್ಯಾ ಫಾಟ್ನಾ ತಿ ಬಾಯ್ಕೊಮನುಸ್ಬಿ ಮರ್ಲಿ; ");
INSERT INTO kans_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ತಸೆ ಹೊಲ್ಯಾರ್ ಅತ್ತಾ ಪರ್ತುನ್ ಝಿತ್ತೆ ಹೊತಲ್ಯಾ ದಿಸಿ, ತಿ ಬಾಯ್ಕೊ ಮಾನುಸ್ ತ್ಯಾ ಸತ್ ಜಾನಾ ಭಾವಾತ್ನಿ ಕೊನಾಚಿ ಬಾಯ್ಕೊ ಹೊತಾ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ತುಮಿ ಕವ್ಡೆ ಚುಕುನ್ ಪಡ್ಲ್ಯಾಸಿ? ತುಮ್ಕಾ ಪವಿತ್ರ್ ಪುಸ್ತಕಾಚಿ ಉಲ್ಲಿಬಿ ಸಮ್ಜನ್‍ ನಾ, ಅನಿ ದೆವಾಚ್ಯಾ ತಾಕ್ತಿಚ್ಯಾ ವಿಶಯಾತ್ ತುಮ್ಕಾ ಗೊತ್ತುಚ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ಮರ್‍ನಾತ್ನಾ ಝಿತ್ತೆ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಸಗ್ಳೆ ಜನಾ ಸರ್‍ಗಾತ್ ದೆವಾಚ್ಯಾದುತಾ ಬಾಸೆನ್ ರಾತ್ಯಾತ್, ನಗಿನ್ ಹೊಯ್ನಾತ್.” ");
INSERT INTO kans_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ಮರಲ್ಲೆ ಪರ್ತುನ್ ಝಿತ್ತೆ ಹೊತಲ್ಯಾ ವಿಶಯಾತ್ ಮೊಯ್ಜೆಚ್ಯಾ ಪುಸ್ತಕಾತ್ ತ್ಯಾ ಜಳ್ತಲ್ಯಾ ಝಿಳಿಚ್ಯಾ ವಿಶಯಾತ್ ಲಿವಲ್ಲೆ ತುಮಿ ವಾಚುಕ್ನ್ಯಾಸಿ ಕಾಯ್? ಥೈ ದೆವ್ ಮೊಯ್ಜೆಕ್ “ಮಿಯಾ ಅಬ್ರಾಹಾಮಾಚೊ ದೆವ್, ಇಸಾಕಾಚೊ ದೆವ್ ಅನಿ ಜಾಕೊಬಾಚೊ ದೆವ್” ಮನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“ದೆವ್ ಮಿಯಾ ಅಬ್ರಾಹಾಮ್, ಇಸಾಕ್, ಜಾಕೊಬಾಚೊ ದೆವ್ ಮನುನ್ ಸಾಂಗ್ತಾ ಜಾಲ್ಯಾರ್, ತೆನಿ ಝಿತ್ತೆ ಹಾತ್ ಮನುನ್ ಅರ್ತ್‍, ತುಮಿ ಲೈ ಚುಕ್ ಯೌಜುನ್‍ಘೆವ್ನ್ ಹಾಸಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ಖಾಯ್ದೆ ಸಿಕ್ವುತಲ್ಯಾಂಚ್ಯಾ ಮದ್ಲ್ಯಾ ಎಕ್ ಮಾನ್ಸಾನ್ ಜೆಜು ಸಾದುಸೆವಾಕ್ನಿ ಸಮಾ ಜಬಾಬ್ ದಿತಲೆ ಅಯ್ಕ್ಲ್ಯಾನ್, ಅನಿ ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್ “ಸಗ್ಳ್ಯಾ ಉಪಾದೆಸಾನ್ಕಿ ಮೊಟೊ ಉಪಾದೆಸ್ ಖಲೊ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ತೆಕಾ ಜೆಜುನ್ ಅಸೆ ಜಬಾಬ್ ದಿಲ್ಯಾನ್ “ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾನು ಆಯ್ಕಾ, ಹೆ ಲೈ ಮಹತ್ವಾಚೆ ವಿಶಯ್” ಸಗ್ಳ್ಯಾ ವರ್‍ತಿ ಅದಿಕಾರ್ ಅಸಲ್ಲೊ ಅಮ್ಚೊ ದೆವ್, ತೊ ಎಕ್ಲೊಚ್ ಧನಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ತುಜ್ಯಾ ಪುರಾ ಕಾಳ್ಜಾನ್, ತುಜ್ಯಾ ಪುರಾ ಆತ್ಮ್ಯಾನ್, ತುಜ್ಯಾ ಪುರಾ ಮನಾನ್, ಅನಿ ತುಜ್ಯಾ ಪುರಾ ಬಳಾನ್. ಸರ್ವೆಸ್ವರಾ ತುಜ್ಯಾ ಎಕ್ಲ್ಯಾಚ್ ದೆವಾಚೊ ಪ್ರೆಮ್ ಕರ್. ");
INSERT INTO kans_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ಅನಿ ದೊನ್ವೆಚೊ ಮಹತ್ವಾಚೊ ಖಾಯ್ದೊ ಮಟ್ಲ್ಯಾರ್ “ತಿಯಾ ತುಜೊಚ್ ಕಸೊ ಪ್ರೆಮ್ ಕರ್‍ತೆ, ತಸೆಚ್ ದುಸ್ರ್ಯಾಂಚೊ ಪ್ರೆಮ್ ಕರುಚೊ. ಹ್ಯಾ ದೊನಿಚ್ಯಾನ್ಕಿ ಮೊಟೊ ಖಾಯ್ದೊ ಅನಿ ಖಲೊಬಿ ನಾ,” ಮನುನ್ ಉತ್ತರ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ತನ್ನಾ ತೊ ಖಾಯ್ದೆ ಸಿಕ್ವುತಲೊ ಜೆಜುಕ್ “ಗುರುಜಿ, ಬರಬ್ಬರ್ ಸಾಂಗ್ಲೆ ತಿಯಾ, ದೆವ್ ಎಕ್ಲೊಚ್, ತೆಚ್ಯಾ ಶಿವಾಯ್ ಅನಿ ದುಸ್ರೊ ದೆವ್ ನಾ. ಹೆ ಖರೆ ಹಾಯ್, ");
INSERT INTO kans_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ಅನಿ ಮಾನ್ಸಾನ್ ಅಪ್ನಾಚ್ಯಾ ಪುರಾ ಕಾಳ್ಜಾನ್, ಪುರಾ ಮನಾನ್, ಪುರಾ ತಾಕ್ತಿನ್ ದೆವಾಚೊ ಪ್ರೆಮ್ ಕರುಚೊ ಅನಿ ಅಪ್ನಾಚೊ ಕರಲ್ಲ್ಯಾ ಬಾಸೆನ್ ದುಸ್ರ್ಯಾಂಚೊಬಿ ಪ್ರೆಮ್ ಕರುಚೊ, ಹಿ ದೊನ್ ಉಪಾದೆಸಾ ಲೈ ಮಹತ್ವಾಚಿ, ಹೆ ಅಮಿ ದೆವಾಕ್ ದಿತಲ್ಯಾ ಕೌಡ್ಯಾಕಿ ಜನಾವರಾಂಚ್ಯಾ ಬಲಿಯಾಂಚ್ಯಾನ್ಕಿ ಅನಿ ದುಸ್ರ್ಯಾ ಕಾನಿಕಾಂಚ್ಯಾನ್ಕಿ ಮೊಟೆ.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ತೆನಿ ಎವ್ಡ್ಯಾ ಬರ್‍ಯಾ ಬುದ್ವಂತ್ಕಿನ್ ಉತ್ತರ್ ದಿಲ್ಲೆ ಆಯ್ಕುನ್ ಜೆಜುನ್ ತೆಕಾ “ತಿಯಾ ದೆವಾಚ್ಯಾ ರಾಜಾಕ್ನಾ ಲೈ ಧುರ್ ನಾಸ್” ಮಟ್ಲ್ಯಾನ್. ಮಾನಾ ಕೊನಾಕ್ಬಿ ಜೆಜುಕ್ ಸವಾಲ್ ಕರುಕ್ ಧಯ್ರೊ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ಜೆಜುನ್ ಗುಡಿತ್ ಶಿಕ್ವುನ್ಗೆತ್ ಹ್ಯೊ ಪ್ರಸ್ನೊ ಇಚಾರ್‍ಲ್ಯಾನ್ “ಖಾಯ್ದೆ ಸಿಕ್ವುತಲೆ ಕ್ರಿಸ್ತ್ ದಾವಿದಾಚೊ ಲೆಕ್ ಮನುನ್ ಸಾಂಗ್ತ್ಟ್ಯಾತ್. ತೆ ಕಶೆ ಹೊತಾ?” ");
INSERT INTO kans_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಪವಿತ್ರ್ ಆತ್ಮೊ ದಾವಿದಾಚ್ಯಾ ಮುಕಾಂತ್ರ್ ಮಟ್ಲ್ಯಾನಾಯ್, “ಸರ್ವೆಸ್ವರಾನ್ ಮಾಜ್ಯಾ ಧನಿಯಾಕ್, ತುಜ್ಯಾ ದುಸ್ಮನಾಕ್ ತುಜ್ಯಾ ಪಾಂಯಾಂಚ್ಯಾ ಮುಳಾತ್ ಪಡಿಸರ್ಕೆ ಕರಿ ಪತರ್, ತಿಯಾ ಮಾಜ್ಯಾ ಉಜ್ವ್ಯಾಕ್ಡೆ ಬಸುನ್ ರ್‍ಹಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“ಅಶೆ ಸ್ವತಾ ದಾವಿದುಚ್ ಮೆಸ್ಸಿಯಾಕ್ ಧನಿ ಮನುನ್ ಬಲ್ವುತಾ ತರ್, ಮೆಸ್ಸಿಯಾ ದಾವಿದಾಚೊ ಲೆಕ್ ಕಸೊ ಹೊವ್ಕ್ ಹೊತಾ?” ಮಟ್ಲ್ಯಾನ್. ಥೈ ಲೈ ಲೊಕಾ ಹೊತ್ತಿ ತಿ ಲೊಕಾ ಜೆಜು ಸಾಂಗ್ತಲೆ ಕುಶಿನ್ ಅಯ್ಕುಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುತಾನಾ ಜೆಜುನ್ “ಖಾಯ್ದೆ ಸಿಕ್ವುತಲ್ಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ,ಪಾಂಯಾಂಚ್ಯಾ ಸಗೊಳ್ ಲಾಂಬ್-ಲಾಂಬ್ ಅಂಗಿಯಾ ನೆಸುನ್ ಘೆವ್ನ್ ಬಾಜಾರಾತ್ ಫಿರ್ತಾನಾ ಸಗ್ಳ್ಯಾನಿಕ್ನಾ ಸಲಾಮ್ ಕರುನ್ ಘೆವ್ಕ್ ತೆಂಕಾ ಲೈ ಕುಶಿ. ");
INSERT INTO kans_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ತೆನಿ ಸಿನಾಗೊಗಾತ್ನಿ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಅನಿ ಸನಾಚ್ಯಾ ಪಂಗ್ತಿಯಾತ್ನಿ ಬಸುಕ್ ಬರೆ-ಬರೆ ಜಾಗೆ ಹುಡ್ಕುನ್ ಘೆತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ಘೊವ್ ಮರಲ್ಲ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾಂಚೊ ಫಾಯ್ದೊ ಕಾಡುನ್ ಘೆವ್ನ್ ತೆಂಚಿ ಘರಾ ಲುಟ್ತ್ಯಾತ್ ಅನಿ ಲಾಂಬ್-ಲಾಂಬ್ ಮಾಗ್ನಿಯಾ ಕರ್‍ತಾತ್, ಹೆಂಕಾ ಫಿಡೆ ಕಟೊರ್ ಶಿಕ್ಷಾ ರಾಕುನ್ ಹಾಯ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ಜೆಜು ಗುಡಿತ್ ಕಾನ್ಕಿಚ್ಯಾ ಡಬ್ಬ್ಯಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಬಸುನ್ ಬಗುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ, ತ್ಯಾ ಡಬ್ಬ್ಯಾತ್ ಲೊಕಾ ಪೈಸೆ ಘಾಲಿತ್, ಸುಮಾರ್ ಸಾವ್ಕಾರ್ ಲೊಕಾ ಲೈ-ಲೈ ಪೈಸೆ ಘಾಲಿತ್, ");
INSERT INTO kans_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ತವ್ಡ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಎಕ್ ಗರಿಬ್ ಘೊವ್ ಮರಲ್ಲಿ ಬಾಯ್ಕೊಮನುಸ್ ಯೆವ್ನ್ ತಾಂಬ್ಯಾಚ್ಯಾ ದೊನ್ ಬಾರಿಕ್ಲ್ಯಾ ಗಾಲಿಯಾ ತ್ಯಾ ಕಾನಿಕಾಚ್ಯಾ ಡಬ್ಬ್ಯಾತ್ ಘಾಟ್ಲಿನ್. ತೆಚಿ ಕಿಮ್ಮತ್ ಎಕ್ ಪೈಸೊ. ");
INSERT INTO kans_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಜಗ್ಗೊಳ್ ಬಲ್ವುನ್ “ಬಗಾ, ಹ್ಯಾ ಕಾನಿಕಾಚ್ಯಾ ಡಬ್ಬ್ಯಾತ್ ಕಾನಿಕ್ ಘಾಟಲ್ಲ್ಯಾ ಎವ್ಡ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚಾನ್ಕಿ ಜಾಸ್ತಿ ಹ್ಯಾ ಗರಿಬ್ ಬಾಯ್ಕೊಮನ್ಸಿನ್ ಘಾಟ್ಲಿನಾಯ್, ");
INSERT INTO kans_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸಗ್ಳ್ಯಾನಿ ಅಪ್ನಾಚ್ಯಾ ಸಾವ್ಕಾರ್ಕಿತ್ ಫಿರೆಹೊವ್ನ್ ಹುರಲ್ಲೆ ಉಲ್ಲೆಸೆ ಘಾಟ್ಲ್ಯಾನಿ, ಖರೆ ಹ್ಯಾ ಗರಿಬ್ ಬಾಯ್ಕೊಮನ್ಸಿನ್ ಅಪ್ನಾಕ್ಡೆ ಅಪ್ನಾಚ್ಯಾ ಜಿವನಾ ಸಾಟ್ನಿ ಮನುನ್ ಹೊತ್ತೆ ದೊನುಚ್ ದೊನ್ ಪೈಸೆಬಿ ಅಪ್ನಾಕ್ ಥವ್ನ್ ಘೆಯ್ನಸ್ತಾನಾ ಘಾಟ್ಲಿನ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿತ್ನಾ ಬಾಯ್ರ್ ಯೆತಾನಾ, ತೆಚ್ಯಾ ಶಿಸಾನಿತ್ಲೊ ಎಕ್ಲೊ “ಗುರುಜಿ! ಅಬಕ್, ಕವ್ಡೆ ಬರೆ ಗುಂಡೆ ಅನಿ ಭಾಂದಾಪ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ತುಮಿ ಎವ್ಡಿ ಬರಿ ಭಾಂದ್ಪಾ ಬಗುಲ್ಯಾಸಿ ಕಿ? ಹೆ ಸಗ್ಳೆ ನಾಸ್ ಹೊವ್ನ್ ಜಾತಾ, ಎಕ್ ಗುಂಡ್ಯಾ ವರ್‍ತಿ ಅನಿ ಎಕ್ ಗುಂಡೊ ರ್‍ಹಾನಾಸ್ತಾನಾ ಹರ್ ಎಕ್ ಗುಂಡೊ ಜಮ್ನಿಕ್ ಕೊಸ್ಳುನ್ ಘಾಲ್ತ್ಯಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ಇದ್ರಾಕ್ ಅಸಲ್ಲ್ಯಾ ಒಲಿವ್ ಮನ್ತಲ್ಯಾ ಮಡ್ಡಿ ವೈರ್ ಬಸಲ್ಲ್ಯಾ ತನ್ನಾ, ಪೆದ್ರು, ಜಾಕೊಬ್, ಜುವಾಂವ್ ಅನಿ ಅಂದ್ರು, ಎಗ್ಳೆಚ್ ಯೆವ್ನ್, ");
INSERT INTO kans_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ಜೆಜುಕ್ “ಹೆ ಸಗ್ಳೆ ಹೊತಲೊ ಎಳ್ ಕನ್ನಾ ಯೆತಾ, ಅನಿ ಕಾಯ್-ಕಾಯ್ ಹೊತಾ, ಹೆ ಸಗ್ಳೆ ಹೊವ್ಲಾ ಮನುಕ್ ವಳಕ್ ಕಾಯ್ ಮನುನ್ ಅಮ್ಕಾ ಸಾಂಗ್” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ಕೊನ್ಬಿ ತುಮ್ಕಾ ಮೊಸ್ ಕರಿನಸಿ ಸರ್ಕೆ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ!” ");
INSERT INTO kans_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ಲೈ ಲೊಕಾ ಯೆವ್ನ್ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುನ್, “ಮಿಯಾಚ್ ‘ಕ್ರಿಸ್ತ್’ ಮನುನ್ ಸಾಂಗುನ್ ಲೈ ಲೊಕಾಕ್ನಿ ಪಸ್ವುತಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ಜಗ್ಗೊಳ್ ಹೊತಲ್ಯಾ ಝಗ್ಡ್ಯಾಂಚೊ ಅವಾಜ್ ಅನಿ ಧುರ್‍ಲ್ಯಾ ಗಾಂವಾತ್ನಿ ಹೊತಲ್ಯಾ ಝಗ್ಡ್ಯಾಂಚ್ಯಾ ಖಬ್ರಿಯಾ ತುಮ್ಕಾ ಆಯ್ಕುಕ್ ಗಾವ್ತ್ಯಾತ್. ಖರೆ ತುಮಿ ಭಿಂವುನಕಾಶಿ. ಹೆ ಸಗ್ಳೆ ಹೊವ್ಕುಚ್ ಪಾಜೆ, ಹೆಚೊ ಅರ್ತ್‍ ಅಂತ್ಕಾಲ್ ಯೆಲೊ ಮನುನ್ ನ್ಹಯ್”. ");
INSERT INTO kans_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ಎಕ್ ದೆಸ್ ಅನಿ ಎಕ್ ದೆಸಾವರ್ತಿ ಅನಿ ಎಕ್ ರಾಜ್ ಅನಿ ಎಕ್ ರಾಜಾಚ್ಯಾ ವರ್‍ತಿ ಮಾರಾ-ಮಾರಿ ಕರುಕ್ ಉಟ್ತ್ಯಾತ್. ತಸೆಚ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಭುಕಂಪಾ ಹೊತ್ಯಾತ್ ಅನಿ ಬರಗಾಲ್ ಪಡ್ತಾ; ಹೆ ಸಗ್ಳೆ ಎಕಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಬಾನತ್ಪಾನಾಚೊ ತರಾಸ್ ಯೆಲ್ಯಾ ಬಾಸೆನ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ಅನಿ ತುಮಿ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ! ತುಮಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಹಾಸಿ ಮನುನ್ ಲೊಕಾ ತುಮ್ಕಾ ಧರುನ್ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಘೆವ್ನ್ ಜಾತ್ಯಾತ್, ತೆಂಚ್ಯಾ ಸಿನಾಗೊಗಾತ್ನಿ ನ್ಹೆವ್ನ್ ಮಾರುಕ್ ಲಾವ್ತ್ಯಾತ್, ಮಾಜ್ಯಾ ಬದಲ್ ಸಾಕ್ಷಿ ಸಾಂಗುಕ್ ಮನುನ್ ಅದಿಕಾರ್‍ಯಾಂಚ್ಯಾ ಅನಿ ರಾಜಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ತುಮ್ಕಾ ಇಬೆ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ಅಂತ್ಕಾಲ್ ಯೆವ್ಚ್ಯಾ ಅದ್ದಿ ತುಮಿ ಸಗ್ಳ್ಯಾ ದೆಸಾನಿತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕುಚ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ತುಮ್ಕಾ ಧರುನ್ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ವೊಡುನ್ ಹಾನುನ್ ಇಚಾರ್‍ನಿ ಕರ್‍ತಾನಾ, ತುಮಿ ತೆಂಕಾ ಕಾಯ್ ಸಾಂಗುಚೆ, ಕಾಯ್ ಬೊಲುಚೆ ಮನುನ್ ಚಿಂತಾ ಕರುನಕಾಸಿ, ಕಾಯ್ ಬೊಲುಚೆ ಮನುನ್ ತುಮ್ಕಾ ದಿಸ್ತಾ ತೆ ಬೊಲಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತನ್ನಾ ತುಮಿ ಬೊಲಿನ್ಯಾಸಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ಬೊಲ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“ಲೊಕಾ ಅಪ್ನಾಚ್ಯಾ ಸ್ವಂತ್ ಭಾವಾಕ್ ಜಿವಾನಿ ಮಾರುಕ್ ಧರುನ್ ದಿತ್ಯಾತ್. ಅನಿ ಬಾಬಾ ಅಪ್ನಾಚ್ಯಾ ಪೊರಾಕ್ನಿ, ಪೊರಾ ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾಂಚ್ಯಾ ವಿರೊದ್ ಜಾವ್ನ್ ತೆಂಕಾ ಜಿವಾನಿ ಮಾರುಕ್ ಲಾವ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ಮಾಕಾ ಲಾಗುನ್ ಹರ್ ಎಕ್ಲೊ ತುಮ್ಚೊ ದ್ವೆಸ್ ಕರ್‍ತ್ಯಾತ್. ಖರೆ ಸರ್ತ್ಯಾ ಕಾಲ್ ಸಗೊಳ್ ಕೊನ್ ವಿಶ್ವಾಸ್ ಕಳ್ದುನ್ ಘೆಯ್ನಾಸ್ತಾನಾ ರ್‍ಹಾತಾ, ತೊ ದೆವಾಚ್ಯಾ ನ್ಯಾಯ್ ತಿರ್ಪಾತ್ನಾ ಬಚಾವ್ ಹೊವ್ನ್ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಜಾತಲಿ ಯೊಗ್ಯತಾ ಜೊಡುನ್ ಘೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ಸಗ್ಳೆ ಸತ್ತ್ಯಾನಾಸ್ ಕರ್‍ತಲಿ ಬುರ್ಶಿ ವಸ್ತ್ ಇಬೆ ರವ್ಚೆ ನ್ಹಯ್ ತ್ಯಾ ಜಾಗ್ಯಾರ್ ಇಬೆ ಹೊತ್ತೆ ತುಮಿ ಬಗ್ತಾನಾ, ಹೆ ವಾಚ್ವುತಲೆ ಹೆಚೊ ಅರ್ತ್‍ ಕಾಯ್ ಮನುನ್ ಕಳ್ವುನ್ ಘೆವ್ಚೆ ಜುದೆಯಾತ್ಲಿ ಲೊಕಾ ಗುಡ್ಡ್ಯಾಂಚ್ಯಾ ವಯ್ನಿ ಪಳುನ್ ಜವ್ಕ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ಘರಾಚ್ಯಾ ಥಾಟಾ ವರ್‍ತಿ ಅಸಲ್ಲೊ ಮಾನುಸ್ ಖಾಲ್ತಿ ಉತ್ರುನ್ ಘರಾತ್ ಗುಸುನ್ ಕಾಯ್ಬಿ ಘೆವ್ಕ್ ಮನುನ್ ಎಳ್ ಕರಿನಸ್ತಾನಾ ಪಳುನ್ ಜಾಂವ್ದಿ, ");
INSERT INTO kans_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ಶೆತಾತ್ ಹೊತ್ತೊ ಮಾನುಸ್ ಅಪ್ನಾಚೆ ಕಪ್ಡೆ ಘೆವ್ಕ್ ಮನುನ್ ಘರಾಕ್ ಜಾಯ್ನಸ್ತಾನಾ ರ್‍ಹಾಂವ್ದಿತ್, ");
INSERT INTO kans_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ತ್ಯಾ ದಿಸಾನಿ ಬಾಯ್ಕಾಮನ್ಸಾಕ್ನಿ ಎವ್ಡೊ ಭಯಂಕರ್ ಎಳ್ ಮಟ್ಲ್ಯಾರ್ ,ಗರ್‍ವಾರ್ ಹೊತ್ತ್ಯಾ ಅನಿ ದುದ್ ಫಿತಲಿ ಪೊರಾ ಹೊತ್ತ್ಯಾ ಬಾಯ್ಕಾಕ್ನಿ ತರ್ ಲೈ ತರಾಸ್. ");
INSERT INTO kans_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ಹೆ ಸಗ್ಳೆ ಪಾವ್ಸ್ ಅನಿ ಥಂಡ್ ಅಸಲ್ಲ್ಯಾ ದಿಸಾತ್ನಿ ಹೊವ್ಚೆ ನ್ಹಯ್ ಮನುನ್ ಮಾಗ್ನಿ ಕರಾ. ");
INSERT INTO kans_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಹ್ಯಾ ದಿಸಾತ್ನಿ ಹೊತಲೊ ಸಂಕಟ್ ಎವ್ಡೊ ಭಯಂಕರ್ ಮಟ್ಲ್ಯಾರ್, ದೆವಾನ್ ಹಿ ಸಗ್ಳಿ ದುನಿಯಾ ರಚಲ್ಲ್ಯಾಕ್ನಾ ಆಜ್ ಪತರ್ ತಸ್ಲೊ ಸಂಕಟ್ ಹ್ಯಾ ದುನಿಯಾನ್ ಬಗುಕ್ನಾ ಅನಿ ಫಿಡೆ ಕನ್ನಾಚ್ ಅಸ್ಲೊ ಸಂಕಟಾಚೊ ಎಳ್ ಯೆಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ದೆವಾನ್ ಹಿ ಸಂಕಟಾಚಿ ದಿಸಾ ಕಮಿ ಕರಿನಸ್ಲ್ಯಾರ್,ಎಕ್ಲೊಬಿ ಮಾನುಸ್ ಬಚಾವ್ ಹೊವ್ಕ್ ಸಾದ್ಯ್ ನತ್ತೆ, ಖರೆ ದೆವಾನ್ ಅಪ್ನಿ ಯೆಚುನ್ ಕಾಡಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ತಿ ದಿಸಾ ಕಮಿ ಕರ್‍ಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ತೆಚ್ಯಾ ಮಾನಾ ಕೊನ್ ತರ್ ತುಮ್ಕಾ “ಅಬಕ್! ಕ್ರಿಸ್ತ್ ಹಿತ್ತೆ ಹಾಯ್, ನಾ ಹೊಲ್ಯಾರ್ ಥೈ ಹಾಯ್, ಮನುನ್‍ ಸಾಂಗ್ತಿಲ್ ತೆಕಾ ವಿಶ್ವಾಸುಚ್ ಕರುನಕಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ತಸೆ ಮನುನ್ ಝುಟೆ ಕ್ರಿಸ್ತ್ ಅನಿ ಝುಟೆ ಪ್ರವಾದಿ ಯೆತ್ಯಾತ್ ಅನಿ ಮೊಟಿ-ಮೊಟಿ ಕಾಮಾ ಅನಿ ಅಜಾಪ್ ಹೊತಲಿ ಕಾಮಾಬಿ ಕರುನ್ ದಾಕ್ವುತ್ಯಾತ್.ಅನಿ ಸಾದ್ಯ್ ಹೊಲ್ಯಾರ್ ದೆವಾನ್ ಎಚುನ್ ಕಾಡಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಮೊಸ್ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ತುಮಿ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಹೆ ಸಗ್ಳೆ ಹೊವ್ಚ್ಯಾ ಅದ್ದಿಚ್ ಮಿಯಾ ತುಮ್ಕಾ ಯೆತಲ್ಯಾ ಹ್ಯಾ ಕಾಲಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗ್ಲಾ”. ");
INSERT INTO kans_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ಹಿ ಸಂಕಟಾಚಿ ದಿಸಾ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ, ಸೂರ್ಯಾ ಕಾಳೊ ಹೊತಾ,ಅನಿ ಚಂದ್ರಾಮ್ ಉಜ್ವೊಡ್ ದಿ ನಾ”. ");
INSERT INTO kans_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","“ಚಿಕ್ಕಿಯಾ ಮಳ್ಬಾತ್ನಾ ಖಾಲ್ತಿ ಪಡ್ತ್ಯಾತ್, ಅನಿ ಮಳ್ಬಾ ವೈಲ್ಯಾ ಸಗ್ಳ್ಯಾ ತಾಕ್ತಿಯಾ ಕಾಪ್ತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ಹೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಅದಿಕಾರ್‍ಯಾನ್ ಅನಿ ಮಹಿಮೆನ್ ಭರುನ್ ಮೊಡಾಂಚ್ಯಾ ವೈನಾ ಯೆತಲೊ ದಿಸ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ಮಾನಾ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಅಪ್ನಾಚ್ಯಾ ದುತಾಕ್ನಿ ಧಾಡುನ್ ಅಪ್ನಿ ಯೆಚುನ್ ಘೆಟಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ದುನಿಯಾಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಭಾಗಾನಿತ್ನಾ ಅನಿ ಸರ್‍ಗಾಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಭಾಗಾನಿತ್ನಾ ಗೊಳಾ ಕರುಕ್ ಲಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ಅಂಜುರಾಚ್ಯಾ ಝಾಡಾ ವೈನಾ ಎಕ್ ಪಾಟ್ ಶಿಕಾ. ಹ್ಯಾ ಝಾಡಾಚ್ಯಾ ಟಾಳಿಯಾ ಹಿರ್ವ್ಯಾ ಸರ್ಕ್ಯಾ ಹೊವ್ನ್, ಮ್ಹವ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಅನಿ ಪಾನಾ ಚಿಗರುಕ್ ಚಾಲು ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ನಿಂಬ್ರಾಚಿ ದಿಸಾ ಜಗ್ಗೊಳ್ ಯೆಲಿ ಮನುನ್ ತುಮಿ ಕಳ್ವುನ್ಘೆತ್ಯಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ತಸೆಚ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಸಂಗ್ತಿಯಾ ಹೊತಲೆ ಬಗುನ್ ತೊ ಎಳ್ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಚಾಲು ಹೊನಾರ್ ಹಾಯ್ ಮನುನ್, ");
INSERT INTO kans_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ಯಾದ್ ಥವ್ನ್ ಘೆವಾ! ಹ್ಯಾ ಕಾಲಾತ್ಲಿ ಉಲ್ಲಿ ಲೊಕಾ ಝಿತ್ತಿ ರ್‍ಹಾತಾನಾಚ್ ಹ್ಯಾ ಸಗ್ಳ್ಯಾ ಸಂಗ್ತಿಯಾ ಹೊತ್ಯಾತ್. ಮನುನ್ ಮಿಯಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ");
INSERT INTO kans_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ಜಮಿನ್ ಅನಿ ಮಳಬ್ ನಾಸ್ ಹೊವ್ನ್ ಜಾಯ್ಲ್, ಖರೆ ಮಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ನಾಸ್ ಹೊಯ್‍ನ್ಯಾತ್.” ");
INSERT INTO kans_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ತೊ ದಿಸ್ ಹೊಂವ್ದಿ, ಎಳ್ ಹೊಂವ್ದಿ, ಕನ್ನಾ ಯೆತಾ ಮನುನ್ ಸರ್ಗಾತ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ದುತಾಕ್ನಿ ಹೊಂವ್ದಿ, ಲೆಕಾಕ್ ಹೊಂವ್ದಿ ಗೊತ್ತ್ ನಾ. ಬಾಬಾಕ್ ಎಕ್ಲ್ಯಾಕುಚ್ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ಕನ್ನಾಬಿ, ರಾಕುನ್ಗೆತ್ “ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ, ತೊ ಎಳ್ ಕನ್ನಾ ಯೆತಾ ಮನುನ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ನಾ”. ");
INSERT INTO kans_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ಹೆ ಕಶೆ ಮಟ್ಲ್ಯಾರ್, “ಹೆ ಅಪ್ನಾಚೆ ಘರ್ ಸೊಡುನ್ ಧುರ್‍ಲ್ಯಾ ದೆಸಾಕ್ ಗೆಲ್ಲ್ಯಾ ಎಕ್ ಮಾನ್ಸಾಕ್ ಸಮಾ ಕರುಕ್ ಹೊತಾ. ಅಪ್ನಾಚೆ ಘರ್ ಬಗುನ್ ಘೆವಾ” ಮನುನ್ ಸೆವಕಾಕ್ನಿ ತೆನಿ ಸಾಂಗ್ಲ್ಯಾನ್. ಅನಿ ಹರ್ ಎಕ್ಲ್ಯಾ ಸೆವಕಾಕ್ನಿ ತೆಂಚೆ-ತೆಂಚೆ ಕಾಮ್ ದಿಲ್ಯಾನ್ ಅನಿ ದಾರ್‍ ರಾಕ್ತಲ್ಯಾಕ್ “ತಿಯಾ ಕನ್ನಾಬಿ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“ಕನ್ನಾಬಿ ತಯಾರಿತ್ ರ್‍ಹಾವಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಘರ್ಚೊ ವಡಿಲ್ ಕನ್ನಾ ಯೆತಾ ಮನುನ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ನಾ, ಎಕ್ ಎಳಾರ್ ಸಾಂಚೆಕ್ಡೆ ರ್‍ಹಾವ್ಕ್ ಫಿರೆ, ನಾಹೊಲ್ಯಾರ್ ಅರ್ದ್ಯಾ ರಾತ್ತಿನ್ ರ್‍ಹಾವ್ಕ್ ಫಿರೆ, ನಾಹೊಲ್ಯಾರ್ ನಸ್ಕಾತ್ ನಾಹೊಲ್ಯಾರ್ ಸಕ್ಕಾಳ್ಚೆ ರಾವ್ಕ್ ಫಿರೆ, ");
INSERT INTO kans_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ತೊ ಎಗ್ದಮುಚ್ ಯೆಲೊ ತರ್, ತುಮಿ ತೆಚ್ಯಾ ಇದ್ರಾಕ್ ಜಾಗೆ ಹೊತ್ತ್ಯಾ ಸರ್ಕೆ ದಿಸುಚೆ. ");
INSERT INTO kans_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ಮಿಯಾ ತುಮ್ಕಾ ಕಾಯ್ ಸಾಂಗುಚೆ ಮನುನ್ ಹಾಂವ್” ಮಟ್ಲ್ಯಾರ್ ತುಮಿ ಸಗ್ಳೆ ಜಾನಾ ಜಾಗೆ ರ್‍ಹಾವಾ. ");
INSERT INTO kans_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ಪಾಸ್ಕ್ ಮನ್ತಲ್ಯಾ ಅನಿ ಇಸ್ಟ್ ಘಾಲಿನಸ್ತಾನಾ ಕರಲ್ಲ್ಯಾ ಭಾಕ್ರಿಚ್ಯಾ ಸನಾಕ್ ಅನಿ ಖಾಲಿ ದೊನ್ ದಿಸಾ ಹುರಲ್ಲಿ, ತನ್ನಾ ಮುಖ್ಯ ಯಾಜಕಾನಿ ಅನಿ ಖಾಯ್ದೆ ಸಿಕ್ವುತಲ್ಯಾನಿ ಜೆಜುಕ್ ಘುಟಾನಿ ಧರುನ್ ಜಿವಾನಿ ಮಾರುಚೆ ಮನುನ್ ಯವ್ಜುನ್ ಘೆವ್ನ್ ಹೊತ್ತ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ಮಾನಾ “ಅತ್ತಾ ಸನ್ ತೊಂಡಾರ್ ಯೆಲೊ, ಲೊಕಾನಿ ಚವ್ತಾಳುನ್ ಖೈ ತರ್ ಧಾಂದಲ್ ಉಟ್ವುತಿಲ್” ಮನುನ್ ಬೊಲುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ಬೆಥನಿ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಎಕ್ ಕಾಲಾತ್ ಕುಸ್ಟ್ ರೊಗ್ ಲಾಗ್ಲುನ್ ಗುನ್ ಹೊಲ್ಲ್ಯಾ ಸಿಮಾವಾಚ್ಯಾ ಘರಾತ್ ಜೆಜು ಜೆವಾನ್ ಕರುಕ್ ಲಾಗಲ್ಲೊ, ತನ್ನಾ ಲೈ ಮ್ಹಾಗ್ರೆ ಬರ್‍ಯಾ ವಾಸೆಚೆ ತೆಲ್ ಘೆವ್ನ್ ಎಕ್ ಬಾಯ್ಕೊಮನುಸ್ ಥೈ ಯೆಲಿ, ಅನಿ ಭರ್‍ನಿ ಉಗ್ಡುನ್ ತೆ ಸುಗಂದ್ತೆಲ್ ಜೆಜುಚ್ಯಾ ಟಕ್ಲ್ಯಾ ವರ್‍ತಿ ವೊತ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ಥೈ ಹೊತ್ತಿ ಉಲ್ಲಿ ಲೊಕಾ “ಹೆ ಎವ್ಡೆ ಮ್ಹಾಗ್ರೆ ತೆಲ್ ಕಶ್ಯಾಕ್ ಹಾಳ್ ಕರ್‍ಲೆ?” ಮನುನ್ ಎಕಾಮೆಕಾತ್ನಿ ಮನುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“ಹೆ ತೆಲ್ ತಿನ್ ಸೆಂಬರ್ ಚಾಂದಿಚ್ಯಾ ಪೈಸ್ಯಾಕ್ನಿ ಇಕುನ್ ಯೆಲ್ಲೆ ಪೈಸೆ ಗರಿಬಾಕ್ನಿ ದಿಲ್ಯಾರ್ ಹೊಯ್ನಸಿತ್ತೆ ಕಾಯ್?” ಮನುನ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಜೊರ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ಖರೆ ಜೆಜುನ್ ಗಪ್ ರ್‍ಹಾವಾ,ತಿಕಾ ಸೊಡುನ್ ಸೊಡಾ ತಿಕಾ ಕಶ್ಯಾಕ್ ತರಾಸ್ ದಿವ್ಕ್ ಲಾಗ್ಲ್ಯಾಶಿ, ತೆನಿ ಮಾಜೆ ಸಾಟ್ನಿ ಎಕ್ ಎಗ್ದಮ್ ಬರೆ ಕಾಮ್ ಕರ್‍ಲಿನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ಗರಿಬ್ ಲೊಕಾ ಕನ್ನಾಬಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರಾತ್ಯಾತ್, ತುಮ್ಕಾ ಮನ್ ಯೆತಾ ತನ್ನಾ ತುಮಿ ತೆಂಕಾ ತುಮ್ಚೆನ್ ಹೊತಾ ತವ್ಡೆ ಬರೆ ಕರುಕ್ ಹೊತಾ, ಖರೆ ಮಿಯಾ ಕನ್ನಾಬಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ಹ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್ ಅಪ್ನಾನ್ ಕಾಯ್ ಕರುಚೆ ಮನುನ್ ಯವಜಲ್ಲಿನ್ ತೆ ತೆನಿ ಕರ್‍ಲಿನ್, ತೆನಿ ಹೆ ಸುಗಂದ್ತೆಲ್ ಮಾಜ್ಯಾ ಆಂಗಾರ್ ಒತುನ್, ಮಿಯಾ ಮರುಚ್ಯಾ ಅದ್ದಿಚ್ ಮಾಜೆ ಶರಿರ್ ಸಮಾದಿ ಕರುಕ್ ಮನುನ್ ತೆನಿ ತಯಾರ್ ಕರ್‍ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ಬಗಾ, ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ “ಸಗ್ಳ್ಯಾ ದುನಿಯಾತ್ ಬರಿ ಖಬರ್ ಪರ್ಗಟ್ ಕರಲ್ಲ್ಯಾ-ಕರಲ್ಲ್ಯಾಕ್ಡೆ, ಹಿನಿ ಕರಲ್ಲ್ಯಾ ಕಾಮಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗುನ್ ಹಿಕಾ ಯಾದ್ ಕರುಂಗೆತ್ ರ್‍ಹಾತ್ಯಾತ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ಮಾನಾ ಬಾರಾ ಜಾನಾ ಶಿಸಾಂಚ್ಯಾ ಮದ್ಲೊ ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತ್ ಜೆಜುಕ್ ಧರುನ್ ದಿವ್ಕ್ ಮನುನ್ ಮುಖ್ಯ ಯಾಜಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲುಕ್ ಮನುನ್ ಗೆಲೊ ");
INSERT INTO kans_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ತೆನಿ ಸಾಂಗಟಲ್ಲೆ ಆಯ್ಕುನ್, ತೆನಿ ಲೈ ಕುಶಿ ಹೊಲೆ ಅನಿ ತುಕಾ ಪೈಸೆ ದಿತಾಂವ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ, ತಸೆ ಮನುನ್ ಜೆಜುಕ್ ಧರುನ್ ದಿತಲೊ ಬರೊ ಅವ್ಕಾಸ್ ತೊ ಹುಡ್ಕುನ್ಗೆತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಸಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಪಾಸ್ಕಾಚೆ ಜೆವಾನ್ ಕರ್‍ತಲೆ ಇಸ್ಟ್ ಘಾಲಿನಸಲ್ಲ್ಯಾ ಭಾಕ್ರಿಚ್ಯಾ ಸನಾಚ್ಯಾ ಪಯ್ಲೆಚ್ಯಾ ದಿಸಿ, ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚ್ಯಾ ಜೆವ್ನಾಚೆ ಬಕ್ರೆ ಬಲಿ ದಿತಲ್ಯಾ ದಿಸಿ, ಶಿಸಾನಿ ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್ “ಪಾಸ್ಕಾಚ್ಯಾ ಜೆವ್ನಾಚಿ ತಯಾರಿ ಅಮಿ ಖೈ ಜಾವ್ನ್ ಕರುಚೆ ಮನುನ್ ತಿಯಾ ಮನ್ತೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ದೊಗ್ಯಾ ಜಾನಾ ಶಿಸಾಕ್ನಿ ಬಲ್ವುನ್ “ತುಮಿ ಗಾಂವಾತ್ ಜಾಂವಾ, ಥೈ ಎಕ್ ಪಾನಿಯಾಚೊ ಬಿಂದ್ಗೊ ಖಾಂಜಾರ್ ಘೆವ್ನ್ ಯೆತಲೊ ಎಕ್ ಮಾನುಸ್ ಗಾವ್ತಾ, ತೆಚ್ಯಾ ಫಾಟ್ನಾಚ್ ಜಾಂವಾ, ");
INSERT INTO kans_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ಅನಿ ತೊ ಖಲ್ಯಾ ಘರಾತ್ ಜಾವ್ನ್ ಗುಸ್ತಾ ಕಿ, ತ್ಯಾ ಘರಾತ್ ಜಾಂವಾ, ಅನಿ ತ್ಯಾ ಘರ್‍ಚ್ಯಾ ವಡ್ಲಾಕ್, ಅಮ್ಚ್ಯಾ ಗುರುಜಿನ್; ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಪಾಸ್ಕಾಚೆ ಜೆವಾನ್ ಕರ್‍ತಲಿ ಖೊಲಿ ಖೈ ಹಾಯ್ ಮನುನ್ ಇಚಾರ್ಲಾನ್ಯಾಯ್?” ಮನುನ್ ಸಾಂಗಾ. ");
INSERT INTO kans_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ತನ್ನಾ ತೊ ವಡಿಲ್ ತುಮ್ಕಾ ಮ್ಹಾಳ್ಗಿ ವರ್‍ತಿ ಹೊತ್ತಿ ಮೊಟಿ ಖೊಲಿ ದಾಕ್ವುತಾ, “ಥೈ ಅಮ್ಕಾ ಸಗ್ಳೆ ಬರೆ ಕರುನ್ ತಯಾರ್ ಕರುನ್ ಥವಲ್ಲೆ ರ್‍ಹಾತಾ. ಥೈ ಜೆವ್ನಾಚಿ ತಯಾರಿ ಕರಾ” ಮನುನ್ ಸಾಂಗುನ್ ಧಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ತನ್ನಾ ತಿ ಶಿಸಾ ತ್ಯಾ ಗಾಂವಾತ್ ಗೆಲಿ, ಥೈ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ತೆಂಕಾ ಗಾವ್ಲೆ, ಥೈ ತೆನಿ ಪಾಸ್ಕಾಚ್ಯಾ ಜೆವ್ನಾಚಿ ಯವಸ್ತಾ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ಸಾಂಚೆಕ್ಡೆ ಜೆಜು ಬಾರಾ ಜಾನಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಥೈ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ತೆನಿ ಜೆವಾನ್ ಕರ್‍ತಾನಾ ಜೆಜುನ್ “ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ತುಮ್ಚ್ಯಾತ್ಲೊ ಎಕ್ಲೊ ಮಾಕಾ ಘಾತ್ ಕರ್‍ನಾರ್ ಹಾಯ್.ತೊ ಮಾನುಸ್ ಹಿತ್ತೆ ಅತ್ತಾ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಜೆವಾನ್ ಕರುಕ್ ಲಾಗ್ಲಾ”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ಹೆ ಆಯ್ಕುನ್ ಶಿಸಾ ಬೆಜಾರ್ ಹೊವ್ನ್ ಎಕ್ಲ್ಯಾಚ್ಯಾ ಮಾನಾ ಎಕ್ಲೊ, ಜೆಜುಕ್‍ “ಮಿಯಾ ತರ್ ನ್ಹಯ್, ನ್ಹಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ “ತುಮ್ಚ್ಯಾ ಬಾರಾ ಜಾನಾನಿತ್ಲೊ ಎಕ್ಲೊ, ತೊ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಆಯ್ದಾನಾತ್ ಅಪ್ನಾಚೊ ಭಾಕ್ರಿಚೊ ತುಕ್ಡೊ ಬುಡ್ವುತಾ. ");
INSERT INTO kans_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲ್ಯಾ ಪರ್ಕಾರ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮರುಕುಚ್ ಪಾಜೆ ಅನಿ ಮರ್ತಾ, ಖರೆ ತೆಕಾ ಘಾತ್ ಕರ್‍ತಲ್ಯಾ ಮಾನ್ಸಾಚಿ ಗತ್, ಮಿಯಾ ಕಾಯ್ ಸಾಂಗು! ತೊ ಮಾನುಸ್ ಜಲ್ಮುಕುಚ್ ನಸ್ಲ್ಯಾರ್ ತೆಕಾಚ್ ಕವ್ಡೆಕಿ ಬರೆ ಹೊತ್ತೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ತೆನಿ ಜೆವಾನ್ ಕರ್‍ತಾನಾ ಜೆಜುನ್ ಭಾಕ್ರಿ ಹಾತಿತ್ ಘೆವ್ನ್, ಧನ್ಯಾವಾದಾಚಿ ಮಾಗ್ನಿ ಕರುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ದಿವ್ನ್ “ಹೆ ಮಾಜೆ ಶರಿರ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ಮಾನಾ ಜೆಜುನ್ ವಾಯ್ನಾಚೆ ಆಯ್ದಾನ್ ಘೆವ್ನ್. ದೆವಾಕ್ ಧನ್ಯಾವಾದ್ ದಿವ್ನ್ ತೆ ತೆಂಕಾ ದಿಲ್ಯಾನ್, ತೆನಿ ತೆ ಫಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ಜೆಜುನ್ ತೆಂಕಾ “ಹೆ ಮಾಜೆ ರಗಾತ್, ದೆವಾನ್ ಅಪ್ನಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಕರಲ್ಲೊ ಎಕ್ ನ್ಹವೊ ಕರಾರ್, ಹೆ ಸುಮಾರ್ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ವೊತಲ್ಲೆ ರಗಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಮಿಯಾ ನ್ಹವೊ ವಾಯ್ನ್ ಫಿತಲ್ಯಾ ದಿಸಾ ಸಗೊಳ್ ಹಿ ವಾಯ್ನ್ ಕನ್ನಾಚ್ ಫಿ ನಾ”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ಮಾನಾ ತೆನಿ ಎಕ್ ಕಿರ್ತನ್ ಗಾವುನ್ ಒಲಿವ್ ಝಾಡಾಂಚ್ಯಾ ಮಡ್ಡಿ ವರ್‍ತಿ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ಮಾನಾ ಜೆಜುನ್ ತೆಂಕಾ “ತುಮಿ ಮಾಕಾ ಸೊಡುನ್ ಪಳುನ್ ಜಾತ್ಯಾಶಿ” ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ “ದೆವ್ ಕುರ್‍ಬುರಾಕ್ ಜಿವಾನಿ ಮಾರ್‍ತಾ, ತನ್ನಾ ಸಗ್ಳಿ ಬಕ್ರಿ ಮಾಳ್ಬರ್ ಹೊತ್ಯಾತ್” ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲೆ ಹಾಯ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“ಖರೆ ಮಿಯಾ ಮರುನ್ ದೆವಾನ್ ಮಾಕಾ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವಲ್ಲ್ಯಾ ತನ್ನಾ ಮಿಯಾ ತುಮ್ಚ್ಯೆನ್ಕಿ ಅದ್ದಿ ಗಾಲಿಲಿಯಾಕ್ ಜಾತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ತನ್ನಾ ಪೆದ್ರು “ಹುರಲ್ಲೆ ಸಗ್ಳೆ ಜಾನಾ ತುಕಾ ಸೊಡುನ್ ಗೆಲ್ಯಾರ್ಬಿ ಮಿಯಾ ತುಕಾ ಸೊಡುನ್ ಜಾಯ್ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ತನ್ನಾ ಜೆಜುನ್ “ಮಿಯಾ ತುಕಾ ಸಾಂಗ್ತಾ, ಆಜ್ ರಾಚ್ಚೆ ದೊನ್ದಾ ಕೊಂಬೊ ಭೊಕುಚ್ಯಾ ಅದ್ದಿ, ತಿಯಾ ತಿನ್ದಾ ಮಾಜಿ ತುಕಾ ಒಳಕುಚ್ ನಾ ಮನುನ್ ಸಾಂಗ್ತೆ”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ಖರೆ ಪೆದ್ರು “ಅನಿ ವಿಶ್ವಾಸಾನ್ ಮಾಕಾ ತುಜೆ ವಾಂಗ್ಡಾ ಮರ್‍ತಲೊ ಎಳ್ ಯೆಲ್ಯಾರ್ಬಿ, ತುಜಿ ಮಾಕಾ ವಳಕುಚ್ ನಾ ಮನುನ್ ಎವ್ಡೆ, ಕನ್ನಾಬಿ ಸಾಂಗಿನಾ” ಮನುನ್ ಸಾಂಗ್ತಾನಾ ಸಗ್ಳಿ ಶಿಸಾಬಿ ತಸೆಚ್ ಮನುಲಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ಮಾನಾ ತೆನಿ ಗೆತ್ಸೆಮನಿ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಯೆವ್ನ್ ಪಾವ್ಲ್ಯಾನಿ. ಅನಿ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ “ಮಿಯಾ ಮಾಗ್ನಿ ಕರುನ್ ಯೆಯ್ ಸಗೊಳ್ ಹಿತ್ತೆ ಬಸಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ಜೆಜುನ್ ಪೆದ್ರುಕ್ ಜಾಕೊಬಾಕ್ ಅನಿ ಜುವಾಂವಾಕ್ ವಾಂಗ್ಡಾ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್, ತರಾಸ್ ಅನಿ ದುಕ್ ತೆಚೆ ವರ್‍ತಿ ಯೆಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ಅನಿ ಜೆಜುನ್ ತೆಂಕಾ “ಮಾಜ್ಯಾ ಕಾಳ್ಜಾತ್ ದುಖ್ಕ್ ಭರ್ಲಾ ಅನಿ ತೆ ಮಾಕಾ ಮಿಯಾ ಮರ್ತಾ ಸರ್ಕೆ ಕರುಕ್ ಲಾಗ್ಲಾ. ತುಮಿ ಹಿತ್ತೆಚ್ ರ್‍ಹಾವ್ನ್ ಜಾಗೆ ರ್‍ಹಾವಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ಅನಿ ಜೆಜು ಉಲ್ಲೆ ಫಿಡೆ ಗೆಲೊ ಅನಿ ಜಿಮ್ನಿರ್ ಡಬ್ ಪಡುನ್ “ಸಾದ್ಯ್ ರ್‍ಹಾಲ್ಯಾರ್ ಹ್ಯೊ ಸಂಕಟಾಚೊ ಎಳ್ ಮಾಜೆಕ್ನಾ ದುರ್ ಕರ್” ಮನುನ್ ಮಾಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ಜೆಜು ಮಾಗುನ್ಗೆತ್ “ಬಾಬಾ” “ಮಾಜ್ಯಾ ಬಾಬಾ! ತುಕಾ ಸಗ್ಳೆ ಸಂಗ್ತಿಯಾ ಕರುಕ್ ಸಾದ್ಯ್ ಹಾಯ್, ಹೆ ಸಂಕಟಾಚೆ ಅಯ್ದಾನ್ ಮಾಜೆಕ್ನಾ ದುರ್ ಕರ್, ಖರೆ ಮಿಯಾ ಯವಜ್ತಾ ತಸೆ ನ್ಹಯ್, ತಿಯಾ ಯವಜಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ಕರ್” ಮನುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ಮಾನಾ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ತಿನ್ ಶಿಸಾಂಚ್ಯಾಕ್ಡೆ ಯೆಲೊ ಅನಿ ತೆನಿ ತಿಗೆ ಜಾನಾಬಿ ನಿಜಲ್ಲೆ ಬಗುನ್ ತೆನಿ ಪೆದ್ರುಕ್ “ಸಿಮಾವ್, ತಿಯಾ ನಿದ್ಲೆ ಕಾಯ್? ಎಕ್ ತಾಸ್ಬರ್ ಸೈತ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ತುಕಾ ಜಾಗೆ ರಾವ್ಕ್ ಹೊಯ್ನಾ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ತೆನಿ ತೆಂಕಾ “ತುಮಿ ಪಾಪಾತ್ ಪಡಿನಸಿ ಸರ್ಕೆ ಜಾಗಿ ರವ್ನ್ ಮಾಗ್ನಿ ಕರಾ. ಮನ್ ತಯಾರ್ ಹಾಯ್ ಹೊಯ್, ಖರೆ ಹ್ಯಾ ಶರಿರಾಕ್ ತವ್ಡಿ ಸಂಬಾಳ್ತಲಿ ತಾಕತ್ ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ಮಾನಾ ಅನಿ ಎಗ್ದಾ ತೊ ಧುರ್ ಗೆಲೊ ಅನಿ ತ್ಯಾಚ್ ಗೊಸ್ಟಿಯಾನಿ ತೆನಿ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ಮಾನಾ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ‍ ಶಿಸಾನಿಕ್ಡೆ ಫಾಟಿ ಯೆಲೊ ಅನಿ ತೆನಿ ನಿಜಲ್ಲೆ ಬಗಟ್ಲ್ಯಾನ್, ತೆಂಕಾ ಡೊಳೆ ಉಗ್ಡುಕ್ ಸೈತ್ ಹೊಯ್ನಶಿ, ತೆಕಾ ಕಾಯ್ ಸಾಂಗುಚೆ ಮನುನ್ ತೆಂಕಾಚ್ ಕಳಿನಸಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ತೊ ತಿನ್ವೆ ಫಾಟಿ ಪರ್ತುನ್ ತೆಂಚೆಕ್ಡೆ ಯೆವ್ನ್ “ತುಮಿ ಅಜುನ್ಬಿ ನಿಜುನ್ ಆರಾಮ್ ಘೆವ್ಲ್ಯಾಶಿ? ಫಿರೆ, ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಧರುನ್ ಪಾಪಿ ಲೊಕಾಂಚ್ಯಾ ಹಾತಾತ್ನಿ ದಿತಲೊ ಎಳ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ಉಟಾ, ಜಾಂವಾ, ಬಗಾ, ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಹಾತಿತ್ ಧರುನ್ ದಿತಲೊ ಯೆವ್ಲಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ಜೆಜು ಬೊಲುನ್ಗೆತುಚ್ ರಾತಾನಾ ಬಾರಾಜಾನಾನಿತ್ಲೊ ಜುದಾಸ್ ಯೆಲೊ. ಅನಿ ಹೆಚ್ಯಾ ಫಾಟ್ನಾ ಕೊಯ್ತೆ ಅನಿ ಟೊನೆ ಹಾತಾತ್ನಿ ಧರುನ್ ಘೆವ್ನ್ ಎಕ್ ಲೊಕಾಂಚೊ ತಾಂಡೊಚ್ ಯೆಲ್ಲೊ. ಮುಖ್ಯ ಯಾಜಕಾನಿ, ಖಾಯ್ದೆ ಸಿಕ್ವುತಲ್ಯಾನಿ ಅನಿ ವಡಿಲಾನಿ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ಧರುನ್ ದಿತಲ್ಯಾನ್ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಎಕ್ ಘುರ್ತ್ ದಿಲ್ಲ್ಯಾನ್, “ಮಿಯಾ ಕೊನಾಕ್ ಉಪ್ಪಾ ದಿತಾಕಿ ತೊಚ್ ತುಮ್ಕಾ ಪಾಜೆ ಹೊಲ್ಲೊ, ತೆಕಾ ತುಮಿ ಧರಾ ಅನಿ ಉಶಾರ್ಕಿನ್ ಘೆವ್ನ್ ಜಾವಾ” ಮನುನ್ ಸಾಂಗಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ಯೆಲ್ಲ್ಯಾ ತನ್ನಾಚ್ ಜುದಾಸ್ ಜೆಜುಕ್ಡೆ ಗೆಲೊ ಅನಿ ಗುರುಜಿ! ಮಟ್ಲ್ಯಾನ್ ಅನಿ ಜೆಜುಚಿ ಉಪ್ಪಾ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ತನ್ನಾ ತೆನಿ ತೆಕಾ ಘಟ್ ಧರುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ಖರೆ ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾ ತ್ಯೆಂಚಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾನ್ ಅಪ್ನಾಚೊ ಚಾಕು ಕಾಡುನ್ ಮಹಾಯಾಜಕಾಚ್ಯಾ ಎಕ್ಲ್ಯಾ ಆಳಾಕ್ ಮಾರುನ್ ತೆಚೊ ಕಾನುಚ್ ಕಾತರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಎಕ್ ಚೊರಾಕ್ ಧರುಕ್ ಯೆಲ್ಲ್ಯಾ ಸರ್ಕೆ, ಕೊಯ್ತೆ, ಟೊನೆ ಘೆವ್ನ್ ತುಮಿ ಕಶ್ಯಾಕ್ ಯೆಲ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ಮಿಯಾ ಸದ್ದಿಚ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಸಿಕ್ವುನ್ಗೆತ್ ಹೊತ್ತೊ, ಥೈ ತುಮಿ ಮಾಕಾ ಧರುಕ್ನ್ಯಾಸಿ,ಖರೆ ಹೆ ಸಗ್ಳೆ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಸಾಂಗಲ್ಲ್ಯಾ ಬಾಸೆನ್ ಹೊಲೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ತನ್ನಾ ಜೆಜುಚಿ ಸಗ್ಳಿ ಶಿಸಾ ಜೆಜುಕ್ ಎಕ್ಲ್ಯಾಕುಚ್ ಸೊಡುನ್ ಪಳುನ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ಎಕ್ಲೊ ದಾನ್ಡಗೊ ಮಾಸುನ್ ಮ್ಹಾಗ್ರೊ ಕಪ್ಡೊ ಧಾಪುನ್ ಘೆವ್ನ್ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಯೆಯ್ ತೆಕಾ ಧರುಕ್ ಪ್ರಯತ್ನ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ಖರೆ ತೊ ಅಪ್ನಾಚ್ಯಾ ಆಂಗಾ ವಯ್ಲೊ ಕಪ್ಡೊ ತೆಂಚ್ಯಾ ಹಾತಾತ್ ಸೊಡುನ್ ನಾಗ್ಡೊಚ್ ಪಳುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ತ್ಯಾ ಧರುನ್ ಹಾನಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಜೆಜುಕ್ ಮಹಾಯಾಜಕಾಚ್ಯಾ ಘರಾಕ್ಡೆ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ.ಥೈ ಸಗ್ಳಿ ಮುಖ್ಯ ಯಾಜಕಾ, ಜಾನ್ತಿ ಲೊಕಾ ಅನಿ ಖಾಯ್ದೆ ಸಿಕ್ವುತಲೆ ಥೈ ಯೆವ್ನ್ ಜಮಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ಪೆದ್ರು ಧುರ್-ಧುರ್ನಾಚ್ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ -ಫಾಟ್ನಾ ಮಹಾಯಾಜಕಾಚ್ಯಾ ಘರಾಚ್ಯಾ ದಾರಾತ್ ಸಗೊಳ್ ಯೆಲೊ, ಥೈ ರಾಕ್ವಾಲ್ಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಸುನ್ ಆಗ್ ಶೆಕುಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ಮುಖ್ಯ ಯಾಜಕಾನಿ ಅನಿ ಸಗ್ಳ್ಯಾ ಸಬೆತ್ಲ್ಯಾನಿ ಉಲ್ಲ್ಯಾ ಸಾಕ್ಷಿಯಾಂಚ್ಯಾ ವೈನಾ ತೆಚ್ಯಾತ್ ಚುಕ್ ಹುಡ್ಕುನ್ ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿವ್ಕ್ ಮನುನ್ ಬಗಟ್ಲ್ಯಾನಿ, ಖರೆ ತೆಂಕಾ ಕಾಯ್ಬಿ ಗಾವುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ಸುಮಾರ್ ಲೊಕಾನಿ ಜೆಜುಚ್ಯಾ ವಿರೊದ್ ಝುಟ್ಯಾ ಸಾಕ್ಷಿಯಾ ಸಾಂಗ್ಲ್ಯಾನಿ, ಖರೆ ತೆನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಕಾನಿಯಾ ಎಕಾಕ್ ಎಕ್ ಹೊಂದುಕ್ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ಮಾನಾ ಎಕ್ ಉಲ್ಲಿ ಲೊಕಾ ಇಬೆ ರ್‍ಹಾವ್ನ್ ಜೆಜುಚ್ಯಾ ವಿರೊದ್ ಝುಟೆ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ಹ್ಯೊ ಮಾನುಸ್, ಮಾನ್ಸಾನಿ ಭಾಂದಲ್ಲಿ ದೆವಾಚಿ ಗುಡಿ ಮೊಡುನ್, ತಿನ್ ದಿಸಾ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ “ಮಿಯಾ ತಿ ಭಾಂದ್ತಾ” ಖರೆ ಮಾನ್ಸಾನ್ ಭಾಂಧಲ್ಲ್ಯಾ ಸರ್ಕೆ ನ್ಹಯ್, ಮನುನ್ ಸಾಂಗ್ತಲೆ ಅಮಿ ಆಯ್ಕ್ಲಾಂವ್, ");
INSERT INTO kans_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ಜಾಲ್ಯಾರ್ಬಿ,ತೆಂಚ್ಯಾ ಸಾಕ್ಷಿಯಾ ಎಕಾಮೆಕಾಕ್ ಹೊಂದುಕ್ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ತನ್ನಾ ಮಹಾಯಾಜಕ್ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಇಬೆ ರ್‍ಹಾಲೊ ಅನಿ ಜೆಜುಕ್ “ಹಿ ಲೊಕಾ ತುಜೆ ವರ್‍ತಿ ಕಾಯ್-ಕಾಯ್ ಅಪ್ವಾದ್ ಘಾಲುಲ್ಯಾತ್, ಹೆಕಾ ತುಜೆಕ್ಡೆ ಕಾಯ್ಬಿ ಜಾಬ್ ನಾ ಕಾಯ್?” ಮನುನ್ ಪ್ರಸ್ನ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ಖರೆ ಜೆಜು ಎಕ್ಬಿ ಶಬ್ದ್ ಬೊಲಿನಸ್ತಾನಾ ಗಪ್ಪುಚ್ ಇಬೆ ರ್‍ಹಾಲೊ. ಅನಿ ಫಿಡೆ ಮಹಾಯಾಜಕಾನ್ ತೆಕಾ “ತಿಯಾ ಆರಾದನೆಕ್ ಯೊಗ್ಯ್ಅಸಲ್ಲ್ಯಾಚೊ ಲೆಕ್ ಮೆಸ್ಸಿಯಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ಜೆಜುನ್ “ಹೊಯ್ ಮಿಯಾ” ಮನುನ್ ಜಾಬ್ ದಿವ್ನ್, “ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮಹೊನ್ನತಾಚ್ಯಾ ಉಜ್ವ್ಯಾಕ್ಡೆ ಬಸಲ್ಲೆ ಅನಿ ದೆವ್ ರ್‍ಹಾತಲ್ಯಾ ಜಾಗ್ಯಾ ವೈನಾ ಯೆತಲ್ಯಾ ಮಹಿಮೆಚ್ಯಾ ಮೊಡಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆತಲೆ ತುಮಿ ಬಗ್ತ್ಯಾಸಿ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ಮಹಾಯಾಜಕಾನ್ ಅಪ್ನಾಚೆ ಕಪ್ಡೆ ಪಿಂಜ್ಲ್ಯಾನ್ ಅನಿ “ಅಮ್ಕಾ ಹೆಚೆನ್ ಮೊಟಿ ಕಸ್ಲಿ ಸಾಕ್ಷಿ ಪಾಜೆ! ");
INSERT INTO kans_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ಹೆನಿ ಬೊಲಲ್ಲಿ ದೆವಾಚಿ ನಿಂದ್ಯಾ ತುಮಿಚ್ ಆಯಿಕ್ಲ್ಯಾಶಿ, ಅತ್ತಾ ತುಮ್ಚೊ ನಿರ್‍ದಾರ್ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ತೆಕಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ತೊ ಅಪ್ರಾದಿ, ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ಹೊವ್ಕ್ ಪಾಜೆ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಥೊಡ್ಯಾನಿ ಜೆಜುಕ್ ಥುಕ್ಲ್ಯಾನಿ, ಅನಿ ತೆಚ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ಫಾಳಿ ಭಾಂದುನ್ ತೆಕಾ ಡುಬ್ರಿತ್ ಮುಟ್ಕ್ಯಾನಿ ಮಾರ್‍ಲ್ಯಾನಿ ಅನಿ “ತುಕಾ ಮಾರಲ್ಲೆ ಕೊನ್ ಮನುನ್ ಸಾಂಗ್” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ಅನಿ ರಾಕ್ವಾಲ್ಯಾನಿ ಠಪ್ರಾಕ್ಯಾ ಮಾರುನ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ಅತ್ತಾ ಪೆದ್ರು ದಾರಾತ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ಮಹಾಯಾಜಕಾಚ್ಯಾ ಘರಾತ್ ಕಾಮ್ ಕರ್‍ತಲೆ ಎಕ್ ಚೆಡು ಥೈ ಯೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ತೆನಿ ಪೆದ್ರು ಆಗಿಕ್ಡೆ ಬಸುನ್ ಆಗ್ ಶೆಕ್ತಲೆ ಬಗಟ್ಲಿನ್,ತೆನಿ ಬರೆ ಕರುನ್ ಪೆದ್ರುಕ್ ಬಗುನ್ “ತಿಯಾಬಿ ನಜರೆತಾಚ್ಯಾ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೆ ನ್ಹಯ್?” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ಖರೆ ಪೆದ್ರುನ್ “ಮಾಕಾ ಗೊತ್ತ್ ನಾ,ತಿಯಾ ಕಾಯ್ ಮನುಲೆ, ಮಾಕಾ ಕಾಯ್ಬಿ ಕಳಿನಾ ಹೊಲಾ” ಮನುನ್ ಥೈತ್ನಾ ಉಟುನ್ ವಾಟೆನ್ ಜಾತಾನಾ ಕೊಂಬ್ಯಾನ್ ಭೊಕ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ಪೆದ್ರು ಥೈ ಜಾವ್ನ್ ಇಬೆ ಹೊತ್ತೆ ತ್ಯಾ ಕಾಮಾಚ್ಯಾ ಚೆಡ್ವಾನ್ ಬಗುನ್ ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾಕ್ನಿ “ಹ್ಯೊ ಮಾನುಸ್ಬಿ ತ್ಯೆಂಚಾತ್ಲೊಚ್” ಮಟ್ಲಿನ್ . ");
INSERT INTO kans_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ಖರೆ ಪೆದ್ರುನ್ ಅನಿ ಬಿ “ಮಿಯಾ ನ್ಹಯ್” ಮಟ್ಲ್ಯಾನ್ ಅನಿ ಉಲ್ಲೊ ಎಳ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾನಿ ಪೆದ್ರುಕ್ “ಖರೆಚ್ ತಿಯಾಬಿ ತ್ಯೆಂಚಾತ್ಲೊ ಎಕ್ಲೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿಯಾ ಗಾಲಿಲಿಯಾಚೊ ಮಾನುಸ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ತನ್ನಾ ಪೆದ್ರುನ್ “ಮಿಯಾ ಖರೆಚ್ ಆನ್ ಘಾಲುನ್ ಸಾಂಗ್ತಾ ಖಲ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ಬೊಲುಲ್ಯಾಸಿ ತೊ ಮಾಕಾ ಗೊತ್ತ್ ನಾ, ಮಿಯಾ ಝುಟೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ ಜಾಲ್ಯಾರ್ ದೆವ್ ಮಾಕಾ ಶಿಕ್ಷಾ ದಿಂವ್ದಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ಪೆದ್ರು ಅಶೆ ಮನುನ್ ಸಾಂಗ್ತಾನಾ ಕೊಂಬ್ಯಾನ್ ದೊನ್ವೆ ಪಟಿ ಭೊಕ್ಲ್ಯಾನ್, ಜೆಜುನ್ ತೆಕಾ “ದೊನ್ದಾ ಕೊಂಬೊ ಭೊಕುಚ್ಯಾ ಅದ್ದಿ ತಿಯಾ ತುಕಾ ಮಾಜಿ ಒಳಕುಚ್ ನಾ ಮನುನ್ ತಿನ್ದಾ ಸಾಂಗ್ತೆ” ಮನುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚಿ ಪೆದ್ರುಕ್ ಯಾದ್ ಯೆಲಿ, ತನ್ನಾ ತೊ ಕೊಸಳ್ಳೊ ಅನಿ ಗಳ್ಗಳುನ್ ರಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ಸಕ್ಕಾಳಿ ನಸ್ಕಾತ್ ಮುಖ್ಯ ಯಾಜಕಾನಿ ಲಗುಲಗುನಾ, ಜಾನ್ತ್ಯಾಕ್ನಿ, ಖಾಯ್ದೆ ಸಿಕ್ವುತಲ್ಯಾಕ್ನಿ ಅನಿ ಸಗ್ಳಿ ಸಭಾ ಮಿಳುನ್ ಕಾಯ್ ಕರ್‍ತಲೆ ಮನುನ್ ಸಗ್ಳೆ ಯವ್ಜುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ಅನಿ ಸರ್‍ಪೊಳ್ಯಾನಿ ಭಾಂದುನ್ ತೆಕಾ ಪಿಲಾತಾಕ್ ಒಪಸ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ಪಿಲಾತಾನ್ ತೆಕಾ “ತಿಯಾ ಜುದೆವಾಂಚೊ ರಾಜಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರಲ್ಲ್ಯಾಕ್, ಜೆಜುನ್ “ತಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್” ಮನುನ್ ಜಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ಮುಖ್ಯ ಯಾಜಕಾನಿ ಜೆಜುಚ್ಯಾ ವರ್‍ತಿ ಸುಮಾರ್ ಅಪ್ವಾದಾ ಘಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ತಸೆ ಮನುನ್ ಪಿಲಾತಾನ್ ಅನಿ ಎಗ್ದಾ ತೆಕಾ “ಹಿ ಲೊಕಾ ತುಜೆ ವರ್‍ತಿ ಯವ್ಡಿ ಲೈ ಅಪ್ವಾದಾ ಘಾಲುಲ್ಯಾತ್ ಅನಿ ತಿಯಾ ಕಾಯ್ಬಿ ಸಾಂಗಿನೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ಅನಿ ಬಿ ಜೆಜುನ್ ಎಕ್ ಶಬ್ದ್ ಸೈತ್ ಬೊಲುಕ್ನಾ, ಹೆ ಬಗುನ್ ಪಿಲಾತ್ ಅಜಾಪ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ಜುದೆವಾಂಚ್ಯಾ ರಾಜ್ ಅದಿಕಾರಿ ಪಿಲಾತಾನ್ ಹರಿಎಕ್ ವರ್ಸಾ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚ್ಯಾ ಎಳಾರ್ ಲೊಕಾನಿ ಇಚಾರಲ್ಲ್ಯಾ ಎಕ್ ಕೈದಿಕ್ ಸೊಡ್ತಲಿ ಎಕ್ ಪದ್ದತ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ತ್ಯಾ ಎಳಾರ್ ಡಂಗೊ ಉಟ್ವುನ್ ಲೊಕಾಕ್ನಿ ಜಿವಾನಿ ಮಾರಲ್ಲೊ ಬಾರಾಬ್ಬಾಸ್ ಮನ್ತಲೊ ಮಾನುಸ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ವರ್ಸಾಚ್ಯಾ ಬಾಸೆನ್ ಅಮ್ಕಾ ಎಕಾ ಕೈದಿಕ್ ಸೊಡುನ್ ದಿ ಮನುನ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ಮಿಳುನ್ ಪಿಲಾತಾಕ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ತನ್ನಾ ಪಿಲಾತಾನ್ ತೆಂಕಾ \"ಜುದೆವಾಂಚ್ಯಾ ರಾಜಾಕ್ ಮಿಯಾ ತುಮ್ಕಾ ಸೊಡುನ್ ದಿವ್ಕಾಯ್?\" ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ಮುಖ್ಯ ಯಾಜಕಾನಿ ಪೊಟಾತ್ ಆಗ್ ಪಡುನ್ ಜೆಜುಕ್ ಧರುನ್ ಅಪ್ನಾಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾತ್ ಮನುನ್ ಪಿಲಾತಾಕ್ ಗೊತ್ತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ಖರೆ ಮುಖ್ಯ ಯಾಜಕಾನಿ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಬಾರಾಬ್ಬಾಸಾಕ್ ಸೊಡ್ ಮನುನ್ ಸಾಂಗಾ ಮನುನ್ ಸಾಂಗುನ್ ಥವಲ್ಲ್ಯಾನಿ. ತಸೆ ಮನುನ್ ಲೊಕಾನಿ “ಬಾರಾಬ್ಬಾಸಾಕ್ ಸೊಡ್” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ಪಿಲಾತಾನ್ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ “ತಸೆ ಜಾಲ್ಯಾರ್, ತುಮಿ ಜುದೆವಾಂಚೊ ರಾಜಾ ಮನುನ್ ಮನ್ತಲ್ಯಾ ಹ್ಯಾ ಮಾನ್ಸಾಕ್ ಮಿಯಾ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ತೆನಿ ಫಾಟ್ನಾ ಬೊಬ್ ಮಾರುನ್ “ತೆಕಾ ಕುರ್ಸಾ ವರ್ತಿ ಮಾರ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ಖರೆ ಪಿಲಾತಾನ್ “ತೆನಿ ಕಾಯ್ ಚುಕ್ ಕರ್‍ಲ್ಯಾನಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ಖರೆ ತೆನಿ ಜೊರಾನ್ “ತೆಕಾ ಕುರ್ಸಾ ವರ್ತಿ ಮಾರ್” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ಲೊಕಾಕ್ನಿ ಕುಶಿ ಕರುಕ್ ಮನುನ್ ಪಿಲಾತಾನ್ ಬಾರಾಬ್ಬಾಸಾಕ್ ತೆಂಚೆ ಸಾಟ್ನಿ ಸೊಡುನ್ ದಿಲ್ಯಾನ್. ಮಾನಾ ಜೆಜುಕ್ ಬಾರ್‍ಕೊಲಾನಿ ಮಾರುನ್ ಕುರ್ಸಾರ್ ಮಾರುಕ್ ಮನುನ್ ಸಯ್ನಿಕಾಂಚ್ಯಾ ಹಾತಾತ್ ಒಪಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ಪಿಲಾತಾಚ್ಯಾ ಸಯ್ನಿಕಾನಿ ಜೆಜುಕ್ ರಾಜ್ ಭವನಾಚ್ಯಾ ಭುತ್ತುರ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ಮೊಟೆ-ಮೊಟೆ ಅದಿಕಾರಿ ಜಮ್ತಲೊ ಜಾಗೊ ತೊ ಅನಿ ಸಗ್ಳ್ಯಾ ಸಯ್ನಿಕಾಕ್ನಿ ಥೈ ಬಲ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ಮಾನಾ ಸಯ್ನಿಕಾನಿ ಜೆಜುಕ್ ರಾಜಾನ್ ನೆಸ್ತಲಿ ಅಂಗಿ ನೆಸ್ವುಲ್ಯಾನಿ ಅನಿ ಕಾಟ್ಯಾಂಚ್ಯಾ ಎಲಿನ್ ಎಕ್ ಕಿರಿಟ್ ಕರುನ್ ಜೆಜುಚ್ಯಾ ಟಕ್ಲ್ಯಾ ವರ್‍ತಿ ಥವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ಅನಿ ಮಾನಾ “ಜುದೆವಾಂಚ್ಯಾ ರಾಜಾ ನಮಸ್ತೆ ತುಕಾ” ಮನುನ್ ತೆಕಾ ಮನಿತ್. ");
INSERT INTO kans_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ತೆನಿ ತೆಚ್ಯಾ ಟಕ್ಲ್ಯಾ ವರ್‍ತಿ ಭೆತ್ತಾಚ್ಯಾ ಖಾಟಿನಿ ಮಾರುನ್, ತೊಂಡಾ ವರ್‍ತಿ ಥುಕುನ್, ಇದ್ರಾಕ್ ಡೊಗ್ಲಾ ಟೆಕುನ್ ತೆಚಿ ತುಜ್ಯಾ ಕರ್ಲ್ಯಾ ಸಾರ್ಕೆ ನಾಟಕ್ ಕರುನ್ ತೆಕಾ ಎಡ್ಸಡುನ್ ದಾಕ್ವುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ಅಶೆ ಎಡ್ಸಡುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಸಯ್ನಿಕಾನಿ ಜೆಜುಕ್ ನೆಸ್ವಲ್ಲಿ ರಾಜಾ ನೆಸ್ತಲಿ ಅಂಗಿ ಕಾಡುನ್ ತೆಚೆ ಅದ್ದಿ ಹೊತ್ತೆ ಕಪ್ಡೆ ನೆಸ್ವುಲ್ಯಾನಿ, ಅನಿ ತೆಕಾ ಕುರ್ಸಾ ವರ್ತಿ ಮಾರುಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ತನ್ನಾ ಸಿರೆನ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ಲೊ ಸಿಮಾವ್ ಶೆತಾಕ್ನಾ ಯೆತಾನಾ ಸಯ್ನಿಕಾನಿ ತೆಕಾ ಜೆಜುಚೊ ಕುರಿಸ್ ವಾವುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಒತ್ತಾಯ್ ಕರ್‍ಲ್ಯಾನಿ ಸಿಮಾವ್, ಅಲೆಕ್ಸಾಂಡರ್ ಅನಿ ರುಫಸ್ ತೆಂಚೊ ಬಾಬಾ. ");
INSERT INTO kans_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ಅಶೆ ತೆನಿ ಜೆಜುಕ್ ಗೊಲ್ಗೊಥಾ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ಗೊಲ್ಲೊಥಾ ಮಟ್ಲ್ಯಾರ್ ಟಕ್ಲ್ಯಾಚ್ಯಾ ಬುರ್ಡಯಾಚೊ ಜಾಗೊ, ");
INSERT INTO kans_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ಥೈ ತೆನಿ ತೆಕಾ ರಗಾತ್ಬೊಳ್ ಮಿಸಳ್ ಕರಲ್ಲೊ ವಾಯ್ನ್ ಫಿವ್ಕ್ ದಿಲ್ಯಾನಿ.ಖರೆ ಜೆಜುನ್ ತೆ ಫಿವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ಸಯ್ನಿಕಾನಿ ಜೆಜುಕ್ ಕುರ್ಸಾ ವರ್ತಿ ಮಾರುನ್, ಚಿಟಿಯಾ ಘಾಲುನ್ ತೆಚೆ ಕಪ್ಡೆ ಕೊನಾಕ್ ಯೆತ್ಯಾತ್ ಮನುನ್ ವಾಟುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ಜೆಜುಕ್ ಕುರ್ಸಾ ವರ್ತಿ ಮಾರ್ತಾನಾ ಜಗ್ಗೊಳ್-ಜಗ್ಗೊಳ್ ಸಕ್ಕಾಳ್ಚೆ ನ್ಹವ್ ಘಂಟೆ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ಜೆಜುಚ್ಯಾ ವರ್‍ತಿ ಘಾಟಲ್ಲೊ ಅಪ್ವಾದ್ “ಜುದೆವಾಂಚೊ ರಾಜಾ” ಮನುನ್ ಲಿವಲ್ಲೆ ಥೈ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ದೊನ್ ಚೊರಾಕ್ನಿಬಿ ಕುರ್ಸಾರ್ ಮಾರಲ್ಲ್ಯಾನಿ, ಎಕ್ಲ್ಯಾಕ್ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ಡಾವ್ಯಾ ಬಾಜುಕ್. ");
INSERT INTO kans_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ಅಶೆ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲ್ಯಾ ಪರ್‍ಕಾರ್, “ಚೊರಾಂಚೊ ವಾಂಗ್ಡಿ” ಮನುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ಥೈತ್ನಾ ಹಿಕ್ಡಿ-ತಿಕ್ಡಿ ದಾಟುನ್ ಜಾತಲಿ ಲೊಕಾನಿ ಟಕ್ಲೆ ಹಾಲ್ವುನ್ಗೆತ್ “ತಿಯಾ ದೆವಾಚಿ ಗುಡಿ ಮೊಡುನ್ ತಿನ್ ದಿಸಾತ್ನಿ ಭಾಂದ್ತಾ ಮಟಲ್ಲೆ, ");
INSERT INTO kans_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ಅತ್ತಾ ಕುರ್ಸಾ ವೈನಾ ಉತ್ರುನ್ ತುಕಾಚ್ ತಿಯಾ ಹುರ್ವುನ್ ಘೆ!” ಮನುನ್ ಎಡ್ಸಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ಥೈ ಹೊತ್ತೆ ಮುಖ್ಯ ಯಾಜಕಾ ಅನಿ ಖಾಯ್ದೆ ಸಿಕ್ವುತಲೆಬಿ “ಹೆನಿ ದುಸ್ರ್ಯಾಕ್ನಿ ಬಚಾವ್ ಕರ್‍ಲ್ಯಾನ್, ಖರೆ ಅಪ್ನಾಕುಚ್ ಬಚಾವ್ ಕರುಕ್ ಹೊಯ್ನಾ, ");
INSERT INTO kans_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ಮೆಸ್ಸಿಯಾ, ಇಸ್ರಾಯೆಲಾಚೊ ರಾಜಾ ಅತ್ತಾ ಕುರ್ಸಾ ವೈನಾ ಉತ್ರುನ್ ಯೆಂವ್ದಿ ಬಗುವಾ, ತನ್ನಾ ತೆಚ್ಯಾ ವರ್‍ತಿ ಅಮಿ ವಿಶ್ವಾಸ್ ಥವ್ತಾವ್”. ಮಟ್ಲ್ಯಾನಿ, ಜೆಜುಚ್ಯಾ ಅಜು-ಬಾಜುಕ್ ಕುರ್ಸಾರ್ ಮಾರಲ್ಲ್ಯಾ ಚೊರಾನಿಬಿ ತಸೆಚ್ ಎಡ್ಸಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ಸುಮಾರ್ ದೊಪಾರ್ಚೆ ಬಾರಾ ಘಂಟ್ಯಾಕ್ನಾ ತಿನ್ ಘಂಟ್ಯಾ ಸಗೊಳ್ ತಿನ್ ತಾಸ್ ಸಗ್ಳ್ಯಾ ದೆಸಾತ್ ಕಾಳೊಕ್ ಹೊಲ್ಲೊ ");
INSERT INTO kans_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ತಿನ್ ಘಂಟ್ಯಾಕ್ ಜೆಜುನ್ ಜೊರಾನ್ “ಎಲೊಯಿ, ಎಲೊಯಿ ಲಾಮಾ, ಸಬಾಕ್ತಾನಿ?\" ತಸೆ ಮಟ್ಲ್ಯಾರ್ \"ಮಾಜ್ಯಾ ದೆವಾ, ಮಾಜ್ಯಾ ದೆವಾ, ತಿಯಾ ಮಾಕಾ ಕಶ್ಯಾಕ್ ಸೊಡ್ಲೆ?” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ಹೆ ಆಯ್ಕುನ್ ಥೈ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ “ಆಯ್ಕಾ! ತೊ ಎಲಿಯಾಕ್ ಬಲ್ವುಲಾ”, ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ತನ್ನಾ ಥೈ ಹೊತ್ತೊ ಎಕ್ಲೊ ಪಳುನ್ ಗೆಲೊ ಅನಿ ಪಾನಿ ವೊಡುನ್ ಘೆತಲೊ ಕಾಪ್ಸಾ ಸರ್ಕೊ ಕಪ್ಡೊ ಘೆವ್ನ್ ಅಂಬೊಟ್ಲ್ಯಾ ವಾಯ್ನಾತ್ ಬುಡ್ವುನ್ ಎಕ್ ಝಲ್ಲೆಕ್ ಶಿರ್ಕುನ್ ಜೆಜುಚ್ಯಾ ಹೊಟ್ಟಾಕ್ನಿ ಲಾವುನ್ಗೆತ್ “ಎಲಿಯಾ ತೆಕಾ ಕುರ್ಸಾ ವೈನಾ ಖಾಲ್ತಿ ಉತ್ರುಕ್ ಯೆತಾ ಕಾಯ್ ಬಗುವಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ತನ್ನಾ ಜೆಜುನ್ ಮೊಟ್ಯಾನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್ ಅನಿ ಅಪ್ನಾಚೊ ಜಿವ್ ಸೊಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ತನ್ನಾ ದೆವಾಚ್ಯಾ ಗುಡಿಚೊ ಫಡ್ದೊ ವೈನಾ ಖಾಲ್ತಿ ಸಗೊಳ್ ದೊನ್ ಭಾಗ್ ಹೊವ್ನ್ ಪಿಂಜುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ತನ್ನಾ ಕುರ್ಸಾಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಇಬೆ ಹೊತ್ತ್ಯಾ ಸೈನಿಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಮುಖಂಡಾನ್ ಜೆಜು ಜಿವ್ ಸೊಡ್ತಾನಾ ಕಾಯ್-ಕಾಯ್ ಹೊಲ್ಲೆ ಬಗುನ್ “ಹ್ಯೊ ಮಾನುಸ್ ಖರೆಚ್ ದೆವಾಚೊ ಲೆಕ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ಎಕ್ ಉಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾ ಉಲ್ಲೆಸೆ ದುರ್ ಇಬೆ ರವ್ನ್ ಬಗುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾ, ಮರಿ ಮಾಗ್ದೆಲಿನ್, ಜಾಕೊಬ್ ಅನಿ ಜೊಸೆಂಚಿ ಬಾಯ್ ಮರಿ ಜಾಕೊಬ್ ತಿಚೊ ಧಾಕ್ಲೊ ಲೆಕ್ ಅನಿ ಸಲೊಮಿ. ");
INSERT INTO kans_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ಹೆನಿ, ಜೆಜು ಗಾಲಿಲಿಯಾತ್ ರಾತಾನಾ ತೆಚ್ಯಾ ಫಾಟ್ನಾ ರಾವ್ನ್ ತೆಕಾ ಮಜತ್ ಕರಲ್ಲ್ಯಾನಿ, ಅನಿ ತೆಚ್ಯಾ ವಾಗ್ಡಾ ಜೆರುಜಲೆಮಾಕ್ ಯೆಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮಾನ್ಸಾಬಿ ಥೈ ಹೊತ್ತ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ಸಾಂಜ್ ಹೊಂವ್ನ್ಗೆತ್ ಯೆಲ್ಲಿ, ತೊ ಸಾಬ್ಬಾತಾಚ್ಯಾ ದಿಸಾಚೊ ಅದ್ಲೊ ದಿಸ್ ಮಟ್ಲ್ಯಾರ್ ಸಾಬ್ಬಾತಾಚ್ಯಾ ತಯಾರಿಚೊ ದಿಸ್, ");
INSERT INTO kans_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ತಸೆ ಮನುನ್ ಅರೆಮಾಥಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಚೊ ಜುಜೆ ಯೆಲೊ,ತೊ ಜುದೆವಾಂಚ್ಯಾ ಮಂತ್ರಿ ಮಂಡಳಾಚೊ ಮರ್ಯಾದಿಚೊ ಸದಸ್ಯಾ, ತೊ ದೆವಾಚ್ಯಾ ರಾಜ್ ಯೆತಲೆ ವಾಟ್ ಬಗುನ್ಗೆತ್ ಹೊತ್ತೊ, ತೊ ಧಯ್ರೊ ಕರುನ್ ಪಿಲಾತಾಕ್ಡೆ ಗೆಲೊ ಅನಿ ಜೆಜುಚೆ ಮಡೆ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ಜೆಜು ಎವ್ಡ್ಯಾ ಲಗ್ಗುನಾ ಮರ್ಲೊ ಮನುನ್ ಆಯ್ಕುನ್ ಪಿಲಾತಾಕ್ ವಿಚಿತ್ರ್ ದಿಸ್ಲೆ.ಸೈನಿಕಾಂಚ್ಯಾ ಮುಖಂಡಾಕ್ ಪಿಲಾತಾನ್ ಬಲ್ವುನ್ “ಜೆಜು ಮರುನ್ ಲೈ ಎಳ್ ಹೊಲೊ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ತ್ಯಾ ಸೈನಿಕಾಂಚ್ಯಾ ಮುಖಂಡಾಕ್ನಾ ಜೆಜು ಮರ್ಲೊ ಮನುನ್ ಆಯ್ಕುನ್ ಜುಜೆಕ್ ಜೆಜುಚೆ ಮಡೆ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಪರ್ವಾನ್ಗಿ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ಜುಜೆನ್ ಮಡೆ ಸಮಾದಿ ಕರುಕ್ ವಾಪರ್ತಲೊ ಮ್ಹಾಗ್ರೊ ಕಪ್ಡೊ ಇಕಾತ್ ಘೆವ್ನ್ ಯೆಲ್ಯಾನ್, ಅನಿ ಜೆಜುಚೆ ಮಡೆ ಕುರ್ಸಾ ವೈನಾ ಉತ್ರುನ್ ತ್ಯಾ ಕಪ್ಡ್ಯಾತ್ ಲಪ್ಟುನ್ ಸಮಾದಿತ್ ಥವ್ಲ್ಯಾನಿ. ತಿ ಸಮಾದಿ ಎಕುಚ್ ಎಕ್ ಗುಂಡ್ಯಾತ್ ಕೆದರಲ್ಲಿ ಸಮಾದಿ ಹೊತ್ತಿ. ತೆನಿ ಸಮಾದಿಚ್ಯಾ ದಾರ್ ಎಕ್ ಮೊಟೊ ಗುಂಡೊ ಗುಳ್ವುನ್ ಧಾಪ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ತ್ಯಾ ಎಳಾರ್ ಮರಿ ಮಾಗ್ದೆಲಿನ್ ಅನಿ ಜೊಸೆಚಿ ಬಾಯ್ ಮರಿ ಹೆ ಸಗ್ಳೆ ಬಗುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾನಿ ಅನಿ ಜೆಜುಚೆ ಮಡೆ ಖೈ ಥವಲ್ಲೆ ಹಾಯ್ ಮನುನ್ ತೆನಿ ಬಗುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ಸಾಬ್ಬಾತ್ ಸರುನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಮರಿ ಮಾಗ್ದೆಲಿನ್, ಜಾಕೊಬಾಚಿ ಬಾಯ್ ಮರಿ ಅನಿ ಸಲೊಮಿ ಜೆಜುಚ್ಯಾ ಮಡ್ಯಾಕ್ ಲಾವುಕ್ ಮನುನ್ ಮ್ಹಾಗ್ಲೆ ಸುಗಂದ್ ತೆಲ್ ಇಕಾತ್ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ಅನಿ ಆಯ್ತಾರ್ ದಿಸ್; ದಿಸ್ ಉಜ್ವಾಡಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಸಮಾದಿಕ್ಡೆ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ಅನಿ ಸಮಾದಿಚ್ಯಾ ದಾರಾ ವರ್‍ತಿ ಲಾವಲ್ಲೊ ಗುಂಡೊ ಅಮ್ಕಾ ಕೊನ್ ಕಾಡುನ್ ದಿತ್ಯಾತ್ ಮನುನ್ ಎಕಾಮೆಕಾಕ್ನಿ ಬೊಲುನ್ ಘೆವ್ಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ತೊ ಗುಂಡೊ ಲೈ ಮೊಟೊ ಹೊತ್ತೊ, ಅಶೆ ಬೊಲುನ್ ತೆನಿ ವೈರ್ ಸಮಾದಿಕ್ಡೆ ಬಗ್ತಾನಾ ಸಮಾದಿಚ್ಯಾ ದಾರಾ ವಯ್ಲೊ ಗುಂಡೊ ಲೊಟುನ್ ಕಡೆಕ್ ಕಾಡಲ್ಲೊ ತೆಂಕಾ ದಿಸ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ತೆನಿ ಸಮಾದಿತ್ ಭುತ್ತುರ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಫ್ಹಾಂಡ್ರೆ ಕಪ್ಡೆ ನೆಸುನ್ ಬಸಲ್ಲೊ ಎಕ್ ದಾನ್ಡಗೊ ಮಾನುಸ್ ತೆಂಕಾ ದಿಸ್ಲೊ, ತೆಕಾ ಬಗುನ್ ತೆನಿ ಭಿಯಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ತೆನಿ ತೆಂಕಾ “ಭಿಂವುನಕಾಶಿ, ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್, ತುಮಿ ಹುಡಕ್ತಲೆ ಕುರ್ಸಾರ್ ಮಾರಲ್ಲ್ಯಾ ನಜರೆತಾಚ್ಯಾ ಜೆಜುಕ್, ತೊ ಹಿತ್ತೆ ನಾ, ತೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟ್ಲಾ, ಹಿತ್ತೆ ಬಗಾ ತೆಕಾ ಥವಲ್ಲೊ ಜಾಗೊ. ");
INSERT INTO kans_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ಅತ್ತಾ ತುಮಿ ಜಾವಾ ಅನಿ ಹಿ ಖಬರ್ ತೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಸಾಂಗಾ ಅನಿ ಪೆದ್ರುಕ್ಬಿ, ತೆನಿ ಅದ್ದಿಚ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ತೊ ತುಮ್ಚ್ಯಾನ್ಕಿ ಅದ್ದಿ ಗಾಲಿಲಿಯಾಕ್ ಜಾತಾ, ಥೈ ತೆಕಾ ತುಮಿ ಬಗ್ತ್ಯಾಸಿ”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ಖರೆ ತೆನಿ ಭಿವ್ನ್ ಥರ್ಥರುನ್ಗೆತ್ ಅನಿ ಅಜಾಪ್ ಹೊವ್ನ್ ಸಮಾದಿತ್ನಾ ಭಾಯ್ರ್ ಪಳುನ್ ಗೆಲ್ಯಾನಿ, ತೆನಿ ಕೊನಾಕ್ಬಿ ಕಾಯ್ಬಿ ಸಾಂಗುಕ್ನ್ಯಾತ್ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಭಿಂವ್ನ್ ಗೆಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ಜೆಜು ಮರಲ್ಲ್ಯಾನಿತ್ನಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್, ಮಟ್ಲ್ಯಾರ್ ಆಯ್ತಾರ್‍ಚೆ ನಸ್ಕಾತ್, ಸಗ್ಳ್ಯಾನಿಕಿ ಅದ್ದಿ ಮರಿ ಮಾಗ್ದೆಲಿನಾಕ್ ದಿಸ್ಲೊ. ಜೆಜುನ್ ತಿಚ್ಯಾ ಆಂಗಾತ್ನಾ ಸಾತ್ ಗಿರೆ ಕಾಡಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ತೆನಿ ಜಾವ್ನ್ ತೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಸಾಂಗ್ಲಿನ್, ತೆನಿ ಅಜುನ್ ದುಕ್ಕಾತ್ ಹೊತ್ತೆ ರಡುನ್ಗೆತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ಜೆಜು ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟ್ಲಾ ಅನಿ ಮಿಯಾ ತೆಕಾ ಬಗಟ್ಲಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾರ್ಬಿ ತೆನಿ ತಿಚೆರ್ ವಿಶ್ವಾಸ್ ಕರುಕ್ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ಮಾನಾ ಜೆಜು ದೊಗಾ ಜಾನಾ ಶಿಸಾಕ್ನಿ ತೆಂಚ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ವಾಟೆನ್ ಚಲುನ್ಗೆತ್ ಜಾತಾನಾ ತೆನಿ ಒಳಕ್ ಗಾಯಿನಸಲ್ಲ್ಯಾ ದುಸ್ರ್ಯಾಚ್ ರಿತಿನ್ ಜೆಜು ತೆಂಕಾ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ತೆನಿ ಪರ್ತುನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಹುರಲ್ಲ್ಯಾಕ್ನಿ ಸಾಂಗ್ಲ್ಯಾನಿ ಖರೆ ತೆಂಕಾ ವಿಶ್ವಾಸ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ಆಕ್ರಿಕ್ ಅಕ್ರಾ ಜಾನಾ ಶಿಸಾ ಜೆವ್ತಾನಾ ಜೆಜು ತೆಂಕಾ ದಿಸ್ಲೊ, ಅನಿ ತೆಂಕಾ ಜೊರ್ ಕರ್‍ಲ್ಯಾನ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಂಚ್ಯಾತ್ಲ್ಯಾನಿ ತೆಕಾ ಝಿತ್ತೊ ಹೊತ್ತೊ ಬಗಟಲ್ಲ್ಯಾನಿ, ಜಾಲ್ಯಾರ್‍ಬಿ ತೆಂಚಿ ಕಾಳ್ಜಾ ವಿಶ್ವಾಸ್ ಕರಿನಸ್ತಾನಾ ರಾವ್ಕ್ ಸರ್ಕಿ ಘಟ್ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ಮಾನಾ ಜೆಜುನ್ ತೆಂಕಾ “ಸಗ್ಳ್ಯಾ ದುನಿಯಾ ವರ್‍ತಿ ಜಾವಾ ಅನಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಬರಿ ಖಬರ್ ಸಾಂಗಾ, ");
INSERT INTO kans_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ಜೆ ಕೊನ್ ವಿಶ್ವಾಸ್ ಕರ್‍ತ್ಯಾತ್ ಅನಿ ಬಾಲ್ತಿಮ್ ಘೆತ್ಯಾತ್ ತೆನಿ ಬಚಾವ್ ಹೊತ್ಯಾತ್, ಅನಿ ಜೆ ಕೊನ್ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾತ್ ತೆಂಕಾ ಶಿಕ್ಷಾ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ಜೆ ಕೊನ್ ವಿಶ್ವಾಸಾತ್ ರ್‍ಹಾತ್ಯಾತ್ ತೆಂಕಾ ವಿಚಿತ್ರ್ ಕಾಮಾ ಕರ್‍ತಲಿ. ಅನಿ ಮಾಜ್ಯಾ ನಾವಾನ್ ಗಿರೆ ಕಾಡ್ತಲಿ ತಾಕತ್ ದಿವ್ನ್ ಹೊತಾ, ಅನಿ ತೆನಿ ನ್ಹವ್ಯಾಚ್ ಬಾಸಾನಿ ಬೊಲ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ತೆನಿ ಸಾಂಪ್ ಹಾತಿತ್ ಧರುನ್ ಘೆಟ್ಲ್ಯಾರ್ಬಿ ಕಸ್ಲೆ ವಿಸ್ ಫಿಲ್ಯಾರ್ಬಿ ತೆಂಕಾ ಕಾಯ್-ಕಾಯ್ ಹೊಯ್ನಾ, ತೆನಿ ಸಿಕ್ ಹೊತ್ತ್ಯಾಂಚ್ಯಾ ಆಂಗಾಕ್ ಅಪಡ್ಲ್ಯಾರ್ ತೆನಿ ಗುನ್ ಹೊತ್ಯಾತ್”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ಜೆಜು ತೆಂಕಾ ಅಶೆ ಹೆ ಸಗ್ಳೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ತೆಕಾ ಸರ್‍ಗಾ ವರ್‍ತಿ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊಲೆ ಅನಿ ತೊ ದೆವಾಚ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ಶಿಸಾನಿ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಜಾವ್ನ್ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನಿ ಅನಿ ದೆವಾನ್ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಕಾಮ್ ಕರುನ್ ಸುಮಾರ್ ವಿಚಿತ್ರಾ ಕರ್ತಲ್ಯಾಚ್ಯಾ ವೈನಾ ಹೆನಿ ಸಾಂಗ್ತಲಿ ಬರಿ ಖಬರ್ ಖರಿ ಹಾಯ್ ಮನುನ್ ದಾಕ್ವುನ್ ದಿಲ್ಯಾನ್.");
INSERT INTO kans_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ಪ್ರಿತಿಚ್ಯಾ ಥಿಯೊಫಿಲಸ್. ಲೈ ಲೊಕಾನಿ ಅಮ್ಚ್ಯಾ ಮದ್ದಿ ಹೊಲ್ಲಿ ಸಗ್ಳಿ ವಿಶಯಾ ಕವ್ಡೆ ಹೊತಾ ತವ್ಡೆ ಬರೆ ಕರುನ್ ಲಿವ್ಕ್ ಕಟ್ಪಟ್ಲ್ಯಾನಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ಹೆ ಸುರು ಹೊಲ್ಲ್ಯಾಕ್ನಾ ಡೊಳ್ಯಾನ್‍ ಡೊಳೊಬರ್ ಬಗಟಲ್ಲ್ಯಾನಿ ಅನಿ ಅಮ್ಕಾ ಬರಿ ಖಬರ್ ಸಾಂಗಲ್ಲ್ಯಾನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ತೆನಿ ಲಿವ್ಲ್ಯಾನಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ತೆಚೆಸಾಟ್ನಿ,ಸುರು ಹೊಲ್ಲ್ಯಾಕ್ನಾ ಮಿಯಾಬಿ ಬರೆ ಕರುನ್ ಹೆ ಶಿಕ್ಲೊ ಅನಿ ತುಜ್ಯಾಸಾಟಿ ಎಕಾಚ್ಯಾ ಫಾಟ್ನಾ ಎಕ್ ವಿಶಯ್ ಬರೆ ಕರುನ್ ಪುಸ್ತಕ್ ರುಪಾತ್ ಲಿವ್ನ್ ಥವ್ತಲೆ ಬರೆ,ಮನುನ್ ಮಾಕಾ ದಿಸ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ತುಕಾ ಶಿಕ್ವಲ್ಲೆ ಸಗ್ಳೆ ಖರೆ ಮನುನ್ ದಾಕ್ವುನ್ ದಿವ್‌ಸಾಟ್ನಿ ಮಿಯಾ ಹೆ ಸಗ್ಳೆ ಲಿವ್ನ್ ಥವ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ಹೆರೊದ್ ಮನ್ತಲೊ ಜುದೆಯಾ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾಚೊ ರಾಜಾ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ಕಾಲಾತ್, ಅಭಿಯಾ ಮನ್ತಲ್ಯಾ ಯಾಜಕಾಚ್ಯಾ ವರ್ಗಾಚೊ ಜೆಕರಿಯಾ ಮನ್ತಲೊ ಎಕ್ಲೊ ಯಾಜಕ್ ಹೊತ್ತೊ, ತೆಚ್ಯಾ ಬಾಯ್ಕೊಚೆ ನಾವ್ ಎಲಿಜಾಬೆತ್ ತಿ ಆರೊನಾಚ್ಯಾಚ್ ಘರಾನ್ಯಾಚಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ತೆನಿ ದೊಗೆಬಿ ದೆವಾಚ್ಯಾ ನದ್ರೆತ್ ಬರೆ ಹೊತ್ತೆ, ಅನಿ ಸರ್ವೆಸ್ವರ್ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಅನಿ ಖಾಯ್ದೆ ಬರೆ ಕರುನ್ ಪಾಳಿತ್, ತೆನಿ ಕಸ್ಲ್ಯಾಬಿ ಚುಕೆತ್ ನತ್ತ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ಖರೆ ತೆಂಕಾ ಪೊರಾ ನತ್ತಿ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಎಲಿಜಾಬೆತ್ ವಾಂಜ್ಡಿ ಹೊತ್ತಿ. ಎಲಿಜಾಬೆತ್ ಅನಿ ಜೆಕರಿಯಾ ಲೈ ಮ್ಹಾತಾರೆ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ಎಕ್ ದಿಸ್ ಅಪ್ನಾಚಿ ಪಾಳಿ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಕರಿಯಾ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಅಪ್ನಾಚೆ ಯಾಜಕಾಚೆ ಕಾಮ್ ಕರಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ಯಾಜಕಾಂಚ್ಯಾ ಪದ್ದತಿ ಸರ್ಕೆ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಧುಪ್ ಘಾಲುಕ್ ಮನುನ್ ಜೆಕರಿಯಾಕ್ ಚಿಟಿಯಾ ಘಾಲುನ್ ಎಚುನ್ ಕಾಡಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ಭುತ್ತುರ್ ಧುಪ್ ಘಾಲ್ತಾನಾ, ಭಾಯ್ರ್ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಮಾಗ್ನಿ ಕರುಂಗೆತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ತನ್ನಾ ಧುಪ್ ಜಾಳ್ವುತಲ್ಯಾ ಅಲ್ತಾರಿಚ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಎಕ್ ದೆವಾಚೊ ದುತ್ ಇಬೆ ಹೊತ್ತೊ ಜೆಕರಿಯಾಕ್ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ತೆಕಾ ಬಗಟಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಕರಿಯಾ ಎಗ್ದಮ್ ಘಾಬರ್‍ಲೊ ಅನಿ ಭಿಂವ್ನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ಖರೆ, ದೆವಾಚ್ಯಾ ದುತಾನ್ ಜೆಕರಿಯಾಕ್ “ಜೆಕರಿಯಾ ಭಿಂವ್‍ನಕ್ಕೊ! ದೆವಾನ್ ತುಜಿ ಮಾಗ್ನಿ ಆಯಿಕ್ಲ್ಯಾನಾಯ್. ತುಜಿ ಬಾಯ್ಕೊ ಎಲಿಜಾಬೆತ್ ಎಕ್ ಲೆಕಾಕ್ ಜಲಮ್ ದಿತಾ,ತುಮಿ ತೆಕಾ ಜುವಾಂವ್ ಮನುನ್ ನಾವ್ ಥವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ತೊ ಜಲಮಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮ್ಕಾ ಲೈ ಕುಶಿ ಹೊತಾ, ಅನಿ ದುಸ್ರ್ಯಾ ಕವ್ಡ್ಯಾಕಿ ಲೊಕಾಕ್ನಿ ಕವ್ಡಿಕಿ ಕುಶಿ ಹೊತಾ! ");
INSERT INTO kans_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ದೆವಾಚ್ಯಾ ನದ್ರೆತ್ ತೊ ಮೊಟೊ ಮಾನುಸ್ ಹೊತಾ, ಅನಿ ತೊ ವಾಯ್ನ್ ಹೊಂವ್ದಿ, ನಿಶಾ ಹೊತಲೆ ಕಾಯ್ಬಿ ಹೊಂವ್ದಿ ಫಿ ನಾ. ತೊ ಜಲ್ಮುಚ್ಯಾಕಿ ಅದ್ದಿತ್ನಾಚ್ ತೊ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರಲ್ಲೊ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಸುಮಾರ್ ಲೊಕಾಕ್ನಿ ತೊ ತೆಂಚ್ಯಾ ದೆವ್ ಸರ್ವೆಸ್ವರಾಕ್ಡೆ ಫಾಟಿ ಪರ್‍ತುನ್ ಹಾನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ತೊ ಧನ್ಯಾಚ್ಯಾ ಫಿಡೆ-ಫಿಡೆ ಜಾತಾ.ಎಲಿಯಾ ಪ್ರವಾದ್ಯಾಚೆ ಗುನ್ ಅನಿ ಬಳ್ ತೆಕಾ ರ್‍ಹಾತಾ. ಬಾಬಾಕ್ನಿ ಅನಿ ಪೊರಾಕ್ನಿ ತೊ ಅನಿಪರ್‍ತುನ್ ಎಕ್ ಕರ್‍ತಾ; ತೊ ದೆವಾಕ್ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಚಲಿನಸಲ್ಲ್ಯಾಕ್ನಿ ದೆವಾಚ್ಯಾ ವಾಟೆನ್ ಚಲಿ ಸರ್ಕೆ ಕರ್‍ತಾ; ದೆವಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ದೆವಾಸಾಟ್ನಿ ತಯಾರ್ ಕರ್‍ತಾ”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ಜೆಕರಿಯಾನ್ ದೆವಾಚ್ಯಾ ದುತಾಕ್ “ಹೆ ಸಗ್ಳೆ ಹೊತಲೆ ಖರೆ ಮನುನ್ ಮಿಯಾ ಕಶೆ ವಿಶ್ವಾಸ್ ಕರು? ಮಿಯಾ ಎಕ್ ಮ್ಹಾತಾರೊ ಮಾನುಸ್,ಅನಿ ಮಾಜಿ ಬಾಯ್ಕೊಬಿ ಮ್ಹಾತಾರಿ”, ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ತನ್ನಾ ದೆವಾಚ್ಯಾ ದುತಾನ್ “ದೆವಾಚ್ಯಾ ಇದ್ರಾಕ್ ರ್‍ಹಾತಲೊ ಘಾಬ್ರಿಯೆಲ್ ಮಿಯಾ, ತುಜೆಕ್ಡೆ ಬೊಲುಕ್ ಅನಿ ತುಕಾ ಹಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಮನುನ್ ದೆವಾನ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ಸಮಾ ಎಳಾಕ್ ಖರೆ ಹೊತಲ್ಯಾ, ಮಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಖಬ್ರೆರ್ ತಿಯಾ ವಿಶ್ವಾಸ್ ಕರುಕ್ನೆ, ಹೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ಸಾಂಗಲ್ಲಿ ಗೊಸ್ಟ್ ಖರಿ ಹೊಯ್‍ ಪತರ್ ತುಕಾ ಬೊಲುಕ್ ಹೊಯ್ನಾ; ತಿಯಾ ಮುಕ್ಕೊ ಹೊವ್ನ್ ರ್‍ಹಾತೆ”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ಹಿಕ್ಡಿ ಲೊಕಾ, ಜೆಕರಿಯಾಚಿ ವಾಟ್ ಬಗುನ್ಗೆತ್ ಹೊತ್ತಿ, ಅನಿ ಹ್ಯೊ ಎವ್ಡೊ ಲೈ ಎಳ್ ಭುತ್ತುರ್ ಕಶ್ಯಾಕ್ ರ್‍ಹಾಲೊ ಅಸಿಲ್! ಮನುನ್ ಅಜಾಪ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ಜೆಕರಿಯಾ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ನಾ ಭಾಯ್ರ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ಲೊಕಾಂಚ್ಯಾಕ್ಡೆ ಬೊಲುಕ್ ಹೊವುಕ್ನಾ, ಹಾತಾನಿ ಸೊನ್ನಿ ಕರುನ್ ತೆನಿ ದಾಕ್ವುಲ್ಯಾನ್ ತೆಕಾ ಬೊಲುಕುಚ್ ಹೊವ್ಕ್ ನಾ.ತನ್ನಾ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ತೆನಿ ದರ್ಶನ್ ಬಗಟ್ಲ್ಯಾನ್ ಮನುನ್ ಲೊಕಾಕ್ನಿ ಕಳ್ಳೆ. ");
INSERT INTO kans_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಕಾಮ್ ಕರ್‍ತಲಿ ಪಾಳಿ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಕರಿಯಾ ಅಪ್ನಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ಎಕ್ ಉಲ್ಲಿ ದಿಸಾ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಚಿ ಬಾಯ್ಕೊ ಎಲಿಜಾಬೆತ್ ಗರ್‍ವಾರ್ ಹೊಲಿ, ಪಾಚ್ ಮ್ಹಯಿನೆ ತಿ ಘರಾತ್ನಾ ಭಾಯ್ರ್ ಪಡುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ತನ್ನಾ ಎಲಿಜಾಬೆತಾನ್,“ಆಕ್ರಿಕ್ ಅತ್ತಾತರ್ ದೆವಾನ್ ಮಾಜೆಸಾಟಿ ಕವ್ಡೆ ಮೊಟೆ ಕಾಮ್ ಕರ್‍ಲ್ಯಾನ್, ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಹೊತ್ತೆ ಮಾಜೆ ಮಾಲ್ದಿಸಾವ್ ಕಾಡುನ್ ಟಾಕ್ಲ್ಯಾನ್” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ಎಲಿಜಾಬೆತ್ ಸಾ ಮ್ಹೈಯ್ನ್ಯಾಚಿ ಗರ್‍ವಾರ್‍ನಿ ಹೊತ್ತ್ಯಾ ತನ್ನಾ, ದೆವಾನ್ ಘಾಬ್ರಿಯೆಲ್ ದುತಾಕ್ ಗಾಲಿಲಿಯಾ ಪ್ರಾಂತ್ಯಾಚ್ಯಾ ನಜರೆತ್ ಮನ್ತಲ್ಯಾ ಮೊಟ್ಯಾ ಗಾವಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ಘಾಬ್ರಿಯೆಲ್ ದೆವಾಚೊ ದುತ್ ಮರಿ ಮನ್ತಲ್ಯಾ ಲಗಿನ್ ಹೊಯ್‍ ನಸಲ್ಲ್ಯಾ ಎಕಾ ಚೆಡ್ವಾಕ್ ಎಕ್ ಖಬರ್ ಘೆವ್ನ್ ಯಲ್ಲೊ. ತ್ಯಾ ಚೆಡ್ವಾಚಿ ದಾವಿದ್ ರಾಜಾಚ್ಯಾ ಘರಾನ್ಯಾಚ್ಯಾ ಜುಜೆ ಮನ್ತಲ್ಯಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಲಗ್ನಾಚಿ ಗೊಸ್ಟ್ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ದೆವಾಚೊ ದುತ್ ತಿಚೆಕ್ಡೆ ಯೆಲೊ ಅನಿ “ದೆವಾಚೆ ಸಮಾದಾನ್ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ರಾಂವ್ದಿತ್! ದೆವ್ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಯ್ ಅನಿ ದೆವಾನ್ ತುಕಾ ಆಶಿರ್ವಾದ್ ದಿಲ್ಯಾನಾಯ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ಹೆ ಆಯ್ಕುನ್ ಮರಿ ಘಾಬರ್‍ಲಿ ಅನಿ ಹ್ಯಾ ದೆವಾಚ್ಯಾ ದುತಾನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಖಬ್ರೆಚೊ ಅರ್ತ್‍ ಕಾಯ್ ಮನುನ್ ತಿ ಯವ್ಜುಕ್ ಪಡ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ಖರೆ ದೆವಾಚ್ಯಾ ದುತಾನ್ ತಿಕಾ, “ಮರಿ ಭಿಂವ್‍ನಕೊ; ದೆವಾಚಿ ಮೊಟಿ ಕುರ್ಪಾ ತುಜೆ ವರ್‍ತಿ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ತಿಯಾ ಗರ್‍ವಾರ್ ಹೊತೆಯ್, ಅನಿ ಎಕ್ ಝಿಲ್ಗ್ಯಾಕ್ ಜಲಮ್ ದಿತೆಯ್, ಅನಿ ತೆಕಾ ‘ಜೆಜು’ ಮನುನ್ ನಾವ್ ಥವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ತೊ ಮೊಟೊ ಮಾನುಸ್ ಹೊತಾ, ಅನಿ ತೆಕಾ ಪರಮೊನ್ನತ್ ದೆವಾಚೊ ಲೆಕ್ ಮನುನ್ ಬಲ್ವುತ್ಯಾತ್.ಅನಿ ಸರ್ವೆಸ್ವರ್ ದೆವ್ ತೆಕಾ ತೆಚ್ಯಾ ಘರಾನ್ಯಾಚ್ಯಾ ದಾವಿದ್ ರಾಜಾ ಸರ್ಕೊ ರಾಜಾ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ಅನಿ ತೊ ಜಾಕೊಬಾಚ್ಯಾ ಘರಾನ್ಯಾಚ್ಯಾ ಲೊಕಾಂಚೊ ರಾಜಾ ಹೊತಾ; ತೆಚೊ ರಾಜ್ ಕನ್ನಾಚ್ ಸರಿನಾ!” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ತನ್ನಾ ಮರಿನ್ “ಮಿಯಾ ಎಕ್ ನಗಿನ್ ಹೊಯ್ನಸಲ್ಲೆ ಚೆಡು,ಹೆ ಸಗ್ಳೆ ಕಶೆ ಹೊತಾ?” ಮನುನ್ ದೆವಾಚ್ಯಾ ದುತಾಕ್ ಇಚಾರ್‍ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ತನ್ನಾ ದೆವಾಚ್ಯಾ ದುತಾನ್ ಪವಿತ್ರ್ ಆತ್ಮೊ ತುಜೆ ವರ್‍ತಿ ಯೆತಾ ಅನಿ ದೆವಾಚೊ ಬಳ್ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾತಾ, ಹೆಚೆಸಾಟ್ನಿಚ್ ಹ್ಯಾ ಪವಿತ್ರ್ ಪೊರಾಕ್ ದೆವಾಚೊ ಲೆಕ್ ಮನುನ್ ಬಲ್ವುತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ತಿಯಾ ಯಾದ್ ಥವ್ನ್ ಘೆ, ಪೊರಾ ಹೊಯ್‍ನ್ಯಾತ್ ಮನುನ್ ಸಾಂಗಲ್ಲಿ ತುಮ್ಚಿ ಸಮಂದಿನ್ ಎಲಿಜಾಬೆತ್ ಮ್ಹಾತಾರಿ ಹೊಲ್ಯಾರ್ಬಿ, ಅತ್ತಾ ಸಾ ಮ್ಹೈಯ್ನ್ಯಾಚಿ ಗರ್‍ವಾರ್‍ನಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ದೆವಾಚ್ಯಾ ಹಾತಿನ್ ಹೊಯ್ನಾ ಮನ್ತಲೆ ಕಾಯ್ಬಿ ನಾ, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ತನ್ನಾ ಮರಿನ್ ಮಿಯಾ ಸರ್ವೆಸ್ವರಾಚಿ ದಾಸಿ, ತಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಮಾಕಾ ಹೊಂವ್ದಿ, ಮಟ್ಲಿನ್. ತನ್ನಾ ದೆವಾಚೊ ದುತ್ ತಿಕಾ ಸೊಡುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ಮರಿ ಗಡ್ಬಡಿನ್ ತಯಾರ್ ಹೊಲಿ, ಅನಿ ಜುದೆಯಾಚ್ಯಾ ಮಡ್ಡ್ಯಾಂಚ್ಯಾ ಎಕ್ ಶಾರಾಕ್ ಲುಗ್ಗುಲಗ್ಗುನಾ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ಥೈ ಜೆಕರಿಯಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲಿ, ಅನಿ ತೆನಿ ಎಲಿಜಾಬೆತಾಕ್ ನಮಸ್ಕಾರ್ ಕರ್‍ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ಮರಿಚ್ಯಾ ನಮಸ್ಕಾರಾಚೊ ಆವಾಜ್ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ, ಎಲಿಜಾಬೆತಿಚ್ಯಾ ಪೊಟಾತ್ಲ್ಯಾ ಪೊರಾನ್ ಹುಡಿ ಮಾರ್‍ಲ್ಯಾನ್, ತನ್ನಾ ಎಲಿಜಾಬೆತ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರಲ್ಲಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ಅನಿ ತೆನಿ ಮೊಟ್ಯಾನ್ “ಸಗ್ಳ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾಂಚ್ಯಾನ್ಕಿ ಜಾಸ್ತಿ ಆಶಿರ್ವಾದ್ ಗಾವಲ್ಲಿ ಬಾಯ್ಕೊಮನುಸ್ ತಿಯಾ, ಅನಿ ತುಜ್ಯಾ ಪೊಟಾನಿ ಜಲಮ್ತಲೊ ಪೊರ್‌ಬಿ ಲೈ ಮೊಟೊ ಆಶಿರ್ವಾದ್ ಗಾವಲ್ಲೊ! ");
INSERT INTO kans_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ಮಾಜ್ಯಾ ಮಾಲ್ಕಾಚಿ ಬಾಯ್ ಮಾಕಾ ಭೆಟುಕ್ ಯೆತಲೆ,ಹೆ ಎವ್ಡೆ ಮೊಟೆ ಘಡಿತ್ ಮಾಜೆ ವಾಂಗ್ಡಾ ಕಶೆ ಘಡುಕ್ ಹೊತಾ?” ");
INSERT INTO kans_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ತುಜ್ಯಾ ನಮಸ್ಕಾರಾಚೊ ಆವಾಜ್ ಕಾನಾತ್ ಪಡಲ್ಲ್ಯಾ ತನ್ನಾಚ್, ಮಾಜ್ಯಾ ಪೊಟಾತ್ಲ್ಯಾ ಪೊರಾನ್ ಕುಸಿನ್ ಹುಡಿ ಮಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ದೆವಾನ್ ದಿಲ್ಲಿ ಖಬರ್ ಖರಿ ಮನುನ್ ವಿಶ್ವಾಸ್ ಕರಲ್ಲಿ ತಿಯಾ ಕವ್ಡಿ ಧನ್ಯ್. ");
INSERT INTO kans_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ತನ್ನಾ ಮರಿ, ಮಾಜೆ ಕಾಳಿಜ್ ಮಾಲ್ಕಾಚಿ ಸ್ತುತಿ ಕರ್‍ತಾ; ");
INSERT INTO kans_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ಮಾಕಾ ಸುಟ್ಕಾ ದಿತಲ್ಯಾ ದೆವಾಕ್ ಲಾಗುನ್ ಮಾಜ್ಯಾ ಜಿವಾಕ್ ಲೈ ಕುಸಿ ಹೊವ್ಕ್ ಲಾಗ್ಲಾ, ");
INSERT INTO kans_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ತೆನಿ ಮಾಜಿ ಎಗ್ದಮ್ ಕಿಳ್ ಗುಲಾಮಾಚಿ ಯಾದ್ ಕರ್‍ಲ್ಯಾನ್! ಹೆಚೆನ್ ಫಿಡೆ ಸಗ್ಳಿ ಲೊಕಾ ಮಾಕಾ ಎಕ್ ಬರೆ ಭಾಗ್ ಗಾವಲ್ಲಿ ಮನುನ್ ಬಲ್ವುತ್ಯಾತ್, ");
INSERT INTO kans_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮೊಟ್ಯಾ ದೆವಾನ್ ಮಾಜೆಸಾಟಿ ಮೊಟಿ-ಮೊಟಿ ಕಾಮಾ ಕರ್‍ಲ್ಯಾನಾಯ್. ತೆಚೆ ನಾವ್ ಎಗ್ದಮ್ ಪವಿತ್ರ್ ಹಾಯ್; ");
INSERT INTO kans_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ಅಪ್ನಾಕ್ ಮರ್‍ಯಾದ್ ದಿತಲ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ಎಕ್ ಪಿಳ್ಗಿಕ್ನಾ ಅನಿ ಎಕ್ ಪಿಳ್ಗಿ ಪತರ್ ತೊ ದಯಾ ದಾಕ್ವುತಾ. ");
INSERT INTO kans_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ತೆನಿ ಅಪ್ನಾಚೊ ಲೈ ಮೊಟ್ಯಾ ತಾಕ್ತಿಚೊ ಬಾವ್ಳೊ ಫಿಡೆ ಕರ್‍ಲ್ಯಾನಾಯ್ ಅನಿ ಗರುಕಿನ್ ಹೊತ್ತ್ಯಾಂಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಯವ್ಜನ್ಯಾ ಹಾಳ್ ಕರುನ್ ಟಾಕ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ತೆನಿ ಮೊಟ್ಯಾ-ಮೊಟ್ಯಾ ರಾಜಾಕ್ನಿ ತೆಂಚ್ಯಾ ಕುರ್ಚಿ ವೈನಾ ಖಾಲ್ತಿ ಹಾನ್ಲ್ಯಾನ್, ಅನಿ ಎಗ್ದಮ್ ಕಿಳ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ವರ್‍ತಿ ಉಕಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ತೆನಿ ಭುಕೆನ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಬರಿ-ಬರಿ ಸಾಮಾನಾ ದಿಲ್ಯಾನ್, ಅನಿ ಸಾವ್ಕಾರಾಕ್ನಿ ಖಾಲಿ ಹಾತಾನಿ ಫಾಟಿ ಪರ್ತುನ್ ಧಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ಅಮ್ಚ್ಯಾ ಫಾಟ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ದಿಲ್ಲಿ ಗೊಸ್ಟ್ ತೆನಿ ರಾಕ್ಲ್ಯಾನ್, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಸೆವಕಾಕ್ ಇಸ್ರಾಯೆಲಾಕ್ ಮಜತ್ ಕರುಕ್ ಮನುನ್ ತೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ತೆನಿ ಅಬ್ರಾಹಾಮಾಚಿ ಯಾದ್ ಥವ್ನ್ ಘೆವ್ನ್ ದಯಾ ದಾಕ್ವುಲ್ಯಾನ್ ಅನಿ ತೆಚ್ಯಾ ಘರಾನ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಸದಾ ಸರ್ವತಾ ಪತರ್ ದಯಾ ದಾಕ್ವುಲ್ಯಾನ್! ");
INSERT INTO kans_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ಮರಿ ಜಗ್ಗೊಳ್ ತಿನ್ ಮ್ಹಯಿನೆ ಎಲಿಜಾಬೆತಿಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಲಿ, ಅನಿ ಮಾನಾ ಅಪ್ನಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ಎಲಿಜಾಬೆತಾನ್ ಪೊರಾಕ್ ಜಲಮ್ ದಿತಲೊ ಎಳ್ ಯೆಲೊ, ಅನಿ ತೆನಿ ಎಕ್ ಲೆಕಾಕ್ ಜಲಮ್ ದಿಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ತಿಚ್ಯಾ ಸೆಜಾರ್‍ಯಾನಿ ಅನಿ ಸೊಯ್ರ್ಯಾನಿ ಹಿ ಖಬರ್ ಆಯಿಕ್ಲ್ಯಾನಿ ಅನಿ ದೆವಾನ್ ತಿಚ್ಯಾ ಜಿವನಾತ್ ಕವ್ಡೆ ಮೊಟೆ ಕಾಮ್ ಕರ್‍ಲ್ಯಾನ್, ಮಟ್ಲ್ಯಾನಿ, ಅನಿ ತಿಚ್ಯಾ ವಾಂಗ್ಡಾ ತೆನಿಬಿ ಲೈ ಕುಶಿ ಹೊಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ಪೊರಾಕ್ ಆಟ್ ದಿಸ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ತೆನಿ ಸುನ್ನತ್ ಕರುಕ್ ಮನುನ್ ತೆಕಾ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ, ಅನಿ ಜೆಕರಿಯಾ ಮನುನ್ ತೆಚ್ಯಾ ಬಾಬಾಚೆಚ್ ನಾವ್ ತೆಕಾ ಥವ್ಚೆ, ಮನುನ್ ಯವಜಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ಖರೆ, ತೆಚ್ಯಾ ಬಾಯ್ನ್ “ನಕ್ಕೊ! ತೆಕಾ ಜುವಾಂವ್ ಮನುನ್ ನಾವ್ ಥವ್ಕ್ ಪಾಜೆ” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ಖರೆ ಲೊಕಾನಿ ತಿಕಾ “ತುಜ್ಯಾ ಸೊಯ್ರ್ಯಾತ್ನಿ ಹ್ಯಾ ನಾವಾಚೊ ಕೊನ್ಬಿ ನಾ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ತನ್ನಾ ತೆನಿ ತ್ಯಾ ಪೊರಾಂಚ್ಯಾ ಬಾಬಾಕ್ ಪೊರಾಕ್ ಕಾಯ್ ಮನುನ್ ನಾವ್ ಥವ್ಚೆ ಮನುನ್ ತಿಯಾ ಮನ್ತೆ ಮನುನ್ ಸೊನ್ನಿ ಕರುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ತನ್ನಾ ಜೆಕರಿಯಾನ್ ಎಕ್ ಫಳಿ ಇಚಾರ್‍ಲ್ಯಾನ್, ಅನಿ “ತೆಚೆ ನಾವ್ ಜುವಾಂವ್” ಮನುನ್ ಫಳಿ ವರ್‍ತಿ ಲಿವ್ಲ್ಯಾನ್, ತನ್ನಾ ತೆನಿ ಸಗ್ಳೆ ಜಾನಾ ಅಜಾಪ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ಅನಿ ತನ್ನಾಚ್ ಜೆಕಾರಿಯಾ ಬೊಲುಕ್‍ಲಾಲೊ ಅನಿ ದೆವಾಕ್ ಹೊಗ್ಳುಕ್‍ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ಹೆ ಆಯ್ಕಲ್ಲಿ ಅಜು ಬಾಜುಚಿ ಲೊಕಾ ಭಿಂಯಾನ್ ಭರ್‍ಲಿ,ಅನಿ ಹಿ ಖಬರ್ ಜುದೆಯಾಚ್ಯಾ ಮಡ್‍ಯಾಂಚ್ಯಾ ಜಾಗ್ಯಾರ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಫರ್ಗಟ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ಹಿ ಖಬರ್ ಆಯ್ಕಲ್ಲೆ ಸಗ್ಳೆ ಜಾನಾ “ಹ್ಯೊ ಪೊರ್ ಫಿಡೆ ಕಾಯ್ ಹೊತಾ ಅಸಿಲ್?” ಮನುನ್ ಇಚಾರುಕ್‍ಲಾಲೆ, ದೆವಾಚೊ ಬಳ್ ತ್ಯಾ ಪೊರಾ ವರ್‍ತಿ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ಜುವಾಂವಾಚೊ ಬಾಬಾ ಜೆಕರಿಯಾ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರ್‍ಲೊ, ಅನಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ದೆವಾಚಿ ಸರ್ವೆಸ್ವರಾಚಿ ಸ್ತುತಿ ಕರುವಾ! ತೊ ಅಪ್ನಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಆದಾರಾಕ್ ಯೆಲೊ, ಅನಿ ತೆಂಕಾ ಸ್ವತಂತ್ರ್ ಕರುಕ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಸೆವಕಾಚ್ಯಾ ದಾವಿದಾಚ್ಯಾ ಘರಾನ್ಯಾತ್ನಾ, ಅಮ್ಕಾ ಎಕ್ ಲೈ ಮೊಟೊ ಸುಟ್ಕಾ ದಿತಲೊ ಮಾನುಸ್ ದಿಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ಲೈ ವರ್ಸಾಂಚ್ಯಾ ಫಾಟಿಚ್ ಅಪ್ನಾಚ್ಯಾ ಪವಿತ್ರ್ ಪ್ರವಾದ್ಯಾಂಚ್ಯಾ ತೊಂಡಾನಿತ್ನಾ, ತೆನಿ ಗೊಸ್ಟ್ ದಿಲ್ಲ್ಯಾ ಸರ್ಕೆ ");
INSERT INTO kans_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ಅಮ್ಚ್ಯಾ ದುಸ್ಮಾನಾಂಚ್ಯಾ ಹಾತಿತ್ನಾ, ಅಮ್ಕಾ ತೆನಿ ರಾಕನ್ ಕರ್‍ಲ್ಯಾನ್ ಅನಿ ಅಮ್ಚೊ ದ್ವೆಸ್ ಕರ್‍ತಲ್ಯಾಂಚ್ಯಾ ಅದಿಕಾರಾತ್ನಾ ತೆನಿ ಅಮ್ಕಾ ಸೊಡ್ವುತಾ ಮನುನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ಅಮ್ಚ್ಯಾ ವಾಡ್ ವಡ್ಲಾಂಚ್ಯಾ ವರ್‍ತಿ ದಯಾ ದಾಕ್ವುತಾ, ಅನಿ ಅದ್ದಿ ಕರಲ್ಲ್ಯಾ ಪವಿತ್ರ್ ಕರಾರಾಚಿ ಯಾದ್ ಥವ್ನ್ ಘೆತಾ, ಮನುನ್ ಸಾಂಗಟಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ಅಮ್ಚ್ಯಾ ವಾಡ್ ವಡ್ಲಾ ಬಾಬಾ ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಕರಲ್ಲ್ಯಾ ಮನಾಕ್‍ ಲಾಗುನ್ ಕರಲ್ಲ್ಯಾ ಆನೆ ಸರ್ಕೆ, ");
INSERT INTO kans_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ತೆನಿ ಅಮ್ಕಾ ಅಮ್ಚ್ಯಾ ದುಸ್ಮಾನಾಂಚ್ಯಾ ಹಾತಾತ್ನಾ ಸೊಡ್ಸುತಾ ಮನುನ್ ಗೊಸ್ಟ್ ದಿಲ್ಲ್ಯಾನ್, ಅನಿ ಕಾಯ್ಬಿ ಭಿಂಯೆನಸ್ತಾನಾ ಅಪ್ನಾಚಿ ಸೆವಾ ಕರಿ ಸರ್ಕೆ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ಅಶೆ ಅಮಿ ಎಕ್ ಎಳಾರ್, ಅಮ್ಚ್ಯಾ ಸಗ್ಳೆ ಜಿವನ್‍ಬರ್ ತೆಚ್ಯಾ ಇದ್ರಾಕ್, ಪವಿತ್ರ್ ಅನಿ ಬರಿ ಕಾಮಾ ಕರ್‍ತಲಿ ಲೊಕಾ ಹೊವ್ನ್ ರಾವ್‍ಸಾಟ್ನಿ. ");
INSERT INTO kans_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“ಅನಿ ತುಕಾ, ಮಾಜ್ಯಾ ಪೊರಾ,ಮಹೊನ್ನತ್ ದೆವಾಚೊ ಪ್ರವಾದಿ ಮನುನ್ ಬಲ್ವುತ್ಯಾತ್. ಧನಿಯಾಚಿ ವಾಟ್ ತಯಾರ್ ಕರುಕ್, ತಿಯಾ ತೆಚ್ಯಾ ಫಿಡೆ-ಫಿಡೆ ಜಾತೆಯ್. ");
INSERT INTO kans_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ಅನಿ ತೆಚ್ಯಾ ಲೊಕಾಕ್ನಿ ತೆಂಚ್ಯಾ ಪಾಪಾನಿತ್ನಾ ಮಾಪ್ ಗಾವಲ್ಲ್ಯಾ ವೈನಾ, ಸುಟ್ಕೆಚಿ ಬುದ್ವಂತ್ಕಿ ದಿತಾ ಮನುನ್ ಸಾಂಗ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ಅಮ್ಚೊ ದೆವ್ ಕನ್ನಾಬಿ ದಯಾ ದಾಕ್ವುತಲೊ ಅನಿ ಸಗ್ಳೆ ದಿತಲೊ. ಅನಿ ತೊ ಅಮ್ಚ್ಯಾ ವರ್‍ತಿ ಸುಟ್ಕಾ ದಿತಲೊ ಮೊಟೊ ಉಜ್ವೊಡ್ ಫಾಕಿ ಸಾರ್ಕೊ ಕರ್‍ತಾ, ");
INSERT INTO kans_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ಅನಿ ಸರ್‍ಗಾ ವೈನಾ ಮರ್‍ನಾಚ್ಯಾ ಭಿಂಯಾತ್ ಅನಿ ದಾಟ್ ಕಾಳ್ಕಾತ್ ಜಿವನ್ ಕರ್‍ತಲ್ಯಾಂಚ್ಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ಉಜ್ವೊಡ್ ಘಾಲುಕ್, ಅನಿ ಅಮ್ಚಿ ಪಾವ್ಲಾ ಶಾಂತಿಚ್ಯಾ ವಾಟೆನ್ ಚಲ್ವುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್”. ");
INSERT INTO kans_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ತೊ ಪೊರ್ ಆಂಗಾನ್ ಅನಿ ಮನಾನ್ ಮೊಟೊ ಹೊಲೊ, ಅನಿ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ದಿಸಿ ಪತರ್ ಹಾಳ್ ಡಂಗ್ಳಿತುಚ್ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ಅಗಸ್ತುಸ್ ಕೈಸರಾಚ್ಯಾ ಕಾಲಾತ್ ಸಗ್ಳ್ಯಾ ರೊಮಾಚ್ಯಾ ರಾಜಾಚ್ಯಾ ಲೊಕಾಂಚಿ ಮೆಜ್ನಿ ಕರುಚಿ ಮನುನ್ ಹುಕುಮ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ಕ್ವಿರಿನಸ್ ಸಿರಿಯಾಚೊ ಮೊಟೊ ಅದಿಕಾರಿ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ಹೊಲ್ಲಿ ಪಯ್ಲಿಚಿ ಮೆಜ್ನಿ ಹಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ಅನಿ ಹರಿ ಎಕ್ಲೊ ಅಪ್ನಾ- ಅಪ್ನಾಚಿ ನಾವಾ ಲಿವುಕ್ ಮನುನ್ ಅಪ್ನಾ-ಅಪ್ನಾಚ್ಯಾ ಸ್ವಂತ್ ಗಾಂವಾಕ್ನಿ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ತೆಚೆಸಾಟ್ನಿ ಜುಜೆಬಿ ಗಾಲಿಲಿಯಾಚ್ಯಾ ನಜರೆತ್ ಮನ್ತಲ್ಯಾ ಗಾವಾತ್ನಾ, ದಾವಿದ್ ರಾಜಾಚ್ಯಾ ಉಪಾಜಲ್ಲ್ಯಾ ಗಾವಾಕ್, ಜುದೆಯಾಚ್ಯಾ ಬೆತ್ಲೆಹೆಮಾಕ್ ಗೆಲೊ.ತೊ ದಾವಿದಾಚ್ಯಾ ಘರಾನ್ಯಾಚೊ, ತಸೆ ಮನುನ್ ತೊ ಥೈ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಲಗ್ನಾಚಿ ಗೊಸ್ಟ್ ಹೊಲ್ಲ್ಯಾ ಮರಿಕ್‍ಬಿ ತೊ ವಾಂಗ್ಡಾ ಘೆವ್ನ್ ಗೆಲ್ಲೊ. ತನ್ನಾ ತಿ ಗರ್‍ವಾರ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ತೆನಿ ಬೆತ್ಲೆಹೆಮಾತ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ತೆನಿ ಪೊರಾಕ್ ಜಲಮ್ ದಿತಲೊ ಎಳ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ತಿನಿ ಅಪ್ನಾಚ್ಯಾ ಪಯ್ಲೆಚ್ಯಾ ಪೊರಾಕ್ ಜಲಮ್ ದಿಲಿನ್. ತೆಂಕಾ ರ್‍ಹಾವ್ಕ್ ಎಕ್ ಘರಾತ್ ಸೈತ್ ಜಾಗೊ ಗಾವುಕ್‍ನತ್ತೊ. ಮರಿನ್ ಪೊರಾಕ್ ಫಾಳಿಚ್ಯಾ ತುಕ್ಡ್ಯಾತ್ನಿ ಲಪ್ಟುನ್ ಗೊದ್ನಿತ್ ನಿಜ್ವುಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ಥೈ ಎಕಾಕ್ಡೆ ಉಲ್ಲಿ ಕುರ್‍ಬುರಾ ಶೆತಾತ್ನಿ ರಾಚ್ಚೆ ಅಪ್ನಾಚ್ಯಾ ಬಕ್ರ್ಯಾಂಚ್ಯಾ ಹಿಂಡ್ಡಾಕ್ನಿ ರಾಕುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ತೆಂಕಾ ಎಕ್ ದೆವಾಚೊ ದುತ್ ದಿಸ್ಲೊ. ದೆವಾಚೊ ಉಜ್ವೊಡ್ ತೆಂಚ್ಯಾ ಭೊತ್ಯಾನಿ ಫಾಕ್ಲೊ. ಕುರ್‍ಬುರಾ ಲೈ ಭಿಂಯಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ಖರೆ ದೆವಾಚ್ಯಾ ದುತಾನ್ “ಭಿಂವ್‌ನಕಾಶಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಖುಶಿ ಹಾನ್ತಲಿ ಬರಿ ಖಬರ್ ಮಿಯಾ ತುಮ್ಕಾ ಘೆವ್ನ್ ಯೆಲಾ”. ");
INSERT INTO kans_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","“ದಾವಿದಾಚ್ಯಾ ಶಾರಾತ್ ಆಜ್ ತುಮ್ಕಾ ಸುಟ್ಕಾ ದಿತಲೊ ಧನಿ, ಕ್ರಿಸ್ತ್ ಜಲಮ್ಲಾ”. ");
INSERT INTO kans_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ಫಾಳಿಯಾತ್ನಿ ಲಪ್ವುನ್ ಗೊದ್ನಿತ್ ನಿಜ್ವಲ್ಲೊ ಎಕ್ ಪೊರ್ ತುಮ್ಕಾ ಗಾವ್ತಾ. ಹಿ ತುಮ್ಕಾ ಎಕ್ ವಳಕ್. ");
INSERT INTO kans_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ಎಗ್ದಮ್, ಸರ್‍ಗಾ ವೈಲ್ಯಾ ದೆವಾಚ್ಯಾ ದುತಾಂಚೊ ತಾಂಡೊ “ದೆವಾಕ್ ಆರಾದನ್” ಕರುಕ್ ಮನುನ್ ಗಿತ್ ಮನ್ತಲೊ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ಎಗ್ದಮ್ ವೈಲ್ಯಾ ಸರ್‍ಗಾತ್ ದೆವಾಕ್ ಮಹಿಮಾ ಹೊಂವ್ದಿ, ಅನಿ ಹ್ಯಾ ಜಿಮ್ನಿರ್ ತೆನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಜಿವನ್ ಕರ್‍ತಲ್ಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಅಸಲ್ಲ್ಯಾಕ್ನಿ ಶಾಂತಿ ಹೊಂವ್ದಿ”. ");
INSERT INTO kans_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ದೆವಾಚಿ ದುತಾ ಸರ್‍ಗಾರ್ ಪರ್ತುನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ತಿ ಕುರ್‍ಬುರಾ ಎಕಾಮೆಕಾಕ್ನಿ “ಚಲಾ ಬೆತ್ಲೆಹೆಮಾಕ್ ಜಾಂವಾ ಅನಿ ದೆವಾನ್ ಅಮ್ಕಾ ಸಾಂಗಲ್ಲೆ ಬಗುನ್ ಯೆವಾ” ಮನುನ್ ಬೊಲುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ತೆನಿ ಗಡ್ಬಡಿನ್ ಥೈ ಗೆಲ್ಯಾನಿ ಅನಿ ಮರಿಕ್,ಜುಜೆಕ್ ಅನಿ ಗೊದ್ನಿತ್ ನಿಜವಲ್ಲ್ಯಾ ಬಾಳ್ಶ್ಯಾಕ್ ಬಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ತೆನಿ ಬಗಟಲ್ಲ್ಯಾ ತನ್ನಾ ದೆವಾಚ್ಯಾ ದುತಾನ್ ಪೊರಾಂಚ್ಯಾ ವಿಶಯಾತ್ ತೆಂಕಾ ಕಾಯ್-ಕಾಯ್ ಸಾಂಗಟಲ್ಲೆ ತೆಂಕಾ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ಕುರ್ಬುರಾನಿ ಸಾಂಗಟಲ್ಲೆ ಆಯ್ಕುನ್ ತೆನಿ ಅಜಾಪ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ಮರಿನ್ ಹೆ ಸಗ್ಳೆ ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ ಥವ್ನ್ ಘೆವ್ನ್ ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಬರೆ ಕರುನ್ ಯವಜ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ಗಿತಾ ಗಾವುನ್ಗೆತ್ ದೆವಾಕ್ ಹೊಗ್ಳುನ್ಗೆತ್ ಕುರ್‍ಬುರಾ ಫಾಟಿ ಪರ್‍ತುನ್ ಗೆಲಿ. ತೆನಿ ಆಯ್ಕಲ್ಲ್ಯಾಸರ್ಕೆ ಅನಿ ದೆವಾಚ್ಯಾ ದುತಾನ್ ಸಾಂಗಟಲ್ಲ್ಯಾ ಸಾರ್ಕೆಚ್ ತೆಂಕಾ ಬಗುಕ್ ಗಾವ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ಆಟ್ವ್ಯಾ ದಿಸಿ ಪೊರಾಕ್ ಸುನ್ನತ್ ಕರ್‍ತಲ್ಯಾ ಎಳಾರ್, ತೆಕಾ “ಜೆಜು” ಮನುನ್ ನಾವ್ ಥವ್ಲ್ಯಾನಿ. ಮರಿ ಗರ್‍ವಾರ್ ಹೊವ್ಚ್ಯಾ ಅದ್ದಿಚ್ ದೆವಾಚ್ಯಾ ದುತಾನ್ ಹೆ ನಾವ್ ತೆಕಾ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಸರ್ಕೆ ಅಪ್ನಾಚಿ ಪದ್ದತ್ ಪಾಳುಕ್ ಮನುನ್ ನಿತಳ್ ಹೊತಲೊ ಎಳ್ ಯೆಲ್ಲ್ಯಾತನ್ನಾ ಜುಜೆ, ಅನಿ ಮರಿ ಪೊರಾಕ್ ದೆವಾಕ್ ಭೆಟ್ವುಕ್ ಮನುನ್ ಜೆರುಜಲೆಮಾಚ್ಯಾ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಗೆಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸರ್ವೆಸ್ವರಾಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ“ಪಯ್ಲೆ ಜಲಮಲ್ಲೊ ಝಿಲ್ಗೊ ದೆವಾಕ್ ಎಕ್ ಪವಿತ್ರ್ ಮನುನ್ ಭೆಟ್ವುಚೆ” ಮನುನ್ ಲಿವಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ದೆವಾಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಸರ್ಕೆ, ಎಕ್ ಜೊಡಿ ಪಾರಿವಾಳಾ ನಾ ತರ್ ದೊನ್ ಕೊವ್ಡ್ಯಾಚಿ ಪಿಲ್ಲಾ, ತೆನಿ ದೆವಾಕ್ ಬಲಿ ಕರುನ್ ದಿತಲಿ ಹೊತ್ತಿ, ತೆ ಬಿ ಕರುನ್ ಯವ್ಕ್ ಮನುನ್ ತೆನಿ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ತ್ಯಾ ಕಾಲಾತ್ ಸಿಮಾವ್ ಮನ್ತಲೊ ಎಕ್ ಮಾನುಸ್ ಜೆರುಜಲೆಮಾತ್ ಹೊತ್ತೊ.ತೊ ಎಕ್ ಬರೊ ಅನಿ ದೆವಾಚ್ಯಾ ಭಿಂಯಾನ್ ಚಲ್ತಲೊ ಮಾನುಸ್,ತೊ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಸುಟ್ಕಾ ಹೊತಲ್ಯಾ ಎಳಾಕ್ ರಾಕುನ್ಗೆತ್ ಹೊತ್ತೊ. ಪವಿತ್ರ್ ಆತ್ಮೊ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ಅನಿ ಸರ್ವೆಸ್ವರಾನ್ ಧಾಡ್ತಾ ಮನುನ್ ಗೊಸ್ಟ್ ದಿಲ್ಲ್ಯಾ ಮೆಸ್ಸಿಯಾಕ್ ಬಗಟ್ಲ್ಯಾ ಸಿವಾಯ್ ತಿಯಾ ಮರಿನೆ ಮನುನ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ತೆಕಾ ಸಾಂಗಟಲ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ಖಾಯ್ದ್ಯಾತ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಪೊರಾಕ್ ದೆವಾಕ್ ಭೆಟ್ವುಕ್ ಮನುನ್, ತೆಚೆ ಬಾಯ್-ಬಾಬಾ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಭೆಟ್ವುಕ್ ಜೆಜುಕ್ ಘೆವ್ನ್ ಯೆಲ್ಲ್ಯಾನಿ. ತನ್ನಾಚ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚ್ಯಾ ಬಳಾನ್ ಸಿಮಿಯಾವ್ ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ಡೆ ಯೆಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ಸಿಮಿಯಾವಾನ್ ಪೊರಾಕ್ ಅಪ್ನಾಚ್ಯಾ ಹಾತಿತ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನ್: ");
INSERT INTO kans_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ಸರ್ವೆಸ್ವರಾ ಅತ್ತಾ ತುಜ್ಯಾ ಸೆವಕಾಕ್ ಸಮಾದಾನಾನ್ ಜಾವ್ಕ್ ಸೊಡ್. ತಿಯಾ ಸಾಂಗಟಲ್ಲಿ ಗೊಸ್ಟ್ ತಿಯಾ ಖರಿ ಕರ್‍ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ತಿಯಾ ತಯಾರ್ ಕರಲ್ಲಿ, ಸುಟ್ಕಾ ಮಾಜ್ಯಾಚ್ ಡೊಳ್ಯಾನಿ ಬಗಟ್ಲೊ: ");
INSERT INTO kans_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ತೆ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ತಿಯಾ ತಯಾರ್ ಕರ್‍ಲೆಯ್. ");
INSERT INTO kans_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ತೊ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ತುಜಿ ಕುಶಿ ಕಾಯ್ ಮನುನ್ ದಾಕ್ವುತಲೊ ಉಜ್ವೊಡ್ ಅನಿ ತುಜ್ಯಾ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ತೊ ಮಹಿಮಾ ಹಾನ್ತಾ”. ತೆಚ್ಯಾ ಸಾಟ್ನಿ, ");
INSERT INTO kans_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ಸಿಮಾವ್ ಪೊರಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಹೆ ಸಗ್ಳೆ ಸಾಂಗ್ತಲೆ ಬಗುನ್, ಪೊರಾಚೆ ಬಾಯ್ ಬಾಬಾ ಅಜಾಪ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ಸಿಮಾವಾನ್ ತೆಂಕಾ ಆಶಿರ್ವಾದ್ ದಿಲ್ಯಾನ್‍, ಅನಿ ಮರಿಕ್, ಹ್ಯೊ ಪೊರ್ ದೆವಾನ್ ಧಾಡಲ್ಲಿ ಎಕ್ ವಳಕ್ ಹೊತಾ ಇಸ್ರಾಯೆಲಾತ್ಲ್ಯಾ ಸುಮಾರ್ ಲೊಕಾಕ್ನಿ ಪಡುಕ್ ಅನಿ ಉಟುಕ್, ಕಾರನ್ ಹೊತಾ. ಖರೆ ಸುಮಾರ್ ಲೊಕಾ ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಹುರ್‍ಪಾಟಿ ಬೊಲ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ಅನಿ ತೊ ತೆಂಚ್ಯಾ ನಿಪುನ್ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಯವ್ಜನ್ಯಾ ಭಾಯ್ರ್ ಉಜ್ಟೊಡಾಕ್ ಹಾನ್ತಾ, ಅನಿ ದುಕ್, ಎಕ್ ಧಾರ್‍ಲ್ಯಾ ಚಾಕ್ವಾ ಸರ್ಕೆ ತುಜ್ಯಾ ಕಾಳ್ಜಾಕ್ ಟೊಪ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ಅನ್ನಾ ಮನುನ್ ನಾವ್ ಹೊತ್ತಿ ಎಕ್ ಪ್ರವಾದಿನ್‍ಬಿ ಥೈ ಹೊತ್ತಿ. ತಿ ಫಾನುಯೆಲಾಚಿ ಲೆಕ್ ಅಶೆರ್ ಮನ್ತಲ್ಯಾ ಘರಾನ್ಯಾಚಿ. ತಿ ನಗಿನ್ ಹೊವ್ನ್ ಸಾತ್ ವರ್ಸಾ ಅಪ್ನಾಚ್ಯಾ ಘೊವಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ. ಅನಿ ತಿ ಲೈ ಮ್ಹಾತಾರಿ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ಅತ್ತಾ ತಿ ಆಂಯ್ಸಿರ್ ಚಾರ್ ವರ್ಸಾಚಿ ವಿಧವ್. ದಿಸ್ ಅನಿ ರಾತ್ ದೆವಾಚಿ ಭಜನ್ ಕರುನ್ಗೆತ್ ಉಪಾಸ್, ಮಾಗ್ನಿ ಕರುನ್ಗೆತ್ ತಿ ದೆವಾಚ್ಯಾ ಗುಡಿತುಚ್ ರ್‍ಹಾಯ್. ದೆವಾಚಿ ಗುಡಿ ಸೊಡುನ್ ತಿ ಕಡೆಕ್ ಜಾಯ್ನಸಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ತ್ಯಾ ಎಳಾರ್ ತಿ ಪೊರಾಂಚ್ಯಾ ಬಾಯ್ ಬಾಬಾಕ್ಡೆ ಯೆಲಿ, ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲಿನ್, ಅನಿ ಜೆರುಜಲೆಮಾಚ್ಯಾ ಸುಟ್ಕೆಚಿ ವಾಟ್ ಬಗುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾಂಚ್ಯಾಕ್ಡೆ, ತೆನಿ ಹ್ಯಾ ಪೊರಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ಖಾಯ್ದ್ಯಾತ್ ಸಾಂಗಲ್ಲೆ ಸಾರ್ಕೆ. ಸಗ್ಳೆ ಶಾಸ್ತರ್ ಕರುನ್ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ, ಮರಿ ಅನಿ ಜುಜೆ ಅಪ್ನಾಚ್ಯಾ ಸ್ವಂತ್ ಗಾವಾಕ್ ಗಾಲಿಲಿಯಾತ್ಲ್ಯಾ ನಜರೆತಾಕ್ ಪರ್ತುನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ಪೊರ್ ಮೊಟೊ ಹೊವ್ನ್ ಘಟ್-ಮುಟ್ ಹೊಲೊ, ಅನಿ ಬುದ್ದಿನ್ಬಿ ಬರೊ ಹೊಲೊ. ದೆವಾಚಿ ಕುರ್ಪಾ ತೆಚ್ಯಾ ವರ್‍ತಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ಹರಿಎಕ್ ವರ್ಸಾ ಜೆಜುಚೆ ಬಾಯ್-ಬಾಬಾ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಕ್ ಮನುನ್ ಜೆರುಜಲೆಮಾಕ್ ಜಾಯ್ತ್. ");
INSERT INTO kans_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ಜೆಜು ಬಾರಾ ವರ್ಸಾಚೊ ಹೊತ್ತೊ ತನ್ನಾ, ಸದ್ದಿಚ್ಯಾ ಸರ್ಕೆ ತೆನಿ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಕ್ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ಸನ್ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಪರ್ತುನ್ ಘರಾಕ್ ಗೆಲ್ಯಾನಿ, ಖರೆ ಪೊರ್ ಜೆಜು ಜೆರುಜಲೆಮಾತುಚ್ ರ್‍ಹಾಲೊ, ಹೆ ತೆಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ ಕಳುಕುಚ್ ನತ್ತೆ . ");
INSERT INTO kans_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಗಾವಾಕ್ ಯೆತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆವ್ಲಾ ಕಾಯ್ಕಿ ಮನುನ್ ಯವ್ಜುನ್, ಎಕ್ ದಿಸಾಚಿ ವಾಟ್ ಚಲುನ್ ಗೆಲ್ಲ್ಯಾ ಮಾನಾ, ತೆನಿ ತೆಂಚ್ಯಾ ಸೊಯ್ರ್ಯಾತ್ನಿ ಅನಿ ವಳ್ಕಿಚ್ಯಾತ್ನಿ ಜೆಜುಕ್ ಹುಡಕ್ಲ್ಯಾನಿ . ");
INSERT INTO kans_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ಖರೆ ತೊ ತೆಂಕಾ ಗಾವುಕ್ನಾ, ತಸೆ ಮನುನ್ ತೆನಿ ಜೆಜುಕ್ ಹುಡ್ಕುನ್ಗೆತ್, ಅನಿ ಪರ್ತುನ್ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ತಿನ್ವ್ಯಾ ದಿಸಿ ಜುದೆವಾಂಚ್ಯಾ ಮಾಸ್ತರಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲುನ್ಗೆತ್ ಅನಿ ತೆಂಕಾ ಪರಸ್ನೆ ಇಚಾರುಂಗೆತ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಬಸಲ್ಲೊ, ತೆಂಕಾ ಗಾವ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ತೊ ಉಶಾರ್ಕಿನ್ ಜಬಾಬ್ ದಿತಲೆ ಬಗುನ್, ಆಯ್ಕಲ್ಲೆ ಸಗ್ಳೆಜಾನ್ ಅಜಾಪ್ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ತೆಕಾ ಬಗುನ್ ತೆಚೆ ಬಾಯ್ ಬಾಬಾ ಅಜಾಪ್ ಹೊಲ್ಯಾನಿ, ಅನಿ ತೆಚ್ಯಾ ಬಾಯ್ನ್ ತೆಕಾ “ಮಾಜ್ಯಾ ಪೊರಾ, ತಿಯಾ ಅಮ್ಕಾ ಅಶೆ ಕಶ್ಯಾಕ್ ಕರ್‍ಲೆ? ತುಕಾ ಹುಡ್ಕುಕ್, ಮಿಯಾ ಅನಿ ತುಮ್ಚೊ ಬಾಬಾ ಕವ್ಡೊ ತರಾಸ್ ಕರುನ್ ಘೆಟ್ಲಾಂವ್ ಗೊತ್ತ್ ಹಾಯ್?” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ತನ್ನಾ ತೆನಿ “ತುಮಿ ಮಾಕಾ ಕಶ್ಯಾಕ್ ಹುಡ್ಕುಕ್ ಲಾಗಲ್ಲ್ಯಾಶಿ? ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ಘರಾತ್ ರಾವ್ಕ್ ಪಾಜೆ ಮನುನ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ನಾ ಕಾಯ್?” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ಖರೆ ತೆನಿ ದಿಲ್ಲ್ಯಾ ಜಬಾಬಾಚೊ ತೆಂಕಾ ಅರ್‍ತುಚ್ ಹೊವುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ಅಶೆ ಜೆಜು ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ನಜರೆತಾಕ್ ಗೆಲೊ. ತೊ ತೆಂಕಾ ಖಾಲ್ತಿ ಹೊವ್ನ್ ರ್‍ಹಾಲೊ.ತೆಚ್ಯಾ ಬಾಯ್ನ್ ಹೆ ಸಗ್ಳೆ ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ ಗೊಳಾ ಕರುನ್ ಥವ್ನ್ ಘೆಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ದೆವಾಚ್ಯಾ ಅನಿ ಲೊಕಾಂಚ್ಯಾ ದಯೆನ್ ಜೆಜು ಆಂಗಾನ್ ಅನಿ ಬುದ್ದಿನ್ ಮೊಟೊ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ತಿಬೆರಿಯಸ್ ಕೈಸಾರ್ಯಾಚ್ ಮನ್ತಲ್ಯಾ ಚಕ್ರವರ್ತಿಚ್ಯಾ ಪಂದ್ರಾವ್ಯಾ ವರ್ಸಾತ್, ಪೊನಿತುಸಿ ಪಿಲಾತ್ ಮನ್ತಲೊ ಜುದೆಯಾಚೊ ಮೊಟೊ ಅದಿಕಾರಿ ಹೊತ್ತೊ,ಹೆರೊದ್ ಮನ್ತಲೊ ಗಾಲಿಲಿಯಾಚೊ ಅದಿಕಾರ್ ಚಾಲ್ವುತಲೊ ಹೊತ್ತೊ,ಅನಿ ತೆಚೊ ಭಾವ್ ಫಿಲಿಪ್, ಇತುರೆ, ಅನಿ ತ್ರಿಕೊನಿತಿಸ್ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾಂಚೊ ಅದಿಕಾರಿ ಅನಿ ಅಬಿಲೆನೆ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಲುಸಾನಿ ಮನ್ತಲೊ ಅದಿಕಾರಿ ಹೊತ್ತೊ, ");
INSERT INTO kans_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ಅನ್ನಾಸ್ ಅನಿ ಕಾಯಿಫಾಸ್ ಮನ್ತಲೆ ತನ್ನಾ ಮೊಟೆ ಯಾಜಕ್ ಹೊವ್ನ್ ಹೊತ್ತೆ. ಹ್ಯಾ ಎಳಾರ್ ಎಕ್ ಹಾಳ್ ಪಡಲ್ಲ್ಯಾ ಡಂಗ್ಳಿತ್ ಜೆಕರಿಯಾಚ್ಯಾ ಲೆಕಾಕ್, ಜುವಾಂವಾಕ್, ಎಕ್ ದೆವಾಚಿ ಗೊಸ್ಟ್ ಗಾವ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ತೆಚೆಸಾಟ್ನಿ ಜುವಾಂವ್ ಜೊರ್ದಾನ್ ನ್ಹಯ್ಚ್ಯಾ ಭೊತ್ಯಾನ್ಲ್ಯಾ ಜಾಗ್ಯಾರ್, “ತುಮ್ಚೆ ಪಾಪಾಚೆ ಜಿವನ್ ಬದ್ಲಾ, ಅನಿ ಬಾಲ್ತಿಮ್ ಘೆವಾ, ಅನಿ ದೆವ್ ತುಮ್ಚಿ ಪಾಪಾ ಮಾಪ್ ಕರ್‍ತಾ” ಮನುನ್ ಸಾಂಗುನ್ಗೆತ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾಚ್ಯಾ ಪುಸ್ತಕಾತ್: “ಡಂಗ್ಳಿತ್ ಎಕ್ಲೊ ಬೊಬ್ ಮಾರ್‍ತಾ, ಧನಿಯಾಸಾಟ್ನಿ ವಾಟ್ ತಯಾರ್ ಕರುನ್ ಥವಾ” “ತೆಕಾ ಯೆವ್ಕ್ ಎಕ್ ನಿಟ್ ವಾಟ್ ತಯಾರ್ ಕರಾ” ");
INSERT INTO kans_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ಸಗ್ಳೆ ಖಡ್ಡೆ ಭರುಕ್ ಪಾಜೆ, ಸಗ್ಳ್ಯಾ ಮೊಟ್ಯಾ ಬಾರಿಕ್ ಮಡ್ಡಿಯಾ ಸಪಾಟ್ ಹೊಂವ್ದಿ: ವಾಕ್ಡಿತಿಕ್ಡಿ ಹೊತ್ತಿ ವಾಟ್ ನಿಟ್ ಹೊತಾ. ಅನಿ ಖರ್ಬಾಡಿ ವಾಟ್ ಶಾಪೊಳ್ ಹೊತಾ; ");
INSERT INTO kans_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","“ಸಗ್ಳಿ ಮಾನುಸ್ ಜಾತ್ ದೆವಾಚಿ ಸುಟ್ಕಾ ಬಗ್ತಾ: ಮನುನ್ ಲಿವಲ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊಲೆ”. ");
INSERT INTO kans_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ತಾಂಡ್ಯಾನಿ ಲೊಕಾ ಜುವಾಂವಾಕ್ಡೆ ಯೆಲಿ, ಅನಿ ತೆನಿ ತೆಂಕಾ ಬಾಲ್ತಿಮ್ ದಿಲ್ಯಾನ್. ಜುವಾಂವಾಕ್ ತೆಂಕಾ “ತುಮಿ ಕುಸ್ಡ್ಯಾಸಾಪಾಚ್ಯಾ ಪಿಳ್ಗಿ ಸಾರ್‍ಕೆ ಹಾಸಿ! ದೆವಾನ್ ದಿತಲ್ಯಾ ಶಿಕ್ಷಾತ್ನಾ ಚುಕ್ವುನ್ ಘೆವ್ಕ್ ಹೊತಾ, ಮನುನ್ ತುಮ್ಕಾ ಕೊನ್ ಉಶಾರ್ಕಿ ದಿಲಿ?” ");
INSERT INTO kans_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ತುಮಿ ತುಮ್ಚ್ಯಾ ಪಾಪಾನಿತ್ನಾ, ಬರ್‍ಯಾ ವಾಟೆಕ್ ಪರತ್ಲ್ಯಾಶಿ, ಮನುನ್ ದಾಕ್ವುನ್ ದಿತಲಿ ಕಾಮಾ ಕರಾ, ಅನಿ ತುಮ್ಚ್ಯಾ-ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಅಮ್ಚೊ ಅದ್ಲೊ ಬಾಬಾ ಅಬ್ರಾಹಾಮ್ ಹಾಯ್, ಮನುನ್ ಸಾಂಗುಕ್ ಜಾವ್‍ನಕಾಶಿ. ಅಬ್ರಾಹಾಮಾಕ್ ಹ್ಯಾ ಗುಂಡ್ಯಾನಿತ್ನಾ ಸೈತ್ ಪಿಳ್ಗಿ ಕರುನ್ ದಿವ್ಕ್ ದೆವಾಕ್ ಹೊತಾ? ");
INSERT INTO kans_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ಝಾಡಾ ಮುಳಾತ್ನಾಚ್ ತೊಡುಕ್ ಮನುನ್ ಕುರಾಡ್ ತಯಾರ್ ಕರುನ್ ಥವ್ನ್ ಹೊಲ್ಲಿ ಹಾಯ್,ಬರಿ ಫಳಾ ದಿ ನಸಲ್ಲಿ ಸಗ್ಳಿ ಝಾಡಾ ತೊಡುನ್ ಆಗಿತ್ ಟಾಕುನ್ ಹೊತ್ಯಾತ್, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ತನ್ನಾ ಲೊಕಾನಿ ಜುವಾಂವಾಕ್ “ತರ್, ಅತ್ತಾ ಅಮಿ ಕಾಯ್ ಕರ್‍ತಲೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ತೆನಿ ತೆಂಕಾ “ಕೊನಾಕ್ಡೆ ದೊನ್ ಅಂಗಿಯಾ ಹಾತ್, ತೊ ಕಾಯ್ಬಿನಸಲ್ಲ್ಯಾಕ್ ಎಕ್ ಅಂಗಿ ದಿಂವ್ದಿ, ಅನಿ ಕೊನಾಕ್ಡೆ ಜೆವ್ಕ್ ಹಾಯ್, ತೊ ವಾಟುನ್ ಘೆವ್ನ್ ಖಾಂವ್ದಿ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ಉಲ್ಲೆ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲೆಬಿ ಬಾಲ್ತಿಮ್ ಘೆವ್ಕ್ ಯೆಲ್ಲೆ, ಅನಿ “ಗುರುಜಿ: ಅಮಿ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ತೆಂಕಾ ಜುವಾಂವಾಕ್ “ಕವ್ಡೆ ವಸುಲ್ ಕರ್‍ತಲೆ ಹಾಯ್,ತೆಚೆನ್ ಜಾಸ್ತಿಚೆ ವಸುಲ್ ಕರುನಕಾಶಿ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ಉಲ್ಲಿ ಸೈನಿಕಾಬಿ ಯೆಲಿ ಅನಿ “ಅಮ್ಚ್ಯಾ ವಿಶಯಾತ್ ಕಾಯ್ ಮನ್ತೆ? ಅಮಿ ಕಾಯ್ ಕರುಚೆ”, ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತೆನಿ ತೆಂಕಾ “ಒತ್ತಾಯ್ ಕರುನ್ ಧಮ್ಕಿ ದಿವ್ನ್ ಕೊನಾಕ್ನಾಬಿ ಪೈಸೆ ಕಾಡುನ್ ಘೆವ್‍ನಕಾಶಿ, ನಾಹೊಲ್ಯಾರ್ ಕೊನಾ ವರ್‍ತಿಬಿ ಝುಟೆ ಅಪ್ವಾದ್ ಘಾಲುನಕಾಶಿ,ತುಮ್ಕಾ ಕವ್ಡೊ ಪಗಾರ್ ದಿತ್ಯಾತ್ ತ್ಯಾತುರುಚ್ ಕುಶಿ ಹೊವಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","“ಅಮಿ ವಾಟ್ ಬಗುನ್ಗೆತ್ ಹೊತ್ತೊ ಮೆಸ್ಸಿಯಾ ಜುವಾಂವುಚ್ ಕಾಯ್ಕಿ,” ಮನುನ್ ಲೊಕಾ ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ನಿ ಯವ್ಜುಕ್ ಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ತೆಚೆಸಾಟ್ನಿ ಜುವಾಂವಾಕ್ ತೆಂಕಾ “ಮಿಯಾ ತುಮ್ಕಾ ಪಾನಿಯಾನ್ ಬಾಲ್ತಿಮ್ ದಿವ್ಲಾ ಖರೆ ಮಾಜ್ಯಾ ಮಾನಾ ಎಕ್ಲೊ ಯೆತಲೊ ಹಾಯ್ ತೊ ಮಾಜೆನ್ಕಿ ಲೈ ಮೊಟೊ, ತೆಚ್ಯಾ ವ್ಹಾನಾಚಿ ನಾಡಿ ಸೊಡ್ತಲಿ ಸೈತ್ ಮಾಕಾ ಮರ್‍ಯಾದ್ ನಾ, ತೊ ತುಮ್ಕಾ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಅನಿ ಆಗಿನ್ ಬಾಲ್ತಿಮ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ತೆನಿ ತೆಚೆ ಸುಪ್ಪ್ ಹಾತಿತ್ ಧರ್‍ಲ್ಯಾನಾಯ್, ತೊ ಅಪ್ಲೆ ಖಳ್ಯಾತ್ಲೆ ದಾನೆ ಫಾಪಡ್ತಾ, ಅನಿ ಘವ್ ಅಪ್ನಾಚ್ಯಾ ದಾನೆ ಥವ್ತಲ್ಯಾ ತಟ್ಟ್ಯಾತ್ ಭರುನ್ ಥವ್ತಾ, ಖರೆ, ಜೊಳ್ಳ್ ಕನ್ನಾಚ್ ಇಜಿನಸಲ್ಲ್ಯಾ ಆಗಿತ್ ಘಾಲುನ್ ಜಾಳ್ವುತಾ”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ಅಶೆ ದುಸ್ರ್ಯಾ-ದುಸ್ರ್ಯಾ ರಿತಿನ್ ಜುವಾಂವಾಕ್ ಲೊಕಾಕ್ನಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನ್, ಅನಿ ಲೊಕಾನಿ ತೆಂಚಿ ಮನಾ ಬದ್ಲಿ ಸಾರ್ಕೆ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ಹೆರೊದ್ ಮನ್ತಲ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಬುರ್ಶಿ-ಬುರ್ಶಿ ಕಾಮಾ ಕರಲ್ಲ್ಯಾನ್ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಭಾವಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಹೆರೊದಿಯಾಸಾಕ್ ನಗಿನ್ ಕರುನ್ ಘೆಟಲ್ಲ್ಯಾನ್, ತಸೆ ಮನುನ್ ಜುವಾಂವ್ ತೆಕಾ ಹಿ ತುಜಿ ಚುಕ್ ಮನುನ್ ಸಾಂಗುನ್ಗೆತ್ ರೈ. ");
INSERT INTO kans_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ಜುವಾಂವಾಕ್ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಲುನ್, ಹೆರೊದಾನ್ ಅನಿ ಎಕ್ ಬುರ್ಶೆ ಕಾಮ್ ಕರುನ್ ಘೆಟಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಾಲ್ತಿಮ್ ದಿವ್ನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್‍ಬಿ ಬಾಲ್ತಿಮ್ ಘೆಟ್ಲ್ಯಾನ್, ಜೆಜು ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ ಮಳಬ್ ಉಗಡ್ಲೊ ");
INSERT INTO kans_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ಅನಿ ಪಾರಿವಾಳಾಚ್ಯಾ ರುಪಾರ್ ಪವಿತ್ರ್ ಆತ್ಮೊ ತೆಚ್ಯಾ ವರ್‍ತಿ ಉತ್ರುನ್ ಯೆಲೊ ಅನಿ “ತಿಯಾ ಮಾಜ್ಯಾ ಮನಾ ಸರ್ಕೊ ಮಾಜೊ ಅಪುರ್‍ಬಾಯೆಚೊ ಲೆಕ್” ಮನುನ್ ಸರ್‍ಗಾ ವೈನಾ ಎಕ್ ಧನ್ ಆಯ್ಕೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ಜೆಜುನ್ ತೆಚೆ, ಬರಿ ಖಬರ್ ಸಿಕ್ವುತಲೆ ಕಾಮ್ ಸುರು ಕರ್‍ತಾನಾ, ತೊ ತಿಸ್ ವರ್ಸಾಂಚೊ ಹೊತ್ತೊ, ಲೊಕಾ ಜೆಜು ಎಲಿಚ್ಯಾ ಲೆಕಾಚೊ ಜುಜೆಚೊ ಲೆಕ್ ಮನುನ್ ಯವ್ಜಿತ್. ");
INSERT INTO kans_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ಯೆಲಿ ಮತ್ತಾತಾಚೊ ಲೆಕ್, ಮತ್ತಾತ್ ಲೆವಿಚೊ ಲೆಕ್, ಲೆವಿ ಮೆಲ್ಕಿಚೊ ಲೆಕ್, ಮೆಲ್ಕಿ ಜನ್ನಾಯಾಚೊ ಲೆಕ್, ಜನ್ನಾಯ್ ಜುಜೆಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ಜುಜೆ ಮತ್ತಥಿಯಾಚೊ ಲೆಕ್, ಮತ್ತಥಿಯಾ ಅಮೊಸಾಚೊ ಲೆಕ್, ಅಮೊಸ್ ನಾಹುಮಾಚೊ ಲೆಕ್, ನಾಹುಮ್ ಎಸ್ಲಿಚೊ ಲೆಕ್, ಎಸ್ಲಿ ನಗ್ಗಾಯಾಚೊ ಲೆಕ್. ");
INSERT INTO kans_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ನಗ್ಗಾಯ್ ಮಾಥಾಚೊ ಲೆಕ್, ಮಾಥ್ ಮತ್ತಥಿಯಾಚೊ ಲೆಕ್, ಮತ್ತಥಿಯಾ ಸಿಮಿಯೊನಾಚೊ ಲೆಕ್, ಸಿಮಿಯೊನ್ ಜೊಸೆಖಾಚೊ ಲೆಕ್. ಜೊಸೆಖ್ ಜೊದಾಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ಜೊದಾ ಜೊನಾನಾಚೊ ಲೆಕ್, ಜೊನಾನ್ ರೆಸಾಚೊ ಲೆಕ್, ರೆಸಾ ಜೆರುಬಾಬೆಲಾಚೊ ಲೆಕ್, ಜೆರುಬಾಬೆಲ್ ಶಅಲ್ತಿಥಿಯೆಲಾಚೊ ಲೆಕ್, ಶಅಲ್ತಿಯೆಲ್ ನೆರಿಚೊ ಲೆಕ್. ");
INSERT INTO kans_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ನೆರಿ ಮೆಲ್ಕಿಚೊ ಲೆಕ್, ಮೆಲ್ಕಿ ಅದ್ದಿ ಮನ್ತಲ್ಯಾಚೊ ಲೆಕ್, ಅದ್ದಿ ಕೊಸಾಮಾಚೊ ಲೆಕ್, ಕೊಸಾಮ್ ಎಲ್ಮಾದಾಮಾಚೊ ಲೆಕ್, ಎಲ್ಮಾದಾಮ್ ಎರಾಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ಎರ್ ಜೊಶ್ವಾಚೊ ಲೆಕ್, ಜೊಶ್ವಾ ಎಲಿಯಾಜರಾಚೊ ಲೆಕ್, ಎಲಿಯಾಜರ್ ಜೊರಿಮಾಚೊ ಲೆಕ್, ಜೊರಿಮ್ ಮಥಾತಾಚೊ ಲೆಕ್, ಮಥಾತ್ ಲೆವಿಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ಲೆವಿ ಸಿಮಿಯಾವಾಚೊ ಲೆಕ್, ಸಿಮಿಯಾವ್ ಜುದಾಚೊ ಲೆಕ್, ಜುದಾ ಜುಜೆಚೊ ಲೆಕ್, ಜುಜೆ ಜೊನಾಮಾಚೊ ಲೆಕ್, ಜೊನಾಮ್ ಎಲಿಯಾಕಿಮಾಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ಎಲಿಯಾಕಿಮ್ ಮಲಿಯಾಚೊ ಲೆಕ್, ಮಲಿಯಾ ಮನ್ನಾಚೊ ಲೆಕ್, ಮನ್ನಾ ಮಾತ್ತಾಥಾಚೊ ಲೆಕ್, ಮಾತ್ತಾಥ್ ನಾತಾನಾಚೊ ಲೆಕ್,ನಾತಾನ್ ದಾವಿದಾಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ದಾವಿದ್ ಜಸ್ಸೆಚೊ ಲೆಕ್, ಜಸ್ಸೆ ಒಬೆದಾಚೊ ಲೆಕ್, ಒಬೆದ್ ಬೊಆಜಾಚೊ ಲೆಕ್, ಬೊಅಜ್ ಸಲ್ಮೊನಾಚೊ ಲೆಕ್, ಸಲ್ಮೊನ್ ನಾಅಸೊನಾಚೊ ಲೆಕ್. ");
INSERT INTO kans_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ನಾಅಸೊನ್ ಅಮಿನಾದಾಬಾಚೊ ಲೆಕ್, ಅಮಿನಾದಾಬ್ ಆದ್ಮಿನಾಚೊ ಲೆಕ್, ಆದ್ಮಿನ್ ಆರ್‍ನಿಚೊ ಲೆಕ್, ಆರ್‍ನಿ ಹೆಸ್ರೊನಾಚೊ ಲೆಕ್, ಹೆಸ್ರೊನ್ ಫೆರೆಸಾಚೊ ಲೆಕ್, ಫೆರೆಜ್ ಜುದಾಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ಜುದಾ ಜಾಕೊಬಾಚೊ ಲೆಕ್, ಜಾಕೊಬ್ ಇಸಾಕಾಚೊ ಲೆಕ್, ಇಸಾಕ್ ಅಬ್ರಾಹಾಮಾಚೊ ಲೆಕ್, ಅಬ್ರಾಹಾಮ್ ತೆರಾಹ್ ನಾಹೊರಾಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ನಾಹೊರ್ ಸೆರುಗಾಚೊ ಲೆಕ್, ಸೆರುಗ್ ರೆವುಚೊ ಲೆಕ್, ರೆವು ಪೆಲೆಗಾಚೊ ಲೆಕ್, ಪೆಲೆಗ್ ಎಬೆರಾಚೊ ಲೆಕ್, ಎಬೆರ್ ಶಿಲಾಹಾಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ಶಿಲಾಹಾ ಕಾಯಿನಾಚೊ ಲೆಕ್, ಕಾಯಿನ್ ಅರ್ಪಾಕ್ಸಾದಾಚೊ ಲೆಕ್, ಅರ್ಫಾಕ್ಸಾದ್ ಶೆಮಾಚೊ ಲೆಕ್, ಶೆಮ್ ನೊಯೆಚೊ ಲೆಕ್, ನೊಯೆ ಲಾಮೆಖಾಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ಲಾಮೆಖ್ ಮಥುಸೆಲಾಚೊ ಲೆಕ್, ಮೆಥುಸೆಲಾ ಎನೊಕಾಚೊ ಲೆಕ್, ಎನೊಕ್ ಜಾರೆದಾಚೊ ಲೆಕ್, ಜಾರೆದ್ ಮಹಾಲಾಲಿಲಾಚೊ ಲೆಕ್, ಮಹಾಲಾಲಿಲ್ ಕಾನಾನಾಚೊ ಲೆಕ್, ");
INSERT INTO kans_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ಕಾನಾನ್ ಎನೊಶಾಚೊ ಲೆಕ್, ಎನೊಶ್ ಶೆತಾಚೊ ಲೆಕ್, ಶೆತ್ ಆದಾಮಾಚೊ ಲೆಕ್, ಆದಾಮ್ ದೆವಾಚೊ ಲೆಕ್. ");
INSERT INTO kans_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ಜೆಜು ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರುನ್ ಜೊರ್ದಾನ್ ನ್ಹಯಿಕ್ನಾ ಪರ್‍ತುನ್ ಯೆಲೊ,ಅನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಜೆಜುಕ್ ಹಾಳ್ ಜಾಗ್ಯಾಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ಚಾಳಿಸ್ ದಿಸಾ ಗಿರೊ ಜೆಜುಕ್ ಪಾಪ್ ಕರಿ ಸರ್ಕೆ ಕರುಕ್‍ ಬಗಟ್ಲ್ಯಾನ್.ತ್ಯಾ ಚಾಳಿಸ್ ದಿಸಾತ್ನಿ ಜೆಜುನ್ ಪೊಟಾಕ್ ಕಾಯ್ಬಿ ಖಯ್‍ನಸಲ್ಲ್ಯಾನ್ ಚಾಳಿಸ್ ದಿಸಾ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ಲೈ ಭುಕ್‍ಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ತನ್ನಾ ಗಿರೊ ಜೆಜುಕ್ “ತಿಯಾ ದೆವಾಚೊ ಲೆಕ್ ಹೊಯ್ ಹೊಲ್ಯಾರ್ ಹ್ಯಾ ಗುಂಡ್ಯಾಕ್ನಿ ಭಾಕ್ರಿಯಾ ಹೊವ್ಕ್ ಹುಕುಮ್ ದಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ತನ್ನಾ ಜೆಜುನ್ “ಖಾಯ್ದ್ಯಾಂಚೆ ಪುಸ್ತಕ್ ಮನ್ತಾ” ಮಾನುಸ್ ಖಾಲಿ ಭಾಕ್ರಿ ವೈನಾ ಎವ್ಡೆಚ್ ಜಿವನ್ ಕರಿನಾ, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ತನ್ನಾ ಸೈತಾನಾನ್ ಜೆಜುಕ್ ಮಡ್ಡಿ ವೈರ್ ಘೆವ್ನ್ ಜಾವ್ನ್, ಹ್ಯಾ ಜಗಾತ್ಲೆ ಸಗ್ಳೆ ರಾಜ್ವಾಡೆ ದಾಕ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ಅನಿ “ಹಿ ಸಗ್ಳೊ ವೈಭವ್ ಅನಿ ಅದಿಕಾರ್ ಮಿಯಾ ತುಕಾ ದಿತಾ” ಹೆ ಸಗ್ಳೆ ಮಾಕಾ ಮನುನ್ ದಿಲ್ಲೆ ಹಾಯ್, ಹೆ ಮಾಜ್ಯಾ ಮನಾಕ್ ಯೆತಾ, ತೆಕಾ ಮಿಯಾ ದಿವ್ಕ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","“ತಿಯಾ ಮಾಜ್ಯಾ ಪಾಯಾ ಪಡ್ಲ್ಯಾರ್ ಹೆ ಸಗ್ಳೆ ಮಿಯಾ ತುಕಾ ದಿತಾ” ಮಟ್ಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ತನ್ನಾ ಜೆಜುನ್ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾತ್ “ಸರ್ವೆಸ್ವರಾ ತುಜ್ಯಾ ದೆವಾಚೆ ಎವ್ಡೆಚ್ ಪಾಯಾ ಪಡ್,ಅನಿ ತೆಚಿ ಎಕ್ಲ್ಯಾಚಿಚ್ ಸೆವಾ ಕರ್ ಮನುನ್ ಸಾಂಗ್ತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ಮಾನಾ ಸೈತಾನಾನ್ ಜೆಜುಕ್ ಜೆರುಜಲೆಮಾಚ್ಯಾ ದೆವಾಚ್ಯಾ ಗುಡಿ ವರ್‍ತಿ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್, ಅನಿ ದೆವಾಚೊ ಲೆಕ್ ಹೊಯ್ ಜಾಲ್ಯಾರ್ ಹಿತ್ನಾ ಖಾಲ್ತಿ ಹುಡಿ ಮಾರ್. ");
INSERT INTO kans_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ “ತುಕಾ ರಾಕನ್ ಕರುಕ್ ದೆವ್ ಅಪ್ನಾಚ್ಯಾ ದುತಾಕ್ನಿ ಹುಕುಮ್ ದಿತಾ, ಮನುನ್ ಲಿವಲ್ಲೆ ಹಾಯ್” ");
INSERT INTO kans_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ತವ್ಡೆಚ್ ನ್ಹಯ್ “ತೆನಿ ತುಕಾ ತುಜೆ ಪಾಯ್ ಜಮ್ನಿಕ್ ಅದ್ಳುಕ್ ದಿ ನಸ್ತಾನಾ ಉಕ್ಲುನ್ ಧರ್‍ತ್ಯಾತ್” ಮನುನ್ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲೆ ಹಾಯ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ಖರೆ ಜೆಜುನ್ ತೆಕಾ “ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾತ್” “ದೆವಾಚಿ ತುಜ್ಯಾ ಸರ್ವೆಸ್ವರಾಚಿ ಪರಿಕ್ಷಾ ಕರುನಕೊ ಮನುನ್ಬಿ ಸಾಂಗ್ತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ಗಿರೊ ಸಗ್ಳ್ಯಾ ರಿತಿನ್ ಜೆಜುಕ್ ಪಾಪ್ ಕರಿ ಸರ್ಕೆ ಕರುಕ್ ಖಟ್ಪಟ್ ಕರುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಸೈತಾನ್ ಉಲ್ಲೊ ಎಳ್ ಜೆಜುಕ್ ಸೊಡುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ತನ್ನಾ ಜೆಜು ಪರ್ತುನ್ ಗಾಲಿಲಿಯಾಕ್ ಯೆಲೊ ಅನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚೊ ಬಳ್ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ, ತೆಚ್ಯಾ ವಿಶಯಾತ್ಲಿ ಖಬರ್, ಗಾಲಿಲಿಯಾಚ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಫರ್ಗಟ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ತೆನಿ ಸಿನಾಗೊಗಾತ್ನಿ ಶಿಕ್ವುಲ್ಯಾನ್, ಅನಿ ಸಗ್ಳ್ಯಾನಿಕ್ನಾ ಶಬಾಸ್ಕಿ ಮನುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ಮಾನಾ ಜೆಜು ಅಪ್ನಿ ಬಾರಿಕ್-ಹೊತ್ತೊ ಮೊಟೊ ಹೊಲ್ಲೆ ಗಾಂವ್ , ನಜರೆತಾಕ್ ಗೆಲೊ, ಅನಿ ಸದ್ದಿಚ್ಯಾ ಬಾಸೆನ್ ಸಿನಾಗೊಗಾತ್ ಗೆಲೊ ಅನಿ ವಾಚ್ವುಕ್ ಇಬೆ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾಚೆ ಪುಸ್ತಕ್ ತೆಕಾ ದಿಲ್ಯಾನಿ, ತೆನಿ ತೆ ಉಗಡ್ಲ್ಯಾನ್, ತನ್ನಾ ತೆಕಾ ಅಶೆ ಮನುನ್ ಲಿವಲ್ಲೆ ವಾಚುಕ್ ಗಾವ್ಲೆ, ತೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, ");
INSERT INTO kans_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ಪವಿತ್ರ್ ಆತ್ಮೊ ಮಾಜೆ ವರ್‍ತಿ ಹಾಯ್ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಗರಿಬಾಕ್ನಿ ಬರಿ ಖಬರ್ ಹಾನುಕ್ ಮನುನ್, ತೆನಿ ಮಾಕಾ ಎಚುನ್ ಕಾಡ್ಲ್ಯಾನಾಯ್. ಗುಲಾಮ್ಗಿರಿತ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಸುಟ್ಕಾ ಯೆಲಾ, ಅನಿ ಕುಡ್ಡಾಕ್ನಿ ದಿಸ್ಟ್ ಯೆಲಾ ಮನುನ್ ಸಾಂಗುಕ್ ತೆನಿ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್. ಅಡ್ಚನಿತ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಸುಟ್ಕಾ ದಿತಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ಅನಿ ದೆವ್ ಅಪ್ನಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ರಾಕನ್ ಕರ್‍ತಲೊ, ಎಳ್ ಯೆವ್ನ್ ಪಾವ್ಲಾ ಮನುನ್ ಸಗ್ಳ್ಯಾಕ್ನಿ ಸಾಂಗುಕ್ ತೆನಿ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್‍. ");
INSERT INTO kans_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ಜೆಜುನ್ ಪುಸ್ತಕ್ ಧಾಪ್ಲ್ಯಾನ್ ಅನಿ ಸಿನಾಗೊಗಾಚ್ಯಾ ಸೆವಕಾಚ್ಯಾ ಹಾತಿತ್ ದಿಲ್ಯಾನ್, ಅನಿ ಬಸ್ಲೊ ಸಿನಾಗೊಗಾತ್ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚೆ ಡೊಳೆ ಜೆಜು ವರ್‍ತಿಚ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ಜೆಜುನ್ ತೆಂಕಾ “ಮಿಯಾ ವಾಚ್ವುತಾನಾ ತುಮಿ ಆಯ್ಕಲ್ಲಿ ಹಿ ಗೊಸ್ಟಿಯಾ ಆಜ್ ಖರೆ ಹೊಲೆ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ತೆಂಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಹೆ ಲೈ ಬರೆ ದಿಸ್ಲೆ, ಅನಿ ಎವ್ಡ್ಯಾ ಬುದ್ವಂತ್ಕಿನ್ ಬೊಲಲ್ಲ್ಯಾ ಬರ್‍ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುನ್, ತೆನಿ ಅಜಾಪ್ ಹೊಲೆ. ತನ್ನಾ ತೆನಿ “ಹ್ಯೊ ಜುಜೆಚೊ ಲೆಕ್ ನ್ಹಯ್?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ತನ್ನಾ ತೆನಿ ತೆಂಕಾ “ವಗ್ದುಳ್ಯಾ, ಅದ್ದಿ ತುಕಾಚ್ ತಿಯಾ, ಆರಾಮ್ ಕರುನ್ಗೆ ” ಮನ್ತಲೆ ಶಾಸ್ತರ್ ಮಾಕಾ ತುಮಿ ಸಾಂಗ್ತ್ಯಾಶಿ, ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹೊತ್ತೆ; ಅನಿ ಕಪರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಕರಲ್ಲಿ ಕಾಮ್ ಹಿತ್ತೆ, ತುಜ್ಯಾ ಸ್ವಂತ್ ಗಾಂವಾತ್‍ಬಿ ಕರುನ್ ದಾಕ್ವು, ಮನುನ್ ತುಮಿ ಮಾಕಾ ಸಾಂಗ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ಖರೆ, ಜೆಜುನ್ ತೆಂಕಾ “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ ಪ್ರವಾದ್ಯಾಕ್ ಅಪ್ನಾಚ್ಯಾ ಸ್ವಂತ್ ಗಾಂವಾತ್ ಕನ್ನಾಬಿ ಮರ್‍ಯಾದ್ ಗಾವಿನಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ ಎಲಿಯಾ ಪ್ರವಾದ್ಯಾಚ್ಯಾ ಎಳಾರ್ ಇಸ್ರಾಯೆಲಾತ್ ಲೈ ಘವ್ ನಸಲ್ಲ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾ ಹೊತ್ತ್ಯಾ, ಸಾಡೆ ತಿನ್ ವರ್ಸಾ ಪಾವ್ಸ್ ನಸ್ತಾನಾ ಸಗ್ಳ್ಯಾ ದೆಶಾತ್ ಬರಗಾಲ್ ಪಡಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ಖರೆ “ಎಲಿಯಾಕ್ ಇಸ್ರಾಯೆಲಾತ್ಲ್ಯಾ ಕೊನಾಕ್ಡೆಬಿ ಧಾಡುನ್ ಹೊವ್ಕ್ ನಾ, ಖರೆ ಜರಾಫಾತ್ ನಾವಾಚ್ಯಾ ಮನುನ್ ಸಿದೊನ್ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಹೊತ್ತ್ಯಾ ಘವ್ ನಸಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ಡೆ ಧಾಡುನ್ ಹೊಲೆ”. ");
INSERT INTO kans_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ಇಸ್ರಾಯೆಲಾತ್ ಕುಸ್ಟ್ ರೊಗಾನಿ ಲೈ ಲೊಕಾ ತರಾಸ್ ಕರುನ್ ಘೆಯ್ತ್, ಖರೆ ಎಲಿಶಾ ಪ್ರವಾದ್ಯಾಚ್ಯಾ ಎಳಾರ್ ಸಿರಿಯಾಚೊ ನಾಮಾನ್ ಮನ್ತಲೊ ಎಕ್ಲೊಚ್ ಆರಾಮ್ ಹೊಲೊ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ಹೆ ಸಗ್ಳೆ ಆಯ್ಕುನ್ ಸಿನಾಗೊಗಾತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ರಾಗ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ತೆನಿ ಉಟ್ಲ್ಯಾನಿ ಅನಿ ಜೆಜುಕ್ ತೆಂಚೆ ಗಾಂವ್ ಭಾಂದಲ್ಲ್ಯಾ ಮಡ್ಡಿ ವರ್‍ತಿ ವೊಡುನ್ ನ್ಹೆಲ್ಯಾನಿ, ಅನಿ ಥೈತ್ನಾ ಲೊಟುನ್ ಘಾಲುಂವಾ ಮನುನ್ ಹೊತ್ತ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ಖರೆ, ಜೆಜು ಲೊಕಾಂಚ್ಯಾ ಮದ್ನಾಚ್ ಚಲುನ್ ಅಪ್ನಾಚಿ ವಾಟ್ ಧರುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ತನ್ನಾ ಜೆಜು ಗಾಲಿಲಿಯಾ ಪ್ರಾಂತ್ಯಾಚ್ಯಾ ಕಪರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಗೆಲೊ. ಅನಿ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ತೊ ಅದಿಕಾರ್‍ಯಾನ್ ಬೊಲ್ತಲೆ ಅನಿ ಶಿಕ್ವುತಲೆ ಆಯ್ಕುನ್ ಲೊಕಾ ಅಜಾಪ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ತ್ಯಾ ಸಿನಾಗೊಗಾತ್ ಗಿರೊಲಾಗಲ್ಲೊ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ. ತೆನಿ ಜೊರಾನಿ ಕಿಂಚುನ್ಗೆತ್. ");
INSERT INTO kans_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ನಜರೆತಾಚ್ಯಾ ಜೆಜು ಅಮ್ಚ್ಯಾಕ್ನಾ ತುಕಾ ಕಾಯ್ ಪಾಜೆ? ಅಮ್ಕಾ ನಾಸ್ ಕರುಕ್ ಮನುನ್ ಎಲೆ ಕಾಯ್? ತಿಯಾ ಕೊನ್ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್, ತಿಯಾ ದೆವಾನ್ ಧಾಡಲ್ಲೊ ಪವಿತ್ರ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ತನ್ನಾ ಜೆಜುನ್ “ಗಪ್-ರ್‍ಹಾಮ್ ಅನಿ‍ ತ್ಯಾ ಮಾನ್ಸಾತ್ನಾ ಭಾಯ್ರ್ ಯೆ” ಮನುನ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ಗಿರ್‍ಯಾನ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ತೆಂಚ್ಯಾ ಇದ್ರಾಕ್ ಪಾಡ್ವುಲ್ಯಾನ್ ಅನಿ ತೆಕಾ ಕಾಯ್ಬಿ ವಾಯ್ಟ್ ಕರಿನಸ್ತಾನಾ ತೊ ತೆಚ್ಯಾ ಭುತ್ತುರ್‍ನಾ ಬಾಯ್ರ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ಲೊಕಾ ಹೆ ಬಗುನ್ ಅಜಾಪ್ ಹೊಲಿ, ಅನಿ ಎಕಾಮಕಾತ್ನಿ “ಹ್ಯಾ ಕಸ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ಅಸ್ತಿಲ್? ಅದಿಕಾರ್‍ಯಾನ್ ಅನಿ ಬಳಾನ್, ಹ್ಯೊ ಮಾನುಸ್ ಗಿರ್‍ಯಾಕ್ನಿ ತಾಕಿತ್ ದಿತಾ, ಅನಿ ತಿ ಗಿರೆ ತೆಚೆ ಆಯ್ಕುನ್ ಭಾಯ್ರ್ ಜಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ಜೆಜುಚಿ ಖಬರ್ ಸಗ್ಳ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಫರ್ಗಟ್ಲಿ”. ");
INSERT INTO kans_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ಜೆಜು ಸಿನಾಗೊಗ್ ಸೊಡುನ್ ಸಿಮಾವಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲೊ ಸಿಮಾವಾಚಿ ಮಾಮಿ ತಾಪಾನ್ ಆರಾಮ್ ನಸ್ತಾನಾ ನಿಜಲ್ಲಿ, ಅನಿ ತೆನಿ ತಿಚ್ಯಾ ವಿಶಯಾತ್ ಜೆಜುಕ್ಡೆ ಬೊಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ಜೆಜು ಗೆಲೊ ಅನಿ ತಿಚ್ಯಾ ಜಗ್ಗೊಳ್ ಇಬೆ ರ್‍ಹಾಲೊ, ಅನಿ ತಾಪಾಕ್ ತಿಕಾ ಸೊಡುನ್ ಜಾ, ಮನುನ್ ತೆನಿ ಸಾಂಗ್ಲ್ಯಾನ್. ತನ್ನಾ ತಾಪ್ ತಿಕಾ ಸೊಡುನ್ ಗೆಲೊ, ಅನಿ ತಿ ಎಗ್ದಮ್ ಉಟ್ಲಿ ಅನಿ ತೆಂಚಿ ಸೆವಾ ಕರುಕ್‍ಲಾಗ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ದಿಸ್ ಬುಡಲ್ಲ್ಯಾ ತನ್ನಾ ಲೊಕಾನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಕ್ ಹೊತ್ತ್ಯಾ ದೊಸ್ತಾಕ್ನಿ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ತೆಂಕಾ ದುಸ್ರಿ-ದುಸ್ರಿ ಲೈ ರೊಗಾ ಹೊತ್ತಿ ತೆಂಚ್ಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ಜೆಜುನ್ ಹಾತ್ ಥವ್ಲ್ಯಾನ್, ಅನಿ ತೆಂಕಾ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ಸುಮಾರ್ ಲೊಕಾನಿತ್ನಾ ಗಿರೆಬಿ ಭಾಯ್ರ್ ಗೆಲಿ. ಅನಿ ಗಿರೆ “ತಿಯಾ ದೆವಾಚೊ ಲೆಕ್” ಮನುನ್ ಬೊಬ್ ಮಾರುಕ್ ಲಾಗಲ್ಲಿ, ಜೆಜುನ್ ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ನಿ ಬೊಲುಕ್ ದಿವ್ಕ್ ನಾ ಕಶ್ಶಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ಮೆಸ್ಸಿಯಾ ಮನುನ್ ತೆಂಕಾ ಗೊತ್ತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ಸಕ್ಕಾಳ್ಚೆ, ಜೆಜು ಗಾಂವ್ ಸೊಡುನ್ ಎಕ್ ಕೊನ್-ಬಿ ನಸಲ್ಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಗೆಲೊ. ತನ್ನಾ ಲೊಕಾ ತೆಕಾ ಹುಡ್ಕುಕ್‍ ಲಾಗಲ್ಲಿ, ಅನಿ ತೊ ತೆಂಕಾ ಗಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆನಿ ತೆಕಾ ಅಪ್ನಾಕ್ ಸೊಡುನ್ ಜಾವ್ಕ್ ದಿವ್ಕನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ಖರೆ ತೆನಿ ತೆಂಕಾ “ದುಸ್ರ್ಯಾ ಗಾಂವಾತ್ನಿಬಿ ಮಿಯಾ ದೆವಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಪಾಜೆ, ಕಶ್ಶಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆಚೆಸಾಟ್ನಿಚ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲೆ ಹಾಯ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ತೆಚೆಸಾಟ್ನಿ ತೊ ದೆಸಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಸಿನಾಗೊಗಾತ್ನಿ ಗೆಲೊ, ಅನಿ ಥೈ ದೆವಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಶಿಕ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ಎಕ್ ದಿಸ್ ಜೆಜು ಗೆನಜರೆತ್ ಮನ್ತಲ್ಯಾ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆಕ್ ಇಬೆ ಹೊತ್ತೊ. ದೆವಾಚಿ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುಕ್ ಲೊಕಾ ಢಕ್ಲಾ-ಢಕ್ಲಿ ಕರುನ್ ಘೆಯ್ತ್ ಗೊಳಾ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ಮೊಸೊಳ್ಯಾ ಧರ್‍ತಲ್ಯಾನಿ ದೊನ್ ಢೊನಾ ವೊಡುನ್ ದಂಡೆಕ್ ಹಾನುನ್ ಥವ್ನ್: ಅಪ್ನಾಚಿ ಜಾಳಿ ಧುತಲೆ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ತ್ಯಾತುರ್‍ಲ್ಯಾ ಎಕ್ ಢೊನಿತ್ ಜೆಜು ಚೆಡುನ್ ಬಸ್ಲೊ ತಿ ಸಿಮಾವಾಚಿ ಢೊನ್, ಅನಿ ಜೆಜುನ್ ಉಲ್ಲಿ ಢೊನ್ ಲೊಟುಕ್ ಸಾಂಗ್ಲ್ಯಾನ್. ಜೆಜು ಢೊನಿತ್ ಬಸುನ್ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ತೆಚೆ ಶಿಕ್ವುನ್ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ ಸಿಮಾವಾಕ್,“ಢೊನ್ ಅನಿ ಉಲ್ಲಿಶಿ ಫಿಡೆ ಲೊಟ್ ಉಲ್ಲ್ಯಾಸ್ಯಾ ಖೊಲ್ ಪಾನಿಯಾತ್, ಅನಿ ತಿಯಾ ಅನಿ ತುಜೆ ವಾಂಗ್ಡಿ ತುಮ್ಚಿ ಜಾಳಿ ಘಾಲಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ತನ್ನಾ ಸಿಮಾವಾನ್ “ಗುರುಜಿ, ಸಗ್ಳಿ ರಾತ್‍ಬರ್ ಅಮಿ ಕಾಮ್ ಕರ್ಲಾಂವ್, ಖರೆ ಅಮ್ಕಾ ಎಕ್‍ಬಿ ಮಾಸೊಳಿ ಗಾವುಕ್‍ನಾ, ಖರೆ ತಿಯಾ ಸಾಂಗುಕ್ ಲಾಗ್ಲೆ ಮನುನ್ ಮಿಯಾ ಜಾಳಿ ಘಾಲ್ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ತೆನಿ ಜಾಳಿ ಘಾಟ್ಲ್ಯಾನಿ ಅನಿ ತೆಂಕಾ ಭರ್ಪುರ್ ಮಾಸೊಳ್ಯಾ ಗಾವ್ಲ್ಯಾ. ತೆಂಚಿ ಜಾಳಿ ಪಿಂಜುಕ್‍ಯಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ತಸೆ ಮನುನ್, ತೆನಿ ಸೊನ್ನಿ ಕರುನ್, ಅನಿದುಸ್ರ್ಯಾ ಢೊನಿತ್ಲ್ಯಾಕ್ನಿಬಿ ಬಲ್ವುಲ್ಯಾನಿ, ತೆನಿಬಿ ಯೆಲ್ಯಾನಿ ಅನಿ ದೊನಿಬಿ ಢೊನಿಯಾತ್ನಿ ಮಾಸೊಳ್ಯಾ ಭರ್‍ಲ್ಯಾನಿ, ದೊನಿಬಿ ಢೊನಿಯಾ ಬುಡುಕ್ ಯೆಲ್ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ಹೆ ಸಗ್ಳೆ ಬಗಟಲ್ಲೆಚ್, ಸಿಮಾವ್ ಪೆದ್ರುನ್ ಜೆಜುಚ್ಯಾ ಇದ್ರಾಕ್ ಡೊಗ್ಲಾ ಟೆಕ್ಲ್ಯಾನ್ ಅನಿ “ಧನಿಯಾ, ಮಾಜೆಕ್ನಾ ಧುರ್ ಜಾ, ಮಿಯಾ ಎಕ್ ಪಾಪಿ ಮಾನುಸ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ತವ್ಡ್ಯಾ ಲೈ ಮಾಸೊಳ್ಯಾ ಬಗುನ್ ಸಿಮಾವ್ ಪೆದ್ರು, ಅನಿ ತೆಚೆ ವಾಂಗ್ಡಿ ಅಜಾಪ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ಖರೆ ಮಟ್ಲ್ಯಾರ್, ಜೆಬೆದೆವಾಚಿ ಪೊರಾ ಜಾಕೊಬ್ ಅನಿ ಜುವಾಂವುಚ್ ಸಿಮಾವಾಚೆ ವಾಂಗ್ಡಿ ಹೊವ್ನ್ ಹೊತ್ತೆ. ಜೆಜುನ್ ಸಿಮಾವಾಕ್ “ಭಿಂವ್ನಕೊ ಹಿತ್ನಾ ಫಿಡೆ ತಿಯಾ ಲೊಕಾಕ್ನಿ ದೆವಾಚ್ಯಾ ರಾಜಾಕ್ ಬಲ್ವುನ್ ಹಂತಲೊ ಮಾನುಸ್ ಹೊತೆ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ತೆನಿ ಢೊನಾ ದಂಡೆಕ್ ವೊಡುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ಸಗ್ಳೆ ಥೈಚ್ ಸೊಡ್ಲ್ಯಾನಿ,ಅನಿ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ಎಗ್ದಾ ಜೆಜು ಎಕ್ ಗಾಂವಾತ್ ಹೊತ್ತೊ. ಥೈ ಕುಸ್ಟ್ ರೊಗ್ ಹೊತ್ತೊ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ. ತೆನಿ ಜೆಜುಕ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ತೊ ಖಾಲ್ತಿ ಪಡ್ಲೊ, ಅನಿ ಜೆಜುಕ್ “ಗುರುಜಿ, ತಿಯಾ ಮನ್ ಕರ್ಲ್ಯಾರ್, ಮಾಕಾ ಪವಿತ್ರ್ ಕರುಕ್ ಹೊತಾ”, ಮನುನ್ ಮಾಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ಜೆಜುನ್ ಅಪ್ನಾಚೊ ಹಾತ್ ಫಿಡೆ ಕರುನ್ ತೆಕಾ ಅಪಡ್ಲ್ಯಾನ್, ಅನಿ “ಮಾಕಾ ಮನ್ ಹಾಯ್, ಪವಿತ್ರ್ ಹೊ”, ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೆಚೊ ರೊಗ್ ತೆಕಾ ಸೊಡುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ಮಾನಾ ಜೆಜುನ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ “ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕ್ಕೊ, ಖರೆ ಯಾಜಕಾಕ್ಡೆ ಜಾ ಅನಿ ತುಕಾಚ್ ತೆಕಾ ದಾಕ್ವು, ಮಾನಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ತಿಯಾ ಶುದ್ದ್ ಹೊಲೆ ಮನುನ್ ದಾಕ್ವುಸಾಟ್ನಿ ಮೊಯ್ಜೆನ್ ಸಾಂಗಟಲ್ಲಿ ಬಲಿ ಭೆಟ್ವು” ಮನುನ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ಖರೆ, ಧುರ್ ಪತರ್ ಜೆಜುಚಿ ಖಬರ್ ಫರ್ಗಟ್ಲಿ, ಅನಿ ಲೊಕಾ ತಾಂಡ್ಯಾ-ತಾಂಡ್ಯಾನಿ ತೆಚಿ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುಕ್, ಅನಿ ಅಪ್ನಾಚಿ ದುಕ್ನಿ ಆರಾಮ್ ಕರುನ್ ಘೆವ್ಕ್, ತೆಚೆಕ್ಡೆ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ಖರೆ ಜೆಜು ಮಾಗ್ನಿ ಕರುಕ್ ಮನುನ್ ಕೊನಬಿನಸಲ್ಲ್ಯಾ ಜಾಗ್ಯಾ ವೈನಿ ಜಾವ್ನ್ ರಾವ್‍ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ಎಕ್ ದಿಸ್ ಜೆಜು ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುತಾನಾ ಉಲ್ಲೆ ಫಾರಿಜೆವ್, ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲಿ ಲೊಕಾ ಗಾಲಿಲಿಯಾಚ್ಯಾ ಅನಿ ಜುದೆಯಾಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಗಾಂವಾನಿತ್ನಾ, ಅನಿ ಜೆರುಜಲೆಮ್ ಶಾರಾತ್ನಾ ಯೆಲ್ಲ್ಯಾನಿ. ತೆನಿಬಿ, ತ್ಯಾ ಲೊಕಾತ್ನಿ ಬಸಲ್ಲ್ಯಾನಿ. ಸರ್ವೆಸ್ವರಾನ್ ಜೆಜುಕ್ ಶಿಕ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಗುನ್ ಕರ್‍ತಲಿ ತಾಕತ್ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಎಕ್ ವಾರೆಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ತೆಚ್ಯಾ ಹಾತ್ರಾನಾ ಸಮೆತ್ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ. ತೆನಿ ಜೆಜು ಹೊತ್ತ್ಯಾ ಘರಾತ್ ಗುಸುಕ್, ಅನಿ ತೆಕಾ ಜೆಜುಚ್ಯಾ ಇದ್ರಾಕ್ ನ್ಹೆವ್ನ್ ಥವ್ಕ್ ಬಗಟ್ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ಲೊಕಾಂಚ್ಯಾ ಅಡ್ಚನಿತ್ ತೆಂಕಾ ಭುತ್ತುರ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಹೊವ್ಕ್ನಾ, ತಸೆ ಮನುನ್ ತೆನಿ ತೆಕಾ ಘರಾ ವರ್‍ತಿ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ, ಖಾಪ್ರಿಯಾ ಕಾಡುನ್ ಎಕ್ ವಾಟ್ ಕರ್‍ಲ್ಯಾನಿ ಅನಿ ತ್ಯಾ ವಾರೆಮಾರಲ್ಲ್ಯಾಕ್ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಮದ್ದಿ, ಜೆಜುಚ್ಯಾ ಇದ್ರಾಕ್ ತೆಚ್ಯಾ ಹಾತ್ರಾನಾ ಸಮೆತ್ ಉತರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ತೆಕಾ ಹಾನಲ್ಲ್ಯಾ ಲೊಕಾಂಚೊ ವಿಶ್ವಾಸ್ ಬಗುನ್, ಜೆಜುನ್ ತ್ಯಾ ವಾರೆಮಾರಲ್ಲ್ಯಾಕ್ “ಮಾಜ್ಯಾ ದೊಸ್ತಾ, ತುಜೆ ಸಗ್ಳೆ ಪಾಪ್ ಮಾಪ್ ಹೊಲೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ತನ್ನಾ ಫಾರಿಜೆವ್ ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲಿ ಲೊಕಾ ಅಪ್ಲ್ಯಾ-ಅಪ್ಲ್ಯಾ ಮದ್ದಿ “ದೆವಾಚಿ ನಿಂದ್ಯಾ ಬೊಲ್ತಲೊ ಹ್ಯೊ ಮಾನುಸ್ ಕೊನ್? ದೆವಾನ್ ಎಕ್ಲ್ಯಾನುಚ್ ಪಾಪ್ ಮಾಪ್ ಕರುಕ್ ಹೊತಾ” ಮನುನ್ ಬೊಲುಕ್‍ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ಜೆಜುಕ್ ತೆನಿ ಯವಜ್ತಲೆ ಕಳ್ಳೆ, ತನ್ನಾ ತೆನಿ “ತುಮಿ ತಸ್ಲೆ ಸಗ್ಳೆ ಕಶ್ಶಾಕ್ ಯವ್ಜುಕ್ ಲಾಗ್ಲ್ಯಾಸಿ?” ");
INSERT INTO kans_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“ತುಜೆ ಪಾಪ್ ಮಾಪ್ ಹೊಲೆ” ಮನ್ತಲೆ ಸಸಾರ್ ಕಾಯ್, “ಉಟ್ ಅನಿ ಚಲ್ ಮನ್ತಲೆ ಕಾಯ್?” ");
INSERT INTO kans_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ತಸೆ ಜಾಲ್ಯಾರ್, ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಹ್ಯಾ ಜಗಾತ್ ಪಾಪ್ ಮಾಪಿ ಕರ್‍ತಲೊ ಅದಿಕಾರ್‍ಬಿ ಹಾಯ್, ಮನುನ್ ಮಿಯಾ ತುಮ್ಕಾ ದಾಕ್ವುನ್ ದಿತಾ. ಮನುನ್ ತ್ಯಾ ವಾರೆಮಾರಲ್ಲ್ಯಾಕ್, ತೆನಿ “ಮಿಯಾ ಸಾಂಗ್ತಾ ಉಟ್, ಘೆ ತುಜೆ ಹಾತ್ರಾನ್, ಅನಿ ಘರಾಕ್ ಚಲ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೊ ಮಾನುಸ್ ತೆಂಚ್ಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಫಿಡ್ಯಾತುಚ್ ಉಟ್ಲೊ, ಅನಿ ಅಪ್ನಿ ನಿಜಲ್ಲೆ ಹಾತ್ರಾನ್ ಘೆವ್ನ್ ದೆವಾಕ್ ಹೊಗ್ಳುನ್ಗೆತ್ ತೊ ಅಪ್ನಾಚ್ಯಾ ಘರಾಕ್ಡೆ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ತೆನಿ ಸಗ್ಳೆ ಜಾನಾ ಎಗ್ದಮ್ ಅಜಾಪ್ ಹೊಲೆ, ಅನಿ “ಕಸ್ಲೆ ಮೊಟೆ ವಿಚಿತ್ರ್ ಅಮಿ ಬಗಟ್ಲ್ಯಾವ್” ಮನುನ್ಗೆತ್ ಭಿಂಯಾನ್ ತೆನಿ ದೆವಾಕ್ ಹೊಗಳ್ಳ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ಹೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಜೆಜು ಬಾಯ್ರ್ ಗೆಲೊ, ಅನಿ ಲೆವಿ ಮನ್ತಲೊ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರುಕ್ ಅಪ್ನಾಚ್ಯಾ ಜಾಗ್ಯಾರ್ ಬಸಲ್ಲೊ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ಜೆಜುನ್ ತೆಕಾ “ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ಲೆವಿ ಉಟ್ಲೊ, ಸಗ್ಳೆ ಥೈಚ್ ಸೊಡ್ಲ್ಯಾನ್, ಅನಿ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ತನ್ನಾ ಲೆವಿನ್ ಅಪ್ನಾಚ್ಯಾ ಘರಾತ್ ಜೆಜುಕ್ ಅನಿ ತೆಚ್ಯಾ ತೆರ್‍ಗಿ ವಸುಲಿ ಕರ್‍ತಲ್ಯಾ ವಾಂಗ್ಡಿಯಾಕ್ನಿ, ಅನಿ ದುಸ್ರ್ಯಾ ಲೊಕಾಕ್ನಿ ಮಿಳುನ್ ಎಕ್ ಮೊಟೆ ಜೆವಾನ್ ಥವಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ಉಲ್ಲ್ಯಾ ಫಾರಿಜೆವಾನಿ, ಅನಿ ಉಲ್ಲ್ಯಾ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ಲ್ಯಾನಿ, ಜೆಜುಚ್ಯಾ ಶಿಸಾಕ್ನಿ “ತುಮಿ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲ್ಯಾಂಚ್ಯಾ, ಅನಿ ದುಸ್ರ್ಯಾ ಪಾಪಿ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಸುನ್ ಕಶ್ಶಾಕ್ ಖಾತ್ಯಾಶಿ-ಫಿತ್ಯಾಶಿ” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ತನ್ನಾ ಜೆಜುನ್ “ಜೆ ಕೊನ್ ಆರಾಮ್ ಹಾತ್, ತೆಂಕಾ ವಗ್ದುಳ್ಯಾಚಿ ಗರಜ್ ನಾ. ಜೆ ಕೊನ್ ಶಿಕ್ ಹಾತ್, ತೆಂಕಾ ಎವ್ಡಿಚ್ ತೆಚಿ ಗರಜ್. ");
INSERT INTO kans_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ಮಿಯಾ ಧರ್ಮಾನಿ ಚಲ್ತಲ್ಯಾ ಲೊಕಾಕ್ನಿ, ಮನ್ ಬದ್ಲುಕ್ ಮನುನ್ ಬಲ್ವುಕ್ ಯೆವ್ಕ್ ನಾ, ಪಾಪಿ ಲೊಕಾಕ್ನಿ ಮನ್ ಬದ್ಲುಕ್ ಬಲ್ವುಕ್ ಮನುನ್ ಯೆಲಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಜೆಜುಕ್ “ಜುವಾಂವಾಚಿ ಶಿಸಾ ಪದೆ ಉಪಾಸ್ ಕರ್‍ತ್ಯಾತ್, ಮಾಗ್ನಿ ಕರ್‍ತ್ಯಾತ್, ಅನಿ ಫಾರಿಜೆವಾಂಚಿ ಶಿಸಾಬಿ ತಸೆಚ್ ಕರ್‍ತ್ಯಾತ್. ಖರೆ ತುಜಿ ಶಿಸಾ ಖಾವ್ನಗೆತ್-ಫಿವ್ನಗೆತ್ ರ್‍ಹಾತ್ಯಾತ್ ಕಶ್ಯಾಕ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ತನ್ನಾ ಜೆಜುನ್ “ಎಕ್ ಲಗ್ನಾಚ್ಯಾ ಕಾರೆವಾಕ್ ಮನುನ್ ಯಲ್ಲೆ ಸೊಯ್ರೆ.ಲಗ್ನಾಚೊ ನ್ಹವ್ರೊ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ರಾತಾನಾ ಉಪ್ಪಾಸಿ ರ್‍ಹಾವ್ಕ್ ಹೊತಾ ಕಾಯ್? ನಾ-ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ಖರೆ ನ್ಹವ್ರ್ಯಾಕ್ ತೆಂಚ್ಯಾ ಮದ್ನಾ ಕಾಡುನ್ ಘೆವ್ನ್ ಜಾತಲೊ ದಿಸ್ ಯೆತಾ, ತನ್ನಾ ತೆನಿ ಉಪಾಸ್ ಕರ್‍ತ್ಯಾತ್”, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ಅನಿ ಜೆಜುನ್ ತೆಂಕಾ ಎಕ್ ಕಾನಿಬಿ ಸಾಂಗ್ಲ್ಯಾನ್ “ಎಕ್ ಜುನ್ನ್ಯಾ ಪಿಂಜಲ್ಲ್ಯಾ ಅಂಗಿಕ್ ಲಾವುನ್ ಶಿವುಕ್ ಮನುನ್, ನ್ಹವ್ಯಾ ಅಂಗಿಚೊ ತುಕ್ಡೊ ಕೊನ್ ಬಿ ಕಾತ್ರುನ್ ಕಾಡಿನಾ. ತೆನಿ ತಸೆ ಕರ್ಲ್ಯಾರ್, ತೊ ನ್ಹವಿ ಅಂಗಿ ಪಿಂಜ್ತಾ, ಅನಿ ತೊ ನ್ಹವೊ ತುಕ್ಡೊ ಜುನ್ನ್ಯಾ ಅಂಗಿಕ್ ಲಾವಲ್ಲೊ ಬರಬ್ಬರ್ ದಿಸಿನಾ. ");
INSERT INTO kans_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ನಾಹೊಲ್ಯಾರ್, ಕೊನ್ ಬಿ ನ್ಹವೊ ವಾಯ್ನ್ ಜುನ್ನ್ಯಾ ಚಮ್ಡ್ಯಾಚ್ಯಾ ಪಿಸ್ವಿತ್ ಘಾಲಿನಾ. ಘಾಟ್ಲ್ಯಾರ್ ಪಿಸ್ವಿ ಪಿಂಜುನ್ ಸೊಡ್ತಾ, ಮಾನಾ ಸಗ್ಳೆ ವಾಯ್ನ್ ಗಳುನ್ ಜಾವ್ನ್ ಸೊಡ್ತಾ, ಅನಿ ತಿ ಚಮ್ಡ್ಯಾಚಿ ಪಿಸ್ವಿಬಿ ಹಾಳ್ ಹೊವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ತಸೆ ಮನುನ್ ನ್ಹವೊ ವಾಯ್ನ್ ನ್ಹವ್ಯಾ ಚಮ್ಡ್ಯಾಚ್ಯಾ ಪಿಸ್ವಿತುಚ್ ವೊತುಚೆ! ");
INSERT INTO kans_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ಜುನ್ನಿ ವಾಯ್ನ್ ಫಿಲ್ಲ್ಯಾ ತನ್ನಾ, ನ್ಹವಿ ವಾಯ್ನ್ ಕೊನಾಕ್ಬಿ ನಕ್ಕೊ ಹೊತಾ,ಜುನ್ನಿ ವಾಯ್ನ್ ಫಿಲ್ಲೊ ಜುನ್ನಿ ವಾಯ್ನುಚ್ ಎಗ್ದಮ್ ಬರಿ ಮನುನ್ ಸಾಂಗ್ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ಎಕ್ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಜೆಜು ಪಿಕ್ ಹೊತ್ತ್ಯಾ ಶೆತಾನಿತ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಜಾವ್ಕ್ ಲಾಗಲ್ಲಿ ತನ್ನಾ ಜೆಜುಚ್ಯಾ ಶಿಸಾನಿ ಕನ್ಸಾ ಮೊಡುನ್ ಘೆಟ್ಲ್ಯಾನಿ ಅನಿ ಹಾತಾನಿ ಮುರ್‍ಡುನ್ ದಾನೆ ಖಾವ್ಕ್ ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ಉಲ್ಲ್ಯಾ ಫಾರಿಜೆವಾನಿ “ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಕರುಚೆ ನ್ಹಯ್ ಮನುನ್ ಅಮ್ಚೊ ಖಾಯ್ದೊ ಸಾಂಗಲ್ಲೆ ತುಮಿ ಕಶ್ಯಾಕ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ತನ್ನಾ ಜೆಜುನ್ “ಅಪ್ನಾಕ್ ಅನಿ ತೆಚ್ಯಾ ವಾಂಗಿಯಾಕ್ನಿ ಭುಕ್‍ ಲಾಗಲ್ಲ್ಯಾ ತನ್ನಾ ದಾವಿದಾನ್ ಕಾಯ್ ಕರ್‍ಲ್ಯಾನ್ ಮನುನ್ ತುಮಿ ವಾಚ್ವುಕ್‍ನ್ಯಾಶಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ, ಯಾಜಕಾನಿ ಸೊಡುನ್ ಅನಿ ಕೊನ್ಬಿ ಖಾವ್ಕ್ ಪರ್ವಾನ್ಗಿ ನಸ್ಲ್ಯಾರ್‍ಬಿ ತೊ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಗೆಲೊ, ಅನಿ ದೆವಾಕ್ ಭೆಟ್ವಲ್ಲ್ಯಾ ಭಾಕ್ರಿಯಾ ತೆನಿ ಹಾನುನ್ ಖಾಲ್ಯಾನ್, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಿಯಾಕ್ನಿಬಿ ದಿಲ್ಯಾನ್”, ಮನುನ್ ತೆಂಕಾ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ಅನಿ ಜೆಜುನ್ ತೆಂಕಾ “ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಸಬ್ಬತಾಚೊಬಿ ಧನಿ” ಮನುನ್ ಸಾಂಗಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ಅನಿ ಎಕ್ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಜೆಜು ಎಕ್ ಸಿನಾಗೊಗಾತ್ ಗೆಲೊ, ಅನಿ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುಲ್ಯಾನ್. ಥೈ ಉಜ್ವ್ಯಾ ಹಾತಿಕ್ ವಾರೆಮಾರಲ್ಲೊ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ಉಲ್ಲೆ ಫಾರಿಜೆವ್, ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲೆ ಜೆಜುಕ್ ಸಿರ್ಕುನ್ ಘಾಲುಕ್ ಎಕ್ ಅವ್ಕಾಸ್ ಹುಡ್ಕುಕ್ ಲಾಗಲ್ಲೆ, ತೆನಿ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಜೆಜು ತ್ಯಾ ಹಾತಾಕ್ ವಾರೆಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಗುನ್ ಕರ್‍ತಾ ಕಾಯ್ ಬಗುವಾ ಮನುನ್ ರಾಕುನ್ಗೆತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ಖರೆ ಜೆಜುಕ್ ತೆನಿ ಯವಜಲ್ಲೆ ಕಳ್ಳೆ, ಅನಿ ತೆನಿ ತ್ಯಾ ಮಾನ್ಸಾಕ್ “ಉಟ್, ಅನಿ ಹಿಕ್ಡಿ ಫಿಡೆ ಯೆ”, ಮಟ್ಲ್ಯಾನ್, ತೊ ಮಾನುಸ್ ಉಟ್ಲೊ, ಅನಿ ಫಿಡೆ ಯೆವ್ನ್ ಇಬೆ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಕಾಯ್-ಕಾಯ್ ಕರುಕ್ ಹೊತಾ ಮನುನ್ ಅಮ್ಚೊ ಖಾಯ್ದೊ ಸಾಂಗ್ತಾ? ಎಕ್ಲ್ಯಾಚೊ ಜಿವ್ ಹುರ್‍ವುಚೊ ಕಾಯ್, ಹಾಳ್ ಕರುಚೊ ಮನ್ತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ಜೆಜುನ್ ಭೊತ್ಯಾನಿ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ತ್ಯಾ ಹಾತಾಕ್ ವಾರೆಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ “ತುಜೊ ಹಾತ್ ಲಾಂಬ್ ಸೊಡ್” ಮಟ್ಲ್ಯಾನ್. ತೆನಿ ತೆಚೊ ಹಾತ್ ಲಾಂಬ್ ಸೊಡ್ಲ್ಯಾನ್, ಅನಿ ತೆಚೊ ಹಾತ್ ಬರೊ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ಫಾರಿಜೆವಾಕ್ನಿ ಅನಿ ಖಾಯ್ದೆ ಸಿಕ್ವುತಲ್ಯಾಕ್ನಿ ರಾಗ್ ಯೆಲೊ, ಅನಿ ತೆನಿ ಅಪ್ನಾ-ಅಪ್ನಾ ಮದ್ದಿಚ್ ಜೆಜುಕ್ ಕಾಯ್ ಕರುಂವಾ? ಮನುನ್ ಬೊಲುನ್ ಘೆವ್ಕ್ ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ಎಕ್ ದಿಸ್ ಜೆಜು ಮಾಗ್ನಿ ಕರುಕ್ ಮನುನ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಗೆಲೊ, ಅನಿ ಪುರಾ ರಾತ್ ತೆನಿ ದೆವಾಕ್ಡೆ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ದಿಸ್ ಉಜ್ವಾಡಲ್ಲ್ಯಾ ತನ್ನಾ ಅಪ್ನಾಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಶಿಸಾಕ್ನಿ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್ ಅನಿ ಅಪೊಸ್ತಲಾ ಮನುನ್ ನಾವ್ ದಿಲ್ಲ್ಯಾ ಬಾರಾ ಜಾನಾಕ್ನಿ ತೆನಿ ಎಚುನ್ ಕಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ತೆಂಚಿ ನಾವಾ - ಸಿಮಾವ್ ಹೆಕಾ ತೆನಿ ಪೆದ್ರು ಮನುನ್ ನಾವ್ ದಿಲ್ಯಾನ್ ಅನಿ ತೆಚೊ ಭಾವ್ ಅಂದ್ರು; ಜಾಕೊಬ್ ಅನಿ ಜುವಾಂವ್, ಫಿಲಿಪ್ ಅನಿ ಬಾರ್‍ತೊಲೊಮೆವ್, ");
INSERT INTO kans_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ಮಾತೆವ್ ಅನಿ ಥೊಮಸ್, ಅಲ್ಫೆವಾಚೊ ಲೆಕ್ ಜಾಕೊಬ್,ಅನಿ ದೆಸ್‍ಭಕ್ತ್ ಮನುನ್ ಬಲ್ವುತಲೊ ಸಿಮಾವ್, ");
INSERT INTO kans_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ಜಾಕೊಬಾಚೊ ಲೆಕ್ ಜುದಾಸ್, ಅನಿ ಜೆಜುಕ್ ಘಾತ್ ಕರಲ್ಲೊ ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತ್. ");
INSERT INTO kans_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ಜೆಜು ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಡ್ಡಿ ವೈನಾ ಖಾಲ್ತಿ ಯೆವ್ನ್,ಸಪಾಟ್ ಜಿಮ್ನಿರ್ ಅಪ್ನಾಚ್ಯಾ ಹುರಲ್ಲ್ಯಾ ಲೈ ಜಾನಾ ಶಿಸಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಇಬೆ ಹೊತ್ತೊ. ಜುದೆಯಾತ್ನಾ ಅನಿ ಜೆರುಜಲೆಮಾತ್ನಾ ಅನಿ ತಿರ್ ಅನಿ ಸಿದೊನ್ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾತ್ಲ್ಯಾ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆಚ್ಯಾ ಜಾಗ್ಯಾನಿತ್ನಾ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾಂಚೊ ಎಕ್ ಮೊಟೊ ತಾಂಡೊ ಥೈ ಯೆವ್ನ್ ಗೊಳಾ ಹೊಲ್ಲೊ ಹೊತ್ತೊ; ");
INSERT INTO kans_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ತೆನಿ, ಜೆಜುನ್ ಸಿಕ್ವುತಲೆ ಆಯ್ಕುಕ್, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ರೊಗಾನಿತ್ನಾ ಬರೆ ಹೊವ್ಕ್ ಮನುನ್ ಥೈ ಯೆಲ್ಲ್ಯಾನಿ. ಗಿರೆ ಲಾಗುನ್ ತರಾಸ್ ಕರುನ್ ಘೆಟಲ್ಲಿ ಲೊಕಾಬಿ ಯೆಲಿ, ಅನಿ ಬರಿ ಹೊವ್ನ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ಸಗ್ಳಿ ಲೊಕಾ ತೆಕಾ ಆಪಡ್ತಲೊ ಅವ್ಕಾಸ್ ಹುಡ್ಕಿತ್, ಅನಿ ಜೆಜುಚಿ ತಾಕತ್ ಭಾಯ್ರ್ ಜಾಯ್, ಅನಿ ಅಪಡಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಗುನ್ ಕರಿ. ");
INSERT INTO kans_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಬಗಟ್ಲ್ಯಾನ್ ಅನಿ, ಗರಿಬಾನೊ ತುಮಿ ಸುಖಿ; ದೆವಾಚೊ ರಾಜ್ ತುಮ್ಚೊಚ್! ");
INSERT INTO kans_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ಅತ್ತಾ ಉಪ್ಪಾಸಿ ಹೊತ್ತ್ಯಾನೊ ತುಮಿ ಸುಖಿ; ತುಮ್ಕಾ ಭರ್‍ಪುರ್ ಗಾವ್ತಾ! ಅತ್ತಾ ರಡ್ತಲ್ಯಾನೊ ತುಮಿ ಕವ್ಡೆ ಸುಖಿ; ತುಮಿ ಹಾಸ್ತ್ಯಾಶಿ! ");
INSERT INTO kans_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಲಾಗುನ್ ಲೊಕಾನಿ ತುಮ್ಕಾ ದ್ವೆಸ್ ಕರ್ಲ್ಯಾರ್, ಮರ್ಯಾದ್ ದಿನಸ್ಲ್ಯಾರ್, ತುಮ್ಚಿ ಮರ್ಯಾದ್ ಕಾಡ್ಲ್ಯಾರ್, ಅನಿ ತುಮಿ ವಾಯ್ಟ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾರ್ ತುಮಿ ಕವ್ಡೆ ಸುಖಿ!” ");
INSERT INTO kans_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ಅಶೆ ತುಮ್ಕಾ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಕುಶಿ ಹೊವಾ ಅನಿ ನಾಚಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸರ್‍ಗಾರ್ ಮೊಟೆ ಭೊಮಾನ್ ತುಮ್ಕಾ ತಯಾರ್ ಹಾಯ್. ತೆಂಚ್ಯಾ ವಾಡ್ ವಡ್ಲಾನಿಬಿ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಅಸೆಚ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“ಖರೆ ಅತ್ತಾ ಸಾವ್ಕಾರ್‍ಕಿನ್ ಜಿವನ್ ಕರ್‍ತಲ್ಯಾನೊ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು; ತುಮ್ಚೆ ಸುಖಾಚೆ ಜಿವನ್ ತುಮ್ಕಾ ಗಾವುನ್ ಹೊಲೆ! ");
INSERT INTO kans_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ಅತ್ತಾ ಖಾವ್ಕ್-ಜೆವ್ಕ್ ಸಗ್ಳೆ ಹೊತ್ತ್ಯಾನೊ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು; ತುಮಿ ಉಪ್ಪಾಸಿ ಪಡ್ತ್ಯಾಶಿ! ಅತ್ತಾ ಹಾಸುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾನೊ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು; ತುಮಿ ಮರ್‍ಗುನ್-ಮರ್‍ಗುನ್ಗೆತ್ ರಡ್ತ್ಯಾಶಿ! ");
INSERT INTO kans_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“ಸಗ್ಳಿ ಲೊಕಾ ತುಮ್ಚ್ಯಾ ಬರೆಪಾನಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲ್ತಲ್ಯಾನೊ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು; ತೆಂಚ್ಯಾ ಅದ್ಲ್ಯಾ ವಾಡ್ ವಡ್ಲಾನಿ ಝುಟ್ಯಾ ಪ್ರವಾದ್ಯಾಕ್ನಿಬಿ ತಸೆಚ್ ಬರೆ-ಬರೆ ಬೊಲಲ್ಲ್ಯಾನಿ”. ");
INSERT INTO kans_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ಮಿಯಾ ಸಾಂಗ್ತಲೆ ಆಯಿಕ್ತಲ್ಯಾನೊ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ: ತುಮ್ಚ್ಯಾ ದುಸ್ಮಾನಾಚೊ ಪ್ರೆಮ್ ಕರಾ,ತುಮ್ಚೆ ವರ್‍ತಿ ರಾಗಾನ್ ರ್‍ಹಾತಲ್ಯಾಕ್ನಿ ಬರೆ ಕರಾ, ");
INSERT INTO kans_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ತುಮ್ಚ್ಯಾ ವರ್‍ತಿ ಸರಾಪ್ ಘಾಲ್ತಲ್ಯಾಕ್ನಿ ತುಮಿ ಆಶಿರ್ವಾದ್ ದಿವಾ, ಅನಿ ತುಮ್ಕಾ ವಾಯ್ಟ್ ಕರ್‍ತಲ್ಯಾಂಚ್ಯಾಸಾಟ್ನಿ ಮಾಗ್ನಿ ಕರಾ. ");
INSERT INTO kans_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ಕೊನ್ ತರ್ ತುಮ್ಚ್ಯಾ ಎಕ್ ಗಾಲಾ ವರ್‍ತಿ ಮಾರ್‍ಲ್ಯಾರ್ ಅನಿ ಎಕ್ ಗಾಲಾ ವರ್‍ತಿ ತೆಕಾ ಮಾರುಕ್ ಸೊಡಾ; ಕೊನ್ ತರ್ ತುಮ್ಚಿ ವೈಲಿ ಅಂಗಿ ಕಾಡುನ್ ಘೆವ್‍ಲಾಲ್ಯಾರ್, ತುಮ್ಚಿ ಭುತ್ತುರ್ಲಿ ಅಂಗಿಬಿ ತೆಕಾ ನ್ಹೆವ್ಕ್ ಸೊಡಾ. ");
INSERT INTO kans_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ತುಮ್ಚೆಕ್ಡೆ ಕಾಯ್ಬಿ ಉಸ್ನೆ ಮಾಗ್ತಲ್ಯಾಕ್ನಿ ದಿವಾ,ಅನಿ ತುಮ್ಚೆಕ್ನಾ ಕೊನ್ಬಿ ಕಾಯ್ತರ್ ಉಸ್ನೆ ಘೆಟಲ್ಲೆ ರ್‍ಹಾಲ್ಯಾರ್ ಪರ್‍ತುನ್ ಮಾಗುನ್ ಘೆವ್‍ನಕಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ದುಸ್ರ್ಯಾನಿ ತುಮ್ಕಾ ಕಶೆ ಕರುಚೆ ಮನುನ್ ತುಮಿ ಯವಜ್ತ್ಯಾಶಿ ತಸೆಚ್ ತುಮಿಬಿ ದುಸ್ರ್ಯಾಕ್ನಿ ಕರಾ”. ");
INSERT INTO kans_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ತುಮ್ಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಲ್ಯಾಂಚೊ ಎವ್ಡೊಚ್ ತುಮಿ ಪ್ರೆಮ್ ಕರ್‍ಲ್ಯಾರ್, ತುಮ್ಕಾ ಕಸ್ಲೊ ಆಶಿರ್ವಾದ್ ಗಾವ್ತಾ? ಪಾಪಿ ಲೊಕಾಬಿ ಅಪ್ನಾಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಲ್ಯಾಂಚೊ ಪ್ರೆಮ್ ಕರ್‍ತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ಅನಿ ತುಮ್ಕಾ ಬರೆ ಕರ್‍ತಲ್ಯಾಕ್ನಿ ಎವ್ಡೆಚ್ ತುಮಿ ಬರೆ ಕರ್‍ಲ್ಯಾರ್, ತುಮ್ಕಾ ಕಸ್ಲೊ ಆಶಿರ್ವಾದ್ ಗಾವ್ತಾ? ಪಾಪಿ ಲೊಕಾಬಿ ಹೆ ಸಗ್ಳೆ ಕರ್‍ತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ಅನಿ ತುಮ್ಕಾ ಪರ್‍ತುನ್ ಫಾಟಿ ದಿತಲ್ಯಾಕ್ನಿ ತುಮಿ ರಿನ್ ದಿಲ್ಯಾರ್ ತುಮ್ಕಾ ಕಸ್ಲೊ ಆಶಿರ್ವಾದ್ ಗಾವ್ತಾ? ಅಪ್ನಿ ದಿಲ್ಲೆ ತವ್ಡೆ ಪರ್‍ತುನ್ ಅಪ್ನಾಕ್ ಗಾವ್ತಾ ಮನ್ತಲ್ಯಾ ಬರೊಸ್ಯಾನ್ ಪಾಪಿ ಲೊಕಾಬಿ ಲೊಕಾಕ್ನಿ ರಿನ್ ದಿತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ತುಮ್ಚ್ಯಾ ದುಸ್ಮಾನಾಂಚೊ ಪ್ರೆಮ್ ಕರಾ ಅನಿ ತೆಂಕಾ ಬರೆ ಕರಾ; ಪರ್‍ತುನ್ ಅನಿ ಘೆತಲಿ ಆಸ್ಯಾ ನಸ್ತಾನಾ ರಿನ್ ದಿವಾ, ತನ್ನಾ ತುಮ್ಕಾ ಭೊಮಾನ್ ಗಾವ್ತಾ, ಅನಿ ತುಮಿ ಲೈ ಮೊಟ್ಯಾ ದೆವಾಚಿ ಪೊರಾ ಹೊತ್ಯಾಶಿ. ತೆಕಾ ಪಾಪಿ ಅನಿ ಬುರ್ಶಿ ಲೊಕಾಬಿ ಬರಿಚ್. ");
INSERT INTO kans_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ತುಮ್ಚೊ ಸರ್‍ಗಾ ವೈಲೊ ಬಾಬಾ ಕಸೊ ದಯಾ ದಾಕ್ವುನಾರೊ ತಸೆ ತುಮಿಬಿ ದಯಾ ದಾಕ್ವುತಲಿ ಲೊಕಾ ಹೊವಾ”. ");
INSERT INTO kans_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ದುಸ್ರ್ಯಾಂಚಿ ನಿತ್ ಕರುನಕಾಸಿ,ಅನಿ ದೆವ್‍ಬಿ ತುಮ್ಚಿ ನಿತ್ ಕರಿನಾ.ದುಸ್ರ್ಯಾಕ್ನಿ ಚುಕಿದಾರ್ ಮನುನ್ ಸಾಂಗುನಕಾಸಿ, ಅನಿ ದೆವ್ ತುಮ್ಕಾಬಿ ಚುಕಿದಾರ್ ಮನಿನಾ; ದುಸ್ರ್ಯಾಕ್ನಿ ಮಾಪ್ ಕರಾ, ಅನಿ ದೆವ್ ತುಮ್ಕಾಬಿ ಮಾಪ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ದುಸ್ರ್ಯಾಕ್ನಿ ದಿವಾ,ಅನಿ ದೆವ್ ತುಮ್ಕಾ ದಿತಾ.ಹೆಚ್ಯಾ ಬದ್ಲಾಕ್, ಮಾಪ್ ಭರುನ್ ತುಮ್ಕಾ ದಿವ್ನ್ ಹೊತಾ,ತುಮ್ಚ್ಯಾ ಪೊಶಾತ್ ಭರುನ್ ಪಡಿಸರ್ಕೆ ತುಮ್ಕಾ ಗಾವ್ತಾ, ಖಲ್ಯಾ ಮಾಪಾನ್ ತುಮಿ ದುಸ್ರ್ಯಾಕ್ನಿ ದಿತ್ಯಾಶಿ ತ್ಯಾಚ್ ಮಾಪಾನ್ ದೆವ್ ತುಮ್ಕಾ ಮೆಜುನ್ ದಿತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ಮಾನಾ ಜೆಜುನ್ ತೆಂಕಾ ಹಿ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್; ಎಕ್ ಕುಡ್ಡ್ಯಾನ್ ಅನಿಎಕ್ ಕುಡ್ಡ್ಯಾಕ್ ವಾಟ್ ದಾಕ್ವುಕ್ ಹೊಯ್ನಾ; ತೆನಿ ತಸೆ ಕರ್ಲ್ಯಾರ್, ದೊಗೆ ಜಾನಾಬಿ ಖಡ್ಡ್ಯಾತ್ ಪಡ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ಎಕ್ ಸಾಳ್ ಶಿಕ್ನಾರೊ ಮಾಸ್ತರಾಚ್ಯಾನ್ಕಿ ಮೊಟೊ ನ್ಹಯ್; ಖರೆ ಸಗ್ಳೆ ಸಾಳ್ ಶಿಕ್ತಲೆ ಶಿಕುನ್ ಮಾಸ್ತರಾ ಸರ್ಕೆ ಗುರುಜಿ ಹೊತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“ತಿಯಾ ತುಜ್ಯಾ ಡೊಳ್ಯಾತ್ನಿ ಹೊತ್ತೊ ಮೊಟೊ ನಾಕ್ಡಾಚೊ ತುಕ್ಡೊ ಬಗಿನಸ್ತಾನಾ,ತುಜ್ಯಾ ಭಾವಾಚ್ಯಾ ಡೊಳ್ಯಾತ್ಲೊ ಬಾರಿಕ್ಲೊ ಕಚ್ರೊ ಕಶ್ಯಾಕ್ ಬಗುಕ್ ಜಾತೆ? ");
INSERT INTO kans_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ಅಶೆ ರಾತಾನಾ ತುಜ್ಯಾ ಡೊಳ್ಯಾತ್ಲೊ ಮೊಟೊ ನಾಕ್ಡಾಚೊ ತುಕ್ಡೊ ತುಕಾ ದಿಸಿನಾ ತರ್ ಭಾವಾ ತುಜ್ಯಾ ಡೊಳ್ಯಾತ್ಲೊ ಕಚ್ರೊ ಕಾಡುಂವಾ ಯೆ ಮನುನ್ ತಿಯಾ ಕಶೆ ಮನುಕ್ ಹೊತಾ? ಕುಸ್ಡ್ಯಾ! ಅದ್ದಿ ತುಜ್ಯಾ ಡೊಳ್ಯಾತ್ ಹೊತ್ತೊ ಮೊಟೊ ತುಕ್ಡೊ ಕಾಡುನ್ ಘೆ, ಮಾನಾ ತುಜ್ಯಾ ಭಾವಾಚ್ಯಾ ಡೊಳ್ಯಾತ್ಲೊ ಕಚ್ರೊ ತುಕಾ ಬರೊ ದಿಸ್ತಾ ತನ್ನಾ ತೊ ತುಕಾ ಕಾಡುಕ್ ಹೊತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ಎಕ್ ಬರೆ ಝಾಡ್ ಬುರ್ಶಿ ಫಳಾ ದಿ ನಾ,ಅನಿ ಎಕ್ ಬುರ್ಶೆ ಝಾಡ್ ಬರಿ ಫಳಾ ದಿ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ಫಳಾಕ್ನಿ ಬಗುನುಚ್ ಝಾಡ್ ಕಸ್ಲೆ ಮನುನ್ ಕಳುನ್ ಯೆತಾ; ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಅಂಜುರಾಚಿ ಫಳಾ ಗಾವಿನ್ಯಾತ್, ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ದರಾಕ್ಷಿಚಿ ಹನ್ನಾ ಗಾವಿನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ಎಕ್ ಬರೊ ಮಾನುಸ್ ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ ಗೊಳಾ ಕರುನ್ ಥವಲ್ಲೆ ಬರೆಚ್ ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ನಾ ಭಾಯ್ರ್ ಕಾಡ್ತಾ, ಎಕ್ ಬುರ್ಸೊ ಮಾನುಸ್ ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ ಗೊಳಾ ಕರುನ್ ಥವಲ್ಲೆ ಬುರ್ಶೆಚ್ ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ನಾ ಭಾಯ್ರ್ ಕಾಡ್ತಾ. ಜೆ ಕಾಯ್ ಮನಾತ್ ಹಾಯ್ ತೆಚ್ ತೊಂಡಾತ್ನಾ ಭಾಯ್ರ್ ಯೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ಮಿಯಾ ಸಾಂಗಲ್ಲೆ ತುಮಿ ಕರಿನ್ಯಾಶಿ, ಅನಿ ಮಾಕಾ ಧನಿ, ಧನಿ ಮನುನ್ ಕಶ್ಯಾಕ್ ಬಲ್ವುತ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ಕೊನ್ಬಿ ಎಕ್ಲೊ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆತಾ ಅನಿ ಮಿಯಾ ಸಾಂಗಟಲ್ಲೆ ಆಯಿಕ್ತಾ ಅನಿ ಮಾಜ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಖಾಲ್ತಿ ಹೊತಾ ತೊ ಕೊನ್ ಮನುನ್ ಮಿಯಾ ದಾಕ್ವುನ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ತೊ ಎಕ್ ಘರ್ ಭಾಂದ್ತಲ್ಯಾ ಮಾನ್ಸಾ ಸರ್ಕೊ ತೊ ಅಪ್ನಾಚ್ಯಾ ಘರಾಚಿ ಪಾಯಾ ಖೊಲ್ ಖಂಡ್ತಾ ಅನಿ ಗುಂಡ್ಯಾ ವರ್‍ತಿ ಪಾಯಾ ಭರ್‍ತಾ. ನ್ಹಯ್ ಭರುನ್ ಯೆತಾ, ಅನಿ ಪಾನಿ ತ್ಯಾ ಘರಾಕ್ ಯೆವ್ನ್ ಮಾರ್‍ತಾ ಖರೆ ತೆ ಘರ್ ಹಾಲಿನಾ,ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆ ಘರ್ ಘಟ್ಮುಟ್ ಗುಂಡ್ಯಾಚ್ಯಾ ವರ್‍ತಿ ಭಾಂದಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ಖರೆ ಮಿಯಾ ಸಾಂಗಟಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುನ್ ತೆಚೆ ಸಾರ್ಕೆ ಚಲಿನಸಲ್ಲೊ ಪಾಯಾ ಭರಿನಸ್ತಾನಾ ಮಾಟಿ ವರ್‍ತಿ ಘರ್ ಭಾಂದ್ತಲ್ಯಾ ಮಾನ್ಸಾ ಬಾಸೆನ್,ನ್ಹಯ್ ಭರುನ್ ಪಾನಿ ಯೆತಾ ಅನಿ ತ್ಯಾ ಘರಾಕ್ ಮಾರ್‍ತಾ ಅನಿ ತೆ ಘರ್ ಕೊಸ್ಳುನ್ ಪಡುನ್ ಜಾತಾ ಅನಿ ಸಗ್ಳೆಚ್ ನಾಸ್ ಹೊವ್ನ್ ಜಾತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ಜೆಜುನ್ ಹೆ ಸಗ್ಳೆ ಲೊಕಾಕ್ನಿ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ತೊ ಕಪರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ಎಕ್ ರೊಮಾಚ್ಯಾ ಶತಪತಿಚೊ ಖಾಸ್ ಆಳ್ ಹೊತ್ತೊ, ತೊ ಸಿಕ್ ಪಡುನ್ ಮರ್‍ತಲ್ಯಾ ಪರಿಸ್ತಿರ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ತ್ಯಾ ಶತಪತಿನ್ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ, ಉಲ್ಲ್ಯಾ ಜುದೆವ್ ಲೊಕಾಂಚ್ಯಾ ಜಾನ್ತ್ಯಾಕ್ನಿ, ತ್ಯಾ ಆಳಾಕ್ ಯೆವ್ನ್ ಬರೆ ಕರ್ ಮನುನ್ ಇಚಾರುಕ್, ಜೆಜುಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ತೆನಿ ಜೆಜುಕ್ಡೆ ಯೆಲ್ಯಾನಿ ಅನಿ, “ಹ್ಯೊ ಮಾನುಸ್ ತಿಯಾ ಲೈ ಆದಾರ್ ದಿವ್ಕ್ ಯೊಗ್ಯ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್,ತೊ ಅಮ್ಚ್ಯಾ ಲೊಕಾಂಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ, ಅನಿ ತೆನಿ ಅಪ್ನಿಚ್ ಅಮ್ಕಾ ಎಕ್ ಸಿನಾಗೊಗ್ ಭಾಂದುನ್ ದಿಲ್ಯಾನಾಯ್”. ಮನುನ್ ಮಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ತನ್ನಾ ಜೆಜು ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲೊ. ಜೆಜು ಘರಾಕ್ನಾ ಉಲ್ಲೆ ಧುರುಚ್ ರಾತಾನಾ, ತ್ಯಾ ಶತಪತಿನ್ ಅಪ್ನಾಚ್ಯಾ ಲೊಕಾನಿಕ್ನಾ “ಗುರುಜಿ, ತಿಯಾ ಮಾಜ್ಯಾ ಘರಾಕ್ ಯೆತಲೊ ತರಾಸ್ ಕರುನ್ ಘೆವ್‍ನಕ್ಕೊ, ತಿಯಾ ಮಾಜ್ಯಾ ಘರಾಕ್ ಯೆಯ್ ಸರ್ಕಿ ಯೊಗ್ಯತಾ ಮಾಕಾ ನಾ ");
INSERT INTO kans_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ಅನಿ ಮಾಕಾ,ತುಜ್ಯಾ ಇದ್ರಾಕ್ ಯೆಯ್ ಸಾರ್ಕಿ ಕಿಮ್ಮತ್‍ಬಿ ನಾ, ತಿಯಾ ಥೈತ್ನಾಚ್ ಎಕ್ ಗೊಸ್ಟ್ ಸಾಂಗ್ಲ್ಯಾರ್ ಫಿರೆ, ತೊ ಆರಾಮ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮಿಯಾಬಿ ಮಾಜ್ಯಾನ್ ಮೊಟ್ಯಾಂಚ್ಯಾ ಅದಿಕಾರಾಚ್ಯಾ ಖಾಲ್ತಿ ಹಾಂವ್, ಅನಿ ಮಾಜ್ಯಾ ಹಾತಿ ಖಾಲ್ತಿಬಿ ಸೈನಿಕಾ ಹಾತ್,ಎಕ್ಲ್ಯಾಕ್ ಮಿಯಾ ಜಾ! ಮಟ್ಲ್ಯಾರ್, ತೊ ಜಾತಾ, ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ಯೆ! ಮಟ್ಲ್ಯಾರ್, ತೊ ಯೆತಾ; ಅನಿ ಆಳಾಕ್ನಿ ಹೆ ಕರಾ ಮಟ್ಲ್ಯಾರ್, ತೆನಿ ಕರ್‍ತ್ಯಾತ್” ಮನುನ್ ಸಾಂಗುನ್ ಧಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ಹೆ ಆಯ್ಕುನ್ ಜೆಜು ಅಜಾಪ್ ಹೊಲೊ; ತೊ ಫಾಟಿ ಪರತ್ಲೊ, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಫಾಟ್ನಾ ಯೆತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ “ಅಸ್ಲೊ ವಿಶ್ವಾಸ್ ಮಾಕಾ ಇಸ್ರಾಯೆಲಾತ್ ಖೈಬಿ ಗಾವುಕ್ನಾ!” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ಜೆಜುಕ್ ಸಾಂಗುಕ್ ಯೆಲ್ಲಿ ಲೊಕಾ ಘರಾಕ್ ಪರ್ತುನ್ ಜಾಯ್‍ ಪತರ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ಸೆವಕ್ ಆರಾಮ್ ಹೊಲ್ಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ಮಾನಾ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ಅನಿ ಮೊಟ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ವಾಂಗ್ಡಾ ನಾಯಿನ್ ಮನ್ತಲ್ಯಾ ಎಕ್ ಗಾಂವಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ಜೆಜು ತ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ಯೆಶಿತ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ಲೊಕಾ ಎಕಾ ಮಾನ್ಸಾಕ್ ಮಾಟಿ ದಿವ್ಕ್ ಮನುನ್ ಗಾವಾತ್ನಾ ಭಾಯ್ರ್ ಯೆವ್‍ಲಾಗಲ್ಲಿ. ಮರಲ್ಲೊ ಮಾನುಸ್ ಎಕ್ ಘೊಮರಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಚೊ ಎಕ್ಲೊಚ್ ಲೆಕ್, ಗಾವಾತ್ಲ್ಯಾ ಲೊಕಾಂಚೊ ಮೊಟೊ ತಾಂಡೊ ತಿಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ಜೆಜುನ್ ತಿಕಾ ಬಗಟಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುಕ್ ತಿಚೊ ಪಾಪ್‍ ದಿಸ್ಲೊ, ಅನಿ ತೆನಿ ತಿಕಾ ರಡುನಕೊ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ತನ್ನಾ ಜೆಜು ಫಿಡೆ ಗೆಲೊ, ಅನಿ ಮರ್‍ನಾಚ್ಯಾ ಪೆಟಿಕ್ ಅಪಡ್ಲ್ಯಾನ್, ತನ್ನಾ ಪೆಟಿ ವಾವುನ್ ಘೆಟಲ್ಲಿ ಲೊಕಾ ಇಬೆ ರ್‍ಹಾಲಿ, ತನ್ನಾ ಜೆಜುನ್ “ದಾಂಡ್ಗ್ಯಾ ಮಾನ್ಸಾ, ಮಿಯಾ ತುಕಾ ಸಾಂಗ್ತಾ ವೈರ್ ಉಟ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ಮರಲ್ಲೊ ಮಾನುಸ್ ಉಟುನ್ ಬಸ್ಲೊ, ಅನಿ ಬೊಲುಕ್‍ಲಾಲೊ, ಜೆಜುನ್ ತೆಕಾ ತೆಚ್ಯಾ ಬಾಯ್ಕ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ಹೆ ಬಗುನ್ ಸಗ್ಳೆಜಾನ್ ಭಿಂವ್ನ್ ಗೆಲೆ ಅನಿ ತೆನಿ ದೆವಾಕ್ ಹೊಗ್ಳುನ್ಗೆತ್. “ಎಕ್ ಮೊಟೊ ಪ್ರವಾದಿ ಅಮ್ಚ್ಯಾ ಮದ್ದಿ ಯೆಲಾ! ದೆವ್ ಅಪ್ನಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಹುರ್ವುನ್ ಘೆವ್ಕ್ ಮನುನ್ ಯೆಲಾ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ಹಿ ಜೆಜುಚಿ ಖಬರ್, ಅನಿ ಜುದೆಯಾ ಪ್ರಾಂತ್ಯಾತ್ ಅನಿ ಸಗ್ಳ್ಯಾ ದೆಸಾತ್ ಜಾವ್ನ್ ಪಾವ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ಜುವಾಂವಾಚ್ಯಾ ಶಿಸಾನಿ, ತೆಕಾ ಸಗ್ಳಿ ಹಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ತೆನಿ ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ದೊಗ್ಯಾಕ್ನಿ ಬಲ್ವುನ್, ಜೆಜುಕ್ಡೆ ಜಾವ್ನ್ “ಜುವಾಂವಾನ್ ಯೆತಲೊ ಹಾಯ್, ಮನುನ್ ಸಾಂಗಲ್ಲೊ ತಿಯಾಚ್ ಕಾಯ್, ಅಮಿ ಅಜುನ್ ಕೊನಾಚಿ ವಾಟ್ ರಾಕುಚೆ?” ಮನುನ್ ಇಚಾರಾ ಮನುನ್ ಸಾಂಗುನ್ ಧಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ತೆನಿ ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್, “ಜುವಾಂವ್ ಬಾವ್ತಿಸಾನ್ ಅಮ್ಕಾ ಯೆತಲೊ ಹಾಯ್ ಮನುನ್ ಸಾಂಗಲ್ಲೊ ತಿಯಾಚ್ ಕಾಯ್, ಅನಿ ದುಸ್ರ್ಯಾಚಿ ವಾಟ್ ಬಗುಚಿ? ಮನುನ್ ಇಚಾರುನ್ ಸಾಂಗುನ್ ಧಾಡ್ಲ್ಯಾನಾಯ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ತನ್ನಾಚ್ ಜೆಜುನ್ ಸುಮಾರ್ ಲೊಕಾಂಚಿ ದುಕ್ನಿ, ರೊಗಾ ಆರಾಮ್ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ಗಿರೆ ಸೊಡ್ವುಲ್ಯಾನ್,ಅನಿ ಸುಮಾರ್ ಕುಡ್ಡ್ಯಾಕ್ನಿ ಡೊಳೆ ದಿಸಿ ಸರ್ಕೆ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ಜೆಜುನ್ ಜುವಾಂವಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ “ಜಾಂವಾ, ಅನಿ ಹಿತ್ತೆ ಬಗಟಲ್ಲೆ, ಅನಿ ಆಯ್ಕಲ್ಲೆ, ಜುವಾಂವಾಕ್ ಸಾಂಗಾ: ಕುಡ್ಡೆ ಬಗ್ತ್ಯಾತ್, ಸೊಟ್ಟೊ ಚಲ್ತಾ, ಕುಸ್ಟ್ ರೊಗ್ ಹೊತ್ತೆ ಪವಿತ್ರ್ ಹೊತ್ಯಾತ್, ಕಿಂವ್ಡೆ ಆಯಿಕ್ತ್ಯಾತ್, ಮರಲ್ಲೆ ಝಿತ್ತೆ ಹೊತ್ಯಾತ್, ಅನಿ ಗರಿಬಾಕ್ನಿ ಬರಿ ಖಬರ್ ಸಾಂಗುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಸಂಶೆವ್‍ ನಸಲ್ಲ್ಯಾಂಚೆ ಕವ್ಡೆ ಬರೆ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ಜುಂವಾವಾಚಿ ಶಿಸಾ ಪರ್ತುನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುನ್ ಜುವಾಂವಾಚ್ಯಾ ವಿಶಯಾತ್ ಲೊಕಾನಿಕ್ಡೆ ಬೊಲುಕ್ ಚಾಲು ಕರ್‍ಲ್ಯಾನ್: ತುಮಿ ಹಾಳ್‍ ಜಾಗ್ಯಾರ್ ಜುವಾಂವಾಕ್ ಮಿಳುಕ್‍ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಕಾಯ್ ಬಗುಕ್ ಮನುನ್ ಗೆಲ್ಲ್ಯಾಶಿ? ಎಕ್ ಕರಾಡಾಚಿ ಕಾಡಿ ವಾರ್ಯಾಕ್ ಬಾಗ್ತಲೆ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ಕಾಯ್ ಬಗುಕ್ ಗೆಲ್ಲ್ಯಾಶಿ, ತುಮಿ? ಬರೆ ಕರುನ್ ನೆಸಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಬಗುಕ್ ಗೆಲ್ಲ್ಯಾಶಿ? ತಸೆ ಬರೆ ನೆಸುನ್, ಆರಾಮಾಚೆ ಜಿವನ್ ಕರ್‍ತಲಿ ಲೊಕಾ ರಾಜಾಂಚ್ಯಾ ಘರಾತ್ನಿ ಗಾವ್ತ್ಯಾತ್! ");
INSERT INTO kans_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ಸಾಂಗಾ ಮಾಕಾ, ಕಾಯ್ ಬಗುಕ್ ತುಮಿ ಗೆಲ್ಲ್ಯಾಶಿ? ಎಕ್ ಪ್ರವಾದಿ? ಹೊಯ್, ರಾವ್ಕ್ ಫಿರೆ, ಖರೆ ತುಮಿ ಪ್ರವಾದ್ಯಾಚ್ಯಾನ್ಕಿ ಮೊಟೆ ಬಗಟ್ಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ “ತುಕಾ ವಾಟ್ ತಯಾರ್ ಕರುಕ್ ಮನುನ್, ಮಾಜ್ಯಾ ಖಬರ್ ದಿತಲ್ಯಾಕ್ ಮಿಯಾ ತುಜ್ಯಾ ಫಿಡೆ ಧಾಡ್ತಾ”. ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಜುವಾಂವಾಚ್ಯಾ ವಿಶಯಾತುಚ್. ");
INSERT INTO kans_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಹ್ಯಾ ಜಗಾತ್ ಜಿವನ್ ಕರಲ್ಲ್ಯಾತ್ನಿ ಜುವಾಂವ್ ಸಗ್ಳ್ಯಾಂಚ್ಯಾನ್ಕಿ ಮೊಟೊ. ಖರೆ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ಲೊ ಎಗ್ದಮ್ ಬಾರಿಕ್ಲೊಬಿ ಜುವಾಂವಾನ್ಕಿ ಮೊಟೊ”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ತೆಕಾ ಆಯ್ಕಲ್ಲೆ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ, ಅನಿ ತ್ಯಾತುರುಚ್ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲಿ ಲೊಕಾ, ದೆವಾಚ್ಯಾ ಬರ್‍ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಖಾಲ್ತಿ ಹೊಲ್ಯಾನಿ, ಅನಿ ಜುವಾಂವಾಕ್ನಾ ಬಾಲ್ತಿಮ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ಖರೆ ಫಾರಿಜೆವಾನಿ, ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾನಿ, ಅಪ್ನಾಸಾಟ್ನಿಚ್ ಮನುನ್ ಹೊತ್ತ್ಯಾ ದೆವಾಚ್ಯಾ ಯವ್ಜನ್ಯಾಕ್ನಿ, ತೆನಿ ಮರ್ಯಾದ್‍ ದಿವ್ಕನ್ಯಾತ್, ಅನಿ ಜುಂವಾವಾಕ್ನಾ ಬಾಲ್ತಿಮ್ ಘೆವ್ಕ್ ನಕ್ಕೊ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ಮಾನಾ ಜೆಜುನ್ “ಅತ್ತಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಮಿಯಾ ಕೆಕಾ ಸಮಾ ಕರು? ತೆನಿ ಕಾಚೆ ಸರ್ಕೆ ಹಾತ್?” ");
INSERT INTO kans_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ತೆನಿ, ಬಾಜಾರಾತ್ ಬಸಲ್ಲ್ಯಾ ಪೊರಾಂಚ್ಯಾ ಬಾಸೆನ್, ಎಕ್ ಪೊರಾಂಚೊ ಗುಂಪೊ, ಅನಿಎಕ್ ಗುಂಪ್ಯಾಕ್ ಬಲ್ವುನ್ಗೆತ್ “ಅಮಿ ತುಮ್ಚ್ಯಾಸಾಟ್ನಿ ಲಗ್ನಾಚೆ ವಾಜಾಪ್ ವಾಜ್ವುಲಾವ್, ಖರೆ ತುಮಿ ನಾಚುಕನ್ಯಾಶಿ! ಅಮಿ ಮಾಟಿ ದಿತಲ್ಯಾ ಗಿತಾ ಮಟ್ಲಾಂವ್, ಖರೆ ತುಮಿ ರಡುಕ್ನ್ಯಾಶಿ! ");
INSERT INTO kans_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ಜುವಾಂವ್ ಬಾವ್ತಿಸ್ ಯೆಲೊ, ಅನಿ ತೆನಿ ಭಾಕ್ರಿ ಖಾವ್ಕ್; ನಾ, ಅನಿ ನಿಶೆಚೆ ಕಾಯ್ಬಿ ಫಿವ್ಕ್ ನಾ. ತೆಕಾ ತುಮಿ ಗಿರೊಲಾಗ್ಲಾ! ಮಟ್ಲ್ಯಾಶಿ”. ");
INSERT INTO kans_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆಲೊ, ಅನಿ ತೆನಿ ಖಾಲ್ಯಾನ್, ಅನಿ ಫಿಲ್ಯಾನ್, ಅನಿ ತುಮಿ “ಭಕಾಸುರ್, ಅನಿ ಫಿದೊಡೊ,ಅನಿ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲ್ಯಾಂಚೊ, ಅನಿ ಪಾಪಿ ಲೊಕಾಂಚೊ ವಾಂಗ್ಡಿ!” ಮಟ್ಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“ಖರೆ ದೆವಾಚಿ ಬುದ್ವಂತ್ಕಿ ಜೆ ಕೊನ್ ಮಾನುನ್ ಘೆತ್ಯಾತ್, ತೆಂಕಾ ಖರೆ ಕಾಯ್ ಮನುನ್ ಕಳ್ವುನ್ ಘೆವ್ಕ್ ಹೊತಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ಎಕ್ ಫಾರಿಜೆವಾನ್ ಜೆಜುಕ್ ಅಪ್ನಾಚ್ಯಾ ಘರಾತ್ ಜೆವ್ನಾಕ್ ಬಲ್ವುಲ್ಯಾನ್, ಜೆಜು ತೆಚ್ಯಾ ಘರಾಕ್ ಗೆಲೊ, ಅನಿ ಜೆವ್ನಾಕ್ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ತ್ಯಾ ಶಾರಾತ್ ಪಾಪಾಚೆ ಜಿವನ್ ಕರ್‍ತಲಿ ಎಕ್ ಬಾಯ್ಕೊಮನುಸ್ ಹೊತ್ತಿ. ಜೆಜು ಫಾರಿಜೆವಾಚ್ಯಾ ಘರಾತ್ ಜೆವ್ನಾಕ್ ಬಸ್ಲಾ ಮನುನ್ ಆಯಿಕ್ಲಿನ್, ತಸೆ ಮನುನ್ ಎಕ್ ಭರ್‍ನಿಬರ್ ಬರಿ ವಾಸ್ ಎತಲೆ ತೆಲ್ ಘೆವ್ನ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ಅನಿ ಜೆಜುಚ್ಯಾ ಪಾಯಾನಿಕ್ನಿ ಬಸ್ಲಿ, ರಡುನ್ಗೆತ್ ದುಖಾನಿ ತೆಚೆ ಪಾಯ್ ಬಿಜ್ವುಲಿನ್, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಕೆಸಾನಿ ಪಾಯಾ ಪುಸ್ಲಿನ್. ಅನಿ ಪಾಯಾಂಚಿ ಉಪ್ಪಾ ಘೆಟ್ಲಿನ್, ಅನಿ ತೆ, ಬರ್‍ಯಾ ವಾಸೆಚೆ ತೆಲ್, ಜೆಜುಚ್ಯಾ ಪಾಯಾ ವಯ್ನಿ ವೊತ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ತ್ಯಾ ಫಾರಿಜೆವಾನ್ ಹೆ ಬಗುನ್, ಅಪ್ಲ್ಯಾ ಅಪ್ನಿಚ್ “ಹ್ಯೊ ಮಾನುಸ್ ಖರೆಚ್ ಪ್ರವಾದಿ ಹೊಲ್ಯಾರ್,ತೆಕಾ ಅಪಡಲ್ಲಿ ಬಾಯ್ಕೊಮನುಸ್ ಕೊನ್; ಅನಿ ಹಿ ಬಾಯ್ಕೊಮನುಸ್ ಕಸ್ಲೆ ಪಾಪಾಚೆ ಜಿವನ್ ಕರ್‍ತಾ ಮನುನ್, ಹೆಕಾ ಕಳ್ತಲೆ ಹೊತ್ತೆ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ಜೆಜುನ್ ತೆಕಾ “ಸಿಮಾವ್, ಮಿಯಾ ತುಕಾ ಕಾಯ್ಕಿ ಸಾಂಗುಕ್ ಪಾಜೆ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ “ಸಾಂಗ್ ಧನಿಯಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ತನ್ನಾ ಜೆಜುನ್ “ದೊಗೆ ಜಾನಾ ರಿನ್ಕಾರಿ ಹೊತ್ತೆ, ತೆನಿ ರಿನ್ ಫೆಡ್ತಲೆ ಹೊತ್ತೆ. ಎಕ್ಲ್ಯಾನ್ ಪಾಸ್ಸೆ ಚಾಂದಿಚೆ ಪೈಸೆ ದಿತಲೆ ಹೊತ್ತೆ, ಅನಿ ಅನಿ ಎಕ್ಲ್ಯಾನ್ ಪನ್ನಾಸ್ ಚಾಂದಿಚೆ ಪೈಸೆ ದಿತಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ತೆಂಕಾ ದೊಗ್ಯಾಕ್ನಿಬಿ ತೆಂಚೆ ರಿನ್ ಫೆಡುಕ್ ಹೊವ್ಕ್ ನಾ. ತಸೆಮನುನ್ ತ್ಯಾ ರಿನ್ ದಿಲ್ಲ್ಯಾನ್, ತೆಂಚೆ ರಿನ್ ಸುಟ್ ಕರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ಹ್ಯಾ ದೊಗ್ಯಾನಿತ್ಲೊ ಕೊನ್ ತೆಚೊ ಜಾಸ್ತಿಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ತನ್ನಾ ಸಿಮಾವಾನ್ “ಮಾಕಾ ದಿಸ್ತಾ, ಲೈ ರಿನ್ ಫೆಡ್ತಲೆ ಹೊತ್ತೊ ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಜೆಜುನ್ “ಸಮಾ ಸಾಂಗ್ಲೆ ತಿಯಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ಮಾನಾ ತೊ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ಡೆ ಪರತ್ಲೊ, ಅನಿ ಸಿಮಾವಾಕ್ “ಹ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ತಿಯಾ ಬಗುಲೆ ಕಾಯ್? ಮಿಯಾ ತುಜ್ಯಾ ಘರಾಕ್ ಯೆಲೊ, ಖರೆ ತಿಯಾ ಮಾಕಾ ಪಾಯ್ ಧುವ್ಕ್ ಪಾನಿ ದಿವ್ಕ್ ನ್ಹೈಯ್, ಖರೆ ತೆನಿ ತಿಚ್ಯಾ ದುಕ್ಕಾನಿ ಮಾಜೆ ಪಾಂಯೆ ಧುಲಿನ್, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಕೆಸಾನಿ ತೆನಿ ಮಾಜೆ ಪಾಯ್ ಪುಸ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ತಿಯಾ ಮಾಕಾ ಉಪ್ಪಾ ದಿವ್ನ್ ಘರಾತ್ ಸ್ವಾಗತ್ ಕರುಕ್ನೆಯ್, ಖರೆ ತೆನಿ ಯೆಲ್ಲ್ಯಾಕ್ನಾ ಮಾಜ್ಯಾ ಪಾಂಯಾಕ್ನಿ ಉಪ್ಪಾ ದಿತಲೆ ಸೊಡುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ಮಾಜ್ಯಾ ಟಕ್ಲ್ಯಾಕ್ ತಿಯಾ ತೆಲ್ ಲಾವುಕ್ನೆಯ್, ಖರೆ ತೆನಿ ಮಾಜ್ಯಾ ಪಾಯಾ ವೈನಿ, ಬರೆ ವಾಸ್ ಯೆತಲೆ ಮ್ಹಾಗ್ರೆ ತೆಲ್ ವೊತ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ತಸೆ ಮನುನ್ ಮಿಯಾ ತುಕಾ ಸಾಂಗ್ತಾ, ತೆನಿ ದಾಕ್ವಲ್ಲೊ ಹ್ಯೊ ಮೊಟೊ ಪ್ರೆಮ್, ತೆನಿ ಕರಲ್ಲಿ ಸುಮಾರ್ ಪಾಪಾ ಮಾಪ್ ಹೊಲಿ ಮನುನ್ ದಾಕ್ವುತಾ. ಕಮಿ ಪಾಪಾಂಚಿ ಮಾಪಿ ಗಾವಲ್ಲೊ, ಕಮಿ ಪ್ರೆಮ್ ದಾಕ್ವುತಾ”. ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ತನ್ನಾ ಜೆಜುನ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ “ತುಜೆ ಸಗ್ಳೆ ಪಾಪ್ ಮಾಪ್ ಹೊಲೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ತನ್ನಾ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವ್ನಾಕ್ ಬಸಲ್ಲೆ ತೆಂಚ್ಯಾ-ತೆಂಚ್ಯಾ ಮದ್ದಿ “ಪಾಪ್ ಸೈತ್ ಮಾಪ್ ಕರ್‍ತಲೊ ಮಾನುಸ್, ಹ್ಯೊ ಕೊನ್ ಅಸಿಲ್‍ ಅಪ್ಪಾ?” ಮನುಕ್‍ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ಖರೆ ಜೆಜುನ್ ತ್ಯಾ ಬಾಯ್ಕೊಮಾನ್ಸಿಕ್ “ತುಜ್ಯಾ ವಿಶ್ವಾಸಾನ್ ತುಕಾ ಬಚಾವ್ ಕರ್‍ಲ್ಯಾನ್; ಸಮಾದಾನಾನ್ ಜಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ಉಲ್ಲ್ಯಾ ಎಳಾಚ್ಯಾ ಮಾನಾ, ಜೆಜು ಗಾಂವಾತ್ನಿ, ಅನಿ ಬಾರಿಕ್ಲ್ಯಾ ಗಾಂವಾತ್ನಿ ದೆವಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುನ್ಗೆತ್ ಗೆಲೊ, ತೆಚಿ ಬಾರಾ ಶಿಸಾಬಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ಅನಿ ಜೆಜುನ್ ಗಿರೆ ಸೊಡ್ವಲ್ಲ್ಯಾ ಅನಿ ಆರಾಮ್ ಕರಲ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ತೆಂಚ್ಯಾತ್ಲಿ ಎಕ್ಲಿ: ಮಾಗ್ದೆಲಿನಾ ಮನುನ್ ಬಲ್ವುತಲಿ ಮರಿ,ಜೆಜುನ್ ಹಿಚ್ಯಾ ಆಂಗಾತ್ನಾ ಸಾತ್ ಗಿರೆ ಕಾಡಲ್ಲ್ಯಾನ್; ");
INSERT INTO kans_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ಅನಿ ಜೊನ್ನಾ ಹಿಚೊ ಘೊ ಖುಜಾ ಮನ್ತಲೊ ಹೆರೊದಾಚ್ಯಾ ಘರಾತ್ ಎಕ್ ಅದಿಕಾರಿ ಹೊವ್ನ್ ಹೊತ್ತೊ, ಅನಿ ಸುಸಾನ್ನಾ, ಅನಿ ಸುಮಾರ್ ಬಾಯ್ಕಾಮನ್ಸಾ ಅಪ್ನಾಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಪೈಶಾನಿ, ಜೆಜುಕ್ ಅನಿ ಶಿಸಾಕ್ನಿ ಮಜತ್ ಕರಿತ್. ");
INSERT INTO kans_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ಲೊಕಾ ಎಕ್ಲ್ಯಾಚ್ಯಾ ಫಾಟ್ನಾ ಎಕ್ಲೊ ಶಾರಾತ್ನಾ ಜೆಜುಕ್ಡೆ ಯೆವ್ನ್ಗೆತುಚ್ ಹೊತ್ತಿ.ಅನಿ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಥೈ ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆಂಕಾ ಜೆಜುನ್ ಹಿ ಕಾನಿ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ಎಗ್ದಾ ಎಕ್ ಮಾನುಸ್ ಘವಾಚೆ ಭ್ಹಿಂಯ್, ಪೆರುಕ್ ಗೆಲೊ.ತೊ ಶೆತಾತ್ ಭ್ಹಿಂಯ್ ಸಿಪಡ್ತಾನಾ,ತ್ಯಾತುರ್‍ಲೆ ಉಲ್ಲೆ, ವಾಟೆಚ್ಯಾ ದಂಡೆರ್ ಪಡ್ಲೆ,ತೆ ಉಲ್ಲೆ ಭ್ಹಿಂಯ್ ಲೊಕಾಂಚ್ಯಾ ಪಾಂಯಾತ್ನಿ ಗಾವ್ಲೆ, ಅನಿ ಫಾಂಕ್ರಾನಿ ಯೆವ್ನ್ ತೆ ಖಾವ್ನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ತ್ಯಾತುರ್‍ಲೆ ಅನಿ ಉಲ್ಲೆ ಗುಂಡಾಡ್ ಜಿಮ್ನಿ ವರ್‍ತಿ ಪಡ್ಲೆ, ಅನಿ ಝಾಡಾ ವಾಳುನ್ ಗೆಲಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಥೈ ಥಂಡ್ ಕಮಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ಅನಿ ಉಲ್ಲೆ ಭ್ಹಿಂಯ್ ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಪಡ್ಲೆ ಕಾಟ್ಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾಚ್ ತೆ ಭ್ಹಿಂಯ್ ಉಗ್ವುನ್ ಮೊಟೆ ಹೊವ್ನ್ ಯೆಲೆ, ಖರೆ ಕಾಟ್ಯಾನಿ ತ್ಯಾ ಝಾಡಾಕ್ನಿ ಅಡ್ವುನ್ ಧರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ಅನಿ ಉಲ್ಲೆ ಭ್ಹಿಂಯ್ ಬರ್‍ಯಾ ಮಾಟಿತ್ ಪಡ್ಲೆ ಝಾಡಾ ಮೊಟಿ ಹೊಲಿ, ಅನಿ ಸೆಂಬರ್ ವಾಟ್ಯಾನಿ ಫಳ್ ದಿಲ್ಯಾನಿ” “ತುಮ್ಕಾ ಆಯ್ಕುಕ್ ಮನ್ ರ್‍ಹಾಲ್ಯಾರ್ ಆಯ್ಕಾ?” ಮನುನ್ ಸಾಂಗುನ್ ಕಾನಿ ಮುಗಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ಹ್ಯಾ ಕಾನಿಚೊ ಅರ್ತ್‍ ಕಾಯ್ ಮನುನ್ ಶಿಸಾನಿ ಜೆಜುಕ್ ಇಚಾರ್‍ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ತನ್ನಾ ಜೆಜುನ್ “ದೆವಾಚ್ಯಾ ರಾಜಾಚೊ ಘುಟಾಚಿ ಸಮ್ಜನ್ ತುಮ್ಕಾ ಎವ್ಡೆಚ್ ದಿಲ್ಲೆ ಹಾಯ್. ಖರೆ ದುಸ್ರ್ಯಾಕ್ನಿ ತೊ ಘುಟ್ ಕಾನಿಯಾಂಚ್ಯಾ ವೈನಾಚ್ ಸಾಂಗುನ್ ಹೊತಾ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಬಗ್ತ್ಯಾತ್, ಖರೆ ತೆಂಕಾ ದಿಸಿನಾ, ಅನಿ ಆಯಿಕ್ತ್ಯಾತ್, ಖರೆ ತೆಂಕಾ ಕಾಯ್ಬಿ ಕಳಿನಾ”. ");
INSERT INTO kans_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ಜೆಜುನ್ “ಹ್ಯಾ ಕಾನಿಚೊ ಅರ್ತ್‍ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್: ಭ್ಹಿಂಯ್ ಮಟ್ಲ್ಯಾರ್ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ. ");
INSERT INTO kans_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ವಾಟೆಚ್ಯಾ ದಂಡೆಕ್ ಪಡಲ್ಲ್ಯಾ ಭ್ಹಿಂಯಾ ಮಟ್ಲ್ಯಾರ್ ಲೊಕಾ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತ್ಯಾತ್: ಖರೆ ಗಿರೊ ತೆಂಚ್ಯಾ ಮನಾತ್ನಾ ತ್ಯಾ ಗೊಸ್ಟಿಯಾ ಕಾಡುನ್ ಘೆವ್ನ್, ಅಶೆ ತೆಂಕಾ ವಿಶ್ವಾಸಾತ್ನಾ, ಅನಿ ಸುಟ್ಕಾ ಹೊತಲ್ಯಾತ್ನಾ ಧುರ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ಗುಂಡಾಡ್ ಜಮ್ನಿ ವರ್‍ತಿ ಪಡಲ್ಲೆ ಭ್ಹಿಂಯ್ ಮಟ್ಲ್ಯಾರ್, ಜಿ ಲೊಕಾ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತ್ಯಾತ್, ಅನಿ ಕುಶಿನ್ ಅಪ್ನಾಚ್ಯಾ ಮನಾತ್ ಥವ್ನ್ ಘೆತ್ಯಾತ್, ಖರೆ ತ್ಯಾ ಗೊಸ್ಟಿಯಾ ತೆಂಚ್ಯಾ ಮನಾತ್ ಎಗ್ದಮ್ ಭುತ್ತುರ್ ಗೆಲ್ಲ್ಯಾ ರಾಯ್ನ್ಯಾತ್. ತೆನಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತ್ಯಾತ್ ಹೊಯ್ ಖರೆ ಕಾಯ್,ತರ್ ಕಸ್ಟ್ ಯೆಲೊ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ತ್ಯಾ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಸೊಡುನ್ ಸೊಡ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಪಡಲ್ಲೆ ಭ್ಹಿಂಯ್ ಮಟ್ಲ್ಯಾರ್, ಜಿ ಲೊಕಾ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತ್ಯಾತ್, ಖರೆ ತೆಂಚ್ಯಾ ಯವ್ಜನ್ಯಾ ಅನಿ ಪಯ್ಸ್ಯಾಂಚಿ ಆಶಾ, ಅನಿ ಹ್ಯಾ ಜಿವನಾಚ್ಯಾ ಯವ್ಜನ್ಯಾ, ತ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ದಡ್ಪುನ್ ಧರ್‍ತ್ಯಾತ್, ಅನಿ ತೆಂಕಾ ಫಳ್ ದಿವ್ಕ್ ದಿನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ಖರೆ, ಬರ್‍ಯಾ ಮಾಟಿತ್ ಪಡಲ್ಲೆ ಭ್ಹಿಂಯ್ ಮಟ್ಲ್ಯಾರ್, ಜಿ ಲೊಕಾ, ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಆಯಿಕ್ತ್ಯಾತ್, ಅನಿ ಬರ್‍ಯಾ ಮನಾನ್ ತೆ ಮಾನುನ್ ಘೆತ್ಯಾತ್, ಅನಿ ಫಳ್ ದಿ ಪತರ್ ತೆನಿ ತಿ, ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಂಬಾಳುನ್ ಥವ್ನ್ ಘೆತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ಲೊಕಾ ದಿವೊ ಪೆಟ್ವುನ್ ಭೊಗುನ್ಯಾಚ್ಯಾ ಬುಡಿ ಧಾಪುನ್ ಥೈನ್ಯಾತ್, ನಾ ಹೊಲ್ಯಾರ್, ನಿಜ್ತಲ್ಯಾ ಮಾಚೊಳಿಚ್ಯಾ ಬುಡಿ ಥೈನಾತ್, ಘರಾತ್ ಭುತ್ತುರ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಲೊಕಾಕ್ನಿ ಉಜ್ವೊಡ್ ದಿಸುಕ್ ಪಾಜೆ ಮನುನ್ ದಿವೊ ಥವ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ವೈರ್ ಥವ್ತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“ಜೆ ಕಾಯ್ ನಿಪ್ವುನ್ ಥವಲ್ಲೆ ಹಾಯ್ ತೆ ಭಾಯ್ರ್ ಉಗ್ಡುನ್ ಥವ್ನ್ ಹೊತಾ,ಅನಿ ಜೆ ಕಾಯ್ ಧಾಪುನ್ ಥವಲ್ಲೆ ತೆ ಗಾವ್ತಾ, ಅನಿ ಉಗ್ಡುನ್ ಭಾಯ್ರ್ ಹಾನುನ್ ಹೊತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ತೆಚೆಸಾಟ್ನಿ, “ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ ಅನಿ ಬರೆ ಕರುನ್ ಆಯ್ಕಾ; ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಕೊನಾಕ್ಡೆ ಕಾಯ್ತರ್ ಉಲ್ಲೆಸೆ ಹಾಯ್ ತೆಕಾ ಜಾಸ್ತಿಚೆ ದಿವ್ನ್ ಹೊತಾ, ಖರೆ ಕೊನಾಕ್ಡೆ ಉಲ್ಲೆಸೆಬಿ ನಾ, ತೆಚೆಕ್ಲೆ ಅಸಲ್ಲೆಬಿ ಉಲ್ಲೆಸೆ ಕಾಡುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ಜೆಜುಚಿ ಬಾಯ್ ಅನಿ ಭಾವಾ ಜೆಜುಕ್ಡೆ ಯೆಲ್ಲ್ಯಾನಿ, ಖರೆ ಲೊಕಾಂಚ್ಯಾ ದಾಟ್ನಿತ್ ತೆಂಕಾ ಜೆಜುಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ಕ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ಕೊನ್ಕಿ ಎಕ್ಲ್ಯಾನ್ ಜೆಜುಕ್ “ತುಜಿ ಬಾಯ್ ಅನಿ ಭಾವಾ ಭಾಯ್ರ್ ಇಬೆ ರ್‍ಹಾಲ್ಯಾತ್, ಅನಿ ತುಜಿ ವಾಟ್ ರಾಕುಲ್ಯಾತ್”. ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ “ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತ್ಯಾತ್, ಅನಿ ತಸೆಚ್ ಚಲ್ತ್ಯಾತ್, ತೆನಿ ಮಾಜಿ ಬಾಯ್, ಅನಿ ಮಾಜಿ ಭಾವಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ಎಕ್ ದಿಸ್ ಜೆಜು ಎಕ್ ಢೊನಿತ್ ಚಡ್ಲೊ ಅನಿ ತೆಚಿ ಶಿಸಾಬಿ ಚಡ್ಲಿ ತನ್ನಾ ತೆನಿ ಶಿಸಾಕ್ನಿ “ಅಮಿ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಜಾಂವ್ವಾ” ಮಟ್ಲ್ಯಾನ್ ತನ್ನಾ ತೆನಿ ಜಾವ್ಕ್ ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ತೆನಿ ಜಾವ್ನಗೆತ್ ರಾತಾನಾ ಜೆಜುಕ್ ನಿಜ್‍ಲಾಗ್ಲಿ ತನ್ನಾ ಸಮುಂದರಾತ್ ಎಗ್ದಮ್ ಮೊಟೊ ವಾರೊ ಉಟ್ಲೊ, ಅನಿ ಢೊನಿತ್ ಪಾನಿ ಭರುಕ್‍ಲಾಲೆ,ಅಶೆ ತೆನಿ ಮೊಟ್ಯಾ ಅಪಾಯಾತ್ ಪಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ತನ್ನಾ ಶಿಸಾ ಜೆಜುಕ್ ಗೆಲಿ ಅನಿ ತೆಕಾ ಉಟ್ವುನ್ “ಗುರುಜಿ, ಗುರುಜಿ, ಅಮಿ ಬುಡುನ್ ಮರ್‍ತಾಂವ್?” ಮನುಲಾಲೆ. ತನ್ನಾ ಜೆಜು ಉಟ್ಲೊ, ಅನಿ ವಾರ್ಯಾಕ್, ಅನಿ ಲ್ಹಾಟಾಕ್ನಿ ತೆನಿ ಹುಕುಮ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ವಾರೊ ಅನಿ ಲ್ಹಾಟಾ ಗಪ್ ರ್‍ಹಾಲಿ, ಅನಿ ಸಗ್ಳೆ ಎಗ್ದಮ್ ಶಾಂತ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ತನ್ನಾ ತೆನಿ ಶಿಸಾಕ್ನಿ “ತುಮ್ಚೊ ವಿಶ್ವಾಸ್ ಖೈ ಗೆಲೊ?” ಮನುನ್ ಮಟ್ಲ್ಯಾನ್. ಖರೆ ತೆನಿ ಭಿಂಯಾಲೆ, ಅನಿ ಅಜಾಪ್ ಹೊಲೆ, ಅನಿ “ಹ್ಯೊ ಕಸ್ಲೊ ಮಾನುಸ್? ವಾರ್ಯಾಕ್ ಅನಿ ಲ್ಹಾಟಾಕ್ನಿ ತೊ ಹುಕುಮ್ ದಿತಾ ಅನಿ ತೆನಿ ಹೆನಿ ಸಾಂಗಟಲ್ಲೆ ಆಯಿಕ್ತ್ಯಾತ್ ಮನುನ್ ಅಪ್ನಾ-ಅಪ್ನಾಚ್ಯಾ ಮದ್ದಿಚ್” ಬೊಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ಜೆಜು ಅನಿ ಶಿಸಾ ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾತ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಹೊತ್ತ್ಯಾ ಗೆರಸೆನಾಂಚ್ಯಾ ಜಾಗ್ಯಾರ್ ಯೆವ್ನ್ ಪಾವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ಜೆಜು ಢೊನಿತ್ನಾ ದಂಡೆಕ್ ಉತರಲ್ಲ್ಯಾ ತನ್ನಾಚ್, ತ್ಯಾ ಗಾಂವಾತ್ಲ್ಯಾ ಗಿರೆ ಲಾಗಲ್ಲ್ಯಾ ಎಕ್ ಮಾನ್ಸಾಕ್ ತೊ ಭೆಟ್ಲೊ. ಲೈ ದಿಸಾಕ್ನಾ ತೊ ಮಾನುಸ್ ಆಂಗಾರ್ ಕಪ್ಡೆನಸ್ತಾನಾ ಫಿರಿ, ಅನಿ ಘರಾತ್ ರೈನಸಿ, ಲೊಕಾಕ್ನಿ ಮಾಟಿ ದಿತಲ್ಯಾ ಢೊಂಬಾತ್ನಿಚ್ ತೊ ರೈ. ");
INSERT INTO kans_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ತೆನಿ ಜೆಜುಕ್ ಬಗಟಲ್ಲ್ಯಾ ತನ್ನಾ, ಮೊಟ್ಯಾನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್, ಅನಿ ಜೆಜುಚ್ಯಾ ಪಾಂಯಾತ್ನಿ ಪಡುನ್ ಜೆಜುಕ್, “ಜೆಜು ಮೊಟ್ಯಾ ದೆವಾಚ್ಯಾ ಲೆಕಾ! ಮಾಜೆಕ್ನಾ ತುಕಾ ಕಾಯ್ ಪಾಜೆ ಹೊಲಾ? ಮಾಕಾ ಶಿಕ್ಷಾ ದಿವ್‍ನಕೊ ಮನುನ್ ಮಿಯಾ ತುಜೆಕ್ಡೆ ಮಾಗ್ನಿ ಕರ್‍ತಾ” ಮನುನ್ ಬೊಬ್ ಮಾರುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್,ಜೆಜುನ್ ತೆಕಾ ತ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಆಂಗಾತ್ನಾ ಭಾಯ್ರ್ ಪಡ್ ಮನುನ್ ಹುಕುಮ್ ದಿಲ್ಲ್ಯಾನ್. ತಸೆ ಮನುನ್ ತೊ ತಸೆ ಮನುಲಾಗಲ್ಲೊ. ಲೊಕಾನಿ ಲೈಂದಾ ತೆಕಾ ಧರುಕ್ ಪ್ರಯತ್ನ್ ಕರಲ್ಲ್ಯಾನಿ. ಅನಿ ಬಂಧಿಖಾನ್ಯಾತ್ ಥವ್ಕ್ ಬಗಟಲ್ಲ್ಯಾನಿ, ಸರ್‍ಪೊಳ್ಯಾನಿ ಹಾತಾ-ಪಾಯಾ ಭಾಂದುಕ್ ಬಗಟಲ್ಲ್ಯಾನಿ, ಖರೆ ತೊ ಸರ್ಪೊಳ್ಯಾ ತೊಡುನ್ ಟಾಕಿ, ಅನಿ ತೊ ಗಿರೊ ತೆಕಾ ಹಾಳ್ ಡಂಗ್ಳಿತ್ ಜಯ್‌ ಸರ್ಕೆ ಕರಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ಜೆಜುನ್ ತೆಕಾ “ತುಜೆ ನಾವ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ “ಮಾಜೆ ನಾವ್ ಸೈತಾನಾಂಚೊ ತಾಂಡೊ” ಮಟ್ಲ್ಯಾನ್ ತೆಚ್ಯಾ ಆಂಗಾತ್ ಲೈ ಗಿರೆ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ಗಿರ್‍ಯಾನಿ ಅಪ್ನಾಕ್ ಪಾತಾಳಾಕ್ ಧಾಡುನಕ್ಕೊ, ಮನುನ್ ಜೆಜುಕ್ಡೆ ಮಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ಥೈ ಜಗ್ಗೊಳುಚ್ ಎಕ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಡುಕ್ರಾಂಚೊ ಎಕ್ ಮೊಟೊ ಹಿಂಡ್ ಚರುಕ್ ಲಾಗಲ್ಲೊ. ತ್ಯಾ ಗಿರ್‍ಯಾನಿ ಅಮ್ಕಾ ತ್ಯಾ ಡುಕ್ರಾಂಚ್ಯಾ ಆಂಗಾತ್ನಿ ಜಾವ್ಕ್ ಸೊಡ್ ಮನುನ್ ಮಾಗ್ಲ್ಯಾನಿ. ಜೆಜುನ್ ತೆಂಕಾ, ಜಾವ್ಕ್ ಸೊಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ತೆನಿ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಸೊಡುನ್ ಡುಕ್ರಾತ್ನಿ ಜಾವ್ನ್ ಗುಸ್ಲ್ಯಾನಿ, ಡುಕ್ರಾಂಚೊ ಸಗ್ಳೊ ಹಿಂಡ್ ಮಡ್ಡಿ ವೈನಾ ಪಾನಿಯಾತ್ ಪಡುನ್ ಬುಡುನ್ ಮರುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ಡುಕ್ರಾಕ್ನಿ ರಾಕ್ತಲ್ಯಾನಿ ಕಾಯ್-ಕಾಯ್ ಹೊಲ್ಲೆ ಬಗಟ್ಲ್ಯಾನಿ, ಅನಿ ಶಾರಾತ್ನಿ, ಅನಿ ಶೆತಾತ್ನಿ, ಹೊತ್ತ್ಯಾಕ್ನಿ ಜಾವ್ನ್ ಹಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ಲೊಕಾ ಕಾಯ್ ಹೊಲೆ ಕಾಯ್ ಮನುನ್ ಬಗುಕ್ ಜೆಜು ಹೊತ್ತ್ಯಾಕ್ಡೆ ಯೆಲಿ.ತೆನಿ ಜೆಜುಕ್ಡೆ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ತೊ ಗಿರೊ ಸುಟುನ್ ಬರೊ ಹೊಲ್ಲೊ, ಮಾನುಸ್ ಬರೆ ಕಪ್ಡೆ ನೆಸುನ್, ಬರ್‍ಯಾ ಬುದ್ದಿನ್, ಜೆಜುಚ್ಯಾ ಪಾಂಯಾತ್ನಿ ಬಸಲ್ಲೊ ತೆನಿ ಬಗಟ್ಲ್ಯಾನಿ; ಹೆ ಬಗುನ್ ತೆನಿ ಭಿಂಯಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ತೊ ಗಿರೊಲಾಗಲ್ಲೊ ಮಾನುಸ್ ಕಸೊ ಬರೊ ಹೊಲೊ ಮನುನ್ ಬಗಟಲ್ಲ್ಯಾನಿ, ಸಗ್ಳೆ ಲೊಕಾಕ್ನಿ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ತನ್ನಾ ತ್ಯಾ ಜಾಗ್ಯಾ ವೈಲಿ ಸಗ್ಳಿ ಲೊಕಾ ಜೆಜುಕ್ ಅಮ್ಚೆ ಗಾಂವ್ ಸೊಡುನ್ ಜಾ ಮನುಕ್‍ಲಾಲಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆನಿ ಭಿಂಯಾವಲ್ಲ್ಯಾನಿ, ತಸೆ ಮನುನ್ ಜೆಜು ಢೊನಿತ್ ಚಡ್ಲೊ, ಅನಿ ಜಾವ್ಕಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ಅಪ್ನಾತ್ನಾ ಗಿರೆ ಗೆಲ್ಲೊ ಮಾನುಸ್ ಯೆಲೊ, ಅನಿ “ಮಿಯಾಬಿ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆತಾ” ಮನುನ್ ಜೆಜುಕ್ಡೆ ಮಾಗುಲಾಲೊ. ಜೆಜುನ್ ತೆಕಾ ಪರ್ತುನ್ ಧಾಡ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ಅನಿ “ತುಜ್ಯಾ ಘರಾಕ್ ಜಾ, ಅನಿ ತುಜ್ಯಾ ಘರಾತ್ಲ್ಯಾಕ್ನಿ ದೆವಾನ್ ಕಾಯ್-ಕಾಯ್ ಕರ್‍ಲ್ಯಾನ್ ತೆ ಸಾಂಗ್”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ತೊ ಮಾನುಸ್ ಶಾರಾತ್ ಗೆಲೊ,ಅನಿ ಜೆಜುನ್ ಅಪ್ನಾಕ್ ಕಾಯ್-ಕಾಯ್ ಕರಲ್ಲೆ ಸಗ್ಳೆ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ಜೆಜು ಸಮುಂದರಾಚ್ಯಾ ಅನಿಎಕ್ ದಂಡೆಕ್ ಪರ್ತುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಲೊಕಾನಿ ತೆಕಾ ಸ್ವಾಗತ್ ಕರ್‍ಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆನಿ ತೆಚಿ ವಾಟ್ ರಾಕುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ತನ್ನಾ ಜಾಯಿರ್ ಮನ್ತಲೊ ಎಕ್ ಮಾನುಸ್ ಯೆಲೊ, ತೊ ಥೈತ್ಲ್ಯಾ ಸಿನಾಗೊಗಾಚೊ ಅದಿಕಾರಿ ಹೊವ್ನ್ ಹೊತ್ತೊ; ತೊ ಎಗ್ದಮ್ ಜೆಜುಚ್ಯಾ ಪಾಂಯಾತ್ ಪಡ್ಲೊ, ಅನಿ ಜೆಜುಕ್ ಅಪ್ನಾಚ್ಯಾ ಘರಾಕ್ಡೆ ಯೆ, ಮನುನ್ ಮಾಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆಚಿ ಬಾರಾ ವರ್ಸಾಚಿ ಲೆಕ್ ಮರ್‍ತಲ್ಯಾ ಸ್ಧಿತಿರ್ ಹೊತ್ತಿ, ತನ್ನಾ ಜೆಜು ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾವ್ನಗೆತ್ ಹೊತ್ತೊ, ತನ್ನಾ ಲೊಕಾ ಜೆಜುಚ್ಯಾ ಭೊತ್ಯಾನಿ ಹೊತ್ತಿ, ಅನಿ ಢಕ್ಲಾ-ಢಕ್ಲಿ ಕರಿತ್. ");
INSERT INTO kans_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ತ್ಯಾ ಲೊಕಾತ್ನಿ ಬಾರಾ ವರ್ಸಾಕ್ನಾ ರಗಾತ್ ಜಾತಲ್ಯಾ ರೊಗಾನ್ ತರಾಸ್ ಕರುನ್ ಘೆವ್ನ‍ಗೆತ್ ಹೊತ್ತಿ ಎಕ್ ಬಾಯ್ಕೊಮನುಸ್ ಹೊತ್ತಿ; ತೆನಿ ಅಪ್ನಾಕ್ಡೆ ಹೊತ್ತೆ ಸಗ್ಳೆ ಪೈಸೆ ಸಾರುನ್, ಆರಾಮ್ ಕರ್‍ತಲ್ಯಾಕ್ನಿ ಜಾವ್ನ್ ಬಗಟ್ಲಿನ್, ಖರೆ ಕೊನಾಚ್ಯಾನ್‍ಬಿ ತಿಕಾ ಗುನ್ ಕರುಕ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ತಿ ಜೆಜುಚ್ಯಾ ಫಾಟಿ ಯೆಲಿ ಅನಿ ತೆನಿ ಜೆಜುಚ್ಯಾ ಆಂಗಾ ವೈಲ್ಯಾ ಕಪ್ಡ್ಯಾಚ್ಯಾ ತುದಿಚ್ಯಾ ಘೊಂಡ್ಯಾಕ್ ತೆನಿ ಹಾತ್ ಲಾವ್ಲಿನ್,ತನ್ನಾ ರಗಾತ್ ಜಾತಲೆ ಬಂದ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ಜೆಜುನ್ “ಮಾಕಾ ಕೊನ್ ಹಾತ್ ಲಾವ್ಲೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ಸಗ್ಳೆ ಜಾನಾ ಮಿಯಾ ನ್ಹಯ್- ತಿಯಾ ನ್ಹಯ್, ಮಟ್ಲ್ಯಾನಿ. ತನ್ನಾ ಪೆದ್ರುನ್ “ಗುರುಜಿ, ಲೊಕಾ ತುಜ್ಯಾ ಭೊತ್ಯಾನಿ ಹಾತ್, ಅನಿ ತೆನಿ ತುಜ್ಯಾ ಆಂಗಾರ್ ಪಡುಲ್ಯಾತ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ಖರೆ ಜೆಜುನ್ “ಮಾಕಾ ಕೊನ್‍ ಕಿ ಹಾತ್ ಲಾವ್ಲ್ಯಾನಿ, ಮಾಜಿ ತಾಕತ್ ಭಾಯ್ರ್ ಗೆಲ್ಲಿ ಮಾಕಾ ಕಳ್ಳೆ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ತನ್ನಾ ತಿ ಬಾಯ್ಕೊಮನುಸ್ ಅತ್ತಾ ಅನಿ ಮಾಕಾ ನಿಪುನ್ ರಾವ್ಕ್ ಹೊಯ್ನಾ ಮನುನ್, ಕಾಪುನ್ಗೆತ್ ಜೆಜುಕ್ಡೆ ಯೆಲಿ, ಅನಿ ತೆಚ್ಯಾ ಪಾಂಯಾತ್ ಪಡ್ಲಿ.ಥೈ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ತೆನಿ, ಅಪ್ನಿ ಜೆಜುಕ್ ಕಶ್ಯಾಕ್ ಹಾತ್‍ ಲಾವ್ಲಿನ್, ಅನಿ ಅಪ್ನಿ ಕಶಿ ತಾಬೊಡ್ತೊಬ್ ಆರಾಮ್ ಹೊಲೊ ಮನುನ್ ಸಾಂಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ತನ್ನಾ ಜೆಜುನ್ ತಿಕಾ “ಲೆಕಿ, ತುಜ್ಯಾ ವಿಶ್ವಾಸಾನ್ ತುಕಾ ಬರೆ ಕರ್‍ಲ್ಯಾನ್, ಸಮಾದಾನಾನ್ ಜಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ಜೆಜು ಅಶೆ ಸಾಂಗ್ತಾ-ಸಾಂಗ್ತಾನಾಚ್, ತ್ಯಾ ಅದಿಕಾರ್‍ಯಾ ಘರಾತ್ನಾ ಎಕ್ಲೊ ಖಬರ್ ಘೆವ್ನ್ ಯೆಲೊ, ಅನಿ ಜಾಯಿರಾಕ್ “ತುಜಿ ಲೆಕ್ ಮರ್ಲಿ, ಅನಿಬಿ ತಿಯಾ ಗುರುಜಿಕ್ ತರಾಸ್ ದಿತಲೆ ನಕ್ಕೊ” ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ಖರೆ ಜೆಜುನ್ ಹೆ ಆಯ್ಕುನ್ ಜಾಯಿರಾಕ್ “ಭಿಂವ್‍ನಕೊ; ಖಾಲಿ ವಿಶ್ವಾಸಾನ್ ರ್‍ಹಾ, ತಿ ಬರಿ ಹೊತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ಜೆಜು ಜಾಯಿರಾಚ್ಯಾ ಘರಾಕ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆನಿ ಪೆದ್ರು, ಜುವಾಂವಾಕ್ ಅನಿ ಜಾಕೊಬಾಕ್, ಅನಿ ತ್ಯಾ ಚೆಡ್ವಾಚ್ಯಾ ಬಾಯ್ಕ್ ಅನಿ ಬಾಬಾಕ್ ಸೊಡುನ್ ಕೊನಾಕ್ಬಿ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಭುತ್ತುರ್ ಯೆವ್ಕ್ ಸೊಡುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ಸಗ್ಳೆ ಜಾನಾ ಪೊರಾ ಸಾಟ್ನಿ ತಳ್ಮಳಿತ್, ಅನಿ ರಡಿತ್, ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ರಡುನಕಾಶಿ; ತೆ ಚೆಡು ಮರುಕ್ನಾ, ನಿದ್ಲಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ತೆನಿ ಜೆಜುಕ್ ಹಾಸ್ಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತಿ ಮರ್‍ಲಾ ಮನುನ್ ತೆಂಕಾ ಗೊತ್ತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ಖರೆ ಜೆಜುನ್ ತಿಚೊ ಹಾತ್ ಧರುನ್ “ಲೆಕಿ, ಉಟ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ಎಗ್ದಮ್ ತಿಕಾ ಅನಿ ಪರ್ತುನ್ ಜಿವ್ ಯೆಲೊ,ಅನಿ ಎಗ್ದಮ್ ತಿ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾಲಿ, ಅನಿ ಜೆಜುನ್ ತೆಂಕಾ ತಿಕಾ ಕಾಯ್ ತರ್ ಬಿ ಖಾವ್ಕ್ ದಿವಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ತಿಚೆ ಬಾಯ್-ಬಾಬಾ ಅಜಾಪ್ ಹೊಲೆ, ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ ಹಿತ್ತೆ ಕಾಯ್ ಹೊಲೆ ಮನುನ್ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕಾಶಿ ಮನುನ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ಜೆಜುನ್ ಬಾರಾ ಶಿಸಾಕ್ನಿ ಎಕಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್ ಅನಿ ಗಿರೆ ಕಾಡ್ತಲೊ ಅದಿಕಾರ್ ಅನಿ ಬಳ್ ತೆಂಕಾ ದಿಲ್ಯಾನ್, ಅನಿ ರೊಗಾ ಗುನ್ ಕರ್‍ತಲೊಬಿ ಬಳ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ಮಾನಾ ತೆನಿ ತೆಂಕಾ ದೆವಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಅನಿ ರೊಗಾತ್ನಿ ಹೊತ್ತ್ಯಾಕ್ನಿ ಗುನ್ ಕರುಕ್ ಬಾರಾ ಜಾನಾ ಶಿಸಾಕ್ನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ತೆನಿ ತೆಂಕಾ ಅಶೆ ಸಾಂಗ್ಲ್ಯಾನ್ “ತುಮಿ ಜಾತಾನಾ ವಾಟೆಕ್ ಮನುನ್ ಕಾಯ್ಬಿ ಘೆವ್‍ಕಾಶಿ: ದಾಂಡೊ ಹೊಂವ್ದಿ; ಪಿಸ್ವಿ ಹೊಂವ್ದಿ, ಜೆವಾನ್ ಹೊಂವ್ದಿ,ಪೈಸೆ ಹೊಂವ್ದಿ, ಎಕ್ ಜಾಸ್ತಿಚಿ ಅಂಗಿ ಸೈತ್ ಘೆವ್‍ನಕಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ಖಲ್ಯಾ ಘರಾತ್ ತುಮ್ಕಾ ಸ್ವಾಗತ್ ಕರ್‍ತ್ಯಾತ್, ತೆ ಶಾರ್ ಸೊಡುನ್ ಜಾಯ್ ಪತರ್ ತ್ಯಾಚ್ ಘರಾತ್ ರ್‍ಹಾವಾ: ");
INSERT INTO kans_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ಖೈ ತರ್ ತುಮ್ಕಾ ಸ್ವಾಗತ್ ಕರಿನಸ್ಲ್ಯಾರ್, ತೆ ಶಾರ್ ಸೊಡುನ್ ಚಲಾ. ಜಾತಾನಾ ತುಮ್ಚ್ಯಾ ತಳ್‍ಪಾಯಾಚಿ ಮಾಟಿ ಫಾಪ್ಡಾ, ಹೆ ತೆಂಕಾ ಎಕ್ ಸಾಕ್ಷಿ ಹೊಂವ್ದಿ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ಅಶೆ ಶಿಸಾ ಗೆಲಿ ಅನಿ ಬರಿ ಖಬರ್ ಸಾಂಗುನ್ಗೆತ್ ಅನಿ ಸಗ್ಳ್ಯಾ ಶಿಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಗುನ್ ಕರುನ್ಗೆತ್ ಸಗ್ಳ್ಯಾ ಗಾಂವಾತ್ನಿ ಫಿರ್‍ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ಅಜು-ಬಾಜುನ್ ಹೊತಲ್ಯಾ ಕಾಮಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಆಯ್ಕುನ್, ಗಾಲಿಲಿಯಾಚೊ ಅದಿಕಾರಿ ಹೆರೊದ್ ಲೈ ಗೊಂದಳ್ಳೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಉಲ್ಲಿ ಲೊಕಾ ಜುವಾಂವ್ ಬಾವ್ತಿಸ್ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆಲಾ ಮನುಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ಅನಿ ಉಲ್ಲೆ ಜಾನಾ ಎಲಿಯಾ ಪ್ರವಾದಿ ಮನಿತ್, ಅನಿ ಉಲ್ಲೆಜಾನ್, ಅದ್ಲ್ಯಾ ಪ್ರವಾದ್ಯಾನಿತ್ಲೊ ಎಕ್ಲೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಯೆಲಾ ಮನುಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ಖರೆ ಹೆರೊದಾನ್ “ಜುವಾಂವಾಚೆ ಟಕ್ಲೆ ಮಿಯಾ ತೊಡುಕ್‍ ಲಾವ್ಲಾ; ಖರೆ ಹೆ ಸಗ್ಳೆ ಮಿಯಾ ಆಯಿಕ್ತಲೆ ಖಲ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ವಿಶಯಾತ್?” ಮಟ್ಲ್ಯಾನ್. ಅನಿ ಜೆಜುಕ್ ಬಗುಚೆ ಮನುನ್ ತೊ ಖಟ್ಪಟಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ಅಪೊಸ್ತಲಾ ಪರ್ತುನ್ ಯೆಲಿ, ಅನಿ ಅಪ್ನಿ ಕಾಯ್-ಕಾಯ್ ಕರಲ್ಲೆ ತೆನಿ ಜೆಜುಕ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ಜೆಜುನ್ ತೆಂಕಾ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ತೆನಿ ಬೆತ್ಸಾಯಿದಾ ಮನ್ತಲ್ಯಾ ಶಾರ್ ಗಾಂವಾಕ್ ಪಾಯ್ ವಾಟೆನಿ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ಹೆ ಆಯ್ಕಲ್ಲಿ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಯೆಲಿ. ತೆನಿ ತೆಂಕಾ ಬಲ್ವುಲ್ಯಾನ್, ಅನಿ ದೆವಾಚ್ಯಾ ರಾಜಾಚ್ಯಾ ವಿಶಯಾತ್ ತೆಂಚೆಕ್ಡೆ ಬೊಲ್ಲ್ಯಾನ್. ಅನಿ ಆರಾಮ್ ಹೊತಲಿ ಗರಜ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಆರಾಮ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ದಿಸ್ ಬುಡುಕ್ ಯೆಲ್ಲ್ಯಾತನ್ನಾ ಬಾರಾ ಜಾನಾ ಶಿಸಾ ಜೆಜುಕ್ಡೆ ಗೆಲಿ, ಅನಿ “ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ದಿ, ತೆನಿ ಜಾವ್ನ್ ಗಾಂವಾತ್ನಿ, ಅನಿ ಶೆತಾತ್ನಿ ಅಪ್ನಾಕ್ ಜೆವ್ಕ್ ಅನಿ ರಾವ್ಕ್ ಕಾಯ್ತರ್ ಯವಸ್ತಾ ಕರುನ್ ಘೆಂವ್ದಿತ್, ಅದ್ದಿಚ್ ಹ್ಯೊ ಜಾಗೊ ಬಗಟ್ಲ್ಯಾರ್, ಕಡೆಕ್ ಕಾಡುನ್ ಟಾಕಲ್ಲ್ಯಾ ಸಾರ್ಕೊ ಹಾಯ್”, ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ “ತುಮಿಚ್ ತೆಂಕಾ ಕಾಯ್ತರ್ ಉಲ್ಲೆ ಖಾವ್ಕ್ ದಿವಾ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಶಿಸಾನಿ ತೆಕಾ “ಅಮ್ಚೆಕ್ಡೆ ಖಾಲಿ ಪಾಂಚ್ ಭಾಕ್ರಿಯಾ ಅನಿ ದೊನ್ ಮೊಸೊಳ್ಯಾ ಹಾತ್, ಹ್ಯಾ ಎವ್ಡ್ಯಾ ಮೊಟ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಇಕಾತ್ ಜೆವಾನ್ ಘೆವ್ನ್ ಯೆವ್ಚೆ ಪಡ್ಲೆ, ತಸೆ ಕರುವಾ ಮಟ್ಲೆ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ಥೈ ಜಗ್ಗೊಳ್ ಪಾಚ್ ಹಜಾರ್ ಘೊಮನ್ಸಾಚ್ ಹೊತ್ತಿ, ತನ್ನಾ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ “ಲೊಕಾಕ್ನಿ ಪನ್ನಾಸ್ ಪನ್ನಾಸ್ ಲೊಕಾಂಚಿ ಎಕ್-ಎಕ್ ಸಾಲ್ ಕರುನ್ ಬಸ್ವಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ತೆನಿ ಜೆಜುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಲೊಕಾಕ್ನಿ ಬಸ್ವುಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ಜೆಜುನ್ ಪಾಚ್ ಭಾಕ್ರಿಯಾ ಅನಿ ದೊನ್ ಮೊಸೊಳ್ಯಾ ಘೆಟ್ಲ್ಯಾನ್,ಅನಿ ವೈರ್ ಸರ್‍ಗಾಕ್ ಬಗುನ್ ತೆ ದಿಲ್ಲ್ಯಾಸಾಟ್ನಿ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನ್,ಅನಿ ಮೊಡುನ್ ಲೊಕಾಕ್ನಿ ವಾಟಾ ಮನುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾನಿಕ್ನಿ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ತೆನಿ ಸಗ್ಳ್ಯಾನಿ ಪೊಟ್‍ಭರ್ ಜೆವ್ಲ್ಯಾನಿ, ಅನಿ ಶಿಸಾನಿ ಹುರಲ್ಲೆ ತುಕ್ಡೆ ಗೊಳಾ ಕರ್ಲ್ಯಾರ್, ಬಾರಾ ಭುಟಿಯಾ ಭರ್‍ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ಎಕ್ ದಿಸ್ ಜೆಜು ಎಕ್ಲೊಚ್ ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ ಶಿಸಾ ತೆಚೆಕ್ಡೆ ಯೆಲಿ. ತೆನಿ ಶಿಸಾಕ್ನಿ “ಲೊಕಾ ಮಿಯಾ ಕೊನ್ ಮನುನ್ ಮನ್ತ್ಯಾತ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ತನ್ನಾ ಶಿಸಾನಿ ತೆಕಾ “ಅನಿ ಉಲ್ಲಿ ಲೊಕಾ ಜುವಾಂವ್ ಬಾವ್ತಿಸ್ ಮನ್ತ್ಯಾತ್,ಉಲ್ಲಿ ಲೊಕಾ ತಿಯಾ ಎಲಿಯಾ ಮನ್ತ್ಯಾತ್, ಅನಿ ಹುರಲ್ಲೆ ಅದ್ಲ್ಯಾ ಕಾಲಾತ್ಲ್ಯಾ ಪ್ರವಾದ್ಯಾನಿತ್ಲೊ ಎಕ್ಲೊ ಪ್ರವಾದಿ ಅನಿ ಪರ್‍ತುನ್ ಝಿತ್ತೊ ಹೊವ್ನ್ ಯೆಲಾ ಮನ್ತ್ಯಾತ್”, ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ “ತರ್ ತುಮಿ ಮಾಕಾ ಕೊನ್ ಮನುನ್ ಮನ್ತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ಪೆದ್ರುನ್ “ತಿಯಾ ದೆವಾಚೊ ಮೆಸ್ಸಿಯಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ತನ್ನಾ ಜೆಜುನ್ ಹೆ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕಾಸಿ ಮನುನ್ ಖಡಕ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ಅನಿ ತೆನಿ “ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾನ್ ಕಸ್ಟ್ ಸೊಸುಕ್ ಪಾಜೆ, ಅನಿ ಜಾನ್ತ್ಯಾಂಚ್ಯಾ, ಮುಖ್ಯ ಯಾಜಕಾಂಚ್ಯಾ ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾನಿಕ್ನಾ ಮರ್‍ಯಾದ್ ಕಾಡುನ್ ಘೆವ್ಕ್ ಪಾಜೆ. ತೆಕಾ ಜಿವಾನಿ ಮಾರ್‍ತ್ಯಾತ್. ಖರೆ ತಿನ್ ದಿಸಾ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ತೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆತಾ”, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ಮಾನಾ ಜೆಜುನ್ ಸಗ್ಳ್ಯಾಕ್ನಿ “ಕೊನ್ ತರ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆವ್ಚೆ ಮನುನ್ ಹಾಯ್ ಜಾಲ್ಯಾರ್,ತೆನಿ ಅಪ್ನಾಕುಚ್‍ ಇಸ್ರುಕ್ ಪಾಜೆ. ಸದ್ದಿಚ್ ತೆಚೊ ಕುರಿಸ್ ವಾವುನ್ ಘೆವ್ಕ್ ಪಾಜೆ, ಅನಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆವ್ಕ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ಜೆ ಕೊನ್ ಅಪ್ನಾಚೊ ಜಿವ್ ರಾಕುನ್ ಘೆವ್ಕ್ ಬಗ್ತಾ, ತೊ ಕಳ್ದುನ್ ಘೆತಾ, ಅನಿ ಜೆ ಕೊನ್ ಮಾಜೆಸಾಟಿ ಅಪ್ನಾಚೊ ಜಿಂವ್ ಕಳ್ದುನ್ ಘೆತಾ, ತೊ ತೆ ಹುರ್ವುನ್ ಘೆತಾ. ");
INSERT INTO kans_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ಮಾನ್ಸಾನ್ ಅಪ್ನಾಚೊ ಜಿವುಚ್ ಕಳ್ದುನ್ ಘೆವ್ನ್, ಸಗ್ಳೊ ಜಗುಚ್ ತರ್‍ಬಿ ಝಿಕುನ್ ಘೆಟ್ಲ್ಯಾನ್ ತರ್, ತೆಕಾ ಕಾಯ್ ಫಾಯ್ದೊ? ಕಾಯ್ಬಿ ಫಾಯ್ದೊ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ಜೆ ಕೊನ್ ಮಾಕಾ, ಅನಿ ಮಿಯಾ ಶಿಕ್ವುತಲ್ಯಾಕ್ ಲಜ್ತಾ, ಮಾನ್ಸಾಚೊ ಲೆಕ್‍ಬಿ ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾಚ್ಯಾ ಮಹಿಮೆನ್ ಭರುನ್ ಸರ್‍ಗಾಚ್ಯಾ ಪವಿತ್ರ್ ದುತಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆತಾನಾ ತೆಚ್ಯಾ ಸಾಟ್ನಿ ಲಜ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ಮಿಯಾ ಖರೆಚೆ ಸಾಂಗ್ತಾ, ಹಿತ್ತೆ ಹೊತ್ತ್ಯಾ ತುಮ್ಚ್ಯಾ ಮದ್ಲೆ ಉಲ್ಲೆ ಜಾನಾ, ದೆವಾಚೆ ರಾಜ್ ಬಗಟ್ಲ್ಯಾ ಶಿವಾಯ್ ಮರಿನ್ಯಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ಹೆ ಸಗ್ಳೆ ಸಾಂಗುನ್ ಆಟ್ ದಿಸ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಪೆದ್ರುಕ್,ಜುವಾಂವಾಕ್, ಅನಿ ಜಾಕೊಬಾಕ್ ಘೆವ್ನ್ ಜೆಜು ಮಾಗ್ನಿ ಕರುಕ್ ಮನುನ್ ಎಕ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ಜೆಜು ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ ತೆಚೆ ತೊಂಡ್ ಬದಲ್ಲೆ, ಅನಿ ತೆಚೆ ಕಪ್ಡೆ ಫಾಂಡ್ರೆ ಖಡ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ಎಗ್ದಮ್ ದೊಗ್ ಜಾನಾ ತೆಚೆಕ್ಡೆ ಬೊಲುಕ್‍ಲಾಲೆ. ತೆನಿ ಕೊನ್ ಮಟ್ಲ್ಯಾರ್, ಮೊಯ್ಜೆ ಅನಿ ಎಲಿಯಾ. ");
INSERT INTO kans_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ತೆನಿ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ಮಹಿಮೆನ್ ಭರುನ್, ಜೆಜು ದೆವಾಚಿ ಯವ್ಜನ್ ಪುರಾ ಕರುಕ್, ಕಶೆ ಕಶೆ ಕರುನ್ ಜೆರುಜಲೆಮಾತ್ ಮರ್‍ನಾರ್ ಹಾಯ್, ಮನುನ್ ಬೊಲುಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ಪೆದ್ರುಕ್ ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಿಯಾಕ್ನಿ ನಿಜ್‍ ಲಾಗಲ್ಲಿ, ಖರೆ ತೆನಿ ಉಟಲ್ಲ್ಯಾ ತನ್ನಾ “ಜೆಜುಚಿ ಮಹಿಮಾ ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ದೊಗೆ ಜಾನಾಕ್ನಿ ಬಗಟ್ಲ್ಯಾನಿ”. ");
INSERT INTO kans_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ತಿ ಮಾನ್ಸಾ ಜೆಜುಕ್ ಸೊಡುನ್ ಜಾತಾ-ಜಾತಾನಾಚ್ ಪೆದ್ರುನ್ ಗುರುಜಿ , ಹಿತ್ತೆ ಅಮಿ ಹೊತ್ತೆ ಕವ್ಡೆ ಬರೆ ಹಾಯ್ ನ್ಹಯ್? ಅಮಿ ತಿನ್ ಝೊಪ್ಡಿ ಘಾಲ್ತಾಂವ್, ಎಕ್ ತುಕಾ, ಎಕ್ ಮೊಯ್ಜೆಕ್,ಅನಿ ಅನಿ ಎಕ್ ಎಲಿಯಾಕ್. ಮಟ್ಲ್ಯಾನ್ ತೊ ಕಾಯ್ ಬೊಲಿ ಮನುನ್ ತೆಕಾಚ್ ಗೊತ್ತ್ ನತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ತೊ ಬೊಲ್ತಾ-ಬೊಲ್ತಾನಾಚ್ ಎಕ್ ಮೊಡ್ ಯೆಲೆ, ಅನಿ ತೆಚ್ಯಾ ಸಾವ್ಳಿನ್ ತೆಂಕಾ ಧಾಪ್ಲಿನ್.ಮೊಡಾಚ್ಯಾ ಸಾವ್ಳಿ ಬಗುನ್ ಶಿಸಾ ಭಿಂಯಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ತನ್ನಾಚ್ ಮೊಡಾತ್ನಾ “ಹ್ಯೊ ಮಾಜೊ ಲೆಕ್, ಮಿಯಾ ಎಚುನ್ ಕಾಡಲ್ಲೊ, ತೆಕಾ ಆಯ್ಕಾ!” ಮನ್ತಲೊ ಧನ್ ಆಯ್ಕೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ತೊ ಧನ್ ಆಯ್ಕುನ್ ಸರಿ ಪತರ್ ಮಟ್ಲ್ಯಾರ್, ಜೆಜು ಎಕ್ಲೊಚ್ ಹೊತ್ತೊ. ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಶಿಸಾ ಗಪ್-ಚಿಪ್ ರ್‍ಹಾಲಿ, ಅನಿ ಹಿತ್ತೆ ಬಗಟಲ್ಲ್ಯಾ ವಿಶಯಾತ್ ಕೊನಾಕ್ಡೆಬಿ ಬೊಲುಕ್‍ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ದುಸ್ರೆಂದಿಸಿ, ಜೆಜು ಅನಿ ತಿ ತಿನ್ ಶಿಸಾ ಮಡ್ಡಿ ವೈನಾ ಖಾಲ್ತಿ ಗೆಲ್ಯಾನಿ, ತನ್ನಾ ಎಕ್ ಮೊಟೊ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಜೆಜುಕ್ ಭೆಟ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ತ್ಯಾ ತಾಂಡ್ಯಾತ್ನಾ ಎಕ್ ಮಾನ್ಸಾನ್,“ಗುರುಜಿ, ಮಾಜ್ಯಾ ಲೆಕಾಕ್ ಬಗಾ,ಮಾಜೊ ಎಕ್ಲೊಚ್ ಲೆಕ್ ತೊ! ");
INSERT INTO kans_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ಎಕ್ ಗಿರೊ ತೆಚ್ಯಾ ಆಂಗಾತ್ ಚಡ್ತಾ, ಅನಿ ಎಗ್ದಮ್ ತೆಕಾ ಬೊಬ್ ಮಾರಿ ಸರ್ಕೆ ಕರ್‍ತಾ, ತೊ ತೊಂಡಾತ್ನಾ ಭುರುಕ್ ಕಾಡ್ತಾ; ವಾಯ್ಟ್ ತರಾಸ್ ದಿವ್ನ್ ತೆಕಾ ಸೊಡುನ್ ಜಾತಾ! ದಯಾ ಕರುನ್ ತೆಕಾ ಬಗಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ತುಜ್ಯಾ ಶಿಸಾಕ್ನಿ ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ ಕಾಡಾ, ಮನುನ್ ಮಿಯಾ ಲೈ ಸಾಂಗ್ಲೊ, ಖರೆ ತೆಂಚೆನ್ ತೆ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ತನ್ನಾ ಜೆಜುನ್ “ಕವ್ಡೆ ಕಮಿ ವಿಶ್ವಾಸಾಚಿ ಲೊಕಾ ತುಮಿ? ಅನಿ ಕೌಡೆಪತರ್ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರಾವ್ಚೆ? ಅನಿ ಕವ್ಡೊ ಎಳ್ ಮಿಯಾ ತುಮ್ಕಾ ಸೊಸುನ್ ಘೆವ್ನ್ ಜಾವ್ಚೆ?” ಮಟ್ಲ್ಯಾನ್. ಮಾನಾ ತ್ಯಾ ಮಾನ್ಸಾಕ್ “ತುಜ್ಯಾ ಲೆಕಾಕ್ ಹಿಕ್ಡಿ ಘೆವ್ನ್ ಯೆ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ತೊ ಝಿಲ್ಗೊ ಜೆಜುಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್‍ಲಾಗಲ್ಲೊ. ತನ್ನಾ ಗಿರ್‍ಯಾನ್ ತೆಕಾ ಜಿಮ್ನಿಕ್‍ ಪಾಡ್ವುಲ್ಯಾನ್, ಅನಿ ತೆಕಾ ಲೊಳಿ ಸಾರ್ಕೆ ಕರ್‍ಲ್ಯಾನ್ ಜೆಜುನ್ ತ್ಯಾ ಗಿರ್‍ಯಾಕ್ “ಭಾಯ್ರ್ ಜಾ” ಮನುನ್ ತಾಕಿತ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ತೊ ಗಿರೊ ಗೆಲೊ, ಅನಿ ತೊ ಝಿಲ್ಗೊ ಬರೊ ಹೊಲೊ, ಅನಿ ತೆನಿ ತೆಚ್ಯಾ ಲೆಕಾಕ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ಡೆ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ಥೈ ಹೊತ್ತಿ ಸಗ್ಳಿ ಲೊಕಾ ದೆವಾಚೊ ಬಳ್ ಬಗುನ್ ಅಜಾಪ್ ಹೊಲಿ. ಜೆಜುನ್ ಕರಲ್ಲ್ಯಾ ಕಾಮಾಕ್ನಿ ಬಗುನ್ ಸಗ್ಳಿ ಲೊಕಾ ಅಜಾಪ್ ಹೊವ್ಕ್ ಲಾಗಲ್ಲಿ, ತನ್ನಾ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ, ");
INSERT INTO kans_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಲೆ ಯಾದ್ ಥವ್ನ್ ಘೆವಾ, ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಮಾನ್ಸಾಂಚ್ಯಾ ಅದಿಕಾರಾತ್ ದಿವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ಖರೆ ಶಿಸಾಕ್ನಿ ತೊ ಕಾಯ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಕಳುಕ್‍ ನಾ, ಹೆ ತೆಂಕಾ ತವ್ಡೆ ಸೊಡ್ಸುನ್ ಸಾಂಗಲ್ಲೆ ನತ್ತೆ, ತಸೆ ಮನುನ್ ತೆಂಕಾ ಕಾಯ್ಬಿ ಕಳುಕ್‍ ನಾ. ಅನಿ ಕಾಯ್ ಮನುನ್ ಇಚಾರುಕ್‍ಬಿ ತೆಂಕಾ ಧೈರೊ ಹೊವುಕ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ತೆಂಚ್ಯಾ ಮದ್ದಿ ಕೊನ್ ಮೊಟೊ ಮನುನ್ ಶಿಸಾ ಅಪ್ನಾಚ್ಯಾ ಮದ್ದಿ ಬೊಲುಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ಜೆಜುಕ್ ತೆಂಚ್ಯಾ ಮನಾತ್ಲೆ ಕಳ್ಳೆ, ತನ್ನಾ ತೆನಿ ಎಕ್ ಪೊರಾಕ್ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ಅನಿ ತೆಂಕಾ “ಹ್ಯಾ ಪೊರಾಕ್ ಜೆ ಕೊನ್ ಮಾಜ್ಯಾ ನಾವಾನ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ, ತೊ ಮಾಕಾಚ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ, ಅನಿ ಜೆ ಕೊನ್ ಮಾಕಾ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ, ತೊ ಮಾಕಾ ಧಾಡಲ್ಲ್ಯಾಕ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಕೊನ್ ಖಾಲ್ತಿ ಹೊತಾ, ತೊ ಸಗ್ಳ್ಯಾಂಚ್ಯಾನ್ಕಿ ಮೊಟೊ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ಜುವಾಂವಾಕ್ ಜೆಜುಕ್, “ಗುರುಜಿ, ತುಜ್ಯಾ ನಾವಾನ್ ಎಕ್ ಮಾನುಸ್ ಗಿರೆ ಕಾಡ್ತಲೆ ಅಮಿ ಬಗಟ್ಲ್ಯಾವ್,ಅನಿ ಅಮಿ ತೆಕಾ ತಿಯಾ ಅಶೆ ಕರ್‍ತಲೆ ಸೊಡ್ ಮನುನ್ ಸಾಂಗ್ಲಾಂವ್” “ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಅಮ್ಚೊ ನ್ಹಯ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ತನ್ನಾ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ “ತೆಕಾ ಅಡ್ವುಕ್ ಜಾವ್ನಕಾಸಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜೆ ಕೊನ್ ಅಮ್ಚ್ಯಾ ವಿರೊದ್ ನಾ ತೊ ಅಮ್ಚೊಚ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ಜೆಜುಕ್ ಸರ್‍ಗಾಕ್ ಘೆವ್ನ್ ಜಾತಲೊ ಎಳ್ ಜಗ್ಗೊಳ್-ಯೆವ್ನ್ಗೆತ್ ಹೊತ್ತೊ, ಜೆಜುನ್ ಅಪ್ನಾಚೆ ಮನ್ ಘಟ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ತೊ ಅಪ್ಲಿ ವಾಟ್ ಧರುನ್ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್‍ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಖಬರ್ ಸಾಂಗ್ತಲ್ಯಾಕ್ನಿ ಫಿಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನ್,ತೆಚೆಸಾಟ್ನಿ ಸಗ್ಳೆ ತಯಾರ್ ಕರುನ್ ಥವ್ಕ್ ಮನುನ್ ತೆನಿ ಸಮಾರಿಯಾಚ್ಯಾ ಎಕ್ ಗಾಂವಾಕ್ ಗೆಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ತೊ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಲೊಕಾಕ್ನಿ ಕಳಲ್ಲೆ, ತಸೆ ಮನುನ್ ಲೊಕಾನಿ ಜೆಜುಕ್ ಗಾಂವಾತ್ ಭುತ್ತುರ್ ಘೆವ್ಕ್‌ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ಜಾಕೊಬ್ ಅನಿ ಜುವಾಂವ್ ಹೆ ಬಗುನ್ “ಧನಿಯಾ, ಸರ್‍ಗಾ ವೈನಾ ಆಗ್ ಯೆವ್ನ್ ಹ್ಯಾ ಲೊಕಾಕ್ನಿ ಭಾಜುನ್ ಟಾಕುಂದಿ ಮನುನ್ ಮಾಗುವಾ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ಖರೆ ಜೆಜು ಪರತ್ಲೊ, ಅನಿ ತೆಂಕಾ ಜೊರ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ತನ್ನಾ ಜೆಜು ಅನಿ ಶಿಸಾ ಅನಿಎಕ್ ಗಾಂವಾಕ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ತೆನಿ ವಾಟೆನ್ ಜಾತಾನಾ, ಎಕ್ ಮಾನುಸ್ ಯೆವ್ನ್ ಜೆಜುಕ್ “ತಿಯಾ ಖೈ ಜಾತೈ ಥೈ ಮಿಯಾ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ಕೊಲ್ಯಾಕ್ನಿ ಢೊಂಬಾ ಹಾತ್, ಅನಿ ಫಾಂಕ್ರಾಕ್ನಿ ಘಂಟೆ ಹಾತ್, ಖರೆ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಟಕ್ಲೆ ಠೆಕುಕ್ ಸೈತ್ ಜಾಗೊ ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ತನ್ನಾ ಅನಿಎಕ್ ಮಾನ್ಸಾಕ್ ಜೆಜುನ್ “ತಿಯಾ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆ!” ಮಟ್ಲ್ಯಾನ್. ಖರೆ ತೆನಿ “ಗುರುಜಿ, ಅದ್ದಿ ಮಿಯಾ ಜಾವ್ನ್ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ ಮಾಟಿ ದಿವ್ನ್ ಯೆತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ಮರಲ್ಲೆಚ್ ಮರಲ್ಲ್ಯಾಕ್ನಿ ಮಾಟಿ ದಿಂವ್ದಿತ್. ತಿಯಾ ಜಾ ಅನಿ ದೆವಾಚ್ಯಾ ರಾಜಾಚ್ಯಾ ವಿಶಯಾತ್ ಲೊಕಾಕ್ನಿ ಸಾಂಗ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ಕೊನ್ಕಿ ಅನಿ ಎಕ್ಲ್ಯಾನ್ “ಗುರುಜಿ, ಮಿಯಾ ತುಜ್ಯಾ ಫಾಟ್ನಾ ಯೆತಾ, ಖರೆ ಅದ್ದಿ ಜಾವ್ನ್ ಮಾಜ್ಯಾ ಘರಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಮಿಯಾ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಸಾಂಗುನ್ ಯೆತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ನಾಂಗ್ರಾಕ್ ಹಾತ್ ಧರುನ್ ಫಾಟಿ ಪರ್ತುನ್ ಬಗ್ತಲ್ಯಾಕ್ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಕಾಮ್ ಕರ್‍ತಲಿ ಮರ್‍ಯಾದ್ ನಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ಹೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಜೆಜುನ್ ಅನಿ ಸತ್ತರಾರ್ ದೊನ್ ಜಾನಾಕ್ನಿ ಎಚುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ಅಪ್ನಿ ಖೈ-ಖೈ ಜಾವ್ಚೆ ಮನುನ್ ಹೊತ್ತೆ, ಥೈ-ಥೈ ದೊಗ್ಯಾ-ದೊಗ್ಯಾಕ್ನಿ ವಾಂಗಡ್ ಕರುನ್ ಅಪ್ನಾಚ್ಯಾಕಿ ಫಿಡೆಚ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ತೆನಿ ತೆಂಕಾ, “ಭರ್‍ಪುರ್ ಪಿಕ್ಕ್ ಯೆಲ್ಲೆ ಹಾಯ್, ಖರೆ ತೆ ಗೊಳಾ ಕರುಕ್ ಕಾಮ್ಗಾರಿ ಲೈ ಕಮಿ ಹಾತ್.ಪಿಕ್ಕಾಚ್ಯಾ ಯಜಮಾನಾಕ್ಡೆ ತೆಚೆ ಪಿಕ್ಕ್ ಗೊಳಾ ಕರುಕ್ ಕಾಮ್ಗಾರಿ ಧಾಡುನ್ ದಿ ಮನುನ್ ಮಾಗ್ನಿ ಕರಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“ಮಾನಾ ಜಾಂವಾ! ಝುಲ್ ಕುತ್ರ್ಯಾಂಚ್ಯಾ ಮದ್ದಿ, ಬಕ್ರ್ಯಾಕ್ನಿ ಧಾಡ್ಲ್ಯಾ ಸರ್ಕೆ ಮಿಯಾ ತುಮ್ಕಾ ಧಾಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ಪಯ್ಸ್ಯಾಂಚಿ ಪಿಸ್ವಿ ಹೊಂವ್ದಿ, ಪಿಸ್ವಿ ಹೊಂವ್ದಿ ಚಪ್ಲಾ ಹೊಂವ್ದಿ ಘೆವ್‍ಕಾಶಿ; ವಾಟೆರ್ ಕೊನಾಕ್ಬಿ ನಮಸ್ಕಾರ್ ಕರುಕ್ ಇಬೆ ರಾವ್ನಕಾಶಿ”. ");
INSERT INTO kans_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ಎಕ್ ಘರಾತ್ ತುಮಿ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಅದ್ದಿ “ಹ್ಯಾ ಘರಾತ್ ಸಮಾದಾನ್ ರ್‍ಹಾಂವ್ದಿತ್” ಮನಾ, ");
INSERT INTO kans_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ಜರ್ ಸಮಾದಾನಾಚೊ, ಪ್ರೆಮಾಚೊ ಮಾನುಸ್ ಥೈ ರ್‍ಹಾಲ್ಯಾರ್, ತುಮಿ ಸಾಂಗಲ್ಲೆ ಸಮಾದಾನ್ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ರಾವ್ಕ್ ಸೊಡಾ; ನಸ್ಲ್ಯಾರ್, ತುಮ್ಚೆ ಸಮಾದಾನ್ ಫಾಟಿ ಘೆವಾ. ");
INSERT INTO kans_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ದುಸ್ರ್ಯಾ ಘರಾತ್ನಿ ಜಾವ್‍ನಕಾಶಿ ತುಮ್ಕಾ ಸ್ವಾಗತ್ ಕರಲ್ಲ್ಯಾ ಎಕುಚ್ ಘರಾತ್ ರ್‍ಹಾವಾ, ತೆನಿ ದಿಲ್ಲೆ ಖಾವಾ, ಫಿವಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ರಾಬಲ್ಲ್ಯಾಕ್ ತೆಚಿ ಮಜುರಿ ಗಾವುಕುಚ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ಖಲ್ಯಾಬಿ ಗಾಂವಾತ್, ನಾ ತರ್ ಘರಾತ್ ತುಮ್ಕಾ ಸ್ವಾಗತ್ ಕರಲ್ಲ್ಯಾ ತನ್ನಾ, ತುಮ್ಕಾ ತೆನಿ ಕಾಯ್ ದಿತ್ಯಾತ್, ತೆಚ್ ಖಾವಾ, ");
INSERT INTO kans_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ತ್ಯಾ ಗಾಂವಾತ್ಲ್ಯಾ ಶಿಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಗುನ್ ಕರಾ ಅನಿ ಥೈತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ “ದೆವಾಚೆ ರಾಜ್ ತುಮ್ಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆಲಾ” ಮನುನ್ ಸಾಂಗಾ. ");
INSERT INTO kans_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ತುಮಿ ಖಲ್ಯಾಬಿ ಗಾಂವಾತ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತುಮ್ಕಾ ಸ್ವಾಗತ್ ಕರಿನಸ್ಲ್ಯಾರ್, ವನಿಯಾತ್ನಿ ಜಾಂವಾ, ಅನಿ ");
INSERT INTO kans_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“ತುಮ್ಚ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ವಿರೊದ್ ಅಮ್ಚ್ಯಾ ತಳ್‍ಪಾಯಾಚಿ ಧುಳ್ ಸೈತ್ ಫಾಪಡ್ತಾವ್. ತುಮ್ಕಾ ಯಾದ್ ರಾವ್ನ್ದಿತ್, ದೆವಾಚೆ ರಾಜ್ ತುಮ್ಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆಲಾ!” ಮನುನ್ ಸಾಂಗಾ. ");
INSERT INTO kans_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ ಹ್ಯಾ ಗಾಂವಾಚಿ ಗತ್ ಸೊದೊಮ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಚ್ಯಾನ್ಕಿ ಕಠಿನ್ ಹೊತಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ಖೊರಾಜಿನಾ! ಬೆತ್ಸಾಯಿದಾ! ತುಜಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು, ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಕರಲ್ಲಿ ಮೊಟಿ-ಮೊಟಿ ಕಾಮಾ ತಿರ್ ಅನಿ ಸಿದೊನಾತ್ ಕರ್ಲ್ಯಾರ್, ಥೈತ್ಲಿ ಲೊಕಾ ಅಪ್ನಾಚ್ಯಾ ಪಾಪಾನಿತ್ಲಾ ಅಮಿ ಭಾಯ್ರ್ ಯೆಲಾಂವ್ ಮನುನ್ ದಾಕ್ವುಕ್, ಕನ್ನಾಕಿಚ್ ಖಾಲ್ತಿ ಬಸುನ್, ಗೊನಿ ಚಿಲಾ ಆಂಗಾರ್ ಘಾಲುನ್ ಘೆಯ್ ಹೊತ್ತಿ, ಅನಿ ಆಂಗಾರ್ ರಕ್ಕಾ ಘಾಲುನ್ ಘೆಯ್ ಹೊತ್ತಿ, ಕಾಯ್ಕಿ! ");
INSERT INTO kans_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ ತಿರ್ ಅನಿ ಸಿದೊನಾಕ್ ತುಮ್ಚ್ಯಾನ್ಕಿ ಜಾಸ್ತಿ ದಯಾ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ಅನಿ ತಿಯಾ ಕಪರ್‍ನವ್! ತುಕಾ ಸರ್‍ಗಾ ಪತರ್ ವೈರ್ ಪಾವುಕ್ ಪಾಜೆ ನ್ಹಯ್? ತುಕಾ ನರ್‍ಕಾತ್ ಟಾಕುನ್ ಹೊತಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ “ಜೆ ಕೊನ್ ತುಮ್ಕಾ ಆಯಿಕ್ತಾ, ತೊ ಮಾಕಾ ಆಯಿಕ್ತಾ; ಕೊನ್ ತುಮ್ಕಾ ಮರ್‍ಯಾದ್ ದಿ ನಾ, ತೊ ಮಾಕಾ ಮರ್‍ಯಾದ್ ದಿ ನಾ; ಅನಿ ಕೊನ್ ಮಾಕಾ ಮರ್‍ಯಾದ್ ದಿ ನಾ, ತೊ ಮಾಕಾ ಧಾಡಲ್ಲ್ಯಾಕ್‍ ಮರ್‍ಯಾದ್ ದಿ ನಾ”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ತನ್ನಾ ಸತ್ತರಾರ್ ದೊಗೆ ಜಾನಾ ಲೈ ಕುಶಿ-ಕುಶಿನ್ ಪರ್ತುನ್ ಯೆಲ್ಯಾನಿ. ಅನಿ ಜೆಜುಕ್ “ಧನಿಯಾ, ತುಜೆ ನಾವ್ ಘೆವ್ನ್ ಅಮಿ ಗಿರ್‍ಯಾಕ್ನಿ ಸೈತ್ ಕಾಯ್ಬಿ ಸಾಂಗ್ಲ್ಯಾರ್, ತೆನಿ ಅಮಿ ಸಾಂಗಟಲ್ಲೆ ಆಯ್ಕಿತ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ಮಿಂಚಾ ಸರ್ಕೆ ಸೈತಾನ್ ಸರ್‍ಗಾ ವೈನಾ ಖಾಲ್ತಿ ಪಡಲ್ಲೆ ಮಿಯಾ ಬಗಟ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ಆಯ್ಕಾ! ಮಿಯಾ ತುಮ್ಕಾ ಸಗ್ಳೊ ಅದಿಕಾರ್ ದಿಲಾ, ತಸೆಮನುನ್ ತುಮಿ ಸಾಪಾಂಚ್ಯಾ ವರ್‍ತಿ, ಅನಿ ಇಂಚ್ವಾಂಚ್ಯಾ ವರ್‍ತಿ, ಅನಿ ದುಸ್ಮಾನಾಚ್ಯಾ ವರ್‍ತಿ ಜಿಕ್ತ್ಯಾಶಿ, ಅನಿ ತುಮ್ಕಾ ಕಾಯ್ಬಿ ಅಪಾಯ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ಖರೆ ಗಿರೆ ತುಮಿ ಸಾಂಗಟಲ್ಲೆ ಆಯಿಕ್ತ್ಯಾತ್ ಮನುನ್ ಕುಶಿ ಹೊವ್‍ನಕಾಶಿ; ಸರ್‍ಗಾತ್ ತುಮ್ಚೆ ನಾವ್ ಲಿವಲ್ಲೆ ಹಾಯ್ ಮನುನ್ ಕುಶಿ ಹೊವಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ಎಗ್ದಾ ಜೆಜು ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಕುಶಿ ಹೊಲೊ ಅನಿ “ಬಾಬಾ ಸರ್‍ಗಾಚ್ಯಾ ಅನಿ ಹ್ಯಾ ಜಗಾಚ್ಯಾ ಧನಿಯಾ ಮಿಯಾ ತುಕಾ ಧನ್ಯವಾದ್ ದಿತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಬುದ್ವಂತಾನಿಕ್ನಾ ಅನಿ ಶಿಕಲ್ಲ್ಯಾನಿಕ್ನಾ ನಿಪ್ವುನ್ ಥವಲ್ಲೆ, ಶಿಕುನಸಲ್ಲ್ಯಾಕ್ನಿ ತಿಯಾ ದಾಕ್ವುನ್ ದಿಲೆ. ಹೊಯ್ ಮಾಜ್ಯಾ ಬಾಬಾ, ಹೆ, ತುಕಾ ಕಶೆ ಪಾಜೆ ತಸೆಚ್ ಹೊಲೆ”. ");
INSERT INTO kans_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ಸಗ್ಳೆ ದಿಲ್ಯಾನಾಯ್,ಬಾಬಾಕ್ ಸೊಡುನ್ ಕೊನಾಕ್ಬಿ ಲೆಕ್ ಕೊನ್ ಮನುನ್ ಗೊತ್ತ್ ನಾ, ಬಾಬಾ ಕೊನ್ ಮನುನ್ ಲೆಕಾಕ್ ಅನಿ ತೆನಿ ಎಚುನ್ ಕಾಡುನ್, ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗಲ್ಲ್ಯಾಕ್ನಿ ಸೊಡುನ್ ಕೊನಾಕ್ಬಿ ಗೊತ್ತ್ ನಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ತನ್ನಾ ಜೆಜು ಶಿಸಾನಿಕ್ನಿ ಪರತ್ಲೊ, ಅನಿ ಘುಟಾನ್ ತೆಂಕಾ ಎವ್ಡೆಚ್ ಹೆ ಸಗ್ಳೆ ಬಗುಲಾಗಲ್ಲ್ಯಾ ತುಮಿ ಕವ್ಡೆ ಧನ್ಯ್! ");
INSERT INTO kans_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಲೈ ಪ್ರವಾದ್ಯಾಕ್ನಿ, ಅನಿ ರಾಜಾಕ್ನಿ, ತುಮಿ ಬಗಲ್ಲೆ ಬಗುಕ್, ಅನಿ ತುಮಿ ಆಯ್ಕಲ್ಲೆ ಆಯ್ಕುಕ್, ಮನ್ ಹೊತ್ತೊ, ಖರೆ ತೆಂಕಾ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ಹೆಚ್ಯಾ ಮಾನಾ, ಎಕ್ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲೊ ಮಾನುಸ್, ಜೆಜುಕ್ ಸಿರ್ಕುನ್ ಘಾಲುಸಾಟ್ನಿ ಮನುನ್ “ಗುರುಜಿ, ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಮಾಕಾ ಗಾವುಚೆ ತರ್ ಮಿಯಾ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ಖಾಯ್ದ್ಯಾಚೆ ಪುಸ್ತಕ್ ಕಾಯ್ ಸಾಂಗ್ತಾ? ತೆ ತಿಯಾ ಕಶೆ ಕಳ್ವುನ್ ಘೆತೆಯ್?” ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ತ್ಯಾ ಮಾನ್ಸಾನ್ “ಸಗ್ಳ್ಯಾ ತುಜ್ಯಾ ಕಾಳ್ಜಾನ್,ಸಗ್ಳ್ಯಾ ತುಜ್ಯಾ ಜಿವಾನಿ, ಸಗ್ಳ್ಯಾ ತುಜ್ಯಾ ತಾಕ್ತಿನ್, ಅನಿ ಸಗ್ಳ್ಯಾ ತುಜ್ಯಾ ಮನಾನ್; ಸರ್ವೆಸ್ವರಾ ತುಜ್ಯಾ ದೆವಾಚೊ ಪ್ರೆಮ್ ಕರ್, ಅನಿ ತಿಯಾ ತುಕಾಚ್ ಕಸೊ ಪ್ರೆಮ್ ಕರ್‍ತೆ, ತಸೆ ತುಜ್ಯಾ ಸೆಜಾರ್‍ಯಾಚೊಬಿ ಪ್ರೆಮ್ ಕರ್, ಮನುನ್ ಖಾಯ್ದ್ಯಾಚೆ ಪುಸ್ತಕ್ ಸಾಂಗ್ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ಸಮಾ ಸಾಂಗ್ಲೆ” ತಿಯಾ “ಹೆ ಕರ್ ಅನಿ ತುಕಾ ನಿರಂತರ್ ಝಿತ್ತೊ ರ್‍ಹಾತಲೆ ಜಿವನ್ ಗಾವ್ತಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ಖರೆ ತೊ ಮಾನುಸ್ ಅಪ್ನಿಚ್ ಖರೊ ಮನುನ್ ದಾಕ್ವುಸಾಟ್ನಿ “ಮಾಜೊ ಸೆಜಾರಿ ಮಟ್ಲ್ಯಾರ್ ಕೊನ್?” ಮನುನ್ ಜೆಜುಕ್ ಇಚಾರುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ತನ್ನಾ ಜೆಜುನ್ “ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೊ ಜೆರುಜಲೆಮಾಕ್ನಾ, ಜೆರಿಕೊಕ್ ಜಾವ್‍ಲಾಗಲ್ಲೊ, ತನ್ನಾ ಚೊರಾನಿ ತೆಕಾ ಧರ್‍ಲ್ಯಾನಿ,ಅನಿ ತೆಚ್ಯೆಕ್ಡೆ ಹೊತ್ತೆ ಸಗ್ಳೆ ಕಾಡುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ಅನಿ ತೆಕಾ ಮಾರುನ್ ಅರ್‍ದೊ ಜಿವ್ ಕರ್‍ಲ್ಯಾನಿ”, ");
INSERT INTO kans_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ಹೆ ಹೊಲ್ಲ್ಯಾ ಎಕ್ ಉಲ್ಲ್ಯಾ ಎಳಾನ್, ಎಕ್ ಯಾಜಕ್ ಥೈತ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಜಾವ್‍ಲಾಗಲ್ಲೊ, ತೆನಿ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ಕಡೆಕ್ನಾಚ್ ತೆಚ್ಯಾ ವಾಟೆನ್ ದಾಟುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ತ್ಯಾಚ್ ವಾಟೆನ್ ಎಕ್ ಲೆವಿತ್ ಯೆಲೊ, ತೆನಿ ಧುರ್‍ನಾಚ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ಎಕ್ ಬಾಜುನ್ ಹೊವ್ನ್, ತೊ ದಾಟುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ಖರೆ ಎಕ್ ಸಮಾರಿಯಾಚೊ ಮಾನುಸ್ ತ್ಯಾ ವಾಟೆನ್ ಜಾವ್‍ಲಾಗಲ್ಲೊ, ಅನಿ ತೆನಿ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಬಗಟ್ಲ್ಯಾನ್, ತೆಕಾ ಬಗುನ್, ತೆಕಾ ತೆಚೊ ಪಾಪ್ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ತೊ ತೆಚ್ಯಾ ಜಗ್ಗೊಳ್ ಗೆಲೊ, ಅನಿ ತೆಚ್ಯಾ ದುಕ್ಕಾಕ್ನಿ ತೆಲ್‍ ಅನಿ ವಾಯ್ನ್ ಲಾವ್ಲ್ಯಾನ್, ಅನಿ ದುಕ್ಕಾಕ್ನಿ ಫಾಳಿಯಾನಿ ಭಾಂದ್ಲ್ಯಾನ್. ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಜನಾವರಾ ವರ್‍ತಿ ಬಸ್ವುನ್ ಘೆವ್ನ್, ತೆಕಾ ಎಕ್ ಘರಾಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್. ಅನಿ ತೆಚಿ ಉಳ್ಗಿ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ದುಸ್ರ್ಯಾ ದಿಸಿ ತ್ಯಾ ಘರಾಚ್ಯಾ ಧನಿಯಾಕ್, ದೊನ್ ಚಾಂದಿಚೆ ಪೈಸೆ ದಿಲ್ಯಾನ್, ಅನಿ “ತೆಕಾ ಬರೆ ಕರುನ್ ಬಗಾ ಅನಿ ಜಾಸ್ತಿ ಖರಚ್ ಹೊಲ್ಯಾರ್, ಮಿಯಾ ಹ್ಯಾ ವಾಟೆನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮ್ಕಾ ಹಾನುನ್ ದಿತಾ” ಮನುನ್ ಸಾಂಗುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ತನ್ನಾ ಜೆಜುನ್ “ತುಜ್ಯಾ ಪರ್‍ಕಾರ್, ಹ್ಯಾ ತಿಗ್ಯಾನಿತ್ನಿ, ಹ್ಯಾ ಚೊರಾನಿ ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಕೊನ್ ಸೆಜಾರಿ ಹೊಲೊ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾನ್ “ಜೆ ಕೊನ್ ತೆಚಿ ಉಳ್ಗಿ ಕರ್‍ಲ್ಯಾನ್ ತೊ”, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ತಸೆ ಜಾಲ್ಯಾರ್, ಜಾ, ಅನಿ ತಿಯಾಬಿ ತಸೆಚ್ ಕರ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ಸದ್ದಿಚ್ಯಾ ಬಾಸೆನ್ ಜೆಜು, ಅನಿ ತೆಚಿ ಶಿಸಾ ತೆಂಚ್ಯಾ ವಾಟೆನ್ ತೆನಿ ಗೆಲ್ಯಾನಿ. ತೆನಿ ಎಕ್ ಗಾಂವಾತ್ ಗೆಲ್ಲ್ಯಾನಿ, ಥೈ ಮಾರ್ಥಾ ಮನ್ತಲ್ಯಾ ಎಕ್ ಬಾಯ್ಕೊಮನ್ಸಿನ್ ತೆಂಕಾ ಅಪ್ನಾಚ್ಯಾ ಘರಾಕ್ ಬಲ್ವುಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ತಿಕಾ ಮರಿ ಮನ್ತಲಿ ಭೆನ್ ಹೊತ್ತಿ, ತಿ ಜೆಜುಚ್ಯಾ ಇದ್ರಾಕ್ ಬಸುನ್, ತೆನಿ ಸಿಕ್ವುತಲೆ ಆಯ್ಕುಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ಸಗ್ಳೆ ಕಾಮ್ ಅಪ್ನಿಚ್ ಕರ್‍ತಲೆ ಮನುನ್, ಮಾರ್ಥಾಕ್ ಬೆಜಾರ್ ಹೊಲೊ, ತಸೆ ಮನುನ್ ತಿ ಜೆಜುಕ್ಡೆ ಯೆಲಿ, ಅನಿ “ಗುರುಜಿ, ಸಗ್ಳೆ ಕಾಮ್ ಮಿಯಾಚ್ ಕರುಲಾಲಾ, ಅನಿ ಮಾಜಿ ಭೆನ್ ತುಜ್ಯಾ ಇದ್ರಾಕ್ ಬಸ್ಲಾ, ತಿಕಾ ತಿಯಾ ಕಾಯ್ಬಿ ಸಾಂಗಿನಾ ಹೊಲೆ? ತಿಕಾ ಯೆವ್ನ್ ಮಾಕಾ ಮಜತ್ ಕರ್ ಮನುನ್ ಸಾಂಗ್!” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ಖರೆ ಜೆಜುನ್ ತಿಕಾ “ಮಾರ್ಥಾ! ತಿಯಾ ಹೆ ಕಾಮ್, ತೆ ಕಾಮ್, ಮನುನ್ ಲೈ ಯವ್ಜುಕ್ ಲಾಗ್ಲೆ, ");
INSERT INTO kans_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ಖರೆ, ಮರಿನ್ ಲೈ ಬರೆ ಹೊತ್ತೆ ಎಚುನ್ ಕಾಡ್ಲಿನಾಯ್, ಅನಿ ತೆ ಕೊನಾಕ್ಬಿ ತಿಚೆಕ್ನಾ ಕಾಡುನ್ ಘೆವ್ಕ್ ಹೊಯ್ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ಎಕ್ ದಿಸ್ ಜೆಜು ಎಕ್ ಜಾಗ್ಯಾರ್ ಮಾಗ್ನಿ ಕರುಕ್ ಲಾಗಲ್ಲೊ. ತೆಚಿ ಮಾಗ್ನಿ ಕರುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ತೆಚ್ಯಾ ಶಿಸಾನಿತ್ಲೊ ಎಕ್ಲೊ “ಗುರುಜಿ, ಜುವಾಂವಾಕ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಶಿಕ್ವಲ್ಲ್ಯಾ ಸರ್ಕೆ ಅಮ್ಕಾಬಿ ಮಾಗ್ನಿ ಕರುಕ್ ಶಿಕ್ವು”, ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ಜೆಜುನ್ ತೆಂಕಾ “ತುಮಿ ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ ಅಶೆ ಮನಾ, ಬಾಬಾ, ತುಜೆ ಪವಿತ್ರ್ ನಾವ್ ಲೈ ಮರ್‍ಯಾದಿಚೆ ಹೊಂವ್ದಿ; ತುಜೆ ರಾಜ್ ಯೆಂವ್ದಿ, ");
INSERT INTO kans_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ಸದ್ದಿಚೆ ಖಾನ್ ಅಮ್ಕಾ ದಿ. ");
INSERT INTO kans_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ಅಮಿ ದುಸ್ರ್ಯಾನಿ ಕರಲ್ಲ್ಯಾ ಚುಕಾ ಕಶೆ ಮಾಪ್ ಕರ್‍ತಾವ್, ತಸೆ ಅಮ್ಚ್ಯಾ ಚುಕಾ ಮಾಪ್ ಕರ್, ಅನಿ ಅಮ್ಕಾ ಲೈ ಕಟಿನ್ ಪರಿಕ್ಷಾತ್ನಿ ಘಾಲುನಕ್ಕೊ”. ");
INSERT INTO kans_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ಅನಿ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ “ಜರ್ ತುಮ್ಚ್ಯಾ ಮದ್ಲೊ ಎಕ್ಲೊ ಅರ್ದ್ಯಾ ರಾತ್ತಿಕ್ ಎಕ್ ದೊಸ್ತಾಚ್ಯಾ ಘರಾಕ್ ಜಾತಾ ಅನಿ ದೊಸ್ತಾ? ಮಾಕಾ ತಿನ್ ಭಾಕ್ರಿಯಾ ದಿ. ");
INSERT INTO kans_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ಗಾಂವಾಕ್ ಜಾತಲೊ ಮಾಜೊ ದೊಸ್ತ್ ಅಚಾನಕ್ ಮಾಜ್ಯಾ ಘರಾಕ್ ಯೆವ್ನ್ ಪಾವ್ಲಾ, ತೆಕಾ ಜಿವನಾಕ್, ಬಿ ಮಾಜೆಕ್ಡೆ ಕಾಯ್ಬಿ ನಾ?” ಮನುನ್ ಮನ್ತಾನಾ, ");
INSERT INTO kans_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ತುಮ್ಚೊ ದೊಸ್ತ್ ತುಮ್ಕಾ, ಭುತ್ತುರ್‍ನಾಚ್, ಮಾಕಾ ತರಾಸ್ ದಿವ್‍ನಕೊ, “ದಾರಾಕ್ ಅಗ್ಳಿ ಘಾಲುನ್ ಹೊಲಾ, ಮಾಜಿ ಪೊರಾ ಮಾಜ್ಯಾ ಹೊಟ್ಟ್ಯಾತ್ ನಿಜ್ಲ್ಯಾತ್, ಮಿಯಾ ಉಟುನ್ ತುಕಾ ಕಾಯ್ಬಿ ದಿವ್ಕ್ ಹೊಯ್ನಾ” ಮನ್ತಾ, ");
INSERT INTO kans_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ಬರೆ ತರ್, ಮಾನಾ ಕಾಯ್ ಹೊತಾ? ಖರೆ, ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ತೆಕಾ ಉಟುಕ್ ಹೊಯ್ನಸ್ಲ್ಯಾರ್‍ಬಿ ಉಟುನ್ ತೊ ತುಮ್ಕಾ ಕಾಯ್ ಪಾಜೆ ತೆ ದಿತಾ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಲಜಿನಸ್ತಾನಾ ತುಮಿ ಇಚಾರ್ಲ್ಯಾಶಿ, ಮನುನ್ ತೊ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ; ಇಚಾರಾ, ಅನಿ ತುಮಿ ಘೆತ್ಯಾಶಿ, ದಾರ್ ಬಡ್ವಾ, ಅನಿ ತೆ ತುಮ್ಕಾ ಉಗಡ್ತಾ, ಹುಡ್ಕಾ, ಅನಿ ತುಮ್ಕಾ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ಜೆ ಕೊನ್ ಇಚಾರ್ತಾತ್ ತೆನಿ ಘೆತ್ಯಾತ್,ಜೆ ಕೊನ್ ಹುಡಕ್ತಾ ತೆಕಾ ಗಾವ್ತಾ, ಅನಿ ಜೆ ಕೊನ್ ದಾರ್ ಬಡ್ವುತ್ಯಾತ್, ತೆಂಕಾ ದಾರ್ ಉಗಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ತುಮ್ಚ್ಯಾ ಮದ್ಲೊ ಕೊನ್ ಬಿ ಎಕ್ಲೊ ಬಾಬಾ, ಅಪ್ನಾಚೊ ಲೆಕ್ ಮಾಸೊಳಿ ಮಾಗ್ತಾನಾ ಸಾಪ್ ದಿತಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ನಾ ಹೊಲ್ಯಾರ್ ಪೊರಾನ್ ಕಂವಾಟ್ ಇಚಾರ್ಲ್ಯಾರ್, ಇಂಚು ದಿತಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ಬುರ್ಶೆ ತುಮಿ, ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್,ಪೊರಾಕ್ನಿ ದಿವ್ಕ್ ಖಲೆ ಬರೆ ಮನುನ್ ಅನಿ ಖಲೆ ಪೊರಾಕ್ನಿ ದಿವ್ಚೆ ಮನುನ್, ತರ್, ಸರ್‍ಗಾ ವೈಲೊ ಪವಿತ್ರ್ ಬಾಬಾ, ಅಪ್ನಾಕ್ಡೆ ಮಾಗ್ತಲ್ಯಾಕ್ನಿ ಕವ್ಡ್ಯಾ ಮಾಪಾನ್ ಅಪ್ನಾಚೊ ಪವಿತ್ರ್ ಆತ್ಮೊ ದಿಯ್ಲ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ಜೆಜುನ್ ಎಕ್ ಮುಕ್ಕ್ಯಾ ಗಿರ್‍ಯಾಕ್ ಭಾಯ್ರ್ ಕಾಡ್ಲ್ಯಾನ್, ಅನಿ ಕಾಡುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ತೊ ಮಾನುಸ್ ಬರೆಚ್ ಬೊಲುಕ್‍ಲಾಗ್ಲೊ, ಹೆ ಬಗುನ್ ಸಗ್ಳಿ ಲೊಕಾ ಅಜಾಪ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ಖರೆ ಎಕ್ ಉಲ್ಲ್ಯಾಸ್ಯಾ ಲೊಕಾನಿ, “ಬೆಎಲ್ಜೆಬುಲ್ ಮನ್ತಲೊ ಗಿರ್‍ಯಾಂಚೊ ಮುಖಂಡ್ ಜೆಜುಕ್ ಗಿರೆ ಭಾಯ್ರ್ ಕಾಡುಕ್ ತಾಕತ್ ದಿತಾ”, ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ಅನಿ ಉಲ್ಲೆ ಜಾನಾ ಜೆಜುಕ್ ಗೊಂದ್ಳುನ್ ಘಾಲುಕ್, ಮನುನ್ ತಿಯಾ ದೆವಾಚೊ ಮಾನುಸ್ ಹೊಲ್ಯಾರ್ ಎಕ್ ಮೊಟೆ ವಿಚಿತ್ರ್ ವಳಕ್ ಕರುನ್ ದಾಕ್ವುನ್, ಖರೆ ಕರುನ್ ದಾಕ್ವು ಮನುಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ತೆನಿ ಯವಜ್ತಲೆ ಜೆಜುಕ್ ಕಳ್ಳೆ, ತೆನಿ ತೆಂಕಾ “ಖಲೊಬಿ ಎಕ್ ದೆಸ್ ದೊನ್ ವಾಟೆ ಹೊವ್ನ್ ಎಕಾಮೆಕಾಚ್ಯಾ ವರ್‍ತಿ ಝಗ್ಡುನ್ಗೆತ್ ರ್‍ಹಾಲ್ಯಾರ್,ತೊ ದೆಸ್ ಲೈ ದಿಸ್ ರ್‍ಹಾಯ್ನಾ, ಅನಿ ಎಕ್ ಕುಟ್ಮಾಚಿ ಲೊಕಾ ದೊನ್‍ ವಾಟೆ ಹೊವ್ನ್ ಝಗ್ಡುನ್ಗೆತ್ ರ್‍ಹಾಲ್ಯಾರ್, ತೆ ಘರಾನೆಚ್ ಹಾಳ್ ಹೊವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ತಸೆ ಜಾಲ್ಯಾರ್, ಜರ್ ಸೈತಾನಾಚೆ ರಾಜ್ ದೊನ್ ವಾಟೆ ಹೊವ್ನ್ ಝಗಡ್ಲ್ಯಾರ್, ತೆ ಕವ್ಡೆ ದಿಸ್ ರ್‍ಹಾತಾ? ಮಿಯಾ ಬೆಎಲ್ಜೆಬುಲಾಚ್ಯಾ ತಾಕ್ತಿನ್ ಅಶೆ ಕರುಕ್ ಲಾಗ್ಲಾ ತರ್, ");
INSERT INTO kans_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ಜರ್ ಮಿಯಾ ಬೆಎಲ್ಜೆಬುಲಾಚ್ಯಾ ತಾಕ್ತಿನ್ ಗಿರೆ ಸೊಡ್ಸುತಾ ಹೊಲ್ಯಾರ್, ತುಮ್ಚೆ ವಾಂಗ್ಡಿ ಕಸ್ಲ್ಯಾ ತಾಕ್ತಿನ್ ಗಿರೆ ಕಾಡ್ತ್ಯಾತ್. ತುಮ್ಚೆ ವಾಂಗ್ಡಿಚ್ ತುಮಿ ಚುಕ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“ಮಿಯಾ ದೆವಾಚ್ಯಾ ಬಳಾನ್ ಗಿರೆ ಕಾಡ್ತಾ, ಅನಿ ಹೆ, ದೆವಾಚೆ ರಾಜ್ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಯೆವ್ನ್ ಹೊಲಾ ಮನುನ್ ತುಮ್ಕಾ ದಾಕ್ವುನ್ ದಿತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ಕನ್ನಾ ಎಕ್ ಘಟ್-ಮುಟ್ ಮಾನುಸ್,ಅಪ್ನಾಚಿ ಹತಿಯಾರಾ ಘೆವ್ನ್, ಅಪ್ನಾಚೆ ಘರ್ ರಾಕ್ತಾ, ತರ್, ತೆಚೆ ಸಗ್ಳೆ ಸುರಕ್ಷಿತ್ ಹಾಯ್ ಮನುನ್ ಜಾಲೆ, ");
INSERT INTO kans_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ಖರೆ, ಎಕ್ ತೆಚೆನ್ಕಿ ಘಟ್-ಮುಟ್ ಮಾನುಸ್ ಯೆವ್ನ್ ತೆಚೆಕ್ಡೆ ಝಗಡ್ತಾ, ಅನಿ ತೆಕಾ ಹಾರ್‍ವುತಾ, ತನ್ನಾ, ತೊ ಘರಾಚೊ ವಡಿಲ್ ಹೊಂದುನ್ ಹೊತ್ತಿ ಸಗ್ಳಿ ಹತಿಯಾರಾ, ಅನಿ ಸಗ್ಳೆ ತೊ ಚೊರುನ್ ಘೆವ್ನ್ ಜಾತಾ, ಅನಿ ವಾಟೆ ಕರುನ್ ಘೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ಜೆ ಕೊನ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ನಾ, ತೊ ಮಾಜ್ಯಾ ವಿರೊದುಚ್, ಅನಿ ಕೊನ್ ಮಾಕಾ ಗೊಳಾ ಕರುಕ್ ಮಜತ್ ಕರಿನಾ, ತೊ ಖರೆಚ್ ಮಾಳ್ಬರ್ ಕರುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಹೊಲೆ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ಎಕ್ ಮಾನ್ಸಾಕ್ನಾ ಗಿರೊ ಭಾಯ್ರ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತೊ ಸಗ್ಳೆಕ್ಡೆ ಫಿರುನ್, ಅಪ್ನಾಕ್ ರ್‍ಹಾವ್ಕ್ ಜಾಗೊ ಗಾವ್ತಾ ಕಾಯ್ ಮನುನ್ ಬಗ್ತಾ. ತೆಕಾ ಖೈಬಿ ಜಾಗೊ ಗಾವಿನಸ್ಲ್ಯಾರ್, ತೆ ಅಪ್ನಾಕುಚ್ ಮಿಯಾ ಅನಿ ಪರ್ತುನ್ ಮಾಜ್ಯಾ ಘರಾಕ್ ಜಾತಾ” ಮನ್ತಾ, ");
INSERT INTO kans_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ತಸೆ ಮನುನ್, ತೆ, ಫಾಟಿ ಪರ್ತುನ್ ಜಾತಾ, ಅನಿ ತೆಕಾ, ತೆ ಘರ್ ಬರೆ, ಅನಿ ಪವಿತ್ರ್ ಹೊತ್ತೆ ದಿಸ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ತನ್ನಾ ತೊ ಗಿರೊ ಪರ್ತುನ್ ಫಾಟಿ ಜಾತಾ, ಅನಿ ಅಪ್ನಾಚ್ಯಾನ್ಕಿ ಬುರ್ಶ್ಯಾ ಸಾತ್ ಗಿರ್‍ಯಾಕ್ನಿ ಘೆವ್ನ್ ಯೆತಾ, ಮಾನಾ ತೆನಿ ಸಗ್ಳೆ ಜಾನಾ, ಥೈ ಯೆವ್ನ್ ರ್‍ಹಾತ್ಯಾತ್. ಅಶೆ ಸಗ್ಳೆ ಹೊವ್ನ್ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ, ತೊ ಮಾನುಸ್ ಅದ್ದಿ ಹೊತ್ತ್ಯಾನ್ಕಿ ಬುರ್ಶ್ಯಾ ಪರಿಸ್ತಿತಿಕ್ ಯೆವ್ನ್ ಪಾವ್ತಾ, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ಹೆ ಸಗ್ಳೆ ಜೆಜುನ್ ಸಾಂಗ್ತಲೆ ಆಯ್ಕುನ್, ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ಲ್ಯಾ ಎಕ್ ಬಾಯ್ಕೊಮನ್ಸಿನ್ “ತುಕಾ ಅಪ್ನಾಚ್ಯಾ ಪೊಟಾತ್ ಥವ್ನ್ ಘೆವ್ನ್ ತುಕಾ ಬಾರಿಕ್ ಮೊಟೆ ಕರಲ್ಲ್ಯಾ ತುಜ್ಯಾ ಬಾಯ್ಚೆ ನಸಿಬ್ ಕವ್ಡೆ ಬರೆ ಅಸಿಲ್!” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ಖರೆ ಜೆಜುನ್ ತನ್ನಾ ತಿಕಾ “ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುನ್, ತೆಚೆ ಸರ್ಕೆ ಚಲ್ತಲ್ಯಾಂಚೆ ನಸಿಬ್ ತಿಚ್ಯಾನ್ಕಿ ಬರೆ”, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ಲೊಕಾ ಜೆಜುಚ್ಯಾ ಭೊತ್ಯಾನಿ ಯೆವ್ನ್-ಯೆವ್ನ್ ಗೊಳಾ ಹೊತಾನಾ, ಜೆಜುನ್ “ಹ್ಯಾ ಕಾಲಾತ್ಲಿ ಲೊಕಾ ಕವ್ಡಿ ವಾಯ್ಟ್! ತೆನಿ ವಿಚಿತ್ರ್ ಕಾಮ್ ಇಚಾರ್‍ತ್ಯಾತ್. ಖರೆ ಜೊನಾ ಪ್ರವಾದ್ಯಾಚ್ಯಾ ಜಿವನಾತ್ ಹೊಲ್ಲ್ಯಾ ವಿಚಿತ್ರ್ ಕಾಮಾಚ್ಯಾನ್ಕಿ, ಅನಿ ದುಸ್ರೆ ವಿಚಿತ್ರ್ ಕಾಮ್ ಹೆಂಕಾ ಕರುನ್ ದಾಕ್ವುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ನಿನಿವೆ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಜೊನಾ ಕಸೊ, ಎಕ್ ವಳಕ್ ಹೊವ್ನ್ ಹೊತ್ತೊ, ತಸೆಚ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಅತ್ತಾಚ್ಯಾ ಕಾಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಎಕ್ ವಳಕ್ ಸರ್ಕೊ ಹೊವ್ನ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ, ಶೆಬಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಚಿ ರಾನಿ ಸೈತ್, ಹ್ಯಾ ಅತ್ತಾಚ್ಯಾ ಕಾಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಚುಕಿದಾರ್ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಸೊಲೊಮೊನ್ ರಾಜಾಚ್ಯಾ ಬುದ್ವಂತ್ಕಿಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುಕ್ ತಿ, ಅಪ್ನಾಚ್ಯಾ ದೆಸಾತ್ನಾ ಫಿರು-ಫಿರುನ್ಗೆತ್ ಯೆಲ್ಲಿ. ಅನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಹಿತ್ತೆ ಕಾಯ್ಕಿ ಸಾಲ್ಮಾವಾಚ್ಯಾನ್ಕಿ ಮೊಟೆ ಹಾಯ್ . ");
INSERT INTO kans_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ಝಡ್ತಿಚ್ಯಾ ದಿಸಿ, ನಿನಿವೆಚಿ ಲೊಕಾ ಇಬೆ ರ್‍ಹಾವ್ನ್ ತುಮ್ಚಿ ಚುಕಾ ದಾಕ್ವುನ್ ದಿತ್ಯಾತ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜೊನಾ ಪ್ರವಾದ್ಯಾನ್ ಸಾಂಗಲ್ಲೆ ಆಯ್ಕಲ್ಲೆಚ್, ತೆನಿ ದೆವಾಕ್ಡೆ ಫಾಟಿ ಪರತ್ಲ್ಯಾನಿ; ಅನಿ ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಹಿತ್ತೆ ಜೊನಾ ಪ್ರವಾದ್ಯಾಚ್ಯಾನ್ಕಿ ಮೊಟೊ ಹಿತ್ತೆ ಹಾಯ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ಕೊನ್ಬಿ ದಿವೊ ಪೆಟ್ವುನ್ ಭೊಗುನ್ಯಾಚ್ಯಾ ಬುಡಿ ನಾ ತರ್ ನಿಜ್ತಲ್ಯಾ ಮಾಚೊಳಿಚ್ಯಾ ಬುಡಿ ಧಾಪುನ್ ಥಯ್ನಾ, ತೊ, ತೊ ದಿವೊ ವೈರ್ ದಿವೊ ಥವ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಥವ್ತಾ. ಅಶೆ ಲೊಕಾ ಘರಾತ್ ಭುತ್ತುರ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಂಕಾ ಉಜ್ವೊಡ್ ದಿಸ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ತುಮ್ಚೆ ಡೊಳೆ ತುಮ್ಚ್ಯಾ ಆಂಗಾಚೆ ದಿವೆ. ಕನ್ನಾ ತುಜೆ ಡೊಳೆ ಸಮಾ ಹಾತ್ ತನ್ನಾ ತುಜ್ಯಾ ಸಗ್ಳ್ಯಾ ಆಂಗಾಕ್ ಉಜ್ವೊಡ್ ರ್‍ಹಾತಾ.ಕನ್ನಾ ತುಮ್ಚೆ ಡೊಳೆ ಸಮಾ ನಾತ್, ತನ್ನಾ ತುಮ್ಚೆ ಸಗ್ಳೆ ಆಂಗುಚ್ ಕಾಳ್ಕಾತ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ತುಮ್ಚೆ ಭುತ್ತುರ್‍ಲೊ ಉಜ್ವೊಡ್ ಕಾಳೊಕ್ ಹೊಯ್ನಶಿ ಸರ್ಕೆ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ಜರ್‌ತರ್ ತುಜೆ ಸಗ್ಳೆ ಆಗ್ ಉಜ್ವೊಡಾತ್ ಹಾಯ್; ತರ್, ತುಜ್ಯಾ ಆಂಗಾಚೊ ಖಲೊ ಭಾಗ್‍ಬಿ ಕಾಳ್ಕಾತ್ ನಾ ಮನುನ್ ಹೊಲೆ, ಕಶೆ ಎಕ್ ದಿವೊ ಪೆಟಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮ್ಚೆ ವರ್‍ತಿ ಕಸೊ ಉಜ್ವೊಡ್ ಪಡ್ತಾ, ತಸೆ, ತುಮಿ ರ್‍ಹಾತ್ಯಾಶಿ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ಜೆಜುಚೆ ಬೊಲುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಎಕ್ ಫಾರಿಜೆವಾನ್ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಘರಾಕ್ ಜೆವ್ನಾಕ್ ಬಲ್ವುಲ್ಯಾನ್. ತನ್ನಾ ತೊ ತ್ಯಾ ಘರಾತ್ ಗೆಲೊ, ಅನಿ ಜೆವ್ನಾಕ್ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ಹೆ ಬಗುನ್ ತೊ ಫಾರಿಜೆವ್ ಅಜಾಪ್ ಹೊಲೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜೆಜುನ್ ಜೆವ್ನಾಕ್ ಬಸುಚ್ಯಾ ಅದ್ದಿ ಹಾತ್ ಧುವ್ನ್ ಘೆವ್‍ನತ್ತ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ತನ್ನಾ ಜೆಜುನ್ ತುಮ್ಚಿ ವಾಟ್ಕಿ ಆಯ್ದಾನಾ ಪವಿತ್ರ್ ಹಾತ್, ಖರೆ ಭುತ್ತುರ್ನಾ ತುಮಿ ಸಗ್ಳೆ ಹಾಳ್ ಕರ್‍ತಲಿ, ಅನಿ ಬುರ್ಶಿ ಲೊಕಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ಪಿಶ್ಯಾನೊ! ಭಾಯ್ಲೆ ಕರಲ್ಲ್ಯಾ ದೆವಾನುಚ್, ಭುತ್ತುರ್‍ಲೆಬಿ ಕರಲ್ಲೆ ಹಾಯ್ ಹೊಯ್ ಕಾಯ್ ನ್ಹಯ್? ");
INSERT INTO kans_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ತುಮ್ಚ್ಯಾ ವಾಟ್ಕ್ಯಾತ್ನಿ, ಅನಿ ಆಯ್ದಾನಾತ್ನಿ ಹೊತ್ತೆ, ಗರಿಬಾಕ್ನಿ ದಿವಾ, ಅನಿ ತುಮಿ ಪದ್ದತಿ ಪರ್‌ಕಾರ್ ಸಗ್ಳೆ ಪವಿತ್ರ್ ಹೊತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ಫಾರಿಜೆವಾನೊ ಮಿಯಾ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ತುಮಿ ಧಾ ತ್ಲೊ ಎಕ್ ವಾಟೊ ಮಟ್ಲ್ಯಾರ್, ಪುದಿನಾ, ಅನಿ ಅಸ್ಲ್ಯಾ ತಸ್ಲ್ಯಾ ಬಾರಿ-ಬಾರಿಕ್ಲ್ಯಾ ಝಾಡಾಂಚ್ಯಾ ಪಿಕಾತ್ಲೊ ಸೈತ್ ವಾಟೊ ದೆವಾಕ್ ದಿತ್ಯಾಶಿ, ಖರೆ, ದುಸ್ರ್ಯಾಕ್ನಿ ಬರೆ ಕರ್‍ತಲ್ಯಾಕ್, ಅನಿ ದೆವಾಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಲ್ಯಾಕ್, ತುಮಿ ತುಮ್ಚೆ ಧ್ಯಾನುಚ್ ದಿ ನಾ ಹೊಲ್ಯಾಶಿ. ದುಸ್ರ್ಯಾಕ್ನಿ ಬರೆ ಕರುಂಗೆತ್ ತುಮಿ, ಹೆ, ಅದ್ದಿ ಕರಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ಫಾರಿಜೆವಾನೊ ಮಿಯಾ ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಸಿನಾಗೊಗಾತ್ನಿ ಬರ್‍ಯಾ ಬರ್‍ಯಾ ಜಾಗ್ಯಾವೈನಿ ಬಸ್ತಲಿ, ತುಮ್ಕಾ ಲೈ ಕುಶಿ. ಅನಿ ಬಾಜಾರಾತ್, ವನಿಯಾತ್ನಿ, ಲೊಕಾನಿ ತುಮ್ಕಾ ನಮಸ್ಕಾರ್ ಕರ್ಲ್ಯಾರ್, ತುಮ್ಕಾ ಲೈ ಕುಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ತುಮಿ ಕಾಯ್ಬಿ ವಳಕ್ ನಸಲ್ಲ್ಯಾ ಸಾರಿಯಾಂಚ್ಯಾ ಸರ್ಕೆ, ಲೊಕಾ ತೆಂಕಾ ಗೊತ್ತ್ ನಸ್ತಾನಾ ತೆಂಚ್ಯಾ ವೈನಾ ಫಿರುನ್ ಖೆಳ್ತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ತನ್ನಾ ಎಕ್ಲೊ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲೊ, ಜೆಜುಕ್ “ಗುರುಜಿ, ಹೆ ಸಗ್ಳೆ ಸಾಂಗುನ್ ತಿಯಾ ಅಮ್ಚಿ ಮರ್‍ಯಾದ್ ಕಾಡುಲೆ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ತನ್ನಾ ಜೆಜುನ್ “ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾನು ತುಮಿ ಕವ್ಡೆ ಭಯಂಕರ್! ತುಮಿ ವಾವುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಹೊವ್‍ ನ್ಹಯ್ ತವ್ಡೆ ಮೊಟೆ ವಜ್ಜೆ, ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿ ವಾವ್ತ್ಯಾಶಿ. ಖರೆ ತೆ, ವಜ್ಜೆ ವಾವುಕ್ ಮಜತ್ ಕರುಕ್ ಮನುನ್ ಹಾತ್ ಫಿಡೆ ಕರುನ್ ಎಕ್ ಬೊಟ್ ಸೈತ್ ತ್ಯಾ ವಜ್ಜ್ಯಾಕ್ ಲಾವಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ತುಮಿ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಮನುನ್ ಬರ್‍ಯಾ-ಬರ್‍ಯಾ ಸಮಾದ್ಯಾ ಭಾಂದ್ತ್ಯಾಶಿ, ಅದ್ಲ್ಯಾ ತುಮ್ಚ್ಯಾ ವಾಡ್ ವಡ್ಲಾನಿ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಜಿವಾನಿ ಮಾರ್‍ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ಅಶೆ ತುಮಿ ತುಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ವಾಡ್ ವಡ್ಲಾನಿ ಕಾಯ್ ಕರ್‍ಲ್ಯಾನಿ ಮನುನ್ ತುಮಿಚ್ ದಾಕ್ವುನ್ ದಿವ್ಕ್ ಲಾಗ್ಲ್ಯಾಶಿ, ತೆನಿ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಜಿವಾನಿ ಮಾರ್‍ಲ್ಯಾನಿ. ತುಮಿ ತೆಂಕಾ ಸಮಾದ್ಯಾ ಭಾಂದ್ಲ್ಯಾಶಿ”. ");
INSERT INTO kans_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ಹ್ಯಾ ಕಾರನಾಕ್ ಸಾಟ್ನಿ ದೆವಾಚಿ ಬುದ್ವಂತ್ಕಿ ಮನ್ತಾ ಮಿಯಾ ತೆಂಚೆಕ್ಡೆ ಪ್ರವಾದ್ಯಾಕ್ನಿ, ಅನಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ತಲ್ಯಾಕ್ನಿ ಧಾಡುನ್ ದಿತಾ; ತ್ಯಾತುರ್‍ಲ್ಯಾ ಥೊಡ್ಯಾಕ್ನಿ ಜಿವಾನಿಚ್ ಮಾರ್‍ತ್ಯಾತ್, ಅನಿ ಉಲ್ಲ್ಯಾಕ್ನಿ ತರಾಸ್ ದಿತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ತೆಚೆಸಾಟ್ನಿ ಜಗ್ ರಚಲ್ಲ್ಯಾಕ್ನಾ ಆಜ್ ಪತರ್ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾಚಿ ಶಿಕ್ಷಾ ಹ್ಯಾ ಕಾಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ಅಬೆಲಾಕ್ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾಕ್ನಾ ಧರುನ್ ಅಲ್ತಾರ್, ಅನಿ ಪವಿತ್ರ್ ಜಾಗ್ಯಾಚ್ಯಾ ಮದ್ದಿ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾ ಜೆಕರಿಯಾ ಪತರ್,ಹೊಯ್, ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ಹ್ಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾಸಾಟ್ನಿ ಅತ್ತಾಚ್ಯಾ ಕಾಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಶಿಕ್ಷಾ ಗಾವ್ತಾ! ");
INSERT INTO kans_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾನು ತುಮ್ಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಬುದ್ವಂತ್ಕಿಚ್ಯಾ ಘರಾಚ್ಯಾ ದಾರಾಚಿ ಚಾವಿ ತುಮಿ ತುಮ್ಚೆಕ್ಡೆ ಥವ್ನ್ ಘೆಟ್ಲ್ಯಾಶಿ, ತುಮಿಬಿ ಭುತ್ತುರ್ ಜಾಯ್‌ನ್ಯಾಶಿ, ಅನಿ ಭುತ್ತುರ್ ಜಾವ್ಕ್ ಖಟ್‍ಪಟ್ತಲ್ಯಾಕ್ನಿಬಿ ತುಮಿ ಜಾವ್ಕ್ ಸೊಡಿನ್ಯಾಶಿ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ಜೆಜು ತೊ ಜಾಗೊ ಸೊಡುನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಫಾರಿಜೆವಾ ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲೆ ಗಾವ್ತಾ ತೆಸೆ ಬೊಲುನ್ಗೆತ್, ಅನಿ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಎಕಾಮೆಕಾಕ್ ಪರಸ್ನೆ ಇಚಾರುನ್ಗೆತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ಅನಿ ಜೆಜುಕ್ ಗೊಂದ್ಳುನ್ ಘಾಲುನ್, ತೆಕಾ ಧರುಕ್ ಮನುನ್ ಬಗುಲಾಗಲ್ಲೆ. ತೆನಿ ಕಾಯ್ ತರ್ ಚುಕ್ ಕರಿ ಸರ್ಕೆ ಕರುಕ್ ಖಟ್ಪಟುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ತ್ಯಾಚ್ ಎಳಾರ್ ಹಜಾರಾನ್ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಥೈ ಗೊಳಾ ಹೊಲ್ಲೊ. ತೆಚೆಸಾಟ್ನಿ ತಿ ಲೊಕಾ ಎಕಾಮೆಕಾಕ್ನಿ ತುಡ್ವುನ್ ಘೆವ್‍ಲಾಗಲ್ಲಿ. ಜೆಜು ಅದ್ದಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ “ಫಾರಿಜೆವಾಂಚ್ಯಾ ಇಸ್ಟಾಚ್ಯಾ ವಿಶಯಾತ್ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ- ತಸೆ ಮಟ್ಲ್ಯಾರ್ ತೆಂಚ್ಯಾ ಕುಸ್ಡ್ಯಾಪಾನಾಚ್ಯಾ ವಿಶಯಾತ್ ಮಟ್ಲೊ ಮಿಯಾ, ");
INSERT INTO kans_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ಜೆ ಕಾಯ್ ಧಾಪುನ್ ಥವಲ್ಲೆ ಹಾಯ್, ತೆ ಉಗ್ಡುನ್ ಹೊತಾ. ಅನಿ ಸಗ್ಳೆ ಘುಟ್ ಮಾಳಾಕ್ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ತನ್ನಾ ಜೆ ಕಾಯ್ ತುಮಿ ಕಾಳ್ಕಾತ್ ಸಾಂಗ್ಲ್ಯಾಶಿ, ತೆ ಮೊಟ್ಯಾ ದಿಸಾಚ್ಯಾ ಉಜ್ವೊಡಾತ್ ಆಯ್ಕುಕ್ ಗಾವ್ತಾ. ಅನಿ ಕಾಯ್-ಕಾಯ್ ತುಮಿ ಎಕ್ ಬಂದ್ ಹೊತ್ತ್ಯಾ ಖೊಲಿತ್ ಪುಸ್ಪುಸುನ್ ಬೊಲ್ಲ್ಯಾಶಿ, ತೆ, ಘರಾಚ್ಯಾ ವರ್‍ತಿ ಬಸುನ್ ಜೊರಾನಿ ಸಾಂಗುನ್ ಹೊತಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ಮಾಜ್ಯಾ ದೊಸ್ತಾನೊ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಆಂಗಾಚೊ ಜಿವ್ ಕಾಡ್ತಲ್ಯಾಕ್ ಭಿಂವ್‍ನಕಾಶಿ, ತೆಚೆನ್ ಮೊಟೆ ಅನಿಕಾಯ್ಬಿ ತೆಕಾ ಕರುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ಖರೆ ಕೊನಾಕ್ ಭಿಂವ್ಚೆ ಮನುನ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ಆಯ್ಕಾ ತುಮಿ ದೆವಾಕ್ ಭಿಂವಾ, ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾ ಮಾನಾ ನರ್‍ಕಾತ್ ನ್ಹೆವ್ನ್ ಘಾಲ್ತಲೊ ಅದಿಕಾರ್ ತೆಕಾ ಹಾಯ್. ಮಾಜೆರ್ ವಿಶ್ವಾಸ್ ಕರಾ, ತುಮಿ ಭಿಂವ್ಕ್ ಪಾಜೆ ಹೊತ್ತೆ ತೆಕಾ ಎವ್ಡೆಚ್! ");
INSERT INTO kans_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ಪಾಚ್ ಗುಬ್‍ಯಾ ದೊನ್ ಪೈಸ್ಯಾಕ್ನಿ ಇಕಿನಾತ್ ಕಾಯ್? ಜಾಲ್ಯಾರ್‍ಬಿ ಎಕ್ ಗುಬ್ಬಿಕ್ ಸೈತ್ ದೆವಾನ್ ಇಸ್ರುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ತುಮ್ಚ್ಯಾ ಟಕ್ಲ್ಯಾಚಿ ಕೆಸಾ ಸೈತ್ ಮೆಜುನ್ ಥವಲ್ಲಿ ಹಾತ್, ತೆಚೆಸಾಟ್ನಿ ಭಿಂವ್ನಕಾಶಿ,ತುಮಿ ಗುಬ್‍ಯಾಂಚ್ಯಾನ್ಕಿ ಲೈ ಕಿಮ್ತಿಚೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಮದ್ದಿ ತುಮಿ ಮಾಜೆ ಮನುನ್ ಸಾಂಗಟಲ್ಲ್ಯಾನೊ, ಮಿಯಾ ತುಮ್ಕಾ ಗೊಸ್ಟ್ ದಿತಾ, ಮಾನ್ಸಾಚೊ ಲೆಕ್‍ಬಿ ದೆವಾಚ್ಯಾ ದುತಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ತುಮಿ ಅಪ್ನಾಚಿ ಲೊಕಾ ಮನುನ್ ಘೆತಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ಖರೆ ಜೆ ಕೊನ್ ಲೊಕಾತ್ನಿ ಮಾಜೊ ಮನುನ್ ಘೆಯ್ನಾ, ತೆಂಕಾ ದೆವಾಚ್ಯಾ ದುತಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್‍ಬಿ ಅಪ್ನಾಚೊ ಮನುನ್ ಘೆಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ಕೊನ್ಬಿ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಚ್ಯಾ ವಿರೊದ್ ಕಾಯ್ಬಿ ಸಾಂಗಟ್ಲ್ಯಾರ್‍ಬಿ, ತೆಕಾ ಮಾಪಿ ಗಾವ್ತಾ, ಖರೆ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚ್ಯಾ ವಿರೊದ್ ಜೆ ಕೊನ್ ಬುರ್ಶೆ ಬೊಲ್ತಾ, ತೆಂಕಾ ಕನ್ನಾಚ್ ಮಾಪಿ ಗಾವಿನಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ತೆನಿ ತುಮ್ಚಿ ಇಚಾರ್‍ನಿ ಕರುಕ್ ಮನುನ್, ಸಿನಾಗೊಗಾತ್ನಿ, ಅನಿ ಅದಿಕಾರ್‍ಯಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಹಾನ್ತಾನಾ, ತುಮಿ ,ತುಮ್ಕಾಚ್ ಕಶೆ ಕರುನ್ ರಾಕುನ್ ಘೆತಲೆ, ಅನಿ ಕಾಯ್ ಬೊಲ್ತಲೆ ಮನುನ್ಬಿ ಯವ್ಜುನಕಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಪವಿತ್ರ್ ಆತ್ಮೊ ತುಮ್ಕಾ ತ್ಯಾ ಎಳಾರ್ ಕಾಯ್ ಬೊಲ್ತಲೆ ಮನುನ್ ಶಿಕ್ವುತಾ, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ತ್ಯಾ ಲೊಕಾನಿತ್ಲ್ಯಾ ಎಕ್ ಮಾನ್ಸಾನ್ ಜೆಜುಕ್ “ಗುರುಜಿ; ಮಾಜ್ಯಾ ಭಾವಾಕ್ ಅಮ್ಚ್ಯಾ ಬಾಬಾನ್ ಅಮ್ಚ್ಯಾಸಾಟ್ನಿ ಸೊಡುನ್ ಗೆಲ್ಲಿ ಆಸ್ತಿ ಅಮ್ಕಾ ವಾಟುನ್ ದಿ ಮನುನ್ ಸಾಂಗ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ತನ್ನಾ ಜೆಜುನ್ “ಮಾಜ್ಯಾ ದೊಸ್ತಾ, ತುಮ್ಕಾ ನ್ಯಾಯ್ ಕರುನ್ ದಿವ್ಕ್ ಮಿಯಾ ಕೊನ್? ತುಮ್ಚಿ ಅಸ್ತಿ ವಾಟುನ್ ದಿತಲೊ ಅದಿಕಾರ್ ಮಾಕಾ ಕೊನ್ ದಿಲಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ಅನಿ ಥೈ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ತೊ “ಸಗ್ಳ್ಯಾ ರಿತಿಚ್ಯಾ ಹವ್ರೆಪಾನಾನಿತ್ನಾ ತುಮ್ಕಾಚ್ ತುಮಿ ರಾಕುನ್ ಘೆವಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಎಕ್ ಮಾನ್ಸಾನ್ ಜಿವ್ ಕಮ್ವುನ್ ಘೆತಲೆ, ತೆನಿ ಕಾಯ್ ಕಮ್ವುಲ್ಯಾನಾಯ್, ಅನಿ ತೆಚಿ ಕವ್ಡಿ ಸಾವ್ಕಾರ್ಕಿ ಹಾಯ್, ತೆಚೆ ವರ್‍ತಿ ಹೊಂದುನ್ ನಾ”, ಮನುನ್ ಸಾಂಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಹಿ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್ “ಬರೆ ಪಿಕ್ ಯೆಲ್ಲೆ, ಬರೆ ಶೆತ್ ಹೊತ್ತೊ ಎಕ್ ಸಾವ್ಕಾರ್ ಮಾನುಸ್ ಹೊತ್ತೊ”. ");
INSERT INTO kans_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ತೊ “ಮಿಯಾ ಮಾಜೆ ಪಿಕ್ ಖೈ ಭರುನ್ ಥವ್ಚೆ? ಮಿಯಾ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಯವ್ಜುಕ್‍ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ಮಾನಾ ತೊ, “ಮಿಯಾ ಅಶೆ ಕರ್‍ತಾ;” ಅತ್ತಾ ಹೊತ್ತಿ ಮಾಜಿ ಗುಡಾನಾ ಮಿಯಾ ಮೊಡುನ್ ಮೊಟಿ ಕರುನ್ ಭಾಂದ್ತಾ, ತನ್ನಾ ಮಿಯಾ ಮಾಜೆ ಸಗ್ಳೆ ಪಿಕ್, ಅನಿ ಕಾಯ್ ಹಾಯ್, ತೆ, ತ್ಯಾತುರ್‍ನಿ ಭರುನ್ ಥವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ತನ್ನಾ ಮಾಕಾಚ್ ಮಿಯಾ “ಬರ್‍ಯಾ ನಸಿಬಾಚ್ಯಾ ಮಾನ್ಸಾ! ಸುಮಾರ್, ವರ್ಸಾನ್ ವರಿಸ್ ಪಾವಿ ಸರ್‍ಕೆ ಬರೆ ಬರೆ ತುಜೆಕ್ಡೆ ಅತ್ತಾ ಹಾಯ್ , ಖಾ, ಫಿ,ಅನಿ ಗಮ್ಮತ್ ಮಾರ್”, ಮನುನ್ ಘೆತಾ ಮನುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ಖರೆ ದೆವಾನ್ ತೆಕಾ “ಪಿಶ್ಯಾ! ಆಜ್ ರಾಚ್ಚೆ ತಿಯಾ ತುಜೊ ಜಿವ್ ಮಾಕಾ ಪರ್ತುನ್ ದಿವ್ಕ್ ಪಾಜೆ; ತನ್ನಾ ತಿಯಾ ತುಕಾ ಮನುನ್ ಗೊಳಾ ಕರುಕ್ ಥವಲ್ಲೆ ಹೆ ಸಗ್ಳೆ ಕೊನಾಚೆ ಹೊತಾ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ಅಶೆ ಜೆಜುನ್ “ಸಾವ್ಕಾರ್ಕಿ ಗೊಳಾ ಕರುಕ್ ಘೆವ್ನ್ ಹೊತ್ತಿ ಲೊಕಾ, ದೆವಾಚ್ಯಾ ಇದ್ರಾಕ್ ಸಾವ್ಕಾರ್ ನ್ಹಯ್”, ಮನುನ್ ಕಾನಿ ಸಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ತನ್ನಾ ಜೆಜು ಶಿಸಾಕ್ನಿ ಹೆಚ್ಯಾ ಸಾಟ್ನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಲೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, ಝಿತ್ತೆ ರ್‍ಹಾವ್‍ಸಾಟ್ನಿ ತುಮ್ಚ್ಯಾ ಜಿವಾಕ್ ಕಾಯ್ ಖಾತಲೆ, ನಾಹೊಲ್ಯಾರ್ ಆಂಗಾರ್ ಕಾಯ್ ನೆಸ್ತಲೆ ಮನುನ್ ಯವ್ಜನ್ ಕರುನಕಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ಜಿವ್; ಜೆವ್ನಾನ್‍ಬಿ ಲೈ ಕಿಮ್ತಿಚೊ. ಅನಿ ಆಂಗ್ ನೆಸ್ತಲ್ಯಾ ಕಪ್ಡ್ಯಾಂಚಾನ್ಕಿ ಲೈ ಕಿಮ್ತಿಚೆ. ");
INSERT INTO kans_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ಫಾಂಕ್ರಾಕ್ನಿ ಬಗಾ; ತೆನಿ ಭ್ಹಿಂಯ್ ಪೆರಿನ್ಯಾತ್, ನಾ ದಾನೆ ಗೊಳಾ ಕರುನ್ ಥವ್ನ್ ಘೆಯ್‌ನ್ಯಾತ್. ತೆಂಚಿ ದಾನೆ ಗೊಳಾ ಕರುನ್ ಥವ್ತಲಿ ಗುಡಾನಾ ನಾತ್, ದೆವ್ ತೆಂಕಾ ಜೆವಾನ್ ದಿತಾ. ಫಾಂಕ್ರಾಂಚ್ಯಾನ್ಕಿ ತುಮಿ ಲೈ ಕಿಮ್ತಿಚೆ. ");
INSERT INTO kans_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ಯವ್ಜುನ್ -ಯವ್ಜುನ್ ತುಮಿ ತುಮ್ಚ್ಯಾ ಜಿವನಾಚಿ ಅದ್ದಿ, ಎಕ್‍ ಉಲ್ಲಿಸಿ ತರ್ಬಿ ಜಾಸ್ತಿ ಕರುನ್ ಘೆವ್ಕ್ ಹೊತಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ಜರ್ ಎವ್ಡೆ ಬಾರಿಕ್ ಕಾಮ್ ತುಮ್ಚ್ಯಾ ಹಾತಿನ್ ಕರುಕ್ ಹೊಯ್ನಾ, ತರ್ ದುಸ್ರ್ಯಾ ಸಗ್ಳ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ಕಶ್ಯಾಕ್ ಯವಜ್ತ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ತಿ, ಡಂಗ್ಳಾತ್ಲಿ ಫುಲ್ಲಾ ಕಸೆ ವಾಡ್ತ್ಯಾತ್ ಬಗಾ; ತೆನಿ ಕಾಮ್ ಕರಿನ್ಯಾತ್, ನಾ ಅಪ್ನಾಕ್ ಮನುನ್ ಕಪ್ಡೆ ತಯಾರ್ ಕರಿನ್ಯಾತ್. ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಸಾಲ್ಮಾವ್ ರಾಜಾ ಸೈತ್, ಅಪ್ನಾಚ್ಯಾ ಸಗ್ಳ್ಯಾ ವೈಭವಾನ್ ಹ್ಯಾತುರ್‍ಲ್ಯಾ ಎಕುಚ್ಎಕ್ ಫುಲ್ಲಾ ಸರ್ಕೊ ನೆಸುಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ದೆವ್ ತ್ಯಾ ಫುಲ್ಲಾಕ್ನಿ ನೆಸ್ವುತಾ. ಆಜ್ ರ್‍ಹಾವ್ನ್ ಉದ್ದ್ಯಾ ಚುಲಿತ್ ಜಳುನ್ ಜಾತಲ್ಯಾ ಡಂಗ್ಳಿತ್ಲ್ಯಾ ಗವ್ತಾಕ್, ದೆವ್, ಅಶೆ ಎವ್ಡೆ ಬರೆ ಕರುನ್ ನೆಸ್ವುತಾ! ತರ್ ತುಮ್ಕಾ ಕವ್ಡೆ ಬರೆ ಕರ್‍ತಾ ಅಸಿಲ್? ಕವ್ಡೊ ಕಮಿ ವಿಶ್ವಾಸ್ ತುಮ್ಚೊ! ");
INSERT INTO kans_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ತೆಚೆಸಾಟ್ನಿ, ತುಮಿ ಕನ್ನಾಬಿ, ಕಾಯ್ ಖಾತಲೆ, ಅನಿ ಕಾಯ್ ಫಿತಲೆ, ಮನುನ್ ಲೈ ಟಕ್ಲೆ ನಾಸ್ವುನ್ ಘೆವ್‍ನಕಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ಹ್ಯಾ ಜಗಾತ್ಲಿ ಕಾಯ್ಬಿ ಗೊತ್ತ್ ನಸಲ್ಲಿ ಲೊಕಾ ಹೆ ಸಗ್ಳೆ ಯವಜ್ತ್ಯಾತ್. ತುಮ್ಕಾ ಕಾಯ್ ಪಾಜೆ ಮನುನ್ ತುಮ್ಚ್ಯಾ ಬಾಬಾಕ್ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ಖರೆ ತುಮಿ ದೆವಾಚ್ಯಾ ರಾಜಾಚ್ಯಾ ವಿಶಯಾತ್ ಯವ್ಜಾ, ಅನಿ ಹೆಚ್ಯಾ ವಾಂಗ್ಡಾ ದೆವ್ ತುಮ್ಕಾ ಸಗ್ಳೆಬಿ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ಬಾರಿಕ್ಲ್ಯಾ ಹಿಂಡಾ ಭಿಂವ್‍ನಕೊ, ತುಜ್ಯಾ ಬಾಬಾಕ್ ಅಪ್ನಾಚೆ ರಾಜ್ ತುಕಾ ದಿವ್ಕ್ ಬರೆ ದಿಸ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ತುಮ್ಚೆ ಮನುನ್ ಹೊತ್ತೆ ಸಗ್ಳೆ ಇಕಾ, ಅನಿ ಯಲ್ಲೆ ಪೈಸೆ ಗರಿಬಾಕ್ನಿ ದಿವಾ, ಕೊನಾಕ್ಬಿ ಪಿಂಜುಕ್ ಹೊಯ್‍ ನಸಲ್ಲ್ಯಾ ಪಿಸ್ವಿಯಾ ತುಮ್ಕಾಚ್ ತುಮಿ ತಯಾರ್ ಕರುನ್ ಘೆವಾ, ಅನಿ ತುಮ್ಚೆ ಬದಿಕ್ ಸರ್‍ಗಾತ್ ಗೊಳಾ ಕರುನ್ ಥವಾ, ಥೈ ತೆ ಕನ್ನಾಚ್ ಕಮಿ ಹೊಯ್ನಾ! ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆ ಬದಿಕ್ ಚೊರಾಕ್ ಕನ್ನಾಚ್ ಗಾವಿನಾ, ಅನಿ ಥೈ ಕುಸಡ್ ಲಾಗಿನಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತುಮ್ಚೆ ಬದಿಕ್ ಖೈ ಹಾಯ್, ಥೈಚ್ ತುಮ್ಚಿ ಮನಾಬಿ ರ್‍ಹಾತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ಕಾಯ್ ಯೆತಾ ತೆಕಾ ತಯಾರ್ ರ್‍ಹಾವಾ. ಕಪ್ಡೆ ನೆಸುನ್, ಅನಿ ತುಮ್ಚೆ ದಿವೆ ಪೆಟ್ವುನ್ ಘೆವ್ನ್ ರ್‍ಹಾವಾ”. ");
INSERT INTO kans_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","“ಲಗ್ನಾಕ್ ಗೆಲ್ಲ್ಯಾ ಅಪ್ನಾಚ್ಯಾ ಮಾಲ್ಕಾಚಿ ವಾಟ್ ರಾಕುನ್ಗೆತ್ ರ್‍ಹಾತಲ್ಯಾ ಆಳಾ ಸರ್ಕೆ, ರಾಕುನ್ಗೆತ್ ರ್‍ಹಾವಾ. ಧನಿನ್ ಯೆವ್ನ್ ದಾರ್ ಬಡ್ವಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆನಿ ತಾಬೊಡ್ತೊಬ್ ದಾರ್ ಕಾಡ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ಧನಿ ಪರ್‍ತುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಜಾಗೆ ರ್‍ಹಾವ್ನ್, ತಯಾರ್ ಹೊತ್ತ್ಯಾ ಆಳಾಂಚೆ ಕವ್ಡೆ ಬರೆ! ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ. ತೊ ಅಪ್ನಾಚಿ ವೈಲಿ ಆಂಗಿ ಕಾಡುನ್ ಥವ್ತಾ, ಅನಿ ತೆಂಕಾ ಬಸುಕ್ ಲಾವ್ತಾ. ಅನಿ ತೆಂಕಾ ಅಪ್ನಿಚ್ ಜೆವಾನ್ ವಾಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ಧನಿ ಅರ್ದ್ಯಾ ರಾಚ್ಚೆ ಹೊಂವ್ದಿ ನಾ ಹೊಲ್ಯಾರ್ ತೆಚ್ಯಾನ್ ಎಳ್ ಕರುನ್ ಯೆಲ್ಯಾರ್‍ಬಿ ತೆನಿ ತಯಾರ್ ಹೊತ್ತೆ, ಧನಿಯಾನ್ ಬಗಟ್ಲ್ಯಾನ್ ತರ್, ತೆಂಚೆ ಕವ್ಡೆ ಬರೆ. ");
INSERT INTO kans_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ಘರಾಚ್ಯಾ ಮಾಲ್ಕಾಕ್, ಚೊರ್ ಹ್ಯಾಚ್ ಎಳಾರ್ ಯೆತಾ, ಮನುನ್ ಗೊತ್ತ್ ರ್‍ಹಾತಾ ಕಾಯ್, ಗೊತ್ತ್ ರ್‍ಹಾಲ್ಯಾರ್, ತೊ ಕನ್ನಾಬಿ ಅಪ್ನಾಚ್ಯಾ ಘರಾತ್ಲೆ ಚೊರುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ದಿ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ಅನಿ ತುಮಿಬಿ ತಯಾರ್ ರ್‍ಹಾವ್ಕ್ ಪಾಜೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತುಮಿ ಯವ್ಜುಕ್ ನಸಲ್ಲ್ಯಾ ಎಳಾರ್ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆತಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ಪೆದ್ರುನ್ ಜೆಜುಕ್ “ಧನಿಯಾ, ಹಿ ಕಾನಿ ಅಮ್ಕಾ ಸಮಂದ್‍ ಪಡ್ತಾ ಕಾಯ್, ಸಗ್ಳ್ಯಾಕ್ನಿಬಿ ಸಮಂದ್ ಪಡ್ತಾ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ತನ್ನಾ ಧನಿಯಾನ್ ಅಶೆ ಜಾಲ್ಯಾರ್ ವಿಶ್ವಾಸಾಚೊ ಅನಿ ಶಾನೊ ಆಳ್ ಕೊನ್? ತೊ ಕೊನ್‍ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, ಜೆ ಕೊನಾಕ್, ಧನಿ, ಘರಾಚಿ ಸಗ್ಳಿ ಜವಾಬ್ದಾರಿ, ಅನಿ ಹುರಲ್ಲ್ಯಾ ಆಳಾಕ್ನಿ, ಸಮಾ ಎಳಾರ್ ಜೆವಾನ್ ವಾಟುನ್ ದಿವ್ಕ್ ಮನುನ್ ನೆಮ್ತಾ, ತೊಚ್. ");
INSERT INTO kans_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ಧನಿ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಅಪ್ನಾಚಿ ಸಗ್ಳಿ ಜವಾಬ್ದಾರಿ ಸಂಬಾಳುನ್ ಘೆವ್ನ್ ತೊ ಆಳ್ ರ್‍ಹಾಲ್ಯಾರ್ ತ್ಯಾ ಆಳಾಚೆ ಕವ್ಡೆ ಬರೆ! ");
INSERT INTO kans_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ಖರೆಚ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಧನಿ ತ್ಯಾ ಆಳಾಕ್ ಅಪ್ನಾಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಅಸ್ತಿಚಿ ಜವಾಬ್ದಾರಿ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ಖರೆ, ಜರ್ ತೊ ಆಳ್, ಅಪ್ನಾಚೊ ಧನಿ ಪರ್ತುನ್ ಯೌಕ್ ಲೈ ಎಳ್ ಹೊತಾ ಮನುನ್ ಯವ್ಜುನ್ ಘೆವ್ನ್, ಹುರಲ್ಲ್ಯಾ ಆಳಾಕ್ನಿ ಘೊಮನುಸ್ ಅನಿ ಬಾಯ್ಕೊಮನುಸ್ ಮನಿನಸ್ತಾನಾ ಮಾರ್‍ತಾ, ಅನಿ ಖಾತಾ, ಫಿತಾ, ಅನಿ ಫಿದೊಡೊ ಹೊವ್ನ್ ಪಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ತನ್ನಾ ತ್ಯಾ ಆಳಾಕ್ ಗೊತ್ತ್ ನಸಲ್ಲ್ಯಾ ಎಳಾರ್, ಧನಿ ಯೆತಾ, ಅನಿ ತೆಚೆ ತುಕ್ಡೆ ತುಕ್ಡೆ ಕರ್‍ತಾ ಅನಿ ಎಕ್ ದಿಸ್ ವಿಶ್ವಾಸ್ ಘಾತ್ಕ್ಯಾಂಚ್ಯಾ ಜಾಗ್ಯಾರ್, ತೆಕಾ ಥವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ಅಪ್ನಾಚ್ಯಾ ಧನಿಯಾಸಾಟ್ನಿ ಕಾಯ್ ಕರುಚೆ ಮನುನ್, ಆಳಾಕ್ ಗೊತ್ತ್ ರ್‍ಹಾತಾ, ಖರೆ ತೊ ಅಪ್ನಿಚ್ ತಯಾರ್ ನಸ್ತಾನಾ ತೆ ಕರಿನಾ, ತರ್ ತೆಕಾ ಲೈ ವಾಯ್ಟ್ ಮಾರ್ ಪಡ್ತಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ಅನಿ ಧನಿಯಾಸಾಟ್ನಿ ಕಾಯ್ ಕರ್‍ತಲೆ ಮನುನ್ ಗೊತ್ತ್ ನಸಲ್ಲೊ ಆಳ್ ರ್‍ಹಾತಾ, ಅನಿ ತೆನಿ ಕಾಯ್ಬಿ ಧನಿಯಾಕ್ ನಕ್ಕೊ ಹೊಲ್ಲಿ ಚುಕ್ ಕರ್ಲ್ಯಾರ್, ತೆಕಾ ಕಮಿ ಶಿಕ್ಷಾ ಗಾವ್ತಾ. ಕೊನಾಕ್ ಲೈ ದಿಲ್ಲೆ ಹಾಯ್, ತೆಚೆಕ್ನಾ ಜಾಸ್ತಿಚೆ ಫಾಟಿ ಯವ್ಕ್ ಪಾಜೆ; ಅನಿ ಕೊನಾಕ್ ಎಗ್ದಮ್ ಜಾಸ್ತಿಚೆ ದಿಲ್ಲೆ ಹಾಯ್, ತೆಚೆಕ್ನಾ ಎಗ್ದಮ್ ಜಾಸ್ತಿಚೆ ಫಾಟಿ ಪರ್ತುನ್ ಯೆವ್ಕ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ಮಿಯಾ ಜಗಾಕ್ ಆಗ್ ಲಾವುಕ್ ಯೆಲಾ, ಅನಿ ಮಾಜ್ಯಾ ಮನಾಕ್ ಯೆಯ್ ಸರ್ಕಿ ಆಗ್ ಪೆಟ್ತಲೆ ಮಾಕಾ ಪಾಜೆ!” ");
INSERT INTO kans_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","“ಮಿಯಾ ಎಕ್ ಬಾಲ್ತಿಮ್ ಘೆತಲೆ ಹಾಯ್, ಅನಿ ಹೆ ಹೊಯ್ ಸಗೊಳ್ ಮಾಕಾ ಲೈ ತರಾಸ್ ಹೊತಲೊ ಹಾಯ್! ");
INSERT INTO kans_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ಹ್ಯಾ ಜಗಾತ್ ಸಮಾದಾನ್ ಹಾನುಕ್ ಮಿಯಾ ಯೆಲಾ ಮನುನ್ ತುಮಿ ಯವಜ್ಲ್ಯಾಶಿ? ನಾ, ಸಮಾದಾನ್ ನ್ಹಯ್, ಎಗ್ಳೆ ಕರುಕ್ ಮಿಯಾ ಯೆಲಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ಅತ್ತಾಚ್ಯಾನ್, ಪಾಚ್ ಜಾನಾ ಹೊತ್ತ್ಯಾತ್ಲೆ, ತಿಗೆಜಾನಾ ದೊಗ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ಅನಿ ದೊಗೆ ಜಾನಾ ತಿಗ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ಪರ್ತುನ್ ಪಡ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ಬಾಬಾ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಂಚ್ಯಾ ವಿರೊದ್, ಅನಿ ಲೆಕಾ ತೆಂಚ್ಯಾ ಬಾಬಾಂಚ್ಯಾ ವಿರೊದ್, ಅವ್ಸಿಯಾ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಿಯಾಂಚ್ಯಾ ವಿರೊದ್, ಅನಿ ಲೆಕಿಯಾ ತೆಂಚ್ಯಾ ಅವ್ಸಿಯಾಂಚ್ಯಾ ವಿರೊದ್, ಮಾಮ್ಜಿ ಸುನ್ನೆಚ್ಯಾ ವಿರೊದ್, ಅನಿ ಸುನ್ನ್ ಮಾಮ್ಜಿಚ್ಯಾ ವಿರೊದ್ ಹೊತ್ಯಾತ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ಮಾನಾ ಜೆಜುನ್ ಲೊಕಾಕ್ನಿ “ದಿಸ್ ಬುಡ್ತಲ್ಯಾ ದಿಕ್ಕಾಕ್ ಎಕ್ ಮೊಡ್ ಚಡುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತುಮಿ ಮನ್ತ್ಯಾಶಿ ಅತ್ತಾ ಪಾವ್ಸ್ ಯೆತಾ ಮನುನ್, ಅನಿ ಪಾವ್ಸ್ ಯೆತಾಚ್. ");
INSERT INTO kans_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ದಕ್ಷಿನ್ ದಿಕ್ಕಾಕ್ನಾ ವಾರೊ ಯೆವ್ಕ್ ಚಾಲು ಹೊಲೊ ಮಟ್ಲ್ಯಾರ್, ಅತ್ತಾ ಗರ್‍ಮಿ ಚಾಲು ಹೊತಾ, ಮನುನ್ ತುಮಿ ಮನ್ತ್ಯಾಶಿ, ಅನಿ ತಸೆಚ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ಕುಸ್ಡ್ಯಾನೊ! ತುಮಿ ಜಿಮ್ನಿಕ್, ಅನಿ ಮಳ್ಬಾಕ್ ಬಗುನ್, ಖಲಿ ದಿಸಾ ಕನ್ನಾ ಯೆತ್ಯಾತ್ ಮನುನ್ ಕಳ್ವುನ್ ಘೆತ್ಯಾಶಿ; ತಸೆ ಜಾಲ್ಯಾರ್, ಹ್ಯಾ ಎಳಾಚ್ಯಾ ವಿಶಯಾತ್ ತುಮ್ಕಾ ಕಶ್ಯಾಕ್‍ ಕಳ್ವುನ್ ಘೆವ್ಕ್ ಹೊಯ್ನಾ ಹೊಲಾ?” ಮನುನ್ಬಿ ತೆಂಕಾ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ಬರಿ ಕಾಮಾ ಕರುಸಾಟಿ ತುಮಿ ತುಮ್ಚ್ಯಾ ಎವ್ಡ್ಯಾಕುಚ್ ಕಶ್ಯಾಕ್ ನಿರ್‍ನಯ್ ಕರುನ್ ಘೆಯ್ನ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ಕೊನ್ಬಿ ಎಕ್ಲೊ ತುಮ್ಚೆ ವರ್‍ತಿ ಪಿರ್ಯಾದ್ ಘಾಲುನ್ ತುಮ್ಕಾ ನ್ಯಾಯ್ ನಿರ್‍ನಯ್‍ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಘೆವ್ನ್ ಜಾತಾ ಜಾಲ್ಯಾರ್, ತೆನಿ ತುಮ್ಕಾ ತ್ಯಾ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾಕ್ಡೆ ಘೆವ್ನ್ ಜವ್ಚ್ಯಾ ಅದ್ದಿಚ್ ತೆಚೆಕ್ಡೆ ರಾಜಿ-ಕುಸಿ-ಹೊವಾ, ಜರ್ ತುಮಿ ಅಶೆ ಕರುಕ್ನ್ಯಾಶಿ, ತರ್ ತೊ ತುಮ್ಕಾ ನ್ಯಾಯ್ ದಿತಲ್ಯಾಚ್ಯಾ ತಾಬೆತ್ ದಿತಾ,ಅನಿ ನ್ಯಾಯ್‍ ನಿರ್‍ನಯ್ ಕರ್‍ತಲೊ, ತುಮ್ಕಾ ಪೊಲಿಸಾಂಚ್ಯಾ ಹಾತಿತ್ ದಿತಾ, ಅನಿ ತುಮ್ಕಾ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಲ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ದಂಡಾಚೊ ಪೈಸ್ಯಾನ್ ಪೈಸೊ ದಿವ್ನ್ ಫೆಡಿ ಸಗೊಳ್ ತುಮಿ ಥೈಚ್ ರ್‍ಹಾತ್ಯಾಶಿ. ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ಎಗ್ದಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ, ಜೆಜುಕ್ಡೆ ಪಿಲಾತಾನ್ ಗಾಲಿಲಿಯಾಚ್ಯಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ದೆವಾಕ್ ಬಲಿ ಭೆಟ್ವುತಾನಾ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ಜೆಜುನ್ ತೆಂಕಾ “ತಿ ಗಾಲಿಲಿಯಾಚಿ ಜಿವಾನಿ ಮಾರಲ್ಲಿ ಲೊಕಾ, ಹುರಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾನ್ಕಿ ಲೈ ಪಾಪಿ ಲೊಕಾ ಮನುನ್ ತುಮಿ ಯೌಜುಲ್ಯಾಸಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'ನಾ. ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ತುಮಿ ತುಮ್ಚ್ಯಾ ಪಾಪಾನಿತ್ನಾ ಫಾಟಿ ಪರ್‍ತಿ ನಸ್ಲ್ಯಾರ್, ತುಮಿಬಿ ತಸೆಚ್ ಮರ್‍ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ಎಕ್ ಲಾಂಬ್, ಉಪ್ಪರ್ಲೆ ಭಾಂದಾಪ್ ಕೊಸ್ಳುನ್ ಪಡುನ್ ಸಿಲೊಆಮಾತ್ ಮರಲ್ಲ್ಯಾ ಅಟ್ರಾ ಲೊಕಾಂಚ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ಕಾಯ್ ಮನ್ತ್ಯಾಶಿ? ಜೆರುಜಲೆಮಾತ್ಲ್ಯಾ ಹುರಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾನ್ಕಿ, ತೆನಿ ಲೈ ಪಾಪಿ ಲೊಕಾ ಮನುನ್ ಯೆವಜ್ಲ್ಯಾಶಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'ನಾ, ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ತುಮಿ ತುಮ್ಚೆ ಪಾಪಾಚೆ ಜಿವನ್ ಬದ್ಲಿನಸ್ಲ್ಯಾರ್, ತುಮಿಬಿ ತಸೆಚ್ ಮರ್‍ತ್ಯಾಶಿ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, ಹಿ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್. “ಎಕ್ ಮಾನ್ಸಾಚ್ಯಾ ದ್ರಾಕ್ಷಿಚ್ಯಾ ಮಳ್ಯಾತ್ ಎಕ್ ಅಂಜುರಾಚೆ ಝಾಡ್ ಹೊತ್ತೆ. ತೊ ತ್ಯಾ ಝಾಡಾಕ್ ಅಂಜುರಾಚಿ ಫಳಾ ಹುಡ್ಕುಕ್ ಗೆಲೊ, ತನ್ನಾ ತೆಂಕಾ ಎಕ್‍ಬಿ ಫಳ್ ಗಾವುಕ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ತಸೆ ಮನುನ್ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಮಳ್ಯಾತ್ ಕಾಮ್ ಕರ್‍ತಲ್ಯಾಕ್ “ಬಗ್, ತಿನ್ ವರ್ಸಾಕ್ನಾ ಮಿಯಾ ಹ್ಯಾ ಝಾಡಾಚಿ ಫಳಾ ಹುಡ್ಕುಕ್ ಯೆವ್ಲಾ, ಖರೆ ಮಾಕಾ ಎಕ್ ಸೈತ್ ಅಂಜುರಾಚೆ ಫಳ್ ಗಾವಿನಾ ಹೊಲಾ. ಜಿಮ್ನಿಕ್ ವಜ್ಜೆ ಹೊವ್ನ್ ಕಶ್ಯಾಕ್ ರ್‍ಹಾತಲೆ ತೆ,ತೊಡುನ್ ಟಾಕ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ಖರೆ, ತ್ಯಾ ಕಾಮ್ ಕರ್‍ತಲ್ಯಾನ್, “ಸಾವ್ಕಾರ್, ತೊಡ್ತಲೆ ನಕ್ಕೊ ರಾಂವ್ದಿತ್; ಮಿಯಾ ತೆಚ್ಯಾ ಮುಳಾತ್ ಕೊಚುನ್, ತೆಕಾ ಗೊಬರ್ ಘಾಲ್ತಾ, ");
INSERT INTO kans_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ಅನಿ ಫಿಡ್ಲ್ಯಾ ವರ್ಸಾಕ್ ತೆ ಬರಿ ಫಳಾ ದಿತಾ ಕಾಯ್ ಬಗುವಾ; ಅನಿಬಿ ತೆನಿ ಫಳಾ ದಿನಸ್ಲ್ಯಾರ್, ತೊಡುವಾ ಮನಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ಎಕ್ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಜೆಜು ಸಿನಾಗೊಗಾತ್ ಶಿಕ್ವುಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ಎಕ್ ಗಿರೊಲಾಗಲ್ಲಿ ಬಾಯ್ಕೊಮನುಸ್ ಹೊತ್ತಿ, ತೆನಿ ತಿಕಾ ಅಟ್ರಾ ವರ್ಸಾ ಅರಾಮನತ್ತ್ಯಾ ಸಾರ್ಕೆ ಕರಲ್ಲ್ಯಾನ್, ತಿ ಬಾಗುನ್ ಗೆಲ್ಲಿ, ತಿಕಾ ವಟ್ಟೊಚ್ ಇಬೆ ರಾವ್ಕ್ ಹೊಯ್ನಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ಜೆಜುನ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಬಲ್ವುನ್ ಅನಿ “ಬಾಯ್ಕೊಮನ್ಸಿ, ತಿಯಾ ತುಜ್ಯಾ ಶಿಕಾತ್ನಾ ಸ್ವತಂತ್ರ್ ಹೊಲೆ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ಜೆಜುನ್ ಅಪ್ನಾಚಿ ಹಾತಾ ತಿಚ್ಯಾ ವರ್‍ತಿ ಥವ್ಲ್ಯಾನ್, ಅನಿ ತಾಬೊಡ್ತೊಬ್ ತಿ ನಿಟ್ ಹೊವ್ನ್ ಇಬೆ ರ್‍ಹಾಲಿ, ಅನಿ ದೆವಾಕ್ ತೆನಿ ಹೊಗಳ್ಳಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ಹ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಜೆಜುನ್ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಗುನ್ ಕರಲ್ಲೆ ಬಗುನ್ ಸಿನಾಗೊಗಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಕ್ ರಾಗ್ ಯೆಲೊ, ಅನಿ ತೊ ಲೊಕಾಕ್ನಿ “ಅಮ್ಕಾ ಕಾಮ್ ಕರುಕ್, ಸಾ ದಿಸಾ ಹಾತ್, ತ್ಯಾ ದಿಸಾತ್ನಿ ಯೆವಾ, ಅನಿ ತುಮ್ಕಾ ತುಮಿ ಗುನ್ ಕರುನ್ ಘೆವ್ನ್ ಜಾಂವಾ, ಸಾಬ್ಬಾತಾಚ್ಯಾ ದಿಸಿ ಯೌನಕಾಸಿ!” ಮನುನ್ ಸಾಂಗುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ಧನಿಯಾನ್ ತೆಕಾ “ತುಮಿ ಕುಸ್ಡ್ಯಾನೊ! ತುಮ್ಚ್ಯಾತ್ಲೊ ಕೊನ್ಬಿ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ,ತುಮ್ಚ್ಯಾ ಗಾಡ್ವಾಕ್ ನಾಹೊಲ್ಯಾರ್, ಬೈಲಾಕ್ ಗೊಟ್ಯಾತ್ನಾ ಸೊಡ್ವುನ್ ಪಾನಿಯಾಕ್ ನ್ಹೆಯ್‌ನ್ಯಾಶಿ ಕಾಯ್; ");
INSERT INTO kans_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ಅತ್ತಾ ಹಿತ್ತೆ, ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ಘರಾನ್ಯಾತ್ಲ್ಯಾ ಎಕ್ಲಿಕ್ ಸೈತಾನಾನ್ ಅಟ್ರಾ ವರ್ಸಾಕ್ನಾ ಭಾಂದುನ್ ಥವ್ಲ್ಯಾನಾಯ್, ತಿ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಸುಟ್ಕಾ ಹೊವ್‍ ನ್ಹಯ್ ಕಾಯ್?” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ಹ್ಯಾ ಜೆಜುಚ್ಯಾ ಜಬಾಬಾನ್ ತೆಚ್ಯಾ ದುಸ್ಮಾನಾಕ್ನಿ ಲಜ್ಜಾ ಕರ್‍ಲಿ, ಲೊಕಾ ಜೆಜುನ್ ಕರಲ್ಲಿ ಮೊಟಿ-ಮೊಟಿ ವಿಚತ್ರ್ ಕಾಮಾ ಬಗುನ್ ಕುಶಿ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ಜೆಜುನ್ ದೆವಾಚೆ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್ ಕಶೆ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. “ದೆವಾಚ್ಯಾ ರಾಜಾಕ್ ಮಿಯಾ ಕಸ್ಲ್ಯಾಕ್ ಸಮಾ ಕರುಕ್ ಹೊತಾ? ");
INSERT INTO kans_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ತೆ ಕಶೆ ಮಟ್ಲ್ಯಾರ್, ಎಕ್ ಮಾನುಸ್ ಎಕ್ ಸಾಸಾವಾಚಿ ಭ್ಹಿಂಯ್ ಘೆತಾ, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಶೆತಾತ್ ಉಗಾತ್ ಘಾಲ್ತಾ, ತೆ ಝಾಡ್ ಮೊಟೆ ಹೊತಾ, ಅನಿ ಮೊಟೆ ಝಾಡ್ ಹೊತಾ, ಅನಿ ಫಾಂಕ್ರಾ ಯೆವ್ನ್ ತೆಚ್ಯಾ ಟಾಳಿಯಾಕ್ನಿ ಘಂಟೆ ಭಾಂದ್ತ್ಯಾತ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ಅನಿಬಿ ಜೆಜುನ್, ದೆವಾಚೆ ರಾಜ್ ಮಟ್ಲ್ಯಾರ್, ಮಿಯಾ ಕಸ್ಲ್ಯಾಕ್ ಸಮಾ ಕರು? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ತೆ, ಕಶೆ ಮಟ್ಲ್ಯಾರ್, ಎಕ್ ಬಾಯ್ಕೊಮನುಸ್ ಸೊಡೊ ಘೆತಾ, ಅನಿ ಲೈಶ್ಯಾ ಪಿಟ್ಟಾತ್ ಘಾಲುನ್ ಥವ್ತಾ, ಅನಿ ತೆ ಪಿಟ್ಟ್ ಸಗ್ಳೆ ಫುಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ಜೆಜು ಶಾರಾತ್ನಿ, ಅನಿ ಗಾಂವಾತ್ನಿ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುನ್ಗೆತ್, ಅನಿ ಜೆರುಜಲೆಮಾಕ್ಡೆ ಅಪ್ನಾಚಿ ವಾಟ್ ಕರುನ್ಗೆತ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ಕೊನ್‍ ಕಿ ಎಕ್ಲ್ಯಾನ್ “ಗುರುಜಿ ಬಚಾವ್ ಹೊತಲಿ ಉಲ್ಲಿಸಿಚ್ ಲೊಕಾ ಕಾಯ್?” ಮನುನ್ ಜೆಜುಕ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ಜೆಜುನ್ ತೆಂಕಾ. ");
INSERT INTO kans_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ಬಾರಿಕ್ಲ್ಯಾ ದಾರಾತ್ನಾ ಭುತ್ತುರ್ ಗುಸುಕ್ ಖಟ್ಪಟ್ ಕರಾ; ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಲೈ ಲೊಕಾ ತ್ಯಾತುರ್ ಗುಸುಕ್ ಕಸ್‍ರತ್ ಕರ್‍ತ್ಯಾತ್, ಖರೆ ತೆಂಕಾ ಗುಸುಕ್ ಹೊಯ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ಘರಾಚೊ ಧನಿ ಉಟ್ತಾ, ಅನಿ ದಾರ್ ಧಾಪ್ತಾ; ತನ್ನಾ ತಿಯಾ ಭಾಯ್ರ್ ಇಬೆ ರ್‍ಹಾವ್ನ್ ದಾರ್ ಬಡ್ವುನ್ “ಧನಿಯಾ ಮಾಕಾ ದಾರ್ ಕಾಡ್” ಮನುನ್ ಇಚಾರ್ಲ್ಯಾರ್. ತನ್ನಾ ತೊ “ತುಮಿ ಖೈತ್ನಾ ಯೆಲ್ಯಾಶಿ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ನಾ!” ಮನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ತನ್ನಾ ತುಮಿ “ಅಮಿ ತುಜ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಜೆವ್ಲಾವ್, ಅನಿ ಫಿಲಾಂವ್; ತಿಯಾ ಅಮ್ಚ್ಯಾ ಶಾರಾತ್ ಅಮ್ಕಾ ಶಿಕ್ವುಲೆ!” ಮನುನ್ ಜಬಾಬ್ ದಿತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ಖರೆ ಅನಿಬಿ ತೊ “ತುಮಿ ಕೊನ್ ಅನಿ ತುಮಿ ಖೈತ್ನಾ ಯೆಲ್ಯಾಶಿ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ನಾ! ಮಾಜೆಕ್ನಾ ಧುರ್ ಜಾವಾ ಬುರ್ಶ್ಯಾ ಲೊಕಾನು!” ಮನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ಅಶೆ ಅಬ್ರಾಹಾಮ್, ಇಸಾಕ್, ಅನಿ ಜಾಕೊಬ್, ಅನಿ ಸಗ್ಳೆ ಪ್ರವಾದಿ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ರಾವ್ನ್ ತುಮ್ಕಾ ಭಾಯ್ರ್ ಘಾಟಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮಿ ರಡ್ತ್ಯಾಶಿ, ಅನಿ ದಾತಾ ಚಾವ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ದಿಸ್ ಉಗಾವ್ತಲ್ಯಾ ಅನಿ, ದಿಸ್ ಬುಡ್ತಲ್ಯಾ ದಿಕ್ಕಾಕ್ನಾ, ಅನಿ ಉತ್ತರ್ ಅನಿ ದಕ್ಷಿನ್ ದಿಕ್ಕಾಕ್ನಾ ಲೊಕಾ ಯೆತ್ಯಾತ್, ಅನಿ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಸನಾಚ್ಯಾ ಜೆವ್ನಾಕ್ ಬಸ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ತನ್ನಾ ಜೆ ಕೊನ್ ಅತ್ತಾ ಫಿಡೆ ಹಾತ್, ತೆನಿ ಫಾಟಿ ಹೊತ್ಯಾತ್, ಅನಿ ಜೆ ಕೊನ್ ಅತ್ತಾ ಫಾಟಿ ಹಾತ್, ತೆನಿ ಫಿಡೆ ಹೊತ್ಯಾತ್, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ತ್ಯಾಚ್ ಎಳಾರ್ ಉಲ್ಲೆ ಫಾರಿಜೆವ್ ಜೆಜುಕ್ಡೆ ಯೆಲೆ, ಅನಿ ತೆಕಾ “ತಿಯಾ ಹಿತ್ನಾ ಖೈ ತರ್ ಜಾ, ಹೆರೊದ್ ತುಕಾ ಜಿವಾನಿ ಮಾರುಕ್ ಬಗುಲಾ”, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ಜೆಜುನ್ ತೆಂಕಾ, “ಜಾವಾ, ಅನಿ ತ್ಯಾ ಕೊಲ್ಯಾಕ್, ಆಜ್ ಅನಿ ಉದ್ದ್ಯಾ ಮಾಕಾ ಗಿರೆ ಕಾಡ್ತಲೆ, ಅನಿ ಲೊಕಾಕ್ನಿ ಗುನ್ ಕರ್‍ತಲೆ ಕಾಮ್ ಹಾಯ್, ತಿನ್ವ್ಯಾ ದಿಸಿ ಮಿಯಾ ತೆ ಸಾರುನ್‍ ಘೆತಾ.ಮನುನ್ ಸಾಂಗಾ. ");
INSERT INTO kans_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ತವ್ಡೆ ಪತರ್, ಮಾಜ್ಯಾ ವಾಟೆನ್ ಜಾವ್ನಗೆತ್ ರ್‍ಹಾತಾ.ಆಜ್ ಉದ್ದ್ಯಾ, ಅನಿ ಪರ್ವಾ, ಎಕ್ ಪ್ರವಾದ್ಯಾಕ್ ಜೆರುಜಲೆಮಾಚ್ಯಾ ಭಾಯ್ರ್ ಜಿವಾನಿ ಮಾರುಕ್ ಹೊಯ್ನಾ”. ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ಜೆರುಜಲೆಮಾ, ಜೆರುಜಲೆಮಾ! ತಿಯಾ ಪ್ರವಾದ್ಯಾಕ್ನಿ ಜಿವಾನಿ ಮಾರ್‍ತೆ,ದೆವಾನ್ ಧಾಡಲ್ಲ್ಯಾ, ಬರಿ ಖಬರ್ ಸಾಂಗ್ತಲ್ಯಾಕ್ನಿ, ತಿಯಾ ಗುಂಡ್ಯಾನ್ ಮಾರ್‍ತೆ! ಎಕ್ ಕೊಂಬ್ಡಿನ್ ಅಪ್ನಾಚ್ಯಾ ಪಿಲ್ಲಾಕ್ನಿ ಅಪ್ನಾಚ್ಯಾ ಫಾಕಾಟ್ಯಾತ್ನಿ ನಿಪ್ವುನ್ ಥವ್ನ್ ಘೆಟ್ಲ್ಯಾ ಸರ್ಕೆ,ಅನಿ ಕವ್ಡೆ ಪತರ್ ತುಜ್ಯಾ ಭೊತ್ಯಾನಿ ಮಿಯಾ ಹಾತ್ ಘಾಲುನ್ ಘೆವ್ನ್ ರಾವ್ಚೆ, ತಸೆ ರ್‍ಹಾಲ್ಯಾರ್‍ಬಿ ತಿಯಾ ಮಾಕಾ ಸೊಡಿನೆಯ್! ");
INSERT INTO kans_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ಅನಿ ತಿಯಾ ತುಜಿ ದೆವಾಚಿ ಗುಡಿ ಕಳ್ದುನ್ ಘೆತೆ. ಮಿಯಾ ತುಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, “ಸರ್ವೆಸ್ವರಾಚ್ಯಾ ನಾವಾನ್ ಯೆತಾ ತೆಕಾ ಜೈ ಹೊಂವ್ದಿ ಮನುನ್ ತಿಯಾ ಮಾಕಾ ಮನಿ ಪತರ್, ಮಿಯಾ ತುಕಾ ಬಗುಕ್ ಗಾವಿನಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ಎಕ್ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ, ಜೆಜು ಎಕ್ ಫಾರಿಜೆವಾಂಚ್ಯಾ ವಡಿಲಾಚ್ಯಾ ಘರಾತ್ ಜೆವ್ನಾಕ್ ಗೆಲ್ಲೊ, ಅನಿ ಲೊಕಾ ಜೆಜುಕ್ ಎಗ್ದಮ್ ಜಗ್ಗೊಳ್ನಾ ಬಗುಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ಹಾತ್-ಪಾಯ್ ಸುಜಲ್ಲೊ ಎಕ್ ಮಾನುಸ್ ಜೆಜುಕ್ಡೆ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ಅನಿ ಜೆಜುನ್ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾಕ್ನಿ, ಅನಿ ಫಾರಿಜೆವಾಕ್ನಿ “ಅಮ್ಚೊ ಖಾಯ್ದೊ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಗುನ್ ಕರುಕ್ ಪರ್ವಾನ್ಗಿ ದಿತಾ ಕಾಯ್, ನಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ಖರೆ ತೆನಿ, ಕಾಯ್ಬಿ ಸಾಂಗುಕ್ನ್ಯಾತ್, ಜೆಜುನ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ತೆಕಾ ಆರಾಮ್ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ಮಾನಾ ತೆನಿ ತೆಂಕಾ “ತುಮ್ಚ್ಯಾತ್ಲೊ ಕೊನಾಚೊಬಿ ಪೊರ್ ನಾ ತರ್ ತುಮ್ಚೊ ಬೈಲ್ ಭಾಯ್ತ್ ಪಡ್ಲ್ಯಾರ್, ಸಬ್ಬತಾಚೊ ದಿಸ್ ರ್‍ಹಾಲ್ಯಾರ್‍ಬಿ, ತೆಕಾ ವೊಡುನ್ ಕಾಡುಚ್ಯಾ ಅದ್ದಿ ರ್‍ಹಾತ್ಯಾಶಿ ಕಾಯ್,” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ತನ್ನಾ ಕೊನಾಕ್‍ಬಿ ತೆಕಾ ಜಬಾಬ್ ದಿವ್ಕ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ಉಲ್ಲೆಸೆ ಸೊಯ್ರೆ ಬರೆ ಬರೆ ಜಾಗೆ ಹುಡಕ್ತಲೆ ಜೆಜುನ್ ಬಗಟ್ಲ್ಯಾನ್. ತೆ ಬಗುನ್ ಜೆಜುನ್ ತೆಂಕಾ, ಹಿ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ಕೊನ್ಬಿ ತುಮ್ಕಾ ಲಗ್ನಾಚ್ಯಾ ಜೆವ್ನಾಕ್ ಬಲ್ವುಲ್ಯಾರ್, ಬರ್‍ಯಾ-ಬರ್‍ಯಾ ಜಾಗ್ಯಾ ವೈನಿ ಜಾವ್ನ್ ಬಸುಚೆ ನ್ಹಯ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತುಮ್ಚ್ಯಾನ್‍ಬಿ ಜಾಸ್ತಿ ಮರ್‍ಯಾದಿಚ್ಯಾ ಮಾನ್ಸಾಕ್, ತೆನಿ ಬಲ್ವಲ್ಲೆ ರಾವ್ಕ್ ಫಿರೆ. ");
INSERT INTO kans_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ತನ್ನಾ ತುಮ್ಕಾ ಬಲ್ವಲ್ಲೊ ಯೆವ್ನ್, ಹ್ಯೊ ಜಾಗೊ ತೆಕಾ ದಿ, ಅನಿ ಉಟ್ ಹಿತ್ನಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾರ್, ತುಕಾ ಲಜ್ತಲೆ ಪಡ್ತಾ, ಅನಿ ಎಗ್ದಮ್ ಫಾಟ್ಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಜಾವ್ನ್ ಬಸ್ತಲೆ ಪಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ತಸೆ ಮನುನ್, ತುಮ್ಕಾ ಖೈಬಿ ಬಲ್ವಲ್ಲ್ಯಾ ತನ್ನಾ, ಫಾಟ್ಲ್ಯಾ ಜಾಗ್ಯಾ ವರ್‍ತಿ ಜಾವ್ನ್ ಬಸಾ, ತನ್ನಾ ತುಮ್ಕಾ ಬಲ್ವಲ್ಲೊ ಮಾನುಸ್ ತುಮ್ಚೆಕ್ಡೆ ಯೆವ್ನ್ “ದೊಸ್ತಾ, ವೈರ್ ಬರ್‍ಯಾ ಜಾಗ್ಯಾರ್ ಯೆವ್ನ್ ಬಸ್”, ಮನುನ್ ತುಮ್ಕಾ ಸಾಂಗ್ತಾನಾ, ಥೈ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ತುಕಾ ಮಾನ್ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“ಜೆ ಕೊನ್ ಅಪ್ನಾಕುಚ್ ಖಾಲ್ತಿ ಕರ್‍ತಾ, ತೊ ವರ್‍ತಿ ಹೊತಾ, ಅನಿ ಜೊ ಕೊನ್ ಅಪ್ನಾಕುಚ್ ವರ್‍ತಿ ಕರ್‍ತಾ ತೊ ಖಾಲ್ತಿ ಹೊತಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಾಕ್ ಜೆವ್ನಾಕ್ ಬಲ್ವಲ್ಲ್ಯಾಕ್ “ಕನ್ನಾಬಿ ಜೆವ್ನಾಕ್ ಬಲ್ವುತಾನಾ ತಿಯಾ ತುಜ್ಯಾ ದೊಸ್ತಾಕ್ನಿ, ನಾಹೊಲ್ಯಾರ್ ಭಾವಾಕ್ನಿ, ನಾಹೊಲ್ಯಾರ್ ಸೊಯ್ರ್ಯಾಕ್ನಿ, ನಾಹೊಲ್ಯಾರ್, ತುಜ್ಯಾ ಸಾವ್ಕಾರ್ ಸೆಜಾರ್‍ಯಾಕ್ನಿ ಬಲ್ವುನಕೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆನಿಬಿ ತುಕಾ ಜೆವ್ನಾಕ್ ಬಲ್ವುತ್ಯಾತ್. ಅನಿ ತಿಯಾ ತೆಂಕಾ ಕಾಯ್ ಕರ್‍ಲೆ, ತೆ ಸಗ್ಳೆ ತೆನಿ ತುಕಾಬಿ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ತಿಯಾ ಮೊಟೆ ಸನಾಚೆ ಜೆವಾನ್‍ ಥವ್ತಾನಾ, ಅದು ಅಸಲ್ಲ್ಯಾಕ್ನಿ, ಗರಿಬಾಕ್ನಿ, ಸೊಟ್ಟ್ಯಾಕ್ನಿ, ಅನಿ ಕುಡ್ಡ್ಯಾಕ್ನಿ, ಬಾಗುನ್‍ ಗೆಲ್ಲ್ಯಾಕ್ನಿ, ಬಲ್ವು. ");
INSERT INTO kans_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ತೆಂಚೆನ್ ತುಕಾ ಫಾಟಿ ಪರ್ತುನ್ ದಿವ್ಕ್ ಹೊಯ್ನಾ, ತನ್ನಾ ತುಕಾ ಆಶಿರ್ವಾದ್ ಗಾವ್ತಾ, ಅನಿ , ಸಗ್ಳಿ ಬರಿ ಲೊಕಾ ಮರುನ್ ಝಿತ್ತೆ ಹೊತಲ್ಯಾ ದಿಸಿ,ದೆವ್ ತುಕಾ ತೆಚೊ ಪ್ರತಿಫಳ್ ದಿತಾ”, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ಥೈ ಜೆವ್ನಾಕ್ ಬಸಲ್ಲ್ಯಾನಿತ್ಲೊ ಎಕ್ಲೊ, ಹೆ ಸಗ್ಳೆ ಆಯ್ಕುನ್ “ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಸನಾಚ್ಯಾ ಜೆವ್ನಾಕ್ ಬಸಲ್ಲ್ಯಾಚೆ ನಸಿಬ್ ಕವ್ಡೆ ಬರೆ!” ಮನುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ಜೆಜುನ್ ತೆಕಾ “ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೆನಿ ಎಕ್ ಮೊಟೆ ಜೆವಾನ್ ಥವಲ್ಲ್ಯಾನ್. ಹ್ಯಾ ಜೆವ್ನಾಕ್, ತೆನಿ ಲೈ ಲೊಕಾಕ್ನಿ ಬಲ್ವಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ಮೊಟ್ಯಾ ಜೆವ್ನಾಚೊ ಎಳ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆನಿ ಸೊಯ್ರ್ಯಾಕ್ನಿ ಬಲ್ವುನ್ ಹಾನುಕ್ ಮನುನ್, ಅಪ್ನಾಚ್ಯಾ ಆಳಾಕ್ನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನ್”, ಸಗ್ಳೆ ತಯಾರ್ ಹೊಲ್ಲೆ ಹಾಯ್, ಯೆವಾ! ಮನುನ್ ಸಾಂಗುನ್ ಧಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ಖರೆ, ತೆ, ಸೊಯ್ರೆ, ಎಕ್ಲ್ಯಾಚ್ಯಾ ಫಾಟ್ನಾ ಎಕ್ಲೊ, ಎಕ್ಯೆಕ್ ನೆವಾನ್ ದಿವ್ಕ್‌ ಲಾಗ್ಲೆ, ಪಯ್ಲೆಚ್ಯಾನ್ ತ್ಯಾ ಆಳಾಕ್ “ಮಿಯಾ ಎಕ್ ನ್ಹವೆ ಶೆತ್ ಖರಿದಿ ಕರ್‍ಲಾ, ಮಿಯಾ ಜಾವ್ನ್ ಉಲ್ಲೆ ತೆ ಬಗುಕ್ ಪಾಜೆ ದಯಾ ಕರುನ್ ಮಾಕಾ ಮಾಪ್ ಕರ್”, ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ಅನಿ ಎಕ್ಲೊ “ಮಿಯಾ ಪಾಂಚ್ ಜೊಡಿ ಬೈಲಾ ಘೆಟ್ಲಾ, ತಿ ಬೈಲಾ ಕಶಿ ಚಲ್ತ್ಯಾತ್ ಮನುನ್ ಬಗುಕ್ ಮನುನ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ, ದಯಾ ಕರುನ್ ಬೆಜಾರ್ ಕರುನ್ ಘೆವ್‍ನಕ್ಕೊ”, ಮನುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ಅನಿ ಎಕ್ಲೊ “ಮಿಯಾ ಅತ್ತಾಚ್ ನಗಿನ್ ಕರುನ್‍ ಘೆಟ್ಲಾ, ಮಾಕಾ ಯೆವ್ಕ್ ಹೊಯ್ನಾ” ಮನುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“ಪರ್ತುನ್ ಜಾವ್ನ್ ಆಳಾನ್ ಹೆ ಸಗ್ಳೆ ಅಪ್ನಾಚ್ಯಾ ಧನಿಯಾಕ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಧನಿಯಾಕ್ ರಾಗ್ ಯೆಲೊ, ಅನಿ ಧನಿಯಾನ್ ಆಳಾಕ್” ತಾಬೊಡ್ತೊಬ್ ಶಾರಾನಿತ್ನಿ, ವನಿಯಾತ್ನಿ, ಸಂದ್ಡಿಯಾತ್ನಿ ಜಾ, ಅನಿ ಗರಿಬಾಕ್ನಿ, ಸೊಟ್ಟ್ಯಾಕ್ನಿ, ಕುಡ್ಡ್ಯಾಕ್ನಿ, ಅದು ಹೊತ್ತ್ಯಾಕ್ನಿ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಯೆ, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ತನ್ನಾ ಆಳಾನ್ ತಾಬೊಡ್ತೊಬ್, “ಧನಿಯಾ, ತುಮಿ ಹುಕುಮ್ ದಿಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ಮಿಯಾ ಕರ್‍ಲೊ, ಖರೆ ತುಮ್ಚ್ಯಾ ಘರಾತ್ ಅನಿ ಲೈ ಜಾಗೊ ಹುರಲ್ಲೊ ಹಾಯ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ತಸೆ ಮನ್ತಾನಾ, ಧನಿಯಾನ್ ಆಳಾಕ್, “ದೆಸಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ರಸ್ತ್ಯಾ ವೈನಿ. ಅನಿ ವನಿಯಾತ್ನಿ ಜಾ, ಅನಿ ಶೆತಾಂಚ್ಯಾ ವಾಟಾ ವೈನಿ ಜಾವ್ನ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಲ್ವುನ್ ಹಾನ್, ಅನಿ ಮಾಜೆ ಸಗ್ಳೆ ಘರ್ ಭರುಂದಿ, ");
INSERT INTO kans_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ಮಿಯಾ ತುಕಾ ಸಾಂಗ್ತಾ, ಮಿಯಾ ಅದ್ದಿ ಬಲ್ವಲ್ಲ್ಯಾನಿತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾನ್‍ಬಿ ಮಾಜ್ಯಾ ಜೆವ್ನಾಚಿ ರುಚಿ ಬಗುಕ್ ಗಾವುಚೆ ನ್ಹಯ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ಎಗ್ದಾ, ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ, ಎಕ್ ಮೊಟೊ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಜಾವ್‍ಲಾಗಲ್ಲೊ, ತನ್ನಾ ತೊ ಫಾಟಿ ಪರತ್ಲೊ, ಅನಿ ತೆಂಕಾ. ");
INSERT INTO kans_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆತಲೊ ಹರ್ ಎಕ್ಲೊ, ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾಚ್ಯಾನ್ಕಿ, ಬಾಯ್ಚ್ಯಾನ್ಕಿ, ಬಾಯ್ಕೊ ಅನಿ ಪೊರಾಚ್ಯಾನ್ಕಿ, ಭಾವಾ ಭೆನಿಯಾಂಚ್ಯಾನ್ಕಿ, ಅನಿ ಅಪ್ನಾಚ್ಯಾನ್ಕಿ ಜಾಸ್ತಿ ಜೆ ಕೊನ್ ಮಾಜೊ ಪ್ರೆಮ್ ಕರಿನಾ ತೊ ಮಾಜೊ ಶಿಸ್ ಹೊವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ಜೆ ಕೊನ್ ಅಪ್ನಾಚೊ ಕುರಿಸ್ ವಾವುನ್ ಘೆವ್ನ್ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆಯ್ನಾ, ತೊ ಮಾಜೊ ಶಿಸ್ ಹೊವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“ತುಮಿ ಕೊನ್ಬಿ ಎಕ್ ಘರ್ ಭಾಂದ್ತಾನಾ, ತೆ ಘರ್ ಭಾಂದುನ್ ಸಾರಿ ಸರ್ಕೆ ಪೈಸೆ ಅಪ್ನಾಕ್ಡೆ ಹಾತ್ ಕಾಯ್ ನಾ,ಮನುನ್ ಅದ್ದಿಚ್ ಯವ್ಜನ್ ಘಾಲಿನ್ಯಾಶಿ ಕಾಯ್”, ");
INSERT INTO kans_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","“ಅಶೆ ತುಮಿ ಕರಿನಸ್ಲ್ಯಾರ್, ಘರ್ ಭಾಂದುಕ್ ಚಾಲು ಕರುನ್, ಭಾಂದುನ್ ಸಾರುಕ್ ಹೊಯ್ನಸ್ಲ್ಯಾರ್, ಸಗ್ಳಿ ಲೊಕಾ ತುಮ್ಕಾ ಬಗುನ್ ಹಾಸ್ತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ಅನಿ “ಹ್ಯಾ ಮಾನ್ಸಾನ್ ಘರ್ ಭಾಂದುಕ್ ಚಾಲು ಕರ್‍ಲ್ಯಾನ್, ಖರೆ, ಸಾರುಕ್ ತೆಕಾ ಹೊಯ್ನಾ ಹೊಲಾ” ಮನ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“ಎಕ್ಲೊ ಧಾ ಹಜಾರ್ ಸೈನಿಕಾ ಹೊತ್ತೊ ರಾಜಾ, ಎಕ್ಲ್ಯಾ ಇಸ್ ಹಜಾರ್ ಸೈನಿಕಾ ಹೊತ್ತ್ಯಾ ರಾಜಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಝಗ್ಡೊ ಕರುಕ್ ಮನುನ್ ಜಾತಾನಾ, ತೊ ಅದ್ದಿಚ್ ಬಸುನ್, ಅಪ್ನಾಚ್ಯಾನ್ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಝಗ್ಡುನ್ ಜಿಕುಕ್ ಹೊತಾ ಕಾಯ್ ನಾ”, ಮನುನ್ ಯವ್ಜುನ್ ಬಗ್ತಾ ");
INSERT INTO kans_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","“ಅಶೆ ತೆನಿ ಯವ್ಜುನ್ ಅಪ್ನಾಕ್ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಝಗ್ಡುನ್, ಜಿಕುಕ್ ಹೊಯ್ನಾ ಮನುನ್ ಯವ್ಜುನ್, ತೊ ರಾಜಾ ಅಪ್ನಾಚ್ಯಾ ಖಬರ್ ದಿತಲ್ಯಾಕ್, ತೊ ದುಸ್ಮಾನ್ ರಾಜಾ, ಧುರುಚ್ ರಾತಾನಾ ‍ಶಾಂತಿ ಸಮಾದಾನ್ ಕರುನ್ ಘೆವ್ವಾ, ಝಗಡ್ತಲೆ ನಕ್ಕೊ” ಮನುನ್ ಸಾಂಗುನ್ ಧಾಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ತಸೆಚ್ “ತುಮ್ಚೆಕ್ಡೆ ಹೊತ್ತೆ ಸಗ್ಳೆ ಸೊಡುನ್ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆಲ್ಯಾ ಶಿವಾಯ್, ತುಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಕೊನಾಕ್‍ಬಿ ಮಾಜೊ ಶಿಸ್ ಹೊವ್ಕ್ ಹೊಯ್ನಾ” ಮನುನ್ ಜೆಜುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ಮಿಟ್ ಬರೆ ಹೊಯ್, ಖರೆ ಮಿಟ್ಟಾನ್, ಅಪ್ನಾಚಿ ಖಾರ್ಪಾನ್ ಕಳ್ದುನ್ ಘೆಟ್ಲ್ಯಾನ್ ತರ್,ತೆಕಾ ಅನಿ ಪರ್ತುನ್ ಖಾರ್ಪಾನ್ ದಿವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ಅಶೆ ತೆ ಮಿಟ್, ನಾ ಮಾಟಿ ಹೊವ್ಕ್ ನಾ ಗೊಬರ್ ಹೊವ್ಕ್; ಉಪಯೊಗಾಕ್ ಯೆತಾ ತೆ ಧುರ್ ನ್ಹೆವ್ನ್ ಟಾಕ್ತಲೆ, ತವ್ಡೆಚ್”, ತುಮ್ಕಾ ಆಯ್ಕುಕ್ ಮನ್ ರ್‍ಹಾಲ್ಯಾರ್ ಆಯ್ಕಾ! ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ಎಕ್ ದಿಸ್ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲಿ ಲೊಕಾ, ಅನಿ ಪಾಪಿ ಲೊಕಾ, ಜೆಜುಚೆ ಶಿಕಾಪ್ ಆಯ್ಕುಚೆ ಮನುನ್ ಯೆಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ತನ್ನಾ ಫಾರಿಜೆವಾ ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲಿ ಲೊಕಾ, ಹೆ ಬಗುನ್ “ಹ್ಯೊ ಮಾನುಸ್ ಪಾಪಿ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾತಾ, ಅನಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವಾನ್‍ಬಿ ಕರ್‍ತಾ” ಮನುನ್ ಬೊಲುಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ತೆಚೆಸಾಟ್ನಿ, ಜೆಜುನ್ ತೆಂಕಾ, ಹಿ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ತುಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್ಡೆ ಸೆಂಬರ್ ಬಕ್ರಿ ಹಾತ್ ಮನುವಾ, ಅನಿ ತ್ಯಾತುರ್‍ಲೆ ಎಕ್ ಬಕ್ರೆ ಕಳದ್ಲೆ ತರ್ ತೊ ಕಾಯ್ ಕರ್‍ತಾ? ತ್ಯಾ ನ್ಹವದಾರ್ ನ್ಹವ್ ಬಕ್ರ್ಯಾಕ್ನಿ ಥಯ್ಚ್ ಸೊಡುನ್, ಕಳ್ದುನ್ ಗೆಲ್ಲ್ಯಾ ಎಕುಚ್ಎಕ್ ಬಕ್ರ್ಯಾಕ್, ಗಾವಿ ಪತರ್ ಹುಡ್ಕುಕ್ ಜಾತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ತೆ ಗಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆಕಾ ಲೈ ಕುಶಿ ಹೊತಾ, ತಸೆ ಮನುನ್ ತೊ ತೆಕಾ ಅಪ್ನಾಚ್ಯಾ ಖಾಂಜ್ಯಾರ್ ಥವ್ನ್ ಘೆತಾ, ");
INSERT INTO kans_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ಅನಿ ತೆಕಾ, ಘರಾಕ್ ಹಾನ್ತಾ, ತನ್ನಾ ಅಪ್ನಾಚ್ಯಾ ದೊಸ್ತಾಕ್ನಿ, ಅನಿ ಅಜು-ಬಾಜುಚ್ಯಾಕ್ನಿ ಬಲ್ವುನ್ ಮಾಕಾ ಲೈ ಕುಶಿ ಹೊವ್ಲಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಚುಕುನ್ ಗೆಲ್ಲೆ ಮಾಜೆ ಬಕ್ರೆ, ಮಾಕಾ ಗಾವ್ಲೆ, ಯೆವಾ, ಅಮಿ ಗರ್‍ದಿ ಕರುವಾ! ಮನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ತಸೆಚ್, ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ನ್ಹವದಾರ್ ನ್ಹವ್ ಧರ್ಮಾನಿ ಚಲ್ತಲ್ಯಾ, ಅನಿ ಮನ್ ಬದ್ಲುಕ್ ತಯಾರ್ ನಸಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾನ್ಕಿ, ಮನ್ ಬದ್ಲುನ್ ಬರೊ ಹೊಲ್ಲ್ಯಾ ಎಕ್ ಪಾಪಿ ಮಾನ್ಸಾಸಾಟ್ನಿ ಸರ್‍ಗಾತ್ ಲೈ ಕುಶಿ ಹೊತಾ, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ನಾಹೊಲ್ಯಾರ್, ಧಾ ಚಾಂದಿಚೆ ಪೈಸೆ ಹೊತ್ತಿ ಎಕ್ ಬಾಯ್ಕೊಮಾನುಸ್, ತ್ಯಾತುರ್‍ಲಿ ಎಕ್ ಗಾಲಿ ಕಳ್ದುನ್ ಘೆತಾ ತನ್ನಾ ತಿ ಕಾಯ್ ಕರ್‍ತಾ? ತಿ, ಎಕ್ ಚಿಮ್ನಿ ಪೆಟ್ವುತಾ, ಸಗ್ಳೆ ಘರ್ ಝಾಡ್ತಾ! ಅನಿ ತೊ ಪೈಸೊ ಗಾವಿ ಪತರ್, ಸಗ್ಳ್ಯಾಕ್ಡೆ ಬರೆ ಕರುನ್ ಹುಡಕ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ತಿಕಾ ತೊ ಪೈಸೊ ಗಾವಲ್ಲ್ಯಾ ತನ್ನಾ ತಿ ಅಪ್ನಾಚ್ಯಾ ದೊಸ್ತಿನ್ಯಾಕ್ನಿ, ಅನಿ ಅಜು-ಬಾಜುಚ್ಯಾಕ್ನಿ ಬಲ್ವುನ್ ಗೊಳಾ ಕರ್‍ತಾ, ಅನಿ ತೆಂಕಾ ಯೆವಾ ಅಮಿ ಗರ್‍ದಿ ಕರುವಾ, ಮಾಜೊ ಕಳದಲ್ಲೊ ಚಾಂದಿಚೊ ಪೈಸೊ ಮಾಕಾ ಗಾವ್ಲೊ, ಮಾಕಾ ಲೈ ಕುಶಿ ಹೊವ್ಲಾ” ಮನುನ್ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ತಸೆಚ್, ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಎಕ್ ಪಾಪಿ ಮಾನುಸ್, ಅಪ್ನಾಚೆ ಜಿವನ್ ಬದ್ಲುನ್ ಬರೊ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ದೆವಾಚ್ಯಾ ದುತಾಕ್ನಿ ಲೈ ಕುಶಿ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ಜೆಜು ಅನಿ ಫಿಡೆ ಅಶೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲೊ, ಎಗ್ದಾ ದೊಗೆ ಜಾನಾ ಲೆಕಾ ಹೊತ್ತೊ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ಧಾಕ್ಲ್ಯಾ ಲೆಕಾನ್, “ಬಾಬಾಕ್ ಬಾಬಾ, ಮಾಜ್ಯಾ ವಾಟ್ಯಾಚಿ ಆಸ್ತಿ ಮಾಕಾ ದಿ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ತೆಚೆಸಾಟ್ನಿ, ತೊ ಮಾನುಸ್ ಅಪ್ನಾಚಿ ಆಸ್ತಿ ದೊನ್ ಭಾಗ್ ಕರ್‍ತಾ, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ದೊಗ್ಯಾಬಿ ಲೆಕಾಕ್ನಿ ತೆಂಚೊ-ತೆಂಚೊ ಇಸ್ಸೊ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ಉಲ್ಲಿ ದಿಸಾ ಗೆಲ್ಲ್ಯಾ ಮಾನಾ, ಧಾಕ್ಲ್ಯಾ ಲೆಕಾನ್, ಅಪ್ನಾಚ್ಯಾ ವಾಟ್ಯಾಚಿ ಆಸ್ತಿ ಇಕ್ಲ್ಯಾನ್ ಅನಿ ಪೈಸೆ ಘೆವ್ನ್ ತೊ ಘರ್ ಸೊಡುನ್ ಎಕ್ ಧುರ್‍ಲ್ಯಾ ದೆಸಾಕ್ ಗೆಲೊ ಅನಿ ಫಿಡ್ಲೊ ಇಚಾರ್ ಕರಿನಸ್ತಾನಾ ಸಗ್ಳೆ ಪೈಸೆ ಮಜ್ಯಾ ಮಾರುನ್ ಖರಚ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ಅಪ್ನಾಕ್ಡೆ ಹೊತ್ತೆ ಸಗ್ಳೆಚ್, ತೆನಿ ಖರ್ಚ್ ಕರ್‍ಲ್ಯಾನ್, ತನ್ನಾ ತ್ಯಾ ದೆಸಾತ್ ಎಗ್ದಮ್ ಮೊಟೊ ಬರಗಾಲ್ ಪಡ್ಲೊ, ತೆಚೆಕ್ಡೆ ಕಾಯ್-ಕಾಯ್ ಹುರುಕ್‍ ನತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ತೆಚೆಸಾಟ್ನಿ, ತೊ ತ್ಯಾ ದೆಸಾತ್ಲ್ಯಾ ಎಕ್ ಮಾನ್ಸಾಚ್ಯಾ ಘರಾತ್ ಕಾಮಾಕ್ ಗೆಲೊ, ತ್ಯಾ ಸಾವ್ಕಾರಾನ್ ತೆಕಾ ಅಪ್ನಾಚ್ಯಾ ಶೆತಾತ್, ಡುಕ್ರಾ ರಾಕ್ತಲೆ ಕಾಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ತೆನಿ ಡುಕ್ರಾನಿ ಖಾತಲೆ ಗಡ್ಡೆ ತರ್ ಬಿ ಖಾವ್ನ್, ಮಿಯಾ ಮಾಜೆ ಪೊಟ್ ಭರುನ್ ಘೆತಾ, ಮನುನ್ ಯವಜ್ಲ್ಯಾನ್, ಖರೆ, ಕೊನ್ಬಿ ತೆಕಾ ಕಾಯ್ಬಿ ಖಾವ್ಕ್ ದಿವ್ಕನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ಆಕ್ರಿಕ್, ತೆಕಾ ಅರು ಯೆಲಿ, ಅನಿ “ಮಾಜ್ಯಾ ಬಾಬಾಚೆ ಘರಾತ್, ಸಗ್ಳಿ ಆಳಾ, ಜೆವ್ನ್-ಖಾವ್ನ್ ಹುರಿ ಸರ್ಕೆ, ಮಾಜ್ಯಾ ಬಾಬಾಕ್ಡೆ ಹಾಯ್, ಅನಿ ಮಿಯಾ ಹಿತ್ತೆ, ಭುಕೆನ್ ಮರುಲಾ!” ");
INSERT INTO kans_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“ಮಿಯಾ ಉಟ್ತಾ, ಅನಿ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ಡೆ ಜಾತಾ, ಅನಿ ಬಾಬಾ, ತುಜ್ಯಾ ಅನಿ ದೆವಾಚ್ಯಾ ವಾಟೆಕ್ ವ್ಹಾಕ್ಡೆ ಜಾವ್ನ್, ಮಿಯಾ ಪಾಪ್ ಕರ್‍ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ಮಾಕಾ ತುಜೊ ಲೆಕ್, ಮನುನ್ ಘೆತಲಿ ಮರ್‍ಯಾದ್ ನಾ, ಮಾಕಾ ತುಜ್ಯಾ ಎಕ್ ಆಳಾಚ್ಯಾ ಸರ್ಕೊ ಮನುನ್ ಘೆ ಮನ್ತಾ” ಮನುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ತಸೆ ಮನುನ್ ತೊ ಉಟ್ಲೊ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾಚ್ಯಾ ಘರಾಕ್ಡೆ ಜಾವ್ಕಲಾಲೊ,ತೊ ಘರಾಕ್ನಾ ಧುರ್ ರ್‍ಹಾತಾನಾಚ್, ಬಾಬಾನ್ ತೆಕಾ ಬಗಟ್ಲ್ಯಾನ್; ತೆಕಾ ಬಗುನ್, ತೆಚೊ ಮನ್‍ ಚುಟ್ಮುಟ್ಲೊ, ಅನಿ ತೊ ಪಳುನ್ ಗೆಲೊ, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಹಾತಾನಿ ತೆಕಾ ಯಾಂಗ್ ಮಾರ್‍ಲ್ಯಾನ್,ಅನಿ ತೆಚಿ ಉಪ್ಪಾ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ತನ್ನಾ ಲೆಕಾನ್ “ಬಾಬಾ, ದೆವಾಚ್ಯಾ, ಅನಿ ತುಜ್ಯಾ ವಾಟೆಕ್ ಅಡ್ವೆ ಜಾವ್ನ್, ಮಿಯಾ ಪಾಪ್ ಕರ್‍ಲೊ,ತುಜೊ ಲೆಕ್ ಮನುನ್ ಘೆತಲಿ ಮರ್‍ಯಾದ್ ಮಾಕಾ ನಾ”, ಮಟ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ಖರೆ ಬಾಬಾನ್ ಆಳಾಕ್ನಿ ಬಲ್ವುನ್ “ಲಗ್ಗುನಾ, ಜಾವ್ನ್ ಬರ್‍ಯಾತ್ಲೆ ಬರೆ ಕಪ್ಡೆ ಹಾನಾ ಅನಿ ತೆಕಾ ನೆಸ್ವಾ. ಬೊಟಾಕ್ ಮುದ್ದಿ ಘಾಲಾ ಅನಿ ತೆಚ್ಯಾ ಪಾಯಾತ್ನಿ ಹೊನಾಯಾ ಘಾಲಾ. ");
INSERT INTO kans_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ಮಾನಾ ಜಾವಾ, ಅನಿ ಎಕ್ ಮಸ್ತ್ ತಯಾರ್ ಹೊತ್ತೊ. ಪುಟ್ಪುಟಿತ್ ಪಾಡ್ಕು ಮಾರಾ. ಅಮಿ ಗರ್‍ದಿ ಕರುಂವಾ! ");
INSERT INTO kans_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ಮರಲ್ಲೊ ಮಾಜೊ ಲೆಕ್ ಝಿತ್ತೊ ಹೊವ್ನ್ ಯೆಲಾ; ಕಳ್ದುನ್ ಗೆಲ್ಲೊ ತೊ ಅತ್ತಾ ಗಾವ್ಲಾ” ಮಟ್ಲ್ಯಾನ್. ಅಶೆ ತೆಂಚಿ ಗರ್‍ದಿ ಚಾಲು ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ತ್ಯಾಚ್ ಎಳಾರ್, ಶೆತಾಕ್ಡೆ ಗೆಲ್ಲೊ ಥೊರ್‍ಲೊ ಲೆಕ್ ಘರಾಕ್ಡೆ ಯೆವ್ಲಾಗಲ್ಲೊ, ತೊ ಘರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ವಾಜ್ಪಾಂಚೊ, ಅನಿ ನಾಚ್ ಚಲಲ್ಲೊ ಅವಾಜ್ ತೆಚ್ಯಾ ಕಾನಾರ್ ಪಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ತಸೆಮನುನ್ ತೆನಿ, ಎಕ್ಲ್ಯಾ ಆಳಾಕ್ ಬಲ್ವುಲ್ಯಾನ್, ಅನಿ “ಕಾಯ್ ಹೊವ್ಲಾ ಹಿತ್ತೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ತ್ಯಾ ಆಳಾನ್ ತೆಕಾ “ತುಜೊ ಭಾವ್ ಪರ್ತುನ್ ಘರಾಕ್ ಯೆಲಾ, ಅನಿ ತುಜ್ಯಾ ಬಾಬಾನ್ ತೆಚೆಸಾಟ್ನಿ ಎಕ್ ಬರೊ ಪುಟ್ಪುಟಿತ್ ಪಾಡ್ಕು ಮಾರುಕ್ ಲಾವ್ಲ್ಯಾನಾಯ್, ತುಜೊ ಭಾವ್ ಸುರಕ್ಷಿತ್ ಪರ್ತುನ್ ಯೆಲಾ ಮನುನ್. ಹ್ಯೊ ಅವಾಜ್ ಹೊವ್ಲಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ತನ್ನಾ ಥೊರ್‍ಲ್ಯಾ ಭಾವಾಕ್, ಲೈ ರಾಗ್ ಯೆಲೊ, ರಾಗಾನ್ ತೊ, ಘರಾತ್ ಭುತ್ತುರ್ ಜಾವ್ಕುಚ್‍ನಾ. ತೆಚೆಸಾಟ್ನಿ, ತೆಚೊ ಬಾಬಾಚ್‍ ಘರಾತ್ನಾ ಭಾಯ್ರ್ ಯೆಲೊ, ಅನಿ ತೆಕಾ ಘರಾತ್ ಭುತ್ತುರ್ ಬಲ್ವುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ಖರೆ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾಕ್, “ಬಾಬಾ, ಎವ್ಡಿ ಸಗ್ಳಿ ವರ್ಸಾ, ಎಕ್ ಆಳಾಚ್ಯಾ ಸರ್ಕೆ, ಮಿಯಾ ತುಜ್ಯಾಸಾಟಿ ಕಾಮ್ ಕರ್‍ಲೊ, ಅನಿ ಕನ್ನಾಚ್ ಮಿಯಾ ತುಜಿ ಗೊಸ್ಟ್ ಮೊಡುಕ್‍ ನಾ. ತರ್, ತಿಯಾ ಮಾಕಾ ಕಾಯ್ ದಿಲೆ? ದೊಸ್ತಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಜ್ಯಾ ಕರ್ ಮನುನ್. ಎಕ್ ಶೆಳ್ ಸೈತ್ ತಿಯಾ ಮಾಕಾ ದಿವ್ಕ್‌ನೆಯ್! ");
INSERT INTO kans_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ಖರೆ, ಹ್ಯಾ ತುಜ್ಯಾ ಲೆಕಾನ್ ತುಜಿ ಸಗ್ಳಿ ಆಸ್ತಿ ಅನಿ ಪೈಸೆ ರಾಂಡಾ ಕರುನ್ ಹಾಳ್ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ತೊ ಪರ್ತುನ್ ಯೆಲಾ ಮನುನ್ ತಿಯಾ ಬರೊ ತಯಾರ್‍ಲೊ ಪುಟ್ಪುಟಿತ್ ಪಾಡ್ಕು ಮಾರ್ಲೆಯ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ತನ್ನಾ ಬಾಬಾನ್ ತೆಕಾ, “ಮಾಜ್ಯಾ ಲೆಕಾ,ತಿಯಾ ಕನ್ನಾಬಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಹಾಸ್, ಅನಿ ಮಾಜೆ ಮನುನ್ ಹೊತ್ತೆ ಸಗ್ಳೆ ತುಜೆಚ್. ");
INSERT INTO kans_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ಖರೆ ಅತ್ತಾ ಅಮಿ ಗರ್‍ದಿ ಕರುಕ್ ಪಾಜೆ, ಕುಶಿ ಹೊವ್ಕ್ ಪಾಜೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮರಲ್ಲೊ ತುಜೊ ಭಾವ್ ಝಿತ್ತೊ ಹೊವ್ನ್ ಯೆಲಾ,ಕಳ್ದುನ್ ಗೆಲ್ಲೊ ಖರೆ ಅತ್ತಾ ತೊ ಅಮ್ಕಾ ಗಾವ್ಲಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ “ಎಗ್ದಾ ಎಕ್ ಸಾವ್ಕಾರ್ ಮಾನುಸ್ ಹೊತ್ತೊ. ತೆಚೊ ಯಾವಾರ್ ಸಂಬಾಳ್ತಲೊ ಎಕ್ ಕಾರ್ಬಾರಿ ಹೊತ್ತೊ. ಸಾವ್ಕಾರಾಕ್, ತೊ ಕಾರ್ಬಾರಿ ಅಪ್ನಾಚೆ ಪಯ್ಸೆ ಹಾಳ್ ಕರುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ತೆಚೆಸಾಟ್ನಿ ತೆನಿ, ತ್ಯಾ ಕಾರ್‍ಬಾರ್‍ಯಾಕ್ ಬಲ್ವುಲ್ಯಾನ್, ಅನಿ ತುಜ್ಯಾ ವಿಶಯಾತ್ ಹೆ ಕಾಯ್ ಆಯ್ಕುಲಾ ಮಿಯಾ? ಅನಿ ಫಿಡೆ ತಿಯಾ ಮಾಜ್ಯಾ ಆಸ್ತಿಚೊ ಕಾರ್ಬಾರಿ ಹೊವ್ನ್ ರ್‍ಹಾತಲೆ ನಕ್ಕೊ, ಲಗ್ಗುನಾ ಕಾಯ್ ಹೊತ್ತೊ ಲೆಕ್ಕ್ ಮಾಕಾ ಹಾನುನ್ ಒಪಸ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ತನ್ನಾ ತ್ಯಾ ಕಾರ್‍ಬಾರ್‍ಯಾನ್ ಅಪ್ನಾಚ್ಯಾ ಮನಾತುಚ್ “ಅತ್ತಾ ಜಾಲ್ಯಾರ್, ಮಾಜೊ ಧನಿ ಮಾಕಾ ಮಾಜ್ಯಾ ಕಾಮಾ ವೈನಾ ಕಾಡ್ನಾರ್ ಹಾಯ್,ಮಿಯಾ ಅತ್ತಾ ಕಾಯ್ ಕರು? ಖಂಡುಕ್ ಮಾಕಾ ಬಳ್ ನಾ, ಅನಿ ಭಿಕ್ ಮಾಗುಕ್ ಮಾಕಾ ಲಜ್ಜಾ ಕರ್‍ತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“ಕಾಯ್ ಕರ್‍ತಲೆ ಮನುನ್ ಅತ್ತಾ ಮಾಕಾ ಕಳ್ಳೆ, ಮಾಕಾ ಕಾಮಾ ವೈನಾ ಕಾಡಲ್ಲ್ಯಾ ತನ್ನಾ ಅಪ್ನಾಚ್ಯಾ ಘರಾತ್ನಿ ಘೆಯ್ ಸರ್ಕೆ ಕೊನಾಕ್ಡೆ ತರ್ ದೊಸ್ತಿ ಕರುನ್ ಘೆವ್ಚೆ”, ");
INSERT INTO kans_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ತಸೆಮನುನ್ ತೆನಿ, ಅಪ್ನಾಚ್ಯಾ ಸಾವ್ಕಾರಾಚೆ ರಿನ್ ಫೆಡ್ತಲೆ ಹೊತ್ತ್ಯಾಕ್ನಿ ಬಲ್ವುಲ್ಯಾನ್. “ತಿಯಾ ಕವ್ಡೆ ರಿನ್ ಪಾವ್ತಲೆ ಹಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“ಸೆಂಬರ್ ಡಬ್ಬೆ ತೆಲ್” ಮನುನ್ ತೆನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್, ತೆನಿ‍ ತೆಕಾ “ಹ್ಯೊ ಘೆ ಹಿತ್ತೆ ಹಾಯ್ ತುಜೊ ಲೆಕ್ಕ್, ಬಸ್ ಅನಿ ಪನ್ನಾಸ್ ಮನುನ್ ಲಿವ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ಮಾನಾ ತೆನಿ ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ಬಲ್ವುಲ್ಯಾನ್, “ಅನಿ ತಿಯಾ ಕವ್ಡೆ ರಿನ್ ದಿತಲೆ ಹಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್, ತೆನಿ “ಹಜಾರ್ ಚಿಲಾ ಘಂವ್” ಮಟ್ಲ್ಯಾನ್. ತ್ಯಾ ಅಳಾನ್ “ಘೆ ತುಜೊ ಲೆಕ್ಕ್ ಪತ್ರ್, ಅನಿ ಆಟ್‍ಸೆ ಚಿಲಾ ಮನುನ್ ಲಿವ್” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“ಅಶೆ ಹ್ಯಾ ಕಾರ್‍ಬಾರ್‍ಯಾನ್ ಎವ್ಡೆ ಶಾನೆಪಾನ್ ವಾಪರಲ್ಲೆ ಬಗುನ್, ಸಾವ್ಕಾರಾನ್ ತೆಕಾ ಶಬಾಸ್ಕಿ ದಿಲ್ಯಾನ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಹ್ಯಾ ಜಗಾತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ, ತೆಂಚಿ ವಿಶಯಾ ಕಶಿ ಕರುನ್ ಸಂಬಾಳ್ತಲಿ ಮನುನ್, ದೆವಾಚ್ಯಾ ವಾಟೆನ್ ಚಲ್ತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾನ್ಕಿ, ಬರೆ ಗೊತ್ತ್ ಹಾಯ್”,ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ಅನಿ ಫಿಡೆ ಜೆಜುನ್ “ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ; ಜಗಾತ್ ತುಮಿ ತುಮ್ಚ್ಯಾಚ್ ಸಾಟ್ನಿ ಮನುನ್, ತುಮ್ಚ್ಯಾ ಅನ್ನ್ಯಾಯಾಚ್ಯಾ ಸಾವ್ಕಾರ್‍ಕಿನ್ ದೊಸ್ತಿಯಾ ಕಮ್ವುನ್ ಘೆವಾ, ಅಶೆ ಹ್ಯಾ ಜಗಾನ್ ತುಮ್ಕಾ ಸೊಡುನ್ ದಿಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮ್ಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸ್ತಾನಾ ರ್‍ಹಾತಲ್ಯಾ ಘರಾತ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಹೊತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ಜೆ ಕೊನ್ ಬಾರಿಕ್ಲ್ಯಾ ವಿಶಯಾತ್ನಿ ವಿಶ್ವಾಸಾನ್ ರ್‍ಹಾತಾ; ತೊ ಮೊಟ್ಯಾ ವಿಶಯಾತ್ನಿಬಿ ವಿಶ್ವಾಸಾನ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ಜರ್, ತುಮ್ಕಾ ಹ್ಯಾ ಜಗಾತ್ಲಿ ವಿಶಯಾಚ್ ಸಂಬಾಳುಕ್ ಹೊಯ್‍ನ್ಯಾತ್, ತರ್ ಖರ್‍ಯಾ, ಅನಿ ಲೈ ಕಿಮ್ತಿಚ್ಯಾ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ಜವಾಬ್ದಾರಿಕ್ ತುಮಿ ಕಶೆ ವಿಶ್ವಾಸಾನ್ ರ್‍ಹಾವ್ಕ್ ಹೊತಾ? ");
INSERT INTO kans_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ಅನಿ ಜರ್ ದುಸ್ರ್ಯಾಕ್ನಿ ಸಮಂದ್ ಪಡಲ್ಲ್ಯಾ ವಿಶಯಾತ್ನಿಚ್ ತುಮಿ ವಿಶ್ವಾಸಾನ್‍ ನಾಶಿ, ತರ್ ತುಮ್ಕಾಚ್ ಮನುನ್ ಸಮಂದ್ ಪಡಲ್ಲೆ ತುಮ್ಕಾ ಕೊನ್ ದಿತಾ? ");
INSERT INTO kans_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ಎಕ್ ಆಳಾನ್ ದೊನ್ ಧನಿಯಾಂಚಿ ಸೆವಾ ಕರುಕ್ ಹೊಯ್ನಾ; ತೊ ಆಳ್ ಎಕ್ಲ್ಯಾಚೊ ದ್ವೆಶ್ ಕರ್‍ತಾ, ಅನಿ ಎಕ್ಲ್ಯಾಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ. ಎಕ್ಲ್ಯಾಕ್ ತೊ ವಿಶ್ವಾಸಾನ್ ರ್‍ಹಾತಾ,ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ತೊ ವಿಶ್ವಾಸಾನ್ ರ್‍ಹಾಯ್ನಾ. “ತುಮಿ ದೆವಾಚಿಬಿ, ಪೈಸ್ಯಾಂಚಿಬಿ ಸೆವಾ ಕರುಕ್ ಹೊಯ್ನಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ಹೆ ಸಗ್ಳೆ ಆಯ್ಕುನ್, ಪೈಸ್ಯಾಂಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಲ್ಯಾ ಫಾರಿಜೆವಾನಿ, ಜೆಜುಕ್ ನಕ್ಕಲ್ ಕರ್‍ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ಜೆಜುನ್ ತೆಂಕಾ “ಲೊಕಾಂಚ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ತುಮಿ ತುಮ್ಕಾಚ್ ಬರಿ ಮಾನ್ಸಾ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತ್ಯಾಶಿ, ಖರೆ, ದೆವಾಕ್ ತುಮ್ಚೊ ಮನ್ ಕಸೊ ಹಾಯ್ ಮನ್ತಲೆ ಗೊತ್ತ್ ಹಾಯ್, ಮಾನ್ಸಾನಿ ಲೈ ಮೊಟ್ಯಾ ಕಿಮ್ತಿಚೆ ಮನುನ್ ಯವಜಲ್ಲ್ಯಾಚಿ ಕಿಮ್ಮತ್ ದೆವಾಚ್ಯಾ ನದ್ರೆತ್ ಕಾಯ್ಬಿ ನ್ಹಯ್”. ");
INSERT INTO kans_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ಜುವಾಂವ್ ಬಾವ್ತಿಸಾಚ್ಯಾ ಕಾಲ್ ಸಗೊಳ್, ಮೊಯ್ಜೆಚೆ ಖಾಯ್ದೆ, ಅನಿ ಪ್ರವಾದ್ಯಾನಿ ಲಿವಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚ್ಯಾ ಪರ್‍ಕಾರ್ ಚಲ್ತಲೆ ಮನುನ್ ಹೊತ್ತೆ; ಖರೆ ಥೈತ್ನಾ ಹಿಕ್ಡಿನ್, ದೆವಾಚ್ಯಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುನ್ ಹೊವ್ಲಾ, ಅನಿ ಸಗ್ಳೆ ಜಾನಾ ತ್ಯಾತುರ್ ಗುಸುಕ್ ಖಟ್‍ಪಟುಲ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“ಹ್ಯೊ ಜಗ್,ಅನಿ ಸರ್ಗ ನಾಪತ್ತೊ ಹೊವ್ನ್ ಜಾವ್ಕ್ ಸಸಾರ್, ಖರೆ, ಖಾಯ್ದ್ಯಾನಿತ್ಲೊ ಎಕ್ ಬಾರಿಕ್ಲೊ ಶಬ್ದ್ ಸೈತ್ ಪುಸುನ್ ಜಾಯ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ಕೊನ್ ತರ್ ಎಕ್ಲೊ ಘೊಮನುಸ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕೊಕ್ ಸೊಡ್ ಚಿಟಿ ದಿತಾ, ಅನಿ ಅನಿ ಎಕ್ಲಿಕ್ಡೆ ನಗಿನ್ ಹೊತಾ, ತರ್ ತೊ ವ್ಯೆಬಿಚಾರ್ ಕರ್‍ತಾ, ಅನಿ ತ್ಯಾ ಸೊಡ್ ಪತ್ತರ್ ಹೊಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಕೊನ್ ನಗಿನ್ ಹೊತಾ, ತೊ ಬಿ ವೆಭಿಚಾರ್ ಕರ್‍ತಾ”, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ಮಾನಾ ಜೆಜುನ್, “ಎಗ್ದಾ ಎಕ್ ಸಾವ್ಕಾರ್ ಮಾನುಸ್ ಹೊತ್ತೊ. ತೊ ಎಗ್ದಮ್ ಲೈ ಕಿಮ್ತಿಚೆ ಕಪ್ಡೆ ನೆಸಿ, ಅನಿ ಸದ್ದಿಚ್ ಎಗ್ದಮ್ ಆರಾಮಾಚೆ ಜಿವನ್ ತೊ ಕರಿ. ");
INSERT INTO kans_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ಲಾಜರಸ್ ಮನ್ತಲೊ ಎಕ್ ಗರಿಬ್ ಮಾನುಸ್‍ಬಿ ಥೈ ಹೊತ್ತೊ. ತೆಚ್ಯಾ ಪುರಾ ಆಂಗಾಕ್ ದುಕ್ಕಾ ಹೊಲ್ಲಿ, ಕನ್ನಾಬಿ ತೊ ತ್ಯಾ ಸಾವ್ಕಾರ್ ಮಾನ್ಸಾಚ್ಯಾ ಹುಂಬ್ಡ್ಯಾತ್ ಯೆವ್ನ್ ಪಡುನ್ ರ್‍ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ತ್ಯಾ ಸಾವ್ಕಾರ್ ಮಾನ್ಸಾಚ್ಯಾ ಜೆವ್ನಾಚ್ಯಾ ಜೆವ್ತಾನಾ ಪಡಲ್ಲೆ ಉಸ್ಟೆ ತರ್‍ಬಿ ಅಪ್ನಾಕ್ ಖಾವ್ಕ್ ಗಾವ್ತಾ ,ಮನುನ್ ತೊ ರಾಕುನ್ಗೆತ್ ರ್‍ಹಾಯ್. ಕುತ್ರಿ ಸೈತ್ ಯೆವ್ನ್ ತೆಚ್ಯಾ ದುಕ್ಕಾಕ್ನಿ ಚಾಟಿತ್”. ");
INSERT INTO kans_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ತೊ ಗರಿಬ್ ಮಾನುಸ್ ಮರ್‍ಲೊ, ಅನಿ ತೆಕಾ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ದುತಾನಿ, ಉಕ್ಲುನ್ ನ್ಹೆವ್ನ್ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ಸನಾಚ್ಯಾ ಜೆವ್ನಾಕ್, ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ಬಾಜುಕುಚ್ ನ್ಹೆವ್ನ್ ಬಸ್ವುಲ್ಯಾನಿ. ತೊ ಸಾವ್ಕಾರ್ ಮಾನುಸ್‍ಬಿ ಮರ್‍ಲೊ, ಅನಿ ತೆಕಾ ಮಾಟಿ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ನರ್‍ಕಾತ್ ಮೊಟ್ಯಾ ವಳ್ವಳ್ಯಾಚ್ಯಾ ಜಾಗ್ಯಾತ್, ತೊ ಹೊತ್ತೊ. ಥೈತ್ನಾ ತೆನಿ ವೈರ್ ಬಗಟಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆಕಾ ಅಬ್ರಾಮ್ ದಿಸ್ಲೊ ಥೈತ್ನಾ ತೊ ಧುರ್ ಹೊತ್ತೊ, ಅನಿ ಲಾಜರಸ್ ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ಬಾಜುಕುಚ್ ಬಸಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ತನ್ನಾ ತೊ ಸಾವ್ಕಾರ್ ಮಾನುಸ್, “ಅಬ್ರಾಹಾಮ್ ಬಾಬಾ! ಮಾಜೆ ವರ್‍ತಿ ದಯಾ ಕರ್, ಅನಿ ಲಾಜರಸಾಕ್ ತೆಚಿ ಬೊಟ್ ಪಾನಿಯಾತ್ ಬುಡ್ವುನ್, ಎಕ್ ಠೆಂಬೊ ಮಾಜ್ಯಾ ಜಿಬ್ಲಿ ವರ್‍ತಿ ಘಾಲುನ್‍ ಥಂಡ್ ಕರುಕ್, ತೆಕಾ ಮಾಜೆಕ್ಡೆ ಧಾಡುನ್ ದಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮಿಯಾ ಹ್ಯಾ ಆಗಿತ್ ವಳ್ವಳುಲಾಲಾ!” ಮನುನ್ ಬೊಬ್ ಮಾರುನ್ ಸಾಂಗುಕಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ಖರೆ ಅಬ್ರಾಹಾಮಾನ್ ತೆಕಾ, “ಮಾಜ್ಯಾ ಲೆಕಾ, ಯಾದ್‍ ಕರ್, ತುಜ್ಯಾ ಜಿವನಾತ್ ತುಕಾ ಸಾವ್ಕಾರ್‍ಕಿಚೆ ಜಿವನ್ ಹೊತ್ತೆ,ಖರೆ ಲಾಜರಸಾಚೆ ಜಿವನ್ ಲೈ ತರಾಸಾಚೆ ಹೊತ್ತೆ, ತೆಚೆಕ್ಡೆ ಕಾಯ್ಬಿ ನತ್ತೆ. ಖರೆ ಅತ್ತಾ ತಿಯಾ ತರಾಸಾನ್ ವಳ್ವಳುನ್ಗೆತ್ ಹಾಸ್, ಅನಿ ತೊ ಹಿತ್ತೆ ಮಜ್ಯಾ ಕರುನ್ಗೆತ್, ಕುಶಿನ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ಹೆಚ್ಯಾ ಭಾಯ್ರ್ ಸಾಂಗುಚೆ ಜಾಲ್ಯಾರ್, ತುಮ್ಚ್ಯಾ ಅನಿ ಅಮ್ಚ್ಯಾ ಮದ್ದಿ,ಎಕ್ ಮೊಟೊ ಅಂತರ್ ಹಾಯ್ , ಅಮ್ಚ್ಯೆಕ್ನಾ ತುಮ್ಚ್ಯಾಕ್ಡೆ ಮನುನ್ ಯವಜ್ಲ್ಯಾರ್, ಕೊನಾಕ್ಬಿ ಯೆವ್ಕ್ ಹೊಯ್ನಾ, ಅನಿ ತುಮ್ಚ್ಯಾಕ್ನಾ, ಅಮ್ಚೆಕ್ಡೆ ಕೊನ್ಬಿ ಯೆವ್ಕ್ ಬಗಟ್ಲ್ಯಾರ್‍ಬಿ ತೆಕಾ ಹಿಕ್ಡಿ ಯೆವ್ಕ್ ಹೊಯ್ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ತನ್ನಾ ತ್ಯಾ ಸಾವ್ಕಾರ್ ಮಾನ್ಸಾನ್, “ಅಬ್ರಾಹಾಮ್ ಬಾಬಾ, ಮಿಯಾ ತುಜೆಕ್ಡೆ ದಯಾ ಕರುನ್ ಮಾಗ್ತಾ, ಲಾಜರಸಾಕ್ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ಘರಾಕ್ ಧಾಡುನ್ ದಿ. ");
INSERT INTO kans_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ಥೈ ಮಾಜಿ ಪಾಚ್‍ ಜಾನಾ ಭಾವಾ ಹಾತ್, ತೊ ತೆಂಕಾ ಜಾವ್ನ್ ಉಶಾರ್ಕಿ ದಿಂವ್ದಿತ್, ತೆನಿ ತರ್‍ಬಿ, ಹ್ಯಾ ವಳ್ವಳ್ಯಾಚ್ಯಾ ಜಾಗ್ಯಾರ್ ಯೆಯ್ನಸ್ತಾನಾ ರಾಂವ್ದಿತ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ತನ್ನಾ ಅಬ್ರಾಹಾಮಾನ್,“ತುಜ್ಯಾ ಭಾವಾಕ್ನಿ ಉಶಾರ್ಕಿ ದಿವ್ಕ್ ಮೊಯ್ಜೆ, ಅನಿ ಪ್ರವಾದ್ಯಾಂಚಿ ಪುಸ್ತಕಾ ಹಾತ್. ತ್ಯಾತುರ್‍ನಿ ಸಾಂಗಟಲ್ಲೆಚ್ ತುಜಿ ಭಾವಾ ಆಯ್ಕುಂದಿತ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ತನ್ನಾ ತ್ಯಾ ಸಾವ್ಕಾರ್ ಮಾನ್ಸಾನ್, “ತೆ ತವ್ಡೆಚ್ ತೆಂಕಾ ಉಶಾರ್ಕಿ ದಿವ್ಕ್ ಪಾವಿನಾ, ಅಬ್ರಾಹಾಮ್ ಬಾಬಾ! ಮರಲ್ಲೊ ಎಕ್ಲೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ತೆಂಚ್ಯಾಕ್ಡೆ ಗೆಲ್ಯಾರ್, ತೆನಿ ತೆಂಚ್ಯಾ ಪಾಪಾನಿತ್ನಾ ಫಾಟಿ ಪರತ್ತ್ಯಾತ್”, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ಖರೆ ಅಬ್ರಾಮಾನ್,“ಮೊಯ್ಜೆನ್, ಅನಿ ಪ್ರವಾದ್ಯಾನಿ ಸಾಂಗಟಲ್ಲೆ ತೆನಿ ಆಯ್ಕಿ ನಸ್ಲ್ಯಾರ್, ಮರಲ್ಲ್ಯಾತ್ಲೊ ಕೊನ್ಬಿ ಝಿತ್ತೊ ಹೊವ್ನ್ ಗೆಲ್ಯಾರ್‍ಬಿ, ತೆನಿ ಆಯ್ಕಿನ್ಯಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಲೊಕಾಕ್ನಿ ಪಾಪಾತ್ ಪಾಡ್ವುತಲಿ ಕಾಮಾ ಹೊವ್ಕುಚ್ ಪಾಜೆ, ಖರೆ, ಹಿ ಪಾಪಾತ್ ಪಡಿಸರ್ಕೆ ಕತರ್ಲಿ ಕಾಮಾ ಕರ್‍ತಲ್ಯಾಚಿ ಗತ್ ಮಿಯಾ ಕಾಯ್ ಸಾಂಗು! ");
INSERT INTO kans_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ಎಕ್ಲ್ಯಾನ್ ಪಾಪಾತ್ ಪಡುಕ್ ಕಾರನ್ ಹೊತಲ್ಯಾ ಬದ್ಲಾಕ್ ತೆಕಾ ತೆಚ್ಯಾ ಗಳ್ಯಾತ್ ಎಕ್ ಮೊಟೊ ಜಾತ್ಯಾಚೊ ಗುಂಡೊ ಭಾಂದುನ್ ಸಮುಂದರಾತ್ ನ್ಹೆವ್ನ್ ತಾಕ್ತಲೆ ಲೈ ಬರೆ. ");
INSERT INTO kans_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ತುಮ್ಚ್ಯಾ ಕರ್ನ್ಶಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ. ಜರ್ ತರ್ ತುಜ್ಯಾ ಭಾವಾನ್ ಪಾಪ್ ಕರ್‍ಲ್ಯಾನ್ ತರ್, ತೆಕಾ ಬುದ್‍ಬಾಳ್ ಸಾಂಗ್, ತೆ ಆಯ್ಕುನ್ ತೊ ಬದಲ್ಲ್ಯಾರ್ ತೆಕಾ ಮಾಪ್ ಕರ್. ");
INSERT INTO kans_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ಜರ್ ತರ್ ಎಕ್ ದಿಸಾಚ್ಯಾ ಪೊಟಾತ್ ಸತ್ತ್‌ದಾಬಿ ತೊ, ತುಜ್ಯಾ ವಿರೊದ್ ಪಾಪ್ ಕರ್‍ತಾ, ಅನಿ ಯೆವ್ನ್ ಚುಕ್ ಮಾಗ್ತಾ, ತರ್ ತೆಕಾ ಮಾಪ್ ಕರ್. ");
INSERT INTO kans_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ಅಪೊಸ್ತಲಾನಿ ಜೆಜುಕ್ “ಅಮ್ಚೊ ವಿಶ್ವಾಸ್ ಘಟ್ ಕರ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ತನ್ನಾ ಜೆಜುನ್, “ತುಮ್ಕಾ ಖಾಲಿ ಎಕ್ ಸಾಸಾವಾಚ್ಯಾ ಭ್ಹಿಂಯಾ ಎವ್ಡೊ ವಿಶ್ವಾಸ್ ರ್‍ಹಾಲ್ಯಾರ್, ತುಮಿ ಎಕ್ ವಡ್ಡಾಚ್ಯಾ ಝಾಡಾಕ್ ತಿಯಾ ಬೆರಾ ಸಮೆತ್ ಉಪ್ಸುನ್, ಸಮುಂದರಾತ್ ಜಾವ್ನ್ ಇಬೆ ರ್‍ಹಾ, ಮಟ್ಲ್ಯಾರ್ ತೆ ಜಾವ್ನ್ ಇಬೆ ರ್‍ಹಾತಾ”, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ತುಮ್ಚೊ ಎಕ್ ಆಳ್ ಮನುನ್ ಚಿಂತುವಾ, ಅನಿ ತೊ ಶೆತಾತ್ ನಾಂಗ್ರುಕ್ ನಾಹೊಲ್ಯಾರ್, ಬಕ್ರ್ಯಾಕ್ನಿ ರಾಕುಕ್ ಜಾತಾ, ತೊ ಶೆತಾಕ್ನಾ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ತುಮಿ ಲಗ್ಗುನಾ ಯೆ, ಅನಿ ಜೆವಾನ್ ಕರ್ ಮನ್ತ್ಯಾಶಿ ಕಾಯ್?” ");
INSERT INTO kans_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ಕನ್ನಾಚ್ ನಾ! ಹೆಚ್ಯಾ ಬದ್ಲಾಕ್, ತೆಕಾ ತುಮಿ “ಮಾಜೆ ಜೆವಾನ್ ತಯಾರ್ ಕರ್, ತುಜ್ಯಾ ಕಂಬ್ರೆಕ್ ಟಿವಾಲೊ ಭಾಂದುನ್ ಘೆ, ಅನಿ ಮಾಜೆ ಜೆವ್ನ್, ಫಿವ್ನ್ ಹೊಯ್‍ ಪತರ್ ರ್‍ಹಾ,ಅನಿ ಮಾನಾ ತಿಯಾ ಜೆವಾನ್ ಕರ್, ಮನ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ಸಾಂಗಲ್ಲೆ ಸಗ್ಳೆ ಕಾಮ್ ಕರಲ್ಲ್ಯಾ ಸಾಟ್ನಿ ಆಳಾಕ್ ಶಾಬಾಸ್ಕಿ ದಿತ್ಯಾಶಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ತುಮ್ಚೆಬಿ ತಸೆಚ್, ತುಮ್ಕಾ ಸಾಂಗಟಲ್ಲೆ ಸಗ್ಳೆ ಕರುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಅಮಿ ಸಾದಾರನ್ ಆಳಾ, ಅಮ್ಚೆ ಕಾಮ್ ಅಮಿ ಕರ್ಲಾಂವ್” ಮನುನ್ ಯವ್ಜುನ್ ಘೆವ್ನ್ ರ್‍ಹಾವಾ. ");
INSERT INTO kans_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ಜೆಜು ಜೆರುಜಲೆಮಾಚಿ ವಾಟ್ ಧರುನ್ ಜವ್‍ಲಾಗಲ್ಲೊ, ಸಾಮಾರಿಯಾ, ಅನಿ ಗಾಲಿಲಿಯಾ ಮನ್ತಲ್ಯಾ ದೊನ್ ಜಾಗ್ಯಾಂಚ್ಯಾ ಬರಬ್ಬರ್ ಮದ್ನಾ ತೊ ಜಾವ್‌ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ತೊ ಎಕ್ ಗಾಂವಾತ್ ಜಾವ್‍ಲಾಗಲ್ಲೊ, ತನ್ನಾ ತೆಕಾ, ಧಾ ಜಾನಾ ಕುಸ್ಟ್ ರೊಗ್‍ ಲಾಗಲ್ಲಿ ಲೊಕಾ ಭೆಟ್ಲಿ. ತೆನಿ ಜೆಜುಕ್ನಾ ಉಲ್ಲೆ ಧುರುಚ್ ಇಬೆ ರ್‍ಹಾಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ಅನಿ, “ಜೆಜು! ಗುರುಜಿ! ಅಮ್ಚಿ ದಯಾ ಕರ್”, ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ಜೆಜುನ್ ತೆಂಕಾ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ “ಜಾವಾ, ಯಾಜಕಾನಿಕ್ಡೆ ಜಾವ್ನ್ ತಪಾಸುನ್ ಬಗುನ್ ಘೆವಾ” ಮಟ್ಲ್ಯಾನ್. ವಾಟೆನ್ ಜಾತಾ-ಜಾತಾನಾಚ್ ತೆನಿ ಪವಿತ್ರ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾನ್ ಅಪ್ನಾಕ್ ಆರಾಮ್ ಹೊಲ್ಲೆ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ತೊ ದೆವಾಕ್ ಹೊಗ್ಳುನ್ಗೆತ್ ಫಾಟಿ ಪರ್ತುನ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ತೊ ಜೆಜುಚ್ಯಾ ಪಾಂಯಾತ್ನಿ ಪಡ್ಲೊ ಅನಿ ಜೆಜುಕ್ ತೆನಿ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನ್. ತೊ ಸಮಾರಿಯಾಚೊ ಎಕ್ ಮಾನುಸ್. ");
INSERT INTO kans_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ತನ್ನಾ ಜೆಜುನ್, “ಅತ್ತಾ ಗುನ್ ಹೊಲ್ಲಿ ಧಾ ಲೊಕಾ ನ್ಹಯ್? ಹುರಲ್ಲಿ ನ್ಹವ್ ಲೊಕಾ ಖೈ ಹಾತ್? ");
INSERT INTO kans_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ದುಸ್ರ್ಯಾ ದೆಸಾತ್ಲೊ ಎಕ್ಲೊಚ್ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿವ್ಕ್ ಮನುನ್ ಪರ್ತುನ್ ಯೆಲೊ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ಅನಿ ಜೆಜುನ್ ತೆಕಾ “ಉಟ್, ಅನಿ ಚಲ್, ತುಜ್ಯಾ ವಿಶ್ವಾಸಾನುಚ್ ತುಕಾ ಬರೆ ಕರ್‍ಲ್ಯಾನ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ಎಗ್ಧಾ ಉಲ್ಲ್ಯಾಸ್ಯಾ ಫಾರಿಜೆವಾನಿ, ಜೆಜುಕ್, “ದೆವಾಚೆ ರಾಜ್ ಕನ್ನಾ ಯೆತಾ” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತನ್ನಾ ತೆಚೊ ಜವಾಬ್ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, “ದೆವಾಚೆ ರಾಜ್ ಕೊನಾಕ್ಬಿ ದಿಸುನ್ಗೆತ್ ಯೆಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ಕೊನ್ಬಿ ಅಬಕ್ ,ಹಿತ್ತೆ ಹಾಯ್! ಥೈ ಹಾಯ್! ಮನುನ್ ಸಾಂಗುಕ್ ಹೊಯ್ನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ದೆವಾಚೆ ರಾಜ್ ತುಮ್ಚ್ಯಾ ಭುತ್ತುರುಚ್ ಹಾಯ್”. ");
INSERT INTO kans_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ತನ್ನಾ ತೆನಿ ಶಿಸಾಕ್ನಿ, ಎಕ್ ಎಳ್ ಯೆತಾ, ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆತಲೆ ಹ್ಯಾ ದಿಸಾತ್ನಿ ಅಮಿ ಬಗ್ತಾಂವ್, ಮನುನ್ ತುಮಿ ಯವ್ಜುನ್ ಘೆವ್ನ್ ರ್‍ಹಾತ್ಯಾಶಿ, ಖರೆ, ತೊ ದಿಸ್ ತುಮ್ಕಾ ಬಗುಕ್ ಗಾವಿನಾ. ");
INSERT INTO kans_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ಲೈ ಜಾನಾ ತನ್ನಾ “ಹಿತ್ತೆ ಬಗಾ! ಥೈ ಬಗಾ, ಮನುನ್ ತುಮ್ಕಾ ಸಾಂಗ್ತ್ಯಾತ್,ಖರೆ ತುಮಿ ತೆ ಸಗ್ಳೆ ಬಗುಕ್ ಜಾವ್‍ನಕಾಶಿ”. ");
INSERT INTO kans_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಳ್ಬಾ ವರ್‍ತಿ ಎಕ್ ದಿಕ್ಕಾಕ್ನಾ, ಅನಿಎಕಾ ದಿಕ್ಕಾ ಪತರ್ ಮಿಂಚ್ ಮಾರುಕ್ ಲಾಗಲ್ಲ್ಯಾ ತನ್ನಾ,ಮಿಯಾ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆತಲಿ ದಿಸಾ ಮನುನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ಖರೆ, ಅದ್ದಿ ತೊ ಕಸ್ಟ್ ಸೊಸುಕ್ ಪಾಜೆ, ಅನಿ ಅತ್ತಾಚ್ಯಾ ಕಾಲಾಚ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ಧುರ್ ಕರುಕ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ನೊಯೆಚ್ಯಾ ಕಾಲಾತ್ ಹೊಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್, ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಯೆತಲ್ಯಾ ಕಾಲಾತ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ನೊಯೆ ಢೊನಿತ್ ಭುತ್ತುರ್ ಗುಸಿ ಪತರ್, ಸಗ್ಳೆ ಜಾನಾ ಖಾವ್ನಗೆತ್, ಫಿವ್ನಗೆತ್, ಅನಿ ಘೊಮನ್ಸಾ ಬಾಯ್ಕೊಮನ್ಸಾ ನಗಿನ್ ಹೊವ್ನಗೆತ್ ಹೊತ್ತ್ಯಾನಿ, ಅನಿ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಪಾನಿ ಭರುನ್ ಯೆಲೆ, ಅನಿ ತೆಂಕಾ ಜಿವಾನಿ ಮಾರುನ್ ಟಾಕ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ಲೊಟಾಚ್ಯಾ ಕಾಲಾತ್ ಹೊಲ್ಲ್ಯಾ ಸರ್ಕೆ, ಸಗ್ಳೆ ಜಾನಾ ಜೆವ್ನಗೆತ್, ಫಿವ್ನಗೆತ್, ಇಕುನ್ಗೆತ್-ಇಕಾತ್ ಘೆವ್ನ್‌ಗೆತ್, ಶೆತಾ ಕರುನ್ಗೆತ್, ಅನಿ ಭಾಂದುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ಖರೆ ಲೊಟ್ ಸೊದೊಮಾತ್ನಾ ಭಾಯ್ರ್ ಪಡಲ್ಲ್ಯಾ ತನ್ನಾ, ಮಳ್ಬಾ ವೈನಾ ಆಗ್ ಅನಿ ಆಗಿಚ್ಯಾ ಇಂಗ್ಳ್ಯಾಂಚೊ ಪಾವ್ಸ್ ಯೆಲೊ, ಅನಿ ತೆಂಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಜಿವಾನಿಚ್ ಮಾರುನ್ ಸೊಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ಮಾನ್ಸಾಚೊ ಲೆಕ್, ಯೆತಾನಾಬಿ ತಸೆಚ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ತ್ಯಾ ದಿಸ್ ಜೊ ಮಾನುಸ್, ಅಪ್ನಾಚ್ಯಾ ಘರಾಚ್ಯಾ ಮ್ಹಾಳ್ಗಿರ್ ಬಸ್ಲಾ, ತೊ ಅಪ್ನಾಚಿ ಸಾಮಾನಾ ಹಾನುಕ್ ಮನುನ್ ಉತ್ರುನ್ ಘರಾತ್ ಜಾಯ್‌ನಸ್ತಾನಾ ರಾಂವ್ದಿತ್, ತಸೆಚ್ ಜೊ ಮಾನುಸ್ ಭಾಯ್ರ್ ಶೆತಾತ್ ಹಾಯ್, ತೊ ಅನಿ ಪರ್ತುನ್ ಘರಾಕ್ ಯೆಯ್ನಸ್ತಾನಾ ರಾವ್ನದಿತ್. ");
INSERT INTO kans_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","\"ಲೊಟಾಚ್ಯಾ ಬಾಯ್ಕೊಚಿ ಖಬರ್ ಕಾಯ್ ಹೊಲಿ ಮನುನ್ ಯಾದ್ ರ್‍ಹಾಂವ್ದಿತ್!” ");
INSERT INTO kans_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“ಜೆ ಕೊನ್ ಅಪ್ನಾಚೊ ಜಿಂವ್ ರಾಕುನ್ ಘೆವ್ಕ್ ಬಗ್ತಾ, ತೊ ತೆ ಕಳ್ದುನ್ ಘೆತಾ, ಅನಿ ಜೆ ಕೊನ್ ಅಪ್ನಾಚೊ ಜಿವ್ ಕಳ್ದುನ್ ಘೆತಾ ತೊ ಹುರ್ವುನ್ ಘೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ತ್ಯಾ ದಿಸ್ ರಾಚ್ಚೆ, ಎಕ್ ಹಾತ್ರಾನಾತ್ ನಿಜಲ್ಲ್ಯಾ ದೊಗ್ಯಾ ಜಾನಾನಿತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ. ಅನಿ ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ಸೊಡುನ್ ಜಾವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ಅನಿ ಜಾತ್ಯಾ ವರ್‍ತಿ ದಳುಕ್ ಬಸಲ್ಲ್ಯಾ ದೊಗೆ ಜಾನಾ ಬಾಯ್ಕೊಮನ್ಸಾನಿತ್ಲ್ಯಾ ಎಕ್ಲಿಕ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ, ಅನಿ ಅನಿ ಎಕ್ಲಿಕ್ ಥೈಚ್ ಸೊಡುನ್ . ಹೊತಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ಶಿಸಾನಿ ಜೆಜುಕ್, “ಹೆ ಸಗ್ಳೆ ಖೈ ಘಡ್ತಾ! ಧನಿಯಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ಜೆಜುನ್ ತೆಂಕಾ “ಖೈ ಮಡಿ ಪಡಲ್ಲಿ ಹಾತ್, ಥೈಚ್ ಹಳಿಹಡ್ಡಾ ಗೊಳಾ ಹೊತ್ಯಾತ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ, ಕನ್ನಾಬಿ ಕಂಟಾಳಿನಸ್ತನಾ ಮಾಗ್ನಿ ಕರುನ್ಗೆತ್ ರ್‍ಹಾತಲೆ ಶಿಕ್ವುಸಾಟ್ನಿ ಮನುನ್, ಹಿ ಕಾನಿ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ಎಕ್ ಮೊಟ್ಯಾ ಗಾಂವಾತ್ ಎಕ್ ನ್ಯಾಯ್ ನಿರ್‍ನಯ್‍ ಕರ್‍ತಲೊ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೆಕಾ ದೆವಾಚೆ ಭಿಂಯೆ ನತ್ತೆ, ಅನಿ ಮಾನ್ಸಾಕ್ನಿ ತರ್ ತೊ ಮೆಜಿಚ್‍ನಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ಅನಿ ತ್ಯಾಚ್ ಗಾಂವಾತ್ ಅಪ್ನಾಕ್ ನ್ಯಾಯ್ ನಿರ್‍ನಯ್ ಕರುನ್ ದಿವ್‍ಸಾಟಿ ಮನುನ್ ತ್ಯಾ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾಕ್ಡೆ ಸದ್ದಿಚ್ ಯೆವ್ನಗೆತ್ ಎಕ್ ಘೊಮರಲ್ಲಿ ಬಾಯ್ಕೊಮನುಸ್ ಹೊತ್ತಿ. ಅನಿ ತೆಕಾ ತಿ, “ಮಾಜ್ಯಾ ವಿರೊದ್ಯಾಚ್ಯಾಕ್ನಾ ಮಾಕಾ ನ್ಯಾಯ್‍ ನಿರ್‍ನಯ್ ಕರುನ್ ದಿ” ಮನುನ್ ಸಾಂಗಿ. ");
INSERT INTO kans_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ತ್ಯಾ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾನ್ ಸುಮಾರ್ ದಿಸಾ ತಿಚ್ಯಾ ವಿಶಯಾತ್ ಟಕ್ಲೆ ನಾಸ್ವುನ್ ಘೆವ್ಕ್ ನಾ. ಖರೆ ಆಕ್ರಿಕ್ ಎಗ್ದಾ ತೆನಿ “ಮಿಯಾ ದೆವಾಕ್ ತರ್ ಭಿಂಯ್ ನಾ, ಅನಿ ಮಾನ್ಸಾಕ್ನಿ ತರ್ ಮೆಜಿಚ್‍ ನಾ, ");
INSERT INTO kans_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ಜಾಲ್ಯಾರ್‍ಬಿ ಹ್ಯಾ ಘೊಮರಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಮಿಯಾ ಕಾಯ್ತರ್ ತಿರ್‍ಮಾನ್ ಕರುನ್ ದಿವ್ಚೊ, ಅನಿ ತಿಚೊ ಹಕ್ಕ್ ತಿಕಾ ಗಾವಿ ಸರ್ಕೆ ಕರುಚೆ, ಮಿಯಾ ತಿಕಾ ಕಾಯ್ಬಿ ನಿರ್‍ನಯ್ ಕರುನ್ ದಿನಸ್ಲ್ಯಾರ್, ಸದ್ದಿ ಯೆವ್ನ್, ತಿ, ಮಾಜೆ ಟಕ್ಲೆ ಖಾತಾ!” ಮನುನ್ ಯವ್ಜುನ್ ಘೆಟ್ಲ್ಯಾನ್. ಅನಿ ತಿಕಾ ಎಕ್ ನಿರ್‍ನಯ್ ಕರುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ಅಶೆ ಧನಿಯಾನ್, ತೆಂಕಾ “ತೊ ಬುರ್ಶ್ಯಾ ನ್ಯಾಯ್ ಕರ್ನಾರೊ ಕಾಯ್ ಮನ್ತಾ ಮನುನ್, ಆಯ್ಕಲ್ಯಾಸಿ!” ");
INSERT INTO kans_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ತರ್ ಅತ್ತಾ, ದೆವ್ ಅಪ್ನಾಕ್ಡೆ ದಿಸ್ -ರಾತ್ ಮಾಗ್ತಲ್ಯಾ ಅಪ್ನಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ನ್ಯಾಯ್ ಕರುನ್ ದಿ ನಾ ಕಾಯ್? ತೊ ಲಗ್ಗುನಾಚ್ ತೆಂಕಾ ತೆನಿ ಮಾಗಲ್ಲೆ ದಿ,ನಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ. ತೊ ಲಗ್ಗುನಾಚ್ ತೆಂಕಾ ನ್ಯಾಯ್ ಕರುನ್ ದಿತಾ. ಖರೆ, ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಹ್ಯಾ ಜಗಾತ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಲೊಕಾಂಚ್ಯಾ ಮನಾತ್ನಿ ವಿಶ್ವಾಸ್ ಹೊತ್ತೆ ತೆಕಾ ಬಗುಕ್ ಗಾವ್ತಾ ಕಾಯ್? ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ಅಪ್ನಿ ಬರೆ, ಅನಿ ಹುರಲ್ಲಿ ಸಗ್ಳಿ ಲೊಕಾ ವಾಯ್ಟ್ ಮನುನ್ ಯವ್ಜುನ್ಗೆತ್ ರ್‍ಹಾತಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಜೆಜುನ್, ಹಿ, ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ಎಗ್ದಾ ದೊಗೆ ಜಾನಾ ಹೊತ್ತೆ, ತೆನಿ ದೊಗೆಬಿ ಮಾಗ್ನಿ ಕರುಕ್ ಮನುನ್ ದೆವಾಚ್ಯಾ ಗುಡಿಕ್‍ ಗೆಲ್ಲ್ಯಾನಿ. ಎಕ್ಲೊ ಎಕ್ ಫಾರಿಜೆವ್, ಅನಿ ಅನಿ ಎಕ್ಲೊ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲೊ ಪಾಪಿ ಮಾನುಸ್”. ");
INSERT INTO kans_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ಫಾರಿಜೆವ್ ಅಪ್ನಾಚ್ಯಾ ಎವ್ಡ್ಯಾಕ್ ಧುರುಚ್ ಇಬೆ ರ್‍ಹಾಲೊ, ಅನಿ ದೆವಾ ಮಿಯಾ ತುಕಾ ಧನ್ಯವಾದ್ ದಿತಾ. ಮಿಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಸರ್ಕೊ, ಅಸ್‍ಬುರ್ಕೊ, ಸಾಂಗಟಲ್ಲೆ ಕರಿನಸಲ್ಲೊ, ನಾ ಹೊಲ್ಯಾರ್, ಎಕ್ ವೆಭಿಚಾರ್ ಕರ್‍ತಲೊ ಮಾನುಸ್ ನ್ಹಯ್. ಮಿಯಾ ತಬಕ್, ತ್ಯಾ ತೆರ್‍ಗಿ ವಸುಲಿ ಕರ್‍ತಲ್ಯಾ ಪಾಪಿ ಮಾನ್ಸಾ ಸಾರ್ಕೊ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","“ಮಿಯಾ ವಾರಾತ್ ದೊನ್ ದಿಸ್ ಉಪಾಸ್ ಕರ್‍ತಾ, ಅನಿ ಮಾಜ್ಯಾ ಉತ್ಪನ್ನಾತ್ಲೊ ಧಾತ್ಲೊ ಎಕ್ ವಾಟೊ ತುಕಾ ದಿತಾ”, ಮನುನ್ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ಖರೆ, ತೊ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲೊ, ಪಾಪಿ ಮಾನುಸ್, ಧುರುಚ್ ಇಬೆ ರ್‍ಹಾಲೊ, ತೆನಿ ಟಕ್ಲೆ ವೈರ್ ಕರುನ್ ಅಪ್ನಾಚೆ ಡೊಳೆ ಸೈತ್ ಸರ್‍ಗಾಕ್ ಲಾವುಕ್ನಾ, ಅಪ್ನಾಚೆ ಹಿರ್‍ದೆ ಬಡ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ “ದೆವಾ ಮಿಯಾ ಎಕ್ ಪಾಪಿ ಮಾನುಸ್, ಮಾಜಿ ದಯಾ ಕರ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ತನ್ನಾ ಜೆಜುನ್, ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ತೊ ತೆರ್‍ಗಿ ವಸುಲ್ ಕರ್‍ತಲೊ, ದೆವಾಚ್ಯಾ ನದ್ರೆತ್ ನಿತಿವಂತ್ ಹೊವ್ನ್, ಆಶಿರ್ವಾದ್ ಘೆವ್ನ್ ಗೆಲೊ. ತ್ಯಾ ಫಾರಿಜೆವಾಚಿ ಮಾಗ್ನಿ, ದೆವಾಕ್ ಮಾನುಕ್ ನಾ. ಜೆ ಕೊನ್ ಅಪ್ನಾಕುಚ್ ವರ್‍ತಿ ಕರ್‍ತ್ಯಾತ್, ತೆಂಕಾ ಖಾಲ್ತಿ ಕರುನ್ ಹೊತಾ, ಅನಿ ಜೆ ಕೊನ್ ಅಪ್ನಾಕುಚ್ ಖಾಲ್ತಿ ಕರ್‍ತ್ಯಾತ್, ತೆಂಕಾ ವರ್‍ತಿ ಕರುನ್ ಹೊತಾ, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ಉಲ್ಲ್ಯಾಸ್ಯಾ ಲೊಕಾನಿ, ಅಪ್ನಾಚ್ಯಾ ಪೊರಾಂಚ್ಯಾ ವರ್‍ತಿ ಹಾತ್ ಥವ್ನ್ ಆಶಿರ್ವಾದ್ ಘೆವ್ನ್ ಜಾವ್‍ಸಾಟ್ನಿ ಮನುನ್, ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ, ಹೆ ಬಗುನ್ ಜೆಜುಚ್ಯಾ ಶಿಸಾನಿ ತೆಂಕಾ ಜೊರ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ಖರೆ ಜೆಜುನ್, ಪೊರಾಕ್ನಿ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್, ಅನಿ, ಪೊರಾಕ್ನಿ ಮಾಜೆಕ್ಡೆ ಯೆವ್ಕ್ ಸೊಡಾ, ತೆಂಕಾ ಅಡ್ವುನಕಾಶಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ದೆವಾಚೆ ರಾಜ್ ಅಸ್ಲ್ಯಾಕ್ನಿಚ್ ಸಮಂದ್ ಪಡಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ಯಾದ್ ಥವ್ನ್ ಘೆವಾ! ಜೆ ಕೊನ್ ಎಕಾ ಬಾರಿಕ್ಲ್ಯಾ ಪೊರಾ ಸರ್‍ಕ್ಯಾ ಬರ್‍ಯಾ ಮನಾನ್, ದೆವಾಚೆ ರಾಜ್ ಸ್ವಿಕಾರ್ ಕರಿನಾ, ತೊ,ಕನ್ನಾಚ್ ತ್ಯಾತುರ್ ಭುತ್ತುರ್ ಜಾಯ್ನಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ಜುದೆವಾಂಚ್ಯಾ ಎಕ್ಲ್ಯಾ ಮುಖಂಡಾನ್ ಜೆಜುಕ್, “ಬರ್‍ಯಾ ಗುರುಜಿ, ಮಾಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವುಚೆ ತರ್, ಮಿಯಾ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ, “ಮಾಕಾ ತಿಯಾ ಬರೊ ಮನುನ್ ಕಶ್ಯಾಕ್ ಮನ್ತೆ? ದೆವಾಕ್ ಎಕ್ಲ್ಯಾಕ್ ಸೊಡುನ್ ಕೊನ್ಬಿ ಬರೊ ನ್ಹಯ್”. ");
INSERT INTO kans_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“ತುಕಾ ತರ್ ಖಾಯ್ದೆ ಗೊತ್ತ್ ಹಾತ್, ವೆಭಿಚಾರ್ ಕರುನಕೊ, ಜಿವಾನಿ ಮಾರುನಕ್ಕೊ, ಚೊರುನಕ್ಕೊ, ಕೊನಾ ವರ್‍ತಿಬಿ ಝುಟೊ ಅಪ್ವಾದ್ ಘಾಲುನಕ್ಕೊ, ತುಜ್ಯಾ ಬಾಯ್ಕ್ ಅನಿ ಬಾಬಾಕ್ ಮರ್‍ಯಾದ್ ದಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾನ್ “ಮಿಯಾ ಬಾರಿಕ್ ಅಸ್ತಾನಾಚ್ಯಾನುಚ್ ಹಿ ಉಪಾದೆಸಾ ಪಾಳುನ್ಗೆತ್ ಹಾಂವ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುನ್ ತೆಕಾ “ಖಾಲಿ ಎಕ್ ಕಾಮ್ ತಿಯಾ ಕರ್‍ತಲೆ ಹುರ್‍ಲಾ; ತುಜೆ ಮನುನ್ ಹೊತ್ತೆ ಸಗ್ಳೆ ಇಕ್, ಅನಿ ಯೆಲ್ಲೆ ಪಯ್ಸೆ ಗರಿಬಾಕ್ನಿ ದಿ, ಅನಿ ಸರ್‍ಗಾರ್ ತುಕಾ ಸಾವ್ಕಾರ್ಕಿ ತಯಾರ್ ಕರುನ್ ಥವಲ್ಲಿ ರ್‍ಹಾತಾ, ಮಾನಾ ಯೆವ್ನ್ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾಕ್, ಲೈ ಬೆಜಾರ್ ಹೊಲೊ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ಲೈ ಸಾವ್ಕಾರ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ಜೆಜುನ್ ತೊ ಮಾನುಸ್ ಬೆಜಾರ್ ಹೊಲ್ಲೆ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ, “ಸಾವ್ಕಾರ್ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾಕ್, ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಗುಸ್ತಲೆ ಮಟ್ಲ್ಯಾರ್, ಕವ್ಡೆ ಕಸ್ಟ್ ಹಾಯ್! ");
INSERT INTO kans_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ಎಕ್ ಸುಯೆಚ್ಯಾ ಡೊಳ್ಯಾತ್ನಾ ಎಕ್ ಒಂಟೆ ಪಾರ್ ಹೊಯ್ಲ್, ಖರೆ ಎಕ್ ಸಾವ್ಕಾರ್ ಮಾನ್ಸಾಕ್ ತವ್ಡ್ಯಾ ಸಸಾರಾನ್ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಗುಸುಕ್ ಹೊಯ್ನಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ಲೊಕಾನಿ,“ತಸೆಜಾಲ್ಯಾರ್, ಕೊನ್ ಬಚಾವ್ ಹೊನಾರ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ತನ್ನಾ ಜೆಜುನ್,“ಮಾನ್ಸಾಕ್ ಸಾಧ್ಯ್ ನಾ, ಖರೆ,ದೆವಾಕ್ ಸಗ್ಳೆ ಕರುಕ್ ಸಾದ್ಯ್ ಹಾಯ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ತನ್ನಾ ಪೆದ್ರುನ್, “ಬಗ್, ಅಮಿ ತರ್ ಅಮ್ಚೆ ಘರ್ -ದಾರ್ ಸೊಡುನ್ ತುಜ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಹಾಂವ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ಹೊಯ್, ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಜೊ ಕೊನ್ ದೆವಾಚ್ಯಾ ರಾಜಾ ಸಾಟ್ನಿ ಘರ್ ಹೊಂವ್ದಿ, ಬಾಯ್ಕೊ ಹೊಂವ್ದಿ, ಭಾವಾಕ್ನಿ ಹೊಂವ್ದಿ, ಬಾಯ್-ಬಾಬಾಕ್ನಿ ಹೊಂವ್ದಿ, ಪೊರಾಕ್ನಿ ಹೊಂವ್ದಿ ಸೊಡ್ತಾ, ");
INSERT INTO kans_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ತೊ ತೆಚ್ಯಾ ಜಿವನಾತ್, ತೆಚೆನ್ಕಿ ಜಾಸ್ತಿಚೆ ಘೆತಾ. ಅನಿ ಆಕ್ರಿಚ್ಯಾ ಕಾಲಾತ್ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸ್ತಾನಾ ಝಿತ್ತೊ ರ್‍ಹಾತಲೆ ಭಾಗ್‍ಬಿ ತೆಕಾ ಗಾವ್ತಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ಜೆಜುನ್ ಬಾರಾ ಶಿಸಾಕ್ನಿ ಬಲ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ತೆಂಕಾ, “ಆಯ್ಕಾ! ಅತ್ತಾ ಅಮಿ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾಂವ್, ಥೈ ಪ್ರವಾದ್ಯಾನ್, ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಚ್ಯಾ ವಿಶಯಾತ್ ಲಿವಲ್ಲೆ ಸಗ್ಳೆ ಖರೆ ಹೊತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ತೆಕಾ ಥೈ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಹಾತಿತ್ ಧರುನ್ ದಿವ್ನ್ ಹೊತಾ. ತೆನಿ ತೆಕಾ ಎಡ್ಸಡ್ತಾತ್, ತೆಚಿ ಮರ್‍ಯಾದ್ ಕಾಡ್ತ್ಯಾತ್, ಅನಿ ತೆಕಾ ಥುಕ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ತೆನಿ ತೆಕಾ, ಬಾರ್‍ಕೊಲಾನಿ ಮಾರ್‍ತ್ಯಾತ್, ಅನಿ ತೆಕಾ ಜಿವಾನಿಚ್ ಮಾರ್‍ತ್ಯಾತ್. ಖರೆ ತಿನ್ ದಿಸಾಂಚ್ಯಾ ಮಾನಾ ತೊ ಝಿತ್ತೊ ಹೊತಾ, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ಖರೆ ಶಿಸಾಕ್ನಿ ತೆನಿ ಸಾಂಗಟಲ್ಲ್ಯಾ ಎಕ್‍ಬಿ ಗೊಸ್ಟಿಚೊ ಅರ್ತ್‍ ಹೊವ್ಕ್ ನಾ. ತ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚೊ ಅರ್ತ್‍ ತೆಂಚೆಕ್ನಾ ನಿಪ್ವುನ್ ಥವಲ್ಲೊ ಹೊತ್ತೊ, ಅನಿ ತೆಂಕಾ ಜೆಜು ಖಲ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲಾ ಮನುನ್ ಕಳುಕುಚ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ಜೆಜು ಜೆರಿಕೊ, ಮನ್ತಲ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ಥೈ ಎಕ್ ಕುಡ್ಡೊ ಭಿಕಾರಿ, ರಸ್ತ್ಯಾಚ್ಯಾ ದಂಡೆಕ್ ಭಿಕ್ ಮಾಗುನ್ಗೆತ್ ಬಸಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ಲೊಕಾಂಚೊ ತಾಂಡೊ ಥೈತ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಜಾತಲೆ ಆಯ್ಕುನ್ ತೆನಿ, “ಹೆ ಕಾಯ್ ಹೊವ್ಲಾ ಹಿತ್ತೆ” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ತೆನಿ ತೆಕಾ, “ನಜರೆತಾಚೊ ಜೆಜು ಹಿತ್ನಾ ದಾಟುನ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ತನ್ನಾ ತೊ, “ಜೆಜು! ದಾವಿದಾಚ್ಯಾ ಲೆಕಾ! ಮಾಜಿ ದಯಾ ಕರ್”, ಮನುನ್ ಬೊಬ್ ಮಾರುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ಇದ್ರಾಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ ಗಪ್‍ರಾಮ್ ಮನುನ್ ತೆಕಾ ಡೊಳೆ ಕಾಡ್ಲ್ಯಾನಿ, ಖರೆ ತೊ, ಅನಿ ಉಲ್ಲೆ ಜೊರಾನಿ,“ಜೆಜು! ದಾವಿದಾಚ್ಯಾ ಲೆಕಾ! ಮಾಜಿ ದಯಾ ಕರ್!” ಮನುನ್ ಬೊಬ್ ಮಾರುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ತಸೆಮನುನ್, ಜೆಜು ಇಬೆ ರ್‍ಹಾಲೊ, ಅನಿ “ತ್ಯಾ ಕುಡ್ಡ್ಯಾ ಮಾನ್ಸಾಕ್ ಮಾಜೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆವಾ” ಮಟ್ಲ್ಯಾನ್. ತೊ ಜಗ್ಗೊಳ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುನ್ ತೆಕಾ. ");
INSERT INTO kans_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ತುಜೆಸಾಟ್ನಿ ಮಿಯಾ ಕಾಯ್ ಕರುಚೆ ಮನುನ್ ತಿಯಾ ಮನ್ತೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ, “ಗುರುಜಿ, ಮಿಯಾ ಅನಿ ಪರ್ತುನ್ ಬಗುಕ್ ಪಾಜೆ!”ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ತನ್ನಾ ಜೆಜುನ್ “ತರ್ ಬಗ್! ತುಜ್ಯಾ ವಿಶ್ವಾಸಾನ್ ತುಕಾ ಬರೆ ಕರ್‍ಲ್ಯಾನ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೆಕಾ ದಿಸುಕ್‍ ಲಾಗ್ಲೆ, ಅನಿ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿವ್ನಗೆತ್ ತೊ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಗೆಲೊ. ಹೆ ಬಗಟಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ, ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ಜೆಜು ಜೆರಿಕೊತ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಜಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ಥೈ ಎಕ್ ಜಾಕ್ಕೆವ್ಸ್ ಮನ್ತಲೊ ತೆರ್‍ಗಿ ವಸುಲಿ ಕರ್‍ತಲ್ಯಾಂಚೊ ಮುಖಂಡ್ ಹೊತ್ತೊ, ತೊ ಲೈ ಸಾವ್ಕಾರ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ತೊ ಜೆಜು ಕೊನ್ ಕಾಯ್ ಮನುನ್ ಬಗುಕ್ ಖಟ್‍ಪಟಿ. ಖರೆ ತೊ ಗಿಡ್ಡೊ ಹೊತ್ತೊ, ತಸೆ ಮನುನ್ ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ದಾಟ್ನಿತ್ ತೆಕಾ ಜೆಜುಕ್ ಬಗುಕ್ ಗಾವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ತಸೆ ಮನುನ್ ತೊ ತ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಫಿಡೆ ಗೆಲೊ, ಅನಿ ಜೆಜುಕ್ ಬಗುಕ್ ಮನುನ್ ಎಕ್ ಅಂಜುರಾಚ್ಯಾ ಝಾಡಾ ವರ್‍ತಿ ಚಡ್ಲೊ. ಜೆಜು ತ್ಯಾ ಝಾಡಾಚ್ಯಾ ಬುಡ್ನಾಚ್ ಪಾರ್ ಹೊವ್ನ್ ಜಾನಾರ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ಜೆಜುನ್ ತ್ಯಾ ಜಾಗ್ಯಾರ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ, ತನ್ನಾ ವೈರ್ ಬಗಟ್ಲ್ಯಾನ್ ಅನಿ ಜಾಕ್ಕೆವ್ಸಾಕ್, ಜಾಕ್ಕೆವ್ಸ್, ಲಗ್ಗುನಾ ಖಾಲ್ತಿ ಉತ್ರುನ್ ‍ಯೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಆಜ್ ತುಜ್ಯಾ ಘರಾತ್ ಮಾಕಾ ವಸ್ತಿ ರ್‍ಹಾವ್ಕ್ ಪಾಜೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ತನ್ನಾ ಜಾಕ್ಕೆವ್ಸ್ ಲಗುಲಗುನಾ ಉತ್ರುನ್ ಯೆಲೊ ಅನಿ ಲೈ ಕುಶಿನ್ ತೆನಿ ಜೆಜುಕ್ ಸ್ವಾಗತ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ಹೆ ಬಗಟಲ್ಲೆ ಸಗ್ಳೆ ಜಾನಾ, “ಹ್ಯೊ ಮಾನುಸ್, ಎಕ್ ಪಾಪಿ ಮಾನ್ಸಾಚ್ಯಾ ಘರಾತ್ ಸೊಯ್ರೊ ಹೊವ್ನ್ ಗೆಲಾ” ಮನುನ್ ಪುಸ್ಪುಸುನ್ ಬೊಲುಕ್‍ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ಜಾಕ್ಕೆವ್ಸ್ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾಲೊ, ಅನಿ ಧನಿಯಾಕ್ “ಗುರುಜಿ ಆಯ್ಕಾ! ಮಾಜೆ ಮನುನ್ ಹೊತ್ತ್ಯಾತ್ಲೆ ಅರ್ದ್ಯಾಕ್ ಅರ್‍ದೆ, ಮಿಯಾ ಗರಿಬಾಕ್ನಿ ದಿತಾ, ಅನಿ ಕೊನಾಕ್-ಕೊನಾಕ್ ಮಿಯಾ ಪಸ್ವುಲಾ,ತೆಂಕಾ ತೆಚ್ಯಾ ಚಾರ್ ಪಟ್ ಪರ್ತುನ್ ದಿತಾ”, ಮಟ್ಲ್ಯಾನ್‍. ");
INSERT INTO kans_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ಜೆಜುನ್ ತೆಕಾ ಆಜ್ ಹ್ಯಾ ಘರಾತ್ ಸುಟ್ಕಾ ಯೆವ್ನ್ ಪಾವ್ಲಾ, ಅನಿ ಹ್ಯಾ ಮಾನ್ಸಾಕ್ ಬಿ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ಬಿ ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ಘರಾನ್ಯಾಚೊಚ್. ");
INSERT INTO kans_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಕಳ್ದುನ್ ಗೆಲ್ಲ್ಯಾಕ್ನಿ ಹುಡ್ಕುಕ್, ಅನಿ ಬಚಾವ್ ಕರುಕ್ ಮನುನ್ ಯೆಲಾ, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ಲೊಕಾ ಹೆ ಸಗ್ಳೆ ಆಯ್ಕುಲಾಗಲ್ಲಿ, ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಎಕ್ ಕಾನಿ ಸಾಂಗ್ಲ್ಯಾನ್ ಅತ್ತಾ ತೊ ಜೆರುಜಲೆಮಾಚ್ಯಾ ಎಗ್ದಮ್ ಜಗ್ಗೊಳ್ ಪಾವಲ್ಲೊ, ಅನಿ ತೆನಿ, ದೆವಾಚೆ ರಾಜ್ ಅತ್ತಾ ದಿಸುಕ್ ಜಗ್ಗೊಳ್ ಯೆಲಾ ಮನುನ್ ಯವ್ಜುನ್ ಘೆವ್ನ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ತಸೆ ಮನುನ್ ತೆನಿ ತೆಂಕಾ ಎಕ್ ಮೊಟ್ಯಾ ಗೌರವಾಚ್ಯಾ ಘರಾನ್ಯಾಚೊ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೊ ಅಪ್ನಿ ಘರಾತ್ ಯೆತಾನಾ ಎಕ್ ರಾಜಾ ಹೊವ್ನ್ ಯೆವ್ಚೆ ಮನುನ್ ಯೆವ್ಜುನ್ ಧುರ್‍ಲ್ಯಾ ದೆಸಾಕ್ ಜಾವ್‍ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ತೊ ಘರ್ ಸೊಡುನ್ ಜಾವ್ಚ್ಯಾ ಅದ್ದಿ, ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಧಾ ಜಾನಾ ಆಳಾಕ್ನಿ ಬಲ್ವುಲ್ಯಾನ್, ಅನಿ ಹರ್ ಎಕ್ಲ್ಯಾಕ್ ಎಕ್ಯೆಕ್, ಸೊನ್ಯಾಚ್ಯಾ ಪಯ್ಸಾಚಿ ಗಾಲಿ ದಿಲ್ಯಾನ್, ಅನಿ “ಮಿಯಾ ಯೆಯ್ ಪತರ್, ಹ್ಯಾ ಪೈಸ್ಯಾಚ್ಯಾ ವೈನಾ ತುಮ್ಕಾ ಕವ್ಡೆ ಕಮ್ವುಕ್ ಹೊತಾ, ತವ್ಡೆ ಕಮ್ವುನ್ ಘೆವ್ನ್ ರ್‍ಹಾವಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ಖರೆ ಅತ್ತಾ ತೆಚ್ಯಾ ಲೊಕಾನಿ ತೆಚ್ಯಾ ಫಾಟ್ನಾ ಹ್ಯೊ ರಾಜಾ ಅಮ್ಕಾ ನಕ್ಕೊ ಮನುನ್ ಸಾಂಗುಕ್ ಮನುನ್ ಎಕ್ಲ್ಯಾ ಖಬರ್ ಸಾಂಗ್ತಲ್ಯಾಕ್ ಸಾಂಗುನ್ ಧಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“ತೊ ಮಾನುಸ್ ಅಪ್ನಿ ರಾಜಾ ಹೊಲೊ! ಅನಿ ಫಾಟಿ ಪರ್ತುನ್ ಯೆಲೊ. ಎಗ್ದಮ್ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಆಳಾಕ್ನಿ ತಾಬೊಡ್ತೊಬ್ ಮಾಜ್ಯಾ ಇದ್ರಾಕ್ ಯೆವ್ಚೆ ಮನುನ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್. ತೆನಿ ಕವ್ಡೆ ಖಮ್ವುಲ್ಯಾನಾತ್ ಬಗುವಾ ಮನುನ್ ತೆನಿ ತೆಂಕಾ ಬಲ್ವುಲ್ಯಾನ್”. ");
INSERT INTO kans_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ಪಯ್ಲೆಚೊ ಆಳ್ ಯೆಲೊ, ಅನಿ “ಗುರುಜಿ, ತಿಯಾ ದಿಲ್ಲ್ಯಾ ಎಕ್ ಸೊನ್ಯಾಚ್ಯಾ ಪೈಸ್ಯಾ ವೈನಾ ಮಿಯಾ ಧಾ ಸೊನ್ಯಾಚೆ ಪೈಸ್ಯೆ ಖಮ್ವುಲಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ತನ್ನಾ ಧನಿಯಾನ್ ತೆಕಾ “ಶಬಾಶ್! ತಿಯಾ ಮಾಜೊ ಎಕ್ ಬರೊ ಆಳ್! ಅಜುನ್ ಸಗೊಳ್ ತಿಯಾ ಮಾಕಾ ವಿಶ್ವಾಸಾನ್ ಹಾಸ್, ತಸೆ ಮನುನ್ ಮಿಯಾ ತುಕಾ ಧಾ ಶಾರಾಂಚ್ಯಾ ವರ್‍ತಿ ಅದಿಕಾರ್ ದಿತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ದೊನ್ವೆಚೊ ಅಳ್ ಯೆಲೊ, ಅನಿ “ಗುರುಜಿ ತಿಯಾ ದಿಲ್ಲ್ಯಾ ಎಕ್ ಪೈಸ್ಯಾ ವೈನಾ ಮಿಯಾ, ಅನಿ ಪಾಂಚ್ ಪೈಸೆ ಖಮ್ವುಲಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ಹೆಚ್ಯೆಸಾಟಿ ತೆಕಾ ಧನಿಯಾನ್, “ತಿಯಾ ಪಾಚ್ ಶಾರಾಂಚ್ಯಾ ವರ್‍ತಿ ತುಜೊ ಅದಿಕಾರ್ ಚಾಲ್ವು”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ಅನಿ ಎಕ್ ಆಳ್ ಯೆಲೊ, ಅನಿ “ಗುರುಜಿ,ಅಬಕ್ ತಿಯಾ ದಿಲ್ಲೊ ಸೊನ್ಯಾಚೊ ಪೈಸೊ; ಮಿಯಾ ತೊ ಎಕ್ ಪಾಳಿತ್ ಗಾಟ್ ಮಾರುನ್ ನಿಪ್ವುನ್ ಥವಲ್ಲೊ”. ");
INSERT INTO kans_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","“ಮಾಕಾ ತುಜೆ ಭಿಂಯೆ ಕರ್‍ಲೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿಯಾ ಲೈ ಕಟೊರ್ ಮಾನುಸ್, ತುಜೆ ನ್ಹಯ್ ಮನುನ್ ಹೊತ್ತೆ ಸೈತ್ ತಿಯಾ ಕಾಡುನ್ ಘೆತೆ, ಅನಿ ಪೆರು ನಸಲ್ಲ್ಯಾಕ್ಡೆ ತಿಯಾ ಕಾತರ್‍ತೆ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ಧನಿಯಾನ್ ತೆಕಾ “ಬುರ್ಶ್ಯಾ ಆಳಾ ತಿಯಾ ಬುರ್ಸೊ ಮನುನ್ ದಾಕ್ವುಕ್ ಮಿಯಾ, ತಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚೊ ವಾಪರ್‍ತಾ.ಮಿಯಾ ಕಟೊರ್ ಮಾನುಸ್ ಮನುನ್ ತುಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಮಾಜೆ ನ್ಹಯ್ ಮನುನ್ ಹೊತ್ತೆ ಸೈತ್ ಮಿಯಾ ಘೆತಾ, ಅನಿ ಮಿಯಾ ಪೆರಿನಸಲ್ಲೆ ಪಿಕ್ಕ್ ಮಿಯಾ ಕಾತರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ಬರೆ, ತರ್, ಮಿಯಾ ದಿಲ್ಲೆ ಪೈಸೆ ತಿಯಾ ಬೆಂಕಾತ್ ಕಶ್ಯಾಕ್ ಥವ್ಕ್ ನೈ? ಮಿಯಾ ಪರತ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಬಡ್ಡಿ ಸಮೆತ್ ಮಿಯಾ ಘೈ ಹೊತ್ತೊ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“ತನ್ನಾ ತೆನಿ ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾಕ್ನಿ ತೊ ಸೊನ್ಯಾಚೊ ಪೈಸೊ ತೆಚ್ಯೆಕ್ನಾ ಕಾಡುನ್ ಘೆವಾ, ಅನಿ ಧಾ ಸೊನ್ಯಾಚೆ ಪೈಸೆ ಹೊತ್ತ್ಯಾಕ್ ದಿವಾ”. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ಖರೆ ತ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ “ಗುರುಜಿ,ಅದ್ದಿಚ್ ತೆಚೆಕ್ಡೆ ಧಾ ಸೊನ್ಯಾಚೆ ಪೈಸೆ ಹಾತ್ ಅನಿ!” ಮಟ್ಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ತನ್ನಾ ತೆನಿ “ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ” ಜೆ ಕೊನಾಕ್ಡೆ ಉಲ್ಲೆಸೆ ಹಾಯ್, ತೆಕಾ,ಅನಿ ಉಲ್ಲೆ ಜಾಸ್ತಿಚೆ ದಿವ್ನ್ ಹೊತಾ, ಅನಿ ಕೊನಾಕ್ಡೆ ಕಾಯ್ಬಿ ನಾ, ತೆಂಚೆಕ್ನಾ ಹೊತ್ತೆಬಿ ಉಲ್ಲೆಸೆ ಕಾಡುನ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ಅತ್ತಾ ಮಿಯಾ ರಾಜಾ ನಕ್ಕೊ ಮನುನ್ ಮಟಲ್ಲ್ಯಾ ಮಾಜ್ಯಾ ದುಸ್ಮಾನಾಕ್ನಿ, ಹಿತ್ತೆ ವೊಡುನ್ ಘೆವ್ನ್ ಯೆವಾ, ಅನಿ ಮಾಜ್ಯಾ ಇದ್ರಾಕುಚ್ ತೆಂಕಾ ಜಿವಾನಿ ಮಾರಾ! ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ಹೆ ಸಗ್ಳೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಜೆಜು ತೆಂಚ್ಯಾ ಫಿಡೆ-ಫಿಡೆ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್ಕಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ತೊ ಓಲಿವ್ ಮಡ್ಡಿವೈಲ್ಯಾ ಬೆತ್ಫಗೆ, ಅನಿ ಬೆಥನಿಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ದೊಗೆ ಜಾನಾ ಶಿಸಾಕ್ನಿ. ");
INSERT INTO kans_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ಥೈ ಫಿಡೆ ಹೊತ್ತ್ಯಾ ಗಾಂವಾತ್ ಜಾವಾ ತುಮಿ ತ್ಯಾ ಗಾಂವಾತ್ ಭುತ್ತುರ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ,ಥೈ ಅಜುನ್ ಪತರ್ ಕೊನ್ಬಿ ಬಸುನಸಲ್ಲೊ ಎಕ್ ಗಾಡ್ವಾಚೊ ಪೆಟೊ ಭಾಂದಲ್ಲೊ ತುಮ್ಕಾ ಗಾವ್ತಾ ತೆಕಾ ಸೊಡ್ವಾ, ಅನಿ ಹಿಕ್ಡಿ ಘೆವ್ನ್ ಯೆವಾ”. ");
INSERT INTO kans_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“ಕೊನ್ಬಿ ತುಮ್ಕಾ ತ್ಯಾ ಗಾಡ್ವಾಕ್ ಕಶ್ಯಾಕ್ ಸೊಡ್ವುಲ್ಯಾಸಿ ಮನುನ್ ಇಚಾರ್ಲ್ಯಾರ್, ತೆಕಾ ಧನಿಯಾಕ್ ತೆಚಿ ಗರಜ್ ಹಾಯ್ ಮನುನ್ ಸಾಂಗಾ” ಮನುನ್ ಸಾಂಗುನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ತೆನಿ ತೆಂಚಿ ವಾಟ್ ಧರುನ್ ಗೆಲ್ಯಾನಿ, ಅನಿ ಜೆಜುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ತೆಂಕಾ ಸಗ್ಳೆ ಗಾವ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ತೆನಿ ತ್ಯಾ ಗಾಡ್ವಾಕ್ ಸೊಡ್ವುತಾನಾ, ತ್ಯಾ ಗಾಡ್ವಾಚ್ಯಾ ಪೆಟ್ಯಾಚ್ಯಾ ಯಜಮಾನಾನ್ ತೆಂಕಾ “ತೆಕಾ ಕಶ್ಯಾಕ್ ಸೊಡ್ವುಲ್ಯಾಸಿ ತುಮಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ತೆನಿ ತೆಕಾ “ಗುರುಜಿಕ್ ತೆ ಪಾಜೆ ಹೊಲಾ”, ಮಟ್ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ಅನಿ ತ್ಯಾ ಗಾಡ್ವಾಚ್ಯಾ ಪೆಟ್ಯಾಕ್ ಜೆಜುಕ್ಡೆ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ ತನ್ನಾ ತೆನಿ ತೆಂಚೆ ಕಪ್ಡೆ ತ್ಯಾ ಜನಾವರಾಚ್ಯಾ ವರ್‍ತಿ ಟಾಕ್ಲ್ಯಾನಿ, ಅನಿ ಜೆಜುಕ್ ತೆಚೆ ವರ್‍ತಿ ಬಸುಕ್ ಮಜತ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ತೊ ತೆಚೆ ವರ್‍ತಿ ಬಸೂನ್ ಯೆತಾನಾ, ಲೊಕಾನಿ ಅಪ್ನಾಚೆ ಕಪ್ಡೆ ರಸ್ತ್ಯಾ ವರ್‍ತಿ ಹಾತರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ತೊ ಜೆರುಜಲೆಮಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ಮಟ್ಲ್ಯಾರ್ ಒಲಿವ್ ಮಡ್ದಿ ವೈನಾ ಉತರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾರ್, ಥೈ ರಸ್ತ್ಯಾಕ್ ಉತಾರ್ ಹೊತ್ತೆ, ಥೈ ತೆಚ್ಯಾ ಶಿಸಾಂಚೊ ಮೊಟೊ ತಾಂಡೊ ಅಪ್ನಿ ಬಗಟಲ್ಲ್ಯಾ ಮೊಟ್ಯಾ ಮೊಟ್ಯಾ ವಿಚಿತ್ರ್ ಕಾಮಾಂಚ್ಯಾಸಾಟ್ನಿ ದೆವಾಕ್ ಮೊಟ್ಯಾನ್ ಬೊಬ್ ಮಾರುನ್ ಧನ್ಯವಾದ್ ದಿವ್ಕ್ ಲಾಗಲ್ಲೊ, ಅನಿ ಹೊಗ್ಳುಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ಸಗ್ಳಿ ಲೊಕಾ , ಸರ್ವೆಸ್ವರಾಚ್ಯಾ ನಾವಾನ್ ಯೆತಲ್ಯಾ ರಾಜಾಕ್ ದೆವ್ ಆಶಿರ್ವಾದ್ ದಿಂವ್ದಿ! ಸರ್‍ಗಾ ವರ್‍ತಿ ಶಾಂತಿ, ಅನಿ ದೆವಾಕ್ ಮಹಿಮಾ ಹೊಂವ್ದಿ! ಮನುಕ್‍ಲಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ತನ್ನಾ ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ಹೊತ್ತ್ಯಾ, ಉಲ್ಲ್ಯಾಸ್ಯಾ ಫಾರಿಜೆವಾನಿ ಜೆಜುಕ್ “ಗುರುಜಿ, ತುಜ್ಯಾ ಶಿಸಾಕ್ನಿ ಗಪ್ ರ್‍ಹಾವಾ, ಮನುನ್ ಸಾಂಗ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ “ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ಜರ್ ಹ್ಯಾ ಲೊಕಾನಿ ವದರ್‍ತಲೆ ಬಂದ್ ಕರ್ಲ್ಯಾರ್ ಗುಂಡೆ ಬೊಬ್ ಮಾರುಕ್‍ ಲಾಗ್ತ್ಯಾತ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ಜೆಜು ಜೆರುಜಲೆಮ್ ಶಾರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆಲೊ, ಅನಿ ತ್ಯಾ ಶಾರಾಕ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ತೊ ತ್ಯಾ ಶಾರಾಸಾಟಿ ರಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ಅಶೆ ಮನುಕ್‍ಲಾಲೊ ಆಜ್ ತಿಯಾ ತರ್ಬಿ ಸಮಾದಾನ್ ಪಾಜೆ ಮನುನ್ ಕಳ್ವುನ್ ಘೆಟಲ್ಲೆ ರ್‍ಹಾಲ್ಯಾರ್, ಕವ್ಡೆ ಬರೆ ಹೊಯ್ ಹೊತ್ತೆ! ಖರೆ ಅತ್ತಾ ತೆ ತುಕಾ ದಿಸಿನಾ! ");
INSERT INTO kans_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಎಕ್ ಎಳ್ ಯೆತಾ ತುಜೆ ದುಸ್ಮಾನ್ ತುಜ್ಯಾ ಭೊತ್ಯಾನಿ ಯೆವ್ನ್ ಅಡ್ಗೊಲ್ ಘಾಲ್ತ್ಯಾತ್, ಅನಿ ತುಜಿ ರಸ್ತೆ ಸಗ್ಳೆ ಬಂದ್ ಕರ್‍ತ್ಯಾತ್, ಅನಿ ಸಗ್ಳ್ಯಾಕ್ನಾ ತುಕಾ ಬಂದ್ ಕರುನ್ ಸೊಡ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ಅನಿ ತೆನಿ ತುಜ್ಯಾ ಭುತ್ತುರ್ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ನಾಸ್ ಕರ್‍ತ್ಯಾತ್; ತುಜ್ಯಾ ಭೊತ್ಯಾನ್ಲ್ಯಾ ಭಿತ್ತಿಚೊ ಎಕ್ ಗುಂಡ್ಯಾರ್ ಗುಂಡೊ ಸೈತ್ ಥೈನಸ್ತಾನಾ ಕೊಸ್ಳುನ್ ಘಾಲ್ತ್ಯಾತ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ದೆವ್ ತುಕಾ ಬಚಾವ್ ಕರುಕ್ ಮನುನ್ ಯೆಲ್ಲೊ ಎಳ್ ತಿಯಾ ವಳ್ಕುಕ್‍ ನೈ! ");
INSERT INTO kans_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ಮಾನಾ ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಗೆಲೊ, ಅನಿ ಯಾಪಾರ್ ಕರ್‍ತಲ್ಯಾಕ್ನಿ ಭಾಯ್ರ್ ಘಾಲುಕ್‍ಲಾಲೊ ");
INSERT INTO kans_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ತೆನಿ ತೆಂಕಾ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲೆ ಹಾಯ್, ದೆವ್ ಮನ್ತಾ “ಮಾಜಿ ದೆವಾಚಿ ಗುಡಿ ಎಕ್ ಮಾಗ್ನಿ ಕರ್‍ತಲೆ ಘರ್ ಹೊತಾ; ಖರೆ ತುಮಿ ತೆ, ಚೊರಾನಿ ನಿಪ್ತಲೊ ಜಾಗೊ ಕರುನ್ ಥವ್ಲ್ಯಾಶಿ!” ಮನುನ್. ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ಸದ್ದಿಚ್ ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುಲಾಗಲ್ಲೊ, ಮುಖ್ಯ ಯಾಜಕಾ, ಖಾಯ್ದೆ ಶಿಕ್ವುತಲಿ ಲೊಕಾ , ಅನಿ ಲೊಕಾಂಚಿ ವ್ಹಡಿಲಾ ಜೆಜುಕ್ ಜಿವಾನಿ ಮಾರ್‍ತಲಿ ಯವ್ಜನ್ ಕರುಕ್ ಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ಖರೆ ತೆಂಕಾ ಜೆಜುಕ್ ಜಿವಾನಿ ಮಾರ್‍ತಲಿ ವಾಟ್ ಗಾವುಕುಚ್‍ನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್,ಲೊಕಾ ಎಕ್ ಶಬದ್ ಸೈತ್ ಚುಕಿನಸ್ತಾನಾ, ಬರೆ ಕರುನ್ ಜೆಜು ಸಾಂಗ್ತಲೆ ಆಯ್ಕುಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ಎಕ್ ದಿಸ್ ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುಲಾಗಲ್ಲೊ, ಅನಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ, ತನ್ನಾ , ಮುಖ್ಯ ಯಾಜಕಾ, ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲಿ ಲೊಕಾ, ಜಾನ್ತ್ಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಳುನ್ ಯೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ಅನಿ “ಹೆ ಸಗ್ಳೆ ಕರುಕ್ ತುಕಾ ಕಸ್ಲೊ ಅದಿಕಾರ್ ಹಾಯ್? ಹೆ ಕರುಕ್ ತುಕಾ ಕೊನ್ ಅದಿಕಾರ್ ದಿಲೊ? ಸಾಂಗ್ ಅಮ್ಕಾ”, ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ಜೆಜುನ್ ತೆಂಕಾ “ಮಿಯಾ ತುಮ್ಕಾ ಎಕ್ ಸವಾಲ್ ಇಚಾರ್ತಾ, ಸಾಂಗಾ ಮಾಕಾ ");
INSERT INTO kans_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ಜುವಾಂವಾಕ್ ಬಾಲ್ತಿಮ್ ದಿತಲೊ ಅದಿಕಾರ್ ದೆವಾಕ್ನಾ ಯೆಲ್ಲೊ ಕಾಯ್ ಮಾನ್ಸಾಕ್ನಾ ಯೆಲ್ಲೊ?” ");
INSERT INTO kans_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ತನ್ನಾ ತೆನಿ ಅಪ್ನಾ-ಅಪ್ನಾ ಮದ್ದಿ “ಅಮಿ ಕಾಯ್ ಸಾಂಗುವಾ? ಅಮಿ ದೆವಾಕ್ನಾ ಮಟ್ಲಾಂವ್ ತರ್, ತೊ ಅಮ್ಕಾ, ತುಮಿ ಕಶ್ಯಾಕ್ ಜುವಾಂವಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಕರುಕ್ನ್ಯಾಶಿ? ಮನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ಅನಿ ಅಮಿ ಮಾನ್ಸಾಕ್ನಾ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾರ್, ಹಿತ್ತೆ ಹೊತ್ತಿ ಸಗ್ಳಿ ಲೊಕಾ ಅಮ್ಕಾ ಗುಂಡ್ಯಾನಿ ಮಾರ್‍ತ್ಯಾತ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಸಗ್ಳೆ ತೊ ಎಕ್ ಪ್ರವಾದಿ, ಮನುನ್ ಮಾನ್ತ್ಯಾತ್” ಮನುನ್ ಬೊಲುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ತಸೆಮನುನ್ ತೆನಿ “ಕೊನಾಕ್ನಾ ಯೆಲೊ ,ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ನಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ತಸೆ ಜಾಲ್ಯಾರ್ ಮಿಯಾಬಿ ಹೆ, ಸಗ್ಳೆ ಕಸ್ಲ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಮಿಯಾ ಕರುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಸಾಂಗಿನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ತನ್ನಾ ಜೆಜುನ್ ಲೊಕಾಕ್ನಿ ಹಿ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್: ಎಗ್ದಾ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೆನಿ ಎಕ್ ದರಾಕ್ಷಿಚೊ ಮಳೊ ಲಾವಲ್ಲ್ಯಾನ್,ಗುತ್ಕ್ಯಾನಿ ದಿಲ್ಯಾನ್ ಮಾನಾ ತೊ ಲೈ ದಿಸಾಸಾಟಿ ಘರ್ ಸೊಡುನ್ ಧುರ್‍ಲ್ಯಾ ಗಾಂವಾಕ್ ಗೆಲೊ, ");
INSERT INTO kans_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ದರಾಕ್ಷಿ ಗೊಳಾ ಕರ್‍ತಲ್ಲ್ಯಾ ಎಳಾರ್, ತ್ಯಾ ಮಾನ್ಸಾನ್ ಅಪ್ನಾಚೊ ಸುಗ್ಗಿಚೊ ವಾಟೊ ಘೆವ್ನ್ ‍ಯೆ ಮನುನ್ ಅಪ್ನಾಚ್ಯಾ ಎಕ್ಲ್ಯಾ ಗುಲಾಮಾಕ್ ಮಳ್ಯಾಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನ್, ಖರೆ ತ್ಯಾ ಗುತ್ಕೆ ಧರಲ್ಲ್ಯಾನಿ ತ್ಯಾ ಗುಲಾಮಾಕ್ ಮಾರ್ ಘಾಟ್ಲ್ಯಾನಿ, ಅನಿ ಖಾಲಿ ಹಾತಾನಿ ಪರ್ತುನ್ ಧಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ತಸೆ ಮನುನ್ ತೆನಿ, ಅನಿಎಕ್ ಆಳಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್; ಖರೆ ಗುತ್ಕೆ ಧರಲ್ಲ್ಯಾನಿ ತೆಕಾ ಧರುನ್ ಮಾರ್ ಘಾಟ್ಲ್ಯಾನಿ, ಅನಿ ತೆಚಿ ಮರ್‍ಯಾದ್ ಕಾಡ್ಲ್ಯಾನಿ. ಅನಿ ಖಾಲಿ ಹಾತಾನಿ ಪರ್ತುನ್ ಧಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ಮಾನಾ ತೆನಿ ತಿನ್ವೆಚ್ಯಾ ಅನಿ ಎಕ್‍ಬಿ ಆಳಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್, ತ್ಯಾ ಗುತ್ಕೆ ಧರಲ್ಲ್ಯಾನಿ ತೆಕಾಬಿ. ಬರಬ್ಬರ್ ದುಕ್ವುಲ್ಯಾನಿ, ಅನಿ ಮಳ್ಯಾಚ್ಯಾ ಭಾಯ್ರ್ ಟಾಕ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ತನ್ನಾ ತೊ ದರಾಕ್ಷಿಚ್ಯಾ ಮಳ್ಯಾಚೊ ಮಾಲಿಕ್ “ಮಿಯಾ ಕಾಯ್ ಕರು? ಮಿಯಾ ಮಾಜ್ಯಾ ಅಪುರ್‍ಬಾಯೆಚ್ಯಾ ಎಕ್ಲ್ಯಾಚ್ ಲೆಕಾಕ್ ಧಾಡುನ್ ದಿತಾ, ತೆಚೆ ತೆನಿ ಆಯಿಕ್ತಿಲ್!” ಮಟ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ಖರೆ, ತ್ಯಾ ಲೆಕಾಕ್ ಬಗಟಲ್ಲೆಚ್ ತೆ ಗುತ್ಕ್ಯಾಚೆ ಎಕಾಮೆಕಾಕ್ನಿ “ಹ್ಯೊ ಹ್ಯಾ ಮಳ್ಯಾಚ್ಯಾ ಮಾಲ್ಕಾಚೊ ಲೆಕ್, ಯೆವಾ ಹೆಕಾ ಜಿವಾನಿಚ್ ಮಾರುಂವ್ವಾ, ಅನಿ ಮಾನಾ ಹಿ ಸಗ್ಳಿ ಅಸ್ತಿ ಅಮ್ಕಾಚ್ ಹೊತಾ” ಮನುಕ್‍ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ಅಶೆ ತೆನಿ ತೆಕಾ ದರಾಕ್ಷಿಚ್ಯಾ ಮಳ್ಯಾತ್ನಾ ಭಾಯ್ರ್ ನ್ಹೆವ್ನ್ ಜಿವಾನಿಚ್ ಮಾರುನ್ ಟಾಕ್ಲ್ಯಾನಿ ತನ್ನಾ ಜೆಜುನ್ “ತನ್ನಾ ತೊ ತ್ಯಾ ದರಾಕ್ಷಿಚ್ಯಾ ಮಳ್ಯಾಚೊ ಮಾಲಿಕ್, ಕಾಯ್ ಕರ್‍ತಾ ಮನುನ್ ತುಮಿ ಮನ್ತ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ತೊ ಯೆತಾ, ಅನಿ ತ್ಯಾ ಮಾನ್ಸಾಕ್ನಿ ಜಿವಾನಿಚ್ ಮಾರ್‍ತಾ, ಅನಿ ಮಳೊ ದುಸ್ರ್ಯಾಕ್ನಿ ಗುತ್ಕ್ಯಾಕ್ ದಿತಾ. ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಲೊಕಾ “ನಾ ತಸೆ ಹೊವ್ಕ್ ಸಾದ್ಯ್ ನಾ!” ಮನುಕ್‍ಲಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ಜೆಜುನ್ ತೆಂಚೆಕ್ಡೆ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ತೆಂಕಾ, ಭಾಂದ್ತಲ್ಯಾನಿ ನಕ್ಕೊ ಮನುನ್ ಟಾಕಲ್ಲೊ ಗುಂಡೊಚ್, ಸಗ್ಳ್ಯಾನ್ಕಿ ಗರ್ಜೆಚೊ ಗುಂಡೊ ಹೊಲೊ. ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಸಾಂಗಲ್ಲ್ಯಾಚೊ ಅರ್ತ್‍ ಕಾಯ್ ತರ್? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“ತ್ಯಾ ಗುಂಡ್ಯಾ ವರ್‍ತಿ ಪಡಲ್ಲೊ ಹರ್ ಎಕ್ಲೊ ತುಕ್ಡೆ-ತುಕ್ಡೆ ಹೊತಾ; ಅನಿ ತೊ ಗುಂಡೊಚ್ ಕೊನಾ ವರ್‍ತಿ ತರ್ ಪಡಿಲ್ ತರ್, ತೊ ತೆಕಾ ಬುಕ್ನಾಚ್ ಕರುನ್ ಟಾಕ್ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾ ಲೊಕಾನಿ, ಅನಿ ಮುಖ್ಯ ಯಾಜಕಾನಿ, ಜೆಜುಕ್ ತ್ಯಾಚ್ ಜಾಗ್ಯಾರ್ ಧರುಚೆ ಮನುನ್ ಖಟ್ಪಟ್ಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಹಿ ಕಾನಿ ತೆನಿ ತೆಂಚ್ಯಾಚ್ ವೈಲಿ ಸಾಂಗ್ಲ್ಯಾನ್ ಮನುನ್ ತೆಂಕಾ ಕಳಲ್ಲೆ, ಖರೆ ತೆಂಚೆನ್ ಹೊವ್ಕ್ ನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಲೊಕಾಕ್ನಿ ಭಿಂಯಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ತಸೆ ಮನುನ್ ತೆನಿ ಬರ್‍ಯಾ ಮಾನ್ಸಾಂಚ್ಯಾ ಸರ್ಕೆ ಕರುನ್ ದಾಕ್ವುತಲ್ಯಾ ಉಲ್ಲ್ಯಾಸ್ಯಾ ಮಾನ್ಸಾಕ್ನಿ ಪಯ್ಸೆ ದಿವ್ನ್ ತಯಾರ್ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ಜೆಜುಕ್ ಇಚಾರುಕ್‍ಲಾವುನ್, ಗೊಂದ್ಳುನ್ ಘಾಲುನ್ ಚುಕ್ ಕರಿ ಸರ್ಕೆ ಕರುಕ್ ‍ಲಾವುನ್, ಮಾನಾ ರೊಮಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಚ್ಯಾ ಹಾತಿತ್ ತೆಕಾ ಧರುನ್ ದಿ ಸರ್ಕೆ ಕರುಚೆ ಮನುನ್ ಅವ್ಕಾಸ್ ಹುಡ್ಕುಕ್ ಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ತ್ಯಾ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾನಿ, ಅನಿ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಶಿಕ್ವುನ್ ಧಾಡಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಜೆಜುಕ್‍ ಗುರುಜಿ, ತಿಯಾ ಸಾಂಗ್ತಲೆ, ಅನಿ ತಿಯಾ ಸಿಕ್ವುತಲೆ ಸಗ್ಳೆ ಬರಬ್ಬರ್ ಹಾಯ್, ತೆ ಅಮ್ಕಾ ಗೊತ್ತ್ ಅಸಲ್ಲೆ ವಿಶಯ್, ಅನಿ ತಿಯಾ ಕೊನಾಚಿ ಪದ್ವಿ-ಗಿದ್ವಿ ಬಗಿನಸ್ತಾನಾ ದೆವಾಚ್ಯಾ ಯವ್ಜನಿ ಸರ್ಕೆ ಕಾಯ್‍ ಹಾಯ್ ತೆಚ್ ಅಮ್ಕಾ ಶಿಕ್ವುತೆ, ");
INSERT INTO kans_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ಅಮಿ ರೊಮಾಚ್ಯಾ ಚಕ್ರವರ್ತಿಕ್ ತೆರ್‍ಗಿ ದಿತಲೆ, ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್, ಸಮಾ ಕಾಯ್ ಚುಕ್? ಮನುನ್ ಅಮ್ಕಾ ಸಾಂಗ್ ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ಖರೆ ಜೆಜುಕ್ ಹೆನಿ ಕಾಯ್ ಖೆಳ್ ಖೆಳುಲ್ಯಾತ್ ಮನುನ್ ಕಳ್ಳೆ , ತಸೆ ಮನುನ್ ತೆಂಕಾ ತೆನಿ, ");
INSERT INTO kans_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ಮಾಕಾ ಎಕ್ ಚಾಂದಿಚೊ ಪೈಸೊ ದಾಕ್ವಾ ಹೆಚ್ಯಾ ವರ್‍ತಿ ಹೊತ್ತೆ ಚಿತ್ತರ್, ಅನಿ ನಾವ್ ಕೊನಾಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತೆನಿ ಚಕ್ರವರ್ತಿಚೆ ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಬರೆ ತರ್ ಜೆ ಕಾಯ್ ಚಕ್ರವರ್ತಿಕ್ ಸಮಂದ್ ಪಡಲ್ಲೆ ಹಾಯ್ ತೆ ಚಕ್ರವರ್ತಿಕ್ ದಿವಾ, ಅನಿ ಜೆ ಕಾಯ್ ದೆವಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೆ ಹಾಯ್ ತೆ ದೆವಾಕ್ ದಿವಾ ಮಟ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ಥೈ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ತೆನಿ ತೆಕಾ ಕಸ್ಲ್ಯಾಬಿ ಚುಕಿತ್ ಸಿರ್‍ಕುಕ್ ಹೊವ್ಕ್ ನಾ, ತಸೆ ಮನುನ್ ಥಂಡ್ ಪಡ್ಲ್ಯಾನಿ. ಅನಿ ಜೆಜುನ್ ಸಾಂಗಲ್ಲೊ ಜಬಾಬ್ ಆಯ್ಕುನ್ ಅಜಾಪ್ ಹೊಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ಮಾನಾ ಮರಲ್ಲಿ ಲೊಕಾ, ಅನಿ ಝಿತ್ತಿ ಹೊವ್ನ್ ಉಟಿನ್ಯಾತ್ ಮನುನ್ ಮನ್ತಲಿ ಉಲ್ಲಿಸಿ ಸಾದುಸೆವಾ, ಜೆಜುಕ್ಡೆ ಯೆಲಿ, ಅನಿ, ");
INSERT INTO kans_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ ಗುರುಜಿ ಮೊಯ್ಜೆನ್ ಅಮ್ಚ್ಯಾಸಾಟ್ನಿ ಎಕ್ ಘೊಮಾನುಸ್ ನಗಿನ್ ಕರುನ್ ಘೆತಾ, ಅನಿ ಪೊರಾ ನಸ್ತಾನಾ ಮರ್ಲ್ಯಾರ್, ತ್ಯಾ ಮರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಭಾವಾನ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನಿಕ್ಡೆ ಲಗಿನ್ ಹೊವ್ಚೆ, ಅನಿ ತೆಂಕಾ ಹೊಲ್ಲಿ ಪೊರಾ ತ್ಯಾ ಮರಲ್ಲ್ಯಾ ಭಾವಾಚಿ ಪೊರಾ ಮನುನ್ ಘೆವ್ಚೆ” ಮನುನ್ ಎಕ್ ಖಾಯ್ದೊ ಲಿವ್ಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ಎಗ್ದಾ ಸತ್ ಜಾನಾ ಭಾವಾ ಹೊತ್ತಿ; ತೆಂಚ್ಯಾತ್ಲೊ ಎಗ್ದಮ್ ಥೊರ್‍ಲೊ ನಗಿನ್ ಹೊಲೊ, ಅನಿ ಪೊರಾ ನಸ್ತಾನಾಚ್ ಮರ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ಮಾನಾ ದೊನ್ವೆಚೊ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ಡೆ ಲಗಿನ್ ಹೊಲೊ ");
INSERT INTO kans_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ಮಾನಾ ತಿನ್ವೆಚೊ, ಅಶೆ ಸತ್‍ಜಾನಾಬಿ ಪೊರಾ ನಸ್ತಾನಾಚ್ ಮರ್‍ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ಆಕ್ರಿಕ್, ತಿ ಬಾಯ್ಕೊಮನುಸ್‍ಬಿ ಮರ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ತರ್ ಅತ್ತಾ, “ಮರಲ್ಲೆ ಸಗ್ಳೆ ಜಾನಾ ಝಿತ್ತೆ ಹೊವ್ನ್ ಉಟುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತಿ ಬಾಯ್ಕೊಮನುಸ್ ಕೊನಾಚಿ ಬಾಯ್ಕೊ ಹೊತಾ? ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸತ್‍ಜಾನಾಬಿ ತಿಚೆಕ್ಡೆ ಲಗಿನ್ ಹೊಲ್ಲೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ಜೆಜುನ್ ತೆಂಕಾ “ಹ್ಯಾ ಜಲ್ಮಾತ್ ಘೊಮನ್ಸಾ, ಅನಿ ಬಾಯ್ಕೊಮನ್ಸಾ ನಗಿನ್ ಹೊತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ಖರೆ ,ಜಿ ಘೊಮನ್ಸಾ, ಅನಿ ಬಾಯ್ಕೊಮನ್ಸಾ ಮರಲ್ಲ್ಯಾತ್ನಾ ಝಿತ್ತೆ ಹೊವ್ಕ್ ಯೊಗ್ಯ್ ಹಾತ್, ಅನಿ ಝಿತ್ತೆ ಹೊವ್ನ್ ಉಟ್ತ್ಯಾತ್ ತ್ಯಾ ಎಳಾರ್ ತೆನಿ ನಗಿನ್ ಕರುನ್ ಘೆಯ್‌ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ತೆನಿ ದೆವಾಚ್ಯಾ ದುತಾಂಚ್ಯಾ ಸರ್ಕೆ ಹೊತ್ಯಾತ್, ಅನಿ ತೆನಿ ಕನ್ನಾಬಿ ಮರಿನ್ಯಾತ್ ತೆನಿ ದೆವಾಚಿ ಪೊರಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆನಿ ಮರುನ್ ಮರ್‍ನಾತ್ನಾ,ಅನಿ ಪರ್ತುನ್ ಝಿತ್ತೆ ಹೊಲ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ಮೊಯ್ಜೆ ಮರಲ್ಲಿ ಮಾನ್ಸಾ ಪರ್ತುನ್ ಝಿತ್ತಿ ಹೊತ್ಯಾತ್ ಮನುನ್ ಬರಬ್ಬರ್ ದಾಕ್ವುನ್ ದಿತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಜಳ್ತಲ್ಯಾ ಝಿಳಿಚ್ಯಾ ವಿಶಯಾತ್ ಬಗ್ತಾನಾ, ಥೈ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್, ಅಬ್ರಾಹಾಮಾಚೊ ದೆವ್ ಇಸಾಕಾಚೊ ದೆವ್, ಅನಿ ಜಾಕೊಬಾಚೊ ದೆವ್” ಮನುನ್ ಮನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ಝಿತ್ತ್ಯಾಂಚೊ ದೆವ್ ತೊ, ಮರಲ್ಲ್ಯಾಂಚೊ ನ್ಹಯ್ , ತೆಕಾ ಸಗ್ಳೆ ಜಾನಾ ಝಿತ್ತೆಚ್ ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ಉಲ್ಲ್ಯಾಸ್ಯಾ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾ ಲೊಕಾನಿ “ಬರಬ್ಬರ್ ಜಬಾಬ್ ದಿಲೆ, ಗುರುಜಿ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ತೆಂಕಾ, ಅನಿ ಜಾಸ್ತಿಚೆ ಸವಾಲಾ ಇಚಾರುಕ್ ಧೈರೊ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ಜೆಜುನ್ ತೆಂಕಾ “ಮೆಸ್ಸಿಯಾ ದಾವಿದಾಚ್ಯಾ ಘರಾನ್ಯಾಚೊ ಕಸೊ ಹೊವ್ಕ್ ಹೊತಾ?” ");
INSERT INTO kans_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ಕಶ್ಯಾಕ್ ದಾವಿದಾನ್ ಅಪ್ನಿಚ್ ಕಿರ್ತನಾಂಚ್ಯಾ ಪುಸ್ತಕಾತ್ ಸಾಂಗಲ್ಲೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್ “ಧನಿಯಾನ್, ಮಾಜ್ಯಾ ಧನಿಯಾಕ್! ತಿಯಾ ಮಾಜ್ಯಾ ಉಜ್ವ್ಯಾಕ್ ಬಸ್ ");
INSERT INTO kans_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ತುಜ್ಯಾ ದುಸ್ಮಾನಾಕ್ನಿ ತುಜ್ಯಾ ಪಾಯಾಚ್ಯಾ ಬುಡ್ಲಿ ಮ್ಹನಿ ಕರಿಪತರ್”. ");
INSERT INTO kans_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ದಾವಿದಾನುಚ್ ತೆಕಾ “ಧನಿ, ಮನುನ್ ಬಲ್ವುಲ್ಯಾರ್, ಮೆಸ್ಸಿಯಾ” ತೆಚ್ಯಾ ಘರಾನ್ಯಾಚೊ ಮನುನ್ ಕಶೆ ಸಾಂಗುಕ್ ಹೊತಾ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ಸಗ್ಳಿ ಲೊಕಾ ಆಯ್ಕುನ್ಗೆತ್ ರ್‍ಹಾತಾನಾಚ್, ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ");
INSERT INTO kans_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಉಶಾರ್ಕಿನ್ ರಾವಾ, ಲಾಂಬ್-ಲಾಂಬ್ಲ್ಯಾ ಅಂಗಿಯಾ ನೆಸುನ್ ಫಿರುಕ್, ಅನಿ ಬಾಜಾರಾತ್ನಿ ಲೊಕಾನಿಕ್ನಾ ನಮಸ್ಕಾರ್ ಕರುನ್ ಘೆವ್ಕ್ ತೆಂಕಾ ಲೈ ಕುಶಿ. ಸಿನಾಗೊಗಾತ್ನಿ ತೆಂಕಾ ಬರೆ-ಬರೆ ಜಾಗೆ ಪಾಜೆ, ಅನಿ ಸನಾಚ್ಯಾ ಜೆವ್ನಾಕ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾಬಿ ಬರೆ-ಬರೆ ಜಾಗೆ ತೆಂಕಾ ಪಾಜೆ; ");
INSERT INTO kans_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ತೆನಿ ಲಜಿನಸ್ತಾನಾ ಘೊಮರಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾಂಚೊ ಫಾಯ್ದೊ ಕಾಡುನ್ ಘೆವ್ನ್ ತೆಂಚಿ ಘರಾ ಲುಟ್ತ್ಯಾತ್, ಅನಿ ಲಾಂಬ್-ಲಾಂಬ್ ಮಾಗ್ನಿಯಾ ಕರುನ್ ಅಪ್ನಿ ಬರೆ ಮನುನ್ ದಾಕ್ವುತ್ಯಾತ್! ತೆಂಕಾ ಎಗ್ದಮ್ ಕಟಿನ್ ಶಿಕ್ಷಾ ರ್‍ಹಾತಾ!” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್‍. ");
INSERT INTO kans_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ಜೆಜುನ್ ಭೊತ್ಯಾನಿ ಬಗಟ್ಲ್ಯಾನ್, ತನ್ನಾ ಸಾವ್ಕಾರ್ ಲೊಕಾ ಅಪ್ನಾಚಿ ಕಾನಿಕ್ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ಕಾನಿಕಾಚ್ಯಾ ಡಬ್ಬ್ಯಾತ್ ಘಾಲುಲಾಗಲ್ಲಿ . ");
INSERT INTO kans_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ಅನಿ ಎಕ್ ಗರಿಬ್‍ ಘೊಮರಲ್ಲಿ ಬಾಯ್ಕೊ ಮಾನುಸ್ ಅಪ್ನಾಕ್ಡೆ ಹೊತ್ತೆ ದೊನ್ ಬಾರಿಕ್ಲೆ ತಾಂಬ್ಯಾಚೆ ಪೈಸೆ ಕಾನಿಕಾಚ್ಯಾ ಡಬ್ಬ್ಯಾತ್, ಘಾಲ್ತಲೆಬಿ ಜೆಜುನ್ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ತನ್ನಾ ತೆನಿ “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ, ಹ್ಯಾ ಗರಿಬ್ ಘೊಮರಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್,ಸಗ್ಳ್ಯಾಂಚ್ಯಾನ್ಕಿ ಜಾಸ್ತಿ ಕಾನಿಕಾಚ್ಯಾ ಡಬ್ಬ್ಯಾತ್ ಘಾಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ಹುರಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾನಿ ಅಪ್ನಾಕ್ ಫಿರೆ ಹೊವ್ನ್ ಹುರಲ್ಲೆ ಲೈ ಲೈ ಪೈಸೆ ಘಾಟ್ಲ್ಯಾನಿ, ಖರೆ ಹಿನಿ ಅಪ್ನಾಚ್ಯಾ ಗರಿಬ್ಕಿತ್ , ಅಪ್ನಾಚೆ ಜಿವನ್ ಚಾಲ್ವುಕ್ ಮನುನ್ ಹೊತ್ತೆ ದೊನುಚ್ ದೊನ್ ಪಯ್ಸೆಬಿ ಅಪ್ನಾಕ್ ಕಾಯ್ಬಿ ಥವ್ನ್ ಘೆಯ್ನಸ್ತಾನಾ, ತೆನಿ ದಿಲಿನ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ಎಕ್ ಉಲ್ಲಿ ಶಿಸಾ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲಾಗಲ್ಲಿ, ಬರ್‍ಯಾ-ಬರ್‍ಯಾ ಗುಂಡ್ಯಾನ್ ಭಾಂದಲ್ಲೆ ಹೆ ಭಾಂದಾಪ್ ಕವ್ಡೆ ಬರೆ ದಿಸ್ತಾ, ಅನಿ ದೆವಾಕ್ ಭೆಟ್ಟಲ್ಲಿ ಕಾನಿಕಾ ಬಗಟ್ಲ್ಯಾರ್ ಬರೆ ದಿಸ್ತಾ ಮನುನ್ ತೆನಿ ಬೊಲುಲಾಗಲ್ಲೆ. ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ಎಕ್ ಎಳ್ ಯೆತಾ, ಅನಿ ಹೆ ತುಮಿ ಬಗುಲ್ಯಾಸಿ ತೆ ಎಕ್ ಸೈತ್ ಗುಂಡೊ ಥೈ ನಸ್ತಾನಾ, ಸಗ್ಳೆ ಕೊಸ್ಳುನ್ ಘಾಲುನ್ ಹೊತಾ, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ತನ್ನಾ ಶಿಸಾನಿ “ಗುರುಜಿ, ಹೆ ಕನ್ನಾ ಘಡ್ತಾ, ಅನಿ ಹೆ ಸಗ್ಳೆ ಹೊನಾರ್ ಹಾಯ್ ,ಮನುನ್ ದಾಕ್ವುಕ್ ಹೆಚ್ಯಾ ಅದ್ದಿ ಕಾಯ್- ಕಾಯ್ ಹೊತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ “ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ; ಮೊಸಾತ್ ಪಡ್ಸಿಲಾ, ಲೈ ಘೊಮನ್ಸಾ ಮಾಜ್ಯಾ ವಿಶಯಾತ್, ಬೊಲುಕ್ ಮನುನ್ ಯೆತ್ಯಾತ್, ಅನಿ ತೆನಿ ಮಿಯಾ ತೊ! ಅನಿ ಎಳ್ ಯೆವ್ನ್ ಪಾವ್ಲೊ ಅತ್ತಾ” ಮನುನ್ ಸಾಂಗ್ತ್ಯಾತ್, ಖರೆ, ತುಮಿ ತೆಂಚ್ಯಾ ಫಾಟ್ನಾ ಜಾವ್ನಕಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ಝಗ್ಡ್ಯಾಂಚ್ಯಾ ವಿಶಯಾತ್, ಹರ್‍ತಾಳಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಆಯ್ಕುನ್ “ತುಮಿ ಭಿಂವ್ನಕಾಸಿ, ಹೆ ಸಗ್ಳೆ ಘಡುಕುಚ್ ಪಾಜೆ ತಸೆಮನುನ್ ಸರ್‍ತೊ ಕಾಲ್ ಜಗ್ಗೊಳ್ ಯೆಲಾ ಮನುಕ್ ಹೊಯ್ನಾ”, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ಅನಿ ಫಿಡೆ ಜೆಜುನ್, “ದೊನ್ ದೆಶಾ ಎಕೆಮೆಕಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಝಗಡ್ತ್ಯಾತ್; ಎಕ್ ರಾಜ್, ಅನಿ ಎಕ್ ರಾಜಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಾರಾಮಾರಿಕ್ ಉಟ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ಎಗ್ದಮ್ ಭಯಾನಕ್ ಭುಕಂಪ್ ಹೊತಾ, ಬರಗಾಲ್ ಪಡ್ತಾ, ಅನಿ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಲೈ ತರಾಸ್ ಹೊತಲೊ ರೊಗ್‍ ಯೆವ್ಕ್ ಸುರು ಹೊತಾ. ಬಗಿನಸಲ್ಲಿ ಅನಿ ಭಯಾನಕ್ ಸಂಗ್ತಿಯಾ ಮಳ್ಬಾ ವರ್‍ತಿ ದಿಸುಕ್‍ ಲಾಗ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ಹೆ ಸಗ್ಳೆ ಘಡುಚ್ಯಾ ಅದ್ದಿ ತುಮ್ಕಾ ಧರುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ, ಅನಿ ತರಾಸ್ ದಿವ್ನ್ ಹೊತಾ; ತುಮ್ಕಾ ಸಿನಾಗೊಗಾತ್ನಿ ನ್ಹೆವ್ನ್ ತುಮ್ಚಿ ಪರಿಕ್ಷಾ ಕರುನ್ ಹೊತಾ, ಅನಿ ತುಮ್ಕಾ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಲುನ್ ಹೊತಾ: ಮಾಜೆಸಾಟಿ ತುಮ್ಕಾ ರಾಜಾಂಚ್ಯಾ, ಅನಿ ಅದಿಕಾರ್‍ಯಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ವೊಡುನ್ ಹಾನುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ಹ್ಯೊ ತುಮ್ಕಾ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಎಕ್ ಬರೊ ಅವ್ಕಾಸ್. ");
INSERT INTO kans_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ತುಮ್ಕಾ ಇಚಾರ್‍ನಿ ಕರುಕ್ ಘೆವ್ನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಕಾಯ್ ಸಾಂಗುನ್ ಅನಿ ಕಶೆ ಕರುನ್ ತುಮ್ಕಾಚ್ ತುಮಿ ರಾಕುನ್ ಘೆತಲೆ -ಮನುನ್ ಯವ್ಜುನಕಾಶಿ, ");
INSERT INTO kans_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ತುಮ್ಕಾ ,ಶಾನ್‍ಪಾನಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ದಿತಾ, ಅನಿ ತುಮಿ ಬೊಲಲ್ಲ್ಯಾಕ್, ದುಸ್ಮಾನಾನಿ ಕೊನ್ಬಿ ಹುರ್‍ಪಾಟಿ ಬೊಲುಕುಚ್ ವಾಟ್ ರ್‍ಹಾಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ತುಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾಕ್ನಿ, ತುಮ್ಚೆ ಬಾಯ್-ಬಾಬಾ, ತುಮ್ಚಿ ಭಾವಾ, ತುಮ್ಚೆ ಸೊಯ್ರೆ, ಅನಿ ತುಮ್ಚಿ ದೊಸ್ತಾಚ್ ಧರುನ್ ದಿತ್ಯಾತ್, ಅನಿ ತುಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾತ್ನಿ ಜಿವಾನಿ ಮಾರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ಮಾಕಾ ಲಾಗುನ್ ಸಗ್ಳೆ ಜಾನಾ ತುಮ್ಕಾ ಧುರ್ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ಖರೆ ತುಮ್ಚ್ಯಾ ಟಕ್ಲ್ಯಾಚ್ಯಾ ಎಕ್ ಕೆಸಾಕ್ ಸೈತ್ ಧಕ್ಕೊ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ಧೈರ್ಯಾನ್ ಇಬೆ ರ್‍ಹಾವಾ, ಅನಿ ತುಮ್ಚ್ಯಾ ಎವ್ಡ್ಯಾಕ್ ತುಮಿಚ್ ಬಚಾವ್ ಹೊತ್ಯಾಶಿ”, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ಜೆರುಜಲೆಮಾಚ್ಯಾ ಭೊತ್ಯಾನಿ ಸೈನಿಕಾ ಯೆವ್ನ್ ಇಬೆ ಹೊತ್ತ್ಯಾ ತನ್ನಾ, ತೆ, ಲಗ್ಗುನಾಚ್ ನಾಸ್ ಹೊತಾ ಮನುನ್ ತುಮ್ಕಾ ಕಳ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ತನ್ನಾ ಜೆ ಕೊನ್-ಕೊನ್ ಜುದೆಯಾತ್ ಹಾತ್ ತೆನಿ ಮಡ್ಡಿಯಾ ವೈನಿ ಪಳುನ್ ಜಾವ್ಚೆ; ಜೆ ಕೊನ್ ಶಾರಾತ್ ಭುತ್ತುರ್ ಹಾತ್ ತೆನಿ ಶಾರ್ ಸೊಡುನ್ ಪಳುಚೆ, ಅನಿ ಜೆ ಕೊನ್ ಖೆಡ್ಯಾತ್ನಿ ಹಾತ್, ತೆನಿ ಶಾರಾಚ್ಯಾ ಭುತ್ತುರ್ ಜಾಯ್‌ನಸ್ತಾನಾ ರ್‍ಹಾವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ತಿ, ದಿಸಾ, ಶಿಕ್ಷೆಚಿ ದಿಸಾ ಮನುನ್ ಬಲ್ವುನ್ ಹೊತ್ಯಾತ್, ಅಶೆ ಹೆ ಸಗ್ಳೆ ಪ್ರವಾದ್ಯಾನಿ ಸಾಂಗಲ್ಲೆ ಖರೆ ಮನುನ್ ದಾಕ್ವುಸಾಟ್ನಿ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ತ್ಯಾ ದಿಸಾತ್ನಿ ಗರ್‍ವಾರ್ ಹೊತ್ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಂಚಿ, ಅನಿ ಬಾರಿಕ್ಲಿ ಪೊರಾ ಹೊತ್ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಂಚಿ ಗತ್ ಕಾಯ್ ಸಾಂಗು! ಹ್ಯಾ ಜಿಮ್ನಿರ್ ಲೈ ಮೊಟೊ ಸಂಕಟ್ ಯೆವ್ನ್ ಪಾವ್ತಾ, ಅನಿ ದೆವಾಚಿ ಶಿಕ್ಷಾ ಹ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿ ಯೆವ್ನ್ ಪಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ಉಲ್ಲ್ಯಾಸ್ಯಾಕ್ನಿ ಚಾಕ್ವಾನಿ ತೊಡುನ್ ಮಾರುನ್ ಹೊತಾ, ಅನಿ ಹುರಲ್ಲ್ಯಾಕ್ನಿ , ಗುಲಾಮ್ ಕರುನ್ ದುಸ್ರ್ಯಾ-ದುಸ್ರ್ಯಾ ದೆಸಾಕ್ನಿ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊತಾ, ಅನಿ ತೆಂಚೊ ಎಳ್ ರ್‍ಹಾಯ್ ಪತರ್ ಮಟ್ಲ್ಯಾರ್, ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತಿ ಲೊಕಾ ಜೆರುಜಲೆಮಾಚೆ ತುಕ್ಡೆ-ತುಕ್ಡೆ ಕರುನ್ ಟಾಕ್ತ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ದಿಸ್, ಚಂದ್ರಾಮ್, ಅನಿ ಚಿಕ್ಕಿಯಾಂಚ್ಯಾ ವೈನಿ ಬಗುನಸಲ್ಲಿ ಅವ್ತಾರಾ ದಿಸುಕ್ ಲಾಗ್ತ್ಯಾತ್, ಅನಿ ಜಿಮ್ನಿರ್ ಸಮುಂದರಾಚ್ಯಾ ಅವಾಜಾಕ್, ಅನಿ ವೊವ್ತಲ್ಯಾ ಹೊವಾರ್‍ಯಾಂಚ್ಯಾ ಆವಾಜಾಕ್ ಜಿಮ್ನಿ ವೈಲಿ ಸಗ್ಳಿ ಲೊಕಾ ಕಂಗಾಲ್ ಹೊವ್ನ್ ಜಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ಮಳ್ಬಾತ್ಲಿ ತಾಕ್ತಿಯಾ ತೆಂಚೊ-ತೆಂಚೊ ಜಾಗೊ ಸೊಡುನ್ ಹಾಲ್ತ್ಯಾತ್ ಸಗ್ಳ್ಯಾ ಜಿಮ್ನಿರ್ ಕಸ್ಲೊ ಸಂಕಟ್ ಯೆವ್ಲಾ ತೆ ಬಗುನ್ ಸಗ್ಳಿ ಲೊಕಾ ಘಾಬ್ರುನ್ ಜಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ತನ್ನಾ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಎಕ್ ಮೊಡಾ ವೈನಾ, ಮೊಟ್ಯಾ ಪದ್ವಿನ್,ಅನಿ ಮಹಿಮೆನ್ ಭರುನ್ ಯೆತಲೊ ತೆಂಕಾ ದಿಸ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ಹೆ ಸಗ್ಳೆ ಹೊವ್ಕ್ ಸುರು ಹೊತಾನಾ, ಉಟುನ್ ಇಬೆ ರ್‍ಹಾವಾ, ಅನಿ ಟಕ್ಲಿ ವೈರ್ ಕರಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತುಮ್ಚಿ ಸುಟ್ಕಾ ಜಗ್ಗೊಳ್ ಯೆಲಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಹಿ ಕಾನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್ “ಎಕ್ ಅಂಜುರಾಚ್ಯಾ ಝಡಾ ವಿಶಯಾತ್, ಅನಿ ಹುರಲ್ಲ್ಯಾ ದುಸ್ರ್ಯಾ ಝಾಡಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಯವ್ಜುನ್ ಬಗಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ತೆಂಚಿ ಪಾನಾ ಚಿಗ್ರುಕ್ ಸುರು ಹೊಲಿ ಮನ್ತಾನಾ, ತುಮ್ಕಾ ನಿಂಬ್ರಾಚಿ ದಿಸಾ ಜಗ್ಗೊಳ್ ಯೆಲಿ ಮನುನ್ ಕಳ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ತಸೆಚ್ ಹೆ ಸಗ್ಳೆ ಹೊತಾನಾ, ದೆವಾಚೆ ರಾಜ್ ಯೆನಾರ್ ಹಾಯ್, ಮನುನ್ ತುಮ್ಕಾ ಕಳುನ್ ಯೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ಯಾದ್ ಥವ್ನ್ ಘೆವಾ, ಅತ್ತಾ ಜಿವನ್ ಕರುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿತ್ಲಿ ಉಲ್ಲಿ ಲೊಕಾ ಝಿತ್ತಿ ರ್‍ಹಾತಾನಾಚ್ ಹೆ ಸಗ್ಳೆ ಘಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ಮಳಬ್ ಅನಿ ಹ್ಯೊ ಜಗ್ ಸರುನ್ ಜಾಯ್ಲ್, ಖರೆ ಮಿಯಾ ಸಾಂಗಟಲ್ಲಿ ಗೊಸ್ಟಿಯಾ ಕನ್ನಾಚ್ ಉಸಿ ಹೊಯ್‍ನ್ಯಾತ್”. ");
INSERT INTO kans_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ಉಶಾರ್ಕಿ ರ್‍ಹಾವಾ! ಸನಾ ಕರ್‍ತಲ್ಯಾತ್, ಅನಿ ನಿಶೆತ್, ಅನಿ ಹ್ಯಾ ಬಾಳ್ವಿಚ್ಯಾ ಯವ್ಜನ್ಯಾತ್ನಿಚ್ ರ್‍ಹಾವ್ನಕಾಶಿ, ತೊ ದಿಸ್ ಎಗ್ದಮ್ ಅಚಾನಕ್ ತುಮ್ಚೆ ವರ್‍ತಿ ಯೆಯ್ಲ್. ");
INSERT INTO kans_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ಪಾಸೊ ಪಡಲ್ಲ್ಯಾ ಸರ್ಕೊ ತೊ ದಿಸಾ ಹ್ಯಾ ಜಗಾತ್ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ಉಶಾರ್ ರ್‍ಹಾವಾ, ಅನಿ , ಹೆ ಸಗ್ಳೆ ಘಡ್ತಾನಾ ತುಮ್ಕಾ ಹ್ಯಾತುರ್‍ನಾ ಹುರ್ವುನ್ ಘೆವ್‍ಸಾಟ್ನಿ, ಅನಿ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಚ್ಯಾ ಇದ್ರಾಕ್ ಧೈರ್ಯಾನ್ ಇಬೆ ರಾವಸಾಟಿ ಮಾಗ್ನಿ ಕರುನ್ಗೆಗೆತ್ ರ್‍ಹಾವಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ತ್ಯಾ ದಿಸಾತ್ನಿ ಜೆಜು ದಿಸ್‍ಬರ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುನ್ಗೆತುಚ್ ರ್‍ಹಾಲೊ, ಅನಿ ಸಾಂಜ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ತೊ ಭಾಯ್ರ್ ಒಲಿವ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಗೆಲೊ, ಅನಿ ಪುರಾ ರಾತ್ ತೊ ಥೈಚ್ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ಸದ್ದಿ ಸಕ್ಕಾಳಿ ಫಿಡೆ ಲೊಕಾ ಜೆಜುನ್ ಸಾಂಗಟಲ್ಲೆ ಆಯ್ಕುಕ್ ಮನುನ್ ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ ಜಾಯ್ತ್. ");
INSERT INTO kans_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ಪಾಸ್ಕ್, ಮನುನ್ ಮನ್ತಲ್ಯಾ ಪಿಟ್ಟ್ ಫುಗ್ವಿನಸ್ತಾನಾ ಕರ್‍ತಲ್ಯಾ ಭಾಕ್ರಿಚ್ಯಾ ಸನಾಚಿ ದಿಸಾ ಜಗ್ಗೊಳ್ ಯೆಲ್ಲಿ ");
INSERT INTO kans_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ಮುಖ್ಯ ಯಾಜಕಾ, ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲಿ ಲೊಕಾ, ಲೊಕಾಕ್ನಿ ಭಿಂಯಾಲಿ; ಅನಿ ಜೆಜುಕ್ ಕಶೆ ಕರುನ್ ಜಿವಾನಿ ಮಾರ್‍ತಲೆ ಮನುನ್ ಘುಟಾನ್ ಎಕ್ ವಾಟ್ ಹುಡ್ಕುನ್ ಕಾಡುನ್ ಬಗುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ತನ್ನಾ ಸೈತಾನ್ ಜೆಜುಚ್ಯಾ ಬಾರಾ ಜಾನಾ ಶಿಸಾನಿತ್ಲ್ಯಾ ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತಾಚ್ಯಾ ಭುತ್ತುರ್ ಗುಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ತಸೆ ಮನುನ್ ಜುದಾಸ್ ಮುಖ್ಯ ಯಾಜಕಾನಿಕ್ನಿ, ಅನಿ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ರಾಕ್ವಾಲ್ಯಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಂಚ್ಯಾಕ್ಡೆ ಗೆಲೊ, ಜೆಜುಕ್ ಕಶೆ ಕರುನ್ ಧರುಕ್ ಹೊತಾ ಮನುನ್,ತೆನಿ, ತೆಂಚೆಕ್ಡೆ ಬೊಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ತೆನಿ ಲೈ ಕುಸಿ ಹೊಲೆ, ಅನಿ ಜುದಾಸಾಕ್ ಪೈಸೆ ದಿವ್ಕ್ ತೆನಿ ತಯಾರ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ತಸೆ ಮನುನ್ ಜುದಾಸ್ ಲೊಕಾಕ್ನಿ ಕಳಿನಸ್ತಾನಾ, ಜೆಜುಕ್ ತೆಂಚ್ಯಾ ಹಾತಿತ್ ಧರುನ್ ದಿತಲೊ ಅವ್ಕಾಸ್ ಹುಡ್ಕುನ್ಗೆತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ಪಿಟ್ಟ್ ಫುಗ್ವಿನಸ್ತಾನಾ ಕರ್‍ತಲ್ಯಾ ಭಾಕ್ರಿಚ್ಯಾ ಸನಾಚೊ ಪಾಸ್ಕಾಚ್ಯಾ ಜೆವ್ನಾಚಿ ಬಕ್ರಿ ಮಾರ್ತ‍ಲೊ ದಿಸ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ತನ್ನಾ ಜೆಜುನ್ ಪೆದ್ರುಕ್, ಅನಿ ಜುವಾಂವಾಕ್ “ಜಾವಾ, ಅನಿ ಅಮ್ಚ್ಯಾ ಪಾಸ್ಕಾಚ್ಯಾ ಜೆವ್ನಾಚಿ ತಯಾರಿ ಕರಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ತನ್ನಾ ತೆನಿ “ಅಮಿ ಖೈ ಜಾವ್ನ್ ತಯಾರಿ ಕರುಚಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ತನ್ನಾ ಜೆಜುನ್ “ತುಮಿ ಶಾರಾತ್ ಭುತ್ತುರ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಎಕ್ ಬಿಂದ್ಗೊ ಪಾನಿ ಅಪ್ನಾಚ್ಯಾ ಖಾಂಜಾರ್ ವಾವುನ್ ಘೆವ್ನ್ ಜಾತಲೊ ಮಾನುಸ್ ತುಮ್ಕಾ ಗಾವ್ತಾ. ತೊ ಖಲ್ಯಾ ಘರಾತ್ ಜಾತಾ ತ್ಯಾ ಘರಾಕ್ ತೆಚ್ಯಾ ಫಾಟ್ನಾಚ್ ಜಾಂವಾ”, ");
INSERT INTO kans_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ಅನಿ ತ್ಯಾ ಘರ್‍ಚ್ಯಾ ವಡಿಲಾಕ್ “ಮಾಜಿ ಶಿಸಾ, ಅನಿ ಮಿಯಾ ಪಾಸ್ಕಾಚೆ ಜೆವಾನ್ ಜೆವ್ತಲಿ ಖೊಲಿ ಖೈ ಹಾಯ್? ಮನುನ್. ಗುರುಜಿನ್‍ ಇಚಾರ್ಲ್ಯಾನಾಯ್”, ಮನುನ್ ಸಾಂಗಾ. ");
INSERT INTO kans_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ತೊ ತುಮ್ಕಾ ಮ್ಹಾಳ್ಗಿ ವರ್‍ತಿ ಎಕ್ ಸಗ್ಳೆ ತಯಾರ್ ಕರುನ್ ಥವಲ್ಲೆ ಖೊಲಿ ದಾಕ್ವುತಾ, ಥೈ ಸಗ್ಳೆ ತಯಾರ್ ಕರುನ್ ಥವಲ್ಲೆ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ತೆನಿ ಗೆಲ್ಯಾನಿ, ಅನಿ ಜೆಜುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ತೆಂಕಾ ಸಗ್ಳೆ ಗಾವ್ಲೆ, ಅನಿ ಥೈ ತೆನಿ ಪಾಸ್ಕಾಚ್ಯಾ ಜೆವ್ನಾಚಿ ತಯಾರಿ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ಎಳ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜು ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವ್ನಾಕ್ ಬಸ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ಅನಿ ತೆಂಕಾ “ಮಿಯಾ ಕಸ್ಟ್ ಸೊಸುಚ್ಯಾ ಅದ್ದಿ, ಹೆ ಪಾಸ್ಕಾಚೆ ಜೆವಾನ್ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವ್ಚೆ ಮನುನ್ ಮಾಕಾ ಹೊತ್ತೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ “ಹೆ ಜೆವಾನ್ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಎಕ್ ಖರೊ ಅರ್ತ್‍ ದಿ ಪತರ್ ಮಿಯಾ, ಅನಿ ಜೆವಾನ್ ಕರಿನಾ”. ");
INSERT INTO kans_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ಮಾನಾ ಜೆಜುನ್ ಎಕ್ ವಾಯ್ನಾನ್ ಭರಲ್ಲೆ ಆಯ್ದಾನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನ್, ಅನಿ “ಹೆ ಘೆವಾ, ಅನಿ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ವಾಟುನ್ ಘೆವ್ನ್ ಫಿವಾ. ");
INSERT INTO kans_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ಅತ್ತಾಚ್ಯಾನ್, ದೆವಾಚೆ ರಾಜ್ ಯೆಯ್ ಪತರ್ ಮಿಯಾ ಅನಿ ಹಿ ವಾಯ್ನ್ ಫಿ ನಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ಮಾನಾ ತೆನಿ ಭಾಕ್ರಿ ಘೆಟ್ಲ್ಯಾನ್ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನ್, ಅನಿ ಮೊಡುನ್ ತೆಂಕಾ ದಿವ್ನ್ “ಹೆ ಮಾಜೆ ಮಾಸ್, ಮಿಯಾ ತುಮ್ಕಾ ದಿವ್ಲಾ, ಹೆ ಮಾಜ್ಯಾ ಯಾದಿಸಾಟ್ನಿ ಮನುನ್ ಕರಾ. ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ತಸೆಚ್ ಜೆವಾನ್ ಕರುಕ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ತೆನಿ ಎಕ್ ಖೊಲ್ಲೆ ಆಯ್ದಾನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ಹೆ ದೆವಾಚ್ಯಾ ನ್ಹವ್ಯಾ ಕರಾರಾಚೆ ಮಾಜೆ ರಗಾತ್, ತುಮ್ಚೆಸಾಟ್ನಿ ವೊತಲ್ಲೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ಖರೆ, ಬಗಾ! ಮಾಕಾ ಘಾತ್ ಕರುನ್ ಧರುನ್ ದಿತಲೊ, ಹಿತ್ತೆಚ್ ಜೆವ್ನಾಚ್ಯಾ ಬೈಟಕಿ ವರ್‍ತಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಬಸಲ್ಲೊ ಹಾಯ್! ");
INSERT INTO kans_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ದೆವಾನ್ ನಿರ್‍ದಾರ್ ಕರಲ್ಲ್ಯಾ ಸರ್ಕೆ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮರುಕುಚ್ ಪಾಜೆ, ಖರೆ, ತೆಕಾ ಘಾತ್ ಕರುನ್ ಧರುನ್ ದಿತಲ್ಯಾಚಿ ಗತ್ ಮಿಯಾ ಕಾಯ್ ಸಾಂಗು!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ತನ್ನಾ ತೆನಿ ಅಪ್ನಾ-ಅಪ್ನಾ ಮದ್ದಿ ಅಮ್ಚ್ಯಾತ್ಲೊ ಕೊನ್-ಅಪ್ಪಾ ತೊ, ಅಶೆ ಕರ್‍ತಲೊ ಮನುನ್ ಇಚಾರುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ಶಿಸಾಂಚ್ಯಾ ಮದ್ದಿ ಅಮ್ಚ್ಯಾ- ಮದ್ಲೊ ಕೊನ್ ಮೊಟೊ ಮನುನ್ ವಾದಿಕ್- ವಾದ್ ಉಟ್ಲಿ ");
INSERT INTO kans_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತೆ ರಾಜಾ ತೆಂಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿ ಅಪ್ನಾಚೊ ಅದಿಕಾರ್ ಚಾಲ್ವುತ್ಯಾತ್, ಅನಿ ಅದಿಕಾರಿ ಅಪ್ನಿ ಲೊಕಾಂಚೆ ದೊಸ್ತಾ ಮನುನ್ ಘೆತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ಖರೆ, ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಅಶೆ ಹೊವ್‍ ನ್ಹಯ್, ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಕೊನ್ ಮೊಟೊ ಹಾಯ್, ತೊ ಸಗ್ಳ್ಯಾಂಚ್ಯಾನ್ಕಿ ಬಾರಿಕ್ ಹೊವ್ಚೆ, ಅನಿ ಮುಖಂಡ್ ಎಕ್ ಸೆವಕ್ ಹೊವ್ಚೊ. ");
INSERT INTO kans_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ಕೊನ್ ಮೊಟೊ, ಜೆವ್ನಾಕ್ ಬಸಲ್ಲೊ, ಕಾಯ್ ಜೆವಾನ್ ವಾಡ್ತಲೊ? ಜೊ ಕೊನ್ ಜೆವ್ನಾಕ್ ಬಸಲ್ಲೊ, ಹಾಯ್ ತೊ ಹೊಯ್ ಕಾಯ್ ನ್ಹಯ್, ಖರೆ, ಮಿಯಾ ಬಗಾ, ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಎಕ್ ವಾಡ್ತಲೊ ಸರ್ಕೊ ಹೊವ್ನ್ ಹಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“ತುಮಿ ಮಾಜ್ಯಾ ಸಗ್ಳ್ಯಾ ತರಾಸಾತ್ನಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಹಾಸಿ; ");
INSERT INTO kans_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ಅನಿ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ಅದಿಕಾರ್ ಚಾಲ್ವುಕ್ ಮನುನ್ ಹಕ್ಕ್ ದಿಲ್ಯಾ ಸರ್ಕೊ, ಮಿಯಾಬಿ ತುಮ್ಕಾ ಅದಿಕಾರ್ ಚಾಲ್ವುಕ್ ಹಕ್ಕ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ತುಮಿ ಮಾಜ್ಯಾ ರಾಜಾತ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವ್ನಾಚ್ಯಾ ಮೆಜಾರ್ ಬಸ್ತ್ಯಾಶಿ, ಅನಿ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಬಾರಾ ಘರಾನ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ರಾಜಾಚ್ಯಾ ಕುರ್ಚಿರ್ ಬಸುನ್ ತುಮಿ ರಾಜ್ ಚಾಲ್ವುತ್ಯಾಶಿ”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ಸಿಮಾವ್, ಸಿಮಾವ್! ಆಯ್ಕ್! ಎಕ್ ಶೆತ್ಕಾರ್‍ಯಾನ್ ಘವಾತ್ನಾ ಜೊಳ್ಳ್ ಎಗಳ್ಯಾ ಸರ್ಕೆ, ಬರೆ ಹೊತ್ತೆ ಬುರ್‍ಸ್ಯಾತ್ನಾ ಎಗ್ಳುಕ್, ತುಮ್ಚಿ ಸಗ್ಳ್ಯಾಂಚಿ ಪರಿಕ್ಷಾ ಕರುಕ್ ಮನುನ್ ಸೈತಾನಾನ್ ಪರವಾನ್ಗಿ ಘೆಟ್ಲ್ಯಾನಾಯ್, ");
INSERT INTO kans_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ಖರೆ, ಸಿಮಾವ್, ತುಜೊ ವಿಶ್ವಾಸ್ ಹಾಲಿನಸ್ತಾನಾ ರ್‍ಹಾವ್‍ಸಾಟ್ನಿ ಮನುನ್ ಮಿಯಾ ಮಾಗ್ನಿ ಕರ್‍ಲಾ, ಅನಿ ತಿಯಾ ಮಾಜೆಕ್ಡೆ ಪರತಲ್ಲ್ಯಾ ತನ್ನಾ ತಿಯಾ ತುಜ್ಯಾ ಭಾವಾಕ್ನಿ ಧೈರೊ ದಿ”, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ತನ್ನಾ ಪೆದ್ರುನ್ “ಧನಿಯಾ, ಮಿಯಾ ತುಜ್ಯಾಸಾಟಿ, ಬಂದಿಖಾನ್ಯಾತ್ ಜವ್ಕ್, ಅನಿ ತುಜೆಸಾಟ್ನಿ ಮರುಕ್ ಸೈತ್ ತಯಾರ್ ಹಾಂವ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ತನ್ನಾ ಜೆಜುನ್ ಪೆದ್ರುಕ್, ಮಿಯಾ ತುಕಾ ಸಾಂಗ್ತಾ, ಆಜ್ ರಾಚ್ಚೆ ತಿಯಾ, ಮಿಯಾ ಕೊನ್ ಮನುನುಚ್ ತುಕಾ ಗೊತ್ತ್ ನಾ, ಮನುನ್ ತಿನ್‍ದಾ ಸಾಂಗಿ ಪತರ್ ಕೊಂಬೊ ಭೊಕಿನಾ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ “ಮಿಯಾ ತುಮ್ಕಾ, ಪೈಸೆ ಘೆವ್‌ನಸ್ತಾನಾ, ಪಿಸ್ವಿ ಘೆವ್‌ನಸ್ತಾನಾ, ನಾ ಹೊಲ್ಯಾರ್, ಹೊನಾಯಾ ನಸ್ತಾನಾ, ಭಾಯ್ರ್ ಧಾಡುನ್ ದಿಲ್ಲೊ ತನ್ನಾ, ತುಮ್ಕಾ ಕಾಯ್ ತರ್ ಕಮಿ ಪಡಲ್ಲೆ ಕಾಯ್? ನಾ ಕಾಯ್ಬಿ ಕಮಿ ಪಡುಕ್ನಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ತನ್ನಾ ಜೆಜುನ್ ಖರೆ ಅತ್ತಾ, ಜೆ ಕೊನಾಕ್ಡೆ ಪೈಶಾಂಚಿ ಪಿಸ್ವಿ ನಾ ಹೊಲ್ಯಾರ್ ಕಾಯ್ಬಿ ಸಾಮಾನ್ ಘೆವ್ನ್ ಜಾತಲಿ ಪಿಸ್ವಿ ಹಾಯ್, ತೊ ತಿ ಘೆಂವ್ದಿ, ಅನಿ ಕೊನಾಕ್ಡೆ ಕೊಯ್ತೊ ನಾ, ತೊ ಅಪ್ನಾಚಿ ಅಂಗಿ ಇಕುನ್ ಎಕ್ ಕೊಯ್ತೊ ಇಕಾತ್ ಘೆಂವ್ದಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ, ಪ್ರವಾದ್ಯಾಚೆ ಪುಸ್ತಕ್ “ತೆನಿ ಚೊರಾಂಚೆ ನಶಿಬ್ ಅಪ್ನಾ ವರ್‍ತಿ ಘೆಟ್ಲ್ಯಾನ್”. ಮನುನ್ ಸಾಂಗ್ತಾ ಹೆ, ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗಲ್ಲೆ ಖರೆ ಹೊವ್ಕ್ ಪಾಜೆ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜೆ ಕಾಯ್ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಲಿವಲ್ಲೆ ಹಾಯ್, ತೆ, ಖರೆ ಹೊವ್ಕುಚ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ತನ್ನಾ ಶಿಸಾನಿ “ಧನಿಯಾ! ಅಬಕ್! ಅಮ್ಚ್ಯಾಕ್ಡೆ ದೊನ್ ಕೊಯ್ತೆ ಹಾತ್!” ಮಟ್ಲ್ಯಾನಿ, ತನ್ನಾ ಜೆಜುನ್,“ತವ್ಡೆಚ್ ಫಿರೆ” ಮನುನ್ ಪರ್ತುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ಜೆಜು ಸದ್ದಿಚ್ಯಾ ಬಾಸೆನ್ ಶಾರ್ ಸೊಡುನ್ ಒಲಿವ್ ಮಡ್ಡಿ ವರ್‍ತಿ ಗೆಲೊ, ಅನಿ ಶಿಸಾಬಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ತ್ಯಾ ಜಾಗ್ಯಾವರ್ತಿ ಜಾವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುಕ್ ಶಿಸಾಕ್ನಿ “ತುಮಿ ಪಾಪಾತ್ ಪಡ್ತಲ್ಯಾ ವಿಶಯಾತ್ನಿ \" ಪಡಿನಸ್ತಾನಾ ರ್‍ಹಾವ್‍ಸಾಟ್ನಿ ಮಾಗ್ನಿ ಕರಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ಮಾನಾ ತೊ ತೆಂಚೆಕ್ನಾ ಎಕ್ ಗುಂಡೊ ಮಾರಿ ಸರ್ಕೆ ತವ್ಡೆ ಧುರ್ ಗೆಲೊ, ಅನಿ ಡೊಗ್ಲಾ ಘಾಲುನ್ ಮಾಗ್ನಿ ಕರುನ್ಗೆತ್, ");
INSERT INTO kans_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ತೆನಿ, “ಬಾಬಾ, ತುಕಾ ಮನ್ ರ್‍ಹಾಲ್ಯಾರ್, ಹೆ ಕಸ್ಟಾಚೆ ಆಯ್ದಾನ್, ಮಾಜೆಕ್ನಾ ಧುರ್ ಕರ್, ಮಾಜ್ಯಾ ಮನಾ ಸರ್ಕೆ ನ್ಹಯ್, ತುಜ್ಯಾ ಮನಾಕ್ ಕಶೆ ದಿಸ್ತಾ ತಸೆ ಕರ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ಎಕ್ ದೆವಾಚೊ ದುತ್ ಸರ್‍ಗಾ ವೈನಾ ಯೆಲೊ, ಅನಿ ತೆಕಾ ಧೈರೊ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ಅನಿಬಿ ಲೈ ದುಕ್ಕಾನ್ ಭರುನ್, ತೆನಿ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನ್, ತೆಚೊ ಘಾಮ್ ರಗ್ತಾಚ್ಯಾ ಠೆಂಬ್ಯಾಂಚ್ಯಾ ಸಾರ್ಕೊ ಜಿಮ್ನಿರ್ ಗಳಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ಅಪ್ನಾಚಿ ಮಾಗ್ನಿ ಕರುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಉಟುನ್ ತೊ, ಶಿಸಾಂಚ್ಯಾಕ್ಡೆ ಗೆಲೊ, ಅನಿ ತೆನಿ ನಿಜುನ್ ಪಡಲ್ಲೆ , ಬಗುನ್ ತೆಕಾ ಬೆಜಾರ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ತೆನಿ ತೆಂಕಾ “ತುಮಿ ಕಶ್ಯಾಕ್ ನಿಜ್ಲ್ಯಾಶಿ? ಉಟಾ, ಅನಿ ಪಾಪಾತ್ನಿ ಪಡ್ತಲ್ಯಾ ವಿಶಯಾತ್ನಿ ತುಮಿ ಪಡಿನಸ್ತಾನಾ ರ್‍ಹಾವ್‍ಸಾಟ್ನಿ ಮಾಗ್ನಿ ಕರಾ”, ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ಜೆಜು ಅಜುನ್ ಬೊಲುನ್ಗೆತುಚ್ ಹೊತ್ತೊ, ತನ್ನಾ ಎಕ್ ಲೊಕಾಂಚೊ ಮೊಟೊ ತಾಂಡೊಚ್ ಥೈ ಯೆಲೊ, ಬಾರಾ ಶಿಸಾನಿತ್ಲ್ಯಾ ಜುದಾಸಾನ್ ತೆಂಕಾ ಘೆವ್ನ್ ಯೆಲ್ಲ್ಯಾನ್. ತೊ ಉಪ್ಪಾ ದಿವ್ಕ್ ಮನುನ್ ಜೆಜುಕ್ಡೆ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ಖರೆ, ಜೆಜುನ್ ತೆಕಾ \" ಜುದಾಸ್ , ಎಕ್ ಉಪ್ಪಾ ದಿವ್ನ್ ತಿಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಧರುನ್ ದಿತೆ ಕಾಯ್? \" ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ಹೆ ಸಗ್ಳೆ ಹೊತಲೆ ಬಗುನ್ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ಶಿಸಾನಿ. ಜೆಜುಕ್, \"ಧನಿಯಾ ಅಮಿ ಅಮ್ಚೆ ಕೊಯ್ತೆ ಕಾಡುಚೆ ಕಾಯ್?\" ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ಅನಿ ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾನ್ ಮಹಾ ಯಾಜಕಾಚ್ಯಾ ಎಕ್ಲ್ಯಾ ಆಳಾಚ್ಯಾ ಕಾನಾಕ್ ಮಾರುನ್, ತೆಚೊ ಉಜ್ವೊ ಕಾನುಚ್ ಕಾತರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ಖರೆ ಜೆಜುನ್, “ಎವ್ಡೆಚ್ ಫಿರೆ!” ಮಟ್ಲ್ಯಾರ್, ಅನಿ ತ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಕಾನಾಕ್ ಅಪ್ಡುನ್ ತೆಚೊ, ಕಾನ್ ಬರೊ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ತನ್ನಾ ಜೆಜುನ್, ಅಪ್ನಾಕ್ ಧರುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಯೆಲ್ಲ್ಯಾ, ಮುಖ್ಯ ಯಾಜಕಾಕ್ನಿ, ಅನಿ ದೆವಾಚಿ ಗುಡಿ ರಾಕ್ತಲ್ಯಾ ಅದಿಕಾರ್‍ಯಾಕ್ನಿ, ಅನಿ ಜಾನ್ತ್ಯಾಕ್ನಿ “ಎಕ್ ಚೊರಾಕ್ ಧರುಕ್ ಯೆಲ್ಯಾ ಸರ್ಕೆ, ಕೊಯ್ತೆ, ಅನಿ ಟೊನೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ಮಿಯಾ ಸದ್ದಿಚ್ ದೆವಾಚಿ ಗುಡಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾಚ್ ರ್‍ಹಾಯ್, ಖರೆ ತುಮಿ ಮಾಕಾ ಧರುಕ್‍ನ್ಯಾಶಿ. ಖರೆ ಕಾಳೊಕ್ ಅಪ್ನಾಚೊ ರಾಜ್ ಚಾಲ್ವುತಲೊ ಎಳ್ ಹ್ಯೊ, ತುಮ್ಚೊ ಎಳ್ ಹ್ಯೊ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ತೆನಿ ಜೆಜುಕ್ ಧರ್‍ಲ್ಯಾನಿ, ಅನಿ ಎಗ್ದಮ್ ಮಹಾ ಯಾಜಕಾಚ್ಯಾ ಘರಾಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ, ಅನಿ ಪೆದ್ರುಬಿ ಧುರ್ -ಧುರ್‍ನಾಚ್ ಜೆಜುನ್ ಧರುನ್ ನ್ಹೆಲ್ಲ್ಯಾಕ್ಡೆ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ಥೈ ದಾರಾತ್ ಮಟ್‍ಮದ್ದಿ, ಎಕ್ ಧುಮಿ ಘಾಟಲ್ಲಿ ಹೊತ್ತಿ, ಅನಿ ಪೆದ್ರು ತ್ಯಾ ಧುಮಿಚ್ಯಾ ಭೊತ್ಯಾನಿ ಹೊತ್ತ್ಯಾ ಲೊಕಾತ್ನಿ ಜಾವ್ನ್ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ಥೈ ಆಗಿಕ್ಡೆ ಬಸಲ್ಲ್ಯಾ ಪೆದ್ರುಕ್ ಎಕ್ ಕಾಮಾಚ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್ ಬಗಟ್ಲಿನ್, ತೆನಿ ತೆಕಾ ಬರೆ ಕರುನ್ ಬಗುನ್ “ಹ್ಯೊ , ಮಾನುಸ್‍ಬಿ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ!” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ಖರೆ ಪೆದ್ರುನ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ “ಬಾಯಿ ತೊ ಕೊನ್ ಮನುನ್ ಸೈತ್ ಮಾಕಾ ಗೊತ್ತ್ ನಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ಎಕ್ ಉಲ್ಲೊ ಎಳ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಎಕ್ ಘೊಮನ್ಸಾನ್ ಪೆದ್ರುಕ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ತಿಯಾಬಿ ಎಕ್ಲೊ ತೆಂಚ್ಯಾತ್ಲೊಚ್! ಮಟ್ಲ್ಯಾನ್. ಖರೆ ಪೆದ್ರುನ್, “ಅರೆ ಬಾಬಾ, ಮಿಯಾ ತೆಂಚ್ಯಾತ್ಲೊ ನ್ಹಯ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ಅನಿ ಸುಮಾರ್ ಎಕ್ ತಾಸ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಅನಿ ಎಕ್ಲೊ ಎಗ್ದಮ್ ವಿಶ್ವಾಸಾನ್ “ಹ್ಯೊ ಮಾನುಸ್ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ ಮನುನ್ ಸಾಂಗ್ತಲ್ಯಾತ್ ಸಂಶೆವುಚ್ ನಾ. ಎಕ್ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಹ್ಯೊ ಬಿ ಎಕ್ ಗಾಲಿಲಿಯಾಕಾರ್!” ಮನುನ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ಖರೆ ಪೆದ್ರುನ್, “ಅರೆ, ಬಾಬಾ; ತಿಯಾ ಖಲ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲೆ ಮನುನ್ ಮಾಕಾಚ್ ಕಳಿನಾ ಹೊಲಾ!” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೊ ಬೊಲುನ್ಗೆತುಚ್ ರಾತಾನಾ, ತಾಬೊಡ್ತೊಬ್ ಎಕ್ ಕೊಂಬ್ಯಾನ್ ಭೊಕ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ತನ್ನಾ ಜೆಜು ಪರತ್ಲೊ, ಅನಿ ಸಿದಾ ಪೆದ್ರುಕ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ಪೆದ್ರುಕ್, ಧನಿಯಾನ್ “ಆಜ್ ರಾಚ್ಚೆ ಕೊಂಬೊ ಭೊಕುಚ್ಯಾ ಅದ್ದಿ ತಿನ್ ದಾ ತಿಯಾ ಮಾಕಾ ವಳ್ಕಿಚ್‍ ನೈ, ಮನುನ್ ಸಾಂಗ್ತೆ” ಮನುನ್ ಸಾಂಗಟಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಚಿ ಯಾದ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ತನ್ನಾ ಪೆದ್ರು ಭಾಯ್ರ್ ಗೆಲೊ ಅನಿ ವಾಯ್ಟ್ ರಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ಜೆಜುಕ್ ರಾಕುಕ್ ಮನುನ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ ಜೆಜುನ್ ಎಡ್ಸಡ್ಲ್ಯಾನಿ, ಅನಿ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ತೆಚೆ ಡೊಳೆ ಫಾಳಿನಿ ಧಾಪ್ಲ್ಯಾನಿ, ಅನಿ, ತೆಕಾ ಘುಮ್ಕೆ ಘಾಲುನ್ “ತುಕಾ ಕೊನ್ ಮಾರ್‍ಲೆ ಮನುನ್ ಸಾಂಗ್ ಬಗುವಾ!” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ಅನಿ ಅಸ್ಲ್ಯಾ ಲೈ ತೆಚಿ ಮರ್‍ಯಾದ್ ಕಾಡ್ತಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ತೆನಿ ತೆಕಾ ಬೊಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ದಿಸ್ ಉಜ್ವಾಡಲ್ಲ್ಯಾ ತನ್ನಾ ಜಾಸ್ತಿ ಲೊಕಾ, ಮುಖ್ಯ ಯಾಜಕಾ, ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲಿ ಲೊಕಾ ಎಕಾಕ್ಡೆ ಗೊಳಾ ಹೊಲಿ, ಅನಿ ಜೆಜುಕ್ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾ ಮಂಡಳಿಚ್ಯಾ ಇದ್ರಾಕ್ ಘೆವ್ನ್ ಯೆವ್ನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ತೆನಿ ತೆಕಾ “ತಿಯಾ ಮೆಸ್ಸಿಯಾ ಕಾಯ್? ಅಮ್ಕಾ ಸಾಂಗ್” ಮನುನ್ ಮಟ್ಲ್ಯಾನಿ. ತೆನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗಟ್ಲ್ಯಾರ್‍ಬಿ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾಶಿ, ");
INSERT INTO kans_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","“ಅನಿ ಮಿಯಾ ತುಮ್ಕಾ ಎಕ್ ಸವಾಲ್ ಇಚಾರ್ಲ್ಯಾರ್ ತುಮ್ಚ್ಯಾನ್ ಮಾಕಾ ಜಬಾಬ್ ದಿವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ಖರೆ ಅತ್ತಾಚ್ಯಾನ್ ಫಿಡೆ, ಮಾನ್ಸಾಚೊ ಲೆಕ್, ಪರಮೊನ್ನತ್ ದೆವಾಚ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಬಸ್ತಾ!” ಮಟ್ಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ತೆನಿ ಸಗ್ಳ್ಯಾನಿ“ತಸೆ ಜಾಲ್ಯಾರ್,ತಿಯಾ ದೆವಾಚೊ ಲೆಕ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತೆನಿ ತೆಂಕಾ “ತುಮಿ ಸಾಂಗಲ್ಲೊಚ್ ಮಿಯಾ.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ತನ್ನಾ ತೆನಿ “ಅಮ್ಕಾ ಅನಿ ಕಸ್ಲಿಬಿ ಸಾಕ್ಷಿ ನಕ್ಕೊ! ತೆನಿ ಕಾಯ್ ಬೊಲ್ಲ್ಯಾನ್ ಮನುನ್ ಅಮಿಚ್ ಆಯಿಕ್ಲಾವ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ಸಗ್ಳೊ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಉಟ್ಲೊ, ಅನಿ ಜೆಜುಕ್ ಪಿಲಾತಾಕ್ಡೆ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ಥೈ ತೆನಿ ಲೊಕಾಕ್ನಿ “ಸಿಜರಾಕ್ ತೆರ್‍ಗಿ ದಿವ್‍ನಕಾಶಿ, ಮನುನ್ ಚುಕ್ ಹೊತ್ತೆ ಶಿಕ್ವುತಲ್ಯಾ, ಅನಿ ಅಪ್ನಿ ಮೆಸ್ಸಿಯಾ ಅನಿ, ರಾಜಾ ಮನುನ್ ಮನ್ತಲ್ಯಾ ಎಕ್ ಮಾನ್ಸಾಕ್ ಅಮಿ ಧರುನ್ ಹಾನ್ಲಾಂವ್” ಮನುನ್ ಜೆಜು ವರ್‍ತಿ ಝುಟೊ ಅಪ್ಪಾದ್ ಘಾಲುಕ್‍ಲಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ಪಿಲಾತಾನ್ ಜೆಜುಕ್ “ತಿಯಾ ಜುದೆವಾಂಚೊ ರಾಜಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತೆಕಾ ಜೆಜುನ್ “ತಿಯಾ ಮಟಲ್ಲ್ಯಾ ಸಾರ್ಕೆಚ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ತನ್ನಾ ಪಿಲಾತಾನ್ ಮುಖ್ಯ ಯಾಜಕಾಕ್ನಿ, ಅನಿ ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ “ಹ್ಯಾ ಮಾನ್ಸಾನ್ ಚುಕ್ ಕರ್‍ಲ್ಯಾನಾಯ್, ಮನುನ್ ದಾಕ್ವುತಲೆ ಕಾಯ್ ಕಾರನ್ ಮಾಕಾ ಗಾವುಕ್ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ಖರೆ ತೆನಿ, “ಅನಿ ಜೊರಾನ್ ಸಗ್ಳ್ಯಾ ಜುದೆಯಾತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುನ್ಗೆತ್, ಹ್ಯೊ ಲೊಕಾತ್ನಿ ಡಂಗೊ ಉಟ್ವುಲಾ, ತೆನಿ ಅಪ್ನಾಚೆ ಹೆ ಕಾಮ್ ಗಾಲಿಲಿಯಾತ್ನಾ ಚಾಲು ಕರಲ್ಲ್ಯಾನ್, ಅನಿ ಅತ್ತಾ ತೊ, ಹಿತ್ತೆ ಯೆವ್ನ್ ಪಾವ್ಲಾ” ಮನುಕ್‍ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಪಿಲಾತಾನ್ “ಹ್ಯೊ ಗಾಲಿಲಿಯಾಚೊ ಮಾನುಸ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ಜೆಜು ಹೆರೊದಾಚ್ಯಾ ಅದಿಕಾರಾತ್ ಹೊತ್ತ್ಯಾ ಜಾಗ್ಯಾವೈಲೊ ಮನುನ್ ಕಳಲ್ಲ್ಯಾ ತನ್ನಾ, ಪಿಲಾತಾನ್ ಜೆಜುಕ್ ಹೆರೊದಾಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ಹೆರೊದ್ ಜೆರುಜಲೆಮಾತುಚ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ಜೆಜುಕ್ ಬಗುನ್ ಹೆರೊದಾಕ್ ಲೈ ಕುಶಿ ಹೊಲಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಲೈಂದಾ, ತೆನಿ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಆಯ್ಕಲ್ಲ್ಯಾನ್, ಅನಿ ಜೆಜುಕ್ ಭೆಟುಚೆ ಮನುನ್ ತೆಕಾ ಲೈ ಮನ್ ಹೊತ್ತೊ. ಜೆಜುನ್ ಕಸ್ಲೆ ತರ್ ಮೊಟೆ ವಿಚಿತ್ರ್ ಕಾಮ್ ಕರಲ್ಲೆ ತೆಕಾ ಬಗ್ತಲೊ ಮನ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ತಸೆಮನುನ್ ಹೆರೊದಾನ್ ಜೆಜುಕ್ ಲೈ ಸವಾಲಾ ಇಚಾರ್‍ಲ್ಯಾನ್, ಖರೆ ಜೆಜುನ್ ಕಾಯ್ಬಿ ಬೊಲುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ಮುಖ್ಯ ಯಾಜಕಾ ಅನಿ ಖಾಯ್ದೊ ಶಿಕ್ವುತಲಿ ಲೊಕಾ ಫಿಡೆ ಯೆಲಿ, ಅನಿ ಜೆಜು ವರ್‍ತಿ, ಲೈ ಝುಟಿ ಅಪ್ವಾದಾ ತೆನಿ ಘಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ಹೆರೊದಾನ್, ಅನಿ ತೆಚ್ಯಾ ಸೈನಿಕಾನಿ ಜೆಜುಕ್ ಎಡ್ಸಡ್ಲ್ಯಾನಿ, ಅನಿ ಮರ್‍ಯಾದ್ ಕಾಡ್ಲ್ಯಾನಿ. ಮಾನಾ ತೆನಿ ಜೆಜುಕ್ ಎಕ್ ಬರಿ ಅಂಗಿ ನೆಸ್ವುಲ್ಯಾನಿ, ಅನಿ ಪಿಲಾತಾಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ಅನಿ ತ್ಯಾಚ್ ದಿಸಿ, ಹೆರೊದ್, ಅನಿ ಪಿಲಾತ್ ದೊಸ್ತಿ ಹೊಲೆ, ಹೆಚ್ಯಾ ಅದ್ದಿ ತೆನಿ ಎಕಾಮೆಕಾಕ್ ದುಸ್ಮಕಿನ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ಪಿಲಾತಾನ್ ಸಗ್ಳ್ಯಾ ಮುಖ್ಯ ಯಾಜಕಾಕ್ನಿ, ಅದಿಕಾರ್‍ಯಾಕ್ನಿ, ಅನಿ ಲೊಕಾಕ್ನಿ ಎಕಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ಅನಿ ತೆಂಕಾ,“ಲೊಕಾಕ್ನಿ ಚುಕ್ ವಾಟೆನ್ ನ್ಹೆವ್ಲಾ ಮನುನ್ ಹ್ಯಾ ಮಾನ್ಸಾಕ್ ತುಮಿ ಮಾಜೆಕ್ಡೆ ಘೆವ್ನ್ ಯೆಲ್ಯಾಶಿ, ಅನಿ ಅತ್ತಾ ತುಮ್ಚ್ಯಾ ಇದ್ರಾಕುಚ್ ಮಿಯಾ ತೆಚಿ ಪರಿಕ್ಷಾ ಕರುನ್ ಬಗಟ್ಲೊ, ಅನಿ ತುಮಿ ಸಾಂಗಟಲ್ಲಿ ಎಕ್‍ಬಿ ಚುಕ್ ತೆನಿ ಕರ್‍ಲ್ಯಾನಾಯ್ ಮನುನ್ ಮಾಕಾ ತರ್ ಕಾಯ್ ದಿಸಿನಾ ಹೊಲಾ. ");
INSERT INTO kans_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ಅನಿ ಹೆರೊದಾಕ್‍ಬಿ ಹೆಚಿ ಚುಕ್ ಕಾಯ್ ಮನುನ್ ಗಾವುಕ್ನಾ ತಸೆ ಮನುನ್ ತೆನಿ ಆನಿಪರ್ತುನ್ ಮಾಜೆಕ್ಡೆ ತೆಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್. ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿ ಸರ್ಕೆ ಹ್ಯಾ ಮಾನ್ಸಾನ್ ಕಾಯ್ಬಿ ಕರುಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ತಸೆ ಮನುನ್ ಮಿಯಾ ತೆಕಾ ಬಾರ್‍ಕೊಲಾನಿ ಮಾರುಕ್ ಲಾವ್ತಾ, ಅನಿ ಸೊಡುನ್ ದಿತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ಹರಿಎಕ್ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಕ್ ಪಿಲಾತಾನ್ ಎಕ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಸೊಡುನ್ ದಿತಲೆ ಮನುನ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾನ್, “ತೆಕಾ ಜಿವಾನಿ ಮಾರ್! ಬಾರಾಬ್ಬಾಸಾಕ್ ಅಮ್ಚ್ಯಾಸಾಟ್ನಿ ಸೊಡುನ್ ದಿ!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ಶಾರಾತ್ ಎಕ್ ಡಂಗೊ ಉಟ್ವಲ್ಲ್ಯಾ‍ಸಾಟ್ನಿ, ಅನಿ ಲೊಕಾಕ್ನಿ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾ ಸಾಟ್ನಿ, ಬಾರಾಬ್ಬಾಸಾಕ್ ಬಂದಿಖಾನ್ಯಾತ್ ಥವಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ಪಿಲಾತ್ ಜೆಜುಕ್ ಸೊಡುಚೆ ಮನುನ್ ಹೊತ್ತೊ ತೆಚೆಸಾಟ್ನಿ ತೆನಿ, ಅನಿ ಎಗ್ದಾ ಲೊಕಾಕ್ನಿ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ಖರೆ ತೆನಿ “ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್! ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ಪಿಲಾತಾನ್ ತಿನ್ವೆಪಟಿ ತೆಂಕಾ “ಖರೆ, ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿ ಸರ್ಕೆ ಕಸ್ಲಿ ಚುಕ್ ತೆನಿ ಕರ್‍ಲ್ಯಾನಾಯ್, ಮಾಕಾ ತರ್ ತೆಚಿ ಕಸ್ಲಿಬಿ ಚುಕ್ ಗಾವುಕ್ನಾ, ತಸೆ ಮನುನ್ ಮಿಯಾ ತೆಕಾ ಬಾರ್‍ಕೊಲಾನಿ ಮಾರುಕ್‍ಲಾವ್ತಾ, ಅನಿ ಸೊಡುನ್ ದಿತಾ!” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ಖರೆ ತೆನಿ ತೆಂಕಾ ಕವ್ಡ್ಯಾ ಹೊತಾ ತವ್ಡ್ಯಾ ಜೊರಾನ್, ಜೆಜುಕ್ ಕುರ್ಸಾರ್ ಮಾರುಚೆ ಮನುನ್ ಬೊಬ್ ಮಾರುಕ್‍ಲಾಲೆ, ಅನಿ ಆಕ್ರಿಕ್ ತೆನಿ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾ ಸರ್ಕೆಚ್ ತೆಂಕಾ ನಿರ್‍ದಾರ್ ಗಾವ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ತನ್ನಾ ಪಿಲಾತಾನ್ ತೆನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ಹೊಂವ್ದಿ ಮನುನ್ ನಿರ್‍ನಯ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ತೆನಿ ಇಚಾರಲ್ಲ್ಯಾ ಡಂಗೊ ಉಟ್ವುನ್, ಅನಿ ಲೊಕಾಕ್ನಿ ಜಿವಾನಿ ಮಾರುನ್ ಬಂದಿಖಾನ್ಯಾತ್ ಹೊತ್ತ್ಯಾಕ್ ತೆನಿ ಸೊಡುನ್ ದಿಲ್ಯಾನ್, ಅನಿ ತುಮ್ಕಾ ಕಾಯ್ ಪಾಜೆ ತೆ ಕರಾ ಮನುನ್ ಜೆಜುಕ್ ತೆಂಚ್ಯಾ ತಾಬೆತ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ಸೈನಿಕಾನಿ ಜೆಜುಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ, ಅನಿ ತೆನಿ ಜೆಜುಕ್ ಘೆವ್ನ್ ಜಾತಾನಾ, ವಾಟೆರ್ ಸಿರೆನ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ಸಿಮಾವಾಕ್ ತೆನಿ ಭೆಟ್ಲ್ಯಾನಿ. ತೊ ಶೆತಾತ್ನಾ ಅಪ್ನಾಚ್ಯಾ ಶಾರಾತ್ ಜಾಯ್. ತೆನಿ ತೆಕಾ ಧರ್‍ಲ್ಯಾನಿ, ಅನಿ ಜೆಜುಚೊ ಕುರಿಸ್ ವಾವುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಲಾವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಲೊಕಾಂಚೊ, ಎಕ್ ಮೊಟೊ ತಾಂಡೊಚ್ ಹೊತ್ತೊ, ತ್ಯಾತುರ್‍ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾ ಜೆಜುಸಾಟ್ನಿ ರಡುಲಾಗಲ್ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ಜೆಜು ತೆಂಚೆಕ್ಡೆ ಪರತ್ಲೊ, ಅನಿ ತೆಂಕಾ “ಜೆರುಜಲೆಮಾಚ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾನೊ ಮಾಜೆಸಾಟಿ ರಡುನಕಾಶಿ! ತುಮ್ಚ್ಯಾ, ಅನಿ ತುಮ್ಚ್ಯಾ ಪೊರಾಂಚ್ಯಾ ಸಾಟ್ನಿ ರಡಾ”, ಮಟ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ಲೊಕಾ ಪೊರಾ ಹೊವನಸಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾಂಚೆ ಕವ್ಡೆ ಬರೆ, ಪೊರಾಕ್ ಜಲಮ್‍ ದಿ ನಸಲ್ಲ್ಯಾಂಚೆ ಕವ್ಡೆ ಬರೆ! ಮನುನ್ ಸಾಂಗ್ತಲೊ ಎಳ್ ಯೆತಾ: ");
INSERT INTO kans_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ತ್ಯಾ ದಿಸಾತ್ನಿ ಲೊಕಾ ಮೊಟ್ಯಾ-ಮೊಟ್ಯಾ ಮಡ್ಡಿಯಾಕ್ನಿ “ಅಮ್ಚೆ ವರ್‍ತಿ ಯೆವ್ನ್ ಪಡಾ, ಮನ್ತ್ಯಾತ್, ಅನಿ ಬಾರಿಕ್ಲ್ಯಾ ಮಡ್ಡಿಯಾಕ್ನಿ”, ಅಮ್ಕಾ ನಿಪ್ವುನ್ ಸೊಡಾ! ಮನ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“ಅಸ್ಲೆ ಸಗ್ಳೆ ಎಕ್ ಹಿರ್‍ವೆ ಹೊತ್ತ್ಯಾ ಝಾಡಾಕುಚ್ ಕರ್ಲ್ಯಾರ್ , ವಾಳ್ಕ್ಯಾ ಝಾಡಾಚಿ ಗತ್ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ಅನಿ ದೊಗ್ಯಾ ಚೊರಾನ್ಕಿಬಿ, ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿವ್ಕ್ ಘೆವ್ನ್ ಯೆಲ್ಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ಅಶೆ ತೆನಿ “ಟಕ್ಲ್ಯಾಚ್ಯಾ ಬುರ್‍ಡ್ಯಾಚೊ ಜಾಗೊ” ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಜೆಜುಕ್ ಕುರ್ಸಾರ್ ಮಾರ್‍ಲ್ಯಾನಿ, ಅನಿ ತ್ಯಾ ದೊಗ್ಯಾ ಚೊರಾಕ್ನಿ, ಎಕ್ಲ್ಯಾಕ್ ಜೆಜುಚ್ಯಾ ಉಜ್ವ್ಯಾಬಾಜುಕ್, ಅನಿ ಎಕ್ಲ್ಯಾಕ್ ಡಾವ್ಯಾ ಬಾಜುಕ್ ಕುರ್ಸಾರ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ತನ್ನಾ ಜೆಜುನ್ “ಬಾಬಾ ತೆಂಕಾ ಮಾಪ್‍ ಕರ್, ತೆನಿ ಕಾಯ್ ಕರುಲ್ಯಾತ್ ಮನುನ್ ತೆಂಕಾಚ್ ಗೊತ್ತ್ ನಾ”, ಮಟ್ಲ್ಯಾನ್. ಚಿಟಿಯಾ ಕಾಡುನ್ ಕೊನಾಕ್ ಯೆತಾತ್ ಬಗುಂವಾ ಮನುನ್ ತೆನಿ ತೆಚೆ ಕಪ್ಡೆ ವಾಟುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ಜುದೆವಾಂಚಿ ಮುಖಂಡಾ ಜೆಜುಕ್ “ತೆನಿ ದುಸ್ರ್ಯಾಕ್ನಿ ಹುರ್‍ವುಲ್ಯಾನ್, ಅತ್ತಾ ತೊ ದೆವಾನ್ ಎಚುನ್ ಕಾಡಲ್ಲೊ ಮೆಸ್ಸಿಯಾ ಹೊಯ್ ಜಾಲ್ಯಾರ್, ಅಪ್ನಾಕುಚ್ ಹುರ್‍ವುನ್ ಘೆಂವ್ದಿ!” ಮನುನ್ ಎಡ್ಸಡ್ತಲೆ ಥೈ ಇಬೆ ಹೊತ್ತಿ ಸಗ್ಳಿ ಲೊಕಾ ಬಗುಲಾಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ಸೈನಿಕಾನಿಬಿ ತೆಕಾ ಎಡ್ಸಡ್ಲ್ಯಾನಿ, ಫಿಡೆ ಯೆವ್ನ್ ತೆಕಾ ಎಗ್ದಮ್ ಅಂಬೊಟ್ಲಿ ವಾಯ್ನ್ ಫಿವ್ಕ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ಅನಿ, ತಿಯಾ ಜುದೆವಾಂಚೊ ರಾಜಾ ಹೊಯ್ ಜಾಲ್ಯಾರ್, ತುಕಾಚ್ ತಿಯಾ ಹುರ್‍ವುನ್ ಘೆ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ತೆಚ್ಯಾ ಟಕ್ಲ್ಯಾಚ್ಯಾ ವರ್‍ತಿ “ಹ್ಯೊ ಜುದೆವಾಂಚೊ ರಾಜಾ” ಮನುನ್ ಎಕ್ ಫಳಿ ವರ್‍ತಿ ಲಿವ್ನ್ ಲಾವಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ತೆಚ್ಯಾ ಅಜು-ಬಾಜುಕ್ ಕುರ್ಸಾರ್ ಮಾರಲ್ಲ್ಯಾ ಚೊರಾನಿತ್ಲೊ ಎಕ್ಲೊ “ತಿಯಾ ಮೆಸ್ಸಿಯಾ ನ್ಹಯ್ ಕಾಯ್? ತುಕಾಚ್ ತಿಯಾ ಹುರ್‍ವುನ್ ಘೆ, ಅನಿ ಅಮ್ಕಾಬಿ ಹುರ್‍ವು” ಮನುನ್ ಜೆಜುಕ್ ಅವ್ಮಾನ್ ಕರುಕ್ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ತನ್ನಾ ಅನಿ ಎಕ್ಲ್ಯಾನ್ ತೆಕಾ “ತುಕಾಬಿ ತೆಕಾ ಗಾವಲ್ಲಿಚ್ ಶಿಕ್ಷಾ ಗಾವ್ಲಾ, ತುಕಾ ಉಲ್ಲೆಬಿ ದೆವಾಚೆ ಭಿಂಯೆ ನಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ಅಮ್ಕಾ ತರ್ ಹಿ. ಶಿಕ್ಷಾ ಗಾವಲ್ಲಿ, ಬರಬ್ಬರ್ ಹಾಯ್ , ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಅಮಿ ಕರಲ್ಲ್ಯಾ ಚುಕಾಕ್ನಿ ಅಮ್ಕಾ ಹಿ ಶಿಕ್ಷಾ ಹೊವ್ಕುಚ್ ಪಾಜೆ, ಖರೆ ತೆನಿ ಕಾಯ್ಬಿ ಚುಕ್ ಕರಲ್ಲಿ ನಾ”, ಮನುನ್ ಜೊರ್ ಕರ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ಅನಿ ಜೆಜುಕ್ “ಜೆಜು, ತಿಯಾ ರಾಜಾಚಿ ಪದ್ವಿ ಘೆವ್ನ್ ಯೆತಾನಾ, ಮಾಜಿ ಯಾದ್ ಕರ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ಜೆಜುನ್ ತೆಕಾ “ಮಿಯಾ ತುಕಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ ಆಜುಚ್ ತಿಯಾ ಮಾಜೆ ವಾಂಗ್ಡಾ, ವೈಕುಂಟಾತ್ ರ್‍ಹಾತೆ!” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ಜಗ್ಗ್ -ಜಗ್ಗೂಳ್ ದೊಪಾರ್ಚೆ ಬಾರಾ ಘಂಟೆ ಹೊಲ್ಲೆ ತನ್ನಾ ದಿಸ್ ಕಾಳೊ ಹೊಲೊ,ಅನಿ ತಿನ್ ಘಂಟ್ಯಾ ಪತರ್ ಸಗ್ಳ್ಯಾ ದೆಶಾತ್ ಕಾಳೊಕ್ ಪಡಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ಅನಿ ದೆವಾಚ್ಯಾ ಗುಡಿಚೊ ಫಡ್ದೊ ಪಿಂಜುನ್ ದೊನ್ ಭಾಗ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ಜೆಜುನ್ ಮೊಟ್ಯಾನ್ “ಬಾಬಾ ಮಾಜೊ ಜಿವ್ ಮಿಯಾ ತುಜ್ಯಾ ತಾಬೆತ್ ದಿತಾ” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನ್. ಅನಿ ಜಿವ್ ಸೊಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ಕಾಯ್-ಕಾಯ್ ಹೊಲೆ ಮನುನ್ ಎಕ್ ಸೈನಿಕಾಂಚ್ಯಾ ಮುಖಂಡಾನ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ “ಹ್ಯೊ ಖರೆಚ್ ಬರೊ ಮಾನುಸ್” ಮನುನ್ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ ಡೊಳ್ಯಾನ್ ಡೊಳೊಬರ್, ಬಗಟಲ್ಲ್ಯಾನಿ ದುಕ್ಕಾನ್ ಅಪ್ನಾಚೆ ಹಿರ್‍ದೆ ಬಡ್ವುನ್ ಘೆವ್ನಗೆತ್‍ ತೆಂಚ್ಯಾ ಘರಾತ್ನಿ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ಜೆಜುಚಿ ವಳಕ್ ಹೊತ್ತಿ. ಲೊಕಾ, ಅನಿ ಗಾಲಿಲಿಯಾತ್ನಾ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಯೆಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾ ಥೈಚ್ ಉಲ್ಲೆ ಧುರ್ ಇಬೆ ರ್‍ಹಾವ್ನ್, ಹೆ ಸಗ್ಳೆ ಬಗುಲಾಗಲ್ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","ಜುದೆಯಾತ್ಲ್ಯಾ ಅರೆಮಾತಿಯಾ, ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ಲೊ ಜುಜೆ ಮನ್ತಲೊ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ. ತೊ ಎಕ್ ಬರೊ, ಅನಿ ಮರ್ಯಾದಿಚೊ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೊ ದೆವಾಚೆ ರಾಜ್ ಯೆತಲಿ ವಾಟ್ ರಾಕುನ್ಗೆತ್ ಹೊತ್ತೊ. ಅನಿ ಜುದೆವಾಂಚ್ಯಾ ನ್ಯಾಯ್ ನಿರ್‍ನಯ್ ಕರ್‍ತಲ್ಯಾ ಬೈಟಕಿಚೊ ಮಾನುಸ್‌ಬಿ ಹೊತ್ತೊ. ತೆನಿ ಘೆಟಲ್ಲೊ ಹ್ಯೊ ನಿರ್‍ದಾರ್ ತೆಕಾ ಸಮಾ ದಿಸುಕ್ ನತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ತೊ ಪಿಲಾತಾಕ್ಡೆ ಗೆಲೊ, ಅನಿ ಜೆಜುಚೆ ಮಡೆ ತೆನಿ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ಜೆಜುಚೆ ಮಡೆ ಕುರ್ಸಾ ವೈನಾ ಖಾಲ್ತಿ ಉತರ್‍ಲ್ಯಾನ್, ಅನಿ ಎಕ್ ಮಡ್ಯಾಕ್ ಲಪಟ್ತಲ್ಯಾ ಮ್ಹಾಗ್ರ್ಯಾ ಫಾಳಿತ್ ತೆ ಲಪಟ್ಲ್ಯಾನ್,ಅನಿ ಕೊನಾಕ್ಬಿ ಅದ್ದಿ ಥೈನಸಲ್ಲ್ಯಾ ಎಕ್ ಘಟ್ಮುಟ್ ಮೊಟ್ಯಾ ಗುಂಡ್ಯಾತ್ ಪೊಕರಲ್ಲ್ಯಾ ಸಮಾದಿತ್ ನ್ಹೆವ್ನ್ ಥವ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ತೊ ದಿಸ್ ಸುಕ್ರಾರ್, ಅನಿ ಸಬ್ಬತ್ ಚಾಲು ಹೊತಲ್ಯಾತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ಗಾಲಿಲಿಯಾಕ್ನಾ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಯೆಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾ ಜೆಜುಚೆ ಮಡೆ ಖೈ ಥವಲ್ಲೆ ಹಾಯ್ ಮನುನ್ ಬಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ತೆನಿ ಘರಾಕ್ ಗೆಲ್ಯಾನಿ, ಅನಿ ಜೆಜುಚ್ಯಾ ಮಡ್ಯಾಕ್ ಲಾವುಕ್ ಮನುನ್, ಬರಿ ವಾಸ್ ಯೆತಲಿ ತೆಲಾ, ಅನಿ ಮಡ್ಯಾಕ್ ಲಾವ್ತಲಿ ತೆಲಾ ತೆನಿ ತಯಾರ್ ಕರ್‍ಲ್ಯಾನಿ. ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ದೆವಾಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ತೆನಿ ಅರಾಮ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ಆಯ್ತಾರ್‍ಚೆ ಸಕ್ಕಾಳಿ ಫಿಡೆ ಅಪ್ನಿ ತಯಾರ್ ಕರಲ್ಲಿ ಸುಗಂದ್ ತೆಲಾ ಘೆವ್ನ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾ ಸಮಾದಿಕ್ಡೆ ಗೆಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ತನ್ನಾ ಸಮಾದಿತ್ ಭುತ್ತುರ್ ಜಾತಲ್ಯಾ ವಾಟೆ ವೈಲೊ ಗುಂಡೊ ಗುಳ್ವುನ್ ಕಡೆಕ್ ಕರಲ್ಲೊ ತೆಂಕಾ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ತಸೆಮನುನ್ ತೆನಿ ಸಮಾದಿತ್ ಭುತ್ತುರ್ ಗೆಲ್ಯಾನಿ ಖರೆ ಥೈ ತೆಂಕಾ ಧನಿಯಾ ಜೆಜುಚೆ ಮಡೆ ಗಾವುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ಹೆ, ಬಗುನ್ ತೆನಿ ಅಜಾಪ್ ಹೊಲ್ಯಾನಿ, ತನ್ನಾ ದೊನ್ ಮಾನ್ಸಾ, ಎಗ್ದಮ್ ಝಳ್-ಝಳ್ತಲೆ ಕಪ್ಡೆ ನೆಸುನ್ ತೆಂಚ್ಯಾ ಇದ್ರಾಕ್ ಇಬೆ ರ್‍ಹಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ತೆಂಕಾ ಬಗುನ್ ಭಿಂವ್ನ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾ ಜಿಮ್ನಿರ್ ಡಬ್ ಪಡ್ಲ್ಯಾ ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾನಿ ಝಿತ್ತೊ ಹೊತ್ತ್ಯಾಕ್, ಮರಲ್ಲ್ಯಾತ್ನಿ ಯೆವ್ನ್ ಕಶ್ಯಾಕ್ ಹುಡ್ಕುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ತೊ ಹಿತ್ತೆ ನಾ ತೆಕಾ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುನ್ ಹೊಲಾ. ಗಾಲಿಲಿಯಾತ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ತೆನಿ ತುಮ್ಕಾ ಕಾಯ್ ಸಾಂಗಟಲ್ಲ್ಯಾನ್ ಮನುನ್ ಯಾದ್ ಕರುನ್ ಘೆವಾ; ");
INSERT INTO kans_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಪಾಪಿ ಲೊಕಾಂಚ್ಯಾ ಹಾತಾತ್ ಧರುನ್ ದಿವ್ಕ್ ಪಾಜೆ, ಅನಿ ಕುರ್ಸಾರ್ ಮಾರುಕ್ ಪಾಜೆ, ಅನಿ ತಿನ್ ದಿಸಾ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುಕ್ ಪಾಜೆ”. ");
INSERT INTO kans_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ತನ್ನಾ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾಕ್ನಿ ಹ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚಿ ಯಾದ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ತೆನಿ ಸಮಾದಿತ್ನಾ ಗೆಲ್ಯಾನಿ, ಅನಿ ಅಕ್ರಾ ಜಾನಾ ಶಿಸಾಕ್ನಿ, ಅನಿ ಹುರಲ್ಲ್ಯಾಕ್ನಿ ಥೈ ಕಾಯ್-ಕಾಯ್ ಹೊಲ್ಲೆ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾ ಕೊನ್- ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್ ಮಾಗ್ದೆಲಾಚಿ ಮರಿ. ಜೊನ್ನಾ, ಅನಿ ಜಾಕೊಬಾಚಿ ಬಾಯ್ ಮರಿ; ಅನಿ ಹುರಲ್ಲ್ಯಾ ದುಸ್ರ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾನಿ ಮಿಳುನ್, ಅಪೊಸ್ತಲ್ಯಾಕ್ನಿ ಹೆ, ಸಗ್ಳೆ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ತನ್ನಾ ಅಪೊಸ್ತಲಾನಿ ಹ್ಯಾ ಬಾಯ್ಕಾಮನ್ಸಾ ಕಾಯ್ಕಿ ನಸಲ್ಲೆಚ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲ್ಯಾತ್ ಮನುನ್ ಯವಜ್ಲ್ಯಾನಿ, ಅನಿ ತೆನಿ ಸಾಂಗಟಲ್ಲೆ ಖರೆ ಮನುನ್ ಮಾನುನ್ ಘೆವ್ಕ್‌ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ಖರೆ ಪೆದ್ರು ಉಟ್ಲೊ, ಅನಿ ಸಮಾದಿಕ್ಡೆ ಪಳುನ್ ಗೆಲೊ ತೆನಿ ವ್ಹಾಕುನ್ ಸಮಾದಿತ್ ಬಗಟಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುಚ್ಯಾ ಮಡ್ಯಾಕ್ ಲಪಟಲ್ಲಿ, ತಿ ಫಾಳಿ ಸೊಡುನ್ ತೆಕಾ ಕಾಯ್ಬಿ ದಿಸುಕ್‍ ನಾ, ತನ್ನಾ ತೊ ಘರಾತ್ ಫಾಟಿ ಪರ್ತುನ್ ಗೆಲೊ, ಅನಿ ಸಗ್ಳೆ ಹೊಲ್ಲೆ ಬಗುನ್ ಅಜಾಪ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ತ್ಯಾಚ್ ದಿಸ್ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿತ್ಲೆ ದೊಗೆ ಜಾನಾ, ಜೆರುಜಲೆಮಾಕ್ನಾ ಚಲುನ್‍ ಗೆಲ್ಯಾರ್ ಸುಮಾರ್ ಸಾತ್ ಮೈಲ್ ಹೊತಾ ತವ್ಡ್ಯಾ ಧುರ್ ಹೊತ್ತ್ಯಾ ಎಮ್ಮಾವ್ಸ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಜಾವ್‍ಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ತೆನಿ ಎಕಾಮೆಕಾಕ್ಡೆ, ಹ್ಯಾ ಸಗ್ಳ್ಯಾ ಹೊಲ್ಲ್ಯಾ ಸಂಗ್ತಿಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ತೆನಿ ಅಶೆ ಬೊಲುನ್ಗೆತ್ ಜಾತಾನಾ, ಜೆಜು ತೆಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಗೆಲೊ, ಅನಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ-ವಾಂಗ್ಡಾಚ್ ಚಲುನ್ ಜಾವ್ಕಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ತೆನಿ ತೆಕಾ ಬಗಟ್ಲ್ಯಾನಿ ಖರೆ, ಕಸೆಕಿ ತೆಂಕಾ ತೆಚಿ ವಳಕುಚ್ ಗಾವುಕ್‍ನಾ. ");
INSERT INTO kans_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ಜೆಜುನ್ ತೆಂಕಾ,“ತುಮಿ ಚಲುನ್ಗೆತ್ ಜಾತಾ-ಜಾತಾ ಖಲ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲಾಗಲ್ಲ್ಯಾಶಿ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ತೊಂಡಾ ಬಾವುನ್ ಘೆವ್ನ್ ಇಬೆ ರ್‍ಹಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾನ್ ಕ್ಲಿಯೊಪಾಸ್;ಮನ್ತಲ್ಯಾನ್. ತೆಕಾ, ಹ್ಯಾ ಫಾಟ್ಲ್ಯಾ ಗೆಲ್ಲ್ಯಾ ದಿಸಾತ್ನಿ, ಜೆರುಜಲೆಮಾತ್ ಕಾಯ್-ಕಾಯ್ ಹೊಲಾ ಮನುನ್ ಗೊತ್ತ್ ನಸಲ್ಲೊ ತಿಯಾ ಎಕ್ಲೊಚ್ ಕಾಯ್ಕಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ತನ್ನಾ ತೆನಿ,“ ಕಾಯ್ ಹೊಲೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ “ನಜರೆತಾಚ್ಯಾ ಜೆಜುಕ್ ಹೊಲ್ಲೆ.” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. “ದೆವಾನ್ ಅನಿ ಮಾನ್ಸಾನಿ ಹ್ಯೊ ಮಾನುಸ್ ಎಕ್ ಪ್ರವಾದಿ ಮನುನ್ ಮಾನಲ್ಲೊ ಹೊತ್ತೊ, ಸಗ್ಳ್ಯಾ ರಿತಿನ್ ತೆಕಾ ಸಗ್ಳೊ ಬಳ್ ಹೊತ್ತೊ, ತೆನಿ ಅಪ್ನಿ ಸಾಂಗ್ಲ್ಯಾನ್ ಅನಿ ತಸೆಚ್ ಕರುನ್ ದಾಕ್ವುಲ್ಯಾನ್”. ");
INSERT INTO kans_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ಅಮ್ಚ್ಯಾ ಮುಖ್ಯ ಯಾಜಕಾನಿ , ಅನಿ ಅಮ್ಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನಿ, ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿ ಸರ್ಕೆ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ತೆಕಾ ಕುರ್ಸಾ ವರ್‍ತಿ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ಅನಿ ಅಮಿ ಹ್ಯೊ ಇಸ್ರಾಯೆಲಾಕ್ ಸ್ವತಂತ್ರ್ ಹಾನುನ್ ದಿತಲೊ ಎಕ್ಲೊ ಮನುನ್ ಯವಜಲ್ಲ್ಯಾವ್. ಹೆ ಸಗ್ಳೆ ಹೊವ್ನ್ ಆಜ್ ತಿನ್ವೊ ದಿಸ್. ");
INSERT INTO kans_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ಅಮ್ಚ್ಯಾ ಉಲ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಾನಿ, ಅನಿ ಅಮ್ಕಾ, ಅನಿ ಉಲ್ಲೆ ಅಚಿತ್ತರ್ ಹೊಯ್ ಸರ್ಕೆ ಕರ್‍ಲ್ಯಾನಿ, ತೆನಿ ತೆಕಾ ಥವಲ್ಲ್ಯಾ ಸಮಾದಿಕ್ಡೆ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ಖರೆ ತೆಂಕಾ ತೆಚೆ ಮಡೆಚ್ ದಿಸುಕ್ನಾ. ತೆನಿ ಯೆಲ್ಯಾನಿ, ಅನಿ ಅಪ್ನಾಕ್ ದೆವಾಚಿ ದುತಾ ದಿಸ್ಲಿ, ಅನಿ ತೆನಿ ತೊ ಝಿತ್ತೊ ಹಾಯ್ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ಅಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾನಿ ಸಮಾದಿಕ್ಡೆ ಜಾವ್ನ್ ಬಗ್ಲ್ಯಾನಿ ತನ್ನಾ, ಬಾಯ್ಕೊಮನ್ಸಾನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ತೆಂಕಾ ಗಾವ್ಲೆ, ಖರೆ ತೊ ತೆಂಕಾ ದಿಸುಕ್ ನಾ; ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ. “ತುಮಿ ಕವ್ಡೆ ಪಿಶೆ ಹಾಸಿ ಪ್ರವಾದ್ಯಾನಿ ಸಾಂಗಟಲ್ಲ್ಯಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಲ್ಯಾತ್ ತುಮಿ ಲೈ ಸಾವ್ಕಾಸ್! ");
INSERT INTO kans_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ಮೆಸ್ಸಿಯಾಕ್ ಅಪ್ನಾಚ್ಯಾ ಮಹಿಮೆತ್ ಜಾವ್ಚ್ಯಾ ಅದ್ದಿ ಹ್ಯೊ ಸಗ್ಳೊ ಕಸ್ಟ್ ಸೊಸ್ತಲೊ ಗರ್ಜೆಚೊ ನ್ಹಯ್ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ಅನಿ ಜೆಜುನ್ ಮೊಯ್ಜೆಚ್ಯಾ ಪುಸ್ತಕಾಕ್ನಾ ಧರಲ್ಲೆ ಸಗ್ಳ್ಯಾ ಪ್ರವಾದ್ಯಾನಿ ಅಪ್ನಾಚ್ಯಾ ವಿಶಯಾತ್ ಕಾಯ್-ಕಾಯ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲೆ ಹಾಯ್, ತೆ ಸಗ್ಳೆ ತೆಂಕಾ ಸೊಡ್ಸುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ತೆನಿ ಜಾವ್ಲಾಗಲ್ಲ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಿ ಫಿಡೆ ಜಾತಲ್ಯಾ ಸರ್ಕೆ ಕರುನ್ ದಾಕ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ಖರೆ ತೆನಿ ತೆಕಾ ಬಲ್ವುಲ್ಯಾನಿ,ಅನಿ “ ಅತ್ತಾ ದಿಸ್ ಬುಡುಕ್ ಯೆಲೊ, ಅನಿ ಅತ್ತಾ ಮಟ್ಲ್ಯಾರ್ ಕಾಳೊಕ್ ಹೊತಾ, ಖೈ ಜಾತೆ,”ಯೆ, ಅನಿ ಅಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾ ಮನುನ್ ಲೈ ಮಾಗ್ಲ್ಯಾನಿ. ತೊ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾವ್‍ಸಾಟ್ನಿ ಮನುನ್ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ತೊ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವ್ನಾಕ್ ಬಸ್ಲೊ, ಅನಿ ಭಾಕ್ರಿ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ಧನ್ಯವಾದ್ ದಿವ್ನ್ ಮೊಡ್ಲ್ಯಾನ್, ಅನಿ ತೆಂಕಾ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ತನ್ನಾ ತೆಂಚೆ ಡೊಳೆ ಉಗಡ್ಲೆ, ಅನಿ ತೆಂಕಾ ತೆಚಿ ವಳಕ್ ಗಾವ್ಲಿ, ಖರೆ ತೊ ತೆಂಚ್ಯಾ ಇದ್ರಾಕ್ನಾ ನಾ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ತನ್ನಾ ತೆನಿ ಎಕಾಮೆಕಾಕ್ನಿ,“ ವಾಟೆನ್ ಯೆತಾನಾ ತೊ ಅಮ್ಚೆಕ್ಡೆ ಬೊಲುನ್ಗೆತ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗುನ್ಗೆತ್ ಯೆತಾನಾ, ಅಮ್ಚ್ಯಾ ಭುತ್ತುರುಚ್ ಎಕ್ ಆಗ್ ಪೆಟ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊಯ್ನಶಿ ಕಾಯ್?” ಮನುನ್ ಬೊಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೆನಿ ಉಟ್ಲ್ಯಾನಿ, ಅನಿ ಅಕ್ರಾ ಜಾನಾ ಶಿಸಾ, ಅನಿ ಹುರಲ್ಲಿ ಲೊಕಾ ಹೊತ್ತ್ಯಾಕ್ಡೆ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ಅನಿ “ ಧನಿ ಖರೆಚ್ ಝಿತ್ತೊ ಹೊಲಾ! ಸಿಮಾವಾಕ್ ತೊ ದಿಸ್ಲೊ!” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ತನ್ನಾ ವಾಟೆನ್ ಜಾತಾನಾ ಅಪ್ನಾಕ್ ಕಾಯ್-ಕಾಯ್ ಹೊಲೆ, ಅನಿ ತೆನಿ ಭಾಕ್ರಿ ಮೊಡುನ್ ದಿತಾನಾ ತೆಚಿ ವಳಕ್ ಅಸೆ ಕರುನ್ ಧರ್‍ಲ್ಯಾನಿ ಮನುನ್ ಸಗ್ಳೆ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ತೆನಿ ದೊಗೆ ಜಾನಾ ಹೆ ಸಗ್ಳೆ ತೆಂಕಾ ಸಾಂಗ್ತಾ ಸಾಂಗ್ತಾನಾಚ್ ಜೆಜು ತೆಂಚ್ಯಾ ಮದ್ದಿ ಇಬೆ ರ್‍ಹಾಲೊ, ಅನಿ “ ಸಮಾದಾನ್ ತುಮ್ಕಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ತೆನಿ ಎಗ್ದಮ್ ಭಿಂವ್ನ್ ಗೆಲೆ, ತೆನಿ ಅಮಿ ಭುತಾಕ್ ಬಗುಲಾವ್ ಮನುನ್ ಯವಜ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ,“ ತುಮಿ ಅಶೆ ಕಾಯ್ ಭೆದ್ರಕ್ ಸರ್ಕೆ ಇಬೆ ರ್‍ಹಾಲ್ಯಾಶಿ, ಅನಿ ಹ್ಯೊ ಸಂಶೆವ್ ತುಮ್ಚ್ಯಾ ಮನಾತ್ನಿ ಕಶ್ಯಾಕ್ ಯೆವ್ಲಾ? ");
INSERT INTO kans_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ಮಾಜ್ಯಾ ಹಾತಾಕ್ನಿ, ಅನಿ ಪಾಯಾಕ್ನಿ ಬಗಾ, ಅನಿ ಬರೆ ಕರುನ್ ಬಗಾ, ಮಿಯಾಚ್ ತೊ, ಮಾಕಾ ಅಪ್ಡುನ್ ಬಗಾ ತುಮ್ಕಾ ಕಳ್ತಾ. ಎಕ್ ಭುತಾಕ್ ಮಾಕಾ ಹೊತ್ತ್ಯಾ ಸರ್ಕೆ ಮಾಸ್ ಅನಿ ಹಡ್ಡಾ ರ್‍ಹಾಯ್ನಾತ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ಹೆ ಸಾಂಗುನ್ ತೆನಿ ತೆಂಕಾ ಅಪ್ನಾಚಿ ಹಾತಾ, ಅನಿ ಪಾಯಾ ದಾಕ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41",". ತೆಂಕಾ ಲೈ ಕುಶಿ ಹೊಲಿ ಅನಿ ಅಜಾಪ್ ಹೊಲೆ; ಅಜುನ್‍ಬಿ ತೆಂಕಾ ವಿಶ್ವಾಸ್ ಹೊವ್ಕ್ ನತ್ತೊ. ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ತೆಂಕಾ,“ತುಮ್ಚ್ಯಾಕ್ಡೆ ಕಾಯ್ ತರ್ ಖಾವ್ಕ್ ಹಾಯ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ತೆನಿ ತೆಕಾ ಎಕ್ ಭಾಜಲ್ಲಿ ಮಾಸೊಳಿ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ತೆನಿ ತಿ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ತೆಂಚ್ಯಾ ಇದ್ರಾಕುಚ್ ಖಾಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ಮಾನಾ ತೆನಿ, “ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ತನ್ನಾಚ್ ಮೊಯ್ಜೆಚ್ಯಾ ಪುಸ್ತಾಕಾತ್ನಿ, ಪ್ರವಾದ್ಯಾನಿ ಲಿವಲ್ಲ್ಯಾ ಪುಸ್ತಾಕಾತ್ನಿ, ಅನಿ ಕಿರ್ತನಾತ್ನಿ ಜೆ ಕಾಯ್ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಲಿವಲ್ಲೆ ಹಾಯ್, ತೆ ಖರೆ ಹೊವ್ಕ್ ಪಾಜೆ ಮನುನ್ ಹೆ ಸಗ್ಳೆ ತುಮ್ಕಾ ಸಾಂಗಟಲ್ಲೊ”. ");
INSERT INTO kans_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ಮಾನಾ ತೆನಿ ಪವಿತ್ರ್ ಪುಸ್ತಕಾಚ್ಯಾ ವಿಶಯಾತ್ ಕಳ್ವುನ್ ಘೆವ್‍ಸಾಟ್ನಿ ತೆಂಚಿ ಮನಾ ಉಗಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ಅನಿ ತೆಂಕಾ,“ ಅಶೆ ಲಿವಲ್ಲೆ ಹಾಯ್; ಮೆಸ್ಸಿಯಾ ಕಸ್ಟ್ ಸೊಸುಕ್ ಪಾಜೆ ಅನಿ ತಿನ್ ದಿಸಾಂಚ್ಯಾ ಮಾನಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆವ್ಕ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ಅನಿ ತೆಚ್ಯಾ ನಾವಾನ್ ಸಗ್ಳ್ಯಾ ದೆಶಾಕ್ನಿ ಪಾಪಾಚೆ ಜಿವನ್ ಬದ್ಲುಕ್,ಅನಿ ಪಾಪಾಂಚಿ ಮಾಪಿ ಗಳ್ಸುನ್ ಘೆವ್ಕ್, ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಪಾಜೆ, ಹೆ ಕಾಮ್ ಜೆರುಜಲೆಮಾತ್ನಾ ಚಾಲು ಹೊತಾ.”ಮನುನ್ ಲಿವಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ತುಮಿಚ್ ಹ್ಯಾ ಸಗ್ಳ್ಯಾ ಸಂಗ್ತಿಯಾಂಚೆ ಸಾಕ್ಷಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ಅನಿ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ತುಮ್ಕಾ ಗೊಸ್ಟ್ ದಿಲ್ಲೆ ಧಾಡುನ್ ದಿತಾ, ಖರೆ “ತುಮಿ ವೈನಾ ತುಮ್ಚೆ ವರ್‍ತಿ ತೊ ಬಳ್ ಉತ್ರುನ್ ಯೆಯ್ ಪತರ್ ಜೆರುಜಲೆಮಾತುಚ್ ರ್‍ಹಾವ್ಕ್ ಪಾಜೆ.” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ಮಾನಾ ತೆನಿ ತೆಂಕಾ ಶಾರಾಚ್ಯಾ ಭಾಯ್ರ್ ಬೆಥನಿಯಾ ಎವ್ಡ್ಯಾ ಧುರ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಥೈ ಅಪ್ನಾಚಿ ಹಾತಾ ವೈರ್ ಕರುನ್, ತೆಂಕಾ ಆಶಿರ್ವಾದ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ತೊ ಆಶಿರ್ವಾದ್ ದಿತಾ-ದಿತಾನಾಚ್, ತೆಕಾ ತೆಂಚ್ಯಾ ಮದ್ನಾ ವೈರ್ ಸರ್‍ಗಾಕ್ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ತೆನಿ ತೆಚೆ ಆರಾದನ್ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ಕುಶಿನ್ ಜೆರುಜಲೆಮಾಕ್ ಪರ್ತುನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ಅನಿ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿವ್ನಗೆತ್ ದೆವಾಚ್ಯಾ ಗುಡಿತುಚ್ ತೆನಿ ಎಳ್ ಕಾಡ್ಲ್ಯಾನಿ.");
INSERT INTO kans_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ಜಗ್ ರಚುಚ್ಯಾ ಅದ್ದಿ ಶಬ್ದ್ ಹೊತ್ತೊ, ತೊ ಶಬ್ದ್ ದೆವಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ ತೊ ಶಬ್ದ್ ದೆವ್ ಹೊವ್ನ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ತೊ ಜಗ್ ರಚುಚ್ಯಾ ಅದ್ದಿಕ್ನಾಚ್ ದೆವಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ದೆವಾನ್ ತೆಚ್ಯಾ ವೈನಾಚ್ ಸಗ್ಳಿ ಸಾಮಾನಾ ಕರ್ಲ್ಯಾನ್, ತೊ ನಸ್ತಾನಾ ಕಸ್ಲಿಬಿ ಸಾಮಾನಾ ರಚುನ್ ಹೊವ್ಕನಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ತ್ಯಾ ಶಬ್ದಾತ್ ಜಿವ್ ಹೊತ್ತೊ, ತೊ ಜಿವ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಉಜ್ವೊಡ್ ಹೊವ್ನ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ತೊ ಉಜ್ವೊಡ್ ಕಾಳ್ಕಾತ್ ಹೊಳ್ವಳ್ತಾ, ಅನಿ ಕಾಳ್ಕಾನ್ ಉಜ್ವೊಡಾಕ್ ಅರ್ತ್ ಕರುನ್ ಘೆವ್ಕ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ದೆವಾನ್ ಧಾಡುನ್ ದಿಲ್ಲೊ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೆಚೆ ನಾಂವ್ ಜುವಾಂವ್, ");
INSERT INTO kans_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ತೊ ಲೊಕಾಕ್ನಿ ಉಜ್ವೊಡಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿವ್ಕ್ ಮನುನ್ ಯೆಲೊ, ಅಶೆ ಸಗ್ಳಿ ಲೊಕಾ ಹಿ ಖಬರ್ ಆಯ್ಕುನ್ ವಿಶ್ವಾಸ್ ಕರುಸಾಟ್ನಿ ಮನುನ್ ತೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ಜುವಾಂವ್ ಅಪ್ನಿಚ್ ಉಜ್ವೊಡ್ ನ್ಹಯ್ ಹೊತ್ತೊ, ತೊ ಖಾಲಿ ಉಜ್ವೊಡಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿವ್ಕ್ ಮನುನ್ ಯೆಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ಜಗಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್ತಿ ಫಾಕ್ತಲೊ ಖರೊ ಉಜ್ವೊಡ್ ಹ್ಯೊಚ್. ");
INSERT INTO kans_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ತೊ ಶಬ್ದ್ ಹ್ಯಾ ಜಗಾತ್ ಹೊತ್ತೊ, ಅನಿ ದೆವಾನ್ ತ್ಯೆಚ್ಯಾ ವೈನಾಚ್ ಹ್ಯೊ ಜಗ್ ರಚುನ್ ಹೊಲ್ಲೊ, ಜಾಲ್ಯಾರ್‍ಬಿ ಹ್ಯಾ ಜಗಾನ್ ತೆಕಾ ಒಳ್ಕುಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ತೊ ಅಪ್ಲ್ಯಾ ಸ್ವತಾಚ್ಯಾ ದೆಶಾಕ್‍ ಯೆಲೊ. ಖರೆ ತ್ಯೆಚ್ಯಾ ಲೊಕಾನಿಚ್ ತೆಕಾ ಸ್ವಿಕಾರ್ ಕರುಕ್‍ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ಖರೆ ಕೊನ್‍ ಕೊನ್ ತೆಕಾ ಸ್ವಿಕಾರ್ ಕರಲ್ಲ್ಯಾನಿ, ತೆಚ್ಯಾ ನಾವಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಥವ್ತಲ್ಯಾ ತೆಂಕಾ ತೆನಿ ದೆವಾಚಿ ಪೊರಾ ಹೊತಲೆ ಅದಿಕಾರ್ ತೆನಿ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ತೆನಿ ಅಸೆಚ್ ದೆವಾಚ್ಯಾ ಪೊರಾಚ್ಯಾ ರುಪಾತ್ ಸ್ವಾಬಾವಿಕ್‍ ನ್ಹಯ್ ಅನಿ ರಗ್ತಾನ್ ನ್ಹಯ್ ಎಕ್ ಮಾನ್ಸಾಚ್ಯಾ ಸಮಂದಾಚ್ಯಾ ಆಶ್ಯಾನ್ ನ್ಹಯ್ ಅನಿ ಬಾಯ್ ಬಾಬಾಚ್ಯಾ ಅಶೆ ವೈನಾ ತೆನಿ ಉಪ್ಜುಕ್‍ನ್ಯಾತ್, ದೆವುಚ್ ಖುದ್ದ್ ತೆಂಚೊ ಬಾಬಾ. ");
INSERT INTO kans_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ಶಬ್ದ್ ಮಾನುಸ್ ಹೊಲೊ ಅನಿ ಕುರ್ಪೆನ್ ಅನಿ ಖರ್‍ಯಾನ್ ಅಮ್ಚ್ಯಾ ಮದ್ದಿ ತೆನಿ ಜಿವನ್ ಕರ್ಲ್ಯಾನ್. ಅನಿ ಅಮಿ ತೆಚಿ ಮಹಿಮಾ ಬಗಟ್ಲಾವ್. ದೆವಾಚ್ಯಾ ಎಕ್ಲ್ಯಾಚ್ ಲೆಕಾನ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾಕ್ನಾ ಘೆಟಲ್ಲಿ ಮಹಿಮಾ. ");
INSERT INTO kans_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ಜುವಾಂವಾನ್ ತೆಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿವ್ನ್, ಬೊಬ್ ಮಾರುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್\" ಮಿಯಾ ಕೊನಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗಟ್ಲಾ ಕಿ ತೊಚ್ ತೊ. ತೊ ಮಾಜ್ಯಾ ಮಾನಾ ಯೆತಾ, ಖರೆ ತೊ ಮಾಜ್ಯಾನ್ಕಿ ಮೊಟೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ಮಿಯಾ ಉಪ್ಜುಚ್ಯಾಕಿ ಅದ್ದಿಚ್ಯಾನುಚ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ತ್ಯೆಚ್ಯಾ ಮಾಪುಕ್ ಹೊಯ್ನಾ ತವ್ಡ್ಯಾ ಮೊಟ್ಯಾ ಕುರ್ಪೆನ್ ತೊ ಅಮ್ಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಕುರ್ಪೆಚ್ಯಾ ವರ್ತಿ ಕುರ್ಪಾ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ದೆವಾನ್ ಖಾಯ್ದೆ ಮೊಯ್ಜೆಕ್ನಾ ದಿಲ್ಯಾನ್ ಖರೆ ಕುರ್ಪಾ ಅನಿ ಖರೆಪಾನ್ ಜೆಜು ಕ್ರಿಸ್ತಾ ವೈನಾ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ದೆವಾಕ್ ಕೊನ್ಬಿ ಕದ್ದಿಚ್ ಬಗಟಲ್ಲೆ ನಾ, ಖರೆ ಬಾಬಾನ್ ದೆವಾಚ್ಯಾ ಸರ್ಕೊ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಜಿವಾತ್ ಜಿವ್ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ಅಪ್ನಾಚ್ಯಾ ಎಕ್ಲ್ಯಾಚ್ ಲೆಕಾಕ್ ಎವ್ಡೆಚ್ ಅಪ್ನಾಕ್ ದಾಕ್ವುನ್ ದಿಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ಜೆರುಜಲೆಮಾಚಿ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಉಲ್ಲ್ಯಾ ಯಾಜಕಾಕ್ನಿ, ಅನಿ ಲೆವಿತಾಕ್ನಿ, ಜುವಾಂವಾಕ್ಡೆ “ತಿಯಾ ಕೊನ್?” ಮನುನ್ ಇಚಾರುಸಾಟ್ನಿ ಜುವಾಂವಾಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ತನ್ನಾ ಜುವಾಂವಾಕ್ ಕಾಯ್ಬಿ ಧಾಪುನ್ ಥೈ ನಸ್ತಾನಾ,ಕಶೆ ಹಾಯ್ ತಸೆಚ್, ಮಿಯಾ ಮೆಸ್ಸಿಯಾ ನ್ಹಯ್.ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ತನ್ನಾ ತೆನಿ,ತಿಯಾ ಕೊನ್ ತರ್? ಎಲಿಯಾ ಕಾಯ್? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತನ್ನಾ ಜುವಾಂವಾನ್, ನಾ, ಮಿಯಾ ನ್ಹಯ್, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ,“ತಿಯಾ ಪ್ರವಾದಿ ಕಾಯ್?” ಮನುನ್ ತೆನಿ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತನ್ನಾ ತೆನಿ, “ಮಿಯಾ ಪ್ರವಾದಿಬಿ ನ್ಹಯ್.” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“ತಸೆ ಜಾಲ್ಯಾರ್ ತಿಯಾ ಕೊನ್ ಮನುನ್ ಅಮ್ಕಾ ಸಾಂಗ್, ಅಮ್ಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಕ್ನಿ ಅಮಿ ಜಬಾಬ್ ದಿವ್ಕ್ ಪಾಜೆ, ತುಜೆ ವಿಶಯಾತ್ ತಿಯಾ ಕಾಯ್ ಮನ್ತೆಯ್?” ಮನುನ್ ತೆನಿ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ತನ್ನಾ ಜುವಾಂವಾನ್ ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾಚಿ ಶಬ್ದಾ ಘೆವ್ನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್ ಡಂಗ್ಳಿತ್ ಬೊಬ್ ಮಾರ್‍ತಲೊ ಧನ್ ಮಿಯಾ “ಧನಿಯಾಕ್ ಯೆವ್ಕ್ ವಾಟ್ ನಿಟ್ ಕರಾ!” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ಫಾರಿಜೆವಾನಿ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾ ಬಾತ್ಮಿ ದಿಲ್ಲ್ಯಾ ಲೊಕಾನಿ , ");
INSERT INTO kans_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ತೆನಿ ಜುವಾಂವಾಕ್ ಇಚಾರ್‍ಲ್ಯಾನಿ “ತಿಯಾ ಮೆಸ್ಸಿಯಾಬಿ ನ್ಹಯ್ ಹೊಲ್ಯಾರ್, ಎಲಿಯಾಬಿ ನ್ಹಯ್ ಹೊಲ್ಯಾರ್, ಅನಿ ಪ್ರವಾದಿಬಿ ನ್ಹಯ್ ಹೊಲ್ಯಾರ್, ತಸೆ ಜಾಲ್ಯಾರ್, ತಿಯಾ ಕಶೆ ಬಾಲ್ತಿಮ್ ದಿತೆಯ್?” ");
INSERT INTO kans_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ತನ್ನಾ ಜುವಾಂವಾನ್ “ಮಿಯಾ ಪಾನಿಯಾನ್ ಬಾಲ್ತಿಮ್ ದಿತಾ, ಖರೆ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಎಕ್ ಮಾನುಸ್ ಹಾಯ್ ತೆಕಾ ತುಮಿ ಒಳ್ಕಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ತೊ ಮಾಜ್ಯಾ ಮಾನಾ ಯೆತಾ, ತ್ಯೆಚ್ಯಾ ಪಾಂಯಾತ್ಲ್ಯಾ ವ್ಹಾನಾಂಚಿ ನಾಡಿ ಸೊಡ್ತಲಿ ಸೈತ್ ಮಾಕಾ ಕಿಮ್ಮತ್ ನಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ಜೊರ್ದಾನ್ ನ್ಹಯ್ಚ್ಯಾ ದಿಸ್ ಉಗಾವ್ತಲ್ಲ್ಯಾ ದಿಕ್ಕಾತ್ ಬೆಥನಿ ಮನ್ತಲೆ ಗಾಂವ್ ಹಾಯ್. ಹಿ ಸಗ್ಳಿ ಗೊಸ್ಟಿಯಾ ಘಡ್ಲ್ಯಾ. ತೆಚ್ ಜುವಾಂವ್ ಲೊಕಾಕ್ನಿ ಬಾಲ್ತಿಮ್ ದಿವ್ಕ್ ಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ದುಸ್ರ್ಯಾ ದಿಸಿ ಅಪ್ನಾಕ್ಡೆ ಯೆತಲ್ಯಾ ಜೆಜುಕ್ ಬಗುನ್ ಜುವಾಂವಾನ್, “ಬಗಾ ಹೆ ದೆವಾಚೆ ಬೊಕ್ಡು ಜಗಾಚೆ ಪಾಪ್ ಕಾಡುನ್ ಟಾಕ್ತಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ಮಾಜ್ಯಾ ಮಾನಾ ಎಕ್ಲೊ ಯೆತಾ, ತೊ ಮಾಜ್ಯಾನ್ಕಿ ಮೊಟೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಮಿಯಾ ಉಪ್ಜುಚ್ಯಾ ಅದ್ದಿಚ್ ಹೊತ್ತೊ. ಮನುನ್ ಮಿಯಾ ಸಾಂಗಟಲ್ಲೆ ಹೆಚ್ಯಾಚ್ ವಿಶಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ತೊ ಕೊನ್ ಮನುನ್ ಮಾಕಾಚ್ ಗೊತ್ತ್ ನತ್ತೆ, ಖರೆ ಮಿಯಾ ಪಾನಿಯಾನಿ ಬಾಲ್ತಿಮ್ ದಿವ್ನ್ ತ್ಯೆಚ್ಯಾ ವಿಶಯಾತ್ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ತೆಚಿ ವಳಕ್ ಕರುನ್ ದಿವ್ಕ್ ಮನುನ್ ಯೆಲಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ಅನಿ ಜುವಾಂವಾನ್ ಅಪ್ನಾಚಿ ಸಾಕ್ಷಿ ದಿಲ್ಯಾನ್; ದೆವಾಚೊ ಆತ್ಮೊ ಪಾರಿವಾಳಾಚ್ಯಾ ರುಪಾರ್ ಸರ್‍ಗಾ ವೈನಾ ಉತರ್‍ತಲೆ, ಅನಿ ತೆಚೆ ವರ್ತಿ ಬಸಲ್ಲೆ ಮಿಯಾ ಬಗಟ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ಜಾಲ್ಯಾರ್‍ಬಿ ತೊ ಕೊನ್ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ನತ್ತೆ. ಖರೆ ಮಾಕಾ ಪಾನಿಯಾನ್ ಬಾಲ್ತಿಮ್ ದಿವ್ಕ್ ಮನುನ್ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾ ದೆವಾನ್, ಕೊನಾಚ್ಯಾ ವರ್ತಿ ದೆವಾಚೊ ಆತ್ಮೊ ಉತರ್‍ತಲೊ ತುಕಾ ದಿಸ್ತಾ, ತೊಚ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಬಾಲ್ತಿಮ್ ದಿತಲೊ ಮನುನ್ ಮಾಕಾ ಸಾಂಗಟಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ತನ್ನಾ ಜುವಾಂವಾನ್, “ಮಿಯಾ ತೆ ಬಗಟ್ಲೊ ಅನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ತೊಚ್ ದೆವಾಚೊ ಲೆಕ್” ಮಟ್ಲ್ಯಾನ್ ಅನಿ ಸಾಕ್ಷಿ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ಜುವಾಂವ್ ದುಸ್ರೆಂದಿಸಿ ಅನಿ ಎಗ್ದಾ ಅಪ್ಲ್ಯಾ ದೊಗೆ ಜಾನಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಥೈ ಇಬೆ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ತನ್ನಾ ಜುವಾಂವಾನ್ ಜೆಜು ಥೈತ್ನಾ ಯೆತಲೊ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ, “ಹೆ ದೆವಾಚೆ ಬೊಕ್ಡು!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ಹ್ಯಾ ತ್ಯೆಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುನ್ ತಿ ದೊಗ್‍ಜಾನಾ ಶಿಸಾ ಜೆಜುಚಿ ಫಾಟ್ ಧರುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ಜೆಜು ಫಾಟಿ ಪರ್ತುನ್ ಬಗುನ್ ಅನಿ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಫಾಟ್ನಾ ಯೆತಲೆ ಬಗುನ್ “ತುಮ್ಕಾ ಕಾಯ್ ಪಾಜೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ “ರಾಬ್ಬಿ ತಿಯಾ ಖೈ ರ್‍ಹಾತೆಯ್?” ರಾಬ್ಬಿ ಮಟ್ಲ್ಯಾರ್ ಗುರುಜಿ. ");
INSERT INTO kans_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ತನ್ನಾ ಜೆಜುನ್, “ಯೆವಾ, ಅನಿ ತುಮಿ ಬಗ್ತ್ಯಾಸಿ”, ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ಸಾಂಚೆಕ್ಡೆ ಚಾರ್ ಘಂಟೆ ಹೊಲ್ಲೆ. ಅಶೆ ತೆನಿ ತ್ಯೆಚ್ಯಾ ಫಾಟ್ನಾ ಗೆಲ್ಯಾನಿ, ಅನಿ ತೊ ಖೈ ರ್‍ಹಾತಾ ಮನುನ್ ಬಗಟ್ಲ್ಯಾನಿ, ಅನಿ ತ್ಯಾ ದಿಸಿ ದಿಸ್ ಬುಡಿ ಪತರ್ ತ್ಯೆಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ಜುವಾಂವಾಚೆ ಆಯ್ಕುನ್ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಗೆಲ್ಲ್ಯಾ ದೊಗಾ ಶಿಸಾನಿತ್ಲೊ ಎಕ್ಲೊ ಸಿಮಾವ್ ಪೆದ್ರುಚೊ ಭಾವ್ ಅಂದ್ರು ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ತೊ ಅಪ್ನಾಚ್ಯಾ ಭಾವಾ ಸಿಮಾವಾಕ್ ಭೆಟಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ, “ಅಮ್ಕಾ ಮೆಸ್ಸಿಯಾ ಗಾವ್ಲೊ” ಮಟ್ಲ್ಯಾನ್ ಮೆಸ್ಸಿಯಾ, ಮಟ್ಲ್ಯಾರ್ ಕ್ರಿಸ್ತ್. ಮನುನ್ ತೆಕಾ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ಮಾನಾ ತೆನಿ ಸಿಮಾವಾಕ್ ಜೆಜುಕ್ಡೆ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಯೆಲೊ. ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ ಬಗುನ್, “ತಿಯಾ ಜುವಾಂವಾಚೊ ಲೆಕ್ ಸಿಮಾವ್, ಖರೆ ತುಕಾ ಹ್ಯಾನ್ ಫಿಡೆ ಕೆಫಾಸ್ ಮನ್ತಾತ್”. ಕೆಫಾಸ್ ಮಟ್ಲ್ಯಾರ್, ಪೆದ್ರು ನಾಹೊಲ್ಯಾರ್, ಗುಂಡೊ. ");
INSERT INTO kans_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ದುಸ್ರೆಂದಿಸಿ ಜೆಜುನ್ ಗಾಲಿಲಿಯಾಕ್ ಜಾವ್ಚೆ ಮನುನ್ ನಿರ್‍ದಾರ್ ಕರ್ಲ್ಯಾನ್, ತನ್ನಾ ತೆಕಾ ಫಿಲಿಪ್ ಗಾವ್ಲೊ. ತೆಕಾ ಜೆಜುನ್ “ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ಫಿಲಿಪ್‍ಬಿ ಬೆತ್ಸಾಯಿದಾ ಮನ್ತಲ್ಯಾ, ಅಂದ್ರು, ಅನಿ ಪೆದ್ರುಂಚ್ಯಾ ಶಾರಾಚೊಚ್. ");
INSERT INTO kans_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ಫಿಲಿಪಾಕ್ ನಾಥಾನಾಯೆಲ್ ಗಾವ್ಲೊ, ತನ್ನಾ ಫಿಲಿಪಾನ್ ತೆಕಾ, “ಮೊಯ್ಜೆನ್ ಅಪ್ನಾಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ ಅನಿ ಪ್ರವಾದ್ಯಾನಿ ಅಪ್ನಾಚ್ಯಾ ಪುಸ್ತಕಾತ್ನಿ ಕೊನಾಚ್ಯಾ ವಿಶಯಾತ್ ಲಿವಲ್ಲ್ಯಾನಾತ್ ತೊ ಅಮ್ಕಾ ಗಾವ್ಲೊ. ತೊ ನಜರೆತಾತ್ಲೊ ಜೆಜು ಜುಜೆಚೊ ಲೆಕ್” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ತನ್ನಾ ನಾಥಾನಾಯೆಲಾನ್, “ನಜರೆತಾತ್ನಾ ಕಾಯ್ ತರ್ ಬರೆ ಮನ್ತಲೆ ಯೆವ್ಕ್ ಹೊತಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ಫಿಲಿಪಾನ್ ತೆಕಾ “ಯೆ ಅನಿ ಬಗ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ಅಪ್ನಾಕ್ಡೆ ಯೆತಲ್ಯಾ ನಾಥಾನಾಯೆಲಾಕ್ ಬಗುನ್ ಜೆಜುನ್, “ಹ್ಯೊ ಎಕ್ ಖರೊ ಇಸ್ರಾಯೆಲ್‍ಕಾರ್, ತ್ಯೆಚ್ಯಾ ಭುತ್ತುರ್ ಕಸ್ಲಿಬಿ ಚುಕ್ ನಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ತನ್ನಾ ನಾಥಾನಾಯೆಲಾನ್ ಜೆಜುಕ್, “ತಿಯಾ ಮಾಕಾ ಕಶೆ ವಳಕ್ತೆಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ಜೆಜುನ್ ತೆಕಾ, “ಫಿಲಿಪಾ ತುಕಾ ಬಲ್ವುಚ್ಯಾ ಅದ್ದಿ ಮಿಯಾ ತುಕಾ ಅಂಜುರಾಚ್ಯಾ ಝಾಡಾಚ್ಯಾ ಬುಡಿ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ಬಗಟ್ಲೊ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ತನ್ನಾ ನಾಥಾನಾಯೆಲಾನ್, “ಗುರುಜಿ, ತಿಯಾ ದೆವಾಚೊ ಲೆಕ್! ಇಸ್ರಾಯೆಲಾಚೊ ರಾಜಾ!” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ಜೆಜುನ್ ತೆಕಾ, “ಅಂಜುರಾಚ್ಯಾ ಝಾಡಾ ಬುಡಿ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ಮಿಯಾ ತುಕಾ ಬಗಟ್ಲೊ ಮನುನ್ ಸಾಂಗಟಲ್ಲ್ಯಾಸಾಟಿ ತಿಯಾ ಮಾಕಾ ವಿಶ್ವಾಸ್ ಕರ್‍ತೆ ಕಾಯ್? ಹೆಚ್ಯಾನ್ಕಿಬಿ ಮೊಟಿ ಕಾಮಾ ತಿಯಾ ಬಗ್ತೆಯ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ಮಾನಾ ತೆನಿ ತೆಂಕಾ, “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್! ಸಾಂಗ್ತಾ: ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಚ್ಯಾ ವರ್ತಿ ಸರ್ಗ್ ಉಗ್ಡುನ್ ದೆವಾಚಿ ದುತಾ ಚಡ್ತಲೆ ಅನಿ ಉತರ್ತಲೆ ತುಮಿ ಬಗ್ತ್ಯಾಶಿ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ದೊನ್ ದಿಸ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಗಾಲಿಲಿಯಾ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾತ್ಲ್ಯಾ ಕಾನಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಎಕ್ ಲಗಿನ್ ಹೊತ್ತೆ ಜೆಜುಚಿ ಬಾಯ್ ಥೈ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ಜೆಜುಕ್, ಅನಿ ತ್ಯೆಚ್ಯಾ ಶಿಸಾಕ್ನಿಬಿ ತ್ಯಾ ಲಗ್ನಾಕ್ ಬಲ್ವಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ವಾಯ್ನ್ ಸರಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುಚ್ಯಾ ಬಾಯ್ನ್ ಜೆಜುಕ್,“ತೆಂಚ್ಯಾಕ್ಲಿ ಸಗ್ಳಿ ವಾಯ್ನ್ ಸರ್ಲಿ” ಮನುನ್ ಸಾಂಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ತನ್ನಾ ಜೆಜುನ್, “ಹೆ ಬಾಯ್, ಮಿಯಾ ಕಾಯ್ ಕರುಚೆ? ಮನುನ್ ತಿಯಾ ಮನುಲೆ? ಮಾಜೊ ನೆಮಸಲ್ಲೊ ಎಳ್ ಅಜುನ್ ಯೆವ್ಕ್ ನಾ” ");
INSERT INTO kans_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ತನ್ನಾ ಜೆಜುಚ್ಯಾ ಬಾಯ್ನ್ ಆಳಾಕ್ನಿ, “ತೊ ಕಾಯ್ ಸಾಂಗ್ತಾ ತೆ ತುಮಿ ಕರಾ” ಮನುನ್ ಸಾಂಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ಜುದೆವ್ ಲೊಕಾಂಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಸಾರ್ಕೆ ಹಾತ್-ಪಾಯ್ ಧುವ್ನ್ ಪವಿತ್ರ್ ಕರುನ್ ಘೆವ್ಕ್ ಮನುನ್ ಪಾನಿ ಭರುನ್ ಥವ್ತಲೆ, ಸಾ, ಮೊಟೆ ಗುಂಡ್ಯಾಂಚೆ ಢೊನೆ ಅಯ್ಸಿ ತೆ ಎಕ್ಸೆ ವಿಸ್ ಲಿಟರ್ ಪಾನಿ ಮಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ಜೆಜುನ್ ಆಳಾಕ್ನಿ, “ತ್ಯಾ ಢೊನ್ಯಾತ್ನಿ ಪಾನಿ ವೊತುನ್ ಭರಾ” ಮಟ್ಲ್ಯಾನ್ ತೆನಿ ತ್ಯಾ ಢೊನ್ಯಾತ್ನಿ ಉಲ್ಲೊಬಿ ಜಾಗೊ ಥೈ ನಸ್ತಾನಾ ಖಳ್ಕಳಿತ್ ಪಾನಿ ಭರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ಮಾನಾ ತೆನಿ ತೆಂಕಾ, “ಅತ್ತಾ ತ್ಯಾತುರ್‍ಲೆ ಉಲ್ಲೆ ಪಾನಿ ಕಾಡಾ, ಅನಿ ಜೆವ್ನಾಚಿ ಯವಸ್ತಾ ಕರ್‍ತಲ್ಯಾ ಮಾನ್ಸಾಕ್ಡೆ ಘೆವ್ನ್ ಜಾವಾ”, ತೆನಿ ತೆ ಪಾನಿ ಜೆವ್ನಾಚಿ ಯವಸ್ತಾ ಕರ್‍ತಲ್ಯಾ ಮಾನ್ಸಾಕ್ಡೆ ನ್ಹೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ತೆ ಪಾನಿ ವಾಯ್ನ್ ಹೊಲ್ಲೆ ತ್ಯಾ ಮಾನ್ಸಾನ್ ತೆ ಚಾಟುನ್ ಬಗಟ್ಲ್ಯಾನ್, ಹೆ ವಾಯ್ನ್ ಖೈತ್ನಾ ಯೆಲ್ಲೆ ಮನುನ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಗೊತ್ತ್ ನತ್ತೆ .ಖರೆ ತೆ ಪಾನಿ ಕಾಡಲ್ಲ್ಯಾ ಆಳಾಕ್ನಿ ಗೊತ್ತ್ ಹೊತ್ತೆ, ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ನ್ಹವ್ರ್ಯಾಕ್ ಬಲ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ಅನಿ “ಸಗ್ಳಿ ಲೊಕಾ ಅದ್ದಿ ಬರೊ ವಾಯ್ನ್ ವಾಟ್ತ್ಯಾತ್, ಪಾವ್ನ್ಯಾನಿ ಪಿವ್ನ್ ಖುಶಿ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಸಾದ್ರನಾಚೊ ವಾಯ್ನ್ ವಾಟ್ತ್ಯಾತ್, ಖರೆ ತಿಯಾ ಅಜುನ್‍ಬಿ ಬರೊ ವಾಯ್ನ್ ಥವ್ಲೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ಜೆಜುನ್ ಗಾಲಿಲಿಯಾತ್ಲ್ಯಾ ಕಾನಾ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಪಯ್ಲೆಚೆ ಅಜಾಪ್ ಕರ್ಲ್ಯಾನ್, ಥೈ ತೆನಿ ಅಪ್ನಾಚಿ ಮಹಿಮಾ ದಾಕ್ವುನ್ ದಿಲ್ಯಾನ್, ಅನಿ ತೆಚಿ ಶಿಸಾ ತೆಚ್ಯಾ ವರ್ತಿ ತೆಕಾ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ಹೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜು ತೆಚಿ ಬಾಯ್, ಭಾವಾ, ಅನಿ ಶಿಸಾ ಕಫರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಗೆಲೊ, ಅನಿ ಎಕ್ ಉಲ್ಲಿ ದಿಸಾ ಥೈಚ್ ರ್‍ಹಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ಜುದೆವಾಂಚೊ ಪಾಸ್ಕಾಚೊ ಸನ್ ತೊಂಡಾರ್ ಯೆಲ್ಲೊ, ತಸೆ ಮನುನ್ ಜೆಜು ವೈರ್ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ಥೈ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಲೊಕಾ, ಗೊರಾ, ಬಕ್ರಿ, ಅನಿ ಪಾರಿವಾಳಾ ಇಕ್ತಲೆ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ಮೆಜಾ ವರ್ತಿ ಬಸುನ್ ಪೈಶ್ಯಾಂಚಿ ಅದ್ಲಾ-ಬದ್ಲಿ ಕರ್‍ತಲೊ ಯಾವಾರ್ ಕರ್‍ತಲಿ ಲೊಕಾಬಿ ಅಪ್ನಾಚ್ಯಾ ಜಾಗ್ಯಾ ವೈನಿ ಬಸಲ್ಲಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ತನ್ನಾ ಜೆಜುನ್ ಬಾರಿಕ್- ಬಾರಿಕ್ ದೊರಿಯಾನಿ ಎಕ್ ಬಾರ್‍ಕೊಲ್ ಕರ್ಲ್ಯಾನ್, ಅನಿ ಸಗ್ಳ್ಯಾ ಜನಾವರಾಕ್ನಿ, ಬಕ್ರ್ಯಾಕ್ನಿ, ಗೊರಾಕ್ನಿ ಭಾಯ್ರ್ ಹಂಬಡ್ಲ್ಯಾನ್, ಪೈಸ್ಯಾಂಚೊ ಯಾವಾರ್ ಕರ್‍ತಲ್ಯಾಂಚಿ ಮೆಜಾ ಪಾಡ್ವುನ್ ಘಾಟ್ಲ್ಯಾನ್ ಅನಿ ತೆಂಚೆ ಪೈಸೆ ಮಾಳ್ಬರ್ ಕರ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ಅನಿ ಪಾರಿವಾಳಾ ಇಕ್ತಲ್ಯಾಕ್ನಿ, ತೆಂಕಾ ಹಿತ್ನಾ ಭಾಯ್ರ್ ಕಾಡಾ! ಮಾಜ್ಯಾ ಬಾಬಾಚೆ ಘರ್ ಬಾಜಾರ್ ಭರ್‍ತಲೊ ಜಾಗೊ ಕರುನ್ ಥವ್ನಕಾಶಿ! ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ತ್ಯೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಪವಿತ್ರ್ ಪುಸ್ತಕ್, “ಮಾಜ್ಯಾ ದೆವಾ ತುಜ್ಯಾ ಘರಾಸಾಟ್ನಿ ಮನುನ್ ಹೊತ್ತಿ ಮಾಜಿ ಉರ್ಬಾ ಎಕ್ ಆಗಿ ಸರ್ಕೆ ಮಾಜ್ಯಾ ಭುತ್ತುರ್ ಜಳುಲಾ” ಮನ್ತಲ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚಿ ಯಾದ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ಜುದೆವಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನಿ ತೆಚ್ಯಾಕ್ಡೆ ಯೆವ್ನ್ ತಿಯಾ ಕಸ್ಲೆ ಕಾಮ್ ಕರುನ್ ದಾಕ್ವುಕ್ ಹೊತಾ ತೆಚ್ಯಾ ವೈನಾ ತುಕಾ ಅದಿಕಾರ್ ಹಾಯ್ ಮನುನ್ ಸಾಬಿತ್ ಹೊತಾ. ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ತನ್ನಾ ಜೆಜುನ್, “ಹಿ ದೆವಾಚಿ ಗುಡಿ ಕೊಸ್ಳುನ್ ಘಾಲಾ, ಅನಿ ತಿನುಚ್ ದಿಸಾತ್ನಿ ಮಿಯಾ ತಿ, ಪರ್ತುನ್ ಭಾಂದ್ತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ತನ್ನಾ ತೆನಿ, “ಹಿ ದೆವಾಚಿ ಗುಡಿ ಭಾಂದುಕ್ ಚಾಳಿಸಾಚ್ಯಾ ವರ್ತಿ ಸಾ ವರ್ಸಾಲಾಗಲ್ಲಿ! ಪರ್ತುನ್ ತಿನ್ ದಿಸಾತ್ನಿ ತಿಯಾ ಹಿ ದೆವಾಚಿ ಗುಡಿ ಭಾಂದ್ತೆಯ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ಖರೆ ಜೆಜು ಖಲ್ಯಾ ಗುಡಿಚೆ ಬೊಲುಲಾಗಲ್ಲೊ ಅಪ್ನಾಚ್ಯಾ ಸ್ವಂತ್ ಆಂಗಾಚ್ಯಾ ವಿಶಯಾತ್ ");
INSERT INTO kans_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ತೆಚೆಸಾಟ್ನಿ ತೊ ಮರುನ್ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತ್ಯೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ತ್ಯೆಚ್ಯಾ ಹ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚಿ ಯಾದ್ ಹೊತ್ತಿ, ಅನಿ ತೆನಿ ಪವಿತ್ರ್ ಪುಸ್ತಕಾ ವರ್ತಿ, ಅನಿ ಜೆಜುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚ್ಯಾ ಎಳಾರ್ ಜೆರುಜಲೆಮಾತ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ, ತೆನಿ ಕರಲ್ಲಿ ಅಜಾಪಾ ಬಗುನ್ ಲೈ ಲೊಕಾ ತೆಚೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರುಕ್ ಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ಖರೆ ಜೆಜುಕ್ ತೆಚ್ಯಾ ವಿಶ್ವಾಸಾಚ್ಯಾ ವರ್ತಿ ಅಪ್ನಾಕ್ ಸೊಡುನ್ ದಿವ್ಕ್ ನಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಚ್ಯೆ ಸಗ್ಳೆ ಗೊತ್ತ್ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ತೆಂಚ್ಯಾ ವಿಶಯಾತ್ ತೆಕಾ ಕೊನ್ಬಿ ಸಾಂಗುಚೆ ಮನುನ್ ನತ್ತೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಂಚ್ಯಾ ಮನಾತ್ನಿ ಕಾಯ್ ಹಾಯ್ ಮನುನ್ ಜೆಜುಕ್ ಗೊತ್ತ್ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ಎಕ್ ಜುದೆವಾಚೊ ಮುಖಂಡ್ ಹೊತ್ತೊ. ಹೆಚೆ ನಾಂವ್ ನಿಕೊದೆಮ್, ಅನಿ ತೊ ಫಾರಿಜೆವಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ಲೊ ಮುಖಂಡ್ ಹೊಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ಎಕ್ ದಿಸ್ ರಾಚ್ಚೆ ನಿಕೊದೆಮ್ ಜೆಜುಕ್ಡೆ ಗೆಲೊ, ಅನಿ ಜೆಜುಕ್, “ರಬ್ಬಿ ತಿಯಾ ದೆವಾನ್ ಧಾಡುನ್ ದಿಲ್ಲೊ ಎಕ್ ಗುರುಜಿ ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್, ದೆವ್ ಫಾಟಿರ್ ರ್‍ಹಾಲ್ಯಾ ಶಿವಾಯ್ ಕೊನಾಕ್ಬಿ ತಿಯಾ ಕರ್‍ತೆ ತಸ್ಲಿ ಅಜಾಪಾ ಕರುಕ್ ಹೊಯ್ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ಜೆಜುನ್ ತೆಕಾ, “ಮಿಯಾ ತುಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗ್ತಾ; ಅನಿ ಎಗ್ದಾ ಉಪ್ಜುನ್ ಯೆಲ್ಯಾ ಶಿವಾಯ್ ಕೊನಾಕ್ಬಿ ದೆವಾಚೆ ರಾಜ್ ಬಗುಕ್‍ ಹೊಯ್ನಾ” ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ತನ್ನಾ ನಿಕೊದೆಮಾನ್, “ಎಕ್ ಮೊಟ್ಯಾ ಮಾನ್ಸಾಕ್, ಅನಿ ಎಗ್ದಾ ಉಪ್ಜುನ್ ಯೆತಲೆ ಮಟ್ಲ್ಯಾರ್, ಕಶೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್, ಅನಿ “ಅನಿ ಪರ್ತುನ್ ಬಾಯ್ಚ್ಯಾ ಪೊಟಾತ್ ಗುಸುನ್ ದೊನ್ವೆಪಟಿ ಉಪಜ್‍ ಘೆವ್ಕ್ ತರ್ ಹೊಯ್ನಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ತುಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ಪಾನಿಯಾನ್, ಅನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಅನಿ ಪರ್ತುನ್ ಉಪ್ಜುನ್ ಯೆಲ್ಯಾ ಶಿವಾಯ್ ಕೊನಾಕ್ಬಿ ದೆವಾಚ್ಯಾ ರಾಜಾತ್ ಭುತ್ತುರ್ ಜಾವ್ಕ್ ಹೊಯ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ಎಕ್ ಮಾನುಸ್ ಆಂಗಾ-ಮಾಸಾನಿ ಮಾನ್ಸಾಚ್ಯಾ ಪೊಟಾನ್ ಉಪಜ್ತಾ, ಖರೆ ಅತ್ಮಿಕ್ ರಿತಿನ್ ತೊ ಆತ್ಮ್ಯಾಚ್ಯಾ ವೈನಾ ಉಪಜ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ತಿಯಾ, ಅನಿ ಎಗ್ದಾ ಉಪ್ಜುಕ್ ಜಾಯ್ ಮನುನ್ ಮಿಯಾ ಮಟ್ಲೊ ಮನುನ್ ತಿಯಾ ಗಡ್ಬಡುನಕೊ. ");
INSERT INTO kans_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ವಾರೊ ಅಪ್ನಾಕ್ ಕಶೆ ಪಾಜೆ ತಶೆ ಖೆಳ್ತಾ ತೆಚೊ ಅವಾಜ್ ಎವ್ಡೊಚ್ ತುಕಾ ಆಯ್ಕೊ ಯೆತಾ, ಖರೆ ತೊ ಖೈತ್ನಾ ಯೆವ್ಲಾ, ಅನಿ ಖೈ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ತುಕಾ ಗೊತ್ತ್ ರ್‍ಹಾಯ್ನಾ ಅಸೆಚ್ ಸಗ್ಳಿ ಲೊಕಾ ಆತ್ಮ್ಯಾಚ್ಯಾ ವೈನಾ ಉಪಜ್ತಾತ್‍. ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“ಹೆ ಸಗ್ಳೆ ಕಶೆ ಹೊವ್ಕ್ ಹೊತಾ?” ಮನುನ್ ನಿಕೊದೆಮಾನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ಜೆಜುನ್ ತೆಕಾ,“ತಿಯಾ ಇಸ್ರಾಯೆಲಾತ್ ಎಕ್ ಮೊಟೊ ಶಿಕ್ವುನಾರೊ ಮಾನುಸ್, ಹೆ ತುಕಾ ಗೊತ್ತ್, ನಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ಮಿಯಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ಅಮ್ಕಾ ಕಾಯ್ ಗೊತ್ತ್ ಹಾಯ್ ತೆಚ್ ಸಾಂಗ್ತಾವ್, ಅನಿ ಅಮಿ ಕಾಯ್ ಬಗಟ್ಲಾವ್ ತ್ಯೆಚ್ಯಾ ವಿಶಯಾತುಚ್ ಅಮಿ ಸಾಕ್ಷಿ ದಿತಾಂವ್. ಖರೆ ಅಜುನ್‍ಬಿ ತುಮಿ ಕೊನ್ಬಿ ಅಮಿ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯ್ಯಾ ತುಮಿ ಸ್ವಿಕಾರ್ ಕರಿನ್ಯಾಸಿ.” ");
INSERT INTO kans_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ಹ್ಯಾ ಜಗಾತ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾಚ್ಯಾ ಬದಲ್ ಮಿಯಾ ಬೊಲ್ತಾನಾಚ್ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾಸಿ, ಅನಿ ಮಿಯಾ ತುಮ್ಕಾ ಸರ್ಗಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗಟ್ಲ್ಯಾರ್ ತುಮಿ ಕಶೆ ವಿಶ್ವಾಸ್ ಕರ್‍ತ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ಸರ್‍ಗಾ ವೈನಾ ಉತ್ರುನ್ ಯೆಲ್ಲ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ಎಕ್ಲ್ಯಾಕ್ ಸೊಡುನ್, ಅನಿ ಕೊನ್ಬಿ ಸರ್ಗಾತ್ ಗೆಲ್ಲೊ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ಕಶೆ ಮೊಯ್ಜೆನ್ ಡಂಗ್ಳಿತ್ ಪಿತ್ಳಿಚೊ ಸಾಪ್ ಕರುನ್ ಎಕ್ ಖಾಂಬ್ಯಾವರ್ತಿ ವೈರ್ ಕರುನ್‍ ಲಾವಲ್ಲ್ಯಾನ್, ತಸೆಚ್ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್‍ಬಿ ವೈರ್ ಉಕ್ಲುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ತೆಚೆಸಾಟ್ನಿ ತೆಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಲ್ಲ್ಯಾ ಹರಿ ಎಕ್ಲ್ಯಾಕ್ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ದೆವಾನ್ ಹ್ಯಾ ಜಗಾಚೊ ಕವ್ಡೊ ಪ್ರೆಮ್ ಕರ್ಲ್ಯಾನ್ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್ ಅಪ್ನಾಚ್ಯಾ ಎಕ್ಲ್ಯಾಚ್ ಎಕ್ಲ್ಯಾ ಲೆಕಾಕ್ ತೆನಿ ಜಗಾಸಾಟ್ನಿ ದಿಲ್ಯಾನ್. ಅನಿ ತ್ಯೆಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಲ್ಲೆ ಕೊನ್ಬಿ ನಾಸ್ ಹೊವ್ಚೆ ನ್ಹಯ್, ತೆಂಕಾ ಕನ್ನಾಬಿ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವುಚೆ ಮನುನ್ ತೆನಿ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ದೆವಾನ್ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಕ್ ಹ್ಯಾ ಜಗಾತ್ ಇಚಾರ್‍ನಿ ಕರುಕ್ ಮನುನ್ ಧಾಡುನ್ ದಿವ್ಕ್ ನಾ ಜಗಾಚೊ ರಾಕನ್ದಾರ್ ಹೊವ್‍ಸಾಟಿ ಮನುನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ಲೆಕಾಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್, ಕರ್‍ತಲ್ಯಾಂಚಿ ಇಚಾರ್‍ನಿ ಹೊಯ್ನಾ ಜೆ ಕೊನ್ ವಿಶ್ವಾಸ್, ಕರಿನಾತ್ ತೆಂಚಿ ಅದ್ದಿ ಇಚಾರ್‍ನಿ ಕರುನ್ ಹೊಲಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ದೆವಾಚ್ಯಾ ಎಕ್ಲ್ಯಾಚ್ ಲೆಕಾಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್, ಕರುಕ್‍ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ತೊ ನ್ಯಾಯಾಚೊ ನಿರ್‍ನಯ್ ಅಸೊ ಹೊತಾ; ಜಗಾತ್ ಉಜ್ವೊಡ್ ಯೆಲೊ ಖರೆ ಲೊಕಾನಿ ಉಜ್ವೊಡಾಚ್ಯಾನ್ಕಿ ಕಾಳ್ಕಾಚೊ ಲೈ ಪ್ರೆಮ್ ಕರ್ಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಂಚಿ ಕಾಮಾಚ್ ಬುರ್ಶಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ಜೆ ಕೊನ್ ಬುರ್ಶಿ ಕಾಮಾ ಕರ್‍ತಾತ್, ತೆನಿ ಉಜ್ವೊಡಾಕ್ ಯೆಯ್ನಾತ್, ತೆನಿ ಉಜ್ವೊಡಾಕ್ ಧುರ್ ಕರ್‍ತಾತ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಂಚಿ ಬುರ್ಶಿ ಕಾಮಾ ದಾಕ್ವುನ್ ದಿತಲೆ ತೆಂಕಾ ಮನ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ಖರೆ ಜೆ ಕೊನ್ ಖರೆ ಹಾಯ್ ತೊ ಉಜ್ವೊಡಾಕ್ಡೆ ಯೆತಾ. ಅನಿ ಅಶೆ ಉಜ್ವೊಡಾಕ್ ದಿಸುನ್ ಯಂವ್ದಿತ್ ತಸೆ ತೆಚಿ ಕಾಮಾ ದೆವಾನ್ ಕರ್‍ಲ್ಯಾನಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ಹೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜು, ಅನಿ ತೆಚಿ ಶಿಸಾ ಜುದೆಯಾ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾಕ್ ಗೆಲ್ಯಾನಿ. ಥೈ ಜೆಜು ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಉಲ್ಲೊ ಎಳ್ ರ್‍ಹಾಲೊ, ಅನಿ ಬಾಲ್ತಿಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ಸಾಲಿಮ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ಎನೊನ್ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಪಾಜೆ ತವ್ಡೆ ಪಾನಿ ಹೊತ್ತೆ, ತಸೆ ಮನುನ್ ಜುವಾಂವ್ ಥೈ ಲೊಕಾಕ್ನಿ ಬಾಲ್ತಿಮ್ ದಿವ್ಕ್ ಲಾಗಲ್ಲೊ, ಲೊಕಾ ಯೆವ್ನ್ ಬಾಲ್ತಿಮ್ ಘೆವ್‍ಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ಹೆ ಸಗ್ಳೆ ಜುವಾಂವಾಕ್ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಲುಚ್ಯಾ ಅದ್ದಿ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ಉಲ್ಲಿ ಜುವಾಂವಾಚಿ ಶಿಸಾ ಎಕ್ ಜುದೆವಾಕ್ಡೆ ಧಾರ್ಮಿಕ್ ರಿತಿಚ್ಯಾ ನಿತಳಾಚ್ಯಾ ವಿಶಯಾತ್ ವಾದ್ ಖೆಳುಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ತನ್ನಾ ತೆನಿ ಜುವಾಂವಾಕ್ಡೆ ಗೆಲ್ಯಾನಿ, ಅನಿ “ಗುರುಜಿ, ತುಕಾ ಯಾದ್ ಹಾಯ್ ಕಾಯ್ ಜೊರ್ದಾನಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಿಸ್ ಉಗಾವ್ತಲ್ಯಾ ದಿಕ್ಕಾತ್ ತೊ ಮಾನುಸ್ ತುಕಾ ಯಾದ್ ಹಾಯ್ ಕಾಯ್? ಅನಿ ತ್ಯೆಚ್ಯಾ ವಿಶಯಾತ್ ತಿಯಾ ಸಾಕ್ಷಿ ದಿಲ್ಲೆ ಅನಿ ಸಗ್ಳೆ ಲೊಕಾ ತೆಚೆಕ್ಡೆ ಜಾವ್ಲ್ಯಾತ್!” ತೊ ಅತ್ತಾ ಬಾಲ್ತಿಮ್ ದಿವ್‍ಲಾಲಾ, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ತನ್ನಾ ಜುವಾಂವಾಕ್ ಜವಾಬ್ ದಿಲ್ಲ್ಯಾನ್, “ದೆವಾನ್ ದಿಲ್ಯಾ ಶಿವಾಯ್ ಕೊನಾಕ್ಬಿ ಕಾಯ್ಬಿ ಗಾವಿನಾ”. ");
INSERT INTO kans_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ತೆಂಕಾ ಜುವಾಂವಾಕ್ ಸಾಂಗ್ಲ್ಯಾನ್ ಮಿಯಾ ಮೆಸ್ಸಿಯಾ ನ್ಹಯ್, ಮಾಕಾ ತ್ಯೆಚ್ಯಾನ್ಕಿ ಫಿಡೆ- ಫಿಡೆ ಧಾಡಲ್ಲೆ ಹೊತ್ತೆ ಮನುನ್ ಸಾಂಗ್ಲಾ ಮನ್ತಲ್ಯಾಕ್ ತುಮಿಚ್ ಸಾಕ್ಷಿ. ");
INSERT INTO kans_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ನ್ಹವ್ರೊ ಮಟ್ಲ್ಯಾರ್, ಕೊನ್ ಮಟ್ಲ್ಯಾರ್ ತೆಕಾ ನ್ಹವ್ರಿ ಸಮಂದ್ ಪಡಲ್ಲಿ ರ್‍ಹಾತಾ; ಖರೆ ನ್ಹವ್ರ್ಯಾಚ್ಯಾ ದೊಸ್ತಾಕ್ ನ್ಹವ್ರ್ಯಾಚೊ ಧನ್ ಅಪ್ನಾಚ್ಯಾ ಕಾನಾತ್ ಪಡಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ಲೈ ಕುಶಿ ಹೊತಾ. ತೊ ತ್ಯೆಚ್ಯಾ ಬಾಜುಕುಚ್ ಇಬೆರಾಲ್ಲೊ ರ್‍ಹಾತಾ. ಹ್ಯಾ ಥರಿನ್ ಮಾಜಿ ಸ್ವತಾಚಿ ಕುಶಿ ಪುರಾ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","“ತೊ ಮೊಟೊ ಹೊವ್ಕ್ ಪಾಜೆ, ಮಿಯಾ ಬಾರಿಕ್ ಹೊವ್ಕ್ ಪಾಜೆ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ಜೊ ಕೊನ್ ವೈನಾ ಯೆತಾ ತೊ ಸಗ್ಳ್ಯಾಂಚ್ಯಾನ್ಕಿ ಮೊಟೊ, ಜೊ ಕೊನ್ ಹ್ಯಾ ಜಿಮ್ನಿಕ್ ಸಮಂದ್ ಪಡಲ್ಲೊ ಹಾಯ್, ತೊ ಹ್ಯಾ ಜಿಮ್ನಿ ವೈಲೊಚ್, ಅನಿ ಹ್ಯಾ ಜಿಮ್ನಿ ವೈಲ್ಯಾ ವಿಶಯಾತುಚ್ ತೊ ಬೊಲ್ತಾ, ಖರೆ ಜೊ ಸರ್ಗಾವೈನಾ, ಯೆಲಾ ತೊ ಸಗ್ಳ್ಯಾಂಚ್ಯಾನ್ಕಿ ವೈಲೊ ");
INSERT INTO kans_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ತೊ ಜೆ ಕಾಯ್ ಅಪ್ನಿ ಬಗಟ್ಲ್ಯಾನಾಯ್, ಅನಿ ಆಯಿಕ್ಲ್ಯಾನಾಯ್ ತ್ಯೆಚ್ಯಾ ವಿಶಯಾತುಚ್ ಲೊಕಾ ಸ್ವಿಕಾರ್ ಕರಿನಾತ್. ಖರೆ ಅಜುನ್‍ಬಿ ಕೊನ್ಬಿ ತೆನಿ ದಿಲ್ಲಿ ಸಾಕ್ಷಿ ಮಾನುನ್ ಘೆಯ್ನಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ಖರೆ ಜೆ ಕೊನ್ ತೆಚಿ ಸಾಕ್ಷಿ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ ತೊ ಅಶೆಚ್ ಕರುನ್ ದೆವ್ ಕರೊ ಮನುನ್ ಸಾಬಿತ್ ಕರ್‍ತಾ ");
INSERT INTO kans_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ಜೆ ಕೊನಾಕ್ ದೆವಾನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್ ತೊ ದೆವಾಚ್ಯಾಚ್ ಗೊಸ್ಟಿಯಾ ಬೊಲ್ತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ದೆವ್ ತೆಕಾ ಅಪ್ನಾಚೊ ಆತ್ಮೊ ಭರ್‍ಪುರ್ ಮಾಪಾನಿ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ಬಾಬಾ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ, ಅನಿ ತೆಂಕಾ ಸಗ್ಳ್ಯಾ ವರ್ತಿ ಅದಿಕಾರ್ ದಿಲಾ . ");
INSERT INTO kans_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ಜೊ ಕೊನ್ ಲೆಕಾಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ ತೆಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವ್ತಾ; ಜೆ ಕೊನ್ ಲೆಕಾಚಿ ಆಜ್ಞಾ ಮಾನಿನಾತ್, ತೆಂಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವಿನಾ, ತೆನಿ ದೆವಾಚ್ಯಾ ರಾಗಾತ್ ರ್‍ಹಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ಜೆಜು ಜುವಾಂವಾಚ್ಯಾನ್ಕಿ ಜಾಸ್ತಿ ಶಿಸಾ ಕರುಕ್ ಲಾಗ್ಲಾ, ಅನಿ ಬಾಲ್ತಿಮ್ ದಿವ್ಲಾ, ಮನುನ್ ಫಾರಿಜೆವಾನಿ ಆಯಿಕ್ಲ್ಯಾನಿ. ಹೆ ಜೆಜುಕ್ ಕಳ್ಳೆ. ");
INSERT INTO kans_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ಖರೆ ಮಟ್ಲ್ಯಾರ್, ಜೆಜುನ್ ಅಪ್ನಿ ಕೊನಾಕ್ಬಿ ಬಾಲ್ತಿಮ್ ದಿವ್ಕ್ ನಾ ತ್ಯೆಚ್ಯಾ ಶಿಸಾನಿ ಬಾಲ್ತಿಮ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ಅಶೆ ಲೊಕಾ ಕಾಯ್- ಕಾಯ್ ಸಾಂಗುಲಾಲ್ಯಾತ್ ಮನುನ್ ಜೆಜುನ್ ಆಯಿಕ್ಲ್ಯಾನ್, ತನ್ನಾ ತೊ ಜುದೆಯಾ ಸೊಡುನ್ ಅನಿ ಪರ್ತುನ್ ಗಾಲಿಲಿಯಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ತೊ ಜಾತಾನಾ ಸಮಾರಿಯಾ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ನಾ ಪಾರ್ ಹೊವ್ನ್ ಜಾತಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ಸಮಾರಿಯಾತ್ ತೊ ಸಿಖಾರ್ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಯೆವ್ನ್ ಪಾವ್ಲೊ, ಹೆ ಜಾಕೊಬಾನ್ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಕ್ ಜುಜೆಕ್ ದಿಲ್ಲ್ಯಾ ಶೆತಾಕ್ನಾ ಲೈ ಧುರ್ ನತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ಥೈ ಜಾಕೊಬಾಚಿ ಭಾಂಯ್ ಹೊತ್ತಿ, ಜೆಜುಕ್ ಚಲುನ್‍ಚಲುನ್ ಫಿರೆ ಹೊಲ್ಲೆ, ಮನುನ್ ತೊ ಥೈ ಭಾಂಯ್ಚ್ಯಾ ಕಟ್ಟ್ಯಾರ್ ಬಸ್ಲೊ, ತನ್ನಾ ಜಗ್ಗೊಳ್ ದೊಪಾರ್ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ಎಕ್ ಸಮಾರಿಯಾಚಿ ಬಾಯ್ಕೊಮನುಸ್ ಪಾನಿ ನ್ಹೆವ್ಕ್ ಮನುನ್ ಭಾಂಯ್‍ಕ್ಡೆ ಯೆಲಿ, ತನ್ನಾ ಜೆಜುನ್ ತಿಕಾ,“ಮಾಕಾ ಉಲ್ಲೆ ಫಿವ್ಕ್ ಪಾನಿ ದಿ?” ಮಟ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ಹ್ಯಾ ಎಳಾರ್ ತೆಚಿ ಶಿಸಾ ಖಾವ್ಕ್ ಕಾಯ್ತರ್ ಖರಿದಿ ಕರುಕ್ ಮನುನ್ ಶಾರಾತ್ ಗೆಲ್ಲಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ತನ್ನಾ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್, “ತಿಯಾ ಎಕ್ ಜುದೆವ್, ಅನಿ ಮಿಯಾ ಎಕ್ ಸಮಾರಿಯಾಕಾರ್‍ನಿ- ತಿಯಾ ಮಾಜಾಕ್ಡೆ ಫಿವ್ಕ್ ಪಾನಿ ದಿ ಮನುನ್ ಕಶೆ ಮಾಗುಲಾಲೆಯ್?” ಮನುನ್ ಜವಾಬ್ ದಿಲಿನ್ ಜುದೆವ್ ಲೊಕಾ ಅನಿ ಸಮಾರಿಯಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಮದ್ದಿ ಕಸ್ಲೊಬಿ ಸಮಂದ್ ನತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ತನ್ನಾ ಜೆಜುನ್ ತಿಕಾ “ದೆವ್ ಕಾಯ್ ದಿತಾ, ಅನಿ ಫಿವ್ಕ್ ಉಲ್ಲೆ ಪಾನಿ ದಿ ಮನುನ್ ತುಜೆಕ್ಡೆ ಮಾಗ್ತಲೊ ಕೊನ್ ಮನುನ್ ತುಕಾ ಗೊತ್ತ್ ರ್‍ಹಾಲ್ಯಾರ್, ತಿಯಾಚ್ ತೆಚೆಕ್ಡೆ ಮಾಗಿ ಹೊತ್ತೆ, ಅನಿ ತೊ ತುಕಾ ಜಿವ್‍ದಿತಲೆ ಪಾನಿ ದಿ ಹೊತ್ತೊ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್, “ಸಾಯ್ಬಾ, ತುಜೆಕ್ಡೆ ಘಾಗರ್ ನಾ, ಅನಿ ಭಾಂಯ್‍ಬಿ ಬರಿಚ್ ಖೊಲ್ ಹಾಯ್, ಜಿವ್ ದಿತಲೆ ಪಾನಿ ತುಕಾ ಕಶೆ ಗಾವ್ತಾ? ");
INSERT INTO kans_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ಅಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಬಾಬಾನ್ ಜಾಕೊಬಾನ್ ಹಿ ಭಾಂಯ್ ಅಮ್ಕಾ ದಿಲ್ಯಾನಾಯ್; ತೆನಿ ತ್ಯೆಚ್ಯಾ ಪೊರಾನಿ, ತ್ಯೆಚ್ಯಾ ಗೊರಾ-ಡೊರಾನಿ ಹ್ಯಾತುರ್‍ಲೆಚ್ ಪಾನಿ ಫಿಲ್ಲ್ಯಾನಿ. ತಿಯಾ ಅಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಬಾಬಾ ಜಾಕೊಬಾನ್ಕಿಬಿ ಮೊಟೊ ಕಾಯ್?” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ಜೆಜುನ್ ಜಬಾಬ್ ದಿಲ್ಲ್ಯಾನ್, “ಜೆ ಕೊನ್ ಹೆ ಪಾನಿ ಫಿತಾ ತೆಕಾ ಅನಿ ಪರ್ತುನ್ ಸೊಸ್‍ ಲಾಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ಖರೆ ಮಿಯಾ ದಿಲ್ಲೆ ಪಾನಿ ಜೆ ಕೊನ್ ಫಿತಾ, ತೆಕಾ ಕನ್ನಾಬಿ ಅನಿ ಪರ್ತುನ್ ಸೊಸ್‍ಲಾಗಿನಾ. ಮಿಯಾ ದಿಲ್ಲೆ ಪಾನಿ ದಿತಲೆ ಪಾನಿ ಭುತ್ತುರ್ ಎಕ್ ಝರೊ ಸರ್ಕೆ ತೆಂಕಾ ಜಿವ್ ದಿತಲೆ ಪಾನಿ ದಿವ್ನಗೆತುಚ್ ರ್‍ಹಾತಾ, ಅನಿ ತೆಂಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ದಿತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ತನ್ನಾ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್‍, “ಸಾಯ್ಬಾ, ಮಾಕಾ ತೆ ಪಾನಿ ದಿ! ಅಶೆ ಕನ್ನಾಬಿ ಮಾಕಾ ಸೊಸ್‍ಲಾಗಿನಾ”, ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ಜೆಜುನ್ ತಿಕಾ, “ಜಾವ್ನ್ ತುಜ್ಯಾ ಘೊವಾಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಪರ್ತುನ್ ಯೆ” ಮಟ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ತನ್ನಾ ತಿನಿ, “ಮಾಜೊ ಘೊವ್ ನಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲಿನ್, ತನ್ನಾ ಜೆಜುನ್ “ತಿಯಾ ತುಜೊ ಘೊವ್ ನಾ ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಸಮಾ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ತಿಕಾ ಪಾಂಚ್ ಜಾನಾಕ್ನಿ ಲಗಿನ್ ಹೊಲಿ, ಅನಿ ಅತ್ತಾ ತಿಯಾ ಕೊನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಸ್ ತೊ ತುಜೊ ಖರೊ ಘೊವ್ ನ್ಹಯ್ ತಿಯಾ ಮಾಕಾ ಖರೆ ಹೊತ್ತೆ ಸಾಂಗಟ್ಲೆಯ್”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ತನ್ನಾ ತಿನಿ, “ಸಾಯ್ಬಾ ತಿಯಾ ಎಕ್ ಪ್ರವಾದಿ ಮನುನ್ ದಿಸ್ತಾ: ");
INSERT INTO kans_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ಅಮ್ಚ್ಯಾ ಸಮಾರಿಯಾಚ್ಯಾ ಅದ್ಲ್ಯಾ ಲೊಕಾನಿ ತ್ಯಾ ಮಡ್ಡಿ ವರ್ತಿ ಆರಾದನ್ ಕರ್ಲ್ಯಾನಿ, ಖರೆ ತುಮಿ ಜುದೆವ್ ಲೊಕಾ ದೆವಾಚಿ ಆರಾದನ್ ಕರ್‍ತಲೊ ಜಾಗೊ ಜೆರುಜಲೆಮ್, ಅನಿ ಜೆರುಲೆಮಾತುಚ್ ಯೆವ್ನ್ ತೆಚೆ ಆರಾದನ್ ಕರುಚಿ ಮನುನ್ ಸಾಂಗ್ತ್ಯಾಶಿ” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ಜೆಜುನ್ ತಿಕಾ, “ಮಾಜೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್, ಎಕ್ ಎಳ್ ಯೆತಾ ತನ್ನಾ ಲೊಕಾ ಮಡ್ಡಿ ವರ್ತಿ ಹೊಂವ್ದಿ, ಜೆರುಜಲೆಮಾತ್ ಹೊಂವ್ದಿತ್ ದೆವಾ ಬಾಬಾಚೆ ಆರಾದಾನ್ ಕರಿನಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ತುಮ್ಕಾ ಸಮಾರಿಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ತುಮಿ ಕೊನಾಚಿ ಆರಾದಾನ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ ಮನುನ್ ಗೊತ್ತ್ ನಾ; ಖರೆ ಅಮ್ಕಾ ಜುದೆವಾಕ್ನಿ ಅಮಿ ಕೊನಾಚಿ ಆರಾದಾನ್ ಕರುಲಾಂವ್ ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಸುಟ್ಕಾ ಜುದೆವ್ ಲೊಕಾನಿತ್ನಾ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ಖರೆ ಎಳ್ ಯೆವ್ಲಾ, ಅನಿ ಖರೆಬಿ ತೊ ಎಳ್ ಯೆವ್ನ್ ಪಾವ್ಲಾ, ಆರಾದನ್ ಕರ್‍ತಲ್ಯಾ ಲೊಕಾನಿ ಬಾಬಾ ಹುಡಕ್ತಾ ದೆವಾಚ್ಯಾ ಆತ್ಮ್ಯಾನ್ ಅನಿ ಖರ್‍ಯಾಪಾನಾನಿ ಭರಲ್ಲಿ ಲೊಕಾ ಬಾಬಾಕ್ ತೊ ಕಸೊ ಹಾಯ್ ತಸೊಚ್ ತೆಚಿ ಅನಿ ತೆಕಾ ಖರೆಪಾನಾನಿ ಆರಾದನ್ ಕರ್‍ತಲಿ ಲೊಕಾಚ್ ಪಾಜೆ”. ");
INSERT INTO kans_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ದೆವ್ ಮಟ್ಲ್ಯಾರ್ ಆತ್ಮೊ, ಅನಿ ಖಾಲಿ ತೆಚ್ಯಾ ಆತ್ಮ್ಯಾಚ್ಯಾ ಬಳಾನ್ ಎವ್ಡೆಚ್ ತೊ ಕಸೊ ಹಾಯ್ ತಶೆ ತೆಚೆ ಖರೆಪಾನಾನ್ ಆರಾದಾನ್ ಕರುಕ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್ ತೆಕಾ, “ಮೆಸ್ಸಿಯಾ ಯೆತಲೊ ಹಾಯ್ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಅನಿ ತೊ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಸಗ್ಳೆ ಅಮ್ಕಾ ಸಾಂಗ್ತಾ”. ");
INSERT INTO kans_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ತನ್ನಾ ಜೆಜುನ್ ಸಾಂಗಲ್ಲ್ಯಾನ್ , “ತುಜೆಕ್ಡೆ ಬೊಲುಲಾ ಹ್ಯೊಚ್ ತೊ ಮಿಯಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ತನ್ನಾ ಜೆಜುಚಿ ಶಿಸಾ ಫಾಟಿ ಪರ್ತುನ್ ಯೆಲಿ ಅನಿ ತೊ ಎಕ್ ಬಾಯ್ಕೊಮನ್ಸಿಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲ್ತಲೆ ಬಗುನ್ ತೆಂಕಾ ಅಜಿಬ್ ದಿಸ್ಲೆ, ಖರೆ ಕೊನ್ಬಿ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ “ತುಕಾ ಕಾಯ್ ಪಾಜೆ? ಮನುನ್ ನಾಹೊಲ್ಯಾರ್ ತಿಯಾ ಕಶ್ಯಾಕ್ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ಡೆ ಬೊಲುಲೆಯ್?” ಮನುನ್ ಜೆಜುಕ್ ಹೊಂವ್ದಿತ್ ಇಚಾರುಕ್‍ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ತನ್ನಾ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್ ಅಪ್ನಾಚಿ ಪಾನಿಯಾಚಿ ಘಾಗರ್ ಥೈಚ್ ಸೊಡ್ಲಿನ್, ಅನಿ ಶಾರಾತ್ ಗೆಲಿ, ಅನಿ ಥೈ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ, ");
INSERT INTO kans_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ಯೆವಾ, ಅನಿ ಮಿಯಾ ಮಾಜ್ಯಾ ಜಿವನಾತ್ ಕರಲ್ಲೆ ಸಗ್ಳೆ ಸಾಂಗಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಬಗಾ ಯೆವಾ, ತೊ ಮೆಸ್ಸಿಯಾಚ್ ರ್‍ಹಾವ್ಕ್ ಫಿರೆ ಕಾಯ್?” ಮನುನ್ ಸಾಂಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ಅಶೆ ತೆನಿ ಶಾರಾತ್ನಾ ಜೆಜುಕ್ ಬಗುಕ್ ಮನುನ್ ಜೆಜುಕ್ಡೆ ಯೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ತನ್ನಾಚ್ ಶಿಸಾಬಿ ಜೆಜುಕ್, “ಗುರುಜಿ ಕಾಯ್ ತರ್ ಉಲ್ಲೆ ಖಾವಾ!” ಮನುನ್ ಲೈ ಸಾಂಗುಲಾಗಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ಖರೆ ತೆನಿ ತೆಂಕಾ, “ಮಾಜಾಕ್ಡೆ ಜೆವಾನ್ ಹಾಯ್ ತ್ಯೆಚ್ಯಾ ವಿಶಯಾತ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ನಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ತಸೆ ಮನುನ್ ಶಿಸಾ ಎಕಾಮಕಾತ್ನಿ “ಕೊನ್ ತರ್ ಹೆಕಾ ಜೆವಾನ್ ಹಾನುನ್ ದಿಲ್ಯಾನಿ, ಕಾಯ್?” ಮನುನ್ ಇಚಾರುಕ್‍ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ಜೆಜುನ್ ತೆಂಕಾ, “ಮಾಕಾ ಧಾಡಲ್ಲ್ಯಾಚ್ಯಾ ಗೊಸ್ಟಿಕ್ ಖಾಲ್ತಿ ಹೊತಲೆ, ಅನಿ ಮಾಕಾ ಜೆ ಕಾಯ್ ಕರುಕ್ ಮನುನ್ ಧಾಡಲ್ಲೆ ಹಾಯ್ ತೆ ಪುರಾ ಕರ್‍ತಲೆಚ್, ಮಾಜೆ ಜೆವಾನ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ತುಮ್ಚಿ ಎಕ್ ಸಾಂಗ್ನಿ ಹಾಯ್, “ಅನಿ ಚಾರ್ ಮ್ಹಯಿನೆ ಎವ್ಡೆಚ್ ಸುಗ್ಗಿ ಯೆಲಿ” ಮನುನ್ ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ಶೆತಾತ್ನಿ ಬರೆ ಕರುನ್ ಎಕ್ ನದರ್ ಘಾಲುನ್ ಬಗಾ; ಕನ್ಸಾ ಸಗ್ಳಿ ಪಿಕುನ್ ಕಾತ್ರುಕ್ ತಯಾರ್ ಹೊವ್ನ್ ಹಾತ್! ");
INSERT INTO kans_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ಪಿಕಾ ಕಾತರ್‍ತಲ್ಯಾಕ್ ತೆಂಚಿ ಮಜುರಿ ದಿವ್ನ್ ಹೊಲಾ, ಅನಿ ತೊ ತೆ ಪಿಕ್ಕ್ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲ್ಯಾ ಜಿವನಾಸಾಟ್ನಿ ಗೊಳಾ ಕರ್‍ತಾ; ಅಶೆ ಪೆರಲ್ಲೊ ಅನಿ ಕಾತರ್‍ತಲೊ ದೊಗೆಬಿ ವಾಂಗ್ಡಾ ಕುಶಿ ಹೊತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ಕೊನ್ ಪೆರಲ್ಲೆ ಕೊನ್‍ ಕಿ ಕಾತರ್‍ತಾ ಮನ್ತಲಿ ಗೊಸ್ಟ್ ಖರಿ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ತಿಯಾ ಕಾಮ್ ಕರಿನಸಲ್ಲ್ಯಾ ಶೆತಾತ್ನಿ ಮಿಯಾ ತುಕಾ ಪಿಕ್ ಕಾತ್ರುಕ್ ಧಾಡ್ತಾ; ಥೈ ದುಸ್ರ್ಯಾನಿ ರಾಬ್ಲ್ಯಾನಾತ್ ಖರೆ ತೆಚೊ ಫಾಯ್ದೊ ತುಕಾ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿನ್ “ಮಿಯಾ ಕರಲ್ಲೆ ಸಗ್ಳೆ ತೆನಿ ಮಾಕಾ ಸಾಂಗ್ಲ್ಯಾನ್” ಮನುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ತನ್ನಾ ತ್ಯಾ ಶಾರಾತ್ಲ್ಯಾ ಸುಮಾರ್ ಸಮಾರಿಯಾಚ್ಯಾ ಲೊಕಾನಿ ಜೆಜುಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ತೆಚೆಸಾಟ್ನಿ ತ್ಯಾ ಸಮಾರಿಯಾಚ್ಯಾ ಲೊಕಾನಿ ಜೆಜುಕ್ಡೆ “ತಿಯಾ ಅಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾ” ಮನುನ್ ಲೈ ಮಾಗ್ಲ್ಯಾನಿ ತನ್ನಾ ಜೆಜು ದೊನ್ ದಿಸ್ ಥೈಚ್ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ತೆನಿ ಸಾಂಗ್ತಲಿ ಬರಿ ಖಬರ್ ಆಯ್ಕುನ್ ಸುಮಾರ್ ಲೈ ಲೊಕಾನಿ ತ್ಯೆಚೆರ್ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ಅನಿ ತೆನಿ ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್, “ಅಮಿ ಅತ್ತಾ ವಿಶ್ವಾಸ್, ಕರ್‍ತಾವ್, ಖಾಲಿ ತಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿ ವೈನಾ ನ್ಹಯ್, ಅಮಿ ಅಮ್ಚ್ಯಾ ಕಾನಾನಿ ತೆನಿ ಸಾಂಗ್ತಲಿ ಖಬರ್ ಆಯಿಕ್ಲಾಂವ್, ಅನಿ ಹ್ಯೊಚ್ ಹ್ಯಾ ಜಗಾಚೊ ರಾಕ್‍ನ್ದಾರ್ ಮನುನ್ ಅಮ್ಕಾ ಕಳ್ಳೆ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ಸಮಾರಿಯಾತ್ ದೊನ್ ದಿಸ್ ರ್‍ಹಾವ್ನ್, ಮಾನಾ ಜೆಜು ಗಾಲಿಲಿಯಾಕ್ ಗೆಲೊ ");
INSERT INTO kans_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ತೆನಿ ಅಪ್ನಾಕುಚ್, “ಪ್ರವಾದ್ಯಾಕ್ನಿ ಸ್ವತಾಚ್ಯಾ ಗಾಂವಾತ್ನಿ ಮಾನ್ ಗಾವಿನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ತೊ ಗಾಲಿಲಿಯಾಕ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ಥೈತ್ಲ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ಸ್ವಾಗತ್ ಕರ್ಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಜೆರುಜಲೆಮಾಕ್ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಕ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ ಕರಲ್ಲಿ ಸಗ್ಳಿ ಕಾಮಾ ತೆನಿ ಬಗಟಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ಮಾನಾ ಜೆಜು ಅಪ್ನಿ ಪಾನಿ ಹೊತ್ತೆ ವಾಯ್ನ್ ಕರುನ್ ಬದ್ಲಲ್ಲ್ಯಾ ಗಾಲಿಲಿಯಾ ಪ್ರಾಂತ್ಯಾತ್ಲ್ಯಾ ಕಾನಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಗೆಲೊ ಥೈ ಎಕ್ ಸರ್ಕಾರಾಚೊ ಮೊಟೊ ಅದಿಕಾರಿ ಹೊತ್ತೊ ತೆಚೊ ಲೆಕ್ ಶಿಕ್ ಹೊತ್ತೊ ತೊ ಲೆಕ್ ಕಫರ್ನವ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ಜೆಜು ಜದೆಯಾತ್ನಾ ಗಾಲಿಲಿಯಾಕ್ ಯೆಲಾ ಮನ್ತಲೆ ಆಯ್ಕಲ್ಲ್ಯಾ, ತನ್ನಾ ತೊ ಜೆಜುಕ್ಡೆ ಗೆಲೊ, ಅನಿ ಶಿಕ್ ಪಡುನ್ ಮರ್‍ತಲ್ಯಾ ಪರಿಸ್ತಿತಿರ್ ಹೊತ್ತ್ಯಾ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಕ್ ಕಫರ್ನವ್ಕ್ ಜಾವ್ನ್ ಗುನ್ ಕರ್ ಮಾಗುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ಜೆಜುನ್ ತೆಕಾ,“ಅಜಾಪಾ, ಅನಿ ಚಮತ್ಕಾರಾ ಬಗಟ್ಲ್ಯಾ ಶಿವಾಯ್ ತುಮ್ಚ್ಯಾತ್ಲೆ ಕೊನ್ಬಿ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾಸಿ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ತ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ತೆಕಾ, “ಸಾಯ್ಬಾ, ಮಾಜೊ ಪೊರ್ ಮರುಚ್ಯಾ ಅದ್ದಿ ತಿಯಾ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ಜೆಜುನ್ ತೆಕಾ, ತುಜೊ ಲೆಕ್ ಝಿತ್ತೊ ರ್‍ಹಾತಾ,“ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ತ್ಯಾ ಮಾನ್ಸಾನ್ ಜೆಜುಚ್ಯಾ ಗೊಸ್ಟಿ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನ್, ಅನಿ ತೊ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ತೊ ಜಾತಾ- ಜಾತಾನಾಚ್ ವಾಟೆರ್ ತೆಚ್ಯಾ ಘರಾತ್ಲಿ ಆಳಾ ತೆಕಾ ಭೆಟ್ಲಿ, ಅನಿ ತುಜೊ ಲೆಕ್ ಬರೊ ಹೊಲಾ!” ಮನ್ತಲಿ ಖಬರ್ ತೆಕಾ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ತನ್ನಾ ತೆನಿ ಕನ್ನಾಚ್ಯಾನ್ ಮಾಜೊ ಲೆಕ್ ಬರೊ ಹೊಲೊ ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್, ತನ್ನಾ ಆಳಾನಿ,“ಕಾಲ್ ದೊಪಾರಿ ಎಕ್ ಘಂಟ್ಯಾಕ್ ತೆಚೊ ತಾಪ್ ತೆಕಾ ಸೊಡುನ್ ಗೆಲೊ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ತನ್ನಾ ತ್ಯಾ ಬಾಬಾಕ್ ಜೆಜುನ್,“ತುಜೊ ಲೆಕ್ ಬರೊ ಹೊತಾ”, ಮನುನ್ ಸಾಂಗಲ್ಲೊ ತೊಚ್ ಎಳ್ ತೊ ಮನುನ್ ಯಾದ್ ಯೆಲಿ, ಅಶೆ ತೆನಿ, ಅನಿ ತೆಚ್ಯಾ ಕುಟ್ಮಾಚ್ಯಾ ಸಗ್ಳ್ಯಾನಿ ಜೆಜುಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ಹೆ ಜೆಜುನ್ ಜುದೆಯಾಕ್ನಾ ಗಾಲಿಲಿಯಾಕ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಕರಲ್ಲೆ ದೊನ್ವೆಚೆ ಅಜಾಪ್. ");
INSERT INTO kans_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ಹೆಚ್ಯಾ ಮಾನಾ ಜೆಜು ಜೆರುಜಲೆಮಾಕ್ ಗೆಲೊ, ಜುದೆವ್ ಲೊಕಾಂಚೊ ಎಕ್ ಸನ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ಜೆರುಜಲೆಮಾತ್ ಬಕ್ರಿ ಇಕ್ತಲೊ ಎಕ್ ಜಾಗೊ ಹೊತ್ತೊ ತ್ಯಾ ವಾಟೆರ್ ಎಕ್ ಪಾಂಚ್ ಮಂಟಪಾಂಚೆ ತಳೆ ಹೊತ್ತೆ. ಜುದೆವ್ ಲೊಕಾ ಹ್ಯಾ ತಳ್ಯಾಕ್ ಬೆಥ್‍ಝತಾ ಮನುನ್ ಬಲ್ವುತಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ತ್ಯಾ ತಳ್ಯಾಚ್ಯಾ ಮಂಟಪಾ ವೈನಿ ಶಿಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಪಡುನ್ ರ್‍ಹಾಯ್. ಕುಡ್ಡಿ, ಸೊಟ್ಟಿ, ವಾರ್‍ಯಾನ್‍ ಮಾರಲ್ಲಿ ಲೊಕಾ ಥೈ ಹೊತ್ತಿ. ಪಾನಿ ಹಾಲ್ತಲೆ ರಾಕಿತ್ ರ್‍ಹಾತ್ಯಾತ್, ");
INSERT INTO kans_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ಅಶೆ ಹೊಲ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಎಳಾಚ್ಯಾ ಮಾಗಿರ್ ದೆವಾಚೊ ದುತ್ ಖಾಲ್ತಿ ಯೆವ್ನ್ ರೊಗ್ ಲಾಗಲ್ಲ್ಯಾ ಮಾನುಸ್ ಸಗ್ಳ್ಯಾನ್ಕಿ ಫಿಡೆ ಜಾತಾ ಅನಿ ಹಾಲ್ತಲ್ಯಾ ಪಾನಿಯಾಕ್ಡೆ ಜಾವ್ನ್ ಪಾವ್ತಾ ತೊ ತೆಕಾ ರೊಗಾತ್ನಾ ಗುನ್ ಹೊಯ್. ");
INSERT INTO kans_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ತಿಸಾರ್ ಆಟ್ ವರ್ಸಾಕ್ನಾ ಶಿಕ್ ಹೊತ್ತೊ ಎಕ್ ಮಾನುಸ್ ಥೈ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ಥೈ ಪಡುನ್ ಹೊತ್ತ್ಯಾ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಜೆಜುನ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ತೊ ಲೈ ದಿಸಾನಿಕ್ನಾ ಶಿಕ್ ಹೊತ್ತೊ ಮನುನ್ ಜೆಜುಕ್ ಗೊತ್ತ್ ಹೊತ್ತೆ, ತಸೆಮನುನ್ ಜೆಜುನ್ ತೆಕಾ “ತುಕಾ ಆರಾಮ್ ಹೊವ್ಕ್ ಮನ್ ಹಾಯ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ತ್ಯಾ ಶಿಕ್ ಮಾನ್ಸಾನ್ “ಸಾಯ್ಬಾ ಪಾನಿ ಹಲ್ವಲ್ಲ್ಯಾ ತನ್ನಾ ಮಾಕಾ ತಳ್ಯಾತ್ ಘೆವ್ನ್ ಜಾತಲೊ ಕೊನ್ಬಿ ನಾ, ಮಿಯಾ ಜಾವ್ಕ್ ಮನುನ್ ಬಗಲ್ಲ್ಯಾ ತನ್ನಾ ದುಸ್ರೆಚ್ ಕೊನ್ಬಿ ಮಾಜ್ಯಾನ್ ಅದ್ದಿ ಜಾವ್ನ್ ಸೊಡ್ತ್ಯಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ಜೆಜುನ್ ತೆಕಾ, “ಉಟ್, ತುಜೆ ಹಾತ್ರಾನ್ ಘೆ ಅನಿ ಜಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ತಾಬೊಡ್ತೊಬ್ ತೊ ಮಾನುಸ್ ಬರೊ ಹೊಲೊ; ತೆನಿ ಅಪ್ನಾಚೆ ಹಾತ್ರಾನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ಚಲುಕ್‍ಲಾಲೊ. ಹೆ ಘಡಲ್ಲೊ ದಿಸ್ ಸಬ್ಬಾತಾಚೊ ದಿಸ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ತೆಚೆಸಾಟ್ನಿ ಜುದೆವ್ ಲೊಕಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನಿ ತ್ಯಾ ಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್, “ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಹಾತ್ರಾನ್ ವಾವುನ್ ಘೆವ್ನ್ ಜಾತಲೆ ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾಚ್ಯಾ ಪರ್‍ಕಾರ್ ಚುಕ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ತನ್ನಾ ತೆನಿ, “ಮಾಕಾ ಬರೆ ಕರಲ್ಲ್ಯಾ ಮಾನ್ಸಾನ್ ಮಾಕಾ ಮಾಜೆ ಹಾತ್ರಾನ್ ಘೆವ್ನ್ ಜಾ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ತೆನಿ ತೆಕಾ “ಕೊನ್ ತೊ ಮಾನುಸ್ ತುಕಾ ಅಶೆ ಕರುಕ್ ಸಾಂಗಲ್ಲೊ” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ಖರೆ ತ್ಯಾ ಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಜೆಜು ಕೊನ್ ಮನುನ್ ಗೊತ್ತ್ ನತ್ತೆ ಥೈ ಲೊಕಾಂಚೊ ಲೈ ಮೊಟೊ ತಾಂಡೊ ಹೊತ್ತೊ, ಅನಿ ಜೆಜು ಥೈತ್ನಾ ಗೆಲ್ಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ಮಾನಾಸರ್ ತೆಕಾ ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಭೆಟ್ಲೊ, ಅನಿ, “ಆಯ್ಕ್, ತಿಯಾ ಅತ್ತಾ ಗುನ್ ಹೊಲೆ, ತೆಚೆಸಾಟ್ನಿ ಪಾಪ್ ಕರುನಕೊ, ಅನಿಬಿ ತುಕಾ ಕಾಯ್ಬಿ ವಾಯ್ಟ್ ಹೊತಲೆ ನಕ್ಕೊ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ತನ್ನಾ ತೊ ಗುನ್ ಹೊಲ್ಲೊ ಮಾನುಸ್, ಜುದೆವ್ ಲೊಕಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನಿಕ್ಡೆ ಗೆಲೊ ಅನಿ ಅಪ್ನಾಕ್ ಗುನ್ ಕರಲ್ಲೊ ಮಾನುಸ್ ಜೆಜು ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ಜೆಜುಕ್ ತರಾಸ್ ದಿವ್ಕ್ ಚಾಲು ಕರ್ಲ್ಯಾನಿ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಹೆ ಕಾಮ್ ಸಬ್ಬಾತಾ ದಿಸಿ ಕರಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ಜೆಜುನ್ ತೆಂಕಾ, “ಮಾಜೊ ಬಾಬಾ ಕನ್ನಾಬಿ ಕಾಮ್ ಕರುನ್ಗೆತುಚ್ ರ್‍ಹಾತಾ, ಅನಿ ಮಿಯಾಬಿ ಕಾಮ್ ಕರುಕುಚ್ ಪಾಜೆ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ಹ್ಯಾ ಗೊಸ್ಟಿಕ್ ಲಾಗುನ್ ಜುದೆವಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಂಚ್ಯಾ ಮನಾತ್ನಿ ಜೆಜುಕ್ ಜಿವಾನಿ ಮಾರುಕ್ ಪಾಜೆ ಮನ್ತಲೊ ಘಟ್ ನಿರ್‍ದಾರ್ ಹೊಲೊ; ತೆನಿ ಖಾಲಿ ಸಬ್ಬಾತಾಚೊ ಖಾಯ್ದೊ ಮೊಡ್ಲ್ಯಾನ್ ಮನುನ್ ಎವ್ಡೆಚ್ ನ್ಹಯ್, ಜಾಲ್ಯಾರ್ ತೆನಿ ದೆವಾಕುಚ್ ಅಪ್ನಾಚೊ ಸ್ವತಾಚೊ ಬಾಬಾ ಮನುನ್ ಘೆಟಲ್ಲ್ಯಾನ್, ಅನಿ ಅಪ್ನಾಕುಚ್ ದೆವಾಚ್ಯಾ ಸಮಾ ಮನುನ್ ಕರುನ್ ಘೆಟಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ತಸೆ ಮನುನ್ ಜೆಜುನ್ ತೆಂಕಾ ಸಾಂಗ್ಲ್ಯಾನ್, ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಸಾಂಗ್ತಾ; ಲೆಕಾನ್ ಅಪ್ನಾಚ್ಯಾ ಅಪ್ನಿಚ್ ಕಾಯ್ ಬಿ ಕರುಕ್ ಹೊಯ್ನಾ, ತೊ ಅಪ್ನಾಚ್ಯಾ ಬಾಬಾನ್ ಕರಲ್ಲೆ ಬಗಟಲ್ಲೆಚ್ ಕರ್‍ತಾ . ಬಾಬಾ ಜೆ ಕಾಯ್ ಕರ್‍ತಾ ತೆಚ್ ಲೆಕ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ಬಾಬಾ ಲೆಕಾಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ, ಅನಿ ತೊ ಅಪ್ನಿ ಕಾಯ್ ಕರ್‍ತಾ ತೆ ಸಗ್ಳೆ ಲೆಕಾಕ್ ದಾಕ್ವುತಾ. ಹೆಚ್ಯೆನ್ಬಿ ಮೊಟಿ ಕಾಮಾ ಕರುಕ್ ಬಾಬಾ ಲೆಕಾಕ್ ಶಿಕ್ವುನ್ ದಿತಾ. ಅಶೆ ತುಮಿ ಸಗ್ಳೆ ಅಜಾಪ್ ಹೊತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ಕಶೆ ಬಾಬಾ ಮರಲ್ಲ್ಯಾಕ್ನಿ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುತಾ, ತಸೆಚ್ ಅಪ್ನಾಕ್ ಪಾಜೆ ಹೊಲ್ಲ್ಯಾಕ್ನಿ ಲೆಕ್‍ಬಿ ಝಿತ್ತೆ ಕರುನ್ ಉಟ್ವುತಾ. ");
INSERT INTO kans_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ಅನಿಬಿ ಬಾಬಾ ಅಪ್ನಿಚ್ ಕೊನಾಚಿ ಇಚಾರ್‍ನಿ ಕರಿನಾ, ತೆನಿ ಇಚಾರ್‍ನಿ ಕರ್‍ತಲೊ ಸಗ್ಳೊ ಅದಿಕಾರ್ ಲೆಕಾಕ್ ದಿಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ತೆಚ್ಯಾ ಸಾಟ್ನಿ ಸಗ್ಳೆ ಲೊಕಾ ಕವ್ಡೊ ಬಾಬಾಕ್ ಮಾನ್ ದಿತ್ಯಾತ್, ತವ್ಡೆಚ್ ಲೆಕಾಕ್ ಬಿ ಮಾನ್ ದಿತ್ಯಾತ್. ಜೆ ಕೊನ್ ಲೆಕಾಕ್ ಮಾನ್ ದಿ ನಾತ್, ತೆನಿ ತೆಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾ ಬಾಬಾಕ್‍ಬಿ ಮಾನ್ ದಿ ನಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ಜೆ ಕೊನ್ ಮಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತಾ, ಅನಿ ಮಾಕಾ ಧಾಡಲ್ಲ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ, ತೆಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವ್ತಾ. ತೆಂಚಿ ಝಡ್ತಿ ಕರುನ್ ಹೊಯ್ನಾ ತೆನಿ ಮರ್‍ನಾತ್ನಾ ಜಿವನಾಕ್ ಪಾರ್ ಹೊವ್ನ್ ಗೆಲ್ಲೆ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ ಎಳ್ ಯೆವ್ಲಾ, ಎಳ್ ಯವ್ನುಚ್ ಪಾವ್ಲಾ. ಮರಲ್ಲಿ ಲೊಕಾ ದೆವಾಚ್ಯಾ ಲೆಕಾಚೊ ಧನ್ ಆಯಿಕ್ತ್ಯಾತ್ ಅನಿ ಜೆ ಕೊನ್ ಆಯಿಕ್ತ್ಯಾತ್ ತೆನಿ ಝಿತ್ತೆ ಹೊತಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ಕಶೆ ಬಾಬಾ ಜಿವಾಚೊ ಮುಳ್ ತಸೆಚ್ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಲೆಕಾಕ್‍ಬಿ ಜಿವಾಚೊ ಮುಳ್ ಕರುನ್ ಥವ್ಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ಅನಿ ತೆನಿ ಇಚಾರ್‍ನಿ ಕರ್‍ತಲೊ ಹಕ್ಕ್ ಲೆಕಾಕ್ ದಿಲ್ಯಾನಾಯ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಮಾನ್ಸಾಚೊ ಲೆಕ್. ");
INSERT INTO kans_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ತುಮಿ ಅಜಾಪ್ ಹೊವ್ನಕಾಶಿ, ಎಕ್ ಎಳ್ ಯೆತಾ ತನ್ನಾ ಸಗ್ಳೆ ಮರಲ್ಲೆ ತೆಚೊ ಧನ್ ಆಯಿಕ್ತ್ಯಾತ್!. ");
INSERT INTO kans_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ಅನಿ ತೆಂಚ್ಯಾ- ತೆಂಚ್ಯಾ ಸಾರಿಯಾನಿತ್ನಾ ಉಟುನ್ ಭಾಯ್ರ್ ಯೆತಾತ್, ಜೆ ಕೊನ್ ಬರೆ ಕರ್‍ಲ್ಯಾನಾತ್ ತೆನಿ ಝಿತ್ತೆ ಹೊತ್ಯಾತ್ ಅನಿ ಜಿವನ್ ಕರ್‍ತಾತ್, ಅನಿ ಜೆ ಕೊನ್ ವಾಯ್ಟ್ ಕರ್‍ಲ್ಯಾನಾತ್ ತೆನಿ ಉಟ್ತಾತ್, ಅನಿ ತೆಂಚಿ ಇಚಾರ್‍ನಿ ಕರುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ಮಿಯಾ ಮಾಜ್ಯಾ ಅದಿಕಾರಾನ್ ಕಾಯ್ಬಿ ಕರುಕ್ ಹೊಯ್ನಾ; ಕಸೊ ದೆವ್ ಮಾಕಾ ಸಾಂಗ್ತಾ ತಸೆ ಮಿಯಾ ಆಯ್ಕಲ್ಲ್ಯಾ ಸಾರ್ಕೆ ಮಿಯಾ ನ್ಯಾಯ್ ಕರ್‍ತಾ, ತಸೆ ಮನುನ್ ಮಾಜೊ ನಿರ್‍ನಯ್ ಸಮಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಮಾಕಾ ಪಾಜೆ ತಸೆ ಕರುಕ್ ಬಗಿನಾ ಹೊಲಾ, ಜೆ ಕೊನ್ ಮಾಕಾ ಧಾಡ್ಲ್ಯಾನಾಯ್ ತೆಕಾ ಪಾಜೆ ತಸೆ ಮಿಯಾ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ಜರ್ ತರ್ ಮಿಯಾಚ್ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿತಾ, ತರ್ ಮಿಯಾ ಸಾಂಗ್ತಲೆ ಖರೆ ಮನುನ್ ಮಾನುನ್ ಘೆವ್ಕ್ ಹೊಯ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ಖರೆ ಕೊನ್‍ ಕಿ ದುಸ್ರೊಚ್ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿತಾ, ಅನಿ ತೊ ಸಾಂಗ್ತಲಿ ಸಾಕ್ಷಿ ಖರಿ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ತುಜ್ಯಾ ಎಕ್ಲ್ಯಾ ಖಬರ್ ಸಾಂಗ್ನಾರ್‍ಯಾಕ್ ಜುವಾಂವಾಕ್ ತಿಯಾ ಧಾಡುನ್ ದಿಲೆಯ್, ಅನಿ ತೊ ಖರ್‍ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುನ್ ಅಪ್ನಾಚಿ ಸಾಕ್ಷಿ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ಮಾಜೆ ವಿಶಯಾತ್ ಎಕ್ ಮಾನ್ಸಾಚಿ ಸಾಕ್ಷಿ ಪಾಜೆಚ್ ಮನುನ್ ನಾ, ಖರೆ ತುಮಿ ನಾಸಾತ್ನಾ ಹುರುಕ್ ಪಾಜೆ ಮಟಲ್ಲ್ಯಾಸಾಟಿ ಮಿಯಾ ಹೆ ಸಾಂಗುಲಾಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ಜುವಾಂವ್ ಎಕ್ ಪೆಟ್ತಾ ಅನಿ ಹೊಳ್ವಳ್ತಲ್ಯಾ ದಿವ್ಯಾ ಸಾರ್ಕೊ ಹೊತ್ತೊ, ಅನಿ ತುಮಿ ಎಕ್ ಉಲ್ಲೊಸೊ ಎಳ್ ತ್ಯಾ ಉಜ್ವೊಡಾತ್ ರ್‍ಹಾವ್ನ್ ಖುಶಿ ಹೊಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ಖರೆ ಮಾಜ್ಯಾಕ್ಡೆ ಮಾಜ್ಯಾಚ್ ವಿಶಯಾತ್ ಜುವಾಂವಾಕ್ ದಿಲ್ಲ್ಯಾ ಸಾಕ್ಷಿನ್ಕಿ ಮೊಟಿ ಸಾಕ್ಷಿ ಹಾಯ್! ಜೆ ಕಾಯ್ ಮಿಯಾ ಕರುಲಾಲಾ, ತೆ ಮಾಜ್ಯಾ ಬಾಬಾನುಚ್ ಮಾಕಾ ಕರ್ ಮನುನ್ ದಿಲ್ಲೆ ಹಾಯ್, ಹಿ ಮಿಯಾ ಕರ್‍ತಲಿ ಕಾಮಾಚ್ ಮಾಕಾ ಬಾಬಾನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ಅನಿ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲೊ ಬಾಬಾಚ್ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿತಾ, ತುಮಿ ಕನ್ನಾಬಿ ತೆಚೊ ಧನ್ ಆಯ್ಕುಕ್‍ನ್ಯಾಶಿ ನಾ ಹೊಲ್ಯಾರ್ ತೆಚೆ ತೊಂಡ್ ಬಗುಕ್‍ನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ಅನಿ ತೆಚಿ ಬರಿ ಖಬರ್ ತುಮಿ ತುಮ್ಚ್ಯಾ ಮನಾತ್ನಿ ಖಬರ್ ಥವ್ನ್ ಘೆವ್ಕನ್ಯಾಶಿ, ಅನಿ ತೆನಿ ಧಾಡಲ್ಲ್ಯಾಚ್ಯಾ ವರ್‍ತಿಬಿ ತುಮಿ ವಿಶ್ವಾಸ್, ಕರಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ತುಮಿ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ಲೆ ಬರೆ ಕರುನ್ ಶಿಕ್ಲ್ಯಾಶಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತ್ಯಾತುರ್‍ನಿ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಹಾಯ್ ಮನುನ್ ತುಮಿ ಚಿಂತ್ಯಾಶಿ, ಖರೆ ತಿ ಸಗ್ಳಿ ನಿಯಮಾ ಪವಿತ್ರ್ ಪುಸ್ತಾಕಾ ಮಾಜ್ಯಾಚ್ ವಿಶಯಾತ್ ಬೊಲ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ಅಜುನ್‍ಬಿ ತುಮ್ಕಾ ಜಿವ್ ಕಮ್ವುನ್ ಘೆವ್‍ಸಾಟ್ನಿ ಮಾಜ್ಯಾಕ್ಡೆ ಯೆವ್ಕ್ ಮನ್‍ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ಮಾನ್ಸಾನಿ ಹೊಗಳ್ತಲೆ ಮಾಕಾ ನಕ್ಕೊ. ");
INSERT INTO kans_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ಖರೆ ತುಮಿ ಕಸ್ಲಿ ಲೊಕಾ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಅನಿ ದೆವಾಸಾಟಿ ತುಮ್ಚ್ಯಾ ಮನಾತ್ನಿ ಪ್ರೆಮಾಚೊ ನಾ ಮನುನ್ಬಿ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ಅದಿಕಾರಾಚ್ಯಾ ವೈನಾ ಯೆಲಾ, ಖರೆ ತುಮಿ ಮಾಕಾ ಸ್ವಿಕಾರ್ ಕರುಕ್‍ನ್ಯಾಶಿ; ಕೊನ್‍ ತರ್ ಅಪ್ನಾಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಯೆಲೊ ತರ್ ತುಮಿ ತೆಕಾ ಸ್ವಿಕಾರ್ ಕರ್‍ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ದುಸ್ರ್ಯಾನಿಕ್ನಾ ಹೊಗ್ಳುನ್ ಘೆತಲೆ ತುಮ್ಕಾ ಬರೆ ದಿಸ್ತಾ. ಖರೆ ತುಮಿ ಎಕ್ಲ್ಯಾಚ್ ದೆವಾಕ್ನಾ ಹೊಗ್ಳುನ್ ಘೆವ್ಕ್ ಮನ್ ಕರಿನ್ಯಾಶಿ, ಅಶೆ ರ್‍ಹಾತಾನಾ ತುಮಿ ಮಾಜ್ಯಾ ಕಶೆ ವಿಶ್ವಾಸ್, ಕರುಕ್ ಹೊತಾ? ");
INSERT INTO kans_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ಮಿಯಾ ಬಾಬಾಚ್ಯಾ ದೆವಾಚ್ಯಾ ಇದ್ರಾಕ್ ತುಮಿ ಚುಕಿದಾರ್ ಮನುನ್ ಮನ್ತಾ ಮನುನ್ ಚಿಂತುನಕಾಶಿ, ತುಮಿ ಬರೊಸೊ ಥವ್ನ್ ಹೊತ್ತೊ ಮೊಯ್ಜೆಚ್ ತುಮಿ ಚುಕಿದಾರ್ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ಜರ್ ತರ್ ತುಮಿ ಖರೆಚ್! ಮೊಯ್ಜೆಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತ್ಯಾಶಿ, ತರ್ ಮಾಜ್ಯಾ ವರ್‍ತಿಬಿ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಿ ಹೊತ್ತ್ಯಾಶಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಲಿವಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ಖರೆ ಅಜುನ್ ತುಮಿ ತೆನಿ ಕಾಯ್ ಲಿವ್ಲ್ಯಾನಾಯ್ ತೆಚೆ ವರ್‍ತಿಚ್ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾಶಿ, ಅನಿ ಮಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ವರ್ತಿ ಕಶೆ ವಿಶ್ವಾಸ್ ಕರ್‍ತ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ಹೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜು ಗಾಲಿಲಿಯಾ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ಬಾಜುಕ್ ಪಾಯ್ ವಾಟೆನಿ ಗೆಲೊ ಹ್ಯಾ ಸಮುಂದರಾಕ್ ತಿಬೆರಿಯಸ್ ಮನುನ್ಬಿ ಬಲ್ವುತಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ತ್ಯೆಚ್ಯಾ ಫಾಟ್ನಾ ಲೊಕಾಂಚೊ ಎಕ್ ಮೊಟೊ ತಾಂಡೊ ಹೊತ್ತೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಜೆಜುನ್ ಶಿಕ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಗುನ್ ಕರಲ್ಲಿ ಅಜಾಪಾ ಬಗಟಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ಜೆಜು ಎಕ್ ಮಡ್ಡಿ ವರ್ತಿ ಗೆಲೊ, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ತನ್ನಾ ಜುದೆವಾಚ್ಯೊ ಪಾಸ್ಕಾಚೊ ಸನ್ ತೊಂಡಾರ್ ಯೆಲ್ಲೊ ಹೊತ್ತೊ ");
INSERT INTO kans_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ಜೆಜುನ್ ಅಪ್ನಾಕ್ಡೆ ಯೆತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ನಿ ಬಗಟ್ಲ್ಯಾನ್ ತಸೆಮನುನ್ ತೆನಿ ಫಿಲಿಪಾಕ್, “ಹ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಪಾವಿ ಸರ್ಕೆ ಜೆವಾನ್ ಅಮಿ ಖೈತ್ನಾ ಇಕಾತ್ ಹಾನುಕ್ ಹೊತಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ಫಿಲಿಪಾಚಿ ಪರಿಕ್ಷಾ ಕರುಕ್ ತೆನಿ ಅಶೆ ಮಟ್ಲ್ಯಾನ್ ತೊ ಕಾಯ್ ಕರ್‍ತಾ ಮನುನ್ ಜೆಜುಕ್ ಗೊತ್ತ್ ಹೊತ್ತೆ, ");
INSERT INTO kans_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ತನ್ನಾ ಫಿಲಿಪಾನ್ ಜವಾಬ್ ದಿಲ್ಲ್ಯಾನ್, “ಹಿತ್ತೆ ಹೊತ್ತ್ಯಾ ಹರಿ ಎಕ್ಲ್ಯಾಕ್ನಿ ಉಲ್ಲೆ-ಉಲ್ಲೆಚ್ ಮಟ್ಲ್ಯಾರ್‍ಬಿ ಭಾಕ್ರಿಯಾ ಇಕಾತ್ ಘೆವ್ಕ್ ದೊನ್ಸೆ ಚಾಂದಿಚೆ ಪೈಸೆ ಲಾಗ್ತ್ಯಾತ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ತ್ಯೆಚ್ಯಾ ಶಿಸಾನಿತ್ಲ್ಯಾ ಅನಿ ಎಕ್ಲ್ಯಾನ್, ಅಂದ್ರು ಮನ್ತಲ್ಯಾನ್, ಹ್ಯೊ ಸಿಮಾವ್ ಪೆದ್ರುಚೊ ಭಾವ್ ತೆನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ಹಿತ್ತೆ ಎಕ್ ಪೊರಾಕ್ಡೆ ಘಂವಾಚ್ಯಾ ಪಾಂಚ್ ಭಾಕ್ರಿಯಾ, ಅನಿ ದೊನ್ ಮಾಸೊಳ್ಯಾ ಹಾತ್, ಖರೆ ತ್ಯಾ ಹ್ಯಾ ಎವ್ಡ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಪಾವಿನ್ಯಾತ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ಜೆಜುನ್ ತೆಂಕಾ, “ಲೊಕಾಕ್ನಿ ಖಾಲ್ತಿ ಬಸ್ವಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ಥೈ ಲೈ ಗವಾತ್ ಹೊತ್ತೆ ತಸೆ ಮನುನ್ ಸಗ್ಳಿ ಲೊಕಾ ಖಾಲ್ತಿ ಬಸ್ಲಿ ಥೈ ಸುಮಾರ್ ಪಾಂಚ್ ಹಜಾರ್ ಘೊಮನ್ಸಾಚ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ಜೆಜುನ್ ಭಾಕ್ರಿ ಘೆಟ್ಲ್ಯಾನ್ ದೆವಾಕ್ ಧನ್ಯವಾದ್ ದಿಲ್ಯಾನ್, ಅನಿ ಥೈ ಬಸಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ವಾಟುಕ್ ಲಾವ್ಲ್ಯಾನ್. ಮಾಸೊಳ್ಯಾಬಿ ತೆನಿ ತಸೆಚ್ ಕರುನ್ ವಾಟುಕ್ ಲಾವ್ಲ್ಯಾನ್, ಲೊಕಾನಿ ತೆಂಕಾ ಪಾಜೆ ತವ್ಡೆ ಜೆವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ತನ್ನಾ ಸಗ್ಳ್ಯಾನಿ ಪೊಟ್ಬರ್ ಜೆವ್ನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ, “ಹುರಲ್ಲೆ ಸಗ್ಳೆ ತುಕ್ಡೆ ಗೊಳಾ ಕರಾ, ಉಲ್ಲೆಸೆಬಿ ಅಮಿ ಹಾಳ್ ಕರ್‍ತಲೆ ನಕ್ಕೊ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ತನ್ನಾ ಜೆಜುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಶಿಸಾನಿ ತುಕ್ಡೆ ಗೊಳಾ ಕರ್ಲ್ಯಾನಿ ಲೊಕಾನಿ ಖಾವ್ನ್ ಹುರಲ್ಲ್ಯಾ ಘಂವಾಚ್ಯಾ ಭಾಕ್ರಿಯಾಂಚ್ಯಾ ತುಕ್ಡ್ಯಾನಿ ಬಾರಾ ಭುಟಿಯಾ ಭರ್‍ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ಜೆಜುನ್ ಕರಲ್ಲೆ ಹೆ ಅಜಾಪ್ ಬಗುನ್ ಥೈ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ “ಹ್ಯೊ ಖರೆಚ್! ಹ್ಯಾ ಜಗಾತ್ ಯೆತಲೊ ಹೊತ್ತೊ ತೊ ಪ್ರವಾದಿ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ಲೊಕಾ ಬಳ್‍ ಜಬ್ಬರಾನ್ ಮಾಕಾ ರಾಜಾ ಕರುಕ್ ಮನುನ್ ಯೆತಾತ್ ಮನುನ್ ಜೆಜುಕ್ ಗೊತ್ತ್ ಹೊತ್ತೆ, ತಸೆ ಮನುನ್ ಜೆಜು ಅನಿ ಪರ್ತುನ್ ಮಡ್ಡಿ ವರ್ತಿ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ಸಾಂಜ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುಚಿ ಶಿಸಾ ಸಮುಂದರಾಕ್ಡೆ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ಢೊನಿತ್ ಚೆಡ್ಲ್ಯಾನಿ, ಅನಿ ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ಬಾಜುಚ್ಯಾ ಕಫರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾವಾಕ್ ಪರ್ತುನ್ ಜಾವ್‍ಲಾಗಲ್ಲ್ಯಾನಿ ತನ್ನಾ ರಾತ್ ಹೊಲ್ಲಿ. ಜೆಜು ಅಜುನ್ ತೆಂಚ್ಯಾ ಕಡೆ ಯೆವ್ಕ್ ನತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ತನ್ನಾ ಎಕ್ ಮೊಟೊ ವಾರೊ ಉಟ್ಲೊ, ಅನಿ ಪಾನಿಯಾಕ್ ವೈರ್-ಖಾಯ್ಲ್ ಕರುಕ್‍ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ಶಿಸಾ ಢೊನಾರ್ ತಿನ್-ಚಾರ್ ಮೈಲಾ ಭುತ್ತುರ್ ಜಾವ್ನ್ ಪಾವಲ್ಲಿ. ತನ್ನಾ ಜೆಜು ಪಾನಿಯಾಚ್ಯಾ ವರ್ತಿ ಚಲುನ್ ಯೆವ್‍ಲಾಗಲ್ಲೊ. ತೆನಿ ತೆಕಾ ಬಗಟ್ಲ್ಯಾನಿ ಅನಿ ತೆನಿ ಭಿಂಯಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ಜೆಜುನ್ ತೆಂಕಾ, “ಭಿಂವ್ನಕಾಶಿ, ಮಿಯಾ ತೊ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ವಾರೊ ಬಂದ್ ಹೊಲ್ಯಾ ತನ್ನಾ ಕುಶಿನ್ ತೆನಿ ಜೆಜುಕ್ ಢೊನಿತ್ ಘೆವ್ಚೆ ಮನುನ್ ತೆನಿ ಕರಲ್ಲ್ಯಾ ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ಡೊನ್ ತೆನಿ ಜಾವ್‍ಲಾಗಲ್ಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಜಾವ್ನ್ ಪಾವ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ದುಸ್ರೆಂದಿಸಿ ತ್ಯಾ ದಂಡೆಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ ಸಮುಂದರಾತ್ ಎಕುಚ್ ಎಕ್ ಢೊನ್ ಹೊತ್ತಿ ಬಗಟ್ಲ್ಯಾನಿ, ಜೆಜು ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಢೊನಿತ್ ಚೆಡುಕ್ ನತ್ತೊ, ಶಿಸಾ ಎವ್ಡೆಚ್ ಥೈತ್ನಾ ಫಿಡೆ ಗೆಲ್ಲಿ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಜೆಜುಕ್ ಫಾಟಿ ಸೊಡುನ್ ಗೆಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ತನ್ನಾ ದುಸ್ರ್ಯಾ ಢೊನಿಯಾ ತಿಬೆರಿಯಾ ಸಮುಂದರಾತ್ನಾ ಧನಿಯಾನ್ ಧನ್ಯವಾದ್ ದಿಲ್ಲ್ಯಾ ಮಾನಾ ಜೆವಾನ್ ಜೆವಲ್ಲ್ಯಾ ಜಾಗ್ಯಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ ಥೈ ನಸಲ್ಲೆ ಬಗುನ್ ಲೊಕಾ ತ್ಯಾ ಢೊನಿಯಾತ್ನಿ ಚೆಡುನ್ ಅನಿ ಜೆಜುಕ್ ಬಗುಕ್ ಮನುನ್ ಕಫರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ಜೆಜು ಸಮುಂದರಾಚ್ಯಾ ತಿಕುಲ್ಯಾ ದಂಡೆಕ್ ಭೆಟಲ್ಲ್ಯಾ ತನ್ನಾ ಲೊಕಾನಿ ಜೆಜುಕ್ “ಗುರುಜಿ, ತಿಯಾ ಹಿತ್ತೆ ಕನ್ನಾ ಯೆಲೆ?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್! ಸಾಂಗ್ತಾ, ತುಮಿ ಮಿಯಾ ಕರಲ್ಲಿ ಅಜಾಪಾ ಬಗುನ್ ನ್ಹಯ್ ತುಮಿ ಪೊಟ್‍ಬರ್ ಭಾಕ್ರಿಯಾ ಖಾಲ್ಯಾಶಿ ಮನುನ್ ಮಾಕಾ ಹುಡ್ಕುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ಹಾಳ್ ಹೊವ್ನ್ ಜಾತಲ್ಯಾ ಜೆವ್ನಾಸಾಟ್ನಿ ರಾಬುನಕಾಶಿ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ದಿತಲ್ಯಾ ಜೆವ್ನಾಸಾಟಿ ರಾಬಾ, ಹೆ ಜೆವಾನ್ ತುಮ್ಕಾ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ದಿತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸರ್ಗಾ ವೈಲ್ಯಾ ಬಾಬಾನ್ ತ್ಯೆಚ್ಯಾವರ್ತಿ ಛಪ್ಪೊ ಮಾರುನ್ ಥವ್ಲ್ಯಾನಾಯ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ತನ್ನಾ ಲೊಕಾನಿ ತೆನಿ, “ದೆವಾಕ್ ಪಾಜೆ ತಶೆ ಕರುಚೆ ಮಟ್ಲ್ಯಾರ್ ಅಮಿ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ಜೆಜುನ್ ತೆಂಕಾ, “ದೆವಾಕ್ ಪಾಜೆ ಹೊಲ್ಲೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್, ಕರ್‍ತಲೆ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ತನ್ನಾ ಲೊಕಾ ತೆನಿ,“ಅಮಿ ಬಗುನ್ ತುಜೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಿ ಸರ್ಕೆ ಕಾಯ್ ಅಜಾಪ್ ಅಮ್ಕಾ ತಿಯಾ ಕರುನ್ ದಾಕ್ವುತೆಯ್? ಕಾಯ್ ಕಾಮ್ ಕರುನ್ ದಾಕ್ವುತೆ ತಿಯಾ?” ");
INSERT INTO kans_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ “ತೆನಿ ತೆಂಕಾ ಸರ್‍ಗಾ ವೈನಾ ಬಾಕ್ರಿ ದಿಲ್ಯಾನ್, ಅನಿ ತೆನಿ ಖಾಲ್ಯಾನಿ ಮಟ್ಲ್ಯಾ ಸರ್ಕೆ ಅಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಲೊಕಾನಿ ಮರುಭುಮಿತ್ ಮನ್ನಾ ಖಾಲ್ಯಾನಿ”. ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಕಾಯ್‍ ತೆ ಸಾಂಗ್ತಾ: ಮೊಯ್ಜೆನ್ ತುಮ್ಕಾ ಸರ್‍ಗಾ ವೈಲಿ ಭಾಕ್ರಿ ದಿವ್‍ನತ್ತ್ಯಾನ್, ಹ್ಯೊ ಮಾಜೊ ಬಾಬಾ ತುಮ್ಕಾ ಖರಿ ಸರ್‍ಗಾ ವೈಲಿ ಭಾಕ್ರಿ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ದೆವಾಚಿ ಭಾಕ್ರಿ ದಿತಾ ಸರ್ಗಾವೈನಾ ಉತ್ರುನ್ ಯೆತಾ, ಅನಿ ಜಗಾಕ್ ಜಿವ್ ದಿತಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ತನ್ನಾ ತೆನಿ, “ಸಾಯ್ಬಾ ಅಮ್ಕಾ ಕನ್ನಾಬಿ ಅಸ್ಲಿಚ್ ಭಾಕ್ರಿ ದಿ” ಮಟ್ಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಸಾಂಗಲ್ಲ್ಯಾನ್, “ಮಿಯಾಚ್ ಜಿವ್ ದಿತಲಿ ಭಾಕ್ರಿ, ಜೆ ಕೊನ್ ಮಾಜ್ಯಾಕ್ಡೆ ಯೆತಾತ್, ತೆಂಕಾ ಕನ್ನಾಬಿ ಭುಕ್ ಲಾಗಿನಾ, ಜೆ ಕೊನ್ ಮಾಜೆ ವರ್ತಿ ವಿಶ್ವಾಸ್, ಕರ್‍ತಾತ್ ತೆಂಕಾ ಕನ್ನಾಚ್ ಸೊಸ್ ಲಾಗಿನಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ಖರೆ ಮಿಯಾ ಮನ್ತಾ ತುಮಿ ಮಾಕಾ ಬಗಟ್ಲ್ಯಾಶಿ ಜಾಲ್ಯಾರ್‍ಬಿ ಅಜುನ್ ತುಮಿ ಮಾಜ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್, ಕರಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಜೆ ಮನುನ್ ಮಾಕಾ ದಿಲ್ಲೆ ಸಗ್ಳಿ ಲೊಕಾ ಮಾಜ್ಯಾಕ್ಡೆ ಯೆತ್ಯಾತ್, ಮಾಜ್ಯಾಕ್ಡೆ ಯೆಲ್ಲ್ಯಾಕ್ನಿ ಮಿಯಾ ಕನ್ನಾಬಿ ಢಕ್ಲುನ್ ಘಾಲಿನಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಸರ್‍ಗಾ ವೈನಾ ಮಾಜ್ಯಾ ಮನಾಚ್ಯಾ ಸರ್ಕೆ ಕರುಕ್ ಯೆವ್ಕ್ ನಾ, ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾಚ್ಯಾ ಮನಾ ಸರ್ಕೆ ಕರುಕ್ ಮನುನ್ ಮಿಯಾ ಯೆಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ಮಾಜ್ಯಾ ಹಾತಿತ್ ಒಪ್ಸುನ್ ದಿಲ್ಲ್ಯಾನಿತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್‍ಬಿ ಕಳ್ದುನ್ ಘೆವ್ಚೆ ನ್ಹಯ್ ಆಕ್ರಿಚ್ಯಾ ದಿಸಿ ಮಿಯಾ ತೆಂಕಾ ಝಿತ್ತೆ ಕರುನ್ ಉಟ್ವುಚೆ, ಮನ್ತಲಿ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಚಿ ಆಶ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ತೆಚೆಸಾಟ್ನಿ ಲೆಕಾಕ್ ಬಗುನ್ ತ್ಯೆಚೆವರ್ತಿ ವಿಶ್ವಾಸ್, ಕರಲ್ಲ್ಯಾಕ್ನಿ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವುಚೆ ಮನ್ತಲಿಚ್ ಮಾಜ್ಯಾ ಬಾಬಾಚಿ ಆಶಾ, ಅನಿ ಮಿಯಾ ತೆಂಕಾ ಆಕ್ರಿಚ್ಯಾ ದಿಸಿ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುತಾ”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ಲೊಕಾ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಪುರ್ಪುಕ್‍ಲಾಗ್ಲಿ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಜುದೆವ್ ಲೊಕಾ ಜೆಜುನ್ ಮಿಯಾ ಸರ್ಗಾವೈನಾ, ಉತ್ರುನ್ ಯೆಲ್ಲಿ ಭಾಕ್ರಿ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ತೆಚೆಸಾಟ್ನಿ ತೆನಿ, “ಹ್ಯೊ ಮಾನುಸ್ ಜುಜೆಚೊ ಲೆಕ್ ಜೆಜು ಹೊಯ್ ಕಾಯ್ ನ್ಹಯ್? ಹೆಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ನಿ ಅಮಿ ಬರೆ ವಳಕ್ತಾಂವ್, ತಸೆ ಜಾಲ್ಯಾರ್, ಹ್ಯೊ ಅಪ್ನಿ ಸರ್‍ಗಾ ವೈನಾ ಉತ್ರುನ್ ಯೆಲಾ ಮನ್ತಾ ತೆ ಕಶೆ?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ತನ್ನಾ ಜೆಜುನ್, ತುಮ್ಚ್ಯಾ-ತುಮ್ಚ್ಯಾ ಮದ್ದಿಚ್ ಪುರ್‍ಪುರ್ತಲೆ ಸೊಡುನ್ ದಿವಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ಬಾಬಾನ್ ಮಾಜ್ಯಾ ಕಡೆ ಯೆಯ್ ಸರ್ಕೆ ಕರ್ಲ್ಯಾ ಶಿವಾಯ್ ಕೊನಾಕ್ಬಿ ಮಾಜಾಕ್ಡೆ ಯೆವ್ಕ್ ಹೊಯ್ನಾ: ಅನಿ ಮಿಯಾ ತೆಕಾ ಆಕ್ರಿಚ್ಯಾ ದಿಸಿ ಝಿತ್ತೆ ಕರುನ್ ಉಟ್ವುತಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ಪ್ರವಾದ್ಯಾನಿ ಲಿವಲ್ಲೆ ಹಾಯ್, ಸಗ್ಳ್ಯಾಕ್ನಿ ದೆವಾನ್ ಶಿಕ್ವುನ್ ಹೊತಾ ಜೆ ಕೊನ್ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ ಆಯಿಕ್ತ್ಯಾತ್ ಅನಿ ಶಿಕ್ತಾತ್ ತೆನಿ ಮಾಜ್ಯಾಕ್ಡೆ ಯೆತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ಅಶೆ ಮನುನ್ ಕೊನ್ಬಿ ಬಾಬಾಕ್ ಬಗಟಲ್ಲೊ ಹಾಯ್ ಮನುನ್ ನ್ಹಯ್, ಜೆ ಕೊನ್ ದೆವಾಚೊ ಮನುನ್ ಹಾಯ್ ತೆನಿ ಎಕ್ಲ್ಯಾನುಚ್ ಬಾಬಾಕ್ ಬಗಟ್ಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಸಾಂಗ್ತಾ! ಜೆ ಕೊನ್ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ ತೆಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ಮಿಯಾಚ್ ಜಿವ್ ದಿತಲಿ ಭಾಕ್ರಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ತುಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಲೊಕಾನಿ ಮರುಭುಮಿತ್ ಮನ್ನಾ ಖಾಲ್ಯಾನಿ ಖರೆ ತೆನಿ ಮರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ಖರೆ ಸರ್ಗಾವೈನಾ, ಉತ್ರುನ್ ಯೆಲ್ಲಿ ಭಾಕ್ರಿ ದುಸ್ರ್ಯಾಚ್ ನಮುನ್ಯಾಚಿ, ಜೆ ಕೊನ್ ಹಿ ಭಾಕ್ರಿ ಖಾತಾ ತೊ ಕನ್ನಾಚ್ ಮರಿನಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ಮಿಯಾ ಸರ್ಗಾವೈನಾ, ಉತ್ರುನ್ ಯೆಲ್ಲಿ ಝಿತ್ತಿ ಭಾಕ್ರಿ, ಹಿ ಭಾಕ್ರಿ ತುಮಿ ಖಾಲ್ಯಾಶಿ ತರ್, ತುಮ್ಕಾ ಮರಾನುಚ್‍ ನಾ, ಅನಿ ಹ್ಯಾ ಜಗಾಕ್ ಜಿವ್ ದಿವ್‍ಸಾಟಿ ಮನುನ್ ಮಿಯಾ ತುಮ್ಕಾ ದಿತಲಿ ಭಾಕ್ರಿ ಮಾಜೆ ಶರಿರ್, ಜಗ್ ಝಿತ್ತೊ ರ್‍ಹಾವ್ಕ್ ಪಾಜೆ ಮನುನ್ ತೆಚ್ಯಾ ಸಾಟ್ನಿ ಮಿಯಾ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ಹೆ ಆಯ್ಕುನ್ ತೆಂಚ್ಯಾ ಮದ್ದಿ ರಾಗಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಉಟುಕ್‍ ಲಾಗ್ಲ್ಯಾ, ತೆನಿ “ಹ್ಯೊ ಮಾನುಸ್ ಅಮ್ಕಾ ಖಾವ್ಕ್ ಅಪ್ನಾಚೆ ಮಾಸ್ ದಿತಾ: ಮನ್ತಾ ಮಟ್ಲ್ಯಾರ್ ಹೆ ಕಶೆ?” ಮನುನ್ ಇಚಾರುಕ್ ಲಾಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ಜೆಜುನ್ ತೆಂಕಾ, “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ತುಮಿ ಮಾನ್ಸಾಚ್ಯಾಲೆಕಾಚೆ ಶರಿರ್ ಖಾಯ್ನಸ್ಲ್ಯಾರ್, ಅನಿ ರಗಾತ್ ಫಿ ನಸ್ಲ್ಯಾರ್ ತುಮ್ಚ್ಯಾ ಭುತ್ತುರ್ ಜಿವುಚ್ ರ್‍ಹಾಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ಜೆ ಕೊನ್ ಮಾಜೆ ಶರಿರ್ ಖಾತಾತ್, ಅನಿ ರಗಾತ್ ಫಿತಾತ್ ತೆಂಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ಗಾವ್ತಾ, ಆಕ್ರಿಚ್ಯಾ ದಿಸಿ ಮಿಯಾ ತೆಂಕಾ ಝಿತ್ತೆ ಕರುನ್ ಉಟ್ವುತಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ಮಾಜೆ ಶರಿರ್ ಖರೆ ಖಾನ್, ಅನಿ ಮಾಜೆ ರಗಾತ್ ಖರೆ ಫಿವನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ಜೆ ಕೊನ್ ಮಾಜೆ ಶರಿರ್ ಖಾತಾತ್ ಅನಿ ರಗಾತ್ ಫಿತಾತ್ ತೆನಿ ಮಾಜ್ಯಾ ಭುತ್ತುರ್ ಜಿವನ್ ಕರ್‍ತಾತ್ ಅನಿ ಮಿಯಾ ತೆಂಚ್ಯಾ ಭುತ್ತುರ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ಝಿತ್ತ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್ ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ಝಿತ್ತೊ ರ್‍ಹಾತಾ, ಅಶೆ ಜೆ ಕೊನ್ ಮಾಕಾ ಖಾತಾತ್. ತೆನಿ ಬಿ ಝಿತ್ತೆ ರ್‍ಹಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ಅಶೆ ರ್‍ಹಾತಾನಾ, ಸರ್ಗಾವೈನಾ, ಉತ್ರುನ್ ಯೆಲ್ಲಿ ಭಾಕ್ರಿ ತುಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಲೊಕಾನಿ ಖಲ್ಲ್ಯಾ ಭಾಕ್ರಿ ಸರ್ಕಿ ನ್ಹಯ್, ತೆನಿ ಮರುನ್ ಗೆಲೆ, ಖರೆ ಜೆ ಕೊನ್ ಹಿ ಭಾಕ್ರಿ ಖಾತಾತ್ ತೆನಿ ಕನ್ನಾಚ್ ಮರಿನ್ಯಾತ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ಕಫರ್‍ನವ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಸಿನಾಗೊಗಾತ್ ಶಿಕ್ವಲ್ಲ್ಯಾ ಸರ್ಕೆ ಜೆಜುನ್ ಹೆ ಸಗ್ಳೆ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ಹೆ ಅಯ್ಕಲ್ಲೆ ಸುಮಾರ್ ತೆಚೆ ವಾಂಗ್ಡಿ “ಹೆ ಶಿಕಾಪ್ ಲೈ ಕಟಿನ್, ಹೆ ಸಗ್ಳೆ ಕೊನ್ ಆಯಿಕ್ತಾ” ಮನುಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಅಪ್ನಾಚಿ ಶಿಸಾ ಪುರ್ಪುರುಲಾಲ್ಯಾತ್ ಮನುನ್ ಜೆಜುಕ್ ಕಳಲ್ಲೆ, ತನ್ನಾ ತೆನಿ ತೆಂಕಾ “ಹೆ ತುಮ್ಕಾ ಆಯ್ಕುನ್ ತರಾಸ್ ಹೊವ್ನ್ ಮಾಕಾ ಸೊಡುನ್ ಜಾಯ್ ಸರ್ಕೆ ಕರುಕ್ ಲಾಗ್ಲಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ತರ್ ತುಮಿ ಮಾನ್ಸಾಚೊ ಲೆಕ್‍ ತೊ ಅದ್ದಿ ಹೊತ್ತ್ಯಾ ಜಾಗ್ಯಾತ್‍ ಜಾತಲೆ ಬಗ್ಲ್ಯಾರ್ ತುಮಿ ಕಾಯ್ ಕರ್‍ತ್ಯಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ದೆವಾಚೊ ಆತ್ಮೊ ಜಿವ್ ದಿತಾ, ಮಾನ್ಸಾಚ್ಯಾ ತಾಕ್ತಿಚೊ ಕಾಯ್ಬಿ ಫಾಯ್ದೊ ನಾ. ಮಿಯಾ ತುಮ್ಚ್ಯಾ ಕಡೆ ಬೊಲಲ್ಲ್ಯಾ ಹ್ಯಾ ಗೊಸ್ಟಿಯಾ ದೆವಾಚ್ಯಾ ಆತ್ಮೊ ಹೊಲಾ ಹ್ಯೊ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ಅಜುನ್ಬಿ ತುಮ್ಚ್ಯಾತ್ಲೆ ಉಲ್ಲಿ ಲೊಕಾ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾತ್”. ಅದ್ದಿಕ್ನಾ ಅಪ್ನಾಚ್ಯಾ ವಾಗ್ಡಾ ಹೊತ್ತೆಚ್ ವಿಶ್ವಾಸ್ ಧರಿನ್ಯಾತ್ ಅನಿ ಹ್ಯಾತುರ್‍ಲೊಚ್ ಕೊನ್ ತರ್ ಅಪ್ನಾಕ್ ಘಾತ್ ಕರ್‍ತಾ ಮನುನ್ ಜೆಜುಕ್ ಅದ್ದಿಚ್ ಗೊತ್ತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ಜೆಜುನ್ ಫಿಡೆ ಬೊಲುನ್ ತೆನಿ,“ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ಬಾಬಾನ್ ಯೆಯ್ ಸರ್ಕೆ ಕರ್‍ತಲ್ಯಾ ಶಿವಾಯ್ ಮಾಜ್ಯಾಕ್ಡೆ ಕೊನ್ಬಿ ಯೆಯ್ನಾತ್ ಮನುನ್ ಮಿಯಾ ಸಾಂಗಲ್ಲೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ಹ್ಯಾ ಗೊಸ್ಟಿಯಾ ಲಾಗುನ್ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ ಸುಮಾರ್ ಲೊಕಾ ತೆಕಾ ಸೊಡುನ್ ಗೆಲಿ, ಅನಿ ತ್ಯೆಚ್ಯಾ ಫಾಟ್ನಾ ಕನ್ನಾಬಿ ಯೆವ್ಕನಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ಬಾರಾಜಾನ್ ಶಿಸಾಕ್ನಿ,“ತುಮ್ಕಾಬಿ ಮಾಕಾ ಸೊಡುನ್ ಜಾವ್ಕ್ ಪಾಜೆ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ತನ್ನಾ ಸಿಮಾವ್ ಪೆದ್ರುನ್,“ಧನಿಯಾ ಅಮಿ ಕೊನಾಕ್ಡೆ ಜಾತಲೆ? ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೊ ಜಿವ್ ದಿತಲಿ ಶಬ್ದಾ ತುಜೆಕ್ಡೆ ಎವ್ಡೆಚ್ ಹಾತ್” ");
INSERT INTO kans_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ಅನಿ ಅತ್ತಾ ಅಮ್ಕಾ ತಿಯಾ ದೆವಾಕ್ನಾ ಯೆಲ್ಲೊ ಪವಿತ್ರ್ ಮನುನ್ ಕಳ್ಳಾ ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ತನ್ನಾ ಜೆಜುನ್ ಜವಾಬ್ ದಿಲ್ಲ್ಯಾನ್ “ತುಮ್ಚ್ಯಾ ಬಾರಾ ಜಾನಾಕ್ನಿ ಮಿಯಾಚ್ ಎಚುಕ್ನಾ ಕಾಯ್? ಜಾಲ್ಯಾರ್‍ಬಿ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಎಕ್ಲೊ ಗಿರೊ ಹಾಯ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ತೊ ಸಿಮಾವ್ ಇಸ್ಕರಿಯೊತಾಚ್ಯಾ ಲೆಕಾ ಜುದಾಸಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲಾಗಲ್ಲೊ, ತೊ ತ್ಯಾ ಬಾರಾ ಜಾನಾ ಶಿಸಾನಿತ್ಲೊ ಹೊಲ್ಯಾರ್ಬಿ ತೆಕಾ ಘಾತ್ ಕರ್‍ನಾರ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ಹೆಚ್ಯಾ ಮಾನಾ ಜೆಜು ಗಾಲಿಲಿಯಾತ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಫಿರುಕ್ ಲಾಗ್ಲೊ. ಜುದೆವ್ ಲೊಕಾ ತೆಕಾ ಜಿವಾನಿ ಮಾರುಕ್ ರಾಕುನ್ಗೆತ್ ಹೊತ್ತೆ, ತಸೆ ಮನುನ್ ತೆಕಾ ಜುದೆಯಾತ್ ಫಿರುಕ್ ನಕ್ಕೊ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ಜುದೆವಾನಿ ಕರ್‍ತಲೊ ತಂಬಾಂಚೊ ಸನ್ ಜಗೊಳ್ ಯೆಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ತಸೆಮನುನ್ ತೆಚ್ಯಾ ಭಾವಾನಿ ತೆಕಾ “ತಿಯಾ ಹಿತ್ತೆತ್ನಾ ಭಾಯ್ರ್ ಜಾವ್ನ್ ಜುದೆಯಾಕ್ ಚಲ್ ಅಶೆಚ್ ತಿಯಾ ಕರ್‍ತೆ ತಿ ಅಜಾಪಾ ತುಜ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತಿ ಲೊಕಾ ಬಗ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ಖಲೊ ಮಾನುಸ್ ಬಿ ಲೊಕಾಚ್ಯಾ ಫಿಡೆ ಬರೊ ಹೊವ್ಕ್ ಹೊತಾ ಅಪ್ನಾಚಿ ಅಪ್ನಿ ಕರ್‍ತಲಿ ಕಾಮಾ ನಿಪುನ್-ನಿಪುನ್ ಕರಿನಾ ತಿಯಾ ಅಜಾಪಾ ಕರುನ್ ದಾಕ್ವುವುಚೆ ತಸೆಮನುನ್ ತಿಯಾ ಕರ್‍ತಲಿ ಕಾಮಾ ಸಗ್ಳ್ಯಾ ಜಗಾಕ್ ಕಳಿ ಸಾರ್ಕೆ ಕರ್!” ");
INSERT INTO kans_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ತ್ಯೆಚ್ಯಾ ಭಾವಾನಿ ಸೈತ್ ತ್ಯೆಚ್ಯಾವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರುಕನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ಜೆಜುನ್ ತೆಂಕಾ, “ಅಜುನ್ ಮಾಜೊ ಸಮಾ ಎಳ್ ಯೆವ್ಕ್ ನಾ. ತುಮ್ಕಾ ಸಗ್ಳೊ ಎಳ್‍ಬಿ ಸಮಾಚ್. ");
INSERT INTO kans_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ಹ್ಯೊ ಜಗ್ ತುಮ್ಚೊ ದ್ವೆಸ್ ಕರಿನಾ ಖರೆ ತೊ ಮಾಜೊ ದ್ವೆಸ್ ಕರ್‍ತಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ತೆಚಿ ವಾಟಾ ಬುರ್ಶ್ಯಾ ಹಾತ್ ಮನುನ್ ಸಾಂಗುಂಗೆತ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ತುಮಿ ಸನಾಕ್ ಜಾವಾ ಮಿಯಾ ಹ್ಯಾ ಸನಾಕ್ ಜಾಯ್ನಾ ಹೊಲಾ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಾಜೊ ಸಮಾ ಎಳ್ ಅಜುನ್ ಯೆವ್ಕ್ ನಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ಎವ್ಡೆ ಸಾಂಗುನ್ ಜೆಜು ಗಾಲಿಲಿಯಾತುಚ್ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ಹೆಚ್ಯಾ ಮಾನಾ ತೆಚಿ ಭಾವಾ ಸನಾಕ್ ಗೆಲಿ, ಜೆಜುಬಿ ಗೆಲೊ ಖರೆ ತೊ ಕೊನಾಕ್ಬಿ ಕಳಿನಸ್ತಾನಾ ಗೆಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ಸನಾತ್ ಜುದೆವಾಂಚೆ ಅದಿಕಾರಿ ಜೆಜುಕ್ ಹುಡ್ಕುಕ್ ಲಾಗಲ್ಲೆ. ಅನಿ “ಖೈ ಹಾಯ್ ತೊ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ಥೈ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಲೈ ಪುಸ್ಪುಸುನ್ ಬೊಲುಲಾಗಲ್ಲ್ಯಾನಿ. ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ “ತೊ ಬರೊ ಮಾನುಸ್” ಮಟ್ಲ್ಯಾನಿ ಅನಿ ಹುರಲ್ಲ್ಯಾನಿ, “ನಾ, ತೊ ಲೊಕಾಕ್ನಿ ಪಸ್ವುಲಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ಖರೆ ಕೊನ್ಬಿ ತ್ಯೆಚ್ಯಾ ವಿಶಯಾತ್ ಫೊಡುನ್ ಬೊಲುಕ್ನ್ಯಾತ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಜುದೆವಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಕ್ನಿ ಭಿಂವುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ಸನ್ ಜಗ್ಗೊಳ್ ಅರ್ದೊ ಹೊಲ್ಲೊ ತನ್ನಾ ಜೆಜು ಗುಡಿತ್ ಗೆಲೊ, ಅನಿ ಶಿಕ್ವುಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ಜುದೆವಾಂಚೆ ಅದಿಕಾರಿ ಲೈ ಅಜಾಪ್ ಹೊಲೆ, ಅನಿ “ಹ್ಯೊ ಮಾನುಸ್ ಶಿಕುಕ್‍ನಾ ನಾ ಕಾಯ್ ನಾ, ಎವ್ಡೆ ಸಗ್ಳೆ ಹೆಕಾ ಕಶೆ ಗೊತ್ತ್ ಹಾಯ್?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ಜೆಜುನ್ ತೆಂಕಾ, “ಮಿಯಾ ಶಿಕ್ವುತಲೆ ಮಾಜೆ ಸ್ವತಾಚೆ ಶಿಕಾಪ್ ನ್ಹಯ್, ತೆ ದೆವಾಕ್ನಾ ಯೆತಾ, ತ್ಯೆನಿಚ್ ಮಾಕಾ ಧಾಡ್ವುನ್ ದಿಲಾ”. ");
INSERT INTO kans_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ಜೆ ಕೊನ್ ದೆವಾಕ್ ಕಾಯ್ ಪಾಜೆ ಹೊಲ್ಲೆ ತೆ ಕರ್‍ತಾ ತೆಕಾ ಮಿಯಾ ಶಿಕ್ವುತಲೆ ದೆವಾಕ್ನಾ ಯೆಲಾ ಕಾಯ್, ಮಿಯಾ ಮಾಜ್ಯಾಚ್ ಅದಿಕಾರ್‍ಯಾನ್ ಬೊಲುಲಾ ಮನುನ್ ಸ್ವತಾಚೆ ಕಳ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ಜೆ ಕೊನ್ ಸ್ವತಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಬೊಲ್ತ್ಯಾತ್, ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಅಪ್ನಿ ಮಹಿಮಾ ಜೊಡುನ್ ಘೆವ್ಕ್ ಕಟ್ಪಟ್ತಾತ್. ಖರೆ ಜೆ ಕೊನಾಕ್ ತೆಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಚಿ ಮಹಿಮಾ ಪಾಜೆ ತೊ ನಿಯತ್ತಿಚೊ, ಅನಿ ತೆಚ್ಯಾ ಭುತ್ತುರ್ ಕಾಯ್ಬಿ ಝುಟೆ ಮನ್ತಲೆ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ತುಮ್ಕಾ ಮೊಯ್ಜೆನ್ ಖಾಯ್ದೆ ದಿಲ್ಲೆ ಹೊಯ್ ಕಿ ನ್ಹಯ್? ಖರೆ ತುಮ್ಚ್ಯಾತ್ಲೊ ಕೊನ್ಬಿ ಹೆ ಖಾಯ್ದೆ ಪಾಳಿನಾ. ತುಮಿ ಮಾಕಾ ಜಿವಾನಿ ಮಾರುಕ್ ಕಶ್ಯಾಕ್ ಬಗುಲ್ಯಾಸಿ?\" ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ತನ್ನಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾನ್ “ತುಕಾ ಗಿರೊ ಲಾಗ್ಲಾ! ಕೊನ್ ತುಕಾ ಜಿವಾನಿ ಮಾರುಕ್ ಬಗುಲ್ಯಾತ್?” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ಎಕ್ ಅಜಾಪ್ ಕರ್‍ಲೊ ತುಮಿ ಸಗ್ಳೆ ಅಜಿಪ್ ಹೊಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ಮೊಯ್ಜೆನ್ ತುಮ್ಕಾ ತುಮ್ಚ್ಯಾ ಲೆಕಾಂಚಿ ಸುನ್ನತ್ ಕರುಚಿ ಮನುನ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್. ಹೆ ಮೊಯ್ಜೆನ್ ನ್ಹಯ್ ತುಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಲೊಕಾನಿಚ್ ಚಾಲು ಕರಲ್ಲೆ ಅಶೆಚ್ ತುಮಿ ಸಬ್ಬಾತಾಚ್ಯಾ ದಿಸಿ ಎಕ್ ಝಿಲ್ಗ್ಯಾಚಿ ಸುನ್ನತ್ ಕರ್‍ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ಜರ್ ತರ್ ಸಬ್ಬಾತಾಚ್ಯಾ ದಿಸಿ ಎಕ್ ಝಿಲ್ಗ್ಯಾಚಿ ಸುನ್ನತ್ ಕರ್‍ತ್ಯಾಶಿ, ತರ್ ಮೊಯ್ಜೆನ್ ದಿಲ್ಲೊ ಖಾಯ್ದೊ ಮೊಡ್ಲ್ಯಾ ಸರ್ಕೆ ಹೊಯ್ನಾ, ತಸೆಜಾಲ್ಯಾರ್ ಎಕ್ ಮಾನ್ಸಾಕ್ ಸಬ್ಬಾತಾ ದಿಸಿ ಬರೆ ಕರ್ಲ್ಯಾರ್ ತುಮ್ಕಾ ಕಶ್ಯಾಕ್ ತುಮಿ ಕೆಕಾ ರಾಗ್ ಯೆವ್ಲಾ? ");
INSERT INTO kans_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ಭಾಯ್ಲೆ ಬಗುನ್ ನಿತ್ ಕರುನಕಾಶಿ, ಖರೆಪಾನಾನ್ ನಿತ್ ಕರಾ”. ");
INSERT INTO kans_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ಜೆರುಜಲೆಮಾತ್ ರ್‍ಹಾತಲಿ ಉಲ್ಲಿ ಲೊಕಾನಿ, “ಅದಿಕಾರಿ ಜಿವಾನಿ ಮಾರುಕ್ ಬಗುನಗೆತ್ ಹಾತ್ ಹೆಕಾಚ್ ನ್ಹಯ್ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ತರ್‍ಬಿ ತೊ ಹಿತ್ತೆ ಕೊನಾಚೆಬಿ ಭಿಂಯೆನಸ್ತಾನಾ ಬೊಲುಲಾ, ಅನಿ ಕೊನ್ಬಿ ತೆಕಾ ಕಾಯ್ಬಿ ಮನಿನಾ ಹೊಲ್ಯಾತ್! ಖರೆ ಹ್ಯೊಚ್ ಮೆಸ್ಸಿಯಾ ಮನುನ್ ಅಮ್ಚ್ಯಾ ಜಾನ್ತ್ಯಾಕ್ನಿ ಕಳ್ಳೆಕಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ಮೆಸ್ಸಿಯಾ ಯೆಲ್ಲ್ಯಾತನ್ನಾ ತೊ ಖೈತ್ನಾ ಯೆಲಾ ಮನುನ್ ಕೊನಾಕ್ಬಿ ಗೊತ್ತ್ ರ್‍ಹಾಯ್ನಾ. ಹ್ಯೊ ಮಾನುಸ್ ಖೈತ್ನಾ ಯೆಲಾ ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ತನ್ನಾ ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಶಿಕ್ವುತಾನಾ ಜೆಜುನ್ ಮೊಟ್ಯಾ ಅವಾಜಾನ್, ಮಿಯಾ ಕೊನ್ ಅನಿ ಖೈತ್ನಾ ಯೆಲಾ ಮನುನ್ ತುಮ್ಕಾ ಖರೆಚ್! ಗೊತ್ತ್ ಹಾಯ್ ಕಾಯ್? ಮಿಯಾ ಮಾಜ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಯೆವ್ಕ್ ನಾ. ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲೊ ಖರೊ ಮಾನುಸ್. ತುಮಿ ತೆಕಾ ವಳ್ಕಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ಖರೆ ಮಿಯಾ ತೆಕಾ ವಳಕ್ತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ತೆಚೆಕ್ನಾಚ್ ಯೆಲಾ ಅನಿ ತೆನಿಚ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ತನ್ನಾ ತೆನಿ ತೆಕಾ ಧರುಕ್ ಬಗಟ್ಲ್ಯಾನಿ, ಖರೆ ಕೊನಾಕ್ಬಿ ತೆಕಾ ಹಾತ್ ಲಾವುಕ್ ಹೊವುಕ್ನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಅಜುನ್ ತೆಚೊ ಎಳ್ ಯೆವ್ಕ್ ನತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ಖರೆ ತ್ಯಾ ತಾಂಡ್ಯಾತ್ಲ್ಯಾ ಸುಮಾರ್ ಲೊಕಾನಿ ತೆಚೆವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನಿ ಅನಿ, “ಮೆಸ್ಸಿಯಾ ಯೆಲ್ಲ್ಯಾತನ್ನಾ ಹ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾನ್ಕಿ ಜಾಸ್ತಿ ಅಜಾಪಾ ಕರ್‍ತಾ ಕಾಯ್?” ತೆಚ್ಯಾನ್ಕಿ ಲೈ ಕರುಕ್ ಹೊಯ್ ನಾ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ಲೊಕಾಂಚೊ ತಾಂಡೊ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಪುಸ್ವುಸುನ್ ಬೊಲ್ತಲೆ ಸಗ್ಳೆ ಫಾರಿಜೆವಾನಿ ಆಯಿಕ್ಲ್ಯಾನಿ, ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ಅನಿ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಉಲ್ಲ್ಯಾ ರಾಕ್ವಾಲ್ಯಾಕ್ನಿ ಜೆಜುಕ್ ಧರುಕ್ ಮನುನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ತನ್ನಾ ಜೆಜುನ್, “ಅನಿ ಎಕ್ ಉಲ್ಲೊಸೊಚ್ ಎಳ್ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾತಾ, ಮಾನಾ ಮಿಯಾ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಕ್ಡೆ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ತುಮಿ ಮಾಕಾ ಹುಡಕ್ತ್ಯಾಶಿ ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಗಾವಿನಾ ಕಶ್ಯಾಕ್‍ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಖೈ ರ್‍ಹಾತಾ ಥೈ ತುಮ್ಚ್ಯಾನ್ ಯೆವ್ಕ್ ಹೊಯ್ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ಜುದೆವಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನಿ ಅಪ್ನಾಂಚ್ಯಾ ಮದ್ದಿಚ್, “ಅಮ್ಕಾ ಗಾವಿನಸ್ಲ್ಯಾಕ್ಡೆ ಹ್ಯೊ ಖೈ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ? ಹ್ಯೊ ಅಮ್ಚಿ ಲೊಕಾ ಹೊತ್ತ್ಯಾ ಗ್ರಿಕ್ ಶಾರಾಕ್ನಿ ಜಾವ್ನ್ ಶಿಕ್ವುತಾ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ತೊ ಅಮಿ ತೆಕಾ ಹುಡಕ್ತಾಂವ್ ಖರೆ ತೊ ಅಮ್ಕಾ ಗಾವಿನಾ, ಅನಿ ಮಿಯಾ ಖೈ ಜಾತಾ ಥೈ ಯೆವ್ಕ್ ಹೊಯ್ನಾ ಮನ್ತಾ. ಹೆಚ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚೊ ಅರ್ತ್ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ಸನಾಚ್ಯಾ ಆಕ್ರಿಚ್ಯಾ ಅನಿ ಲೈ ಮಹತ್ವಾಚ್ಯಾ ದಿಸಿ ಜೆಜು ಇಬೆ ರ್‍ಹಾಲೊ ಅನಿ ಮೊಟ್ಯಾನ್, “ಜೆ ಕೊನ್ ಸೊಸೆನ್ ಹಾತ್ ತೆನಿ ಮಾಜಾಕ್ಡೆ ಯೆಂವ್ದಿತ್ ಅನಿ ಫಿಂವ್ದಿತ್, ");
INSERT INTO kans_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಮನ್ತಾ 'ಜೆ ಕೊನ್ ಮಾಜೆರ್ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾತ್ ತೆಂಚ್ಯಾ ಭುತ್ತುರುಚ್ ಜಿವ್‍ದಿತಲ್ಯಾ ಪಾನಿಯಾಚೆ ಝರೆ ಫುಟ್ತಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ಜೆಜು ಆತ್ಮ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲ್ಲ್ಯಾನ್. ಹೆ ಅಪ್ನಾಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಲ್ಯಾಕ್ನಿ ಗಾವ್ತಲೆ ಹೊತ್ತೆ. ಪವಿತ್ರ್ ತ್ಯಾ ಎಳಾರ್ ಅಜುನ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಕ್ ದಿಲ್ಲೆ ನತ್ತೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಅಜುನ್ ಬಿ ಜೆಜುಕ್ ಮಹಿಮೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಉಟ್ವಲ್ಲೆ ನತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ತಾಂಡ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಜೆಜುನ್ ಹೆ ಸಾಂಗ್ತಲೆ ಆಯ್ಕಲ್ಲ್ಯಾನ್ ಅನಿ, “ಹ್ಯೊ ಮಾನುಸ್ ಖರೊಚ್ ಎಕ್ ಪ್ರವಾದಿ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ಅನಿ ಹುರಲ್ಲ್ಯಾನಿ, “ತೊ ಮೆಸ್ಸಿಯಾ!” ಮಟ್ಲ್ಯಾನಿ. ಖರೆ ಅನಿ ಉರಲ್ಲ್ಯಾನಿ “ಮೆಸ್ಸಿಯಾ ಗಾಲಿಲಿಯಾತ್ನಾ ಯೆಯ್ನಾ!” ");
INSERT INTO kans_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಮನ್ತಾ “ಮೆಸ್ಸಿಯಾ ದಾವಿದ್ ರಾಜಾಚ್ಯಾ ಘರಾನ್ಯಾಚೊ ಅನಿ ತೊ ದಾವಿದಾನ್ ಜಿವನ್ ಕರಲ್ಲ್ಯಾ ಬೆತ್ಲೆಹೆಮಾತ್ ಉಪಾಜ್ತಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ಅಶೆಚ್ ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ಜೆಜುಕ್ ಲಾಗುನ್ ಭಾಗ್ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ಧರುಚೆ ಮನುನ್ ಬಗಟ್ಲ್ಯಾನಿ, ಖರೆ ಕೊನಾಕ್ಬಿ ತೆಕಾ ಹಾತ್ ಲಾವ್ಕ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ರಾಕ್ವಾಲಿ ಫಾಟಿ ಪರ್ತುನ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಅನಿ ಫಾರಿಜೆವಾನಿ ತೆಂಕಾ, “ತುಮಿ ತೆಕಾ ಕಶ್ಯಾಕ್ ಹಾನುಕ್‍ನ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ತನ್ನಾ ರಾಕ್ವಾಲ್ಯಾನಿ “ಹ್ಯೊ ಮಾನುಸ್ ಬೊಲ್ತಾ ತಶೆ ಕೊನ್ಬಿ ಕನ್ನಾಬಿ ಬೊಲುಕ್ನಾ!” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ತನ್ನಾ ಫಾರಿಜೆವಾನಿ, “ತುಮ್ಕಾಬಿ ತೆನಿ ಪಿಸ್ವುನ್ ಘಾಟ್ಲ್ಯಾನ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“ಕನ್ನಾಬಿ ತುಮ್ಕಾ ಅದಿಕಾರ್‍ಯಾನಿತ್ಲೊ ಎಕ್ಲೊ ನಾ ಹೊಲ್ಯಾರ್ ಫಾರಿಜೆವಾನಿತ್ಲೊ ಎಕ್ಲೊ ತೆಚೆವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ ಮನುನ್ ಗೊತ್ತ್ ಹಾಯ್ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ನಾ ಹ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಮೊಯ್ಜೆಚೆ ಖಾಯ್ದೆ ಗೊತ್ತ್ ನಾತ್, ತಸೆಮನುನ್ ತೆನಿ ದೆವಾಚ್ಯಾ ಸರಾಪಾತ್ ಹಾತ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ಫಾರಿಜೆವಾನಿತ್ಲೊ ಎಕ್ಲೊ ನಿಕೊದೆಮ್ ಮನ್ತಲೊ, ತೊ ಜೆಜುಕ್ ಭೆಟುಕ್ ಮನುನ್ ಗೆಲ್ಲೊ ತೆನಿ ಅನಿ ಹುರಲ್ಲ್ಯಾಕ್ನಿ, ");
INSERT INTO kans_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಕೊನಾಕ್ಬಿ ಬರೆ ಕರುನ್ ಆಯ್ಕಲ್ಲ್ಯಾ ಶಿವಾಯ್ ಅನಿ ತೆನಿ ಕರಲ್ಲಿ ಚುಕ್ ಹುಡ್ಕುನ್ ಕಾಡ್ಲ್ಯಾ ಶಿವಾಯ್ ತೊ ಮಾನುಸ್ ಚುಕಿದಾರ್ ಮನುನ್ ಸಾಂಗುಕ್ ಹೊಯ್ನಾ” ಮಟ್ಲ್ಯಾನ್ ");
INSERT INTO kans_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ತನ್ನಾ ತೆನಿ,“ಬರೆ ಜಾಲ್ಯಾರ್, ತಿಯಾಬಿ ಗಾಲಿಲಿಯಾತ್ಲೊ ಕಾಯ್? ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ವಾಚ್, ಗಾಲಿಲಿಯಾತ್ನಾ ಕನ್ನಾಬಿ ಪ್ರವಾದಿ ಯೆಯ್ನಾ ಮನುನ್ ತಿಯಾ ಶಿಕ್ತೆ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ಮಾನಾ ತೆನಿ ಹರಿ ಎಕ್ಲೆ ತ್ಯೆಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ಖರೆ ಜೆಜು ಒಲಿವ್ ಮಡ್ಡಿ ವರ್ತಿ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ತೊ ಪರ್ತುನ್ ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ಡೆ ಗೆಲೊ ಸಗ್ಳಿ ಲೊಕಾ ತೆಚ್ಯಾ ಭೊತ್ಯಾನಿ ಗೊಳಾ ಹೊಲ್ಲಿ, ತನ್ನಾ ತೊ ಖಾಲ್ತಿ ಬಸುನ್ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ಶಾಸ್ತರಾ ಶಿಕ್ವುತಲ್ಯಾನಿ ಅನಿ ಫಾರಿಜೆವಾನಿ ವೆಭಿಚಾರ್ ಕರ್‍ತಾನಾ ಗಾವುನ್ ಪಡಲ್ಲ್ಯಾ ಎಕ್ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ, ಅನಿ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ತಿಕಾ ಇಬೆ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ತೆನಿ ಜೆಜುಕ್,“ಗುರುಜಿ ಹಿ ಬಾಯ್ಕೊಮನುಸ್ ವೆಭಿಚಾರ್ ಕರ್‍ತಾನಾಚ್ ಗಾವುನ್‍ ಪಡ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ಅಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ ಮೊಯ್ಜೆನ್ ಅಸ್ಲ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ಗುಂಡ್ಯಾನಿ ಮಾರುನ್ ಜಿವ್ ಕಾಡುಚೆ ಮನುನ್ ಹುಕುಮ್ ದಿಲ್ಯಾನಾಯ್. ಅತ್ತಾ ತಿಯಾ ಕಾಯ್ ಮನ್ತೆ?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ಜೆಜುಕ್ ಗೊಂದ್ಳುನ್ ಘಾಲುನ್ ಹೆಚ್ಯಾವೈನಾ ತೆಕಾ ಶಿರ್ಕುನ್ ಘಾಲುಕ್ ಮನುನ್ ಅಶೆಚ್ ಮಟ್ಲ್ಯಾನಿ. ಖರೆ ತೊ ಖಾಲ್ತಿ ವ್ಹಾಕ್ಲೊ ಅನಿ ತ್ಯೆಚ್ಯಾ ಬೊಟಾನಿ ಜಿಮ್ನಿ ವರ್ತಿ ಲಿವ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ತೆನಿ ಪರಸ್ನೆ ಇಚಾರುಂಗೆತ್ ಇಬೆ ಹೊತ್ತೆ, ತನ್ನಾ ತೊ ನಿಟ್ ಇಬೆ ರ್‍ಹಾಲೊ ಅನಿ ತೆಂಕಾ, “ತುಮ್ಚ್ಯಾತ್ಲೊ ಕೊನ್ ಪಾಪ್ ಕರುಕ್ನಾ ತೊ ಅದ್ದಿ ತಿಕಾ ಗುಂಡೊ ಮಾರುಂದಿ” ಮಟ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ಅನಿ ತೊ ಖಾಲ್ತಿ ವ್ಹಾಕ್ಲೊ ಅನಿ ಜಿಮ್ನಿ ವರ್ತಿ ಲಿವ್ಕ್‌ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ಅಶೆಚ್ ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಮ್ಹಾತಾರ್‍ಯಾಕ್ನಾ ಧರುನ್ ಹರೆಕ್ಲೊ ಎಕೆಕ್ಲೆಚ್ ಸಗ್ಳಿ ಲೊಕಾ ಗೆಲೆ ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾ ಬಾಯ್ಕೊಮನ್ಸಿಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆಜು ಎಕ್ಲೊಚ್ ಹುರ್‍ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ಜೆಜು ನಿಟ್ ಇಬೆ ರ್‍ಹಾಲೊ ಅನಿ ತಿಕಾ, “ತೆನಿ ಖೈ ಹಾತ್? ತ್ಯಾತುರ್‍ಲೆ ಕೊನ್ಬಿ ತುಕಾ ಚುಕಿದಾರ್ ಮನುನ್ ಸಾಂಗುಕ್ ರ್‍ಹಾವ್ಕನಾತ್ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ತನ್ನಾ ತಿನಿ, “ನಾ, ಕೊನ್ಬಿ ನಾ ಸಾಯ್ಬಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲಿನ್, ತನ್ನಾ ಜೆಜುನ್ ತಿಕಾ “ತಸೆಜಾಲ್ಯಾರ್ ಮಿಯಾಬಿ ತುಕಾ ಚುಕಿದಾರ್ ಮನಿನಾ ಜಾ, ಖರೆ ಅನಿ ಫಿಡೆ ಪಾಪ್ ಕರುನಕೊ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ಜೆಜುನ್ ಅನಿ ಪರ್ತುನ್ ಲೊಕಾಂಚ್ಯಾಕ್ಡೆ ಬೊಲುನ್ ಅಶೆ ಮಟ್ಲ್ಯಾನ್ “ಮಿಯಾಚ್ ಜಗಾಚೊ ಉಜ್ವೊಡ್ ಜೊ ಕೊನ್ ಮಾಜಿ ಫಾಟ್ ಧರ್ತಾ ತೊ ಕಾಳ್ಕಾತ್ ಚಲಿನಾ, ಖರೆ ತೆಕಾ ಜಿವಿತಾಚೊ ಉಜ್ವೊಡ್ ಘೆವ್ನ್ ರ್‍ಹಾತಾ”. ");
INSERT INTO kans_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ತನ್ನಾ ಫಾರಿಜೆವಾನಿ ತೆಕಾ, “ತಿಯಾ ತುಜ್ಯಾಚ್ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿ ಖರೆ ತಸ್ಲ್ಯಾ ಸಾಕ್ಷಿಕ್ ಕಿಮ್ಮತ್ ನಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ತನ್ನಾ ಜೆಜುನ್ ಜವಾಬ್ ದಿಲ್ಲ್ಯಾನ್, “ಮಿಯಾ ಮಾಜ್ಯಾಚ್ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ಸಾಂಗ್ಲ್ಯಾರ್ ತೆಕಾ ಕಿಮ್ಮತ್ ಹಾಯ್ , ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಖೈತ್ನಾ ಯೆಲಾ, ಅನಿ ಖೈ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್. ತುಮ್ಕಾ ಮಿಯಾ ಖೈತ್ನಾ ಯೆಲಾ ಅನಿ ಖೈ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಗೊತ್ತ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ತುಮಿ ಮಾನ್ಸಾನಿ ಕರ್‍ಲ್ಯಾ ಸರ್ಕೆ ಇಚಾರ್‍ನಿ ಕರ್‍ತ್ಯಾಶಿ, ಮಿಯಾ ಕೊನಾಚೆಬಿ ಇಚಾರ್‍ನಿ ಕರುಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ಖರೆ ಮಿಯಾ ತಸೆಕರ್ಲ್ಯಾರ್ ಬಿ ಮಾಜೊ ನಿರ್‍ನಯ್ ಖರೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಹ್ಯಾತುರ್ ಮಿಯಾ ಎಕ್ಲೊಚ್ ನಾವ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲೊ ಬಾಬಾಚ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ತುಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ ದೊಗೆ ಜಾನಾ ಎಕುಚ್ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿವ್ನ್ ಸಾಂಗಟ್ಲ್ಯಾರ್ ತೆ ಖರೆಚ್! ಮನುನ್ ಲಿವಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ಮಿಯಾ ಮಾಜ್ಯಾ ಸ್ವತಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿತಾ, ಅನಿ ಮಾಕಾ ಧಾಡಲ್ಲೊ ಮಾಜೊ ಬಾಬಾಬಿ ಮಾಜ್ಯಾ ವಿಶಯಾತುಚ್ ಸಾಕ್ಷಿ ದಿತಾ”. ");
INSERT INTO kans_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ತೆನಿ ತೆಕಾ “ತುಜೊ ಬಾಬಾ ಖೈ ಹಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ಜೆಜುನ್ ತೆಂಕಾ ಜವಾಬ್ ದಿವ್ನ್ “ಮಾಕಾಬಿ ತುಮಿ ವಳ್ಕಿನ್ಯಾಶಿ, ಅನಿ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ ಬಿ ತುಮಿ ವಳ್ಕಿನ್ಯಾಶಿ, ಮಾಕಾ ತುಮಿ ವಳಕ್ಲ್ಯಾರ್ ಮಾಜ್ಯಾ ಬಾಬಾಕ್‍ಬಿ ತುಮಿ ವಳ್ಕಿ ಹೊತ್ತ್ಯಾಶಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ಜೆಜು ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಹಿ ಸಗ್ಳಿ ಗೊಸ್ಟಿಯಾ ಶಿಕ್ವುತಾನಾ ಕಾನಿಕಾಚೆ ಡಬ್ಬೆ ಥವಲ್ಲ್ಯಾ ಖೊಲಿತ್ ಹೊತ್ತೊ ಖರೆ ಕೊನ್ ಬಿ ತೆಕಾ ಧರುಕ್ ನಾತ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಚೊ ಎಳ್ ಅಜುನ್ ಯೆವ್ನಸಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ಜೆಜು ತೆಂಕಾ ಅನಿ ಪರ್ತುನ್, “ಮಿಯಾ ಭಾಯ್ರ್ ಪಡುನ್ ಜಾತಾ ಖರೆ ತುಮಿ ಮಾಕಾ ಹುಡಕ್ತ್ಯಾಶಿ. ಖರೆ ತುಮ್ಚ್ಯಾ ಪಾಪಾತುಚ್ ತುಮಿ ಮರ್‍ತ್ಯಾಶಿ. ಮಿಯಾ ಜಾತಾ ಥೈ ತುಮ್ಚ್ಯಾನ್ ಜಾವ್ಕ್ ಹೊಯ್ನಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ತೆಚೆಸಾಟ್ನಿ ಜುದೆವಾಂಚ್ಯಾ “ಹ್ಯೊ, ತೊ ಜಾತಾ ಥೈ ಅಮ್ಚ್ಯಾನ್ ಜಾವ್ಕ್ ಹೊಯ್ನಾ ಮನುನ್ ಮನುಲಾ, ಅಶೆ ಮಟ್ಲ್ಯಾರ್ ಹ್ಯೊ ಅಪ್ನಾಚೊಚ್ ಜಿವ್ ಕಾಡುನ್ ಘೆಟ್ನಾರ್ ಹಾಯ್ ಕಿ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ತನ್ನಾ ಜೆಜುನ್, “ತುಮಿ ಹ್ಯಾ ಜಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲಿ ಲೊಕಾ, ಖರೆ ಮಿಯಾ ವೈಲೊ ತುಮಿ ಖಾಯ್ಲೆ. ತುಮಿ ಹ್ಯಾ ಜಗಾತ್ಲೆ, ಖರೆ ಮಿಯಾ ಹ್ಯಾ ಜಗಾತ್ಲೊ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ತೆಚೆಸಾಟ್ನಿ ತುಮಿ ತುಮ್ಚ್ಯಾ ಪಾಪಾತುಚ್ ಮರ್‍ತ್ಯಾಶಿ ಮನುನ್ ಮಿಯಾ ಸಾಂಗಟ್ಲೊ. ಅನಿ ಮಿಯಾ ಕೊನ್ ಕಾಯ್ ಮನುನ್ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರುನಸ್ಲ್ಯಾರ್ ತುಮಿ ತುಮ್ಚ್ಯಾ ಪಾಪಾತ್ನಿಚ್ ಮರ್‍ತ್ಯಾಶಿ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ತೆನಿ ತೆಕಾ, “ಅದ್ದಿಸ್ನಾ ತುಮ್ಕಾ ಕಾಯ್ ಸಾಂಗಿತ್ ತೊ ಮಿಯಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ಜೆಜುನ್ ತೆಂಕಾ, “ಮಿಯಾ ತುಮ್ಚೆಕ್ಡೆ ಕಶ್ಯಾಕ್ ಬೊಲುಚೆ? ");
INSERT INTO kans_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ತುಮ್ಚ್ಯಾ ವಿಶಯಾತ್ ಮಿಯಾ ಸಾಂಗ್ತಲೆ, ಅನಿ ತುಮ್ಕಾ ಚುಕಿದಾರ್ ಕರ್‍ತಲೆ ಲೈ ಹಾಯ್. ಜೊ ಕೊನ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್ ತೊ ಖರೆಪಾನಾಚೊ ಮಾನುಸ್, ಅನಿ ಜೆ ಕಾಯ್ ಮಿಯಾ ತೆಚೆಕ್ನಾ ಆಯಿಕ್ಲಾ ತೆಚ್ ಮಿಯಾ ಹ್ಯಾ ಜಗಾಕ್ ಸಾಂಗ್ತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ತೊ ಅಪ್ಲ್ಯಾ ಬಾಬಾಚ್ಯಾ ವಿಶಯಾತುಚ್ ಬೊಲುಲಾ ಮನ್ತಲೆ ತೆಂಕಾ ಕಳುಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ತಸೆಮನುನ್ ಜೆಜುನ್ ತೆಂಕಾ, “ತುಮಿ ಮಾನ್ಸಾಚ್ಯಾಲೆಕಾಕ್ ವೈರ್ ಉಕಲಲ್ಲ್ಯಾ ತನ್ನಾ, ಮಿಯಾ ಕೊನ್ ಮನುನ್ ತುಮ್ಕಾ ಕಳ್ತಾ. ಖರೆ ಮಿಯಾ ಕರ್‍ತಲೆ ಮಾಜ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಕಾಯ್ ಬಿ ಕರಿನಾ ಹೊಲಾ ಮನುನ್ ತುಮ್ಕಾ ಕಳ್ತಾ. ಮಿಯಾ ಖಾಲಿ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ಸಾಂಗುನ್ ಧಾಡಲ್ಲ್ಯಾ ಸರ್ಕೆ ಸಾಂಗುಲಾಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ಅನಿ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲೊ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಯ್, ತೆನಿ ಮಾಕಾ ಎಕ್ಲ್ಯಾಕುಚ್ ಸೊಡುನ್ ದಿವ್ಕನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಕನ್ನಾಬಿ ತೆಕಾ ಒಪ್ಪ್ ಹೊಲ್ಲೆಚ್ ಕರ್‍ತಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ಜೆಜುನ್ ಹೆ ಸಾಂಗ್ತಲೆ ಅಯ್ಕಲ್ಲ್ಯಾ ಸುಮಾರ್ ಲೊಕಾನಿ ತೆಚಾವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ತನ್ನಾ ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಲ್ಯಾ ಜುದೆವಾಕ್ನಿ, “ತುಮಿ ಮಿಯಾ ಶಿಕ್ವುತಲ್ಯಾಕ್ ಖಾಲ್ತಿ ಹೊಲ್ಯಾರ್ ತುಮಿ ಖರೆಚ್! ಮಾಜಿ ಶಿಸಾ, ");
INSERT INTO kans_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ತುಮ್ಕಾ, ಖರೆ ಕಾಯ್ ಮನುನ್ ಗೊತ್ತ್ ಹೊತಾ, ಅನಿ ತೆಚ್ ಖರೆ ತುಮ್ಕಾ ಸ್ವತಂತ್ರ್ ಕರ್‍ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ತನ್ನಾ ತೆನಿ ಅಮಿ ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ಘರಾನ್ಯಾಚೆ ಅನಿ ಅಮಿ ಕನ್ನಾಚ್ ಕೊನಾಚೆ ಗುಲಾಮ್ ಹೊವ್ಕನಾವ್. ತುಮಿ ಸ್ವತಂತ್ರ್ ಹೊತ್ಯಾಶಿ ಮನುನ್ ತಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಚೊ ಅರ್ತ್ ಕಾಯ್? ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ಜೆಜುನ್ ತೆಂಕಾ, “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ; ಜೊ ಕೊನ್ ಪಾಪ್ ಕರ್‍ತಾ, ತೊ ಪಾಪಾಚೊ ಗುಲಾಮ್”. ");
INSERT INTO kans_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ಗುಲಾಮ್ ಎಕ್ ಕುಟ್ಮಾಚೊ ಖಾಯ್ಮಿಚೊ ಮಾನುಸ್ ನ್ಹಯ್, ಖರೆ ಎಕ್ ಲೆಕ್ ಕನ್ನಾಬಿ ಕುಟ್ಮಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೊ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ಲೆಕಾನ್ ತುಮ್ಕಾ ಸ್ವತಂತ್ರ್ ಕರ್ಲ್ಯಾನ್ ತರ್, ತುಮಿ ಖರೆಚ್! ಸ್ವತಂತ್ರ್ ಹೊತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ತುಮಿ ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ಘರಾನ್ಯಾಚೆ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್. ಅಜುನ್ ಬಿ ತುಮಿ ಮಾಕಾ ಜಿವಾನಿ ಮಾರುಕ್ ಮನುನ್ ಬಗುಲ್ಯಾಶಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತುಮಿ ಮಿಯಾ ಶಿಕ್ವಲ್ಲೆ ಮಾನುನ್ ಘೆಯ್ನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ಜೆ ಕಾಯ್ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ದಾಕ್ವುಲ್ಯಾನಾಯ್ ತೆಚ್ಯಾ ವಿಶಯಾತ್ ಮಿಯಾ ಬೊಲುಲಾ, ಖರೆ ತುಮಿ ತುಮ್ಚ್ಯಾ ಬಾಬಾನ್ ತುಮ್ಕಾ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ತೆನಿ ತೆಕಾ, “ಅಬ್ರಾಹಾಮ್ ಅಮ್ಚೊ ಬಾಬಾ”, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ಜೆಜುನ್ ತೆಂಕಾ, “ಖರೆಚ್! ತುಮಿ ಅಬ್ರಾಹಾಮಾಚಿ ಪೊರಾ ಹೊಲ್ಯಾರ್, ಅಬ್ರಾಮಾನ್ ಕರಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ತುಮಿಬಿ ಕರಿ ಹೊತ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ಖರೆ ದೆವಾಕ್ನಾ ಆಯ್ಕಲ್ಲೆ ಖರೆ ತುಮ್ಕಾ ಸಾಂಗುಸಾಟ್ನಿ ಮಿಯಾ ಹೆ ಸಗ್ಳೆ ಕರ್‍ಲೊ, ತರ್ ಬಿ ತುಮಿ ಮಾಕಾ ಜಿವಾನಿ ಮಾರುಕ್ ಬಗುಲ್ಯಾಶಿ. ಅಬ್ರಾಹಾಮ್ ಅಸೊ ನತ್ತೊ! ");
INSERT INTO kans_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ತುಮಿ ತುಮ್ಚ್ಯಾ ಬಾಬಾನ್ ಕರಲ್ಲ್ಯಾ ಸರ್ಕೆಚ್ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ ಸಾಂಗಲ್ಲ್ಯಾನ್ ಅಮಿ ವೆಭಿಚಾರಾಕ್ ಜಲ್ಮುಕ್ನಾಂವ್ , “ದೆವ್ ಎಕ್ಲೊಚ್ ಅಮ್ಚೊ ಬಾಬಾ ಹೊವ್ನ್ ಹಾಯ್ ಅನಿ ಅಮಿ ತೆಚಿ ಖರಿ ಪೊರಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ಜೆಜುನ್ ತೆಂಕಾ, “ಖರೆಚ್! ದೆವ್ ತುಮ್ಚೊ ಬಾಬಾ ಹೊಲ್ಯಾರ್ ತುಮಿ ಮಾಜೊ ಪ್ರೆಮ್ ಕರಿ ಹೊತ್ತ್ಯಾಶಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ದೆವಾತ್ನಾಚ್ ಯೆಲಾ ಅನಿ ಅತ್ತಾ ಹಿತ್ತೆ ಹಾಂವ್. ಮಿಯಾ ಮಾಜ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಯೆವ್ಕ್ ನಾ, ತೆನಿಚ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ಮಿಯಾ ಕಾಯ್ ಸಾಂಗ್ತಾ ತೆ ತುಮ್ಕಾ ಕಶ್ಯಾಕ್ ಕಳಿನಾ? ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತುಮ್ಕಾ ಮಿಯಾ ಸಾಂಗ್ತಲಿ ಖಬರ್ ಆಯ್ಕುನ್ ಸೊಸುನ್ ಘೆವ್ಕ್ ಹೊಯ್ನಾ ಹೊಲಾ ಕಾಯ್ಕಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ತುಮಿ ತುಮ್ಚ್ಯಾ ಬಾಬಾ ಗಿರೊ ಪೊರಾ, ತುಮಿ ತುಮ್ಚ್ಯಾ ಬಾಬಾಕ್ ಕಶೆ ಪಾಜೆ ತಶೆಚ್ ಚಲ್ತ್ಯಾಶಿ. ಪಯ್ಲೆಚ್ಯಾನುಚ್ ತೊ ಎಕ್ ಜಿವಾನಿ ಮಾರ್‍ತಲೊ, ಅನಿ ತೊ ಕನ್ನಾಚ್ ಖರೆ ಹಾಯ್ ಥೈ ಯೆಯ್ನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತ್ಯೆಚ್ಯಾ ಭುತ್ತುರ್ ಖರೆ ಮನ್ತಲೆಚ್ ನಾ. ತೊ ಝುಟೆ ಬೊಲ್ತಾನಾ, ಅಪ್ನಾಕ್ ಬರೆ ದಿಸ್ತಾ ತಶೆ ತೊ ಬೊಲ್ತಾ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಎಕ್ ಝುಟೊ ಅನಿ ಝುಟೆ ಬೊಲ್ತಲ್ಯಾಂಚೊ ಬಾಬಾ. ");
INSERT INTO kans_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ಖರೆ ಮಿಯಾ ಖರೆ ಬೊಲುಲಾ ತೆಚೆಸಾಟ್ನಿ ತುಮಿ ಮಾಜೆರ್ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ತುಮ್ಚ್ಯಾತ್ಲೊ ಕೊನ್ ತೊ ಮಾಜ್ಯಾ ಭುತ್ತುರ್ ಪಾಪ್ ದಾಕ್ವುನ್ ದಿತಲೊ? ಮಿಯಾ ಖರೆಚ್! ಸಾಂಗ್ಲೊ ತರ್ ತುಮಿ ಕಶ್ಯಾಕ್ ಮಾಜೆರ್ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾಶಿ? ");
INSERT INTO kans_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ಜೆ ಕೊನ್ ದೆವಾಕ್ನಾ ಯೆತಾ ತೊ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ತಾ. ತುಮಿ ದೆವಾಕ್‍ ಸಮಂದ್ ಪಡಲ್ಲೆ ನ್ಹಯ್, ತಸೆಮನುನ್ ತುಮಿ ಮಾಜಿ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕಿನ್ಯಾಶಿ”. ");
INSERT INTO kans_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ಜುದೆವಾನಿ ಜೆಜುಕ್ ಸಾಂಗಲ್ಲ್ಯಾನಿ, “ತಿಯಾ ಸಮಾರಿಯಾಚೊ ಮಾನುಸ್ ಹೊಯ್ ಕಾಯ್ ನ್ಹಯ್?” ಅನಿ ತುಕಾ ಗಿರೊ ಲಾಗ್ಲಾ ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ತನ್ನಾ ಜೆಜುನ್ “ಮಾಕಾ ಗಿರೊ ಲಾಗುಕ್ ನಾ” ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ ಮಾನ್ ದಿತಾ ಖರೆ ತುಮಿ ಮಾಕಾ ಮಾನ್ ದಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ಮಿಯಾ ಮಾಕಾಚ್ ಮಾನ್ ಮರ್‍ಯಾದ್ ಗಾವುಕ್ ಪಾಜೆ ಮನುನ್ ಬಗಿನಾ ಹೊಲಾ. ಖರೆ ಜೊ ಕೊನ್ ಎಕ್ಲೊ ಹಾಯ್ ತೊ ಮಾಜ್ಯಾ ತರ್ಪೆನ್ ನ್ಯಾಯ್ ದಿತಲೊ ತೊ ತೆ ಹುಡ್ಕುಲಾಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ ಜೊ ಕೊನ್ ಮಾಜ್ಯಾ ಶಿಕ್ವುತಲ್ಯಾಕ್ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಚಲ್ತಾತ್ ತೊ ಕನ್ನಾಚ್ ಮರಿನಾ. ");
INSERT INTO kans_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ಜುದೆವಾನಿ ತೆಕಾ ಖರೆ ಸಾಂಗಲ್ಲ್ಯಾನಿ , “ಅತ್ತಾ ತುಕಾ ಗಿರೊ ಲಾಗಲ್ಲೆ ಖರೆಚ್!” ಮನುನ್ ಅಮ್ಕಾ ಖಾತ್ರಿ ಹೊಲಿ! ಅಬ್ರಾಹಾಮ್ ಮರ್‍ಲೊ, ಪ್ರವಾದಿಬಿ ಮರುನ್ ಗೆಲೆ, ಖರೆ ತಿಯಾ ಮನ್ತೆಯ್ ಜೊ ಕೊನ್ ಮಾಜೆ ಶಿಕ್ವುತಲ್ಯಾನಿ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಚಲ್ತಾತ್ ತೆನಿ ಕನ್ನಾಚ್ ಮರಿನ್ಯಾತ್ ಮನುನ್ ಮನ್ತೆಯ್. ");
INSERT INTO kans_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","“ಅಮ್ಚೊ ಬಾಬಾ ಅಬ್ರಾಹಾಮ್ ಮರುನ್ ಗೆಲೊ, ತಿಯಾ ಕಾಯ್ ಅಬ್ರಾಮಾಚ್ಯಾನ್ಕಿ ಮೊಟೊ ಕಾಯ್? ಅನಿ ಪ್ರವಾದಿಬಿ ಮರುನ್ ಗೆಲೆ. ತಿಯಾ ಕೊನ್ ಮನುನ್ ಚಿಂತುಲೆ ತಿಯಾ?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ಮಾಕಾಚ್ ಮರ್‍ಯಾದ್ ಗಾವುಚಿ ಮನುನ್ ಬಗುಲಾ ಹೊಲ್ಯಾರ್, ತ್ಯಾ ಮರ್‍ಯಾದಿಕ್ ಕಾಯ್ಬಿ ಕಿಮ್ಮತ್ ನಾ. ಮಾಜೊ ಬಾಬಾಚ್ ಮಾಕಾ ಮರ್‍ಯಾದ್ ಗಾವಿ ಸರ್ಕೆ ಕರ್‍ತಾ ತೆಕಾ ತುಮಿ ತುಮ್ಚೊ ದೆವ್ ಮನುನ್ ಮನ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ತುಮಿ ತೆಕಾ ಕನ್ನಾಬಿ ವಳ್ಕಿನ್ಯಾಶಿ ಖರೆ ಮಿಯಾ ತೆಕಾ ವಳಕ್ತಾ, ಅನಿ ಮಿಯಾ ತೆಕಾ ವಳ್ಕಿನಾ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾರ್ ಮಿಯಾಬಿ ತುಮ್ಚ್ಯಾ ಸರ್ಕೊಚ್ ಝುಟೊ ಹೊತಾ. ಖರೆ ಮಿಯಾ ತೆಕಾ ವಳಕ್ತಾ ಅನಿ ತೆಚ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಚಲ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ಮಿಯಾ ಯೆತಲೊ ಎಳ್ ಬಗುಕ್ ಮನುನ್ ತುಮ್ಚ್ಯಾ ಬಾಬಾ ಅಬ್ರಾಹಾಮಾಕ್ ಲೈ ಮನ್ ಹೊತ್ತೊ ತೆನಿ ತೊ ಎಳ್ ಬಗಟ್ಲ್ಯಾನ್ ಅನಿ ತೆಕಾ ಲೈ ಖುಶಿ ಹೊಲಿ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ತವ್ಡ್ಯಾಕ್ ಮಟ್ಲ್ಯಾ ಜುದೆವಾನಿ, ತುಕಾ ಪನ್ನಾಸ್ ವರ್ಸಾ ಸೈತ್ ಹೊವ್ಕನಾತ್ ಅನಿ ತಿಯಾ ಅಬ್ರಾಹಾಮಾಕ್ ಬಗಟ್ಲೆ ಕಾಯ್?\" ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ಅಬ್ರಾಹಾಮ್ ಉಪ್ಜುಚ್ಯಾ ಪಯ್ಲೆಚ್ಯಾನುಚ್ ಮಿಯಾ ಹಾಂವ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ತನ್ನಾ ತೆನಿ ಜೆಜುಕ್ ಮಾರುಕ್ ಮನುನ್ ಗುಂಡೆ ಎಚುನ್ ಘೆಟ್ಲ್ಯಾನಿ , ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ ಚುಕ್ವುನ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ನಾ ಭಾಯ್ರ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ಜೆಜು ಅಪ್ಲಿ ವಾಟ್ ಧರುನ್ ಜಾತಾನಾ ಉಪಾಜ್ತಾನಾಚ್ ಕುಡ್ಡೊ ಹೊತ್ತ್ಯಾ ಎಕ್ ಮಾನ್ಸಾಕ್ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ತ್ಯೆಚ್ಯಾ ಶಿಸಾನಿ ತೆಕಾ, “ಗುರುಜಿ, ಹ್ಯೊ ಮಾನುಸ್ ಕೊನಾಚ್ಯಾ ಪಾಪಾಕ್ ಲಾಗುನ್ ಕುಡ್ಡೊ ಹೊವ್ನ್ ಉಪಾಜ್ಲಾ? ತ್ಯೆಚ್ಯಾಚ್‍ ಪಾಪಾಕ್ನಿ ಲಾಗುನ್ ಕಾಯ್? ತ್ಯೆಚ್ಯಾ ಬಾಯ್ ಬಾಬಾಚ್ಯಾ ಪಾಪಾಕ್ನಿ ಲಾಗುನ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ತನ್ನಾ ಜೆಜುನ್, “ತೊ ತೆಚ್ಯಾ ಪಾಪಾಕ್ನಿ ಲಾಗುನ್ ಹೊಂವ್ದಿ, ತೆಚ್ಯಾ ಬಾಯ್ - ಬಾಬಾಚ್ಯಾ ಪಾಪಾಕ್ನಿ ಹೊಂವ್ದಿ ಕುಡ್ಡೊ ಹೊವ್ನ್ ಉಪ್ಜುಕ್ನಾ, ದೆವಾಚೊ ಬಳ್ ಕಾಮಾಚ್ಯಾ ರುಪಾತ್ ದಾಕ್ವುನ್ ದಿವ್‍ಸಾಟ್ನಿ ಮನುನ್ ತೊ ಕುಡ್ಡೊ ಹೊವ್ನ್ ಉಪಜ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ದಿಸ್ ಬುಡಿ ಪತರ್ ಮಾಕಾ ಧಾಡಲ್ಲ್ಯಾನ್ ಕರುಕ್ ಸಾಂಗಲ್ಲಿ ಕಾಮಾ ಅಮಿ ಕರುಕ್ ಪಾಜೆ ರಾತ್ ಹೊವ್ಕ್ ಯೆಲಿ ರಾತ್ ಹೊಲಿ ತರ್ ಕೊನ್ಬಿ ಕಾಮ್ ಕರಿನಾತ್”. ");
INSERT INTO kans_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","“ಮಿಯಾ ಹ್ಯಾ ಜಗಾತ್ ಅಸಿ ಪತರ್, ಮಿಯಾ ಜಗಾಚೊ ಉಜ್ವೊಡ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ಹೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜುನ್ ಜಿಮ್ನಿ ವರ್ತಿ ಥುಕ್ಲ್ಯಾನ್, ಅನಿ ಉಲ್ಲಿ ಮಾಟಿ ಕಾಲ್ವುನ್ ಚಿಕ್ಕೊಲ್ ಕರ್ಲ್ಯಾನ್. ಅನಿ ತೊ ಚಿಕ್ಕೊಲ್ ತ್ಯಾ ಕುಡ್ಡ್ಯಾಚ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ಪುಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ಅನಿ ಜಾವ್ನ್ ಸಿಲೊಆಮ್ ತಳ್ಯಾತ್ ಧುವ್ನ್ ಘೆ ಮಟ್ಲ್ಯಾನ್ ಸಿಲೊಆಮ್ ಮಟ್ಲ್ಯಾರ್ ಧಾಡಲ್ಲೊ ಮನುನ್ ಅರ್ತ್ ತನ್ನಾ ತೊ ಮಾನುಸ್ ಗೆಲೊ ಅನಿ ಅಪ್ನಾಚೆ ತೊಂಡ್ ಧುವ್ನ್ ಘೆವ್ನ್ ಯೆಲೊ. ತನ್ನಾ ತೆಕಾ ದಿಸುಕ್‍ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ತೆಚ್ಯಾ ಅಜು ಬಾಜುಚ್ಯಾನಿ ಅನಿ ತೊ ಅದ್ದಿ ಭಿಕ್ ಮಾಗುನ್ಗೆತ್ ಬಸಲ್ಲೆ ಬಗಲ್ಲ್ಯಾ ಲೊಕಾನಿ, “ಹ್ಯೊ ಹಿತ್ತೆ ಸದ್ದಿ ಭಿಕ್ ಮಾಗುಕ್ ಬಸ್ತಲೊ ಮಾನುಸ್ ನ್ಹಯ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ತನ್ನಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ “ಹ್ಯೊಚ್ ತೊ” ಮಟ್ಲ್ಯಾನಿ ಖರೆ ಅನಿ ಉಲ್ಲ್ಯಾನಿ, “ಹ್ಯೊ ನ್ಹಯ್ ತೊ, ಹ್ಯೊಬಿ ತೆಚ್ಯಾ ಸರ್ಕೊಚ್ ದಿಸ್ತಾ” ಮಟ್ಲ್ಯಾನಿ. ಖರೆ ತ್ಯಾ ಮಾನ್ಸಾನುಚ್ “ಮಿಯಾಚ್ ತೊ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ತೆನಿ ತೆಕಾ “ಕಶೆ ಕರುನ್ ತುಕಾ ಅತ್ತಾ ದಿಸುಲಾಲಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ತನ್ನಾ ತೆನಿ, “ಜೆಜು ಮನ್ತಲ್ಯಾ ಎಕ್ ಮಾನ್ಸಾನ್, ಉಲ್ಲೊ ಚಿಕ್ಕೊಲ್ ಮಾಜ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ಲಾವ್ಲ್ಯಾನ್, ಅನಿ ಸಿಲೊಆಮ್ ತಳ್ಯಾತ್ ಜಾವ್ನ್ ಧುವ್ನ್ ಘೆ ಮಟ್ಲ್ಯಾನ್, ಮಿಯಾ ಗೆಲೊ ಅನಿ ಧುವ್ನ್ ಘೆಟ್ಲೊ, ತನ್ನಾ ಮಾಕಾ ದಿಸುಲಾಲೆ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ತನ್ನಾ ತ್ಯಾ ಲೊಕಾನಿ, ತೊ ಖೈ ಹಾಯ್ ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತನ್ನಾ ತೆನಿ “ಮಾಕಾ ಗೊತ್ತ್ ನಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ಮಾನಾ ತೆನಿ ತ್ಯಾ ಬರೊ ಹೊಲ್ಲ್ಯಾ ಕುಡ್ಡ್ಯಾ ಮಾನ್ಸಾಕ್ ಫಾರಿಜೆವಾನಿಕ್ಡೆ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ಜೆಜುನ್ ಚಿಕ್ಕೊಲ್ ಲಾವುನ್ ತೆಕಾ ದಿಸ್ಟ್ ದಿಸಿ ಸರ್ಕೆ ಕರಲ್ಲೊ ದಿಸ್ ಸಬ್ಬಾತಾಚೊ ದಿಸ್ ಹೊಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ತನ್ನಾ ಫಾರಿಜೆವಾನಿ ಅನಿ ಎಗ್ದಾ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತ್ಯಾ ಬರೊ ಹೊಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್, \"ತುಕಾ ತುಜಿ ದಿಸ್ಟ್ ಕಶೆ ಕರುನ್ ಗಾವ್ಲಿ.\" ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತೆನಿ ತೆಂಕಾ\" ತೆನಿ ಮಾಜ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ಚಿಕ್ಕೊಲ್ ಲಾವ್ಲ್ಯಾನ್ ಮಾನಾ ಮಿಯಾ ಮಾಜೆ ತೊಂಡ್ ಧುವ್ನ್ ಘೆಟ್ಲೊ ಅತ್ತಾ ಮಾಕಾ ದಿಸ್ಟ್ ದಿಸುಲಾಲಾ.\" ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ತನ್ನಾ ಉಲ್ಲಿ ಫಾರಿಜೆವಾನಿ \" ಹೆ ಕರಲ್ಲೊ ಮಾನುಸ್ ದೆವಾಕ್ ನಾ ಯೆಲ್ಲೊ ನ್ಹಯ್,\" ತೊ ಸಬ್ಬಾತಾಚೊ ಖಾಯ್ದೊಚ್ ಪಾಳಿನಾ, ಮಟ್ಲ್ಯಾನಿ. ಖರೆ ಅನಿ ಉಲ್ಲ್ಯಾನಿ \" ಎಕ್ ಪಾಪಿ ಮಾನ್ಸಾನ್ ಎವ್ಡೆ ಮೊಟೆ ಅಜಾಪ್ ಕಶೆ ಕರುಕ್ ಹೊತಾ?\" ಮಟ್ಲ್ಯಾನಿ, ಅಶೆ ತೆಂಚ್ಯಾ- ತೆಂಚ್ಯಾ ಮದ್ದಿಚ್ ವಾದ್‍ವಿವಾದ್ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ತಸೆ ಮನುನ್ ಫಾರಿಜೆವಾನಿ ಅನಿ ಎಗ್ದಾ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಇಚಾರ್‍ಲ್ಯಾನಿ, “ತೆನಿ ತುಕಾ ಡೊಳ್ಯಾಕ್ ದಿಸ್ಟ್ ದಿಲ್ಲ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ವಿಶಯಾತ್ ಕಾಯ್ ಮನ್ತೆಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾನ್ “ತೊ ಎಕ್ ಪ್ರವಾದಿ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ತೊ ಕುಡ್ಡೊ ಹೊತ್ತೊ, ಅತ್ತಾ ತೆಕಾ ದಿಸುಲಾಲಾ ಮನುನ್ ಅಜುನ್ಬಿ ಜುದೆವಾಂಚ್ಯಾ ಫುಡಾರ್‍ಯಾಕ್ನಿ ವಿಶ್ವಾಸ್‍ ನತ್ತೊ, ತಸೆಮನುನ್ ತೆನಿ ತ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಬಾಯ್-ಬಾಬಾಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ");
INSERT INTO kans_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ಅನಿ “ಹ್ಯೊ ತುಮ್ಚೊಚ್ ಲೆಕ್ ಕಾಯ್? ಹ್ಯೊ ಉಪಾಜಲ್ಲ್ಯಾಕ್ನಾಚ್ ಕುಡ್ಡೊ ಮನುನ್ ತುಮಿ ಮನುಲ್ಯಾಶಿ, ತಸೆ ಹೊಲ್ಯಾರ್ ತೆಕಾ ಅತ್ತಾ ಸಗ್ಳೆ ದಿಸುಲಾಲಾ ತೆ ಕಶೆ ಹೊಲೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ತನ್ನಾ ತ್ಯೆಚ್ಯಾ ಬಾಯ್-ಬಾಬಾನಿ, “ತೊ ಅಮ್ಚೊಚ್ ಲೆಕ್ ಅನಿ ತೊ ಉಪಾಜ್ತಾನಾಚ್ ಕುಡ್ಡೊ ಹೊವ್ನ್ ಉಪಜಲ್ಲೊ ತೆ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ಖರೆ ತೆಕಾ ಅತ್ತಾ ಕಶೆ ಕರುನ್ ದಿಸುಲಾಲಾ, ಅನಿ ತೆಚೆ ಕುಡ್ಡೆ ಹೊತ್ತೆ ತೆ ಡೊಳ್ ಕೊನ್ ಬರೆ ಕರ್ಲ್ಯಾನಿ ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ನಾ, ತೊ ಕಾಯ್ ಬಾರಿಕ್ಲೊ ಪೊರ್ ನ್ಹಯ್, ಕಶೆ ಕಾಯ್ ಹೊಲೆ ಮನುನ್ ತೊಚ್ ಸಾಂಗ್ತಾ ತೆಕಾ ಇಚಾರಾ” ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ಜುದೆವಾಂಚ್ಯಾ ಫುಡಾರ್‍ಯಾಂಚ್ಯಾ ಭಿಂಯಾನ್ ತೆನಿ ಅದ್ದಿಚ್ ನಿರ್‍ದಾರ್ ಕರಲ್ಲ್ಯಾನಿ. ತ್ಯೆಚ್ಯಾ ಬಾಯ್ -ಬಾಬಾನಿ ಅಶೆ ಮಟ್ಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಜೆ ಕೊನ್ ಜೆಜುಕ್ ಮೆಸ್ಸಿಯಾ ಮನ್ತಾ ತೆಕಾ ಸಿನಾಗೊಗಾತ್ನಾ ಭಾಯ್ರ್ ಘಾಲ್ತಲೆ ಮನುನ್ ");
INSERT INTO kans_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ತಸೆಮನುನ್ ತ್ಯೆಚ್ಯಾ ಬಾಯ್-ಬಾಬಾನಿ, ತೊ ಬಾರಿಕ್ ಪೊರ್ ನ್ಹಯ್, ತೆಕಾಚ್ ಇಚಾರಾ! ಮನುನ್ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ಅನಿ ಎಗ್ದಾ ದೊನ್ವೆಪಟಿ ತ್ಯಾ ಉಪಾಜಲ್ಲ್ಯಾಕ್ನಾ ಕುಡ್ಡೊ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಪಾರಿಜೆವಾನಿ ಬಲ್ವುಲ್ಯಾನಿ, “ಅನಿ ದೆವಾಚ್ಯಾ ನಾವಾನ್ ಮಹಿಮಾ ಘಾಲುನ್ ಅಮ್ಕಾ ಖರೆಚ್! ಸಾಂಗ್!. ತುಕಾ ಬರೆ ಕರಲ್ಲೊ ಮಾನುಸ್ ಪಾಪಿ ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್”. ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾನ್, “ತೊ ಎಕ್ಲೊ ಪಾಪಿ ಹೊಯ್ ಕಾಯ್ ನ್ಹಯ್, ತೆ ಸಗ್ಳೆ ಮಾಕಾ ಗೊತ್ತ್ ನಾ, ಮಿಯಾ ಕುಡ್ಡೊ ಹೊತ್ತೊ, ಅತ್ತಾ ಮಾಕಾ ದಿಸುಕ್ ಲಾಗ್ಲಾ ತವ್ಡೆಚ್ ಮಾಕಾ ಗೊತ್ತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ತನ್ನಾ ಫಾರಿಜೆವಾನಿ “ತೆನಿ ಕಾಯ್ ಕರ್ಲ್ಯಾನ್, ಕುಡ್ಡೊ ಹೊತ್ತ್ಯಾ ತುಕಾ ತೆನಿ ಕಶೆ ಕರುನ್ ಬರೆ ಕರ್ಲ್ಯಾನ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾನ್ “ಮಿಯಾ ತುಮ್ಕಾ ಸಗ್ಳೆ ಸಾಂಗ್ಲಾ, ತುಮಿ ಆಯ್ಕುಕ್‍ನ್ಯಾಸಿ ಕಾಯ್? ಅನಿ ಪರ್ತುನ್ ಕಶ್ಯಾಕ್ ಅಯ್ಕುಕ್ ಪಾಜೆ ತುಮ್ಕಾ? ತುಮ್ಕಾಬಿ ತೆಚಿ ಶಿಸಾ ಹೊತಲೊ ಮನ್ ಹಾಯ್ ಕಾಯ್?” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ತನ್ನಾ ತೆನಿ ತೆಕಾ ಅವ್ಮಾನ್ ಕರುನ್, “ತಿಯಾಚ್ ತೊ, ತೆಚೊ ಶಿಸ್, ಅಮಿ ಮೊಯ್ಜೆಚ್ಯಾ ವಾಟೆನ್ ಚಲ್ತಲೆ ಲೊಕಾ. ");
INSERT INTO kans_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ದೆವಾನ್ ಮೊಯ್ಜೆಕ್ಡೆ ಬೊಲ್ಲ್ಯಾನ್, ತೆ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಖರೆ ಹ್ಯೊ ಖೈತ್ನಾ ಯೆಲಾ ಅನಿ ಕೊನ್ ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ನಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾನ್, “ವಿಚಿತ್ರ್ ವಿಶಯ್ ಹೆ ತ್ಯಾ ಮಾನ್ಸಾನ್ ಮಾಜೆ ಡೊಳೆ ದಿಸಿ ಸರ್ಕೆ ಕರ್ಲ್ಯಾನ್, ಅನಿ ತೊ ಕೊನ್ ಮನುನ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ಪಾಪಿ ಲೊಕಾಂಚೆ ದೆವ್ ಆಯ್ಕಿನಾ, ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಜೆ ಕೊನ್ ತೆಕಾ ಮಾನ್ ದಿತಾ ತೆಂಚೆ ದೆವ್ ಆಯಿಕ್ತಾ, ಅನಿ ತೆಂಕಾ ಪಾಜೆ ಹೊಲ್ಲೆ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ಜಗ್ ರಚಲ್ಲ್ಯಾಕ್ನಾ ಅಜುನ್ ಪತರ್ ಕೊನ್ಬಿ ಎಕ್ ಕುಡ್ಡ್ಯಾಕ್ ದಿಸ್ಟ್ ದಿಲ್ಯಾನ್ ಮನುನ್ ಅಮಿ ಆಯ್ಕಲ್ಲೆ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ಹ್ಯೊ ಮಾನುಸ್ ದೆವಾಕ್ನಾ ಯೆಲ್ಲೊ ನ್ಹಯ್ ಹೊಲ್ಯಾರ್, ತೆಚ್ಯಾನ್ ಹೆ ಸಗ್ಳೆ ಕರುಕ್ ಹೊಯ್ನಶಿ ಹೊತ್ತೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ತನ್ನಾ ತೆನಿ, “ತಿಯಾ ಪಾಪಾತ್ ಉಪ್ಜುನ್, ಪಾಪಾತುಚ್ ಮೊಟೊ ಹೊಲ್ಲೊ, ಅಮ್ಕಾಚ್ ಶಿಕ್ವುಕ್ ಯೆತೆಯ್?” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ, ಅನಿ ತೆಕಾ ಸಿನಾಗೊಗಾತ್ನಾ ಭಾಯ್ರ್ ಘಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ಹಿತ್ತೆ ಕಾಯ್-ಕಾಯ್ ಹೊಲೆ ಮನ್ತಲಿ ಖಬರ್ ಜೆಜುಕ್ ಗಾವ್ಲಿ, ಮಾನಾ ತೊ ಮಾನುಸ್ ಜೆಜುಕ್ ಭೆಟ್ಲೊ, ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ,“ಮಾನ್ಸಾಚ್ಯಾಲೆಕಾ ವರ್ತಿ ತಿಯಾ ವಿಶ್ವಾಸ್ ಕರ್‍ತೆ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾನ್, “ಸಾಯ್ಬಾ ತೊ ಕೊನ್ ಮನುನ್ ಮಾಕಾ ಸಾಂಗ್, ಅಶೆ ಮಿಯಾ ತೆಚೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರುಕ್ ಹೊತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ಜೆಜುನ್ ತೆಕಾ “ತಿಯಾ ಬಗಟ್ಲೆಯ್ ತೆಕಾ, ತುಜೆ ಕಡೆ ಅತ್ತಾ ಬೊಲುಲಾಕಿ ತೊಚ್ ತೊ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ತನ್ನಾ ತ್ಯಾ ಮಾನ್ಸಾನ್ “ಧನಿಯಾ ಮಿಯಾ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ” ಮಟ್ಲ್ಯಾನ್ ಅನಿ ಜೆಜುಚ್ಯಾ ಇದ್ರಾಕ್ ಡಿಂಬಿಯಾ ಘಾಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ನ್ಯಾಯ್ ನಿರ್‍ನಯ್ ಕರುಕ್ ಮನುನ್ ಹ್ಯಾ ಜಗಾತ್ ಯೆಲಾ, ತೆಚೆಸಾಟ್ನಿ ಕುಡ್ಡ್ಯಾನಿ ಬಗುಕ್ ಪಾಜೆ ಅನಿ ಜೆ ಕೊನಾಕ್ ದಿಸ್ತಾ ತೆನಿ ಕುಡ್ಡೆ ಹೊವ್ಕ್ ಪಾಜೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ಥೈ ತ್ಯೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ಉಲ್ಲ್ಯಾ ಫಾರಿಜೆವಾನಿ ತೆನಿ ಸಾಂಗಲ್ಲೆ ಆಯ್ಕುನ್, “ಅಮ್ಕಾಬಿ ಕುಡ್ಡೆ ಮನುಲಾಲೆ ಕಾಯ್ ತಿಯಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ತೆಂಕಾ ಜೆಜುನ್ “ತುಮಿ ಕುಡ್ಡೆ ಮನುನ್ ರ್‍ಹಾಲ್ಯಾರ್, ತುಮಿ ಚುಕಿದಾರ್ ಹೊಯ್‍ನ್ಯಾಶಿ, ಖರೆ ಅನಿಬಿ ತುಮಿ ತುಮ್ಚಿ ನದರ್ ಬರಿಚ್ ಮನುನ್ ಮನ್ತ್ಯಾಶಿ ತರ್, ತುಮಿ ಚುಕ್ ಚಿಂತುನ್ ಹಾಸಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ಜೆಜುನ್ ಅಶೆ ಮಟ್ಲ್ಯಾನ್, “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆಚ್! ಸಾಂಗ್ತಾ ಬಕ್ರ್ಯಾಂಚ್ಯಾ ಗೊಟ್ಯಾತ್ ಜೆ ಕೊನ್ ದಾರಾತ್ನಾ ಭುತ್ತುರ್ ಗುಸಿನಾ, ವೈನಾ ಚೆಡುನ್ ದುಸ್ರ್ಯಾಕ್ನಾಚ್ ಭುತ್ತುರ್ ಗುಸ್ತಾ ತೊ ಚೊರ್ ಅನಿ ಲುಟುನ್ ಘೆವ್ನ್ ಜಾತಲೊ ಮಾನುಸ್ , ");
INSERT INTO kans_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ಜೊ ಕೊನ್ ದಾರಾತ್ನಾ ಭುತ್ತುರ್ ಗುಸ್ತಾ ತೊಚ್ ತ್ಯಾ ಬಕ್ರ್ಯಾಂಚೊ ಕುರ್‍ಬುರ್. ");
INSERT INTO kans_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ದಾರಾಕ್ಡೆ ಹೊತ್ತೆ ರಾಕ್ವಾಲಿ ತೆಕಾ ದಾರ್ ಉಗಡ್ತ್ಯಾತ್, ತೊ ಅಪ್ನಾಚ್ಯಾ ಬಕ್ರ್ಯಾಕ್ನಿ ನಾವಾನಿ ಬಲ್ವುತಾ, ತಿ ಬಕ್ರಿ ತೆಚೊ ಧನ್ ಆಯಿಕ್ತ್ಯಾತ್, ಅನಿ ತೊ ತೆಂಕಾ ಫಾಟ್ನಾ ಚಾಲ್ವುನ್ ಘೆವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ಭಾಯ್ರ್ ಘೆವ್ನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೊ ತೆಂಚ್ಯಾ ಫಿಡೆ-ಫಿಡೆ ಜಾತಾ ಅನಿ ತಿ ಬಕ್ರಿ ತ್ಯೆಚ್ಯಾ ಫಾಟ್ನಾ ಯೆತಾತ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಂಕಾ ತೆಚೊ ಧನ್ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ತಿ ಬಕ್ರಿ ವಳಕ್ ನಸಲ್ಲ್ಯಾಂಚ್ಯಾ ಫಾಟ್ನಾ ಜಾಯ್ನಾತ್, ವಳಕ್ ನಸಲ್ಲ್ಯಾನಿಕ್ನಾ ತಿ ಧುರ್ ಪಳುನ್ ಜಾತಾತ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿ ಬಕ್ರಿ ತೆಂಚೊ ಧನ್ ವಳ್ಕಿನಾತ್”. ");
INSERT INTO kans_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ಜೆಜುನ್ ಹಿ ಕಾನಿ ತೆಂಕಾ ಸಾಂಗಟ್ಲ್ಯಾನ್ ಹೊಯ್, ಖರೆ ತೆಂಕಾ ಕಾಯ್ಬಿ ಕಳುಕ್‍ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ತಸೆಮನುನ್ ಜೆಜುನ್ ತೆಂಕಾ “ಅನಿ ಎಗ್ದಾ ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ಬಕ್ರ್ಯಾನಿಕ್ಡೆ ಜಾತಲಿ ದಡ್ಪೊ ಮಿಯಾಚ್. ");
INSERT INTO kans_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ಮಾಜ್ಯಾನ್ ಅದ್ದಿ ಯೆಲ್ಲೆ ಸಗ್ಳಿ ಲೊಕಾ ಚೊರಾ ಅನಿ ಲುಟುನ್ ಘೆವ್ನ್ ಜಾತಲಿ ಲೊಕಾ, ಖರೆ ಬಕ್ರಿ ತೆನಿ ಸಾಂಗಟಲ್ಲೆ ಆಯ್ಕಿನಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ಮಿಯಾಚ್ ದಡ್ಪೊ, ಮಾಜ್ಯಾಕ್ನಾ ಜೆ ಕೊನ್ ಯೆತಾ ತೊ ಹುರ್ತಾ, ತೊ ಯೆತಾ ಅನಿ ಭಾಯ್ರ್ ಜಾತಾ ತೆಕಾ ಬರೊ ಚಾರೊ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ಚೊರ್ ಫಕತ್ ಚೊರುಕ್, ಜಿವಾನಿ ಮಾರುಕ್, ಅನಿ ಹಾಳ್ ಕರುಕ್ ಯೆತಾ, ಮಿಯಾ ತುಮ್ಕಾ ಜಿವ್ ಗಾವುಚೊ ಮನುನ್ ಯೆಲಾ, ಭರ್‍ಪುರ್ ಮಾಪಾನ್ ದಿವ್ಚೆ ಅನಿ ಜಿವ್ ದಿವ್ಚೆ ಮನುನ್ ಯೆಲಾ”. ");
INSERT INTO kans_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ಬಕ್ರ್ಯಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಜಿವ್ ದಿವ್ಕ್ ತಯಾರ್ ಅಸಲ್ಲೊ ಬರೊ ಕುರ್‍ಬುರ್ ಮಿಯಾಚ್” ");
INSERT INTO kans_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ಮಜುರಿನ್ ಹೊತ್ತೊ ಮಾನುಸ್ ಕುರ್‍ಬುರ್ ನ್ಹಯ್, ಅನಿ ತಿ ಬಕ್ರಿ ತೆಚಿ ಸ್ವತಾಚಿ ನ್ಹಯ್. ತಸೆಮನುನ್ ಝುಲ್ ಕುತ್ರೆ ಯೆತಲೆ ಬಗಟಲ್ಲ್ಯಾ ತನ್ನಾ ತೊ ಪಳುನ್ ಜಾವ್ನ್ ಸೊಡ್ತಾ, ಅಶೆ ತೆ ಝುಲ್ ಕುತ್ರೆ ತ್ಯಾ ಬಕ್ರ್ಯಾತ್ನಿ ಗುಸುನ್ ಬಕ್ರ್ಯಾಕ್ನಿ ಮೊಡ್ತಾ, ಅನಿ ತಿ ಬಕ್ರಿ ಮಾಳ್ಬರ್ ಹೊತಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ಮಜುರಿಚೊ ಮಾನುಸ್ ಮಜುರಿನ್ ರ್‍ಹಾತಾ ತೆಕಾ ಬಕ್ರ್ಯಾಂಚೆ ಪಡುನ್ ಗೆಲ್ಲೆ ನಾ. ತಸೆಮನುನ್ ತೊ ತೆಂಕಾ ಸೊಡುನ್ ಪಳುನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ಮಿಯಾ ಬರೊ ಕುರ್‍ಬುರ್, ಕಶೆ ಬಾಬಾ ಮಾಕಾ ವಳಕ್ತಾ ಅನಿ ಮಿಯಾ ಬಾಬಾಕ್ ವಳಕ್ತಾ, ");
INSERT INTO kans_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ತಶೆಚ್ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಕ್ರ್ಯಾಕ್ನಿ ವಳಕ್ತಾ. ಅನಿ ತೆನಿ ಮಾಕಾ ವಳಕ್ತಾತ್, ಅನಿ ಮಾಕಾ ತ್ಯೆಂಚ್ಯಾಸಾಟ್ನಿ ಜಿವ್ ದಿವ್ಕ್ ತಯಾರ್ ಹಾಯ್, ");
INSERT INTO kans_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ಹ್ಯಾ ಬಕ್ರ್ಯಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ನಸಲ್ಲಿ ಮಾಕಾ ಸಮಂದ್ ಪಡಲ್ಲಿ ಅನಿ ಉಲ್ಲಿ ಬಕ್ರಿ ಹಾತ್‍. ತೆಂಕಾಬಿ ಮಿಯಾ ಫಾಟಿ ಹಾನುಕ್ ಪಾಜೆ, ತೆನಿ ಮಾಜೊ ಧನ್ ಆಯಿಕ್ತ್ಯಾತ್ ಅನಿ ತೆನಿ ಎಕುಚ್ ಕುರ್‍ಬುರಾಚ್ಯಾ ಎಕುಚ್ ತಾಂಡ್ಯಾತ್ ರ್‍ಹಾತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ಮಾಜೊ ಬಾಬಾ ಮಾಕಾ ಪ್ರೆಮ್ ಕರ್‍ತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಮಾಜೊ ಜಿವ್ ದಿವ್ಕ್ ಸೈತ್ ತಯಾರ್ ಹಾಂವ್. ತೊ ಜಿವ್ ಮಿಯಾ ಅನಿ ಪರ್ತುನ್ ಖಮ್ವುನ್ ಘೆವ್ಕ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ಕೊನಾಕ್ಬಿ ಮಾಜೊ ಜಿವ್ ಕಾಡುನ್‍ ಘೆವ್ಕ್ ಹೊಯ್ನಾ, ಮಿಯಾ ಮಾಜ್ಯಾ ಸ್ವಂತ್ ಕುಶಿನ್ ತೊ ದಿತಾ. ಅನಿ ತೊ ಜಿವ್ ಪರ್ತುನ್ ಘೆತಲೊ ಹಕ್ಕ್ ಮಾಕಾ ಹಾಯ್, ಹೆ ಕರುಸಾಟ್ನಿ ಮನುನ್ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ಹುಕುಮ್ ದಿಲ್ಯಾನಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ಅನಿ ಹ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಲಾಗುನ್ ಜುದೆವಾತ್ನಿ ಭಾಗ್ ಹೊಲ್ಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ತೆಂಚ್ಯಾತ್ಲೆ ಲೈ ಲೊಕಾ “ತೆಕಾ ಗಿರೊಲಾಗ್ಲಾ! ತೊ ಪಿಸೊ ಹೊಲಾ ತೆಚ್ಯೆ ಅಮಿ ಕಶ್ಯಾಕ್ ಆಯ್ಕುಚೆ” ಮನುಲಾಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ಖರೆ ಅನಿ ಹುರಲ್ಲೆ, “ಗಿರೊಲಾಗಲ್ಲೊ ಮಾನುಸ್ ಅಸೊ ಬೊಲಿ ನಾ! ಎಕ್ ಗಿರ್‍ಯಾನ್ ಕುಡ್ಡ್ಯಾ ಮಾನ್ಸಾಕ್ ದಿಸಿ ಸರ್ಕೆ ಕರುಕ್ ಹೊತಾ ಕಾಯ್?” ಮನುಲಾಗಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ಥಂಡಿಚಿ ದಿಸಾ ತಿ, ಅನಿ ದೆವಾಚ್ಯಾ ಗುಡಿಚೊ ಬೆಟ್ವುತಲೊ ಸನ್ ಜೆರುಜಲೆಮಾತ್ ಹೊವ್ನ್ ಸರಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ಜೆಜು ಸೊಲೊಮೊನಾಚ್ಯಾ ಮಂಟಪಾತ್ನಾ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಫಿರುಲಾಗಲ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ತನ್ನಾ ಜುದೆವ್ ಲೊಕಾ ತ್ಯೆಚ್ಯಾ ಭೊತ್ಯಾನಿ ಗೊಳಾ ಹೊಲಿ, ಅನಿ, “ಅಮ್ಕಾ ಅನಿ ಕವ್ಡೆ ಪತರ್ ಸಾಂಗಿನಸ್ತಾನಾಚ್ ರ್‍ಹಾತೆಯ್? ಮನುನ್ ಅಮ್ಕಾ ಖರೆಚ್! ಫೊಡುನ್ ಸಾಂಗ್” ತಿಯಾ ಮೆಸ್ಸಿಯಾ ಕಾಯ್? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ಜೆಜುನ್ ತೆಂಕಾ “ಮಿಯಾ ತುಮ್ಕಾ ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗುನ್ ಹೊಲಾ, ಖರೆ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಿನಾ ಹೊಲ್ಯಾಶಿ. ಮಿಯಾ ಕರ್‍ತಲಿ ಸಗ್ಳಿ ಕಾಮಾ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಮಿಯಾ ಹಿ ಕಾಮಾ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ಖರೆ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾಸಿ, ತಸೆಮನುನ್ ತುಮಿ ಮಾಜಿ ಬಕ್ರಿ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ಮಾಜಿ ಬಕ್ರಿ ಮಾಜೊ ಧನ್ ಆಯಿಕ್ತ್ಯಾತ್ ಮಿಯಾ ತೆಂಕಾ ವಳಕ್ತಾ, ಅನಿ ತೆನಿ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆತಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ಮಿಯಾ ತೆಂಕಾ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ದಿತಾ, ತೆನಿ ಕನ್ನಾಬಿ ಮರಿನ್ಯಾತ್. ಕೊನಾಚ್ಯಾನ್ಬಿ ತೆಂಕಾ ಮಾಜೆಕ್ನಾ ಕಾಡುನ್ ಘೆವ್ಕ್ ಅನಿ ಮಾಜ್ಯಾಕ್ನಾ ಧುರ್ ಕರುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ಜೆ ಕಾಯ್ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ದಿಲ್ಯಾನಾಯ್ ತೆ ಸಗ್ಳ್ಯಾಚ್ಯಾನ್ಕಿ ಮೊಟೆ, ಮಾಜೊ ಬಾಬಾ ತೆಂಕಾ ರಾಕ್ತಾನಾ ಕೊನಾಕ್ಬಿ ತೆಂಕಾ ಧುರ್ ಕರುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ಬಾಬಾ ಅನಿ ಮಿಯಾ ಎಕುಚ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ತನ್ನಾ ಅನಿ ಜುದೆವ್ ಲೊಕಾನಿ ತೆಕಾ ಗುಂಡ್ಯಾನಿ ಮಾರುಕ್ ಮನುನ್ ಗುಂಡೆ ಎಚುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ಜೆಜುನ್ ತೆಂಕಾ,“ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಕರುಕ್ ಮನುನ್ ಮಾಕಾ ದಿಲ್ಲಿ ಲೈ ಬರಿ ಕಾಮಾ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಕರ್‍ಲೊ; ಹ್ಯಾ ಕಾಮಾನಿತ್ಲ್ಯಾ ಖಲ್ಯಾ ಕಾಮಾಸಾಟ್ನಿ ತುಮಿ ಮಾಕಾ ಗುಂಡ್ಯಾನಿ ಮಾರ್‍ತ್ಯಾಶಿ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ತ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ, “ಅಮಿ ತಿಯಾ ಕರಲ್ಲ್ಯಾ ಖಲ್ಯಾಬಿ ಬರ್‍ಯಾ ಕಾಮಾಸಾಟ್ನಿ ತುಕಾ ಗುಂಡ್ಯಾನಿ ಮಾರುಕ್ ಉಟುಕ್ನಾವ್! ತಿಯಾ ಕರ್‍ತಲ್ಯಾ ನಿಂದ್ಯಾಸಾಟ್ನಿ ಅಮಿ ಮಾರುಕ್ ಉಟ್ಲಾವ್! ತಿಯಾ ಎಕ್ ಮಾನುಸ್, ಖರೆ ತಿಯಾ ತುಕಾಚ್ ದೆವ್ ಕರುಕ್ ಬಗುಲಾಲೆಯ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ಜೆಜುನ್ ತೆಂಕಾ “ತುಮ್ಚ್ಯಾಚ್ ಖಾಯ್ದ್ಯಾತ್ನಿ?” ದೆವ್ ಮಿಯಾ ಮನ್ತಾ. ತುಮಿ ದೆವಾ ಮನುನ್ ನಾ ಕಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಸಾಂಗಲ್ಲೆ ಸಗ್ಳೆ ಖರೆಚ್! ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್, ದೆವ್ ಅಪ್ನಾಚಿ ಖಬರ್ ದಿವ್ನ್ ಧಾಡಲ್ಲ್ಯಾಕ್ನಿ ತುಮಿ ದೆವಾ ಸರ್ಕೆ ಮನ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ತಸೆಚ್ ಮಾಜ್ಯಾ ಬಾಬಾನ್‍ಬಿ ಮಾಕಾ ಎಚುನ್ ಕಾಡುನ್ ಹ್ಯಾ ಜಗಾತ್ ಧಾಡುನ್ ದಿಲ್ಯಾನಾಯ್, ತಸೆ ಜಾಲ್ಯಾರ್ ಮಿಯಾ ದೆವಾಚೊ ಲೆಕ್ ಮಟಲ್ಲೆ ತುಮಿ ನಿಂದ್ಯಾ ಕರ್‍ಲ್ಯಾ ಸರ್ಕೆ ಕಶೆ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ ಪಾಜೆ ಹೊಲ್ಲೆ ಕರ್ಲ್ಯಾರ್‍ಬಿ ತುಮಿ ಮಾಜೆರ್ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ಅಶೆ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಿನಸ್ಲ್ಯಾರ್ಬಿ ಮಿಯಾ ತಿ ಕರ್‍ತಾ, ತುಮಿ ಮಿಯಾ ಕರ್‍ತಲಿ ಕಾಮಾ ತರ್ಬಿ ಬಗುನ್ ವಿಶ್ವಾಸ್ ಕರಾ, ಅಶೆ ಎಗ್ದಾ ತರ್‍ಬಿ ಸಗ್ಳ್ಯಾತ್ ಮಾಜೊ ಬಾಬಾ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಯ್, ಅನಿ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಂವ್ ಮನುನ್ ಕಳ್ತಾ ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ಅನಿ ಎಗ್ದಾ ತೆನಿ ತೆಕಾ ಧರುಕ್ ಮನುನ್ ಬಗಟ್ಲ್ಯಾನಿ, ಖರೆ ಜೆಜು ತೆಂಚ್ಯಾ ಹಾತಾನಿತ್ನಾ ಚುಕ್ವುನ್ ಘೆವ್ನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ತನ್ನಾ ಜೆಜು ಫಾಟಿ ಪರ್ತುನ್ ಜೊರ್ದಾನ್ ನ್ಹಯ್ ದಾಟುನ್ ಜುವಾಂವಾಕ್ ಬಾಲ್ತಿಮ್ ದಿಲ್ಲ್ಯಾನ್ ತ್ಯಾ ಜಾಗ್ಯಾಕ್ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ಲೈ ಲೊಕಾ ತೆಚೆಕ್ಡೆ ಯೆಲಿ ಅನಿ ತ್ಯಾ ಲೊಕಾನಿ,“ಜುವಾಂವಾಕ್ ಅಜಾಪಾ ಕರುಕ್‍ ನಾ” ಖರೆ ತೆನಿ ಹ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗಟಲ್ಲೆ ಸಗ್ಳೆ ಖರೆ ಹೊಲೆ, ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ಥೈ ಲೈ ಲೊಕಾನಿ ಜೆಜು ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ಬೆಥನಿ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಲಾಜರ್ ಮನ್ತಲೊ ಎಕ್ ಮಾನುಸ್ ಹೊತ್ತೊ, ತೊ ಶಿಕ್ ಹೊತ್ತೊ, ಮರಿ ಅನಿ ತಿಚಿ ಭೆನ್ ಮಾರ್ಥಾ ಬೆಥನಿ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಜಿವನ್ ಕರಿತ್. ");
INSERT INTO kans_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ಜೆಜುಚ್ಯಾ ಪಾಯಾ ವೈನಿ ಬರಿ ವಾಸ್ ಯೆತಲೆ ತೆಲ್ ಜೆಜುಚ್ಯಾ ಪಾಂಯಾಂಚ್ಯಾ ವರ್ತಿ ವೊತಲ್ಲಿ ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಕೆಸಾನಿ ಪುಸಲ್ಲಿ ಮರಿ ಹಿ, ಶಿಕ್ ಅಸಲ್ಲೊ ಲಾಜರ್ ಹಿಚೊ ಭಾವ್. ");
INSERT INTO kans_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ಲಾಜರಾಚ್ಯಾ ಭೆನ್ಯಾನಿ “ಧನಿಯಾ ತುಜೊ ಪ್ರೆಮಾಚೊ ದೊಸ್ತ್ ಶಿಕ್ ಪಡ್ಲಾ” ಮನುನ್ ಜೆಜುಕ್ ಬಾತ್ಮಿ ಸಾಂಗುನ್ ಧಾಡಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ಹಿ ಬಾತ್ಮಿ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ “ಹ್ಯಾ ಪಿಡೆಚೊ ಪರಿನಾಮ್ ಲಾಜರಾಚ್ಯಾ ಮರ್‍ನಾಚ್ಯಾ ವೈನಾ ಸರಿನಾ, ಹೆ ದೆವಾಕ್ ಮಹಿಮಾ ಹಾನುಸಾಟ್ನಿ ಮನುನ್ ಹೊಲಾ, ಅನಿ ಹಿಚ್ಯಾ ವೈನಾ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮಹಿಮಾ ಜೊಡುನ್ ಘೆತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ಜೆಜುಕ್ ಮಾರ್ಥಾ ಅನಿ ತಿಚಿ ಭೆನ್ ಅನಿ ಲಾಜರಾಚೊ ಲೈ ಪ್ರೆಮ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ಲಾಜರ್ ಶಿಕ್ ಹಾಯ್ ಮನ್ತಲಿ ಬಾತ್ಮಿ ಗಾವ್ಲ್ಯಾರ್ ಬಿ ಜೆಜು ಅಪ್ನಿ ಖೈ ಹೊತ್ತೊ ಥೈ ಅನಿ ದೊನ್ ದಿಸ್ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ತನ್ನಾ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ , “ಅಮಿ ಜುದೆಯಾಕ್ ಜಾವಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ತನ್ನಾ ಶಿಸಾನಿ, “ಗುರುಜಿ, ಅತ್ತಾ ಎಕ್ ಉಲ್ಲ್ಯಾ ಎಳಾಚ್ಯಾ ಫಾಟಿ ಥೈ ತುಕಾ ಲೊಕಾ ಗುಂಡ್ಯಾನಿ ಮಾರುಕ್ ಮನುನ್ ಉಟಲ್ಲಿ, ಅನಿ ತಿಯಾ ಥೈಚ್ ಜಾವ್ಕ್ ಬಗುಲೆ ಕಾಯ್?” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ತನ್ನಾ ಜೆಜುನ್, “ಎಕ್ ದಿಸಾಕ್ ಬಾರಾ ತಾಸ್ ಹೊಯ್ ಕಾಯ್ ನ್ಹಯ್? ಕೊನ್ ದಿಸಾಚ್ಯಾ ಉಜ್ವೊಡಾತ್ ಚಲ್ತಾ ತೊ ಅದ್ಳುನ್ ಪಡಿನಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಕಾ ಹ್ಯಾ ಜಗಾಚೊ ಉಜ್ವೊಡ್ ದಿಸ್ತಾ”. ");
INSERT INTO kans_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ಖರೆ ಜೊ ಕೊನ್ ರಾಚ್ಚೆ ಚಲ್ತಾ ತೊ ಅದ್ಳುನ್ ಪಡ್ತಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆಕಾ ಉಜ್ವೊಡ್ ದಿಸಿನಾ. ");
INSERT INTO kans_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ಹೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜುನ್, ಅಮ್ಚೊ ದೊಸ್ತ್ ಲಾಜರ್ ನಿದ್ಲಾ, ಖರೆ ಮಿಯಾ ಜಾವ್ನ್ ತೆಕಾ ವೈರ್ ಉಟ್ವುತಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ತನ್ನಾ ಶಿಸಾನಿ, “ಧನಿಯಾ ತೊ ನಿದ್ಲಾ ಜಾಲ್ಯಾರ್ ತೊ ಬರೊ ಹೊತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ಖರೆ ಜೆಜುನ್ ಮಟಲ್ಲೆ ಲಾಜರಸ್ ಮರ್‍ಲಾ ಮನುನ್, ಖರೆ ಶಿಸಾನಿ ತೊ ಅಶೆಚ್ ಸದ್ದಿಚ್ಯಾ ಬಾಶೆನ್ ನಿದ್ಲಾ ಮನುನ್ ಚಿಂತ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ತಸೆಮನುನ್ ಜೆಜುನ್ ತೆಂಕಾ, “ಲಾಜರ್ ಮರ್‍ಲಾ ಮನುನ್ ಫೊಡುನ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ಖರೆ ತುಮ್ಕಾ ಲಾಗುನ್ ಮಿಯಾ ತ್ಯೆಚ್ಯಾ ವಾಂಗ್ಡಾ ನಸಲ್ಲ್ಯಾಸಾಟಿ ಮಾಕಾ ಖುಶಿ ಹೊತಾ, ಅಶೆಚ್ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತ್ಯಾಶಿ. ಚಲಾ ಅಮಿ ಲಾಜರಾಕ್ಡೆ ಜಾಂವ್ವಾ” ಮಟ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ತನ್ನಾ ದಿದಿಮೊಸ್ ಮನ್ತಲೊ ಥೊಮಸಾನ್ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗುಡ್ಚ್ಯಾ ಶಿಸಾಕ್ನಿ, “ಅಮಿ ಸಗ್ಳಿ ಲೊಕಾಬಿ ಗುರುಜಿಚ್ಯಾ ವಾಂಗ್ಡಾ ಥೈ ಜಾಂವ್ವಾ, ಅಶೆಚ್ ಅಮಿಬಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಮರುಕ್ ಹೊತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ಜೆಜು ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ, ಲಾಜರಾಕ್ ಸಮಾದಿತ್ ಥವ್ನ್ ಚಾರ್ ದಿಸ್ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ಬೆಥನಿ ಜೆರುಜಲೆಮಾತ್ನಾ ಜಗೊಳ್ ತಿನ್ ಮೈಲ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ಅನಿ ಜುದೆಯಾತ್ಲಿ ಲೈ ಲೊಕಾ ಅಪ್ನಾಚ್ಯಾ ಭಾವಾಚ್ಯಾ ಮರ್‍ನಾಕ್ ಲಾಗುನ್ ದುಖಾತ್ ಹೊತ್ತ್ಯಾ ಮಾರ್ಥಾಕ್ ಅನಿ ಮರಿಕ್ ಭೆಟುಕ್ ಮನುನ್ ಯೆಲ್ಲಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ಜೆಜು ಯೆವ್ಲಾ ಮನುನ್ ಖಬರ್ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಮಾರ್ಥಾ ಜೆಜುಕ್ ಭೆಟುಕ್ ಮನುನ್ ಘರಾತ್ನಾ ಭಾಯ್ರ್ ಗೆಲಿ, ಖರೆ ಮರಿ ಭುತ್ತುರ್ ಘರಾತುಚ್ ರ್‍ಹಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ಮಾರ್ಥಾನ್ ಜೆಜುಕ್, “ಧನಿಯಾ ತಿಯಾ ಹಿತ್ತೆ ರ್‍ಹಾಲ್ಯಾರ್ ಮಾಜೊ ಭಾವ್ ಮರಿನಶಿ ಹೊತ್ತೊ! ");
INSERT INTO kans_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ಖರೆ ಅತ್ತಾ ಹೊಲ್ಯಾರ್ಬಿ ತಿಯಾ ದೆವಾಕ್ಡೆ ಮಾಗ್ಲ್ಯಾರ್ ದೆವ್ ತಿಯಾ ಕಾಯ್ ಇಚಾರ್‍ತೆ ತೆ ಕರ್‍ತಾ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ತನ್ನಾ ಜೆಜುನ್ ತಿಕಾ, “ತುಜೊ ಭಾವ್ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟ್ತಾ” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ತನ್ನಾ ತಿನಿ, “ಆಕ್ರಿಚ್ಯಾ ದಿಸಿ ಅನಿ ಪರ್ತುನ್ ಝಿತ್ತೆ ಹೊವ್ನ್ ಉಟ್ತಲ್ಯಾ ಎಳಾರ್ ತೊ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟ್ತಾ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ತನ್ನಾ ಜೆಜುನ್ ತಿಕಾ “ಝಿತ್ತೆ ಹೊವ್ನ್ ಉಟ್ತಲೆ ಅನಿ ಜಿವ್ ಮಿಯಾಚ್. ಜೊ ಕೊನ್ ಮಾಜೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ ತೊ ಮರ್‍ಲ್ಯಾರ್‍ಬಿ ಝಿತ್ತೊ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ಅನಿ ಜೊ ಕೊನ್ ಝಿತ್ತೊ ರ್‍ಹಾತಾ ಅನಿ ಮಾಜೆವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ ತೊ ಕನ್ನಾಚ್ ಹೆ ತಿಯಾ ವಿಶ್ವಾಸ್ ಕರ್‍ತೆ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ತನ್ನಾ ಮಾರ್ಥಾನ್, “ಹೊಯ್ ಧನಿಯಾ! ತಿಯಾ ಮೆಸ್ಸಿಯಾ ಹ್ಯಾ ಜಗಾತ್ ಯೆತಲೊ ಹಾಯ್ ಮನುನ್ ಹೊತ್ತೊ ದೆವಾಚೊಲೆಕ್ ಮನುನ್ಬಿ ಮಿಯಾ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ಮಾರ್ಥಾನ್ ಹೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಅಪ್ನಾಚ್ಯಾ ಭೆನಿಕ್ಡೆ ಮರಿಕ್ಡೆ ಗೆಲಿ ಅನಿ ಕೊನಾಕ್ಬಿ ಗೊತ್ತ್ ನಸ್ತಾನಾ ಬಲ್ವುಲಿನ್ ಅನಿ ತೆನಿ ತಿಕಾ “ಗುರುಜಿ ಹಿತ್ತೆ ಯೆವ್ನ್ ಪಾವ್ಲಾ ಅನಿ ತೊ ತುಕಾ ಇಚಾರುಲಾಲಾ” ಮನುನ್ ಸಾಂಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಮರಿ ಉಟ್ಲಿ ಗಡ್ಬಡಿನ್ ಜೆಜುಕ್ ಭೆಟುಕ್ ಗೆಲಿ ");
INSERT INTO kans_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ಜೆಜು ಅಜುನ್ ಗಾಂವಾಕ್ ಯೆವ್ನ್ ಪಾವುನತ್ತೊ, ತೊ ಅಜುನ್ ತೆಕಾ ಮಾರ್ಥಾ ಭೆಟಲ್ಲ್ಯಾ ಜಾಗ್ಯಾರುಚ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ಘರಾತ್ ಮರಿಕ್ ಸಮಾದಾನ್ ಸಾಂಗುನ್ಗೆತ್ ಹೊತ್ತಿ ಲೊಕಾ. ತಿ ಗಡ್ಬಡಿನ್ ಭಾಯ್ರ್ ಜಾತಲೆ ಬಗುನ್ ತಿಚ್ಯಾ ಫಾಟ್ನಾ ಗೆಲಿ. ತಿ ಲಾಜರಾಕ್ ಮಾಟಿ ದಿಲ್ಲ್ಯಾ ಸಮಾದಿಕ್ಡೆ ರಡುಸಾಟ್ನಿ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಕಾಯ್ಕಿ ಮನುನ್ ಚಿಂತ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ಮರಿ ಜೆಜು ಹೊತ್ತ್ಯಾಕ್ಡೆನ್ ಯೆವ್ನ್ ಪಾವ್ಲಿ, ಅನಿ ತೆಕಾ ಬಗಟಲ್ಲ್ಯಾ ತನ್ನಾ ತಿ ಜೆಜುಚ್ಯಾ ಪಾಂಯಾತ್ನಿ ಡಬ್ ಪಡ್ಲಿ. ಅನಿ ತಿನಿ, “ಧನಿಯಾ ತಿಯಾ ಹಿತ್ತೆ ರ್‍ಹಾಲ್ಯಾರ್ ಮಾಜೊ ಭಾವ್ ಮರಿನಶಿ ಹೊತ್ತೊ!” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ತನ್ನಾ ಜೆಜುನ್ ಮರಿ ಅನಿ ತಿಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ ಲೊಕಾ ರಡ್ತಲೆ ಬಗಟ್ಲ್ಯಾನ್, ತೆಚ್ಯಾ ಮನಾಕ್ ಬೆಜಾರ್ ಹೊಲೊ ಅನಿ ತೊ ಕಳ್ವಳ್ಳೊ. ");
INSERT INTO kans_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ತನ್ನಾ ತೆನಿ ತೆಂಕಾ, “ತುಮಿ ತೆಕಾ ಖೈ ಥವ್ಲ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ “ಧನಿಯಾ ಯೆ ಅನಿ ಬಗ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ಜೆಜು ರಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ತನ್ನಾ ಜುದೆವ್ ಲೊಕಾನಿ ಸಾಂಗಟಲ್ಲ್ಯಾನಿ, “ಬಗಾ ತೆಕಾ ತೆಚೊ ಕವ್ಡೊ ಪ್ರೆಮ್ ಹೊತ್ತೊ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ಖರೆ ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಜುದೆವಾನಿ, “ಹೆನಿ ಕುಡ್ಡ್ಯಾ ಲೊಕಾಕ್ನಿ ದಿಸ್ಟ್ ಯೆಯ್ ಸಾರ್ಕಿ ಕರ್ಲ್ಯಾನ್ ನ್ಹಯ್? ಲಾಜರಾಕ್ ಮರಿನಶಿ ಸರ್ಕೆ ಕರುಕ್ ತೆಕಾ ಹೊಯ್ನಶಿ ಹೊತ್ತೆ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ಜೆಜು ಅನಿ ಎಗ್ದಾ ಲೈ ವಾಯ್ಟ್ ಕಳ್ವಳ್ಳೊ. ಅನಿ ಲಾಜರಾಕ್ ಥವಲ್ಲ್ಯಾ ಸಮಾದಿಕ್ಡೆ ಗೆಲೊ, ತ್ಯೆಚ್ಯಾ ವಾಟೆರ್ ಗುಂಡೊ ಲಾವ್ನ್ ಧಾಪಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ತನ್ನಾ ಜೆಜುನ್, “ಹ್ಯೊ ಗುಂಡೊ ಕಡೆಕ್ ಕಾಡಾ!” ಮನುನ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್. ತನ್ನಾ ಮಾರ್ಥಾನ್ ತ್ಯಾ ಮರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಭೆನಿನ್, “ಧನಿಯಾ ತೆಕಾ ಸಮಾದಿತ್ ಥವ್ನ್ ಚಾರ್ ದಿಸಾ ಹೊಲಿ ತೆಕಾ ಬುರ್ಶಿ ವಾಸ್ ಪಡ್ಲಾ ಅಶಿಲ್!” ಮನುನ್ ಜಬಾಬ್ ದಿಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ತನ್ನಾ ಜೆಜುನ್ ತಿಕಾ, “ಮಿಯಾ ತುಕಾ ಸಾಂಗುಕ್ನಾ ಕಾಯ್?” ತಿಯಾ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾರ್ ತುಕಾ ದೆವಾಚಿ ಮಹಿಮಾ ಬಗುಕ್ ಗಾವ್ತಾ ಮನುನ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ತೆನಿ ತೊ ಗುಂಡೊ ಕಡೆಕ್ ಕಾಡ್ಲ್ಯಾನಿ. ತನ್ನಾ ಜೆಜುನ್ ವೈರ್ ಬಗಟ್ಲ್ಯಾನ್ ಅನಿ, “ಬಾಬಾ ಮಿಯಾ ತುಕಾ ಧನ್ಯವಾದ್ ದಿತಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿಯಾ ಮಾಜೆ ಆಯಿಕ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ತಿಯಾ ಕನ್ನಾಬಿ ಮಾಜೆ ಆಯಿಕ್ತೆ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಖರೆ ಹ್ಯಾ ಹಿತ್ತೆ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾಸಾಟಿ ಅಶೆಚ್ ಮನುಲಾ, ಅಶೆಚ್ ತೆನಿ ತಿಯಾಚ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲೆ ಮನುನ್‍ ವಿಶ್ವಾಸ್ ಕರುಂದಿತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ಹೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಲಾಜರಾಕ್ ಮೊಟ್ಯಾನ್, “ಲಾಜರ್ ಭಾಯ್ರ್ ಯೆ!” ಮನುನ್ ಬಲ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ಮರಲ್ಲೊ ಮಾನುಸ್ ಭಾಯ್ರ್ ಯೆಲೊ, ತ್ಯೆಚ್ಯಾ ಹಾತಾಕ್ನಿ ಅನಿ ಪಾಂಯಾಕ್ನಿ ಫಾಳಿಯಾ ಲಪಟಲ್ಲ್ಯಾ ಹೊತ್ತ್ಯಾ ಅನಿ ತ್ಯೆಚ್ಯಾ ತೊಂಡಾರ್ ಬಿ ಎಕ್ ಕಪ್ಡೊ ಲಪ್ಟಲ್ಲೊ ಹೊತ್ತೊ. ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ತೆಕಾ ಲಪ್ಟಲ್ಲೊ ಕಪ್ಡೊ ಸೊಡ್ವಾ ಅನಿ ತೊ ಜಾಂವ್ದಿತ್” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ಮರಿಕ್ ಭೆಟುಕ್ ಯೆಲ್ಲ್ಯಾ ಲೈ ಲೊಕಾನಿ ಜೆಜುನ್ ಕರಲ್ಲೆ ಹೆ ಬಗಟ್ಲ್ಯಾನಿ ಅನಿ ತೆಚೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ಖರೆ ತೆಂಚ್ಯಾತ್ಲಿ ಉಲ್ಲಿ ಲೊಕಾ ಫಾರಿಜೆವಾನಿಕ್ನಿ ಗೆಲಿ ಅನಿ ಜೆಜುನ್ ಕಾಯ್ ಕಾಯ್ ಕರ್ಲ್ಯಾನ್ ತೆ ತೆನಿ ತೆಂಕಾ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ತಸೆಮನುನ್ ಫಾರಿಜೆವಾನಿ ಅನಿ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಸನ್ಹೆದ್ರಿನ್ ಸಭಾ ಜಮುಲ್ಯಾನಿ ಅನಿ, “ಅಮಿ ಕಾಯ್ ಕರುಂವಾ? ಹ್ಯೊ ಮಾನುಸ್ ಕಸ್ಲಿ ಅಜಾಪಾ ಕರುಕ್ ಲಾಗ್ಲಾ ಬಗಾ! ");
INSERT INTO kans_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ಅಮಿ ಹೆಕಾ ಅಶಿಚ್ ಫಿಡೆ ಜಾವ್ಕ್ ಸೊಡುನ್ ದಿಲ್ಯಾರ್, ಸಗ್ಳಿ ಲೊಕಾ ಹೆಚೆವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾತ್, ಅನಿ ರೊಮಾಚೆ ಅದಿಕಾರಿ ಯೆವ್ನ್ ಅಮ್ಚ್ಯಾ ದೆವಾಚಿ ಗುಡಿ ಅನಿ ಅಮ್ಚೊ ದೆಶ್ ನಾಸ್ ಕರುನ್ ಟಾಕ್ತಿಲ್!” ಮಟ್ಲ್ಯಾನಿ ");
INSERT INTO kans_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ತೆಂಚಾತ್ಲೊ ಎಕ್ಲೊ ಕಾಯಿಫಾಸ್ ಮನ್ತಲೊ ತ್ಯಾ ವರ್ಸಾ ತೊ ಮೊಟೊ ಮುಖ್ಯ ಯಾಜಕ್ ಹೊವ್ನ್ ಹೊತ್ತೊ ತೆನಿ, “ತುಮ್ಕಾ ಕಾಯ್ಬಿ ಕಳಿನಾ! ");
INSERT INTO kans_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ಸಗ್ಳೊ ದೆಶ್ ನಾಸ್ ಹೊತಲ್ಯಾಚ್ಯಾ ಬದ್ಲಾಕ್ , ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಎಕ್ ಮಾನುಸ್ ಮರ್‍ತಲೆ ಬರೆ ಮನುನ್ ಗೊತ್ತ್ ನಾ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ಖರೆ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಅಪ್ನಿಚ್, ನಾಹೊಲ್ಯಾರ್ ತ್ಯಾ ವರ್ಸಾ ತೊ ಮೊಟೊ ಮುಖ್ಯ ಯಾಜಕ್ ಹೊವ್ನ್ ಹೊತ್ತೊ ಮನುನ್ ತೆನಿ ಅಶೆಚ್ ಸಾಂಗುಕನ್ಯಾತ್, ತೊ ಜೆಜು ಜುದೆವ್ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಮರ್‍ತಲೊ ಹಾಯ್ ಮನುನ್ ಅದ್ದಿಚ್ ಫಿಡೆ ಹೊತಲೆ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ಅನಿ ಖಾಲಿ ತೆಂಕಾ ಎವ್ಡೆಚ್ ನ್ಹಯ್, ಮಾಳ್ಬರ್ ಹೊವ್ನಗೆಲ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಗೊಳಾ ಕರುನ್ ಎಕ್ ಕರುಕಸಾಟ್ನಿ ತೊ ಮರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ತ್ಯಾ ದಿಸಾತ್ನಾ ಜುದೆವಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನಿ ಜೆಜುಕ್ ಜಿವಾನಿ ಮಾರ್‍ತಲೆ ಮನುನ್ ಯೆವ್ಜನ್ ಘಾಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ತಸೆಮನುನ್ ಅನಿ ಫಿಡೆ ಜೆಜು ಜುದೆವಾಂಚ್ಯಾ ಮದ್ದಿ ಬಹಿರಂಗ್ ಫಿರುಕ್ನಾ, ತೊ ಥೈತ್ನಾ ಡಂಗ್ಳಿಚ್ಯಾ ಜಗ್ಗೊಳ್ ಹೊತ್ತ್ಯಾ ಎಫ್ರಾಯಿಮ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಗೆಲೊ, ಥೈ ತೊ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ಪಾಸ್ಕಾಚೊ ಸನ್ ತೊಂಡಾರ್ ಯೆತಲೊ ಹೊತ್ತೊ , ತೆಚೆಸಾಟ್ನಿ ಲೊಕಾ ಗಾವಾ ಗಾವಾನಿತ್ನಾ ಸನಾಚ್ಯಾ ಅದ್ದಿ ಶುದ್ದಾಚಾರಾಚಿ ಶಾಸ್ತರಾ ಕರುನ್ ಘೆವಸಾಟ್ನಿ ಮನುನ್ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ತೆನಿ ಜೆಜುಕ್ ಹುಡ್ಕುಕ್ ಲಾಗಲ್ಲ್ಯಾನಿ, ಅನಿ ತೆಚ್ಯಾ ಸಾಟ್ನಿ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಎಕಾಮೆಕಾಕ್ನಿ, “ತುಮಿ ಕಾಯ್ ಮನ್ತ್ಯಾಶಿ ? ಖರೆಚ್! ತೊ ಸನಾಕ್ ಯೆಯ್ನಸ್ತಾನಾ ರ್‍ಹಾಯ್ಲ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ಜೆಜುಕ್ ಧರುಸಾಟ್ನಿ ಮನುನ್ ಮುಖ್ಯ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಹುಕುಮ್ ದಿಲ್ಲ್ಯಾನಿ ಅನಿ ಫಾರಿಜೆವಾನಿ ಕೊನಾಕ್ಬಿ ಜೆಜು ಖೈ ಹಾಯ್ ಮನುನ್ ಕಳ್ಳ್ಯಾರ್ ತೆನಿ ಯೆವ್ನ್ ಸಾಂಗುಚೆ ಮನುನ್ ಸಗ್ಳ್ಯಾಕ್ನಿ ತಾಕಿತ್ ದಿಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ಪಾಸ್ಕಾಚೆ ಸನಾಕ್ ಸಾ ದಿಸ್ ಹೊತ್ತೆ, ತನ್ನಾ ಜೆಜು ಭೆಥನಿ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್, ಅಪ್ನಿ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವಲ್ಲ್ಯಾ ಲಾಜರಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ತೆನಿ ತೆಕಾ ಥೈ ಜೆವಾನ್ ತಯಾರ್ ಕರಲ್ಲ್ಯಾನಿ, ಮಾರ್ಥಾ ರಾಚ್ಚೆ ಜೆವಾನ್ ವಾಡುಕ್ ಮಜತ್ ಕರಿ. ಲಾಜರ್ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವ್ನಾಚ್ಯಾ ಪಂಗ್ತಿರ್ ಬಸಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ತನ್ನಾ ಮರಿನ್ ಜಟಮಾಂಸಾನ್ ತಯಾರ್ ಹೊಲ್ಲೆ ಲೈ ಮ್ಹಾಗ್ರೆ ತೆಲ್ ಜೆಜುಚ್ಯಾ ಪಾಯಾ ವೈನಿ ವೊತ್ಲಿನ್ ,ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಕೆಸಾನಿ ತೆಚಿ ಪಾಯಾ ಪುಸ್ಲಿನ್. ತನ್ನಾ ಘರ್ ಸಗ್ಳೆ ತ್ಯಾ ತೆಲಾಚ್ಯಾ ವಾಸೆನ್ ಭರುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ತನ್ನಾ ಜೆಜುಚ್ಯಾ ಶಿಸಾನಿತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾನ್ ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತಾಕ್ ಹೆ ಬರೆ ದಿಸುಕ್ನಾ ಹ್ಯೊ ಫಿಡೆ ಜೆಜುಕ್ ಧರುನ್ ದಿತಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ಹೆ ಎವ್ಡೆ ಬರೆ ವಾಸೆಚೆ ತೆಲ್ ತಿನ್ಶೆ ಚಾಂದಿಚ್ಯಾ ಪೈಸ್ಯಾಕ್ನಿ ಇಕುನ್, ಯೆಲ್ಲೆ ಪೈಸೆ ಗರಿಬಾಕ್ನಿ ದಿಲ್ಯಾರ್ ಹೊಯ್ನಶಿ ಹೊತ್ತೆ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ತೆಕಾ ಗರಿಬಾಂಚಿ ಕಾಳ್ಜಿ ಹೊತ್ತಿ ಮನುನ್ ತೆನಿ ಅಶೆಚ್ ಸಾಂಗುಕ್ನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಎಕ್ ಚೊರ್ ಹೊತ್ತೊ. ತೆಚೆಕ್ಡೆ ಪೈಶಾಂಚಿ ಪಿಶ್ವಿ ಹೊತ್ತಿ ಅನಿ ತ್ಯಾತುರ್‍ಲೆ ಪೈಸೆ ತೊ ಅಪ್ನಾಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಕಾಮಾಸಾಟ್ನಿ ವಾಪ್ರಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ಖರೆ ಜೆಜುನ್, “ತಿಚ್ಯಾ ಎವ್ಡ್ಯಾಕ್ ತಿಕಾ ಸೊಡಾ! ಮಾಕಾ ಮಾಟಿ ದಿತಲ್ಯಾ ದಿಸಾಸಾಟಿ ಕರ್‍ತಲೆ ಕಾಮ್ ತಿ ಅತ್ತಾ ಕರುಕ್ ಲಾಗ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ಕನ್ನಾಬಿ ಗರಿಬ್ ಲೊಕಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾಚ್ ರ್‍ಹಾತ್ಯಾತ್ ಖರೆ ಮಿಯಾ ಕನ್ನಾಬಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಯ್ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ಲೈ ಲೊಕಾನಿ ಜೆಜು ಬೆಥನಿಯಾತ್ ಹಾಯ್ ಮನ್ತಲೆ ಆಯ್ಕಲ್ಯಾನಿ ತಸೆಮನುನ್ ತ್ಯಾನಿ ಥೈ ಗೆಲ್ಯಾನಿ, ಖಾಲಿ ಜೆಜುಸಾಟ್ನಿ ಎವ್ಡೆಚ್ ನ್ಹಯ್ ಲಾಜರಾಕ್ ಬಗುಕ್ ಮನುನ್ ಥೈ ಗೆಲ್ಲ್ಯಾನಿ, ತೆಕಾ ಜೆಜುನ್ ಮರಲ್ಲ್ಯಾಕ್ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ತಸೆಮನುನ್ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಲಾಜರಾಕ್ಬಿ ಜಿವಾನಿ ಮಾರ್‍ತಲೆ ಯೆವ್ಜನ್ ಕರ್ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಲಾಜರಾಕ್ ಲಾಗುನ್ ಲೈ ಜುದೆವ್ ಲೊಕಾನಿ ತೆಂಕಾ ಸೊಡುನ್ ಜೆಜುಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ದುಸ್ರೆ ದಿಸಿ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಕ್ ಮನುನ್ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಮೊಟ್ಯಾ ತಾಂಡ್ಯಾನ್ ಜೆಜು ಜೆರುಜಲೆಮಾಕ್ ಯೆವ್ಲಾ ಮನ್ತಲೆ ಆಯಿಕ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ತಸೆಮನುನ್ ತ್ಯಾನಿ ಖಜುರಾಚ್ಯಾ ಪಾನಾ ಸರ್ಕಿ ಪಾನಾ ಘೆವ್ನ್, “ಹೊಸಾನ್ನಾ! ಸರ್ವೆಸ್ವರಾಚ್ಯಾ ನಾವಾನ್ ಯೆತಾ ತೊ ದೆವ್ ಆಶಿರ್ವಾದ್ ದಿವ್ನ್ ದಿ! ದೆವಾ ಇಸ್ರಾಯೆಲಾಚೊ ರಾಜಾ ಆಶಿರ್ವಾದ್ ದಿವ್ನ್ ದಿ!” ಮನುನ್ ಬೊಬ್ ಮಾರುನ್ಗೆತ್ ಜೆಜುಕ್ ಭೆಟುಕ್ ಮನುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ಜೆಜು ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಜೆಜುಕ್ ಎಕ್ ಗಾಡಾವ್ ಗಾವ್ಲೊ ತೊ ತೆಚ್ಯಾ ವರ್ತಿ ಬಸಲ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ಭಿಂವ್ನಕಾಶಿ! ಸಿಯೊನಾಚ್ಯಾ ಶಾರಾಚ್ಯಾ ಲೊಕಾನು ಅಬಕ್ ಹಿತ್ತೆ ತುಜೊ ರಾಜಾ ಎಕ್ ಗಾಡ್ವಾ ವರ್ತಿ ಬಸುನ್ ಯೆತಾ. ಮನುನ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸರ್ಕೆ ಜೆಜು ಗಾಡ್ವಾ ವರ್ತಿ ಬಸುನ್ ಯೆವ್ಲಾ . ");
INSERT INTO kans_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ತ್ಯಾ ಎಳಾರ್ ಹೆ ಸಗ್ಳೆ ಕಾಯ್ ಮನುನ್ ತ್ಯೆಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಕಳುಕ್ ನಾ, ಖರೆ ಜೆಜುಕ್ ಮಹಿಮೆನ್ ಉಟ್ವಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ಕಳ್ಳೆಕಿ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ತ್ಯೆಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸಾರ್ಕೆಚ್ ತೆನಿ ತೆಕಾ ಕರ್ಲ್ಯಾನಿ ಮನುನ್ ತೆಂಕಾ ಯಾದ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ಜೆಜು ಲಾಜರಾಕ್ ಸಮಾದಿತ್ನಾ ಭಾಯ್ರ್ ಯೆ ಮನುನ್ ಬಲ್ವುನ್ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುತಾನಾ ಥೈ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ ಥೈ ಕಾಯ್ ಕಾಯ್ ಹೊಲೆ ಮನ್ತಲೆ ಸಗ್ಳೆ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ತೆನಿ ಅಜಾಪ್ ಕರಲ್ಲೆ ಲೈ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾನ್ ಆಯ್ಕಲ್ಲ್ಯಾನ್ ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ತೆಕಾ ಬಗುಕ್ ಗೆಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ತನ್ನಾ ಫಾರಿಜೆವಾನಿ ಎಕಾಮೆಕಾಕ್ನಿ, “ಬಗಾ ಅಮ್ಚೆನಿ ಕಾಯ್ ಬಿ ಕರುಕ್ ಹೊಯ್ನಾ ಹೊಲಾ! ಸಗ್ಳೊ ಜಗುಚ್ ತ್ಯೆಚ್ಯಾ ಫಾಟ್ನಾ ಜಾವ್ಲಾಲಾ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ಸನಾಚ್ಯಾ ಎಳಾರ್ ಆರಾದನ್ ಕರುಕ್ ಮನುನ್ ಜೆರುಜಲೆಮಾಕ್ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾತ್ನಿ ಉಲ್ಲಿ ಗ್ರಿಕ್ ದೆಶಾಚಿ ಲೊಕಾಬಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ತೆನಿ ಫಿಲಿಪಾಕ್ಡೆ ಗೆಲ್ಯಾನಿ ತೊ ಗಾಲಿಲಿಯಾತ್ಲ್ಯಾ ಬೆತ್ಸಾಯಿದಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ಲೊ ಅನಿ, “ಸಾಯ್ಬಾ ಅಮ್ಕಾ ಜೆಜುಕ್ ಬಗುಚೆ ಮನುನ್ ಹೊತ್ತೆ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ಫಿಲಿಪಾನ್ ಜಾವ್ನ್ ಅಂದ್ರುಕ್ ಜಾವ್ನ್ ಸಾಂಗ್ಲ್ಯಾನ್, ಅನಿ ತೆನಿ ದೊಗೆಬಿ ಜಾವ್ನ್ ಜೆಜುಕ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ಜೆಜುನ್ ತೆಂಕಾ ಜವಾಬ್ ದಿಲ್ಲ್ಯಾನ್, “ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮೊಟಿ ಮಹಿಮಾ ಜೊಡುನ್ ಘೆತಲೊ ಎಳ್ ಅತ್ತಾ ಯೆವ್ನ್ ಪಾವ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ! ಕಡೆ ಪತರ್ ಘಂವಾಚಿ ಭ್ಹಿಂಯ್ ಮಾಟಿತ್ ಪಡುನ್ ಮರಿನಾ ತವ್ಡ್ಯಾ ಪತರ್ ಎಕ್ಲಿಚ್ ರ್‍ಹಾತಾ. ಖರೆ ತಿ ಮರಲ್ಲ್ಯಾ ತನ್ನಾ ಅನಿ ಜಾಸ್ತಿಚಿ ಭ್ಹಿಂಯಾ ಉತ್ಪನ್ನ್ ಕರಿ ಸರ್ಕೆ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ಜೊ ಕೊನ್ ಅಪ್ನಾಚ್ಯಾ ಜಿವಾಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ, ತೊ ತೆ ಕಳ್ದುನ್ ಘೆತಾ, ಅನಿ ಜೊ ಕೊನ್ ಹ್ಯಾ ಜಗಾತ್ ಅಪ್ನಾಚ್ಯಾ ಸ್ವಂತ್ ಜಿವಾಚೊ ದ್ವೆಸ್ ಕರ್‍ತಾ ತೊ ಅಪ್ನಾಚೊ ಜಿವ್ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲ್ಯಾ ಜಿವನಾಕ್ ರಾಕುನ್ ಥವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ಜೆ ಕೊನಾಕ್ ಮಾಜಿ ಸೆವಾ ಕರುಕ್ ಪಾಜೆ ತೊ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆಂವ್ದಿತ್, ಅಶೆಚ್ ಮಿಯಾ ಖೈ ರ್‍ಹಾತಾ ಥೈ ಮಾಜೊ ಸೆವಕ್ ಬಿ ರ್‍ಹಾತಾ. ಅನಿ ಮಾಜೊ ಬಾಬಾ ಮಾಜಿ ಸೆವಾ ಕರ್‍ತಲ್ಯಾಕ್ ಮಾಜೊ ಬಾಬಾ ಭೊಮಾನ್ ದಿತಾ”. ");
INSERT INTO kans_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ಅತ್ತಾ ಮಾಜೊ ಜಿವ್ ಭಿಂವ್ಲಾ, ಅನಿ ಮಿಯಾ ಕಾಯ್ ಸಾಂಗು? ಬಾಬಾ ಹ್ಯೊ ಎಳ್ ಮಾಜೆವರ್ತಿ ಯೆವ್ಕ್ ದಿವ್‍ನಕೊ? ಖರೆ ತೆಚೆಸಾಟ್ನಿಚ್ ಮನುನ್ ಮಿಯಾ ಯೆಲಾ ತಶೆ ಮನುನ್ ಮಿಯಾ ಹ್ಯೊ ಕಸ್ಟ್ ಅನ್ಬೊಗ್ಸುಕುಚ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ಬಾಬಾ, ತುಜೆ ನಾವ್ ಮಹಿಮೆವಂತ್ ಹೊಯ್ ಸಾರ್ಕೆ ಕರ್! ತನ್ನಾ ಸರ್ಗಾವೈನಾ ಮಿಯಾ ತೆ ಮಹಿಮೆವಂತ್ ಕರ್‍ಲಾ ಅನಿ ಅನಿ ಎಗ್ದಾ ತೆ ಮಹಿಮೆವಂತ್ ಕರ್‍ತಾ” ಮನುನ್ ಧನ್ ಆಯ್ಕೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾನ್ ತೊ ಧನ್ ಆಯಿಕ್ಲ್ಯಾನ್ ಅನಿ ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಗುಡ್ಗುಡೊ ತೊ ಮಟ್ಲ್ಯಾನಿ ಅನಿ ಹುರಲ್ಲ್ಯಾನಿ, “ತ್ಯೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ದೆವಾಚ್ಯಾದುತಾನ್‍ ಬೊಲ್ಲ್ಯಾನ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ಖರೆ ಜೆಜುನ್ ತೆಂಕಾ, “ಹ್ಯೊ ಬೊಲಲ್ಲೊ ಧನ್ ಮಾಜೆಸಾಟ್ನಿ ನ್ಹಯ್ ತುಮ್ಚೆಸಾಟ್ನಿ. ");
INSERT INTO kans_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ಅತ್ತಾ ಹ್ಯಾ ಜಗಾಚಿ ಝಡ್ತಿ ಹೊತಲೊ ಎಳ್ ಯೆಲೊ ಹ್ಯೊ ಜಗಾಚ್ಯಾ ಅತ್ತಾ ಫುಡಾರ್‍ಯಾಕ್ ಕಡೆಕ್ ಕಾಡುನ್ ಟಾಕುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ಮಾಕಾ ಕನ್ನಾ ಜಮ್ನಿ ವೈನಾ ವೈರ್ ಉಕ್ಲುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಮಿಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ಮಾಜ್ಯಾಕ್ಡೆ ವೊಡುನ್ ಘೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ಹೆ ಸಾಂಗಲ್ಲ್ಯಾ ಮಾನಾ ತೊ ಅಪ್ನಿ ಕಸ್ಲೆ ಮರಾನ್ ಮರ್‍ತಲೊ ಹಾಯ್ ಮನುನ್ ದಾಕುನ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ತನ್ನಾ ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾನ್, “ಅಮ್ಚೊ ಖಾಯ್ದೊ ಮೆಸ್ಸಿಯಾಕ್ ಕನ್ನಾಚ್ ಮರಾನ್ ನಾ ಮನ್ತಾ, ತಸೆಜಾಲ್ಯಾರ್ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಕ್ ವೈರ್ ಉಕ್ಲುನ್ ಹೊತಾ ಮನುನ್ ತಿಯಾ ಕಶೆ ಮನ್ತೆಯ್? ಮಾನ್ಸಾಚೊ ಲೆಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಕೊನ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ತನ್ನಾ ಜೆಜುನ್, “ಅನಿ ಉಲ್ಲೊಸೊಚ್ ಎಳ್ ಉಜ್ವೊಡ್ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ರ್‍ಹಾತಾ, ಉಜ್ವೊಡ್ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ರ್‍ಹಾತಾನಾಚ್ ತುಮಿ ತುಮ್ಚಿ ಫಿಡ್ಲಿ ವಾಟ್ ಚಲಾ, ಅಶೆಚ್ ಕಾಳೊಕಾಕ್ ತುಮ್ಚ್ಯಾವರ್ತಿ ಯೆವ್ಕ್ ಹೊಯ್ನಾ ಕಾಳ್ಕಾತ್ ಚಲ್ತಲ್ಯಾಕ್ ತೊ ಖೈ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಗೊತ್ತ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ಕವ್ಡ್ಯಾ ಪತರ್ ಉಜ್ವೊಡ್ ತುಮ್ಚೆ ವಾಂಗ್ಡಾ ರ್‍ಹಾತಾನಾಚ್ ತುಮಿ ತ್ಯೆಚೆವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಾ, ಅಶೆಚ್ ತುಮಿ ಉಜ್ವೊಡಾಚಿ ಲೊಕಾ ಹೊವ್ನ್ ರ್‍ಹಾತ್ಯಾಶಿ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ಎವ್ಡೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜು ತೆಂಚೆತ್ನಾ ಭಾಯ್ರ್ ಪಡುನ್ ಗೆಲೊ, ಅನಿ ತೆಂಕಾ ದಿಸುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ತೆನಿ ತೆಂಚ್ಯಾ ಇದ್ರಾಕ್ ಎವ್ಡಿ ಸಗ್ಳಿ ಅಜಾಪಾ ಕರ್ಲ್ಯಾರ್ ಬಿ, ತೆನಿ ತ್ಯೆಚೆವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರುಕ್ನಾತ್, ");
INSERT INTO kans_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ಅಶೆ ತೆಂಕಾ ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾನ್ “ಸರ್ವೆಸ್ವರಾ, ಮಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಖಬ್ರೆ ವರ್ತಿ ಕೊನ್ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ? ಸರ್ವೆಸ್ವರ್ ಅಪ್ನಾಚಿ ತಾಕತ್ ಕೊನಾಚ್ಯಾ ವರ್ತಿ ದಾಕುನ್ ದಿತಾ” ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಪುರಾ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ಅಶೆಚ್ ತೆನಿಬಿ ವಿಶ್ವಾಸ್ ಕರುಕ್ನಾತ್ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಇಸಾಯಿಯಾ ಪ್ರವಾದ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ದೆವಾನ್ ತುಮ್ಚೆ ಡೊಳೆ ಕುಡ್ಡೆ ಕರ್‍ಲ್ಯಾನಾಯ್ ಅನಿ ತೆಂಚಿ ಮನಾಂಚಿ ದಾರಾ ಧಾಪ್ಲ್ಯಾನಾಯ್” “ತಸೆಮನುನ್ ತೆಂಚ್ಯಾ ಡೊಳ್ಯಾಕ್ನಿ ದಿಸಿನಾ ಅನಿ ತೆಂಚ್ಯಾ ಮನಾಕ್ನಿ ಕಾಯ್ ಬಿ ಅರ್ತ್ ಹೊಯ್ನಾ ಅನಿ ಮಿಯಾ ತೆಂಕಾ ಗುನ್ ಕರುಕ್ ಮನುನ್ ತೆನಿ ಮಾಜಾಕ್ಡೆ ಪರ್ತುನ್ ಯೆಯ್ನಾತ್ ಮನುನ್ ದೆವ್ ಮನ್ತಾ.” ಮನುನ್ ಬಿ ಸಾಂಗಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ಇಸಾಯಿಯಾನ್ ತಸೆ ಸಾಂಗಲ್ಲೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್ ಜೆಜುಚಿ ಮಹಿಮಾ ಬಗಟಲ್ಲ್ಯಾನ್ ತಸೆಮನುನ್ ತೆನಿ ಅಶೆಚ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ಉಲ್ಲೆ ಜುದೆವಾಂಚೆ ಅದಿಕಾರಿಬಿ ಜೆಜುವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಿತ್ ಖರೆ ಫಾರಿಜೆವಾಕ್ನಿ ಲಾಗುನ್ ತೆನಿ ತೊ ವಿಶ್ವಾಸ್ ದಾಕ್ವುನ್ ದಿ ನಸಿತ್ ಅಶೆಚ್ ಸಿನಾಗೊಗಾನಿತ್ನಾ ಭಾಯ್ರ್ ಘಾಲ್ತಲೆ ತೆಂಕಾ ನಕ್ಕೊ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ತೆನಿ ದೆವಾಚ್ಯಾ ಶಾಬಾಸ್ಕಿನ್ಬಿ ಜಾಸ್ತಿ ಮಾನ್ಸಾಚ್ಯಾ ಶಾಬಾಸ್ಕಿಕ್ ಪ್ರೆಮ್ ಕರ್‍ತಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ಜೆಜುನ್ ಮೊಟ್ಯಾ ಅವಾಜಾನ್ ಸಾಂಗಲ್ಲ್ಯಾನ್ “ಜೊ ಕೊನ್ ಮಾಜೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ ತೊ ಖಾಲಿ ಮಾಜೆವರ್ತಿ ಎವ್ಡೆಚ್ ನ್ಹಯ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಚ್ಯಾ ವರ್‍ತಿಬಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ಜೊ ಕೊನ್ ಮಾಕಾ ಬಗ್ತಾ, ತೊ ಮಾಕಾ ಧಾಡಲ್ಲ್ಯಾಕ್ ಬಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ಮಿಯಾ ಹ್ಯಾ ಜಗಾಕ್ ಎಕ್ ಉಜ್ವೊಡ್ ಹೊವ್ನ್ ಯೆಲಾ. ತೆಚೆಸಾಟ್ನಿ ಮಾಜೆವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಲೊ ಕೊನ್ ಬಿ ಕಾಳ್ಕಾತ್ ರ್‍ಹಾಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ಕೊನ್ ಮಾಜಿ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುನ್ ತಿ ಪಾಳಿನಾ, ಮಿಯಾ ತೆಚಿ ನಿತ್ ಕರಿನಾ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಜಗಾಚಿ ನಿತ್ ಕರುಕ್ ಮನುನ್ ಮಿಯಾ ಯೆವ್ಕ್ ನಾ, ಜಗಾಕ್ ಹುರ್‍ವುನ್ ಘೆವ್ಕ್ ಮನುನ್ ಯೆಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ಜೊ ಕೊನ್ ಮಾಕಾ ಇನ್ಕಾರ್ ಕರುನ್, ಮಾಜ್ಯಾ ತೊಂಡಾತ್ನಾ ಯೆಲ್ಲಿ ಶಬ್ದಾ ಮಾನುನ್ ಘೆಯ್ನಾ ತ್ಯಾಚ್ ಮಾಜ್ಯಾ ಗೊಸ್ಟಿಯಾ ತೆಂಚಿ ನಿತ್ ಕರ್‍ತಲೊ ಎಕ್ಲೊ ಹಾಯ್, ಆಕ್ರಿಚ್ಯಾ ದಿಸಿ ಮಿಯಾ ಬೊಲಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾಚ್ ತೆಚಿ ನಿತ್ ಹೊಯ್ ಸಾರ್ಕಿ ಕರ್‍ತಾತ್! ");
INSERT INTO kans_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ಹೆ ಖರೆಚ್! ಹಾಯ್ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಮಾಜ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಕಾಯ್ ಬೊಲುಕ್ನಾ, ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಹುಕುಮಾ ಸರ್ಕೆ ಸಾಂಗುಚೆ ಅನಿ ಬೊಲುಚೆ. ");
INSERT INTO kans_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ಅನಿ ತೆನಿ ದಿಲ್ಲಿ ಹುಕುಮ್ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ದಿತಾ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್, ತಸೆಮನುನ್ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಸಾಂಗ್ ಮನುನ್ ಸಾಂಗಲ್ಲೆಚ್ ಸಾಂಗ್ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚ್ಯಾ ಅದ್ಲೊ ದಿಸ್ ತೊ, ಜೆಜುಕ್ ಅನಿ ಜುವಾಂವ್ ಅಪ್ನಿ ಹ್ಯೊ ಜಗ್ ಸೊಡುನ್ ಬಾಬಾಕ್ಡೆ ಜಾತಲೊ ಎಳ್ ಯೆಲೊ ಮನುನ್ ಗೊತ್ತ್ ಹೊತ್ತೆ, ಹ್ಯಾ ಜಗಾತ್ ಅಪ್ನಾಚೆ ಸ್ವತಾಚೆ ಮನುನ್ ಹೊತ್ತ್ಯಾಂಚೊ ತೆನಿ ಲೈ ಪ್ರೆಮ್ ಕರ್‍ತಲೊ ತೆನಿ ಸೊಡುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ಜೆಜು ಅನಿ ತೆಚಿ ಶಿಸಾ ಸಾಂಚೆ ಜೆವಾನ್ ಕರುಕ್ ಲಾಗಲ್ಲ್ಯಾನಿ. ತನ್ನಾ ಅದ್ದಿಚ್ ಗಿರೊ ಜೆಜುಕ್ ಧರುನ್ ದಿವ್ಚೆ ಮನ್ತಲಿ ಯೆವ್ಜನ್ ಸಿಮಾವ್ ಇಸ್ಕರಿಯೊತಾಚ್ಯಾ ಲೆಕಾಚ್ಯಾ ಜುದಾಸಾಚ್ಯಾ ಮನಾತ್ ಘಾಟಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ಜೆಜುಕ್ ಗೊತ್ತ್ ಹೊತ್ತೆ ಬಾಬಾನ್ ಸಗ್ಳೊ ಅದಿಕಾರ್ ಅಪ್ನಾಕ್ ದಿಲ್ಯಾನಾಯ್, ಅನಿ ಅಪ್ನಿ ದೆವಾಕ್ನಾ ಯೆಲಾ, ಅನಿ ದೆವಾಕ್ಡೆಚ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನ್ತಲೆ ಗೊತ್ತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ತಸೆಮನುನ್ ತೊ ಜೆವ್ನಾಕ್ ಬಸಲ್ಲ್ಯಾಕ್ನಾ ಉಟ್ಲೊ, ಅಪ್ನಾಚಿ ವೈಲಿ ಅಂಗಿ ಕಾಡ್ಲ್ಯಾನ್, ಅನಿ ಕಂಬ್ರೆಕ್ ಎಕ್ ಟಿವಾಲೊ ಭಾಂದುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ಮಾನಾ ಎಕ್ ಮೊಟ್ಯಾ ಅಯ್ದಾನಾತ್ ಪಾನಿ ವೊತುನ್ ಭರುನ್ ಘೆಟ್ಲ್ಯಾನ್. ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚೆ ಪಾಂಯೆ ಧುವ್ಕ್ ಚಾಲು ಕರ್ಲ್ಯಾನ್, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ಕಂಬ್ರೆಕ್ ಭಾಂದುನ್ ಘೆಟಲ್ಲ್ಯಾ ಟಿವಾಲಾನಿ ತೆಂಚೆ ಪಾಂಯೆ ಪುಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ಅಶೆ ತೊ ಸಿಮಾವ್ ಪೆದ್ರುಕ್ಡೆ ಯೆಲೊ, ತನ್ನಾ ಪೆದ್ರುನ್ ಜೆಜುಕ್, “ಧನಿಯಾ, ತಿಯಾ ಮಾಜೆ ಪಾಯ್ ಧುತೆಯ್ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ಕಾಯ್ ಕರುಕ್ ಲಾಗ್ಲಾ ಮನ್ತಲೆ ತುಕಾ ಅತ್ತಾ ಕಳಿನಾ, ಖರೆ ಮಾನಾ ತುಕಾ ಸಗ್ಳೆ ಕಳ್ತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ತನ್ನಾ ಪೆದ್ರುನ್, “ನಾ ಕನ್ನಾಚ್ ಮಾಜೆ ಪಾಯ್ ಧುವ್ಕ್ ಮಿಯಾ ತುಕಾ ಸೊಡಿನಾ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ತುಜೆ ಪಾಯ್ ಧುಯ್‍ನಸ್ಲ್ಯಾರ್, ತುಕಾ ಮಾಜಾಕ್ಡೆ ಕಾಯ್ಬಿ ವಾಟ್ನಿ ನಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ತನ್ನಾ ಸಿಮಾವ್ ಪೆದ್ರುನ್ “ತಸೆ ಹೊಲ್ಯಾರ್ ಧನಿಯಾ ಮಾಜೆ ಪಾಯ್ ಎವ್ಡೆಚ್ ನ್ಹಯ್! ಮಾಜಿ ಹಾತಾ ಅನಿ ಟಕ್ಲೆಬಿ ಧುವ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ತನ್ನಾ ಜೆಜುನ್ “ಪಾನಿ ನ್ಹಲ್ಲೆ ಪವಿತ್ರ್ ಹಾತ್ ತೆಂಚೆ ಪಾಯ್ ಎವ್ಡೆಚ್ ಧುಲ್ಯಾರ್ ಫಿರೆ ಸಗ್ಳೆ ಆಂಗುಚ್ ಧುತಲಿ ಗರಜ್ ನಾ. ಎಕ್ಲ್ಯಾಕ್ ಸೊಡುನ್ ತುಮಿ ಸಗ್ಳೆ ಜಾನಾ ಪವಿತ್ರ್ ಹಾಸಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ಅಪ್ನಾಕ್ ಧರುನ್ ದಿತಲೊ ಕೊನ್ ಮನುನ್ ಜೆಜುಕ್ ಗೊತ್ತ್ ಹೊತ್ತೆ, ತಸೆಮನುನ್ ತೆನಿ, “ತುಮ್ಚ್ಯಾತ್ಲೊ ಎಕ್ಲೊ ಸೊಡುನ್ ತುಮಿ ಸಗ್ಳೆ ಜಾನಾ ಪವಿತ್ರ್ ನಾಶಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ತೆಂಚೆ ಪಾಂಯೆ ಧುವ್ನ್ ಸರಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜುನ್ ಅಪ್ನಾಚಿ ವೈಲಿ ಅಂಗಿ ಅನಿ ಪರ್ತುನ್ ನೆಸ್ಲ್ಯಾನ್. ಅನಿ ಅಪ್ನಿ ಬಸಲ್ಲ್ಯಾ ಜಾಗ್ಯಾವರ್ತಿ ಜಾವ್ನ್ ತೊ ಬಸ್ಲೊ. ಅನಿ “ಅತ್ತಾ ಮಿಯಾ ಕಾಯ್ ಕರ್‍ಲೊ ಮನುನ್ ತುಮ್ಕಾ ಕಳ್ಳೆ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ತುಮಿ ಮಾಕಾ ಗುರುಜಿ ಅನಿ ಧನಿ ಮನುನ್ ಬಲ್ವುತ್ಯಾಶಿ. ಅನಿ ತುಮಿ ಬಲ್ವುತಲೆ ಸಮಾ ಹಾಯ್, ಮಿಯಾಚ್ ಹೊ. ");
INSERT INTO kans_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ಹೆಚ್ಯಾ ಸಾಟ್ನಿ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ಗುರುಜಿನ್ ಅನಿ ಧನಿಯಾನ್ ತುಮ್ಚೆ ಪಾಂಯೆ ಧುಲೊ, ತಸೆಚ್ ತುಮಿಬಿ ಎಕಾಮೆಕಾಚೆ ಪಾಂಯೆ ಧುವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ಮಿಯಾ ತುಮ್ಕಾ ಎಕ್ ಉದಾರನ್ ಕರುನ್ ದಾಕ್ವುಲೊ, ತುಮಿಬಿ ತಸೆಚ್ ಕರುಚೆ ಮನುನ್ ಮಿಯಾ ಹೆ ಕರುನ್ ದಾಕ್ವುಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗ್ತಾ, ಆಳಾ ತೆಂಚ್ಯಾ ಧನಿಯಾಂಚ್ಯಾನ್ಕಿ ಮೊಟಿ ನ್ಹಯ್, ಅನಿ ಬಾತ್ಮಿ ಸಾಂಗ್ನಾರೆ ತೆಂಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಚ್ಯಾನ್ಕಿ ಮೊಟೆ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ಖರೆ ಅತ್ತಾ ತುಮ್ಕಾ ಹೆ ಖರೆ ಗೊತ್ತ್ ಹೊಲೆ ಹ್ಯಾಚ್ ಖರೆಪಾನಾತ್ ತುಮಿ ಚಲ್ಲ್ಯಾರ್, ತುಮ್ಚೆ ಕವ್ಡೆ ಬರೆ! ");
INSERT INTO kans_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ಮಿಯಾ ತುಮ್ಚ್ಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾಚ್ ವಿಶಯಾತ್ ಬೊಲಿನಾ ಹೊಲಾ, ಮಿಯಾ ಎಚುನ್ ಕಾಡಲ್ಲ್ಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಖರೆ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಎಕುಚ್ ಭಾನ್ಯಾತ್ ಜೆವಲ್ಲೊ ಮಾಜೆ ವರ್ತಿ ಪರತ್ತಾ ” ಮನುನ್ ಲಿವಲ್ಲೆ ಖರೆ ಹೊವ್ಕ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ಸಗ್ಳೆ ಘಡುಚ್ಯಾ ಅದ್ದಿಚ್ ಹೆ ಸಗ್ಳೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಹೆ ಘಡಲ್ಲ್ಯಾ ತನ್ನಾ, ಮನುನ್ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರುಚೆ ಮಿಯಾಚ್ ತೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ “ಜೊ ಕೊನ್ ಮಿಯಾ ಧಾಡ್ವಲ್ಲ್ಯಾಕ್, ಸ್ವಿಕಾರ್ ಘೆತಾ, ತೊ ಮಾಕಾಚ್ ಸ್ವಿಕಾರ್ ಕರ್‍ತಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ಹೆ ಸಗ್ಳೆ ಸಾಂಗುನ್ ಸರಲ್ಲ್ಯಾ ಮಾನಾ, ಜೆಜು ದುಕಾನಿ ಭರಲ್ಲೊ ತನ್ನಾ ತೆನಿ “ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಹೊತ್ತೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ತುಮ್ಚ್ಯಾತ್ಲೊ ಎಕ್ಲೊ ಮಾಕಾ ಘಾತ್‍ ಕರುನ್ ಧರುನ್ ದಿನಾರ್ ಹಾಯ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ತನ್ನಾ ಶಿಸಾ ಎಕಾಮೆಕಾಕ್ನಿ ಬಗುಕ್ ಪಡ್ಲಿ ಅನಿ ಕೊನ್ ಅಶಿಲ್ ತೊ ಮನ್ತಲ್ಯಾ ಗೊಂದಳಾತ್ ಪಡ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ಶಿಸಾನಿತ್ಲೊ ಎಕ್ಲೊ, ಜೆಜುಚ್ಯಾ ಪ್ರೆಮಾಚೊ ಶಿಸ್ ಜೆಜುಕ್ ಲಾಗುನ್ ಬಸಲ್ಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ಸಿಮಾವ್ ಪೆದ್ರುನ್ ತ್ಯಾ ಶಿಸಾಕ್, “ತೊ ಕೊನಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲಾ ಮನುನ್ ಇಚಾರ್” ಮನುನ್ ಸೊನ್ನಿ ಕರುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ತಸೆಮನುನ್ ತೊ ಶಿಸ್ ಜೆಜುಚ್ಯಾ ಜಗ್ಗೊಳ್ ಬಾಗ್ಲೊ ಅನಿ,“ಧನಿಯಾ ಕೊನ್ ತೊ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ತನ್ನಾ ಜೆಜುನ್ “ಮಿಯಾ ಭಾಕ್ರಿಚೊ ತುಕ್ಡೊ ಘೆಟ್ಲ್ಯಾನ್ ಆಯ್ದಾನಾತ್ ಬುಡ್ವುನ್ ಕೊನಾಕ್ ದಿತಾ ಬಗ್ ತೊಚ್ ತೊ” ಮಟ್ಲ್ಯಾನ್, ತನ್ನಾ ಜೆಜುನ್ ಎಕ್ ಭಾಕ್ರಿಚೊ ತುಕ್ಡೊ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ಅಯ್ದಾನಾತ್ ಬುಡ್ವುನ್ ಸಿಮಾವ್ ಇಸ್ಕರಿಯೊತಾಚ್ಯಾ ಲೆಕಾಕ್ ಜುದಾಸಾಕ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ಜೆಜುನ್ ದಿಲ್ಲೊ ಭಾಕ್ರಿಚೊ ತುಕ್ಡೊ ಘೆಟಲ್ಲ್ಯಾ ತನ್ನಾಚ್ ಜುದಾಸಾಚ್ಯಾ ಮನಾತ್ ಸೈತಾನ್ ಗುಸ್ಲೊ, ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ತಿಯಾ ಕಾಯ್ ಕರ್‍ತಲೆ ಹಾಯ್ ತೆ ಲಗ್ಗುಲಗ್ಗುನಾ ಕರ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ಜಾಲ್ಯಾರ್, ಜೆಜುನ್ ಅಶೆ ಕಶ್ಯಾಕ್ ತೆಕಾ ಸಾಂಗಟ್ಲ್ಯಾನ್ ಮನುನ್ ಥೈ ಜೆವ್ನಾಕ್ ಬಸಲ್ಲ್ಯಾನಿತ್ಲ್ಯಾ ಕೊನಾಕ್ಬಿ ಕಳುಕ್‍ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ತೆಂಚೆಕ್ಡೆ ಹೊತ್ತ್ಯಾ ಪೈಶಾಂಚಿ ಜವಾಬ್ದಾರಿ ಜುದಾಸ್ ಬಗುನ್ ಘೆಯ್, ತಸೆಮನುನ್ ಉಲ್ಲ್ಯಾ ಶಿಸಾನಿ ಸನಾಕ್ ಪಾಜೆ ಹೊಲ್ಲೆ ಸಗ್ಳೆ ಹಾನ್, ನಾಹೊಲ್ಯಾರ್ ಕಾಯ್ಬಿ ಇಕಾತ್ ಹಾನುನ್ ಗರಿಬಾಕ್ನಿ ದಿವ್ಕ್ ಮನುನ್ ಜೆಜು ಜುದಾಸಾಕ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಚಿಂತ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ತಿ ಭಾಕ್ರಿ ಘೆಟಲ್ಲ್ಯಾ ತನ್ನಾಚ್ ತಾಬೊಡ್ತೊಬ್ ಜುದಾಸ್ ಥೈತ್ನಾ ಭಾಯ್ರ್ ಗೆಲೊ, ತನ್ನಾ ರಾತ್ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ಜುದಾಸ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುನ್, “ಅತ್ತಾ ಮಾನ್ಸಾಚ್ಯಾ ಲೆಕಾಚಿ ಮಹಿಮಾ ದಿಸುಕ್ ಲಾಗ್ಲಾ, ಅನಿ ತ್ಯೆಚ್ಯಾ ವೈನಾ ದೆವಾಚಿಚ್ ಮಹಿಮಾ ದಿಸುನ್ ಯೆತಾ” ");
INSERT INTO kans_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ದೆವಾಚಿ ಮಹಿಮಾ ತೆಚೆ ವೈನಾ ದಿಸುನ್ ಯೆತಾ ಹೊಲ್ಯಾರ್ ದೆವ್ ಅಪ್ನಿಚ್ ಮಾನ್ಸಾಚ್ಯಾಲೆಕಾಚಿ ಮಹಿಮಾ ತ್ಯೆಚ್ಯಾ ಭುತ್ತುರ್ ಧಾಕ್ವುನ್ ದಿತಾ. ಅನಿ ಹೆ ತಾಬೊಡ್ತೊಬ್ ತೊ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ಮಾಜ್ಯಾ ಪೊರಾನೊ, ಮಿಯಾ ಅನಿ ಲೈ ಎಳ್ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಯ್ನಾ ತುಮಿ ಮಾಜಿ ವಾಟ್ ಬಗುನ್ಗೆತ್ ರ್‍ಹಾತ್ಯಾಶಿ, ಖರೆ ಅತ್ತಾ ಮಿಯಾ ತುಮ್ಕಾ ಜುದೆವಾಚ್ಯಾ ಫುಡಾರ್‍ಯಾಕ್ನಿ ಸಾಂಗಲ್ಲೆಚ್ ಸಾಂಗ್ತಾ ಮಿಯಾ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಥೈ ತುಮ್ಚ್ಯಾನ್ ಜಾವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ಅನಿ ಅತ್ತಾ ಮಿಯಾ ತುಮ್ಕಾ ಎಕ್ ನ್ಹವೊ ಖಾಯ್ದೊ ದಿತಾ, ಮಿಯಾ ಕಸೊ ತುಮ್ಚೊ ಪ್ರೆಮ್ ಕರ್‍ಲೊ. ತಸೆ ತುಮಿ ಎಕಾಮೆಕಾಚೊ ಪ್ರೆಮ್ ಕರಾ, ತುಮಿ ಎಕಾಮೆಕಾಚೊ ಪ್ರೆಮ್ ಕರುಕುಚ್ ಪಾಜೆ ಮನುನುಚ್ ಮಿಯಾ ತಸೆ ಕರ್‍ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ಎಕಾ ಎಳಾರ್ ತುಮಿ ಎಕಾಮೆಕಾಚೊ ಪ್ರೆಮ್ ಕರ್ಲ್ಯಾಶಿ ತರ್, ತುಮಿ ಮಾಜಿ ಶಿಸಾ ಮನುನ್ ಸಗ್ಳ್ಯಾಕ್ನಿ ಕಳ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ಸಿಮಾವ್ ಪೆದ್ರುನ್,“ಧನಿಯಾ ತಿಯಾ ಖೈ ಜಾವ್ಲೆಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್, ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಥೈ ತುಕಾ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆವ್ಕ್ ಹೊಯ್ನಾ”, “ಖರೆ ಮಾನಾ ತಿಯಾ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆತೆಯ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ತನ್ನಾ ಪೆದ್ರುನ್ “ಧನಿಯಾ ಕಶ್ಯಾಕ್ ಮಿಯಾ ತುಜ್ಯಾ ಫಾಟ್ನಾ ಯೆವ್ಕ್ ಹೊಯ್ನಾ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್, ಅನಿ “ಮಿಯಾ ತುಜ್ಯಾಸಾಟಿ ಮರುಕ್ ಸೈತ್ ತಯಾರ್ ಹಾಂವ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ, ತಿಯಾ ಖರೆಚ್! ಮಾಜೆಸಾಟಿ ಮರುಕ್ ತಯಾರ್ ಹಾಸ್ ಕಾಯ್? ಮಿಯಾ ತುಕಾ ಖರೆ ಹೊತ್ತೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ಕೊಂಬೊ ಭೊಕುಚ್ಯಾ ಅದ್ದಿ ತಿಯಾ ತಿನ್ದಾ ತುಕಾ ಮಾಜಿ ವಳಕುಚ್ ನಾ ಮನುನ್ ಸಾಂಗ್ತೆಯ್, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ಜೆಜುನ್ ತೆಂಕಾ, “ತುಮಿ ಭಿಂವ್ನಕಾಶಿ ಅನಿ ಬೆಜಾರ್ ಹೊವ್‍ನಕಾಶಿ ದೆವಾಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಾ ಅನಿ ಮಾಜೆ ವರ್‍ತಿಬಿ ವಿಶ್ವಾಸ್ ಕರಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","“ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ಘರಾತ್ ಲೈ ಖೊಲಿಯಾ ಹಾತ್, ಅನಿ ಮಿಯಾ ತುಮ್ಚ್ಯಾಸಾಟ್ನಿ ಜಾಗೊ ತಯಾರ್ ಕರುಕ್ ಮನುನ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ, ನಾಹೊಲ್ಯಾರ್ ಹೆ ಸಗ್ಳೆ ಮಿಯಾ ಸಾಂಗಿನಸಿ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ಮಿಯಾ ಜಾವ್ನ್ ಜಾಗೊ ತಯಾರ್ ಕರುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಮಿಯಾ ಪರ್ತುನ್ ಯೆತಾ ಅನಿ ತುಮ್ಕಾ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಘೆವ್ನ್ ಜಾತಾ. ಅಶೆ ಮಿಯಾ ಖೈ ರ್‍ಹಾತಾ ಥೈಚ್ ತುಮಿಬಿ ರ್‍ಹಾತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ಮಿಯಾ ಖೈ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಥೈ ಜಾತಾಲಿ ವಾಟ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ತನ್ನಾ ಥೊಮಸಾನ್ ತೆಕಾ “ಧನಿಯಾ ತಿಯಾ ಖೈ ಜಾವ್ಲೆ ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ನಾ? ತಸೆ ಹೊಲ್ಯಾರ್ ಅಮ್ಕಾ ಥೈ ಜಾತಲಿ ವಾಟ್ ಕಶಿ ಕಳ್ನಾರ್?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ “ಮಿಯಾಚ್ ವಾಟ್, ಖರೆ, ಅನಿ ಜಿವ್, ಮಾಜೆಕ್ನಾ ಹೊವ್ನ್ ಗೆಲ್ಯಾ ಶಿವಾಯ್ ಕೊನಾಕ್ಬಿ ಬಾಬಾಕ್ಡೆ ಯೆವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ಎಕ್ ಎಳಾರ್ ತುಮಿ ಮಾಕಾ ವಳಕ್ತ್ಯಾಶಿ, ಅನಿ ಅತ್ತಾಚ್ಯಾನ್ ತುಮಿ ತೆಕಾಬಿ ಬರೆ ಕರುನ್‍ ವಳಕ್ತ್ಯಾಶಿ ಅನಿ ಬಗಟ್ಲ್ಯಾಶಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ತನ್ನಾ ಫಿಲಿಪಾನ್ ತೆಕಾ, “ಧನಿಯಾ ಅಮ್ಕಾ ಬಾಬಾ ದಾಕ್ವು! ಅಮ್ಕಾ ತವ್ಡೆ ಪಾಜೆ ಹೊಲ್ಲೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ಜೆಜುನ್ ತೆಕಾ ಜಬಾಬ್ ದಿಲ್ಲ್ಯಾನ್ ಎವ್ಡಿ ಲೈ ದಿಸಾ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಲೊ, ಫಿಲಿಪಾ ತಿಯಾ ಅಜುನ್‍ಬಿ ಮಾಕಾ ವಳ್ಕುಕ್ ನೆ? ಜೆ ಕೊನ್ ಮಾಕಾ ಬಗಟ್ಲಾ, ತೆನಿ ಬಾಬಾಕ್ ಬಗಟ್ಲಾ, ಅಶೆ ರ್‍ಹಾತಾನಾ ತಿಯಾ ಅಮ್ಕಾ ಬಾಬಾಕ್ ದಾಕ್ವು? ಮನುನ್ ಕಶೆ ಇಚಾರುಕ್ ಹೊತಾ, ");
INSERT INTO kans_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ಫಿಲಿಪಾ, ಮಿಯಾ ಬಾಬಾಚ್ಯಾ ಭುತ್ತುರ್ ಅನಿ ಬಾಬಾ ಮಾಜ್ಯಾ ಭುತ್ತುರ್ ಹಾಯ್ ಮನುನ್ ತುಕಾ ವಿಶ್ವಾಸ್ ನಾ ಕಾಯ್? ಮಟ್ಲ್ಯಾನ್. ಮಾನಾ ಜೆಜುನ್ ಶಿಸಾಕ್ನಿ, ಮಿಯಾ ತುಮ್ಚ್ಯಾಕ್ಡೆ ಬೊಲಲ್ಲ್ಯಾ ಗೊಸ್ಟಿಯಾ ಮಾಜ್ಯಾ ಭುತ್ತುರ್‍ನಾಚ್ ಯೆವ್ಕನಾತ್, ಮಾಜ್ಯಾ ಭುತ್ತುರ್ ಹೊತ್ತೊ ಮಾಜೊ ಬಾಬಾ ಸ್ವತಾ ಅಪ್ನಾಚೆ ಕಾಮ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ಬಾಬಾ ಮಾಜ್ಯಾ ಭುತ್ತುರ್ ಅನಿ ಮಿಯಾ ಬಾಬಾಚ್ಯಾ ಭುತ್ತುರ್ ಹಾಯ್ ಮನುನ್ ಮಿಯಾ ಸಾಂಗ್ತಾನಾ ಮಾಜೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಾ, ನಾಹೊಲ್ಯಾರ್, ಮಿಯಾ ಕರ್‍ತಲಿ ಕಾಮಾ ಸಾಕ್ಷಿ ಸಾಟ್ನಿ ಅಜಾಪಾ ಬಗುನ್ ತರ್ಬಿ ವಿಶ್ವಾಸ್ ಕರಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಹೊತ್ತೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ಜೆ ಕೊನ್ ಮಾಜೆ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾತ್ ತೆನಿ ಮಿಯಾ ಕರಲ್ಲಿ ಕಾಮಾ ಕರ್‍ತಾತ್, ತೆನಿ ತ್ಯೆಚೆನ್ಬಿ ಮೊಟಿ ಕಾಮಾ ಕರ್‍ತಾತ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಬಾಬಾಕ್ಡೆ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ಅನಿ ಮಿಯಾ ತುಮಿ ಮಾಜ್ಯಾ ನಾವಾನ್ ಕಾಯ್ ಮಾಗ್ತ್ಯಾಶಿ ತೆ ಸಗ್ಳೆ ಕರ್‍ತಾ. ಅಶೆ ಲೆಕ್ ಬಾಬಾಚಿ ಮಹಿಮಾ ವೈನಾ ದಾಕ್ವುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ಮಾಜ್ಯಾ ನಾವಾನ್ ತುಮಿ ಕಾಯ್‍ ಮಾಗಟ್ಲ್ಯಾರ್‍ಬಿ ಮಿಯಾ ತೆ ಕರುನ್ ದಿತಾ. ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ತುಮಿ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ತ್ಯಾಶಿ ಹೊಲ್ಯಾರ್, ತರ್ ಮಿಯಾ ದಿಲ್ಲೆ ಖಾಯ್ದೆ ತುಮಿ ಪಾಳ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ಡೆ ಇಚಾರುನ್ ಎಕ್ ಮಜತ್ ಕರ್‍ತಲ್ಯಾಕ್ ಧಾಡುನ್ ದಿತಾ, ತೊ ಸದಾ ಸರ್ವತಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾಚ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ತೊ ಎಕ್ ಆತ್ಮೊ ತೊ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಖರೆ ದಾಕ್ವುನ್ ದಿತಾ. ಹ್ಯೊ ಜಗ್ ತೆಕಾ ಸ್ವಿಕಾರ್ ಕರಿನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಹ್ಯೊ ಜಗ್ ತೆಕಾ ವಳ್ಕಿನಾ, ತೊ ತೆಕಾ ದಿಸಿನಾ. ಖರೆ ತುಮಿ ತೆಕಾ ವಳಕ್ತ್ಯಾಶಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಿವನ್ ಕರ್‍ತಾ ಅನಿ ತುಮ್ಚ್ಯಾ ಭುತ್ತುರ್ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ಮಿಯಾ ಜಾತಾನಾ ತುಮ್ಕಾ ಅನಾಥ್ ಸರ್ಕೆ ಕರುನ್ ಸೊಡುನ್ ಜಾಯ್ನಾ, ಮಿಯಾ ಅನಿ ಪರ್ತುನ್ ತುಮ್ಚ್ಯಾಕ್ಡೆ ಯೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ಅನಿ ಎಕ್ ಉಲ್ಲ್ಯಾಶ್ಯಾ ಎಳಾನ್ ಹ್ಯೊ ಜಗ್ ಮಾಕಾ ಬಗಿನಾ. ಖರೆ ತುಮಿ ಮಾಕಾ ಬಗ್ತ್ಯಾಶಿ. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಝಿತ್ತೊ ರ್‍ಹಾತಾ ಅನಿ ತುಮಿಬಿ ಝಿತ್ತೆ ರ್‍ಹಾತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ತೊ ದಿಸ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಕಶೆ ಅತ್ತಾ ಮಿಯಾ ಬಾಬಾಚ್ಯಾ ಭುತ್ತುರ್ ಹಾಂವ್ ಅನಿ ತುಮಿ ಮಾಜ್ಯಾ ಭುತ್ತುರ್ ಹಾಶಿ, ಮನುನ್ ತುಮ್ಕಾ ಕಳ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ಜೆ ಕೊನ್ ಮಿಯಾ ದಿಲ್ಲೆ ಖಾಯ್ದೆ ಮಾನುನ್ ಘೆತಾ ಅನಿ ತೆಂಚ್ಯಾ ಸರ್ಕೆ ಚಲ್ತಾ ತೊ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ. ಜೆ ಕೊನ್ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ತೆಂಚೊ ಮಾಜೊ ಬಾಬಾ ಪ್ರೆಮ್ ಕರ್‍ತಾ, ಮಿಯಾಬಿ ತೆಂಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ಅನಿ ಮಾಕಾಚ್ ಮಿಯಾ ತೆಂಕಾ ದಾಕ್ವುನ್ ದಿತಾ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ತನ್ನಾ ಜುದಾಸಾನ್, ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತ್ ನ್ಹಯ್, “ಧನಿಯಾ ತಿಯಾ ಅಮ್ಕಾ ಎವ್ಡೆಚ್ ತುಕಾ ದಾಕ್ವುನ್ ದಿ ಅನಿ ಜಗಾಕ್ ದಾಕ್ವುನ್ ದಿನೆಯ್ ಕಶ್ಯಾಕ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ, “ಜೆ ಕೊನ್ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ತೊ ಮಿಯಾ ಕಾಯ್ ಶಿಕ್ವುತಾ ತೆ ಮಾನುನ್ ಘೆತಾ. ಮಾಜೊ ಬಾಬಾ ತೆಂಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ಅನಿ ಮಿಯಾ ಅನಿ ಮಾಜೊ ಬಾಬಾ ದೊಗೆಬಿ ತೆಂಚ್ಯಾಕ್ಡೆ ಯೆತಾಂವ್ ಅನಿ ತೆಂಚ್ಯಾ ಮದ್ದಿ ರ್‍ಹಾತಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ಜೆ ಕೊನ್ ಮಿಯಾ ಶಿಕ್ವಲ್ಲೆ ಶಿಕಾಪ್ ಮಾನುನ್ ಘೆಯ್‍ನ್ಯಾತ್, ತೆನಿ ಮಾಜೊ ಪ್ರೆಮ್ ಕರಿನ್ಯಾತ್, ತುಮಿ ಆಯ್ಕುಲ್ಯಾಶಿ ಹಿ ಶಿಕಾಪಾ ಮಾಜಿ ಸ್ವತಾಚಿ ನ್ಹಯ್, ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾ ಬಾಬಾಚಿ”. ");
INSERT INTO kans_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾತಾನಾಚ್ ತುಮ್ಕಾ ಮಿಯಾ ಹೆ ಸಗ್ಳೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ");
INSERT INTO kans_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ಮಾಜ್ಯಾ ನಾವಾನ್ ಬಾಬಾನ್ ಧಾಡುನ್ ದಿಲ್ಲೊ ಮಜತ್ ಕರ್‍ತಲೊ ಪವಿತ್ರ್ ಆತ್ಮೊ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗಲ್ಲೆ ಸಗ್ಳೆ ಯಾದ್ ಕರುನ್ ದಿತಾ ಅನಿ ತುಮ್ಕಾ ಸಗ್ಳೆ ಶಿಕ್ವುತಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ಶಾಂತಿ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ಮಿಯಾ ಸೊಡುನ್ ಜಾತಾ, ಹಿ ಮಾಜಿ ಸ್ವತಾಚಿ ಶಾಂತಿ ಮಿಯಾ ತುಮ್ಕಾ ದಿತಾ. ಹ್ಯಾ ಜಗಾನ್ ದಿಲ್ಲ್ಯಾ ಸರ್ಕೆ ಮಿಯಾ ತಿ ತುಮ್ಕಾ ದಿ ನಾ. ಚಿಂತಾ ಕರುನಕಾಶಿ ಅನಿ ತುಮ್ಚಿ ಮನಾ ತಳ್ಮಳಿ ನಸ್ತಾನಾ ರ್‍ಹಾಂವ್ದಿ ಅನಿ ಭಿಂವ್ನಕಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ಮಿಯಾ ತುಮ್ಕಾ ಸೊಡುನ್ ಜಾತಾ ಮನುನ್ ಸಾಂಗಲ್ಲೆ ತುಮಿ ಆಯಿಕ್ಲ್ಯಾಶಿ, ಖರೆ ಮಿಯಾ ಅನಿ ಪರ್ತುನ್ ಯೆತಾ. ತುಮಿ ಮಾಜೆ ಪ್ರೆಮ್ ಕರ್‍ತ್ಯಾಶಿ ಹೊಲ್ಯಾರ್ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ಡೆ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನ್ತಾನಾ ತುಮ್ಕಾ ಕುಶಿ ಹೊವ್ಕ್ ಪಾಜೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಮಾಜ್ಯಾನ್ಕಿ ಮೊಟೊ. ");
INSERT INTO kans_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ಅಶೆ ಹೆ ಸಗ್ಳೆ ಘಡುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರುಚೆ ಮನುನ್ ಹೆ ಸಗ್ಳೆ ಘಡುಚ್ಯಾ ಅದ್ದಿಚ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗಟ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ಲೈ ಎಳ್ ಮಿಯಾ ತುಮ್ಚ್ಯಾಕ್ಡೆ ಬೊಲಿನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಹ್ಯಾ ಜಗಾಚೊ ಅದಿಕಾರಿ ಯೆವ್‍ಲಾಲಾ, ಮಾಜೆ ವರ್ತಿ ತೆಕಾ ಕಸ್ಲೊಬಿ ಅದಿಕಾರ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ಮಿಯಾ ಬಾಬಾಚೊ ಕವ್ಡೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ಖರೆ ಹ್ಯಾ ಜಗಾಕ್ ಕಳುಕ್ ಪಾಜೆ; ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ತೆನಿ ಮಾಕಾ ಕಾಯ್ ಸಾಂಗ್ಲ್ಯಾನಾಯ್ ತೆ ಸಗ್ಳೆ ಕರುಲಾಲಾ. ಚಲಾ ಅಮಿ ಹಿತ್ನಾ ಜಾಂವ್ವಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ಮಿಯಾ ಖರಿ ದ್ರಾಕ್ಷಿಚಿ ಯೆಲ್, ಮಾಜೊ ಬಾಬಾ ದ್ರಾಕ್ಷಿಚ್ಯಾ ಮ್ಹಳ್ಯಾಚೊ ಮಾಲಿಕ್. ");
INSERT INTO kans_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ತೊ ಮಾಕಾ ಲಾಗುನ್ ಹೊತ್ತ್ಯಾ ಫಳಾ ದಿ ನಸಲ್ಲ್ಯಾ ಫಾಟೆ ತೊಡ್ತಾ ಅನಿ ಫಳ್ ದಿತಲ್ಯಾ ಫಾಟೆ ಅನಿ ಉಲ್ಲೆ ಫಳ್ ದಿವಸಾಟ್ನಿ ಮನುನ್ ಮಾಳ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ತುಮಿ ತರ್ ಮಿಯಾ ಶಿಕ್ವಲ್ಲ್ಯಾ ಶಿಕಾಪಾ ವೈನಾ ಮಾಳ್ ಕರಲ್ಲ್ಯಾ ಫಾಟ್ಯಾಂಚ್ಯಾ ಸರ್ಕೆ ಹೊಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ತುಮಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾವಾ ಅನಿ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾತಾ. ಖಲ್ಯಾಬಿ ಎಕ್ ಫಾಟ್ಯಾನ್ ಯೆಲಿಚ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾಲ್ಯಾ ಶಿವಾಯ್ ಫಳಾ ದಿವ್ಕ್ ಹೊಯ್ನಾ. ತಶೆಚ್ ತುಮಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾಲ್ಯಾ ಶಿವಾಯ್ ತುಮಿ ಫಳ್ ದಿವ್ಕ್ ಹೊಯ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ಮಿಯಾ ದ್ರಾಕ್ಷಿಚಿ ಯೆಲ್ ತುಮಿ ತೆ ಫಾಟೆ. ಜೊ ಕೊನ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾತಾ ಅನಿ ಮಿಯಾ ತ್ಯೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾತಾ ತೊ ಜಾಸ್ತಿಚಿ ಫಳ್ ದಿತಾ, ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಯಾ ನಸ್ತಾನಾ ತುಮಿ ಕಾಯ್ ಬಿ ಕರುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ಜೊ ಕೊನ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾಯ್ನಾ; ತೊ ಕಾತ್ರುನ್ ಕಾಡಲ್ಲ್ಯಾ ಫಾಟ್ಯಾ ಸರ್ಕೊ, ತೊ ಫಾಟೊ ವಾಳುನ್ ಜಾತಾ, ತಸ್ಲೆ ಫಾಟೆ ಗೊಳಾ ಕರುನ್ ಜಾಳ್ವುತಾತ್ ಮನುನ್ ಆಗಿತ್ ಟಾಕ್ತಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ತುಮಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಲ್ಯಾರ್ ಅನಿ ಮಾಜ್ಯಾ ಗೊಸ್ಟಿಯಾ ತುಮ್ಚ್ಯಾ ಭುತ್ತುರ್ ರ್‍ಹಾಲ್ಯಾರ್ ತುಮಿ ತುಮ್ಕಾ ಕಾಯ್ ಪಾಜೆ ತೆ ಮಾಗಾ ತೆ ತುಮ್ಕಾ ಗಾವ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ತುಮಿ ಜಾಸ್ತಿಚಿ ಫಳಾ ದಿಲ್ಲ್ಯಾ ವೈನಾ ಮಾಜ್ಯಾ ಬಾಬಾಚಿ ಮಹಿಮಾ ದಾಕ್ವುನ್ ದಿಲ್ಯಾಶಿ, ಅನಿ ಅಶೆಚ್ ತುಮಿ ಮಾಜಿ ಶಿಸಾ ಹೊಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ಕಸೊ ಮಾಜೊ ಬಾಬಾ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ತಸೊ ಮಿಯಾ ತುಮ್ಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ, ತುಮಿ ಮಾಜ್ಯಾ ಪ್ರೆಮಾನ್ ರ್‍ಹಾವಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ಕಶೆ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ಗೊಸ್ಟಿಕ್ ಖಾಲ್ತಿ ಹೊವ್ನ್ ತೆಚ್ಯಾ ಪ್ರೆಮಾನ್ ಹಾಂವ್, ತಶೆ ತುಮಿ ಮಾಜ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯಿಕ್ಲ್ಯಾರ್, ಮಾಜ್ಯಾ ಪ್ರೆಮಾತ್ ರ್‍ಹಾತ್ಯಾಶಿ”. ");
INSERT INTO kans_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ಮಾಜೊ ಕುಶಿ ತುಮ್ಚ್ಯಾ ಮದ್ದಿ ರ್‍ಹಾವ್ನ್ ತುಮ್ಚೊ ಖುಶಿ ಪುರಾ ಹೊಂವ್ದಿ ಮನುನ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ಹ್ಯೊ ಮಾಜೊ ಖಾಯ್ದೊ, ಕಶೆ ಮಿಯಾ ತುಮ್ಚೊ ಪ್ರೆಮ್ ಕರ್‍ಲೊ ತಶೆ ತುಮಿಬಿ ಎಕಾಮೆಕಾಚೊ ಪ್ರೆಮ್ ಕರಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ಅಪ್ನಾಚ್ಯಾ ದೊಸ್ತಾಸಾಟ್ನಿ ಜಿವ್ ದಿತಲ್ಯಾಚ್ಯಾನ್ಕಿಬಿ ಮೊಟೊ ಪ್ರೆಮ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ಮಿಯಾ ತುಮ್ಕಾ ದಿಲ್ಲ್ಯಾ ಖಾಯ್ದೊ ಸಾಂಗಟಲ್ಲೆ ಕರ್ಲ್ಯಾಶಿ ತರ್ ತುಮಿ ಮಾಜಿ ದೊಸ್ತಾ . ");
INSERT INTO kans_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ಅನಿ ಫಿಡೆ ಮಿಯಾ ತುಮ್ಕಾ ಸೆವಕ್ ಮನುನ್ ಬಲ್ವಿನಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಸೆವಕಾಕ್ ತೆಚೊ ಧನಿ ಕಾಯ್ ಕರ್‍ತಾ ಮನ್ತಲೆ ಗೊತ್ತ್ ರ್‍ಹಾಯ್ನಾ. ಹೆಚ್ಯಾ ಬದ್ಲಾಕ್, ಮಿಯಾ ತುಮ್ಕಾ ದೊಸ್ತಾ ಮನುನ್ ಬಲ್ವುತಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ನಾ ಆಯ್ಕಲ್ಲೆ ಸಗ್ಳೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗಟ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ತುಮಿ ಮಾಕಾ ಎಚುನ್ ಕಾಡುಕ್ನ್ಯಾಶಿ, ಮಿಯಾ ತುಮ್ಕಾ ಎಚುನ್ ಕಾಡ್ಲಾ ಅನಿ ಜಾಸ್ತಿಚಿ ಫಳಾ ದಿವ್ ಸಾಟ್ನಿ ಮನುನ್ ನೆಮ್ಲಾ, ಹುರ್‍ತಲಿ ಫಳಾ ದಿವ್‍ಸಾಟ್ನಿ ನೆಮ್ಲಾ. ಅಶೆಚ್ ಮಾಜ್ಯಾ ನಾವಾನ್ ಬಾಬಾಕ್ಡೆನ್ ತುಮಿ ಮಾಗ್ತ್ಯಾಶಿ ತೆ ಸಗ್ಳೆ ತೊ ತುಮ್ಕಾ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಲಿ ಹುಕುಮ್ ಹಿ ತುಮಿ ಎಕಾಮೆಕಾಚೊ ಪ್ರೆಮ್ ಕರಾ”. ");
INSERT INTO kans_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ಹ್ಯಾ ಜಗಾನ್ ತುಮ್ಚೊ ದ್ವೆಸ್ ಕರ್ಲ್ಯಾರ್ ತೆನಿ ತುಮ್ಚ್ಯಾನ್ಕಿ ಅದ್ದಿ ತೆನಿ ಮಾಜೊ ದ್ವೆಸ್ ಕರ್‍ಲಾ ಮನುನ್ ಯಾದ್ ಕರಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ತುಮಿ ಜಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೆ ಮನುನ್ ರ್‍ಹಾಲ್ಯಾರ್ ತೊ ತುಮಿ ತೆಚೆಚ್ ಮನುನ್ ತುಮ್ಚೊ ಪ್ರೆಮ್ ಕರಿ ಹೊತ್ತೊ. ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಹ್ಯಾ ಜಗಾತ್ನಾ ಎಚುನ್ ಕಾಡ್ಲಾ, ಅನಿ ತುಮಿ ಹ್ಯಾ ಜಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೆ ನ್ಹಯ್ ,ತೆಚೆಸಾಟ್ನಿ ಹ್ಯೊ ಜಗ್ ತುಮ್ಚೊ ದ್ವೆಸ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗಲ್ಲೆ ಯಾದ್ ಥವ್ನ್ ಘೆವಾ ಆಳ್ ಅಪ್ನಾಚ್ಯಾ ಧನಿಯಾಚ್ಯಾನ್ಕಿಬಿ ಮೊಟೊ ನ್ಹಯ್ ಜರ್ ತರ್ ಲೊಕಾ ಮಾಕಾ ತರಾಸ್ ದಿತ್ಯಾತ್ , ತರ್ ಲೊಕಾ ತುಮ್ಕಾಬಿ ತರಾಸ್ ದಿತ್ಯಾತುಚ್, ತೆನಿ ಮಾಜ್ಯಾ ಶಿಕಾಪಾಕ್ ಖಾಲ್ತಿ ಹೊಲ್ಯಾನಿತರ್, ತುಮ್ಚ್ಯಾಬಿ ಶಿಕಾಪಾಕ್ನಿ ಖಾಲ್ತಿ ಹೊತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ಖರೆ ತುಮಿ ಮಾಜೆ ಹೊಲ್ಲ್ಯಾಸಾಟಿ ತೆನಿ ತುಮ್ಕಾ ಹೆ ಸಗ್ಳೆ ಕರ್‍ತಾತ್, ತೆನಿ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಕ್ ವಳ್ಕಿನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ಮಿಯಾ ಯೆವ್ನ್ ತೆಂಚೆಕ್ಡೆ ಬೊಲಲ್ಲೆ ನಸ್ಲ್ಯಾರ್, ತೆಂಕಾ ತೆಂಚ್ಯಾ ಪಾಪಾಚ್ಯಾ ವಿಶಯಾತ್ ಕಾಯ್ಬಿ ಅಸಂಯ್ ದಿಶಿನಶಿ ಹೊತ್ತೆ, ಖರೆ ಅತ್ತಾ ತೆಂಕಾ ತೆಂಚ್ಯಾ ಪಾಪಾತ್ನಾ ಚುಕುನ್ ಘೆವ್ಕ್ ರ್‍ಹಾವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ಜೆ ಕೊನ್ ಮಾಜೊ ದ್ವೆಸ್ ಕರ್‍ತಾತ್ ತೆನಿ ಮಾಜ್ಯಾ ಬಾಬಾಚೊಬಿ ದ್ವೆಸ್ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ಮಿಯಾ ತೆಂಚ್ಯಾ ಮದ್ದಿ ಯೆವ್ನ್ ಕೊನ್ಬಿ ಕರುನಸಲ್ಲಿ ಕಾಮಾ ಕರುನ್‍ ದಾಕ್ವಿನಸ್ಲ್ಯಾರ್ ತೆಂಕಾ ತೆಂಚ್ಯಾ ಪಾಪಾಚ್ಯಾ ವಿಶಯಾತ್ ತೆಂಕಾ ಅಸಂಯ್ ದಿಶಿನಶಿ ಹೊತ್ತೆ, ತೆನಿ ತೆ ಸಗ್ಳೆ ಬಗಟ್ಲ್ಯಾನಿ ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ಮಾಜೊ ಅನಿ ಮಾಜ್ಯಾ ಬಾಬಾಚೊ ದ್ವೆಸ್ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ತೆಂಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ನಿ ಕಾಯ್ಬಿ ಕಾರನ್ ನಸ್ತಾನಾ ತೆನಿ ಮಾಜೊ ದ್ವೆಸ್ ಕರ್ಲ್ಯಾನಿ. ಮನುನ್ ಲಿವಲ್ಲೆ ಖರೆ ಹೊವ್‍ಸಾಟ್ನಿ ಹೆ ಸಗ್ಳೆ ಅಶೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ಲೆ ಖರೆ ದಾಕ್ವುನ್ ದಿತಲೊ, ಮಜತ್ ಕರ್‍ತಲೊ ಪವಿತ್ರ್ ಆತ್ಮೊ ಬಾಬಾಕ್ನಾ ಯೆತಾ. ಮಿಯಾ ತೆಕಾ ಬಾಬಾಕ್ನಾ ತುಮ್ಚೆಕ್ಡೆ ಧಾಡುನ್ ದಿತಾ. ಅನಿ ತೊ ಮಾಜೆ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ಅನಿ ತುಮಿಬಿ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಸಾಕ್ಷಿ ಬೊಲ್ತ್ಯಾಶಿ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಅದ್ದಿಚ್ಯಾನುಚ್ ತುಮಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ತುಮ್ಚೊ ವಿಶ್ವಾಸ್ ಹಾಲುಚೆ ನ್ಹಯ್ ಮನುನ್ ಮಿಯಾ ಹೆ ಸಗ್ಳೆ ತುಮ್ಕಾ ಅದ್ದಿಚ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ತುಮ್ಕಾ ಜುದೆವಾಚ್ಯಾ ಸಿನಾಗೊಗಾನಿತ್ನಾ ಭಾಯ್ರ್ ಘಾಲುನ್ ಹೊತಾ. ಅನಿ ತುಮ್ಕಾ ಜಿವಾನಿ ಮಾರ್‍ತಲ್ಯಾನಿ, ಅಪ್ನಿ ಜಿವಾನಿ ಮಾರುನ್ ಅಮಿ ದೆವಾಚಿ ಸೆವಾ ಕರುಲಾಂವ್ ಮನುನ್ ಚಿಂತ್ತಲೊ ಎಳ್‍ಬಿ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ಲೊಕಾ ಬಾಬಾಕ್‍ ಹೊಂವ್ದಿ ಮಾಕಾ ಹೊಂವ್ದಿ ವಳ್ಕಿನ್ಯಾತ್, ತಸೆಮನುನ್ ತೆನಿ ಹೆ ಸಗ್ಳೆ ಕರ್‍ತಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ತೆನಿ ಹೆ ಸಗ್ಳೆ ಕರ್‍ತಲೊ ಎಳ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮ್ಕಾ ಮಿಯಾ ದಿಲ್ಲಿ ಉಶಾರ್ಕಿ ಯಾದ್ ರಾಂವ್ದಿತ್ ಮನುನ್ ಹೆ ಸಗ್ಳೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ”. ಅದ್ದಿಚ್ ಮಿಯಾ ಹೆ ಸಗ್ಳೆ ತುಮ್ಕಾ ಸಾಂಗುನತ್ತೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ತುಮ್ಚ್ಯಾ ವಾಗ್ಡಾ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ಖರೆ ಅತ್ತಾ ಮಿಯಾ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಕ್ಡೆ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ, ಅನಿಬಿ ತುಮ್ಚ್ಯಾತ್ಲೊ ಕೊನ್ಬಿ ಮಾಕಾ ತಿಯಾ ಖೈ ಜಾವ್ಲೆ ಮನುನ್ ಇಚಾರುಕ್ ಹೊಯ್ನಾ? ");
INSERT INTO kans_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ಅತ್ತಾ ತೆ ಸಗ್ಳೆ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗಟ್ಲಾ, ತುಮ್ಚ್ಯಾ ಮನಾಕ್ನಿ ಬೆಜಾರ್ ಹೊವ್‍ಲಾಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ಖರೆ ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗ್ತಾ, ಮಿಯಾ ತುಮ್ಚ್ಯಾಕ್ನಾ ಧುರ್ ಗೆಲ್ಲೆ ತುಮ್ಕಾಚ್ ಬರೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಜಾಯ್ ನಸ್ಲ್ಯಾರ್ ಮಜತ್ ಕರ್‍ತಲೊ ಯೆಯ್ನಾ, ಮಿಯಾ ತುಮ್ಚ್ಯಾಕ್ನಾ ಗೆಲೊ ತರ್ ತೆಕಾ ತುಮ್ಚೆಕ್ಡೆ ಧಾಡುನ್ ದಿತಾ, ");
INSERT INTO kans_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ಅನಿ ತೊ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಹ್ಯಾ ಜಗಾತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಪಾಪಾಚ್ಯಾ ವಿಶಯಾತ್ ತೆನಿ ಚುಕ್ ವಾಟೆರ್ ಹಾತ್ ಮನುನ್ ದಾಕ್ವುನ್ ದಿತಾ ಅನಿ ಖಲೆ ಸಮಾ ಹಾಯ್ ತ್ಯೆಚ್ಯಾ ವಿಶಯಾತ್ ಅನಿ ದೆವಾನ್ ಕರ್‍ತಲ್ಯಾ ಝಡ್ತಿಚ್ಯಾ ವಿಶಯಾತ್ ದಾಕ್ವುನ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ತೆನಿ ಪಾಪಾಚ್ಯಾ ವಿಶಯಾತ್ ಚುಕ್ ವಾಟೆರ್ ಹಾತ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆನಿ ಮಾಜ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರಿನಾತ್, ");
INSERT INTO kans_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ತೆನಿ ಖಲೆ ಸಮಾ ಹಾಯ್ ತೆಕಾಚ್ ವ್ಹಾಕ್ಡೆ ಹೊವ್ನ್ ಹಾತ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ಡೆ ಜಾವ್‍ಲಾ, ಅನಿ ಫಿಡೆ ಮಿಯಾ ಕೊನಾಕ್ಬಿ ಬಗುಕ್ ಗಾವಿನಾ, ");
INSERT INTO kans_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ಅನಿ ತೆನಿ ಝಡ್ತಿಚ್ಯಾ ವಿಶಯಾತ್ ಚುಕ್ ಚಿಂತುನ್ ಘೆವ್ನ್ ಹಾತ್ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಹ್ಯಾ ಜಗಾಕ್ ಫುಡಾರ್‍ಯಾಚಿ ಝಡ್ತಿ ಹೊವ್ನ್ ನಿರ್‍ನಯ್ ಕರುನ್ ಹೊಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ಅನಿ ಲೈ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಲೆ ಹಾಯ್ ಖರೆ ತುಮ್ಚ್ಯಾನ್ ತೆ ಸಗ್ಳೆ ಸಂಬಾಳುನ್ ಘೆವ್ಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ಕಶೆಬಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೊ ತುಮ್ಕಾ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ಲೆ ಖರೆಪಾನ್ ದಾಕ್ವುನ್ ದಿತಾ, ತೊ ತುಮ್ಕಾ ಸಗ್ಳ್ಯಾ ಖರೆಪಾನಾತ್ ಚಾಲ್ವುನ್ ನ್ಹೆತಾ. ತೊ ಅಪ್ನಾಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಬೊಲಿನಾ, ತೊ ಅಪ್ನಿ ಆಯ್ಕಲ್ಲೆಚ್ ಸಾಂಗ್ತಾ. ಅನಿ ಫಿಡೆ ಯೆತಲ್ಯಾ ವಿಶಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ತೊ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ತೊ ಮಾಕಾ ಮಹಿಮಾ ದಿತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಮಿಯಾ ಸಾಂಗಲ್ಲೆ ಘೆತಾ ಅನಿ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ಜೆ ಕಾಯ್ ಮಾಜ್ಯಾ ಬಾಬಾಚೆ ಮನುನ್ ಹಾಯ್ ತೆ ಮಾಜೆಚ್, ತೆಚೆಸಾಟ್ನಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ಮಿಯಾ ಕಾಯ್ ದಿತಾ ತೆ ಘೆತಾ ಅನಿ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ ಮನುನ್ ಮಿಯಾ ಮಟ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ಅನಿ ಎಕ್ ಉಲ್ಲ್ಯಾ ಎಳಾಚ್ಯಾ ಮಾನಾ ಮಿಯಾ ತುಮ್ಕಾ ಬಗುಕ್ ಗಾವಿನಾ ಮಾನಾ ಅನಿ ಉಲ್ಲ್ಯಾ ಎಳಾನ್ ಮಿಯಾ ತುಮ್ಕಾ ಬಗುಕ್ ಗಾವ್ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ಶಿಸಾನಿತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾನಿ ಎಕಾಮೆಕಾತ್ನಿ “ಅಶೆ ಮಟ್ಲ್ಯಾರ್ ಕಾಯ್? ತೊ ಮನ್ತಾ ಉಲ್ಲ್ಯಾ ಎಳಾನ್ ಮಿಯಾ ತುಮ್ಕಾ ಬಗುಕ್ ಗಾವಿನಾ, ಅನಿ ಅನಿ ಉಲ್ಲ್ಯಾ ಎಳಾನ್ ಮಿಯಾ ತುಮ್ಕಾ ಬಗುಕ್ ಗಾವ್ತಾ ಅನಿ ತೊ ಮಾನಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ಡೆ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ” ");
INSERT INTO kans_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ಹ್ಯೊ ಉಲ್ಲೊ ಎಳ್ ಮಟ್ಲ್ಯಾರ್ ಕಾಯ್? ಹ್ಯೊ ಕಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲಾ ಮನುನ್ “ಅಮ್ಕಾ ಕಳಿನಾ ಹೊಲಾ” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ತೆನಿ ತೆಕಾ ಕಾಯ್ಕಿ ಇಚಾರುಚೆ ಮನುನ್ ಹಾತ್ ಮನುನ್ ಜೆಜುಕ್ ಕಳ್ಳೆ, ತನ್ನಾ ತೆನಿ ತೆಂಕಾ, “ಉಲ್ಲ್ಯಾ ಎಳಾನ್ ಮಿಯಾ ಬಗುಕ್ ಗಾವಿನಾ, ಮಾನಾ ಅನಿ ಉಲ್ಲ್ಯಾ ಎಳಾನ್ ಬಗುಕ್ ಗಾವ್ತಾ ಮನ್ತಲ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ಎಕಾಮೆಕಾತ್ನಿ ಇಚಾರುಲಾಲ್ಯಾಶಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಹೊತ್ತೆ ಸಾಂಗ್ತಾ, ತುಮಿ ಕಳ್ವಳ್ತ್ಯಾಶಿ ಅನಿ ರಡ್ತ್ಯಾಶಿ, ಖರೆ ಸಗ್ಳೊ ಜಗ್ ಖುಶಿ ಹೊತಾ, ತುಮಿ ದುಕ್ಕಾನ್ ರ್‍ಹಾತ್ಯಾಶಿ, ಖರೆ ತುಮ್ಚೊ ದುಕ್ ಕುಶಿ ಹೊವ್ನ್ ಬದಲ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ಎಕ್ ಪೊರಾಕ್ ಜಲಮ್ ದಿತಲೊ ಎಳ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಅಪ್ನಾಚೊ ಕಸ್ಟಾಚೊ ಎಳ್ ಯೆಲೊ ಮನುನ್ ಎಕ್ ಬಾಯ್ಕೊಮನ್ಸಿಕ್ ದುಕ್ ಹೊತಾ, ಖರೆ ಪೊರ್ ಉಪಾಜಲ್ಲ್ಯಾ ತನ್ನಾ ತಿ ತೊ ಸಗ್ಳೊ ಕಸ್ಟ್ ಇಸರ್‍ತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಹ್ಯಾ ಜಗಾತ್ ಎಕ್ ಪೊರ್ ಉಪಾಜ್ಲೊ ಮಟಲ್ಲ್ಯಾಸಾಟ್ನಿ ತಿ ಕುಶಿ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ತಸೆಚ್ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾಬಿ ಹೊತಾ, ತುಮಿ ಅತ್ತಾ ದುಕಾತ್ ಹಾಶಿ, ಖರೆ ಮಿಯಾ ಅನಿ ಎಗ್ದಾ ತುಮ್ಕಾ ಭೆಟ್ತಾನಾ ತುಮ್ಚಿ ಮನಾ ಖುಶಿನ್ ಭರಲ್ಲಿ ರ್‍ಹಾತ್ಯಾತ್. ತಿ ಕುಶಿ ಕೊನಾಕ್ಬಿ ತುಮ್ಚ್ಯಾಕ್ನಾ ಕಾಡುನ್ ನ್ಹೆವ್ಕ್ ಹೊಯ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ತೊ ದಿಸ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮಿ ಮಾಜಾಕ್ಡೆ ಕಾಯ್ಬಿ ಮಾಗಿನ್ಯಾಶಿ, ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಅಸಲ್ಲೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ. ಮಾಜ್ಯಾ ನಾವಾನ್ ತುಮಿ ಕಾಯ್ಬಿ ಮಾಗ್ಲ್ಯಾರ್‍ಬಿ ಮಾಜೊ ಬಾಬಾ ತೆ ತುಮ್ಕಾ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ಆಜ್ ಪತರ್ ತುಮಿ ಮಾಜ್ಯಾ ನಾವಾನ್ ಕಾಯ್ಬಿ ಮಾಗುಕ್‍ನ್ಯಾಶಿ; ಇಚಾರಾ ಅನಿ ತುಮ್ಕಾ ಗಾವ್ತಾ. ಅಶೆ ತುಮ್ಚೊ ಕುಶಿ ಪುರಾ ಹೊತಾ”. ");
INSERT INTO kans_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ಹೆ ಸಗ್ಳೆ ಸಾಂಗುಕ್ ಮಿಯಾ ಒಡ್ಪಾ ವಾಪರ್‍ಲೊ, ಖರೆ ಎಕ್ ಎಳ್ ಯೆತಾ, ತನ್ನಾ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾಚ್ಯಾ ವಿಶಯಾತ್ ತುಮ್ಚೆಕ್ಡೆ ಫೊಡುನ್ ಬೊಲ್ತಾ ");
INSERT INTO kans_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ತೊ ದಿಸ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತುಮಿ ತೆಚೆಕ್ಡೆ ಮಾಜ್ಯಾ ನಾವಾನ್ ಮಾಗ್ತ್ಯಾಶಿ, ಅನಿ ಮಿಯಾ ತುಮ್ಚ್ಯಾಸಾಟ್ನಿ ತೆಚ್ಯೆಕ್ಡೆ ಮಾಗ್ತಾ ಮನುನ್ ಸಾಂಗಿನಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ತುಮಿ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ಲ್ಯಾಶಿ ಅನಿ ಮಿಯಾ ದೆವಾಕ್ನಾ ಯೆಲಾ ಮನುನ್ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾಶಿ ಮನುನ್ ಮಾಜೊ ಬಾಬಾ ತುಮ್ಚೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ಮಿಯಾ ಬಾಬಾಕ್ನಾ ಯೆಲೊ, ಅನಿ ಮಿಯಾ ಹ್ಯಾ ಜಗಾತ್ ಯೆಲೊ, ಅನಿ ಅತ್ತಾ ಮಿಯಾ ಹ್ಯೊ ಜಗ್ ಸೊಡುನ್ ಬಾಬಾಕ್ಡೆ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ”, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ತನ್ನಾ ಶಿಸಾನಿ ತೆಕಾ, “ಅತ್ತಾ ತಿಯಾ ಒಡ್ಪಾ ವೈನಾ ಬೊಲಿನಸ್ತಾನಾ ಫೊಡುನ್ ಬೊಲುಲಾಲೆ, ");
INSERT INTO kans_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ತುಕಾ ಸಗ್ಳೆ ಗೊತ್ತ್ ಹಾಯ್ ಮನುನ್ ಅಮ್ಕಾ ಅತ್ತಾ ಕಳ್ಳೆ. ಕೊನ್ಬಿ ಪ್ರಸ್ನೊ ಇಚಾರುಚೆ ಮನ್ತಲೆ ತುಕಾ ನಕ್ಕೊ, ಹೆ ಅಮ್ಕಾ ತಿಯಾ ದೆವಾಕ್ನಾ ಯೆಲ್ಲೊ ಮನುನ್ ವಿಶ್ವಾಸ್ ಕರಿ ಸಾರ್ಕೆ ಕರ್‍ತಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ ಸಾಂಗಲ್ಲ್ಯಾನ್, ತುಮಿ ಅತ್ತಾ ವಿಶ್ವಾಸ್ ಕರ್‍ತ್ಯಾಶಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ತುಮಿ ಸಗ್ಳಿ ಲೊಕಾ ಮಾಳ್ಬರ್ ಹೊವ್ನ್ ತುಮ್ಚ್ಯಾ ಘರಾಕ್ನಿ ಪಳುನ್ ಜಾತಲೊ ಎಳ್ ಯೆಲೊ, ಅನಿ ತೊ ಯೆವ್ನ್ ಪಾವಲ್ಲೊಚ್ ಹಾಯ್, ಅನಿ ಮಿಯಾ ಎಕ್ಲೊಚ್ ಹುರ್‍ತಾ, ಖರೆ ಮಿಯಾ ಎಕ್ಲೊಚ್ ನಾಂವ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಬಾಬಾಚ್ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ತುಮಿ ಸಗ್ಳೆ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಹೊವ್ನ್ ರಾವ್ನ್ ಶಾಂತಿನ್ ರಾವ್ಚೆ ಮನುನ್ ಮಿಯಾ ಹೆ ಸಗ್ಳೆ ತುಮ್ಕಾ ಸಾಂಗಟ್ಲೊ, ಖರೆ ಧೈರೊ ಕರಾ! ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಿಯಾ ಹ್ಯಾ ಜಗಾ ವರ್ತಿ ಜಿಕ್ಲಾ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ಹೆ ಸಗ್ಳೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ ವೈರ್ ಸರ್ಗಾಕ್ಡೆ ಬಗಟ್ಲ್ಯಾನ್. ಅನಿ, ಬಾಬಾ ಎಳ್ ಯೆಲೊ, ಲೊಕಾನ್ ತುಕಾ ಮಹಿಮಾ ದಿವಸಾಟ್ನಿ ಲೆಕಾಕ್ ತಿಯಾ ತುಜಿ ಮಹಿಮಾ ದಿ. ");
INSERT INTO kans_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿಯಾ ತ್ಯೆಚ್ಯಾ ತಾಬೆತ್ ದಿಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಕನ್ನಾಚ್ ಮರಾನ್ ನಸಲ್ಲೆ ಜಿವನ್ ದಿವ್‍ಸಾಟ್ನಿ ಮನುನ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್ತಿ ತೆಕಾ ಅದಿಕಾರ್ ದಿಲೆಯ್. ");
INSERT INTO kans_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ಕನ್ನಾಚ್ ಮರಾನ್‍ನಸಲ್ಲೆ ಜಿವನ್ ಮಟ್ಲ್ಯಾರ್ ತುಕಾ ಎಕ್ಲ್ಯಾಚ್ ಖರ್‍ಯಾ ದೆವಾಕ್ ವಳಕ್ತಲೆ ಅನಿ ತಿಯಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾ ಜೆಜು ಕ್ರಿಸ್ತಾಕ್ ವಳಕ್ತಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ಮಿಯಾ ಹ್ಯಾ ಜಿಮ್ನಿರ್ ತುಜಿ ಮಹಿಮಾ ದಾಕ್ವುಲಾ ತಿಯಾ ಮಾಕಾ ಒಪಸಲ್ಲೆ ಕಾಮ್ ಮಿಯಾ ಕರುನ್ ಸಾರ್‍ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ಬಾಬಾ! ಹ್ಯೊ ಜಗ್ ರಚುಚ್ಯಾ ಅದ್ದಿ ಮಿಯಾ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ಮಾಕಾ ಹೊತ್ತಿ, ತಿಚ್ ಮಹಿಮಾ ತಿಯಾ ಮಾಕಾ ಅತ್ತಾ ತುಜ್ಯಾ ಇದ್ರಾಕ್ ದಿ. ");
INSERT INTO kans_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ಹ್ಯಾ ಜಗಾತ್ ಮಾಜೆ ಮನುನ್ ತಿಯಾ ಮಾಕಾ ದಿಲ್ಲ್ಯಾಕ್ನಿ ಮಿಯಾ ತುಜಿ ವಳಕ್ ಕರುನ್ ದಿಲೊ. ತೆನಿ ತುಕಾ ಸಮಂದ್ ಪಡಲ್ಲೆ ಹಾತ್, ಅನಿ ತಿಯಾಚ್ ತೆಂಕಾ ಮಾಜ್ಯಾ ತಾಬೆತ್ ದಿಲೆಯ್, ತೆನಿ ತುಜ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ಅನಿ ಅತ್ತಾ ತೆಂಕಾ ಜೆ ಕಾಯ್ ಮಾಕಾ ದಿಲ್ಲೆ ಹಾಯ್ ತೆ ಸಗ್ಳೆ ತುಜೆಕ್ನಾಚ್ ಯೆಲಾ ಮನುನ್ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ತಿಯಾ ಮಾಜ್ಯಾ ತಾಬೆತ್ ದಿಲ್ಲಿ ಖಬರ್ ಮಿಯಾ ತೆಂಕಾ ದಿಲಾ. ಅನಿ ತೆನಿ ತಿ ಸ್ವಿಕಾರ್ ಕರ್ಲ್ಯಾನಿ, ಅನಿ ಮಿಯಾ ತುಜೆಕ್ನಾಚ್ ಯೆಲಾ ಮನುನ್ ತೆಂಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಅನಿ ತಿಯಾಚ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲೆ ಮನುನ್ ತೆನಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ಮಿಯಾ ತ್ಯೆಂಚ್ಯಾಸಾಟ್ನಿ ಮಾಗ್ನಿ ಕರ್‍ತಾ ಮಿಯಾ ಹ್ಯಾ ಜಗಾಸಾಟ್ನಿ ಮಾಗ್ನಿ ಕರಿನಾ, ತಿಯಾ ಮಾಕಾ ಮನುನ್ ಕೊನಾಕೊನಾಕ್ ದಿಲೆ ತೆಂಚೆಸಾಟ್ನಿ ಮಾಗ್ನಿ ಕರ್‍ತಾ. ತೆನಿ ತುಕಾ ಸಮಂದ್ ಪಡಲ್ಲಿ ಮಾನ್ಸಾ. ");
INSERT INTO kans_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ಜೆ ಕಾಯ್ ಮಾಜೆ ಮನುನ್ ಹಾಯ್ ತೆ ಸಗ್ಳೆ ತುಜೆಚ್, ಅನಿ ತುಜೆ ಮನುನ್ ಹೊತ್ತೆ ಸಗ್ಳೆ ಮಾಜೆಚ್, ಅನಿ ಮಾಜಿ ಮಹಿಮಾ ತೆಂಚ್ಯಾ ವೈನಾ ದಿಸುನ್ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ಅತ್ತಾ ಮಿಯಾ ತುಜೆಕ್ಡೆ ಯೆವ್ಲಾಲಾ, ಅನಿ ಲೈ ಎಳ್ ಮಿಯಾ ಹ್ಯಾ ಜಗಾತ್ ರ್‍ಹಾಯ್ನಾ, ಖರೆ ತೆನಿ ಹ್ಯಾ ಜಗಾತುಚ್ ರ್‍ಹಾತ್ಯಾತ್. ಪವಿತ್ರ್ ಬಾಬಾ! ತುಜ್ಯಾ ನಾವಾಚ್ಯಾ ಬಳಾನ್ ತೆಂಕಾ ತಿಯಾ ರಾಕ್, ತೆಚ್ ನಾವ್ ತಿಯಾ ಮಾಕಾಬಿ ದಿಲ್ಲೆ. ಅಸೆ, ಕಶೆ ಮಿಯಾ ಅನಿ ತಿಯಾ ಎಕ್ ಹೊವ್ನ್ ಹಾಂವ್, ತಸೆ ತೆನಿಬಿ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ಮಿಯಾ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ ತನ್ನಾ, ತಿಯಾ ಮಾಕಾ ದಿಲ್ಲ್ಯಾ ತುಜ್ಯಾ ನಾವಾಚ್ಯಾ ಬಳಾನ್ ಮಿಯಾ ತೆಂಕಾ ಸುರಕ್ಷಿತ್ ಥವಲ್ಲೊ. ಅಶೆ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್, ಕೊನಾಚೆ ನಿಸಂತಾನ್ ಹೊವ್ಕ್ ಪಾಜೆ ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಹಾಯ್, ತೆ ಪುರಾ ಹೊವ್‍ಸಾಟ್ನಿ ತೆಕಾ ಎಕ್ಲ್ಯಾಕ್ ಸೊಡುನ್ ಹುರಲ್ಲೆ ಕೊನ್ಬಿ ನಾಸ್‍ ಹೊವ್ಕನಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ಖರೆ ಅತ್ತಾ ಮಿಯಾ ತುಜೆಕ್ಡೆ ಯೆವ್ಲಾ, ಅನಿ ಮಿಯಾ ಹೆ ಸಗ್ಳೆ ಹ್ಯಾ ಜಗಾತ್ ಸಾಂಗ್ತಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಮಾಜಿ ಕುಶಿ ಸಂಪುರ್ನ್ ರಿತಿನ್ ತೆಂಚ್ಯಾ ಮನಾತ್ನಿ ಭರುನ್ ರ್‍ಹಾಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ಮಿಯಾ ತೆಂಕಾ ತುಜ್ಯಾ ಗೊಸ್ಟಿಯಾ ಶಿಕ್ವುಲೊ, ಖರೆ ಹ್ಯಾ ಜಗಾನ್ ತೆಂಕಾ ಧುರ್ ಕರ್ಲ್ಯಾನ್. ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಕಶೆ ಮಿಯಾ ಹ್ಯಾ ಜಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೊ ನ್ಹಯ್, ತಶೆಚ್ ತೆನಿಬಿ ಹ್ಯಾ ಜಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೆ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ತೆಂಕಾ ಹ್ಯಾ ಜಗಾತ್ನಾ ಕಡೆಕ್ ಕಾಡುನ್ ಘೆ ಮನುನ್ ಮಿಯಾ ಮಾಗಿನಾ. ಖರೆ ತೆಂಕಾ ತ್ಯಾ ಬುರ್ಶ್ಯಾಚ್ಯಾ ಹಾತಾತ್ನಾ ರಾಕ್ ಮನುನ್ ಮಾಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ಕಶೆ ಮಿಯಾ ಹ್ಯಾ ಜಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೊ ನ್ಹಯ್, ತಶೆಚ್ ತೆನಿಬಿ ಹ್ಯಾ ಜಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೆ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ತುಜ್ಯಾ ಖರೆಪಾನಾಕ್ ಲಾಗುನ್ ತೆಂಕಾ ತಿಯಾ ತುಜ್ಯಾಚ್ ಹಾತಿತ್ ಒಪ್ಸುನ್ ಘೆ, ತುಜಿ ಗೊಸ್ಟ್ ಖರಿ. ");
INSERT INTO kans_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ಕಶೆ ತಿಯಾ ಮಾಕಾ ಜಗಾತ್ ಧಾಡುನ್ ದಿಲೆಯ್, ತಸೆಚ್ ಮಿಯಾ ತೆಂಕಾ ಜಗಾತ್ ಧಾಡುನ್ ದಿಲಾ. ");
INSERT INTO kans_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ತೆಚೆಸಾಟ್ನಿ ಮಿಯಾ ಮಾಕಾಚ್ ತುಜ್ಯಾ ಹಾತಾತ್ ಒಪ್ಸುನ್ ದಿತಾ. ಅಶೆ ತೆನಿಬಿ ಖರೆಚ್! ತುಕಾ ಒಪ್ಸುನ್ ದಿಲ್ಲೆ ಹೊಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ಖಾಲಿ ತೆಂಚೆಸಾಟ್ನಿ ಎವ್ಡೆಚ್ ಮಿಯಾ ಮಾಗಿನಾ, ತೆನಿ ಸಾಂಗಲ್ಲಿ ಬರಿ ಖಬರ್ ಆಯ್ಕುನ್ ಮಾಜೆವರ್ತಿ ವಿಶ್ವಾಸ್ ಕರ್‍ತಲ್ಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಸಾಟ್ನಿಬಿ ಮಿಯಾ ಮಾಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ತೆನಿ ಸಗ್ಳಿ ಲೊಕಾ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾಯ್‍ ಸಾರ್ಕೆ ಹೊಂವ್ದಿತ್ ಮನುನ್ ಮಿಯಾ ಮಾಗ್ತಾ. ಬಾಬಾ! ಕಶೆ ತಿಯಾ ಮಾಜ್ಯಾ ಭುತ್ತುರ್ ಹಾಸ್, ಅನಿ ಮಿಯಾ ತುಜೆ ಭುತ್ತುರ್ ಹಾಂವ್. ತಸೆಚ್ ತೆನಿಬಿ ಅಮ್ಚ್ಯಾ ಭುತ್ತುರ್ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾಯ್ ಸರ್ಕೆ ಹೊಂವ್ದಿತ್. ಅಶೆ ತಿಯಾಚ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲೆ ಮನುನ್ ಹ್ಯೊ ಜಗ್ ವಿಶ್ವಾಸ್ ಕರಿ ಸರ್ಕೆ ಹೊಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ತಿಯಾ ಮಾಕಾ ದಿಲ್ಲಿ ಮಹಿಮಾಚ್ ಮಿಯಾ ಲೊಕಾಕ್ನಿ ದಿಲಾ, ಅಶೆ ತಿಯಾ ಅನಿ ಮಿಯಾ ಕಶೆ ಎಕ್ ಹೊವ್ನ್ ಹಾಂವ್ ತಸೆಚ್ ತೆನಿಬಿ ಎಕ್ ಹೊವ್ನ್ ರ್‍ಹಾಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ಮಿಯಾ ತೆಂಚ್ಯಾ ಭುತ್ತುರ್ ಹಾಂವ್ ಅನಿ ತಿಯಾ ಮಾಜ್ಯಾ ಭುತ್ತುರ್ ಹಾಸ್ ಅಶೆ ತೆನಿ ಸಂಪುರ್ನ್ ರಿತಿನ್ ಎಕ್ ಹೊಂವ್ದಿತ್, ಹೆಕಾ ಲಾಗುನ್ ಹ್ಯೊ ಜಗ್ ಕಳ್ವುನ್ ಘೆಂವ್ದಿ ತಿಯಾಚ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲೆ. ಅನಿ ತಿಯಾ ಕಸೊ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ಲೆ ತಸೆಚ್ ತ್ಯೆಂಚೊಬಿ ಪ್ರೆಮ್ ಕರ್‍ತೆ ಮನುನ್ ತೆಂಕಾ ಕಳುಂದಿ. ");
INSERT INTO kans_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ಬಾಬಾ! ತಿಯಾ ತೆಂಕಾ ಮಾಜಾಕ್ಡೆ ದಿಲೆಯ್, ಅನಿ ಮಿಯಾ ಖೈ ರ್‍ಹಾತಾ ಥೈ ತೆನಿಬಿ ಹೊತ್ತೆ ಮಾಕಾ ಪಾಜೆ. ಅಶೆ ಹ್ಯೊ ಜಗ್ ರಚುಚ್ಯಾ ಅದ್ದಿಚ್ ತಿಯಾ ಮಾಜೊ ಪ್ರೆಮ್ ಕರುನ್ ಮಾಕಾ ದಿಲ್ಲಿ ಮಹಿಮಾ ತೆನಿಬಿ ಬಗಿ ಸರ್ಕೆ ಹೊಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ಬರ್‍ಯಾ ಬಾಬಾ! ಹ್ಯೊ ಜಗ್ ತುಕಾ ವಳ್ಕಿನಾ, ಖರೆ ಮಿಯಾ ತುಕಾ ವಳಕ್ತಾ. ಅನಿ ಹೆಂಕಾ ತಿಯಾಚ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲೆ ಮನುನ್ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ಮಿಯಾ ತೆಂಕಾ ತುಜಿ ಖರಿ ವಳಕ್ ಕರುನ್ ದಿಲಾ, ಅನಿ ಅನಿ ಫಿಡೆಬಿ ಮಿಯಾ ತೆಂಕಾ ತುಜಿ ಖರಿ ವಳಕ್ ದಿವ್ನಗೆತುಚ್ ರ್‍ಹಾತಾ. ಅಶೆ ಮಾಜೆ ವರ್ತಿ ತುಕಾ ಅಸಲ್ಲೊ ಪ್ರೆಮ್ ತೆಂಚ್ಯಾ ಮದ್ದಿಬಿ ರ್‍ಹಾವ್ಕ್ ಹೊತಾ, ಅನಿ ಅಶೆ ಮಿಯಾಬಿ ತೆಂಚ್ಯಾ ಮದ್ದಿ ರ್‍ಹಾವ್ಕ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ಜೆಜುನ್ ಹಿ ಮಾಗ್ನಿ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ತೊ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ವಾಂಗ್ಡಾ ಘೆವ್ನ್ ಕೆದ್ರೊನ್ ಮನ್ತಲೊ ಕರ್‍ಕೊ ದಾಟುನ್ ಗೆಲೊ, ಥೈ ಎಕ್ ಮ್ಹಳೊ ಹೊತ್ತೊ, ತೆನಿ ತ್ಯಾ ಮಳ್ಯಾತ್ ಗುಸ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ಜೆಜುಕ್ ಘಾತ್ ಕರುನ್ ಧರುನ್ ದಿತಲ್ಯಾ ಜುದಾಸಾಕ್ ಹ್ಯೊ ಜಾಗೊ ಗೊತ್ತ್ ಹೊತ್ತೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತನ್ನಾ-ತನ್ನಾ ಜೆಜು ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಥೈ ಜಯ್. ");
INSERT INTO kans_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ತಸೆಮನುನ್ ಜುದಾಸ್ ರೊಮಾಚ್ಯಾ ಸೈನಿಕಾಚೊ ಎಕ್ ತಾಂಡೊ, ಅನಿ ಉಲ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ರಾಕ್ವಾಲ್ಯಾಕ್ನಿ, ಘೆವ್ನ್ ತ್ಯಾ ಮಳ್ಯಾಕ್ ಯೆಲೊ, ತೆಂಕಾ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಅನಿ ಫಾರಿಜೆವಾನಿ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾನಿ, ತೆನಿ ಹಾತಿಯಾರಾ, ಲಾಟ್ನಿಯಾ, ಅನಿ ಚುಡ್ತಿಯಾ ಘೆವ್ನ್ ಯೆಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ಜೆಜುಕ್ ಅಪ್ನಾಕ್ ಕಾಯ್-ಕಾಯ್ ಹೊತಲೆ ಹಾಯ್ ಮನುನ್ ಗೊತ್ತ್ ಹೊತ್ತೆ, ತಸೆಮನುನ್ ತೊ ಉಲ್ಲೆ ಫಿಡೆ ಗೆಲೊ, ಅನಿ “ತುಮಿ ಕೊನಾಕ್ ಹುಡ್ಕುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ತನ್ನಾ ತೆನಿ “ನಜರೆತಾಚ್ಯಾ ಜೆಜುಕ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಲ್ಯಾನಿ. ತನ್ನಾ ತೆನಿ, “ಮಿಯಾಚ್ ತೊ” ಮಟ್ಲ್ಯಾನ್, ಜುದಾಸ್ ಇಸ್ಕರಿಯೊತ್ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಥೈ ಇಬೆ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ಜೆಜುನ್ “ಮಿಯಾಚ್ ತೊ” ಮನುನ್ ಮಟಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಫಾಟಿ ಸರಕ್ಲೆ ಅನಿ ಜಿಮ್ನಿ ವರ್ತಿ ಡಬ್ ಪಡ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ಅನಿ ಎಗ್ದಾ ಜೆಜುನ್ ತೆಂಕಾ,“ತುಮಿ ಕೊನಾಕ್ ಹುಡ್ಕುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತೆನಿ “ನಜರೆತಾಚ್ಯಾ ಜೆಜುಕ್” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ತನ್ನಾ ಜೆಜುನ್,“ಮಿಯಾ ತುಮ್ಕಾ ವಾಡ್ಗೊಳುಚ್ ಸಾಂಗ್ಲಾ ಮಿಯಾಚ್ ತೊ, ಮನುನ್, ತುಮಿ ಮಾಕಾ ಹುಡ್ಕುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ ಹೊಲ್ಯಾರ್, ಹ್ಯಾ ಹುರಲ್ಲ್ಯಾಕ್ನಿ ಜಾವ್ಕ್ ದಿವಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“ಬಾಬಾ ತಿಯಾ ಮಾಜಾಕ್ಡೆ ದಿಲ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್‍ಬಿ ಮಿಯಾ ಕಳ್ದುನ್ ಜಾವ್ಕ್ ದಿವ್ಕ್ ನಾ” ಮನುನ್ ಮಟಲ್ಲಿ ಗೊಸ್ಟ್ ಪುರಾ ಹೊವ್‍ಸಾಟ್ನಿ ತೆನಿ ಅಶೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ಸಿಮಾವ್ ಪೆದ್ರುನ್ ಅಪ್ನಾಚೊ ಚಾಕು ಕಾಡ್ಲ್ಯಾನ್, ಅನಿ ಮೊಟ್ಯಾ ಯಾಜಕಾಂಚ್ಯಾ ಆಳಾಚ್ಯಾ ಕಾನಾಕ್ ಮಾರುನ್, ತೆಚೊ ಉಜ್ವೊ ಕಾನುಚ್ ಕಾತ್ರುನ್ ಕಾಡ್ಲ್ಯಾನ್. ತ್ಯಾ ಆಳಾಚೆ ನಾವ್ ಮಾಲ್ಖ್ ಮನುನ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ಜೆಜುನ್ ಪೆದ್ರುಕ್, “ತುಜೊ ಚಾಕು ಪಿಸ್ವಿತ್ ಘಾಲ್ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ದಿಲ್ಲ್ಯಾ ಕಸ್ಟಾಚ್ಯಾ ಆಯ್ದಾನಾತ್ಲೆ ಫಿತಲೆ ನಕ್ಕೊ ಮನ್ತೆ ಕಾಯ್ ತಿಯಾ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ತನ್ನಾ ಅದಿಕಾರ್‍ಯಾನ್ ಹುಕುಮ್ ದಿಲ್ಲ್ಯಾ ತನ್ನಾ ರೊಮಾಚ್ಯಾ ಸೈನಿಕಾನಿ ಅನಿ ಜುದೆವಾನಿ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾ ರಾಕ್ವಾಲ್ಯಾನಿ. ಜೆಜುಕ್ ಧರುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ಅನಿ ಭಾಂದ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ಅನಿ ತೆಕಾ ಅದ್ದಿ ಅನ್ನಾಸ್ ಮನ್ತಲ್ಯಾ ಮಾನ್ಸಾಕ್ಡೆ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ತೊ ತ್ಯಾ ವರ್ಸಾ ಮೊಟೊ ಯಾಜಕ್ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ಕಾಯಿಫಾಸಾಚೊ ಮಾಮಾ. ");
INSERT INTO kans_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಎಕ್ ಮಾನ್ಸಾನ್ ಮರ್‍ತಲೆ ಬರೆ ಮನುನ್ ಕಾಯಿಫಾಸಾನುಚ್ ಜುದೆವ್ ಲೊಕಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಕ್ನಿ ಸಲಹಾ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ಸಿಮಾವ್ ಪೆದ್ರು ಅನಿ ತೊ ಅನಿ ಎಕ್ಲೊ ಶಿಸ್ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾಫಾಟ್ನಾ ಗೆಲೆ, ತೊ ಅನಿ ಎಕ್ಲೊ ಮೊಟ್ಯಾ ಯಾಜಕಾಂಚ್ಯಾ ವಳ್ಕಿಚೊ ತಸೆ ಮನುನ್ ತೊ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಮೊಟ್ಯಾ ಯಾಜಕಾಂಚ್ಯಾ ಘರಾಚ್ಯಾ ದಾರಾತ್ ಪತರ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ಪೆದ್ರು ಭಾಯ್ರ್ ದಾರಾತ್‍ ಭುತ್ತುರ್ ಗುಸ್ತಲ್ಯಾಕ್ಡೆ ಇಬೆ ಹೊತ್ತೊ, ತನ್ನಾ ತೊ ಅನಿ ಎಕ್ಲೊ ಮೊಟ್ಯಾ ಯಾಜಕಾಂಚ್ಯಾ ವಳ್ಕಿಚೊ ಶಿಸ್ ಭಾಯ್ರ್ ಯೆಲೊ. ಅನಿ ತೆನಿ ಎಕ್ಲ್ಯಾ ಕಾಮಾಚ್ಯಾ ಚೆಡ್ವಾಕ್ಡೆ ಸಾಂಗುನ್ ಪೆದ್ರುಕ್ ಭುತ್ತುರ್ ಘೆವ್ನ್ ಯೆಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ಥೈ ವಾಟೆಕ್ಡೆ ಹೊತ್ತ್ಯಾ ಕಾಮಾಚ್ಯಾ ಚೆಡ್ವಾನ್ ಪೆದ್ರುಕ್, “ತಿಯಾಬಿ ತ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಶಿಸಾನಿತ್ಲೊ ಎಕ್ಲೊ ನ್ಹಯ್ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಪೆದ್ರುನ್, “ನಾ ಮಿಯಾ ನ್ಹಯ್” ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ಥಂಡ್ ಕುರುಲಾಗಲ್ಲಿ ತಸೆ ಮನುನ್ ಆಳಾನಿ ಅನಿ ರಾಕ್ವಾಲ್ಯಾನಿ ಎಕ್ ಧುಮಿ ಘಾಟ್ಲ್ಯಾನಿ ಅನಿ ಧುಮಿಚ್ಯಾ ಭೊತ್ಯಾನಿ ಇಬೆ ರ್‍ಹಾವ್ನ್ ಆಗ್ ಶೆಕುಲಾಗಲ್ಲ್ಯಾನಿ. ತಸೆಮನುನ್ ಪೆದ್ರುಬಿ ಗೆಲೊ ಅನಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಇಬೆ ರ್‍ಹಾವ್ನ್ ಆಗ್ ಶೆಕುಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ಮೊಟ್ಯಾ ಯಾಜಕಾನ್ ಶಿಸಾಂಚ್ಯಾ ಅನಿ ಶಿಕಾಪಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಜೆಜುಕ್ ಪರಸ್ನೆ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ತನ್ನಾ ಜೆಜುನ್ ಮಿಯಾ ಕನ್ನಾಬಿ ಸಗ್ಳ್ಯಾಕ್ನಿ ಕಾಯ್ಬಿ ಧಾಪುನ್ ಘೆಯ್ನಸ್ತಾನಾ, ಬೊಲ್ಲಾ, ಮಿಯಾ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಅನಿ ಸಿನಾಗೊಗಾತ್ನಿ ಮಾಜಿ ಸಗ್ಳಿ ಶಿಕಾಪಾ ಶಿಕ್ವುಲಾ, ಥೈ ಸಗ್ಳಿ ಲೊಕಾ ಗೊಳಾ ಹೊಲ್ಲಿ ರ್‍ಹಾಯ್ತ್, ಮಿಯಾ ಕಾಯ್ಬಿ ಧಾಪುನ್ ಥವ್ನ್ ಘೆವ್ನ್ ಬೊಲುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ತಿಯಾ ಮಾಕಾ ಕಶ್ಯಾಕ್ ಇಚಾರುಲಾಲೆ? ಮಿಯಾ ಬೊಲಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿಚ್ ಇಚಾರ್. ಮಿಯಾ ತೆಂಕಾ ಕಾಯ್ -ಕಾಯ್ ಸಾಂಗ್ಲೊ ಮನುನ್ ತೆಂಕಾ ಗೊತ್ತ್ ಹಾಯ್ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ಅಶೆ ಜೆಜುನ್ ಸಾಂಗಟಲ್ಲ್ಯಾ ತನ್ನಾ ಥೈ ಹೊತ್ತ್ಯಾ ಎಕ್ ರಾಕ್ವಾಲ್ಯಾನ್ ಜೆಜುಚ್ಯಾ ಕಾನಾಕ್ಡೆ ಠಪ್ರಾಕ್ ಮಾರ್‍ಲ್ಯಾನ್ ಅನಿ, “ಮೊಟ್ಯಾ ಯಾಜಕಾಕ್ಡೆ ಅಶೆ ಬೊಲುಚೆ ಮಟ್ಲ್ಯಾರ್ ತುಕಾ ಕವ್ಡೊ ಧೈರೊ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ, “ಮಿಯಾ ಕಾಯ್ ತರ್ ಚುಕ್ ಬೊಲ್ಲಾ ಹೊಲ್ಲ್ಯಾರ್, ಹಿತ್ತೆ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಸಾಂಗ್. ಮಿಯಾ ಸಾಂಗಲ್ಲೆ ಸಮಾ ಹಾಯ್ ಜಾಲ್ಯಾರ್ ಮಾಕಾ ಕಶ್ಯಾಕ್ ಮಾರ್‍ಲೆಯ್?” ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ತನ್ನಾ ಅನ್ನಾಸಾನ್ ಭಾಂದಲ್ಲೆ ಹೊತ್ತೆ ತಶೆಚ್ ಜೆಜುಕ್ ಮೊಟೊ ಯಾಜಕ್ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ಕಾಯಿಫಾಸಾಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ಸಿಮಾವ್ ಪೆದ್ರು ಅಜುನ್‍ಬಿ ಥೈ ಇಬೆ ರ್‍ಹಾವ್ನ್ ಆಗ್ ಶೆಕುಲಾಗಲ್ಲೊ, ತನ್ನಾ ಥೈತ್ಲ್ಯಾನಿ ತೆಕಾ “ತಿಯಾಬಿ ತ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಶಿಸಾನಿತ್ಲೊ ಎಕ್ಲೊ ಕಾಯ್ಕಿ ನ್ಹಯ್?” ಮಟ್ಲ್ಯಾನಿ. ಖರೆ ಪೆದ್ರುನ್, “ನಾ, ಮಿಯಾ ನ್ಹಯ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ಮೊಟ್ಯಾ ಯಾಜಕಾಚ್ಯಾ ಆಳಾನಿತ್ಲೊ ಎಕ್ಲೊ, ಪೆದ್ರುನ್ ಕಾನ್ ಕಾತರಲ್ಲ್ಯಾಚೊ ಎಕ್ಲೊ ಸಮಂದಿಕ್, “ಮಿಯಾ ತುಕಾ ತ್ಯೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಳ್ಯಾತ್ ಬಗುನತ್ತೊ ಕಾಯ್?” ಮನುನ್ ಇಚಾರುಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ಅನಿಬಿ ಪೆದ್ರುನ್ “ನಾ,” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ಕೊಂಬ್ಯಾನ್ ಭೊಕ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ಸಕ್ಕಾಳಿ ಫಿಡೆ ನಸ್ಕಾತ್ ಜೆಜುಕ್ ಕಾಯಿಫಾಸಾಚ್ಯಾ ಘರಾತ್ನಾ ಮೊಟ್ಯಾ ಅದಿಕಾರ್‍ಯಾಚ್ಯಾ ಪಿಲಾತಾಚ್ಯಾ ಘರಾಕ್ಡೆ ಘೆವ್ನ್ ಜಾವ್ನ್ ಹೊಲೆ. ಬ‍ಸ್ಟಗಾರ್ ಹೊವ್ನ್ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚೆ ಬೊಕ್ಡಾಚೆ ಜೆವಾನ್ ಜೆವ್ಕ್ ಸಮಸ್ಯೆ ಹೊಯ್ಲ್ ಮನುನ್ ಜುದೆವ್ ಲೊಕಾಂಚೆ ಅದಿಕಾರಿ ರಾಜಾಚ್ಯಾ ಘರಾತ್ ಭುತ್ತುರ್ ಗುಸುಕ್‍ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ತಸೆ ಮನುನ್ ಪಿಲಾತುಚ್ ಭಾಯ್ರ್ ತೆಂಚೆಕ್ಡೆ ಯೆಲೊ, ಅನಿ ತೆನಿ ತೆಂಕಾ “ಹ್ಯಾ ಮಾನ್ಸಾಚಿ ಚುಕ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ತನ್ನಾ ತೆನಿ, “ತೆನಿ ಕಾಯ್ಬಿ ಚುಕ್ ಕರಲ್ಲಿ ನಸ್ಲ್ಯಾರ್, ಅಮಿ ತೆಕಾ ತುಜೆಕ್ಡೆ ಹಾನಿನಸಿ ಹೊತ್ತಾಂವ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ತನ್ನಾ ಪಿಲಾತಾನ್ ತೆಂಕಾ, “ತಸೆ ಜಾಲ್ಯಾರ್ ತುಮಿಚ್ ತೆಕಾ ಘೆವ್ನ್ ಜಾವಾ, ಅನಿ ತುಮ್ಚ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಕಾಯ್ ಕರ್‍ತಲೆ ಹಾಯ್ ತೆ ಕರಾ” ಮಟ್ಲ್ಯಾನ್ ತನ್ನಾ ತೆನಿ, “ಕೊನಾಕ್ಬಿ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿವ್ಕ್ ಅಮ್ಕಾ ಪರ್‍ವಾನ್ಗಿ ನಾ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ಅಪ್ನಿ ಕಸ್ಲ್ಯಾ ರಿತಿಚೆ ಮರಾನ್ ಮರ್‍ತಲೊ ಹಾಂವ್ ಮನುನ್ ಜೆಜುನ್ ಸಾಂಗಲ್ಲೆ ಪುರಾ ಹೊವ್‍ಸಾಟ್ನಿ ಅಶೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ಪಿಲಾತ್ ಭುತ್ತುರ್ ಘರಾತ್ ಗೆಲೊ ಅನಿ ಜೆಜುಕ್ ಬಲ್ವುಲ್ಯಾನ್, ಅನಿ “ತಿಯಾ ಜುದೆವಾಚೊ ರಾಜಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ತನ್ನಾ ಜೆಜುನ್, “ಹೆ ತಿಯಾಚ್ ಮಾಕಾ ಇಚಾರುಲಾಲೆ ಕಾಯ್ ಕೊನ್ತರ್ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ತುಕಾ ಸಾಂಗ್ಲ್ಯಾನಾತ್?” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ತನ್ನಾ ಪಿಲಾತಾನ್ “ತಿಯಾ ಕಾಯ್ ಮಿಯಾ ಜುದೆವ್ ಮನುನ್ ಚಿಂತ್ಲೆ ಕಾಯ್? ತುಜ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಲೊಕಾನಿ ಅನಿ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ತುಕಾ ಮಾಜ್ಯಾ ತಾಬೆತ್ ದಿಲ್ಯಾನಾತ್. ತಿಯಾ ಕಾಯ್ ಕರ್‍ಲೆ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ತನ್ನಾ ಜೆಜುನ್, “ಮಾಜೊ ರಾಜ್ ಹ್ಯಾ ಜಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೊ ನ್ಹಯ್! ಮಾಜೊ ರಾಜ್ ಹ್ಯಾ ಜಗಾಚೊ ರ್‍ಹಾಯ್ ಹೊತ್ತೊ ತರ್, ಜುದೆವ್ ಅದಿಕಾರ್‍ಯಾಂಚ್ಯಾ ತಾಬೆತ್ ಮಿಯಾ ಗಾವಿನಸಿ ಸರ್ಕೆ ಮಾಜೆ ವಾಂಗ್ಡಿ ಮಾರಾಮಾರಿ ಕರಿ ಹೊತ್ತಿ . ಮಾಜೊ ರಾಜ್ ಹ್ಯಾ ಜಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೊ ನ್ಹಯ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ತನ್ನಾ ಪಿಲಾತಾನ್ ತೆಕಾ, “ತಸೆ ಜಾಲ್ಯಾರ್ ತಿಯಾ ರಾಜಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ಜೆಜುನ್, “ಮಿಯಾ ರಾಜಾ ಮನುನ್ ತಿಯಾ ಮಟ್ಲೆ. ಮಿಯಾ ಉಪ್ಜುನ್ ಹ್ಯಾ ಜಗಾತ್ ಎಕ್ ಉದ್ದೆಸಾ ಸಾಟ್ನಿ ಯೆಲೊ, ತೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, ಖರ್‍ಯಾ ತ್ಯಾ ವಿಶಯಾತ್ ಬೊಲ್ತಲೆ, ಜೆ ಕೊನ್- ಕೊನ್ ಹ್ಯಾ ಖರೆಪಾನಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲೆ ಹಾತ್, ತೆನಿ ಮಿಯಾ ಸಾಂಗಲ್ಲೆ ಆಯಿಕ್ತ್ಯಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ತನ್ನಾ, “ಖರೆ ಮಟ್ಲ್ಯಾರ್ ಕಾಯ್?” ಮನುನ್ ಪಿಲಾತಾನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ಮಾನಾ ಪಿಲಾತ್ ಭಾಯ್ರ್ ಲೊಕಾನಿಕ್ಡೆ ಗೆಲೊ, ಅನಿ ತೆನಿ ತೆಂಕಾ “ಮಾಕಾ ತೆಚಿ ಕಾಯ್ಬಿ ಚುಕ್ ಗಾವುಕ್ನಾ”. ");
INSERT INTO kans_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ಖರೆ ಪದ್ದತಿ ಪರ್‍ಕಾರ್ ತುಮ್ಚ್ಯಾಸಾಟ್ನಿ ಮನುನ್ ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚ್ಯಾ ಎಳಾರ್ ಎಕ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಹೊತ್ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಸೊಡುನ್ ದಿತಲೆ ಮನುನ್ ಹಾಯ್ ನ್ಹಯ್, ಜುದೆವಾಂಚ್ಯಾ ರಾಜಾಕ್ ತುಮ್ಚ್ಯಾಸಾಟ್ನಿ ಮಿಯಾ ಸೊಡುನ್ ದಿವ್ ಕಾಯ್?, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ತನ್ನಾ ತೆನಿ,“ನಕ್ಕೊ, ತೆಕಾ ನಕ್ಕೊ ಅಮ್ಕಾ ಬಾರಾಬ್ಬಾಸ್ ಪಾಜೆ!” ಮನುನ್ ಬೊಬ್ ಮಾರುಂಗೆತ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ, ಬಾರಾಬ್ಬಾಸ್ ಎಕ್ ಹೊರಾಟ್ ಕರ್‍ತಲೊ ಮಾನುಸ್. ");
INSERT INTO kans_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ತನ್ನಾ ಪಿಲಾತಾನ್ ಜೆಜುಕ್ ಭೆಟ್ಲ್ಯಾನ್ ಅನಿ ಬಾರ್‍ಕೊಲಾನಿ ಮಾರುಕ್ ಲಾವ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ಸೈನಿಕಾನಿ ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಎಕ್ ಮುಕುಟ್ ಕರ್ಲ್ಯಾನಿ, ಅನಿ ಜೆಜುಚ್ಯಾ ಟಕ್ಲ್ಯಾರ್ ಘಾಟ್ಲ್ಯಾನಿ; ಮಾನಾ ತೆನಿ ತೆಕಾ ಎಕ್ ಜಾಂಬ್ಳ್ಯಾ ರಂಗಾಚೊ ಝಗೊ ನೆಸ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ಅನಿ ತೆಚೆಕ್ಡೆ ಯೆವ್ನ್ “ಜುದೆವಾಂಚ್ಯಾ ರಾಜಾ ತುಕಾ ಜೈ ಹೊಂವ್ದಿ” ಮಟ್ಲ್ಯಾನಿ, ಅನಿ ಜಾವ್ನ್ ತೆನಿ ತೆಕಾ ಠಪ್ರಾಕ್ಯಾ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ಪಿಲಾತ್ ಅನಿ ಎಗ್ದಾ ಭಾಯ್ರ್ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ಡೆ ಗೆಲೊ, ಅನಿ, “ಬಗಾ! ಮಾಕಾ ತೆಕಾ ಶಿಕ್ಷಾ ದಿ ಸರ್ಕೆ ಕಸ್ಲಿಬಿ ಚುಕ್ ಗಾವುಕ್ನಾ ಮನುನ್ ದಾಕ್ವುಸಾಟ್ನಿ ಮಿಯಾ ತೆಕಾ ತುಮ್ಚ್ಯಾ ಇದ್ರಾಕ್ ಹಾನುಲಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ಅಶೆ ಕಾಟ್ಯಾಂಚೆ ಕಿರಿಟ್ ಅನಿ ಜಾಂಬ್ಳೊ ಝಗೊ ನೆಸಲ್ಲೊ ಜೆಜು ಭಾಯ್ರ್ ಯೆಲೊ. ತನ್ನಾ ಪಿಲಾತಾನ್ ತೆಂಕಾ “ಬಗಾ! ಹ್ಯಾ ಮಾನ್ಸಾಕ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ, ಅನಿ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ರಾಕ್ವಾಲ್ಯಾನಿ ತೆಕಾ ಬಗಟಲ್ಲ್ಯಾ ಬರಬ್ಬರ್, “ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್! ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ಪಿಲಾತಾನ್ ತೆಂಕಾ “ತುಮಿಚ್ ತೆಕಾ ಘೆವ್ನ್ ಜಾವಾ, ಅನಿ ಕುರ್ಸಾರ್ ಮಾರಾ, ಮಾಕಾ ತೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ದಿ ಸರ್ಕೆ ಚುಕ್ ತೆಚ್ಯಾ ಭುತ್ತುರ್ ಗಾವುಕ್ನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ತನ್ನಾ ತ್ಯಾ ಜುದೆವಾನಿ “ಅಮ್ಕಾ ಎಕ್ ಖಾಯ್ದೊ ಹಾಯ್ ಅನಿ ತ್ಯಾ ಖಾಯ್ದ್ಯಾ ಪರ್‍ಕಾರ್ ಹೆಕಾ ಮರ್‍ನಾಚಿ ಶಿಕ್ಷಾ ಹೊವ್ಕ್ ಪಾಜೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಅಪ್ನಾಕುಚ್ ದೆವಾಚೊಲೆಕ್ ಮನುನ್ ಮಾನ್ತಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ಹೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಪಿಲಾತ್ ಅನಿ ಉಲ್ಲೊ ಭಿಂಯಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ತೊ ಪರ್ತುನ್ ಘರಾತ್ ಗೆಲೊ, ಅನಿ ಜೆಜುಕ್ “ತಿಯಾ ಖೈತ್ನಾ ಯೆಲೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ಖರೆ ಜೆಜುನ್ ಜಬಾಬ್ ದಿವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ಪಿಲಾತಾನ್ ತೆಕಾ, “ತಿಯಾ ಮಾಜಾಕ್ಡೆ ಬೊಲಿನಿ ಮಾಕಾ ತುಕಾ ಸೊಡುಕ್ ಅದಿಕಾರ್ ಹಾಯ್, ಅನಿ ಕುರ್ಸಾರ್ ಮಾರುಕ್ಬಿ ಅದಿಕಾರ್ ಹಾಯ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ತೆಕಾ ಜೆಜುನ್, “ತುಕಾ ಮಾಜೆ ವರ್ತಿ ಅದಿಕಾರ್ ಹಾಯ್ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ದೆವಾನ್ ತೊ ಅದಿಕಾರ್ ತುಕಾ ದಿಲ್ಯಾನಾಯ್, ತೆಚೆಸಾಟ್ನಿ ಜೊ ಕೊನ್ ಮಾಕಾ ತುಜ್ಯಾ ಹಾತಿತ್ ಒಪ್ಸುನ್ ದಿಲ್ಯಾನಾಯ್ ತೆಕಾ ಮೊಟೊ ಪಾಪ್ ಲಾಗ್ತಾ”. ");
INSERT INTO kans_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ಹೆ ಆಯ್ಕುನ್ ಪಿಲಾತ್ ಜೆಜುಕ್ ಸೊಡ್ತಲೊ ಎಕ್ ಅವ್ಕಾಸ್ ಗಾವ್ತಾ ಕಾಯ್ ಬಗುನ್‍ಗೆತ್ ಹೊತ್ತೊ. ಖರೆ ಜುದೆವಾನಿ ಬೊಬ್ ಮಾರುನ್ಗೆತ್, ತಿಯಾ ಹ್ಯಾ ಮಾನ್ಸಾಕ್ ಸೊಡ್ಲೆ ತರ್ ತಿಯಾ ಚಕ್ರವರ್ತಿಚೊ ದೊಸ್ತ್ ನ್ಹಯ್, ಜೆ ಕೊನ್ ಅಪ್ನಾಕುಚ್ ಎಕ್ ರಾಜಾ ಮನ್ತಾ ತೊ ಚಕ್ರವರ್ತಿಚ್ಯಾ ವಿರೊದುಚ್, ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ಹ್ಯಾ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಪಿಲಾತ್ ಜೆಜುಕ್ ಘರಾತ್ನಾ ಭಾಯ್ರ್ ಹನ್ಲ್ಯಾನ್, ಅನಿ , ಮಟ್ಲ್ಯಾರ್, ಗುಂಡ್ಯಾಚೊ ಕಟ್ಟೊ “ಹೆಬ್ರೆವ್ ಬಾಶೆನ್ ತೆಕಾ ಗಬ್ಬಾಥಾ ಮನ್ತ್ಯಾತ್” ತ್ಯಾ ಜಾಗ್ಯಾ ವರ್ತಿ ಬಸುನ್ ಝಡ್ತಿ ಕರುಕ್ ಬಸ್ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಬಸ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ಪಾಸ್ಕಾಚ್ಯಾ ಸನಾಚೊ ಅದ್ಲೊ ದಿಸ್ ತೊ ಜಗ್ಗೊಳ್-ಜಗ್ಗೊಳ್ ದೊಪಾರ್ ಹೊವ್ನಗೆತ್ ಯೆಲ್ಲಿ ತನ್ನಾ ಪಿಲಾತಾನ್ ಲೊಕಾಕ್ನಿ,“ಹಿತ್ತೆ ಬಗಾ ತುಮ್ಚೊ ರಾಜಾ!” ಹಾಯ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ತ್ಯಾ ಲೊಕಾನಿ, “ತೆಕಾ ಜಿವಾನಿ ಮಾರ್! ತೆಕಾ ಜಿವಾನಿ ಮಾರ್! ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ತನ್ನಾ ಪಿಲಾತಾನ್ ತೆಂಕಾ, “ಮಿಯಾ ತುಮ್ಚ್ಯಾ ರಾಜಾಕ್ ಕುರ್ಸಾರ್ ಮಾರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್, ತನ್ನಾ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ, “ಅಮ್ಕಾ ಎಕ್ಲೊಚ್ ಎಕ್ ರಾಜಾ ಹಾಯ್ ತೊ ಸಿಜರ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ತನ್ನಾ ಪಿಲಾತಾನ್ ಜೆಜುಕ್ ಕುರ್ಸಾರ್ ಮಾರುಸಾಟ್ನಿ ತೆಂಚ್ಯಾ ಹಾತಿತ್ ಒಪ್ಸುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ಅಶೆ ತೆನಿ ಜೆಜುಕ್ ಘೆಟ್ಲ್ಯಾನಿ ಅನಿ ಜೆಜುನ್ ಅಪ್ನಾಚೊ ಕುರಿಸ್ ವಾವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ಬುರ್‍ಡ್ಯಾಚೊ ಜಾಗೊ ಮನ್ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಯೆವ್ನ್ ಪಾವ್ಲೊ ತಶೆ ಮಟ್ಲ್ಯಾರ್ ಹೆಬ್ರೆವ್ ಬಾಶೆತ್ ಗೊಲ್ಗೊಥಾ ಮನ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ಥೈ ತೆನಿ ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್‍ಲ್ಯಾನಿ, ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ, ಅನಿ ದೊಗೆಜಾನಾಕ್ನಿಬಿ ಕುರ್ಸಾರ್ ಮಾರ್‍ಲ್ಯಾನಿ ತೆಂಕಾ ಹಿಕು-ತಿಕುಲ್ಯಾ ಬಾಜುಕ್, ಅನಿ ಜೆಜುಕ್ ಮದ್ದಿ ಕರುನ್ ಕುರ್ಸಾರ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ಪಿಲಾತಾನ್ ಎಕ್ ಫಳಿ ವರ್ತಿ “ಜೆಜು ನಜರೆನ್ ಜುದೆವಾಂಚೊ ರಾಜಾ” ಮನುನ್ ಲಿವ್ನ್ ಕುರ್ಸಾ ವರ್ತಿ ಲಾವಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ಸುಮಾರ್ ಲೊಕಾನಿ ಹೆ ವಾಚ್ವುಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಜೆಜುಕ್ ಕುರ್ಸಾ ವರ್ತಿ ಮಾರಲ್ಲೊ ಜಾಗೊ ಶಾರಾತ್ನಾ ಜಗೊಳ್ ಹೊತ್ತೊ, ತೆ ಲಿವಲ್ಲೆ, ಹೆಬ್ರೆವ್, ಲ್ಯಾಟಿನ್, ಅನಿ ಗ್ರಿಕ್ ಬಾಶೆತ್ ಲಿವಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ಮೊಟ್ಯಾ ಯಾಜಕಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಪಿಲಾತಾಕ್ಡೆ,“ಜುದೆವಾಂಚೊ ರಾಜಾ ಮನುನ್ ಲಿವ್‍ನಕೊ ಹ್ಯೊ ಮಾನುಸ್ ಅಪ್ನಿ ಜುದೆವಾಂಚೊ ರಾಜಾ ಮನುನ್ ಮನುಲಾಗಲ್ಲೊ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ತನ್ನಾ ಪಿಲಾತಾನ್ “ಜೆ ಕಾಯ್ ಮಿಯಾ ಲಿವ್ಲಾ, ತೆ ಲಿವ್ನ್ ಹೊಲಾ”, ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ಜೆಜುಕ್ ಕುರ್ಸಾರ್ ಮಾರುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಸೈನಿಕಾನಿ ತೆಚೆ ಕಪ್ಡೆ ಘೆಟ್ಲ್ಯಾನಿ ಅನಿ ಚಾರ್ ವಾಟೆ ಕರುನ್ ಎಗಳ್ಳ್ಯಾನಿ, ಎಕೆಕ್ ವಾಟೊ ಎಕೆಕ್ಲ್ಯಾನಿ ಚಾರ್ ಸೈನಿಕಾನಿ ತೆ ವಾಟುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ತೆನಿ ತೆಚೊ ಝಗೊಬಿ ಘೆಟ್ಲ್ಯಾನಿ. ತೊ ಎಕ್ ಸೈತ್ ಶಿವನ್ ನಸ್ತಾನಾ ವೈನಾ ಖಾಯ್ಲ್ ಪತರ್ ಎಕಾಕ್ನಾ ಗುತುನ್‍ಗೆತ್ ಯೆಲ್ಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ಸೈನಿಕಾನಿ ಎಕಾಮೆಕಾಕ್ನಿ “ಅಮಿ ಹ್ಯೊ ಪಿಂಜ್ತಲೊ ನಕ್ಕೊ, ಚಿಟಿಯಾ ಘಾಲುನ್ ಕೊನಾಕ್ ಯೆತಾ ಕಾಯ್ ಮನುನ್ ಬಗುವಾ” ಮಟ್ಲ್ಯಾನಿ. ಅಶೆ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್, “ತೆನಿ ಮಾಜೆ ಕಪ್ಡೆ ಅಪ್ನಾಂಚ್ಯಾ ಮದ್ದಿ ವಾಟುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ಅನಿ ಮಾಜ್ಯಾ ಝಾಗ್ಯಾಸಾಟ್ನಿ ಚಿಟಿಯಾ ಘಾಟ್ಲ್ಯಾನಿ”. ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಪುರಾ ಹೊಲೆ. ಸೈನಿಕಾನಿ ಅಸೆಚ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ಜೆಜುಚಿ ಬಾಯ್ ಮರಿ, ಜೆಜುಚ್ಯಾ ಬಾಯ್ಚಿ ಭೆನ್, ಕ್ಲಿಯೊಪಾಸಾಚಿ ಬಾಯ್ಕೊ ಮರಿ, ಅನಿ ಮರಿ ಮಾಗ್ದೆಲಿನಾ ಹೆನಿ ಥೈಚ್ ಜೆಜುಜ್ಯಾ ಕುರ್ಸಾ ಜಗ್ಗೊಳ್ ಇಬೆ ಹೊತ್ತ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕ್, ಅನಿ ಥೈ ಇಬೆ ಹೊತ್ತ್ಯಾ ಅಪ್ನಾಚ್ಯಾ ಪ್ರೆಮಾಚ್ಯಾ ಶಿಸಾಕ್ ಬಗಟ್ಲ್ಯಾನ್, ಅನಿ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಬಾಯ್ಕ್,“ಬಾಯಿ, ಹ್ಯೊ ತುಜೊ ಲೆಕ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ಮಾನಾ ತೆನಿ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಕ್, “ಹಿ ತುಜಿ ಬಾಯ್” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್, ತನ್ನಾಚ್ಯಾನ್ ತ್ಯಾ ಶಿಸಾನ್ ತಿಕಾ ಅಪ್ನಾಚಿ ಸ್ವತಾಚಿ ಬಾಯ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ಘರಾಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ಕಾಯ್ ಘಡ್ತಲೆ ಹಾಯ್ ತೆ ಸಗ್ಳೆ ಘಡುನ್ ಹೊಲೆ ಮನುನ್ ಜೆಜುಕ್ ಕಳ್ಳೆ. ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ಲೆ ಖರೆ ಹೊವ್‍ಸಾಟ್ನಿ ತೆನಿ, “ಮಾಕಾ ಸೊಸ್‍ ಲಾಗ್ಲಾ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ಅಂಬೊಟ್ಲಿ ವಾಯ್ನ್ ಭರುನ್ ಥವಲ್ಲೆ ಎಕ್ ಆಯ್ದಾನ್ ಥೈ ಹೊತ್ತೆ, ತಸೆಮನುನ್ ಎಕ್ ಕಾಪುಸ್ ಸರ್ಕೆ ಘೆವ್ನ್ ತ್ಯಾ ಬುರ್ಶ್ಯಾ ವಾಯ್ನಾತ್ ಬುಡ್ವುನ್, ಎಕ್ ಹಿಸ್ಸೊಪಾಚ್ಯಾ ಝಲ್ಲೆಕ್ ಲಾವುನ್ ಜೆಜುಚ್ಯಾ ಹೊಟ್ಟಾಂಚ್ಯಾ ಪತರ್ ವೈರ್ ಉಕ್ಲುನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ಜೆಜುನ್ ತಿ ಅಂಬೊಟ್ಲಿ ವಾಯ್ನ್ ಫಿಲ್ಯಾನ್, ಅನಿ,“ಸರ್ಲೆ” ಮಟ್ಲ್ಯಾನ್ ಅನಿ ಅಪ್ನಾಚಿ ಮಾನ್ ಬಾಗ್ವುಲ್ಯಾನ್ ಅನಿ ಅಪ್ನಾಚೊ ಜಿವ್ ಸೊಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ತನ್ನಾ ಜುದೆವಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನಿ ಕುರ್ಸಾರ್ ಮಾರಲ್ಲ್ಯಾಂಚೆ ಡೊಕೆ ಮೊಡುನ್ ತೆಂಚಿ ಮಡಿ ಕುರ್ಸಾನಿ ವೈನಾ ಉತ್ರುಕ್ ಪಿಲಾತಾಕ್ನಾ ಪರ್‍ವಾನ್ಗಿ ಘೆಟ್ಲ್ಯಾನಿ. ತೆಚೆಸಾಟ್ನಿ ತೆನಿ ತೊ ದಿಸ್ ಸುಕ್ರಾರ್, ಅನಿ ಸಬ್ಬಾತಾಚಿ ದಿಸಿ ಮಡಿ ಕುರ್ಸಾ ವರ್ತಿ ಥವ್ತಲೊ ಮನ್ ತೆಂಕಾ ನತ್ತೊ, ಹಿ ಪರ್‍ವಾನ್ಗಿ ಮಾಗುನ್ ಘೆಟಲ್ಲ್ಯಾನಿ, ಅನಿ ಹ್ಯೊ ಸಬ್ಬಾತ್‍ ತರ್ ಲೈ ವಿಶೆಸ್ ರಿತಿಚೊ ಪವಿತ್ರ್ ಸಬ್ಬಾತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ತಸೆಮನುನ್ ಸೈನಿಕಾ ಗೆಲಿ ಅನಿ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಕುರ್ಸಾರ್ ಮಾರಲ್ಲ್ಯಾ ದೊಗ್ಯಾಂಚೆಬಿ ಡೊಕೆ ಮೊಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ಖರೆ ತೆನಿ ಜೆಜುಕ್ಡೆ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ, ತೊ ಅದ್ದಿಚ್ ಮರಲ್ಲೊ ಹೊತ್ತೊ ಬಗಟ್ಲ್ಯಾನಿ, ತಸೆಮನುನ್ ತೆನಿ ತೆಚೆ ಡೊಕೆ ಮೊಡುಕ್‍ನ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ಎಕ್ ಸೈನಿಕಾನ್ ಕಶೆ ಕಾಯ್ಕಿ ಅಪ್ನಾಚ್ಯಾ ಬರ್ಚಿನಿ ಜೆಜುಚ್ಯಾ ಪಕ್ಡಿತ್ ಟೊಪ್ಲ್ಯಾನ್. ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ರಗಾತ್ ಅನಿ ಪಾನಿ ಭಾಯ್ರ್ ಪಡ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ಜೆ ಕೊನ್ ಹೆ ಬಗಟ್ಲಾ ತ್ಯೆನಿಚ್, ತಿಯಾ ವಿಶ್ವಾಸ್ ಕರುಸಾಟ್ನಿ ಮನುನ್ ಸಾಕ್ಷಿ ದಿಲ್ಯಾನಾಯ್ ಅನಿ ಜೆ ಕಾಯ್ ತೆನಿ ಸಾಂಗ್ಲ್ಯಾನಾಯ್ ತೆ ಖರೆ ಹಾಯ್ ಅನಿ ತೊ ಖರೆ ಬೊಲುಲಾ ಮನುನ್ ತೆಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","“ತೆಚೆ ಎಕ್ ಸೈತ್ ಹಡ್ಡ್ ಮೊಡುನ್ ಹೊಯ್ನಾ. ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಸಾಂಗಟಲ್ಲೆ ಖರೆ ಹೊವ್‍ಸಾಟ್ನಿ ಹೆ ಅಶೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ಅನಿ ಅನಿ ಎಕಾಕ್ಡೆ ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಮನ್ತಾ” ತಿ ಲೊಕಾ ಕೊನಾಕ್ ಟೊಪ್ತ್ಯಾತ್ ತೆಕಾ ಬಗ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ಹೆಚ್ಯಾ ಮಾನಾ, ಅರೆಮಾತಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ಜುಜೆನ್ ಪಿಲಾತಾಕ್ಡೆ ಜೆಜುಚೆ ಮಡೆ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಪರವಾನ್ಗಿ ಇಚಾರ್‍ಲ್ಯಾನ್. ಜುಜೆ ಎಕ್ ಜೆಜುಚ್ಯಾ ಫಾಟ್ನಾ ಹೊತ್ತೊ ಮಾನುಸ್, ಖರೆ ಹೆ ಕೊನಾಕ್ಬಿ ಗೊತ್ತ್ ನತ್ತೆ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಬಿ ಜುದೆವಾಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಕ್ನಿ ಭಿಂಯ್, ಪಿಲಾತಾನ್ ಜೆಜುಚೆ ಮಡೆ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಹೊತಾ ಮಟ್ಲ್ಯಾನ್, ತಸೆಮನುನ್ ಜುಜೆ ಗೆಲೊ, ಅನಿ ಜೆಜುಚೆ ಮಡೆ ತೆನಿ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ಎಕ್ ದಿಸ್ ರಾಚ್ಚೆಂಚೆ ಜೆಜುಕ್ ಬಗುಕ್ ಮನುನ್ ಯೆಲ್ಲೊ, ನಿಕೊದೆಮ್, ಜಗ್ಗೊಳ್-ಜಗ್ಗೊಳ್ ತಿಸ್ ಕಿಲೊವ್ ಹೊಯ್ಲ್ ತವ್ಡೆ ಸುಗಂದ್ ತೆಲ್ ಅನಿ ಲೊಳಿಸಾರ್ ಮಿಸಳಲ್ಲೆ ತೆಲ್ ಘೆವ್ನ್ ಜುಜೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ದೊಗೆಜಾನಾನಿ ಜೆಜುಚೆ ಮಡೆ ಘೆಟ್ಲ್ಯಾನಿ, ಅನಿ ಜುದೆವಾಂಚ್ಯಾ ಪದ್ದತಿ ಸರ್ಕೆ ಮಡೆ ಮಾಟಿ ದಿವ್ಕ್ ತಯಾರ್ ಕರುಸಾಟ್ನಿ ಲಾವ್ತಲೆ ತೆಲ್ ಲಾವುನ್ ಎಕ್ ಲೈ ಕಿಮ್ತಿಚ್ಯಾ ಕಪ್ಡ್ಯಾತ್ ಲಪಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ಜೆಜುಕ್ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾ ಜಾಗ್ಯಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಎಕ್ ಮ್ಹಳೊ ಹೊತ್ತೊ. ತ್ಯಾ ಮಳ್ಯಾತ್ ಅಜುನ್ ಪತರ್ ಕೊನಾಕ್ಬಿ ಮಾಟಿ ದಿ ನಸಲ್ಲಿ ಎಕ್ ಸಮಾದಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ತ್ಯಾತುರ್‍ಬಿ ತೊ ಸಬ್ಬಾತಾಚ್ಯಾ ಅದ್ಲೊ ದಿಸ್ ಹೊಲ್ಲೊ, ಅನಿ ತಿ ಸಮಾದಿಬಿ ಜಗ್ಗೊಳುಚ್ ಹೊತ್ತಿ ತಸೆಮನುನ್ ತೆನಿ ಜೆಜುಚೆ ಮಡೆ ತ್ಯಾ ಸಮಾದಿತ್ ಥವಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ಆಯ್ತಾರ್‍ಚೆ ಸಕ್ಕಾಳಿ ಫಿಡೆ, ಅಜುನ್ ಉಲ್ಲೊ ಕಾಳೊಕ್ ಹೊತ್ತೊ, ತನ್ನಾ ಮರಿ ಮಾಗ್ದೆಲಿನ್ ಸಮಾದಿಕ್ಡೆ ಯೆಲಿ, ಅನಿ ಸಮಾದಿಚ್ಯಾ ದಾರಾರ್ ಲಾವಲ್ಲೊ ಗುಂಡೊ ಕಡೆಕ್ ಸರಕಲ್ಲೊ ತೆನಿ ಬಗಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ತನ್ನಾ ತಿ ಪಳುನ್ಗೆತ್ ಸಿಮಾವ್ ಪೆದ್ರು, ಅನಿ ತ್ಯಾ ಜೆಜುಚ್ಯಾ ಪ್ರೆಮಾಚ್ಯಾ ಶಿಸಾಕ್ಡೆ ಗೆಲಿ, “ಅನಿ, ತೆನಿ ಧನಿಯಾಕ್ ಸಮಾದಿತ್ನಾ ಕಾಡುನ್ ನ್ಹೆಲ್ಯಾನಾತ್ ತೆನಿ ಖೈ ನ್ಹೆಲ್ಯಾನಾತ್ ಕಾಯ್ಕಿ” ಮನುನ್ ಸಾಂಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ತನ್ನಾ ಪೆದ್ರು, ಅನಿ ತೊ ಅನಿ ಎಕ್ಲೊ ಶಿಸ್ ಸಮಾದಿಕ್ಡೆ ಪಳುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ತೆನಿ ದೊಗೆಬಿ ಪಾಳುನ್ಗೆತ್ ಗೆಲೆ. ಖರೆ ತೊ ಅನಿ ಎಕ್ಲೊ ಶಿಸ್ ಪೆದ್ರುಚ್ಯಾನ್ಕಿ ಜೊರ್ ಪಳಾಲೊ, ಅನಿ ಸಮಾದಿಕ್ಡೆ ಜಾವ್ನ್ ಪಾವ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ತೆನಿ ಸಮಾದಿತ್ ಹಾನ್ಕುನ್ ಬಗಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ಜೆಜುಚ್ಯಾ ಮಡ್ಯಾಕ್ ಲಪ್ಟಲ್ಲೊ ಕಪ್ಡೊ ಎವ್ಡೊಚ್ ದಿಸ್ಲೊ, ತೊ ಭುತ್ತುರ್ ಜಾವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ಫಾಟ್ನಾ ಯೆಲ್ಲೊ ಸಿಮಾವ್ ಪೆದ್ರು, ನಿಟ್ ಸಮಾದಿತ್ ಭುತ್ತುರ್ ಗುಸ್ಲೊ, ತೊ ಮ್ಹಾಗ್ರೊ ಕಪ್ಡೊ ಖಾಲ್ತಿ ಪಡ್ತಲ್ಲೆ ಬಗಟಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ಅನಿ ಜೆಜುಚ್ಯಾ ಟಕ್ಲ್ಯಾರ್ ಲಪ್ಟಲ್ಲೊ ಕಪ್ಡೊ ಎವ್ಡೆಚ್ ತೆಕಾ ದಿಸ್ಲೆ, ತೊ ಕಪ್ಡೊ ಲೈ ಕಿಮ್ತಿಚ್ಯಾ ಕಪ್ಡ್ಯಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಪಡಲ್ಲೊ ನತ್ತೊ, ತೊ ಲಪ್ಟುನ್ ಥವಲ್ಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ತನ್ನಾ ತೊ ಅದ್ದಿ ಸಮಾದಿಕ್ಡೆ ಜಾವ್ನ್ ಪಾವಲ್ಲೊ ಅನಿ ಎಕ್ಲೊ ಶಿಸ್‍ಬಿ ಭುತ್ತುರ್ ಗೆಲೊ. ತೆನಿ ಹೆ ಸಗ್ಳೆ ಬಗಟ್ಲ್ಯಾನ್ ಅನಿ ವಿಶ್ವಾಸ್ ಕರ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ತೊ ಮರ್‍ನಾತ್ನಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುಕ್ ಪಾಜೆ ಮನುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾನ್ ಸಾಂಗಟಲ್ಲೆ ತೆಂಕಾ ಅಜುನ್ಬಿ ಕಳುಕ್ ನತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ಮಾನಾ ಶಿಸಾ ಪರ್ತುನ್ ಘರಾಕ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ಮರಿ ಮಾಗ್ದೆಲಿನ್ ಸಮಾದಿಚ್ಯಾ ಭಾಯ್ರ್ ರಡುಂಗೆತ್ ಇಬೆ ಹೊತ್ತಿ ತಿ ರಡ್ತಾರಡ್ತಾನಾಚ್, ತೆನಿ ಸಮಾದಿತ್ ಹಾನ್ಕುನ್ ಬಗಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ತನ್ನಾ ದೊಗೆ ಜಾನಾ ದೆವ್‍ದುತಾ ಫಾಂಡ್ರೆ ಕಪ್ಡೆ ನೆಸುನ್ ಜೆಜುಚೆ ಮಡೆ ಥವಲ್ಲ್ಯಾಕ್ಡೆ ಟಕ್ಲ್ಯಾಕ್ಡೆ ಎಕ್ಲೊ, ಅನಿ ಪಾಂಯಾಂಚ್ಯಾ ಬಾಜುಕ್ ಎಕ್ಲೊ ಬಸಲ್ಲೆ ತಿಕಾ ದಿಸ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ತನ್ನಾ ತ್ಯಾ ದೆವ್‍ದುತಾನಿ, “ಬಾಯಿ, ತಿಯಾ ಕಶ್ಯಾಕ್ ರಡುಲಾಲೆ?” ಮನುನ್ ತಿಕಾ ಇಚಾರ್‍ಲ್ಯಾನಿ. ತನ್ನಾ ತೆನಿ “ತೆನಿ ಧನಿಯಾಕ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಾತ್ ತೆಕಾ ತೆನಿ ಖೈ ಥವ್ಲ್ಯಾನಾತ್ ಮನುನ್ ಮಾಕಾ ಗೊತ್ತ್ ನಾ!” ಮನುನ್‍ ಜಬಾಬ್ ದಿಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ಮಾನಾ ತೆನಿ ಪರ್ತುನ್ ಬಗ್ತಾನಾ ಜೆಜು ಥೈಚ್ ಇಬೆ ಹೊತ್ತೊ, ಖರೆ ತೊ ಜೆಜುಚ್ ಮನುನ್ ತಿಕಾ ಕಳುಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ಜೆಜುನ್ ತಿಕಾ, “ಬಾಯಿ, ತಿಯಾ ಕಶ್ಯಾಕ್ ರಡುಲಾಲೆ?” ಮಟ್ಲ್ಯಾನ್, ಅನಿ “ತಿಯಾ ಕೊನಾಕ್ ಹುಡ್ಕುಲೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತೆನಿ ತೊ ತ್ಯಾ ಮಳ್ಯಾತ್ಲೊ ಕೊನ್ತರ್ ಅಶಿಲ್ ಮನುನ್ ಚಿಂತ್ಲಿನ್ ಅನಿ ತೆಕಾ, “ಸಾಯ್ಬಾ, ತಿಯಾ ತೆಕಾ ಘೆವ್ನ್ ಗೆಲೆ ಜಾಲ್ಯಾರ್, ತೆಕಾ ತಿಯಾ ಖೈ ಥವ್ಲೆ ಮನುನ್ ಮಾಕಾ ಸಾಂಗ್, ಮಿಯಾ ಜಾವ್ನ್ ತೆಕಾ ಘೆವ್ನ್ ಯೆತಾ” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ಜೆಜುನ್ ತಿಕಾ,“ಮರಿ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತಿ ತೆಚೆಕ್ಡೆ ಪರತ್ಲಿ, ಅನಿ, ಹೆಬ್ರೆವ್ ಬಾಶೆತ್, “ರಬ್ಬೊನಿ” ಮಟ್ಲಿನ್. ಅಶೆ ಮಟ್ಲ್ಯಾರ್ ಗುರುಜಿ ಮನುನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ತನ್ನಾ ಜೆಜುನ್ ತಿಕಾ, “ಮಾಕಾ ಧರುನ್ ಘೆವ್ನ್ ರಾವ್ನಕ್ಕೊ, ಮಿಯಾ ಅಜುನ್ ಮಾಜ್ಯಾ ಬಾಬಾಕ್ಡೆ ಫಾಟಿ ಪರ್ತುನ್ ಜಾವ್ಕ್ ನಾ, ಖರೆ ಜಾ ಅನಿ ಮಾಜ್ಯಾ ಭಾವಾಕ್ನಿ ಮಿಯಾ ಮಾಜ್ಯಾ ಬಾಬಾ ಅನಿ ತುಮ್ಚ್ಯಾ ಬಾಬಾಕ್ಡೆ, ಮಾಜ್ಯಾ ದೆವಾ ಅನಿ ತುಮ್ಚ್ಯಾ ದೆವಾಕ್ಡೆ ಪರ್ತುನ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ ಮನುನ್ ಸಾಂಗ್” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ಅಶೆ ಮರಿ ಮಾಗ್ದೆಲಿನ್ ಶಿಸಾನಿಕ್ಡೆ ಗೆಲಿ, ಅನಿ ಮಿಯಾ ಧನಿಯಾಕ್ ಬಗಟ್ಲೊ ಮನುನ್ ಸಾಂಗಟ್ಲಿನ್, ಅನಿ ತೆಂಚ್ಯಾ ವಿಶಯಾತ್ ಧನಿಯಾನ್ ತಿಚೆಕ್ಡೆ ಕಾಯ್-ಕಾಯ್ ಸಾಂಗಲ್ಲ್ಯಾನ್ ತೆ ಸಗ್ಳೆ ತೆನಿ ತೆಂಕಾ ಸಾಂಗಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ತ್ಯಾಚ್ ಆಯ್ತಾರ್‍ಚೆ ಸಾಂಚೆಕ್ಡೆ ಸಗ್ಳಿ ಶಿಸಾ ಜುದೆವಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಕ್ನಿ ಭಿಂವ್ನ್, ದಾರಾ ಧಾಪುನ್ ಘೆವ್ನ್ ಭುತ್ತುರ್ ಬಸಲ್ಲಿ ಹೊತ್ತಿ ತನ್ನಾ ಜೆಜು ಯೆಲೊ, ಅನಿ ತೆಂಚ್ಯಾ ಮದ್ದಿ ಇಬೆ ರ್‍ಹಾಲೊ, ಅನಿ ತೆಂಕಾ, “ಶಾಂತಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಂವ್ದಿತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ಹೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ತೆನಿ ಅಪ್ನಾಚಿ ಹಾತಾ, ಅನಿ ಪಕ್ಡಿತ್ ತೆಂಕಾ ದಾಕ್ವುಲ್ಯಾನ್ ಧನಿಯಾಕ್ ಬಗುನ್ ಶಿಸಾಕ್ನಿ ಲೈ ಕುಶಿ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ಅನಿ ಎಗ್ದಾ ಜೆಜುನ್ ತೆಂಕಾ, “ಶಾಂತಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಂವ್ದಿತ್, ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾ ಸರ್ಕೆ ಮಿಯಾಬಿ ತುಮ್ಕಾ ಧಾಡುನ್ ದಿತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ಮಾನಾ ತೆನಿ ತೆಂಚೆ ವರ್ತಿ ಅಪ್ನಾಚೊ ಶ್ವಾಸ್ ಸೊಡ್ಲ್ಯಾನ್, ಅನಿ,“ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಕ್ ಘೆವಾ, ");
INSERT INTO kans_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ತುಮಿ ಲೊಕಾಂಚಿ ಪಾಪಾ ಮಾಪ್ ಕರ್ಲ್ಯಾರ್ ತಿ ಮಾಪ್ ಕರುನ್ ಹೊತ್ಯಾತ್, ತುಮಿ ತಿ ಮಾಪ್ ಕರಿನಸ್ಲ್ಯಾರ್ ತಿ ಮಾಪ್ ಕರುನ್ ಹೊಯ್‍ನ್ಯಾತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ಬಾರಾ ಜಾನಾ ಶಿಸಾನಿತ್ಲೊ ದಿದಿಮೊಸ್ ಮಟ್ಲ್ಯಾರ್ ಅವ್ಲೊ ಅವ್ಳಿ-ಜವ್ಳಿ ಮನ್ತಲೊ ಥೊಮಸ್ ಜೆಜು ಥೈ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ನತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ತಸೆಮನುನ್ ಹುರಲ್ಲ್ಯಾ ಶಿಸಾನಿ ತೆಕಾ,“ಅಮಿ ಧನಿಯಾಕ್ ಬಗಟ್ಲಾವ್” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನಿ. ತನ್ನಾ ಥೊಮಸಾನ್,“ಮಿಯಾ ತ್ಯೆಚ್ಯಾ ಹಾತಾಂಚ್ಯಾ ವರ್ತಿ ಹೊತ್ತಿ ಮೊಳ್ಯಾಂಚಿ ವಳಕ್ ಬಗಟ್ಲ್ಯಾ ಶಿವಾಯ್ ಅನಿ ತ್ಯಾ ಮೊಳ್ಯಾಂಚ್ಯಾ ವಳ್ಕಿಯಾತ್ನಿ ಬೊಟ್ ಘಾಲುನ್ ಅನಿ ತ್ಯೆಚ್ಯಾ ಪಕ್ಡಿತ್ ಹಾತ್ ಘಾಲುನ್ ಬಗಟ್ಲ್ಯಾ ಶಿವಾಯ್ ವಿಶ್ವಾಸ್, ಕರಿನಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ಎಕ್ ವಾರಾಚ್ಯಾ ಮಾನಾ ಶಿಸಾ ದಾರಾ ಲಾವುನ್ ಘೆವ್ನ್ ಭುತ್ತುರ್ ಗೊಳಾ ಹೊವ್ನ್ ಹೊತ್ತಿ, ಅನಿ ಥೊಮಸ್‍ಬಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ. ದಾರಾ ಧಾಪಲ್ಲಿ ಹೊತ್ತಿ ಜಾಲ್ಯಾರ್‍ಬಿ ಜೆಜು ತೆಂಚ್ಯಾ ಮದ್ದಿ ಯೆವ್ನ್ ಇಬೆ ರ್‍ಹಾಲೊ, ಅನಿ, “ಶಾಂತಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾಂವ್ದಿತ್” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ಮಾನಾ ತೆನಿ ಥೊಮಸಾಕ್, “ಥೊಮಾಸಾ ಯೆ ಅನಿ ಮಾಜ್ಯಾ ಹಾತಾತ್ನಿ ತುಜೊ ಬೊಟ್ ಘಾಲುನ್ ಬಗ್, ಮಾನಾ ತುಜೊ ಹಾತ್ ಲಾಂಬ್ ಕರುನ್ ಮಾಜ್ಯಾ ಪಕ್ಡಿತ್ ಘಾಲುನ್ ಬಗ್, ಸಂಶೆವ್ ಕರ್‍ತಲೆ ಸೊಡ್, ಅನಿ ವಿಶ್ವಾಸ್ ಕರ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ತನ್ನಾ ಥೊಮಸಾನ್, “ಮಾಜ್ಯಾ ಧನಿಯಾ, ಮಾಜ್ಯಾ ದೆವಾ!” ಮನುನ್ ತೆಕಾ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ತನ್ನಾ ಜೆಜುನ್ ತೆಕಾ, “ತಿಯಾ ಮಾಕಾ ಬಗಟ್ಲೆ ಮನುನ್ ವಿಶ್ವಾಸ್, ಕರುಕ್ ಲಾಗ್ಲೆ, ಖರೆ ಮಾಕಾ ಬಗಿನಸ್ತಾನಾಚ್ ವಿಶ್ವಾಸ್ ಕರ್‍ತಲ್ಯಾಂಚೆ ಕವ್ಡೆ ಬರೆ ಅಸಿಲ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ಜೆಜುನ್ ಅಪ್ನಾಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಅನಿಬಿ ಲೈ ಅಜಾಪಾ ಕರಲ್ಲ್ಯಾನ್, ತಿ ಸಗ್ಳಿ ಹ್ಯಾ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲಿ ನಾತ್. ");
INSERT INTO kans_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ಖರೆ ಹೆ ಲಿವಲ್ಲೆ ಎವ್ಡೆ ತುಮಿ ಜೆಜು ಮೆಸ್ಸಿಯಾ, ದೆವಾಚೊಲೆಕ್ ಮನುನ್ ವಿಶ್ವಾಸ್ ಕರುಚೆ, ಅನಿ ತುಮಿ ತ್ಯೆಚ್ಯಾ ವರ್ತಿ ಥವಲ್ಲ್ಯಾ ವಿಶ್ವಾಸಾಚ್ಯಾ ವೈನಾ ತುಮಿ ಜಿವ್ ಖಮ್ವುನ್ ಘೆವ್ಸಾಟ್ನಿ ಲಿವಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ಹೆಚ್ಯಾ ಮಾನಾ ಜೆಜು ತಿಬೆರಿಯಸ್ ಮನ್ತಲ್ಯಾ ಸಮುಂದರಾತ್ ಅನಿ ಎಗ್ದಾ ಶಿಸಾಕ್ನಿ ದಿಸ್ತಾ ತೆ ಅಶೆ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ಸಿಮಾವ್ ಪೆದ್ರು, ಥೊಮಸ್, ಗಾಲಿಲಿಯಾತ್ಲ್ಯಾ ಕಾನಾ ಶಾರಾತ್ಲೊ ನಾಥಾನಾಯೆಲ್ ಜೆಬೆದೆವಾಚಿ ಲೆಕಾ, ಅನಿ ದೊಗೆಲೊಕಾ ಜೆಜುಚಿ ಶಿಸಾ ಎಕಾಕ್ಡೆ ಜಮಾ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ಸಿಮಾವ್ ಪೆದ್ರುನ್ ಹುರಲ್ಲ್ಯಾಕ್ನಿ“ಮಿಯಾ ಮಾಸೊಳ್ಯಾ ಧರುಕ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ “ಅಮಿಬಿ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ಯೆತಾಂವ್” ಮಟ್ಲ್ಯಾನಿ. ತಸೆಮನುನ್ ತೆನಿ ಢೊನ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ, ಖರೆ ಸಗ್ಳಿ ರಾತ್ಬರ್ ತೆಂಕಾ ಎಕ್ ಸೈತ್ ಮಾಸೊಳಿ ಗಾವುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ದಿಸ್ ಉಜ್ವಾಡ್ತಾನಾ ಜೆಜು ದಂಡೆಕ್ ಇಬೆ ಹೊತ್ತೊ, ಖರೆ ಶಿಸಾಕ್ನಿ ತೊ ಜೆಜುಚ್ ಮನುನ್ ಕಳುಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ದೊಸ್ತಾನೊ, ತುಮ್ಕಾ ಕಾಯ್ಬಿ ಗಾವುಕ್ನಾ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ “ನಾ, ಕಾಯ್ಬಿ ಮಾಸೊಳ್ಯಾ ಗಾವುಕ್ನಾ” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ತೆನಿ ತೆಂಕಾ, “ತುಮಿ ತುಮ್ಚಿ ಜಾಳಿ ಢೊನಿಚ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಟಾಕಾ, ತನ್ನಾ ತುಮ್ಕಾ ಕಾಯ್ಬಿ ಗಾವ್ತಾ,” ಮಟ್ಲ್ಯಾನ್ ತನ್ನಾ ತೆನಿ ಜಾಳೆ ಟಾಕ್ಲ್ಯಾನಿ ತನ್ನಾ ತೆಂಚ್ಯಾನ್ ಜಾಳೆ ವೊಡುಕ್ ಹೊಯ್ನಾ ಹೊಲೆ, ತವ್ಡ್ಯಾ ಮಾಸೊಳ್ಯಾ ತ್ಯಾತುರ್ ಪಡಲ್ಲ್ಯಾ. ");
INSERT INTO kans_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ಜೆಜುಚ್ಯಾ ತ್ಯಾ ಪ್ರೆಮಾಚ್ಯಾ ಶಿಸಾನ್ ಸಿಮಾವ್ ಪೆದ್ರುಕ್ “ಧನಿ ತೊ!” ಮಟ್ಲ್ಯಾನ್, ತೊ ಧನಿ ಮನುನ್ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಪೆದ್ರುನ್ ಅಪ್ನಾಚೆ ಕಪ್ಡೆ ನೆಸುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ಪಾನಿಯಾತ್ ಹುಡಿ ಮಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ಹುರಲ್ಲಿ ಶಿಸಾ ಮಾಸೊಳ್ಯಾನಿ ಭರಲ್ಲೆ ಜಾಳೆ ವೊಡುಂಗೆತ್ ದಂಡೆಕ್ ಯೆಲಿ, ತೆನಿ ದಂಡೆಕ್ನಾ ಧುರ್ ನತ್ತೆ ಸುಮಾರ್ ತಿನ್ಸೆ ಪುಟ್ ಭುತ್ತುರ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ತೆನಿ ದಂಡೆಕ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ಎಕ್ ಧುಮಿ ಪೆಟಲ್ಲಿ ಹೊತ್ತಿ ಅನಿ ತೆಚೆವರ್ತಿ ಮಾಸೊಳಿ, ಅನಿ ಉಲ್ಲಿ ಭಾಕ್ರಿ ಹೊತ್ತಿ ತೆನಿ ಬಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ತನ್ನಾ ಜೆಜುನ್ ತೆಂಕಾ, “ತುಮಿ ಧರಲ್ಲ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಮಾಸೊಳ್ಯಾ ಘೆವ್ನ್ ಯೆವಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ತನ್ನಾ ಸಿಮಾವ್ ಪೆದ್ರು ಡೊನಿಕ್ಡೆ ಗೆಲೊ, ಅನಿ ಮೊಟ್ಯಾ ಮೊಟ್ಯಾ ಮಾಸೊಳ್ಯಾ ಪಡಲ್ಲೆ ಜಾಳೆ ದಂಡೆಕ್ ವೊಡುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಎಕ್ಸೆ ಪನ್ನಾಸಾರ್ ತಿನ್ ಮಾಸೊಳ್ಯಾ ಹೊತ್ತ್ಯಾ ತ್ಯಾ ತವ್ಡ್ಯಾ ಲೈ ಮಾಸೊಳ್ಯಾ ರ್‍ಹಾಲ್ಯಾರ್‍ಬಿ ಜಾಳೆ ಪಿಂಜುಕ್ ನತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ಜೆಜುನ್ ತೆಂಕಾ,“ಯೆವಾ ಅನಿ ಖಾವಾ” ಮಟ್ಲ್ಯಾನ್, ತೆಕಾ “ತಿಯಾ ಕೊನ್?” ಮನುನ್ ಇಚಾರುಕ್ ಶಿಸಾನಿತ್ಲ್ಯಾ ಕೊನಾಕ್ಬಿ ಧೈರೊ ಹೊವ್ಕ್ ನಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಧನಿಚ್ ಮನುನ್ ತೆಂಕಾ ಕಳಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ಅಶೆ ಜೆಜು ಯೆಲೊ, ಅನಿ ಭಾಕ್ರಿ ಘೆಟ್ಲ್ಯಾನ್ ಅನಿ ತೆಂಕಾ ದಿಲ್ಯಾನ್ ಮಾಸೊಳಿಬಿ ತಸೆಚ್ ಕರುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ಅಸೆ, ಜೆಜು ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟಲ್ಲ್ಯಾಕ್ನಾ ತಿನ್ವೆಪಟಿ ಶಿಸಾಕ್ನಿ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ತೆಂಚೆ ಖಾವ್ನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುನ್ ಸಿಮಾವ್ ಪೆದ್ರುಕ್, “ಸಿಮಾವ್ ಜುವಾಂವಾಚ್ಯಾ ಲೆಕಾ ತಿಯಾ ಸಗ್ಳ್ಯಾಚ್ಯಾನ್ಕಿ ಜಾಸ್ತಿ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ತೆ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ಪೆದ್ರುನ್ “ಹೊಯ್ ಧನಿಯಾ, ಮಿಯಾ ತುಜೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ಮನುನ್ ತುಕಾಚ್ ಗೊತ್ತ್ ಹಾಯ್‍” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ಜೆಜುನ್ ತೆಕಾ, “ಮಾಜ್ಯಾ ಬೊಕ್ಡಾಕ್ನಿ ಚಾರ್‍ವು” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ಅನಿ ಎಕ್ ಉಲ್ಲೊ ಎಳ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಜೆಜುನ್ ಪೆದ್ರುಕ್, “ಸಿಮಾವ್ ಜುವಾಂವಾಚ್ಯಾ ಲೆಕಾ ತಿಯಾ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ತೆ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ತನ್ನಾ ತೆನಿ, “ಹೊಯ್, ಮಿಯಾ ತುಜೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ಮನುನ್ ತುಕಾ ಗೊತ್ತ್ ಹಾಯ್” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ಜೆಜುನ್ ತೆಕಾ, “ಮಾಜ್ಯಾ ಬಕ್ರ್ಯಾಕ್ನಿ ಬಗುನ್ ಘೆ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ತಿನ್ವೆಪಟಿ ಜೆಜುನ್, “ಸಿಮಾವ್ ಜುವಾಂವಾಚ್ಯಾ ಲೆಕಾ, ತಿಯಾ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ತೆ ಕಾಯ್?” ಮಟ್ಲ್ಯಾನ್. ಜೆಜುನ್ ತಿನ್ವೆಪಟಿ “ತಿಯಾ ಮಾಜೊ ಪ್ರೆಮ್ ಕರ್‍ತೆ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ತಾನಾ ಪೆದ್ರುಕ್ ಜೆಜಾರ್ ದಿಸ್ಲೊ, ಅನಿ ತೆನಿ “ಧನಿಯಾ ತುಕಾ ಸಗ್ಳೆ ಗೊತ್ತ್ ಹಾಯ್, ಮಿಯಾ ತುಜೊ ಪ್ರೆಮ್ ಕರ್‍ತಾ ಮನುನ್ ತುಕಾ ಗೊತ್ತ್ ಹಾಯ್!” ಮನುನ್ ಮಟ್ಲ್ಯಾನ್ ಜೆಜುನ್ ತೆಕಾ,“ಮಾಜ್ಯಾ ಬಕ್ರ್ಯಾಕ್ನಿ ಚಾರ್‍ವು, ");
INSERT INTO kans_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ಮಿಯಾ ತುಕಾ ಖರೆ ಹೊತ್ತೆ ಸಾಂಗುಕ್ ಲಾಗ್ಲಾ, ತಿಯಾ ದಾಂಡ್ಗೊ ಹೊತ್ತ್ಯಾ ತನ್ನಾ ತಯಾರ್ ಹೊಯ್ಸ್, ಅನಿ ತುಕಾ ಖೈ ಜಾತಲೆ ಹಾಯ್ ಥೈ ಜಾಯ್ಸ್, ಖರೆ ತಿಯಾ ಮ್ಹಾತಾರೊ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ತಿಯಾ ತುಜಿ ಹಾತಾ ವೈರ್ ಕರ್‍ತೆ, ಅನಿ ಕೊನ್ಬಿ ದುಸ್ರೆಚ್ ತುಕಾ ಕಪ್ಡೆ ನೆಸ್ವುತಾತ್ ಅನಿ ತುಕಾ ಮನ್‍ ನಸಲ್ಲ್ಯಾಕ್ಡೆ ಘೆವ್ನ್ ಜಾತಾತ್” ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ಹೆ ಸಾಂಗುನ್ ಜೆಜುನ್ ಪೆದ್ರು ದೆವಾಚ್ಯಾ ನಾವಾಕ್ ಮಹಿಮಾ ಹಾನುಕ್ ಮನುನ್ ಕಸ್ಲೆ ಮರಾನ್ ಮರ್‍ತಲೊ ಹಾಯ್ ಮನುನ್ ದಾಕ್ವುನ್ ದಿಲ್ಯಾನ್. ಮಾನಾ ಜೆಜುನ್ ತೆಕಾ,“ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ಪೆದ್ರು ಫಾಟಿ ಪರತಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ತೊ ಜೆಜುಚೊ ಪ್ರೆಮಾಚೊ ಅನಿ ಎಕ್ಲೊ ಶಿಸ್, ಜೆವ್ನಾಚ್ಯಾ ಎಳಾರ್ ಜೆಜುಚ್ಯಾ ಬಾಜುಕ್ ಬಸಲ್ಲೊ, ಅನಿ ಜೆಜುಚ್ಯಾ ಜಗ್ಗೊಳ್ ವ್ಹಾಕುನ್ “ಧನಿಯಾ ತುಕಾ ಘಾತ್ ಕರ್‍ತಲೊ ಕೊನ್ ತೊ?” ಮನುನ್ ಇಚಾರಲ್ಲೊ ಶಿಸ್ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ಪೆದ್ರುನ್ ತೆಕಾ ಬಗಟಲ್ಲ್ಯಾ ತನ್ನಾ ಜೆಜುಕ್ “ಧನಿಯಾ ಹ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಬದಲ್ ತಿಯಾ ಕಾಯ್ ಮನ್ತೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ಜೆಜುನ್ ತೆಕಾ, “ಮಿಯಾ ಯೆಯ್ ಪತರ್ ತೊ ಝಿತ್ತೊ ರ್‍ಹಾವ್ಕ್ ಪಾಜೆ, ಮನುನ್ ರ್‍ಹಾಲ್ಯಾರ್, ತೆ ಸಗ್ಳೆ ತುಕಾ ಕಾಯ್? ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆ!” ಮನುನ್ ಜಬಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","“ಅಶೆ ಹೊವ್ನ್ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾಂಚ್ಯಾ ಮದ್ದಿ ಹ್ಯೊ ಶಿಸ್ ಮರುಚೆ ನೈಯ್‍ ಮನ್ತಲಿ ಖಬರ್ ಉಟ್ಲಿ”. ಖರೆ ತೊ ಮರ್‍ತಲೆ ನಕ್ಕೊ ಮನುನ್ ಜೆಜುನ್ ಸಾಂಗುಕ್‍ನಾ. ತೆನಿ, “ಮಿಯಾ ಯೆಯ್ ಪತರ್ ಜರ್ ತರ್ ತೊ ಝಿತ್ತೊ ರ್‍ಹಾವ್ಕ್ ಪಾಜೆ ಮನುನ್ ಮಾಕಾ ಪಾಜೆ ಹೊಲ್ಯಾರ್, ತುಕಾ ಕಶ್ಯಾಕ್ ಪಾಜೆ ತೆ?” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ತೊಚ್ ತೊ ಶಿಸ್ ಹಿ ಸಗ್ಳಿ ವಿಶಯಾ ಸಾಂಗಟಲ್ಲೊ, ಅನಿ ಸಗ್ಳೆ ಲಿವ್ನ್ ಥವಲ್ಲೊ: ಅನಿ ತೆನಿ ಸಾಂಗಟಲ್ಲಿ ಸಾಕ್ಷಿ ಖರಿ ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ಜೆಜುನ್ ಕರಲ್ಲಿ ಕಾಮಾ, ಅನಿ ಲೈ ಹಾತ್ ತಿ ಸಗ್ಳಿ ಎಕಾಚ್ಯಾ ಮಾನಾ ಎಕ್ ಲಿವ್ಲ್ಯಾರ್, ತಿ ಲಿವ್‍ಸಾಟಿ ಪಾಜೆ ಹೊಲ್ಲಿ ಪುಸ್ತಕಾ ಹ್ಯಾ ಜಗಾಕುಚ್ ಅಟ್ಪಿನಸಿ ಹೊತ್ತಿ ಕಾಯ್ಕಿ ಮನುನ್ ಮಾಕಾ ದಿಸ್ತಾ .");
INSERT INTO kans_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ಪ್ರೆಮಾಚ್ಯಾ ಥಿಯೊಫಿಲಸ್, ಮಾಜ್ಯಾ ಪಯ್ಲೆಚ್ಯಾ ಪುಸ್ತಕಾತ್ ಜೆಜುನ್ ಅಪ್ಲಿ ಕಾಮಾ ಸುರು ಕರಲ್ಲ್ಯಾ ಎಳಾಕ್ನಾ ಜೆಜುನ್ ಕರಲ್ಲಿ ಅನಿ ಶಿಕ್ವಲ್ಲಿ ಸಗ್ಳಿ ವಿಶಯಾ ಮಿಯಾ ಲಿವ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ಸರ್ಗಾರ್ ತೆಕಾ ಘೆವ್ನ್ ಗೆಲ್ಲ್ಯಾ ದಿಸಾ ಪತರ್, ಅನಿ ಅಪ್ನಾಚಿ ಅಪೊಸ್ತಲಾ ಮನುನ್ ಎಚುನ್ ಕಾಡಲ್ಲ್ಯಾಕ್ನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚ್ಯಾ ಬಳಾ ವೈನಾ ತೆನಿ ಶಿಕ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ಅಪ್ನಾಚ್ಯಾ ಮರ್‍ನಾಚ್ಯಾ ಮಾನಾಚ್ಯಾ ಎಳಾರ್ ಅಪ್ನಿ ಅನಿ ಪರ್ತುನ್ ಝಿತ್ತೊ ಹೊಲಾ ಮನುನ್ ಸುಮಾರ್ ಖಾತ್ರಿಯಾಂಚ್ಯಾ ವೈನಾ ತೆನಿ ದಾಕ್ವುನ್ ದಿಲ್ಯಾನ್, ಅನಿ ತೊ ಚಾಳಿಸ್ ದಿಸ್ ಪತರ್ ತೆಂಚ್ಯಾ ನದ್ರೆಕ್ ಪಡ್ಲೊ, ಅನಿ ದೆವಾಚ್ಯಾ ರಾಜಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುನ್ಗೆತ್ ತೆಂಚ್ಯಾಕ್ಡೆ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ಎಗ್ದಾ ತಸಿ ಎಕಾಕ್ಡೆ ತೊ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವಾನ್ ಕರುಕ್ ಲಾಗಲ್ಲೊ ತೆನಿ ತೆಂಕಾ ಅಶೆ ತಾಕಿತ್ ದಿಲ್ಯಾನ್ ಜೆರುಜಲೆಮ್ ಸೊಡುನ್ ಜಾವ್‍ನಕಾಶಿ , ಖರೆ ಮಾಜ್ಯಾ ಬಾಬಾನ್ ಗೊಸ್ಟ್ ದಿಲ್ಲ್ಯಾ ಭೊಮಾನಾಚಿ ವಾಟ್ ರಾಕಾ, ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಮಿಯಾ ಬೊಲ್ತಾನಾ ತುಮಿ ಆಯಿಕ್ಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಜುವಾಂವಾನ್ ಪಾನಿಯಾನ್ ಬಾಲ್ತಿಮ್ ದಿಲ್ಯಾನ್, ಖರೆ ಅನಿ ಎಕ್ ಉಲ್ಲ್ಯಾ ದಿಸಾನಿ ತುಮ್ಕಾ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನಿ ಬಾಲ್ತಿಮ್ ದಿವ್ನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ಅಶೆ ಅಪೊಸ್ತಲಾ ಜೆಜುಚ್ಯಾ ಭೊತ್ಯಾನ್ ಎಕಾಕ್ಡೆ ಗೊಳಾ ಹೊಲಿ, ಅನಿ ತೆಕಾ, “ಧನಿಯಾ ತಿಯಾ ಇಸ್ರಾಯೆಲಾಚೆ ರಾಜ್ ಅನಿ ಎಗ್ದಾ ಭಾಂದ್ತಲೆ ಹ್ಯಾಚ್ ಎಳಾರ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ಖರೆ ತೆನಿ ತೆಂಕಾ ಜಬಾಬ್ ದಿವ್ನ್ ಮಟ್ಲ್ಯಾನ್ ಬಾಬಾನ್ ಅಪ್ಲ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಅದಿಕಾರಾನ್ ನಿರ್ಧಾರ್ ಕರಲ್ಲೊ ಎಳ್ ಅನಿ ದಿಸ್ ಸಮ್ಜುನ್ ಘೆತಲೆ ಕಾಮ್ ತುಮ್ಚೆ ನ್ಹಯ್, ");
INSERT INTO kans_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ಖರೆ ಪವಿತ್ರ್ ಆತ್ಮೊ ತುಮ್ಚ್ಯಾ ವರ್‍ತಿ ಯೆತಾ ತನ್ನಾ ತುಮ್ಕಾ ಬಳ್ ಗಾವ್ತಾ. ಮಾನಾ ಜೆರುಜಲೆಮಾಕ್ ,ಸಗ್ಳ್ಯಾ ಜುದೆಯ್ ಪ್ರಾಂತ್ಯಾತ್ ಅನಿ ಸಮರ್ಯಾತ್‍ ಅನಿ ಜಗಾಚ್ಯಾ ಆಕ್ರಿ ಪತರ್ಬಿ ತುಮಿ ಮಾಕಾ ಸಾಕ್ಷಿ ಹೊವ್ನ್ ರ್‍ಹಾತ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ಜೆಜುನ್ ಹೆ ಸಗ್ಳೆ ಸಾಂಗುನ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಬಗುನ್ಗೆತ್ ರ್‍ಹಾತಾನಾಚ್ ತೆಕಾ ವೈರ್ ಉಕ್ಲುನ್ ನ್ಹೆವ್ನ್ ಹೊಲೆ ಅನಿ ತೆಂಚ್ಯಾ ಡೊಳ್ಯಾಂಚ್ಯಾ ಇದ್ರಾಕ್ನಾ ತೆಕಾ ಮೊಡಾನ್ ನಿಪ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ಅಶೆ ಚಡುನ್ಗೆತ್ ಜಾತಾನಾ ಅನಿ ತೆನಿ ಮಳ್ಬಾಕುಚ್ ನದರ್ ಲಾವ್ನ್ ರ್‍ಹಾತಾನಾ ಪಾಂಡ್ರೆ ಕಪ್ಡೆ ನೆಸಲ್ಲೆ ದೊಗೆ ಜನಾ ಎಗ್ದಮ್ ತೆಂಚ್ಯಾಕ್ಡೆ ಯೆವ್ನ್ ಇಬೆ ರ್‍ಹಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ಅನಿ ತೆನಿ ಮನುಕ್ ಲಾಗ್ಲೆ, “ಗಾಲಿಲಿಯಾಚ್ಯಾ ಮಾನ್ಸಾನು, ತುಮಿ ಅಶೆ ಮಳ್ಬಾಕ್ ನದರ್ ಲಾವ್ನ್ ಘೆವ್ನ್ ಕಶ್ಯಾಕ್ ಇಬೆ ರ್‍ಹಾಲ್ಯಾಶಿ? ಹ್ಯೊ ತುಮ್ಚ್ಯಾ ಮದ್ಲೊ ವೈರ್ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಹೊಲ್ಲೊ ಜೆಜು, ಕಸೊ ತುಮಿ ತೆಕಾ ಸರ್ಗಾರ್ ಚಡುನ್ ಜಾತಾನಾ ಬಗುಕ್ ಲಾಗ್ಲ್ಯಾಸಿ ತೆಸೊಚ್ ಅನಿ ಪರ್ತುನ್ ತೊ ಯೆತಾ”. ");
INSERT INTO kans_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ಮಾನಾ ತೆನಿ ಒಲಿವೆತ್ ಮನುನ್ ನಾಂವ್ ಹೊತ್ತ್ಯಾ ಮಡ್ಡಿ ವೈನಾ ಜೆರುಜಲೆಮಾಕ್ ಫಾಟಿ ಯೆಲ್ಯಾನಿ ಜೆರುಜಲೆಮಾತ್ನಾ ಒಲಿವೆತ್ ಲೈ ಧುರ್ ನಾ, ಲೈ ಲೈ ಮಟ್ಲ್ಯಾರ್ ಅರ್‍ದೊ ಮೈಲ್ ಧುರ್ ಅಸಿಲ್. ");
INSERT INTO kans_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ಶಾರಾತ್ ಯೆವ್ನ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ತೆನಿ ರ್‍ಹಾಯ್ತ್ ತ್ಯಾ ಮಾಳ್ಗಿಚ್ಯಾ ಖೊಲಿತ್ ತೆನಿ ಗೆಲ್ಯಾನಿ: ಪೆದ್ರು ಅನಿ ಜುವಾಂವ್ ಜಾಕೊಬ್ ಅನಿ ಆಂದ್ರೆ, ಫಿಲಿಪ್ ಅನಿ ಥೊಮಸ್ , ಬಾರ್‍ತೊಲೊಮೆವ್ ಅನಿ ಮಾತೆವ್, ಅಲ್ಫೆವಾಚೊ ಲೆಕ್ ಜಾಕೊಬ್ ಅನಿ ಹೊರಾಟ್ ಕರ್‍ತಲೊ ಸಿಮಾವ್ ಅನಿ ಜಾಕೊಬಾಚೊ ಲೆಕ್ ಜುದ್ ಯೆವ್ಡೆ ಜನಾ ಖೊಲಿತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ಅನಿ ಜೆಜುಚೆ ಬಾಯ್ ಮರಿ ಮಿಳುನ್ ಅನಿ ಉಲ್ಲಿ ಬಾಯ್ಕಾಮಾನಸ್ಸಾ ಅನಿ ಜೆಜುಚಿ ಭಾವಾಬಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ. ಅಶೆ ತೆನಿ ಎಕ್ ಮನಾನ್ ಗೊಳಾ ಹೊವ್ನ್ ಮಾಗ್ನಿ ಕರಿತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ತ್ಯಾಚ್ ದಿಸಾತ್ನಿ ಸುಮಾರ್ ಎಕ್ಸೆವಿಸ್ ಜನಾ ವಿಶ್ವಾಸಾತ್ ಹೊತ್ತಿ ಲೊಕಾ ಜಮಲ್ಲ್ಯಾ ಎಳಾರ್ ಪೆದ್ರು ತೆಂಚ್ಯಾ ಮದ್ದಿ ಇಬೆ ರ್‍ಹಾವ್ನ್ ಅಶೆ ಮನುಕ್ ಲಾಗ್ಲೊ, ");
INSERT INTO kans_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ಭಾವಾನು ಅನಿ ಭೆನಿಯಾನು ದಾವಿದಾಚ್ಯಾ ತೊಂಡಾತ್ನಾ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಸಾಂಗಲ್ಲೆ ಜೆಜುಕ್ ಘಾತ್ ಕರುನ್ ಧರುನ್ ದಿತಲ್ಯಾ ಜುದಾಸಾಚ್ಯಾ ವಿಶಯಾತ್ ಲಿವಲ್ಲೆ ಖರೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ತೊ ಅಮ್ಚ್ಯಾಚ್ ತಾಂಡ್ಯಾತ್ಲೊ ಅನಿ ಅಮ್ಚ್ಯಾ ಸೆವೆಚ್ಯಾ ಕಾಮಾತ್ ತೊ ಬಿ ಎಚುನ್ ಕಾಡಲ್ಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ಹ್ಯಾ ಮಾನ್ಸಾನ್ ಅಪ್ನಾಚ್ಯಾ ಖೊಟ್ಯಾ ಕಾಮಾನ್ ಕಮ್ವಲ್ಲ್ಯಾ ಪೈಸ್ಯಾನ್ ಎಕ್ ಸೆತ್ ಇಕಾತ್ ಘೆಟ್ಲ್ಯಾನ್, ತ್ಯಾತುರ್ ತೊಂಡಾನಿ ಪಡುನ್ ತೆಚೆ ಪೊಟ್ ಫುಟ್ಲೆ ಅನಿ ತೆಚಿ ಸಗ್ಳಿ ಅಂತ್ಡಾ ಭಾಯ್ರ್ ಪಡ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ಜೆರುಜಲೆಮಾತ್ ಜಿವನ್ ಕರ್‍ತಲ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಹಿ ಖಬರ್ ಕಳ್ಳಿ, ಅಶೆ ತ್ಯಾ ಸೆತಾಕ್ ತೆಂಚ್ಯಾ ಬಾಶೆತ್ ಅಕೆಲ್ತಾಮಾ ಮಟ್ಲ್ಯಾರ್ ರಗ್ತಾಚೆ ಸೆತ್ ಮನುನ್ ನಾಂವ್ ಪಡ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ಕಿರ್ತನಾಂಚ್ಯಾ ಪುಸ್ತಕಾತ್ ಅಶೆ ಲಿವಲ್ಲೆ ಹಾಯ್: ತೆಚೆ ಘರ್ ಹಾಳ್ ಪಡುಂದಿತ್, ಕೊನ್‍ಬಿ ತ್ಯಾತುರ್ ವಸ್ತಿ ಕರುನಸುಂದಿತ್. ಅನಿ ಹೆ ಸೊಡುನ್ ಅಶೆ ಬಿ ಲಿವಲ್ಲೆ ಹಾಯ್: ತೆಚೊ ಹುದ್ದೊ ಅನಿ ಎಕ್ಲೊ ಘೆಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ಅಶೆ ರ್‍ಹಾತಾನಾ, ಧನಿ ಜೆಜು ಅಮ್ಚ್ಯಾ ಮದ್ದಿ ವಸ್ತಿ ಕರಿ ತ್ಯಾ ಎಳಾರ್ ಅಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ಎಕ್ ಮಾನ್ಸಾಕ್ ಎಚುನ್ ಕಾಡ್ತಲೆ ಗರ್ಜೆಚೆ. ");
INSERT INTO kans_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ಜುವಾಂವ್ ಬಾಲ್ತಿಮ್ ದಿಲ್ಲ್ಯಾ ಎಳಾಕ್ನಾ ಶುರು ಕರುನ್ ಜೆಜುಕ್ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಹೊಲ್ಲೆ ತ್ಯಾ ಎಳಾ ಪತರ್ ಹೆಂಚ್ಯಾತ್ಲೊ ಎಕ್ಲೊ ಅಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ತೆಚ್ಯಾ ಅನಿ ಪರ್ತುನ್ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟಲ್ಯಾಚಿ ಸಾಕ್ಷಿ ಹೊವ್ಕ್ ಪಾಜೆ. ");
INSERT INTO kans_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ತೆನಿ ದೊಗ್ಯಾಂಚಿ ನಾವಾ ಎಚುನ್ ಕಾಡ್ಲ್ಯಾನಿ: ಬಾರ್ಸಾಬ್ಬಾಸ್ ಮನ್ತಲೊ ಜುಜೆ ತೆಕಾ ಜುಸ್ತ್ ಮನುನ್ಬಿ ಬಲ್ವಿತ್ ಅನಿ ಮಾಥ್ಥಿಯಾಸ್. ");
INSERT INTO kans_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ಮಾನಾ ತೆನಿ ಅಶೆ ಮಾಗ್ನೆ ಕರ್‍ಲ್ಯಾನಿ: “ಧನಿಯಾ ಸಗ್ಳ್ಯಾಂಚಿ ಭುತ್ತುರ್‍ಲಿ ಮಾನಾ ತುಕಾ ಗೊತ್ತ್ ಹಾತ್. ದೊಗ್ಯಾಂಚ್ಯಾ ಭುತ್ತುರ್‍ಲ್ಯಾ ಕೊನಾಕ್ ತಿಯಾ ಎಚುನ್ ಕಾಡ್ಲೆ ದಾಕ್ವು, ");
INSERT INTO kans_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ಅಶೆ ಹೊವ್ನ್ ತೆನಿ ಸೆವಕಾಚೊ ಅನಿ ಅಪೊಸ್ತಲಾಚೊ ಜಾಗೊ ಘೆಂವ್ದಿತ್, ಜುದಾಸ್ ಹೊ ಜಾಗೊ ಸೊಡುನ್ ಗೆಲಾ.” ");
INSERT INTO kans_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ಮಾನಾ ತೆಂಚ್ಯಾ ದೊಗ್ಯಾಂಚ್ಯಾ ಮದ್ದಿ ಚಿಟಿಯಾ ಘಾಟ್ಲ್ಯಾನಿ ಅನಿ ಮಾಥ್ಥಿಯಾಸಾಚೆ ನಾವ್ ವೈರ್ ಪಡ್ಲೆ ಅಶೆ ತೆಕಾ ಅಕ್ರಾ ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ಭುತ್ತುರ್ ಘೆವ್ನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ಪೆಂತೆಕೊಸ್ತಾಚ್ಯಾ ಸನಾದಿಸಿ ದೆವಾಚಿ ಸಗ್ಳ್ಯಿ ಲೊಕಾ ಎಕ್ ಜಾಗ್ಯಾರ್ ಗೊಳಾ ಹೊವ್ನ್ ಯೆಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ತನ್ನಾ ಮಳ್ಬಾಕ್ನಾ ಎಗ್ದಾಚ್ ಎಕ್ ಆವಾಜ್ ಯೆಲೊ ತೊ ಆವಾಜ್ ಮೊಟೊ ವಾರೊ ಯೆಲ್ಲ್ಯಾ ಸಾರ್ಕೊ ಹೊತ್ತೊ. ಅನಿ ತೊ ಅವಾಜ್ ತೆನಿ ಬಸಲ್ಲ್ಯಾ ಘರಾತ್ ಫುರಾ ಪಗಳ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ಅನಿ ತೆನಿ ಜಿಬ್ಲಿಯಾಂಚ್ಯಾ ಸಾರ್ಕೆ ಹೊತ್ತಿ ಆಗ್ ಬಗಟ್ಲ್ಯಾನಿ, ತಿ ಆಗಿಚಿ ಜಿಬ್ಲಿಯಾ ಪಗ್ಳುನ್ ಥೈ ಹೊತ್ತ್ಯಾ ಹರ್ ಎಕ್ಲ್ಯಾಚ್ಯಾ ವರ್‍ತಿ ಪಡ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ತನ್ನಾ ತೆನಿ ಸಗ್ಳೆ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರುನ್, ತೊ ಆತ್ಮೊ ತೆಂಕಾ ಕಸಿ ಬಳ್ ದಿತಾ ತಸೆ ದುಸ್ರ್ಯಾ ದುಸ್ರ್ಯಾ ಭಾಶಾತ್ನಿ ಬೊಲುಕ್ ಲಾಗ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ಲೈ ಭಕ್ತಿವಂತ್ ಹೊತ್ತಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ತ್ಯಾ ವೆಳಾರ್ ಜೆರುಜಲೆಮಾತ್ ಹೊತ್ತಿ, ತೆಂಚ್ಯಾತ್ ಜಗಾತ್ಲ್ಯಾ ಹರ್ ಎಕ್ ದೆಶ್ಯಾಕ್ನಾ ಯೆಲ್ಲಿ ಲೊಕಾಬಿ ಹೊತ್ತಿ, ತೊ ಆವಾಜ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಥೈ ಲೈ ಲೊಕಾ ಗೊಳಾ ಹೊಲ್ಲಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ತೊ ಆವಾಜ್ ಆಯ್ಕುನ್ ಥೈ ದುಸ್ರ್ಯಾ ದುಸ್ರ್ಯಾ ಭಾಶೆಚಿ ಲೊಕಾ ಗೊಳಾ ಹೊಲಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿ ದೆವಾಚಿ ಲೊಕಾ ಅಪ್ಲ್ಯಾ ಅಪ್ಲ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಭಾಶ್ಯಾನಿ ಬೊಲುಕ್ ಲಾಗಲ್ಲೆ ತೆ ಬಗುನ್ ಥೈ ಗೊಳಾ ಹೊಲ್ಲಿ ಲೊಕಾ ಆಜಾಪ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ಅನಿ ತಿ ಲೊಕಾ ಅಜಾಪ್ ಹೊವ್ನ್ ಮಟ್ಲ್ಯಾನಿ; “ಹಿ ಬೊಲುಕ್ ಲಾಗಲ್ಲಿ ಲೊಕಾ ಗಾಲಿಲಿಯಾತ್ಲಿ ಲೊಕಾ ನ್ಹಯ್ ಕಾಯ್?” ");
INSERT INTO kans_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ಅಮ್ಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಗಾಂವಾಚಿ ಬಾಶಾ ತೆನಿ ಬೊಲ್ತಲ್ಯಾ ಸಾರ್ಕೆ ಅಮ್ಕಾ ಆಯ್ಕುಕ್ ಲಾಗ್ಲಾ ಹೆ ಸಗ್ಳೆ ಕಶೆ ಹೊಲೆ? ");
INSERT INTO kans_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ಅಮಿ ಸಗ್ಳೆ ಖಲ್ಯಾ ಖಲ್ಯಾ ಗಾಂವಾಂಚೆ ಮಟ್ಲ್ಯಾರ್, ಪಾರ್ಥಿಯಾತ್ಲೆ, ಮೆದಿಯಾತ್ಲೆ, ಎಲಾಮಾತ್ಲೆ , ಮೆಸಾಪೊತಾಮಿಯಾತ್ಲೆ, ಜುದೆಯಾತ್ಲೆ, ಕಪ್ಪದೊಸಿಯಾತ್ಲೆ, ಪೊಂತ್ಯಾತ್ಲೆ, ಎಶ್ಯಾತ್ಲೆ, ");
INSERT INTO kans_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ಅನಿ ಪಿರ್ಗಿಯಾತ್ಲೆ, ಪಂಪಿಲಿಯಾತ್ಲೆ, ಇಜಿಪ್ತಾತ್ಲೆ ಅನಿ ಲಿಬಿಯಾಚ್ಯಾ ಜಗೊಳ್ಲ್ಯಾ ಸಿರೆನಿತ್ಲೆ, ಅನಿ ಥೊಡಿ ಲೊಕಾ ರೊಮಾತ್ಲಿ, ");
INSERT INTO kans_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ಜುದೆವಾಂಚೆ ಅನಿ ಜುದೆವಾಂಚೊ ಧರ್ಮ್ ಚಾಲ್ವನ್ ಘೆವ್ನ್ ಜಾತಲಿ ದುಸ್ರಿ ಲೊಕಾ ಕ್ರೆತಾತ್ಲಿ ಅನಿ ಅರೆಬಿಯಾತ್ಲಿ ಜಾಲ್ಯಾರ್ಬಿ, ದೆವಾನ್ ಕರಲ್ಲ್ಯಾ ಮೊಟ್ಯಾ ಕಾಮಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಅಮ್ಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಬಾಶಾನಿ ಸಾಂಗ್ತಲೆ ಅಮಿ ಆಯ್ಕಿಸಾರ್ಕೆ ಹೊಲೆ ಮನುನ್ ಬೊಲುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ತೆನಿ ಸಗ್ಳೆ ಜಾನಾ ಘಾಬರ್ಲೆ ಅನಿ ಅಜಾಪ್ ಹೊವ್ನ್, “ಹೆ ಕಾಯ್ ಹೊಲೆ?” ಮನುನ್ ಎಕಾಮೆಕಾಕ್ ಇಚಾರುನ್ ಘೆವ್ಕ್ ಲಾಗ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ಖರೆ ಹುರಲ್ಲ್ಯಾ ಲೊಕಾನಿ ತೆಂಕಾ ಬಗುನ್ “ಹೆನಿ ಲೈ ವಾಯ್ನ್ ಫಿವ್ನ್ ನಿಶೆತ್ ಹಾತ್.” ಮನುನ್ ಸಾಂಗುನ್ ಹಾಸ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ಮಾನಾ ಪೆದ್ರು ಹುರಲ್ಲ್ಯಾ ಆಕ್ರಾ ಲೊಕಾ ಅಪೊಸ್ತಲಾಕ್ನಿ ಘೆವ್ನ್ ಇಬೆ ರ್‍ಹಾವ್ನ್, ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಮೊಟ್ಯಾ ಧನಾನ್ ಸಾಂಗುಕ್ ಲಾಗ್ಲೊ: ಜುದೆವಾನು, ಜೆರುಜಲೆಮಾತ್ಲ್ಯಾ ಲೊಕಾನು, ಮಿಯಾ ಸಾಂಗ್ತಲ್ಯಾಕ್ ಕಾನ್ ದಿವ್ನ್ ಆಯ್ಕಾ, ತುಮಿ ಕಳ್ವುನ್ ಘೆವ್ಚಿ ಹೊಲ್ಲಿ ಸಂಗ್ತಿಯಾ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ತುಮಿ ಯೆವ್ಜುನ್ ಘೆಟಲ್ಲ್ಯಾ ಸಾರ್ಕೆ ಹೆನಿ ವಾಯ್ನ್ ಫಿಲ್ಲಿ ಲೊಕಾ ನ್ಹಯ್, ಅತ್ತಾ ಖಾಲಿ ಸಕ್ಕಾಳ್ಚೆ ನ್ಹವ್ ಗಂಟೆ ಹೊಲಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ಖರೆ ಅತ್ತಾ ಹಿತ್ತೆ ಚಲುಲಾಗಲ್ಯಾ ಸಂಗ್ತಿಯಾಂಚ್ಯಾ ವಿಶಯಾ ಪ್ರವಾದಿ ಯೊಯೆಲಾನ್ ಅಶೆ ಬೊಲಲ್ಲೆ ಹಾಯ್: ");
INSERT INTO kans_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ಆಕ್ರಿಚ್ಯಾ ದಿಸಾತ್ನಿ ಅಪ್ನಿ ಕರ್‍ತಲೆ ಕಾಯ್ ಮನುನ್ ದೆವ್ ಸಾಂಗ್ತಾ! ಮಿಯಾ ಮಾಜೊ ಆತ್ಮೊ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿ ಘಾಲ್ತಾ, ತುಮ್ಚಿ ಲೆಕಾ ಅನಿ ಲೆಕಿಯಾ ಪ್ರವಾದ್ ಕರ್ತಾತ್, ತುಮ್ಚಿ ದಾಂಡ್ಗಿ ಲೊಕಾ ದರ್ಶನ್ ಬಗ್ತ್ಯಾತ್, ಅನಿ ತುಮ್ಚಿ ಮ್ಹಾತಾರಿ ಮಾನ್ಸಾ ಸಪ್ನಾ ಬಗ್ತ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ತ್ಯಾ ಎಳಾರ್ ಮಿಯಾ ಮಾಜೊ ಆತ್ಮೊ ಸೆವಕಾ, ಅನಿ ಸೆವಕಿಂಚ್ಯಾ ವೈರ್ಬಿ ಘಾಲ್ತಾ ತನ್ನಾ ತೆನಿಬಿ ಪ್ರವಾದ್ ಕರ್ತಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ಮಿಯಾ ಮಳ್ಬಾತ್ ಅಜಾಪಾಚಿ ಕಾಮಾ ದಾಕ್ವುತಾ, ಜಿಮ್ನಿರ್ ವಳಕ್ ದಾಕ್ವುತಾ , ರಗಾತ್, ಆಗ್ ಅನಿ ಡುಕ್ಟಾಚೊ ವಾಪ್ ಥೈ ರ್‍ಹಾತಾ. ");
INSERT INTO kans_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ತನ್ನಾ ದಿಸ್ ಕಾಳೊ ಹೊತಾ, ಚಂದ್ರಾಮ್ ರಗ್ತಾ ಸಾರ್ಕೊ ತಾಂಬ್ಡೊ ಹೊತಾ, ತನ್ನಾ ಧನಿಯಾಚೊ ಮೊಟೊ ಮಹಿಮೆಚೊ ದಿಸ್ ಯೆತಾ. ");
INSERT INTO kans_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ಕೊನ್ ಧನಿಯಾಚ್ಯಾ ನಾಂವಾನ್ ಮಾಗ್ನಿ ಕರ್ತಾತ್, ತೆಂಕಾ ಹುರ್ವುನ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾನು ಮಾಜಿ ಹಿ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕಾ, ದೆವಾನ್ ಅಪ್ನಿ ಜೆಜುಚ್ಯಾ ವೈನಾ ಕರಲ್ಲಿ ತಾಕ್ತಿಚ್ಯಾ ಅನಿ ಚಮತ್ಕಾರಾಚ್ಯಾ ಕಾಮಾಂಚ್ಯಾ ವೈನಾ ನಜರೆತಾತ್ಲ್ಯಾ ಜೆಜುಚೊ ದೈವಿಕ್ ಅದಿಕಾರ್ ಸ್ಪಸ್ಟ್ ಹೊವ್ನ್ ದಾಕ್ವುನ್ ದಿಲ್ಲೊ ಹಾಯ್, ಹಿ ಸಂಗ್ತಿಯಾ ತುಮಿ ಸಗ್ಳ್ಯಾನಿ ಬಗ್ಲ್ಯಾಸಿ, ತಸೆ ಹೊವ್ನ್ ಹೆ ಸಗ್ಳೆ ಖರೆ ಮನುನ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ಜೆಜುಕ್ ತುಮ್ಕಾ ಹಾತಾತ್ ಒಪ್ಸುನ್ ದಿತಲಿ ದೆವಾಚಿಚ್ ಯವ್ಜನ್ ಹೊತ್ತಿ, ದೆವಾನ್ ಲೈ ಫಾಟಿಚ್ ಹೆ ನಿರ್ಧಾರ್ ಕರುನ್ ಥವಲ್ಲ್ಯಾನ್. ಖರೆ ತುಮಿ ಪಾಪಿ ಲೊಕಾಂಚ್ಯಾ ಮಜತಿನ್ ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್ಲ್ಯಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ಜೆಜುನ್ ಮರ್ನಾಚೊ ತರಾಸ್ ಸೊಸ್ಲ್ಯಾನ್, ಖರೆ ದೆವಾನ್ ತೆಕಾ ಮರ್‍ನಾತ್ನಾ ಉಟ್ವುಲ್ಯಾನ್, ತಸೆ ಹೊವ್ನ್ ಮರ್ನಾಚ್ಯಾನ್ ಜೆಜುಕ್ ಧರುನ್ ಘೆವ್ಕ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ತಸೆ ಹೊವ್ನ್ ದಾವಿದಾನ್ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಅಶೆ ಸಾಂಗಲ್ಲೆ ಹಾಯ್, ಧನಿ ಸಗ್ಳ್ಯಾ ವೆಳಾರ್ ಮಾಜ್ಯಾ ಇದ್ರಾಕ್ ಹೊತ್ತೆ ಮಿಯಾ ಬಗಟ್ಲೊ: ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೊ ಮಾಜ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಹಾಯ್ ತಸೆ ಹೊವ್ನ್ ಮಿಯಾ ಭಿಂಯೆ ನಸ್ತಾನಾ ಘಟ್ ರ್‍ಹಾತಾ, ");
INSERT INTO kans_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ತಸೆ ಹೊವ್ನ್ ಮಾಜ್ಯಾ ಮನಾಕ್ ಲೈ ಕುಶಿ ಹೊತಾ, ಅನಿ ಮಾಜಿ ಬೊಲ್ನಿ ಕುಶಿನ್ ಭರುನ್ ರ್‍ಹಾತ್ಯಾತ್, ಅನಿ ಮರ್ತಲ್ಯಾ ಸಾರ್ಕೊ ಹೊತ್ತೊ ಮಿಯಾ ಬರೊಸ್ಯಾನ್ ಜಿವನ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತಿಯಾ ಮಾಜೊ ಜಿವಾಚೊ ಆತ್ಮೊ ಪಾತಾಳಾತ್ ಘಾಲಿನೆಯ್, ತಿಯಾ ಪವಿತ್ರ್ ಹೊವ್ನ್ ಹೊತ್ತೆ ಮಾಜೆ ಆಂಗ್ ಕುಸುನ್ ಜಾವ್ಕ್ ಅವಕಾಸ್ ದಿನೆಯ್. ");
INSERT INTO kans_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ಕಶೆ ಜಿವನ್ ಕರುಚೆ ಮನುನ್ ತಿಯಾ ಮಾಕಾ ದಾಕ್ವುನ್ ದಿಲೆ, ಅನಿ ತಿಯಾ ಮಾಜ್ಯಾ ಇದ್ರಾಕ್ ರ್‍ಹಾತಲೆ ಮಾಕಾ ಉಮ್ಮೆದಿನ್ ಭರಿ ಸಾರ್ಕೆ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ಮಾಜ್ಯಾ ಭಾವಾನು ಅನಿ ಭೆನಿಯಾನು, ಅಮ್ಚ್ಯಾ ವಾಡ್ವಡ್ಲಾ ದಾವಿದ್ ರಾಜಾಚ್ಯಾ ವಿಶಯಾತ್ ಮಿಯಾ ತುಮ್ಕಾ ಖರೆ ಸಾಂಗ್ತಾ, ತೊ ಮರುನ್ ಗೆಲೊ ತೆಕಾ ಮಾಟಿ ದಿವ್ನ್ ಹೊಲಿ, ತೆಚಿ ಸಮಾದಿ ಅಜುನ್ಬಿ ಆಮ್ಚ್ಯಾ ಮದ್ದಿ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ದಾವಿದ್ ಎಕ್ ಪ್ರವಾದಿ ಹೊತ್ತೊ, ದೆವಾನ್ ತೆಕಾ ತುಜ್ಯಾ ಘರಾನಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್ ತುಜ್ಯಾ ಸಾರ್ಕೊಚ್ ರಾಜಾ ಕರ್ತಾ ಮನುನ್ ಆನ್ ಥವ್ನ್ ಗೊಸ್ಟ್ ದಿಲ್ಲೆ ತೆಕಾ ಗೊತ್ತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ದಾವಿದಾನ್ ದೆವ್ ಫಿಡೆ ಕಾಯ್ ಕರ್‍ತಲೊ ಹಾಯ್ ಮನ್ತಲೆ ಕಳ್ವುನ್ ಘೆಟಲ್ಲ್ಯಾನ್, ತಸೆ ಹೊವ್ನ್ ತೆನಿ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟ್ತಲೊ ಹೊತ್ತ್ಯಾ ಕ್ರಿಸ್ತಾಚ್ಯಾ ವಿಶಯಾತ್ ಅಶೆ ಮಟ್ಲ್ಯಾನ್; ತೆಜೆ ಶರಿರ್ ಸಮಾದಿತ್ ಕುಸುನ್ ಜಾವ್ಕ್ ನಾ, ");
INSERT INTO kans_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ದೆವಾನ್ ಜೆಜುಕ್ ಮರ್ನಾತ್ನಾ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುಲ್ಯಾನ್. ಅನಿ ಅಮಿ ಸಗ್ಳೆ ಹೆಕಾ ಸಾಕ್ಷಿ ಹೊವ್ನ್ ಹಾವ್. ");
INSERT INTO kans_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ಜೆಜು ಸರ್ಗಾರ್ ಜಾವ್ನ್ ದೆವಾಚ್ಯಾ ಉಜ್ವ್ಯಾ ಭಾಜುಕ್ ಬಸ್ಲ್ಯಾ, ಅನಿ ತೆಚ್ಯಾ ಬಾಬಾನ್ ಗೊಸ್ಟ್ ದಿಲ್ಲ್ಯಾ ಸಾರ್ಕೆ ಪವಿತ್ರ್ ಆತ್ಮೊ ತೆಕಾ ದಿಲ್ಯಾನ್, ತಸೆ ಹೊವ್ನ್ ಜೆಜುನ್ ತೊ ಆತ್ಮೊ ಅಮ್ಚ್ಯಾ ವರ್‍ತಿ ಘಾಟ್ಲಾ, ತುಮಿ ತೆ ಬಗುಕ್ ಲಾಗ್ಲ್ಯಾಸಿ ಅನಿ ಆಯ್ಕುಕ್ ಲಾಗ್ಲ್ಯಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ಹೆಚ್ಯಾಸಾಟ್ನಿ ದೆವಾನ್ ದಾವಿದಾಕ್ ಮರ್ನಾತ್ನಾ ಉಟ್ವುನ್ ಸರ್‍ಗಾಕ್ ನ್ಹೆವ್ಕ್ ನಾ, ಖರೆಚ್ ತೆನಿ ಧನಿಯಾನ್ ಮಾಜ್ಯಾ ಧನಿಯಾಕ್ ಸಾಂಗ್ಲ್ಯಾನ್, ತಿಯಾ ಮಾಜ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಬಸುನ್ ರ್‍ಹಾ, ");
INSERT INTO kans_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ಮಿಯಾ ತುಜ್ಯಾ ದುಸ್ಮನಾಕ್ನಿ ಪಾಯಾ ಥವ್ತಲಿ ಮ್ಹನಿ ಹೊಯ್ ಸಾರ್ಕೆ ಕರಿಪತರ್, ತಿಯಾ ಮಾಜ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಬಸುನ್ ರ್‍ಹಾ ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಹಾಯ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ತಸೆ ಹೊವ್ನ್ ತುಮಿ ಕುರ್ಸಾರ್ ಮಾರಲ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಜೆಜುಕುಚ್, ದೆವಾನ್ ಧನಿ ಅನಿ ಕ್ರಿಸ್ತ್ ಕರ್ಲ್ಯಾನ್ ಮನ್ತಲೆ ತುಮಿ ಇಸ್ರಾಯೆಲಾಚಿ ಸಗ್ಳಿ ಲೊಕಾ ಕಳ್ವುನ್ ಘೆವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ಲೊಕಾನಿ ಹೆ ಸಗ್ಳೆ ಆಯಿಕ್ಲ್ಯಾನಿ ತನ್ನಾ ತೆಂಚ್ಯಾ ಮನಾಕ್ ಲೈ ಬೆಜಾರ್ ಹೊಲೊ, ತನ್ನಾ ತೆನಿ ಪೆದ್ರುಕ್ ಅನಿ ಹುರಲ್ಲ್ಯಾ ಅಪೊಸ್ತಲಾಕ್ನಿ “ಭಾವಾನು ಅತ್ತಾ ಅಮಿ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ತನ್ನಾ ಪೆದ್ರುನ್ ತೆಂಕಾ “ತುಮ್ಚ್ಯಾತ್ಲೊ ಹರ್ ಎಕ್ಲೊಬಿ ಅಪ್ಲ್ಯಾ ಪಾಪಾತ್ನಾ ಪರ್ತುನ್ ದೆವಾಕ್ಡೆ ಯೆವ್ನ್ ಜೆಜು ಕ್ರಿಸ್ತಾಚ್ಯಾ ನಾಂವಾನ್ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆಂವ್ದಿತ್, ತನ್ನಾ ದೆವ್ ತುಮ್ಚ್ಯಾ ಪಾಪಾಕ್ನಿ ಮಾಪ್ ಕರ್‍ತಾ, ಅನಿ ದೆವಾನ್ ಗೊಸ್ಟ್ ದಿಲ್ಲೊ ಪವಿತ್ರ್ ಆತ್ಮೊ ತುಮಿ ಘೆವ್ಕ್ ಹೊತಾ”. ");
INSERT INTO kans_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ಹಿ ಗೊಸ್ಟ್ ತುಮ್ಕಾ ತುಮ್ಚ್ಯಾ ಪೊರಾ ಬಾಳಾಕ್ನಿ, ಅನಿ ಲೈ ಧುರ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ದಿಲ್ಲೆ ಹಾಯ್. ಅಮ್ಚ್ಯಾ ದೆವಾ ಧನಿಯಾನ್ ಅಪ್ನಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಬಲ್ವಲ್ಲ್ಯಾ ಹರ್ ಎಕ್ಲ್ಯಾಕ್ಬಿ ಹಿ ಗೊಸ್ಟ್ ದಿಲ್ಲಿ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ಪೆದ್ರುನ್ ಅನಿ ಲೈ ಬೊಲ್ನ್ಯಾನಿ ಉಶಾರ್ಕಿ ದಿವ್ನ್, ತೆಂಕಾ, “ತುಮಿ ತುಮ್ಕಾ ಹ್ಯಾ ಬುರ್ಶ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್ತಿ ಯೆತಲ್ಯಾ ಶಿಕ್ಷಾತ್ನಾ ಹುರ್ವುನ್ ಘೆವಾ!” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ತೆಂಚ್ಯಾತ್ಲ್ಯಾ ಲೈ ಲೊಕಾನಿ ಪೆದ್ರು ಸಾಂಗ್ತಲೆ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನಿ ಅನಿ ಬಾಲ್ತಿಮ್ ಘೆಟ್ಲ್ಯಾನಿ, ತ್ಯಾ ದಿಸಿ ಸುಮಾರ್ ತಿನ್ ಹಜಾರ್ ಲೊಕಾ ದೆವಾಚ್ಯಾ ಲೊಂಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಮಿಳ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ತೆನಿ ಅಪೊಸ್ತಲಾಂಚಿ ಶಿಕಾಪಾ ಆಯಿಕ್ತಲ್ಯಾತ್, ಭಾವ್ ಭೆನಿಯಾಂಚ್ಯಾ ಎಕ್ವಟ್ಟಾತ್ ಅನಿ ಎಕ್ ಹೊವ್ನ್ ಜೆವಾನ್ ಕರ್‍ತಲ್ಯಾತ್ ಅನಿ ಮಾಗ್ನೆ ಕರ್‍ತಲ್ಯಾತ್ ಅಪ್ಲೊ ಎಳ್ ಖರಚ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ಅಪೊಸ್ತಲಾನಿ ಲೈ ಅಜಾಪಾ ಅನಿ ವಿಚಿತ್ರಾ ಕರಿತ್ ಹೊತ್ತ್ಯಾನಿ ಅನಿ ಹರ್ ಎಕ್ಲ್ಯಾಕ್ಬಿ ದೆವಾಚ್ಯಾ ವರ್‍ತಿ ಭಕ್ತಿ ವಾಡ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ಸಗ್ಳಿ ದೆವಾಚಿ ಮಾನ್ಸಾಬಿ ಎಕ್ವಟ್ಟಾನಿ ರ್‍ಹಾಯ್ತ್ ಅನಿ ಹರ್ ಎಕ್ಲೊ ಸಗ್ಳಿ ಸಾಮಾನಾ ಎಕಾಮೆಕಾತ್ನಿ ವಾಟುನ್ ಘೆಯ್ತ್. ");
INSERT INTO kans_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ಅಪ್ಲೆ ಸೆತ್ ಅನಿ ತೆಂಚ್ಯಾಕ್ಡೆ ಹೊತ್ತಿ ಸಗ್ಳಿ ಸಾಮಾನಾ ಇಕುನ್ ಗಾವಲ್ಲೆ ಪೈಸೆ ಕೊನಾಕ್ ಗರಜ್ ಹಾಯ್ ತೆಂಕಾ ವಾಟುನ್ ದಿಯ್ತ್. ");
INSERT INTO kans_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ಸದ್ದಿಚ್ ತೆನಿ ಜಮಾ ಹೊವ್ನ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಎಕ್ವಟ್ಟಾನಿ ಯೆಯ್ತ್ ಅನಿ ಅಪ್ಲ್ಯಾ ಘರಾತ್ನಿ ಎಕುಚ್ ಕಡೆ ಮಿಳುನ್ ಜೆವಾನ್ ಕರಿತ್, ಕುಶಿನ್ ಅನಿ ಖಾಲ್ತಿ ಹೊವ್ನ್ ಚಲ್ತಲ್ಯಾ ಮನಾನಿ ಜೆವಾನ್ ಕರಿತ್, ");
INSERT INTO kans_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ಅನಿ ದೆವಾಕ್ ಸ್ತುತಿ ಕರಿತ್, ಅನಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಮನಾನಿ ಸಗ್ಳೆ ಜಾನಾ ಮಜ್ಯಾ ಕರಿತ್. ಹರಿಎಕ್ ದಿಸ್ ಬಿ ಲೈ ದೆವಾಚಿ ರಾಕ್ವನ್ ಜೊಡುನ್ ಘೆಟಲ್ಲಿ ಲೊಕಾ ಹ್ಯಾ ತಾಂಡ್ಯಾತ್ ಧನಿ ಹಾನುನ್ ಮಿಳ್ವಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ಎಕ್ ದಿಸಿ ಪೆದ್ರು ಅನಿ ಜುವಾಂವ್ ದೊಪಾರಿ ತಿನ್ ಗಂಟ್ಯಾಕ್ಡೆ ಚಲ್ತಲ್ಯಾ ತೊ ಮಾಗ್ನಿಚೊ ಎಳ್ ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ಡೆ ಜಾಯ್ತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ತನ್ನಾ ಎಕ್ ಜಲ್ಮಿ ಸೊಟ್ಟೊ ಹೊತ್ತೊ ತೆಜ್ಯಾಕ್ಡೆ ಚಲುಕ್ ಹೊಯ್ನಶಿ, ತೆಸೆ ಹೊವ್ನ್ ತೆಚಿ ವಾಂಗ್ಡಿ ಲೊಕಾ ತೆಕಾ ಸದ್ದಿ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಭಿಕ್ ಮಾಗುಸಾಟಿ ತೆಕಾ ಸುದಂರ್ ದ್ವಾರ್ ಮನ್ತಲ್ಯಾ ದಡ್ಪ್ಯಾಕ್ಡೆ ಬಸ್ವುನ್ ಥೈಯ್ತ್, ತೊ ಸೊಟ್ಟೊ ತ್ಯಾ ದಡ್ಪ್ಯಾಕ್ಡೆ ಬಸುನ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಜಾಯ್ತ್ ಯೆತಲ್ಯಾಂಚ್ಯಾಕ್ಡೆ ಭಿಕ್ ಮಾಗುನ್ಗೆತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ಪೆದ್ರು ಅನಿ ಜುವಾಂವ್ ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ ಜಾವ್ನ್ ಗೆತ್ ರಾತಾನಾ ತೊ ಸೊಟ್ಟೊ ತೆಂಚ್ಯಾಕ್ನಾ ಕಾಯ್ತರಿಬಿ ಗಾವ್ತಾ ಕಾಯ್ಕಿ ಮನುನ್ ಭಿಕ್ ಮಾಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ಪೆದ್ರುನ್ ಅನಿ ಜುವಾಂವಾಕ್ ತ್ಯಾ ಸೊಟ್ಟ್ಯಾಕುಚ್ ಬಗಟ್ಲ್ಯಾನಿ ಅನಿ ಪೆದ್ರುನ್ ತೆಕಾ “ಅಮ್ಕಾ ಬಗ್!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ತೆಂಚ್ಯಾಕ್ನಾ ಕಾಯ್ ತರ್ ಬಿ ಗಾವ್ತಲೆ ಮನುನ್ ಚಿಂತುನ್ ತ್ಯಾ ಸೊಟ್ಟ್ಯಾನ್ ತೆಂಕಾಚ್ ಬಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ಖರೆ ಪೆದ್ರುನ್ ತೆಕಾ ಮಾಜ್ಯಾಕ್ಡೆ ಪೈಸೆ, ಸೊನೆ ಕಾಯ್ ನಾ, ಜಾಲ್ಯಾರ್ ಮಾಜ್ಯಾಕ್ಡೆ ಹೊತ್ತೆ ಮಿಯಾ ತುಕಾ ದಿತಾ ನಜರೆತಾಚ್ಯಾ ಜೆಜುಚ್ಯಾ ನಾಂವಾನ್ ಮಿಯಾ ಸಾಂಗ್ತಾ ಚಲುಕ್‍ಲಾಗ್, ");
INSERT INTO kans_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ಮಾನಾ ಪೆದ್ರುನ್ ತ್ಯಾ ಸೊಟ್ಯಾಚೊ ಉಜ್ವೊಹಾತ್ ಧರುನ್ ತೆಕಾ ಉಟುನ್ ಇಬೆ ಕರ್‍ಲ್ಯಾನ್, ತನ್ನಾ ತೆಚ್ಯಾ ಪಾಂಯಾಕ್ನಿ, ಅನಿ ಪಾಯಾಚ್ಯಾ ಗಾಟ್ಯಾಕ್ನಿ ತಾಬೊಡ್ತೊಬ್ ಬಳ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ತೊ ಸೊಟ್ಟೊ ಹುಡಿ ಮಾರುನ್ ಅಪ್ಲ್ಯಾ ಪಾಂಯಾರ್ನ್ನಿ ಇಬೆ ರ್‍ಹಾಲೊ, ಅನಿ ಫಿರುನ್ ಖೆಳುಲಾಲೊ ಮಾನಾ ತೊ ಪೆದ್ರುಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಚಲುನ್ಗೆತ್, ಹುಡಿಯಾ ಮಾರುಂಗೆತ್, ಅನಿ ದೆವಾಕ್ ಸ್ತುತಿ ಕರುಂಗೆತ್ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ಭುತ್ತುರ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ಥೈತ್ಲ್ಯಾ ಲೊಕಾನಿ ತೊ ಸೊಟ್ಟೊ ಉಟುನ್ ಚಲ್ತಲೆ, ಅನಿ ದೆವಾಕ್ ಸ್ತುತಿ ಕರ್‍ತಲೆ ಬಗಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ಅನಿ ತ್ಯಾ “ಸುಂದರ್ ದಡ್ಪ್ಯಾತ್” ಭಿಕ್ ಮಾಗಿತ್ ಹೊತ್ತೊ ಹ್ಯೊಚ್ ತೊ ಮನುನ್ ವಳಕ್ಲ್ಯಾನಿ, ಅನಿ ತೆಂಕಾ ಹೆ ಕಶೆ ಹೊಲೆ ಮನುನ್ ಅಜಾಪ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ತೊ ಸೊಟ್ಟೊ ಪೆದ್ರುಕ್ ಅನಿ ಜುವಾಂವಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾಯ್ತ್ ಹೊತ್ತೊ. ತೆಕಾ ಗುನ್ ಹೊಲ್ಲೆ ಬಗುನ್ ಲೊಕಾ ಸಗ್ಳಿ ಅಜಾಪ್ ಹೊಲ್ಯಾನಿ ಸೊಲೊಮನಾಚ್ಯಾ ದಾರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಇಬೆ ಹೊತ್ತ್ಯಾ ತೆಂಚ್ಯಾಕ್ಡೆ ಸಗ್ಳಿ ಲೊಕಾ ಪಳುನ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ಮಾನಾ ಪೆದ್ರುನ್ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಗುನ್ ಮಾಜ್ಯಾ ಇಸ್ರಾಯೆಲಾಂಚ್ಯಾ ಲೊಕಾನು ಹೆ ಬಗುನ್ ತುಮಿ ಕಶ್ಯಾಕ್ ಅಜಾಪ್ ಹೊತ್ತ್ಯಾಶಿ? ಹೊ ಚಲುಲಾಗಲೆ ಮಾಜ್ಯಾ ತಾಕ್ತಿನ್ ಮಿಯಾ ಕರ್‍ಲಾ ಮನುನ್ ಬಗುಲ್ಯಾಸಿ ಕಾಯ್? ಅಮಿ ಬರೆ ಪಾನಾನ್ ಹೊತ್ಯಾಕ್ ಹಿ ಕಾಮಾ ಹೊವ್ಲಾತ್ ಮನುನ್ ಚಿಂತುಲ್ಲ್ಯಾಸಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ಅಬ್ರಾಹಾಮಾಚೊ, ಇಸಾಕಾಚೊ, ಅನಿ ಜಾಕೊಬಾಚೊ ದೆವ್ ತೊಚ್ ಅನಿ ಅಮ್ಚ್ಯಾ ಪುರ್ವಜ್ಯಾಂಚೊ ಸಗ್ಳ್ಯಾಂಚೊ ದೆವ್, ತೆನಿ ಅಪ್ಲೊ ಸೆವಕ್ ಜೆಜುಚಿ ಮಹಿಮಾ ಹೊಯ್ ಸಾರ್ಕೆ ಕರ್‍ಲಾ, ತಸೆ ಹೊಲ್ಯಾರ್ಬಿ ತುಮಿ ಜೆಜುಕ್ ಜಿವಾನಿ ಮಾರುಕ್ ಪಿಲಾತಾಕ್ಡೆ ಒಪ್ಸುನ್ ದಿಲ್ಯಾಸಿ ಪಿಲಾತಾನ್ ತೆಕಾ ಸೊಡುಚೆ ಮನುನ್ ತುಮ್ಚ್ಯಾಕ್ಡೆ ಬೊಲ್ಯಾರ್ಬಿ ತುಮಿ ತೆಕಾ ಸೊಡ್ಸುಕ್ ಅವಕಾಸ್ ದಿವ್ಕನ್ಯಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ಜೆಜು ನಿತಿವಂತ್ ಬರೊ, ಅನಿ ಪವಿತ್ರ್ ಹೊವ್ನ್ ಹೊತ್ತೊ, ಜಾಲಾರ್ಬಿ ತುಮಿ ತೆಕಾ ತಿರಸ್ಕಾರ್ ಕರುನ್ ಜೆಜುಚ್ಯಾ ಬದ್ಲಾಕ್ ಖುನಿಗಾರ್ ಬರಬ್ಬಾಕ್ ಸೊಡುಚೆ ಮನುನ್ ಪಿಲಾತಾಕ್ಡೆ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ಅಶೆ ಕರುನ್ ತುಮಿ ಜಿವ್ ದಿತಲ್ಯಾಕುಚ್ ಜಿವಾನಿ ಮಾರುನ್ ಟಾಕ್ಲ್ಯಾಶಿ ಖರೆ ದೆವಾನ್ ತೆಕಾ ಮರ್ನ್ನಾತ್ನಾ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುಲ್ಯಾನ್ ಹೆ ಸಗ್ಳ್ಯೆ ಅಮಿ ಡೊಳ್ಳ್ಯಾನಿ ಬಗಟ್ಲಾತ್. ಹೆಕಾ ತುಮಿ ಸಗ್ಳೆ ಸಾಕ್ಷಿ ಹೊವ್ನ್ ಹಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ತುಮ್ಚ್ಯಾ ಇದ್ರಾಕ್ ಹೊತ್ತ್ಯಾ ಹ್ಯಾ ಮಾನ್ಸಾಚಿ ವಳಕ್ ತುಮ್ಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಹಾಯ್, ತೆಚ್ಯಾ ನಾವಾವರ್ತಿ ಥವಲ್ಯಾ ವಿಶ್ವಾಸಾ ವೈನಾ ಹೊ ಮಾನುಸ್ ಗುನ್ ಹೊಲಾ. ಹೆ ಸಗ್ಳೆ ತುಮಿ ಬಗುಲ್ಲ್ಯಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ಅನಿ ಮಾಜ್ಯಾ ಭಾವಾನೊ ಅನಿ ಭೆನಿಯಾನೊ, ತುಮ್ಕಾ ಕಳಿಸ್ತಾನಾ ಅಶೆ ಕರ್ಲ್ಯಾಸಿ ಮನ್ತಲೆ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್, ತುಮ್ಚ್ಯಾ ಮೊಟ್ಯಾ ಮಾನ್ಸಾನಿಬಿ ಜೆಜುಕ್ ತಿರಸ್ಕಾರ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ದೆವಾನ್ ಲೈ ಎಳಾಚ್ಯಾ ಅದ್ದಿಚ್ ಅಪ್ಲ್ಯಾ ಪ್ರವಾದ್ಯಾಂಚ್ಯಾ ಕ್ರಿಸ್ತಾನ್ ಕಸ್ಟ್ ಸೊಸುಕ್ ಪಾಜೆ ಮನುನ್ ಸಾಂಗಟಲ್ಲ್ಯಾನ್ ತೆ ಅಶೆ ಪುರಾ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ತಸೆ ಹೊವ್ನ್ ತುಮಿ ಪಾಪಾಕ್ನಾ ಮನ್ ಪರ್ತುನ್ ಘೆವ್ನ್ ದೆವಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವಾ, ತನ್ನಾ ತೊ ತುಮ್ಚ್ಯಾ ಪಾಪಾಕ್ನಿ ಮಾಪ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ಧನಿ ತುಮ್ಕಾ ಆತ್ಮಿಕ್ ಬಳ್ ದಿತಾ, ಅಪ್ನಿ ಕ್ರಿಸ್ತ್ ಹೊವ್ನ್ ಎಚುನ್ ಘೆಟಲ್ಯಾ ಜೆಜುಕ್ ತುಮ್ಕಾ ದಿಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ಖರೆ ಸಗ್ಳ್ಯೆಬಿ ಸಮಾ ಕರ್‍ತಲೊ ಎಳ್ ಯೆಯ್ ಪತರ್ ಜೆಜು ಸರ್‍ಗಾತುಚ್ ರ್‍ಹಾವ್ಚೊ ಮನುನ್ ದೆವಾನ್ ಅಪ್ಲ್ಯಾ ಪವಿತ್ರ್ ಪ್ರವಾದ್ಯಾಂಚ್ಯಾ ಬರ್‍ಯಾ ಖಬ್ರಿಯಾತ್ನಿ ಸಾಂಗಲ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ತಸೆ ಹೊವ್ನ್ ಮೊಯ್ಜೆನ್ “ತುಮ್ಚೊ ದೆವ್ ಹೊಲ್ಲೊ ಧನಿ ತುಮ್ಕಾ ಎಕ್ ಪ್ರವಾದಿ ದಿತಾ, ತುಮ್ಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಮದ್ನಾಚ್ ತೊ ಪ್ರವಾದಿ ಯೆತಾ, ಅನಿ ತೊ ಮಾಜ್ಯಾ ಸಾರ್ಕೊಚ್ ರ್‍ಹಾತಾ ತ್ಯಾ ಪ್ರವಾದ್ಯಾನ್ ಸಾಂಗ್ತಲೆ ಹರ್ ಎಕ್ ಬಿ ತುಮಿ ಮಾನುಚೆ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ತ್ಯಾ ಪ್ರವಾದಾಕ್ ಮಾನಿನಸಲ್ಲೊ ಹರ್ ಎಕ್ಲೊಬಿ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ನಾ ಎಗ್ಳೊ ಹೊವ್ನ್ ನಾಸ್ ಹೊವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ಸಾಮುಯೆಲಾಕ್ನಾ ದರುನ್ ತೆಚ್ಯಾ ಮಾನಾ ಯೆಲ್ಲ್ಯಾ ಪ್ರವಾದ್ಯಾನಿ ಅತ್ತಾಚ್ಯಾ ದಿಸಾತ್ನಿ ಕಾಯ್ ಹೊತಲೆ ಹಾಯ್ ಮನುನ್ ಸಾಂಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ತ್ಯಾ ಪ್ರವಾದ್ಯಾನಿ ಸಾಂಗಲಿ ಸಂಗ್ತಿಯಾ ತುಮ್ಚ್ಯಾ ಪುರ್ವಜ್ಯಾಚಿ ಲೊಕಾಂಚ್ಯಾಕ್ನಾ ದೆವಾನ್ ಕರುನ್ ಘೆಟಲೊ ಕರಾರ್ ತುಮಿ ಮಾನುನ್ ಘೆಟಲ್ಲೆ ಹಾಸಿ, ತುಮ್ಚೊ ಪುರ್ವಜ್ ಮಾನುಸ್ ಅಬ್ರಾಹಾಮಾಕ್, ತುಜ್ಯಾ ಪಿಳ್ಗಿನ್ ಜಗಾತ್ಲಿ ಸಗ್ಳಿ ಲೊಕಾ ಆಶಿರ್ವಾದ್ ಘೆತಾತ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ದೆವಾನ್ ಮುಖ್ಯ್ ಸೆವಕ್ ಅದ್ದಿಚ್ಯಾ ಅದ್ದಿ ಮರ್ನಾಕ್ನಾ ಉಟ್ವುನ್ ತುಮ್ಕಾ ಆಶಿರ್ವಾದ್ ದಿವ್ಕ್ ಸಾಟ್ನಿ, ತುಮ್ಚ್ಯಾಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನ್, ತೊ ತುಮ್ಚ್ಯಾ ಬುರ್ಶಾ ಕಾಮಾತ್ನಾ ದುರ್ ಕರುನ್ ತುಮ್ಕಾ ಆಶಿರ್ವಾದ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ಪೆದ್ರು ಅನಿ ಜುವಾಂವ್ ಲೊಕಾಂಚ್ಯಾಕ್ಡೆ ಬೊಲಿತ್ ರಾತಾನಾ ಅನಿ ಥೊಡಿ ಲೊಕಾ ತೆಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆಲ್ಯಾನಿ ತ್ಯಾತುರ್ ಥೊಡಿಲೊಕಾ ಯಾಜಕಾ, ಅನಿ ಉಲ್ಲಿ ಲೊಕಾ ಸಾದುಸೆವಾಂಚಿ, ಅನಿ ದೆವಾಚಿ ಗುಡಿ ರಾಕ್ತಲ್ಯಾಂಚೊ ಮುಂಖಡ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ಜೆಜುಚ್ಯಾ ಬಳಾನ್ ಲೊಕಾ ಪರ್ತುನ್ ಜಿವ್ ಹೊತ್ಯಾತ್ ಮನುನ್ ತೆ ದೊನ್ ಅಪೊಸ್ತಲಾಬಿ ಶಿಕಾಪ್ ಕರಿತ್ ಹೊತ್ತೆ ಹೆ ಬಗುನ್ ತ್ಯಾಲೊಕಾನಿ ತೆಂಚ್ಯಾ ವೈರ್ ರಾಗ್ ಹೊಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ತಸೆ ಹೊವ್ನ್ ಪೆದ್ರುಕ್ ಅನಿ ಜುವಾಂವಾಕ್ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ದುಸ್ರ್ಯಾಂದಿಸಿ ಪತರ್ ಬಿ ಬಂಧಿಖಾನ್ಯಾತ್ ಥವಲ್ಲ್ಯಾನಿ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತ್ಯಾ ದಿಸಾ ಕಾಳೊಕ್ ಹೊವ್ನ್ ಗೆಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ಖರೆ ತೆನಿ ಶಿಕಾಪ್ ಕರಲೆ ಆಯ್ಕುನ್ ಲೈ ಲೊಕಾನಿ ವಿಸ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ತೆನಿ ಘೊಮಾನ್ಸಾಂಚೊ ಅಂಕೊಚ್ ಸುಮಾರ್ ಪಾಚ್ ಹಜಾರಾಕ್ ದಾಟಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ದುಸ್ರ್ಯಾ ದಿಸಾ ಜುದೆವಾಂಚಿ ಮುಖಂಡಾ, ಜಾಂಟಿ ಲೊಕಾ , ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಲಿ ಲೊಕಾ ಜೆರುಜಲೆಮಾತ್ ತಾಂಡೊ ಹೊವ್ನ್ ಗೊಳಾ ಹೊಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ಥೈ ಅನ್ನಾನ್, ಕಾಯಫ್, ಜುವಾಂವ್ , ಅನಿ ಅಲೆಗ್ಸಾಂಡರ್ ಬಿ ಹೊತ್ತೊ, ಮೊಟ್ಯಾ ಯಾಜಕಾಚ್ಯಾ ಘರಾನಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲಿ ಲೊಕಾ ಥೈ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ತೆನಿ ಪೆದ್ರುಕ್ ಅನಿ ಜುವಾಂವಾಕ್ ಥೈ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ನೆವ್ನ್ ಇಬೆಕರ್ಲ್ಯಾನಿ ಅನಿ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ತೆಂಕಾ ತುಮಿ ಹ್ಯಾ ಸೊಟ್ಟ್ಯಾಕ್ ಕಶೆ ಸಮಾ ಕರ್ಲ್ಯಾಸಿ ? ಖಚ್ಚ್ಯಾ ಬಳಾನ್ ತುಮಿ ಹೆ ಕರ್ಲ್ಯಾಸಿ? ಕೊನಾಚೆ ನಾವ್ ತುಮಿ ವಾಪರ್ಲ್ಯಾಸಿ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ತನ್ನಾ ಪೆದ್ರುನ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರುನ್ ತೆಂಕಾ ಜವಾಬ್ ದಿಲ್ಯಾನ್, ಲೊಕಾಂಚ್ಯಾ ಮುಖಂಡಾನೊ, ಅನಿ ಜ್ಯಾಂನ್ತ್ಯಾನೊ: ");
INSERT INTO kans_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ಹ್ಯಾ ಸೊಟ್ಯಾಕ್ ಹೊಲ್ಯಾ ಬರ್ಯಾಸಾಟಿ ತುಮಿ ಮಾಕಾ ಪರಸ್ನೆ ಕರುಕ್ ಲಾಗ್ಲ್ಯಾಶಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ನಜರೆತಾಚ್ಯಾ ಜೆಜು ಕ್ರಿಸ್ತಾಚ್ಯಾ ನಾವಾರ್ ತೆಂಕಾ ಹ್ಯಾ ಮಾನ್ಸಾಕ್ ಗುನ್‍ ಹೊಲ್ಲೆ ಮನ್ತಲೆ ತುಮಿ, ಅನಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಸಗ್ಳ್ಯಿ ಕಳ್ವುನ್ ಘೆವ್ಚೆ ಮನುನ್ ಮಿಯಾ ಆಶಾ ಕರ್‍ತಾ, ತುಮಿ ಜೆಜುಕ್ ಕುರ್ಸಾರ್ ಘಾಟಲ್ಲ್ಯಾಸಿ ಖರೆ ದೆವಾನ್ ತೆಕಾ ಮರ್ನ್ನಾಕ್ನಾ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುಲ್ಯಾನ್, ಹ್ಯೊ ಮಾನುಸ್ ಸೊಟ್ಟೊ ಹೊತ್ತೊ ಅತ್ತಾ ತೊ ಗುನ್ ಹೊಲಾ, ಅನಿ ಜೆಜುಚ್ಯಾ ನಾಂವಾನ್ ತುಮ್ಚ್ಯಾ ಫಿಡೆ ಉಟುನ್ ಇಬೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ಜೆಜುನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸಾರ್ಕೆ ತುಮಿ ಬಾಂದ್ತಲ್ಯಾ ಲೊಕಾನಿ ಬಾಂದುಕ್ ನಕ್ಕೊ ಮನುನ್ ಸೊಡಲ್ಲೊ ಗುಂಡೊಚ್ ಲೈ ಮಹತ್ವಾಚೊ ಗುಂಡೊ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ಅಮ್ಕಾ ರಾಕ್ವನ್ ದಿತಲೊ ಜೆಜುಚ್, ತೆಚ್ಯಾ ನಾಂವಾಕ್ನಾ ನಸ್ತಾನಾ ಮಳ್ಬಾಚ್ಯಾ ಖಾಲ್ತಿ ಹ್ಯಾ ಜಗಾಚ್ಯಾ ಮಾನ್ಸಾತ್ನಿ ಹೊತ್ತ್ಯಾ ಖಚ್ಚ್ಯಾ ನಾವಾನ್ಬಿ ಅಮ್ಕಾ ರಾಕ್ವನ್ ಹೊಯ್ನಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ಪೆದ್ರುಕ್ ಅನಿ ಜುವಾಂವಾಕ್ ಕಸ್ಲಿಬಿ ಶಿಕಾಪಾ ಗೊತ್ತ್ ನತ್ತಿ, ಖರೆ ತೆನಿ ಉಲ್ಲೆಬಿ ಭಿಂಯೆ ನಸ್ತಾನಾ ಬೊಲುನ್ಗೆತ್ ಹೊತ್ತೆ ಬಗುನ್ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ತಾಂಡ್ಯಾಚಿ ಲೊಕಾ ಅಜಾಪ್ ಹೊಲ್ಯಾನಿ ಅನಿ ಹೆನಿ ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ ಮನುನ್ ತೆನಿ ಯಾದ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ತೊ ಸೊಟ್ಟೊ ಪೆದ್ರು ಅನಿ ಜುವಾಂವಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಇಬೆ ಹೊತ್ತೊ ಥೈತ್ಲ್ಯಾ ಲೊಕಾನಿ ಬಗಲ್ಲ್ಯಾನಿ ತಸೆ ಹೊವ್ನ್ ತ್ಯಾ ಅಪೊಸ್ತಲಾಕ್ನಿ ವಿರೊಧ್ ಹೊವ್ನ್ ತೆಂಚ್ಯಾಕ್ಡೆ ಕಾಯ್ಬಿ ಸಾಂಗುಕ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ಪೆದ್ರು ಅನಿ ಜುವಾಂವಾಕ್ ಝಡ್ತಿ ಕರುಲಾಗಲ್ಲ್ಯಾ ಜಾಂನ್ತ್ಯಾ ವೈನಾ ಭಾಯ್ರ್ ಧಾಡ್ಲ್ಯಾನಿ, ಅನಿ ತೆನಿ ಎಕಾಮೆಕಾಕ್ ಬೊಲುನ್ ಘೆವ್ಕ್ ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ತೆನಿ “ ಹ್ಯಾ ಮಾನಸ್ಸಾಕ್ನಿ ಅಮಿ ಅತ್ತಾ ಕಾಯ್ ಕರುವಾ? ಹೆನಿ ಕರಲ್ಲೆ ಮೊಟ್ಟೆ ಚಮತ್ಕಾರ್ ಜೆರುಜಲೆಮಾತ್ ಹರ್ ಎಕ್ಲ್ಯಾಕ್ಬಿ ಗೊತ್ತ್ ಹೊತ್ಯಾ ಸಾಟ್ನಿ ಹೆ ಝುಟೆ ಮನುನ್‍ಬಿ ಸಾಂಗುಕ್ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ಖರೆ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಲೊಕಾಕ್ನಿ ಸಾಂಗುನಕಾಸಿ ಮನುನ್ ಹೆಂಕಾ ಅಮಿ ಬಿಂವ್ಸುಚೆ ತನ್ನಾ ಹಿ ಸಂಗ್ತಿಯಾ ಲೊಕಾಂಚ್ಯಾ ಮದ್ದಿ ಪಗ್ಳಿನಾ”, ಮನುನ್ ಬೊಲುನ್ ಘೆಟಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ತಸೆ ಹೊವ್ನ್ ಲೊಕಾನಿ ಪೆದ್ರುಕ್, ಅನಿ ಜುವಾಂವಾಕ್, ಪರ್ತುನ್ ಭುತ್ತುರ್ ಬಲ್ವುಲ್ಯಾನಿ, ಅನಿ ಜೆಜುಚ್ಯಾ ನಾಂವಾನ್ ತುಮಿ ಕಾಯ್ಬಿ ಸಾಂಗುಚೆ ನ್ಹಯ್, ಅನಿ ಕಸ್ಲಿಬಿ ಶಿಕಾಪಾ ದಿವ್ಚೆ ನ್ಹಯ್ ಮನುನ್ ಹುಶ್ಯಾರ್ಕಿ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ಖರೆ ತೆಂಕಾ ಪೆದ್ರುನ್ ಅನಿ ಜುವಾಂವಾಕ್, ಅಮಿ ತುಮ್ಕಾ ಮಾನುಚೆ ಕಿ? ನಾ ತರ್ ದೆವಾಕ್ ಮಾನುಚೆ? ಹ್ಯಾತುರ್ ಖಚ್ಚಿ ದೆವಾಚಿ ಇಚ್ಚಾ ತುಮಿಚ್ ಸಾಂಗಾ. ");
INSERT INTO kans_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ಅಮಿ ತರ್ ಗಪ್ಪ್ ರಾನಾರ್ ನ್ಹಯ್ ಅಮಿ ಬಗಟಲ್ಲಿ ಅನಿ ಆಯ್ಕಲಿ ಸಂಗ್ತಿಯಾ ಲೊಕಾಕ್ನಿ ಸಾಂಗುಕುಚ್ ಹೊಯ್ನಾ ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ಖರೆ ತ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ನ್ಯಾಯ್ ಕರ್‍ತಲ್ಯಾ ಮುಖಂಡಾಂಚ್ಯಾಕ್ಡೆ ಕಸ್ಲೆಬಿ ಶಿಕ್ಷಾ ದಿವ್ಕ್ ಹೊವ್ಕ್ ನಾ, ಪೆದ್ರುಕ್ ಅನಿ ಜುವಾಂವಾಕ್ ಉಶಾರ್ಕಿ ತವ್ಡೆಚ್ ದಿಲ್ಯಾನಿ ತೆಂಕಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಥೈ ಹೊಲ್ಲಿ ಸಂಗ್ತಿಯಾ ಬಗುನ್ ಲೊಕಾ ಸಗ್ಳ್ಯಿ ದೆವಾಕ್ ಹೊಗ್ಳಾಪ್ ಕರುಲಾಗಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ಥೈ ಹೊಲ್ಲ್ಯಾ ಅಜಾಪಾಚ್ಯಾ ಕಾಮಾನಿ ಗುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನ್ಸಾಸಾಕ್ ಚಾಳಿಸ್ ವರ್ಸಾ ದಾಟಲ್ಲಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ಪೆದ್ರು ಅನಿ ಜುವಾಂವ್ ಥೈತ್ನಾ ಸುಟ್ಕಾ ಹೊಲ್ಯಾ ತನ್ನಾ ಪರ್ತುನ್ ಅಪ್ಲ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಗೆಲೆ, ಅನಿ ಮುಖ್ಯಯಾಜಕಾನ್ ಅನಿ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ತೆಂಕಾ ಸಾಂಗಲ್ಲೆ ಹರ್ ಎಕ್‍ಬಿ ಅಪ್ಲ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಸಾಂಗ್ಲ್ಯಾನಿ . ");
INSERT INTO kans_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ಹೆ ಆಯ್ಕಲ್ಲಿ ದೆವಾಚಿ ಲೊಕಾ ದೆವಾಕ್ ಮಾಗ್ನಿ ಕರುಸಾಟಿ ಎಕಾಕ್ಡೆ ಗೊಳಾ ಹೊಲಿ ಅನಿ ತೆನಿ ಎಕುಚ್ ಮನಾನ್, ಮೊಟ್ಯಾ ಧನಿಯಾ, ಸರ್‍ಗ್ ಅನಿ ಜಿಮಿನ್ ಸಮುಂದರ್ ಅನಿ ಜಗಾತ್ಲೆ ಹರ್ ಎಕ್‍ಬಿ ರಚಲೈ ");
INSERT INTO kans_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ಅಮ್ಚೊ ಪುರ್ವಜ್ ಮಾನುಸ್, ದಾವಿದ್ ತುಜೊ ಸೆವಕ್ ಹೊಲ್ಲೊ ತೆನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚಿ ಮಜ್ಜತ್ ಘೆವ್ನ್ ಹೆ ಗೊಸ್ಟಿಯಾ ಲಿವ್ಲ್ಯಾನ್: ಲೊಕಾ ಸಗ್ಳಿ ಕಶ್ಯಾಕ್ ರಾಗ್ ಹೊತ್ಯಾತ್? ಅನಿ ಫಾಯ್ದ್ಯಾಕ್ ಪಡಿನಸಲಿ ಯವ್ಜನ್ ಕಶ್ಯಾಕ್ ಕರ್ತಾತ್ ? ");
INSERT INTO kans_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ಹ್ಯಾ ಜಗಾತ್ಲೆ ರಾಜಾ ಸಗ್ಳ್ಯೆ ಝಗ್ಡೊ ಕರುಕ್ ತಯಾರ್ ಹೊವ್ನ್ ಹಾತ್; ಧನಿಯಾಕ್ ಅನಿ ಕ್ರಿಸ್ತಾಕ್ ವಿರೊಧ್ ಹೊವ್ನ್ ಮುಂಖಡಾ ಸಗ್ಳ್ಯಿ ಗೊಳಾ ಹೊವ್ನ್ ಯೆಲಾತ್ ಮನುನ್ ಸಾಂಗುಕ್ ಲಾವ್ಲೈ ನ್ಹಯ್ ? ");
INSERT INTO kans_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ಖರೆಚ್ ಬಿ ಹೆರೊದ್ ಅನಿ ಪೊಂತಿಯಸ್ ಪಿಲಾತ್ ಸಗ್ಳ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಅನಿ ಇಸ್ರಾಯೆಲ್ ಲೊಕಾಂಚ್ಯಾ ವಾಗ್ಡಾ ಕ್ರಿಸ್ತ್ ತುಜೊ ಪವಿತ್ರ್ ಸೆವಕಾಕ್ ವಿರೊದ್ ಹೊವ್ನ್ ಶಾರಾತ್ ಗೊಳಾ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ಜೆಜುಕ್ ವಿರೊದ್ ಹೊವ್ನ್ ಗೊಳಾ ಹೊವ್ನ್ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾನಿ ತೆಚಿ ಎವ್ಜುನ್ ಫುರಾ ಹೊಯ್ ಸಾರ್ಕೆ ಕರ್‍ಲ್ಯಾನಿ ತುಜ್ಯಾ ಬಳಾನ್ ಅನಿ ತುಜ್ಯಾ ಚಿತ್ತಾನ್ ಹೆ ಸಗ್ಳ್ಯೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ಧನಿಯಾ ಅತ್ತಾ ತೆನಿ ಸಾಂಗುಲಾಗಲೆ ಆಯ್ಕ್ ತೆನಿ ಅಮ್ಕಾ ಭಿಂವ್‍ಸುಕ್ ಬಗುಲಾಲಾತ್! ಧನಿಯಾ ಅಮಿ ತುಜಿ ಸೆವಕಾ ತುಜಿ ಗೊಸ್ಟಿಯಾ ಭಿಂಯೆ ನಸ್ತಾನಾ ಸಾಂಗುಕ್ ಅಮ್ಕಾ ಮಜತ್ ಕರ್. ");
INSERT INTO kans_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ಪವಿತ್ರ್ ಜೆಜುಚ್ಯಾ ನಾಂವಾನ್ ರೊಗಾತ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಗುನ್ ಕರ್ ಅಜಾಪಾಚಿ ಅನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮಾ ಕರುಕ್ ತುಜೊ ಹಾತ್ ಫಿಡೆ ಕರ್ ಮನುನ್ ತೆನಿ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ಅಶೆ ದೆವಾಚಿ ಲೊಕಾ ಮಾಗ್ನಿ ಕರಿತ್ ರಾತಾನಾ ತೆಂಚೊ ತಾಂಡ್ಯಾ ಗೊಳಾ ಹೊಲ್ಲೊ ಜಾಗೊ ಥರ್ ಥರ್ಲ್ಲೊ ತೆನಿ ಸಗ್ಳ್ಯೆ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರುನ್ ದೆವಾಚಿ ಗೊಸ್ಟಿಯಾ ಭಿಂಯ್ ನಸ್ತಾನಾ ಸಾಂಗುಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚೊ ಮನ್ ಅನಿ ಜಿಂವ್ ಎಕುಚ್ ಹೊತ್ತಿ ತೆಂಚ್ಯಾ ಮದ್ದಿ ಕೊನ್ ಎಕ್ಲೊಬಿ ಅಪ್ನಾಕ್ಡೆ ಹೊತ್ತೆ ಅಪ್ನಾಚೆಚ್ ಮನುನ್ ಸಾಂಗಿನಸಿತ್ ತೆಚ್ಯಾ ಬದ್ಲಾಕ್ ತೆನಿ ಹರ್ ಎಕ್ ಸಾಮಾನಾ ಎಕಾಮೆಕಾಕ್ ವಾಟುನ್ ಘೆಯ್ತ್. ");
INSERT INTO kans_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ಧನಿಯಾ ಜೆಜು ಮರಲ್ಲ್ಯಾ ಕನ್ನಾ ಝಿತ್ತೊ ಹೊಲ್ಲೊ ಖರೆಚ್ ಮನ್ತಲೆ ಅಪೊಸ್ತಲಾನಿ ಲೊಕಾಕ್ನಿ ಸಾಂಗಿತ್ ದೆವಾನ್ ಅಪ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಮೊಟೊ ಆಶಿರ್ವಾದ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ತೆಂಕಾ ಪಾಜೆ ಹೊಲ್ಲೆ ಸಗ್ಳೆ ಸೆತ್, ಘರ್ ಧಾರ್ ಹರ್ ಎಕ್ಲೊಬಿ ತೆ ಇಕುನ್, ");
INSERT INTO kans_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ಯೆಲ್ಲೆ ಪೈಸೆ ಅಪೊಸ್ತಲಾಕ್ನಿ ದಿಯ್ತ್ ತೆ ಪೈಸೆ ಅಪ್ಲ್ಯಾ ಗರಜೆಕ್ ಪಾಜೆ ಹೊಲ್ಲೆ ಸಾರ್ಕೆ ವಾಟುನ್ ದಿಯ್ತ್. ");
INSERT INTO kans_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ತ್ಯಾ ಲೊಕಾತ್ನಿ ಜುಜೆ ಮನ್ತಲೊ ಹೊತ್ತೊ ತೊ ಸೈಪುನ್ ಮನ್ತಲೊ ಗಾಂವಾತ್ ಜಲಮ್ಮಲ್ಲೊ ಎಕ್ ಲೆವಿ ಹೊವ್ನ್ ಹೊತ್ತೊ ತೆಕಾ ಅಪೊಸ್ತಲಾ ಬಾನಾರ್ಬಾ ಮನುನ್ ಬಲ್ಯಿತ್. ಬರ್ನಾಬಾ ಮಟ್ಲ್ಯಾರ್ ಉಮ್ಮೆದ್ ದಿತಲೊ ಮಾನುಸ್, ");
INSERT INTO kans_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ಜುಜೆಕ್ಬಿ ಸೆತ್ ಹೊತ್ತ್ಯೆ ತೆನಿ ತೆ ಇಕುನ್ ಯೆಲ್ಲೆ ಪೈಸೆ ಅಪೊಸ್ತಲಾಕ್ನಿ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ಖರೆ ಅನನಿಯಾ ಮನ್ತಲ್ಯಾ ನಾವಾಚೊ ಎಕ್ ಮಾನುಸ್ ಅನಿ ತೆಚಿ ಬಾಯ್ಕೊ ಸಾಪಿರಾ ದೊಗೆ ಜನಾಬಿ ಮಿಳುನ್ ಅಪ್ಲೆ ಸೆತಾಚೊ ಎಕ್ ಬಾಗ್ ಇಕ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ತೆನಿ ಗಾವಲ್ಲ್ಯಾ ಪೈಸ್ಯಾತ್ ಅಪೊಸ್ತಲಾಕ್ನಿ ದಿತಾನಾ ಉಲ್ಲೆ ಪೈಸೆ ಅಪ್ನಾ ಸಾಟ್ನಿ ಮನುನ್ ನಿಪ್ವುನ್ ಥವ್ನ್ ಘೆಟಲ್ಯಾನಿ ಹೆ ತೆಜಾ ಬಾಯ್ಕೊ ಬಿ ಗೊತ್ತ್ ಅನಿ ತೆನಿ ಬಿ ಹೆಕಾ ಒಪ್ಕಿ ದಿಲ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ತನ್ನಾ ಪೆದ್ರುನ್ ತೆಕಾ ಅನನಿಯಾಕ್ , ತುಜೆ ಸೆತ್ ಇಕುನ್ ಗಾವಾಲ್ಯಾ ಪೈಸಾತ್ ನಿಪ್ವುನ್ ಥವ್ನ್ ಘೆವ್ನ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಕ್ ಮೊಸ್ ಕರ್ತೆ ಕಾಯ್ ಅನಿ ತುಜ್ಯಾ ಮನಾತ್ ಸೈತಾನಾಕ್ ಜಾಗೊ ದಿವಲ್ಲೆ ನ್ಹಯ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ಅದ್ದಿ ಹಿ ಆಸ್ತಿ ತುಜ್ಯಾ ನಾವಾರ್ ಹೊತ್ತೆ ನ್ಹಯ್?, ಅನಿ ತಿ ಆಸ್ತಿ ಅಶೆ ಇಕುನ್ ಗಾವಲ್ಲೆ ಪೈಸೆ ತುಜೆಚ್ ಹೊಲ್ಲೆ ಹೊತ್ತೆ ತುಜ್ಯಾ ಮನಾತ್ ಅಶೆ ಕಶ್ಯಾಕ್ ಯೆವ್ಜಲೈ? ತಿಯಾ ಮಾನ್ಸಾಕ್ ಝುಟೆ ಸಾಂಗುಕ್ ನ್ಹಯ್ ದೆವಾಕುಚ್ ಝುಟೆ ಸಾಂಗ್ಲಯ್. ");
INSERT INTO kans_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ಹಿ ಗೊಸ್ಟ್ ಆಯ್ಕಲ್ಲೊ ತಸೊಚ್ ಅನನಿಯಾ ಖಾಲ್ತಿ ಪಡುನ್ ಮರುನ್ ಗೆಲೊ, ಅನಿ ಹಿ ಖಬರ್ ಅಯ್ಕಲ್ಲಿ ಲೊಕಾ ಸಗ್ಳ್ಯಿ ಘಾಬರ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ಥೊಡಿ ದಾಂಡ್ಗಿ ಮಾನ್ಸಾ ಯೆವ್ನ್ ತೆಜೆ ಮಡೆ ಪಾಳಿತ್ ಲಪ್ಟುನ್ ಉಕ್ಲುನ್ ನೆವ್ನ್ ಮಾಟಿ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ಜಗ್ಗೊಳ್, ಜಗ್ಗೊಳ್ ತಿನ್ ತಾಸ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ತೆಚಿ ಬಾಯ್ಕೊ ಸಾಫಿರಾ ಭುತ್ತುರ್ ಯೆಲಿ ಹಿತ್ತೆ ಹೊಲ್ಲಿ ಸಂಗ್ತಿಯಾ ತಿಕಾ ಗೊತ್‍ ನತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ತನ್ನಾ ಪೆದ್ರುನ್ ತಿಕಾ “ತುಮ್ಚೆ ಸೆತ್ ಇಕಲ್ಲೆ ಪೈಸೆ ಯವ್ಡೆಚ್ ಕಾಯ್?” “ತುಮ್ಕಾ ಕೌವ್ಡೆ ಪೈಸೆ ಗಾವ್ಲೆ ಮನುನ್ ಮಾಕಾ ಖರೆಚ್ ಸಾಂಗ್” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್ , ತನ್ನಾ ಸಾಫಿರಾನ್ “ಹೊಯ್ ಎವ್ಡೆಚ್!” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ಪೆದ್ರುನ್ ತಿಕಾ ತಿಯಾ ಅನಿ ತುಜ್ಯಾ ಘವಾನ್ ಧನಿಯಾಚ್ಯಾ ಆತ್ಮ್ಯಾಕ್ ಪರಿಕ್ಷೆ ಕರಲ್ಲೆ ಕಶ್ಯಾಕ್? ಅಬಕ್‍! ತುಜ್ಯಾ ಘವಾಕ್‍ ಮಾಟಿ ಕರುನ್ ಯೆಲ್ಲಿ ಲೊಕಾ ಧಾರಾತ್ ಇಬೆ ಹಾತ್ ತುಕಾಬಿ ತಸೆಚ್ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಜಾತಾತ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾಲಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ಸಾಫಿರಾಬಿ ತೆಜಾ ಪಾಂಯಾಂಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಪಡುನ್ ಜಿವ್ ಸೊಡ್ಲಿನ್, ತಿ ದಾಂಡ್ಗಿ ಲೊಕಾ ಭುತ್ತುರ್ ಯೆವ್ನ್ ಬಗ್ತಾನಾ ತಿ ಬಿ ಮರುನ್ ಪಡಲ್ಲಿ ತೆನಿ ತೆಕಾ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ತಿಚ್ಯಾ ಘವಾಚ್ಯಾ ಭಾಜುಕ್ ಮಾಟಿ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ಹ್ಯಾ ಸಂಗ್ತಿಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಆಯ್ಕಲ್ಲೆ ದೆವಾಚಿ ಲೊಕಾ ಅನಿ ಸಗ್ಳ್ಯಿ ಲೊಕಾಬಿ ಲೈ ಘಾಬರ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ತೆನಿ ಸಗ್ಳಿ ಲೊಕಾ ಚಮತ್ಕಾರಾಚಿ ಅನಿ ಅಜಾಪಾಚಿ ಕಾಮಾ ಕರ್‍ಲ್ಯಾನಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ತೆಂಚಿ ಕಾಮಾ ಬಗ್ಲ್ಯಾನಿ ತೆನಿ ಸಗ್ಳಿ ಲೊಕಾ ಎಕ್ ಕಡೆ ಗೊಳಾ ಹೊವ್ನ್ ಸೊಲೊಮೊನಾಚ್ಯಾ ಮಾಟ್ವಾತ್ ಮಿಳುನ್ ಯಯ್ತ್ . ");
INSERT INTO kans_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ತಾಂಡ್ಯಾಚ್ಯಾ ಭಾಯ್ಲ್ಯಾಲೊಕಾಕ್ನಿ ತೆಂಚ್ಯಾಕ್ನಾ ಇಬೆ ರಾವ್ಕ್ ಧೈರೊ ನತ್ತೊ ,ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ಲೊಕಾ ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಲೈ ಬರಿ ಗೊಸ್ಟಿಯಾಚ್ ಸಾಂಗಿತ್ . ");
INSERT INTO kans_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ಖರೆ ಲೈ ಲೊಕಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಮಿಳುಲಾಗಲಿ ,ಅನಿ ಲೈ ಲೊಕಾ ಘೊಮಾನ್ಸಾ ಅನಿ ಬಾಯ್ಕಾ ಮನ್ಸಾನಿ ಧನಿಯಾಚೆರ್ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ತಸೆ ಹೊವ್ನ್ ಲೊಕಾ ಸಗ್ಳಿ ಬರೆ ನತ್ಯಾ ಮಾನ್ಸಾಕ್ನಿ ಡಾಳಿಯಾರ್ನಿ ಥವ್ನ್ ,ಪೆದ್ರು ಜಾಯ್ತ್ ರಾತಾನಾ ತೆಚಿ ಸಾವ್ಳಿ ತರಿಬಿ ತೆಂಚ್ಯಾರ್ ಪಡುಂದಿ ಮನುನ್ ತೆಂಕಾ ವಾಟೆರ್ ಹಾನುನ್ ಥೈಯ್ತ್. ");
INSERT INTO kans_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ಜೆರುಜಲೆಮಾತ್ನಾ ಅಜು ಬಾಜುಚ್ಯಾ ಗಾವಾತ್ನಾ ಸಗ್ಳ್ಯಿ ಲೊಕಾ ತಾಂಡೊ ತಾಂಡೊಹೊವ್ನ್ ಯೆಯ್ತ್, ತೆನಿ ರೊಗಾತ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಅನಿ ಮ್ಹಾರು ಧರಲ್ಲ್ಯಾಕ್ನಿ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಯೆಯ್ತ್ ತೆಂಕಾ ಸಗ್ಳ್ಯಾಕ್ನಿ ಗುನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ಮುಖ್ಯ ಯಾಜಕಾ ಅನಿ ತೆಂಚಿ ವಾಂಗ್ಡಿ ಸಾದುಸೆವಾಕ್ನಿ ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ವೈರ್ ಲೈ ಕುಸ್ಡೆ ಪಾನ್ ಹೊಲೆ, ಅನಿ ತೆನಿ ಹೆಂಕಾ ಕಾಯ್ ತರ್ ಕರುಚೆ ಮನುನ್ ಯವ್ಜುನ್ ಘೆಟ್ಲ್ಯಾನಿ . ");
INSERT INTO kans_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ತೆನಿ ಅಪೊಸ್ತಲಾಕ್ನಿ ಧರುನ್ ಸಗ್ಳ್ಯಾಕ್ನಿ ಗೊತ್ತ್ ಹೊತ್ತ್ಯಾ ಮೊಟ್ಯಾ ಬಂಧಿಖಾನ್ಯಾತ್ ಥವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ಖರೆ ತ್ಯಾ ದಿಸಾ ರಾಚ್ಚೆ ಧನಿಯಾಚ್ಯಾ ದುತಾನ್ ಬಂದಿಖಾನ್ಯಾಚಿ ದಾರಾ ಉಗಡ್ಲ್ಯಾನ್ ಅನಿ ಅಪೊಸ್ತಲಾಕ್ನಿ ಭಾಯ್ರ್ ಬಲ್ವುನ್ ಹಾನುನ್ ತೆಂಕಾ, ");
INSERT INTO kans_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ಜಾವ್ನ್ ಗುಡಿತ್ ಇಬೆ ರ್‍ಹಾವಾ, ಅನಿ ನ್ಹವ್ಯಾ ಜಿವನಾಚ್ಯಾ ವಿಶಯಾತ್ ಹರ್ ಎಕ್ಲ್ಯಾಕ್ನಿಬಿ ಸಾಂಗಾ” ಮಟ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ತಸೆ ಹೊವ್ನ್ ತೆನಿ ದುಸ್ರ್ಯಾಂದಿಸಿ ಸಕ್ಕಾಳಿ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಜಾವ್ನ್ ಶಿಕಾಪ್ ಕರುಕ್ ಲಾಗ್ಲೆ. ತೆನಿ ಜುದೆವಾಂಚಿ ಮುಖಂಡಾ ಅನಿ ಇಸ್ರಾಯೆಲಾತ್ಲ್ಯಾ ಪ್ರಮುಖ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಘೆವ್ನ್ ನ್ಯಾಯ್ ಕರ್‍ತಲೊ ತಾಂಡೊ ಮಿಳ್ವುಲ್ಯಾನಿ ತೆಚ್ಯಾ ಮಾನಾ ಅಪೊಸ್ತಲಾಕ್ನಿ ಅಪ್ಲ್ಯಾ ಜಗ್ಗೊಳ್ ಬಲ್ವುನ್ ಹಾನುಕ್ ಮನುನ್ ಥೊಡ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಂಧಿಖಾನ್ಯಾಕ್ಡೆ ಧಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ತಿ ಸೆವಕಾ ಬಂದಿಖಾನ್ಯಾತ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ಥೈ ಅಪೊಸ್ತಲಾ ದಿಸುಕ್ ನಾತ್ ತೆನಿ ಪಾಟಿ ಪರ್ತುನ್ ಯೆವ್ನ್ ನ್ಯಾಯಾ ಸಭೆಕ್ ಕಳ್ವುನ್ಗೆತ್ , ");
INSERT INTO kans_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ಬಂಧಿಖಾನೊ ದಾಪಲ್ಲೊ ಹೊತ್ತೊ, ಅನಿ ಚಾವಿ ಲಾವಲ್ಲಿ ಹೊತ್ತಿ ರಾಕ್ವಾಲಿ ದಾರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಇಬೆ ಹೊತ್ತೆ, ಖರೆ ಅಮಿ ಧಾರ್ ಕಾಡುನ್ ಬಗಲ್ಲ್ಯಾ ತನ್ನಾ ಬಂದಿಖಾನೊ ಖಾಲಿ ಹೊತ್ತೊ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ಗುಡಿಚ್ಯಾ ರಾಕ್ವಾಲ್ಯಾಂಚೊ ಮುಖಂಡ್ ಅನಿ ಮುಖ್ಯ್ ಯಾಜಕಾ ಹೆ ಆಯ್ಕಲ್ಯಾ ಮಾನಾ ಅಪೊಸ್ತಲಾಕ್ನಿ ಕಾಯ್ ಹೊವ್ಕ್ ಫಿರೆ ಮನುನ್ ಅಜಾಪ್ ಹೊಲ್ಲ್ಯಾನಿ . ");
INSERT INTO kans_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ಮಾನಾ ಅನಿ ಎಕ್ಲ್ಯಾನ್ ಯೆವ್ನ್ ತೆಂಕಾ, “ಆಯ್ಕಾ! ತುಮಿ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಟಲ್ಲಿ ಮಾನ್ಸಾ ಗುಡಿತ್ ಇಬೆ ರಾವ್ನ್ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುಲಾತ್” ಮನುನ್ ಸಾಂಗಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ತನ್ನಾ ಅಧಿಕಾರಿನಿ ಅನಿ ಲೊಕಾನಿ ಜಾವ್ನ್ ಅಪೊಸ್ತಲಾಕ್ನಿ ಬಲ್ವುನ್ ಹಾನ್ಲ್ಯಾನಿ , ಖರೆ ಸೈನಿಕಾನಿ ವತ್ತಾಯ್ ಕರುಕ್ ನಾತ್ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್ ತೆನಿ ಲೊಕಾಕ್ನಿ ಭಿಂವ್‍ಲ್ಲ್ಯಾನಿ ಲೊಕಾಕ್ನಿ ರಾಗ್ ಯೆವ್ನ್ ಗುಂಡೆ ಮಾರುನ್ ಅಪ್ನಾಕ್ನಿ ಜಿಂವ್ ಕಾಡ್ತಿಲ್ ಮನುನ್ ಭಿಂವ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ತೆನಿ ಅಪೊಸ್ತಲಾಕ್ನಿ ತಾಂಡ್ಯಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಬಲ್ವುನ್ ಹಾನುನ್ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಇಬೆ ಕರ್‍ಲ್ಯಾನಿ ಮಹಾ ಯಾಜಕಾನಿ ಅಪೊಸ್ತಲಾಕ್ನಿ, ");
INSERT INTO kans_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ಹ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ವಿಶಯಾತ್ ಶಿಕಾಪ್ ಶಿಕ್ವುನಕಾಸಿ ಮನುನ್ ತುಮ್ಕಾ ಸಾಂಗ್ಲ್ಯಾಂವ್, ಖರೆ ತುಮಿ ಕಾಯ್ ಕರ್ಲ್ಯಾಸಿ? ಜೆರುಜಲೆಮಾತ್ ತುಮ್ಚ್ಯಾ ಶಿಕಾಪಾನಿಚ್ ಭರ್ಲ್ಯಾಸಿ, ಜೆಜುಚ್ಯಾ ಮರ್‍ನಾಚಿ ಜವಾಬ್ದಾರಿ ಅಮ್ಚ್ಯಾ ವೈರ್ ಘಾಲುಕ್ ಬಗುಲ್ಯಾಸಿ” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ತನ್ನಾ ಪೆದ್ರುನ್ ಅನಿ ಹುರಲ್ಲ್ಯಾ ಅಪೊಸ್ತಲಾನಿ ಉತ್ತರ್ ದಿಲ್ಯಾನ್ ಅಮಿ ದೆವಾಕ್ ಮಾನುನ್ ಘೆತಾಂವ್ ಖರೆ ಮಾನ್ಸಾಕ್ನಿ ನ್ಹಯ್ ಮಟ್ಲ್ಯಾನ್ ! ");
INSERT INTO kans_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ತುಮಿ ಜೆಜುಕ್ ಜಿವಾನಿ ಮಾರ್ಲ್ಯಾಸಿ ತುಮಿ ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರುನ್ ಜಿಂವ್ ಕಾಡ್ಲ್ಯಾಸಿ , ಖರೆ ದೆವಾನ್ ಮಟ್ಲ್ಯಾರ್ ಅಮ್ಚ್ಯಾ, ವಾಡ್ ವಡ್ಲಾಂಚ್ಯಾ ದೆವಾನುಚ್ ಜೆಜುಕ್ ಮರಲ್ಯಾಕ್ನಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟ್ವುಲ್ಯಾನ್!, ");
INSERT INTO kans_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ಇಸ್ರಾಯೆಲಾಚಿ ಲೊಕಾ ಪಾಪಾಸಾಟಿ ಮನ್ ಪರ್ತುನ್ ಪಾಪಾಕ್ನಾ ಸುಟ್ಕಾ ಘೆವ್ಕ್ ಸಾಟ್ನಿ ದೆವಾನ್ ತೆಕಾ ಅಮ್ಚೊ ರಾಕ್ನಾರಿ ಅನಿ ಮುಂಖಡ್ ಕರುನ್ ಅಪ್ಲ್ಯಾ ಉಜ್ವ್ಯಾ ಬಾಜುಕ್ ಬಸ್ವುನ್ ಘೆಟ್ಲಾ . ");
INSERT INTO kans_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","“ಹ್ಯಾ ಸಂಗ್ತಿಯಾಕ್ನಿ ಅಮಿಚ್ ಸಾಕ್ಷಿ, ಅಮಿ ಯವ್ಡೆಚ್ ನ್ಹಯ್, ತೆಕಾ ಮಾನುನ್ ಘೆಟಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ದೆವಾನ್ ದಿಲ್ಲೊ ಪವಿತ್ರ್ ಆತ್ಮೊಬಿ ಸಾಕ್ಷಿ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ಜುದೆವಾಂಚಿ ಮುಖಂಡಾಕ್ನಿ ಹಿ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುನ್ ತೆಂಚೊ ರಾಗ್ ಲೈ ಚವ್ತಾಳ್ಲೊ, ಅನಿ ತೆನಿ ಅಪೊಸ್ತಲಾಕ್ನಿ ಜಿವ್ ಕಾಡುಚೆ ಮನುನ್ ಯವ್ಜುನ್ ಘೆಟಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ತನ್ನಾ ಫಾರಿಜೆವಾನಿತ್ಲೊ ಎಕ್ಲೊ ತಾಂಡ್ಯಾತ್ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾಲೊ ತೆಜೆ ನಾಂವ್ ಗಮಲಿಯೆಲ್, ತೊ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲಿ ಲೊಕಾ ಕರ್‍ತಲೊ ಮಾನುಸ್ ಹೊಲ್ಲೊ, ಅನಿ ಲೊಕಾ ಸಗ್ಳ್ಯಿ ತೆಕಾ ಮಾನಿತ್ ಥೊಡ್ಯಾ ಎಳಾ ಪತರ್ ಅಪೊಸ್ತಲಾಕ್ನಿ ತಾಂಡ್ಯಾತ್ನಾ ಭಾಯ್ರ್ ಧಾಡುಚೆ ಮನುನ್ ತೆನಿ ಲೊಕಾಕ್ನಿ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ಮಾನಾ ತೆನಿ ಇಸ್ರಾಯೆಲಾಂಚ್ಯಾ ಲೊಕಾನು ತುಮಿ ಹೆಂಕಾ ಬುರ್ಶೆ ಕರುಚೆ ಮನುನ್ ಹೊತ್ತ್ಯಾಚಾ ವಿಶಯಾತ್ ಹುಶ್ಯಾರ್ಕಿನ್ ರ್‍ಹಾವಾ! ");
INSERT INTO kans_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ಎಗ್ದಾ ಥೆಯೊದಾಸ್ ಮನ್ತಲ್ಯಾ ನಾವಾಚೊ ಮಾನುಸ್ ಯೆಲ್ಲೆ ತುಮ್ಕಾ ಯಾದ್ ಅಸಿಲ್? ತೆನಿ ಅಪ್ನಾಕುಚ್ ಮೊಟೊ ಮಾನುಸ್ ಮನುನ್ ಘೆಟಲ್ಲ್ಯಾನ್ ಜಗ್ಗೊಳ್-ಜಗ್ಗೊಳ್ ಚಾರ್ಸಿ ಲೊಕಾ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ ಹೊಲ್ಯಾರ್ ಬಿ ತೆಕಾ ಮಾರುನ್ ಟಾಕಲ್ಲ್ಯಾನಿ ತೆಚಿ ವಾಂಗ್ಡಿಯಾ ಸಗ್ಳಿ ಪರ್‍ತುನ್ ಪಳುನ್ ಗೆಲೆ ತೆಂಚೆನ್ ಕಾಯ್ಬಿ ಕರುಕ್ ಹೊವ್ಕ್‌ ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ತನ್ನಾ ಜುದಾಸ್ ಮನ್ತಲೊ ಗಲಿಲಾಯಕ್ನಾ ಯಲೊ ತೊ ಲೊಕಾಂಚ್ಯಾ ಗನತಿಚೊ ಎಳ್ ಹೊಲ್ಲೊ, ತೆನಿ ಬಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾತಲ್ಯಾ ಲೊಕಾಂಚೊ ಎಕ್ ತಾಂಡೊಚ್ ತಯಾರ್ ಕರ್‍ಲ್ಯಾನ್ ತೆಕಾಬಿ ಮಾರುನ್ ಟಾಕ್ಲ್ಯಾನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾತಲಿ ಲೊಕಾ ಸಗ್ಳಿ ಫಿರುನ್ ಪಳುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“ತಸೆ ಹೊವ್ನ್ ಅತ್ತಾ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಲೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್ ಹ್ಯಾ ಲೊಕಾಂಚ್ಯಾಕ್ನಾ ಧುರ್ ರ್‍ಹಾವಾ, ತೆಂಚ್ಯಾ ಎವ್ಡ್ಯಾಕ್ ತೆಂಕಾ ಸೊಡುನ್ ಸೊಡಾ ತೆಂಚಿ ಯೌಜನ್ ಮಾನ್ಸಾಂಚ್ಯಾಕ್ನಾ ಯೆಲ್ಲಿ ಹೊಲ್ಯಾರ್ ಪಡುನ್ ಜಾತಾ”. ");
INSERT INTO kans_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ಖರೆ ತಿ ಯವ್ಜನ್ ದೆವಾಕ್ನಾ ಯೆಲ್ಲಿ ಹೊಲ್ಯಾರ್ ತುಮಿ ತೆಂಕಾ ಅಡ್ಕಳ್ ಕರುಕ್ ಹೊಯ್ನಾ ತುಮಿ ದೆವಾಕುಚ್ ವಿರೊಧ್ ಹೊವ್ನ್ ಝಗ್ಡೊ ಕರ್‍ಲೆ ಸಾರ್ಕೆ ಹೊತಾ! ಮನುನ್ ಸಾಂಗಲ್ಯಾನ್ ತನ್ನಾ ಗಮಲಿಯೆಲಾಚ್ಯಾ ಸಲಹಾಕ್ನಿ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಒಪ್ಪುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ತೆನಿ ಅಪೊಸ್ತಲಾಕ್ನಿ ಭುತ್ತುರ್ ಬಲ್ವುನ್, ಮಾರುನ್, ಜೆಜುಚ್ಯಾ ನಾಂವಾಚ್ಯಾ ವಿಶಯಾತ್ ತುಮಿ ಸಾಂಗುಚೆ ನ್ಹಯ್ ಮನುನ್ ಹುಶ್ಯಾರ್ಕಿ ದಿವ್ನ್ ಧಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ಹಿ ಅಪೊಸ್ತಲಾ ನ್ಯಾಯ್ ಕರ್ತಲ್ಯಾ ಸಭೆತ್ನಾ ಬಾಯ್ರ್ ಗೆಲೆ ಜೆಜುಚ್ಯಾ ನಾಂವಾ ಸಾಟ್ನಿ ಅವಮಾನ್ ಕರುನ್ ಘೆವ್ಕ್ ಅಮಿಬಿ ಸಕ್ತಾಂವ್ ಮನುನ್ ಕುಶಿ ಹೊಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ತೆನಿ ಲೊಕಾಕ್ನಿ ಶಿಕ್ವುತಲೆ ಬಂದ್ ಕರುಕ್ನಾತ್, ಜೆಜುಚ್ ಕ್ರಿಸ್ತ್ ಮನ್ತತ್ಲಿ ಬರಿ ಖಬರ್ ಲೊಕಾಕ್ನಿ ಸಾಂಗುಲಾಲೆ ತೆನಿ ಹರ್ ಎಕ್ ದಿಸಾಬಿ ಗುಡಿತ್ನಿ, ಅನಿ ಲೊಕಾಂಚ್ಯಾ ಘರಾತ್ನಿ ಶಿಕಾಪ್ ಕರಿತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ಜೆಜುಚ್ಯಾ ಶಿಸಾಂಚೊ ಅಂಕೊ ಜಾಸ್ತಿ ಹೊವ್ನನ್ಗೆತ್ ಹೊತ್ತೊ, ಖರೆ ತ್ಯಾ ಎಳಾರ್ ಗ್ರಿಕ್ ಬೊಲ್ತಲ್ಯಾ ಅನಿ ಥೈಚ್ ರಾತಲ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಮದ್ದಿ ಝಗ್ಡೊ ಉಟ್ಲೊ, ಗ್ರಿಕ್ ಬೊಲ್ತಲ್ಯಾ ಜುದೆವಾನಿ ಅಪ್ನಾಚ್ಯಾ ಮದ್ಲ್ಯಾ ವಿದವ್ ಬಾಯ್ಕಾಕ್ನಿ ಸದ್ದಿಚ್ಯಾ ವಾಟ್ನಿಚ್ಯಾ ಎಳಾರ್ ಧ್ಯಾನ್ ದಿವ್ನ್ ಹೊಯ್ನಾ ಹೊಲಾ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ತನ್ನಾ ಬಾರಾ ಲೊಕಾ ಅಪೊಸ್ತಲಾನಿ ಸಗ್ಳ್ಯಾ ಶಿಸಾಂಚೊ ತಾಂಡೊ ಎಕಾಕ್ಡೆ ಬಲ್ವುನ್ ತೆಂಕಾ,ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಶಿಕ್ವುತಲ್ಯಾಚ್ಯಾ ಬದ್ಲಾಕ್ ಪೈಶ್ಯಾ ಪಾನಿಯಾಚೆಚ್ ವಿಶಯ್ ಘೆವ್ನ್ ಅಮಿ ಬಸ್ತಲೆ ಸಮಾ ನ್ಹಯ್! ");
INSERT INTO kans_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","“ತಸೆ ಹೊವ್ನ್ ಭಾವಾನು ಅನಿ ಭೆನಿಯಾನು ತುಮ್ಚ್ಯಾ ಮದ್ಲ್ಯಾ ಲೊಕಾನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸಾರ್ಕೆ, ಬುದ್ದ್ ಹೊತ್ತೆ ಅನಿ ಅನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರಲ್ಲ್ಯಾ ಸಾತ್ ಲೊಕಾಕ್ನಿ ಎಚುನ್ ಕಾಡಾ, ಅಮಿ ತೆಂಕಾ ಹೆ ಕಾಮ್ ಒಪ್ಸುನ್ ದಿತಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ತನ್ನಾ ಅಮಿ ಅಮ್ಚೊ ಎಳ್ ಸಗ್ಳೊ ಮಾಗ್ನಿ ಕರುಕ್ ಅನಿ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಶಿಕ್ವುಕ್ ಹೊತಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಹಿ ಯೆವ್ಜನ್ ಸಮಾ ದಿಸ್ಲಿ, ತಸೆ ಹೊವ್ನ್ ಹ್ಯಾ ಸಾತ್ ಲೊಕಾಕ್ನಿ ಎಚುನ್ ಘೆಟ್ಲ್ಯಾನಿ : ಸ್ತೆಪನ್ ಮನ್ತಲೊ ಮೊಟ್ಯಾ ವಿಶ್ವಾಸಾಚೊ ಅನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರಲ್ಲೊ ಮಾನುಸ್, ಫಿಲಿಪ್ಪ್, ಪ್ರೊಖೊರ್, ನಿಕನೊರ್, ತಿಮೊನ್, ಪರ್ಮೆನ್, ಅನಿ ನಿಕ್ಲಾಂವ್ ಮನ್ತಲೊ ಜುದೆವ್ ಧರ್ಮಾಕ್ ಯೆಲ್ಲೊ ಮಾನುಸ್ ಹ್ಯೊ ಅಂತಿಯೊಕಾಚೊ. ");
INSERT INTO kans_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ತನ್ನಾ ಹ್ಯಾ ಸಾತ್ ಲೊಕಾಕ್ನಿ ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಇಬೆ ಕರ್‍ಲ್ಯಾನಿ, ಅಪೊಸ್ತಲಾನಿ ಮಾಗ್ನಿ ಕರುನ್ ತೆಂಚ್ಯಾ ಟಕ್ಲ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ಅಪ್ಲಿ ಹಾತಾ ಥವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ದೆವಾಚಿ ಗೊಸ್ಟಿಯಾ ಲೈ ಲೊಕಾಕ್ನಿ ಜಾವ್ನ್ ಪಾವುಕ್‍ ಲಾಗ್ಲಿ, ಜೆರುಜಲೆಮಾತ್ಲ್ಯಾ ಶಿಸಾಂಚೊ ತಾಂಡೊ ಲೈ ವಾಡುನ್ಗೆತ್‍ ಯೆಲೊ, ಲೈ ಜುದೆವಾಂಚ್ಯಾ ಯಾಜಕಾನಿ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನಿ ಅನಿ ಮಾನ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ಸ್ತೆಪನ್ ದೆವಾಚ್ಯಾ ಕುರ್ಪೆನ್ ಅನಿ ಬಳಾನ್ ಭರುನ್ ಅಜಾಪಾ ಅನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮಾ ಕರುಂಗೆತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ಖರೆ ಥೊಡಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಯೆವ್ನ್ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ವಾದ್ ಕರ್‍ಲ್ಯಾನಿ, ಹಿ ಲೊಕಾ ಜುದೆವಾಂಚ್ಯಾ ಸಿನಾಗೊಗಾಕ್ ಸಮಂದ್ ಪಡಲ್ಲಿ, ತೆಕಾ ಸುಟ್ಕಾ ಹೊಲ್ಲ್ಯಾಂಚೆ ಸಿನಾಗೊಗ್ ಮನುನ್ ಬಲ್ವಿತ್, ಸಿರೆನಾತ್ನಾ ಅನಿ ಅಲೆಕ್ಸಾಂಡ್ರಿಯಾತ್ನಾ ಜುದೆವಾಂಚ್ಯಾಸಾಟ್ನಿ ಹೆ ಸಿನಾಗೊಗ್ ಹೊತ್ತೆ, ಸಿಲಿಸಿಯಾ ಅನಿ ಎಶ್ಯಾತ್ನಾ ಯೆಲ್ಲಿ ಜುದೆವಾಂಚಿ ಲೊಕಾಬಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತಿ, ತೆನಿ ಸಗ್ಳ್ಯಾನಿ ಯೆವ್ನ್ ಸ್ತೆಪನಾಚ್ಯಾ ವಿರೊದ್ ವಾದ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ಖರೆ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಸ್ತೆಪನಾಕ್ ಶಾನೆಪಾನಾನ್ ಬೊಲುಕ್ ಮಜತ್ ಕರ್‍ಲ್ಯಾನ್, ಸ್ತೆಪನಾಚಿ ಬೊಲ್ನಿ ಲೈ ಬಳಾಚಿ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ಸಾಟ್ನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ತೆಂಕಾ ವಾದ್ ಕರುಕ್ ಹೊಯ್ನಸ್ತಾನಾ, ");
INSERT INTO kans_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","“ಸ್ತೆಪನ್ ಮೊಯ್ಜೆಕ್ ಅನಿ ದೆವಾಕ್ ದೊಗ್ಯಾಕ್ನಿ ವಿರೊದ್ ಹೊವ್ನ್ ಬುರ್ಶಿ ಗೊಸ್ಟಿಯಾ ಸಾಂಗ್ತಾ; ತೆ ಅಮಿಚ್ ಆಯಿಕ್ಲಾವ್” ಮನುನ್ ಸಾಂಗುಚೆ ಬಗಾ ಮನುನ್ ಥೊಡ್ಯಾ ಲೊಕಾಕ್ನಿ ಪೈಸೆ ದಿವ್ನ್ ಶಿಕ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ಅಶೆ ಹ್ಯಾ ಜುದೆವಾನಿ ಲೊಕಾಕ್ನಿ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾಕ್ನಿ ಅನಿ ಖಾಯ್ದೆ ಶಿಕ್ವುತಲ್ಯಾಕ್ನಿ ಕಿಡ್ವುಲ್ಯಾನಿ, ತೆನಿ ಲೈ ರಾಗಾನ್ ಯೆವ್ನ್ ಸ್ತೆಪನಾಕ್ ಧರುನ್ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾಂಚ್ಯಾ ಝಡ್ತಿ ಕರ್ತಲ್ಯಾ ತಾಂಡ್ಯಾಕ್ಡೆ ಬಲ್ವುನ್ ನ್ಹೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ತನ್ನಾ ಹ್ಯಾ ಲೊಕಾಕ್ನಿ ಝುಟಿ ಸಾಕ್ಷಿ ಸಾಂಗ್ತಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಲ್ವುನ್ ಹಾನುನ್, “ಹ್ಯೊ ಮಾನುಸ್ ಹ್ಯಾ ಪವಿತ್ರ್ ಗುಡಿಚ್ಯಾ ವಿರೊದ್ ಹೊವ್ನ್ ಅನಿ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾಚ್ಯಾಬಿ ವಿರೊದ್ ಹೊವ್ನ್ ಕನ್ನಾಬಿ ಬುರ್ಶಿ ಗೊಸ್ಟಿಯಾ ಬೊಲ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ನಜರೆತಾತ್ಲೊ ಜೆಜು ಹಿ ಗುಡಿ ಪಾಡ್ವುನ್ ಮೊಯ್ಜೆಚೆ ಖಾಯ್ದೆ ಬದಲ್ತಾ ಮನುನ್ ಹ್ಯೊ ಮಾನುಸ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೆ ಅಮಿ ಆಯಿಕ್ಲಾಂವ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ತಾಂಡ್ಯಾತ್ ಬಸಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ಸ್ತೆಪನಾಚ್ಯಾ ತೊಂಡಾಕುಚ್ ಬಗ್ಲ್ಯಾನಿ, ತೆಚೆ ತೊಂಡ್ ತೆಂಕಾ ದೆವಾಚ್ಯಾ ದುತಾಂಚ್ಯಾ ತೊಂಡಾ ಸಾರ್ಕೆ ಹೊಳ್ವುತಲೆ ದಿಸ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ತನ್ನಾ ಮಾಹಾಯಾಜಕಾನ್ ಸ್ತೆಪನಾಕ್, “ಮಿಯಾ ಹಿ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕಲೆ ಖರೆ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ತನ್ನಾ ಸ್ತಪೆನಾಕ್ ಮಾಜ್ಯಾ ಭಾವಾನು ಅನಿ ಬಾಬಾನು, ಮಿಯಾ ಸಾಂಗ್ತಲೆ ಆಯ್ಕಾ, ಅಮ್ಚೊ ಪುರ್ವಜ್ಯಾಂಚೊ ಬಾಬಾ ಅಬ್ರಾಹಾಮ್ ಹಾರಾನಿತ್ ರ್‍ಹಾವ್ಚ್ಯಾ ಅದ್ದಿ ಮೆಸೆಪೊತಾಮ್ಯಾತ್ ಹೊತ್ತೊ, ದೆವಾನ್ ತೆಕಾ ಅಪ್ಲ್ಯಾ ಮಹಿಮಾನ್ ದಾಕ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ಅನಿ ದೆವಾನ್ ತೆಕಾ ತಿಯಾ ತುಜಿ ಸ್ವತಾಚಿ ಲೊಕಾ, ಅನಿ ತುಜೊ ದೆಶ್ ಸೊಡುನ್ ಮಿಯಾ ದಾಕ್ವಲ್ಲ್ಯಾ ದೆಶ್ಯಾಕ್ ಜಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ತನ್ನಾ ತೊ ಖಾಲ್ದೆಯಾ ಮನ್ತಲೊ ದೆಶ್ ಸೊಡುನ್ ಹಾರಾನ್ ಮನ್ತಲ್ಯಾ ದೆಶ್ಯಾಕ್ ಜಾವ್ನ್ ವಸ್ತಿ ಹೊತ್ತೊ, ಅನಿ ತೆಜೊ ಬಾಬಾ ಮರಲ್ಲ್ಯಾ ಮಾನಾ ದೆವಾನ್ ತೆಕಾ ಅತ್ತಾ ತುಮಿ ಹೊತ್ಯಾ ಹ್ಯಾ ಜಾಗ್ಯಾಕ್ ಧಾಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ಖರೆ ದೆವಾನ್ ತೆಕಾ ಖಲೆ ಸೆತ್ ಬಿ ದಿವ್ಕ್ ನಾ, ಎಕ್ ಗೆನ್ಬರ್ ಜಾಗೊ ಬಿ ದೆವಾನ್ ತೆಕಾ ದಿವ್ಕ್ ನಾ, ಖರೆ ತೆಕಾ ಅಜುನ್ ಪೊರಾಬಿ ಹೊವ್ಚ್ಯಾ ಅದ್ದಿಚ್ ತುಕಾ ಅನಿ ತುಜ್ಯಾ ಪೊರಾಕ್ನಿ ಹ್ಯೊ ದೆಶ್ ಮಿಯಾ ದಿತಾ ಮನುನ್ ದೆವಾನ್ ತೆಕಾ ಗೊಸ್ಟ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ಅನಿ ದೆವಾನ್ ತೆಕಾ , ತುಜ್ಯಾ ಪಿಳ್ಗಿಚಿ ಲೊಕಾ , ದುಸ್ರ್ಯಾ ದೆಶ್ಯಾತ್ ರ್‍ಹಾತ್ಯಾತ್ ಅನಿ ತೆನಿ ಥೈ ದುಸ್ರಿ ಲೊಕಾ ಸಾರ್ಕೆ ಹೊವ್ನ್ ರ್‍ಹಾತ್ಯಾತ್, ಥೈತ್ಲಿ ಮಾನ್ಸಾ ತೆಂಕಾ ದಾಸ್ ಕರುನ್ ಘೆವ್ನ್ ಸುಮಾರ್ ಚಾರ್ ಸೆಂಬರ್ ವರ್ಸಾ ಕ್ರುರ್ ಹೊವ್ನ್ ಚಾಲ್ವುತಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ಖರೆ ತೆಂಕಾ ಗುಲಾಮ್ ಕರುನ್‍ ಘೆಟಲ್ಯಾಕ್ನಿ ಮಿಯಾಚ್ ಝಡ್ತಿ ಕರ್‍ತಾ ,ಅನಿ ತುಜ್ಯಾ ಪಿಳ್ಗಿಚಿ ಲೊಕಾ ತ್ಯಾ ದೆಶ್ಯಾತ್ನಾ ಭಾಯ್ರ್ ಪಡುನ್ ಯೆವ್ನ್ ಮಾಕಾ ಹ್ಯಾ ಜಾಗ್ಯಾರ್ ಆರಾದನ್ ಕರ್ತಾತ್, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ಮಾನಾ ದೆವಾನ್ ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಎಕ್ ಕರಾರ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನ್, ತ್ಯಾ ಕರಾರಾಚಿ ವಳಕ್‍ ಸುನ್ನತ್ ಕರ್‍ತಲೆ, ತಸೆ ಹೊವ್ನ್ ತೆನಿ ಲೆಕಾಕ್ ಆಟ್ವ್ಯಾ ದಿಸಾಕ್ ಸುನ್ನತ್ ಕರಸ್ಲ್ಯಾನ್, ಇಸಾಕಾನ್ಬಿ ಅಪ್ಲೊ ಲೆಕ್ ಜಾಕೊಬಾಕ್ ಸುನ್ನತ್ ಕರಸ್ಲ್ಯಾನ್, ಅನಿ ಜಾಕೊಬಾನ್ ಅಮ್ಚಿ ಪುರ್ವಜ್ ಲೊಕಾ ಹೊವ್ನ್ ಹೊತ್ಯಾ ಅಪ್ಲ್ಯಾ ಬಾರಾ ಲೆಕಾಕ್ನಿಬಿ ಸುನ್ನತ್ ಕರಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ಜಾಕೊಬಾಚ್ಯಾ ಲೆಕಾನಿ ಅಪ್ಲೊ ಧಾಕ್ಲೊ ಭಾವ್ ಜುಜೆಕ್ ಕುಸ್ಡೆಪಾನಾನ್ ಇಜಿಪ್ತ್ ದೆಶಾಕ್ ಇಕುನ್ ಸೊಡ್ಲ್ಯಾನಿ, ಖರೆ ಥೈ ದೆವ್ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ತೆಕಾ ಯೆಲ್ಲ್ಯಾ ತರಾಸಾಂತ್ನಾ ದೆವಾನ್ ಸೊಡ್ವುಲ್ಯಾನ್, ಇಜಿಪ್ತ್ ದೆಶಾತ್ ಫೆರೊಹ್ ರಾಜಾಕ್ನಾ ದಯಾ ಗಾಯ್ ಸಾರ್ಕೊ ಹೊಲೆ, ಅನಿ ತೆಕಾ ರಾಜಾನ್ ಇಜಿಪ್ತ್ ,ಅನಿ ಅಪ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಅದಿಪತಿ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ತನ್ನಾ ತ್ಯಾ ಇಜಿಪ್ತ್ ಅನಿ ಕಾನಾನ್ ದೆಶಾತಾತ್ನಿ, ಲೈ ಬರ್ಗಾಲ್ ಯೆವ್ನ್ ಅಮ್ಚ್ಯಾ ಪುರ್ವಜಾಕ್ನಿಬಿ ಜೆವಾನ್ ಖಾನ್ ಗಾವ್ಕ್ ನಾ . ");
INSERT INTO kans_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ಇಜಿಪ್ತ್ ದೆಶಾತ್ ಖಾತಲಿ ದಿನ್ಸಾ ಗೊಳಾ ಕರುನ್ ಥವಲ್ಲೆ ಹಾಯ್ ಮನುನ್ ಜಾಕೊಬಾಚ್ಯಾ ಕಾನಾಕ್ ಆಯ್ಕುಕ್ ಯೆಲ್ಲೆ, ಅನಿ ಅಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಪುರ್ವಜ್ ಲೊಕಾಕ್ನಿ ಥೈ ಧಾಡುನ್ ದಿಲ್ಯಾನ್, ಹಿ ತೆಂಚಿ ಇಜಿಪ್ತಾಕ್ ಅದ್ಲಿ ಭೆಟ್, ");
INSERT INTO kans_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ಜುಜೆಚಿ ಭಾವಾ ದೊನ್ವ್ಯಾಪಟಿ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಅಪ್ಲಿ ವಳಕ್ ಭಾವಾಕ್ನಿ ಸಾಂಗ್ಲ್ಯಾನ್, ಅನಿ ಜುಜೆಚ್ಯಾ ಘರಾನ್ಯಾಚ್ಯಾ ಬದಲ್ ಫೆರೊಹ್ ರಾಜಾಕ್ಬಿ ಗೊತ್ತ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ಮಾನಾ ಜುಜೆನ್ ಅಪ್ಲೊ ಬಾಬಾ ಜಾಕೊಬ್ ಅನಿ ಅಪ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಘರಾನ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಇಜಿಪ್ತಾಕ್ ಬಲ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ತೆನಿ ಸಗ್ಳೆ ಮಿಳುನ್ ಸತ್ತರಾರ್ ಸಾತ್ ಲೊಕಾ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ಮಾನಾ ಜಾಕೊಬ್ ಇಜಿಪ್ತ್ ದೆಶಾಕ್ ಗೆಲೊ, ಅಮ್ಚ್ಯಾ ಪುರ್ವಜಾಂಚೆ ಮ್ಹರಾನ್ ಹೊಯ್ ಪತರ್ ಬಿ ತೆನಿ ಥೈಚ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ಮಾನಾ ತೆಂಚಿ ಹಾಡ್ಡಾ ಶೆಕೆಮಾಕ್ ನ್ಹೆವ್ನ್ ಹೊಲೆ,ಅನಿ ಅಬ್ರಾಹಾಮಾನ್ ಹೆಮೊರಾಚ್ಯಾ ಪೊರಾಕ್ನಿ ಚಾಂದಿಚೆ ಪೈಸೆ ದಿವ್ನ್ ಇಕಾತ್ ಘೆಟಲ್ಯಾ ಸಮಾದಿತ್ ತೆಂಕಾ ಮಾಟಿ ದಿವ್ನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ಖರೆ ದೆವಾನ್ ಅಬ್ರಾಹಾಮಾಕ್ ದಿಲ್ಲಿ ಗೊಸ್ಟ್ ಫುರಾ ಹೊತಲೊ ಯೆಳ್ ಜಗ್ಗೊಳ್ ಯೆಲ್ಲೊ, ಅನಿ ಇಜಿಪ್ತ್ ದೆಶ್ಯಾತ್ ಹೊತ್ತ್ಯಾ ಅಮ್ಚ್ಯಾ ಲೊಕಾಂಚೊ ಅಂಕೊ ಲೈ ವಾಡುಂಗೆತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ಅಶೆ ರ್‍ಹಾತಾನಾ, ಆಕ್ರಿಚ್ಯಾ ಎಳಾರ್ ಜುಜೆಚ್ಯಾ ವಿಶಯಾತ್ ಗೊತ್ತ್ ನಸಲ್ಲೊ ದುಸ್ರೊ ಎಕ್ಲೊ ಇಜಿಪ್ತಾತ್ ರಾಜಾ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ಹ್ಯೊ ರಾಜಾ ಅಮ್ಚ್ಯಾ ಅದ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ವಿರೊದ್ ಬುರ್ಶೆ ಚಿಂತುನ್ ತೆಂಚ್ಯಾ ಬಾಳ್ಸ್ಯಾಕ್ನಿ ಜಿವ್ ಕಾಡುಚೆ ಮನುನ್ ತೆಂಕಾ ಘರಾತ್ನಾ ಬಾಯ್ರ್ ಥವ್ಕ್ ಸಾಂಗಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ತ್ಯಾ ಎಳಾರ್ ಮೊಯ್ಜೆ ಉಪಾಜ್ಲೊ, ಅನಿ ತೊ ಬಗುಕ್ ಎಗ್ದಮ್ ಬರೊ ದಿಸಿ ಅನಿ ತೆಚ್ಯಾ ಬಾಬಾಚ್ಯಾ ಘರಾತ್ ತೆಕಾ ತಿನ್ ಮೈನೆ ಬಾಳ್ಗುನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ಅನಿ ತೆಕಾ ಘರಾತ್ನಾ ಭಾಯ್ರ್ ಟಾಕಲ್ಲ್ಯಾ ತನ್ನಾ ಫೆರೊಹ್ ರಾಜಾಚ್ಯಾ ಲೆಕಿನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ತೆಕಾ ಅಪ್ಲ್ಯಾ ಸ್ವಂತ್ ಲೆಕಾ ಸಾರ್ಕೆ ಬಾಳಗ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ಇಜಿಪ್ತ್ ದೆಶಾತ್ಲಿ ಸಗ್ಳ್ಯಿ ಶಿಕಾಪಾ ಸಿಕ್ವುಲ್ಯಾನಿ, ತೊ ಬೊಲ್ನ್ಯಾತ್ನಿ ಅನಿ ಉಶ್ಯಾರ್ಕಿಚಿ ಕಾಮಾ ಕರುಕ್ ತಯಾರ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ತೆಕಾ ಚಾಳಿಸ್ ವರ್ಸಾ ಹೊಲ್ಯಾ ತನ್ನಾ ಇಸ್ರಾಯೆಲಾತ್ನಾ ಯೆವ್ನ್ ಹೊತ್ಯಾ ಅಪ್ಲ್ಯಾ ಭಾವಾಕ್ನಿ ಭೆಟುಚೆ ಮನುನ್ ನಿರ್ದಾರ್ ಕರ್ಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ಇಜಿಪ್ತಾತ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾಕ್ ಅನ್ನ್ಯಾಯ್ ಹೊತಲೆ ಬಗುನ್ ಮೊಯ್ಜೆ ತೆಕಾ ತರಾಸ್ ದಿವ್ಕ್ ಲಾಗಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಲೈ ಮಾರುನ್ ಜಿವ್ ಕಾಡುನ್ ತೆಜೊ ಶೆಡ್ ಕಾಡುನ್ ಘೆತಾ. ");
INSERT INTO kans_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ದೆವಾನ್ ಅಮ್ಕಾ ಸುಟ್ಕಾ ಕರುನ್ ರಾಕ್ವನ್ ಕರುಕ್ ಸಾಟ್ನಿ ಅಪ್ನಾಕ್ ಧಾಡ್ಲಾ ಮನುನ್ ತೆನಿ ಕಳ್ವುನ್ ಘೆಂವ್ದಿ ಮನುನ್ ಮೊಯ್ಜೆನ್ ಚಿಂತ್ಲ್ಯಾನ್, ಖರೆ ತೆನಿ ತೆ ಕಳ್ವುನ್ ಘೆವ್ಕ್ ನಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ದುಸ್ರ್ಯಾಂದಿಸಿ ತೆನಿ ಎಕಾಮೆಕಾಕ್ನಿ ಮಾರುನ್ ಘೆಯ್ತ್ ರಾತಾನಾ ತೊ ಮೊಯ್ಜೆ ತೆಂಚ್ಯಾ ಇದ್ರಾಕ್ ಯೆವ್ನ್ ಸಮಾಧಾನ್ ಕರುಕ್ ಸಾಟ್ನಿ ತೆಂಕಾ, ತುಮಿ ಭಾವ್ ಭಾವಾ ಹೊವ್ನ್ ಬಿ ಕಶ್ಯಾಕ್ ಎಕಾಮೆಕಾಕ್ ದುಕ್ವುನ್ ಘೆತ್ಯಾಶಿ? ಮನುನ್ ಇಚಾರುಕ್ ಗೆಲೊ . ");
INSERT INTO kans_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ತ್ಯಾತುರ್ಲ್ಯಾ ಎಕ್ಲ್ಯಾನ್ ತೆಕಾ ಅಮ್ಕಾ ಅನ್ನ್ಯಾಯ್ ಕರ್‍ತಲೊ, ನಾಹೊಲ್ಯಾರ್ ಮುಖಂಡ್ ಅನಿ ನ್ಯಾಯ್ ಕರ್ತಲೊ ಕರುನ್ ತುಕಾ ಕೊನಿ ತರಿಬಿ ಥವ್ಲಾತ್ ಕಾಯ್? ನಾ! ");
INSERT INTO kans_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ಕಾಲ್ ತಿಯಾ ಇಜಿಪ್ತಾತ್ಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಜಿವಾನಿ ಮಾರಲ್ಲ್ಯಾ ಸಾರ್ಕೆ ಮಾಕಾಬಿ ಜಿವಾನಿ ಮಾರುಚೆ ಮನುನ್ ಹಾಸ್ ಕಾಯ್? ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ಹಿ ಖಬರ್ ಆಯ್ಕುನ್ ಮೊಯ್ಜೆನ್ ಇಜಿಪ್ತ್ ದೆಶ್ ಸೊಡುನ್ ಮಿದಿಯಾನ್ ಮನ್ತಲ್ಯಾ ದೆಶಾಕ್ ಪಳುನ್ ಜಾವ್ನ್ ಥೈ ದುಸ್ರ್ಯಾ ದೆಶಾಚೊ ಸಾರ್ಕೊ ಹೊವ್ನ್ ಜಿವನ್ ಕರಿತ್ ಹೊತ್ತೊ, ಅನಿ ತೆಕಾ ಥೈ ದೊನ್ ಲೆಕಾ ಉಪಾಜ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ಚಾಳಿಸ್ ವರ್ಸಾ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ದೆವಾಚೊ ದುತ್ ತೆಕಾ ಸಿನಾಯ್ ಮನ್ತಲ್ಯಾ ಗುಂಡಾಚ್ಯಾ ಡಂಗ್ಳಿತ್ ಕಾಟ್ಯಾಂಚ್ಯಾ ಝಿಳಿತ್ ಜಳ್ತಲ್ಯಾ ಆಗಿತ್ ದಿಸ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ಮೊಯ್ಜೆಕ್ ತೆ ಬಗುನ್ ಅಜಾಪ್ ಹೊವ್ನ್ ಜಗ್ಗೊಳ್ ಜಾವ್ನ್ ಬಗುಚೆ ಮನುನ್ ಜಾವ್ಕ್ ಲಾಗಲ್ಯಾ ತನ್ನಾ, ತೆಕಾ ಎಕ್ ಧನ್ ಆಯ್ಕೊಯೆಲಿ ತಿ ಧನ್ ಧನಿಯಾಚಿ ಹೊಲ್ಲಿ, ");
INSERT INTO kans_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ಧನಿಯಾನ್ ತೆಕಾ ಮಿಯಾಚ್ ತುಜ್ಯಾ ಬಾಬಾಂಚೊ ದೆವ್ ,ಅಬ್ರಾಹಾಮಾಚೊ, ಇಸಾಕಾಚೊ, ಅನಿ ಜಾಕೊಬಾಚೊ ದೆವ್ ಮಟ್ಲ್ಯಾನ್, ತನ್ನಾ ಮೊಯ್ಜೆ ತ್ಯಾ ಝಿಳಿಕ್ ಬಗುಕ್ ಬಿಂವ್ನ್ ಥರ್ ಥರ್‍ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ತೆಕಾ ಧನಿಯಾನ್ “ತುಜಿ ವ್ಹಾನಾ ಕಾಡುನ್ ಟಾಕ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತಿಯಾ ಇಬೆ ಹೊತ್ತೊ ಜಾಗೊ ಪವಿತ್ರ್ ಮನುನ್ ತೆನಿ ಸಾಂಗಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ಇಜಿಪ್ತಾತ್ ಮಾಜಿ ಲೊಕಾ ಲೈ ತರಾಸ್ ಕರುನ್ ಘೆವ್ಕ್ ಲಾಗಲೆ ಮಿಯಾ ಬಗಟ್ಲಾ ಅನಿ ತೆಂಚೊ ವಿಳಾಪ್ ಮಿಯಾ ಆಯ್ಕ್ಲಾ, ತೆಂಕಾ ಸುಟ್ಕಾ ದಿವ್ಕ್ ಮನುನ್ ಮಿಯಾ ಉತ್ರುನ್ ಯೆಲಾ, ಮೊಯ್ಜೆ ಅತ್ತಾ ಮಿಯಾ ತುಕಾ ಇಜಿಪ್ತಾಕ್ ಧಾಡುನ್ ದಿತಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ಆಗಿನ್ ಜಳುಕ್ಲಾಗಲ್ಯಾ ಝಿಳಿತ್ ಮೊಯ್ಜೆನ್ ದೆವ್ ದುತಾಕ್ ಬಗಲ್ಯಾನ್, ದೆವಾನ್ ತ್ಯಾ ದುತಾಕ್ನಾಚ್ ಮೊಯ್ಜೆಕ್ ಇಸ್ರಾಯೆಲ್ ಲೊಕಾಕ್ನಿ ಸುಟ್ಕಾ ಕರ್‍ತಲೊ ಅನಿ ಅದಿಪತಿ ಕರುನ್ ಧಾಡಲೆ, ಖರೆ ತ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ಅಮ್ಚೊ ಮುಖಂಡ್ ಅನಿ ಝಡ್ತಿ ಕರ್‍ತಲೊ ಮನುನ್ ತುಕಾ ಕೊನಿತರಿ ಸಾಂಗ್ಲಾತ್ ಕಾಯ್? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ತಸೆ ಹೊವ್ನ್ ಮೊಯ್ಜೆನ್ ಲೊಕಾಕ್ನಿ ಇಜಿಪ್ತಾತ್ನಾ ಬಲ್ವುನ್ ಹಾನ್ಲ್ಯಾನ್ ಅನಿ ತೆನಿ ಇಜಿಪ್ತಾತ್, ತಾಂಬ್ಡ್ಯಾ ಸಮುಂದರಾತ್, ಅನಿ ಚಾಳಿಸ್ ವರ್ಸಾ ಪತರ್ ಡಂಗ್ಳಿತ್ಬಿ ಅಜಾಬಾಚಿ ಅನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮಾ ಕರುಂಗೆತ್ ಲೊಕಾಕ್ನಿ ಫಿಡೆ ಚಾಲ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ಅನಿ ಮೊಯ್ಜೆನ್ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ದೆವ್ ತುಮ್ಕಾ ಎಕ್ ಪ್ರವಾದಿ ದಿತಲೊ ಹಾಯ್ ತೊ ಪ್ರವಾದಿ ತುಮ್ಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಲೊಕಾಂತ್ನಾಚ್ ಯೆತಾ, ತೊ ಮಾಜ್ಯಾ ನಮನಿಚ್ ರ್‍ಹಾತಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ಮೊಯ್ಜೆ ಡಂಗ್ಳಿತ್ ಇಸ್ರಾಯೆಲ್ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ, ಪುರ್ವಜಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲಲ್ಯಾ ದೆವ್ ದುತಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ, ಅನಿ ತೆನಿ ದೆವಾಚಿ ಜಿವ್ ಹೊತ್ತಿ ಗೊಸ್ಟಿಯಾ ಅಮ್ಕಾ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ಖರೆ ಮೊಯ್ಜೆಚ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಮಾನುಕ್ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಮನ್ ನತ್ತೊ, ತೆನಿ ತೆಕಾ ಸೊಡುನ್ ಇಜಿಪ್ತಾಕ್ ಪರ್ತುನ್ ಪಳುನ್ ಜಾವ್ಚೆ ಮನುನ್ ಚಿಂತಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ತೆನಿ ಆರೊನಾಕ್, ಮೊಯ್ಜೆನ್ ಅಮ್ಕಾ ಇಜಿಪ್ತ್ ದೆಶಾಕ್ನಾ ಬಲ್ವುನ್ ಹಾನ್ಲ್ಯಾನ್, ಖರೆ ತೆಕಾ ಕಾಯ್ ಹೊಲೆ ಮನುನ್ ಅಮ್ಕಾ ಗೊತ್ತ್ ನಾ, ತಸೆ ಹೊವ್ನ್ ಅಮ್ಚ್ಯಾ ಫಿಡೆ ಜಾವ್ಕ್, ಅನಿ ಅಮ್ಕಾ ಚಾಲ್ವುಕ್ ಥೊಡಿ ದೆವಾ ಕರುನ್ ದಿ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ತಸೆ ಹೊವ್ನ್ ತ್ಯಾ ಲೊಕಾನಿ ವಾಂಸ್ರಾ ಸಾರ್ಕೆ ಎಕ್ ಮುರ್ತಿ ಕರುನ್ ತೆಕಾ ಬಲಿ ಭೆಟ್ವುಲ್ಯಾನಿ, ತ್ಯಾ ಲೊಕಾನಿ ಅಪ್ಲ್ಯಾ ಹಾತಿನ್ ಕರುನ್ ಘೆಟಲ್ಲ್ಯಾ ಮುರ್ತಿಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಲೈ ಕುಶಿನ್ ಸನ್ ಕರ್‍ಲ್ಯಾನಿ ! ");
INSERT INTO kans_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ಖರೆ ದೆವಾನ್ ತೆಂಕಾ ವಿರೊಧ್ ಹೊವ್ನ್ ಮಳ್ಬಾತ್ಲೊ ದಿಸ್, ಚಂದ್ರಾಮ್ ಅನಿ ಚುಕ್ಕಿಯಾಕ್ನಿ ಫುಜ್ಯಾ ಕರುಕ್ ಸೊಡುನ್ ದಿಲ್ಯಾನ್, ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಪ್ರವಾದ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾತ್ ಅಶೆ ಲಿವಲ್ಲೆ ಹಾಯ್: ದೆವ್ ಅಸೊ ಮನ್ತಾ, ತುಮಿ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾನಿ, ಭಜನ್ ಕರುಚೆ ಮನುನ್ ಚಾಳಿಸ್ ವರ್ಸಾ ಡಂಗ್ಳಿತ್ ರಾತಾನಾ ಮಾಕಾ ಜನಾವರಾಂಚಿ ಬಲಿ ಭೆಟ್ವುಲ್ಯಾಸಿ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ಅನಿ ತುಮಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಮೊಲೊಕ್ ಮನ್ತಲ್ಯಾ ದೆವಾಚೆ ಬಿಡಾರ್, ಅನಿ ತುಮ್ಚ್ಯಾ ರೆಫಾ ಮನ್ತಲ್ಯಾ ದೆವತೆಚೊ ಚುಕ್ಕಿಚೊ ರುಪ್ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾಸಿ, ಫುಜ್ಯಾ ಕರುಕ್ ಮನುನ್ ತುಮಿ ಕರುನ್ ಘೆಟಲ್ಲಿ ಮುರ್ತಿಯಾ ಹಿಚ್ ತಸೆ ಹೊವ್ನ್ ಮಿಯಾ ತುಮ್ಕಾ ಬಾಬಿಲೊನಾಚ್ಯಾ ತಿಕ್ಡಿನ್ ಧಾಡುನ್ ದಿತಾ. ");
INSERT INTO kans_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ದೆವ್ ಹಾಜಿರ್ ರ್‍ಹಾತಲೆ ಬಿರಾಡಾರುಚ್ ಅಮ್ಚ್ಯಾ ಪುರ್ವಜ್ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಡಂಗ್ಳಿತ್ ಹೊತ್ತೆ, ಹೆ ಬಿಡಾರ್ ತಯಾರ್ ಕರ್‍ತಲೆ ಕಶೆ ಮನುನ್ ದೆವಾನ್ ಮೊಯ್ಜೆಕ್ ಸಾಂಗಲ್ಯಾನ್, ದೆವಾನ್ ಅಪ್ನಾಕ್ ದಾಕ್ವಲ್ಯಾ ಸಾರ್ಕೆಚ್ ತಯಾರ್ ಕರುಕ್ ಮೊಯ್ಜೆಕ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ತೆ ಬಿಡಾರ್ ಅಮ್ಚ್ಯಾ ಪುರ್ವಜ್ಯಾಕ್ನಿ ತೆಂಚ್ಯಾ ಬಾಬಾಂಚ್ಯಾಕ್ನಾ ಗಾವ್ಲೆ ಅನಿ ತೆನಿ ಜೊಶ್ವಾಚ್ಯಾ ಫುಡಾರ್ಕಿತ್ ಹ್ಯಾ ದೆಶಾಕ್ ಹಾನ್ಲ್ಯಾನಿ,ತ್ಯಾ ಯೆಳಾತ್ ಹ್ಯೊ ದೆಶ್ ಅನ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಹಾತಿತ್ ಹೊತ್ತೊ, ಖರೆ ದೆವಾನ್ ತೆಂಕಾ ಅಮ್ಚ್ಯಾ ಪುರ್ವಜಾಂಚ್ಯಾ ಇದ್ರಾಕುಚ್ ಭಾಯ್ರ್ ಘಾಟ್ಲ್ಯಾನ್ ಅನಿ ದಾವಿದಾಚ್ಯಾ ಯೆಳ್ ಪತರ್ಬಿ ಹೆ ಬಿಡಾರ್ ಥೈಚ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ದಾವಿದಾಚ್ಯಾ ವರ್‍ತಿ ದೆವಾಚಿ ಕುರ್ಪಾ ಹೊತ್ತಿ, “ಮಿಯಾ ಜಾಕೊಬಾಚ್ಯಾ ದೆವಾಕ್ ವಸ್ತಿ ಕರುಕ್ ಮಾಗ್ನಿ ಕರ್‍ತಲೊ ಜಾಗೊ ಬಾಂದುಕ್ ಮಾಕಾ ಅವ್ಕಾಸ್ ಕರುನ್ ದಿ ಮನುನ್ ದಾವಿದಾನ್ ದೆವಾಕ್ಡೆ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ಖರೆ ದಾವಿದಾಚೊ ಲೆಕ್ ಸೊಲೊಮೊನಾನುಚ್ ದೆವಾ ಸಾಟ್ನಿ ವಸ್ತಿ ಕರ್‍ತಲೊ ಜಾಗೊ ಭಾಂದ್ಲ್ಯಾನ್”. ");
INSERT INTO kans_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ಖರೆ ಪ್ರವಾದಿನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸಾರ್ಕೆ ಸಗ್ಳ್ಯಾತ್ ಮೊಟೊ ದೆವ್ ಮಾನ್ಸಾನಿ ಅಪ್ಲ್ಯಾ ಹಾತಿನ್ ಬಾಂದಲ್ಯಾ ಘರಾತ್ನಿ ವಸ್ತಿ ರ್‍ಹಾಯ್ನಾ, ಮನುನ್ ಲಿವಲ್ಲೆ ಹಾಯ್: ");
INSERT INTO kans_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ಸರ್ಗ್‍ ಮಾಜೊ ಸಿವಾಸನ್, ಅನಿ ಜಿಮಿನ್ ಮಾಜೆ ಪಾಯ್ ಥವ್ತಲಿ ಮ್ಹನಿ ತುಮಿ ಮಾಜ್ಯಾ ಸಾಟ್ನಿ ಕಸ್ಲೆ ಘರ್ ಬಾಂದುಕ್ ಹೊತಾ? ಮಿಯಾ ಆರಾಮ್ ಕರ್‍ತಲೊ ಜಾಗೊ ಖೈ ಹಾಯ್? ");
INSERT INTO kans_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ಹೆ ಸಗ್ಳ್ಯೆ ಮಿಯಾಚ್ ರಚಲ್ಲೆ ನ್ಹಯ್ ಕಾಯ್! ");
INSERT INTO kans_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ಸ್ತೆಪನಾನ್ ಅನಿಬಿ ಬೊಲುನ್, “ಮಂಡ್ ಮನಾಚ್ಯಾ ಲೊಕಾನು ತುಮಿ ತುಮ್ಚಿ ಮಾನಾ ದೆವಾಕ್ ದಿವ್ಕ್ ನ್ಯಾಸಿ, ಅನಿ ತೆಚ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಕಾನ್ ದಿವ್ಕ್ ನ್ಯಾಸಿ, ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಕ್ ಕನ್ನಾಬಿ ವಿರೊಧ್ ಹೊವ್ನ್ ಹಾಸಿ ತುಮ್ಚ್ಯಾ ಪುರ್ವಜ್ ಲೊಕಾನಿ ಬಿ ಅಸೆಚ್ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ತುಮಿ ಬಿ ತೆಂಚ್ಯಾ ಸಾರ್ಕೆಚ್ ಹಾಸಿ! ");
INSERT INTO kans_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ತುಮ್ಚ್ಯಾ ಪುರ್ವಜಾನಿ ತರಾಸ್ ದಿಸ್ತಾನಾ ಸೊಡಲೊ ಪ್ರವಾದಿ ಕೊನ್ ಹಾಯ್? ಅನಿ ತೆನಿ ತ್ಯಾ ನಿತಿವಂತಾಚ್ಯಾ ಯೆನ್ಯಾಚ್ಯಾ ಅದ್ದಿಚ್ ಬರಿ ಖಬರ್ ಸಾಂಗಲ್ಲ್ಯಾಕ್ನಿ ಜಿವ್ ಕಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ತುಮಿ ಸರ್ಗಾತ್ಲ್ಯಾ ದೆವ್ ದುತಾಂಚ್ಯಾಕ್ನಾ ಖಾಯ್ದ್ಯಾಂಚೆ ಪುಸ್ತಕ್ ಘೆಟ್ಲ್ಯಾಶಿ ಖರೆ ತೆಕಾ ಮಾನುಕ್ನ್ಯಾಸಿ!”. ");
INSERT INTO kans_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ಸ್ತೆಪನಾಚಿ ಬೊಲ್ನಿ ಆಯ್ಕುನ್ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾಕ್ನಿ ರಾಗ್ ಯೆವ್ನ್ ತೆನಿ ದಾತ್ ಹೊಟ್ ಚಾವ್ನ್ ಘೆವ್ಕ್ ಲಾಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ಖರೆ ಸ್ತೆಪೆನ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರಲ್ಲೊ ಹೊತ್ತೊ, ತೆನೆ ಮಳ್ಬಾಕ್ಡೆ ಡೊಳೆ ಉಕ್ಲುನ್ ದೆವಾಚಿ ಮಹಿಮಾ ಅನಿ ಜೆಜು ದೆವಾಚ್ಯಾ ಉಜ್ಜ್ಯಾ ಬಾಜುನ್ ಇಬೆ ಹೊತ್ತೆ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ಅನಿ “ಹೆಬಕ್, ಸರ್ಗ್‍ ಉಗಡಲ್ಲೆ ಅನಿ ಮಾನ್ಸಾಚೊ ಲೆಕ್ ದೆವಾಚ್ಯಾ ಉಜ್ಜ್ಯಾ ಬಾಜುಕ್ ಇಬ್ಬೆ ಹೊತ್ತ್ಯೆ ಮಿಯಾ ಬಗುಲ್ಲಾ!” ಮನುನ್ ಸಾಂಗಲಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ತನ್ನಾ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾನಿ ಸಗ್ಳ್ಯಾನಿ ಮೊಟ್ಯಾನ್ ಬೊಬ್ ಮಾರುನ್ ಅಪ್ಲಿ ಕಾನಾ ಹಾತಾನಿ ಧಾಪುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ತೆನಿ ಸಗ್ಳ್ಯೆ ಗೊಳಾ ಹೊವ್ನ್ ಸ್ತೆಪೆನಾಚ್ಯಾ ಆಂಗಾರ್ ಚಡುನ್ ಯೆವ್ನ್, ");
INSERT INTO kans_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ತೆಕಾ ಶಾರಾತ್ನಾ ಭಾಯ್ರ್ ವಡುನ್ ನೆವ್ನ್, ತೊ ಮರಿ ಪತರ್ ಬಿ ತೆಚ್ಯಾ ವೈರ್ ಗುಂಡೆ ಟಾಕ್ಲ್ಯಾನಿ ಸ್ತೆಪನಾಕ್ ವಿರೊಧ್ ಹೊವ್ನ್ ಸಾಕ್ಷಿ ಸಾಂಗಲ್ಲ್ಯಾ ಲೊಕಾನಿ, ಅಪ್ಲಿ ವೈಲಿ ಅಂಗಿಯಾ ಕಾಡುನ್ ಸಾವ್ಲು ಮನ್ತಲ್ಯಾ ದಾಂಡ್ಗ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಪಾಂಯಾತ್ನಿ ಥವ್ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ಸ್ತೆಪನಾಕ್ ಗುಂಡೆ ಟಾಕ್ಲ್ಯಾನಿ ಖರೆ ಸ್ತೆಪನಾನ್ ಮಾಗ್ನಿ ಕರುನ್ಗೆತ್, “ಧನಿಯಾ ಜೆಜು, ಮಾಜೊ ಆತ್ಮೊ ತುಜ್ಯಾಕ್ಡೆ ಘೆ!” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ತೆನಿ ಡಿಂಬಿಯಾರ್ನಿ ಇಬೆ ರ್‍ಹಾವ್ನ್, “ಧನಿಯಾ, ಹ್ಯೊ ಪಾಪ್ ಹೆಂಚ್ಯಾ ವೈರ್ ಘಾಲು ನಕ್ಕೊ!” ಮನುನ್ ಮೊಟ್ಯಾ ಧನಾನ್ ಸಾಂಗುನ್ಗೆತ್ ಜಿಂವ್ ಸೊಡ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ಸಾವ್ಲುಕ್ ಸ್ತೆಪನಾಚೊ ಜಿವ್ ಕಾಡಲೆ ಒಪ್ಕಿ ಹೊಲ್ಲೆ, ತ್ಯಾ ದಿಸಾಕ್ನಾಚ್ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ವಿರೊದ್ ಹೊವ್ನ್ ತರಾಸ್ ಸುರು ಹೊಲೊ, ಅನಿ ತೆನಿ ಸಗ್ಳ್ಯಾನಿ ಅಪೊಸ್ತಲಾಕ್ನಿ ಸೊಡುನ್ ಸಾಮಾರ್ಯಾಚ್ಯಾ ಗಾಂವಾಕ್ನಿ ಪಗ್ಳುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ತನ್ನಾ ಥೊಡ್ಯಾ ಲೊಕಾನಿ ಸ್ತೆಪನಾಕ್ ನ್ಹೆವ್ನ್ ಸಮಾಧಿ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ತೆನಿ ಸ್ತೆಪನಾ ಸಾಟ್ನಿ ಲೈ ರಡುನ್ ಅಳಾಪ್ ಕರ್‍ಲ್ಯಾನಿ, ");
INSERT INTO kans_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ಖರೆ ಸಾವ್ಲಾನ್ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚೆ ತಾಂಡೆ ಹಾಳ್ ಕರುಕ್ ಚಾಲುಕರ್ಲ್ಯಾನ್, ಹರ್ ಎಕ್ ಘರಾತ್ನಿಬಿ ಗುಸುನ್ ಘವ್ ಮಾನ್ಸಾಕ್ನಿ, ಅನಿ ಬಾಯ್ಕಾ ಮಾನ್ಸಾಕ್ನಿ ಸಗ್ಳ್ಯಾಕ್ನಿಬಿ ಭಾಯ್ರ್ ವಡುನ್ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ದೆವಾಚಿ ವಿಶ್ವಾಸಿ ಲೊಕಾ ಲೈ ಕಡೆ ಪಗಳ್ಲಿ, ಅನಿ ತೆನಿ ಗೆಲ್ಯಾಕ್ಡೆ ಸಗ್ಳ್ಯಾಕ್ಡೆಬಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಲೊಕಾಕ್ನಿ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ಫಿಲಿಪಾನ್ ಸಮಾರ್ಯ್ ಮನ್ತಲ್ಯಾ ಮುಖ್ಯ್ ಗಾಂವಾಕ್ ಜಾವ್ನ್ ಕ್ರಿಸ್ತಾಚ್ಯಾ ವಿಶಯಾತ್ ಪರ್ಗಟ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ಫಿಲಿಪ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೆ ಥೈತ್ಲ್ಯಾ ಲೊಕಾನಿ ಆಯ್ಕಲ್ಯಾನಿ, ಅನಿ ತಸೆಚ್ ತೊ ಕರುಲಾಗಲಿ ಅಜಾಪಾಚಿ ಕಾಮಾಬಿ ಬಗ್ಲ್ಯಾನಿ, ತೆನಿ ಸಾಂಗಲಿ ಸಂಗ್ತಿಯಾ ಸಗ್ಳ್ಯಿ ಎಕ್ ಮನಾನ್ ಧ್ಯಾನ್ ದಿವ್ನ್ ಆಯ್ಕ್ ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ಥೈತ್ಲ್ಯಾ ಲೈ ಲೊಕಾಕ್ನಿ ಧರಲೊ ಮಾರು ತೆಂಕಾ ಸೊಡುನ್ ಜಾತಾನಾ ಮೊಟ್ಯಾನ್ ಅವಾಜ್ ಕರುಂಗೆತ್ ಗೆಲೊ ಅನಿ ಲೈ ಸೊಟ್ಯಾಕ್ನಿ ಅನಿ ವಾರೆ ಮಾರಲ್ಯಾಕ್ನಿ ಗುನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ತಸೆ ಹೊವ್ನ್ ತ್ಯಾ ಶಾರಾತ್ಲಿ ಲೊಕಾ ಲೈ ಕುಶಿ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ಖರೆ ತ್ಯಾ ಶಾರಾತ್ ಸಿಮಾವ್ ಮನ್ತಲೊ ಎಕ್ಲೊ ಹೊತ್ತೊ, ತೊ ಅಪ್ಲ್ಯಾ ಮೊಡಿ ಮಂತ್ರಾನಿ ಥೈತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಕಂಗಾಲ್ ಕರುನ್ ಥವಲ್ಲ್ಯಾನ್, ತೊ ಅಪ್ನಾಕುಚ್ ಅಪ್ನಿ ಮೊಟೊ ಮಾನುಸ್ ಮನುನ್ ಘೆವ್ನ್ ಬಡಾಯ್ ಕರಿತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ಮಟ್ಲ್ಯಾರ್ ಬಾರಿಕ್ಲ್ಯಾಂಚ್ಯಾಕ್ನಾ ಮೊಟ್ಯಾಂಚ್ಯಾ ಪತರ್ ಸಗ್ಳೆಬಿ ತೆಕಾ ಲೈ ಬಳ್ ಹಾಯ್ ಮನುನ್ ಸಾಂಗಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ತೆನಿ ಅಪ್ಲ್ಯಾ ಮೊಡಿ ಮಂತ್ರಾತ್ನಿ ಲೈ ಯೆಳಾಸ್ನಾ ಲೊಕಾಕ್ನಿ ವಿಸ್ಮಿತ್ ಕರುನ್ ಥವಲ್ಯಾ ಸಾಟ್ನಿ ಸಗ್ಳಿ ಲೊಕಾ ತೆಚಿ ಗೊಸ್ಟಿಯಾ ಮಾನಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ಖರೆ ಫಿಲಿಪ್ಪಾನ್ ದೆವಾಚ್ಯಾ ರಾಜಾಚ್ಯಾ ವಿಶಯಾತ್ ಅನಿ ಜೆಜು ಕ್ರಿಸ್ತಾಚ್ಯಾ ತಾಕ್ತಿಚ್ಯಾ ವಿಶಯಾತ್ ಲೊಕಾಕ್ನಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನ್ ಘೊಮ್ಸಾನಿ , ಅನಿ ಬಾಯ್ಕೊ ಮಾನ್ಸಾನಿ ಪಿಲಿಪಾನ್ ಸಾಂಗಲ್ಯಾಕ್ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ಸ್ವತಾ ಸಿಮಾಂವಾನ್ಬಿ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ಬಾಲ್ತಿಮ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ಸಿಮಾವ್ ಪಿಲಿಪಾಚ್ಯಾ ಜಗ್ಗೊಳುಚ್ ರ್‍ಹಾಯ್, ಫಿಲಿಪಾನ್ ಕರಲಿ ಆಜಾಪಾಚಿ ಕಾಮಾ ಬಗುನ್ ಸಿಮಾವ್ ಲೈ ವಿಸ್ಮಿತ್ ಹೊಯ್. ");
INSERT INTO kans_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ಅಪೊಸ್ತಲಾ ಅಜುನ್ ಜೆರುಜಲೆಮಾತ್ ರಾತಾನಾ ಸರ್ಮಾಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ಲ್ಯಾ ಲೊಕಾನಿ ದೆವಾಚಿ ಗೊಸ್ಟಿಯಾ ಸ್ವಿಕಾರ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನಿ ಮನ್ತಲೆ ಆಯ್ಕಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಪೆದ್ರುಕ್, ಅನಿ ಜುವಾಂವಾಕ್ ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ತೆನಿ ದೊಗೆಬಿ ಸಮಾರ್ಯಾಕ್ ಯೆವ್ನ್ ಥೈತ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ಗಾಂವ್ದಿ ಮನುನ್ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ಹ್ಯಾ ಲೊಕಾನಿ ಧನಿಯಾ ಜೆಜುಚ್ಯಾ ನಾವಾನ್ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆಟಲ್ಯಾನಿ, ಖರೆ ತಾಂಚ್ಯಾತ್ಲ್ಯಾ ಕೊನಾಚ್ಯಾ ವೈರಬಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ಯೆವ್ಕ್ ನಸಲ್ಲೊ ತಸೆ ಹೊವ್ನ್, ");
INSERT INTO kans_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ಪೆದ್ರುನ್ ಅನಿ ಜುವಾಂವಾಕ್ ತೆಂಚ್ಯಾರ್ ಅಪ್ಲಿ ಹಾತಾ ಥವ್ಲ್ಯಾನಿ ತನ್ನಾ ತೆಂಕಾ ಪವಿತ್ರ್ ಆತ್ಮೊ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ಪೆದ್ರುನ್ ಅನಿ ಜುವಾಂವಾನ್ ಹಾತಾ ಥವಲ್ಲ್ಯಾ ತನ್ನಾ ಲೊಕಾಕ್ನಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ಗಾವ್ಕ್ಲಾಗಲೆ ಸಿಮಾವಾನ್ ಬಗ್ಲ್ಯಾನ್, ತಸೆ ಹೊವ್ನ್ ತೆನಿ ಅಪೊಸ್ತಲಾಕ್ನಿ ಪೈಸೆ ದಿಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ಅನಿ ಮಿಯಾ ಕೊನಾಚ್ಯಾ ವರ್‍ತಿ ಮಾಜೊ ಹಾತ್ ಥವ್ತಾ ತೆಂಕಾ ಪವಿತ್ರ್ ಆತ್ಮೊ ಗಾಯ್ ಸಾರ್ಕೆ ಹೊತಲಿ ಬಳ್ ಮಾಕಾಬಿ ದಿವಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ತನ್ನಾ ಪೆದ್ರು ಸಿಮೊನಾಕ್, “ತಿಯಾ ನಾಸ್ ಹೊ! ಅನಿ ತುಜೆ ಪೈಸೆಬಿ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ನಾಸ್ ಹೊಂವ್ದಿತ್!” ದೆವಾಚಿ ವರಾ ಪೈಸೆ ದಿವ್ನ್ ಘೆವ್ಕ್ ಹೊತಾ ಮನುನ್ ತಿಯಾ ಚಿಂತ್ಲೈ. ");
INSERT INTO kans_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ದೆವಾಚ್ಯಾ ಕಾಮಾತ್ನಿ ತಿಯಾ ಅಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ವಾಟೊ ಅನಿ ಭಾಗ್ ಘೆವ್ಕ್ ಹೊಯ್ನಾ, ತುಜೊ ಮನ್ ದೆವಾಚ್ಯಾ ಫಿಡೆ ಸಮಾನಾ. ");
INSERT INTO kans_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ತಸೆ ಹೊವ್ನ್ ತುಜೊ ಮನ್ ಬದ್ಲುನ್ ಘೆ! ತಿಯಾ ಕರಲಿ ಬುರ್ಶಿ ಕಾಮಾ ಸೊಡುನ್ ದೆವಾಕ್ಡೆ ಪರತ್, ಧನಿಯಾಕ್ಡೆ ಮಾಗ್ನಿ ಕರ ತಿಯಾ ಅಸ್ಲಿ ಯವ್ಜನ್ ಕರಲ್ಯಾಕ್ ತೊ ತುಕಾ ಮಾಪಿ ಕರ್ಲ್ಯಾರ್ ಬಿ ಕರ್‍ತಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ತಿಯಾ ಲೈ ಕೊಡುಪಾನಾನ್ ಭರಲ್ಲೆ, ಅನಿ ಪಾಪಾಕ್ ಗುಲಾಮ್ ಹೊವ್ನ್ ಹೊತ್ತೆ ಮಿಯಾ ಬಗಟ್ಲಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ತನ್ನಾ ಸಿಮಾವಾನ್ ಮಾಜ್ಯಾ ಸಾಟ್ನಿ ತುಮಿ ದೊಗೆಬಿ ಧನಿಯಾಕ್ಡೆ ತುಮಿ ಸಾಂಗಲ್ಲ್ಯಾ ಸಂಗ್ತಿಯಾತ್ನಿ ಎಕ್ಬಿ ಮಾಕಾ ಹೊವ್ಕ್ ನ್ಹಯ್ ಸಾರ್ಕೆ ಮಾಗ್ನಿ ಕರಾ! ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ತೆಚ್ಯಾ ಮಾನಾ ಪೆದ್ರು ಅನಿ ಜುವಾಂವಾಕ್ ಅಪ್ನಿ ಆಯ್ಕಲ್ಲಿ ಜೆಜುಚಿ ಖಬರ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಕಳ್ವುಲ್ಯಾನಿ, ತೆನಿ ಲೊಕಾಕ್ನಿ ಧನಿಯಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುನ್, ಮಾನಾ ಜೆರುಜಲೆಮಾಕ್ ಜಾತಾನಾ ವಾಟೆರ್ ಸಮಾರ್ಯಾತ್ಲಾ ಲೈ ಗಾಂವಾಕ್ನಿ ಜಾವ್ಕ್ ಲೊಕಾಕ್ನಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ಧನಿಯಾಚ್ಯಾ ದೆವ್ ದುತಾನ್ ಫಿಲಿಪಾಕ್, ತಿಯಾ ಉಟುನ್ ತಯಾರ್ ಹೊವ್ನ್ ದಕ್ಷಿನಾಚ್ಯಾ ಭಾಜುಕ್ ಮಟ್ಲ್ಯಾರ್, ಜೆರುಜಲೆಮಾಕ್ನಾ ಗಾಜ್ಯಾಕ್ ಜಾತಲ್ಯಾ ಡಂಗ್ಳಿಚ್ಯಾ ವಾಟೆಕ್ಡೆ ಜಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ತಸೆ ಹೊವ್ನ್ ಫಿಲಿಪ್ ತಯಾರ್ ಹೊವ್ನ್ ಜಾವ್ಲಾಲೊ, ತನ್ನಾ ಇಥಿಯೊಫಿಯಾತ್ಲೊ, ಎಕ್ ಮಾನುಸ್ ತೆಕಾ ವಾಟೆರ್ ದಿಸ್ಲೊ, ಹೊ ಮಾನುಸ್ ಹಿಜ್ಡಾ ಹೊಲ್ಲೊ, ಇಥಿಯೊಫಿಯಾಚ್ಯಾ ರಾನಿಚ್ಯಾ ಆಸ್ಥಾನಾತ್ ಹ್ಯೊ ಮೊಟೊ ಅಧಿಕಾರಿ ಹೊವ್ನ್ ಹೊತ್ತೊ ಪೈಸೆ ಸಗ್ಳ್ಯೆ ಬಗುನ್ ಘೆತಲಿ ಜವಾಬ್ದಾರಿ ತೆಕಾಚ್ ಹೊತ್ತಿ, ತೊ ದೆವಾಚಿ ಸ್ತುತಿ ಕರುಕ್ ಸಾಟ್ನಿ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ತೊ ಅಪ್ಲ್ಯಾ ರಥಾತ್ ಬಸುನ್ ಯೆಶಾಯಾಚೆ ಪುಸ್ತಕ್ ವಾಚುನ್ಗೆತ್ ಅಪ್ಲ್ಯಾ ಘರಾಕ್ಡೆ ಪರ್ತುನ್ ಜಾವ್‍ಲಾಗಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಫಿಲಿಪಾಕ್ “ರಥಾಕ್ಡೆ ಜಾವ್ನ್ ತೆಚ್ಯಾ ಜಗ್ಗೊಳ್ ರಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ಸಾಂಗಲ್ಲ್ಯಾ ಸಾರ್ಕೆಚ್ ಫಿಲಿಪ್ ರಥಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಗೆಲೊ, ತೊ ಮಾನುಸ್ ವಾಚುಲಾಗಲೆ ಯೆಶಾಯಾಚೆ ಪ್ರವಾದನ್ ಪುಸ್ತಕ್ ಫಿಲಿಪಾಕ್‍ಬಿ ಆಯ್ಕಲೆ, ತನ್ನಾ ಫಿಲಿಪಾನ್ ತೆಕಾ ತಿಯಾ ವಾಚುಲಾಗಲೆ ತುಕಾ ಅರ್ತ್‍ ಹೊವ್ಲಾ ಕಾಯ್? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ತನ್ನಾ ತ್ಯಾ ಅಧಿಕಾರಿನ್ ಮಿಯಾ ಕಶೆ ಅರ್ಥ್ ಕರುನ್ ಘೆವ್ಕ್ ಹೊತಾ? ಕೊನ್ ತರಿಬಿ ದುಸ್ರ್ಯಾನಿ ಹೆ ಮಾಕಾ ಕಳ್ವುಚೆ! ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್, ಅನಿ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ರಥಾತ್ ಚಡುನ್ ಬಸ್ ಮನುನ್ ಫಿಲಿಪಾಕ್ ಬಲ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ತೊ ವಾಚುಲಾಗಲ್ಯಾ ಪವಿತ್ರ್ ಪುಸ್ತಕಾಚೊ ಭಾಗ್ ಖಲೊ ಮಟ್ಲ್ಯಾರ್: ತೊಡ್ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ನ್ಹೆಲ್ಲ್ಯಾ ಬಕ್ರ್ಯಾ ಸಾರ್ಕೊ ತೊ ಹೊತ್ತೊ, ಅಪ್ಲಿ ಕೆಸಾ ಕಾಪುಲಾಗಲ್ಯಾಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಗಪ್ ಇಬೆ ಹೊತ್ತ್ಯಾ ಬಕ್ರ್ಯಾ ಸಾರ್ಕೊ ತೊ ಹೊತ್ತೊ, ತೆನಿ ಎಕ್ ಶಬ್ದ್ ಸೈತ್ ಬೊಲುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ತೆನಿ ಮಾನುನ್ ಘೆಟಲ್ಯಾ ಸಾಟ್ನಿ ತೆಕಾ ನ್ಯಾಯ್ ಗಾವ್ಕನಾ ತೆಚ್ಯಾ ಪುರ್ವಜಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗುಕ್ ಕೊನಾಕ್ಬಿ ಬಳ್ ನಾ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜಿಮ್ನಿ ವೈನಾ ತೆಜೊ ಜಿವನ್ ಸರುನ್ಗೆತ್ ಯೆಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ತೆನಿ ಫಿಲಿಪಾಕ್, “ದಯಾ ಕರುನ್ ಮಾಕಾ ಸಾಂಗ್ ಹಿತ್ತೆ ಖಚ್ಚ್ಯಾ ಪ್ರವಾದ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗುಲಾಗಲೆ ಹಾಯ್? ತೊ ಅಪ್ನಾಚ್ಯಾಚ್ ವಿಶಯಾತ್ ಸಾಂಗುಲ್ಲಾ ಕಾಯ್?” ಮಾಕಾ ಸಾಂಗ್ ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ಫಿಲಿಪಾನ್ ಪವಿತ್ರ್ ಪುಸ್ತಕಾಚ್ಯಾ ಹ್ಯಾ ಭಾಗಾಕ್ನಾಚ್ ಶುರು ಕರುನ್ ಜೆಜುಚ್ಯಾ ವಿಶಯಾಚಿ ಖಬರ್ ತೆಕಾ ಕಳ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ಜಾಂವ್ಗೆತ್ - ಜಾಂವ್ಗೆತ್, ಅನಿ ಪಾನಿ ಹೊತ್ತ್ಯಾ ಎಕ್ ಜಾಗ್ಯಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಪಾವ್ಲೆ, ತನ್ನಾ ತೊ ಅಧಿಕಾರಿ “ಹೆಬಕ್! ಹಿತ್ತೆ ಪಾನಿ ಹಾಯ್! ಮಿಯಾ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆವ್ಕ್ ಕಾಯ್‍ತರಿಬಿ ಅಡ್ಕಳ್ ಹಾಯ್ ಕಾಯ್?” ಮನುನ್ ಪಿಲಿಪಾಕ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ತನ್ನಾ ಪಿಲಿಪಾನ್ ಅಧಿಕಾರಿಕ್ “ ತಿಯಾ ಫುರಾ ಮನಾನ್ ವಿಶ್ವಾಸ್ ಕರ್‍ತಲೊ ಹೊಲ್ಯಾರ್ ಬಾಲ್ತಿಮ್ ಘೆವ್ಕ್ ಹೊತಾ” ಮಟ್ಲ್ಯಾನ್, ತನ್ನಾ ಅದಿಕಾರಿನ್ “ಜೆಜು ಕ್ರಿಸ್ತ್ ದೆವಾಚೊ ಲೆಕ್ ಮನುನ್ ಮಿಯಾ ವಿಶ್ವಾಸ್ ಕರ್‍ತಾ” ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ಮಾನಾ ತೆನಿ ರಥ್ ಇಬೆ ಕರಾ ಮನುನ್ ಹುಕುಮ್ ಕರ್‍ಲ್ಯಾನ್, ತೆನಿ ದೊಗೆಬಿ ಪಾನಿಯಾತ್ ಉತ್ರುನ್ ಮಾನಾ ಫಿಲಿಪಾನ್ ತೆಕಾ ಬಾಲ್ತಿಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ತೆನಿ ಪಾನಿಯಾತ್ನಾ ವೈರ್ ಯೆಲ್ಲ್ಯಾತನ್ನಾ, ಧನಿಯಾಚ್ಯಾ ಆತ್ಮ್ಯಾನ್ ಫಿಲಿಪಾಕ್ ಉಕ್ಲುನ್ ನ್ಹೆಲ್ಯಾನ್, ಅನಿ ಕನ್ನಾಬಿ ಫಿಲಿಪ್ ತ್ಯಾ ಮಾನ್ಸಾಕ್ ದಿಸುಕ್ ನಾ, ತೊ ಲೈ ಕುಶಿ ಹೊವ್ನ್ ಅಪ್ನಿ ಜಾವ್‍ಲಾಗಲ್ಯಾ ವಾಟೆನ್ ಫಿಡೆ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ಖರೆ ಫಿಲಿಪಾನ್ ಅಜೊತ್ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ದಾಕ್ವುನ್ ಘೆವ್ನ್ ಸೆಜರೆಯ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಜಾತಾನಾ ವಾಟೆರ್ ಗಾವಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಗಾಂವಾತ್ನಿ ಬಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ಸಾವ್ಲು ಅನಿ ಬಿ ಧನಿಯಾಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಭಿಂವ್ಸುಕ್, ಅನಿ ಜಿವ್ ಕಾಡುಕ್ ಬಗಿತ್ ಹೊತ್ತೊ, ತಸೆ ಹೊವ್ನ್ ತೊ ಮೊಟ್ಯಾಯಾಜಕಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಜಾವ್ನ್, ");
INSERT INTO kans_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ದಮಸ್ಕಾ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಕ್ರಿಸ್ತಾಚ್ಯಾ ವಾಟೆನ್ ಚಲ್ತಲ್ಯಾ ಲೊಕಾಕ್ನಿ ವಳ್ಕುನ್ ಬಾಯ್ಕಾಮಾನ್ಸಾ, ಘವ್ಮಾನ್ಸಾ ಮನುನ್ ಬಗಿನಸ್ತಾನಾ ಧರುನ್ ತೆಂಕಾ ಬಾಂದುನ್ ಜೆರುಜಲೆಮಾಕ್ ತೆಂಕಾ ಭಂದಿ ಕರುನ್ ಹಾನುಕ್ ಅಪ್ನಾಕ್ ಅಧಿಕಾರ್ ದಿಲ್ಲೊ ಹಾಯ್, ಮನುನ್ ಧಮಸ್ಕ್ ಶಾರಾತ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ನಿ ಚಿಟ್ ಲಿವ್ಚೆ ಮನುನ್ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ತಸೊಚ್ ಸಾವ್ಲು ಧಮಸ್ಕಾಕ್ ಜಾವ್‍ಲಾಲೊ, ತೊ ಶಾರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ,ಎಗ್ದಮ್, ಲೈ ಹೊಳಾವ್ತಲೊ ಎಕ್ ಉಜ್ವೊಡ್ ಮಳ್ಬಾಕ್ನಾ ತೆಚ್ಯಾ ಅಜುಭಾಜುನ್ ಹೊಳಾವ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ತನ್ನಾ ಸಾವ್ಲು ಜಿಮ್ನಿರ್ ಪಡ್ಲೊ, “ಸಾವ್ಲ್, ಸಾವ್ಲ್! ತಿಯಾ ಮಾಕಾ ಕಶ್ಯಾಕ್ ತರಾಸ್ ದಿತೈಯ್?” ಮನ್ತಲಿ ಧನ್‍ ತೆಕಾ ಆಯ್ಕೊಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ತನ್ನಾ ಸಾವ್ಲುನ್ “ಧನಿಯಾ ತಿಯಾ ಕೊನ್‍?” ಮಟ್ಲ್ಯಾನ್, ತ್ಯಾ ಧನಾನ್ ತನ್ನಾ, “ತಿಯಾ ತರಾಸ್ ದಿವ್‍ಲಾಗಲೊ ಜೆಜು ಮಿಯಾಚ್!” ");
INSERT INTO kans_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“ಖರೆ ತಿಯಾ ಅತ್ತಾ ಉಟುನ್ ಶಾರಾತ್ ಜಾ, ತಿಯಾ ಕಾಯ್ ಕರುಚೆ ಮನ್ತಲೆ ಥೈತ್ಲೊ ಎಕ್ ಮಾನುಸ್ ತುಕಾ ಸಾಂಗ್ತಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಪ್ರಯಾನ್ ಕರುಲಾಗಲ್ಯಾ ಲೊಕಾನಿ ಥೈ ಬೊಲಿನಸಲ್ಯಾ ಮುಕ್ಕ್ಯಾಂಚ್ಯಾ ಸಾರ್ಕೆ ಇಬೆ ಹೊತ್ತೆ, ತೆಂಕಾ ಧನ್ ಎಕುಚ್ ಆಯ್ಕಲಿ ಖರೆ ತೆಂಕಾ ಕೊನ್ಬಿ ದಿಸುಕ್ನಾತ್, ");
INSERT INTO kans_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ಖಾಲ್ತಿ ಪಡಲ್ಯಾಕ್ನಾ ಸಾವ್ಲಾನ್ ಉಟುನ್ ಡೊಳೆ ಉಗಡ್ಲ್ಯಾನ್, ಖರೆ ತೆಕಾ ಕಾಯ್ಬಿ ದಿಸಿನಸಿ ತನ್ನಾ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ಹಾತಿಕ್ ಧರುನ್ ಧಮಸ್ಕಾಕ್ ನ್ಹೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ತಿನ್ ದಿಸಾ ಪತರ್ ಬಿ ಸಾವ್ಲಾಕ್ ಕಾಯ್ಬಿ ದಿಸಿನಸಿ, ಅನಿ ತೆನಿ ಜೆವಾನ್ ಪಾನಿ ಸಗ್ಳೆ ಸೊಡುನ್ ಉಪ್ಪಾಸಿ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ಅನನಿಯ್ ಮನ್ತಲೊ ಜೆಜುಚೊ ಶಿಸಾ ಎಕ್ಲೊ ಧಮಸ್ಕಾತ್ ಹೊತ್ತೊ, ಧನಿಯಾನ್ ತೆಕಾ ಸಪ್ನಾತ್ ಅನನಿಯ್! ಮನುನ್ ಬಲ್ವುಲ್ಯಾನ್, ತನ್ನಾ ತೆನಿ “ಧನಿಯಾ, ಹೆಬಕ್ ಮಿಯಾ ಹಿತ್ತೆ ಹಾಯ್” ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ತನ್ನಾ ಧನಿಯಾನ್ ಅನನಿಯಾಕ್ ತಿಯಾ ಉಟುನ್ ನಿಟ್ಲಿ ವಾಟ್ ಮನುನ್ ಬಲ್ವುತಲ್ಲ್ಯಾ ವಾಟೆಕ್ ಜಾ, ಥೈ ಹೊತ್ತ್ಯಾ ಜುದಾಸಾಚೆ ಘರ್ ಹುಡ್ಕುನ್ ಕಾಡುನ್ ತಾರ್ಸಿಸ್ ಶಾರಾತ್ಲ್ಯಾ ಸಾವ್ಲಾಚ್ಯಾ ವಿಶಯಾತ್ ಇಚಾರ್, ತೊ ಅತ್ತಾ ಥೈ ಮಾಗ್ನಿ ಕರುನ್ಗೆತ್ ಹಾಯ್, ");
INSERT INTO kans_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ಅನನಿಯಸ್ ಮನ್ತಲೊ ಎಕ್ಲೊ ತೆಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಅಪ್ಲಿ ಹಾತಾ ತೆಚ್ಯಾ ವೈರ್ ಥವಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ಪರ್ತುನ್, ಅನಿ ಡೊಳೆ ದಿಸುಕ್ ಲಾಗ್ತಾತ್ “ ಮನ್ತಲೆ ದರ್ಶನ್ ತೆಕಾ ದಿಸಲ್ಲೆ ಹಾಯ್”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ಖರೆ ಅನನಿಯಾನ್, “ಧನಿಯಾ, ಜೆರುಜಲೆಮಾತ್ ಹೊತ್ತ್ಯಾ ತುಜ್ಯಾ ಲೊಕಾಕ್ನಿ ಹ್ಯಾ ಮಾನ್ಸಾನ್ ಕರಲ್ಯಾ ಬುರ್ಶ್ಯಾ ಕಾಮಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಲೊಕಾನಿ ಸಾಂಗ್ತಲೆ ಮಿಯಾ ಆಯಿಕ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ಅತ್ತಾ ತೊ ದಮಸ್ಕಾಕ್‍ಬಿ ಯೆಲಾ, ತುಜ್ಯಾರ್ ವಿಶ್ವಾಸ್ ಥವಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಂಧಿಖಾನ್ಯಾತ್ ಘಾಲ್ತಲೊ ಅಧಿಕಾರ್ ತೆಕಾ ಮೊಟ್ಯಾ ಯಾಜಕಾಂಚ್ಯಾಕ್ನಾ ಗಾವಲ್ಲೊ ಹಾಯ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ಖರೆ ಧನಿಯಾನ್ ಅನನಿಯಾಕ್, ಜಾ! ತೆಕಾ ಮಿಯಾ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ರಾಜಾಕ್ನಿ, ಜುದೆವಾಕ್ನಿ, ಅನಿ ಹುರಲ್ಯಾ ಇಸ್ರಾಯೆಲ್ ಲೊಕಾಕ್ನಿ ಕಳ್ವುತಲ್ಯಾ ಮುಖ್ಯ್ ಕಾಮಾಚೊ ಹತಿಯಾರ್ ಕರುನ್ ಎಚುನ್ ಘೆಟಲ್ಲೆ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","“ತೆನಿ ಮಾಜ್ಯಾ ಸಾಟ್ನಿ ಸೊಸುನ್ ಘೆವ್ಚೊ ಹೊಲ್ಲೊ ತರಾಸ್ ಮಿಯಾಚ್, ತೆಕಾ ದಾಕ್ವುನ್ ದಿತಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ತಸೆ ಹೊವ್ನ್ ಅನನಿಯ್ ಜುದಾಸಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲೊ, ಅನಿ ಸಾವ್ಲುಚೆರ್ ಅಪ್ನಿ ಹಾತಾ ಥವ್ನ್ “ಸಾವ್ಲ್, ಮಾಜ್ಯಾ ಭಾವಾ, ಧನಿಯಾ ಜೆಜುನ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲಾ, ತಿಯಾ ಹಿತ್ತೆ ಯೆತಾನಾ ವಾಟೆರ್ ಬಗಟಲ್ಲೆ ತೆಕಾಚ್, ತುಕಾ ಪರ್ತುನ್ ಡೊಳೆ ಯೆಯ್ ಸಾರ್ಕೆ ಹೊವ್ಚೆ, ಅನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರುಚೊ ಮನುನ್ ಜೆಜುನ್ ಮಾಕಾ ಧಾಡುನ್ ದಿಲಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ತಾಬೊಡ್ತೊಬ್ ಖವ್ಳಾಂಚ್ಯಾ ಸಾರ್ಕೆ ಹೊತ್ತೆ ಕಾಯ್ಕಿ ಎಕ್ ಸಾವ್ಲಾಚ್ಯಾ ಡೊಳ್ಯಾಂತ್ನಾ ಖಾಲ್ತಿ ಪಡ್ಲೆ, ತೆಕಾ ಪರ್ತುನ್ ಡೊಳೆ ದಿಸುಕ್ ಲಾಗ್ಲೆ! ಸಾವ್ಲಾ ವೈರ್ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾಲೊ ಅನಿ ತೆಕಾ ಬಾಲ್ತಿಮ್‍ ದಿವ್ನ್ ಹೊಲೆ , ");
INSERT INTO kans_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ಮಾನಾ ತೆನಿ ಜೆವಾನ್ ಕರ್‍ಲ್ಯಾನ್, ತೆಚ್ಯಾ ಮಾನಾ ತೆಕಾ ಬಳ್ ಯೆಲಿ, ಅನಿ ತೊ ಜೆಜುಚ್ಯಾ ಶಿಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಥೊಡ್ಯಾ ದಿಸಾಂಚ್ಯಾ ಪತರ್ ಧರ್ಮಸ್ಕಾತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ಸಾವ್ಲಾ ಯೆಳ್ ಕರಿನಸ್ತಾನಾ ಸಿನಾಗೊ ಜಾವ್ನ್ “ಜೆಜುಚ್ ದೆವಾಚೊ ಲೆಕ್” ಮನುನ್ ಶಿಕಾಪ್ ಕರುಲಾಗಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ತೆಜೆ ಬೊಲ್ನೆ ಆಯ್ಕಲ್ಲಿ ಲೊಕಾ ಸಗ್ಳ್ಯಿ ಅಜಾಪ್ ಹೊಲಿ, ಅನಿ ಜೆರುಜಲೆಮಾತ್ ಹೊತ್ತೊ ಮಾನುಸ್ ಹ್ಯೊಚ್, ಜೆಜುಚ್ಯಾ ನಾವಾರ್ ವಿಶ್ವಾಸ್ ಥವ್ತಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಜಿವಾನಿ ಮಾರುಕ್ ಬಗಿತ್ ಹೊತ್ತೊ! ಜೆಜುಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಧರುನ್ ಮುಖ್ಯ್ ಯಾಜಕಾಂಚ್ಯಾಕ್ಡೆ ವೊಡುನ್ ನ್ಹೆವ್ಚೆ ಮನುನ್ ಯೆಲ್ಲೊ ಹ್ಯೊಚ್ ನ್ಹಯ್ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ಖರೆ ಸಾವ್ಲಾ, ಅನಿಬಿ ಲೈ ಬಳಾನಿ ಜೆಜುಚ್ ಕ್ರಿಸ್ತ್ ಮನುನ್ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೊ, ತೆಚ್ಯಾ ವೈನಾ ದಮಸ್ಕಾತ್ಲ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾಕ್ಡೆ ಕಾಯ್ಬಿ ಬೊಲುಕ್ ಹೊವ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ಲೈ ದಿಸಾ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾನಿ ಸಾವ್ಲಾಕ್ ಜಿವ್ ಕಾಡುಚೆ ಮನುನ್ ಯವ್ಜನ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ಜುದೆವಾಂಚಿ ಲೊಕಾ ಸಾವ್ಲಾಚಿ ವಾಟ್ ಬಗುನ್ ಘೆತ್ ಶಾರಾಚ್ಯಾ ದಡ್ಪ್ಯಾಕ್ನಿ ರಾತ್ ಅನಿ ದಿಸ್ ರಾಯ್ತ್ , ಖರೆ ತೆಂಚಿ ಹಿ ಯವ್ಜುನ್ ಸಾವ್ಲಾಕ್ ಗೊತ್ತ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ಎಕ್ ದಿಸ್ ರಾತ್ತಿನಿ ಶಿಸಾನಿ ಸಾವ್ಲಾಕ್ ಶಾರಾತ್ನಾ ಭಾಯ್ರ್ ಧಾಡುಕ್ ಸಾಟ್ನಿ ತೆಕಾ ಎಕ್ ಭುಟ್ಟಿತ್ ಬಸ್ವುನ್, ಶಾರಾಚ್ಯಾ ಭಿತ್ತಿತ್ನಾ ತೆಕಾ ಖಾಲ್ತಿ ಉತರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ಸಾವ್ಲ್ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲೊ, ತೆನೆ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಮಿಳುಚೆ ಮನುನ್ ಕಟ್ಪಟ್ಲ್ಯಾನ್, ಖರೆ ತೆನಿ ಸಗ್ಳ್ಯಾನಿ ತೆಕಾ ಭಿಂವ್ಲ್ಯಾನಿ, ಸಾವ್ಲ್ ಖರೆಚ್ ಜೆಜುಚೊ ಶಿಸಾ ಮನ್ತಲೆ ತೆನಿ ವಿಶ್ವಾಸ್ ಕರುಕ್ ನಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ಖರೆ ಬಾರ್ನಾಬಾಸ್ ತೆಕಾ ಮಜತ್ ಕರುಕ್ ಯೆಲೊ ಅನಿ ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಬುಲ್ವುನ್ ಹಾನ್ಲ್ಯಾನ್, ಸಾವ್ಲಾನ್ ದಮಸ್ಕಾಚ್ಯಾ ವಾಟೆರ್ ಧನಿಯಾಕ್ ಬಗಲ್ಲೆ, ಅನಿ ಧನಿಯಾನ್ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲಲ್ಲೆ ಬರ್ನಾಬಾಸಾನ್ ತೆಂಕಾ ಸಾಂಗ್ಲ್ಯಾನ್, ತವ್ಡೆಚ್ ನ್ಹಯ್ ಸಾವ್ಲಾನ್ ಧಮಾಸ್ಕಾತ್ ಲೊಕಾಕ್ನಿ ಧನಿಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಧೈರ್‍ಯಾನಿ ಪರ್ಗಟ್ ಕರ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ತ್ಯಾ ದಿಸಾಚ್ಯಾನ್ ಸಾವ್ಲಾನ್ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ, ತೆನಿ ಧನಿಯಾಚ್ಯಾ ನಾವಾರ್ ಜೆರುಜಲೆಮಾತ್ಬಿ ಧೈರ್ಯಾನ್ ಶಿಕಾಪ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ಸಾವ್ಲು ಗ್ರಿಕ್ ಭಾಶ್ಯಾ ಭೊಲ್ತಲ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಪರ್ತುನ್ ಭೊಲ್ತಾ ಅನಿ ವಾದ್ ಕರ್‍ತಾ ಖರೆ ತೆನಿ ತೆಕಾ ಜಿವ್ ಕಾಡುಕ್ ಬಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಸಾವ್ಲಾನ್ ಅಪ್ಲ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಕಳ್ವುತಾನಾ ತೆನಿ ತೆಕಾ ಸೆಜರೆಯಾ ಶಾರಾಕ್ ಬಲ್ವುನ್ ನೆವ್ನ್ ಥೈತ್ನಾ ತಾರ್ಸಿಸ್ ಶಾರಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ಅಶೆ ರಾತಾನಾ ಜುದೆಯಾ, ಗಲಿಲಿಯಾ, ಅನಿ ಸಮಾರಿಯಾ ಗಾಂವಾತ್ನಿ ಹೊತ್ತ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ನಿ ಶಾಂತ್ಪಾನ್ ಹೊಲೆ, ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚ್ಯಾ ಮಜತಿ ವೈನಾ ತೆ ತಾಂಡೆ ವಾಡುಕ್ ಲಾಗ್ಲೆ, ಲೊಕಾನಿ ಅಪ್ನಿ ಧನಿಯಾಕ್ ಮಾನ್ ದಿತ್ಯಾತ್ ಮನ್ತಲೆ ಅಪ್ಲ್ಯಾ ಜಿವಿತಾನಿ ದಾಕ್ವುನ್ ದಿಲ್ಯಾನಿ, ಹೆಚ್ಯಾ ಸಾಟ್ನಿ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಲೈ ವಾಡುಕ್ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ಪೆದ್ರು ಜೆರುಜಲೆಮಾಚ್ಯಾ ಅಜು ಬಾಜು ಹೊತ್ತ್ಯಾ ಗಾಂವಾತ್ನಿ ಜಾಂವ್ನ್ಗೆತ್ ರಾತಾನಾ ಲಿಡ್ಡಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಹೊತ್ತ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಭೆಟುಚೆ ಮನುನ್ ಥೈ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ತೆನಿ ಲಿಡ್ಡಾತ್ ಎನೆಯಾ ಮನ್ತಲ್ಯಾ ಎಕ್ ಮಾನ್ಸಾಕ್ ಬಗಟ್ಲ್ಯಾನ್, ತೆಕಾ ವಾರೆಮಾರುನ್ ಆಟ್ ವರ್ಸಾಚ್ಯಾನ್ ತೊ ಹಾತ್ರಾನಾತುಚ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ಪೆದ್ರು ತೆಕಾ “ಎನೆಯಾ ಜೆಜು ಕ್ರಿಸ್ತ್ ತುಕಾ ಗುನ್ ಕರ್‍ತಾ ಉಟುನ್ ತುಜೆ ಹಾತ್ರಾನ್ ಗೊಳಾ ಕರುನ್ ಥವ್!” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್, ತನ್ನಾಚ್ ಎನೆಯಾ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ಲಿಡ್ಡಾ ಅನಿ ಸಾರೊನಾಚ್ಯಾ ಮಾಳಾತ್ ಜಿವನ್ ಕರಿತ್ ಹೊತ್ತಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ಬಗುನ್ ಧನಿಯಾಕ್ಡೆ ಮನ್ ಪರತ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ಜೊಪ್ಪಾ ಶಾರಾತ್ ತಬಿಥಾ ಮನ್ತಲಿ ಜೆಜುಚಿ ಶಿಸೆ ಹೊತ್ತಿ, ಗ್ರಿಕ್ ಭಾಶ್ಯಾನ್ ತಿಜೆ ನಾವ್ ದೊರ್ಕಾಸ್ ಮಟ್ಲ್ಯಾರ್, “ಚಿತಾಳ್” ಮನುನ್, ತಿ ಕನ್ನಾಬಿ ಲೊಕಾಂಚ್ಯಾ ಸಾಟ್ನಿ ಬರಿ ಕಾಮಾಚ್ ಕರಿತ್ ಹೊತ್ತಿ, ಅನಿ ತಿ ಗರಿಬ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಕನ್ನಾಬಿ ಮಜ್ಜತ್ ಕರಿತ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ಪೆದ್ರು ಲಿಡ್ಡಾತ್ ರಾತಾನಾ ತಿ ಸಿಕೆತ್ ಪಡುನ್ ಮರುನ್ ಗೆಲಿ, ಲೊಕಾನಿ ತಿಚ್ಯಾ ಮಡ್ಯಾಕ್ ನಾವ್ಸುನ್ ಮ್ಹಾಳ್ಯಾ ವೈಲ್ಯಾ ಎಕ್ ಖೊಲಿತ್ ಥವಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ಪೆದ್ರು ಜೊಪ್ಪಾತ್ ಹಾಯ್ ಮನ್ತಲಿ ಖಬರ್ ದೆವಾಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಕಳಲ್ಲಿ, ಜೊಪ್ಪ್ ಮನ್ತಲೆ ಗಾಂವ್ ಲಿಡ್ಡಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಚ್ಯಾ ಜಗೊಳುಚ್ ಹೊತ್ತೆ , ತಸೆ ಹೊವ್ನ್ ತೆನಿ ದೊನ್ ಮಾನ್ಸಾಕ್ನಿ ಪೆದ್ರುಕ್ಡೆ ಧಾಡ್ಲ್ಯಾನಿ, ತ್ಯಾ ದೊಗಾನಿ ಪೆದ್ರುಕ್, “ದಯಾ ಕರುನ್ ತಾಬ್ಡೊಡ್ತೊಬ್ ಯೆ!” ಮನುನ್ ಬಲ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ಪೆದ್ರು ತಯಾರ್ ಹೊವ್ನ್ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲೊ ತೊ ಥೈ ಪಾವಲ್ಯಾ ತನ್ನಾ ತೆನಿ ಪೆದ್ರುಕ್ ಮ್ಹಾಳ್ಳ್ಯಾ ವೈಲ್ಯಾ ಖೊಲಿಕ್ ಬಲ್ವುನ್ ನ್ಹೆಲ್ಯಾನಿ, ಘವ್ಮರಲ್ಲಿ ಬಾಯ್ಕಾಮಾನ್ಸಾ ಸಗ್ಳ್ಯಿ ರಡಿಂಗೆತ್ ಪೆದ್ರುಕ್ಡೆ ಯೆಲಿ, ಅನಿ ದೊರ್ಕಾಸ್ ಜಿವಾನಿ ರಾತಾನಾ ಅಪ್ನಾಕ್ನಿ ತಯಾರ್ ಕರುನ್ ದಿಲ್ಲೆ ಝಗೆ ಅನಿ ಕಪ್ಡೆ ಸಗ್ಳ್ಯೆ ಪೆದ್ರುಕ್ ದಾಕ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ಪೆದ್ರುನ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಖೊಲಿತ್ನಾ ಭಾಯ್ರ್ ಧಾಡುನ್ ಡಿಂಬಿಯಾ ಘಾಲುನ್ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನ್, ಮಾನಾ ತಬಿಥಾಚ್ಯಾ ಮಡ್ಯಾಕ್ಡೆ ಪರ್ತುನ್ “ತಬಿಥಾ, ಉಟುನ್ ಇಬೆರಾ” ಮಟ್ಲ್ಯಾನ್, ತಿನೆ ಅಪ್ಲೆ ಡೊಳೆ ಉಗಡ್ಲಿನ್, ಅನಿ ಪೆದ್ರುಕ್ ಬಗುನ್ ಉಟುನ್ ಬಸ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ಪೆದ್ರುನ್ ಹಾತ್ ಧರುನ್ ತಿಕಾ ಉಟುನ್ ಇಬೆ ರಾವ್ಕ್ ಮಜ್ಜತ್ ಕರ್‍ಲ್ಯಾನ್, ಮಾನಾ ತೆನಿ ಘವ್ಮರಲ್ಯಾ ಬಾಯ್ಕಾಮಾನ್ಸಾಕ್ನಿ, ಅನಿ ದೆವಾಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಖೊಲಿತ್ ಬಲ್ವುನ್ ತಬಿಥಾ ಝಿತ್ತಿ ಹೊಲ್ಲಿ ತೆಂಕಾ ದಾಕ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ಜೊಪ್ಪಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿಬಿ ಹಿ ಖಬರ್ ಕಳ್ಲಿ ಹ್ಯಾ ಲೊಕಾತ್ನಿ ಲೈ ಲೊಕಾನಿ ಧನಿಯಾಚೆರ್ ವಿಶ್ವಾಸ್ ಥವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ಪೆದ್ರು ಲೈ ದಿಸಾಂಚ್ಯಾ ಪತರ್ ಬಿ ಜೊಪ್ಪಾತ್ಲ್ಯಾ ಚಮ್ಡ್ಯಾಚೆ ಕಾಮ್ ಕರ್‍ತಲ್ಯಾ ಸಿಮಾವಾಚ್ಯಾ ಘರಾತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ಸೆಜಾರೆಯ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಕೊರ್ನೆಲ್ ಮನ್ತಲೊ ಎಕ್ಲೊ ಹೊತ್ತೊ, ತೊ ಇಟಲಿ ಸೈನ್ಯಾಚೊ ಎಕ್ ಶತಾದಿಪತಿ ಹೊವ್ನ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ಹ್ಯೊ ಕೊರ್ನೆಲ್ ದೆವಸ್ಪಾನಾಚೊ ಮಾನುಸ್ ಹೊವ್ನ್ ಹೊತ್ತೊ, ತೊ ಅನಿ ತೆಚ್ಯಾ ಘರಾತ್ಲಿ ಸಗ್ಳಿ ಲೊಕಾ ದೆವಾಕ್ ಆರಾದನ್ ಕರಿತ್, ತೊ ಬರ್‍ಯಾ ಮನಾನ್ ಗರಿಬಾಕ್ನಿ ದಾನ್ ಧರ್ಮ್ ಕರಿತ್ ಹೊತ್ತೊ, ಅನಿ ಕನ್ನಾಬಿ ದೆವಾಕ್ಡೆ ಮಾಗ್ನಿ ಕರಿತ್ ರ್‍ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ಎಕ್ ದಿಸಿ ದೊಪರಾಕ್ಡೆ ಸುಮಾರ್ ತಿನ್ ಗಂಟೆ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಕೊರ್ನೆಲಾಕ್ ಎಕ್ ದರ್ಶನ್ ದಿಸ್ಲೆ, ದೆವಾಚೊ ದುತ್ ಎಕ್ಲೊ ತೆಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ “ಕೊರ್ನೆಲಾ” ಮನುನ್ ಬಲ್ವುತಲೆ ತೆಕಾ ಚೊಕ್ಕ್ ದಿಸ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ತನ್ನಾ ಕೊರ್ನೆಲಾನ್ ದೆವಾಚ್ಯಾ ದುತಾಕ್ ಬಗುನ್ ಭಿಂವ್ನ್ ಸಾಯ್ಬಾ ತುಕಾ ಕಾಯ್ ಹೊವ್ಚೆ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್, ತೆಕಾ “ದೆವಾನ್ ತುಜಿ ಮಾಗ್ನಿಯಾ ಆಯಿಕ್ಲ್ಯಾನ್, ತಿಯಾ ಗರಿಬಾಕ್ನಿ ದಾನ್ ಧರ್ಮ್ ದಿಲ್ಲೆ ಸಗ್ಳ್ಯೆ ತೆನಿ ಬಗ್ಲಾ, ದೆವಾನ್ ತುಕಾ ಮೆಚ್ಚುನ್ ಘೆಟ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ಅತ್ತಾ ಸಿಮಾವ್ ಮನ್ತಲ್ಯಾ ಮಾನ್ಸಾಕ್ ಬಲ್ವುನ್ ಹಾನುಕ್ ಸಾಟ್ನಿ ಲೊಕಾಕ್ನಿ ಜೊಪ್ಪ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಧಾಡ್, ಸಿಮಾವಾಕ್ ಪೆದ್ರು ಮನುನ್‍ಬಿ ಬಲ್ವುತಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ಸಿಮಾವ್ ಚಮ್ಡ್ಯಾಚೆ ಕಾಮ್ ಕರ್ತಲ್ಯಾ ಮಾನ್ಸಾಚ್ಯಾ ಘರಾತ್ ರ್‍ಹಾಯ್, ತೆಜೆ ಘರ್ ಸಮುಂದ್ರಾಚ್ಯಾ, ದಂಡೆಕ್ ಹಾಯ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ಕೊರ್ನೆಲಾಚ್ಯಾ, ವಾಂಗ್ಡಾ ಬೊಲಲೊ ದೆವಾಚೊ ದುತ್ ಗೆಲೊ, ಮಾನಾ ತೆನಿ ಅಪ್ಲ್ಯಾ ಸೆವಕಾಂತ್ಲ್ಯಾ ದೊಗಾಕ್ನಿ, ಅನಿ ಎಕ್ ಸೈನಿಕಾ ಬಲ್ವುಲ್ಯಾನ್, ಹ್ಯೊ ಸೈನಿಕ್ ದೆವಸ್ಪಾನಾಚೊ ಮಾನುಸ್ ಹೊಲ್ಲೊ. ಕೊರ್ನೆಲಾಚ್ಯಾ ಮನಾಕ್ ಜಗೊಳ್ಲ್ಯಾ ಮಜ್ಜತ್ ಕಾರಾತ್ನಿ ಹ್ಯೊಬಿ ಎಕ್ಲೊ ಹೊವ್ನ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ಕೊರ್ನೆಲಾನ್ ತೆಂಕಾ ಹರ್ ಎಕ್‍ಬಿ ವಿವರನ್ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ತೆಂಕಾ ಜೊಪ್ಪಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ದುಸ್ರ್ಯಾ ದಿಸಿ ಹಿ ಲೊಕಾ ಜೊಪ್ಪಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಜಗ್ಗೊಳ್ ಯೆಲ್ಲ್ಯಾ ದೊಪಾರ್ಚೊ ಎಳ್ ಹೊಲ್ಲೊ ತ್ಯಾ ವೆಳಾರ್ ಪೆದ್ರು ಮಾಗ್ನಿ ಕರುಕ್ ಸಾಟ್ನಿ ಘರಾಚ್ಯಾ ಮಾಳ್ಗಿ ವರ್‍ತಿ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ಪೆದ್ರುಕ್ ಬುಕ್ ಲಾಗುನ್ ಜೆವಾನ್ ಕರುಚೆ ಸಾರ್ಕೆ ದಿಸ್ಲೆ, ಥೈ ತೆಚ್ಯಾ ಸಾಟ್ನಿ ರಾಂದುಗೆತ್ ಹೊತ್ತೆ ತನ್ನಾ ಪೆದ್ರುಕ್ ಎಕ್ ದರ್ಶನ್ ದಿಸ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ಉಗಡಲ್ಲ್ಯಾ ಮಳ್ಬಾಕ್ನಾ ಖಲೊಕಿ ಎಕ್ ವಸ್ತ್ ಖಾಲ್ತಿ ಉತ್ರುನ್ ಯೆವ್ಕ್ ಲಾಗಲ್ಲೆ ತೆನಿ ಬಗಟ್ಲ್ಯಾನ್, ತೆ ಎಕ್ ಮೊಟ್ಯಾ ವಾಟ್ಲಿ ಸಾರ್ಕೆ ಹೊತ್ತೆ ತೆಚ್ಯಾ ಚಾರಿ ಮುಲ್ಲ್ಯಾಕ್ನಿ ದೊರಿಯಾ ಬಾಂದುನ್ ಜಿಮ್ನಿ ವರ್‍ತಿ ಉತ್ರುನ್ ಸೊಡಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ತ್ಯಾತುರ್ ಸಗ್ಳ್ಯಾ ನಮನ್ಯಾಚಿ ಜನಾವರಾ ಹೊತ್ತಿ ಮಟ್ಲ್ಯಾರ್, ಚಾರ್ ಪಾಯಾಂಚಿ ಜನಾವರಾ, ಪೊಟಾನ್ ಜಾತಲೆ ಕಿಡೆ, ಅನಿ ಫಾಂಕ್ರಾ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ತನ್ನಾ ಎಕ್ ಧನಾನ್, ಪೆದ್ರು ಉಟ್! ಕಾಪುನ್ ಖಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ಖರೆ ಪೆದ್ರುನ್ “ಧನಿಯಾ ಮಿಯಾ ತಸೆ ಕರಿನಾ! ಭ್ರಸ್ಟ್ ಹೊಲ್ಲೆ ಅನಿ ಅಶುದ್ದ್ ಅಸಲ್ಲೆ ಮಿಯಾ ಕನ್ನಾಬಿ ಖಾಲ್ಲೊ ನ್ಹಯ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ಖರೆ ತ್ಯಾ ಧನಿಯಾನ್ ತೆಕಾ ದೆವಾನ್ ಹೆ ಸಗ್ಳ್ಯೆ ಶುದ್ದ್ ಕರ್‍ಲಾ, ಹೆಕಾ ಸಗ್ಳ್ಯಾಕ್ ಬ್ರಸ್ಟ್ ಮನುನ್ ಸಾಂಗುನಕೊ! ಮನುನ್ ಅನಿ ಪರ್ತುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ಅಸೆಚ್ ತಿನ್‍ ದಾ ಹೊಲೆ ಮಾನಾ ತೆ ಸಗ್ಳ್ಯೆ ತಾಬೊಡ್ತೊಬ್ ಮಳ್ಬಾಕುಚ್ ಪರ್ತುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ಪೆದ್ರುಕ್ ಅಪ್ನಿ ಬಗಲ್ಲ್ಯಾ ದರ್ಶನಾಚೊ ಅರ್ಥ್ ಕಾಯ್ ಹೊವ್ಕ್ ಫಿರೆ ಮನುನ್ ಅಜಾಪ್ ಹೊಲೆ, ತನ್ನಾಚ್ ಕೊರ್ನೆಲಾನ್ ದಾಡಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಸಿಮಾವಾಚೆ ಘರ್ ವಳ್ಕುನ್ ಕಾಡುನ್ ತೆನಿ ದಡ್ಪ್ಯಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಇಬೆ ರಾವ್ನ್, ");
INSERT INTO kans_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ಬಲ್ವುನ್, “ಸಿಮಾವ್ ಪೆದ್ರು ಮನ್ತಲೊ ಮಾನುಸ್ ಹಿತ್ತೆ ಹಾಯ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ಪೆದ್ರು ತ್ಯಾ ದರ್ಶನಾಚ್ಯಾ ವಿಶಯಾತ್ ಅಜುನ್ ಬಿ ಯವ್ಜುನ್ಗೆತ್ ಹೊತ್ತೊ, ಖರೆ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ತೆಕಾ, ಸಿಮಾವ್ ತುಕಾ ಹುಡ್ಕುಂಗೆತ್ ತಿನ್ ಲೊಕಾ ಯೆಲಾತ್, ");
INSERT INTO kans_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ತಿಯಾ ಉಟುನ್ ಖಾಲ್ತಿ ಉತ್ರುನ್ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾ, ಪಾಟಿ ಸರ್ಕುನಕ್ಕೊ ಅನಿ ಜವಾಬ್ ಇಚಾರುನಕ್ಕೊ , ಮಿಯಾಚ್ ತೆಂಕಾ ತುಜ್ಯಾಕ್ಡೆ ಧಾಡುನ್ ದಿಲಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ತಸೆ ಹೊವ್ನ್ ಪೆದ್ರು ಖಾಲ್ತಿ ಉತ್ರುನ್ ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಜಾವ್ನ್, “ತುಮಿ ಹುಡ್ಕುಕ್ ಲಾಗಲ್ಲೊ ಮಾನುಸ್ ಮಿಯಾಚ್” ತುಮಿ ಕಶ್ಯಾಕ್ ಯೆಲ್ಯಾಸಿ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ತ್ಯಾ ಲೊಕಾನಿ, ಕೊರ್ನೆಲ್ ಮನ್ತಲೊ ಎಕ್ ಶತಾದಿಪತಿ ಹೊತ್ತೊ, ತೊ ಧಾರ್ಮಿಕ್ ಮಾನುಸ್ ,ಅನಿ ದೆವಾಕ್ ಆರಾದನ್ ಕರ್‍ತಲೊ ಅನಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಸಗ್ಳ್ಯಿ ತೆಕಾ ಮಾನ್‍ ದಿತ್ಯಾತ್, ತುಕಾ ಅಪ್ಲ್ಯಾ ಘರಾಕ್ ಬಲ್ವುನ್ ತಿಯಾ ಸಾಂಗ್ತಲಿ ಸಂಗ್ತಿಯಾ ಆಯ್ಕುಚೆ ಮನುನ್ ದೆವಾಚ್ಯಾ ದುತಾನ್ ಕೊರ್ನೆಲಾಕ್ ಕಳ್ವುಲ್ಯಾನ್, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ಪೆದ್ರುನ್ ತೆಂಕಾ ಭುತ್ತುರ್ ಬಲ್ವುನ್, ತ್ಯಾ ರಾತ್ತಿನಿ ಥೈಚ್ ರಾವ್ಚೆ ಮನುನ್ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನ್, ದುಸ್ರ್ಯಾಂದಿಸಿ ಪೆದ್ರು ತಯಾರ್ ಹೊವ್ನ್ ತ್ಯಾ ತಿನ್ ಮಾನ್ಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾವ್ಕಲಾಲೊ, ಜೊಪ್ಪಾತ್ಲೆ ದೆವಾಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾತ್ನಿ ಥೊಡಿ ಲೊಕಾ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ದುಸ್ರ್ಯಾಂದಿಸಿ ತೆನಿ ಸೆಜಾರೆಯ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಪಾವ್ಲೆ ಕೊರ್ನೆಲ್ ತೆಂಚ್ಯಾಸಾಟ್ನಿ ರಾಕುನ್ಗೆತ್ ಹೊತ್ತೊ, ತೆನಿ ಅಪ್ಲ್ಯಾ ಬಳ್ಗಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಅನಿ ಜಗೊಳ್ಲ್ಯಾ ವಾಂಗ್ಡಿಯಾಕ್ನಿ ತನ್ನಾಚ್ ಅಪ್ಲ್ಯಾ ಘರಾಕ್ ಬಲ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ಪೆದ್ರು ಘರಾತ್ ಗುಸ್ತಾನಾ ಕೊರ್ನೆಲ್ ತೆಕಾ ಇದ್ರಾಕ್ ಗಾವ್ಲೊ ಅನಿ ಪೆದ್ರುಚ್ಯಾ ಪಾಂಯಾತ್ನಿ ಅಡ್ವೊ ಪಡುನ್ ನಮಸ್ಕಾರ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ಖರೆ ಪೆದ್ರುನ್ ತೆಕಾ, “ವೈರ್ ಉಟ್ವುನ್ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾ! ಮಿಯಾಬಿ ತುಜ್ಯಾ ಸರ್ಕೊಚ್ ಎಕ್ ಕೆವಲ್ ಮಾನುಸ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ಪೆದ್ರುನ್ ಕೊರ್ನೆಲಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಅನಿಬಿ ಬೊಲುನ್ಗೆತ್ ಭುತ್ತುರ್ ಗೆಲ್ಯಾ ತನ್ನಾ ಥೈ ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಂಚೊ ಮೊಟೊ ತಾಂಡೊ ಬಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ಪೆದ್ರುನ್ ತೆಂಕಾ, “ಜುದೆವಾಂಚೊ ಎಕ್ ಮಾನುಸ್ ದುಸ್ರ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಸಂಪರ್ಕ್ ಥವ್ನ್ ಘೆತಲೆ ಹೊಂವ್ದಿ, ತೆಕಾ ಭೆಟ್ತಲೆ ಹೊಂವ್ದಿ ಹೆ ಸಗ್ಳೆ ಮೊಯ್ಜೆಚ್ಯಾ ಕರಾರಾಂಚ್ಯಾ ಪುಸ್ತಕಾಕ್ ವಿರೊದ್ ಹೊವ್ನ್ ಹಾಯ್ ಮನ್ತಲೆ ತುಮ್ಕಾ ಗೊತ್ತುಚ್ ಹಾಯ್, ಖರೆ ಖಚ್ಚ್ಯಾ ಮಾನ್ಸಾಕ್ಬಿ ಬ್ರಸ್ಟ್ ಮನುನ್ ಹೊಂವ್ದಿ ಅಶುದ್ದ್ ಮನುನ್ ಬಲ್ವುತಲೆ ಹೊಂವ್ದಿ ಕರು ನ್ಹಯ್ ಮನುನ್ ದೆವಾನ್ ಮಾಕಾ ದಾಕ್ವುನ್ ದಿಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ತಸೆ ಹೊವ್ನ್, ಮಾಕಾ ಹಿತ್ತೆ ಯೆ ಮನುನ್ ಬಲ್ವಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಯಾ ವಾದ್ ಕರುಕ್‍ ನಾ, ಖರೆ ತುಮಿ ಮಾಕಾ ಕಶ್ಯಾಕ್ ಬಲ್ವುಲ್ಯಾಸಿ ಮನ್ತಲೆ ದಯಾ ಕರುನ್ ಅತ್ತಾ ಸಾಂಗಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ತನ್ನಾ ಕೊರ್ನೆಲಾನ್, “ತಿನ್ ದಿಸಾಂಚ್ಯಾ ಫಾಟ್ಲ್ಯಾ ದಿಸಿ, ಮಿಯಾ ಮಾಜ್ಯಾ ಘರಾತ್ ಮಾಗ್ನಿ ಕರಿತ್ ಹೊತ್ತೊ, ತನ್ನಾ ಸುಮಾರ್ ದೊಪಾರ್ಚೆ ತಿನ್ ಗಂಟೆ ಯೆಳ್ ಹೊಲ್ಲೊ, ಎಗ್ದಮ್ ಮಾಜ್ಯಾ ಫಿಡ್ಯಾತ್ ಎಕ್ ಮಾನುಸ್ ಯೆವ್ನ್ ಇಬೆ ರ್‍ಹಾಲೊ ತೆನಿ ನೆಸಲ್ಲೆ ಕಪ್ಡೆ ಉಜ್ವೊಡಾ ಸಾರ್ಕೆ ಹೊಳ್ವಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ತ್ಯಾ ಮಾನ್ಸಾನ್, ಕೊರ್ನೆಲ್! ದೆವಾನ್ ತುಜಿ ಮಾಗ್ನಿ ಆಯಿಕ್ಲಾ, ತಿಯಾ ಗರಿಬಾಕ್ನಿ ದಿತಲೆ ಸಗ್ಳೆ ಬಗುನ್ ದೆವಾನ್ ತುಕಾ ಧ್ಯಾನಾತ್ ಘೆಟ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ತಸೆ ಹೊವ್ನ್ ಥೊಡ್ಯಾ ಲೊಕಾಕ್ನಿ ಜೊಪ್ಪ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಧಾಡುನ್ ಪೆದ್ರು ಮನುನ್ ಬಲ್ವುತಲ್ಯಾ ಸಿಮಾವಾಕ್ ಯೆವ್ಕ್ ಸಾಂಗ್, ಪೆದ್ರು ಚಮ್ಡ್ಯಾಚೆ ಕಾಮ್ ಕರ್‍ತಲ್ಯಾ ಸಿಮಾವ್ ಮನ್ತಲ್ಯಾಚ್ಯಾ ಘರಾತ್ ವಸ್ತಿ ಹಾಯ್, ತೆಜೆ ಘರ್ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆಕ್ ಹಾಯ್” ಮಟ್ಲ್ಯಾ‍ನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ತಸೆ ಹೊವ್ನ್, ಮಿಯಾ ಲಗ್ಗುನಾ ತುಕಾ ಯೆವ್ಕ್ ಸಾಂಗುನ್ ಧಾಡ್ಲೊ, ತಿಯಾ ಹಿತ್ತೆ ಯೆಲ್ಲೆ ಉಪ್ಕಾರ್ ಹೊಲೊ, ಅಮ್ಕಾ ಸಾಂಗ್ ಮನುನ್ ಧನಿಯಾನ್ ತುಕಾ ಸಾಂಗಲ್ಲೆ ಹರ್ ಎಕ್‍ಬಿ ಆಯ್ಕುಕ್ ಅಮಿ ಸಗ್ಳೆ ಹಿತ್ತೆ ದೆವಾಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಗೊಳಾ ಹೊಲಾಂವ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ಪೆದ್ರುನ್ ಬೊಲ್ನೆ ಚಾಲುಕರುನ್, ದೆವ್ ಸಗ್ಳ್ಯಾಕ್ನಿಬಿ ಎಕುಚ್ ನಮುನಿ ಬಗ್ತಾ, ಮನ್ತಲೆ ಖರೆ ಮಾಕಾ ಅತ್ತಾ ಕಳ್ಳೆ. ");
INSERT INTO kans_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ಅಪ್ನಾಕ್ ಆರಾದನ್ ಕರ್‍ತಲೊ ನಿತಿಚೊ ಮಾನುಸ್ ಕೊನ್ ಹೊಲ್ಯಾರ್ಬಿ ದೆವ್ ತೆಕಾ ಅಪ್ನಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಘೆತಾ, ಹಿತ್ತೆ ತೊ ಖಚ್ಚ್ಯಾ ದೆಶ್ಯಾಚೊ ಮನ್ತಲೆ ಜವಾಬ್ ಯೆಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ದೆವಾನ್ ಇಸ್ರಾಯೆಲ್‌ಕಾರಾಕ್ನಿ ಅಪ್ಲಿ ಬರಿ ಖಬರ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್ ಅನಿ ಜೆಜು ಕ್ರಿಸ್ತಾಕ್ನಾ ಬರಿ ಖಬರ್ ಪರ್ಗಟ್ ಕರ್‍ಲ್ಯಾನ್, ತೊ ಸಗ್ಳ್ಯಾಂಚೊ ಧನಿಯಾ ಹೊವ್ನ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ಗಲಿಲಾಯಾತ್ ಶುರು ಹೊವ್ನ್ ಜುವಾಂವಾಕ್ ಬಾಲ್ತಿಮಾಚ್ಯಾ ವಿಶಯಾತ್ ಪರ್ಗಟ್ ಕರಲ್ಯಾ ಮಾನಾ ಜುದೆಯಾತ್ ಕಾಯ್ ಹೊಲೆ ಮನ್ತಲೆ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ನಜರೆತಾಚ್ಯಾ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್, ದೆವಾನ್ ತೆಕಾ ಪವಿತ್ರ್ ಆತ್ಮೊ ಅನಿ ಬಳ್ ದಿವ್ನ್ ಅಭಿಶೆಕ್ ಕರ್‍ಲ್ಯಾನ್, ತೆನಿ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಲೊಕಾಕ್ನಿ ಬರೆ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ಮ್ಹಾರು ಧರಲ್ಯಾಕ್ನಿ ಜೆಜುನ್ ಗುನ್ ಕರ್‍ಲ್ಯಾನ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಜೆಜುಚ್ಯಾ ವಾಂಗ್ಡಾ ದೆವ್ ಹಾಯ್ ಮನ್ತಲೆ ಹೆಚ್ಯಾ ವೈನಾ ದಿಸುನ್ ಯೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ಇಸ್ರಾಯೆಲಾಂಚ್ಯಾ ದೆಶ್ಯಾತ್ ಅನಿ ಜೆರುಜಲೆಮಾತ್ ಜೆಜುನ್ ಕರಲ್ಲಿ ಸಗ್ಳಿ ಕಾಮಾ ಅಮಿ ಬಗಟ್ಲಾಂವ್, ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಕಾಮಾಕ್ನಿ ಅಮಿ ಸಾಕ್ಷಿ ಹೊವ್ನ್ ಹಾತ್, ಖರೆ ಜೆಜುಕ್ ಜಿವ್ ಕಾಡುನ್ ಹೊಲೆ ತೆನಿ ತೆಕಾ ಕುರ್ಸಾರ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ಖರೆ, ದೆವಾನ್ ತೆಕಾ ಮರ್ನಾಕ್ನಾ ತಿನ್ವೆ ದಿಸಾತ್ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುಲ್ಯಾನ್! ಜೆಜು ಪ್ರತ್ಯೆಕ್ಷ್ ದಿಸಿ ಸಾರ್ಕೊ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ಖರೆ ಜೆಜುನ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ದಾಕ್ವುನ್ ಘೆವ್ಕ್ ನಾ, ದೆವಾಕ್ನಾ ಅದ್ದಿಚ್ ಸಾಕ್ಷಿ ಹೊವ್ನ್ ಎಚುನ್ ಘೆಟಲ್ಯಾನಿ ಎವ್ಡೆಚ್ ತೆಕಾ ಬಗ್ಲ್ಯಾನಿ! ಜೆಜು ಮರ್ನಾಕ್ನಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆಲಾ ಮಾನಾ ಅಮಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವಾನ್ ಕರ್ಲಾಂವ್ ಅನಿ ಫಿಲಾವ್. ");
INSERT INTO kans_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ಲೊಕಾಕ್ನಿ ಶಿಕಾಪಾ ಕರುಚೆ ಮನುನ್ ಜೆಜುನ್ ಅಮ್ಕಾ ಸಾಂಗಲ್ಯಾನ್, ಝಿತ್ತೆ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿಬಿ ಅನಿ ಮರುನ್ ಗೆಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಿ ದೆವಾಕ್ನಾ ನಾಯ್ಯಾಧಿಪತಿ ಹೊಲ್ಲೊ ಮಾನುಸ್ ಅಪ್ನಿಚ್ ಮನ್ತಲೆ ಲೊಕಾಕ್ನಿ ಕಳ್ವು ಮನುನ್ ಅಮ್ಕಾ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ಜೆಜುಚ್ಯಾ ವರ್ತಿ ವಿಶ್ವಾಸ್ ಥವ್ತಲ್ಯಾ ಹರ್ ಎಕ್ಲ್ಯಾಚೊ ಪಾಪ್‍ ಬಿ ದೆವ್ ಜೆಜುಕ್ನಾ ಮಾಪ್ ಕರ್‍ತಾ, ಹೆ ಖರೆ ಮನುನ್ ಪ್ರವಾದ್ಯಾನಿ ಸಾಂಗ್ಲಾತ್, ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ಪೆದ್ರು ಅಶೆ ಸಾಂಗುನ್ಗೆತ್ ರ್‍ಹಾತಾನಾಚ್ ತೆಚಿ ಬರಿ ಖಬರ್ ಆಯ್ಕಲ್ಯಾಂಚ್ಯಾ ವರ್‍ತಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ಉತ್ರುನ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ಪೆದ್ರುಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆಲ್ಲಿ ಜೊಪ್ಪಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ಲಿ ಜುದೆವ್ ವಿಶ್ವಾಸಿ ಲೊಕಾ, ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿಬಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ಯೆಲ್ಲೆ ಬಗುನ್ ತೆನಿ ಅಜಾಪ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ಪೆದ್ರುಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಕೊನ್ ತರಿ ತೆಂಕಾ ಪಾನಿಯಾನ್ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆಯ್ನಾ ಸಾರ್ಕೆ ಅಡ್ಕಳ್ ಕರುಕ್ ಹೊಯ್ಲ್ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ಪಾನಿಯಾತ್ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆಯ್ನಾ ಸಾರ್ಕೆ ಹೆಂಕಾ ಅಡ್ಕಳ್ ಕರುಕ್ ಕೊನಾಚೆನ್ಬಿ ಹೊಯ್ಲ್ ಕಾಯ್? ಅಮಿ ಮಾನುನ್ ಘೆಟಲ್ಯಾ ಸಾರ್ಕೆಚ್ ಹೆನಿಬಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಕ್ ಮಾನುನ್ ಘೆಟ್ಲ್ಯಾನಿ!” ಮನುನ್ ಸಾಂಗುನ್, ");
INSERT INTO kans_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ಜೆಜುಚ್ಯಾ ನಾವಾನ್ ಪಾನಿಯಾತ್ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆವ್ಕ್ ಪೆದ್ರುನ್ ತೆಂಕಾ ಹುಕುಮ್ ದಿಲ್ಯಾನ್, ತೆಚ್ಯಾ ಮಾನಾ ಥೊಡ್ಯಾ ದಿಸಾಂಚ್ಯಾ ಪತರ್ ಅಪ್ಲ್ಯಾ ವಾಂಗ್ಡಾ ರಾವ್ಚೆ ಮನುನ್ ತ್ಯಾ ಲೊಕಾನಿ ಪೆದ್ರುಕ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ಅಪೊಸ್ತಲಾಕ್ನಿ ಅನಿ ಜುದೆಯೆತ್ಲ್ಯಾ ಭಾವಾಕ್ನಿಬಿ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾನಿ ದೆವಾಚಿ ಗೊಸ್ಟಿಯಾ ಮಾನುನ್ ಘೆಟ್ಲ್ಯಾನಿ ಮನ್ತಲೆ ಕಳುನ್ ಯೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ಖರೆ ಪೆದ್ರು ಜೆರುಜಲೆಮಾಕ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಸುನ್ನತ್ ಹೊವ್ಕುಚ್ ಪಾಜೆ ಮನುನ್ ಚಿಂತ್ತಲ್ಯಾ ಲೊಕಾನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಚರ್ಚಾ ಕರುನ್ಗೆತ್, ");
INSERT INTO kans_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ತೆನಿ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾಂಚ್ಯಾ ಅನಿ ಸುನ್ನತ್ ಕರುನ್ ಘೆವ್ ನಸಲಾಂಚ್ಯಾ ಘರಾತ್ನಿ ತಿಯಾ ಗೆಲೈ! ಅನಿ ತಿಯಾ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆವಾನ್ಬಿ ಕರ್‍ಲೆ! ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ತಸೆ ಹೊವ್ನ್ ಪೆದ್ರುನ್ ಅದ್ದಿಚ್ಯಾನ್ ಹೊಲ್ಲಿ ಸಂಗ್ತಿಯಾ ಸಗ್ಳ್ಯಿ ತೆಂಕಾ ಸಾಂಗುನ್ಗೆತ್, ");
INSERT INTO kans_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ಪೆದ್ರುನ್ ತೆಂಕಾ, ಮಿಯಾ ಜೊಪ್ಪಾ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾ, ಮಾಗ್ನಿ ಕರ್‍ತಾನಾ, ಮಾಕಾ ಎಕ್ ದರ್ಶನ್ ದಿಸ್ಲೆ ತ್ಯಾ ದರ್ಶನಾತ್ ಮಳ್ಬಾಕ್ನಾ ಉತ್ರುನ್ ಯೆತಲೊ ಎಕ್ ವಸ್ತ್ ಬಗ್ಲೊ ತೆ ಫಾಂಡ್ರ್ಯಾ ಕಪ್ಡ್ಯಾಚ್ಯಾ ಝೊಳ್ಗಿ ಸಾರ್ಕೆ ಹೊತ್ತೆ ತೆಚ್ಯಾ ಚಾರಿ ಮುಲ್ಲ್ಯಾಕ್ನಿಬಿ ಬಾಂದುನ್ ಮಳಬಾಕ್ನಾ ಖಾಲ್ತಿ ಸೊಡಲ್ಲೆ ಹೊತ್ತೆ ತೆ ಉತ್ರುನ್ ಯೆವ್ನ್ ಮಿಯಾ ಹೊತ್ಯಾಕ್ಡೆ ಜಗೊಳುಚ್ ಇಬೆ ರಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ತಾತ್ಯುರ್ ಜಿಮ್ನಿ ವೈಲಿ ಚಾರ್ ಪಾಯಾಂಚಿ ಜನಾವರಾ ಭಯಾನಕ್ ಜನಾವರಾ, ಪೊಟಾನ್ ಫಿರ್ತಲೆ ಕಿಡೆ ಅನಿ ಫಾಂಕ್ರಾಬಿ ಹೊತ್ತಿ ಮಿಯಾ ಬಗಟ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ತನ್ನಾ ಪೆದ್ರು, ಉಟ್! ಜಿವ್ ಕಾಡುನ್ ಖಾ! ಮನುನ್ ಮಾಕಾ ಸಾಂಗ್ತಲೊ ಧನ್ ಆಯ್ಕಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ಖರೆ ಮಿಯಾ, ಧನಿಯಾ ಮಿಯಾ ತಸೊ ಕರಿನಾ! ಭ್ರಸ್ಟ್ ಅನಿ ಅಶುದ್ದ್ ಹೊತ್ತೆ ಕಾಯ್ಬಿ ಮಿಯಾ ಖಾಯ್ನಾ ಮನುನ್ ಸಾಂಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ಖರೆ ದೆವಾನ್ ಹೆ ಶುದ್ದ್ ಕರ್‍ಲಾ ತಿಯಾ ಹೆ ಅಶುದ್ದ್ ಮನುನ್ ಸಾಂಗುನಕ್ಕೊ! ಮನುನ್ ತ್ಯಾ ಸರ್‍ಗಾ ವೈಲ್ಯಾ ಧನಾನ್ ಮಾಕಾ ಜವಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ಅಸೆಚ್ ತಿನ್ದಾ ಹೊಲೆ ಮಾನಾ ತೆ ಸಗ್ಳ್ಯೆ ಪರ್ತುನ್ ಮಳ್ಬಾಕುಚ್ ಘೆವ್ನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ತ್ಯಾ ಎಳಾರ್ ಸೆಜರೆಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ನಾ ಧಾಡುನ್ ದಿಲ್ಲಿ ತಿನ್ ಲೊಕಾಕ್ನಿ ಮಿಯಾ ಹೊತ್ತ್ಯಾ ಘರಾಕ್ ತ್ಯಾ ಎಳಾರ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ಅನ್ಮಾನ್ ಕರಿನಸ್ತಾನಾ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾವ್ಚೆ ಮನುನ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಮಾಕಾ ಸಾಂಗ್ಲ್ಯಾನ್, ಹಿತ್ತೆ ಹೊತ್ತಿ ಹಿ ಸಾ ಲೊಕಾ ಭಾವಾಬಿ ಮಾಜ್ಯಾ ವಾಗ್ಡಾ ಸೆಜರಿಯಾಕ್ ಯೆಲಿ ಮಾನಾ ಅಮಿ ಕೊರ್ನೆಲಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲ್ಲ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ಕೊರ್ನೆಲಾನ್ ಅಪ್ಲ್ಯಾ ಘರಾತ್ ದೆವಾಚೊ ದುತ್ ಇಬೆ ಹೊತ್ತೊ ಅಪ್ನಿ ಬಗಲ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಮಾಕಾ ಸಾಂಗ್ಲ್ಯಾನ್, ತ್ಯಾ ದೆವಾಚ್ಯಾ ದುತಾನ್ ತೆಕಾ, ಥೊಡ್ಯಾ ಲೊಕಾಕ್ನಿ ಜೊಪ್ಪಾಕ್ ಧಾಡುನ್ ಸಿಮಾವ್ ಪೆದ್ರುಕ್ ತುಜ್ಯಾಕ್ಡೆ ಬಲ್ವುನ್ ಘೆ, ");
INSERT INTO kans_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ತೊ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲ್ತಾ, ತೊ ಸಾಂಗ್ತಲಿ ಸಂಗ್ತಿಯಾ ತುಕಾ ಅನಿ ತುಜ್ಯಾ ಘರಾನ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ರಾಕ್ವನ್ ಕರ್‍ತಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“ಮಿಯಾ ಮಾಜಿ ಶಿಕಾಪ್ ಚಾಲುಕರಲ್ಯಾ ತನ್ನಾ ಅದ್ದಿ ಅಮ್ಚ್ಯಾರ್ ಪವಿತ್ರ್ ಆತ್ಮೊ ಯೆಲ್ಲ್ಯಾ ಸಾರ್ಕೊಚ್ ತೆಂಚ್ಯಾ ವೈರಬಿ ಯೆಲೊ”. ");
INSERT INTO kans_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ತನ್ನಾ ಮಿಯಾ ಧನಿಯಾಚಿ ಬೊಲ್ನಿ ಯಾದ್ ಕರುನ್ ಘೆಟಲ್ಲೊ, ಜುವಾಂವಾನ್ ಲೊಕಾಕ್ನಿ ಪಾನಿಯಾತ್ ಬಾಲ್ತಿಮ್ ಕರಸ್ಲ್ಯಾನ್, ಖರೆ ತುಮಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾತ್ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆತ್ಯಾಶಿ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ಧನಿ ಜೆಜುಚ್ಯಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಥವಲ್ಲ್ಯಾ ಅಮ್ಕಾ ದಿಲ್ಲಿ ವರುಚ್ ದೆವಾನ್ ಹ್ಯಾ ಲೊಕಾಕ್ನಿಬಿ ದಿಲ್ಯಾನ್, ಅಶೆ ರಾತಾನಾ ದೆವಾಚೆ ಕಾಮ್ ಇಬೆ ಕರುಕ್ ಮಿಯಾ ಕೊನ್? ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ಜುದೆವಾತ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾನಿ ಹಿ ಸಂಗ್ತಿಯಾ ಆಯ್ಕಲ್ಲ್ಯಾ ಮಾನಾ ವಾದ್ ಕರ್‍ತಲೆ ಬಂದ್ ಕರುನ್ ದೆವಾಕ್ ಸ್ತುತಿ ಕರುಂಗೆತ್ “ತಸೆ ಹೊಲ್ಯಾರ್ ಅಮ್ಚ್ಯಾ ಬಾಸೆನ್ ಅಪ್ಲಿ ಮನಾ ಬದ್ಲುನ್ ಘೆವ್ನ್ ಜಿವ್ ಘೆವ್ಕ್ ಸಾಟ್ನಿ ದೆವಾನ್ ಜುದೆವಾಂಚೆ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿಬಿ ಅವಾಕಾಸ್ ದಿಲ್ಯಾನ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ಸ್ತೆಪನಾಕ್ ಜಿವಾನಿ ಮಾರುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಯೆಲ್ಲ್ಯಾ ತರಾಸಾನಿ ದೆವಾಚಿ ಲೊಕಾ ಸಗ್ಳಿ ಪಗ್ಳುನ್ ಗೆಲ್ಲಿ, ದೆವಾಚ್ಯಾ ಲೊಕಾತ್ನಿ ಥೊಡಿ ಲೊಕಾ ಪೊಯಿನಿಕ್ಯಾ, ಸಿಪ್ರ್ ಅನಿ ಅಂತಿಯೊಕ್ಯ್ ಮನ್ತಲ್ಯಾ ಲೈ ಧುರ್‍ಲ್ಯಾ ಗಾಂವಾತ್ನಿ ಗೆಲೆ, ದೆವಾಚ್ಯಾ ಲೊಕಾನಿ ಹ್ಯಾ ಗಾಂವಾತ್ನಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಕಳ್ವುಲ್ಯಾನಿ ಖರೆ ತೆನಿ ಜುದೆವಾಕ್ನಿ ಎವ್ಡೆಚ್ ಕಳ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ಹ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾತ್ನಿ ಥೊಡಿ ಲೊಕಾ ಸೈಪುಸ್ ಅನಿ ಸಿರೆನ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ಲೆ ಹೊತ್ತೆ, ಹಿ ಲೊಕಾ ಅಂತಿಯೊಕ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಥೈತ್ಲ್ಯಾ ಗ್ರಿಕ್ ಬಾಶ್ಯಾ ಬೊಲ್ತಲ್ಯಾ ಲೊಕಾಕ್ನಿಬಿ ತೆನಿ ಧನಿಯಾ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಬರಿ ಖಬರ್ ಕಳ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ಧನಿ ದೆವಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಮಜ್ಜತ್ ಕರಿತ್ ಹೊತ್ತೊ, ಲೈ ಲೊಕಾ ಧನಿಯಾಚೆರ್ ವಿಶ್ವಾಸ್ ಥವ್ನ್ ತೆಚ್ಯಾ ಸಾರ್ಕೆಚ್ ಚಾಲ್ವುನ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಲಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ಅಂತಿಯೊಕ್ಯಾತ್ಲ್ಯಾ ಹ್ಯಾ ನ್ಹವ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಜೆರುಜಲೆಮಾತ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಕಳ್ಳೆ, ತಸೆಹೊವ್ನ್ ತೆನಿ ಬರ್ನಾಬಾಕ್ ಅಂತಿಯೊಕ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಧಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ಬಾರ್ನಾಬಾಸ್ ಅಂತಿಯೊಕಾಕ್ ಪಾವಲ್ಯಾ ತನ್ನಾ ದೆವಾನ್ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಲೈ ಆಶಿರ್ವಾದ್ ಕರಲ್ಲೆ ಬಗಟ್ಲ್ಯಾನ್, ಹೆಚ್ಯಾ ವೈನಾ ತೆಕಾ ಲೈ ಖುಶಿ ಹೊಲಿ, ಅನಿ ತೆನಿ ಅಂತಿಯೊಕ್ಯಾತ್ ಹೊತ್ತ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಸಗ್ಳೆ ಪುರಾ ಮನಾನಿ ಧನಿಯಾಚೆರ್ ವಿಶ್ವಾಸಾನ್ ವಾಡ್ವಳ್ಕಿ ಹೊಯ್ ಸಾರ್ಕೆ ಉಮ್ಮೆದ್ ಭರ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ಬಾರ್ನಾಬಾಸ್ ಬರೊ ಮಾನುಸ್ ಹೊಲ್ಲೊ, ತೊ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರಲ್ಲೊ ಅನಿ ಪುರಾ ವಿಶ್ವಾಸಾನ್ ಹೊತ್ತೊ ಅನಿ ಲೈ ಲೊಕಾಕ್ನಿ ಧನಿಯಾಕ್ಡೆ ಬಲ್ವುನ್ ಹಾನ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ತೆಚ್ಯಾ ಮಾನಾ ಸಾವ್ಲಾಕ್ ಹುಡ್ಕುಂಗೆತ್ ಬಾರ್ನಾಬಾಸ್ ತಾರ್ಸಿಸ್ ಶಾರಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ಬಾಬಾನ್ ಥೈ ಸಾವ್ಲಾಕ್ ಹುಡ್ಕುನ್ ಕಾಡುನ್ ಅಪ್ಲ್ಯಾ ವಾಂಗ್ಡಾ ತೆಕಾ ಅಂತಿಯೊಕಾಕ್ ಬಲ್ವುನ್ ಹಾಡ್ಲ್ಯಾನ್, ತೆನಿ ದೊಗೆಬಿ ಅಂತಿಯೊಕ್ಯಾತ್ ಎಕ್ ವರ್ಸ್ ಪುರಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಮೊಗಾನ್ ರಾವ್ನ್ ಲೈ ಲೊಕಾಕ್ನಿ ಶಿಕಾಪಾ ಕರ್‍ಲ್ಯಾನಿ, ಜೆಜುಚ್ಯಾ ಗೊಸ್ಟಿಯಾಂಚ್ಯಾ ಸಾರ್ಕೆ ಚಲ್ತಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಕ್ರಿಸ್ತಾಂವಾ ಮನ್ತಲೆ ನಾವ್ ಯೆಲ್ಲೆ ಅಂತಿಯೊಕ್ಯಾತುಚ್. ");
INSERT INTO kans_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ತ್ಯಾ ಎಳಾರ್ ಥೊಡಿ ಲೊಕಾ ಪ್ರವಾದಿಯಾ ಜೆರುಜಲೆಮಾಕ್ನಾ ಅಂತಿಯೊಕಾಕ್ ಗೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ಹ್ಯಾ ಪ್ರವಾದ್ಯಾತ್ನಿ ಅಗಬ್! ಮನ್ತಲೊ ಎಕ್ಲೊ ಹೊತ್ತೊ, ಹೆನಿ ಅಂತಿಯೊಕ್ಯಾತ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರುನ್ ಸಗ್ಳ್ಯಾ ಜಗಾಕುಚ್ ಲೈ ಮೊಟೊ ಬರ್ಗಾಲ್ ಯೆತಲೊ ಹಾಯ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್, ತೊ ಬರ್ಗಾಲ್ ಕ್ಲಾಡಿಸ್ ಮನ್ತಲ್ಯಾ ರಾಜಾಚ್ಯಾ ಎಳಾರ್ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ಜುದೆಯ್ ಗಾಂವಾತ್ಲ್ಯಾ ಭಾವಾಕ್ನಿ ಅನಿ ಭೆನಿಯಾಕ್ನಿ ಮಜ್ಜತ್ ಕರುಚೆ ಮನುನ್ ದೆವಾಚ್ಯಾ ಲೊಕಾನಿ ಚಿಂತುನ್ ದೆವಾಚ್ಯಾ ಲೊಕಾತ್ನಿ ಹರ್ ಎಕ್ಲ್ಯಾನ್‍ಬಿ ಅಪ್ನಾಕ್ಡೆ ಕೌವ್ಡೆ ಹೊತಾ ತವ್ಡೆ ತೆಂಕಾ ಧಾಡುನ್ ದಿವ್ಕ್ ಯೆವ್ಜನ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ತೆನಿ ಪೈಸೆ ಜಮ್ವುನ್ ಬರ್ನಾಬಾಸ್, ಅನಿ ಸಾವ್ಲಾಕ್ಡೆ ದಿಲ್ಯಾನಿ, ಮಾನಾ ಬಾರ್ನಾಬಾಸ್ ಅನಿ ಸಾವ್ಲಾನ್ ತೆ ಪೈಸೆ ಹಾನುನ್ ಜುದೆಯಾತ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಮುಖಂಡಾಕ್ನಿ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ . ");
INSERT INTO kans_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ತ್ಯಾ ಯೆಳಾರ್ ಹೆರೊದ್‍ರಾಜಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ಲ್ಯಾ ಥೊಡಾಕ್ನಿ ತರಾಸ್ ದಿವ್ಕ್ ಲಾಗುನ್, ");
INSERT INTO kans_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ಜುವಾಂವಾಚೊ ಮೊಟೊ ಭಾವ್ ಜಾಕೊಬಾಕ್ ಕೊಯ್ತ್ಯಾನಿ ಜಿಂವ್ ಕಾಡ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಹೆ ಸಗ್ಳೆ ಬರೆ ದಿಸ್ಲಿ ಮನ್ತಲೆ ಹೆರೊದಾನ್ ಕಳ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ತಸೆ ಹೊವ್ನ್ ತೆನಿ ಪೆದ್ರುಕ್ ಭಾಂದುನ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಘಾಲುಕ್ ಲಾವ್ಲ್ಯಾನ್, ತನ್ನಾ ಫುಗ್ ನಸಲ್ಲ್ಯಾ ಭಾಕ್ರಿಯಾಂಚೊ ಸನ್ ಚಲಿತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ಸೊಳಾ ಸೈನಿಕಾ ಪೆದ್ರುಕ್ ರಾಕ್ವಲಿ ಹೊತ್ತೆ, ಪಾಸ್ಕಾಚೊ ಸನ್ ಸರಲ್ಯಾ ತನ್ನಾ ತೆಕಾ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಹಾನುನ್ ಇಬೆ ಕರುಚೆ ಮನುನ್ ಘೆಟಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ಪೆದ್ರು ಬಂದಿಖಾನ್ಯಾತ್ ರಾತಾನಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ಲಿ ಲೊಕಾ ತೆಚ್ಯಾ ಸಾಟ್ನಿ ಪುರಾ ಮನ್ ದಿವ್ನ್ ಮಾಗ್ನಿ ಕರಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ಪೆದ್ರು ದೊನ್ ಸೈನಿಕಾಂಚ್ಯಾ ಮದ್ದಿ ನಿಜಲೊ ಹೊತ್ತೊ, ಅನಿ ತೆಕಾ ದೊನ್ ಸರ್ಪೊಳಿಯಾನಿ ಭಾಂದಲೆ ಹೊತ್ತೆ, ತನ್ನಾ ರಾತ್ ಹೊಲ್ಲಿ ಅನಿ ಲೈ ಲೊಕಾ ಸೈನಿಕಾ ಧಾರಾತ್‍ ಬಿ ರಾಕಿತ್ ಹೊತ್ತಿ, ದುಸ್ರೆಂದಿಸಾ ಪೆದ್ರುಕ್ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಹಾನುಚೆ ಮನುನ್ ಹೆರೊದಾನ್ ಯೆವ್ವುನ್ ಘೆವ್ನ್ ಹೊತ್ತ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ಎಗ್ದಮ್, ಧನಿಯಾಚೊ ದುತ್ ಥೈ ಇಬೆ ರ್‍ಹಾಲೊ, ತ್ಯಾ ಖೊಲಿತ್ ಉಜ್ವೊಡ್ ಹೊಲೊ, ದೆವ್ ದುತಾನ್ ಪೆದ್ರುಕ್ ಆಪ್ಡುನ್ ಉಟ್ವುನ್ “ಲಗ್ಗುನಾ ಉಟ್!” ಮಟ್ಲ್ಯಾನ್, ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ತೆಚ್ಯಾ ಹಾತಿಚಿ ಸರ್ಪೊಳಿಯಾ ಸುಟುನ್ ಪಡ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ದೆವಾಚ್ಯಾ ದುತಾನ್ ಪೆದ್ರುಕ್, “ಕಪ್ಡೆ ನೆಸುನ್ ಘೆ; ಅನಿ ವ್ಹಾನಾಯ್ಯಾ ಘಾಲುನ್ ಘೆ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ಪೆದ್ರುನ್ ತಸೆಚ್ ಕರ್‍ಲ್ಯಾನ್, ಮಾನಾದೆವ್ ದುತಾನ್ ತುಜೊ ಝಗೊ ಬಾಂಧುನ್ ಘೆವ್ನ್ ಮಾಜ್ಯಾ ಫಾಟ್ನಾ ಯೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ದೆವಾಚೊ ದುತ್ ಭಾಯ್ರ್ ಗೆಲೊ ಮಾನಾ ಪೆದ್ರುಬಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲೊ, ದೆವಾಚೊ ದುತ್ ಅಶೆ ಕರ್‍ತಾ ಮನ್ತಲೆ ಪೆದ್ರುಕ್ ಖರೆಚ್‍ಬಿ ಗೊತ್ತ್ ನತ್ತೆ, ಅಪ್ನಿ ಬಗುಲಾಗಲೆ ಸಗ್ಳ್ಯೆದರ್ಶನ್ ಮನುನ್ ತೆನಿ ಚಿಂತ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ದೆವಾಚೊ ದುತ್ ಅನಿ ಪೆದ್ರುನ್ ಅದ್ದಿಚಿ ಅನಿ ದೊನ್ವೆಚಿ ರಾಕ್ವನ್ ಹೊತ್ತೆ ಜಾಗೆ ದಾಟ್ಲ್ಯಾನಿ, ಮಾನಾ ತೆನಿ ಅಪ್ಲ್ಯಾ ಗಾಂವಾಕ್ಡೆ ಜಾತಲ್ಯಾ ಲೊಂಗ್ಟಾಂಚ್ಯಾ ದಾರಾಕ್ಡೆ ಯೆಲೆ, ತೆ ದಾರ್ ಅಪ್ಲ್ಯಾ ಯೆವ್ಡ್ಯಾಕುಚ್ ಅಪ್ನಿ ಉಗಡ್ಲೆ ಪೆದ್ರು ಅನಿ ದೆವಾಚೊ ದುತ್ ತ್ಯಾ ದಾರಾನಿ ಭಾಯ್ರ್ ಯೆವ್ನ್ ಉಲ್ಲೆ ದುರ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ದೆವ್ ದುತ್ ಪೆದ್ರುಕ್ ಸೊಡುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ಹೊಲ್ಲಿ ಸಂಗ್ತಿಯಾ ತನ್ನಾ ಪೆದ್ರುನ್ ಕಳ್ವುನ್ ಘೆವ್ನ್ “ಧನಿಯಾನ್ ದೆವಾಚ್ಯಾ ದುತಾಕ್ ಖರೆಬಿ ಮಾಜ್ಯಾಕ್ಡೆ ಧಾಡುನ್ ದಿಲ್ಯಾನ್ ಮನ್ತಲೆ ಮಾಕಾ ಅತ್ತಾ ಕಳ್ಳೆ, ತೆನಿ ಮಾಕಾ ಹೆರೊದ್ ರಾಜಾಚ್ಯಾ ಹಾತಿತ್ನಾ ಪಾರ್ ಕರ್‍ಲ್ಯಾನ್, ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾನಿ ಮಾಕಾ ಬುರ್ಶೆ ಹೊತಾ ಮನುನ್ ಚಿಂತಲ್ಯಾನಿ, ಖರೆ ಧನಿಯಾನ್ ಮಾಕಾ ತರಾಸಾತ್ನಾ ರಾಕ್ವನ್ ಕರ್‍ಲ್ಯಾನ್” ಮನುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ಮಾನಾ ತೊ ಮರಿಯಾಂಚ್ಯಾ ಘರಾಕ್ ಗೆಲೊ ಮರಿಯಾ ಮನ್ತಲಿ ಜುವಾಂವಾಂಚಿ ಬಾಯ್ ಜುವಾಂವಾಕ್ ಮಾರ್ಕ್ ಮನುನ್‍ಬಿ ಬಲ್ವಿತ್, ಥೈ ಲೈ ಲೊಕಾ ಗೊಳಾ ಹೊವ್ನ್ ಮಾಗ್ನಿ ಕರಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ಪೆದ್ರುನ್ ತ್ಯಾ ಘರಾಕ್ ಯೆವ್ನ್ ಧಾರ್ ಬಡ್ವುಲ್ಯಾನ್, ರೊದ್ ಮನ್ತಲಿ ಆಳ್ ಕೊನ್‍ ಕಾಯ್ ಮನುನ್ ಬಗುಕ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ರೊದೆನ್ ಪೆದ್ರುಚಿ ಧನ್ ವಳಕ್ಲಿನ್, ಅನಿ ತಿಕಾ ಲೈ ಕುಶಿ ಹೊಲಿ, ದಾರ್ ಕಾಡ್ತಲೆ ಇಸ್ರುನ್ ತಿ ಭುತ್ತುರ್ ಮಾಗ್ನಿ ಕರುಕ್ ಲಾಗಲ್ಲ್ಯಾಂಚ್ಯಾಕ್ಡೆ ಪಳುನ್ ಗೆಲಿ ಅನಿ “ಪೆದ್ರು ಭಾಯ್ರ್ ಇಬೆ ಹಾಯ್!” ಮಟ್ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ತನ್ನಾ ತ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾನಿ “ತುಕಾ ಪಿಶೆ ಧರ್ಲಾ!” ಮಟ್ಲ್ಯಾನಿ, ಖರೆ ತಿನೆ ಅಪ್ನಿ ಸಾಂಗುಲಾಗಲೆ ಖರೆಚ್ ಮನುನ್ ಸಾಂಗ್ಲಿನ್, ತಸೆ ಹೊವ್ನ್ ತೆನಿ, ತೊ ಪೆದ್ರುಚೊ ದುತ್ ಹೊವ್ಕ್ ಫಿರೆ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ಖರೆ ಪೆದ್ರು ದಾರ್ ಬಡ್ವುಂಗೆತುಚ್ ಹೊತ್ತೊ, ತ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾನಿ ಧಾರ್ ಕಾಡುನ್ ಪೆದ್ರುನ್ ಬಗುನ್ ವಿಸ್ಮಿತ್ ಹೊಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ಪೆದ್ರುನ್ ತೆಂಕಾ ಗಪ್ಪ್ ರ್‍ಹಾಯ್ ಸಾರ್ಕೆ ಸೊನ್ನಾಯ್ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ಧನಿಯಾನ್ ಅಪ್ನಾಕ್ ಬಂದಿಖಾನ್ಯಾತ್ನಾ ಸೊಡ್ವುನ್ ಹಾನಲೆ ಕಶೆ ಮನ್ತಲೆ ತೆಂಕಾ ಸಾಂಗುನ್, ಜಾಕೊಬಾಕ್ ಅನಿ ಹುರಲ್ಲ್ಯಾ ಭಾವಾಕ್ನಿಬಿ ಹಿ ಸಂಗ್ತಿಯಾ ಕಳ್ವಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್, ಮಾನಾ ಪೆದ್ರು ಥೈತ್ನಾ ದುಸ್ರ್ಯಾಕ್ಡೆ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ದುಸ್ರ್ಯಾಂದಿಸಿ, ಪೆದ್ರು ಖೈ ಗೆಲೊ ಮನುನ್ ಸೈನಿಕಾತ್ನಿ ಮೊಟೊ ಗೊಂದಲ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ಖೈ ಹುಡಕ್ಲ್ಯಾರ್ಬಿ ಹೆರೊದಾಕ್ಡೆ ಪೆದ್ರುಕ್ ಹುಡ್ಕುನ್ ಕಾಡುಕ್ ಹೊವ್ಕ್ ನಾ, ತಸೆ ಹೊವ್ನ್ ತೆನಿ ರಾಕ್ವಲ್ಯಾಕ್ನಿ ಇಚಾರುನ್ ತೆಂಕಾ ಮರ್ನ್ನಾಚಿ ಶಿಕ್ಷಾ ದಿಲ್ಯಾನ್, ಮಾನಾ ಹೆರೊದಾನ್ ಜುದೆಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ನಾ ಸೆಜರೆಯ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಜಾವ್ನ್ ಥೊಡೆ ದಿಸಾ ಥೈಚ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ತಿರ್ ಅನಿ ಸಿದೊನ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಂತ್ಲಾ ಲೊಕಾಂಚೆರ್ ಹೆರೊದಾಕ್ ಲೈ ರಾಗ್ ಯೆಲ್ಲೊ, ತ್ಯಾ ಶಾರಾಂತ್ಲಿ ಲೊಕಾ ಹೆರೊದಾಕ್ ಲೆಕ್ ಭೆಟ್ವುಚೆ ಮನುನ್ ಗೊಳಾ ಹೊವ್ನ್ ಗೆಲಿ, ಅನಿ ಬ್ಲಾಸ್ತಾ ಮನ್ತಲ್ಯಾ ಹೆರೊದಾಚ್ಯಾ ವಯಕ್ತಿಕ್ ಸೆವಕಾಕ್ ಅಪ್ನಾಕ್ಡೆ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ತೆನಿ ಅಪ್ನಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೆರೊದ್‍ರಾಜಾನ್ ಶಾಂತ್ಪಾನಾಚೊ ಕರಾರ್ ಕರುನ್ ಘೆವ್ಚೆ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆಂಚ್ಯಾ ಗಾಂವಾಕ್ನಿ ಹೆರೊದಾಚ್ಯಾ ಗಾಂವಾಕ್ನಾಚ್ ಜೆವ್ನಾಕ್ ಪಾಜೆ ಹೊಲ್ಲೆ ಸಗ್ಳೆ ಯೆಯ್ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ತೆಂಕಾ ಭೆಟುಕ್ ಮನುನ್ ಹೆರೊದ್ ರಾಜಾನ್ ಎಕ್‍ ದಿಸ್ ವಳಕ್ ಕರುನ್, ತ್ಯಾ ದಿಸಿ ತೆನಿ ಬರೆ ದಿಸ್ತಲೆ ರಾಜಾಚೆ ಕಪ್ಡೆ ನೆಸುನ್ ಘೆವ್ನ್ ಅಪ್ಲ್ಯಾ ಸಿವಾಸನಾರ್ ಬಸುನ್ ಲೊಕಾಕ್ನಿ ಭಾಶಾನ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ತ್ಯಾ ಲೊಕಾನಿ, “ಹಿ ಧನ್ ದೆವಾಚಿಚ್ ಮಾನ್ಸಾಚಿ ನ್ಹಯ್” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ಹೆರೊದಾನ್ ಹಿ ಹೊಗ್ಳಾಪಾ ಸಗ್ಳಿ ಅಪ್ನಾಚಿಚ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನ್, ತೆನಿ ದೆವಾಕ್ ಮಹಿಮಾ ಕರುಕ್ ನಾ ತಸೆ ಹೊವ್ನ್ ತನ್ನಾಚ್ ಧನಿಯಾಚ್ಯಾ ದೆವ್ ದುತಾನ್ ತೆಕಾ ರೊಗ್ ಯೆಯ್ ಸಾರ್ಕೆ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ತೆಚ್ಯಾ ಅಂಗಾತ್ಲಿ ಭುತ್ತುರ್‍ಲಿ ಭಾಗಾ ಕಿಡ್ಯಾನಿ ಖಾವ್ನ್ ತೊ ಮರುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಪಗ್ಳುಲಾಗಲಿ ಅನಿ ಲೈ ಲೊಕಾಕ್ನಿ ಗಾವ್ಲಾಗಲಿ, ");
INSERT INTO kans_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ಬಾರ್ನಾಬಾಸ್ ಅನಿ ಸಾವ್ಲಾ ಜೆರುಜಲೆಮ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಅಪ್ಲೆ ಕಾಮ್ ಕರುನ್ ಫಾಟಿ ಅಂತಿಯೊಕ್ಯ್ ಶಾರಾಕ್ ಯೆಲ್ಯಾನಿ, ಮಾರ್ಕ್ ಮನ್ತಲ್ಯಾ ಜುವಾಂವಾಕ್ಬಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಘೆವ್ನ್ ಯೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ಅಂತಿಯೊಕ್ಯ್ ಮನ್ತಲ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ಥೊಡಿ ಲೊಕಾ ಪ್ರವಾದಿಯಾ ಅನಿ ಥೊಡೆ ಶಿಕಾಪಾ ಕರ್‍ತಲೆ ಹೊತ್ತೆ ತೆನಿ ಕೊನ್ ಮಟ್ಲ್ಯಾರ್ : ಬಾರ್ನಾಬಾಸ್, ನಿಗರ್ ಮನುನ್ ಬಲ್ವುತಲೊ ಸಿಮಾವ್, ಅನಿ ಸಿರೆನ್ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ಲೊ ಮೆನಹೆನ್ ಮನ್ತಲೊ ಅನಿ ಸಾವ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ತೆನಿ ಸಗ್ಳ್ಯಾನಿ ಧನಿಯಾಚಿ ಸೆವಾಕರಿತ್, ಅನಿ ಉಪ್ಪಾಸಿ ರಾವ್ನ್ ಮಾಗ್ನಿ ಕರಿತ್, ತನ್ನಾ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ತೆಂಕಾ, “ಬಾರ್ನಾಬಾಸಾಕ್ ಅನಿ ಸಾವ್ಲಾಕ್ ವಿಶೆಸ್ ಕರುನ್ ಯೆಗ್ಳೆಚ್ ಥವಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ತಸೆ ಹೊವ್ನ್ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾನಿ ಉಪ್ಪಾಸಿ ರಾವ್ನ್ ಮಾಗ್ನೆ ಕರುನ್, ಬಾರ್ನಾಬಾಸಾಕ್ ಅನಿ ಸಾವ್ಲಾಕ್ ಟಕ್ಲ್ಯಾ ವರ್‍ತಿ ಹಾತ್ ಥವ್ನ್ ತೆಂಕಾ ಆಶಿರ್ವಾದ್ ಕರುನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ಬಾನಾಬಾಸಾಕ್ ಅನಿ ಸಾವ್ಲಾಕ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನುಚ್ ಧಾಡುನ್ ದಿಲ್ಯಾನ್, ತೆನಿ ಸಿಲಿಸಿಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಗೆಲೆ, ಮಾನಾ ತೆನಿ ಸಿಲಿಸಿಯಾಕ್ನಾ ಢೊನಾತ್ನಾ ಸೈಪ್ರಸ್ ದ್ವಿಪಾಕ್ ಜಾವ್ಲಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ಬಾರ್ನಾಬಾಸ್ ಅನಿ ಸಾವ್ಲಾ ಸಾಲಾಮಿಸ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಜುದೆವಾನಿ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಪರ್ಗಟ್ ಕರ್ಲ್ಯಾನಿ ಮಾರ್ಕ್ ಮನ್ವುನ್ ಘೆತಲೊ ಜುವಾಂವ್ ಮಜ್ಜತ್ ಕರುಕ್‍ಸಾಟಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ತೆನಿ ತ್ಯಾ ದ್ವಿಪಾತ್ ಫಿರುಂಗೆತ್ ಪಾಫೊಸ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಜಾವ್ನ್ ಮೊಡಿ ಮಂತ್ರಾ ಕರ್‍ತಲ್ಯಾ ಜುದೆವಾಂಚೊ ಝುಟೊ ಪ್ರವಾದಿ ಹೊಲ್ಲೊ ಬಾರ್ ಜೆಜು ಮನ್ತಲ್ಯಾಕ್ ಬಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ಸೆರ್ಜಿಯೊ ಸಾವ್ಲು ಮನ್ತಲ್ಯಾ ನಾವಾಚೊ ಎಕ್ ಮಾನುಸ್ ರಾಜ್ಯಪಾಲಾಕ್ ವಾಂಗ್ಡಿ ಹೊವ್ನ್ ಹೊತ್ತೊ, ತೊ ಲೈ ಬುದ್ವಂತ್ ಮಾನುಸ್ ಹೊಲ್ಲೊ, ಖರೆ ತೊ ರಾಜ್ಯಪಾಲ್ ಬಾರ್ನಾಬ್ ಮನ್ತಲ್ಯಾ ಭಾವಾಕ್ನಾ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಆಯ್ಕುಚೆ ಮನುನ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ಖರೆ ತೊ ಮಾಟಾ ಮಂತರ್ಕಾರಿ ಎಲಿಮಾ ತೆಂಕಾ ವಿರೊದ್ ಹೊಲ್ಲೊ, ಗ್ರಿಕ್ ಬಾಶೆತ್ ಬಾರ್ ಜೆಜುಕ್ ಎಲಿಮಾ ಮನುನ್ ಬಲ್‍ಯಿತ್ ರಾಜ್ಯಪಾಲಾಕ್ ದೆವಾಚೆರ್ ವಿಶ್ವಾಸ್ ಥೈನಾ ಸಾರ್ಕೆ ಕರುಕ್ ಹ್ಯೊ ಎಲಿಮಾ ಕಟ್ಪಟ್ ಕರಿತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ಖರೆ ಪಾವ್ಲು ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರುನ್ ಎಲಿಮಾಕುಚ್ ಬಗುನ್, ");
INSERT INTO kans_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ತಿಯಾ ಗಿರ್ಯಾಚೊ ಲೆಕ್!” ಬರೆ ಹೊತಲ್ಯಾ ಹರ್ ಎಕ್ಲ್ಯಾಕ್ಬಿ ತಿಯಾ ದುಶ್ಮನ್ ಹೊವ್ನ್ ಹಾಸ್ ! ಧನಿಯಾಚ್ಯಾ ಖರೆ ಪಾನಾಕ್ ಝುಟೆ ಕರುಚೆ ಮನುನ್ ತಿಯಾ ಕನ್ನಾಬಿ ಕಟ್ಪಟ್ ಕರಿತ್ ರಾತೈ! ");
INSERT INTO kans_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ಅಬಕ್, ಧನಿಯಾ ಹಾತ್ ತುಕಾ ವೈರ್ ಹೊವ್ನ್ ಉಟೈತಿಲ್,ಉಲ್ಲೊ ಯೆಳ್ ತುಕಾ ಕಾಯ್ಬಿ ದಿಸಿನಾ, ತಿಯಾ ಕುಡ್ಡೊ ಹೊತೈ, ದಿಸಾಚೊ ಉಜ್ವೊಡ್ಬಿ ತಿಯಾ ಬಗುಕ್ ಹೊಯ್ನಾ ಮಟ್ಲ್ಯಾನ್ ತನ್ನಾ ತಾಬೊಡ್ತೊಬ್ ಎಲಿಯಾಕ್ ಸಗ್ಳೆಬಿ ಕಾಳೊಕ್ ಹೊವ್ನ್ ಗೆಲೆ, ಕೊನ್ ತರ್ ಬಿ ಅಪ್ನಾಕ್ ಹಾತ್ ಧರುನ್ ಚಲ್ವುಂದಿತ್ ಮನುನ್ ತಳ್ಮಳ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ಹೆ ಬಗಲ್ಯಾ ರಾಜ್ ಪಾಲಾನ್ ಧನಿಯಾಚೆರ್ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ತೊ ಧನಿಯಾಚ್ಯಾ ವಿಶಯಾಚೆ ಶಿಕಾಪ್ ಆಯ್ಕುನ್ ವಿಸ್ಮಿತ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ಪಾವ್ಲು ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಿಯಾನಿ ಪಾಫೊಸ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ನಾ ಢೊನಿತ್ನಾ ಗೆಲೆ, ಪಾಂಫಿಲಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ಲ್ಯಾ ಪೆರ್ಗೆ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ತೆನಿ ಯೆಲೆ, ಖರೆ ಮಾರ್ಕ್ ಮನ್ವುನ್ ಘೆತಲೊ ಜುವಾಂವ್ ತೆಂಕಾ ಸೊಡುನ್ ಜೆರುಜಲೆಮಾಕ್ ಪರ್ತುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ತೆನಿ ಪೆರ್ಗೆ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ನಿ ಫಿಡೆ ಜಾವ್ನ್, ಪಿಸಿದಿಯಾ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾಚ್ಯಾ ಅಂತಿಯೊಕಾಕ್ ಗೆಲೆ ತೆನಿ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಅಂತಿಯೊಕ್ಯಾತ್ಲಾ ಜುದೆವಾಂಚ್ಯಾ ಸಿನಾಗೊತ್ ಜಾವ್ನ್ ಬಸ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ಥೈ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚೆ ಪುಸ್ತಕ್ ಅನಿ ಪ್ರವಾದ್ಯಾಂಚೆ ಪುಸ್ತಕ್ ವಾಚುನ್ ಹೊಲೆ ಮಾನಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಮುಖಂಡಾನ್ ಪಾವ್ಲುಕ್, ಅನಿ ಬಾರ್ನಾಬಾಸಾಕ್ ಭಾವಾನು, ಹಿತ್ತೆ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಉಮ್ಮೆದ್ ಬರಿ ಸಾರ್ಕೆ ತುಮಿ ಕಾಯ್‍ ತರಿಬಿ ಸಾಂಗುಚೆ ಮನುನ್ ರ್‍ಹಾಲ್ಯಾರ್ ದಯಾ ಕರುನ್ ಸಾಂಗಾ! ಮನುನ್ ಖಬರ್ ಧಾಡ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ಪಾವ್ಲುನ್ ಇಬೆ ರ್‍ಹಾವ್ನ್ ಅಪ್ಲಿ ಬೊಲ್ನಿಯಾ ಸಾಂಗುಚೆ ಮನುನ್ ಲೊಕಾಕ್ನಿ ಹಾತ್ ಸೊನ್ನಿ ಕರುನ್ ದಾಕ್ವುನ್ ಅಶೆ ಮಟ್ಲ್ಯಾನ್ “ಮಾಜ್ಯಾ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾನು, ಜುದೆವಾನು, ಅನಿ ಖರ್ಯ್ಯಾ ದೆವಾಕ್ ಆರಾದನ್ ಕರ್‍ತಲ್ಯಾ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾನು, ಮಿಯಾ ಸಾಂಗ್ತಲೆ ಆಯ್ಕಾ!” ");
INSERT INTO kans_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ಇಸ್ರಾಯೆಲಾಂಚ್ಯಾ ದೆವಾನ್ ಅಮ್ಚ್ಯಾ ಪುರ್ವಜ್ ಲೊಕಾಕ್ನಿ ಎಚುನ್ ಘೆಟ್ಲ್ಯಾನ್ ಇಜಿಪ್ತಾತ್ ಪ್ರವಾಸ್ ಗೆಲ್ಯಾಂಚ್ಯಾ ಸಾರ್ಕೆ ಹೊತ್ತ್ಯಾ ಅಪ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ದೆವಾನ್ ಮಜ್ಜತ್ ಕರುನ್ ತೆಂಕಾ ಬರೆ ಕರ್‍ಲ್ಯಾನ್, ದೆವಾನ್ ಮೊಟೊ ದೆಶ್ ಹೊವ್ನ್ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ಅಪ್ಲ್ಯಾ ಮೊಟ್ಯಾ ಬಳಾನ್ ತೆಂಕಾ ತ್ಯಾ ದೆಶ್ಯಾತ್ನಾ ಚಾಲ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ಚಾಳಿಸ್ ವರ್ಸಾಂಚ್ಯಾ ಪಾತರ್ ಡಂಗ್ಳಿತ್ ತೆನಿ ಕರಲ್ಲೆ ಸಗ್ಳೆ ದೆವಾನ್ ಸೊಸುನ್ ಘೆಟ್ಲ್ಯಾನ್‍. ");
INSERT INTO kans_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ಕಾನಾನ್ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ಲ್ಯಾ ಸಾತ್ ಘರಾನಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ನಾಸ್‍ ಕರುನ್ ಅಪ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ತ್ಯಾ ಗಾಂವಾಚೊ ಅದಿಕಾರ್ ಸ್ವತಾಚೆ ಕರುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ಸುಮಾರ್ ಚಾರ್ಸೆಪನ್ನಾಸ್ ವರ್ಸಾಂಚ್ಯಾ ಯೆಳಾತ್ ಹೆ ಸಗ್ಳೆ ಹೊಲೆ, ಹೆ ಸಗ್ಳೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಪ್ರವಾದಿ ಸಾಮುಯೆಲಾಚ್ಯಾ ಯೆಳಾ ಪತರ್ಬಿ ದೆವಾನ್ ಅಮ್ಚ್ಯಾ ಲೊಕಾಕ್ನಿ ನ್ಯಾಯ್ ಕರ್‍ತಲೊ ಮಾನುಸ್ ದಿಲ್ಯಾನ್, ");
INSERT INTO kans_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ತೆಚ್ಯಾ ಮಾನಾ ಲೊಕಾನಿ ಅಪ್ನಾಕ್ನಿ ಎಕ್ ರಾಜಾ ಪಾಜೆ ಮನುನ್ ಮಾಗ್ತಾನಾ, ದೆವಾನ್ ತೆಂಕಾ ಕಿಶೆನ್ಯಾ ಮನ್ತಲ್ಯಾಚೊ ಲೆಕ್ ಸಾವ್ಲಾಕ್ ದಿಲ್ಯಾನ್, ಸಾವ್ಲ್ ಬೆನ್ಯಾಮಿನಾಚ್ಯಾ ಘರಾನಾಚೊ ಹೊ ಚಾಳಿಸ್ ವರ್ಸಾ ತೆಂಚೊ ರಾಜಾ ಹೊವ್ನ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ಸಾವ್ಲಾಕ್ ಕಾಡುನ್ ಘಾಟ್ಲ್ಯಾ ಮಾನಾ ದಾವಿದಾಕ್ ದೆವಾನ್ ತೆಂಚೊ ರಾಜಾ ಕರ್‍ಲ್ಯಾನ್, “ಕಿಸಿಯಾಚೊ ಲೆಕ್ ದಾವಿದ್ ಮಾಜ್ಯಾ ಮನಾ ಸಾರ್ಕೊ ಹೊವ್ನ್ ಹಾಯ್, ಅನಿ ತೊ ಮಾಜ್ಯಾ ಇಚ್ಚ್ಯಾ ಸಾರ್ಕೆಚ್ ಕಾಮಾ ಕರ್‍ತಾ” ಮನುನ್ ದೆವಾನ್ ದಾವಿದಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“ದೆವಾನ್ ದಾವಿದಾಚ್ಯಾ ಘರಾನಾಕ್ನಾ ಎಕ್ಲ್ಯಾಕ್ ಇಸ್ರಾಯೆಲಾಚ್ಯಾ ಲೊಕಾಂಚೊ ರಾಕ್ವನ್ ಕಾರಿ ಹೊವ್ನ್ ಅಪ್ಲ್ಯಾ ಗೊಸ್ಟಿ ಸಾರ್ಕೆಚ್ ಧಾಡುನ್ ದಿಲಾ ತೊಚ್ ಜೆಜು”. ");
INSERT INTO kans_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ಜೆಜು ಯೆವ್ಚ್ಯಾ ಅದ್ದಿ ಜುವಾಂವಾಕ್ ಜುದೆವಾಂಚ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ತುಮ್ಚ್ಯಾ ಪಾಪಾಕ್ನಿ ಮನ್ ಪರ್ತುನ್ ದೆವಾಕ್ಡೆ ಯೆವ್ನ್ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆವಾ ಮನುನ್ ಶಿಕಾಪ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ಹಿ ಕಾಮಾ ಸಾರ್ತಾನಾ ಜುವಾಂವಾನ್ ಲೊಕಾಕ್ನಿ “ಮಿಯಾ ಕೊನ್ ಮನುನ್ ತುಮಿ ಯೆವಜ್ತ್ಯಾಸಿ ಮಿಯಾ ಕ್ರಿಸ್ತ್ ನ್ಹಯ್ ಮಾಜ್ಯಾ ಮಾನಾ ತೊ ಯೆತಲೊ ಹಾಯ್ ಮಿಯಾ ತೆಚ್ಯಾ ಪಾಯಾತ್ಲಿ ವ್ಹಾನಾಯ್ಯಾ ಕಾಡುಕ್‍ಬಿ ಯೊಗ್ಯ್ ನಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ಮಾಜ್ಯಾ ಭಾವಾನು ಅಬ್ರಾಹಾಮಾಚ್ಯಾ ಘರಾನಾತ್ಲಾ ಲೆಕಾನು ಅನಿ ಖರ್ಯ್ಯಾ ದೆವಾಕ್ ಆರಾದನ್ ಕರುನ್ಗೆತ್ ಹೊತ್ತ್ಯಾ ಜುದೆವಾಂಚೆ ನ್ಹಯ್ ಹೊಲ್ಯಾ ಲೊಕಾನು, ಆಯ್ಕಾ!” ಅಮ್ಚ್ಯಾ ಸಾಟಿಚ್ ಹಿ ರಾಕ್ವನಿಚಿ ಖಬರ್ ಧಾಡಲಿ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ಜೆರುಜಲೆಮಾತ್ ಹೊತ್ತ್ಯಾ ಜುದೆವಾನಿ ಅನಿ ಜುದೆವಾಂಚ್ಯಾ ಮುಂಖಡಾನಿ ಜೆಜುಚ್ ಅರ್ಥ್ ಕರುನ್ ಘೆವ್ಕ್ ನಾತ್, ಹರ್ ಎಕ್ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಾಬಿ ಪ್ರವಾದ್ಯಾಚಿ ಗೊಸ್ಟಿಯಾ ಪುರಾ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ಜೆಜು ಮರುಕುಚ್ ಪಾಜೆ ಮನ್ತಲ್ಯಾಕ್ ತೆಂಕಾ ಕಾರನ್ ಗಾವ್ಕ್ ನಸ್ಲ್ಯಾರ್ಬಿ ತೆಕಾ ಜಿವಾನಿ ಮಾರುಚೆ ಮನುನ್ ಪಿಲಾತಾಕ್ಡೆ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಯಾ ಸಾರ್ಕೆ ಜೆಜುಕ್ ಹೊವ್ಚೆ ಮನುನ್ ಹೊತ್ತೆ ಬುರ್ಶೆಪಾನ್ ಸಗ್ಳೆ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾನಿಚ್ ತೆಕಾ ಕರ್‍ಲ್ಯಾನಿ ತೆಚ್ಯಾ ಮಾನಾ ತೆಕಾ ಕುರ್ಸಾ ವೈನಾ ಖಾಲ್ತಿ ಉತ್ರುನ್ ಸಮಾದಿತ್ ಥವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ಖರೆ ತೆಕಾ ದೆವಾನ್ ಮರಲ್ಯಾಕ್ನಾ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ಹೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜೆಜು ವಾಂಗ್ಡಾ ಗಲಿಲಾಯಾಕ್ನಾ ಜೆರುಜಲೆಮಾಕ್ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ಲೈ ದಿಸಾಂಚ್ಯಾ ಪಾತರ್ ಬಗ್ಲ್ಯಾನಿ, ಅತ್ತಾ ತೆನಿಚ್ ತೆಚ್ಯಾ ವಿಶಯಾತ್ ಅಮ್ಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಸಾಕ್ಷಿ ಹೊವ್ನ್ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“ದೆವಾನ್ ಅಮ್ಚ್ಯಾ ಪುರ್ವಜ್ ಲೊಕಾಕ್ನಿ ಗೊಸ್ಟ್ ದಿಲ್ಲ್ಯಾ ವಿಶಯಾಚೆ ಬರಿ ಖಬರ್ ಅಮಿ ತುಮ್ಕಾ ಸಾಂಗ್ತಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ಅಮಿ ತೆಂಚ್ಯಾ ಖಂದಾನಾಚೆ ಹೊವ್ನ್ ಹಾತ್ ದೆವಾನ್ ಜೆಜುಕ್ ಮರಲ್ಯಾಕ್ನಾ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುನ್ ಅಮ್ಚ್ಯಾ ಸಾಟ್ನಿ ಹಿ ಗೊಸ್ಟ್ ಹೊಯ್‍ ಸಾರ್ಕೆ ಕರುನ್ ಥವ್ಲಾ ಹೆಚ್ಯಾ ಬಗ್ಗೆ ದೊನ್ವೆಚ್ಯಾ ಕಿರ್ತನ್ಯಾತ್ ಅಶೆ ಲಿವಲ್ಲೆ ಹಾಯ್. “ತಿಯಾ ಮಾಜೊ ಲೆಕ್,ಆಜುಚ್ ಮಿಯಾ ತುಜೊ ಬಾಬಾ ಹೊಲಾ” ");
INSERT INTO kans_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ತನ್ನಾ ದೆವಾನ್ ಸಾಂಗ್ತಲೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್, ಮಿಯಾ ದಾವಿದಾಕ್ ಕರಲ್ಲಿ ಖರ್ಯ್ಯಾಚಿ ಗೊಸ್ಟಿಯಾ ಅನಿ ಪವಿತ್ರ್ ಹೊವ್ನ್ ಹೊತ್ತಿ ಗೊಸ್ಟಿಯಾ ದಾಕ್ವುತಾ. ");
INSERT INTO kans_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ಖರೆ ಅನಿ ಎಕಾಕ್ಡೆ ದೆವಾನ್ ಅಶೆ ಸಾಂಗ್ಲಾ, ತಿಯಾ ತುಜ್ಯಾ ಪರಿಶುದ್ದ್ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾಕ್ ಬುರ್ಶೆ ಪಾನಾತ್ ಬಗುಕ್ ಸೊಡಿನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ದಾವಿದಾನ್ ಅಪ್ಲ್ಯಾ ಜಿವ್ ಹೊತ್ತ್ಯಾ ಯೆಳಾರ್ ಫುರಾ ದೆವಾಚ್ಯಾ ಇಚ್ಚ್ಯಾಸಾರ್ಕೆ ಜಿವನ್ ಕರ್‍ಲ್ಯಾನ್, ತೆಚ್ಯಾ ಮಾನಾ ತೊ ಮರುನ್ ಗೆಲೊ ತೆಕಾ ತೆಚ್ಯಾ ಪುರ್ವಜಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಾಟಿ ಕರುನ್ ಹೊಲೆ ,ತೆಜೆ ಆಂಗ್ ಸಮಾದಿತ್ ಕುಸುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ಖರೆ ಜೆ ಕೊನಾಕ್ ತೆನಿ ಮರ್ನಾಕ್ನಾ ಝಿತ್ತೆ ಕರುನ್ ಉಟ್ವುಲಾ ತೆಜೆ ಆಂಗ್ ಕುಸುಕ್ನಾ, ");
INSERT INTO kans_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ತಸೆಹೊವ್ನ್ ಮಾಜ್ಯಾ ಭಾವಾನು ಅನಿ ಭೆನಿಯಾನು ತುಮ್ಕಾ ಜೆಜುಕ್ನಾಚ್ ಪಾಪಾಕ್ ಕ್ಷಮಾ ಗಾವ್ತಾ ಮನುನ್ ಸಾಂಗುನ್ ಹೊಲಾ ಮನ್ತಲೆ ಮಿಯಾ ತುಮ್ಕಾ ಕಳ್ವುತಾ. ");
INSERT INTO kans_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ತೆಜ್ಯಾಕ್ನಾಚ್ ವಿಶ್ವಾಸ್ ಕರಲ್ಯಾ ಹರ್ ಎಕ್ಲ್ಯಾಕ್ನಿ ಪಾಪಾಕ್ನಾ ಸುಟ್ಕಾ ಅನಿ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ವೈನಾ ಚುಕ್ದಾರಿ ಮನುನ್ ಸಾಂಗುಕ್ ಹೊಯ್ ನಸಲ್ಯಾ ಸಾರ್ಕೆ ಚುಕೆತ್ನಾ, ಸುಟ್ಕಾ ಹೊಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ತಸೆ ಹೊವ್ನ್ ಪ್ರವಾದಿಯಾನಿ ಸಾಂಗಲಿ ಥೊಡಿ ಸಂಗ್ತಿಯಾ ಖರೆ ಹೊಯ್ನಾ ಸಾರ್ಕೆ ಉಶಾರ್ಕಿನ್ ರ್‍ಹಾವಾ. ");
INSERT INTO kans_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ಹಾಸ್ತಲ್ಯಾ ಲೊಕಾನು ಅಜಾಪ್ ಹೊವ್ನಗೆತ್ ನಾಸ್ ಹೊವ್ನ್ ಜಾವಾ, ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಿನಸಲ್ಯಾ ಸಾರ್ಕೆ ಕಾಮ್ ಮಿಯಾ ಕರ್‍ತಾ, ದುಸ್ರ್ಯಾನಿ ತುಮ್ಕಾ ಸಾಂಗ್ಲ್ಯಾರ್ಬಿ ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಿನ್ಯಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸ್ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ನಾ ಭಾಯ್ರ್ ಜಾತಾನಾ ಹ್ಯಾ ಸಂಗ್ತಿಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಕಳ್ವುನ್ ಘೆವ್ನ್ ಅನಿ ಜಾಸ್ತಿಚೆ ಕಳ್ವುಕ್ ಸಾಟ್ನಿ ಫಿಡ್ಲ್ಯಾ ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ ಪರ್ತುನ್ ಯೆವ್ಚೆ ಮನುನ್ ತೆನಿ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ಬೈಟಕ್ ಸರಲ್ಲ್ಯಾ ಮಾನಾ ಲೈ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಅನಿ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತಿ ಲೊಕಾಬಿ ಥೈತ್ನಾ ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲಿ, ತನ್ನಾ ತೆಂಕಾ ದೆವಾಚ್ಯಾ ಕುರ್ಪೆತ್ ಫಿಡೆ ಜಾವ್ಕ್ ಉಮ್ಮೆದ್ ಭರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ಫಿಡ್ಲ್ಯಾ ಸಬ್ಬತ್ತಾಚ್ಯಾ ದಿಸಿ ದೆವಾಚಿ ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುಕ್ ಲೈ ಕರುನ್ ಸಗ್ಳ್ಯಾ ಶಾರಾಚಿ ಲೊಕಾಚ್ ಗೊಳಾ ಹೊವ್ನ್ ಯೆಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ಹೆ ಬಗಲ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಲೈ ಕುಶ್ಡೆಪಾನ್ ಹೊಲೆ ತೆನಿ ಪಾವ್ಲುಚಿ ಬೊಲ್ನಿಯಾ ಆಯ್ಕುನ್ ಗಾಳಿಯಾ ದಿಲ್ಯಾನಿ ಅನಿ ವಿರೊದ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ಖರೆ ಪಾವ್ಲುನ್ ಅನಿ ಬಾರ್ನಾಬಾನ್ ಧೈರೊ ಘೆವ್ನ್ ಬೊಲುನ್ ಆಮಿ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಅದ್ದಿಚ್ ದೆವಾಚಿ ಗೊಸ್ಟಿಯಾ ಬೊಲ್ಲ್ಯಾಂವ್, ಖರೆ ತುಮಿ ತೆ ಆಯ್ಕಿನಸ್ತಾನಾ ನಾಸ್ ಹೊಯ್ ನಸಲ್ಲ್ಯಾ ಜಿವಾಕ್ನಾ ಧುರ್ ಹೊಲ್ಯಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಧನಿಯಾನ್ ದಿಲ್ಲೆ ಹುಕುಮ್ ಅಶೆ ಹಾಯ್,ಮಿಯಾ ತುಕಾ ಜುದೆವ್ ನೈ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಉಜ್ವೊಡ್ ಸಾರ್ಕೊ ಕರ್‍ಲಾ, ತಿಯಾ ಜಗಾಚೊ ಆಕ್ರಿಚೊ ಯೆಳ್ ಹೊಯ್ ಪತರ್ಬಿ ರಾಕ್ವನ್ದಾರಿ ಹೊವ್ನ್ ರ್‍ಹಾಯ್ ಸಾರ್ಕೆ ಮಿಯಾ ತುಕಾ ದುಸ್ರ್ಯಾ ಲೊಕಾಕ್ನಿ ಉಜ್ವೊಡ್ ಸಾರ್ಕೊ ಕರುನ್ ಥವ್ಲಾ ಮನುನ್ ದೆವಾನ್ ಸಾಂಗ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ಹೆ ಆಯ್ಕುನ್ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ ಲೈ ಕುಶಿ ಹೊವ್ನ್ ಧನಿಯಾಚ್ಯಾ ಬರ್‍ಯಾ ಖಬ್ರೆಸಾಟ್ನಿ ಸ್ತುತಿ ಕರ್‍ಲ್ಯಾನಿ, ನಾಸ್ ಹೊಯ್ ನಸಲ್ಲ್ಯಾ ಜಿವಾಕ್ ಎಚುನ್ ಕಾಡುನ್ ಹೊಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾನಿ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ಧನಿಯಾಚಿ ಬರಿ ಖಬರ್ ತ್ಯಾ ಶಾರಾತ್ ಫುರಾ ಪಗ್ಳುನ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ಖರೆ ಜುದೆವಾನಿ ಥೈತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಘವ್ಮಾನ್ಸಾಕ್ನಿ ಅನಿ ಬಾಯ್ಕಾ ಮಾನ್ಸಾಕ್ನಿ ಝಗ್ಡ್ಯಾಕ್ ಉಟಿ ಸಾರ್ಕೆ ಕರುನ್ ಸಮಾಜ್ಯಾತ್ ಗೌರವಾನ್ ಹೊತ್ತ್ಯಾ ಬಾಯ್ಕಾ ಮಾನ್ಸಾಕ್ನಿ ಅನಿ ಉಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಧಾಡುನ್ ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಕ್ ವಿರೊದ್ ಬುರ್ಶೆ ಕರುನ್ ತೆಂಕಾ ಪ್ರಾಂತ್ಯಾಕ್ನಾ ಭಾಯ್ರ್ ಘಾಲಿ ಸಾರ್ಕೆ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ತಸೆ ಹೊವ್ನ್ ಪಾವ್ಲುನ್ ಅನಿ ಬಾರ್ನಾಬಾನ್ ತೆಂಕಾ ಎಕ್ ಹುಶ್ಯಾರ್ಕಿ ಹೊಂವ್ದಿ ಮನುನ್ ಅಪ್ಲ್ಯಾ ಪಾಂಯಾಕ್ನಿ ಲಾಗಲಿ ಧುಳ್ ಫಾಪ್ಡುನ್ ಟಾಕುನ್ ಇಕೊನಿಯಾಕ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ಖರೆ ಅಂತಿಯೊಕ್ಯಾತ್ಲಿ ದೆವಾಚಿ ಲೊಕಾ ಕುಶಿನ್ ಹೊತ್ತಿ ಅನಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ಭರುನ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸ್ ಇಕೊನಿಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಗೆಲೆ, ಹರ್ ಎಕ್ ಶಾರಾತ್ ತೆನಿ ಕರಲ್ಯಾ ಸಾರ್ಕೆಚ್ ಹಿತ್ತೆಬಿ ಜುದೆವಾಂಚ್ಯಾ ಸಿನಾಗೊತ್ ಜಾವ್ನ್ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲ್ಯಾನಿ, ಪಾವ್ಲುಚೆ ಅನಿ ಬಾರ್ನಾಬಾಸಾಚಿ ಶಿಕಾಪಾ ಆಯ್ಕುನ್ ಜುದೆವಾಂಚ್ಯಾ ಅನಿ ಗ್ರಿಕಾಂಚ್ಯಾ ಲೈ ಲೊಕಾನಿ ದೆವಾಚೆರ್ ವಿಶ್ವಾಸ್ ಥವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ಖರೆ ಜುದೆವಾಂತ್ನಿ ವಿಶ್ವಾಸ್ ಕರಿನಸ್ತಾನಾ ಹೊತ್ತ್ಯಾ ಥೊಡ್ಯಾ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ರಾಗ್ ಹೊಯ್ ಸಾರ್ಕೆ ಕರುನ್ ಭಾವಾಂಚ್ಯಾ ವಿರೊಧ್ ಹೊವ್ನ್ ಲೊಕಾಕ್ನಿ ಉಟ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ಖರೆ ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸ್ ಇಕೊನಿಯಾತ್ ಲೈ ಯೆಳಾ ಪತರ್ ರಾವ್ನ್ ಧನಿಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಧೈರ್ಯಾನ್ ಬೊಲ್ಲ್ಯಾನಿ, ಅನಿ ಧನಿಯಾನ್ ತೆಂಚ್ಯಾಕ್ನಾ ಚಮತ್ಕಾರಾಚಿ ಅನಿ ಅಜಾಪಾಚಿ ಕಾಮಾ ಕರುನ್ ಅಪ್ಲಿ ಕುರ್ಪೆಚಿ ಖಬರ್ ಘಟ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ಖರೆ ಶಾರಾತ್ಲ್ಯಾ ಲೊಕಾತ್ನಿ ಥೊಡ್ಯಾನಿ ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲಿ, ಅನಿ ಥೊಡ್ಯಾ ಲೊಕಾನಿ ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲ್ಯಾನಿ ತೆಚ್ಯಾ ಸಾಟ್ನಿ ಥೈಚ್ ದೊನ್ ತಾಂಡೆ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ಜುದೆವಾಂಚ್ಯಾ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾತ್ಲೆ ಥೊಡೆ ಅನಿ ಜುದೆವಾಂಚೆ ಥೊಢಿ ಲೊಕಾ ಅಪ್ಲ್ಯಾ ಮುಖಂಡಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಳುನ್ ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬರೆ ಚಾಲ್ವುನ್ ಘೆವ್ನ್ ಜಾಯ್‌ನಸ್ತಾನಾ ತೆಂಕಾ ಬುರ್ಶೆ ಕರುಚೆ ಮನುನ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ಹೆ ಕಳ್ವುನ್ ಘೆಟಲ್ಲ್ಯಾ ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸಾಕ್ ತ್ಯಾ ಶಾರಾತ್ನಾ ಲಿಕಾವೊನಿಯಾಚಿ ಶಾರಾ ಲುಸ್ತ್ ಅನಿ ದರ್ಬೆಕ್ ಅನಿ ತೆಚ್ಯಾ ಅಜುಭಾಜುಕ್ ಹೊತ್ತ್ಯಾ ಪ್ರಾಂತ್ಯಾಕ್ನಿ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ತೆನಿ ಥೈ ಬಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಕಳ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ಲಿಸ್ತ್ರಾ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಎಕ್ಲೊ ಜಲ್ಮಿಸೊಟ್ಟೊ ಮಾನುಸ್ ಹೊತ್ತೊ ತೆಚ್ಯಾ ಪಾಂಯಾತ್ನಿ ಬಳ್ ನತ್ತಿ, ಅನಿ ಕನ್ನಾಬಿ ಚಲಲೊಚ್ ನತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ಹ್ಯೊ ಮಾನುಸ್ ಅಪ್ನಿ ಬಸಲ್ಲ್ಯಾಕ್ನಾಚ್ ಪಾವ್ಲುಚಿ ಬೊಲ್ನಿ ಆಯ್ಕಿತ್ ಹೊತ್ತೊ, ಪಾವ್ಲುನ್ ತೆಕಾಚ್ ಬಗ್ಲ್ಯಾನ್ ದೆವ್ ಅಪ್ನಾಕ್ ಗುನ್‍ ಕರ್‍ತಾ ಮನ್ತಲೊ ವಿಶ್ವಾಸ್ ತೆಕಾ ಹೊತ್ತೊ ಪಾವ್ಲುನ್ ವಳ್ಕುನ್, ");
INSERT INTO kans_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ತೆಕಾ, “ಉಟ್; ತುಜ್ಯಾ ಪಾಯಾವೈನಿ ಇಬೆ ರ್‍ಹಾ!” ಮನುನ್ ಮೊಟ್ಯಾ ಧನಾನ್ ಸಾಂಗ್ಲ್ಯಾನ್, ತನ್ನಾಚ್ ತೊ ಮಾನುಸ್ ಹುಡುನ್ ಚಲುಕ್‍ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ಪಾವ್ಲುನ್ ಕರಲ್ಲಿ ಹಿ ಕಾಮಾ ಬಗಲಿ ಲೊಕಾ ಅಪ್ಲ್ಯಾ ಲಿಕಾವುನಿ ಮನ್ತಲ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಭಾಶೆನ್ “ದೆವಾ ಮಾನ್ಸಾಂಚೊ ರುಪ್ ಘಾಲುಘೆವ್ನ್ ಆಮ್ಚ್ಯಾ ಜಗ್ಗೊಳ್ ಉತ್ರುನ್ ಯೆಲಾತ್!” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ತ್ಯಾ ಲೊಕಾನಿ ಬಾರ್ನಾಬಾಸಾಕ್ ಜೆವುಸ್ ದೆವ್ ಮನುನ್, ಅನಿ ಮುಖ್ಯ್ ಶಿಕಾಪ್‍ಕಾರಿ ಪಾವ್ಲುಕ್ ಹೆರ್ಮ್ ದೆವ್ ಮನುನ್ ನಾವ್ ಥವ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ಜೆವುಸ್ ಮನ್ತಲ್ಯಾ ದೆವಾಚೆ ಗುಡಿ ಶಾರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಹೊತ್ತಿ, ತ್ಯಾ ಗುಡಿಚೊ ಪುಜಾರಿ ಥೊಡೆ ಬೈಲಾಚೆ ಪಾಡೆ ಅನಿ ಫುಲ್ಲಾ ಘೆವ್ನ್ ಶಾರಾಕ್ ಗುಸ್ತಲ್ಯಾ ದಡ್ಪ್ಯಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆಲ್ಲೊ ತ್ಯಾ ಪುಜಾರಿನ್ ಅನಿ ಥೈತ್ಲ್ಯಾ ಲೊಕಾನಿ ಪಾವ್ಲುಕ್, ಅನಿ ಬಾರ್ನಾಬಾಸಾಕ್ ಬಲಿ ಭೆಟ್ವುನ್ ತೆಂಕಾ ಆರಾಧಾನ್ ಕರುಚೆ ಮನುನ್ ಚಿಂತಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ಹೆ ಆಯ್ಕುಲ್ಯಾ ಬಾರ್ನಾಬಾಸ್ ಅನಿ ಪಾವ್ಲುನ್ ಅಪ್ಲಿ ಫಾಳಿಯಾ ಪಿಂಜುನ್ ಘೆವ್ನ್ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ಪಳುನ್ ಜಾವ್ನ್, ಅಶೆ ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ; ");
INSERT INTO kans_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ಲೊಕಾನು, ತುಮಿ ಹೆ ಸಗ್ಳೆ ಕಶ್ಯಾಕ್ ಕರುಲ್ಲ್ಯಾಸಿ? ಅಮಿ ದೆವಾ ನ್ಹಯ್, ಅಮಿಬಿ ತುಮ್ಚ್ಯಾ ಸಾರ್ಕಿ ಮಾನ್ಸಾ, ತುಮ್ಕಾ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಚೆ ಮನುನ್ ಅಮಿ ಹಿತ್ತೆ ಹಾತ್, ಜಿವ್ ಸ್ವರುಪಾಚ್ಯಾ ದೆವಾಕ್ಡೆ ಪರ್ತುನ್ ಯೆವಾ,ಸಮುಂದರ್ ಮಳ್ಬ್, ಜಿಮಿನ್ ಅನಿ ತ್ಯಾತುರ್ ಹೊತ್ತೆ ಹರ್ ಎಕ್‍ಬಿ ರಚಲ್ಲೊ ತೊಚ್. ");
INSERT INTO kans_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ಸರುನ್ ಗೆಲ್ಲ್ಯಾ ಯೆಳಾತ್ನಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ದೆವಾನ್ ಅಪ್ಲ್ಯಾ ಇಚ್ಚ್ಯಾ ಸಾರ್ಕೆ ಚಲುಕ್ ಸೊಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ಖರೆ ಅಪ್ನಿ ಎಕ್ಲೊಚ್ ಖರೊ ದೆವ್ ಮನ್ತಲೆ ತೆನಿ ಅಪ್ಲ್ಯಾ ಬರ್‍ಯಾ ಕಾಮಾನಿ ದಾಕ್ವುಲ್ಯಾನ್, ತೆನಿ ತುಮ್ಕಾ ಮಳ್ಬಕ್ನಾ ಪಾವ್ಸ್ ದಿವ್ನ್ ಜೆವ್ನಾ ಸಾಟ್ನಿ ಸಮಾ ಎಳಾರ್ ಪಿಕ್ ದಿವ್ನ್ ತುಮ್ಚ್ಯಾ ಮನಾಕ್ನಿ ಉಮ್ಮೆದಿನ್ ಭರಿಸಾರ್ಕೆ ಕರ್‍ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ಪಾವ್ಲುನ್ ಅನಿ ಬಾರ್ನಾಬಾಸಾನ್ ಯೆವ್ಡೆ ಸಗ್ಳ್ಯೆ ಸಾಂಗ್ಲಾರ್ಬಿ ಬಲಿ ಭೆಟ್ವುನ್ ಆರಾದನ್ ಕರುಚೆ ಮನುನ್ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಡ್ವುಕ್ ಲೈ ತರಾಸ್ ಹೊಲೊ . ");
INSERT INTO kans_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ತೆಚ್ಯಾ ಮಾನಾ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಅಂತಿಯೊಕ್ಯ್ ಅನಿ ಇಕೊನಿಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಂಚ್ಯಾಕ್ನಾ ಪಾವ್ಲುಕ್ ವಿರೊದ್ ಹೊವ್ನ್ ಯೆವ್ನ್ ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಳುನ್ ಪಾವ್ಲುಕ್ ಗುಂಡೆ ಮಾರುನ್ ತೊ ಮರ್ಲೊ ಮನುನ್ ಚಿಂತುನ್ ಶಾರಾತ್ನಾ ತೆಕಾ ವಡುನ್ ನೆವ್ನ್ ಭಾಯ್ರ್ ಟಾಕ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ಖರೆ, ಜೆಜುಚಿ ಶಿಸಾ ಲೊಕಾ ತೆಚ್ಯಾ ಅಜುಭಾಜುನ್ ಗೊಳಾ ಹೊವ್ನ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ತೊ ಉಟುನ್ ಶಾರಾತ್ ಗೆಲೊ, ದುಸ್ರೆಂದಿಸಿ ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸ್ ದರ್ಬೆ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸ್ ದರ್ಬೆ ಶಾರಾತ್‍ಬಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲ್ಯಾನಿ, ಲೈ ಲೊಕಾ ಜೆಜುಚಿ ಶಿಸಾಹೊಲಿ ತೆನಿ ದೊಗಾ ಲಿಸ್ತ್ರಾ, ಇಕೊನಿಯಾ ಅನಿ ಅಂತಿಯೊಕ್ಯ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ನಿ ಪರ್ತುನ್ ಗೆಲೆ, ");
INSERT INTO kans_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ಜೆಜುಚ್ಯಾ ಶಿಸಾಕ್ನಿ ವಿಶ್ವಾಸಾತ್ ಬಳ್ ಹಾನುನ್ ಘಟ್ ಹೊವ್ನ್ ರ್‍ಹಾಯ್ ಸಾರ್ಕೆ ಉಮ್ಮೆದ್ ಭರ್‍ಲ್ಯಾನಿ, ಅನಿ ಅಮಿ ದೆವಾಚ್ಯಾ ರಾಜಾಕ್ ಜಾವ್ಚೆ ಹೊಲ್ಯಾರ್ ಲೈ ತರಾಸಾನಿ ಜಾವ್ಚೆ ಹೊತಾ ಮನುನ್ ಶಿಕಾಪಾ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ಪಾವ್ಲುನ್ ಅನಿ ಬಾರ್ನಾಬಾಸಾನ್ ಹರ್ ಎಕ್ ತಾಂಡ್ಯಾಕ್ಬಿ ಎಕ್‍ ಎಕ್ ಮುಖಂಡ್ ಎಚ್ಲ್ಯಾನಿ ಉಪಾಸ್ ರ್ಹಾವ್ನ್ ಮಾಗ್ನಿ ಕರುನ್ ಅಪ್ನಿ ವಿಶ್ವಾಸ್ ಥವಲ್ಯಾ ಧನಿಯಾಕ್ ಒಪ್ಸುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸಾಕ್ ಪಿಸಿದಿಯಾ ಗಾಂವಾತ್ನಾ ಪಾಂಫಿಲಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ ಯೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ತೆನಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಪೆರ್ಗೆ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಶಿಕಾಪಾ ಕರುನ್, ಥೈತ್ನಾ ಅತ್ತಾಲಿಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ತೆಚ್ಯಾ ಮಾನಾ ತೆನಿ ಥೈತ್ನಾ ಸಿರಿಯಾತ್ಲ್ಯಾ ಅಂತಿಯೊಕ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಸಮುಂದರಾಚ್ಯಾ ವಾಟೆನಿ ಗೆಲೆ, ಅತ್ತಾ ಪಾತರ್ ಕರುನ್ ಸಾರಲ್ಲ್ಯಾ ಸೆವಾಚ್ಯಾ ಕಾಮಾಕ್ನಿ ದೆವಾಚ್ಯಾ ಕುರ್ಪೆಚ್ಯಾ ಹಾತಿತ್ ಒಪ್ಸುನ್ ದಿವ್ನ್ ಧಾಡಲ್ಲೆ ಹ್ಯಾ ಶಾರಾತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿಚ್. ");
INSERT INTO kans_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸ್ ಹಿತ್ತೆ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಸಗ್ಳೆ ಗೊಳಾ ಕರುನ್, ದೆವಾನ್ ಅಪ್ನಾ ವಾಂಗ್ಡಾ ಕರಲ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಕಾಮಾಂಚ್ಯಾ ವಿಶಯಾತ್ ತೆಂಕಾ ಕಳ್ವುಲ್ಯಾನಿ, ಅನಿ “ಜುದೆವಾಂಚೆ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾನಿಬಿ ವಿಶ್ವಾಸ್‍ ಕರಿಸಾರ್ಕೆ ದೆವಾನ್ ದಾರಾ ಉಗಡ್ಲಾ!” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ತೆನಿ ಅಂತಿಯೊಕಾಕ್ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ದೆವಾನ್ ದುಸ್ರ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಪ್ಲ್ಯಾ ವಿಶ್ವಾಸಾತ್ ಯೆವ್ಕ್ ವಾಟ್ ಕರುನ್ ದಿಲ್ಯಾನ್ ಮನ್ತಲೆ ದಾಕ್ವುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ಮಾನಾ ಉಲ್ಲಿ ಲೊಕಾ ಜುದೆಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ನಾ ಅಂತಿಯೊಕ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಯೆಲ್ಲಿ, ತುಮಿ ಸುನ್ನತ್ ಕರುನ್ ಘೆಯ್ನಸ್ಲ್ಯಾರ್ ತುಮ್ಕಾ ಸುಟ್ಕಾ ಹೊಯ್ನಾ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾತ್ ಸಾರ್ಕೆ ಸುನ್ನತ್ ಕರುನ್ ಘೆವ್ಚೆ ಮನುನ್ ಸಾಂಗಲ್ಲೆ ಹಾಯ್ ಮನುನ್ ತೆನಿ ಜುದೆವ್ ನ್ಹಯ್ ಅಸಲ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಶಿಕಾಪ್ ಕರುಲಾಗ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ಪಾವ್ಲುನ್ ಅನಿ ಬಾರ್ನಾಬಾಸಾನ್ ಹ್ಯಾ ಶಿಕಾಪಾಕ್ನಿ ಅಪ್ಲೊ ವಿರೊದ್ ದಾಕ್ವುನ್ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ವಾದ್ ಕರ್‍ಲ್ಯಾನಿ, ಹ್ಯಾ ನಮುನ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಅಪೊಸ್ತಲಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಅನಿ ಪುರ್ವಜ್ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಚರ್ಚಾ ಕರುಕ್ ಸಾಟ್ನಿ ಪಾವ್ಲುಕ್ ಅನಿ ಬಾರ್ನಾಬಾಸಾಕ್ ಹುರಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜೆರುಜಲೆಮಾಕ್ ಧಾಡುಚೆ ಮನುನ್ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾನಿ ಚಿಂತ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ತಸೆಚ್ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾನಿ ಹೆಂಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ, ತೆನಿ ಪೊಯಿನಿಕ್ಯಾ ಅನಿ ಸಮರ್ಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ವಾಟೆನ್ ಗೆಲೆ, ತೆನಿ ಹ್ಯಾ ಗಾಂವಾತ್ನಿ ಜುದೆವಾಂಚಿ ನ್ಹಯ್ ಹೊಲ್ಲಿ ಲೊಕಾಬಿ ದೆವಾಕ್ಡೆ ಪರ್ತುನ್ ಯೆಲ್ಲ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗ್ಲ್ಯಾನಿ, ಹೆ ಆಯ್ಕುನ್ ಭಾವಾಕ್ನಿಬಿ ಲೈ ಕುಶಿ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ಪಾವ್ಲು ಬಾರ್ನಾಬಾಸ್ ಅನಿ ಉಲ್ಲಿ ಲೊಕಾ ಜೆರುಜಲೆಮಾಕ್ ಅಪೊಸ್ತಲಾನಿ, ಜಾಂನ್ತ್ಯಾ ಲೊಕಾನಿ ಅನಿ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾನಿ ತೆಂಕಾ ಸ್ವಾಗತ್ ಕರ್‍ಲ್ಯಾನಿ, ತೆನಿ ಸಗ್ಳ್ಯಾನಿ ದೆವಾನ್ ಅಪ್ಲ್ಯಾ ವಾಂಗ್ಡಾ ಕರಲ್ಲ್ಯಾ ಬರ್‍ಯಾ ಕಾಮಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಥೈತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ಖರೆ ದೆವಾಚ್ಯಾ ಲೊಕಾಂತ್ಲಿ ಥೊಡಿ ಲೊಕಾ ಫಾರಿಜೆವಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚಿ ಲೊಕಾ ಹೊಲ್ಲಿ ಅನಿ ತೆನಿ ಉಟುನ್ ಇಬೆ ರ್‍ಹಾವ್ನ್ “ಜುದೆವಾಂಚಿ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಸುನ್ನತ್ ಕರುನ್ ಘೆವ್ಚೆ ಅನಿ ತೆನಿ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾಕ್ ಮಾನುಚೆ ಮನುನ್ ಅಮಿ ತೆಂಕಾ ಸಾಂಗುಚೆ!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ಮಾನಾ, ಅಪೊಸ್ತಲಾ ಅನಿ ಜಾಂನ್ತಿ ಲೊಕಾ ಹ್ಯಾ ಸಮಸ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಚರ್ಚಾ ಕರುಕ್ ಮನುನ್ ಗೊಳಾ ಹೊವ್ನ್ ಯೆಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ಲೈ ಯೆಳ್ ಚರ್ಚಾ ಕರುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ, ಪೆದ್ರುನ್ ಉಟುನ್ ಇಬೆ ರಾವ್ನ್ ತೆಂಕಾ , ಮಾಜ್ಯಾ ಭಾವಾನು ಅನಿ ಭೆನಿಯಾನು, ಜುದೆವಾಂಚೆ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗುಕ್ ಮನುನ್ ತುಮ್ಚ್ಯಾತ್ನಾ ಮಾಕಾ ದೆವಾನ್ ಲೈ ದಿಸಾಂಚ್ಯಾ ಅದ್ದಿಚ್ ಎಚುನ್ ಘೆಟ್ಲ್ಯಾನ್, ಅನಿ ತೆನಿ ಮಾಜಿ ಶಿಕಾಪಾ ಆಯ್ಕುನ್ ದೆವಾಚೆರ್ ವಿಶ್ವಾಸ್ ಥವ್ಲ್ಯಾನಿ ಮನ್ತಲೆ ತುಮ್ಕಾಚ್ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚಿ ಯೆವ್ಜನಿಯಾಬಿ ಗೊತ್ತ್ ಹೊತ್ತ್ಯಾ ದೆವಾನ್ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಪ್ಲಿ ಲೊಕಾ ಮನುನ್ ಸಾಕ್ಷಿ ದಿಲ್ಯಾನ್. ದೆವಾನ್ ಅಮ್ಕಾ ದಿಲ್ಲ್ಯಾ ಸಾರ್ಕೆಚ್ ತೆಂಕಾಬಿ ಪವಿತ್ರ್ ಆತ್ಮೊ ದಿವ್ನ್ ಹೆ ಖರೆ ಮನುನ್ ದಾಕ್ವುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ದೆವಾಚ್ಯಾ ನದ್ರೆತ್ ಅಮ್ಕಾ ಅನಿ ತೆಂಕಾ ಕಸ್ಲೊ ಫರಕ್ ಬಿ ನಾ, ತೆನಿ ವಿಶ್ವಾಸ್ ಕರಲ್ಲ್ಯಾ ಸಾಟ್ನಿ ದೆವಾನ್ ತೆಂಚಿ ಪಾಪಾ‌ ಮಾಪಿ ಕರ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ಅಶೆ ರಾತಾನಾ, ಜುದೆವಾಂಚೆ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಭಾವಾಂಚ್ಯಾ ಖಾಂಜ್ಯಾರ್ ಲೈ ಜೆಡ್ ಹೊತ್ತೆ ವಜ್ಜೆ ಕಶ್ಯಾಕ್ ವಾವ್ತ್ಯಾಸಿ, ತುಮಿ ದೆವಾಕ್ ರಾಗ್ ಯೆಯ್ ಸಾರ್ಕೆ ಕರ್ತ್ಯಾಶಿ ಕಾಯ್? ಅಮ್ಕಾ ಹೊಂವ್ದಿತ್, ಅಮ್ಚ್ಯಾ ವಾಡ್ ವಡ್ಲಾಕ್ನಿ ಹೊಂವ್ದಿತ್ ಹೆ ವಜ್ಜೆ ವಾವಿ ಸಾರ್ಕೆ ಬಳ್ ನತ್ತೊ!. ");
INSERT INTO kans_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ತಸೆ ಹೊವ್ನ್ ಅಮ್ಕಾ ಹೊಂವ್ದಿ ಹೆಂಕಾ ಹೊಂವ್ದಿ ರಾಕ್ವನ್ ಹೊತಲಿ ಧನಿಯಾ ಜೆಜುಚ್ಯಾ ಕುರ್ಪೆನುಚ್ ಮನುನ್ ಅಮಿ ವಿಶ್ವಾಸ್ ಕರ್ತಾಂವ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ತೆನಿ ಸಾಂಗುಕ್ ಲಾಗಲ್ಲೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾ ಸಗ್ಳ್ಯಾ ತಾಂಡ್ಯಾಚಿ ಲೊಕಾ ಶಾಂತ್ ಹೊಲಿ, ತೆನಿ ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾಕ್ನಿ ಕಾನ್ ದಿಲ್ಯಾನಿ, ಜುದೆವಾಂಚೆ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಮದ್ದಿ ದೆವಾನ್ ಅಪ್ಲ್ಯಾಂಚಾಕ್ನಾ ಕರಲ್ಲಿ ಆಜಾಪಾಚಿ ಅನಿ ಚಮತ್ಕಾರಾಚ್ಯಾ ಕಾಮಾಂಚ್ಯಾ ವಿಶಯಾತ್ ತೆಂಕಾ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ಮಾನಾ ತೆನಿ ಬೊಲುನ್ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಜಾಕೊಬಾನ್, “ಮಾಜ್ಯಾ ಭಾವಾನು, ಭೆನಿಯಾನು ಮಿಯಾ ಸಾಂಗ್ತಲೆ ಆಯ್ಕಾ, ");
INSERT INTO kans_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ದೆವಾನ್ ಜುದೆವಾಂಚೆ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಪ್ಲಿ ಕಾಳ್ಜಿ ಕಸಿ ಕರ್ಲಾ ಮನ್ತಲೆ ಸಿಮಾವಾನ್ ಅಮ್ಕಾ ಕಳ್ವುಲ್ಯಾನ್ ದೆವಾನ್ ಜುದೆವಾಂಚಿ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಪ್ಲಿ ಲೊಕಾ ಕರುನ್ ಘೆಟಲ್ಲೆ ಹೆಚ್ ಪೈಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ಪವಿತ್ರ್ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲ್ಯಾ ಸಾರ್ಕೆ; ಪ್ರವಾದ್ಯಾಂಚಿ ಗೊಸ್ಟಿಯಾಬಿ ಹೆಕಾ ಒಪ್ಪ್ ಹೊವ್ನ್ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ಹೆ ಹೊಲ್ಲ್ಯಾ ಮಾನಾ ಮಿಯಾ ಫಾಟಿ ಪರ್ತುನ್ ಯೆತಾ ಅನಿ ತೆಚೊ ರಾಜ್ ಪರ್ತುನ್ ಬಾಂದ್ತಾ, ಪಾಡ್ವುನ್ ಹೊಲ್ಲ್ಯಾ ರಾಜಾಚೆ ತುಕ್ಡೆ ಪರ್ತುನ್ ಭಾಂದ್ತಾ ಅನಿ ತೆ ಘಟ್ ಕರ್‍ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ಹುರಲ್ಲಿ ಲೊಕಾ ಧನಿಯಾಕ್ಡೆ ಯೆತಾತ್, ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲಿ ಲೊಕಾ ಮಾಕಾ ವಳಕ್ತಾತ್ ಮನುನ್ ಹೆ ಸಗ್ಳೆ ಧನಿ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ಲೈ ಅದ್ದಿಚ್ಯಾನುಚ್ ಹಿ ಸಗ್ಳ್ಯಿ ಕಾಮಾ ಕಳ್ವುನ್ ಹೊಲಾತ್”. ");
INSERT INTO kans_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ತಸೆ ಹೊವ್ನ್ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ದೆವಾಕ್ಡೆ ಪರ್ತುನ್ ಯೆಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಮಿ ತರಾಸ್ ದಿತಲೆ ನಕ್ಕೊ, ಹಿ ಮಾಜೆ ಸಲಹಾ. ");
INSERT INTO kans_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ತೆಚ್ಯಾ ಬದ್ಲಾಕ್ ಅಮಿ ತೆಂಕಾ ಎಕ್ ಚಿಟ್ ಲಿವ್ನ್ ಹಿ ವಿಶಯಾ ಕಳ್ವುಂವಾ, ಮುರ್ತಿಯಾಕ್ನಿ ಬಲಿ ಭೆಟ್ವಲ್ಲೆ ಖಾನ್ ಖಾವ್ನಕಾಸಿ ಹೆ ಖಾನ್ ಪವಿತ್ರ್ ನ್ಹಯ್, ಕಸ್ಲೊಬಿ ಲೈಂಗಿಕ್ ಪಾಪ್ ಕರುನಕಾಸಿ ಗಳೊ ಚಿರ್ಡುನ್ ಜಿವ್ ಕಾಡಲ್ಲ್ಯಾ ಜನಾವರಾಂಚೆ ಮಾಸ್ ನಾತರ್ ರಗಾತ್ ಖಾವ್ನಕಾಸಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚೆ ಪುಸ್ತಕ್ ಶಿಕಾಪ್ ಕರ್‍ತಲಿ ಲೊಕಾ ಹರ್ ಎಕ್ ಶಾರಾತ್ಬಿ ಹಾತ್, ಲೈ ವರ್ಸಾಂತ್ನಾ ಹರ್ ಎಕ್ ಆರಾಮ್ ಕರ್‍ತಲ್ಯಾ ದಿಸಾ ದಿಸಿ ಮೊಯ್ಜೆಚಿ ಕರಾರಾ ವಾಚುನ್ ಹೊತ್ಯಾತ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ಅಪೊಸ್ತಲಾನಿ, ಜಾಂನ್ತ್ಯಾ ಲೊಕಾನಿ ಅನಿ ಸಗ್ಳ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾನಿ ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಥೊಡ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಂತಿಯೊಕಾಕ್ ಧಾಡುಚೆ ಮನುನ್ ಚಿಂತ್ಲ್ಯಾನಿ, ಅಪ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಎಚುನ್ ಘೆವ್ಚೆ ಮನುನ್ ನಿರ್ಧಾರ್ ಕರ್‍ಲ್ಯಾನಿ, ತೆನಿ ಬಾರ್ಸಬ್ ಮನ್ತಲ್ಯಾ ಜುದಾಕ್ ಅನಿ ಸಿಲಾಸ್ ಮನ್ತಲ್ಯಾಕ್ ಎಚುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ಹೆನಿ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ ಪ್ರಮುಖ್ ಹೊವ್ನ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾನಿ ಹೆಂಚ್ಯಾ ಹಾತಿತ್ ಚಿಟ್ ದಿವ್ನ್ ಧಾಡ್ಲ್ಯಾನಿ, ತ್ಯಾ ಚಿಟಿತ್ ಅಶೆ ಲಿವಲ್ಲೆ ಹೊತ್ತೆ; ಅಂತಿಯೊಕ್ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್, ಅನಿ ಸಿರಿಯ, ಸಿಲಿಸಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ನಿ ರ್‍ಹಾತಲ್ಯಾ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಭಾವಾಕ್ನಿ ಅನಿ ಭೆನಿಯಾಕ್ನಿ ಸಗ್ಳಿ ತುಮ್ಚಿ ಭಾವಾ ಹೊವ್ನ್ ಹೊತ್ತಿ, ಅಪೊಸ್ತಲಾ ಅನಿ ಜಾಂನ್ತ್ಯಿ ಲೊಕಾ ಕರ್‍ತಲೊ ನಮಸ್ಕಾರ್, ಪ್ರೆಮಾಚ್ಯಾ ಭಾವಾನು, ");
INSERT INTO kans_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ಅಮ್ಚ್ಯಾ ತಾಂಡ್ಯಾತ್ನಾ ತುಮ್ಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆಲ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಭಾವಾನಿ ಉಲ್ಲಿ ಸಂಗ್ತಿಯಾ ಸಾಂಗುನ್ ತುಮ್ಕಾ ತರಾಸ್ ಹೊಯ್ ಸಾರ್ಕೆ ಕರುನ್ ತುಮ್ಚ್ಯಾತ್ ಗೊಂದಳ್ ಕರ್‍ಲ್ಯಾನಿ ಮನ್ತಲಿ ಖಬರ್ ಅಮ್ಕಾ ಗಾವ್ಲಾ, ಖರೆ ತಸೆ ಕರಾ ಮನುನ್ ಅಮಿ ತೆಂಕಾ ಸಾಂಗುಕ್ ನತ್ತಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ತಸೆ ಹೊವ್ನ್, ಅಮಿ ಸಗ್ಳ್ಯಾನಿ ಎಕುಚ್ ಮನಾನ್ ಉಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಎಚುನ್ ಕಾಡುನ್ ತುಮ್ಚ್ಯಾಕ್ಡೆ ಧಾಡುಚೆ ಮನುನ್ ಚಿಂತ್ಲ್ಯಾಂವ್, ಅಮ್ಚೊ ಪ್ರೆಮಾಚೊ ಭಾವ್ ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ತೆನಿ ಯೆವ್ಕ್ ಲಾಗ್ಲಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ಬಾರ್ನಾಬಾಸ್ ಅನಿ ಪಾವ್ಲುನ್ ಅಮ್ಚೊ ಧನಿಯಾ ಜೆಜುಕ್ರಿಸ್ತಾಚ್ಯಾ ಸೆವಾ ಸಾಟ್ನಿ ಅಪ್ಲಿ ಜಿವನ್ ಒಪ್ಸುನ್ ದಿಲಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ತಸೆ ಹೊವ್ನ್, ಅಮಿ ಜುದಾಕ್ ಅನಿ ಸಿಲಾಸಾಕ್ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಧಾಡುನ್ ದಿಲಾಂವ್, ಅಮಿ ಲಿವಲ್ಲಿ ಸಂಗ್ತಿಯಾ ತೆನಿ ತುಮ್ಕಾ ಸಾಂಗ್ತಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ತುಮ್ಕಾ ಅನಿಬಿ ಲೈ ವಜ್ಜೆ ರ್‍ಹಾವ್ಚೆ ನ್ಹಯ್ ಮನ್ತಲೊ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚೊ ನಿರ್ದಾರ್, ತೆಕಾ ಅಮಿ ಒಪ್ಸುನ್ ಘೆಟ್ಲಾತ್ ತುಮಿ ಹಿ ಕಾಮಾ ಯೆವ್ಡಿಚ್ ಮಾನುಚೆ. ");
INSERT INTO kans_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ಮುರ್ತಿಯಾಕ್ನಿ ಭೆಟ್ವಲ್ಲೊ ಖಾನ್ ಖಾವ್ನಕಾಸಿ, ಅನಿ ರಗಾತ್ ಖಾವ್ನಕಾಸಿ, ಗಳೊ ಚಿರ್ಡುನ್ ಜಿವ್ ಕಾಡಲ್ಲ್ಯಾ ಜನಾವರಾಂಚೆ ಮಾಸ್ ಖಾವ್ನಕಾಸಿ, ಕಸ್ಲೊಬಿ ಅನೈತಿಕ್ ಅನಿ ಲೈಂಗಿಕ್ ಪಾಪ್ ಕರುನಕಾಸಿ, ತುಮಿ ಹ್ಯಾತುರ್ನ್ನಾ ಧುರ್ ರ್‍ಹಾಲ್ಯಾರ್ ತುಮ್ಕಾ ಬರೆ ಹೊತಾ ಅನಿ ತುಮ್ಕಾ ಬರೆಚ್ ಹೊಂವ್ದಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ತಸೆ ಹೊವ್ನ್, ಪಾವ್ಲು, ಬಾರ್ನಾಬಾಸ್, ಜುದ್ ಅನಿ ಸಿಲಾಸ್ ಜೆರುಜಲೆಮಾತ್ನಾ ಜಾವ್ಕ್ ಲಾಗ್ಲೆ, ತೆನಿ ಅಂತಿಯೊಕಾಕ್ ಜಾವ್ನ್ ಥೈತ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಮಿಳ್ವುನ್ ತೆಂಕಾ ಹಿ ಚಿಟ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ದೆವಾಚ್ಯಾ ಲೊಕಾನಿ ಹೆ ವಾಚ್ಲ್ಯಾನಿ, ಅನಿ ತ್ಯಾ ಚಿಟಿತ್ ಹೊತ್ತಿ ಉಮ್ಮೆದಿಚಿ ಖಬರ್ ಆಯ್ಕುನ್ ಕುಶಿ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ಜುದ್ ಅನಿ ಸಿಲಾಸ್ ಮನ್ತಲೆ ಪ್ರವಾದಿ ಹೊವ್ನ್ ಹೊತ್ತೆ, ತೆನಿ ಭಾವಾಕ್ನಿ ಅನಿ ಭೆನಿಯಾಕ್ನಿ ಲೈ ಸಂಗ್ತಿಯಾ ಸಾಂಗುನ್ ಉಮ್ಮೆದ್ ಭರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ಜುದ್ ಅನಿ ಸಿಲಾಸ್ ಥೈಚ್ ರಾವ್ನ್, ಭಾವಾ ಅನಿ ಭೆನಿಯಾನಿ ಸಮಾಧಾನಾಚೊ ಆಶಿರ್ವಾದ್ ದಿವ್ನ್ ಧಾಡ್ಲ್ಯಾನಿ ಅನಿ ತೆನಿ ತೆಂಕಾ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾಂಚ್ಯಾಕ್ಡೆ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ಖರೆ ಸಿಲಾಸಾನ್ ಥೈ ರ್‍ಹಾವ್ಚೆ ಮನುನ್ ನಿರ್ಧಾರ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ಪಾವ್ಲು ಅನಿ ಬಾರ್ನಾಬಾಸ್ ಅಂತಿಯೊಕಾತ್ ರ್‍ಹಾವ್ನ್, ಹುರಲ್ಲ್ಯಾ ಲೈ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಳುನ್ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಪರ್ಗಟ್ ಕರ್‍ಲ್ಯಾನಿ ಅನಿ ಧನಿಯಾಚೆ ಶಿಕಾಪ್ ಲೊಕಾಕ್ನಿ ಕಳ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ಉಲ್ಲಿ ದಿಸಾ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಪಾವ್ಲುನ್ ಬಾರ್ನಾಬಾಕ್, ಅಮಿ ದೆವಾಚಿ ಗೊಸ್ಟಿಯಾ ಸಾಂಗಲ್ಲ್ಯಾ ಲೈ ಶಾರಾತ್ನಿ ಭಾವಾಕ್ನಿ ಅನಿ ಭೆನಿಯಾಕ್ನಿ ಭೆಟುನ್ ತೆನಿ ಕಶೆ ಹಾತ್ ಮನುನ್ ಬಗುನ್ ಯೆಂವ್ವಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ಮಾರ್ಕ್ ಮನ್ತಲ್ಯಾ ಜುವಾಂವಾಕ್ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಲ್ವುನ್ ನ್ಹೆವ್ಚೆ ಮನುನ್ ಬಾರ್ನಾಬಾಸಾನ್ ಮನ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ಖರೆ ತೆನಿ ಅದ್ದಿ ಜಾವ್ನಗೆತ್ ರ್‍ಹಾತಾನಾ ಮಾರ್ಕ್ ಮನ್ತಲ್ಯಾ ಜುವಾಂವಾನ್ ತೆಂಕಾ ಪಾಂಫಿಲಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಕ್ಡೆ ಸೊಡುನ್ ಗೆಲ್ಯಾನ್, ತೊ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಸೆವಾ ಕರುಕ್ ಫಿಡೆ ಯೆವ್ಕ್ ನಾ, ತಸೆ ಹೊವ್ನ್ ತೆಕಾ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಜಾತಲೊ ಪಾವ್ಲುಕ್ ಮನ್ ನತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ಹೆಚ್ಯಾ ವಿಶಯಾತ್ ಪಾವ್ಲುಕ್ ಅನಿ ಬಾರ್ನಾಬಾಸಾಕ್ ಝಗ್ಡೊ ಹೊಲೊ, ತೆನಿ ಎಗ್ಳೆ ಹೊವ್ನ್ ದುಸ್ರ್ಯಾ ವಾಟಾನಿ ಗೆಲೆ, ಬಾರ್ನಾಬಾಸ್ ಮಾರ್ಕಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಢೊನಾತ್ನಾ ಸೈಪ್ರಸಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ಪಾವ್ಲುನ್ ಅಪ್ನಾ ವಾಂಗ್ಡಾ ಸಿಲಾಸ್ ಮನ್ತಲ್ಯಾಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್, ಅಂತಿಯೊಕ್ಯಾತ್ಲಾ ಭಾವಾನಿ ಪಾವ್ಲುಕ್ ಧನಿಯಾಚ್ಯಾ ಕುರ್ಪೆಚ್ಯಾ ಹಾತಿತ್ ಒಪ್ಸುನ್ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ತೆನಿ ಸಿರಿಯಾ ಅನಿ ಸಿಲಿಸಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ನಾ ದಾಟುನ್ ಜಾವನ್ಗೆತ್ ಥೈತ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ನಿ ಲೈ ಘಟ್ ಕರ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ಪಾವ್ಲು ದರ್ಬೆ ಅನಿ ಲಿಸ್ರ್ತಿ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ನಿ ಗೆಲೊ ಥೈ ತಿಮೊಥಿ ಮನ್ತಲೊ ಎಕ್ ಕ್ರಿಸ್ತಾಂವ್ ಹೊತ್ತೊ, ತೆಚೊ ಬಾಬಾ ಗ್ರಿಕ್ ಭಾಶೆಚೊ ಮಾನುಸ್ ಹೊಲ್ಲೊ, ಅನಿ ಬಾಯ್ ಜುದೆವಾಂಚಿ ವಿಶ್ವಾಸಿ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ಲಿಸ್ರ್ತಿಅನಿ ಇಕೊನಿಯಾ ಶಾರಾತ್ಲಿ ವಿಶ್ವಾಸಿ ಲೊಕಾ ತಿಮೊಥಿಕ್ ಮಾನ್ ದಿಯ್ತ್, ಅನಿ ತೆಚ್ಯಾ ವಿಶಯಾತ್ ಬರೆಚ್ ಸಾಂಗಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ಪಾವ್ಲುನ್ ತಿಮೊಥಿಕ್ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಘೆವ್ನ್ ಜಾವ್ಚೆ ಮನುನ್ ಆಸ್ಯಾ ಕರ್‍ಲ್ಯಾನ್, ಖರೆ ತ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ತೊ ಗ್ರಿಕಾಂಚೊ ಮನ್ತಲೆ ಗೊತ್ತ್ ಹೊತ್ತೆ ತಸೆ ಹೊವ್ನ್, ತಿಮೊಥಿಕ್ ಸುನ್ನತ್ ಕರಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ತೆಚ್ಯಾ ಮಾನಾ ಪಾವ್ಲು ಅನಿ ತೆಚಿ ವಾಂಗ್ಡಿಯಾ ದುಸ್ರ್ಯಾ ಶಾರಾಂತ್ನಾ ಜಾವ್ಕ್ ಲಾಗಲ್ಲೆ ಜೆರುಜಲೆಮಾತ್ಲ್ಯಾ ವಿಸ್ವಾಸಿ ಲೊಕಾಕ್ನಿ ಅಪೊಸ್ತಲಾಂಚಿ ಅನಿ ಜಾಂನ್ತ್ಯಾಂಚಿ ನೆಮಾ ಅನಿ ತಿರ್ಮಾನಾ ಸಾಂಗುನ್ ತೆಂಕಾ ಮಾನುನ್ ಘೆವ್ನ್ ರಾವ್ಚೆ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ತಸೆ ಹೊವ್ನ್, ದಿಸಾಂದಿಸ್ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ನಿ ವಿಶ್ವಾಸ್ ಅನಿ ತೆಂಚೊ ಅಂಕೊ ವಾಡುಕ್ ಲಾಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ಪಾವ್ಲು ಅನಿ ತೆಚೆ ವಾಂಗ್ಡಿ ಪ್ರೆಮಾನಿ ಹೊತ್ತೆ,, ಪಿರ್ಗಿಯಾ ಅನಿ ಗಲ್ಯಾತ್ ಮನ್ತಲ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ನಾ ಗೆಲೆ, ಅಸಿಯಾ ಸಿಮೆತ್ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಕಳ್ವುಚೆ ಮನುನ್ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್‍ ತೆಂಕಾ ಅಡ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ಪಾವ್ಲು ಅನಿ ತಿಮೊಥಿ ಮಿಸಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಗೆಲೆ, ತೆನಿ ಬಿಥಿನಿಯಾ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಜಾವ್ಚೆ ಮನುನ್ ಹೊತ್ತೆ, ಖರೆ ಜೆಜುಚ್ಯಾ ಆತ್ಮ್ಯಾನ್ ತೆಂಕಾ ಥೈ ಜಾಯ್ನಾ ಸಾರ್ಕೆ ಅಡ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ತಸೆ ಹೊವ್ನ್, ತೆನಿ ಮಿಸಿಯಾ ಗಾಂವಾತ್ನಾ ದಾಟುನ್ ಸಿದಾ ತ್ರೊವಾಸ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ತ್ಯಾ ದಿಸಾ ರಾತ್ತಿನ್ ಪಾವ್ಲುಕ್ ಎಕ್ ದರ್ಶನ್ ದಿಸ್ಲೆ, ತ್ಯಾತುರ್ ಮೆಸೆದೊನಿಯಾ ಗಾಂವಾತ್ನಾ ಯೆಲ್ಲೊ ಎಕ್ ಮಾನುಸ್ ಥೈ ಇಬೆ ರಾವ್ನ್ ಮೆಸೆದೊನಿಯಾಕ್ ಯೆವ್ನ್ ಮಾಕಾ ಮಜ್ಜತ್ ಕರ್ ಮನುನ್ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ಪಾವ್ಲುನ್ ತೆ ದರ್ಶನ್ ಬಗಲ್ಯಾ ತನ್ನಾ ಥೈತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಬರಿ ಖಬರ್ ಕಳ್ವುಕ್ ಸಾಟ್ನಿ ದೆವಾನ್ ಅಮ್ಕಾ ಬಲ್ವುಲಾ ಮನುನ್ ಅರ್ಥ್ ಕರುನ್ ಘೆವ್ನ್ ಮೆಸೆದೊನಿಯಾಕ್ ಜಾವ್ಕ್ ಅಮಿ ತಯಾರ್ ಹೊತ್ತಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ದುಸ್ರಾ ದಿಸಿ ಅಮಿ ತ್ರೊವಾಕ್ನಾ ಢೊನಿತ್ ಜಾವ್ಕ್ ಸಮೊಥ್ರ್ ಮನ್ತಲ್ಯಾ ದ್ವಿಪಾಕ್ ಯೆವ್ನ್ ನೆಯಪೊಲಿಸ್ ಶಾರಾಕ್ ಜಾವ್ನ್, ");
INSERT INTO kans_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ಥೈತ್ನಾ ಫಿಲಿಪ್ಪಿ ಪ್ರಾಂತ್ಯಾತ್ ಗೆಲಾಂವ್, ತೆ ಮೆಸೆದೊನಿಯಾಚೆ ಎಕ್ ಶಾರ್ ಹೊವ್ನ್ ಹೊತ್ತೆ, ಅನಿ ರೊಮನ್ನಾಂಚೊ ವಾಡೊ ಹೊಲ್ಲೊ ಹೊತ್ತೊ, ಅಮಿ ಥೈ ಉಲ್ಲ್ಯಾ ದಿಸಾಂಚ್ಯಾ ಪತರ್ ಹೊತ್ತ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ನ್ಹೈಯ್‍ಚ್ಯಾ ಜಗ್ಗೊಳ್ ವಿಶೆಸ್ ಮಾಗ್ನಿ ಕರ್‍ತಲೊ ಬರೊ ಜಾಗೊ ಬಗುಕ್ ಹೊತಾ ಮನುನ್ ಚಿಂತುನ್ ಘೆವ್ನ್ ಸಬ್ಬತ್ತಾಚ್ಯಾ ದಿಸಿ ನ್ಹೈಯ್ಚ್ಯಾ ಜಗ್ಗೊಳ್ ಜಾವ್ಕ್ ಮನುನ್ ಶಾರಾಕ್ ಗುಸ್ತಲ್ಯಾ ದಡ್ಪ್ಯಾತ್ನಾ ಭಾಯ್ರ್ ಗೆಲಾಂವ್, ಥೈ ಉಲ್ಲಿ ಬಾಯ್ಕಾ ಮಾನ್ಸಾ ಗೊಳಾ ಹೊವ್ನ್ ಯೆಲ್ಲಿ, ಅಮಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಸುನ್ ಬೊಲ್ಲ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ಥೈ ಥುವತೈರ್ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ಲಿ ಲಿಡಿಯಾ ಮನ್ತಲಿ ಎಕ್ ಬಾಯ್ಕೊ ಮಾನುಸ್ ಹೊತ್ತಿ, ಝಾಂಬ್ಳ್ಯಾ ಬನ್ನಾಚೆ ಕಪ್ಡೆ ಇಕ್ತಲೆ ತಿಜೆ ಕಾಮ್ ಹೊಲ್ಲೆ, ತಿ ಖರ್ಯ್ಯಾ ದೆವಾಕ್ ಆರಾಧನ್‍ ಕರ್‍ತಲಿ ಹೊಲ್ಲಿ , ತಿ ಪಾವ್ಲುಚಿ ಬೊಲ್ನಿಯಾ ಆಯ್ಕುನ್ಗೆತ್ ಹೊತ್ತಿ, ತನ್ನಾ ಧನಿಯಾನ್ ತಿಜೊ ಮನ್ ಉಗಡ್ಲ್ಯಾನ್, ಅನಿ ತಿನೆ ಪಾವ್ಲು ಸಾಂಗ್ತಲ್ಯಾ ಬೊಲ್ನಿಯಾಕ್ನಿ ವಿಶ್ವಾಸ್ ಕರ್‍ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ಲಿಡಿಯಾ ಅನಿ ತೆಚ್ಯಾ ಘರಾತ್ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿಬಿ ಬಾಲ್ತಿಮ್ ಘೆಟ್ಲ್ಯಾನಿ, ಅನಿ ತೆನಿ ಮಿಯಾ ಧನಿಯಾ ಜೆಜುಚ್ಯಾ ವರ್‍ತಿ ಖರೊ ವಿಶ್ವಾಸ್ ಥವಲ್ಲಿ ಮನುನ್ ತುಮಿ ಯೆವಜ್ತ್ಯಾಸಿ ಹೊಲ್ಯಾರ್ ಮಾಜ್ಯಾ ಘರಾಕ್ ಯೆವ್ನ್ ರ್‍ಹಾವಾ ಮನುನ್ ಒತ್ತಾಯ್ ಕರ್‍ಲಿನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ಎಗ್ದಾ ಅಮಿ ಮಾಗ್ನಿ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಜಾತಾನಾ ಎಕ್ ಸಂಗತ್ ಹೊಲಿ, ಎಕ್ ದಾಸಿ ಅಮ್ಕಾ ಭೆಟ್ಲಿ ತಿಜ್ಯಾಕ್ಡೆ ಎಕ್ ವಿಶೆಸ್ ಆತ್ಮೊ ಹೊತ್ತೊ, ತ್ಯಾ ಆತ್ಮ್ಯಾಚ್ಯಾ ಬಳಾನ್ ತಿ ಫಿಡೆ ಹೊತಲೆ ಹೊತ್ತ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗಿತ್ ಹೊತ್ತಿ, ತಸೆ ಕರುನ್ ತಿ ಅಪ್ಲ್ಯಾ ಯಜಮಾನಾಕ್ ಲೈ ಪೈಸೆ ಕರುನ್ ದಿತ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ತಿ ಅಮ್ಚ್ಯಾ ಅನಿ ಪಾವ್ಲುಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆವ್ನ್ ಮೊಟ್ಯಾನ್ ಬೊಬ್ ಮಾರುನ್, ಹಿ ಲೊಕಾ ಮೊಟ್ಯಾ ದೆವಾಚಿ ಸೆವಾ ಕರ್‍ತಲಿ, ತುಮಿ ಕಶೆ ದೆವಾಚಿ ರಾಕ್ವನ್ ಪಾವುನ್ ಘೆವ್ಕ್ ಹೊತಾ ಮನ್ತಲೆ ಸಾಂಗುಲ್ಲಾತ್ ಮಟ್ಲಿನ್ . ");
INSERT INTO kans_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ತಿನಿ ಲೈ ದಿಸಾ ಪತರ್ ಅಸೆಚ್ ಕರ್‍ಲಿನ್, ಹೆಚ್ಯಾ ವೈನಾ ಬೆಜಾರ್ ಹೊಲ್ಲ್ಯಾ ಪಾವ್ಲುನ್ ಪರ್ತುನ್, ತ್ಯಾ ಬುರ್ಶ್ಯಾ ಆತ್ಮ್ಯಾಕ್ “ಜೆಜು ಕ್ರಿಸ್ತಾಚ್ಯಾ ನಾವಾನ್ ತುಕಾ ಹುಕುಮ್ ದಿತಾ ಹಿಕಾ ಸೊಡುನ್ ಚಲ್!” ಮಟ್ಲ್ಯಾನ್, ತನ್ನಾಚ್ ತೊ ಬುರ್ಸೊ ಆತ್ಮೊ ತಿಕಾ ಸೊಡುನ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ಹೆ ಬಗಟಲ್ಲ್ಯಾ ತಿಜಾ ಯಜಮಾನಾಕ್ ಅತ್ತಾ ತಿಜ್ಯಾಕ್ನಾ ಪೈಸೆ ಖಮ್ವುಕ್ ಹೊಯ್ನಾ ಮನ್ತಲೆ ಕಳುನ್ ಯೆಲೆ, ತಸೆ ಹೊವ್ನ್ ತೆನಿ ಪಾವ್ಲುಕ್ ಅನಿ ಸಿಲಾಸಾಕ್ ಧರುನ್ ಶಾರಾತ್ಲ್ಯಾ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಗಾಂವ್ಚೆ ಅಧಿಕಾರಿ ಹೊತ್ತ್ಯಾಕ್ಡೆ ವಡುನ್ ನ್ಹೆಲ್ಯಾನಿ . ");
INSERT INTO kans_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ತ್ಯಾ ಲೊಕಾನಿ ಪಾವ್ಲು ಅನಿ ಸಿಲಾಸಾಕ್ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ಅಧಿಕಾರಿಕ್ಡೆ ಬಲ್ವುನ್ ಹಾನುನ್ ಹೆನಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಅಮ್ಚ್ಯಾ ಶಾರಾತ್ ಧಾಂದಲ್ ಉಟ್ವುಲಾತ್, ");
INSERT INTO kans_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ಅಮ್ಚ್ಯಾ ಪದ್ದತಿ ನೆಮಾಕ್ ವಿರೊದ್ ಹೊವ್ನ್ ನಕ್ಕೊ ಹೊಲ್ಲಿ ಕಾಮಾ ಕರುಲ್ಲಾತ್ ಮನುನ್ ಹೆನಿ ಲೊಕಾಕ್ನಿ ಸಾಂಗುಲ್ಲಾತ್, ರೊಮ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಚ್ಯಾ ಲೊಕಾನಿ, ಅಮಿ ತಸ್ಲಿ ಕಾಮಾ ಕರುಕ್ ಹೊಯ್ನಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಪಾವ್ಲುಕ್ ಅನಿ ಸಿಲಾಸಾಕ್ ವಿರೊದ್ ಹೊವ್ನ್ ಹೊತ್ತೊ, ತನ್ನಾ ಮುಂಖಡಾನಿ ತೆಂಚೆ ದೊಗಾಂಚೆ ಕಪ್ಡೆ ಪಿಂಜುನ್ ಟಾಕುಕ್ ಲಾವ್ನ್ ತೆಂಕಾ ಖಾಟಿನ್ ಲೈ ಮಾರುಕ್ ಲಾವ್ನ್, ");
INSERT INTO kans_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಲ್ವುನ್ ಮಾನಾ ಬಂಧಿಖಾನ್ಯಾಚ್ಯಾ ಅಧಿಕಾರಿಕ್, ತೆಂಕಾ ಲೈ ಉಶಾರ್ಕಿನ್ ರಾಕಾ! ಮನುನ್ ಹುಕುಮ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ತಸೆ ಹೊವ್ನ್, ಬಂದಿಖಾನ್ಯಾಚ್ಯಾ ಅಧಿಕಾರ್ಯಾನ್ ತೆಂಕಾ ಭುರ್ತುಲ್ಯಾ ಖೊಲಿತ್ ಘಾಲುನ್, ತೆಂಚಿ ಪಾಯಾ ಝಾಡಾಚ್ಯಾ ಬೊಡ್ಯಾಂಚ್ಯಾ ಮದ್ದಿ ಘಾಲುನ್ ಬಾಂದ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ಅರ್ದ್ಯಾ ರಾತ್ತಿನ್ ಪಾವ್ಲು ಅನಿ ಸಿಲಾಸ್ ಮಾಗ್ನಿ ಕರಿತ್ ದೆವಾಕ್ ಸ್ತುತಿ ಗಿತಾ ಸಾಂಗಿತ್ ಹೊತ್ತೆ, ಹುರಲ್ಲಿ ಚೊರಾ ಸಗ್ಳಿ ತೆ ಆಯ್ಕಿತ್ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ಬಗುನ್ಗೆತ್ ರ್‍ಹಾತಾನಾಚ್ ಮೊಟೊ ಭುಕಂಪ್ ಹೊಲೊ, ತೊ ಭುಕಂಪ್ ಲೈ ಮೊಟೊ ಹೊಲ್ಲ್ಯಾ ಸಾಟ್ನಿ ಬಂಧಿಖಾನ್ಯಾಚಿ ಪಾಯಾ ಸಗ್ಳಿ ಹಾಲ್ಲಿ, ಅನಿ ದಾರಾ ಸಗ್ಳಿ ಉಗ್ಡುನ್ ಸಗ್ಳಿ ಚೊರಾಂಚಿ ಬಾಂಧಲಿ ಸರ್ಪಳಿಯಾ ಸುಟುನ್ ಪಡ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ತನ್ನಾ ಬಂದಿಖಾನ್ಯಾಚೊ ಅಧಿಕಾರಿ ನಿಜೆತ್ನಾ ಜಾಗೊ ಹೊಲೊ, ದಾರಾ ಸಗ್ಳಿ ಉಗಡಲ್ಲಿ ಹೊತ್ತಿ ಬಗುನ್ ಅತ್ತಾ ಸಗ್ಳಿ ಚೊರಾಬಿ ಚುಕ್ವುನ್ ಘೆವ್ನ್ ಪಳುನ್ ಜಾವ್ಕ್ ಫಿರೆ ಮನುನ್ ಚಿಂತುನ್, ತೆನಿ ಅಪ್ಲೊ ಕೊಯ್ತೊ ಘೆವ್ನ್ ಜಿವ್ ಕಾಡುನ್ ಘೆವ್ಚೆ ಮನುನ್ ಹೊತ್ತ್ಯಾ ತನ್ನಾಚ್, ");
INSERT INTO kans_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ಖರೆ ಪಾವ್ಲುನ್ ತೆಕಾ, “ತಿಯಾ ಜಿವ್ ಕಾಡುನ್ ಘೆವ್ ನಕ್ಕೊ! ಅಮಿ ಸಗ್ಳ್ಯೆಬಿ ಹಿತ್ತೆಚ್ ಹಾತ್” ಮನುನ್ ಮೊಟ್ಯಾನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ತೆಚ್ಯಾ ಮಾನಾ ಬಂದಿಖಾನ್ಯಾಚ್ಯಾ ಅಧಿಕಾರಿನ್ ಎಕ್ಲ್ಯಾಕ್ಡೆ ದಿವೊ ಪೆಟ್ವುನ್ ಹಾನ್ ಮನುನ್ ಸಾಂಗುನ್, ತೊ ಭುತ್ತುರ್ ಪಳುನ್ ಜಾವ್ನ್ ಪಾವ್ಲು ಅನಿ ಸಿಲಾಸಾಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಕೊಸ್ಳುನ್ ಪಡ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ಮಾನಾ ತೆಂಕಾ ದೊಗ್ಯಾಕ್ನಿ ಭಾಯ್ರ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ತೆನಿ, “ಸಾಯ್ಬಾನು, ಮಿಯಾ ದೆವಾಚಿ ರಾಕ್ವನ್ ಘೆವ್ಚೆ ಹೊಲ್ಯಾರ್ ಕಾಯ್ ಕರುಚೆ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ತನ್ನಾ ಪಾವ್ಲುನ್ ಅನಿ ಸಿಲಾಸಾನ್, ಕ್ರಿಸ್ತಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಥವ್, ತನ್ನಾಚ್ ತಿಯಾ ಅನಿ ತುಜ್ಯಾ ಘರಾತ್ಲಿ ಲೊಕಾಬಿ ದೆವಾಚಿ ರಾಕ್ವನ್ ಘೆವ್ಕ್ ಹೊತಾ ಮನುನ್, ");
INSERT INTO kans_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ತೆಕಾ ಅನಿ ತೆಚ್ಯಾ ಘರಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿಬಿ ಧನಿಯಾಚಿ ಬರಿ ಖಬರ್ ಕಳ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ತನ್ನಾ ಅರ್ದಿರಾತ್ ಕಳದಲ್ಲೊ ಯೆಳ್ ಹೊಲ್ಲೊ, ಪಾವ್ಲುಕ್ ಅನಿ ಸಿಲಾಸಾಕ್ ಬಲ್ವುನ್ ನ್ಹೆವ್ನ್ ಅಧಿಕಾರಿನ್ ತೆಂಚಿ ದುಖ್ಖಾ ಸಗ್ಳಿ ಧುವ್ನ್ ತೆಚ್ಯಾ ಮಾನಾ ಅಪ್ಲ್ಯಾ ಘರಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಘೆವ್ನ್ ತೆಂಚ್ಯಾಕ್ನಾ ಬಾಲ್ತಿಮ್ ಕರ್ಸುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ಯೆವ್ಡೆ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆನಿ ಸಗ್ಳಿ ಲೊಕಾ ಧನಿಯಾಚೆರ್ ವಿಶ್ವಾಸ್ ಥವಲ್ಲ್ಯಾಸಾಟಿ ಲೈ ಕುಶಿ ಹೊಲೆ ಮಾನಾ ತೆನಿ ಪಾವ್ಲುಕ್ ಅನಿ ಸಿಲಾಸಾಕ್ ಅಪ್ಲ್ಯಾ ಘರಾಕ್ ಬಲ್ವುನ್ ನ್ಹೆವ್ನ್ ಜೆವಾನ್ ಕರಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ದುಸ್ರ್ಯಾಂದಿಸಿ ಸಕ್ಕಾಳಿ ರೊಮಾಚ್ಯಾ ಮುಖಂಡಾನಿ ಬಂಧಿಖಾನ್ಯಾಚ್ಯಾ ಅಧಿಕಾರಿಕ್ ಸೈನಿಕಾಂಚ್ಯಾಕ್ನಾ ಹ್ಯಾ ಲೊಕಾಕ್ನಿ ಸುಟ್ಕಾ ಕರ್ ಮನುನ್ ಸಾಂಗುನ್ ಧಾಡಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ತನ್ನಾ ಬಂಧಿಖಾನ್ಯಾಚ್ಯಾ ಅಧಿಕಾರಿನ್ ಪಾವ್ಲುಕ್ ಅನಿ ಸಿಲಾಸಾಕ್ ಅಮ್ಚ್ಯಾ ಮುಖಂಡಾನಿ ಸೈನಿಕಾಕ್ನಾ ತುಮ್ಕಾ ಸುಟ್ಕಾ ಕರುಚೆ ಮನುನ್ ಸಾಂಗುನ್ ಧಾಡ್ಲಾ ತುಮಿ ಸಮಾಧಾನಾನ್ ಜಾವಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ಖರೆ ಪಾವ್ಲುನ್, “ಅಮ್ಚಿ ಚುಕ್ ಕಾಯ್ ಮನುನ್ ದಾಕಯಿನಸ್ತಾನಾ ತುಮ್ಚ್ಯಾ ಮುಖಂಡಾನ್ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಅಮ್ಕಾ ಮಾರುಕ್ ಲಾವ್ನ್ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಲುಕ್ ಲಾವ್ಲ್ಯಾನ್, ತುಮಿ ರೊಮ್ ಶಾರಾತ್ಲಿ ಲೊಕಾ ಅಮ್ಕಾಬಿ ಹಕ್ಕ್ ಹಾಯ್, ಅತ್ತಾ ತೊ ಅಮ್ಕಾ ಕೊನ್ ಗೊತ್ತ್ ನಸ್ತಾನಾ ಘುಟ್ಟಾನಿ ಸುಟ್ಕಾ ಕರುಲ್ಲಾ ಕಾಯ್? ಅಮಿ ಜಾಯ್ನಾಂವ್, ಮುಖಂಡುಚ್ ಯೆವ್ನ್ ಅಮ್ಕಾ ಹಿತ್ನಾ ಭಾಯ್ರ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಜಾವ್ಚೊ,” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ತ್ಯಾ ಸೈನಿಕಾನಿ ಮುಖಂಡಾಂಚ್ಯಾಕ್ಡೆ ಜಾವ್ನ್ ಪಾವ್ಲುನ್ ಸಾಂಗಲೆ ಸಗ್ಳೆ ಸಾಂಗ್ಲ್ಯಾನಿ, ಪಾವ್ಲು ಅನಿ ಸಿಲಾಸ್ ರೊಮಾತ್ಲಿ ಲೊಕಾ ಮನ್ತಲೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾಚ್ ಮುಖಂಡಾ ಭಿಂಯಾಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ತಸೆ ಹೊವ್ನ್ ತೆನಿ ಪಾವ್ಲು ಅನಿ ಸಿಲಾಸಾಕ್ಡೆ ಯೆವ್ನ್ ಚುಕ್ ಮಾಗ್ಲ್ಯಾನಿ, ಅನಿ ತೆಂಕಾ ಬಂದಿಖಾನ್ಯಾತ್ನಾ ಭಾಯ್ರ್ ಬಲ್ವುನ್ ನ್ಹೆವ್ನ್ ಅಪ್ಲ್ಯಾ ಶಾರಾತ್ನಾ ತುಮಿ ಜಾವಾ ಮನುನ್ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ಖರೆ ತೆನಿ ದೊಗಾ ಬಂದಿಖಾನ್ಯಾತ್ನಾ ಸುಟ್ಕಾ ಹೊವ್ನ್ ಲಿಡಿಯಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲೆ, ಥೈ ಉಲ್ಲಿ ಲೊಕಾ ದೆವಾಚ್ಯಾ ತಾಂಡ್ಯಾಚಿ ಹೊತ್ತಿ ತೆಂಕಾ ಉಮ್ಮೆದ್ ಹೊಯ್ ಸಾರ್ಕೆ ಕರುನ್ ಮಾನಾ ತೆನಿ ಥೈತ್ನಾ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ಪಾವ್ಲು ಅನಿ ಸಿಲಾಸ್ ಅಂಫಿಪೊಲಿ ಅನಿ ಅಪೊಲೊನಿಯ್ ಮನ್ತಲ್ಯಾ ವಾಟೆನಿ ಫಿರುಂಗೆತ್ ಥೆಸಲೊನಿಕಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಪಾವ್ಲೆ, ತ್ಯಾ ಶಾರಾತ್ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಂಚಿ ಎಕ್ ಸಿನಾಗೊ ಹೊತ್ತೊ . ");
INSERT INTO kans_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ಪಾವ್ಲು ಸದ್ದಿ ಗೆಲ್ಲ್ಯಾ ಸಾರ್ಕೆಚ್ ಜುದೆವಾಕ್ನಿ ಭೆಟುಕ್ ಮನುನ್ ತ್ಯಾ ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ ಗೆಲೊ, ತೆನಿ ತಿನ್ ವಾರಾಂಚ್ಯಾ ಪಾತರ್ ಹರ್ ಎಕ್ ಸಬ್ಬತ್ತಾಚ್ಯಾ ದಿಸಾಬಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಪವಿತ್ರ್ ಪುಸ್ತಕಾಚ್ಯಾ ಆಧಾರಾನ್ ಚರ್ಚಾ ಕರುನ್ ತೆಂಕಾ ಕಳ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“ಕ್ರಿಸ್ತ್ ಮರುನ್ ಸಮಾದಿತ್ನಾ ಝಿತ್ತೊ ಹೊವ್ನ್, ಯೆವ್ಕುಚ್ ಪಾಜೆ ಹೊಲ್ಲೆ, ಮಿಯಾ ಅತ್ತಾ ಸಾಂಗುಲ್ಲಾ, ಹ್ಯೊ ಜೆಜುಚ್ ಕ್ರಿಸ್ತ್” ಮನುನ್ ಪಾವ್ಲುನ್ ತೆಂಕಾ ಸಗ್ಳೆ ಸೊಡ್ಸುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ಥೈ ಖರ್ಯ್ಯಾ ದೆವಾಕ್ ಪ್ರೆಮ್ ಕರ್‍ತಲಿ ಗ್ರಿಕಾಂಚಿ ಉಲ್ಲಿ ಲೊಕಾ ಉಲ್ಲಿ ಪ್ರಮುಖ್ಯ್ ಬಾಯ್ಕಾಮಾನ್ಸಾ ಹೊತ್ತಿ, ತೆನಿ ಮನ್ ಪರ್ತುನ್ ಪಾವ್ಲು ಅನಿ ಸಿಲಾಸಾಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಮಿಳ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ಖರೆ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಹೆ ಬಗುನ್ ಕುಸ್ಡೆಪಾನ್ ಹೊಲೆ, ತೆನಿ ಶಾರಾತ್ಲ್ಯಾ ಥೊಡ್ಯಾ ಪಿಧುಡ್ಯಾ ಲೊಕಾಕ್ನಿ ಪೈಸೆ ದಿವ್ನ್ ಬಲ್ವುನ್ ಹಾನುನ್ ಥೈ ಧಾಂದಲ್ ಉಟ್ವುಲ್ಯಾನಿ, ತಿ ಲೊಕಾ ಪಾವ್ಲುಕ್ ಅನಿ ಸಿಲಾಸಾಕ್ ಹುಕ್ಡುನ್ಗೆತ್ ಯೊಸೊನಾಚ್ಯಾ ಘರಾಕ್ ಜಾವ್ನ್ ತೆಂಕಾ ವಡುನ್ ಲೊಕಾಂಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಹಾನುಚೆ ಮನುನ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ತೆಂಕಾ ಥೈ ಪಾವ್ಲು ಅನಿ ಸಿಲಾಸ್ ದಿಸಿನಸಲ್ಲ್ಯಾ ತನ್ನಾ, ತೆನಿ ಯೊಸಾನಾಕ್ ಅನಿ ಥೊಡ್ಯಾ ದೆವಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಶಾರಾಚ್ಯಾ ಅಧಿಕಾರಿಚ್ಯಾ ಫಿಡೆ ವಡುನ್ ಹಾನುನ್ ಹಿ ಲೊಕಾ ಜಗಾತ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಬಿ ಧಾಂದಲ್ ಉಟ್ವುನ್ ಅತ್ತಾ ಹಿತ್ತೆಬಿ ಯೆಲಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ಹ್ಯಾ ಯೊಸೊನಾನ್ ತೆಂಕಾ ಅಪ್ಲ್ಯಾ ಘರಾತ್ ಥವ್ನ್ ಘೆಟ್ಲಾ , ಹೆನಿ ಸಗ್ಳ್ಯಾನಿ ಸಿಸರಾ ಮನ್ತಲ್ಯಾಚೆ ಖಾಯ್ದೆ ಆಯ್ಕಿನಾ ಹೊಲಾತ್, ಅನಿ ಜೆಜು ಮನ್ತಲೊ ಅನಿ ಎಕ್ ರಾಜಾ ಹಾಯ್ ಮನುನ್ ಸಾಂಗ್ತಾತ್, ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ಸಂಗ್ತಿಯಾ ಆಯ್ಕಾಲ್ಲ್ಯಾ ತನ್ನಾ, ಶಾರಾಚಿ ಅಧಿಕಾರಿ ಅನಿ ಹುರಲ್ಲಿ ಲೊಕಾ ಲೈ ಕಂಗಾಲ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ತೆನಿ ಯೊಸೊನಾಕ್ನಾ ಅನಿ ಹುರಲ್ಲ್ಯಾ ವಿಸ್ವಾಸಿ ಲೊಕಾಂಚ್ಯಾಕ್ನಾ ಜಾಮಿನ್ ಘೆವ್ನ್ ತೆಂಕಾ ಸುಟ್ಕಾ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ತ್ಯಾ ದಿಸಾ ರಾತ್ತಿನಿ ದೆವಾಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾನಿ ಪಾವ್ಲುಕ್ ಅನಿ ಸಿಲಾಸಾಕ್ ಬೆರೊಯಾಕ್ ಧಾಡ್ಲ್ಯಾನಿ, ಥೈ ಹೆನಿ ದೊಗಾ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸಿನಾಗೊತ್ ಗೆಲೆ, ");
INSERT INTO kans_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ಹಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಥೆಸಲೊನಿಕಾತ್ಲ್ಯಾ ಜುದೆವಾಂಚ್ಯಾಕ್ಕಿಂತಾಬಿ ಬರಿ ಹೊವ್ನ್ ಹೊತ್ತಿ, ತೆನಿ ಪಾವ್ಲುನ್ ಅನಿ ಸಿಲಾಸಾನ್ ಸಾಂಗ್ತಲಿ ಸಂಗ್ತಿಯಾ ಉಮ್ಮೆದಿನ್ ಆಯಿಕ್ಲ್ಯಾನಿ, ಅನಿ ಹಿ ಸಂಗ್ತಿಯಾ ಖರೆಚ್ ಕಾಯ್ ಮನುನ್ ಕಳ್ವುನ್ ಘೆವ್ಕ್ ಸಾಟ್ನಿ ಸದ್ದಿಚ್ ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ವಾಚ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ಹ್ಯಾ ಜುದೆವಾಂತ್ನಿ ಲೈ ಲೊಕಾನಿ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನಿ, ತ್ಯಾತುರ್ರ್ಬಿ ಲೈ ಪ್ರಮುಖ್ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ಗ್ರಿಕಾಂಚ್ಯಾ ಬಾಯ್ಕಾಮಾನ್ಸಾನಿ ಅನಿ ಘೊವ್ಮಾನ್ಸಾನಿ ದೆವಾಚೆರ್ ವಿಶ್ವಾಸ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ಖರೆ ಪಾವ್ಲುನ್ ಬೆರೊಯಾ ಶಾರಾತ್ ಯೆವ್ನ್ ದೆವಾಚ್ಯಾ ಗೊಸ್ಟಿಯಾ ಸಾಂಗ್ಲ್ಯಾನ್, ಮನ್ತಲಿ ಖಬರ್ ಆಯ್ಕುನ್ ಥೆಸಲೊನಿಕಾತ್ಲ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಕಂಗಾಲ್ ಕರುನ್ ಧಾಂದಲ್ ಉಟ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ತಸೆ ಹೊವ್ನ್, ದೆವಾಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾನಿ ಪಾವ್ಲುಕ್ ಸಮುಂದ್ರಾಚ್ಯಾ ದಂಡೆಕ್ಲ್ಯಾ ಗಾಂವಾಕ್ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ, ಖರೆ ಸಿಲಾಸ್ ಅನಿ ತಿಮೊಥಿ ಬೆರೊಯ್ ಶಾರಾತುಚ್ ರಾಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ಪಾವ್ಲುಕ್ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಗೆಲ್ಲ್ಯಾ ದೆವಾಚ್ಯಾ ತಾಂಡ್ಯಾತ್ಲ್ಯಾ ಲೊಕಾನಿ ಅಥೆನ್ಸ್ ಶಾರಾಕ್ ಬಲ್ವುನ್ ನ್ಹೆಲ್ಯಾನಿ , ತೆನಿ ಫಾಟಿ ಪರ್ತುನ್ ಯೆತಾನಾ ಪಾವ್ಲುಕ್ನಾ ಸಿಲಾಸ್ ಅನಿ ತಿಮೊಥಿಕ್ ಎಕ್ ಖಬರ್ ಘೆವ್ನ್ ಯೆಲ್ಯಾನಿ, “ಹೊಲ್ಲ್ಯಾ ಯೆವ್ಡೆ ಲಗ್ಗುನಾಚ್ ಮಾಜ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವಾ” ಮನ್ತಲಿಚ್ ತಿ ಖಬರ್. ");
INSERT INTO kans_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ಅಥೆನ್ಸ್ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಪಾವ್ಲು ಸಿಲಾಸ್ ಅನಿ ತಿಮೊಥಿಚಿ ವಾಟ್ ಬಗಿತ್ ಹೊತ್ತೊ, ತ್ಯಾ ಶಾರಾತ್ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಮುರ್ತಿಯಾಚ್ ಹೊತ್ತೆ ಬಗುನ್ ತೆಚ್ಯಾ ಮನಾಕ್ ಲೈ ದುಖ್ ಹೊಲೆ, ");
INSERT INTO kans_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ಪಾವ್ಲುನ್ ದೆವಾಚ್ಯಾ ಗುಡಿತ್ ಜುದೆವಾಂಚ್ಯಾ ಅನಿ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಗ್ರಿಕಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಚರ್ಚಾ ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ಶಾರಾಚ್ಯಾ ಬಾಜಾರ್ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾರ್ಬಿ ಥೊಡ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಸದ್ದಾಬಿ ಚರ್ಚಾ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ಎಪಿ ಕೊರಿಯಾ ಅನಿ ಸ್ಥೊಯಿಕ್ ತತ್ವ್ ಜ್ಞಾನಿತ್ನಿ ಥೊಡ್ಯಾ ಲೊಕಾನಿ ಪಾವ್ಲು ವಾಂಗ್ಡಾ ವಾದ್ ಕರುನ್, ಹ್ಯೊ ಮಾನುಸ್ ದುಶ್ರ್ಯಾ ದೆಶಾಚ್ಯಾ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲ್ಲಾ ಮಟ್ಲ್ಯಾನಿ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೊ ಜೆಜುಚ್ಯಾ ಪರ್ತುನ್ ಝಿತ್ತೊ ಹೊತಲ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಲಾಗಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ಅನಿ ತೆನಿ ಪಾವ್ಲುಕ್ ಅರಿಯೊಪಾಗ್ ಮನ್ತಲ್ಯಾ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಬಲ್ವುನ್ ನ್ಹೆಲಾನಿ, ತೆಕಾ “ತಿಯಾ ಶಿಕಾಪ್ ಕರುಲಾಗಲೊ ನವೊ ತತ್ವ ದಯಾ ಕರುನ್ ಅಮ್ಕಾ ಸಾಂಗ್. ");
INSERT INTO kans_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ಅಮ್ಕಾ ತಿಯಾ ಸಾಂಗುಲಾಗಲಿ ಹಿ ಸಂಗ್ತಿಯಾ ನ್ಹವಿ ಹೊವ್ನ್ ಹಾತ್ ಹೆಚ್ಯಾ ಅದ್ದಿ ಕನ್ನಾಬಿ ಅಮಿ ಹಿ ಸಂಗ್ತಿಯಾ ಆಯ್ಕುಕುಚ್ ನಾತ್ ಹ್ಯಾ ಶಿಕಾಪಾಕ್ನಿ ಅರ್ತ್‍ ಕಾಯ್ ಮನ್ತಲೆ ತುಮಿ ಕಳುನ್ ಘೆವ್ಚೆ ಮನುನ್ ಆನ್ ಕರ್ತಾಂವ್” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ನ್ಹವ್ಯಾ ಯೆವ್ಜನಿಯಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುಕ್ ಅನಿ ಆಯ್ಕುಕ್ ಥೈತ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಕುಶಿ ಹೊಲಿ . ");
INSERT INTO kans_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ತನ್ನಾ ಅರಿಯೊಗ್ ಮನ್ತಲ್ಯಾ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಇದ್ರಾಕ್ ಇಬೆ ರ್‍ಹಾವ್ನ್ ಅಶೆ ಮಟ್ಲ್ಯಾನ್! ಅಥೆನಾತ್ಲ್ಯಾ ಲೊಕಾನು, ತುಮಿ ಸಗ್ಳ್ಯಾ ಸಂಗ್ತಿಯಾತ್ನಿಬಿ ಲೈ ನಿತಿವಂತ್ ಲೊಕಾ ಮನ್ತಲೆ ಮಾಕಾ ದಿಸ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ಮಿಯಾ ತುಮ್ಚ್ಯಾ ಶಾರಾತ್ ಚಲುನ್ ಜಾಯ್ತ್ ರಾತಾನಾ ತುಮಿ ಫುಜ್ಯಾ ಕರ್‍ತಲಿ ದೆವಾಂಚಿ ಮುರ್ತಿಯಾ ಬಗಟ್ಲೊ ಎಕ್ ಬಲಿ ಭೆಟ್ವುತಲ್ಯಾ ಜಗ್ಯಾಕ್ “ಗೊತ್ತ್ ನತ್ತ್ಯಾ ದೆವಾಕ್” ಮನುನ್ ಲಿವಲ್ಲೆ ಹೊತ್ತೆ ತುಮ್ಕಾ ಗೊತ್ತ್ ನತ್ತ್ಯಾ ದೆವಾಕ್ ತುಮಿ ಆರಾಧನ್‍ ಕರುಲ್ಲ್ಯಾಸಿ, ತ್ಯಾ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ಸಗ್ಳೆ ಜಗ್ ಅನಿ ತ್ಯಾತುರ್ ಹೊತ್ತೆ ಹರ್ ಎಕ್‍ಬಿ ರಚಲ್ಲೊ ತ್ಯಾ ದೆವಾನುಚ್ ಮಳ್ಬಾಕ್ ಅನಿ ಜಿಮ್ನಿಕ್ ತೊಚ್ ವಡಿಲ್ ಮಾನ್ಸಾನಿ ರಚಲ್ಲ್ಯಾ ಹ್ಯಾ ಗುಡಿಯಾತ್ನಿ ತೊ ಜಿವನ್ ಕರಿನಾ. ");
INSERT INTO kans_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ತೊ ದೆವುಚ್ ಮಾನ್ಸಾಕ್ ಜಿವ್, ಶ್ವಾಸ್ ಅನಿ ಸಗ್ಳ್ಯೆ ದಿತಲೊ, ತೆಕಾ ಮಾನ್ಸಾಂಚ್ಯಾ ಗುಡಿಚಿ ಗರಜ್ ನಾ ತೆಕಾ ಕಾಯ್ಬಿ ಕಮ್ಮಿ ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ಎಕ್ ಮಾನ್ಸಾಕ್ ರಚುನ್ ದೆವಾನ್ ಹ್ಯಾ ಜಗಾರ್ ಮಾನ್ಸಾಂಚೊ ಕುಲ್ ಶುರು ಕರ್‍ಲ್ಯಾನ್, ಅನಿ ತೆನಿ ಖೈ ಕನ್ನಾ ಜಿವನ್ ಕರುಂಗೆತ್ ರಾವ್ಚೆ ಮನ್ತಲೆ ನಿರ್ಧಾರ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ಲೊಕಾನಿ ಅಪ್ನಾಕ್ ಹುಡ್ಗುಚೆ ಮನ್ತಲಿ ದೆವಾಚಿ ಇಚ್ಚ್ಯಾ ಹೊಲ್ಲೆ ಅಪ್ನಾಸಾಟ್ನಿ ಅಜುಭಾಜುಕ್ ಸಗ್ಳ್ಯೆ ಹುಡ್ಕುನ್ ಕಾಡುನ್ ಘೆವ್ಕ್ ಹೊತಾ ಮನುನ್ ದೆವಾನ್ ತಸೆ ಕರ್‍ಲ್ಯಾನ್, ಖರೆ ಅಮ್ಕಾ ಕೊನಾಕ್ಬಿ ತೊ ಎಕ್ಲ್ಯಾಕ್ಬಿ ಧುರ್ ಹೊವ್ಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ಅಮಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ವಸ್ತಿ ಕರ್ತಾಂವ್ , ಚಲ್ತಾಂವ್ ಅನಿ ಚಿಗರ್ತಾಂವ್, ತುಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಗಿತಾ ಲಿವ್ತಲ್ಯಾ ಮಾನ್ಸಾನಿ ಅಮಿ ತೆಚಿ ಪೊರಾ ಮನುನ್ ಸಾಂಗ್ಲಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ಅಮಿ ದೆವಾಚಿ ಪೊರಾ ಹೊವ್ನ್ ಹಾತ್, ತಸೆ ಹೊವ್ನ್ ಮಾನ್ಸಾನಿ ತಯಾರ್ ಕರಲ್ಲಿ ಸೊನ್ಯಾಚಿ ಚಾಂದಿಚಿ ನಾ ತರ್ ಗುಂಡ್ಯಾಚಿ ಮುರ್ತಿಯಾ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ಅದ್ಲ್ಯಾ ಕಾಲಾತ್ಲ್ಯಾ ಲೊಕಾನಿ ದೆವಾಕ್ ಅರ್ತ್‍ ಕರುನ್ ಘೆವ್ಕ್ ನಾತ್, ಖರೆ ದೆವಾನ್ ತೆಕಾ ಸಗ್ಳೆ ಧ್ಯಾನ್ ದಿವ್ಕ್ ನಾ, ಅತ್ತಾ ತರಿಬಿ ಜಗಾತ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾಕ್ಡೆ ಬಿ ದೆವಾಕ್ಡೆ ಮನ್ ಪರ್ತುನ್ ಘೆವ್ಚೆ ಮನುನ್ ತೆನಿ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ಜಗಾತ್ಲ್ಯಾ ಹರ್ ಎಕ್ಲ್ಯಾಕ್ಬಿ ಝಡ್ತಿ ಕರುಕ್ ಮನುನ್ ದೆವಾನ್ ದಿಸ್ ವಳಕ್ ಕರುನ್ ಥವಲ್ಲೊ ಹಾಯ್, ತ್ಯಾ ದಿಸಾ ಝಡ್ತಿ ಕರುಕ್ ಮನುನ್ ತೆನಿ ಲೈ ಯೆಳಾಚ್ಯಾ ಅದ್ದಿಚ್ ಎಕ್ ಮಾನ್ಸಾಕ್ ಎಚುನ್ ಘೆಟಲ್ಲೆ ಹಾಯ್, ತೆ ಖರೆ ಕರುಕ್ ಸಾಟ್ನಿ ತೆಕಾ ಮರ್ನಾಕ್ನಾ ಝಿತ್ತೊ ಕರುನ್ ಉಟ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ತ್ಯಾ ಲೊಕಾತ್ನಿ ಉಲ್ಲ್ಯಾನಿ ಜೆಜು ಮರ್ನಾಕ್ನಾ ಝಿತ್ತೊ ಹೊವ್ನ್ ಉಟುನ್ ಯೆಲಾ ಮನ್ತಲಿ ವಿಶಯ್ ಆಯ್ಕುನ್ ಯೆಡ್ವುಲ್ಯಾನಿ, ಅನಿ ಉಲ್ಲ್ಯಾನಿ ಹ್ಯಾ ವಿಶಯಾತ್ ಅನಿ ಎಗ್ದಾ ಸಾಂಗುಚೆ ತನ್ನಾ ಅಮಿ ಆಯಿಕ್ತಾಂವ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ತಸೆ ಹೊವ್ನ್, ಪಾವ್ಲು ತಾಂಡೊ ಸೊಡುನ್ ತೆಂಚ್ಯಾಕ್ನಾ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ಖರೆ ತ್ಯಾ ಲೊಕಾತ್ನಿ ಉಲ್ಲ್ಯಾನಿ ಪಾವ್ಲುಚೆರ್ ವಿಶ್ವಾಸ್ ಕರುನ್ ತೆಕಾ ಆಪ್ನಾಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಮಿಳ್ವುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ವಿಶ್ವಾಸ್ ಕರಲ್ಲ್ಯಾ ಲೊಕಾತ್ನಿ ಅರಿಯೊಪಾಗ್ ಮನ್ತಲ್ಯಾ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ತಾಂಡ್ಯಾಚಿ ದಿಯೊನಿಸಿಯಾ ದಮಾರಿ ಮನ್ತಲಿ ಬಾಯ್ಕೊಮಾನುಸ್‍ ಅನಿ ಹುರಲ್ಲಿ ಲೊಕಾ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ಮಾನಾ ಪಾವ್ಲು ಅಥೆನ್ಸ್ ಸೊಡುನ್ ಕೊರಿಂಥಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ಪೊಂತ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಉಪಾಜಲ್ಲೊ ಅಕ್ವಿಲ್ ಮನ್ತಲ್ಯಾ ನಾವಾಚೊ ಥೈ ದಿಸಲ್ಲೊ, ಸಗ್ಳಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ರೊಮ್ ಶಾರಾಕ್ ಸೊಡುನ್ ಜಾವ್ಚೆ ಮನುನ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್, ಅಕ್ವಿಲ್ ಅನಿ ತೆಚಿ ಬಾಯ್ಕೊ ಪ್ರಿಸ್ಕಿಲ್ಲ್ ಮನ್ತಲ್ಲಿ ತೆನಿ ಇಟಲಿಕ್ನಾ ಕೊರಿಂಥಾಕ್ ಅತ್ತಾ ದನಿ ಯೆಲ್ಲ್ಯಾನಿ, ಕ್ಲಾಡಿಯಸ್ ಮನ್ತಲ್ಯಾ ಮಾನಸ್ಸಾನ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್, ತೆನಿ ಇಟಲಿ ಮನ್ತಲೆ ಗಾಂವ್ ಸೊಡುನ್ ಯೆಲ್ಲ್ಯಾನಿ, ಪಾವ್ಲುನ್ ಅಕ್ವಿಲಾಕ್ ಅನಿ ತೆಜಾ ಬಾಯ್ಕೊ ಪ್ರಿಸ್ಕಿಲ್ಲಾಕ್ ಭೆಟುಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆನಿ ಪಾವ್ಲುಚ್ಯಾ ಸಾರ್ಕೆ ಬಿಡಾರಾ ತಯಾರ್ ಕರ್‍ತಲೆ ಕಾಮ್ ಕರಿತ್ ಪಾವ್ಲು ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾಚ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ಹರ್ ಸಬ್ಬತ್‍ ದಿಸಾದಿಸಿ ಪಾವ್ಲುನ್ ದೆವಾಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಸಿನಾಗೊತ್ ಜುದೆವಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಅನಿ ಗ್ರಿಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಚರ್ಚಾ ಕರುನ್ ಎಕ್ ಕರುಚೆ ಮನುನ್ ಬಗಿ. ");
INSERT INTO kans_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ಸಿಲಾಸ್, ತಿಮೊಥಿ ಅನಿ ಪಾವ್ಲು ಮೆಸೆದೊನಿಯಾತ್ನಾ ಯೆಲೆ, ಪಾವ್ಲುನ್ ಅಪ್ಲೊ ಯೆಳ್ ಸಗ್ಳೊ ತ್ಯಾ ಲೊಕಾಕ್ನಿ ದೆವಾಚಿ ಖಬರ್ ಕಳ್ವುನ್ ದಿಲ್ಯಾನ್, ಅನಿ ಜೆಜುಚ್ ಕ್ರಿಸ್ತ್ ಮನುನ್ ಜುದೆವಾಂಚ್ಯಾ ಮದ್ದಿ ಸಾಕ್ಷಿ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ಹೊಲ್ಯಾರ್ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾನಿ ಪಾವ್ಲುಚಿ ಶಿಕಾಪಾ ಸಗ್ಳಿ ತಿರಸ್ಕಾರ್ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ಗಾಳಿಯಾ ದಿಲ್ಯಾನಿ, ತೆಚಾ ಸಾಟ್ನಿ ಪಾವ್ಲುನ್ ಅಪ್ನಾಚಿ ಫಾಳಿಯಾಂಚಿ ಧುಳ್ ಝಾಡ್ಸುನ್ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ “ತುಮ್ಚೊ ನಾಸ್ ಹೊವ್ಕ್ ಮಿಯಾ ಜವಾಬ್ದಾರಿ ನ್ಹಯ್ ತುಮಿಚ್ ಕಾರನ್ ಹೆಜಾ ಮಾನಾ ಮಿಯಾ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಜಾತಾ!” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ತನ್ನಾ ಪಾವ್ಲು ಸಿನಾಗೊ ಸೊಡುನ್ ತಿತಯುಸ್ತ್ ಮನ್ತಲ್ಯಾಚ್ಯಾ ಘರಾಕ್ ಗೆಲೊ, ತೊ ಮಾನುಸ್ ದೆವಾಕ್ ಆರಾಧನ್‍ ಕರಿತ್ ಹೊತ್ತೊ, ತೆಚೆ ಘರ್ ಸಿನಾಗೊಚ್ಯಾ ಬಾಜುಕುಚ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ಕ್ರಿಸ್ಪಸ್ ಮನ್ತಲೊ ಎಕ್ ಮಾನುಸ್ ಸಿನಾಗೊಚೊ ಅದಿಕಾರಿ ಹೊಲ್ಲೊ, ಅನಿ ತೆಚ್ಯಾ ಘರಾತ್ ಹೊತ್ತಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾನಿ ಧನಿಯಾಚೆರ್ ವಿಶ್ವಾಸ್ ಥವ್ಲ್ಯಾನಿ, ಕೊರಿಂಥ್ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ಪಾವ್ಲುನ್ ಸಾಂಗಲ್ಲಿ ಬರಿ ಖಬರ್ ಆಯ್ಕಲ್ಯಾ ಲೈ ಲೊಕಾನಿ ವಿಶ್ವಾಸ್ ಕರುನ್ ಬಾಲ್ತಿಮ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ಎಕ್ ದಿಸಿ ರಾತ್ತಿನ್ ಪಾವ್ಲುಕ್ ದರ್ಶನ್ ಹೊಲೆ ಧನಿಯಾನ್; ತೆಕಾ, ಭಿಂವ್‍ನಕೊ! ಲೊಕಾಕ್ನಿ ತಿಯಾ ಸಾಂಗುನ್ಗೆತ್ ಜಾ, ಇಬೆ ಕರುನಕ್ಕೊ! ");
INSERT INTO kans_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮಿಯಾಚ್ ತುಜ್ಯಾ ವಾಂಗ್ಡಾ ಹಾಯ್ ತುಕಾ ಬುರ್ಶೆ ಕರುಕ್ ಕೊನಾಚ್ಯಾನ್ ಬಿ ಹೊಯ್ನಾ, ಮಾಜಿ ಉಲ್ಲಿ ಲೊಕಾ ಹ್ಯಾ ಶಾರಾತ್ ಹಾತ್, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ಪಾವ್ಲುನ್ ದೆವಾಚಿ ಖರಿ ಖಬರ್ ಲೊಕಾಕ್ನಿ ಶಿಕಾಪಾ ಕರುನ್ಗೆತ್ ಥೈ ದಿಡ್ ವರಿಸ್ ಪತರ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ಅಖಾಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ ಗಲ್ಲಿಯೊನ್ ಮನ್ತಲ್ಲೊ ರೊಮ್ ಸಾಮ್ರಾಜ್ಯಾಚೊ ಅದಿಕಾರಿ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ ಥೊಡಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಪಾವ್ಲುಚ್ಯಾ ವಿರೊಧ್ ಗೊಳಾ ಹೊವ್ನ್ ತೆನಿ ಪಾವ್ಲುಕ್ ಧರುನ್ ಝಡ್ತಿ ಕರ್‍ತಲ್ಲ್ಯಾ ಜಾಗ್ಯಾತ್ ಬಲ್ವುನ್ ನೆಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ಹೊ ಮಾನುಸ್ ಅಮ್ಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಮೊಜ್ಜೆಚ್ಯಾ ಖಾಯ್ದೆಚ್ಯಾ ಪುಸ್ತಕಾಚ್ಯಾ ವಿರುಧ್ ಹೊಲ್ಲ್ಯಾ ರಿತಿನ್ ದೆವಾಕ್ ಆರಾಧನ್‍ ಕರುಚೆ ಮನುನ್ ಹ್ಯೊ ಲೊಕಾಕ್ನಿ ತೆಂಚಿ ಮನಾ ಪರ್ತುಕ್ ಕಟ್ಪಟ್ ಕರುಲಾಲಾ! ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ಪಾವ್ಲುನ್ ಬೊಲುಚೆ ಮನುನ್ ತಯಾರ್ ಹೊವ್ನ್ಗೆತ್ ರ್‍ಹಾತಾನಾಚ್ ಗೆಲ್ಲಿಯೊನ್ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ, ಹೊ ಮಾನುಸ್ ಎಕ್ ಎಳಾರ್ ಚುಕ್ ಕರಲ್ಲೊ ಅನಿ ಮೊಟೊ ಅಪರಾದ್ ಕರಲ್ಲೊ ಹೊಲ್ಲ್ಯಾರ್ ಮಿಯಾ ಹೆ ಜವಾಬ್ದಾರಿನ್ ಆಯ್ಕುಕ್ ಹೊಯ್ ಹೊತ್ತೆ . ");
INSERT INTO kans_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ಖರೆ ಹಿ ವಾದ್ ವಿವಾದಾ ಕರ್‍ತಲಿ ಬೊಲ್ನಿಯಾ ಅನಿ ನಾವಾ ತುಮ್ಚ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾಕ್ ಸಂಬದ್ ಪಡಲ್ಲಿ ಹಾತ್, ತಸೆ ತುಮಿಚ್ ಹೆ ಸಮಾ ಕರುನ್ ಘೆವ್ಚೆ, ಹ್ಯಾ ಸಂಗ್ತಿಯಾಕ್ನಿ ಝಡ್ತಿ ಕರ್‍ತಲೊ ಹೊವ್ನ್ ರ್‍ಹಾವ್ಕ್ ಮಾಕಾ ಮನ್ ನಾ! ಮನುನ್ ಸಾಂಗುನ್, ");
INSERT INTO kans_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ತಸೆ ಹೊವ್ನ್ ತೆನಿ ತೆಂಕಾ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ಜಾಗ್ಯಾ ವೈನಾ ಧಾಡುನ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ಮಾನಾಸರ್ ತೆನಿ ಸಗ್ಳೆ ಸೊಸ್ಥೆನ್ ಮನ್ತಲ್ಯಾ ಸಿನಾಗೊಚ್ಯಾ ಅದಿಕಾರಿಕ್ ಧರುನ್ ಘೆವ್ನ್ ಇಚಾರ್ನಿ ಕರ್ತಲ್ಯಾಚ್ಯಾ ಇದ್ರಾಕ್, ಮಾರ್‍ಲ್ಯಾನಿ, ಹೊಲ್ಯಾರ್ ಗಲ್ಲಿಯೊನ್ ಮನ್ತಲ್ಯಾನ್ ತೆ ಕಾಯ್ಬಿ ಲೆಕ್ಕಾತ್ ಧರುಕ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ಪಾವ್ಲು ವಿಶ್ವಾಸಿ ಭಾವಾಚ್ಯಾ ವಾಂಗ್ಡಾ ಕೊರಿಂಥಾತ್ ಉಲ್ಲಿ ದಿಸಾ ರ್‍ಹಾಲೊ ತೆಚ್ಯಾ ಮನಾ ಸಮುಂದ್ರರಾಚ್ಯಾ ವಾಟೆನ್ ಪ್ರಿಸ್ಕಿಲಾ ಅನಿ ಅಕ್ವಿಲ್ ಮನ್ತಲ್ಲ್ಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಸಿರಿಯಾಕ್ ಜಾವ್ಕ್ ಲಾಗಲ್ಲೊ, ಪ್ರಯಾನ್ ಕರುಚ್ಯಾ ಅದ್ದಿಚ್ ತೆನಿ ಕೆಂಕ್ರೆ ಶಾರಾತ್ ಅಪ್ಲಿ ಕೆಸಾ ಕಾತ್ರುನ್ ಘೆವ್ಕ್ ಗೆಲೊ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆನಿ ಶಪತ್ ಕರಲ್ಲೆ ಹೊತ್ತೆ ");
INSERT INTO kans_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ತೆನಿ ಎಫೆಸಿ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಗೆಲೆ ಪ್ರಿಸ್ಕಿಲ್ಲ್ ಅನಿ ಅಕ್ವಿಲ್ಲಾಕ್ ಪಾವ್ಲುನ್ ತೆಂಕಾ ಸೊಡುನ್ ಗೆಲೆ ಹಿತ್ತೆಚ್ ಪಾವ್ಲುನ್ ಎಫೆಸ್‍ ಮನ್ತಲ್ಯಾ ಗಾಂವಾತ್ ರಾತಾನಾ ಸಿನಾಗೊ ಜಾವ್ನ್ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾಕ್ಡೆ ಚರ್ಚಾ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ತ್ಯಾ ಲೊಕಾನಿ ಪಾವ್ಲುಕ್ ಅನಿ ಉಲ್ಲಿ ದಿಸಾ ಅಪ್ನಾಚ್ಯಾ ವಾಂಗ್ಡಾ ರ್‍ಹಾವ್ಚೆ ಮನುನ್ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ಖರೆ ತೆನಿ ತೆ ಒಪ್ಪುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ಹೆಚ್ಯಾ ಬದ್ಲಾಕ್ ತೆನಿ ಜಾತಾನಾ ತೆಂಕಾ ದೆವಾಚೊ ಮನ್ ರ್‍ಹಾಲ್ಯಾರ್, ಮಿಯಾ ಪರ್ತುನ್ ತುಮ್ಚ್ಯಾಕ್ಡೆ ಯೆತಾ ಮನುನ್ ಸಾಂಗುನ್ ಢೊನಾತ್ನಾ ಸಮುಂದರಾಚ್ಯಾ ವಾಟೆನ್ ಎಫೆಸಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ತೊ ಸೆಜಾರೆಯಾಕ್ ಯೆವ್ನ್ ಪಾವಲ್ಯಾ ತನ್ನಾ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್ನ್ ದೆವಾಚ್ಯಾ ಲೊಕಾಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಜಾವ್ನ್ ಯೆತಾ ಮನುನ್ ಸಾಂಗುನ್ ಅಂತಿಯೊಕಾಕ್‍ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ಮನಾ ತೊ ಉಲ್ಲೊ ಯೆಳ್ ಥೈ ರಾವ್ನ್ ಜಾತಾನಾ ಗಲಾತ್ಯಾ ಅನಿ ಪಿರ್ಗಿಯಾತ್ನಾ ಫಿರುನ್ಗೆತ್ ಸಗ್ಳ್ಯಾ ವಿಶ್ವಾಸಿ ಲೊಕಾಕ್ನಿ ಘಟ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ತವ್ಡ್ಯಾ ಯೆಳಾಕುಚ್ ಅಲೆಕ್ಸಾಂಡ್ರಿಯಾತ್ ಉಪಾಜಲೊ ಅಪೊಲ್ಲೊಸ್ ಮನ್ತಲೊ ಜುದೆವಾಂಚೊ ಎಕ್ಲೊ ಎಫೆಸಾಕ್ ಯೆಲೊ, ತೊ ಬೊಲ್ನ್ಯಾತ್ನಿ ಲೈ ಉಶಾರ್ ಅನಿ ಪವಿತ್ರ್ ಪುಸ್ತಕ್ ಕಳ್ವುನ್ ಘೆಟಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ಧನಿಯಾಚ್ಯಾ ವಿಶಯಾತ್ ತೆನಿ ಬರೆ ಶಿಕುನ್ ಘೆಟಲ್ಯಾನ್, ಅನಿ ತೊ ಲೈ ಉಮ್ಮೆದಿಚ್ಯಾ ಮನಾನ್ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಸಮಾಕರುನ್ ಶಿಕಾಪಾ ಶಿಕ್ವಿತ್ ಹೊತ್ತೊ, ತೆಕಾ ಜುವಾಂವಾಚ್ಯಾ ಬಾಲ್ತಿಮಾಚ್ಯಾ ವಿಶಯಾತ್ ತವ್ಡೆಚ್ ಗೊತ್ತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ತೆನಿ ಸಿನಾಗೊತ್ ತೊ ಧರ್ಯ್ಯಾನ್ ಬೊಲುಕ್ ಚಾಲು ಕರ್‍ಲ್ಯಾನ್, ಅಕ್ವಿಲ್ಲಾನ್ ಅನಿ ಪ್ರಿಸ್ಕಿಲ್ಲಾನ್ ಆಯ್ಕುನ್ ತೆಕಾ ಅಪ್ಲ್ಯಾ ಘರಾಕ್ ಬಲ್ವುನ್ ನ್ಹೆವ್ನ್ ತೆಕಾ ದೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಸಮಾ ಶಿಕಾಪ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ಹೆ ಸಗ್ಳೆ ಹೊಲ್ಯಾ ಮಾನಾ ಅಪೊಲ್ಲೊಸಾನ್ ಅಖಾಯಾಕ್ ಜಾವ್ಚೆ ಮನುನ್ ನಿರ್ದಾರ್ ಕರ್‍ಲ್ಯಾನ್, ತನ್ನಾ ಎಫೆಸಾತ್ಲ್ಯಾ ವಿಶ್ವಾಸಿ ಲೊಕಾನಿ ಅಖಾಯಿಯಾತ್ಲ್ಯಾ ವಿಶ್ವಾಸಿ ಲೊಕಾಕ್ನಿ ಚಿಟ್ ಲಿವ್ನ್ ಮಜ್ಜತ್ ಕರುನ್ ತೆಕಾ ಸ್ವಾಗತ್ ಕರುಕ್ ಮನುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ತೊ ಥೈ ಪಾವಲ್ಯಾ ತನ್ನಾ ದೆವಾಚ್ಯಾ ಮೊಟ್ಯಾ ಕುರ್ಪೆ ವೈನಾ ಥೈ ಹೊತ್ತ್ಯಾ ವಿಶ್ವಾಸಿ ಲೊಕಾಕ್ನಿ ಎಕ್ ಮಜತ್ಕಾರಿ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ತೆಚ್ಯಾ ಬಳಾಚ್ಯಾ ವಾದ್ ವಿವಾದಾನಿ ಲೊಕಾತ್ನಿ ಜಾವ್ನ್ ಹೊತಲ್ಯಾ ಚರ್ಚಾತ್ನಿ ಪವಿತ್ರ್ ಪುಸ್ತಕಾಚ್ಯಾ ವೈನಾ ಜೆಜುಚ್ ಕ್ರಿಸ್ತ್ ಮನುನ್ ಖರೆ ಕರುನ್ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಹರ್‍ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ಅಪೊಲ್ಲೊಸ್ ಕೊರಿಂಥ್ ಶಾರಾತ್ ರಾತಾನಾ ಪಾವ್ಲುನ್ ಮಡ್ಡಿ ವೈಲಾ ಗಾಂವಾತ್ನಿ ಜಾವ್ನ್ಗೆತ್ ಎಫೆಸಾಕ್ ಯೆವ್ನ್ ಉಲ್ಯಾ ಶಿಸಾಕ್ನಿ ಭೆಟುನ್, ");
INSERT INTO kans_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ತುಮಿ ವಿಶ್ವಾಸ್ ಕರಲ್ಲ್ಯಾ ತನ್ನಾ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಕ್ ಘೆಟ್ಲ್ಯಾಶಿ ಕಾಯ್? ಮನುನ್ ಇಚಾರ್ತಾನಾ ತೆನಿ “ನಾ ಅಮಿ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಚ್ಯಾ ವಿಶಯಾತ್ ಅಜುನ್ ಪತರ್ ಆಯ್ಕುಕ್ ನಾತ್!” ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ಪಾವ್ಲುನ್ ತೆಂಕಾ,“ ತುಮಿ ಖಚ್ಚ್ಯಾ ರಿತಿಚೆ ಬಾಲ್ತಿಮ್ ಘೆಟ್ಲ್ಯಾಶಿ?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ತೆನಿ ಜುವಾಂವಾಚೆ ಬಾಲ್ತಿಮ್ ಅಮಿ ಕರುನ್ ಘೆಟ್ಲ್ಯಾಂವ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ಜುವಾಂವಾಚೆ ಬಾಲ್ತಿಮ್ ಪಾಪ್ ಸೊಡುನ್ ದೆವಾಕ್ಡೆ ಪರ್ತುನ್ ಯೆತಲ್ಯಾಕ್ನಿ ಹೊಲ್ಲೆ, ತೆನಿ ಲೊಕಾಕ್ನಿ ಅಪ್ಲ್ಯಾ ಮಾನಾ ಯೆತಲೊ ಹೊತ್ಯ್ತಾಚೆರ್ ವಿಶ್ವಾಸ್ ಥವಾ ಮನುನ್ ಸಾಂಗಲ್ಯಾನ್ ತೊ ಜೆಜುಚ್. ");
INSERT INTO kans_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ತೆನಿ ಹೆ ಆಯ್ಕುಲ್ಯಾ ತನ್ನಾ ಧನಿಯಾ ಜೆಜುಚ್ಯಾ ನಾವಾರ್ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ಪಾವ್ಲುನ್ ತೆಂಚ್ಯಾ ವರ್‍ತಿ ಹಾತಾ ಥವಲ್ಲ್ಯಾ ತನ್ನಾ ತೆಂಕಾ ಪವಿತ್ರ್ ಆತ್ಮೊ ಯೆಲೊ, ತೆನಿ ಅಪ್ನಾಕ್ ವಳಕ್ ನಸಲ್ಲಿ ದುಸ್ರಿ ದುಸ್ರಿ ಭಾಶ್ಯಾ ಬೊಲ್ಯಾನಿ ಅನಿ ದೆವಾಚಿ ಬರಿ ಖಬರ್ ಪರ್ಗಟ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ತೆನಿ ಲೈ ಕರುನ್ ಬಾರಾ ಘೊಮಾನ್ಸಾ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ತ್ಯಾ ಶಾರಾತ್ ಪಾವ್ಲುನ್ ಸಿನಾಗೊಕ್ ಜಾವ್ನ್ ಧೈರ್ಯಾನ್ ಬೊಲುನ್ಗೆತ್ ಸುಮಾರ್ ತಿನ್ ಮ್ಹ್ನನ್ಯಾನ್ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ದೆವಾಚ್ಯಾ ರಾಜಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಬೊಲುನ್ಗೆತ್ ತೆಂಚೆ ಮನ್ ಪರ್ತುಕ್ ಬಗ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ತ್ಯಾತುರ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಅಪ್ಲೊ ಮನ್ ಘಟ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ಅನಿ ವಿಶ್ವಾಸ್ ಕರುಕ್ ನಾತ್, ಸಗ್ಳ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಇದ್ರಾಕ್ ತಿರಾನ್ನ್‌ ಮನ್ತಲ್ಯಾಚ್ಯಾ ಸಾಳೆತ್ ಧನಿಯಾಚ್ಯಾ ವಾಟೆಚ್ಯಾ ವಿಶಯಾತ್ ಬುರ್ಶೆ ಬೊಲ್ಲ್ಯಾನಿ, ತಸೆ ಹೊವ್ನ್ ಪಾವ್ಲುನ್ ತೆಂಕಾ ಸೊಡುನ್ ವಿಶ್ವಾಸಿ ಲೊಕಾಕ್ನಿ ಅಪ್ನಾ ವಾಂಗ್ಡಾ ಬಲ್ವುನ್ ನೆಲ್ಯಾನ್, ಅನಿ ಸದ್ದಿ ತೆಂಕಾ ತುರ್ ಮನ್ತಲ್ಯಾ ಶಿಕ್ವುತಲ್ಯಾ ಖೊಲಿಕ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಚರ್ಚಾ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ಹೆ ದೊನ್ ವರ್ಸಾ ಪತರ್ ಚಲುನ್ಗೆತ್ ಹೊತ್ಯಾ ಸಾಟ್ನಿ ಆಸ್ಯಾ ಪ್ರಾಂತ್ಯಾಲ್ಲಿ ಸಗ್ಳಿ ಜುದೆವಾಂಚಿ ಅನಿ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಧನಿಯಾ ಜೆಜುಚಿ ಬರಿ ಖಬರ್ ಆಯಿಕ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ದೆವ್ ಪಾವ್ಲುಚ್ಯಾ ಹಾತಿನ್ ಹೊಯ್ ನಸಲ್ಲಿ ಮೊಟಿ ಕಾಮಾ ಕರ್ಸುನ್ಗೆತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ತಸೆ ಹೊವ್ನ್ ಲೊಕಾಕ್ನಿ ತೆಚ್ಯಾ ಹಾತಿತ್ಲೊ ಟವಾಲೊ ನಾ ತರ್ ಕಾಮ್ ಕರ್‍ತಾನಾ ನೆಸ್ತಲಿ ವೈಲಿ ಅಂಗಿ ನ್ಹೆವ್ನ್ ಶಿಕ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ವರ್‍ತಿ ಘಾಲ್ತಾನಾ ತೆಂಕಾ ಗುನ್ ಹೊಲೆ, ಅನಿ ಗಿರೆ ಸೊಡುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ಗಿರೆ ಸೊಡಸ್ತಲಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಥೈ ಫಿರುಂಗೆತ್ ಹೊತ್ತಿ ತೆಂಚ್ಯಾತ್ಲಿ ಉಲ್ಲಿ ಲೊಕಾ ಧನಿಯಾ ಜೆಜುಚೆ ನಾವ್ ವಾಪ್ರುನ್ ಘೆವ್ನ್ ಗಿರೆ ಸೊಡ್ಸುಕ್ ಕಟ್ಪಟ್ ಕರಿತ್ ಹೊತ್ತಿ, ತೆನಿ ಪಾವ್ಲು ಪರ್ಗಟ್ ಕರುಲಾಗಲ್ಯಾ ಜೆಜುಚ್ಯಾ ನಾವಾನ್ ಹುಕುಮ್ ದಿತಾ, ಭಾಯ್ರ್ ಯೆ ಮನುನ್ ಮ್ಹಾರ್‍ವಾಕ್ನಿ ಸಾಂಗಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ಸ್ಕೆವ್ ಮನ್ತಲ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಮೊಟ್ಯಾ ಯಾಜಕಾಚಿ ಪೊರಾ ಸಾತ್ ಲೊಕಾ ಭಾವ್ ಭಾವಾಬಿ ಹೆಚ್ ಕಾಮ್ ಕರಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ಖರೆ ಮ್ಹಾರ್ವಾನ್ ತೆಂಕಾ ಜೆಜು ಅಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್, ಅನಿ ಪಾವ್ಲುಬಿ ಗೊತ್ತ್ ಹಾಯ್, ಖರೆ ತುಮಿ ಕೊನ್? ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ಖರೆ ಮ್ಹಾರು ಧರಲ್ಯಾ ಮಾನ್ಸಾನ್ ತೆಂಕಾ ಧರುನ್ ತೆಂಚೆ ಕಪ್ಡೆ ಪಿಂಜುನ್ ತುಕ್ಡೆ ಕರ್‍ಲ್ಯಾನ್ ಅನಿ ಘರಾತ್ನಾ ಪಳುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ಎಫೆಸಾತ್ ರ್‍ಹಾತಲಿ ಜುದೆವಾಂಚಿ ಅನಿ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾನಿ ಜೆಜುಚ್ಯಾ ವಿಶಯಾತ್ ಆಯ್ಕಲ್ಯಾನಿ, ಅನಿ ಭಿಂವ್ಲ್ಯಾನಿ, ಅನಿ ಧನಿಯಾ ಜೆಜುಚ್ಯಾ ನಾವಾಕ್ ಲೈ ಮಾನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ತೆಜ್ಯಾರ್ ವಿಶ್ವಾಸ್ ಕರಲ್ಲ್ಯಾ ಲೈ ಲೊಕಾನಿ ಯೆವ್ನ್ ಲೊಕಾಂಚ್ಯಾ ಫಿಡ್ಯಾತ್ ಅಪ್ನಿ ಕರಲಿ ಚುಕೆಚಿ ಕಾಮಾ ಸಗ್ಳಿ ಮಾಳಾಕ್ ಹಾನುನ್ ಸಾಂಗುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ತವ್ಡೆ ನಸ್ತಾನಾ ಮೊಡಿ ಮಂತ್ರಾ ಕರ್ತಲ್ಯಾ ಲೊಕಾನಿ ಅನಿ ಥೈ ಹೊತ್ತ್ಯಾ ವಿಶ್ವಾಸಿ ಲೊಕಾನಿ ಅಪ್ಲಿ ಮೊಡಿಯಾಂಚಿ ಪುಸ್ತಕಾ ಹಾನುನ್ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ತೆ ಜಾಳ್ವುನ್ ಟಾಕ್ಲ್ಯಾನಿ, ತ್ಯಾ ಪುಸ್ತಕಾಂಚಿ ಕಿಮ್ಮತ್ ಮೆಜುನ್ ಬಗಲ್ಲ್ಯಾ ತನ್ನಾ ಪನ್ನಾಸ್ ಹಜಾರ್ ಚಾಂದಿಚೆ ಪೈಸೆ ಹೊವ್ನ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ಅಶೆ ಧನಿಯಾಚಿ ಖಬರ್ ಲೈ ಪಗ್ಳುನ್ಗೆತ್ ಗೆಲಿ, ಅನಿ ಬಳಾನ್ ವಾಡ್ವಳ್ಕಿ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ಪಾವ್ಲುನ್ ಮೆಸೆದೊನಿಯಾ, ಅನಿ ಅಖಾಯಾ ಮನ್ತಲ್ಯಾ ದೆಶ್ಯಾತ್ನಿ ದಾಟುನ್ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್ಕ್ ನಿರ್ದಾರ್ ಕರುನ್ ಥೈ ಗೆಲ್ಲ್ಯಾ ತನ್ನಾ ರೊಮಾಕ್‍ಬಿ ಭೆಟುಚೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ತಸೆ ಹೊವ್ನ್, ತೆನಿ ಅಪ್ಲೆ ಮಜತ್ ಕಾರಿ ತಿಮೊಥಿ, ಅನಿ ಎರಸ್ತಾಕ್ ಮೆಸೆದೊನಿಯಾಕ್ ಧಾಡುನ್ ದಿವ್ನ್ ಅಪ್ನಿ ಆಸ್ಯಾ ಸಿಮೆತ್ ರಾಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ತ್ಯಾ ಎಳಾರ್ ಎಪೆಸಾತ್ ಧನಿಯಾಚ್ಯಾ ವಾಟೆಚ್ಯಾ ವಿಶಯಾತ್ ಲೈ ಮೊಟೊ ಧಂಗೊ ಉಟಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ದೆವುತ್ರಿ ಮನ್ತಲೊ ಸೊನಾರ್ ಹೊತ್ತೊ, ತೊ ಚಾಂದಿನ್ ಬಾರಿಕ್ ಅರ್ತೆಮಿ ದೆವಿಚಿ ಗುಡಿಯಾ ಕರಿ, ಅನಿ ತೆ ಕಾಮ್ ಕರ್ತಲ್ಯಾಕ್ನಿ ಫಾಯ್ದೊ ಹೊಯ್ ಸಾರ್ಕೆ ಕರಿತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ಕಾಮಾ ಕರ್ತಲ್ಯಾಕ್ನಿ, ಅನಿ ತ್ಯಾತುರ್ ಉಮ್ಮೆದ್ ಹೊತ್ತ್ಯಾಕ್ನಿ ಬಲ್ವುನ್ ಮಾನ್ಸಾನು, ಹ್ಯಾ ಕಾಮಾನಿ ಅಮ್ಕಾ ಫಾಯ್ದೊ ಹೊವ್ಲಾ ಮನ್ತಲೆ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ಅಶೆ ಪಾವ್ಲು ಕಾಯ್ ಕರುಲ್ಲಾ ಮನ್ತಲೆ ತುಮಿ ಬಗಲ್ಲ್ಯಾಸಿ ಅನಿ ಆಯ್ಕಲ್ಲ್ಯಾಸಿ, ಮಾನ್ಸಾಚ್ಯಾ ಹಾತಿನಿ ಕರಲ್ಲೊ ದೆವ್ ನ್ಹಯ್ ಮನುನ್ ಎಸಾತ್ ಎವ್ಡೆ ನ್ಹಯ್ ಸಗ್ಳ್ಯಾ ಆಸಿಯಾ ಪ್ರಾಂತಾತ್ ಬಿ ಸಾಂಗುಲ್ಲಾ ಅನಿ ಲೈ ಲೊಕಾಂಚಿ ಮನಾ ಪರ್ತುಲ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ಅಶೆ ರಾತಾನಾ ಅಮ್ಚ್ಯಾ ಹ್ಯಾ ವ್ಯಾಪಾರಾಚೆ ನಾವ್ ಬುರ್ಶೆ ಹೊವ್ನ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ, ತವ್ಡೆಚ್ ನ್ಹಯ್ ಅಮ್ಚ್ಯಾ ಅರ್ತಮೆ ದೆವತೆಚಿ ಗುಡಿಬಿ ತರಾಸಾತ್ ಹಾಯ್, ತಿಚೆ ಮೊಟೆಪಾನಬಿ ನಾಸ್ ಹೊವ್ನ್ ಜಾತಾ, ಆಸ್ಯಾ ಶಾರಾತ್ಲಿ ಸಗ್ಳಿ ಲೊಕಾ ಪುಜ್ಯಾ ಕರ್‍ತಲೆ ಹಿಚೆ ನಾವ್ ನಾಸ್ ಹೊವ್ನ್ ಜಾತಾ. ");
INSERT INTO kans_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ಹಿ ಬೊಲ್ನಿಯಾ ಆಯ್ಕಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾನ್ ಲೈ ರಾಗಾನ್, ಎಪೆಸಾತ್ಲಿ ಅರ್ತೆಮಿ ದೆವಿಚ್ ಮೊಟಿ! ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ತೆಂಚಿ ಬೊಬ್ ಸಗ್ಳ್ಯಾ ಶಾರಾತ್ ಪಗಳ್ಳಿ ತನ್ನಾ ಮೆಸೆದೊನಿಯಾತ್ಲೊ ಗಾಯ್ ಅನಿ ಅರಿಸ್ತಾರ್ಕಾಕ್ನಿ ಧರುನ್ ಭಾಂದುನ್ ಲೈ ಲೊಕಾ ಗೊಳಾ ಹೊತಲ್ಯಾ ಜಾಗ್ಯಾರ್ ನ್ಹೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ಪಾವ್ಲುನ್ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಇದ್ರಾಕ್ ಜಾವ್ಚೆ ಮನುನ್ ಚಿಂತ್ಲ್ಯಾನ್, ಖರೆ ವಿಶ್ವಾಸಿ ಲೊಕಾನಿ ತೆಕಾ ಜಾವ್ಕ್ ಸೊಡುಕ್ನಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ತವ್ಡೆ ನಸ್ತಾನಾ ಆಸ್ಯಾ ಸಿಮೆತ್ಲ್ಯಾ ಅಧಿಕಾರಿತ್ನಿ ಉಲ್ಲಿ ಲೊಕಾ ಪಾವ್ಲುಚಿ ವಾಂಗ್ಡಿಯಾ ಹೊಲ್ಲ್ಯಾ ಸಾಟ್ನಿ ತೆಂಚ್ಯಾಕ್ನಾ, ತೆಕಾ ಲೊಕಾ ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ಜಾಗ್ಯಾರ್ ಜಾತಲೆ ನಕ್ಕೊ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ಉಲ್ಲಿ ಲೊಕಾ ಎಕ್ ವಿಶಯಾತ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾರ್, ಹುರಲ್ಲಿ ಲೊಕಾ ದುಶ್ರ್ಯಾ ವಿಶಯಾತ್ ಬೊಬ್ ಮಾರುಕ್ಲಾಗಲಿ, ತಾಂಡ್ಯಾತ್ ಲೈ ಗದ್ದಲ್ ಹೊಲೊ, ಅಪ್ನಿ ಥೈ ಕಶ್ಯಾಕ್ ಎಲಾತ್ ಮನ್ತಲೆಚ್ ಲೈ ಲೊಕಾಕ್ನಿ ಗೊತ್ತ್ ನತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಅಲೆಗ್ಸಾಂಡರ್ ಮನ್ತಲ್ಯಾಕ್ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ಫಿಡೆ ಜಾವ್ನ್ ಬೊಲುಕ್ ತೆನಿ ಲೊಕಾಕ್ನಿ ಹಾತಿನ್ ಸೊನ್ನಿ ಕರುನ್ ಗಪ್ಪ್ ರ್‍ಹಾವಾ ಮನುನ್ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ವಾದ್ ಕರುನ್ ಅಪ್ಲ್ಯಾ ಸಾಟ್ನಿ ಬೊಲುಕ್ಲಾಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ಹೊಲ್ಯಾರ್ ಅಲೆಕ್ಸಾಂಡರ್ ಮನ್ತಲ್ಲೊ ಮಾನುಸ್ ಜುದೆವಾಂಚೊ ಮನುನ್ ಕಳಲ್ಲ್ಯಾ ತನ್ನಾ ಲೊಕಾನಿ, ಎಫೆಸ್ ಶಾರಾಚ್ಯಾ ಅರ್ತೆಮಿ ಮನ್ತಲಿ ಮಹಾದೆವಿ! ಮನುನ್ ಎಕುಚ್ ಸಮಾ ದೊನ್ ತಾಸ್ ಪತರ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ತನ್ನಾ ತ್ಯಾ ಶಾರಾತ್ಲ್ಯಾ ಯಜಮಾನಾನ್ ಸಗ್ಳ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಶಾಂತ್‍ ಕರುನ್, ತೆಂಕಾ ಎಪೆಸಾತ್ಲ್ಯಾ ಲೊಕಾನು ಮಳ್ಬಾಕ್ನಾ ಪಡಲಿ ಮೊಟ್ಯಾ ಅರ್ತೆಮೆ ದೆವತೆಚಿ ಗುಡಿ ಅನಿ ತಿಜಿ ಮುರ್ತಿ ರಾಕುನ್ ಘೆವ್ನ್ ಯೆಲ್ಲೆ ಎಪೆಸಾತ್ಲ್ಯಾ ಲೊಕಾನಿಚ್ ಮನ್ತಲೆ ಸಗ್ಳ್ಯಾ ಜಗಾಕುಚ್ ಗೊತ್ತ್ ಹಾಯ್ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ತಸೆ ಹೊವ್ನ್ ಹಿ ಸಂಗ್ತಿಯಾ ನ್ಹಯ್ ಮನುನ್ ಸಾಂಗುಕ್ ಹೊಯ್ನಾ, ತುಮಿ ಶಾಂತ್ ಹೊವ್ನ್ ರಾವ್ಚೆ ಅನಿ ಗಡ್ಬಡಿನ್ ಕಾಯ್ಬಿ ಕರುಕ್ ಜಾವ್ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ತಸೆ ಹೊವ್ನ್ ತುಮಿ ಧರುನ್ ಹಾನಲಿ ಹಿ ಲೊಕಾ ಗುಡಿಯಾ ಚೊರಲಿ ನ್ಹಯ್ ನಾ ತರ್ ದೆವಿಕ್ ಗಾಳಿಯಾ ದಿವ್ನ್ ಬೊಲಲೆ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ಅಶೆ ರಾತಾನಾ ದೆಮೆತ್ರಿ ಅನಿ ತೆಚಿ ಕಾಮಾ ಕರ್ತಲ್ಯಾಕ್ನಿ ಕೊನಾಚ್ಯಾ ವಿರೊದ್‍ಬಿ ಝಗ್ಡೊ ರ್‍ಹಾಲ್ಯಾರ್ ಅಮ್ಚೆ ಅಧಿಕಾರಿ ಹಾತ್, ಅನಿ ಝಡ್ತಿ ಕರ್‍ತಲೊ ಜಾಗೊ ಹಾಯ್, ಥೈ ಜಾವ್ನ್ ತಕ್ರಾರ್ ಸಾಂಗುಕ್ ಹೊತಾ. ");
INSERT INTO kans_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ತುಮಿ ದುಶ್ರೆ ಕಾಯ್ತರಿಬಿ ಬೊಲುಚೆ ಮನುನ್ ಹಾಸಿ ಕಾಯ್? ಬೊಲುಚೆ ಮನುನ್ ಹೊತ್ತೆ ಹೊಲ್ಯಾರ್ ಶಾರಾತ್ಲ್ಯಾ ಮೊಟ್ಯಾ ಝಡ್ತಿಚ್ಯಾ ಬೈಟಕಿಕ್ ಯೆವಾ, ಥೈ ತೆ ನಿರ್ದಾರ್ ಕರುಂವಾ. ");
INSERT INTO kans_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಅಮಿ ಹಿತ್ತೆ ಲೈ ಘಾತ್ಕೊ ಧಂಗೊ ಉಟ್ವುಲಾಂವ್, ಸಗ್ಳ್ಯಾ ಗದ್ದಲಾಕ್ನಿ ಮಾಪಿ ಕರುಕ್ ಕೊನಾಚೆನ್ಬಿ ಹೊಯ್ನಾ ಅನಿ ಸಮಾ ಕಾರನ್ ದಿವ್ಕ್ ಅಮ್ಚ್ಯೆಕ್ಡೆ ಹೊಯ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ಹಿ ಗೊಸ್ಟಿಯಾ ಸಾಂಗ್ಲ್ಯಾ ಮಾನಾ ತೆನಿ ಥೈ ಗೊಳಾ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಚೆ ಬೈಟಕ್ ಮುಗಸ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ದಾಂದಲ್ ಇಬೆ ಹೊತ್ತ್ಯಾ ಮಾನಾ, ಪಾವ್ಲುನ್ ವಿಶ್ವಾಸಿ ಲೊಕಾಕ್ನಿ ಗೊಳಾ ಕರುನ್ ತೆಂಕಾ ಧೈರ್ಯಾಚಿ ಗೊಸ್ಟಿಯಾ ಸಾಂಗುನ್, ಅನಿ ಜಾವ್ನ್ ಯೆತಾ ಮನುನ್ ಮೆಸೆದೊನಿಯಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ತೊ ತ್ಯಾ ಶಾರಾತ್ನಿ ಫಿರುನ್ಗೆತ್ ಉಲ್ಲ್ಯಾ ಗಾಂವಾಕ್ನಿ ಭೆಟ್ಲ್ಯಾನ್, ಜೆಜುಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಉಲ್ಲಿ ಸಂಗ್ತಿಯಾ ಸಾಂಗುನ್ ಬಳ್‍ ದಿಲ್ಲ್ಯಾನ್, ಮಾನಾ ಪಾವ್ಲು ಗ್ರಿಸಿ ಮನ್ತಲ್ಯಾ ಅಖಾಯಿಯಾಕ್ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ಪಾವ್ಲು ಥೈ ತಿನ್ ಮ್ಹೈನೆ ಪತರ್ ಹೊತ್ತೊ, ತೊ ಸಿರಿಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಜಾವ್ಕ್ ತಯಾರ್ ಹೊವ್ನ್ ರ್‍ಹಾತಾ, ಹೊಲ್ಯಾರ್ ಉಲ್ಲ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ ವಿರೊಧ್ ಹೊವ್ನ್ ಯವ್ಜನ್ ಕರ್‍ಲ್ಯಾನಿ, ತೆಚ್ಯಾಸಾಟ್ನಿ ಪಾವ್ಲುನ್ ಸಿರಿಯಾ ಮನ್ತಲ್ಲ್ಯಾ ಶಾರಾಕ್ ಮೆಸೆದೊನಿಯಾಕ್ನಾ ಪಾಟಿ ಪರ್ತುನ್ ಜಾವ್ಚೆ ಮನುನ್ ನಿರ್ಧಾರ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ಬೆರೆಯಾತ್ಲೊ ಪುರ್ರ್ ಮನ್ತಲ್ಯಾಚೊ ಲೆಕ್ ಸೊಪತ್ರ್ ಥೆಸಲೊನಿಕಾತ್ಲೊ ಅರಿಸ್ತಾರ್ಕ್, ಅನಿ ಸೆಕುಂದ್ ದರ್ಬೆಚೊ ಗಾಯಸ್, ಅನಿ ಆಸಿಯಾ ಪ್ರಾಂತ್ಯಾತ್ಲೊ ತುಕಿಕ್, ತ್ರೊಪಿಮ್ ಅನಿ ತಿಮೊಥಿ ಹೆನಿ ಸಗ್ಳೆ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ತೆನಿ ಜಾತಲ್ಯಾ ಅದ್ದಿಚ್ ಜಾವ್ನ್ ತ್ರೊವಾಸ್ ಶಾರಾತ್ ಅಮ್ಚ್ಯಾ ಸಾಟ್ನಿ ರಾಕುನ್ಗೆತ್ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ಫುಗ್ ನಸಲ್ಲ್ಯಾ ಬಾಕ್ರಿಚ್ಯಾ ಸನಾಚ್ಯಾ ಮಾನಾ ಅಮಿ ಫಿಲಿಪ್ಪಿ ಮನ್ತಲ್ಯಾ ಶಾರಾಚ್ಯಾ ಢೊನಿತ್ ಗೆಲಾಂವ್, ಪಾಚ್ ದಿಸಾ ಕಳದ್ಲ್ಯಾ ಮಾನಾ ಅಮಿ ತೆಂಕಾ ತ್ರೊವಾಸ್ ಶಾರಾತ್ ಭೆಟ್ಲ್ಯಾಂವ್ ಅಮಿ ಥೈ ಸಾತ್ ದಿಸಾ ರಾಲ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ಸಬ್ಬತಾಚ್ಯಾ ದಿಸಿ, ಅಮಿ ಸಗ್ಳ್ಯೆ ಭಾಕ್ರಿ ಮೊಡುಕ್ ಎಕ್ ಹೊವ್ನ್ ಮಿಳುನ್ ಯೆಲ್ಲ್ಯಾಂವ್, ಪಾವ್ಲು ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲಲ್ಯಾ ದುಸ್ರ್ಯಾಂದಿಸಿ ತೊ ಥೈತ್ನಾ ಸೊಡುನ್ ಜಾನಾರ್ ಹೊತ್ತೊ, ತಸೆ ಹೊವ್ನ್ ತೆನಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಅರ್ದ್ಯಾ ರಾತ್ತಿನ್ ಪಾತರ್ಬಿ ಬೊಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ಅಮಿ ಬಸಲ್ಲ್ಯಾ ಮಾಳ್ಗಿಚ್ಯಾ ಖೊಲಿತ್ ಲೈ ದಿವೆ ಪೆಟ್ವಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ಯುತಿಕ್ ಮನ್ತಲೊ ದಾಂಡ್ಗೊ ಝಿಲ್ಗೊ ಕಿಡ್ಕಿರ್ ಬಸುನ್ ನಿಜೆನ್ ಝಮುನ್ಗೆತ್ ಹೊತ್ತೊ, ಪಾವ್ಲು ಬೊಲಿತ್ ರ್‍ಹಾತಾನಾಚ್ ತೊ ಝಿಲ್ಗೊ ತಿನ್ವಾ ಮಾಳ್ಗಿ ವೈನಾ ಪಡ್ಲೊ, ಲೊಕಾನಿ ಖಾಲ್ತಿ ಉತ್ರುನ್ ತೆಕಾ ಉಕ್ಲುನ್ ಬಗಲ್ಲ್ಯಾ ತನ್ನಾ ತೊ ಮರುನ್ ಪಡಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ಪಾವ್ಲುನ್ ಖಾಲ್ತಿ ಉತ್ರುನ್ ಜಾವ್ನ್ ತೆಕಾ ಟೆಕ್ಕೊ ಮಾರುನ್ ಧರುನ್ ಘೆವ್ನ್ “ಚಿಂತಾ ಕರುನಕಾಸಿ ತೊ ಝಿತ್ತೊ ಹೊಲಾ” ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ತನ್ನಾ ತೆನಿ ಅನಿ ಪರ್ತುನ್ ಮಾಳ್ಗಿಕ್ ಜಾವ್ನ್ ಭಾಕ್ರಿ ಮೊಡುನ್ ಜೆವಾನ್ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಉಜ್ವಾಡಿ ಪತರ್ಬಿ ಬೊಲ್ಯಾನ್, ಮಾನಾ ಗೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ತೆನಿ ಝಿತ್ತೊ ಹೊತ್ತ್ಯಾ ದಾಂಡ್ಗ್ಯಾ ಝಿಲ್ಗ್ಯಾಕ್ ಘರಾಕ್ ಬಲ್ವುನ್ ಹಾನ್ತಾನಾ ತೆಂಕಾ ಲೈ ಕುಶಿ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ಅಮಿ ಪಿಡೆ ಢೊನಿತ್ನಾ ಜಗ್ಗೊಳ್ ಜಾವ್ನ್ ಅಸ್ಸೊಸ್ಸಿ ಶಾರಾಕ್ ಜಾವ್ಕ್ ಲಾಗಲಾಂವ್ , ಅನಿ ಪಾವ್ಲುಕ್‍ಬಿ ಅಮ್ಚ್ಯಾಕ್ನಾ ನ್ಹೆವ್ಚೆ ಮನುನ್ ಚಿಂತಲಾಂವ್, ತೊ ಪಾಯ್ ವಾಟೆನ್ ಚಲುನ್ ಥೈ ಜಾನಾರ್ ಹೊಲ್ಲೊ, ತೆಚ್ಯಾ ಸಾಟ್ನಿ ತೆನಿ ಅಮ್ಕಾ ತಯಾರಿ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ತಸೆಚ್ ತೊ ಅಸ್ಸೊಸ್ಸಿತ್ ಅಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಮಿಳ್ವುನ್ ಘೆಟ್ಲ್ಯಾನ್, ತನ್ನಾ ಅಮಿ ತೆಕಾಬಿ ಅಮ್ಚ್ಯಾ ಢೊನಾತ್ ಚಡ್ವುನ್ ಘೆವ್ನ್ ಮಿಲೆತಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ಗೆಲ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ತೆನಿ ಜಾವ್ಕ್ಲಾಗಲೆ ಅಮಿ ದುಸ್ರ್ಯಾ ದಿಸಿ ಖಿಯೊಸ್ ದ್ವಿಪಾಚ್ಯಾ ಇದ್ರಾಕ್ ಹೊತ್ಯಾ ಜಾಗ್ಯಾಕ್ ಯೆಲಾಂವ್, ತೆಚ್ಯಾ ದುಸ್ರೆ ದಿಸಿ ಸಾಮಾಸಾಕ್ ಪಾಲ್ಲ್ಯಾಂವ್, ಅನಿ ತೆಚ್ಯಾ ದುಸ್ರೆ ದಿಸಿ ಮಿಲೆತಾತ್ ಯೆವ್ನ್ ಪಾಲ್ಲ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ಪಾವ್ಲುನ್ ಆಶಿಯಾ ಪ್ರಾಂತ್ಯಾತ್ ಅಪ್ಲಿ ದಿಸಾ ಕಳ್ದುಕ್ ಮನ್ ನಸ್ತಾನಾ ಎಪೆಸಾ ಶಾರಾಕ್ ದಾಟುನ್ ಜಾವ್ಚೆ ಮನುನ್ ನಿರ್ಧಾರ್ ಕರ್‍ಲ್ಯಾನ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಹೊತಾ ತೊವ್ಡೆ ಲಗುನಾಚ್ ಪಂತೆಕೊಸ್ತಾ ದಿಸಿ ಜೆರುಜೆಲೆಮಾಕ್ ಜಾವ್ನ್ ಪಾವ್ನಾರ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ಪಾವ್ಲುನ್ ಮಿಲೆತಾಕ್ನಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಮುಂಖಡಾಕ್ನಿ ಅಪ್ನಾಕ್ ಭೆಟುಚೆ ಮನುನ್ ಖಬರ್ ಧಾಡುನ್ ಅಪ್ನಾಕ್ಡೆ ಬಲ್ವುಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ಮಿಯಾ ಎಶ್ಯಾ ಸಿಮೆತ್ ಪಾಯ್ ಥವಲ್ಯಾ ಅದ್ದಿಚ್ಯಾ ದಿಸಾಕ್ನಾ ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ಸಗ್ಳ್ಯಾ ಯೆಳಾರ್ಬಿ ಕಸೊ ರ್‍ಹಾಲೊ ಅನಿ ಕಸೊ ಎಳ್ ಕಳದ್ಲೊ ಮನ್ತಲೆ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾನಿ ಮಾಕಾ ವಿರೊದ್ ಹೊವ್ನ್ ಕರಲ್ಲ್ಯಾ ಘುಟ್ಟಾನಿ ಡೊಳ್ಯಾತ್ನಿ ಪಾನಿ ಘಾಲುನ್ಗೆತ್ ಧನಿಯಾಚ್ಯಾ ಸೆವಕಾನ್ ಸಾರ್ಕೆ ಮಾಜೆ ಕಾಮ್ ಕರುನ್ಗೆತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ಮಿಯಾ ತುಮ್ಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಇದ್ರಾಕ್ ತುಮ್ಚ್ಯಾ ಘರಾಕ್ನಿ ಯೆವ್ನ್ ತುಮ್ಕಾ ಮಜ್ಜತ್‍ಕಾರಿ ಹೊವ್ನ್ ಹೊತ್ತೊ, ಅನಿ ತುಮ್ಕಾ ಶಿಕಾಪಾಕರುಕ್ ಫಾಟಿ ಸರ್ಕುಕ್ನಾ ಹೆ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ಮಿಯಾ ಜುದೆವಾಕ್ನಿ ಅನಿ ಗ್ರಿಕಾಂಚ್ಯಾ ಲೊಕಾಕ್ನಿ ತೆನಿ ಪಾಪ್ ಸೊಡುನ್ ದೆವಾಕ್ಡೆ ಪರ್ತುನ್ ಯೆವ್ಚೆ, ಅನಿ ಧನಿಯಾ ಜೆಜುಚ್ಯಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಥವ್ಚೆ ಮನುನ್ ಸಾಂಗ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ಅನಿ ಅತ್ತಾ ಮಿಯಾ ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾಕ್ ಮಾನುನ್ ಘೆವ್ನ್ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್ಕ್ ಲಾಗ್ಲಾ, ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಕಾಯ್ ಹೊತಾ ಮನ್ತಲೆ ಮಾಕಾ ಗೊತ್ತ್ ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ಹರ್ ಎಕ್ ಬಂಧಿಖಾನೊ ಅನಿ ತರಾಸಾ ತುಜಿ ವಾಟ್ ರಾಕಿತ್ ಹಾತ್ ಮನುನ್ ಪವಿತ್ರ್ ಆತ್ಮೊ ಮಾಕಾ ಹುಶ್ಯಾರ್ಕಿ ದಿಯ್ತ್ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ಕಾಯ್ ಬಿ ಹೊಂವ್ದಿತ್, ಮಿಯಾ ಮಾಜ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಜಿವಾಚ್ಯಾ ವಿಶಯಾತ್ ಚಿಂತಾ ಕರಿನಾ ಮಾಕಾ ಧನಿಯಾ ಜೆಜುನ್ ದಿಲ್ಲಿ ಎಕುಚ್ ಗುರಿ ಹಾಯ್, ಮಾಜೆ ಪಳಾಪ್ ಮಿಯಾ ಪಳುನ್ ಸಾರುಚೆ, ತೆ ದೆವಾಚ್ಯಾ ಬರ್‍ಯಾ ಖಬ್ರೆಚ್ಯಾ ಕುರ್ಪೆಕ್ ಸಾಕ್ಷಿ ಹೊತಲ್ಲೆ ಹೊವ್ನ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ಅತ್ತಾ ಮಾಜ್ಯಾಕ್ಡೆ ಆಯ್ಕಾ ತುಮ್ಚೊ ಎಕ್ಲೊಬಿ ಮಾಕಾ ಅನಿ ಕನ್ನಾಬಿ ಬಗಿನಾಸಿ ಮನ್ತಲೆ ಮಾಕಾ ಗೊತ್ತ್ ಹಾಯ್, ತುಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ವೆಳಾರುಚ್ ದೆವಾಚ್ಯಾ ವಿಶಯಾಚೆ ಖಬರ್ ಮಿಯಾ ತುಮ್ಕಾ ಸಾಂಗ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ತಸೆ ಹೊವ್ನ್, ಮಿಯಾ ಖರೆಚ್ ಸಾಂಗ್ತಾ ತುಮ್ಚ್ಯಾತ್ ಕೊನ್‍ತರಿಬಿ ನಾಸ್ ಹೊವ್ನ್ ಗೆಲ್ಯಾಕ್ ಮಿಯಾ ತೆಕಾ ಹೊನೆಗಾರ್ ನ್ಹಯ್. ");
INSERT INTO kans_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಎಕ್ ಬಿ ದಾಪುನ್ ಥೈ ನಸ್ತಾನಾ ದೆವಾಚೊ ಉದ್ದೆಶ್ ಕಾಯ್ ಮನ್ತಲೆ ಮಿಯಾ ತುಮ್ಕಾ ಕಳ್ವುಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ತುಮ್ಕಾಚ್ ತುಮಿ ತೆಚ್ಯಾ ಹುಶ್ಯಾರ್ಕಿನ್ ರಾಕುನ್ ಘೆವಾ. ಪವಿತ್ರ್ ಆತ್ಮ್ಯಾನ್ ತ್ಯಾ ದಿಸಿ ತುಮ್ಕಾ ದಿಲ್ಯಾ ಬಕ್ರಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ ಉಶಾರ್ಕಿನ್ ಬಗುನ್ಗೆವಾ, ದೆವಾಚ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಬಕ್ರಿಯಾ ರಾಕ್ತಲ್ಯಾಂಚ್ಯಾ ಸಾರ್ಕೆ ರ್‍ಹಾವಾ, ತೆ ತೆನಿ ಅಪ್ಲ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಲೆಕಾಚ್ಯಾ ರಗ್ತಾನ್ ಇಕಾತ್ ಘೆಟ್ಲಾ . ");
INSERT INTO kans_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ಮಿಯಾ ಸೊಡುನ್ ಗೆಲ್ಲ್ಯಾ ಮಾನಾ ಕ್ರುರ್ ಝುಲ್ ಕುತ್ರಿ ತುಮ್ಚ್ಯಾಕ್ಡೆ ಯೆತಾತ್ ಅನಿ ತೆನಿ ಬಕ್ರ್ಯಾಂಚ್ಯಾ ತಾಂಡ್ಯಾಕ್ನಿ ಸೊಡಿನಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ಝುಟಿ ಶಿಕಾಪಾ ಸಾಂಗುನ್ ತುಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಉಲ್ಲ್ಯಾ ವಿಶ್ವಾಸಿ ಲೊಕಾಕ್ನಿ ವಡುನ್ ನ್ಹೆತಲಿ ಲೊಕಾಬಿ ಹಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ತೆಸೆ ಹೊವ್ನ್, ಮಿಯಾ ರಡುನ್ಗೆತ್ ತಿನ್ ವರ್ಸಾಚೊ ದಿಸ್ ತುಮ್ಚ್ಯಾತ್ಲ್ಯಾ ಹರ್ ಎಕ್ಲ್ಯಾಕ್ಬಿ ಶಿಕ್ವಲ್ಲೆ ಹುಶ್ಯಾರ್ಕಿನ್ ಯಾದ್ ಥವ್ನ್ ಘೆವಾ”. ");
INSERT INTO kans_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ಅತ್ತಾ ಮಿಯಾ ತುಮ್ಕಾ ದೆವಾಚ್ಯಾ, ಅನಿ ತೆಚ್ಯಾ ಕುರ್ಪೆಚ್ಯಾ ಬರ್‍ಯಾ ಖಬ್ರೆಚ್ಯಾ ಜಗ್ಗೊಳ್ ಒಪ್ಸುನ್ ದಿತಾ,ತೆಕಾ ತುಮ್ಕಾ ಪವಿತ್ರ್ ಕರ್ತಲಿ ಬಳ್ ಹಾಯ್, ಅನಿ ತುಮ್ಕಾ ದೆವ್ ಅಪ್ಲ್ಯಾ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ದಿತಲೊ ಆಶಿರ್ವಾದ್ ದಿತಾ, ");
INSERT INTO kans_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ಮಿಯಾ ಕೊನಾಚ್ಯಾ ಸೊನೆ ನಾ ತರ್ ಚಾಂದಿಕ್ನಿ ಹೊಂವ್ದಿ ಕಪ್ಡ್ಯಾಕ್ನಿ ಹೊಂವ್ದಿ ಆಸ್ಯಾ ಕರುಕ್ನಾ. ");
INSERT INTO kans_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ಮಿಯಾ ಮಾಜ್ಯಾ ಸ್ವತಾಚ್ಯಾ ಹಾತಾನಿ ರಾಬುನ್ ಮಾಜಿ ಅನಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾಂಚಿ ಗರ್ಜ್ ಪುರಾ ಕರ್ಲಾ, ಹೆ ತುಮ್ಕಾ ಗೊತ್ತ್ ಹಾಯ್. ");
INSERT INTO kans_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ಸಗ್ಳ್ಯಾ ವಿಶಯಾಕ್ನಿ ಮಿಯಾಚ್ ತುಮ್ಕಾ ಉದಾರನ್ ದಾಕ್ವುನ್ ದಿಲಾ, ತುಮಿ ಬಿ ತಸೆಚ್ ರಾಬುನ್ ಬಳ್ ನಸಲ್ಯಾಕ್ನಿ ಮಜ್ಜತ್ ಕರುಚೆ ಅನಿ “ಘೆತಲ್ಯಾಚ್ಯಾಕಿಂತಾ ದಿತಲ್ಯಾತ್ ಲೈ ಆಶಿರ್ವಾದ್ ಹಾಯ್” ಮನುನ್ ಧನಿಯಾ ಜೆಜುನ್ ಸಾಂಗಲಿ ಗೊಸ್ಟ್ ಯಾದ್ ಥವ್ನ್ ಘೆವಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ಹಿ ಗೊಸ್ಟಿಯಾ ತೆನಿ ಸಾಂಗಲ್ಲ್ಯಾ ಮಾನಾ ತೆಂಚ್ಯಾ ಸಗ್ಳ್ಯಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಡೊಗ್ಲಾ ಘಾಲುನ್ ಮಾಗ್ನಿ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ಮಾನಾ ತೆನಿ ಸಗ್ಳ್ಯಾನಿ ರಡ್ಲ್ಯಾನಿ, ಅನಿ ಪಾವ್ಲುಕ್ ಯಾಂಗ್ ಮಾರುನ್, ಉಪ್ಪಾ ದಿವ್ನ್ ಜಾವ್ನ್ ಯೆ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ತೆನಿ ಅನಿ ಕನ್ನಾಬಿ ಮಾಕಾ ಪರ್ತುನ್ ಬಗುಕ್ ಹೊಯ್ನಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾಕ್ ತೆನಿ ಲೈ ದುಖ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನಿ, ಅನಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ತೆನಿ ಢೊನ್ಯಾ ಪತರಬಿ ಜಾವ್ನ್ ತೆಕಾ ಧಾಡುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ಅಮಿ ಸಗ್ಳೆ ಜಾಂನ್ತ್ಯಾಕ್ನಿ ಧಾಡುನ್ ದಿವ್ನ್ ಢೊನಾತ್ನಾ ಕೊಸ್ ಮನ್ತಲ್ಯಾ ದ್ವಿಪಾಕ್ ಗೆಲ್ಲ್ಯಾಂವ್, ದುಸ್ರ್ಯಾಂದಿಸಿ ರೊದಾಕ್ ಪಾವುನ್ ಅನಿ ಥೈತ್ನಾ ಪತಾರಾಕ್ ಗೆಲಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ಪೊಯಿನಿಕ್ಯಾಕ್ ಜಾತಲಿ ಢೊನ್ ಚಡುನ್‍ ಅಮಿ ಪ್ರಯಾನ್ ಕರುಕ್ ಲಾಗ್ಲಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ಅಮಿ ಸೈಪ್ರಸ್ ದ್ವಿಪಾಕ್ ಬಗುನ್ ಢಾವ್ಯಾಭಾಜುಕ್ ಸೊಡುನ್ ಸಿರಿಯಾ ದೆಶ್ಯಾಕ್ಡೆ ಜಾವ್ನ್, ತಿರ್ ಶಾರಾತ್ ಢೊನ್ ಇಬೆಕರ್ಲ್ಯಾಂವ್, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಥೈ ಢೊನಾತ್ನಾ ಸಾಮಾನ್ ಉತರ್ತಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ಅಮಿ ಥೈ ಉಲ್ಲಿ ಶಿಸಾಕ್ನಿ ಬಗುನ್, ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಸಾತ್ ದಿಸಾ ಹೊತ್ತಾಂವ್, ಅನಿ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಪವಿತ್ರ್ ಆತ್ಮೊ ಹೊತ್ತೊ ಬಗಟ್ಲ್ಯಾವ್, ತೆನಿ ಪಾವ್ಲುಕ್ ತಿಯಾ ಜೆರುಜಲೆಮಾಕ್ ಜಾವ್ ನಕ್ಕೊ ಮನುನ್ ಹುಶ್ಯಾರ್ಕಿ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ತಿ ದಿಸಾ ಕಳದ್ಲ್ಯಾ ಮಾನಾ ಅಮಿ ಜಾತಾನಾ ಥೈತ್ಲಿ ಲೊಕಾ ಸಗ್ಳ್ಯಿ ಅಪ್ಲ್ಯಾ ಬಾಯ್ಕೊ ಪೊರಾಕ್ನಿಬಿ ವಾಂಗ್ಡಾ ಘೆವ್ನ್ ಅಮ್ಕಾ ಪಾವ್ಸುಕ್ ಶಾರಾಚ್ಯಾ ಭಾಯ್ರ್ ಯೆಲ್ಯಾನಿ ಅನಿ ಅಮಿ ಸಮುಂದರಾಚ್ಯಾ ದಂಡೆಕ್ ಡೊಗ್ಲಾ ಘಾಲುನ್ ಮಾಗ್ನೆ ಕರುನ್. ");
INSERT INTO kans_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ಎಕಾಮೆಕಾಕ್ ಜಾವ್ನ್ ಯೆತಾ ಮನುನ್ ಸಾಂಗುನ್ ಢೊನ್ ಚಡ್ಲಾಂವ್ ತೆನಿ ಅಪ್ಲ್ಯಾ ಘರಾಕ್ನಿ ಫಾಟಿ ಪರ್ತುನ್ ಗೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ಅಮಿ ತುರ್ ಶಾರಾತ್ನಾ ಅಮ್ಚೆ ಪ್ರಯಾನ್ ಫಿಡೆ ಕರುನ್ ಪ್ತೊಲೊಮಾ ಮನ್ತಲೊ ಶಾರಾಕ್ ಗೆಲ್ಯಾಂವ್ ಥೈ ಹೊತ್ತ್ಯಾ ದೆವಾಚೆರ್ ವಿಶ್ವಾಸ್ ಥವಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ವಂದನ್ ಕರುನ್ ಎಕ್ ದಿಸ್ ಥೈ ಹೊತ್ತ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ದುಸ್ರೆ ದಿಸಿ ಸೆಜಾರೆಯ ಶಾರಾಕ್ ಯೆವ್ನ್ ಪಾವ್ನ್ ಫಿಲಿಪ್ಪಾಚ್ಯಾ ಘರಾತ್ ರಾಲ್ಯಾಂವ್, ಬರಿ ಖಬರ್ ಲೊಕಾಕ್ನಿ ಪರ್ಗಟ್ ಕರ್ತಲೆಚ್ ಹೆಜೆ ಕಾಮ್, ಹ್ಯೊ ಜೆರುಜಲೆಮಾಕ್ ಮಜತ್ ಕಾರಿ ಕರುನ್ ಎಚುನ್ ಕಾಡಲ್ಲ್ಯಾ ಸಾತ್ ಲೊಕಾತ್ನಿ ಎಕ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ತೆಕಾ ಲಗಿನ್ ಹೊವ್ ನಸಲ್ಲಿ ಲೆಕಿಯಾ ಹೊತ್ತಿ, ತೆನಿ ದೆವಾಚಿ ಬರಿ ಬಖರ್ ಪ್ರವಾದನ್ ಕರ್‍ತಲೆ ಹೊಲ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ಅಮಿ ಥೈ ಜಾವ್ನ್ ಉಲ್ಲಿ ದಿಸಾ ಹೊಲ್ಯಾ ಮಾನಾ ಅಗಬ್ ಮನ್ತಲೊ ಎಕ್ಲೊ ಪ್ರವಾದಿ ಜುದೆಯಾಕ್ನಾ ಯೆಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ತೆನಿ ಅಮ್ಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ , ಪಾವ್ಲುಚೊ ಖಬ್ರೆಚೊ ಪಟ್ಟೊ ಕಾಡುನ್ ಘೆವ್ನ್ ಅಪ್ಲಿ ಹಾತಾ ಪಾಯಾ ಭಾಂದುನ್ ಘೆವ್ನ್ ಹ್ಯೊ ಕಂಬ್ರೆಚೊ ಪಟ್ಟೊ ಕೊನಾಚೊ, ತ್ಯಾ ಮಾನ್ಸಾಕ್ ಜೆರುಜಲೆಮಾತ್ಲಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಅಶೆ ಬಾಂಧುನ್ ಘಾಲ್ತಾತ್, ಅನಿ ತೆನಿ ತೆಕಾ ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಹಾತಿತ್ ಒಪ್ಸುನ್ ದಿತ್ಯಾತ್, ಮನುನ್ ಪವಿತ್ರ್ ಆತ್ಮೊ ಸಾಂಗುಲ್ಲಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ಅಮಿ ಹಿ ಬೊಲ್ನಿಯಾ ಆಯ್ಕಲ್ಲ್ಯಾ ತನ್ನಾಚ್ ಪಾವ್ಲುಕ್ ಜೆರುಜಲೆಮಾಕ್ ಜಾತಲೆ ಅನಿ ಥೈ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ ನಕ್ಕೊ ಮನುನ್ ಮಾಗುನ್ ಘೆಟ್ಲ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ಖರೆ ಪಾವ್ಲುನ್ ತುಮಿ ಕಶ್ಯಾಕ್ ರಡುನ್ಗೆತ್ ಮಾಜೆ ಹಿರ್‍ದೆ ಫುಟಿ ಸಾರ್ಕೆ ಕರುಲ್ಲ್ಯಾಸಿ? ಮಿಯಾ ಜೆರುಜಲೆಮಾತ್ ಬಂಧಿಹೊವ್ಕ್ ಥವ್ಡೆಚ್ ನ್ಹಯ್ ಧನಿಯಾ ಜೆಜುಚ್ಯಾ ನಾವಾಸಾಟಿ ಮರುಕ್ಬಿ ತಯಾರ್ ಹಾಂವ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ತೆನಿ ಒಪ್ಪಿನಸ್ತಾನಾ ಹೊತ್ತ್ಯಾ ಸಾಟ್ನಿ ಧನಿಯಾಚ್ಯಾ ಇಚ್ಚಾ ಸಾರ್ಕೆ ಹೊಂವ್ದಿ ಮನುನ್ ಗಪ್ಪ್ ರಾಲ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ಉಲ್ಲಿ ದಿಸಾ ಕಳದಲ್ಲ್ಯಾ ಮಾನಾ ಅಮಿ ತಯಾರ್ ಹೊವ್ನ್ ಜೆರುಜಲೆಮಾಕ್ ಗೆಲ್ಯಾಂವ್. ");
INSERT INTO kans_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ಸೆಜಾರಾಕ್ನಾ ಉಲ್ಲಿ ಶಿಸಾಲೊಕಾ ಅಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆವ್ನ್ ಅಮಿ ಜಾವ್ನ್ ರ್‍ಹಾತಲ್ಯಾ ಘರಾಪತರ್ ಅಮ್ಕಾ ಪಾವಸ್ಲ್ಯಾನಿ, ತ್ಯಾ ಘರಾತ್ಲೊ ಮಾನುಸ್ ಅದ್ದಿಚ್ಯಾ ಶಿಸಾತ್ನಿ ಎಕ್ಲೊ ಹೊವ್ನ್ ಹೊತ್ತೊ ಸೈಪುಸಾತ್ಲೊ ಮಾನುಸ್ ಮನ್ತಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ಅಮಿ ಜೆರುಜಲೆಮಾಕ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ವಿಶ್ವಾಸಿ ಲೊಕಾನಿ ಅಮ್ಕಾ ಉಮ್ಮೆದಿನ್ ಸ್ವಾಗತ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ದುಸ್ರ್ಯಾಂದಿಸಿ ಪಾವ್ಲುನ್ ಅಮ್ಕಾ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಜಾಕೊಬಾಕ್ ಭೆಟುಕ್ ನ್ಹೆಲ್ಯಾನ್, ತನ್ನಾ ಮುಖಂಡಾ ಸಗ್ಳಿ ಥೈ ಮಿಳುನ್ ಯೆಲ್ಲಿ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ಪಾವ್ಲುನ್ ತೆಂಕಾ ನಮಸ್ಕಾರ್ ಕರುನ್ಗೆತ್, ದೆವಾನ್ ಕರಲಿ ಸಗ್ಳಿ ಕಾಮಾಬಿ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಮದ್ದಿ ಸಾಂಗುನ್ಗೆಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ತೆನಿ ಹೆ ಆಯಿಕ್ಲ್ಯಾನಿ ದೆವಾಕ್ ಸ್ತುತಿ ಕರ್‍ಲ್ಯಾನಿ, ಅನಿ ತೆನಿ ಪಾವ್ಲುಕ್ ಭಾವಾ, ಹಜಾರ್ಘಟ್ಲಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ವಿಶ್ವಾಸಿ ಹೊವ್ನ್ ಬದಲಲ್ಲೆ ತಿಯಾ ಬಗುಕ್ ಲಾಗ್ಲೈಯ್, ಅನಿ ಖಾಯ್ದ್ಯಾಂಚೆ ಪುಸ್ತಕ್ ದೆವಸ್ಪಾನ್ ವಾಚುಲ್ಲಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಮದ್ದಿ ಜಿವನ್ ಕರ್‍ತಲ್ಯಾ ಜುದೆವಾಕ್ನಿ ತುಮ್ಚ್ಯಾ ಪೊರಾಕ್ನಿ ಸುನ್ನತ್ ಕರ್ಸುನಕಾಸಿ, ತೆಂಚಿ ಪದ್ದತಿಯಾ ಕರುನಕಾಸಿ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಕ್ನಿ ಮಾನುನಕಾಸಿ ಮನುನ್ ತಿಯಾ ಶಿಕಾಪಾ ಕರುಲೈಯ್ ಮನುನ್ ತುಜ್ಯಾ ವಿಶಯಾತ್ ಸಾಂಗುಲ್ಲಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ಅತ್ತಾ ಅಮಿ ಕಾಯ್ ಕರುವಾ? ತಿಯಾ ಹಿತ್ತೆ ಯೆಲ್ಲಿಖಬರ್ ಜುದೆವ್ಯಾಚ್ಯಾ ವಿಶ್ವಾಸಿ ಲೊಕಾಕ್ನಿ ಕಳ್ತಾ. ");
INSERT INTO kans_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ಹೊಲ್ಯಾರ್ ಅತ್ತಾ ತಿಯಾ ಕಾಯ್ ಕರುಚೆ ಮನುನ್ ಅಮಿ ತುಕಾ ಸಾಂಗ್ತಾವ್ ಅಮ್ಚ್ಯಾ ಲೊಕಾತ್ನಿ ಚಾರ್ ಜನಾನಿ ದೆವಾಕ್ಡೆ ಆನ್ ಕರುನ್ಗೆಟ್ಲ್ಯಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ತಿಯಾ ತೆಂಕಾ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ತೆಂಚ್ಯಾ ವಾಂಗ್ಡಾ ತುಕಾಬಿ ನಿತಳ್ ಕರುನ್ಗೆತ್ ತೆಂಚೆ ಹರಕೆ ಪಾವ್ಸು, ಅಶೆ ಕರ್‍ತಾನಾ ತುಜ್ಯಾ ವಿಶಯಾತ್ ತೆನಿ ಆಯ್ಕಲಿ ಖಬ್ರಿಯಾ ಖರೆ ನ್ಹಯ್ ಮನುನ್, ಅನಿ ತಿಯಾ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಚ್ಯಾ ಸಾರ್ಕೆ ಚಲ್ತೈಯ್ ಮನುನ್ ಕಳ್ವುನ್ ಘೆತಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ಜುದೆವ್ ನ್ಹಯ್ ಹೊತ್ತ್ಯಾ ವಿಶ್ವಾಸಿ ಲೊಕಾಕ್ನಿ ಅಮಿ ಎಕ್ ಚಿಟ್ ಅತ್ತಾ ಹಾಲಿ ಧಾಡುನ್ ಹೊಲಾ ಮುರ್ತಿಯಾಕ್ನಿ ಭೆಟ್ವಲ್ಲೊ ಖಾನ್ ಖಾವ್ನಕಾಸಿ, ರಗಾತ್ ಖಾವ್ನಕಾಸಿ, ಗಳೊ ಚಿರ್ಡುನ್ ಜಿವ್ ಕಾಡಲ್ಯಾ ಜನಾವರಾಂಚೆ ಮಾಸ್ ಖಾವ್ನಕಾಸಿ, ಕಸ್ಲೊಬಿ ಲೈಂಗಿಕ್ ಪಾಪ್ ಕರುನಕಾಸಿ, ಮನುನ್ ತ್ಯಾ ಚಿಟಿತ್ ಲಿವ್ನ್ ಹೊಲಾ ಮಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ತನ್ನಾ ಪಾವ್ಲುನ್ ತ್ಯಾ ಚಾರ್ ಜನಾಕ್ನಿ ಅಪ್ನಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನ್, ದುಸ್ರೆ ದಿಸಿ ಪಾವ್ಲುನ್ ಶುದ್ಧಾಚಾರಾಚ್ಯಾ ವ್ರತಾತ್ ಭಾಗ್ ಘೆಟ್ಲ್ಯಾನ್, ಮಾನಾಸರ್ ತೆನಿ ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ ಜಾವ್ನ್ ಶುದ್ದಾಚಾರಾಚಿ ನೆಮಾ ಸಗ್ಳಿ ಸಾರ್‍ತಲೆ ದಿಸಾ ಪರ್ಗಟ್ ಕರ್‍ಲ್ಯಾನ್, ಆಕ್ರಿಚ್ಯಾ ದಿಸಾತ್ನಿ ಹರ್ ಎಕ್ಲೊ ಮಾನುಸ್ ಬಲಿ ದಿತಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ತಿ ಸಾತ್ ದಿಸಾ ಸರ್ತಲ್ಯಾ ಯೆಳಾರ್ ಹೊತ್ತಿ, ಖರೆ ಎಶ್ಯಾಕ್ನಾ ಯೆಲ್ಲಿ ಜುದೆವಾಂಚಿ ಲೊಕಾನಿ ಪಾವ್ಲುಕ್ ಗುಡಿತ್ ಬಗುನ್ ತೆಂಕಾ ಪಗ್ಳುನ್ ಧುರ್ ಕರುನ್ ತೆಕಾ ಧರುನ್ ಘೆವ್ನ್ ಗೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾನು, ಮಾಕಾ ಮಜ್ಜತ್ ಕರಾ! ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಕ್ನಿ ಅಮ್ಚ್ಯಾ ಲೊಕಾಕ್ನಿ, ಅನಿ ಹ್ಯಾ ಗುಡಿಕ್ ವಿರೊದ್ ಹೊವ್ನ್ ಸಗ್ಳ್ಯಾ ಜಾಗ್ಯಾರ್ನಿ ಲೊಕಾಕ್ನಿ ಶಿಕಾಪಾ ಕರಿತ್ ಹೊತ್ತೊ ಹ್ಯೊಚ್, ಅತ್ತಾ ಹೆನಿ ಉಲ್ಲಿ ಲೊಕಾ ಗ್ರಿಕಾಕ್ನಿ ದೆವಾಚ್ಯಾ ಗುಡಿಕ್ ಬಲ್ವುನ್ ಹಾನ್ಲಾ! ಹ್ಯೊ ಪವಿತ್ರ್ ಜಾಗೊ ಹೆನಿ ಅಶುದ್ದ್ ಕರ್‍ಲಾ!” ಮನುನ್ ಬೊಬ್ ಮಾರುನ್ ಗದ್ದಲ್ ಉಟ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ತ್ರೊಪಿಯ್ ಮನ್ತಲ್ಯಾ ಗ್ರಿಕಾಂಚ್ಯಾ ಮಾನ್ಸಾಕ್ ಜೆರುಜಲೆಮಾತ್ ಪಾವ್ಲು ವಾಂಗ್ಡಾ ಬಗಲ್ಲ್ಯಾನಿ, ತ್ರೊಪಿಮ್ ಎಫೆಸಾತ್ಲೊ, ತಸೆ ಹೊವ್ನ್ ಪಾವ್ಲುನ್ ತೆಕಾ ಪವಿತ್ರ್ ಜಾಗ್ಯಾರ್‍ನಿ ಬಲ್ವುನ್ ನ್ಹೆಲಾ ಮನುನ್ ಚಿಂತಾಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ತನ್ನಾ ಶಾರಾತ್ ಪುರಾ ಗದ್ದಲ್ ಶುರು ಹೊತಾ, ಸಗ್ಳ್ಯಾ ಕಡ್ಲಿ ಲೊಕಾ ಪಳುನ್ ಯೆವ್ನ್ ಪಾವ್ಲಿ ತೆಕಾ ಬಂಧಿ ಕರುನ್ ಗುಡಿತ್ನಾ ಭಾಯ್ರ್ ವಡುನ್ ಹಾನುನ್ ಹೊಲೆ, ಗುಡಿಚಿ ಸಗ್ಳಿ ದಾರಾಬಿ ಎಗ್ದಾಚ್ ಧಾಪುನ್ ಹೊಲಿ . ");
INSERT INTO kans_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ತೆನಿ ಪಾವ್ಲುಕ್ ಜಿವ್ ಕಾಡುಚೆ ಮನುನ್ ಕಟ್ಪಟ್ ಕರಿತ್ ರಾತಾನಾ ಸಗ್ಳ್ಯಾ ಶಾರಾತ್ ಗದ್ದಲ್ ಉಟ್ಲೊ ಮನ್ತಲಿ ಖಬರ್ ಜೆರುಜಲೆಮಾತ್ಲ್ಯಾ ರೊಮ್ ಸೆನಾಧಿಪತಿಕ್ ಗೊತ್ತ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ತಾಬೊಡ್ತೊಬ್ ತೆನಿ ಉಲ್ಲಿ ಸೆನಾಧಿಕಾರಿಯಾ, ಅನಿ ಸೈನಿಕಾಕ್ನಿ ಅಪ್ನಾ ವಾಂಗ್ಡಾ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಲೊಕಾಂಚೊ ತಾಂಡೊ ಹೊತ್ತ್ಯಾಕ್ಡೆ ಗೆಲೊ ಸೆನಾಧಿಪತಿಕ್ ಅನಿ ತೆಚ್ಯಾ ಸೈನಿಕಾಕ್ನಿ ಬಗುನ್ ಲೊಕಾನಿ ಪಾವ್ಲುಕ್ ಮಾರ್‍ತಲೆ ಇಬೆ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ಸೆನಾಧಿಪತಿನ್ ಸೈನಿಕಾಕ್ನಿ ಜಾವ್ನ್ ಪಾವ್ಲುಕ್ ಧರುನ್ ದೊನ್ ಸರ್ಪೊಳಿಯಾನಿ ಭಾಂದುಕ್ ಸಾಂಗ್ಲ್ಯಾನ್, ಅನಿ ತೆನಿ ಹ್ಯೊ ಮಾನುಸ್ ಕೊನ್? ಹೆನಿ ಕಾಯ್ ಚುಕ್ ಕರ್‍ಲಾ? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ಥೈತ್ಲಿ ಉಲ್ಲಿ ಲೊಕಾ ಯೆವ್ನ್ ಎಕ್ ವಿಶಯಾತ್ ಬೊಬ್ ಮಾರುಕ್ಲಾಗಲಿ ಹುರಲ್ಲಿ ಲೊಕಾ, ಅನಿ ದುಸ್ರ್ಯಾ ವಿಶಯಾತ್ ಬೊಬ್ ಮಾರುಕ್ಲಾಗಲಿ, ಹ್ಯೊ ಗದ್ದಲ್ ಬೊಬ್ ಮಾರುಲಾಗಲ್ಯಾನ್ ಭರುನ್ ಹೊತ್ತ್ಯಾ ಸಾಟ್ನಿ ಕಾಯ್ ಚಲುಲ್ಲಾ ಮನ್ತಲೆ ಖರೆ ಕಳ್ವುನ್ಗೆವ್ಕ್ ಹೊವ್ಕ್ ನಾ, ತಸೆ ಹೊವ್ನ್, ಸೆನಾಧಿಪತಿನ್ ಪಾವ್ಲುಕ್ ಕೊಟೆತ್ ಘೆವ್ನ್ ಜಾವ್ಕ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ಪಾವ್ಲು ಪಾಯ್ರಿಯಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಪಾವಲ್ಲ್ಯಾ ತನ್ನಾ ಲೈ ಲೊಕಾ ಡಕ್ಳುಂಗೆತ್ ಹೊತ್ತ್ಯಾಸಾಟ್ನಿ ಸೈನಿಕಾಕ್ನಿ ತೆಕಾ ಉಕ್ಲುನ್ ಘೆವ್ನ್ ಜಾತಲೆ ಯೆಲೆ, ಲೊಕಾಂಚೊ ತಾಂಡೊ ಲೈ ರಾಗಾನ್ ಭರಲ್ಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ತಾಂಡೊ ಹೊವ್ನ್ ಯೆಲ್ಲಿ ಲೊಕಾ ಅಮ್ಚ್ಯಾ ವಾಂಗ್ಡಾ ಯೆವ್ನ್ಗೆತ್ ತೆಕಾ ಜಿವ್‍ಕಾಡಾ! ಮನುನ್ ಬೊಬ್ ಮಾರಿತ್. ");
INSERT INTO kans_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ಸೈನಿಕಾನಿ ಪಾವ್ಲುಕ್ ಸೈನಿಕಾಂಚ್ಯಾ ಕೊಟೆತ್ ಘೆವ್ನ್ ಜಾತಾನಾ ಪಾವ್ಲುನ್ ಸೆನಾಧಿಪತಿಕ್ ಎಕ್ ಗೊಸ್ಟ್ ಸಾಂಗುಕ್ ಮಾಕಾ ಅವಕಾಸ್ ಹಾಯ್ ಕಾಯ್? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್ ತನ್ನಾ ಸೆನಾಧಿಪತಿನ್ ಹೊ ತುಕಾ ಗ್ರಿಕ್ ಬಾಶ್ಯಾ ಗೊತ್ತ್ ಹಾಯ್ ಕಾಯ್? ");
INSERT INTO kans_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ತಸೆ ಹೊಲ್ಯಾರ್, ಮಿಯಾ ಚಿಂತಲ್ಲೊ ಮಾನುಸ್ ತಿಯಾ ನ್ಹಯ್ ಉಲ್ಲ್ಯಾ ಎಳಾಚ್ಯಾ ಅದ್ದಿ ಗದ್ದಲ್ ಉಟ್ವಲ್ಲೊ ಇಜಿಪ್ತಾತ್ಲೊ ಮಾನುಸ್ ತಿಯಾಚ್ ಮನುನ್ ಮಿಯಾ ಚಿಂತಲೊ ತ್ಯಾ ಮಾನ್ಸಾನ್ ತರಾಸ್ ದಿತಲ್ಯಾ ಚಾರ್ ಹಜಾರ್ ಚೊರಾಕ್ನಿ ಡಂಗ್ಳಿಕ್ ಬಲ್ವುನ್ ನ್ಹೆಲ್ಲೊ ತಿಯಾಚ್ ನ್ಹಯ್ ಕಾಯ್? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ತೆಕಾ ಪಾವ್ಲುನ್ ಮಿಯಾ ಜುದೆವಾಂಚೊ ಸಿಲಿಸಿ ದೆಶಾಚ್ಯಾ ತಾರ್ಸಿಸಾತ್ ಉಪಾಜಲ್ಲೊ, ಮಿಯಾ ತ್ಯಾ ಶಾರಾಚೊ ಪ್ರಮುಖ್ ಮಾನುಸ್, ದಯಾ ಕರುನ್ ಲೊಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲುಕ್ ಅವಕಾಸ್ ಕರುನ್ ದಿವಾ ಮಟ್ಲ್ಯಾನ್ . ");
INSERT INTO kans_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ಸೆನಾಧಿಪತಿನ್ ತೆಕಾ ಅವಕಾಸ್ ದಿತಾನಾ ಪಾವ್ಲುನ್, ಪಾಯ್ರಿಯಾ ವೈನಿ ಇಬೆ ರ್‍ಹಾವ್ನ್; ಲೊಕಾಕ್ನಿ ಗಪ್‍ರಾವ್ಕ್ ಸಾಂಗುನ್, ಲೊಕಾ ಶಾಂತ್ ಹೊಲ್ಲ್ಯಾ ತನ್ನಾ, ಹಿಬ್ರು ಬಾಶೆನ್ ಬೊಲುಕ್ ಶುರು ಕರ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ಪಾವ್ಲುನ್, ಮಾಜ್ಯಾ ವಿಶ್ವಾಸಾತ್ ಹೊತ್ತ್ಯಾ ಜುದೆವ್ ವಾಂಗ್ಡಿಯಾನು ಅನಿ ಬಾಬಾನು ಮಾಜ್ಯೊ ಪ್ರತಿವಾದ್ ಆಯ್ಕಾ! ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ಪಾವ್ಲು ಹಿಬ್ರು ಬಾಶೆತ್ ಬೊಲ್ತೆಲ್ಲೆ ಆಯ್ಕುನ್ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಅನಿ ಉಲ್ಲಿ ಶಾಂತ್ ಹೊಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ತನ್ನಾ ಪಾವ್ಲು ಅಶೆ ಸಾಂಗ್ಲ್ಯಾನ್: ಮಿಯಾ ಜುದೆವಾಂಚೊ, ಮಿಯಾ ಉಪಾಜಲ್ಲೆ ಸಿಲಿಸಿ ದೆಶಾಚ್ಯಾ ತಾರ್ಸಿಸ್ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್, ಹೊಲ್ಯಾರ್, ಮಿಯಾ ಮೊಟೊ ಹೊಲ್ಲೊ ಜೆರುಜಲೆಮಾತ್. ಮಿಯಾ ಗಮಲಿಯಲಾಚ್ಯಾ ಹಾತಿತ್ ಶಿಕಲ್ಲೊ ಪೊರ್, ಅಮ್ಚ್ಯಾಪುರ್ವಜ್ಯಾಂಚ್ಯಾ ಖಾಯ್ದ್ಯಾಚ್ಯಾ ಪುಸ್ತಕಾಂಚ್ಯಾ ವಿಶಯಾತ್ ಹರ್ ಎಕ್ಬಿ ಮಾಕಾ ಬರೆ ಕರುನ್ ಶಿಕಾಪ್ ಕರ್‍ಲಾ, ಆಜ್ ಹಿತ್ತೆ ಹೊತ್ತ್ಯಾ ತುಮ್ಚ್ಯಾ ಸಾರ್ಕೆ ಮಿಯಾ ದೆವಾಚ್ಯಾ ಸೆವಾಚ್ಯಾ ವಿಶಯಾತ್ ಲೈ ಅಭಿಮಾನ್ ಥವಲ್ಲೊ ಹೊತ್ತೊ. ");
INSERT INTO kans_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ಜೆಜುಚ್ಯಾ ವಾಟೆನ್ ಕೊನ್ ಜಾತಾತ್ ತೆಂಕಾ ಮಿಯಾ ತರಾಸ್ ದಿಲಾ ಮಾಜ್ಯಾ ವೈನಾ ತೆಂಚ್ಯಾತ್ ಉಲ್ಲ್ಯಾಲೊಕಾಕ್ನಿ ಮರಿ ಪಾತರ್ ತರಾಸ್ ದಿಲೊ, ಅನಿ ಘವ್ಮಾನ್ಸಾಕ್ನಿ ಅನಿ ಬಾಯ್ಕೊಮಾನ್ಸಾಕ್ನಿ ಭಾಂದುನ್ ಬಂದಿಖಾನ್ಯಾತ್ ಘಾಲುಕ್ ಲಾವ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ಹೆ ಖರೆ ಮನನುಕ್ ಮುಖ್ಯ್ ಯಾಜಕ್ ಅನಿ ಜುದೆವಾಂಚ್ಯಾ ಜಾನ್ತ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ತಾಂಡ್ಯಾತ್ಲಿ ಲೊಕಾ ಸಗ್ಳಿ ಸಾಕ್ಷಿ ಹೊವ್ನ್ ಹಾತ್, ಎಗ್ದಾ ಹ್ಯಾ ಮುಂಖಡಾನಿ ಮಾಕಾ ಉಲ್ಲಿ ಚಿಟಿಯಾ ದಿಲ್ಯಾನಿ, ದಮಸ್ಕಾ ಮನ್ತಲ್ಯಾ ಶಾರಾತ್ಲ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಭಾವಾಕ್ನಿ ತಿ ಸಗ್ಳ್ಯಿ ಚಿಟಿಯಾ ಲಿವಲ್ಲಿ ಹೊತ್ತಿ ಮಿಯಾ ಜೆಜುಚ್ಯಾ ಶಿಸಾಕ್ನಿ ಬಂಧಿಕರುನ್ ಶಿಕ್ಷಾ ದಿವ್ಕ್ ಸಾಟ್ನಿ ತೆಂಕಾ ಜೆರುಜಲೆಮಾಕ್ ವಡುನ್ ಘೆವ್ನ್ ಯೆವ್ಕ್ ಥೈ ಜಾವ್ಲಾಗಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ಮಿಯಾ ಪ್ರಯಾನ್ ಕರುನ್ಗೆತ್ ದಮಸ್ಕಾಚ್ಯಾ ಶಾರಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಸುಮಾರ್ ದೊಪಾರ್ ಹೊಲ್ಲಿ ಹೊತ್ತಿ, ತನ್ನಾ ಯೆಗ್ದಾಚ್ ಹೊಳ್ವತಲ್ಲೊ ಎಕ್ ಉಜ್ವೊಡ್ ಮಾಜ್ಯಾ ಬೊತ್ಯಾನ್ ಹೊಳ್ವಲ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ತನ್ನಾ ಮಿಯಾ ಜಿಮ್ನಿ ವರ್‍ತಿ ಪಡ್ಲೊ ತನ್ನಾ ಮಾಕಾ ಎಕ್ ಧನ್ ಆಯಿಕ್ಲೊ, ಸಾವ್ಲ್, ಸಾವ್ಲ್! ತಿಯಾ ಕಶ್ಯಾಕ್ ಮಾಕಾ ತರಾಸ್ ದಿತೈಯ್? ");
INSERT INTO kans_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ತನ್ನಾ ಮಿಯಾ, ಧನಿಯಾ, ತಿಯಾ ಕೊನ್? ಮನುನ್ ಇಚಾರ್ಲೊ ತ್ಯಾ ಧನಾನ್, ನಜರೆತಾಚೊ ಜೆಜು ಮಿಯಾ ತಿಯಾ ತರಾಸ್ ದಿತಲ್ಲೆ ಮಾಕಾಚ್ ಮನುನ್ ಸಾಂಗಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಹೊತ್ತ್ಯಾ ಲೊಕಾಕ್ನಿ ಮಾಜ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲ್ತಲಿ ಧನ್ ಆಯ್ಕುಕ್ನಾ, ಖರೆ ತೆನಿ ತೊ ಉಜ್ವೊಡ್ ಬಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“ತನ್ನಾ ಧನಿಯಾ ಮಿಯಾ ಕಾಯ್ ಕರು?” ಮಟ್ಲೊ ಧನಿಯಾನ್ ಉಟುನ್ ದಮಸ್ಕಾ ಶಾರಾತ್ ಜಾ ಮಿಯಾ ಅದ್ದಿಚ್ ನೆಮ್ಸುನ್ ತುಕಾ ಥವಲ್ಲಿ ಸಗ್ಳಿ ಕಾಮಾ ತುಕಾ ಥೈ ಕಳ್ವುನ್ ಹೊತಾ ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ಹೊಳಾವ್ತಲ್ಯಾ ಉಜ್ವಡಾನ್ ಮಾಕಾ ಕುಡ್ಡೊ ಕರಲ್ಯಾಸಾಟ್ನಿ ಕಾಯ್ಬಿ ದಿಸುಕ್ನಾ, ತಸೆಹೊವ್ನ್, ತ್ಯಾ ಲೊಕಾನಿ ಮಾಕಾ ದಮಸ್ಕಾ ಶಾರಾತ್ ಹಾತ್ ಧರುನ್ ಚಲ್ವುನ್ ನ್ಹೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ದಮಸ್ಕಾತ್ ಅನನಿಯ್ ಮನ್ತಲ್ಲೊ ಮಾಜ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆಲೊ, ತೊ ದೆವಸ್ಪಾನಾಚೊ ಮಾನುಸ್ ಹೊಲ್ಲೊ, ತೊ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾಕ್ ಮಾನುನ್ ಘೆವ್ನ್ ಜಾತಲೊ ಹೊಲ್ಲೊ, ಥೈ ಹೊತ್ತಿ ಜುದೆವಾಂಚಿ ಸಗ್ಳಿ ಲೊಕಾ ತೆಕಾ ಮಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ಅನನಿಯಾ ಮನ್ತಲೊ ಮಾಜ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್, ಮಾಜ್ಯಾ ಭಾವಾ ಸಾವ್ಲ್, ತುಕಾ ಅನಿ ಪರ್ತುನ್ ಡೊಳೆ ದಿಸುಂದಿತ್ ! ಮಟ್ಲ್ಯಾನ್, ತಾಬೊಡ್ತೊಬ್ ಮಾಕಾ ದಿಸ್ಟ್ ಯೆಲಿ, ಅನಿ ಮಿಯಾ ತೆಕಾ ಬಗ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ಅನನಿಯಾನ್ ಮಾಕಾ, ಅಮ್ಚ್ಯಾ ಪುರ್ವಜಾಂಚ್ಯಾ ದೆವಾನ್ ತುಕಾ ಲೈ ಯೆಳಾಚ್ಯಾ ಅದ್ದಿಚ್ ಎಚುನ್ ಘೆಟ್ಲಾ, ದೆವಾಚಿ ಯವ್ಜನ್ ಕಳ್ವುನ್ ಘೆವ್ಚೆ ಮನುನ್ ನಿಯತ್ತಿಚ್ಯಾ ಜೆಜುಕ್ ಬಗುಚೆ ಮನುನ್ ಅನಿ ತೆಚಿ ಸಗ್ಳಿ ಗೊಸ್ಟ್ ಆಯ್ಕುಚೆ ಮನುನ್ ದೆವಾನ್ ತುಕಾ ಎಚುನ್ ಘೆಟ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ತಿಯಾ ಬಗಲ್ಲಿ ಅನಿ ಆಯ್ಕಲ್ಲಿ ಸಂಗ್ತಿಯಾ ಸಗ್ಳಿ ಸಗ್ಳ್ಯಾ ಲೊಕಾಕ್ನಿ ಸಾಕ್ಷಿ ಹೊವ್ನ್ ರಾತೈಯ್. ");
INSERT INTO kans_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ಅತ್ತಾ ತಿಯಾ ತಡೊ ಕರ್‍ತಲೆ ಕಶ್ಯಾಕ್? ಉಟ್ ! ಜೆಜುಚ್ಯಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಥವ್ನ್ ಬಾಲ್ತಿಮ್ ಕರುನ್ ಘೆ, ಅನಿ ತೆಜ್ಯಾಕ್ಡೆ ಮಾಗ್ನಿ ಕರ್, ತುಜೊ ಪಾಪ್ ದುವ್ನ್ ಘೆ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ಮಾನಾಸರ್ ಮಿಯಾ ಜೆರುಜಲೆಮಾಕ್ ಪರ್ತುನ್ ಗೆಲೊ ದೆವಾಚ್ಯಾ ಗುಡಿಚ್ಯಾ ದಾರಾತ್ ಮಾಗ್ನಿ ಕರ್ತಾನಾ ಮಾಕಾ ಎಕ್ ದರ್ಶನ್ ಹೊಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ಮಿಯಾ ಧನಿಯಾಕ್ ಬಗಟ್ಲೊ ತನ್ನಾ ಮಾಕಾ, ತಡೊ ಕರಿನಸ್ತಾನಾ ಜೆರುಜಲೆಮಾಕ್ ಜಾ, ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಹಿ ಲೊಕಾ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ತುಜಿ ಸಾಕ್ಷಿ ಒಪ್ಪುನ್ ಘೆಯ್‌ನ್ಯಾತ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ತನ್ನಾ ಮಿಯಾ, ಧನಿಯಾ, ದೆವಾಚ್ಯಾ ಲೊಕಾಕ್ನಿ ಬಂಧಿಖಾನ್ಯಾತ್ ಘಾಲುನ್ ಮಾರುಕ್‍ಲಾವಲ್ಲೊ ಮಿಯಾಚ್ ಮನುನ್ ಲೊಕಾಕ್ನಿ ಗೊತ್ತ್ ಹಾಯ್, ತುಜ್ಯಾ ವರ್‍ತಿ ವಿಶ್ವಾಸ್ ಥವಲ್ಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಹುಡ್ಕುನ್ ಕಾಡುನ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಘಾಲುಕ್ ಮಿಯಾ ಸಗ್ಳ್ಯಾ ಸಿನಾಗೊತ್ನಿಬಿ ಜಾವ್ನ್ ಯೆಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ತುಜಿ ಸಾಕ್ಷಿ ಹೊಲ್ಲ್ಯಾ ಸ್ತೆಫನ್ ಮನ್ತಲ್ಯಾಕ್ ಜಿವಾನಿ ಮಾರ್ತಾನಾ ಮಿಯಾ ಥೈ ಹೊತ್ತೆ ಬಿ ಲೊಕಾಕ್ನಿ ಗೊತ್ತ್ ಹೊತ್ತೆ, ಸ್ತೆಫನ್ ಮನ್ತಲ್ಯಾಕ್ ಜಿವಾನಿ ಮಾರುಕ್ ತೆನಿ ನಿರ್ಧಾರ್ ಕರಲ್ಲ್ಯಾ ತನ್ನಾ ಮಿಯಾ ತೆಕಾ ಒಪ್ಗಿ ದಿವ್ನ್ ಥೈ ಇಬೆ ಹೊತ್ತೊ, ಅನಿ ತೆಕಾ ಜಿವಾನಿ ಮಾರ್ತಲ್ಲ್ಯಾಂಚೆ ಝಗೆಬಿ ಮಿಯಾ ಧರುನ್ ಘೆವ್ನ್ ಇಬೆ ಹೊತ್ತೊ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ಖರೆ ಧನಿಯಾನ್ ಮಾಕಾ “ ಜಾ ಲೈ ಧುರ್ ಹೊತ್ತ್ಯಾ ಜುದೆವ್ ನ್ಹಯ್ ಹೊಲ್ಲ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಜಗ್ಗೊಳ್ ಮಿಯಾ ತುಕಾ ಧಾಡ್ತಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್”. ");
INSERT INTO kans_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ಹಿ ಗೊಸ್ಟಿಯಾ ಸಾಂಗ್ತಾನಾ ಸಗ್ಳಿ ಲೊಕಾ ಪಾವ್ಲು ಸಾಂಗ್ತಲೆ ಆಯ್ಕುಲಾಲಿ ಮಾನಾ ತೆನಿ “ಅಸ್ಲ್ಯಾಕ್ನಿ ಜಿಮ್ನಿ ವೈನಾ ಕಾಡುನ್ ಟಾಕುಚೆ ಹ್ಯೊ ಜಿವಾನಿ ರ್‍ಹಾವ್ಕ್ ಯೊಗ್ಯಾನಾ” ಮನುನ್ ಬೊಬ್ ಮಾರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ತೆನಿ ಬೊಬ್ ಮಾರುನ್ಗೆತ್ ಅಪ್ಲಿ ವೈಲಿ ಅಂಗಿಯಾ ಕಾಡುನ್ ಮಾಟಿ ಮಳ್ಬಾಕ್ಡೆ ಹುಡ್ವುಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ತನ್ನಾ ರೊಮಾಚ್ಯಾ ಸೈನಿಕಾಚ್ಯಾ ಮುಖಂಡಾನ್ ಪಾವ್ಲುಕ್ ಬುತ್ತುರ್ ಘೆವ್ನ್ ಜಾವ್ನ್ ಮಾರಾ ಮನುನ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್,ಲೊಕಾ ಅಶೆ ಬೊಬ್ ಮಾರುಕ್ ಕಾಯ್ ಕಾರನ್ ಮನ್ತಲೆ ತೆಜ್ಯಾಕ್ನಾಚ್ ಸಾಂಗ್ಸುಚೆ ಮನ್ತಲಿ ತ್ಯಾ ಮುಖಂಡಾಚಿ ಆಶ್ಯಾ ಹೊಲ್ಲಿ. ");
INSERT INTO kans_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ಪಾವ್ಲುಕ್ ಮಾರುಕ್ ಸಿಪಾಯಿಯಾ ಭಾಂದಿತ್ ರಾತಾನಾ ಥೈ ಹೊತ್ತ್ಯಾ ರೊಮತ್ಲ್ಯಾ ಅಧಿಕಾರಿಕ್ ಪಾವ್ಲುನ್, “ಚುಕ್ದಾರಿ ಮನುನ್ ನಿರ್ಧಾರ್ ಹೊವ್ಕ್ ನಸಲ್ಲ್ಯಾ ರೊಮಾಚ್ಯಾ ಮಾನ್ಸಾಕ್ ಮಾರುಕ್ ತುಮ್ಕಾ ಹಕ್ಕ್ ಹಾಯ್ ಕಾಯ್?” ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ತ್ಯಾ ಅಧಿಕಾರಿನ್ ತೆ ಆಯ್ಕಲ್ಲ್ಯಾ ತಾಬೊಡ್ತೊಬ್ ಸೈನಿಕಾಚೊ ಮುಂಖಡಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್, ತಿಯಾ ಕಾಯ್ ಕರುಲ್ಲೆ ಮನುನ್ ತುಕಾ ಗೊತ್ತ್ ಹಾಯ್ ಕಾಯ್? ಹ್ಯೊ ಮಾನುಸ್ ರೊಮ್ ಮನ್ತಲ್ಯಾ ಶಾರಾಚೊ! ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ತನ್ನಾ ಸೈನಿಕಾಚೊ ಮುಂಖಡ್ ಪಾವ್ಲುಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್, ಸಾಂಗ್ ತಿಯಾ ಖರೆಬಿ ರೊಮ್ ಶಾರಾತ್ಲೊ ಮಾನುಸ್ ಕಾಯ್? ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್ ಪಾವ್ಲುನ್, ಹೊಯ್ ಮನುನ್ ಜವಾಬ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ಸೈನಿಕಾಚ್ಯಾ ಮುಂಖಡಾನ್, ಮಿಯಾ ರೊಮ್ ಶಾರಾಚೊ ಮಾನುಸ್ ಹೊವ್ಕ್ ಲೈ ಪೈಸೆ ದಿಲಾ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್ ಖರೆ ಪಾವ್ಲುನ್, ಮಿಯಾ ಜಲ್ಮಿಚ್ ರೊಮಾಚೊ ಮಾನುಸ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ಪಾವ್ಲುಕ್ ಪರಸ್ನೆ ಇಚಾರುಕ್ ತಯಾರ್ ಹೊವ್ನ್ ಹೊತ್ತಿ ಲೊಕಾ ತನ್ನಾಚ್ ತೆಚ್ಯಾ ಜಗ್ಗೊಳ್ನಾ ಗೆಲಿ, ಖರೆ ಪಾವ್ಲುಕ್ ತನ್ನಾಚ್ ಭಾಂದುನ್ ಘಾಟಲ್ಲೆ ಹೊತ್ತೆ, ಅನಿ ತೊ ರೊಮಾಚೊ ಮಾನುಸ್ ಹೊಲ್ಲ್ಯಾಕ್ ಸೆನಾಧಿಪತಿಕ್‍ ಭಿಂಯೆ ಕರುಕ್ ಲಾಗ್ಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ದುಸ್ರೆಂದಿಸಿ ಪಾವ್ಲುಕ್ ವಿರೊಧ್ ಹೊವ್ನ್ ಜುದೆವಾಂಚ್ಯಾ ಲೊಕಾನಿ ಹಾನಲ್ಲೆ ಅಪರಾಧ್ ಕಾಯ್ ಮನುನ್ ಕಳ್ವುನ್ ಘೆವ್ಕ್ ಸೆನಾಧಿಪತಿನ್ ನಿರ್ಧಾರ್ ಕರ್‍ಲ್ಯಾನ್, ತೆಚಾ ಸಾಟ್ನಿ ತೆನಿ ಮುಖ್ಯ್ ಯಾಜಕ್ ಜುದೆವಾಂಚ್ಯಾ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಲೊಕಾಕ್ನಿಬಿ ಗೊಳಾ ಹೊವ್ನ್ ಯೆವ್ಕ್ ಹುಕುಮ್ ದಿಲ್ಲ್ಯಾನ್, ಸೆನಾಧಿಪತಿನ್ ಪಾವ್ಲುಚಿ ಬಾಂದಲ್ಲಿ ಸರ್ಪೊಳಿಯಾ ಕಾಡುನ್ ಟಾಕುನ್ ತೆಕಾ ಭಾಯ್ರ್ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಯೆವ್ನ್ ತಾಂಡ್ಯಾಚ್ಯಾ ಇದ್ರಾಕ್ ಇಬೆ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ತನ್ನಾ ಪಾವ್ಲುನ್ ಜುದೆವಾಂಚ್ಯಾ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ತಾಂಡ್ಯಾಕುಚ್ ಬಗುನ್, “ಮಾಜ್ಯಾ ಭಾವಾನು ಮಿಯಾ ಆಜ್ ಪತರ್ ದೆವಾಚ್ಯಾ ಫಿಡೆ ಬರ್‍ಯಾ ಮಾನಾನ್ ಚಲುನ್ಗೆತ್ ಯೆಲಾ” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ಮೊಟೊ ಯಾಜಕ್ ಅನನಿಯಾ ಮನ್ತಲೊಬಿ ಥೈ ಹೊತ್ತೊ ಪಾವ್ಲುಚ್ಯಾ ತೊಂಡಾರ್ ಮಾರಾ ಮನುನ್ ಸಾಂಗಲ್ಲ್ಯಾನ್, ಗೊಸ್ಟಿಯಾ ಆಯ್ಕುನ್ ಪಾವ್ಲುಚ್ಯಾ ಬಾಜುಕ್ ಇಬೆ ಹೊತ್ತ್ಯಾಕ್ನಿ ತೆಚ್ಯಾ ತೊಂಡಾರ್ ಮಾರುಕ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ತೆಕಾ ಪಾವ್ಲುನ್ ದೆವ್ ತುಕಾಬಿ ಮಾರ್‍ತಾ! ತಿಯಾ ಚುನ್ನೊ ಲಾವಲ್ಲ್ಯಾ ಭಿತ್ತಿ ಸಾರ್ಕೊ ಹಾಸ್ ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಚ್ಯಾ ಸಾರ್ಕೆ ಝಡ್ತಿ ಕರುಕ್ ಬಸಲ್ಲೊ ತಿಯಾ ಮಾಕಾ ಮಾರಾ ಮನುನ್ ತೆಂಕಾ ಸಾಂಗುಲೈ ಕಾಯ್? ತಿಯಾ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ದ್ಯಾಕ್ನಿ ಮೊಡುಲೈಯ್! ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ಪಾವ್ಲುಚ್ಯಾ ಜಗ್ಗೊಳ್ ಇಬೆ ಹೊತ್ತ್ಯಾ ಲೊಕಾನಿ ತೆಕಾ “ದೆವಾಚ್ಯಾ ಮೊಟ್ಯಾ ಯಾಜಕಾಕ್ ತಿಯಾ ಅಶೆ ಬೊಲುನೈ, ತೆಕಾ ತಿಯಾ ಅವಮಾನ್ ಕರುಲೈ!” ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ಪಾವ್ಲು ತೆಂಕಾ, ಭಾವಾನು ಹೊ ಮಾನುಸ್ ಮೊಟೊ ಯಾಜಕ್ ಮನ್ತಲೆ ಮಾಕಾ ಗೊತ್ತ್ ನತ್ತೆ , ತುಮ್ಚ್ಯಾ ಲೊಕಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾಚ್ಯಾ ವಿರೊದ್ ವಾಯ್ಟ್ ಬೊಲು ನ್ಹಯ್ ಮನುನ್ ಮೊಯ್ಜೆಚ್ಯಾ ಖಾಯ್ಲ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾತ್ ಲಿವಲ್ಲೆ ಹಾಯ್ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ತ್ಯಾ ತಾಂಡ್ಯಾತ್ ಥೊಡಿ ಲೊಕಾ ಸಾದುಸೆವಾಂಚಿ ಅನಿ ಥೊಡಿ ಲೊಕಾ ಫಾರಿಜೆವಾಂಚಿ ಹೊವ್ನ್ ಹೊತ್ತಿ, ತಸೆಹೊವ್ನ್ ಪಾವ್ಲುನ್ ಮಾಜ್ಯಾ ಭಾವಾನು ಮಿಯಾ ಫಾರಿಜೆವಾಂಚೊ! ಅನಿ ಮಾಜೊ ಬಾಬಾಬಿ ಫಾರಿಜೆವಾಂಚೊ ಮರಲ್ಲೆ ಪರ್ತುನ್ ಝಿತ್ತೊ ಹೊತ್ಯಾತ್ ಮನ್ತಲೆ ಮಿಯಾ ವಿಶ್ವಾಸ್ ಕರ್‍ತಲ್ಯಾ ಸಾಟ್ನಿ ಹಿತ್ತೆ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾಕ್ಡೆ ಪಾವ್ಲಾ ,ಮನುನ್ ಮೊಟ್ಯಾನ್ ಬೊಬ್ ಮಾರುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ಪಾವ್ಲುನ್ ಬೊಬ್ ಮಾರುನ್ ಸಾಂಗಲ್ಲೆ ತನ್ನಾ , ಫಾರಿಜೆವಾಕ್ನಿ ಅನಿ ಸಾದುಸೆವಾಕ್ನಿ ಮೊಟೊ ಬೊಲ್ಯ್ನಾಚೊ ಝಗ್ಡೊ ಹೊಲೊ, ತಾಂಡ್ಯಾತ್ ಭೆದ್ಭಾಬ್ ಹೊಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ಕಶ್ಯಾಕ್ ಮಟ್ಲ್ಯಾರ್, ಮರಲ್ಲೆ ಪರ್ತುನ್ ಝಿತ್ತೆ ಹೊತಲ್ಲೆ ನಾ,ಅನಿ ದೆವ್‍ದುತಾ ಹೊಂವ್ದಿ,ಆತ್ಮೆ ಹೊಂವ್ನ್ದಿತ್ ನಾ ಮನ್ತಲೊ ಸಾದುಸೆವಾಂಚೊ ವಿಶ್ವಾಸ್, ಅನಿ ಫಾರಿಜೆವಾ ಹ್ಯಾ ತಿನಾಕ್ ಬಿ ವಿಶ್ವಾಸ್ ಕರ್ತಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ಥೈ ಲೈ ಆವಾಜ್ ಹೊಲೊ, ಫಾರಿಜೆವಾಂಚ್ಯಾ ತಾಂಡಾತ್ಲಿ ಥೊಡಿ ಲೊಕಾ ಧರ್ಮ ಶಿಕಾಪಾ ಕರ್ತಲೆ ಉಟುನ್ ಇಬೆ ರಾವ್ನ್ ಹ್ಯಾ ಮಾನ್ಸಾಕ್ಡೆ ಅಮ್ಕಾ ಕಾಯ್ಬಿ ಚುಕ್‍ ದಿಸುನ್ ಯೆಯ್ನಾ ಹೊಲಾ! ಕಾಯ್ಕಿ ತೆಚ್ಯಾ ವಾಂಗ್ಡಾ ಬೊಲುಕ್ ಫಿರೆ ಮನುನ್ ವಾದ್ ಕರ್‍ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ಹೆ ಬೊಲ್ನೆ ಮಾನಾ ಝಗ್ಡೊ ಹೊಲೆ, ಜುದೆವಾಂಚಿ ಲೊಕಾ ಪಾವ್ಲುಕ್ ತೊಡುನ್ ತುಕ್ಡೆ ಕಾಡುನ್ ಟಾಕಿತ್ ಮನ್ತಲ್ಯಾ ಭಿಂಯ್ಯಾನಿ ಸೈನಿಕಾಂಚ್ಯಾ ಅದಿಕಾರ್‍ಯಾನ್ ಸೈನಿಕಾಕ್ನಿ “ಖಾಲ್ತಿ ಉತ್ರುನ್ ಜಾವ್ನ್ ಪಾವ್ಲುಕ್ ಹೆಂಚ್ಯಾ ಜಗ್ಗೊಳ್ನಾ ನ್ಹೆವ್ನ್ ಸೈನಿಕಾಂಚ್ಯಾ ಕೊಟೆತ್ ಥವಾ” ಮನುನ್ ಹುಕುಮ್ ಕರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ತ್ಯಾ ದಿಸಿ ರಾತ್ತಿನಿ ಧನಿಯಾ ಜೆಜು ಪಾವ್ಲುಚ್ಯಾ ಜಗ್ಗೊಳ್ ಯೆವ್ನ್ ಇಬೆ ರಾವ್ನ್ ಭಿಂವ್‍ನಕ್ಕೊ! ತಿಯಾ ಮಾಜ್ಯಾ ವಿಶಯಾತ್ ಜೆರುಜಲೆಮಾತ್ ಸಾಂಗಲ್ಲ್ಯಾ ಸಾರ್ಕೆಚ್ ರೊಮಾತ್ ಬಿ ಜಾವ್ನ್ ಮಾಜಿ ಸಾಕ್ಷಿ ಸಾಂಗುಚೆ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ದುಸ್ರ್ಯಾಂದಿಸಿ ಸಕ್ಕಾಳಿ ಜುದೆವಾಂಚ್ಯಾ ಥೊಡ್ಯಾ ಲೊಕಾನಿ ಪಾವ್ಲುಕ್ ವಿರೊದ್ ಗೊಳಾ ಹೊವ್ನ್ ಉಪಾಯ್ ಕರಲ್ಲ್ಯಾನಿ, ಅಮಿ ಪಾವ್ಲುಚೊ ಜಿವ್ ಕಾಡಿ ಪತರ್ ಅಮಿ ಕಾಯ್ಬಿ ಪಿನಾಂವ್, ಅನಿ ಕಾಯ್ಬಿ ಖಾಯ್ನಾಂವ್ ಮನುನ್ ಆನ್ ಕರುನ್ ಘೆಟ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ಅಶೆ ಕರಲ್ಲೆ ಚಾಳಿಸಾಕ್ಕಿಂತಾಬಿ ಲೈ ಲೊಕಾ ಹೊತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ಮೊಟೊ ಯಾಜಕ್ ಅನಿ ಜಾಂಟ್ಯಾ ಲೊಕಾಂಚ್ಯಾಕ್ಡೆ ಜಾವ್ನ್ ಪಾವ್ಲುಕ್ ಜಿವ್ ಕಾಡಿ ಪತರ್ ಅಮಿ ಕಾಯ್ ಬಿ ಖಾಯ್ನಾಂವ್ ಅನಿ ಫಿಯ್ನಾವ್ ಮನುನ್ ಆನ್ ಕರ್ಲಾತ್ ಮನುನ್ ಸಾಂಗಲ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ತಸೆ ಹೊವ್ನ್, ಅತ್ತಾ ತುಮಿ ಕಾಯ್ ಕರುಚೆ ಮಟ್ಲ್ಯಾರ್, ಸೈನಿಕಾಚ್ಯಾ ಅಧಿಕಾರಿಕ್ ಅನಿ ಸಗ್ಳ್ಯಾ ಜುದೆವಾಂಚ್ಯಾ ಮುಖಂಡಾಕ್ನಿ ಎಕ್ ಖಬರ್ ಧಾಡುನ್ ದಿವಾ, ಪಾವ್ಲುಕ್ ಅನಿಬಿ ಲೈ ಪ್ರಶ್ನಿಯಾ ಇಚಾರುಕ್ ಪಾಜೆ ಮನುನ್ ಅಮ್ಚ್ಯಾ ಜಗ್ಗೊಳ್ ಬಲ್ವುನ್ ಹಾನುಕ್ ರೊಮಾತ್ಲ್ಯಾ ಅಧಿಕಾರಿಕ್ ಸಾಂಗಾ, ಪಾವ್ಲು ಹಿತ್ತೆ ಯೆತಾನಾಚ್ ಅಮಿ ವಾಟೆಕ್ ರಾಕುನ್ಗೆತ್ ರಾವ್ನ್ ತೆಕಾ ಜಿವ್ ಕಾಡ್ತಾಂವ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ಖರೆ ಹಿ ಯೆವ್ಚನ್ ಪಾವ್ಲುಚ್ಯಾ ಭೆನಿಚ್ಯಾ ಲೆಕಾಕ್ ಗೊತ್ತ್ ಹೊಲಿ, ತೆನಿ ಸೈನಿಕಾಂಚ್ಯಾ ಕೊಟೆತ್ ಜಾವ್ನ್ ಹೆ ಸಗ್ಳೆ ಪಾವ್ಲುಕ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ತನ್ನಾ ಪಾವ್ಲುನ್ ಅಧಿಕಾರಿತ್ನಿ ಎಕ್ಲ್ಯಾಕ್ ಬಲ್ವುನ್, ಹ್ಯಾ ದಾಂಡ್ಗ್ಯಾ ಮಾನ್ಸಾಕ್ ಸೈನಿಕಾಂಚ್ಯಾ ಅಧಿಕಾರಿಕ್ಡೆ ಬಲ್ವುನ್ ಘೆವ್ನ್ ಜಾ, ಹ್ಯೊ ತೆಂಕಾ ಎಕ್ ಖಬರ್ ಸಾಂಗ್ನಾರ್ ಹಾಯ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ತಸೆ ಹೊವ್ನ್, ಅಧಿಕಾರಿನ್ ಪಾವ್ಲುಚ್ಯಾ ಭೆನಿಚ್ಯಾ ಲೆಕಾಕ್ ಸೈನಿಕಾಂಚ್ಯಾ ಅಧಿಕಾರಿಕ್ಡೆ ನ್ಹೆಲ್ಯಾನ್. ಅನಿ ಹ್ಯಾ ದಾಂಡ್ಗ್ಯಾ ಮಾನ್ಸಾಕ್ ತುಜ್ಯಾಕ್ಡೆ ಬಲ್ವುನ್ ನ್ಹೆ ಮನುನ್ ಬಂಧಿಖಾನ್ಯಾತ್ ಹೊತ್ತ್ಯಾ ಪಾವ್ಲುನ್ ತುಕಾ ಎಕ್ ಖಬರ್ ಧಾಡುನ್ ದಿಲಾ ಮಟ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ಸೈನಿಕಾಂಚ್ಯಾ ಮುಖಂಡಾನ್ ತ್ಯಾ ದಾಂಡ್ಗ್ಯಾ ಮಾನ್ಸಾಕ್ ಹಾತಿಕ್ ಧರುನ್ ಕೊನ್ ನಸಲ್ಯಾ ಜಾಗ್ಯಾಕ್ ಬಲ್ವುನ್ ನ್ಹೆವ್ನ್, ತಿಯಾ ಕಾಯ್ ಸಾಂಗಚೆ ಮನುನ್ ಹಾಸ್ ಮನುನ್ ಇಚಾರ್‍ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ತನ್ನಾ ದಾಂಡ್ಗ್ಯಾ ಮಾನ್ಸಾನ್ ಅನಿ ಲೈ ಪ್ರಶ್ನಿಯಾ ಇಚಾರುಕ್ ಪಾಜೆ ಮನುನ್ ಪಾವ್ಲುಕ್ ಉದ್ದ್ಯಾಚ್ಯಾ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ಬೈಟಕಿಕ್ ಬಲ್ವುನ್ ಹಾನುಕ್ ತುಜ್ಯಾಕ್ಡೆ ಮಾಗುನ್ ಘೆವ್ಕ್ ಮನುನ್ ನಿರ್ಧಾರ್ ಕರ್ಲಾತ್. ");
INSERT INTO kans_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ಖರೆ ತೆಂಕಾ ವಿಶ್ವಾಸ್ ಕರುನಕ್ಕೊ! ಪಾವ್ಲುಕ್ ಜಿವ್ ಕಾಡುಸಾಟಿ ಚಾಳಿಸಾಕ್ಕಿಂತಾಬಿ ಲೈ ಜುದೆವಾಂಚಿ ಲೊಕಾ ರಾಕುನ್ಗೆತ್ ನಿಪುನ್ ಬಸ್ಲಾತ್ ತೆಕಾ ಜಿವ್ ಕಾಡಿ ಪಾತರ್ ಕಾಯ್ಬಿ ಖಾಯ್ನಾತ್ ಅನಿ ಫಿಯ್ನಾತ್ ಮನುನ್ ಆನ್ ಥವ್ನ್ ತುಜ್ಯಾ ಒಪ್ಗಿಕ್ ವಾಟ್ ರಾಕುನ್ಗೆತ್ ಹಾತ್ ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ತನ್ನಾ ತ್ಯಾ ಸೈನಿಕಾಂಚ್ಯಾ ಮುಖಂಡಾನ್, “ತಿಯಾ ಮಾಕಾ ಸಾಂಗಲ್ಲ್ಯಾ ಯೆವ್ಜನಿಚ್ಯಾ ವಿಶಯಾತ್ ಕೊನಾಕ್ಬಿ ಸಾಂಗುನಕ್ಕೊ” ಮನುನ್ ಸಾಂಗುನ್ ತ್ಯಾ ದಾಂಡ್ಗ್ಯಾ ಮಾನ್ಸಾಕ್ ಧಾಡುನ್ ದಿಲ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ಮಾನಾ ಸೈನಿಕಾಚ್ಯಾ ಮುಂಖಡಾನ್ ದೊನ್ ಸೈನಿಕಾಂಚ್ಯಾ ಅಧಿಕಾರಿಕ್ನಿ ಬಲ್ವುನ್ ತೆಂಕಾ, ಸೆಜರೆಯಾಕ್ ಧಾಡುನ್ ದಿವ್ಕ್ ದೊನ್ಸೆ ಸೈನಿಕಾಕ್ನಿ ತಯಾರ್ ಕರ್, ಅನಿ ಸತ್ತರ್ ಲೊಕಾಂಚಿ ಘೊಡ್ಯಾಂಚಿ ಸೈನ್,ಮಾನಾ ದೊನ್ಸೆ ಲೊಕಾ ಭರ್ಜಿಯಾ ಘೆಟಲಿ ಲೊಕಾ ತಯಾರ್ ಕರ್, ಆಜ್ ರಾತ್ತಿನ್ ನ್ಹೌವ್ ಗಂಟ್ಯಾಕ್ ಹಿತ್ತೆತ್ನಾ ಜಾವ್ಕ್ ತಯಾರ್ ಹೊವ್ಚೆ. ");
INSERT INTO kans_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","“ರಾಜ್ಯ್ ಪಾಲ್ ಫೆಲಿಕ್ಸಾಚ್ಯಾ ಜಗ್ಗೊಳ್ ಪಾವ್ಲುಕ್ ಕಾಯ್ ತರಾಸ್ ನಸ್ತಾನಾ ಬಲ್ವುನ್ ನೆವ್ಕ್ ಪಾಜೆ”, ತಸೆ ಹೊವ್ನ್ ತೆಚ್ಯಾ ಪ್ರಯಾನಾಕ್ ಉಲ್ಲೆ ಘೊಡೆ ತಯಾರ್ ಕರುನ್ ಘೆ, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ಸೈನಿಕಾಂಚ್ಯಾ ಮುಖಂಡಾನ್ ಎಕ್ ಚಿಟ್ ಲಿವ್ಲ್ಯಾನ್, ತ್ಯಾತುರ್ ಅಶೆ ಮನುನ್ ಲಿವಲ್ಲೆ ಹೊತ್ತೆ. ");
INSERT INTO kans_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","ಕ್ಲಾಡಿಸ್ ಲುಸಿಯಾಕ್ನಾ ಮೊಟೊರಾಜಾ ಹೊವ್ನ್ ಹೊತ್ತ್ಯಾ ರಾಜ್ ಪಾಲ್ ಫೆಲಿಕ್ಸಾಕ್, ನಮಸ್ಕಾರ್. ");
INSERT INTO kans_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ಜುದೆವಾಂಚಿ ಲೊಕಾ ಹ್ಯಾ ಮಾನ್ಸಾಕ್ ದರುನ್ ಜಿವ್ ಕಾಡ್ನಾರ್ ಹೊತ್ತಿ, ಖರೆ ಹೊ ಜುದೆವಾಂಚೊ ಮಾನುಸ್ ಮನ್ತಲೆ ಮಾಕಾ ಗೊತ್ತ್ ಹೊಲೆ, ತಸೆ ಹೊವ್ನ್ ಮಿಯಾ ಹೆಕಾ ಸೈನಿಕಾಂಚ್ಯಾ ವಾಂಗ್ಡಾ ಜಾವ್ನ್ ರಾಕ್ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ತೆನಿ ಹೆಚ್ಯಾ ವರ್‍ತಿ ಘಾಲುಲಾಗಲ್ಯಾ ಚುಕೆಕ್ನಿ ಕಾರನ್ ಕಳ್ವುನ್ ಘೆವ್ಚೆ ಮನುನ್ ಮಿಯಾ ಝಡ್ತಿ ಕರ್‍ತಲ್ಯಾ ತಾಂಡ್ಯಾಚ್ಯಾ ಇದ್ರಾಕ್ ಹೆಕಾ ಇಬೆ ಕರ್‍ಲೊ. ");
INSERT INTO kans_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ಖರೆ ಮಾಕಾ ಥೈ ಕಳುನ್ ಯೆಲ್ಲೆ ಕಾಯ್ ಮಟ್ಲ್ಯಾರ್ ಪಾವ್ಲುನ್ ಬುರ್ಶಿ ಕಾಮಾ ಕರ್‍ಲಾ ಮನುನ್ ತೆನಿ ಸಾಂಗ್ಲ್ಯಾರ್ಬಿ ತೆನಿ ಸಾಂಗುಲಾಗಲೆ ತೆಂಚ್ಯಾ ಖಾಯ್ದ್ಯಾಂಚ್ಯಾ ಪುಸ್ತಕಾಕ್ ಸಮಂದ್ ಪಡಲೆ ಹೊತ್ತೆ, ಅನಿ ಹೆಕಾ ಮರ್ನಾಚ್ಯಾ ಶಿಕ್ಷಾಕ್ ಹೊಂವ್ದಿ, ಬಂಧಿಖಾನ್ಯಾಕ್ ಧಾಡ್ತಲ್ಯಾ ಸಾರ್ಕೆ ಹೊಂವ್ದಿ ಕಾಯ್ಬಿ ಚುಕ್ ನತ್ತಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ಖರೆ ಜುದೆವಾಂಚಿ ಥೊಡಿ ಲೊಕಾ ಪಾವ್ಲುಕ್ ಜಿವ್ ಕಾಡುಚೆ ಮನುನ್ ಯೆವ್ಜನ್ ಕರುಲಾಗಲೆ ಮಾಕಾ ಗೊತ್ತ್ ಹೊಲೆ, ತಸೆ ಹೊವ್ನ್, ಮಿಯಾ ತೆಕಾ ತುಜ್ಯಾ ಜಗ್ಗೊಳ್ ಧಾಡುನ್ ದಿಲಾ, ತೌವ್ಡೆಚ್ ನ್ಹಯ್ ತೆನಿ ಕರಲಿ ಚುಕಿಚಿ ಚಾಡಿಯಾ ತುಕಾ ಸಾಂಗುಕ್ ಸಾಂಗ್ತಲ್ಯಾ ಲೊಕಾಕ್ನಿ ಸಾಂಗ್ಲಾ. ");
INSERT INTO kans_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ಸೈನಿಕಾಕ್ನಿ ಸಾಂಗಲ್ಯಾ ಸಾರ್ಕೆ ರಾತ್ತಿನ್ ಪಾವ್ಲುಕ್ ಅಂತಿಪತ್ರಿಯಾ ಮನ್ತಲ್ಯಾ ಶಾರಾಕ್ ನ್ಹೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ದುಸ್ರ್ಯಾಂದಿಸಿ ಪಾವ್ಲುಚ್ಯಾ ವಾಂಗ್ಡಾ ಫಿಡೆ ಜಾವ್ಕ್ ಸಾಟ್ನಿ ಘೊಡೆ ಚಾಲ್ವುತಲ್ಯಾಕ್ನಿ ಸೊಡುನ್ ಸೈನಿಕಾ ಅನಿ ಪಾಟಿ ಪರ್ತುನ್ ಕೊಟೆಕ್ ಯೆಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ಘೊಡ್ಕಿಯಾಂಚ್ಯಾ ಲೊಕಾನಿ ಸೆಜೆರೆಯಾ ಶಾರಾಕ್ ಪಾವ್ನ್ ರಾಜ್ಯ್ ಪಾಲ್ ಫೆಲಿಕ್ಸಾಕ್ ಚಿಟ್ ದಿಲ್ಯಾನ್, ಮಾನಾ ತೆನಿ ಪಾವ್ಲುಕ್‍ ತೆಕಾ ಒಪ್ಸುನ್ ದಿಲ್ಯಾನಿ. ");
INSERT INTO kans_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ರಾಜ್ಯ್ ಪಾಲಾನ್ ಚಿಟ್ ವಾಚ್ಲ್ಯಾನ್ ಅನಿ ತೆನಿ ಪಾವ್ಲುಕ್, “ತಿಯಾ ಖಲ್ಯಾ ದೆಶ್ಯಾಚೊ?” ಮನುನ್ ಇಚಾರ್ತಾನಾ, ಸಿಲಿಸಿಯಾಚೊ ಮನ್ತಲೆ ಕಳುನ್ ಯೆಲೆ. ");
INSERT INTO kans_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ರಾಜ್ಯ್ ಪಾಲಾನ್ “ತುಕಾ ವಿರೊಧ್ ಹೊವ್ನ್ ಹೊತ್ತಿ ಜುದೆವಾಂಚಿ ಲೊಕಾ ಹಿತ್ತೆ ಯೆಲ್ಲ್ಯಾ ತನ್ನಾ ಮಿಯಾ ಇಚಾರ್ನೆ ಕರ್‍ತಾ”, ಮನುನ್ ಸಾಂಗ್ಲ್ಯಾನ್, ಮಾನಾ ಪಾವ್ಲುಕ್ ಹೆರೊದಾಚ್ಯಾ ಘರಾತ್ ಥವ್ಚೆ ಮನುನ್ ಹುಕುಮ್ ದಿಲ್ಯಾನ್. ");
INSERT INTO kans_vpl VALUES ("AC24_1","074_24_1","ACT","