﻿USE sofia;
DROP TABLE IF EXISTS sofia.kanokcv_vpl;
CREATE TABLE kanokcv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kanokcv_vpl WRITE;
INSERT INTO kanokcv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ಆದಿಯಲ್ಲಿ ದೇವರು ಆಕಾಶವನ್ನೂ ಭೂಮಿಯನ್ನೂ ಸೃಷ್ಟಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ಭೂಮಿಯು ನಿರಾಕಾರವಾಗಿಯೂ ಬರಿದಾಗಿಯೂ ಇತ್ತು. ಆದಿಸಾಗರದ ಮೇಲೆ ಕತ್ತಲೆ ಕವಿದಿತ್ತು. ದೇವರಾತ್ಮರು ಜಲ ಸಮೂಹಗಳ ಮೇಲೆ ಚಲಿಸುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ಆಗ ದೇವರು, “ಬೆಳಕಾಗಲಿ” ಎನ್ನಲು, ಬೆಳಕಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ದೇವರು ಬೆಳಕನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡರು. ದೇವರು ಬೆಳಕನ್ನು ಕತ್ತಲೆಯಿಂದ ಪ್ರತ್ಯೇಕಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ದೇವರು ಬೆಳಕಿಗೆ ಹಗಲು ಎಂದೂ ಕತ್ತಲೆಗೆ ರಾತ್ರಿ ಎಂದೂ ಕರೆದರು. ಆಗ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಮೊದಲನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ನಂತರ ದೇವರು, “ಜಲರಾಶಿಯ ನಡುವೆ ವಿಸ್ತಾರವಾದ ಗುಮ್ಮಟವಾಗಲಿ, ಅದು ನೀರಿನಿಂದ ಭೂಮಿಯನ್ನು ಪ್ರತ್ಯೇಕ ಮಾಡಲಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ಹೀಗೆ ದೇವರು ವಿಸ್ತಾರವಾದ ಗುಮ್ಮಟವನ್ನು ಅದರ ಕೆಳಗಿದ್ದ ನೀರನ್ನೂ ಅದರ ಮೇಲಿದ್ದ ನೀರನ್ನೂ ಪ್ರತ್ಯೇಕಿಸಿದರು. ಅದು ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ದೇವರು ಆ ಗುಮ್ಮಟಕ್ಕೆ ಆಕಾಶ ಎಂದು ಕರೆದರು. ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಎರಡನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ಆಗ ದೇವರು, “ಆಕಾಶದ ಕೆಳಗಿರುವ ನೀರು ಒಂದೇ ಸ್ಥಳದಲ್ಲಿ ಕೂಡಿಕೊಳ್ಳಲಿ, ಒಣ ನೆಲವು ಕಾಣಿಸಲಿ,” ಎಂದರು. ಅದು ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ದೇವರು ಒಣ ನೆಲಕ್ಕೆ “ಭೂಮಿ” ಎಂದೂ ಕೂಡಿಕೊಂಡಿದ್ದ ನೀರಿಗೆ “ಸಮುದ್ರ” ಎಂದೂ ಹೆಸರಿಟ್ಟರು. ದೇವರು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ಅನಂತರ ದೇವರು, “ಭೂಮಿಯು ಹುಲ್ಲನ್ನೂ ಬೀಜಬಿಡುವ ಗಿಡಗಳನ್ನೂ ಅದರದರ ಜಾತಿಗನುಸಾರವಾಗಿ ಬೀಜವುಳ್ಳ ಹಣ್ಣಿನ ಮರಗಳನ್ನೂ ಉತ್ಪತ್ತಿ ಮಾಡಲಿ,” ಎಂದು ಹೇಳಿದರು. ಅದು ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ಭೂಮಿಯ ಮೇಲೆ ತಮ್ಮ ತಮ್ಮ ಜಾತಿಯ ಪ್ರಕಾರ ಬೀಜಬಿಡುವ ಕಾಯಿಪಲ್ಯದ ಗಿಡಗಳು ಉಂಟಾದವು ಮತ್ತು ಅದರದರ ಜಾತಿಗನುಸಾರವಾಗಿ ಬೀಜವುಳ್ಳ ಹಣ್ಣಿನ ಮರಗಳನ್ನು ಮೊಳೆಯಿಸಿದವು. ದೇವರು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಮೂರನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ಅನಂತರ ದೇವರು, “ಹಗಲನ್ನು ರಾತ್ರಿಯಿಂದ ಪ್ರತ್ಯೇಕಿಸುವುದಕ್ಕೆ ಆಕಾಶಮಂಡಲದಲ್ಲಿ ಬೆಳಕುಗಳಿರಲಿ; ಅವು ಕಾಲಗಳನ್ನೂ ದಿನ ಸಂವತ್ಸರಗಳನ್ನೂ ಸೂಚಿಸುವ ಗುರುತುಗಳಾಗಿರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ಅವು ಭೂಮಿಗೆ ಬೆಳಕನ್ನು ಕೊಡುವುದಕ್ಕೆ ಆಕಾಶಮಂಡಲದಲ್ಲಿ ದೀಪಗಳಂತಿರಲಿ,” ಎಂದರು. ಅದು ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ಹಗಲನ್ನಾಳುವುದಕ್ಕೆ ದೊಡ್ಡ ಬೆಳಕನ್ನು, ರಾತ್ರಿಯನ್ನಾಳುವುದಕ್ಕೆ ಚಿಕ್ಕ ಬೆಳಕನ್ನು ಎಂಬಂತೆ ದೇವರು ಎರಡು ದೊಡ್ಡ ಬೆಳಕುಗಳನ್ನು ಉಂಟುಮಾಡಿದರು. ದೇವರು ನಕ್ಷತ್ರಗಳನ್ನು ಸಹ ಉಂಟುಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ದೇವರು ಆ ಬೆಳಕುಗಳನ್ನು ಆಕಾಶದಲ್ಲಿಟ್ಟು ಭೂಮಿಗೆ ಬೆಳಕನ್ನು ಕೊಡುವುದಕ್ಕೂ ");
INSERT INTO kanokcv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ಹಗಲನ್ನು ಮತ್ತು ರಾತ್ರಿಯನ್ನು ಆಳುವುದಕ್ಕೂ ಬೆಳಕನ್ನು ಕತ್ತಲೆಯಿಂದ ಪ್ರತ್ಯೇಕಿಸುವುದಕ್ಕೂ ದೇವರು ಅವುಗಳನ್ನು ನೇಮಿಸಿದರು. ದೇವರು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ನಾಲ್ಕನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ಆಮೇಲೆ ದೇವರು, “ನೀರಿನಲ್ಲಿ ಜೀವಜಂತುಗಳು ತುಂಬಿಕೊಳ್ಳಲಿ, ಭೂಮಿಯ ಮೇಲೆ ಆಕಾಶಮಂಡಲದಲ್ಲಿ ಪಕ್ಷಿಗಳು ಹಾರಾಡಲಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ಹೀಗೆ ದೇವರು ದೊಡ್ಡ ಜಲಚರಗಳನ್ನು, ನೀರಿನಲ್ಲಿ ತುಂಬಿರುವ ಎಲ್ಲಾ ಚಲಿಸುವ ಜೀವ ಜಂತುಗಳನ್ನು, ರೆಕ್ಕೆಗಳುಳ್ಳ ಪ್ರತಿಯೊಂದು ಪಕ್ಷಿಯನ್ನು ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ ಸೃಷ್ಟಿಸಿದರು. ದೇವರು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ದೇವರು ಅವುಗಳನ್ನು ಆಶೀರ್ವದಿಸಿ ಅವುಗಳಿಗೆ, “ನೀವು ಅಭಿವೃದ್ಧಿಯಾಗಿ ಹೆಚ್ಚಿರಿ, ಸಮುದ್ರಗಳಲ್ಲಿ ನೀರನ್ನು ತುಂಬಿರಿ, ಭೂಮಿಯ ಮೇಲೆ ಪಕ್ಷಿಗಳ ಸಂಖ್ಯೆ ಹೆಚ್ಚಾಗಲಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಐದನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ಆಮೇಲೆ ದೇವರು, “ಭೂಮಿಯಿಂದ ಎಲ್ಲಾ ತರಹದ ಜೀವಿಗಳು ಉಂಟಾಗಲಿ: ಪಶುಗಳು, ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಜೀವಿಗಳು, ಕಾಡುಮೃಗಗಳು, ತಮ್ಮ ತಮ್ಮ ಜಾತಿಗನುಸಾರವಾಗಿ ಉಂಟಾಗಲಿ,” ಎಂದರು. ಅದು ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ಹೀಗೆ ದೇವರು ಎಲ್ಲ ತರದ ಕಾಡುಮೃಗಗಳನ್ನೂ ಪಶುಗಳನ್ನೂ ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಜೀವಿಗಳನ್ನೂ ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ ಉಂಟುಮಾಡಿದರು. ದೇವರು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ತರುವಾಯ ದೇವರು, “ನಾವು ನಮ್ಮ ಸ್ವರೂಪದಲ್ಲಿ, ನಮ್ಮ ಹೋಲಿಕೆಯಲ್ಲಿ ಮನುಷ್ಯನನ್ನು ಉಂಟುಮಾಡೋಣ. ಅವರು ಸಮುದ್ರದಲ್ಲಿರುವ ಮೀನುಗಳ ಮೇಲೆಯೂ ಆಕಾಶದ ಪಕ್ಷಿಗಳ ಮೇಲೆಯೂ ಪಶುಗಳ ಮೇಲೆಯೂ ಕಾಡುಮೃಗಗಳ ಮೇಲೆಯೂ ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಎಲ್ಲಾ ಜೀವಿಗಳ ಮೇಲೆಯೂ ಆಳ್ವಿಕೆ ಮಾಡಲಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ಹೀಗೆ ದೇವರು ಮನುಷ್ಯನನ್ನು ತಮ್ಮ ಸ್ವರೂಪದಲ್ಲಿ ಸೃಷ್ಟಿ ಮಾಡಿದರು. ದೇವರ ಸ್ವರೂಪದಲ್ಲಿಯೇ ಅವರನ್ನು ಸೃಷ್ಟಿ ಮಾಡಿದರು. ಅವರನ್ನು ಗಂಡು ಹೆಣ್ಣಾಗಿ ಸೃಷ್ಟಿ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ದೇವರು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ, “ನೀವು ಸಂತಾನವುಳ್ಳವರಾಗಿ, ಸಂಖ್ಯೆಯಲ್ಲಿ ಹೆಚ್ಚಿರಿ, ಭೂಮಿಯನ್ನು ತುಂಬಿಸಿ ಅದನ್ನು ಆಳಿರಿ. ಸಮುದ್ರದ ಮೀನುಗಳ ಮೇಲೆಯೂ ಆಕಾಶದ ಪಕ್ಷಿಗಳ ಮೇಲೆಯೂ ನೆಲದ ಮೇಲೆ ಚಲಿಸುವ ಎಲ್ಲಾ ಜೀವಿಗಳ ಮೇಲೆಯೂ ಆಳ್ವಿಕೆ ನಡೆಸಿರಿ,” ಎಂದು ಅವರಿಗೆ ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ದೇವರು, “ಇಗೋ, ಭೂಮಿಯ ಮೇಲಿರುವ ಬೀಜಬಿಡುವ ಸಕಲ ಸಸ್ಯಗಳನ್ನೂ ಬೀಜಬಿಡುವ ಸಕಲ ಹಣ್ಣಿನ ಮರಗಳನ್ನೂ ನಿಮಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ಅವು ನಿಮಗೆ ಆಹಾರಕ್ಕಾಗಿರುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ಭೂಮಿಯಲ್ಲಿರುವ ಎಲ್ಲಾ ಜೀವಿಗಳಿಗೂ ಆಕಾಶದ ಪಕ್ಷಿಗಳಿಗೂ ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಜೀವಿಗಳಿಗೂ ಉಸಿರನ್ನು ಹೊಂದಿರುವ ಪ್ರತಿಯೊಂದು ಜೀವಿಗಳಿಗೆ ಹಸಿರಾದ ಸಸ್ಯಗಳನ್ನೆಲ್ಲಾ ನಾನು ಆಹಾರವಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ,” ಎಂದರು. ಅದು ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ದೇವರು ತಾವು ಉಂಟು ಮಾಡಿದ್ದನ್ನೆಲ್ಲಾ ನೋಡಲು, ಅವೆಲ್ಲವೂ ಬಹಳ ಒಳ್ಳೆಯದಾಗಿದ್ದವು. ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಆರನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ಹೀಗೆ ಭೂಮ್ಯಾಕಾಶಗಳೂ ಅವುಗಳಲ್ಲಿರುವ ಸಮಸ್ತವೂ ಸಂಪೂರ್ಣವಾಗಿ ನಿರ್ಮಿತವಾದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ದೇವರು ತಮ್ಮ ಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ಮುಗಿಸಿದ ಮೇಲೆ ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ಅನಂತರ ದೇವರು ಏಳನೆಯ ದಿನವನ್ನು ಆಶೀರ್ವದಿಸಿ, ಅದನ್ನು ಪವಿತ್ರ ದಿನವನ್ನಾಗಿ ಮಾಡಿದರು. ಏಕೆಂದರೆ ಆ ದಿನದಲ್ಲಿ ದೇವರು ಸೃಷ್ಟಿಸಿದ ತಮ್ಮ ಎಲ್ಲಾ ಕೆಲಸಗಳಿಂದ ವಿಶ್ರಮಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ಯೆಹೋವ ದೇವರು ಭೂಮ್ಯಾಕಾಶಗಳನ್ನು ಉಂಟುಮಾಡಿದರು. ಇದೇ ಭೂಮ್ಯಾಕಾಶಗಳ ನಿರ್ಮಾಣ ಚರಿತ್ರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ಭೂಮಿಯಲ್ಲಿ ಯಾವ ಗಿಡವೂ ಇನ್ನೂ ಬೆಳೆದಿರಲಿಲ್ಲ, ಯಾವ ಪಲ್ಯವೂ ಇನ್ನೂ ಮೊಳೆತಿರಲಿಲ್ಲ. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ಭೂಮಿಯ ಮೇಲೆ ಮಳೆ ಸುರಿಸಿರಲಿಲ್ಲ. ಆಗ ಭೂಮಿಯನ್ನು ವ್ಯವಸಾಯ ಮಾಡುವುದಕ್ಕೆ ಮನುಷ್ಯನೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ಆದರೆ ಭೂಮಿಯಿಂದ ಮಂಜು ಏರಿಬಂದು ನೆಲವನ್ನೆಲ್ಲಾ ತೋಯಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ಹೀಗಿರಲು ಯೆಹೋವ ದೇವರು ನೆಲದ ಮಣ್ಣಿನಿಂದ ಮನುಷ್ಯನನ್ನು ರೂಪಿಸಿ, ಅವನ ಮೂಗಿನಲ್ಲಿ ಜೀವಶ್ವಾಸವನ್ನು ಊದಿದರು ಆಗ ಅವನು ಜೀವಿಸುವ ವ್ಯಕ್ತಿಯಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ಯೆಹೋವ ದೇವರು ಪೂರ್ವದಿಕ್ಕಿಗಿರುವ ಏದೆನ್ ಸೀಮೆಯಲ್ಲಿ ತೋಟವನ್ನು ಮಾಡಿ, ತಾವು ರೂಪಿಸಿದ ಮನುಷ್ಯನನ್ನು ಅದರಲ್ಲಿ ಇರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ಯೆಹೋವ ದೇವರು ನೋಟಕ್ಕೆ ರಮ್ಯವೂ ಊಟಕ್ಕೆ ಒಳ್ಳೆಯವೂ ಆದ ಎಲ್ಲಾ ಮರಗಳನ್ನೂ ಭೂಮಿಯಲ್ಲಿ ಬೆಳೆಯುವಂತೆ ಮಾಡಿದರು. ತೋಟದ ಮಧ್ಯದಲ್ಲಿ ಜೀವದ ಮರವನ್ನೂ ಒಳ್ಳೆಯದರ ಮತ್ತು ಕೆಟ್ಟದ್ದರ ತಿಳುವಳಿಕೆಯ ಮರವನ್ನೂ ಬೆಳೆಯುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ಏದೆನ್ ಸೀಮೆಯಿಂದ ಒಂದು ನದಿ ಹರಿದು, ತೋಟವನ್ನು ತೋಯಿಸುತ್ತಿತ್ತು. ಅದು ಅಲ್ಲಿಂದ ಹರಿದು ವಿಭಾಗವಾಗಿ, ನಾಲ್ಕು ಉಪನದಿಗಳಾದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ಮೊದಲನೆಯದರ ಹೆಸರು ಪೀಶೋನ್; ಅದು ಬಂಗಾರವಿರುವ ಹವೀಲ ದೇಶವನ್ನೆಲ್ಲಾ ಸುತ್ತಿ ಹರಿಯುತ್ತಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ಆ ದೇಶದ ಬಂಗಾರವು ಉತ್ತಮವಾಗಿತ್ತು. ಅಲ್ಲಿ ಬದೋಲಖ ಧೂಪ ಮತ್ತು ಗೋಮೇಧಿಕ ರತ್ನ ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ಎರಡನೆಯ ನದಿಯ ಹೆಸರು ಗೀಹೋನ್; ಅದು ಕೂಷ್ ದೇಶವನ್ನೆಲ್ಲಾ ಸುತ್ತಿ ಹರಿಯುತ್ತಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ಮೂರನೆಯ ನದಿಯ ಹೆಸರು ಟೈಗ್ರಿಸ್; ಅದು ಅಸ್ಸೀರಿಯಾ ದೇಶದ ಪೂರ್ವಕ್ಕೆ ಹರಿಯುತ್ತಿತ್ತು. ನಾಲ್ಕನೆಯ ನದಿಯು ಯೂಫ್ರೇಟೀಸ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ಯೆಹೋವ ದೇವರು ಮನುಷ್ಯನನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗಿ, ಏದೆನ್ ತೋಟದಲ್ಲಿ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೂ ಕಾಯುವುದಕ್ಕೂ ಅದರಲ್ಲಿ ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ಮನುಷ್ಯನಿಗೆ, “ನೀನು ತೋಟದ ಎಲ್ಲಾ ಮರಗಳ ಹಣ್ಣುಗಳನ್ನು ನಿನ್ನ ಇಷ್ಟಾನುಸಾರವಾಗಿ ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ಆದರೆ ಒಳ್ಳೆಯದರ, ಕೆಟ್ಟದ್ದರ ತಿಳುವಳಿಕೆಯ ಮರದ ಹಣ್ಣನ್ನು ನೀನು ತಿನ್ನಬಾರದು. ಏಕೆಂದರೆ, ನೀನು ಅದನ್ನು ತಿಂದ ದಿನವೇ ಸಾಯುವಿ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ಅನಂತರ ಯೆಹೋವ ದೇವರು, “ಮನುಷ್ಯನು ಒಂಟಿಯಾಗಿರುವುದು ಒಳ್ಳೆಯದಲ್ಲ. ಅವನಿಗೆ ಸರಿಬೀಳುವ ಸಹಕಾರಿಣಿಯನ್ನು ಉಂಟುಮಾಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ಯೆಹೋವ ದೇವರು ಭೂಮಿಯಲ್ಲಿರುವ ಎಲ್ಲಾ ಕಾಡುಮೃಗಗಳನ್ನೂ ಆಕಾಶದ ಎಲ್ಲಾ ಪಕ್ಷಿಗಳನ್ನೂ ಮಣ್ಣಿನಿಂದ ರೂಪಿಸಿದ ಮೇಲೆ, ಅವುಗಳಿಗೆ ಮನುಷ್ಯನು ಏನು ಹೆಸರಿಡುವನೋ ಎಂದು ನೋಡುವುದಕ್ಕೆ, ಅವುಗಳನ್ನು ಅವನ ಬಳಿಗೆ ತಂದರು. ಒಂದೊಂದು ಜೀವಿಗೂ ಮನುಷ್ಯನು ಕರೆದದ್ದೇ ಆ ಜೀವಿಗಳಿಗೆಲ್ಲಾ ಹೆಸರಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ಹೀಗೆ ಮನುಷ್ಯನು ಎಲ್ಲಾ ಪಶುಗಳಿಗೂ ಆಕಾಶದ ಪಕ್ಷಿಗಳಿಗೂ ಕಾಡುಮೃಗಗಳಿಗೂ ಹೆಸರಿಟ್ಟನು. ಆದರೆ ಆದಾಮನಿಗೆ ಸರಿಬೀಳುವ ಸಹಕಾರಿಣಿಯು ಕಾಣಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ಆದಕಾರಣ ಯೆಹೋವ ದೇವರು ಮನುಷ್ಯನಿಗೆ ಗಾಢನಿದ್ರೆ ಬರಮಾಡಿದರು. ಅವನು ನಿದ್ರಿಸುತ್ತಿರುವಾಗ, ಅವರು ಅವನ ಪಕ್ಕೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದರ ಸ್ಥಳವನ್ನು ಮಾಂಸದಿಂದ ಮುಚ್ಚಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ಬಳಿಕ ಯೆಹೋವ ದೇವರು ಮನುಷ್ಯನಿಂದ ತೆಗೆದಿದ್ದ ಪಕ್ಕೆಯಿಂದ ಒಬ್ಬ ಸ್ತ್ರೀಯನ್ನು ಉಂಟುಮಾಡಿ, ಆಕೆಯನ್ನು ಆ ಮನುಷ್ಯನ ಬಳಿಗೆ ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ಆಗ ಮನುಷ್ಯನು ಹೀಗೆ ಹೇಳಿದನು: “ಇದು ನನ್ನ ಎಲುಬಿನಿಂದಾದ ಎಲುಬು ಮತ್ತು ನನ್ನ ಮಾಂಸದಿಂದಾದ ಮಾಂಸವಾಗಿದೆ. ಈಕೆ ನರನಿಂದ ತೆಗೆದಿರುವುದರಿಂದ, ಈಕೆ, ‘ನಾರಿ’ ಎಂದು ಎನಿಸಿಕೊಳ್ಳುವಳು.” ");
INSERT INTO kanokcv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ಈ ಕಾರಣದಿಂದ ಪುರುಷನು ತಂದೆತಾಯಿಗಳನ್ನು ಬಿಟ್ಟು, ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಸೇರಿಕೊಳ್ಳುವನು. ಅವರಿಬ್ಬರೂ ಒಂದೇ ಶರೀರವಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ಆದಾಮನೂ ಅವನ ಹೆಂಡತಿಯೂ ಬೆತ್ತಲೆಯಾಗಿದ್ದರೂ ನಾಚಿಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ಯೆಹೋವ ದೇವರು ಸೃಷ್ಟಿಸಿದ ಅಡವಿಯ ಎಲ್ಲಾ ಕಾಡುಮೃಗಗಳಿಗಿಂತ ಸರ್ಪವು ಬಹು ಯುಕ್ತಿಯುಳ್ಳದ್ದಾಗಿತ್ತು. ಅದು ಸ್ತ್ರೀಗೆ, “ನೀವು ತೋಟದಲ್ಲಿರುವ ಯಾವ ಮರದ ಹಣ್ಣನ್ನೂ ತಿನ್ನಬಾರದೆಂದು ದೇವರು ಹೇಳಿದ್ದು ನಿಜವೋ?” ಎಂದು ಕೇಳಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ಆಗ ಸ್ತ್ರೀಯು ಸರ್ಪಕ್ಕೆ, “ತೋಟದ ಮರಗಳ ಹಣ್ಣುಗಳನ್ನು ನಾವು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ಆದರೆ ತೋಟದ ಮಧ್ಯದಲ್ಲಿರುವ ಈ ಮರದ ಹಣ್ಣಿನ ವಿಷಯವಾಗಿ, ‘ನೀವು ಇದನ್ನು ತಿನ್ನಲೂ ಕೂಡದು, ಮುಟ್ಟಲೂ ಕೂಡದು; ತಿಂದರೆ ಸತ್ತು ಹೋಗುವಿರಿ’ ಎಂದು ದೇವರು ಹೇಳಿದ್ದಾರೆ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ಸರ್ಪವು ಸ್ತ್ರೀಗೆ, “ನೀವು ನಿಶ್ಚಯವಾಗಿ ಸಾಯುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ನೀವು ಇದನ್ನು ತಿಂದ ದಿನದಲ್ಲಿ ನಿಮ್ಮ ಕಣ್ಣುಗಳು ತೆರೆಯುವುವು, ನೀವು ಒಳ್ಳೆಯದನ್ನು ಮತ್ತು ಕೆಟ್ಟದ್ದನ್ನು ಅರಿತವರಾಗಿ ದೇವರ ಹಾಗೆ ಇರುವಿರಿ. ಇದು ದೇವರಿಗೆ ತಿಳಿದಿದೆ,” ಎಂದು ಹೇಳಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ಆಗ ಸ್ತ್ರೀಯು, ಆ ಮರದ ಹಣ್ಣು ಆಹಾರಕ್ಕೆ ಒಳ್ಳೆಯದಾಗಿಯೂ ಕಣ್ಣಿಗೆ ರಮ್ಯವಾಗಿಯೂ ಜ್ಞಾನೋದಯಕ್ಕೆ ಅಪೇಕ್ಷಿಸತಕ್ಕದ್ದಾಗಿಯೂ ಇದೆ ಎಂದು ತಿಳಿದು, ಆ ಹಣ್ಣನ್ನು ತೆಗೆದುಕೊಂಡು ತಿಂದಳು. ತನ್ನ ಸಂಗಡ ಇದ್ದ ಗಂಡನಿಗೂ ಕೊಟ್ಟಳು, ಅವನೂ ತಿಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ಆಗ ಅವರಿಬ್ಬರ ಕಣ್ಣುಗಳು ತೆರೆದವು. ತಾವು ಬೆತ್ತಲೆಯಾಗಿದ್ದೇವೆಂದು ತಿಳಿದು, ಅವರು ಅಂಜೂರದ ಎಲೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ತಮಗೆ ತಾವೇ ಉಡುಪುಗಳನ್ನು ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ತರುವಾಯ ಯೆಹೋವ ದೇವರು, ಸಂಜೆಯ ತಂಗಾಳಿಯಲ್ಲಿ ತೋಟದೊಳಗೆ ಸಂಚರಿಸುತ್ತಿರುವಾಗ, ಆ ಸ್ತ್ರೀ ಪುರುಷರು ಅವರ ಸಪ್ಪಳವನ್ನು ಕೇಳಿ, ಅವರಿಗೆ ಕಾಣಿಸಿಕೊಳ್ಳಬಾರದೆಂದು ತೋಟದ ಮರಗಳ ಮಧ್ಯದಲ್ಲಿ ಅಡಗಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ಆಗ ಯೆಹೋವ ದೇವರು ಮನುಷ್ಯನನ್ನು ಕರೆದು ಅವನಿಗೆ, “ನೀನು ಎಲ್ಲಿದ್ದೀ?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ಅದಕ್ಕೆ ಅವನು, “ನಿನ್ನ ಶಬ್ದವನ್ನು ನಾನು ತೋಟದಲ್ಲಿ ಕೇಳಿದೆ. ನಾನು ಬೆತ್ತಲೆಯಾಗಿರುವುದರಿಂದ ಭಯಪಟ್ಟು ಅಡಗಿಕೊಂಡೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ಅದಕ್ಕೆ ದೇವರು, “ನೀನು ಬೆತ್ತಲೆಯಾಗಿದ್ದೀ ಎಂದು ನಿನಗೆ ತಿಳಿಸಿದವರು ಯಾರು? ತಿನ್ನಬಾರದೆಂದು ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮರದ ಹಣ್ಣನ್ನು ತಿಂದಿದ್ದೀಯೋ?” ಎಂದು ಕೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ಅದಕ್ಕೆ ಮನುಷ್ಯನು, “ನೀನು ನನ್ನ ಸಂಗಡ ಇರಿಸಿದ ಸ್ತ್ರೀಯು ಆ ಮರದ ಹಣ್ಣನ್ನು ನನಗೆ ಕೊಟ್ಟಳು. ನಾನು ತಿಂದೆನು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ಯೆಹೋವ ದೇವರು ಸ್ತ್ರೀಗೆ, “ಇದೇನು ನೀನು ಮಾಡಿದ್ದು?” ಎಂದು ಕೇಳಲು, ಅದಕ್ಕೆ ಸ್ತ್ರೀಯು, “ಸರ್ಪವು ನನ್ನನ್ನು ವಂಚಿಸಿತು. ನಾನು ತಿಂದೆನು,” ಎಂದು ಉತ್ತರಕೊಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ಆಗ ಯೆಹೋವ ದೇವರು ಸರ್ಪಕ್ಕೆ ಹೀಗೆ ಹೇಳಿದರು, “ನೀನು ಇದನ್ನು ಮಾಡಿದ ಕಾರಣ, “ಎಲ್ಲಾ ಪಶುಗಳಲ್ಲಿಯೂ ಎಲ್ಲಾ ಕಾಡುಮೃಗಗಳಲ್ಲಿಯೂ ನೀನು ಬಹು ಶಾಪಗ್ರಸ್ತನಾದೆ. ಇಂದಿನಿಂದ ನಿನ್ನ ಜೀವನ ಪೂರ್ತಿ ಹೊಟ್ಟೆಯಿಂದ ಹರಿದಾಡಿ, ಮಣ್ಣನ್ನು ತಿನ್ನುವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ನಾನು ನಿನಗೂ ಸ್ತ್ರೀಗೂ ನಿಮ್ಮ ಸಂತಾನಕ್ಕೂ ಆಕೆಯ ಸಂತಾನಕ್ಕೂ ವೈರತ್ವವನ್ನು ಇಡುವೆನು. ಆತನು ನಿನ್ನ ತಲೆಯನ್ನು ಜಜ್ಜುವನು ಮತ್ತು ನೀನು ಆತನ ಹಿಮ್ಮಡಿಯನ್ನು ಕಚ್ಚುವಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ಬಳಿಕ ದೇವರು ಸ್ತ್ರೀಗೆ ಹೀಗೆ ಹೇಳಿದರು, “ನಾನು ನಿನ್ನ ಗರ್ಭ ವೇದನೆಯನ್ನು ಅಧಿಕವಾಗಿ ಹೆಚ್ಚಿಸುವೆನು. ನೀನು ನೋವಿನಿಂದ ಮಕ್ಕಳನ್ನು ಹೆರುವಿ. ನಿನ್ನ ಗಂಡನ ಮೇಲೆ ನಿನ್ನ ಬಯಕೆ ಇರುವುದು. ಅವನು ನಿನ್ನನ್ನು ಆಳುವನು.” ");
INSERT INTO kanokcv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ಅನಂತರ ದೇವರು ಆದಾಮನಿಗೆ ಹೀಗೆ ಹೇಳಿದರು, “ತಿನ್ನಬಾರದೆಂದು ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮರದ ಫಲವನ್ನು ನಿನ್ನ ಹೆಂಡತಿಯ ಮಾತು ಕೇಳಿ ತಿಂದ ಕಾರಣ, “ನಿನ್ನ ನಿಮಿತ್ತ ಭೂಮಿಗೆ ಶಾಪ ಬಂತು. ನಿನ್ನ ಜೀವಮಾನವೆಲ್ಲಾ ಕಷ್ಟಪಟ್ಟು ದುಡಿದು, ಅದರ ಹುಟ್ಟುವಳಿಯನ್ನು ಉಣ್ಣುವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ಭೂಮಿಯಲ್ಲಿ ಮುಳ್ಳುಗಿಡಗಳೂ ಕಳ್ಳಿಗಳೂ ಬೆಳೆಯುವುವು. ನೀನು ಹೊಲದ ಬೆಳೆಯನ್ನು ಉಣ್ಣುವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ನೀನು ಪುನಃ ಮಣ್ಣಿಗೆ ಸೇರುವ ತನಕ, ಬೆವರಿಡುತ್ತಾ ಆಹಾರವನ್ನು ಉಣ್ಣುವೆ. ನೀನು ಮಣ್ಣಿನಿಂದ ತೆಗೆದವನಾಗಿರುವುದರಿಂದ ನೀನು ಮಣ್ಣೇ. ನೀನು ಪುನಃ ಮಣ್ಣಿಗೆ ಸೇರತಕ್ಕವನು.” ");
INSERT INTO kanokcv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ಆದಾಮನು ತನ್ನ ಹೆಂಡತಿಯ ಹೆಸರನ್ನು ಹವ್ವ ಎಂದು ಕರೆದನು. ಏಕೆಂದರೆ ಆಕೆಯೇ ಬದುಕಿದವರಿಗೆಲ್ಲಾ ತಾಯಿಯಾಗಿದ್ದಾಳೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ಯೆಹೋವ ದೇವರು ಆದಾಮನಿಗೂ ಅವನ ಹೆಂಡತಿಗೂ ಚರ್ಮದ ಅಂಗಿಗಳನ್ನು ಮಾಡಿ ತೊಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ಯೆಹೋವ ದೇವರು, “ಇಗೋ, ಮನುಷ್ಯನು ಒಳ್ಳೆಯದನ್ನು ಮತ್ತು ಕೆಟ್ಟದ್ದನ್ನು ತಿಳಿದು, ನಮ್ಮಲ್ಲಿ ಒಬ್ಬನಂತಾದನಲ್ಲಾ. ಈಗ ಅವನು ಕೈಚಾಚಿ, ಜೀವವೃಕ್ಷದ ಹಣ್ಣನ್ನು ಸಹ ತಿಂದು, ಶಾಶ್ವತವಾಗಿ ಬದುಕುವವನಾಗಬಾರದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ಆದ್ದರಿಂದ ಅವನು ಉತ್ಪತ್ತಿಯಾದ ಭೂಮಿಯನ್ನೇ ವ್ಯವಸಾಯ ಮಾಡುವುದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ಏದೆನ್ ತೋಟದೊಳಗಿಂದ ಅವನನ್ನು ಹೊರಗೆ ಕಳುಹಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ಹೀಗೆ ಅವರು ಮನುಷ್ಯನನ್ನು ಹೊರಗೆ ಹಾಕಿ, ಜೀವವೃಕ್ಷದ ದಾರಿಯನ್ನು ಕಾಯುವುದಕ್ಕೆ ಏದೆನ್ ತೋಟದ ಪೂರ್ವದಲ್ಲಿ ಕೆರೂಬಿಯರನ್ನೂ ಎಲ್ಲಾ ಕಡೆಯಲ್ಲಿ ಸುತ್ತುವ ಜ್ವಾಲೆಯ ಖಡ್ಗವನ್ನೂ ಇರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ಆದಾಮನು ತನ್ನ ಹೆಂಡತಿಯಾದ ಹವ್ವಳನ್ನು ಕೂಡಲು, ಆಕೆಯು ಗರ್ಭಿಣಿಯಾಗಿ, ಕಾಯಿನನನ್ನು ಹೆತ್ತು, “ನಾನು ಯೆಹೋವ ದೇವರ ಅನುಗ್ರಹದಿಂದ ಗಂಡು ಮಗುವನ್ನು ಪಡೆದಿದ್ದೇನೆ,” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ಅನಂತರ ಆಕೆಯು ಅವನ ತಮ್ಮನಾದ ಹೇಬೆಲನನ್ನು ಹೆತ್ತಳು. ಹೇಬೆಲನು ಕುರಿ ಕಾಯುವವನಾದನು ಮತ್ತು ಕಾಯಿನನು ವ್ಯವಸಾಯ ಮಾಡುವವನಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ಸ್ವಲ್ಪ ಕಾಲದ ತರುವಾಯ, ಕಾಯಿನನು ಹೊಲದ ಬೆಳೆಯಲ್ಲಿ ಕೆಲವನ್ನು ತಂದು, ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ಹೇಬೆಲನು ಸಹ ತನ್ನ ಹಿಂಡಿನಿಂದ ಚೊಚ್ಚಲ ಕುರಿಗಳನ್ನೂ ಅವುಗಳ ಕೊಬ್ಬನ್ನೂ ತಂದನು. ಯೆಹೋವ ದೇವರು ಹೇಬೆಲನನ್ನೂ ಅವನ ಕಾಣಿಕೆಯನ್ನೂ ಮೆಚ್ಚಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ಆದರೆ ಕಾಯಿನನನ್ನೂ ಅವನ ಕಾಣಿಕೆಯನ್ನೂ ದೇವರು ಮೆಚ್ಚಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಕಾಯಿನನು ಬಹು ಕೋಪಗೊಂಡನು. ಅವನ ಮುಖವು ಬಾಡಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ಆಗ ಯೆಹೋವ ದೇವರು ಕಾಯಿನನಿಗೆ, “ನೀನು ಕೋಪಗೊಂಡಿದ್ದೇಕೆ? ಏಕೆ ನಿನ್ನ ಮುಖವು ಬಾಡಿದೆ? ");
INSERT INTO kanokcv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ನೀನು ಒಳ್ಳೆಯದನ್ನು ಮಾಡಿದರೆ, ನೀನು ಸ್ವೀಕಾರವಾಗುತ್ತಿದ್ದೆ ಅಲ್ಲವೇ? ನೀನು ಒಳ್ಳೆಯದನ್ನು ಮಾಡದೆ ಹೋದರೆ, ಬಾಗಿಲಲ್ಲಿ ಪಾಪವು ಹೊಂಚಿಕೊಂಡಿರುವುದು ಮತ್ತು ಅದು ನಿನ್ನನ್ನು ನುಂಗಲು ಬಯಸುತ್ತದೆ. ಆದರೂ ನೀನು ಅದರ ಮೇಲೆ ಅಧಿಕಾರ ಮಾಡಬೇಕು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ಅನಂತರ ಕಾಯಿನನು, “ಅಡವಿಗೆ ಹೋಗೋಣ ಬಾ,” ಎಂದು ತನ್ನ ತಮ್ಮನಿಗೆ ಹೇಳಿದನು. ಅವರು ಅಲ್ಲಿ ಬಂದಾಗ ಕಾಯಿನನು ತನ್ನ ತಮ್ಮ ಹೇಬೆಲನ ಮೇಲೆ ದಾಳಿಮಾಡಿ, ಅವನನ್ನು ಕೊಂದುಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ಯೆಹೋವ ದೇವರು ಕಾಯಿನನನ್ನು, “ನಿನ್ನ ತಮ್ಮ ಹೇಬೆಲನು ಎಲ್ಲಿ?” ಎಂದು ಕೇಳಲು, ಅವನು, “ನಾನರಿಯೆ. ನಾನು ನನ್ನ ತಮ್ಮನನ್ನು ಕಾಯುವವನೋ?” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ಅದಕ್ಕೆ ಯೆಹೋವ ದೇವರು, “ನೀನು ಏನು ಮಾಡಿದೆ? ನಿನ್ನ ತಮ್ಮನ ರಕ್ತವು ಭೂಮಿಯಿಂದ ನನ್ನನ್ನು ಕೂಗುತ್ತಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ನೀನು ಈಗ ಶಾಪಗ್ರಸ್ತನಾಗಿದ್ದಿ. ನೀನು ಸುರಿಸಿದ ನಿನ್ನ ತಮ್ಮನ ರಕ್ತವನ್ನು ಸ್ವೀಕರಿಸಲು ಬಾಯಿತೆರೆದಿರುವ ಭೂಮಿಯಿಂದ ತಿರಸ್ಕಾರವಾಗಿದ್ದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ನೀನು ಭೂಮಿಯನ್ನು ವ್ಯವಸಾಯ ಮಾಡಿದರೂ ಅದು ಇನ್ನು ಮುಂದೆ ಫಲಿಸುವುದಿಲ್ಲ. ನೀನು ಭೂಲೋಕದಲ್ಲಿ ಅಲೆಮಾರಿಯಾಗಿ ತಿರುಗುವವನು ಆಗಿರುವೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ಆಗ ಕಾಯಿನನು ಯೆಹೋವ ದೇವರಿಗೆ, “ನನ್ನ ಶಿಕ್ಷೆಯು ತಾಳಲಾರದಷ್ಟು ದೊಡ್ಡದಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ಇಗೋ, ನೀವು ಈ ದಿನ ನನ್ನನ್ನು ಸ್ವದೇಶದಿಂದ ಓಡಿಸುತ್ತಿದ್ದೀರಲ್ಲಾ! ನಿಮ್ಮ ಸಮ್ಮುಖದಿಂದ ನಾನು ಮರೆಯಾಗಿರಬೇಕಾಯಿತು. ಭೂಮಿಯಲ್ಲಿ ಅಲೆಮಾರಿಯಾಗಿರಬೇಕು. ಇದಲ್ಲದೆ ನನ್ನನ್ನು ಕಂಡವರು ಕೊಲ್ಲುವರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ಆದ್ದರಿಂದ ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ, “ಹಾಗಲ್ಲ, ಕಾಯಿನನನ್ನು ಕೊಲ್ಲುವವನ ಮೇಲೆ ಏಳರಷ್ಟು ಪ್ರತೀಕಾರವಿರುವುದು,” ಎಂದು ಹೇಳಿದರು. ಕಾಯಿನನನ್ನು ಕಂಡವರು ಕೊಲ್ಲದ ಹಾಗೆ ಯೆಹೋವ ದೇವರು ಅವನ ಮೇಲೆ ಒಂದು ಗುರುತನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ಆಗ ಕಾಯಿನನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಟುಹೋಗಿ, ಏದೆನ್ ಸೀಮೆಗೆ ಪೂರ್ವದಲ್ಲಿದ್ದ ನೋದು ಎಂಬ ದೇಶದಲ್ಲಿ ವಾಸಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ಕಾಯಿನನು ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಕೂಡಲು, ಅವಳು ಗರ್ಭಿಣಿಯಾಗಿ ಹನೋಕನನ್ನು ಪಡೆದಳು. ಇದಲ್ಲದೆ ಕಾಯಿನನು ಒಂದು ಊರನ್ನು ಕಟ್ಟಿ, ಅದಕ್ಕೆ ಹನೋಕ್ ಎಂದು ತನ್ನ ಮಗನ ಹೆಸರನ್ನಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ಹನೋಕನಿಂದ ಈರಾದನು ಹುಟ್ಟಿದನು. ಈರಾದನಿಂದ ಮೆಹೂಯಾಯೇಲನು ಹುಟ್ಟಿದನು. ಮೆಹೂಯಾಯೇಲನಿಂದ ಮೆತೂಷಾಯೇಲನು ಹುಟ್ಟಿದನು. ಮೆತೂಷಾಯೇಲನಿಂದ ಲೆಮೆಕನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ಲೆಮೆಕನು ಇಬ್ಬರು ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆಯಾದನು. ಒಬ್ಬಳ ಹೆಸರು ಆದಾ ಮತ್ತೊಬ್ಬಳ ಹೆಸರು ಚಿಲ್ಲಾ. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ಆದಾಳು ಯಾಬಾಲನನ್ನು ಹೆತ್ತಳು. ಪಶುಗಳನ್ನು ಸಾಕುತ್ತಾ, ಗುಡಾರಗಳಲ್ಲಿ ವಾಸಿಸುವವರೆಲ್ಲರ ಮೂಲಪುರುಷನು ಇವನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ಇವನ ತಮ್ಮನ ಹೆಸರು ಯೂಬಾಲನು. ಇವನು ಕಿನ್ನರಿ ಕೊಳಲುಗಳನ್ನು ನುಡಿಸುವವರ ಮೂಲಪುರುಷನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ಚಿಲ್ಲಾ ತೂಬಲ್ ಕಾಯಿನನನ್ನು ಪಡೆದಳು. ಅವನು ಕಂಚು ಮತ್ತು ಕಬ್ಬಿಣದ ಆಯುಧಗಳನ್ನು ಮಾಡುವವನಾಗಿದ್ದನು. ತೂಬಲ್ ಕಾಯಿನನ ತಂಗಿಯ ಹೆಸರು ನಯಮಾ. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ಲೆಮೆಕನು ತನ್ನ ಹೆಂಡತಿಯರಿಗೆ ಹೀಗೆಂದನು: “ಆದಾ, ಚಿಲ್ಲಾ, ನನ್ನ ಮಾತನ್ನು ಕೇಳಿರಿ. ಲೆಮೆಕನ ಹೆಂಡತಿಯರೇ, ನಾನು ಹೇಳುವುದನ್ನು ಗಮನಿಸಿರಿ. ನನಗೆ ಗಾಯಮಾಡಿದ ಒಬ್ಬ ಮನುಷ್ಯನನ್ನು ಕೊಂದೆನು. ನನ್ನನ್ನು ಹೊಡೆದ ಯುವಕನನ್ನು ಹತ ಮಾಡಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ಕಾಯಿನನನ್ನು ಕೊಂದವನಿಗೆ ಏಳರಷ್ಟು ಪ್ರತೀಕಾರವಾದರೆ, ಲೆಮೆಕನನ್ನು ಹೊಡೆಯುವವನಿಗೆ, ಎಪ್ಪತ್ತೇಳರಷ್ಟಾಗುವುದು.” ");
INSERT INTO kanokcv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ಆದಾಮನು ತಿರುಗಿ ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಕೂಡಲು, ಆಕೆ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತು, “ಕಾಯಿನನು ಕೊಂದುಹಾಕಿದ ಹೇಬೆಲನಿಗೆ ಬದಲಾಗಿ, ದೇವರು ನನಗೆ ಬೇರೆ ಸಂತಾನವನ್ನು ನೇಮಿಸಿದನು,” ಎಂದು ಆ ಮಗುವಿಗೆ, ಸೇತ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ಸೇತನಿಗೆ ಒಬ್ಬ ಮಗನು ಹುಟ್ಟಿದನು. ಅವನಿಗೆ ಎನೋಷ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಆ ಕಾಲದಲ್ಲಿ ಜನರು, ಯೆಹೋವ ಎಂಬ ಹೆಸರನ್ನು ಆರಾಧಿಸುವುದಕ್ಕೆ ಪ್ರಾರಂಭಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ಆದಾಮನ ವಂಶದವರ ದಾಖಲೆಯಿದು: ದೇವರು ಮನುಷ್ಯನನ್ನು ಸೃಷ್ಟಿಸಿದ ದಿನದಲ್ಲಿ ಅವನನ್ನು ತಮ್ಮನ್ನೇ ಹೋಲುವಂತೆ ಉಂಟುಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ದೇವರು ಅವರನ್ನು ಗಂಡು ಹೆಣ್ಣಾಗಿ ಸೃಷ್ಟಿ ಮಾಡಿದರು. ಅದೇ ದಿನದಲ್ಲಿ ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ, ಅವರಿಗೆ “ಮನುಷ್ಯ” ಎಂದು ಕರೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ಆದಾಮನು ನೂರಮೂವತ್ತು ವರುಷದವನಾದಾಗ ರೂಪದಲ್ಲಿ ತನ್ನ ಹೋಲಿಕೆಗೆ ಸರಿಯಾದ ಮಗನನ್ನು ಪಡೆದು ಅವನಿಗೆ, “ಸೇತ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ಸೇತನು ಹುಟ್ಟಿದ ಮೇಲೆ ಆದಾಮನು ಗಂಡು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು, ಎಂಟುನೂರು ವರುಷ ಬದುಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ಆದಾಮನು ಒಟ್ಟು ಒಂಬೈನೂರ ಮೂವತ್ತು ವರುಷ ಬದುಕಿ ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ಸೇತನು ನೂರ ಐದು ವರುಷದವನಾದಾಗ ಎನೋಷನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ಎನೋಷನು ಹುಟ್ಟಿದ ಮೇಲೆ ಸೇತನು ಎಂಟುನೂರ ಏಳು ವರುಷ ಬದುಕಿದನು. ಅವನಿಗೆ ಬೇರೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳು ಇದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ಸೇತನು ಒಟ್ಟು ಒಂಬೈನೂರ ಹನ್ನೆರಡು ವರ್ಷ ಬದುಕಿ ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ಎನೋಷನು ತೊಂಬತ್ತು ವರ್ಷದವನಾದಾಗ ಕೇನಾನನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ಕೇನಾನನು ಹುಟ್ಟಿದ ಮೇಲೆ ಎನೋಷನು ಗಂಡು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಎಂಟುನೂರ ಹದಿನೈದು ವರುಷ ಬದುಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ಅವನು ಒಟ್ಟು ಒಂಬೈನೂರ ಐದು ವರುಷ ಬದುಕಿ ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ಕೇನಾನನು ಎಪ್ಪತ್ತು ವರುಷದವನಾದಾಗ, ಅವನಿಂದ ಮಹಲಲೇಲನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ಕೇನಾನನು ಮಹಲಲೇಲನು ಹುಟ್ಟಿದ ಮೇಲೆ ಎಂಟುನೂರ ನಲವತ್ತು ವರ್ಷ ಬದುಕಿ, ಗಂಡು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ಕೇನಾನನು ಒಟ್ಟು ಒಂಬೈನೂರ ಹತ್ತು ವರ್ಷ ಬದುಕಿ ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ಮಹಲಲೇಲನು ಅರವತ್ತೈದು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ಯೆರೆದನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ಯೆರೆದನು ಹುಟ್ಟಿದ ಮೇಲೆ ಮಹಲಲೇಲನು ಎಂಟುನೂರ ಮೂವತ್ತು ವರ್ಷ ಬದುಕಿ ಗಂಡು, ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ಮಹಲಲೇಲನು ಎಂಟುನೂರ ತೊಂಬತ್ತೈದು ವರ್ಷ ಬದುಕಿ ತರುವಾಯ ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ಯೆರೆದನು ನೂರ ಅರವತ್ತೆರಡು ವರುಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ಹನೋಕನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ಹನೋಕನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಯೆರೆದನು ಎಂಟುನೂರು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಗಂಡು, ಹೆಣ್ಣುಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ಯೆರೆದನು ಒಟ್ಟು ಒಂಬೈನೂರ ಅರವತ್ತೆರಡು ವರ್ಷ ಬದುಕಿ, ತರುವಾಯ ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ಹನೋಕನು ಅರವತ್ತೈದು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ಮೆತೂಷೆಲಹನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ಮೆತೂಷೆಲಹನು ಹುಟ್ಟಿದ ತರುವಾಯ, ಹನೋಕನು ಮುನ್ನೂರು ವರ್ಷ ದೇವರೊಂದಿಗೆ ನಡೆದನು. ಅವನಿಂದ ಗಂಡು, ಹೆಣ್ಣುಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ಹನೋಕನು ಒಟ್ಟು ಮುನ್ನೂರ ಅರವತ್ತೈದು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ದೇವರೊಂದಿಗೆ ನಂಬಿಗಸ್ತನಾಗಿ ನಡೆಯುತ್ತಿದ್ದ ಹನೋಕನನ್ನು ದೇವರು ತೆಗೆದುಕೊಂಡು ಹೋದದ್ದರಿಂದ ಅವನು ಕಾಣಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ಮೆತೂಷೆಲಹನು ನೂರ ಎಂಬತ್ತೇಳು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ಲೆಮೆಕನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ಲೆಮೆಕನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಮೆತೂಷೆಲಹನು ಏಳುನೂರ ಎಂಬತ್ತೆರಡು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಗಂಡು, ಹೆಣ್ಣುಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ಮೆತೂಷೆಲಹನಿಗೆ ಒಟ್ಟು ಒಂಬೈನೂರ ಅರವತ್ತೊಂಭತ್ತು ವರ್ಷಗಳಾಗಿದ್ದವು. ತರುವಾಯ ಅವನು ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ಲೆಮೆಕನು ನೂರ ಎಂಬತ್ತೆರಡು ವರ್ಷದವನಾದಾಗ, ಒಬ್ಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ಅವನಿಗೆ, ನೋಹ ಎಂದು ಹೆಸರಿಟ್ಟು, “ಯೆಹೋವ ದೇವರು ಶಪಿಸಿದ ಭೂಮಿಯಿಂದ ನಮಗೆ ಉಂಟಾದ ಕಷ್ಟದಲ್ಲಿಯೂ ಪ್ರಯಾಸದಲ್ಲಿಯೂ ಇವನೇ ನಮ್ಮನ್ನು ಉಪಶಮನಗೊಳಿಸುವನು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ನೋಹನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಲೆಮೆಕನು ಗಂಡು, ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು, ಐನೂರ ತೊಂಬತ್ತೈದು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ಲೆಮೆಕನು ಒಟ್ಟು ಏಳುನೂರ ಎಪ್ಪತ್ತೇಳು ವರ್ಷ ಬದುಕಿದನು. ತರುವಾಯ ಅವನು ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ನೋಹನು ಐನೂರು ವರ್ಷದವನಾಗಿದ್ದನು. ಆಗ ನೋಹನಿಂದ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತರು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ಭೂಮಿಯ ಮೇಲೆ ಜನರ ಸಂಖ್ಯೆ ಹೆಚ್ಚಾಗತೊಡಗಿದಾಗ ಅವರಿಗೆ ಪುತ್ರಿಯರು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ಆಗ ದೇವಪುತ್ರರು, ಮನುಷ್ಯ ಪುತ್ರಿಯರ ಸೌಂದರ್ಯವನ್ನು ಕಂಡು ಅವರನ್ನು ಆರಿಸಿಕೊಂಡು, ತಮಗೆ ಹೆಂಡತಿಯರನ್ನಾಗಿ ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ಆಗ ಯೆಹೋವ ದೇವರು, “ನನ್ನ ಆತ್ಮವು ಮನುಷ್ಯರಲ್ಲಿ ನಿತ್ಯವಾಗಿ ಇರುವುದಿಲ್ಲ. ಏಕೆಂದರೆ ಅವರು ಮರ್ತ್ಯರೇ. ಆದರೂ ಅವರ ಆಯುಷ್ಯವು ನೂರ ಇಪ್ಪತ್ತು ವರ್ಷಗಳಾಗಿರುವುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ಆ ದಿನಗಳಲ್ಲಿ ಭೂಮಿಯ ಮೇಲೆ ನೆಫೀಲಿಯೆಂಬ ರಾಕ್ಷಸ ವಂಶದವರು ಇದ್ದರು. ನಂತರದಲ್ಲಿಯೂ ಇದ್ದರು. ದೇವಪುತ್ರರು ಮನುಷ್ಯ ಪುತ್ರಿಯರೊಂದಿಗೆ ಕೂಡಿದಾಗ, ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ಇವರೇ ಪೂರ್ವಕಾಲದಲ್ಲಿ ಪ್ರಸಿದ್ಧರಾಗಿದ್ದ ಪರಾಕ್ರಮಿಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ಮನುಷ್ಯನ ದುಷ್ಟತನವು ಭೂಮಿಯಲ್ಲಿ ಹೆಚ್ಚಿದ್ದನ್ನೂ ಅವನ ಹೃದಯದ ಆಲೋಚನೆಗಳೆಲ್ಲವೂ ಯಾವಾಗಲೂ ಬರೀ ಕೆಟ್ಟದ್ದೆಂದೂ ಯೆಹೋವ ದೇವರು ಕಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ಯೆಹೋವ ದೇವರು ಭೂಮಿಯ ಮೇಲೆ ಮನುಷ್ಯರನ್ನು ಉಂಟುಮಾಡಿದ್ದಕ್ಕೆ ನಿಟ್ಟುಸಿರುಬಿಟ್ಟು, ತಮ್ಮ ಹೃದಯದಲ್ಲಿ ನೊಂದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು, “ನಾನು ಸೃಷ್ಟಿಸಿದ ಮನುಷ್ಯನಿಂದ ಹಿಡಿದು, ಸಕಲ ಪ್ರಾಣಿ, ಆಕಾಶದ ಪಕ್ಷಿಗಳನ್ನೂ ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಜೀವಿಗಳನ್ನು, ಭೂಮಿಯ ಮೇಲಿನಿಂದ ಎಲ್ಲವನ್ನು ನಾಶಮಾಡುವೆನು. ನಾನು ಅವರನ್ನು ಉಂಟುಮಾಡಿದ್ದಕ್ಕೆ ದುಃಖಪಡುತ್ತೇನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ಆದರೆ ನೋಹನಿಗೆ ಯೆಹೋವ ದೇವರ ದಯೆ ದೊರಕಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ಇದು ನೋಹನ ಮತ್ತು ಅವನ ವಂಶದವರ ಚರಿತ್ರೆ: ನೋಹನು ನೀತಿವಂತನೂ ತನ್ನ ಕಾಲದವರಲ್ಲಿ ನಿರ್ದೋಷಿಯೂ ಆಗಿದ್ದನು. ಅವನು ದೇವರೊಂದಿಗೆ ವಿಶ್ವಾಸದಿಂದ ನಡೆಯುತ್ತಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ನೋಹನಿಗೆ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್ ಎಂಬ ಮೂರು ಮಂದಿ ಮಕ್ಕಳಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ಭೂಲೋಕದವರು ದೇವರ ದೃಷ್ಟಿಯಲ್ಲಿ ಕೆಟ್ಟು ಹೋಗಿದ್ದರು. ಹಿಂಸಾಚಾರವು ಲೋಕವನ್ನು ತುಂಬಿಕೊಂಡಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ದೇವರು ಭೂಮಿಯನ್ನು ನೋಡಲಾಗಿ ಅದು ಕೆಟ್ಟುಹೋಗಿತ್ತು, ಮನುಷ್ಯರೆಲ್ಲರೂ ಭೂಮಿಯ ಮೇಲೆ ತಮ್ಮ ನಡವಳಿಕೆಯನ್ನು ಕೆಡಿಸಿಕೊಂಡಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ಆಗ ದೇವರು ನೋಹನಿಗೆ, “ನಾನು ಮನುಷ್ಯರೆಲ್ಲರಿಗೂ ಅಂತ್ಯವನ್ನು ತೀರ್ಮಾನಿಸಿದ್ದೇನೆ. ಅವರಿಂದ ಭೂಮಿಯು ಹಿಂಸಾಚಾರದಿಂದ ತುಂಬಿದೆ. ನಾನು ಭೂಮಿಯೊಂದಿಗೆ ಅವರನ್ನೂ ನಾಶಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ಆದ್ದರಿಂದ ನಿನಗೋಸ್ಕರವಾಗಿ ತುರಾಯಿ ಮರದಿಂದ ನಾವೆಯನ್ನು ಮಾಡಿಕೋ; ಅದರಲ್ಲಿ ಕೋಣೆಗಳನ್ನು ಮಾಡು, ಅದರ ಒಳಭಾಗಕ್ಕೂ ಹೊರಭಾಗಕ್ಕೂ ರಾಳವನ್ನು ಹಚ್ಚು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ನೀನು ಅದನ್ನು ಈ ರೀತಿಯಾಗಿ ಮಾಡತಕ್ಕದ್ದು: ನಾವೆಯ ಉದ್ದವು ಸುಮಾರು ಒಂದುನೂರ ಮೂವತ್ತೈದು ಮೀಟರ್, ಅದರ ಅಗಲ ಇಪ್ಪತ್ತಮೂರು ಮೀಟರ್, ಅದರ ಎತ್ತರ ಹದಿನಾಲ್ಕು ಮೀಟರ್ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ಅದಕ್ಕೆ ಚಾವಣಿಯನ್ನು ಮಾಡು, ಅದರ ಕೆಳಗೆ ಹದಿನೆಂಟು ಇಂಚಿನ ಕಿಟಕಿಯನ್ನು ನಾವೆಯ ಸುತ್ತಲೂ ಮಾಡಬೇಕು; ಅದರ ಪಕ್ಕದಲ್ಲಿ ನಾವೆಯ ಬಾಗಿಲನ್ನು ಇಡಬೇಕು. ಕೆಳಗಿನದು, ಎರಡನೆಯದು, ಮೂರನೆಯದು ಎಂಬ ಮೂರು ಅಂತಸ್ತುಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ನಾನು ಆಕಾಶದ ಕೆಳಗಿರುವ ಜೀವಶ್ವಾಸವುಳ್ಳ ಸಕಲ ಪ್ರಾಣಿಗಳನ್ನು ನಾಶಮಾಡುವುದಕ್ಕೆ ಜಲಪ್ರಳಯವನ್ನು ಭೂಮಿಯ ಮೇಲೆ ಬರಮಾಡುತ್ತೇನೆ. ಆಗ ಭೂಮಿಯಲ್ಲಿರುವುದೆಲ್ಲವೂ ನಾಶವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ಆದರೆ ನಾನು ನಿನ್ನ ಸಂಗಡ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಾಪಿಸುವೆನು. ನೀನು, ನಿನ್ನ ಸಂಗಡ ನಿನ್ನ ಮಕ್ಕಳು, ನಿನ್ನ ಹೆಂಡತಿ ಹಾಗೂ ಸೊಸೆಯರು ನಾವೆಯೊಳಗೆ ಸೇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ಜೀವಿಗಳ ಪ್ರತಿಜಾತಿಯಲ್ಲೂ ಒಂದು ಗಂಡು, ಒಂದು ಹೆಣ್ಣು; ಹೀಗೆ ಎರಡೆರಡನ್ನು ನಾವೆಯಲ್ಲಿ ಸೇರಿಸಿ ನಿನ್ನೊಂದಿಗೆ ಜೀವಂತವಾಗಿ ಉಳಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ಪಕ್ಷಿಗಳಲ್ಲಿ ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ, ಪ್ರಾಣಿಗಳಲ್ಲಿ ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ ಮತ್ತು ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಸಕಲ ಜೀವಿಗಳಲ್ಲಿ ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ ಎರಡೆರಡು ಬದುಕಿಬಾಳಲು ಅವುಗಳನ್ನು ನೀನು ಕಾಪಾಡುವಂತೆ ನಿನ್ನ ಬಳಿಗೆ ಬರುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ನೀನು, ಎಲ್ಲ ವಿಧವಾದ ಆಹಾರ ಪದಾರ್ಥಗಳನ್ನು ಕೂಡಿಸಿಡಬೇಕು. ಅದು ನಿಮಗೂ ಮತ್ತು ಪ್ರಾಣಿಗಳಿಗೂ ಆಹಾರವಾಗಿರಬೇಕು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ನೋಹನು ಎಲ್ಲವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ಯೆಹೋವ ದೇವರು ನೋಹನಿಗೆ, “ನೀನೂ, ನಿನ್ನ ಮನೆಯವರೆಲ್ಲರೂ ನಾವೆಯೊಳಗೆ ಸೇರಿಕೊಳ್ಳಿರಿ. ಏಕೆಂದರೆ ಈ ಕಾಲದವರಲ್ಲಿ ನೀನೊಬ್ಬನೇ ನನ್ನ ಮುಂದೆ ನೀತಿವಂತನಾಗಿರುವುದನ್ನು ನಾನು ನೋಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ಎಲ್ಲಾ ಶುದ್ಧ ಪಶುಗಳಲ್ಲಿ ಏಳೇಳು ಗಂಡು, ಹೆಣ್ಣುಗಳನ್ನೂ, ಶುದ್ಧವಲ್ಲದ ಪಶುಗಳಲ್ಲಿ ಎರಡೆರಡು ಗಂಡು, ಹೆಣ್ಣುಗಳನ್ನೂ ನಿನ್ನೊಂದಿಗೆ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ಆಕಾಶದ ಪಕ್ಷಿಗಳಲ್ಲಿ ಗಂಡು, ಹೆಣ್ಣು ಏಳೇಳರಂತೆ ತೆಗೆದುಕೊಂಡು, ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಅವುಗಳ ಸಂತತಿಯನ್ನು ಜೀವಂತವಾಗಿ ಉಳಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ಏಳು ದಿವಸಗಳಾದ ಮೇಲೆ ಭೂಮಿಯ ಮೇಲೆ ನಲವತ್ತು ದಿನ ಹಗಲಿರುಳು ಮಳೆಯು ಬರುವಂತೆ ನಾನು ಮಾಡುವೆನು. ನಾನು ಉಂಟುಮಾಡಿದ ಪ್ರತಿಯೊಂದು ಜೀವರಾಶಿಯನ್ನೂ ಭೂಮಿಯ ಮೇಲಿಂದ ಅಳಿಸಿಬಿಡುತ್ತೇನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ಯೆಹೋವ ದೇವರು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ನೋಹನು ಎಲ್ಲವನ್ನೂ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ಜಲಪ್ರಳಯವು ಭೂಮಿಯ ಮೇಲೆ ಉಂಟಾದಾಗ ನೋಹನು ಆರುನೂರು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ಆಗ ನೋಹನು ಪ್ರಳಯದ ನಿಮಿತ್ತವಾಗಿ ಹೆಂಡತಿ, ಮಕ್ಕಳು, ಸೊಸೆಯರ ಸಹಿತವಾಗಿ ನಾವೆಯಲ್ಲಿ ಸೇರಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ಶುದ್ಧ ಪ್ರಾಣಿಗಳಲ್ಲಿಯೂ, ಅಶುದ್ಧ ಪ್ರಾಣಿಗಳಲ್ಲಿ, ಪಕ್ಷಿಗಳಲ್ಲಿ ಮತ್ತು ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಜೀವಿಗಳೆಲ್ಲವೂ ");
INSERT INTO kanokcv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ದೇವರು ನೋಹನಿಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಗಂಡುಹೆಣ್ಣುಗಳು ಜೋಡಿ ಜೋಡಿಯಾಗಿ ಬಂದು ನೋಹನೊಂದಿಗೆ ನಾವೆಯಲ್ಲಿ ಸೇರಿಕೊಂಡವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ಏಳು ದಿವಸಗಳಾದ ನಂತರ ಜಲಪ್ರಳಯವು ಭೂಮಿಯ ಮೇಲೆ ಬಂತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ನೋಹನ ಜೀವನದ ಆರುನೂರು ವರ್ಷದ ಎರಡನೆಯ ತಿಂಗಳಿನ ಹದಿನೇಳನೆಯ ದಿವಸದಲ್ಲಿಯೇ ಮಹಾಸಾಗರದ ಸೆಲೆಗಳು ಒಡೆದವು. ಆಕಾಶದ ಪ್ರವಾಹದ ದ್ವಾರಗಳು ತೆರೆದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ನಲವತ್ತು ದಿವಸ ಹಗಲಿರುಳು ಭೂಮಿಯ ಮೇಲೆ ದೊಡ್ಡ ಮಳೆ ಸುರಿಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ಅದೇ ದಿನದಲ್ಲಿ ನೋಹನು ಮತ್ತು ಅವನ ಪುತ್ರರಾದ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್ ಇವರೂ ನೋಹನ ಹೆಂಡತಿಯೂ ಅವನ ಪುತ್ರರ ಹೆಂಡತಿಯರೂ ನಾವೆಯನ್ನು ಪ್ರವೇಶಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ಇದಲ್ಲದೆ ತಮ್ಮ ತಮ್ಮ ಜಾತಿಗನುಸಾರವಾಗಿ ಎಲ್ಲಾ ಕಾಡು ಮೃಗಗಳೂ ಎಲ್ಲಾ ಪಶುಗಳೂ ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಎಲ್ಲಾ ಜೀವಿಗಳೂ ಎಲ್ಲಾ ಪಕ್ಷಿಗಳೂ ಎಲ್ಲಾ ವಿಧವಾದ ರೆಕ್ಕೆಯಿರುವ ಜೀವಿಗಳೂ ಪ್ರವೇಶಿಸಿದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ಹೀಗೆ ಜೀವಶ್ವಾಸವಿರುವ ಎಲ್ಲಾ ಸೃಷ್ಟಿಗಳಲ್ಲಿ ಎರಡೆರಡು ನೋಹನ ಬಳಿಗೆ ನಾವೆಯೊಳಗೆ ಹೋದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ದೇವರು ನೋಹನಿಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಎಲ್ಲಾ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಒಂದು ಗಂಡು, ಒಂದು ಹೆಣ್ಣು ಈ ಮೇರೆಗೆ ಸೇರಿದವು. ಯೆಹೋವ ದೇವರು ನೋಹನನ್ನು ಒಳಗೆ ಬಿಟ್ಟು ಬಾಗಿಲನ್ನು ಮುಚ್ಚಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ನಲವತ್ತು ದಿನ ಭೂಮಿಯ ಮೇಲೆ ಪ್ರಳಯವು ಬಂದು, ನೀರು ಹೆಚ್ಚಿ ನಾವೆಯನ್ನು ಮೇಲಕ್ಕೆ ಎತ್ತಲು ಅದು ಭೂಮಿಯಿಂದ ತೇಲಾಡಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ನೀರು ಪ್ರಬಲವಾಗಿ ಭೂಮಿಯ ಮೇಲೆ ಹೆಚ್ಚಿದಾಗ ನಾವೆಯು ನೀರಿನ ಮೇಲೆ ಚಲಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ಭೂಮಿಯ ಮೇಲೆ ನೀರು ಅಧಿಕವಾಗಿ ಪ್ರಬಲವಾದದ್ದರಿಂದ ಆಕಾಶಮಂಡಲದ ಕೆಳಗಿರುವ ಎಲ್ಲಾ ದೊಡ್ಡ ಬೆಟ್ಟಗಳೂ ಮುಚ್ಚಿಕೊಂಡವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ನೀರು ಬೆಟ್ಟವನ್ನು ಮುಚ್ಚಿ ಅವುಗಳ ಮೇಲೆ ಸುಮಾರು ಏಳು ಮೀಟರಷ್ಟು ಏರಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ಪಕ್ಷಿಗಳು, ಪಶುಗಳು, ಕಾಡುಮೃಗಗಳು, ನೆಲದ ಮೇಲೆ ಚಲಿಸುವ ಸಕಲ ಪ್ರಾಣಿಗಳು ಮತ್ತು ಮನುಷ್ಯರು ನಾಶವಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ಒಣನೆಲದ ಮೇಲಿದ್ದ ಮೂಗಿನಿಂದ ಶ್ವಾಸಬೀಡುವ ಜೀವಿಗಳೆಲ್ಲವೂ ಸತ್ತು ಹೋದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ಹೀಗೆ ಮನುಷ್ಯರು, ಪಶುಪಕ್ಷಿ, ಕ್ರಿಮಿಕೀಟಗಳು, ಭೂಮಿಯ ಮೇಲಿದ್ದ ಎಲ್ಲಾ ಜೀವರಾಶಿಗಳೂ ನಾಶವಾಯಿತು. ಅವು ಭೂಮಿಯ ಮೇಲಿಂದ ಅಳಿದುಹೋದವು. ನೋಹನು ಮತ್ತು ಅವನ ಸಂಗಡ ನಾವೆಯಲ್ಲಿದ್ದವರು ಮಾತ್ರ ಜೀವಂತವಾಗಿ ಉಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ಜಲವು ಭೂಮಿಯ ಮೇಲೆ ನೂರೈವತ್ತು ದಿನ ಮುಂದುವರೆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ದೇವರು ನೋಹನನ್ನೂ ಅವನ ಸಂಗಡ ನಾವೆಯಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಕಾಡುಮೃಗಗಳನ್ನೂ ಪಶುಗಳನ್ನೂ ನೆನಪಿಗೆ ತಂದುಕೊಂಡು, ಭೂಲೋಕದ ಮೇಲೆ ಗಾಳಿಬೀಸುವಂತೆ ಮಾಡಲಾಗಿ, ನೀರು ತಗ್ಗಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ಮಾತ್ರವಲ್ಲದೆ ಸಾಗರದ ಸೆಲೆಗಳೂ, ಆಕಾಶದ ದ್ವಾರಗಳೂ ಮುಚ್ಚಿಹೋದವು. ಆಕಾಶದಿಂದ ಬೀಳುವ ಮಳೆ ನಿಂತುಹೋಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ಹೀಗೆ ನೀರು ಭೂಮಿಯ ಮೇಲಿನಿಂದ ಕ್ರಮವಾಗಿ ಇಳಿಯಿತು. ನೀರು ನೂರೈವತ್ತು ದಿನಗಳ ಅಂತ್ಯದಲ್ಲಿ ಕಡಿಮೆಯಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೇಳನೆಯ ದಿನದಲ್ಲಿ ನಾವೆಯು ಅರಾರಾಟ್ ಬೆಟ್ಟಗಳ ಮೇಲೆ ನಿಂತಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ಹತ್ತನೆಯ ತಿಂಗಳಿನವರೆಗೂ ನೀರು ಕಡಿಮೆಯಾಗುತ್ತಾ ಬಂತು, ಹತ್ತನೆಯ ತಿಂಗಳಿನ ಮೊದಲಿನ ದಿನದಲ್ಲಿ ಬೆಟ್ಟಗಳ ಶಿಖರಗಳು ಕಾಣಿಸಲಾರಂಭಿಸಿದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ನಲವತ್ತು ದಿನಗಳಾದ ಮೇಲೆ, ನೋಹನು ತಾನು ಮಾಡಿದ ನಾವೆಯ ಕಿಟಕಿಯನ್ನು ತೆರೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ಅವನು ಒಂದು ಕಾಗೆಯನ್ನು ಹೊರಕ್ಕೆ ಬಿಟ್ಟನು, ಅದು ಭೂಮಿಯ ಮೇಲಿದ್ದ ನೀರು ಒಣಗುವ ತನಕ ಹೋಗುತ್ತಾ ಬರುತ್ತಾ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ಭೂಮುಖದ ಮೇಲೆ ಜಲವು ಕಡಿಮೆಯಾಯಿತೋ ಇಲ್ಲವೋ ಎಂದು ನೋಡುವಂತೆ, ಒಂದು ಪಾರಿವಾಳವನ್ನೂ ಹೊರಕ್ಕೆ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ಆದರೆ ನೀರು ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಇರುವುದರಿಂದ ಪಾರಿವಾಳವು ಕಾಲಿಡುವುದಕ್ಕೂ ಸ್ಥಳವನ್ನು ಕಾಣದೆ, ಅವನ ಬಳಿಗೆ ನಾವೆಗೆ ಹಿಂದಿರುಗಿತು. ಅವನು ಕೈಚಾಚಿ ಅದನ್ನು ಹಿಡಿದು, ನಾವೆಯಲ್ಲಿ ತನ್ನ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ಅವನು ಇನ್ನೂ ಏಳು ದಿವಸ ತಡೆದು, ಪಾರಿವಾಳವನ್ನು ಪುನಃ ನಾವೆಯೊಳಗಿಂದ ಹೊರಕ್ಕೆ ಬಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ಸಂಜೆಯಲ್ಲಿ ಆ ಪಾರಿವಾಳವು ಅವನ ಬಳಿಗೆ ತಿರುಗಿ ಬರಲು, ಅದರ ಬಾಯಿಯಲ್ಲಿ ಓಲಿವ್ ಮರದ ಹೊಸ ಚಿಗುರು ಇತ್ತು. ನೋಹನು ಅದನ್ನು ನೋಡಿ ನೀರು ಭೂಮಿಯ ಮೇಲಿಂದ ಇಳಿದಿದೆಯೆಂದು ತಿಳಿದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ಇನ್ನೂ ಏಳು ದಿನಗಳು ತಡೆದು, ಆ ಪಾರಿವಾಳವನ್ನು ಬಿಟ್ಟಾಗ, ಅದು ತಿರುಗಿ ಅವನ ಬಳಿಗೆ ಬರಲೇ ಇಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ಆರುನೂರ ಒಂದನೆಯ ವರ್ಷದ, ಮೊದಲನೆಯ ತಿಂಗಳಿನ, ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಭೂಮಿಯ ಮೇಲಿದ್ದ ನೀರು ಇಳಿದಿತ್ತು. ನೋಹನು ನಾವೆಯ ಮೇಲಿನ ಮುಚ್ಚಳವನ್ನು ತೆಗೆದು ನೋಡಲಾಗಿ, ನೆಲವು ಒಣಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ಎರಡನೆಯ ತಿಂಗಳಿನ ಇಪ್ಪತ್ತೇಳನೆಯ ದಿನದಲ್ಲಿ ಭೂಮಿಯು ಒಣಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ಆಗ ದೇವರು ನೋಹನಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ನೀನು, ನಿನ್ನ ಹೆಂಡತಿ, ಮಕ್ಕಳು, ಸೊಸೆಯರ ಸಹಿತವಾಗಿ ನಾವೆಯನ್ನು ಬಿಟ್ಟು ಹೊರಗೆ ಬಾ. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ನಿನ್ನ ಬಳಿಯಲ್ಲಿರುವ ಪಕ್ಷಿ, ಪಶು, ಕ್ರಿಮಿ, ಮುಂತಾದ ಎಲ್ಲಾ ಜೀವಿಗಳನ್ನು ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಬಾ. ಅವುಗಳಿಗೆ ಭೂಮಿಯ ಮೇಲೆ ಬಹು ಸಂತಾನವಾಗಲಿ, ಅವು ಅಭಿವೃದ್ಧಿಯಾಗಿ ಹೆಚ್ಚಲಿ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ಹೀಗೆ ನೋಹನು, ಹೆಂಡತಿ, ಮಕ್ಕಳು, ಸೊಸೆಯರ ಸಹಿತವಾಗಿ ಹೊರಗೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ಎಲ್ಲಾ ಮೃಗಗಳೂ ಎಲ್ಲಾ ಕ್ರಿಮಿಗಳೂ ಎಲ್ಲಾ ಪಕ್ಷಿಗಳೂ ಭೂಮಿಯಲ್ಲಿ ಹರಿದಾಡುವ ಎಲ್ಲವೂ ತಮ್ಮ ತಮ್ಮ ಜಾತಿಗನುಸಾರವಾಗಿ ನಾವೆಯೊಳಗಿಂದ ಹೊರಗೆ ಬಂದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ನೋಹನು ಯೆಹೋವ ದೇವರಿಗೆ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿ, ಶುದ್ಧವಾದ ಪ್ರತಿ ಪಶುಗಳಿಂದಲೂ ಶುದ್ಧವಾದ ಪ್ರತಿ ಪಕ್ಷಿಗಳಿಂದಲೂ ಕೆಲವೊಂದನ್ನು ಆಯ್ದುಕೊಂಡು, ಬಲಿಪೀಠದ ಮೇಲೆ ದಹನಬಲಿಗಳನ್ನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವ ದೇವರಿಗೆ ಗಮಗಮಿಸಲು, ಅವರು ಹೃದಯದೊಳಗೆ, “ಮನುಷ್ಯನ ಹೃದಯದ ಆಲೋಚನೆ ಚಿಕ್ಕಂದಿನಿಂದಲೇ ಕೆಟ್ಟದ್ದು, ಆದರೂ ನಾನು ಇನ್ನು ಮೇಲೆ ಮನುಷ್ಯರ ನಿಮಿತ್ತವಾಗಿ ಭೂಮಿಯನ್ನು ಶಪಿಸುವುದಿಲ್ಲ. ನಾನು ಎಲ್ಲಾ ಜೀವಿಗಳನ್ನೂ ಸಂಹರಿಸಿದಂತೆ ಇನ್ನು ಮೇಲೆ ಸಂಹರಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“ಭೂಮಿಯು ಇರುವವರೆಗೆ ಬಿತ್ತುವ ಕಾಲವೂ ಕೊಯ್ಯುವ ಕಾಲವೂ; ತಂಪೂ ಸೆಕೆಯೂ; ಬೇಸಿಗೆಯೂ ಹಿಮಕಾಲವೂ; ಹಗಲೂ ರಾತ್ರಿಯೂ ನಿಂತುಹೋಗುವುದಿಲ್ಲ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ದೇವರು ನೋಹನನ್ನೂ, ಅವನ ಪುತ್ರರನ್ನೂ ಆಶೀರ್ವದಿಸಿ ಅವರಿಗೆ, “ನೀವು ಬಹು ಸಂತಾನವುಳ್ಳವರಾಗಿ ಹೆಚ್ಚಿ, ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ತುಂಬಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ಭೂಮಿಯ ಎಲ್ಲಾ ಮೃಗಗಳ ಮೇಲೆಯೂ ಆಕಾಶದ ಎಲ್ಲಾ ಪಕ್ಷಿಗಳ ಮೇಲೆಯೂ ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಎಲ್ಲಾ ಕ್ರಿಮಿಕೀಟಗಳ ಮೇಲೆಯೂ ಸಮುದ್ರದ ಎಲ್ಲಾ ಮೀನುಗಳ ಮೇಲೆಯೂ ನಿಮ್ಮ ಭಯ ಬೆದರಿಕೆಯು ಇರುವುದು. ನಿಮ್ಮ ಕೈಗೆ ಅವು ಕೊಡಲಾಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ಚಲಿಸುವ ಜೀವಜಂತುಗಳೆಲ್ಲಾ ನಿಮಗೆ ಆಹಾರವಾಗಿ ಇರಲಿ. ಹಸಿರು ಪಲ್ಯಗಳ ಹಾಗೆಯೇ, ಅವುಗಳನ್ನೆಲ್ಲಾ ನಾನು ನಿಮಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“ಆದರೆ ಮಾಂಸವನ್ನು ಅದರ ಜೀವವಾಗಿರುವ ರಕ್ತದೊಂದಿಗೆ ನೀವು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ನಿಮ್ಮ ರಕ್ತ ಸುರಿಸಿ, ಪ್ರಾಣ ತೆಗೆಯುವವರಿಗೆ, ಮುಯ್ಯಿತೀರಿಸುವೆನು, ಮೃಗವಾಗಿದ್ದರೆ ಅದಕ್ಕೂ ಮುಯ್ಯಿತೀರಿಸುವೆನು. ಮನುಷ್ಯನಾಗಿದ್ದರೆ, ಹತನಾದವನು ಇನ್ನೊಬ್ಬ ಮನುಷ್ಯನಾದುದರಿಂದ ಹತಿಸಿದವನಿಗೂ ಮುಯ್ಯಿತೀರಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“ಯಾರಾದರೂ ಮನುಷ್ಯರ ರಕ್ತವನ್ನು ಸುರಿಸುತ್ತಾರೋ, ಅವರ ರಕ್ತವನ್ನು ಮನುಷ್ಯರೇ ಸುರಿಸುವರು. ಏಕೆಂದರೆ ದೇವರು ತಮ್ಮ ಸ್ವರೂಪದಲ್ಲಿಯೇ ಮನುಷ್ಯರನ್ನು ಸೃಷ್ಟಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ಆದ್ದರಿಂದ ನೀವು ಬಹುಸಂತಾನವಾಗಿ ಹೆಚ್ಚಿರಿ. ಸಂಖ್ಯೆಯಲ್ಲಿಯೂ ಅಧಿಕವಾಗಿ ಭೂಮಿಯಲ್ಲಿ ಹೆಚ್ಚಿರಿ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ಇದಲ್ಲದೆ ದೇವರು ನೋಹನಿಗೂ ಅವನ ಸಂಗಡ ಇದ್ದ ಅವನ ಪುತ್ರರಿಗೂ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ನಾನು ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ನಿಮ್ಮ ಸಂಗಡವೂ ನಿಮ್ಮ ತರುವಾಯ ನಿಮ್ಮ ಸಂತತಿಯವರ ಸಂಗಡವೂ ");
INSERT INTO kanokcv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ನಿಮ್ಮ ಜೊತೆ ನಾವೆಯೊಳಗಿಂದ ಹೊರಗೆ ಬಂದ ಎಲ್ಲಾ ಜೀವಿಗಳ ಸಹಿತ ಅಂದರೆ ಪಕ್ಷಿಗಳು, ಪಶುಗಳು, ಕಾಡುಮೃಗಗಳು ಮತ್ತು ಭೂಮಿಯ ಎಲ್ಲಾ ಜೀವಿಗಳೊಂದಿಗೆ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಾಪಿಸುತ್ತೇನೆ ");
INSERT INTO kanokcv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ಜಲಪ್ರಳಯದಿಂದ ಇನ್ನು ಮೇಲೆ ಎಲ್ಲಾ ಜೀವಿಗಳು ನಾಶವಾಗುವುದಿಲ್ಲ. ಭೂಮಿಯನ್ನು ಹಾಳು ಮಾಡುವುದಕ್ಕೆ ಇನ್ನು ಮುಂದೆ ಇಂಥ ಪ್ರಳಯವು ಇರುವುದಿಲ್ಲ ಎಂದು ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಾಪಿಸುತ್ತೇನೆ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ದೇವರು ಮತ್ತೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನನಗೂ ನಿಮಗೂ ನಿಮ್ಮ ಸಂಗಡ ಇರುವ ಎಲ್ಲಾ ಜೀವಜಂತುಗಳಿಗೂ ಮಧ್ಯದಲ್ಲಿ ತಲತಲಾಂತರಗಳವರೆಗೆ ನಾನು ಮಾಡುವ ಒಡಂಬಡಿಕೆಗೆ ಗುರುತು ಇದೆ: ");
INSERT INTO kanokcv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ನನ್ನ ಮಳೆಬಿಲ್ಲನ್ನು ಮೇಘಗಳಲ್ಲಿ ಇಟ್ಟಿದ್ದೇನೆ, ಅದು ನನಗೂ ಭೂಮಿಗೂ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಗೆ ಗುರುತಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ನಾನು ಭೂಮಿಯ ಮೇಲೆ ಮೇಘಗಳನ್ನು ಬರಮಾಡುವಾಗ, ಆ ಮಳೆಬಿಲ್ಲು ಮೇಘಗಳಲ್ಲಿ ಕಂಡುಬರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ಆಗ ನಾನು ನನಗೂ ನಿಮಗೂ ಪ್ರತಿಯೊಂದು ಜೀವಿಗಳಿಗೂ ಮಧ್ಯೆಯಿರುವ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳುವೆನು. ಇನ್ನು ಎಲ್ಲಾ ಜೀವಿಗಳನ್ನು ನಾಶಮಾಡುವ ಪ್ರಳಯವಾಗುವುದೇ ಇಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ಆ ಮಳೆಬಿಲ್ಲು ಮೇಘಗಳಲ್ಲಿರುವಾಗ, ದೇವರಾದ ನನಗೂ ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಜೀವಜಂತುಗಳಿಗೂ ಮಧ್ಯದಲ್ಲಿ ಇರುವ ನಿತ್ಯವಾದ ಒಡಂಬಡಿಕೆಯನ್ನು ಜ್ಞಾಪಕ ಮಾಡಿಕೊಳ್ಳುವ ಹಾಗೆ, ನಾನು ಅದನ್ನು ನೋಡುವೆನು.” ");
INSERT INTO kanokcv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ನಂತರ ದೇವರು ನೋಹನಿಗೆ, “ಈ ಮಳೆಬಿಲ್ಲು ನನಗೂ ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಜೀವಿಗಳಿಗೂ ಮಧ್ಯದಲ್ಲಿ ಸ್ಥಾಪಿಸಿದ ಒಡಂಬಡಿಕೆಯ ಗುರುತಾಗಿದೆ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ನಾವೆಯೊಳಗಿಂದ ಹೊರಬಂದ ನೋಹನ ಪುತ್ರರು ಯಾರೆಂದರೆ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್. ಹಾಮನು ಕಾನಾನನ ತಂದೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ಈ ಮೂವರು ನೋಹನ ಮಕ್ಕಳು; ಭೂಮಿಯ ಮೇಲೆ ಚೆದರಿದ ಎಲ್ಲ ಜನರು ಇವರಿಂದಲೇ ಉತ್ಪತ್ತಿಯಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ನೋಹನು ವ್ಯವಸಾಯಗಾರನಾಗಿದ್ದನು. ಅವನು ಒಂದು ದ್ರಾಕ್ಷಿತೋಟವನ್ನು ಪ್ರಾರಂಭಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ಅವನು ಅದರಿಂದ ಸ್ವಲ್ಪ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿದು ಅಮಲೇರಿ, ತನ್ನ ಗುಡಾರದಲ್ಲಿ ಬೆತ್ತಲೆಯಾಗಿ ಮಲಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ಕಾನಾನನ ತಂದೆ ಹಾಮನು, ತನ್ನ ತಂದೆಯ ಬೆತ್ತಲೆತನವನ್ನು ನೋಡಿ, ಹೊರಗಿದ್ದ ತನ್ನ ಸಹೋದರರಿಬ್ಬರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ಆಗ ಶೇಮನೂ ಯೆಫೆತನೂ ಬಟ್ಟೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ತಮ್ಮಿಬ್ಬರ ಹೆಗಲಿನ ಮೇಲೆ ಇಟ್ಟು, ಹಿಂಭಾಗವಾಗಿ ಹೋಗಿ, ತಮ್ಮ ತಂದೆಯ ಬೆತ್ತಲೆತನವನ್ನು ಮುಚ್ಚಿದರು. ಅವರ ಮುಖಗಳು ಹಿಮ್ಮುಖವಾಗಿದ್ದುದರಿಂದ ತಮ್ಮ ತಂದೆಯ ಬೆತ್ತಲೆತನವನ್ನು ಅವರು ನೋಡಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ನೋಹನು ದ್ರಾಕ್ಷಾರಸದ ಅಮಲಿನಿಂದ ಎಚ್ಚೆತ್ತು, ತನ್ನ ಕಿರಿಯ ಮಗನು ತನಗೆ ಮಾಡಿದ್ದನ್ನು ತಿಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ನಂತರ ಅವನು ಹೀಗೆಂದನು, “ಕಾನಾನನು ಶಾಪಗ್ರಸ್ತನಾಗಲಿ, ಅವನು ತನ್ನ ಸಹೋದರರಿಗೆ ದಾಸಾನುದಾಸನಾಗಿರಲಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ನೋಹನು ಮತ್ತೆ ಹೇಳಿದ್ದು, “ಶೇಮನ ದೇವರಾದ ಯೆಹೋವ ಸ್ತುತಿಹೊಂದಲಿ. ಕಾನಾನನು ಶೇಮನಿಗೆ ದಾಸನಾಗಿರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ಯೆಫೆತನ ಮೇರೆಗಳನ್ನು ದೇವರು ವಿಸ್ತರಿಸಲಿ. ಯೆಫೆತನು ಶೇಮನ ಗುಡಾರಗಳಲ್ಲಿ ವಾಸವಾಗಿರಲಿ, ಕಾನಾನನು ಯೆಫೆತನಿಗೆ ದಾಸನಾಗಿರಲಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ಪ್ರಳಯವಾದ ಮೇಲೆ ನೋಹನು ಮುನ್ನೂರ ಐವತ್ತು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ನೋಹ ಒಟ್ಟು ಒಂಬೈನೂರ ಐವತ್ತು ವರ್ಷ ಜೀವಿಸಿ, ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ನೋಹನ ಪುತ್ರರಾದ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತರಿಗೆ ಪ್ರಳಯವಾದ ಮೇಲೆ ಅವರಿಗೆ ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ಅವರ ವಂಶಾವಳಿ ಇದು: ");
INSERT INTO kanokcv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ಯೆಫೆತನ ಪುತ್ರರು: ಗೋಮೆರ್, ಮಾಗೋಗ್, ಮಾದಯ್, ಯಾವಾನ್ ತೂಬಲ್, ಮೆಷೆಕ್ ಮತ್ತು ತೀರಾಸ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ಗೋಮೆರನ ಪುತ್ರರು: ಅಷ್ಕೆನಜ್, ರೀಫತ್, ತೋಗರ್ಮ. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ಯಾವಾನನ ಮಕ್ಕಳು: ಎಲೀಷಾ, ತಾರ್ಷೀಷ್, ಕಿತ್ತೀಮ್, ದೋದಾನೀಮ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ಇವರಿಂದ ಕಡಲತೀರದ ಹಾಗೂ ದ್ವೀಪಗಳ ನಿವಾಸಿಯರು ತಮ್ಮ ಸ್ವಂತ ದೇಶ, ಭಾಷೆ, ಕುಲ ಜನಾಂಗಗಳ ಪ್ರಕಾರ ಹರಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ಹಾಮನ ಪುತ್ರರು: ಕೂಷ್, ಈಜಿಪ್ಟ್, ಪೂಟ್, ಕಾನಾನ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ಕೂಷನ ಪುತ್ರರು: ಸೆಬ, ಹವೀಲ, ಸಬ್ತಾ, ರಾಮ, ಸಬ್ತೆಕ. ರಾಮನ ಪುತ್ರರು: ಶೆಬಾ ಮತ್ತು ದೆದಾನ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ಕೂಷನು ನಿಮ್ರೋದನ ತಂದೆಯಾಗಿದ್ದನು, ಇವನು ಭೂಮಿಯ ಮೇಲೆ ಬಲಿಷ್ಠ ಯುದ್ಧವೀರನಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ಅವನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಬಲಿಷ್ಠ ಬೇಟೆಗಾರನಾದನು. ಆದ್ದರಿಂದ, “ನಿಮ್ರೋದನಂತೆ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಬಲಿಷ್ಠ ಬೇಟೆಗಾರ” ಎಂಬ ಹೇಳಿಕೆ ಇಂದಿಗೂ ಇದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ಶಿನಾರ್ ದೇಶದಲ್ಲಿರುವ ಬಾಬಿಲೋನ್, ಯೆರೆಕ್, ಅಕ್ಕದ್, ಕಲ್ನೇ ಎಂಬವು ಅವನ ರಾಜ್ಯದ ಪ್ರಾರಂಭದ ಕೇಂದ್ರಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ಆ ದೇಶದಿಂದ ಅವನು ಅಸ್ಸೀರಿಯಕ್ಕೆ ಹೋಗಿ ನಿನೆವೆ, ರೆಹೋಬೋತೀರ್, ಕೆಲಹ ಪಟ್ಟಣಗಳನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ಮತ್ತು ನಿನೆವೆ ಹಾಗೂ ಕೆಲಹ ಮಧ್ಯದಲ್ಲಿರುವ ರೆಸೆನ್ ಮಹಾಪಟ್ಟಣವನ್ನು ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ಈಜಿಪ್ಟನವರಿಂದ ಲೂದ್ಯರು, ಅನಾಮ್ಯರು, ಲೆಹಾಬ್ಯರು, ನಫ್ತುಹ್ಯರು ");
INSERT INTO kanokcv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ಪತ್ರುಸ್ಯರು, ಕಸ್ಲುಹ್ಯರು, ಕಫ್ತೋರ್ಯರು ಹುಟ್ಟಿದರು. ಕಸ್ಲುಹ್ಯರಿಂದ ಫಿಲಿಷ್ಟಿಯರು ಬಂದವರು, ");
INSERT INTO kanokcv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ಕಾನಾನ್ ವಂಶದಲ್ಲಿ ಮೊದಲು ಹುಟ್ಟಿದವನು ಸೀದೋನ್; ಆಮೇಲೆ ಹೇತನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ಯೆಬೂಸಿಯರು, ಅಮೋರಿಯರು, ಗಿರ್ಗಾಷಿಯರು ");
INSERT INTO kanokcv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ಹಿವ್ವಿಯರು, ಅರ್ಕಿಯರು, ಸೀನಿಯರು, ");
INSERT INTO kanokcv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ಅರ್ವಾದಿಯರು, ಚೆಮಾರಿಯರು, ಹಮಾತಿಯರು, ಕಾನಾನನಿಂದ ಹುಟ್ಟಿದರು. ತರುವಾಯ ಕಾನಾನ್ ಕುಟುಂಬಗಳು ವಿಸ್ತಾರವಾಗಿ ಹರಡಿದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ಕಾನಾನ್ಯರ ಮೇರೆಯು ಸೀದೋನ್ ಪಟ್ಟಣದಿಂದ ಗೆರಾರಿನ ಮಾರ್ಗವಾಗಿ ಗಾಜಾ ಪಟ್ಟಣದವರೆಗೂ ಮತ್ತು ಸೊದೋಮ್, ಗೊಮೋರ, ಅದ್ಮಾ, ಚೆಬೋಯಿಮ್ ಎಂಬ ಪಟ್ಟಣಗಳ ಮಾರ್ಗವಾಗಿ ಲೆಷಾ ಊರಿನವರೆಗೂ ಇರುತ್ತದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ಇವರು ತಮ್ಮ ಕುಟುಂಬಗಳ ಮತ್ತು ತಮ್ಮ ಭಾಷೆಗಳ ಪ್ರಕಾರ, ತಮ್ಮ ಸೀಮೆ ಹಾಗು ದೇಶಗಳಲ್ಲಿಯೂ ಇರುವ ಹಾಮನ ಪುತ್ರರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ಯೆಫೆತನ ಹಿರಿಯ ಸಹೋದರನೂ ಏಬೆರನ ಮಕ್ಕಳ ಮೂಲಪುರುಷನೂ ಆಗಿರುವ ಶೇಮನಿಗೆ ಸಹ ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ಶೇಮನ ಪುತ್ರರು: ಏಲಾಮ್, ಅಶ್ಯೂರ್, ಅರ್ಪಕ್ಷದ್, ಲೂದ್, ಅರಾಮ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ಅರಾಮನ ಪುತ್ರರು: ಊಚ್, ಹೂಲ್, ಗೆತೆರ್ ಮತ್ತು ಮೆಷೆಕ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ಅರ್ಪಕ್ಷದ್ ಶೆಲಹನ ತಂದೆ; ಶೆಲಹ ಏಬೆರನ ತಂದೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ಏಬೆರನಿಗೆ ಇಬ್ಬರು ಪುತ್ರರು ಹುಟ್ಟಿದರು. ಒಬ್ಬನಿಗೆ ಪೆಲೆಗ್ ಎಂದು ಹೆಸರಿಡಲಾಯಿತು, ಅವನ ಕಾಲದಲ್ಲಿ ಲೋಕದಲ್ಲಿಯ ಜನರು ವಿಭಾಗವಾದದ್ದರಿಂದ ಈ ಹೆಸರು ಅವನಿಗೆ ಬಂದಿತು. ಅವನ ತಮ್ಮನ ಹೆಸರು ಯೊಕ್ತಾನ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ಯೊಕ್ತಾನನ ಸಂತಾನದವರು: ಅಲ್ಮೋದಾದ್, ಶೆಲೆಪ್, ಹಜರ್ಮಾವೆತ್, ಯೆರಹ, ");
INSERT INTO kanokcv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ಹದೋರಾಮ್, ಊಜಾಲ್, ದಿಕ್ಲಾ, ");
INSERT INTO kanokcv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ಓಬಾಲ್, ಅಬೀಮಯೇಲ್, ಶೆಬಾ, ");
INSERT INTO kanokcv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ಓಫೀರ್, ಹವೀಲಾ ಹಾಗೂ ಯೋಬಾಬ್ ಹುಟ್ಟಿದರು. ಇವರೆಲ್ಲರೂ ಯೊಕ್ತಾನನ ಪುತ್ರರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ಅವರ ನಿವಾಸವು ಮೇಶಾ ನಾಡು ಮೊದಲುಗೊಂಡು ಪೂರ್ವದಿಕ್ಕಿನ ಸೆಫಾರ್ ಎಂಬ ಬೆಟ್ಟದವರೆಗೂ ಹರಡಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ಇವರೇ ತಮ್ಮ ಕುಟುಂಬಗಳ, ತಮ್ಮ ಭಾಷೆಗಳ ಪ್ರಕಾರ, ತಮ್ಮ ದೇಶಗಳಲ್ಲಿ, ತಮ್ಮ ಜನಾಂಗಗಳ ಪ್ರಕಾರ ಶೇಮನ ಪುತ್ರರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ವಂಶಾವಳಿಗಳಿಗೂ ಜನಾಂಗಗಳಿಗೂ ಅನುಸಾರವಾಗಿ ನೋಹನ ಪುತ್ರರ ಕುಟುಂಬಗಳು ಇವೇ. ಪ್ರಳಯವಾದ ಮೇಲೆ ಇವರಿಂದ ಜನಾಂಗಗಳು ಭೂಮಿಯಲ್ಲಿ ಹರಡಿಕೊಂಡವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ಆ ಕಾಲದಲ್ಲಿ ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ಒಂದೇ ಭಾಷೆಯಿತ್ತು. ಭಾಷಾಭೇದವೇನೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ಜನರು ಪೂರ್ವದಿಕ್ಕಿಗೆ ಪ್ರಯಾಣ ಮಾಡುವಾಗ, ಶಿನಾರ್ ದೇಶದ ಬಯಲನ್ನು ಕಂಡು ಅಲ್ಲಿ ವಾಸಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ಅಲ್ಲಿ ಅವರು, “ಬನ್ನಿರಿ ನಾವು ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡಿ, ಚೆನ್ನಾಗಿ ಸುಡೋಣ,” ಎಂದು ಒಬ್ಬರಿಗೊಬ್ಬರು ಮಾತನಾಡಿಕೊಂಡರು. ಅವರು ಕಲ್ಲಿಗೆ ಬದಲಾಗಿ ಇಟ್ಟಿಗೆಯನ್ನು, ಸುಣ್ಣಕ್ಕೆ ಬದಲಾಗಿ ಜೇಡಿಮಣ್ಣನ್ನು ಉಪಯೋಗಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ಅನಂತರ ಅವರು, “ಬನ್ನಿರಿ, ನಾವು ಭೂಮಿಯ ಮೇಲೆ ಪಟ್ಟಣವನ್ನು ಕಟ್ಟೋಣ. ಆಕಾಶವನ್ನು ಮುಟ್ಟುವ ಒಂದು ಗೋಪುರವನ್ನು ನಮಗೋಸ್ಕರವಾಗಿ ಕಟ್ಟಿಕೊಂಡು, ನಮಗೆ ಹೆಸರು ಸಂಪಾದಿಸಿಕೊಳ್ಳೋಣ. ಹೀಗೆ ಮಾಡಿದರೆ ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಚದರುವುದಕ್ಕೆ ಆಸ್ಪದವಾಗುವದಿಲ್ಲ,” ಎಂದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ಜನರು ಕಟ್ಟುತ್ತಿದ್ದ ಪಟ್ಟಣವನ್ನೂ ಗೋಪುರವನ್ನೂ ನೋಡುವುದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ಇಳಿದು ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ಯೆಹೋವ ದೇವರು, “ಇವರಿಗೆ ಒಂದೇ ಜನಾಂಗವೂ ಒಂದೇ ಭಾಷೆಯೂ ಇದೆ. ಇವರು ಇದನ್ನು ಮಾಡಲಾರಂಭಿಸಿದ್ದಾರೆ. ಈಗ ಇನ್ನು ಮುಂದೆ ಇವರು ಮಾಡುವುದಕ್ಕೆ ಉದ್ದೇಶಿಸುವುದು ಇವರಿಗೆ ಅಸಾಧ್ಯವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ನಾವು ಇಳಿದು ಹೋಗಿ, ಇವರು ಒಬ್ಬರ ಮಾತನ್ನು ಒಬ್ಬರು ತಿಳಿಯದಂತೆ, ಇವರ ಭಾಷೆಯನ್ನು ಗಲಿಬಿಲಿ ಮಾಡೋಣ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ಆದ್ದರಿಂದ ಯೆಹೋವ ದೇವರು ಅವರನ್ನು ಅಲ್ಲಿಂದ ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಚದರಿಸಿದರು. ಆಗ ಅವರು ಆ ಪಟ್ಟಣ ಕಟ್ಟುವುದನ್ನು ನಿಲ್ಲಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ಆದಕಾರಣ ಅದಕ್ಕೆ, ಬಾಬೆಲ್ ಎಂದು ಹೆಸರಾಯಿತು. ಏಕೆಂದರೆ ಅಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಇಡೀ ಜಗತ್ತಿನ ಭಾಷೆಗಳನ್ನು ಗಲಿಬಿಲಿ ಮಾಡಿದರು. ಅಲ್ಲಿಂದ ಯೆಹೋವ ದೇವರು ಅವರನ್ನು ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ಚದರಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ಶೇಮನ ವಂಶಾವಳಿ: ಶೇಮನು ನೂರು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಎಂದರೆ, ಪ್ರಳಯವಾಗಿ ಎರಡು ವರ್ಷಗಳಾದ ಮೇಲೆ ಅವನಿಂದ ಅರ್ಪಕ್ಷದನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ಶೇಮನಿಂದ ಅರ್ಪಕ್ಷದನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಶೇಮನು ಐನೂರು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಪುತ್ರರೂ ಪುತ್ರಿಯರೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ಅರ್ಪಕ್ಷದನು ಮೂವತ್ತೈದು ವರ್ಷದವನಾಗಿರುವಾಗ, ಅವನಿಂದ ಶೆಲಹನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ಅರ್ಪಕ್ಷದನಿಂದ ಶೆಲಹನು ಹುಟ್ಟಿದ ಮೇಲೆ ಅರ್ಪಕ್ಷದನು ನಾನೂರ ಮೂರು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಪುತ್ರರೂ ಪುತ್ರಿಯರೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ಶೆಲಹನು ಮೂವತ್ತು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ಏಬೆರನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ಶೆಲಹನಿಂದ ಏಬೆರನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಶೆಲಹನು ನಾನೂರ ಮೂರು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಪುತ್ರರೂ ಪುತ್ರಿಯರೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ಏಬೆರನು ಮೂವತ್ತ ನಾಲ್ಕು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ಪೆಲೆಗನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ಏಬೆರನಿಂದ ಪೆಲೆಗನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಏಬೆರನು ನಾನೂರ ಮೂವತ್ತು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಪುತ್ರರೂ ಪುತ್ರಿಯರೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ಪೆಲೆಗನು ಮೂವತ್ತು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ರೆಗೂವನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ಪೆಲೆಗನಿಂದ ರೆಗೂವನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಪೆಲೆಗನು ಇನ್ನೂರ ಒಂಬತ್ತು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಪುತ್ರರೂ ಪುತ್ರಿಯರೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ರೆಗೂವನು ಮೂವತ್ತೆರಡು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ಸೆರೂಗನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ರೆಗೂವನಿಂದ ಸೆರೂಗನು ಹುಟ್ಟಿದ ಮೇಲೆ, ರೆಗೂವನು ಇನ್ನೂರ ಏಳು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಪುತ್ರರೂ ಪುತ್ರಿಯರೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ಸೆರೂಗನು ಮೂವತ್ತು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ನಾಹೋರನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ಸೆರೂಗನಿಂದ ನಾಹೋರನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಸೆರೂಗನು ಇನ್ನೂರು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಪುತ್ರರೂ ಪುತ್ರಿಯರೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ನಾಹೋರನು ಇಪ್ಪತ್ತೊಂಬತ್ತು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ತೆರಹನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ನಾಹೋರನಿಂದ ತೆರಹನು ಹುಟ್ಟಿದ ಮೇಲೆ, ನಾಹೋರನು ನೂರ ಹತ್ತೊಂಬತ್ತು ವರ್ಷ ಬದುಕಿದನು. ಅವನಿಂದ ಪುತ್ರರೂ ಪುತ್ರಿಯರೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ತೆರಹನು ಎಪ್ಪತ್ತು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಅವನಿಂದ ಅಬ್ರಾಮನೂ ನಾಹೋರನೂ ಹಾರಾನನೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ತೆರಹನ ವಂಶಾವಳಿ: ತೆರಹನಿಂದ ಅಬ್ರಾಮನೂ ನಾಹೋರನೂ ಹಾರಾನನೂ ಹುಟ್ಟಿದರು. ಹಾರಾನನಿಂದ ಲೋಟನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ಆದರೆ ಹಾರಾನನು ತಾನು ಹುಟ್ಟಿದ ಸೀಮೆಯಾದ ಕಸ್ದೀಯರ ಊರ್ ಎಂಬ ಪಟ್ಟಣದಲ್ಲಿ ತನ್ನ ತಂದೆ ತೆರಹನಿಗಿಂತ ಮೊದಲು ಸತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ಅಬ್ರಾಮನೂ ನಾಹೋರನೂ ಮದುವೆಮಾಡಿಕೊಂಡರು. ಅಬ್ರಾಮನ ಹೆಂಡತಿಯ ಹೆಸರು ಸಾರಯಳು, ನಾಹೋರನ ಹೆಂಡತಿಯ ಹೆಸರು ಮಿಲ್ಕಾ. ಈಕೆಯು ಹಾರಾನನ ಮಗಳು. ಹಾರಾನನು ಮಿಲ್ಕಾಳಿಗೂ ಇಸ್ಕಳಿಗೂ ತಂದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ಸಾರಯಳು ಬಂಜೆಯಾದದ್ದರಿಂದ ಆಕೆಗೆ ಮಕ್ಕಳಿರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ತೆರಹನು ತನ್ನ ಮಗನಾದ ಅಬ್ರಾಮನನ್ನು ಮತ್ತು ತನಗೆ ಮೊಮ್ಮಗನೂ ಹಾರಾನನಿಗೆ ಮಗನೂ ಆದ ಲೋಟನನ್ನೂ ಹಾಗೂ ತನಗೆ ಸೊಸೆಯೂ ಅಬ್ರಾಮನಿಗೆ ಹೆಂಡತಿಯೂ ಆದ ಸಾರಯಳನ್ನೂ ಕರೆದುಕೊಂಡು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಹೋಗುವುದಕ್ಕಾಗಿ ಕಸ್ದೀಯರ ಊರ್ ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟು, ಹಾರಾನ್ ಎಂಬ ಪಟ್ಟಣಕ್ಕೆ ಬಂದು ಅಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ತೆರಹನು ಇನ್ನೂರ ಐದು ವರ್ಷ ಜೀವಿಸಿ, ಹಾರಾನಿನಲ್ಲಿ ಮರಣಹೊಂದಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ಯೆಹೋವ ದೇವರು ಅಬ್ರಾಮನಿಗೆ ಹೀಗೆ ಹೇಳಿದರು, “ನೀನು ನಿನ್ನ ಸ್ವದೇಶದಿಂದಲೂ ಬಂಧುಗಳಿಂದಲೂ ನಿನ್ನ ತಂದೆಯ ಮನೆಯಿಂದಲೂ ಹೊರಬಂದು, ನಾನು ನಿನಗೆ ತೋರಿಸುವ ನಾಡಿಗೆ ಹೋಗು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“ನಾನು ನಿನ್ನನ್ನು ದೊಡ್ಡ ಜನಾಂಗದವನನ್ನಾಗಿ ಮಾಡಿ, ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿ, ನಿನ್ನ ಹೆಸರನ್ನು ಪ್ರಸಿದ್ಧ ಮಾಡುವೆನು. ನೀನು ಆಶೀರ್ವಾದವಾಗಿ ಇರುವಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವವರನ್ನು ನಾನು ಆಶೀರ್ವದಿಸುವೆನು. ನಿನ್ನನ್ನು ಶಪಿಸುವವರನ್ನು ನಾನು ಶಪಿಸುವೆನು. ನಿನ್ನ ಮೂಲಕ ಭೂಲೋಕದ ಎಲ್ಲಾ ಜನಾಂಗಗಳಿಗೂ ಆಶೀರ್ವಾದ ಉಂಟಾಗುವುದು.” ");
INSERT INTO kanokcv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ಆದ್ದರಿಂದ ಯೆಹೋವ ದೇವರು ತನಗೆ ಹೇಳಿದ ಪ್ರಕಾರ, ಅಬ್ರಾಮನು ಹೊರಟುಹೋದನು. ಲೋಟನು ಅವನೊಂದಿಗೆ ಹೋದನು. ಅಬ್ರಾಮನು ಹಾರಾನಿನಿಂದ ಹೊರಟಾಗ ಎಪ್ಪತ್ತೈದು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ಅಬ್ರಾಮನು ತನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಯಳನ್ನೂ, ತನ್ನ ಸಹೋದರನ ಮಗ ಲೋಟನನ್ನೂ, ತಾವು ಕೂಡಿಸಿಕೊಂಡಿದ್ದ ಎಲ್ಲಾ ಆಸ್ತಿಯನ್ನೂ, ಹಾರಾನಿನಲ್ಲಿ ಸಂಪಾದಿಸಿಕೊಂಡಿದ್ದ ಎಲ್ಲಾ ಜನರನ್ನೂ ತಮ್ಮ ಸಂಗಡ ಕರೆದುಕೊಂಡು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಸೇರಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ಅಬ್ರಾಮನು ಆ ದೇಶದಲ್ಲಿ ಶೆಕೆಮ್ ಎಂಬ ಸ್ಥಳದ ಮೋರೆ ಎಂಬ ಮಹಾವೃಕ್ಷದವರೆಗೆ ಪ್ರಯಾಣಮಾಡಿದನು. ಆಗ ಕಾನಾನ್ಯರು ಆ ದೇಶದಲ್ಲಿ ಇದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ಯೆಹೋವ ದೇವರು ಅಬ್ರಾಮನಿಗೆ ಕಾಣಿಸಿಕೊಂಡು, “ನಾನು ನಿನ್ನ ಸಂತತಿಗೆ ಈ ದೇಶವನ್ನು ಕೊಡುವೆನು,” ಎಂದರು. ಆದ್ದರಿಂದ ಅವನು ಅಲ್ಲಿ ತನಗೆ ಕಾಣಿಸಿಕೊಂಡ ಯೆಹೋವ ದೇವರಿಗೆ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ಅಲ್ಲಿಂದ ಅವರು ಬೇತೇಲಿನ ಪೂರ್ವದ ಬೆಟ್ಟಕ್ಕೆ ಹೋಗಿ, ಪಶ್ಚಿಮಕ್ಕೆ ಬೇತೇಲ್, ಪೂರ್ವಕ್ಕೆ ಆಯಿ ಎಂಬ ಊರೂ ಇರುವ ಹಾಗೆ ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿಕೊಂಡನು. ಅಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿ, ಯೆಹೋವ ದೇವರ ಹೆಸರನ್ನು ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ಅಬ್ರಾಮನು ಪ್ರಯಾಣಮಾಡಿ, ನೆಗೆವ ಕಡೆಗೆ ಹೊರಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ಆಗ ಆ ದೇಶದಲ್ಲಿ ಬರ ಉಂಟಾದದ್ದರಿಂದ, ಅಬ್ರಾಮನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಕೆಲವು ಸಮಯ ಇರಲು ಇಳಿದು ಹೋದನು. ಏಕೆಂದರೆ ಬರವು ಆ ದೇಶದಲ್ಲಿ ಘೋರವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ಅವನು ಈಜಿಪ್ಟನ್ನು ಸಮೀಪಿಸುತ್ತಿದ್ದಾಗ, ತನ್ನ ಹೆಂಡತಿ ಸಾರಯಳಿಗೆ, “ನೀನು ನೋಡುವುದಕ್ಕೆ ರೂಪವತಿಯೆಂದು ನನಗೆ ತಿಳಿದಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ಹೀಗಿರುವುದರಿಂದ ಈಜಿಪ್ಟಿನವರು ನಿನ್ನನ್ನು ಕಂಡು, ‘ಈಕೆಯು ಅವನ ಹೆಂಡತಿ’ ಎಂದು ಹೇಳಿ, ನನ್ನನ್ನು ಕೊಂದುಹಾಕಿ, ನಿನ್ನನ್ನು ಉಳಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ನಿನ್ನ ದೆಸೆಯಿಂದ ನನಗೆ ಒಳ್ಳೆಯದಾಗಿ, ನನ್ನ ಪ್ರಾಣವು ಉಳಿಯುವಂತೆ ನೀನು ನನ್ನ ಸಹೋದರಿ ಎಂದು ದಯಮಾಡಿ ಹೇಳಬೇಕು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ಅಬ್ರಾಮನು ಈಜಿಪ್ಟಿಗೆ ಬಂದಾಗ, ಈಜಿಪ್ಟಿನವರು, ಆ ಸಾರಯಳು ಬಹಳ ಸುಂದರಿ ಎಂದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ಫರೋಹನ ಅಧಿಕಾರಿಗಳು ಆಕೆಯನ್ನು ನೋಡಿ, ಫರೋಹನ ಮುಂದೆ ಆಕೆಯನ್ನು ಹೊಗಳಿ, ಆ ಸ್ತ್ರೀಯನ್ನು ಅವನ ಅರಮನೆಗೆ ಕರೆದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ಅವನು ಆಕೆಗೋಸ್ಕರ ಅಬ್ರಾಮನಿಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡಿದನು. ಅವನಿಗೆ ಕುರಿ, ಎತ್ತು, ಕತ್ತೆಗಳೂ ದಾಸದಾಸಿಯರೂ ಹೆಣ್ಣು ಕತ್ತೆಗಳೂ ಒಂಟೆಗಳೂ ದೊರೆತವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ಆದರೆ ಯೆಹೋವ ದೇವರು ಫರೋಹನನ್ನೂ, ಅವನ ಮನೆಯನ್ನೂ ಅಬ್ರಾಮನ ಹೆಂಡತಿ ಸಾರಯಳಿಗಾಗಿ ಭಯಂಕರವಾದ ರೋಗಗಳಿಂದ ಬಾಧಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ಅನಂತರ ಫರೋಹನು ಅಬ್ರಾಮನನ್ನು ಕರೆಯಿಸಿ, “ನೀನು ನನಗೆ ಮಾಡಿದ್ದೇನು? ಈಕೆಯು ನಿನ್ನ ಹೆಂಡತಿ ಎಂದು ಯಾಕೆ ನನಗೆ ತಿಳಿಸಲಿಲ್ಲ? ");
INSERT INTO kanokcv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‘ಆಕೆಯು ನನ್ನ ಸಹೋದರಿ,’ ಎಂದು ಯಾಕೆ ಹೇಳಿದೆ? ನೀನು ಹಾಗೆ ಹೇಳಿದ್ದರಿಂದ ಆಕೆಯನ್ನು ನನಗೆ ಹೆಂಡತಿಯಾಗಿ ಇಟ್ಟುಕೊಳ್ಳುವುದರಲ್ಲಿದ್ದೆನು. ಆದರೆ ಈಗ, ನಿನ್ನ ಹೆಂಡತಿ, ಈಕೆಯನ್ನು ನೀನು ಕರೆದುಕೊಂಡು ಹೋಗು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ಫರೋಹನು ತನ್ನ ಜನರಿಗೆ ಅವನ ವಿಷಯದಲ್ಲಿ ಆಜ್ಞಾಪಿಸಲು, ಅವರು ಅಬ್ರಾಮನನ್ನೂ ಅವನ ಹೆಂಡತಿಯನ್ನೂ ಅವನಿಗಿದ್ದ ಎಲ್ಲದರ ಸಮೇತ ಅಲ್ಲಿಂದ ಕಳುಹಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ಆಗ ಅಬ್ರಾಮನು ತನ್ನ ಹೆಂಡತಿಯೊಂದಿಗೆ ತನಗೆ ಇದ್ದದ್ದನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು ಲೋಟನ ಸಂಗಡ ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟು ನೆಗೆವಕ್ಕೆ ಪ್ರಯಾಣಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ಅಬ್ರಾಮನು ಪಶುಗಳು, ಬೆಳ್ಳಿ ಮತ್ತು ಬಂಗಾರವನ್ನು ಹೊಂದಿ ಬಹು ಧನವಂತನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ಅವನು ತನ್ನ ಪ್ರಯಾಣಗಳಲ್ಲಿ ನೆಗೆವದಿಂದ ಬೇತೇಲಿಗೆ, ಎಂದರೆ ಮೊದಲು ಬೇತೇಲಿಗೂ ಆಯಿ ಎಂಬ ಊರಿಗೂ ಮಧ್ಯದಲ್ಲಿ ಅವನ ಗುಡಾರವಿದ್ದ ಸ್ಥಳಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ಅಲ್ಲಿ ಅಬ್ರಾಮನು ಯೆಹೋವ ದೇವರ ಹೆಸರನ್ನು ಹೇಳಿಕೊಂಡು ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ಅಬ್ರಾಮನ ಸಂಗಡ ಬಂದ ಲೋಟನಿಗೆ ಸಹ ಕುರಿ ದನಗಳೂ ಗುಡಾರಗಳೂ ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ಆಗ ಅವರು ಒಂದಾಗಿ ವಾಸಿಸಲಿಕ್ಕೆ ಆ ಸ್ಥಳ ಸಾಲದೆ ಹೋಯಿತು. ಅವರಿಬ್ಬರ ಸಂಪತ್ತು ಬಹಳವಾಗಿದ್ದರಿಂದ ಒಂದೇ ಸ್ಥಳದಲ್ಲಿ ಅವರು ವಾಸವಾಗಿರಲು ಆಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ಆಗ ಅಬ್ರಾಮನ ದನ ಕಾಯುವವರಿಗೂ ಲೋಟನ ದನ ಕಾಯುವವರಿಗೂ ಜಗಳವಾಯಿತು. ಕಾನಾನ್ಯರೂ ಪೆರಿಜೀಯರೂ ಆಗ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ಅಬ್ರಾಮನು ಲೋಟನಿಗೆ, “ನನಗೂ, ನಿನಗೂ; ನನ್ನ ದನ ಕಾಯುವವರಿಗೂ ನಿನ್ನ ದನ ಕಾಯುವವರಿಗೂ ಜಗಳವಿರಬಾರದು. ಏಕೆಂದರೆ ನಾವು ಬಳಗದವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ದೇಶವೆಲ್ಲಾ ನಿನ್ನ ಮುಂದೆ ಇರುತ್ತದೆಯಲ್ಲವೆ? ನಾವು ಪ್ರತ್ಯೇಕವಾಗೋಣ. ನೀನು ಎಡಕ್ಕೆ ಹೋದರೆ, ನಾನು ಬಲಕ್ಕೆ ಹೋಗುವೆನು; ನೀನು ಬಲಕ್ಕೆ ಹೋದರೆ, ನಾನು ಎಡಕ್ಕೆ ಹೋಗುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ಲೋಟನು ತನ್ನ ಕಣ್ಣುಗಳನ್ನೆತ್ತಿ ನೋಡಿ ಯೊರ್ದನಿನ ಮೈದಾನವನ್ನೆಲ್ಲಾ ಕಂಡನು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ಸೊದೋಮನ್ನೂ ಗೊಮೋರವನ್ನೂ ನಾಶ ಮಾಡುವುದಕ್ಕಿಂತ ಮುಂಚೆ, ಅದೆಲ್ಲಾ ಚೋಗರಿನವರೆಗೆ ನೀರಾವರಿ ಪ್ರದೇಶವಾಗಿದ್ದು, ಯೆಹೋವ ದೇವರ ತೋಟದಂತೆಯೂ ಈಜಿಪ್ಟ್ ದೇಶದಂತೆಯೂ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ಆದುದರಿಂದ ಲೋಟನು ಯೊರ್ದನಿನ ಕಣಿವೆಯನ್ನೆಲ್ಲಾ ತನಗಾಗಿ ಆರಿಸಿಕೊಂಡನು. ಲೋಟನು ಪೂರ್ವದಿಕ್ಕಿನ ಕಡೆಗೆ ಹೊರಟಿದ್ದರಿಂದ, ಅವರು ಒಬ್ಬರಿಂದೊಬ್ಬರು ಪ್ರತ್ಯೇಕವಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ಅಬ್ರಾಮನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡಿದನು. ಲೋಟನಾದರೋ ಸಮತಟ್ಟಾದ ಊರುಗಳಲ್ಲಿ ವಾಸಿಸುತ್ತಾ ಸೊದೋಮಿನ ಬಳಿ ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ಸೊದೋಮಿನ ಜನರು ದುಷ್ಟರಾಗಿದ್ದರು ಮತ್ತು ಯೆಹೋವ ದೇವರ ವಿರುದ್ಧ ಬಹಳ ಪಾಪಮಾಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ಲೋಟನು ಅಬ್ರಾಮನಿಂದ ಹೋದ ಮೇಲೆ ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ, “ಈಗ ನೀನಿರುವ ಸ್ಥಳದಿಂದ ಉತ್ತರಕ್ಕೂ ದಕ್ಷಿಣಕ್ಕೂ ಪೂರ್ವಕ್ಕೂ ಪಶ್ಚಿಮಕ್ಕೂ ಕಣ್ಣೆತ್ತಿ ನೋಡು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ಏಕೆಂದರೆ ನೀನು ಕಾಣುವ ದೇಶವನ್ನೆಲ್ಲಾ ನಾನು ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಗೂ ಶಾಶ್ವತವಾಗಿ ಕೊಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ಭೂಮಿಯ ಧೂಳನ್ನು ಒಬ್ಬನು ಲೆಕ್ಕಿಸಬಹುದಾದರೆ, ನಿನ್ನ ಸಂತಾನದವರನ್ನು ಸಹ ಲೆಕ್ಕಿಸಲು ಸಾಧ್ಯವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ಎದ್ದು ದೇಶದ ಉದ್ದಗಲಕ್ಕೂ ನಡೆದಾಡು. ನಾನು ನಿನಗೆ ಅದನ್ನು ಕೊಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ಅನಂತರ ಅಬ್ರಾಮನು ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿಸಿಕೊಳ್ಳುತ್ತಾ, ಹೆಬ್ರೋನಿನಲ್ಲಿರುವ ಮಮ್ರೆಯ ತೋಪಿಗೆ ಬಂದು, ಅಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ಅಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಒಂದು ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ಶಿನಾರಿನ ಅರಸ ಅಮ್ರಾಫೆಲನು ಎಲ್ಲಸಾರಿನ ಅರಸ ಅರಿಯೋಕನು, ಏಲಾಮಿನ ಅರಸ ಕೆದೊರ್ಲಗೋಮರನು, ಗೋಯಿಮದ ಅರಸ ತಿದ್ಗಾಲನು ಇವರ ದಿನಗಳಲ್ಲಿ ಆದದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ಇವರು ಸೊದೋಮಿನ ಅರಸ ಬೆರಗನೂ ಗೊಮೋರದ ಅರಸ ಬಿರ್ಶಗನೂ ಅದ್ಮಾಹದ ಅರಸ ಶಿನಾಬನಿಗೂ ಚೆಬೋಯಿಮಿನ ಅರಸ ಶೆಮೇಬರನಿಗೂ ಬೆಲಗಿನ ಅಂದರೆ, ಚೋಗರದ ಅರಸನಿಗೂ ವಿರೋಧವಾಗಿ ಯುದ್ಧಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ಇವರೆಲ್ಲರು ಉಪ್ಪಿನ ಸಮುದ್ರವಾಗಿರುವ ಸಿದ್ದೀಮ್ ತಗ್ಗಿನಲ್ಲಿ ಒಟ್ಟಾಗಿ ಕೂಡಿಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ಅವರು ಹನ್ನೆರಡು ವರ್ಷ ಕೆದೊರ್ಲಗೋಮರನಿಗೆ ಸೇವೆಮಾಡಿ, ಹದಿಮೂರನೆಯ ವರ್ಷದಲ್ಲಿ ತಿರುಗಿಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ಹದಿನಾಲ್ಕನೆಯ ವರ್ಷದಲ್ಲಿ ಕೆದೊರ್ಲಗೋಮರನೂ ಅವನ ಸಂಗಡ ಇದ್ದ ಅರಸರೂ ಬಂದು ಅಷ್ಟರೋತ್ ಕರ್ನಯಿಮಿನಲ್ಲಿ ರೆಫಾಯರನ್ನೂ, ಹಾಮಿನಲ್ಲಿ ಜೂಜ್ಯರನ್ನೂ, ಶಾವೆ ಕಿರ್ಯಾತಯಿಮಿನಲ್ಲಿ ಏಮಿಯರನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ಅವರ ಬೆಟ್ಟವಾದ ಸೇಯೀರನಲ್ಲಿ ಹೋರಿಯರನ್ನೂ ಅರಣ್ಯಕ್ಕೆ ಸಮೀಪವಾದ ಏಲ್ಪಾರಾನಿನವರೆಗೂ ಅವರನ್ನು ಸೋಲಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ಅವರು ಹಿಂದಿರುಗಿ ಕಾದೇಶ್ ಎಂಬ ಎನ್ಮಿಷ್ಪಾಟಿಗೆ ಬಂದು, ಅಮಾಲೇಕ್ಯರ ಎಲ್ಲಾ ಬಯಲನ್ನು ಹಜಜೋನ್ ತಾಮಾರಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಅಮೋರಿಯರನ್ನೂ ಜಯಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ಸೊದೋಮಿನ ಅರಸನೂ ಗೊಮೋರದ ಅರಸನೂ ಅದ್ಮಾಹದ ಅರಸನೂ ಚೆಬೋಯಿಮಿನ ಅರಸನೂ ಚೋಗರೆಂಬ ಬೆಲಗದ ಅರಸನೂ ಹೊರಟು, ");
INSERT INTO kanokcv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ಏಲಾಮಿನ ಅರಸ ಕೆದೊರ್ಲಗೋಮರನಿಗೂ ಗೋಯಿಮದ ಅರಸನಾದ ತಿದ್ಗಾಲನಿಗೂ ಶಿನಾರಿನ ಅರಸ ಅಮ್ರಾಫೆಲನಿಗೂ ಎಲ್ಲಸಾರಿನ ಅರಸ ಅರಿಯೋಕನಿಗೂ ವಿರೋಧವಾಗಿ ಸಿದ್ದೀಮ್ ತಗ್ಗಿನಲ್ಲಿ ಯುದ್ಧಮಾಡಿದರು. ಹೀಗೆ ನಾಲ್ವರು ಅರಸರಿಗೆ ವಿರೋಧವಾಗಿ ಐದು ಮಂದಿ ಅರಸರು ಎದುರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ಸಿದ್ದೀಮ್ ತಗ್ಗು ಕಲ್ಲರಗಿನ ಕೆಸರುಕುಣಿಗಳಿಂದ ತುಂಬಿತ್ತು. ಸೊದೋಮ್ ಗೊಮೋರಗಳ ಅರಸರು ಓಡಿಹೋಗಿ ಅದರಲ್ಲಿ ಬಿದ್ದರು. ಉಳಿದವರು ಬೆಟ್ಟಕ್ಕೆ ಓಡಿಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ಆಗ ಅವರು ಸೊದೋಮ್, ಗೊಮೋರಗಳ ಎಲ್ಲಾ ಸಂಪತ್ತನ್ನೂ, ಅವರ ಎಲ್ಲಾ ಆಹಾರ ಪದಾರ್ಥಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ಸೊದೋಮಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಅಬ್ರಾಮನ ಸಹೋದರನ ಮಗ ಲೋಟನನ್ನು ಅವನ ಆಸ್ತಿ ಸಹಿತ ಹಿಡಿದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ತಪ್ಪಿಸಿಕೊಂಡವನೊಬ್ಬನು ಹೋಗಿ ಹಿಬ್ರಿಯನಾದ ಅಬ್ರಾಮನಿಗೆ ಇದನ್ನು ತಿಳಿಸಿದನು. ಆಗ ಅಬ್ರಾಮನು ಎಷ್ಕೋಲನಿಗೂ ಆನೇರನಿಗೂ ಸಹೋದರನಾಗಿದ್ದ ಅಮೋರಿಯನಾದ ಮಮ್ರೆಯನ ತೋಪಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ಇವರು ಅಬ್ರಾಮನೊಂದಿಗೆ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಂಡಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ತನ್ನ ಸಹೋದರನ ಮಗನು ಸೆರೆಯಾಗಿ ಹೋಗಿರುವುದನ್ನು ಕೇಳಿದಾಗ, ಅಬ್ರಾಮನು ತನ್ನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿ, ಶಿಕ್ಷಿತರಾಗಿದ್ದ ಮುನ್ನೂರ ಹದಿನೆಂಟು ಸೇವಕರನ್ನು ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧಮಾಡಿ, ದಾನಿನವರೆಗೆ ಹಿಂದಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ಅಬ್ರಾಮನು ರಾತ್ರಿಯಲ್ಲಿ ಅವರಿಗೆ ವಿರೋಧವಾಗಿ ತನ್ನ ಸೇವಕರ ಸೈನ್ಯವನ್ನು ವಿಭಾಗಿಸಿ, ಅವರನ್ನು ಹೊಡೆದು, ದಮಸ್ಕದ ಉತ್ತರದಲ್ಲಿ ಹೋಬಾದವರೆಗೆ ಅವರನ್ನು ಸೋಲಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ಆಸ್ತಿಯನ್ನೆಲ್ಲಾ ಹಿಂದಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಬಂದನು. ತನ್ನ ಬಂಧುವಾದ ಲೋಟನನ್ನೂ, ಅವನ ಸಂಪತ್ತನ್ನೂ ಸ್ತ್ರೀಯರನ್ನೂ ಜನರನ್ನೂ ಹಿಂದಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ಅವನು ಕೆದೊರ್ಲಗೋಮರನನ್ನೂ, ಅವನ ಸಂಗಡ ಇದ್ದ ರಾಜರನ್ನೂ ಸೋಲಿಸಿ, ಹಿಂದಿರುಗಿ ಬಂದಾಗ, ಸೊದೋಮಿನ ಅರಸನು ಹೊರಟು ಶಾವೆ ತಗ್ಗು ಎಂಬ ಅರಸನ ತಗ್ಗಿನಲ್ಲಿ ಅಬ್ರಾಮನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕಾಗಿ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ಸಾಲೇಮಿನ ಅರಸ ಮೆಲ್ಕಿಜೆದೇಕನು ರೊಟ್ಟಿ ಮತ್ತು ದ್ರಾಕ್ಷಾರಸವನ್ನು ತಂದನು. ಇವನು ಮಹೋನ್ನತರಾದ ದೇವರ ಯಾಜಕನೂ ಆಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ಇವನು ಅಬ್ರಾಮನನ್ನು ಹೀಗೆ ಆಶೀರ್ವದಿಸಿದನು: “ಅಬ್ರಾಮನು ಭೂಮಿ, ಆಕಾಶವನ್ನು ಸೃಷ್ಟಿಸಿದ ಮಹೋನ್ನತ ದೇವರಿಂದ ಆಶೀರ್ವಾದ ಹೊಂದಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ನಿನ್ನ ಶತ್ರುಗಳನ್ನು ನಿನ್ನ ಕೈಗೆ ಒಪ್ಪಿಸಿದ ಮಹೋನ್ನತ ದೇವರು ಸ್ತುತಿಹೊಂದಲಿ.” ಅಬ್ರಾಮನು ಎಲ್ಲವುಗಳಲ್ಲಿ ಅವನಿಗೆ ಹತ್ತನೆಯ ಒಂದು ಭಾಗವನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ಸೊದೋಮಿನ ಅರಸನು ಅಬ್ರಾಮನಿಗೆ, “ನೀನು ಬಿಡಿಸಿಕೊಂಡು ಬಂದ ಜನರನ್ನು ನನಗೆ ಕೊಡು. ಸಂಪತ್ತನ್ನು ನೀನು ತೆಗೆದುಕೋ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ಅದಕ್ಕೆ ಅಬ್ರಾಮನು ಸೊದೋಮಿನ ಅರಸನಿಗೆ, “ಭೂಮಿ ಆಕಾಶವನ್ನು ಸ್ವಾಧೀನ ಪಡಿಸಿಕೊಂಡಿರುವ ಮಹೋನ್ನತ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರ ಕಡೆಗೆ ನನ್ನ ಕೈ ಎತ್ತಿ ಪ್ರಮಾಣ ಮಾಡುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ನಿನಗೆ ಸೇರಿದ ದಾರವನ್ನಾಗಲಿ, ಕೆರದ ಬಾರನ್ನಾಗಲಿ ನಾನು ತೆಗೆದುಕೊಳ್ಳುವುದಿಲ್ಲ. ಏಕೆಂದರೆ, ‘ನಾನು ಅಬ್ರಾಮನನ್ನು ಐಶ್ವರ್ಯವಂತನನ್ನಾಗಿ ಮಾಡಿದ್ದೇನೆ’ ಎಂದು ನೀನು ಹೇಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ನನ್ನ ಆಳುಗಳು ಊಟಮಾಡಿದ್ದು ಸಾಕು. ನನ್ನ ಸಂಗಡ ಬಂದ ಆನೇರ, ಎಷ್ಕೋಲ್ ಮತ್ತು ಮಮ್ರೆ ಎಂಬ ಈ ಜನರ ಪಾಲನ್ನು ಬಿಟ್ಟು ನಾನು ಏನನ್ನೂ ತೆಗೆದುಕೊಳ್ಳುವುದಿಲ್ಲ. ಇವರು ತಮ್ಮ ಪಾಲನ್ನು ತೆಗೆದುಕೊಳ್ಳಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ಇವುಗಳಾದ ಮೇಲೆ ಯೆಹೋವ ದೇವರ ವಾಕ್ಯವು ಅಬ್ರಾಮನಿಗೆ ದರ್ಶನದಲ್ಲಿ ಉಂಟಾಗಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಅಬ್ರಾಮನೇ, ಭಯಪಡಬೇಡ. ನಾನು ನಿನಗೆ ಗುರಾಣಿಯಾಗಿದ್ದೇನೆ. ನಾನೇ ನಿನಗೆ ಅತ್ಯಧಿಕ ಬಹುಮಾನವಾಗಿದ್ದೇನೆ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ಅದಕ್ಕೆ ಅಬ್ರಾಮನು, “ಸಾರ್ವಭೌಮ ಯೆಹೋವ ದೇವರೇ, ಮಕ್ಕಳಿಲ್ಲದವನಾಗಿರುವ ನನಗೆ ಏನು ಕೊಡುವಿರಿ? ಈ ದಮಸ್ಕದ ಎಲೀಯೆಜೆರನಿಗೆ ನನ್ನ ಆಸ್ತಿ ಪಾಲಾಗಿಬಿಡುವುದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ಅನಂತರ ಅಬ್ರಾಮನು, “ನೀವು ನನಗೆ ಸಂತಾನವನ್ನು ಕೊಡಲಿಲ್ಲ. ನನ್ನ ಮನೆಯಲ್ಲಿರುವ ದಾಸನೇ ಉತ್ತರಾಧಿಕಾರಿಯಾಗಿರುವನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ಆಗ ಯೆಹೋವ ದೇವರ ವಾಕ್ಯವು, “ಈ ಮನುಷ್ಯನು ನಿನ್ನ ಉತ್ತರಾಧಿಕಾರಿಯಾಗುವುದಿಲ್ಲ. ನಿನ್ನಿಂದಲೇ ಹುಟ್ಟಿಬರುವ ನಿನ್ನ ಮಗನು ನಿನ್ನ ವಾರಸುದಾರನಾಗುವನು,” ಎಂದು ಹೇಳಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ಯೆಹೋವ ದೇವರು ಅವನನ್ನು ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದು, “ಈಗ ನೀನು ಆಕಾಶವನ್ನು ದೃಷ್ಟಿಸಿ, ನಕ್ಷತ್ರಗಳನ್ನು ಲೆಕ್ಕಿಸಲು ನಿನ್ನಿಂದಾದರೆ, ಲೆಕ್ಕಿಸು. ಅದರಂತೆಯೇ ನಿನ್ನ ಸಂತತಿಯು ಆಗುವುದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ಅಬ್ರಾಮನು ಯೆಹೋವ ದೇವರನ್ನು ನಂಬಿದನು, ಆ ನಂಬಿಕೆಯು ಅವನ ಲೆಕ್ಕಕ್ಕೆ ನೀತಿ ಎಂದು ಎಣಿಸಲಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ದೇವರು ಅವನಿಗೆ, “ಈ ದೇಶವನ್ನು ಸೊತ್ತಾಗಿ ನಿನಗೆ ಕೊಡಲು, ಕಸ್ದೀಯರ ಊರ್ ಎಂಬ ಪ್ರದೇಶದಿಂದ ನಿನ್ನನ್ನು ಹೊರಗೆ ತಂದ ಯೆಹೋವ ದೇವರು ನಾನೇ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ಅದಕ್ಕೆ ಅವನು, “ಸಾರ್ವಭೌಮ ಯೆಹೋವ ದೇವರೇ ನಾನು ಅದನ್ನು ನನ್ನ ಸೊತ್ತಾಗಿ ಹೊಂದುವೆನೆಂದು ಯಾವುದರಿಂದ ತಿಳಿದುಕೊಳ್ಳಲಿ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ಅದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ಅಬ್ರಾಮನಿಗೆ, “ಮೂರು ವರ್ಷದ ಕಡಸನ್ನು, ಮೂರು ವರ್ಷದ ಮೇಕೆಯನ್ನು, ಮೂರು ವರ್ಷದ ಟಗರನ್ನು, ಒಂದು ಬೆಳವಕ್ಕಿಯನ್ನು, ಒಂದು ಪಾರಿವಾಳವನ್ನು ನನಗಾಗಿ ತೆಗೆದುಕೊಂಡು ಬಾ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ಅನಂತರ ಅವನು ಇವುಗಳನ್ನೆಲ್ಲಾ ಯೆಹೋವ ದೇವರಿಗಾಗಿ ತೆಗೆದುಕೊಂಡು ಬಂದು ಎರಡೆರಡು ಹೋಳುಮಾಡಿ, ಒಂದು ತುಂಡನ್ನು ಇನ್ನೊಂದರ ಎದುರಾಗಿ ಇಟ್ಟನು. ಆದರೆ ಅವನು ಪಕ್ಷಿಗಳನ್ನು ತುಂಡು ಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ರಣಹದ್ದುಗಳು ಆ ಶವಗಳ ಮೇಲೆ ಇಳಿದು ಬಂದಾಗ, ಅಬ್ರಾಮನು ಅವುಗಳನ್ನು ಓಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ಸೂರ್ಯನು ಅಸ್ತಮಿಸಲಾಗಿ ಅಬ್ರಾಮನಿಗೆ ಗಾಢನಿದ್ರೆ ಹತ್ತಿತ್ತು. ಭೀಕರವಾದ ಕಾರ್ಗತ್ತಲು ಅವನ ಮೇಲೆ ಕವಿಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ಯೆಹೋವ ದೇವರು ಅಬ್ರಾಮನಿಗೆ, “ನಿನ್ನ ಸಂತತಿಯವರು ತಮ್ಮದಲ್ಲದ ದೇಶದಲ್ಲಿ ಪ್ರವಾಸಿಗಳಾಗಿರುವರು, ಅವರು ಗುಲಾಮರಾಗಿ ನಾಲ್ಕುನೂರು ವರ್ಷಗಳವರೆಗೆ ದಬ್ಬಾಳಿಕೆಗೆ ಗುರಿಯಾಗುವರು ಎಂಬುದನ್ನು ನೀನು ಖಂಡಿತವಾಗಿಯೂ ತಿಳಿಯತಕ್ಕದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ಆದರೆ ಅವರು ಗುಲಾಮರಾಗಿ ಸೇವೆ ಸಲ್ಲಿಸುತ್ತಿದ್ದ ದೇಶಕ್ಕೆ ನಾನು ನ್ಯಾಯತೀರಿಸುವೆನು. ತರುವಾಯ ಮಹಾ ಸಂಪತ್ತಿನೊಂದಿಗೆ ಅವರು ಹೊರಗೆ ಬರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ನೀನಾದರೋ ಸಮಾಧಾನದಿಂದ ನಿನ್ನ ಪಿತೃಗಳ ಬಳಿಗೆ ಸೇರುವೆ. ಬಹಳ ಮುದಿ ಪ್ರಾಯದವನಾಗಿ ಮರಣಹೊಂದುವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ಆಗ ನಾಲ್ಕನೆಯ ಸಂತಾನದವರು ಇಲ್ಲಿಗೆ ತಿರುಗಿ ಬರುವರು. ಏಕೆಂದರೆ ಅಮೋರಿಯರ ಅಪರಾಧವು ಇನ್ನೂ ಪೂರ್ಣಸ್ಥಿತಿಗೆ ಬರಲಿಲ್ಲ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ಇದಾದ ಮೇಲೆ ಹೊತ್ತು ಮುಳುಗಿ ಕತ್ತಲಾಗುತ್ತಿರಲು, ಹೊಗೆ ಹಾಯುವ ಒಲೆಯೂ ಉರಿಯುವ ದೀಪವೂ ಆ ತುಂಡುಗಳ ಮಧ್ಯದಲ್ಲಿ ಹಾದು ಹೋದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ಅದೇ ದಿನದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಅಬ್ರಾಮನ ಸಂಗಡ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಂಡು, “ಈಜಿಪ್ಟ್ ದೇಶದ ನದಿಯಿಂದ ಮಹಾನದಿ ಯೂಫ್ರೇಟೀಸ್ ನದಿಯವರೆಗೆ ವಾಸಿಸುವ ");
INSERT INTO kanokcv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ಕೇನ್ಯರೂ ಕೆನಿಜ್ಜೀಯರೂ ಕದ್ಮೋನಿಯರೂ ");
INSERT INTO kanokcv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ಹಿತ್ತಿಯರೂ ಪೆರಿಜೀಯರೂ ರೆಫಾಯರೂ ");
INSERT INTO kanokcv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ಅಮೋರಿಯರೂ ಕಾನಾನ್ಯರೂ ಗಿರ್ಗಾಷಿಯರೂ ಯೆಬೂಸಿಯರೂ ವಾಸವಾಗಿರುವ ದೇಶವನ್ನು ನಾನು ನಿನ್ನ ಸಂತತಿಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ಅಬ್ರಾಮನ ಹೆಂಡತಿ ಸಾರಯಳಿಗೆ ಮಕ್ಕಳಿರಲಿಲ್ಲ. ಆಕೆಗೆ ಹಾಗರಳೆಂಬ ಈಜಿಪ್ಟಿನ ದಾಸಿ ಇದ್ದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ಆಗ ಸಾರಯಳು ಅಬ್ರಾಮನಿಗೆ, “ನಾನು ಮಕ್ಕಳನ್ನು ಹೆರದಂತೆ ಯೆಹೋವ ದೇವರು ನನಗೆ ಅಡ್ಡಿ ಮಾಡಿದ್ದಾರೆ. ದಯಮಾಡಿ ನೀನು ನನ್ನ ದಾಸಿಯ ಬಳಿಗೆ ಹೋಗು. ಒಂದು ವೇಳೆ ನಾನು ಅವಳ ಮೂಲಕ ಕುಟುಂಬವನ್ನು ಕಟ್ಟಬಲ್ಲೆ,” ಎಂದಳು. ಅಬ್ರಾಮನು ಸಾರಯಳ ಮಾತನ್ನು ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ಅಬ್ರಾಮನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಹತ್ತು ವರ್ಷ ವಾಸಿಸಿದ ತರುವಾಯ, ಅಬ್ರಾಮನ ಹೆಂಡತಿಯಾದ ಸಾರಯಳು ಈಜಿಪ್ಟಿನವಳಾದ ಹಾಗರಳೆಂಬ ದಾಸಿಯನ್ನು ತನ್ನ ಗಂಡನಿಗೆ ಹೆಂಡತಿಯಾಗಿ ಒಪ್ಪಿಸಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ಅವನು ಹಾಗರಳನ್ನು ಕೂಡಿದನು. ಆಗ ಅವಳು ಗರ್ಭಿಣಿಯಾದಳು. ತಾನು ಗರ್ಭಿಣಿಯಾದೆನೆಂದು ತಿಳಿದಾಗ, ಅವಳು ತನ್ನ ಯಜಮಾನಿಯನ್ನು ತಿರಸ್ಕರಿಸಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ಸಾರಯಳು ಅಬ್ರಾಮನಿಗೆ, “ನನಗೆ ಆದ ಅನ್ಯಾಯಕ್ಕೆ ನೀನೇ ಹೊಣೆ. ನಾನು ನನ್ನ ದಾಸಿಯನ್ನು ನಿನಗೆ ಹೆಂಡತಿಯಾಗಿ ಕೊಟ್ಟೆನು. ಈಗ ಅವಳು ಗರ್ಭಿಣಿಯಾದ್ದರಿಂದ ನಾನು ಅವಳ ಕಣ್ಣಿಗೆ ತಿರಸ್ಕಾರಕ್ಕೆ ಯೋಗ್ಯಳಾದೆನು. ಯೆಹೋವ ದೇವರು ನಿನಗೂ ನನಗೂ ನ್ಯಾಯತೀರಿಸಲಿ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ಆದರೆ ಅಬ್ರಾಮನು ಸಾರಯಳಿಗೆ, “ಇಗೋ, ನಿನ್ನ ದಾಸಿಯು ನಿನ್ನ ಕೈಯಲ್ಲಿ ಇದ್ದಾಳೆ. ನಿನ್ನ ಮನಸ್ಸಿಗೆ ಬಂದಂತೆ ಮಾಡು,” ಎಂದನು. ಆಗ ಸಾರಯಳು ಹಾಗರಳನ್ನು ಬಾಧಿಸಿದ್ದರಿಂದ, ಅವಳು ಸಾರಯಳಿಂದ ಓಡಿ ಹೋದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ಯೆಹೋವ ದೇವರ ದೂತನು ಮರುಭೂಮಿಯಲ್ಲಿ ಶೂರಿನ ಮಾರ್ಗವಾಗಿರುವ ಒಂದು ನೀರಿನ ಬುಗ್ಗೆಯ ಬಳಿಯಲ್ಲಿ ಹಾಗರಳನ್ನು ಕಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“ಸಾರಯಳ ದಾಸಿ ಹಾಗರಳೇ, ನೀನು ಎಲ್ಲಿಂದ ಬಂದೆ? ನೀನು ಎಲ್ಲಿಗೆ ಹೋಗುತ್ತೀ?” ಎಂದು ವಿಚಾರಿಸಿದನು. ಅವಳು, “ನನ್ನ ಯಜಮಾನಿ ಸಾರಯಳನ್ನು ಬಿಟ್ಟು ಓಡಿ ಹೋಗುತ್ತಿದ್ದೇನೆ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ಯೆಹೋವ ದೇವರ ದೂತನು ಆಕೆಗೆ, “ನಿನ್ನ ಯಜಮಾನಿಯ ಬಳಿಗೆ ಹಿಂದಿರುಗಿ ಹೋಗಿ ಆಕೆಗೆ ಅಧೀನಳಾಗಿರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರ ದೂತನು ಅವಳಿಗೆ, “ನಿನ್ನ ಸಂತಾನವನ್ನು ಲೆಕ್ಕಿಸಲಾಗದಷ್ಟು ಹೆಚ್ಚಿಸುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ಅನಂತರ ಯೆಹೋವ ದೇವರ ದೂತನು ಆಕೆಗೆ ಹೀಗೆ ಹೇಳಿದನು: “ನೀನು ಈಗ ಗರ್ಭಿಣಿಯಾಗಿರುವೆ, ಒಬ್ಬ ಮಗನನ್ನು ಹೆರುವೆ. ಅವನಿಗೆ, ಇಷ್ಮಾಯೇಲ್ ಎಂದು ಹೆಸರಿಡಬೇಕು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ನಿನ್ನ ವ್ಯಥೆಗೆ ಕಿವಿಗೊಟ್ಟಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ಅವನು ಕಾಡುಕತ್ತೆಯಂತೆ ಇರುವನು. ಪ್ರತಿಯೊಬ್ಬರಿಗೂ ವಿರೋಧವಾಗಿ ಅವನು ಕೈ ಎತ್ತುವನು, ಪ್ರತಿಯೊಬ್ಬರ ಕೈಯೂ ಅವನ ವಿರೋಧವಾಗಿ ಇರುವುದು. ಅವನು ತನ್ನ ಸಹೋದರರೆಲ್ಲರ ಎದುರಿನಲ್ಲಿ ವಾಸವಾಗಿರುವನು.” ");
INSERT INTO kanokcv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ಆಮೇಲೆ ಆಕೆಯು ತನ್ನ ಸಂಗಡ ಮಾತನಾಡಿದ ಯೆಹೋವ ದೇವರಿಗೆ, “ನೀವು ನನ್ನನ್ನು ನೋಡುವ ದೇವರು,” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಏಕೆಂದರೆ, “ನನ್ನನ್ನು ನೋಡುವ ದೇವರನ್ನು ನಾನು ಇಲ್ಲಿ ನೋಡಿದೆ,” ಎಂದುಕೊಂಡಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ಆದ್ದರಿಂದ ಆ ಬಾವಿಗೆ, ಬೇರ್ ಲಹೈರೋಯಿ ಎಂದು ಹೆಸರಾಯಿತು. ಅದು ಕಾದೇಶಿಗೂ ಬೆರೆದಿಗೂ ಮಧ್ಯದಲ್ಲಿ ಇದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ತರುವಾಯ ಹಾಗರಳು ಅಬ್ರಾಮನಿಗೆ ಮಗನನ್ನು ಹೆತ್ತಳು. ಹಾಗರಳ ಮಗನಿಗೆ ಅಬ್ರಾಮನು ಇಷ್ಮಾಯೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ಹಾಗರಳು ಅಬ್ರಾಮನಿಗೆ ಇಷ್ಮಾಯೇಲನನ್ನು ಹೆತ್ತಾಗ, ಅಬ್ರಾಮನು ಎಂಬತ್ತಾರು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ಅಬ್ರಾಮನು ತೊಂಬತ್ತೊಂಬತ್ತು ವರ್ಷದವನಾದಾಗ, ಯೆಹೋವ ದೇವರು ಅಬ್ರಾಮನಿಗೆ ಕಾಣಿಸಿಕೊಂಡು, “ನಾನೇ ಸರ್ವಶಕ್ತ ದೇವರು. ನೀನು ನನ್ನ ಸನ್ನಿಧಿಯಲ್ಲಿಯೇ ನಡೆಯುತ್ತಾ ದೋಷವಿಲ್ಲದವನಾಗಿರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ನನಗೂ ನಿನಗೂ ಮಧ್ಯದಲ್ಲಿ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡುವೆನು. ಇದಲ್ಲದೆ ನಿನ್ನನ್ನು ಅತ್ಯಧಿಕವಾಗಿ ವೃದ್ಧಿಪಡಿಸುವೆನು,” ಎಂದು ಅವನಿಗೆ ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ಆಗ ಅಬ್ರಾಮನು ಸಾಷ್ಟಾಂಗ ನಮಸ್ಕಾರಮಾಡಿದನು. ದೇವರು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ನಾನಾದರೋ ಈ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ನಿನ್ನ ಸಂಗಡ ಮಾಡಿದ್ದೇನೆ: ನೀನು ಅನೇಕ ರಾಷ್ಟ್ರಗಳಿಗೆ ತಂದೆಯಾಗಿರುವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ಇನ್ನು ಮುಂದೆ, ‘ಅಬ್ರಾಮ್’ ಎಂದು ನಿನಗೆ ಹೆಸರಿರುವುದಿಲ್ಲ. ನಿನ್ನ ಹೆಸರು, ‘ಅಬ್ರಹಾಮ’ ಎಂದು ಇರುವುದು. ಏಕೆಂದರೆ ನಾನು ನಿನ್ನನ್ನು ಅನೇಕ ಜನಾಂಗಗಳಿಗೆ ತಂದೆಯನ್ನಾಗಿ ಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ನಿನ್ನಿಂದ ಅನೇಕ ಜನಾಂಗಗಳೂ ಅರಸರೂ ಹುಟ್ಟುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ಇದಲ್ಲದೆ ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಗೂ ದೇವರಾಗಿರುವೆನು. ಈ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ನಿನಗೋಸ್ಕರವೂ ನಿನ್ನ ತರುವಾಯ ಬರುವ ನಿನ್ನ ಸಂತತಿಗೋಸ್ಕರವೂ ತಲತಲಾಂತರದವರೆಗೂ ನಿತ್ಯವಾದ ಒಡಂಬಡಿಕೆಯಾಗಿ ಸ್ಥಾಪಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ನೀನು ಪ್ರವಾಸಿಯಾಗಿರುವ ಕಾನಾನ್ ದೇಶವನ್ನೆಲ್ಲಾ ನಿನಗೂ ನಿನ್ನ ತರುವಾಯ ನಿನ್ನ ಸಂತತಿಗೂ ಶಾಶ್ವತವಾದ ಸ್ವತ್ತನ್ನಾಗಿ ಕೊಟ್ಟು, ನಾನು ಅವರಿಗೆ ದೇವರಾಗಿರುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ಇದಲ್ಲದೆ ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ, “ನೀನೂ, ನಿನ್ನ ತರುವಾಯ ಬರುವ ನಿನ್ನ ಸಂತತಿಯವರೂ ತಲತಲಾಂತರಕ್ಕೂ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಕೈಕೊಂಡು ನಡೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ನೀನೂ, ನಿನ್ನ ತರುವಾಯ ನಿನ್ನ ಸಂತತಿಯವರೂ ಕೈಕೊಳ್ಳಬೇಕಾದ ನನ್ನ ಒಡಂಬಡಿಕೆ ಯಾವುದೆಂದರೆ: ನಿಮ್ಮಲ್ಲಿರುವ ಗಂಡಸರೆಲ್ಲರಿಗೂ ಸುನ್ನತಿಯಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ನೀವು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳುವುದು, ನಿಮಗೂ ನನಗೂ ಉಂಟಾದ ಒಡಂಬಡಿಕೆಗೆ ಗುರುತಾಗಿ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ನಿಮ್ಮ ಸಂತತಿಯವರಲ್ಲಿ ಪ್ರತಿಯೊಂದು ಗಂಡು ಮಗುವಿಗೂ ಎಂಟು ದಿನಗಳಾದ ಮೇಲೆ ಸುನ್ನತಿ ಮಾಡಿಸಬೇಕು. ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವನಾಗಲಿ, ನಿನ್ನ ಸಂತತಿಯಲ್ಲದೆ ಪರರ ಮಕ್ಕಳಾಗಲಿ, ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡವನಾಗಲಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ಹೀಗೆ ನಿನ್ನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವನಿಗೂ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡವನಿಗೂ ಸುನ್ನತಿಯಾಗಬೇಕು. ಈ ನನ್ನ ಒಡಂಬಡಿಕೆಯು ನಿಮ್ಮ ಶರೀರದಲ್ಲಿ ನಿತ್ಯವಾದ ಒಡಂಬಡಿಕೆಯಾಗಿರುವುದನ್ನು ಸೂಚಿಸುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳದವನು ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಮೀರಿದ ಕಾರಣ, ಅವನನ್ನು ಜನರೊಳಗಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ, “ನಿನ್ನ ಹೆಂಡತಿ ಸಾರಯಳ ವಿಷಯದಲ್ಲಾದರೋ, ಆಕೆಯನ್ನು ಸಾರಯಳೆಂದು ಕರೆಯಬೇಡ, ಅವಳ ಹೆಸರು, ‘ಸಾರಾ.’ ");
INSERT INTO kanokcv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ಆಕೆಯನ್ನು ನಾನು ಆಶೀರ್ವದಿಸುತ್ತೇನೆ. ಆಕೆಯಿಂದ ನಿನಗೆ ಒಬ್ಬ ಮಗನನ್ನು ಸಹ ಕೊಡುತ್ತೇನೆ. ಆಕೆಯು ಜನಾಂಗಗಳ ತಾಯಿಯಾಗುವಂತೆ ಆಕೆಯನ್ನು ಆಶೀರ್ವದಿಸುತ್ತೇನೆ. ಆಕೆಯಿಂದ ರಾಷ್ಟ್ರಗಳೂ ಅರಸರೂ ಹುಟ್ಟುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ಅಬ್ರಹಾಮನು ಅಡ್ಡಬಿದ್ದು ನಕ್ಕು, “ನೂರು ವರ್ಷದವನಿಗೆ ಮಗುವು ಹುಟ್ಟುವುದುಂಟೇ? ತೊಂಬತ್ತು ವರ್ಷದವಳಾದ ಸಾರಳು ಹೆರುವುದುಂಟೋ?” ಎಂದು ತನ್ನ ಹೃದಯದಲ್ಲಿ ಅಂದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ಅಬ್ರಹಾಮನು ದೇವರಿಗೆ, “ಇಷ್ಮಾಯೇಲನು ನಿನ್ನ ಆಶೀರ್ವಾದದಲ್ಲಿ ಬದುಕಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ಅದಕ್ಕೆ ದೇವರು, “ನಿಶ್ಚಯವಾಗಿ ನಿನ್ನ ಹೆಂಡತಿ ಸಾರಳು ಮಗನನ್ನು ಹೆರುವಳು. ಅವನಿಗೆ, ‘ಇಸಾಕ್’ ಎಂದು ಹೆಸರಿಡಬೇಕು. ಅವನ ಸಂಗಡವೂ ಅವನ ತರುವಾಯ ಹುಟ್ಟುವ ಅವನ ಸಂತತಿಯವರ ಸಂಗಡವೂ ನಾನು ನನ್ನ ಶಾಶ್ವತವಾದ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಾಪಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ಇಷ್ಮಾಯೇಲನ ವಿಷಯದಲ್ಲಿ ನೀನು ಬೇಡಿದ್ದನ್ನು ಕೇಳಿದ್ದೇನೆ. ನಾನು ಅವನನ್ನು ಸಹ ಆಶೀರ್ವದಿಸುವೆನು. ಅವನನ್ನು ಅಭಿವೃದ್ಧಿ ಮಾಡಿ, ಅತ್ಯಧಿಕವಾಗಿ ಹೆಚ್ಚಿಸುವೆನು. ಅವನಿಂದ ಹನ್ನೆರಡು ಪ್ರಭುಗಳು ಹುಟ್ಟುವರು. ನಾನು ಅವನಿಂದ ದೊಡ್ಡ ಜನಾಂಗವಾಗುವಂತೆ ಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ಆದರೆ ಬರುವ ವರ್ಷ ಈ ಕಾಲದಲ್ಲಿ ಸಾರಳು ನಿನ್ನಿಂದ ಹೆರುವ ಇಸಾಕನ ಸಂಗಡ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಾಪಿಸವೆನು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ಆಗ ದೇವರು ಅವನ ಸಂಗಡ ಮಾತನಾಡುವುದನ್ನು ಮುಗಿಸಿ, ಅಬ್ರಹಾಮನ ಬಳಿಯಿಂದ ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ಅಬ್ರಹಾಮನು ತನ್ನ ಮಗ ಇಷ್ಮಾಯೇಲನಿಗೂ ತನ್ನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವರೆಲ್ಲರಿಗೂ ತಾನು ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡವರೆಲ್ಲರಿಗೂ ಹೀಗೆ ತನ್ನ ಮನೆಯಲ್ಲಿದ್ದ ಗಂಡಸರೆಲ್ಲರಿಗೂ ದೇವರು ತನಗೆ ಹೇಳಿದ ಹಾಗೆ, ಆ ದಿನವೇ ಸುನ್ನತಿ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ಅಬ್ರಹಾಮನಿಗೆ ಸುನ್ನತಿಯಾದಾಗ ಅವನು ತೊಂಬತ್ತೊಂಬತ್ತು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ಅವನ ಮಗ ಇಷ್ಮಾಯೇಲನಿಗೆ ಸುನ್ನತಿಯಾದಾಗ, ಅವನು ಹದಿಮೂರು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ಅಬ್ರಹಾಮನೂ ಅವನ ಮಗ ಇಷ್ಮಾಯೇಲನೂ ಅದೇ ದಿನದಲ್ಲಿ ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ಅವನ ಮನೆಯಲ್ಲಿದ್ದ ಗಂಡಸರೆಲ್ಲರಿಗೂ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವರಿಗೂ ಪರರಿಂದ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡವರಿಗೂ ಅವನ ಸಂಗಡವೇ ಸುನ್ನತಿ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ಯೆಹೋವ ದೇವರು ಮಮ್ರೆಯ ಮೈದಾನಗಳಲ್ಲಿ ಅಬ್ರಹಾಮನಿಗೆ ಕಾಣಿಸಿಕೊಂಡರು. ಹಗಲಿನ ಬಿಸಿಲಿನಲ್ಲಿ ಅವನು ಡೇರೆಯ ಬಾಗಿಲಿನಲ್ಲಿ ಕುಳಿತುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ಆಗ ತನ್ನ ಕಣ್ಣುಗಳನ್ನೆತ್ತಿ ನೋಡಲು, ಮೂವರು ಪುರುಷರು ಹತ್ತಿರದಲ್ಲಿ ನಿಂತಿದ್ದರು. ಅವನು ಅವರನ್ನು ಕಂಡು ಅವರಿಗೆ ಎದುರಾಗಿ ಡೇರೆಯ ಬಾಗಿಲಿನಿಂದ ಓಡಿಬಂದು ನೆಲದವರೆಗೂ ಬಗ್ಗಿ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ಅಬ್ರಹಾಮನು ಅವರಿಗೆ, “ನನ್ನ ಸ್ವಾಮಿ, ನಿಮ್ಮ ದೃಷ್ಟಿಯಲ್ಲಿ ನನಗೆ ದಯೆ ದೊರೆತಿದ್ದರೆ, ನಿಮ್ಮ ದಾಸನ ಬಳಿಯಿಂದ ಹೊರಟು ಹೋಗಬೇಡಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ಸ್ವಲ್ಪ ನೀರು ತೆಗೆದುಕೊಂಡು ಬರುತ್ತೇನೆ, ನಿಮ್ಮ ಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಿರಿ, ಮರದ ಕೆಳಗೆ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ನಾನು ಸ್ವಲ್ಪ ಆಹಾರವನ್ನು ತರುತ್ತೇನೆ. ತರುವಾಯ ನೀವು ಮುಂದೆ ಹೊರಟು ಹೋಗಬಹುದು. ನೀವು ನಿಮ್ಮ ದಾಸನ ಬಳಿಗೆ ಬಂದಿದ್ದೀರಿ,” ಎಂದು ಬೇಡಿಕೊಂಡನು. ಅದಕ್ಕೆ ಅವರು, “ನೀನು ಹೇಳಿದಂತೆಯೇ ಮಾಡು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ಆಗ ಅಬ್ರಹಾಮನು ತ್ವರೆಯಾಗಿ ಗುಡಾರದಲ್ಲಿದ್ದ ಸಾರಳ ಬಳಿಗೆ ಹೋಗಿ, “ಬೇಗನೇ ಮೂರು ಸೇರು ನಯವಾದ ಹಿಟ್ಟು ನಾದಿ, ಒಲೆಯ ಮೇಲೆ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ಅಬ್ರಹಾಮನು ದನದ ಮಂದೆಯ ಬಳಿಗೆ ಓಡಿಹೋಗಿ, ಒಳ್ಳೆಯ ಕರುವನ್ನು ತೆಗೆದುಕೊಂಡು ಒಬ್ಬ ಸೇವಕನಿಗೆ ಕೊಟ್ಟನು. ಆ ಸೇವಕನು ಬೇಗನೆ ಅಡಿಗೆಯನ್ನು ಸಿದ್ಧಪಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ತರುವಾಯ ಮೊಸರನ್ನೂ, ಹಾಲನ್ನೂ, ಪಕ್ವಮಾಡಿದ ಮಾಂಸವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಅವರ ಮುಂದೆ ಇಟ್ಟನು. ಅವನಾದರೋ ಮರದ ಕೆಳಗೆ ಅವರ ಹತ್ತರ ನಿಂತುಕೊಂಡನು. ಅವರು ಊಟಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ಅವರು ಅಬ್ರಹಾಮನಿಗೆ, “ನಿನ್ನ ಹೆಂಡತಿ ಸಾರಳು ಎಲ್ಲಿ?” ಎಂದು ಕೇಳಲು, ಅವನು, “ಇಗೋ, ಡೇರೆಯಲ್ಲಿದ್ದಾಳೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ಆಗ ಆ ಮೂವರಲ್ಲಿ ಒಬ್ಬರು, “ಬರುವ ವರ್ಷ ಇದೇ ಸಮಯದಲ್ಲಿ ನಾನು ನಿಶ್ಚಯವಾಗಿ ತಿರುಗಿ ನಿನ್ನ ಬಳಿಗೆ ಬರುವೆನು. ಆಗ ನಿನ್ನ ಹೆಂಡತಿ ಸಾರಳಿಗೆ ಒಬ್ಬ ಮಗನಿರುವನು,” ಎಂದನು. ಸಾರಳು ಅವರ ಹಿಂದೆ ಇದ್ದ ಡೇರೆಯ ಬಾಗಿಲಲ್ಲಿದ್ದು ಅದನ್ನು ಕೇಳಿಸಿಕೊಂಡಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ಅಬ್ರಹಾಮನೂ ಸಾರಳೂ ವಯಸ್ಸಾಗಿ, ಮುದುಕರಾಗಿದ್ದರು. ಸಾರಳಿಗೆ ಮಗುವನ್ನು ಹೆರುವ ಕಾಲ ಮುಗಿದು ಹೋಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ಆದ್ದರಿಂದ ಸಾರಳು ತನ್ನೊಳಗೆ ನಕ್ಕು, “ನಾನು ವೃದ್ಧಳಾಗಿದ್ದೇನೆ, ನನ್ನ ಯಜಮಾನನು ಸಹ ಮುದುಕನಾಗಿದ್ದಾನೆ. ಹೀಗಿರುವಲ್ಲಿ ನನ್ನಿಂದ ಮಗುವನ್ನು ಹೆರುವದಾದೀತೇ?” ಎಂದುಕೊಂಡಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ಆಗ ಯೆಹೋವ ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ, “ನಾನು ಮುದಿಪ್ರಾಯದವಳಾಗಿ ಮಗುವನ್ನು ಹೆರುವುದು ನಿಜವೋ? ಎಂದುಕೊಂಡು ಸಾರಳು ಏಕೆ ನಕ್ಕಳು? ");
INSERT INTO kanokcv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ಯೆಹೋವ ದೇವರಿಗೆ ಅಸಾಧ್ಯವಾದದ್ದು ಯಾವುದಾದರೂ ಇದೆಯೋ? ಬರುವ ವರ್ಷ ಇದೇ ಸಮಯದಲ್ಲಿ ನಾನು ತಿರುಗಿ ನಿನ್ನ ಬಳಿಗೆ ಬರುವೆನು. ಆಗ ಸಾರಳಿಗೆ ಒಬ್ಬ ಮಗನಿರುವನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ಆದರೆ ಸಾರಳು ಭಯಪಟ್ಟು, “ನಾನು ನಗಲಿಲ್ಲ,” ಎಂದು ಹೇಳಿ ಸುಳ್ಳಾಡಿದಾಗ, ದೇವರು, “ನೀನು ನಕ್ಕದ್ದು ನಿಜ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ತರುವಾಯ ಆ ಮನುಷ್ಯರು ಎದ್ದು ಅಲ್ಲಿಂದ ಸೊದೋಮಿನ ಕಡೆಗೆ ನೋಡಿದರು. ಅಬ್ರಹಾಮನು ಅವರನ್ನು ಕಳುಹಿಸಿಕೊಡುವುದಕ್ಕೆ ಅವರ ಸಂಗಡ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ಆಗ ಯೆಹೋವ ದೇವರು, “ನಾನು ಮಾಡುವುದನ್ನು ಅಬ್ರಹಾಮನಿಗೆ ಮರೆಮಾಡಲೋ? ");
INSERT INTO kanokcv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ಅಬ್ರಹಾಮನು ನಿಶ್ಚಯವಾಗಿ ಬಲವಾದ ದೊಡ್ಡ ಜನಾಂಗವಾಗುವನು, ಅವನ ಮೂಲಕ ಭೂಲೋಕದ ಎಲ್ಲಾ ಜನಾಂಗಗಳಿಗೂ ಆಶೀರ್ವಾದ ಉಂಟಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ಏಕೆಂದರೆ, ಅವನು ತನ್ನ ಮಕ್ಕಳಿಗೂ ಅವನ ತರುವಾಯ ಅವನ ಮನೆಯವರಿಗೂ ಯೆಹೋವ ದೇವರ ಮಾರ್ಗವನ್ನು ಕೈಗೊಂಡು, ನೀತಿ ನ್ಯಾಯಗಳನ್ನು ಅನುಸರಿಸಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸುವನು. ಆಗ ಯೆಹೋವ ದೇವರಾದ ನಾನು ಅಬ್ರಹಾಮನಿಗೆ ಹೇಳಿದ್ದು ನೆರವೇರುವದು,” ಎಂದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು, “ಸೊದೋಮ್ ಗೊಮೋರಗಳ ಕೂಗು ದೊಡ್ಡದಾಗಿದೆ. ಅವರ ಪಾಪವೂ ಘೋರವಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ನಾನು ಇಳಿದು ಹೋಗಿ ನನ್ನ ಬಳಿಗೆ ಬಂದ ಆ ಊರಿನವರ ಕೂಗಿನ ಪ್ರಕಾರವೇ, ಅವರು ಮಾಡಿದ್ದಾರೋ, ಇಲ್ಲವೋ, ಎಂದು ನೋಡಿ ತಿಳಿದುಕೊಳ್ಳುವೆನು,” ಎಂದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ಆ ಮನುಷ್ಯರು ಅಲ್ಲಿಂದ ತಮ್ಮ ಮುಖಗಳನ್ನು ತಿರುಗಿಸಿಕೊಂಡು, ಸೊದೋಮಿನ ಕಡೆಗೆ ಹೋದರು. ಆದರೆ ಅಬ್ರಹಾಮನು ಇನ್ನೂ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ನಿಂತುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ಆಗ ಅಬ್ರಹಾಮನು ಹತ್ತಿರ ಬಂದು, “ದುಷ್ಟರ ಜೊತೆ ನೀತಿವಂತರನ್ನೂ ನಾಶಮಾಡುವಿರೋ? ");
INSERT INTO kanokcv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ಒಂದು ವೇಳೆ ಆ ಪಟ್ಟಣದಲ್ಲಿ ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರಿದ್ದರೆ, ಅದರೊಳಗಿರುವ ಆ ಐವತ್ತು ನೀತಿವಂತರಿಗೋಸ್ಕರ ಆ ಸ್ಥಳವನ್ನು ಉಳಿಸದೆ ನಾಶಮಾಡುವಿರೋ? ");
INSERT INTO kanokcv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ಈ ರೀತಿಯಾಗಿ ನೀತಿವಂತರಿಗೂ ದುಷ್ಟರಿಗೂ ಭೇದ ಮಾಡದೆ, ನೀತಿವಂತರನ್ನು ದುಷ್ಟರ ಸಂಗಡ ಕೊಲ್ಲುವುದು ನಿಮ್ಮಿಂದ ಎಂದಿಗೂ ಆಗಬಾರದು. ಭೂಲೋಕಕ್ಕೆಲ್ಲಾ ನ್ಯಾಯಾಧಿಪತಿಯಾಗಿರುವ ತಾವು ನ್ಯಾಯವಾದದ್ದನ್ನೇ ಮಾಡಬೇಕಲ್ಲವೇ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ಅದಕ್ಕೆ ಯೆಹೋವ ದೇವರು, “ನನಗೆ ಸೊದೋಮ್ ಪಟ್ಟಣದೊಳಗೆ ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರು ಸಿಕ್ಕಿದರೆ, ಅವರಿಗೋಸ್ಕರ ಆ ಸ್ಥಳವನ್ನೆಲ್ಲಾ ಉಳಿಸುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ಆಗ ಅಬ್ರಹಾಮನು, “ಇಗೋ, ಮಣ್ಣೂ, ಬೂದಿಯೂ ಆಗಿರುವ ನಾನು ಯೆಹೋವ ದೇವರ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ಧೈರ್ಯಗೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ಒಂದು ವೇಳೆ ಐವತ್ತು ನೀತಿವಂತರಲ್ಲಿ ಐದು ಮಂದಿ ಕಡಿಮೆ ಇದ್ದರೆ, ಆ ಐದು ಮಂದಿ ಇಲ್ಲದ್ದರಿಂದ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವಿರೋ?” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕೆ ದೇವರು, “ನಲವತ್ತೈದು ಮಂದಿ ಅಲ್ಲಿ ಸಿಕ್ಕಿದರೆ ನಾನು ನಾಶಮಾಡುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ಅಬ್ರಹಾಮನು ದೇವರ ಸಂಗಡ ಇನ್ನೂ ಮಾತನಾಡಿ, “ಅಲ್ಲಿ ನಲವತ್ತು ಮಂದಿ ದೊರೆತರೆ, ಏನು ಮಾಡುವಿರಿ?” ಎನ್ನಲು, ಅದಕ್ಕೆ ದೇವರು, “ನಲವತ್ತು ಮಂದಿಗೋಸ್ಕರ ಅದನ್ನು ನಾನು ನಾಶಮಾಡುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ಅವನು, “ಯೆಹೋವ ದೇವರಿಗೆ ಕೋಪಬಾರದೆ ಇರಲಿ, ನಾನು ಮಾತನಾಡುತ್ತೇನೆ. ಒಂದು ವೇಳೆ ಅಲ್ಲಿ ಮೂವತ್ತು ಮಂದಿ ಇದ್ದರೆ,” ಎಂದಾಗ, ದೇವರು, “ನನಗೆ ಅಲ್ಲಿ ಮೂವತ್ತು ಮಂದಿ ಸಿಕ್ಕಿದರೆ, ನಾಶಮಾಡುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ಅವನು, “ಯೆಹೋವ ದೇವರ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ಬಂದಿದ್ದೇನೆ. ಒಂದು ವೇಳೆ ಇಪ್ಪತ್ತು ಮಂದಿ ಸಿಕ್ಕಿದರೆ ಏನು ಮಾಡುವಿರಿ?” ಎಂದನು. ಅದಕ್ಕೆ ದೇವರು, “ಇಪ್ಪತ್ತು ಮಂದಿಗೋಸ್ಕರ ನಾನು ಅದನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ಆಗ ಅವನು, “ಯೆಹೋವ ದೇವರೇ, ನಿಮಗೆ ಕೋಪಬಾರದೆ ಇರಲಿ. ಇನ್ನು ಒಂದೇ ಸಾರಿ ಮಾತನಾಡುತ್ತೇನೆ. ಒಂದು ವೇಳೆ ಅಲ್ಲಿ ಹತ್ತು ಮಂದಿ ಸಿಕ್ಕಿದರೆ,” ಎಂದಾಗ, ದೇವರು, “ಹತ್ತು ಮಂದಿಗೋಸ್ಕರ ನಾನು ಅದನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ಯೆಹೋವ ದೇವರು ಅಬ್ರಹಾಮನ ಸಂಗಡ ಮಾತನಾಡುವುದನ್ನು ಮುಗಿಸಿದ ಕೂಡಲೆ ಹೊರಟು ಹೋದರು. ಅಬ್ರಹಾಮನು ತನ್ನ ಮನೆಗೆ ಹಿಂದಿರುಗಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ದೂತರಿಬ್ಬರು ಸಾಯಂಕಾಲದಲ್ಲಿ ಸೊದೋಮಿಗೆ ಬಂದಾಗ, ಲೋಟನು ಸೊದೋಮಿನ ಬಾಗಿಲಲ್ಲಿ ಕುಳಿತಿದ್ದನು. ಲೋಟನು ಅವರನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಎದ್ದು ನೆಲದವರೆಗೆ ಬಾಗಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“ಸ್ವಾಮಿಗಳೇ, ನೀವು ನಿಮ್ಮ ದಾಸನ ಮನೆಯಲ್ಲಿ ತಂಗಿ, ರಾತ್ರಿ ಕಳೆಯಿರಿ. ನಿಮ್ಮ ಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಿರಿ. ಬೆಳಿಗ್ಗೆ ಎದ್ದು ನಿಮ್ಮ ಮಾರ್ಗವನ್ನು ಹಿಡಿದು ಹೋಗಬಹುದು,” ಎಂದು ಬೇಡಿಕೊಂಡನು. ಅದಕ್ಕೆ ಅವರು, “ಹಾಗಲ್ಲ, ನಾವು ರಾತ್ರಿಯೆಲ್ಲಾ ಬೀದಿಯಲ್ಲಿ ಇರುತ್ತೇವೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ಅದಕ್ಕವನು ಅವರನ್ನು ಬಹಳವಾಗಿ ಬಲವಂತ ಮಾಡಿದ್ದರಿಂದ, ಅವರು ತಿರುಗಿಬಂದು ಅವನ ಮನೆಯೊಳಕ್ಕೆ ಪ್ರವೇಶಿಸಿದರು. ಅವನು ಅವರಿಗಾಗಿ ಔತಣ ಮಾಡಿಸಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಸಿದ್ಧಮಾಡಿದನು. ಅವರು ಊಟಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ಆದರೆ ಅವರು ಮಲಗುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಸೊದೋಮ್ ಪಟ್ಟಣದ ಜನರು, ಹುಡುಗರು ಮೊದಲುಗೊಂಡು ಮುದುಕರವರೆಗೆ ಎಲ್ಲಾ ಜನರೂ ಪ್ರತಿಯೊಂದು ಮೂಲೆಯಿಂದ ಕೂಡಿ, ಮನೆಯನ್ನು ಸುತ್ತಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ಅವರು ಲೋಟನನ್ನು ಕರೆದು, “ಈ ರಾತ್ರಿಯಲ್ಲಿ ನಿನ್ನ ಬಳಿಗೆ ಬಂದ ಮನುಷ್ಯರು ಎಲ್ಲಿ? ಅವರನ್ನು ನಮ್ಮ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಾ, ಅವರೊಡನೆ ಸಂಭೋಗಿಸಬೇಕು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ಆಗ ಲೋಟನು ಅವರ ಬಳಿಗೆ ಬಂದು ಬಾಗಿಲನ್ನು ತನ್ನ ಹಿಂದೆ ಮುಚ್ಚಿಕೊಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“ನನ್ನ ಸಹೋದರರೇ, ಈ ದುಷ್ಟತನವನ್ನು ಮಾಡಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ಗಂಡಸರನ್ನು ಅರಿಯದ ಇಬ್ಬರು ಪುತ್ರಿಯರು ನನಗೆ ಇದ್ದಾರೆ. ಅವರನ್ನು ನಿಮ್ಮ ಬಳಿಗೆ ಕರೆ ತರುವೆನು. ನಿಮ್ಮ ದೃಷ್ಟಿಗೆ ಒಳ್ಳೆಯದೆಂದು ಕಾಣುವ ಹಾಗೆ ನೀವು ಅವರಿಗೆ ಮಾಡಿರಿ. ಆ ಮನುಷ್ಯರಿಗೆ ಮಾತ್ರ ಏನೂ ಮಾಡಬೇಡಿರಿ. ಏಕೆಂದರೆ ಅವರು ನನ್ನ ಮನೆಯ ಆಶ್ರಯಕ್ಕೆ ಬಂದಿದ್ದಾರೆ,” ಎಂದು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ಆದರೆ ಅವರು, “ಹಿಂದಕ್ಕೆ ಸರಿ,” ಎಂದು ಹೇಳಿ, “ಇವನು ಪ್ರವಾಸಿಯಾಗಿ ಬಂದು ನ್ಯಾಯಾಧಿಪತಿಯಾಗಲು ಯತ್ನಿಸುತ್ತಿದ್ದಾನೆ. ಈಗ ನಿನಗೆ ಅವರಿಗಿಂತ ಹೆಚ್ಚು ಕೇಡು ಮಾಡುತ್ತೇವೆ,” ಎಂದರು. ಅವರು ಲೋಟನನ್ನು ಬಲವಾಗಿ ತುಳಿದು, ಬಾಗಿಲನ್ನು ಮುರಿಯಲು ಸಮೀಪಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ಆಗ ಲೋಟನ ಮನೆಗೆ ಬಂದಿದ್ದ ಆ ದೂತರಿಬ್ಬರು ತಮ್ಮ ಕೈಯಿಂದ ಲೋಟನನ್ನು ತಮ್ಮ ಕಡೆಗೆ ಒಳಕ್ಕೆ ಎಳೆದುಕೊಂಡು ಬಾಗಿಲನ್ನು ಮುಚ್ಚಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ಬಾಗಿಲಲ್ಲಿದ್ದವರನ್ನು ಕಿರಿಯರಿಂದ ಹಿರಿಯರವರೆಗೆ ಕುರುಡಾಗುವಂತೆ ಮಾಡಿದರು. ಆಗ ಆ ಊರಿನವರು ಬಾಗಿಲನ್ನು ಕಂಡುಕೊಳ್ಳದೆ ಬೇಸರಗೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ಆ ದೂತರಿಬ್ಬರು ಲೋಟನಿಗೆ, “ಇಲ್ಲಿ ನಿನಗೆ ಇನ್ನೂ ಯಾರಾದರೂ ಇದ್ದಾರೋ? ನಿನ್ನ ಅಳಿಯಂದಿರನ್ನೂ, ನಿನ್ನ ಪುತ್ರರನ್ನೂ, ಪುತ್ರಿಯರನ್ನೂ, ಪಟ್ಟಣದಲ್ಲಿ ನಿನಗಿರುವ ಎಲ್ಲರನ್ನೂ ಈ ಸ್ಥಳದಿಂದ ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಾ. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ಏಕೆಂದರೆ ಈ ಸ್ಥಳದವರ ಕೂಗು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೊಡ್ಡದಾಗಿರುವುದರಿಂದ ನಾವು ಇದನ್ನು ನಾಶ ಮಾಡುತ್ತೇವೆ. ಯೆಹೋವ ದೇವರು ನಮ್ಮನ್ನು ಕಳುಹಿಸಿದ್ದಾರೆ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ಆಗ ಲೋಟನು ಹೊರಟುಹೋಗಿ, ತನ್ನ ಪುತ್ರಿಯರನ್ನು ಗೊತ್ತುಮಾಡಿದ್ದ ಅಳಿಯಂದಿರ ಸಂಗಡ ಮಾತನಾಡಿ, “ಎದ್ದು ಈ ಸ್ಥಳದಿಂದ ಹೊರಡಿರಿ. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ಈ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವುದಕ್ಕಿದ್ದಾರೆ,” ಎಂದನು. ಆದರೆ ಅವನು ತನ್ನ ಅಳಿಯಂದಿರಿಗೆ ಪರಿಹಾಸ್ಯಮಾಡುವಂತೆ ಕಾಣಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ಸೂರ್ಯೋದಯವಾಗುವ ಮೊದಲು ದೂತರು ಲೋಟನನ್ನು ತ್ವರೆಪಡಿಸಿ, “ಈ ಪಟ್ಟಣಕ್ಕೆ ಉಂಟಾಗುವ ದಂಡನೆಯಿಂದ ನೀನು ನಾಶವಾಗದ ಹಾಗೆ ಎದ್ದು ನಿನ್ನ ಹೆಂಡತಿಯನ್ನೂ ಇಲ್ಲಿರುವ ನಿನ್ನ ಪುತ್ರಿಯರನ್ನೂ ಕರೆದುಕೊಂಡು ನಡೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ಅವರು ತಡಮಾಡಿದಾಗ ಯೆಹೋವ ದೇವರು ಅವನನ್ನು ಕನಿಕರಿಸಿದ್ದರಿಂದ, ಆ ದೂತರು ಅವನ ಕೈಯನ್ನೂ, ಅವನ ಹೆಂಡತಿಯ ಕೈಯನ್ನೂ, ಅವನ ಇಬ್ಬರು ಪುತ್ರಿಯರ ಕೈಗಳನ್ನೂ ಹಿಡಿದು, ಅವರನ್ನು ಪಟ್ಟಣದ ಹೊರಗೆ ತಂದುಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ಅವರನ್ನು ಹೊರಗೆ ತಂದಮೇಲೆ ಅವರಲ್ಲಿ ಒಬ್ಬನು, “ಹಿಂದಕ್ಕೆ ನೋಡಬೇಡ. ಸುತ್ತಲಿರುವ ಯಾವ ಮೈದಾನದಲ್ಲಿಯೂ ನಿಂತುಕೊಳ್ಳಬೇಡ. ನೀನು ನಾಶವಾಗದ ಹಾಗೆ ತಪ್ಪಿಸಿಕೊಂಡು ಬೆಟ್ಟಕ್ಕೆ ಓಡಿಹೋಗು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ಅದಕ್ಕೆ ಲೋಟನು, “ಸ್ವಾಮಿ, ಅದು ನನ್ನಿಂದಾಗದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ಈಗ ನಿನ್ನ ದಾಸನಿಗೆ ನಿನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ದಯೆ ದೊರಕಿದೆ. ನನ್ನ ಪ್ರಾಣವನ್ನು ಉಳಿಸುವ ಹಾಗೆ ನೀನು ನನಗೆ ಮಾಡಿದ ದಯೆ ದೊಡ್ಡದು. ಆದರೆ ನಾನು ತಪ್ಪಿಸಿಕೊಂಡು ಬೆಟ್ಟಕ್ಕೆ ಓಡಿಹೋಗಲಾರೆನು, ನನಗೆ ವಿಪತ್ತು ಉಂಟಾಗಿ ಸತ್ತೇನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ಆ ಪಟ್ಟಣವನ್ನು ನೋಡಿರಿ. ನಾನು ಅಲ್ಲಿಗೆ ಓಡಿಹೋಗಲು ಸಮೀಪವಾಗಿದೆ ಮತ್ತು ಅದು ಸಣ್ಣದು. ನಾನು ತಪ್ಪಿಸಿಕೊಂಡು ಅಲ್ಲಿಗೆ ಹೋಗುತ್ತೇನೆ. ಇದರಿಂದ ನನ್ನ ಪ್ರಾಣವು ಉಳಿಯುವುದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ದೂತನು ಅವನಿಗೆ, “ಈ ವಿಷಯದಲ್ಲಿಯೂ ನಾನು ನಿನ್ನ ಬೇಡಿಕೆಯನ್ನು ಅಂಗೀಕರಿಸಿದ್ದೇನೆ. ನೋಡು, ನೀನು ಹೇಳಿದ ಆ ಊರನ್ನು ನಾನು ಕೆಡವಿ ಹಾಕುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ಬೇಗನೆ ತಪ್ಪಿಸಿಕೊಂಡು ಅಲ್ಲಿಗೆ ಹೋಗು, ಏಕೆಂದರೆ ನೀನು ಅಲ್ಲಿ ಸೇರುವ ತನಕ ನಾನೇನೂ ಮಾಡಲಾರೆನು,” ಎಂದನು. ಆದ್ದರಿಂದ ಆ ಊರಿಗೆ ಚೋಗರ್ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ಲೋಟನು ಚೋಗರಿಗೆ ಬಂದಾಗ ಸೂರ್ಯೋದಯವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ಆಗ ಯೆಹೋವ ದೇವರು ಸೊದೋಮ್ ಮತ್ತು ಗೊಮೋರದ ಮೇಲೆ ಗಂಧಕವನ್ನೂ, ಬೆಂಕಿಯನ್ನೂ ಆಕಾಶದಿಂದ ಸುರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ಹೀಗೆ ದೇವರು ಆ ಪಟ್ಟಣಗಳನ್ನೂ, ಅಲ್ಲಿಯ ಪ್ರದೇಶವನ್ನೂ, ಪಟ್ಟಣಗಳ ಎಲ್ಲಾ ನಿವಾಸಿಗಳನ್ನೂ, ಭೂಮಿಯ ಮೇಲೆ ಬೆಳೆದ ಬೆಳೆಯನ್ನೂ ಅಳಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ಆದರೆ ಲೋಟನ ಹಿಂದೆ ಬರುತ್ತಿದ್ದ ಅವನ ಹೆಂಡತಿಯು ಹಿಂದಿರುಗಿ ನೋಡಿ ಉಪ್ಪಿನ ಸ್ತಂಭವಾದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ಅಬ್ರಹಾಮನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು, ತಾನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಂತಿದ್ದ ಆ ಸ್ಥಳಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ಅವನು ಸೊದೋಮ್ ಗೊಮೋರಗಳ ಕಡೆಗೂ ಮೈದಾನದ ಎಲ್ಲಾ ಪ್ರದೇಶಗಳ ಕಡೆಗೂ ನೋಡಿದನು. ಆ ಪ್ರದೇಶದಿಂದ ಹೊಗೆಯು ಕುಲುಮೆಯ ಹೊಗೆಯಂತೆ ಏರುತ್ತಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ದೇವರು ಆ ಬಯಲುಸೀಮೆಯ ಪಟ್ಟಣಗಳನ್ನು ನಾಶಮಾಡಿದಾಗ, ಲೋಟನು ವಾಸವಾಗಿದ್ದ ಪಟ್ಟಣಗಳನ್ನು ನಾಶಮಾಡಿದರು. ಆದರೆ ಅಬ್ರಹಾಮನನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಂಡು, ಲೋಟನನ್ನು ಹೊರಗೆ ಕಳುಹಿಸಿ ಪಾರು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ಲೋಟನು ಚೋಗರಿನಲ್ಲಿ ವಾಸಿಸಲು ಭಯಪಟ್ಟು, ತನ್ನ ಇಬ್ಬರು ಪುತ್ರಿಯರ ಸಂಗಡ ಬೆಟ್ಟದ ಮೇಲೆ ಹೋಗಿ ವಾಸಮಾಡಿದನು. ಅಲ್ಲಿ ಅವನೂ ಅವನ ಇಬ್ಬರು ಪುತ್ರಿಯರೂ ಒಂದು ಗವಿಯಲ್ಲಿ ವಾಸವಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ಆಗ ಹಿರಿಯ ಮಗಳು ಚಿಕ್ಕವಳಿಗೆ, “ನಮ್ಮ ತಂದೆಯು ಮುದುಕನಾಗಿದ್ದಾನೆ. ಲೋಕದ ಎಲ್ಲಾ ಕ್ರಮದ ಪ್ರಕಾರ ನಮ್ಮೊಂದಿಗಿರಲು ನಮ್ಮ ಸುತ್ತಲಿನ ಪ್ರದೇಶದಲ್ಲಿ ಪುರುಷರಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ಆದ್ದರಿಂದ ನಾವು ನಮ್ಮ ತಂದೆಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸಿ, ನಾವು ಅವನ ಸಂಗಡ ಮಲಗಿಕೊಳ್ಳೋಣ. ಏಕೆಂದರೆ ನಾವು ನಮ್ಮ ತಂದೆಯ ಸಂತಾನವನ್ನು ಉಳಿಸಬೇಕು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ಆ ರಾತ್ರಿಯಲ್ಲಿ ಅವರು ತಮ್ಮ ತಂದೆಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸಿದರು. ಆಗ ಹಿರಿಯ ಮಗಳು ಬಂದು ತನ್ನ ತಂದೆಯ ಸಂಗಡ ಮಲಗಿಕೊಂಡಳು. ಅವಳು ಮಲಗಿಕೊಂಡದ್ದೂ, ಎದ್ದು ಹೋದದ್ದೂ ಅವನಿಗೆ ತಿಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ಮರುದಿನ ಹಿರಿಯವಳು ಚಿಕ್ಕವಳಿಗೆ, “ಕಳೆದ ರಾತ್ರಿ ತಂದೆಯ ಸಂಗಡ ನಾನು ಮಲಗಿಕೊಂಡೆನು. ಈ ರಾತ್ರಿಯಲ್ಲಿಯೂ ಅವನಿಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸಿ, ನೀನು ಹೋಗಿ ಅವನ ಸಂಗಡ ಮಲಗಿಕೋ. ಏಕೆಂದರೆ ನಾವು ನಮ್ಮ ತಂದೆಯ ಸಂತಾನವನ್ನು ಉಳಿಸಬೇಕು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ಹಾಗೆ ಆ ರಾತ್ರಿಯಲ್ಲಿಯೂ ತಮ್ಮ ತಂದೆಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸಿದರು. ಆಗ ಚಿಕ್ಕವಳು ಎದ್ದು, ಅವನ ಸಂಗಡ ಮಲಗಿಕೊಂಡಳು. ಅವಳು ಮಲಗಿಕೊಂಡದ್ದೂ, ಎದ್ದು ಹೋದದ್ದೂ ಅವನಿಗೆ ತಿಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ಈ ಪ್ರಕಾರ ಲೋಟನ ಇಬ್ಬರು ಪುತ್ರಿಯರು ತಮ್ಮ ತಂದೆಯಿಂದ ಗರ್ಭಿಣಿಯರಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ಹಿರಿಯ ಮಗಳು ಮಗನನ್ನು ಹೆತ್ತು, ಅವನಿಗೆ ಮೋವಾಬ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಈಗಿನ ಮೋವಾಬ್ಯರಿಗೂ ಇವನೇ ತಂದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ಚಿಕ್ಕವಳು ಸಹ ಮಗನನ್ನು ಹೆತ್ತು, ಅವನಿಗೆ ಬೆನಮ್ಮಿ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಈಗಿನ ಅಮ್ಮೋನಿಯರಿಗೂ ಇವನೇ ತಂದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ಅಬ್ರಹಾಮನು ಅಲ್ಲಿಂದ ನೆಗೆವ ಕಡೆಗೆ ಕಾದೇಶಿಗೆ ಪ್ರಯಾಣಮಾಡಿ, ಕಾದೇಶ್ ಹಾಗೂ ಶೂರಿನ ಮಧ್ಯದ ಗೆರಾರಿನಲ್ಲಿ ಸ್ವಲ್ಪಕಾಲ ಪ್ರವಾಸಿಯಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ಗೆರಾರಿನಲ್ಲಿ ಅಬ್ರಹಾಮನು ತನ್ನ ಹೆಂಡತಿ ಸಾರಳ ವಿಷಯವಾಗಿ, “ಅವಳು ನನ್ನ ತಂಗಿ,” ಎಂದು ಹೇಳಿದ್ದನು. ಆದ್ದರಿಂದ ಗೆರಾರಿನ ಅರಸ ಅಬೀಮೆಲೆಕನು ಸಾರಳನ್ನು ಕರೆಯಿಸಿ ತನ್ನ ಅರಮನೆಗೆ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ಆದರೆ ದೇವರು ಅಬೀಮೆಲೆಕನಿಗೆ ರಾತ್ರಿಯ ಕನಸಿನಲ್ಲಿ ಬಂದು, “ನೀನು ಆ ಸ್ರೀಯನ್ನು ತೆಗೆದುಕೊಂಡ ಕಾರಣ ಸಾಯತಕ್ಕವನಾಗಿದ್ದಿ, ಏಕೆಂದರೆ ಆಕೆಯು ಆ ಮನುಷ್ಯನ ಹೆಂಡತಿ,” ಎಂದು ಅವನಿಗೆ ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ಆದರೆ ಅಬೀಮೆಲೆಕನು ಆಕೆಯ ಸಮೀಪಕ್ಕೆ ಬಂದಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಅವನು, “ಪ್ರಭುವೇ, ನಿರಪರಾಧಿಯಾದ ಪ್ರಜೆಯನ್ನು ನೀವು ನಾಶಮಾಡುವಿರೋ? ");
INSERT INTO kanokcv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ಅವನು ನನಗೆ, ‘ಅವಳು ನನ್ನ ತಂಗಿ,’ ಎಂದು ಹೇಳಲಿಲ್ಲವೋ? ಅವಳೇ, ‘ಅವನು ನನ್ನ ಅಣ್ಣ,’ ಎಂದು ಹೇಳಿದ್ದಾಳೆ. ಆದ್ದರಿಂದ ನಾನು ಯಥಾರ್ಥವಾದ ಹೃದಯದಿಂದಲೂ ನಿರಪರಾಧದ ಹಸ್ತದಿಂದಲೂ ಇದನ್ನು ಮಾಡಿದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ಅದಕ್ಕೆ ದೇವರು ಕನಸಿನಲ್ಲಿ ಅವನಿಗೆ, “ಹೌದು, ನೀನು ಇದನ್ನು ಯಥಾರ್ಥವಾದ ಹೃದಯದಿಂದಲೇ ಮಾಡಿದ್ದೀಯೆ ಎಂದು ನನಗೂ ತಿಳಿದಿದೆ. ಆದ್ದರಿಂದ ನೀನು ನನಗೆ ವಿರೋಧವಾಗಿ ಪಾಪಮಾಡದಂತೆ ನಾನು ನಿನ್ನನ್ನು ತಡೆದು, ಆಕೆಯನ್ನು ಮುಟ್ಟಗೊಡಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ಈಗ ಆ ಮನುಷ್ಯನ ಹೆಂಡತಿಯನ್ನು ನೀನು ಹಿಂದಕ್ಕೆ ಕಳುಹಿಸಿಬಿಡು. ಏಕೆಂದರೆ ಅವನು ಪ್ರವಾದಿಯಾಗಿದ್ದಾನೆ. ನೀನು ಬದುಕುವಂತೆ ಅವನು ನಿನಗೋಸ್ಕರ ಪ್ರಾರ್ಥಿಸುವನು. ನೀನು ಆಕೆಯನ್ನು ಹಿಂದಕ್ಕೆ ಕಳುಹಿಸದಿದ್ದರೆ, ನೀನೂ ನಿನ್ನವರೆಲ್ಲರೂ ಖಂಡಿತವಾಗಿ ಸಾಯುವಿರಿ ಎಂದು ತಿಳಿದುಕೋ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ಅಬೀಮೆಲೆಕನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು, ತನ್ನ ಸೇವಕರೆಲ್ಲರನ್ನೂ ಕರೆದು, ಇವುಗಳನ್ನೆಲ್ಲಾ ಅವರಿಗೆ ಹೇಳಿದನು. ಅದಕ್ಕೆ ಆ ಮನುಷ್ಯರು ಬಹಳವಾಗಿ ಹೆದರಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನನ್ನು ಕರೆದು ಅವನಿಗೆ, “ನೀನು ನಮಗೆ ಮಾಡಿದ್ದೇನು? ನೀನು ನನ್ನ ಮೇಲೆಯೂ ನನ್ನ ರಾಜ್ಯದ ಮೇಲೆಯೂ ದೊಡ್ಡ ಪಾಪವನ್ನು ಬರಮಾಡುವಂತೆ ನಿನಗೆ ನಾನು ಏನು ಅಪರಾಧ ಮಾಡಿದ್ದೇನೆ? ನೀನು ನನಗೆ ಮಾಡಬಾರದ ಕೆಲಸಗಳನ್ನು ಮಾಡಿದ್ದೀಯೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ಇದಲ್ಲದೆ ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನಿಗೆ, “ನೀನು ಹೀಗೆ ಮಾಡಿದ ಕಾರಣವೇನು?” ಎಂದು ವಿಚಾರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ಅದಕ್ಕೆ ಅಬ್ರಹಾಮನು, “ಈ ಸ್ಥಳದಲ್ಲಿ ಖಂಡಿತವಾಗಿ ದೇವರ ಭಯವು ಇಲ್ಲವೆಂದೂ ನನ್ನ ಹೆಂಡತಿಗಾಗಿ ಅವರು ನನ್ನನ್ನು ಕೊಲ್ಲುವರೆಂದೂ ನಾನು ನೆನಸಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ಇದಲ್ಲದೆ ನಿಜವಾಗಿಯೂ ಅವಳು ನನ್ನ ತಂಗಿ, ಆದರೆ ನನ್ನ ತಾಯಿಯ ಮಗಳಲ್ಲ, ನನ್ನ ತಂದೆಯ ಮಗಳೇ, ನನಗೆ ಹೆಂಡತಿಯಾದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ದೇವರು ನನ್ನ ತಂದೆಯ ಮನೆಯೊಳಗಿಂದ ನನ್ನನ್ನು ದೇಶಾಂತರಕ್ಕೆ ಕರೆದಾಗ, ನಾನು ಅವಳಿಗೆ, ನೀನು ನನಗೆ ತೋರಿಸತಕ್ಕ ದಯೆಯು ಯಾವುದೆಂದರೆ, ನಾವು ಹೋಗುವ ಪ್ರತಿಯೊಂದು ಸ್ಥಳದಲ್ಲಿ ನನ್ನ ವಿಷಯವಾಗಿ, ‘ಇವನು ನನ್ನ ಅಣ್ಣ,’ ಎಂದು ಹೇಳು ಎಂದು ತಿಳಿಸಿದೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ಆಗ ಅಬೀಮೆಲೆಕನು ಕುರಿಗಳನ್ನೂ ಎತ್ತುಗಳನ್ನೂ ದಾಸರನ್ನೂ ದಾಸಿಯರನ್ನೂ ತೆಗೆದುಕೊಂಡು ಅಬ್ರಹಾಮನಿಗೆ ಕೊಟ್ಟು, ಅವನ ಹೆಂಡತಿ ಸಾರಳನ್ನು ಅವನಿಗೆ ಒಪ್ಪಿಸಿಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ಅಬೀಮೆಲೆಕನು, “ನನ್ನ ದೇಶವು ನಿನ್ನ ಮುಂದೆ ಇದೆ, ನಿನಗೆ ಇಷ್ಟವಾಗಿರುವ ಸ್ಥಳದಲ್ಲಿ ವಾಸಮಾಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ಸಾರಳಿಗೆ, “ನಿನ್ನ ಅಣ್ಣನಿಗೆ ಸಾವಿರ ಬೆಳ್ಳಿಯ ಹಣವನ್ನು ಕೊಟ್ಟಿದ್ದೇನೆ. ನೋಡು, ನಡೆದ ಘಟನೆಗೆ ಇದು ಪ್ರಾಯಶ್ಚಿತ್ತವಾಗಿದೆ. ನಿನ್ನ ಸಂಗಡ ಇರುವವರೆಲ್ಲರಿಗೂ ಉಳಿದವರೆಲ್ಲರಿಗೂ ನೀನು ನಿರ್ದೋಷಿಯೆಂದು ಇದು ಸಾಕ್ಷಿಯಾಗಿರಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ಆಗ ಅಬ್ರಹಾಮನು ದೇವರಿಗೆ ಪ್ರಾರ್ಥನೆಮಾಡಿದನು. ದೇವರು ಅಬೀಮೆಲೆಕನನ್ನೂ, ಅವನ ಹೆಂಡತಿಯನ್ನೂ ದಾಸಿಯರನ್ನೂ ವಾಸಿಮಾಡಿದರು. ಆದ್ದರಿಂದ ಅವರಿಗೆ ಮಕ್ಕಳಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ಅಬ್ರಹಾಮನ ಹೆಂಡತಿ ಸಾರಳ ನಿಮಿತ್ತ ಅಬೀಮೆಲೆಕನ ಮನೆಯಲ್ಲಿದ್ದ ಮಹಿಳೆಯರನ್ನು ಬಂಜೆಯರನ್ನಾಗಿ ಮಾಡಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ಯೆಹೋವ ದೇವರು ಸಾರಳಿಗೆ ವಾಗ್ದಾನ ಮಾಡಿದಂತೆ ಆಕೆಗೆ ದಯೆತೋರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ ಹೇಳಿದ ಸಮಯದಲ್ಲಿ ಅವನು ಮುದುಕನಾಗಿದ್ದಾಗ, ಸಾರಳು ಗರ್ಭಿಣಿಯಾಗಿ ಅವನಿಗೆ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ಅಬ್ರಹಾಮನು ತನಗೆ ಸಾರಳಲ್ಲಿ ಹುಟ್ಟಿದ ಮಗನಿಗೆ, ಇಸಾಕ, ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ದೇವರು ತನಗೆ ಅಪ್ಪಣೆಕೊಟ್ಟ ಹಾಗೆ ಅಬ್ರಹಾಮನು ತನ್ನ ಮಗ ಇಸಾಕನಿಗೆ ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಸುನ್ನತಿ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ಅಬ್ರಹಾಮನ ಮಗ ಇಸಾಕನು ಜನಿಸಿದಾಗ ಅವನು ನೂರು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ಆಗ ಸಾರಳು, “ದೇವರು ನನ್ನನ್ನು ನಗುವಂತೆ ಮಾಡಿದ್ದಾರೆ. ಹೀಗೆ ಕೇಳುವವರೆಲ್ಲರೂ ನನ್ನೊಂದಿಗೆ ನಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ಸಾರಳು ಮಕ್ಕಳಿಗೆ ಹಾಲು ಕುಡಿಸುವಳೆಂದು ಅಬ್ರಹಾಮನಿಗೆ ಯಾರು ಹೇಳುತ್ತಿದ್ದರು? ನಾನು ಅವನಿಗೆ ಮುದಿಪ್ರಾಯದಲ್ಲಿ ಮಗನನ್ನು ಹೆತ್ತೆನು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ಇಸಾಕನು ಬೆಳೆದು ಬಾಲಕನಾಗಿ ತಾಯಿಯ ಹಾಲು ಕುಡಿಯುವುದನ್ನು ಬಿಟ್ಟನು. ಆ ದಿನದಲ್ಲಿ ಅಬ್ರಹಾಮನು ದೊಡ್ಡ ಔತಣ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ಈಜಿಪ್ಟಿನವಳಾದ ಹಾಗರಳಿಗೆ ಅಬ್ರಹಾಮನಿಂದ ಜನಿಸಿದ ಮಗನು ಹಾಸ್ಯ ಮಾಡುವುದನ್ನು ಸಾರಳು ನೋಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ಅಬ್ರಹಾಮನಿಗೆ, “ಈ ದಾಸಿಯನ್ನೂ, ಅವಳ ಮಗನನ್ನೂ ಹೊರಗೆ ಹಾಕು. ಈ ದಾಸಿಯ ಮಗನು ನನ್ನ ಮಗ ಇಸಾಕನ ಸಂಗಡ ಬಾಧ್ಯನಾಗಬಾರದು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ಅಬ್ರಹಾಮನಿಗೆ ತನ್ನ ಮಗನ ದೆಸೆಯಿಂದ ಬಹು ದುಃಖವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ಆಗ ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ, “ಹುಡುಗನಿಗಾಗಿಯೂ, ನಿನ್ನ ದಾಸಿಗಾಗಿಯೂ ನೀನು ಚಿಂತಿಸಬೇಡ. ಸಾರಳು ನಿನಗೆ ಹೇಳಿದ್ದೆಲ್ಲವನ್ನು ಕೇಳು. ಏಕೆಂದರೆ ಇಸಾಕನಿಂದ ಹುಟ್ಟುವವರೇ ನಿನ್ನ ಸಂತತಿ ಎನಿಸಿಕೊಳ್ಳುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ದಾಸಿಯ ಮಗನೂ ನಿನ್ನ ಸಂತಾನವಾಗಿರುವುದರಿಂದ, ಅವನನ್ನೂ ನಾನು ಜನಾಂಗವಾಗಿ ಮಾಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ಅಬ್ರಹಾಮನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು ರೊಟ್ಟಿಯನ್ನೂ, ನೀರಿನ ತಿತ್ತಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹಾಗರಳಿಗೆ ಕೊಟ್ಟು, ಅವುಗಳನ್ನು ಆಕೆಯ ಹೆಗಲಿನ ಮೇಲೆ ಇರಿಸಿ, ಆ ಹುಡುಗನ ಸಂಗಡ ಅವಳನ್ನು ಕಳುಹಿಸಿಬಿಟ್ಟನು. ಆಕೆಯು ಹೋಗಿ ಬೇರ್ಷೆಬದ ಮರುಭೂಮಿಯಲ್ಲಿ ಅಲೆದಾಡುತ್ತಿದ್ದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ತಿತ್ತಿಯೊಳಗಿನ ನೀರು ಮುಗಿದಾಗ, ಆಕೆ ಮಗುವನ್ನು ಒಂದು ಮರದ ಕೆಳಗೆ ಮಲಗಿಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ಬಾಣವನ್ನೆಸೆಯುವಷ್ಟು ದೂರಹೋಗಿ ಕುಳಿತುಕೊಂಡು, “ಮಗುವಿನ ಸಾವನ್ನು ನಾನು ನೋಡಲಾರೆನು,” ಎಂದು ಹೇಳಿ ಸ್ವರವೆತ್ತಿ ಅತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ದೇವರು ಆ ಹುಡುಗನ ಅಳುವ ಸ್ವರವನ್ನು ಕೇಳಿದರು. ಆಗ ದೇವದೂತನು ಆಕಾಶದೊಳಗಿಂದ ಹಾಗರಳನ್ನು ಕರೆದು, ಆಕೆಗೆ, “ಹಾಗರಳೇ, ವ್ಯಥೆಪಡುವುದೇಕೆ? ಅಂಜಬೇಡ ದೇವರು ಹುಡುಗನ ಸ್ವರವನ್ನು ಕೇಳಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ಎದ್ದು ಹುಡುಗನನ್ನು ಎತ್ತಿಕೊಂಡು ನಿನ್ನ ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೋ. ನಾನು ಅವನನ್ನು ದೊಡ್ಡ ಜನಾಂಗದವನನ್ನಾಗಿ ಮಾಡುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ದೇವರು ಆಕೆಯ ಕಣ್ಣುಗಳನ್ನು ತೆರೆಯಲು, ಆಕೆಯು ನೀರಿನ ಬಾವಿಯನ್ನು ನೋಡಿದಳು. ಅಲ್ಲಿಗೆ ಹೋಗಿ ತಿತ್ತಿಯಲ್ಲಿ ನೀರನ್ನು ತುಂಬಿಸಿ, ಹುಡುಗನಿಗೆ ಕುಡಿಯಲು ಕೊಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ದೇವರು ಆ ಹುಡುಗನ ಸಂಗಡ ಇದ್ದರು. ಹುಡುಗನು ಬೆಳೆದು ಮರುಭೂಮಿಯಲ್ಲಿ ವಾಸಮಾಡಿ ಬಿಲ್ಲುಗಾರನಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ಇಷ್ಮಾಯೇಲನು ಪಾರಾನಿನ ಮರುಭೂಮಿಯಲ್ಲಿ ವಾಸಮಾಡುತ್ತಿದ್ದಾಗ, ಅವನ ತಾಯಿಯು ಅವನಿಗೋಸ್ಕರ ಈಜಿಪ್ಟ್ ದೇಶದ ಒಬ್ಬ ಹೆಣ್ಣನ್ನು ತರಿಸಿ ಮದುವೆಮಾಡಿಸಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ಆ ಕಾಲದಲ್ಲಿ ಅಬೀಮೆಲೆಕನೂ, ಅವನ ಮುಖ್ಯ ಸೈನ್ಯಾಧಿಪತಿಯಾದ ಫೀಕೋಲನೂ ಅಬ್ರಹಾಮನಿಗೆ, “ನೀನು ಮಾಡುವ ಎಲ್ಲಾ ಕೆಲಸಕಾರ್ಯಗಳಲ್ಲಿಯೂ ದೇವರು ನಿನ್ನ ಸಂಗಡ ಇದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ಆದ್ದರಿಂದ ನೀನು ನನಗೂ, ನನ್ನ ಮಗನಿಗೂ, ನನ್ನ ಮೊಮ್ಮಗನಿಗೂ ವಂಚನೆ ಮಾಡುವುದಿಲ್ಲವೆಂದು ದೇವರ ಮೇಲೆ ಆಣೆ ಇಟ್ಟು ಪ್ರಮಾಣಮಾಡು. ನಾನು ನಿನಗೆ ಒಳ್ಳೆಯದನ್ನೇ ಮಾಡಿದ ಪ್ರಕಾರ, ನೀನು ನನಗೂ, ನೀನು ವಾಸಮಾಡುತ್ತಿರುವ ಈ ದೇಶಕ್ಕೂ ಒಳ್ಳೆಯದನ್ನೇ ಮಾಡಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ಅದಕ್ಕೆ ಅಬ್ರಹಾಮನು, “ನಾನು ಹಾಗೆಯೇ ಪ್ರಮಾಣ ಮಾಡುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ಅಬೀಮೆಲೆಕನ ಸೇವಕರು ಬಲಾತ್ಕಾರದಿಂದ ತೆಗೆದುಕೊಂಡ ನೀರಿನ ಬಾವಿಗಾಗಿ ಅಬ್ರಹಾಮನು ಅಬೀಮೆಲೆಕನ ಮೇಲೆ ತಪ್ಪು ಹೊರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ಅದಕ್ಕೆ ಅಬೀಮೆಲೆಕನು, “ಈ ಕೆಲಸವನ್ನು ಯಾರು ಮಾಡಿದರೆಂದು ನಾನು ಅರಿಯೆ. ನೀನೂ ನನಗೆ ತಿಳಿಸಲಿಲ್ಲ. ನಾನು ಇಂದಿನವರೆಗೂ ಅದನ್ನು ಕೇಳಲೂ ಇಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ಆಗ ಅಬ್ರಹಾಮನು ಕುರಿಗಳನ್ನೂ, ಎತ್ತುಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಅಬೀಮೆಲೆಕನಿಗೆ ಕೊಟ್ಟನು. ಆಗ ಅವರಿಬ್ಬರೂ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ಅಬ್ರಹಾಮನು ಹಿಂಡಿನಿಂದ ಏಳು ಹೆಣ್ಣು ಕುರಿಮರಿಗಳನ್ನು ಬೇರೆ ಮಾಡಿ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನಿಗೆ, “ನೀನು ಆ ಏಳು ಹೆಣ್ಣು ಕುರಿಮರಿಗಳನ್ನು ಬೇರೆಯಾಗಿ ನಿಲ್ಲಿಸಿದ ಅರ್ಥ ಏನು?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ಅದಕ್ಕೆ ಅಬ್ರಹಾಮನು, “ನಾನೇ ಆ ಬಾವಿಯನ್ನು ಅಗೆದಿದ್ದೇನೆಂಬುದಕ್ಕೆ ಸಾಕ್ಷಿಯಾಗಿ ಆ ಏಳು ಹೆಣ್ಣು ಕುರಿಮರಿಗಳನ್ನು ನೀನು ನನ್ನ ಕೈಯಿಂದ ತೆಗೆದುಕೊಳ್ಳಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ಹೀಗೆ ಅವರಿಬ್ಬರೂ ಅಲ್ಲಿ ಪ್ರಮಾಣ ಮಾಡಿದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಬೇರ್ಷೆಬ ಎಂದು ಅಬ್ರಹಾಮನು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ಹೀಗೆ ಅವರು ಬೇರ್ಷೆಬದಲ್ಲಿ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡರು. ತರುವಾಯ ಅಬೀಮೆಲೆಕನೂ, ಅವನ ಮುಖ್ಯ ಸೈನ್ಯಾಧಿಪತಿ ಫೀಕೋಲನೂ ಎದ್ದು ಫಿಲಿಷ್ಟಿಯರ ದೇಶಕ್ಕೆ ಹಿಂದಿರುಗಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ಅಬ್ರಹಾಮನು ಬೇರ್ಷೆಬದಲ್ಲಿ ಪಿಚುಲ ವೃಕ್ಷವನ್ನು ನೆಟ್ಟು, ಅಲ್ಲಿ ನಿತ್ಯ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರ ಹೆಸರನ್ನು ಹೇಳಿ ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ಅಬ್ರಹಾಮನು ಫಿಲಿಷ್ಟಿಯರ ದೇಶದಲ್ಲಿ ಬಹುಕಾಲ ತಂಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ಕೆಲವು ಕಾಲದ ನಂತರ, ದೇವರು ಅಬ್ರಹಾಮನನ್ನು ಪರೀಕ್ಷಿಸುವುದಕ್ಕಾಗಿ ಅವನಿಗೆ, “ಅಬ್ರಹಾಮನೇ,” ಎಂದು ಕರೆದರು. ಅದಕ್ಕವನು, “ಇಗೋ, ಇಲ್ಲಿದ್ದೇನೆ,” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ಆಗ ದೇವರು, “ನೀನು ಪ್ರೀತಿ ಮಾಡುವ ನಿನ್ನ ಒಬ್ಬನೇ ಮಗ ಇಸಾಕನನ್ನು ಈಗ ತೆಗೆದುಕೊಂಡು, ಮೊರೀಯಾ ದೇಶಕ್ಕೆ ಹೋಗಿ, ಅಲ್ಲಿ ನಾನು ನಿನಗೆ ಹೇಳುವ ಒಂದು ಬೆಟ್ಟದ ಮೇಲೆ ಅವನನ್ನು ದಹನಬಲಿಯಾಗಿ ಅರ್ಪಿಸು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ಅಬ್ರಹಾಮನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು, ತನ್ನ ಕತ್ತೆಗೆ ತಡಿ ಕಟ್ಟಿ, ತನ್ನ ಸೇವಕರಲ್ಲಿ ಇಬ್ಬರನ್ನೂ, ತನ್ನ ಮಗ ಇಸಾಕನನ್ನೂ, ದಹನಬಲಿಗಳಿಗಾಗಿ ಕಟ್ಟಿಗೆಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು, ದೇವರು ತನಗೆ ಹೇಳಿದ ಸ್ಥಳಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ಮೂರನೆಯ ದಿನ ಅಬ್ರಹಾಮನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ, ಆ ಸ್ಥಳವು ದೂರದಲ್ಲಿ ಕಾಣಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ಅಬ್ರಹಾಮನು ತನ್ನ ಸೇವಕರಿಗೆ, “ಕತ್ತೆಯ ಸಂಗಡ ಇಲ್ಲಿಯೇ ಇರಿ. ನಾನೂ, ಹುಡುಗನೂ ಅಲ್ಲಿಗೆ ಹೋಗಿ, ಆರಾಧನೆ ಮಾಡಿ, ನಿಮ್ಮ ಬಳಿಗೆ ಹಿಂದಿರುಗಿ ಬರುತ್ತೇವೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ಅಬ್ರಹಾಮನು ದಹನಬಲಿಗಳ ಕಟ್ಟಿಗೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ತನ್ನ ಮಗ ಇಸಾಕನ ಮೇಲೆ ಹೊರಿಸಿ; ಬೆಂಕಿಯನ್ನೂ, ಕತ್ತಿಯನ್ನೂ ತನ್ನ ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡನು. ಅವರಿಬ್ಬರೂ ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ಇಸಾಕನು ತನ್ನ ತಂದೆ ಅಬ್ರಹಾಮನಿಗೆ, “ಅಪ್ಪಾ,” ಎಂದನು. ಆಗ ಅಬ್ರಹಾಮನು, “ಏನು ಮಗನೇ?” ಎಂದನು. ಅದಕ್ಕೆ ಅವನು, “ಇಗೋ, ಬೆಂಕಿಯೂ, ಕಟ್ಟಿಗೆಯೂ ಇವೆ, ಆದರೆ ದಹನಬಲಿಗೋಸ್ಕರ ಕುರಿಮರಿಯು ಎಲ್ಲಿ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ಅಬ್ರಹಾಮನು, “ನನ್ನ ಮಗನೇ, ದೇವರೇ ದಹನಬಲಿಗೋಸ್ಕರ ಕುರಿಮರಿಯನ್ನು ಒದಗಿಸುವರು,” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ಹೀಗೆ ಅವರಿಬ್ಬರೂ ಜೊತೆಯಲ್ಲಿ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ದೇವರು ಅವನಿಗೆ ಹೇಳಿದ ಸ್ಥಳಕ್ಕೆ ಬಂದಾಗ, ಅಬ್ರಹಾಮನು ಅಲ್ಲಿ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿ, ಕಟ್ಟಿಗೆಗಳನ್ನು ಅದರ ಮೇಲೆ ಕ್ರಮವಾಗಿ ಜೋಡಿಸಿ, ತನ್ನ ಮಗ ಇಸಾಕನನ್ನು ಕಟ್ಟಿ, ಬಲಿಪೀಠದ ಮೇಲೆ ಇದ್ದ ಕಟ್ಟಿಗೆಗಳ ಮೇಲೆ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ಅಬ್ರಹಾಮನು ಕೈಚಾಚಿ ತನ್ನ ಮಗನನ್ನು ಕೊಲ್ಲುವುದಕ್ಕೆ ಕತ್ತಿ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ಆಗ ಯೆಹೋವ ದೇವರ ದೂತನು ಆಕಾಶದೊಳಗಿಂದ, “ಅಬ್ರಹಾಮನೇ, ಅಬ್ರಹಾಮನೇ,” ಎಂದು ಅವನನ್ನು ಕರೆದನು. ಅವನು, “ಇಲ್ಲಿ ಇದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ಯೆಹೋವ ದೇವರ ದೂತನು ಅಬ್ರಹಾಮನಿಗೆ, “ಹುಡುಗನ ಮೇಲೆ ಕೈ ಹಾಕಬೇಡ; ಅವನಿಗೆ ಏನೂ ಮಾಡಬೇಡ; ಏಕೆಂದರೆ ನೀನು ದೇವರಿಗೆ ಭಯಪಡುತ್ತೀ ಎಂದು ಈಗ ನಾನು ತಿಳಿದಿದ್ದೇನೆ. ನೀನು ನಿನ್ನ ಒಬ್ಬನೇ ಮಗನನ್ನು ನನಗೆ ಅರ್ಪಿಸುವುದಕ್ಕೆ ಹಿಂಜರಿಯಲಿಲ್ಲ,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ಅಬ್ರಹಾಮನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ, ಅವನ ಹಿಂದೆ ಒಂದು ಟಗರು ಕೊಂಬುಗಳಿಂದ ಪೊದೆಯಲ್ಲಿ ಸಿಕ್ಕಿಕೊಂಡಿತ್ತು. ಅಬ್ರಹಾಮನು ಹೋಗಿ ಆ ಟಗರನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದನ್ನು ತನ್ನ ಮಗನಿಗೆ ಬದಲಾಗಿ ದಹನಬಲಿಯಾಗಿ ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ಅಬ್ರಹಾಮನು ಆ ಸ್ಥಳಕ್ಕೆ ಯೆಹೋವ ಯೀರೆ ಎಂದು ಹೆಸರಿಟ್ಟನು. “ಯೆಹೋವ ದೇವರು ಪರ್ವತದ ಮೇಲೆ ಒದಗಿಸುವರು,” ಎಂದು ಇಂದಿನವರೆಗೂ ಜನರು ಹೇಳುತ್ತಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ಯೆಹೋವ ದೇವರ ದೂತನು ಆಕಾಶದೊಳಗಿಂದ ಎರಡನೆಯ ಸಾರಿ ಅಬ್ರಹಾಮನನ್ನು ಕರೆದು ಅವನಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“ನೀನು ಈ ಕಾರ್ಯವನ್ನು ಮಾಡಿ, ನಿನ್ನ ಒಬ್ಬನೇ ಮಗನನ್ನು ಸಹ ನನಗೆ ಕೊಡುವುದಕ್ಕೆ ಹಿಂಜರಿಯದೆ ಇದ್ದುದರಿಂದ, ಯೆಹೋವ ದೇವರಾದ ನಾನು ನಿನಗೆ ಪ್ರಮಾಣವಾಗಿ ಹೇಳುವುದೇನಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ನಿಶ್ಚಯವಾಗಿ ನಾನು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸೇ ಆಶೀರ್ವದಿಸುವೆನು. ನಿನ್ನ ಸಂತಾನವನ್ನು ಆಕಾಶದ ನಕ್ಷತ್ರಗಳ ಹಾಗೆಯೂ ಸಮುದ್ರದ ತೀರದಲ್ಲಿರುವ ಮರಳಿನ ಹಾಗೆಯೂ ಹೆಚ್ಚಿಸುವೆನು. ನಿನ್ನ ಸಂತಾನದವರು ತಮ್ಮ ಶತ್ರುಗಳ ಪಟ್ಟಣಗಳನ್ನು ವಶಪಡಿಸಿಕೊಳ್ಳುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ನೀನು ನನಗೆ ವಿಧೇಯನಾದದ್ದರಿಂದ, ನಿನ್ನ ಸಂತತಿಯ ಮೂಲಕ ಭೂಲೋಕದ ಎಲ್ಲಾ ಜನಾಂಗಗಳಿಗೂ ಆಶೀರ್ವಾದ ಉಂಟಾಗುವುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ತರುವಾಯ ಅಬ್ರಹಾಮನು ತನ್ನ ಸೇವಕರ ಬಳಿಗೆ ಹಿಂದಿರುಗಿ ಬಂದನು. ಅವರೆಲ್ಲರೂ ಬೇರ್ಷೆಬಕ್ಕೆ ಹೋದರು. ಅಬ್ರಹಾಮನು ಬೇರ್ಷೆಬದಲ್ಲಿ ವಾಸಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ಕೆಲ ಸಮಯದ ನಂತರ ಕೆಲವರು ಅಬ್ರಹಾಮನಿಗೆ, “ಮಿಲ್ಕಾಳು ತಾಯಾಗಿದ್ದಾಳೆ. ನಿನ್ನ ಸಹೋದರ ನಾಹೋರನಿಗೆ ಅವಳು ಮಕ್ಕಳನ್ನು ಹೆತ್ತಿದ್ದಾಳೆ,” ಎಂದು ತಿಳಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ಅವರು ಯಾರೆಂದರೆ, ಅವನ ಚೊಚ್ಚಲು ಮಗ ಊಚ್, ಅವನ ಸಹೋದರ ಬೂಜ್, ಅರಾಮನ ತಂದೆ ಕೆಮೂಯೇಲ್, ");
INSERT INTO kanokcv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ಕೆಸೆದ್, ಹಜೋ, ಪಿಲ್ದಾಷ್, ಇದ್ಲಾಫ್, ಬೆತೂಯೇಲ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ಬೆತೂಯೇಲನಿಂದ ರೆಬೆಕ್ಕಳು ಹುಟ್ಟಿದಳು. ಈ ಎಂಟು ಮಂದಿಯನ್ನು ಮಿಲ್ಕಾಳು ಅಬ್ರಹಾಮನ ಸಹೋದರ ನಾಹೋರನಿಗೆ ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ಅವನ ಉಪಪತ್ನಿ ರೂಮಳೆಂಬವಳು ಸಹ ಟೆಬಹ, ಗಹಮ, ತಹಷ, ಮಾಕಾ ಎಂಬುವರನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ಸಾರಳು ನೂರಿಪ್ಪತ್ತೇಳು ವರ್ಷ ಬದುಕಿದ್ದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ಅವಳು ಕಾನಾನ್ ದೇಶದಲ್ಲಿರುವ ಹೆಬ್ರೋನಿನಲ್ಲಿ ಅಂದರೆ ಕಿರ್ಯತ್ ಅರ್ಬದಲ್ಲಿ ಮರಣಹೊಂದಿದಳು. ಅಬ್ರಹಾಮನು ಸಾರಳಿಗೋಸ್ಕರ ಗೋಳಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ಆಗ ಅಬ್ರಹಾಮನು ತನ್ನ ಹೆಂಡತಿಯ ಶವದ ಬಳಿಯಿಂದ ಎದ್ದು, ಹಿತ್ತಿಯರ ಬಳಿಗೆ ಬಂದು, ಅವರಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ನಾನು ನಿಮ್ಮೊಂದಿಗೆ ಪರದೇಶಸ್ಥನೂ, ಪರವಾಸಿಯೂ ಆಗಿದ್ದೇನೆ. ನನಗೆ ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ಸಮಾಧಿಯ ಸ್ಥಳವನ್ನು ಕೊಡಿರಿ. ಆಗ ನನ್ನ ಹೆಂಡತಿಯ ಶವವನ್ನು ಹೂಳಿಡುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ಹಿತ್ತಿಯರು ಅಬ್ರಹಾಮನಿಗೆ ಉತ್ತರಕೊಟ್ಟು, ");
INSERT INTO kanokcv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ಒಡೆಯಾ, ನಮ್ಮ ಮಾತನ್ನು ಕೇಳು, ನೀನು ನಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಮಹಾಪ್ರಭುವಾಗಿದ್ದೀ. ನಮ್ಮ ಸಮಾಧಿಗಳೊಳಗೆ ಉತ್ತಮವಾದದ್ದರಲ್ಲಿ ನಿನ್ನ ಹೆಂಡತಿಯ ಶವವನ್ನು ಹೂಳಿಡು. ನಮ್ಮಲ್ಲಿ ಯಾರೂ ನಿನಗೆ ಸಮಾಧಿಯನ್ನು ಕೊಡುವುದಿಲ್ಲ ಎಂದು ಹೇಳಲಾರರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ಆಗ ಅಬ್ರಹಾಮನು ಎದ್ದು, ಆ ದೇಶದ ಜನರಾದ ಹಿತ್ತಿಯರ ಮುಂದೆ ತಲೆಬಾಗಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ಅವರ ಸಂಗಡ ಮಾತನಾಡಿ, “ನಾನು ನನ್ನ ಹೆಂಡತಿಯ ಶವವನ್ನು ಹೂಳಿಡುವುದು ನಿಮ್ಮ ಮನಸ್ಸಿಗೆ ಸರಿಬಿದ್ದರೆ, ನನ್ನ ಮಾತು ಕೇಳಿ ಚೋಹರನ ಮಗ ಎಫ್ರೋನನನ್ನು ನನಗಾಗಿ ಬೇಡಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ಅವನು ತನ್ನ ಹೊಲದ ಅಂಚಿನಲ್ಲಿರುವ ಮಕ್ಪೇಲಾ ಗವಿಯನ್ನು ನನಗೆ ಕೊಡಲಿ. ಅವನು ಅದನ್ನು ತಕ್ಕ ಕ್ರಯಕ್ಕೆ ನಿಮ್ಮ ಎದುರಿನಲ್ಲಿ ನನಗೆ ಕೊಡಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ಆಗ ಅವರ ಮಧ್ಯದಲ್ಲಿ ಕುಳಿತುಕೊಂಡಿದ್ದ ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನನು ಪಟ್ಟಣದ ದ್ವಾರದ ಬಳಿಯಲ್ಲಿ ಕೂತಿದ್ದ ಎಲ್ಲಾ ಹಿತ್ತಿಯರು ಕೇಳುವಂತೆ ಅಬ್ರಹಾಮನಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ಒಡೆಯನೇ ಹಾಗಲ್ಲ, ನನ್ನ ಮಾತನ್ನು ಕೇಳು. ಆ ಹೊಲವನ್ನು ನಿನಗೆ ಕೊಡುತ್ತೇನೆ. ಅದರಲ್ಲಿರುವ ಗವಿಯನ್ನೂ ನಿನಗೆ ಕೊಡುತ್ತೇನೆ. ಅದನ್ನು ನನ್ನ ಜನರ ಎದುರಿನಲ್ಲಿ ನಿನಗೆ ಕೊಡುತ್ತೇನೆ. ನಿನ್ನ ಹೆಂಡತಿಯ ಶವವನ್ನು ಹೂಳಿಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ಆಗ ಅಬ್ರಹಾಮನು ದೇಶದ ಜನರ ಮುಂದೆ ತಲೆಬಾಗಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ದೇಶದ ಜನರು ಕೇಳುವಂತೆ ಎಫ್ರೋನನಿಗೆ, “ನೀನು ನನಗೆ ಕೊಡಬೇಕೆಂದಿದ್ದರೆ ನನ್ನ ಮಾತನ್ನು ಕೇಳು. ನಾನು ಹೊಲದ ಕ್ರಯವನ್ನು ಕೊಡುತ್ತೇನೆ. ಅದನ್ನು ನನ್ನಿಂದ ತೆಗೆದುಕೋ, ಆಗ ನನ್ನ ಹೆಂಡತಿಯ ಶವವನ್ನು ಅಲ್ಲಿ ಹೂಳಿಡುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ಎಫ್ರೋನನು ಅಬ್ರಹಾಮನಿಗೆ ಉತ್ತರವಾಗಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ನನ್ನ ಒಡೆಯನೇ, ನನ್ನ ಮಾತನ್ನು ಕೇಳು. ಆ ಭೂಮಿಯು ನಾನೂರು ಬೆಳ್ಳಿಯ ನಾಣ್ಯಗಳ ಬೆಲೆಯುಳ್ಳದ್ದು, ಈ ಕುರಿತು ನಮ್ಮೊಳಗೇ ವಾದವೇಕೆ? ನಿನ್ನ ಹೆಂಡತಿಯ ಶವವನ್ನು ಹೂಳಿಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ಅಬ್ರಹಾಮನು ಎಫ್ರೋನನ ಮಾತಿಗೆ ಒಪ್ಪಿಕೊಂಡು, ಎಫ್ರೋನನು ಹಿತ್ತಿಯರ ಎದುರಿನಲ್ಲಿ ಹೇಳಿದ ಬೆಲೆ ಅಂದರೆ, ವರ್ತಕರಲ್ಲಿ ನಡೆಯುವ ನಾನೂರು ಬೆಳ್ಳಿ ನಾಣ್ಯಗಳನ್ನು ತೂಕಮಾಡಿ ಅವನಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ಹೀಗೆ ಮಮ್ರೆಗೆ ಎದುರಾಗಿರುವ ಮಕ್ಪೇಲದಲ್ಲಿರುವ ಎಫ್ರೋನನ ಹೊಲವೂ, ಆ ಹೊಲದಲ್ಲಿರುವ ಗವಿಯೂ, ಆ ಹೊಲದ ಸುತ್ತಲೂ ಇರುವ ಎಲ್ಲಾ ಮರಗಳೂ, ");
INSERT INTO kanokcv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ಹಿತ್ತಿಯರ ಮುಂದೆಯೂ, ಅವರ ಪಟ್ಟಣದ ಹೆಬ್ಬಾಗಿಲಿನಲ್ಲಿ ಸೇರುವ ಎಲ್ಲರ ಮುಂದೆಯೂ ಅಬ್ರಹಾಮನ ಆಸ್ತಿಯೆಂದು ದೃಢವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ಇದಾದ ಮೇಲೆ ಅಬ್ರಹಾಮನು ತನ್ನ ಹೆಂಡತಿ ಸಾರಳನ್ನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಹೆಬ್ರೋನ್ ಎಂಬ ಮಮ್ರೆಗೆ ಎದುರಾಗಿರುವ ಮಕ್ಪೇಲ ಹೊಲದ ಗವಿಯಲ್ಲಿ ಹೂಳಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ಆ ಹೊಲವೂ, ಅದರಲ್ಲಿರುವ ಗವಿಯೂ ಹಿತ್ತಿಯರಿಂದ ಅಬ್ರಹಾಮನಿಗೆ ಸ್ವಂತ ಸಮಾಧಿ ಎಂದು ಸ್ಥಿರವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ಅಬ್ರಹಾಮನು ವೃದ್ಧನಾಗಿದ್ದನು. ಯೆಹೋವ ದೇವರು ಅಬ್ರಹಾಮನನ್ನು ಎಲ್ಲಾದರಲ್ಲಿಯೂ ಆಶೀರ್ವದಿಸಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ಅಬ್ರಹಾಮನು ತನಗೆ ಇದ್ದವುಗಳ ಮೇಲೆಲ್ಲಾ ಆಡಳಿತ ಮಾಡುವ ತನ್ನ ಮನೆಯ ಹಿರಿಯ ಸೇವಕನಿಗೆ, “ನಿನ್ನ ಕೈಯನ್ನು ನನ್ನ ತೊಡೆಯ ಕೆಳಗೆ ಇಡು, ");
INSERT INTO kanokcv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ನೀನು ನನ್ನ ಸುತ್ತಲೂ ವಾಸವಾಗಿರುವ ಕಾನಾನ್ಯರ ಪುತ್ರಿಯರೊಳಗಿಂದ ನನ್ನ ಮಗನಿಗೆ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ನನ್ನ ದೇಶಕ್ಕೂ, ಬಂಧುಗಳ ಬಳಿಗೂ ಹೋಗಿ ನನ್ನ ಮಗ ಇಸಾಕನಿಗೆ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಬರುತ್ತೇನೆಂದು ಪರಲೋಕದ ಮತ್ತು ಭೂಲೋಕದ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರ ಮೇಲೆ ನೀನು ನನಗೆ ಪ್ರಮಾಣಮಾಡಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ಆ ಸೇವಕನು ಅವನಿಗೆ, “ಒಂದು ವೇಳೆ ನನ್ನನ್ನು ಹಿಂಬಾಲಿಸಿ, ಈ ದೇಶಕ್ಕೆ ಬರಲು ಆ ಸ್ತ್ರೀಗೆ ಮನಸ್ಸಿಲ್ಲದೆ ಹೋದರೆ, ನೀನು ಬಿಟ್ಟುಬಂದ ದೇಶಕ್ಕೆ ನಿನ್ನ ಮಗನನ್ನು ತಿರುಗಿ ಕರೆದುಕೊಂಡು ಹೋಗಬೇಕೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ಅಬ್ರಹಾಮನು ಅವನಿಗೆ, “ನನ್ನ ಮಗನನ್ನು ತಿರುಗಿ ಅಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಹೋಗಬಾರದು, ");
INSERT INTO kanokcv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ನನ್ನ ತಂದೆಯ ಮನೆಯಿಂದಲೂ ಬಂಧುಗಳ ದೇಶದೊಳಗಿಂದಲೂ ನನ್ನನ್ನು ಹೊರಗೆ ಕರೆದು, ನನ್ನ ಸಂಗಡ ಮಾತನಾಡಿ, ‘ನಿನ್ನ ಸಂತಾನಕ್ಕೆ ಈ ದೇಶವನ್ನು ಕೊಡುವೆನು,’ ಎಂದು ನನಗೆ ಪ್ರಮಾಣ ಮಾಡಿದ ಪರಲೋಕದ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಅಲ್ಲಿಂದ ನನ್ನ ಮಗನಿಗೆ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳುವ ಹಾಗೆ, ತಮ್ಮ ದೂತನನ್ನು ನಿನ್ನ ಮುಂದೆ ಕಳುಹಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ಆದರೆ ನಿನ್ನನ್ನು ಹಿಂಬಾಲಿಸಿ ಬರುವುದಕ್ಕೆ ಆ ಸ್ತ್ರೀಗೆ ಮನಸ್ಸಿಲ್ಲದಿದ್ದರೆ, ನನಗೆ ಮಾಡಿದ ಆ ಪ್ರಮಾಣದಿಂದ ನೀನು ಬಿಡುಗಡೆಯಾಗಿರುವೆ. ಆದರೆ ನನ್ನ ಮಗನನ್ನು ಅಲ್ಲಿಗೆ ಮಾತ್ರ ತಿರುಗಿ ಕರೆದುಕೊಂಡು ಹೋಗಬಾರದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ಆಗ ಆ ಸೇವಕನು ತನ್ನ ಕೈಯನ್ನು ತನ್ನ ಯಜಮಾನನಾದ ಅಬ್ರಹಾಮನ ತೊಡೆಯ ಕೆಳಗೆ ಇಟ್ಟು, ಆ ವಿಷಯ ಬಗ್ಗೆ ಅವನಿಗೆ ಪ್ರಮಾಣ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ಆಗ ಆ ಸೇವಕನು ತನ್ನ ಯಜಮಾನನ ಒಂಟೆಗಳಲ್ಲಿ ಹತ್ತು ಒಂಟೆಗಳನ್ನೂ, ತನ್ನ ಯಜಮಾನನಿಂದ ಎಲ್ಲಾ ತರಹದ ವಸ್ತ್ರಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಅರಾಮ್ ನಹರೈಮಿಗೆ ಹೊರಟು, ನಾಹೋರನು ವಾಸವಾಗಿದ್ದ ಊರನ್ನು ಸೇರಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ಆಗ ಸ್ತ್ರೀಯರು ನೀರು ತರಲು ಬರುವ ಸಂಜೆಯ ಸಮಯವಾಗಿತ್ತು. ಅವನು ಪಟ್ಟಣದ ಹೊರಗೆ ನೀರಿನ ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ಒಂಟೆಗಳನ್ನು ಮಲಗಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ಆಗ ಅವನು, “ನನ್ನ ಯಜಮಾನನಾದ ಅಬ್ರಹಾಮನ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರೇ, ಈ ಹೊತ್ತು ನನಗೆ ಅನುಕೂಲವನ್ನು ಉಂಟುಮಾಡಿ, ನನ್ನ ಯಜಮಾನನಾದ ಅಬ್ರಹಾಮನಿಗೆ ದಯೆ ತೋರಿಸಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ನಾನು ನೀರಿನ ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ನಿಂತುಕೊಂಡಿದ್ದೇನೆ. ಊರಿನ ಜನರ ಪುತ್ರಿಯರು ನೀರು ಸೇದುವುದಕ್ಕೆ ಹೊರಗೆ ಬರುತ್ತಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ನಾನು ಯಾವ ಹುಡುಗಿಗೆ, ‘ನೀರು ಕುಡಿಯುವ ಹಾಗೆ ನಿನ್ನ ಕೊಡವನ್ನು ಇಳಿಸು,’ ಎಂದು ಕೇಳಿಕೊಂಡಾಗ, ‘ನೀನೂ ಕುಡಿ, ನಿನ್ನ ಒಂಟೆಗಳಿಗೆ ಸಹ ಕುಡಿಯುವುದಕ್ಕೆ ಕೊಡುತ್ತೇನೆ,’ ಎಂದು ಹೇಳುವಳೋ, ಆಕೆಯನ್ನೇ ನೀವು ನಿಮ್ಮ ಸೇವಕನಾದ ಇಸಾಕನಿಗೆ ನೇಮಕ ಮಾಡಿದ್ದೀರಿ ಮತ್ತು ಯಜಮಾನನಿಗೆ ದಯೆ ತೋರಿಸಿದ್ದೀರಿ, ಎಂದು ಇದರಿಂದ ನಾನು ತಿಳಿದುಕೊಳ್ಳುವೆನು,” ಎಂದು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ಅವನು ಹಾಗೆ ಹೇಳುವುದನ್ನು ಮುಗಿಸುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಅಬ್ರಹಾಮನ ಸಹೋದರನಾದ ನಾಹೋರನ ಹೆಂಡತಿಯಾಗಿರುವ ಮಿಲ್ಕಾಳ ಮಗ ಬೆತೂಯೇಲನಿಗೆ ಹುಟ್ಟಿದ ರೆಬೆಕ್ಕಳು ತನ್ನ ಕೊಡವನ್ನು ಹೆಗಲಿನ ಮೇಲೆ ಇಟ್ಟುಕೊಂಡು ಹೊರಗೆ ಬಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ಆ ಹುಡುಗಿಯು ನೋಡುವುದಕ್ಕೆ ಬಹು ಸುಂದರಿಯಾಗಿದ್ದಳು, ಮದುವೆಯಾಗದ ಕನ್ನಿಕೆಯಾಗಿದ್ದಳು. ಆಕೆಯು ಬಾವಿಯ ಬಳಿಗೆ ಹೋಗಿ, ತನ್ನ ಕೊಡವನ್ನು ತುಂಬಿಕೊಂಡು ಬಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ಆಗ ಸೇವಕನು ಅವಳೆದುರಿಗೆ ಓಡಿಹೋಗಿ, “ನಿನ್ನ ಕೊಡದೊಳಗಿಂದ ಸ್ವಲ್ಪ ನೀರು ನನಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ಕೊಡು,” ಎಂದು ಕೇಳಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ಅದಕ್ಕವಳು, “ನನ್ನ ಒಡೆಯನೇ, ಕುಡಿ,” ಎಂದು ಹೇಳಿ, ತ್ವರೆಯಾಗಿ ತನ್ನ ಕೊಡವನ್ನು ಕೈಯಿಂದ ಇಳಿಸಿ, ಅವನಿಗೆ ಕುಡಿಯಲು ಕೊಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ಅವನಿಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ಕೊಟ್ಟನಂತರ ಆಕೆಯು, “ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ಸಾಕಾಗುವಷ್ಟು ನೀರನ್ನು ಸೇದುತ್ತೇನೆ,” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ಆಕೆಯು ತ್ವರೆಪಟ್ಟು ತನ್ನ ಕೊಡದಲ್ಲಿದ್ದ ನೀರನ್ನು ತೊಟ್ಟಿಯಲ್ಲಿ ಹೊಯ್ದು, ತಿರುಗಿ ಸೇದುವುದಕ್ಕೆ ಬಾವಿಯ ಬಳಿಗೆ ಓಡಿ, ಅವನ ಎಲ್ಲಾ ಒಂಟೆಗಳಿಗೋಸ್ಕರ ನೀರನ್ನು ಸೇದಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ಆಗ ಯೆಹೋವ ದೇವರು ತನ್ನ ಪ್ರಯಾಣನ್ನು ಸಫಲ ಮಾಡಿದರೋ ಏನೋ, ಎಂದು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕೆ ಆ ಮನುಷ್ಯನು ಆಕೆಯನ್ನು ಗಮನಿಸುತ್ತಾ, ಆಶ್ಚರ್ಯಪಟ್ಟು ಮೌನವಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ಒಂಟೆಗಳು ನೀರು ಕುಡಿದಾದ ಮೇಲೆ, ಆ ಮನುಷ್ಯನು ಅರ್ಧ ತೊಲೆಯ ತೂಕದ ಚಿನ್ನದ ಮೂಗುತಿಯನ್ನು, ಹತ್ತು ತೊಲೆ ತೂಕದ ಎರಡು ಬಳೆಗಳನ್ನು ಆಕೆಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ಅನಂತರ, “ನೀನು ಯಾರ ಮಗಳು? ನನಗೆ ಹೇಳು. ನಿನ್ನ ತಂದೆಯ ಮನೆಯಲ್ಲಿ ಒಂದು ರಾತ್ರಿ ಕಳೆಯುವುದಕ್ಕೆ ನಮಗೆ ಸ್ಥಳವಿದೆಯೋ?” ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ಅದಕ್ಕೆ ಆಕೆಯು, “ನಾಹೋರನಿಗೆ ಮಿಲ್ಕಾಳು ಹೆತ್ತ ಬೆತೂಯೇಲನ ಮಗಳು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ಇದಲ್ಲದೆ ಆಕೆಯು ಅವನಿಗೆ, “ಹುಲ್ಲೂ, ಮೇವೂ ನಮ್ಮಲ್ಲಿ ಸಾಕಷ್ಟು ಇವೆ, ನೀವು ಒಂದು ರಾತ್ರಿ ಕಳೆಯುವುದಕ್ಕೆ ಸ್ಥಳವಿದೆ,” ಎಂದು ಅವನಿಗೆ ಹೇಳಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ಆಗ ಆ ಮನುಷ್ಯನು ತಲೆಬಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಅಡ್ಡಬಿದ್ದು ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ಇದಲ್ಲದೆ ಅವನು, “ನನ್ನ ಯಜಮಾನನಾದ ಅಬ್ರಹಾಮನ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಸ್ತುತಿಹೊಂದಲಿ. ಅವರು ನನ್ನ ಯಜಮಾನನನ್ನು ಕೈಬಿಡದೆ, ತಮ್ಮ ದಯೆಯನ್ನೂ, ನಂಬಿಗಸ್ತಿಕೆಯನ್ನೂ ತೋರಿಸಿದ್ದಾರೆ. ನಾನು ಮಾರ್ಗದಲ್ಲಿರುವಾಗ ಯೆಹೋವ ದೇವರು ನನ್ನನ್ನು ನನ್ನ ಯಜಮಾನನ ಸಹೋದರನ ಮನೆಗೇ ನಡೆಸಿದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ಆಗ ಆ ಹುಡುಗಿಯು ಓಡಿಹೋಗಿ ಈ ವಿಷಯಗಳನ್ನು ತನ್ನ ತಾಯಿಯ ಮನೆಯಲ್ಲಿದ್ದವರಿಗೆ ತಿಳಿಸಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ರೆಬೆಕ್ಕಳಿಗೆ ಲಾಬಾನನೆಂಬ ಸಹೋದರನಿದ್ದನು. ಬಾವಿಯ ಬಳಿಯಲ್ಲಿದ್ದ ಆ ಮನುಷ್ಯನ ಬಳಿಗೆ ಲಾಬಾನನು ಓಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ಅವನು ಮೂಗುತಿಯನ್ನೂ, ತನ್ನ ಸಹೋದರಿಯ ಕೈಗಳಲ್ಲಿದ್ದ ಬಳೆಗಳನ್ನೂ ಕಂಡು, ಆ ಮನುಷ್ಯನು ತನ್ನ ಬಳಿ ಹೀಗೆ ಮಾತನಾಡಿದನೆಂದು ಹೇಳಿದ ತನ್ನ ಸಹೋದರಿ ರೆಬೆಕ್ಕಳ ಮಾತುಗಳನ್ನು ಕೇಳಿ, ಆ ಮನುಷ್ಯನ ಬಳಿಗೆ ಬಂದನು. ಅವನು ಇನ್ನೂ ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ಒಂಟೆಗಳ ಹತ್ತಿರ ನಿಂತಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ಲಾಬಾನನು ಅವನಿಗೆ, “ಯೆಹೋವ ದೇವರಿಂದ ಆಶೀರ್ವಾದ ಪಡೆದವನೇ, ಒಳಗೆ ಬಾ, ಏಕೆ ಹೊರಗೆ ನಿಂತಿರುವೆ? ನಾನು ಮನೆಯನ್ನೂ, ಒಂಟೆಗಳಿಗೆ ಸ್ಥಳವನ್ನೂ ಸಿದ್ಧಮಾಡಿದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ಆಗ ಆ ಮನುಷ್ಯನು ಮನೆಗೆ ಬಂದನು. ಅವನು ಒಂಟೆಗಳನ್ನು ಬಿಚ್ಚಿ, ಅವುಗಳಿಗೆ ಹುಲ್ಲನ್ನೂ, ಮೇವನ್ನೂ ಕೊಟ್ಟನು. ಅವನ ಕಾಲುಗಳನ್ನೂ, ಅವನ ಸಂಗಡ ಇದ್ದ ಮನುಷ್ಯರ ಕಾಲುಗಳನ್ನೂ ತೊಳೆಯುವುದಕ್ಕೆ ನೀರನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ಅವನಿಗೆ ಊಟಕ್ಕೆ ಬಡಿಸಿದಾಗ, ಅವನು, “ನಾನು ಬಂದ ಕೆಲಸದ ವಿಷಯ ಹೇಳದೆ ಊಟಮಾಡುವುದಿಲ್ಲ,” ಎಂದನು. ಅದಕ್ಕೆ ಲಾಬಾನನು, “ಹೇಳು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ಅವನು, “ನಾನು ಅಬ್ರಹಾಮನ ಸೇವಕನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ಯೆಹೋವ ದೇವರು ನನ್ನ ಯಜಮಾನನನ್ನು ಬಹಳವಾಗಿ ಆಶೀರ್ವದಿಸಿದ್ದರಿಂದ ಅವನು ಧನವಂತನಾದನು. ದೇವರು ಅವನಿಗೆ ಕುರಿದನ, ಬೆಳ್ಳಿಬಂಗಾರ, ದಾಸದಾಸಿ, ಒಂಟೆಗಳು ಮತ್ತು ಕತ್ತೆಗಳನ್ನು ಕೊಟ್ಟಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ಇದಲ್ಲದೆ ನನ್ನ ಯಜಮಾನನ ಹೆಂಡತಿ ಸಾರಳು ಮುದಿಪ್ರಾಯದಲ್ಲಿ ನನ್ನ ಯಜಮಾನನಿಗೆ ಮಗನನ್ನು ಹೆತ್ತಿದ್ದಾಳೆ. ಇವನು ತನಗಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ಅವನಿಗೆ ಕೊಟ್ಟಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ನನ್ನ ಯಜಮಾನನು, ‘ನಾನು ಯಾರ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡುತ್ತೇನೋ, ಆ ಕಾನಾನ್ಯರ ಪುತ್ರಿಯರಲ್ಲಿ ನನ್ನ ಮಗನಿಗೆ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ಆದರೆ ನೀನು ನನ್ನ ತಂದೆಯ ಮನೆಗೂ, ನನ್ನ ಬಂಧುಗಳ ಬಳಿಗೂ ಹೋಗಿ, ನನ್ನ ಮಗನಿಗೆ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕೆಂದು,’ ನನ್ನಿಂದ ಪ್ರಮಾಣ ಮಾಡಿಸಿಕೊಂಡಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“ನಾನು ನನ್ನ ಯಜಮಾನನಿಗೆ, ‘ಒಂದು ವೇಳೆ ಆ ಸ್ತ್ರೀ ನನ್ನನ್ನು ಹಿಂಬಾಲಿಸದೆ ಹೋದಾಳು,’ ಹೇಳಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“ಅವನು ನನಗೆ, ‘ನಾನು ಯಾರ ಮುಂದೆ ನಂಬಿಗಸ್ತಿಕೆಯಿಂದ ನಡೆದುಕೊಳ್ಳುತ್ತೇನೋ, ಆ ಯೆಹೋವ ದೇವರು ತಮ್ಮ ದೂತನನ್ನು ನಿನ್ನ ಸಂಗಡ ಕಳುಹಿಸಿ, ನೀನು ನನ್ನ ಬಂಧುಗಳಿಂದಲೂ ನನ್ನ ತಂದೆಯ ಮನೆಯೊಳಗಿಂದಲೂ ನನ್ನ ಮಗನಿಗೋಸ್ಕರ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳುವ ಹಾಗೆ ನಿನ್ನ ಪ್ರಯತ್ನವನ್ನು ಸಫಲಮಾಡುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ನೀನು ನನ್ನ ಬಂಧುಗಳ ಬಳಿಗೆ ಬಂದಾಗ, ಅವರು ನಿನಗೆ ಆ ಹುಡುಗಿಯನ್ನು ಕೊಡದೆ ಹೋದರೆ, ನಾನು ಮಾಡಿಸಿದ ಪ್ರಮಾಣದಿಂದ ಬಿಡುಗಡೆಯಾಗಿರುವೆ,’ ” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“ಈ ದಿನ ನಾನು ಆ ಬಾವಿಯ ಬಳಿಗೆ ಬಂದಾಗ, ‘ನನ್ನ ಯಜಮಾನನಾದ ಅಬ್ರಹಾಮನ ದೇವರಾದ ಯೆಹೋವ ದೇವರೇ, ನೀವು ಬಯಸಿದರೆ, ದಯವಿಟ್ಟು ನಾನು ಬಂದ ಪ್ರಯಾಣಕ್ಕೆ ನೀವು ಸಫಲ ಮಾಡಿದ್ದಾದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ಇಗೋ, ನಾನು ಈಗ ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ನಿಂತಿದ್ದೇನೆ. ಯಾವ ಹುಡುಗಿ ನೀರು ಸೇದುವುದಕ್ಕೆ ಹೊರಗೆ ಬರುತ್ತಾಳೋ, ನಾನು ಆಕೆಗೆ, “ನಿನ್ನ ಕೊಡದೊಳಗಿಂದ ನನಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ಸ್ವಲ್ಪ ನೀರು ಕೊಡು,” ಎಂದು ಕೇಳಿದಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ಆಕೆಯು ನನಗೆ, “ನೀನೂ ಕುಡಿ, ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ಸೇದಿ ಹಾಕುತ್ತೇನೆ,” ಎಂದು ನನಗೆ ಹೇಳಿದರೆ, ಆಕೆಯೇ ಯೆಹೋವ ದೇವರಿಂದ ನನ್ನ ಯಜಮಾನನ ಮಗನಿಗೆ ನೇಮಕವಾದ ಹೆಂಡತಿಯಾಗಿರಲಿ,’ ಎಂದುಕೊಂಡೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“ನಾನು ನನ್ನ ಹೃದಯದಲ್ಲಿ ಹಾಗೆ ಅಂದುಕೊಂಡು ಮುಗಿಸುವುದರೊಳಗಾಗಿ, ರೆಬೆಕ್ಕಳು ತನ್ನ ಹೆಗಲಿನ ಮೇಲೆ ಕೊಡವನ್ನಿಟ್ಟುಕೊಂಡು ಹೊರಗೆ ಬಂದಳು. ಆಕೆಯು ಬಾವಿಯಿಂದ ನೀರನ್ನು ಸೇದಿದಳು. ಆಗ ನಾನು, ‘ನನಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ಕೊಡು,’ ಎಂದು ಆಕೆಯನ್ನು ಕೇಳಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“ಅದಕ್ಕೆ ಆಕೆಯು ತ್ವರೆಪಟ್ಟು, ತನ್ನ ಹೆಗಲಿನ ಮೇಲಿನಿಂದ ಕೊಡವನ್ನು ಇಳಿಸಿ, ‘ನೀನು ಕುಡಿ ಮತ್ತು ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ನೀರು ತಂದುಕೊಡುತ್ತೇನೆ,’ ಎಂದಳು. ಆಗ ನಾನು ಕುಡಿದೆನು, ಆಕೆಯು ಒಂಟೆಗಳಿಗೂ ನೀರನ್ನು ತಂದುಕೊಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“ನಾನು ಆಕೆಗೆ, ‘ನೀನು ಯಾರ ಮಗಳು?’ ಎಂದು ಕೇಳಿದೆನು. “ಅದಕ್ಕವಳು, ‘ನಾಹೋರನಿಗೆ ಮಿಲ್ಕಾಳು ಹೆತ್ತ ಮಗನಾದ ಬೆತೂಯೇಲನ ಮಗಳು,’ ಎಂದಳು. “ಆಗ ನಾನು ಆಕೆಗೆ ಮೂಗುತಿಯನ್ನೂ, ಆಕೆಯ ಕೈಗಳಿಗೆ ಬಳೆಗಳನ್ನೂ ಕೊಟ್ಟು, ");
INSERT INTO kanokcv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ತಲೆಬಾಗಿ ಯೆಹೋವ ದೇವರನ್ನು ಆರಾಧಿಸಿ, ನನ್ನ ಯಜಮಾನನ ಸಹೋದರನ ಮಗಳನ್ನು ಅವನ ಮಗನಿಗೆ ಹೆಂಡತಿಯಾಗಿ ತೆಗೆದುಕೊಳ್ಳುವುದಕ್ಕೆ ನನ್ನನ್ನು ಸರಿಯಾದ ಮಾರ್ಗದಲ್ಲಿ ನಡೆಸಿದ ನನ್ನ ಯಜಮಾನನಾದ ಅಬ್ರಹಾಮನ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರನ್ನು ಕೊಂಡಾಡಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ಆದ್ದರಿಂದ ನೀವು ನನ್ನ ಯಜಮಾನನಿಗೆ ದಯೆಯಿಂದಲೂ ನಂಬಿಗಸ್ತಿಕೆಯಿಂದಲೂ ವರ್ತಿಸುವುದಾದರೆ ನನಗೆ ತಿಳಿಸಿರಿ. ಇಲ್ಲದಿದ್ದರೂ ನನಗೆ ತಿಳಿಸಿರಿ. ಆಗ ನಾನು ಬಲಗಡೆಯಾದರೂ, ಎಡಗಡೆಯಾದರೂ ತಿರುಗಿಕೊಂಡುಹೋಗುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ಅದಕ್ಕೆ ಲಾಬಾನನು ಮತ್ತು ಬೆತೂಯೇಲನು, “ಈ ಕಾರ್ಯವು ಯೆಹೋವ ದೇವರಿಂದಲೇ ಉಂಟಾಯಿತು. ನಾವಂತೂ ಹೌದೆಂದೂ ಅಲ್ಲವೆಂದೂ ಹೇಳಲಾರೆವು ");
INSERT INTO kanokcv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ರೆಬೆಕ್ಕಳನ್ನು ನಿನ್ನ ವಶಕ್ಕೆ ಕೊಡುತ್ತೇವೆ; ಕರೆದುಕೊಂಡು ಹೋಗಬಹುದು; ಯೆಹೋವ ದೇವರು ಹೇಳಿದಂತೆಯೇ ಆಕೆ ನಿನ್ನೊಡೆಯನ ಮಗನಿಗೆ ಹೆಂಡತಿಯಾಗಲಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ಅಬ್ರಹಾಮನ ಸೇವಕನು ಅವರ ಮಾತನ್ನು ಕೇಳಿದಾಗ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಅಡ್ಡಬಿದ್ದು, ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ಅವನು ಬೆಳ್ಳಿಯ ಒಡವೆ, ಬಂಗಾರದ ಒಡವೆ, ವಸ್ತ್ರಗಳನ್ನೂ ತಂದು, ರೆಬೆಕ್ಕಳಿಗೆ ಕೊಟ್ಟನು. ಆಕೆಯ ಸಹೋದರನಿಗೂ, ಆಕೆಯ ತಾಯಿಗೂ ಅಮೂಲ್ಯವಾದ ಉಡುಗೊರೆಗಳನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ತರುವಾಯ ಅವನೂ, ಅವನ ಸಂಗಡ ಇದ್ದ ಜನರೂ ಊಟಮಾಡಿ, ಕುಡಿದು, ರಾತ್ರಿಯನ್ನು ಅಲ್ಲೇ ಕಳೆದರು. ಬೆಳಿಗ್ಗೆ ಎದ್ದ ಮೇಲೆ ಅವನು, “ನನ್ನನ್ನು ನನ್ನ ಯಜಮಾನನ ಬಳಿಗೆ ಕಳುಹಿಸಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ಅದಕ್ಕೆ ಆಕೆಯ ಸಹೋದರನೂ, ತಾಯಿಯೂ, “ಹುಡುಗಿಯು ಕೆಲವು ದಿನ ಇರಲಿ. ಹತ್ತು ದಿನಗಳಾದರೂ ನಮ್ಮ ಬಳಿಯಲ್ಲಿ ಇದ್ದು ತರುವಾಯ ಹೋಗಲಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ಆಗ ಅವನು ಅವರಿಗೆ, “ನನ್ನನ್ನು ತಡೆಯಬೇಡಿರಿ, ಯೆಹೋವ ದೇವರು ನನ್ನ ಮಾರ್ಗವನ್ನು ಸಫಲ ಮಾಡಿದ್ದಾರಲ್ಲಾ. ನನ್ನ ಯಜಮಾನನ ಬಳಿಗೆ ಹೋಗುವಂತೆ ನನ್ನನ್ನು ಕಳುಹಿಸಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ಆಗ ಅವರು, “ನಾವು ಹುಡುಗಿಯನ್ನು ಕರೆದು, ಆಕೆಯ ಅಭಿಪ್ರಾಯವನ್ನು ವಿಚಾರಿಸೋಣ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ಅವರು ರೆಬೆಕ್ಕಳನ್ನು ಕರೆದು ಆಕೆಗೆ, “ಈ ಮನುಷ್ಯನ ಸಂಗಡ ಹೋಗುತ್ತೀಯಾ?” ಎಂದು ಕೇಳಿದರು. ಅದಕ್ಕೆ ಆಕೆಯು, “ನಾನು ಹೋಗುತ್ತೇನೆ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ಆಗ ಅವರು ತಮ್ಮ ಸಹೋದರಿಯಾದ ರೆಬೆಕ್ಕಳನ್ನೂ ಅವಳ ದಾದಿಯನ್ನೂ ಅಬ್ರಹಾಮನ ಸೇವಕನನ್ನೂ ಅವನ ಜೊತೆಯಲ್ಲಿದ್ದ ಮನುಷ್ಯರನ್ನೂ ಸಾಗಕಳುಹಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ಇದಲ್ಲದೆ ಅವರು ರೆಬೆಕ್ಕಳನ್ನು ಹೀಗೆಂದು ಆಶೀರ್ವದಿಸಿದರು: “ನಮ್ಮ ಸಹೋದರಿಯೇ, ನೀನು ಸಹಸ್ರ ಸಹಸ್ರ ಮಕ್ಕಳಿಗೆ ತಾಯಿಯಾಗು. ನಿನ್ನ ಸಂತಾನದವರು ತಮ್ಮ ವೈರಿಗಳ ಪ್ರದೇಶಗಳನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳಲಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ಆಗ ರೆಬೆಕ್ಕಳೂ, ಆಕೆಯ ದಾಸಿಯರೂ ಒಂಟೆಗಳ ಮೇಲೆ ಹತ್ತಿ, ಆ ಮನುಷ್ಯನ ಹಿಂದೆ ಹೋದರು. ಆ ಸೇವಕನು ರೆಬೆಕ್ಕಳನ್ನು ಕರಕೊಂಡು ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ಇಸಾಕನು ಬೇರ್ ಲಹೈರೋಯಿ ಬಾವಿಗೆ ಹೋಗಿ ಬಂದನು. ಅವನು ದೇಶದ ನೆಗೆವನಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ಇಸಾಕನು ಸಾಯಂಕಾಲ ಹೊಲದಲ್ಲಿ ಧ್ಯಾನಮಾಡುವುದಕ್ಕೆ ಹೋದಾಗ, ಕಣ್ಣೆತ್ತಿ ನೋಡಲು, ಒಂಟೆಗಳು ಬರುವುದನ್ನು ಕಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ರೆಬೆಕ್ಕಳು ಸಹ ಕಣ್ಣೆತ್ತಿ ಇಸಾಕನನ್ನು ನೋಡಿ, ಒಂಟೆಗಳಿಂದ ಇಳಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ಆಕೆಯು ಆ ಸೇವಕನಿಗೆ, “ಹೊಲದಲ್ಲಿ ನಮಗೆ ಎದುರಾಗಿ ಬರುವ ಆ ಮನುಷ್ಯನು ಯಾರು?” ಎಂದಳು. ಅದಕ್ಕೆ ಸೇವಕನು, “ಅವನೇ ನನ್ನ ಯಜಮಾನನು,” ಎಂದಾಗ, ಆಕೆಯು ಮುಸುಕು ಹಾಕಿಕೊಂಡಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ಆಗ ಸೇವಕನು ಇಸಾಕನಿಗೆ ತಾನು ಮಾಡಿದ ಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ತಿಳಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ಇಸಾಕನು ಆಕೆಯನ್ನು ತನ್ನ ತಾಯಿಯಾದ ಸಾರಳ ಗುಡಾರಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ಅವನು ರೆಬೆಕ್ಕಳನ್ನು ಸ್ವೀಕರಿಸಿದನು. ಆಕೆಯು ಅವನ ಹೆಂಡತಿಯಾದಳು, ಅವನು ಆಕೆಯನ್ನು ಪ್ರೀತಿಸಿದನು. ಹೀಗೆ ಇಸಾಕನು ತನ್ನ ತಾಯಿಯ ಮರಣದ ದುಃಖ ಶಮನ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ಅಬ್ರಹಾಮನು ಕೆಟೂರಳೆಂಬ ಇನ್ನೊಬ್ಬಳನ್ನು ಮದುವೆಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ಆಕೆಯು ಜಿಮ್ರಾನ್, ಯೊಕ್ಷಾನ್, ಮೆದಾನ್, ಮಿದ್ಯಾನ್, ಇಷ್ಬಾಕ್, ಶೂಹ ಇವರನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ಯೊಕ್ಷಾನನಿಗೆ ಶೆಬಾ ಮತ್ತು ದೆದಾನ್ ಹುಟ್ಟಿದರು. ದೆದಾನನ ಪುತ್ರರು ಅಶ್ಯೂರರು, ಲೆಟೂಶ್ಯರೂ, ಲೆಯುಮ್ಯರೂ. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ಮಿದ್ಯಾನನ ಪುತ್ರರು: ಏಫಾ, ಏಫೆರ್, ಹನೋಕ್, ಅಬೀದ, ಎಲ್ದಾಯ. ಇವರೆಲ್ಲರೂ ಕೆಟೂರಳ ಸಂತತಿಯವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ಆದರೆ ಅಬ್ರಹಾಮನು ತನಗಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ಇಸಾಕನಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ಅಬ್ರಹಾಮನಿಗೆ ಇದ್ದ ಉಪಪತ್ನಿಯರ ಮಕ್ಕಳಿಗೆ ಅಬ್ರಹಾಮನು ದಾನಗಳನ್ನು ಕೊಟ್ಟು, ತಾನು ಜೀವಿಸುತ್ತಿರುವಾಗಲೇ ಅವರನ್ನು ತನ್ನ ಮಗ ಇಸಾಕನ ಬಳಿಯಿಂದ ಪೂರ್ವದಿಕ್ಕಿನ ಕಡೆಗೆ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ಅಬ್ರಹಾಮನು ನೂರೆಪ್ಪತ್ತೈದು ವರ್ಷಗಳವರೆಗೆ ಜೀವಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ಅವನು ಪೂರ್ಣಾಯುಷ್ಯನಾಗಿ ತುಂಬಾ ಮುದುಕನಾಗಿ ಮರಣಹೊಂದಿ ತನ್ನ ಪಿತೃಗಳ ಬಳಿಗೆ ಸೇರಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ಅವನ ಪುತ್ರರಾದ ಇಸಾಕನೂ, ಇಷ್ಮಾಯೇಲನೂ ಮಮ್ರೆಗೆ ಎದುರಾಗಿರುವ ಹಿತ್ತಿಯನಾದ ಚೋಹರನ ಮಗ ಎಫ್ರೋನನ ಹೊಲದಲ್ಲಿರುವ ಮಕ್ಪೇಲ ಎಂಬ ಗವಿಯಲ್ಲಿ ಅವನನ್ನು ಹೂಳಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ಅಬ್ರಹಾಮನು ಅದನ್ನು ಹಿತ್ತಿಯರಿಂದ ಕೊಂಡುಕೊಂಡಿದ್ದನು. ಅಬ್ರಹಾಮನಿಗೂ, ಅವನ ಹೆಂಡತಿ ಸಾರಳಿಗೂ ಒಂದೇ ಸ್ಥಳದಲ್ಲಿ ಸಮಾಧಿ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ಅಬ್ರಹಾಮನು ಸತ್ತ ನಂತರ ದೇವರು ಅವನ ಮಗ ಇಸಾಕನನ್ನು ಆಶೀರ್ವದಿಸಿದರು. ಇಸಾಕನು ಬೇರ್ ಲಹೈರೋಯಿ ಎಂಬ ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ವಾಸಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ಸಾರಳ ದಾಸಿ ಈಜಿಪ್ಟಿನ ಹಾಗರಳು ಅಬ್ರಹಾಮನಿಗೆ ಹೆತ್ತ ಮಗ ಇಷ್ಮಾಯೇಲನ ವಂಶಾವಳಿ: ");
INSERT INTO kanokcv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ಜನನದ ಪ್ರಕಾರ ಇಷ್ಮಾಯೇಲನ ಪುತ್ರರ ಹೆಸರುಗಳು ಇವೇ: ಇಷ್ಮಾಯೇಲನ ಚೊಚ್ಚಲ ಮಗನು ನೆಬಾಯೋತ್, ಕೇದಾರ್, ಅದ್ಬೆಯೇಲ್, ಮಿಬ್ಸಾಮ್, ");
INSERT INTO kanokcv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ಮಿಷ್ಮಾ, ದೂಮಾ, ಮಸ್ಸಾ, ");
INSERT INTO kanokcv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ಹದದ್, ತೇಮಾ, ಯೆಟೂರ್, ನಾಫೀಷ್, ಕೇದೆಮ. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ಇವರೇ ಇಷ್ಮಾಯೇಲನ ಪುತ್ರರು. ಇವುಗಳೇ ಅವರ ಗ್ರಾಮಗಳ ಪ್ರಕಾರವಾಗಿಯೂ, ಪಾಳೆಯಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ಇರುವ ಅವರ ಹೆಸರುಗಳು. ಅವರು ತಮ್ಮ ಜನಾಂಗಗಳ ಪ್ರಕಾರ ಹನ್ನೆರಡು ಮಂದಿ ಪ್ರಭುಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ಇಷ್ಮಾಯೇಲನು ಬದುಕಿದ ವರ್ಷಗಳು ನೂರಮೂವತ್ತೇಳು. ಅವನು ಮರಣಹೊಂದಿ ತನ್ನ ಪಿತೃಗಳ ಬಳಿಗೆ ಸೇರಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ಅವನ ವಂಶಸ್ಥರು ಅಸ್ಸೀರಿಯಗೆ ಹೋಗುವ, ಈಜಿಪ್ಟಿನ ಮೇರೆಯಲ್ಲಿ ಹವೀಲದಿಂದ ಶೂರ್‌ವರೆಗಿನ ಪ್ರದೇಶದಲ್ಲಿ ವಾಸಿಸಿದರು. ಅವರು ತಮ್ಮ ಎಲ್ಲಾ ಸಹೋದರರೊಂದಿಗೆ ಎದುರುಬದಿರಿನಲ್ಲೇ ವಾಸಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ಅಬ್ರಹಾಮನ ಮಗ ಇಸಾಕನ ವಂಶಾವಳಿ: ಅಬ್ರಹಾಮನಿಂದ ಇಸಾಕನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ಇಸಾಕನು ನಲವತ್ತು ವರ್ಷದವನಾಗಿದ್ದಾಗ ಪದ್ದನ್ ಅರಾಮಿನಿಂದ ಅರಾಮ್ಯನಾದ ಬೆತೂಯೇಲನ ಮಗಳೂ, ಲಾಬಾನನ ಸಹೋದರಿಯೂ ಆದ ರೆಬೆಕ್ಕಳನ್ನು ಹೆಂಡತಿಯಾಗಿ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ಆದರೆ ಆಕೆಯು ಬಂಜೆಯಾಗಿದ್ದುದರಿಂದ ಇಸಾಕನು ತನ್ನ ಹೆಂಡತಿಗೋಸ್ಕರ ಯೆಹೋವ ದೇವರನ್ನು ಬೇಡಿಕೊಂಡನು. ಯೆಹೋವ ದೇವರು ಅವನ ಬೇಡಿಕೆಯನ್ನು ಪೂರೈಸಿದರು. ಆದ್ದರಿಂದ ಅವನ ಹೆಂಡತಿ ರೆಬೆಕ್ಕಳು ಗರ್ಭಿಣಿಯಾದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ಅವಳ ಗರ್ಭದಲ್ಲಿ ಶಿಶುಗಳು ಒಂದನ್ನೊಂದು ನೂಕಿಕೊಂಡಾಗ ಆಕೆಯು, “ನನಗೆ ಏಕೆ ಹೀಗಾಗುತ್ತಿದೆ?” ಎಂದು ಕೇಳಿ, ಯೆಹೋವ ದೇವರ ಬಳಿಗೆ ವಿಚಾರಿಸುವುದಕ್ಕೆ ಹೋದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ಯೆಹೋವ ದೇವರು ಆಕೆಗೆ ಹೀಗೆ ಹೇಳಿದರು: “ನಿನ್ನ ಹೊಟ್ಟೆಯಲ್ಲಿ ಎರಡು ಜನಾಂಗಗಳು ಇವೆ. ನಿನ್ನ ಗರ್ಭದೊಳಗಿನಿಂದಲೇ ಎರಡು ಜನಾಂಗಗಳು ಹೊರಟುಬಂದು ಬೇರೆಯಾಗುವುವು. ಒಂದು ಇನ್ನೊಂದಕ್ಕಿಂತ ಬಲವಾಗಿರುವುದು. ಇದಲ್ಲದೆ ಹಿರಿಯನು ಕಿರಿಯವನಿಗೆ ಸೇವೆಮಾಡುವನು.” ");
INSERT INTO kanokcv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ಆಕೆಯು ಹೆರುವುದಕ್ಕೆ ದಿನತುಂಬಿದಾಗ, ಆಕೆಯ ಗರ್ಭದಲ್ಲಿ ಅವಳಿ ಮಕ್ಕಳಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ಮೊದಲನೆಯವನು ಕೆಂಪಾಗಿಯೂ ಕೂದಲಿನ ವಸ್ತ್ರದಂತೆ ಇಡೀ ದೇಹವು ಇದ್ದುದರಿಂದ ಅವನಿಗೆ, ಏಸಾವ, ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ತರುವಾಯ ಅವನ ತಮ್ಮನು ಏಸಾವನ ಹಿಮ್ಮಡಿಯನ್ನು ಕೈಯಿಂದ ಹಿಡಿದುಕೊಂಡು ಹೊರಗೆ ಬಂದನು. ಅವನಿಗೆ, ಯಾಕೋಬ, ಎಂದು ಹೆಸರಿಟ್ಟರು. ಆಕೆಯು ಇವರನ್ನು ಹೆತ್ತಾಗ ಇಸಾಕನು ಅರವತ್ತು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ಆ ಹುಡುಗರು ಬೆಳೆದಾಗ ಏಸಾವನು ಬೇಟೆಯಾಡುವುದರಲ್ಲಿ ಜಾಣನಾಗಿದ್ದು, ಅಡವಿಯ ಮನುಷ್ಯನಾದನು. ಯಾಕೋಬನು ಗುಡಾರಗಳಲ್ಲಿ ವಾಸಮಾಡುವ ಸಾಧು ಮನುಷ್ಯನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ಬೇಟೆಯಲ್ಲಿ ಆಸಕ್ತನಾಗಿದ್ದ ಇಸಾಕನು ಏಸಾವನನ್ನು ಪ್ರೀತಿಸಿದನು. ಆದರೆ ರೆಬೆಕ್ಕಳು ಯಾಕೋಬನನ್ನು ಪ್ರೀತಿಸಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ಒಂದು ಸಾರಿ ಯಾಕೋಬನು ಅಡಿಗೆ ಮಾಡುತ್ತಿದ್ದಾಗ, ಏಸಾವನು ದಣಿದು ಅಡವಿಯಿಂದ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ಏಸಾವನು ಯಾಕೋಬನಿಗೆ, “ಆ ಕೆಂಪಾದ ಪದಾರ್ಥವನ್ನು ತಿನ್ನುವುದಕ್ಕೆ ನನಗೆ ಕೊಡು, ನಾನು ದಣಿದಿದ್ದೇನೆ,” ಎಂದನು. ಆದ್ದರಿಂದ ಅವನಿಗೆ, ಎದೋಮ್, ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ಆಗ ಯಾಕೋಬನು, “ಈ ಹೊತ್ತು ನಿನ್ನ ಜೇಷ್ಠ ಪುತ್ರನ ಹಕ್ಕನ್ನು ನನಗೆ ಮಾರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ಏಸಾವನು, “ಇಗೋ, ನಾನು ಸಾಯುತ್ತಿದ್ದೇನೆ, ಜೇಷ್ಠ ಪುತ್ರನ ಹಕ್ಕಿನಿಂದ ನನಗೇನು ಲಾಭ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ಯಾಕೋಬನು, “ಈ ಹೊತ್ತು ನನಗೆ ಪ್ರಮಾಣಮಾಡು,” ಎಂದನು. ಆಗ ಅವನು ಯಾಕೋಬನಿಗೆ ಪ್ರಮಾಣಮಾಡಿ, ತನ್ನ ಜೇಷ್ಠ ಪುತ್ರನ ಹಕ್ಕನ್ನು ಅವನಿಗೆ ಮಾರಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ಆಗ ಯಾಕೋಬನು ಏಸಾವನಿಗೆ ರೊಟ್ಟಿಯನ್ನೂ, ಅಲಸಂದಿ ಗುಗ್ಗರಿಯನ್ನೂ ಕೊಟ್ಟನು. ಅವನು ತಿಂದು, ಕುಡಿದು ಎದ್ದು ಹೋದನು. ಹೀಗೆ ಏಸಾವನು ತನ್ನ ಜೇಷ್ಠ ಪುತ್ರನ ಹಕ್ಕನ್ನು ತಾತ್ಸಾರದಿಂದ ಕಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ಅಬ್ರಹಾಮನ ದಿನಗಳಲ್ಲಿ ಬಂದ ಮೊದಲನೆಯ ಬರವಲ್ಲದೆ, ದೇಶದಲ್ಲಿ ಮತ್ತೊಂದು ಬರವು ಬಂದಿತು. ಆಗ ಇಸಾಕನು ಗೆರಾರಿನಲ್ಲಿದ್ದ ಫಿಲಿಷ್ಟಿಯರ ಅರಸನಾದ ಅಬೀಮೆಲೆಕನ ಬಳಿಗೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ಆಗ ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ ಕಾಣಿಸಿಕೊಂಡು, “ಈಜಿಪ್ಟಿಗೆ ಇಳಿದು ಹೋಗಬೇಡ. ನಾನು ನಿನಗೆ ಹೇಳುವ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ಈ ದೇಶದಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿರು. ಆಗ ನಾನು ನಿನ್ನ ಸಂಗಡ ಇದ್ದು, ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು. ನಿನಗೂ, ನಿನ್ನ ಸಂತಾನಕ್ಕೂ ಈ ಪ್ರದೇಶಗಳನ್ನೆಲ್ಲಾ ಕೊಡುವೆನು. ನಿನ್ನ ತಂದೆ ಅಬ್ರಹಾಮನಿಗೆ ನಾನು ಮಾಡಿದ ಪ್ರಮಾಣವನ್ನು ಈಡೇರಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ನಿನ್ನ ಸಂತತಿಯನ್ನು ಆಕಾಶದ ನಕ್ಷತ್ರಗಳಂತೆ ಹೆಚ್ಚಿಸುವೆನು. ನಿನ್ನ ಸಂತತಿಗೆ ಈ ಪ್ರದೇಶಗಳನ್ನೆಲ್ಲಾ ಕೊಡುವೆನು. ನಿನ್ನ ಸಂತತಿಯ ಮೂಲಕ ಭೂಮಿಯ ಎಲ್ಲಾ ಜನಾಂಗಗಳಿಗೂ ಆಶೀರ್ವಾದವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ಏಕೆಂದರೆ ಅಬ್ರಹಾಮನು ನನ್ನ ಮಾತಿಗೆ ನನ್ನ ವಿಧಿಯನ್ನೂ, ನನ್ನ ಆಜ್ಞೆಗಳನ್ನೂ, ನನ್ನ ಕಟ್ಟಳೆಗಳನ್ನೂ ನನ್ನ ನೇಮಗಳನ್ನೂ, ಕೈಗೊಂಡು ನಡೆದನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ಆಗ ಇಸಾಕನು ಗೆರಾರಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ಆ ಸ್ಥಳದ ಮನುಷ್ಯರು ಅವನ ಹೆಂಡತಿಯ ವಿಷಯದಲ್ಲಿ ವಿಚಾರಿಸಿದಾಗ ಅವನು, ರೆಬೆಕ್ಕಳು ನೋಟಕ್ಕೆ ಚೆಲುವೆಯಾಗಿದ್ದುದರಿಂದ ಆಕೆಯ ನಿಮಿತ್ತ ಆ ಸ್ಥಳದ ಜನರು ತನ್ನನ್ನು ಕೊಂದಾರೆಂದು, ಆಕೆ ತನ್ನ ಹೆಂಡತಿಯೆಂದು ಹೇಳುವುದಕ್ಕೆ ಅಂಜಿ ಅವನು, “ಆಕೆಯು ನನ್ನ ತಂಗಿ” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ಅವನು ಅಲ್ಲಿ ಬಹಳ ದಿನಗಳಿದ್ದ ಮೇಲೆ, ಒಂದು ದಿನ ಫಿಲಿಷ್ಟಿಯರ ಅರಸನಾದ ಅಬೀಮೆಲೆಕನು ಕಿಟಕಿಯಿಂದ ನೋಡುತ್ತಿದ್ದಾಗ, ಇಸಾಕನು ತನ್ನ ಹೆಂಡತಿಯಾದ ರೆಬೆಕ್ಕಳ ಸಂಗಡ ಸರಸಮಾಡುವುದನ್ನು ಕಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ಆಗ ಅಬೀಮೆಲೆಕನು ಇಸಾಕನನ್ನು ಕರೆದು, “ಆಕೆಯು ಖಂಡಿತ ನಿನ್ನ ಹೆಂಡತಿಯಾಗಿದ್ದಾಳೆ. ಆದರೆ ನೀನು, ‘ಆಕೆಯು ನನ್ನ ತಂಗಿ,’ ಎಂದು ಏಕೆ ಹೇಳಿದೆ?” ಎಂದನು. ಇಸಾಕನು ಅವನಿಗೆ, “ನಾನು ಆಕೆಯ ನಿಮಿತ್ತ ಸಾಯಬಾರದೆಂದು ಹಾಗೆ ಹೇಳಿದೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ಆಗ ಅಬೀಮೆಲೆಕನು, “ನೀನು ನಮಗೆ ಮಾಡಿದ್ದೇನು? ಜನರಲ್ಲಿ ಒಬ್ಬನು ನಿನ್ನ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಂಡಿದ್ದರೆ, ನೀನು ನಮ್ಮ ಮೇಲೆ ಅಪರಾಧವನ್ನು ಬರಮಾಡುತ್ತಿದ್ದೆಯಲ್ಲಾ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ಅಬೀಮೆಲೆಕನು ತನ್ನ ಜನರಿಗೆಲ್ಲಾ, “ಈ ಮನುಷ್ಯನನ್ನಾಗಲಿ, ಅವನ ಹೆಂಡತಿಯನ್ನಾಗಲಿ ಮುಟ್ಟುವವನು ಖಂಡಿತವಾಗಿ ಸಾಯಬೇಕು,” ಎಂದು ಅಪ್ಪಣೆಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ಇಸಾಕನು ಆ ದೇಶದಲ್ಲಿ ಬಿತ್ತಿದ ವರ್ಷದಲ್ಲಿಯೇ ನೂರರಷ್ಟು ಬೆಳೆಯನ್ನು ಹೊಂದಿದನು. ಯೆಹೋವ ದೇವರು ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ಅವನು ಬಹಳ ಶ್ರೀಮಂತನಾಗಿ, ಕ್ರಮೇಣವಾಗಿ ಹೆಚ್ಚಿದ್ದರಿಂದ ಅಭಿವೃದ್ಧಿಯಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ಏಕೆಂದರೆ ಅವನಿಗೆ ಕುರಿ ಮಂದೆಗಳೂ ದನಗಳ ಹಿಂಡುಗಳೂ ಬಹಳ ಮಂದಿ ಸೇವಕರೂ ಇದ್ದರು. ಆದ್ದರಿಂದ ಫಿಲಿಷ್ಟಿಯರು ಅವನ ಮೇಲೆ ಹೊಟ್ಟೆಕಿಚ್ಚುಪಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ಅವನ ತಂದೆ ಅಬ್ರಹಾಮನ ದಿನಗಳಲ್ಲಿ ಅಬ್ರಹಾಮನ ಸೇವಕರು ಅಗೆದ ಬಾವಿಗಳನ್ನೆಲ್ಲಾ ಫಿಲಿಷ್ಟಿಯರು ಮಣ್ಣುಹಾಕಿ ಮುಚ್ಚಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ಅಬೀಮೆಲೆಕನು ಇಸಾಕನಿಗೆ, “ನಮ್ಮನ್ನು ಬಿಟ್ಟು ಹೋಗು, ಏಕೆಂದರೆ ನೀನು ನಮಗಿಂತ ಬಲಿಷ್ಠನಾಗಿಬಿಟ್ಟೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ಆಗ ಇಸಾಕನು ಅಲ್ಲಿಂದ ಹೋಗಿ ಗೆರಾರಿನ ತಗ್ಗಿನಲ್ಲಿ ಗುಡಾರ ಹಾಕಿ, ಅಲ್ಲಿ ವಾಸಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ಇದಲ್ಲದೆ ಇಸಾಕನು ತನ್ನ ತಂದೆ ಅಬ್ರಹಾಮನ ದಿನಗಳಲ್ಲಿ ಅಗೆದಂಥ ಬಾವಿಗಳನ್ನು ತಿರುಗಿ ಅಗೆದನು. ಏಕೆಂದರೆ ಅಬ್ರಹಾಮನು ಮರಣದ ನಂತರ ಫಿಲಿಷ್ಟಿಯರು ಅವುಗಳನ್ನು ಮುಚ್ಚಿದ್ದರು. ಅವುಗಳಿಗೆ ತನ್ನ ತಂದೆಯು ಕೊಟ್ಟ ಹೆಸರುಗಳ ಪ್ರಕಾರವೇ ಅವನು ಅವುಗಳಿಗೆ ಹೆಸರುಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ಇಸಾಕನ ಸೇವಕರು ತಗ್ಗಿನಲ್ಲಿ ಅಗೆದಾಗ, ಅಲ್ಲಿ ಅವರಿಗೆ ಉಕ್ಕುವ ಒರತೆಯ ಬಾವಿಯು ಸಿಕ್ಕಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ಗೆರಾರಿನ ಮಂದೆಯನ್ನು ಮೇಯಿಸುವವರು, “ಈ ನೀರು ನಮ್ಮದು,” ಎಂದು ಇಸಾಕನ ಮಂದೆಯನ್ನು ಮೇಯಿಸುವವರ ಸಂಗಡ ಜಗಳವಾಡಿದರು. ಅವರು ಅವನ ಸಂಗಡ ಜಗಳವಾಡಿದ ಕಾರಣ ಅವನು ಆ ಬಾವಿಗೆ, ಏಸೆಕ್, ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ತರುವಾಯ ಅವರು ಇನ್ನೊಂದು ಬಾವಿಯನ್ನು ಅಗೆದಾಗ, ಅದಕ್ಕಾಗಿಯೂ ಅವರು ಜಗಳವಾಡಿದಾಗ, ಅವನು ಅದಕ್ಕೆ, ಸಿಟ್ನಾ, ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ಅಲ್ಲಿಂದ ಅವನು ಹೊರಟುಹೋಗಿ ಇನ್ನೊಂದು ಬಾವಿಯನ್ನು ಅಗೆದಾಗ, ಅದಕ್ಕಾಗಿ ಅವರು ಜಗಳವಾಡಲಿಲ್ಲ. ಅದಕ್ಕೆ ಅವನು, “ಈಗ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಸ್ಥಳವನ್ನು ಮಾಡಿದ್ದಾರೆ. ನಾವು ಈ ದೇಶದಲ್ಲಿ ಅಭಿವೃದ್ಧಿ ಹೊಂದುವೆವು,” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ, ರೆಹೋಬೋತ್, ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ಅಲ್ಲಿಂದ ಅವನು ಬೇರ್ಷೆಬಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ಅದೇ ರಾತ್ರಿಯಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ ಕಾಣಿಸಿಕೊಂಡು, “ನಿನ್ನ ತಂದೆ ಅಬ್ರಹಾಮನ ದೇವರು ನಾನೇ, ಭಯಪಡಬೇಡ. ಏಕೆಂದರೆ ನಾನು ನಿನ್ನ ಸಂಗಡ ಇದ್ದೇನೆ, ನನ್ನ ದಾಸನಾದ ಅಬ್ರಹಾಮನಿಗೋಸ್ಕರ ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿ, ನಿನ್ನ ಸಂತತಿಯನ್ನು ಹೆಚ್ಚಿಸುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ಆಗ ಇಸಾಕನು ಅಲ್ಲಿ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿ, ಯೆಹೋವ ದೇವರ ಹೆಸರನ್ನು ಹೇಳಿಕೊಂಡು, ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿದನು. ಆಗ ಇಸಾಕನ ಸೇವಕರು ಅಲ್ಲಿ ಒಂದು ಬಾವಿಯನ್ನು ಅಗೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ತರುವಾಯ ಅಬೀಮೆಲೆಕನೂ, ಅವನ ಸ್ನೇಹಿತರಲ್ಲಿ ಒಬ್ಬನಾದ ಅಹುಜ್ಜತನೂ, ಅವನ ಮುಖ್ಯ ಸೈನ್ಯಾಧಿಪತಿ ಫೀಕೋಲನೂ ಗೆರಾರಿನಿಂದ ಅವನ ಬಳಿಗೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ಇಸಾಕನು ಅವರಿಗೆ, “ನನ್ನ ಬಳಿಗೆ ನೀವು ಏಕೆ ಬಂದಿದ್ದೀರಿ? ನೀವು ನನ್ನನ್ನು ಹಗೆಮಾಡಿ, ನಿಮ್ಮ ಬಳಿಯಿಂದ ನನ್ನನ್ನು ಕಳುಹಿಸಿಬಿಟ್ಟಿರಲ್ಲಾ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ಅದಕ್ಕೆ ಅವರು, “ನಿಶ್ಚಯವಾಗಿ ಯೆಹೋವ ದೇವರು ನಿನ್ನ ಸಂಗಡ ಇದ್ದಾರೆ ಎಂದು ತಿಳಿದು, ನಮಗೂ, ನಿನಗೂ ಮಧ್ಯದಲ್ಲಿ ಒಂದು ಪ್ರಮಾಣವಿರುವ ಹಾಗೆ, ನಿನ್ನ ಸಂಗಡ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಳ್ಳೋಣವೆಂದು ನಾವು ತೀರ್ಮಾನಿಸಿದ್ದೇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ಅದೇನೆಂದರೆ, ನಾವು ನಿನ್ನನ್ನು ಮುಟ್ಟದೆ, ನಿನಗೆ ಒಳ್ಳೆಯದನ್ನೇ ಮಾಡಿ, ನಿನ್ನನ್ನು ಸಮಾಧಾನದಿಂದ ಕಳುಹಿಸಿದ ಹಾಗೆ ನೀನು ನಮಗೂ ಕೇಡು ಮಾಡಬಾರದು. ಏಕೆಂದರೆ ನೀನು ಈಗ ಯೆಹೋವ ದೇವರಿಂದ ಆಶೀರ್ವಾದ ಹೊಂದಿರುವೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ಆಗ ಇಸಾಕನು ಅವರಿಗೆ ಔತಣವನ್ನು ಮಾಡಿಸಿದನು. ಅವರೆಲ್ಲರೂ ತಿಂದು ಕುಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಒಬ್ಬರಿಗೊಬ್ಬರು ಪ್ರಮಾಣ ಮಾಡಿಕೊಂಡರು. ಅನಂತರ ಇಸಾಕನು ಅವರನ್ನು ಸಾಗಕಳುಹಿಸಿದನು. ಅವರು ಸಮಾಧಾನದಿಂದ ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ಅದೇ ದಿನದಲ್ಲಿ ಇಸಾಕನ ಸೇವಕರು ಬಂದು ತಾವು ಅಗೆದ ಬಾವಿಯಲ್ಲಿ, “ನೀರು ಸಿಕ್ಕಿತ್ತು,” ಎಂದು ಅವನಿಗೆ ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ಅದಕ್ಕೆ ಅವನು, ಷಿಬಾ, ಎಂದು ಹೆಸರಿಟ್ಟನು. ಆದ್ದರಿಂದ ಇಂದಿನವರೆಗೂ ಬೇರ್ಷೆಬ ಎಂದು ಆ ಪಟ್ಟಣಕ್ಕೆ ಹೆಸರಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ಏಸಾವನು ನಲವತ್ತು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ಹಿತ್ತಿಯನಾದ ಬೇರಿಯನ ಮಗಳಾದ ಯೆಹೂದೀತಳನ್ನೂ, ಹಿತ್ತಿಯನಾದ ಏಲೋನನ ಮಗಳಾದ ಬಾಸೆಮತಳನ್ನೂ ಮದುವೆಯಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ಇವರ ದೆಸೆಯಿಂದ ಇಸಾಕನಿಗೂ, ರೆಬೆಕ್ಕಳಿಗೂ ಮನೋವ್ಯಥೆಯಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ಇಸಾಕನು ಮುದುಕನಾಗಿ ನೋಡುವುದಕ್ಕಾಗದಷ್ಟು ಅವನ ಕಣ್ಣುಗಳು ಮಬ್ಬಾದಾಗ, ಅವನು ತನ್ನ ಹಿರಿಯ ಮಗ ಏಸಾವನನ್ನು ಕರೆದು ಅವನಿಗೆ, “ನನ್ನ ಮಗನೇ,” ಎಂದನು. ಅವನು ಇಸಾಕನಿಗೆ, “ಇದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ಆಗ ಇಸಾಕನು, “ಇಗೋ, ಈಗ ನಾನು ಮುದುಕನಾಗಿದ್ದೇನೆ. ನನ್ನ ಸಾವಿನ ದಿನವನ್ನು ಅರಿಯೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ಆದ್ದರಿಂದ ಈಗ ನೀನು ನಿನ್ನ ಆಯುಧಗಳನ್ನೂ, ಬಿಲ್ಲುಬತ್ತಳಿಕೆಯನ್ನೂ, ತೆಗೆದುಕೊಂಡು ಅಡವಿಗೆ ಹೋಗಿ ನನಗೋಸ್ಕರ ಬೇಟೆಯ ಮಾಂಸವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ನಾನು ಇಷ್ಟಪಡುವ ರುಚಿಯಾದ ಊಟವನ್ನೂ ಸಿದ್ಧಮಾಡಿ ತೆಗೆದುಕೊಂಡು ಬಾ. ಆಗ ಸಾಯುವುದಕ್ಕಿಂತ ಮುಂಚೆ ನಾನು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವಂತೆ ಅದನ್ನು ಊಟಮಾಡುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ಇಸಾಕನು ತನ್ನ ಮಗ ಏಸಾವನಿಗೆ ಹೇಳಿದ್ದನ್ನು ರೆಬೆಕ್ಕಳು ಕೇಳಿಸಿಕೊಂಡಳು. ಏಸಾವನು ಬೇಟೆಯಾಡಿ ಅದನ್ನು ತರುವುದಕ್ಕಾಗಿ ಅಡವಿಗೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ಆಗ ರೆಬೆಕ್ಕಳು ತನ್ನ ಮಗ ಯಾಕೋಬನಿಗೆ, “ನಿನ್ನ ತಂದೆ ನಿನ್ನ ಸಹೋದರ ಏಸಾವನಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘ನನಗೋಸ್ಕರ ಬೇಟೆಯ ಮಾಂಸವನ್ನು ತೆಗೆದುಕೊಂಡು ಬಂದು, ನಾನು ಇಷ್ಟಪಡುವ ರುಚಿಯಾದ ಅಡಿಗೆಯನ್ನು ಮಾಡಿಕೊಂಡು ಬಾ, ಆಗ ನಾನು ಸಾಯುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಊಟಮಾಡಿ, ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು,’ ಎಂದು ಹೇಳಿದ್ದನ್ನು ನಾನು ಕೇಳಿಸಿಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ಆದ್ದರಿಂದ ಈಗ ನನ್ನ ಮಗನೇ, ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸುವ ನನ್ನ ಮಾತಿಗೆ ವಿಧೇಯನಾಗು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ನೀನು ಮಂದೆಯ ಬಳಿಗೆ ಹೋಗಿ, ಅಲ್ಲಿಂದ ಎರಡು ಒಳ್ಳೆಯ ಮೇಕೆಯ ಮರಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬಾ. ನಿನ್ನ ತಂದೆಗೋಸ್ಕರ ನಾನು ಅವುಗಳನ್ನೂ, ಅವನು ಇಷ್ಟಪಡುವ ರುಚಿಯಾದ ಅಡಿಗೆಯನ್ನೂ ಸಿದ್ಧಮಾಡುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ನೀನು ಅದನ್ನು ನಿನ್ನ ತಂದೆಯ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. ಅವನು ಸಾಯುವುದಕ್ಕಿಂತ ಮೊದಲು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವಂತೆ ಊಟಮಾಡಲಿ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ಅದಕ್ಕೆ ಯಾಕೋಬನು ತನ್ನ ತಾಯಿ ರೆಬೆಕ್ಕಳಿಗೆ, “ನನ್ನ ಸಹೋದರ ಏಸಾವನು ರೋಮವುಳ್ಳವನಾಗಿದ್ದಾನೆ, ನಾನು ನುಣುಪಾದ ಚರ್ಮವುಳ್ಳವನಾಗಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ಒಂದು ವೇಳೆ ನನ್ನ ತಂದೆಯು ನನ್ನನ್ನು ಮುಟ್ಟಿದರೆ, ನನ್ನ ಗತಿಯೇನು? ನಾನು ಅವನಿಗೆ ಮೋಸಮಾಡುವವನಾಗಿ ಕಂಡು ಬಂದು, ಆಶೀರ್ವಾದಕ್ಕಿಂತ ಶಾಪವನ್ನೇ ಹೊಂದುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ಅವನ ತಾಯಿಯು ಅವನಿಗೆ, “ನನ್ನ ಮಗನೇ, ನಿನ್ನ ಶಾಪವು ನನ್ನ ಮೇಲೆ ಇರಲಿ, ನೀನು ಮಾತ್ರ ನನ್ನ ಮಾತಿಗೆ ವಿಧೇಯನಾಗಿ ಹೋಗಿ, ಅವುಗಳನ್ನು ನನ್ನ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಬಾ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ಆಗ ಯಾಕೋಬನು ಹೋಗಿ ಅವುಗಳನ್ನು ಹಿಡಿದು ತೆಗೆದುಕೊಂಡು ತನ್ನ ತಾಯಿಗೆ ತಂದುಕೊಟ್ಟನು. ಅವನ ತಾಯಿಯು, ಅವನ ತಂದೆಯು ಇಷ್ಟಪಡುವ ರುಚಿಯಾದ ಅಡಿಗೆಯನ್ನು ಸಿದ್ಧಮಾಡಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ತರುವಾಯ ರೆಬೆಕ್ಕಳು ಮನೆಯಲ್ಲಿದ್ದ ತನ್ನ ಹಿರಿಯ ಮಗನಾದ ಏಸಾವನ ಒಳ್ಳೆಯ ವಸ್ತ್ರವನ್ನು ತೆಗೆದುಕೊಂಡು, ತನ್ನ ಕಿರಿಯ ಮಗ ಯಾಕೋಬನಿಗೆ ಉಡಿಸಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ಇದಲ್ಲದೆ ಮೇಕೆಯ ಮರಿಗಳ ಚರ್ಮಗಳನ್ನು ಅವನ ಕೈಗಳ ಮೇಲೆಯೂ, ನುಣುಪಾದ ಅವನ ಕೊರಳಿನ ಮೇಲೆಯೂ ಕಟ್ಟಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ತರುವಾಯ ತಾನು ಸಿದ್ಧಮಾಡಿದ ರುಚಿಯಾದ ಊಟವನ್ನೂ, ರೊಟ್ಟಿಯನ್ನೂ ತನ್ನ ಮಗ ಯಾಕೋಬನ ಕೈಯಲ್ಲಿ ಕೊಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ಆಗ ಅವನು ತನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಹೋಗಿ, “ನನ್ನ ತಂದೆಯೇ,” ಎಂದನು. ಅದಕ್ಕೆ ಅವನು, “ನೀನು ಯಾರು?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ಯಾಕೋಬನು ತನ್ನ ತಂದೆಗೆ, “ನಾನು ನಿನ್ನ ಹಿರಿಯ ಮಗ ಏಸಾವನು. ನೀನು ನನಗೆ ಹೇಳಿದಂತೆ ಮಾಡಿದ್ದೇನೆ, ಎದ್ದು ಕುಳಿತುಕೋ. ನೀನು ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವಂತೆ ನನ್ನ ಬೇಟೆಯ ಮಾಂಸವನ್ನು ಊಟಮಾಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ಇಸಾಕನು ತನ್ನ ಮಗನಿಗೆ, “ನನ್ನ ಮಗನೇ, ಇಷ್ಟು ಬೇಗ ಅದು ನಿನಗೆ ಹೇಗೆ ಸಿಕ್ಕಿತು?” ಎಂದನು. ಅವನು, “ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನನ್ನೆದುರಿಗೆ ಅದು ಬರುವಂತೆ ಮಾಡಿದರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ಆಗ ಇಸಾಕನು ಯಾಕೋಬನಿಗೆ, “ನನ್ನ ಮಗನೇ, ನೀನೇ ನನ್ನ ಮಗ ಏಸಾವನು ಹೌದೋ, ಅಲ್ಲವೋ ಎಂದು ನಾನು ನಿನ್ನನ್ನು ಮುಟ್ಟಿನೋಡುವಂತೆ ಹತ್ತಿರ ಬಾ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ಆಗ ಯಾಕೋಬನು ತನ್ನ ತಂದೆ ಇಸಾಕನ ಹತ್ತಿರ ಬಂದನು. ಇಸಾಕನು ಅವನನ್ನು ಮುಟ್ಟಿ, “ಸ್ವರವು ಯಾಕೋಬನ ಸ್ವರವಾಗಿದೆ, ಆದರೆ ಕೈಗಳು ಏಸಾವನ ಕೈಗಳು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ಅವನ ಕೈಗಳು ಅವನ ಅಣ್ಣ ಏಸಾವನ ಕೈಗಳಂತೆ ರೋಮಮಯವಾಗಿ ಇದ್ದುದರಿಂದ, ಅವನು ಯಾರೆಂದು ತಿಳಿಯದೆ, ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ಮತ್ತೆ ಅವನು, “ನೀನು ನನ್ನ ಮಗ ಏಸಾವನೋ?” ಎಂದಾಗ. ಯಾಕೋಬನು, “ನಾನೇ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ಆಗ ಇಸಾಕನು, “ನನ್ನ ಮಗನೇ, ನೀನು ತಂದದ್ದನ್ನು ಕೊಡು, ಊಟಮಾಡಿ, ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು,” ಎಂದನು. ಆಗ ಯಾಕೋಬನು ಅದನ್ನು ಹತ್ತಿರ ತೆಗೆದುಕೊಂಡು ಬಂದಾಗ ಅವನು ಊಟಮಾಡಿದನು. ಅವನು ದ್ರಾಕ್ಷಾರಸವನ್ನು ತಂದಾಗ, ಅದನ್ನು ಕುಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ಅವನ ತಂದೆ ಇಸಾಕನು ಅವನಿಗೆ, “ನನ್ನ ಮಗನೇ, ಹತ್ತಿರ ಬಂದು ನನಗೆ ಮುದ್ದಿಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ಆಗ ಯಾಕೋಬನು ಹತ್ತಿರ ಬಂದು ಮುದ್ದಿಟ್ಟನು. ಇಸಾಕನು ಅವನ ವಸ್ತ್ರಗಳ ವಾಸನೆಯನ್ನು ಮೂಸಿ ನೋಡಿ, ಅವನನ್ನು ಹೀಗೆ ಆಶೀರ್ವದಿಸಿದನು, “ನನ್ನ ಮಗನ ವಾಸನೆಯು ಯೆಹೋವ ದೇವರು ಆಶೀರ್ವದಿಸಿದ ಹೊಲದ ವಾಸನೆಯಂತೆ ಇದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ದೇವರು ನಿನಗೆ ಆಕಾಶದ ಮಂಜನ್ನೂ ಸಾರವುಳ್ಳ ಭೂಮಿಯನ್ನೂ ಸಮೃದ್ಧಿಯಾದ ಧಾನ್ಯವನ್ನೂ ಹೊಸ ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಕೊಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ಜನರು ನಿನಗೆ ಸೇವೆಮಾಡಲಿ, ಜನಾಂಗಗಳು ನಿನಗೆ ಅಡ್ಡಬೀಳಲಿ, ನಿನ್ನ ಸಹೋದರರಿಗೆ ನೀನು ದೊರೆಯಾಗಿರು. ನಿನ್ನ ತಾಯಿಯ ಮಕ್ಕಳು ನಿನಗೆ ಅಡ್ಡಬೀಳಲಿ. ನಿನ್ನನ್ನು ಶಪಿಸುವವರಿಗೆ ಶಾಪವೂ ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವವರಿಗೆ ಆಶೀರ್ವಾದವೂ ಆಗಲಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಆಶೀರ್ವದಿಸಿದ ತರುವಾಯ, ಯಾಕೋಬನು ತನ್ನ ತಂದೆ ಇಸಾಕನ ಸಮ್ಮುಖದಿಂದ ಹೊರಟುಹೋದನು. ಆಮೇಲೆ ಅವನ ಸಹೋದರ ಏಸಾವನು ಬೇಟೆಯಿಂದ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ಅವನೂ ಸಹ ರುಚಿಯಾದ ಊಟವನ್ನು ಸಿದ್ಧಮಾಡಿ, ತನ್ನ ತಂದೆಯ ಬಳಿಗೆ ತಂದು, “ನನ್ನ ತಂದೆಯೇ, ಎದ್ದು ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವಂತೆ ನಿನ್ನ ಮಗನ ಬೇಟೆಯ ಮಾಂಸವನ್ನು ಊಟಮಾಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ಅವನ ತಂದೆ ಇಸಾಕನು ಅವನಿಗೆ, “ನೀನು ಯಾರು?” ಎಂದಾಗ. ಅವನು, “ನಾನು ನಿನ್ನ ಚೊಚ್ಚಲ ಮಗ ಏಸಾವನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ಆಗ ಇಸಾಕನು ಬಹಳವಾಗಿ ನಡುಗುತ್ತಾ, “ನೀನು ಬರುವುದಕ್ಕಿಂತ ಮೊದಲು ಬೇಟೆಯಾಡಿ ನನಗೆ ಊಟ ತಂದವನು ಯಾರು? ಅವನು ಎಲ್ಲಿದ್ದಾನೆ? ನೀನು ಬರುವುದರೊಳಗಾಗಿ ನಾನು ಎಲ್ಲವನ್ನೂ ಊಟಮಾಡಿ ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದೆನು. ಅವನು ಆಶೀರ್ವಾದ ಹೊಂದಿರುವನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ಏಸಾವನು ತನ್ನ ತಂದೆಯ ಮಾತುಗಳನ್ನು ಕೇಳಿದಾಗ, ವ್ಯಥೆಪಟ್ಟು ಗಟ್ಟಿಯಾದ ಸ್ವರದಿಂದ ಅತ್ತನು. ತನ್ನ ತಂದೆಗೆ, “ತಂದೆಯೇ, ನನ್ನನ್ನು ಕೂಡಾ ಆಶೀರ್ವದಿಸು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ಇಸಾಕನು, “ನಿನ್ನ ಸಹೋದರನು ಮೋಸದಿಂದ ಬಂದು ನಿನ್ನ ಆಶೀರ್ವಾದವನ್ನು ತೆಗೆದುಕೊಂಡಿದ್ದಾನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ಅದಕ್ಕೆ ಏಸಾವನು, “ಅವನಿಗೆ ಯಾಕೋಬನೆಂಬ ಹೆಸರು ಸರಿಯಲ್ಲವೋ? ಅವನು ನನ್ನನ್ನು ಎರಡು ಸಾರಿ ವಂಚಿಸಿದ್ದಾನೆ. ಅವನು ನನ್ನ ಚೊಚ್ಚಲತನವನ್ನು ತೆಗೆದುಕೊಂಡಿದ್ದಾನೆ. ಇಗೋ, ಈಗ ನನ್ನ ಆಶೀರ್ವಾದವನ್ನೂ ತೆಗೆದುಕೊಂಡಿದ್ದಾನೆ. ನೀನು ನನಗೋಸ್ಕರ ಒಂದಾದರೂ ಆಶೀರ್ವಾದವನ್ನು ಉಳಿಸಲಿಲ್ಲವೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ಇಸಾಕನು ಉತ್ತರವಾಗಿ ಏಸಾವನಿಗೆ, “ಅವನನ್ನು ನಿನಗೆ ದೊರೆಯನನ್ನಾಗಿ ನೇಮಿಸಿದ್ದೇನೆ, ಅವನ ಸಹೋದರರೆಲ್ಲರನ್ನೂ ಅವನಿಗೆ ಸೇವಕರನ್ನಾಗಿ ಕೊಟ್ಟು, ಧಾನ್ಯದಿಂದಲೂ ಹೊಸ ದ್ರಾಕ್ಷಾರಸದಿಂದಲೂ ಅವನನ್ನು ಪೋಷಿಸಿದ್ದೇನೆ. ಈಗ ನನ್ನ ಮಗನೇ, ನಿನಗೆ ನಾನು ಏನು ಮಾಡಲಿ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ಏಸಾವನು ತನ್ನ ತಂದೆಗೆ, “ನನ್ನ ತಂದೆಯೇ, ಆ ಒಂದೇ ಆಶೀರ್ವಾದವು ನಿನಗೆ ಇದೆಯೋ? ತಂದೆಯೇ, ನನ್ನನ್ನೂ ಆಶೀರ್ವದಿಸು,” ಎಂದು ಅವನು ಗಟ್ಟಿಯಾಗಿ ಕೂಗಿ ಅತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ಆಗ ಅವನ ತಂದೆ ಇಸಾಕನು ಉತ್ತರವಾಗಿ ಅವನಿಗೆ ಹೀಗೆ ಹೇಳಿದನು, “ನಿನ್ನ ನಿವಾಸವು ಭೂಮಿಯ ಐಶ್ವರ್ಯದಿಂದಲೂ ಮೇಲಿನ ಆಕಾಶದಿಂದ ಬೀಳುವ ಮಂಜಿನಿಂದಲೂ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ನೀನು ಖಡ್ಗದಿಂದಲೇ ಬದುಕುವೆ, ನಿನ್ನ ಸಹೋದರರನ್ನು ನೀನು ಸೇವೆಮಾಡುವೆ, ಆದರೆ ನಿನ್ನ ತಾಳ್ಮೆ ತಪ್ಪಿದಾಗ, ಅವನ ನೊಗವನ್ನು ನಿನ್ನ ಕೊರಳಿನಿಂದ ಮುರಿದುಹಾಕುವೆ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ಏಸಾವನು ತನ್ನ ತಂದೆಯು ಅವನಿಗೆ ಕೊಟ್ಟ ಆಶೀರ್ವಾದಕ್ಕೋಸ್ಕರ ಯಾಕೋಬನನ್ನು ದ್ವೇಷಿಸಿದನು. ಏಸಾವನು, “ನನ್ನ ತಂದೆಗೋಸ್ಕರ ದುಃಖಪಡುವ ದಿನಗಳು ಸಮೀಪವಾಗಿವೆ. ತರುವಾಯ ನಾನು ನನ್ನ ಸಹೋದರ ಯಾಕೋಬನನ್ನು ಕೊಲ್ಲುವೆನು,” ಎಂದು ತನ್ನಲ್ಲಿಯೇ ಅಂದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ರೆಬೆಕ್ಕಳಿಗೆ ತನ್ನ ಹಿರಿಯ ಮಗ ಏಸಾವನ ಬಗ್ಗೆ ಗ್ರಹಿಸಿದಾಗ, ಆಕೆಯು ತನ್ನ ಕಿರಿಯ ಮಗ ಯಾಕೋಬನನ್ನು ಕರೆದು ಅವನಿಗೆ, “ನಿನ್ನ ಸಹೋದರ ಏಸಾವನು ನಿನ್ನನ್ನು ಕೊಂದು, ತನ್ನನ್ನು ಸಂತೈಸಿಕೊಳ್ಳುವುದಕ್ಕಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ಆದ್ದರಿಂದ ಈಗ ನನ್ನ ಮಗನೇ, ನನ್ನ ಮಾತಿಗೆ ವಿಧೇಯನಾಗು. ಎದ್ದು ಹಾರಾನಿನಲ್ಲಿರುವ ನನ್ನ ಸಹೋದರ ಲಾಬಾನನ ಬಳಿಗೆ ಓಡಿಹೋಗು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ನಿನ್ನ ಸಹೋದರನ ಕೋಪವು ತೀರುವವರೆಗೆ ಕೆಲವು ದಿವಸಗಳು ಅಲ್ಲೇ ಇರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ನಿನ್ನ ಕಡೆಗಿರುವ ನಿನ್ನ ಸಹೋದರನ ಕೋಪವು ತೀರಿಹೋಗಿ, ನೀನು ಅವನಿಗೆ ಮಾಡಿದ್ದನ್ನು ಅವನು ಮರೆಯುವವರೆಗೆ ನೀನು ಅಲ್ಲೇ ಇರು. ತರುವಾಯ ನಾನು ನಿನ್ನನ್ನು ಅಲ್ಲಿಂದ ಕರೆಸಿಕೊಳ್ಳುವೆನು. ಒಂದೇ ದಿನದಲ್ಲಿ ನಾನು ನಿಮ್ಮಿಬ್ಬರನ್ನೂ ಕಳೆದುಕೊಳ್ಳುವುದು ಏಕೆ?” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ರೆಬೆಕ್ಕಳು ಇಸಾಕನಿಗೆ, “ಹಿತ್ತಿಯ ಸ್ತ್ರೀಯರ ದೆಸೆಯಿಂದ ನನ್ನ ಜೀವ ನನಗೆ ಬೇಸರವಾಗಿದೆ. ಇಂಥ ಹಿತ್ತಿಯ ಸ್ತ್ರೀಯರಲ್ಲಿ ಒಬ್ಬಳನ್ನು ತನ್ನ ಹೆಂಡತಿಯಾಗಿ ಯಾಕೋಬನು ಮದುವೆ ಮಾಡಿಕೊಂಡರೆ, ನಾನು ಬದುಕಿರುವುದು ವ್ಯರ್ಥ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಕರೆದು ಆಶೀರ್ವದಿಸಿ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, “ಕಾನಾನ್ಯರ ಸ್ತ್ರೀಯರನ್ನು ನೀನು ಮದುವೆಯಾಗಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ಕೂಡಲೇ ನಿನ್ನ ತಾಯಿಯ ತಂದೆ ಬೆತೂಯೇಲನು ಇರುವ ಪದ್ದನ್ ಅರಾಮಿಗೆ ಹೋಗು. ನಿನ್ನ ತಾಯಿಯ ಸಹೋದರ ಲಾಬಾನನ ಹೆಣ್ಣುಮಕ್ಕಳಲ್ಲಿ ಒಬ್ಬಳನ್ನು ಹೆಂಡತಿಯನ್ನಾಗಿ ಮಾಡಿಕೋ. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ಸರ್ವಶಕ್ತ ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿ, ನೀನು ದೊಡ್ಡ ಸಮುದಾಯವಾಗುವಂತೆ ನಿನ್ನನ್ನು ಅಭಿವೃದ್ಧಿ ಮಾಡಿ ಹೆಚ್ಚಿಸಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ ಕೊಟ್ಟಿರುವ ಮತ್ತು ನೀನು ಈಗ ಪ್ರವಾಸಿಯಾಗಿರುವ ದೇಶವನ್ನು ನೀನು ಬಾಧ್ಯವಾಗಿ ಹೊಂದುವಂತೆ ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿ, ನಿನಗೂ, ನಿನ್ನ ಸಂತತಿಗೂ ಕೊಡಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಕಳುಹಿಸಿದಾಗ, ಅವನು ಪದ್ದನ್ ಅರಾಮಿನಲ್ಲಿದ್ದ ಯಾಕೋಬನ ಮತ್ತು ಏಸಾವನ ತಾಯಿ ರೆಬೆಕ್ಕಳ ಸಹೋದರ ಅರಾಮಿನವನಾದ ಬೆತೂಯೇಲನ ಮಗನಾಗಿದ್ದ ಲಾಬಾನನ ಬಳಿಗೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಆಶೀರ್ವದಿಸಿ, ಅವನಿಗೆ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳುವುದಕ್ಕೆ ಪದ್ದನ್ ಅರಾಮಿಗೆ ಕಳುಹಿಸಿದ್ದನ್ನೂ, ಇಸಾಕನು ಅವನನ್ನು ಆಶೀರ್ವದಿಸುತ್ತಿದ್ದಾಗ, ಅವನಿಗೆ, “ಕಾನಾನ್ಯರ ಪುತ್ರಿಯರಲ್ಲಿ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಾರದು,” ಎಂದು ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೂ, ಏಸಾವನು ತಿಳಿದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ಯಾಕೋಬನು ತನ್ನ ತಂದೆತಾಯಿಗಳ ಮಾತಿಗೆ ವಿಧೇಯನಾಗಿ, ಪದ್ದನ್ ಅರಾಮಿಗೆ ಹೋದದ್ದನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ಕಾನಾನ್ಯರ ಪುತ್ರಿಯರು ತನ್ನ ತಂದೆ ಇಸಾಕನಿಗೆ ಮೆಚ್ಚಿಗೆಯಾಗಲಿಲ್ಲವೆಂದು ಏಸಾವನು ತಿಳಿದು, ");
INSERT INTO kanokcv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ಅವನು ಇಷ್ಮಾಯೇಲನ ಬಳಿಗೆ ಹೋಗಿ, ತನಗಿದ್ದ ಹೆಂಡತಿಯರಲ್ಲದೆ ಅಬ್ರಹಾಮನ ಮಗ ಇಷ್ಮಾಯೇಲನ ಮಗಳೂ, ನೆಬಾಯೋತನ ತಂಗಿಯೂ ಆಗಿರುವ ಮಹಲತ್ ಎಂಬವಳನ್ನೂ ಮದುವೆಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ಆಗ ಯಾಕೋಬನು ಬೇರ್ಷೆಬದಿಂದ ಹಾರಾನಿನ ಕಡೆಗೆ ಹೊರಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ಅವನು ಒಂದು ಸ್ಥಳಕ್ಕೆ ಸೇರಿದಾಗ, ಸೂರ್ಯಾಸ್ತಮವಾದದ್ದರಿಂದ ಅಲ್ಲಿ ಉಳಿದುಕೊಂಡನು. ಅವನು ಅಲ್ಲಿದ್ದ ಕಲ್ಲುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದು ತಲೆ ದಿಂಬನ್ನಾಗಿ ಇಟ್ಟುಕೊಂಡು, ಆ ಸ್ಥಳದಲ್ಲಿ ಮಲಗಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ಆಗ ಅವನು ಒಂದು ಕನಸುಕಂಡನು. ಏಣಿಯು ಭೂಮಿಯ ಮೇಲೆ ನಿಂತಿತ್ತು. ಅದರ ತುದಿಯು ಪರಲೋಕಕ್ಕೆ ಮುಟ್ಟಿತ್ತು. ದೇವದೂತರು ಅದರ ಮೇಲೆ ಏರುತ್ತಾ ಇಳಿಯುತ್ತಾ ಇದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ಅದರ ಮೇಲೆ ನಿಂತುಕೊಂಡು, “ನಿನ್ನ ತಂದೆ ಅಬ್ರಹಾಮನ ದೇವರೂ, ಇಸಾಕನ ದೇವರೂ ಆದ ಯೆಹೋವ ದೇವರು ನಾನೇ. ನೀನು ಮಲಗಿರುವ ಭೂಮಿಯನ್ನು ನಿನಗೂ, ನಿನ್ನ ಸಂತತಿಗೂ ಕೊಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ನಿನ್ನ ಸಂತತಿಯು ಭೂಮಿಯ ಧೂಳಿನಂತೆ ಅಸಂಖ್ಯವಾಗುವುದು. ನೀನು ಪೂರ್ವ, ಪಶ್ಚಿಮ, ದಕ್ಷಿಣೋತ್ತರಗಳಿಗೆ ಹರಡಿಕೊಳ್ಳುವೆ. ನಿನ್ನಿಂದಲೂ ನಿನ್ನ ಸಂತತಿಯಿಂದಲೂ ಭೂಮಿಯ ಎಲ್ಲಾ ಜನರು ಆಶೀರ್ವಾದ ಹೊಂದುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ಇಗೋ, ನಾನು ನಿನ್ನ ಸಂಗಡ ಇದ್ದು, ನೀನು ಹೋಗುವಲ್ಲೆಲ್ಲಾ ನಿನ್ನನ್ನು ಕಾಪಾಡಿ, ಈ ದೇಶಕ್ಕೆ ನಿನ್ನನ್ನು ತಿರುಗಿ ಬರಮಾಡುವೆನು. ಏಕೆಂದರೆ ನಾನು ನಿನಗೆ ಹೇಳಿದ್ದನ್ನು ಮಾಡುವವರೆಗೆ ನಿನ್ನನ್ನು ಬಿಡುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ತರುವಾಯ ಯಾಕೋಬನು ನಿದ್ರೆಯಿಂದ ಎಚ್ಚೆತ್ತು, “ನಿಶ್ಚಯವಾಗಿ ಈ ಸ್ಥಳದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಇದ್ದಾರೆ. ಇದನ್ನು ನಾನು ಅರಿಯಲಿಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ಅವನು ಭಯಪಟ್ಟು, “ಈ ಸ್ಥಳವು ಎಷ್ಟೋ ಗಂಭೀರವಾದದ್ದು, ಇದು ದೇವರ ಮನೆಯೇ ಹೊರತು ಬೇರೆಯಲ್ಲ. ಇದೇ ಪರಲೋಕದ ಬಾಗಿಲು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ಯಾಕೋಬನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು, ತಾನು ತಲೆದಿಂಬಾಗಿ ಇಟ್ಟುಕೊಂಡಿದ್ದ ಕಲ್ಲನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದನ್ನು ಸ್ತಂಭವಾಗಿ ನೆಟ್ಟು, ಅದರ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಹೊಯ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ಇದಲ್ಲದೆ ಅವನು ಆ ಸ್ಥಳಕ್ಕೆ, ಬೇತೇಲ್, ಎಂದು ಹೆಸರಿಟ್ಟನು. ಅದಕ್ಕಿಂತ ಮೊದಲು ಆ ಸ್ಥಳಕ್ಕೆ, ಲೂಜ್ ಎಂದು ಹೆಸರಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ಆಗ ಯಾಕೋಬನು ಪ್ರಮಾಣಮಾಡಿ, “ದೇವರು ನನ್ನ ಸಂಗಡ ಇದ್ದು, ನಾನು ಹೋಗುವ ಈ ಮಾರ್ಗದಲ್ಲಿ ನನ್ನನ್ನು ಕಾಪಾಡಿ, ಉಣ್ಣುವುದಕ್ಕೆ ಆಹಾರವನ್ನೂ, ಉಡುವುದಕ್ಕೆ ವಸ್ತ್ರವನ್ನೂ ನನಗೆ ಕೊಟ್ಟು, ");
INSERT INTO kanokcv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ನನ್ನನ್ನು ಸಮಾಧಾನವಾಗಿ ನನ್ನ ತಂದೆಯ ಮನೆಗೆ ತಿರುಗಿ ಬರಮಾಡಿದರೆ, ಯೆಹೋವ ನನಗೆ ದೇವರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ಇದಲ್ಲದೆ ಸ್ತಂಭವಾಗಿ ನಾನು ನಿಲ್ಲಿಸಿದ ಈ ಕಲ್ಲು ದೇವರ ಮನೆಯಾಗಿರುವುದು. ಆಗ ದೇವರು ನನಗೆ ಕೊಡುವುದರಲ್ಲೆಲ್ಲಾ ಹತ್ತರಲ್ಲಿ ಒಂದು ಭಾಗವನ್ನು ದೇವರಿಗೆ ನಾನು ಖಂಡಿತವಾಗಿ ಕೊಡುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ಆಗ ಯಾಕೋಬನು ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರಿಸುತ್ತಾ ಪೂರ್ವದಿಕ್ಕಿನ ಜನರ ದೇಶಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ಅವನು ಕಣ್ಣೆತ್ತಿ ನೋಡಲಾಗಿ, ಹೊಲದಲ್ಲಿ ಒಂದು ಬಾವಿ ಇತ್ತು. ಅದರ ಸಮೀಪದಲ್ಲಿ ಮೂರು ಕುರಿಮಂದೆಗಳು ಮಲಗಿದ್ದವು. ಏಕೆಂದರೆ ಆ ಬಾವಿಯ ನೀರನ್ನು ಮಂದೆಗಳಿಗೆ ಕುಡಿಸುತ್ತಿದ್ದರು. ಆ ಬಾವಿಯ ಮೇಲೆ ಒಂದು ದೊಡ್ಡ ಕಲ್ಲು ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ಅಲ್ಲಿ ಮಂದೆಗಳೆಲ್ಲಾ ಕೂಡಿದಾಗ, ಬಾವಿಯ ಮೇಲಿದ್ದ ಕಲ್ಲನ್ನು ಉರುಳಿಸಿ, ಕುರಿಗಳಿಗೆ ನೀರನ್ನು ಕುಡಿಸಿ, ಕಲ್ಲನ್ನು ಮತ್ತೆ ಅದರ ಸ್ಥಳದಲ್ಲಿ ಇಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ಯಾಕೋಬನು ಅವರಿಗೆ, “ನನ್ನ ಸಹೋದರರೇ, ನೀವು ಎಲ್ಲಿಯವರು?” ಎಂದಾಗ. ಅವರು, “ನಾವು ಹಾರಾನಿನವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ಅದಕ್ಕವನು ಅವರಿಗೆ, “ನಾಹೋರನ ಮೊಮ್ಮಗ ಲಾಬಾನನನ್ನು ನೀವು ಬಲ್ಲಿರೋ?” ಎಂದಾಗ. ಅವರು, “ನಾವು ಅವನನ್ನು ಬಲ್ಲೆವು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ಯಾಕೋಬನು ಅವರಿಗೆ, “ಅವನು ಕ್ಷೇಮವಾಗಿದ್ದಾನೋ?” ಎಂದು ಕೇಳಿದಾಗ, ಆಗ ಅವರು, “ಕ್ಷೇಮವಾಗಿದ್ದಾನೆ, ಅಗೋ, ಅವನ ಮಗಳಾದ ರಾಹೇಲಳು ಕುರಿಗಳ ಸಂಗಡ ಬರುತ್ತಿದ್ದಾಳೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ಯಾಕೋಬನು ಅವರಿಗೆ, “ಇನ್ನೂ ಬಹಳ ಹೊತ್ತು ಇದೆ. ಮಂದೆಗಳನ್ನು ಕೂಡಿಸುವ ಸಮಯವು ಇದಲ್ಲ. ಕುರಿಗಳಿಗೆ ನೀರು ಕುಡಿಸಿ ಹೋಗಿ ಮೇಯಿಸಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ಅದಕ್ಕೆ ಅವರು, “ಮಂದೆಗಳನ್ನೆಲ್ಲಾ ಒಟ್ಟುಗೂಡಿಸಿದ ಮೇಲೆ ಬಾವಿಯ ಮೇಲಿರುವ ಕಲ್ಲನ್ನು ಉರುಳಿಸುತ್ತಾರೆ. ಆಗ ನಾವು ಕುರಿಗಳಿಗೆ ನೀರನ್ನು ಕುಡಿಸುತ್ತೇವೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ಯಾಕೋಬನು ಇನ್ನೂ ಅವರ ಸಂಗಡ ಮಾತನಾಡುತ್ತಿದ್ದಾಗ, ಕುರಿಗಳನ್ನು ಮೇಯಿಸುವ ರಾಹೇಲಳು ತನ್ನ ತಂದೆಯ ಕುರಿಗಳ ಸಂಗಡ ಬಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ಯಾಕೋಬನು ತನ್ನ ತಾಯಿಯ ಸಹೋದರ ಲಾಬಾನನ ಮಗಳಾದ ರಾಹೇಲಳನ್ನೂ, ಅವಳ ಕುರಿಗಳನ್ನೂ ನೋಡಿದಾಗ, ಯಾಕೋಬನು ಹತ್ತಿರ ಬಂದು, ಬಾವಿಯ ಮೇಲಿದ್ದ ಕಲ್ಲನ್ನು ಹೊರಳಿಸಿ, ತನ್ನ ತಾಯಿಯ ಸಹೋದರನಾದ ಲಾಬಾನನ ಕುರಿಗಳಿಗೆ ನೀರನ್ನು ಕುಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ಆಗ ಯಾಕೋಬನು ರಾಹೇಲಳಿಗೆ ಮುದ್ದಿಟ್ಟು, ತನ್ನ ಸ್ವರವನ್ನೆತ್ತಿ ಗಟ್ಟಿಯಾಗಿ ಅತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ಯಾಕೋಬನು ರಾಹೇಲಳಿಗೆ, ತಾನು ಆಕೆಯ ತಂದೆಗೆ ಸೋದರಳಿಯನೆಂದೂ ರೆಬೆಕ್ಕಳ ಮಗನೆಂದೂ ತಿಳಿಸಿದನು. ಆಗ ಆಕೆಯು ಓಡಿಹೋಗಿ ತನ್ನ ತಂದೆಗೆ ತಿಳಿಸಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ಲಾಬಾನನು ತನ್ನ ಸಹೋದರಿಯ ಮಗ ಯಾಕೋಬನ ಸುದ್ದಿಯನ್ನು ಕೇಳಿದಾಗ, ಅವನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಓಡಿಬಂದು ಅವನನ್ನು ಅಪ್ಪಿಕೊಂಡು ಮುದ್ದಿಟ್ಟನು. ಅವನನ್ನು ಮನೆಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ಅವನು ಲಾಬಾನನಿಗೆ ಎಲ್ಲಾ ವಿಷಯಗಳನ್ನು ತಿಳಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ಆಗ ಲಾಬಾನನು ಅವನಿಗೆ, “ನಿಶ್ಚಯವಾಗಿ ನೀನು ನನ್ನ ರಕ್ತಸಂಬಂಧಿಯಾಗಿದ್ದೀ,” ಎಂದನು. ಯಾಕೋಬನು ಅವನ ಸಂಗಡ ಒಂದು ತಿಂಗಳು ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ನೀನು ನನ್ನ ಸಂಬಂಧಿಕನಾಗಿರುವುದರಿಂದ ಸುಮ್ಮನೆ ನನಗೆ ಸೇವೆ ಮಾಡಬೇಕೆ? ನಿನ್ನ ಸಂಬಳ ಎಷ್ಟೆಂಬುದನ್ನು ನನಗೆ ಹೇಳು?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ಲಾಬಾನನಿಗೆ ಇಬ್ಬರು ಪುತ್ರಿಯರಿದ್ದರು. ದೊಡ್ಡವಳ ಹೆಸರು ಲೇಯಳು, ಚಿಕ್ಕವಳ ಹೆಸರು ರಾಹೇಲಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ಲೇಯಳ ಕಣ್ಣುಗಳು ಕಾಂತಿಹೀನವಾಗಿದ್ದವು. ಆದರೆ ರಾಹೇಲಳು ಸುಂದರಿಯೂ ರೂಪವತಿಯೂ ಆಗಿದ್ದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ಹೀಗಿರುವುದರಿಂದ ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನು ಪ್ರೀತಿಸಿ, “ನಾನು ನಿನ್ನ ಕಿರಿ ಮಗಳಾಗಿರುವ ರಾಹೇಲಳಿಗೋಸ್ಕರ ನಿಮ್ಮಲ್ಲಿ ಏಳು ವರ್ಷ ಸೇವೆ ಮಾಡುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ಅದಕ್ಕೆ ಲಾಬಾನನು, “ಅವಳನ್ನು ಬೇರೊಬ್ಬನಿಗೆ ಕೊಡುವುದಕ್ಕಿಂತ, ನಿನಗೆ ಕೊಡುವುದು ಒಳ್ಳೆಯದು. ಆದ್ದರಿಂದ ನನ್ನ ಸಂಗಡವಿರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ಈ ಪ್ರಕಾರ ಯಾಕೋಬನು ರಾಹೇಲಳಿಗೋಸ್ಕರ ಏಳು ವರ್ಷ ಸೇವೆ ಮಾಡಿದನು. ಅವನು ಆಕೆಯನ್ನು ಪ್ರೀತಿಮಾಡಿದ್ದರಿಂದ ಏಳು ವರ್ಷಗಳು ಅವನಿಗೆ ಸ್ವಲ್ಪದಿನಗಳಾಗಿ ತೋರಿದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ತರುವಾಯ ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ನನ್ನ ಸೇವಾ ದಿನಗಳು ಪೂರ್ತಿಯಾದವು. ನಾನು ನನ್ನ ಹೆಂಡತಿಯೊಂದಿಗೆ ಬಾಳುವಂತೆ ಆಕೆಯನ್ನು ನನಗೆ ಕೊಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ಆಗ ಲಾಬಾನನು ಆ ಸ್ಥಳದ ಮನುಷ್ಯರನ್ನೆಲ್ಲಾ ಕೂಡಿಸಿ ಔತಣ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ರಾತ್ರಿಯಾದಾಗ ಅವನು ತನ್ನ ಮಗಳಾದ ಲೇಯಳನ್ನು ಯಾಕೋಬನ ಬಳಿಗೆ ಕರೆತಂದನು. ಆಗ ಅವನು ಲೇಯಳ ಬಳಿಗೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ಇದಲ್ಲದೆ ಲಾಬಾನನು ತನ್ನ ದಾಸಿಯಾದ ಜಿಲ್ಪಳನ್ನು, ತನ್ನ ಮಗಳಾದ ಲೇಯಳಿಗೆ ದಾಸಿಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ಬೆಳಿಗ್ಗೆ ನೋಡಲಾಗಿ ಆಕೆಯು ಲೇಯಳಾಗಿದ್ದಳು. ಆಗ ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ಇದೇನು ನೀನು ನನಗೆ ಮಾಡಿದೆ? ರಾಹೇಲಳಿಗೋಸ್ಕರ ನಾನು ನಿನಗೆ ಸೇವೆಮಾಡಿದೆನಲ್ಲಾ? ಏಕೆ ನನಗೆ ಮೋಸಮಾಡಿದೆ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ಅದಕ್ಕೆ ಲಾಬಾನನು, “ಹಿರಿಯಳಿಗಿಂತ ಮೊದಲು ಕಿರಿಯಳನ್ನು ಮದುವೆ ಮಾಡಿಕೊಡುವುದು ನಮ್ಮ ಪದ್ಧತಿಯಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ಹಿರಿಯಳೊಡನೆ ಈ ವಾರವನ್ನು ಪೂರೈಸು. ತರುವಾಯ ನೀನು ಇನ್ನು ಬೇರೆ ಏಳು ವರ್ಷಗಳವರೆಗೆ ಸೇವೆ ಮಾಡಲು ಒಪ್ಪಿಕೊಂಡರೆ, ನಾನು ಕಿರಿಯ ಮಗಳನ್ನು ನಿನಗೆ ಕೊಡುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ಯಾಕೋಬನು ಅದರಂತೆ ಮಾಡಿ, ವಾರವನ್ನು ಪೂರೈಸಿದನು. ಆಗ ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ರಾಹೇಲಳನ್ನು ಅವನಿಗೆ ಹೆಂಡತಿಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ರಾಹೇಲಳಿಗೆ, ತನ್ನ ದಾಸಿಯಾದ ಬಿಲ್ಹಳನ್ನು ದಾಸಿಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ಯಾಕೋಬನು ರಾಹೇಲಳೊಂದಿಗೆ ಕೂಡಿ, ಲೇಯಳಿಗಿಂತ ರಾಹೇಲಳನ್ನು ಹೆಚ್ಚು ಪ್ರೀತಿಸಿದನು. ಇನ್ನೂ ಏಳು ವರ್ಷ ಲಾಬಾನನ ಬಳಿಯಲ್ಲಿ ಸೇವೆ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ಲೇಯಳು ತಾತ್ಸಾರಕ್ಕೆ ತುತ್ತಾಗುವಳೆಂದು ಯೆಹೋವ ದೇವರು ಕಂಡು, ಅವಳು ಗರ್ಭಿಣಿಯಾಗುವಂತೆ ಅನುಗ್ರಹಮಾಡಿದರು. ಆದರೆ ರಾಹೇಲಳು ಬಂಜೆಯಾಗಿದ್ದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ಲೇಯಳು ಗರ್ಭಿಣಿಯಾಗಿ ಮಗನನ್ನು ಹೆತ್ತು, “ನಿಜವಾಗಿ ಯೆಹೋವ ದೇವರು ನನ್ನ ಬಾಧೆಯನ್ನು ನೋಡಿದ್ದಾರೆ. ಆದ್ದರಿಂದ ನನ್ನ ಗಂಡನು ನನ್ನನ್ನು ಪ್ರೀತಿ ಮಾಡುವನು,” ಎಂದು ಹೇಳಿ ಮಗುವಿಗೆ ರೂಬೇನ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ಲೇಯಳು ಮತ್ತೆ ಗರ್ಭಿಣಿಯಾಗಿ ಮಗನನ್ನು ಹೆತ್ತು, “ನಾನು ತಾತ್ಸಾರವಾಗಿದ್ದೆ ಎಂದು ಯೆಹೋವ ದೇವರು ಕೇಳಿ, ಇವನನ್ನು ನನಗೆ ಕೊಟ್ಟಿದ್ದಾರೆ,” ಎಂದು ಹೇಳಿ ಅವನಿಗೆ ಸಿಮೆಯೋನ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ಮತ್ತೊಮ್ಮೆ ಲೇಯಳು ಮಗನನ್ನು ಹೆತ್ತು, “ಈಗಲಾದರೂ ನನ್ನ ಗಂಡನು ನನ್ನೊಂದಿಗೆ ಒಂದಾಗುವನು. ಏಕೆಂದರೆ ನಾನು ಅವನಿಗೆ ಮೂರು ಪುತ್ರರನ್ನು ಹೆತ್ತಿದ್ದೇನೆ,” ಎಂದು ಹೇಳಿ, ಆ ಮಗುವಿಗೆ ಲೇವಿ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ಆಕೆಯು ಮತ್ತೆ ಗರ್ಭಿಣಿಯಾಗಿ ಮಗನನ್ನು ಹೆತ್ತು, “ಈಗ ನಾನು ಯೆಹೋವ ದೇವರನ್ನು ಸ್ತುತಿಸುವೆನು,” ಎಂದು ಹೇಳಿ, ಅವನಿಗೆ ಯೆಹೂದ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಆಮೇಲೆ ಆಕೆಗೆ ಮಕ್ಕಳಾಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ರಾಹೇಲಳು ತಾನು ಯಾಕೋಬನಿಗೆ ಮಕ್ಕಳನ್ನು ಹೆರಲಿಲ್ಲ ಎಂದು ತಿಳಿದಾಗ, ಆಕೆಯು ತನ್ನ ಸಹೋದರಿಯ ಮೇಲೆ ಹೊಟ್ಟೆಕಿಚ್ಚು ಪಟ್ಟು ಯಾಕೋಬನಿಗೆ, “ನನಗೆ ಮಕ್ಕಳನ್ನು ಕೊಡು, ಇಲ್ಲದಿದ್ದರೆ ನಾನು ಸಾಯುತ್ತೇನೆ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ಅದಕ್ಕೆ ಯಾಕೋಬನು ರಾಹೇಲಳ ಮೇಲೆ ಕೋಪಿಸಿಕೊಂಡು, “ನಿನಗೆ ಗರ್ಭ ಫಲವನ್ನು ಕೊಡುವ ದೇವರ ಸ್ಥಾನದಲ್ಲಿ ನಾನಿದ್ದೇನೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ಅದಕ್ಕೆ ಆಕೆಯು, “ನನ್ನ ದಾಸಿ ಬಿಲ್ಹಳು ಇದ್ದಾಳೆ, ಅವಳ ಬಳಿಗೆ ಹೋಗು, ಅವಳು ಹೆತ್ತು ನನ್ನ ಮಡಿಲಲ್ಲಿ ಇಡಲಿ. ಅವಳಿಂದ ನನಗೆ ಮಕ್ಕಳಾಗುವರು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ಹೀಗೆ ಅವನಿಗೆ ತನ್ನ ದಾಸಿ ಬಿಲ್ಹಳನ್ನು ಕೊಟ್ಟಳು. ಯಾಕೋಬನು ಅವಳನ್ನು ಸ್ವೀಕರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ಬಿಲ್ಹಳು ಗರ್ಭಿಣಿಯಾಗಿ, ಯಾಕೋಬನಿಗೆ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ರಾಹೇಲಳು, “ದೇವರು ನನಗೆ ನ್ಯಾಯತೀರಿಸಿ, ನನ್ನ ಸ್ವರವನ್ನು ಕೇಳಿ, ನನಗೆ ಮಗನನ್ನು ಕೊಟ್ಟಿದ್ದಾರೆ,” ಎಂದು ಹೇಳಿದಳು. ಆದ್ದರಿಂದ ಆಕೆಯು ಅವನಿಗೆ ದಾನ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ರಾಹೇಲಳ ದಾಸಿ ಬಿಲ್ಹಳು ಮತ್ತೆ ಗರ್ಭಿಣಿಯಾಗಿ, ಯಾಕೋಬನಿಗೆ ಎರಡನೆಯ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ಆಗ ರಾಹೇಲಳು, “ಅಧಿಕವಾದ ಹೋರಾಟಗಳಿಂದ ನನ್ನ ಸಹೋದರಿಯ ಸಂಗಡ ಹೋರಾಡಿ ಜಯಿಸಿದ್ದೇನೆ,” ಎಂದು ಹೇಳಿ ಅವನಿಗೆ ನಫ್ತಾಲಿ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ಲೇಯಳು ತಾನು ಹೆರುವುದು ನಿಂತಿತೆಂದು ತಿಳಿದು, ತನ್ನ ದಾಸಿ ಜಿಲ್ಪಳನ್ನು ಯಾಕೋಬನಿಗೆ ಹೆಂಡತಿಯಾಗಿ ಕೊಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ಲೇಯಳ ದಾಸಿ ಜಿಲ್ಪಳು ಯಾಕೋಬನಿಗೆ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ಆಗ ಲೇಯಳು, “ಎಂಥಾ ಸೌಭಾಗ್ಯ,” ಎಂದು ಹೇಳಿ ಅವನಿಗೆ ಗಾದ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ಲೇಯಳ ದಾಸಿ ಜಿಲ್ಪಳು ಯಾಕೋಬನಿಗೆ ಎರಡನೆಯ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ಆಗ ಲೇಯಳು, “ನಾನು ಧನ್ಯಳಾದೆನು, ಏಕೆಂದರೆ ಸ್ತ್ರೀಯರು ನನ್ನನ್ನು ಧನ್ಯಳೆಂದು ಕರೆಯುವರು,” ಎಂದು ಹೇಳಿ ಅವನಿಗೆ ಆಶೇರ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ರೂಬೇನನು ಗೋಧಿ ಕೊಯ್ಯುವ ಕಾಲದಲ್ಲಿ ಹೋಗಿ, ಹೊಲದಲ್ಲಿ ದುದಾಯಿ ಫಲಗಳನ್ನು ಕಂಡು, ತಾಯಿ ಲೇಯಳ ಬಳಿಗೆ ಕೆಲವು ಫಲಗಳನ್ನು ತಂದಾಗ, ರಾಹೇಲಳು ಲೇಯಳಿಗೆ, “ನಿನ್ನ ಮಗನು ತಂದ ಫಲಗಳಲ್ಲಿ ಕೆಲವನ್ನು ನನಗೆ ಕೊಡು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ಅದಕ್ಕೆ ಆಕೆಯು, “ನೀನು ನನ್ನ ಗಂಡನನ್ನು ತೆಗೆದುಕೊಂಡದ್ದು ಅಲ್ಪಕಾರ್ಯವೋ? ನೀನು ಈಗ ನನ್ನ ಮಗನು ತಂದ ದುದಾಯ ಫಲಗಳನ್ನು ಸಹ ತೆಗೆದುಕೊಳ್ಳುವಿಯೋ?” ಎಂದಳು. ಅದಕ್ಕೆ ರಾಹೇಲಳು, “ನಿನ್ನ ಮಗನು ತಂದ ದುದಾಯ ಫಲಗಳಿಗೋಸ್ಕರ ಯಾಕೋಬನು ಈ ರಾತ್ರಿ ನಿನ್ನ ಸಂಗಡ ಮಲಗಲಿ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ಯಾಕೋಬನು ಸಾಯಂಕಾಲದಲ್ಲಿ ಹೊಲದಿಂದ ಬಂದಾಗ, ಲೇಯಳು ಅವನೆದುರಿಗೆ ಹೋಗಿ, “ನೀನು ನನ್ನ ಬಳಿಗೆ ಬರಬೇಕು. ನನ್ನ ಮಗನು ತಂದ ದುದಾಯಿ ಫಲಗಳನ್ನು ಕೊಟ್ಟು ನಿನ್ನನ್ನು ಸಂಪಾದಿಸಿಕೊಂಡಿದ್ದೇನೆ,” ಎಂದಳು. ಆದ್ದರಿಂದ ಅವನು ಆ ರಾತ್ರಿಯಲ್ಲಿ ಆಕೆಯ ಸಂಗಡ ಮಲಗಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ಆಗ ದೇವರು ಲೇಯಳ ಪ್ರಾರ್ಥನೆಯನ್ನು ಕೇಳಿದ್ದರಿಂದ, ಆಕೆಯು ಗರ್ಭಿಣಿಯಾಗಿ ಯಾಕೋಬನಿಗೆ ಐದನೆಯ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ಲೇಯಳು, “ನಾನು ನನ್ನ ಗಂಡನಿಗೆ ನನ್ನ ದಾಸಿಯನ್ನು ಕೊಟ್ಟಿದ್ದರಿಂದ ದೇವರು ನನಗೆ ಪ್ರತಿಫಲವನ್ನು ಕೊಟ್ಟಿದ್ದಾರೆ,” ಎಂದು ಹೇಳಿ, ಅವನಿಗೆ ಇಸ್ಸಾಕಾರ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ಮತ್ತೊಂದು ಸಾರಿ ಲೇಯಳು ಗರ್ಭಿಣಿಯಾಗಿ ಯಾಕೋಬನಿಗೆ ಆರನೆಯ ಮಗನನ್ನು ಹೆತ್ತಳು, ");
INSERT INTO kanokcv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ಲೇಯಳು, “ದೇವರು ನನಗೆ ಒಳ್ಳೆಯ ವರದಾನವನ್ನು ಕೊಟ್ಟಿದ್ದಾರೆ. ಈಗ ನಾನು ಅವನಿಗೆ ಆರು ಮಕ್ಕಳನ್ನು ಹೆತ್ತದ್ದರಿಂದ, ನನ್ನ ಗಂಡನು ಈಗಲಾದರೂ ನನ್ನನ್ನು ಗೌರವಿಸುವನು,” ಎಂದು ಹೇಳಿ, ಅವನಿಗೆ ಜೆಬುಲೂನ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ತರುವಾಯ ಆಕೆಯು ಒಬ್ಬ ಮಗಳನ್ನು ಹೆತ್ತು, ಆಕೆಗೆ ದೀನಾ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ಆಗ ದೇವರು ರಾಹೇಲಳನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಂಡರು. ದೇವರು ಆಕೆಯ ಮೊರೆಯನ್ನು ಕೇಳಿ, ಆಕೆಗೆ ಮಕ್ಕಳಾಗುವಂತೆ ಅನುಗ್ರಹಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ಆಕೆಯು ಗರ್ಭಿಣಿಯಾಗಿ ಮಗನನ್ನು ಹೆತ್ತು, “ದೇವರು ನನ್ನ ನಿಂದೆಯನ್ನು ತೆಗೆದುಬಿಟ್ಟಿದ್ದಾರೆ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ಆಕೆಯು, “ಯೆಹೋವ ದೇವರು ನನಗೆ ಮತ್ತೊಬ್ಬ ಮಗನನ್ನು ದಯಪಾಲಿಸುವರು,” ಎಂದು ಹೇಳಿ ಅವನಿಗೆ ಯೋಸೇಫ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ರಾಹೇಲಳು ಯೋಸೇಫನನ್ನು ಹೆತ್ತಾಗ ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ನಾನು ನನ್ನ ಸ್ಥಳಕ್ಕೂ ಸ್ವದೇಶಕ್ಕೂ ಹೋಗುವಂತೆ ನನ್ನನ್ನು ಕಳುಹಿಸಿಕೊಡು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ನಾನು ಯಾರಿಗೋಸ್ಕರ ನಿನಗೆ ಸೇವೆ ಮಾಡಿದೆನೋ, ಆ ನನ್ನ ಹೆಂಡತಿಯರನ್ನೂ, ನನ್ನ ಮಕ್ಕಳನ್ನೂ ನನ್ನೊಂದಿಗೆ ಕಳುಹಿಸಿಕೊಡು. ನಾನು ನಿನಗೆ ಮಾಡಿದ ಸೇವೆಯನ್ನು ನೀನು ಬಲ್ಲವನಾಗಿದ್ದೀಯೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ಲಾಬಾನನು ಅವನಿಗೆ, “ನಾನು ನಿನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ದಯೆ ಹೊಂದಿದವನಾಗಿದ್ದರೆ, ನನ್ನ ಬಳಿಯಲ್ಲಿಯೇ ಇರು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ನಿನಗೋಸ್ಕರ ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದಾರೆಂದು ನಾನು ಭವಿಷ್ಯಜ್ಞಾನ ಅನುಭವದಿಂದ ಕಲಿತುಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ನೀನು ನಿನ್ನ ಸಂಬಳವನ್ನು ನಿರ್ಣಯಿಸು. ಅದನ್ನು ನಾನು ನಿನಗೆ ಕೊಡುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ಅದಕ್ಕೆ ಯಾಕೋಬನು ಅವನಿಗೆ, “ನಾನು ನಿನಗೆ ಮಾಡಿದ ಸೇವೆಯನ್ನೂ, ನಿನ್ನ ಪಶುಗಳು ನನ್ನ ಬಳಿಯಲ್ಲಿ ಹೇಗೆ ಅಭಿವೃದ್ಧಿ ಆಗಿವೆ ಎಂಬುದನ್ನೂ ನೀನು ಬಲ್ಲೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ನಾನು ಬರುವುದಕ್ಕಿಂತ ಮುಂಚೆ ನಿನಗಿದ್ದದ್ದು ಸ್ವಲ್ಪವೇ. ಈಗ ಅದು ಬಹಳವಾಗಿ ಹೆಚ್ಚಿದೆ. ನಾನು ಬಂದಂದಿನಿಂದ ಯೆಹೋವ ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದಾರೆ. ಈಗ ನಾನು ನನ್ನ ಸ್ವಂತ ಮನೆಗೋಸ್ಕರ ಯಾವಾಗ ಸಂಪಾದಿಸಲಿ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ಅದಕ್ಕೆ ಲಾಬಾನನು, “ನಿನಗೆ ನಾನು ಏನು ಕೊಡಲಿ?” ಎಂದನು. ಯಾಕೋಬನು, “ಏನೂ ಕೊಡಬೇಡ, ಒಂದು ವಿಷಯದಲ್ಲಿ ಒಪ್ಪಿಕೊಂಡರೆ, ನಾನು ಮತ್ತೆ ನಿನ್ನ ಮಂದೆಯನ್ನು ಮೇಯಿಸಿ ಕಾಯುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ಈ ಹೊತ್ತು ನಾನು ನಿನ್ನ ಎಲ್ಲಾ ಮಂದೆಯ ಮಧ್ಯದಲ್ಲಿ ಹಾದು ಹೋಗುವೆನು. ಕುರಿಗಳಲ್ಲಿ ಕಂದುಬಣ್ಣದವುಗಳನ್ನೆಲ್ಲಾ, ಮೇಕೆಗಳಲ್ಲಿ ಚುಕ್ಕೆ ಮತ್ತು ಮಚ್ಚೆ ಉಳ್ಳವುಗಳನ್ನೆಲ್ಲಾ ಬೇರೆ ಮಾಡುವೆನು. ಅವೇ ನನ್ನ ಕೂಲಿಯಾಗಿರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ಹೀಗಿದ್ದರೆ ಬರುವ ಕಾಲದಲ್ಲಿ ನನ್ನ ಸಂಬಳಕ್ಕಾಗಿ ನಾನು ನಿನ್ನ ಮುಂದೆ ಬಂದಾಗ, ನನ್ನ ಪ್ರಾಮಾಣಿಕತೆಯೇ ನನಗೆ ಸಾಕ್ಷಿಕೊಡುವುದು. ಮೇಕೆಗಳಲ್ಲಿ ಚುಕ್ಕೆ ಮತ್ತು ಮಚ್ಚೆ ಕುರಿಗಳಲ್ಲಿ ಕಂದು ಬಣ್ಣವಿಲ್ಲದವುಗಳು ನನ್ನ ಬಳಿಯಲ್ಲಿದ್ದರೆ, ಅವು ಕದ್ದವುಗಳು ಎಂದು ಎಣಿಕೆಯಾಗಿರಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ಲಾಬಾನನು, “ನೀನು ಹೇಳಿದಂತೆಯೇ ಆಗಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ಅದೇ ದಿನದಲ್ಲಿ ಲಾಬಾನನು ಹೋತಗಳಲ್ಲಿ ರೇಖೆ, ಮಚ್ಚೆ ಇದ್ದವುಗಳನ್ನೂ ಮತ್ತು ಸ್ವಲ್ಪ ಬಿಳುಪಾದ ಬಣ್ಣವಿದ್ದ ಎಲ್ಲವುಗಳನ್ನೂ, ಕುರಿಗಳಲ್ಲಿ ಕಂದು ಬಣ್ಣವಿದ್ದವುಗಳನ್ನೂ ವಿಂಗಡಿಸಿ, ತನ್ನ ಪುತ್ರರ ಕೈಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ತನಗೂ, ಯಾಕೋಬನಿಗೂ ಮಧ್ಯದಲ್ಲಿ ಮೂರು ದಿನಗಳ ಪ್ರಯಾಣದಷ್ಟು ಅಂತರವನ್ನು ಬಿಟ್ಟನು. ಯಾಕೋಬನು ಲಾಬಾನನ ಮಿಕ್ಕ ಮಂದೆಯನ್ನು ಮೇಯಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ಹೀಗಿರುವಲ್ಲಿ ಯಾಕೋಬನು ಲಿಬ್ನೆ, ಲೂಜು, ಅರ್ಮೋನ್ ಎಂಬ ಮರಗಳ ಹಸಿ ಕೋಲುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ಪಟ್ಟೆಪಟ್ಟೆಯಾಗಿ ತೊಗಟೆಯನ್ನು ಸುಲಿದು, ಅವುಗಳಲ್ಲಿರುವ ಬಿಳಿಯ ಬಣ್ಣವು ಕಾಣಿಸುವಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ಮಂದೆಗಳು ನೀರು ಕುಡಿಯುವುದಕ್ಕೆ ಬಂದಾಗ, ಅವು ಗರ್ಭಧರಿಸಬೇಕೆಂದು ನೀರು ಕುಡಿಯುವ ದೋಣಿಗಳಲ್ಲಿ ತಾನು ತೊಗಟೆ ಸುಲಿದ ಕೋಲುಗಳನ್ನು ಅವುಗಳ ಮುಂದೆ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ಮಂದೆಗಳು ಆ ಕೋಲುಗಳನ್ನು ನೋಡಿ, ಸಂಗಮ ಮಾಡಿದ್ದರಿಂದ, ಚುಕ್ಕೆ ಮಚ್ಚೆ ರೇಖೆಗಳುಳ್ಳ ಮರಿಗಳನ್ನು ಈಯುತ್ತಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ಯಾಕೋಬನು ಕುರಿಗಳನ್ನು ಬೇರೆ ಮಾಡಿ, ಲಾಬಾನನ ಮಂದೆಯಲ್ಲಿರುವ ರೇಖೆಗಳುಳ್ಳ ಆಡುಕುರಿಗಳೆದುರಾಗಿಯೂ ಕಂದು ಬಣ್ಣ ಉಳ್ಳವುಗಳೆದುರಾಗಿಯೂ ಕುರಿಗಳನ್ನು ಇರಿಸಿದನು. ಅವನು ತನ್ನ ಮಂದೆಯನ್ನು ಲಾಬಾನನ ಮಂದೆಗಳೊಂದಿಗೆ ಸೇರಿಸದೆ, ಅವುಗಳನ್ನು ಬೇರೆ ಇಟ್ಟುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ಬಲವಾದ ಕುರಿಗಳು ಸಂಗಮ ಮಾಡುವಾಗ ಯಾಕೋಬನು ಆ ಕುರಿಗಳು ಕೋಲುಗಳನ್ನು ನೋಡುತ್ತಾ ಗರ್ಭಧರಿಸುವ ಹಾಗೆ ಕೋಲುಗಳನ್ನು ಕುರಿಗಳ ಕಣ್ಣೆದುರಾಗಿ ದೋಣಿಗಳಲ್ಲಿ ಇಡುತ್ತಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ಆದರೆ ಕುರಿಗಳು ಬಲಹೀನವಾಗಿದ್ದಾಗ, ಅವನು ಕೋಲುಗಳನ್ನು ದೋಣಿಗಳಲ್ಲಿ ಇಡಲಿಲ್ಲ. ಹೀಗಾಗಿ ಬಲಹೀನವಾದವುಗಳು ಲಾಬಾನನಿಗೂ, ಬಲವಾದವುಗಳು ಯಾಕೋಬನಿಗೂ ಆದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ಈ ಪ್ರಕಾರ ಯಾಕೋಬನು ಅತ್ಯಧಿಕವಾಗಿ ಅಭಿವೃದ್ಧಿಯಾದ್ದರಿಂದ, ಬಹು ಕುರಿಗಳೂ ದಾಸದಾಸಿಯರೂ ಒಂಟೆಗಳೂ ಕತ್ತೆಗಳೂ ಅವನಿಗೆ ದೊರೆತವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ಲಾಬಾನನ ಮಕ್ಕಳು, “ನಮ್ಮ ತಂದೆಗೆ ಇದ್ದವುಗಳನ್ನೆಲ್ಲಾ ಯಾಕೋಬನು ತೆಗೆದುಕೊಂಡು, ನಮ್ಮ ತಂದೆಗಿದ್ದವುಗಳಿಂದ ಈ ಘನತೆಯನ್ನೆಲ್ಲಾ ಪಡೆದಿದ್ದಾನೆ,” ಎಂದು ಹೇಳುವ ಮಾತುಗಳನ್ನು ಯಾಕೋಬನು ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ಇದಲ್ಲದೆ ಯಾಕೋಬನು ಲಾಬಾನನ ಮುಖವನ್ನು ನೋಡಿದಾಗ, ಅದು ತನ್ನ ಕಡೆಗೆ ಮೊದಲು ಇದ್ದ ಹಾಗೆ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ಆಗ ಯೆಹೋವ ದೇವರು ಯಾಕೋಬನಿಗೆ, “ನಿನ್ನ ತಂದೆಗಳ ದೇಶಕ್ಕೂ, ನಿನ್ನ ಬಂಧುಗಳ ಬಳಿಗೂ ಹಿಂದಿರುಗಿ ಹೋಗು. ನಾನು ನಿನ್ನ ಸಂಗಡ ಇರುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನೂ, ಲೇಯಳನ್ನೂ ಹೊಲದಲ್ಲಿದ್ದ ತನ್ನ ಮಂದೆಯ ಬಳಿಗೆ ಕರೆಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ಅವರಿಗೆ, “ನಿಮ್ಮ ತಂದೆಯ ಮುಖವು ಮೊದಲು ನನ್ನ ಕಡೆಗೆ ಇದ್ದ ಹಾಗೆ ಈಗ ಇಲ್ಲದಿರುವುದನ್ನು ನಾನು ನೋಡಿದ್ದೇನೆ. ಆದರೆ ನನ್ನ ತಂದೆಯ ದೇವರು ನನ್ನ ಕಡೆಗೆ ಇದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ನಾನು ಪೂರ್ಣಬಲದಿಂದ ನಿಮ್ಮ ತಂದೆಯ ಸೇವೆ ಮಾಡಿದ್ದು ನಿಮಗೆ ತಿಳಿದಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ಆದರೆ ನಿಮ್ಮ ತಂದೆಯು ನನಗೆ ವಂಚನೆಮಾಡಿ, ನನ್ನ ಸಂಬಳವನ್ನು ಹತ್ತು ಸಾರಿ ಬದಲಾಯಿಸಿದನು. ಆದಾಗ್ಯೂ ದೇವರು ಅವನಿಂದ ನನಗೆ ಕೇಡು ಮಾಡಗೊಡಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ನಿಮ್ಮ ತಂದೆ ನನಗೆ, ‘ಚುಕ್ಕೆಯುಳ್ಳದ್ದು ನಿನಗೆ ಸಂಬಳವಾಗಿರಲಿ,’ ಅಂದಾಗ, ಮಂದೆಯೆಲ್ಲಾ ಚುಕ್ಕೆಯುಳ್ಳದ್ದನ್ನೇ ಈಯಿತು. ಅವನು, ‘ರೇಖೆಯುಳ್ಳದ್ದು ನಿನಗೆ ಸಂಬಳವಾಗಿರಲಿ,’ ಎಂದಾಗ, ಮಂದೆಯೆಲ್ಲಾ ರೇಖೆಯುಳ್ಳದ್ದನ್ನೇ ಈಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ಹೀಗೆ ದೇವರು ನಿಮ್ಮ ತಂದೆಯ ಪಶುಗಳನ್ನು ತೆಗೆದು, ನನಗೆ ಕೊಟ್ಟಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“ಇದಲ್ಲದೆ ಕುರಿಗಳು ಸಂಗಮ ಮಾಡುವಾಗ, ಸ್ವಪ್ನದಲ್ಲಿ ನಾನು ನನ್ನ ಕಣ್ಣುಗಳನ್ನೆತ್ತಿ ನೋಡಲಾಗಿ, ಕುರಿಗಳ ಮೇಲೆ ಏರುವ ಟಗರುಗಳು ಚುಕ್ಕೆ, ಮಚ್ಚೆ, ರೇಖೆಗಳುಳ್ಳವುಗಳಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ದೇವದೂತನು ಸ್ವಪ್ನದಲ್ಲಿ ನನಗೆ, ‘ಯಾಕೋಬನೇ’ ಎಂದನು. ಅದಕ್ಕೆ ನಾನು, ‘ಇಲ್ಲಿ ಇದ್ದೇನೆ,’ ಎಂದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ಅವನು ನನಗೆ, ‘ನಿನ್ನ ಕಣ್ಣುಗಳನ್ನೆತ್ತಿ ಕುರಿಗಳನ್ನೇರುವ ಎಲ್ಲಾ ಟಗರುಗಳನ್ನು ನೋಡು. ಅವು ಚುಕ್ಕೆ, ಮಚ್ಚೆ, ರೇಖೆಯೂ ಉಳ್ಳವುಗಳಾಗಿವೆ. ಏಕೆಂದರೆ ಲಾಬಾನನು ನಿನಗೆ ಮಾಡಿದ್ದನ್ನೆಲ್ಲಾ ಕಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ನೀನು ಸ್ತಂಭವನ್ನು ಅಭಿಷೇಕಿಸಿ, ನನಗೆ ಪ್ರಮಾಣ ಮಾಡಿದ ಬೇತೇಲಿನ ದೇವರು ನಾನೇ. ಈಗ ಎದ್ದು ಈ ದೇಶದಿಂದ ಹೊರಟು, ನಿನ್ನ ಬಂಧುಗಳ ದೇಶಕ್ಕೆ ಹಿಂದಿರುಗಿ ಹೋಗು,’ ಎಂದು ಹೇಳಿದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ಆಗ ರಾಹೇಲಳು, ಲೇಯಳು ಅವನಿಗೆ, “ನಮ್ಮ ತಂದೆಯ ಮನೆಯಲ್ಲಿ ಇನ್ನೇನಾದರೂ ಭಾಗವೂ, ಬಾಧ್ಯತೆಯೂ ಇದೆಯೋ? ");
INSERT INTO kanokcv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ಅವನು ನಮ್ಮನ್ನು ಹೊರಗಿನವರಂತೆ ಎಣಿಸಿದ್ದಾನಲ್ಲಾ. ಅವನು ನಮ್ಮನ್ನು ಮಾರಿ, ನಮ್ಮ ಹಣವನ್ನೂ ನುಂಗೇ ಬಿಟ್ಟನಲ್ಲಾ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ಆದ್ದರಿಂದ ದೇವರು ನಮ್ಮ ತಂದೆಯಿಂದ ತೆಗೆದುಕೊಂಡ ಐಶ್ವರ್ಯವೆಲ್ಲಾ ನಮ್ಮದು, ನಮ್ಮ ಮಕ್ಕಳದು. ಹಾಗಾದರೆ ಈಗ ದೇವರು ನಿನಗೆ ಹೇಳಿದ್ದನ್ನೆಲ್ಲಾ ಮಾಡು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ಆಗ ಯಾಕೋಬನು ಎದ್ದು ತನ್ನ ಮಕ್ಕಳನ್ನೂ, ತನ್ನ ಹೆಂಡತಿಯರನ್ನೂ ಒಂಟೆಗಳ ಮೇಲೆ ಹತ್ತಿಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ತನ್ನ ಎಲ್ಲಾ ಪಶುಗಳನ್ನೂ, ತಾನು ಸಂಪಾದಿಸಿದ ಎಲ್ಲಾ ಸಂಪತ್ತನ್ನೂ, ಪದ್ದನ್ ಅರಾಮಿನಲ್ಲಿ ತಾನು ಸಂಪಾದಿಸಿದ ಪಶುಗಳನ್ನೂ ಕಾನಾನ್ ದೇಶದಲ್ಲಿದ್ದ ತನ್ನ ತಂದೆ ಇಸಾಕನ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೊರಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ಲಾಬಾನನು ತನ್ನ ಕುರಿಗಳ ಉಣ್ಣೆ ಕತ್ತರಿಸುವುದಕ್ಕೆ ಹೋಗಿದ್ದನು. ಆಗ ರಾಹೇಲಳು ತನ್ನ ತಂದೆಯ ವಿಗ್ರಹಗಳನ್ನು ಕದ್ದುಕೊಂಡಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ಆದರೆ ಯಾಕೋಬನು ತಾನು ಹೋಗುವುದನ್ನು ಅರಾಮ್ಯನಾದ ಲಾಬಾನನಿಗೆ ತಿಳಿಸದೆ ವಂಚಿಸಿ ಓಡಿಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ಅವನು ತನಗಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು ಓಡಿಹೋದನು. ಅವನು ಎದ್ದು ಗಿಲ್ಯಾದ್ ಪರ್ವತಕ್ಕೆ ಅಭಿಮುಖವಾಗಿ ಯೂಫ್ರೇಟೀಸ್ ನದಿಯನ್ನು ದಾಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ಯಾಕೋಬನು ಓಡಿಹೋದನೆಂದು ಮೂರನೆಯ ದಿವಸದಲ್ಲಿ ಲಾಬಾನನಿಗೆ ತಿಳಿಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ಆಗ ಅವನು ತನ್ನ ಬಂಧುಗಳನ್ನು ಕರೆದುಕೊಂಡು, ಅವನನ್ನು ಬೆನ್ನಟ್ಟಿ, ಏಳು ದಿನ ಪ್ರಯಾಣಮಾಡಿ, ಗಿಲ್ಯಾದ್ ಪರ್ವತದಲ್ಲಿ ಅವನನ್ನು ಸಂಧಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ಆ ರಾತ್ರಿ ದೇವರು ಸ್ವಪ್ನದಲ್ಲಿ ಅರಾಮಿನವನಾದ ಲಾಬಾನನ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, “ನೀನು ಯಾಕೋಬನ ಸಂಗಡ ಒಳ್ಳೆಯದನ್ನಾಗಲಿ, ಕೆಟ್ಟದ್ದನ್ನಾಗಲಿ ಮಾತನಾಡದಂತೆ ಎಚ್ಚರಿಕೆಯಾಗಿರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ತರುವಾಯ ಲಾಬಾನನು ಯಾಕೋಬನನ್ನು ಸಂಧಿಸಿದಾಗ, ಯಾಕೋಬನು ಗಿಲ್ಯಾದ್ ಪರ್ವತದಲ್ಲಿ ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿಕೊಂಡಿದ್ದನು. ಲಾಬಾನನು ಸಹ ಅಲ್ಲಿಯೇ ಗುಡಾರವನ್ನು ಹಾಕಿಸಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ನೀನು ಏನು ಮಾಡಿದೆ? ನನಗೆ ತಿಳಿಸದೆ ಮೋಸಮಾಡಿದ್ದೀಯೆ ಮತ್ತು ನನ್ನ ಪುತ್ರಿಯರನ್ನು ಯುದ್ಧದಲ್ಲಿ ಸೆರೆಹಿಡಿದವರ ಹಾಗೆ ತೆಗೆದುಕೊಂಡು ಹೋದೆಯಲ್ಲಾ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ಯಾಕೆ ನೀನು ಗುಪ್ತವಾಗಿ ಕಳ್ಳತನದಿಂದ ಓಡಿ ಹೋದೆ? ಏಕೆ ಮೋಸಮಾಡಿದೆ? ನನಗೆ ತಿಳಿಸಿದ್ದರೆ ಸಂತೋಷದಿಂದ ಹಾಡು, ತಾಳ, ವೀಣೆಗಳ ಸಂಗೀತದೊಂದಿಗೆ ನಿನ್ನನ್ನು ಕಳುಹಿಸುತ್ತಿದ್ದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ಆದರೆ ನೀನು ನನ್ನ ಮೊಮ್ಮಕ್ಕಳಿಗೂ, ನನ್ನ ಹೆಣ್ಣು ಮಕ್ಕಳಿಗೂ ಮುದ್ದು ಕೊಡುವುದಕ್ಕೂ ಬಿಡಲಿಲ್ಲ. ನೀನು ಮಾಡಿದ್ದು ಬುದ್ಧಿಹೀನ ಕೆಲಸವೇ ಸರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ನಿನಗೆ ಕೇಡು ಮಾಡುವುದಕ್ಕೆ ನನ್ನ ಕೈಯಲ್ಲಿ ಸಾಮರ್ಥ್ಯ ಇದೆ. ಆದರೆ ನಿನ್ನ ತಂದೆಯ ದೇವರು ನಿನ್ನೆ ರಾತ್ರಿ ನನ್ನ ಸಂಗಡ ಮಾತನಾಡಿ, ‘ನೀನು ಯಾಕೋಬನ ಸಂಗಡ ಒಳ್ಳೆಯದನ್ನಾಗಲಿ, ಕೆಟ್ಟದ್ದನ್ನಾಗಲಿ ಹೇಳದಂತೆ ಎಚ್ಚರವಾಗಿರು,’ ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ಈಗ ನೀನು ನಿನ್ನ ತಂದೆಯ ಮನೆಯನ್ನು ಬಹಳವಾಗಿ ಹಾರೈಸಿದ್ದರಿಂದ ಹೋಗಬೇಕಾಯಿತು. ಆದರೆ ನೀನು ನನ್ನ ದೇವರುಗಳನ್ನು ಕದ್ದದ್ದು ಯಾಕೆ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ಅದಕ್ಕೆ ಯಾಕೋಬನು ಉತ್ತರವಾಗಿ ಲಾಬಾನನಿಗೆ, “ನೀನು ನಿನ್ನ ಪುತ್ರಿಯರನ್ನು ನನ್ನಿಂದ ಬಲಾತ್ಕಾರದಿಂದ ಹಿಂದಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳುವೆ ಎಂದು ಭಯಪಟ್ಟೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ಆದರೆ ಯಾರ ಬಳಿಯಲ್ಲಿ ನಿನ್ನ ದೇವರುಗಳು ಸಿಕ್ಕುವುವೋ ಅವರು ಸಾಯಲಿ. ನನ್ನ ಬಳಿಯಲ್ಲಿ ನಿನ್ನದೇನಾದರೂ ಇದ್ದರೆ, ನಮ್ಮ ಬಂಧುಗಳ ಮುಂದೆ ವಿಚಾರಿಸಿ ಅದನ್ನು ತೆಗೆದುಕೋ,” ಎಂದನು. ಆದರೆ ರಾಹೇಲಳು ಅವುಗಳನ್ನು ಕದ್ದುಕೊಂಡದ್ದು ಯಾಕೋಬನಿಗೆ ತಿಳಿದಿರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ಆಗ ಲಾಬಾನನು ಯಾಕೋಬನ ಗುಡಾರದಲ್ಲಿಯೂ, ಲೇಯಳ ಗುಡಾರದಲ್ಲಿಯೂ, ಆ ಇಬ್ಬರು ದಾಸಿಯರ ಗುಡಾರಗಳಲ್ಲಿಯೂ ಹೋಗಿ ಹುಡುಕಿದರೂ, ಅವುಗಳನ್ನು ಕಾಣಲಿಲ್ಲ. ಲೇಯಳ ಗುಡಾರದಿಂದ ಹೊರಟು ರಾಹೇಲಳ ಗುಡಾರದೊಳಗೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ಆದರೆ ರಾಹೇಲಳು ವಿಗ್ರಹಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಒಂಟೆಯ ಸಾಮಗ್ರಿಯಲ್ಲಿಟ್ಟು, ಅದರ ಮೇಲೆ ಕುಳಿತುಕೊಂಡಳು. ಲಾಬಾನನು ಗುಡಾರವನ್ನೆಲ್ಲಾ ಹುಡುಕಿದರೂ, ಅವನು ಅವುಗಳನ್ನು ಕಾಣಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ರಾಹೇಲಳು ತನ್ನ ತಂದೆಗೆ, “ಅಪ್ಪಾ, ನಾನು ನಿನ್ನ ಮುಂದೆ ಎದ್ದು ನಿಂತುಕೊಳ್ಳದೇ ಇರುವುದರಿಂದ, ನನ್ನ ಮೇಲೆ ಕೋಪಬಾರದೆ ಇರಲಿ. ಏಕೆಂದರೆ ನಾನು ಮುಟ್ಟಾಗಿದ್ದೇನೆ,” ಎಂದಳು. ಅವನು ಹುಡುಕಿ ಆ ವಿಗ್ರಹಗಳನ್ನು ಕಂಡುಕೊಳ್ಳದೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ಆಗ ಯಾಕೋಬನು ಕೋಪಗೊಂಡು ಲಾಬಾನನೊಂದಿಗೆ ವಾದಿಸಿದನು. ಯಾಕೋಬನು ಉತ್ತರವಾಗಿ ಲಾಬಾನನಿಗೆ, “ನೀನು ನನ್ನನ್ನು ಬೆನ್ನಟ್ಟಿ ಬರುವುದಕ್ಕೆ ನನ್ನ ಅಪರಾಧವೇನು?” ನನ್ನ ಪಾಪವೇನು? ");
INSERT INTO kanokcv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ನೀನು ನನ್ನ ಸಲಕರಣೆಗಳನ್ನೆಲ್ಲಾ ಹುಡುಕಿದ ಮೇಲೆ ನಿನ್ನ ಮನೆಯ ಯಾವ ವಸ್ತುಗಳನ್ನು ಕಂಡುಕೊಂಡೆ? ನನಗೂ, ನಿನಗೂ ಬಂಧುಗಳಾಗಿರುವವರ ಮುಂದೆ ಅದನ್ನು ಇಲ್ಲಿ ಇಡು. ಅವರೇ ನಮ್ಮಿಬ್ಬರ ಮಧ್ಯೆ ನ್ಯಾಯತೀರಿಸಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“ಈ ಇಪ್ಪತ್ತು ವರ್ಷ ನಾನು ನಿನ್ನ ಸಂಗಡ ಇದ್ದೆನು. ನಿನ್ನ ಕುರಿಗಳೂ, ಮೇಕೆಗಳೂ ಮರಿ ಹಾಕಲಿಲ್ಲ. ನಿನ್ನ ಕುರಿ ಹೋತಗಳನ್ನು ನಾನು ತಿನ್ನಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ಮೃಗಗಳಿಂದ ಘಾಯವಾದವುಗಳನ್ನು ನಿನ್ನ ಬಳಿಗೆ ತಾರದೆ, ಅವುಗಳ ನಷ್ಟವನ್ನು ನಾನೇ ಹೊತ್ತೆನು. ಹಗಲಲ್ಲಿ ಕದ್ದದ್ದನ್ನೂ, ರಾತ್ರಿಯಲ್ಲಿ ಕದ್ದದ್ದನ್ನೂ ನನ್ನಿಂದಲೇ ತೆಗೆದುಕೊಂಡೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ನನ್ನ ಸ್ಥಿತಿ ಹೀಗೆ ಇತ್ತು: ಹಗಲಲ್ಲಿ ಬಿಸಿಲಿನಿಂದಲೂ ಇರುಳಲ್ಲಿ ಚಳಿಯಿಂದಲೂ ಬಾಧೆಪಟ್ಟೆನು. ನನ್ನ ಕಣ್ಣುಗಳಿಗೆ ನಿದ್ರೆ ತಪ್ಪಿಹೋಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ನಿನ್ನ ಇಬ್ಬರು ಪುತ್ರಿಯರಿಗಾಗಿ ಹದಿನಾಲ್ಕು ವರ್ಷ, ನಿನ್ನ ಮಂದೆಗಳಿಗೋಸ್ಕರ ಆರು ವರ್ಷ, ಈ ಪ್ರಕಾರ ಇಪ್ಪತ್ತು ವರ್ಷ ನಿನ್ನ ಮನೆಯಲ್ಲಿದ್ದು, ನಿನ್ನ ಸೇವೆ ಮಾಡಿದೆನು. ಆದರೆ ನೀನು ನನ್ನ ಸಂಬಳವನ್ನು ಹತ್ತು ಸಾರಿ ಬದಲಾಯಿಸಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ನನ್ನ ತಂದೆ ದೇವರೂ, ಅಬ್ರಹಾಮನ ದೇವರೂ, ಇಸಾಕನ ಭಯವೂ ನನ್ನೊಂದಿಗೆ ಇಲ್ಲದೆ ಹೋಗಿದ್ದರೆ, ನಿಶ್ಚಯವಾಗಿ ನೀನು ನನ್ನನ್ನು ಬರಿಗೈಯಿಂದ ಕಳುಹಿಸುತ್ತಿದ್ದೆ. ನನ್ನ ಬಾಧೆಯನ್ನೂ, ನನ್ನ ಕಷ್ಟವನ್ನೂ ದೇವರು ಕಂಡು, ನಿನ್ನೆ ರಾತ್ರಿ ನಿನ್ನನ್ನು ಗದರಿಸಿದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ಲಾಬಾನನು ಅದಕ್ಕೆ ಉತ್ತರವಾಗಿ ಯಾಕೋಬನಿಗೆ, “ಈ ಪುತ್ರಿಯರು ನನ್ನ ಪುತ್ರಿಯರೇ, ಈ ಮಕ್ಕಳು ನನ್ನ ಮಕ್ಕಳೇ, ಈ ಮಂದೆಯು ನನ್ನ ಮಂದೆಯೇ, ಅಂತು ನೀನು ಕಾಣುವುದೆಲ್ಲಾ ನನ್ನದೇ. ಹಾಗಾದರೆ ನನ್ನ ಪುತ್ರಿಯರಿಗಾಗಲಿ, ಅವರು ಹೆತ್ತ ಮಕ್ಕಳಿಗಾಗಲಿ ನಾನು ಈ ಹೊತ್ತು ಏನು ಮಾಡಲಿ? ");
INSERT INTO kanokcv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ಆದ್ದರಿಂದ ನೀನು ಇಲ್ಲಿ ಬಾ, ನಾನೂ ನೀನೂ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡೋಣ, ಅದು ನನಗೂ ನಿನಗೂ ಮಧ್ಯದಲ್ಲಿ ಸಾಕ್ಷಿಯಾಗಿರಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ಆಗ ಯಾಕೋಬನು ಒಂದು ಕಲ್ಲನ್ನು ತೆಗೆದುಕೊಂಡು ಸ್ತಂಭವಾಗಿ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ಯಾಕೋಬನು ತನ್ನ ಕಡೆಯವರಿಗೆ, “ಕಲ್ಲುಗಳನ್ನು ಕೂಡಿಸಿರಿ,” ಎಂದನು. ಅವರು ಕಲ್ಲುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಒಂದು ಕುಪ್ಪೆ ಮಾಡಿದರು. ಅವರು ಆ ಕುಪ್ಪೆಯ ಬಳಿಯಲ್ಲಿ ಕುಳಿತುಕೊಂಡು ಊಟಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ಆ ಕುಪ್ಪೆಗೆ ಲಾಬಾನನು ಯಗರಸಾಹದೂತ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಯಾಕೋಬನು ಗಲೇದ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ಆಗ ಲಾಬಾನನು, “ಈ ಕುಪ್ಪೆಯು ಈ ಹೊತ್ತು ನಿನಗೂ ನನಗೂ ಸಾಕ್ಷಿಯಾಗಿದೆ,” ಎಂದನು. ಆದ್ದರಿಂದ ಅದಕ್ಕೆ ಗಲೇದ್ ಎಂದೂ, ");
INSERT INTO kanokcv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ಮಿಚ್ಪಾ ಎಂದೂ ಹೆಸರಾಯಿತು. ಏಕೆಂದರೆ, “ನನಗೂ ನಿನಗೂ ಮಧ್ಯದಲ್ಲಿ ನಾವು ಒಬ್ಬರಿಗೊಬ್ಬರು ಅಗಲಿರುವಾಗ ಯೆಹೋವ ದೇವರು ನಮ್ಮನ್ನು ನೋಡಿಕೊಳ್ಳುತ್ತಾ ಇರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ನೀನು ನನ್ನ ಪುತ್ರಿಯರನ್ನು ಉಪದ್ರವಪಡಿಸಿದರೆ, ಇಲ್ಲವೆ ನನ್ನ ಮಕ್ಕಳ ಹೊರತಾಗಿ ಬೇರೆ ಹೆಂಡತಿಯರನ್ನು ನೀನು ಪಡೆದರೆ, ಯಾವ ಮನುಷ್ಯನೂ ವಿಚಾರಿಸಲು ಇಲ್ಲದಿದ್ದರೂ ನನಗೂ ನಿನಗೂ ನಡುವೆ ದೇವರೇ ಈ ಒಪ್ಪಂದಕ್ಕೆ ಸಾಕ್ಷಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ನಿನಗೂ ನನಗೂ ಮಧ್ಯೆ ನಾನು ಹಾಕಿಸಿರುವ ಈ ಕುಪ್ಪೆಯನ್ನು ನೋಡು, ಈ ಸ್ತಂಭವನ್ನು ನೋಡು, ");
INSERT INTO kanokcv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ನಾನು ಈ ಕುಪ್ಪೆಯನ್ನು ದಾಟಿ ನಿನ್ನ ಹತ್ತಿರ ಬರುವುದಿಲ್ಲ; ನೀನು ಈ ಕುಪ್ಪೆಯನ್ನು ಮತ್ತು ಸ್ತಂಭವನ್ನು ಕೇಡಿಗಾಗಿ ದಾಟುವುದಿಲ್ಲವೆಂಬುದಕ್ಕೆ ಈ ಕುಪ್ಪೆಯೂ ಈ ಸ್ತಂಭವೂ ಸಾಕ್ಷಿಯಾಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ಅಬ್ರಹಾಮನ ದೇವರು, ನಾಹೋರನ ದೇವರು, ಅವರ ತಂದೆಯ ದೇವರು ನಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ನ್ಯಾಯತೀರಿಸಲಿ,” ಎಂದನು. ಆಗ ಯಾಕೋಬನು ತನ್ನ ತಂದೆ ಇಸಾಕನ ಭಯದ ಮೇಲೆ ಪ್ರಮಾಣ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ಯಾಕೋಬನು ಆ ಬೆಟ್ಟದಲ್ಲಿ ಬಲಿಯನ್ನು ಅರ್ಪಿಸಿ, ಭೋಜನ ಮಾಡುವುದಕ್ಕೆ ತನ್ನ ಬಂಧುಗಳನ್ನು ಕರೆಕಳುಹಿಸಿದನು. ಅವರು ಭೋಜನ ಮಾಡಿ ಬೆಟ್ಟದಲ್ಲಿಯೇ ರಾತ್ರಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ಮುಂಜಾನೆ ಲಾಬಾನನು ಎದ್ದು ತನ್ನ ಪುತ್ರ ಪುತ್ರಿಯರಿಗೆ ಮುದ್ದಿಟ್ಟು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ಲಾಬಾನನು ಹೊರಟು ತನ್ನ ಸ್ಥಳಕ್ಕೆ ಹಿಂದಿರುಗಿ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ಅನಂತರ ಯಾಕೋಬನು ತನ್ನ ಮಾರ್ಗವಾಗಿ ಹೋಗುತ್ತಿದ್ದಾಗ, ದೇವದೂತರು ಅವನ ಎದುರಿಗೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ಯಾಕೋಬನು ಅವರನ್ನು ನೋಡಿದಾಗ, “ಇದು ದೇವರ ಸೈನ್ಯ,” ಎಂದು ಹೇಳಿ, ಆ ಸ್ಥಳಕ್ಕೆ ಮಹನಯಿಮ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ಯಾಕೋಬನು ಎದೋಮ್ಯರ ದೇಶವಾದ ಸೇಯೀರನ ಸೀಮೆಯಲ್ಲಿರುವ ತನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನ ಬಳಿಗೆ ದೂತರನ್ನು ತನ್ನ ಮುಂದಾಗಿ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ಕಳುಹಿಸುವಾಗ ಅವರಿಗೆ, “ನನ್ನ ಯಜಮಾನನಾದ ಏಸಾವನಿಗೆ ನೀವು ಹೀಗೆ ಹೇಳಬೇಕು: ‘ನಿನ್ನ ದಾಸನಾದ ಯಾಕೋಬನು ಹೀಗೆ ಹೇಳುತ್ತಾನೆ: ಲಾಬಾನನ ಸಂಗಡ ನಾನು ಇಲ್ಲಿಯವರೆಗೆ ಪ್ರವಾಸಿಯಾಗಿದ್ದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ಈಗ ನನಗೆ ಎತ್ತು, ಕತ್ತೆ, ಕುರಿಗಳು, ದಾಸದಾಸಿಯರು ಇದ್ದಾರೆ. ನಾನು ನಿನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ದಯೆ ಹೊಂದುವಂತೆ ನಾನು ಈ ಸಂದೇಶವನ್ನು ನನ್ನ ಯಜಮಾನನಾದ ನಿಮಗೆ ತಿಳಿಸುವುದಕ್ಕಾಗಿ ಕಳುಹಿಸಿದ್ದೇನೆ,’ ಎಂದು ಹೇಳಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ಆಗ ದೂತರು ಯಾಕೋಬನ ಬಳಿಗೆ ಹಿಂದಿರುಗಿ ಬಂದು, “ನಾವು ನಿನ್ನ ಸಹೋದರ ಏಸಾವನ ಬಳಿಗೆ ಹೋಗಿ ಬಂದಿದ್ದೇವೆ; ಅವನು ನಾನೂರು ಮಂದಿಯನ್ನು ಕರೆದುಕೊಂಡು ನಿನ್ನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಬರುತ್ತಿದ್ದಾನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ಆಗ ಯಾಕೋಬನು ಬಹಳವಾಗಿ ಭಯಪಟ್ಟು, ತನ್ನ ಸಂಗಡ ಇದ್ದ ಜನರನ್ನೂ, ಕುರಿಗಳನ್ನೂ, ದನಗಳನ್ನೂ, ಒಂಟೆಗಳನ್ನೂ ಎರಡು ಗುಂಪುಗಳಾಗಿ ವಿಭಾಗಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ಏಕೆಂದರೆ, “ಏಸಾವನು ಒಂದು ಗುಂಪಿನ ಮೇಲೆ ದಾಳಿಮಾಡಿದರೆ, ಉಳಿದ ಗುಂಪು ತಪ್ಪಿಸಿಕೊಂಡು ಹೋಗಬಹುದು,” ಎಂದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ಇದಲ್ಲದೆ ಯಾಕೋಬನು, “ನನ್ನ ತಂದೆ ಅಬ್ರಹಾಮನ ದೇವರೇ, ನನ್ನ ತಂದೆ ಇಸಾಕನ ದೇವರೇ, ನಿಮ್ಮ ದೇಶಕ್ಕೂ, ನಿನ್ನ ಬಂಧುಗಳ ಬಳಿಗೂ ಹಿಂದಿರುಗಿ ಹೋಗು. ಆಗ ನಾನು ನಿನಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡುವೆನು ಎಂದು ನನಗೆ ಹೇಳಿದ ಯೆಹೋವ ದೇವರೇ, ");
INSERT INTO kanokcv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ನೀವು ನಿಮ್ಮ ದಾಸನಿಗೆ ತೋರಿಸಿದ ಎಲ್ಲಾ ಕರುಣೆಗಳಿಗೂ, ಎಲ್ಲಾ ಸತ್ಯಕ್ಕೂ ಅಯೋಗ್ಯನಾಗಿದ್ದೇನೆ. ಏಕೆಂದರೆ ನಾನು ಮೊದಲು ಈ ಯೊರ್ದನ್ ಹೊಳೆಯನ್ನು ದಾಟಿದಾಗ, ನನ್ನ ಕೈಯಲ್ಲಿ ಕೋಲು ಮಾತ್ರವೇ ಇತ್ತು, ಈಗ ನನಗೆ ಎರಡು ಗುಂಪುಗಳಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ನನ್ನ ಅಣ್ಣ ಏಸಾವನ ಕೈಯಿಂದ ನನ್ನನ್ನು ತಪ್ಪಿಸಿರಿ. ಏಕೆಂದರೆ ಅವನು ಬಂದು ನನ್ನನ್ನೂ, ಮಕ್ಕಳೊಂದಿಗೆ ತಾಯಂದಿರನ್ನೂ, ದಾಳಿಮಾಡುವನು ಎಂದು ನಾನು ಅವನಿಗೆ ಭಯಪಡುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","‘ನಿನಗೆ ಖಂಡಿತವಾಗಿ ಒಳ್ಳೆಯದನ್ನು ಮಾಡುವೆನು ಮತ್ತು ನಿನ್ನ ಸಂತತಿಯನ್ನು ಎಣಿಸುವುದಕ್ಕಾಗದ ಸಮುದ್ರದ ಮರಳಿನ ಹಾಗೆ ಮಾಡುವೆನು,’ ಎಂದು ನನಗೆ ಹೇಳಿದ್ದೀರಲ್ಲಾ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ಯಾಕೋಬನು ಆ ರಾತ್ರಿ ಅಲ್ಲೇ ಕಳೆದನು. ತಾನು ತಂದದ್ದರಲ್ಲಿ ಕೆಲವನ್ನು ಅವನ ಅಣ್ಣ ಏಸಾವನಿಗೆ ಕಾಣಿಕೆಗಾಗಿ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ಅವು ಯಾವುವೆಂದರೆ, ಇನ್ನೂರು ಮೇಕೆಗಳು, ಇಪ್ಪತ್ತು ಹೋತಗಳು, ಇನ್ನೂರು ಕುರಿಗಳು, ಇಪ್ಪತ್ತು ಟಗರುಗಳು, ");
INSERT INTO kanokcv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ಹಾಲು ಕೊಡುವ ಮೂವತ್ತು ಒಂಟೆಗಳು, ಅವುಗಳ ಮರಿಗಳು, ನಲವತ್ತು ಆಕಳುಗಳು, ಹತ್ತು ಹೋರಿಗಳು, ಇಪ್ಪತ್ತು ಹೆಣ್ಣು ಕತ್ತೆಗಳು, ಹತ್ತು ಗಂಡುಕತ್ತೆಗಳು, ");
INSERT INTO kanokcv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ಇವುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದು ಮಂದೆಯನ್ನೂ, ಪ್ರತ್ಯೇಕವಾಗಿ ಅವನು ತನ್ನ ಸೇವಕರಿಗೆ ಒಪ್ಪಿಸಿ, ಅವರಿಗೆ, “ನನ್ನ ಮುಂದೆ ನಡೆದು ಮಂದೆ ಮಂದೆಗೂ ಮಧ್ಯದಲ್ಲಿ ಸ್ಥಳ ಬಿಡಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ಅವನು ಮೊದಲನೆಯವನಿಗೆ, “ನನ್ನ ಅಣ್ಣ ಏಸಾವನು ನಿನ್ನೆದುರಿಗೆ ಬಂದು, ‘ನೀನು ಯಾರ ಕಡೆಯವನು? ಎಲ್ಲಿಗೆ ಹೋಗುತ್ತೀ? ಇಲ್ಲಿ ನಿನ್ನ ಮುಂದೆ ಇರುವ ಇವೆಲ್ಲ ಯಾರವು?’ ಎಂದು ಕೇಳಿದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ನೀನು ಅವನಿಗೆ, ‘ಇವು ನಿನ್ನ ದಾಸನಾದ ಯಾಕೋಬನವುಗಳೇ, ಇದು ನನ್ನ ಯಜಮಾನನಾದ ಏಸಾವನಿಗೆ ಕಳುಹಿಸಲಾದ ಕಾಣಿಕೆ, ಅವನೂ ನಮ್ಮ ಹಿಂದೆ ಇದ್ದಾನೆ,’ ಎಂದು ಅವನಿಗೆ ಹೇಳಬೇಕು,” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ಎರಡನೆಯವನಿಗೂ ಮೂರನೆಯವನಿಗೂ ಮಂದೆಗಳ ಹಿಂದೆ ಹೋಗುವವರೆಲ್ಲರಿಗೂ, “ನೀವು ಏಸಾವನನ್ನು ಕಂಡರೆ ಅವನಿಗೆ ಹಾಗೆಯೇ ಹೇಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ಇದಲ್ಲದೆ, ‘ನಿನ್ನ ದಾಸ ಯಾಕೋಬನು ನಮ್ಮ ಹಿಂದೆ ಬರುತ್ತಾನೆಂದು ಹೇಳಬೇಕು,’ ” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ಏಕೆಂದರೆ ನನ್ನ ಮುಂದೆ ಹೋಗುವ ಕಾಣಿಕೆಯಿಂದ ಅವನನ್ನು ಸಮಾಧಾನಪಡಿಸುವೆನು. ತರುವಾಯ ಅವನ ಮುಖವನ್ನು ಕಾಣುವೆನು. ಅವನು ನನ್ನನ್ನು ಅಂಗೀಕರಿಸುವನೇನೋ ಎಂದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ಹೀಗೆ ಆ ಕಾಣಿಕೆಯು ಅವನ ಮುಂದಾಗಿ ಹೊರಟುಹೋಯಿತು. ತಾನಾದರೋ ಆ ರಾತ್ರಿ ಅಲ್ಲಿಯೇ ತಂಗಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ಆ ರಾತ್ರಿಯಲ್ಲಿ ಯಾಕೋಬನು ಎದ್ದು ತನ್ನ ಇಬ್ಬರು ಹೆಂಡತಿಯರನ್ನೂ, ತನ್ನ ಇಬ್ಬರು ದಾಸಿಯರನ್ನೂ, ತನ್ನ ಹನ್ನೊಂದು ಮಂದಿ ಪುತ್ರರನ್ನೂ ಕರೆದುಕೊಂಡು ಯಬ್ಬೋಕ್ ಎಂಬ ಹೊಳೆಯ ದಂಡೆಯನ್ನು ದಾಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ಅವನು ಅವರನ್ನು ಕರೆದುಕೊಂಡು ಹೊಳೆ ದಂಡೆಯನ್ನು ದಾಟಿಸಿದ್ದಲ್ಲದೆ ತನಗಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ದಾಟಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ಆಗ ಯಾಕೋಬನು ಒಬ್ಬನೇ ಉಳಿದಾಗ, ಒಬ್ಬ ಮನುಷ್ಯನು ಉದಯವಾಗುವವರೆಗೆ ಅವನ ಸಂಗಡ ಹೋರಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ಆ ಮನುಷ್ಯನು ಅವನನ್ನು ಜಯಿಸದೆ ಇರುವುದನ್ನು ಕಂಡು, ಅವನ ತೊಡೆಯ ಕೀಲನ್ನು ಮುಟ್ಟಿದನು. ಅವನು ಹಾಗೆಯೇ ಸಂಗಡ ಹೋರಾಡುತ್ತಿರುವಾಗಲೇ ಯಾಕೋಬನ ತೊಡೆಯ ಕೀಲು ತಪ್ಪಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ಅವನು ಯಾಕೋಬನಿಗೆ, “ಉದಯವಾಯಿತು, ನನ್ನನ್ನು ಹೋಗಗೊಡು,” ಎಂದಾಗ. ಯಾಕೋಬನು, “ನೀನು ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸದ ಹೊರತು, ನಾನು ನಿನ್ನನ್ನು ಹೋಗಗೊಡಿಸೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ಆ ಮನುಷ್ಯನು ಅವನಿಗೆ, “ನಿನ್ನ ಹೆಸರು ಏನು?” ಎಂದಾಗ. ಅವನು, “ಯಾಕೋಬ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ಅದಕ್ಕೆ ಅವನು, “ನಿನ್ನ ಹೆಸರು ಇನ್ನು ಮೇಲೆ ಯಾಕೋಬನೆಂದು ಎನಿಸಿಕೊಳ್ಳದೆ, ಇಸ್ರಾಯೇಲ್ ಎಂದು ನಿನಗೆ ಹೆಸರಾಗುವುದು. ಏಕೆಂದರೆ ನೀನು ದೇವರ ಸಂಗಡವೂ, ಮನುಷ್ಯರ ಸಂಗಡವೂ ಹೋರಾಡಿ ಜಯಿಸಿದ್ದೀ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ಯಾಕೋಬನು, “ನಿನ್ನ ಹೆಸರನ್ನು ನನಗೆ ತಿಳಿಸು,” ಎಂದು ಅವನನ್ನು ಕೇಳಿಕೊಂಡನು. ಆತನು, “ನನ್ನ ಹೆಸರನ್ನು ಏಕೆ ಕೇಳುತ್ತೀ?” ಎಂದು ಹೇಳಿ ಅವನನ್ನು ಅಲ್ಲೇ ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ಆಗ ಯಾಕೋಬನು, “ನಾನು ದೇವರನ್ನು ಮುಖಾಮುಖಿಯಾಗಿ ನೋಡಿದರೂ, ನನ್ನ ಪ್ರಾಣ ಉಳಿಯಿತು,” ಎಂದು ಹೇಳಿ ಆ ಸ್ಥಳಕ್ಕೆ ಪೆನೀಯೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ಯಾಕೋಬನು ಪೆನೀಯೇಲನ್ನು ದಾಟಿಹೋದಾಗ, ಸೂರ್ಯೋದಯವಾಯಿತು. ಆದರೆ ಅವನು ತೊಡೆಯ ನೋವಿನ ನಿಮಿತ್ತ ಕುಂಟುತ್ತಾ ನಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ಆತನು ಯಾಕೋಬನ ತೊಡೆಯ ಕೀಲನ್ನು ಮುದುರಿದ ನರದಲ್ಲಿ ಮುಟ್ಟಿದ್ದರಿಂದ ಇಸ್ರಾಯೇಲರು ತೊಡೆಯ ಕೀಲಿನ ಮೇಲಿರುವ ಮುದುರಿದ ನರವನ್ನು ಈ ದಿನದವರೆಗೂ ತಿನ್ನುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ಯಾಕೋಬನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ, ಏಸಾವನು ನಾನೂರು ಮಂದಿ ಮನುಷ್ಯರ ಸಂಗಡ ಬರುತ್ತಿದ್ದನು. ಆಗ ಅವನು ಲೇಯಳಿಗೂ, ರಾಹೇಲಳಿಗೂ, ಇಬ್ಬರು ದಾಸಿಯರಿಗೂ ಅವರವರ ಮಕ್ಕಳನ್ನು ಒಪ್ಪಿಸಿ, ಅವರನ್ನು ಬೇರೆ ಬೇರೆ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ದಾಸಿಯರನ್ನೂ, ಅವರ ಮಕ್ಕಳನ್ನೂ ಮುಂದುಗಡೆಯಲ್ಲಿಯೂ; ಅವರ ಹಿಂದೆ ಲೇಯಳನ್ನೂ, ಆಕೆಯ ಮಕ್ಕಳನ್ನೂ; ಕಟ್ಟಕಡೆಯಲ್ಲಿ ರಾಹೇಲಳನ್ನೂ, ಯೋಸೇಫನನ್ನೂ ಇರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ತಾನೇ ಅವರ ಮುಂದಾಗಿ ಹೋಗಿ ತನ್ನ ಸಹೋದರನ ಬಳಿಗೆ ಬರುವವರೆಗೆ ಏಳು ಸಾರಿ ನೆಲದವರೆಗೆ ಬಗ್ಗಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ಆಗ ಏಸಾವನು ಅವನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಓಡಿಬಂದು, ಅವನನ್ನು ಅಪ್ಪಿಕೊಂಡು, ಅವನ ಕೊರಳಿನ ಮೇಲೆ ಬಿದ್ದು, ಅವನಿಗೆ ಮುದ್ದಿಟ್ಟನು. ಅವರಿಬ್ಬರೂ ಅತ್ತರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ಆಗ ಏಸಾವನು ತನ್ನ ದೃಷ್ಟಿ ಹರಿಸಿ, ಆ ಸ್ತ್ರೀಯರನ್ನೂ, ಮಕ್ಕಳನ್ನೂ ನೋಡಿ, “ನಿನ್ನ ಜೊತೆಯಲ್ಲಿರುವ ಇವರು ಯಾರು?” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕವನು, “ದೇವರು ನಿನ್ನ ದಾಸನಿಗೆ ಕೃಪೆಯಿಂದ ಕೊಟ್ಟ ಮಕ್ಕಳು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ಆಗ ದಾಸಿಯರೂ, ಅವರ ಮಕ್ಕಳೂ ಹತ್ತಿರ ಬಂದು ಅವನಿಗೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ಲೇಯಳು ಸಹ ತನ್ನ ಮಕ್ಕಳೊಂದಿಗೆ ಹತ್ತಿರ ಬಂದು ಅಡ್ಡಬಿದ್ದಳು. ತರುವಾಯ ಯೋಸೇಫನೂ, ರಾಹೇಲಳೂ ಬಂದು ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ಆಗ ಏಸಾವನು, “ನಾನು ದಾರಿಯಲ್ಲಿ ಕಂಡ ಪಶುಗಳ ಮಂದೆಗಳೆಲ್ಲಾ ಏತಕ್ಕೆ?” ಎಂದು ಕೇಳಿದನು. ಯಾಕೋಬನು, “ನನ್ನ ಒಡೆಯನ ದೃಷ್ಟಿಯಲ್ಲಿ ನನಗೆ ದಯೆ ದೊರಕುವುದಕ್ಕೋಸ್ಕರ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ಅದಕ್ಕೆ ಏಸಾವನು, “ನನ್ನ ಸಹೋದರನೇ, ನನಗೆ ಸಾಕಷ್ಟು ಇದೆ. ನಿನಗೆ ಇದ್ದದ್ದು ನೀನೇ ಇಟ್ಟುಕೋ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ಆಗ ಯಾಕೋಬನು, “ಹಾಗಲ್ಲ, ಈಗ ನಿನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ನಾನು ದಯೆ ಹೊಂದಿದ್ದೆನಾದರೆ, ನನ್ನ ಕಾಣಿಕೆಯನ್ನು ನನ್ನ ಕೈಯಿಂದ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಏಕೆಂದರೆ ನಾನು ದೇವರ ಮುಖವನ್ನು ಕಂಡಂತೆ, ನಿನ್ನ ಮುಖವನ್ನು ಕಂಡದ್ದಕ್ಕಾಗಿಯೂ, ನೀನು ನನ್ನನ್ನು ಮೆಚ್ಚಿದ್ದಕ್ಕಾಗಿಯೂ, ");
INSERT INTO kanokcv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ನಿನಗೋಸ್ಕರ ತಂದಿರುವ ನನ್ನ ಕಾಣಿಕೆಯನ್ನು ಸ್ವೀಕರಿಸಬೇಕೆಂದು ಬೇಡುತ್ತೇನೆ. ದೇವರು ನನ್ನೊಂದಿಗೆ ಕೃಪೆಯಿಂದ ವರ್ತಿಸಿದ್ದರಿಂದ ನನಗೆ ಬೇಕಾದಷ್ಟು ಇವೆ,” ಎಂದು ಹೇಳಿ, ಅವನನ್ನು ಬಲವಂತ ಮಾಡಿದ್ದರಿಂದ ಏಸಾವನು ಅದನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ತರುವಾಯ ಏಸಾವನು, “ನಾವು ಮುಂದಕ್ಕೆ ಪ್ರಯಾಣವನ್ನು ಬೆಳೆಸೋಣ. ನಾನು ನಿನ್ನ ಮುಂದೆ ಹೋಗುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ಅದಕ್ಕೆ ಯಾಕೋಬನು ಅವನಿಗೆ, “ಮಕ್ಕಳು ಎಳೆಯ ಪ್ರಾಯದವರಿದ್ದಾರೆ, ಇದಲ್ಲದೆ ಎಳೆಯ ದನಕುರಿಗಳು ನನ್ನ ಬಳಿಯಲ್ಲಿರುವುದು ನನ್ನ ಒಡೆಯನಿಗೆ ತಿಳಿದಿದೆ. ಒಂದು ದಿನ ಹೆಚ್ಚಾಗಿ ಅವುಗಳನ್ನು ನಡೆಸಿದರೆ, ಎಲ್ಲಾ ಮಂದೆಯು ಸತ್ತು ಹೋದಾವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ಆದ್ದರಿಂದ ನನ್ನ ಒಡೆಯನೇ, ನೀನು ನಿನ್ನ ಸೇವಕನಿಗಿಂತಲೂ ಮುಂಚೆ ಹೋಗಬಹುದು. ನಾನು ನನ್ನ ಒಡೆಯನ ಬಳಿಗೆ ಸೇಯೀರಿಗೆ ಬರುವವರೆಗೆ, ನನ್ನ ಮುಂದಿರುವ ಮಂದೆಗಳ ನಡಿಗೆಗೂ, ಮಕ್ಕಳ ನಡಿಗೆಗೂ ತಕ್ಕ ಹಾಗೆ ಮೆಲ್ಲಗೆ ನಡೆದು ಬರುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ಅದಕ್ಕೆ ಏಸಾವನು, “ನನ್ನ ಬಳಿಯಲ್ಲಿರುವ ಜನರಲ್ಲಿ ಕೆಲವರನ್ನು ನಿನ್ನ ಬಳಿಯಲ್ಲಿ ಬಿಟ್ಟು ಹೋಗುತ್ತೇನೆ,” ಅನ್ನಲು. ಯಾಕೋಬನು, “ಅದರ ಅಗತ್ಯವೇನು? ನನ್ನ ಒಡೆಯನ ದೃಷ್ಟಿಯಲ್ಲಿ ನನಗೆ ದಯೆ ದೊರಕಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ಹೀಗೆ ಏಸಾವನು ಆ ದಿನವೇ ತನ್ನ ಮಾರ್ಗವಾಗಿ ಸೇಯೀರಿಗೆ ಹಿಂದಿರುಗಿ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ಯಾಕೋಬನು ಪ್ರಯಾಣಮಾಡಿ, ಸುಕ್ಕೋತಿಗೆ ಹೋಗಿ, ಮನೆಯನ್ನು ಕಟ್ಟಿಸಿಕೊಂಡನು. ಇದಲ್ಲದೆ ತನ್ನ ಪಶುಗಳಿಗೆ ಹಟ್ಟಿಗಳನ್ನು ಮಾಡಿಸಿದನು. ಆದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಸುಕ್ಕೋತ್ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ಯಾಕೋಬನು ಪದ್ದನ್ ಅರಾಮಿನಿಂದ ಬಂದು, ಕಾನಾನ್ ದೇಶದ ಶೆಕೆಮ್ ಪಟ್ಟಣವನ್ನು ಸೇರಿ, ಅದರ ಮುಂದೆ ತನ್ನ ಗುಡಾರಗಳನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ಅವನು ತನ್ನ ಗುಡಾರಗಳನ್ನು ಹಾಕಿದ ಭೂಮಿಯನ್ನು ಶೆಕೆಮಿನ ತಂದೆ ಹಮೋರನ ಮಕ್ಕಳ ಕೈಯಿಂದ ನೂರು ನಾಣ್ಯಗಳಿಗೆ ಕೊಂಡುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ಅಲ್ಲಿ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿಸಿ ಅದಕ್ಕೆ, ಏಲೆಲೋಹೇ ಇಸ್ರಾಯೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ಲೇಯಳು ಯಾಕೋಬನಿಗೆ ಹೆತ್ತ ಮಗಳಾದ ದೀನಳು ದೇಶದ ಸ್ತ್ರೀಯರನ್ನು ನೋಡುವುದಕ್ಕಾಗಿ ಹೊರಗೆ ಹೋದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ದೇಶದ ಪ್ರಭುವಾಗಿದ್ದ ಹಿವ್ವಿಯನಾದ ಹಮೋರನ ಮಗ ಶೆಕೆಮನು ಆಕೆಯನ್ನು ತೆಗೆದುಕೊಂಡುಹೋಗಿ ಮಾನಭಂಗ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ಅವನ ಮನಸ್ಸು ಯಾಕೋಬನ ಮಗಳಾದ ದೀನಳ ಮೇಲೆಯೇ ಇತ್ತು. ಅವನು ಆ ಹುಡುಗಿಯನ್ನು ಪ್ರೀತಿಸಿ, ಆಕೆಯೊಂದಿಗೆ ಅನುರಾಗದಿಂದ ಮಾತನಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ಶೆಕೆಮನು ತನ್ನ ತಂದೆ ಹಮೋರನಿಗೆ, “ಈ ಹುಡುಗಿಯನ್ನು ನನಗೆ ಹೆಂಡತಿಯಾಗಿರುವಂತೆ ಹೇಳು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ಯಾಕೋಬನು ತನ್ನ ಮಗಳಾದ ದೀನಳನ್ನು ಶೆಕೆಮನು ಕೆಡಿಸಿದ್ದಾನೆಂದು ಕೇಳಿದಾಗ, ಅವನ ಮಕ್ಕಳು ಅವನ ಪಶುಗಳ ಸಂಗಡ ಹೊಲದಲ್ಲಿದ್ದರು. ಅವರು ಬರುವವರೆಗೆ ಯಾಕೋಬನು ಸುಮ್ಮನಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ಆಗ ಶೆಕೆಮನ ತಂದೆ ಹಮೋರನು ಯಾಕೋಬನ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ಯಾಕೋಬನ ಮಕ್ಕಳು ಆ ವಿಷಯವನ್ನು ಕೇಳಿದ ಕೂಡಲೇ ಹೊಲದಿಂದ ಬಂದರು. ಶೆಕೆಮನು ಯಾಕೋಬನ ಮಗಳ ಸಂಗಡ ಮಲಗಿ, ಇಸ್ರಾಯೇಲಿನಲ್ಲಿ ಅವಮಾನಕರವಾದದ್ದನ್ನು ಮಾಡಿದ್ದರಿಂದ, ಅವರು ವ್ಯಸನಪಟ್ಟು, ಬಹಳ ಕೋಪಗೊಂಡರು. ಅದು ಹಾಗೆ ಆಗಬಾರದಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ಹಮೋರನು ಅವರಿಗೆ, “ನನ್ನ ಮಗ ಶೆಕೆಮನ ಮನಸ್ಸು ನಿಮ್ಮ ಮಗಳನ್ನು ಆಶಿಸುತ್ತದೆ. ಆಕೆಯನ್ನು ಅವನಿಗೆ ಹೆಂಡತಿಯಾಗಿ ಕೊಡಿರಿ, ಎಂದು ನಿಮ್ಮನ್ನು ಕೇಳಿಕೊಳ್ಳುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ನೀವು ನಮ್ಮೊಂದಿಗೆ ಮದುವೆ ಸಂಬಂಧ ಮಾಡಿಕೊಳ್ಳಿರಿ. ನಿಮ್ಮ ಪುತ್ರಿಯರನ್ನು ನಮಗೆ ಕೊಡಿರಿ, ನಮ್ಮ ಪುತ್ರಿಯರನ್ನು ನೀವು ಮದುವೆಯಾಗಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ಇದಲ್ಲದೆ ನೀವು ನಮ್ಮ ಸಂಗಡ ವಾಸಮಾಡಿರಿ. ದೇಶವು ನಿಮ್ಮ ಮುಂದೆ ಇದೆ. ನೀವು ಅದರಲ್ಲಿ ವಾಸಿಸಿ, ಅದರಲ್ಲಿ ವ್ಯಾಪಾರಮಾಡಿ, ಅದರಿಂದ ಆಸ್ತಿಯನ್ನು ಮಾಡಿಕೊಳ್ಳಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ಬಳಿಕ ಶೆಕೆಮನು ಆಕೆಯ ತಂದೆಗೂ, ಆಕೆಯ ಸಹೋದರರಿಗೂ, “ನಿಮ್ಮ ದೃಷ್ಟಿಯಲ್ಲಿ ನನಗೆ ದಯೆ ದೊರಕಲಿ, ನೀವು ಕೇಳಿದ್ದನ್ನು ನಾನು ನಿಮಗೆ ಕೊಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ಆದರೆ ಆ ಹುಡುಗಿಯನ್ನು ನನಗೆ ಹೆಂಡತಿಯಾಗಿ ಕೊಡಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ಆಗ ಯಾಕೋಬನ ಮಕ್ಕಳು ಶೆಕೆಮನಿಗೂ, ಅವನ ತಂದೆ ಹಮೋರನಿಗೂ ವಂಚನೆಯ ಉತ್ತರವನ್ನು ಕೊಟ್ಟರು. ಏಕೆಂದರೆ ಅವನು ತಮ್ಮ ತಂಗಿ ದೀನಳನ್ನು ಕೆಡಿಸಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ಯಾಕೋಬನ ಮಕ್ಕಳು ಅವರಿಗೆ, “ನಾವು ಈ ಕಾರ್ಯವನ್ನು ಮಾಡಲಾರೆವು. ಸುನ್ನತಿ ಇಲ್ಲದ ಮನುಷ್ಯನಿಗೆ ನಮ್ಮ ತಂಗಿಯನ್ನು ಕೊಡಲಾರೆವು. ಅದು ನಮಗೆ ಅವಮಾನ. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ಆದರೆ ನೀವು ನಮ್ಮ ಹಾಗಿದ್ದು, ನಿಮ್ಮಲ್ಲಿರುವ ಗಂಡಸರೆಲ್ಲಾ ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡರೆ ಮಾತ್ರ ನಾವು ನಿಮಗೆ ಒಪ್ಪುವೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ನಮ್ಮ ಪುತ್ರಿಯರನ್ನು ನಿಮಗೆ ಕೊಟ್ಟು, ನಿಮ್ಮ ಪುತ್ರಿಯರನ್ನು ತೆಗೆದುಕೊಳ್ಳುವೆವು. ಇದಲ್ಲದೆ ನಾವು ನಿಮ್ಮೊಂದಿಗೆ ವಾಸಮಾಡಿ, ಒಂದೇ ಜನಾಂಗವಾಗುವೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ಆದರೆ ನೀವು ನಮ್ಮ ಮಾತನ್ನು ಕೇಳದೆ, ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳದೆ ಹೋದರೆ, ನಮ್ಮ ಹುಡುಗಿಯನ್ನು ನಾವು ಕರೆದುಕೊಂಡು ಹೋಗಿಬಿಡುತ್ತೇವೆ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ಅವರ ಮಾತುಗಳು ಹಮೋರನಿಗೂ, ಅವನ ಮಗ ಶೆಕೆಮನಿಗೂ ಯೋಗ್ಯವಾಗಿ ಕಂಡವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ಆ ಯೌವನಸ್ಥನು ಯಾಕೋಬನ ಮಗಳನ್ನು ಮೆಚ್ಚಿದ್ದರಿಂದ, ಆ ಕಾರ್ಯವನ್ನು ಮಾಡುವುದಕ್ಕೆ ಹಿಂಜರಿಯಲಿಲ್ಲ. ಅವನು ತನ್ನ ತಂದೆಯ ಮನೆಯವರೆಲ್ಲರಿಗಿಂತ ಗೌರವವುಳ್ಳವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ಆಗ ಹಮೋರನೂ, ಅವನ ಮಗ ಶೆಕೆಮನೂ ತಮ್ಮ ಪಟ್ಟಣ ದ್ವಾರದ ಬಳಿಗೆ ಬಂದು, ತಮ್ಮ ಪಟ್ಟಣದ ಜನರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ಈ ಜನರು ನಮ್ಮ ಸಂಗಡ ಸಮಾಧಾನವಾಗಿದ್ದಾರೆ, ಆದ್ದರಿಂದ ಅವರು ದೇಶದಲ್ಲಿ ವಾಸಮಾಡಿ, ಅದರಲ್ಲಿ ವ್ಯಾಪಾರಮಾಡಲಿ. ದೇಶವು ಅವರಿಗಾಗಿ ಸಾಕಷ್ಟು ವಿಸ್ತಾರವಾಗಿದೆ. ಅವರ ಪುತ್ರಿಯರನ್ನು ನಮಗೆ ಹೆಂಡತಿಯರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳೋಣ ಮತ್ತು ನಮ್ಮ ಪುತ್ರಿಯರನ್ನು ಅವರಿಗೆ ಕೊಡೋಣ. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡರೆ ಮಾತ್ರ ಅವರು ನಮ್ಮ ಸಂಗಡ ವಾಸಮಾಡುವುದಕ್ಕೂ, ಒಂದೇ ಜನಾಂಗವಾಗುವುದಕ್ಕೂ ಒಪ್ಪುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ಅವರ ಮಂದೆಗಳೂ, ಅವರ ಸಂಪತ್ತೂ, ಅವರ ಎಲ್ಲಾ ಪಶುಗಳೂ ನಮ್ಮದಾಗುವುವು ಅಲ್ಲವೋ? ಅವರಿಗೆ ನಾವು ಒಪ್ಪಿಕೊಂಡರೆ ಮಾತ್ರ, ಅವರು ನಮ್ಮ ಸಂಗಡ ವಾಸಿಸುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ಆಗ ಪಟ್ಟಣದ ದ್ವಾರದಲ್ಲಿ ಹೋಗುವ ಗಂಡಸರೆಲ್ಲರೂ ಹಮೋರನೂ, ಅವನ ಮಗ ಶೆಕೆಮನೂ ಹೇಳಿದ ಮಾತುಗಳನ್ನು ಕೇಳಿ, ಒಪ್ಪಿಕೊಂಡರು. ಹೀಗೆ ಪಟ್ಟಣದಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಗಂಡಸರು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಅವರಿಗೆ ನೋವುಂಟಾದಾಗ, ಯಾಕೋಬನ ಮಕ್ಕಳಲ್ಲಿ ಇಬ್ಬರು ಅಂದರೆ, ದೀನಳ ಸಹೋದರರಾದ ಸಿಮೆಯೋನನೂ, ಲೇವಿಯೂ ತಮ್ಮ ತಮ್ಮ ಖಡ್ಗಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಧೈರ್ಯವಾಗಿ ಪಟ್ಟಣಕ್ಕೆ ಬಂದು, ಗಂಡಸರನ್ನೆಲ್ಲಾ ಕೊಂದುಹಾಕಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ಹಮೋರನನ್ನೂ, ಅವನ ಮಗನಾದ ಶೆಕೆಮನನ್ನೂ ಅವರು ಖಡ್ಗದಿಂದ ಕೊಂದುಹಾಕಿ, ದೀನಳನ್ನು ಶೆಕೆಮನ ಮನೆಯಿಂದ ಕರೆದುಕೊಂಡು ಹೊರಗೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ಅವರು ತಮ್ಮ ಸಹೋದರಿಯನ್ನು ಕೆಡಿಸಿದ್ದರಿಂದ ಯಾಕೋಬನ ಮಕ್ಕಳು ಬಂದು ಆ ಊರನ್ನೇ ಕೊಳ್ಳೆಹೊಡೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ಪಟ್ಟಣದಲ್ಲಿಯೂ, ಹೊಲದಲ್ಲಿಯೂ ಇದ್ದ ಅವರ ಕುರಿ, ದನ, ಕತ್ತೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ಅವರ ಎಲ್ಲಾ ಆಸ್ತಿಯನ್ನೂ, ಅವರ ಎಲ್ಲಾ ಚಿಕ್ಕ ಮಕ್ಕಳನ್ನೂ, ಅವರ ಹೆಂಡತಿಯರನ್ನೂ ಸೆರೆಹಿಡಿದು, ಮನೆಯಲ್ಲಿ ಇದ್ದದ್ದೆಲ್ಲವನ್ನೂ ಅವರು ಕೊಳ್ಳೆಹೊಡೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ಆಗ ಯಾಕೋಬನು ಸಿಮೆಯೋನನಿಗೂ, ಲೇವಿಗೂ, “ನೀವು ನನ್ನನ್ನು ಈ ದೇಶದ ನಿವಾಸಿಗಳಾದ ಕಾನಾನ್ಯರಿಗೂ ಪೆರಿಜೀಯರಿಗೂ ಅಸಹ್ಯವಾಗುವಂತೆ ಮಾಡಿ, ನನ್ನನ್ನು ಕಳವಳಪಡಿಸಿದಿರಿ. ನಾವು ಸ್ವಲ್ಪ ಜನರು, ಹೀಗಿರುವಲ್ಲಿ ಅವರು ನನಗೆ ವಿರೋಧವಾಗಿ ಕೂಡಿಕೊಂಡು ನನ್ನನ್ನು ದಾಳಿಮಾಡುವರು. ಆಗ ನಾನೂ, ನನ್ನ ಮನೆಯವರೂ ನಾಶವಾಗುವೆವು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ಆದರೆ ಅವರು, “ಅವನು ನಮ್ಮ ತಂಗಿಯನ್ನು ವೇಶ್ಯೆಯಂತೆ ನಡೆಸಬಹುದೋ?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ದೇವರು ಯಾಕೋಬನಿಗೆ, “ನೀನು ಇಲ್ಲಿಂದ ಬೇತೇಲಿಗೆ ಹೋಗಿ ಅಲ್ಲಿ ವಾಸಮಾಡು, ನಿನ್ನ ಸಹೋದರ ಏಸಾವನ ಎದುರಿನಿಂದ ಓಡಿ ಹೋಗುತ್ತಿದ್ದಾಗ, ನಿನಗೆ ಕಾಣಿಸಿಕೊಂಡ ದೇವರಿಗೆ ಅಲ್ಲಿ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ಆಗ ಯಾಕೋಬನು ತನ್ನ ಮನೆಯವರಿಗೂ, ತನ್ನ ಸಂಗಡ ಇದ್ದವರೆಲ್ಲರಿಗೂ, “ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿರುವ ಅನ್ಯದೇವರುಗಳನ್ನು ತೆಗೆದುಹಾಕಿ ಶುದ್ಧರಾಗಿರಿ, ನೀವು ನಿಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಬದಲಾಯಿಸಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ನಾವು ಇಲ್ಲಿಂದ ಹೊರಟು ಬೇತೇಲಿಗೆ ಹೋಗೋಣ. ಕಷ್ಟಕಾಲದಲ್ಲಿ ನನ್ನ ವಿಜ್ಞಾಪನೆಯನ್ನು ಆಲಿಸಿ, ನಾನು ಹೋದ ದಾರಿಯಲ್ಲಿ ನನ್ನ ಸಂಗಡ ಇದ್ದ ದೇವರಿಗೆ ಅಲ್ಲಿ ನಾನು ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ಆಗ ಅವರು ತಮ್ಮ ಬಳಿಯಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಅನ್ಯದೇವರುಗಳನ್ನೂ, ತಮ್ಮ ಕಿವಿಗಳಲ್ಲಿದ್ದ ಮುರುವುಗಳನ್ನೂ ತೆಗೆದು, ಯಾಕೋಬನಿಗೆ ಕೊಟ್ಟರು. ಅವನು ಅವುಗಳನ್ನು ಶೆಕೆಮ್ ಊರಿಗೆ ಸಮೀಪವಾಗಿದ್ದ ಏಲಾ ಮರದ ಕೆಳಗೆ ಹೂಳಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ತರುವಾಯ ಅವರು ಮುಂದೆ ಪ್ರಯಾಣಮಾಡಿದರು. ಆಗ ಸುತ್ತಲಿರುವ ಪಟ್ಟಣಗಳವರ ಮೇಲೆ ದೇವರ ಭಯವು ಇದ್ದುದರಿಂದ, ಅವರು ಯಾಕೋಬನ ಮಕ್ಕಳನ್ನು ಬೆನ್ನಟ್ಟಿ ಬರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ಹೀಗೆ ಯಾಕೋಬನು ತನ್ನ ಸಂಗಡ ಇದ್ದ ಎಲ್ಲಾ ಜನರಸಹಿತವಾಗಿ ಕಾನಾನ್ ದೇಶದಲ್ಲಿರುವ ಬೇತೇಲ್ ಎಂಬ ಲೂಜಿಗೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ಅಲ್ಲಿ ಅವನು ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿ, ತಾನು ತನ್ನ ಸಹೋದರನ ಬಳಿಯಿಂದ ಓಡಿಹೋದಾಗ, ಅಲ್ಲಿ ದೇವರು ತನಗೆ ಪ್ರತ್ಯಕ್ಷನಾದದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಏಲ್ ಬೇತೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ಆಗ ರೆಬೆಕ್ಕಳ ದಾದಿಯಾಗಿದ್ದ ದೆಬೋರಳು ಮರಣಹೊಂದಿದಳು. ಬೇತೇಲಿನ ಕೆಳಗಿದ್ದ ಏಲಾ ಮರದ ಬುಡದಲ್ಲಿ ಆಕೆಯನ್ನು ಹೂಳಿಟ್ಟರು. ಆ ಸ್ಥಳಕ್ಕೆ ಅಲ್ಲೋನ್ ಬಾಕೂತ್ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ಯಾಕೋಬನು ಪದ್ದನ್ ಅರಾಮಿನಿಂದ ಬಂದಾಗ, ದೇವರು ಅವನಿಗೆ ಇನ್ನೊಂದು ಸಾರಿ ಪ್ರತ್ಯಕ್ಷನಾಗಿ, ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ದೇವರು ಅವನಿಗೆ, “ಈಗ ನಿನಗೆ ಯಾಕೋಬನೆಂದು ಹೆಸರಿರುವುದು. ಆದರೆ ಇನ್ನು ಮೇಲೆ ನೀನು ಯಾಕೋಬನೆಂದು ಕರೆಸಿಕೊಳ್ಳದೆ, ‘ಇಸ್ರಾಯೇಲ್,’ ಎಂದು ಕರೆಸಿಕೊಳ್ಳುವೆ,” ಎಂದು ಹೇಳಿ, ಅವನಿಗೆ ಇಸ್ರಾಯೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ದೇವರು ಅವನಿಗೆ, “ಸರ್ವಶಕ್ತ ದೇವರು ನಾನೇ. ನೀನು ಅಭಿವೃದ್ಧಿಯಾಗಿ, ನಿನ್ನ ಸಂತಾನವು ಹೆಚ್ಚಲಿ. ಜನಾಂಗವೂ ಜನಾಂಗಗಳ ಗುಂಪೂ ನಿನ್ನಿಂದ ಉಂಟಾಗುವುವು. ಅರಸರು ನಿನ್ನಿಂದ ಹುಟ್ಟುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ಇದಲ್ಲದೆ ಅಬ್ರಹಾಮನಿಗೂ, ಇಸಾಕನಿಗೂ ನಾನು ಕೊಟ್ಟ ದೇಶವನ್ನು ನಿನಗೆ ಕೊಡುವೆನು. ನಿನ್ನ ತರುವಾಯ ನಿನ್ನ ಸಂತತಿಗೂ ಈ ದೇಶವನ್ನು ಕೊಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ದೇವರು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿದ ಸ್ಥಳದಿಂದ ಮೇಲಕ್ಕೇರಿ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ಯಾಕೋಬನು ತನ್ನ ಸಂಗಡ ದೇವರು ಮಾತನಾಡಿದ, ಆ ಸ್ಥಳದಲ್ಲಿ ಸ್ತಂಭವನ್ನು ಅಂದರೆ ಕಲ್ಲಿನ ಸ್ತಂಭವನ್ನು ನಿಲ್ಲಿಸಿ, ಪಾನಾರ್ಪಣೆ ಮಾಡಿ, ಅದರ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಹೊಯ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ದೇವರು ತನ್ನ ಸಂಗಡ ಮಾತನಾಡಿದ ಸ್ಥಳಕ್ಕೆ ಯಾಕೋಬನು ಬೇತೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ಬೇತೇಲಿನಿಂದ ಅವರು ಪ್ರಯಾಣಮಾಡಿ, ಎಫ್ರಾತೂರಿಗೆ ಇನ್ನೂ ಸ್ವಲ್ಪ ದೂರ ಇರುವಾಗ, ರಾಹೇಲಳು ಪ್ರಸವವೇದನೆಯಿಂದ ಕಷ್ಟಪಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ಹೆರುವುದರಲ್ಲಿ ಆಕೆಯು ಕಷ್ಟಪಡುತ್ತಿದ್ದಾಗ, ಸೂಲಗಿತ್ತಿಯು ಅವಳಿಗೆ, “ನೀನು ಭಯಪಡಬೇಡ, ಈ ಮಗನನ್ನು ಸಹ ನೀನು ಪಡೆಯುವೆ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ಆದರೆ ರಾಹೇಲಳು ಸತ್ತುಹೋದಳು. ಅವಳು ಪ್ರಾಣಬಿಡುವಾಗ, ಮಗನಿಗೆ ಬೆನೋನಿ ಎಂದು ಹೆಸರಿಟ್ಟಳು, ಆದರೆ ಅವನ ತಂದೆ ಅವನಿಗೆ ಬೆನ್ಯಾಮೀನ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ಸತ್ತು ಹೋದ ರಾಹೇಲಳನ್ನು ಬೇತ್ಲೆಹೇಮ್ ಎಂಬ ಎಫ್ರಾತಿಗೆ ಹೋಗುವ ಮಾರ್ಗದಲ್ಲಿ ಹೂಳಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ಯಾಕೋಬನು ಅವಳ ಸಮಾಧಿಯ ಮೇಲೆ ಒಂದು ಸ್ತಂಭವನ್ನು ನೆಟ್ಟನು. ಅದೇ ಇಂದಿನವರೆಗೂ ರಾಹೇಲಳ ಸಮಾಧಿಯ ಸ್ತಂಭವಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ಇಸ್ರಾಯೇಲನು ಪ್ರಯಾಣಮಾಡಿ ಮಿಗ್ದಲ್ ಏದರಿನ ಆಚೆ ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ಇಸ್ರಾಯೇಲನು ಆ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾಗ, ರೂಬೇನನು ಹೋಗಿ ತನ್ನ ತಂದೆಯ ಉಪಪತ್ನಿ ಬಿಲ್ಹಳ ಸಂಗಡ ಮಲಗಿದನು. ಈ ವಿಷಯ ಇಸ್ರಾಯೇಲನಿಗೆ ತಿಳಿಯಿತು. ಯಾಕೋಬನಿಗೆ ಹನ್ನೆರಡು ಮಂದಿ ಪುತ್ರರು ಇದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ಅವರಲ್ಲಿ ಲೇಯಳ ಪುತ್ರರು: ಯಾಕೋಬನ ಚೊಚ್ಚಲ ಮಗ ರೂಬೇನ್, ಸಿಮೆಯೋನ್, ಲೇವಿ, ಯೆಹೂದ, ಇಸ್ಸಾಕಾರ್ ಮತ್ತು ಜೆಬುಲೂನ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ರಾಹೇಲಳ ಪುತ್ರರು: ಯೋಸೇಫ್ ಮತ್ತು ಬೆನ್ಯಾಮೀನ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ರಾಹೇಲಳ ದಾಸಿ ಬಿಲ್ಹಳ ಪುತ್ರರು: ದಾನ್, ನಫ್ತಾಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ಲೇಯಳ ದಾಸಿ ಜಿಲ್ಪಳ ಪುತ್ರರು: ಗಾದ್ ಮತ್ತು ಆಶೇರ್. ಇವರೇ ಪದ್ದನ್ ಅರಾಮಿನಲ್ಲಿ ಯಾಕೋಬನಿಗೆ ಹುಟ್ಟಿದ ಮಕ್ಕಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ಯಾಕೋಬನು ಮಮ್ರೆಯಲ್ಲಿದ್ದ ತನ್ನ ತಂದೆ ಇಸಾಕನ ಬಳಿಗೆ ಅಬ್ರಹಾಮನೂ, ಇಸಾಕನೂ ಪ್ರವಾಸಿಗರಾಗಿ ವಾಸವಾಗಿದ್ದ ಹೆಬ್ರೋನ್ ಎಂಬ ಕಿರ್ಯತ್ ಅರ್ಬ ಪಟ್ಟಣಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ಆಗ ಇಸಾಕನು ನೂರ ಎಂಬತ್ತು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ಇಸಾಕನು ಮುದುಕನಾಗಿಯೂ, ತುಂಬಾ ಆಯುಷ್ಯವುಳ್ಳವನಾಗಿಯೂ ಮರಣಹೊಂದಿ ತನ್ನ ಪಿತೃಗಳೊಂದಿಗೆ ಸೇರಿದನು. ಅವನ ಮಕ್ಕಳಾದ ಏಸಾವನೂ, ಯಾಕೋಬನೂ ಅವನನ್ನು ಸಮಾಧಿಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ಎದೋಮ್ ಎಂಬ ಏಸಾವನ ವಂಶಾವಳಿ ಇದು: ");
INSERT INTO kanokcv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ಏಸಾವನು ಕಾನಾನ್ಯರ ಪುತ್ರಿಯರನ್ನು ಅಂದರೆ, ಹಿತ್ತಿಯನಾದ ಏಲೋನನ ಮಗಳಾದ ಆದಾ, ಹಿವ್ವಿಯನಾದ ಸಿಬೆಯೋನನ ಮಗಳಾದ ಅನಾಹಳ ಮಗಳಾಗಿದ್ದ ಒಹೊಲೀಬಾಮ, ");
INSERT INTO kanokcv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ಇಷ್ಮಾಯೇಲನ ಮಗಳೂ ನೆಬಾಯೋತನ ಸಹೋದರಿಯೂ ಆಗಿದ್ದ ಬಾಸೆಮತ್ ಇವರನ್ನು ಮದುವೆಯಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ಆದಾಳು ಏಸಾವನಿಗೆ ಎಲೀಫಜನನ್ನು ಹೆತ್ತಳು. ಬಾಸೆಮತಳು ರೆಯೂವೇಲನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ಒಹೊಲೀಬಾಮಳು ಯೆಯೂಷನನ್ನು, ಯಳಾಮನನ್ನು, ಕೋರಹ ಇವರನ್ನು ಹೆತ್ತಳು. ಇವರು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಏಸಾವನಿಗೆ ಹುಟ್ಟಿದ ಪುತ್ರರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ತರುವಾಯ ಏಸಾವನು ತನ್ನ ಹೆಂಡತಿಯರನ್ನೂ ಪುತ್ರಪುತ್ರಿಯರನ್ನೂ ತನ್ನ ಮನೆಯಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಜನರನ್ನೂ ತನ್ನ ಹಿಂಡುಗಳನ್ನೂ ತನ್ನ ಎಲ್ಲಾ ಪಶುಗಳನ್ನೂ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ತಾನು ಸಂಪಾದಿಸಿದ್ದ ಎಲ್ಲಾ ಸಂಪತ್ತನ್ನೂ ತೆಗೆದುಕೊಂಡು, ತನ್ನ ಸಹೋದರನಾದ ಯಾಕೋಬನ ಬಳಿಯಿಂದ ಸ್ವಲ್ಪ ದೂರವಿದ್ದ ಮತ್ತೊಂದು ಊರಿಗೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ಏಕೆಂದರೆ ಅವರ ಸಂಪತ್ತು ಅವರು ಕೂಡಿ ಇರುವುದಕ್ಕೆ ಆಗದಷ್ಟು ಅಭಿವೃದ್ಧಿಯಾಗಿತ್ತು. ಅವರ ಪಶುಪ್ರಾಣಿಗಳಿಗೋಸ್ಕರ ಅವರು ಪ್ರವಾಸವಾಗಿದ್ದ ದೇಶವು ಅವರಿಗೆ ಸಾಲದೆ ಹೋಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ಹೀಗೆ ಎದೋಮನು ಎಂಬ ಏಸಾವನು ಸೇಯೀರ್ ಪರ್ವತದಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ಸೇಯೀರ್ ಪರ್ವತದಲ್ಲಿರುವ ಎದೋಮ್ಯರ ತಂದೆ ಏಸಾವನ ವಂಶಾವಳಿಗಳು ಇವೇ: ");
INSERT INTO kanokcv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ಏಸಾವನ ಪುತ್ರರ ಹೆಸರುಗಳು ಯಾವುವೆಂದರೆ: ಏಸಾವನ ಹೆಂಡತಿಯಾಗಿರುವ ಆದಾ ಎಂಬಾಕೆಯ ಮಗನಾಗಿರುವ ಎಲೀಫಜನು, ಏಸಾವನ ಹೆಂಡತಿ ಬಾಸೆಮತಳ ಮಗ ರೆಯೂವೇಲನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ಎಲೀಫಜನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ತೇಮಾನ್, ಓಮಾರ್, ಚೆಫೋ, ಗತಾಮ್, ಕೆನಜ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ತಿಮ್ನಾಳು ಏಸಾವನ ಮಗ ಎಲೀಫಜನಿಗೆ ಉಪಪತ್ನಿಯಾಗಿದ್ದು, ಅಮಾಲೇಕನನ್ನು ಹೆತ್ತಳು. ಏಸಾವನ ಹೆಂಡತಿಯಾಗಿದ್ದ ಆದಾ ಎಂಬಾಕೆಯ ಪುತ್ರರು ಇವರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ರೆಯೂವೇಲನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ನಹತ್, ಜೆರಹ, ಶಮ್ಮಾ ಮತ್ತು ಮಿಜ್ಜಾ, ಇವರು ಏಸಾವನ ಹೆಂಡತಿ ಬಾಸೆಮತಳ ಮೊಮ್ಮಕ್ಕಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ಏಸಾವನ ಹೆಂಡತಿಯಾಗಿದ್ದ ಸಿಬೆಯೋನನ ಮಗಳಾಗಿರುವ ಅನಾಹಳ ಮಗಳಾದ ಒಹೊಲೀಬಾಮಳ ಪುತ್ರರು ಯಾರೆಂದರೆ: ಆಕೆಯು ಏಸಾವನಿಗೆ ಯೆಯೂಷ್, ಯಳಾಮ್ ಹಾಗೂ ಕೋರಹ ಇವರನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ಏಸಾವನ ಪುತ್ರರ ಮುಖಂಡರು ಯಾರೆಂದರೆ: ಏಸಾವನ ಚೊಚ್ಚಲ ಮಗನಾಗಿರುವ ಎಲೀಫಜನ ಮಕ್ಕಳಾದ ತೇಮಾನ್, ಓಮಾರ್, ಚೆಫೋ, ಕೆನಜ್, ");
INSERT INTO kanokcv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ಕೋರಹ, ಗತಾಮ್, ಅಮಾಲೇಕ್, ಎದೋಮ್ಯ ದೇಶದಲ್ಲಿದ್ದ ಎಲೀಫಜನಿಂದ ಬಂದ ಮುಖಂಡರು ಇವರೇ. ಇವರು ಆದಾ ಎಂಬಾಕೆಯ ಮೊಮ್ಮಕ್ಕಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ಏಸಾವನ ಮಗ ರೆಯೂವೇಲನ ಪುತ್ರರು ಯಾರೆಂದರೆ: ನಹತ್, ಜೆರಹ, ಶಮ್ಮಾ ಹಾಗೂ ಮಿಜ್ಜಾ; ಎದೋಮ್ ದೇಶದಲ್ಲಿದ್ದ ರೆವುಯೇಲನಿಂದ ಬಂದ ಮುಖಂಡರು ಇವರೇ. ಇವರು ಏಸಾವನ ಹೆಂಡತಿ ಬಾಸೆಮತಳ ಮೊಮ್ಮಕ್ಕಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ಏಸಾವನ ಹೆಂಡತಿ ಒಹೊಲೀಬಾಮಳ ಪುತ್ರರು ಯಾರೆಂದರೆ: ಯೆಯೂಷ್, ಯಳಾಮ್ ಮತ್ತು ಕೋರಹ ಇವರೇ. ಇವರು ಅನಾಹನ ಮಗಳೂ ಏಸಾವನ ಹೆಂಡತಿಯೂ ಆಗಿದ್ದ ಒಹೊಲೀಬಾಮಳಿಂದ ಬಂದ ಮುಖಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ಇವರು ಎದೋಮ್ ಎಂಬ ಏಸಾವನ ಪುತ್ರರು. ಇವರು ಮುಖಂಡರಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ದೇಶದಲ್ಲಿ ವಾಸಿಸುತ್ತಿದ್ದ ಹೋರಿಯನಾದ ಸೇಯೀರನ ಪುತ್ರರು ಯಾರೆಂದರೆ: ಲೋಟಾನ್, ಶೋಬಾಲ್, ಸಿಬೆಯೋನ್, ಅನಾಹ, ");
INSERT INTO kanokcv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ದೀಶೋನ್, ಏಚೆರ್, ದೀಶಾನ್ ಇವರು ಎದೋಮ್ ದೇಶದಲ್ಲಿದ್ದ ಸೇಯೀರನ ಮಕ್ಕಳಾದ ಹೋರಿಯರ ಮುಖಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ಲೋಟಾನನ ಪುತ್ರರು ಯಾರೆಂದರೆ: ಹೋರಿ ಮತ್ತು ಹೋಮಾಮ್. ಲೋಟಾನನಿಗೆ ತಿಮ್ನಾ ಎಂಬ ಸಹೋದರಿ ಇದ್ದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ಶೋಬಾಲನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ಅಲ್ವಾನ್, ಮಾನಹತ್, ಏಬಾಲ್, ಶೆಫೋ ಮತ್ತು ಓನಾಮ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ಸಿಬೆಯೋನನ ಮಕ್ಕಳು: ಅಯ್ಯಾಹ ಮತ್ತು ಅನಾಹ ಎಂಬುವರು. ತನ್ನ ತಂದೆ ಸಿಬೆಯೋನನ ಕತ್ತೆಗಳನ್ನು ಕಾಯುವಾಗ ಕಾಡಿನಲ್ಲಿ ಬಿಸಿನೀರಿನ ಒರತೆಗಳನ್ನು ಕಂಡುಕೊಂಡವನೂ ಅರಣ್ಯದಲ್ಲಿ ಹೇಸರಗತ್ತೆಗಳನ್ನು ಕಂಡುಕೊಂಡವನು ಈ ಅನಾಹನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ಅನಾಹನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ದೀಶೋನ್ ಮತ್ತು ಅನಾಹನ ಮಗಳಾದ ಒಹೊಲೀಬಾಮಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ದೀಶೋನನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ಹೆಮ್ದಾನ್, ಎಷ್ಬಾನ್, ಇತ್ರಾನ್ ಮತ್ತು ಕೆರಾನ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ಏಚೆರನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ಬಿಲ್ಹಾನ್, ಜಾವಾನ್ ಮತ್ತು ಆಕಾನ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ದೀಶಾನನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ಊಚ್ ಮತ್ತು ಅರಾನ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ಹೋರಿಯರಿಂದ ಬಂದ ಮುಖಂಡರು ಯಾರೆಂದರೆ: ಲೋಟಾನ್, ಶೋಬಾಲ್, ಸಿಬೆಯೋನ್, ಅನಾಹ, ");
INSERT INTO kanokcv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ದೀಶೋನ್, ಏಚೆರ್, ದೀಶಾನ್. ಹೋರಿಯರಿಂದ ಹುಟ್ಟಿದ ಸೇಯೀರ್ ದೇಶದಲ್ಲಿ ಮುಖಂಡರು ಇವರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ಇಸ್ರಾಯೇಲರನ್ನು ಯಾವ ಅರಸನೂ ಆಳುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಎದೋಮ್ ದೇಶದಲ್ಲಿ ಆಳಿದ ಅರಸರು ಇವರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ಎದೋಮಿನಲ್ಲಿ ಬೆಯೋರನ ಮಗನಾದ ಬೆಲಗನು ಆಳಿದನು. ಅವನ ಪಟ್ಟಣದ ಹೆಸರು ದಿನ್ಹಾಬಾ. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ಬೆಲಗನ ಮರಣದ ನಂತರ ಅವನ ಬದಲಾಗಿ ಬೊಚ್ರದವನಾದ ಜೆರಹನ ಮಗ ಯೋಬಾಬನು ಉತ್ತರಾಧಿಕಾರಿಯಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ಯೋಬಾಬನ ಮರಣದ ನಂತರ ಅವನ ಬದಲಾಗಿ ತೇಮಾನೀಯರ ದೇಶದ ಹುಷಾಮನು ಅರಸನಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ಹುಷಾಮನ ಮರಣದ ನಂತರ ಅವೀತದ ಬೆದದನ ಮಗ ಹದದ ಅರಸನಾದನು. ಇವನು ಮೋವಾಬ್ ದೇಶದಲ್ಲಿ ನಡೆದ ಯುದ್ಧದಲ್ಲಿ ಮಿದ್ಯಾನರನ್ನು ಸೋಲಿಸಿದ; ಅವನ ರಾಜಧಾನಿಯ ಹೆಸರು ಅವೀತ್. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ಹದದ ಮೃತನಾದ ಮೇಲೆ ಅವನ ಬದಲಾಗಿ ಮಸ್ರೇಕದವನಾದ ಸಮ್ಲಾಹನು ಅರಸನಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ಸಮ್ಲಾಹನ ಮರಣದ ನಂತರ ಅವನ ಬದಲಾಗಿ ಯೂಫ್ರೇಟೀಸ್ ನದಿತೀರದಲ್ಲಿರುವ ರೆಹೋಬೋತ್ ಊರಿನ ಸೌಲನು ಅರಸನಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ಸೌಲನು ಮೃತನಾದ ಮೇಲೆ ಅಕ್ಬೋರನ ಮಗ ಬಾಳ್ ಹಾನಾನ್ ಅರಸನಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ಅಕ್ಬೋರನ ಮಗ ಬಾಳ್ ಹಾನಾನನು ಮೃತನಾದ ಮೇಲೆ ಅವನ ಬದಲಾಗಿ ಹದದನು ಆಳಿದನು. ಅವನ ಪಟ್ಟಣದ ಹೆಸರು ಪಾವು. ಅವನ ಹೆಂಡತಿಯ ಹೆಸರು ಮೆಹೇಟಬೇಲ್. ಈಕೆಯು ಮೇಜಾಹಾಬನ ಮಗಳಾದ ಮಟ್ರೇದಳ ಮಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ಕುಟುಂಬ, ಸ್ಥಳ, ಹೆಸರುಗಳ ಪ್ರಕಾರವಾಗಿ ಏಸಾವನ ಮುಖಂಡರ ಹೆಸರುಗಳು ಯಾವುವೆಂದರೆ: ತಿಮ್ನಾ, ಅಲ್ವಾ, ಯೆತೇತ, ");
INSERT INTO kanokcv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ಒಹೊಲೀಬಾಮ, ಏಲಾ, ಪೀನೋನ್, ");
INSERT INTO kanokcv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ಕೆನಜ್, ತೇಮಾನ್, ಮಿಬ್ಜಾರ, ");
INSERT INTO kanokcv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ಮಗ್ದೀಯೇಲ್ ಮತ್ತು ಗೀರಾಮ್ ಇವರೇ ತಮ್ಮ ನಿವಾಸಸ್ಥಳಗಳ ಪ್ರಕಾರ ಎದೋಮ್ಯರ ಮುಖಂಡರು. ಎದೋಮ್ಯರ ತಂದೆ ಏಸಾವನು ವಂಶಾವಳಿ ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ಯಾಕೋಬನು ತನ್ನ ತಂದೆ ಪ್ರವಾಸಿಯಾಗಿದ್ದ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ಇದು ಯಾಕೋಬನ ವಂಶದವರ ಚರಿತ್ರೆ: ಯೋಸೇಫನು ಹದಿನೇಳು ವರ್ಷದವನಾಗಿದ್ದಾಗ, ತನ್ನ ಸಹೋದರರ ಸಂಗಡ ಅಂದರೆ, ತನ್ನ ತಂದೆಯ ಹೆಂಡತಿಯರಾಗಿದ್ದ ಬಿಲ್ಹಳ ಮತ್ತು ಜಿಲ್ಪಳ ಮಕ್ಕಳ ಸಂಗಡ ಕುರಿಮಂದೆಗಳನ್ನು ಕಾಯುತ್ತಿದ್ದನು. ಯೋಸೇಫನು ಅವರ ಕೆಟ್ಟತನದ ಸುದ್ದಿಯನ್ನು ತನ್ನ ತಂದೆಗೆ ತಿಳಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ಯೋಸೇಫನು ಇಸ್ರಾಯೇಲನಿಗೆ ಮುಪ್ಪಿನ ವಯಸ್ಸಿನಲ್ಲಿ ಹುಟ್ಟಿದ ಮಗನಾಗಿದ್ದುದರಿಂದ ಅವನು ತನ್ನ ಎಲ್ಲಾ ಮಕ್ಕಳಿಗಿಂತ ಅವನನ್ನು ಹೆಚ್ಚು ಪ್ರೀತಿಮಾಡಿ, ಅವನಿಗೆ ಅನೇಕ ಬಣ್ಣಗಳ ಅಂಗಿಯನ್ನು ಹೊಲಿಸಿಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ತಮ್ಮ ತಂದೆಯು ಅವನನ್ನು ಎಲ್ಲಾ ಸಹೋದರರಿಗಿಂತ ಹೆಚ್ಚು ಪ್ರೀತಿಮಾಡುತ್ತಿರುವುದನ್ನು ಅವನ ಸಹೋದರರು ಕಂಡು, ಅವನನ್ನು ದ್ವೇಷಿಸಿ, ಅವನ ಸಂಗಡ ಸಮಾಧಾನದಿಂದ ಮಾತಾಡದೆಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ಯೋಸೇಫನು ಒಂದು ಕನಸನ್ನು ಕಂಡು ತನ್ನ ಸಹೋದರರಿಗೆ ತಿಳಿಸಿದಾಗ, ಅವರು ಅವನನ್ನು ಇನ್ನೂ ಹೆಚ್ಚಾಗಿ ದ್ವೇಷಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ಅವನು ಅವರಿಗೆ, “ನಾನು ಕಂಡ ಈ ಕನಸನ್ನು ಹೇಳುತ್ತೇನೆ ಕೇಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ನಾವು ಹೊಲದಲ್ಲಿ ಸಿವುಡುಗಳನ್ನು ಕಟ್ಟುತ್ತಾ ಇದ್ದೆವು. ನನ್ನ ಸಿವುಡು ಎದ್ದುನಿಂತಿತು. ಆಗ ನಿಮ್ಮ ಸಿವುಡುಗಳು ತಿರುಗಿ ನನ್ನ ಸಿವುಡಿಗೆ ಅಡ್ಡಬಿದ್ದವು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ಆಗ ಅವನ ಸಹೋದರರು ಅವನಿಗೆ, “ನೀನು ನಮ್ಮನ್ನು ನಿಶ್ಚಯವಾಗಿಯೂ ಆಳುವೆಯೋ? ನಿಜವಾಗಿ ನಮ್ಮ ಮೇಲೆ ದೊರೆತನ ಮಾಡುವಿಯೋ?” ಎಂದು ಹೇಳಿ, ಅವನ ಕನಸು ಮತ್ತು ಅವನ ಮಾತುಗಳಿಗೆ ಅವನನ್ನು ಮತ್ತಷ್ಟೂ ದ್ವೇಷಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ಇದಲ್ಲದೆ ಅವನು ಇನ್ನೊಂದು ಕನಸನ್ನು ಕಂಡು ತನ್ನ ಸಹೋದರರಿಗೆ, “ಇನ್ನೊಂದು ಕನಸನ್ನು ಕಂಡಿದ್ದೇನೆ. ಸೂರ್ಯನೂ ಚಂದ್ರನೂ ಹನ್ನೊಂದು ನಕ್ಷತ್ರಗಳೂ ನನಗೆ ಅಡ್ಡಬಿದ್ದವು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ಅವನು ತನ್ನ ತಂದೆಗೂ ತನ್ನ ಸಹೋದರರಿಗೂ ತಿಳಿಸಿದಾಗ, ಅವನ ತಂದೆಯು ಅವನನ್ನು ಗದರಿಸಿ, “ನೀನು ಕಂಡ ಈ ಕನಸು ಏನು? ನಾನು, ನಿನ್ನ ತಾಯಿ, ನಿನ್ನ ಸಹೋದರರೂ ನಿಜವಾಗಿ ನಿನ್ನ ಮುಂದೆ ಅಡ್ಡ ಬೀಳುವುದಕ್ಕೆ ಬರಬೇಕೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ಹೀಗೆ ಅವನ ಸಹೋದರರು ಅವನ ಮೇಲೆ ಹೊಟ್ಟೆಕಿಚ್ಚುಪಟ್ಟರು. ಆದರೆ ಅವನ ತಂದೆ ಆ ಮಾತನ್ನು ಮನಸ್ಸಿನಲ್ಲಿ ಇಟ್ಟುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ಅವನ ಸಹೋದರರು ಶೆಕೆಮಿನಲ್ಲಿ ತಮ್ಮ ತಂದೆಯ ಮಂದೆಯನ್ನು ಮೇಯಿಸುವುದಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ಆದ್ದರಿಂದ ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ಸಹೋದರರು ಶೆಕೆಮಿನಲ್ಲಿ ಮಂದೆಯನ್ನು ಮೇಯಿಸುತ್ತಾರಲ್ಲಾ. ಅವರ ಬಳಿಗೆ ನಾನು ನಿನ್ನನ್ನು ಕಳುಹಿಸುತ್ತೇನೆ ಹೋಗು,” ಎಂದನು. ಅದಕ್ಕೆ ಅವನು, “ಆಗಲಿ ಹೋಗುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ಯಾಕೋಬನು ಅವನಿಗೆ, “ಹೋಗಿ ನಿನ್ನ ಸಹೋದರರ ಕ್ಷೇಮಸಮಾಚಾರವನ್ನೂ, ಮಂದೆಗಳ ಕ್ಷೇಮಸಮಾಚಾರವನ್ನೂ ತಿಳಿದುಕೊಂಡು ಬಂದು ನನಗೆ ತಿಳಿಸು,” ಎಂದು ಹೇಳಿ ಹೆಬ್ರೋನ್ ಕಣಿವೆಯಿಂದ ಕಳುಹಿಸಿದನು. ಯೋಸೇಫನು ಶೆಕೆಮಿಗೆ ಬಂದಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ಒಬ್ಬಾನೊಬ್ಬ ಮನುಷ್ಯನು ಯೋಸೇಫನು ಹೊಲದಲ್ಲಿ ಅಲೆದಾಡುವುದನ್ನು ಕಂಡು ಅವನಿಗೆ, “ನೀನು ಏನು ಹುಡುಕುತ್ತಿದ್ದೀ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ಅದಕ್ಕೆ ಅವನು, “ನನ್ನ ಸಹೋದರರನ್ನು ಹುಡುಕುತ್ತಿದ್ದೇನೆ, ಅವರು ತಮ್ಮ ಮಂದೆಗಳನ್ನು ಎಲ್ಲಿ ಮೇಯಿಸುತ್ತಿದ್ದಾರೆಂದು ದಯವಿಟ್ಟು ನನಗೆ ಹೇಳು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ಆ ಮನುಷ್ಯನು, “ಅವರು ಇಲ್ಲಿಂದ ಹೊರಟು ಹೋದರು. ಅವರು, ‘ನಾವು ದೋತಾನಿಗೆ ಹೋಗೋಣ,’ ಎಂದು ಮಾತಾಡುವದನ್ನು ನಾನು ಕೇಳಿಸಿಕೊಂಡೆ,” ಎಂದನು. ಆಗ ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರನ್ನು ಹುಡುಕಿಕೊಂಡು ಹೋಗಿ ದೋತಾನಿನಲ್ಲಿ ಅವರನ್ನು ಕಂಡುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ಅವರು ದೂರದಿಂದ ಅವನನ್ನು ನೋಡಿದಾಗ, ಅವನು ಸಮೀಪಕ್ಕೆ ಬರುವ ಮುಂಚೆಯೇ ಅವನನ್ನು ಕೊಂದುಹಾಕಬೇಕೆಂದು ಅವನಿಗೆ ವಿರೋಧವಾಗಿ ಒಳಸಂಚು ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ಅವರು, “ಇಗೋ, ಈ ಕನಸುಗಾರ ಬರುತ್ತಿದ್ದಾನೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ಬನ್ನಿರಿ, ಈಗ ಅವನನ್ನು ಕೊಂದು, ಯಾವುದೋ ಒಂದು ಕಾಡುಮೃಗವು ಅವನನ್ನು ತಿಂದುಬಿಟ್ಟಿತೆಂದು ಹೇಳೋಣ. ತರುವಾಯ ಅವನ ಕನಸುಗಳು ಏನಾಗುವವೋ ನೋಡೋಣ,” ಎಂದು ಒಬ್ಬರಿಗೊಬ್ಬರು ಮಾತನಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ಆದರೆ ರೂಬೇನನು ಅದನ್ನು ಕೇಳಿ, ಅವನನ್ನು ಅವರ ಕೈಗಳಿಂದ ತಪ್ಪಿಸಿ, “ಅವನನ್ನು ಕೊಲ್ಲುವುದು ಬೇಡ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ರೂಬೇನನು ಅವನನ್ನು ಅವರ ಕೈಗಳಿಂದ ತಪ್ಪಿಸಿ, ತನ್ನ ತಂದೆಯ ಬಳಿಗೆ ತಿರುಗಿ ಕರೆದುಕೊಂಡುಹೋಗುವ ಉದ್ದೇಶದಿಂದ ಅವರಿಗೆ, “ರಕ್ತ ಚೆಲ್ಲಬೇಡಿರಿ, ಕಾಡಿನಲ್ಲಿರುವ ಈ ಗುಂಡಿಯಲ್ಲಿ ಹಾಕಿರಿ, ಆದರೆ ಅವನ ಮೇಲೆ ಕೈಹಾಕಬೇಡಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರ ಬಳಿಗೆ ಬಂದಾಗ, ಅವರು ಯೋಸೇಫನ ಮೇಲಿದ್ದ ಬಣ್ಣಗಳ ಅಂಗಿಯನ್ನು ತೆಗೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ಅವನನ್ನು ತೆಗೆದುಕೊಂಡು ಗುಂಡಿಯಲ್ಲಿ ಹಾಕಿದರು. ಆ ಗುಂಡಿ ನೀರಿಲ್ಲದೆ ಬರಿದಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ಅವರು ಊಟಕ್ಕೆ ಕುಳಿತುಕೊಂಡಾಗ, ತಮ್ಮ ಕಣ್ಣುಗಳನ್ನೆತ್ತಿ ನೋಡಲಾಗಿ, ಇಷ್ಮಾಯೇಲರ ಗುಂಪು ಗಿಲ್ಯಾದಿನಿಂದ ಬರುತ್ತಿತ್ತು. ಅವರ ಒಂಟೆಗಳು ಸಾಂಬ್ರಾಣಿ, ಸುಗಂಧ ತೈಲ, ರಕ್ತಬೋಳಗಳನ್ನು ಹೊರುತ್ತಿದ್ದವು. ಅವರು ಅವುಗಳನ್ನು ಈಜಿಪ್ಟಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ಆಗ ಯೆಹೂದನು ತನ್ನ ಸಹೋದರರಿಗೆ, “ನಾವು ನಮ್ಮ ಸಹೋದರನನ್ನು ಕೊಂದುಹಾಕಿ, ಅವನ ರಕ್ತವನ್ನು ಮರೆಮಾಡುವುದರಲ್ಲಿ ಲಾಭವೇನು? ");
INSERT INTO kanokcv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ಬನ್ನಿರಿ, ಇಷ್ಮಾಯೇಲರಿಗೆ ಅವನನ್ನು ಮಾರೋಣ. ನಾವು ಅವನ ಮೇಲೆ ಕೈಹಾಕಬಾರದು. ಏಕೆಂದರೆ ಅವನು ನಮ್ಮ ಸಹೋದರನೂ ನಮ್ಮ ದೇಹವೂ ರಕ್ತವೂ ಆಗಿದ್ದಾನೆ,” ಎಂದನು. ಅದಕ್ಕೆ ಅವನ ಸಹೋದರರು ಒಪ್ಪಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ಈ ಪ್ರಕಾರ ಮಿದ್ಯಾನ್ಯರ ವರ್ತಕರು ಹಾದುಹೋಗುತ್ತಿದ್ದಾಗ, ಅವರು ಯೋಸೇಫನನ್ನು ಗುಂಡಿಯಿಂದ ಮೇಲೆತ್ತಿ, ಇಷ್ಮಾಯೇಲರಿಗೆ ಅವನನ್ನು ಇಪ್ಪತ್ತು ಬೆಳ್ಳಿಯ ನಾಣ್ಯಗಳಿಗೆ ಮಾರಿದರು. ಅವರು ಯೋಸೇಫನನ್ನು ಈಜಿಪ್ಟಿಗೆ ಕರೆದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ರೂಬೇನನು ಗುಂಡಿಯ ಬಳಿಗೆ ತಿರುಗಿ ಬಂದಾಗ, ಯೋಸೇಫನು ಗುಂಡಿಯಲ್ಲಿ ಇಲ್ಲದ್ದರಿಂದ, ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ಹರಿದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ಅವನು ತನ್ನ ಸಹೋದರರ ಬಳಿಗೆ ತಿರುಗಿ ಹೋಗಿ, “ಬಾಲಕನು ಅಲ್ಲಿ ಇಲ್ಲವಲ್ಲಾ, ನಾನು ಎಲ್ಲಿಗೆ ಹೋಗಲಿ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ಆಗ ಅವರು ಯೋಸೇಫನ ಅಂಗಿಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಒಂದು ಹೋತವನ್ನು ಕೊಯ್ದು, ಆ ಅಂಗಿಯನ್ನು ರಕ್ತದಲ್ಲಿ ಅದ್ದಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ಆ ಬಣ್ಣದ ಅಂಗಿಯನ್ನು ಅವರು ತಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ತಂದು, “ಇದು ನಮಗೆ ಸಿಕ್ಕಿತು, ಇದು ನಿನ್ನ ಮಗನ ಅಂಗಿಯೋ ಏನೋ ನೋಡು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ಯಾಕೋಬನು ಅದನ್ನು ಗುರುತು ಹಿಡಿದು, “ಇದು ನನ್ನ ಮಗನ ಅಂಗಿ ಹೌದು, ದುಷ್ಟಮೃಗವು ಅವನನ್ನು ತಿಂದುಬಿಟ್ಟಿತು, ಯೋಸೇಫನನ್ನು ನಿಸ್ಸಂದೇಹವಾಗಿ ಸೀಳಿಹಾಕಿರಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ಆಗ ಯಾಕೋಬನು ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ಹರಿದುಕೊಂಡು ತನ್ನ ನಡುವಿಗೆ ಗೋಣಿಯನ್ನು ಕಟ್ಟಿಕೊಂಡು ತನ್ನ ಮಗನಿಗೋಸ್ಕರ ಬಹುದಿನ ದುಃಖಪಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ಅವನ ಪುತ್ರಪುತ್ರಿಯರೆಲ್ಲಾ ಅವನನ್ನು ಆದರಿಸಿದರೂ ಅವನು ಆದರಣೆ ಹೊಂದಲೊಲ್ಲದೆ, “ನನ್ನ ಮಗನಿರುವ ಸಮಾಧಿಗೆ ದುಃಖದಿಂದಲೇ ಇಳಿದು ಹೋಗುವೆನು,” ಎಂದನು. ಹೀಗೆ ಅವನ ತಂದೆ ಅವನಿಗೋಸ್ಕರ ಅತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ಇದರೊಂದಿಗೆ, ಆ ಮಿದ್ಯಾನ್ಯರು ಯೋಸೇಫನನ್ನು ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆ ತೆಗೆದುಕೊಂಡುಹೋಗಿ ಪೋಟೀಫರನಿಗೆ ಮಾರಿದರು. ಇವನು ಫರೋಹನ ಉದ್ಯೋಗಸ್ಥನೂ ಮೈಗಾವಲಿನ ದಳಪತಿಯೂ ಆಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ಆ ಕಾಲದಲ್ಲಿ ಯೆಹೂದನು ತನ್ನ ಸಹೋದರರ ಬಳಿಯಿಂದ ಹೊರಟು, ಅದುಲ್ಲಾಮೂರಿನವನಾದ ಹೀರಾನ ಬಳಿಗೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ಅಲ್ಲಿ ಯೆಹೂದನು ಕಾನಾನ್ಯನಾದ ಶೂಗನ ಮಗಳನ್ನು ಕಂಡು, ಅವಳನ್ನು ಮದುವೆಯಾಗಿ ಅವಳನ್ನು ಕೂಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ಅವಳು ಗರ್ಭಿಣಿಯಾಗಿ ಮಗನನ್ನು ಹೆತ್ತಳು. ಯೆಹೂದನು ಅವನಿಗೆ ಏರ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ಆಕೆಯು ತಿರುಗಿ ಗರ್ಭಿಣಿಯಾಗಿ ಮಗನನ್ನು ಹೆತ್ತು, ಅವನಿಗೆ ಓನಾನ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ಆಕೆಯು ಮತ್ತೊಂದು ಸಾರಿ ಮಗನನ್ನು ಹೆತ್ತು, ಅವನಿಗೆ ಶೇಲಹ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಆಕೆಯು ಅವನನ್ನು ಹೆತ್ತಾಗ, ಯೆಹೂದನು ಕೆಜೀಬಿನಲ್ಲಿ ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ಇದಾದ ಮೇಲೆ ಯೆಹೂದನು ತನ್ನ ಜೇಷ್ಠಪುತ್ರ ಏರನಿಗೆ ತಾಮಾರ್ ಎಂಬ ಹೆಣ್ಣನ್ನು ತಂದು ಮದುವೆಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ಆದರೆ ಯೆಹೂದನ ಜೇಷ್ಠಪುತ್ರ ಏರನು ಯೆಹೋವ ದೇವರ ದೃಷ್ಟಿಯಲ್ಲಿ ದುಷ್ಟನಾಗಿದ್ದುದರಿಂದ, ಯೆಹೋವ ದೇವರು ಅವನನ್ನು ಸಾವಿಗೀಡುಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ಆಗ ಯೆಹೂದನು ಓನಾನನಿಗೆ, “ನಿನ್ನ ಸಹೋದರನ ಹೆಂಡತಿಯ ಬಳಿಗೆ ಹೋಗಿ, ಅವಳನ್ನು ಮದುವೆಯಾಗಿ, ನಿನ್ನ ಅಣ್ಣನಿಗೆ ಸಂತತಿಯನ್ನು ಉಂಟುಮಾಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ಆದರೆ ಓನಾನನು ಆ ಸಂತತಿಯು ತನ್ನದಾಗತಕ್ಕದ್ದಲ್ಲವೆಂದು ತಿಳಿದುಕೊಂಡು, ತನ್ನ ಅಣ್ಣನಿಗೆ ಸಂತತಿಯನ್ನು ಉಂಟು ಮಾಡದ ಹಾಗೆ, ತನ್ನ ವೀರ್ಯವನ್ನು ನೆಲದ ಮೇಲೆ ಚೆಲ್ಲಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ಅವನು ಮಾಡಿದ್ದು ಯೆಹೋವ ದೇವರ ದೃಷ್ಟಿಯಲ್ಲಿ ಮೆಚ್ಚಿಗೆಯಾಗಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಅವರು ಇವನನ್ನೂ ಸಾವಿಗೀಡುಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ಆಗ ಯೆಹೂದನು ತನ್ನ ಸೊಸೆ ತಾಮಾರಳಿಗೆ, “ನನ್ನ ಮಗ ಶೇಲಹನು ದೊಡ್ಡವನಾಗುವವರೆಗೆ ವಿಧವೆಯಾಗಿದ್ದು, ನಿನ್ನ ತಂದೆಯ ಮನೆಯಲ್ಲಿರು,” ಎಂದನು. ಏಕೆಂದರೆ ಇವನು ಸಹ ತನ್ನ ಸಹೋದರರ ಹಾಗೆ ಸತ್ತಾನೆಂದು ಅಂದುಕೊಂಡನು. ತಾಮಾರಳಾದರೋ ಹೋಗಿ ತನ್ನ ತಂದೆಯ ಮನೆಯಲ್ಲಿ ವಾಸಮಾಡಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ಬಹಳ ದಿನಗಳಾದ ಮೇಲೆ ಯೆಹೂದನ ಹೆಂಡತಿಯಾಗಿದ್ದ ಶೂಗನ ಮಗಳು ಸತ್ತಳು. ಯೆಹೂದನು ಆದರಣೆ ಹೊಂದಿದ ಮೇಲೆ, ತಾನೂ, ತನ್ನ ಸ್ನೇಹಿತನಾಗಿರುವ ಅದುಲ್ಲಾಮ್ಯನಾದ ಹೀರಾನನೂ ತನ್ನ ಕುರಿಗಳ ಉಣ್ಣೆಯನ್ನು ಕತ್ತರಿಸುವವರ ಬಳಿಗೆ ತಿಮ್ನಾ ಊರಿಗೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ಆಗ ತಾಮಾರಳಿಗೆ, “ನಿನ್ನ ಮಾವನು ತನ್ನ ಕುರಿಗಳ ಉಣ್ಣೆಯನ್ನು ಕತ್ತರಿಸುವುದಕ್ಕೆ ತಿಮ್ನಾ ಊರಿಗೆ ಹೋಗುತ್ತಿದ್ದಾನೆ,” ಎಂದು ತಿಳಿಸಿದಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ಆಕೆಯು ವಿಧವೆಯ ವಸ್ತ್ರಗಳನ್ನು ತೆಗೆದಿಟ್ಟು, ಮುಸುಕುಹಾಕಿ ಮುಚ್ಚಿಕೊಂಡು, ತಿಮ್ನಾ ಊರಿನ ಮಾರ್ಗದಲ್ಲಿರುವ ಏನಯಿಮೂರಿನ ಬಹಿರಂಗ ಸ್ಥಳದಲ್ಲಿ ಕೂತುಕೊಂಡಳು. ಏಕೆಂದರೆ ಶೇಲಹನು ದೊಡ್ಡವನಾಗಿದ್ದರೂ ತನ್ನನ್ನು ಅವನಿಗೆ ಹೆಂಡತಿಯಾಗಿ ಕೊಡಲಿಲ್ಲವೆಂದು ಹಾಗೆ ಮಾಡಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ಯೆಹೂದನು ಅವಳನ್ನು ಕಂಡಾಗ, ಅವಳು ಮುಖ ಮುಚ್ಚಿಕೊಂಡಿದ್ದರಿಂದ ಅವಳು ವೇಶ್ಯೆಯೆಂದು ತಿಳಿದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ಮಾರ್ಗದಿಂದ ಆಕೆಯ ಕಡೆಗೆ ತಿರುಗಿಕೊಂಡು ಅವನು, “ನನ್ನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ಬರಗೊಡಿಸು,” ಎಂದನು. ಏಕೆಂದರೆ ಅವಳು ತನ್ನ ಸೊಸೆಯೆಂದು ಅವನಿಗೆ ತಿಳಿದಿರಲಿಲ್ಲ. ಅವಳು, “ನೀನು ನನ್ನ ಬಳಿಗೆ ಬಂದರೆ, ನನಗೆ ಏನು ಕೊಡುವೆ?” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ಅವನು, “ಮಂದೆಯಿಂದ ನಿನಗೆ ಮೇಕೆಯ ಮರಿಯನ್ನು ಕಳುಹಿಸುತ್ತೇನೆ,” ಎಂದನು. ಅವಳು, “ನೀನು ಅದನ್ನು ಕಳುಹಿಸುವವರೆಗೆ ಈಡು ಕೊಡುವೆಯೋ?” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ಅದಕ್ಕೆ ಅವನು, “ನಿನಗೆ ಕೊಡತಕ್ಕ ಈಡು ಏನು?” ಎಂದಾಗ. ಅವಳು, “ನಿನ್ನ ಮುದ್ರೆಯೂ ನಿನ್ನ ದಾರವೂ ನಿನ್ನ ಕೈಯಲ್ಲಿರುವ ಕೋಲೂ,” ಎಂದಳು. ಆಗ ಅವನು ಅವುಗಳನ್ನು ಆಕೆಗೆ ಕೊಟ್ಟು, ಆಕೆಯನ್ನು ಕೂಡಿದನು. ಹೀಗೆ ಅವಳು ಅವನಿಂದ ಗರ್ಭಿಣಿಯಾದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ತರುವಾಯ ಅವಳು ಎದ್ದು ಹೋಗಿ, ಮುಸುಕನ್ನು ತೆಗೆದಿಟ್ಟು, ತನ್ನ ವಿಧವೆಯ ವಸ್ತ್ರಗಳನ್ನು ಹಾಕಿಕೊಂಡಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ಯೆಹೂದನು ಆ ಸ್ತ್ರೀಯ ಕೈಯಿಂದ ಈಡು ತೆಗೆದುಕೊಳ್ಳುವದಕ್ಕೆ ತನ್ನ ಸ್ನೇಹಿತನಾದ ಅದುಲ್ಲಾಮ್ಯನ ಕೈಯಿಂದ ಮೇಕೆಯ ಮರಿಯನ್ನು ಕಳುಹಿಸಿದಾಗ ಆಕೆಯು ಸಿಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ಅದುಲ್ಲಾಮ್ಯನು ಆಕೆಯ ಊರಿನವರನ್ನು, “ಏನಯಿಮಿನ ಬಹಿರಂಗ ಮಾರ್ಗದ ಬಳಿಯಲ್ಲಿದ್ದ ವೇಶ್ಯೆ ಎಲ್ಲಿ?” ಎಂದು ಕೇಳಿದಾಗ. ಅವರು, “ಈ ಸ್ಥಳದಲ್ಲಿ ಯಾವ ವೇಶ್ಯೆಯೂ ಇರಲಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ಆಗ ಅವನು ಯೆಹೂದನ ಬಳಿಗೆ ತಿರುಗಿಬಂದು, “ಆಕೆಯು ನನಗೆ ಸಿಕ್ಕಲಿಲ್ಲ, ಇದಲ್ಲದೆ ಆ ಸ್ಥಳದ ಮನುಷ್ಯರು, ‘ಈ ಸ್ಥಳದಲ್ಲಿ ದೇವದಾಸಿ ಇರಲಿಲ್ಲ,’ ಎಂದು ಹೇಳಿದರು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ಆಗ ಯೆಹೂದನು, “ನಾವು ಅಪಹಾಸ್ಯಕ್ಕೆ ಒಳಗಾಗದ ಹಾಗೆ ಅವಳು ಅದನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಲಿ, ಈ ಮೇಕೆಯ ಮರಿಯನ್ನು ನಾನು ಕಳುಹಿಸಿದೆನು, ಆದರೆ ಆಕೆಯು ನಿನಗೆ ಸಿಕ್ಕಲಿಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ಹೆಚ್ಚು ಕಡಿಮೆ ಮೂರು ತಿಂಗಳಾದ ಮೇಲೆ ಯೆಹೂದನಿಗೆ, “ನಿನ್ನ ಸೊಸೆ ತಾಮಾರಳು ವೇಶ್ಯಾವೃತ್ತಿಮಾಡಿ ವ್ಯಭಿಚಾರದಿಂದ ಗರ್ಭಿಣಿಯಾಗಿದ್ದಾಳೆ,” ಎಂದು ತಿಳಿಸಿದರು. ಆಗ ಯೆಹೂದನು, “ಅವಳನ್ನು ಹೊರಗೆ ತನ್ನಿರಿ, ಅವಳನ್ನು ಸುಡಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ಆಕೆಯನ್ನು ಹೊರಗೆ ತಂದಾಗ, ಆಕೆಯು ತನ್ನ ಮಾವನಿಗೆ, “ಈ ಒತ್ತೆಯ ಸಾಮಾನುಗಳನ್ನು ಕೊಟ್ಟ ಆ ಮನುಷ್ಯನಿಂದಲೇ ನಾನು ಗರ್ಭಿಣಿಯಾಗಿದ್ದೇನೆ. ಆದ್ದರಿಂದ ಈ ಮುದ್ರೆಯೂ ದಾರವೂ ಕೋಲೂ ಯಾರವೆಂದು ತಿಳಿದುಕೋ,” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ಆಗ ಯೆಹೂದನು ಅವುಗಳನ್ನು ಗುರುತಿಸಿ, “ಆಕೆಯು ನನಗಿಂತ ನೀತಿವಂತಳು, ಏಕೆಂದರೆ ನಾನು ನನ್ನ ಮಗ ಶೇಲಹನಿಗೆ ಅವಳನ್ನು ಕೊಡಲಿಲ್ಲ,” ಎಂದನು. ಅವನು ಮತ್ತೆ ಆಕೆಯೊಡನೆ ಸಂಸರ್ಗವಿಲ್ಲದೆ ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ಅವಳು ಹೆರುವ ಸಮಯದಲ್ಲಿ, ಅವಳಿ ಮಕ್ಕಳು ಆಕೆಯ ಗರ್ಭದಲ್ಲಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ಆಕೆಯು ಹೆರುವಾಗ ಒಂದು ಮಗುವು ತನ್ನ ಕೈಚಾಚಿತು. ಆಗ ಸೂಲಗಿತ್ತಿಯು, “ಇದು ಮೊದಲು ಬಂದದ್ದು,” ಎಂದು ಹೇಳಿ ಅದರ ಕೈಗೆ ಕೆಂಪು ನೂಲನ್ನು ಕಟ್ಟಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ಆ ಮಗುವು ತನ್ನ ಕೈಯನ್ನು ಹಿಂದಕ್ಕೆ ಎಳೆದಾಗ, ಅವನ ಸಹೋದರನು ಹೊರಗೆ ಬಂದನು. ಆಗ ಅವಳು, “ನೀನು ಕಿತ್ತುಕೊಂಡು ಹೊರಗೆ ಬಂದೆಯಾ?” ಎಂದಳು. ಹೀಗೆ ಅವನಿಗೆ ಪೆರೆಚ್ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ತರುವಾಯ ತನ್ನ ಕೈಯಲ್ಲಿ ಕೆಂಪು ನೂಲು ಇದ್ದ ಅವನ ಸಹೋದರನು ಹೊರಗೆ ಬಂದನು. ಅವನಿಗೆ ಜೆರಹ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ಯೋಸೇಫನನ್ನು ಕರೆದುಕೊಂಡುಹೋದ ಇಷ್ಮಾಯೇಲರು ಈಜಿಪ್ಟಿಗೆ ಸೇರಿದಾಗ ಅವನನ್ನು ಈಜಿಪ್ಟಿನ ಪೋಟೀಫರ್ ಎಂಬವನಿಗೆ ಮಾರಿಬಿಟ್ಟರು. ಪೋಟೀಫರನು ಫರೋಹನ ಉದ್ಯೋಗಸ್ಥನೂ ಮೈಗಾವಲಿನ ದಳಪತಿಯೂ ಆಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ಯೆಹೋವ ದೇವರು ಯೋಸೇಫನ ಸಂಗಡ ಇದ್ದುದರಿಂದ, ಅವನು ಏಳಿಗೆಯಾಗಿ ಈಜಿಪ್ಟಿನವನಾದ ತನ್ನ ಯಜಮಾನನ ಮನೆಯಲ್ಲಿ ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ಯೆಹೋವ ದೇವರು ಅವನ ಸಂಗಡ ಇದ್ದಾನೆಂದೂ ಅವನು ಮಾಡಿದ್ದನ್ನೆಲ್ಲಾ ಯೆಹೋವ ದೇವರು ಅವನ ಕೈಯಿಂದ ಅಭಿವೃದ್ಧಿಮಾಡಿದನೆಂದೂ ಅವನ ಯಜಮಾನನಿಗೆ ತಿಳಿಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ಆದ್ದರಿಂದ ಯೋಸೇಫನು ಪೋಟೀಫರನ ದೃಷ್ಟಿಯಲ್ಲಿ ದಯೆಹೊಂದಿ ಅವನ ಸೇವೆ ಮಾಡಿದನು. ಪೋಟೀಫರನು ಅವನನ್ನು ತನ್ನ ಮನೆಯ ಮೇಲೆ ಮೇಲ್ವಿಚಾರಕನನ್ನಾಗಿ ಮಾಡಿ, ತನಗಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ಅವನ ಕೈಗೆ ಒಪ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ಅವನನ್ನು ಮನೆಯಲ್ಲಿಯೂ, ತನಗಿದ್ದ ಎಲ್ಲದರ ಮೇಲೆಯೂ ಮೇಲ್ವಿಚಾರಕನನ್ನಾಗಿ ಮಾಡಿದಂದಿನಿಂದ ಯೆಹೋವ ದೇವರು ಆ ಈಜಿಪ್ಟಿನವನ ಮನೆಯನ್ನು ಯೋಸೇಫನಿಗಾಗಿ ಆಶೀರ್ವದಿಸಿದರು. ಮನೆಯಲ್ಲಿಯೂ ಹೊಲದಲ್ಲಿಯೂ ಅವನಿಗಿದ್ದ ಎಲ್ಲದರ ಮೇಲೆಯೂ ಯೆಹೋವ ದೇವರ ಆಶೀರ್ವಾದವಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ಹೀಗಿರುವುದರಿಂದ ಅವನು ತನಗಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ಯೋಸೇಫನಿಗೆ ಒಪ್ಪಿಸಿ, ತನ್ನ ಊಟದ ವಿಷಯದಲ್ಲಿ ಹೊರತು ಬೇರೆ ಯಾವುದರ ವಿಷಯದಲ್ಲಿಯೂ ಚಿಂತಿಸದೆ ಇದ್ದನು. ಯೋಸೇಫನು ಸುರೂಪಿಯೂ ಸುಂದರನೂ ಆಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ಸ್ವಲ್ಪ ಸಮಯದ ನಂತರ ಯೋಸೇಫನ ಯಜಮಾನನ ಹೆಂಡತಿಯು ಅವನ ಮೇಲೆ ಕಣ್ಣು ಹಾಕಿ, “ನನ್ನ ಸಂಗಡ ಮಲಗು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ಆದರೆ ಅವನು ಅದಕ್ಕೆ ಒಪ್ಪದೆ, ತನ್ನ ಯಜಮಾನನ ಹೆಂಡತಿಗೆ, “ನನ್ನ ಯಜಮಾನನು ತನ್ನ ಮನೆಯಲ್ಲಿರುವ ಯಾವುದರ ಬಗ್ಗೆಯೂ ಚಿಂತಿಸದೆ, ತನಗಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ನನಗೆ ಒಪ್ಪಿಸಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ಈ ಮನೆಯಲ್ಲಿ ನನಗಿಂತ ದೊಡ್ಡವನಾರೂ ಇಲ್ಲ. ನೀನು ಅವನ ಹೆಂಡತಿಯಾಗಿರುವುದರಿಂದ, ನಿನ್ನನ್ನು ಹೊರತುಪಡಿಸಿ ನನಗೆ ಮತ್ತೇನೂ ಮರೆಮಾಡಲಿಲ್ಲ. ಹಾಗಿರುವಲ್ಲಿ ನಾನು ಈ ಮಹಾ ದುಷ್ಕೃತ್ಯ ಮಾಡಿ, ದೇವರಿಗೆ ವಿರೋಧವಾಗಿ ಪಾಪ ಮಾಡುವುದು ಹೇಗೆ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ಅವಳು ಪ್ರತಿದಿನ ಯೋಸೇಫನ ಸಂಗಡ ಮಾತನಾಡಿದರೂ, ಅವನು ಅವಳ ಕೂಡ ಮಲಗುವುದಕ್ಕಾಗಲಿ, ಅವಳ ಹತ್ತಿರ ಇರುವುದಕ್ಕಾಗಲಿ ಒಪ್ಪಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ಹೀಗಿರುವಲ್ಲಿ ಒಂದು ದಿನ ಅವನು ತನ್ನ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೆ ಮನೆಯನ್ನು ಪ್ರವೇಶಿಸಿದಾಗ, ಮನೆಯ ಸೇವಕರಲ್ಲಿ ಒಬ್ಬರೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ಆಗ ಆಕೆಯು ಅವನ ಬಟ್ಟೆಯನ್ನು ಹಿಡಿದುಕೊಂಡು, “ನನ್ನ ಸಂಗಡ ಮಲಗು,” ಎಂದಳು. ಆದರೆ ಅವನು ತನ್ನ ವಸ್ತ್ರವನ್ನು ಅವಳ ಕೈಯಲ್ಲಿ ಬಿಟ್ಟು ಹೊರಗೆ ಓಡಿಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ಅವನು ತನ್ನ ವಸ್ತ್ರವನ್ನು ತನ್ನ ಕೈಯಲ್ಲಿ ಬಿಟ್ಟು ಬಿಟ್ಟಿದ್ದನ್ನೂ, ಹೊರಗೆ ಓಡಿ ಹೋದದ್ದನ್ನೂ ಅವಳು ಕಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ತನ್ನ ಮನೆಯ ಸೇವಕರನ್ನು ಕರೆದು ಅವರಿಗೆ, “ನೋಡಿರಿ, ನಮ್ಮನ್ನು ಅವಮಾನ ಮಾಡುವುದಕ್ಕೆ ಈ ಹಿಬ್ರಿಯನು ನಮ್ಮಲ್ಲಿಗೆ ಬಂದಿದ್ದಾನೆ. ಅವನು ನನ್ನ ಮೇಲೆ ಅತ್ಯಾಚಾರಮಾಡುವುದಕ್ಕೆ ನನ್ನ ಹತ್ತಿರ ಬಂದನು. ಆಗ ನಾನು ಗಟ್ಟಿಯಾಗಿ ಕೂಗಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ನಾನು ಜೋರಾಗಿ ಕೂಗಿದ್ದನ್ನು ಅವನು ಕೇಳಿ, ತನ್ನ ವಸ್ತ್ರವನ್ನು ನನ್ನ ಬಳಿಯಲ್ಲೇ ಬಿಟ್ಟು ಹೊರಗೆ ಓಡಿಹೋದನು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ತನ್ನ ಯಜಮಾನನು ಹೊರಗಿನಿಂದ ಬರುವವರೆಗೆ, ಆಕೆಯು ಅವನ ವಸ್ತ್ರವನ್ನು ತನ್ನ ಬಳಿಯಲ್ಲಿಯೇ ಇಟ್ಟುಕೊಂಡಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ಅವನು ಬಂದಾಗ ಅವನಿಗೂ ಅದರಂತೆಯೇ ಹೇಳುತ್ತಾ, “ನೀನು ನಮ್ಮ ಬಳಿಗೆ ತಂದ ಹಿಬ್ರಿಯ ಸೇವಕನು ನನ್ನನ್ನು ಅವಮಾನ ಮಾಡುವುದಕ್ಕೆ ನನ್ನ ಬಳಿಗೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ಆದರೆ ನಾನು ಜೋರಾಗಿ ಕೂಗಿಕೊಂಡಾಗ, ಅವನು ತನ್ನ ವಸ್ತ್ರವನ್ನು ನನ್ನ ಬಳಿಯಲ್ಲಿ ಬಿಟ್ಟು ಹೊರಗೆ ಓಡಿಹೋದನು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","“ನಿನ್ನ ಸೇವಕನು ನನಗೆ ಹೀಗೆ ಮಾಡಿದ,” ಎಂದು ತನ್ನ ಹೆಂಡತಿ ಹೇಳಿದ್ದನ್ನು ಯಜಮಾನನು ಕೇಳಿ, ಅವನ ಕೋಪವೇರಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ಆಗ ಯೋಸೇಫನ ಯಜಮಾನನು ಅವನನ್ನು ಹಿಡಿದುಕೊಂಡು, ರಾಜನ ಕೈದಿಗಳನ್ನಿಡುವ ಸೆರೆಮನೆಯಲ್ಲಿ ಹಾಕಿದನು. ಯೋಸೇಫನು ಆ ಸೆರೆಮನೆಯಲ್ಲಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ಆದರೆ ಯೆಹೋವ ದೇವರು ಯೋಸೇಫನ ಸಂಗಡ ಇದ್ದು, ಅವನ ಮೇಲೆ ಕರುಣೆಯಿಟ್ಟು, ಸೆರೆಮನೆಯ ಯಜಮಾನನು ಅವನ ಮೇಲೆ ದಯೆ ತೋರಿಸುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ಆದ್ದರಿಂದ ಸೆರೆಯ ಯಜಮಾನನು ಸೆರೆಮನೆಯಲ್ಲಿ ಬಂಧಿಸಿದ ಕೈದಿಗಳನ್ನೆಲ್ಲಾ ಯೋಸೇಫನಿಗೆ ಒಪ್ಪಿಸಿದನು. ಅಲ್ಲಿ ಮಾಡಬೇಕಾದದ್ದನ್ನೆಲ್ಲಾ ಯೋಸೇಫನೇ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ಯೆಹೋವ ದೇವರು ಅವನ ಸಂಗಡ ಇದ್ದುದರಿಂದಲೂ ಅವನು ಮಾಡುವುದನ್ನು ಯೆಹೋವ ದೇವರು ಅಭಿವೃದ್ಧಿಮಾಡಿದ್ದರಿಂದಲೂ ಸೆರೆಯ ಯಜಮಾನನು ಅವನ ಕೈಗೆ ಒಪ್ಪಿಸಿದ ಯಾವುದಕ್ಕೂ ಚಿಂತೆ ಮಾಡದೆ ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ಕೆಲವು ಸಮಯದ ನಂತರ ಈಜಿಪ್ಟಿನ ಅರಸನ ಪಾನದಾಯಕನೂ, ರೊಟ್ಟಿಗಾರನೂ ತಮ್ಮ ಅರಸನಿಗೆ ಎದುರಾಗಿ ಅಪರಾಧ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ಆಗ ಫರೋಹನು ಪಾನದಾಯಕರಲ್ಲಿ ಮುಖ್ಯಸ್ಥನೂ, ರೊಟ್ಟಿಗಾರರಲ್ಲಿ ಮುಖ್ಯಸ್ಥನೂ ಆಗಿದ್ದ ಅವನ ಇಬ್ಬರು ಉದ್ಯೋಗಸ್ಥರ ಮೇಲೆ ಕೋಪಿಸಿಕೊಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ಅವರನ್ನು ಮೈಗಾವಲಿನವರ ದಳಪತಿಯ ಮನೆಯೊಳಗೆ ಕಾವಲಿರಿಸಿದನು. ಅದು ಯೋಸೇಫನು ಬಂಧಿಯಾಗಿದ್ದ ಸ್ಥಳವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ಮೈಗಾವಲಿನ ದಳಪತಿಯು ಅವರನ್ನೂ ನೋಡಿಕೊಳ್ಳುವದಕ್ಕೆ ಯೋಸೇಫನನ್ನು ನೇಮಿಸಿದ್ದರಿಂದ, ಅವನು ಅವರನ್ನು ನೋಡಿಕೊಳ್ಳುತ್ತಿದ್ದನು. ಅವರು ಕೆಲವು ಕಾಲ ಸೆರೆಯಲ್ಲಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ಅವರಿಬ್ಬರಿಗೂ ಅಂದರೆ, ಈಜಿಪ್ಟ್ ದೇಶದ ಅರಸನು ಸೆರೆಯಲ್ಲಿ ಹಾಕಿಸಿದ್ದ ಪಾನದಾಯಕನಿಗೂ, ರೊಟ್ಟಿಗಾರನಿಗೂ ಒಂದೇ ರಾತ್ರಿ ಕನಸು ಬಿತ್ತು. ಅವರವರ ಕನಸಿಗೆ ಅದರದೇ ಆದ ಅರ್ಥವಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ಆಗ ಯೋಸೇಫನು ಬೆಳಿಗ್ಗೆ ಅವರ ಬಳಿಗೆ ಬಂದು ಅವರನ್ನು ನೋಡಿದಾಗ, ಅವರು ಚಿಂತೆಯುಳ್ಳವರಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ಅವನು ತನ್ನ ಸಂಗಡ ತನ್ನ ಯಜಮಾನನ ಸೆರೆಯಲ್ಲಿದ್ದ ಫರೋಹನ ಅಧಿಕಾರಿಗಳನ್ನು, “ನಿಮ್ಮ ಮುಖಗಳು ಇಂದು ಚಿಂತೆಗೊಂಡಿರುವುದು ಏಕೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ಅವರು ಯೋಸೇಫನಿಗೆ, “ನಾವು ಕನಸನ್ನು ಕಂಡಿದ್ದೇವೆ, ಆದರೆ ಅದರ ಅರ್ಥವನ್ನು ನಮಗೆ ಹೇಳುವವರಿಲ್ಲ,” ಎಂದರು. ಯೋಸೇಫನು ಅವರಿಗೆ, “ಅರ್ಥ ಹೇಳುವುದು ದೇವರದಲ್ಲವೋ? ಎಂದು ಹೇಳಿ, ಅವುಗಳನ್ನು ನನಗೆ ಹೇಳಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ಆಗ ಮುಖ್ಯ ಪಾನದಾಯಕನು ತನ್ನ ಕನಸನ್ನು ಯೋಸೇಫನಿಗೆ ತಿಳಿಸುತ್ತಾ, “ಕನಸಿನಲ್ಲಿ ನನ್ನ ಮುಂದೆ ದ್ರಾಕ್ಷಿಬಳ್ಳಿ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ಆ ದ್ರಾಕ್ಷಿಬಳ್ಳಿಯಲ್ಲಿ ಮೂರು ಕೊಂಬೆಗಳಿದ್ದವು. ಅವು ಚಿಗುರಿ, ಹೂವು ಅರಳಿ, ಅದರ ಗೊಂಚಲುಗಳು ಹಣ್ಣಾದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ಫರೋಹನ ಪಾತ್ರೆಯು ನನ್ನ ಕೈಯಲ್ಲಿರಲಾಗಿ, ನಾನು ಆ ದ್ರಾಕ್ಷಿಹಣ್ಣುಗಳನ್ನು ತೆಗೆದು ಫರೋಹನ ಪಾತ್ರೆಯಲ್ಲಿ ಹಿಂಡಿ, ಆ ಪಾತ್ರೆಯನ್ನು ಫರೋಹನ ಕೈಯಲ್ಲಿ ಕೊಟ್ಟೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ಅದಕ್ಕೆ ಯೋಸೇಫನು, “ಅದರ ಅರ್ಥ ಏನೆಂದರೆ, ಆ ಮೂರು ಕೊಂಬೆಗಳು ಮೂರು ದಿನಗಳಾಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ಇನ್ನು ಮೂರು ದಿನಗಳಾದ ಮೇಲೆ ಫರೋಹನು ನಿನ್ನನ್ನು ಗೌರವಿಸಿ, ತಿರುಗಿ ನಿನ್ನ ಕೆಲಸದಲ್ಲಿ ಇಡುವನು. ನೀನು ಮೊದಲು ಅವನ ಪಾನದಾಯಕನಾಗಿದ್ದ ಹಾಗೆ ಫರೋಹನ ಪಾತ್ರೆಯನ್ನು ಅವನ ಕೈಗೆ ಕೊಡುವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ಆದರೆ ನೀನು ಸುಖದಿಂದಿರುವಾಗ ನನ್ನನ್ನು ನೆನಪಿಸಿಕೊಂಡು, ನನಗೆ ದಯೆತೋರಿಸಿ, ಫರೋಹನ ಮುಂದೆ ನನ್ನ ವಿಷಯ ತಿಳಿಸಿ, ಈ ಸೆರೆಯೊಳಗಿಂದ ನನ್ನನ್ನು ಹೊರಗೆ ಬರುವಂತೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ಏಕೆಂದರೆ ನನ್ನನ್ನು ಹಿಬ್ರಿಯರ ದೇಶದೊಳಗಿಂದ ಹಿಡಿದು ತಂದಿದ್ದಾರೆ. ಇಲ್ಲಿಯೂ ಸಹ ನಾನು ಏನೂ ತಪ್ಪುಮಾಡದೆ ಇದ್ದರೂ ನನ್ನನ್ನು ಸೆರೆಯಲ್ಲಿ ಹಾಕಿದರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ಯೋಸೇಫನು ಒಳ್ಳೆಯ ಅರ್ಥವನ್ನು ಹೇಳಿದನೆಂದು ಮುಖ್ಯ ರೊಟ್ಟಿಗಾರನು ತಿಳಿದಾಗ, ಅವನು ಯೋಸೇಫನಿಗೆ, “ನನ್ನ ಕನಸಿನಲ್ಲಿಯೂ ಮೂರು ರೊಟ್ಟಿಯ ಪುಟ್ಟಿಗಳು ನನ್ನ ತಲೆಯ ಮೇಲಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ಮೇಲಿದ್ದ ಪುಟ್ಟಿಯಲ್ಲಿ ಫರೋಹನಿಗೋಸ್ಕರ ರೊಟ್ಟಿಗಾರರು ಮಾಡುವ ಎಲ್ಲಾ ವಿಧವಾದ ಆಹಾರವಿತ್ತು. ನನ್ನ ತಲೆಯ ಮೇಲಿದ್ದ ಪುಟ್ಟಿಯೊಳಗಿದ್ದ ಅದನ್ನು ಪಕ್ಷಿಗಳು ತಿಂದವು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ಅದಕ್ಕೆ ಯೋಸೇಫನು ಉತ್ತರವಾಗಿ, “ಅದರ ಅರ್ಥವು ಇದೇ: ಆ ಮೂರು ಪುಟ್ಟಿಗಳು, ಮೂರು ದಿನಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ಇನ್ನು ಮೂರು ದಿನಗಳಾದ ಮೇಲೆ ಫರೋಹನು ನಿನ್ನ ತಲೆಯನ್ನು ತೆಗೆಸಿ, ನಿನ್ನನ್ನು ಮರದ ಮೇಲೆ ತೂಗು ಹಾಕಿಸುವನು. ಪಕ್ಷಿಗಳು ನಿನ್ನ ಮಾಂಸವನ್ನು ತಿಂದುಬಿಡುವುವು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಫರೋಹನ ಜನ್ಮದಿನವಾಗಿದ್ದರಿಂದ ಅವನು ತನ್ನ ಸೇವಕರೆಲ್ಲರಿಗೂ ಔತಣವನ್ನು ಮಾಡಿಸಿ, ಮುಖ್ಯ ಪಾನದಾಯಕನನ್ನು ಮತ್ತು ಮುಖ್ಯ ರೊಟ್ಟಿಗಾರನನ್ನು ತನ್ನ ಅಧಿಕಾರಿಗಳ ಮುಂದೆ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ಮುಖ್ಯ ಪಾನದಾಯಕನನ್ನು ತಿರುಗಿ ಉದ್ಯೋಗದಲ್ಲಿ ಇರಿಸಿದ್ದರಿಂದ, ಮತ್ತೆ ಅವನು ಫರೋಹನ ಕೈಗೆ ಪಾನಪಾತ್ರೆಯನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ಆದರೆ ಮುಖ್ಯ ರೊಟ್ಟಿಗಾರನನ್ನು ಗಲ್ಲಿಗೇರಿಸಿದನು. ಹೀಗೆ ಯೋಸೇಫನು ಹೇಳಿದ ಹೇಳಿದಂತೆಯೇ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ಆದರೂ ಪಾನದಾಯಕರ ಮುಖ್ಯಸ್ಥನು ಯೋಸೇಫನನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳದೆ ಅವನನ್ನು ಮರೆತುಬಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ಎರಡು ಪೂರ್ಣ ವರ್ಷಗಳು ಕಳೆದ ಮೇಲೆ ಫರೋಹನು ಒಂದು ಕನಸನ್ನು ಕಂಡನು. ಆ ಕನಸಿನಲ್ಲಿ ಅವನು ನೈಲ್ ನದಿಯ ಬಳಿಯಲ್ಲಿ ನಿಂತಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ಲಕ್ಷಣವಾದ ಮತ್ತು ಕೊಬ್ಬಿದ ಏಳು ಹಸುಗಳು ನೈಲ್ ನದಿಯೊಳಗಿಂದ ಏರಿಬಂದು, ಆಪುಹುಲ್ಲುಗಾವಲಲ್ಲಿ ಮೇಯುತ್ತಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ಅವಲಕ್ಷಣವಾದ ಬೇರೆ ಏಳು ಬಡಹಸುಗಳು ಅವುಗಳ ಹಿಂದೆ ನದಿಯೊಳಗಿಂದ ಏರಿಬಂದು, ಆ ಹಸುಗಳ ಹತ್ತಿರ ನೈಲ್ ನದಿ ತೀರದಲ್ಲಿ ನಿಂತಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ಆ ಅವಲಕ್ಷಣವಾದ ಬಡಹಸುಗಳು, ಕೊಬ್ಬಿದ ಮತ್ತು ಲಕ್ಷಣವಾದ ಏಳು ಹಸುಗಳನ್ನು ತಿಂದುಬಿಟ್ಟವು. ಆಗ ಫರೋಹನು ಎಚ್ಚೆತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ಅವನು ತಿರುಗಿ ನಿದ್ರೆ ಮಾಡಿದಾಗ, ಎರಡನೆಯ ಸಾರಿ ಕನಸನ್ನು ಕಂಡನು. ಒಂದೇ ದಂಟಿನಲ್ಲಿ ಏಳು ಒಳ್ಳೆಯ ಪುಷ್ಟಿಯಾದ ತೆನೆಗಳು ಎದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ಅವುಗಳ ಹಿಂದೆಯೇ ಪೂರ್ವದಿಕ್ಕಿನ ಗಾಳಿಯಿಂದ ಬತ್ತಿ, ಒಣಗಿ ಹೋದ ಏಳು ತೆನೆಗಳು ಮೊಳೆತವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ಆ ಬತ್ತಿ ಹೋಗಿದ್ದ ತೆನೆಗಳು, ಪುಷ್ಟಿಯಾದ ಏಳು ತೆನೆಗಳನ್ನು ನುಂಗಿ ಬಿಟ್ಟವು. ಫರೋಹನು ಎಚ್ಚೆತ್ತಾಗ ಅದು ಕನಸಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ಬೆಳಿಗ್ಗೆ ಅವನ ಮನಸ್ಸು ಕಳವಳಗೊಂಡಿತು. ಆದ್ದರಿಂದ ಅವನು ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ಮಂತ್ರವಾದಿಗಳನ್ನೂ ಎಲ್ಲಾ ಜ್ಞಾನಿಗಳನ್ನೂ ಕರೆಕಳುಹಿಸಿದನು. ಫರೋಹನು ಅವರಿಗೆ ತನ್ನ ಕನಸನ್ನು ತಿಳಿಸಿದಾಗ, ಅವುಗಳ ಅರ್ಥವನ್ನು ಹೇಳುವವರು ಯಾರೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ಆಗ ಪಾನದಾಯಕರ ಮುಖ್ಯಸ್ಥನು ಫರೋಹನಿಗೆ, “ಈ ಹೊತ್ತು ನನ್ನ ತಪ್ಪನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ಫರೋಹನು ತನ್ನ ಸೇವಕರ ಮೇಲೆ ಕೋಪಿಸಿಕೊಂಡಾಗ, ನನ್ನನ್ನೂ, ರೊಟ್ಟಿಗಾರರ ಮುಖ್ಯಸ್ಥನನ್ನೂ ಮೈಗಾವಲಿನ ದಳಪತಿಯ ಮನೆಯಲ್ಲಿ ಕಾವಲಲ್ಲಿ ಇಟ್ಟಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ನಾವು ಒಂದು ರಾತ್ರಿಯಲ್ಲಿ ಕನಸನ್ನು ಕಂಡೆವು. ಒಬ್ಬೊಬ್ಬನ ಕನಸಿಗೆ ಬೇರೆ ಬೇರೆ ಅರ್ಥವಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ಮೈಗಾವಲಿನ ದಳಪತಿಗೆ ಸೇವಕನಾಗಿದ್ದ ಹಿಬ್ರಿಯ ಯೌವನಸ್ಥನು ಅಲ್ಲಿ ನಮ್ಮ ಸಂಗಡ ಇದ್ದನು. ಅವನಿಗೆ ನಾವು ನಮ್ಮ ಕನಸುಗಳನ್ನು ತಿಳಿಸಿದಾಗ, ಅವನು ನಮ್ಮ ನಮ್ಮ ಕನಸಿನ ಅರ್ಥವನ್ನು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ಅವನು ಹೇಳಿದ ಅರ್ಥದಂತೆಯೇ ನಮಗಾಯಿತು. ನಾನು ನನ್ನ ಸ್ಥಾನವನ್ನು ಪುನಃ ಪಡೆದುಕೊಂಡೆನು, ಇನ್ನೊಬ್ಬನನ್ನು ಗಲ್ಲಿಗೇರಿಸಲಾಯಿತು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ಆಗ ಫರೋಹನು ಯೋಸೇಫನನ್ನು ಕರೆತರುವಂತೆ ಸೇವಕರನ್ನು ಕಳುಹಿಸಿದನು. ಅವರು ಅವನನ್ನು ತ್ವರೆಯಾಗಿ ಕಾರಾಗೃಹದಿಂದ ಹೊರಗೆ ತಂದರು. ಅವನು ಕ್ಷೌರಮಾಡಿಸಿಕೊಂಡು, ವಸ್ತ್ರಗಳನ್ನು ಬದಲಾಯಿಸಿ ಫರೋಹನ ಬಳಿಗೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ಆಗ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನಾನು ಕನಸನ್ನು ಕಂಡಿದ್ದೇನೆ, ಅದರ ಅರ್ಥವನ್ನು ಹೇಳುವವರು ಯಾರೂ ಇಲ್ಲ. ನೀನು ಕನಸನ್ನು ಗ್ರಹಿಸಿ, ಅರ್ಥವನ್ನು ಹೇಳುತ್ತೀ ಎಂದು ನಿನ್ನ ವಿಷಯವಾಗಿ ನಾನು ಕೇಳಿದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ಯೋಸೇಫನು ಫರೋಹನಿಗೆ ಉತ್ತರವಾಗಿ, “ಅದನ್ನು ನಾನು ಹೇಳಲಾರೆ, ಆದರೆ ದೇವರು ಫರೋಹನಿಗೆ ಮೆಚ್ಚಿಕೆಯಾದ ಉತ್ತರವನ್ನು ಕೊಡುವರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ಅದಕ್ಕೆ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನನ್ನ ಕನಸಿನಲ್ಲಿ, ನಾನು ನೈಲ್ ನದಿಯ ತೀರದಲ್ಲಿ ನಿಂತುಕೊಂಡಿದ್ದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ಆಗ ಕೊಬ್ಬಿದ ಮಾಂಸವಿದ್ದ ಲಕ್ಷಣವಾದ ಏಳು ಹಸುಗಳು ನೈಲ್ ನದಿಯೊಳಗಿಂದ ಏರಿಬಂದು, ಆಪುಹುಲ್ಲುಗಾವಲಲ್ಲಿ ಮೇಯುತ್ತಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ಅವುಗಳ ಹಿಂದೆ ಅವಲಕ್ಷಣವಾದ ಕೊಬ್ಬಿಲ್ಲದ ಬೇರೆ ಏಳು ಬಡಹಸುಗಳು ಏರಿ ಬಂದವು. ಅಂಥ ಬಡ ಹಸುಗಳನ್ನು, ನಾನು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಎಲ್ಲಿಯೂ ನೋಡಿದ್ದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ಅವಲಕ್ಷಣವಾದ ಬಡಹಸುಗಳು, ಕೊಬ್ಬಿದ ಆ ಏಳು ಹಸುಗಳನ್ನು ತಿಂದುಬಿಟ್ಟವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ಇವು ಅವುಗಳನ್ನು ತಿಂದ ಮೇಲೂ ಅವು ತಿಂದ ಹಾಗೆ ತೋರಲಿಲ್ಲ. ಅವು ಮೊದಲಿನಂತೆ ಬಡಕಲಾಗಿಯೇ ಇದ್ದವು. ತರುವಾಯ ನಾನು ಎಚ್ಚೆತ್ತೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“ನನಗೆ ಇನ್ನೊಂದು ಕನಸು ಬಂತು. ನಾನು ಆ ಕನಸಿನಲ್ಲಿ, ಒಂದೇ ದಂಟಿನಲ್ಲಿ ಪುಷ್ಟಿಯುಳ್ಳ ಏಳು ತೆನೆಗಳು ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ಪೂರ್ವದಿಕ್ಕಿನ ಗಾಳಿಯಿಂದ ಒಣಗಿ ಬತ್ತಿ ಹೋಗಿದ್ದ ಏಳು ತೆನೆಗಳು ಅವುಗಳ ತರುವಾಯ ಮೊಳೆತವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ಆ ಒಣಗಿದ್ದ ಏಳು ತೆನೆಗಳು, ಪುಷ್ಟಿಯಾದ ಏಳು ತೆನೆಗಳನ್ನು ನುಂಗಿದವು. ನಾನು ಇದನ್ನು ಮಂತ್ರವಾದಿಗಳಿಗೆ ತಿಳಿಸಿದಾಗ, ಅದರ ಅರ್ಥವನ್ನು ನನಗೆ ಯಾರೂ ಹೇಳಲಿಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ಆಗ ಯೋಸೇಫನು ಫರೋಹನಿಗೆ, “ಫರೋಹನ ಎರಡು ಕನಸುಗಳ ವಿಷಯ ಒಂದೇ, ದೇವರು ಮಾಡಲಿರುವುದನ್ನು ಫರೋಹನಿಗೆ ತಿಳಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ಆ ಏಳು ಒಳ್ಳೆಯ ಹಸುಗಳು ಏಳು ವರ್ಷಗಳು; ಏಳು ಒಳ್ಳೆಯ ತೆನೆಗಳೂ, ಏಳು ವರ್ಷಗಳೇ. ಇವೆರಡು ಕನಸುಗಳ ಅರ್ಥ ಒಂದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ಅವುಗಳ ತರುವಾಯ ಏರಿ ಬಂದ ಬಡಕಲಾದ ಕೆಟ್ಟ ಏಳು ಹಸುಗಳು ಮತ್ತು ಪೂರ್ವದಿಕ್ಕಿನ ಗಾಳಿಯಿಂದ ಒಣಗಿ ಬತ್ತಿ ಹೋಗಿದ್ದ ಏಳು ತೆನೆಗಳು, ಬರಲಿರುವ ಏಳು ವರ್ಷಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“ನಾನು ಫರೋಹನಿಗೆ ಹೇಳಿದ ಮಾತಿನಂತೆ ದೇವರು ಮಾಡಲಿರುವುದನ್ನು ಫರೋಹನಿಗೆ ತೋರಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಬಹುಸಮೃದ್ಧಿಯ ಸುಭಿಕ್ಷ ವರ್ಷಗಳು ಬರುತ್ತವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ಆದರೆ ಅವುಗಳ ಹಿಂದೆ ಏಳು ವರ್ಷಗಳ ಬರಗಾಲ ಬರುತ್ತವೆ. ಆಗ ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದ ಸುಭಿಕ್ಷವು ಮರೆಯುವಂತಾಗುವುದು. ಇದಲ್ಲದೆ ಬರಗಾಲವು ದೇಶವನ್ನು ನಾಶಮಾಡುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ತರುವಾಯ ಬರಗಾಲವು ಬಹಳ ಕಠಿಣವಾಗಿರುವುದರಿಂದ, ಸುಭಿಕ್ಷ ಕಾಲದ ನೆನಪು ದೇಶದಲ್ಲಿ ಇರದೆ ಹೋಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ಇದಲ್ಲದೆ ಆ ಕನಸು ಫರೋಹನಿಗೆ ಎರಡು ಸಾರಿ ಬಿದ್ದುದರಿಂದ, ಆ ಕಾರ್ಯವು ದೇವರಿಂದ ಸ್ಥಿರಪಡಿಸಲಾಗಿದೆ. ಆದ್ದರಿಂದ ದೇವರು ಅದನ್ನು ಬೇಗನೆ ನೆರವೇರಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ಹೀಗಿರುವುದರಿಂದ ಈಗ ಫರೋಹನು ವಿವೇಕಿಯಾದ ಬುದ್ಧಿಯುಳ್ಳ ಒಬ್ಬನನ್ನು ನೋಡಿ, ಅವನನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆ ನೇಮಿಸಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ಫರೋಹನು ಅಧಿಕಾರಿಗಳನ್ನು ನೇಮಿಸಿ, ದೇಶದ ಮೇಲಿಟ್ಟು, ಸುಭಿಕ್ಷದ ಏಳು ವರ್ಷಗಳಲ್ಲಿ ಈಜಿಪ್ಟ್ ದೇಶದ ಐದರಲ್ಲಿ ಒಂದು ಭಾಗ ಬೆಳೆಯನ್ನು ಕಂದಾಯವಾಗಿ ತೆಗೆದುಕೊಳ್ಳಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ಅಧಿಕಾರಿಗಳು ಮುಂಬರುವ ಈ ಒಳ್ಳೆಯ ವರ್ಷಗಳ ಆಹಾರವನ್ನೆಲ್ಲಾ ಕೂಡಿಸಿ, ಫರೋಹನ ಕೈಕೆಳಗೆ ಧಾನ್ಯವನ್ನು ಪಟ್ಟಣಗಳಲ್ಲಿ ಇಟ್ಟುಕೊಂಡು ಕಾಯಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ಈಜಿಪ್ಟಿನಲ್ಲಿ ಬರುವದಕ್ಕಿರುವ ಬರಗಾಲದ ಏಳು ವರ್ಷಗಳಲ್ಲಿ ದೇಶವು ಹಾಳಾಗದಂತೆ, ಆಹಾರವು ದೇಶಕ್ಕೆ ಸಂಗ್ರಹವಾಗಿರುವುದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ಈ ಮಾತುಗಳು ಫರೋಹನಿಗೂ, ಅವನ ಸೇವಕರಿಗೂ ಒಳ್ಳೆಯದೆಂದು ತೋರಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ಫರೋಹನು ತನ್ನ ಸೇವಕರಿಗೆ, “ಯೋಸೇಫನಂಥ ದೇವರಾತ್ಮವುಳ್ಳ ಮನುಷ್ಯನು ಸಿಕ್ಕಾನೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ದೇವರು ನಿನಗೆ ಇವುಗಳನ್ನೆಲ್ಲಾ ತೋರಿಸಿದ ಮೇಲೆ, ನಿನ್ನ ಹಾಗೆ ವಿವೇಕಿಯೂ ಬುದ್ಧಿವಂತನೂ ಯಾರೂ ಇಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ನೀನೇ ನನ್ನ ಅರಮನೆಯ ಅಧಿಕಾರಿಯಾಗಿರಬೇಕು. ನಿನ್ನ ಮಾತಿನ ಪ್ರಕಾರ ನನ್ನ ಜನರೆಲ್ಲಾ ಅಧೀನವಾಗಿರಲಿ. ಸಿಂಹಾಸನದಲ್ಲಿ ಮಾತ್ರ ನಾನು ನಿನಗಿಂತ ದೊಡ್ಡವನಾಗಿರುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ಇದಲ್ಲದೆ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನೋಡು, ನಾನು ನಿನ್ನನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆಲ್ಲಾ ನೇಮಿಸಿದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ಫರೋಹನು ತನ್ನ ಕೈಯೊಳಗಿನ ಉಂಗುರವನ್ನು ತೆಗೆದು ಯೋಸೇಫನ ಕೈಯಲ್ಲಿಟ್ಟು, ನಾರುಮಡಿಯ ವಸ್ತ್ರವನ್ನು ತೊಡಿಸಿ, ಚಿನ್ನದ ಸರಪಣಿಯನ್ನು ಅವನ ಕೊರಳಿಗೆ ಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ತನಗಿದ್ದ ಎರಡನೆಯ ರಥದಲ್ಲಿ ಅವನನ್ನು ಕೂಡಿಸಿದಾಗ, “ಈತನನ್ನು ನಮಸ್ಕರಿಸಿ ದಾರಿಮಾಡಿರಿ,” ಎಂದು ಪ್ರಕಟಿಸಿದನು. ಹೀಗೆ ಅವನನ್ನು ಈಜಿಪ್ಟ್ ದೇಶವನ್ನೆಲ್ಲಾ ಆಳುವವನನ್ನಾಗಿ ನೇಮಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ಇದಲ್ಲದೆ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನಾನು ಫರೋಹನು, ನಿನ್ನ ಅಪ್ಪಣೆಯಿಲ್ಲದೆ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಯಾವನೂ ತನ್ನ ಕೈಯನ್ನಾಗಲಿ, ಕಾಲನ್ನಾಗಲಿ ಎತ್ತಬಾರದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ಫರೋಹನು ಯೋಸೇಫನಿಗೆ ಸಾಫ್ನತ್ಪನ್ನೇಹ ಎಂದು ಹೆಸರಿಟ್ಟನು. ತರುವಾಯ ಓನಿನ ಯಾಜಕನಾದ ಪೋಟೀಫೆರನ ಮಗಳಾದ ಆಸನತ್ ಎಂಬಾಕೆಯನ್ನು ಅವನಿಗೆ ಹೆಂಡತಿಯಾಗಿ ಕೊಟ್ಟನು. ತರುವಾಯ ಯೋಸೇಫನು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಸಂಚರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ಯೋಸೇಫನು ಈಜಿಪ್ಟಿನ ಅರಸನಾದ ಫರೋಹನ ಮುಂದೆ ನಿಂತಾಗ, ಮೂವತ್ತು ವರ್ಷದವನಾಗಿದ್ದನು. ತರುವಾಯ ಯೋಸೇಫನು ಫರೋಹನ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಟು, ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಸಂಚಾರಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ಆ ದೇಶವು ಸುಭಿಕ್ಷದ ಏಳು ವರ್ಷಗಳಲ್ಲಿ ರಾಶಿರಾಶಿಯಾಗಿ ಫಲಕೊಟ್ಟಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ಹೀಗಿರಲಾಗಿ ಅವನು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿದ್ದ ಆ ಏಳು ವರ್ಷಗಳ ಆಹಾರವನ್ನೆಲ್ಲಾ ಕೂಡಿಸಿ, ಪಟ್ಟಣಗಳಲ್ಲಿ ಇಟ್ಟನು. ಒಂದೊಂದು ಪಟ್ಟಣದ ಸುತ್ತಲಿರುವ ಬೆಳೆಯನ್ನು ಆಯಾ ಪಟ್ಟಣದಲ್ಲಿ ಕೂಡಿಸಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ಈ ಮೇರೆಗೆ ಯೋಸೇಫನು ದವಸ ಧಾನ್ಯವನ್ನು ಸಮುದ್ರದ ಮರಳಿನಷ್ಟು ರಾಶಿರಾಶಿಯಾಗಿ ಕೂಡಿಸಿ ಲೆಕ್ಕಮಾಡುವುದನ್ನು ಬಿಟ್ಟುಬಿಟ್ಟನು. ಅದನ್ನು ಲೆಕ್ಕಮಾಡುವುದಕ್ಕೆ ಆಗದೆ ಹೋಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ಇದಲ್ಲದೆ ಬರಗಾಲದ ವರ್ಷಗಳು ಬರುವುದಕ್ಕೆ ಮುಂಚೆ, ಯೋಸೇಫನಿಗೆ ಇಬ್ಬರು ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ಓನಿನ ಯಾಜಕನಾದ ಪೋಟೀಫೆರನ ಮಗಳಾದ ಆಸನತ್, ಅವಳನ್ನು ಯೋಸೇಫನಿಗೆ ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ಜೇಷ್ಠಪುತ್ರನಿಗೆ ಯೋಸೇಫನು ಮನಸ್ಸೆ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಏಕೆಂದರೆ ಅವನು, “ದೇವರು ನನ್ನ ಕಷ್ಟವನ್ನು ಮತ್ತು ನನ್ನ ತಂದೆಯ ಮನೆಯನ್ನು ಮರೆತುಬಿಡುವಂತೆ ಮಾಡಿದರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ಅವನು ತನ್ನ ಎರಡನೆಯ ಮಗನಿಗೆ ಎಫ್ರಾಯೀಮ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. “ನಾನು ಬಾಧೆಯನ್ನನುಭವಿಸಿದ ದೇಶ ಫಲಭರಿತವಾಗುವಂತೆ ದೇವರು ಮಾಡಿದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿದ್ದ ಸುಭಿಕ್ಷದ ಏಳು ವರ್ಷಗಳು ಮುಗಿದ ತರುವಾಯ, ");
INSERT INTO kanokcv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ಯೋಸೇಫನು ಹೇಳಿದಂತೆ ಬರುವುದಕ್ಕಿದ್ದ ಬರಗಾಲದ ಏಳು ವರ್ಷಗಳು ಆರಂಭವಾದವು. ಆಗ ಎಲ್ಲಾ ದೇಶಗಳಲ್ಲಿ ಬರಗಾಲವಿತ್ತು. ಆದರೆ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಆಹಾರವಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ಈಜಿಪ್ಟ್‌ದವರೆಲ್ಲಾ ಹಸಿದು, ಜನರು ಆಹಾರಕ್ಕಾಗಿ ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಕೂಗಿಕೊಂಡಾಗ, ಫರೋಹನು ಎಲ್ಲಾ ಈಜಿಪ್ಟಿನವರಿಗೆ, “ಯೋಸೇಫನ ಬಳಿಗೆ ಹೋಗಿರಿ, ಅವನು ನಿಮಗೆ ಹೇಳುವುದನ್ನು ಮಾಡಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ಈಜಿಪ್ಟಿನಲ್ಲೆಲ್ಲಾ ಬರವಿತ್ತು. ಯೋಸೇಫನು ಧಾನ್ಯವಿದ್ದ ಕಣಜಗಳನ್ನೆಲ್ಲಾ ತೆರೆದು ಈಜಿಪ್ಟಿನವರಿಗೆ ಮಾರಿದನು. ಆಗ ಬರವು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಕಠಿಣವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ಇದಲ್ಲದೆ ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಬರಗಾಲವು ಕಠಿಣವಾಗಿದ್ದದರಿಂದ, ಎಲ್ಲಾ ದೇಶದವರು ಯೋಸೇಫನಿಂದ ಧಾನ್ಯವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ಈಜಿಪ್ಟಿಗೆ ಬರುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ಈಜಿಪ್ಟಿನಲ್ಲಿ ಧಾನ್ಯ ಉಂಟೆಂದು ಯಾಕೋಬನು ತಿಳಿದಾಗ, ಅವನು ತನ್ನ ಪುತ್ರರಿಗೆ, “ನೀವು ಒಬ್ಬರನ್ನೊಬ್ಬರು ನೋಡಿಕೊಂಡು ಸುಮ್ಮನಿರುವುದೇನು?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ಅವನು ಮುಂದುವರಿಸಿ, “ಈಜಿಪ್ಟಿನಲ್ಲಿ ಧಾನ್ಯ ಉಂಟೆಂದು ನಾನು ಕೇಳಿದ್ದೇನೆ. ನಾವು ಸಾಯದೆ ಬದುಕುವಂತೆ ನೀವು ಅಲ್ಲಿಗೆ ಇಳಿದು ಹೋಗಿ, ನಮಗಾಗಿ ಅಲ್ಲಿಂದ ಧಾನ್ಯವನ್ನು ಕೊಂಡುಕೊಳ್ಳಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ಆಗ ಯೋಸೇಫನ ಹತ್ತು ಮಂದಿ ಸಹೋದರರು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಧಾನ್ಯವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ಆದರೆ ಯೋಸೇಫನ ಸಹೋದರನಾದ ಬೆನ್ಯಾಮೀನನನ್ನು ಕಳುಹಿಸಲಿಲ್ಲ. ಏಕೆಂದರೆ ಅವನಿಗೆ ಕೇಡು ಬಂದೀತೆಂದು ಹೇಳಿ, ಯಾಕೋಬನು ಅವನನ್ನು ಅವನ ಸಹೋದರರ ಸಂಗಡ ಕಳುಹಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಬರವಿದ್ದುದರಿಂದ ಧಾನ್ಯವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ಬರುವವರೊಂದಿಗೆ ಇಸ್ರಾಯೇಲನ ಪುತ್ರರೂ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ಆಗ ಯೋಸೇಫನು ದೇಶದ ಮೇಲೆಲ್ಲಾ ಅಧಿಪತಿಯಾಗಿದ್ದನು. ದೇಶದ ಜನರಿಗೆಲ್ಲಾ ಧಾನ್ಯವನ್ನು ಮಾರುವವನು ಅವನೇ ಆಗಿದ್ದನು. ಹೀಗಿರಲಾಗಿ ಯೋಸೇಫನ ಸಹೋದರರು ಬಂದು, ತಮ್ಮ ಮುಖಗಳನ್ನು ನೆಲದ ಮಟ್ಟಿಗೂ ತಗ್ಗಿಸಿ ಅವನಿಗೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರನ್ನು ನೋಡಿ ಅವರನ್ನು ಗುರುತಿಸಿದರೂ, ತಿಳಿಯದವನ ಹಾಗೆ ಅನ್ಯನಂತೆ ಕಠಿಣವಾದ ಮಾತುಗಳನ್ನಾಡಿ, ಅವರಿಗೆ, “ಎಲ್ಲಿಂದ ಬಂದಿರಿ?” ಎಂದನು. ಅದಕ್ಕೆ ಅವರು, “ಆಹಾರ ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ಕಾನಾನ್ ದೇಶದಿಂದ ಬಂದೆವು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರನ್ನು ಗುರುತಿಸಿದರೂ, ಅವರು ಅವನನ್ನು ಗುರುತಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ಆಗ ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರನ್ನು ನೋಡಿ ಅವರನ್ನು ಗುರುತಿಸಿದರೂ ಆಗ ಯೋಸೇಫನು ತಾನು ಅವರ ವಿಷಯದಲ್ಲಿ ಕಂಡ ಕನಸುಗಳನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಂಡು ಅವರಿಗೆ, “ನೀವು ಗೂಢಚಾರರು, ದೇಶದ ಒಳಗುಟ್ಟನ್ನು ನೋಡುವುದಕ್ಕೆ ಬಂದಿದ್ದೀರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ಅದಕ್ಕವರು, “ಅಲ್ಲ, ನಮ್ಮ ಒಡೆಯಾ, ನಿನ್ನ ದಾಸರಾದ ನಾವು ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವದಕ್ಕೆ ಬಂದಿದ್ದೇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ನಾವೆಲ್ಲರೂ ಒಬ್ಬ ಮನುಷ್ಯನ ಪುತ್ರರಾಗಿದ್ದು ಸತ್ಯವಂತರಾಗಿದ್ದೇವೆ. ಆದ್ದರಿಂದ ನಿನ್ನ ದಾಸರು ಗೂಢಚಾರರಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ಆದರೆ ಅವನು ಅವರಿಗೆ, “ಇಲ್ಲ, ದೇಶದ ಒಳಗುಟ್ಟನ್ನು ನೀವು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕೋಸ್ಕರವೇ ಬಂದಿದ್ದೀರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ಅದಕ್ಕವರು, “ನಿನ್ನ ದಾಸರಾದ ನಾವು ಹನ್ನೆರಡು ಸಹೋದರರು. ನಾವು ಕಾನಾನ್ ದೇಶದಲ್ಲಿರುವ ಒಬ್ಬ ಮನುಷ್ಯನ ಮಕ್ಕಳು. ಈಗ ಚಿಕ್ಕವನು ನನ್ನ ತಂದೆಯೊಂದಿಗೆ ಇದ್ದಾನೆ, ಮತ್ತೊಬ್ಬನು ಇಲ್ಲ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ಆಗ ಯೋಸೇಫನು ಅವರಿಗೆ, “ನೀವು ಗೂಢಚಾರರೆಂದು ನಾನು ನಿಮಗೆ ಹೇಳಿದ ಮಾತು ನಿಜವೇ! ");
INSERT INTO kanokcv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ಈಗ ನಿಮ್ಮನ್ನು ನಾನು ಪರೀಕ್ಷಿಸುತ್ತೇನೆ. ಹೇಗೆಂದರೆ, ನಿಮ್ಮ ಚಿಕ್ಕ ಸಹೋದರನು ಇಲ್ಲಿಗೆ ಬಂದ ಹೊರತು, ಫರೋಹನ ಜೀವದಾಣೆ ನೀವು ಇಲ್ಲಿಂದ ಹೋಗಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ನಿಮ್ಮಲ್ಲಿಂದ ಒಬ್ಬನನ್ನು ಕಳುಹಿಸಿರಿ, ಅವನು ನಿಮ್ಮ ಸಹೋದರನನ್ನು ಕರೆದುಕೊಂಡು ಬರಲಿ. ಆದರೆ ನೀವು ಸೆರೆಮನೆಯಲ್ಲಿರಬೇಕು. ಹೀಗೆ ನಿಮ್ಮಲ್ಲಿ ಸತ್ಯವು ಉಂಟೋ, ಇಲ್ಲವೋ ಎಂದು ನಿಮ್ಮ ಮಾತುಗಳನ್ನು ಪರೀಕ್ಷಿಸುತ್ತೇನೆ. ಇಲ್ಲದಿದ್ದರೆ, ಫರೋಹನ ಜೀವದಾಣೆ ನಿಶ್ಚಯವಾಗಿ ನೀವು ಗೂಢಚಾರರು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ಯೋಸೇಫನು ಎಲ್ಲರನ್ನು ಒಟ್ಟಿಗೆ ಮೂರು ದಿನಗಳು ಸೆರೆಯಲ್ಲಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಯೋಸೇಫನು ಅವರಿಗೆ, “ನಾನು ದೇವರಿಗೆ ಭಯಪಡುವವನಾಗಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ನೀವು ಸತ್ಯವಂತರಾಗಿದ್ದರೆ, ನಿಮ್ಮ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನು ನೀವು ಇದ್ದ ಸೆರೆಮನೆಯಲ್ಲಿ ಬಂಧಿತನಾಗಿರಲಿ. ಆದರೆ ನೀವು ಎಲ್ಲರೂ ನಿಮ್ಮ ಮನೆಗಳ ಕ್ಷಾಮಕ್ಕೆ ಧಾನ್ಯಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ನಿಮ್ಮ ಚಿಕ್ಕ ತಮ್ಮನನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆತನ್ನಿರಿ. ಆಗ ನಿಮ್ಮ ಮಾತುಗಳು ಸತ್ಯವೆಂದು ದೃಢವಾಗುವವು. ನೀವು ಸಾಯದೆ ಉಳಿಯುವಿರಿ,” ಎಂದನು. ಅವರು ಹಾಗೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ಆಗ ಅವರು, “ನಿಶ್ಚಯವಾಗಿ ನಮ್ಮ ಸಹೋದರನ ಅಪರಾಧವು ನಮ್ಮ ಮೇಲೆ ಇದೆ. ಅವನು ನಮ್ಮನ್ನು ಬೇಡಿಕೊಂಡಾಗ, ಅವನ ಪ್ರಾಣಸಂಕಟವನ್ನು ಕಂಡರೂ ಕೇಳದೆ ಹೋದೆವು. ಆದಕಾರಣ ಈ ಸಂಕಟವು ನಮ್ಮ ಮೇಲೆ ಬಂದಿತು,” ಎಂದು ಮಾತಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ಆಗ ರೂಬೇನನು ಅವರಿಗೆ ಉತ್ತರವಾಗಿ, “ಹುಡುಗನಿಗೆ ಏನೂ ಕೇಡು ಮಾಡಬೇಡಿರಿ, ಎಂದು ನಾನು ನಿಮಗೆ ಹೇಳಿದರೂ ನೀವು ಕೇಳಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಅವನಿಗಾದ ಪ್ರಾಣಹಾನಿಯ ವಿಷಯದಲ್ಲಿ ಈಗ ನಾವು ಲೆಕ್ಕ ಒಪ್ಪಿಸುತ್ತಿದ್ದೇವೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ಆದರೆ ಯೋಸೇಫನು ಅವರು ಆಡಿದ್ದನ್ನು ತಿಳಿದುಕೊಳ್ಳುತ್ತಿದ್ದನು ಎಂಬುದು ಅವರಿಗೆ ಗೊತ್ತಾಗಲಿಲ್ಲ. ಏಕೆಂದರೆ ಯೋಸೇಫನು ಅನುವಾದಕನ ಮುಖಾಂತರ ಅವರ ಸಂಗಡ ಮಾತಾಡುತ್ತಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ಅನಂತರ ಯೋಸೇಫನು ಅವರ ಬಳಿಯಿಂದ ಹೊರಟುಹೋಗಿ ಅತ್ತನು. ಮತ್ತೆ ಅವರ ಬಳಿಗೆ ಬಂದು, ಅವರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರೊಂದಿಗೆ ಸಿಮೆಯೋನನನ್ನು ತಂದು, ಅವರ ಕಣ್ಣೆದುರಿನಲ್ಲಿ ಬಂಧಿಸಿ ಸೆರೆಯಲ್ಲಿ ಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ತರುವಾಯ ಯೋಸೇಫನು ಧಾನ್ಯವನ್ನು ತುಂಬಿಸಬೇಕೆಂದೂ, ಒಬ್ಬೊಬ್ಬನ ಚೀಲದಲ್ಲಿ ಅವನವನ ಹಣವನ್ನು ತಿರುಗಿ ಇಡಬೇಕೆಂದೂ, ಪ್ರಯಾಣಕ್ಕಾಗಿ ಅವರಿಗೆ ಆಹಾರ ಸರಬರಾಜು ಮಾಡಬೇಕೆಂದೂ ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ಆಗ ಅವರು ತಮ್ಮ ಧಾನ್ಯವನ್ನು ಕತ್ತೆಗಳ ಮೇಲೆ ಹೇರಿಕೊಂಡು, ಅಲ್ಲಿಂದ ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ಆಗ ಒಬ್ಬನು ತನ್ನ ಕತ್ತೆಗೆ ಆಹಾರವನ್ನು ಕೊಡುವುದಕ್ಕೆ ವಸತಿಗೃಹದಲ್ಲಿ ತನ್ನ ಚೀಲವನ್ನು ಬಿಚ್ಚಿದಾಗ, ಚೀಲದ ಬಾಯಲ್ಲಿಟ್ಟಿದ್ದ ತನ್ನ ಹಣವನ್ನು ಕಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ಅವನು ತನ್ನ ಸಹೋದರರಿಗೆ, “ನನ್ನ ಹಣವನ್ನು ಹಿಂದಕ್ಕೆ ಕೊಟ್ಟಿದ್ದಾರೆ, ಅದು ನನ್ನ ಚೀಲದಲ್ಲಿದೆ,” ಎಂದು ಹೇಳಿದ. ಅವರಿಗೆ ಹೃದಯ ಕಂಪನವಾದಂತಾಗಿ ಹೆದರಿ ಒಬ್ಬರಿಗೊಬ್ಬರು, “ದೇವರು ನಮಗೆ ಮಾಡಿದ್ದೇನು?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ಅವರು ಕಾನಾನ್ ದೇಶದಲ್ಲಿದ್ದ ತಮ್ಮ ತಂದೆ ಯಾಕೋಬನ ಬಳಿಗೆ ಬಂದಾಗ, ತಮಗೆ ಸಂಭವಿಸಿದ್ದೆಲ್ಲವನ್ನೂ ಅವನಿಗೆ ತಿಳಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ದೇಶದ ಅಧಿಪತಿಯಾಗಿರುವ ಮನುಷ್ಯನು ನಮ್ಮ ಸಂಗಡ ಕಠಿಣವಾಗಿ ಮಾತನಾಡಿ, ದೇಶದ ಗೂಢಚಾರರನ್ನಾಗಿ ನಮ್ಮನ್ನು ಎಣಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ನಾವು ಅವನಿಗೆ, “ನಾವು ಗೂಢಚಾರರಲ್ಲ, ಸತ್ಯವಂತರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ನಾವು ಹನ್ನೆರಡು ಮಂದಿ ಸಹೋದರರಾಗಿದ್ದು, ಒಂದೇ ತಂದೆಯ ಪುತ್ರರಾಗಿದ್ದೇವೆ, ಒಬ್ಬನು ಇಲ್ಲ, ಚಿಕ್ಕವನು ಇಂದು ನಮ್ಮ ತಂದೆಯ ಸಂಗಡ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಇದ್ದಾನೆ,” ಎಂದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“ಆಗ ದೇಶದ ಪ್ರಭುವಾಗಿರುವ ಆ ಮನುಷ್ಯನು, ‘ನೀವು ಯಥಾರ್ಥರೆಂದು ನಾನು ಇದರಲ್ಲಿ ತಿಳಿದುಕೊಳ್ಳುವೆನು. ನೀವು ನಿಮ್ಮ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನನ್ನು ನನ್ನ ಬಳಿಯಲ್ಲಿಟ್ಟು, ನಿಮ್ಮ ಮನೆಯ ಕ್ಷಾಮಕ್ಕೆ ಅವಶ್ಯವಾದದ್ದನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ನಿಮ್ಮ ಚಿಕ್ಕ ತಮ್ಮನನ್ನು ನನ್ನ ಬಳಿಗೆ ತನ್ನಿರಿ. ಆಗ ನೀವು ಗೂಢಚಾರರಲ್ಲವೆಂದೂ, ಯಥಾರ್ಥರೆಂದೂ ತಿಳಿದುಕೊಂಡು, ನಿಮ್ಮ ಸಹೋದರರನ್ನು ನಿಮಗೆ ಒಪ್ಪಿಸುವೆನು. ಆಗ ನೀವು ದೇಶದಲ್ಲಿ ವ್ಯಾಪಾರ ಮಾಡಬಹುದು,’ ಎಂದು ಹೇಳಿದನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ಇದಲ್ಲದೆ ಅವರು ತಮ್ಮ ಚೀಲಗಳನ್ನು ಬರಿದು ಮಾಡುತ್ತಿದ್ದಾಗ, ಅವನವನ ಹಣದ ಗಂಟು, ಅವನವನ ಚೀಲದಲ್ಲಿ ಇತ್ತು. ಅವರೂ, ಅವರ ತಂದೆಯೂ ಆ ಹಣದ ಗಂಟುಗಳನ್ನು ನೋಡಿ ಭಯಪಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ಆಗ ಅವರ ತಂದೆ ಯಾಕೋಬನು ಅವರಿಗೆ, “ನನ್ನನ್ನು ಮಕ್ಕಳಿಲ್ಲದವನನ್ನಾಗಿ ಮಾಡಿದ್ದೀರಿ. ಯೋಸೇಫನೂ ಇಲ್ಲ, ಸಿಮೆಯೋನನೂ ಇಲ್ಲ, ಬೆನ್ಯಾಮೀನನನ್ನೂ ಕರೆದುಕೊಂಡು ಹೋಗುವುದರಲ್ಲಿದ್ದೀರಿ. ಇವುಗಳೆಲ್ಲಾ ನನಗೆ ವಿರೋಧವಾಗಿವೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ರೂಬೇನನು ತನ್ನ ತಂದೆಗೆ, “ನಾನು ಅವನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ತಾರದೆ ಹೋದರೆ, ನನ್ನ ಇಬ್ಬರು ಪುತ್ರರನ್ನು ಕೊಂದುಬಿಡು. ನೀನು ಬೆನ್ಯಾಮೀನನನ್ನು ನನ್ನ ಕೈಯಲ್ಲಿ ಒಪ್ಪಿಸು. ನಾನು ಅವನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ತಿರುಗಿ ತರುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ಆದರೆ ಯಾಕೋಬನು, “ನನ್ನ ಮಗನು ನಿಮ್ಮ ಸಂಗಡ ಹೋಗಬಾರದು, ಅವನ ಅಣ್ಣ ಸತ್ತು ಹೋಗಿ, ಇವನೊಬ್ಬನೇ ಉಳಿದಿದ್ದಾನೆ. ನೀವು ಹೋಗುವ ಮಾರ್ಗದಲ್ಲಿ ಇವನಿಗೆ ಕೇಡು ಬಂದರೆ, ನನ್ನ ಮುದಿ ತಲೆಯನ್ನು ದುಃಖದಿಂದ ಸಮಾಧಿಗೆ ಇಳಿಸುವಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ದೇಶದಲ್ಲಿ ಬರವು ಘೋರವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ಅವರು ಈಜಿಪ್ಟಿನಿಂದ ತಂದಿದ್ದ ಧಾನ್ಯವು ತೀರಿದ ಮೇಲೆ ಅವರ ತಂದೆ ಅವರಿಗೆ, “ತಿರುಗಿ ಹೋಗಿ ನಮಗಾಗಿ ಸ್ವಲ್ಪ ಆಹಾರ ಕೊಂಡುಕೊಳ್ಳಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ಆಗ ಯೆಹೂದನು ಅವನಿಗೆ, “ಆ ಮನುಷ್ಯನು ನಮಗೆ ನಿಮ್ಮ ಸಹೋದರನು ನಿಮ್ಮ ಸಂಗಡ ಇದ್ದ ಹೊರತು, ನೀವು ನನ್ನ ಮುಖವನ್ನು ನೋಡಬಾರದೆಂದು, ನಮಗೆ ದೃಢವಾಗಿ ನಿರ್ಣಯಿಸಿ ಹೇಳಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ನೀನು ನಮ್ಮ ತಮ್ಮನನ್ನು ನಮ್ಮ ಸಂಗಡ ಕಳುಹಿಸಿದರೆ, ನಾವು ಹೋಗಿ ನಿನಗಾಗಿ ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಂಡು ಬರುತ್ತೇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ಅವನನ್ನು ಕಳುಹಿಸದೆ ಹೋದರೆ, ನಾವು ಹೋಗುವುದಿಲ್ಲ. ಏಕೆಂದರೆ ಆ ಮನುಷ್ಯನು, ‘ನಿಮ್ಮ ತಮ್ಮನು ನಿಮ್ಮ ಸಂಗಡ ಇಲ್ಲದಿದ್ದರೆ, ನನ್ನ ಮುಖವನ್ನು ನೋಡಬಾರದು,’ ಎಂದು ನಮಗೆ ಹೇಳಿದ್ದಾನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ಇಸ್ರಾಯೇಲನು, “ನಿಮಗೆ ಇನ್ನೊಬ್ಬ ತಮ್ಮನು ಇದ್ದಾನೆಂದು ನೀವು ಏಕೆ ಆ ಮನುಷ್ಯನಿಗೆ ಹೇಳಿ ನನಗೆ ಕೇಡು ಮಾಡಿದ್ದೀರಿ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ಅವರು ಅವನಿಗೆ, “ಆ ಮನುಷ್ಯನು ನಮ್ಮ ವಿಷಯದಲ್ಲಿ ಮತ್ತು ನಮ್ಮ ಮನೆಯವರ ವಿಷಯದಲ್ಲಿ ನೇರವಾಗಿ ಕೇಳಿ ಅವನು, ‘ನಿಮ್ಮ ತಂದೆ ಇನ್ನೂ ಬದುಕಿದ್ದಾನೋ? ನಿಮಗೆ ಇನ್ನೊಬ್ಬ ಸಹೋದರನು ಇದ್ದಾನೋ?’ ಎಂದು ಕೇಳಿದನು. ಆಗ ಈ ಮಾತುಗಳಿಗೆ ತಕ್ಕ ಹಾಗೆ ನಾವು ಅವನಿಗೆ ತಿಳಿಸಿದೆವು. ‘ನಿಮ್ಮ ತಮ್ಮನನ್ನು ಕರೆದುಕೊಂಡು ಬನ್ನಿರಿ,’ ಎಂದು ಅವನು ನಮಗೆ ಹೇಳುತ್ತಾನೆಂದು ನಮಗೆ ಹೇಗೆ ತಿಳಿಯಲು ಸಾಧ್ಯ?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ಯೆಹೂದನು ತನ್ನ ತಂದೆ ಇಸ್ರಾಯೇಲನಿಗೆ, “ಆ ಹುಡುಗನನ್ನು ನನ್ನ ಸಂಗಡ ಕಳುಹಿಸು, ಆಗ ನಾವು ಹೋಗುವೆವು. ನಾವು, ನೀನೂ ಮತ್ತು ನಮ್ಮ ಮಕ್ಕಳು ಸಾಯದೆ ಬದುಕುವೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ನಾನು ಅವನಿಗೋಸ್ಕರ ಹೊಣೆಯಾಗಿರುವೆನು. ನೀನು ಅವನ ವಿಷಯದಲ್ಲಿ ನನ್ನನ್ನೇ ಕೇಳಬಹುದು. ನಾನು ಅವನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ತಂದು ನಿನ್ನೆದುರಿಗೆ ನಿಲ್ಲಿಸದಿದ್ದರೆ, ಎಂದೆಂದಿಗೂ ನಾನು ಅಪರಾಧವನ್ನು ಹೊರುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ಏಕೆಂದರೆ ನಾವು ತಡಮಾಡದೆ ಇದ್ದಿದ್ದರೆ, ಇಷ್ಟರಲ್ಲಿ ಎರಡು ಸಾರಿ ಹೋಗಿ ಬರಬಹುದಾಗಿತ್ತು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ಆಗ ಅವರ ತಂದೆ ಇಸ್ರಾಯೇಲನು ಅವರಿಗೆ, “ಹಾಗಿದ್ದರೆ ನೀವು ಹೀಗೆ ಮಾಡಿರಿ. ಈ ದೇಶದಲ್ಲಿ ದೊರಕುವ ಶ್ರೇಷ್ಠವಾದ ಫಲಗಳನ್ನು ನಿಮ್ಮೊಂದಿಗೆ ಇಟ್ಟುಕೊಂಡು, ಆ ಮನುಷ್ಯನಿಗೆ ಕಾಣಿಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ಅಂದರೆ, ಸ್ವಲ್ಪ ತೈಲ, ಸ್ವಲ್ಪ ಜೇನು, ಸುಗಂಧದ್ರವ್ಯ, ರಕ್ತಬೋಳ, ಆಕ್ರೋಡು ಮತ್ತು ಬಾದಾಮಿ ಇವುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ಇದಲ್ಲದೆ ಎರಡರಷ್ಟು ಹಣವನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ಅವರು ನಿಮ್ಮ ಚೀಲಗಳ ಬಾಯಲ್ಲಿ ಹಾಕಿ ಹಿಂದಕ್ಕೆ ಕಳುಹಿಸಿದ ಹಣವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ಒಂದು ವೇಳೆ ಅದು ಅವರಿಗೆ ತಿಳಿಯದೆ ಬಂದಿರಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ನಿಮ್ಮ ಸಹೋದರನನ್ನು ಕರೆದುಕೊಂಡು ಆ ಮನುಷ್ಯನ ಬಳಿಗೆ ತಿರುಗಿ ಹೋಗಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ಸರ್ವಶಕ್ತ ದೇವರು ನಿಮ್ಮ ಮತ್ತೊಬ್ಬ ಸಹೋದರನನ್ನೂ ಬೆನ್ಯಾಮೀನನನ್ನೂ ಕಳುಹಿಸಿಕೊಡುವ ಹಾಗೆ, ಆ ಮನುಷ್ಯನು ನಿಮ್ಮ ಮೇಲೆ ಕರುಣೆ ತೋರಿಸುವಂತೆ ಮಾಡಲಿ. ನಾನಂತೂ ಮಕ್ಕಳನ್ನು ಕಳೆದುಕೊಂಡವನಾಗಿರಬೇಕಾದರೆ ಹಾಗೆಯೇ ಆಗಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ಆಗ ಅವರು ಆ ಕಾಣಿಕೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ತಮ್ಮ ಕೈಯಲ್ಲಿ ಎರಡರಷ್ಟು ಹಣವನ್ನೂ, ಬೆನ್ಯಾಮೀನನನ್ನೂ ಕರೆದುಕೊಂಡು ಈಜಿಪ್ಟಿಗೆ ಹೋಗಿ, ಯೋಸೇಫನ ಮುಂದೆ ನಿಂತರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ಯೋಸೇಫನು ಬೆನ್ಯಾಮೀನನನ್ನು ಅವರ ಸಂಗಡ ಕಂಡಾಗ ತನ್ನ ಮನೆ ಉಗ್ರಾಣಿಕನಿಗೆ, “ಈ ಮನುಷ್ಯರನ್ನು ಮನೆಗೆ ಕರೆದುಕೊಂಡು ಹೋಗಿ, ಮಾಂಸದ ಅಡುಗೆ ಸಿದ್ಧಮಾಡು. ಏಕೆಂದರೆ ಈ ಮನುಷ್ಯರು ಮಧ್ಯಾಹ್ನದಲ್ಲಿ ನನ್ನ ಸಂಗಡ ಊಟಮಾಡಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ಯೋಸೇಫನು ಹೇಳಿದಂತೆ ಅವನು ಮಾಡಿದನು. ಅವನು ಆ ಮನುಷ್ಯರನ್ನು ಯೋಸೇಫನ ಮನೆಗೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ಯೋಸೇಫನ ಮನೆಗೆ ಕರೆತಂದದ್ದರಿಂದ ಅವರು ಭಯಪಟ್ಟು, “ಹಿಂದೆ ನಮ್ಮ ಚೀಲಗಳಲ್ಲಿ ತಿರುಗಿ ಸೇರಿದ ಹಣಕ್ಕಾಗಿ ನಮ್ಮನ್ನು ಹಿಡಿದು, ನಮ್ಮ ಮೇಲೆ ಬಿದ್ದು, ನಮ್ಮನ್ನು ದಾಸರಾಗಿ ಮಾಡಿ, ನಮ್ಮ ಕತ್ತೆಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳುವುದಕ್ಕೆ ನಮ್ಮನ್ನು ಇಲ್ಲಿಗೆ ತಂದಿದ್ದಾನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ಆಗ ಅವರು ಯೋಸೇಫನ ಮನೆಯ ಬಳಿಗೆ ಹೋಗಿ, ಬಾಗಿಲಿನ ಮುಂದೆ ಗೃಹನಿರ್ವಾಹಕನ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“ಒಡೆಯಾ, ನಾವು ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ಮೊದಲನೆಯ ಸಾರಿ ಬಂದದ್ದು ನಿಜವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ಇದಾದ ಮೇಲೆ ನಾವು ವಸತಿಗೃಹಕ್ಕೆ ಬಂದು ನಮ್ಮ ಚೀಲಗಳನ್ನು ತೆರೆದಾಗ, ಪ್ರತಿಯೊಬ್ಬನ ಹಣವು ಅವನವನ ಚೀಲದ ಬಾಯಲ್ಲಿ ಇತ್ತು. ನಮ್ಮ ಕೈಗಳಲ್ಲಿ ಅದನ್ನು ತಿರುಗಿ ತೆಗೆದುಕೊಂಡು ಬಂದಿದ್ದೇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ಇದಲ್ಲದೆ ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ಬೇರೆ ಹಣವನ್ನೂ ತಂದಿದ್ದೇವೆ. ಈ ಹಣವನ್ನು ನಮ್ಮ ಚೀಲಗಳಲ್ಲಿ ಯಾರು ಇಟ್ಟರೆಂದು ನಮಗೆ ತಿಳಿಯದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ಅದಕ್ಕವನು, “ನಿಮಗೆ ಸಮಾಧಾನವಿರಲಿ, ಭಯಪಡಬೇಡಿರಿ. ನಿಮ್ಮ ದೇವರೂ ನಿಮ್ಮ ತಂದೆಯ ದೇವರೂ ನಿಮ್ಮ ಚೀಲಗಳಲ್ಲಿ ನಿಮಗೆ ನಿಕ್ಷೇಪವನ್ನು ಕೊಟ್ಟಿದ್ದಾರೆ. ನಿಮ್ಮ ಹಣವು ನನಗೆ ಮುಟ್ಟಿದೆ,” ಎಂದು ಹೇಳಿ ಸಿಮೆಯೋನನನ್ನು ಅವರ ಬಳಿಗೆ ತಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ಆ ಮನುಷ್ಯನು ಅವರನ್ನು ಯೋಸೇಫನ ಮನೆಯೊಳಗೆ ಕರೆದುಕೊಂಡು ಬಂದು ಅವರಿಗೆ ನೀರನ್ನು ಕೊಟ್ಟಾಗ, ಅವರು ತಮ್ಮ ಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಂಡರು. ಇದಲ್ಲದೆ ಅವರ ಕತ್ತೆಗಳಿಗೆ ಮೇವನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ಅವರು ಅಲ್ಲಿ ಊಟ ಮಾಡಬೇಕೆಂದು ಕೇಳಿದ್ದರಿಂದ, ಯೋಸೇಫನು ಮಧ್ಯಾಹ್ನದಲ್ಲಿ ಮನೆಗೆ ಬರುವಷ್ಟರಲ್ಲಿ ಕಾಣಿಕೆಯನ್ನು ಸಿದ್ಧಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ಯೋಸೇಫನು ಮನೆಗೆ ಬಂದ ಮೇಲೆ, ತಮ್ಮ ಕೈಗಳಲ್ಲಿದ್ದ ಕಾಣಿಕೆಯನ್ನು ಮನೆಯೊಳಗೆ ತೆಗೆದುಕೊಂಡು ಬಂದು, ಅವನಿಗೆ ನೆಲದವರೆಗೂ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ಆಗ ಯೋಸೇಫನು ಅವರ ಕ್ಷೇಮಸಮಾಚಾರವನ್ನು ಕೇಳಿ, “ನೀವು ಹೇಳಿದ ವೃದ್ಧನಾದ ನಿಮ್ಮ ತಂದೆ ಕ್ಷೇಮವೋ? ಅವನು ಇನ್ನೂ ಬದುಕಿದ್ದಾನೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ಅದಕ್ಕವರು, “ನಿನ್ನ ದಾಸನಾದ ನಮ್ಮ ತಂದೆಯು ಕ್ಷೇಮದಿಂದಿದ್ದಾನೆ, ಅವನು ಇನ್ನೂ ಬದುಕಿದ್ದಾನೆ,” ಎಂದು ಹೇಳಿ ತಮ್ಮ ತಲೆಗಳನ್ನು ಮತ್ತೆ ಬಾಗಿಸಿ ವಂದಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ಆಗ ಅವನು ತನ್ನ ದೃಷ್ಟಿಯಿಟ್ಟು, ತನ್ನ ತಾಯಿಯ ಮಗನೂ ತನ್ನ ತಮ್ಮನೂ ಆದ ಬೆನ್ಯಾಮೀನನನ್ನು ನೋಡಿ, “ನೀವು ನನಗೆ ಹೇಳಿದ ನಿಮ್ಮ ಚಿಕ್ಕ ತಮ್ಮನು ಇವನೋ?” ಎಂದು ಹೇಳಿ, “ನನ್ನ ಮಗನೇ, ದೇವರು ನಿನಗೆ ಕೃಪಾಳುವಾಗಿರಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ಆಗ ಯೋಸೇಫನ ಕರುಳು ತನ್ನ ತಮ್ಮನ ಬಗ್ಗೆ ಮರುಗಿದ್ದರಿಂದ ಅವನು ಅವಸರದಲ್ಲಿ ಎದ್ದು ಅಳುವುದಕ್ಕೆ ಸ್ಥಳವನ್ನು ಹುಡುಕಿ, ತನ್ನ ಕೋಣೆಯೊಳಗೆ ಹೋಗಿ ಅಲ್ಲಿ ಅತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ತರುವಾಯ ಅವನು ಮುಖವನ್ನು ತೊಳೆದುಕೊಂಡು ಹೊರಗೆ ಬಂದನು. ಅವನು ಮನಸ್ಸನ್ನು ಬಿಗಿಹಿಡಿದುಕೊಂಡು, “ಊಟಕ್ಕೆ ಬಡಿಸಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ಆಗ ಅವರು ಯೋಸೇಫನಿಗೆ, ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೂ ಅವನ ಸಂಗಡ ಇದ್ದ ಈಜಿಪ್ಟಿನವರಿಗೂ ಬೇರೆಬೇರೆಯಾಗಿ ಊಟಕ್ಕೆ ಇಟ್ಟರು. ಏಕೆಂದರೆ ಈಜಿಪ್ಟಿನವರು ಹಿಬ್ರಿಯರ ಕೂಡ ಊಟಮಾಡುತ್ತಿರಲಿಲ್ಲ. ಅದು ಈಜಿಪ್ಟಿನವರಿಗೆ ಅಸಹ್ಯವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ಯೋಸೇಫನು ಅವರನ್ನು ಹಿರಿಯವರಿಂದ ಕಿರಿಯವನವರೆಗೆ ಅವರವರ ವಯಸ್ಸಿನ ಪ್ರಕಾರ ಕುಳಿತುಕೊಳ್ಳುವಂತೆ ಮಾಡಿದ್ದರಿಂದ, ಅವರು ತಮ್ಮತಮ್ಮೊಳಗೆ ಆಶ್ಚರ್ಯಪಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ಯೋಸೇಫನು ತನ್ನ ಮುಂದಿಟ್ಟಿದ್ದ ಆಹಾರವನ್ನು ಕಳುಹಿಸಿದಾಗ, ಬೆನ್ಯಾಮೀನನಿಗೆ ಕಳುಹಿಸಿದ ಆಹಾರವು ಅವರೆಲ್ಲರ ಆಹಾರಗಳಿಗಿಂತ ಐದರಷ್ಟು ಹೆಚ್ಚಾಗಿತ್ತು ಮತ್ತು ಅವರು ಅವನ ಸಂಗಡ ಕುಡಿದು ಸಂತೋಷದಿಂದಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ಯೋಸೇಫನು ತನ್ನ ಮನೆಯ ಉಗ್ರಾಣಿಕನಿಗೆ, “ಈ ಮನುಷ್ಯರ ಚೀಲಗಳಲ್ಲಿ ಹೊರುವುದಕ್ಕಾಗುವಷ್ಟು ಧಾನ್ಯವನ್ನು ತುಂಬಿಸಿ, ಪ್ರತಿಯೊಬ್ಬನ ಹಣವನ್ನು ಅವನವನ ಚೀಲದ ಬಾಯಲ್ಲಿ ಇಡು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ನನ್ನ ಬೆಳ್ಳಿಯ ಪಾತ್ರೆಯನ್ನು ಚಿಕ್ಕವನ ಚೀಲದ ಬಾಯಲ್ಲಿ ಅವನ ಧಾನ್ಯ ಹಾಗೂ ಹಣದ ಸಂಗಡ ಇಡು,” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ಯೋಸೇಫನು ಹೇಳಿದಂತೆಯೇ ಅವನು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ಸೂರ್ಯೋದಯವಾದಾಗ ಆ ಮನುಷ್ಯರನ್ನು ತಮ್ಮ ಕತ್ತೆಗಳ ಸಹಿತವಾಗಿ ಕಳುಹಿಸಲಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ಅವರು ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟು ದೂರ ಹೋಗುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಯೋಸೇಫನು ಮನೆಯ ಗೃಹನಿರ್ವಾಹಕನಿಗೆ, “ಆ ಮನುಷ್ಯರ ಹಿಂದೆ ಹೋಗು. ಅವರು ಸಿಕ್ಕಿದಾಗ, ‘ಏಕೆ ನೀವು ಒಳ್ಳೆಯದಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡಿದಿರಿ? ");
INSERT INTO kanokcv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ಆ ಪಾತ್ರೆಯು ನನ್ನ ಒಡೆಯನು ಕುಡಿಯುವ ಪಾತ್ರೆಯಲ್ಲವೋ? ಅದರಿಂದ ನಿಜವಾಗಿಯೂ ಅವನು ದೈವೋಕ್ತಿಯನ್ನು ಹೇಳುವನಲ್ಲಾ? ನೀವು ಹೀಗೆ ಮಾಡಿದ್ದು ಕೆಟ್ಟದ್ದಾಗಿದೆ,’ ಎಂದು ಅವರಿಗೆ ಹೇಳು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ಅವನು ಅವರನ್ನು ಸಂಧಿಸಿ ಈ ಮಾತುಗಳನ್ನು ಅವರಿಗೆ ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ಆಗ ಅವರು ಅವನಿಗೆ, “ನಮ್ಮ ಒಡೆಯನು ಏಕೆ ಇಂಥ ಮಾತುಗಳನ್ನಾಡುತ್ತಾನೆ? ನಿನ್ನ ದಾಸರು ಹೀಗೆ ಮಾಡುವವರಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ನಮ್ಮ ಚೀಲಗಳ ಬಾಯಲ್ಲಿ ನಮಗೆ ಸಿಕ್ಕಿದ ಹಣವನ್ನು ನಿಮಗೆ ಕೊಡುವುದಕ್ಕೆ ಕಾನಾನ್ ದೇಶದಿಂದ ತಂದೆವು. ಹೀಗಿರಲು ನಿನ್ನ ಯಜಮಾನನ ಮನೆಯೊಳಗಿಂದ ಬೆಳ್ಳಿಬಂಗಾರವನ್ನು ಹೇಗೆ ಕದ್ದುಕೊಂಡೇವು? ");
INSERT INTO kanokcv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ಅದು ನಿನ್ನ ದಾಸರಲ್ಲಿ ಯಾರ ಹತ್ತಿರ ಸಿಕ್ಕುವುದೋ ಅವನು ಸಾಯಲಿ ಮತ್ತು ನಾವು ಸಹ ನಮ್ಮ ಒಡೆಯನಿಗೆ ದಾಸರಾಗುವೆವು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ಆಗ ಅವನು, “ಈಗ ನಿಮ್ಮ ಮಾತಿನಂತೆಯೇ ಆಗಲಿ. ಯಾರ ಬಳಿಯಲ್ಲಿ ಅದು ಸಿಕ್ಕುತ್ತದೋ, ಅವನು ನನಗೆ ದಾಸನಾಗಿರಲಿ, ಆದರೆ ನೀವು ನಿರಪರಾಧಿಗಳಾಗಿರುವಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ಅದಕ್ಕೆ ಅವರು ತ್ವರೆಪಟ್ಟು, ತಮ್ಮ ತಮ್ಮ ಚೀಲಗಳನ್ನು ನೆಲಕ್ಕೆ ಇಳಿಸಿ ಅವುಗಳನ್ನು ಬಿಚ್ಚಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ಅವರು ಹಿರಿಯನನ್ನು ಮೊದಲುಗೊಂಡು ಕಿರಿಯವನವರೆಗೆ ಶೋಧಿಸಲಾಗಿ, ಆ ಪಾತ್ರೆಯು ಬೆನ್ಯಾಮೀನನ ಚೀಲದಲ್ಲಿ ಸಿಕ್ಕಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ಆಗ ಅವರು ತಮ್ಮ ವಸ್ತ್ರಗಳನ್ನು ಹರಿದುಕೊಂಡು, ತಮ್ಮ ತಮ್ಮ ಕತ್ತೆಗಳ ಮೇಲೆ ಚೀಲಗಳನ್ನು ಹೇರಿಕೊಂಡು ಪಟ್ಟಣಕ್ಕೆ ಮರಳಿ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ಯೆಹೂದನೂ ಅವನ ಸಹೋದರರೂ ಯೋಸೇಫನು ಇನ್ನೂ ಮನೆಯಲ್ಲಿದ್ದಾಗಲೇ, ಅವನ ಮನೆಗೆ ಬಂದು ಮುಂದೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ಆಗ ಯೋಸೇಫನು ಅವರಿಗೆ, “ನೀವು ಮಾಡಿದ ಈ ಕೆಲಸವೇನು? ನನ್ನಂಥ ಮನುಷ್ಯನು ದೈವೋಕ್ತಿಗಳನ್ನು ಬಲ್ಲೆನೆಂದು ನಿಮಗೆ ತಿಳಿದಿರಲಿಲ್ಲವೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ಯೆಹೂದನು, “ನಾವು ನಮ್ಮ ಒಡೆಯನಿಗೆ ಏನು ಹೇಳೋಣ? ಏನು ಮಾತನಾಡೋಣ? ಹೇಗೆ ನಮ್ಮನ್ನು ನಾವು ನೀತಿವಂತರಾಗಿ ಮಾಡಿಕೊಳ್ಳೋಣ? ನಿನ್ನ ದಾಸರ ಪಾಪವನ್ನು ದೇವರು ಹೊರಪಡಿಸಿದ್ದಾರೆ. ನಾವೂ ಪಾತ್ರೆಯು ಯಾರ ಕೈಯಲ್ಲಿ ಸಿಕ್ಕಿತೋ ಅವನೂ ನನ್ನ ಒಡೆಯನಿಗೆ ದಾಸರಾಗಿದ್ದೇವೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ಆಗ ಯೋಸೇಫನು, “ಹಾಗೆ ಎಂದಿಗೂ ಆಗಬಾರದು. ಯಾರ ಬಳಿಯಲ್ಲಿ ಆ ಪಾತ್ರೆಯು ಸಿಕ್ಕಿತೋ, ಅವನು ನನಗೆ ದಾಸನಾಗಿರಲಿ. ಆದರೆ ನೀವು ಸಮಾಧಾನವಾಗಿ ನಿಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ಹೋಗಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ಯೆಹೂದನು ಅವನ ಸಮೀಪಕ್ಕೆ ಬಂದು, “ನನ್ನ ಒಡೆಯನೇ, ನನ್ನ ಒಡೆಯನ ಕಿವಿಗಳಲ್ಲಿ ಒಂದು ಮಾತು ಹೇಳುವುದಕ್ಕೆ ನಿನ್ನ ದಾಸನಿಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು. ನಿನ್ನ ದಾಸನ ಮೇಲೆ ನಿನ್ನ ಕೋಪವು ಉರಿಯದೆ ಇರಲಿ. ಏಕೆಂದರೆ ನೀನು ಫರೋಹನಿಗೆ ಸಮಾನನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ನನ್ನ ಒಡೆಯನೇ, ‘ನಿಮಗೆ ತಂದೆಯೂ ಸಹೋದರರೂ ಇದ್ದಾರೋ,’ ಎಂದು ತನ್ನ ದಾಸರನ್ನು ಕೇಳಲು, ");
INSERT INTO kanokcv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ನಾವು ನಮ್ಮ ಒಡೆಯನಿಗೆ, ‘ನಮಗೆ ಮುದುಕನಾದ ತಂದೆಯೂ ಅವನಿಗೆ ಮುಪ್ಪಿನಲ್ಲಿ ಹುಟ್ಟಿದ ಚಿಕ್ಕ ಮಗನೂ ಇದ್ದಾನೆ, ಅವನ ಸಹೋದರನು ಸತ್ತುಹೋಗಿದ್ದಾನೆ. ಅವನ ತಂದೆಯು ಅವನನ್ನು ಪ್ರೀತಿಸುತ್ತಾನೆ,’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“ಅದಕ್ಕೆ ನೀನು ನಿನ್ನ ದಾಸರಿಗೆ, ‘ನಾನು ಅವನನ್ನು ನೋಡುವ ಹಾಗೆ, ಅವನನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬನ್ನಿರಿ,’ ಎಂದು ಹೇಳಿದೆಯಲ್ಲಾ. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ನಾವು ನಮ್ಮ ಒಡೆಯನಿಗೆ, ‘ಆ ಹುಡುಗನು ನಮ್ಮ ತಂದೆಯನ್ನು ಬಿಡಕೂಡದು. ಅವನು ತಂದೆಯನ್ನು ಬಿಟ್ಟರೆ, ಅವನು ಸಾಯುವನು,’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ಆಗ ನೀವು ನಿನ್ನ ದಾಸರಿಗೆ, ‘ನಿಮ್ಮ ಚಿಕ್ಕ ತಮ್ಮನು ನಿಮ್ಮ ಸಂಗಡ ಇಲ್ಲಿಗೆ ಬಾರದಿದ್ದರೆ, ಇನ್ನು ಮೇಲೆ ನನ್ನ ಮುಖವನ್ನು ನೋಡಬಾರದು,’ ಎಂದು ಹೇಳಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ಹೀಗಿರಲಾಗಿ ನಾವು ನಿನ್ನ ದಾಸನಾದ ನಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ಹೋದಾಗ, ನನ್ನ ಒಡೆಯನ ಮಾತುಗಳನ್ನು ಅವನಿಗೆ ತಿಳಿಸಿದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“ನಮ್ಮ ತಂದೆಯು, ‘ನೀವು ತಿರುಗಿ ಹೋಗಿ, ನಮಗೆ ಸ್ವಲ್ಪ ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳಿರಿ,’ ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ಆಗ ನಾವು, ‘ಹೋಗುವುದಕ್ಕಾಗದು, ನಮ್ಮ ಚಿಕ್ಕ ತಮ್ಮನು ನಮ್ಮೊಂದಿಗೆ ಇದ್ದರೆ ಮಾತ್ರ ನಾವು ಹೋಗುತ್ತೇವೆ. ಏಕೆಂದರೆ ನಮ್ಮ ಚಿಕ್ಕ ತಮ್ಮನು ನಮ್ಮ ಸಂಗಡ ಇದ್ದರೆ ಮಾತ್ರ, ಆ ಮನುಷ್ಯನ ಮುಖವನ್ನು ನಾವು ನೋಡುವುದಕ್ಕಾಗುವುದು,’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“ಅದಕ್ಕೆ ನಿನ್ನ ದಾಸನಾದ ನನ್ನ ತಂದೆಯು, ‘ನನ್ನ ಹೆಂಡತಿಯು ನನಗೆ ಇಬ್ಬರು ಪುತ್ರರನ್ನು ಹೆತ್ತಳೆಂಬುದು ನಿಮಗೆ ತಿಳಿದಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ಒಬ್ಬನು ನನ್ನ ಬಳಿಯಿಂದ ಹೋಗಿ ಬಿಟ್ಟನು. “ಅವನು ನಿಶ್ಚಯವಾಗಿ ಕಾಡುಮೃಗದಿಂದ ಸೀಳಿ ಸತ್ತಿರಬೇಕು,” ಎಂದು ಹೇಳಿದಿರಿ. ಅವನನ್ನು ನಾನು ಈ ದಿನದವರೆಗೂ ನೋಡಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ಈಗ ಇವನನ್ನೂ ನನ್ನ ಬಳಿಯಿಂದ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕೆಂದಿದ್ದೀರಿ. ಅವನಿಗೂ ಕೇಡು ಬಂದರೆ, ನನ್ನ ಮುದಿ ತಲೆಯು ದುಃಖದಿಂದ ಸಮಾಧಿಗೆ ಇಳಿಯುವಂತೆ ಮಾಡುವಿರಿ,’ ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“ಹೀಗಿರಲಾಗಿ ನಾನು ನಿನ್ನ ದಾಸನಾದ ನನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಹೋಗುವ ಸಮಯದಲ್ಲಿ ಅವನ ಪ್ರಾಣವು ಹುಡುಗನ ಪ್ರಾಣದಲ್ಲಿ ನೆಟ್ಟಿದ್ದರಿಂದ, ");
INSERT INTO kanokcv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ಹುಡುಗನು ನಮ್ಮ ಸಂಗಡ ಇಲ್ಲದಿರುವುದನ್ನು ಕಂಡಾಗಲೇ ಅವನು ಸಾಯುವನು. ನಿನ್ನ ದಾಸನಾಗಿರುವ ನಮ್ಮ ತಂದೆಯ ಮುದಿ ತಲೆಯನ್ನು ದುಃಖದಿಂದ ಸಮಾಧಿಗೆ ನಿನ್ನ ದಾಸರು ಇಳಿಯುವಂತೆ ಮಾಡುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ಏಕೆಂದರೆ ನಿನ್ನ ದಾಸನಾದ ನಾನು, ಆ ಹುಡುಗನಿಗೋಸ್ಕರ ನನ್ನ ತಂದೆಯ ಬಳಿಯಲ್ಲಿ ಹೊಣೆಯಾಗಿ, ‘ಅವನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ತಾರದೆ ಹೋದರೆ, ಎಂದೆಂದಿಗೂ ನನ್ನ ತಂದೆಗೆ ದೋಷಿಯಾಗಿರುವೆನು,’ ಎಂದು ಹೇಳಿಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“ಹಾಗಿದ್ದಲ್ಲಿ ಆ ಹುಡುಗನ ಬದಲಾಗಿ ನಿನ್ನ ದಾಸನಾದ ನಾನು ನನ್ನ ಒಡೆಯನಿಗೆ ದಾಸನಾಗಿರುವೆನು. ಹುಡುಗನು ನನ್ನ ಸಹೋದರರ ಸಂಗಡ ಹೋಗಿಬಿಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ಹುಡುಗನು ನನ್ನ ಬಳಿಯಲ್ಲಿರದೆ, ನಾನು ಹೇಗೆ ನನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಹೋಗಲಿ? ಹೋದರೆ ನನ್ನ ತಂದೆಗೆ ಬರುವ ಕೇಡನ್ನು ನಾನು ನೋಡಬೇಕಾದೀತು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ಆಗ ಯೋಸೇಫನು ತನ್ನ ಸುತ್ತಲೂ ನಿಂತಿದ್ದವರ ಮುಂದೆ ಮನಸ್ಸನ್ನು ಬಿಗಿಹಿಡಿದುಕೊಳ್ಳಲು ಆಗಲಿಲ್ಲ. “ಎಲ್ಲರನ್ನೂ ತನ್ನ ಬಳಿಯಿಂದ ಹೊರಗೆ ಹೋಗುವಂತೆ ಮಾಡಿರಿ,” ಎಂದು ಕೂಗಿದನು. ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರಿಗೆ ತನ್ನನ್ನು ಪರಿಚಯಿಸಿಕೊಳ್ಳಲು ಹೋದಾಗ, ಅಲ್ಲಿ ಬೇರೆ ಯಾರೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ಆಗ ಅವನು ತನ್ನ ಸ್ವರವೆತ್ತಿ ಅತ್ತಾಗ, ಹೊರಗಿದ್ದ ಈಜಿಪ್ಟಿನವರೂ, ಫರೋಹನ ಮನೆಯವರೂ ಕೇಳಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರಿಗೆ, “ನಾನು ಯೋಸೇಫನು! ನನ್ನ ತಂದೆಯು ಬದುಕಿದ್ದಾನೋ?” ಎಂದನು. ಅದಕ್ಕೆ ಅವನ ಸಹೋದರರು ಅವನ ಮುಂದೆ ಕಳವಳಗೊಂಡವರಾಗಿ, ಅವನಿಗೆ ಉತ್ತರ ಕೊಡಲಾರದೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ಆಗ ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರಿಗೆ, “ನನ್ನ ಬಳಿಗೆ ಬನ್ನಿರಿ,” ಎಂದು ಕೇಳಿಕೊಂಡನು. ಅವರು ಹತ್ತಿರಕ್ಕೆ ಬಂದಾಗ ಅವನು, “ನೀವು ಈಜಿಪ್ಟಿಗೆ ಮಾರಿದ ನಿಮ್ಮ ಸಹೋದರನಾದ ಯೋಸೇಫನು ನಾನೇ! ");
INSERT INTO kanokcv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ಆದರೆ ನೀವು ನನ್ನನ್ನು ಇಲ್ಲಿಗೆ ಮಾರಿದ್ದಕ್ಕಾಗಿ ಈಗ ವ್ಯಸನಪಟ್ಟು ನಿಮ್ಮ ಮೇಲೆ ನೀವೇ ಸಿಟ್ಟುಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ಪ್ರಾಣ ಸಂರಕ್ಷಣೆಗಾಗಿ ದೇವರು ನನ್ನನ್ನು ನಿಮ್ಮ ಮುಂದೆ ಕಳುಹಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ಏಕೆಂದರೆ ಈ ಎರಡು ವರ್ಷಗಳವರೆಗೆ ಭೂಮಿಯಲ್ಲಿ ಕ್ಷಾಮವಿತ್ತು. ಇದಲ್ಲದೆ ಇನ್ನೂ ಐದು ವರ್ಷಗಳವರೆಗೆ ಬಿತ್ತುವುದೂ, ಕೊಯ್ಯುವುದೂ ಇರುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ಆದ್ದರಿಂದ ನಿಮ್ಮ ಸಂತತಿಯನ್ನು ಭೂಮಿಯಲ್ಲಿ ಉಳಿಸುವುದಕ್ಕೂ, ದೊಡ್ಡ ಬರಗಾಲದಿಂದ ನಿಮ್ಮ ಪ್ರಾಣಗಳನ್ನು ಉಳಿಸುವುದಕ್ಕೂ ದೇವರು ನನ್ನನ್ನು ಇಲ್ಲಿಗೆ ಕಳುಹಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“ಆದ್ದರಿಂದ ಈಗ ನೀವಲ್ಲ, ದೇವರು ತಾವೇ ನನ್ನನ್ನು ಇಲ್ಲಿಗೆ ಕಳುಹಿಸಿದ್ದಾರೆ. ದೇವರು ನನ್ನನ್ನು ಫರೋಹನಿಗೆ ತಂದೆಯಾಗಿಯೂ, ಅವನ ಮನೆಗೆಲ್ಲಾ ಯಜಮಾನನನ್ನಾಗಿಯೂ ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆಲ್ಲಾ ಅಧಿಕಾರಿಯನ್ನಾಗಿಯೂ ಮಾಡಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ನೀವು ಶೀಘ್ರವಾಗಿ ನನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಹೊರಟುಹೋಗಿ, ‘ನಿನ್ನ ಮಗ ಯೋಸೇಫನನ್ನು ದೇವರು ಈಜಿಪ್ಟಿಗೆಲ್ಲಾ ಪ್ರಭುವನ್ನಾಗಿ ಮಾಡಿದ್ದಾರೆ, ತಡಮಾಡದೆ ನನ್ನ ಬಳಿಗೆ ಬೇಗ ಬಾ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ಗೋಷೆನ್ ಪ್ರದೇಶದಲ್ಲಿ ನೀನು ವಾಸವಾಗಿದ್ದು ನಿನ್ನ ಮಕ್ಕಳೂ, ಮೊಮ್ಮಕ್ಕಳೂ, ದನಕುರಿಗಳೂ, ನಿನಗಿದ್ದದ್ದೆಲ್ಲವೂ ನನ್ನ ಸಮೀಪದಲ್ಲಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ಅಲ್ಲಿ ನಿನ್ನನ್ನು ಪೋಷಿಸುವೆನು. ಏಕೆಂದರೆ ಇನ್ನೂ ಕ್ಷಾಮದ ಐದು ವರ್ಷಗಳಿವೆ. ನಿನಗೂ, ನಿನ್ನ ಮನೆಗೂ, ನಿನಗಿರುವುದೆಲ್ಲದಕ್ಕೂ ಬಡತನವಾಗಬಾರದು’ ಎಂದು ಹೇಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“ನಿಮ್ಮ ಸಂಗಡ ಮಾತನಾಡುವುದು ನನ್ನ ಬಾಯಿಯೇ ಎಂದು ನಿಮ್ಮ ಕಣ್ಣುಗಳೂ, ನನ್ನ ಸಹೋದರ ಬೆನ್ಯಾಮೀನನ ಕಣ್ಣುಗಳೂ ನೋಡಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ಹೀಗಿರಲಾಗಿ ನೀವು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ನನಗಿರುವ ಎಲ್ಲಾ ಘನತೆಯನ್ನೂ, ನೀವು ನೋಡಿದ್ದೆಲ್ಲವನ್ನೂ ನನ್ನ ತಂದೆಗೆ ತಿಳಿಸಿ, ನನ್ನ ತಂದೆಯನ್ನು ಶೀಘ್ರವಾಗಿ ಇಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಬನ್ನಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ಅವನು ತನ್ನ ತಮ್ಮ ಬೆನ್ಯಾಮೀನನ ಕುತ್ತಿಗೆಯನ್ನು ಅಪ್ಪಿಕೊಂಡು ಅತ್ತನು, ಬೆನ್ಯಾಮೀನನೂ ಅತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ಇದಲ್ಲದೆ ತನ್ನ ಸಹೋದರರಿಗೆಲ್ಲಾ ಮುದ್ದಿಟ್ಟು ಅವರನ್ನು ಅಪ್ಪಿಕೊಂಡು ಅತ್ತನು. ತರುವಾಯ ಅವನ ಸಹೋದರರು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ಯೋಸೇಫನ ಸಹೋದರರು ಬಂದಿದ್ದಾರೆಂಬ ಸುದ್ದಿಯನ್ನು ಫರೋಹನ ಮನೆಯವರು ಕೇಳಿದಾಗ ಫರೋಹನಿಗೂ, ಅವನ ಸೇವಕರಿಗೂ ಅದು ಮೆಚ್ಚಿಗೆಯಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ಆಗ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ಸಹೋದರರಿಗೆ ಹೀಗೆ ಮಾಡಲು ಹೇಳು: ‘ನೀವು ನಿಮ್ಮ ವಾಹಕಪಶುಗಳ ಮೇಲೆ ವಸ್ತುಗಳನ್ನು ಹೇರಿ, ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಹೋಗಿ, ");
INSERT INTO kanokcv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ನಿಮ್ಮ ತಂದೆಯನ್ನೂ, ಕುಟುಂಬದವರನ್ನೂ ಕರೆದುಕೊಂಡು ನನ್ನ ಬಳಿಗೆ ಬನ್ನಿರಿ. ಈಜಿಪ್ಟ್ ದೇಶದ ಸುಖಸಂಪತ್ತನ್ನು ಅನುಭವಿಸಬಹುದು.’ ");
INSERT INTO kanokcv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“ಇದನ್ನು ಸಹ ನಿನ್ನ ಸಹೋದರರು ಹೇಳುವಂತೆ ನಿನಗೆ ಅಪ್ಪಣೆಯಾಗಿದೆ: ‘ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ನಿಮ್ಮ ಚಿಕ್ಕವರಿಗಾಗಿಯೂ, ಹೆಂಡತಿಯರಿಗಾಗಿಯೂ ಬಂಡಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡುಹೋಗಿ, ನಿಮ್ಮ ತಂದೆಯನ್ನು ಕರೆದುಕೊಂಡು ಬನ್ನಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ನಿಮ್ಮ ಸಾಮಗ್ರಿಗಳಿಗಾಗಿ ಚಿಂತಿಸಬೇಡಿರಿ. ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿರುವ ಉತ್ತಮವಾದದ್ದೆಲ್ಲಾ ನಿಮ್ಮದೇ,’ ” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ಇಸ್ರಾಯೇಲನ ಮಕ್ಕಳು ಹಾಗೆಯೇ ಮಾಡಿದರು. ಫರೋಹನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಯೋಸೇಫನು ಅವರಿಗೆ ಬಂಡಿಗಳನ್ನೂ, ಮಾರ್ಗಕ್ಕೋಸ್ಕರ ಆಹಾರವನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ಅವರೆಲ್ಲರಿಗೆ ಬದಲು ವಸ್ತ್ರಗಳನ್ನೂ, ಬೆನ್ಯಾಮೀನನಿಗೆ ಮುನ್ನೂರು ಬೆಳ್ಳಿಯ ನಾಣ್ಯಗಳನ್ನೂ, ಐದು ಬದಲು ವಸ್ತ್ರಗಳನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ಇದಲ್ಲದೆ ಅವನು ತನ್ನ ತಂದೆಗೆ ಹತ್ತು ಕತ್ತೆಗಳು ಹೊರುವಷ್ಟು ಈಜಿಪ್ಟಿನ ಶ್ರೇಷ್ಠವಾದವುಗಳನ್ನೂ, ಪ್ರಯಾಣಕ್ಕೋಸ್ಕರ ತಂದೆಗೆ ಹತ್ತು ಹೆಣ್ಣು ಕತ್ತೆಗಳು ಹೊರುವಷ್ಟು ಗೋಧಿ, ರೊಟ್ಟಿ, ಆಹಾರಗಳನ್ನೂ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ಯೋಸೇಫನು ಅವರಿಗೆ, “ಮಾರ್ಗದಲ್ಲಿ ಜಗಳವಾಡಬೇಡಿರಿ,” ಎಂದು ಹೇಳಿ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ಅವರು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಟುಹೋಗಿ ಕಾನಾನಿನಲ್ಲಿದ್ದ ತಮ್ಮ ತಂದೆ ಯಾಕೋಬನ ಬಳಿಗೆ ಬಂದು, ");
INSERT INTO kanokcv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“ಯೋಸೇಫನು ಇನ್ನೂ ಜೀವದಿಂದ ಇದ್ದಾನೆ! ಅವನೇ ಈಜಿಪ್ಟ್ ದೇಶವನ್ನೆಲ್ಲಾ ಆಳುತ್ತಿದ್ದಾನೆ,” ಎಂದು ಅವನಿಗೆ ತಿಳಿಸಿದಾಗ, ಅವನು ಆಶ್ಚರ್ಯಪಟ್ಟನು, ಅವರನ್ನು ನಂಬಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ಆದರೆ ಯೋಸೇಫನು ತಮಗೆ ಹೇಳಿದ ಎಲ್ಲಾ ಮಾತುಗಳನ್ನು ಅವರು ಯಾಕೋಬನಿಗೆ ಹೇಳಿದರು. ಅವನನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗುವುದಕ್ಕೆ ಯೋಸೇಫನು ಕಳುಹಿಸಿದ ರಥಗಳನ್ನು ಅವನು ನೋಡಿದಾಗ ಯಾಕೋಬನ ಆತ್ಮವು ಉಜ್ಜೀವಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ಕೊನೆಗೆ ಇಸ್ರಾಯೇಲನು, “ನನ್ನ ಮಗ ಯೋಸೇಫನು ಇನ್ನೂ ಜೀವಂತವಾಗಿದ್ದಾನೆ, ಅಷ್ಟೇ ಸಾಕು! ನಾನು ಸಾಯುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಹೋಗಿ ಅವನನ್ನು ನೋಡುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ಇಸ್ರಾಯೇಲನು ತನಗಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು ಬೇರ್ಷೆಬಕ್ಕೆ ಬಂದು, ತನ್ನ ತಂದೆ ಇಸಾಕನ ದೇವರಿಗೆ ಬಲಿಗಳನ್ನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ದೇವರು ಇಸ್ರಾಯೇಲನಿಗೆ ರಾತ್ರಿಯ ದರ್ಶನದಲ್ಲಿ ಮಾತನಾಡಿ, “ಯಾಕೋಬನೇ, ಯಾಕೋಬನೇ,” ಎಂದರು. ಅದಕ್ಕವನು, “ಇಗೋ, ಇದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ದೇವರು ಅವನಿಗೆ, “ನಾನೇ ದೇವರು, ನಿನ್ನ ತಂದೆಯ ದೇವರು. ನೀನು ಈಜಿಪ್ಟಿಗೆ ಹೋಗುವುದಕ್ಕೆ ಭಯಪಡಬೇಡ. ಏಕೆಂದರೆ ಅಲ್ಲಿ ನಾನು ನಿನ್ನನ್ನು ದೊಡ್ಡ ಜನಾಂಗವಾಗಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ನಾನೇ ನಿನ್ನ ಸಂಗಡ ಈಜಿಪ್ಟಿಗೆ ಹೋಗುವೆನು. ನಾನು ನಿಶ್ಚಯವಾಗಿ ನಿನ್ನನ್ನು ಕಾನಾನಿಗೆ ತಿರುಗಿ ಬರಮಾಡುವೆನು. ಯೋಸೇಫನು ನಿನ್ನ ಅಂತಿಮ ಕಾಲದಲ್ಲಿ ನೀನು ಕಣ್ಣುಮುಚ್ಚುವಾಗ ಇರುವನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ಆಗ ಯಾಕೋಬನು ಎದ್ದು ಬೇರ್ಷೆಬದಿಂದ ಹೊರಟನು. ಆಗ ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ತಂದೆ ಯಾಕೋಬನನ್ನೂ, ತಮ್ಮ ಮಕ್ಕಳನ್ನೂ, ತಮ್ಮ ಹೆಂಡತಿಯರನ್ನೂ ಫರೋಹನು ಕಳುಹಿಸಿದ ರಥಗಳಲ್ಲಿ ಕೂರಿಸಿಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ಅವರು ತಮ್ಮ ಪಶುಗಳನ್ನೂ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ತಾವು ಸಂಪಾದಿಸಿದ ತಮ್ಮ ಸಂಪತ್ತನ್ನೂ ತೆಗೆದುಕೊಂಡು ಈಜಿಪ್ಟಿಗೆ ಬಂದರು. ಯಾಕೋಬನು ತನ್ನ ಕುಟುಂಬ ಸಮೇತವಾಗಿ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ಅವನು ತನ್ನ ಗಂಡು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನೂ, ಮೊಮ್ಮೊಕ್ಕಳನ್ನೂ, ಅಂತೂ ತನ್ನ ಇಡೀ ಕುಟುಂಬದವರೆಲ್ಲರನ್ನೂ ತನ್ನೊಂದಿಗೆ ಈಜಿಪ್ಟಿಗೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ಈಜಿಪ್ಟಿಗೆ ಬಂದ ಇಸ್ರಾಯೇಲರ ಮಕ್ಕಳು ಎಂದರೆ, ಯಾಕೋಬನ ಹಾಗೂ ಅವನ ಸಂತತಿಯರ ಹೆಸರುಗಳು: ಯಾಕೋಬನ ಚೊಚ್ಚಲ ಮಗ ರೂಬೇನನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ರೂಬೇನನ ಪುತ್ರರು: ಹನೋಕ್, ಪಲ್ಲೂ, ಹೆಚ್ರೋನ್ ಮತ್ತು ಕರ್ಮೀ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ಸಿಮೆಯೋನನ ಮಕ್ಕಳು: ಯೆಮೂಯೇಲ್, ಯಾಮೀನ್, ಓಹದ್, ಯಾಕೀನ್, ಚೋಹರ್ ಮತ್ತು ಕಾನಾನ್ಯಳ ಮಗನಾದ ಸೌಲ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ಲೇವಿಯ ಪುತ್ರರು: ಗೇರ್ಷೋನ್, ಕೊಹಾತ್, ಮೆರಾರೀ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ಯೆಹೂದನ ಮಕ್ಕಳು: ಏರ್, ಓನಾನ್, ಶೇಲಹ, ಪೆರೆಚ್ ಮತ್ತು ಜೆರಹ. ಆದರೆ ಏರನೂ, ಓನಾನನೂ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಸತ್ತರು. ಪೆರೆಚನ ಮಕ್ಕಳು: ಹೆಚ್ರೋನ್ ಮತ್ತು ಹಾಮೂಲ್ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ಇಸ್ಸಾಕಾರನ ಮಕ್ಕಳು: ತೋಲಾ, ಪುವ್ವಾ, ಯೋಬ್ ಮತ್ತು ಶಿಮ್ರೋನ್ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ಜೆಬುಲೂನನ ಮಕ್ಕಳು: ಸೆರೆದ್, ಏಲೋನ್, ಯಹಲೇಲ್ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ಇವರು ಲೇಯಳ ಮಕ್ಕಳು. ಆಕೆಯು ಇವರನ್ನೂ, ತನ್ನ ಮಗಳಾದ ದೀನಳನ್ನೂ ಪದ್ದನ್ ಅರಾಮಿನಲ್ಲಿ ಯಾಕೋಬನಿಗೆ ಹೆತ್ತಳು. ಅವನ ಪುತ್ರಪುತ್ರಿಯರೆಲ್ಲಾ ಸೇರಿ ಒಟ್ಟು ಮೂವತ್ತು ಮೂರು ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ಗಾದನ ಮಕ್ಕಳು: ಚಿಫ್ಯೋನ್, ಹಗ್ಗೀ, ಶೂನೀ, ಎಚ್ಬೋನ್, ಏರೀ, ಅರೋದೀ ಮತ್ತು ಅರೇಲೀ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ಆಶೇರನ ಮಕ್ಕಳು: ಇಮ್ನಾ, ಇಷ್ವಾ, ಇಷ್ವೀ, ಬೆರೀಯ ಮತ್ತು ಅವರ ಸಹೋದರಿಯಾದ ಸೆರಹ. ಬೆರೀಗನ ಪುತ್ರರು: ಹೆಬೆರ, ಮಲ್ಕೀಯೇಲ್ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ಲೇಯಳಿಗೆ ಕೊಟ್ಟ ಜಿಲ್ಪಳ ಮಕ್ಕಳು ಇವರೇ. ಈಕೆಯಿಂದ ಯಾಕೋಬನಿಗಾದ ಮಕ್ಕಳು ಮತ್ತು ಮೊಮ್ಮಕ್ಕಳು ಒಟ್ಟು ಹದಿನಾರು ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ಯಾಕೋಬನ ಹೆಂಡತಿಯಾದ ರಾಹೇಲಳ ಪುತ್ರರು: ಯೋಸೇಫ್, ಬೆನ್ಯಾಮೀನ್ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ಯೋಸೇಫನಿಗೆ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ಓನ್ ಪಟ್ಟಣದ ಯಾಜಕನಾಗಿರುವ ಪೋಟೀಫೆರನ ಮಗಳಾದ ಆಸನತ್ ಮನಸ್ಸೆಯನ್ನೂ, ಎಫ್ರಾಯೀಮನನ್ನೂ ಅವನಿಗೆ ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ಬೆನ್ಯಾಮೀನನ ಪುತ್ರರು: ಬೆಳ, ಬೆಕೆರ್, ಅಷ್ಬೇಲ್, ಗೇರಾ, ನಾಮಾನ್, ಏಹೀ, ರೋಷ್, ಮುಪ್ಪೀಮ್, ಹುಪ್ಪೀಮ್ ಮತ್ತು ಆರ್ದ್ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ಇವರು ಯಾಕೋಬನಿಗೆ ಹುಟ್ಟಿದ ರಾಹೇಲಳ ಪುತ್ರರು. ಎಲ್ಲರೂ ಕೂಡಿ ಹದಿನಾಲ್ಕು ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ದಾನನ ಮಗನು: ಹುಶೀಮನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ನಫ್ತಾಲಿಯ ಪುತ್ರರು: ಯಹಚೇಲ, ಗೂನೀ, ಯೇಚೆರ್, ಶಿಲ್ಲೇಮ್ ಎಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ಇವರು ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ರಾಹೇಲಳಿಗೆ ಕೊಟ್ಟಿದ್ದ ಬಿಲ್ಹಳ ಪುತ್ರರು. ಇವರನ್ನು ಆಕೆಯು ಯಾಕೋಬನಿಗೆ ಹೆತ್ತಳು. ಇವರು ಎಲ್ಲರೂ ಕೂಡಿ ಏಳುಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ಯಾಕೋಬನ ಪುತ್ರರ ಹೆಂಡತಿಯರಲ್ಲದೆ, ಯಾಕೋಬನ ಸಂಗಡ ಈಜಿಪ್ಟಿಗೆ ಹೋದವರು ಒಟ್ಟು ಅರವತ್ತಾರು ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ಅವರಲ್ಲದೆ ಈಜಿಪ್ಟಿನಲ್ಲಿ ಯೋಸೇಫನಿಗೆ ಇಬ್ಬರು ಪುತ್ರರು ಹುಟ್ಟಿದರು. ಯಾಕೋಬನ ಮನೆಯವರಾಗಿ ಈಜಿಪ್ಟಿಗೆ ಹೋದ ಜನರೆಲ್ಲಾ ಸೇರಿ ಒಟ್ಟು ಎಪ್ಪತ್ತು ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ಇದಲ್ಲದೆ ಗೋಷೆನ್ ಪ್ರಾಂತಕ್ಕೆ ಮಾರ್ಗವನ್ನು ತೋರಿಸುವಂತೆ ಯಾಕೋಬನು ಯೆಹೂದನನ್ನು ತನ್ನ ಮುಂದಾಗಿ ಯೋಸೇಫನ ಬಳಿಗೆ ಕಳುಹಿಸಿದನು. ಅವರು ಗೋಷೆನ್ ಪ್ರಾಂತಕ್ಕೆ ಬಂದು ಸೇರಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ಆಗ ಯೋಸೇಫನು ತನ್ನ ರಥವನ್ನು ಸಿದ್ಧಮಾಡಿಕೊಂಡು, ತನ್ನ ತಂದೆ ಇಸ್ರಾಯೇಲನಿಗೆ ಎದುರಾಗಿ ಗೋಷೆನಿಗೆ ಹೋದನು. ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯನ್ನು ಸಂಧಿಸಿ, ಅಪ್ಪಿಕೊಂಡು, ಬಹಳ ಹೊತ್ತಿನವರೆಗೆ ಅತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ಆಗ ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ಮುಖವನ್ನು ಕಂಡಿದ್ದರಿಂದ ಇನ್ನು ನಾನು ಮರಣ ಹೊಂದಲು ಸಿದ್ಧನಾಗಿದ್ದೇನೆ. ನೀನು ಇನ್ನೂ ಜೀವದಿಂದ ಇದ್ದೀಯೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರಿಗೂ, ತನ್ನ ತಂದೆಯ ಮನೆಯವರಿಗೂ, “ನಾನು ಹೋಗಿ ಫರೋಹನಿಗೆ, ಕಾನಾನ್ ದೇಶದಲ್ಲಿದ್ದ ನನ್ನ ಸಹೋದರರೂ, ನನ್ನ ತಂದೆಯ ಮನೆಯವರೂ ನನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ಅವರು ಕುರಿಕಾಯುವವರು, ಅವರಿಗೆ ಪಶುಗಳು ಇವೆ. ತಮ್ಮ ಕುರಿದನಗಳನ್ನೂ, ತಮಗಿದ್ದದ್ದೆಲ್ಲವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಂದಿದ್ದಾರೆ, ಎಂದು ಹೇಳುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ಫರೋಹನು ನಿಮ್ಮನ್ನು ಕರೆಯಿಸಿ, ‘ನಿಮ್ಮ ಕೆಲಸವೇನು?’ ಎಂದು ಕೇಳುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ನೀವು ಅವನಿಗೆ, ‘ಚಿಕ್ಕಂದಿನಿಂದ ಇಂದಿನವರೆಗೂ ನಿನ್ನ ದಾಸರಾದ ನಾವೂ ನಮ್ಮ ಪೂರ್ವಿಕರೂ ಪಶುಗಳನ್ನು ಕಾಯುವವರಾಗಿದ್ದೇವೆ,’ ಎಂದು ಹೇಳಬೇಕು. ಏಕೆಂದರೆ ಕುರಿ ಕಾಯುವವರೆಲ್ಲಾ ಈಜಿಪ್ಟಿನವರಿಗೆ ಅಸಹ್ಯವಾಗಿದ್ದರಿಂದ, ನೀವು ಗೋಷೆನ್ ಪ್ರಾಂತದಲ್ಲಿ ವಾಸವಾಗಿರುವಂತೆ ನೇಮಿಸುವನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ಯೋಸೇಫನು ಹೋಗಿ ಫರೋಹನಿಗೆ, “ನನ್ನ ತಂದೆಯೂ, ನನ್ನ ಸಹೋದರರೂ ತಮ್ಮ ಕುರಿದನಗಳನ್ನೂ, ತಮಗಿದ್ದ ಎಲ್ಲವುಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಕಾನಾನ್ ದೇಶದಿಂದ ಬಂದಿದ್ದಾರೆ. ಅವರು ಗೋಷೆನ್ ಪ್ರಾಂತದಲ್ಲಿ ಇದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ಅವನು ತನ್ನ ಸಹೋದರರಲ್ಲಿ ಐದು ಮಂದಿಯನ್ನು ಕರೆದುಕೊಂಡು ಬಂದು ಫರೋಹನ ಮುಂದೆ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ಫರೋಹನು ಯೋಸೇಫನ ಸಹೋದರರಿಗೆ, “ನಿಮ್ಮ ಕೆಲಸವೇನು?” ಎಂದು ಕೇಳಿದನು. ಅವರು ಫರೋಹನಿಗೆ, “ನಿನ್ನ ದಾಸರಾದ ನಾವೂ, ನಮ್ಮ ತಂದೆಯವರೂ ಕುರಿಕಾಯುವವರಾಗಿದ್ದೇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ದೇಶದಲ್ಲಿ ಪ್ರವಾಸಮಾಡುವುದಕ್ಕಾಗಿ ಬಂದಿದ್ದೇವೆ. ಏಕೆಂದರೆ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಕ್ಷಾಮವು ಕಠಿಣವಾಗಿರುವುದರಿಂದ, ನಿನ್ನ ದಾಸರ ಮಂದೆಗಳಿಗೆ ಹುಲ್ಲುಗಾವಲು ಇಲ್ಲ. ಹೀಗಿರುವುದರಿಂದ ನಿನ್ನ ದಾಸರು ಗೋಷೆನ್ ಪ್ರಾಂತದ ನಿವಾಸಿಗಳಾಗುವಂತೆ ಮಾಡಬೇಕೆಂದು ನಿನ್ನನ್ನು ಕೇಳಿಕೊಳ್ಳುತ್ತೇವೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ಅದಕ್ಕೆ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ತಂದೆಯೂ, ನಿನ್ನ ಸಹೋದರರೂ ನಿನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ಈಜಿಪ್ಟ್ ದೇಶವು ನಿನ್ನ ಮುಂದೆ ಇದೆ. ದೇಶದ ಉತ್ತಮವಾದ ಕಡೆ ನಿನ್ನ ತಂದೆಯೂ, ಸಹೋದರರೂ ವಾಸಮಾಡುವಂತೆ ಮಾಡು. ಗೋಷೆನ್ ಪ್ರಾಂತದಲ್ಲಿ ಅವರು ವಾಸವಾಗಿರಲಿ. ಅವರಲ್ಲಿ ಯಾರಾದರೂ ಸಮರ್ಥರೆಂದು ನೀನು ತಿಳಿದರೆ, ಅವರನ್ನು ನಮಗಿರುವ ಪಶುಗಳ ಮೇಲೆ ವಿಚಾರಕರನ್ನಾಗಿ ಇರಿಸು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ಯೋಸೇಫನು ತನ್ನ ತಂದೆ ಯಾಕೋಬನನ್ನು ಕರೆದುಕೊಂಡು ಬಂದು, ಫರೋಹನ ಮುಂದೆ ನಿಲ್ಲಿಸಿದನು. ಯಾಕೋಬನು ಫರೋಹನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ಫರೋಹನು ಯಾಕೋಬನಿಗೆ, “ನಿನಗೆ ಎಷ್ಟು ವರ್ಷಗಳು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ಯಾಕೋಬನು ಫರೋಹನಿಗೆ, “ನಾನು ಲೋಕದಲ್ಲಿ ಸಂಚಾರಮಾಡಿದ್ದು ನೂರಮೂವತ್ತು ವರುಷಗಳೇ. ನನ್ನ ವರ್ಷಗಳು ಕಡಿಮೆಯಾದರೂ ಕಠಿಣವಾದವುಗಳು ಆಗಿವೆ. ಅವು ನನ್ನ ಪಿತೃಗಳ ಪ್ರಯಾಣದ ವರ್ಷಗಳಿಗೆ ಸಮವಾಗಿಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ಆಗ ಯಾಕೋಬನು ಫರೋಹನನ್ನು ಆಶೀರ್ವದಿಸಿ, ಅವನಿಂದ ಬೀಳ್ಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೂ, ತನ್ನ ಸಹೋದರರಿಗೂ ನಿವಾಸವನ್ನು ಕೊಟ್ಟು, ಫರೋಹನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ, ಅವರಿಗೆ ಈಜಿಪ್ಟ್ ದೇಶದ ಉತ್ತಮವಾದ ರಮ್ಸೇಸ್ ಸೀಮೆಯ ಸ್ವತ್ತನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯನ್ನೂ, ತನ್ನ ಸಹೋದರರನ್ನೂ, ತನ್ನ ತಂದೆಯ ಮನೆಯವರೆಲ್ಲರನ್ನೂ ಅವರ ಮಕ್ಕಳ ಲೆಕ್ಕದ ಪ್ರಕಾರ ಆಹಾರಕೊಟ್ಟು, ಅವರನ್ನು ಸಂರಕ್ಷಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ಆದರೆ ಬರವು ಅತಿ ಘೋರವಾಗಿದ್ದದ್ದರಿಂದ ದೇಶದಲ್ಲೆಲ್ಲಾ ಆಹಾರ ಇರಲಿಲ್ಲ. ಈಜಿಪ್ಟ್ ದೇಶವೂ, ಕಾನಾನ್ ದೇಶವೂ ಕ್ಷಾಮದಿಂದ ಕ್ಷೀಣವಾದವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ಆಗ ಯೋಸೇಫನು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿಯೂ, ಕಾನಾನ್ ದೇಶದಲ್ಲಿಯೂ ಜನರು ಕೊಂಡುಕೊಂಡ ಧಾನ್ಯಕ್ಕೆ ಬದಲಾಗಿ ಕೊಟ್ಟ ಹಣವನ್ನೆಲ್ಲಾ ಕೂಡಿಸಿ, ಅದನ್ನು ಫರೋಹನ ಮನೆಗೆ ತಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿಯೂ, ಕಾನಾನ್ ದೇಶದಲ್ಲಿಯೂ ಹಣವು ಮುಗಿದಾಗ, ಈಜಿಪ್ಟಿನವರೆಲ್ಲರೂ ಯೋಸೇಫನ ಬಳಿಗೆ ಬಂದು, “ನಮಗೆ ಆಹಾರವನ್ನು ಕೊಡು, ನಾವು ನಿನ್ನ ಮುಂದೆ ಏಕೆ ಸಾಯಬೇಕು? ಏಕೆಂದರೆ ಹಣವೆಲ್ಲಾ ತೀರಿತು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ಆಗ ಯೋಸೇಫನು, “ನಿಮ್ಮ ಪಶುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬನ್ನಿರಿ, ಹಣ ತೀರಿದ್ದೇಯಾದರೆ, ನಿಮ್ಮ ಪಶುಗಳಿಗೆ ಬದಲಾಗಿ ಧಾನ್ಯವನ್ನು ಕೊಡುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ಅವರು ತಮ್ಮ ಪಶುಗಳನ್ನೆಲ್ಲಾ ಯೋಸೇಫನ ಬಳಿಗೆ ತಂದರು. ಅವುಗಳ ಬದಲಾಗಿ ಅವನು ಆಹಾರ ಧಾನ್ಯ ಕೊಟ್ಟನು. ಅವರ ಕುದುರೆಗಳನ್ನೂ ಕುರಿಗಳನ್ನೂ ಆಡುಗಳನ್ನೂ ದನಗಳನ್ನೂ ಕತ್ತೆಗಳನ್ನೂ ಬದಲಾಗಿ ತೆಗೆದುಕೊಂಡನು. ಆ ವರ್ಷ ಅವರು ಆಹಾರಕ್ಕಾಗಿ ತಮ್ಮ ಎಲ್ಲಾ ಪಶುಪ್ರಾಣಿಗಳನ್ನು ಮಾರಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ಆ ವರ್ಷವಾದ ಮೇಲೆ ಮಾರನೆಯ ವರ್ಷದಲ್ಲಿ, ಅವರು ಅವನ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, “ಹಣವೂ ಪಶುಗಳ ಮಂದೆಗಳೂ ನಮ್ಮ ಒಡೆಯನ ವಶವಾಗಿ ಮುಗಿದಿರುವುದರಿಂದ, ನಮ್ಮ ಶರೀರಗಳೂ, ನಮ್ಮ ಭೂಮಿಯೂ ಹೊರತು ನಮ್ಮ ಒಡೆಯನ ಮುಂದೆ ಏನೂ ಉಳಿಯಲಿಲ್ಲವೆಂಬುದನ್ನು ನಮ್ಮ ಒಡೆಯನಿಗೆ ಮರೆಮಾಡದೆ ತಿಳಿಸುತ್ತಿದ್ದೇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ನಾವೂ, ನಮ್ಮ ಭೂಮಿಯೂ ನಿನ್ನ ಕಣ್ಣೆದುರಿಗೆ ಸಾಯುವುದು ಏಕೆ? ನಮ್ಮನ್ನೂ, ನಮ್ಮ ಭೂಮಿಯನ್ನೂ ಆಹಾರಕ್ಕಾಗಿ ಕೊಂಡುಕೋ. ಆಗ ನಾವೂ, ನಮ್ಮ ಭೂಮಿಯೂ ಫರೋಹನಿಗೆ ದಾಸರಾಗಿರುವೆವು. ನಮಗೆ ಬೀಜವನ್ನು ಕೊಡು, ಆಗ ನಾವು ಸಾಯದೆ ಬದುಕುವೆವು, ಭೂಮಿಯು ಹಾಳಾಗದೆ ಇರುವುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ಆಗ ಯೋಸೇಫನು ಈಜಿಪ್ಟ್ ದೇಶವನ್ನೆಲ್ಲಾ ಫರೋಹನಿಗಾಗಿ ಕೊಂಡುಕೊಂಡನು. ಬರವು ಅವರಿಗೆ ಘೋರವಾಗಿದ್ದುದರಿಂದ ಈಜಿಪ್ಟನವರು ತಮ್ಮ ತಮ್ಮ ಹೊಲಗಳನ್ನು ಮಾರಿಬಿಟ್ಟರು. ಹೀಗೆ ದೇಶವು ಫರೋಹನದಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ಯೋಸೇಫನು ಈಜಿಪ್ಟ್ ದೇಶದ ಒಂದು ಮೇರೆಯಿಂದ ಇನ್ನೊಂದು ಮೇರೆಯವರೆಗೂ ಜನರನ್ನು ದಾಸರನ್ನಾಗಿ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ಯಾಜಕರ ಭೂಮಿಯನ್ನು ಮಾತ್ರ ಅವನು ಕೊಂಡುಕೊಳ್ಳಲಿಲ್ಲ. ಏಕೆಂದರೆ ಫರೋಹನು ಯಾಜಕರಿಗೆ ಭತ್ಯೆಗಳನ್ನು ನೇಮಿಸಿದ್ದನು. ಅವನು ಅವರಿಗೆ ನೇಮಿಸಿದ್ದನ್ನು, ಅವರು ಊಟಮಾಡುತ್ತಿದ್ದರು. ಆದ್ದರಿಂದ ಅವರು ತಮ್ಮ ಭೂಮಿಗಳನ್ನು ಮಾರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ಯೋಸೇಫನು ಜನರಿಗೆ, “ಇಂದು ನಿಮ್ಮನ್ನೂ, ನಿಮ್ಮ ಭೂಮಿಯನ್ನೂ ಫರೋಹನಿಗಾಗಿ ಕೊಂಡುಕೊಂಡಿದ್ದೇನೆ. ಇಲ್ಲಿ ನಿಮಗೆ ಬೀಜವಿದೆ. ನೀವು ಭೂಮಿಯಲ್ಲಿ ಬೀಜ ಬಿತ್ತಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ಬೆಳೆ ಬಂದಾಗ ಐದನೆಯ ಪಾಲನ್ನು ಫರೋಹನಿಗೆ ಕೊಡಬೇಕು. ಉಳಿದ ನಾಲ್ಕು ಪಾಲು ಹೊಲದ ಬೀಜಕ್ಕಾಗಿಯೂ, ನಿಮ್ಮ ಆಹಾರಕ್ಕಾಗಿಯೂ, ನಿಮ್ಮ ಮಕ್ಕಳ ಆಹಾರಕ್ಕಾಗಿಯೂ ನಿಮಗೆ ಇರಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ಆಗ ಅವರು, “ನೀನೇ ನಮ್ಮನ್ನು ಬದುಕಿಸಿದ್ದೀ, ನಮ್ಮ ಒಡೆಯನ ಕಣ್ಣುಗಳ ಮುಂದೆ ನಮಗೆ ದಯೆ ದೊರಕಲಿ. ನಾವು ಫರೋಹನ ದಾಸರಾಗಿರುವೆವು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ಹೀಗೆ ಯೋಸೇಫನು ಫರೋಹನಿಗೆ ಐದನೆಯ ಪಾಲು ಆಗಬೇಕೆಂಬುದನ್ನು ಈಜಿಪ್ಟಿನ ಭೂಮಿಗೆ ಇಂದಿನವರೆಗೂ ನಿಯಮವಾಗಿ ಸ್ಥಾಪಿಸಿದನು. ಯಾಜಕರ ಭೂಮಿಯು ಮಾತ್ರ ಫರೋಹನದಾಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ಇಸ್ರಾಯೇಲರು ಈಜಿಪ್ಟ್ ದೇಶದ ಗೋಷೆನ್ ಪ್ರಾಂತದಲ್ಲಿ ವಾಸವಾಗಿದ್ದು, ಆಸ್ತಿಯನ್ನು ಸಂಪಾದಿಸಿ, ಬೆಳೆದು ಬಹಳವಾಗಿ ವೃದ್ಧಿಹೊಂದಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ಇದಲ್ಲದೆ ಯಾಕೋಬನು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಹದಿನೇಳು ವರುಷ ಬದುಕಿದನು. ಯಾಕೋಬನು ಬದುಕಿದ ದಿನಗಳು ನೂರ ನಲ್ವತ್ತೇಳು ವರ್ಷಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ಇಸ್ರಾಯೇಲನ ಮರಣದ ಸಮಯವು ಸಮೀಪಿಸಿದಾಗ, ಅವನು ತನ್ನ ಮಗ ಯೋಸೇಫನನ್ನು ಕರೆಯಿಸಿ ಅವನಿಗೆ, “ಈಗ ನಿನ್ನ ಸಮ್ಮುಖದಲ್ಲಿ ನಾನು ದಯೆ ಹೊಂದಿದ್ದೇಯಾದರೆ, ನಿನ್ನ ಕೈಯನ್ನು ನನ್ನ ತೊಡೆಯ ಕೆಳಗೆ ಇಟ್ಟು, ನನಗೆ ಉಪಕಾರವನ್ನೂ, ನಂಬಿಗಸ್ತಿಕೆಯನ್ನೂ ತೋರಿಸು. ಈಜಿಪ್ಟಿನಲ್ಲಿ ನನ್ನನ್ನು ಹೂಳಿಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ನನ್ನ ತಂದೆಯ ಸಂಗಡ ನಾನು ಮಲಗಬೇಕು. ಈಜಿಪ್ಟಿನಿಂದ ನನ್ನನ್ನು ತೆಗೆದುಕೊಂಡುಹೋಗಿ, ಅವರ ಸಮಾಧಿಯ ಸ್ಥಳದಲ್ಲಿ ನನ್ನನ್ನು ಹೂಳಿಡು,” ಎಂದನು. ಅದಕ್ಕವನು, “ನಿನ್ನ ಮಾತಿನ ಪ್ರಕಾರ ನಾನು ಮಾಡುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ಯಾಕೋಬನು ತನಗೆ ಪ್ರಮಾಣಮಾಡು ಎಂದಾಗ ಯೋಸೇಫನು ಅವನಿಗೆ ಪ್ರಮಾಣ ಮಾಡಿದನು. ಆಗ ಇಸ್ರಾಯೇಲನು ತನ್ನ ಊರುಕೋಲಿನ ಮೇಲೆ ಒರಗಿಕೊಂಡು ದೇವರನ್ನು ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ಕೆಲವು ಕಾಲದ ನಂತರ ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ತಂದೆ ಅಸ್ವಸ್ಥನಾಗಿದ್ದಾನೆ,” ಎಂಬ ಸುದ್ದಿ ಬಂದಿತು. ಆಗ ಅವನು ತನ್ನ ಇಬ್ಬರು ಪುತ್ರರಾದ ಮನಸ್ಸೆಯನ್ನೂ, ಎಫ್ರಾಯೀಮನನ್ನೂ ಕರೆದುಕೊಂಡು ತಂದೆಯ ಬಳಿಗೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ಯಾಕೋಬನಿಗೆ, “ನಿನ್ನ ಮಗ ಯೋಸೇಫನು ಬಂದಿದ್ದಾನೆ,” ಎಂದು ತಿಳಿಸಿದಾಗ, ಇಸ್ರಾಯೇಲನು ಚೇತರಿಸಿಕೊಂಡು ಹಾಸಿಗೆಯ ಮೇಲೆ ಕುಳಿತುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ಆಗ ಯಾಕೋಬನು ಯೋಸೇಫನಿಗೆ, “ಸರ್ವಶಕ್ತ ದೇವರು ಕಾನಾನ್ ದೇಶದ ಲೂಜ್ ಎಂಬಲ್ಲಿ ನನಗೆ ಕಾಣಿಸಿಕೊಂಡು, ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ದೇವರು ನನಗೆ, ‘ನಿನ್ನನ್ನು ಅಭಿವೃದ್ಧಿಪಡಿಸಿ, ನಿನ್ನ ಸಂತತಿಯನ್ನು ಹೆಚ್ಚಿಸುವೆನು. ಅನೇಕ ಜನಾಂಗಗಳು ನಿನ್ನಿಂದುಟಾಗುವಂತೆ ಮಾಡುವೆನು, ನಿನ್ನ ತರುವಾಯ ನಿನ್ನ ಸಂತತಿಗೂ ಈ ದೇಶವನ್ನು ಶಾಶ್ವತವಾದ ಸ್ವತ್ತನ್ನಾಗಿ ಕೊಡುತ್ತೇನೆ,’ ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“ಈಗ ನಾನು ನಿನ್ನ ಬಳಿಗೆ ಈಜಿಪ್ಟಿಗೆ ಬರುವ ಮೊದಲು ಈಜಿಪ್ಟಿನಲ್ಲಿ ನಿನಗೆ ಹುಟ್ಟಿದ ಇಬ್ಬರು ಪುತ್ರರಾದ ಎಫ್ರಾಯೀಮ್ ಮನಸ್ಸೆಯರು ನನ್ನವರಾಗಿರಬೇಕು. ಅವರು ರೂಬೇನ್ ಮತ್ತು ಸಿಮೆಯೋನರಂತೆ ನನ್ನವರಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ಆದರೆ ಅವರ ತರುವಾಯ ನಿನ್ನಿಂದ ಹುಟ್ಟುವ ಸಂತಾನವು ನಿನ್ನದಾಗಿರಲಿ. ಅವರು ತಮ್ಮ ಸಹೋದರರ ಸೊತ್ತಿಗೆ ಬಾಧ್ಯತೆಯನ್ನು ಪಡೆದು ಅವರ ಕುಲದ ಹೆಸರನ್ನೇ ಇಟ್ಟುಕೊಳ್ಳಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ನಾನು ಪದ್ದನ್ ಅರಾಮಿನಿಂದ ಬಂದಾಗ, ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಎಫ್ರಾತಿನಿಂದ ಸ್ವಲ್ಪ ದೂರವಾಗಿರುವಾಗ, ರಾಹೇಲಳು ಸತ್ತುಹೋದಳು. ಅಲ್ಲಿ ಅಂದರೆ, ಬೇತ್ಲೆಹೇಮ್ ಎಂಬ ಎಫ್ರಾತಿಗೆ ಹೋಗುವ ಮಾರ್ಗದಲ್ಲಿ ಆಕೆಯನ್ನು ಸಮಾಧಿಮಾಡಿದೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ಆಗ ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನ ಮಕ್ಕಳನ್ನು ಕಂಡು, “ಇವರು ಯಾರು?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ಅದಕ್ಕೆ ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೆ, “ದೇವರು ಈ ಸ್ಥಳದಲ್ಲಿ ನನಗೆ ಕೊಟ್ಟ ನನ್ನ ಪುತ್ರರು,” ಎಂದನು. ಆಗ ಇಸ್ರಾಯೇಲನು, “ಅವರನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಾ. ನಾನು ಅವರನ್ನು ಆಶೀರ್ವದಿಸುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ಇಸ್ರಾಯೇಲನು ಮುದುಕನಾಗಿದ್ದದ್ದರಿಂದ, ಅವನ ಕಣ್ಣುಗಳು ಕಾಣದಷ್ಟು ಮಬ್ಬಾಗಿದ್ದವು. ಯೋಸೇಫನು ಅವರನ್ನು ಅವನ ಸಮೀಪಕ್ಕೆ ತಂದಾಗ, ಅವನು ಅವರನ್ನು ಮುದ್ದಿಟ್ಟು, ಅಪ್ಪಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ಮುಖವನ್ನು ಕಾಣುವೆನೆಂದು ನಾನು ನೆನಸಿರಲಿಲ್ಲ. ಆದರೆ ನಿನ್ನ ಸಂತಾನವನ್ನು ಸಹ ದೇವರು ನನಗೆ ಕಾಣುವಂತೆ ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ಆಗ ಯೋಸೇಫನು ಅವರನ್ನು ಮೊಣಕಾಲುಗಳ ಬಳಿಯಿಂದ ಬರಮಾಡಿ ತಂದೆಗೆ ಅಡ್ಡಬಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ತರುವಾಯ ಯೋಸೇಫನು ತನ್ನ ಬಲಗಡೆಯಲ್ಲಿ ಇಸ್ರಾಯೇಲನ ಎಡಗೈಗೆ ಎದುರಾಗಿ ಎಫ್ರಾಯೀಮನನ್ನೂ, ತನ್ನ ಎಡಗಡೆಯಲ್ಲಿ ಇಸ್ರಾಯೇಲನ ಬಲಗೈಗೆ ಎದುರಾಗಿ ಮನಸ್ಸೆಯನ್ನೂ ನಿಲ್ಲಿಸಿ, ಅವರಿಬ್ಬರನ್ನೂ ತನ್ನ ತಂದೆಯ ಬಳಿಗೆ ತಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ಆಗ ಇಸ್ರಾಯೇಲನು ತನ್ನ ಬಲಗೈಯನ್ನು ಚಾಚಿ ಚಿಕ್ಕವನಾದ ಎಫ್ರಾಯೀಮನ ತಲೆಯ ಮೇಲೆಯೂ, ತನ್ನ ಎಡಗೈಯನ್ನು ಮನಸ್ಸೆಯ ತಲೆಯ ಮೇಲೆಯೂ ಇಟ್ಟನು. ಮನಸ್ಸೆಯು ಹಿರಿಯವನಾಗಿದ್ದರೂ, ಬೇಕೆಂದೇ ಅವನು ತನ್ನ ಕೈಗಳನ್ನು ಹಾಗೆ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ಆಗ ಅವನು ಯೋಸೇಫನನ್ನು ಹೀಗೆ ಆಶೀರ್ವದಿಸಿದನು, “ನನ್ನ ತಂದೆ ಅಬ್ರಹಾಮನೂ ಇಸಾಕನೂ ಯಾವ ದೇವರ ಮುಂದೆ ನಡೆದುಕೊಂಡರೋ, ಆ ದೇವರೇ ನಾನು ಹುಟ್ಟಿದಂದಿನಿಂದ ಇಂದಿನವರೆಗೆ ನನಗೆ ಕುರುಬ ಆಗಿದ್ದ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ಎಲ್ಲಾ ಕೇಡಿನಿಂದ ನನ್ನನ್ನು ತಪ್ಪಿಸಿದ ಆ ದೇವರ ದೂತ, ಈ ಹುಡುಗರನ್ನು ಆಶೀರ್ವದಿಸಲಿ. ನನ್ನ ಹೆಸರಿನಿಂದಲೂ, ನನ್ನ ಪಿತೃಗಳಾದ ಅಬ್ರಹಾಮ, ಇಸಾಕರ ಹೆಸರಿನಿಂದಲೂ ಅವರು ಮುಂದುವರೆಯಲಿ. ಭೂಮಿಯ ಮೇಲೆ ಸಮೂಹವಾಗಿ ಹೆಚ್ಚಲಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ತನ್ನ ತಂದೆಯು ಎಫ್ರಾಯೀಮನ ತಲೆಯ ಮೇಲೆ ಬಲಗೈಯನ್ನು ಇಟ್ಟದ್ದನ್ನು ಯೋಸೇಫನು ಕಂಡಾಗ, ಅದು ಅವನಿಗೆ ಇಷ್ಟವಾಗಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಅವನು ತನ್ನ ತಂದೆಯ ಕೈಯನ್ನು ಹಿಡಿದು, ಎಫ್ರಾಯೀಮನ ತಲೆಯ ಮೇಲಿಂದ ತೆಗೆದು, ಮನಸ್ಸೆಯ ತಲೆಯ ಮೇಲೆ ಇಡುವುದರಲ್ಲಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೆ, “ಅಪ್ಪಾ, ಹಾಗಲ್ಲ, ಇವನೇ ಜೇಷ್ಠಪುತ್ರನು. ಇವನ ತಲೆಯ ಮೇಲೆ ಬಲಗೈ ಇಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ಅದಕ್ಕೆ ಅವನ ತಂದೆಯು ಒಪ್ಪದೆ, “ನನಗೆ ಗೊತ್ತು. ನನ್ನ ಮಗನೇ, ನನಗೆ ತಿಳಿಯಿತು. ಅವನು ಸಹ ಜನಾಂಗವಾಗುವುದಲ್ಲದೆ ಅವನು ದೊಡ್ಡವನಾಗುವನು. ಆದರೂ ಅವನ ತಮ್ಮನು ನಿಶ್ಚಯವಾಗಿ ಅವನಿಗಿಂತ ದೊಡ್ಡವನಾಗುವನು. ಅವನ ಸಂತತಿಯು ಜನಾಂಗಗಳ ಸಮೂಹವಾಗುವುದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ಹೀಗೆ ಅವನು ಅವರನ್ನು ಆ ದಿನದಲ್ಲಿ ಆಶೀರ್ವದಿಸಿ, ಹೀಗೆಂದನು: “ನಿಮ್ಮ ಹೆಸರಿನಲ್ಲಿ ಇಸ್ರಾಯೇಲರು ಈ ಆಶೀರ್ವಾದವನ್ನು ಹೇಳುವರು: ‘ಎಫ್ರಾಯೀಮ್ ಮನಸ್ಸೆಯರ ಹಾಗೆ ದೇವರು ನಿನ್ನನ್ನು ಮಾಡಲಿ.’ ” ಹೀಗೆ ಹೇಳುತ್ತಾ ಯಾಕೋಬನು ಎಫ್ರಾಯೀಮನಿಗೆ ಮನಸ್ಸೆಗಿಂತಲೂ ಉನ್ನತಸ್ಥಾನವನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ಆಗ ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನಿಗೆ, “ನಾನು ಸಾಯುತ್ತೇನೆ, ಆದರೆ ದೇವರು ನಿಮ್ಮ ಸಂಗಡವಿದ್ದು, ನಿಮ್ಮನ್ನು ನಿಮ್ಮ ಪಿತೃಗಳ ದೇಶಕ್ಕೆ ಮತ್ತೆ ಸೇರಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ಇದಲ್ಲದೆ ನಾನು ನನ್ನ ಖಡ್ಗದಿಂದಲೂ ಬಿಲ್ಲಿನಿಂದಲೂ ಅಮೋರಿಯರ ಕೈಯಿಂದ ತೆಗೆದುಕೊಂಡ ಒಂದು ಹೊಲವನ್ನು ನಿನ್ನ ಸಹೋದರರಿಗಿಂತ ಹೆಚ್ಚಾಗಿ ನಿನಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ಆಗ ಯಾಕೋಬನು ತನ್ನ ಪುತ್ರರನ್ನು ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನೀವೆಲ್ಲರೂ ಕೂಡಿಬನ್ನಿರಿ. ಅಂತ್ಯ ದಿನಗಳಲ್ಲಿ ನಿಮಗೆ ಸಂಭವಿಸುವುದನ್ನು ನಿಮಗೆ ತಿಳಿಸುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“ಯಾಕೋಬನ ಪುತ್ರರೇ, ನೀವು ಒಟ್ಟಿಗೆ ಕೂಡಿಕೊಂಡು ಕೇಳಿರಿ, ನಿಮ್ಮ ತಂದೆ ಇಸ್ರಾಯೇಲನ ಮಾತಿಗೆ ಕಿವಿಗೊಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“ರೂಬೇನನೇ, ನೀನು ನನ್ನ ಜೇಷ್ಠಪುತ್ರನು. ನನ್ನ ಶಕ್ತಿ, ನನ್ನ ಬಲದ ಸಂಕೇತವೂ, ಗೌರವದಲ್ಲಿ ಶಕ್ತಿಯಲ್ಲಿ ಮಿತಿಮೀರಿದವನೂ ಆಗಿರುವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ನೀರಿನಂತೆ ಚಂಚಲನಾಗಿದ್ದು, ನೀನು ಶ್ರೇಷ್ಠನಾಗುವುದಿಲ್ಲ. ಏಕೆಂದರೆ ನಿನ್ನ ತಂದೆಯ ಮಂಚವನ್ನೇರಿ ಹೊಲೆಮಾಡಿದೆ, ನನ್ನ ಹಾಸಿಗೆಯನ್ನು ಏರಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“ಸಿಮೆಯೋನನೂ ಲೇವಿಯೂ ಸಹೋದರರು ಹಿಂಸಾಚಾರದ ಆಯುಧಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ನನ್ನ ಮನವೇ, ಅವರ ಆಲೋಚನೆಗೆ ಒಳಪಡಬೇಡ. ನನ್ನ ಪ್ರಾಣವೇ, ಅವರ ಕೂಟಗಳಲ್ಲಿ ಸೇರಬೇಡ. ಅವರು ತಮ್ಮ ಕೋಪದಲ್ಲಿ ಮನುಷ್ಯರನ್ನು ಕೊಂದರು, ಮದದಿಂದ ಎತ್ತುಗಳನ್ನು ಊನಪಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ಅವರ ಕೋಪವು ಭಯಂಕರವಾಗಿಯೂ ಅವರ ರೌದ್ರವು ಕ್ರೂರವಾಗಿಯೂ ಇದ್ದು, ಅದಕ್ಕೆ ಶಾಪಗ್ರಸ್ತವಾಗಲಿ. ಯಾಕೋಬನ ಕುಟುಂಬದಲ್ಲಿ ಅವರನ್ನು ವಿಭಾಗಿಸಿ ಇಸ್ರಾಯೇಲಿನಲ್ಲಿ ಅವರನ್ನು ಚದರಿಸಿಬಿಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“ಯೆಹೂದನೇ, ನಿನ್ನ ಸಹೋದರರು ನಿನ್ನನ್ನು ಹೊಗಳುವರು. ನಿನ್ನ ಕೈ ನಿನ್ನ ಶತ್ರುಗಳ ಕುತ್ತಿಗೆಯ ಮೇಲಿರುವುದು. ನಿನ್ನ ತಂದೆಯ ಮಕ್ಕಳು ನಿನಗೆ ಅಡ್ಡಬೀಳುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ಯೆಹೂದನು ಸಿಂಹದ ಮರಿಯಾಗಿದ್ದಾನೆ. ನನ್ನ ಮಗನೇ, ಬೇಟೆಹಿಡಿದು ಮೇಲಕ್ಕೆ ಬಂದೆ. ಅವನು ಸಿಂಹದಂತೆಯೂ ಪ್ರಾಯದ ಸಿಂಹದ ಹಾಗೆಯೂ ಮುದುರಿಕೊಂಡು ಮಲಗಿದ್ದಾನೆ. ಅವನನ್ನು ಕೆಣಕುವವರು ಯಾರು? ");
INSERT INTO kanokcv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ರಾಜದಂಡವನ್ನು ಹಿಡಿಯತಕ್ಕವನು ಶೀಲೋವಿನಿಂದ ಬರುವ ತನಕ, ಯೆಹೂದನ ಕೈಯಿಂದ ರಾಜದಂಡವಾಗಲೀ, ಆಡಳಿತಗಾರನ ಅಧಿಕಾರವಾಗಲೀ ಬಿಟ್ಟು ಹೋಗುವುದಿಲ್ಲ. ಎಲ್ಲಾ ಜನಾಂಗಗಳು ಅವನಿಗೆ ವಿಧೇಯವಾಗುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ಅವನು ತನ್ನ ವಾಹನ ಪಶುವನ್ನು ದ್ರಾಕ್ಷಾಲತೆಗೆ ಕಟ್ಟುವನು. ರಾಜದ್ರಾಕ್ಷೆಗೆ ತನ್ನ ಕತ್ತೆಯನ್ನು ಬಿಗಿಯುವನು. ದ್ರಾಕ್ಷಾರಸದಲ್ಲಿ ತನ್ನ ಬಟ್ಟೆ ಒಗೆಯುವನು, ದ್ರಾಕ್ಷಾರಸದಲ್ಲಿಯೇ ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ಅದ್ದಿ ತೊಳೆಯುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ದ್ರಾಕ್ಷಾರಸದಿಂದ ಅವನ ಕಣ್ಣುಗಳು ಕೆಂಪಾಗಿರುವವು, ಹಾಲಿನಿಂದ ಅವನ ಹಲ್ಲುಗಳು ಬಿಳುಪಾಗಿರುವವು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“ಜೆಬುಲೂನನು ಸಮುದ್ರದ ಕರಾವಳಿಯಲ್ಲಿ ವಾಸಿಸುವನು, ಅವನಿಗೆ ಹಡಗುಗಳು ಸೇರುವ ರೇವೂ ಇರುವುದು. ಅವನ ಮೇರೆಯು ಸೀದೋನಿಗೆ ಮುಟ್ಟುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ಇಸ್ಸಾಕಾರನು ಕುರಿಯ ಹಟ್ಟಿಗಳ ನಡುವೆ ಮಲಗಿಕೊಳ್ಳುವ ಬಲವುಳ್ಳ ಕತ್ತೆಯಾಗಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ವಿಶ್ರಾಂತಿಯು ಒಳ್ಳೆಯದೆಂದೂ ದೇಶವು ರಮ್ಯವೆಂದೂ ನೋಡಿ ಹೊರೆ ಹೊರುವುದಕ್ಕೆ ತನ್ನ ಹೆಗಲನ್ನು ಬಗ್ಗಿಸಿ ಬಿಟ್ಟಿಯ ಕೆಲಸ ಮಾಡುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ದಾನನು ಇಸ್ರಾಯೇಲನ ಗೋತ್ರಗಳಲ್ಲಿ ಒಂದು ಗೋತ್ರವಾಗಿ ತನ್ನ ಜನರಿಗೆ ನ್ಯಾಯತೀರಿಸುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ದಾನನು ಮಾರ್ಗದಲ್ಲಿರುವ ಸರ್ಪವೂ ದಾರಿಯಲ್ಲಿರುವ ಹಾವೂ ಆಗಿರುವನು. ಕುದುರೆಯ ಹಿಮ್ಮಡಿಯನ್ನು ಕಚ್ಚಿದರೆ, ಹತ್ತಿದವನು ಬೋರಲು ಬೀಳುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“ಯೆಹೋವ ದೇವರೇ, ನಿಮ್ಮ ವಿಮೋಚನೆಗಾಗಿ ಕಾಯುತ್ತಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“ಗಾದನ ಮೇಲೆ ಸೈನ್ಯವು ದಾಳಿಮಾಡುವುದು, ಕೊನೆಗೆ ಅವನೇ ಅವರನ್ನು ಓಡಿಸಿಬಿಡುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“ಆಶೇರನ ಆಹಾರವು ಕೊಬ್ಬಿದ ಆಹಾರವು. ಅವನು ಅರಸನಿಗೆ ಸವಿಯೂಟವನ್ನು ಕೊಡುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“ನಫ್ತಾಲಿ ಬಿಡುಗಡೆ ಹೊಂದಿದ ಜಿಂಕೆ, ಅವನು ಮಾತುಗಳು ಸುಂದರ ಮಕ್ಕಳ ಮಾತುಗಳಂತೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“ಯೋಸೇಫನು ಫಲಭರಿತವಾದ ದ್ರಾಕ್ಷಿಬಳ್ಳಿ ಕಾಲುವೆಗಳ ಬಳಿಯಲ್ಲಿರುವ ಫಲಭರಿತ ದ್ರಾಕ್ಷಿಬಳ್ಳಿ, ಅದರ ಕೊಂಬೆಗಳು ಗೋಡೆಗಳನ್ನೇರುತ್ತವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ಸಿಟ್ಟಿನಿಂದ ಬಿಲ್ಲುಗಾರರು ಅವನ ಮೇಲೆ ಬೀಳುವರು. ವಿರೋಧದಿಂದ ಅವನ ಮೇಲೆ ಬಾಣಗಳನ್ನು ಎಸೆಯುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ಆದರೆ ಅವನ ಬಿಲ್ಲು ಸ್ಥಿರವಾಗಿ ನಿಲ್ಲುವುದು. ಅವನ ಬಲವಾದ ತೋಳುಗಳು ಚುರುಕಾಗಿ ನಿಂತವು. ಇದಕ್ಕೆ ಕಾರಣ ಯಾಕೋಬನಿಗೆ ಸರ್ವಶಕ್ತರಾಗಿರುವ ದೇವರ ಹಸ್ತವೇ; ಇದಕ್ಕೆ ಕಾರಣ ಇಸ್ರಾಯೇಲನ ಬಂಡೆಯಾಗಿರುವ ಕುರುಬ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ಇದಕ್ಕೆ ಕಾರಣ ನಿನಗೆ ಸಹಾಯ ಮಾಡುವ ನಿನ್ನ ಪಿತೃಗಳ ದೇವರು; ನಿನ್ನನ್ನು ಸರ್ವಶಕ್ತರಾದ ದೇವರು ಆಶೀರ್ವದಿಸಲಿ. ಆ ಆಶೀರ್ವಾದಗಳು ಪರಲೋಕದವುಗಳು. ಆ ಆಶೀರ್ವಾದಗಳು ಕೆಳಗಿನಾಳದಲ್ಲಿರುವವುಗಳು. ಅವು ಎದೆಯ ಹಾಗೂ ಗರ್ಭದ ಆಶೀರ್ವಾದಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ಪುರಾತನ ಪರ್ವತಗಳ ಆಶೀರ್ವಾದಗಳಿಗಿಂತ ನಿನ್ನ ತಂದೆಯ ಆಶೀರ್ವಾದಗಳು ಶ್ರೇಷ್ಠವಾದವುಗಳು. ಅವು ಪುರಾತನ ಶಿಖರಗಳ ಐಶ್ವರ್ಯಕ್ಕಿಂತ ಹೆಚ್ಚಿನವುಗಳು. ಇವೆಲ್ಲವೂ ಯೋಸೇಫನ ತಲೆಯ ಮೇಲೆ ಅಂದರೆ, ತನ್ನ ಸಹೋದರರಲ್ಲಿ ರಾಜಕುಮಾರನಾದವನ ಹಣೆಯ ಮೇಲಿರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“ಬೆನ್ಯಾಮೀನನು ಕ್ರೂರವಾದ ತೋಳದಂತಿದ್ದಾನೆ. ಬೆಳಿಗ್ಗೆ ತಿನ್ನುತ್ತಾನೆ, ಸಂಜೆ ಕೊಳ್ಳೆಯನ್ನು ಹಂಚಿಕೊಳ್ಳುತ್ತಾನೆ.” ");
INSERT INTO kanokcv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ಇವರೆಲ್ಲಾ ಇಸ್ರಾಯೇಲಿನ ಹನ್ನೆರಡು ಗೋತ್ರಗಳು. ಅವರ ತಂದೆ ಅವರಿಗೆ ಹೇಳಿದ್ದೂ ಇದೇ. ಅವನು ಒಬ್ಬೊಬ್ಬನನ್ನೂ ಅವನಿಗೆ ತಕ್ಕ ಆಶೀರ್ವಾದದ ಪ್ರಕಾರ ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ಅವನು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನಾನು ನನ್ನ ಜನರೊಂದಿಗೆ ಸೇರಿಕೊಳ್ಳುತ್ತೇನೆ. ನನ್ನ ಪಿತೃಗಳ ಸಂಗಡ ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನನ ಹೊಲದಲ್ಲಿರುವ ಗವಿಯಲ್ಲಿ ");
INSERT INTO kanokcv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಮಮ್ರೆಗೆ ಎದುರಾಗಿ ಮಕ್ಪೇಲ ಹೊಲದಲ್ಲಿರುವಂಥ ಅಬ್ರಹಾಮನು, ಹೊಲದ ಸಂಗಡ ಸ್ವಂತ ಸಮಾಧಿಗೋಸ್ಕರ ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನನಿಂದ ಕೊಂಡುಕೊಂಡಂಥ ಗವಿಯಲ್ಲಿ ನನ್ನನ್ನು ಹೂಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ಅಲ್ಲಿ ಅಬ್ರಹಾಮನನ್ನೂ, ಅವನ ಹೆಂಡತಿ ಸಾರಳನ್ನೂ ಹೂಳಿದರು. ಅಲ್ಲಿ ಇಸಾಕನನ್ನೂ, ಅವನ ಹೆಂಡತಿ ರೆಬೆಕ್ಕಳನ್ನೂ ಹೂಳಿಟ್ಟರು. ಅಲ್ಲಿ ನಾನು ಲೇಯಳನ್ನೂ ಹೂಳಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ಆ ಹೊಲವೂ, ಅದರಲ್ಲಿರುವ ಗವಿಯೂ ಹಿತ್ತಿಯರಿಂದ ಕೊಂಡುಕೊಂಡದ್ದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ಯಾಕೋಬನು ತನ್ನ ಪುತ್ರರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ ತರುವಾಯ, ತನ್ನ ಕಾಲುಗಳನ್ನು ಮಂಚದ ಮೇಲೆ ಮುದುರಿಕೊಂಡನು. ಅವನು ಪ್ರಾಣ ಬಿಟ್ಟು ತನ್ನ ಪಿತೃಗಳೊಂದಿಗೆ ಸೇರಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ಆಗ ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯ ಶವದ ಮೇಲೆ ಬಿದ್ದು, ಅವನಿಗಾಗಿ ಕಣ್ಣೀರು ಸುರಿಸುತ್ತಾ ಅವನಿಗೆ ಮುದ್ದಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ಯೋಸೇಫನು ತನ್ನ ತಂದೆ ಇಸ್ರಾಯೇಲನಿಗೆ ಸುಗಂಧದ್ರವ್ಯವನ್ನು ಹಾಕಬೇಕೆಂದು ತನ್ನ ದಾಸರಾದ ವೈದ್ಯರಿಗೆ ಅಪ್ಪಣೆಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ವೈದ್ಯರು ಇಸ್ರಾಯೇಲನಿಗೆ ನಲವತ್ತು ದಿನಗಳವರೆಗೆ ಸುಗಂಧದ್ರವ್ಯಗಳ ಲೇಪನ ಮಾಡಿದರು. ಅದಕ್ಕಾಗಿ ಅಷ್ಟು ಸಮಯ ಬೇಕಾಗಿತ್ತು. ಇದಲ್ಲದೆ ಈಜಿಪ್ಟಿನವರು ಅವನಿಗಾಗಿ ಎಪ್ಪತ್ತು ದಿವಸ ದುಃಖಪಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ಅವನಿಗಾಗಿ ದುಃಖಿಸುವ ದಿನಗಳು ಮುಗಿದ ಮೇಲೆ ಯೋಸೇಫನು ಫರೋಹನ ಆಸ್ಥಾನದವರಿಗೆ, “ನಾನು ನಿಮ್ಮ ಕಣ್ಣುಗಳ ಮುಂದೆ ದಯೆ ಹೊಂದಿದ್ದೇಯಾದರೆ, ಫರೋಹನ ಕಿವಿಗಳಲ್ಲಿ ಈ ಮಾತು ಹೇಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘ನನಗೆ ನನ್ನ ತಂದೆ, “ನಾನು ಸಾಯುತ್ತೇನೆ, ನಾನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ನನಗೋಸ್ಕರ ಅಗೆದ ನನ್ನ ಸಮಾಧಿಯಲ್ಲಿಯೇ ನನ್ನನ್ನು ಸಮಾಧಿಮಾಡಬೇಕು,” ಎಂದು ನನ್ನಿಂದ ಪ್ರಮಾಣ ಮಾಡಿಸಿದ್ದಾನೆ.’ ಹೀಗಿರುವುದರಿಂದ ನಾನು ಹೋಗಿ ನನ್ನ ತಂದೆಯನ್ನು ಹೂಳಿ, ತಿರುಗಿ ಬರುವ ಹಾಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ಆಗ ಫರೋಹನು, “ನಿನ್ನ ತಂದೆಯು ನಿನ್ನಿಂದ ಪ್ರಮಾಣ ಮಾಡಿಸಿದಂತೆ, ನೀನು ಹೋಗಿ ನಿನ್ನ ತಂದೆಯನ್ನು ಹೂಳಿಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ಹೀಗೆ ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯನ್ನು ಸಮಾಧಿಮಾಡುವದಕ್ಕೆ ಹೊರಟುಹೋದನು. ಅವನ ಸಂಗಡ ಫರೋಹನ ದಾಸರೆಲ್ಲರೂ ಅರಮನೆಯ ಹಿರಿಯರೆಲ್ಲರೂ ಈಜಿಪ್ಟ್ ದೇಶದ ಮುಖ್ಯಸ್ಥರೆಲ್ಲರೂ, ");
INSERT INTO kanokcv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ಯೋಸೇಫನ ಮನೆಯವರೆಲ್ಲರೂ ಅವನ ಸಹೋದರರೂ ಅವನ ತಂದೆಯ ಮನೆಯವರೆಲ್ಲರೂ ಹೋದರು. ಅವರ ಮಕ್ಕಳನ್ನೂ, ಕುರಿದನಗಳನ್ನೂ ಮಾತ್ರ ಗೋಷೆನ್ ಪ್ರಾಂತದಲ್ಲಿ ಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ರಥಗಳೂ, ರಾಹುತರೂ ಅವನ ಸಂಗಡ ಹೊರಟು ಹೋದರು. ಸಮೂಹವು ಬಹಳ ದೊಡ್ಡದಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ಅವರು ಯೊರ್ದನಿನ ಆಚೆ ಇರುವ ಆಟಾದ್ ಕಣಕ್ಕೆ ಬಂದಾಗ, ಅಲ್ಲಿ ಅಧಿಕವಾದ ಮತ್ತು ಮಹಾ ಘೋರವಾದ ಗೋಳಾಟದಿಂದ ದುಃಖಪಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ದೇಶದ ನಿವಾಸಿಗಳಾದ ಕಾನಾನ್ಯರು ಆಟಾದ್ ಕಣದಲ್ಲಿ ಆಗುತ್ತಿದ್ದ ದುಃಖವನ್ನು ಕಂಡಾಗ, “ಇದು ಈಜಿಪ್ಟಿನವರಿಗೆ ಘೋರವಾದ ದುಃಖ,” ಎಂದು ಹೇಳಿದರು. ಆದ್ದರಿಂದ ಅದಕ್ಕೆ ಆಬೇಲ್ ಮಿಚ್ರಯೀಮ್ ಎಂದು ಹೆಸರಾಯಿತು. ಅದು ಯೊರ್ದನಿನ ಆಚೆ ಇದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ಯಾಕೋಬನು ತನ್ನ ಪುತ್ರರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಅವನಿಗೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ಅವನ ಪುತ್ರರು ಅವನನ್ನು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ತೆಗೆದುಕೊಂಡುಹೋಗಿ, ಅಬ್ರಹಾಮನು ಸ್ವಂತ ಸಮಾಧಿಗೋಸ್ಕರ ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನಿನಿಂದ ಕೊಂಡುಕೊಂಡಿದ್ದ ಮಮ್ರೆಗೆ ಎದುರಾಗಿರುವಂಥ ಮಕ್ಪೇಲ ಹೊಲದ ಗವಿಯಲ್ಲಿ ಹೂಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯನ್ನು ಹೂಳಿದ ಮೇಲೆ, ತನ್ನ ಸಹೋದರರ ಸಂಗಡವೂ, ತನ್ನ ತಂದೆಯನ್ನು ಹೂಳುವುದಕ್ಕಾಗಿ ಅವನ ಸಂಗಡ ಹೋದವರೆಲ್ಲರೂ ಈಜಿಪ್ಟಿಗೆ ತಿರುಗಿ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ತಮ್ಮ ತಂದೆ ಸತ್ತು ಹೋದ ಮೇಲೆ ಯೋಸೇಫನ ಸಹೋದರರು, “ಒಂದು ವೇಳೆ ಯೋಸೇಫನು ನಮ್ಮನ್ನು ಹಗೆಮಾಡಿ, ನಾವು ಅವನಿಗೆ ಮಾಡಿದ್ದ ಎಲ್ಲಾ ಕೇಡಿಗಾಗಿ ನಿಶ್ಚಯವಾಗಿ ಪ್ರತೀಕಾರಮಾಡಬಹುದು,” ಎಂದುಕೊಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ಅವರು ಒಬ್ಬ ಸೇವಕನನ್ನು ಕಳುಹಿಸಿ ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ತಂದೆಯು ಮರಣ ಹೊಂದುವುದಕ್ಕಿಂತ ಮುಂಚೆ, ");
INSERT INTO kanokcv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘ನಿನ್ನ ಸಹೋದರರ ಅಪರಾಧವನ್ನೂ ಅವರ ಪಾಪವನ್ನೂ ಮನ್ನಿಸು,’ ಎಂಬುದಾಗಿ ಯೋಸೇಫನಿಗೆ ಹೇಳಿರಿ, ಎಂದು ತಿಳಿಸಿದ್ದಾನೆ. ಹೀಗಿರುವುದರಿಂದ ನಿನ್ನ ತಂದೆಯ ದೇವರ ದಾಸರಾದ ನಾವು ಮಾಡಿದ ಅಪರಾಧವನ್ನು ದಯಮಾಡಿ ಕ್ಷಮಿಸು,” ಎಂದು ತಿಳಿಸಿದರು. ಈ ಸಂದೇಶ ಅವನಿಗೆ ಬಂದಾಗ, ಅವನು ಅತ್ತನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ಆಮೇಲೆ ಅವನ ಸಹೋದರರು ಬಂದು ಅವನ ಮುಂದೆ ಅಡ್ಡಬಿದ್ದು, “ನಿನ್ನ ದಾಸರಾಗಿದ್ದೇವೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ಯೋಸೇಫನು ಅವರಿಗೆ, “ಭಯಪಡಬೇಡಿರಿ, ನಾನು ದೇವರ ಸ್ಥಾನದಲ್ಲಿ ಇದ್ದೇನೋ? ");
INSERT INTO kanokcv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ನೀವು ನನಗೆ ವಿರೋಧವಾಗಿ ಕೇಡನ್ನು ಕಲ್ಪಿಸಿದ್ದೀರಿ, ಆದರೆ ದೇವರು ಒಳ್ಳೆಯದಕ್ಕಾಗಿಯೇ ಸಂಕಲ್ಪಿಸಿದರು. ಈಗ ಬಹುಜನರ ಪ್ರಾಣ ಉಳಿಯುವಂತೆ ನಡೆಯುತ್ತಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ಹೀಗಿರುವುದರಿಂದ ನೀವು ಭಯಪಡಬೇಡಿರಿ. ನಾನು ನಿಮ್ಮನ್ನೂ, ನಿಮ್ಮ ಮಕ್ಕಳನ್ನೂ ಸಂರಕ್ಷಿಸುತ್ತೇನೆ,” ಎಂದು ಹೇಳಿ, ಅವರನ್ನು ಸಂತೈಸಿ, ದಯೆಯಿಂದ ಮಾತನಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ಹೀಗೆ ಯೋಸೇಫನೂ, ಅವನ ತಂದೆಯ ಮನೆಯವರೂ ಸಹಿತವಾಗಿ ಈಜಿಪ್ಟಿನಲ್ಲಿ ವಾಸಮಾಡಿದರು. ಯೋಸೇಫನು ನೂರಹತ್ತು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ಯೋಸೇಫನು ಎಫ್ರಾಯೀಮನ ಮರಿಮೊಮ್ಮಕ್ಕಳನ್ನೂ ಕಂಡನು. ಮನಸ್ಸೆಯ ಮಗ ಮಾಕೀರನ ಮಕ್ಕಳೂ ಸಹ ಯೋಸೇಫನ ತೊಡೆಯ ಮೇಲೆಯೇ ಬೆಳೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ಇದಲ್ಲದೆ ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರಿಗೆ, “ನಾನು ಸತ್ತಮೇಲೆ ದೇವರು ನಿಶ್ಚಯವಾಗಿ ನಿಮ್ಮನ್ನು ಕಾಪಾಡಿ, ಈ ದೇಶದೊಳಗಿಂದ ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೋಬರಿಗೆ ಪ್ರಮಾಣ ಮಾಡಿದ ದೇಶಕ್ಕೆ ಸೇರುವಂತೆ ಮಾಡುವರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ಯೋಸೇಫನು ಇಸ್ರಾಯೇಲನ ಮಕ್ಕಳಿಗೆ, “ದೇವರು ನಿಶ್ಚಯವಾಗಿ ನಿಮಗೆ ಸಹಾಯ ಮಾಡುವರು. ಆಗ ನನ್ನ ಎಲುಬುಗಳನ್ನು ಇಲ್ಲಿಂದ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು,” ಎಂದು ಪ್ರಮಾಣ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ಯೋಸೇಫನು ನೂರಹತ್ತು ವರ್ಷದವನಾಗಿ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಸತ್ತನು. ಅವರು ಅವನಿಗೆ ಸುಗಂಧದ್ರವ್ಯವನ್ನು ಹಾಕಿ, ಈಜಿಪ್ಟಿನಲ್ಲಿ ಪೆಟ್ಟಿಗೆಯೊಳಗೆ ಇಟ್ಟರು.");
INSERT INTO kanokcv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ಯಾಕೋಬನೊಂದಿಗೆ ಈಜಿಪ್ಟಿಗೆ ತಮ್ಮ ತಮ್ಮ ಮನೆಯವರ ಸಂಗಡ ಬಂದ ಇಸ್ರಾಯೇಲನ ಮಕ್ಕಳ ಹೆಸರುಗಳು: ");
INSERT INTO kanokcv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ರೂಬೇನ್, ಸಿಮೆಯೋನ್, ಲೇವಿ ಮತ್ತು ಯೆಹೂದ, ");
INSERT INTO kanokcv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ಇಸ್ಸಾಕಾರ್ ಜೆಬುಲೂನ್ ಮತ್ತು ಬೆನ್ಯಾಮೀನ್, ");
INSERT INTO kanokcv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ದಾನ್, ನಫ್ತಾಲಿ, ಗಾದ್ ಮತ್ತು ಆಶೇರ್. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ಯಾಕೋಬನ ವಂಶಜರು ಒಟ್ಟು ಎಪ್ಪತ್ತು ಮಂದಿ ಆದರೆ ಯೋಸೇಫನು ಮೊದಲೇ ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ಹಲವು ವರ್ಷಗಳ ಬಳಿಕ ಯೋಸೇಫನೂ ಅವನ ಸಹೋದರರೆಲ್ಲರೂ ಆ ಸಂತತಿಯವರೆಲ್ಲರೂ ಸತ್ತರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ಆದರೆ ಇಸ್ರಾಯೇಲರ ಮಕ್ಕಳು ಅತ್ಯಧಿಕವಾಗಿ ಅಭಿವೃದ್ಧಿಯಾಗಿ ಹೆಚ್ಚಿನ ಸಂಖ್ಯೆಯಲ್ಲಿ ಹರಡಿಕೊಂಡು ಬಲಗೊಂಡರು, ಅದರಿಂದ ಆ ದೇಶವು ಅವರಿಂದ ತುಂಬಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ತರುವಾಯ ಯೋಸೇಫನನ್ನೇ ಅರಿಯದ ಬೇರೊಬ್ಬ ಅರಸನು, ಈಜಿಪ್ಟಿನಲ್ಲಿ ಅಧಿಕಾರಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ಅವನು ತನ್ನ ಜನರಿಗೆ, “ಇಸ್ರಾಯೇಲರು ನಮಗಿಂತ ಹೆಚ್ಚಿನ ಸಂಖ್ಯೆಯಲ್ಲಿದ್ದಾರೆ ಮತ್ತು ಹೆಚ್ಚು ಬಲವುಳ್ಳವರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ನಮಗೆ ಯುದ್ಧ ಸಂಭವಿಸಿದರೆ ಅವರು ನಮ್ಮ ಶತ್ರುಗಳ ಸಂಗಡ ಕೂಡಿಕೊಂಡು, ನಮಗೆ ವಿರೋಧವಾಗಿ ಯುದ್ಧಮಾಡಿ, ದೇಶವನ್ನು ಬಿಟ್ಟು ಹೋಗಬಹುದು ಆದ್ದರಿಂದ ಅವರು ವೃದ್ಧಿಯಾಗದಂತೆ ಅವರೊಂದಿಗೆ ಬುದ್ಧಿವಂತಿಕೆಯಿಂದ ನಾವು ವರ್ತಿಸೋಣ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ಆಗ ಅವರನ್ನು ಬಿಟ್ಟೀ ಕೆಲಸಗಳಿಂದ ಶ್ರಮಪಡಿಸುವುದಕ್ಕಾಗಿ, ಬಿಟ್ಟೀ ಕೆಲಸಮಾಡಿಸುವ ಅಧಿಕಾರಿಗಳನ್ನು ಅವರ ಮೇಲೆ ನೇಮಿಸಿದರು. ಅವರು ಫರೋಹನಿಗೆ ಪಿತೋಮ್ ಮತ್ತು ರಮ್ಸೇಸ್ ಎಂಬ ಉಗ್ರಾಣ ಪಟ್ಟಣಗಳನ್ನು ಕಟ್ಟಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ಆದರೆ ಈಜಿಪ್ಟನವರು ಅವರನ್ನು ಎಷ್ಟು ಶ್ರಮಪಡಿಸಿದರೋ, ಅಷ್ಟು ಅಧಿಕವಾಗಿ ಅವರು ಹೆಚ್ಚಿ ಹರಡಿಕೊಂಡದ್ದರಿಂದ ಈಜಿಪ್ಟಿನವರು ಇಸ್ರಾಯೇಲರ ಬಗ್ಗೆ ಹೆದರಿದವರಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ಆದ್ದರಿಂದ ಈಜಿಪ್ಟಿನವರು ಇಸ್ರಾಯೇಲರನ್ನು ಕ್ರೂರವಾಗಿ ನಡೆಸಿಕೊಳ್ಳುತ್ತಾ ಸೇವೆ ಮಾಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ಮಣ್ಣು ಅಗೆಯುವ, ಇಟ್ಟಿಗೆಯನ್ನು ಮಾಡುವ ಮತ್ತು ವ್ಯವಸಾಯದ ಎಲ್ಲಾ ವಿಧವಾದ ಕೆಲಸಗಳಲ್ಲಿಯೂ ಕಠಿಣವಾಗಿ ದುಡಿಸಿಕೊಂಡು ಅವರ ಜೀವಿತವನ್ನೇ ಬೇಸರಪಡಿಸಿದರು. ಈಜಿಪ್ಟಿನವರು ಅವರಿಂದ ಮಾಡಿಸಿದ ಎಲ್ಲಾ ಕೆಲಸವು ಕಠೋರವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ಈಜಿಪ್ಟಿನ ಅರಸನು ಶಿಪ್ರಾ ಮತ್ತು ಪೂಗಾ ಎಂದು ಹೆಸರಿದ್ದ ಹಿಬ್ರಿಯ ಸೂಲಗಿತ್ತಿಯರ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ಅವರಿಗೆ, “ನೀವು ಹಿಬ್ರಿಯ ಸ್ತ್ರೀಯರಿಗೆ ಸೂಲಗಿತ್ತಿಯ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೆ ಹೆರಿಗೆಯ ಸಮಯದಲ್ಲಿ ಅವರನ್ನು ಪರಾಂಬರಿಸುವಾಗ, ಗಂಡು ಮಗುವಾದರೆ ಅದನ್ನು ಕೊಂದುಹಾಕಿರಿ, ಹೆಣ್ಣಾದರೆ ಬದುಕಲಿ,” ಎಂದು ಹೇಳಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ಆದರೆ ಸೂಲಗಿತ್ತಿಯರು ದೇವರಿಗೆ ಭಯಪಟ್ಟು ಈಜಿಪ್ಟಿನ ಅರಸನು ತಮಗೆ ಹೇಳಿದಂತೆ ಮಾಡದೆ ಗಂಡು ಮಕ್ಕಳನ್ನು ಬದುಕಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ಆಗ ಈಜಿಪ್ಟಿನ ಅರಸನು ಸೂಲಗಿತ್ತಿಯರನ್ನು ಕರೆಯಿಸಿ, “ಏಕೆ ಗಂಡು ಮಕ್ಕಳನ್ನು ಬದುಕಿಸಿದ್ದೀರಿ? ಇಂಥ ಕೆಲಸವನ್ನು ಏಕೆ ಮಾಡಿದಿರಿ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ಸೂಲಗಿತ್ತಿಯರು ಫರೋಹನಿಗೆ, “ಹಿಬ್ರಿಯರ ಸ್ತ್ರೀಯರು ಈಜಿಪ್ಟಿನ ಸ್ತ್ರೀಯರಂತೆ ಅಲ್ಲ, ಅವರು ಚುರುಕಾಗಿದ್ದಾರೆ. ಸೂಲಗಿತ್ತಿಯರು ಅವರ ಹತ್ತಿರ ಬರುವುದಕ್ಕೆ ಮುಂಚೆಯೇ ಹೆರುತ್ತಾರೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ಆದ್ದರಿಂದ ದೇವರು ಸೂಲಗಿತ್ತಿಯರಿಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡಿದರು. ಇದಲ್ಲದೆ ಇಸ್ರಾಯೇಲರು ಸಂಖ್ಯೆಯಲ್ಲೂ ಹೆಚ್ಚಾಗಿ ಬಹು ಬಲಗೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ಸೂಲಗಿತ್ತಿಯರು ದೇವರಿಗೆ ಭಯಪಟ್ಟದ್ದರಿಂದ, ದೇವರು ಅವರ ಕುಟುಂಬಕ್ಕೆ ಅಭಿವೃದ್ಧಿಯನ್ನು ಉಂಟುಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ಆದರೆ ಫರೋಹನು ತನ್ನ ಎಲ್ಲಾ ಜನರಿಗೆ, “ಹುಟ್ಟುವ ಹಿಬ್ರಿಯರ ಗಂಡು ಮಕ್ಕಳನ್ನೆಲ್ಲಾ ನೈಲ್ ನದಿಯಲ್ಲಿ ಹಾಕಬೇಕು, ಹೆಣ್ಣುಮಕ್ಕಳನ್ನೆಲ್ಲಾ ಬದುಕಿಸಬೇಕು,” ಎಂದು ಅಪ್ಪಣೆಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ಈ ಸಮಯದಲ್ಲಿ ಲೇವಿಯ ವಂಶದವನಾದ ಒಬ್ಬನು ಲೇವಿಯ ಸ್ತ್ರೀಯನ್ನು ಮದುವೆಯಾದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ಆ ಸ್ತ್ರೀಯು ಗರ್ಭಧರಿಸಿ, ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತಳು. ಅದು ಸುಂದರವಾಗಿದ್ದುದರಿಂದ ಮೂರು ತಿಂಗಳು ಬಚ್ಚಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ಆದರೆ ಅದನ್ನು ಹೆಚ್ಚುಕಾಲ ಬಚ್ಚಿಡುವುದಕ್ಕಾಗದೆ ಇದ್ದಾಗ, ಅವನಿಗಾಗಿ ಆಪಿನ ಪೆಟ್ಟಿಗೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಜೇಡಿಮಣ್ಣನ್ನು ಮತ್ತು ರಾಳವನ್ನು ಹಚ್ಚಿ, ಕೂಸನ್ನು ಅದರಲ್ಲಿಟ್ಟು, ನೈಲ್ ನದಿಯ ಅಂಚಿನಲ್ಲಿ ಇದ್ದ ಜಂಬು ಹುಲ್ಲಿನಲ್ಲಿ ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ಕೂಸಿಗೆ ಏನಾಗುವುದೋ ಎಂದು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕೆ ದೂರದಲ್ಲಿ ಅದರ ಅಕ್ಕ ನಿಂತುಕೊಂಡಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ಆಗ ಫರೋಹನ ಮಗಳು ನೈಲ್ ನದಿಯಲ್ಲಿ ಸ್ನಾನ ಮಾಡುವದಕ್ಕೆ ಬಂದಳು. ಆಕೆಯ ದಾಸಿಯರು ನದಿಯ ಅಂಚಿನಲ್ಲಿ ತಿರುಗಾಡುತ್ತಿದ್ದರು. ಫರೋಹನ ಮಗಳು ಜಂಬು ಹುಲ್ಲಿನಲ್ಲಿದ್ದ ಪೆಟ್ಟಿಗೆಯನ್ನು ನೋಡಿ ತನ್ನ ದಾಸಿಯನ್ನು ಕಳುಹಿಸಿ, ಅದನ್ನು ತರಿಸಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ಆ ಪೆಟ್ಟಿಗೆಯನ್ನು ತೆರೆದಾಗ, ಕೂಸನ್ನು ನೋಡಿದಳು. ಕೂಸು ಅಳುತ್ತಿತ್ತು. ಆಕೆಗೆ ಅದರ ಮೇಲೆ ಕನಿಕರ ಹುಟ್ಟಿತು. ಅವಳು, “ಇದು ಹಿಬ್ರಿಯರ ಮಕ್ಕಳಲ್ಲಿ ಒಂದಾಗಿರಬೇಕು,” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ಆಗ ಮಗುವಿನ ಅಕ್ಕ ಫರೋಹನ ಮಗಳಿಗೆ, “ನಾನು ಹೋಗಿ ಈ ಕೂಸಿಗೆ ಹಾಲು ಕೊಟ್ಟು ಸಾಕುವುದಕ್ಕೆ ಹಿಬ್ರಿಯ ಸ್ತ್ರೀಯರಿಂದ ಒಬ್ಬ ದಾದಿಯನ್ನು ನಿನಗೋಸ್ಕರ ಕರೆದುಕೊಂಡು ಬರಲೋ?” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ಫರೋಹನ ಮಗಳು ಆಕೆಗೆ, “ಹೌದು, ಹೋಗು,” ಎಂದಳು. ಆಗ ಆ ಹುಡುಗಿಯು ಹೋಗಿ ಕೂಸಿನ ತಾಯಿಯನ್ನೇ ಕರೆದುಕೊಂಡು ಬಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ಫರೋಹನ ಮಗಳು ಆಕೆಗೆ, “ಈ ಮಗುವನ್ನು ತೆಗೆದುಕೊಂಡುಹೋಗಿ, ನನಗೋಸ್ಕರ ಸಾಕು. ನಾನು ನಿನಗೆ ಸಂಬಳವನ್ನು ಕೊಡುವೆನು,” ಎಂದಳು. ಆಗ ಆ ಸ್ತ್ರೀಯು ಕೂಸನ್ನು ತೆಗೆದುಕೊಂಡುಹೋಗಿ ಸಾಕಿದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ಆ ಮಗುವು ಬೆಳೆದಾಗ, ಅವನನ್ನು ಫರೋಹನ ಮಗಳ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋದಳು. ಅವನು ಆಕೆಗೆ ಮಗನಾದನು. ಆಕೆಯು, “ನೀರಿನೊಳಗಿಂದ ಇವನನ್ನು ಎಳೆದೆ,” ಎಂದು ಹೇಳಿ ಅವನಿಗೆ “ಮೋಶೆ” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ಹಲವು ವರ್ಷಗಳ ನಂತರ ಮೋಶೆಯು ದೊಡ್ಡವನಾದ ಮೇಲೆ ತನ್ನ ಸಹೋದರರ ಬಳಿಗೆ ಹೋಗಿ ಅವರ ಬಿಟ್ಟೀ ಕೆಲಸಗಳನ್ನು ನೋಡಿದಾಗ, ಒಬ್ಬ ಈಜಿಪ್ಟಿನವನು ತನ್ನ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬ ಹಿಬ್ರಿಯನನ್ನು ಹೊಡೆಯುವುದನ್ನು ನೋಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ಅವನು ಸುತ್ತಮುತ್ತ ನೋಡಿ, ಯಾರೂ ಇಲ್ಲವೆಂದು ತಿಳಿದು ಆ ಈಜಿಪ್ಟಿನವನನ್ನು ಕೊಂದುಹಾಕಿ, ಮರಳಿನಲ್ಲಿ ಮುಚ್ಚಿಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ಮರುದಿನ ಅವನು ಮತ್ತೆ ಹೊರಗೆ ಹೋದಾಗ, ಹಿಬ್ರಿಯರಾದ ಇಬ್ಬರು ಮನುಷ್ಯರು ಜಗಳವಾಡುತ್ತಿದ್ದರು. ತಪ್ಪು ಮಾಡಿದವನಿಗೆ ಮೋಶೆ, “ಏಕೆ ನಿನ್ನ ಜೊತೆಯವನನ್ನು ಹೊಡೆಯುತ್ತೀ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ಅದಕ್ಕವನು, “ಯಾರು ನಿನ್ನನ್ನು ನಮ್ಮ ಮೇಲೆ ಪ್ರಭುವನ್ನಾಗಿಯೂ ನ್ಯಾಯಾಧಿಪತಿಯನ್ನಾಗಿಯೂ ನೇಮಿಸಿದ್ದಾರೆ? ಆ ಈಜಿಪ್ಟಿನವನನ್ನು ಕೊಂದುಹಾಕಿದಂತೆ ನನ್ನನ್ನೂ ಕೊಂದು ಹಾಕಬೇಕೆಂದಿದ್ದೀಯೋ?” ಎಂದನು. ಆಗ ಮೋಶೆಯು ಭಯಪಟ್ಟು, “ನಿಶ್ಚಯವಾಗಿ ನಾನು ಮಾಡಿದ ಕಾರ್ಯವು ತಿಳಿದಿರಬೇಕು,” ಎಂದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ಫರೋಹನು ಈ ವಿಷಯವನ್ನು ಕೇಳಿದಾಗ, ಮೋಶೆಯನ್ನು ಕೊಂದುಹಾಕುವುದಕ್ಕೆ ಪ್ರಯತ್ನಿಸಿದನು. ಆದರೆ ಮೋಶೆಯು ಫರೋಹನ ಎದುರಿನಿಂದ ಓಡಿಹೋಗಿ ಮಿದ್ಯಾನ್ ದೇಶಕ್ಕೆ ವಾಸಿಸಲು ಹೋದನು. ಅಲ್ಲಿ ಒಂದು ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ಕೂತುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ಮಿದ್ಯಾನಿನ ಯಾಜಕನಿಗೆ ಏಳುಮಂದಿ ಪುತ್ರಿಯರಿದ್ದರು. ಇವರು ಬಂದು ತಮ್ಮ ತಂದೆಯ ಕುರಿಮಂದೆಗಳಿಗೆ ನೀರು ಕುಡಿಸುವದಕ್ಕಾಗಿ ನೀರು ಸೇದಿ, ದೋಣಿಗಳನ್ನು ತುಂಬಿಸುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ಕುರುಬರು ಬಂದು ಅವರನ್ನು ಅಲ್ಲಿಂದ ಓಡಿಸಲು, ಮೋಶೆಯು ಎದ್ದು ಬಂದು ಅವರಿಗೆ ಸಹಾಯಮಾಡಿ, ಅವರ ಕುರಿಗಳಿಗೆ ನೀರು ಕುಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ಹುಡುಗಿಯರು ತಮ್ಮ ತಂದೆ ರೆಯೂವೇಲನ ಬಳಿಗೆ ಬಂದಾಗ, ಅವನು ಅವರಿಗೆ, “ಏಕೆ ಈ ಹೊತ್ತು ಬೇಗ ಬಂದಿರಿ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ಅದಕ್ಕೆ ಅವರು, “ಈಜಿಪ್ಟಿನವನಾದ ಒಬ್ಬ ಮನುಷ್ಯನು ಕುರುಬರ ಕೈಯಿಂದ ನಮ್ಮನ್ನು ತಪ್ಪಿಸಿ, ನಮಗೋಸ್ಕರ ಸಾಕಾಗುವಷ್ಟು ನೀರು ಸೇದಿ, ಮಂದೆಗೆ ಕುಡಿಸಿದನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ಆಗ ರೆಯೂವೇಲನು ತನ್ನ ಪುತ್ರಿಯರಿಗೆ, “ಅವನು ಎಲ್ಲಿದ್ದಾನೆ? ಏಕೆ ಆ ಮನುಷ್ಯನನ್ನು ಬಿಟ್ಟು ಬಂದಿರಿ? ಅವನನ್ನು ಕರೆಯಿರಿ, ಅವನು ಊಟಮಾಡಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ಮೋಶೆಯು ಆ ಮನುಷ್ಯನ ಸಂಗಡ ವಾಸಮಾಡುವುದಕ್ಕೆ ಸಮ್ಮತಿಸಿದನು. ಅವನು ಮೋಶೆಗೆ ತನ್ನ ಮಗಳಾದ ಚಿಪ್ಪೋರಳನ್ನು ಮದುವೆ ಮಾಡಿಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ಆಕೆಯು ಅವನಿಗೆ ಮಗನನ್ನು ಹೆತ್ತಾಗ, ಮೋಶೆಯು ಅವನಿಗೆ ಗೇರ್ಷೋಮ್ ಎಂದು ಹೆಸರಿಟ್ಟನು ಏಕೆಂದರೆ ಅವನು, “ನಾನು ಪರದೇಶದಲ್ಲಿ ಅನ್ಯನಾಗಿದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ಹೀಗೆ ಬಹಳ ದಿನಗಳಾದ ಮೇಲೆ ಈಜಿಪ್ಟಿನ ಅರಸನು ಸತ್ತನು. ಇಸ್ರಾಯೇಲರು ದಾಸತ್ವದ ಕಾರಣದಿಂದ ನರಳಾಡುತ್ತಾ ಮೊರೆಯಿಡುತ್ತಿದ್ದರು. ದಾಸತ್ವದ ನಿಮಿತ್ತವಾಗಿ ಅವರ ಕೂಗು ದೇವರ ಬಳಿಗೆ ಮುಟ್ಟಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ದೇವರು ಅವರ ನರಳಾಟವನ್ನು ಕೇಳಿದಾಗ, ಅವರು ಅಬ್ರಹಾಮ, ಇಸಾಕ ಮತ್ತು ಯಾಕೋಬನ ಸಂಗಡ ತಾವು ಮಾಡಿದ ಒಡಂಬಡಿಕೆಯನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ದೇವರು ಇಸ್ರಾಯೇಲರನ್ನು ನೋಡಿ ಅವರಲ್ಲಿ ಕನಿಕರಗೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ಮೋಶೆಯು ತನ್ನ ಮಾವನೂ ಮಿದ್ಯಾನಿನ ಯಾಜಕನೂ ಆದ ಇತ್ರೋವನ ಮಂದೆಯನ್ನು ಮೇಯಿಸುತ್ತಿದ್ದನು. ಮರುಭೂಮಿಯ ಹಿಂಭಾಗಕ್ಕೆ ನಡೆಸಿಕೊಂಡು ಹೋಗಿ ಹೋರೇಬ್ ಎಂಬ ದೇವರ ಬೆಟ್ಟಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ಆಗ ಯೆಹೋವ ದೇವರ ದೂತನು ಪೊದೆಯೊಳಗೆ ಉರಿಯುವ ಬೆಂಕಿಯಲ್ಲಿ ಅವನಿಗೆ ಕಾಣಿಸಿಕೊಂಡನು. ಮೋಶೆಯು ನೋಡಿದಾಗ, ಪೊದೆಯು ಬೆಂಕಿಯಿಂದ ಉರಿಯುತ್ತಿತ್ತು ಆದಾಗ್ಯೂ ಪೊದೆಯು ಸುಟ್ಟು ಹೋಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ಆಗ ಮೋಶೆಯು, “ನಾನು ಹೋಗಿ ಆ ವಿಚಿತ್ರ ನೋಟವನ್ನೂ ಪೊದೆಯು ಏಕೆ ಸುಟ್ಟುಹೋಗಲಿಲ್ಲವೆಂಬುದನ್ನೂ ನೋಡುವೆನು,” ಎಂದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ಅವನು ನೋಡುವುದಕ್ಕೆ ಹತ್ತಿರ ಬರುವುದನ್ನು ಯೆಹೋವ ದೇವರು ನೋಡಿದಾಗ, ದೇವರು ಪೊದೆಯೊಳಗಿಂದ ಅವನಿಗೆ, “ಮೋಶೇ, ಮೋಶೇ,” ಎಂದು ಕರೆದರು. ಆಗ ಅವನು, “ನಾನು ಇಲ್ಲಿ ಇದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ಆಗ ದೇವರು ಅವನಿಗೆ, “ಇಲ್ಲಿ ಸಮೀಪಕ್ಕೆ ಬರಬೇಡ, ನಿನ್ನ ಪಾದರಕ್ಷೆಗಳನ್ನು ತೆಗೆದಿಡು. ನೀನು ನಿಂತಿರುವ ಸ್ಥಳ ಪರಿಶುದ್ಧ ಭೂಮಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ಇದಲ್ಲದೆ ಮೋಶೆಗೆ, “ನಾನು ನಿನ್ನ ಪಿತೃಗಳ ದೇವರೂ ಅಬ್ರಹಾಮನ ದೇವರೂ ಇಸಾಕನ ದೇವರೂ ಯಾಕೋಬನ ದೇವರೂ ಆಗಿದ್ದೇನೆ,” ಎಂದು ಹೇಳಿದರು. ಮೋಶೆಯು ದೇವರ ಕಡೆ ದೃಷ್ಟಿ ಇಡುವುದಕ್ಕೆ ಭಯಪಟ್ಟು ತನ್ನ ಮುಖವನ್ನು ಮುಚ್ಚಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ಆಗ ಯೆಹೋವ ದೇವರು, “ಈಜಿಪ್ಟಿನಲ್ಲಿರುವ ನನ್ನ ಜನರ ವ್ಯಥೆಯನ್ನು ವಾಸ್ತವವಾಗಿಯೂ ಕಂಡಿದ್ದೇನೆ. ಬಿಟ್ಟೀ ಮಾಡಿಸುವವರ ವಿಷಯದಲ್ಲಿ ಅವರು ಇಟ್ಟ ಮೊರೆಯು ನನಗೆ ಕೇಳಿಸಿತು. ಅವರ ದುಃಖವನ್ನು ಬಲ್ಲೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ಆದಕಾರಣ ಅವರನ್ನು ಈಜಿಪ್ಟನವರ ಕೈಯೊಳಗಿಂದ ಬಿಡುಗಡೆ ಮಾಡುವುದಕ್ಕೆ ಬಂದಿದ್ದೇನೆ. ನಾನು ಅವರನ್ನು ಆ ದೇಶದಿಂದ ಬಿಡಿಸಿ, ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ವಿಸ್ತಾರವಾದ ಒಳ್ಳೆಯ ದೇಶಕ್ಕೆ ಅಂದರೆ ಕಾನಾನ್ಯರು, ಹಿತ್ತಿಯರು, ಅಮೋರಿಯರು, ಪೆರಿಜೀಯರು, ಹಿವ್ವಿಯರು, ಯೆಬೂಸಿಯರು ವಾಸವಾಗಿರುವ ದೇಶಕ್ಕೆ ನಡೆಸಿಕೊಂಡು ಹೋಗುವುದಕ್ಕೂ ಇಳಿದು ಬಂದಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ಈಗ ಇಸ್ರಾಯೇಲರ ಕೂಗು ನನಗೆ ಮುಟ್ಟಿದೆ. ಈಜಿಪ್ಟಿನವರು ಅವರಿಗೆ ಕೊಡುತ್ತಿರುವ ಉಪದ್ರವವನ್ನು ನಾನು ನೋಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ಆದ್ದರಿಂದ ಈಗ ಬಾ, ನಾನು ನಿನ್ನನ್ನು ಫರೋಹನ ಬಳಿಗೆ ಕಳುಹಿಸುತ್ತೇನೆ. ಇಸ್ರಾಯೇಲರಾದ ನನ್ನ ಜನರನ್ನು ನೀನು ಈಜಿಪ್ಟಿನೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ಆಗ ಮೋಶೆಯು ದೇವರಿಗೆ, “ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, ಇಸ್ರಾಯೇಲರನ್ನು ಈಜಿಪ್ಟಿನೊಳಗಿಂದ ಹೊರಗೆ ತರುವುದಕ್ಕೆ ನಾನು ಎಷ್ಟರವನು?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ಆಗ ದೇವರು, “ನಿಶ್ಚಯವಾಗಿ ನಾನು ನಿನ್ನ ಸಂಗಡ ಇರುವೆನು. ನೀನು ಜನರನ್ನು ಈಜಿಪ್ಟಿನೊಳಗಿಂದ ಹೊರಗೆ ತಂದ ತರುವಾಯ ನೀವು ಈ ಬೆಟ್ಟದ ಮೇಲೆ ದೇವರಾದ ನನ್ನನ್ನು ಆರಾಧಿಸುವಿರಿ. ನಾನು ನಿನ್ನನ್ನು ಕಳುಹಿಸಿದವನು ಎಂಬುದಕ್ಕೆ ಇದೇ ನಿನಗೆ ಗುರುತಾಗಿ ಇರುವುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ಅದಕ್ಕೆ ಮೋಶೆಯು ದೇವರಿಗೆ, “ಇಸ್ರಾಯೇಲರ ಬಳಿಗೆ ಹೋಗಿ, ‘ನಿಮ್ಮ ಪಿತೃಗಳ ದೇವರು ನನ್ನನ್ನು ನಿಮ್ಮ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾರೆ,’ ಎಂದು ಹೇಳುವಾಗ ಅವರು ನನಗೆ, ‘ಅವರ ಹೆಸರು ಏನು?’ ಎಂದು ಕೇಳಿದರೆ, ನಾನು ಅವರಿಗೆ ಏನು ಹೇಳಬೇಕು?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ಆಗ ದೇವರು ಮೋಶೆಗೆ, “ಇರುವಾತನೇ ಆಗಿದ್ದೇನೆ. ‘ಆ ಇರುವಾತನು ನನ್ನನ್ನು ನಿಮ್ಮ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾರೆ,’ ಎಂದು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ಮತ್ತೆ ದೇವರು ಮೋಶೆಗೆ, “ ‘ನಿಮ್ಮ ಪಿತೃಗಳ ದೇವರೂ ಅಬ್ರಹಾಮನ ದೇವರೂ ಇಸಾಕನ ದೇವರೂ ಯಾಕೋಬನ ದೇವರೂ ಆಗಿರುವ ಯೆಹೋವ ದೇವರು ನನ್ನನ್ನು ನಿಮ್ಮ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾರೆ,’ ಎಂದು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಬೇಕು, “ಇದೇ ಯುಗಯುಗಕ್ಕೆ ನನ್ನ ಹೆಸರೂ, ತಲತಲಾಂತರಕ್ಕೂ ನನ್ನನ್ನು ಸ್ಮರಿಸಬೇಕಾದ ಹೆಸರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“ನೀನು ಹೋಗಿ ಇಸ್ರಾಯೇಲ್ ಹಿರಿಯರನ್ನು ಕೂಡಿಸಿ ಅವರಿಗೆ, ‘ನಿಮ್ಮ ಪಿತೃಗಳ ದೇವರೂ ಅಬ್ರಹಾಮನ ದೇವರೂ ಇಸಾಕನ ದೇವರೂ ಯಾಕೋಬನ ದೇವರೂ ಆಗಿರುವ ಯೆಹೋವ ದೇವರು ನನಗೆ ಕಾಣಿಸಿಕೊಂಡು ಹೀಗೆಂದಿದ್ದಾರೆ: ನಾನು ನಿಮ್ಮನ್ನೂ ಈಜಿಪ್ಟಿನಲ್ಲಿ ನಿಮಗೆ ಸಂಭವಿಸಿದ್ದನ್ನೆಲ್ಲವನ್ನೂ ನಿಶ್ಚಯವಾಗಿ ನೋಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ಈಜಿಪ್ಟಿನ ವ್ಯಥೆಯಿಂದ ಬಿಡಿಸಿ ನಿಮ್ಮನ್ನು ಕಾನಾನ್ಯರು, ಹಿತ್ತಿಯರು, ಅಮೋರಿಯರು, ಪೆರಿಜೀಯರು, ಹಿವ್ವಿಯರು, ಯೆಬೂಸಿಯರು ಇರುವ ಹಾಲು ಜೇನು ಹರಿಯುವ ದೇಶಕ್ಕೆ ಬರಮಾಡುವೆನೆಂದು ವಾಗ್ದಾನ ಮಾಡಿದ್ದೇನೆ,’ ಎಂದು ಅವರಿಗೆ ತಿಳಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರು ನಿನ್ನ ಮಾತನ್ನು ಕೇಳುವರು. ಆಗ ನೀನು ಇಸ್ರಾಯೇಲ್ ಜನರ ಹಿರಿಯರ ಸಹಿತವಾಗಿ ಈಜಿಪ್ಟಿನ ಅರಸನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ, ‘ಹಿಬ್ರಿಯರ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಪ್ರತ್ಯಕ್ಷನಾಗಿದ್ದಾರೆ. ಆದ್ದರಿಂದ ನಾವು ಮರುಭೂಮಿಯಲ್ಲಿ ಮೂರು ದಿನ ಪ್ರಯಾಣಮಾಡಿ, ನಮ್ಮ ಯೆಹೋವ ದೇವರಿಗೆ ಯಜ್ಞಮಾಡಬೇಕಾಗಿದೆ. ಅದಕ್ಕಾಗಿ ನಮ್ಮನ್ನು ಬಿಡು ಎಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತೇವೆ,’ ಎಂದು ಹೇಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ಆದರೂ ಈಜಿಪ್ಟಿನ ಅರಸನು ನೀವು ಎಷ್ಟು ಬಲವಂತ ಮಾಡಿದರೂ ನಿಮ್ಮನ್ನು ಹೋಗಗೊಡಿಸುವುದಿಲ್ಲ ಎಂದು ನನಗೆ ನಿಶ್ಚಯವಾಗಿ ತಿಳಿದಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ಹೀಗಿರುವುದರಿಂದ ನನ್ನ ಕೈಯನ್ನು ಚಾಚಿ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನು ಮಾಡಿ, ನಾನು ಅದನ್ನು ನಾನಾ ವಿಧವಾಗಿ ಬಾಧಿಸುವೆನು. ತರುವಾಯ ಅವನು ನಿಮ್ಮನ್ನು ಕಳುಹಿಸಿಬಿಡುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“ಇದಲ್ಲದೆ ಈ ಜನರಿಗೆ ಈಜಿಪ್ಟಿನವರ ಕಣ್ಣೆದುರಿನಲ್ಲಿ ದಯೆ ದೊರಕುವಂತೆ ಮಾಡುವೆನು. ನೀವು ಹೋಗುವಾಗ ಬರಿಗೈಯಲ್ಲಿ ಹೋಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ಆದರೆ ಪ್ರತಿ ಸ್ತ್ರೀಯು ತನ್ನ ಮನೆಯಲ್ಲಿ ಇಳಿದುಕೊಂಡಿರುವ ಸ್ತ್ರೀಯಿಂದಲೂ ನೆರೆಯವಳಿಂದಲೂ ಬೆಳ್ಳಿಬಂಗಾರದ ಒಡವೆಗಳನ್ನು ಮತ್ತು ವಸ್ತ್ರಗಳನ್ನು ಕೇಳಿಕೊಳ್ಳಲಿ. ಅವುಗಳನ್ನು ನಿಮ್ಮ ಪುತ್ರಪುತ್ರಿಯರ ಮೇಲೆ ಹಾಕಿರಿ. ಹೀಗೆ ನೀವು ಈಜಿಪ್ಟಿನವರನ್ನು ಸೂರೆಮಾಡುವಿರಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ಮೋಶೆಯು ಉತ್ತರವಾಗಿ, “ಅವರು ನನ್ನನ್ನು ನಂಬದೆ, ನನ್ನ ಮಾತಿಗೆ ಕಿವಿಗೊಡದೆ, ‘ಯೆಹೋವ ದೇವರು ನಿನಗೆ ಕಾಣಿಸಿಕೊಂಡೇ ಇಲ್ಲ,’ ಎಂದು ಹೇಳಬಹುದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ, “ನಿನ್ನ ಕೈಯಲ್ಲಿರುವುದೇನು?” ಎಂದು ಕೇಳಿದರು. ಅವನು, “ಕೋಲು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ, “ಅದನ್ನು ನೆಲದ ಮೇಲೆ ಬಿಸಾಡು,” ಎಂದರು. ಅವನು ಅದನ್ನು ನೆಲದ ಮೇಲೆ ಬಿಸಾಡಿದನು. ಆಗ ಅದು ಸರ್ಪವಾಯಿತು. ಮೋಶೆ ಅಲ್ಲಿಂದ ಓಡಿಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನಿನ್ನ ಕೈಚಾಚಿ, ಅದರ ಬಾಲವನ್ನು ಹಿಡಿ,” ಎಂದಾಗ, ಅವನು ಕೈಚಾಚಿ ಅದನ್ನು ಹಿಡಿದ ಕೂಡಲೇ, ಅದು ಅವನ ಕೈಯಲ್ಲಿ ಕೋಲಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ಆಗ ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ, “ಇದರಿಂದ ಆ ಜನರು ತಮ್ಮ ಪೂರ್ವಜರಾದ ಅಬ್ರಹಾಮ, ಇಸಾಕ ಹಾಗೂ ಯಾಕೋಬರ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಿನಗೆ ಪ್ರಕಟವಾಗಿದ್ದು ನಿಜ ಎಂಬುದನ್ನು ನಂಬುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ಅವನ ಸಂಗಡ ಇನ್ನೂ ಮಾತನಾಡಿ, “ನಿನ್ನ ಕೈಯನ್ನು ನಿನ್ನ ಉಡಿಯಲ್ಲಿ ಇಟ್ಟುಕೋ,” ಎಂದಾಗ, ಅವನು ತನ್ನ ಕೈಯನ್ನು ಉಡಿಯಲ್ಲಿ ಹಾಕಿ ಹೊರಗೆ ತೆಗೆದನು. ಇಗೋ, ಅವನ ಕೈ ಕುಷ್ಠದಿಂದ ಹಿಮದಂತೆ ಆಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ದೇವರು ಅವನಿಗೆ, “ನಿನ್ನ ಕೈಯನ್ನು ಉಡಿಯಲ್ಲಿ ಹಾಕು,” ಎಂದಾಗ, ಅವನು ತನ್ನ ಕೈಯನ್ನು ಉಡಿಯಲ್ಲಿ ಹಾಕಿ, ಉಡಿಯಿಂದ ಹೊರಗೆ ತೆಗೆದಾಗ, ಅದು ಅವನ ಉಳಿದ ಮೈಯಂತೆ ಆಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ಆಗ ಯೆಹೋವ ದೇವರು, “ಜನರು ನಿನ್ನನ್ನು ನಂಬದೆ ಮೊದಲನೆಯ ಸೂಚಕಕಾರ್ಯವನ್ನು ಗಮನಿಸದೆ ಹೋದರೂ, ಎರಡನೆಯ ಸೂಚಕಕಾರ್ಯವನ್ನು ನೋಡಿ ನಂಬುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ಆ ಎರಡೂ ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ಅವರು ನಂಬದೆ, ನಿನ್ನ ಮಾತನ್ನು ಕೇಳದೆ ಹೋದರೆ, ನೀನು ನೈಲ್ ನದಿಯ ನೀರನ್ನು ತೆಗೆದು, ಒಣಗಿದ ನೆಲದ ಮೇಲೆ ಸುರಿಯಬೇಕು. ಆಗ ನೀನು ತೆಗೆದ ನದಿಯ ನೀರು ಒಣಗಿದ ನೆಲದ ಮೇಲೆ ರಕ್ತವಾಗುವುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರಿಗೆ, “ಸ್ವಾಮಿ, ನನ್ನನ್ನು ಕ್ಷಮಿಸಿರಿ, ನಾನು ಮೊದಲಿನಿಂದಲೂ ನೀವು ನಿಮ್ಮ ದಾಸನ ಸಂಗಡ ಮಾತನಾಡಿದಂದಿನಿಂದಲೂ ವಾಕ್ಚಾತುರ್ಯವಿಲ್ಲದವನು. ನನ್ನ ಮಾತೂ ನಾಲಿಗೆಯೂ ಮಂದವಾಗಿವೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ಅದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ, “ಮನುಷ್ಯರಿಗೆ ಬಾಯಿ ಕೊಟ್ಟಾತನೂ ಯಾರು? ಮೂಕರನ್ನೂ ಕಿವುಡರನ್ನೂ ಮಾಡಿದಾತನೂ ಯಾರು? ದೃಷ್ಟಿಯುಳ್ಳವರನ್ನೂ ದೃಷ್ಟಿಯಿಲ್ಲದವರನ್ನೂ ಮಾಡಿದಾತನೂ ಯಾರು? ಯೆಹೋವ ದೇವರಾದ ನಾನೇ ಅಲ್ಲವೋ? ");
INSERT INTO kanokcv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ಹಾಗಾದರೆ ಈಗ ಹೋಗು, ನಾನೇ ನಿನ್ನ ಸಂಗಡವಿದ್ದು, ನೀನು ಮಾತನಾಡತಕ್ಕದ್ದನ್ನು ನಿನಗೆ ಬೋಧಿಸುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ಅದಕ್ಕೆ ಮೋಶೆಯು, “ಸ್ವಾಮಿ, ನೀವು ಬೇರೊಬ್ಬನನ್ನು ಕಳುಹಿಸಿರಿ, ಎಂದು ಬೇಡುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಮೇಲೆ ಬೇಸರಗೊಂಡು, “ಲೇವಿಯನಾದ ಆರೋನನು ನಿನ್ನ ಸಹೋದರನಲ್ಲವೇ? ಅವನು ಚೆನ್ನಾಗಿ ಮಾತನಾಡಬಲ್ಲನೆಂದು ನನಗೆ ಗೊತ್ತಿದೆ. ಅವನು ನಿನ್ನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಬರುತ್ತಾನೆ. ಅವನು ನಿನ್ನನ್ನು ಕಂಡು, ತನ್ನ ಹೃದಯದಲ್ಲಿ ಆನಂದಿಸುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ಅವನ ಸಂಗಡ ನೀನು ಮಾತನಾಡಿ, ಹೇಳಬೇಕಾದ ಮಾತುಗಳನ್ನು ಅವನಿಗೆ ತಿಳಿಸಬೇಕು. ನಿನ್ನ ಬಾಯಿಂದಲೂ ಅವನ ಬಾಯಿಂದಲೂ ನಾನೇ ಮಾತನಾಡಿ ನೀವು ಮಾಡಬೇಕಾದುದನ್ನು ಕಲಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ಅವನು ನಿನ್ನ ಪರವಾಗಿ ಜನರ ಸಂಗಡ ಮಾತನಾಡುವನು. ಅವನು ನಿನಗೆ ಬಾಯಿಯಾಗಿರುವನು, ನೀನು ಅವನಿಗೆ ದೇವರಂತಿರುವಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ಆದರೆ ಈ ಕೋಲನ್ನು ನಿನ್ನ ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಇದರಿಂದಲೇ ನೀನು ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ಮಾಡುವೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ಇದಾದ ಮೇಲೆ ಮೋಶೆಯು ತನ್ನ ಮಾವನಾದ ಇತ್ರೋವನ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, “ಈಜಿಪ್ಟಿನಲ್ಲಿರುವ ನನ್ನ ಸಹೋದರರ ಬಳಿಗೆ ಹಿಂದಿರುಗಿ ಹೋಗಿ, ಅವರು ಇನ್ನೂ ಜೀವದಿಂದ ಇದ್ದಾರೋ ಎಂಬುದನ್ನು ನೋಡುವೆನು,” ಎಂದನು. ಇತ್ರೋವನು ಮೋಶೆಗೆ, “ಸಮಾಧಾನದಿಂದ ಹೋಗು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ಯೆಹೋವ ದೇವರು ಮಿದ್ಯಾನಿನಲ್ಲಿ ಮೋಶೆಗೆ, “ಈಜಿಪ್ಟಿಗೆ ಹಿಂದಿರುಗಿ ಹೋಗು. ಏಕೆಂದರೆ ನಿನ್ನನ್ನು ಕೊಲ್ಲಬೇಕೆಂದಿದ್ದ ಜನರೆಲ್ಲಾ ಸತ್ತಿದ್ದಾರೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ಆಗ ಮೋಶೆಯು ತನ್ನ ಹೆಂಡತಿಯನ್ನೂ ಮಕ್ಕಳನ್ನೂ ಕರೆದುಕೊಂಡು ಅವರನ್ನು ಕತ್ತೆಯ ಮೇಲೆ ಕುಳ್ಳಿರಿಸಿ, ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆ ಹಿಂದಿರುಗಿ ಬಂದನು. ಇದಲ್ಲದೆ ದೇವರ ಕೋಲನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆ ಹಿಂದಿರುಗಿ ಹೋಗುವಾಗ, ನಾನು ನಿನ್ನ ಕೈಯಲ್ಲಿ ಮಾಡಿಸಿದ ಎಲ್ಲಾ ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ಫರೋಹನ ಮುಂದೆ ಮಾಡು. ಆದರೆ ನಾನು ಅವನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸುವೆನು. ಅವನು ಜನರನ್ನು ಹೋಗಗೊಡಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ಆಗ ನೀನು ಫರೋಹನಿಗೆ, ‘ಯೆಹೋವ ದೇವರು ಹೀಗೆ ಹೇಳುತ್ತಾರೆ: ಇಸ್ರಾಯೇಲ ನನ್ನ ಮಗನು, ನನ್ನ ಜೇಷ್ಠಪುತ್ರನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ಫರೋಹನೇ, ನಾನು ನಿನಗೆ ಹೇಳುವುದೇನೆಂದರೆ: “ನನ್ನ ಸೇವೆಮಾಡುವಂತೆ ನನ್ನ ಮಗನನ್ನು ಕಳುಹಿಸು.” ನೀನು ಅವನನ್ನು ಕಳುಹಿಸುವುದನ್ನು ನಿರಾಕರಿಸಿದರೆ, ನಾನು ನಿನ್ನ ಮಗನನ್ನು ಅಂದರೆ, ನಿನ್ನ ಜೇಷ್ಠಪುತ್ರನನ್ನು ಕೊಲ್ಲುವೆನು,’ ಎಂದು ತಿಳಿಸಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ಇದಲ್ಲದೆ ಮೋಶೆಯು ಹೋಗುವ ದಾರಿಯಲ್ಲಿ ವಸತಿಗೃಹದಲ್ಲಿದ್ದಾಗ, ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಎದುರಿಗೆ ಬಂದು ಅವನನ್ನು ಕೊಲ್ಲುವುದಕ್ಕಿದ್ದಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ಚಿಪ್ಪೋರಳು ಕಲ್ಲಿನ ಚೂರಿ ತೆಗೆದುಕೊಂಡು ತನ್ನ ಮಗನಿಗೆ ಸುನ್ನತಿ ಮಾಡಿ, ಅದನ್ನು ಮೋಶೆಯ ಪಾದಗಳಿಗೆ ಮುಟ್ಟಿಸಿ ಅವನಿಗೆ, “ಖಂಡಿತವಾಗಿ ನೀನು ನನಗೆ ರಕ್ತಧಾರೆಯಿಂದಾದ ಗಂಡನು,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ಆಗ ಯೆಹೋವ ದೇವರು ಅವನನ್ನು ಉಳಿಸಿದರು. ಆಗ ಅವಳು, “ಸುನ್ನತಿಯ ನಿಮಿತ್ತ ನೀನು ನನಗೆ ರಕ್ತಧಾರೆಯಿಂದ ಗಂಡನಾಗಿದ್ದೀ,” ಎಂದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ಆರೋನನಿಗೆ, “ಮೋಶೆಯನ್ನು ಎದುರುಗೊಳ್ಳುವದಕ್ಕೆ ಮರುಭೂಮಿಗೆ ಹೋಗು,” ಎಂದರು. ಆಗ ಅವನು ಹೋಗಿ ದೇವರ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯನ್ನು ಎದುರುಗೊಂಡು ಮುದ್ದಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ಆಗ ಮೋಶೆಯು ಆರೋನನಿಗೆ ತನ್ನನ್ನು ಕಳುಹಿಸಿದ ಯೆಹೋವ ದೇವರ ಎಲ್ಲಾ ಮಾತುಗಳನ್ನೂ ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಎಲ್ಲಾ ಸೂಚಕಕಾರ್ಯಗಳನ್ನೂ ತಿಳಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ತರುವಾಯ ಮೋಶೆಯೂ ಆರೋನನೂ ಹೋಗಿ ಇಸ್ರಾಯೇಲಿನ ಹಿರಿಯರನ್ನೆಲ್ಲಾ ಒಟ್ಟುಗೂಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ ಮಾತುಗಳನ್ನೆಲ್ಲಾ ಆರೋನನು ಅವರಿಗೆ ಹೇಳಿ, ಜನರ ಮುಂದೆ ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ಜನರು ನಂಬಿದರು. ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರನ್ನು ದರ್ಶಿಸಿ, ಅವರ ವ್ಯಥೆಯನ್ನು ನೋಡಿದ್ದಾರೆ ಎಂದು ಅವರು ಕೇಳಿದಾಗ, ತಲೆಬಾಗಿಸಿ ಆರಾಧಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ತರುವಾಯ ಮೋಶೆಯೂ ಆರೋನನೂ ಹೋಗಿ ಫರೋಹನಿಗೆ, “ಇಸ್ರಾಯೇಲಿನ ಯೆಹೋವ ದೇವರು, ‘ಮರುಭೂಮಿಯಲ್ಲಿ ನನಗೆ ನನ್ನ ಜನರು ಹಬ್ಬವನ್ನಾಚರಿಸುವುದಕ್ಕೆ ಅವರನ್ನು ಹೋಗಗೊಡಿಸು,’ ಎಂದು ಹೇಳುತ್ತಾರೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ಆಗ ಫರೋಹನು, “ನಾನು ಆತನ ಮಾತಿಗೆ ವಿಧೇಯನಾಗಿ ಇಸ್ರಾಯೇಲರನ್ನು ಕಳುಹಿಸಿಬಿಡುವಂತೆ ಆ ಯೆಹೋವ ಯಾರು? ಆ ಯೆಹೋವ ದೇವರನ್ನು ನಾನರಿಯೆನು. ಇಸ್ರಾಯೇಲರನ್ನೂ ಕಳುಹಿಸುವುದಿಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ಆಗ ಅವರು ಫರೋಹನಿಗೆ, “ಹಿಬ್ರಿಯರ ದೇವರು ನಮ್ಮನ್ನು ಸಂದರ್ಶಿಸಿದ್ದಾರೆ. ಆದ್ದರಿಂದ ನಾವು ಮರುಭೂಮಿಯಲ್ಲಿ ಮೂರು ದಿವಸ ಪ್ರಯಾಣಮಾಡಿ, ನಮ್ಮ ಯೆಹೋವ ದೇವರಿಗೆ ಯಜ್ಞ ಅರ್ಪಿಸುವುದಕ್ಕೆ ನಾವು ಹೋಗಬೇಕು. ಇಲ್ಲವಾದರೆ ಅವರು ಉಪದ್ರವದಿಂದಲೋ ಖಡ್ಗದಿಂದಲೋ ನಮ್ಮನ್ನು ದಂಡಿಸುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ಈಜಿಪ್ಟಿನ ಅರಸನು ಅವರಿಗೆ, “ಮೋಶೆಯೇ, ಆರೋನನೇ, ಜನರು ತಮ್ಮ ಕೆಲಸಗಳನ್ನು ಮಾಡದಂತೆ ಏಕೆ ಮಾಡುತ್ತೀರಿ? ನಿಮ್ಮ ಬಿಟ್ಟೀ ಕೆಲಸಗಳಿಗೆ ಹೋಗಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ಇದಲ್ಲದೆ ಫರೋಹನು, “ಈಗ ಹಿಬ್ರಿಯರು ಈ ದೇಶದಲ್ಲಿ ಹೆಚ್ಚಿದ್ದಾರೆ. ನೀವು ಅವರನ್ನು ಅವರ ಬಿಟ್ಟಿಕೆಲಸಗಳಿಂದ ನಿಲ್ಲಿಸಿಬಿಡುತ್ತೀರಲ್ಲಾ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ಅದೇ ದಿನದಲ್ಲಿ ಫರೋಹನು ಬಿಟ್ಟಿಕೆಲಸ ಮಾಡಿಸುವವರಿಗೂ ಅವರ ಮೇಲ್ವಿಚಾರಕರಿಗೂ, ");
INSERT INTO kanokcv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ನೀವು ಇನ್ನು ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ಮೊದಲಿನ ಹಾಗೆ ಜನರಿಗೆ ಒಣಹುಲ್ಲನ್ನು ಕೊಡಬೇಡಿರಿ. ಅವರೇ ಹೋಗಿ ಹುಲ್ಲನ್ನು ಕೂಡಿಸಿಕೊಳ್ಳಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ಅವರು ಈವರೆಗೆ ಮಾಡಿದ ಇಟ್ಟಿಗೆಗಳ ಲೆಕ್ಕದಲ್ಲಿ ಏನೂ ಕಡಿಮೆ ಮಾಡಬಾರದೆಂದು ಅವರಿಗೆ ಹೇಳಬೇಕು. ಅವರು ಮೈಗಳ್ಳರೇ, ಆದ್ದರಿಂದ ಅವರು, ‘ನಾವು ಹೋಗಿ ನಮ್ಮ ದೇವರಿಗೆ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸೋಣ,’ ಎಂದು ಕೂಗುತ್ತಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ಈ ಜನರು ಸುಳ್ಳು ಮಾತುಗಳಿಗೆ ಲಕ್ಷ್ಯಕೊಡದಂತೆ ಅವರ ಮೇಲೆ ಹೆಚ್ಚು ಕೆಲಸಗಳನ್ನು ಹೊರಿಸಿರಿ. ಅವರು ದುಡಿಯಲಿ,” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ಆಗ ಬಿಟ್ಟಿಕೆಲಸವನ್ನು ಮಾಡಿಸುವವರೂ ಮೇಲ್ವಿಚಾರಕರೂ ಹೊರಗೆ ಹೋಗಿ ಜನರಿಗೆ, “ಫರೋಹನು ಹೀಗೆ ಹೇಳುತ್ತಾನೆ: ‘ನಾನು ನಿಮಗೆ ಒಣಹುಲ್ಲು ಕೊಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ನಿಮಗೆ ಹುಲ್ಲು ಎಲ್ಲಿ ದೊರಕುವುದೋ, ಅಲ್ಲಿಗೆ ನೀವೇ ಹೋಗಿ ತೆಗೆದುಕೊಳ್ಳಿರಿ. ಆದರೆ ನಿಮ್ಮ ಕೆಲಸವು ಏನೂ ಕಡಿಮೆಯಾಗಬಾರದು,’ ಎಂದು ಹೇಳಿದ್ದಾನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ಆಗ ಜನರು ಒಣಹುಲ್ಲಿಗಾಗಿ ಕಳೆಕೀಳಿಸುವುದಕ್ಕೆ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಚದರಿಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ಇದಲ್ಲದೆ ಬಿಟ್ಟಿಕೆಲಸ ಮಾಡಿಸುವವರು, “ಹುಲ್ಲು ಇದ್ದಾಗ ನಿಮ್ಮ ಕೆಲಸಗಳನ್ನು ಮಾಡಿದಂತೆಯೇ, ಪ್ರತಿಯೊಂದು ದಿನದಲ್ಲಿ, ಆ ದಿನದ ಕೆಲಸವನ್ನು ತೀರಿಸಿಬಿಡಬೇಕು,” ಎಂದು ಹೇಳಿ ಅವರನ್ನು ತ್ವರೆಪಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ಫರೋಹನ ಅಧಿಕಾರಿಗಳು ತಾವೇ ನೇಮಿಸಿದ ಇಸ್ರಾಯೇಲರ ಮೇಲ್ವಿಚಾರಕರಿಗೆ, “ನೀವು ಮೊದಲು ಇಟ್ಟಿಗೆಗಳ ಲೆಕ್ಕವನ್ನು ಒಪ್ಪಿಸಿದಂತೆ ನಿನ್ನೆ ಈ ಹೊತ್ತು ಏಕೆ ಒಪ್ಪಿಸಲಿಲ್ಲ,” ಎಂದು ಹೇಳಿ ಅವರನ್ನು ಹೊಡೆಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ಇಸ್ರಾಯೇಲರ ಮೇಲ್ವಿಚಾರಕರು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, “ಏಕೆ ನಿಮ್ಮ ದಾಸರಿಗೆ ಹೀಗೆ ಮಾಡುತ್ತೀರಿ? ");
INSERT INTO kanokcv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ನಿಮ್ಮ ದಾಸರಿಗೆ ನೇಮಿಸಿದ ಅಧಿಕಾರಿಗಳು ಹುಲ್ಲನ್ನು ಕೊಡದೆ, ‘ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡಿರಿ’ ಎಂದು ನಮಗೆ ಹೇಳುತ್ತಾ ನಮ್ಮನ್ನು ಹೊಡೆಯುತ್ತಿದ್ದಾರೆ. ಆದರೆ ತಪ್ಪು ನಿಮ್ಮ ಸ್ವಂತ ಜನರಲ್ಲಿಯೇ ಇದೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ಅದಕ್ಕೆ ಅವನು, “ನೀವು ಮೈಗಳ್ಳರು, ನೀವು ಮೈಗಳ್ಳರಾದ ಕಾರಣ, ನೀವು, ‘ನಾವು ಹೋಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಯಜ್ಞವನ್ನರ್ಪಿಸುತ್ತೇವೆ,’ ಎಂದು ಹೇಳುತ್ತೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ಆದ್ದರಿಂದ ಈಗ ಹೋಗಿ ಕೆಲಸಮಾಡಿರಿ. ಹುಲ್ಲನ್ನು ನಿಮಗೆ ಕೊಡುವುದಕ್ಕಾಗುವುದಿಲ್ಲ. ಆದರೂ ನೇಮಿಸಿದ್ದ ಇಟ್ಟಿಗೆಗಳನ್ನು ನೀವು ತಯಾರಿಸಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ದಿನದಿನವೂ ಒಪ್ಪಿಸಬೇಕಾದ ಇಟ್ಟಿಗೆಗಳ ಲೆಕ್ಕ ಕಡಿಮೆಯಾಗಬಾರದೆಂದು ಅಪ್ಪಣೆಯಾದ್ದರಿಂದ, ಇಸ್ರಾಯೇಲರ ಮೇಲ್ವಿಚಾರಕರು ತಾವು ದುರವಸ್ಥೆಯಲ್ಲಿ ಇದ್ದೇವೆಂದು ತಿಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ಅವರು ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಗೆ ಬಂದಾಗ, ದಾರಿಯಲ್ಲಿ ಕಾದಿದ್ದ ಮೋಶೆಯನ್ನೂ, ಆರೋನನನ್ನೂ ಸಂಧಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ಅವರು ಮೋಶೆ ಆರೋನರಿಗೆ, “ಯೆಹೋವ ದೇವರು ನಿಮ್ಮನ್ನು ನೋಡಿ ನ್ಯಾಯತೀರಿಸಲಿ! ಏಕೆಂದರೆ ನೀವೇ ಫರೋಹನ ಮುಂದೆಯೂ ಅವನ ದಾಸರ ಮುಂದೆಯೂ ನಮ್ಮನ್ನು ಅವರು ಹೇಸಿಕೊಳ್ಳುವಂತೆ ಮಾಡಿದಿರಿ. ನಮ್ಮನ್ನು ಸಂಹರಿಸುವುದಕ್ಕೆ ನೀವು ಅವರ ಕೈಗೆ ಖಡ್ಗವನ್ನು ಕೊಟ್ಟಿದ್ದೀರಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ಆಗ ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಬಳಿಗೆ ಬಂದು, “ಸ್ವಾಮಿ, ಈ ಜನರಿಗೆ ಏಕೆ ಕಷ್ಟವನ್ನು ಕೊಟ್ಟಿದ್ದೀರಿ? ಏಕೆ ನನ್ನನ್ನು ಕಳುಹಿಸಿದಿರಿ? ");
INSERT INTO kanokcv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ನಾನು ಫರೋಹನ ಬಳಿಗೆ ಬಂದು ನಿಮ್ಮ ಹೆಸರಿನಲ್ಲಿ ಮಾತನಾಡಿದಂದಿನಿಂದ, ಈ ಜನರಿಗೆ ಅವನು ಕೇಡನ್ನೇ ಮಾಡುತ್ತಿದ್ದಾನೆ. ನೀವು ನಿಮ್ಮ ಜನರನ್ನು ರಕ್ಷಿಸಲಿಲ್ಲವಲ್ಲಾ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನಾನು ಫರೋಹನಿಗೆ ಮಾಡುವುದನ್ನು ಈಗ ನೀನು ನೋಡುವೆ. ನನ್ನ ಬಲವಾದ ಹಸ್ತವನ್ನು ಕಂಡು ಅವನು ಅವರನ್ನು ಹೋಗಗೊಡಿಸುವನು. ನನ್ನ ಬಲವಾದ ಹಸ್ತದ ಕಾರಣದಿಂದ ಅವನು ಅವರನ್ನು ತನ್ನ ದೇಶದೊಳಗಿಂದ ಹೊರಡಿಸುವನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ಇದಲ್ಲದೆ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ನಾನೇ ಅಬ್ರಹಾಮನಿಗೂ ಇಸಾಕನಿಗೂ ಯಾಕೋಬನಿಗೂ ಸರ್ವಶಕ್ತ ದೇವರೆಂದು ಪ್ರಕಟಿಸಿಗೊಂಡೆನು. ಆದರೆ ಯೆಹೋವ ದೇವರೆಂಬ ನನ್ನ ಹೆಸರಿನಿಂದ ನಾನು ಅವರಿಗೆ ಪೂರ್ಣವಾಗಿ ತಿಳಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ಕಾನಾನ್ ದೇಶವನ್ನು ಅಂದರೆ, ಅವರು ವಾಸವಾಗಿದ್ದ ಅವರ ಪ್ರವಾಸದ ದೇಶವನ್ನು ನಾನು ಅವರಿಗೆ ಕೊಡುವೆನೆಂದು ಅವರ ಸಂಗಡ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ದೃಢಪಡಿಸಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ಈಜಿಪ್ಟಿನವರು ದಾಸರನ್ನಾಗಿ ಇಟ್ಟುಕೊಂಡಿರುವ ಇಸ್ರಾಯೇಲರ ನರಳುವಿಕೆಯನ್ನು ಕೇಳಿ, ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ನೆನಪಿಗೆ ತಂದುಕೊಂಡೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“ಆದ್ದರಿಂದ ಇಸ್ರಾಯೇಲರಿಗೆ, ‘ನಾನೇ ಯೆಹೋವ ದೇವರು. ನಾನು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನ ಬಿಟ್ಟಿಕೆಲಸದಿಂದ ಅವರಿಗೆ ದಾಸತ್ವದಲ್ಲಿರುವುದರಿಂದ, ನಾನು ಚಾಚಿದ ಬಾಹುವಿನಿಂದಲೂ ಬಲವಾದ ನ್ಯಾಯತೀರ್ಪುಗಳಿಂದಲೂ ನಿಮ್ಮನ್ನು ಬಿಡಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ನಿಮ್ಮನ್ನು ನನ್ನ ಜನರನ್ನಾಗಿ ತೆಗೆದುಕೊಂಡು ನಿಮಗೆ ದೇವರಾಗಿರುವೆನು. ಈಜಿಪ್ಟಿನ ಬಿಟ್ಟಿಕೆಲಸಗಳೊಳಗಿಂದ ನಿಮ್ಮನ್ನು ಹೊರಗೆ ಬರಮಾಡಿದಾಗ, ಯೆಹೋವ ದೇವರಾಗಿರುವ ನಾನೇ ನಿಮ್ಮ ದೇವರಾಗಿದ್ದೇನೆಂದು ನಿಮಗೆ ತಿಳಿಯುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ನಾನು ಅಬ್ರಹಾಮನಿಗೂ ಇಸಾಕನಿಗೂ ಯಾಕೋಬನಿಗೂ ಕೊಡುವೆನೆಂದು ಕೈಯನ್ನೆತ್ತಿ ಪ್ರಮಾಣ ಮಾಡಿದ ದೇಶದಲ್ಲಿ ನಿಮ್ಮನ್ನು ಬರಮಾಡಿ, ಅದನ್ನು ನಿಮಗೆ ಸೊತ್ತಾಗಿ ಕೊಡುವೆನೆಂದು ಹೇಳಿದ ಯೆಹೋವ ದೇವರು ನಾನೇ,’ ಎಂದು ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ ಹಾಗೆ ಹೇಳಿದಾಗ, ಅವರು ಮನೋವೇದನೆಯ ದೆಸೆಯಿಂದಲೂ ಕ್ರೂರವಾದ ದಾಸತ್ವದ ದೆಸೆಯಿಂದಲೂ ಮೋಶೆಯ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ನೀನು ಈಜಿಪ್ಟಿನ ಅರಸನಾದ ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, ಅವನು ಇಸ್ರಾಯೇಲರನ್ನು ತನ್ನ ದೇಶದಿಂದ ಹೊರಗೆ ಕಳುಹಿಸುವಂತೆ ಅವನ ಸಂಗಡ ಮಾತನಾಡು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ಆದರೆ ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ, “ಇಗೋ, ಇಸ್ರಾಯೇಲರೇ ನನ್ನ ಮಾತನ್ನು ಕೇಳದಿರುವಲ್ಲಿ, ತೊದಲು ಮಾತನಾಡುವ ನನ್ನ ಮಾತನ್ನು ಫರೋಹನು ಕೇಳುವುದು ಹೇಗೆ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ, ಇಸ್ರಾಯೇಲರನ್ನು ಈಜಿಪ್ಟಿನ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡುವಂತೆ ಇಸ್ರಾಯೇಲರ ಬಳಿಗೂ ಅರಸನಾದ ಫರೋಹನ ಬಳಿಗೂ ಹೋಗಬೇಕೆಂದು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ಇಸ್ರಾಯೇಲ್ ಗೋತ್ರಗಳ ಮನೆಯ ಮುಖ್ಯಸ್ಥರು ಇವರೇ: ಇಸ್ರಾಯೇಲನ ಜೇಷ್ಠ ಪುತ್ರನಾದ ರೂಬೇನನ ಪುತ್ರರು: ಹನೋಕ್, ಪಲ್ಲೂ, ಹೆಚ್ರೋನ್, ಕರ್ಮೀ. ಇವರು ರೂಬೇನನ ಗೋತ್ರಗಳ ಮೂಲ ಪುರುಷರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ಸಿಮೆಯೋನನ ಪುತ್ರರು: ಯೆಮೂಯೇಲ್, ಯಾಮೀನ್, ಓಹದ್, ಯಾಕೀನ್, ಚೋಹರ್ ಮತ್ತು ಕಾನಾನ್ಯಳ ಮಗನಾದ ಸೌಲ. ಇವು ಸಿಮೆಯೋನನ ಗೋತ್ರಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ತಮ್ಮ ತಮ್ಮ ವಂಶಾವಳಿಗಳ ಪ್ರಕಾರವಾಗಿರುವ ಲೇವಿಯ ಪುತ್ರರ ಹೆಸರುಗಳು: ಗೇರ್ಷೋನ್, ಕೊಹಾತ್, ಮೆರಾರೀ. ಲೇವಿಯು ನೂರಮೂವತ್ತೇಳು ವರ್ಷಗಳವರೆಗೆ ಬದುಕಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ಗೇರ್ಷೋನನ ಪುತ್ರರು ಅವರ ಗೋತ್ರಗಳಿಗನುಸಾರವಾಗಿ: ಲಿಬ್ನೀ ಮತ್ತು ಶಿಮ್ಮೀಯರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ಕೊಹಾತನ ಪುತ್ರರು: ಅಮ್ರಾಮ್, ಇಚ್ಹಾರ್, ಹೆಬ್ರೋನ್, ಉಜ್ಜೀಯೇಲ್. ಕೊಹಾತನು ಜೀವಿಸಿದ ವರ್ಷಗಳು ನೂರಮೂವತ್ತಮೂರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ಮೆರಾರೀಯ ಪುತ್ರರು: ಮಹ್ಲೀ, ಮೂಷೀ. ವಂಶಾವಳಿಗಳ ಪ್ರಕಾರ ಇವೇ ಲೇವಿಯ ಗೋತ್ರಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ಅಮ್ರಾಮನು ತನ್ನ ಸೋದರತ್ತೆಯಾದ ಯೋಕೆಬೆದಳನ್ನು ಮದುವೆಯಾದನು. ಆಕೆಯು ಅವನಿಗೆ ಆರೋನನನ್ನೂ, ಮೋಶೆಯನ್ನೂ ಹೆತ್ತಳು. ಅಮ್ರಾಮನು ಜೀವಿಸಿದ ಕಾಲ ನೂರಮೂವತ್ತೇಳು ವರ್ಷಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ಇಚ್ಹಾರನ ಪುತ್ರರು: ಕೋರಹ, ನೆಫೆಗ್ ಮತ್ತು ಜಿಕ್ರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ಉಜ್ಜೀಯೇಲನ ಪುತ್ರರು: ಮೀಶಾಯೇಲ್, ಎಲ್ಜಾಫಾನ್ ಮತ್ತು ಸಿತ್ರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ಆರೋನನು ಅಮ್ಮೀನಾದಾಬನ ಮಗಳೂ ನಹಶೋನನ ಸಹೋದರಿಯೂ ಆದ ಎಲೀಶೇಬಳನ್ನು ಮದುವೆಯಾದನು. ಆಕೆಯು ಅವನಿಗೆ ನಾದಾಬ್, ಅಬೀಹೂ, ಎಲಿಯಾಜರ್, ಈತಾಮಾರ್ ಇವರನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ಕೋರಹನ ಪುತ್ರರು: ಅಸ್ಸೀರ್ ಎಲ್ಕಾನಾ, ಅಬೀಯಾಸಾಫ್ ಎಂಬುವರು. ಇವು ಕೋರಹೀಯರ ಗೋತ್ರಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ಆರೋನನ ಮಗ ಎಲಿಯಾಜರನು ಪೂಟಿಯೇಲನ ಹೆಣ್ಣುಮಕ್ಕಳಲ್ಲಿ ಒಬ್ಬಳನ್ನು ಮದುವೆಯಾದನು. ಆಕೆಯು ಅವನಿಗೆ ಫೀನೆಹಾಸನನ್ನು ಹೆತ್ತಳು. ಗೋತ್ರಗಳ ಪ್ರಕಾರ ಇವರು ಲೇವಿಯರ ಗೋತ್ರಗಳ ಮುಖ್ಯಸ್ಥರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ಆರೋನ್, ಮೋಶೆ ಇವರಿಗೆ, “ಇಸ್ರಾಯೇಲರನ್ನು ಅವರವರ ಗೋತ್ರಗಳಿಗನುಸಾರವಾಗಿ ಈಜಿಪ್ಟಿನ ಒಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಬೇಕು,” ಎಂದು ಯೆಹೋವ ದೇವರು ಹೇಳಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ಆದುದರಿಂದ ಮೋಶೆ, ಆರೋನರೂ ಇಸ್ರಾಯೇಲರನ್ನು ಹೊರಗೆ ತರುವುದಕ್ಕಾಗಿ ಈಜಿಪ್ಟಿನ ಅರಸನಾದ ಫರೋಹನ ಸಂಗಡ ಮಾತನಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ಅವರು ಮೋಶೆಗೆ, “ನಾನೇ ಯೆಹೋವ ದೇವರು. ನಾನು ನಿನಗೆ ಹೇಳುವುದನ್ನೆಲ್ಲಾ ಈಜಿಪ್ಟಿನ ಅರಸನಾದ ಫರೋಹನಿಗೆ ತಿಳಿಸು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ಅದಕ್ಕೆ ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಮುಂದೆ, “ಇಗೋ, ನಾನು ತೊದಲು ಮಾತನಾಡುವವನು. ಫರೋಹನು ನನ್ನ ಮಾತನ್ನು ಹೇಗೆ ಕೇಳುತ್ತಾನೆ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಇಗೋ, ನಿನ್ನನ್ನು ಫರೋಹನಿಗೆ ದೇವರಂತೆ ಮಾಡಿದ್ದೇನೆ. ನಿನ್ನ ಸಹೋದರನಾದ ಆರೋನನು ನಿನ್ನ ಪ್ರವಾದಿಯಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸುವುದನ್ನೆಲ್ಲಾ ನೀನು ಮಾತನಾಡಬೇಕು. ಇಸ್ರಾಯೇಲರನ್ನು ತನ್ನ ದೇಶದೊಳಗಿಂದ ಕಳುಹಿಸಿಬಿಡುವ ಹಾಗೆ ನಿನ್ನ ಸಹೋದರನಾದ ಆರೋನನು ಫರೋಹನ ಸಂಗಡ ಮಾತನಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ಆದರೆ ನಾನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸಿ, ನನ್ನ ಸೂಚಕಕಾರ್ಯಗಳನ್ನೂ, ನನ್ನ ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನೂ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಹೆಚ್ಚಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ಆದರೆ ಫರೋಹನು ನಿಮ್ಮ ಮಾತನ್ನು ಕೇಳುವುದಿಲ್ಲ. ಆದರೆ ನನ್ನ ಕೈಯನ್ನು ಈಜಿಪ್ಟಿನ ಮೇಲೆ ಇಟ್ಟು, ದೊಡ್ಡ ನ್ಯಾಯ ತೀರ್ಪುಗಳಿಂದ ನನ್ನ ಜನರಾದ ಇಸ್ರಾಯೇಲರನ್ನೂ, ಅವರ ಸೈನ್ಯಗಳನ್ನೂ ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ನಾನು ಈಜಿಪ್ಟಿನ ಮೇಲೆ ನನ್ನ ಕೈಯನ್ನಿಟ್ಟು, ಅವರೊಳಗಿಂದ ಇಸ್ರಾಯೇಲರನ್ನು ಹೊರಗೆ ಬರಮಾಡಿದಾಗ, ನಾನು ಯೆಹೋವ ದೇವರೆಂದು ಈಜಿಪ್ಟಿನವರಿಗೆ ತಿಳಿದುಬರುವುದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ಮೋಶೆಯೂ ಆರೋನನೂ ಯೆಹೋವ ದೇವರು ತಮಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ಅವರು ಫರೋಹನ ಮುಂದೆ ಮಾತನಾಡುವಾಗ ಮೋಶೆಯು ಎಂಬತ್ತು ವರ್ಷದವನೂ ಆರೋನನು ಎಂಬತ್ತಮೂರು ವರ್ಷದವನೂ ಆಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ಆಗ ಯೆಹೋವ ದೇವರು ಮಾತನಾಡಿ ಮೋಶೆಗೂ ಆರೋನನಿಗೂ, ");
INSERT INTO kanokcv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ಫರೋಹನು ನಿಮಗೆ, ‘ನೀವು ಒಂದು ಅದ್ಭುತಕಾರ್ಯವನ್ನು ತೋರಿಸಿರಿ,’ ಎಂದಾಗ ನೀನು ಆರೋನನಿಗೆ, ‘ನಿನ್ನ ಕೋಲನ್ನು ತೆಗೆದುಕೊಂಡು ಫರೋಹನ ಮುಂದೆ ಬಿಸಾಡು,’ ಎಂದು ಹೇಳು, ಆಗ ಅದು ಸರ್ಪವಾಗುವುದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ಆಗ ಮೋಶೆಯೂ ಆರೋನನೂ ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಯೆಹೋವ ದೇವರು ತಮಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡಿದರು. ಆರೋನನು ತನ್ನ ಕೋಲನ್ನು ಫರೋಹ ಮತ್ತು ಅವನ ಸೇವಕರ ಮುಂದೆಯೂ ಬಿಸಾಡಿದಾಗ, ಅದು ಸರ್ಪವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ಫರೋಹನು ಜ್ಞಾನಿಗಳನ್ನೂ, ಮಂತ್ರವಾದಿಗಳನ್ನೂ ಕರೆಸಿದನು. ಆಗ ಈಜಿಪ್ಟಿನ ಮಂತ್ರಗಾರರೂ ಸಹ ತಮ್ಮ ಮಾಟಗಳಿಂದ ಹಾಗೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ಅವರು ತಮ್ಮ ತಮ್ಮ ಕೋಲುಗಳನ್ನು ಬಿಸಾಡಿದಾಗ, ಅವು ಸರ್ಪಗಳಾದವು. ಆದರೆ ಆರೋನನ ಕೋಲು ಅವರ ಕೋಲುಗಳನ್ನು ನುಂಗಿಬಿಟ್ಟಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ಯೆಹೋವ ದೇವರು ಹೇಳಿದಂತೆಯೇ ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಯಿತು. ಅವನು ಅವರ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಯಿತು. ಅವನು ಜನರನ್ನು ಕಳುಹಿಸಿಬಿಡುವುದಕ್ಕೆ ನಿರಾಕರಿಸುತ್ತಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ಬೆಳಿಗ್ಗೆ ಫರೋಹನ ಬಳಿಗೆ ಹೋಗು. ಅವನು ಹೊರಗೆ ನದಿಯ ಬಳಿಗೆ ಹೋಗುವನು. ಆಗ ನೈಲ್ ನದಿ ತೀರದಲ್ಲಿ ಅವನೆದುರಿಗೆ ನಿಂತುಕೊಂಡು, ಸರ್ಪವಾಗಿ ಮಾಡಿದ ಕೋಲನ್ನು ನಿನ್ನ ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡಿರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ಅವನಿಗೆ ನೀನು, ‘ಹಿಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನನ್ನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾರೆ. ಮರುಭೂಮಿಯಲ್ಲಿ ನನಗೆ ಆರಾಧನೆ ಮಾಡುವ ಹಾಗೆ ನನ್ನ ಜನರನ್ನು ಕಳುಹಿಸು, ಎಂದು ಅವರು ಹೇಳಿದ್ದಾರೆ. ಆದರೆ ಇಗೋ, ಇಂದಿನವರೆಗೂ ನೀನು ಕೇಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ಆದುದರಿಂದ ಯೆಹೋವ ದೇವರು ಮತ್ತೆ ನಿನಗೆ ಹೇಳುವುದೇನೆಂದರೆ: ನಾನೇ ಯೆಹೋವ ದೇವರೆಂದು ನೀನು ಇದರಿಂದ ತಿಳಿದುಕೊಳ್ಳುವೆ. ನನ್ನ ಕೈಯಲ್ಲಿರುವ ಕೋಲಿನಿಂದ, ನೈಲ್ ನದಿಯಲ್ಲಿರುವ ನೀರನ್ನು ಹೊಡೆಯುವೆನು, ಆಗ ಅದು ರಕ್ತವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ನದಿಯಲ್ಲಿರುವ ಮೀನುಗಳು ಸಾಯುವುವು. ನೈಲ್ ನದಿಯು ಹೊಲಸಾಗಿ ನಾರುವುದು. ಈಜಿಪ್ಟಿನವರು ನದಿಯ ನೀರನ್ನು ಕುಡಿಯುವುದಕ್ಕೆ ಅಸಹ್ಯಪಡುವರು,’ ಎಂದು ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ಅನಂತರ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಆರೋನನಿಗೆ, ‘ನಿನ್ನ ಕೋಲನ್ನು ತೆಗೆದುಕೊಂಡು ಈಜಿಪ್ಟಿನ ನೀರಿನ ಮೇಲೆಯೂ ಅದರ ನದಿಗಳ ಮೇಲೆಯೂ ಕೊಳಗಳ ಮೇಲೆಯೂ ಅದರ ಕಾಲುವೆ ಮೇಲೆಯೂ ಅದರ ಕೆರೆಗಳ ಮೇಲೆಯೂ ಕೈಚಾಚು,’ ಎಂದು ಹೇಳು. ಆಗ ಅವು ರಕ್ತವಾಗುವುವು. ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ನೀರಿರುವ ಮರದ ತೊಟ್ಟಿಗಳಲ್ಲಾಗಲೀ, ಕಲ್ಲಿನ ಪಾತ್ರೆಗಳಲ್ಲಾಗಲೀ ರಕ್ತವಿರುವುದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ಮೋಶೆಯೂ ಆರೋನನೂ ಯೆಹೋವ ದೇವರು ತಮಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡಿದರು. ಅವನು ಕೋಲನ್ನು ಎತ್ತಿ, ನೈಲ್ ನದಿಯಲ್ಲಿರುವ ನೀರನ್ನು ಫರೋಹನ ಮುಂದೆಯೂ, ಅವನ ಸೇವಕರ ಮುಂದೆಯೂ ಹೊಡೆದನು. ಆಗ ನದಿಯಲ್ಲಿದ್ದ ನೀರೆಲ್ಲಾ ರಕ್ತವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ನದಿಯಲ್ಲಿದ್ದ ಮೀನುಗಳು ಸತ್ತವು, ನದಿಯು ದುರ್ವಾಸನೆಗೊಂಡಿತು. ಈಜಿಪ್ಟಿನವರು ನೈಲ್ ನದಿಯ ನೀರನ್ನು ಕುಡಿಯಲಾರದೆ ಹೋದರು. ಆಗ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ರಕ್ತವಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ಆದರೆ ಈಜಿಪ್ಟಿನ ಮಂತ್ರಗಾರರು ತಮ್ಮ ಮಾಟಗಳಿಂದ ಹಾಗೆಯೇ ಮಾಡಿದ್ದರಿಂದ ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಯಿತು. ಯೆಹೋವ ದೇವರು ಹೇಳಿದಂತೆಯೇ ಅವನು ಅವರ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ಫರೋಹನು ತಿರುಗಿಕೊಂಡು ತನ್ನ ಅರಮನೆಗೆ ಹಿಂದಿರುಗಿದನು. ಅವನು ಈ ಅದ್ಭುತಕ್ಕೂ ಗಮನಕೊಡಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ಆದರೆ ಈಜಿಪ್ಟಿನವರೆಲ್ಲರೂ ನದಿಯ ನೀರನ್ನು ಕುಡಿಯಲಾರದೆ, ಕುಡಿಯುವ ನೀರಿಗಾಗಿ ನೈಲ್ ನದಿಯ ಸುತ್ತಲೂ ಅಗೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ಯೆಹೋವ ದೇವರು ನೈಲ್ ನದಿಯನ್ನು ರಕ್ತವನ್ನಾಗಿ ಮಾಡಿ ಏಳು ದಿನಗಳು ಕಳೆದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ಅನಂತರ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಅವನಿಗೆ, “ನೀನು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ ಯೆಹೋವ ದೇವರು ಹೀಗೆ ಹೇಳುತ್ತಾರೆ, ‘ನನ್ನನ್ನು ಆರಾಧಿಸುವಂತೆ ನನ್ನ ಜನರನ್ನು ಕಳುಹಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ಕಳುಹಿಸುವುದಕ್ಕೆ ನಿರಾಕರಿಸಿದರೆ, ನಾನು ನಿನ್ನ ದೇಶವನ್ನೆಲ್ಲಾ ಕಪ್ಪೆಗಳಿಂದ ಉಪದ್ರವ ತರುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ನೈಲ್ ನದಿಯಲ್ಲಿ ಕಪ್ಪೆಗಳು ತುಂಬಿಹೋಗುವುವು. ಅವು ನಿನ್ನ ಅರಮನೆಯಲ್ಲಿಯೂ ನೀನು ಮಲಗುವ ಕೊಠಡಿಯಲ್ಲಿಯೂ ನಿನ್ನ ಹಾಸಿಗೆಯ ಮೇಲೂ ನಿನ್ನ ಸೇವಕರ ಮನೆಗಳಲ್ಲಿಯೂ ನಿನ್ನ ಜನರ ಮೇಲೆಯೂ ನಿನ್ನ ಒಲೆಗಳಲ್ಲಿಯೂ ನಿನ್ನ ಹಿಟ್ಟು ನಾದುವ ಹರಿವಾಣಗಳಲ್ಲಿಯೂ ಕಾಣಿಸಿಕೊಳ್ಳುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ನಿನ್ನ ಮೇಲೆಯೂ ನಿನ್ನ ಜನರ ಮೇಲೆಯೂ ನಿನ್ನ ಎಲ್ಲಾ ಅಧಿಕಾರಿಗಳ ಮೇಲೆಯೂ ಕಪ್ಪೆಗಳು ಏರಿ ಬರುವುವು,’ ಎಂದು ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ಅನಂತರ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ನೀನು ಆರೋನನಿಗೆ, ‘ನೀನು ಕೋಲನ್ನು ಹಿಡಿದುಕೊಂಡು ನದಿ, ಕಾಲುವೆ, ಕೆರೆಗಳ ಮೇಲೆಲ್ಲಾ ನಿನ್ನ ಕೈಚಾಚಿ ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆಲ್ಲಾ ಕಪ್ಪೆಗಳು ಬರುವಂತೆ ಮಾಡು,’ ಎಂದು ಹೇಳಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ಆರೋನನು ಈಜಿಪ್ಟಿನ ನೀರಿನ ಮೇಲೆ ಕೈಚಾಚಿದಾಗ, ಕಪ್ಪೆಗಳು ಏರಿಬಂದು ಈಜಿಪ್ಟ್ ದೇಶವನ್ನು ಮುತ್ತಿಕೊಂಡವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ಆದರೆ ಮಂತ್ರಗಾರರು ತಮ್ಮ ಮಾಟಗಳಿಂದ ಹಾಗೆಯೇ ಮಾಡಿ, ಕಪ್ಪೆಗಳನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆ ಬರಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ಆಗ ಫರೋಹನು ಮೋಶೆ ಮತ್ತು ಆರೋನರನ್ನು ಕರೆಯಿಸಿ, “ನೀವು ಯೆಹೋವ ದೇವರನ್ನು ಬೇಡಿಕೊಂಡು ಈ ಕಪ್ಪೆಗಳನ್ನು ನನ್ನ ಬಳಿಯಿಂದಲೂ ನನ್ನ ಪ್ರಜೆಗಳ ಬಳಿಯಿಂದಲೂ ತೊಲಗಿಸಬೇಕು. ಹಾಗೆ ಮಾಡಿದರೆ ನಿಮ್ಮ ಜನರು ಯೆಹೋವ ದೇವರಿಗೋಸ್ಕರ ಯಜ್ಞಮಾಡುವಂತೆ ಅವರಿಗೆ ನಾನು ಅಪ್ಪಣೆ ಕೊಡುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ಅದಕ್ಕೆ ಮೋಶೆ, “ಈ ಕಪ್ಪೆಗಳು ತಮ್ಮ ಬಳಿಯಿಂದಲೂ ನಿನ್ನ ಮನೆಗಳಿಂದಲೂ ತೊಲಗಿ ಹೋಗಿ, ನೈಲ್ ನದಿಯಲ್ಲಿ ಮಾತ್ರ ಉಳಿಯುವಂತೆ ನಾನು ಯಾವಾಗ ನಿನ್ನ ಪರವಾಗಿ, ನಿನ್ನ ಪ್ರಜಾ ಪರಿವಾರದ ಪರವಾಗಿ ಪ್ರಾರ್ಥನೆ ಸಲ್ಲಿಸಬೇಕು? ನಿನಗೆ ಸರಿದೋರಿದಂತೆ ನೀನೇ ಅದಕ್ಕೊಂದು ಕಾಲವನ್ನು ನಿಗದಿಮಾಡಬೇಕು,” ಎಂದು ಫರೋಹನನ್ನು ವಿನಂತಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ಫರೋಹನು ಮೋಶೆಗೆ, “ನಾಳೆ,” ಎಂದನು. ಆಗ ಮೋಶೆಯು, “ನಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರ ಹಾಗೆ ಯಾರೂ ಇಲ್ಲವೆಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವ ಹಾಗೆ, ನಿನ್ನ ಮಾತಿನ ಪ್ರಕಾರ ಆಗಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ಕಪ್ಪೆಗಳು ನಿನ್ನಿಂದಲೂ ನಿನ್ನ ಮನೆಗಳಿಂದಲೂ ನಿನ್ನ ಸೇವಕರಿಂದಲೂ ನಿನ್ನ ಜನರಿಂದಲೂ ಹೊರಟುಹೋಗಿ, ನೈಲ್ ನದಿಯಲ್ಲಿ ಮಾತ್ರ ಇರುವುವು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ಮೋಶೆ ಆರೋನರು ಫರೋಹನನ್ನು ಬಿಟ್ಟು ಹೊರಗೆ ಹೋದಾಗ, ಮೋಶೆ ಫರೋಹನ ಮೇಲೆ ಬರಮಾಡಿದ ಕಪ್ಪೆಗಳ ಕಾಟದ ಬಗ್ಗೆ ಯೆಹೋವ ದೇವರಿಗೆ ಮೊರೆಯಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ಮೋಶೆ ಹೇಳಿದ ಪ್ರಕಾರ ಯೆಹೋವ ದೇವರು ಮಾಡಿದರು. ಮನೆಗಳಲ್ಲಿಯೂ ಅಂಗಳಗಳಲ್ಲಿಯೂ ಹೊಲಗಳಲ್ಲಿಯೂ ಇದ್ದ ಕಪ್ಪೆಗಳು ಸತ್ತವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ಅವರು ಅವುಗಳನ್ನು ರಾಶಿಗಳಾಗಿ ಕೂಡಿಸಿಟ್ಟಿದ್ದರಿಂದ ದೇಶವು ದುರ್ವಾಸನೆಯಿಂದ ತುಂಬಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ಆದರೆ ಫರೋಹನು ತನಗೆ ಉಪಶಮನವಾಯಿತೆಂದು ನೋಡಿದಾಗ, ಯೆಹೋವ ದೇವರು ಹೇಳಿದಂತೆ ಅವನು ತನ್ನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡಿಕೊಂಡು, ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ಅನಂತರ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ನೀನು ಆರೋನನಿಗೆ, ‘ನೀನು ಕೋಲನ್ನು ಚಾಚಿ ಭೂಮಿಯ ಧೂಳನ್ನು ಹೊಡೆ, ಆಗ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಧೂಳು ಹೇನುಗಳಾಗುವುವು,’ ಎಂದು ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ಅವರು ಹಾಗೆಯೇ ಮಾಡಲಾರಂಭಿಸಿದರು. ಆರೋನನು ಕೋಲನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದು, ಅದನ್ನು ಚಾಚಿ, ಭೂಮಿಯ ಧೂಳನ್ನು ಹೊಡೆದನು. ಆಗ ಮನುಷ್ಯರಲ್ಲಿಯೂ ಪಶುಗಳಲ್ಲಿಯೂ ಹೇನುಗಳಾದವು. ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ನೆಲದ ಧೂಳು ಹೇನುಗಳಾದವು ");
INSERT INTO kanokcv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ಮಂತ್ರಗಾರರು ಹೇನುಗಳನ್ನು ಬರಮಾಡುವುದಕ್ಕೆ ತಮ್ಮ ಮಾಟಗಳಿಂದ ಪ್ರಯತ್ನಿಸಿದರು, ಆದರೆ ಸಾಧ್ಯವಾಗದೆ ಹೋಯಿತು. ಆ ಹೇನುಗಳು ಮನುಷ್ಯರ ಮೇಲೆಯೂ ಪಶುಗಳ ಮೇಲೆಯೂ ಹಾಗೆಯೇ ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ಆಗ ಮಂತ್ರಗಾರರು ಫರೋಹನಿಗೆ, “ಇದು ದೇವರ ಕೈಕೆಲಸವೇ ಸರಿ,” ಎಂದರು. ಆದರೆ ಯೆಹೋವ ದೇವರು ಹೇಳಿದಂತೆ ಫರೋಹನ ಹೃದಯ ಕಠಿಣವಾಯಿತು. ಆದ್ದರಿಂದ ಅವನು ಅವರ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಫರೋಹನ ಮುಂದೆ ನಿಂತುಕೋ. ಅವನು ಹೊರಗೆ ನದಿಯ ಬಳಿಗೆ ಬರುತ್ತಾನೆ. ನೀನು ಅವನಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ಯೆಹೋವ ದೇವರು ಹೀಗೆ ಹೇಳುತ್ತಾರೆ: ನನ್ನ ಜನರು ನನ್ನನ್ನು ಆರಾಧಿಸುವಂತೆ ಅವರನ್ನು ಕಳುಹಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ನೀನು ನನ್ನ ಜನರನ್ನು ಕಳುಹಿಸದೆ ಹೋದರೆ, ನಾನು ನಿನ್ನ ಮೇಲೆಯೂ ನಿನ್ನ ಸೇವಕರ ಮೇಲೆಯೂ ನಿನ್ನ ಜನರ ಮೇಲೆಯೂ ನಿನ್ನ ಮನೆಗಳಿಗೂ ನೊಣಗಳನ್ನು ಕಳುಹಿಸುವೆನು. ಈಜಿಪ್ಟಿನವರ ಮನೆಗಳೂ, ಅವರು ವಾಸವಾಗಿರುವ ಭೂಮಿಯೂ ನೊಣಗಳಿಂದ ತುಂಬಿರುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘ಆದರೆ ಆ ದಿವಸದಲ್ಲಿ ನಾನೇ ಭೂಲೋಕದಲ್ಲಿ ಯೆಹೋವ ದೇವರೆಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವಂತೆ, ನನ್ನ ಜನರು ವಾಸಿಸುವ ಗೋಷೆನ್ ಪ್ರಾಂತದಲ್ಲಿ ನೊಣಗಳು ಇರದ ಹಾಗೆ ಅದನ್ನು ನಾನು ಪ್ರತ್ಯೇಕಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ನನ್ನ ಜನರನ್ನೂ, ನಿನ್ನ ಜನರನ್ನೂ ವಿಂಗಡಿಸುವೆನು. ನಾಳೆ ಈ ಸೂಚಕಕಾರ್ಯ ಕಾಣುವುದು,’ ಎಂದು ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ಯೆಹೋವ ದೇವರು ಹಾಗೆಯೇ ಮಾಡಲಾರಂಭಿಸಿದರು. ಬಾಧಿಸುವ ನೊಣಗಳು ಫರೋಹನ ಮನೆಯಲ್ಲಿಯೂ ಅವನ ಸೇವಕರ ಮನೆಗಳಲ್ಲಿಯೂ ಸಮಸ್ತ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿಯೂ ಬಂದವು. ನೊಣಗಳಿಂದ ದೇಶವು ಹಾಳಾಗಿ ಹೋಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ಆಗ ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನೀವು ಹೋಗಿ ಈ ದೇಶದಲ್ಲಿಯೇ ನಿಮ್ಮ ದೇವರಿಗೆ ಯಜ್ಞವನ್ನರ್ಪಿಸಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ಆದರೆ ಮೋಶೆಯು ಫರೋಹನಿಗೆ, “ಹಾಗೆ ಮಾಡುವುದು ಯುಕ್ತವಲ್ಲ. ಏಕೆಂದರೆ ನಮ್ಮ ಯೆಹೋವ ದೇವರಾದ ದೇವರಿಗೆ ಯಜ್ಞವನ್ನರ್ಪಿಸುವುದು ಈಜಿಪ್ಟಿನವರಿಗೆ ಅಸಹ್ಯವಾಗಿರುವುದು. ಈಜಿಪ್ಟಿನವರಿಗೆ ಅಸಹ್ಯವಾಗಿರುವುದನ್ನು ಅವರ ಕಣ್ಣೆದುರಿಗೆ ಅರ್ಪಿಸಿದರೆ, ಅವರು ನಮ್ಮ ಮೇಲೆ ಕಲ್ಲೆಸೆದಾರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ಮರುಭೂಮಿಯಲ್ಲಿ ಮೂರು ದಿನಗಳು ಪ್ರಯಾಣಮಾಡಿ, ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರಿಗೆ ಅವರ ಅಪ್ಪಣೆಯಂತೆ ಯಜ್ಞಮಾಡುವೆವು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ಅದಕ್ಕೆ ಫರೋಹನು ಅವನಿಗೆ, “ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರಿಗೆ ಮರುಭೂಮಿಯಲ್ಲಿ ಯಜ್ಞವನ್ನರ್ಪಿಸುವಂತೆ ನಿಮ್ಮನ್ನು ಕಳುಹಿಸುತ್ತೇನೆ. ಆದರೆ ದೂರ ಹೋಗಬೇಡಿರಿ, ನನಗೋಸ್ಕರ ಪ್ರಾರ್ಥನೆಮಾಡಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ಆಗ ಮೋಶೆಯು ಅವನಿಗೆ, “ನಾನು ನಿನ್ನನ್ನು ಬಿಟ್ಟು ಹೋಗಿ, ಯೆಹೋವ ದೇವರಿಗೆ ಪ್ರಾರ್ಥನೆ ಮಾಡುವೆನು. ನೊಣಗಳು ನಾಳೆ ಫರೋಹನನ್ನೂ, ಅವನ ಸೇವಕರನ್ನೂ, ಅವರ ಜನರನ್ನೂ ಬಿಟ್ಟು ಹೋಗುವುವು. ಆದರೆ ಯೆಹೋವ ದೇವರಿಗೆ ಯಜ್ಞವನ್ನರ್ಪಿಸುವುದಕ್ಕೆ ಫರೋಹನಾದ ನೀನು ಜನರನ್ನು ಕಳುಹಿಸದೆ ಇನ್ನು ಮೇಲೆ ವಂಚಿಸಬಾರದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ತರುವಾಯ ಮೋಶೆಯು ಫರೋಹನನ್ನು ಬಿಟ್ಟು ಹೋಗಿ, ಯೆಹೋವ ದೇವರನ್ನು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ಮೋಶೆಯು ಕೇಳಿದಂತೆಯೇ ಯೆಹೋವ ದೇವರು ಮಾಡಿದರು. ಅವರು ಫರೋಹನಿಂದಲೂ ಅವನ ಸೇವಕರಿಂದಲೂ, ಅವರ ಜನರಿಂದಲೂ ನೊಣಗಳನ್ನು ತೆಗೆದುಹಾಕಿದರು. ಅಲ್ಲಿ ಒಂದಾದರೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ಆದರೆ ಫರೋಹನು ಆ ಸಮಯದಲ್ಲಿಯೂ ತನ್ನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡಿಕೊಂಡಿದ್ದಲ್ಲದೆ, ಜನರನ್ನೂ ಹೋಗಗೊಡಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ಅನಂತರ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನಂದರೆ, “ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ, ‘ಹಿಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಹೀಗೆ ಹೇಳುತ್ತಾರೆ: “ನನ್ನನ್ನು ಆರಾಧಿಸುವಂತೆ ನನ್ನ ಜನರನ್ನು ಕಳುಹಿಸು.” ");
INSERT INTO kanokcv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ಅವರನ್ನು ಕಳುಹಿಸುವುದಕ್ಕೆ ನಿರಾಕರಿಸಿ ಇನ್ನೂ ತಡೆದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ಯೆಹೋವ ದೇವರ ಕೈ ಹೊಲದಲ್ಲಿರುವ ನಿನ್ನ ಪಶುಗಳ ಮೇಲೆ ಇರುವುದು. ಕುದುರೆ, ಕತ್ತೆ, ಒಂಟೆ, ಎತ್ತು, ಕುರಿ, ಆಡು ಇವುಗಳ ಮೇಲೆ ಕಠಿಣವಾದ ಉಪದ್ರವ ಬರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರ ಪಶುಗಳನ್ನೂ ಈಜಿಪ್ಟಿನವರ ಪಶುಗಳನ್ನೂ ವಿಂಗಡಿಸುವರು. ಇಸ್ರಾಯೇಲರ ಪಶುಗಳಲ್ಲಿ ಒಂದೂ ಸಾಯುವುದಿಲ್ಲ,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು, “ನಿರ್ದಿಷ್ಟವಾದ ಒಂದು ಸಮಯವನ್ನು ನೇಮಿಸಿ, ನಾಳೆ ಯೆಹೋವ ದೇವರು ಈ ಕಾರ್ಯವನ್ನು ಈ ದೇಶದಲ್ಲಿ ಮಾಡುವರು, ಎಂದು ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ಮಾರನೆಯ ದಿನವೇ ಯೆಹೋವ ದೇವರು ಆ ಕಾರ್ಯವನ್ನು ಮಾಡಲಾರಂಭಿಸಿದರು. ಈಜಿಪ್ಟಿನ ಪಶುಗಳೆಲ್ಲಾ ಸತ್ತು ಹೋದವು. ಆದರೆ ಇಸ್ರಾಯೇಲರ ಪಶುಗಳಲ್ಲಿ ಒಂದೂ ಸಾಯಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ಫರೋಹನು ಆಳುಗಳನ್ನು ಕಳುಹಿಸಿ ನೋಡಿದಾಗ, ಇಸ್ರಾಯೇಲರ ಪಶುಗಳಲ್ಲಿ ಒಂದೂ ಸತ್ತಿರಲಿಲ್ಲ. ಆದರೆ ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಗಿದ್ದುದರಿಂದ ಅವನು ಜನರನ್ನು ಹೋಗಗೊಡಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಆರೋನರಿಗೆ, “ಕೈತುಂಬಾ ಒಲೆಯ ಬೂದಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಿರಿ. ಅದನ್ನು ಮೋಶೆಯು ಫರೋಹನ ಮುಂದೆ ಆಕಾಶದ ಕಡೆಗೆ ತೂರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ಆಗ ಅದು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಪುಡಿಯಾಗುವುದು. ಅದು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಮನುಷ್ಯರ ಮೇಲೆಯೂ ಪಶುಗಳ ಮೇಲೆಯೂ ಹುಣ್ಣುಗಳಾಗುವ ಬೊಕ್ಕೆಗಳು ಏಳುವಂತೆ ಮಾಡುವುದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ಆಗ ಅವರು ಒಲೆಯ ಬೂದಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಫರೋಹನ ಮುಂದೆ ನಿಂತರು. ಮೋಶೆಯು ಅದನ್ನು ಆಕಾಶದ ಕಡೆಗೆ ತೂರಿದನು. ಆಗ ಅದು ಮನುಷ್ಯರಲ್ಲಿಯೂ ಪಶುಗಳಲ್ಲಿಯೂ ಹರಡಿ ಹುಣ್ಣುಗಳಾಗುವಂಥ ಬೊಕ್ಕೆಗಳಾದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ಇದಲ್ಲದೆ ಮಂತ್ರಗಾರರು ಹುಣ್ಣಿನ ನಿಮಿತ್ತ ಮೋಶೆಯ ಮುಂದೆ ನಿಂತುಕೊಳ್ಳಲಾರದೆ ಹೋದರು. ಏಕೆಂದರೆ ಹುಣ್ಣುಗಳು ಮಂತ್ರಗಾರರ ಮೇಲೆಯೂ ಈಜಿಪ್ಟಿನವರ ಮೇಲೆಯೂ ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ಆದರೆ ಯೆಹೋವ ದೇವರು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡಿದರು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದಂತೆಯೇ ಅವನು ಅವರ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಫರೋಹನ ಮುಂದೆ ನಿಂತುಕೊಂಡು ಅವನಿಗೆ, ‘ಹಿಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಹೀಗೆ ಹೇಳುತ್ತಾರೆ: ನನ್ನನ್ನು ಅವರು ಆರಾಧಿಸುವ ಹಾಗೆ ನನ್ನ ಜನರನ್ನು ಕಳುಹಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ನನ್ನ ಹಾಗೆ ಯಾರೂ ಇಲ್ಲವೆಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವ ಹಾಗೆ, ಈ ಸಾರಿ ನಾನು ಎಲ್ಲಾ ಉಪದ್ರವಗಳನ್ನು ನಿನ್ನ ಮೇಲೆಯೂ ನಿನ್ನ ಸೇವಕರ ಮೇಲೆಯೂ ನಿನ್ನ ಜನರ ಮೇಲೆಯೂ ಬರಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ಈಗ ನನ್ನ ಕೈಚಾಚಿ ನಿನ್ನನ್ನೂ, ನಿನ್ನ ಜನರನ್ನೂ ಉಪದ್ರವದಿಂದ ಬಾಧಿಸುವೆನು. ನಿನ್ನನ್ನು ಭೂಮಿಯೊಳಗಿಂದ ನಿರ್ಮೂಲ ಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ಆದರೆ ನಿಶ್ಚಯವಾಗಿ ನಾನು ನಿನ್ನಲ್ಲಿ ನನ್ನ ಶಕ್ತಿಯನ್ನು ತೋರಿಸಿ, ನನ್ನ ಹೆಸರನ್ನು ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಪ್ರಸಿದ್ಧಪಡಿಸಬೇಕೆಂಬ ಉದ್ದೇಶದಿಂದಲೇ ನಿನ್ನನ್ನು ಸಾಯಿಸದೆ ಉಳಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ನೀನು ಇನ್ನೂ ಅವರನ್ನು ಕಳುಹಿಸದೆ ನನ್ನ ಜನರಿಗೆ ವಿರೋಧವಾಗಿ ನಿನ್ನನ್ನು ನೀನೇ ಹೆಚ್ಚಿಸಿಕೊಳ್ಳುತ್ತೀಯೋ? ");
INSERT INTO kanokcv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ಹಾಗಾದರೆ ನಾಳೆ ಇಷ್ಟು ಹೊತ್ತಿಗೆ ಮಹಾ ಕಠಿಣವಾದ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯನ್ನು ಬೀಳುವಂತೆ ಮಾಡುವೆನು. ಅಂಥದ್ದು ಈಜಿಪ್ಟಿನಲ್ಲಿ, ಅದರ ರಾಜ್ಯವು ಸ್ಥಾಪಿತವಾದಂದಿನಿಂದ ಇಲ್ಲಿಯವರೆಗೂ ಆಗಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ಹೀಗಿರುವುದರಿಂದ ಯಾರನ್ನಾದರೂ ಕಳುಹಿಸಿ ನಿನ್ನ ಪಶುಗಳನ್ನೂ, ಹೊಲದಲ್ಲಿ ನಿನಗಿರುವವುಗಳನ್ನೂ ಭದ್ರಪಡಿಸು. ಏಕೆಂದರೆ ಮನೆಗಳಿಗೆ ಬಾರದೆ ಹೊಲದಲ್ಲಿ ಸಿಕ್ಕುವ ಮನುಷ್ಯರ ಮೇಲೆಯೂ ಪಶುಗಳ ಮೇಲೆಯೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯು ಸುರಿದು ಕೊಲ್ಲುವುದು,’ ಎಂದು ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ಆಗ ಫರೋಹನ ಸೇವಕರಲ್ಲಿ ಯೆಹೋವ ದೇವರ ವಾಕ್ಯಕ್ಕೆ ಭಯಪಟ್ಟವರೆಲ್ಲರೂ ತಮ್ಮ ದಾಸರನ್ನೂ ಪಶುಗಳನ್ನೂ ಮನೆಗಳಿಗೆ ಓಡಿ ಬರುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ಆದರೆ ಯೆಹೋವ ದೇವರ ವಾಕ್ಯಕ್ಕೆ ಮನಸ್ಸು ಕೊಡದವರು, ತಮ್ಮ ದಾಸರನ್ನೂ ಪಶುಗಳನ್ನೂ ಹೊಲದಲ್ಲಿ ಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಆಕಾಶದ ಕಡೆಗೆ ನಿನ್ನ ಕೈಚಾಚು. ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಮನುಷ್ಯರ ಮೇಲೆಯೂ ಪಶುಗಳ ಮೇಲೆಯೂ ಮತ್ತು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಇರುವ ಎಲ್ಲಾ ಹೊಲದ ಬೆಳೆಯ ಮೇಲೆಯೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆ ಸುರಿಯುವುದು,” ಎಂದು ಪ್ರಕಟಪಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ಮೋಶೆಯು ಆಕಾಶದ ಕಡೆಗೆ ತನ್ನ ಕೋಲನ್ನು ಚಾಚಿದನು. ಆಗ ಯೆಹೋವ ದೇವರು ಗುಡುಗುಗಳನ್ನೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯನ್ನೂ ಸುರಿಸಿದರು. ಸಿಡಿಲು ನೆಲಕ್ಕೆ ಬಡಿಯಿತು. ಸಿಡಿಲಿನ ಆರ್ಭಟದೊಂದಿಗೆ ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯನ್ನು ಸುರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ಸಿಡಿಲಿನ ಆರ್ಭಟದೊಂದಿಗೆ ಕಠಿಣವಾದ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯೂ ಸುರಿಯಿತು. ಈಜಿಪ್ಟ್ ಒಂದು ರಾಷ್ಟ್ರವಾದಂದಿನಿಂದ ಅಂಥ ಘೋರವಾದ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯೂ ಆ ದೇಶದಲ್ಲಿ ಆಗಿರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ಆ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಮನುಷ್ಯರು ಮೊದಲುಗೊಂಡು ಪಶುಗಳವರೆಗೂ ಹೊಲದಲ್ಲಿ ಇದ್ದದ್ದನ್ನೆಲ್ಲಾ ಹಾಳುಮಾಡಿತು. ಹೊಲದ ಎಲ್ಲಾ ಸೊಪ್ಪನ್ನೂ ಹಾಳು ಮಾಡಿ, ಎಲ್ಲಾ ಮರಗಳನ್ನು ಮುರಿದುಹಾಕಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ಇಸ್ರಾಯೇಲರು ಇದ್ದ ಗೋಷೆನ್ ಪ್ರಾಂತದಲ್ಲಿ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯು ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ಆಗ ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ಕರೆಕಳುಹಿಸಿ ಅವರಿಗೆ, “ಈ ಸಲ ನಾನು ಪಾಪಮಾಡಿದ್ದೇನೆ, ಯೆಹೋವ ದೇವರು ನೀತಿವಂತನು. ಆದರೆ ನಾನೂ, ನನ್ನ ಜನರೂ ತಪ್ಪಿತಸ್ಥರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ಆದ್ದರಿಂದ ಈ ಬಲವಾದ ಗುಡುಗುಗಳೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯೂ ಇನ್ನು ಸಾಕು. ಇವುಗಳು ನಿಂತುಹೋಗುವಂತೆ ಯೆಹೋವ ದೇವರನ್ನು ಬೇಡಿಕೊಳ್ಳಿರಿ, ನೀವು ಇನ್ನು ಇಲ್ಲಿ ಇರದಂತೆ ನಾನು ನಿಮ್ಮನ್ನು ಕಳುಹಿಸಿಬಿಡುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ಮೋಶೆಯು ಅವನಿಗೆ, “ನಾನು ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟುಹೋದ ಕೂಡಲೇ, ಯೆಹೋವ ದೇವರ ಕಡೆಗೆ ನನ್ನ ಕೈಗಳನ್ನು ಚಾಚಿ ಪ್ರಾರ್ಥಿಸುವೆನು. ಭೂಮಿಯು ಯೆಹೋವ ದೇವರದೇ ಎಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವಂತೆ ಗುಡುಗುಗಳು ನಿಂತುಹೋಗುವುವು. ಆಲಿಕಲ್ಲಿನ ಮಳೆಯು ಇನ್ನು ಇರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ಆದರೂ ನೀನು ಮತ್ತು ನಿನ್ನ ಅಧಿಕಾರಿಗಳು ದೇವರಾದ ಯೆಹೋವ ದೇವರಿಗೆ ಭಯಪಡುವುದಿಲ್ಲವೆಂದು ನಾನು ಬಲ್ಲೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ಜವೆಗೋಧಿಗೆ ತೆನೆಯೂ ಅಗಸೆಯ ಮೊಗ್ಗುಗಳೂ ಇದ್ದುದರಿಂದ ಅಗಸೆಯೂ ಜವೆಗೋಧಿಯೂ ಹಾಳಾದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ಆದರೆ ಗೋಧಿ ಮತ್ತು ಕಡಲೆ ಬೆಳೆದಿಲ್ಲವಾದ್ದರಿಂದ ಹಾಳಾಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ತರುವಾಯ ಮೋಶೆಯು ಫರೋಹನನ್ನು ಬಿಟ್ಟು ಪಟ್ಟಣದ ಹೊರಗೆ ಬಂದಾಗ, ತನ್ನ ಕೈಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಕಡೆಗೆ ಚಾಚಿದನು. ಆಗ ಗುಡುಗುಗಳೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯೂ ನಿಂತುಹೋದವು. ಇನ್ನು ಮಳೆಯು ಭೂಮಿಯ ಮೇಲೆ ಬೀಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ಮಳೆ, ಆಲಿಕಲ್ಲಿನ ಮಳೆ, ಗುಡುಗುಗಳು ನಿಂತುಹೋದದ್ದನ್ನು ಫರೋಹನು ನೋಡಿದಾಗ, ಅವನು ಪುನಃ ಪಾಪಮಾಡಿದನು. ತನ್ನ ಅಧಿಕಾರಿಗಳ ಸಹಿತವಾಗಿ ತನ್ನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಯಿತು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದಂತೆ, ಅವನು ಇಸ್ರಾಯೇಲರನ್ನು ಕಳುಹಿಸಲೇ ಇಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ತರುವಾಯ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಫರೋಹನ ಬಳಿಗೆ ಹೋಗು, ಏಕೆಂದರೆ ನಾನು ನನ್ನ ಅದ್ಭುತ ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ಅವನ ಮುಂದೆ ತೋರಿಸುವುದಕ್ಕಾಗಿ ಅವನ ಹೃದಯವನ್ನೂ ಅವನ ಅಧಿಕಾರಿಗಳ ಹೃದಯಗಳನ್ನೂ ಕಠಿಣ ಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ಇದಲ್ಲದೆ ನೀನು ನಿನ್ನ ಮಕ್ಕಳಿಗೂ ನಿನ್ನ ಮಕ್ಕಳ ಮಕ್ಕಳಿಗೂ ನಾನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಏನು ಮಾಡಿದೆನೆಂದೂ, ನಾನೇ ಯೆಹೋವ ದೇವರೆಂದೂ ನೀವು ತಿಳಿದುಕೊಳ್ಳುವಂತೆ ನಾನು ಅವರ ಮಧ್ಯದಲ್ಲಿ ಮಾಡಿದ ಅದ್ಭುತ ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ತಿಳಿಸಬೇಕು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ಮೋಶೆ ಆರೋನರು ಫರೋಹನ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, “ಹಿಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಹೀಗೆ ಹೇಳುತ್ತಾರೆ, ‘ನನ್ನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೀನು ಎಷ್ಟು ಕಾಲ ತಲೆ ತಗ್ಗಿಸದಿರುವೆ? ನನ್ನನ್ನು ಆರಾಧಿಸುವಂತೆ ನನ್ನ ಜನರನ್ನು ಹೋಗಗೊಡಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ನೀನು ನನ್ನ ಜನರನ್ನು ಹೋಗಗೊಡಿಸದಿದ್ದರೆ, ನಾಳೆಯೇ ನಾನು ನಿನ್ನ ರಾಜ್ಯದಲ್ಲಿ ಮಿಡತೆಗಳನ್ನು ಬರಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ಒಬ್ಬನು ಭೂಮಿಯನ್ನು ಕಾಣುವುದಕ್ಕಾಗದಷ್ಟು ಅವು ಭೂಮಿಯನ್ನೆಲ್ಲಾ ಮುಚ್ಚಿಕೊಳ್ಳುವುವು. ಇದಲ್ಲದೆ ಅವು ಆಲಿಕಲ್ಲಿನ ಮಳೆಯಿಂದ ಹಾಳಾಗದೆ ನಿಮಗಾಗಿ ಉಳಿದಿರುವುದೆಲ್ಲವನ್ನೂ, ಹೊಲಗಳಲ್ಲಿ ಚಿಗುರಿರುವ ಪ್ರತಿಯೊಂದು ಮರವನ್ನೂ ತಿಂದುಬಿಡುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ಅವು ನಿನ್ನ ಮನೆಗಳಲ್ಲಿಯೂ ನಿನ್ನ ಅಧಿಕಾರಿಗಳ ಮನೆಗಳಲ್ಲಿಯೂ ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ಮನೆಗಳಲ್ಲಿಯೂ ತುಂಬಿಕೊಳ್ಳುವುವು. ನಿನ್ನ ತಂದೆ ಅಲ್ಲದೆ ನಿನ್ನ ತಂದೆಯ ತಂದೆಗಳಾಗಲಿ, ಭೂಮಿಯ ಮೇಲೆ ಇದ್ದಂದಿನಿಂದ ಇಂದಿನವರೆಗೂ ಅಂಥ ಮಿಡತೆಯ ದಂಡನ್ನು ಯಾರೂ ನೋಡಿಲ್ಲ,’ ” ಎಂದು ಮೋಶೆ ಹೇಳಿ ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ಫರೋಹನ ಅಧಿಕಾರಿಗಳು ಅವನಿಗೆ, “ಇವನು ಎಷ್ಟು ಕಾಲ ನಮಗೆ ಉರುಲಾಗಿರಬೇಕು. ಆ ಜನರು ತಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರಿಗೆ ಆರಾಧನೆ ಮಾಡುವಂತೆ ಅವರನ್ನು ಕಳುಹಿಸಿಬಿಡು. ಈಜಿಪ್ಟ್ ನಾಶವಾಯಿತೆಂದು ನಿನಗೆ ಇನ್ನೂ ತಿಳಿಯಲಿಲ್ಲವೋ?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ಆದುದರಿಂದ ಫರೋಹನು ಮೋಶೆ ಮತ್ತು ಆರೋನರನ್ನು ಪುನಃ ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನೀವು ಹೋಗಿ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರಿಗೆ ಆರಾಧನೆ ಮಾಡಿರಿ, ಆದರೆ ಹೋಗುವವರು ಯಾರ‍್ಯಾರು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ಅದಕ್ಕೆ ಮೋಶೆಯು ಅವನಿಗೆ, “ನಮ್ಮ ಚಿಕ್ಕವರನ್ನೂ ವೃದ್ಧರನ್ನೂ ಕರೆದುಕೊಂಡು ಹೋಗುತ್ತೇವೆ. ಇದಲ್ಲದೆ ನಮ್ಮ ಪುತ್ರಪುತ್ರಿಯರನ್ನೂ ನಮ್ಮ ದನಕುರಿಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹೋಗುತ್ತೇವೆ. ಏಕೆಂದರೆ ನಾವು ಯೆಹೋವ ದೇವರಿಗಾಗಿ ಹಬ್ಬವನ್ನು ಮಾಡಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ಫರೋಹನು ಅವರಿಗೆ, “ನಾನು ನಿಮ್ಮ ಮಡದಿ ಮಕ್ಕಳನ್ನೂ ಕಳುಹಿಸಿಕೊಟ್ಟು, ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ಸಂಗಡ ಇರಲಿ ಎಂದು ನಾನು ಹೇಳಬಯಸುವಿರೋ? ಇಲ್ಲಾ! ನೀವು ಕೇಡು ಮಾಡಲು ನಿರ್ಧರಿಸಿರುವಿರಿ? ");
INSERT INTO kanokcv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ಹಾಗೆ ಮಾಡದೆ, ಗಂಡಸರಾದ ನೀವು ಮಾತ್ರ ಹೋಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಆರಾಧನೆ ಮಾಡಿರಿ, ಏಕೆಂದರೆ ಇದನ್ನೇ ನೀವು ಬಯಸಿದಿರಿ,” ಎಂದನು. ತರುವಾಯ ಫರೋಹನು ಅವರನ್ನು ತನ್ನ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಡಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಮಿಡತೆಗಳಿಗಾಗಿ ನಿನ್ನ ಕೈಯನ್ನು ಈಜಿಪ್ಟಿನ ಮೇಲೆ ಚಾಚು. ಅವು ಈಜಿಪ್ಟಿನ ಮೇಲೆ ಬಂದು, ಆಲಿಕಲ್ಲಿನ ಮಳೆಯು ದೇಶದಲ್ಲಿ ಉಳಿಸಿದ ಹಸುರಾದದ್ದನ್ನೆಲ್ಲಾ ತಿಂದುಬಿಡಲಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ಮೋಶೆಯು ತನ್ನ ಕೋಲನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆ ಚಾಚಿದಾಗ, ಯೆಹೋವ ದೇವರು ಹಗಲಲ್ಲೂ ರಾತ್ರಿಯಲ್ಲೂ ಪೂರ್ವದಿಕ್ಕಿನಿಂದ ಗಾಳಿಯನ್ನು ಬರಮಾಡಿದರು. ಉದಯವಾದಾಗ ಆ ಗಾಳಿಯು ಮಿಡತೆಗಳನ್ನು ಅಟ್ಟಿಕೊಂಡು ಬಂದಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ಹೀಗೆ ಮಿಡತೆಗಳ ಉಪದ್ರವ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಬಂದು, ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ಮೇರೆಗಳಲ್ಲಿ ದೊಡ್ಡ ಸಮೂಹವಾಗಿ ಸೇರಿಕೊಂಡವು. ಅವುಗಳಂಥವು ಹಿಂದೆ ಎಂದಿಗೂ ಇರಲಿಲ್ಲ, ಅನಂತರವೂ ಇರಲಾರವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ಏಕೆಂದರೆ ಅವು ಭೂಮಿಯನ್ನೆಲ್ಲಾ ಮುತ್ತಿಕೊಂಡದ್ದರಿಂದ, ಆ ದೇಶದಲ್ಲಿ ಕತ್ತಲಾಯಿತು. ಅವು ಭೂಮಿಯ ಎಲ್ಲಾ ಸೊಪ್ಪನ್ನೂ, ಆಲಿಕಲ್ಲಿನ ಮಳೆಯು ಉಳಿಸಿದ ಎಲ್ಲಾ ಫಲವನ್ನೂ ತಿಂದುಬಿಟ್ಟವು. ಮರಗಳಲ್ಲಾಗಲಿ, ಹೊಲದ ಗಿಡಗಳಲ್ಲಾಗಲಿ ಹಸುರಾದದ್ದು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಿಯೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ಆಗ ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ತ್ವರೆಯಾಗಿ ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರಿಗೂ, ನಿಮಗೂ ವಿರೋಧವಾಗಿ ಪಾಪಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ಹೀಗಿರುವುದರಿಂದ ಈಗ ಒಂದೇ ಸಾರಿ ಮಾತ್ರ ನನ್ನ ಪಾಪವನ್ನು ಕ್ಷಮಿಸಬೇಕು. ಈ ಮರಣಕರವಾದ ಉಪದ್ರವವನ್ನು ನನ್ನಿಂದ ತೊಲಗಿಸುವಂತೆ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರನ್ನು ಬೇಡಿಕೊಳ್ಳಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ಆಗ ಮೋಶೆ ಫರೋಹನನ್ನು ಬಿಟ್ಟು ಹೋಗಿ ಯೆಹೋವ ದೇವರನ್ನು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ಯೆಹೋವ ದೇವರು ಬಲವಾದ ಪಶ್ಚಿಮ ಗಾಳಿಯನ್ನು ಬೀಸುವಂತೆ ಮಾಡಿದರು. ಅದು ಮಿಡತೆಗಳನ್ನು ಎತ್ತಿಕೊಂಡು ಹೋಗಿ ಕೆಂಪು ಸಮುದ್ರದಲ್ಲಿ ಹಾಕಿತು. ಈಜಿಪ್ಟ್ ಮೇರೆಗಳಲ್ಲೆಲ್ಲಾ ಒಂದು ಮಿಡತೆಯಾದರೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ಆದರೆ ಯೆಹೋವ ದೇವರು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡಿದ್ದರಿಂದ, ಅವನು ಇಸ್ರಾಯೇಲರನ್ನು ಕಳುಹಿಸದೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಕತ್ತಲೆ ಕವಿದು ಗಾಡಾಂಧಕಾರವಾಗುವಂತೆ ನಿನ್ನ ಕೈಯನ್ನು ಆಕಾಶದ ಕಡೆಗೆ ಚಾಚು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ಮೋಶೆಯು ಆಕಾಶದ ಕಡೆಗೆ ಕೈಚಾಚಿದಾಗ, ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಮೂರು ದಿನಗಳವರೆಗೆ ಘೋರವಾದ ಕತ್ತಲೆ ಕವಿಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ಮೂರು ದಿನಗಳವರೆಗೆ ಅವರು ಒಬ್ಬರನ್ನೊಬ್ಬರು ನೋಡಲಾಗಲಿಲ್ಲ. ಯಾರೂ ತಮ್ಮ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಏಳಲಿಲ್ಲ. ಆದರೆ ಇಸ್ರಾಯೇಲರಿಗೆಲ್ಲಾ ಅವರು ವಾಸಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಅವರಿಗೆ ಬೆಳಕಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ಆಗ ಫರೋಹನು ಮೋಶೆಯನ್ನು ಕರೆಯಿಸಿ ಅವನಿಗೆ, “ನೀವು ಹೋಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಆರಾಧನೆ ಮಾಡಿರಿ. ನಿಮ್ಮ ಕುರಿದನಗಳು ಮಾತ್ರ ಇಲ್ಲಿರಲಿ. ನಿಮ್ಮ ಮಡದಿ ಮಕ್ಕಳೂ ನಿಮ್ಮ ಸಂಗಡ ಹೋಗಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ಅದಕ್ಕೆ ಮೋಶೆಯು ಅವನಿಗೆ, “ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸುವುದಕ್ಕಾಗಿ ಯಜ್ಞಗಳನ್ನೂ ದಹನಬಲಿಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹೋಗಲು ಅಪ್ಪಣೆಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ನಮ್ಮ ಪಶುಪ್ರಾಣಿಗಳನ್ನೂ ನಾವು ನಮ್ಮ ಸಂಗಡ ತೆಗೆದುಕೊಂಡು ಹೋಗುವೆವು. ಒಂದು ಗೊರಸನ್ನೂ ಬಿಡಲಾರೆವು. ಏಕೆಂದರೆ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರಿಗೆ ಆರಾಧನೆ ಮಾಡುವುದಕ್ಕೆ ಅವುಗಳಿಂದಲೇ ಬಲಿ ಅರ್ಪಿಸಬೇಕು. ಯೆಹೋವ ದೇವರಿಗೆ ಯಾವ ಅರ್ಪಣೆ ಮಾಡಬೇಕೆಂಬುದು ಅಲ್ಲಿಗೆ ಹೋಗುವವರೆಗೂ ನಮಗೆ ತಿಳಿಯದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ಆದರೆ ಯೆಹೋವ ದೇವರು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡಿದ್ದರಿಂದ, ಅವನು ಅವರನ್ನು ಕಳುಹಿಸಲಾರದೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ಆಗ ಫರೋಹನು ಮೋಶೆಗೆ, “ನನ್ನನ್ನು ಬಿಟ್ಟು ಹೋಗು. ಇನ್ನು ನನ್ನ ಮುಖವನ್ನು ನೋಡದಂತೆ ಎಚ್ಚರ. ಏಕೆಂದರೆ ನೀನು ನನ್ನ ಮುಖವನ್ನು ನೋಡಿದ ದಿನದಲ್ಲಿ ಸಾಯುವೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ಮೋಶೆಯು ಅವನಿಗೆ, “ನೀನು ಸರಿಯಾಗಿ ಹೇಳಿದ್ದೀ. ಇನ್ನು ಮೇಲೆ ನಾನು ನಿನ್ನ ಮುಖವನ್ನು ನೋಡುವುದಿಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಇನ್ನು ಒಂದೇ ಉಪದ್ರವವನ್ನು ಫರೋಹನ ಮೇಲೆಯೂ, ಈಜಿಪ್ಟ್ ಮೇಲೆಯೂ ಬರಮಾಡುವೆನು. ಆಮೇಲೆ ಅವನು ಇಲ್ಲಿಂದ ಕಳುಹಿಸುವನು. ಇಲ್ಲಿಂದ ನಿಮ್ಮನ್ನು ನಿಶ್ಚಯವಾಗಿ ಬಲವಂತದಿಂದ ಎಲ್ಲರನ್ನೂ ಕಳುಹಿಸಿಬಿಡುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ಆದ್ದರಿಂದ ಸ್ತ್ರೀಪುರುಷರೆಲ್ಲರು ತನ್ನ ನೆರೆಯವನಿಂದಲೂ ಬೆಳ್ಳಿಬಂಗಾರ ಒಡವೆಗಳನ್ನು ಕೇಳಿಕೊಳ್ಳಬೇಕೆಂದು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟಿನವರ ದೃಷ್ಟಿಯಲ್ಲಿ ಜನರಿಗೆ ದಯೆ ದೊರಕುವಂತೆ ಮಾಡಿದರು. ಇದಲ್ಲದೆ ಮೋಶೆಯು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿಯೂ ಫರೋಹನ ಅಧಿಕಾರಿಗಳ ದೃಷ್ಟಿಯಲ್ಲಿಯೂ ಜನರ ದೃಷ್ಟಿಯಲ್ಲಿಯೂ ಬಹಳ ಗೌರವ ಹೊಂದಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ಆಗ ಮೋಶೆಯು ಫರೋಹನಿಗೆ, “ಯೆಹೋವ ದೇವರು ಹೀಗೆ ಹೇಳುತ್ತಾರೆ: ‘ಸುಮಾರು ಮಧ್ಯರಾತ್ರಿಯಲ್ಲಿ ನಾನು ಈಜಿಪ್ಟಿನ ಮಧ್ಯದಲ್ಲಿ ಹಾದು ಹೋಗುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ಆಗ ಈಜಿಪ್ಟ್ ದೇಶದ ಚೊಚ್ಚಲ ಮಕ್ಕಳು ಅಂದರೆ, ಸಿಂಹಾಸನದ ಮೇಲೆ ಕೂತಿರುವ ಫರೋಹನ ಚೊಚ್ಚಲ ಮಗನು ಮೊದಲುಗೊಂಡು ಬೀಸುವ ಕಲ್ಲನ್ನು ಹಿಡಿದಿರುವ ದಾಸಿಯ ಚೊಚ್ಚಲ ಮಗನವರೆಗೆ ಮತ್ತು ಪಶುಗಳಲ್ಲಿ ಚೊಚ್ಚಲಾದವುಗಳೆಲ್ಲವೂ ಸಾಯುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ದೊಡ್ಡ ಗೋಳಾಟವಿರುವುದು. ಅಂಥಾ ಗೋಳಾಟವು ಹಿಂದೆಯೂ ಇರಲಿಲ್ಲ, ಇನ್ನು ಮುಂದೆಯೂ ಇರುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ಆದರೆ ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟಿನವರಿಗೂ, ಇಸ್ರಾಯೇಲರಿಗೂ ಮಧ್ಯದಲ್ಲಿಟ್ಟಿರುವ ವ್ಯತ್ಯಾಸವನ್ನು ನೀವು ತಿಳುಕೊಳ್ಳುವಂತೆ, ಇಸ್ರಾಯೇಲಿನವರ ವಿರುದ್ಧ ಇಲ್ಲವೆ ಪ್ರಾಣಿಗಳ ವಿರುದ್ಧ ಒಂದು ನಾಯಿ ಸಹ ಬೊಗಳುವುದಿಲ್ಲ.’ ");
INSERT INTO kanokcv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ಆಗ ನಿನ್ನ ದಾಸರಾದ ಇವರೆಲ್ಲರೂ ನನ್ನ ಬಳಿಗೆ ಬಂದು, ನನಗೆ ಅಡ್ಡಬಿದ್ದು, ನನಗೆ ನೀನೂ, ನಿನ್ನನ್ನು ಹಿಂಬಾಲಿಸುವ ಜನರೆಲ್ಲರೂ, ‘ಹೊರಗೆ ಹೋಗಿರಿ,’ ಎಂದು ಹೇಳುವರು. ತರುವಾಯ ನಾನು ಹೊರಗೆ ಹೋಗುವೆನು,” ಎಂದು ಹೇಳಿ ಮೋಶೆಯು ಕೋಪಾವೇಶವುಳ್ಳವನಾಗಿ ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ಆದರೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನನ್ನ ಅದ್ಭುತಗಳು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಹೆಚ್ಚಾಗುವಂತೆ ಫರೋಹನು ನಿಮ್ಮ ಮಾತನ್ನು ಕೇಳುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ಈ ಅದ್ಭುತಗಳನ್ನೆಲ್ಲಾ ಮೋಶೆ ಆರೋನರು ಫರೋಹನ ಮುಂದೆ ಮಾಡಿದರು. ಆದರೆ ಯೆಹೋವ ದೇವರು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡಿದ್ದರಿಂದ, ಅವನು ಇಸ್ರಾಯೇಲರನ್ನು ತನ್ನ ದೇಶದೊಳಗಿಂದ ಕಳುಹಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಮೋಶೆ ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ಎಲ್ಲಾ ಮಾಸಗಳಲ್ಲಿ ಇದೇ ನಿಮಗೆ ಆದಿಮಾಸವಾಗಿರಬೇಕು. ಇದು ನಿಮಗೆ ವರುಷದ ಮೊದಲನೆಯ ತಿಂಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ಇಸ್ರಾಯೇಲ್ ಸಭೆಗೆಲ್ಲಾ ನೀವು ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ಈ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ಅವರು ತಮಗೆ ಪ್ರತಿ ಗೋತ್ರಗಳ ಪ್ರತಿಯೊಂದು ಕುಟುಂಬಕ್ಕೆ ಒಂದರಂತೆ ಕುರಿಮರಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ಆ ಕುರಿಮರಿಯನ್ನು ಪೂರ್ತಿಯಾಗಿ ತಿನ್ನುವುದಕ್ಕೆ ಕುಟುಂಬವು ಚಿಕ್ಕದಾಗಿದ್ದರೆ, ತನ್ನ ಮನೆಗೆ ಸಮೀಪವಾಗಿರುವ ತನ್ನ ನೆರೆಯವನ ಕುಟುಂಬದಲ್ಲಿ ಲೆಕ್ಕನೋಡಿ ಅವರೊಂದಿಗೆ ಪಾಲು ಹೊಂದಲಿ. ಒಬ್ಬೊಬ್ಬನು ತಿನ್ನುವ ಅಳತೆಯ ಪ್ರಕಾರ ಕುರಿಮರಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ನೀವು ಆಯ್ದುಕೊಳ್ಳುವ ಕುರಿಮರಿಯು ದೋಷರಹಿತವಾಗಿರುವ ಒಂದು ವರ್ಷದ ಗಂಡುಮರಿಯಾಗಿರಬೇಕು. ನೀವು ಕುರಿಗಳಿಂದಾಗಲಿ, ಆಡುಗಳಿಂದಾಗಲಿ ತೆಗೆದುಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ಈ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದವರೆಗೆ ಅವುಗಳನ್ನು ಇಟ್ಟುಕೊಳ್ಳಬೇಕು. ತರುವಾಯ ಸಂಜೆಯಲ್ಲಿ ಇಸ್ರಾಯೇಲಿನ ಜನಾಂಗದವರೆಲ್ಲರೂ ಅವುಗಳನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ಅವರು ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪ ತೆಗೆದು, ಕುರಿಮರಿಯ ಮಾಂಸವನ್ನು ಭೋಜನಮಾಡುವ ಮನೆಗಳ ಬಾಗಿಲಿನ ನಿಲುವು ಪಟ್ಟಿಗಳಿಗೂ, ಮೇಲಿನ ಪಟ್ಟಿಗೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ಆ ರಾತ್ರಿಯಲ್ಲಿಯೇ ಮಾಂಸವನ್ನು ಸುಟ್ಟು, ಅದನ್ನೂ, ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನೂ ಕಹಿಯಾದ ಪಲ್ಯಗಳ ಸಂಗಡ ತಿನ್ನಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ಅದರಲ್ಲಿ ಯಾವುದನ್ನೂ ಹಸಿಯಾದದ್ದನ್ನಾಗಲಿ, ನೀರಿನಲ್ಲಿ ಬೇಯಿಸಿಯಾಗಲಿ ತಿನ್ನದೆ, ಅದರ ತಲೆ, ತೊಡೆ, ಒಳಗಿನವುಗಳ ಸಹಿತವಾಗಿ ಬೆಂಕಿಯಲ್ಲಿ ಸುಟ್ಟೇ ಅದನ್ನು ತಿನ್ನಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ಅದರಲ್ಲಿ ಬೆಳಗಿನವರೆಗೆ ಏನನ್ನೂ ಉಳಿಸಬಾರದು. ಬೆಳಗಿನವರೆಗೆ ಅದರಲ್ಲಿ ಉಳಿದದ್ದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ನೀವು ಅದನ್ನು ತಿನ್ನತಕ್ಕ ರೀತಿ ಇದೇ: ನೀವು ನಿಮ್ಮ ನಡುಕಟ್ಟಿಕೊಂಡು, ಕೆರಮೆಟ್ಟಿಕೊಂಡು ಊರುಗೋಲನ್ನು ಹಿಡಿದುಕೊಂಡು ತ್ವರೆಯಾಗಿ ಅದನ್ನು ತಿನ್ನಬೇಕು, ಅದು ಯೆಹೋವ ದೇವರ ಪಸ್ಕವಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“ಏಕೆಂದರೆ ನಾನು ಈ ರಾತ್ರಿ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿರುವ ಎಲ್ಲಾ ಮನುಷ್ಯರಲ್ಲಿಯೂ, ಪಶುಗಳಲ್ಲಿಯೂ ಇರುವ ಚೊಚ್ಚಲಾದವುಗಳನ್ನು ಸಂಹರಿಸುವೆನು. ಈಜಿಪ್ಟಿನ ದೇವರುಗಳಿಗೆಲ್ಲಾ ನಾನು ನ್ಯಾಯತೀರಿಸುವೆನು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ಆದರೆ ನೀವು ಇರುವ ಎಲ್ಲಾ ಮನೆಗಳ ಮೇಲೆ ರಕ್ತವು ನಿಮಗೆ ಗುರುತಾಗಿರುವುದು. ಆ ರಕ್ತವನ್ನು ನಾನು ನೋಡುವಾಗ, ನಿಮ್ಮನ್ನು ದಾಟಿಹೋಗುವೆನು. ಈಜಿಪ್ಟ್ ದೇಶವನ್ನು ನಾನು ಸಂಹರಿಸುವ ಸಮಯದಲ್ಲಿ, ನಿಮ್ಮನ್ನು ನಾಶಮಾಡುವ ಯಾವ ಉಪದ್ರವವು ನಿಮ್ಮ ಮೇಲೆ ಬರುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ಈ ದಿನವು ನಿಮಗೆ ಜ್ಞಾಪಕಾರ್ಥವಾಗಿರುವುದು. ನೀವು ಅದನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಹಬ್ಬವಾಗಿ ತಲತಲಾಂತರಗಳಲ್ಲಿ ಆಚರಿಸಬೇಕು. ಅದನ್ನು ಶಾಶ್ವತ ನಿಯಮವೆಂದು ಎಂದೆಂದಿಗೂ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ಏಳು ದಿನಗಳವರೆಗೆ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು. ಮೊದಲನೆಯ ದಿನದಲ್ಲಿಯೇ ಹುಳಿಹಿಟ್ಟನ್ನು ನಿಮ್ಮ ಮನೆಯೊಳಗಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ಏಕೆಂದರೆ ಮೊದಲನೆಯ ದಿನದಿಂದ ಏಳನೆಯ ದಿನದವರೆಗೆ ಹುಳಿರೊಟ್ಟಿ ತಿನ್ನುವವರನ್ನು ಇಸ್ರಾಯೇಲಿನೊಳಗಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ಇದಲ್ಲದೆ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಪರಿಶುದ್ಧ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆ ಸೇರಬೇಕು, ಏಳನೆಯ ದಿನದಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆ ಸೇರಬೇಕು. ಊಟಕ್ಕೆ ಬೇಕಾದದ್ದನ್ನು ಮಾಡುವುದನ್ನು ಬಿಟ್ಟು, ಆ ದಿನಗಳಲ್ಲಿ ಯಾವ ತರವಾದ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ಏಕೆಂದರೆ ಆ ದಿನದಲ್ಲಿಯೇ ನಾನು ನಿಮ್ಮ ಸೈನ್ಯಗಳನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ್ದೇನೆ. ಆದಕಾರಣ ನಿಮ್ಮ ಸಂತತಿಗಳಲ್ಲಿ ಅದನ್ನು ಶಾಶ್ವತ ನಿಯಮವೆಂದು ಎಂದೆಂದಿಗೂ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ಸಂಜೆಯಿಂದ ಅದೇ ತಿಂಗಳಿನ ಇಪ್ಪತ್ತೊಂದನೆಯ ದಿನ ಸಂಜೆಯವರೆಗೆ ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ಏಳು ದಿನಗಳವರೆಗೆ ಹುಳಿ ಹಿಟ್ಟು ನಿಮ್ಮ ಮನೆಗಳಲ್ಲಿ ಸಿಕ್ಕಬಾರದು, ಏಕೆಂದರೆ ಹುಳಿ ಬೆರೆಸಿದ್ದನ್ನು ಯಾರು ತಿನ್ನುವರೋ ಅವರು ಪರದೇಶದವರಾಗಲಿ, ಸ್ವದೇಶದವರಾಗಲಿ ಅವರನ್ನು ಇಸ್ರಾಯೇಲ್ ಸಭೆಯೊಳಗಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ಹುಳಿ ಕಲಸಿದ್ದು ಯಾವುದೇ ಆಗಿರಲಿ ನೀವು ತಿನ್ನಬಾರದು. ನಿಮ್ಮ ಎಲ್ಲಾ ನಿವಾಸಗಳಲ್ಲಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನೇ ತಿನ್ನಬೇಕು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ಆಗ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲಿನ ಎಲ್ಲಾ ಹಿರಿಯರನ್ನು ಕರೆದು ಅವರಿಗೆ, “ನಿಮ್ಮ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಕುರಿಗಳನ್ನು ಆಯ್ದುಕೊಂಡು ಪಸ್ಕಹಬ್ಬಕ್ಕಾಗಿ ಕೊಯ್ಯಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ಹಿಸ್ಸೋಪ ಗಿಡದ ಕಟ್ಟನ್ನು ತೆಗೆದುಕೊಂಡು, ಬೋಗುಣಿಯಲ್ಲಿರುವ ರಕ್ತದಲ್ಲಿ ಅದನ್ನು ಅದ್ದಿ, ಬಾಗಿಲಿನ ಮೇಲೆ ಅಡ್ಡ ಪಟ್ಟಿಗೂ, ಅದರ ಪಕ್ಕದಲ್ಲಿರುವ ಎರಡು ನಿಲುವು ಕಂಬಗಳಿಗೂ ಹಚ್ಚಿರಿ. ನಿಮ್ಮಲ್ಲಿ ಯಾರೂ ಬೆಳಗಾಗುವವರೆಗೆ ಮನೆಯ ಬಾಗಿಲನ್ನು ಬಿಟ್ಟುಹೋಗಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟಿನವರನ್ನು ಸಂಹರಿಸುವುದಕ್ಕಾಗಿ ಹಾದುಹೋಗುವರು. ಅವರು ಅಡ್ಡ ಪಟ್ಟಿಯ ಮೇಲೂ, ಅದರ ಪಕ್ಕದ ಎರಡು ನಿಲುವು ಕಂಬಗಳ ಮೇಲೂ ರಕ್ತವನ್ನು ನೋಡಿದಾಗ, ಸಂಹಾರಕನು ನಿಮ್ಮ ಮನೆಗಳೊಳಗೆ ಬಂದು ನಿಮ್ಮನ್ನು ಸಂಹಾರಮಾಡದಂತೆ, ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ಬಾಗಿಲುಗಳನ್ನು ದಾಟಿಹೋಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“ಇದನ್ನು ಒಂದು ಶಾಸನವಾಗಿ ನೀವೂ, ನಿಮ್ಮ ಪುತ್ರರೂ ಸದಾಕಾಲಕ್ಕೂ ಆಚರಿಸತಕ್ಕದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ಯೆಹೋವ ದೇವರು ಕೊಡುವೆನೆಂದು ಪ್ರಮಾಣ ಮಾಡಿದ ದೇಶಕ್ಕೆ ನೀವು ಬಂದಾಗ, ಈ ಆಚರಣೆಯನ್ನು ನೀವು ಕೈಗೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ನಿಮ್ಮ ಮಕ್ಕಳು, ‘ಈ ಆಚರಣೆಯ ಅರ್ಥವೇನು?’ ಎಂದು ಕೇಳಿದಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ನೀವು ಅವರಿಗೆ, ‘ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಈಜಿಪ್ಟಿನವರನ್ನು ಸಂಹರಿಸಿ, ನಮ್ಮ ಮನೆಗಳನ್ನು ಕಾಪಾಡುವುದಕ್ಕಾಗಿ ಇಸ್ರಾಯೇಲರ ಮನೆಗಳನ್ನು ದಾಟಿಹೋದ ಯೆಹೋವ ದೇವರ ಪಸ್ಕ ಬಲಿಯ ಆಚರಣೆಯನ್ನು ನಡೆಸುತ್ತಿದ್ದೇವೆ,’ ಎಂದು ನೀವು ಹೇಳಬೇಕು,” ಎಂದನು. ಆಗ ಜನರು ತಲೆಬಾಗಿಸಿ ಆರಾಧಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಆರೋನರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮೇರೆಗೆ ಇಸ್ರಾಯೇಲರು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ಮಧ್ಯರಾತ್ರಿಯಲ್ಲಿ ಸಿಂಹಾಸನದ ಮೇಲೆ ಕೂತುಕೊಂಡ ಫರೋಹನ ಚೊಚ್ಚಲು ಮಗನು ಮೊದಲುಗೊಂಡು, ಸೆರೆಯಲ್ಲಿದ್ದ ಸೆರೆಯವನ ಚೊಚ್ಚಲು ಮಗನವರೆಗೂ, ಎಂದರೆ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಮಕ್ಕಳನ್ನೂ, ಪಶುಗಳಲ್ಲಿ ಚೊಚ್ಚಲಾದವುಗಳೆಲ್ಲವನ್ನೂ ಯೆಹೋವ ದೇವರು ಸಂಹರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ಆಗ ಫರೋಹನೂ, ಅವನ ಎಲ್ಲಾ ಅಧಿಕಾರಿಗಳೂ, ಎಲ್ಲಾ ಈಜಿಪ್ಟಿನವರೂ ರಾತ್ರಿಯಲ್ಲಿ ಎದ್ದರು. ಆ ಈಜಿಪ್ಟಿನಲ್ಲಿ ದೊಡ್ಡ ಗೋಳಾಟವಾಯಿತು. ಏಕೆಂದರೆ ಅಲ್ಲಿ ಸತ್ತವರು ಇಲ್ಲದ ಒಂದು ಮನೆಯಾದರೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ಫರೋಹನು ರಾತ್ರಿಯಲ್ಲಿ ಮೋಶೆ ಆರೋನರನ್ನು ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನೀವು ಮತ್ತು ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಎದ್ದು ನನ್ನ ಜನರೊಳಗಿಂದ ಹೊರಟು ಹೋಗಿರಿ. ನೀವು ಹೇಳಿದ ಹಾಗೆಯೇ, ಯೆಹೋವ ದೇವರನ್ನು ಆರಾಧಿಸುವುದಕ್ಕೆ ಹೊರಟುಹೋಗಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ನೀವು ಹೇಳಿದಂತೆ ನಿಮ್ಮ ಕುರಿದನಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಿರಿ. ನನ್ನನ್ನು ಸಹ ಆಶೀರ್ವದಿಸಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ಇದಲ್ಲದೆ ಈಜಿಪ್ಟಿನವರು, “ನಾವೆಲ್ಲರೂ ಸಾಯುತ್ತೇವೆ,” ಎಂದು ಹೇಳಿ, ಅವರನ್ನು ತ್ವರೆಯಾಗಿ ದೇಶದೊಳಗಿಂದ ಕಳುಹಿಸಿಬಿಡುವ ಹಾಗೆ ಜನರನ್ನು ಒತ್ತಾಯಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ಆದ್ದರಿಂದ ಜನರು ಹಿಟ್ಟಿಗೆ ಹುಳಿ ಹಾಕುವುದಕ್ಕಿಂತ ಮುಂಚೆ, ಅಡಿಗೆ ಮಾಡುವ ಪಾತ್ರೆಗಳ ಸಂಗಡ ಬಟ್ಟೆಗಳಲ್ಲಿ ಕಟ್ಟಿ, ಹೆಗಲಿನ ಮೇಲೆ ಹೊತ್ತುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ಇಸ್ರಾಯೇಲರು ಮೋಶೆಯು ಹೇಳಿದಂತೆ ಮಾಡಿ, ಬೆಳ್ಳಿಬಂಗಾರದ ಒಡವೆಗಳನ್ನೂ, ಬಟ್ಟೆಗಳನ್ನೂ ಈಜಿಪ್ಟಿನವರಿಂದ ಕೇಳಿ ಪಡೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟಿನವರ ಎದುರಿನಲ್ಲಿ ಜನರ ಮೇಲೆ ದಯೆ ತೋರಿಸಿದ್ದರಿಂದ, ಅವರು ಕೇಳಿದ್ದನ್ನು ಕೊಟ್ಟರು. ಹೀಗೆ ಅವರು ಈಜಿಪ್ಟಿನವರ ಸೊತ್ತನ್ನು ಸುಲಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ಆಗ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಮಕ್ಕಳಲ್ಲದೆ ಗಂಡಸರು ಮಾತ್ರ ಆರು ಲಕ್ಷ ಜನರು ಕಾಲುನಡಿಗೆಯಾಗಿ ರಮ್ಸೇಸನ್ನು ಬಿಟ್ಟು ಸುಕ್ಕೋತಿಗೆ ಪ್ರಯಾಣಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ಬೇರೆ ಜನಸಮೂಹವೂ ಕುರಿದನ ಮೊದಲಾದ ಪಶುಗಳ ಬಹುದೊಡ್ಡ ಹಿಂಡೂ ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಹೋದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ಆಗ ಅವರು ಈಜಿಪ್ಟಿನಿಂದ ತಂದಿದ್ದ ನಾದಿದ ಹಿಟ್ಟು ಇನ್ನೂ ಹುಳಿಯಾಗದ ಕಾರಣ, ಹಿಟ್ಟಿನಿಂದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಿದರು. ಏಕೆಂದರೆ ಅವರನ್ನು ಅಲ್ಲಿ ನಿಲ್ಲಗೊಡದೆ ಈಜಿಪ್ಟಿನಿಂದ ಓಡಿಸಿಬಿಟ್ಟಿದ್ದರು. ಅವರು ತಮಗಾಗಿ ಯಾವ ಆಹಾರವನ್ನೂ ಸಿದ್ಧಪಡಿಸಿಕೊಂಡಿರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ಇಸ್ರಾಯೇಲರು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಪ್ರವಾಸವಾಗಿ ವಾಸಮಾಡಿದ್ದ ಕಾಲವು ನಾನೂರ ಮೂವತ್ತು ವರ್ಷಗಳಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ನಾನೂರ ಮೂವತ್ತು ವರ್ಷಗಳು ತೀರಿದ ತರುವಾಯ, ಅದೇ ದಿನದಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಸೈನ್ಯಗಳೆಲ್ಲಾ ಈಜಿಪ್ಟ್ ದೇಶವನ್ನು ಬಿಟ್ಟು ಹೊರಗೆ ಹೋದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ದೇವರು ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಅವರನ್ನು ಹೊರಗೆ ತಂದ ಕಾರಣ, ಇದು ಯೆಹೋವ ದೇವರಿಗೆ ಆಚರಿಸಬೇಕಾದ ರಾತ್ರಿಯಾಗಿತ್ತು. ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಸಂತತಿಗಳಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಆಚರಿಸಬೇಕಾದ ರಾತ್ರಿಯು ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಆರೋನರಿಗೆ, “ಪಸ್ಕದ ಶಾಸನವು ಇದೆ: “ವಿದೇಶಿಯರಲ್ಲಿ ಯಾರೂ ಪಸ್ಕಭೋಜನವನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ಆದರೆ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡ ಪ್ರತಿಯೊಬ್ಬ ಗುಲಾಮನು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡ ತರುವಾಯ, ಅಂಥವನು ಅದನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ಪರದೇಶದವರೂ, ಕೂಲಿಯವರೂ, ಅದನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ಒಂದೇ ಮನೆಯಲ್ಲಿ ಅದನ್ನು ತಿನ್ನಬೇಕು. ಆ ಮಾಂಸದಲ್ಲಿ ಸ್ವಲ್ಪ ಅಂಶವನ್ನಾದರೂ ಮನೆಯ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬಾರದು. ಪಶುವಿನ ಎಲುಬುಗಳಲ್ಲಿ ಒಂದನ್ನಾದರೂ ಮುರಿಯಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ಇಸ್ರಾಯೇಲಿನ ಸಮೂಹದಲ್ಲಿರುವವರೆಲ್ಲರೂ ಇದನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“ನಿಮ್ಮ ಜೊತೆಯಲ್ಲಿ ವಾಸಮಾಡಿದ ಪರದೇಶದವನು ಯೆಹೋವ ದೇವರಿಗೆ ಪಸ್ಕವನ್ನು ಆಚರಿಸಬೇಕೆಂದಿದ್ದರೆ, ಅವನ ಗಂಡಸರೆಲ್ಲಾ ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳಲಿ. ತರುವಾಯ ಅವನು ಅದನ್ನು ಆಚರಿಸುವುದಕ್ಕೆ ಸಮೀಪಬರಲಿ, ಅಂಥವರು ಸ್ವದೇಶದಲ್ಲಿ ಹುಟ್ಟಿದವರಂತೆ ಇರುವರು. ಆದರೆ ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳದ ಒಬ್ಬನಾದರೂ ಅದನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ಸ್ವದೇಶದಲ್ಲಿ ಹುಟ್ಟಿದವನಿಗೂ, ನಿಮ್ಮಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿರುವ ಅನ್ಯನಿಗೂ ಒಂದೇ ನಿಯಮವಿರಲಿ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ಇಸ್ರಾಯೇಲರೆಲ್ಲಾ ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಆರೋನರಿಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ಅದೇ ದಿನದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರನ್ನು ಅವರ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಹುಟ್ಟಿರುವ ಪ್ರತಿಯೊಂದು ಚೊಚ್ಚಲ ಗಂಡನ್ನು ನನಗಾಗಿ ಮೀಸಲಾಗಿಡು. ಮನುಷ್ಯರಾಗಿರಲಿ, ಪಶುಪ್ರಾಣಿಗಳಾಗಿರಲಿ ಪ್ರಥಮ ಗರ್ಭಫಲವು ನನ್ನದಾಗಿದೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ಆಗ ಮೋಶೆಯು ಜನರಿಗೆ, “ನೀವು ಈಜಿಪ್ಟಿನ ದಾಸತ್ವದಿಂದ ಹೊರಬಂದ ಈ ದಿನವನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಿರಿ. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮನ್ನು ತಮ್ಮ ಭುಜಬಲದಿಂದ ಅಲ್ಲಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ್ದಾರೆ. ಹೀಗಿರುವುದರಿಂದ ಈ ದಿನ ನೀವು ಹುಳಿರೊಟ್ಟಿಯನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ಅಬೀಬ ತಿಂಗಳಿನ ಈ ದಿನದಲ್ಲಿ ನೀವು ಹೊರಗೆ ಬಂದಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ಆದ್ದರಿಂದ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ಪಿತೃಗಳಿಗೆ ಪ್ರಮಾಣ ಮಾಡಿದ ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶಕ್ಕೆ ಅಂದರೆ ಕಾನಾನ್ಯರ, ಹಿತ್ತಿಯರ, ಅಮೋರಿಯರ, ಹಿವ್ವಿಯರ, ಯೆಬೂಸಿಯರ ದೇಶಕ್ಕೆ ನಿಮ್ಮನ್ನು ಕರೆತಂದು ಅದನ್ನು ನಿಮಗೆ ಕೊಟ್ಟಾಗ ಈ ಹಬ್ಬವನ್ನು ಈ ತಿಂಗಳಲ್ಲಿ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನು ಏಳು ದಿವಸ ತಿನ್ನಬೇಕು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಹಬ್ಬವನ್ನಾಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ಆ ಏಳು ದಿನಗಳಲ್ಲಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನು ತಿನ್ನಬೇಕು. ಅಲ್ಲದೆ ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ಹುಳಿಯಾಗಲಿ ಇಲ್ಲವೆ ಹುಳಿಹಿಟ್ಟಾಗಲಿ ನಿಮ್ಮ ಯಾವ ಮೇರೆಯಲ್ಲೂ ಕಾಣಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ಆ ದಿನದಲ್ಲಿ ನಿಮ್ಮ ಮಕ್ಕಳಿಗೆ, ‘ನಾವು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಬಂದಾಗ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಮಾಡಿದ್ದನ್ನು ಸ್ಮರಿಸುವುದಕ್ಕಾಗಿ ಇದನ್ನು ಆಚರಿಸುತ್ತೇವೆ,’ ಎಂದು ತಿಳಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮನ್ನು ತಮ್ಮ ಭುಜಬಲದಿಂದ ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ್ದಾರೆ. ಆದ್ದರಿಂದ ದೇವರ ನಿಯಮವು ನಿಮ್ಮ ಬಾಯಲ್ಲಿ ಇರುವಂತೆ, ಈ ಆಚರಣೆಯು ನಿಮ್ಮ ಕೈಯಲ್ಲಿ ಗುರುತಾಗಿಯೂ ನಿಮ್ಮ ಹಣೆಯಲ್ಲಿ ಜ್ಞಾಪಕಾರ್ಥವಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ಹೀಗಿರುವುದರಿಂದ ನೀವು ಪ್ರತಿ ವರುಷವು ನೇಮಿತವಾದ ಕಾಲದಲ್ಲಿ ಈ ಶಾಸನವನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“ಯೆಹೋವ ದೇವರು ನಿಮಗೂ ನಿಮ್ಮ ಪಿತೃಗಳಿಗೂ ಪ್ರಮಾಣ ಮಾಡಿದ ಪ್ರಕಾರ, ನಿಮ್ಮನ್ನು ಕಾನಾನ್ಯರ ದೇಶಕ್ಕೆ ಬರಮಾಡಿ, ಅದನ್ನು ನಿಮಗೆ ಕೊಟ್ಟನಂತರ, ");
INSERT INTO kanokcv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ನಿಮ್ಮಲ್ಲಿಯೂ ನಿಮ್ಮ ಪಶುಪ್ರಾಣಿಗಳಲ್ಲಿಯೂ ಹುಟ್ಟುವ ಪ್ರತಿಯೊಂದು ಗರ್ಭದ ಪ್ರಥಮ ಫಲವನ್ನು ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ಕತ್ತೆಯ ಚೊಚ್ಚಲು ಮರಿಗೆ ಬದಲಾಗಿ ಕುರಿಮರಿಯನ್ನು ಕೊಟ್ಟು ವಿಮೋಚಿಸಿಕೊಳ್ಳಬೇಕು. ಹಾಗೆ ವಿಮೋಚಿಸಿಕೊಳ್ಳದೆ ಹೋದರೆ ಅದರ ಕುತ್ತಿಗೆ ಮುರಿಯಬೇಕು. ಮನುಷ್ಯರಲ್ಲಿ ಚೊಚ್ಚಲ ಗಂಡು ಮಕ್ಕಳನ್ನು ಬದಲುಕೊಟ್ಟು, ವಿಮೋಚಿಸಲೇಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“ಮುಂದೆ ಬರುವ ಕಾಲದಲ್ಲಿ ನಿಮ್ಮ ಪುತ್ರರು ನಿಮಗೆ, ‘ಇದರ ಅರ್ಥವೇನು?’ ಎಂದು ಕೇಳುವಾಗ, ನೀವು ಅವರಿಗೆ, ‘ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಭುಜಬಲದಿಂದ ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನ ದಾಸತ್ವದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ಫರೋಹನು ಹಟಮಾರಿತನದಿಂದ ನಮ್ಮನ್ನು ಕಳುಹಿಸದೆ ಇದ್ದಾಗ, ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಚೊಚ್ಚಲಾದದ್ದನ್ನೆಲ್ಲಾ ಎಂದರೆ, ಮನುಷ್ಯರ ಹಾಗೂ ಪಶುಪ್ರಾಣಿಗಳ ಚೊಚ್ಚಲಾದವುಗಳನ್ನು ಕೊಂದುಹಾಕಿದರು. ಆದ್ದರಿಂದ ಚೊಚ್ಚಲ ಗಂಡುಗಳನ್ನೆಲ್ಲಾ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸುತ್ತೇವೆ. ನಮ್ಮ ಪುತ್ರರಲ್ಲಿ ಚೊಚ್ಚಲಾದವರೆಲ್ಲರನ್ನು ವಿಮೋಚಿಸುತ್ತೇವೆ,’ ");
INSERT INTO kanokcv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ಇದು ನಿಮ್ಮ ಕೈಯಲ್ಲಿ ಗುರುತಾಗಿಯೂ ನಿಮ್ಮ ಹಣೆಯ ಮೇಲೆ ಸಂಕೇತವಾಗಿಯೂ ಇರಲಿ. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಭುಜಬಲದಿಂದ ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ್ದಾರೆ ಎಂದು ಹೇಳಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ಫರೋಹನು ಜನರನ್ನು ಕಳುಹಿಸಿಬಿಟ್ಟಾಗ, ಫಿಲಿಷ್ಟಿಯರ ದೇಶದ ದಾರಿಯು ಸಮೀಪವಿದ್ದರೂ ದೇವರು ಅವರನ್ನು ಅದರಲ್ಲಿ ನಡೆಸಲಿಲ್ಲ. ಏಕೆಂದರೆ ದೇವರು, “ಜನರು ಯುದ್ಧವನ್ನು ನೋಡಿ, ಮನಸ್ಸನ್ನು ಬೇರೆಮಾಡಿಕೊಂಡು, ಈಜಿಪ್ಟಿಗೆ ಹಿಂದಿರುಗಿಯಾರು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ಹೀಗಿರುವುದರಿಂದ ಯೆಹೋವ ದೇವರು ಜನರನ್ನು ಕೆಂಪುಸಮುದ್ರದ ಮರುಭೂಮಿಯಲ್ಲಿ ಸುತ್ತಿಕೊಂಡು ಹೋಗುವಂತೆ ಮಾಡಿದರು. ಇಸ್ರಾಯೇಲರು ಯುದ್ಧಸನ್ನದ್ಧರಾಗಿ ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ಆಗ ಮೋಶೆಯು ತನ್ನೊಂದಿಗೆ ಯೋಸೇಫನ ಎಲುಬುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋದನು. ಏಕೆಂದರೆ ಯೋಸೇಫನು ಇಸ್ರಾಯೇಲರಿಗೆ, “ದೇವರು ನಿಜವಾಗಿಯೂ ನಿಮ್ಮ ಸಹಾಯಕ್ಕೆ ಬರುವರು. ಆಗ ನೀವು ನನ್ನ ಎಲುಬುಗಳನ್ನು ಇಲ್ಲಿಂದ ನಿಮ್ಮ ಕೂಡ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು,” ಎಂದು ಹೇಳಿ ಅವರಿಂದ ದೃಢಪ್ರಮಾಣ ಮಾಡಿಸಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ಹೀಗೆ ಅವರು ಸುಕ್ಕೋತಿನಿಂದ ಪ್ರಯಾಣಮಾಡಿ, ಏತಾಮಿನ ಮರುಭೂಮಿಯ ಅಂಚಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ಇದಲ್ಲದೆ ಅವರು ಹಗಲೂ ರಾತ್ರಿಯೂ ಪ್ರಯಾಣ ಮಾಡುವ ಹಾಗೆ ಯೆಹೋವ ದೇವರು ಹಗಲಲ್ಲಿ ಅವರಿಗೆ ದಾರಿ ತೋರಿಸುವುದಕ್ಕೆ ಮೇಘದ ಸ್ತಂಭದಲ್ಲಿಯೂ ರಾತ್ರಿಯಲ್ಲಿ ಅವರಿಗೆ ಬೆಳಕು ಕೊಡುವುದಕ್ಕೆ ಅಗ್ನಿಯ ಸ್ತಂಭದಲ್ಲಿಯೂ ಅವರ ಮುಂದೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ದೇವರು ಹಗಲಲ್ಲಿ ಮೇಘಸ್ತಂಭವನ್ನೂ ರಾತ್ರಿಯಲ್ಲಿ ಅಗ್ನಿಸ್ತಂಭವನ್ನೂ ಜನರ ಎದುರಿನಿಂದ ತೆಗೆದುಬಿಡಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ತರುವಾಯ ಯೆಹೋವ ದೇವರು ಮಾತನಾಡಿ ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ಇಸ್ರಾಯೇಲರು ಹಿಂತಿರುಗಿ ಹೋಗಿ ಪೀಹಹೀರೋತಿಗೆ ಎದುರಾಗಿ ಮಿಗ್ದೋಲಿಗೂ ಸಮುದ್ರಕ್ಕೂ ಮಧ್ಯದಲ್ಲಿ ಬಾಲ್ಜೆಫೋನಿಗೆ ಎದುರಾಗಿ ಇಳಿದುಕೊಳ್ಳಬೇಕೆಂದು ಅವರಿಗೆ ಹೇಳು. ಅದರ ಎದುರಾಗಿ ನೀವು ಸಮುದ್ರದ ತೀರದಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ಏಕೆಂದರೆ ಫರೋಹನು ಇಸ್ರಾಯೇಲರ ವಿಷಯದಲ್ಲಿ, ‘ಅವರು ಗಲಿಬಿಲಿಗೊಂಡು ಮರುಭೂಮಿಯನ್ನು ಸುತ್ತುವರಿದ ಪ್ರದೇಶದಲ್ಲಿ ಅತ್ತಿತ್ತ ಹೋಗುತ್ತಿರುವರು,’ ಎಂದುಕೊಳ್ಳುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ಇದಲ್ಲದೆ ಫರೋಹನು ನಿಮ್ಮನ್ನು ಹಿಂದಟ್ಟುವಂತೆ ನಾನು ಅವನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡುವೆನು. ಫರೋಹನಲ್ಲಿಯೂ, ಅವನ ಎಲ್ಲಾ ಸೈನ್ಯದಲ್ಲಿಯೂ ನನ್ನನ್ನು ಘನಪಡಿಸಿಕೊಳ್ಳುವೆನು. ಆಗ ನಾನೇ ಯೆಹೋವ ದೇವರೆಂದು ಈಜಿಪ್ಟಿನವರು ತಿಳಿಯುವರು,” ಎಂದು ಹೇಳಿದರು. ಅದರಂತೆಯೇ ಇಸ್ರಾಯೇಲರು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ಜನರು ಓಡಿಹೋದರೆಂಬ ವಿಷಯ ಈಜಿಪ್ಟಿನ ಅರಸನಿಗೆ ತಿಳಿಯಿತು. ಆಗ ಫರೋಹನ ಮತ್ತು ಅವನ ಸೇವಕರ ಹೃದಯವು ಅವರಿಗೆ ವಿರೋಧವಾಗಿ ತಿರುಗಿಕೊಂಡಿತು. ಅವರು, “ಇಸ್ರಾಯೇಲರು ನಮ್ಮ ಸೇವೆ ಮಾಡುವುದನ್ನು ಬಿಟ್ಟು ಹೋಗಿಬಿಡುವಂತೆ ನಾವು ಏಕೆ ಮಾಡಿದೆವು?” ಎಂದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ಆಗ ಫರೋಹನು ತನ್ನ ರಥವನ್ನು ಸಿದ್ಧಮಾಡಿ, ತನ್ನ ಸೈನ್ಯವನ್ನು ತನ್ನೊಂದಿಗೆ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ಇದಲ್ಲದೆ ಅವನು ಆರಿಸಿಕೊಂಡ ಅತ್ಯುತ್ತಮ ಆರುನೂರು ರಥಗಳನ್ನೂ, ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ರಥಗಳನ್ನೂ, ಅವುಗಳ ಮೇಲೆ ಅಧಿಪತಿಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ಈಜಿಪ್ಟಿನ ಅರಸನಾದ ಫರೋಹನ ಹೃದಯವನ್ನು ಯೆಹೋವ ದೇವರು ಕಠಿಣ ಮಾಡಿದ್ದರಿಂದ ಅವನು ಇಸ್ರಾಯೇಲರನ್ನು ಹಿಂದಟ್ಟಿದನು. ಆದರೆ ಇಸ್ರಾಯೇಲರು ಧೈರ್ಯದಿಂದ ಹೊರಗೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ಈಜಿಪ್ಟಿನವರು ಅವರನ್ನು ಹಿಂದಟ್ಟಿದರು. ಅವರು ಸಮುದ್ರ ತೀರದಲ್ಲಿ ಇಳಿದುಕೊಂಡಿರುವಾಗ, ಫರೋಹನ ಎಲ್ಲಾ ಕುದುರೆಗಳೂ ರಥಗಳೂ ಕುದುರೆ ಸವಾರರೂ ಅವನ ಸೈನ್ಯವೂ ಪೀಹಹೀರೋತಿನ ಸಮೀಪದಲ್ಲಿ ಬಾಲ್ಜೆಫೋನಿನ ಎದುರಾಗಿ ಇಸ್ರಾಯೇಲರನ್ನು ಸಮೀಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ಫರೋಹನು ಸಮೀಪಕ್ಕೆ ಬರುವುದನ್ನು ಇಸ್ರಾಯೇಲರು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದರು. ಈಜಿಪ್ಟಿನವರು ಅವರ ಹಿಂದೆ ಬರುತ್ತಿರುವುದನ್ನು ಕಂಡು ಇಸ್ರಾಯೇಲರು ಬಹಳ ಭಯಪಟ್ಟು ಯೆಹೋವ ದೇವರಿಗೆ ಮೊರೆಯಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ಅವರು ಮೋಶೆಗೆ, “ಈಜಿಪ್ಟಿನಲ್ಲಿ ಸಮಾಧಿಗಳು ಇಲ್ಲದ ಕಾರಣ ನಾವು ಮರುಭೂಮಿಯಲ್ಲಿ ಸಾಯುವ ಹಾಗೆ ನಮ್ಮನ್ನು ಕರೆದುಕೊಂಡು ಬಂದೆಯೋ? ಏಕೆ ನೀನು ಈ ಪ್ರಕಾರ ನಮಗೆ ಮಾಡಿ, ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದೆ? ");
INSERT INTO kanokcv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ನಾವು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿದ್ದಾಗಲೇ, ‘ನೀನು ನಮ್ಮ ಗೊಡವೆಗೆ ಬರಬೇಡ, ನಾವು ಈಜಿಪ್ಟಿನವರಿಗೆ ಸೇವೆಮಾಡುತ್ತೇವೆ,’ ಎಂದು ನಿನಗೆ ಹೇಳಲಿಲ್ಲವೇ? ನಾವು ಮರುಭೂಮಿಯಲ್ಲಿ ಸಾಯುವುದಕ್ಕಿಂತ ಈಜಿಪ್ಟಿನವರಿಗೆ ಸೇವೆ ಮಾಡುವುದೇ ಒಳ್ಳೆಯದಾಗಿತ್ತಲ್ಲಾ?” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ಅದಕ್ಕೆ ಮೋಶೆಯು ಜನರಿಗೆ, “ನೀವು ಭಯಪಡಬೇಡಿರಿ, ದೃಢವಾಗಿ ನಿಲ್ಲಿರಿ. ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ಈ ಹೊತ್ತು ತೋರಿಸುವ ರಕ್ಷಣೆಯನ್ನು ನೋಡಿರಿ. ನೀವು ಈ ಹೊತ್ತು ನೋಡುವ ಈಜಿಪ್ಟಿನವರನ್ನು ಇನ್ನು ಮುಂದೆ ಎಂದೆಂದಿಗೂ ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ಯೆಹೋವ ದೇವರು ನಿಮಗೋಸ್ಕರ ಯುದ್ಧಮಾಡುವರು, ಆದರೆ ನೀವು ವಿಶ್ರಾಂತಿಯಿಂದಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ನನಗೆ ಮೊರೆಯಿಡುವುದೇನು? ಇಸ್ರಾಯೇಲರಿಗೆ ಮುಂದಕ್ಕೆ ಹೊರಡಬೇಕೆಂದು ಹೇಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ನೀನು ನಿನ್ನ ಕೋಲನ್ನು ಎತ್ತಿ, ನಿನ್ನ ಕೈಯನ್ನು ಸಮುದ್ರದ ಮೇಲೆ ಚಾಚಿ, ಅದನ್ನು ವಿಭಾಗಿಸು. ಆಗ ಇಸ್ರಾಯೇಲರು ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲಿ ಒಣಗಿದ ನೆಲದ ಮೇಲೆ ಹೋಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ನಾನು ಈಜಿಪ್ಟಿನವರ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡುತ್ತೇನೆ. ಅವರು ಇವರನ್ನು ಹಿಂದಟ್ಟುವರು. ಇದಲ್ಲದೆ ಫರೋಹನ ಮೇಲೆಯೂ ಅವನ ಎಲ್ಲಾ ಸೈನ್ಯದ ಮೇಲೆಯೂ ಅವನ ರಥಗಳ ಮೇಲೆಯೂ ಕುದುರೆಯ ಸವಾರರ ಮೇಲೆಯೂ ನನ್ನನ್ನು ಘನಪಡಿಸಿಕೊಳ್ಳುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ನಾನು ಫರೋಹನ ಮೇಲೆಯೂ ಅವನ ರಥಗಳ ಮೇಲೆಯೂ ಅವನ ಕುದುರೆ ಸವಾರರ ಮೇಲೆಯೂ ನನ್ನನ್ನು ಘನಪಡಿಸಿಕೊಂಡಾಗ, ನಾನೇ ಯೆಹೋವ ದೇವರೆಂದು ಈಜಿಪ್ಟಿನವರು ತಿಳಿದುಕೊಳ್ಳುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ಆಗ ಇಸ್ರಾಯೇಲ್ ದಂಡಿನ ಮುಂದೆ ಹೋಗುತ್ತಿದ್ದ ದೇವದೂತನು ತನ್ನ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಅವರ ಹಿಂದೆ ಬಂದನು. ಅವರ ಮುಂದೆ ಇದ್ದ ಮೇಘಸ್ತಂಭವು ಅಲ್ಲಿಂದ ಬಂದು ಅವರ ಹಿಂದೆ ನಿಂತುಕೊಂಡಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ಅದು ಈಜಿಪ್ಟಿನ ದಂಡಿಗೂ ಇಸ್ರಾಯೇಲರ ದಂಡಿಗೂ ನಡುವೆ ಬಂದಿತು. ಮೇಘಸ್ತಂಭವು ಈಜಿಪ್ಟಿನವರಿಗೆ ಕತ್ತಲನ್ನೂ ಇಸ್ರಾಯೇಲರಿಗೆ ಬೆಳಕನ್ನೂ ನೀಡಿತು. ಆ ರಾತ್ರಿಯೆಲ್ಲಾ ಒಬ್ಬರ ಹತ್ತಿರ ಒಬ್ಬರು ಬರಲಾಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ಆಗ ಮೋಶೆಯು ಸಮುದ್ರದ ಮೇಲೆ ತನ್ನ ಬಲಗೈಯನ್ನು ಚಾಚಲಾಗಿ, ಯೆಹೋವ ದೇವರು ರಾತ್ರಿಯೆಲ್ಲಾ ಬಲವಾದ ಪೂರ್ವದಿಕ್ಕಿನ ಗಾಳಿಯಿಂದ ಸಮುದ್ರವನ್ನು ಹಿಂದಕ್ಕೆ ಹೋಗುವಂತೆ ಸಮುದ್ರವನ್ನು ಸರಿಸಿ, ಒಣ ನೆಲ ಕಾಣಿಸುವಂತೆ ಮಾಡಿದರು. ಆಗ ನೀರು ವಿಭಾಗವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ಹೀಗೆ ಇಸ್ರಾಯೇಲರು ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲಿ ಒಣಗಿದ ನೆಲದ ಮೇಲೆ ನಡೆದುಹೋದರು. ನೀರು ಅವರಿಗೆ ಎಡಗಡೆ ಮತ್ತು ಬಲಗಡೆಗಳಲ್ಲಿ ಗೋಡೆಯಾಗಿ ನಿಂತಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ಈಜಿಪ್ಟಿನವರೂ ಫರೋಹನ ಎಲ್ಲಾ ಕುದುರೆಗಳೂ ಅವನ ರಥಗಳೂ ಕುದುರೆ ಸವಾರರೂ ಅವರನ್ನು ಹಿಂದಟ್ಟಿ, ಅವರ ಹಿಂದೆ ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲಿ ಸೇರಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ಬೆಳಗಿನ ಜಾವದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಅಗ್ನಿ ಮೇಘಗಳ ಸ್ತಂಭದೊಳಗಿಂದ ಈಜಿಪ್ಟಿನ ದಂಡಿನ ಮೇಲೆ ದೃಷ್ಟಿಯಿಟ್ಟು, ಈಜಿಪ್ಟಿನ ದಂಡನ್ನು ಗಾಬರಿಗೊಳಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ಅವರ ರಥಗಳ ಚಕ್ರಗಳನ್ನು ತೆಗೆದುಬಿಟ್ಟು ಕಷ್ಟದಿಂದ ಅವರು ಹೋಗುವಂತೆ ಮಾಡಿದರು. ಆಗ ಈಜಿಪ್ಟಿನವರು, “ಇಸ್ರಾಯೇಲರ ಎದುರಿನಿಂದ ಓಡಿಹೋಗೋಣ. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟಿನವರಿಗೆ ವಿರೋಧವಾಗಿ ಯುದ್ಧಮಾಡುತ್ತಾರೆ,” ಎಂದು ಹೇಳಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಈಜಿಪ್ಟಿನವರನ್ನೂ ಅವರ ರಥಗಳ ಕುದುರೆಯ ಸವಾರರನ್ನೂ ಸಮುದ್ರವು ಮುಳುಗಿಸುವಂತೆ ಸಮುದ್ರದ ಮೇಲೆ ಕೈಚಾಚು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ಆಗ ಮೋಶೆಯು ಸಮುದ್ರದ ಮೇಲೆ ಕೈಚಾಚಲಾಗಿ ಸಮುದ್ರವು ಬೆಳಗಾಗುವಾಗಲೇ ಮೊದಲಿನಂತೆ ತುಂಬಿಕೊಂಡಿತು. ಈಜಿಪ್ಟಿನವರು ಓಡಿಹೋಗುತ್ತಾ ಅದಕ್ಕೆ ಎದುರಾಗಿಯೇ ಬಂದರು. ಹೀಗೆ ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟಿನವರನ್ನು ಸಮುದ್ರದೊಳಗೆ ಕೆಡವಿಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ನೀರು ತಿರುಗಿಬಂದು ರಥಗಳೂ ಕುದುರೆಗಳೂ ಸವಾರರೂ ಅವರ ಹಿಂದೆ ಸಮುದ್ರದಲ್ಲಿ ಬರುತ್ತಿದ್ದ ಫರೋಹನ ಎಲ್ಲಾ ಸೈನ್ಯವೂ ಹೀಗೆ ಒಬ್ಬರೂ ಉಳಿಯದಂತೆ ಮುಳುಗಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ಆದರೆ ಇಸ್ರಾಯೇಲರು ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲಿದ್ದ ಒಣಗಿದ ನೆಲದ ಮೇಲೆ ನಡೆದುಹೋದರು. ನೀರು ಅವರಿಗೆ ಎಡಗಡೆ ಮತ್ತು ಬಲಗಡೆಗಳಲ್ಲಿ ಗೋಡೆಯಂತಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ಆ ದಿನದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಈ ಪ್ರಕಾರ ಇಸ್ರಾಯೇಲರನ್ನು ಈಜಿಪ್ಟಿನವರ ಕೈಯಿಂದ ರಕ್ಷಿಸಿದರು. ಇಸ್ರಾಯೇಲರು ಸಮುದ್ರ ತೀರದಲ್ಲಿ ಸತ್ತ ಈಜಿಪ್ಟಿನವರನ್ನು ನೋಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ಈಜಿಪ್ಟಿನವರ ಮೇಲೆ ಯೆಹೋವ ದೇವರು ಮಾಡಿದ ದೊಡ್ಡ ಕಾರ್ಯವನ್ನು ನೋಡಿದಾಗ, ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರಿಗೆ ಭಯಪಟ್ಟು, ಅವರಲ್ಲಿಯೂ ಅವರ ಸೇವಕನಾದ ಮೋಶೆಯಲ್ಲಿಯೂ ನಂಬಿಕೆಯಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ಆಗ ಮೋಶೆ ಮತ್ತು ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರಿಗೆ ಈ ಹಾಡನ್ನು ಹಾಡಿದರು: “ನಾನು ಯೆಹೋವ ದೇವರಿಗೆ ಹಾಡುತ್ತೇನೆ. ಏಕೆಂದರೆ ಅವರು ಪ್ರಭಾವದಿಂದ ಜಯಶಾಲಿಯಾದರು. ಕುದುರೆಗಳನ್ನೂ ರಾಹುತರನ್ನೂ ಸಮುದ್ರದಲ್ಲಿ ದಬ್ಬಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“ಯೆಹೋವ ದೇವರು ನನ್ನ ಬಲವೂ ಕೀರ್ತನೆಯೂ ಆಗಿದ್ದಾರೆ; ಅವರು ನನ್ನ ರಕ್ಷಣೆಯಾದರು; ಅವರು ನನ್ನ ದೇವರು, ಅವರನ್ನು ಕೊಂಡಾಡುವೆನು; ಅವರು ನನ್ನ ತಂದೆಯ ದೇವರು, ನಾನು ಅವರನ್ನು ಘನಪಡಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ಯೆಹೋವ ದೇವರು ಯುದ್ಧವೀರರು; ಯೆಹೋವ ದೇವರು ಎಂಬುದೇ ಅವರ ಹೆಸರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ಅವರು ಫರೋಹನ ರಥಗಳನ್ನೂ, ಅವನ ಸ್ಯೆನ್ಯವನ್ನೂ ಸಮುದ್ರದಲ್ಲಿ ಅಲ್ಲಾಡಿಸಿ ಎಸೆದಿದ್ದಾರೆ. ಫರೋಹನ ಅತ್ಯುತ್ತಮ ಅಧಿಕಾರಿಗಳು ಸಹ ಕೆಂಪು ಸಮುದ್ರದಲ್ಲಿ ಮುಳುಗಿ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ಆಳವಾದ ಜಲರಾಶಿ ಅವರನ್ನು ಮುಚ್ಚಿಕೊಂಡವು. ಅವರು ಕಲ್ಲಿನಂತೆ ಸಮುದ್ರದ ತಳಕ್ಕೆ ಮುಳುಗಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ಯೆಹೋವ ದೇವರೇ, ನಿಮ್ಮ ಬಲಗೈ ಶಕ್ತಿಯಲ್ಲಿ ಮಹಿಮೆಯುಳ್ಳದ್ದಾಗಿದೆ; ಯೆಹೋವ ದೇವರೇ, ನಿಮ್ಮ ಬಲಗೈ ಶತ್ರುವನ್ನು ಜಜ್ಜಿ ಪುಡಿ ಮಾಡಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“ನಿಮ್ಮ ಮಹತ್ತಾದ ಘನತೆಯಲ್ಲಿ ನಿಮಗೆ ವಿರೋಧವಾಗಿ ಎದ್ದವರನ್ನು ಕೆಡವಿಬಿಟ್ಟಿರುವಿರಿ. ನಿಮ್ಮ ಕೋಪವು ಬೆಂಕಿಯಂತೆ ಕಾರಿದೆ; ಅದು ಅವರನ್ನು ಕೋಲಿನಂತೆ ದಹಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ನೀವು ಬೀಸಿದ ಬಿರುಸಾದ ಗಾಳಿಯಿಂದ ನೀರು ಒಟ್ಟುಗೂಡಿದವು. ಪ್ರವಾಹಗಳು ರಾಶಿಯಂತೆ ನಿಂತವು. ಜಲರಾಶಿಗಳು ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲಿ ಗಟ್ಟಿಯಾದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ಶತ್ರುವು ಹೆಮ್ಮೆಯಿಂದ ಹೀಗೆ ಮಾತನಾಡಿಕೊಳ್ಳುತ್ತಿದ್ದರು, ‘ನಾನು ಹಿಂದಟ್ಟುವೆನು, ಅವರನ್ನು ಹಿಡಿಯುವೆನು, ನಾನು ಅವರ ಕೊಳ್ಳೆಯನ್ನು ಹಂಚುವೆನು; ನನ್ನ ಆಶೆಗಳು ಅವರಿಂದ ತೃಪ್ತಿ ಹೊಂದುವುವು; ನಾನು ನನ್ನ ಖಡ್ಗವನ್ನು ಹಿರಿಯುವೆನು; ನನ್ನ ಕೈ ಅವರನ್ನು ಸಂಹಾರ ಮಾಡುವುದು.’ ");
INSERT INTO kanokcv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ನೀವು ನಿಮ್ಮ ಶ್ವಾಸ ಊದಿದಾಗ ಸಮುದ್ರವು ಅವರನ್ನು ನುಂಗಿಕೊಂಡಿತು. ಅವರು ಸೀಸದಂತೆ ಮಹಾಸಾಗರದಲ್ಲಿ ಮುಳುಗಿ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ಯೆಹೋವ ದೇವರೇ, ನಿಮ್ಮ ಹಾಗೆ ಯಾರಿದ್ದಾರೆ? ಪರಿಶುದ್ಧತ್ವದಲ್ಲಿ ವೈಭವ ಹೊಂದಿದವರೂ, ಮಹಿಮೆಯಲ್ಲಿ ಅತಿಶಯರೂ, ಅದ್ಭುತಗಳನ್ನು ಮಾಡುವವರೂ ಆದ ನಿಮ್ಮ ಹಾಗೆ ಯಾರಿದ್ದಾರೆ? ");
INSERT INTO kanokcv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“ನೀವು ನಿಮ್ಮ ಬಲಗೈಯನ್ನು ಚಾಚಲು ಭೂಮಿಯು ಅವರನ್ನು ನುಂಗಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ನೀವು ವಿಮೋಚಿಸಿದ ಜನರನ್ನು ನೀವು ನಿಮ್ಮ ಪ್ರೀತಿಯಿಂದ ನಡೆಸಿದ್ದೀರಿ. ನೀವು ಅವರನ್ನು ನಿಮ್ಮ ಬಲದಿಂದ ನಿಮ್ಮ ಪರಿಶುದ್ಧ ನಿವಾಸಕ್ಕೆ ನಡೆಸಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ಜನರು ಇದನ್ನು ಕೇಳಿದಾಗ ಭಯಪಡುವರು. ದುಃಖವು ಫಿಲಿಷ್ಟಿಯದಲ್ಲಿ ವಾಸಿಸುವವರನ್ನು ಹಿಡಿಯುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ಆಗ ಎದೋಮಿನ ಪ್ರಭುಗಳು ದಿಗ್ಭ್ರಮೆಗೊಳ್ಳುವರು; ಕಂಪನವು ಮೋವಾಬಿನ ಬಲಿಷ್ಠರನ್ನು ಹಿಡಿಯುವುದು; ಕಾನಾನಿನ ನಿವಾಸಿಗಳೆಲ್ಲಾ ಕರಗಿ ಹೋಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ಭಯವೂ ಹೆದರಿಕೆಯೂ ಅವರಿಗಾಗುವುದು; ನಿಮ್ಮ ಜನರು ದಾಟಿ ಹೋಗುವವರೆಗೆ ಯೆಹೋವ ದೇವರೇ, ನೀವು ಕೊಂಡುಕೊಂಡ ಜನರು ದಾಟಿಹೋಗುವವರೆಗೆ ನಿಮ್ಮ ಬಾಹುವಿನ ದೊಡ್ಡಸ್ತಿಕೆಯಿಂದ ಅವರು ಕಲ್ಲಿನಂತೆ ಸ್ತಬ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ಅವರನ್ನು ಒಳಗೆ ಬರಮಾಡಿ, ಯೆಹೋವ ದೇವರೇ, ನಿಮ್ಮ ಕೈಗಳು ಸ್ಥಾಪಿಸಿದ ಪರಿಶುದ್ಧ ನಿವಾಸದಲ್ಲಿಯೂ ಯೆಹೋವ ದೇವರೇ, ನೀವು ವಾಸಿಸುವುದಕ್ಕೆ ಮಾಡಿಕೊಂಡಿರುವ ನಿಮ್ಮ ಸ್ವತ್ತಾಗಿರುವ ಪರ್ವತದಲ್ಲಿಯೂ ಅವರನ್ನು ಸ್ಥಾಪಿಸುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“ಯೆಹೋವ ದೇವರು ಯುಗಯುಗಾಂತರಗಳವರೆಗೆ ಆಳುವರು.” ");
INSERT INTO kanokcv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ಫರೋಹನ ಕುದುರೆಗಳು ಅವನ ರಥಗಳ ಮತ್ತು ಸವಾರರ ಸಂಗಡ ಸಮುದ್ರದೊಳಗೆ ಬಂದಾಗ, ಯೆಹೋವ ದೇವರು ಸಮುದ್ರದ ನೀರನ್ನು ಅವರ ಮೇಲೆ ತಿರುಗಿ ಬರಮಾಡಿದರು. ಆದರೆ ಇಸ್ರಾಯೇಲರು ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲಿನ ಒಣನೆಲದ ಮೇಲೆ ದಾಟಿಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ಆಗ ಪ್ರವಾದಿನಿಯಾಗಿದ್ದ ಆರೋನನ ಸಹೋದರಿ ಮಿರ್ಯಾಮಳು ಕೈಯಲ್ಲಿ ತಾಳವನ್ನು ತೆಗೆದುಕೊಂಡಳು. ಸ್ತ್ರೀಯರೆಲ್ಲರೂ ತಾಳಗಳನ್ನು ಹಿಡಿದುಕೊಂಡು ನಾಟ್ಯವಾಡುತ್ತಾ, ಆಕೆಯನ್ನು ಹಿಂಬಾಲಿಸಿ ಹೊರಹೊರಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ಮಿರ್ಯಾಮಳು ಅವರಿಗೆ ಹೀಗೆ ಹಾಡಿದಳು: “ಯೆಹೋವ ದೇವರಿಗೆ ನೀವು ಹಾಡಿರಿ, ಅವರು ಮಹೋನ್ನತದಲ್ಲಿದ್ದಾರೆ; ಕುದುರೆಯನ್ನೂ ಸವಾರರನ್ನೂ ಸಮುದ್ರದಲ್ಲಿ ಮುಣುಗಿಸಿಬಿಟ್ಟರು.” ");
INSERT INTO kanokcv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ಆಮೇಲೆ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರನ್ನು ಕೆಂಪು ಸಮುದ್ರದಿಂದ ನಡೆಸಿದನು. ಅವರು ಶೂರಿನ ಮರುಭೂಮಿಯೊಳಗೆ ಹೋದರು. ಅವರು ಮರುಭೂಮಿಯಲ್ಲಿ ಮೂರು ದಿನಗಳು ಪ್ರಯಾಣಮಾಡಿದರೂ ನೀರನ್ನು ಕಂಡುಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ಅವರು ಮಾರಾ ಎಂಬಲ್ಲಿಗೆ ಬಂದ ಮೇಲೆ ಅಲ್ಲಿಯ ನೀರನ್ನು ಕುಡಿಯಲಾರದೆ ಇದ್ದರು; ಅದು ಕಹಿಯಾಗಿತ್ತು. ಆದಕಾರಣ ಅದರ ಹೆಸರು “ಮಾರಾ” ಎಂದು ಕರೆಯಲಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ಆದ್ದರಿಂದ ಜನರು, “ನಾವು ಏನು ಕುಡಿಯೋಣ?” ಎಂದು ಹೇಳಿ, ಮೋಶೆಗೆ ವಿರೋಧವಾಗಿ ಗೊಣಗುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ಅವನು ಯೆಹೋವ ದೇವರಿಗೆ ಮೊರೆಯಿಟ್ಟನು. ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ ಒಂದು ಗಿಡವನ್ನು ತೋರಿಸಿದರು. ಅವನು ಅದನ್ನು ನೀರಿನಲ್ಲಿ ಹಾಕಿದಾಗ, ನೀರು ಸಿಹಿಯಾಗಿ ಬಿಟ್ಟಿತು. ಅಲ್ಲಿ ದೇವರು ಅವರಿಗಾಗಿ ಒಂದು ನಿಯಮವನ್ನೂ ಒಂದು ಶಾಸನವನ್ನೂ ಮಾಡಿದರು. ಅಲ್ಲಿಯೇ ದೇವರು ಅವರನ್ನು ಪರೀಕ್ಷಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ದೇವರು, “ನೀವು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರ ಮಾತಿಗೆ ಶ್ರದ್ಧೆಯಿಂದ ಕಿವಿಗೊಟ್ಟು, ಅವರ ದೃಷ್ಟಿಯಲ್ಲಿ ಸರಿಯಾದದ್ದನ್ನು ಮಾಡಿ, ಅವರ ಆಜ್ಞೆಗಳಿಗೆ ಕಿವಿಗೊಟ್ಟು, ಅವರ ನಿಯಮಗಳನ್ನು ಕೈಗೊಂಡರೆ, ಈಜಿಪ್ಟಿನ ಮೇಲೆ ಬರಮಾಡಿದ ಯಾವ ವ್ಯಾಧಿಯನ್ನೂ ನಿಮ್ಮ ಮೇಲೆ ಬರಮಾಡುವುದಿಲ್ಲ. ನಿಮ್ಮನ್ನು ಸ್ವಸ್ಥಪಡಿಸುವ ಯೆಹೋವ ದೇವರು ನಾನೇ ಆಗಿದ್ದೇನೆ,” ಎಂದು ಪ್ರಕಟಪಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ತರುವಾಯ ಇಸ್ರಾಯೇಲರು ಏಲೀಮಿಗೆ ಬಂದರು. ಅಲ್ಲಿ ಹನ್ನೆರಡು ನೀರಿನ ಬಾವಿಗಳೂ ಎಪ್ಪತ್ತು ಖರ್ಜೂರದ ಮರಗಳೂ ಇದ್ದವು. ಅವರು ಆ ನೀರಿನ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ಇಸ್ರಾಯೇಲರ ಸಭೆಯೆಲ್ಲಾ ಏಲೀಮಿನಿಂದ ಪ್ರಯಾಣಮಾಡಿ, ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಹೊರಟ ಎರಡನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ಏಲೀಮಿಗೂ, ಸೀನಾಯಿ ಪರ್ವತಕ್ಕೂ ಮಧ್ಯೆ ಇರುವ ಸೀನ್ ಮರುಭೂಮಿಗೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ಆಗ ಇಸ್ರಾಯೇಲರ ಸಭೆಯೆಲ್ಲಾ ಮರುಭೂಮಿಯಲ್ಲಿ ಮೋಶೆ ಮತ್ತು ಆರೋನರ ವಿರೋಧವಾಗಿ ಗೊಣಗುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ಇಸ್ರಾಯೇಲರು ಅವರಿಗೆ, “ನಾವು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಮಾಂಸದ ಪಾತ್ರೆಗಳ ಬಳಿಯಲ್ಲಿ ಕುಳಿತುಕೊಂಡು ಸಾಕಾಗುವಷ್ಟು ರೊಟ್ಟಿಯನ್ನು ತಿನ್ನುತ್ತಿದ್ದಾಗ, ಯೆಹೋವ ದೇವರ ಕೈಯಿಂದ ಸತ್ತು ಹೋಗಿದ್ದರೆ ಒಳ್ಳೆಯದಾಗಿತ್ತು. ಇಡೀ ಜನಾಂಗವೇ ಹಸಿವೆಯಿಂದ ಸತ್ತು ಹೋಗುವಂತೆ ನಮ್ಮನ್ನು ಈ ಮರುಭೂಮಿಗೆ ಬರಮಾಡಿದ್ದೀರಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನಾನು ರೊಟ್ಟಿಯನ್ನು ನಿಮಗಾಗಿ ಆಕಾಶದಿಂದ ಸುರಿಸುತ್ತೇನೆ. ಜನರು ಹೊರಗೆ ಹೋಗಿ ಪ್ರತಿದಿನ ಆ ದಿನಕ್ಕೆ ಬೇಕಾದದ್ದನ್ನು ಕೂಡಿಸಲಿ. ಇದರಿಂದ ಅವರು ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಕೈಗೊಳ್ಳುವರೋ, ಇಲ್ಲವೋ ಎಂಬುದನ್ನು ಪರೀಕ್ಷಿಸುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ಆರನೆಯ ದಿವಸದಲ್ಲಿ ಮಾತ್ರ ಅವರು ತಂದದ್ದನ್ನು ಸಿದ್ಧಪಡಿಸಿಕೊಳ್ಳುವಾಗ, ಪ್ರತಿದಿನ ಕೂಡಿಸುವುದಕ್ಕಿಂತಲೂ ಎರಡರಷ್ಟಾಗಿರುವುದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ಆಗ ಮೋಶೆ, ಆರೋನರು ಇಸ್ರಾಯೇಲರಿಗೆಲ್ಲಾ, “ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದವರು ಯೆಹೋವ ದೇವರೇ, ಎಂದು ಸಾಯಂಕಾಲವಾದಾಗ ನಿಮಗೆ ತಿಳಿಯುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ಬೆಳಿಗ್ಗೆ ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯನ್ನು ನೋಡುವಿರಿ. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರಿಗೆ ವಿರೋಧವಾಗಿ ನೀವು ಗೊಣಗುಟ್ಟಿದ್ದನ್ನು ಅವರು ಕೇಳಿದ್ದಾರೆ. ನಮಗೆ ವಿರೋಧವಾಗಿ ನೀವು ಗೊಣಗುಟ್ಟುವ ಹಾಗೆ ನಾವು ಯಾರು?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ಮೋಶೆ ಮುಂದುವರಿಸಿ, “ಸಂಜೆಯಲ್ಲಿ ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ಮಾಂಸಾಹಾರವನ್ನೂ, ಬೆಳಿಗ್ಗೆ ಬೇಕಾದಷ್ಟು ರೊಟ್ಟಿಯನ್ನೂ ಕೊಡುವರು. ನಿಮ್ಮ ಗೊಣಗುಟ್ಟುವಿಕೆಯು ಯೆಹೋವ ದೇವರಿಗೆ ಹೊರತು ನಮಗಲ್ಲ. ನಾವು ಎಷ್ಟು ಮಾತ್ರದವರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ಅನಂತರ ಮೋಶೆ ಆರೋನನಿಗೆ, “ನೀನು ಇಸ್ರಾಯೇಲರ ಸಮೂಹಕ್ಕೆ, ‘ನಿಮ್ಮ ಗೊಣಗುಟ್ಟುವಿಕೆಯನ್ನು ಯೆಹೋವ ದೇವರು ಕೇಳಿದ್ದರಿಂದ ನೀವು ಅವರ ಮುಂದೆ ಬನ್ನಿರಿ,’ ಎಂದು ಹೇಳು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ಆರೋನನು ಇಸ್ರಾಯೇಲರ ಸಭೆಯ ಸಂಗಡ ಮಾತನಾಡುತ್ತಿದ್ದಾಗ ಅವರು ಮರುಭೂಮಿಯ ಕಡೆಗೆ ನೋಡಿದರು. ಆಗ, ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯು ಮೇಘದಲ್ಲಿ ಪ್ರತ್ಯಕ್ಷವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“ಇಸ್ರಾಯೇಲರ ಗೊಣಗುಟ್ಟುವಿಕೆಯನ್ನು ಕೇಳಿದ್ದೇನೆ. ಅವರ ಸಂಗಡ ನೀನು ಮಾತನಾಡಿ, ‘ನೀವು ಸಂಜೆಯಲ್ಲಿ ಮಾಂಸವನ್ನು ತಿನ್ನುವಿರಿ. ಬೆಳಿಗ್ಗೆ ರೊಟ್ಟಿಯಿಂದ ತೃಪ್ತರಾಗುವಿರಿ. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರೆಂದು ತಿಳಿದುಕೊಳ್ಳುವಿರಿ,’ ಎಂದು ಅವರಿಗೆ ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ಸಂಜೆಯಲ್ಲಿ ಲಾವಕ್ಕಿಗಳು ಬಂದು ಅವರ ಪಾಳೆಯವನ್ನು ಮುಚ್ಚಿಕೊಂಡವು. ಬೆಳಿಗ್ಗೆ ಮಂಜು ಪಾಳೆಯದ ಸುತ್ತಲೂ ಬಿದ್ದಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ಬಿದ್ದಿದ್ದ ಮಂಜು ಹೋದ ಮೇಲೆ, ಗಟ್ಟಿಯಾದ ಪದಾರ್ಥವು ಮಂಜಿನ ಹನಿಯಷ್ಟು ಚಿಕ್ಕದಾದದ್ದೂ, ಗುಂಡಾದದ್ದೂ ಮರುಭೂಮಿಯಲ್ಲಿ ಹರಡಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ಇಸ್ರಾಯೇಲರು ಅದನ್ನು ನೋಡಿದಾಗ ಅವರು, ಒಬ್ಬರಿಗೊಬ್ಬರು, “ಇದೇನು?” ಎಂದರು. ಏಕೆಂದರೆ ಅದು ಏನಾಗಿತ್ತೆಂದು ಅವರಿಗೆ ತಿಳಿಯಲಿಲ್ಲ. ಆಗ ಮೋಶೆಯು ಅವರಿಗೆ, “ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ಕೊಟ್ಟಿರುವ ರೊಟ್ಟಿಯು ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ಯೆಹೋವ ದೇವರು, ‘ಪ್ರತಿಯೊಬ್ಬನು ತಾನು ಎಷ್ಟು ತಿನ್ನುವನೋ ಅದರ ಪ್ರಕಾರ ಅದನ್ನು ಕೂಡಿಸಲಿ. ಪ್ರತಿಯೊಬ್ಬನಿಗೆ ಸುಮಾರು ಒಂದು ಕಿಲೋಗ್ರಾಂದಷ್ಟು ನಿಮ್ಮ ಡೇರೆಗಳಲ್ಲಿರುವ ವ್ಯಕ್ತಿಗಳ ಲೆಕ್ಕದ ಪ್ರಕಾರ ನೀವು ತೆಗೆದುಕೊಳ್ಳಿರಿ,’ ಎಂದು ಹೇಳಿದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ಇಸ್ರಾಯೇಲರು ಅದರಂತೆ ಮಾಡಿ ಕೆಲವರು ಹೆಚ್ಚು, ಕೆಲವರು ಕಡಿಮೆ ಕೂಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ಓಮೆರದಿಂದ ಅಳತೆಮಾಡಿದಾಗ, ಅತಿಯಾಗಿ ಕೂಡಿಸಿದವನಿಗೆ ಹೆಚ್ಚಾಗಲಿಲ್ಲ, ಮಿತವಾಗಿ ಕೂಡಿಸಿದವನಿಗೆ ಕೊರತೆಯಾಗಲಿಲ್ಲ. ಒಬ್ಬೊಬ್ಬನು ಊಟಮಾಡುವಷ್ಟು ಅವರು ಕೂಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ಮೋಶೆ ಅವರಿಗೆ, “ಇದನ್ನು ಯಾರೂ ಮರುದಿನದವರೆಗೆ ಇಟ್ಟುಕೊಳ್ಳಬಾರದು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ಆದರೂ ಅವರು ಮೋಶೆಯ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ಕೆಲವರು ಅದನ್ನು ಬೆಳಗಿನವರೆಗೆ ಇಟ್ಟುಕೊಂಡಾಗ, ಅದು ಹುಳ ಬಿದ್ದು ಹೊಲಸುವಾಸನೆ ಹುಟ್ಟಿತು. ಆಗ ಮೋಶೆಯು ಅವರ ಮೇಲೆ ಕೋಪಿಸಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ಹೀಗೆ ಅವರಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ತಿನ್ನುವಷ್ಟು ಪ್ರತಿದಿನದ ಬೆಳಿಗ್ಗೆ ಅದನ್ನು ಕೂಡಿಸುತ್ತಿದ್ದರು. ಬಿಸಿಲು ಬಹಳವಾದಾಗ ಅದು ಕರಗಿ ಹೋಗುತ್ತಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ಆರನೆಯ ದಿನದಲ್ಲಿ ಅವರು ಎರಡರಷ್ಟು ಅಂದರೆ ಒಬ್ಬನಿಗೆ ಎರಡು ಓಮೆರದಂತೆ ಕೂಡಿಸಿದ್ದರಿಂದ ಸಭೆಯ ಎಲ್ಲಾ ಅಧಿಕಾರಿಗಳು ಬಂದು ಮೋಶೆಗೆ ತಿಳಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ಅದಕ್ಕೆ ಮೋಶೆ, “ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ಮಾತು ಇದೇ: ‘ನಾಳೆ ಯೆಹೋವ ದೇವರಿಗೆ ಪರಿಶುದ್ಧ ಸಬ್ಬತ್ ದಿನವಾಗಿದೆ. ಇಂದೇ ಸುಡಬೇಕಾದದ್ದನ್ನು ಸುಟ್ಟು, ಬೇಯಿಸಬೇಕಾದದ್ದನ್ನು ಬೇಯಿಸಿರಿ. ಇದರಲ್ಲಿ ಮಿಕ್ಕಾದದ್ದನ್ನೆಲ್ಲಾ ಬೆಳಗಿನವರೆಗೆ ಇಟ್ಟುಕೊಳ್ಳಿರಿ,’ ” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ಮೋಶೆಯು ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಅದನ್ನು ಮರುದಿನದವರೆಗೆ ಇಟ್ಟುಕೊಂಡಾಗ, ಅದು ಹೊಲಸುವಾಸನೆ ಹೊಂದಲಿಲ್ಲ. ಅದರಲ್ಲಿ ಹುಳಗಳೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ಆಗ ಮೋಶೆಯು, “ಈ ಹೊತ್ತು ಅದನ್ನು ಊಟಮಾಡಿರಿ. ಏಕೆಂದರೆ ಈ ದಿನವು ಯೆಹೋವ ದೇವರ ಸಬ್ಬತ್ ದಿನವಾಗಿದೆ. ಈ ಹೊತ್ತು ನಿಮಗೆ ಹೊಲದಲ್ಲಿ ಆಹಾರ ಸಿಕ್ಕುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ಆರು ದಿವಸ ಅದನ್ನು ಕೂಡಿಸಬೇಕು. ಏಳನೆಯ ದಿನ ಸಬ್ಬತ್ ದಿನವಾಗಿರುವುದರಿಂದ ಅದು ದೊರೆಯುವುದಿಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ಏಳನೆಯ ದಿನ ಜನರಲ್ಲಿ ಕೆಲವರು ಕೂಡಿಸುವುದಕ್ಕೆ ಹೊರಗೆ ಹೋದಾಗ, ಅವರಿಗೆ ಏನೂ ಸಿಕ್ಕಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಎಷ್ಟು ಕಾಲ ನನ್ನ ಕಟ್ಟಳೆಗಳನ್ನೂ, ನಿಯಮಗಳನ್ನೂ ಕೈಗೊಳ್ಳದೆ ನಿರಾಕರಿಸುವಿರಿ? ");
INSERT INTO kanokcv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ನೋಡಿರಿ, ಯೆಹೋವ ದೇವರಾದ ನಾನು ನಿಮಗೆ ಸಬ್ಬತ್ ದಿನವನ್ನು ಕೊಟ್ಟಿದ್ದರಿಂದಲೇ, ಆರನೆಯ ದಿನದಲ್ಲಿ ನಿಮಗೆ ಎರಡು ದಿನಗಳಿಗೆ ಸಾಕಾಗುವಷ್ಟು ಆಹಾರ ಕೊಟ್ಟಿದ್ದೇನೆ. ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ತನ್ನ ಸ್ಥಳದಲ್ಲಿ ಇರಲಿ. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾರೂ ತನ್ನ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟುಹೋಗಬಾರದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ಹೀಗೆ ಜನರು ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ಇಸ್ರಾಯೇಲರು ಆ ಆಹಾರಕ್ಕೆ ಮನ್ನಾ, ಎಂದು ಹೆಸರಿಟ್ಟರು. ಅದು ಕೊತ್ತಂಬರಿ ಬೀಜದಂತೆ ಬೆಳ್ಳಗಿತ್ತು. ಅದರ ರುಚಿಯು ಜೇನುತುಪ್ಪ ಕಲಸಿದ ದೋಸೆಯಂತೆ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ಮೋಶೆಯು ಅವರಿಗೆ, “ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ್ದು ಇದೇ: ‘ನಾನು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಡಿಸಿದಾಗ, ಮರುಭೂಮಿಯಲ್ಲಿ ನಿಮಗೆ ತಿನ್ನಿಸಿದ ರೊಟ್ಟಿಯನ್ನು ನಿಮ್ಮ ಸಂತಾನಗಳು ನೋಡುವಂತೆ ಒಂದು ಓಮೆರ್ ಮನ್ನವನ್ನು ತುಂಬಿಸಿ ಇಟ್ಟಿರಬೇಕು,’ ಎಂಬುದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ಮೋಶೆ ಆರೋನನಿಗೆ, “ನೀನು ಒಂದು ಪಾತ್ರೆಯನ್ನು ತೆಗೆದುಕೊಂಡು ಒಂದು ಓಮೆರ್ ಮನ್ನವನ್ನು ಅದರಲ್ಲಿ ಹಾಕಿ ನಿಮ್ಮ ಸಂತತಿಯವರು ನೋಡುವುದಕ್ಕೋಸ್ಕರ ಅದನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಇಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಆರೋನನು ಮನ್ನವನ್ನು ಸಂರಕ್ಷಿಸುವುದಕ್ಕೆ ಸಾಕ್ಷಿಯಾಗಿ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ಇಸ್ರಾಯೇಲರು ತಾವು ವಾಸವಾಗಿರತಕ್ಕ ದೇಶಕ್ಕೆ ಬರುವವರೆಗೆ, ನಲವತ್ತು ವರುಷ ಮನ್ನವನ್ನು ತಿಂದರು. ಕಾನಾನ್ ದೇಶದ ಮೇರೆಗಳಿಗೆ ಸೇರುವವರೆಗೂ ಅವರು ಮನ್ನವನ್ನು ತಿಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ಓಮೆರ್ ಎಂದರೆ ಏಫಾದಲ್ಲಿ ಹತ್ತನೆಯ ಒಂದು ಪಾಲು ಹಿಡಿಯುವಂಥ ಅಳತೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ಇಸ್ರಾಯೇಲ್ ಸಮೂಹವೆಲ್ಲಾ ಯೆಹೋವ ದೇವರ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಅವರವರು ಹೊರಡುವ ಕ್ರಮದಂತೆ ಸೀನ್ ಮರುಭೂಮಿಯಿಂದ ಹೊರಟು ರೆಫೀದೀಮಿನಲ್ಲಿ ತಂಗಿದರು. ಅಲ್ಲಿ ಜನರಿಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ನೀರು ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ಆದಕಾರಣ ಜನರು ಮೋಶೆಯ ಸಂಗಡ ವಿವಾದ ಮಾಡಿ, “ನಮಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ನೀರು ಕೊಡು,” ಎಂದರು. ಮೋಶೆಯು ಅವರಿಗೆ, “ಏಕೆ ನನ್ನ ಸಂಗಡ ವಿವಾದ ಮಾಡುತ್ತೀರಿ? ಯೆಹೋವ ದೇವರನ್ನು ಏಕೆ ಪರೀಕ್ಷಿಸುತ್ತೀರಿ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ಅಲ್ಲಿ ಜನರು ದಾಹಗೊಂಡು ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ಗೊಣಗುಟ್ಟಿ, “ನಮ್ನನ್ನೂ, ನಮ್ಮ ಮಕ್ಕಳನ್ನೂ, ನಮ್ಮ ಪಶುಗಳನ್ನೂ ದಾಹದಿಂದ ಕೊಲ್ಲುವುದಕ್ಕಾಗಿ ಏಕೆ ಈಜಿಪ್ಟಿನೊಳಗಿಂದ ಇಲ್ಲಿಗೆ ಬರಮಾಡಿದೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ಆಗ ಮೋಶೆಯು ಯೆಹೋವ ದೇವರಿಗೆ ಮೊರೆಯಿಟ್ಟು, “ಈ ಜನರಿಗೆ ನಾನೇನು ಮಾಡಲಿ? ಅವರು ಬಹಳಮಟ್ಟಿಗೆ ನನಗೆ ಕಲ್ಲೆಸೆಯುವುದಕ್ಕಿದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಜನರ ಮುಂದೆ ಹಾದು ಹೋಗಿ ಇಸ್ರಾಯೇಲಿನ ಹಿರಿಯರಲ್ಲಿ ಕೆಲವರನ್ನು ಕರಕೊಂಡು ನೀನು ನೈಲ್ ನದಿಯನ್ನು ಹೊಡೆದ ಕೋಲನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಹೋಗು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ಅಲ್ಲಿ, ನಾನು ಹೋರೇಬಿನಲ್ಲಿ ಬಂಡೆಯ ಮೇಲೆ ನಿನ್ನ ಮುಂದೆ ನಿಂತುಕೊಳ್ಳುವೆನು, ನೀನು ಬಂಡೆಯನ್ನು ಹೊಡೆಯಬೇಕು. ಆಗ ಜನರು ಕುಡಿಯುವಂತೆ ನೀರು ಹೊರಗೆ ಬರುವುದು,” ಎಂದರು. ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರ ಎದುರಿನಲ್ಲಿ ಹಾಗೆಯೇ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","“ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಇದ್ದಾನೋ ಇಲ್ಲವೋ,” ಎಂದು ಜನರು ಪರೀಕ್ಷಿಸಿದ್ದರಿಂದ ಮೋಶೆ ಆ ಸ್ಥಳಕ್ಕೆ ಮಸ್ಸಾ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಅಲ್ಲಿ ಇಸ್ರಾಯೇಲರು ತನ್ನೊಡನೆ ವಿವಾದ ಮಾಡಿದ್ದರಿಂದ ಮೆರೀಬಾ ಎಂತಲೂ ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ಅಮಾಲೇಕ್ಯರು ಬಂದು ರೆಫೀದೀಮಿನಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಯುದ್ಧಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ಆಗ ಮೋಶೆಯು ಯೆಹೋಶುವನಿಗೆ, “ನೀನು ನಮ್ಮ ಜನರಲ್ಲಿ ಕೆಲವರನ್ನು ಆರಿಸಿಕೊಂಡು ಅಮಾಲೇಕ್ಯರ ಸಂಗಡ ಯುದ್ಧಮಾಡುವುದಕ್ಕೆ ಹೋಗು. ನಾಳೆ ನಾನು ದೇವರ ಕೋಲನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡು ಗುಡ್ಡದ ಮೇಲೆ ನಿಂತುಕೊಳ್ಳುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ಯೆಹೋಶುವನು ಮೋಶೆ ಅಪ್ಪಣೆ ಕೊಟ್ಟಂತೆ ಅಮಾಲೇಕ್ಯರೊಂದಿಗೆ ಯುದ್ಧಮಾಡಿದನು. ಮೋಶೆಯೂ ಆರೋನನೂ ಹೂರನೂ ಗುಡ್ಡದ ಮೇಲೆ ಏರಿಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ಮೋಶೆಯು ತನ್ನ ಕೈಯನ್ನು ಎತ್ತಿದಾಗ, ಇಸ್ರಾಯೇಲರು ಜಯಿಸಿದರು. ಅವನು ತನ್ನ ಕೈಯನ್ನು ಇಳಿಸಿದಾಗ ಅಮಾಲೇಕ್ಯರು ಜಯಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ಆದರೆ ಮೋಶೆಯ ಕೈಗಳು ಭಾರವಾಗಿರಲಾಗಿ ಅವರು ಕಲ್ಲನ್ನು ತಂದು ಇಟ್ಟಾಗ, ಅವನು ಅದರ ಮೇಲೆ ಕೂತುಕೊಂಡನು. ಆರೋನನು ಒಂದು ಕಡೆಯಲ್ಲಿಯೂ, ಹೂರನು ಇನ್ನೊಂದು ಕಡೆಯಲ್ಲಿಯೂ ಮೋಶೆಯ ಕೈಗಳಿಗೆ ಆಧಾರ ಕೊಟ್ಟರು. ಹೀಗೆ ಸೂರ್ಯನು ಮುಳುಗುವವರೆಗೆ ಅವನ ಕೈಗಳು ಇಳಿಯದೆ ನಿಂತೇ ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ಯೆಹೋಶುವನು ಅಮಾಲೇಕ್ಯರನ್ನೂ, ಅವನ ಜನರನ್ನೂ ಖಡ್ಗದಿಂದ ಸೋಲಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಇದನ್ನು ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಗ್ರಂಥದಲ್ಲಿ ಬರೆ. ಏಕೆಂದರೆ ನಾನು ಅಮಾಲೇಕ್ಯರ ನೆನಪು ಭೂಲೋಕದಲ್ಲಿ ಇರದಂತೆ ಸಂಪೂರ್ಣವಾಗಿ ಅಳಿಸಿಬಿಡುವೆನು. ಇದನ್ನು ಯೆಹೋಶುವನಿಗೆ ಮನದಟ್ಟಾಗುವಂತೆ ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ಇದಾದ ಮೇಲೆ ಮೋಶೆ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿ, ಅದಕ್ಕೆ “ಯೆಹೋವ ನಿಸ್ಸೀ,” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ಅನಂತರ ಮೋಶೆ, “ಯೆಹೋವ ದೇವರ ಸಿಂಹಾಸನಕ್ಕೆ ವಿರೋಧವಾಗಿ ಅಮಾಲೇಕ್ಯರ ಕೈಗಳು ಎತ್ತಿದ್ದರಿಂದ, ಯೆಹೋವ ದೇವರು ತಲತಲಾಂತರಗಳಲ್ಲಿ ಅಮಾಲೇಕ್ಯರ ವಿರುದ್ಧ ಯುದ್ಧಮಾಡುವರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ದೇವರು ಮೋಶೆಗೂ, ತಮ್ಮ ಜನರಾದ ಇಸ್ರಾಯೇಲರಿಗೂ ಮಾಡಿದವುಗಳೆಲ್ಲವನ್ನೂ ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರನ್ನು ಈಜಿಪ್ಟಿನೊಳಗಿಂದ ಹೊರಗೆ ತಂದದ್ದನ್ನೂ, ಮಿದ್ಯಾನಿನ ಯಾಜಕನೂ, ಮೋಶೆಯ ಮಾವನೂ ಆಗಿದ್ದ ಇತ್ರೋವನಿಗೆ ಮುಟ್ಟಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ಅವನು ತನ್ನ ಬಳಿಗೆ ಕಳುಹಿಸಲಾಗಿದ್ದ ಮೋಶೆಯ ಹೆಂಡತಿ ಚಿಪ್ಪೋರಳನ್ನು ಮತ್ತು ಆಕೆಯ ಇಬ್ಬರು ಪುತ್ರರನ್ನು ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ಮೋಶೆಯು, “ನಾನು ಪರದೇಶದಲ್ಲಿ ಅನ್ಯನಾಗಿದ್ದೆನು,” ಎಂದು ಹೇಳಿ ಆ ಪುತ್ರರಲ್ಲಿ ಒಬ್ಬನಿಗೆ ಗೇರ್ಷೋಮ್ ಎಂದು ಹೆಸರಿಟ್ಟಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","“ನನ್ನ ತಂದೆಯ ದೇವರು ನನ್ನ ಸಹಾಯಕನಾಗಿದ್ದು, ಫರೋಹನ ಖಡ್ಗದಿಂದ ಬಿಡುಗಡೆ ಮಾಡಿದನು,” ಎಂದು ಹೇಳಿ ಇನ್ನೊಬ್ಬ ಮಗನಿಗೆ ಎಲೀಯೆಜೆರ್ ಎಂದು ಹೆಸರಿಟ್ಟಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ಮೋಶೆಯ ಮಾವನಾದ ಇತ್ರೋವನ ಸಂಗಡ ಮೋಶೆಯ ಹೆಂಡತಿಯನ್ನೂ, ಅವನ ಪುತ್ರರನ್ನೂ ಮೋಶೆಯ ಬಳಿಗೆ ಅವನು ತಂಗಿದ್ದ ಮರುಭೂಮಿಯಲ್ಲಿ ದೇವರ ಬೆಟ್ಟದ ಬಳಿಗೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ಆಗ ಅವನು ಮೋಶೆಗೆ, “ನಿನ್ನ ಮಾವ ಇತ್ರೋವನೆಂಬ ನಾನು ನಿನ್ನ ಹೆಂಡತಿ, ಇಬ್ಬರು ಮಕ್ಕಳನ್ನೂ ಕರೆದುಕೊಂಡು ನಿನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದೇನೆ,” ಎಂದು ಹೇಳಿ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ಮೋಶೆಗೆ ತನ್ನ ಮಾವನನ್ನು ಎದುರುಗೊಂಡು ಅವನನ್ನು ವಂದಿಸಿ, ಮುದ್ದಿಟ್ಟನು. ಅವರು ಪರಸ್ಪರ ಕ್ಷೇಮಸಮಾಚಾರವನ್ನು ಕೇಳಿಕೊಂಡು ಗುಡಾರಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ಇಸ್ರಾಯೇಲರಿಗೋಸ್ಕರ ಯೆಹೋವ ದೇವರು ಫರೋಹನಿಗೂ ಈಜಿಪ್ಟಿನವರಿಗೂ ಮಾಡಿದ್ದೆಲ್ಲವನ್ನೂ, ಅವರಿಗೆ ಒದಗಿದ ಎಲ್ಲಾ ಸಂಕಟವನ್ನೂ ಯೆಹೋವ ದೇವರು ತಮ್ಮನ್ನು ಹೇಗೆ ತಪ್ಪಿಸಿದನೆಂಬುದನ್ನೂ ಮೋಶೆಯು ತನ್ನ ಮಾವನಿಗೆ ತಿಳಿಯಪಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರಿಗೆ ಮಾಡಿದ ಎಲ್ಲಾ ಉಪಕಾರಕ್ಕಾಗಿಯೂ, ಯೆಹೋವ ದೇವರು ಅವರನ್ನು ಈಜಿಪ್ಟಿನವರ ಕೈಗಳಿಂದ ತಪ್ಪಿಸಿದ್ದಕ್ಕಾಗಿಯೂ ಇತ್ರೋವನು ಸಂತೋಷಪಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ಇತ್ರೋವನು, “ಈಜಿಪ್ಟಿನವರ ಕೈಗೂ ಫರೋಹನ ಕೈಗೂ ಈಜಿಪ್ಟಿನವರ ಅಧಿಕಾರದೊಳಗಿಂದಲೂ ಜನರನ್ನು ತಪ್ಪಿಸಿದ ಯೆಹೋವ ದೇವರಿಗೆ ಸ್ತೋತ್ರವಾಗಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ಎಲ್ಲಾ ದೇವರುಗಳಿಗಿಂತ ಯೆಹೋವ ದೇವರೇ ದೊಡ್ಡವರೆಂದು ಈಗ ನಾನು ತಿಳಿದುಕೊಂಡಿದ್ದೇನೆ. ಏಕೆಂದರೆ ಈಜಿಪ್ಟಿನವರು ಗರ್ವಪಟ್ಟಿದ್ದರಿಂದ ಯೆಹೋವ ದೇವರು ಅವರನ್ನು ತಗ್ಗಿಸಿದರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ಮೋಶೆಯ ಮಾವ ಇತ್ರೋವನು ದಹನಬಲಿಯನ್ನೂ, ಯಜ್ಞಗಳನ್ನೂ ದೇವರಿಗಾಗಿ ತೆಗೆದುಕೊಂಡು ಬಂದನು. ಆರೋನನೂ, ಇಸ್ರಾಯೇಲಿನ ಹಿರಿಯರೆಲ್ಲರೂ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಮೋಶೆಯ ಮಾವನ ಸಂಗಡ ಭೋಜನವನ್ನು ಮಾಡುವುದಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ಮರುದಿನ ಮೋಶೆಯು ಜನರಿಗೆ ನ್ಯಾಯತೀರಿಸುವುದಕ್ಕೆ ಕೂತುಕೊಂಡಾಗ, ಜನರು ಬೆಳಗಿನಿಂದ ಸಂಜೆಯವರೆಗೆ ಮೋಶೆಯ ಬಳಿಯಲ್ಲಿ ನಿಂತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ಇತ್ರೋವನು ಮೋಶೆಯು ಜನರಿಗಾಗಿ ಮಾಡುವುದನ್ನೆಲ್ಲಾ ನೋಡಿದಾಗ, ಅವನು ಮೋಶೆಗೆ, “ಇದೇನು ಜನರಿಗೆ ನೀನು ಮಾಡುವುದು? ಏಕೆ ನೀನೊಬ್ಬನೇ ನ್ಯಾಯಾಧೀಶನಾಗಿ ಕೂತಿರಲಾಗಿ, ಜನರು ಬೆಳಗಿನಿಂದ ಸಂಜೆಯವರೆಗೆ ನಿನ್ನ ಬಳಿಯಲ್ಲಿ ನಿಂತಿರಬೇಕು?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ಅದಕ್ಕೆ ಮೋಶೆಯು ತನ್ನ ಮಾವನಿಗೆ, “ದೇವರ ವಿಷಯವಾಗಿ ಕೇಳುವುದಕ್ಕಾಗಿ ಜನರು ನನ್ನ ಬಳಿಗೆ ಬರುತ್ತಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ಅವರಿಗೆ ಏನಾದರೂ ವ್ಯಾಜ್ಯವಿದ್ದರೆ ನನ್ನ ಬಳಿಗೆ ಬರುತ್ತಾರೆ. ನಾನು ಒಬ್ಬರ ಸಂಗಡ ಇನ್ನೊಬ್ಬರಿಗಿರುವ ವ್ಯಾಜ್ಯವನ್ನು ತೀರಿಸುತ್ತೇನೆ. ದೇವರ ನಿಯಮಗಳನ್ನೂ, ಆಜ್ಞೆಗಳನ್ನೂ ಅವರಿಗೆ ತಿಳಿಯಪಡಿಸುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ಮೋಶೆಯ ಮಾವನು ಅವನಿಗೆ, “ನೀನು ಮಾಡುವ ಕಾರ್ಯವಿಧಾನ ಸರಿಯಲ್ಲ, ");
INSERT INTO kanokcv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ನೀನೂ, ನಿನ್ನ ಸಂಗಡ ಇರುವ ಜನರೂ ಖಂಡಿತ ಬಳಲುವಿರಿ. ಏಕೆಂದರೆ ಇದು ನಿನಗೆ ಬಹು ಭಾರ. ನೀನೊಬ್ಬನೇ ಇದನ್ನು ಮಾಡಲಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ಆದ್ದರಿಂದ ಈಗ ನನ್ನ ಮಾತನ್ನು ಕೇಳು, ನಿನಗೆ ಆಲೋಚನೆ ಹೇಳುತ್ತೇನೆ. ದೇವರು ನಿನ್ನ ಸಂಗಡ ಇರಲಿ. ನೀನು ಜನರಿಗಾಗಿ ದೇವರ ಪಕ್ಷದಲ್ಲಿದ್ದು, ಅವರ ವ್ಯಾಜ್ಯಗಳನ್ನು ದೇವರ ಮುಂದೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ನಿಯಮಗಳನ್ನೂ, ಆಜ್ಞೆಗಳನ್ನೂ ಅವರಿಗೆ ಕಲಿಸಿ, ಅವರು ನಡೆಯಬೇಕಾದ ಮಾರ್ಗವನ್ನೂ, ಅವರು ಮಾಡಬೇಕಾದ ಕೆಲಸವನ್ನೂ ಅವರಿಗೆ ತೋರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ಇದಲ್ಲದೆ ನೀನು ಸಮಸ್ತ ಜನರೊಳಗೆ ಸಮರ್ಥರು ಅಂದರೆ ದೇವರಿಗೆ ಭಯಪಡುವವರೂ, ಸತ್ಯವಂತರೂ, ದುರಾಶೆಯನ್ನು ಹಗೆಮಾಡುವವರೂ ಆಗಿರುವವರನ್ನು ಸಾವಿರ ಮಂದಿಯ ಮೇಲೆಯೂ, ನೂರು ಮಂದಿಯ ಮೇಲೆಯೂ, ಐವತ್ತು ಮಂದಿಯ ಮೇಲೆಯೂ, ಹತ್ತು ಮಂದಿಯ ಮೇಲೆಯೂ ಅಧಿಕಾರಿಗಳನ್ನಾಗಿ ನೇಮಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ಇವರು ಎಲ್ಲಾ ಕಾಲಗಳಲ್ಲಿಯೂ ಜನರಿಗೆ ನ್ಯಾಯತೀರಿಸಲಿ. ಆದರೆ ದೊಡ್ಡ ವ್ಯಾಜ್ಯಗಳನ್ನೆಲ್ಲಾ ನಿನ್ನ ಮುಂದೆ ತಂದು, ಸಣ್ಣ ವ್ಯಾಜ್ಯಗಳನ್ನೆಲ್ಲಾ ತಾವೇ ತೀರಿಸಲಿ. ಆಗ ನಿನಗೆ ಸುಲಭವಾಗುವುದು. ಅವರೂ ನಿನ್ನ ಸಂಗಡ ಭಾರವನ್ನು ಹೊರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ಈ ಕಾರ್ಯವನ್ನು ಮಾಡುವುದಕ್ಕೆ ದೇವರು ನಿನಗೆ ಅಪ್ಪಣೆ ಕೊಟ್ಟರೆ, ಆಗ ನೀನು ಇದನ್ನು ನಿರ್ವಹಿಸಲು ಶಕ್ತನಾಗುವೆ. ಈ ಜನರೆಲ್ಲರೂ ತಮ್ಮ ತಮ್ಮ ಸ್ಥಳಗಳಿಗೆ ಸಮಾಧಾನದಿಂದ ಹೋಗುವರು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ಮೋಶೆಯು ತನ್ನ ಮಾವನ ಮಾತನ್ನು ಕೇಳಿ, ಅವನು ಹೇಳಿದ್ದನ್ನೆಲ್ಲಾ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಇರುವ ಸಮರ್ಥರನ್ನು ಆರಿಸಿಕೊಂಡು, ಅವರನ್ನು ಜನರ ಮೇಲೆ ಮುಖ್ಯಸ್ಥರನ್ನಾಗಿ ಮಾಡಿ, ಸಾವಿರ ಮಂದಿಯ ಮೇಲೆ, ನೂರು ಮಂದಿಯ ಮೇಲೆ, ಐವತ್ತು ಮಂದಿಯ ಮೇಲೆ, ಹತ್ತು ಮಂದಿಯ ಮೇಲೆ ಅಧಿಕಾರಿಗಳನ್ನಾಗಿ ನೇಮಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ಇವರು ಎಲ್ಲಾ ಕಾಲಗಳಲ್ಲಿ ಜನರಿಗೆ ನ್ಯಾಯತೀರಿಸಿ, ಕಠಿಣ ವ್ಯಾಜ್ಯಗಳನ್ನು ಮೋಶೆಯ ಬಳಿಗೆ ತರುತ್ತಿದ್ದರು. ಸಣ್ಣ ವ್ಯಾಜ್ಯಗಳನ್ನು ತಾವೇ ತೀರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ತರುವಾಯ ಮೋಶೆಯು ತನ್ನ ಮಾವ ಇತ್ರೋವನಿಗೆ ಸಾಗಕಳುಹಿಸಿದಾಗ, ಅವನು ಸ್ವದೇಶಕ್ಕೆ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ಇಸ್ರಾಯೇಲರು ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟ ಮೂರನೆಯ ತಿಂಗಳಿನ ಅದೇ ದಿನದಲ್ಲಿ ಸೀನಾಯಿ ಮರುಭೂಮಿಗೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ಅವರು ರೆಫೀದೀಮಿನಿಂದ ಹೊರಟು, ಸೀನಾಯಿ ಮರುಭೂಮಿಗೆ ಬಂದು, ಮರುಭೂಮಿಯಲ್ಲಿ ಡೇರೆ ಹಾಕಿ, ಬೆಟ್ಟಕ್ಕೆದುರಾಗಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ಮೋಶೆಯು ದೇವರ ಸನ್ನಿಧಿಗೆ ಬೆಟ್ಟದ ಮೇಲೆ ಹೋದನು. ಆಗ ಯೆಹೋವ ದೇವರು ಸೀನಾಯಿ ಪರ್ವತದ ಮೇಲಿನಿಂದ ಅವನನ್ನು ಕರೆದು ಅವನಿಗೆ, “ನೀನು ಯಾಕೋಬನ ಮನೆತನದವರಾದ ಇಸ್ರಾಯೇಲರಿಗೆ ಇದನ್ನು ತಿಳಿಸು: ");
INSERT INTO kanokcv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘ನಾನು ಈಜಿಪ್ಟಿನವರಿಗೆ ಮಾಡಿದ್ದನ್ನೂ, ಹದ್ದು ತನ್ನ ಮರಿಗಳನ್ನು ತನ್ನ ರೆಕ್ಕೆಗಳ ಮೇಲೆ ಹೊತ್ತು ಬರುವಂತೆ ನಿಮ್ಮನ್ನು ಈ ಸ್ಥಳಕ್ಕೆ ಬರಮಾಡಿದ್ದನ್ನೆಲ್ಲಾ ನೀವು ನೋಡಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ಆದ್ದರಿಂದ ಈಗ ನೀವು ನನ್ನ ಮಾತನ್ನು ಕೇಳಿ, ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಕಾಪಾಡಿದರೆ, ಸಮಸ್ತ ಜನರಲ್ಲಿ ನೀವು ನನ್ನ ಸಂಗ್ರಹಿಸಿದ ಸೊತ್ತಾಗಿರುವಿರಿ. ಏಕೆಂದರೆ ಭೂಮಿಯೆಲ್ಲಾ ನನ್ನದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ನೀವು ನನಗೆ ಯಾಜಕ ರಾಜ್ಯವೂ ಪರಿಶುದ್ಧ ಜನಾಂಗವೂ ಆಗಿರುವಿರಿ.’ ಇಸ್ರಾಯೇಲರಿಗೆ ನೀನು ಹೇಳಬೇಕಾದ ಮಾತುಗಳು ಇವೇ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ಆಗ ಮೋಶೆಯು ಇಳಿದುಬಂದು ಜನರ ಹಿರಿಯರನ್ನು ಕರೆದು, ಯೆಹೋವ ದೇವರು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಈ ಮಾತುಗಳನ್ನೆಲ್ಲಾ ಅವರ ಮುಂದೆ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ಜನರೆಲ್ಲಾ ಒಂದಾಗಿ ಉತ್ತರಕೊಟ್ಟು, “ಯೆಹೋವ ದೇವರು ಹೇಳಿದ್ದನ್ನೆಲ್ಲಾ ಮಾಡುತ್ತೇವೆ,” ಎಂದು ಹೇಳಿದರು. ಆಗ ಮೋಶೆಯು ಜನರ ಮಾತುಗಳನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನಾನು ನಿನ್ನ ಸಂಗಡ ಮಾತನಾಡುವುದನ್ನು ಜನರು ಕೇಳುವ ಹಾಗೆಯೂ ಅವರು ಸದಾಕಾಲ ನಿನ್ನನ್ನು ನಂಬುವಂತೆಯೂ ದಟ್ಟವಾದ ಮೇಘದಲ್ಲಿ ನಾನು ನಿನ್ನ ಬಳಿಗೆ ಬರುತ್ತೇನೆ,” ಎಂದರು. ಮೋಶೆಯು ಜನರ ಮಾತುಗಳನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಜನರ ಬಳಿಗೆ ಹೋಗಿ ಈ ಹೊತ್ತೂ ನಾಳೆಯೂ ಅವರನ್ನು ಶುದ್ಧಮಾಡು. ಅವರು ತಮ್ಮ ವಸ್ತ್ರಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಅವರು ಸಿದ್ಧವಾಗಿರಲಿ. ಏಕೆಂದರೆ ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಸಮಸ್ತ ಜನರ ಕಣ್ಣೆದುರಿನಲ್ಲಿ ಸೀನಾಯಿ ಪರ್ವತಕ್ಕೆ ಇಳಿದು ಬರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ಜನರಿಗೋಸ್ಕರ ಸುತ್ತಲೂ ಮೇರೆಗಳನ್ನು ಮಾಡಿಸಿ, ‘ಅವರು ಬೆಟ್ಟವನ್ನು ಏರದಂತೆಯೂ ಅದರ ಮೇರೆಯನ್ನು ಮುಟ್ಟದಂತೆಯೂ ಜಾಗ್ರತೆಯಾಗಿರಬೇಕು. ಬೆಟ್ಟವನ್ನು ಮುಟ್ಟಿದವರೆಲ್ಲಾ ಖಂಡಿತವಾಗಿ ಸತ್ತು ಹೋಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ಯಾರೂ ಅಂಥವರನ್ನು ಮುಟ್ಟಬಾರದು. ಮುಟ್ಟಿದ ಪಶುವಾಗಲಿ, ಮನುಷ್ಯನಾಗಲಿ ನಿಶ್ಚಯವಾಗಿ ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ಇಲ್ಲವೆ ಈಟಿಯಿಂದ ತಿವಿಯಬೇಕು.’ ದೀರ್ಘವಾಗಿ ತುತೂರಿ ಊದುವ ಸಮಯದಲ್ಲಿ ಅವರು ಬೆಟ್ಟದ ಬಳಿಗೆ ಬರಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ಆಗ ಮೋಶೆಯು ಬೆಟ್ಟದಿಂದಿಳಿದು ಜನರನ್ನು ಶುದ್ಧಿಮಾಡಿದನು. ಅವರು ತಮ್ಮ ವಸ್ತ್ರಗಳನ್ನು ತೊಳೆದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ಅವನು ಜನರಿಗೆ, “ಮೂರನೆಯ ದಿನಕ್ಕಾಗಿ ಸಿದ್ಧರಾಗಿರಿ, ನೀವು ಲೈಂಗಿಕ ಸಂಬಂಧದಿಂದ ದೂರವಾಗಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಉದಯವಾದಾಗ, ಬೆಟ್ಟದ ಮೇಲೆ ಗುಡುಗು, ಮಿಂಚು, ದಟ್ಟವಾದ ಮೇಘ ಮತ್ತು ತುತೂರಿಯ ಮಹಾ ಧ್ವನಿ ಉಂಟಾದವು. ಪಾಳೆಯದಲ್ಲಿದ್ದ ಜನರೆಲ್ಲರೂ ನಡುಗಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ಆಗ ಮೋಶೆಯು ದೇವರನ್ನು ಸಂಧಿಸುವುದಕ್ಕೆ ಜನರನ್ನು ಪಾಳೆಯದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದನು. ಆಗ ಅವರು ಬೆಟ್ಟದ ಕೆಳಗೆ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ಯೆಹೋವ ದೇವರು ಅಗ್ನಿಯೊಳಗೆ ಬೆಟ್ಟದ ಮೇಲೆ ಇಳಿದಿದ್ದರಿಂದ ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲೆಲ್ಲಾ ಹೊಗೆ ಹಾಯುತ್ತಿತ್ತು. ಅದರ ಹೊಗೆಯು ಆವಿಗೆಯ ಹೊಗೆಯಂತೆ ಏರಿ ಬರುತ್ತಾ ಇತ್ತು. ಬೆಟ್ಟವೆಲ್ಲಾ ಬಹಳವಾಗಿ ಕಂಪಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ತುತೂರಿಯ ಧ್ವನಿಯು ಬರಬರುತ್ತಾ ಹೆಚ್ಚಾಗುತ್ತಾ ಇತ್ತು. ಆಗ ಮೋಶೆಯು ದೇವರೊಡನೆ ಮಾತನಾಡಿದನು. ಅವನಿಗೆ ದೇವರು ಉತ್ತರಕೊಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ಯೆಹೋವ ದೇವರು ಸೀನಾಯಿ ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿ ಇಳಿದುಬಂದು ಮೋಶೆಯನ್ನು ಬೆಟ್ಟದ ತುದಿಗೆ ಕರೆದರು. ಮೋಶೆಯು ಮೇಲೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಇಳಿದು ಹೋಗಿ ಜನರನ್ನು ಎಚ್ಚರಿಸಬೇಕು. ಅವರು ಯೆಹೋವ ದೇವರನ್ನು ನೋಡುವದಕ್ಕಾಗಿ ಮುಂದೆ ಬಂದರೆ, ಅವರಲ್ಲಿ ಬಹಳ ಜನರು ಸಾಯುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ಯೆಹೋವ ದೇವರ ಸಮೀಪಕ್ಕೆ ಬರುವ ಯಾಜಕರು ಸಹ ಯೆಹೋವ ದೇವರು ಅವರನ್ನು ಸಾಯಿಸದಂತೆ ತಮ್ಮನ್ನು ಶುದ್ಧಿಮಾಡಿಕೊಳ್ಳಲಿ, ಇಲ್ಲವಾದರೆ ಅವರನ್ನೂ ನಾನು ತಟ್ಟನೆ ನಾಶಮಾಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರಿಗೆ, “ಜನರು ಸೀನಾಯಿ ಬೆಟ್ಟವನ್ನು ಏರಲಾರರು. ಬೆಟ್ಟಕ್ಕೆ ಮೇರೆಗಳನ್ನು ಹಾಕಿ ಅದನ್ನು ಶುದ್ಧಮಾಡೆಂದು ನೀವೇ ನಮ್ಮನ್ನು ಎಚ್ಚರಿಸಿದ್ದೀರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ಆಗ ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ, “ನೀನು ಇಳಿದು ಹೋಗಿ, ಆರೋನನನ್ನು ಕರೆದುಕೊಂಡು ಇಲ್ಲಿಗೆ ಬಾ. ಆದರೆ ಯೆಹೋವ ದೇವರಿಂದ ಸಂಹಾರವಾಗದಂತೆ ಯಾಜಕರೂ ಜನರೂ ಮುಂದೆ ಯೆಹೋವ ದೇವರ ಬಳಿಗೆ ಬಾರದೇ ಇರಲಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ಮೋಶೆಯು ಜನರ ಬಳಿಗೆ ಇಳಿದು ಹೋಗಿ ಅವರಿಗೆ ಇದನ್ನೆಲ್ಲಾ ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ದೇವರು ಈ ಎಲ್ಲಾ ವಾಕ್ಯಗಳನ್ನು ಹೇಳಿದರು: ");
INSERT INTO kanokcv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ನಿನ್ನನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದಿಂದಲೂ ದಾಸತ್ವದ ನಾಡಿನೊಳಗಿಂದಲೂ ಹೊರಗೆ ತಂದ ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“ನಾನಲ್ಲದೆ ನಿನಗೆ ಬೇರೆ ದೇವರುಗಳು ಇರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","ಮೇಲಿನ ಆಕಾಶದಲ್ಲಾಗಲಿ, ಕೆಳಗಿನ ಭೂಮಿಯಲ್ಲಾಗಲಿ, ಭೂಮಿಯ ಕೆಳಗಿರುವ ನೀರುಗಳಲ್ಲಾಗಲಿ ಇರುವ ಯಾವುದರ ವಿಗ್ರಹವನ್ನಾಗಲಿ, ರೂಪವನ್ನಾಗಲಿ ನೀನು ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ನೀನು ಅವುಗಳಿಗೆ ಅಡ್ಡ ಬೀಳಬಾರದು ಮತ್ತು ಆರಾಧಿಸಲೂಬಾರದು. ಏಕೆಂದರೆ ನಿನ್ನ ದೇವರಾದ ನಾನು, ನನಗೆ ಸಲ್ಲಬೇಕಾದ ಗೌರವವನ್ನು ಮತ್ತೊಬ್ಬರಿಗೆ ಸಲ್ಲಗೊಡಿಸದ ಸ್ವಾಮ್ಯಾಸಕ್ತನಾದ ಯೆಹೋವ ದೇವರಾಗಿದ್ದೇನೆ. ನನ್ನನ್ನು ಹಗೆ ಮಾಡುವ ತಂದೆತಾಯಿಗಳ ಅಪರಾಧವನ್ನು ಮಕ್ಕಳ ಮೇಲೆಯೂ ಮೂರನೆಯ ನಾಲ್ಕನೆಯ ತಲೆಗಳವರೆಗೂ ಬರಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ನನ್ನನ್ನು ಪ್ರೀತಿಸಿ, ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಕೈಗೊಳ್ಳುವವರಿಗೆ, ಸಾವಿರ ತಲೆಗಳವರೆಗೆ ಪ್ರೀತಿ ತೋರಿಸುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವ ದೇವರ ಹೆಸರನ್ನು ದುರುಪಯೋಗಮಾಡಬಾರದು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಹೆಸರನ್ನು ದುರುಪಯೋಗಮಾಡುವವರನ್ನು ಶಿಕ್ಷಿಸದೆ ಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ಸಬ್ಬತ್ ದಿನವನ್ನು ಪರಿಶುದ್ಧ ದಿನವೆಂದು ಜ್ಞಾಪಕದಲ್ಲಿಟ್ಟುಕೊಂಡು ಆಚರಿಸಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ಆರು ದಿನಗಳಲ್ಲಿ ನೀನು ದುಡಿದು, ನಿನ್ನ ಕೆಲಸವನ್ನೆಲ್ಲಾ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ಆದರೆ ಏಳನೆಯ ದಿನ ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವ ದೇವರ ಸಬ್ಬತ್ ದಿನವಾಗಿದೆ. ಅದರಲ್ಲಿ ನೀನಾಗಲೀ, ನಿನ್ನ ಮಗನಾಗಲೀ, ನಿನ್ನ ಮಗಳಾಗಲೀ, ನಿನ್ನ ದಾಸನಾಗಲೀ, ನಿನ್ನ ದಾಸಿಯಾಗಲೀ, ನಿನ್ನ ಪಶುಗಳಾಗಲೀ ಮತ್ತು ನಿನ್ನ ಊರಲ್ಲಿರುವ ಅನ್ಯದೇಶದವರು ಸಹ ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ಏಕೆಂದರೆ ಆರು ದಿನಗಳಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಆಕಾಶವನ್ನೂ ಭೂಮಿಯನ್ನೂ ಸಮುದ್ರವನ್ನೂ ಅದರಲ್ಲಿರುವ ಪ್ರತಿಯೊಂದನ್ನೂ ಉಂಟುಮಾಡಿ, ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಂಡನು. ಆದ್ದರಿಂದ ಯೆಹೋವ ದೇವರು ಸಬ್ಬತ್ ದಿನವನ್ನು ಆಶೀರ್ವದಿಸಿ, ಅದನ್ನು ಪರಿಶುದ್ಧ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಿನಗೆ ಕೊಡುವ ದೇಶದಲ್ಲಿ ನೀನು ಬಹುಕಾಲ ಬಾಳುವಂತೆ ನಿನ್ನ ತಂದೆತಾಯಿಗಳನ್ನು ಗೌರವಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","ಕೊಲೆ ಮಾಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","ವ್ಯಭಿಚಾರ ಮಾಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","ಕದಿಯಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","ನಿನ್ನ ನೆರೆಯವನಿಗೆ ವಿರೋಧವಾಗಿ ಸುಳ್ಳುಸಾಕ್ಷಿ ಹೇಳಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","ನಿನ್ನ ನೆರೆಯವನ ಮನೆಯನ್ನು ಆಶಿಸಬೇಡ. ನಿನ್ನ ನೆರೆಯವನ ಹೆಂಡತಿಯನ್ನು ಆಶಿಸಬೇಡ. ಅವನ ದಾಸನನ್ನಾಗಲಿ, ಅವನ ದಾಸಿಯನ್ನಾಗಲಿ, ಅವನ ಎತ್ತನ್ನಾಗಲಿ, ಅವನ ಕತ್ತೆಯನ್ನಾಗಲಿ, ನಿನ್ನ ನೆರೆಯವನಿಗೆ ಇರುವ ಯಾವುದನ್ನೂ ಆಶಿಸಬೇಡ.” ");
INSERT INTO kanokcv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ಜನರೆಲ್ಲಾ ಗುಡುಗುಗಳನ್ನೂ ಮಿಂಚುಗಳನ್ನೂ ತುತೂರಿಯ ಶಬ್ದವನ್ನೂ ಬೆಟ್ಟದಲ್ಲಿ ಹೊಗೆ ಹಾಯುವುದನ್ನೂ ನೋಡಿದರು. ಜನರು ಅದನ್ನು ನೋಡಿ ನಡುಗುತ್ತಾ ದೂರಹೋಗಿ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ಅವರು ಮೋಶೆಗೆ, “ನೀನೇ ನಮ್ಮ ಸಂಗಡ ಮಾತನಾಡು, ಆಗ ನಾವು ಕೇಳುವೆವು. ನಾವು ಸಾಯದ ಹಾಗೆ ದೇವರು ನಮ್ಮೊಂದಿಗೆ ನೇರವಾಗಿ ಮಾತನಾಡಲು ಬಿಡಬೇಡಿ,” ಎಂದು ವಿನಂತಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ಆಗ ಮೋಶೆಯು ಜನರಿಗೆ, “ಭಯಪಡಬೇಡಿರಿ. ಏಕೆಂದರೆ ನಿಮ್ಮನ್ನು ಪರೀಕ್ಷಿಸುವುದಕ್ಕೋಸ್ಕರವೂ ನೀವು ಪಾಪಮಾಡದಂತೆ ಅವರ ಭಯವು ನಿಮಗಿರಲೆಂದೂ ದೇವರು ಬಂದಿದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ಆಗ ಜನರು ದೂರದಲ್ಲಿ ನಿಂತರು. ಮೋಶೆಯು ದೇವರಿದ್ದ ಕಾರ್ಗತ್ತಲೆಯ ಹತ್ತಿರ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು, ‘ನಾನು ಆಕಾಶದಿಂದ ನಿಮ್ಮ ಸಂಗಡ ಮಾತನಾಡಿದ್ದನ್ನು ನೀವು ನೋಡಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ನನ್ನ ಹೊರತಾಗಿ ಬೆಳ್ಳಿ ಬಂಗಾರಗಳ ದೇವರುಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘ಬಲಿಪೀಠವನ್ನು ಮಣ್ಣಿನಿಂದ ಮಾಡಬೇಕು. ಅದರ ಮೇಲೆ ನಿಮ್ಮ ಸಮರ್ಪಣೆಗಳಾದ ದಹನಬಲಿಗಳನ್ನೂ ಸಮಾಧಾನದ ಬಲಿಗಳನ್ನೂ ಕುರಿಮೇಕೆಗಳನ್ನೂ ದನಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ನಾನು ನನ್ನ ಹೆಸರನ್ನು ಗೌರವಿಸುವಂತೆ ಮಾಡುವ ಎಲ್ಲಾ ಸ್ಥಳಗಳಲ್ಲಿಯೂ ನಾನು ನಿಮ್ಮ ಬಳಿಗೆ ಬಂದು ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ಬಲಿಪೀಠವನ್ನು ಕಲ್ಲಿನಿಂದ ಮಾಡಿದರೆ, ಅದನ್ನು ಕೆತ್ತಿದ ಕಲ್ಲಿನಿಂದ ಕಟ್ಟಬಾರದು. ಏಕೆಂದರೆ ಉಳಿಯನ್ನು ಅದರ ಮೇಲೆ ಉಪಯೋಗಿಸಿದರೆ, ಅದನ್ನು ಅಪವಿತ್ರಮಾಡಿದ ಹಾಗಾಗುತ್ತದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ನನಗಾಗಿ ಬಲಿಪೀಠದ ಮೇಲೆ ಹೋಗಲು ಹತ್ತುವಾಗ ನಿನ್ನ ಬೆತ್ತಲೆತನ ಕಾಣಬಾರದು. ಅದರ ಮೆಟ್ಟಲುಗಳನ್ನು ಹತ್ತಬಾರದು,’ ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“ಈಗ ಅವರ ಮುಂದೆ ನೀನು ಇಡತಕ್ಕ ನ್ಯಾಯವಿಧಿಗಳು ಇವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“ನೀನು ಹಿಬ್ರಿಯ ದಾಸನನ್ನು ಕೊಂಡುಕೊಂಡರೆ, ಅವನು ಆರು ವರ್ಷ ನಿನಗೆ ಸೇವೆಮಾಡಬೇಕು. ಏಳನೆಯ ವರ್ಷದಲ್ಲಿ ಅವನು ಏನೂ ಕೊಡದೆ ಬಿಡುಗಡೆಯಾಗಿ ಹೋಗಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ಅವನು ಒಬ್ಬನಾಗಿ ಬಂದಿದ್ದರೆ, ಒಬ್ಬನಾಗಿಯೇ ಹೋಗಬೇಕು. ಅವನು ಮದುವೆಯಾದವನಾಗಿದ್ದರೆ, ಅವನ ಹೆಂಡತಿಯು ಅವನ ಸಂಗಡ ಹೋಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ಅವನ ಯಜಮಾನನು ಅವನಿಗೆ ಮದುವೆಮಾಡಿಸಿ ಆ ಹೆಂಡತಿಗೆ ಗಂಡು ಇಲ್ಲವೆ ಹೆಣ್ಣುಮಕ್ಕಳು ಹುಟ್ಟಿದ್ದರೆ, ಆ ಹೆಂಡತಿಯೂ ಅವಳ ಮಕ್ಕಳೂ ಯಜಮಾನನ ಸೊತ್ತಾಗುವರು. ಅವನು ಒಬ್ಬನಾಗಿಯೇ ಹೋಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“ಆದರೆ ದಾಸನು, ‘ನಾನು ನನ್ನ ಯಜಮಾನನನ್ನೂ ನನ್ನ ಹೆಂಡತಿಯನ್ನೂ ನನ್ನ ಮಕ್ಕಳನ್ನೂ ಪ್ರೀತಿಮಾಡುತ್ತೇನೆ. ಆದ್ದರಿಂದ ನಾನು ಬಿಡುಗಡೆಯಾಗಿ ಹೋಗುವುದಕ್ಕೆ ಮನಸ್ಸಿಲ್ಲ,’ ಎಂದು ಸ್ವಷ್ಟವಾಗಿ ಹೇಳಿದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ಅವನ ಯಜಮಾನನು ಅವನನ್ನು ನ್ಯಾಯಾಧೀಶರ ಬಳಿಗೆ ಕರಕೊಂಡು ಬಂದು, ಬಾಗಿಲಿನ ಬಳಿಗಾದರೂ ಅದರ ಕಂಬದ ಬಳಿಗಾದರೂ ಬರಮಾಡಿ, ಅವನ ಯಜಮಾನನು ಅವನ ಕಿವಿಯನ್ನು ದಬ್ಬಳದಿಂದ ಚುಚ್ಚಬೇಕು. ಆಗ ಅವನು ಸದಾಕಾಲಕ್ಕೂ ಅವನ ದಾಸನಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ಒಬ್ಬನು ತನ್ನ ಮಗಳನ್ನು ದಾಸಿಯನ್ನಾಗಿ ಮಾರಿದರೆ, ದಾಸರು ಹೋಗುವಂತೆ ಆಕೆಯು ಹೋಗಿಬಿಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ಅವಳನ್ನು ನಿಶ್ಚಯಮಾಡಿಕೊಂಡ ಯಜಮಾನನಿಗೆ ಒಂದು ವೇಳೆ ಅವಳು ಮೆಚ್ಚಿಕೆಯಾಗದೆ ಹೋದರೆ, ಆಗ ಅವಳು ಬಿಡುಗಡೆಯಾಗುವಂತೆ ಮಾಡಲಿ. ಅವನು ಅವಳನ್ನು ವಂಚಿಸಿದ್ದರಿಂದ ಯೆಹೂದ್ಯರಲ್ಲದವರಿಗೆ ಅವಳನ್ನು ಮಾರುವುದಕ್ಕೆ ಅವನಿಗೆ ಅಧಿಕಾರವಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ಒಂದು ವೇಳೆ ಅವನು ತನ್ನ ಮಗನಿಗೆ ಅವಳನ್ನು ನಿಶ್ಚಯ ಮಾಡಿದರೆ, ಹೆಣ್ಣು ಮಕ್ಕಳ ನ್ಯಾಯದ ಪ್ರಕಾರ ಅವಳಿಗೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ಒಂದು ವೇಳೆ ಅವನು ಇನ್ನೊಬ್ಬಳನ್ನು ಮದುವೆಯಾದರೆ, ಮೊದಲನೆಯವಳಿಗೆ ಅನ್ನ, ವಸ್ತ್ರ, ದಾಂಪತ್ಯದ ಹಕ್ಕನ್ನು ಕಡಿಮೆ ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ಈ ಮೂರನ್ನು ಅವಳಿಗೆ ಮಾಡದೆ ಹೋದರೆ, ಅವಳು ಏನೂ ಕ್ರಯ ಕೊಡದೆ, ಸ್ವತಂತ್ರಳಾಗಿ ಹೋಗಿಬಿಡಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ಮನುಷ್ಯನನ್ನು ಸಾಯುವಂತೆ ಹೊಡೆದವನು ಖಂಡಿತವಾಗಿ ಸಾಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ಆದರೆ ಕೊಲ್ಲಬೇಕೆಂಬ ಯೋಚನೆ ಇಲ್ಲದೆ ದೇವರು ಅನುಮತಿಸಿದ್ದರಿಂದ ಕೊಲೆಯಾದರೆ, ಕೊಂದವನು ಓಡಿಹೋಗುವಂತೆ ಅವನಿಗೆ ಒಂದು ಸ್ಥಳವನ್ನು ನಾನು ನೇಮಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ಆದರೆ ಒಬ್ಬನು ಮತ್ತೊಬ್ಬನನ್ನು ಕೊಲ್ಲಬೇಕೆಂಬ ಉದ್ದೇಶ ಇಟ್ಟುಕೊಂಡು ಮೋಸದಿಂದ ಕೊಂದರೆ, ಅವನು ಸಾಯುವಂತೆ ನೀನು ಅವನನ್ನು ನನ್ನ ಬಲಿಪೀಠದಿಂದ ದೂರ ತೆಗೆದುಕೊಂಡುಹೋಗಿ ಕೊಂದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ತಂದೆತಾಯಿಗಳನ್ನು ಹೊಡೆಯುವವನು ಖಂಡಿತವಾಗಿ ಮರಣದಂಡನೆ ಹೊಂದಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ಒಬ್ಬನು ಮತ್ತೊಬ್ಬನನ್ನು ಅಪಹರಿಸಿಕೊಂಡು ಹೋಗಿ ಮಾರಿದರೆ, ಇಲ್ಲವೆ ಅವನು ಬಂಧನಕ್ಕೊಳಗಾದಾಗ ಅಪಹರಿಸಲಾದವನು ಅವನೊಂದಿಗಿದ್ದರೆ, ಅವನನ್ನು ಮರಣದಂಡನೆಗೆ ಗುರಿಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ತಂದೆಗಾದರೂ ತಾಯಿಗಾದರೂ ಶಾಪಕೊಟ್ಟವನು ಖಂಡಿತವಾಗಿ ಸಾಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ಇಬ್ಬರು ಜಗಳವಾಡುವಾಗ ಒಬ್ಬನು ಮತ್ತೊಬ್ಬನನ್ನು ಕಲ್ಲಿನಿಂದಾಗಲಿ, ಮುಷ್ಟಿಯಿಂದಾಗಲಿ ಹೊಡೆದದ್ದರಿಂದ ಅವನು ಸಾಯದೆ ಗಾಯಗೊಂಡು, ಹಾಸಿಗೆ ಹಿಡಿದು, ಕ್ರಮೇಣ ");
INSERT INTO kanokcv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ಅವನು ಎದ್ದು ಕೋಲೂರಿಕೊಂಡು ತಿರುಗಾಡುವುದಾದರೆ, ಅವನನ್ನು ಹೊಡೆದವನು ಅಪರಾಧವಿಲ್ಲದೆ ಹೋಗಬೇಕು. ಪೆಟ್ಟು ತಿಂದವನು ಗುಣಹೊಂದುವವರೆಗೆ ಆಗುವ ಖರ್ಚನ್ನು ಹೊಡೆದವನು ಕೊಡಬೇಕು ಮತ್ತು ಅವನನ್ನು ಪೂರ್ಣ ಸ್ವಸ್ಥನಾಗುವಂತೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“ಒಬ್ಬನು ದಾಸನನ್ನಾಗಲಿ, ದಾಸಿಯನ್ನಾಗಲಿ ಸಾಯುವಂತೆ ಕೋಲಿನಿಂದ ಹೊಡೆದಾಗ, ಹೊಡೆದವನಿಗೆ ಖಂಡಿತವಾಗಿ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ದಾಸದಾಸಿಯರು ಒಂದೆರಡು ದಿನಗಳ ನಂತರ ಉಳಿದರೆ ಶಿಕ್ಷೆಯಾಗಬಾರದು. ಏಕೆಂದರೆ ಅವರು ಅವನ ಸೊತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ಜನರು ಜಗಳವಾಡುವಾಗ ಗರ್ಭಿಣಿಯಾದ ಸ್ತ್ರೀಗೆ ಏಟು ತಗಲಿ ಗರ್ಭಸ್ರಾವವಾದರೆ, ಆ ಸ್ತ್ರೀಯ ಗಂಡನು ಕೇಳಿದಷ್ಟು ಮತ್ತು ನ್ಯಾಯಾಲಯವು ವಿಧಿಸುವಷ್ಟು ದಂಡವನ್ನು ಹೊಡೆದವನು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ಬೇರೆ ಹಾನಿಯಾದ ಪಕ್ಷದಲ್ಲಿ ಪ್ರಾಣಕ್ಕೆ ಪ್ರಾಣವನ್ನು, ಕಣ್ಣಿಗೆ ಕಣ್ಣನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ಹಲ್ಲಿಗೆ ಹಲ್ಲು, ಕೈಗೆ ಕೈಯನ್ನು, ಕಾಲಿಗೆ ಕಾಲನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ಸುಟ್ಟ ಗಾಯಕ್ಕೆ ಸುಟ್ಟಗಾಯವನ್ನು, ಕಡಿದ ಗಾಯಕ್ಕೆ ಕಡಿದ ಗಾಯವನ್ನು, ಹೊಡೆದ ಗಾಯಕ್ಕೆ ಹೊಡೆದು ಗಾಯವನ್ನು ನೀನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ಒಬ್ಬನು ದಾಸನ ಕಣ್ಣನ್ನು ಇಲ್ಲವೆ ದಾಸಿಯ ಕಣ್ಣನ್ನು ಹೊಡೆದು ನಷ್ಟಪಡಿಸಿದರೆ, ಆ ಕಣ್ಣಿಗೋಸ್ಕರ ಅವರನ್ನು ಅವನು ಬಿಡುಗಡೆ ಮಾಡಿ ಕಳುಹಿಸಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ಒಬ್ಬನು ದಾಸನ ಹಲ್ಲನ್ನು, ಇಲ್ಲವೆ ದಾಸಿಯ ಹಲ್ಲನ್ನು ಉದುರಿಸಿದರೆ, ಹಲ್ಲಿಗೋಸ್ಕರ ಅವರನ್ನು ಬಿಡುಗಡೆ ಮಾಡಿ ಕಳುಹಿಸಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ಯಾವುದಾದರೂ ಒಂದು ಎತ್ತು ಪುರುಷನನ್ನಾಗಲಿ, ಸ್ತ್ರೀಯನ್ನಾಗಲಿ ಹಾಯ್ದು ಕೊಂದರೆ, ಆ ಎತ್ತನ್ನು ಖಂಡಿತವಾಗಿ ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ಅದರ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು. ಆ ಎತ್ತಿನ ಯಜಮಾನನು ನಿರಪರಾಧಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ಆದರೆ ಆ ಎತ್ತು ಮೊದಲಿನಿಂದ ಹಾಯುವಂಥದ್ದೆಂದು ಯಜಮಾನನಿಗೆ ತಿಳಿದಿದ್ದರೂ ಅವನು ಅದನ್ನು ಕಟ್ಟಿಹಾಕದೆ ಇದ್ದುದರಿಂದ ಅದು ಪುರುಷನನ್ನಾಗಲಿ, ಸ್ತ್ರೀಯನ್ನಾಗಲಿ ಕೊಂದುಹಾಕಿದರೆ, ಆ ಎತ್ತನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ಆದರೆ ಯಜಮಾನನೂ ಮರಣದಂಡನೆಗೆ ಗುರಿಯಾಗುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ಒಂದು ವೇಳೆ ಅವನಿಗೆ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ನೇಮಿಸಿದರೆ, ಅವನು ತನಗೆ ನೇಮಿಸಿದ್ದನ್ನೆಲ್ಲಾ ತನ್ನ ಪ್ರಾಣವಿಮೋಚನೆಗಾಗಿ ಕೊಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ಅದು ಮಗನನ್ನು ಹಾಯ್ದಿದ್ದರೂ, ಮಗಳನ್ನು ಹಾಯ್ದಿದ್ದರೂ ಈ ನ್ಯಾಯತೀರ್ಪಿನ ಪ್ರಕಾರ ಅದರ ಯಜಮಾನನಿಗೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ದಾಸನನ್ನಾದರೂ, ದಾಸಿಯನ್ನಾದರೂ ಎತ್ತು ಹಾಯ್ದರೆ, ದಾಸನ, ದಾಸಿಯ ಯಜಮಾನನಿಗೆ ಮೂವತ್ತು ಬೆಳ್ಳಿ ನಾಣ್ಯಗಳನ್ನು ಕೊಡಬೇಕು ಮತ್ತು ಎತ್ತನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ಗುಂಡಿಯನ್ನು ಅಗೆದವನು ಅದನ್ನು ಮುಚ್ಚದೆ ಇದ್ದುದರಿಂದ ಎತ್ತಾದರೂ ಕತ್ತೆಯಾದರೂ ಆ ಗುಂಡಿಯಲ್ಲಿ ಬಿದ್ದು ಸತ್ತರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ಗುಂಡಿಯನ್ನು ಅಗೆದವನು ಈಡು ಕೊಡಬೇಕು. ಅವುಗಳ ಯಜಮಾನನಿಗೆ ಕ್ರಯ ನೀಡಬೇಕು. ಆದರೆ ಸತ್ತ ಪಶು ಅವನದಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ಒಬ್ಬನ ಎತ್ತು ಮತ್ತೊಬ್ಬನ ಎತ್ತನ್ನು ಹಾಯ್ದು ಕೊಂದರೆ, ಜೀವದಿಂದಿರುವ ಎತ್ತನ್ನು ಮಾರಿ ಅದರ ಕ್ರಯವನ್ನೂ, ಸತ್ತ ಎತ್ತನ್ನೂ ಸರಿಯಾಗಿ ಇಬ್ಬರೂ ಪಾಲುಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ಇಲ್ಲವೆ ಆ ಎತ್ತು ಮೊದಲಿನಿಂದಲೂ ಹಾಯುವಂಥದ್ದೇ ಎಂದು ತಿಳಿದಿದ್ದರೂ, ಅದರ ಯಜಮಾನನು ಅದನ್ನು ಕಟ್ಟಿಹಾಕದೆ ಹೋಗಿದ್ದರೆ, ಎತ್ತಿಗೆ ಎತ್ತನ್ನು ಖಂಡಿತವಾಗಿ ಬದಲುಕೊಡಬೇಕು. ಆದರೆ ಸತ್ತ ಪಶುವನ್ನು ಅವನು ತೆಗೆದುಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ಒಬ್ಬನು ಎತ್ತನ್ನಾಗಲಿ, ಕುರಿಯನ್ನಾಗಲಿ ಕದ್ದು ಕೊಯ್ದರೆ, ಇಲ್ಲವೆ ಅದನ್ನು ಮಾರಿದರೆ, ಅವನು ಒಂದು ಎತ್ತಿಗೆ ಬದಲಾಗಿ ಐದು ಎತ್ತುಗಳನ್ನೂ, ಒಂದು ಕುರಿಗೆ ನಾಲ್ಕು ಕುರಿಗಳನ್ನೂ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“ಒಬ್ಬ ಕಳ್ಳನು ಮನೆ ಮುರಿಯುವಾಗಲೇ ಕೈಗೆ ಸಿಕ್ಕಿದಾಗ ಅವನನ್ನು ಹೊಡೆದುಕೊಂದರೆ, ಹೊಡೆದವನ ರಕ್ತ ಸುರಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ಅವನು ಕಳ್ಳತನ ಮಾಡುವಾಗ ಸೂರ್ಯೋದಯವಾದರೆ, ಹೊಡೆದವನ ರಕ್ತ ಸುರಿಸಬೇಕು. “ಕಳ್ಳನು ಕದ್ದದ್ದನ್ನೆಲ್ಲಾ ಪೂರ್ತಿಯಾಗಿ ಹಿಂದಿರುಗಿಸಬೇಕು. ಅವನಲ್ಲಿ ಕೊಡಲು ಇಲ್ಲದ ಪಕ್ಷಕ್ಕೆ ಅವನ ಕಳ್ಳತನಕ್ಕಾಗಿ ಅವನನ್ನು ಗುಲಾಮನನ್ನಾಗಿ ಮಾರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ಕಳ್ಳತನ ಮಾಡಿದ ಎತ್ತಾಗಲಿ, ಕತ್ತೆಯಾಗಲಿ, ಕುರಿಯಾಗಲಿ ಕದ್ದವನ ಬಳಿಯಲ್ಲಿ ಜೀವವುಳ್ಳದ್ದಾಗಿ ಸಿಕ್ಕಿದರೆ ಅವನು ಎರಡರಷ್ಟು ಈಡು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ಒಬ್ಬನು ಇನ್ನೊಬ್ಬನ ಹೊಲದಲ್ಲಿ ತನ್ನ ಪಶುಗಳನ್ನು ಬಿಟ್ಟು ಬೆಳೆಯನ್ನೂ, ದ್ರಾಕ್ಷಿ ತೋಟವನ್ನೂ ಮೇಯಿಸಿದರೆ, ಅವನು ತನ್ನ ಸ್ವಂತ ಹೊಲದ ಉತ್ತಮ ಭಾಗವನ್ನೂ, ದ್ರಾಕ್ಷಿ ತೋಟದಲ್ಲಿನ ಉತ್ತಮವಾದದ್ದನ್ನೂ ಈಡು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“ಬೆಂಕಿಹತ್ತಿ ಅದು ಮುಳ್ಳಿನ ಕೊಂಪೆಗೆ ತಗುಲಿ, ಸಿವುಡುಗಳ ಬಣವೆಗಳನ್ನಾಗಲಿ, ನಿಂತ ಬೆಳೆಯನ್ನಾಗಲಿ, ಹೊಲವನ್ನಾಗಲಿ ಸುಟ್ಟುಬಿಟ್ಟರೆ, ಆ ಬೆಂಕಿಯನ್ನು ಹಚ್ಚಿದವನು ಖಂಡಿತವಾಗಿ ಈಡು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ಒಬ್ಬನು ತನ್ನ ನೆರೆಯವನಿಗೆ ತನ್ನ ಹಣವನ್ನಾಗಲಿ, ವಸ್ತುಗಳನ್ನಾಗಲಿ ಇಟ್ಟುಕೊಳ್ಳುವುದಕ್ಕೆ ಕೊಟ್ಟಾಗ, ಅದು ಅವನ ಮನೆಯಿಂದ ಕಳ್ಳತನವಾದರೆ, ಕಳ್ಳತನ ಮಾಡಿದವನು ಸಿಕ್ಕಿದರೆ, ಅವನು ಎರಡರಷ್ಟು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ಕಳ್ಳನು ಸಿಕ್ಕದೆ ಹೋದರೆ ಮನೆಯ ಯಜಮಾನನು ತನ್ನ ನೆರೆಯವನ ವಸ್ತುಗಳನ್ನು ಅವನು ಮುಟ್ಟಲಿಲ್ಲವೆಂದು ವಿಚಾರಿಸುವುದಕ್ಕೆ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅವನನ್ನು ಹಾಜರುಪಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ಎತ್ತು, ಕತ್ತೆ, ಕುರಿ ವಸ್ತ್ರಗಳ ವಿಷಯವಾದ ಎಲ್ಲಾ ಅಪರಾಧಗಳಿಗೋಸ್ಕರ ಇಲ್ಲವೆ ಕಳೆದುಹೋದ ಯಾವ ತರದ ವಸ್ತುಗಳ ವಿಷಯದಲ್ಲಿ ಒಬ್ಬನು ಇನ್ನೊಬ್ಬನ ಬಳಿಯಲ್ಲಿ ಅದನ್ನು ಕಂಡು, ‘ಇದು ತನ್ನದೆಂದು,’ ಹೇಳಿದ ಪಕ್ಷಕ್ಕೆ ಆ ಇಬ್ಬರ ವ್ಯಾಜ್ಯವು ದೇವರ ಸನ್ನಿಧಿಗೆ ಬರಬೇಕು. ನ್ಯಾಯಾಧಿಪತಿಗಳು ಯಾರನ್ನು ಅಪರಾಧಿಯೆಂದು ನಿರ್ಣಯಿಸುವರೋ, ಅವನು ಎರಡರಷ್ಟು ತನ್ನ ನೆರೆಯವನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“ಒಬ್ಬನು ತನ್ನ ನೆರೆಯವನಿಗೆ ಕತ್ತೆಯನ್ನಾದರೂ ಎತ್ತನ್ನಾದರೂ ಕುರಿಯನ್ನಾದರೂ ಬೇರೆ ಯಾವ ಪಶುವನ್ನಾದರೂ ಕಾಯುವುದಕ್ಕೆ ಕೊಟ್ಟಾಗ, ಅದು ಸತ್ತರೆ, ಇಲ್ಲವೆ ಊನವಾದರೆ, ಇಲ್ಲವೆ ಯಾರೂ ತಿಳಿಯದಂತೆ ಸುಲಿಗೆಯಾದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ತಾನು ತನ್ನ ನೆರೆಯವನ ವಸ್ತುವನ್ನು ತೆಗೆದುಕೊಳ್ಳಲಿಲ್ಲವೆಂದು ಅವರಿಬ್ಬರ ಮಧ್ಯದಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಪ್ರಮಾಣಮಾಡಬೇಕು. ಅದನ್ನು ಪಶುವಿನ ಯಜಮಾನನು ಒಪ್ಪಿದರೆ ಅವನು ಈಡುಕೊಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ಆದರೆ ಅದು ಅವನ ಬಳಿಯಿಂದ ಕಳ್ಳತನವಾಗಿ ಹೋಗಿದ್ದರೆ, ಯಜಮಾನನಿಗೆ ಈಡು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ಕಾಡುಮೃಗವು ಅದನ್ನು ಕೊಂದಿದ್ದರೆ, ಅದರ ಹೆಣವನ್ನು ಸಾಕ್ಷಿಗಾಗಿ ತರಲಿ. ಕಾಡುಮೃಗ ಕೊಂದಿದ್ದಕ್ಕೆ ಈಡುಕೊಡಬೇಕಾದ ಅವಶ್ಯಕತೆ ಇಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ಒಬ್ಬನು ತನ್ನ ನೆರೆಯವನಿಂದ ಪಶುವನ್ನು ಎರವಲಾಗಿ ತೆಗೆದುಕೊಂಡಿರಲಾಗಿ ಅದರ ಒಡೆಯನು ಅದರ ಹತ್ತಿರ ಇಲ್ಲದಿರುವಾಗ, ಆ ಪಶುವಿಗೆ ಊನವಾದರೆ, ಇಲ್ಲವೆ ಅದು ಸತ್ತರೆ ಅದಕ್ಕೆ ಅವನು ಖಂಡಿತವಾಗಿ ಈಡು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ಆದರೆ ಅದರ ಯಜಮಾನನು ಅದರ ಸಂಗಡ ಇದ್ದರೆ ಈಡು ಕೊಡದೆಯಿರಲಿ. ಅದು ಬಾಡಿಗೆಗೆ ತಂದಿದ್ದರೆ ಅದರ ಬಾಡಿಗೆಯಲ್ಲಿಯೇ ಎಣಿಕೆಯಾಗಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“ಒಬ್ಬನು ಕನ್ನಿಕೆಯನ್ನು ಮೋಸಗೊಳಿಸಿ, ಅವಳ ಸಂಗಡ ಮಲಗಿದರೆ ಅವಳು ತನ್ನ ಹೆಂಡತಿಯಾಗುವಂತೆ ಆಕೆಗೆ ಖಂಡಿತವಾಗಿ ತೆರವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ಆಕೆಯ ತಂದೆಗೆ ಆಕೆಯನ್ನು ಕೊಡುವುದಕ್ಕೆ ಮನಸ್ಸಿಲ್ಲದಿದ್ದರೆ, ಅವನಿಗೆ ಕನ್ನಿಕೆಯ ತೆರವಿನ ಪ್ರಕಾರ ಹಣ ಸಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“ಮಾಟಗಾರ್ತಿಯನ್ನು ಬದುಕಲು ಬಿಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“ಪಶುವಿನ ಸಂಗಡ ಸಂಗಮಿಸುವ ಯಾರಾದರೂ ಸರಿ, ಅಂಥವನಿಗೆ ಮರಣದಂಡನೆಯಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“ಯೆಹೋವ ದೇವರು ಹೊರತಾಗಿ ಮತ್ತೊಬ್ಬ ದೇವರಿಗೆ ಯಜ್ಞ ಅರ್ಪಿಸುವವನು ಸಂಪೂರ್ಣವಾಗಿ ನಾಶವಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“ಪರದೇಶಸ್ಥನನ್ನು ಉಪದ್ರವ ಪಡಿಸಬೇಡಿರಿ ಮತ್ತು ಬಾಧಿಸಲೂ ಬೇಡಿರಿ. ಏಕೆಂದರೆ ನೀವು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಪರದೇಶಿಗಳಾಗಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“ಯಾವ ವಿಧವೆಯನ್ನು, ದಿಕ್ಕಿಲ್ಲದ ಮಗುವನ್ನು ಬಾಧಿಸಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ನೀವು ಯಾವ ರೀತಿಯಲ್ಲಿ ಅವರನ್ನು ಬಾಧಿಸಿದರೂ ಅವರು ಕೂಗಿದರೆ ನಾನು ನಿಶ್ಚಯವಾಗಿ ಅವರ ಕೂಗನ್ನು ಕೇಳುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ಆಗ ನನ್ನ ಕೋಪವು ಉರಿಯುವುದು. ಖಡ್ಗದಿಂದ ನಿಮ್ಮನ್ನು ಕೊಲ್ಲುವೆನು. ನಿಮ್ಮ ಹೆಂಡತಿಯರು ವಿಧವೆಯರಾಗುವರು. ನಿಮ್ಮ ಮಕ್ಕಳು ದಿಕ್ಕಿಲ್ಲದವರಾಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ಬಡವರಾಗಿರುವ ನನ್ನ ಜನರಿಗೆ ಹಣವನ್ನು ಸಾಲವಾಗಿ ಕೊಟ್ಟರೆ, ಅವನಿಂದ ಬಡ್ಡಿ ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ಇಲ್ಲವೆ ಅವನ ಮೇಲೆ ಬಡ್ಡಿ ಹೊರಿಸಬೇಡ. ನಿಮ್ಮ ನೆರೆಯವನ ಮೇಲಂಗಿಯನ್ನು ಅಡವು ಇಟ್ಟುಕೊಂಡಿದ್ದರೆ, ಸೂರ್ಯನು ಮುಳುಗುವುದರೊಳಗಾಗಿ ಅವನಿಗೆ ಹಿಂದಕ್ಕೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ಏಕೆಂದರೆ ಅದು ಅವನಿಗೆ ಒಂದೇ ಹೊದಿಕೆಯಾಗಿದೆ. ಅದೇ ಅವನ ಮೈಗೆ ಉಡುಪು. ಅವನು ಯಾವುದನ್ನು ಹೊದ್ದುಕೊಂಡು ಮಲಗಿಯಾನು? ಅವನು ನನಗೆ ಮೊರೆಯಿಟ್ಟರೆ ನಾನು ಕೇಳುವೆನು. ಏಕೆಂದರೆ ನಾನು ಅನುಕಂಪ ಉಳ್ಳವನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ದೇವರನ್ನು ದೂಷಿಸಬೇಡ, ನಿನ್ನ ಜನರ ಅಧಿಕಾರಿಗಳನ್ನು ಶಪಿಸಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“ನಿನ್ನ ಧಾನ್ಯಗಳನ್ನೂ ಪಾನಗಳನ್ನೂ ನನಗೆ ಅರ್ಪಿಸುವುದಕ್ಕೆ ತಡಮಾಡಬೇಡ. “ನಿನ್ನ ಮಕ್ಕಳಲ್ಲಿ ಚೊಚ್ಚಲಾದವರನ್ನು ನನಗೆ ಮೀಸಲಾಗಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ಅದರಂತೆಯೇ ನಿಮ್ಮ ದನಕುರಿಗಳನ್ನೂ ನನಗೆ ಸಮರ್ಪಿಸಬೇಕು. ಅದು ಏಳು ದಿನಗಳು ತಾಯಿಯ ಬಳಿಯಲ್ಲಿರಲಿ, ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಅದನ್ನು ನನಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“ನೀವು ನನಗೆ ಪರಿಶುದ್ಧ ಜನರಾಗಿರಬೇಕು. ಆದ್ದರಿಂದ ಹೊಲದಲ್ಲಿ ಕಾಡುಮೃಗ ಕೊಂದದ್ದನ್ನು ನೀವು ತಿನ್ನಬಾರದು, ಅದನ್ನು ನಾಯಿಗಳಿಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ಸುಳ್ಳು ಸುದ್ದಿಯನ್ನು ಹಬ್ಬಿಸಬಾರದು. ದುರುದ್ದೇಶಪೂರಿತ ಸಾಕ್ಷಿಯಾಗುವ ಮೂಲಕ ದುಷ್ಟರಿಗೆ ಸಹಾಯಮಾಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡುವವರು ಬಹುಮಂದಿ ಆದರೂ ನೀವು ಅವರನ್ನು ಹಿಂಬಾಲಿಸಬೇಡ. ಬಹುಮಂದಿಯೊಂದಿಗೆ ನ್ಯಾಯಕ್ಕೆ ವಿರುದ್ಧವಾಗಿ ವ್ಯಾಜ್ಯದಲ್ಲಿ ಸಾಕ್ಷಿಕೊಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ಬಡವನಿಗೂ ವ್ಯಾಜ್ಯದಲ್ಲಿ ಮುಖದಾಕ್ಷಿಣ್ಯ ಮಾಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“ನೀವು ವೈರಿಯ ಎತ್ತಾಗಲಿ, ಕತ್ತೆಯಾಗಲಿ ತಪ್ಪಿಸಿಕೊಂಡು ಹೋಗುವಾಗ, ಅದು ನಿಮಗೆ ಸಿಕ್ಕಿದರೆ ನೀವು ಅದನ್ನು ಖಂಡಿತವಾಗಿ ತಿರುಗಿ ಅವನಿಗೆ ತಂದುಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ನಿಮ್ಮನ್ನು ಹಗೆ ಮಾಡುವವನ ಕತ್ತೆಯು ತನ್ನ ಹೊರೆಯ ಕೆಳಗೆ ಬಿದ್ದಿರುವುದನ್ನು ನೀವು ಕಂಡಾಗ, ಅವನಿಗೆ ಸಹಾಯ ಮಾಡುವುದಕ್ಕೆ ಮನಸ್ಸಿಲ್ಲದಿದ್ದರೂ ನೀವು ಖಂಡಿತವಾಗಿ ಅವನಿಗೆ ಸಹಾಯಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“ಬಡವನ ವ್ಯಾಜ್ಯದಲ್ಲಿ ನ್ಯಾಯವನ್ನು ತಪ್ಪಿಸಿ ತೀರ್ಪುಕೊಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ಸುಳ್ಳಿನ ವಿಷಯಗಳಿಂದ ನೀವು ದೂರವಿರಬೇಕು. ನಿರಪರಾಧಿ, ನೀತಿವಂತ ಆದ ವ್ಯಕ್ತಿಗೆ ಮರಣದಂಡನೆ ವಿಧಿಸಬಾರದು. ಅಂಥ ದುಷ್ಕೃತ್ಯ ಮಾಡಿದವನಿಗೆ ನಾನು ಶಿಕ್ಷೆ ವಿಧಿಸದೆ ಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“ಲಂಚವನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ಏಕೆಂದರೆ ಲಂಚವು ಜ್ಞಾನಿಗಳ ಕಣ್ಣುಗಳನ್ನು ಕುರುಡುಮಾಡಿ, ನಿರಪರಾಧಿಗೆ ದೊರಕಬೇಕಾದ ನ್ಯಾಯವನ್ನು ತಪ್ಪಿಸುತ್ತದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“ಪರದೇಶಿಯರನ್ನು ಪೀಡಿಸಬಾರದು. ಏಕೆಂದರೆ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ನೀವೂ ಪರದೇಶಿಗಳಾದ್ದಿರಷ್ಟೇ, ಅಂಥವರ ಮನೋವ್ಯಥೆಯನ್ನು ನಿಮಗೆ ತಿಳಿದಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ಆರು ವರ್ಷ ನಿಮ್ಮ ಭೂಮಿಗೆ ಬೀಜ ಹಾಕಿ, ಅದರ ಬೆಳೆಯನ್ನು ಕೂಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ಆದರೆ ಏಳನೆಯ ವರುಷದಲ್ಲಿ ಅದಕ್ಕೆ ವಿಶ್ರಾಂತಿಯನ್ನು ಕೊಟ್ಟು, ಅದನ್ನು ಬೀಳುಬಿಡಬೇಕು. ಆಗ ನಿಮ್ಮ ಜನರಲ್ಲಿರುವ ಬಡವರು ಅದರಲ್ಲಿ ಬೆಳೆದದ್ದನ್ನು ತಿನ್ನಲಿ. ಅವರು ಬಿಟ್ಟದ್ದನ್ನು ಕಾಡುಮೃಗಗಳು ತಿನ್ನಲಿ. ನಿಮ್ಮ ದ್ರಾಕ್ಷಿತೋಟದ, ಓಲಿವ್ ಮರಗಳ ವಿಷಯದಲ್ಲಿಯೂ ಹಾಗೆಯೇ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ಆರು ದಿವಸ ನೀವು ನಿಮ್ಮ ಕೆಲಸಗಳನ್ನು ಮಾಡಬೇಕು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ನೀವು, ನಿಮ್ಮ ಎತ್ತು ಮತ್ತು ನಿಮ್ಮ ಕತ್ತೆ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಬೇಕು. ಇದಲ್ಲದೆ ನಿಮ್ಮ ಮನೆಯಲ್ಲಿ ಜನಿಸಿದ ದಾಸದಾಸಿಯರೂ ಪರದೇಶಸ್ಥರೂ ದಣಿವು ಆರಿಸಿಕೊಳ್ಳಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ನಾನು ನಿಮಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೆಲ್ಲಾ ಜಾಗರೂಕತೆಯಿಂದ ಕೈಗೊಳ್ಳಬೇಕು. ಬೇರೆ ದೇವರುಗಳ ಹೆಸರನ್ನು ಎತ್ತಬೇಡ. ಅದನ್ನು ಉಚ್ಚರಿಸಲೂ ಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ವರ್ಷಕ್ಕೆ ಮೂರು ಸಾರಿ ನನಗೆ ಹಬ್ಬ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ಅಬೀಬ ತಿಂಗಳಿನ ನೇಮಕವಾದ ಸಮಯದಲ್ಲಿ ಏಳು ದಿನಗಳವರೆಗೆ ನಾನು ನಿಮಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು. ಏಕೆಂದರೆ ನೀವು ಆ ತಿಂಗಳಲ್ಲೇ ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಬಂದಿದ್ದೀರಿ. “ಒಬ್ಬರೂ ಕಾಣಿಕೆಯಿಲ್ಲದೆ ಬರಿಗೈಯಿಂದ ನನ್ನ ಸನ್ನಿಧಿಗೆ ಬರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“ನೀವು ಬಿತ್ತಿದ ಹೊಲದಲ್ಲಿ ಪ್ರಥಮ ಫಲವು ದೊರೆತಾಗ ಸುಗ್ಗಿ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. “ಹೊಲತೋಟಗಳ ಬೆಳೆಯನ್ನು ಕೂಡಿಸುವಾಗ ಅಂದರೆ, ವರ್ಷದ ಕೊನೆಯಲ್ಲಿ ಫಲಸಂಗ್ರಹದ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“ವರ್ಷಕ್ಕೆ ಮೂರು ಸಾರಿ ನಿಮ್ಮಲ್ಲಿರುವ ಪುರುಷರೆಲ್ಲಾ ಸಾರ್ವಭೌಮ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಕಾಣಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ಬಲಿ ಅರ್ಪಣೆಯ ರಕ್ತವನ್ನು ಹುಳಿಯಿರುವ ರೊಟ್ಟಿಯ ಸಂಗಡ ಅರ್ಪಿಸಬಾರದು. “ಯಾವುದೇ ಹಬ್ಬದ ಅರ್ಪಣೆಯಲ್ಲಿ ಕೊಬ್ಬನ್ನು ಬೆಳಗಿನವರೆಗೆ ಇಟ್ಟುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“ನಿಮ್ಮ ಭೂಮಿಯ ಪ್ರಥಮ ಫಲಗಳಲ್ಲಿ ಅತ್ಯುತ್ತಮವಾದದ್ದನ್ನು ನಿಮ್ಮ ಯೆಹೋವ ದೇವರ ಆಲಯಕ್ಕೆ ತರಬೇಕು. “ಮೇಕೆಯ ಮರಿಯನ್ನು ಅದರ ತಾಯಿಯ ಹಾಲಿನಲ್ಲಿ ಬೇಯಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“ಮಾರ್ಗದಲ್ಲಿ ನಿಮ್ಮನ್ನು ಕಾಪಾಡುವುದಕ್ಕೋಸ್ಕರವೂ ನಾನು ಸಿದ್ಧಮಾಡಿದ ಸ್ಥಳಕ್ಕೆ ತರುವುದಕ್ಕೋಸ್ಕರವೂ ನಾನು ಒಬ್ಬ ದೂತನನ್ನು ನಿಮ್ಮ ಮುಂದೆ ಕಳುಹಿಸುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ಅವನ ವಿಷಯದಲ್ಲಿ ಜಾಗ್ರತೆಯಾಗಿದ್ದು, ಅವನ ಮಾತಿಗೆ ವಿಧೇಯರಾಗಿರಿ. ಅವನಿಗೆ ಕೋಪವನ್ನೆಬ್ಬಿಸಬೇಡಿರಿ. ಏಕೆಂದರೆ ನನ್ನ ಹೆಸರು ಅವನಲ್ಲಿ ಇರುವುದರಿಂದ ಅವನು ನಿಮ್ಮ ದ್ರೋಹಗಳನ್ನು ಮನ್ನಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ಅವನ ಮಾತಿಗೆ ನೀವು ನಿಜವಾಗಿಯೂ ವಿಧೇಯರಾಗಿ ನಾನು ಹೇಳಿದ್ದನ್ನೆಲ್ಲಾ ನೀವು ಮಾಡಿದರೆ, ನಿಮ್ಮ ಶತ್ರುಗಳಿಗೆ ನಾನು ಶತ್ರುವಾಗಿಯೂ ನಿಮ್ಮ ವಿರೋಧಿಗಳಿಗೆ ನಾನು ವಿರೋಧಿಯಾಗಿಯೂ ಇರುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ಏಕೆಂದರೆ ನನ್ನ ದೂತನು ನಿಮ್ಮ ಮುಂದೆ ಹೋಗಿ ಅಮೋರಿಯರು, ಹಿತ್ತಿಯರು, ಪೆರಿಜೀಯರು, ಕಾನಾನ್ಯರು, ಹಿವ್ವಿಯರು ಮತ್ತು ಯೆಬೂಸಿಯರು ಇರುವ ದೇಶಕ್ಕೆ ನಿಮ್ಮನ್ನು ಬರಮಾಡುವನು. ಅವರನ್ನು ನಾನು ನಿರ್ಮೂಲ ಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ಅವರ ದೇವರುಗಳಿಗೆ ನೀವು ಅಡ್ಡಬೀಳಲೂಬಾರದು, ಅವುಗಳನ್ನು ಆರಾಧಿಸಲೂಬಾರದು. ಇದಲ್ಲದೆ ನೀವು ಅವರ ಕೃತ್ಯಗಳ ಪ್ರಕಾರ ಮಾಡದೆ, ಅವರನ್ನು ನಿರ್ಮೂಲ ಮಾಡಿಬಿಟ್ಟು, ಅವರ ವಿಗ್ರಹಗಳನ್ನು ಪೂರ್ಣವಾಗಿ ಒಡೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ನೀವು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರಿಗೆ ಆರಾಧನೆ ಮಾಡಬೇಕು. ಆಗ ಆತನು ನಿಮ್ಮ ಆಹಾರವನ್ನೂ ನೀರನ್ನೂ ಆಶೀರ್ವದಿಸುವನು. ನಾನು ವ್ಯಾಧಿಯನ್ನು ನಿಮ್ಮ ಮಧ್ಯದಿಂದ ತೊಲಗಿಸಿಬಿಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ಗರ್ಭ ಸ್ರಾವವಾಗಲಿ, ಬಂಜೆತನವಾಗಲಿ ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಇರುವುದಿಲ್ಲ. ನಾನು ನಿಮಗೆ ಸಂಪೂರ್ಣವಾದ ಆಯುಷ್ಯವನ್ನು ಅನುಗ್ರಹಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“ನೀವು ಹೋಗುವ ಎಲ್ಲ ಜಾಗಗಳಲ್ಲಿಯೂ ನನ್ನ ಮೇಲಿನ ಭೀತಿಯನ್ನು ನಿಮ್ಮನ್ನು ಎದುರಿಸುವ ಜನರಲ್ಲಿ ಉಂಟುಮಾಡಿಸಿ, ಕಳವಳವನ್ನು ಉಂಟುಮಾಡುವೆನು ಮತ್ತು ನಿಮ್ಮನ್ನು ವಿರೋಧಿಸುವವರೆಲ್ಲಾ ನಿಮಗೆ ಬೆನ್ನು ತೋರಿಸುವಂತೆ ಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ಹಿವ್ವಿಯರು, ಕಾನಾನ್ಯರು ಮತ್ತು ಹಿತ್ತಿಯರೂ ನಿಮ್ಮ ಎದುರಿನಿಂದ ಓಡಿಹೋಗುವಂತೆ ಕಡಜದ ಹುಳಗಳನ್ನು ನಿಮ್ಮ ಮುಂದೆ ಕಳಹಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ಭೂಮಿಯು ಬರಿದಾಗದಂತೆಯೂ ಕಾಡುಮೃಗಗಳು ನಿಮ್ಮ ವಿರೋಧವಾಗಿ ಹೆಚ್ಚಾಗದ ಹಾಗೆಯೂ ಅವುಗಳನ್ನು ಒಂದೇ ವರ್ಷದಲ್ಲಿ ನಿಮ್ಮ ಎದುರಿನಿಂದ ಓಡಿಸದೆ ");
INSERT INTO kanokcv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ನೀವು ಅಭಿವೃದ್ಧಿಯಾಗಿ ದೇಶವನ್ನು ಸ್ವತಂತ್ರಿಸಿಕೊಳ್ಳುವವರೆಗೆ ಸ್ವಲ್ಪ ಸ್ವಲ್ಪವಾಗಿ ಹೊರಡಿಸುತ್ತಿರುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“ಕೆಂಪು ಸಮುದ್ರದಿಂದ ಫಿಲಿಷ್ಟಿಯರ ಸಮುದ್ರದವರೆಗೆ ಮರುಭೂಮಿಯಿಂದ ನದಿಯವರೆಗೂ ನಿಮ್ಮ ಮೇರೆಗಳನ್ನು ನೇಮಿಸುವೆನು. ದೇಶದ ನಿವಾಸಿಗಳನ್ನು ನಿಮ್ಮ ಕೈಗಳಿಗೆ ಒಪ್ಪಿಸುವೆನು. ನೀವು ಅವರನ್ನು ನಿಮ್ಮ ಎದುರಿನಿಂದ ಓಡಿಸಿಬಿಡುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ಅವರ ಸಂಗಡ, ಅವರ ದೇವರುಗಳ ಸಂಗಡ ಯಾವ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ನನಗೆ ವಿರೋಧವಾಗಿ ನೀವು ಪಾಪಮಾಡದಂತಾಗಬೇಕಾದರೆ, ಅವರು ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿರಬಾರದು. ಏಕೆಂದರೆ ನೀವು ಅವರ ದೇವರುಗಳನ್ನು ಆರಾಧಿಸಿದರೆ ಅದು ನಿಮಗೆ ಖಂಡಿತವಾಗಿ ಉರುಲಾಗಿರುವುದು.” ");
INSERT INTO kanokcv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ತರುವಾಯ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು, ಆರೋನ್, ನಾದಾಬ್, ಅಬೀಹೂ ಮತ್ತು ಇಸ್ರಾಯೇಲಿನ ಹಿರಿಯರಲ್ಲಿ ಎಪ್ಪತ್ತು ಮಂದಿಯೂ ಈ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಯೆಹೋವ ದೇವರಾದ ನನ್ನ ಬಳಿಗೆ ಬಂದು ದೂರದಲ್ಲಿ ಆರಾಧಿಸಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ಮೋಶೆ ಒಬ್ಬನೇ ಯೆಹೋವ ದೇವರ ಸಮೀಪಕ್ಕೆ ಬರಲಿ. ಬೇರೆ ಯಾರೂ ಸಮೀಪಕ್ಕೆ ಬರಬಾರದು. ಜನರೂ ಅವನ ಸಂಗಡ ಮೇಲೇರಿ ಬರಬಾರದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ಮೋಶೆಯು ಬಂದು ಯೆಹೋವ ದೇವರ ಎಲ್ಲಾ ಮಾತುಗಳನ್ನೂ ಎಲ್ಲಾ ನ್ಯಾಯವಿಧಿಗಳನ್ನು ಜನರಿಗೆ ತಿಳಿಸಿದನು. ಆಗ ಜನರೆಲ್ಲಾ ಒಂದೇ ಸ್ವರದಿಂದ, “ಯೆಹೋವ ದೇವರು ಹೇಳಿದ ಎಲ್ಲಾ ಮಾತುಗಳ ಪ್ರಕಾರ ಮಾಡುತ್ತೇವೆ,” ಎಂದು ಉತ್ತರಕೊಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರು ಪ್ರಕಟಪಡಿಸಿದ ಮಾತುಗಳನ್ನೆಲ್ಲಾ ಬರೆದಿಟ್ಟನು. ಅವನು ಮರುದಿನ ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಬೆಟ್ಟದ ಕೆಳಗೆ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿಸಿ, ಇಸ್ರಾಯೇಲಿನ ಹನ್ನೆರಡು ಗೋತ್ರಗಳಿಗನುಸಾರವಾಗಿ ಹನ್ನೆರಡು ಸ್ತಂಭಗಳನ್ನು ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ಅವನು ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಗಳನ್ನೂ ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಹೋರಿಗಳನ್ನೂ ಅರ್ಪಿಸುವುದಕ್ಕಾಗಿ ಇಸ್ರಾಯೇಲರ ಯೌವನಸ್ಥರನ್ನು ಕಳುಹಿಸಲು ಅವರು ಅದನ್ನು ಅರ್ಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ಮೋಶೆಯು ರಕ್ತದಲ್ಲಿ ಅರ್ಧವನ್ನು ತೆಗೆದುಕೊಂಡು ಬೋಗುಣಿಗಳಲ್ಲಿ ಹಾಕಿದನು ಮತ್ತು ರಕ್ತದಲ್ಲಿ ಮಿಕ್ಕ ಅರ್ಧವನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಚಿಮುಕಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ಒಡಂಬಡಿಕೆಯ ಗ್ರಂಥವನ್ನು ತೆಗೆದುಕೊಂಡು ಜನರ ಸಭೆಯಲ್ಲಿ ಓದಿದನು. ಆಗ ಅವರು, “ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ನಾವು ಅನುಸರಿಸಿ ಅವುಗಳಿಗೆ ವಿಧೇಯರಾಗುವೆವು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ತರುವಾಯ ಮೋಶೆಯು ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ಜನರ ಮೇಲೆ ಚಿಮುಕಿಸಿ, “ಈ ಎಲ್ಲಾ ಮಾತುಗಳ ವಿಷಯದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮೊಂದಿಗೆ ಮಾಡಿದ ಒಡಂಬಡಿಕೆಯ ರಕ್ತ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ಆಗ ಮೋಶೆ, ಆರೋನ್, ನಾದಾಬ್, ಅಬೀಹೂ ಮತ್ತು ಇಸ್ರಾಯೇಲಿನ ಹಿರಿಯರಲ್ಲಿ ಎಪ್ಪತ್ತು ಮಂದಿಯೂ ಮೇಲಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ಅವರು ಇಸ್ರಾಯೇಲಿನ ದೇವರನ್ನು ನೋಡಿದರು. ಆತನ ಪಾದಗಳ ಕೆಳಗೆ ನೀಲ ವರ್ಣದ ಕಲ್ಲಿನ ಕೆಲಸಕ್ಕೆ ಸಮಾನವಾದದ್ದೂ, ಆಕಾಶದ ಹಾಗೆ ನಿರ್ಮಲವಾದದ್ದೂ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ಆದರೆ ದೇವರು ಇಸ್ರಾಯೇಲರ ಶ್ರೇಷ್ಠರನ್ನು ತಳ್ಳಿಬಿಡಲಿಲ್ಲ. ಅವರು ಸಹ ದೇವರನ್ನು ನೋಡಿ, ಊಟಮಾಡಿ, ಪಾನಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಬೆಟ್ಟವನ್ನೇರಿ, ನನ್ನ ಬಳಿಗೆ ಬಂದು ಇಲ್ಲೇ ಇರು. ನಿಯಮವನ್ನು ಹಾಗು ಆಜ್ಞೆಗಳನ್ನು ನೀನು ಜನರಿಗೆ ಬೋಧನೆಮಾಡುವಂತೆ ಬರೆದಿರುವ ಕಲ್ಲಿನ ಹಲಗೆಗಳನ್ನು ನಾನು ನಿನಗೆ ಕೊಡುತ್ತೇನೆ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ಆಗ ಮೋಶೆಯೂ ಅವನ ಸಹಾಯಕನಾದ ಯೆಹೋಶುವನೂ ದೇವರ ಬೆಟ್ಟದ ಮೇಲೆ ಹೊರಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ಆಗ ಮೋಶೆ ಹಿರಿಯರಿಗೆ, “ನಾವು ನಿಮ್ಮ ಬಳಿಗೆ ತಿರುಗಿ ಬರುವವರೆಗೆ ಇಲ್ಲಿ ನಮಗಾಗಿ ಕಾದುಕೊಂಡಿರಿ. ಆರೋನನೂ ಹೂರನೂ ನಿಮ್ಮ ಸಂಗಡ ಇರುತ್ತಾರೆ. ಯಾರಿಗಾದರೂ ವ್ಯಾಜ್ಯವಿದ್ದರೆ ಅವರ ಬಳಿಗೆ ಹೋಗಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ಮೋಶೆ ಬೆಟ್ಟವನ್ನೇರಿ ಹೋದಾಗ ಮೇಘವು ಬೆಟ್ಟವನ್ನು ಮುಚ್ಚಿಕೊಂಡಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯು ಸೀನಾಯಿ ಬೆಟ್ಟದ ಮೇಲೆ ನೆಲೆಯಾಗಿದ್ದುದರಿಂದ ಮೇಘವು ಅದನ್ನು ಆರು ದಿನಗಳವರೆಗೆ ಮುಚ್ಚಿಕೊಂಡಿತು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಆತನು ಮೇಘದೊಳಗಿಂದ ಮೋಶೆಯನ್ನು ಕರೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯ ದೃಶ್ಯವು ಇಸ್ರಾಯೇಲರ ಕಣ್ಣುಗಳ ಮುಂದೆ ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿ ದಹಿಸುವ ಅಗ್ನಿಯಂತಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ಆಗ ಮೋಶೆಯು ಮೇಘದ ಮಧ್ಯಕ್ಕೆ ಬಂದು ಬೆಟ್ಟವನ್ನೇರಿದನು. ಅವನು ಹಗಲಿರುಳು ನಲವತ್ತು ದಿವಸ ಪರ್ವತದ ಮೇಲಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ನನಗೆ ಕಾಣಿಕೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬರುವಂತೆ ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡು. ಯಾರ ಹೃದಯದಲ್ಲಿ ಕಾಣಿಕೆ ಕೊಡಬೇಕೆಂಬ ಪ್ರೇರಣೆ ಹುಟ್ಟುತ್ತದೋ, ಅಂಥವರ ಕಾಣಿಕೆಯನ್ನು ನೀನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“ನೀನು ಅವರಿಂದ ತೆಗೆದುಕೊಳ್ಳಬೇಕಾದ ಕಾಣಿಕೆಗಳು: “ಚಿನ್ನ, ಬೆಳ್ಳಿ, ಕಂಚು, ");
INSERT INTO kanokcv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದಾರಗಳು, ನಾರುಬಟ್ಟೆಗಳು, ಮೇಕೆಯ ಕೂದಲು, ");
INSERT INTO kanokcv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ಕೆಂಪು ಬಣ್ಣದಲ್ಲಿ ಅದ್ದಿದ ಟಗರುಗಳ ಚರ್ಮಗಳು, ಕಡಲುಹಂದಿಯ ಚರ್ಮಗಳು, ಜಾಲಿ ಮರದ ಕಟ್ಟಿಗೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ದೀಪಕ್ಕಾಗಿ ಓಲಿವ್ ಎಣ್ಣೆ ಮತ್ತು ಅಭಿಷೇಕಿಸುವ ಎಣ್ಣೆಗೋಸ್ಕರ ಪರಿಮಳ ಧೂಪಕ್ಕೋಸ್ಕರ ಸುಗಂಧ ದ್ರವ್ಯಗಳು, ");
INSERT INTO kanokcv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ಏಫೋದ್ ಕವಚಕ್ಕಾಗಿ ಗೋಮೇಧಿಕಗಳು ಮತ್ತು ಎದೆಪದಕದಲ್ಲಿ ಹಚ್ಚಬೇಕಾದ ನಾನಾ ರತ್ನಗಳು ಇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“ನಾನು ಅವರ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುವ ಹಾಗೆ ಅವರು ನನಗೆ ಒಂದು ಪರಿಶುದ್ಧ ಆಲಯವನ್ನು ಕಟ್ಟಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ಗುಡಾರದ ಮಾದರಿಯನ್ನೂ, ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳ ಮಾದರಿಯನ್ನೂ ನಾನು ನಿನಗೆ ತೋರಿಸುವಂತೆಯೇ ನೀನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“ಜಾಲಿ ಮರದಿಂದ ಸುಮಾರು ಒಂದು ಮೀಟರ್ ಉದ್ದ ಮತ್ತು ಅರವತ್ತೆಂಟು ಸೆಂಟಿಮೀಟರ್ ಅಗಲ ಮತ್ತು ಅರವತ್ತೆಂಟು ಸೆಂಟಿಮೀಟರ್ ಎತ್ತರವಾಗಿರುವ ಮಂಜೂಷವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ಅದನ್ನು ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಒಳಗೂ ಹೊರಗೂ ಹೊದಿಸಬೇಕು. ಅದರ ಸುತ್ತಲೂ ಬಂಗಾರದ ತೋರಣವನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ಅದಕ್ಕೆ ನಾಲ್ಕು ಬಂಗಾರದ ಬಳೆಗಳನ್ನು ಎರಕಹೊಯಿಸಿ ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಎಂದರೆ ಒಂದು ಕಡೆಯಲ್ಲಿ ಎರಡು ಬಳೆಗಳನ್ನು ಮತ್ತೊಂದು ಕಡೆಯಲ್ಲಿ ಎರಡು ಬಳೆಗಳನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ಆಮೇಲೆ ಜಾಲಿ ಮರದ ಕೋಲುಗಳನ್ನು ಮಾಡಿಸಿ, ಅವುಗಳಿಗೆ ಬಂಗಾರದಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ಮಂಜೂಷವನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಕೋಲುಗಳನ್ನು ಮಂಜೂಷದ ಎರಡು ಕಡೆಗಳಲ್ಲಿರುವ ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ಮಂಜೂಷದ ಬಳೆಗಳಲ್ಲಿಯೇ ಕೋಲುಗಳನ್ನು ಇಡಬೇಕು. ಅವುಗಳೊಳಗಿಂದ ಕೋಲುಗಳನ್ನು ತೆಗೆಯಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ಮಂಜೂಷದಲ್ಲಿ ನಾನು ನಿನಗೆ ಕೊಡುವ ಒಡಂಬಡಿಕೆಯ ಶಾಸನದ ಹಲಗೆಯನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“ಸುಮಾರು ನೂರಹತ್ತು ಸೆಂಟಿಮೀಟರ್ ಉದ್ದವೂ ಎಪ್ಪತ್ತು ಸೆಂಟಿಮೀಟರ್ ಅಗಲವೂ ಇರುವ ಕರುಣಾಸನವನ್ನು ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ಕರುಣಾಸನದ ಎರಡು ತುದಿಗಳಲ್ಲಿ ಎರಡು ಬಂಗಾರದಿಂದ ಕೆರೂಬಿಗಳನ್ನು ನಕಾಸಿ ಕೆಲಸದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ಒಂದು ಬದಿಯ ಕೊನೆಯಲ್ಲಿ ಒಂದು ಕೆರೂಬಿಯನ್ನೂ ಇನ್ನೊಂದು ಬದಿಯ ಕೊನೆಯಲ್ಲಿ ಒಂದು ಕೆರೂಬಿಯನ್ನೂ ಮಾಡಿಸಬೇಕು. ಹೀಗೆ ಕರುಣಾಸನದ ಎರಡೂ ಬದಿಗಳಲ್ಲಿ ಕೆರೂಬಿಯನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ಆ ಕೆರೂಬಿಗಳು ತಮ್ಮ ರೆಕ್ಕೆಗಳನ್ನು ಮೇಲಕ್ಕೆ ಚಾಚಿರುವಂತೆಯೂ ಕರುಣಾಸನವನ್ನು ತಮ್ಮ ರೆಕ್ಕೆಗಳಿಂದ ಮುಚ್ಚುವಂತೆಯೂ ಕೆರೂಬಿಗಳ ಮುಖಗಳು ಎದುರುಬದುರಾಗಿ ಕರುಣಾಸನವನ್ನು ನೋಡುತ್ತಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ಕರುಣಾಸನವನ್ನು ಮಂಜೂಷದ ಮೇಲಿಡಬೇಕು ಮತ್ತು ಮಂಜೂಷದಲ್ಲಿ ನಾನು ನಿನಗೆ ಕೊಡುವ ಒಡಂಬಡಿಕೆಯ ಶಾಸನಗಳನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ನಾನು ಅಲ್ಲಿ ನಿನಗೆ ದರ್ಶನವನ್ನು ಕೊಟ್ಟು, ಕರುಣಾಸನದ ಮೇಲೆ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಮೇಲಿರುವ ಎರಡು ಕೆರೂಬಿಗಳ ಮಧ್ಯದಿಂದ ಇಸ್ರಾಯೇಲರ ವಿಷಯದಲ್ಲಿ ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸುವವುಗಳನ್ನೆಲ್ಲಾ ನಿನಗೆ ತಿಳಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ಸುಮಾರು ತೊಂಬತ್ತು ಸೆಂಟಿಮೀಟರ್ ಉದ್ದ, ನಲವತ್ತೈದು ಸೆಂಟಿಮೀಟರ್ ಅಗಲ ಮತ್ತು ಅರವತ್ತೆಂಟು ಸೆಂಟಿಮೀಟರ್ ಎತ್ತರ ಇರುವ ಮೇಜನ್ನು ಜಾಲಿ ಮರದಿಂದ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಮೇಜನ್ನು ಹೊದಿಸಿ, ಅದರ ಸುತ್ತಲೂ ಬಂಗಾರದ ತೋರಣವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ಮೇಜಿನ ಸುತ್ತಲೂ ಅಂಗೈ ಅಗಲದ ಅಡ್ಡಪಟ್ಟಿಯನ್ನು ಮಾಡಿಸಿ, ಅಂಚಿನ ಸುತ್ತಲೂ ಬಂಗಾರದ ತೋರಣವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ಇದಲ್ಲದೆ ಆ ಮೇಜಿಗೆ ಬಂಗಾರದ ನಾಲ್ಕು ಬಳೆಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳನ್ನು ಅದರ ನಾಲ್ಕು ಕಾಲುಗಳಲ್ಲಿರುವ ನಾಲ್ಕು ಮೂಲೆಗಳಿಗೆ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ಅಂಚಿಗೆ ಸಮೀಪವಾಗಿ ಮೇಜನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗಲು ಇರುವ ಕೋಲುಗಳಿಗೆ ಬಳೆಗಳು ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ಮೇಜನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಕೋಲುಗಳನ್ನು, ತೋರಣವನ್ನು ಜಾಲಿ ಮರದಿಂದ ಮಾಡಿ, ಬಂಗಾರದಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ಇದಲ್ಲದೆ ನೀನು ಪಾತ್ರೆಗಳನ್ನು, ಧೂಪಾರತಿಗಳನ್ನು, ಮುಚ್ಚಳಗಳನ್ನು ಪಾನಾರ್ಪಣೆಗೆ ಹೂಜೆಗಳನ್ನೂ ಬೇಕಾದ ಬಟ್ಟಲುಗಳನ್ನೂ, ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ಮೇಜಿನ ಮೇಲೆ ನೈವೇದ್ಯದ ರೊಟ್ಟಿಯನ್ನು ಯಾವಾಗಲೂ ನನ್ನ ಮುಂದೆ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“ಶುದ್ಧ ಬಂಗಾರದಿಂದ ದೀಪಸ್ತಂಭವನ್ನು ಮಾಡಬೇಕು. ಅದರ ಬುಡವನ್ನೂ ಕಂಬವನ್ನೂ ನಕಾಸಿ ಕೆಲಸದಿಂದ ಮಾಡಬೇಕು. ದೀಪಸ್ತಂಭದ ಬುಡದಿಂದಲೇ ಅಖಂಡವಾಗಿ ಪುಷ್ಪದ ಗೊಂಚಲುಗಳಂತೆಯೂ ಹಣತೆಗಳಂತೆಯೂ ಮೊಗ್ಗುಗಳಂತೆಯೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ದೀಪಸ್ತಂಭದಿಂದ ಆರು ಕೊಂಬೆಗಳು ಹೊರ ಬಂದಿರಬೇಕು. ಅಂದರೆ ಒಂದು ಭಾಗದಿಂದ ಮೂರು ಕೊಂಬೆಗಳೂ ಮತ್ತೊಂದು ಭಾಗದಿಂದ ಮೂರು ಕೊಂಬೆಗಳೂ ಹೊರಗೆ ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ಒಂದು ಕೊಂಬೆಯಲ್ಲಿ ಬಾದಾಮಿ ಪುಷ್ಟದಂತಿರುವ ಮೂರು ಹಣತೆಗಳು, ಮೊಗ್ಗು ಪುಷ್ಟಗಳಿರಬೇಕು ಮತ್ತು ಮತ್ತೊಂದು ಕೊಂಬೆಯಲ್ಲಿ ಬಾದಾಮಿಯ ಪುಷ್ಟವಿದ್ದ ಮೂರು ಹಣತೆಗಳು, ಮೊಗ್ಗು ಪುಷ್ಟಗಳಿರಬೇಕು. ಈ ಪ್ರಕಾರ ದೀಪಸ್ತಂಭದಿಂದ ಹೊರಗೆ ಬರುವ ಆರು ಕೊಂಬೆಗಳಲ್ಲಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ದೀಪಸ್ತಂಭದಲ್ಲಿಯೇ ಬಾದಾಮಿ ಹೂವುಗಳಂತೆಯೂ ಮೊಗ್ಗುಗಳಂತೆಯೂ ಅದಕ್ಕೊಂದು ಪುಷ್ಪದ ಆಕಾರದಲ್ಲಿ ನಾಲ್ಕು ಹಣತೆಗಳು ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ದೀಪಸ್ತಂಭದಿಂದ ಹೊರಬರುವ ಒಂದು ಮೊಗ್ಗು ಮೊದಲ ಜೋಡಿ ಕೊಂಬೆಗಳ ಅಡಿಯಲ್ಲಿರಬೇಕು. ಎರಡನೇ ಮೊಗ್ಗು ಎರಡನೇ ಜೋಡಿಯ ಅಡಿಯಲ್ಲಿ ಮತ್ತು ಮೂರನೆಯ ಮೊಗ್ಗು ಮೂರನೆಯ ಜೋಡಿಯ ಅಡಿಯಲ್ಲಿ ಹೀಗೆ ಆರು ಕೊಂಬೆಗಳು ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ಅದರ ಮೊಗ್ಗುಗಳೂ ಕೊಂಬೆಗಳೂ ಅದರಿಂದಲೇ ಬಂದಿರಬೇಕು. ದೀಪಸ್ತಂಭವನ್ನೆಲ್ಲಾ ಶುದ್ಧ ಬಂಗಾರದ ಒಂದೇ ಅಚ್ಚಿನಲ್ಲಿ ಬರೆದ ಕಲಾಕೃತಿಯಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“ಅದರ ಏಳು ದೀಪಗಳನ್ನು ಮಾಡಿ ಅವು ಮುಂದುಗಡೆಯಲ್ಲಿ ಪ್ರಕಾಶಕೊಡುವಂತೆ ಅವುಗಳನ್ನು ಹೊತ್ತಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ಇದಲ್ಲದೆ ಅದರ ಕುಡಿ ಕತ್ತರಿಸುವ ಕತ್ತರಿಗಳನ್ನೂ ಬೂದಿಯ ಪಾತ್ರೆಗಳನ್ನೂ ಶುದ್ಧ ಬಂಗಾರದಿಂದಲೇ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ದೀಪಸ್ತಂಭವನ್ನೂ ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ಒಂದು ತಲಾಂತು ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ಬೆಟ್ಟದಲ್ಲಿ ನಿನಗೆ ತೋರಿಸಿದ ಮಾದರಿಯ ಪ್ರಕಾರವೇ ಅವುಗಳನ್ನು ಮಾಡುವಂತೆ ನೋಡಿಕೋ. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“ಗುಡಾರವನ್ನು ಹತ್ತು ಪರದೆಗಳಿಂದ ಮಾಡಿ, ನಯವಾಗಿ ಹೊಸೆದ ನಾರಿನಿಂದಲೂ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ಕೌಶಲ್ಯದ ಕೆಲಸದಿಂದಲೂ ಮಾಡಿದ ಕೆರೂಬಿಗಳುಳ್ಳವುಗಳಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ಎಲ್ಲಾ ಪರದೆಗಳೂ ಒಂದೇ ಅಳತೆಯವುಗಳಾಗಿರಬೇಕು. ಪ್ರತಿಯೊಂದು ಪರದೆಯು ಸುಮಾರು ಹದಿಮೂರು ಮೀಟರ್ ಉದ್ದ ಮತ್ತು ಎರಡು ಮೀಟರ್ ಅಗಲವಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ಐದು ಪರದೆಗಳನ್ನು ಒಂದಕ್ಕೊಂದು ಜೋಡಿಸಬೇಕು ಮತ್ತು ಇನ್ನುಳಿದ ಐದು ಪರದೆಗಳನ್ನೂ ಒಂದಕ್ಕೊಂದು ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನ ಒಂದು ಜೋಡಣೆಯ ಸ್ಥಳದಲ್ಲಿ ನೀಲಿ ದಾರಿನ ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಿ, ಎರಡನೆಯ ಜೋಡಣೆಯ ಕಟ್ಟಕಡೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿಯೂ ಅದೇ ಪ್ರಕಾರ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ಒಂದು ಪರದೆಯನ್ನು ಜೋಡಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಇರುವ ಇನ್ನೊಂದು ಪರದೆಯ ಕೊನೆಯಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಬೇಕು. ಆ ಕುಣಿಕೆಗಳು ಒಂದಕ್ಕೊಂದು ಎದುರುಬದುರಾಗಿ ಹಿಡಿದುಕೊಳ್ಳುವವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ಬಂಗಾರದ ಐವತ್ತು ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳಿಂದ ಪರದೆಗಳನ್ನು ಒಂದಕ್ಕೊಂದು ಜೋಡಿಸಬೇಕು. ಹೀಗೆ ಅದು ಒಂದೇ ಗುಡಾರವಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“ಇದಲ್ಲದೆ ನೀನು ಗುಡಾರದ ಮೇಲೆ ಹೊದಿಸುವುದಕ್ಕಾಗಿ ಮೇಕೆಯ ಕೂದಲಿನಿಂದ ಹನ್ನೊಂದು ಪರದೆಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ಒಂದೊಂದು ಪರದೆಯು ಸುಮಾರು ಹದಿಮೂರುವರೆ ಮೀಟರ್ ಉದ್ದ ಮತ್ತು ಒಂದುವರೆ ಮೀಟರ್ ಅಗಲ ಇರಬೇಕು. ಹನ್ನೊಂದು ಪರದೆಗಳೂ ಒಂದೇ ಅಳತೆಯಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ಐದು ಪರದೆಗಳನ್ನು ಒಂದಾಗಿ ಜೋಡಿಸಿ ಇನ್ನುಳಿದ ಆರು ಪರದೆಗಳನ್ನು ಒಂದಾಗಿ ಜೋಡಿಸಿ, ಆರನೆಯ ಪರದೆಯನ್ನು ಗುಡಾರದ ಮುಂಭಾಗದಲ್ಲಿ ಮಡಿಸಿ ತೂಗಾಡಬಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ಜೋಡಿಸುವಾಗ ಕೊನೆಯ ಒಂದು ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳನ್ನು, ಜೋಡಣೆಯಲ್ಲಿರುವ ಕೊನೆಯ ಎರಡನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ಇದಲ್ಲದೆ ಕಂಚಿನ ಐವತ್ತು ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿ, ಕೊಂಡಿಗಳನ್ನು ಕುಣಿಕೆಗಳಲ್ಲಿ ಸಿಕ್ಕಿಸಿ, ಒಂದೇ ಡೇರೆ ಆಗುವಂತೆ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ಗುಡಾರದ ಪರದೆಗಳನ್ನು ಮಿಕ್ಕಿದ ತೂಗಾಡುವಂಥದ್ದು ಎಂದರೆ ಉಳಿದ ಅರ್ಧ ಪರದೆಯು ಗುಡಾರದ ಹಿಂಭಾಗದಲ್ಲಿ ತೂಗಾಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ಗುಡಾರದ ಪರದೆಗಳ ಉದ್ದದಲ್ಲಿ ಈಚೆ ಆಚೆ ಮಿಕ್ಕಿದ ಮೊಳವು ಗುಡಾರದ ಈಚೆ ಆಚೆಯಲ್ಲಿ ಅದನ್ನು ಮುಚ್ಚುವುದಕ್ಕಾಗಿ ತೂಗಾಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ಗುಡಾರದ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಕೆಂಪು ಬಣ್ಣದಲ್ಲಿ ಅದ್ದಿ ತೆಗೆದ ಟಗರುಗಳ ಚರ್ಮದಿಂದ ಮಾಡಬೇಕು, ಅದರ ಮೇಲೆ ಕಡಲುಹಂದಿಯ ಚರ್ಮದ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“ಗುಡಾರಕ್ಕೆ ಜಾಲಿ ಮರದಿಂದ ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ಒಂದೊಂದು ಚೌಕಟ್ಟಿನ ಉದ್ದವು ಸುಮಾರು ನಾಲ್ಕುವರೆ ಮೀಟರ್ ಮತ್ತು ಅಗಲ ಅರವತ್ತೆಂಟು ಸೆಂಟಿಮೀಟರ್ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ಒಂದು ಚೌಕಟ್ಟಿಗೆ ಒಂದಕ್ಕೊಂದು ಸರಿಯಾದ ಅಂತರದಲ್ಲಿ ಎರಡು ಕೈಗಳನ್ನು ಮಾಡಬೇಕು. ಅದೇ ಪ್ರಕಾರ ಗುಡಾರದ ಎಲ್ಲಾ ಚೌಕಟ್ಟುಗಳಿಗೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ಗುಡಾರದ ದಕ್ಷಿಣ ಭಾಗದಲ್ಲಿ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳ ಕೆಳಗೆ ನಾಲ್ವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನು ಮಾಡಬೇಕು ಮತ್ತು ಒಂದೊಂದು ಚೌಕಟ್ಟಿನ ಕೆಳಗೆ ಅದರ ಎರಡು ಪಟ್ಟಿಗಳಿಗಾಗಿ ಎರಡೆರಡು ಕುಳಿಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ಹಾಗೆಯೇ ಗುಡಾರದ ಉತ್ತರ ದಿಕ್ಕಿನಲ್ಲಿ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ಮತ್ತು ಒಂದೊಂದು ಚೌಕಟ್ಟಿನ ಕೆಳಗೆ ಎರಡೆರಡು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಂತೆ ನಲವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ಗುಡಾರದ ಹಿಂಭಾಗಕ್ಕೆ ಅಂದರೆ ಪಶ್ಚಿಮದ ಕಡೆಗೆ ಆರು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ಗುಡಾರದ ಹಿಂಭಾಗದ ಎರಡು ಮೂಲೆಗಳಿಗೆ ಬೇರೆ ಎರಡು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ಈ ಮೂಲೆಗಳನ್ನು ಅಡಿಯಲ್ಲಿ ಜೋಡಿಸಿರಬೇಕು. ಮೇಲ್ಭಾಗದಲ್ಲಿಯೂ ಒಂದೇ ಬಳೆಗೆ ಜೋಡಿಸಿರಬೇಕು. ಇದೇ ರೀತಿಯಲ್ಲಿ ಅವು ಎರಡು ಮೂಲೆಗಳಲ್ಲಿ ಎರಡಕ್ಕೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ಹೀಗೆ ಅವು ಎಂಟು ಚೌಕಟ್ಟುಗಳೂ ಒಂದೊಂದು ಚೌಕಟ್ಟಿನ ಕೆಳಗೆ ಎರಡೆರಡು ಕೂರುಗದ್ದಿಗೇ ಕಲ್ಲುಗಳೂ ಇರುವುದರಿಂದ ಅವುಗಳಿಗೆ ಹದಿನಾರು ಬೆಳ್ಳಿಯ ಕೂರುಗದ್ದಿಗೇ ಕಲ್ಲುಗಳೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“ಜಾಲಿ ಮರದಿಂದ ಅಗುಳಿಗಳನ್ನು ಮಾಡಬೇಕು. ಗುಡಾರದ ಒಂದು ಕಡೆಯ ಚೌಕಟ್ಟುಗಳಿಗೆ ಐದು ಅಗುಳಿಗಳನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ಗುಡಾರದ ಇನ್ನೊಂದು ಭಾಗದ ಚೌಕಟ್ಟುಗಳಿಗೆ ಐದು ಅಗುಳಿಗಳನ್ನು, ಅದರ ಹಿಂದುಗಡೆಯ ಅಂದರೆ ಪಶ್ಚಿಮ ಭಾಗದಲ್ಲಿರುವ ಚೌಕಟ್ಟುಗಳಿಗೆ ಐದು ಅಗುಳಿಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ಮಧ್ಯದ ಅಗುಳಿಯು ಚೌಕಟ್ಟುಗಳ ನಡುವೆ ಒಂದು ಕಡೆಯಿಂದ ಮತ್ತೊಂದು ಕಡೆಯವರೆಗೆ ಮುಟ್ಟಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ಆ ಚೌಕಟ್ಟುಗಳನ್ನು ಬಂಗಾರದಿಂದ ಹೊದಿಸಬೇಕು. ಅವುಗಳಿಗೆ ಬಂಗಾರದಿಂದ ಬಳೆಗಳನ್ನು ಮಾಡಬೇಕು. ಅಗುಳಿಗಳನ್ನು ಬಂಗಾರದಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“ಹೀಗೆ ಬೆಟ್ಟದ ಮೇಲೆ ನಾನು ನಿನಗೆ ತೋರಿಸಿದ ಕ್ರಮದ ಪ್ರಕಾರ ಗುಡಾರವನ್ನು ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“ಪರದೆಯನ್ನು ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಮಾಡಬೇಕು. ಅದರ ಮೇಲೆ ಕೌಶಲ್ಯದಿಂದ ಕಸೂತಿಹಾಕಿ ಮಾಡಿದ ಕೆರೂಬಿಗಳುಳ್ಳದ್ದನ್ನಾಗಿ ಅದನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ಜಾಲಿ ಮರದ ನಾಲ್ಕು ಸ್ತಂಭಗಳನ್ನು ಮಾಡಿ, ಬಂಗಾರ ತಗಡುಗಳಿಂದ ಅವುಗಳನ್ನು ಹೊದಿಸಿದರು. ಅವುಗಳಿಗೆ ಬಂಗಾರದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿ, ಬೆಳ್ಳಿಯ ನಾಲ್ಕು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳ ಮೇಲೆ ಊರಿಕೊಂಡಿರುವ ಜಾಲಿ ಮರದ ಸ್ತಂಭಗಳಲ್ಲಿ ಅದನ್ನು ತೂಗು ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ಆ ಪರದೆಯನ್ನು ಕೊಂಡಿಗಳ ಕೆಳಗೆ ತೂಗುಹಾಕಿ, ಪರದೆಯೊಳಗೆ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷವನ್ನು ತರಬೇಕು. ಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೂ ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೂ ಮಧ್ಯದಲ್ಲಿ ಆ ಪರದೆಯನ್ನು ವಿಂಗಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಮೇಲೆ ಕರುಣಾಸನವನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ಇದಲ್ಲದೆ ಗುಡಾರದ ಉತ್ತರ ಕಡೆಯಲ್ಲಿ ಪರದೆಯ ಹೊರಗೆ ಮೇಜನ್ನು ಇಡಬೇಕು ಮತ್ತು ದೀಪಸ್ತಂಭವನ್ನು ಅದರ ಎದುರಾಗಿ ದಕ್ಷಿಣದ ದಿಕ್ಕಿನಲ್ಲಿ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರುಗಳಿಂದ ಹೊಸೆದು ಕಸೂತಿ ಕೆಲಸಮಾಡಿದ ಪರದೆಯನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ಆ ಪರದೆಗೆ ಜಾಲಿ ಮರದ ಐದು ಕಂಬಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳನ್ನು ಬಂಗಾರದಿಂದ ಹೊದಿಸಬೇಕು. ಅವುಗಳ ಕೊಂಡಿಗಳು ಬಂಗಾರದವುಗಳಾಗಿರಬೇಕು. ಅವುಗಳಿಗೆ ಐದು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನು ಕಂಚಿನಿಂದ ಎರಕಹೊಯಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“ಇದಲ್ಲದೆ ಜಾಲಿ ಮರದಿಂದ ಬಲಿಪೀಠವನ್ನು ಮಾಡಬೇಕು. ಅದರ ಎತ್ತರವು ಸುಮಾರು ಒಂದು ಮೀಟರ್ ಇರಬೇಕು. ಅದರ ಉದ್ದ ಮತ್ತು ಅಗಲವು ಸುಮಾರು ಎರಡೂವರೆ ಮೀಟರ್ ಚಚ್ಚೌಕವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಕೊಂಬುಗಳನ್ನು ಮಾಡಬೇಕು. ಆ ಕೊಂಬುಗಳು ಆ ಬಲಿಪೀಠಕ್ಕೆ ಏಕವಾಗಿರಬೇಕು. ಅವುಗಳನ್ನು ಕಂಚಿನಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ಅದರ ಬೂದಿಯನ್ನು ತೆಗೆಯುವದಕ್ಕಾಗಿ ಬಟ್ಟಲುಗಳು, ಸಲಿಕೆಗಳು, ಮುಳ್ಳುಚಮಚಗಳು, ಬೋಗುಣಿಗಳು, ಅಗ್ಗಿಷ್ಟಿಕೆಗಳು ಮತ್ತು ಬಲಿಪೀಠದ ಉಪಕರಣಗಳನ್ನೆಲ್ಲಾ ಕಂಚಿನಿಂದ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ಅದಕ್ಕೆ ಹೆಣಿಗೆ ಕೆಲಸದಿಂದ ಕಂಚಿನ ಜಾಳಿಗೆಯನ್ನು ಮಾಡಿ, ಆ ಜಾಳಿಗೆಯ ನಾಲ್ಕು ಮೂಲೆಗಳಿಗೆ ಕಂಚಿನ ನಾಲ್ಕು ಬಳೆಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ಆ ಜಾಳಿಗೆಯು ಬಲಿಪೀಠದ ಸುತ್ತಲಿರುವ ಕಟ್ಟಿಗೆಯ ಕಟ್ಟೆಯ ಕೆಳಗೆ ಇದ್ದು, ಅದನ್ನು ಬಲಿಪೀಠದ ಕೆಳಭಾಗದಿಂದ ಮಧ್ಯದವರೆಗೆ ಇರುವಂತೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ಬಲಿಪೀಠಕ್ಕೆ ಜಾಲಿ ಮರದಿಂದ ಕೋಲುಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳನ್ನು ಕಂಚಿನಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ಆ ಕೋಲುಗಳನ್ನು ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ಅವುಗಳು ಬಲಿಪೀಠವನ್ನು ಹೊರುವುದಕ್ಕೆ ಅದರ ಎರಡೂ ಬದಿಯಲ್ಲಿ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ಬಲಿಪೀಠವನ್ನು ಚೌಕಟ್ಟುಗಳಿಂದ ಪೊಳ್ಳಾಗಿರುವಂತೆ ಮಾಡಬೇಕು. ಬೆಟ್ಟದಲ್ಲಿ ನಿನಗೆ ತೋರಿಸಿದಂತೆ ಅದನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“ಗುಡಾರದ ಅಂಗಳವನ್ನು ಮಾಡಬೇಕು. ಹೇಗೆಂದರೆ ದಕ್ಷಿಣ ದಿಕ್ಕಿನಲ್ಲಿರುವ ಅಂಗಳಕ್ಕೋಸ್ಕರ ನಯವಾಗಿ ಹೊಸೆದ ನಾರಿನ ಪರದೆಗಳನ್ನು ಮಾಡಬೇಕು. ಅವು ಸುಮಾರು ನಲವತ್ತೈದು ಮೀಟರ್ ಉದ್ದವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ಆ ಕಡೆಯಲ್ಲಿ ಇಪ್ಪತ್ತು ಸ್ತಂಭಗಳು ಮತ್ತು ಅವುಗಳಿಗೆ ಇಪ್ಪತ್ತು ಕಂಚಿನ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿರಬೇಕು. ಸ್ತಂಭಗಳ ಕೊಂಡಿಗಳನ್ನು ಮತ್ತು ಅವುಗಳ ಪಟ್ಟಿಗಳನ್ನು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ಹಾಗೆಯೇ ಉತ್ತರ ದಿಕ್ಕಿನ ಪರದೆಗಳು ಸುಮಾರು ನಲವತ್ತೈದು ಮೀಟರ್ ಉದ್ದವಾಗಿರಬೇಕು, ಇಪ್ಪತ್ತು ಸ್ತಂಭಗಳು ಮತ್ತು ಇಪ್ಪತ್ತು ಕಂಚಿನ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿರಬೇಕು. ಆ ಸ್ತಂಭಗಳ ಕೊಂಡಿಗಳು ಮತ್ತು ಕಟ್ಟುಗಳು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“ಅಂಗಳದ ಪಶ್ಚಿಮ ಭಾಗದಲ್ಲಿ ಸುಮಾರು ಇಪ್ಪತ್ತಮೂರು ಮೀಟರ್ ಉದ್ದವಾದ ಪರದೆಗಳು, ಹತ್ತು ಸ್ತಂಭಗಳು ಮತ್ತು ಆ ಸ್ತಂಭಗಳಿಗೆ ಹತ್ತು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಸೂರ್ಯೋದಯದ ಕಡೆಗೆ ಅಂಗಳದ ಅಗಲವು ಸುಮಾರು ಇಪ್ಪತ್ತಮೂರು ಮೀಟರ್ ಉದ್ದವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ದ್ವಾರದ ಒಂದು ಬದಿಯ ಪರದೆಗಳು ಸುಮಾರು ಆರುವರೆ ಮೀಟರ್ ಉದ್ದವಾಗಿರಬೇಕು. ಅವುಗಳಿಗೆ ಮೂರು ಸ್ತಂಭಗಳು, ಆ ಸ್ತಂಭಗಳಿಗೆ ಮೂರು ಕಾಲು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ಎರಡೂ ಕಡೆಗಳಲ್ಲಿ ಸುಮಾರು ಆರುವರೆ ಮೀಟರ್ ಉದ್ದವಾದ ಪರದೆಗಳು, ಅವುಗಳಿಗೆ ಮೂರು ಸ್ತಂಭಗಳು ಮತ್ತು ಮೂರು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“ಗುಡಾರದ ಅಂಗಳದ ದ್ವಾರಕ್ಕಾಗಿ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಕಸೂತಿ ಕೆಲಸಮಾಡಿದ ಇಪ್ಪತ್ತು ಮೊಳದ ಪರದೆ, ಅದಕ್ಕೆ ನಾಲ್ಕು ಸ್ತಂಭಗಳು ಮತ್ತು ನಾಲ್ಕು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ಅಂಗಳದ ಸುತ್ತಲಿರುವ ಸ್ತಂಭಗಳಿಗೆಲ್ಲಾ ಬೆಳ್ಳಿಯ ಕಟ್ಟುಗಳು, ಬೆಳ್ಳಿಯ ಕೊಂಡಿಗಳು ಮತ್ತು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳು ಕಂಚಿನದ್ದಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ಅಂಗಳದ ಉದ್ದ ಸುಮಾರು ನಲವತ್ತೈದು ಮೀಟರ್, ಅಗಲ ಸುಮಾರು ಇಪ್ಪತ್ತಮೂರು ಮೀಟರ್, ಅದರ ಎತ್ತರ ಸುಮಾರು ಎರಡು ಮೀಟರ್ ಇರಬೇಕು. ಪರದೆಗಳು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದದ್ದಾಗಿದ್ದು, ಅವುಗಳ ಕುಳಿಗಳನ್ನು ಕಂಚಿನಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ಗುಡಾರದ ಕೆಲಸಕ್ಕೆ ಬೇಕಾಗುವ ಎಲ್ಲಾ ಉಪಕರಣಗಳು, ಅಂಗಳದ ಸುತ್ತಲೂ ಇರುವ ಎಲ್ಲಾ ಗೂಟಗಳೂ ಕಂಚಿನಿಂದ ಮಾಡಿದ್ದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“ಬೆಳಕಿಗೋಸ್ಕರ ದೀಪಗಳು ಯಾವಾಗಲೂ ಉರಿಯುತ್ತಿರುವಂತೆ ಅವರು ಕುಟ್ಟಿದ ಶುದ್ಧವಾದ ಓಲಿವ್ ಎಣ್ಣೆಯನ್ನು ನನ್ನ ಬಳಿಗೆ ತರುವಂತೆ ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಮುಂದೆ ಇರುವ ಪರದೆಯ ಹೊರಗೆ, ಆರೋನನು ಮತ್ತು ಅವನ ಮಕ್ಕಳು ಸಂಜೆಯಿಂದ ಉದಯದವರೆಗೆ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ದೀಪವನ್ನು ಸರಿಪಡಿಸುತ್ತಾ ಉರಿಸುತ್ತಿರಬೇಕು. ಈ ನಿಯಮವು ಇಸ್ರಾಯೇಲರಿಗೆ ಮತ್ತು ಅವರ ಸಂತತಿಯವರಿಗೆ ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“ನನಗೆ ಯಾಜಕ ಸೇವೆ ಮಾಡುವುದಕ್ಕೆ ನೀನು ಇಸ್ರಾಯೇಲರಿಂದ ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನನ್ನೂ, ಅವನ ಮಕ್ಕಳಾದ ನಾದಾಬ್, ಅಬೀಹೂ, ಎಲಿಯಾಜರ್, ಈತಾಮಾರ್ ಎಂಬುವರನ್ನು ನಿನ್ನ ಹತ್ತಿರ ಬರಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ನಿನ್ನ ಸಹೋದರನಾದ ಆರೋನನ ಗೌರವಕ್ಕೋಸ್ಕರವೂ ಅಲಂಕಾರಕ್ಕೋಸ್ಕರವೂ ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳನ್ನು ನೀನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ಇದಲ್ಲದೆ ನಾನು ಜ್ಞಾನದ ಆತ್ಮದಿಂದ ತುಂಬಿದ ವಿವೇಕದ ಹೃದಯವಿರುವವರ ಸಂಗಡ ನೀನು ಮಾತನಾಡು, ಅವರು ಆರೋನನ ವಸ್ತ್ರಗಳನ್ನು ಮಾಡಲಿ. ಅವನು ಅವುಗಳನ್ನು ಧರಿಸಿಕೊಂಡು ನನ್ನ ಯಾಜಕನಾಗುವುದಕ್ಕೆ ಪ್ರತಿಷ್ಠಿತನಾಗುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ಅವರು ಮಾಡಬೇಕಾದ ವಸ್ತ್ರಗಳು ಇವು: ಎದೆಪದಕವು, ಏಫೋದ್, ನಿಲುವಂಗಿ, ಕಸೂತಿಯ ಕೆಲಸದ ಮೇಲಂಗಿ, ಮುಂಡಾಸ, ನಡುಕಟ್ಟು. ನಿನ್ನ ಸಹೋದರನಾದ ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ನನ್ನ ಯಾಜಕರಾಗಿ ಸೇವೆ ಮಾಡುವುದಕ್ಕೆ ಅವರಿಗಾಗಿ ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳನ್ನು ಮಾಡಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ಅವರು ಬಂಗಾರ, ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರವನ್ನು ಮತ್ತು ನಯವಾದ ನಾರುಬಟ್ಟೆಯನ್ನು ಹೊಸೆದು ಉಪಯೋಗಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ಏಫೋದನ್ನು ಬಂಗಾರ, ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಕಸೂತಿ ಕೆಲಸ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ಈ ಕವಚಕ್ಕೆ ಅದರ ಎರಡೂ ಕೊನೆಗಳನ್ನು ಜೋಡಿಸುವುದಕ್ಕೆ ಎರಡು ಹೆಗಲು ಪಟ್ಟಿಗಳಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ಅದರ ಮೇಲಿರುವ ಕಸೂತಿ ಕೆಲಸದ ಏಫೋದಿನ ನಡುಕಟ್ಟನ್ನು ಒಂದೇ ರೀತಿಯ ವಸ್ತುಗಳಿಂದ ತಯಾರಿಸಬೇಕು ಅಂದರೆ ಬಂಗಾರ, ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರಿನಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಮಾಡಿದ್ದಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“ನೀನು ಎರಡು ಗೋಮೇಧಿಕ ರತ್ನಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಇಸ್ರಾಯೇಲರ ಮಕ್ಕಳ ಹೆಸರುಗಳನ್ನು ಅವುಗಳ ಮೇಲೆ ಕೆತ್ತಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ಒಂದು ರತ್ನದ ಮೇಲೆ ಆರು ಹೆಸರುಗಳನ್ನು ಮತ್ತೊಂದು ರತ್ನದ ಮೇಲೆ ಮಿಕ್ಕ ಆರು ಹೆಸರುಗಳನ್ನು ಅವರವರ ಜನನದ ಪ್ರಕಾರ ಕೆತ್ತಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ಶಿಲ್ಪಿಗನು ಕಲ್ಲಿನ ಮೇಲೆ ಮುದ್ರೆ ಕೆತ್ತುವ ಪ್ರಕಾರ, ಆ ಎರಡೂ ರತ್ನಗಳ ಮೇಲೆ ಇಸ್ರಾಯೇಲರ ಮಕ್ಕಳ ಹೆಸರುಗಳನ್ನು ಕೆತ್ತಿಸಿ, ಅವುಗಳನ್ನು ಬಂಗಾರದ ಜವೆಗಳಲ್ಲಿ ಹೊದಿಸಿದ್ದಾಗಿ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ಆ ಎರಡು ರತ್ನಗಳನ್ನು ಏಫೋದಿನ ಹೆಗಲಿನ ಭಾಗದ ಮೇಲೆ ಇಸ್ರಾಯೇಲರ ಜ್ಞಾಪಕಾರ್ಥವಾದ ರತ್ನಗಳಾಗಿ ಇಡಬೇಕು. ಆರೋನನು ತನ್ನ ಎರಡು ಹೆಗಲುಗಳ ಮೇಲೆ ಅವರ ಹೆಸರುಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಹೊರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ನೀನು ಬಂಗಾರದ ಜವೆಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ಹೊಸೆದ ಹಗ್ಗದಂತೆ ಶುದ್ಧ ಬಂಗಾರದ ಎರಡು ಸರಪಣಿಗಳನ್ನು ಹೆಣಿಗೆ ಕೆಲಸದಿಂದ ಮಾಡಿ, ಆ ಹೆಣೆದ ಸರಪಣಿಗಳ ಕೊನೆಗಳನ್ನು ಜವೆಗಳಿಗೆ ಸೇರಿಸಿಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“ದೇವನಿರ್ಣಯ ಮಾಡುವ ಆತನ ಎದೆಪದಕವನ್ನು ಕೌಶಲ್ಯ ಕೆಲಸದಿಂದ ಎಂದರೆ ಏಫೋದಿನ ಕೆಲಸದ ಹಾಗೆಯೇ ಬಂಗಾರ, ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರಿನಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ಅದು ಗೇಣು ಉದ್ದ, ಒಂದು ಗೇಣು ಅಗಲ ಮತ್ತು ಇದು ಎರಡು ಪದರುಳ್ಳದ್ದಾಗಿ ಚಚ್ಚೌಕವಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ನಂತರ ಅದರಲ್ಲಿ ನಾಲ್ಕು ಸಾಲುಗಳಾಗಿ ರತ್ನಗಳನ್ನು ಜೋಡಿಸಬೇಕು. ಮೊದಲನೆಯ ಸಾಲಿನಲ್ಲಿ ಮಾಣಿಕ್ಯ, ಪುಷ್ಯರಾಗ ಮತ್ತು ಸ್ಫಟಿಕಗಳಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ಎರಡನೆಯ ಸಾಲಿನಲ್ಲಿ ಕೆಂಪರಲು, ನೀಲ ಮತ್ತು ಪಚ್ಚೆಗಳಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ಮೂರನೆಯ ಸಾಲಿನಲ್ಲಿ ಸುವರ್ಣರತ್ನ, ಗೋಮೇಧಿಕ ಮತ್ತು ಧೂಮ್ರಮಣಿಗಳಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ನಾಲ್ಕನೆಯ ಸಾಲಿನಲ್ಲಿ ಪೀತರತ್ನ, ಗೋಮೇಧಿಕ, ಸೂರ್ಯಕಾಂತ ಶಿಲೆ ಇವುಗಳನ್ನು ಬಂಗಾರದ ಜವೆಯ ಕಲ್ಲುಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ಈ ರತ್ನಗಳು ಇಸ್ರಾಯೇಲರ ಗೋತ್ರದ ಹೆಸರುಗಳ ಪ್ರಕಾರ ಅವು ಹನ್ನೆರಡಾಗಿರಬೇಕು. ಒಂದೊಂದರ ಮೇಲೆ ಒಂದೊಂದು ಹೆಸರಿದ್ದು, ಹನ್ನೆರಡು ಗೋತ್ರಗಳ ಪ್ರಕಾರ ಮುದ್ರೆಗಳ ಹಾಗೆ ಕೆತ್ತಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ಎದೆಪದಕದ ಮೇಲಿರುವ ಕೊನೆಗಳಲ್ಲಿ ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಹೆಣೆದ ಕೆಲಸವಾಗಿರುವ ಹುರಿಗಳಂತಿರುವ ಸರಪಣಿಯನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ಆ ಎದೆಪದಕದ ಮೇಲೆ ಬಂಗಾರದ ಎರಡು ಬಳೆಗಳನ್ನು ಮಾಡಿ, ಆ ಎರಡು ಬಳೆಗಳನ್ನು ಎದೆಪದಕದ ಎರಡು ಕೊನೆಗಳಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ಬಂಗಾರದಿಂದ ಹೆಣೆದ ಆ ಎರಡು ಸರಪಣಿಗಳನ್ನು ಎದೆಪದಕದ ಕೊನೆಗಳಲ್ಲಿರುವ ಎರಡು ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ಆ ಎರಡು ಹೆಣೆದ ಸರಪಣಿಗಳ ಎರಡು ಕೊನೆಗಳನ್ನು ಎರಡು ಜವೆಗಳಲ್ಲಿ ಸೇರಿಸಿ, ಏಫೋದಿನ ಹೆಗಲು ಭಾಗಗಳ ಮುಂದುಗಡೆ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ಅದಲ್ಲದೆ ಬಂಗಾರದ ಎರಡು ಉಂಗುರಗಳನ್ನು ಮಾಡಿ, ಎದೆಪದಕದ ಎರಡು ಕೊನೆಗಳಲ್ಲಿ ಸೇರಿಸಿ, ಏಫೋದಿನ ಬದಿಗೆ ಒಳಗಡೆಯಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ಚಿನ್ನದ ಬೇರೆ ಎರಡು ಉಂಗುರಗಳನ್ನು ಮಾಡಿ, ಏಫೋದಿನ ಮುಂಬದಿಯ ಕೆಳಗಿನ ಎರಡು ಹೆಗಲಿನ ಪಟ್ಟಿಗಳಲ್ಲಿ, ಏಫೋದಿನ ವಿಚಿತ್ರವಾದ ನಡುಕಟ್ಟಿನ ಮೇಲೆ ಅದನ್ನು ಜೋಡಿಸುವ ಸ್ಥಳಕ್ಕೆ ಎದುರಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ಆ ಎದೆಪದಕವನ್ನು ಏಫೋದಿನ ವಿಚಿತ್ರವಾದ ನಡುಕಟ್ಟಿನ ಮೇಲೆ ಇರುವಂತೆಯೂ, ಎದೆಪದಕವು ಏಫೋದನ್ನು ಬಿಟ್ಟು ಅಲ್ಲಾಡದಂತೆಯೂ, ಅದರ ಉಂಗುರಗಳ ಮೂಲಕವಾಗಿ ಏಫೋದಿನ ಉಂಗುರಗಳಿಗೆ ನೀಲಿ ದಾರದಿಂದ ಕಟ್ಟಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“ಹೀಗೆ ಆರೋನನು ಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೆ ಬರುವಾಗ ಇಸ್ರಾಯೇಲರ ಹೆಸರುಗಳನ್ನು ಯಾವಾಗಲೂ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಜ್ಞಾಪಕ ಮಾಡುವುದಕ್ಕಾಗಿ ನ್ಯಾಯದ ಎದೆಪದಕವನ್ನು ತನ್ನ ಹೃದಯದ ಮೇಲೆ ಹೊರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ನಿರ್ಣಯವನ್ನು ತಿಳಿಸುವ ಎದೆಪದಕದಲ್ಲಿ ಊರೀಮ್ ಮತ್ತು ತುಮ್ಮೀಮ್‌ಗಳನ್ನು ಇಡಬೇಕು. ಆರೋನನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಗೆ ಬರುವ ಸಮಯದಲ್ಲಿ ಅವು ಅವನ ಹೃದಯದ ಮೇಲೆ ಇರಬೇಕು. ಹೀಗೆ ಆರೋನನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಯಾವಾಗಲೂ ಇಸ್ರಾಯೇಲರ ನಿರ್ಣಯಗಳನ್ನು ತನ್ನ ಹೃದಯದ ಮೇಲೆ ಹೊರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ಏಫೋದಿನ ನಿಲುವಂಗಿಯನ್ನೆಲ್ಲಾ ನೀಲಿ ಬಣ್ಣದ ಬಟ್ಟೆಯಿಂದ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ಅದರ ಮಧ್ಯದಲ್ಲಿ ಮೇಲ್ಗಡೆ ತಲೆದೂರಿಸುವುದಕ್ಕೆ ರಂದ್ರವಿರಬೇಕು. ಅದು ಹರಿಯದ ಆ ರಂದ್ರದ ಸುತ್ತಲೂ ನೇಯ್ಗೆ ಕಸೂತಿಯನ್ನು ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ನಿಲುವಂಗಿಯ ಅಂಚಿನ ಮೇಲೆ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ದಾಳಿಂಬೆ ಹಣ್ಣಿನಂತೆ ಅದರ ಅಂಚಿನ ಸುತ್ತಲೂ ಮಾಡಿ, ಅವುಗಳ ಮಧ್ಯದಲ್ಲಿ ಬಂಗಾರದ ಗಂಟೆಗಳನ್ನೂ ಸುತ್ತಲೂ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ಒಂದು ಗೆಜ್ಜೆ, ಒಂದು ದಾಳಿಂಬೆಯಂತಿರುವ ಚೆಂಡನ್ನು ಒಂದಾದ ಮೇಲೆ ಒಂದು ಮೇಲಂಗಿಯ ಅಂಚಿನ ಸುತ್ತಲೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ಇದು ಸೇವೆಗಾಗಿ ಆರೋನನ ಮೇಲೆ ಇರಬೇಕು. ಅವನು ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೆ ಬರುತ್ತಾ ಹೋಗುತ್ತಾ ಇರುವ ಸಮಯದಲ್ಲಿ, ಅವನು ಸಾಯದಂತೆ ಅವನ ಶಬ್ದವು ಕೇಳಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“ಶುದ್ಧ ಬಂಗಾರದ ತಗಡನ್ನು ಮಾಡಿ ಮುದ್ರೆ ಕೆತ್ತುವ ಪ್ರಕಾರ, ಅದರಲ್ಲಿ ಹೀಗೆ ಕೆತ್ತಬೇಕು: ‘ಯೆಹೋವ ದೇವರಿಗೆ ಪರಿಶುದ್ಧ.’ ");
INSERT INTO kanokcv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ಅದು ಮುಂಡಾಸದ ಮುಂಭಾಗದಲ್ಲಿರುವಂತೆ ಅದನ್ನು ನೀಲಿ ದಾರಿನಿಂದ ಕಟ್ಟಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಪರಿಶುದ್ಧ ದಾನಗಳನ್ನೆಲ್ಲಾ ಪರಿಶುದ್ಧ ಮಾಡುವ ಪರಿಶುದ್ಧ ಕಾರ್ಯಗಳ ದೋಷವನ್ನು ಆರೋನನು ಹೊರುವ ಹಾಗೆ ಅದು ಆರೋನನ ಹಣೆಯ ಮೇಲಿರಬೇಕು. ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಅವುಗಳೆಲ್ಲಾ ಅಂಗೀಕಾರವಾಗುವ ಹಾಗೆ ಅದು ಯಾವಾಗಲೂ ಅವನ ಹಣೆಯ ಮೇಲೆ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಕಸೂತಿ ಕೆಲಸದಿಂದ ಮಾಡಿದ ಮೇಲಂಗಿಯನ್ನೂ ನಯವಾದ ನಾರಿನಿಂದ ಮಾಡಿದ ಮುಂಡಾಸವನ್ನೂ ಹೆಣಿಗೆಯ ಕೆಲಸದಿಂದ ನಡುಕಟ್ಟನ್ನೂ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ಆರೋನನ ಮಕ್ಕಳಿಗೆ ತಕ್ಕ ಗೌರವ ಹಾಗೂ ಶೋಭೆ ಸಿಗುವಂತೆ ನಿಲುವಂಗಿಗಳನ್ನೂ, ನಡುಕಟ್ಟುಗಳನ್ನೂ ಹಾಗೂ ಪೇಟಗಳನ್ನೂ ಮಾಡಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ಅವುಗಳನ್ನು ನಿನ್ನ ಸಹೋದರ ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರಿಗೆ ತೊಡಿಸಿ, ಅವರನ್ನು ಅಭಿಷೇಕಿಸಿ, ಪ್ರತಿಷ್ಠೆ ಮಾಡು. ಅವರು ನನಗೆ ಯಾಜಕ ಸೇವೆ ಮಾಡುವ ಹಾಗೆ ಅವರನ್ನು ಶುದ್ಧಮಾಡು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“ಅವರ ಬೆತ್ತಲೆಯನ್ನು ಮುಚ್ಚುವ ಹಾಗೆ ನಾರಿನ ಚಡ್ಡಿಗಳನ್ನು ಮಾಡಿಸು. ಅವು ಸೊಂಟದಿಂದ ತೊಡೆಯವರೆಗೆ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೆ ಬರುವ ಸಮಯದಲ್ಲಿಯೂ ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಸೇವೆ ಮಾಡುವುದಕ್ಕೆ ಬಲಿಪೀಠದ ಸಮೀಪಕ್ಕೆ ಬರುವ ಸಮಯದಲ್ಲಿಯೂ ದೋಷವನ್ನು ಹೊತ್ತು ಸಾಯದ ಹಾಗೆ ಇವುಗಳನ್ನು ಹಾಕಿಕೊಂಡಿರಬೇಕು. “ಇದೇ ಆರೋನನಿಗೂ ಅವನ ತರುವಾಯ ಅವನ ಸಂತತಿಯವರಿಗೂ ಇರಬೇಕಾದ ನಿತ್ಯವಾದ ಕಟ್ಟಳೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“ಅವರು ನನಗೆ ಯಾಜಕ ಸೇವೆಮಾಡುವಂತೆ ನೀನು ಅವರನ್ನು ಶುದ್ಧ ಮಾಡಲು ಮಾಡಬೇಕಾದದ್ದೇನೆಂದರೆ: ದೋಷವಿಲ್ಲದ ಒಂದು ಹೋರಿಯನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ಅತ್ಯುತ್ತಮ ಗೋಧಿಯ ಹಿಟ್ಟಿನಿಂದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನೂ ಎಣ್ಣೆ ಹೊಯ್ದ ಹುಳಿಯಿಲ್ಲದ ಹೋಳಿಗೆಗಳನ್ನೂ ಎಣ್ಣೆ ಹಚ್ಚಿದ ಹುಳಿಯಿಲ್ಲದ ಪೂರಿಗಳನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ಇವುಗಳನ್ನು ಒಂದೇ ಬುಟ್ಟಿಯಲ್ಲಿ ಇಟ್ಟುಕೊಂಡು ಹೋರಿ ಮತ್ತು ಎರಡು ಟಗರುಗಳ ಸಂಗಡ ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿಗೆ ತಂದು, ನೀರಿನಲ್ಲಿ ಅವರನ್ನು ತೊಳೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ತರುವಾಯ ಆ ವಸ್ತ್ರಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಆರೋನನಿಗೆ ಅಂಗಿಯನ್ನೂ ಏಫೋದಿನ ನಿಲುವಂಗಿಯನ್ನೂ ಏಫೋದನ್ನೂ ಎದೆಪದಕವನ್ನೂ ತೊಡಿಸಿ, ಏಫೋದಿನ ಕಲಾತ್ಮಕವಾದ ನಡುಕಟ್ಟಿನಿಂದ ಅವನ ನಡುವನ್ನೂ ಕಟ್ಟಿ, ");
INSERT INTO kanokcv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ಅವನ ತಲೆಗೆ ಮುಂಡಾಸವನ್ನು ಇಟ್ಟು, ಮುಂಡಾಸದ ಮೇಲೆ ಪರಿಶುದ್ಧ ಪಟ್ಟವನ್ನು ಇಟ್ಟು, ");
INSERT INTO kanokcv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ಅಭಿಷೇಕಿಸುವ ಎಣ್ಣೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಅವನ ತಲೆಯ ಮೇಲೆ ಹೊಯ್ದು, ಅವನನ್ನು ಅಭಿಷೇಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ನೀನು ಅವನ ಪುತ್ರರನ್ನು ಕರೆದುಕೊಂಡು ಬಂದು ಅವರಿಗೆ ನಿಲುವಂಗಿಗಳನ್ನು ತೊಡಿಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಮುಂಡಾಸುಗಳನ್ನು ಇಟ್ಟು ನಡುಕಟ್ಟುಗಳನ್ನು ಕಟ್ಟಬೇಕು, ಅವರಿಗೆ ಹೀಗೆ ಅವರಿಗೆ ಯಾಜಕತ್ವ ಸೇವೆಯು ಶಾಶ್ವತ ಕಟ್ಟಳೆಯಾಗಿರುವುದು. “ಈ ರೀತಿಯಾಗಿ ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ನೀನು ಪ್ರತಿಷ್ಠೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ಇದಲ್ಲದೆ ಆ ಹೋರಿಯನ್ನು ಸಭೆಯ ಗುಡಾರದ ಮುಂದೆ ತರಬೇಕು. ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಹೋರಿಯ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ತರುವಾಯ ನೀನು ಆ ಹೋರಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ನೀನು ಹೋರಿಯ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ನಿನ್ನ ಬೆರಳಿನಿಂದ ಬಲಿಪೀಠದ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ, ರಕ್ತವನ್ನೆಲ್ಲಾ ಬಲಿಪೀಠದ ಅಡಿಯಲ್ಲಿ ಸುರಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ನೀನು ಕರುಳುಗಳನ್ನೂ ಅವುಗಳ ಮೇಲಿರುವ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ ಕಾಳಿಜದ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರ ಜನಕಾಂಗಗಳನ್ನೂ ಅವುಗಳ ಕೊಬ್ಬನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ಇದಲ್ಲದೆ ಹೋರಿಯ ಮಾಂಸವನ್ನೂ ಅದರ ಚರ್ಮವನ್ನೂ, ಅದರ ಸಗಣಿಯನ್ನೂ ಪಾಳೆಯದ ಹೊರಗೆ ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ಅದು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ನೀನು ಒಂದು ಟಗರನ್ನು ಸಹ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ಆ ಟಗರಿನ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ತರುವಾಯ ಆ ಟಗರನ್ನು ನೀನು ವಧಿಸಿ, ಅದರ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ಇದಲ್ಲದೆ ಆ ಟಗರನ್ನು ತುಂಡುತುಂಡಾಗಿ ಕಡಿದು, ಅದರ ಕರುಳುಗಳನ್ನೂ ಕಾಲುಗಳನ್ನೂ ತೊಳೆದು, ಅದರ ತುಂಡುಗಳನ್ನು ತಲೆಯ ಸಂಗಡ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ಅದನ್ನೆಲ್ಲಾ ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಯಾಗಿದೆ. ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯ ದಹನಬಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ಆ ಇನ್ನೊಂದು ಟಗರನ್ನು ನೀನು ತಂದಾಗ, ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಆ ಟಗರಿನ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ತರುವಾಯ ನೀನು ಅದನ್ನು ವಧಿಸಿ, ಅದರ ರಕ್ತವನ್ನು ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರ ಬಲಗಿವಿಯ ತುದಿಗೂ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಹಚ್ಚಿ, ಆ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ಆರೋನನೂ ಅವನ ವಸ್ತ್ರಗಳೂ ಅವನೊಂದಿಗೆ ಅವನ ಪುತ್ರರೂ ಅವರ ವಸ್ತ್ರಗಳೂ ಪರಿಶುದ್ಧವಾಗುವ ಹಾಗೆ ಬಲಿಪೀಠದ ಮೇಲಿರುವ ರಕ್ತವನ್ನೂ, ಅಭಿಷೇಕ ತೈಲವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಆರೋನನ ಮೇಲೆಯೂ ಅವನ ವಸ್ತ್ರಗಳ ಮೇಲೆಯೂ ಅವನ ಪುತ್ರರ ಮೇಲೆಯೂ ಅವರ ವಸ್ತ್ರಗಳ ಮೇಲೆಯೂ ನೀನು ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“ಇದಲ್ಲದೆ ಆ ಟಗರಿನ ಕೊಬ್ಬನ್ನೂ ಬಾಲವನ್ನೂ ಕರುಳುಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಕಾಳಿಜದ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರ ಜನಕಾಂಗಗಳನ್ನೂ ಅವುಗಳ ಕೊಬ್ಬನ್ನೂ ಬಲದೊಡೆಯನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಏಕೆಂದರೆ ಅದು ಪ್ರತಿಷ್ಠೆಯ ಟಗರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಪುಟ್ಟಿಯೊಳಗಿಂದ ಒಂದು ರೊಟ್ಟಿಯನ್ನೂ ಎಣ್ಣೆಯ ಒಂದು ಹೋಳಿಗೆಯನ್ನೂ ಒಂದು ಪೂರಿಯನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ನೀನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನೆಲ್ಲಾ ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರ ಕೈಗಳಿಗೆ ಕೊಟ್ಟು, ಅವರು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಅದನ್ನು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ನೀನು ಅವುಗಳನ್ನು ಅವರ ಕೈಗಳಿಂದ ತೆಗೆದುಕೊಂಡು, ಬಲಿಪೀಠದ ಮೇಲೆ ದಹನಬಲಿಯಾಗಿ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಸುವಾಸನೆಗೋಸ್ಕರ ದಹಿಸಬೇಕು. ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಅರ್ಪಣೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ಇದಲ್ಲದೆ ಆರೋನನು ಪ್ರತಿಷ್ಠೆಯ ಟಗರಿನ ಎದೆಯ ಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು, ನೈವೇದ್ಯವಾಗಿ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿವಾಳಿಸಬೇಕು. ಅದು ನಿನ್ನ ಪಾಲಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“ನೀನು ನೈವೇದ್ಯ ಮಾಡಿದ ಎದೆಯ ಭಾಗವನ್ನೂ, ಅರ್ಪಣೆ ಮಾಡಿದ ಬಲದ ಮುಂದೊಡೆಯನ್ನೂ, ಆರೋನನ, ಅವನ ಪುತ್ರರಿಗೆ ಸಲ್ಲಬೇಕಾದ ಪ್ರತಿಷ್ಠಿತ ಟಗರಿನ ಭಾಗವನ್ನು ಪ್ರತಿಷ್ಠಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ಅದು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಇಸ್ರಾಯೇಲರ ಕಡೆಯಿಂದ ನಿತ್ಯವಾಗಿ ಕೊಡುವ ಭಾಗವಾಗಿರಬೇಕು. ಏಕೆಂದರೆ ಅದು ನೈವೇದ್ಯವಾಗಿದೆ. ಇಸ್ರಾಯೇಲರ ಸಮಾಧಾನದ ಬಲಿಗಳ ಅರ್ಪಣೆಗಳಿಂದ ಅವರು ಯೆಹೋವ ದೇವರಿಗೆ ನೈವೇದ್ಯ ಮಾಡುವಂಥದ್ದು ಆಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“ಇದಲ್ಲದೆ ಆರೋನನಿಗೆ ಇದ್ದ ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳು ಅವನ ತರುವಾಯ ಅವನ ಪುತ್ರರಿಗೆ ಆಗಬೇಕು. ಅವರು ಅಭಿಷಿಕ್ತರಾಗಿ ಅವುಗಳನ್ನು ಧರಿಸಿಕೊಂಡು, ಪ್ರತಿಷ್ಠಿತರಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ಅವನ ಬದಲಾಗಿ ಅವನ ಮಗನು ಯಾಜಕತ್ವವನ್ನು ನಡೆಸಿ, ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಸೇವೆಮಾಡುವಂತೆ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಪ್ರವೇಶಿಸಿದ ದಿನದಿಂದ ಅವುಗಳನ್ನು ಏಳು ದಿನಗಳವರೆಗೆ ತೊಟ್ಟುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“ಪ್ರತಿಷ್ಠೆಯ ಟಗರನ್ನು ತೆಗೆದುಕೊಂಡು ನೀನು ಅದರ ಮಾಂಸವನ್ನು ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಬೇಯಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಟಗರಿನ ಮಾಂಸವನ್ನೂ ಪುಟ್ಟಿಯಲ್ಲಿರುವ ರೊಟ್ಟಿಯನ್ನೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ಅವರನ್ನು ಪ್ರತಿಷ್ಠೆ ಮಾಡುವುದಕ್ಕೋಸ್ಕರ ಮತ್ತು ಪರಿಶುದ್ಧ ಮಾಡುವುದಕ್ಕೋಸ್ಕರ ಅವರಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಿದವುಗಳನ್ನು ಅವರೇ ಊಟಮಾಡಬೇಕು. ಇತರರು ಅದನ್ನು ಉಣ್ಣಬಾರದು. ಏಕೆಂದರೆ ಅವು ಪರಿಶುದ್ಧವಾದವುಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ಪ್ರತಿಷ್ಠೆ ಬಲಿ ಮಾಂಸದಲ್ಲಿಯೂ ರೊಟ್ಟಿಯಲ್ಲಿಯೂ ಮರುದಿನದವರೆಗೆ ಏನಾದರೂ ಉಳಿದರೆ ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ಅದು ಪರಿಶುದ್ಧವಾಗಿರುವುದರಿಂದ ಅದನ್ನು ಮರುದಿನ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ಹೀಗೆ ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರಿರಿಗೂ ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಎಲ್ಲವುಗಳ ಪ್ರಕಾರಮಾಡಿ, ಏಳು ದಿವಸ ಅವರನ್ನು ಪ್ರತಿಷ್ಠೆ ಕ್ರಮವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ಪ್ರತಿದಿನ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಒಂದು ಹೋರಿಯನ್ನು ಯಜ್ಞ ಮಾಡಬೇಕು. ಬಲಿಪೀಠವನ್ನು ಶುದ್ಧಿಮಾಡುವುದಕ್ಕಾಗಿ ಅದರ ಮೇಲೆ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯನ್ನು ಸಮರ್ಪಿಸಿ, ಅದನ್ನು ದೇವರ ಸೇವೆಗಾಗಿ ಪ್ರತಿಷ್ಠಿಸುವುದಕ್ಕಾಗಿ ಅಭಿಷೇಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ಏಳು ದಿವಸ ಬಲಿಪೀಠಕ್ಕೊಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಿ, ಅದನ್ನು ಪವಿತ್ರ ಮಾಡಬೇಕು. ಆಗ ಬಲಿಪೀಠವು ಅತಿ ಪರಿಶುದ್ಧವಾಗಿರುವುದು. ಬಲಿಪೀಠವನ್ನು ಮುಟ್ಟುವುದೆಲ್ಲಾ ಪವಿತ್ರವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ಬಲಿಪೀಠದ ಮೇಲೆ ನೀನು ಅರ್ಪಿಸಬೇಕಾದದ್ದು ಇದೇ: ಒಂದು ವರ್ಷದ ಎರಡು ಕುರಿಮರಿಗಳನ್ನು ಪ್ರತಿದಿನ ಬಿಟ್ಟುಬಿಡದೆ ದಹನಬಲಿಯಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ಒಂದು ಕುರಿಮರಿಯನ್ನು ಮುಂಜಾನೆಯಲ್ಲಿಯೂ ಮತ್ತೊಂದನ್ನು ಸಾಯಂಕಾಲದಲ್ಲಿಯೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ಒಂದು ಲೀಟರ್ ಕುಟ್ಟಿ ತೆಗೆದ ಓಲಿವ್ ಎಣ್ಣೆಯನ್ನು ಸುಮಾರು ಒಂದುವರೆ ಕಿಲೋಗ್ರಾಂ ಗೋಧಿಹಿಟ್ಟಿಗೆ ಬೆರೆಸಿ, ಒಂದು ಲೀಟರ್ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಸಮರ್ಪಣೆಗಾಗಿ ಆ ಮೊದಲನೆಯ ಕುರಿಯ ಸಮೇತ ಹೋಮ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ಇನ್ನೊಂದು ಕುರಿಮರಿಯನ್ನು ಸಂಜೆಯಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ಬೆಳಿಗ್ಗೆ ಮಾಡಿದಂತೆಯೇ ಅದರ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ ಪಾನದ ಅರ್ಪಣೆಯನ್ನೂ ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾಗಿರುವಂತೆ ಬೆಂಕಿಯಿಂದ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“ಇದು ತಲತಲಾಂತರಗಳಲ್ಲಿಯೂ ನಿತ್ಯಕ್ಕೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಮುಂದೆ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಾನು ನಿಮ್ಮ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ಸಂಧಿಸುವಲ್ಲಿ ಇದೇ ನಿತ್ಯವಾದ ದಹನಬಲಿಯಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ಅಲ್ಲಿ ನಾನು ಇಸ್ರಾಯೇಲರನ್ನು ಸಂಧಿಸುವೆನು. ಅದು ನನ್ನ ಮಹಿಮೆಯಿಂದ ಪವಿತ್ರವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“ನಾನು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನೂ ಬಲಿಪೀಠವನ್ನೂ ಪರಿಶುದ್ಧ ಮಾಡುವೆನು. ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ನನಗೆ ಯಾಜಕ ಸೇವೆಮಾಡುವಂತೆ ಪವಿತ್ರ ಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ನಾನು ವಾಸಮಾಡಿ, ಅವರಿಗೆ ನಾನು ದೇವರಾಗಿರುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ಅವರ ಮಧ್ಯದಲ್ಲಿ ನಾನು ವಾಸವಾಗಿರುವದಕ್ಕಾಗಿ ಅವರನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ ಅವರ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಾನೇ ಎಂದು ಅವರಿಗೆ ತಿಳಿಯುವುದು. ನಾನೇ ಅವರ ದೇವರಾದ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“ನೀನು ಜಾಲಿ ಮರದ ಕಟ್ಟಿಗೆಯಿಂದ ಧೂಪವೇದಿಯನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ಅದರ ಉದ್ದ ಮತ್ತು ಅಗಲ ಸುಮಾರು ನಲವತ್ತೈದು ಸೆಂಟಿಮೀಟರ್, ಅದರ ಎತ್ತರ ಸುಮಾರು ತೊಂಬತ್ತು ಸೆಂಟಿಮೀಟರ್ ಇದ್ದು, ಅದು ಚಚ್ಚೌಕವಾಗಿರಬೇಕು. ಅದರ ಕೊಂಬುಗಳನ್ನು ಸಹ ಜಾಲಿ ಮರದಿಂದಲೇ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ಅದರ ಮೇಲ್ಭಾಗವನ್ನೂ ಅದರ ಸುತ್ತಲಿನ ಬದಿಗಳನ್ನೂ ಕೊಂಬುಗಳನ್ನೂ ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಹೊದಿಸಿ, ಅದರ ಸುತ್ತಲೂ ಬಂಗಾರದ ಗೋಟನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ಅದರ ಗೋಟಿನ ಕೆಳಗೆ ಎರಡು ಬದಿಗಿರುವ ಎರಡು ಮೂಲೆಗಳಲ್ಲಿ ಎರಡು ಬಂಗಾರದ ಬಳೆಗಳನ್ನು ಮಾಡಬೇಕು. ಇವುಗಳನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಅವುಗಳಲ್ಲಿ ಕೋಲುಗಳನ್ನು ಸಿಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ಆ ಕೋಲುಗಳನ್ನು ಜಾಲಿ ಮರದಿಂದ ಮಾಡಿ, ಅವುಗಳನ್ನು ಬಂಗಾರದಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ಅದನ್ನು ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಮುಂದೆ ಇರುವ ಪರದೆಯ ಮುಂದೆಯೂ ನಾನು ನಿನ್ನನ್ನು ಸಂಧಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಇರುವ ಮಂಜೂಷದ ಮೇಲಿನ ಕರುಣಾಸನದ ಮುಂದೆಯೂ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“ಅದರ ಮೇಲೆ ಆರೋನನು ಪರಿಮಳ ಧೂಪವನ್ನು ಸುಡಬೇಕು. ಪ್ರತಿದಿನ ಬೆಳಿಗ್ಗೆ ಸುಡಬೇಕು. ಪ್ರತಿದಿನ ಬೆಳಿಗ್ಗೆ ದೀಪಗಳನ್ನು ಸಿದ್ಧಮಾಡುವಾಗ ಅದನ್ನು ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ಆರೋನನು ಸಂಜೆ ದೀಪಗಳನ್ನು ಹಚ್ಚುವ ಸಮಯದಲ್ಲಿ ಧೂಪವೇದಿಯ ಮೇಲೆ ಧೂಪವನ್ನು ಸುಡಬೇಕು. ಅದೇ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಅರ್ಪಿಸಬೇಕಾದ ನಿತ್ಯವಾದ ಧೂಪವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ನೀವು ಅದರ ಮೇಲೆ ಬೇರೆ ಧೂಪವನ್ನಾಗಲಿ, ದಹನಬಲಿಗಳನ್ನಾಗಲಿ, ಧಾನ್ಯಗಳ ಅರ್ಪಣೆಯನ್ನಾಗಲಿ ಅರ್ಪಿಸಬಾರದು. ಇಲ್ಲವೆ ಪಾನಾರ್ಪಣೆಯನ್ನು ಅದರ ಮೇಲೆ ಹೊಯ್ಯಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ಆರೋನನು ಮತ್ತು ಅವನ ಸಂತತಿಯವರು ವರ್ಷಕ್ಕೆ ಒಂದು ಸಾರಿ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ರಕ್ತದಿಂದ ಅದರ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು.” ");
INSERT INTO kanokcv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ಆಗ ಯೆಹೋವ ದೇವರು ಪ್ರಕಟಪಡಿಸಿ ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ನೀನು ಇಸ್ರಾಯೇಲರನ್ನು ಎಣಿಸಲು ಜನಗಣತಿಯನ್ನು ತೆಗೆದುಕೊಂಡಾಗ ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನ ಜೀವನದ ವಿಮೋಚನೆಯ ಕ್ರಯವನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಕೊಡಬೇಕು. ಈ ರೀತಿ ಮಾಡಿದಲ್ಲಿ ಅವರನ್ನು ಎಣಿಸುವಾಗ ಅವರಲ್ಲಿ ವ್ಯಾಧಿ ಉಂಟಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ಲೆಕ್ಕಿತರಾದವರಲ್ಲಿ ಸೇರುವ ಪ್ರತಿಯೊಬ್ಬ ಮನುಷ್ಯನು ಕೊಡಬೇಕಾದದ್ದು ಏನೆಂದರೆ ಶೆಕೆಲಿಗೆ ಇಪ್ಪತ್ತು ಗೇರಾಗಳ ಪ್ರಕಾರವಾಗಿ ಪರಿಶುದ್ಧ ಆಲಯದ ಶೆಕೆಲಿನ ಮೇರೆಗೆ ಅರ್ಧ ಶೆಕೆಲ್ ಕೊಡಬೇಕು. ಅರ್ಧ ಶೆಕೆಲ್ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸುವ ಕಾಣಿಕೆಯಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ಲೆಕ್ಕಿತರಾದವರಲ್ಲಿ ಇಪ್ಪತ್ತು ವರ್ಷದವರೂ ಅದಕ್ಕೂ ಹೆಚ್ಚು ಪ್ರಾಯವುಳ್ಳವರೂ ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆಯನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ನಿಮ್ಮ ಜೀವನದ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕೆ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸುವ ಕಾಣಿಕೆಯನ್ನು ಕೊಡುವುದರಲ್ಲಿ ಐಶ್ವರ್ಯವಂತರು ಅರ್ಧ ಶೇಕೆಲಿಗಿಂತ ಹೆಚ್ಚು ಕೊಡಬಾರದು. ಬಡವನು ಕಡಿಮೆ ಕೊಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ಪ್ರಾಯಶ್ಚಿತ್ತದ ಹಣವನ್ನು ಇಸ್ರಾಯೇಲರಿಂದ ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನದ ಗುಡಾರದ ಕೆಲಸಕ್ಕಾಗಿ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ಇದೇ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಜ್ಞಾಪಕಾರ್ಥಕ್ಕಾಗಿಯೂ ಅವರ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿಯೂ ಇರುವುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ತೊಳೆದುಕೊಳ್ಳುವದಕ್ಕಾಗಿ ಕಂಚಿನ ಬೋಗುಣಿಯನ್ನು ಮಾಡಿಸಿ ಅದಕ್ಕೆ ಕಂಚಿನ ಪೀಠವನ್ನೂ ಮಾಡಿಸಿ, ಅದನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರ ಮತ್ತು ಬಲಿಪೀಠದ ಮಧ್ಯದಲ್ಲಿಟ್ಟು, ಅದರಲ್ಲಿ ನೀರನ್ನು ತುಂಬಿಸಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ಏಕೆಂದರೆ ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಅದರಲ್ಲಿ ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಪ್ರವೇಶಿಸುವಾಗ ಸೇವೆ ಮಾಡುವುದಕ್ಕೂ, ಬೆಂಕಿಯಿಂದ ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಯನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕೂ ಬಲಿಪೀಠದ ಬಳಿಗೆ ಬರುವಾಗ ಅವರು ಸಾಯದ ಹಾಗೆ ನೀರಿನಲ್ಲಿ ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ಅವರು ಸಾಯದ ಹಾಗೆ ತಮ್ಮ ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಇದೇ ಅವನಿಗೂ ಅವನ ಸಂತತಿಯವರಿಗೂ ತಲತಲಾಂತರಗಳಲ್ಲಿ ನಿತ್ಯವಾದ ಕಟ್ಟಳೆಯಾಗಿರಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ಉತ್ತಮವಾದ ತೈಲಗಳನ್ನು ಆರು ಕಿಲೋಗ್ರಾಂ ಸ್ವಚ್ಛವಾದ ರಕ್ತಬೋಳವು, ಇದರ ಅರ್ಧದಷ್ಟು ಮೂರು ಕಿಲೋಗ್ರಾಂ ಸುಗಂಧವಾದ ಲವಂಗಚಕ್ಕೆಯನ್ನು ಮತ್ತು ಮೂರು ಕಿಲೋಗ್ರಾಂ ಸುಗಂಧವಾದ ಬಜೆಯನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ಆರು ಕಿಲೋಗ್ರಾಂ ದಾಲ್ಚಿನ್ನಿಯನ್ನು ಪರಿಶುದ್ಧಸ್ಥಳದ ಅಳತೆಯ ಮೇರೆಗೆ ಇವುಗಳನ್ನು ನೀನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಸುಮಾರು ನಾಲ್ಕು ಲೀಟರಷ್ಟು ಓಲಿವ್ ಎಣ್ಣೆಯನ್ನು ಸಹ ತೆಗೆದುಕೊಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ಅದರಿಂದ ಸುಗಂಧಕಾರನ ವಿದ್ಯೆಯ ಪ್ರಕಾರ ಪರಿಶುದ್ಧವಾದ ಅಭಿಷೇಕ ತೈಲವನ್ನು ಮಾಡು. ಇದು ಪರಿಶುದ್ಧವಾದ ಅಭಿಷೇಕದ ತೈಲವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ಅದರಿಂದ ಸಭೆಯ ಗುಡಾರವನ್ನೂ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷವನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ಮೇಜನ್ನೂ ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ದೀಪಸ್ತಂಭವನ್ನೂ ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ಧೂಪದ ವೇದಿಯನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ದಹನಬಲಿಯ ಪೀಠವನ್ನೂ ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ಗಂಗಾಳವನ್ನೂ, ಅದರ ಕಾಲುಗಳನ್ನೂ ಅಭಿಷೇಕಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ಅವು ಮಹಾಪರಿಶುದ್ಧವಾಗುವಂತೆ ಅವುಗಳನ್ನು ಶುದ್ಧಮಾಡು. ಅವುಗಳನ್ನು ಮುಟ್ಟುವುದೆಲ್ಲವೂ ಪರಿಶುದ್ಧವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“ಆರೋನನನ್ನೂ, ಅವನ ಪುತ್ರರನ್ನೂ ಅಭಿಷೇಕಿಸಿ, ಅವರು ನನಗೆ ಯಾಜಕ ಸೇವೆಮಾಡುವಂತೆ ಅವರನ್ನು ಪ್ರತಿಷ್ಠೆ ಮಾಡು, ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ: ‘ತಲತಲಾಂತರಗಳಲ್ಲಿ ಇದು ನನಗೆ ಪರಿಶುದ್ಧವಾದ ಅಭಿಷೇಕ ಎಣ್ಣೆಯಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ಇದನ್ನು ಮನುಷ್ಯರ ಮೇಲೆ ಹೊಯ್ಯಬಾರದು. ಇದರ ಮಾದರಿಯಂತೆ ಅಥವಾ ಇದಕ್ಕೆ ಸಮಾನವಾದದ್ದನ್ನು ಮಾಡಬಾರದು. ಇದು ಪರಿಶುದ್ಧವಾದದ್ದು. ನೀವು ಸಹ ಇದನ್ನು ಪರಿಶುದ್ಧವೆಂದು ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ಇದರ ಹಾಗೆ ತೈಲ ಮಾಡುವವನೂ ಯಾಜಕನಲ್ಲದವನ ಮೇಲೆ ಇದನ್ನು ಹಚ್ಚುವವನನ್ನು ಸ್ವಜನರೊಳಗಿಂದ ತೆಗೆದುಹಾಕಬೇಕು,’ ಎಂದು ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಹಾಲು ಮಡ್ಡಿ, ಗುಗ್ಗಲ ಹಾಗೂ ಗಂಧದ ಚಕ್ಕೆ ಎಂಬ ಪರಿಮಳಗಳನ್ನೂ ಶುದ್ಧವಾದ ಸಾಮ್ರಾಣಿಯನ್ನೂ ತೆಗೆದುಕೋ. ಅವು ಸಮತೂಕವಾಗಿರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ಅದನ್ನು ಸುಗಂಧ ತೈಲ ಮಾಡುವವರ ವಿದ್ಯೆಯ ಪ್ರಕಾರ ಬೆರಸಿ, ಶುದ್ಧವಾದ ಮತ್ತು ಪವಿತ್ರವಾದ ತೈಲವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ಅದರಲ್ಲಿ ಸ್ವಲ್ಪ ಪುಡಿಮಾಡಿ, ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ನಾನು ನಿನ್ನನ್ನು ಸಂಧಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಮುಂದೆ ಇಡು. ಅದು ನಿಮಗೆ ಮಹಾಪರಿಶುದ್ಧವಾಗಿರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ನೀನು ಮಾಡುವ ಧೂಪದ ಮಾದರಿಯಂತೆ ನಿಮಗೋಸ್ಕರ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ಅದನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಪವಿತ್ರವೆಂದು ಪರಿಗಣಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ಸುವಾಸನೆಗಾಗಿ ಅದನ್ನು ಮಾಡಿಕೊಳ್ಳುವವನನ್ನು ಅವನ ಕುಲದಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಅವನಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ನೋಡು, ನಾನು ಯೆಹೂದ ಕುಲದವನಾದ ಹೂರನ ಮೊಮ್ಮಗನೂ ಊರಿಯನ ಮಗನೂ ಆದ ಬೆಚಲಯೇಲ್ ಎಂಬವನನ್ನು ಗುರುತಿಸಿ ನಾನು ಆರಿಸಿಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ನಾನು ಅವನನ್ನು ದೇವರ ಆತ್ಮನಿಂದಲೂ ಜ್ಞಾನದಿಂದಲೂ ತಿಳುವಳಿಕೆಯಿಂದಲೂ ವಿವೇಕದಿಂದಲೂ ಎಲ್ಲಾ ವಿಧವಾದ ಕೌಶಲ್ಯದಿಂದಲೂ ತುಂಬಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ಅವನು ಚಿನ್ನ, ಬೆಳ್ಳಿ, ಕಂಚಿನಲ್ಲಿ ಕಲಾತ್ಮಕವಾದ ವಿನ್ಯಾಸಗಳ ಕೆಲಸವನ್ನು ಮಾಡುವುದಕ್ಕೂ, ");
INSERT INTO kanokcv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ರತ್ನಗಳಲ್ಲಿ ಕೆತ್ತನೆಯನ್ನೂ ಮರದಲ್ಲಿ ಕೆತ್ತನೆಯನ್ನೂ ಸಕಲ ವಿಧವಾದ ಕೌಶಲ್ಯದ ಕೆಲಸವನ್ನು ಬಲ್ಲವನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ಇಗೋ, ನಾನೇ ಅವನೊಂದಿಗೆ ದಾನನ ಕುಲದವನಾದ ಅಹೀಸಾಮಾಕನ ಮಗನಾದ ಒಹೋಲಿಯಾಬನನ್ನು ನೇಮಿಸಿದ್ದೇನೆ. “ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೆಲ್ಲವನ್ನು ಮಾಡುವುದಕ್ಕೆ ಜಾಣರಾದವರೆಲ್ಲರ ಹೃದಯಗಳಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನಾದರೂ ಕಲ್ಪಿಸಿ ಮಾಡುವದಕ್ಕೆ ಜ್ಞಾನವನ್ನು ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“ದೇವದರ್ಶನದ ಗುಡಾರ, ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷ, ಅದರ ಮೇಲಿರುವ ಕರುಣಾಸನ, ಗುಡಾರದ ಎಲ್ಲಾ ಉಪಕರಣಗಳು, ");
INSERT INTO kanokcv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ಮೇಜು ಅದರ ಉಪಕರಣಗಳು, ಶುದ್ಧ ಬಂಗಾರದ ದೀಪಸ್ತಂಭ, ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳು, ಧೂಪವೇದಿ, ಬಲಿಪೀಠ, ");
INSERT INTO kanokcv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ದಹನಬಲಿಪೀಠದ ಎಲ್ಲಾ ಉಪಕರಣಗಳು, ಗಂಗಾಳ, ಅದರ ಕಾಲು, ");
INSERT INTO kanokcv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ಯಾಜಕನಾದ ಆರೋನನ ಕಲಾತ್ಮಕವಾಗಿ ನೇಯ್ದ ಸೇವಾವಸ್ತ್ರಗಳು, ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳು, ಯಾಜಕನ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೆ ಅವನ ಮಕ್ಕಳ ವಸ್ತ್ರಗಳು, ");
INSERT INTO kanokcv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ಅಭಿಷೇಕಿಸುವ ತೈಲ, ಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೋಸ್ಕರವಿರುವ ಪರಿಮಳ ಧೂಪ. “ಇವುಗಳನ್ನೆಲ್ಲಾ ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವರು ಮಾಡುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ನೀನು ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ, ‘ನಿಶ್ಚಯವಾಗಿ ನೀವು ನನ್ನ ವಿಶ್ರಾಂತಿಯ ದಿನವನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ಏಕೆಂದರೆ ನಿಮ್ಮನ್ನು ಪರಿಶುದ್ಧ ಮಾಡುವ ಯೆಹೋವ ದೇವರು ನಾನೇ ಎಂದು ನೀವು ತಿಳಿಯುವಂತೆ ಇದೇ ನನಗೂ, ನಿಮಗೂ, ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಗುರುತಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘ಹೀಗಿರುವುದರಿಂದ ನೀವು ಸಬ್ಬತ್ ದಿನವನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ಏಕೆಂದರೆ ಅದು ನಿಮಗೆ ಪರಿಶುದ್ಧವಾದದ್ದು. ಅದನ್ನು ಅಪವಿತ್ರ ಮಾಡುವ ಪ್ರತಿಯೊಬ್ಬನು ಸಾಯಲೇಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾರಾದರೂ ಕೆಲಸ ಮಾಡಿದರೆ, ಅವರನ್ನು ನಿಮ್ಮ ಜನರೊಳಗಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ಆರು ದಿವಸ ಕೆಲಸ ಮಾಡಬೇಕು. ಆದರೆ ಏಳನೆಯ ದಿನವು ಯೆಹೋವ ದೇವರಿಗೆ ಪರಿಶುದ್ಧವಾದ ಸಬ್ಬತ್ ದಿನ. ಆ ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ಕೆಲಸ ಮಾಡುವವರೆಲ್ಲಾ ಸಾಯಲೇಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ಹೀಗಿರಲಾಗಿ ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ತಲತಲಾಂತರಗಳಲ್ಲಿ ನಿತ್ಯ ಒಡಂಬಡಿಕೆಯಾಗಿ ಆಚರಿಸುವಂತೆ ಸಬ್ಬತ್ ದಿನವನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ನನಗೂ, ಇಸ್ರಾಯೇಲರಿಗೂ ಇದೇ ಶಾಶ್ವತವಾದ ಗುರುತು. ಏಕೆಂದರೆ ಆರು ದಿವಸಗಳಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಆಕಾಶವನ್ನೂ, ಭೂಮಿಯನ್ನೂ ಉಂಟುಮಾಡಿ ಏಳನೆಯ ದಿನದಲ್ಲಿ ಕೆಲಸ ನಿಲ್ಲಿಸಿ, ವಿಶ್ರಮಿಸಿಕೊಂಡರು ಎಂದು ಹೇಳು,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮಾತನಾಡಿ ಮುಗಿಸಿದ ಮೇಲೆ, ಅವನಿಗೆ ಸಾಕ್ಷಿಯ ಎರಡು ಹಲಗೆಗಳನ್ನೂ ದೇವರು ಬೆರಳಿನಿಂದ ಬರೆದ ಕಲ್ಲಿನ ಹಲಗೆಗಳನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ಮೋಶೆಯು ಬೆಟ್ಟದಿಂದ ಇಳಿಯದೆ ತಡಮಾಡಿದ್ದನ್ನು ಇಸ್ರಾಯೇಲರು ನೋಡಿದಾಗ, ಅವರು ಆರೋನನ ಬಳಿಗೆ ಕೂಡಿಬಂದು ಅವನಿಗೆ, “ನೀನು ಎದ್ದು ನಮ್ಮನ್ನು ಮುನ್ನಡೆಸಿಕೊಂಡು ಹೋಗುವ ದೇವರುಗಳನ್ನು ನಮಗಾಗಿ ಮಾಡು. ಏಕೆಂದರೆ ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ನಮ್ಮನ್ನು ಕರೆದುಕೊಂಡು ಬಂದ ಮನುಷ್ಯನಾದ ಈ ಮೋಶೆಗೆ ಏನಾಯಿತೋ ನಮಗೆ ತಿಳಿಯದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ಅದಕ್ಕೆ ಆರೋನನು ಅವರಿಗೆ, “ನಿಮ್ಮ ಹೆಂಡತಿಯರ ಮತ್ತು ನಿಮ್ಮ ಪುತ್ರಪುತ್ರಿಯರ ಕಿವಿಗಳಲ್ಲಿರುವ ಚಿನ್ನದ ವಾಲೆಗಳನ್ನು ಬಿಚ್ಚಿ ನನ್ನ ಬಳಿಗೆ ತನ್ನಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ಆಗ ಜನರೆಲ್ಲರೂ ತಮ್ಮ ಕಿವಿಗಳಲ್ಲಿದ್ದ ಚಿನ್ನದ ವಾಲೆಗಳನ್ನು ಕಿತ್ತು ಆರೋನನ ಬಳಿಗೆ ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ಅವನು ಅವುಗಳನ್ನು ಅವರ ಕೈಗಳಿಂದ ತೆಗೆದುಕೊಂಡು, ಉಳಿಯಿಂದ ರೂಪಿಸಿ, ಎರಕ ಹೊಯ್ದು, ಕರುವಾಗಿ ಮಾಡಿದನು. ಆಗ ಅವರು, “ಇಸ್ರಾಯೇಲರೇ, ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿನಿಂದ ಬರಮಾಡಿದ ನಿಮ್ಮ ದೇವರುಗಳು ಇವೇ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ಆರೋನನು ಅದನ್ನು ನೋಡಿ ಅದರ ಮುಂದೆ ಬಲಿಪೀಠವನ್ನು ಕಟ್ಟಿದನು. “ನಾಳೆ ಯೆಹೋವ ದೇವರಿಗೆ ಹಬ್ಬ,” ಎಂದು ಪ್ರಕಟಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ಮರುದಿನ ಬೆಳಿಗ್ಗೆ ಜನರು ಎದ್ದು, ದಹನಬಲಿಗಳನ್ನೂ, ಸಮಾಧಾನ ಬಲಿಗಳನ್ನೂ ಸಮರ್ಪಿಸಿದರು. ಬಳಿಕ ತಿನ್ನಲೂ ಕುಡಿಯಲೂ ಕುಳಿತುಕೊಂಡರು, ಆಮೇಲೆ ಎದ್ದು ಕುಣಿದಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಇಳಿದು ಹೋಗು ಏಕೆಂದರೆ ನೀನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದ ನಿನ್ನ ಜನರು ತಮ್ಮನ್ನು ಕೆಡಿಸಿಕೊಂಡಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ನಾನು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮಾರ್ಗವನ್ನು ಬೇಗನೆ ಬಿಟ್ಟು, ತಮಗೆ ಎರಕ ಹೊಯ್ದ ಕರುವನ್ನು ಮಾಡಿಕೊಂಡು, ಅದನ್ನು ಆರಾಧಿಸುತ್ತಾ, ಅದಕ್ಕೆ ಬಲಿ ಅರ್ಪಿಸಿ, ‘ಇಸ್ರಾಯೇಲರೇ, ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದ ನಿಮ್ಮ ದೇವರುಗಳು ಇವುಗಳೇ,’ ಎಂದು ಹೇಳುತ್ತಿದ್ದಾರೆ.” ");
INSERT INTO kanokcv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನಾನು ಈ ಜನರನ್ನು ನೋಡಿದ್ದೇನೆ. ಇವರು ಹಟಮಾರಿ ಜನರೇ, ");
INSERT INTO kanokcv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ಹೀಗಿರುವುದರಿಂದ ನನ್ನ ಕೋಪಾಗ್ನಿಯು ಅವರ ಮೇಲೆ ಉರಿದು ಅವರನ್ನು ದಹಿಸಿಬಿಡುವಂತೆ ನನ್ನನ್ನು ಬಿಡು. ತರುವಾಯ ನಾನು ನಿನ್ನನ್ನು ದೊಡ್ಡ ಜನಾಂಗವಾಗುವಂತೆ ಮಾಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ಅದಕ್ಕೆ ಮೋಶೆ, ತನ್ನ ದೇವರಾದ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಬೇಡಿಕೊಂಡು ಹೇಳಿದ್ದೇನೆಂದರೆ, “ಯೆಹೋವ ದೇವರೇ, ನೀವು ಮಹಾಶಕ್ತಿಯಿಂದಲೂ, ಬಲವುಳ್ಳ ಕೈಯಿಂದಲೂ ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ ನಿಮ್ಮ ಜನರ ಮೇಲೆ ಏಕೆ ನಿಮ್ಮ ಕೋಪವು ಉರಿಯುವುದು? ");
INSERT INTO kanokcv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","‘ಕೇಡಿನ ನಿಮಿತ್ತವೂ ಬೆಟ್ಟಗಳಲ್ಲಿ ಅವರನ್ನು ಸಾಯಿಸಿ, ಭೂಮಿಯ ಮೇಲಿನಿಂದ ಅವರನ್ನು ಅಳಿಸಿಬಿಡುವುದಕ್ಕೂ, ದೇವರು ಅವರನ್ನು ಹೊರಗೆ ಬರಮಾಡಿದ್ದಾರೆ,’ ಎಂದು ಈಜಿಪ್ಟಿನವರು ಏಕೆ ಹೇಳಬೇಕು? ತಾವು ಕೋಪಾಗ್ನಿಯನ್ನು ಬಿಟ್ಟು ತಿರುಗಿಕೊಳ್ಳಿ. ನಿಮ್ಮ ಜನರಿಗೆ ವಿರೋಧವಾದ ಈ ಕೇಡಿನ ವಿಷಯದಲ್ಲಿ ತಮ್ಮ ಮನಸ್ಸನ್ನು ಬದಲಾಯಿಸಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ಆ ನಿಮ್ಮ ಸೇವಕರಾದ ಅಬ್ರಹಾಮನನ್ನೂ, ಇಸಾಕನನ್ನೂ, ಇಸ್ರಾಯೇಲನನ್ನೂ ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಿರಿ, ಯಾರಿಗೆ ನೀವು ಆಣೆಯಿಟ್ಟು ಪ್ರಮಾಣಮಾಡಿ: ‘ಆಕಾಶದ ನಕ್ಷತ್ರಗಳ ಹಾಗೆ ನಿನ್ನ ಸಂತತಿಯನ್ನು ಹೆಚ್ಚಿಸಿ, ನಾನು ಹೇಳಿದ ಈ ದೇಶವನ್ನು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಕೊಡುವೆನು ಮತ್ತು ಅವರು ನಿತ್ಯವಾಗಿ ಸ್ವಾಧೀನವಾಗಿಟ್ಟುಕೊಳ್ಳುವರು’ ಎಂದು ಮಾತುಕೊಡಲಿಲ್ಲವೆ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ಆಗ ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಜನರಿಗೆ ಮಾಡುವೆನೆಂದು ಹೇಳಿದ ಕೇಡಿನ ವಿಷಯದಲ್ಲಿ ಮನಸ್ಸನ್ನು ಮಾರ್ಪಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ಮೋಶೆಯು ತಿರುಗಿಕೊಂಡು ಎರಡೂ ಬದಿಯಲ್ಲಿ ಬರೆದಿರುವ ಸಾಕ್ಷಿಯ ಎರಡು ಹಲಗೆಗಳನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡು ಬೆಟ್ಟದಿಂದ ಇಳಿದು ಬಂದನು. ಆ ಹಲಗೆಗಳ ಎರಡೂ ಬದಿಗಳಲ್ಲಿ ಅಂದರೆ ಈ ಕಡೆಯಲ್ಲಿಯೂ ಮತ್ತು ಆ ಕಡೆಯಲ್ಲಿಯೂ ಬರಹವಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ಆ ಹಲಗೆಗಳು ದೇವರ ಕೆಲಸಗಳಾಗಿದ್ದವು. ಆ ಹಲಗೆಗಳ ಮೇಲೆ ಕೆತ್ತಿದ ಬರಹವು ದೇವರದ್ದೇ ಆಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ಯೆಹೋಶುವನು ಜನರು ಕೂಗುತ್ತಿದ್ದ ಶಬ್ದವನ್ನು ಕೇಳಿ ಮೋಶೆಗೆ, “ಪಾಳೆಯದ ಕಡೆಯಿಂದ ಯುದ್ಧದ ಶಬ್ದವು ಕೇಳಿಸುತ್ತದೆ,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ಅದಕ್ಕೆ ಮೋಶೆಯು ಹೀಗೆ ಉತ್ತರಿಸಿದನು: “ಅದು ಜಯಧ್ವನಿಯು ಅಲ್ಲ, ಅಪಜಯದ ಧ್ವನಿಯೂ ಅಲ್ಲ. ಆದರೆ ನನಗೆ ಹಾಡುವ ಧ್ವನಿಯು ಕೇಳಿಸುತ್ತಿದೆ.” ");
INSERT INTO kanokcv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ಇದಾದ ಮೇಲೆ ಮೋಶೆ ಪಾಳೆಯದ ಸಮೀಪಕ್ಕೆ ಬಂದು ಆ ಕರುವನ್ನೂ, ಅವರ ಕುಣಿದಾಟವನ್ನೂ ನೋಡಿದಾಗ, ಮೋಶೆಯು ಕೋಪಗೊಂಡು ಕೈಯಲ್ಲಿದ್ದ ಹಲಗೆಗಳನ್ನು ಬೆಟ್ಟದ ಅಡಿಯಲ್ಲಿ ಬಿಸಾಡಿ ಅವುಗಳನ್ನು ಒಡೆದುಬಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ಅವರು ಮಾಡಿದ ಕರುವನ್ನು ಅವನು ತೆಗೆದುಕೊಂಡು, ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟು ಪುಡಿಯಾಗುವವರೆಗೆ ಅರೆದು ನೀರಿನ ಮೇಲೆ ಚೆಲ್ಲಿ, ಆ ನೀರನ್ನು ಇಸ್ರಾಯೇಲರು ಕುಡಿಯುವಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ಈ ಜನರ ಮೇಲೆ ದೊಡ್ಡ ಪಾಪವನ್ನು ನೀನು ಬರಮಾಡುವಂತೆ ಅವರು ನಿನಗೆ ಏನು ಮಾಡಿದರು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ಅದಕ್ಕೆ ಆರೋನನು, “ನನ್ನ ಒಡೆಯನೇ ಕೋಪಗೊಳ್ಳಬೇಡಿ ಈ ಜನರು ಕೆಡುಕಿನ ಮನಸ್ಸಿನವರಾಗಿದ್ದಾರೆಂದು ನೀವು ಬಲ್ಲಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ಅವರು ನನಗೆ, ‘ನಮ್ಮನ್ನು ಮುನ್ನಡೆಸಿಕೊಂಡು ಹೋಗುವ ದೇವರುಗಳನ್ನು ಮಾಡು. ಏಕೆಂದರೆ ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ನಮ್ಮನ್ನು ಬರಮಾಡಿದ ಈ ಮೋಶೆಗೆ ಏನಾಯಿತೋ ನಮಗೆ ತಿಳಿಯದು,’ ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ಆದ್ದರಿಂದ ನಾನು ಅವರಿಗೆ, ‘ಚಿನ್ನ ಇದ್ದವರು ಅದನ್ನು ತರಲಿ,’ ಎಂದೆನು. ಅವರು ಅದನ್ನು ನನಗೆ ಕೊಟ್ಟರು. ಆಗ ನಾನು ಅದನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಹಾಕಿದಾಗ, ಈ ಕರುವು ಉಂಟಾಯಿತು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ಮೋಶೆಯು ಜನರು ಕ್ರಮವಿಲ್ಲದಿರುವುದನ್ನು ಕಂಡನು. ಆರೋನನು ಅವರನ್ನು ಮಿತಿಮೀರಿ ಇಷ್ಟಬಂದಂತೆ ಮಾಡುವದಕ್ಕೆ ಅವಕಾಶ ಮಾಡಿಕೊಟ್ಟದ್ದರಿಂದ ಅವರ ವೈರಿಗಳ ಮುಂದೆ ಅಪಹಾಸ್ಯಕ್ಕೆ ಆಸ್ಪದವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ಮೋಶೆಯು ಪಾಳೆಯದ ಬಾಗಿಲಲ್ಲಿ ನಿಂತುಕೊಂಡು, “ಯೆಹೋವ ದೇವರ ಪಕ್ಷದವರೆಲ್ಲರೂ ನನ್ನ ಬಳಿಗೆ ಬರಲಿ,” ಎಂದನು. ಆಗ ಲೇವಿಯರೆಲ್ಲರು ಅವನ ಬಳಿಗೆ ಕೂಡಿಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ಆಗ ಅವನು ಅವರಿಗೆ, “ಇಸ್ರಾಯೇಲಿನ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಹೀಗೆ ಹೇಳುತ್ತಾರೆ, ‘ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನ ಖಡ್ಗವನ್ನು ಪಕ್ಕದಲ್ಲಿ ಕಟ್ಟಿಕೊಂಡು ಪಾಳೆಯದಲ್ಲೆಲ್ಲಾ ಒಂದು ದ್ವಾರದಿಂದ ಇನ್ನೊಂದು ದ್ವಾರಕ್ಕೆ ಹೋಗಿ ಹೋಗುತ್ತಾ ಬರುತ್ತಾ ತನ್ನ ಸಹೋದರನನ್ನೂ, ತನ್ನ ಜೊತೆಗಾರನನ್ನೂ ಮತ್ತು ನೆರೆಹೊರೆಯವನೆಂದು ಲಕ್ಷಿಸದೆ ಕೊಲ್ಲಲಿ,’ ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ಲೇವಿಯರು ಮೋಶೆಯು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಮಾಡಿದರು. ಆ ದಿನ ಹೆಚ್ಚು ಕಡಿಮೆ ಮೂರು ಸಾವಿರ ಜನರು ಸತ್ತರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ಆಗ ಮೋಶೆ ಆ ಲೇವಿಯರಿಗೆ, “ಈ ದಿನ ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ಮಗನನ್ನಾದರೂ, ಅಣ್ಣತಮ್ಮಂದಿರನ್ನಾದರೂ ಲಕ್ಷ್ಯಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳದೆ, ನಿಮ್ಮನ್ನೇ ಯೆಹೋವ ದೇವರ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಾಪಿಸಿಕೊಂಡಿದ್ದೀರಿ. ಆದ್ದರಿಂದ ಅವರು ಈ ದಿನ ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸಿರುವರು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ಮರುದಿನದಲ್ಲಿ, ಮೋಶೆಯು ಜನರಿಗೆ, “ನೀವು ದೊಡ್ಡ ಪಾಪವನ್ನು ಮಾಡಿದ್ದೀರಿ. ಆದ್ದರಿಂದ ನಾನು ಈಗ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಯೆಹೋವ ದೇವರ ಬಳಿಗೆ ಹೋಗುವೆನು. ಒಂದು ವೇಳೆ ನಿಮ್ಮ ಪಾಪಕ್ಕಾಗಿ ನಾನು ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಿಕೊಳ್ಳಬಹುದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ಹೀಗೆ ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಬಳಿಗೆ ತಿರುಗಿ ಹೋಗಿ, “ಅಯ್ಯೋ, ಈ ಜನರು ದೊಡ್ಡ ಪಾಪವನ್ನು ಮಾಡಿದ್ದಾರೆ. ಅವರು ತಮಗೆ ಚಿನ್ನದ ದೇವರುಗಳನ್ನು ಮಾಡಿಕೊಂಡಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ಆದರೂ ಈಗ ನೀವು ಅವರ ಪಾಪವನ್ನು ಕ್ಷಮಿಸಬೇಕು. ಇಲ್ಲವಾದರೆ ನೀವು ಬರೆದ ಗ್ರಂಥದಿಂದ ನನ್ನ ಹೆಸರನ್ನು ಅಳಿಸಿಬಿಡಿ,” ಎಂದು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ಅದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನನಗೆ ವಿರೋಧವಾಗಿ ಪಾಪಮಾಡಿದವನ ಹೆಸರನ್ನೇ ನಾನು ನನ್ನ ಪುಸ್ತಕದಿಂದ ಅಳಿಸಿಬಿಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ಆದರೆ ಈಗ ನೀನು ಹೋಗಿ, ಜನರನ್ನು ನಿನಗೆ ನಾನು ಹೇಳಿದ ಸ್ಥಳಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋಗು. ಇಗೋ, ನನ್ನ ದೂತನು ನಿನ್ನನ್ನು ಮುನ್ನಡೆಸುವನು. ಆದರೂ ನಾನು ವಿಚಾರಿಸುವ ದಿನ ಬಂದಾಗ ಅವರ ಪಾಪಕ್ಕೆ ತಕ್ಕಂತೆ ಅವರನ್ನು ಶಿಕ್ಷಿಸುತ್ತೇನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ಹೀಗೆ ಆರೋನನು ಮಾಡಿದ ಕರುವನ್ನು ಅವರು ಆರಾಧಿಸಿದ್ದರಿಂದ ಯೆಹೋವ ದೇವರು ಜನರನ್ನು ಉಪದ್ರವದಿಂದ ಬಾಧಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದ ಜನರ ಸಂಗಡ ಈ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ನಾನು ಅಬ್ರಹಾಮನಿಗೂ, ಇಸಾಕನಿಗೂ, ಯಾಕೋಬನಿಗೂ, ‘ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಅದನ್ನು ಕೊಡುವೆನು,’ ಎಂದು ಹೇಳಿ ಪ್ರಮಾಣ ಮಾಡಿದ ದೇಶಕ್ಕೆ ಹೋಗು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ನಾನು ನಿನ್ನ ಮುಂದೆ ದೂತನನ್ನು ಕಳುಹಿಸಿ ಕಾನಾನ್ಯರನ್ನೂ, ಅಮೋರಿಯರನ್ನೂ, ಹಿತ್ತಿಯರನ್ನೂ, ಪೆರಿಜೀಯರನ್ನೂ, ಹಿವ್ವಿಯರನ್ನೂ, ಯೆಬೂಸಿಯರನ್ನೂ ಹೊರದೂಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶಕ್ಕೆ ಹೋಗು. ನಾನು ನಿಮ್ಮ ಸಂಗಡ ಹೋಗುವುದಿಲ್ಲ ಏಕೆಂದರೆ ನೀವು ಮಾತು ಕೇಳದ ಹಟಮಾರಿ ಜನರಾಗಿದ್ದೀರಿ ಮತ್ತು ಮಾರ್ಗದಲ್ಲಿ ನಾನು ನಿಮ್ಮನ್ನು ಸಂಹರಿಸಬೇಕಾಗಬಹುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ಜನರು ಈ ಕಠಿಣವಾದ ಮಾತುಗಳನ್ನು ಕೇಳಿದಾಗ ದುಃಖಪಟ್ಟರು. ಯಾರೂ ತಮ್ಮ ಆಭರಣಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ‘ನೀವು ಆಜ್ಞೆಗಳನ್ನು ಪಾಲಿಸದ ಹಟಮಾರಿ ಜನರು. ನಾನು ಕ್ಷಣಮಾತ್ರವೂ ನಿಮ್ಮೊಡನೆ ಬಂದರೆ ನೀವು ನಿರ್ಮೂಲವಾಗಿಬಿಡುವಿರಿ. ಹೀಗಿರುವುದರಿಂದ ಈಗ ನಿಮ್ಮ ಆಭರಣಗಳನ್ನು ನಿಮ್ಮಿಂದ ತೆಗೆದುಬಿಡಿರಿ, ನಾನು ನಿಮಗೆ ಏನು ಮಾಡಬೇಕೆಂಬುದನ್ನು ತೀರ್ಮಾನಿಸುವೆನು’ ಎಂದು ಹೇಳು,” ಎಂದು ತಿಳಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ಅದರಂತೆಯೇ ಇಸ್ರಾಯೇಲರು ಹೋರೇಬ್ ಬೆಟ್ಟದ ಬಳಿಯಲ್ಲಿ ತಮ್ಮ ಆಭರಣಗಳನ್ನು ತೆಗೆದುಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ಮೋಶೆಯು ಗುಡಾರವನ್ನು ತೆಗೆದು ಪಾಳೆಯದ ಹೊರಗೆ ಪಾಳೆಯಕ್ಕೆ ದೂರವಾಗಿ ಹಾಕಿ, ಅದಕ್ಕೆ “ದೇವದರ್ಶನದ ಗುಡಾರ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ತರುವಾಯ ಯೆಹೋವ ದೇವರನ್ನು ಹುಡುಕುವವರೆಲ್ಲಾ ಪಾಳೆಯದ ಹೊರಗೆ ಇರುವ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ಇದಾದ ಮೇಲೆ ಮೋಶೆಯು ಗುಡಾರದ ಬಳಿಗೆ ಹೊರಗೆ ಹೋಗುತ್ತಿರುವಾಗ ಜನರೆಲ್ಲರೂ ಎದ್ದು, ತಮ್ಮ ತಮ್ಮ ಗುಡಾರಗಳ ಬಾಗಿಲುಗಳಲ್ಲಿ ನಿಂತುಕೊಂಡು ಮೋಶೆಯು ಗುಡಾರದಲ್ಲಿ ಪ್ರವೇಶಿಸುವವರೆಗೆ ಅವನ ಹಿಂದೆ ನೋಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ಮೋಶೆ ಗುಡಾರದೊಳಗೆ ಹೋಗುವಾಗ, ಮೇಘಸ್ತಂಭವು ಪ್ರವೇಶದ್ವಾರದ ಬಳಿಯಲ್ಲಿ ನಿಲ್ಲುತ್ತಿತ್ತು. ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ಜನರೆಲ್ಲರೂ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ನಿಂತ ಮೇಘಸ್ತಂಭವನ್ನು ನೋಡುವಾಗ ತಮ್ಮ ತಮ್ಮ ಡೇರೆಗಳ ಬಾಗಿಲುಗಳಲ್ಲಿ ಎದ್ದು ನಿಂತು ಯೆಹೋವ ದೇವರನ್ನು ಆರಾಧಿಸುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ಒಬ್ಬ ಮನುಷ್ಯನು ತನ್ನ ಸ್ನೇಹಿತನ ಸಂಗಡ ಮಾತನಾಡುವಂತೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮುಖಾಮುಖಿಯಾಗಿ ಮಾತನಾಡುತ್ತಿದ್ದರು. ತರುವಾಯ ಅವನು ಪಾಳೆಯಕ್ಕೆ ಹಿಂದಿರುಗಿ ಹೋಗುತ್ತಿದ್ದನು. ಆದರೆ ಅವನ ಸೇವಕನೂ ನೂನನ ಮಗನೂ ಆದ ಯೆಹೋಶುವನೆಂಬ ಯೌವನಸ್ಥನು ಗುಡಾರವನ್ನು ಬಿಟ್ಟುಹೋಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರಿಗೆ, “ ‘ಈ ಜನರನ್ನು ನಡೆಸಿಕೊಂಡು ಹೋಗು,’ ಎಂದು ನನಗೆ ಹೇಳುತ್ತಿರುವಿರಿ. ಯಾರನ್ನು ನನ್ನ ಸಂಗಡ ಕಳುಹಿಸುವಿರಿ, ಎಂದು ನೀವು ನನಗೆ ತಿಳಿಸಲಿಲ್ಲ. ಆದರೂ ನೀವು ನನಗೆ, ‘ನಾನು ನಿನ್ನನ್ನು ನಿನ್ನ ಹೆಸರಿನ ಮೂಲಕ ತಿಳಿದಿದ್ದೇನೆ, ನನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ನಿನಗೆ ಕೃಪೆ ದೊರೆಯಿತು,’ ಎಂದೂ ಹೇಳಿದ್ದೀರಲ್ಲಾ. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ಹಾಗಾದರೆ ಈಗ ನಿಮ್ಮ ದೃಷ್ಟಿಯಲ್ಲಿ ನನಗೆ ದಯೆ ದೊರೆಕಿದ್ದೇ ಆದರೆ ನಾನು ನಿಮ್ಮನ್ನು ತಿಳಿಯುವ ಹಾಗೆ, ನಿಮ್ಮ ಮಾರ್ಗವನ್ನು ನನಗೆ ತೋರಿಸಿ. ಆಗ ನಿಮ್ಮ ದೃಷ್ಟಿಯಲ್ಲಿ ನನಗೆ ದಯೆ ದೊರಕಿರುವುದು. ಈ ಜನಾಂಗವು ನಿಮ್ಮ ಜನರೇ, ಎಂದು ಜ್ಞಾಪಿಸಿಕೊಳ್ಳುವೆನು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ಆಗ ಯೆಹೋವ ದೇವರು, “ನನ್ನ ಪ್ರಸನ್ನತೆಯು ನಿನ್ನ ಸಂಗಡ ಹೋಗುವುದು. ನಾನು ನಿನಗೆ ವಿಶ್ರಾಂತಿಯನ್ನು ಕೊಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ಮೋಶೆಯು ಅವರಿಗೆ, “ನಿಮ್ಮ ಪ್ರಸನ್ನತೆಯು ನಮ್ಮೊಂದಿಗೆ ಹೋಗದಿದ್ದರೆ ನಮ್ಮನ್ನು ಇಲ್ಲಿಂದ ಕರೆದುಕೊಂಡು ಹೋಗಬೇಡಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ಏಕೆಂದರೆ ನನಗೂ ನಿಮ್ಮ ಜನರಿಗೂ ನಿಮ್ಮ ದೃಷ್ಟಿಯಲ್ಲಿ ದಯೆ ದೊರಕಿತೆಂದು ಯಾವುದರಿಂದ ತಿಳಿದುಬರುವುದು? ನೀವು ನನ್ನೊಂದಿಗೆ ಹೋಗುವುದರಿಂದಲ್ಲವೋ? ಹೀಗೆ ನಾನೂ ನಿಮ್ಮ ಜನರೂ ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಜನರಿಂದ ಪ್ರತ್ಯೇಕವಾಗಿರುವೆವು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ಅದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಆಡಿದ ಈ ಮಾತಿನಂತೆಯೇ ನಾನು ಇದನ್ನು ಮಾಡುತ್ತೇನೆ. ಏಕೆಂದರೆ ನನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ನಿನಗೆ ದಯೆ ದೊರಕಿತು. ನಾನು ನಿನ್ನನ್ನು ನಿನ್ನ ಹೆಸರಿನಿಂದ ತಿಳಿದಿದ್ದೇನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ಆಗ ಮೋಶೆ, “ನಿಮ್ಮ ಮಹಿಮೆಯನ್ನು ನನಗೆ ತೋರಿಸಿ ಎಂದು ನಾನು ನಿಮ್ಮನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ಅದಕ್ಕೆ ಅವರು, “ನಾನು ನನ್ನ ಒಳ್ಳೆಯತನವನ್ನೆಲ್ಲಾ ನಿನ್ನ ಎದುರಿಗೆ ಹಾದು ಹೋಗ ಮಾಡಿ, ಯೆಹೋವ ದೇವರ ಹೆಸರನ್ನು ನಿನ್ನ ಮುಂದೆ ಪ್ರಕಟಮಾಡಿ, ಯಾವನ ಮೇಲೆ ನನ್ನ ಕರುಣೆ ಉಂಟೋ, ಅವನನ್ನು ಕರುಣಿಸುವೆನು. ಯಾವನ ಮೇಲೆ ನನ್ನ ಕನಿಕರವಿದೆಯೋ ಅವನನ್ನು ಕನಿಕರಿಸುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ಮತ್ತೆ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ನನ್ನ ಮುಖವನ್ನು ನೋಡಲಾರಿ. ಏಕೆಂದರೆ ಯಾವ ಮನುಷ್ಯನೂ ನನ್ನನ್ನು ನೋಡಿ ಬದುಕಿರಲಾರನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು, “ನನ್ನ ಬಳಿಯಲ್ಲಿ ಒಂದು ಸ್ಥಳವಿದೆ. ನೀನು ಬಂಡೆಯ ಮೇಲೆ ನಿಂತುಕೋ. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ಆಗ ನನ್ನ ಮಹಿಮೆಯು ಹಾದುಹೋಗುವಾಗ, ನಿನ್ನನ್ನು ಬಂಡೆಯ ಬಿರುಕಿನಲ್ಲಿ ನಿಲ್ಲಿಸಿ, ನಿನ್ನ ಮೇಲೆ ನನ್ನ ಕೈ ಮುಚ್ಚುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ತರುವಾಯ ನನ್ನ ಕೈಯನ್ನು ತೆಗೆದುಬಿಡುವೆನು. ಆಗ ನೀನು ನನ್ನ ಬೆನ್ನನ್ನು ನೋಡುವೆ, ಆದರೆ ನನ್ನ ಮುಖವು ನಿನಗೆ ಕಾಣಿಸುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಮೊದಲಿನವುಗಳ ಹಾಗೆ ಎರಡು ಕಲ್ಲಿನ ಹಲಗೆಗಳನ್ನು ಕೆತ್ತಿಸಿಕೋ. ಆಗ ನೀನು ಒಡೆದ ಆ ಮೊದಲನೆಯ ಹಲಗೆಗಳ ಮೇಲೆ ಇದ್ದ ವಾಕ್ಯಗಳನ್ನು ಈ ಹಲಗೆಗಳ ಮೇಲೆ ನಾನು ಬರೆಯುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ಬೆಳಿಗ್ಗೆ ನೀನು ಸಿದ್ಧನಾಗಿ ಸೀನಾಯಿ ಬೆಟ್ಟವನ್ನೇರಿ, ಆ ಬೆಟ್ಟದ ತುದಿಯ ಮೇಲೆ ನನ್ನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಂತಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ಆದರೆ ಯಾರೂ ನಿನ್ನ ಸಂಗಡ ಮೇಲಕ್ಕೆ ಬರಬಾರದು. ಬೆಟ್ಟದ ಮೇಲೆ ಎಲ್ಲಿಯೂ ಯಾರೂ ಕಾಣಿಸಬಾರದು, ಆ ಬೆಟ್ಟದ ಎದುರಿನಲ್ಲಿ ದನಕುರಿಗಳು ಸಹ ಮೇಯಬಾರದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ಆಗ ಮೋಶೆಯು ಮೊದಲಿನವುಗಳಂತೆ ಎರಡು ಕಲ್ಲಿನ ಹಲಗೆಗಳನ್ನು ಕೆತ್ತಿಸಿಕೊಂಡನು. ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಯೆಹೋವ ದೇವರು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಕಲ್ಲಿನ ಎರಡು ಹಲಗೆಗಳನ್ನು ತನ್ನ ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಸೀನಾಯಿ ಬೆಟ್ಟದ ಮೇಲೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ಆಗ ಯೆಹೋವ ದೇವರು ಮೇಘದಲ್ಲಿ ಇಳಿದುಬಂದು ಅಲ್ಲಿ ಅವನ ಸಂಗಡ ನಿಂತುಕೊಂಡು, ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಹೆಸರನ್ನು ಪ್ರಕಟಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ಯೆಹೋವ ದೇವರು ಅವನೆದುರಿಗೆ ಹಾದು ಹೋಗಿ, “ಯೆಹೋವ ದೇವರು, ಯೆಹೋವ ದೇವರು, ಕರುಣಾಳುವು, ಕೃಪಾಳುವು, ದೀರ್ಘಶಾಂತನು, ಮಹಾ ಪ್ರೀತಿಯುಳ್ಳವನು ಮತ್ತು ಸತ್ಯದಲ್ಲಿ ಸಮೃದ್ಧಿಯಾದಾತನೂ ");
INSERT INTO kanokcv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ಸಾವಿರ ತಲೆಗಳವರೆಗೂ ಕರುಣೆ ತೋರಿಸುವಾತನು. ದೋಷವನ್ನು, ಅಪರಾಧವನ್ನು, ಪಾಪವನ್ನು ಕ್ಷಮಿಸುವಾತನು ಆದರೂ ಅಪರಾಧಿಯನ್ನು ಶಿಕ್ಷಿಸದೆ ಬಿಡದವನೂ ತಂದೆಗಳ ದೋಷವನ್ನು ಮಕ್ಕಳ ಮೇಲೆಯೂ ಮೊಮ್ಮಕ್ಕಳ ಮೇಲೆಯೂ ಮೂರನೆಯ ಮತ್ತು ನಾಲ್ಕನೆಯ ತಲೆಗಳವರೆಗೂ ಶಿಕ್ಷಿಸುವಾತನು,” ಎಂದು ಪ್ರಕಟಿಸಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ಆಗ ಮೋಶೆಯು ತ್ವರೆಪಟ್ಟು ನೆಲಕ್ಕೆ ಬಾಗಿ ಅವರನ್ನು ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ಅವನು, ಕರ್ತನೇ, “ಈಗ ನಿಮ್ಮ ದೃಷ್ಟಿಯಲ್ಲಿ ನನಗೆ ದಯೆ ದೊರಕಿದರೆ, ನನ್ನ ಕರ್ತನೇ ತಾವೇ ನಮ್ಮ ಸಂಗಡ ಬರಬೇಕು. ಇದು ಮಾತು ಕೇಳದ ಹಟಮಾರಿ ಜನಾಂಗವೇ ಹೌದು. ಆದರೂ ನಮ್ಮ ದೋಷವನ್ನೂ ಪಾಪವನ್ನೂ ಮನ್ನಿಸಿ ನಮ್ಮನ್ನು ನಿಮ್ಮ ಸೊತ್ತಾಗಿ ತೆಗೆದುಕೊಳ್ಳಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ಅದಕ್ಕೆ ಯೆಹೋವ ದೇವರು, “ನಾನು ಒಂದು ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡುತ್ತೇನೆ. ಸಮಸ್ತ ಭೂಮಿಯಲ್ಲಿಯೂ ಯಾವ ಜನಾಂಗದಲ್ಲಿಯೂ ಹಿಂದೆಂದಿಗೂ ಮಾಡದಿರುವಂಥ ಅದ್ಭುತಗಳನ್ನು ನಿನ್ನ ಎಲ್ಲಾ ಜನರ ಮುಂದೆ ಮಾಡುವೆನು. ನೀನು ಯಾರ ಮಧ್ಯದಲ್ಲಿ ಇರುವೆಯೋ ಆ ಜನರೂ ಯೆಹೋವ ದೇವರ ಕಾರ್ಯವನ್ನು ನೋಡುವರು ಏಕೆಂದರೆ ನಾನು ನಿಮಗೆ ಮಾಡುವಂಥದ್ದು ಭಯಂಕರವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ನಾನು ಈ ಹೊತ್ತು ನಿಮಗೆ ಆಜ್ಞಾಪಿಸುವುದನ್ನು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು. ಹಿತ್ತಿಯರನ್ನೂ ಅಮೋರಿಯರನ್ನೂ ಕಾನಾನ್ಯರನ್ನೂ, ಪೆರಿಜೀಯರನ್ನೂ ಹಿವ್ವಿಯರನ್ನೂ ಯೆಬೂಸಿಯರನ್ನೂ ನಿಮ್ಮ ಮುಂದೆಯೇ ಹೊರಡಿಸಿಬಿಡುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ನೀನು ಹೋಗುವ ದೇಶದ ನಿವಾಸಿಗಳ ಸಂಗಡ ಒಪ್ಪಂದವನ್ನು ಮಾಡದಂತೆ ನೋಡಿಕೋ. ಒಂದು ವೇಳೆ ಮಾಡಿದರೆ ಅದು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಉರುಲಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ಆದರೆ ಅವರ ಬಲಿಪೀಠಗಳನ್ನು ಒಡೆದುಹಾಕಬೇಕು. ಅವರ ಪವಿತ್ರ ಕಲ್ಲುಕಂಬಗಳನ್ನು ಒಡೆದು, ಅಶೇರವೆಂಬ ವಿಗ್ರಹಸ್ತಂಭಗಳನ್ನು ಕಡಿದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ಏಕೆಂದರೆ, ‘ರೋಷವುಳ್ಳವನು,’ ಎಂದು ಹೆಸರುಳ್ಳ ಯೆಹೋವ ದೇವರು ರೋಷವುಳ್ಳ ದೇವರಾಗಿರುವುದರಿಂದ ನೀನು ಬೇರೆ ದೇವರುಗಳನ್ನು ಆರಾಧಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ನೀನು ಆ ದೇಶದ ನಿವಾಸಿಗಳ ಸಂಗಡ ಒಪ್ಪಂದ ಮಾಡಿಕೊಳ್ಳದಂತೆ ಎಚ್ಚರದಿಂದಿರು. ಅವರು ಅನ್ಯದೇವರುಗಳನ್ನು ಆರಾಧಿಸಿ, ಅವುಗಳಿಗೆ ಯಜ್ಞ ಅರ್ಪಿಸುವ ಸಮಯದಲ್ಲಿ ಒಬ್ಬನು ನಿನ್ನನ್ನು ಕರೆದಾನು, ನೀನು ಅವನ ಯಜ್ಞಭೋಜನವನ್ನು ಮಾಡಬೇಕಾದೀತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ಇದಲ್ಲದೆ ಅವರ ಪುತ್ರಿಯರನ್ನು ನಿನ್ನ ಪುತ್ರರಿಗೋಸ್ಕರ ತೆಗೆದುಕೊಳ್ಳಬೇಕಾಗಬಹುದು. ತೆಗೆದುಕೊಂಡರೆ ಅವರ ಪುತ್ರಿಯರು ತಮ್ಮ ದೇವರುಗಳನ್ನು ಆರಾಧಿಸಿ, ನಿಮ್ಮ ಪುತ್ರರನ್ನೂ ಅನ್ಯದೇವರುಗಳ ಆರಾಧನೆಯೆಂಬ ವ್ಯಭಿಚಾರಕ್ಕೆ ಎಳೆಯಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“ನಿಮಗಾಗಿ ದೇವರುಗಳ ಎರಕ ಹೊಯ್ದ ವಿಗ್ರಹಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ನಾನು ನಿಮಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಚೈತ್ರ ಮಾಸದ ಏಳು ದಿವಸ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು. ಏಕೆಂದರೆ ಅಬೀಬ ತಿಂಗಳಿನಲ್ಲಿ ನೀವು ಈಜಿಪ್ಟ್ ದೇಶವನ್ನು ಬಿಟ್ಟು ಬಂದಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ಪ್ರಥಮ ಗರ್ಭಫಲವೆಲ್ಲಾ ಅಂದರೆ ನಿಮ್ಮ ಪಶುಗಳಾಗಲಿ, ಎತ್ತುಗಳಾಗಲಿ, ಟಗರುಗಳಾಗಲಿ ಮೊದಲು ಹುಟ್ಟುವವುಗಳೆಲ್ಲಾ ಗಂಡಾಗಿದ್ದರೆ ಅವು ನನ್ನವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ಕತ್ತೆಮರಿಗೆ ಬದಲಾಗಿ ಕುರಿಮರಿಯನ್ನು ವಿಮೋಚಿಸಬೇಕು. ನೀನು ವಿಮೋಚಿಸದೆ ಹೋದರೆ, ಕುತ್ತಿಗೆಯನ್ನು ಮುರಿಯಬೇಕು. ನಿನ್ನ ಪುತ್ರರಲ್ಲಿ ಚೊಚ್ಚಲಾದವರನ್ನೆಲ್ಲಾ ವಿಮೋಚಿಸಬೇಕು. “ನನ್ನ ಮುಂದೆ ಯಾರೂ ಬರಿಗೈಯಿಂದ ಕಾಣಿಸಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ಆರು ದಿನಗಳು ಕೆಲಸಮಾಡಿ, ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಬೇಕು. ಬಿತ್ತುವ ಕಾಲದಲ್ಲಿಯೂ ಕೊಯ್ಯುವ ಕಾಲದಲ್ಲಿಯೂ ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“ಪ್ರಥಮ ಗೋಧಿ ಸುಗ್ಗಿಯ ವಾರಗಳ ಹಬ್ಬವನ್ನು ಮತ್ತು ವರ್ಷದ ಕೊನೆಯಲ್ಲಿ ಬೆಳೆ ಸಂಗ್ರಹದ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ವರುಷಕ್ಕೆ ಮೂರು ಸಾರಿ ನಿಮ್ಮ ಗಂಡು ಮಕ್ಕಳೆಲ್ಲಾ ಸಾರ್ವಭೌಮ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಅಂದರೆ ಇಸ್ರಾಯೇಲಿನ ದೇವರ ಮುಂದೆ ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ಏಕೆಂದರೆ ನಾನು ಜನಾಂಗಗಳನ್ನು ನಿಮ್ಮ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಡಿಸಿಬಿಟ್ಟು, ನಿಮ್ಮ ಮೇರೆಗಳನ್ನು ವಿಸ್ತಾರ ಮಾಡುವೆನು. ವರ್ಷಕ್ಕೆ ಮೂರು ಸಾರಿ ನೀವು ನಿಮ್ಮ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಬರುವ ಸಮಯದಲ್ಲಿ ಯಾರೂ ನಿಮ್ಮ ಭೂಮಿಯನ್ನು ಅಪಹರಿಸಲು ಆಶೆಪಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ಬಲಿ ಅರ್ಪಣೆಯ ರಕ್ತವನ್ನು ಹುಳಿಯಿರುವ ರೊಟ್ಟಿಯ ಸಂಗಡ ಅರ್ಪಿಸಬಾರದು. ಇಲ್ಲವೆ ಪಸ್ಕಹಬ್ಬದ ಬಲಿಯಲ್ಲಿ ಯಾವುದೂ ಬೆಳಗಿನವರೆಗೆ ಉಳಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“ನಿಮ್ಮ ಭೂಮಿಯ ಪ್ರಥಮ ಫಲಗಳಲ್ಲಿ ಅತ್ಯುತ್ತಮವಾದದ್ದನ್ನು ನಿಮ್ಮ ಯೆಹೋವ ದೇವರ ಆಲಯಕ್ಕೆ ತರಬೇಕು. “ಮೇಕೆಯ ಮರಿಯನ್ನು ಅದರ ತಾಯಿಯ ಹಾಲಿನಲ್ಲಿ ಬೇಯಿಸಬಾರದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೀಗೆ ಹೇಳಿದರು, “ನೀನು ಈ ವಾಕ್ಯಗಳನ್ನು ಬರೆ. ಏಕೆಂದರೆ ಈ ವಾಕ್ಯಗಳ ಪ್ರಕಾರವೇ ನಾನು ನಿನ್ನ ಮತ್ತು ಇಸ್ರಾಯೇಲಿನ ಸಂಗಡ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡಿದ್ದೇನೆ.” ");
INSERT INTO kanokcv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ಮೋಶೆಯು ಹಗಲಿರುಳು ನಲವತ್ತು ದಿವಸ ರೊಟ್ಟಿಯನ್ನು ತಿನ್ನದೇ, ನೀರನ್ನು ಕುಡಿಯದೇ ಅಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಸಂಗಡ ಇದ್ದನು. ದೇವರು ಒಡಂಬಡಿಕೆಯ ವಾಕ್ಯಗಳಾದ ಹತ್ತು ಆಜ್ಞೆಗಳನ್ನು ಹಲಗೆಗಳ ಮೇಲೆ ಬರೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ಮೋಶೆಯು ಸಾಕ್ಷಿಯ ಎರಡು ಹಲಗೆಗಳನ್ನು ತನ್ನ ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡು ಸೀನಾಯಿ ಬೆಟ್ಟದಿಂದ ಇಳಿದಾಗ, ಅವನು ಯೆಹೋವ ದೇವರ ಸಂಗಡ ಬೆಟ್ಟದಲ್ಲಿ ಮಾತನಾಡಿದ್ದರಿಂದ ಅವನ ಮುಖವು ಪ್ರಕಾಶಿಸುತ್ತದೆಂದು ಬೆಟ್ಟದಿಂದ ಇಳಿದಾಗ ಮೋಶೆಗೆ ತಿಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ಆದರೆ ಆರೋನನು ಮತ್ತು ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಮೋಶೆಯನ್ನು ನೋಡಿದಾಗ, ಇಗೋ, ಅವನ ಮುಖವು ಪ್ರಕಾಶಿಸುತ್ತಿತ್ತು. ಆದ್ದರಿಂದ ಅವರು ಅವನ ಹತ್ತಿರ ಬರುವುದಕ್ಕೆ ಭಯಪಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ಮೋಶೆಯು ಅವರನ್ನು ಕರೆದಾಗ, ಆರೋನನು ಮತ್ತು ಸಭೆಯ ಮುಖ್ಯಸ್ಥರೆಲ್ಲರೂ ಅವನ ಬಳಿಗೆ ತಿರುಗಿ ಬಂದರು. ಆಗ ಮೋಶೆಯು ಅವರ ಸಂಗಡ ಮಾತನಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ತರುವಾಯ ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಹತ್ತಿರ ಬಂದರು. ಆಗ ಅವನು ಅವರಿಗೆ, ಯೆಹೋವ ದೇವರು ತನಗೆ ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಹೇಳಿದವುಗಳನ್ನೆಲ್ಲಾ ಆಜ್ಞಾಪಿಸಿ ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ಮೋಶೆಯು ಅವರ ಸಂಗಡ ಮಾತನಾಡಿ ಮುಗಿಸುವವರೆಗೂ ಅವನು ತನ್ನ ಮುಖದ ಮೇಲೆ ಮುಸುಕು ಹಾಕಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ಆದರೆ ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಆತನ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ಒಳಗೆ ಪ್ರವೇಶಿಸಿ ಹೊರಗೆ ಬರುವವರೆಗೆ ಆ ಮುಸುಕನ್ನು ತೆಗೆದು ಬಿಡುತ್ತಿದ್ದನು. ಅವನು ಹೊರಗೆ ಬಂದು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ಆಗ ಮೋಶೆಯ ಮುಖವು ಪ್ರಕಾಶಿಸುವುದನ್ನು ಇಸ್ರಾಯೇಲರು ನೋಡಿದ್ದರು. ಮೋಶೆ ದೇವರ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ಹೋಗುವವರೆಗೆ ಅವನು ತನ್ನ ಮುಖದ ಮೇಲೆ ತಿರುಗಿ ಮುಸುಕನ್ನು ಹಾಕಿಕೊಳ್ಳುತ್ತಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರ ಸಮೂಹವನ್ನು ಒಟ್ಟುಗೂಡಿಸಿ ಅವರಿಗೆ, “ನೀವು ಅನುಸರಿಸಬೇಕೆಂದು ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ಆರು ದಿನಗಳು ಕೆಲಸ ಮಾಡಬೇಕು. ಆದರೆ ಏಳನೆಯ ದಿನವು ನಿಮಗೆ ಪರಿಶುದ್ಧವಾಗಿರಬೇಕು. ಅದು ಯೆಹೋವ ದೇವರ ಸಬ್ಬತ್ ದಿನ. ಆ ದಿನದಲ್ಲಿ ಕೆಲಸಮಾಡುವವರಿಗೆ ಮರಣದಂಡನೆಯಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ನೀವು ವಾಸಮಾಡುವ ಯಾವ ಮನೆಯಲ್ಲಿಯೂ ಬೆಂಕಿಯನ್ನು ಹೊತ್ತಿಸಬಾರದು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರ ಇಡೀ ಸಮೂಹಕ್ಕೆ ಹೇಳಿದ್ದು: “ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ್ದು ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ನಿಮ್ಮಲ್ಲಿರುವದರಿಂದ ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸಿರಿ. ಯಾರ‍್ಯಾರಿಗೆ ಇಷ್ಟವಿದೆಯೋ ಅವರು, “ಚಿನ್ನ, ಬೆಳ್ಳಿ, ಕಂಚು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ನೀಲಿ, ನಾರು, ರಕ್ತವರ್ಣ ನಾರು, ಲಾಕಿ ಬಣ್ಣ, ನಾರು, ನಾರುಬಟ್ಟೆಗಳು, ಮೇಕೆಯ ಕೂದಲು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ಕೆಂಪು ಬಣ್ಣದಲ್ಲಿ ಅದ್ದಿದ ಟಗರುಗಳ ಚರ್ಮಗಳು, ಕಡಲುಹಂದಿಯ ಚರ್ಮಗಳು, ಜಾಲಿ ಮರದ ಕಟ್ಟಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ದೀಪಕ್ಕಾಗಿ ಓಲಿವ್ ಎಣ್ಣೆ ಅಭಿಷೇಕಿಸುವ ಎಣ್ಣೆಗೋಸ್ಕರ ಪರಿಮಳ ಮತ್ತು ಧೂಪಕ್ಕೋಸ್ಕರ ಸುಗಂಧ ದ್ರವ್ಯಗಳು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ಏಫೋದ್ ಕವಚಕ್ಕಾಗಿ ಗೋಮೇಧಿಕಗಳು ಮತ್ತು ಎದೆಪದಕದಲ್ಲಿ ಹಚ್ಚಬೇಕಾದ ನಾನಾ ರತ್ನಗಳನ್ನು ತನ್ನಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“ನಿಮ್ಮಲ್ಲಿರುವ ಶಿಲ್ಪಿಗಳೆಲ್ಲರೂ ಬಂದು, ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದವುಗಳನ್ನೆಲ್ಲಾ ಮಾಡಬೇಕು. ಅವು ಯಾವುವೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು, ಅದರ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು, ಅದರ ಕೊಂಡಿಗಳನ್ನು, ಅದರ ಚೌಕಟ್ಟುಗಳನ್ನು, ಅದರ ಅಗುಳಿಗಳನ್ನು, ಅದರ ಸ್ತಂಭಗಳನ್ನು, ಅದರ ಕುಣಿಕೆಗಳನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ಮಂಜೂಷವನ್ನು, ಅದರ ಕೋಲುಗಳನ್ನು, ಅವುಗಳೊಂದಿಗೆ ಕರುಣಾಸನವನ್ನು, ಮರೆಮಾಡುವ ಪರದೆಯನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ಮೇಜನ್ನು, ಅದರ ಕೋಲುಗಳನ್ನು, ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು, ನೈವೇದ್ಯದ ರೊಟ್ಟಿಯನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ಬೆಳಕಿಗಾಗಿ ದೀಪಸ್ತಂಭವನ್ನು, ಅದರ ಉಪಕರಣಗಳನ್ನು, ಅದರ ದೀಪಗಳನ್ನು, ದೀಪಸ್ತಂಭಕ್ಕಾಗಿ ಎಣ್ಣೆಯನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ಧೂಪವೇದಿಯನ್ನು, ಅದರ ಕೋಲುಗಳನ್ನು, ಅಭಿಷೇಕಿಸುವ ತೈಲವನ್ನು, ಪರಿಮಳ ಧೂಪವನ್ನು, ಗುಡಾರದ ಬಾಗಿಲಿನ ಪರದೆಯನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ದಹನಬಲಿಯ ಪೀಠವನ್ನು, ಅದರೊಂದಿಗೆ ಕಂಚಿನ ಜಾಳಿಗೆಯನ್ನು, ಅದರ ಕೋಲುಗಳನ್ನು, ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು, ಕಂಚಿನ ಗಂಗಾಳವನ್ನು, ಅದರ ಕಾಲನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ದೇವದರ್ಶನದ ಗುಡಾರ ಅಂಗಳದ ಪರದೆಗಳನ್ನು, ಅದರ ಸ್ತಂಭಗಳನ್ನು, ಅದರ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನು, ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆಗಳನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ಗುಡಾರದ ಗೂಟಗಳನ್ನು, ಅಂಗಳದ ಗೂಟಗಳನ್ನು, ಅದರ ಹಗ್ಗಗಳನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ಪರಿಶುದ್ಧಸ್ಥಳದ ಸೇವೆಗೋಸ್ಕರ ನೇಯ್ದ ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳನ್ನು ಅಂದರೆ ಸೇವೆಮಾಡುವದಕ್ಕೆ ಯಾಜಕನಾದ ಆರೋನನಿಗೆ ಮತ್ತು ಅವನ ಪುತ್ರರಿಗೆ ಯಾಜಕವಸ್ತ್ರಗಳನ್ನು ಮಾಡಲಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ಆಗ ಇಸ್ರಾಯೇಲರ ಸಮೂಹವೆಲ್ಲಾ ಮೋಶೆಯ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ಹೃದಯ ಪ್ರೇರಣೆ ಹೊಂದಿದವರೂ ಸಿದ್ಧಮನಸ್ಸಿನವರೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಕೆಲಸಕ್ಕಾಗಿಯೂ ಅದರ ಎಲ್ಲಾ ಸೇವೆಗಾಗಿಯೂ ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳಿಗಾಗಿಯೂ ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ಸ್ತ್ರೀಪುರುಷರೆಲ್ಲರೂ ಮನಃಪೂರ್ವಕವಾಗಿ ಬಂದು ಬಳೆಗಳನ್ನೂ ಮೂಗುತಿಗಳನ್ನೂ ಉಂಗುರಗಳನ್ನೂ ಮುದ್ರೆಗಳನ್ನೂ ಚಿನ್ನದ ಎಲ್ಲಾ ಒಡವೆಗಳನ್ನೂ ತಂದರು. ಜನರೆಲ್ಲಾ ಚಿನ್ನವನ್ನು ವಿಶೇಷ ಕಾಣಿಕೆಗಳನ್ನಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣ ದಾರಗಳೂ ನಯವಾದ ನಾರುಮಡಿ, ಮೇಕೆಯ ಕೂದಲು, ಟಗರುಗಳ ಕೆಂಪು ಬಣ್ಣದ ಚರ್ಮಗಳೂ ಕಡಲುಹಂದಿಯ ಚರ್ಮಗಳೂ ಯಾರ ಬಳಿಯಲ್ಲಿದ್ದವೋ ಅವರೆಲ್ಲರೂ ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ಬೆಳ್ಳಿ, ಕಂಚುಗಳ ಕಾಣಿಕೆಗಳನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕೆ ಮನಸ್ಸಿದ್ದವರೆಲ್ಲರೂ ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆಗಳನ್ನು ತಂದರು. ಸೇವೆಯ ಎಲ್ಲಾ ಕೆಲಸಕ್ಕೋಸ್ಕರ ಜಾಲಿ ಮರವಿದ್ದವರು ಅದನ್ನು ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ಕುಶಲತೆ ಬಲ್ಲ ಸ್ತ್ರೀಯರೆಲ್ಲರೂ ತಮ್ಮ ಕೈಗಳಿಂದ ನೇಯ್ದ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣ ದಾರಗಳನ್ನು ಮತ್ತು ನಯವಾದ ನಾರುಮಡಿಯನ್ನು ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ಕುಶಲತೆ ಬಲ್ಲ ಎಲ್ಲಾ ಸ್ತ್ರೀಯರು ಮೇಕೆ ಕೂದಲುಗಳನ್ನು ನೇಯ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ಅಧಿಪತಿಗಳು ಏಫೋದಿನಲ್ಲಿಯೂ ಎದೆಪದಕದಲ್ಲಿಯೂ ಕೂಡ್ರಿಸುವುದಕ್ಕೆ ಗೋಮೇಧಿಕಗಳನ್ನೂ ರತ್ನಗಳನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ಸುಗಂಧದ್ರವ್ಯಗಳನ್ನೂ ದೀಪಕ್ಕೋಸ್ಕರವೂ ಅಭಿಷೇಕಿಸುವ ತೈಲಕ್ಕೋಸ್ಕರವೂ ಪರಿಮಳ ಧೂಪಕ್ಕೋಸ್ಕರವೂ ಎಣ್ಣೆಯನ್ನೂ ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ಹೀಗೆ ಮಾಡಬೇಕೆಂದು ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಮುಖಾಂತರವಾಗಿ ಆಜ್ಞಾಪಿಸಿದ ಎಲ್ಲಾ ಕೆಲಸಕ್ಕೋಸ್ಕರ ಬೇಕಾದವುಗಳನ್ನು ಇಸ್ರಾಯೇಲಿನ ಸ್ತ್ರೀಪುರುಷರೆಲ್ಲರು ಮನಃಪೂರ್ವಕವಾಗಿಯೇ ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆಯನ್ನು ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ಆಗ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ, “ನೋಡಿರಿ, ಯೆಹೋವ ದೇವರು ಯೆಹೂದ ಕುಲದವನಾದ ಹೂರನ ಮೊಮ್ಮಗನೂ ಊರಿಯನ ಮಗನೂ ಆದ ಬೆಚಲಯೇಲ್ ಎಂಬವನನ್ನು ಗುರುತಿಸಿ ಆರಿಸಿಕೊಂಡಿದ್ದಾರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ಅವರು ಅವನನ್ನು ದೇವರ ಆತ್ಮನಿಂದಲೂ ಜ್ಞಾನದಿಂದಲೂ ತಿಳುವಳಿಕೆಯಿಂದಲೂ ವಿವೇಕದಿಂದಲೂ ");
INSERT INTO kanokcv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ಚಿನ್ನ, ಬೆಳ್ಳಿ, ಕಂಚಿನಲ್ಲಿ ಕಲಾತ್ಮಕವಾದ ವಿನ್ಯಾಸಗಳ ಕೆಲಸವನ್ನು ಮಾಡುವುದರಲ್ಲಿಯೂ ");
INSERT INTO kanokcv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ರತ್ನಗಳಲ್ಲಿ ಕೆತ್ತನೆಯನ್ನೂ ಮರದಲ್ಲಿ ಕೆತ್ತನೆಯನ್ನೂ ಸಕಲ ವಿಧವಾದ ಕೌಶಲ್ಯದ ಕೆಲಸದ ಜ್ಞಾನದಿಂದಲೂ ಅವನನ್ನು ತುಂಬಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ಇದಲ್ಲದೆ ಕಲಿಸುವುದಕ್ಕೆ ಅವನಿಗೆ ಮತ್ತು ದಾನನ ಕುಲದವನಾದ ಅಹೀಸಾಮಾಕನ ಮಗನಾದ ಒಹೋಲಿಯಾಬನನ್ನು ನೇಮಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ಕೆತ್ತನೆಯ ಕೆಲಸಗಳನ್ನು, ವಿನ್ಯಾಸದ ಕೆಲಸಗಳನ್ನು, ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ, ನಯವಾದ ನಾರುಬಟ್ಟೆ ಇವುಗಳಲ್ಲಿ ಕಸೂತಿ ಕೆಲಸಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ಮತ್ತು ನೇಯ್ಗೆಯ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೆ ಎಂದರೆ ಅವುಗಳಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನಾದರೂ ಕಲ್ಪಿಸಿ ಮಾಡುವದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ಅವರಿಗೆ ಜ್ಞಾನವನ್ನು ಅನುಗ್ರಹಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ತರುವಾಯ ಬೆಚಲಯೇಲ್ ಮತ್ತು ಒಹೋಲಿಯಾಬನೂ ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಎಲ್ಲವುಗಳನ್ನು ಮಾಡುವರು. ಅವರು ಪರಿಶುದ್ಧಸ್ಥಳದ ಸೇವೆಗೋಸ್ಕರ ಎಲ್ಲಾ ವಿಧವಾದ ಕೆಲಸವನ್ನು ಯೆಹೋವ ದೇವರಿಂದ ಜ್ಞಾನ ವಿವೇಕಗಳನ್ನು ಹೊಂದಿದ ಇತರರೊಂದಿಗೆ ಕೆಲಸಮಾಡುವರು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ಬೆಚಲಯೇಲನನ್ನು, ಒಹೋಲಿಯಾಬನನ್ನು ಮತ್ತು ಯೆಹೋವ ದೇವರು ಜ್ಞಾನಕೊಟ್ಟಿದ್ದ ಪ್ರತಿಯೊಬ್ಬ ಶಿಲ್ಪಿಯನ್ನೂ ಆ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೆ ಸಿದ್ಧ ಮನಸ್ಸಿದ್ದ ಪ್ರತಿಯೊಬ್ಬನನ್ನೂ ಮೋಶೆಯು ಕರೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ಅವರು ಪರಿಶುದ್ಧ ಆಲಯದ ನಿರ್ಮಾಣಕ್ಕೋಸ್ಕರ ಇಸ್ರಾಯೇಲರು ತಂದ ಕಾಣಿಕೆಗಳನ್ನೆಲ್ಲಾ ಮೋಶೆಯ ಬಳಿಯಿಂದ ತೆಗೆದುಕೊಂಡರು. ಇದಲ್ಲದೆ ಅವರು ಪ್ರತಿದಿನ ಬೆಳಿಗ್ಗೆ ಉಚಿತವಾದ ಕಾಣಿಕೆಗಳನ್ನು ತರುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ಆಗ ಪರಿಶುದ್ಧಸ್ಥಳದ ಕೆಲಸವನ್ನು ಮಾಡುವ ಜ್ಞಾನಿಗಳೆಲ್ಲರೂ ತಮ್ಮ ತಮ್ಮ ಕೆಲಸವನ್ನು ಬಿಟ್ಟು ಬಂದು, ");
INSERT INTO kanokcv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ಯೆಹೋವ ದೇವರು ಮಾಡಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಿದ ಸೇವೆಯ ಕೆಲಸಕ್ಕೆ ಬೇಕಾಗಿರುವುದಕ್ಕಿಂತ ಹೆಚ್ಚಾಗಿ ಕಾಣಿಕೆಗಳನ್ನು ಈ ಜನರು ತರುತ್ತಿದ್ದಾರೆ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ಆಗ ಮೋಶೆಯು, “ಇನ್ನು ಮೇಲೆ ಪರಿಶುದ್ಧಸ್ಥಳದ ಕಾಣಿಕೆಗೋಸ್ಕರ ಯಾವ ಪುರುಷನಾಗಲಿ, ಸ್ತ್ರೀಯಾಗಲಿ ಕೆಲಸ ಮಾಡಬಾರದೆಂದು ಪಾಳೆಯದಲ್ಲೆಲ್ಲಾ ಪ್ರಕಟಿಸಬೇಕು,” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ಹೀಗೆ ಜನರು ಕಾಣಿಕೆಗಳನ್ನು ತರುವುದನ್ನು ನಿಲ್ಲಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ಏಕೆಂದರೆ ಎಲ್ಲಾ ಕೆಲಸವನ್ನು ಮಾಡುವುದಕ್ಕೆ ಸಾಕಾಗಿ ಮಿಕ್ಕುವಷ್ಟು ಸಾಮಗ್ರಿಗಳು ದೊರೆತವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ಕೆಲಸದವರಲ್ಲಿದ್ದ ಶಿಲ್ಪಿಗಳೆಲ್ಲರೂ ಗುಡಾರವನ್ನು ಹತ್ತು ಪರದೆಗಳಿಂದ ಮಾಡಿ, ನಯವಾಗಿ ಹೊಸೆದ ನಾರಿನಿಂದಲೂ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ಕೌಶಲ್ಯದ ಕೆಲಸದಿಂದಲೂ ಕೆರೂಬಿಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ಎಲ್ಲಾ ಪರದೆಗಳೂ ಒಂದೇ ಅಳತೆಯವುಗಳಾಗಿದ್ದವು. ಪ್ರತಿಯೊಂದು ಪರದೆಯು ಸುಮಾರು ಹದಿಮೂರು ಮೀಟರ್ ಉದ್ದ ಮತ್ತು ಎರಡು ಮೀಟರ್ ಅಗಲವಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ಅವರು ಐದು ಪರದೆಗಳನ್ನು ಒಂದಕ್ಕೊಂದು ಜೋಡಿಸಿದರು ಮತ್ತು ಇನ್ನುಳಿದ ಐದು ಪರದೆಗಳನ್ನೂ ಒಂದಕ್ಕೊಂದು ಜೋಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನ ಒಂದು ಜೋಡಣೆಯ ಸ್ಥಳದಲ್ಲಿ ನೀಲಿ ದಾರಿನ ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಿದ್ದಲ್ಲದೆ, ಎರಡನೆಯ ಜೋಡಣೆಯ ಕಟ್ಟಕಡೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿಯೂ ಅದೇ ಪ್ರಕಾರ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ಒಂದು ಪರದೆಯಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಿ, ಇನ್ನೊಂದು ಪರದೆಯ ಅಂಚನ್ನು ಜೋಡಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಿದರು. ಆ ಕುಣಿಕೆಗಳು ಒಂದು ಪರದೆಯನ್ನು ಮತ್ತೊಂದು ಪರದೆಯು ಹಿಡಿದುಕೊಳ್ಳುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ಅವರು ಬಂಗಾರದ ಐವತ್ತು ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳಿಂದ ಎರಡು ಜೋಡಣೆ ಪರದೆಗಳನ್ನು ಒಂದಕ್ಕೊಂದು ಜೋಡಿಸಿದರು. ಹೀಗೆ ಅದು ಒಂದೇ ಗುಡಾರವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ಈ ಗುಡಾರದ ಮೇಲೆ ಹೊದಿಸುವುದಕ್ಕಾಗಿ ಅವರು ಮೇಕೆಯ ಕೂದಲಿನಿಂದ ಹನ್ನೊಂದು ಪರದೆಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ಒಂದೊಂದು ಪರದೆಯು ಸುಮಾರು ಹದಿಮೂರುವರೆ ಮೀಟರ್ ಉದ್ದ ಮತ್ತು ಒಂದುವರೆ ಮೀಟರ್ ಅಗಲ ಇರಬೇಕು. ಹನ್ನೊಂದು ಪರದೆಗಳೂ ಒಂದೇ ಅಳತೆಯಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ಅವರು ಐದು ಪರದೆಗಳನ್ನು ಒಂದಾಗಿ ಜೋಡಿಸಿ ಇನ್ನುಳಿದ ಆರು ಪರದೆಗಳನ್ನು ಒಂದಾಗಿ ಜೋಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ಅವರು ಕೊನೆಯ ಒಂದು ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳನ್ನು, ಜೋಡಣೆಯಲ್ಲಿರುವ ಕೊನೆಯ ಎರಡನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ಅದು ಒಂದೇ ಡೇರೆ ಆಗುವಂತೆ ಅವುಗಳ ಜೋಡಣೆಗೆ ಅವರು ಕಂಚಿನ ಐವತ್ತು ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ಅದಲ್ಲದೆ ಗುಡಾರದ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಕೆಂಪು ಬಣ್ಣದಲ್ಲಿ ಅದ್ದಿ ತೆಗೆದ ಟಗರುಗಳ ಚರ್ಮದಿಂದ ಮಾಡಿದರು. ಅದರ ಮೇಲೆ ಕಡಲುಹಂದಿಯ ಚರ್ಮದ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ಗುಡಾರವು ನಿಂತುಕೊಂಡಿರುವುದಕ್ಕೆ ಅವರು ಜಾಲಿ ಮರದಿಂದ ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ಒಂದೊಂದು ಚೌಕಟ್ಟಿನ ಉದ್ದವು ಸುಮಾರು ನಾಲ್ಕುವರೆ ಮೀಟರ್ ಮತ್ತು ಅಗಲ ಅರವತ್ತೆಂಟು ಸೆಂಟಿಮೀಟರ್ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ಒಂದು ಚೌಕಟ್ಟಿಗೆ ಒಂದಕ್ಕೊಂದು ಸರಿಯಾದ ಅಂತರದಲ್ಲಿ ಎರಡು ಕೈಗಳನ್ನು ಮಾಡಿದರು. ಅದೇ ಪ್ರಕಾರ ಅವರು ಗುಡಾರದ ಎಲ್ಲಾ ಚೌಕಟ್ಟುಗಳಿಗೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ಅವರು ಗುಡಾರದ ದಕ್ಷಿಣ ಭಾಗದಲ್ಲಿ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ಅವರು ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳ ಕೆಳಗೆ ನಾಲ್ವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನು ಮಾಡಿದರು ಮತ್ತು ಒಂದೊಂದು ಚೌಕಟ್ಟಿನ ಕೆಳಗೆ ಅದರ ಎರಡು ಪಟ್ಟಿಗಳಿಗಾಗಿ ಎರಡೆರಡು ಕುಳಿಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ಇನ್ನೊಂದು ಭಾಗಕ್ಕೆ ಅಂದರೆ ಗುಡಾರದ ಉತ್ತರ ದಿಕ್ಕಿನಲ್ಲಿ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ಒಂದೊಂದು ಚೌಕಟ್ಟಿನ ಕೆಳಗೆ ಎರಡೆರಡು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಂತೆ ನಲವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ಗುಡಾರದ ಹಿಂಭಾಗಕ್ಕೆ ಅಂದರೆ ಪಶ್ಚಿಮದ ಕಡೆಗೆ ಆರು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ಅವರು ಗುಡಾರದ ಹಿಂಭಾಗದ ಎರಡು ಮೂಲೆಗಳಿಗೆ ಬೇರೆ ಎರಡು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ಈ ಮೂಲೆಗಳನ್ನು ಅಡಿಯಲ್ಲಿ ಜೋಡಿಸಿರಬೇಕು. ಮೇಲ್ಭಾಗದಲ್ಲಿಯೂ ಒಂದೇ ಬಳೆಗೆ ಜೋಡಿಸಿದರು. ಇದೇ ರೀತಿಯಲ್ಲಿ ಅವರು ಎರಡು ಮೂಲೆಗಳಲ್ಲಿ ಎರಡಕ್ಕೂ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ಇಂಥ ಎಂಟು ಚೌಕಟ್ಟುಗಳಿದ್ದವು. ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟಿನ ಕೆಳಗೆ ಎರಡೆರಡು ಕೂರುಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಂತೆ ಅವುಗಳಿಗೆ ಹದಿನಾರು ಬೆಳ್ಳಿಯ ಕೂರುಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ಅವರು ಜಾಲಿ ಮರದಿಂದ ಅಗುಳಿಗಳನ್ನು ಮಾಡಿದರು, ಗುಡಾರದ ಒಂದು ಕಡೆಯ ಚೌಕಟ್ಟುಗಳಿಗೆ ಐದು ಅಗುಳಿಗಳು, ");
INSERT INTO kanokcv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ಗುಡಾರದ ಇನ್ನೊಂದು ಭಾಗದ ಚೌಕಟ್ಟುಗಳಿಗೆ ಐದು ಅಗುಳಿಗಳನ್ನು, ಅದರ ಹಿಂದುಗಡೆಯ ಅಂದರೆ ಪಶ್ಚಿಮ ಭಾಗದಲ್ಲಿರುವ ಚೌಕಟ್ಟುಗಳಿಗೆ ಐದು ಅಗುಳಿಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ಮಧ್ಯದ ಅಗುಳಿಯು ಚೌಕಟ್ಟುಗಳ ನಡುವೆ ಒಂದು ಕಡೆಯಿಂದ ಮತ್ತೊಂದು ಕಡೆಯವರೆಗೆ ಹಾದು ಹೋಗುವಹಾಗೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ಆ ಚೌಕಟ್ಟುಗಳನ್ನು ಬಂಗಾರದಿಂದ ಹೊದಿಸಿ, ಆ ಅಗುಳಿಗಳಿಗಾಗಿ ಬಂಗಾರದಿಂದ ಬಳೆಗಳನ್ನು ಮಾಡಿ, ಮಾಡಿದ ಅಗುಳಿಗಳನ್ನು ಬಂಗಾರದಿಂದ ಹೊದಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ಪರದೆಯನ್ನು ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಮಾಡಿದರು. ಅದರ ಮೇಲೆ ಕೌಶಲ್ಯದಿಂದ ಕಸೂತಿಹಾಕಿ ಮಾಡಿದ ಕೆರೂಬಿಗಳುಳ್ಳದ್ದನ್ನಾಗಿ ಅದನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ಅದಕ್ಕೆ ಜಾಲಿ ಮರದ ನಾಲ್ಕು ಸ್ತಂಭಗಳನ್ನು ಮಾಡಿ, ಬಂಗಾರ ತಗಡುಗಳಿಂದ ಅವುಗಳನ್ನು ಹೊದಿಸಿದರು. ಅವುಗಳಿಗೆ ಬಂಗಾರದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳಿಗೆ ಬೆಳ್ಳಿಯ ನಾಲ್ಕು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನು ಎರಕ ಹೊಯ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರುಗಳಿಂದ ಹೊಸೆದು ಕಸೂತಿ ಕೆಲಸಮಾಡಿದ ಪರದೆಯನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ಕೊಂಡಿಯಿರುವ ಐದು ಕಂಬಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳ ತಲೆಗಳನ್ನೂ ಕಂಬಗಳನ್ನೂ ಬಂಗಾರದಿಂದ ಹೊದಿಸಿದರು. ಆದರೆ ಅವುಗಳ ಐದು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನು ಕಂಚಿನಿಂದ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ಬೆಚಲಯೇಲನು ಜಾಲಿ ಮರದಿಂದ ಸುಮಾರು ಒಂದು ಮೀಟರ್ ಉದ್ದ ಮತ್ತು ಅರವತ್ತೆಂಟು ಸೆಂಟಿಮೀಟರ್ ಅಗಲ ಮತ್ತು ಎತ್ತರವಾಗಿರುವ ಮಂಜೂಷವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ಅದನ್ನು ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಒಳಗೂ ಹೊರಗೂ ಹೊದಿಸಿ, ಅದರ ಸುತ್ತಲೂ ಬಂಗಾರದ ತೋರಣವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ಅದರ ನಾಲ್ಕು ಬಂಗಾರದ ಬಳೆಗಳನ್ನು ಎರಕಹೊಯಿಸಿ ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಎಂದರೆ ಒಂದು ಕಡೆಯಲ್ಲಿ ಎರಡು ಬಳೆಗಳನ್ನು ಮತ್ತೊಂದು ಕಡೆಯಲ್ಲಿ ಎರಡು ಬಳೆಗಳನ್ನು ಇರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ಆಮೇಲೆ ಜಾಲಿ ಮರದ ಕೋಲುಗಳನ್ನು ಮಾಡಿಸಿ, ಅವುಗಳಿಗೆ ಬಂಗಾರದಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ಮಂಜೂಷವನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಕೋಲುಗಳನ್ನು ಮಂಜೂಷದ ಎರಡು ಕಡೆಗಳಲ್ಲಿರುವ ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ಇದಲ್ಲದೆ ಸುಮಾರು ನೂರಹತ್ತು ಸೆಂಟಿಮೀಟರ್ ಉದ್ದವೂ ಎಪ್ಪತ್ತು ಸೆಂಟಿಮೀಟರ್ ಅಗಲವೂ ಇರುವ ಕರುಣಾಸನವನ್ನು ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ಅವನು ಕರುಣಾಸನದ ಎರಡು ತುದಿಗಳಲ್ಲಿ ಎರಡು ಬಂಗಾರದಿಂದ ಕೆರೂಬಿಗಳನ್ನು ನಕಾಸಿ ಕೆಲಸದಿಂದ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ಒಂದು ಬದಿಯ ಕೊನೆಯಲ್ಲಿ ಒಂದು ಕೆರೂಬಿಯನ್ನೂ ಇನ್ನೊಂದು ಬದಿಯ ಕೊನೆಯಲ್ಲಿ ಒಂದು ಕೆರೂಬಿಯನ್ನೂ ಮಾಡಿದನು. ಹೀಗೆ ಕರುಣಾಸನದ ಎರಡೂ ಬದಿಗಳಲ್ಲಿ ಕೆರೂಬಿಯನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ಆ ಕೆರೂಬಿಗಳು ತಮ್ಮ ರೆಕ್ಕೆಗಳನ್ನು ಮೇಲಕ್ಕೆ ಚಾಚಿರುವಂತೆಯೂ ಕರುಣಾಸನವನ್ನು ತಮ್ಮ ರೆಕ್ಕೆಗಳಿಂದ ಮುಚ್ಚುವಂತೆಯೂ ಇದ್ದವು. ಕೆರೂಬಿಗಳ ಮುಖಗಳು ಎದುರುಬದುರಾಗಿ ಕರುಣಾಸನವನ್ನು ನೋಡುತ್ತಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ಸುಮಾರು ತೊಂಬತ್ತು ಸೆಂಟಿಮೀಟರ್ ಉದ್ದ, ನಲವತ್ತೈದು ಸೆಂಟಿಮೀಟರ್ ಅಗಲ ಮತ್ತು ಅರವತ್ತೆಂಟು ಸೆಂಟಿಮೀಟರ್ ಎತ್ತರ ಇರುವ ಮೇಜನ್ನು ಜಾಲಿ ಮರದಿಂದ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ಆಮೇಲೆ ಅದನ್ನು ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಹೊದಿಸಿ, ಸುತ್ತಲೂ ಬಂಗಾರದ ತೋರಣ ಕಟ್ಟಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ಸುತ್ತಲೂ ಅಂಗೈ ಅಗಲದ ಅಡ್ಡಪಟ್ಟಿಯನ್ನು ಮಾಡಿಸಿ, ಅಂಚಿನ ಸುತ್ತಲೂ ಬಂಗಾರದ ತೋರಣವನ್ನು ಕಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ಮೇಜಿಗೆ ಬಂಗಾರದ ನಾಲ್ಕು ಬಳೆಗಳನ್ನು ಎರಕ ಹೊಯ್ದು, ಅವುಗಳನ್ನು ಅದರ ನಾಲ್ಕು ಕಾಲುಗಳಲ್ಲಿರುವ ನಾಲ್ಕು ಮೂಲೆಗಳಿಗೆ ಜೋಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ಮೇಜನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗಲು ಕೋಲುಗಳನ್ನು ಮಾಡಿ, ಈ ಬಳೆಗಳನ್ನು ಅಡ್ಡಪಟ್ಟಿಗೆ ಸಮೀಪದಲ್ಲಿ ಕೂಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ಮೇಜನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗುವವರಿಗಾಗಿ ಜಾಲಿ ಮರದಿಂದ ಕೋಲುಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳಿಗೆ ಬಂಗಾರದಿಂದ ಹೊದಿಸಲಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ಮೇಜಿನ ಮೇಲೆ ಇಡಬೇಕಾದ ಉಪಕರಣಗಳನ್ನು ಅಂದರೆ ಹರಿವಾಣ, ಧೂಪಾರತಿಗಳು, ಹೂಜೆಗಳು, ಪಾನದ್ರವ್ಯಗಳ ಅರ್ಪಣೆಗಾಗಿ ಬೇಕಾಗುವ ಬಟ್ಟಲುಗಳನ್ನು ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ಚೊಕ್ಕ ಬಂಗಾರದಿಂದ ದೀಪಸ್ತಂಭವನ್ನು ಮಾಡಿದರು. ಅದರ ಬುಡವನ್ನೂ ಕಂಬವನ್ನೂ ನಕಾಸಿ ಕೆಲಸದಿಂದ ಮಾಡಿದರು. ದೀಪಸ್ತಂಭದ ಬುಡದಿಂದಲೇ ಅಖಂಡವಾಗಿ ಪುಷ್ಪದ ಗೊಂಚಲುಗಳಂತೆಯೂ ಹಣತೆಗಳಂತೆಯೂ ಮೊಗ್ಗುಗಳಂತೆಯೂ ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ಆ ದೀಪಸ್ತಂಭದಿಂದ ಆರು ಕೊಂಬೆಗಳು ಹೊರ ಬಂದಿದ್ದವು. ಅಂದರೆ ಒಂದು ಭಾಗದಿಂದ ಮೂರು ಕೊಂಬೆಗಳೂ ಮತ್ತೊಂದು ಭಾಗದಿಂದ ಮೂರು ಕೊಂಬೆಗಳೂ ಹೊರಗೆ ಬಂದಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ಒಂದು ಕೊಂಬೆಯಲ್ಲಿ ಬಾದಾಮಿ ಪುಷ್ಟದಂತಿರುವ ಮೂರು ಹಣತೆಗಳು, ಮೊಗ್ಗು ಪುಷ್ಟಗಳಿದ್ದವು ಮತ್ತು ಮತ್ತೊಂದು ಕೊಂಬೆಯಲ್ಲಿ ಬಾದಾಮಿಯ ಪುಷ್ಟವಿದ್ದ ಮೂರು ಹಣತೆಗಳು ಮೊಗ್ಗು ಪುಷ್ಟಗಳಿದ್ದವು. ಈ ಪ್ರಕಾರ ದೀಪಸ್ತಂಭದಿಂದ ಹೊರಗೆ ಬರುವ ಆರು ಕೊಂಬೆಗಳಲ್ಲಿಯೂ ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ದೀಪಸ್ತಂಭದಲ್ಲಿಯೇ ಬಾದಾಮಿ ಹೂವುಗಳಂತೆಯೂ ಮೊಗ್ಗುಗಳಂತೆಯೂ ಅದಕ್ಕೊಂದು ಪುಷ್ಪದ ಆಕಾರದಲ್ಲಿ ನಾಲ್ಕು ಹಣತೆಗಳು ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ದೀಪಸ್ತಂಭದಿಂದ ಹೊರಬರುವ ಒಂದು ಮೊಗ್ಗು ಮೊದಲ ಜೋಡಿ ಕೊಂಬೆಗಳ ಅಡಿಯಲ್ಲಿತ್ತು, ಎರಡನೇ ಮೊಗ್ಗು ಎರಡನೇ ಜೋಡಿಯ ಅಡಿಯಲ್ಲಿ ಮತ್ತು ಮೂರನೆಯ ಮೊಗ್ಗು ಮೂರನೆಯ ಜೋಡಿಯ ಅಡಿಯಲ್ಲಿ ಹೀಗೆ ಆರು ಕೊಂಬೆಗಳಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ಅದರ ಮೊಗ್ಗುಗಳೂ ಕೊಂಬೆಗಳೂ ಅದರಿಂದಲೇ ಬಂದಿದ್ದವು. ದೀಪಸ್ತಂಭವನ್ನೆಲ್ಲಾ ಶುದ್ಧ ಬಂಗಾರದ ಒಂದೇ ಅಚ್ಚಿನಲ್ಲಿ ಬರೆದ ಕಲಾಕೃತಿಯಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ಅವರು ಏಳು ದೀಪಗಳನ್ನೂ ಕುಡಿ ಕತ್ತರಿಸುವ ಕತ್ತರಿಗಳನ್ನೂ ಬೂದಿಯ ಪಾತ್ರೆಗಳನ್ನೂ ಶುದ್ಧ ಬಂಗಾರದಿಂದಲೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ದೀಪಸ್ತಂಭವನ್ನೂ ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ಒಂದು ತಲಾಂತು ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ಜಾಲಿ ಮರದ ಕಟ್ಟಿಗೆಯಿಂದ ಧೂಪವೇದಿಯನ್ನು ಮಾಡಿದರು. ಅದರ ಉದ್ದ ಮತ್ತು ಅಗಲ ಸುಮಾರು ನಲವತ್ತೈದು ಸೆಂಟಿಮೀಟರ್, ಅದರ ಎತ್ತರ ಸುಮಾರು ತೊಂಬತ್ತು ಸೆಂಟಿಮೀಟರ್ ಇದ್ದು, ಅದು ಚಚ್ಚೌಕವಾಗಿತ್ತು. ಅದರ ಕೊಂಬುಗಳನ್ನು ಸಹ ಜಾಲಿ ಮರದಿಂದಲೇ ಮಾಡಲಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ಅದರ ಮೇಲ್ಭಾಗವನ್ನೂ ಅದರ ಸುತ್ತಲಿನ ಬದಿಗಳನ್ನೂ ಕೊಂಬುಗಳನ್ನೂ ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಹೊದಿಸಿದರು. ಅದರ ಸುತ್ತಲೂ ಬಂಗಾರದ ಗೋಟನ್ನು ಕಟ್ಟಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ಅದರ ಗೋಟಿನ ಕೆಳಗೆ ಎರಡು ಬದಿಗಿರುವ ಎರಡು ಮೂಲೆಗಳಲ್ಲಿ ಎರಡು ಬಂಗಾರದ ಬಳೆಗಳನ್ನು ಮಾಡಿದರು, ಇವುಗಳನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಅವುಗಳಲ್ಲಿ ಕೋಲುಗಳನ್ನು ಸಿಕ್ಕಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ಕೋಲುಗಳನ್ನು ಜಾಲಿ ಮರದಿಂದ ಮಾಡಿ, ಅವುಗಳನ್ನು ಬಂಗಾರದಿಂದ ಹೊದಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ಅನಂತರ ಅವರು ಸುಗಂಧಕಾರನ ವಿದ್ಯೆಯ ಪ್ರಕಾರ ಪರಿಶುದ್ಧವಾದ ಅಭಿಷೇಕ ತೈಲವನ್ನು ಮತ್ತು ಪರಿಮಳ ದ್ರವ್ಯದಿಂದ ಶುದ್ಧವಾದ ಧೂಪವನ್ನು ತಯಾರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ಬೆಚಲೇಲನು ಜಾಲಿ ಮರದಿಂದ ದಹನಬಲಿಯ ಪೀಠವನ್ನು ಮಾಡಿದರು. ಅದರ ಎತ್ತರವು ಸುಮಾರು ಒಂದು ಮೀಟರ್ ಇರಬೇಕು. ಅದರ ಉದ್ದ ಮತ್ತು ಅಗಲವು ಸುಮಾರು ಎರಡೂವರೆ ಮೀಟರ್ ಚಚ್ಚೌಕವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಕೊಂಬುಗಳನ್ನು ಮಾಡಿದರು. ಆ ಕೊಂಬುಗಳು ಆ ಬಲಿಪೀಠಕ್ಕೆ ಏಕವಾಗಿರಬೇಕು. ಅವುಗಳನ್ನು ಕಂಚಿನಿಂದ ಹೊದಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ಅನಂತರ ಅವರು ಬಲಿಪೀಠದ ಉಪಕರಣಗಳನ್ನೆಲ್ಲಾ ಅಂದರೆ ಬಟ್ಟಲುಗಳು, ಸಲಿಕೆಗಳು, ಮುಳ್ಳುಚಮಚಗಳು, ಬೋಗುಣಿಗಳು, ಅಗ್ಗಿಷ್ಟಿಕೆಗಳು ಇವುಗಳೆನ್ನೆಲ್ಲಾ ಕಂಚಿನಿಂದ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ಬಲಿಪೀಠಕ್ಕೆ ಹೆಣಿಗೆ ಕೆಲಸದಿಂದ ಕಂಚಿನ ಜಾಳಿಗೆಯನ್ನು ಮಾಡಿದರು. ಅದು ಬಲಿಪೀಠದ ಸುತ್ತಲಿರುವ ಕಟ್ಟಿಗೆಯ ಕಟ್ಟೆಯ ಕೆಳಗೆ ಇದ್ದು, ಅದನ್ನು ಬಲಿಪೀಠದ ಕೆಳಭಾಗದಿಂದ ಮಧ್ಯದವರೆಗೆ ಇರುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ವೇದಿಯನ್ನು ಹೊರುವಾಗ ಕೋಲು ಸಿಕ್ಕಿಸುವುದಕ್ಕೋಸ್ಕರ ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ನಾಲ್ಕು ಬಳೆಗಳನ್ನು ಕಂಚಿನಿಂದ ಎರಕ ಹೊಯ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ಅವರು ಜಾಲಿ ಮರದಿಂದ ಕೋಲುಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳನ್ನು ಕಂಚಿನಿಂದ ಹೊದಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ಬಲಿಪೀಠವನ್ನು ಹೊರುವುದಕ್ಕೆ ಅದರ ಎರಡೂ ಬದಿಯಲ್ಲಿ ಮಾಡಿದ ಕೋಲುಗಳನ್ನು ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಿದರು. ಅವರು ಆ ಬಲಿಪೀಠವನ್ನು ಚೌಕಟ್ಟುಗಳಿಂದ ಪೊಳ್ಳಾಗಿರುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಸೇವೆಮಾಡುತ್ತಿದ್ದ ಸ್ತ್ರೀಯರಿಂದ ಕೂಡಿಸಿದ ಕಂಚಿನ ದರ್ಪಣಗಳಿಂದ ಕಂಚಿನಿಂದ ಬೋಗುಣಿಯನ್ನು ಅದರ ಪೀಠವನ್ನೂ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ಅವರು ಗುಡಾರದ ಅಂಗಳವನ್ನು ಮಾಡಿದರು. ಹೇಗೆಂದರೆ ದಕ್ಷಿಣ ದಿಕ್ಕಿನಲ್ಲಿರುವ ಅಂಗಳಕ್ಕೋಸ್ಕರ ನಯವಾಗಿ ಹೊಸೆದ ನಾರಿನ ಪರದೆಗಳನ್ನು ಮಾಡಲಾಗಿತ್ತು. ಅವು ಸುಮಾರು ನಲವತ್ತೈದು ಮೀಟರ್ ಉದ್ದವಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ಆ ಕಡೆಯಲ್ಲಿ ಇಪ್ಪತ್ತು ಸ್ತಂಭಗಳಿದ್ದವು ಮತ್ತು ಅವುಗಳಿಗೆ ಇಪ್ಪತ್ತು ಕಂಚಿನ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿದ್ದವು. ಸ್ತಂಭಗಳ ಕೊಂಡಿಗಳನ್ನು ಮತ್ತು ಅವುಗಳ ಪಟ್ಟಿಗಳನ್ನು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಲಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ಉತ್ತರ ದಿಕ್ಕಿನ ಪರದೆಗಳು ಸುಮಾರು ನಲವತ್ತೈದು ಮೀಟರ್ ಉದ್ದವಾಗಿದ್ದವು. ಇಪ್ಪತ್ತು ಸ್ತಂಭಗಳು ಮತ್ತು ಇಪ್ಪತ್ತು ಕಂಚಿನ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿದ್ದವು. ಆ ಸ್ತಂಭಗಳ ಕೊಂಡಿಗಳು ಮತ್ತು ಕಟ್ಟುಗಳು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಿದ್ದಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ಅಂಗಳದ ಪಶ್ಚಿಮ ಭಾಗದಲ್ಲಿ ಸುಮಾರು ಇಪ್ಪತ್ತಮೂರು ಮೀಟರ್ ಉದ್ದವಾದ ಪರದೆಗಳಿದ್ದವು. ಹತ್ತು ಸ್ತಂಭಗಳು ಮತ್ತು ಆ ಸ್ತಂಭಗಳಿಗೆ ಹತ್ತು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿದ್ದವು. ಸ್ತಂಭಗಳ ಕೊಂಡಿ ಮತ್ತು ಅಲಂಕಾರದ ಮೇಲಿನ ಕಟ್ಟುಗಳು ಬೆಳ್ಳಿಯದ್ದಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಸೂರ್ಯೋದಯದ ಕಡೆಗೆ ಅಂಗಳದ ಅಗಲವು ಸುಮಾರು ಇಪ್ಪತ್ತಮೂರು ಮೀಟರವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ದ್ವಾರದ ಒಂದು ಬದಿಯ ಪರದೆಗಳು ಸುಮಾರು ಆರುವರೆ ಮೀಟರ್ ಉದ್ದವಾಗಿದ್ದವು. ಅವುಗಳಿಗೆ ಮೂರು ಸ್ತಂಭಗಳು, ಆ ಸ್ತಂಭಗಳಿಗೆ ಮೂರು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳು ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ಅಂಗಳದ ದ್ವಾರದ ಎರಡೂ ಕಡೆಗಳಲ್ಲಿ ಸುಮಾರು ಆರುವರೆ ಮೀಟರ್ ಉದ್ದವಾದ ಪರದೆಗಳಿದ್ದವು, ಅವುಗಳಿಗೆ ಮೂರು ಸ್ತಂಭಗಳು ಮತ್ತು ಮೂರು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ಅಂಗಳದ ಸುತ್ತಲಿದ್ದ ಎಲ್ಲ ಪರದೆಗಳು ನಯವಾಗಿ ಹೊಸೆದ ನಾರಿನ ಬಟ್ಟೆಯಿಂದ ಮಾಡಲಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ಸ್ತಂಭಗಳ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳು ಕಂಚಿನದ್ದಾಗಿದ್ದವು. ಸ್ತಂಭಗಳ ಕೊಂಡಿಗಳು ಮತ್ತು ಕಟ್ಟುಗಳು ಬೆಳ್ಳಿಯದ್ದಾಗಿದ್ದವು. ಸ್ತಂಭದ ಬೋದಿಗೆಗಳು ಬೆಳ್ಳಿಯಿಂದ ಹೊದಿಸಲಾಗಿತ್ತು. ಅಂಗಳದ ಎಲ್ಲಾ ಸ್ತಂಭಗಳಿಗೆ ಬೆಳ್ಳಿಯ ಕಟ್ಟುಗಳಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ಗುಡಾರದ ಅಂಗಳದ ದ್ವಾರಕ್ಕಾಗಿ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಕಸೂತಿ ಕೆಲಸಮಾಡಿದ ಇಪ್ಪತ್ತು ಮೊಳದ ಪರದೆ ಮಾಡಲಾಗಿತ್ತು. ಅದರ ಉದ್ದವು ಇಪ್ಪತ್ತು ಮೊಳವಾಗಿತ್ತು. ಅಗಲ, ಎತ್ತರಗಳಲ್ಲಿ ಅಂಗಳದ ಉಳಿದ ಪರದೆಗಳಿಗೆ ಸರಿಯಾಗುವಂತೆ ಐದು ಮೊಳ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ಅವುಗಳಿಗೆ ನಾಲ್ಕು ಸ್ತಂಭಗಳು, ಆ ಕಂಬಗಳಿಗೆ ನಾಲ್ಕು ಕಂಚಿನ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿದ್ದವು. ಅವುಗಳ ಕೊಂಡಿಗಳು ಬೆಳ್ಳಿಯದ್ದಾಗಿದ್ದವು. ಅವುಗಳ ಬೋದಿಗಳ ಹೊದಿಕೆ ಮತ್ತು ಅಲಂಕಾರದ ಪಟ್ಟಿಗಳು ಬೆಳ್ಳಿಯದ್ದಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ಗುಡಾರದ ಮತ್ತು ಅಂಗಳದ ಸುತ್ತಲೂ ಇರುವ ಎಲ್ಲಾ ಗೂಟಗಳೂ ಕಂಚಿನಿಂದ ಮಾಡಿದ್ದಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೆ ಅಂದರೆ ಒಡಂಬಡಿಕೆಯ ನಿಯಮದ ಗುಡಾರ ನಿರ್ಮಾಣಕ್ಕೆ ಬಳಸಿದ ವಸ್ತುಗಳ ಲೆಕ್ಕ ಇವು: ಮೋಶೆಯ ಆಜ್ಞೆಯ ಮೇರೆಗೆ ಯಾಜಕನಾದ ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನ ನಿರ್ದೇಶನದಲ್ಲಿ ಲೇವಿಯರ ಕೈಯಿಂದ ಲೆಕ್ಕ ಮಾಡಿಸಿದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೆಲ್ಲಾ ಯೆಹೂದ ಕುಲದವನಾದ ಊರಿಯ ಮಗನೂ ಹೂರನ ಮೊಮ್ಮಗನೂ ಆದ ಬೆಚಲಯೇಲನು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ಅವನ ಜೊತೆಯಲ್ಲಿ ದಾನ್ ಕುಲದವನಾದ ಅಹೀಸಾಮಾಕನ ಮಗ ಒಹೋಲಿಯಾಬನೂ ಇದ್ದನು. ಇವನು ಕೆತ್ತನೆ ಕೆಲಸ ಮಾಡುವವನೂ ಕುಶಲ ಕೆಲಸಗಾರನೂ ನೀಲಿ, ಧೂಮ್ರ ಮತ್ತು ರಕ್ತವರ್ಣದ ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಕಸೂತಿ ಕೆಲಸ ಮಾಡುವವನೂ ಆಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ಪರಿಶುದ್ಧಾಲಯದ ಸೇವೆಗೆ ನೇಮಕವಾದ ಪರಿಶುದ್ಧ ಕೆಲಸಕ್ಕೆ ಉಪಯೋಗಿಸಿದ ಎಲ್ಲಾ ಬಂಗಾರವು ವಿಶೇಷವಾಗಿ ಅರ್ಪಿಸಿದ ಕಾಣಿಕೆಯಾಗಿತ್ತು, ಅದು ಇಪ್ಪತ್ತೊಂಬತ್ತು ತಲಾಂತು ಮತ್ತು ಏಳುನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ಪರಿಶುದ್ಧಾಲಯದ ನಿಯಮದ ಮೇರೆಗೆ ಸಮೂಹದ ಜನಗಣತಿಯಲ್ಲಿ ದಾಖಲಿಸಿದ ಜನರಿಂದ ಸಂಗ್ರಹಿದ ಬೆಳ್ಳಿಯ ತೂಕವು ಸುಮಾರು 3,400 ಕಿಲೋಗ್ರಾಂ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ಪರಿಶುದ್ಧಾಲಯದ ನಿಯಮದ ಮೇರೆಗೆ ಪ್ರತಿಯೊಬ್ಬ ಮನುಷ್ಯನಿಂದ ಒಂದೊಂದು “ಬೆಕಾ” ಅಂದರೆ ಅರ್ಧ ಶೆಕೆಲ್ ಆಗಿತ್ತು. ಕೊಟ್ಟವರ ಲೆಕ್ಕವನ್ನು ಇಪ್ಪತ್ತು ವರ್ಷದವರು ಮತ್ತು ಅದಕ್ಕೆ ಮೇಲಿನ ಪ್ರಾಯದವರನ್ನು ಲೆಕ್ಕ ಮಾಡಲಾಗಿ ಅದು 6,03,550 ಗಂಡಸರ ಸಂಖ್ಯೆ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ಪರಿಶುದ್ಧಾಲಯದ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿಗೆ ಮತ್ತು ಪರದೆಗಳ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿಗೆ ಎರಕ ಹೊಯ್ಯಲು 3,400 ಕಿಲೋಗ್ರಾಂ ಬೆಳ್ಳಿ ಹಿಡಿಯಿತು. ಒಂದು ಗದ್ದಿಗೇ ಕಲ್ಲಿಗೆ ಮೂವತ್ನಾಲ್ಕು ಕಿಲೋಗ್ರಾಂನಂತೆ ನೂರು ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳಿಗೆ 3,400 ಕಿಲೋಗ್ರಾಂ ಬೆಳ್ಳಿ ಆಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ಒಂದರ ತೂಕ ಸುಮಾರು 34 ಕಿಲೋಗ್ರಾಂ ಇತ್ತು. ಅವನು ಕಂಬಗಳಿಗೆ ಕೊಂಡಿಗಳನ್ನೂ ಕಂಬದ ಬೋದಿಗೆ ಮೇಲ್ಹೊದಿಕೆಯನ್ನೂ ಅಲಂಕಾರದ ಪಟ್ಟಿಗಳನ್ನೂ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ವಿಶೇಷ ಕಾಣಿಕೆಯಾಗಿ ಬಂದ ಕಂಚು 2,425 ಕಿಲೋಗ್ರಾಂ ತೂಕವಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ಆ ಕಂಚಿನಿಂದ ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ದ್ವಾರಗಳಿಗೆ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನೂ ಬಲಿಪೀಠವನ್ನೂ ಅದಕ್ಕೆ ಕಂಚಿನ ಜಾಳಿಗೆಯನ್ನೂ ಬಲಿಪೀಠದ ಸಮಸ್ತ ಪಾತ್ರೆಗಳನ್ನೂ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ಅಂಗಳದ ಸುತ್ತಲಿನ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನೂ, ಗುಡಾರದ ಮತ್ತು ಅಂಗಳದ ಸುತ್ತಲಿನ ಎಲ್ಲಾ ಗೂಟಗಳನ್ನೂ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮೇರೆಗೆ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರಿನಿಂದ ಪವಿತ್ರ ಆಲಯದ ಸೇವೆ ಮಾಡುವುದಕ್ಕೆ ಕಲಾತ್ಮಕವಾಗಿ ನೇಯ್ದ ಸೇವಾ ವಸ್ತ್ರಗಳನ್ನು ಮತ್ತು ಆರೋನನಿಗೆ ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ಬೆಚಲೇಲನು ಏಫೋದನ್ನು ಬಂಗಾರ, ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರುಬಟ್ಟೆಯನ್ನು ಹೊಸೆದು ಉಪಯೋಗಿಸಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ಅವರು ಬಂಗಾರವನ್ನು ಹೊಡೆದು, ತೆಳುವಾದ ತಗಡುಗಳನ್ನಾಗಿ ಮಾಡಿ, ಅದನ್ನು ಕತ್ತರಿಸಿ ಎಳೆಗಳನ್ನಾಗಿ ಮಾಡಿ, ಆ ಎಳೆಗಳನ್ನು ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಕಸೂತಿ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೆ ಉಪಯೋಗಿಸಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ಆ ಕವಚಕ್ಕೆ ಅದರ ಎರಡೂ ಕೊನೆಗಳನ್ನು ಜೋಡಿಸುವುದಕ್ಕೆ ಎರಡು ಹೆಗಲು ಪಟ್ಟಿಗಳನ್ನು ತಯಾರಿಸಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ಅದರ ಮೇಲಿರುವ ಅದರ ಮೇಲಿರುವ ಕಸೂತಿ ಕೆಲಸದ ಏಫೋದಿನ ನಡುಕಟ್ಟನ್ನು ಒಂದೇ ರೀತಿಯ ವಸ್ತುಗಳಿಂದ ತಯಾರಿಸಬೇಕು ಅಂದರೆ ಬಂಗಾರ, ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರಿನಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಮಾಡಲಾಗಿತ್ತು, ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ಮುದ್ರೆ ಕೆತ್ತುವ ಪ್ರಕಾರ, ಗೋಮೇಧಿಕ ರತ್ನಗಳಲ್ಲಿ ಹನ್ನೆರಡು ಇಸ್ರಾಯೇಲರ ಮಕ್ಕಳ ಹೆಸರುಗಳನ್ನು ಕೆತ್ತಿ ಬಂಗಾರದ ಕುಂದಣದಲ್ಲಿ ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆಯೇ ಅವರು ಆ ಎರಡು ರತ್ನಗಳನ್ನು ಏಫೋದಿನ ಹೆಗಲಿನ ಭಾಗದ ಮೇಲೆ ಇಸ್ರಾಯೇಲರ ಜ್ಞಾಪಕಾರ್ಥವಾದ ರತ್ನಗಳಾಗುವಂತೆ ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ಎದೆಪದಕವನ್ನು ಕೌಶಲ್ಯ ಕೆಲಸದಿಂದ ಎಂದರೆ ಏಫೋದಿನ ಕೆಲಸದ ಹಾಗೆಯೇ ಬಂಗಾರ, ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರಿನಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ಅದು ಚಚ್ಚೌಕವಾಗಿತ್ತು, ಅದು ಗೇಣು ಉದ್ದ, ಒಂದು ಗೇಣು ಅಗಲ ಮತ್ತು ಇದು ಎರಡು ಪದರುಳ್ಳದ್ದಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ನಂತರ ಅದರಲ್ಲಿ ನಾಲ್ಕು ಸಾಲುಗಳಾಗಿ ರತ್ನಗಳನ್ನು ಜೋಡಿಸಿದರು. ಮೊದಲನೆಯ ಸಾಲಿನಲ್ಲಿ ಮಾಣಿಕ್ಯ, ಪುಷ್ಯರಾಗ ಮತ್ತು ಸ್ಪಟಿಕಗಳಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ಎರಡನೆಯ ಸಾಲಿನಲ್ಲಿ ಕೆಂಪರಲು, ನೀಲ ಮತ್ತು ಪಚ್ಚೆಗಳಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ಮೂರನೆಯ ಸಾಲಿನಲ್ಲಿ ಸುವರ್ಣರತ್ನ, ಗೋಮೇಧಿಕ ಮತ್ತು ಧೂಮ್ರಮಣಿಗಳಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ನಾಲ್ಕನೆಯ ಸಾಲಿನಲ್ಲಿ ಪೀತರತ್ನ, ಗೋಮೇಧಿಕ, ಸೂರ್ಯಕಾಂತ ಶಿಲೆ ಇವುಗಳನ್ನು ಬಂಗಾರದ ಜವೆಯ ಕಲ್ಲುಗಳಲ್ಲಿ ಸೇರಿಸಲಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ಆ ರತ್ನಗಳು ಇಸ್ರಾಯೇಲರ ಗೋತ್ರದ ಹೆಸರುಗಳ ಪ್ರಕಾರ ಅವು ಹನ್ನೆರಡಾಗಿದ್ದವು. ಒಂದೊಂದರ ಮೇಲೆ ಒಂದೊಂದು ಹೆಸರಿದ್ದು ಹನ್ನೆರಡು ಗೋತ್ರಗಳ ಪ್ರಕಾರ ಮುದ್ರೆಗಳ ಹಾಗೆ ಕೆತ್ತಿದವುಗಳಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ಎದೆಪದಕದ ಮೇಲಿರುವ ಕೊನೆಗಳಲ್ಲಿ ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಹೆಣೆದ ಕೆಲಸವಾಗಿರುವ ಹುರಿಗಳಂತಿರುವ ಸರಪಣಿಯನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ಬಂಗಾರದ ಆ ಎರಡು ಜವೆಗಳನ್ನು ಮಾಡಿ, ಆ ಎರಡು ಬಳೆಗಳನ್ನು ಎದೆಪದಕದ ಎರಡು ಕೊನೆಗಳಲ್ಲಿ ಸೇರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ಬಂಗಾರದಿಂದ ಹೆಣೆದ ಆ ಎರಡು ಸರಪಣಿಗಳನ್ನು ಎದೆಪದಕದ ಕೊನೆಗಳಲ್ಲಿರುವ ಎರಡು ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ಆ ಎರಡು ಹೆಣೆದ ಸರಪಣಿಗಳ ಎರಡು ಕೊನೆಗಳನ್ನು ಆ ಎರಡು ಜವೆಗಳಲ್ಲಿ ಸೇರಿಸಿ, ಏಫೋದಿನ ಹೆಗಲು ಭಾಗಗಳ ಮುಂದುಗಡೆ ಇರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ಬಂಗಾರದ ಎರಡು ಉಂಗುರಗಳನ್ನು ಮಾಡಿ, ಎದೆಪದಕದ ಎರಡು ಕೊನೆಗಳಲ್ಲಿ ಸೇರಿಸಿ ಏಫೋದಿನ ಬದಿಗೆ ಒಳಗಡೆಯಲ್ಲಿ ಹಾಕಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ಚಿನ್ನದ ಬೇರೆ ಎರಡು ಉಂಗುರಗಳನ್ನು ಮಾಡಿ, ಏಫೋದಿನ ಮುಂಬದಿಯ ಕೆಳಗಿನ ಎರಡು ಹೆಗಲಿನ ಪಟ್ಟಿಗಳಲ್ಲಿ, ಏಫೋದಿನ ವಿಚಿತ್ರವಾದ ನಡುಕಟ್ಟಿನ ಮೇಲೆ ಅದನ್ನು ಜೋಡಿಸುವ ಸ್ಥಳಕ್ಕೆ ಎದುರಾಗಿ ಇರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆಯೇ ಆ ಎದೆಪದಕವನ್ನು ಏಫೋದಿನ ವಿಚಿತ್ರವಾದ ನಡುಕಟ್ಟಿನ ಮೇಲೆ ಇರುವಂತೆಯೂ ಎದೆಪದಕವು ಏಫೋದನ್ನು ಬಿಟ್ಟು ಅಲ್ಲಾಡದಂತೆಯೂ ಅದರ ಉಂಗುರಗಳ ಮೂಲಕವಾಗಿ ಏಫೋದಿನ ಉಂಗುರಗಳಿಗೆ ನೀಲಿ ದಾರದಿಂದ ಕಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ಏಫೋದಿನ ನಿಲುವಂಗಿಯನ್ನೆಲ್ಲಾ ನೀಲಿ ಬಣ್ಣದ ಬಟ್ಟೆಯಿಂದ ಮಾಡಿದರು. ಅದು ನೇಕಾರನ ಕೆಲಸವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ನಿಲುವಂಗಿಯ ರಂದ್ರ, ಕವಚದ ರಂದ್ರದ ಹಾಗೆ ಅದರ ಮಧ್ಯದಲ್ಲಿ ಇತ್ತು. ಅದು ಹರಿಯದ ಹಾಗೆ ಯುದ್ಧದ ಕವಚದೋಪಾದಿಯಲ್ಲಿ ಆ ರಂದ್ರದ ಸುತ್ತಲೂ ನೇಯ್ಗೆ ಪಟ್ಟಿ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ನಿಲುವಂಗಿಯ ಅಂಚಿನ ಮೇಲೆ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಮತ್ತು ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದು ದಾಳಿಂಬೆ ಹಣ್ಣಿನಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ಶುದ್ಧ ಬಂಗಾರದ ಗಂಟೆಗಳನ್ನು ಮಾಡಿ, ಆ ಗಂಟೆಗಳನ್ನು ದಾಳಿಂಬೆಗಳ ನಡುವೆಯೇ ಇರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ಒಂದು ಗೆಜ್ಜೆ, ಒಂದು ದಾಳಿಂಬೆಯಂತಿರುವ ಚೆಂಡನ್ನು ಒಂದಾದ ಮೇಲೆ ಒಂದು ಸೇವೆಗೋಸ್ಕರ ಮಾಡಿದ ಮೇಲಂಗಿಯ ಅಂಚಿನ ಸುತ್ತಲೂ ಇದ್ದವು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆಯೇ ಅದು ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ಆರೋನನಿಗೆ ಹಾಗೂ ಅವನ ಮಕ್ಕಳಿಗೆ ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದ ಕೆಲಸದಿಂದ ಮಾಡಿದ ಮೇಲಂಗಿಗಳನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ನಯವಾದ ನಾರಿನಿಂದ ಮಾಡಿದ ಮುಂಡಾಸವನ್ನೂ ಸೌಂದರ್ಯವುಳ್ಳ ನಾರಿನ ಕುಲಾವಿಗಳನ್ನೂ ಹೊಸೆದ ನಯವಾದ ನಾರುಗಳಿಂದ ಮಾಡಿದ ಒಳಉಡುಪುಗಳನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ನಯವಾದ ನಾರಿನಿಂದ ಹೊಸೆದ ನೀಲಿ, ಧೂಮ್ರ, ರಕ್ತವರ್ಣದ ದಾರದಿಂದ ಹೆಣಿಗೆಯ ಕೆಲಸದಿಂದ ನಡುಕಟ್ಟನ್ನೂ ಮಾಡಿದರು. ಇವುಗಳನ್ನು ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ಶುದ್ಧ ಬಂಗಾರದಿಂದ ಪರಿಶುದ್ಧ ಕಿರೀಟದ ತಗಡನ್ನು ಮಾಡಿ, ಮುದ್ರೆ ಕೆತ್ತುವ ಪ್ರಕಾರ ಅದರಲ್ಲಿ, “ಯೆಹೋವ ದೇವರಿಗೆ ಪರಿಶುದ್ಧ,” ಎಂದು ಕೆತ್ತಿಸಿದರು, ");
INSERT INTO kanokcv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ಅದು ಮುಂಡಾಸದ ಮುಂಭಾಗದಲ್ಲಿರುವಂತೆ ಅದನ್ನು ನೀಲಿ ದಾರಿನಿಂದ ಕಟ್ಟಿಸಿದರು. ಇದನ್ನು ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ಈ ಪ್ರಕಾರ ದೇವದರ್ಶನದ ಗುಡಾರದ ಕೆಲಸವೆಲ್ಲಾ ಮುಗಿಯಿತು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೆಲ್ಲಾ ಇಸ್ರಾಯೇಲರು ಅದರಂತೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ಆಗ ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಮೋಶೆಯ ಬಳಿಗೆ ತಂದರು. ಅದರ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು, ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನು ಅದರ ಕೊಂಡಿಗಳನ್ನು, ಅದರ ಚೌಕಟ್ಟುಗಳನ್ನು, ಅದರ ಅಗುಳಿಗಳನ್ನು, ಅದರ ಸ್ತಂಭಗಳನ್ನು, ಅದರ ಕುಣಿಕೆಗಳನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ಕೆಂಪು ಬಣ್ಣದಲ್ಲಿ ಅದ್ದಿದ ಟಗರುಗಳ ಹೊದಿಕೆಯನ್ನು, ಕಡಲುಹಂದಿಗಳ ಚರ್ಮಗಳ ಹೊದಿಕೆಗಳನ್ನು, ಮರೆಮಾಡುವ ಪರದೆಯನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷನ್ನು, ಅದರ ಕೋಲುಗಳನ್ನು, ಕರುಣಾಸನವನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ಮೇಜನ್ನು, ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು, ನೈವೇದ್ಯದ ರೊಟ್ಟಿಯನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ಶುದ್ಧವಾದ ದೀಪಸ್ತಂಭವನ್ನು, ಅದರ ದೀಪಗಳನ್ನು, ಕ್ರಮವಾಗಿಡುವ ದೀಪಗಳನ್ನು, ಅದರ ಉಪಕರಣಗಳನ್ನು, ದೀಪಸ್ತಂಭಕ್ಕಾಗಿ ಎಣ್ಣೆಯನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ಚಿನ್ನದ ಬಲಿಪೀಠವನ್ನು, ಅಭಿಷೇಕಿಸುವ ತೈಲವನ್ನು, ಪರಿಮಳ ಧೂಪವನ್ನು, ಗುಡಾರದ ಬಾಗಿಲಿನ ಪರದೆಯನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ಬಲಿಪೀಠವನ್ನು, ಅದರೊಂದಿಗೆ ಕಂಚಿನ ಜಾಳಿಗೆಯನ್ನು, ಅದರ ಕೋಲುಗಳನ್ನು, ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು, ಕಂಚಿನ ಗಂಗಾಳವನ್ನು, ಅದರ ಕಾಲನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ದೇವದರ್ಶನದ ಗುಡಾರ ಅಂಗಳದ ಪರದೆಗಳನ್ನು, ಅದರ ಸ್ತಂಭಗಳನ್ನು, ಅದರ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳನ್ನು, ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆಗಳನ್ನು, ಅದರ ಹಗ್ಗಗಳನ್ನು, ಗುಡಾರದ ಗೂಟಗಳನ್ನು, ಸಭೆಯ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೆ ಬೇಕಾದ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ಪರಿಶುದ್ಧಸ್ಥಳದ ಸೇವೆಗೋಸ್ಕರ ನೇಯ್ದ ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳನ್ನು ಅಂದರೆ ಸೇವೆಮಾಡುವದಕ್ಕೆ ಯಾಜಕನಾದ ಆರೋನನಿಗೆ ಮತ್ತು ಅವನ ಪುತ್ರರಿಗೆ ಯಾಜಕವಸ್ತ್ರಗಳನ್ನು ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆಯೇ, ಇಸ್ರಾಯೇಲರು ಈ ಕೆಲಸಗಳನ್ನೆಲ್ಲಾ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ಮೋಶೆಯು ಆ ಕೆಲಸವನ್ನೆಲ್ಲಾ ನೋಡಿದಾಗ, ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಅವರು ಅದನ್ನು ಮಾಡಿದ್ದರು. ಆದ್ದರಿಂದ ಮೋಶೆಯು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿವಸದಲ್ಲಿ ಸಭೆಯ ಡೇರೆಯನ್ನು ಮತ್ತು ಗುಡಾರವನ್ನು ಎತ್ತಿ ನಿಲ್ಲಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷವನ್ನು ಅದರಲ್ಲಿ ಇಟ್ಟು, ಅದನ್ನು ನೀನು ಪರದೆಯಿಂದ ಮುಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ಮೇಜನ್ನು ಒಳಗೆ ತಂದು, ಅದರ ಮೇಲಿಡಬೇಕಾದದ್ದನ್ನು ಸರಿಯಾಗಿ ಇಡಬೇಕು. ದೀಪಸ್ತಂಭವನ್ನು ಒಳಗೆ ತಂದು, ನೀನು ಅದರ ದೀಪಗಳನ್ನು ಅಂಟಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ನೀನು ಮಾಡಿದ ಚಿನ್ನದ ಧೂಪಪೀಠವನ್ನು ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಎದುರಾಗಿ ಇಟ್ಟು, ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಪರದೆಯನ್ನು ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“ನೀನು ದಹನಬಲಿಯ ಪೀಠವನ್ನು ಸಭೆಯ ಡೇರೆಯಾದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಎದುರಾಗಿ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ನೀನು ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೂ, ಬಲಿಪೀಠಕ್ಕೂ ಮಧ್ಯದಲ್ಲಿ ಗಂಗಾಳವನ್ನಿಟ್ಟು, ಅದರಲ್ಲಿ ನೀರನ್ನು ತುಂಬಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ಅದರ ಸುತ್ತಲೂ ಆವರಣವನ್ನು ನಿಲ್ಲಿಸಿ, ಆ ಆವರಣದ ಬಾಗಿಲಿನ ಬಳಿಯಲ್ಲಿ ನೀನು ಪರದೆಯನ್ನು ತೂಗು ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ನೀನು ಅಭಿಷೇಕ ತೈಲವನ್ನು ತೆಗೆದುಕೊಂಡು ಗುಡಾರವನ್ನೂ, ಅದರಲ್ಲಿರುವ ಎಲ್ಲವುಗಳನ್ನೂ ಅಭಿಷೇಕಿಸಿ, ಅದರಲ್ಲಿರುವ ಎಲ್ಲಾ ಸಾಮಗ್ರಿಗಳನ್ನೂ ಪರಿಶುದ್ಧ ಮಾಡು. ಆಗ ಅದು ಪರಿಶುದ್ಧವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ದಹನಬಲಿಯ ಪೀಠವನ್ನೂ, ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ನೀನು ಅಭಿಷೇಕಿಸಿ, ಬಲಿಪೀಠವನ್ನು ಪವಿತ್ರಮಾಡು. ಆಗ ಅದು ಅತಿಪರಿಶುದ್ಧವಾದ ಬಲಿಪೀಠವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ಗಂಗಾಳವನ್ನೂ, ಅದರ ಕಾಲುಗಳನ್ನೂ ನೀನು ಅಭಿಷೇಕಿಸಿ, ಅದನ್ನು ಪ್ರತಿಷ್ಠಾಪನೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“ಆರೋನನನ್ನೂ, ಅವನ ಮಕ್ಕಳನ್ನೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿಗೆ ಬರಮಾಡಿ, ಅವರನ್ನು ನೀರಿನಿಂದ ಸ್ನಾನ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ಆರೋನನು ನನಗೆ ಯಾಜಕ ಸೇವೆ ಮಾಡುವ ಹಾಗೆ ಅವನಿಗೆ ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳನ್ನು ತೊಡಿಸಿ, ಅವನನ್ನು ಅಭಿಷೇಕಿಸಿ, ಅವನನ್ನು ಶುದ್ಧಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ಅವನ ಪುತ್ರರನ್ನು ನೀನು ಬರಮಾಡಿಕೊಂಡು, ಅವರಿಗೆ ಅಂಗಿಗಳನ್ನು ತೊಡಿಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ಅವರ ತಂದೆಯನ್ನು ಅಭಿಷೇಕಿಸಿದ ಪ್ರಕಾರ, ಅವರು ನನಗೆ ಯಾಜಕ ಸೇವೆಯನ್ನು ಮಾಡುವ ಹಾಗೆ ಅವರನ್ನೂ ನೀನು ಅಭಿಷೇಕಿಸು. ಅವರ ಈ ಅಭಿಷೇಕದಿಂದ ಅವರ ಸಂತತಿಗಳಲ್ಲಿ ನಿತ್ಯವಾದ ಯಾಜಕತ್ವವಾಗಿರುವುದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಅವನು ಎಲ್ಲವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ಎರಡನೆಯ ವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿವಸದಲ್ಲಿ ಗುಡಾರವು ಎದ್ದುನಿಂತಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ಆಗ ಮೋಶೆಯು ಗುಡಾರವನ್ನು ನಿಲ್ಲಿಸಿ, ಅದರ ಕಾಲುಗಳನ್ನು ಬಿಗಿದು, ಅದರ ಚೌಕಟ್ಟುಗಳನ್ನು ಇರಿಸಿ, ಅಗುಳಿಗಳನ್ನು ಹಾಕಿ, ಅದರ ಸ್ತಂಭಗಳನ್ನು ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆ ಗುಡಾರದ ಮೇಲೆ ಡೇರೆಯನ್ನು ಹರಡಿಸಿ, ಡೇರೆಯ ಹೊದಿಕೆಯನ್ನು ಅದರ ಮೇಲೆ ಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ಅವನು ಆಜ್ಞಾಶಾಸನಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಮಂಜೂಷದ ಪೆಟ್ಟಿಗೆಯಲ್ಲಿಟ್ಟು, ಮಂಜೂಷಕ್ಕೆ ಕೋಲುಗಳನ್ನು ಸೇರಿಸಿ, ಮಂಜೂಷದ ಮೇಲೆ ಕರುಣಾಸನವನ್ನು ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ಅವನು ಮಂಜೂಷವನ್ನು ಗುಡಾರಕ್ಕೆ ತಂದು, ಮರೆಮಾಡುವ ಪರದೆಯನ್ನಿರಿಸಿ, ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷವನ್ನು ಮರೆಮಾಡಿದನು. ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ಅನಂತರ ಮೋಶೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಉತ್ತರ ಭಾಗದಲ್ಲಿ, ಪರದೆಯ ಹೊರಗೆ ಮೇಜನ್ನು ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆ ಅದರ ಮೇಲೆ ರೊಟ್ಟಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಕ್ರಮವಾಗಿ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಮೇಜಿಗೆ ಎದುರಾಗಿ ಗುಡಾರದ ದಕ್ಷಿಣ ಭಾಗದಲ್ಲಿ ದೀಪಸ್ತಂಭವನ್ನು ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೀಪಗಳನ್ನು ಇರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ಚಿನ್ನದ ಧೂಪವೇದಿಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಪರದೆಯ ಮುಂದೆ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆ ಅದರ ಮೇಲೆ ಪರಿಮಳ ಧೂಪವನ್ನು ಸುಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ಗುಡಾರದ ಬಾಗಿಲಿನ ಪರದೆಯನ್ನು ತೂಗುಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಳಿಯಲ್ಲಿ ದಹನಬಲಿಯ ಪೀಠವನ್ನು ಇಟ್ಟನು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಮುಂದೆ ಬಲಿಪೀಠ ಇಟ್ಟು ಅದರ ಮೇಲೆ ದಹನಬಲಿ ಮತ್ತು ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೂ, ಬಲಿಪೀಠಕ್ಕೂ ಮಧ್ಯ ಗಂಗಾಳವನ್ನು ಇಟ್ಟು, ಅದರಲ್ಲಿ ತೊಳೆಯುವುದಕ್ಕೆ ನೀರನ್ನು ತುಂಬಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ಮೋಶೆಯೂ, ಆರೋನನೂ, ಅವನ ಪುತ್ರರೂ ಅದರಲ್ಲಿ ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಒಳಗೆ ಸೇರುವ ಸಮಯದಲ್ಲಿಯೂ, ಬಲಿಪೀಠದ ಸಮೀಪಕ್ಕೆ ಬರುವ ಸಮಯದಲ್ಲಿಯೂ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆಯೇ ಅವರು ಸ್ನಾನ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ಮೋಶೆಯು ಗುಡಾರಕ್ಕೂ, ಬಲಿಪೀಠಕ್ಕೂ ಸುತ್ತಲೂ ಅಂಗಳವನ್ನು ನಿಲ್ಲಿಸಿ, ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆಯನ್ನು ತೂಗುಹಾಕಿದನು. ಈ ಪ್ರಕಾರ ಮೋಶೆಯು ಆ ಕೆಲಸವನ್ನು ತೀರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ಆಗ ಮೇಘವು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಮುಚ್ಚಿಕೊಂಡು, ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ತುಂಬಿಕೊಂಡಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ದೇವದರ್ಶನದ ಗುಡಾರದ ಮೇಲೆ ಮೇಘವು ನೆಲೆಯಾಗಿದ್ದದರಿಂದಲೂ, ಯೆಹೋವ ದೇವರು ಮಹಿಮೆಯು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ತುಂಬಿದ್ದರಿಂದಲೂ, ಮೋಶೆಯು ಒಳಗೆ ಪ್ರವೇಶಿಸಲಾರದೆ ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ಮೇಘವು ಗುಡಾರವನ್ನು ಬಿಟ್ಟು ಮೇಲಕ್ಕೆ ಹೋದಾಗ, ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಪ್ರಯಾಣಕ್ಕಾಗಿ ಮುಂದೆ ಹೊರಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ಆದರೆ ಮೇಘವು ಮೇಲಕ್ಕೆ ಎತ್ತದೇ ಇರುವಾಗ ಅದು ಎತ್ತುವ ದಿವಸದವರೆಗೆ ಅವರು ಪ್ರಯಾಣ ಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ಏಕೆಂದರೆ ಇಸ್ರಾಯೇಲರ ಎಲ್ಲಾ ಪ್ರಯಾಣಗಳಲ್ಲಿ ಅವರ ಕಣ್ಣುಗಳ ಮುಂದೆ ಹಗಲಿನಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಮೇಘವು ಗುಡಾರದ ಮೇಲೆ ಇತ್ತು. ರಾತ್ರಿಯಲ್ಲಿ ಮೇಘದೊಳಗೆ ಅಗ್ನಿಯು ಪ್ರಕಾಶಿಸುತ್ತಿತ್ತು.");
INSERT INTO kanokcv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯನ್ನು ಕರೆದು, ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗಿಂದ ಅವನೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕಾದದ್ದೇನಂದರೆ: “ ‘ನಿಮ್ಮಲ್ಲಿ ಯಾರಾದರೂ ಯೆಹೋವ ದೇವರಿಗೆ ಒಂದು ಪ್ರಾಣಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಸಮರ್ಪಿಸಲು ಆಶಿಸಿದರೆ, ಅದನ್ನು ದನಕರುಗಳಿಂದಾಗಲಿ, ಆಡು ಕುರಿಗಳಿಂದಾಗಲಿ ಆಯ್ದುಕೊಂಡು ಸಮರ್ಪಿಸಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘ಅಂಥವನು ದನಕರುಗಳನ್ನು ದಹನಬಲಿಯನ್ನಾಗಿ ಸಮರ್ಪಿಸುವುದಾದರೆ, ಆ ಪ್ರಾಣಿ ಕಳಂಕರಹಿತವಾದ ಗಂಡಾಗಿರಬೇಕು. ಯೆಹೋವ ದೇವರಿಗೆ ಒಪ್ಪಿಗೆಯಾಗುವಂತೆ ಅದನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ದಹನಬಲಿ ಅರ್ಪಿಸುವವನು ತನ್ನ ಕೈಯನ್ನು ಆ ಪ್ರಾಣಿಯ ತಲೆಯ ಮೇಲೆ ಇಡಬೇಕು. ಹೀಗೆ ಅದು ಅವನಿಗೋಸ್ಕರ ಅವನ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಅಂಗೀಕಾರವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ಅವನು ಆ ಹೋರಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ವಧಿಸಬೇಕು. ಆಗ ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರು ರಕ್ತವನ್ನು ತಂದು, ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿರುವ ಬಲಿಪೀಠದ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ಅವನು ಆ ದಹನಬಲಿಯ ಚರ್ಮವನ್ನು ಸುಲಿದು, ಅದರ ದೇಹವನ್ನು ಕಡಿದು, ತುಂಡುತುಂಡಾಗಿ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ಯಾಜಕನಾದ ಆರೋನನ ಪುತ್ರರು ಬಲಿಪೀಠದ ಮೇಲೆ ಕ್ರಮವಾಗಿ ಕಟ್ಟಿಗೆಯನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ಆಗ ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರು ಅದರ ಭಾಗಗಳನ್ನು ಅಂದರೆ, ತಲೆಯನ್ನೂ ಮತ್ತು ಕೊಬ್ಬನ್ನೂ ಬಲಿಪೀಠದ ಮೇಲೆ ಬೆಂಕಿಯ ಮೇಲಿರುವ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ಕ್ರಮವಾಗಿ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ಅದರ ಕರುಳುಗಳನ್ನೂ, ಕಾಲುಗಳನ್ನೂ ಅವರು ನೀರಿನಲ್ಲಿ ತೊಳೆಯಬೇಕು. ಯಾಜಕನು ಎಲ್ಲವನ್ನೂ ಬಲಿಪೀಠದ ಮೇಲೆ ಬೆಂಕಿಯಿಂದ ಸಮರ್ಪಿಸುವ ದಹನಬಲಿಯಂತೆಯೂ, ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾಗುವಂತೆಯೂ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘ದಹನಬಲಿಗೋಸ್ಕರ ತನ್ನ ಕಾಣಿಕೆಯು ಮಂದೆಯಿಂದ ತರುವುದಾದರೆ ಅವನು ಕುರಿಗಳಲ್ಲಾಗಲಿ, ಮೇಕೆಗಳಲ್ಲಾಗಲಿ, ಕಳಂಕರಹಿತ ಒಂದು ಗಂಡನ್ನು ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ಅವನು ಅದನ್ನು ಬಲಿಪೀಠದ ಉತ್ತರದ ಕಡೆಯಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ವಧಿಸಬೇಕು. ಇದಲ್ಲದೆ ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರು ಅದರ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ಅರ್ಪಿಸುವವನು ಆ ಪ್ರಾಣಿಯ ದೇಹವನ್ನು ತುಂಡುತುಂಡಾಗಿ ಕಡಿದ ಮೇಲೆ, ಯಾಜಕನು ಆ ತುಂಡುಗಳನ್ನೂ, ತಲೆಯನ್ನೂ, ಕೊಬ್ಬನ್ನೂ ಬಲಿಪೀಠದ ಮೇಲಿನ ಬೆಂಕಿಯಲ್ಲಿ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ಕ್ರಮವಾಗಿ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ಕರುಳುಗಳನ್ನೂ ಕಾಲುಗಳನ್ನೂ ನೀರಿನಿಂದ ತೊಳೆಯಬೇಕು. ಆಗ ಯಾಜಕನು ಅವೆಲ್ಲವುಗಳನ್ನೂ ತಂದು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ಬೆಂಕಿಯಿಂದ ಸಮರ್ಪಿಸುವ ದಹನಬಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾಗುವಂತೆಯೂ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಯಾಗಿ ಸಮರ್ಪಿಸುವಂಥದ್ದು ಪಕ್ಷಿಗಳಾಗಿದ್ದರೆ, ಅವನು ತನ್ನ ಯಜ್ಞಕ್ಕಾಗಿ ಬೆಳವಕ್ಕಿಯನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಪಾರಿವಾಳದ ಮರಿಯನ್ನಾಗಲಿ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ಆಗ ಯಾಜಕನು ಅದನ್ನೂ ಬಲಿಪೀಠದ ಬಳಿಗೆ ತಂದು ಅದರ ತಲೆಯನ್ನು ಮುರಿದು, ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ಅದರ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಹೊರಬದಿಯಲ್ಲಿ ಹಿಂಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ಇದಲ್ಲದೆ ಅವನು ಅದರ ರೆಕ್ಕೆ ಪುಕ್ಕಗಳೊಂದಿಗೆ ಕರುಳುಗಳನ್ನೂ ಕಿತ್ತು, ಬಲಿಪೀಠದ ಬಳಿ ಪೂರ್ವ ಭಾಗದಲ್ಲಿ ಬೂದಿಯಿರುವ ಸ್ಥಳದಲ್ಲಿ ಬಿಸಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ಅವನು ಅದನ್ನು ರೆಕ್ಕೆಗಳೊಂದಿಗೆ ಹರಿಯಬೇಕು. ಆದರೆ ಬೇರೆಬೇರೆಯಾಗಿ ವಿಭಾಗಿಸಬಾರದು. ಆಗ ಯಾಜಕನು ಅದನ್ನು ಬಲಿಪೀಠದ ಬೆಂಕಿಯ ಮೇಲಿರುವ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ಸಮರ್ಪಿಸುವ ದಹನಬಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾಗುವಂತೆ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘ಯಾರಾದರೂ ಯೆಹೋವ ದೇವರಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನು ಸಮರ್ಪಿಸುವುದಾದರೆ ಅವನ ಸಮರ್ಪಣೆಯು ನಯವಾದ ಹಿಟ್ಟಿನದ್ದಾಗಿರಬೇಕು. ಅವನು ಅದರ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಸುರಿಸಬೇಕು, ಅದರ ಮೇಲೆ ಸಾಂಬ್ರಾಣಿಯನ್ನು ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ಇದಲ್ಲದೆ ಅವನು ಅದನ್ನು ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರ ಬಳಿಗೆ ತರಬೇಕು. ಅವನು ಹಿಟ್ಟಿನಲ್ಲಿಯೂ, ಎಣ್ಣೆಯಲ್ಲಿಯೂ ಒಂದು ಹಿಡಿಯನ್ನು ಅದರ ಎಲ್ಲಾ ಸಾಂಬ್ರಾಣಿಯ ಸಂಗಡ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಯಾಜಕನು ಅದನ್ನು ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಬಲಿಪೀಠದ ಮೇಲೆ ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯ ಸಮರ್ಪಣೆಯಾಗಿ ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ಧಾನ್ಯ ಸಮರ್ಪಣೆಯಲ್ಲಿ ಉಳಿದದ್ದನ್ನು ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅದು ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ್ದಾಗಿದ್ದು ಯೆಹೋವ ದೇವರ ಸಮರ್ಪಣೆಗಳಲ್ಲಿ ಮಹಾಪರಿಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘ನೀನು ಒಲೆಯಲ್ಲಿ ಸುಟ್ಟ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ತರುವುದಾದರೆ, ಅದು ಹುಳಿಯಿಲ್ಲದ ಮತ್ತು ಎಣ್ಣೆಯಿಂದ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನ ರೊಟ್ಟಿಗಳು ಇಲ್ಲವೆ ಹುಳಿಯಿಲ್ಲದ ಎಣ್ಣೆ ಹೊಯ್ದ ದೋಸೆಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ನಿನ್ನ ಕಾಣಿಕೆಯು ಬೋಗುಣಿಯಲ್ಲಿ ಬೇಯಿಸಿದ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯಾಗಿದ್ದರೆ, ಅದು ಹುಳಿಯಿಲ್ಲದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ಎಣ್ಣೆ ಮಿಶ್ರಿತವಾದದ್ದು ಆಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ನೀನು ಅದನ್ನು ತುಂಡುಗಳನ್ನಾಗಿ ವಿಭಾಗಿಸಿ, ಅದರ ಮೇಲೆ ಎಣ್ಣೆ ಸುರಿಯಬೇಕು, ಅದು ಆಹಾರ ಸಮರ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ನಿನ್ನ ಕಾಣಿಕೆಯು ತವೆಯಲ್ಲಿ ಬೇಯಿಸಿದ ಧಾನ್ಯವಾಗಿದ್ದರೆ, ಅದು ನಯವಾದ ಎಣ್ಣೆಯಿಂದ ಕೂಡಿದ ಹಿಟ್ಟಿನಿಂದ ಮಾಡಿದ್ದಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ನೀನು ಇವುಗಳಿಂದ ಮಾಡಿದ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ತರಬೇಕು. ಅದು ಯಾಜಕನಿಗೆ ಒಪ್ಪಿಸಿದಾಗ, ಅವನು ಅದನ್ನು ಬಲಿಪೀಠದ ಬಳಿಗೆ ತರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ಆಗ ಯಾಜಕನು ಅದರಿಂದ ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನಾಗಿ ತೆಗೆದುಕೊಂಡು ಅದನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ಅದು ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ್ದಾಗಿದ್ದು, ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯ ಸಮರ್ಪಣೆಯಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ಧಾನ್ಯ ಸಮರ್ಪಣೆಯಲ್ಲಿ ಉಳಿದದ್ದನ್ನು ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅದು ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ್ದಾಗಿದ್ದು ಯೆಹೋವ ದೇವರ ಸಮರ್ಪಣೆಗಳಲ್ಲಿ ಮಹಾಪರಿಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘ಯೆಹೋವ ದೇವರಿಗೆ ನೀನು ತರುವ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯು ಯಾವುದೂ ಹುಳಿಯಿಂದ ಮಾಡಿದ್ದಾಗಿರಬಾರದು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರಿಗೆ ನೀವು ಬೆಂಕಿಯಿಂದ ಮಾಡುವ ಯಾವ ಸಮರ್ಪಣೆಯಲ್ಲಿ ಹುಳಿಯನ್ನಾಗಲಿ, ಜೇನನ್ನಾಗಲಿ ಬೆರೆಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ಪ್ರಥಮ ಫಲದ ಕಾಣಿಕೆಯ ವಿಷಯದಲ್ಲಿಯಾದರೋ ನೀವು ಅವುಗಳನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ಆದರೆ ಅವುಗಳನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುವಾಸನೆಗಾಗಿ ಸುಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ನಿನ್ನ ಪ್ರತಿಯೊಂದು ಧಾನ್ಯ ಸಮರ್ಪಣೆಯೂ ಉಪ್ಪಿನಲ್ಲಿ ಬೆರಕೆಯಾಗಿರಬೇಕು. ನಿನ್ನ ದೇವರ ಒಡಂಬಡಿಕೆಯ ಉಪ್ಪು ನಿನ್ನ ಸಮರ್ಪಣೆಯಲ್ಲಿ ಇಲ್ಲದೆ ಇರಬಾರದು. ನಿನ್ನ ಎಲ್ಲಾ ಸಮರ್ಪಣೆಗಳಲ್ಲಿ ನೀನು ಉಪ್ಪನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘ನೀನು ನಿನ್ನ ಪ್ರಥಮ ಫಲಗಳ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಮಾಡಿದರೆ, ನಿನ್ನ ಪ್ರಥಮ ಫಲ ಧಾನ್ಯ ಕಾಣಿಕೆಯನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟ ಕಾಳಿನ ಹಸಿರು ತೆನೆಗಳನ್ನೂ ಅಲ್ಲದೆ ತುಂಬಿದ ತೆನೆಗಳಿಂದ ಬಡಿದ ಒಣಗಿದ ಕಾಳುಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ನೀನು ಅದರ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಸಾಂಬ್ರಾಣಿಯನ್ನು ಹಾಕು. ಇದೇ ಧಾನ್ಯ ಸಮರ್ಪಣೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ಯಾಜಕನು ಬಡಿದ ಕಾಳುಗಳಲ್ಲಿ ಕೆಲವು ಭಾಗವನ್ನು ಅದರ ಜೊತೆಯಲ್ಲಿ ಎಲ್ಲಾ ಸಾಂಬ್ರಾಣಿಯನ್ನು ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಸುಡಬೇಕು. ಇದು ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಸಮರ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘ಯಾರಾದರು ಸಮಾಧಾನ ಸಮರ್ಪಣೆಗಾಗಿ ಬಲಿದಾನ ಮಾಡಬೇಕಾದರೆ, ಅಂಥವನು ಸಮರ್ಪಿಸುವ ಪ್ರಾಣಿ ದನಕರುವಾಗಿದ್ದಲ್ಲಿ, ಅದು ಗಂಡಾಗಿರಲಿ ಅಥವಾ ಹೆಣ್ಣಾಗಿರಲಿ ಯೆಹೋವ ದೇವರ ದೃಷ್ಟಿಯಲ್ಲಿ ಕಳಂಕರಹಿತವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ಅವನು ಅರ್ಪಿಸಬೇಕಾದ ಆ ಪ್ರಾಣಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಗೆ ತಂದು ಅದರ ತಲೆಯ ಮೇಲೆ ಕೈ ಇಡಬೇಕು. ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ವಧಿಸಬೇಕು. ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರು ಅದರ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ಅವನು ಸಮಾಧಾನದ ಕಾಣಿಕೆಯ ಯಜ್ಞಾರ್ಪಣೆಯನ್ನು ಅಂದರೆ ಕರುಳುಗಳನ್ನು ಮುಚ್ಚುವ ಕೊಬ್ಬನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ಎರಡು ಮೂತ್ರ ಜನಕಾಂಗಗಳನ್ನೂ, ಪಕ್ಕೆಯ ಬದಿಯಲ್ಲಿಯ ಅವುಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ, ಮೂತ್ರ ಜನಕಾಂಗಗಳ ಮೇಲಿರುವ ಪೊರೆಯನ್ನೂ ಮೂತ್ರಜನಕಾಂಗಗಳೊಂದಿಗೆ ಅದನ್ನು ತೆಗೆದುಕೊಂಡು ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಕಾಣಿಕೆಯಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ಆರೋನನ ಪುತ್ರರು ಅದನ್ನು ಬಲಿಪೀಠದಲ್ಲಿ ಬೆಂಕಿಯ ಮೇಲಿರುವ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ದಹನಬಲಿಯಾಗಿ ಸುಡಬೇಕು. ಅದು ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಕಾಣಿಕೆಯಾಗಿದ್ದು, ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘ಅವನ ಕಾಣಿಕೆಯು ಸಮಾಧಾನದ ಬಲಿಯಾಗಿ, ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ತನ್ನ ಆಡುಕುರಿಗಳಿಂದಾದ ಕಾಣಿಕೆಯಾಗಿದ್ದರೆ, ಗಂಡಾಗಲಿ, ಹೆಣ್ಣಾಗಲಿ ಕಳಂಕರಹಿತವಾದದ್ದನ್ನು ಅವನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ಅವನು ಕುರಿಮರಿಯನ್ನು ಅರ್ಪಣೆಗೋಸ್ಕರ ಅರ್ಪಿಸುವುದಾದರೆ, ಅದನ್ನು ಅವನು ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ಅವನು ತನ್ನ ಅರ್ಪಣೆಯ ತಲೆಯ ಮೇಲೆ ತನ್ನ ಕೈಯನ್ನು ಇಟ್ಟು, ಅದನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಎದುರಿನಲ್ಲಿ ವಧಿಸಬೇಕು. ಇದಲ್ಲದೆ ಆರೋನನ ಪುತ್ರರು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುತ್ತಲೂ ರಕ್ತವನ್ನು ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಅದರ ಇಡೀ ಹಿಂಭಾಗವನ್ನೂ, ಅದರ ಕೊಬ್ಬನ್ನೂ, ಅವನು ಬೆನ್ನೆಲುಬಿನಿಂದ ತೆಗೆದು ಕರುಳುಗಳನ್ನು ಮುಚ್ಚುವ ಕೊಬ್ಬನ್ನೂ, ಕರುಳುಗಳ ಮೇಲಿರುವ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ಎರಡು ಮೂತ್ರ ಜನಕಾಂಗಗಳನ್ನೂ, ಪಕ್ಕೆಯ ಬದಿಗಳಲ್ಲಿರುವವುಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ, ಕಾಳಿಜದ ಉತ್ತಮ ಭಾಗ, ಮೂತ್ರಜನಕಾಂಗಗಳೊಂದಿಗೆ ವಪೆಯ ಮೇಲಿರುವ ಪೊರೆಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಕಾಣಿಕೆಯಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ಯಾಜಕನು ಅದನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಸಮರ್ಪಣೆಯ ಆಹಾರವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘ಸಮರ್ಪಣೆಯು ಮೇಕೆಯಾಗಿದ್ದರೆ, ಅದನ್ನು ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ಅವನು ಅದರ ತಲೆಯ ಮೇಲೆ ತನ್ನ ಕೈಯನ್ನಿಟ್ಟು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮುಂದೆ ಅದನ್ನು ವಧಿಸಬೇಕು. ಆಗ ಆರೋನನ ಪುತ್ರರು ಅದರ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ಕರುಳುಗಳನ್ನು ಮುಚ್ಚುವ ಕೊಬ್ಬನ್ನೂ, ಕರುಳುಗಳ ಮೇಲಿರುವ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ಎರಡು ಮೂತ್ರ ಜನಕಾಂಗಗಳನ್ನೂ ಪಕ್ಕೆಯ ಬದಿಗಳಲ್ಲಿರುವವುಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಕಾಳಿಜದ ಉತ್ತಮ ಭಾಗ, ಮೂತ್ರಜನಕಾಂಗಗಳೊಂದಿಗೆ ವಪೆಯ ಮೇಲಿರುವ ಪೊರೆಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಕಾಣಿಕೆಯಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ಯಾಜಕನು ಅವುಗಳನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ಅದು ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಸುವಾಸನೆಯ ಯಜ್ಞಾರ್ಪಣೆಯ ಆಹಾರವಾಗಿರುವುದು. ಎಲ್ಲಾ ಕೊಬ್ಬು ಯೆಹೋವ ದೇವರದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘ನೀವು ಕೊಬ್ಬನ್ನಾಗಲಿ, ರಕ್ತವನ್ನಾಗಲಿ ತಿನ್ನದೆ ಇರುವುದು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆಲ್ಲಾ ನಿಮ್ಮ ಎಲ್ಲಾ ನಿವಾಸಗಳಲ್ಲಿ ನಿರಂತರವಾದ ಕಟ್ಟಳೆಯಾಗಿರುವುದು,’ ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ‘ಯಾರಾದರೂ ಉದ್ದೇಶವಿಲ್ಲದೆ ಪಾಪಮಾಡಿದರೆ ಹಾಗೂ ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಗಳಲ್ಲಿ ನಿಷೇಧಿಸಿದ ಯಾವುದನ್ನಾದರೂ ಮಾಡಿದರೆ, ಅವರು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಈ ಕ್ರಮಗಳನ್ನು ಕೈಗೊಳ್ಳಬೇಕು: ");
INSERT INTO kanokcv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘ಅಭಿಷಿಕ್ತನಾದ ಯಾಜಕನು ಪಾಪಮಾಡಿ ಜನರ ಮೇಲೆ ಅಪರಾಧವನ್ನು ತಂದರೆ, ತಾನು ಮಾಡಿದ ಪಾಪಕ್ಕಾಗಿ ಕಳಂಕರಹಿತವಾದ ಒಂದು ಎಳೆಯ ಹೋರಿಯನ್ನು ದೋಷಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ಅವನು ಆ ಹೋರಿಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಎದುರಿಗೆ ತರಬೇಕು. ತನ್ನ ಕೈಯನ್ನು ಆ ಹೋರಿಯ ತಲೆಯ ಮೇಲಿಟ್ಟು, ಆ ಹೋರಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ಆಗ ಅಭಿಷಿಕ್ತನಾದ ಯಾಜಕನು ಆ ಹೋರಿಯ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ಯಾಜಕನು ತನ್ನ ಬೆರಳನ್ನು ರಕ್ತದಲ್ಲಿ ಅದ್ದಿ, ಯೆಹೋವ ದೇವರ ಮುಂದಿನ ಪವಿತ್ರ ಸ್ಥಳದ ತೆರೆಯ ಮುಂದೆ ರಕ್ತವನ್ನು ಏಳು ಸಾರಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ಯಾಜಕನು ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗಿರುವ ಸುವಾಸನೆಯುಳ್ಳ ಧೂಪವನ್ನು ಬಲಿಪೀಠದ ಕೊಂಬುಗಳಿಗೆ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಹಚ್ಚಬೇಕು. ಅಲ್ಲದೆ ಆ ಹೋರಿಯ ಎಲ್ಲಾ ರಕವನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿರುವ ದಹನಬಲಿಯ ಪೀಠದ ಅಡಿಯಲ್ಲಿ ಸುರಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ಅವನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿರುವ ಹೋರಿಯ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನು ಅದರಿಂದ ತೆಗೆಯಬೇಕು. ಕರುಳುಗಳನ್ನು ಮುಚ್ಚುವ ಕೊಬ್ಬನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನು ಪಕ್ಕೆಯ ಬದಿಯಲ್ಲಿರುವ ಕೊಬ್ಬನ್ನೂ, ಮೂತ್ರಪಿಂಡದೊಂದಿಗೂ ಕಾಳಿಜದ ಉತ್ತಮ ಭಾಗವನ್ನೂ ಅವನು ತೆಗೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ಸಮಾಧಾನದ ಬಲಿಯನ್ನು ಹೋರಿಯಿಂದ ತೆಗೆದಂತೆಯೇ ತೆಗೆಯಬೇಕು. ಯಾಜಕನು ದಹನಬಲಿಯ ಪೀಠದ ಮೇಲೆ ಅವುಗಳನ್ನು ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ಆ ಹೋರಿಯ ಚರ್ಮವನ್ನು, ಅದರ ಎಲ್ಲಾ ಮಾಂಸವನ್ನು, ಅದರ ತಲೆ, ಅದರ ಕಾಲುಗಳು, ಅದರ ಕರುಳುಗಳು, ಅದರ ಸಗಣಿಯೊಂದಿಗೆ ");
INSERT INTO kanokcv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ಎಂದರೆ ಇಡೀ ಹೋರಿಯನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಶುದ್ಧವಾದ ಸ್ಥಳಕ್ಕೆ ಅಂದರೆ ಬೂದಿ ಚೆಲ್ಲುವ ಸ್ಥಳಕ್ಕೆ ತಂದು, ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ಬೆಂಕಿಯಿಂದ ಅದನ್ನು ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘ಮಾಡಬಾರದ ಕೆಲಸಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಗಳಿಗೆ ವಿರೋಧವಾಗಿ ಯಾವುದನ್ನಾದರೂ ಇಸ್ರಾಯೇಲರು ಅರಿಯದೆ ಮಾಡಿ ಅಪರಾಧಿಗಳಾಗಿದ್ದರೆ ಮತ್ತು ಅದು ಸಮೂಹಕ್ಕೆ ಕಣ್ಮರೆಯಾಗಿದ್ದರೆ ");
INSERT INTO kanokcv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ಅವರು ಮಾಡಿದ ಪಾಪವು ಗೊತ್ತಾದಾಗ, ಆ ಪಾಪಕ್ಕಾಗಿ ಸಮಾಜವು ಒಂದು ಎಳೆಯ ಹೋರಿಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮುಂದೆ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ಸಮಾಜದ ಹಿರಿಯರು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಆ ಹೋರಿಯ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನಿಡಬೇಕು. ಆ ಹೋರಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ಅಭಿಷಿಕ್ತನಾದ ಯಾಜಕನು ಆ ಹೋರಿಯ ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ತಂದು, ");
INSERT INTO kanokcv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ಅದರಲ್ಲಿ ಬೆರಳನ್ನು ಅದ್ದಿ ಅದನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಅಂದರೆ ತೆರೆಯ ಮುಂದೆ ಏಳು ಸಾರಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ಇದಲ್ಲದೆ ಅವನು ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗಿರುವ ಬಲಿಪೀಠದ ಕೊಂಬುಗಳಿಗೆ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಹಚ್ಚಿ, ಉಳಿದ ಎಲ್ಲಾ ರಕ್ತವನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗಿರುವ ದಹನಬಲಿಯ ಪೀಠದ ಅಡಿಯಲ್ಲಿ ಸುರಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ಅವನು ಅದರ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಇರುವ ಆ ಹೋರಿಗೆ ಮಾಡಿದಂತೆಯೇ, ಈ ಹೋರಿಗೂ ಮಾಡಬೇಕು. ಇದಲ್ಲದೆ ಯಾಜಕನು ಅವರಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು, ಆಗ ಅವರಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ಅವನು ಮೊದಲನೆಯ ಹೋರಿಯನ್ನು ಸುಟ್ಟಂತೆಯೇ, ಈ ಹೋರಿಯನ್ನು ಪಾಳೆಯದ ಆಚೆಗೆ ತೆಗೆದುಕೊಂಡುಹೋಗಿ ಸುಡಬೇಕು. ಅದು ಸಮಾಜಕ್ಕೆ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘ಒಬ್ಬ ಅಧಿಪತಿಯು ದೇವರಾದ ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಗಳಿಗೆ ವಿರೋಧವಾಗಿ ತಿಳಿಯದೆ ಪಾಪಮಾಡಿ ಅಪರಾಧಿಯಾಗಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ಇಲ್ಲವೆ ಅವನು ಮಾಡಿದ ಆ ಪಾಪವು ಅವನಿಗೆ ತಿಳಿದುಬಂದರೆ, ಅವನು ಬಲಿಗಾಗಿ ಹೋತಗಳಲ್ಲಿ ಕಳಂಕರಹಿತವಾದ ಒಂದು ಹೋತವನ್ನು ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ಅವನು ತನ್ನ ಕೈಯನ್ನು ಆ ಹೋತದ ತಲೆಯ ಮೇಲೆ ಇಟ್ಟು, ಯೆಹೋವ ದೇವರ ಮುಂದೆ ದಹನಬಲಿಯನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಅದನ್ನು ವಧಿಸಬೇಕು. ಅದು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ಯಾಜಕನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ರಕ್ತವನ್ನು ತನ್ನ ಬೆರಳಿನಿಂದ ತೆಗೆದುಕೊಂಡು, ದಹನಬಲಿಯ ಪೀಠದ ಮೇಲೆ ಅಡಿಯಲ್ಲಿ ಹೊಯ್ಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ಅವರು ಸಮಾಧಾನದ ಕೊಬ್ಬಿನಂತೆಯೇ ಅದರ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ಯಾಜಕನು ಅವನ ಪಾಪದ ವಿಷಯದಲ್ಲಿ ಅವನಿಗೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಆಗ ಅವನಿಗೆ ಕ್ಷಮೆ ದೊರಕುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘ಸಾಮಾನ್ಯ ಜನರಲ್ಲಿ ಯಾವನಾದರೂ ಮಾಡಬಾರದವುಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಗಳಿಗೆ ವಿರೋಧವಾಗಿ ತಿಳಿಯದೆ ಪಾಪಮಾಡಿ ಅಪರಾಧಿಯಾಗಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ಇಲ್ಲವೆ ಅವರು ಮಾಡಿದ ಪಾಪವು ಅವರಿಗೆ ತಿಳಿದುಬಂದರೆ, ಅವರು ಪಾಪ ಪರಿಹಾರಕ್ಕಾಗಿ ಕಳಂಕರಹಿತವಾದ ಒಂದು ಹೆಣ್ಣು ಮೇಕೆಯನ್ನು ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ಅವರು ತಮ್ಮ ಕೈಯನ್ನು ಪಾಪದ ಬಲಿಯ ಮೇಲಿಟ್ಟು, ಆ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯನ್ನು ದಹನಬಲಿಯ ಸ್ಥಳದಲ್ಲಿ ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ಆಗ ಯಾಜಕನು ತನ್ನ ಬೆರಳಿನಿಂದ ಅದರ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು, ದಹನಬಲಿಯ ಪೀಠದ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ, ಉಳಿದ ಎಲ್ಲಾ ರಕ್ತವನ್ನು ಆ ಬಲಿಪೀಠದ ಅಡಿಯಲ್ಲಿ ಸುರಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ಅವನು ಸಮಾಧಾನ ಬಲಿಯ ಕೊಬ್ಬನ್ನು ತೆಗೆದಂತೆ, ಅದರ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನು ತೆಗೆಯಬೇಕು. ಯಾಜಕನು ಅದನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾಗಿ ಸುಡಬೇಕು. ಇದಲ್ಲದೆ ಯಾಜಕನು ಅವನಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು, ಆಗ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘ಯಾರಾದರೂ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಒಂದು ಕುರಿಮರಿಯನ್ನು ತರುವುದಾದರೆ, ಕಳಂಕರಹಿತವಾದ ಒಂದು ಹೆಣ್ಣನ್ನು ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ಅವರು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಯನ್ನು ಇಟ್ಟು, ದೋಷಪರಿಹಾರ ಬಲಿಯಾಗಿ ದಹನಬಲಿಯನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲಿ ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ಯಾಜಕನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ರಕ್ತವನ್ನು ತನ್ನ ಬೆರಳಿನಿಂದ ತೆಗೆದುಕೊಂಡು, ದಹನಬಲಿಯ ಪೀಠದ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಬೇಕು. ಉಳಿದ ಎಲ್ಲಾ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಅಡಿಯಲ್ಲಿ ಹೊಯ್ಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ಇದಲ್ಲದೆ ಸಮಾಧಾನ ಬಲಿಗಳ ಕುರಿಮರಿಯ ಕೊಬ್ಬಿನಂತೆಯೇ, ಅದರ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ ತೆಗೆಯಬೇಕು. ಯಾಜಕನು ಬೆಂಕಿಯ ಸಮರ್ಪಣೆಗಳನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಮಾಡಿದಂತೆಯೇ, ಬಲಿಪೀಠದ ಮೇಲೆ ಅವುಗಳನ್ನು ಸುಡಬೇಕು. ಯಾಜಕನು ಅವನು ಮಾಡಿದ ಪಾಪಕ್ಕೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು, ಆಗ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘ಯಾವನಾದರೂ ಆಣೆ ಇಡುವುದನ್ನು ಕೇಳಿ, ಸಾಕ್ಷಿಯಾಗಿದ್ದು, ಪಾಪಮಾಡಿದರೆ, ಅವನು ಅದನ್ನು ಕಂಡೂ ಇಲ್ಲವೆ ತಿಳಿದೂ ಅವನು ಅದನ್ನು ಹೇಳದಿದ್ದರೆ, ಅವನು ತನ್ನ ಅಪರಾಧವನ್ನು ಹೊತ್ತುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘ಇಲ್ಲವೆ, ಯಾವನಿಗಾದರೂ ಅಶುದ್ಧವಾದ ಕಾಡುಮೃಗ, ಪಶು ಇವುಗಳ ಹೆಣವಾಗಲಿ, ಅಶುದ್ಧವಾದ ಹರಿದಾಡುವ ಕ್ರಿಮಿಗಳ ಹೆಣಗಳಾಗಲಿ ಅಥವಾ ಬೇರೆ ಯಾವ ಅಶುದ್ಧವಸ್ತುವಾಗಲಿ ತಗಲಿದರೆ ಅವನಿಗೆ ತಿಳಿಯದೆ ಇದ್ದರೂ ಅವನು ಅಶುದ್ಧವಾಗಿದ್ದು ಅಪರಾಧಿಯಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ಇಲ್ಲವೆ, ಅವನು ಮನುಷ್ಯನ ಅಶುದ್ಧತ್ವವನ್ನು ತಗಲಿದರೆ, ಮನುಷ್ಯನನ್ನು ಅಶುದ್ಧಪಡಿಸುವ ಯಾವುದೇ ಅಶುದ್ಧತ್ವವಾಗಿದ್ದರೂ ಅದು ಅವನಿಗೆ ತಿಳಿಯದೆ ಇದ್ದು, ತರುವಾಯ ಅದು ಅವನಿಗೆ ತಿಳಿದಾಗ, ಅವನು ಅಪರಾಧಿಯಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ಒಬ್ಬನು ಆಣೆಯಿಟ್ಟು ಕೆಟ್ಟದ್ದನ್ನಾಗಲಿ, ಒಳ್ಳೆಯದನ್ನಾಗಲಿ ಮಾಡುವುದನ್ನು ತನ್ನ ತುಟಿಗಳಿಂದ ಉಚ್ಛರಿಸಿದರೆ, ಒಬ್ಬ ಮನುಷ್ಯನು ಪ್ರಮಾಣದೊಡನೆ ಉಚ್ಚರಿಸಿದ್ದು ಯಾವುದೇ ಆಗಿರಲಿ, ಅದು ಅವನಿಗೆ ತಿಳಿಯದೆ ಇದ್ದು, ತರುವಾಯ ಅದು ಅವನಿಗೆ ತಿಳಿದಾಗ, ಇವುಗಳೊಂದರಲ್ಲಿ ಅವನು ಅಪರಾಧಿಯಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ಅವನು ಇವುಗಳೊಂದರಲ್ಲಿ ಅಪರಾಧಿಯಾಗಿದ್ದು, ತಾನು ಅದರಲ್ಲಿ ಪಾಪಮಾಡಿದ್ದೇನೆಂದು ಅರಿಕೆ ಮಾಡುವುದಾದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ಅವನು ತಾನು ಮಾಡಿದ ಪಾಪಕ್ಕಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಅಪರಾಧ ಬಲಿಯನ್ನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಮಂದೆಯಿಂದ ಒಂದು ಹೆಣ್ಣು ಕುರಿಯನ್ನಾಗಲಿ, ಒಂದು ಮೇಕೆಯನ್ನಾಗಲಿ ತರಬೇಕು. ಯಾಜಕನು ಅವನ ಪಾಪಕ್ಕಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘ಯಾರಾದರೂ ಒಂದು ಕುರಿಮರಿಯನ್ನು ತರುವುದಕ್ಕೆ ಅಶಕ್ತರಾಗಿದ್ದರೆ, ತಾವು ಮಾಡಿದ ಅಪರಾಧಕ್ಕಾಗಿ ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ, ಇಲ್ಲವೆ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ತರಬೇಕು. ಒಂದನ್ನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ, ಮತ್ತೊಂದನ್ನು ದಹನಬಲಿಗಾಗಿ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ಅವನು ಅವುಗಳನ್ನು ಯಾಜಕರ ಬಳಿಗೆ ತಂದಾಗ ಅವನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗೆ ತಂದಿರುವುದನ್ನು ಮೊದಲು ಸಮರ್ಪಿಸಿ, ಅದರ ತಲೆಯನ್ನು ಕುತ್ತಿಗೆಯಿಂದ ಮುರಿಯಬೇಕು. ಆದರೆ ಅದನ್ನು ವಿಭಾಗಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ಇದಲ್ಲದೆ, ಅವನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಬದಿಯಲ್ಲಿ ಚಿಮುಕಿಸಬೇಕು. ಉಳಿದ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಬದಿಯಲ್ಲಿ ಹಿಂಡಬೇಕು. ಅದು ದೋಷಪರಿಹಾರ ಬಲಿಯಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ಅವನು ಕ್ರಮದ ಪ್ರಕಾರ, ಎರಡನೆಯದನ್ನು ದಹನಬಲಿಯಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ಯಾಜಕನು ಅವನು ಮಾಡಿದ ಪಾಪಕ್ಕಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಆಗ ಅವನಿಗೆ ಕ್ಷಮೆ ದೊರಕುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘ಆದರೆ ಅವರು ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ, ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತರುವುದಕ್ಕೆ ಅಶಕ್ತರಾಗಿದ್ದರೆ, ಪಾಪಮಾಡಿದವರು ತಮ್ಮ ಬಲಿಗಾಗಿ, ಮೂರು ಸೇರು ಗೋಧಿ ಹಿಟ್ಟನ್ನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿ ತರಬೇಕು. ಅವರು ಅದರ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಇಲ್ಲವೆ ಸಾಂಬ್ರಾಣಿಯನ್ನು ಹಾಕಬಾರದು. ಏಕೆಂದರೆ ಅದು ದೋಷಪರಿಹಾರ ಬಲಿಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ತರುವಾಯ ಅವರು ಅದನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ಯಾಜಕನು ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಅದರಿಂದ ತನ್ನ ಹಿಡಿಯಷ್ಟು ತೆಗೆದುಕೊಂಡು, ಬಲಿಪೀಠದ ಮೇಲೆ ಬೆಂಕಿಯ ಅರ್ಪಣೆಗಳಿಗನುಸಾರವಾಗಿ ಯೆಹೋವ ದೇವರಿಗಾಗಿ ಸುಡಬೇಕು. ಅದು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ಇವುಗಳಲ್ಲಿ ಒಂದನ್ನು ಪಾಪದ ವಿಷಯವಾಗಿ ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಆಗ ಅದು ಅವನಿಗೆ ಕ್ಷಮಿಸಲಾಗುವುದು. ಉಳಿದದ್ದು ಯಾಜಕನಿಗಾಗಿ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯಾಗಿರುವುದು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ಯಾರಾದರೂ ಅತಿಕ್ರಮಿಸಿದ್ದರೆ ಮತ್ತು ಯೆಹೋವ ದೇವರ ಪರಿಶುದ್ಧ ಸಂಗತಿಗಳನ್ನು ಅರಿಯದೆ ಪಾಪಮಾಡಿದ್ದರೆ, ಅವರು ತಮ್ಮ ಅತಿಕ್ರಮಕ್ಕಾಗಿ ತಮ್ಮ ಹಿಂಡುಗಳಿಂದ ಕಳಂಕರಹಿತವಾದ ಟಗರನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಪವಿತ್ರ ಸ್ಥಳಕ್ಕೆ ನೇಮಕವಾದ ಎರಡು ಬೆಳ್ಳಿನಾಣ್ಯ ಅಥವಾ ಹೆಚ್ಚು ಬೆಲೆಬಾಳುವ ಟಗರನ್ನು ಹಿಂಡಿನಿಂದ ತಂದು ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಗಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ಪರಿಶುದ್ಧವಾದದ್ದಲ್ಲದೆ, ತಾನು ಅನ್ಯಾಯವಾಗಿ ಇಟ್ಟುಕೊಂಡಿರುವ ದೇವರ ವಸ್ತುಗಳನ್ನು ಅದಕ್ಕೆ ಐದನೆಯ ಪಾಲನ್ನು ಕೂಡಿಸಿ, ಅದನ್ನು ಯಾಜಕನಿಗೆ ಕೊಡಬೇಕು. ಅವನು ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ತಂದ ಟಗರಿನಿಂದ ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡಿದಾಗ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ಯಾರಾದರೂ ಯೆಹೋವ ದೇವರು ನಿಷೇಧಿಸಿದ ಆಜ್ಞೆಗಳಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ಮಾಡಿ, ಪಾಪಮಾಡಿದರೆ, ಅದು ಅವರಿಗೆ ತಿಳಿಯದಿದ್ದರೂ ಅವರು ಅಪರಾಧಿಯಾಗಿರುವರು ಮತ್ತು ಅವರು ತಮ್ಮ ಅಪರಾಧವನ್ನು ಹೊತ್ತುಕೊಳ್ಳುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ಅಲ್ಲದೆ ಅವನು ಹಿಂಡಿನೊಳಗಿಂದ ಕಳಂಕರಹಿತವಾದ ಒಂದು ಟಗರನ್ನು ನಿನ್ನ ಅಂದಾಜಿಗನುಸಾರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಗಾಗಿ, ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ಯಾಜಕನು, ಅಜ್ಞಾನದಿಂದ ಅವನು ಉದ್ದೇಶವಿಲ್ಲದೆ ಮಾಡಿದ ತಪ್ಪಿಗಾಗಿ, ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡಬೇಕು. ಅವನಿಗೆ ಕ್ಷಮೆ ದೊರಕುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ಅವನು ನಿಶ್ಚಯವಾಗಿ ಯೆಹೋವ ದೇವರ ವಿರುದ್ಧವಾಗಿ ಅಪರಾಧ ಮಾಡಿದ್ದಾನೆ, ಅದಕ್ಕಾಗಿ ಇದು ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯಾಗಿದೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಡನೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ಯಾರಾದರೂ ಪಾಪಮಾಡಿದರೆ ಮತ್ತು ನೆರೆಯವರಿಗೆ ಮೋಸ ಮಾಡುವ ಮೂಲಕ ಯೆಹೋವ ದೇವರಿಗೆ ವಿಶ್ವಾಸದ್ರೋಹಿ ಆಗಿದ್ದರೆ ಅಥವಾ ಅವರ ಆರೈಕೆಯಲ್ಲಿ ಏನಾದರೂ ಉಳಿಸಿಕೊಂಡಿದ್ದರೆ ಅಥವಾ ಯಾವುದನ್ನಾದರೂ ಕದ್ದುಕೊಂಡಿದ್ದರೆ ಅಥವಾ ಅವರು ತಮ್ಮ ನೆರೆಹೊರೆಯವರಿಗೆ ಮೋಸ ಮಾಡಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ಇಲ್ಲವೆ ಕಳೆದುಹೋಗಿದ ವಸ್ತು ಸಿಕ್ಕಿ, ಅದರ ವಿಷಯದಲ್ಲಿ ಸುಳ್ಳಾಡಿದ್ದರೆ ಮತ್ತು ಸುಳ್ಳಾಗಿ ಪ್ರಮಾಣ ಮಾಡಿದ್ದರೆ, ಇವೆಲ್ಲವುಗಳಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ಒಬ್ಬನು ಮಾಡಿದ್ದರೆ, ಅವನು ಪಾಪಮಾಡುವವನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ಅವನು ಪಾಪಮಾಡಿ, ಅಪರಾಧಿಯಾಗಿರುವುದರಿಂದ ಬಲಾತ್ಕಾರವಾಗಿ ಪಡೆದುಕೊಂಡದ್ದನ್ನೂ ಇಲ್ಲವೆ ಅವನು ಮೋಸದಿಂದ ಪಡೆದ ವಸ್ತುವನ್ನೂ ಇಲ್ಲವೆ ಅವನ ವಶಕ್ಕೆ ಸಿಕ್ಕಿದ ವಸ್ತುವನ್ನೂ ಹಿಂದಕ್ಕೆ ತಂದುಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ಅಥವಾ ಅವನು ಸುಳ್ಳಾಗಿ ಪ್ರಮಾಣಮಾಡಿ, ಪಡೆದವುಗಳೆಲ್ಲವುಗಳನ್ನೂ ಕೂಡಿಸಿ, ಹಿಂದಕ್ಕೆ ಕೊಡಬೇಕು. ಪ್ರಾಯಶ್ಚಿತ್ತದ ಬಲಿ ಅರ್ಪಿಸುವ ದಿನದಲ್ಲಿ, ಅದರ ಯಜಮಾನನು ಯಾವನಾಗಿರುವನೋ, ಅವನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ಅವನು ತನ್ನ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಕಳಂಕರಹಿತವಾದ ಒಂದು ಟಗರನ್ನು ಹಿಂಡಿನಿಂದ ತಂದು ಅದನ್ನು ಯೆಹೋವ ದೇವರಿಗೆಂದು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ಯಾಜಕನು ಅವನಿಗಾಗಿ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಬೇಕು. ಅತಿಕ್ರಮದಲ್ಲಿ ಅವನು ಏನನ್ನಾದರೂ ಮಾಡಿದ್ದರೆ, ಆ ವಿಷಯದಲ್ಲಿ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಆಜ್ಞಾಪಿಸಿ ಹೀಗೆ ಹೇಳು, ‘ಇದು ದಹನಬಲಿಯ ನಿಯಮವಾಗಿದೆ. ದಹನಬಲಿ ಇಡೀ ರಾತ್ರಿ, ಅಂದರೆ ಬೆಳಗಿನವರೆಗೆ ಬಲಿಪೀಠದ ಅಗ್ನಿಕುಂಡದ ಮೇಲೆ ಇರಬೇಕು. ಬಲಿಪೀಠದ ಬೆಂಕಿಯು ಅದರೊಳಗೆ ಸುಡುತ್ತಾ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ಯಾಜಕನು ತನ್ನ ನಾರುಮಡಿಯ ಉಡುಪನ್ನೂ ತನ್ನ ಶರೀರದ ಮೇಲೆ ನಾರುಮಡಿಯ ಒಳಉಡುಪುಗಳನ್ನೂ ಧರಿಸಿಕೊಂಡು, ಬಲಿಪೀಠದ ಮೇಲೆ ದಹನಬಲಿಯೊಂದಿಗೆ ಸುಟ್ಟ ಬೂದಿಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದನ್ನು ಬಲಿಪೀಠದ ಬಳಿಯಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ಆಮೇಲೆ ಅವನು ತನ್ನ ಉಡುಪುಗಳನ್ನು ತೆಗೆದುಹಾಕಿ, ಬೇರೆ ಉಡುಪುಗಳನ್ನು ಧರಿಸಿಕೊಂಡು, ಆ ಬೂದಿಯನ್ನು ಪಾಳೆಯದ ಆಚೆಗೆ ಶುದ್ಧವಾದ ಸ್ಥಳಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ಬಲಿಪೀಠದ ಮೇಲೆ ಬೆಂಕಿಯು ಅದರೊಳಗೆ ಸುಡುತ್ತಲೇ ಇರಬೇಕು. ಅದು ಆರಿಹೋಗಿರಬಾರದು. ಪ್ರತಿ ಮುಂಜಾನೆ ಯಾಜಕನು ಅದರ ಮೇಲೆ ಕಟ್ಟಿಗೆಯನ್ನು ಹಾಕಬೇಕು. ದಹನಬಲಿಯನ್ನು ಅದರ ಮೇಲೆ ಕ್ರಮವಾಗಿ ಇಡಬೇಕು. ಇದಲ್ಲದೆ ಅವನು ಅದರ ಮೇಲೆ ಸಮಾಧಾನ ಬಲಿ ಅರ್ಪಣೆಗಳ ಕೊಬ್ಬನ್ನು ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ಬಲಿಪೀಠದ ಮೇಲೆ ಬೆಂಕಿಯು ಯಾವಾಗಲೂ ಉರಿಯುತ್ತಿರಬೇಕು, ಅದು ಎಂದಿಗೂ ಆರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘ಧಾನ್ಯ ಸಮರ್ಪಣೆಯ ನಿಯಮವು ಇದೇ. ಆರೋನನ ಪುತ್ರರು ಬಲಿಪೀಠದ ಮುಂದೆ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅದನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ಯಾಜಕನು ಧಾನ್ಯ ಸಮರ್ಪಣೆಯ ಹಿಟ್ಟಿನಲ್ಲಿ ಒಂದು ಹಿಡಿ ಹಿಟ್ಟನ್ನೂ, ಧಾನ್ಯ ಸಮರ್ಪಣೆಯ ಮೇಲಿರುವ ಅದರ ಎಣ್ಣೆಯನ್ನೂ, ಅದರ ಎಲ್ಲಾ ಸಾಂಬ್ರಾಣಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಬಲಿಪೀಠದ ಮೇಲೆ ಸುವಾಸನೆಗಾಗಿ ಅದನ್ನು ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ಅದರಲ್ಲಿ ಉಳಿದದ್ದನ್ನು ಆರೋನನೂ, ಅವನ ಪುತ್ರರೂ ತಿನ್ನಬೇಕು. ಅದನ್ನು ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯೊಂದಿಗೆ ತಿನ್ನಬೇಕು. ಅದನ್ನು ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಅಂಗಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ಅದನ್ನು ಹುಳಿಯೊಂದಿಗೆ ಬೇಯಿಸಬಾರದು. ಅವರು ನನಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ನನ್ನ ಸಮರ್ಪಣೆಗಳಲ್ಲಿ ಅವರ ಪಾಲನ್ನು ಅವರಿಗೆ ನಾನು ಕೊಟ್ಟಿದ್ದೇನೆ. ಅದು ದೋಷಪರಿಹಾರದ ಬಲಿಯ ಹಾಗೆಯೂ ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ಆರೋನನ ಮಕ್ಕಳಲ್ಲಿ ಎಲ್ಲಾ ಗಂಡುಮಕ್ಕಳೂ ಅದನ್ನು ತಿನ್ನಬಹುದು. ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಸಮರ್ಪಣೆಗಳ ವಿಷಯದಲ್ಲಿ ನಿಮ್ಮ ಸಂತತಿಗಳಿಗೆ ಇದು ಒಂದು ಶಾಶ್ವತ ಕಟ್ಟಳೆಯಾಗಿರುವುದು. ಅವುಗಳನ್ನು ಮುಟ್ಟುವ ಪ್ರತಿಯೊಬ್ಬನೂ ಪರಿಶುದ್ಧನಾಗಿರಬೇಕು,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಡನೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ಆರೋನನೂ, ಅವನ ಪುತ್ರರೂ ಅಭಿಷಿಕ್ತರಾದ ದಿನದಲ್ಲಿ, ಅವರು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಬಲಿಯು ಇದೇ. ಮೂರು ಸೇರು ಗೋಧಿ ಹಿಟ್ಟಿನಲ್ಲಿ ನಿರಂತರವಾಗಿರುವ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಮುಂಜಾನೆ ಅದರಲ್ಲಿ ಅರ್ಧಭಾಗವನ್ನು ಮತ್ತು ರಾತ್ರಿ ಅದರಲ್ಲಿ ಅರ್ಧಭಾಗವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ಅದನ್ನು ಒಂದು ಬೋಗುಣಿಯಲ್ಲಿ ಎಣ್ಣೆಯೊಂದಿಗೆ ಮಾಡಬೇಕು. ಅದನ್ನು ತರುವಾಗ ಅದು ಎಣ್ಣೆಯಿಂದ ನೆನೆದೇ ಇರಬೇಕು. ಬೇಯಿಸಿದ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯ ತುಂಡುಗಳನ್ನು ನೀನು ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ಅವನ ಪುತ್ರರಲ್ಲಿ ಅವನಿಗೆ ಬದಲಾಗಿ ಅಭಿಷಿಕ್ತನಾದ ಯಾಜಕನು ಅದನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಇದು ಯೆಹೋವ ದೇವರಿಗಾಗಿ ನಿರಂತರವಾದ ಒಂದು ಕಟ್ಟಳೆಯಾಗಿದೆ. ಅದು ಸಂಪೂರ್ಣವಾಗಿ ಸುಟ್ಟಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ಏಕೆಂದರೆ ಯಾಜಕನಿಗಾಗಿರುವ ಪ್ರತಿಯೊಂದು ಧಾನ್ಯ ಸಮರ್ಪಣೆಯೂ ಸಂಪೂರ್ಣವಾಗಿ ಸುಟ್ಟಿರಬೇಕು. ಅದನ್ನು ತಿನ್ನಬಾರದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“ಆರೋನನಿಗೂ, ಅವನ ಪುತ್ರರಿಗೂ ಹೇಳು: ‘ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ನಿಯಮವು ಇದೇ. ದಹನಬಲಿಯನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯೂ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ವಧಿಸಬೇಕು. ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯನ್ನು ಮಾಡುವ ಯಾಜಕನು ಅದನ್ನು ತಿನ್ನಬೇಕು. ಅದನ್ನು ಸಭೆಯ ದೇವದರ್ಶನದ ಗುಡಾರದ ಅಂಗಳದ ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ಅದರ ಮಾಂಸವನ್ನು ಮುಟ್ಟಿದ್ದೆಲ್ಲವೂ ಪರಿಶುದ್ಧವಾಗಿರುವುದು. ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವಾದರೂ ಉಡುಪಿನ ಮೇಲೆ ಬಿದ್ದರೆ, ಅದನ್ನು ಚಿಮುಕಿಸಿದ ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿಯೇ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ಆದರೆ ಅದನ್ನು ಬೇಯಿಸಿದ ಮಣ್ಣಿನ ಪಾತ್ರೆಯನ್ನು ಒಡೆಯಬೇಕು. ಅದನ್ನು ಒಂದು ಕಂಚಿನ ಪಾತ್ರೆಯಲ್ಲಿ ಬೇಯಿಸಿದ್ದಾದರೆ, ಅದನ್ನು ಬೆಳಗಿ, ನೀರಿನಿಂದ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ಯಾಜಕರ ಕುಟುಂಬದಲ್ಲಿ ಇರುವ ಗಂಡಸರೆಲ್ಲಾ ಅದನ್ನು ತಿನ್ನಬೇಕು. ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ಯಾವ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ರಕ್ತವನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಸಮಾಧಾನಕ್ಕಾಗಿ ತರಲಾಗಿದೆಯೋ, ಆ ಬಲಿಯನ್ನು ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬಾರದು, ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘ಇವು ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯ ನಿಯಮಗಳು: ಇದು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ದಹನಬಲಿಯನ್ನು ವಧಿಸಿದ ಸ್ಥಳದಲ್ಲಿಯೇ ಪ್ರಾಯಶ್ಚಿತ್ತದ ಬಲಿಯನ್ನು ವಧಿಸಬೇಕು. ಅದರ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ಅದರ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ, ಅಂದರೆ ಬಾಲದ ಕೊಬ್ಬನ್ನೂ ಕರುಳಿನ ಸುತ್ತಲಿರುವ ಕೊಬ್ಬನ್ನು, ");
INSERT INTO kanokcv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ಬದಿಯಲ್ಲಿರುವ ಎರಡು ಮೂತ್ರ ಜನಕಾಂಗಗಳನ್ನೂ, ಅವುಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ, ಪಕ್ಕೆಯ ಬದಿಯಲ್ಲಿಯ ಪೊರೆಯನ್ನೂ ಮೂತ್ರಜನಕಾಂಗಗಳೊಂದಿಗೆ ತೆಗೆದುಕೊಂಡು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ಆಗ ಯಾಜಕನು ಅವುಗಳನ್ನು ಬೆಂಕಿಯಿಂದ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸುವ ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ಇದು ಪ್ರಾಯಶ್ಚಿತ್ತದ ಬಲಿಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ಯಾಜಕರಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬ ಪುರುಷನು ಅದನ್ನು ತಿನ್ನಬೇಕು. ಅದನ್ನು ಪರಿಶುದ್ಧವಾದ ಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ಹಾಗೆಯೇ ಪ್ರಾಯಶ್ಚಿತ್ತದ ಬಲಿಯೂ ಆಗಿದೆ. ಅವುಗಳಿಗೆ ಇರುವುದು ಒಂದೇ ನಿಯಮ, ಅವುಗಳಿಂದ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವ ಯಾಜಕನೇ ಅವುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ದಹನಬಲಿಯನ್ನು ಸಮರ್ಪಿಸುವ ಯಾಜಕನು ತಾನು ಸಮರ್ಪಿಸಿದ ದಹನಬಲಿಯ ತೊಗಲನ್ನು ತಾನೇ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ಒಲೆಯಲ್ಲಿ ಬೇಯಿಸಿದ ಬಾಂಡ್ಲಿಯಲ್ಲಿಯೂ ಬೋಗುಣಿಯಲ್ಲಿಯೂ ತಯಾರಿಸಿದ ಎಲ್ಲಾ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯು ಸಮರ್ಪಿಸಿದ ಯಾಜಕನದಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ಎಣ್ಣೆಯಿಂದ ಮಿಶ್ರಿತವಾದ ಮತ್ತು ಒಣಗಿದ್ದ ಪ್ರತಿಯೊಂದು ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ ಆರೋನನ ಪುತ್ರರು ಸರಿ ಸಮಾನವಾಗಿ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘ಅವನು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಸಮಾಧಾನದ ಬಲಿಗಳ ನಿಯಮವು ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘ಅವನು ಉಪಕಾರ ಸ್ತುತಿಗಾಗಿ ಅರ್ಪಿಸುವುದಾದರೆ, ಕೃತಜ್ಞತಾಸ್ತುತಿ ಬಲಿಯನ್ನು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳೊಂದಿಗೆ, ಎಣ್ಣೆ ಹೊಯ್ದ ಹುಳಿಯಿಲ್ಲದ ದೋಸೆಗಳೊಂದಿಗೆ ಮತ್ತು ನಯವಾದ ಹಿಟ್ಟಿನ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹುರಿದ ರೊಟ್ಟಿಗಳೊಂದಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ರೊಟ್ಟಿಗಳಲ್ಲದೆ, ಅವನು ಸಮಾಧಾನದ ಬಲಿಗಳನ್ನು ಉಪಕಾರಸ್ತುತಿ ಯಜ್ಞದೊಂದಿಗೆ ತನ್ನ ಬಲಿಗಾಗಿ ಹುಳಿರೊಟ್ಟಿಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ಅವನು ಇಡೀ ಕಾಣಿಕೆಯಲ್ಲಿ ಒಂದನ್ನು ಕಾಣಿಕೆಯನ್ನಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಬೇಕು. ಅದು ಸಮಾಧಾನ ಬಲಿಗಳ ರಕ್ತವನ್ನು ಚಿಮುಕಿಸುವ ಯಾಜಕನದ್ದಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ಉಪಕಾರ ಸ್ತುತಿಗಾಗಿ ಅವನು ಸಮಾಧಾನ ಬಲಿಯ ಮಾಂಸವನ್ನು ಅರ್ಪಿಸಲಾದ ದಿನವೇ ತಿನ್ನಬೇಕು. ಅವನು ಅದರಲ್ಲಿ ಬೆಳಗಿನವರೆಗೆ ಯಾವುದನ್ನೂ ಉಳಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘ಆದರೆ ಅವನ ಯಜ್ಞ ಸಮರ್ಪಣೆಯು ಒಂದು ಹರಕೆಯಾಗಿದ್ದರೆ ಇಲ್ಲವೆ ಸ್ವಯಿಚ್ಛೆಯಾದ ಸಮರ್ಪಣೆಯಾಗಿದ್ದರೆ ಅವನು ತನ್ನ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸಿದ ದಿನದಲ್ಲಿಯೇ ಅದನ್ನು ತಿನ್ನಬೇಕು. ಅದರಲ್ಲಿ ಉಳಿದದ್ದನ್ನು ಮಾರನೆಯ ದಿನದಲ್ಲಿ ಸಹ ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ಆದರೆ ಉಳಿದಿರುವ ಯಜ್ಞದ ಮಾಂಸವನ್ನು ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ತನ್ನ ಸಮಾಧಾನ ಬಲಿಯ ಯಜ್ಞದ ಮಾಂಸದಲ್ಲಿ ಯಾವ ಭಾಗವನ್ನಾದರೂ ಮೂರನೆಯ ದಿನದಲ್ಲಿ ತಿಂದರೆ ಅದು ಬಲಿಯಾಗುವುದಿಲ್ಲ, ಇಲ್ಲವೆ ಅರ್ಪಿಸುವವನ ಲೆಕ್ಕಕ್ಕೆ ಸೇರುವುದಿಲ್ಲ. ಅದು ಅಶುಚಿಯಾಗಿರುವುದು, ಅದನ್ನು ತಿನ್ನುವವನು ತನ್ನ ಅಪರಾಧವನ್ನು ಹೊರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘ಅಶುದ್ಧವಾದ ಯಾವುದನ್ನಾದರೂ ಮುಟ್ಟಿದ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು, ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ಮಾಂಸದ ವಿಷಯದಲ್ಲಿ ಶುದ್ಧವಾಗಿರುವವರೆಲ್ಲರೂ ಅದರಲ್ಲಿ ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ಆದರೆ ಯೆಹೋವ ದೇವರಿಗೆ ಸಂಬಂಧಪಟ್ಟ ಸಮಾಧಾನದ ಬಲಿಯ ಯಜ್ಞದ ಮಾಂಸವನ್ನು ಯಾವನಾದರೂ ಅಶುದ್ಧನಾಗಿದ್ದು ತಿನ್ನುವನೋ, ಅಂಥವರನ್ನು ತಮ್ಮ ಜನರಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ಇದಲ್ಲದೆ ಯಾವನಾದರೂ ಮನುಷ್ಯನ ಅಶುದ್ಧ ವಸ್ತುವನ್ನೇ ಇಲ್ಲವೆ ಯಾವುದೇ ಹೊಲೆಯಾದ ಅಶುದ್ಧವಸ್ತುವನ್ನಾಗಲಿ ಮುಟ್ಟಿದರೆ ಮತ್ತು ಯೆಹೋವ ದೇವರಿಗೆ ಸಂಬಂಧಿಸಿದ ಸಮಾಧಾನ ಬಲಿಯ ಯಜ್ಞದ ಮಾಂಸವನ್ನು ತಿಂದರೆ ಅವನು ತನ್ನ ಕುಲದಿಂದ ಬಹಿಷ್ಕೃತನಾಗಬೇಕು,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೀಗೆ ಹೇಳು: ‘ನೀವು ಎತ್ತು ಇಲ್ಲವೆ ಕುರಿ ಇಲ್ಲವೆ ಮೇಕೆಗಳ ಕೊಬ್ಬನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ತಾನಾಗಿಯೇ ಸತ್ತ ಪ್ರಾಣಿಯ ಕೊಬ್ಬನ್ನೂ, ಕಾಡುಮೃಗಗಳು ಸೀಳಿದ್ದರ ಕೊಬ್ಬನ್ನೂ ಬೇರೆ ಯಾವುದಕ್ಕಾದರೂ ಉಪಯೋಗಿಸಬಹುದು. ಆದರೆ ನೀವು ಅದನ್ನು ಎಷ್ಟು ಮಾತ್ರವೂ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ಏಕೆಂದರೆ ಮನುಷ್ಯರು ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಸಮರ್ಪಿಸಿದ ಬಲಿ, ಪ್ರಾಣಿಯ ಕೊಬ್ಬನ್ನು ಯಾವನಾದರೂ ತಿಂದರೆ, ಅಂಥವರನ್ನು ತಮ್ಮ ಜನರಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ಇದಲ್ಲದೆ ನೀವು ಯಾವ ತರದ ರಕ್ತವನ್ನೂ ಅಂದರೆ ಅದು ಪಕ್ಷಿಯದಾಗಿರಲಿ, ಪ್ರಾಣಿಯದಾಗಿರಲಿ ನಿಮ್ಮ ಯಾವ ನಿವಾಸಗಳಲ್ಲಿಯೂ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ಯಾವುದೇ ತರದ ರಕ್ತವನ್ನು ತಿಂದವನು ಯಾವನೇ ಆಗಿರಲಿ, ಅಂಥವನನ್ನು ತನ್ನ ಜನರಿಂದ ತೆಗೆದುಹಾಕಬೇಕು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ನೀನು ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೀಗೆ ಹೇಳು: ‘ಯೆಹೋವ ದೇವರಿಗೆ ಸಮಾಧಾನ ಬಲಿಯನ್ನು ಅರ್ಪಿಸುವವನು, ಸಮಾಧಾನ ಬಲಿಯ ತನ್ನ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ಅವನು ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಸಮರ್ಪಣೆಗಳನ್ನು ತನ್ನ ಸ್ವಂತ ಕೈಗಳಿಂದಲೇ ತರಬೇಕು. ಯೆಹೋವ ದೇವರ ಮುಂದೆ ನೈವೇದ್ಯರೂಪವಾಗಿ ನಿವಾಳಿಸುವದಕ್ಕೆ ಕೊಬ್ಬಿನೊಂದಿಗೆ ಎದೆಯನ್ನು ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ಯಾಜಕನು ಆ ಕೊಬ್ಬನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ಆದರೆ ಎದೆಯು ಆರೋನನ ಮತ್ತು ಅವನ ಮಕ್ಕಳಿಗೆ ಸೇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ಬಲಭುಜವನ್ನು ನೀವು ಯಾಜಕನಿಗೆ ಸಮಾಧಾನದ ಬಲಿಯಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ಸಮಾಧಾನದ ಬಲಿಗಳ ರಕ್ತವನ್ನೂ, ಕೊಬ್ಬನ್ನೂ ಸಮರ್ಪಿಸುವ ಆರೋನನ ಪುತ್ರರಲ್ಲಿ ಒಬ್ಬನು ಭುಜದ ಬಲಭಾಗವನ್ನು ತನ್ನ ಪಾಲಾಗಿ ತೆಗೆದುಕೊಳ್ಳಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ಏಕೆಂದರೆ ನೈವೇದ್ಯ ಮಾಡಿದ ಎದೆಯನ್ನು ಮತ್ತು ನಿವಾಳಿಸುವ ಭುಜವನ್ನು ಇಸ್ರಾಯೇಲಿನ ಮಕ್ಕಳ ಸಮಾಧಾನದ ಬಲಿಗಳ ಯಜ್ಞಗಳಿಂದ ನಾನು ತೆಗೆದುಕೊಂಡು ಯಾಜಕನಾದ ಆರೋನನಿಗೂ, ಅವನ ಪುತ್ರರಿಗೂ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಒಂದು ನಿರಂತರವಾದ ಕಟ್ಟಳೆಯಾಗಿ ಅವರಿಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ಆರೋನನ ಅಭಿಷೇಕದ ಮತ್ತು ಅವನ ಮಕ್ಕಳ ಅಭಿಷೇಕದ ದಿನದಲ್ಲಿ ಅವರು ತಮ್ಮನ್ನು ಯಾಜಕನ ಉದ್ಯೋಗದ ಸೇವೆಗಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಒಪ್ಪಿಸಿಕೊಳ್ಳುವಾಗ, ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಸಮರ್ಪಿಸುವ ಬಲಿಗಳಲ್ಲಿ ಇರುವ ಪಾಲು ಇದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ಅವರನ್ನು ಅಭಿಷೇಕಿಸಿದ ದಿನದಲ್ಲಿ ಇದನ್ನು ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರಿಗೆ ಅವರ ಎಲ್ಲಾ ಸಂತತಿಗಳಲ್ಲಿ ಒಂದು ನಿರಂತರವಾದ ಕಟ್ಟಳೆಯಾಗಿರುವಂತೆ ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ದಹನಬಲಿ, ಧಾನ್ಯ ಬಲಿ, ಪಾಪ ಪರಿಹಾರದ ಬಲಿ, ಪ್ರಾಯಶ್ಚಿತ್ತದ ಬಲಿ, ಪ್ರತಿಷ್ಠೆಗಳ ಮತ್ತು ಸಮಾಧಾನದ ಬಲಿಗಳ ಉಪದೇಶಗಳು ಇವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ಇವುಗಳನ್ನು ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರಿಗೆ ಅವರು ತಮ್ಮ ಕಾಣಿಕೆಗಳನ್ನು ಸಮರ್ಪಿಸುವಂತೆ ಆಜ್ಞಾಪಿಸಿದ ದಿನದಲ್ಲಿ ಸೀನಾಯಿ ಮರುಭೂಮಿಯ ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“ಆರೋನನನ್ನೂ, ಅವನೊಂದಿಗೆ ಅವನ ಪುತ್ರರನ್ನೂ, ಉಡುಪುಗಳನ್ನೂ, ಅಭಿಷೇಕ ತೈಲವನ್ನೂ, ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಹೋರಿಯನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಬುಟ್ಟಿಯನ್ನೂ ತೆಗೆದುಕೋ. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ಎಲ್ಲಾ ಸಭೆಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಒಟ್ಟಾಗಿ ಸೇರಿಸು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ಆಗ ಮೋಶೆಯು, ಯೆಹೋವ ದೇವರು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡಿದನು. ಸಭೆಯು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಒಟ್ಟಾಗಿ ಕೂಡಿಬಂದಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ಮೋಶೆಯು ಸಭೆಗೆ, “ಯೆಹೋವ ದೇವರು ಮಾಡುವುದಕ್ಕೆ ಆಜ್ಞಾಪಿಸಿರುವುದು ಇದೇ.” ");
INSERT INTO kanokcv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ಮೋಶೆಯು ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಕರೆದುಕೊಂಡು ಬಂದು, ಸ್ನಾನಮಾಡಿಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ಆರೋನನಿಗೆ ನಿಲುವಂಗಿಯನ್ನು ಹೊದಿಸಿ, ನಡುಕಟ್ಟಿನಿಂದ ಅವನ ನಡುವನ್ನು ಕಟ್ಟಿ, ಅವನಿಗೆ ಮೇಲಂಗಿಯನ್ನು ತೊಡಿಸಿ, ಅವನ ಮೇಲೆ ಏಫೋದನ್ನು ಹಾಕಿ, ಏಫೋದಿನ ಕಲಾತ್ಮಕವಾದ ನಡುಕಟ್ಟಿನಿಂದ ಅವನ ನಡುವನ್ನೂ ಕಟ್ಟಿ, ಅದರಿಂದ ಅವನನ್ನು ಬಿಗಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ಅವನ ಮೇಲೆ ಎದೆಪದಕವನ್ನು ಹಾಕಿ, ಆ ಎದೆಪದಕದಲ್ಲಿ ಊರೀಮ್ ಮತ್ತು ತುಮ್ಮೀಮ್ ಇವುಗಳನ್ನೂ ಸಹ ಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ಅವನ ತಲೆಯ ಮೇಲೆ ಮುಂಡಾಸವನ್ನು ಇಟ್ಟು, ಆ ಮುಂಡಾಸದ ಮೇಲೆ ಅಂದರೆ ಅದರ ಮುಂಭಾಗದಲ್ಲಿ ಬಂಗಾರದ ಪಟ್ಟಿಯನ್ನೂ, ಪವಿತ್ರವಾದ ಕಿರೀಟವನ್ನೂ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ಮೋಶೆಯು ಅಭಿಷೇಕ ತೈಲವನ್ನು ತೆಗೆದುಕೊಂಡು ಗುಡಾರವನ್ನೂ, ಅದರೊಳಗಿರುವುದೆಲ್ಲವನ್ನೂ ಅಭಿಷೇಕಿಸಿ, ಅವುಗಳನ್ನು ಪವಿತ್ರ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ಅವನು ಅದರಿಂದ ಬಲಿಪೀಠದ ಮೇಲೆ ಏಳು ಸಾರಿ ಚಿಮುಕಿಸಿ, ಬಲಿಪೀಠವನ್ನೂ, ಅದರ ಎಲ್ಲಾ ಪಾತ್ರೆಗಳನ್ನೂ, ಗಂಗಾಳವನ್ನೂ, ಅದರ ಕಾಲನ್ನೂ ಅಭಿಷೇಕಿಸಿ, ಅವುಗಳನ್ನು ಪವಿತ್ರ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ಅವನು ಅಭಿಷೇಕ ತೈಲದಿಂದ ಆರೋನನ ತಲೆಯ ಮೇಲೆ ಸುರಿದು, ಅವನನ್ನು ಪವಿತ್ರ ಮಾಡುವುದಕ್ಕಾಗಿ ಅವನನ್ನು ಅಭಿಷೇಕಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ಮೋಶೆಯು ಆರೋನನ ಪುತ್ರರನ್ನು ಕರೆದುಕೊಂಡು ಬಂದು ಅವರಿಗೆ ನಿಲುವಂಗಿಗಳನ್ನು ತೊಡಿಸಿ, ಅವರ ನಡುಗಳನ್ನು ನಡುಕಟ್ಟುಗಳಿಂದ ಕಟ್ಟಿ, ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವರ ಮೇಲೆ ಕುಲಾಯಿಗಳನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಅವನು ಹೋರಿಯನ್ನು ತಂದನು. ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಆ ಹೋರಿಯ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ಆಗ ಅವನು ಅದನ್ನು ವಧಿಸಿದನು. ಮೋಶೆಯು ಅದರ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು, ಬಲಿಪೀಠದ ಸುತ್ತಲೂ ಇರುವ ಕೊಂಬುಗಳ ಮೇಲೆ ತನ್ನ ಬೆರಳಿನಿಂದ ಹಚ್ಚಿ, ಬಲಿಪೀಠವನ್ನು ಶುದ್ಧೀಕರಿಸಿ, ಉಳಿದ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಅಡಿಯಲ್ಲಿ ಹೊಯ್ದನು. ಅದರ ಮೇಲೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕಾಗಿ ಅದನ್ನು ಪವಿತ್ರ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ಕರುಳುಗಳ ಮೇಲಿರುವ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ ಕಾಳಿಜದ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರ ಜನಕಾಂಗಗಳನ್ನೂ ಅವುಗಳ ಕೊಬ್ಬನ್ನೂ ಮೋಶೆಯು ತೆಗೆದುಕೊಂಡು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಹೋರಿಯ ಮಾಂಸವನ್ನೂ, ಅದರ ಚರ್ಮವನ್ನೂ, ಅದರ ಸಗಣಿಯನ್ನೂ ಅವನು ಪಾಳೆಯದ ಹೊರಗೆ ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ದಹನಬಲಿಗಾಗಿ ಟಗರನ್ನು ತಂದನು. ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ಆ ಟಗರಿನ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ಅವನು ಅದನ್ನು ವಧಿಸಿದನು. ತರುವಾಯ ಮೋಶೆಯು ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ಅವನು ಆ ಟಗರನ್ನು ತುಂಡುತುಂಡಾಗಿ ಮಾಡಿದನು. ಮೋಶೆಯು ತಲೆಯನ್ನು, ಆ ತುಂಡುಗಳನ್ನು, ಆ ಕೊಬ್ಬನ್ನು ಸುಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ಅವನು ಕರುಳುಗಳನ್ನೂ, ಕಾಲುಗಳನ್ನೂ ನೀರಿನಲ್ಲಿ ತೊಳೆದನು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಆ ಟಗರನ್ನು ಪೂರ್ಣವಾಗಿ ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಟ್ಟನು. ಇದು ದಹನಬಲಿಯಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಸುವಾಸನೆಯ ಸಮರ್ಪಣೆಯಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ಅವನು ಪ್ರತಿಷ್ಠೆಯ ಟಗರಾದ ಇನ್ನೊಂದು ಟಗರನ್ನು ತಂದನು. ಆಗ ಆರೋನನೂ, ಅವನ ಪುತ್ರರೂ ಆ ಟಗರಿನ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ಮೋಶೆಯು ಅದನ್ನು ವಧಿಸಿ, ಅದರ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ಅದನ್ನು ಆರೋನನ ಬಲಗಿವಿಯ ತುದಿಗೂ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಹಚ್ಚಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ಮೋಶೆಯು ಆರೋನನ ಪುತ್ರರನ್ನು ಕರೆತಂದು ಅವರ ಬಲಗಿವಿಯ ತುದಿಯ ಮೇಲೆಯೂ, ಅವರವರ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ, ಅವರವರ ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಆ ರಕ್ತವನ್ನು ಹಚ್ಚಿ, ಆ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ಅವನು ಕೊಬ್ಬನ್ನೂ ಬಾಲವನ್ನೂ ಕರುಳುಗಳ ಮೇಲಿರುವ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ ಕಾಳಿಜದ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರ ಜನಕಾಂಗಗಳನ್ನೂ ಅವುಗಳ ಕೊಬ್ಬನ್ನೂ ಬಲದೊಡೆಯನ್ನೂ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಪುಟ್ಟಿಯೊಳಗಿಂದ ಒಂದು ರೊಟ್ಟಿಯನ್ನೂ ಎಣ್ಣೆಯ ಒಂದು ಹೋಳಿಗೆಯನ್ನೂ ಒಂದು ಪೂರಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು, ಅವುಗಳನ್ನು ಕೊಬ್ಬಿನ ಮೇಲೆಯೂ, ಬಲಭುಜದ ಮೇಲೆಯೂ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ಅದೆಲ್ಲವನ್ನೂ ಆರೋನನ ಕೈಗಳಿಗೆ ಮತ್ತು ಅವನ ಪುತ್ರರ ಕೈಗಳಿಗೆ ಕೊಟ್ಟು, ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಸಮರ್ಪಣೆಗಾಗಿ ಅವುಗಳನ್ನು ನೈವೇದ್ಯ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ಆಮೇಲೆ ಮೋಶೆಯು ಅವುಗಳನ್ನು ಅವರ ಕೈಗಳಿಂದ ತೆಗೆದುಕೊಂಡು, ಬಲಿಪೀಠದ ಮೇಲೆ ದಹನಬಲಿಯಾಗಿ ಅವುಗಳನ್ನು ಸುಟ್ಟನು. ಅವು ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಸಮರ್ಪಿಸಿದ ಸುಗಂಧಕರ ಪ್ರತಿಷ್ಠೆಯ ಬಲಿಯಾಗಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ಮೋಶೆಯು ಟಗರಿನ ಎದೆಯ ಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು ನೈವೇದ್ಯವಾಗಿ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿವಾಳಿಸಿದನು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಪ್ರತಿಷ್ಠಿತ ಟಗರು ಮೋಶೆಯ ಪಾಲಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ಮೋಶೆಯು ಅಭಿಷೇಕ ತೈಲವನ್ನೂ, ಬಲಿಪೀಠದ ಮೇಲಿರುವ ರಕ್ತವನ್ನೂ ತೆಗೆದುಕೊಂಡು, ಆರೋನನ ಮೇಲೆಯೂ, ಅವನ ಉಡುಪುಗಳ ಮೇಲೆಯೂ ಅವನೊಂದಿಗೆ ಅವನ ಪುತ್ರರ ಮೇಲೆಯೂ, ಅವರ ಉಡುಪುಗಳ ಮೇಲೆಯೂ ಚಿಮುಕಿಸಿದನು. ಆರೋನನನ್ನೂ, ಅವನ ಉಡುಪುಗಳನ್ನೂ, ಅವನೊಂದಿಗೆ ಅವನ ಪುತ್ರರನ್ನೂ, ಅವನ ಪುತ್ರರ ಉಡುಪುಗಳನ್ನೂ ಪವಿತ್ರ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ಮೋಶೆಯು ಆರೋನನಿಗೂ, ಅವನ ಪುತ್ರರಿಗೂ, “ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಆ ಮಾಂಸವನ್ನು ಬೇಯಿಸಿರಿ. ಅದನ್ನು ಪ್ರತಿಷ್ಠಿತ ಬುಟ್ಟಿಯೊಳಗಿರುವ ರೊಟ್ಟಿಯೊಡನೆ ತಿನ್ನಬೇಕು. ನಾನು ಆಜ್ಞಾಪಿಸಿ ಹೇಳಿದಂತೆ, ‘ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ಅದನ್ನು ತಿನ್ನಬೇಕು.’ ");
INSERT INTO kanokcv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ಮಾಂಸದಲ್ಲಿಯೂ, ರೊಟ್ಟಿಯಲ್ಲಿಯೂ ಉಳಿದದ್ದನ್ನು ನೀವು ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ಇದಲ್ಲದೆ ನಿಮ್ಮ ಪ್ರತಿಷ್ಠೆಯ ದಿನದ ಕೊನೆಗೊಳ್ಳುವುದಕ್ಕೆ ಏಳು ದಿವಸ ಹಿಡಿಯುವುದರಿಂದ ನೀವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನಿಂದ ಹೊರಗೆ ಹೋಗಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ನಿಮ್ಮ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಈ ಹೊತ್ತು ಏನೇನು ನಡೆಯಿತೋ ಅದನ್ನು ಏಳು ದಿನವೂ ನಡೆಸಬೇಕೆಂದು ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ಆದ್ದರಿಂದ ಏಳು ದಿನಗಳವರೆಗೆ ನೀವು ಸಾಯದಂತೆ ಹಗಲೂ ರಾತ್ರಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ಏಕೆಂದರೆ ಹಾಗೆಯೇ ನನಗೆ ಅಪ್ಪಣೆಯಾಗಿದೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ಹೀಗೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಎಲ್ಲವನ್ನೂ, ಆರೋನನೂ, ಅವನ ಪುತ್ರರೂ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಮೋಶೆಯು ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಮತ್ತು ಇಸ್ರಾಯೇಲಿನ ಹಿರಿಯರನ್ನೂ ಕರೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ಅವನು ಆರೋನನಿಗೆ, “ನೀನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಕರುವನ್ನೂ ಮತ್ತು ದಹನಬಲಿಗಾಗಿ ಕಳಂಕರಹಿತ ಟಗರನ್ನೂ ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಮರ್ಪಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ: ‘ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಹೋತವನ್ನೂ ದಹನಬಲಿಗಾಗಿ ಕಳಂಕರಹಿತ ಒಂದು ವರ್ಷದ ಕರುವನ್ನೂ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಯನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಯಜ್ಞಕ್ಕೆ ಸಮಾಧಾನ ಬಲಿಗಾಗಿ ಒಂದು ಹೋರಿಯನ್ನು ಮತ್ತು ಒಂದು ಟಗರನ್ನು ಸಹ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಆಹಾರದ ಬಲಿ ಎಣ್ಣೆಯೊಂದಿಗೆ ಬೆರೆತಿರಬೇಕು. ಏಕೆಂದರೆ ಈ ದಿನವೇ ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ಕಾಣಿಸಿಕೊಳ್ಳುವರು,’ ” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ಅವರು ಮೋಶೆಯು ಆಜ್ಞಾಪಿಸಿದವುಗಳನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮುಂದೆ ತಂದರು. ಸಮೂಹವೆಲ್ಲವೂ ಹತ್ತಿರ ಬಂದು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ನಿಂತಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ಮೋಶೆ ಅವರಿಗೆ, “ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ಸಂಗತಿಯು ಇದೇ. ಇದನ್ನು ನೀವು ಮಾಡಿರಿ. ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯು ನಿಮಗೆ ಕಾಣಿಸಿಕೊಳ್ಳುವುದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ಬಲಿಪೀಠದ ಕಡೆಗೆ ಹೋಗಿ, ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ನಿನ್ನ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯನ್ನೂ ದಹನಬಲಿಯನ್ನೂ ಅರ್ಪಿಸು. ನಿನಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡು, ಜನರ ಸಮರ್ಪಣೆಗಳನ್ನು ಸಮರ್ಪಿಸಿ, ಅವರಿಗಾಗಿಯೂ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ಆದ್ದರಿಂದ ಆರೋನನು ಬಲಿಪೀಠದ ಕಡೆಗೆ ಹೋಗಿ, ತನಗಾಗಿ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾದ ಕರುವನ್ನು ವಧಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ಆಗ ಆರೋನನ ಪುತ್ರರು ಅವನ ಬಳಿಗೆ ರಕ್ತವನ್ನು ತಂದರು. ಅವನು ಆ ರಕ್ತದಲ್ಲಿ ತನ್ನ ಬೆರಳನ್ನು ಅದ್ದಿ, ಬಲಿಪೀಠದ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ, ಬಲಿಪೀಠದ ಅಡಿಯಲ್ಲಿ ಉಳಿದ ರಕ್ತವನ್ನು ಹೊಯ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ಅದರ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ಕೊಬ್ಬು, ಮೂತ್ರಪಿಂಡಗಳು ಮತ್ತು ಕಾಳಿಜದ ಹತ್ತಿರವಿರುವ ಕೊಬ್ಬು, ಇವುಗಳನ್ನು ಅವನು ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ, ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ಮಾಂಸವನ್ನೂ ಚರ್ಮವನ್ನೂ ಅವನು ಪಾಳೆಯದ ಹೊರಗೆ ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ಅವನು ದಹನಬಲಿಯನ್ನು ವಧಿಸಿದಾಗ, ಆರೋನನ ಪುತ್ರರು ಅವನಿಗೆ ರಕ್ತವನ್ನು ತಂದು ಕೊಟ್ಟರು. ಅದನ್ನು ಅವನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ಅವರು ಅವನಿಗೆ ದಹನಬಲಿಯನ್ನೂ ಅವುಗಳ ತುಂಡುಗಳೊಂದಿಗೆ ತಲೆಯನ್ನೂ ತಂದು ಕೊಡಲು, ಅವನು ಅವುಗಳನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ಅವನು ಕರುಳುಗಳನ್ನು ಮತ್ತು ಕಾಲುಗಳನ್ನು ತೊಳೆದು, ಅವುಗಳನ್ನು ದಹನಬಲಿಯ ಜೊತೆ ಮೇಲಿನ ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ಅದಾದ ಮೇಲೆ ಆರೋನನು ಜನರಿಗಾಗಿ ಅರ್ಪಿಸಿದ ಬಲಿಯನ್ನು ತಂದು, ಹೋತವನ್ನು ತೆಗೆದುಕೊಂಡು, ಜನರಿಗಾಗಿ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿರುವುದನ್ನು ವಧಿಸಿ, ಮೊದಲನೆಯದರ ಹಾಗೆ ಅದನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ಅವನು ದಹನಬಲಿಯನ್ನು ತಂದು, ಅದನ್ನು ವಿಧಿಬದ್ಧವಾಗಿ ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ಅವನು ಧಾನ್ಯ ಸಮರ್ಪಣೆಯ ಬಲಿಯನ್ನು ತಂದು, ಅದರಲ್ಲಿ ಒಂದು ಹಿಡಿ ತೆಗೆದುಕೊಂಡು, ಬಲಿಪೀಠದ ಮೇಲೆ ಬೆಳಗಿನ ದಹನಬಲಿ ಯಜ್ಞದ ಬಳಿಯಲ್ಲಿ ಅದನ್ನು ಹೋಮ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ಅವನು ಜನರಿಗಾಗಿದ್ದ ಹೋರಿ ಮತ್ತು ಟಗರನ್ನು ಸಮಾಧಾನ ಬಲಿಗಳ ಯಜ್ಞಕ್ಕಾಗಿ ವಧಿಸಿದನು. ಆರೋನನ ಪುತ್ರರು ರಕ್ತವನ್ನು ಅವನ ಬಳಿಗೆ ತರಲು, ಅದನ್ನು ಅವನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುತ್ತಲೂ ಚಿಮುಕಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ಹೋರಿಯ ಮತ್ತು ಟಗರಿನ ಕೊಬ್ಬನ್ನೂ ಹಿಂಭಾಗದ ಕೊಬ್ಬನ್ನೂ ಮತ್ತು ಕರುಳುಗಳ ಸುತ್ತಲಿನ ಕೊಬ್ಬನ್ನೂ ಮೂತ್ರಪಿಂಡಗಳ ಮತ್ತು ಕಾಳಿಜದ ಹತ್ತಿರವಿರುವ ಕೊಬ್ಬನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ಕೊಬ್ಬನ್ನು ಎದೆಯ ಭಾಗಗಳ ಮೇಲೆ ಇಡಲು, ಆರೋನನು ಆ ಕೊಬ್ಬನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ಎದೆಯ ಭಾಗಗಳನ್ನು, ಬಲತೊಡೆಗಳನ್ನು ಆರೋನನು, ಮೋಶೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ಆರೋನನು ಜನರ ಕಡೆಗೆ ತನ್ನ ಕೈಗಳನ್ನು ಎತ್ತಿ, ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯನ್ನೂ ದಹನಬಲಿಯನ್ನೂ ಮತ್ತು ಸಮಾಧಾನದ ಬಲಿಯನ್ನೂ ಸಮರ್ಪಿಸಿದ ಮೇಲೆ ಇಳಿದು ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ಮೋಶೆಯೂ ಆರೋನನೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಒಳಗೆ ಹೋಗಿ, ಹೊರಗೆ ಬಂದು ಜನರನ್ನು ಆಶೀರ್ವದಿಸಿದರು. ಆಗ ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯು ಜನರೆಲ್ಲರಿಗೂ ಕಾಣಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ಆಗ ಅಲ್ಲಿ ಬೆಂಕಿಯು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಿಂದ ಬಂದು, ಬಲಿಪೀಠದ ಮೇಲಿದ್ದ ದಹನಬಲಿಯನ್ನು ಮತ್ತು ಕೊಬ್ಬನ್ನು ದಹಿಸಿಬಿಟ್ಟಿತು. ಇದನ್ನು ಜನರೆಲ್ಲರೂ ಕಂಡಾಗ, ಅವರು ಆನಂದದಿಂದ ಜಯಘೋಷ ಮಾಡಿ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ಆರೋನನ ಪುತ್ರರಾದ ನಾದಾಬ್ ಮತ್ತು ಅಬೀಹೂ ತಮ್ಮ ತಮ್ಮ ಧೂಪ ಪಾತ್ರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದರಲ್ಲಿ ಬೆಂಕಿಯನ್ನು ಹಾಕಿ, ಅದರಲ್ಲಿ ಸುವಾಸನೆಯ ಧೂಪವನ್ನು ಹಾಕಿ, ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸದೇ ಇದ್ದ ಬೇರೆ ಬೆಂಕಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ಆಗ ಯೆಹೋವ ದೇವರ ಬಳಿಯಿಂದ ಬೆಂಕಿಯು ಹೊರಟುಬಂದು ಅವರನ್ನು ದಹಿಸಿಬಿಟ್ಟಿತು. ಅವರು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಮರಣಹೊಂದಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ತರುವಾಯ ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ಯೆಹೋವ ದೇವರು ಹೇಳಿದ್ದು ಇದೇ. ಅದೇನೆಂದರೆ: “ ‘ನನ್ನನ್ನು ಸಮೀಪಿಸುವವರ ಮುಖಾಂತರ ನನ್ನ ಪರಿಶುದ್ಧತೆಯನ್ನು ತೋರಿಸುವೆನು ಮತ್ತು ಜನರೆಲ್ಲರ ಮುಂದೆ ನನ್ನ ಮಹಿಮೆಯನ್ನು ತೋರ್ಪಡಿಸುವೆನು,’ ” ಎಂದನು. ಆಗ ಆರೋನನು ಮಾತನಾಡದೆ ಸುಮ್ಮನಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ಮೋಶೆಯು ಆರೋನನ ಚಿಕ್ಕಪ್ಪನಾದ ಉಜ್ಜೀಯೇಲನ ಮಕ್ಕಳಾದ ಮೀಶಾಯೇಲನನ್ನೂ ಎಲ್ಜಾಫಾನನನ್ನೂ ಕರೆದು, “ನಿಮ್ಮ ಸಹೋದರರನ್ನು ಪರಿಶುದ್ಧ ಸ್ಥಳದಿಂದ ಪಾಳೆಯದ ಹೊರಗೆ ಹೊತ್ತುಕೊಂಡು ಹೋಗಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ಮೋಶೆಯು ಹೇಳಿದ ಹಾಗೆಯೇ, ಅವರು ಹತ್ತಿರಕ್ಕೆ ಹೋಗಿ ಅವರನ್ನು ಅವರ ಮೇಲಂಗಿಗಳೊಂದಿಗೆ ಹೊತ್ತುಕೊಂಡು ಪಾಳೆಯದ ಹೊರಗೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ಆಗ ಮೋಶೆಯು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಾದ ಎಲಿಯಾಜರನಿಗೂ ಈತಾಮಾರನಿಗೂ, “ನೀವು ಮರಣ ಹೊಂದದಂತೆಯೂ ಕೋಪವು ಜನರೆಲ್ಲರ ಮೇಲೆ ಬಾರದಂತೆಯೂ ನೀವು ನಿಮ್ಮ ಮುಚ್ಚಿದ ತಲೆಗಳನ್ನು ತೆಗೆಯಬೇಡಿರಿ. ಇಲ್ಲವೆ ನಿಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ತೆಗೆಯಬೇಡಿರಿ. ಇಲ್ಲವೆ ನಿಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಳ್ಳಬೇಡಿರಿ. ಆದರೆ ನಿಮ್ಮ ಸಹೋದರರಾಗಿರುವ ಇಸ್ರಾಯೇಲಿನ ಮನೆತನದವರೆಲ್ಲರು ಯೆಹೋವ ದೇವರು ಉರಿಸಿದ ಬೆಂಕಿಯ ನಾಶದ ನಿಮಿತ್ತ ಗೋಳಾಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ನೀವು ಮರಣ ಹೊಂದದಂತೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನಿಂದ ಹೊರಗೆ ಹೋಗಬಾರದು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರ ಅಭಿಷೇಕ ತೈಲವು ನಿಮ್ಮ ಮೇಲಿದೆ,” ಎಂದನು. ಆಗ ಅವರು ಮೋಶೆಯ ಮಾತಿನ ಪ್ರಕಾರವೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ಯೆಹೋವ ದೇವರು ಮಾತನಾಡಿ ಆರೋನನಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ನೀನು ಸಾಯದಂತೆ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೆ ಬರುವಾಗ ನೀನೂ ಇಲ್ಲವೆ ನಿನ್ನ ಪುತ್ರರೂ ದ್ರಾಕ್ಷಾರಸವನ್ನಾಗಲಿ, ಮದ್ಯವನ್ನಾಗಲಿ ಕುಡಿಯಬಾರದು. ಇದು ನಿಮ್ಮ ವಂಶಾವಳಿಯು ಇರುವವರೆಗೂ ಶಾಶ್ವತವಾಗಿರುವ ಕಟ್ಟಳೆಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ನೀವು ಶುದ್ಧವಾದದ್ದಕ್ಕೂ ಅಪವಿತ್ರವಾದದ್ದಕ್ಕೂ ಮಧ್ಯೆ ಇರುವ ವ್ಯತ್ಯಾಸವನ್ನು ತೋರಿಸುವುದಕ್ಕಾಗಿಯೂ ");
INSERT INTO kanokcv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ನೀವು ಇಸ್ರಾಯೇಲರಿಗೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಕೈಗೆ ಒಪ್ಪಿಸಿ ಹೇಳಿದ ಹಾಗೆ, ಎಲ್ಲಾ ಕಟ್ಟಳೆಗಳನ್ನು ಬೋಧಿಸುವುದಕ್ಕಾಗಿಯೂ ಇರುವುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ಮೋಶೆಯು ಆರೋನನೊಂದಿಗೂ ಉಳಿದ ಅವನ ಪುತ್ರರಾದ ಎಲಿಯಾಜರನೊಂದಿಗೂ ಈತಾಮಾರನೊಂದಿಗೂ ಮಾತನಾಡಿ, “ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಬಲಿಗಳಲ್ಲಿ ಉಳಿದಿರುವ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಿರಿ ಮತ್ತು ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಬಳಿಯಲ್ಲಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿ ತಿನ್ನಿರಿ. ಏಕೆಂದರೆ ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ನೀವು ಅದನ್ನು ಪರಿಶುದ್ಧವಾದ ಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ದಹನ ಮಾಡಿದ ಯೆಹೋವ ದೇವರ ಯಜ್ಞಗಳಲ್ಲಿ ಇವು ನಿನಗೂ ನಿನ್ನ ಪುತ್ರರಿಗೂ ಸಲ್ಲತಕ್ಕವುಗಳು. ಏಕೆಂದರೆ ಹಾಗೆ ನನಗೆ ಆಜ್ಞೆಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ನೀನೂ, ನಿನ್ನೊಂದಿಗೆ ನಿನ್ನ ಪುತ್ರರೂ ನಿನ್ನ ಪುತ್ರಿಯರೂ ನೈವೇದ್ಯ ಮಾಡಿದ ಎದೆಯ ಭಾಗವನ್ನೂ, ಅರ್ಪಿಸುವ ತೊಡೆಯ ಭಾಗವನ್ನೂ ಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ಏಕೆಂದರೆ ಅದು ಇಸ್ರಾಯೇಲರ ಸಮಾಧಾನದ ಬಲಿಗಳಲ್ಲಿ ನಿನಗೂ ನಿನ್ನ ಪುತ್ರರಿಗೂ ಸಲ್ಲುವಂಥವುಗಳಾಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ನೈವೇದ್ಯವಾಗಿ ಅರ್ಪಿಸುವ ಎದೆಯನ್ನೂ ತೊಡೆಯನ್ನೂ ಅವರು ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಕೊಬ್ಬಿನ ಸಮರ್ಪಣೆಗಳನ್ನು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸುವುದಕ್ಕೆ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ತರಬೇಕು. ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆ ಅದು ನಿನಗೂ, ನಿನ್ನೊಂದಿಗೆ ನಿನ್ನ ಪುತ್ರರಿಗೂ ನಿತ್ಯ ಕಟ್ಟಳೆಯಾಗಿ ಸಿಕ್ಕಬೇಕು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ಅನಂತರ ಮೋಶೆಯು ಶ್ರದ್ಧೆಯಿಂದ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ಹೋತವನ್ನು ಹುಡುಕಿದಾಗ, ಅದು ಸುಟ್ಟು ಹೋಗಿತ್ತು. ಅವನು ಆರೋನನ ಉಳಿದ ಪುತ್ರರಾದ ಎಲಿಯಾಜರ್ ಮತ್ತು ಈತಾಮಾರನ ಮೇಲೆ ಕೋಪಗೊಂಡು, ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದ್ದರಿಂದಲೂ ಯೆಹೋವ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅವರಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕಾಗಿಯೂ ನೀವು ಸಭೆಯ ಅಪರಾಧವನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ದೇವರು ಅದನ್ನು ಕೊಟ್ಟಿದ್ದೆಂದೂ ನೀವು ತಿಳಿದು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯನ್ನು ಪರಿಶುದ್ಧವಾದ ಸ್ಥಳದಲ್ಲಿ ಏಕೆ ತಿನ್ನಲಿಲ್ಲ? ");
INSERT INTO kanokcv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ಇಗೋ, ಅದರ ರಕ್ತವು ಪರಿಶುದ್ಧಸ್ಥಳದ ಒಳಗೆ ತರಲಿಲ್ಲವಾದ ಕಾರಣ ನಾನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ನಿಶ್ಚಯವಾಗಿ ನೀವು ಅದನ್ನು ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕಾಗಿತ್ತು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ಆಗ ಆರೋನನು ಮೋಶೆಗೆ, “ಈ ದಿನ ಅವರು ಪಾಪಪರಿಹಾರ ಬಲಿಯನ್ನು ಮತ್ತು ಅದರ ದಹನಬಲಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಿದ್ದರು. ಆದರೆ ಈ ದುಃಖ ಘಟನೆಗಳು ನನಗೆ ಸಂಭವಿಸಿದೆ. ಹೀಗಿರುವಲ್ಲಿ ಇಂದು ನಾನು ಆ ಪಾಪ ಪರಿಹಾರದ ಬಲಿದ್ರವ್ಯವನ್ನು ಊಟಮಾಡಿದ್ದರೆ, ಯೆಹೋವ ದೇವರು ಸಂತೋಷಪಡುತ್ತಿದ್ದರೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ಆಗ ಮೋಶೆಯು ಈ ಮಾತನ್ನು ಕೇಳಿದಾಗ ತೃಪ್ತಿಪಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಆರೋನರಿಗೆ ಹೀಗೆ ಹೇಳಿದರು, ");
INSERT INTO kanokcv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೀಗೆ ಹೇಳಬೇಕು: ‘ಭೂಮಿಯ ಮೇಲೆ ಇರುವ ಎಲ್ಲಾ ನೀವು ತಿನ್ನತಕ್ಕ ಪ್ರಾಣಿಗಳು ಯಾವವಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ಪ್ರಾಣಿಗಳಲ್ಲಿ ಕಾಲ್ಗೊರಸು ಸೀಳಿದ ಮತ್ತು ಮೇವನ್ನು ಮೆಲುಕಾಡಿಸುವುದನ್ನೂ ನೀವು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘ಯಾವ ಪ್ರಾಣಿ ಮೆಲುಕು ಹಾಕಿದರೂ ಗೊರಸು ಸೀಳಿರುವುದಿಲ್ಲವೋ ಮತ್ತು ಯಾವ ಪ್ರಾಣಿಯ ಗೊರಸು ಸೀಳಿದ್ದರೂ ಮೆಲುಕು ಹಾಕುವುದಿಲ್ಲವೋ ಅವುಗಳ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಬಾರದು. ಒಂಟೆಯು ಮೇವನ್ನು ಮೆಲುಕಾಡಿಸುವುದಾದರೂ ಅದಕ್ಕೆ ಸೀಳುಗೊರಸು ಇಲ್ಲ. ಅದು ನಿಮಗೆ ಅಶುದ್ಧ. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ಬೆಟ್ಟದ ಕುಣಿ ಮೊಲವು ಮೇವನ್ನು ಮೆಲುಕುಹಾಕುವುದಾದರೂ, ಆದರೂ ಸೀಳುಗೊರಸು ಇಲ್ಲವಾದದ್ದರಿಂದ ಅದು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ಮೊಲವು ಮೆಲುಕುಹಾಕುವುದಾದರೂ, ಆದರೂ ಸೀಳುಗೊರಸು ಇಲ್ಲವಾದದ್ದರಿಂದ ಅದು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ಹಂದಿಯ ಗೊರಸು ಸೀಳಿದ್ದರೂ ಅದು ಮೇವನ್ನು ಮೆಲುಕು ಹಾಕುವುದಿಲ್ಲ, ಅದು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ಅವುಗಳ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಬಾರದು. ಅವುಗಳ ಹೆಣವನ್ನು ಮುಟ್ಟಬಾರದು. ಅವು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘ನೀರಿನಲ್ಲಿ ಬಾಳುವ ಎಲ್ಲವುಗಳಲ್ಲಿ ಅಂದರೆ ಸಮುದ್ರದಲ್ಲಿ ಮತ್ತು ನದಿಯಲ್ಲಿ ಇರುವ ಈಜು ರೆಕ್ಕೆಗಳುಳ್ಳ ಮತ್ತು ಪೊರೆ ಇರುವವುಗಳನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ಸಮುದ್ರಗಳಲ್ಲಿಯೂ, ನದಿಗಳಲ್ಲಿಯೂ ನೀರೊಳಗೆ ಚಲಿಸುವ ಮತ್ತು ಜೀವಿಸುವ ಎಲ್ಲವುಗಳಲ್ಲಿ ಈಜುರೆಕ್ಕೆ ಮತ್ತು ಪೊರೆಯಿಲ್ಲದವುಗಳು ನಿಮಗೆ ನಿಷಿದ್ಧವಾಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ಅವು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿಯೇ ಇರುವವು. ನೀವು ಅವುಗಳ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು ಮತ್ತು ಅವುಗಳ ಶವಗಳು ನಿಮಗೆ ಹೇಯವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ನೀರಲ್ಲಿ ಯಾವುದಕ್ಕೆ ಈಜುರೆಕ್ಕೆ ಮತ್ತು ಪೊರೆಗಳಿಲ್ಲವೋ ಅವು ನಿಮಗೆ ಹೇಯವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘ಪಕ್ಷಿಗಳಲ್ಲಿ ಇವುಗಳು ನಿಮಗೆ ನಿಷಿದ್ಧವಾಗಿವೆ. ಇವುಗಳು ನಿಮಗೆ ಅಸಹ್ಯಕರವಾದ ಮತ್ತು ತಿನ್ನಲು ನಿಷೇಧಿಸಲಾದ ಪಕ್ಷಿಗಳು ನೀವು ತಿನ್ನಬಾರದವುಗಳು ಯಾವುವೆಂದರೆ: ಗರುಡ, ರಣಹದ್ದು, ಕಪ್ಪು ರಣಹದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ಕ್ರೌಂಚ, ಅದರ ಜಾತಿಯ ಹದ್ದು, ");
INSERT INTO kanokcv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ಅದರ ಜಾತಿಗನುಸಾರವಾದ ಪ್ರತಿಯೊಂದು ಕಾಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ಉಷ್ಟ್ರಪಕ್ಷಿ, ಚೀರು ಗೂಬೆ, ಕಡಲ ಹಕ್ಕಿ ಮತ್ತು ಅದರ ಪ್ರತಿಯೊಂದು ಜಾತಿಯ ಗಿಡುಗ. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ಸಣ್ಣ ಗೂಬೆ, ನೀರುಕಾಗೆ, ದೊಡ್ಡ ಗೂಬೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ಬಿಳಿಗೂಬೆ, ಮರಳುಗಾಡು ಗೂಬೆ, ರಣಹದ್ದು, ");
INSERT INTO kanokcv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ನೀರು ಕೋಳಿ, ಕೊಕ್ಕರೆ, ಸಕಲವಿಧವಾದ ಬಕ, ಹೆಡೆಹಕ್ಕಿ ಮತ್ತು ಬಾವಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘ನಾಲ್ಕು ಕಾಲುಗಳಿಂದ ಹರಿದಾಡುವ ಕ್ರಿಮಿಕೀಟಗಳು ನಿಮಗೆ ಹೇಯವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ಆದರೂ ಹಾರಾಡುವ, ಹರಿದಾಡುವ ನಾಲ್ಕು ಕಾಲುಗಳ ಮೇಲೆ ಹೋಗುವ, ತಮ್ಮ ಪಾದಗಳ ಮೇಲೆ ಕಾಲುಗಳಿದ್ದು, ಭೂಮಿಯ ಮೇಲೆ ದುಮುಕುವವುಗಳನ್ನೂ ನೀವು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ಮಿಡತೆಗಳನ್ನು ಜುಟ್ಟೆ ಮಿಡತೆಗಳನ್ನು ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ಆದರೆ ನಾಲ್ಕು ಪಾದವಿರುವ ಎಲ್ಲಾ ಹಾರಾಡುವ, ಹರಿದಾಡುವ ಬೇರೆಯವುಗಳು ನಿಮಗೆ ಹೇಯವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘ಇವುಗಳಿಂದ ನೀವು ಅಶುದ್ಧರಾಗುವಿರಿ. ಅಂದರೆ ಅವುಗಳ ಶವಗಳನ್ನು ಮುಟ್ಟುವವರು ಸಂಜೆಯವರೆಗೂ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ಯಾರಾದರೂ ಅವುಗಳ ಶವವನ್ನು ಹೊತ್ತರೂ, ಅವರು ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸಂಜೆಯವರೆಗೂ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘ಯಾವ ಪ್ರಾಣಿಯ ಗೊರಸು ಸ್ವಲ್ಪ ಸೀಳಿದ್ದರೂ, ಇಗ್ಗೊರಸಾಗಿಲ್ಲವೋ ಮತ್ತು ಮೆಲುಕು ಹಾಕುವುದಿಲ್ಲವೋ ಅದು ನಿಮಗೆ ಅಶುದ್ಧ. ಅವುಗಳ ಶವವನ್ನು ಮುಟ್ಟುವವರು ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ನಾಲ್ಕು ಕಾಲುಗಳ ಮೇಲೆ ಹೋಗುವ ಎಲ್ಲಾ ಬಗೆಯ ಮೃಗಗಳಲ್ಲಿ ಅಂಗಾಲಿನ ಮೇಲೆ ಹೋಗುವುದೆಲ್ಲವೂ ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿರುವುವು. ಯಾರಾದರೂ ಅವುಗಳ ಶವವನ್ನು ಮುಟ್ಟಿದರೆ ಅವರು ಸಂಜೆಯವರೆಗೂ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ಅವುಗಳ ಶವವನ್ನು ಹೊರುವವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು. ಅವರು ಸಂಜೆಯವರೆಗೂ ಅಶುದ್ಧರಾಗಿರುವರು. ಈ ಪ್ರಾಣಿಗಳು ನಿಮಗೆ ಅಶುದ್ಧವಾದವುಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವವುಗಳಲ್ಲಿ ಇವು ಸಹ ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿರಬೇಕು: ಮುಂಗುಲಿ, ಇಲಿ, ಸಕಲವಿಧವಾದ ಉಡ, ");
INSERT INTO kanokcv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ಅರೆ ಪಳಗಿಸಿದ ಪ್ರಾಣಿ, ಹಾವುರಾಣಿ, ಊಸುರುವಳ್ಳಿ, ಹಲ್ಲಿ, ಬಸವನ ಹುಳು ಮತ್ತು ಚಿಟ್ಟಿಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಇವು ನಿಮಗೆ ಅಶುದ್ಧ. ಸತ್ತಿರುವಾಗ ಅವುಗಳನ್ನು ಯಾರಾದರೂ ಮುಟ್ಟಿದರೆ ಅವರು ಸಂಜೆಯವರೆಗೂ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ಅವು ಸತ್ತು ಹೋಗಿ, ಯಾವುದರ ಮೇಲೆ ಬೀಳುವವೋ ಅವೆಲ್ಲಾ ಅಶುದ್ಧವಾಗಿರುವುದು. ಅದು ಮರದ ಪಾತ್ರೆಯೇ ಆಗಿರಲಿ, ಉಡುಪೇ ಆಗಿರಲಿ, ಚೀಲವೇ ಆಗಿರಲಿ, ಕೆಲಸ ಮಾಡುವ ಯಾವ ವಸ್ತುವಾಗಲಿ, ಅದು ಏನೇ ಆಗಿರಲಿ ಸಂಜೆಯವರೆಗೆ ನೀರಲ್ಲಿ ಇಡುವವರೆಗೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ನಂತರ ಅದು ಶುದ್ಧವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ಪ್ರತಿಯೊಂದು ಮಣ್ಣಿನ ಪಾತ್ರೆಯಲ್ಲಿ ಅವುಗಳಲ್ಲಿ ಯಾವುದಾದರೂ ಬಿದ್ದರೆ, ಅದರಲ್ಲಿ ಏನಿದ್ದರೂ ಅಶುದ್ಧವಾಗುವುದು ಮತ್ತು ನೀವು ಅದನ್ನು ಒಡೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ಅದರಲ್ಲಿರುವ ಆಹಾರ ಪದಾರ್ಥವೆಲ್ಲಾ ನೀರಿನಿಂದ ನೆನೆದಿದ್ದರೆ ಅದು ಅಶುದ್ಧವಾಗಿರುವುದು. ಅಂಥ ಪ್ರತಿ ಪಾತ್ರೆಯಲ್ಲಿ ಕುಡಿಯುವ ಎಲ್ಲಾ ಪಾನವೂ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ಅವುಗಳ ಹೆಣ ಯಾವ ಸಾಮಾನಿನ ಮೇಲೆ ಬಿದ್ದರೂ ಅದು ಅಶುದ್ಧವಾಗಿರುವುದು. ಅದು ಹರಿವಾಣವಾಗಿದ್ದರೂ, ಮಣ್ಣುಗಳ ಒಲೆಯಾಗಿದ್ದರೂ ಅದನ್ನು ಒಡೆದುಹಾಕಬೇಕು. ಏಕೆಂದರೆ ಅವು ಅಶುದ್ಧವಾಗಿವೆ. ಅವು ನಿಮಗೆ ಅಶುದ್ಧವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ನೀರು ಹೆಚ್ಚಾಗಿರುವ ಬುಗ್ಗೆಯಾಗಲಿ, ಹಳ್ಳವಾಗಲಿ ಶುದ್ಧವಾಗಿರುವುದು. ಅವುಗಳೊಳಗಿಂದ ಹೆಣಗಳನ್ನು ಎತ್ತಿದವರು ಅಶುದ್ಧರಾಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ಯಾವ ಭಾಗವಾದರೂ ಬಿತ್ತುವ ಬೀಜದಲ್ಲಿ ಬಿದ್ದರೂ ಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ಆದರೆ ನೀರು ಹಾಕಿ ನೆನಸಿದ ಬೀಜದ ಮೇಲೆ ಆ ಹೆಣವು ಬಿದ್ದರೆ, ಅದು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘ನೀವು ತಿನ್ನುವ ಯಾವುದಾದರೂ ಪ್ರಾಣಿ ಸತ್ತಿದ್ದರೆ, ಅದರ ಶವವನ್ನು ಮುಟ್ಟಿದವರು ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ಯಾರಾದರೂ ಅದರ ಮಾಂಸವನ್ನು ತಿಂದಲ್ಲಿ ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು. ಅವರು ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ಅದರ ಶವವನ್ನು ಹೊರುವವರೂ ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು. ಅವರು ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಪ್ರತಿಯೊಂದು ಕ್ರಿಮಿಯೂ ಹೇಯವಾಗಿದೆ. ಅದನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ಹೊಟ್ಟೆಯಿಂದ ಹರಿದಾಡುವ ಯಾವುದನ್ನೂ, ನಾಲ್ಕು ಕಾಲಿನ ಮೇಲೆ ನಡೆದಾಡುವ ಯಾವುದನ್ನೂ, ಇಲ್ಲವೆ ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಎಲ್ಲಾ ಕ್ರಿಮಿಗಳಲ್ಲಿ ಬಹಳ ಕಾಲುಗಳಿದ್ದ ಯಾವುದನ್ನು ನೀವು ತಿನ್ನಬಾರದು. ಏಕೆಂದರೆ ಅವು ಹೇಯವಾಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ಯಾವುದೇ ಹರಿದಾಡುವ ಪ್ರಾಣಿಯೊಡನೆಯೂ ನೀವು ನಿಮ್ಮನ್ನು ಅಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳಬಾರದು, ನೀವು ಅವುಗಳೊಂದಿಗೆ ನಿಮ್ಮನ್ನು ಅಶುದ್ಧಪಡಿಸಿಕೊಂಡು ಅವುಗಳಿಂದ ಮಲಿನರಾಗಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ಏಕೆಂದರೆ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಾನೇ. ನೀವು ನಿಮ್ಮನ್ನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಳ್ಳಿರಿ. ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವುದರಿಂದ ನೀವೂ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ಇದಲ್ಲದೆ ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಯಾವ ಬಗೆಯ ಜಂತುಗಳಿಂದಲೂ ನಿಮ್ಮನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ಏಕೆಂದರೆ ನಿಮ್ಮ ದೇವರಾಗಿರುವುದಕ್ಕೆ ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ನಿಮ್ಮನ್ನು ಹೊರಗೆ ಕರೆತಂದ ಯೆಹೋವ ದೇವರು ನಾನೇ. ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವುದರಿಂದ ನೀವು ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘ಪ್ರಾಣಿಗಳು, ಪಕ್ಷಿಗಳು, ನೀರಿನಲ್ಲಿರುವ ಮತ್ತು ನೆಲದ ಮೇಲೆ ತೆವಳುವ ಪ್ರತಿಯೊಂದು ಜೀವಿಗಳಿಗೆ ಕುರಿತಾದ ನಿಯಮವು ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ಅಶುದ್ಧ ಮತ್ತು ಶುದ್ಧಗಳ ನಡುವಿನ ವ್ಯತ್ಯಾಸವನ್ನೂ ಮತ್ತು ತಿನ್ನಲರ್ಹವಾದ ಮೃಗ ಮತ್ತು ತಿನ್ನಬಾರದ ಮೃಗಗಳ ನಡುವಿನ ವ್ಯತ್ಯಾಸವನ್ನು ಹೀಗೆ ತಿಳಿದುಕೊಳ್ಳುವಿರಿ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೀಗೆ ಹೇಳು: ‘ಒಬ್ಬ ಸ್ತ್ರೀಯು ಗರ್ಭಧರಿಸಿ, ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತರೆ, ಅವಳು ಏಳು ದಿನಗಳು ಅಶುದ್ಧಳಾಗಿರಬೇಕು. ತನ್ನ ಮುಟ್ಟಿಗಾಗಿ ಪ್ರತ್ಯೇಕಿಸಿದ ದಿನಗಳ ಪ್ರಕಾರ ಅವಳು ಅಶುದ್ಧಳಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಮಗುವಿಗೆ ಸುನ್ನತಿ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ಅವಳು ಮೂವತ್ತಮೂರು ದಿನಗಳು ಶುದ್ಧೀಕರಣದಲ್ಲಿ ಮುಂದುವರಿಯಬೇಕು. ಅವಳ ಶುದ್ಧೀಕರಣದ ದಿನಗಳು ಪೂರೈಸುವ ತನಕ ಅವಳು ಪರಿಶುದ್ಧವಾದದ್ದನ್ನು ಮುಟ್ಟಬಾರದು, ಇಲ್ಲವೆ ಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೆ ಬರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ಅವಳು ಹೆಣ್ಣು ಮಗುವನ್ನು ಹೆತ್ತರೆ, ಅವಳು ಮುಟ್ಟಿನಲ್ಲಿರುವಂತೆ ಎರಡು ವಾರಗಳು ಅಶುದ್ಧಳಾಗಿರಬೇಕು. ಅವಳು ಅರವತ್ತಾರು ದಿನಗಳು ಶುದ್ಧೀಕರಣದಲ್ಲಿ ಮುಂದುವರಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘ಮಗನಿಗಾಗಿ ಇಲ್ಲವೆ ಮಗಳಿಗಾಗಿ ಅವಳ ಶುದ್ಧ ದಿನಗಳು ಪೂರ್ತಿಯಾದರೆ, ಅವಳು ದಹನಬಲಿಗಾಗಿ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಯನ್ನೂ, ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಪಾರಿವಾಳದ ಮರಿಯನ್ನೂ, ಇಲ್ಲವೆ ಬೆಳವಕ್ಕಿಯನ್ನೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ಅವನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಅದನ್ನು ಅರ್ಪಿಸಿ, ಅವಳಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ಆಗ ಅವಳು ತನ್ನ ರಕ್ತಸ್ರಾವದಿಂದಾದ ಅಶುದ್ಧತೆಯಿಂದ ಶುದ್ಧಳಾಗುವಳು. “ ‘ಗಂಡು ಮಗುವನ್ನಾಗಲಿ, ಹೆಣ್ಣು ಮಗುವನ್ನಾಗಲಿ ಹೆತ್ತವಳಿಗೆ ನಿಯಮವು ಇದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ಅವಳು ಕುರಿಮರಿಯನ್ನು ತರಲು ಅಶಕ್ತಳಾಗಿದ್ದರೆ, ಅವಳು ದಹನಬಲಿಗಾಗಿ ಒಂದು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ, ಇನ್ನೊಂದು ಎಂಬಂತೆ ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನು ಇಲ್ಲವೆ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನು ತರಬೇಕು ಮತ್ತು ಯಾಜಕನು ಅವಳಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಆಗ ಅವಳು ಶುದ್ಧಳಾಗುವಳು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಮತ್ತು ಆರೋನರೊಡನೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ಒಬ್ಬ ಮನುಷ್ಯನು ತನ್ನ ಚರ್ಮದ ಮೇಲೆ ಬಾವಾಗಲಿ, ಕಜ್ಜಿಯಾಗಲಿ, ಹೊಳಪಿನ ಮಚ್ಚೆಯಾಗಲಿ ಮತ್ತು ಅವನ ಚರ್ಮದಲ್ಲಿ ಕುಷ್ಠದ ವ್ಯಾಧಿಯಂತಿದ್ದರೆ, ಅವನು ಯಾಜಕನಾದ ಆರೋನನ ಬಳಿಗಾದರೂ ಇಲ್ಲವೆ ಯಾಜಕರಾದ ಅವನ ಪುತ್ರರಲ್ಲಿ ಒಬ್ಬನ ಬಳಿಗಾದರೂ ಕರೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ಯಾಜಕನು ಚರ್ಮದ ಮೇಲಿರುವ ವ್ಯಾಧಿಯನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ವ್ಯಾಧಿಯಲ್ಲಿನ ಕೂದಲು ಬೆಳ್ಳಗಾದರೆ, ಆ ವ್ಯಾಧಿಯು ಅವನ ಚರ್ಮಕ್ಕಿಂತಲೂ ಆಳವಾಗಿ ಕಂಡರೆ, ಅದು ಚರ್ಮರೋಗವಾಗಿರುವುದು. ಆಗ ಯಾಜಕನು ಅವನನ್ನು ನೋಡಿ ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ಅವನ ಚರ್ಮದಲ್ಲಿ ಬಿಳುಪಾದ ಮಚ್ಚೆಯಿದ್ದು, ಅದು ನೋಡುವುದಕ್ಕೆ ಚರ್ಮಕ್ಕಿಂತಲೂ ಆಳವಾಗಿದ್ದು, ಅಲ್ಲಿನ ಕೂದಲು ಬೆಳ್ಳಗಾಗದಿದ್ದರೆ ಯಾಜಕನು ಆ ವ್ಯಾಧಿಯವನನ್ನು ಏಳು ದಿನ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ಯಾಜಕನು ಏಳನೆಯ ದಿನದಲ್ಲಿ ಅವನನ್ನು ಪರೀಕ್ಷಿಸಿದಾಗ, ಆ ವ್ಯಾಧಿ ನಿಂತ ಹಾಗೆ ಕಾಣಿಸಿದರೆ, ಆ ವ್ಯಾಧಿ ಚರ್ಮದಲ್ಲಿ ಹರಡಿರದಿದ್ದರೆ, ಯಾಜಕನು ಅವನನ್ನು ಇನ್ನೂ ಏಳು ದಿನಗಳು ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ಯಾಜಕನು ಅವನನ್ನು ಏಳನೆಯ ದಿನದಲ್ಲಿ ಪರೀಕ್ಷಿಸಬೇಕು. ಆಗ ವ್ಯಾಧಿಯು ಸ್ವಲ್ಪ ಕಪ್ಪಾಗಿದ್ದು, ಚರ್ಮದಲ್ಲೆಲ್ಲಾ ಹರಡಿರದಿದ್ದರೆ ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ಅದು ಬರೀ ಕಜ್ಜಿಯಾದ ಕಾರಣ ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ಅವನು ತನ್ನ ಶುದ್ಧಿಗಾಗಿ ಯಾಜಕನಿಗೆ ತೋರಿಸಿಕೊಂಡ ಮೇಲೆ ಕಜ್ಜಿಯು ಚರ್ಮದ ಹೊರಗೆಲ್ಲಾ ಹೆಚ್ಚಾಗಿ ಹಬ್ಬಿದರೆ, ಅವನು ತಿರುಗಿ ಯಾಜಕನಿಗೆ ತೋರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಿದಾಗ, ಕಜ್ಜಿಯ ಚರ್ಮವೇ ಹರಡಿರುವುದಾದರೆ ಆಗ ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ಏಕೆಂದರೆ ಅದು ಚರ್ಮರೋಗವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ಚರ್ಮರೋಗವು ಮನುಷ್ಯನಲ್ಲಿ ಇರುವುದಾದರೆ, ಅವನನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ಆಗ ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು, ಆ ಬಾವು ಚರ್ಮದಲ್ಲಿ ಬೆಳ್ಳಗಿದ್ದು, ಅದರ ಕೂದಲು ಬೆಳ್ಳಗಾಗಿ ಹೋಗಿದ್ದರೆ ಮತ್ತು ಆ ಬಾವಿನಲ್ಲಿ ಹಸಿ ಮಾಂಸವು ಇದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ಅದು ಅವನ ಚರ್ಮದಲ್ಲಿ ದೀರ್ಘಕಾಲದ ಚರ್ಮರೋಗವಾಗಿರುವುದು. ಆಗ ಯಾಜಕನು ಅವನು ಅಶುದ್ಧನೆಂದು ನುಡಿಯಬೇಕು ಮತ್ತು ಅವನನ್ನು ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸದೆ ಆಗಲೇ ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“ಒಬ್ಬನಲ್ಲಿ ಸಾಂಕ್ರಾಮಿಕ ಚರ್ಮರೋಗ ಹತ್ತಿದರೆ ಮತ್ತು ಚರ್ಮವನ್ನೆಲ್ಲಾ ಹರಡಿಕೊಂಡು ತಲೆಯಿಂದ ಪಾದದವರೆಗೂ ಹರಡಿವುದುನ್ನು ಯಾಜಕನು ಪರೀಕ್ಷಿಸಿದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ಆಗ ಯಾಜಕನು ಅದನ್ನು ಗಮನಿಸಬೇಕು. ತೊನ್ನು ಹತ್ತಿದರೆ, ಅವನ ಮೈಯೆಲ್ಲವನ್ನು ಹರಡಿಕೊಂಡಿದ್ದರೆ, ಅವನು ವ್ಯಾಧಿಯಿಂದ ಶುದ್ಧನಾಗಿರುವನೆಂದು ನುಡಿಯಬೇಕು. ಅದು ಪೂರ್ತಿ ಬೆಳ್ಳಗಾಗಿರುವುದರಿಂದ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ಆದರೆ ಹಸಿ ಮಾಂಸವು ಅವನಲ್ಲಿ ಕಾಣಿಸಿಕೊಂಡರೆ ಅವನು ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ಯಾಜಕನು ಹಸಿ ಮಾಂಸವನ್ನು ಪರೀಕ್ಷಿಸಿ ಅವನು ಅಶುದ್ಧನೆಂದು ನುಡಿಯಬೇಕು. ಏಕೆಂದರೆ ಹಸಿ ಮಾಂಸವು ಅಶುದ್ಧವಾದದ್ದು, ಅದು ಅಶುದ್ಧಗೊಳಿಸುವ ಚರ್ಮರೋಗವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ಹಸಿ ಮಾಂಸವು ಮತ್ತೆ ಬದಲಾಗಿ ಬೆಳ್ಳಗಾದರೆ, ಅವನು ಯಾಜಕನ ಬಳಿಗೆ ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ಆಗ ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸಿ, ಆ ವ್ಯಾಧಿಯು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ, ಯಾಜಕನು, ಅವನು ವ್ಯಾಧಿಯಿಂದ ಶುದ್ಧನಾಗಿರುವನೆಂದು ನುಡಿಯಬೇಕು. ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ಆ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಹುಣ್ಣು ಉಂಟಾಗಿ ವಾಸಿಯಾದರೂ ");
INSERT INTO kanokcv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ಆ ಹುಣ್ಣಿನ ಜಾಗದಲ್ಲಿ ಬಿಳಿಯ ಊತವಾಗಲಿ ಇಲ್ಲವೆ ಬಿಳುಪಾದ ಮಚ್ಚೆಯಾಗಲಿ, ಕೆಂಪು ಮಿಶ್ರಿತ ಕಲೆ ಉಂಟಾದರೆ ಅದನ್ನು ಯಾಜಕನಿಗೆ ತೋರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಿದಾಗ, ಅದು ಚರ್ಮದಿಂದ ಕೆಳಗೆ ಕಂಡರೆ ಮತ್ತು ಅಲ್ಲಿಯ ಕೂದಲು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ, ಯಾಜಕನು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ನುಡಿಯಬೇಕು. ಅದು ಹುಣ್ಣಿನಿಂದ ಒಡೆದುಹೋದ ಚರ್ಮರೋಗವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ಆದರೆ ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಲು, ಅದರಲ್ಲಿ ಬಿಳಿಯ ಕೂದಲು ಇರದಿದ್ದರೆ ಮತ್ತು ಅದು ಚರ್ಮಕ್ಕಿಂತಲೂ ತಗ್ಗಾಗದಿದ್ದರೆ ಮತ್ತು ಸ್ವಲ್ಪ ಮಬ್ಬಾಗಿದ್ದರೆ, ಆಗ ಯಾಜಕನು ಅವನನ್ನು ಏಳು ದಿನಗಳು ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ಅದು ಚರ್ಮದ ಹೊರಗೆಲ್ಲಾ ಹೆಚ್ಚಾಗಿ ಹರಡಿದ್ದರೆ, ಯಾಜಕನು ಅವನು ಅಶುದ್ಧನೆಂದು ನುಡಿಯಬೇಕು. ಅದು ಚರ್ಮರೋಗವಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ಆದರೆ ಆ ಹೊಳಪಾದ ಕಲೆಯು ಹರಡದೆ ಅದೇ ಸ್ಥಳದಲ್ಲಿ ಇದ್ದು, ಅದು ಉರಿಯುವ ಹುಣ್ಣಾಗಿದ್ದರೂ ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನುಡಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ಅವನ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಬೆಂಕಿಯ ಬೊಬ್ಬೆಯು ಉಂಟಾಗಿ ಆ ಬೊಬ್ಬೆಯ ಸಹ ಮಾಂಸವು ಬಿಳುಪಾದ ಇಲ್ಲವೆ ಸ್ವಲ್ಪ ಕೆಂಪಗೆ, ಬಿಳಿಯ ಹೊಳಪಾದ ಕಲೆಯಾಗಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಆ ಹೊಳಪಾದ ಕಲೆಯ ಮೇಲೆ ಕೂದಲು ಬಿಳುಪಾಗಿ ತಿರುಗಿದ್ದರೆ ಮತ್ತು ಅದು ನೋಡುವುದಕ್ಕೆ ಚರ್ಮಕ್ಕಿಂತಲೂ ಆಳವಾಗಿದ್ದರೆ, ಅದು ಬೊಬ್ಬೆಯಿಂದ ಒಡೆದ ಚರ್ಮರೋಗವಾಗಿರುವುದು. ಆದಕಾರಣ ಅವನು ಅಶುದ್ಧನೆಂದು ಯಾಜಕನು ನುಡಿಯಬೇಕು. ಅದು ಚರ್ಮವ್ಯಾಧಿಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ಆದರೆ ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಿದಾಗ, ಆ ಹೊಳಪಾದ ಮಚ್ಚೆಯ ಮೇಲೆ ಕೂದಲು ಬೆಳ್ಳಗಾಗದಿದ್ದರೆ ಮತ್ತು ಅದು ಚರ್ಮಕ್ಕಿಂತಲೂ ಆಳವಾಗಿರದೆ ಸ್ವಲ್ಪ ಮೋಟಾಗಿದ್ದರೆ, ಯಾಜಕನು ಆಗ ಅವನನ್ನು ಏಳು ದಿನಗಳ ಕಾಲ ಮುಚ್ಚಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ಯಾಜಕನು ಅವನನ್ನು ಏಳನೆಯ ದಿನದಲ್ಲಿ ಪರೀಕ್ಷಿಸಬೇಕು. ಆಗ ಅದು ಚರ್ಮದ ಹೊರಗೆಲ್ಲಾ ಹೆಚ್ಚಾಗಿ ಹರಡಿದ್ದರೆ, ಯಾಜಕನು ಆಗ ಅವನು ಅಶುದ್ಧನೆಂದು ಹೇಳಬೇಕು. ಅದು ಚರ್ಮರೋಗ. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ಆ ಹೊಳಪಾದ ಕಲೆಯು ಅದೇ ಸ್ಥಳದಲ್ಲಿ ಉಳಿದಿದ್ದರೆ ಮತ್ತು ಚರ್ಮದಲ್ಲಿ ಹರಡದೆ ಸ್ವಲ್ಪ ಮಬ್ಬಾಗಿದ್ದರೆ, ಬೆಂಕಿ ಸುಟ್ಟ ಬೊಬ್ಬೆಯ ಊತವೆಂದು ಮತ್ತು ಅವನು ಶುದ್ಧನೆಂದು ಯಾಜಕನು ನುಡಿಯಬೇಕು. ಏಕೆಂದರೆ ಅದು ಬೆಂಕಿಯ ಬೊಬ್ಬೆಯಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ಒಬ್ಬ ಪುರುಷನಿಗಾಗಲಿ ಇಲ್ಲವೆ ಸ್ತ್ರೀಗಾಗಲಿ ವ್ಯಾಧಿಯು ತಲೆಯ ಮೇಲಾಗಲಿ, ಗಡ್ಡದ ಮೇಲಾಗಲಿ ಕಲೆ ಇದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ಆಗ ಯಾಜಕನು ಆ ವ್ಯಾಧಿಯನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಅದು ನೋಡುವುದಕ್ಕೆ ಚರ್ಮಕ್ಕಿಂತಲೂ ಆಳವಾಗಿದ್ದರೆ ಮತ್ತು ಅದರಲ್ಲಿ ಹಳದಿಯ ತೆಳ್ಳನೆಯ ಕೂದಲಿದ್ದರೆ, ಯಾಜಕನು ಆಗ ಅವನು ಅಶುದ್ಧನೆಂದು ಹೇಳಬೇಕು. ಅದು ತಲೆಯ ಮೇಲಾಗಲಿ ಇಲ್ಲವೆ ಗಡ್ಡದ ಮೇಲಾಗಲಿ ಇರುವ ಚರ್ಮರೋಗವಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ಯಾಜಕನು ಆ ಇಸಬಿನ ವ್ಯಾಧಿಯನ್ನು ನೋಡಿದಾಗ, ಅದು ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತಲೂ ಆಳವಾಗಿರದಿದ್ದರೆ ಮತ್ತು ಕಪ್ಪುಕೂದಲು ಇರದಿದ್ದರೆ, ಯಾಜಕನು ಆಗ ಆ ಇಸಬಿನ ವ್ಯಾಧಿಯವನನ್ನು ಏಳು ದಿನಗಳ ಕಾಲ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಆ ವ್ಯಾಧಿಯನ್ನು ಪರೀಕ್ಷಿಸಿದಾಗ, ಆ ಇಸಬು ಹರಡದೆ ಮತ್ತು ಅದರಲ್ಲಿ ಹಳದಿ ಕೂದಲು ಇರದೆ, ಆ ಇಸಬು ಮಿಕ್ಕ ಚರ್ಮಕ್ಕಿಂತಲೂ ಆಳವಾಗಿ ಕಾಣದಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ಅವನು ಕ್ಷೌರ ಮಾಡಿಸಿಕೊಳ್ಳಲಿ. ಆದರೆ ಅವನು ಇಸಬನ್ನು ಕ್ಷೌರ ಮಾಡಬಾರದು. ಯಾಜಕನು ಆ ಇಸಬಿನವನನ್ನು ಏಳು ದಿನ ಹೆಚ್ಚಾಗಿ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಆ ಇಸಬನ್ನು ನೋಡಬೇಕು. ಆ ಇಸಬು ಚರ್ಮದಲ್ಲಿ ಹರಡಿರದಿದ್ದರೆ ಇಲ್ಲವೆ ನೋಡಲು ಅದು ಮಿಕ್ಕ ಚರ್ಮಕ್ಕಿಂತಲೂ ತಗ್ಗಾಗಿರದಿದ್ದರೆ, ಯಾಜಕನು ಆಗ ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನುಡಿಯಬೇಕು, ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಶುದ್ಧನಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ಆದರೆ ಅವನು ಶುದ್ಧನಾದ ಮೇಲೆ ಆ ಇಸಬು ಚರ್ಮದಲ್ಲಿ ಹೆಚ್ಚಾಗಿ ಹರಡಿರದಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ಯಾಜಕನು ಆಗ ಅವನನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು, ಆ ಇಸಬು ಚರ್ಮದಲ್ಲಿ ಹರಡಿದ್ದರೆ, ಯಾಜಕನು ಹಳದಿ ಕೂದಲಿಗಾಗಿ ವಿಚಾರಿಸದಿರಲಿ. ಅವನು ಅಶುದ್ಧನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ಆದರೆ ಆ ಇಸಬು ಅವನಿಗೆ ನಿಂತ ಹಾಗೆ ಕಂಡರೆ ಮತ್ತು ಅದರಲ್ಲಿ ಕಪ್ಪುಕೂದಲು ಬೆಳೆದರೆ, ಇಸಬು ವಾಸಿಯಾಗಿ ಅವನು ಶುದ್ಧನಾಗುವನು, ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನುಡಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ಒಬ್ಬ ಪುರುಷನಿಗಾಗಲಿ ಇಲ್ಲವೆ ಸ್ತ್ರೀಗಾಗಲಿ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಬಿಳಿಯ ಹೊಳಪಾದ ಮಚ್ಚೆಗಳು ಅಲ್ಲಲ್ಲಿ ಇದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ಅವುಗಳನ್ನು ಯಾಜಕನು ಪರೀಕ್ಷಿಸಬೇಕು, ಅವರ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಹೊಳಪಾದ ಕಲೆಗಳು ಮಬ್ಬಾಗಿ ಬಿಳುಪಾಗಿದ್ದರೆ, ಅದು ಚರ್ಮದ ಮೇಲೆ ಬಿಸಿಲಿನಿಂದಾದ ಕೆಂಪು ಮಚ್ಚೆಯಾಗಿರುವುದು. ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ಒಬ್ಬ ಗಂಡಸಿನ ತಲೆಯ ಕೂದಲು ಉದುರಿ ಹೋದರೆ, ಅವನು ಬೋಳು ತಲೆಯವನು. ಆದರೂ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ಮುಂದಲೆಯ ಭಾಗದಲ್ಲಿ ಕೂದಲು ಉದುರಿ ಹೋಗಿದ್ದರೆ, ಅವನು ಪಟ್ಟೆ ತಲೆಯವನು, ಆದರೂ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ಆದರೆ ಆ ಬೋಳು ತಲೆಯಲ್ಲಿ ಇಲ್ಲವೆ ಪಟ್ಟೆ ತಲೆಯಲ್ಲಿ ಕೆಂಪಗಿರುವ ಬಿಳುಪಾದ ಮಚ್ಚೆಯಿದ್ದರೆ, ಅದು ಅವನ ಬೋಳು ತಲೆಯಲ್ಲಾಗಲಿ ಇಲ್ಲವೆ ಪಟ್ಟೆ ತಲೆಯಲ್ಲಾಗಲಿ ಹುಟ್ಟುತ್ತಿರುವ ಚರ್ಮರೋಗವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ಆಗ ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಅವನ ಬೋಳು ತಲೆಯಲ್ಲಾಗಲಿ, ಇಲ್ಲವೆ ಅವನ ಪಟ್ಟೆ ತಲೆಯಲ್ಲಾಗಲಿ ಏಳುತ್ತಿರುವ ಆ ಕಲೆಯು ಬಿಳುಪಾಗಿ ಕೆಂಪಾಗಿದ್ದರೆ ಮತ್ತು ಮಾಂಸದ ತೊಗಲಿನಲ್ಲಿ ಇರುವ ಚರ್ಮರೋಗದ ಹಾಗಿದ್ದರೆ, ಅವನು ರೋಗಿ ಎಂದೂ ಅಶುದ್ಧನೆಂದೂ ");
INSERT INTO kanokcv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ಅವನ ವ್ಯಾಧಿಯು ಅವನ ತಲೆಯಲ್ಲಿ ಕಾಣಿಸಿದ್ದರಿಂದ ಅವನು ಖಂಡಿತವಾಗಿ ಅಶುದ್ಧನೆಂದೂ ಯಾಜಕನು ಹೇಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ಚರ್ಮರೋಗ ಇರುವ ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡವನಾಗಿ, ತಲೆಗೂದಲನ್ನು ಕೆದರಿಕೊಂಡು, ಮುಖದ ಕೆಳಭಾಗವನ್ನು ಮುಚ್ಚಿಕೊಂಡು, ‘ನಾನು ಅಶುದ್ಧನು, ಅಶುದ್ಧನು,’ ಎಂದು ಕೂಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ಆ ವ್ಯಾಧಿ ಅವನಲ್ಲಿ ಇರುವಷ್ಟು ದಿನಗಳೂ ಅವನು ಅಶುದ್ಧನಾಗಿರುವನು. ಅವನು ಪಾಳೆಯದ ಹೊರಗೆ ಒಂಟಿಯಾಗಿ ವಾಸಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ಬೂಜು ಚರ್ಮರೋಗದ ಗುರುತು ಅವನ ಉಡುಪಿನಲ್ಲೂ ಇದ್ದು, ಅದು ಉಣ್ಣೆಯ ಉಡುಪಾಗಲಿ ಇಲ್ಲವೆ ನಾರಿನ ಉಡುಪಾಗಲಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ನಾರಿನ ಇಲ್ಲವೆ ಉಣ್ಣೆಯ ಹಾಸಿನಲ್ಲಾಗಲಿ, ಹೊಕ್ಕಿನಲ್ಲಾಗಲಿ, ಚರ್ಮದಲ್ಲಾಗಲಿ, ಚರ್ಮದಿಂದ ಮಾಡಿದ ಯಾವ ವಸ್ತುವಿನಲ್ಲಾಗಲಿ ಇದಲ್ಲದೆ ಹಸುರಾಗಿ ಇಲ್ಲವೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ಆ ಬಟ್ಟೆ ತೊಗಲು ಹಾಸು ಇಲ್ಲವೆ ಚರ್ಮದಿಂದ ಮಾಡಿದ ಯಾವ ವಸ್ತುವಿನಲ್ಲಾಗಲಿ, ಹಸುರಾಗಿ ಇಲ್ಲವೆ ಕೆಂಪಾಗಿ ಇದ್ದರೆ ಅದು ಬೂಜಾಗಿದೆ. ಅದನ್ನು ಯಾಜಕನಿಗೆ ತೋರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಿ, ಆ ವಸ್ತುವನ್ನು ಏಳು ದಿನಗಳು ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ಅವನು ಏಳನೆಯ ದಿನದಲ್ಲಿ ಅದನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಆ ಬೂಜು ಅವನ ಉಣ್ಣೆ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ನಾರಿನ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ನೇಯ್ಗೆಯಲ್ಲಾಗಲಿ, ಹೆಣಿಗೆಯಲ್ಲಾಗಲಿ, ತೊಗಲಿನ ವಸ್ತುವಿನ್ನಾಗಲಿ ಹರಡಿದ್ದರೆ ಅದು ನಾಶಕರವಾದ ಬೂಜುರೋಗವಾಗಿದೆ. ಅದು ಅಶುದ್ಧವು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ಆದ್ದರಿಂದ ಅವನು ಆ ಉಡುಪುಗಳನ್ನು ಅಂದರೆ ಅದು ಉಣ್ಣೆ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ನಾರಿನ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ನೇಯ್ಗೆಯಲ್ಲಾಗಲಿ, ಹಣಿಗೆಯಲ್ಲಾಗಲಿ, ತೊಗಲಿನ ವಸ್ತುವಿನ್ನಾಗಲಿ ಎಲ್ಲಿ ಬೂಜಿದೆಯೋ ಅದನ್ನು ಸುಡಬೇಕು. ಏಕೆಂದರೆ ಅದು ನಾಶಕರವಾದ ಬೂಜುರೋಗವಾಗಿದೆ. ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ಯಾಜಕನು ಪರೀಕ್ಷಿಸಿದಾಗ ಬೂಜು ಉಡುಪಿನಲ್ಲಾಗಲಿ, ಹಾಸಿನಲ್ಲಾಗಲಿ, ಹೊಕ್ಕಿನಲ್ಲಾಗಲಿ, ತೊಗಲಿನ ವಸ್ತುಗಳಲ್ಲಾಗಲಿ ಹರಡದಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ಆಗ ಯಾಜಕನು ಆ ಬೂಜುಳ್ಳ ವಸ್ತುವನ್ನು ತೊಳೆಯುವಂತೆ ಆಜ್ಞಾಪಿಸಿ, ಅದನ್ನು ಅವನು ಏಳು ದಿನಗಳ ಕಾಲ ಹೆಚ್ಚಾಗಿ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ಅದನ್ನು ತೊಳೆದಾದ ಮೇಲೆ ಯಾಜಕನು ಆ ಬೂಜನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಆ ಬೂಜು ಬಣ್ಣವನ್ನು ಬದಲಾಯಿಸದಿದ್ದರೆ ಮತ್ತು ಹರಡದಿದ್ದರೆ ಅದು ಅಶುದ್ಧವಾಗಿರುವುದು. ಅದನ್ನು ನೀನು ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ಅದು ಒಳಗಿನಿಂದಾಗಲಿ ಇಲ್ಲವೆ ಹೊರಗಿನಿಂದಾಗಲಿ ವ್ಯಾಪಿಸಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಿದರೆ, ಆ ಬೂಜು ಹಿಡಿದ ವಸ್ತುವನ್ನು ತೊಳೆದ ನಂತರ ಮಬ್ಬಾಗಿದ್ದರೆ ಅವನು ಅದನ್ನು ಬಟ್ಟೆಯಿಂದಾಗಲಿ, ಚರ್ಮದಿಂದಾಗಲಿ, ಹಾಸಿನಿಂದಾಗಲಿ, ಹೊಕ್ಕಿನಿಂದಾಗಲಿ ಹರಿದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ಆದರೆ ಉಣ್ಣೆ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ನಾರಿನ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ನೇಯ್ಗೆಯಲ್ಲಾಗಲಿ ಹಣಿಗೆಯಲ್ಲಾಗಲಿ, ತೊಗಲಿನ ವಸ್ತುವಿನಲ್ಲಾಗಲಿ ಕಂಡು ಬಂದರೆ ಅದು ಹರಡುವ ಬೂಜು ಮತ್ತು ಬೂಜಿರುವ ವಸ್ತುವನ್ನು ನೀನು ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ನೀನು ತೊಳೆದ ಮೇಲೆ ಆ ಬೂಜು ಯಾವ ವಸ್ತುವಿನಿಂದ ಹೊರಟು ಹೋಯಿತೋ, ಆ ಬಟ್ಟೆಯನ್ನೂ, ಹಾಸನ್ನೂ, ಹೊಕ್ಕನ್ನೂ ಇಲ್ಲವೆ ಚರ್ಮದ ಯಾವುದೇ ಸಾಮಗ್ರಿಗಳನ್ನೂ ಎರಡನೆಯ ಸಾರಿ ತೊಳೆಯಬೇಕು. ಆಗ ಅದು ಶುದ್ಧವಾಗಿರುವುದು.” ");
INSERT INTO kanokcv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ಉಣ್ಣೆ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ ನಾರಿನ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ನೇಯ್ಗೆಯಲ್ಲಾಗಲಿ, ಹಣಿಗೆಯಲ್ಲಾಗಲಿ, ತೊಗಲಿನ ವಸ್ತುವಿನ್ನಾಗಲಿ ಬೂಜು ಹಿಡಿದಿದ್ದರೆ ಪಾಲಿಸತಕ್ಕ ನಿಯಮಗಳಿವು. ಅದನ್ನು ಶುದ್ಧವೆಂದು ಇಲ್ಲವೆ ಅಶುದ್ಧವೆಂದು ನುಡಿಯುವುದಕ್ಕೆ ವಿಧಿಯು ಇಲ್ಲವೆ ಅಶುದ್ಧವೆಂದು ನುಡಿಯುವುದಕ್ಕೆ ವಿಧಿಯು ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“ಚರ್ಮರೋಗಿಯು ತನ್ನ ಶುದ್ಧತೆಯ ದಿನದಲ್ಲಿ ಮಾಡತಕ್ಕ ನಿಯಮವು ಇದೇ. ಅವನನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ಯಾಜಕನು ಪಾಳೆಯದ ಆಚೆಗೆ ಹೊರಟು ಹೋಗಬೇಕು. ಚರ್ಮರೋಗದಿಂದ ರೋಗಿಯು ಗುಣವಾದನೆಂದು ಯಾಜಕನು ಪರೀಕ್ಷಿಸಿದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ಆಗ ಶುದ್ಧಮಾಡಿಕೊಳ್ಳುವವನಿಗೋಸ್ಕರ ಜೀವವುಳ್ಳ ಮತ್ತು ಶುದ್ಧವಾದ ಎರಡು ಪಕ್ಷಿಗಳನ್ನೂ, ದೇವದಾರು ಕಟ್ಟಿಗೆಯನ್ನೂ, ರಕ್ತವರ್ಣದ ದಾರವನ್ನೂ ಮತ್ತು ಹಿಸ್ಸೋಪನ್ನೂ ತೆಗೆದುಕೊಳ್ಳುವಂತೆ ಯಾಜಕನು ಆಜ್ಞಾಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ಆ ಪಕ್ಷಿಗಳಲ್ಲಿ ಒಂದನ್ನು ಹರಿಯುವ ನೀರಿನ ಮೇಲೆ ಮಣ್ಣಿನ ಪಾತ್ರೆಯಲ್ಲಿ ಕೊಲ್ಲಬೇಕೆಂದು ಯಾಜಕನು ಆಜ್ಞಾಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ಇದಲ್ಲದೆ ಜೀವವುಳ್ಳ ಪಕ್ಷಿಯನ್ನೂ, ದೇವದಾರು ಕಟ್ಟಿಗೆಯನ್ನೂ, ರಕ್ತವರ್ಣದ ದಾರವನ್ನೂ ಮತ್ತು ಹಿಸ್ಸೋಪನ್ನೂ ತೆಗೆದುಕೊಂಡು, ಹರಿಯುವ ನೀರಿನ ಬಳಿಯಲ್ಲಿ ವಧಿಸಿದ ಆ ಪಕ್ಷಿಯ ರಕ್ತದಲ್ಲಿ ಅದ್ದಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ಚರ್ಮರೋಗದಿಂದ ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನ ಮೇಲೆ ಏಳು ಸಾರಿ ಚಿಮುಕಿಸಿ, ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನುಡಿದು, ಆ ಜೀವವುಳ್ಳ ಪಕ್ಷಿಯನ್ನು ಬಯಲಾದ ಹೊಲದಲ್ಲಿ ಬಿಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“ಶುದ್ಧವಾಗುವುದಕ್ಕಿರುವವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡವನಾಗಿ, ತನ್ನ ಎಲ್ಲಾ ಕೂದಲನ್ನು ಬೋಳಿಸಿಕೊಂಡು, ತಾನು ಶುದ್ಧನಾಗುವಂತೆ ತನ್ನನ್ನು ನೀರಿನಲ್ಲಿ ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ತರುವಾಯ ಅವನು ಪಾಳೆಯದೊಳಗೆ ಬಂದು ತನ್ನ ಡೇರೆಯೊಳಗೆ ಏಳು ದಿನಗಳವರೆಗೆ ಕಾಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ಆದರೆ ಏಳನೆಯ ದಿನದಲ್ಲಿ ಅವನು ತನ್ನ ತಲೆಯ ಎಲ್ಲಾ ಕೂದಲನ್ನೂ, ಗಡ್ಡವನ್ನೂ, ತನ್ನ ಕಣ್ಣುಹುಬ್ಬುಗಳನ್ನೂ ಮಾತ್ರವಲ್ಲದೆ ತನ್ನ ಎಲ್ಲಾ ಕೂದಲನ್ನೂ ಬೋಳಿಸಿಕೊಳ್ಳಬೇಕು. ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಇದಲ್ಲದೆ ತನ್ನ ದೇಹವನ್ನು ಸಹ ನೀರಿನಲ್ಲಿ ತೊಳೆಯಬೇಕು. ಆಗ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“ಎಂಟನೆಯ ದಿವಸದಲ್ಲಿ ಅವನು ಕಳಂಕರಹಿತವಾದ ಎರಡು ಕುರಿಮರಿಗಳನ್ನು ಮತ್ತು ಒಂದು ವರುಷದ ಕಳಂಕರಹಿತವಾದ ಹೆಣ್ಣು ಕುರಿಯನ್ನು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಕಲಸಿದ ಐದು ಕಿಲೋಗ್ರಾಂ ಗೋಧಿ ಹಿಟ್ಟನ್ನು, ಒಂದನೆಯ ಮೂರು ಭಾಗ ಎಣ್ಣೆಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ಅವನನ್ನು ಶುದ್ಧಪಡಿಸುವ ಯಾಜಕನು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನನ್ನು ಇವುಗಳೊಂದಿಗೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿಯಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“ಆಗ ಯಾಜಕನು ಒಂದು ಗಂಡು ಕುರಿಮರಿಯನ್ನೂ, ಒಂದನೆಯ ಮೂರು ಭಾಗದಷ್ಟು ಎಣ್ಣೆಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯಾಗಿ ಅರ್ಪಿಸಿ, ಅವುಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ಇದಲ್ಲದೆ ಅವನು ಆ ಕುರಿಮರಿಯನ್ನು ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯನ್ನು, ದಹನಬಲಿಯನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲಿ ವಧಿಸಬೇಕು. ದೋಷಪರಿಹಾರ ಬಲಿಯಂತೆಯೇ ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯೂ ಯಾಜಕನದಾಗಿದೆ. ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ಯಾಜಕನು ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯಲ್ಲಿ ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು ಮತ್ತು ಯಾಜಕನು ಅದನ್ನು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನ ಬಲಗಿವಿಯ ತುದಿಗೂ ಮತ್ತು ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿನ ಮೇಲೆಯೂ, ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿನ ಮೇಲೆಯೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ಯಾಜಕನು ಒಂದನೆಯ ಮೂರು ಭಾಗದಷ್ಟು ಎಣ್ಣೆಯಲ್ಲಿ ಸ್ವಲ್ಪ ತೆಗೆದುಕೊಂಡು ತನ್ನ ಸ್ವಂತ ಎಡ ಅಂಗೈಯಲ್ಲಿ ಹೊಯ್ಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ಯಾಜಕನು ತನ್ನ ಎಡಗೈಯಲ್ಲಿರುವ ಎಣ್ಣೆಯಲ್ಲಿ ತನ್ನ ಬಲಗೈ ಬೆರಳನ್ನು ಅದ್ದಿ, ತನ್ನ ಬೆರಳಿನಿಂದ ಆ ಎಣ್ಣೆಯನ್ನು ಏಳು ಸಾರಿ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ತನ್ನ ಕೈಯಲ್ಲಿ ಮಿಕ್ಕಿದ ಎಣ್ಣೆಯನ್ನು ಯಾಜಕನು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನ ಬಲಗಿವಿಯ ತುದಿಯ ಮೇಲೆ ಮತ್ತು ಅವನ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿನ ಮೇಲೆ, ಅವನ ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿನ ಮೇಲೆ ಹಚ್ಚಬೇಕು. ಅದೇ ರೀತಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯ ರಕ್ತದ ಮೇಲೆ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ಯಾಜಕನ ಕೈಯಲ್ಲಿರುವ ಉಳಿದ ಆ ಎಣ್ಣೆಯನ್ನು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನ ತಲೆಯ ಮೇಲೆ ಹೊಯ್ಯಬೇಕು. ಯಾಜಕನು ಅವನಿಗಾಗಿ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“ಯಾಜಕನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯನ್ನು ಸಮರ್ಪಿಸಿ, ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನಿಗೋಸ್ಕರ ಅವನ ಅಶುದ್ಧತೆಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ತರುವಾಯ ಅವನು ದಹನಬಲಿಯ ಪ್ರಾಣಿಯನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ಯಾಜಕನು ದಹನಬಲಿಯನ್ನೂ, ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ ಬಲಿಪೀಠದ ಮೇಲೆ ಸಮರ್ಪಿಸಬೇಕು. ಇದಲ್ಲದೆ ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡಬೇಕು. ಆಗ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“ಅವನು ಬಡವನಾಗಿದ್ದರೆ ಅಷ್ಟೊಂದು ತರುವುದಕ್ಕೆ ಆಗದಿದ್ದರೆ, ಅವನು ತನ್ನ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಬಲಿ ಕೊಡಲು ನೈವೇದ್ಯ ಮಾಡುವುದಕ್ಕೆ ಒಂದು ಕುರಿಮರಿಯನ್ನೂ, ಎಣ್ಣೆ ಬೆರೆಸಿದ ಒಂದುವರೆ ಕಿಲೋಗ್ರಾಂ ನಯವಾದ ಹಿಟ್ಟನ್ನೂ, ಒಂದನೆಯ ಮೂರು ಭಾಗದಷ್ಟು ಎಣ್ಣೆಯನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ಮತ್ತು ಅವನಿಂದಾಗುವಷ್ಟು ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನೂ ಇಲ್ಲವೆ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅವುಗಳಲ್ಲಿ ಒಂದು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿಯೂ, ಇನ್ನೊಂದು ದಹನಬಲಿಗಾಗಿಯೂ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“ಅವನು ತನ್ನ ಶುದ್ಧತೆಗಾಗಿ ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಇವುಗಳನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಗೆ ಯಾಜಕನ ಹತ್ತಿರಕ್ಕೆ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ಯಾಜಕನು ಪ್ರಾಯಶ್ಚಿತ್ತದ ಸಮರ್ಪಣೆಯ ಆ ಕುರಿಮರಿಯನ್ನೂ, ಒಂದನೆಯ ಮೂರು ಭಾಗದಷ್ಟು ಎಣ್ಣೆಯನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಯಾಜಕನು ಅವುಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ಅವನು ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಗಾಗಿ ಆ ಕುರಿಮರಿಯನ್ನು ವಧಿಸಬೇಕು. ಆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯ ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ಯಾಜಕನು ತೆಗೆದುಕೊಂಡು, ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳುವವನ ಬಲಗಿವಿಯ ತುದಿಯ ಮೇಲೆಯೂ, ಅವನ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿನ ಮೇಲೆಯೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ಇದಲ್ಲದೆ ಯಾಜಕನು ತನ್ನ ಸ್ವಂತ ಎಡ ಅಂಗೈಯಲ್ಲಿ ಎಣ್ಣೆಯನ್ನು ಸುರಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ಯಾಜಕನು ತನ್ನ ಬಲಬೆರಳಿನಿಂದ ತನ್ನ ಎಡಗೈಯಲ್ಲಿರುವ ಸ್ವಲ್ಪ ಎಣ್ಣೆಯನ್ನು ಏಳು ಸಾರಿ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ಇದಲ್ಲದೆ ಯಾಜಕನು ತನ್ನ ಕೈಯಲ್ಲಿದ್ದ ಎಣ್ಣೆಯನ್ನು ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳುವವನ ಬಲಗಿವಿಯ ತುದಿಯ ಮೇಲೆಯೂ, ಅವನ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿನ ಮೇಲೆಯೂ, ಅವನ ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿನ ಮೇಲೆಯೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯ ರಕ್ತದ ಸ್ಥಳದ ಮೇಲೆಯೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ಯಾಜಕನ ಕೈಯಲ್ಲಿರುವ ಉಳಿದ ಎಣ್ಣೆಯನ್ನು ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳುವವನ ತಲೆಯ ಮೇಲೆ ಹೊಯ್ದು, ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಅವನಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ತರುವಾಯ ಅವನು ತನ್ನ ಸ್ಥಿತಿಗೆ ತಕ್ಕಂತೆ ತಂದ ಬೆಳವಕ್ಕಿಗಳಲ್ಲಿಯಾಗಲಿ ಪಾರಿವಾಳದ ಮರಿಗಳಲ್ಲಿಯಾಗಲಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ಅದರಂತೆಯೇ ಅವನು ತನ್ನ ಸ್ಥಿತಿಗೆ ತಕ್ಕಂತೆ ಒಂದನ್ನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಮತ್ತು ಇನ್ನೊಂದನ್ನು ದಹನಬಲಿಗಾಗಿ ಧಾನ್ಯಸಮರ್ಪಣೆಯೊಂದಿಗೆ ಸಮರ್ಪಿಸಬೇಕು, ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳುವವನಿಗೋಸ್ಕರ ಯಾಜಕನು ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ಚರ್ಮರೋಗವುಳ್ಳವನು ಶುದ್ಧತೆ ಮಾಡಿಸಿಕೊಳ್ಳಲು ಗತಿಯಿಲ್ಲದವನಿಗೆ ತನ್ನ ಶುದ್ಧತೆಗಾಗಿ ಇರುವ ನಿಯಮವು ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಮತ್ತು ಆರೋನರೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ನಾನು ನಿಮಗೆ ಸೊತ್ತಾಗಿ ಕೊಡುವ ಕಾನಾನ್ ದೇಶದೊಳಗೆ ನೀವು ಬಂದ ಬಳಿಕ ನಾನು ನಿಮಗೆ ಸೊತ್ತಾಗಿ ಕೊಡುವ ಮನೆಯಲ್ಲಿ ಬೂಜನ್ನು ಬರಮಾಡಿದಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ಮನೆಯವನು ಯಾಜಕನ ಬಳಿಗೆ ಬಂದು, ‘ನನ್ನ ಮನೆಯಲ್ಲಿ ಬೂಜಿನ ಗುರುತಿದ್ದಂತೆ ಕಾಣುತ್ತಿದೆ,’ ಎಂದು ಹೇಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ಆಗ ಯಾಜಕನು ಆ ಮನೆಯಲ್ಲಿ ಬೂಜನ್ನು ಪರೀಕ್ಷಿಸುವುದಕ್ಕೆ ಹೋಗುವ ಮೊದಲು, ಆ ಮನೆಯೊಳಗೆ ಇರುವವುಗಳು ಅಶುದ್ಧವಾಗದಂತೆ ಆ ಮನೆಯನ್ನು ಬರಿದುಮಾಡಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಬೇಕು. ತರುವಾಯ ಯಾಜಕನು ಮನೆಯನ್ನು ಪರೀಕ್ಷಿಸುವುದಕ್ಕೆ ಒಳಗೆ ಹೋಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ಅವನು ಆ ಬೂಜನ್ನು ಪರೀಕ್ಷಿಸಿದಾಗ, ಅದು ಮನೆಯ ಗೋಡೆಗಳಲ್ಲಿ ತಗ್ಗಾದ ಸಾಲುಗಳಲ್ಲಿ ಹಸಿರಾಗಿಯಾದರೂ, ಕೆಂಪಾಗಿ ಗೋಡೆಯ ಮಟ್ಟಕ್ಕಿಂತ ತಗ್ಗಿನಲ್ಲಿ ತೋರಿಬಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ಯಾಜಕನು ಆ ಮನೆಯ ಹೊರಗೆ ಮನೆಯ ಬಾಗಿಲ ಬಳಿಗೆ ಹೋಗಿ ಅದನ್ನು ಏಳು ದಿವಸಗಳವರೆಗೆ ಮುಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ತಿರುಗಿಬಂದು ಪರೀಕ್ಷಿಸಿದಾಗ, ಆ ಬೂಜು ಮನೆಯ ಗೋಡೆಗಳಲ್ಲಿ ಹರಡಿಕೊಂಡಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ಬೂಜುಳ್ಳ ಕಲ್ಲುಗಳನ್ನು ಅವರು ತೆಗೆದು ಪಟ್ಟಣದ ಆಚೆಗೆ ಅಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಬಿಸಾಡಬೇಕೆಂದೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ಆ ಮನೆಯ ಒಳಭಾಗದಲ್ಲಿ ಸುತ್ತಲೂ ಕೆರೆದು, ಕೆರೆದ ಧೂಳನ್ನು ಪಟ್ಟಣದ ಹೊರಗೆ ಅಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಸುರಿಯಬೇಕೆಂದೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ಅವರು ಆ ಕಲ್ಲುಗಳಿಗೆ ಬದಲಾಗಿ ಬೇರೆ ಕಲ್ಲುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕೆಂದೂ ಯಾಜಕನು ಆಜ್ಞಾಪಿಸಬೇಕು, ಅವನು ಬೇರೆ ಗಾರೆಯಿಂದ ಆ ಮನೆಗೆ ಗಿಲಾವುಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ಅವನು ಆ ಮನೆಯ ಕಲ್ಲುಗಳನ್ನು ತೆಗೆಸಿ ಅದನ್ನು ಕೆತ್ತಿ ಗಿಲಾವು ಮಾಡಿಸಿದ ಮೇಲೆ ಆ ಬೂಜು ತಿರುಗಿ ಕಾಣಬಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ಯಾಜಕನು ಬಂದು ಪರೀಕ್ಷಿಸಬೇಕು. ಆಗ ಬೂಜು ಮನೆಯಲ್ಲಿ ಹರಡಿಕೊಂಡಿದ್ದರೆ, ಆ ಮನೆಯಲ್ಲಿ ಅದೊಂದು ನಾಶಕರವಾದ ಬೂಜು ಆಗಿರುವುದು, ಆ ಮನೆ ಅಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ಅವನು ಆ ಮನೆಯನ್ನು ಕೆಡವಿಹಾಕಿ, ಅದರ ಕಲ್ಲುಗಳನ್ನೂ, ಮರಗಳನ್ನೂ, ಆ ಮನೆಯ ಎಲ್ಲಾ ಧೂಳನ್ನೂ ತೆಗೆದು, ಅವುಗಳನ್ನು ಪಟ್ಟಣದ ಹೊರಗೆ ಅಶುದ್ಧವಾದ ಸ್ಥಳಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“ಆ ಮನೆಯು ಮುಚ್ಚಿರುವ ಕಾಲದಲ್ಲೆಲ್ಲಾ ಅದರೊಳಗೆ ಯಾವನಾದರೂ ಹೋದರೆ ಸಾಯಂಕಾಲದವರೆಗೆ ಅವನು ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ಆ ಮನೆಯೊಳಗೆ ಮಲಗಿಕೊಳ್ಳುವವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಅಲ್ಲದೆ ಆ ಮನೆಯೊಳಗೆ ತಿನ್ನುವವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“ಆದರೆ ಯಾಜಕನು ಒಳಗೆ ಬಂದು ಅದನ್ನು ಪರೀಕ್ಷಿಸಿದಾಗ, ಗಿಲಾವು ಮಾಡಿದ ನಂತರ ಆ ಮನೆಯಲ್ಲಿ ಆ ಬೂಜು ಹರಡಿಕೊಂಡಿರದಿದ್ದರೆ, ಆ ಮನೆಯು ಶುದ್ಧವೆಂದು ಯಾಜಕನು ನಿರ್ಣಯಿಸಬೇಕು. ಏಕೆಂದರೆ ಆ ಬೂಜು ಹೊರಟುಹೋಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ಆ ಮನೆಯನ್ನು ಶುದ್ಧಪಡಿಸುವುದಕ್ಕೋಸ್ಕರ ಎರಡು ಪಕ್ಷಿಗಳನ್ನೂ, ದೇವದಾರು ಕಟ್ಟಿಗೆಯನ್ನೂ, ರಕ್ತವರ್ಣ ದಾರವನ್ನೂ, ಹಿಸ್ಸೋಪನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ಆ ಪಕ್ಷಿಗಳಲ್ಲಿ ಒಂದನ್ನು ಹರಿಯುವ ನೀರಿನ ಮೇಲೆ ಒಂದು ಮಣ್ಣಿನ ಪಾತ್ರೆಯಲ್ಲಿ ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ತರುವಾಯ ದೇವದಾರು ಕಟ್ಟಿಗೆಯನ್ನೂ, ಹಿಸ್ಸೋಪನ್ನೂ, ರಕ್ತವರ್ಣ ದಾರವನ್ನೂ, ಸಜೀವವುಳ್ಳ ಪಕ್ಷಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು, ಅವುಗಳನ್ನು ವಧಿಸಿದ ಪಕ್ಷಿಯ ರಕ್ತದಲ್ಲಿ ಮತ್ತು ಹರಿಯುವ ನೀರಿನಲ್ಲಿ ಅದ್ದಿ, ಏಳು ಸಾರಿ ಆ ಮನೆಗೆ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ಅವನು ಪಕ್ಷಿಯ ರಕ್ತದಿಂದಲೂ, ಹರಿಯುವ ನೀರಿನಿಂದಲೂ, ಸಜೀವವುಳ್ಳ ಪಕ್ಷಿಯಿಂದಲೂ, ದೇವದಾರು ಕಟ್ಟಿಗೆಯಿಂದಲೂ, ಹಿಸ್ಸೋಪಿನಿಂದಲೂ, ರಕ್ತವರ್ಣ ದಾರದಿಂದಲೂ ಆ ಮನೆಯನ್ನು ಶುದ್ಧೀಕರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ಆದರೆ ಜೀವವುಳ್ಳ ಆ ಪಕ್ಷಿಯನ್ನು ಪಟ್ಟಣದ ಆಚೆಗೆ ಬಯಲಾದ ಹೊಲಗಳಲ್ಲಿ ಬಿಟ್ಟುಬಿಡಬೇಕು. ಆ ಮನೆಗೋಸ್ಕರ ಪಾಪದ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡಬೇಕು. ಆಗ ಅದು ಶುದ್ಧವಾಗುವುದು.” ");
INSERT INTO kanokcv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ಎಲ್ಲಾ ವಿಧವಾದ ಚರ್ಮರೋಗಕ್ಕೂ, ಇಸಬಿಗೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ಬಟ್ಟೆಯ ಮತ್ತು ಮನೆಯ ಬೂಜಿಗೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ಬಾವು, ಚರ್ಮವ್ಯಾಧಿಗೂ, ಹೊಳೆಯುವ ಕಲೆಗೂ ");
INSERT INTO kanokcv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ಅವುಗಳ ಶುದ್ಧಾಶುದ್ಧ ಬೇಧವನ್ನು ಬೋಧಿಸುವ ನಿಯಮಗಳು ಇವೇ. ಚರ್ಮರೋಗಗಳ ಹಾಗೂ ಬೂಜಿನ ವಿಷಯದಲ್ಲಿರುವ ನಿಯಮಗಳು ಇವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಆರೋನರೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೀಗೆ ಹೇಳು: ‘ಒಬ್ಬ ಪುರುಷನ ಶರೀರದಿಂದ ಮೇಹಸ್ರಾವ ಹರಿಯುವುದಾಗಿದ್ದರೆ, ಆ ಸ್ರಾವದ ನಿಮಿತ್ತವಾಗಿ ಅವನು ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ಅವನ ಸ್ರಾವದಲ್ಲಿ ಅದು ಅವನ ಅಶುದ್ಧತೆಯಾಗಿರುವುದು. ಅವನ ಶರೀರವು ತನ್ನ ಸ್ರಾವದಿಂದ ಹರಿಯುವುದಾಗಿದ್ದರೂ, ಸ್ರಾವವು ಅವನ ಶರೀರದಲ್ಲಿ ನಿಂತು ಹೋಗಿದ್ದರೂ, ಅದು ಅವನ ಅಶುದ್ಧತೆಯಾಗಿರುವುದು. ಅವನ ವಿಸರ್ಜನೆಯು ಹೇಗೆ ಅಶುದ್ಧತೆಯನ್ನು ತರುತ್ತದೆ ಅಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘ಸ್ರಾವವಿರುವವನು ಮಲಗುವ ಪ್ರತಿಯೊಂದು ಹಾಸಿಗೆಯೂ ಅಶುದ್ಧವಾದದ್ದು, ಅವನು ಕೂತುಕೊಳ್ಳುವ ಪ್ರತಿಯೊಂದು ವಸ್ತುವೂ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ಅವನ ಹಾಸಿಗೆಯನ್ನು ಮುಟ್ಟುವವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು, ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಸಂಜೆಯವರೆಗೆ ಅವರು ಅಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ಇದಲ್ಲದೆ ಸ್ರಾವವಿರುವವನು ಕುಳಿತುಕೊಂಡ ಯಾವುದೇ ವಸ್ತುವಿನ ಮೇಲೆ ಕುಳಿತುಕೊಳ್ಳುವವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಸಂಜೆಯವರೆಗೆ ಅವರು ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘ಸ್ರಾವವಿರುವವನ ಶರೀರವನ್ನು ಮುಟ್ಟುವವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು ಮತ್ತು ಸಂಜೆಯವರೆಗೆ ಅವರು ಅಶುದ್ಧನಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘ಶುದ್ಧರಾಗಿರುವವರ ಮೇಲೆ ಸ್ರಾವವಿರುವವನು ಉಗುಳಿದರೆ, ಅವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಸಂಜೆಯವರೆಗೆ ಅವರು ಅಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘ಸ್ರಾವವುಳ್ಳವನು ಏರಿ ಕುಳಿತುಕೊಂಡಿದ್ದ ತಡಿಯು ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ಅವನ ಕೆಳಗಿರುವ ಯಾವುದಾದರೂ ವಸ್ತುವನ್ನು ಮುಟ್ಟಿದವನು ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು, ಅವುಗಳಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ಹೊತ್ತುಕೊಳ್ಳುವವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಸಂಜೆಯವರೆಗೆ ಅವನು ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘ಸ್ರಾವವುಳ್ಳವನು ತನ್ನ ಕೈಗಳನ್ನು ನೀರಿನಿಂದ ತೊಳೆದುಕೊಳ್ಳದೆ, ಯಾರನ್ನಾದರೂ ಮುಟ್ಟಿದರೆ ಅವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಸಂಜೆಯವರೆಗೆ ಅವರು ಅಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘ಸ್ರಾವವುಳ್ಳವನು ಮುಟ್ಟಿದ ಮಣ್ಣಿನ ಪಾತ್ರೆಯನ್ನು ಒಡೆಯಬೇಕು. ಮರದ ಪ್ರತಿಯೊಂದು ಪಾತ್ರೆಯನ್ನು ನೀರಿನಲ್ಲಿ ಜಾಲಿಸಿ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘ಸ್ರಾವವುಳ್ಳವನು ತನ್ನ ಸ್ರಾವದಿಂದ ತನ್ನ ಶುದ್ಧತೆಗಾಗಿ ಏಳು ದಿನಗಳನ್ನು ಲೆಕ್ಕ ಮಾಡಿ, ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು. ಇದಲ್ಲದೆ ಹರಿಯುವ ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಆಗ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಅವನು ತನಗಾಗಿ ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನು ಇಲ್ಲವೆ ಎರಡು ಪಾರಿವಾಳ ಮರಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಬಂದು ಅವುಗಳನ್ನು ಯಾಜಕನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ಆಗ ಯಾಜಕನು ಒಂದನ್ನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಮತ್ತು ಇನ್ನೊಂದನ್ನು ದಹನಬಲಿಗಾಗಿ ಅವುಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು, ಯಾಜಕನು ಅವನ ಸ್ರಾವಕ್ಕೋಸ್ಕರ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘ಒಬ್ಬನಿಗೆ ವೀರ್ಯವು ಹೊರಟು ಹೋದರೆ, ಅವನು ತನ್ನ ಶರೀರವನ್ನೆಲ್ಲಾ ನೀರಿನಲ್ಲಿ ತೊಳೆದು, ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ವೀರ್ಯವು ಬಿದ್ದ ಪ್ರತಿಯೊಂದು ಬಟ್ಟೆ ಮತ್ತು ಪ್ರತಿಯೊಂದು ಚರ್ಮವನ್ನು ನೀರಿನಿಂದ ತೊಳೆದು, ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ಇದಲ್ಲದೆ ಸ್ತ್ರೀಯೊಂದಿಗೆ ಒಬ್ಬನು ಮಲಗಿ, ವೀರ್ಯ ಸ್ರಾವವಾಗಿದ್ದರೆ, ಅವರಿಬ್ಬರೂ ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘ಒಬ್ಬ ಸ್ತ್ರೀಗೆ ತನ್ನ ಶರೀರದಲ್ಲಿ ರಕ್ತ ಸ್ರಾವವಿದ್ದರೆ, ಅವಳು ಏಳು ದಿವಸಗಳವರೆಗೆ ಪ್ರತ್ಯೇಕವಾಗಿರಬೇಕು, ಅವಳನ್ನು ಯಾರಾದರೂ ಮುಟ್ಟಿದರೆ, ಅವರು ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘ಅವಳು ಮುಟ್ಟಾದಾಗ ಅವಳು ಮಲಗುವ ಪ್ರತಿಯೊಂದು ಹಾಸಿಗೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ಅವಳು ಕೂತುಕೊಳ್ಳುವ ಪ್ರತಿಯೊಂದು ವಸ್ತುವು ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ಅವಳ ಹಾಸಿಗೆಯನ್ನು ಮುಟ್ಟುವವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ಅವಳು ಯಾವುದರ ಮೇಲೆ ಕುಳಿತಿದ್ದಳೋ, ಅದನ್ನು ಮುಟ್ಟಿದವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು. ಅವರು ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ಇದಲ್ಲದೆ ಅವಳ ಹಾಸಿಗೆಯ ಮೇಲಾಗಲಿ ಇಲ್ಲವೆ ಅವಳು ಕುಳಿತುಕೊಂಡ ಯಾವದರ ಮೇಲಾಗಲಿ ಇರುವುದನ್ನು ಮುಟ್ಟಿದವರು ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘ಯಾವನಾದರೂ ಅವಳೊಂದಿಗೆ ಸಂಗಮಿಸಿದರೆ ಮತ್ತು ಅವಳ ಸ್ರಾವವು ಅವನಿಗೆ ತಗಲಿದರೆ, ಅವನು ಏಳು ದಿವಸ ಅಶುದ್ಧನಾಗಿರಬೇಕು. ಅವನು ಮಲಗಿಕೊಳ್ಳುವ ಹಾಸಿಗೆಯೆಲ್ಲಾ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘ಇದಲ್ಲದೆ ಸ್ತ್ರೀಗೆ ಅವಳ ಮುಟ್ಟಿನ ಕಾಲಕ್ಕಿಂತಲೂ ಹೆಚ್ಚು ದಿನ ರಕ್ತಸ್ರಾವವು ಇದ್ದರೆ, ಇಲ್ಲವೆ ಮುಟ್ಟಾಗಿದ್ದ ಕಾಲದಲ್ಲಾಗುವ ರಕ್ತಸ್ರಾವಕ್ಕಿಂತ ಹೆಚ್ಚಾಗಿ ಹರಿಯುತ್ತಿದ್ದರೆ, ಅವಳ ಸ್ರಾವದ ಅಶುದ್ಧತ್ವದ ಎಲ್ಲಾ ದಿನಗಳು ಅವಳ ಮುಟ್ಟಿನ ದಿನಗಳಂತೆ ಇರಬೇಕು. ಅವಳು ಅಶುದ್ಧಳಾಗಿರುವಳು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ಅವಳ ಸ್ರಾವದ ಎಲ್ಲಾ ದಿನಗಳಲ್ಲಿ ಅವಳು ಮಲಗಿಕೊಳ್ಳುವ ಹಾಸಿಗೆಯು, ಅವಳ ಮುಟ್ಟಿನ ಹಾಸಿಗೆಯಂತೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ಅವಳು ಕುಳಿತುಕೊಳ್ಳುವುದೆಲ್ಲವೂ ಅವಳ ಮುಟ್ಟಿನ ಅಶುದ್ಧತೆಯಂತೆಯೇ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ಯಾರಾದರೂ ಆ ವಸ್ತುಗಳನ್ನು ಮುಟ್ಟಿದರೆ ಅಶುದ್ಧರಾಗಿರುವರು. ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಅವರು ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘ಅವಳು ತನ್ನ ಸ್ರಾವದಿಂದ ಶುದ್ಧಳಾದರೆ, ಅವಳು ಶುದ್ಧಳಾದಂದಿನಿಂದ ತನಗಾಗಿ ಏಳು ದಿನಗಳನ್ನು ಲೆಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಅವಳು ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ, ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತೆಗೆದುಕೊಂಡು, ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿ ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ಯಾಜಕನು ಒಂದನ್ನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿಯೂ, ಇನ್ನೊಂದನ್ನು ದಹನಬಲಿಗಾಗಿಯೂ ಸಮರ್ಪಿಸಬೇಕು, ಯಾಜಕನು ಅವಳಿಗಾಗಿ ಅವಳ ಅಶುದ್ಧತೆಯ ಸ್ರಾವದ ವಿಷಯದಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘ಹೀಗೆ ನೀವು ಇಸ್ರಾಯೇಲರನ್ನು ಅಶುದ್ಧತೆಯಿಂದ ದೂರವಾಗಿರುವಂತೆ ನೋಡಿಕೊಳ್ಳಬೇಕು. ಆಗ ಅವರು ತಮ್ಮ ಮಧ್ಯದಲ್ಲಿರುವ ನನ್ನ ಗುಡಾರವನ್ನು ಅಶುದ್ಧ ಮಾಡದೆ, ತಮ್ಮ ಅಶುದ್ಧತ್ವದಿಂದ ಸಾಯುವುದಿಲ್ಲ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ಮೇಹಸ್ರಾವವುಳ್ಳವನಿಗೂ ವೀರ್ಯ ಸ್ರಾವವುಳ್ಳವನಿಗೂ ಅವುಗಳಿಂದ ಅಶುದ್ಧವಾಗುವವರೆಗೂ ಇರುವ ನಿಯಮವು ಇದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ಮುಟ್ಟು ಇರುವವಳಿಗೂ, ಸ್ರಾವವಿರುವ ಪುರುಷನಿಗೂ ಸ್ತ್ರೀಗೂ, ಅಶುದ್ಧವಾದವಳ ಸಂಗಡ ಮಲಗಿದವನಿಗೂ ಇರುವ ನಿಯಮ ಇದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ಆರೋನನ ಇಬ್ಬರು ಗಂಡು ಮಕ್ಕಳು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಗೆ ಬಂದು ಸತ್ತಾಗ ಮೋಶೆಯಂದಿಗೆ ಯೆಹೋವ ದೇವರು ಮಾತನಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನು ಮಂಜೂಷದ ಮೇಲಿರುವ ಕರುಣಾಸನದ ಮುಂದಿರುವ ತೆರೆಯ ಒಳಗೆ ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೆ ಎಲ್ಲಾ ಸಮಯಗಳಲ್ಲಿ ಬಾರದಿರಲಿ, ಇಲ್ಲವಾದರೆ ಅವನು ಸಾಯುತ್ತಾನೆ, ಏಕೆಂದರೆ ಕರುಣಾಸನದ ಮೇಲೆ ಮೇಘದೊಳಗೆ ನಾನು ಪ್ರತ್ಯಕ್ಷನಾಗುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“ಈ ಸೂಚನೆಗಳನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ಅನುಸರಿಸಿದ ನಂತರವೇ ಆರೋನನು ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೆ ಪ್ರವೇಶಿಸಬೇಕು: ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಒಂದು ಹೋರಿಯನ್ನು ಮತ್ತು ದಹನಬಲಿಗಾಗಿ ಒಂದು ಟಗರನ್ನು ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ಅವನು ಪರಿಶುದ್ಧವಾದ ನಾರುಬಟ್ಟೆಯ ಮೇಲಂಗಿಯನ್ನು ತೊಟ್ಟುಕೊಂಡು, ತನ್ನ ಶರೀರದ ಮೇಲೆ ನಾರುಬಟ್ಟೆಯ ಒಳಉಡುಪನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು ಮತ್ತು ನಾರಿನ ನಡುಕಟ್ಟನ್ನು ಕಟ್ಟಿಕೊಂಡು, ನಾರಿನ ಮುಂಡಾಸವನ್ನು ಧರಿಸಬೇಕು. ಇವು ಪವಿತ್ರವಾದ ಉಡುಪುಗಳು. ಆದಕಾರಣ ಅವನು ನೀರಿನಿಂದ ಸ್ನಾನಮಾಡಿ ಅವುಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ಅವನು ಇಸ್ರಾಯೇಲರ ಸಭೆಯ ಕಡೆಯಿಂದ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಎರಡು ಹೋತಗಳನ್ನು, ದಹನಬಲಿಗಾಗಿ ಒಂದು ಟಗರನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“ಇದಲ್ಲದೆ ಆರೋನನು ತನಗೋಸ್ಕರ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ತನ್ನ ಹೋರಿಯನ್ನು ಸಮರ್ಪಿಸಿ, ತನ್ನ ಮನೆಯವರಿಗೋಸ್ಕರವೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ಅವನು ಎರಡು ಹೋತಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಗೆ ತಂದು, ಅವುಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ಆರೋನನು ಆ ಎರಡು ಹೋತಗಳಿಗಾಗಿ ಚೀಟುಹಾಕಬೇಕು. ಒಂದು ಚೀಟು ಯೆಹೋವ ದೇವರಿಗೋಸ್ಕರ, ಮತ್ತೊಂದು ಚೀಟು ಬಲಿಪಶುವಿಗೋಸ್ಕರ. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ಆರೋನನು ಯೆಹೋವ ದೇವರ ಚೀಟು ಬಿದ್ದ ಹೋತವನ್ನು ತಂದು, ಅದನ್ನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ಆದರೆ ಬಲಿಪಶುವಿಗಾಗಿ ಚೀಟು ಬಿದ್ದ ಆ ಹೋತವನ್ನು ತನ್ನೊಂದಿಗೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕಾಗಿ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಜೀವವಾಗಿ ನಿಲ್ಲಿಸಿ, ಅದನ್ನು ಬಲಿಪಶುವಾಗಿ ಕಾಡಿನಲ್ಲಿ ಹೋಗುವಂತೆ ಬಿಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“ಇದಲ್ಲದೆ ಆರೋನನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿರುವ ಹೋರಿಯನ್ನು ತಂದು, ತನಗೋಸ್ಕರ ಮತ್ತು ತನ್ನ ಮನೆತನದವರಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ತನಗೋಸ್ಕರ ದೋಷಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಆ ಹೋರಿಯನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ಅವನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಬಲಿಪೀಠದಿಂದ ಬೆಂಕಿಯ ಕೆಂಡಗಳನ್ನು ಧೂಪ ಸುಡುವ ಪಾತ್ರೆಯಲ್ಲಿ ತುಂಬಿಸಿ, ತನ್ನ ಎರಡು ಕೈತುಂಬ ಪರಿಮಳ ಧೂಪದ್ರವ್ಯದ ಚೂರ್ಣವನ್ನು ತೆಗೆದುಕೊಂಡು, ತೆರೆಯನ್ನು ದಾಟಿ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ಅವನು ಸಾಯದ ಹಾಗೆ ಆ ಧೂಪದ ಹೊಗೆಯು ಸಾಕ್ಷಿಯ ಮೇಲಿರುವ ಕರುಣಾಸನವು ಮುಚ್ಚಿಕೊಳ್ಳುವಂತೆ ಆ ಧೂಪವನ್ನು ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಬೆಂಕಿಯ ಮೇಲೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ಆ ಹೋರಿಯ ರಕ್ತದಿಂದ ಸ್ವಲ್ಪ ತೆಗೆದುಕೊಂಡು, ಕರುಣಾಸನದ ಮೇಲೆ ಪೂರ್ವಕ್ಕೆ ತನ್ನ ಬೆರಳಿನಿಂದ ಚಿಮುಕಿಸಬೇಕು, ಕರುಣಾಸನದ ಮುಂದೆ ಆ ರಕ್ತವನ್ನು ತನ್ನ ಬೆರಳಿನಿಂದ ಏಳು ಸಾರಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ತರುವಾಯ ಅವನು ಜನರಿಗೋಸ್ಕರ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿರುವ ಹೋತವನ್ನು ವಧಿಸಿ, ಅದರ ರಕ್ತವನ್ನು ತೆರೆಯ ಒಳಗಡೆ ತಂದು, ಹೋರಿಯ ರಕ್ತದಿಂದ ಮಾಡಿದಂತೆಯೇ ಕರುಣಾಸನದ ಮೇಲೆಯೂ, ಕರುಣಾಸನದ ಮುಂದೆಯೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ಇಸ್ರಾಯೇಲರ ಅಶುದ್ಧತ್ವದ ನಿಮಿತ್ತವಾಗಿಯೂ, ಎಲ್ಲಾ ಅಪರಾಧಗಳಿಗಾಗಿಯೂ ಅವನು ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಅವರು ಅಶುದ್ಧತ್ವದ ಮಧ್ಯದಲ್ಲಿ ಉಳಿದವರಿಗೋಸ್ಕರ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೂ ಅದರಂತೆಯೇ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ಅವನು ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕಾಗಿ ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೆ ಹೋಗಿರುವಾಗ ತನಗೋಸ್ಕರವೂ, ತನ್ನ ಮನೆಯವರಿಗೆಲ್ಲರಿಗೋಸ್ಕರವೂ, ಇಸ್ರಾಯೇಲರ ಸಭೆಯವರೆಲ್ಲರಿಗೋಸ್ಕರವೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಿ ಹೊರಗೆ ಬರುವ ತನಕ ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಒಬ್ಬ ಮನುಷ್ಯನೂ ಇರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“ಅವನು ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿರುವ ಬಲಿಪೀಠದ ಬಳಿಗೆ ಬಂದು, ಅದಕ್ಕೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡಬೇಕು. ಹೋರಿಯ ರಕ್ತವನ್ನೂ, ಹೋತದ ರಕ್ತವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಲಿಪೀಠದ ಸುತ್ತಲೂ ಇರುವ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ಅವನು ಏಳು ಸಾರಿ ಅದರ ಮೇಲೆ ರಕ್ತವನ್ನು ಚಿಮುಕಿಸಿ, ಅದನ್ನು ಶುದ್ಧಮಾಡಬೇಕು ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಅಶುದ್ಧತೆಯನ್ನು ಹೋಗಲಾಡಿಸಿ, ಅದನ್ನು ಪರಿಶುದ್ಧ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“ಹೀಗೆ ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೂ, ಸಭೆಯ ಗುಡಾರಕ್ಕೂ, ಬಲಿಪೀಠಕ್ಕೂ ಸಂಧಾನದ ಕೊನೆಯಲ್ಲಿ ಅವನು ಒಂದು ಜೀವವುಳ್ಳ ಹೋತವನ್ನು ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ಆರೋನನು ಆ ಜೀವವುಳ್ಳ ಹೋತದ ತಲೆಯ ಮೇಲೆ ತನ್ನ ಎರಡೂ ಕೈಗಳನ್ನು ಇಟ್ಟು, ಅದರ ಮೇಲೆ ಇಸ್ರಾಯೇಲರ ಎಲ್ಲಾ ಅಕ್ರಮಗಳನ್ನೂ, ಅವರ ಎಲ್ಲಾ ಪಾಪಗಳಲ್ಲಿರುವ ದ್ರೋಹಗಳನ್ನೂ ಅರಿಕೆಮಾಡಿ ಅವುಗಳನ್ನು ಹೋತದ ತಲೆಯ ಮೇಲೆ ಇರಿಸಿ, ನೇಮಕವಾದ ಒಬ್ಬ ಮನುಷ್ಯನ ಕೈಯಿಂದ ಅದನ್ನು ಅಡವಿಯೊಳಗೆ ಕಳುಹಿಸಿಬಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ಆ ಹೋತ ಅವರ ಎಲ್ಲಾ ಪಾಪಗಳನ್ನೂ ತನ್ನ ಮೇಲೆ ಹೊತ್ತುಕೊಂಡು ನಿರ್ಜನವಾದ ಸ್ಥಳಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗುವಂತೆ ಆ ಮನುಷ್ಯನು ಹೋತವನ್ನು ಅಡವಿಗೆ ತೆಗೆದುಕೊಂಡುಹೋಗಿ ಅಲ್ಲೇ ಬಿಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“ಆರೋನನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಬಂದು, ತಾನು ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳದೊಳಕ್ಕೆ ಹೋಗುವಾಗ ತೊಟ್ಟುಕೊಂಡಿದ್ದ ನಾರಿನ ಬಟ್ಟೆಗಳನ್ನು ತೆಗೆದುಹಾಕಿ ಅವುಗಳನ್ನು ಅಲ್ಲಿಯೇ ಬಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ಅವನು ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಿ, ತನ್ನ ಬಳಕೆಯ ಬಟ್ಟೆಗಳನ್ನು ಧರಿಸಿಕೊಂಡು, ಹೊರಗೆ ಬಂದು ತನ್ನ ದಹನಬಲಿಯನ್ನೂ, ಜನರ ದಹನಬಲಿಯನ್ನೂ ಸಮರ್ಪಿಸಿ ತನಗೋಸ್ಕರವೂ, ಜನರಿಗೋಸ್ಕರವೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ಕೊಬ್ಬನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“ಬಲಿಪಶುವಿಗಾಗಿ ಹೋತವನ್ನು ಹೋಗಲು ಬಿಟ್ಟವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಿದ ಮೇಲೆ ಅವನು ಪಾಳೆಯದೊಳಕ್ಕೆ ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ಇದಲ್ಲದೆ ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕಾಗಿ ಯಾವುದರ ರಕ್ತವು ತರಲಾಗಿತ್ತೋ, ಆ ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯ ಹೋರಿಯನ್ನು ಮತ್ತು ದೋಷಪರಿಹಾರ ಬಲಿಯ ಹೋತವನ್ನು ಪಾಳೆಯದ ಆಚೆಗೆ ತೆಗೆದುಕೊಂಡುಹೋಗಿ ಅವುಗಳ ಚರ್ಮವನ್ನೂ, ಮಾಂಸವನ್ನೂ, ಸಗಣಿಯನ್ನೂ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ಅವುಗಳನ್ನು ಸುಡುವವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಿದ ನಂತರ ಪಾಳೆಯದೊಳಕ್ಕೆ ಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ಇದು ನಿಮಗೆ ಶಾಶ್ವತವಾದ ನಿಯಮ: ಸ್ವದೇಶೀಯರಾದ ನೀವೂ, ನಿಮ್ಮೊಡನೆ ವಾಸಿಸುತ್ತಿರುವ ಪರಕೀಯರೂ, ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ಎಲ್ಲಾ ಕೆಲಸಗಳನ್ನು ಬಿಟ್ಟು, ನಿಮ್ಮ ಆತ್ಮಗಳನ್ನು ಕುಂದಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ನೀವು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಮ್ಮ ಎಲ್ಲಾ ಪಾಪಗಳಿಂದ ಶುದ್ಧರಾಗಿರುವಂತೆ ನಿಮ್ಮನ್ನು ಶುದ್ಧೀಕರಿಸುವ ಹಾಗೆ, ಆ ದಿನದಲ್ಲಿ ಯಾಜಕನು ನಿಮಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ಇದೇ ನಿಮಗೆ ಸಬ್ಬತ್ ದಿನವಾಗಿರುವುದು. ನಿಮಗೆ ನಿತ್ಯವಾದ ನಿಯಮವಿರುವಂತೆ ನಿಮ್ಮನ್ನು ತಗ್ಗಿಸಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ಯಾವನು ತನ್ನ ತಂದೆಯ ಬದಲಾಗಿ ಮಹಾಯಾಜಕ ಉದ್ಯೋಗಕ್ಕೋಸ್ಕರ ಅಭಿಷಿಕ್ತನಾಗಿ ಪ್ರತಿಷ್ಟಿಸಲಾಗಿದ್ದಾನೋ, ಆ ಮಹಾಯಾಜಕನು ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡಬೇಕು. ಅವನು ಪರಿಶುದ್ಧ ಉಡುಪುಗಳಾದ ನಾರು ಬಟ್ಟೆಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ಹೀಗೆ ಅವನು ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಇದಲ್ಲದೆ ಸಭೆಯ ಗುಡಾರಕ್ಕಾಗಿಯೂ, ಬಲಿಪೀಠಕ್ಕಾಗಿಯೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಯಾಜಕರಿಗಾಗಿಯೂ, ಸಭೆಯ ಎಲ್ಲಾ ಜನರಿಗೋಸ್ಕರವೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“ಹೀಗೆ ಇಸ್ರಾಯೇಲರ ಎಲ್ಲಾ ಪಾಪಗಳಿಗಾಗಿ ವರ್ಷಕ್ಕೊಂದಾವರ್ತಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದು, ನಿಮಗೆ ನಿರಂತರವಾದ ನಿಯಮವಾಗಿರುವುದು,” ಎಂದು ಹೇಳಿದರು. ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“ಆರೋನನಿಗೂ, ಅವನ ಪುತ್ರರಿಗೂ, ಇಸ್ರಾಯೇಲರೆಲ್ಲರಿಗೂ ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೀಗೆ ಹೇಳು: ‘ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ಇಂತೆಂದು ಆಜ್ಞಾಪಿಸುತ್ತಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ಇಸ್ರಾಯೇಲಿನ ಮನೆತನದಲ್ಲಿ ಯಾವನು ಒಂದು ಎತ್ತನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಒಂದು ಕುರಿಯನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಒಂದು ಆಡನ್ನಾಗಲಿ ಪಾಳೆಯದೊಳಗೆ ಆಗಲಿ ಇಲ್ಲವೆ ಪಾಳೆಯದ ಹೊರಗೆ ಆಗಲಿ ವಧಿಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸುವುದಕ್ಕಾಗಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಮುಂದೆ ತಾರದಿದ್ದರೆ, ಆ ಮನುಷ್ಯನ ಮೇಲೆ ರಕ್ತಾಪರಾಧವು ಹೊರಿಸಬೇಕು. ಅವನು ರಕ್ತ ಸುರಿಸಿರುವವನು, ಆ ಮನುಷ್ಯನು ತನ್ನ ಜನರ ಮಧ್ಯದೊಳಗಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ಇಸ್ರಾಯೇಲರು ತಾವು ಬಯಲಿನಲ್ಲಿ ಸಮರ್ಪಿಸುವ ಬಲಿಗಳನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿಯಲ್ಲಿ ಯಾಜಕನ ಬಳಿಗೆ ತಂದು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮಾಧಾನದ ಬಲಿಯಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ಯಾಜಕನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಬಲಿಪೀಠದ ಮೇಲೆ ರಕ್ತವನ್ನು ಚಿಮುಕಿಸಬೇಕು. ಕೊಬ್ಬನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಆಹ್ಲಾದಕರ ಸುಗಂಧ ವಾಸನೆಯಾಗಿ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ಜಾರತ್ವ ಮಾಡುವಂತೆ ಅವರು ಇದುವರೆಗೆ ಪೂಜಿಸುತ್ತಿದ್ದ ಆ ಮೇಕೆ ದೇವತೆಗಳಿಗೆ ಇನ್ನೆಂದಿಗೂ ತಮ್ಮ ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸಬಾರದು. ಇದು ಅವರಿಗೂ ಅವರ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತವಾದ ನಿಯಮ.’ ");
INSERT INTO kanokcv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ಇದಲ್ಲದೆ ನೀನು ಅವರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ಇಸ್ರಾಯೇಲಿನ ಮನೆತನದವರಲ್ಲಿ ಯಾವ ಮನುಷ್ಯನಾದರು ಇಲ್ಲವೆ ನಿಮ್ಮೊಳಗೆ ಪ್ರವಾಸಿಗರಾಗಿದ್ದ ಪರಕೀಯರು ದಹನಬಲಿಯನ್ನಾಗಲಿ, ಯಜ್ಞವನ್ನಾಗಲಿ ಅರ್ಪಿಸಿದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ಅದನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸುವಂತೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಗೆ ತಾರದಿದ್ದರೆ, ಆ ಮನುಷ್ಯನನ್ನು ತನ್ನ ಜನರ ಮಧ್ಯದೊಳಗಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘ಇದಲ್ಲದೆ ಇಸ್ರಾಯೇಲ್ ಮನೆತನದಲ್ಲಿ ಯಾವನಾದರೂ ನಿಮ್ಮ ಮಧ್ಯದೊಳಗೆ ಪ್ರವಾಸಿಯಾಗಿರುವ ಪರಕೀಯನಾದರೂ, ಯಾವುದೇ ತರದ ರಕ್ತವನ್ನು ತಿಂದರೆ, ರಕ್ತವನ್ನು ತಿನ್ನುವ ಆ ಪ್ರಾಣಕ್ಕೆ ನಾನು ವಿಮುಖನಾಗಿರುವೆನು, ಅವನನ್ನು ಅವನ ಜನರ ಮಧ್ಯದೊಳಗಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ಏಕೆಂದರೆ ದೇಹದ ಜೀವವು ರಕ್ತದೊಳಗೆ ಇರುತ್ತದೆ ಮತ್ತು ನಾನು ಅದನ್ನು ನಿಮ್ಮ ಆತ್ಮಗಳಿಗೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕಾಗಿ ಬಲಿಪೀಠದ ಮೇಲೆ ನಿಮಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ಪ್ರಾಣಕ್ಕೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದು ರಕ್ತವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ಆದಕಾರಣ ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಿದೆನು, “ನಿಮ್ಮಲ್ಲಿಯಾಗಲಿ, ನಿಮ್ಮ ನಡುವೆ ತಂಗಿರುವ ಪರಕೀಯರಲ್ಲಿಯಾಗಲಿ ಯಾರೂ ರಕ್ತವನ್ನು ಭುಜಿಸಬಾರದು.” ");
INSERT INTO kanokcv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘ಇದಲ್ಲದೆ ಇಸ್ರಾಯೇಲರು ಯಾವ ಮನುಷ್ಯನಾದರೂ ಇಲ್ಲವೆ ನಿಮ್ಮೊಳಗೆ ಪ್ರವಾಸಿಯಾಗಿರುವ ಪರಕೀಯನಾದರೂ ತಿನ್ನುವುದಕ್ಕಾಗಿ ಬೇಟೆಯಾಡಿ, ಯಾವುದೇ ಪಶುವನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಪಕ್ಷಿಯನ್ನಾಗಲಿ ಹಿಡಿದರೆ, ಅದರ ರಕ್ತವನ್ನೆಲ್ಲಾ ಸುರಿದು ಅದನ್ನು ಮಣ್ಣಿನಿಂದ ಮುಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ಏಕೆಂದರೆ ಅದು ಎಲ್ಲಾ ಶರೀರಗಳ ಜೀವವಾಗಿದೆ. ಅದಕ್ಕಿರುವ ರಕ್ತವು ಅದರ ಜೀವಕ್ಕಾಗಿಯೇ ಇದೆ. ಆದ್ದರಿಂದ ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ, “ನೀವು ಯಾವ ತರಹದ ರಕ್ತವನ್ನೂ ತಿನ್ನಬಾರದು,” ಎಂದು ಹೇಳಿದ್ದೇನೆ. ಏಕೆಂದರೆ ಎಲ್ಲಾ ಶರೀರಗಳ ಜೀವವೂ ಅದರ ರಕ್ತದಲ್ಲಿಯೇ ಇದೆ. ಅದನ್ನು ತಿನ್ನುವ ಯಾವನನ್ನಾದರೂ ಬಹಿಷ್ಕರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘ಸ್ವದೇಶದವನಾಗಲಿ ಇಲ್ಲವೆ ಪರಕೀಯನಾಗಲಿ ತನ್ನಷ್ಟಕ್ಕೆ ತಾನೇ ಸತ್ತು ಹೋದದ್ದನ್ನು ಇಲ್ಲವೆ ಕಾಡುಮೃಗ ಕೊಂದದ್ದನ್ನು ತಿಂದ ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಸಂಜೆಯವರೆಗೆ ಅವನು ಅಶುದ್ಧನಾಗಿರಬೇಕು. ತರುವಾಯ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ಆದರೆ ಅವನು ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳದೆ ಇದ್ದರೆ, ಇಲ್ಲವೆ ತಾನು ಸ್ನಾನ ಮಾಡದಿದ್ದರೆ, ತನ್ನ ಅಪರಾಧವನ್ನು ತಾನೇ ಹೊತ್ತುಕೊಳ್ಳಬೇಕು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೀಗೆ ಹೇಳಬೇಕು, ‘ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ನೀವು ವಾಸವಾಗಿದ್ದ ಈಜಿಪ್ಟ್ ದೇಶದ ಆಚಾರಗಳನ್ನು ಅನುಸರಿಸಬಾರದು. ನಿಮ್ಮನ್ನು ಸೇರಿಸಲಿರುವ ಕಾನಾನ್ ದೇಶದವರ ಆಚಾರಗಳನ್ನು ನೀವು ಮಾಡಬಾರದು. ಇಲ್ಲವೆ ನೀವು ಅವರ ಪದ್ಧತಿಗಳನುಸಾರ ನಡೆಯಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ನೀವು ನನ್ನ ನಿರ್ಣಯಗಳನ್ನು ಕೈಗೊಂಡು ಕಟ್ಟಳೆಗಳ ಪ್ರಕಾರ ನಡೆಯಬೇಕು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ಆದ್ದರಿಂದ ನೀವು ನನ್ನ ನಿಯಮಗಳನ್ನೂ, ನನ್ನ ನಿರ್ಣಯಗಳನ್ನೂ ಕೈಗೊಳ್ಳಿರಿ. ಇವುಗಳನ್ನು ಅನುಸರಿಸುವವರು ನಿಯಮಗಳ ಮೂಲಕವೇ ಬದುಕುವರು, ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘ನಿಮ್ಮಲ್ಲಿ ಯಾವನಾದರೂ ತನ್ನ ಹತ್ತಿರ ಸಂಬಂಧಿಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಬೆಳೆಸಬಾರದು, ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘ನಿನ್ನ ತಾಯಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಿ, ನಿನ್ನ ತಂದೆಯನ್ನು ಅಗೌರವಿಸಬೇಡ. ಆಕೆ ನಿನ್ನ ತಾಯಿ: ಆಕೆಯೊಂದಿಗೆ ಇಂಥ ಸಂಬಂಧ ಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘ನಿನ್ನ ಮಲತಾಯಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬೇಡ. ಅದು ನಿನ್ನ ತಂದೆಗೆ ಅಗೌರವವನ್ನುಂಟು ಮಾಡುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘ನಿನ್ನ ಸಹೋದರಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬೇಡ. ಆಕೆ ನಿನ್ನ ತಂದೆಯ ಮಗಳಾಗಿರಬಹುದು ಇಲ್ಲವೆ ತಾಯಿಯ ಮಗಳಾಗಿರಬಹುದು. ಆಕೆ ಒಂದೇ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿರಬಹುದು ಇಲ್ಲವೆ ಬೇರೆ ಕಡೆಯಲ್ಲಿ ಹುಟ್ಟಿರಬಹುದು ಆಕೆಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘ನಿನ್ನ ಮಗನ ಮಗಳ ಕೂಡ, ಇಲ್ಲವೆ ಮಗಳ ಮಗಳ ಕೂಡ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬೇಡ. ಅದು ನಿನಗೆ ಅಗೌರವವಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘ನಿನ್ನ ತಂದೆಯಿಂದ ಜನಿಸಿದ ನಿನ್ನ ತಂದೆಯ ಮಗಳೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬೇಡ. ಆಕೆ ನಿನ್ನ ಸಹೋದರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘ನಿನ್ನ ತಂದೆಯ ಸಹೋದರಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬೇಡ. ಆಕೆ ನಿನ್ನ ತಂದೆಯ ಸಮೀಪ ಬಂಧು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘ನಿನ್ನ ತಾಯಿಯ ಸಹೋದರಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬೇಡ. ಅವಳು ನಿನ್ನ ತಾಯಿಗೆ ಹತ್ತಿರದ ಸಂಬಂಧಿಯಾಗಿದ್ದಾಳೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘ನಿನ್ನ ತಂದೆಯ ಸಹೋದರನ ಹೆಂಡತಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಬೆಳೆಸಬೇಡ. ನಿನ್ನ ತಂದೆಯ ಸಹೋದರನನ್ನು ಅಗೌರವಿಸಬೇಡ. ಆಕೆ ನಿನ್ನ ದೊಡ್ಡಮ್ಮ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘ನಿನ್ನ ಸೊಸೆಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಪರ್ಕ ಬೇಡ. ಆಕೆ ನಿನ್ನ ಮಗನ ಹೆಂಡತಿ. ನೀನು ಅವಳ ಬೆತ್ತಲೆತನವನ್ನು ಕಾಣುವಂತೆ ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘ನೀನು ನಿನ್ನ ಸಹೋದರನ ಹೆಂಡತಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬೇಡ. ಅದು ನಿನ್ನ ಸಹೋದರನನ್ನು ಅಗೌರವಿಸುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘ಸ್ತ್ರೀಯೊಂದಿಗೂ, ಆಕೆಯ ಮಗಳೊಂದಿಗೂ ಒಟ್ಟಿಗೆ ಲೈಂಗಿಕ ಸಂಪರ್ಕ ಬೇಡ. ಆಕೆಯ ಮಗನ ಮಗಳೊಂದಿಗಾದರೂ, ಮಗಳ ಮಗಳೊಂದಿಗಾದರೂ ಲೈಂಗಿಕ ಸಂಪರ್ಕ ಬೇಡ. ಅವರು ಆಕೆಯ ಹತ್ತಿರ ಸಂಬಂಧಿಗಳು. ಅದು ದುಷ್ಟತನ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘ನಿನ್ನ ಹೆಂಡತಿಗೆ ವೈರಿಯಾಗುವ ಹಾಗೆ ಅವಳ ಸಹೋದರಿಯನ್ನು ಹೆಂಡತಿಯಾಗಿ ತೆಗೆದುಕೊಳ್ಳಬೇಡ. ಒಬ್ಬಳು ಜೀವಂತವಾಗಿರುವಾಗ ಮತ್ತೊಬ್ಬಳೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘ಮುಟ್ಟಿನಿಂದ ಅಶುದ್ಧಳಾದ ಸ್ತ್ರೀಯ ಸಂಪರ್ಕ ಮಾಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘ಪರರ ಹೆಂಡತಿಯೊಂದಿಗೆ ನೀನು ಸಂಗಮಿಸಿ ಅಶುದ್ಧನಾಗಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘ನಿನ್ನ ಮಕ್ಕಳಲ್ಲಿ ಯಾರನ್ನೂ ಮೋಲೆಕ್ ದೇವತೆಗೆ ಸಮರ್ಪಿಸಿ, ನಿನ್ನ ದೇವರ ಹೆಸರನ್ನು ಅಪಕೀರ್ತಿಗೆ ಗುರಿಮಾಡಬಾರದು. ನಾನು ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘ಸ್ತ್ರೀಯೊಂದಿಗೆ ಮಲಗಿಕೊಳ್ಳುವಂತೆ ಪುರುಷನೊಂದಿಗೆ ಮಲಗಬಾರದು. ಅದು ಅಸಹ್ಯವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘ಇದಲ್ಲದೆ ಪಶುವಿನೊಂದಿಗೆ ನೀನು ಮಲಗಿ ನಿನ್ನನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳಬಾರದು. ಯಾವ ಸ್ತ್ರೀಯೂ ಸಂಗಮಕ್ಕಾಗಿ ಪಶುವಿನ ಮುಂದೆ ನಿಲ್ಲಬಾರದು. ಅದು ಸ್ವಭಾವಕ್ಕೆ ವ್ಯತಿರಿಕ್ತವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘ನೀವು ಈ ಯಾವ ವಿಷಯಗಳಲ್ಲಿಯೂ ನಿಮ್ಮನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳಬಾರದು. ಏಕೆಂದರೆ ನಿಮ್ಮ ಮುಂದೆಯೇ ನಾನು ಹೊರಡಿಸಿಬಿಟ್ಟ ಜನಾಂಗಗಳು ಇವೆಲ್ಲವುಗಳಿಂದ ಹೊಲೆಯಾಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ದೇಶವೂ ಅಶುದ್ಧವಾಗಿದೆ. ಆದ್ದರಿಂದ ಅದರ ಮೇಲಿರುವ ಅಕ್ರಮವನ್ನು ನಾನು ದಂಡಿಸುವೆನು. ಆಗ ದೇಶವು ತಾನೇ ತನ್ನೊಳಗಿನ ನಿವಾಸಿಗಳನ್ನು ಕಾರಿಬಿಡುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ಆದ್ದರಿಂದ ನೀವು ನನ್ನ ನಿಯಮಗಳನ್ನು, ನನ್ನ ನಿರ್ಣಯಗಳನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ಸ್ವದೇಶದವರಲ್ಲಿ ಯಾವನಾಗಲಿ ಇಲ್ಲವೆ ನಿಮ್ಮೊಳಗೆ ಪ್ರವಾಸಿಯಾಗಿದ್ದ ಪರಕೀಯನಾಗಲಿ ಈ ಅಸಹ್ಯವಾದವುಗಳಲ್ಲಿ ಒಂದನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ನಿಮ್ಮೆದುರಿನಲ್ಲಿದ್ದ ಆ ದೇಶದವರು ಈ ಎಲ್ಲಾ ಅಸಹ್ಯವಾದವುಗಳನ್ನು ಮಾಡಿದ್ದರಿಂದ ದೇಶವೂ ಅಶುದ್ಧವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ನೀವೂ ಅದನ್ನು ಅಶುದ್ಧಮಾಡಿದರೆ, ಅದು ನಿಮಗಿಂತ ಮೊದಲಿದ್ದ ಜನಾಂಗಗಳವರನ್ನು ಕಾರಿದಂತೆ ನಿಮ್ಮನ್ನೂ ಕಾರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘ಏಕೆಂದರೆ ಯಾವನಾದರೂ ಈ ಅಸಹ್ಯವಾದವುಗಳಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ಮಾಡಿದರೆ, ಅವನನ್ನು ಅವರ ಜನರ ಮಧ್ಯದೊಳಗಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ನಿಮಗಿಂತ ಮೊದಲಿನವರು ಮಾಡಿದಂತೆ ಅಸಹ್ಯವಾದ ಆಚರಣೆಗಳಲ್ಲಿ ಒಂದನ್ನಾದರೂ ನೀವು ಮಾಡದಂತೆ ಮತ್ತು ಅವುಗಳಲ್ಲಿ ನಿಮ್ಮನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳದಂತೆ ನೀವು ನನ್ನ ಕಟ್ಟಳೆಗಳನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ಇಸ್ರಾಯೇಲರ ಸಭೆಯವರೆಲ್ಲರ ಸಂಗಡ ಮಾತನಾಡಿ, ಅವರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು: ‘ನೀವು ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರಾದ ನಾನು ಪರಿಶುದ್ಧನಾಗಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ತಾಯಿಗೂ ತನ್ನ ತಂದೆಗೂ ಭಯಪಟ್ಟು, ನನ್ನ ವಿಶ್ರಾಂತಿಯ ದಿನಗಳನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘ನೀವು ವಿಗ್ರಹಗಳ ಕಡೆಗೆ ತಿರುಗಿಕೊಳ್ಳಬೇಡಿರಿ. ಇಲ್ಲವೆ ನಿಮಗೋಸ್ಕರವಾಗಿ ಎರಕದ ದೇವರುಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘ನೀವು ನಿಮ್ಮ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮಾಧಾನದ ಬಲಿಯನ್ನು ಸಮರ್ಪಿಸುವುದಾದರೆ, ನೀವು ಆತನಿಗೆ ಮೆಚ್ಚಿಗೆಯಾಗುವ ರೀತಿಯಲ್ಲಿಯೇ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ಅದನ್ನು ನೀವು ಸಮರ್ಪಿಸಿದ ದಿನದಲ್ಲಿಯೂ ಮಾರನೆಯ ದಿನದಲ್ಲಿಯೂ ತಿನ್ನಬೇಕು. ಆದರೆ ಅದು ಮೂರನೆಯ ದಿನದವರೆಗೆ ಉಳಿದರೆ ಅದನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ಅದನ್ನು ಮೂರನೆಯ ದಿನದಲ್ಲಿ ತಿಂದದ್ದೇ ಆದರೆ, ಅದು ಅಸಹ್ಯವಾದದ್ದು, ಅದು ಅಂಗೀಕೃತವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ಆದ್ದರಿಂದ ಅದನ್ನು ತಿನ್ನುವ ಪ್ರತಿಯೊಬ್ಬರೂ ತಮ್ಮ ಅಪರಾಧವನ್ನು ಹೊತ್ತುಕೊಳ್ಳಬೇಕು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರಿಗೆ ಪವಿತ್ರವಾದದ್ದನ್ನು ಅವರು ಅಶುದ್ಧಮಾಡಿದ್ದಾನೆ. ಅಂಥವರನ್ನು ತಮ್ಮ ಜನರ ಮಧ್ಯದೊಳಗಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘ನೀವು ನಿಮ್ಮ ಭೂಮಿಯ ಪೈರನ್ನು ಕೊಯ್ಯುವಾಗ, ನಿಮ್ಮ ಹೊಲದ ಮೂಲೆಗಳಲ್ಲಿ ಸಂಪೂರ್ಣವಾಗಿ ಕೊಯ್ಯಬಾರದು. ಇಲ್ಲವೆ ನಿಮ್ಮ ಸುಗ್ಗಿಯ ಹಕ್ಕಲುಗಳನ್ನು ಕೂಡಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ನಿಮ್ಮ ದ್ರಾಕ್ಷಿತೋಟದಲ್ಲಿ ಹಕ್ಕಲಾಯಬಾರದು. ಇಲ್ಲವೆ ಪ್ರತಿಯೊಂದು ದ್ರಾಕ್ಷಿಯನ್ನೂ ಕೂಡಿಸಬಾರದು. ನೀವು ಅವುಗಳನ್ನು ಬಡವರಿಗಾಗಿಯೂ ಪರಕೀಯರಿಗಾಗಿಯೂ ಬಿಟ್ಟುಬಿಡಬೇಕು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘ಕದಿಯಬಾರದು. “ ‘ಸುಳ್ಳಾಡಬಾರದು. “ ‘ಒಬ್ಬರಿಗೊಬ್ಬರು ಮೋಸಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘ನನ್ನ ಹೆಸರಿನಲ್ಲಿ ಸುಳ್ಳು ಪ್ರಮಾಣ ಮಾಡಬಾರದು. ನಿಮ್ಮ ದೇವರ ಹೆಸರನ್ನು ಅಗೌರವಿಸಬಾರದು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘ನಿಮ್ಮ ನೆರೆಯವನನ್ನು ವಂಚಿಸಬಾರದು. “ ‘ಇಲ್ಲವೆ ಅವನನ್ನು ಸುಲಿದುಕೊಳ್ಳಬಾರದು. ಕೂಲಿಯಾಳಿನ ಕೂಲಿಯು ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ರಾತ್ರಿಯೆಲ್ಲಾ ಮತ್ತು ಮುಂಜಾನೆಯವರೆಗೆ ಇರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘ಕಿವುಡನನ್ನು ಶಪಿಸಬಾರದು. ಇಲ್ಲವೆ ಕಣ್ಣು ಕಾಣದವನನ್ನು ಮುಗ್ಗರಿಸುವಂತೆ ಮಾಡಬಾರದು. ನಿಮ್ಮ ದೇವರಿಗೆ ಭಯಪಡಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘ವ್ಯಾಜ್ಯ ತೀರಿಸುವಾಗ ನೀನು ಅನ್ಯಾಯ ಮಾಡದಿರು. ಬಡವನ ಮುಖ ದಾಕ್ಷಿಣ್ಯವನ್ನಾಗಲಿ, ಬಲಿಷ್ಠನ ಘನತೆಯನ್ನಾಗಲಿ ಲಕ್ಷಿಸದೆ ನಿಷ್ಪಕ್ಷಪಾತವಾಗಿ ತೀರ್ಪುಕೊಡು. ನಿನ್ನ ನೆರೆಯವನಿಗೆ ನೀತಿಯಲ್ಲಿ ನ್ಯಾಯವಾಗಿ ತೀರ್ಪುಮಾಡು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘ನಿನ್ನ ಜನರ ಮಧ್ಯದಲ್ಲಿ ಚಾಡಿಗಾರನಾಗಿ ತಿರುಗಾಡಬೇಡ. “ ‘ನಿನ್ನ ನೆರೆಯವನ ರಕ್ತಾಪರಾಧಕ್ಕೆ ಕಾರಣನಾಗಬೇಡ. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘ನಿನ್ನ ಹೃದಯದಲ್ಲಿ ನಿನ್ನ ಸಹೋದರನನ್ನು ದ್ವೇಷಿಸಬೇಡ, ನಿನ್ನ ನೆರೆಯವನ ಪಾಪವು ನಿನ್ನ ಮೇಲೆ ಬಾರದಂತೆ ಅವನನ್ನು ತಪ್ಪದೆ ಗದರಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘ನಿನ್ನ ಜನರ ಮಕ್ಕಳ ಮೇಲೆ ಮುಯ್ಯಿಗೆ ಮುಯ್ಯಿ ತೀರಿಸದವನಾಗಿಯೂ, ಸೇಡು ತೀರಿಸದೆಯೂ ಇರು. ನಿನ್ನ ನೆರೆಯವನನ್ನು ನಿನ್ನಂತೆಯೇ ಪ್ರೀತಿಸಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘ನೀನು ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. “ ‘ನಿನ್ನ ಪಶುಗಳನ್ನು ಬೇರೆ ಜಾತಿಯೊಂದಿಗೆ ಕೂಡಗೊಡಿಸಬೇಡ. “ ‘ನಿನ್ನ ಹೊಲದಲ್ಲಿ ಮಿಶ್ರವಾದ ಬೀಜಗಳನ್ನು ಬಿತ್ತಬೇಡ. “ ‘ಇದಲ್ಲದೆ ನಾರು ಮತ್ತು ಉಣ್ಣೆ ಕೂಡಿಸಿದ ಬಟ್ಟೆ ನಿನ್ನ ಮೇಲೆ ಇರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘ಒಬ್ಬ ಪುರುಷನಿಗೆ ನಿಶ್ಚಿತವಾಗಿರುವ ದಾಸಿಯಾದ ಒಬ್ಬ ಸ್ತ್ರೀಯೊಂದಿಗೆ ಒಬ್ಬ ಮನುಷ್ಯನು ಸಂಗಮಿಸುವುದಕ್ಕಾಗಿ ಮಲಗಿದರೆ ಅವಳು ಬಿಡುಗಡೆಯನ್ನು ಹೊಂದಿರದಿದ್ದರೆ, ಇಲ್ಲವೆ ಅವಳಿಗೆ ಸ್ವಾತಂತ್ರ್ಯವನ್ನು ಕೊಡದಿರದಿದ್ದರೆ, ತಕ್ಕ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ಅವಳು ಸ್ವತಂತ್ರಳಲ್ಲದ ಕಾರಣ ಅವಳಿಗೆ ಮರಣದಂಡನೆಯನ್ನು ವಿಧಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ಅವನು ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯ ಟಗರಾದ ತನ್ನ ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ಅವನು ಮಾಡಿದ ಪಾಪಕ್ಕಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯಾಗಿರುವ ಟಗರಿನಿಂದ ಯಾಜಕನು ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಆಗ ಅವನು ಮಾಡಿದ ಪಾಪವನ್ನು ಅವನಿಗೆ ಕ್ಷಮಿಸಲಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘ನೀವು ದೇಶದೊಳಗೆ ಬಂದು ಎಲ್ಲಾ ತರಹದ ಮರಗಳನ್ನು ಆಹಾರಕ್ಕೋಸ್ಕರ ನೆಟ್ಟಾಗ, ಅದರ ಫಲವನ್ನು ಮೂರು ವರುಷಗಳವರೆಗೆ ಅಶುದ್ಧವೆಂದೆಣಿಸಿ ಅದನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ಆದರೆ ನಾಲ್ಕನೆಯ ವರುಷದಲ್ಲಿ ಅದರ ಎಲ್ಲಾ ಫಲವು ಯೆಹೋವ ದೇವರ ಸ್ತೋತ್ರಕ್ಕಾಗಿ ಪರಿಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ಐದನೆಯ ವರುಷದಲ್ಲಿ ಅದರ ಫಲವನ್ನು ನೀವು ತಿನ್ನಬೇಕು. ಆಗ ಅದು ನಿಮಗೆ ಇನ್ನೂ ಸಮೃದ್ಧಿಯಾಗಿ ಫಲಿಸುವುದು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘ರಕ್ತದೊಂದಿಗೆ ಯಾವುದನ್ನೂ ನೀವು ತಿನ್ನಬಾರದು. “ ‘ಇದಲ್ಲದೆ ಮಂತ್ರವನ್ನು ಮಾಡಬಾರದು. ಇಲ್ಲವೆ ಶಕುನಗಳನ್ನು ನೋಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘ನಿಮ್ಮ ತಲೆಯ ಮೂಲೆಗಳನ್ನು ದುಂಡಗೆ ಕತ್ತರಿಸಬಾರದು. ಇದಲ್ಲದೆ ನಿಮ್ಮ ಗಡ್ಡದ ಮೂಲೆಯನ್ನು ಕೆಡಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘ಸತ್ತವರಿಗಾಗಿ ನಿಮ್ಮ ಶರೀರವನ್ನು ಕೊಯ್ದುಕೊಳ್ಳಬಾರದು. ನಿಮ್ಮ ಮೇಲೆ ಯಾವ ಹಚ್ಚೆಗಳನ್ನೂ ಹಚ್ಚಿಸಿಕೊಳ್ಳಬಾರದು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘ನಿನ್ನ ಮಗಳು ವೇಶ್ಯೆಯಾಗುವಂತೆ ವ್ಯಭಿಚಾರಕ್ಕೆ ಬಿಡಬಾರದು. ಹಾಗೆ ಮಾಡಿದರೆ, ದೇಶವು ವೇಶ್ಯೆತನಕ್ಕೆ ಒಳಪಡುವುದು ಮತ್ತು ಕೆಟ್ಟತನದಿಂದ ತುಂಬಿಹೋಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘ನನ್ನ ವಿಶ್ರಾಂತಿಯ ದಿನಗಳನ್ನು ನೀವು ಆಚರಿಸಬೇಕು. ನನ್ನ ಪರಿಶುದ್ಧಸ್ಥಳದ ವಿಷಯದಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವರಾಗಿರಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘ಮಾಟಗಾರರನ್ನು ಲಕ್ಷಿಸಬೇಡ, ಅಲ್ಲದೆ ಅವರಿಂದ ಅಶುದ್ಧವಾಗದಂತೆ ಭೂತಪ್ರೇತಗಳನ್ನು ವಿಚಾರಿಸುವವರನ್ನು ಅನುಸರಿಸಬೇಡ. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘ತಲೆ ನೆರೆತ ವೃದ್ಧರ ಮುಂದೆ ಎದ್ದು ನಿಂತುಕೊಳ್ಳಬೇಕು, ಅವರ ಸಮ್ಮುಖವನ್ನು ಗೌರವಿಸು. ನಿನ್ನ ದೇವರಿಗೆ ಭಯಪಡಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘ಒಬ್ಬ ಪರಕೀಯನು ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ನಿನ್ನೊಂದಿಗೆ ಪ್ರವಾಸಿಯಾಗಿದ್ದರೆ, ಅವನನ್ನು ಉಪದ್ರವ ಪಡಿಸಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ಆದರೆ ನಿಮ್ಮಲ್ಲಿ ವಾಸವಾಗಿರುವ ಪರಕೀಯನು ನಿಮ್ಮೊಳಗೇ ಸ್ವದೇಶದವನಂತಿರಲಿ. ನೀವು ಅವನನ್ನು ನಿಮ್ಮಂತೆಯೇ ಪ್ರೀತಿಸಬೇಕು. ಏಕೆಂದರೆ ನೀವು ಸಹ ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಪರಕೀಯರಾಗಿದ್ದಿರಿ. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘ನಿಮ್ಮ ನಿರ್ಣಯದಲ್ಲಿಯೂ, ಅಳೆಯುವುದರಲ್ಲಿಯೂ, ತೂಕದಲ್ಲಿಯೂ, ಅಳತೆಯಲ್ಲಿಯೂ ನೀವು ಅನ್ಯಾಯ ಮಾಡಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ತಕ್ಕಡಿ, ತೂಕದ ಕಲ್ಲುಗಳು, ಕಿಲೋಗ್ರಾಂ ಮತ್ತು ಲೀಟರ್ ನ್ಯಾಯಯುತವಾಗಿರಲಿ. ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ನಿಮ್ಮನ್ನು ಹೊರಗೆ ತಂದ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘ಆದ್ದರಿಂದ ನನ್ನ ಎಲ್ಲಾ ಆಜ್ಞೆಗಳನ್ನೂ, ನನ್ನ ಎಲ್ಲಾ ನ್ಯಾಯಗಳನ್ನೂ ನೀವು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು,’ ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು: ‘ಇಸ್ರಾಯೇಲರಲ್ಲಿಯಾಗಲಿ, ಇಸ್ರಾಯೇಲಿನಲ್ಲಿ ಪ್ರವಾಸಿಯಾದ ಪರಕೀಯರಲ್ಲಿಯಾಗಲಿ ಯಾವನಾದರೂ ತನ್ನ ಸಂತತಿಯನ್ನು ಮೋಲೆಕನಿಗೆ ಕೊಟ್ಟರೆ, ನಿಶ್ಚಯವಾಗಿ ಅವನಿಗೆ ಮರಣವನ್ನು ವಿಧಿಸಬೇಕು. ದೇಶದ ಜನರು ಅವನಿಗೆ ಕಲ್ಲೆಸೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ನಾನು ಆ ಮನುಷ್ಯನಿಗೆ ವಿಮುಖನಾಗಿರುವೆನು. ಅವನನ್ನು ಅವನ ಜನರ ಮಧ್ಯದೊಳಗಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ಏಕೆಂದರೆ ಅವನು ನನ್ನ ಹೆಸರನ್ನು ಅಪವಿತ್ರಗೊಳಿಸುವಂತೆ ಮತ್ತು ನನ್ನ ಪವಿತ್ರ ಸ್ಥಳವನ್ನು ಅಶುದ್ಧಮಾಡುವಂತೆ ತನ್ನ ಮಕ್ಕಳನ್ನು ಮೋಲೆಕನಿಗೆ ಕೊಟ್ಟಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ಆ ಮನುಷ್ಯನು ತನ್ನ ಸಂತತಿಯನ್ನು ಮೋಲೆಕನಿಗೆ ಕೊಡುವಾಗ, ಜನರು ತಮ್ಮ ಕಣ್ಣುಗಳನ್ನು ಮರೆಮಾಡಿ, ಅವನನ್ನು ಕೊಲ್ಲದೆ ಹೋದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ಆಗ ನಾನು ಆ ಮನುಷ್ಯನಿಗೂ, ಅವನ ಕುಟುಂಬಕ್ಕೂ ವಿರೋಧವಾಗಿಯೂ, ವಿಮುಖವಾಗಿಯೂ ಇರುವೆನು. ಮೋಲೆಕನನ್ನು ಪೂಜೆ ಮಾಡಿದ್ದಕ್ಕಾಗಿ ಅವನನ್ನೂ, ದೇವದ್ರೋಹಿಗಳಾಗಿ ಅವನನ್ನು ಹಿಂಬಾಲಿಸುವವರೆಲ್ಲರನ್ನೂ ಅವರ ಜನರ ಮಧ್ಯದೊಳಗಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘ಇದಲ್ಲದೆ ಮಾಟಗಾರರನ್ನು ಮತ್ತು ಭೂತಪ್ರೇತಗಳನ್ನು ವಿಚಾರಿಸುವವರ ಬಳಿಗೆ ಹೋಗಿ, ಅವರ ಆಲೋಚನೆ ಕೇಳಿಕೊಂಡು ದೇವದ್ರೋಹಿಯಾದರೆ ನಾನು ಅಂಥ ಮನುಷ್ಯನಿಗೆ ವಿಮುಖನಾಗಿರುವೆನು. ಅವನನ್ನು ಅವನ ಜನರ ಮಧ್ಯದೊಳಗಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘ಆದ್ದರಿಂದ ನೀವು ನಿಮ್ಮನ್ನು ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳಿರಿ ಮತ್ತು ಪರಿಶುದ್ಧರಾಗಿರಿ. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ಇದಲ್ಲದೆ ನೀವು ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಕೈಗೊಂಡು ಅವುಗಳನ್ನು ಪಾಲಿಸಬೇಕು. ನಿಮ್ಮನ್ನು ಶುದ್ಧಪಡಿಸುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘ತನ್ನ ತಂದೆಯಾನ್ನಾಗಲಿ, ತನ್ನ ತಾಯಿಯನ್ನಾಗಲಿ ಶಪಿಸುವವರಿಗೆ ನಿಶ್ಚಯವಾಗಿ ಮರಣದಂಡನೆ ವಿಧಿಸಬೇಕು. ಯಾರು ತನ್ನ ತಂದೆಯಾನ್ನಾಗಲಿ, ತನ್ನ ತಾಯಿಯನ್ನಾಗಲಿ ಶಪಿಸುವರೋ, ಅವರ ಪಾಪವು ಸ್ವಯಂಕೃತವಾದುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘ಇದಲ್ಲದೆ ಒಬ್ಬನು ಮತ್ತೊಬ್ಬನ ಹೆಂಡತಿಯೊಡನೆ ವ್ಯಭಿಚಾರ ಮಾಡಿದರೆ, ವ್ಯಭಿಚಾರ ಮಾಡುವವನಿಗೂ ಮತ್ತು ವ್ಯಭಿಚಾರ ಮಾಡುವವಳಿಗೂ ನಿಶ್ಚಯವಾಗಿ ಮರಣದಂಡನೆ ವಿಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘ತನ್ನ ತಂದೆಯ ಹೆಂಡತಿಯೊಡನೆ ಸಂಗಮಿಸುವವನು ತನ್ನ ತಂದೆಗೆ ಮಾನಭಂಗ ಮಾಡಿದಂತೆ. ಅವರಿಬ್ಬರಿಗೂ ನಿಶ್ಚಯವಾಗಿ ಮರಣದಂಡನೆ ವಿಧಿಸಬೇಕು. ಅವರ ರಕ್ತವು ಅವರ ಮೇಲೆ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘ಒಬ್ಬನು ತನ್ನ ಸೊಸೆಯೊಂದಿಗೆ ಸಂಗಮಿಸಿದರೆ, ಅವರಿಬ್ಬರಿಗೂ ನಿಶ್ಚಯವಾಗಿ ಮರಣದಂಡನೆ ವಿಧಿಸಬೇಕು. ಅವರು ವಿಕೃತವನ್ನು ಮಾಡಿದ್ದಾರೆ, ಅವರ ಪಾಪವು ಅವರ ಮೇಲೆ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘ಒಬ್ಬ ಮನುಷ್ಯನು ಸ್ತ್ರೀಯೊಂದಿಗೆ ಮಲಗುವಂತೆ ಮತ್ತೊಬ್ಬ ಮನುಷ್ಯನೊಂದಿಗೆ ಮಲಗಿದರೆ, ಅವರಿಬ್ಬರೂ ಅಸಹ್ಯವಾದದ್ದನ್ನು ಮಾಡಿದವರಾಗಿದ್ದಾರೆ. ಅವರಿಗೆ ನಿಶ್ಚಯವಾಗಿಯೂ ಮರಣದಂಡನೆ ವಿಧಿಸಬೇಕು. ಅವರ ರಕ್ತವು ಅವರ ಮೇಲೆ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘ಒಬ್ಬ ಮನುಷ್ಯನು ಒಬ್ಬ ಸ್ತ್ರೀಯನ್ನೂ, ಅವಳ ತಾಯಿಯನ್ನೂ ಮದುವೆ ಮಾಡಿಕೊಂಡರೆ ಅದು ದುಷ್ಟತನವಾಗಿದೆ. ಆದ್ದರಿಂದ ನಿಮ್ಮಲ್ಲಿ ದುಷ್ಟತನವು ಇರದಂತೆ ಆ ಮೂರು ಜನರನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಡಿಸಿಬಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘ಒಬ್ಬನು ಪಶುವಿನೊಂದಿಗೆ ಸಂಗಮಿಸಿದರೆ ಅವನಿಗೆ ನಿಶ್ಚಯವಾಗಿ ಮರಣದಂಡನೆಯಾಗಬೇಕು ಮತ್ತು ನೀವು ಆ ಪಶುವನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘ಇದಲ್ಲದೆ ಒಬ್ಬ ಸ್ತ್ರೀಯು ಒಂದು ಪಶುವಿನೊಂದಿಗೆ ಸಂಗಮಿಸುವುದಕ್ಕಾಗಿ ಮಲಗಿಕೊಂಡರೆ, ನೀವು ಆ ಸ್ತ್ರೀಯನ್ನೂ, ಆ ಪಶುವನ್ನೂ ಕೊಲ್ಲಬೇಕು. ಅವರಿಗೆ ನಿಶ್ಚಯವಾಗಿ ಮರಣದಂಡನೆಯಾಗಬೇಕು. ಅವರ ಪಾಪವು ಅವರ ಮೇಲೆ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘ಒಬ್ಬನು ತನ್ನ ತಂದೆಯ ಇಲ್ಲವೆ ತನ್ನ ತಾಯಿಯ ಮಗಳಾದ ತನ್ನ ಸಹೋದರಿಯ ಬೆತ್ತಲೆತನವನ್ನು ನೋಡಿದರೆ, ಇಲ್ಲವೆ ಅವಳು ಅವನ ಬೆತ್ತಲೆತನವನ್ನು ನೋಡಿದರೆ ಅದು ದುಷ್ಟತನವೇ. ಅವರನ್ನು ತಮ್ಮ ಜನರ ಮಧ್ಯದಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ಅವರ ರಕ್ತವು ಅವರ ಮೇಲೆ ಇರುವುದು. ಅವನು ತನ್ನ ಸಹೋದರಿಯನ್ನು ಸಂಗಮಿಸಿದ್ದರಿಂದ ತನ್ನ ಅಪರಾಧವನ್ನು ತಾನೇ ಹೊತ್ತುಕೊಳ್ಳುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘ಒಬ್ಬ ಮನುಷ್ಯನು ಮುಟ್ಟಾದ ಸ್ತ್ರೀಯೊಂದಿಗೆ ಮಲಗಿ, ಆಕೆಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಪರ್ಕ ಮಾಡಿದರೆ, ಅವನು ಆಕೆಯ ಮುಟ್ಟಿನ ಮೂಲವನ್ನು ಬಹಿರಂಗಪಡಿಸಿದ್ದಾನೆ. ಆಕೆ ಅದನ್ನು ಬಹಿರಂಗಪಡಿಸಿದ್ದಾಳೆ. ಅವರಿಬ್ಬರನ್ನೂ ಸ್ವಜನರಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘ನೀನು ನಿನ್ನ ತಾಯಿಯ ಸಹೋದರಿ ಇಲ್ಲವೆ ತಂದೆಯ ಸಹೋದರಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಪರ್ಕ ಮಾಡಬೇಡ. ಅದು ಸಮೀಪ ಬಂಧುವನ್ನು ಅಗೌರವಿಸಿದ ಹಾಗೆ ಅದಕ್ಕೆ ನೀವಿಬ್ಬರೂ ಜವಾಬ್ದಾರರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘ಒಬ್ಬನು ತನ್ನ ಚಿಕ್ಕಪ್ಪನ ಹೆಂಡತಿಯೊಂದಿಗೆ ಸಂಗಮಿಸಿದರೆ, ಅವನು ತನ್ನ ಚಿಕ್ಕಪ್ಪನನ್ನು ಅಗೌರವಿಸಿದಂತೆ. ಅವರು ತಮ್ಮ ಪಾಪವನ್ನು ಹೊತ್ತುಕೊಳ್ಳಬೇಕು. ಅವರು ಮಕ್ಕಳಿಲ್ಲದೆ ಸಾಯುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘ಒಬ್ಬನು ತನ್ನ ಸಹೋದರನ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಂಡರೆ, ಅದು ಅಶುದ್ಧವಾದದ್ದು. ಏಕೆಂದರೆ ಅವನು ತನ್ನ ಸಹೋದರನನ್ನು ಅಗೌರವಿಸಿದ್ದಾನೆ. ಅವರು ಮಕ್ಕಳಿಲ್ಲದವರಾಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘ನೀವು ನನ್ನ ಎಲ್ಲಾ ನಿಯಮಗಳನ್ನೂ, ನನ್ನ ಎಲ್ಲಾ ನ್ಯಾಯಗಳನ್ನೂ ಕೈಗೊಂಡು ಪಾಲಿಸಬೇಕು. ಹೀಗಿದ್ದರೆ ನೀವು ವಾಸಿಸುವುದಕ್ಕೆ ನಾನು ನಿಮ್ಮನ್ನು ತರುವ ಆ ದೇಶವು ನಿಮ್ಮನ್ನು ಕಾರಿಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ನಾನು ನಿಮ್ಮೆದುರಿನಲ್ಲಿಯೇ ಹೊರಗೆ ಹಾಕಿದ ಜನಾಂಗಗಳಂತೆ ನೀವು ನಡೆಯಬಾರದು. ಏಕೆಂದರೆ ಅವರು ಇಂಥವುಗಳನ್ನೆಲ್ಲಾ ಮಾಡಿದ್ದಾರೆ. ಆದಕಾರಣ ನಾನು ಅವರನ್ನು ಕಂಡು ಅಸಹ್ಯಗೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ಆದರೆ, “ನೀವು ಅವರ ದೇಶವನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳುವಿರಿ. ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ಆ ದೇಶವನ್ನು ನೀವು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳುವಂತೆ ನಾನು ಅದನ್ನು ನಿಮಗೆ ಕೊಡುತ್ತೇನೆ.” ನಿಮ್ಮನ್ನು ಬೇರೆ ಜನರಿಂದ ಪ್ರತ್ಯೇಕಪಡಿಸಿದಂಥ ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘ಆದ್ದರಿಂದ ನೀವು ಶುದ್ಧವಾದ ಮತ್ತು ಅಶುದ್ಧವಾದ ಪಶುಗಳ ಮಧ್ಯದಲ್ಲಿಯೂ, ಅಶುದ್ಧವಾದ ಮತ್ತು ಶುದ್ಧವಾದ ಪಕ್ಷಿಗಳ ಮಧ್ಯದಲ್ಲಿಯೂ ವ್ಯತ್ಯಾಸ ಮಾಡಬೇಕು. ಇದಲ್ಲದೆ ನಾನು ನಿಮ್ಮಿಂದ ಪ್ರತ್ಯೇಕಿಸಿದ ಅಶುದ್ಧವಾದ ಪಶುಗಳಿಂದಲೂ ಇಲ್ಲವೆ ಪಕ್ಷಿಗಳಿಂದಲೂ ಇಲ್ಲವೆ ಭೂಮಿಯ ಮೇಲೆ ಚಲಿಸುವ ಯಾವ ತರವಾದ ಜೀವಿಯಿಂದಲೂ ನೀವು ನಿಮ್ಮ ಪ್ರಾಣಗಳನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ನೀವು ನನ್ನವರಾಗಿರುವಂತೆ ನಿಮ್ಮನ್ನು ಬೇರೆ ಜನರಿಂದ ಪ್ರತ್ಯೇಕಿಸಿದ ಯೆಹೋವ ದೇವರಾದ ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವುದರಿಂದ, ನೀವು ನನಗೆ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘ಪುರುಷನಾಗಲಿ, ಸ್ತ್ರೀಯಾಗಲಿ ಮಾಟಗಾರರಾಗಿದ್ದರೆ ಇಲ್ಲವೆ ಭೂತಪ್ರೇತಗಳನ್ನು ವಿಚಾರಿಸುವವರಾಗಿದ್ದರೆ, ಅವರನ್ನು ನಿಶ್ಚಯವಾಗಿ ಕೊಲ್ಲಬೇಕು. ಅವರ ಪಾಪವು ಅವರ ಮೇಲೆ ಇರುವುದು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು ಆರೋನನ ಮಕ್ಕಳಾದ ಯಾಜಕರೊಂದಿಗೆ ಮಾತನಾಡಿ, ಅವರಿಗೆ ಹೀಗೆ ಹೇಳು: ಸತ್ತವರ ದೇಹವನ್ನು ಮುಟ್ಟುವುದರಿಂದ ಯಾವ ಯಾಜಕನೂ ಅಪವಿತ್ರನಾಗಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ಆದರೆ ತನ್ನ ಹತ್ತಿರದ ಸಂಬಂಧಿಯಾಗಿ, ಅಂದರೆ ಅವನ ತಾಯಿಯಾಗಿ, ತಂದೆಯಾಗಿ, ಅವನ ಮಗನಿಗಾಗಿ, ಅವನ ಮಗಳಿಗಾಗಿ, ಅವನ ಸಹೋದರನಿಗಾಗಿ, ");
INSERT INTO kanokcv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ಅವನಿಗೆ ಹತ್ತಿರದ ಗಂಡನಿಲ್ಲದ ಕನ್ನಿಕೆಯಾದ ಸಹೋದರಿಗಾಗಿ ಹೊರತು, ");
INSERT INTO kanokcv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ಅವನು ತನ್ನ ಜನರೊಳಗೆ ಮುಖ್ಯಸ್ಥನಾಗಿರುವುದರಿಂದ ತನ್ನನ್ನು ತಾನು ಅಪವಿತ್ರವಾಗಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘ಅವರು ತಮ್ಮ ತಲೆಯನ್ನು ಬೋಳಿಸಿಕೊಳ್ಳಬಾರದು. ಅಲ್ಲದೆ ತಮ್ಮ ಗಡ್ಡದ ಮೂಲೆಯನ್ನು ಬೋಳಿಸಿಕೊಳ್ಳಬಾರದು. ದೇಹವನ್ನು ಗಾಯಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ಅವರು ತಮ್ಮ ಯೆಹೋವ ದೇವರಿಗೆ ಅಗ್ನಿಯಿಂದ ಮಾಡಿದ ಸಮರ್ಪಣೆಗಳನ್ನು ಮತ್ತು ತನ್ನ ದೇವರ ರೊಟ್ಟಿಯನ್ನು ಸಮರ್ಪಿಸುವುದರಿಂದ, ಅವರು ತಮ್ಮ ದೇವರ ಹೆಸರನ್ನು ಅಗೌರವಪಡಿಸದೆ, ತಮ್ಮ ದೇವರಿಗೆ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ಆದಕಾರಣ ಅವರು ಪರಿಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘ಯಾಜಕರು ತಮ್ಮ ದೇವರಿಗೆ ಪರಿಶುದ್ಧರಾಗಿರುವುದರಿಂದ ವೇಶ್ಯೆಯನ್ನಾಗಲಿ, ಶೀಲಭ್ರಷ್ಠ ಸ್ತ್ರೀಯನ್ನಾಗಲಿ, ಗಂಡನಿಂದ ವಿಚ್ಛೇದನ ಪಡೆದವಳನ್ನಾಗಲಿ ಹೆಂಡತಿಯನ್ನಾಗಿ ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ಅವರನ್ನು ಪರಿಶುದ್ಧರೆಣಿಸಿ, ಏಕೆಂದರೆ ನಿಮ್ಮ ದೇವರಾದ ನನಗೆ ಆಹಾರವನ್ನು ಸಮರ್ಪಿಸುವವರಾದ ಕಾರಣ ನೀನು ಅವರನ್ನು ದೇವರ ದಾಸರೆಂದು ಭಾವಿಸಬೇಕು. ನಿಮ್ನನ್ನು ನನ್ನ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡಿರುವ ಯೆಹೋವ ದೇವರೆಂಬ ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವುದರಿಂದ ಅವರನ್ನೂ ಪರಿಶುದ್ಧರೆಂದು ನೀನು ಭಾವಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘ಯಾವುದೇ ಯಾಜಕನ ಮಗಳು ವ್ಯಭಿಚಾರ ಕೃತ್ಯದಿಂದ ತನ್ನನ್ನು ಅಪವಿತ್ರ ಮಾಡಿಕೊಂಡರೆ, ಅವಳು ತನ್ನ ತಂದೆಯನ್ನು ಅಗೌರವಿಸಿದ್ದಾಳೆ. ಅವಳನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘ತನ್ನ ಸಹೋದರರೊಳಗೆ ಮಹಾಯಾಜಕನಾಗಿದ್ದು, ಯಾವನು ತೈಲಾಭಿಷೇಕ ಹೊಂದಿ, ದೀಕ್ಷಾವಸ್ತ್ರಗಳನ್ನು ಧರಿಸಿ, ಪಟ್ಟಕ್ಕೆ ಬರುವನೋ, ಅವನು ತನ್ನ ತಲೆಯನ್ನು ಮುಚ್ಚಿಕೊಳ್ಳಲೂಬಾರದು, ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಳ್ಳಲೂಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ಯಾವ ಮೃತ ಶರೀರದ ಬಳಿಗೂ ಹೋಗಬಾರದು, ಅವನು ತನ್ನ ತಂದೆತಾಯಿಗಳ ಮರಣದ ನಿಮಿತ್ತ, ತನ್ನನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ಇದಲ್ಲದೆ ಪರಿಶುದ್ಧ ಸ್ಥಳದಿಂದ ಹೊರಗೆ ಹೋಗಬಾರದು ಮತ್ತು ತನ್ನ ದೇವರ ಪರಿಶುದ್ಧ ಸ್ಥಳವನ್ನು ಅಪವಿತ್ರ ಮಾಡಬಾರದು. ಏಕೆಂದರೆ ತನ್ನ ದೇವರ ಅಭಿಷೇಕ ತೈಲವನ್ನು ತಲೆಯ ಮೇಲೆ ಹೊಯ್ಯಿಸಿಕೊಂಡು ಪ್ರತಿಷ್ಠಿತನಾಗಿದ್ದಾನೆ. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘ಅವನು ಪುರುಷ ಸಂಪರ್ಕವೇ ಇಲ್ಲದ ಯುವತಿಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಬೇಕೇ ಹೊರತು ");
INSERT INTO kanokcv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ವಿಧವೆಯನ್ನಾಗಲಿ, ಗಂಡ ಬಿಟ್ಟ ಸ್ತ್ರೀಯನ್ನಾಗಲಿ, ಇಲ್ಲವೆ ಅಪವಿತ್ರಳನ್ನಾಗಲಿ, ವೇಶ್ಯೆಯನ್ನಾಗಲಿ, ಇಂಥವರನ್ನು ಅವನು ಮದುವೆಯಾಗಬಾರದು. ಆದರೆ ತನ್ನ ಸ್ವಂತ ಜನರಲ್ಲಿ ಒಬ್ಬ ಕನ್ನಿಕೆಯನ್ನು ತನಗೆ ಹೆಂಡತಿಯನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ಇದಲ್ಲದೆ ಅವನು ತನ್ನ ಜನರೊಳಗೆ ತನ್ನ ಸಂತತಿಯನ್ನು ಅಪವಿತ್ರ ಮಾಡಬಾರದು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರಾದ ನಾನು ಅವನನ್ನು ಶುದ್ಧೀಕರಿಸುತ್ತೇನೆ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ಆರೋನನೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೀಗೆ ಹೇಳು: ‘ನಿನ್ನ ಸಂತತಿಯ ವಂಶಾವಳಿಗಳಲ್ಲಿ ಯಾವನಿಗೆ ನ್ಯೂನತೆವಿರುತ್ತದೋ, ಅವನು ದೇವರ ರೊಟ್ಟಿಯನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕಾಗಿ ಬರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ಊನಗೊಂಡ ಮನುಷ್ಯನು ಸಮೀಪಕ್ಕೆ ಬರಬಾರದು. ಎಂದರೆ, ಕಣ್ಣಿಲ್ಲದವನು, ಕುಂಟನು, ಕುರೂಪವುಳ್ಳವನು, ಅಂಗವಿಕಲನು, ");
INSERT INTO kanokcv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ಮುರಿದ ಪಾದವುಳ್ಳವನು, ಮುರಿದ ಕೈಯುಳ್ಳವನು, ");
INSERT INTO kanokcv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ಗೂನು ಬೆನ್ನುಳ್ಳವನು, ಗಿಡ್ಡನು, ಕಣ್ಣುಗಳಲ್ಲಿ ನ್ಯೂನತೆವುಳ್ಳವನು, ಕಜ್ಜಿತುರಿಗಳುಳ್ಳವನು, ತನ್ನನ್ನು ನಪುಂಸಕನನ್ನಾಗಿ ಮಾಡಿಕೊಂಡವನು, ");
INSERT INTO kanokcv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ಯಾಜಕನಾದ ಆರೋನನ ಸಂತತಿಯಲ್ಲಿ ನ್ಯೂನತೆವುಳ್ಳ ಯಾವ ಮನುಷ್ಯನೂ ಅಗ್ನಿ ಸಮರ್ಪಣೆಗಳನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕಾಗಿ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಬರಬಾರದು. ನ್ಯೂನತೆವುಳ್ಳವನು ತನ್ನ ದೇವರ ರೊಟ್ಟಿಯನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕಾಗಿ ಸಮೀಪ ಬರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ಅವನು ದೇವರ ರೊಟ್ಟಿಯಲ್ಲಿ ಪರಿಶುದ್ಧವಾದದ್ದನ್ನೂ, ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದನ್ನೂ ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ಆದರೆ ಅವನು ನ್ಯೂನತೆವುಳ್ಳವನಾದ್ದರಿಂದ ತೆರೆಯ ಒಳಗೆ ಹೋಗಬಾರದು ಹಾಗು ಯಜ್ಞವೇದಿಯ ಬಳಿಗೆ ಬರಬಾರದು. ಹೀಗೆ ಅವನು ನನ್ನ ಪರಿಶುದ್ಧ ಸ್ಥಳವನ್ನು ಅಪವಿತ್ರ ಮಾಡಬಾರದು. ಏಕೆಂದರೆ ಅವರನ್ನು ಶುದ್ಧೀಕರಿಸುವ ಯೆಹೋವ ದೇವರು ನಾನೇ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ಮೋಶೆಯು ಅದನ್ನು ಆರೋನನಿಗೂ, ಅವನ ಪುತ್ರರಿಗೂ, ಇಸ್ರಾಯೇಲರಿಗೂ ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ತರುವಾಯ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ಆರೋನನೊಂದಿಗೂ, ಅವನ ಪುತ್ರರೊಂದಿಗೂ ಮಾತನಾಡು, ಅವರು ನನ್ನ ಪರಿಶುದ್ಧ ಹೆಸರನ್ನು ಅಪವಿತ್ರಮಾಡದಂತೆ ಇಸ್ರಾಯೇಲರು ನನಗೆ ಸಲ್ಲಿಸುವ ಪರಿಶುದ್ಧವಾದವುಗಳನ್ನು ಗೌರವದಿಂದ ಅವರು ಪ್ರತ್ಯೇಕವಾಗಿರಿಸಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“ಅವರಿಗೆ ನೀನು ಹೀಗೆ ಹೇಳು: ‘ನಿಮ್ಮ ಎಲ್ಲಾ ಸಂತತಿಯ ವಂಶಾವಳಿಗಳಲ್ಲಿ ಅಶುದ್ಧತ್ವವಿರುವ ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರಿಗೆ ಸಲ್ಲಿಸುವ ಪರಿಶುದ್ಧವಾದವುಗಳ ಬಳಿಗೆ ಯಾವನು ಬರುವನೋ, ಅವನನ್ನು ನನ್ನ ಸನ್ನಿಧಿಯಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘ಆರೋನನ ಸಂತತಿಯವರಲ್ಲಿ ಯಾವನಾದರೂ ಚರ್ಮರೋಗ ಇಲ್ಲವೆ ಸ್ರಾವವುಳ್ಳವನಿದ್ದರೆ, ಅವನು ಶುದ್ಧನಾಗುವವರೆಗೆ ಪರಿಶುದ್ಧವಾದವುಗಳನ್ನು ತಿನ್ನಬಾರದು. ಹೆಣದಿಂದ ಅಶುದ್ಧವಾದದ್ದನ್ನು ಮುಟ್ಟಿದವನು ಇಲ್ಲವೆ ತನ್ನೊಳಗಿಂದ ವೀರ್ಯ ಹೊರಟವನು ");
INSERT INTO kanokcv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ಇಲ್ಲವೆ ತನ್ನನ್ನು ಅಶುದ್ಧನಾಗುವಂತೆ ಹರಿದಾಡುವ ಯಾವುದನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಅಶುದ್ಧ ಮನುಷ್ಯನನ್ನಾಗಲಿ ಮುಟ್ಟಿದವನು, ");
INSERT INTO kanokcv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು. ಅವನು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಿದ ಮೇಲೆ ಪರಿಶುದ್ಧವಾದವುಗಳನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ಸೂರ್ಯನು ಮುಳುಗಿದಾಗ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ತರುವಾಯ ಅವನು ಪರಿಶುದ್ಧವಾದವುಗಳನ್ನು ತಿನ್ನಲಿ. ಏಕೆಂದರೆ ಅದು ಅವನಿಗೆ ಆಹಾರ. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ತನ್ನನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳದಂತೆ ತನ್ನಷ್ಟಕ್ಕೆ ತಾನೇ ಸತ್ತಿರುವುದನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಕಾಡುಮೃಗಗಳಿಂದ ಕೊಂದದ್ದನ್ನಾಗಲಿ ತಿನ್ನಬಾರದು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘ಯಾಜಕರು ಅದನ್ನು ಅಪವಿತ್ರ ಪಡಿಸಿದರೆ, ಅದರ ನಿಮಿತ್ತ ಅಪರಾಧಿಯಾಗಿ ಸಾಯದಂತೆ ನನ್ನ ವಿಧಿಗಳನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ಅವರನ್ನು ಶುದ್ಧೀಕರಿಸುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘ಪರಿಶುದ್ಧವಾದದ್ದನ್ನು ಪರಕೀಯನು ತಿನ್ನಬಾರದು. ಯಾಜಕನ ಅತಿಥಿಯಾಗಲಿ ಇಲ್ಲವೆ ಕೂಲಿ ಆಳಾಗಲಿ ಪರಿಶುದ್ಧವಾದವುಗಳಲ್ಲಿ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ಆದರೆ ಯಾಜಕನು ಯಾವನನ್ನಾದರೂ ತನ್ನ ಹಣದಿಂದ ಕೊಂಡುಕೊಂಡರೆ, ಅವನು ಅದರಲ್ಲಿ ತಿನ್ನಬಹುದು. ಅವನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವನು ಅದನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ಯಾಜಕನ ಮಗಳು ಒಬ್ಬ ಯಾಜಕನಲ್ಲದವನನ್ನು ಮದುವೆಯಾದರೆ, ಅವಳು ಸಮರ್ಪಣೆಯಾದ ಪರಿಶುದ್ಧವಾದವುಗಳಲ್ಲಿ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ಯಾಜಕನ ಮಗಳು ವಿಧವೆಯಾಗಿದ್ದರೆ ಇಲ್ಲವೆ ಗಂಡಬಿಟ್ಟವಳಾಗಿದ್ದರೆ ಮತ್ತು ಮಕ್ಕಳಿಲ್ಲದವಳಾಗಿ ತನ್ನ ಯೌವನದಲ್ಲಿದ್ದಂತೆಯೇ ತನ್ನ ತಂದೆಯ ಮನೆಗೆ ಹಿಂದಿರುಗಿದವಳಾಗಿದ್ದರೆ, ಅವಳು ತನ್ನ ತಂದೆಯ ಆಹಾರದಲ್ಲಿ ತಿನ್ನಲಿ. ಆದರೆ ಯಾಜಕರಲ್ಲದ ಕುಟುಂಬದವರು ಅದರಲ್ಲಿ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘ಇದಲ್ಲದೆ ಯಾವನಾದರೂ ತಿಳಿಯದೆ ಪರಿಶುದ್ಧವಾದದ್ದನ್ನು ತಿಂದರೆ, ಅವನು ಅದರ ಐದನೆಯ ಪಾಲನ್ನು ಕೂಡಿಸಿ, ಪರಿಶುದ್ಧವಾದದ್ದನ್ನು ಯಾಜಕನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸುವ ಪರಿಶುದ್ಧವಾದವುಗಳನ್ನು ಅವರು ಅಪವಿತ್ರ ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ಇಲ್ಲವೆ ಅವರು ಪರಿಶುದ್ಧವಾದವುಗಳನ್ನು ತಿನ್ನುವುದರಿಂದ ತಮ್ಮ ಮೇಲೆ ಅತಿಕ್ರಮದ ಅಪರಾಧವನ್ನು ಹೊತ್ತುಕೊಳ್ಳದಿರಲಿ. ಏಕೆಂದರೆ ಅವರನ್ನು ಶುದ್ಧೀಕರಿಸುವ ಯೆಹೋವ ದೇವರು ನಾನೇ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“ಆರೋನನೊಂದಿಗೂ, ಅವನ ಪುತ್ರರೊಂದಿಗೂ ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೇಳಬೇಕಾದದ್ದು ಇದೇ, ‘ಇಸ್ರಾಯೇಲ್ ಮನೆತನದವರಲ್ಲಿಯಾಗಲಿ, ಇಸ್ರಾಯೇಲರಾದ ಪರಕೀಯರಲ್ಲಿಯಾಗಲಿ ಯಾರಾದರೂ ತಮ್ಮ ಎಲ್ಲಾ ಪ್ರಮಾಣಗಳ ನಿಮಿತ್ತವಾಗಿ ಕಾಣಿಕೆಯನ್ನು ದಹನಬಲಿಯಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸುವ ಉಚಿತವಾದ ಅರ್ಪಣೆಗಳಲ್ಲಿ ");
INSERT INTO kanokcv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ನೀವು ನಿಮ್ಮ ಸ್ವಯಿಚ್ಛೆಯಿಂದ ಕಳಂಕರಹಿತವಾದ ಗಂಡು ಪಶು, ಕುರಿ ಅಥವಾ ಮೇಕೆಯನ್ನೇ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ಆದರೆ ದೋಷವಿರುವ ಯಾವುದನ್ನೂ ಸಮರ್ಪಿಸಬಾರದು. ಏಕೆಂದರೆ ಅದು ನಿಮಗೋಸ್ಕರ ಅಂಗೀಕಾರವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ತಮ್ಮ ಪ್ರಮಾಣವನ್ನು ಪೂರೈಸುವ ಹಾಗೆ ಯಾರಾದರೂ ಸಮಾಧಾನದ ಬಲಿಯನ್ನಾಗಲಿ, ಪಶುಗಳನ್ನಾಗಲಿ, ಕುರಿಗಳನ್ನಾಗಲಿ ಉಚಿತವಾದ ಕಾಣಿಕೆಯಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸುವುದಾದರೆ, ಅದು ಅಂಗೀಕಾರಕ್ಕೆ ಪರಿಪೂರ್ಣವುಳ್ಳದ್ದಾಗಿರಬೇಕು. ಅದರೊಳಗೆ ಯಾವ ದೋಷವೂ ಕಳಂಕವೂ ಇರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ಕುರುಡಾದದ್ದು, ಮುರಿದದ್ದು, ಅಂಗಹೀನವಾದದ್ದು, ಬೊಕ್ಕೆಯುಳ್ಳದ್ದು, ಕಜ್ಜಿ ತುರಿಯುಳ್ಳದ್ದು, ಇವುಗಳನ್ನು ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಲೂಬಾರದು ಮತ್ತು ಅವುಗಳನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ದಹನಬಲಿಯಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಲೂಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ಹೋರಿಯಾಗಲಿ ಇಲ್ಲವೆ ಕುರಿಮರಿಯಾಗಲಿ ಅದಕ್ಕೆ ಹೆಚ್ಚಾದ ಅಂಗವಿರುವದಾಗಿದ್ದರೆ ಇಲ್ಲವೆ ಅದರ ಅಂಗಗಳಲ್ಲಿ ಕೊರತೆಯಿರುವುದಾದರೆ, ಅದನ್ನು ಉಚಿತ ಕಾಣಿಕೆಯಾಗಿ ಅರ್ಪಿಸಬಹುದು. ಆದರೆ ಹರಕೆಯಾಗಿ ಅದು ಅಂಗೀಕಾರವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ಜಜ್ಜಿ ಗಾಯವಾದ, ನುಜ್ಜುಗುಜ್ಜಾದ, ಮುರಿದ ಇಲ್ಲವೆ ಕೊಯ್ದಿರುವ ಯಾವುದನ್ನೂ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬಾರದು. ನಿಮ್ಮ ದೇಶದೊಳಗಿರುವ ಅಂಥ ಯಾವ ಬಲಿಯನ್ನಾದರೂ ನೀವು ಸಮರ್ಪಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ಇದಲ್ಲದೆ ಪರಕೀಯನಿಂದ ತೆಗೆದುಕೊಂಡ ಅಂತಹ ಯಾವ ಪಶುವನ್ನೂ ನಿಮ್ಮ ದೇವರಿಗೆ ಆಹಾರವಾಗಿ ಅರ್ಪಿಸಬಾರದು. ಏಕೆಂದರೆ ಅವರ ಕುಂದುಳ್ಳದ್ದು ಮತ್ತು ದೋಷಗಳೂ ಅವುಗಳಲ್ಲಿ ಇರುತ್ತವೆ. ಅವು ನಿಮಗೋಸ್ಕರವಾಗಿ ಅಂಗೀಕಾರವಾಗುವುದಿಲ್ಲ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ಹೋರಿಯನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಕುರಿಯನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಆಡನ್ನಾಗಲಿ ತಂದಾಗ, ಏಳು ದಿವಸಗಳವರೆಗೆ ಅದು ತನ್ನ ತಾಯಿಯ ಬಳಿಯಲ್ಲಿ ಇರಲಿ. ಎಂಟನೆಯ ದಿನದಿಂದ ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಯಾಗಿ ಸಮರ್ಪಿಸಿದರೆ ಅಂಗೀಕಾರವಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ಹಸುವನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಕುರಿಯನ್ನಾಗಲಿ ಅದರ ಮರಿಯೊಂದಿಗೆ ಎರಡನ್ನೂ ಒಂದೇ ದಿನದಲ್ಲಿ ವಧಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“ನೀವು ಕೃತಜ್ಞತೆಯ ಯಜ್ಞಾರ್ಪಣೆಯನ್ನು, ಯೆಹೋವ ದೇವರಿಗೆ ಮಾಡುವ ಬಲಿದಾನವನ್ನು ಮೆಚ್ಚಿಗೆಯಾದ ರೀತಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ಅದೇ ದಿನದಲ್ಲಿ ಅದನ್ನು ತಿಂದುಬಿಡಬೇಕು. ಅದರಲ್ಲಿ ಯಾವುದನ್ನೂ ಮಾರನೆಯ ದಿನದವರೆಗೆ ಉಳಿಸಬಾರದು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“ಆದ್ದರಿಂದ ನೀವು ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಕೈಗೊಂಡು ಅವುಗಳನ್ನು ಮಾಡಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ನನ್ನ ಪರಿಶುದ್ಧವಾದ ಹೆಸರನ್ನು ಅಪರಿಶುದ್ಧಗೊಳಿಸಬಾರದು, ಏಕೆಂದರೆ ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ನಾನು ಪರಿಶುದ್ಧನೆಂದು ಪರಿಗಣಿಸಬೇಕು. ನಿಮ್ಮನ್ನು ನನ್ನ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ನಿಮಗೆ ದೇವರಾಗಿರಲು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ತಂದೆನು. ನಾನೇ ಯೆಹೋವ ದೇವರು.” ");
INSERT INTO kanokcv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ನೀನು ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೀಗೆ ಹೇಳು, ‘ನೀವು ಪರಿಶುದ್ಧ ಸಭೆಗಳಾಗಿ ಸೇರಿ ಯೆಹೋವ ದೇವರಾಗಿರುವ ನನಗೋಸ್ಕರ ನೇಮಕವಾದ ಈ ಹಬ್ಬಗಳನ್ನು ಪ್ರಕಟಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘ಆರು ದಿವಸ ಕೆಲಸ ಮಾಡಬೇಕು. ಆದರೆ ಏಳನೆಯ ದಿನವು ಸಬ್ಬತ್ ದಿನ. ಆ ದಿನವು ಪರಿಶುದ್ಧ ದಿನವಾಗಿರುವುದು. ನೀವು ಆ ದಿನದಲ್ಲಿ ಕೆಲಸಮಾಡಬಾರದು. ನಿಮ್ಮ ಎಲ್ಲಾ ನಿವಾಸಗಳಲ್ಲಿಯೂ ಅದು ಯೆಹೋವ ದೇವರ ಸಬ್ಬತ್ ದಿನವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘ಇವು ಯೆಹೋವ ದೇವರ ಹಬ್ಬಗಳು: ನೀವು ನೇಮಕವಾದ ಕಾಲಗಳಲ್ಲಿ ನಿಮ್ಮ ಪವಿತ್ರ ಸಭಾ ಕೂಟಗಳಲ್ಲಿ ಈ ಹಬ್ಬಗಳನ್ನು ಪ್ರಕಟಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ಸಂಜೆಯಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಪಸ್ಕಹಬ್ಬವಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ಅದೇ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳ ಹಬ್ಬವನ್ನು ಯೆಹೋವ ದೇವರಿಗೋಸ್ಕರ ಆಚರಿಸಬೇಕು. ಅದು ಮೊದಲುಗೊಂಡು ಏಳು ದಿನಗಳವರೆಗೆ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಪರಿಶುದ್ಧ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆ ಸೇರಬೇಕು. ಯಾವ ತರವಾದ ಉದ್ಯೋಗವನ್ನು ನೀವು ಆ ದಿನದಲ್ಲಿ ಮಾಡಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ಆದರೆ ಏಳು ದಿವಸ ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಬಲಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಪರಿಶುದ್ಧ ಸಭಾಕೂಟವಿರುವುದು. ಅದರಲ್ಲಿ ನೀವು ಕಷ್ಟಕರವಾದ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ: ‘ನಾನು ನಿಮಗೆ ಕೊಡುವ ದೇಶದೊಳಕ್ಕೆ ನೀವು ಬಂದಾಗ ಮತ್ತು ಅಲ್ಲಿಯ ಸುಗ್ಗಿಯನ್ನು ಕೊಯ್ದರೆ, ನಿಮ್ಮ ಸುಗ್ಗಿಯ ಪ್ರಥಮ ಫಲಗಳ ಸಿವುಡನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ಅದು ನಿಮಗೋಸ್ಕರ ಅಂಗೀಕಾರವಾಗುವಂತೆ ಅದನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ಸಬ್ಬತ್ ದಿನವಾದ ಮಾರನೆಯ ದಿನ ಯಾಜಕನು ಅದನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ನೀವು ಸಿವುಡನ್ನು ಅರ್ಪಿಸುವ ದಿನದಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಯಾಗಿ ಸಮರ್ಪಿಸುವಂತೆ ಒಂದು ವರ್ಷದ ಮತ್ತು ಕಳಂಕರಹಿತವಾದ ಕುರಿಮರಿಯನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ಇದರೊಂದಿಗೆ, ಧಾನ್ಯ ಸಮರ್ಪಣೆಯಲ್ಲಿ ಬೆರೆಸಿದ ಎಣ್ಣೆ ಮತ್ತು ಮೂರು ಕಿಲೋಗ್ರಾಂ ನಯವಾದ ಹಿಟ್ಟನ್ನು ಆಹ್ಲಾದಕರವಾದ ಪರಿಮಳದ ರೂಪದಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಬೇಕು. ಇದಲ್ಲದೆ ಅದರೊಂದಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಪಾನದ್ರವ್ಯವು ಸುಮಾರು ಒಂದು ಲೀಟರ್ ದ್ರಾಕ್ಷಾರಸ ಆಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ಅದೇ ದಿನದಲ್ಲಿ ನೀವು ನಿಮ್ಮ ದೇವರಿಗೆ ಬಲಿಯನ್ನು ತರುವವರೆಗೆ ರೊಟ್ಟಿಯನ್ನಾಗಲಿ, ಹುರಿದ ಕಾಳನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಹಸಿರಾದ ತೆನೆಗಳನ್ನಾಗಲಿ ತಿನ್ನಬಾರದು. ಇದು ನಿಮಗೆ ನಿಮ್ಮ ಸಂತತಿಯ ಎಲ್ಲಾ ನಿವಾಸಗಳಲ್ಲಿಯೂ ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘ಸಬ್ಬತ್ ದಿನದ ಮಾರನೆಯ ದಿನ ನೀವು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿದ ಸಿವುಡನ್ನು ತಂದ ದಿನದಿಂದ ಏಳು ವಾರಗಳು ಪೂರ್ಣವಾಗುವವರೆಗೆ ಲೆಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ಏಳನೆಯ ಸಬ್ಬತ್ ದಿನದ ಮಾರನೆಯ ದಿನದಿಂದ ನೀವು ಐವತ್ತು ದಿನಗಳನ್ನು ಲೆಕ್ಕಿಸಬೇಕು. ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ಹೊಸ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ಇದಲ್ಲದೆ ನೀವು ನಿಮ್ಮ ಮನೆಗಳಿಂದ ತಂದ ಹಿಟ್ಟಿನಲ್ಲಿ ಎರಡೆರಡು ಓಮರ್ ಹಿಟ್ಟಿನಿಂದ ಎರಡು ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಬೇಕು. ಇವುಗಳನ್ನು ಹುಳಿಹಾಕಿದ ಗೋಧಿಯ ಹಿಟ್ಟಿನಿಂದ ಮಾಡಿ ಪ್ರಥಮಫಲವಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ಇದಲ್ಲದೆ ನೀವು ರೊಟ್ಟಿಯೊಂದಿಗೆ ಕಳಂಕರಹಿತವಾದ ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳನ್ನೂ ಒಂದು ಎಳೆಯ ಹೋರಿಯನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ಅವು ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಗಳಾಗುವುವು. ಅವುಗಳೊಂದಿಗೆ ಆಹಾರ ಬಲಿಯು ಮತ್ತು ಪಾನಾರ್ಪಣೆಗಳು, ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಸುವಾಸನೆಯಾದ ಅರ್ಪಣೆಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ತರುವಾಯ ಹೋತವನ್ನು ಪಾಪ ಪರಿಹಾರದ ಬಲಿಯಾಗಿಯೂ ಮತ್ತು ಸಮಾಧಾನ ಬಲಿಯಾಗಿ ಒಂದು ವರ್ಷದ ಎರಡು ಕುರಿಮರಿಗಳನ್ನು ಬಲಿಯಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ಯಾಜಕನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಪ್ರಥಮ ಫಲದ ರೊಟ್ಟಿಯೊಂದಿಗೂ, ಎರಡು ಕುರಿಮರಿಗಳೊಂದಿಗೂ ಅವುಗಳನ್ನು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕು. ಅವು ಯೆಹೋವ ದೇವರಿಗೆ ಪರಿಶುದ್ಧವಾಗಿದ್ದು ಯಾಜಕನಿಗೋಸ್ಕರ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ಅದೇ ದಿನದಲ್ಲಿ ಪವಿತ್ರ ಸಭೆ ಕೂಡುವುದೆಂದು ಪ್ರಕಟಿಸಬೇಕು ಮತ್ತು ಆ ದಿನದಲ್ಲಿ ನೀವು ಉದ್ಯೋಗವನ್ನೂ ಮಾಡಬಾರದು. ಇದು ನಿಮಗೂ, ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ, ನೀವು ಎಲ್ಲೇ ಇದ್ದರೂ ಪಾಲಿಸಬೇಕಾದ ಶಾಶ್ವತ ನಿಯಮ. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘ನಿಮ್ಮ ಭೂಮಿಯ ಸುಗ್ಗಿಯನ್ನು ನೀವು ಕೊಯ್ಯುವಾಗ, ನಿಮ್ಮ ಹೊಲದ ಮೂಲೆಯನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ಕೊಯ್ಯಬಾರದು, ಇಲ್ಲವೆ ನಿಮ್ಮ ಸುಗ್ಗಿಯಲ್ಲಿ ಯಾವ ಹಕ್ಕಲನ್ನೂ ಕೂಡಿಸಿಕೊಳ್ಳಬಾರದು. ನೀವು ಅವುಗಳನ್ನು ಬಡವರಿಗಾಗಿ ಮತ್ತು ಪರಕೀಯರಿಗಾಗಿ ಬಿಟ್ಟುಬಿಡಬೇಕು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ: ‘ಏಳನೆಯ ತಿಂಗಳಿನಲ್ಲಿ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ನಿಮಗೆ ತುತೂರಿಗಳನ್ನು ಊದುವ ಜ್ಞಾಪಕಾರ್ಥವಾದ ಸಬ್ಬತ್ ದಿನವಾಗಿರಬೇಕು. ಆ ದಿನ ಪರಿಶುದ್ಧ ಸಭೆಯ ಕೂಟವೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ನೀವು ಅದರಲ್ಲಿ ಕಷ್ಟಕರವಾದ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ಆದರೆ ದಹನಬಲಿಯನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಬೇಕು,’ ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ಈ ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿವಸವು ಪ್ರಾಯಶ್ಚಿತ್ತದ ದಿವಸವಾಗಿರುವುದು. ಅದು ನಿಮಗೆ ಒಂದು ಪರಿಶುದ್ಧ ಸಭೆಯ ಕೂಟವಾಗಿರುವುದು. ನೀವು ಉಪವಾಸ ಮಾಡಿ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಸಮರ್ಪಣೆಯನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ಆ ದಿವಸದಲ್ಲಿ ನೀವು ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ಏಕೆಂದರೆ ಅದು ನಿಮಗೋಸ್ಕರ ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತದ ದಿವಸವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ಅದೇ ದಿವಸದಲ್ಲಿ ಯಾರಾದರೂ ಉಪವಾಸ ಮಾಡದೆ ಇದ್ದಲ್ಲಿ, ಅವರು ತಮ್ಮ ಜನರೊಳಗಿಂದ ಸಂಪೂರ್ಣವಾಗಿ ತೆಗೆಯಲಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ಅದೇ ದಿವಸದಲ್ಲಿ ಯಾರಾದರೂ ಕೆಲಸವನ್ನು ಮಾಡಿದರೆ, ಅವರನ್ನು ನಾನು ಅವರ ಜನರ ಮಧ್ಯದಿಂದ ನಾಶಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ನೀವು ಯಾವ ತರಹದ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ಇದು ನಿಮ್ಮ ಸಂತತಿಗೆ ಎಲ್ಲಾ ನಿವಾಸಗಳಲ್ಲಿ ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ಇದು ನಿಮಗೆ ಸಬ್ಬತ್ ದಿನವಾಗಿರುವುದು. ನೀವು ನಿಮ್ಮನ್ನು ಉಪವಾಸ ಇಡಬೇಕು. ಆ ತಿಂಗಳಿನ ಒಂಬತ್ತನೆಯ ದಿವಸದ ಸಾಯಂಕಾಲದಿಂದ ಹಿಡಿದು ಮರುದಿನದ ಸಂಜೆಯವರೆಗೆ ಸಬ್ಬತ್ ದಿನವನ್ನು ಆಚರಿಸಬೇಕು,” ಎಂಬದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೀಗೆ ಹೇಳು: ‘ಈ ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿವಸವು ಏಳು ದಿವಸಗಳವರೆಗೆ ಯೆಹೋವ ದೇವರಿಗೆ ಗುಡಾರಗಳ ಹಬ್ಬವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ಮೊದಲನೆಯ ದಿವಸದಲ್ಲಿ ಪರಿಶುದ್ಧ ಸಭೆಯ ಕೂಟವಿರುವುದು. ನೀವು ಅದರಲ್ಲಿ ಕಷ್ಟಕರವಾದ ಕೆಲಸಗಳನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ಏಳು ದಿವಸ ನೀವು ಬೆಂಕಿಯ ಮೂಲಕ ಬಲಿಗಳನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಬೇಕು. ಎಂಟನೆಯ ದಿವಸವು ನಿಮಗೆ ಪರಿಶುದ್ಧ ಕೂಟವಾಗಿರುವುದು. ನೀವು ಬೆಂಕಿಯ ಮೂಲಕ ಬಲಿಯನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಬೇಕು. ಅದೊಂದು ಗಂಭೀರ ಸಭೆಯಾಗಿರುವುದು. ಅದರಲ್ಲಿ ನೀವು ಕಷ್ಟಕರವಾದ ಕೆಲಸಗಳನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘ನೀವು ಪರಿಶುದ್ಧ ಸಭೆಯಾಗಿ ಯೆಹೋವ ದೇವರ ನೇಮಕವಾದ ಹಬ್ಬಗಳು ಇವೇ. ಇವುಗಳ ಒಂದೊಂದು ದಿವಸದಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಯನ್ನೂ, ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ, ಯಜ್ಞವನ್ನೂ, ಪಾನದ್ರವ್ಯ ಬಲಿಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ಯೆಹೋವ ದೇವರ ವಿಶ್ರಾಂತಿಯ ದಿನಗಳ ಹೊರತಾಗಿಯೂ, ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸುವ ನಿಮ್ಮ ದಾನಗಳ ಹೊರತಾಗಿಯೂ, ನಿಮ್ಮ ಎಲ್ಲಾ ಹರಕೆಗಳ ಹೊರತಾಗಿಯೂ, ನಿಮ್ಮ ಎಲ್ಲಾ ಸ್ವಯಿಚ್ಛೆಯ ಕಾಣಿಕೆಗಳ ಹೊರತಾಗಿಯೂ ಸಲ್ಲಿಸಬೇಕಾದ ಅರ್ಪಣೆಗಳಿರುತ್ತವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ಭೂಮಿಯ ಫಲವನ್ನು ಕೂಡಿಸಿದಾಗ, ಯೆಹೋವ ದೇವರಿಗೆ ಏಳು ದಿವಸಗಳ ಹಬ್ಬವನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ಮೊದಲನೆಯ ದಿನವು ಸಬ್ಬತ್ ದಿನವಾಗಿರಬೇಕು ಮತ್ತು ಎಂಟನೆಯ ದಿನವು ಸಬ್ಬತ್ ದಿನವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ಮೊದಲನೆಯ ದಿವಸದಲ್ಲಿ ನೀವು ಸುಂದರವಾದ ಮರಗಳ ರೆಂಬೆಗಳನ್ನೂ, ಖರ್ಜೂರ ಮರಗಳ ರೆಂಬೆಗಳನ್ನೂ, ದಟ್ಟವಾದ ಮರಗಳ ರೆಂಬೆಗಳನ್ನೂ, ಹಳ್ಳದ ನೀರವಂಜಿ ಮರಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಏಳು ದಿನಗಳವರೆಗೆ ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಸಂತೋಷ ಪಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ವರ್ಷದಲ್ಲಿ ನೀವು ಏಳು ದಿವಸಗಳ ಹಬ್ಬವನ್ನು ಯೆಹೋವ ದೇವರಿಗಾಗಿ ಕೈಗೊಳ್ಳಬೇಕು. ಇದು ನಿಮ್ಮ ಸಂತತಿಗಳಲ್ಲಿ ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿರಬೇಕು. ನೀವು ಇದನ್ನು ಏಳನೆಯ ತಿಂಗಳಿನಲ್ಲಿ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ಏಳು ದಿವಸಗಳವರೆಗೆ ನೀವು ಗುಡಾರಗಳಲ್ಲಿ ವಾಸಿಸಬೇಕು. ಸ್ವದೇಶೀಯರಾದ ಇಸ್ರಾಯೇಲರಾಗಿ ಹುಟ್ಟಿದವರೆಲ್ಲರೂ ಗುಡಾರಗಳಲ್ಲಿ ವಾಸಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ಏಕೆಂದರೆ ನಾನು ಇಸ್ರಾಯೇಲರನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿನಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದಾಗ, ಅವರು ಗುಡಾರಗಳಲ್ಲಿ ವಾಸಿಸುವಂತೆ ಮಾಡಿದೆನೆಂದು ನಿಮ್ಮ ಸಂತತಿಯವರು ತಿಳಿದುಕೊಳ್ಳುವರು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ಹೀಗೆ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ ಯೆಹೋವ ದೇವರ ಹಬ್ಬಗಳನ್ನು ನೇಮಕಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ಬೆಳಕಿಗೋಸ್ಕರ ದೀಪಗಳು ಯಾವಾಗಲೂ ಉರಿಯುತ್ತಿರುವಂತೆ ಅವರು ಕುಟ್ಟಿದ ಶುದ್ಧವಾದ ಓಲಿವ್ ಎಣ್ಣೆಯನ್ನು ನನ್ನ ಬಳಿಗೆ ತರುವಂತೆ ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಮುಂದೆ ಇರುವ ಪರದೆಯ ಹೊರಗೆ, ಆರೋನನು ಸಂಜೆಯಿಂದ ಉದಯದವರೆಗೆ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ದೀಪವನ್ನು ಸರಿಪಡಿಸುತ್ತಾ ಉರಿಸುತ್ತಿರಬೇಕು. ಈ ನಿಯಮವು ನಿಮಗೆ ಮತ್ತು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ದೀಪಗಳು ಚೊಕ್ಕ ಬಂಗಾರದ ದೀಪಸ್ತಂಭದ ಮೇಲೆ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಯಾವಾಗಲೂ ಇರುವಂತೆ ಅವನು ಕ್ರಮಪಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“ನೀನು ನಯವಾದ ಹಿಟ್ಟನ್ನು ತೆಗೆದುಕೊಂಡು ಹನ್ನೆರಡು ರೊಟ್ಟಿಗಳನ್ನು ಸುಡಬೇಕು. ಪ್ರತಿಯೊಂದು ರೊಟ್ಟಿ ಎರಡೆರಡು ಓಮರನಷ್ಟು ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ಅವುಗಳನ್ನು ಚೊಕ್ಕ ಬಂಗಾರದ ಮೇಜಿನ ಮೇಲೆ ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಒಂದು ಸಾಲಿನಲ್ಲಿ ಆರರಂತೆ, ಎರಡು ಸಾಲುಗಳನ್ನಾಗಿ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ರೊಟ್ಟಿಯ ಮೇಲೆ ಅದು ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಇರುವಂತೆಯೂ, ಬೆಂಕಿಯ ಮೂಲಕ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಣೆಯಾಗುವಂತೆಯೂ, ಪ್ರತಿಯೊಂದು ಸಾಲಿನ ಮೇಲೆ ಶುದ್ಧವಾದ ಸಾಂಬ್ರಾಣಿಯನ್ನು ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ಪ್ರತಿಯೊಂದು ಸಬ್ಬತ್ ದಿನದಲ್ಲಿಯೂ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಯಾವಾಗಲೂ ಅವನು ಅದನ್ನು ಕ್ರಮಪಡಿಸಬೇಕು. ಇದು ಇಸ್ರಾಯೇಲರ ಕಡೆಯಿಂದ ನಿತ್ಯವಾದ ಒಡಂಬಡಿಕೆಯಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ಅದು ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರದಾಗಿರಬೇಕು. ಅವರು ಅದನ್ನು ಪರಿಶುದ್ಧವಾದ ಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ಏಕೆಂದರೆ ಅದು ನಿತ್ಯವಾದ ನಿಯಮವಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಯಾಗಿ ಸಮರ್ಪಿಸುವವುಗಳಲ್ಲಿ ಅವನಿಗೆ ಮಹಾಪರಿಶುದ್ಧವಾಗಿರುವುದು.” ");
INSERT INTO kanokcv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ಇಸ್ರಾಯೇಲಿನವಳಾದ ಒಬ್ಬ ಸ್ತ್ರೀಗೂ, ಈಜಿಪ್ಟಿನವನಾದ ಪುರುಷನಿಗೂ ಹುಟ್ಟಿದ ಮಗನು ಇಸ್ರಾಯೇಲರ ಪಾಳ್ಯಕ್ಕೆ ಬಂದನು. ಇಸ್ರಾಯೇಲಿನವಳಾದ ಸ್ತ್ರೀಯ ಈ ಮಗನು ಇಸ್ರಾಯೇಲಿನ ಒಬ್ಬ ಮನುಷ್ಯನೊಂದಿಗೆ ಪಾಳೆಯದಲ್ಲಿ ಜಗಳವಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ಇಸ್ರಾಯೇಲ್ ಸ್ತ್ರೀಯ ಮಗನು ಯೆಹೋವ ದೇವರ ನಾಮವನ್ನು ದೂಷಿಸಿ, ಶಪಿಸಿದನು. ಅವರು ಅವನನ್ನು ಮೋಶೆಯ ಬಳಿಗೆ ತಂದರು. ಅವನ ತಾಯಿಯ ಹೆಸರು ಶೆಲೋಮಿತ್. ಇವಳು ದಾನ್ ಕುಲದ ದಿಬ್ರೀಯನ ಮಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ಯೆಹೋವ ದೇವರ ಮನಸ್ಸನ್ನು ತಿಳಿಯುವಂತೆ ಅವನನ್ನು ಕಾವಲಲ್ಲಿ ಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ಶಪಿಸಿದವನನ್ನು ಪಾಳೆಯದ ಆಚೆಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ, ಅವನಿಂದ ಕೇಳಿದವರೆಲ್ಲರೂ ಅವನ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನಿಡಲಿ, ಸಭೆಯವರೆಲ್ಲರೂ ಅವನಿಗೆ ಕಲ್ಲೆಸೆಯಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ನೀನು ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು, ‘ತನ್ನ ದೇವರನ್ನು ಶಪಿಸುವವನು, ತನ್ನ ಪಾಪವನ್ನು ಹೊತ್ತುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ಯೆಹೋವ ದೇವರ ನಾಮವನ್ನು ದೂಷಣೆ ಮಾಡುವವನಿಗೆ ನಿಶ್ಚಯವಾಗಿ ಮರಣವನ್ನು ವಿಧಿಸಬೇಕು. ಸಭೆಯವರೆಲ್ಲರೂ ನಿಶ್ಚಯವಾಗಿ ಅವನಿಗೆ ಕಲ್ಲೆಸೆಯಬೇಕು. ಇದಲ್ಲದೆ ಸ್ವದೇಶೀಯನಾಗಿರಲಿ, ಪರಕೀಯನಾಗಿರಲಿ ಯೆಹೋವ ದೇವರ ಹೆಸರನ್ನು ದೂಷಣೆ ಮಾಡಿದಾಗ, ಅವನನ್ನು ಮರಣ ಶಿಕ್ಷೆಗೆ ಒಳಪಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘ಯಾರಾದರೂ ಮನುಷ್ಯನನ್ನು ಕೊಂದರೆ, ನಿಶ್ಚಯವಾಗಿ ಮರಣಕ್ಕೆ ಒಳಪಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ಪಶುವನ್ನು ಕೊಲ್ಲುವವರು, ಅದಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ಒಂದು ಪಶುವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ಯಾರಾದರೂ ತಮ್ಮ ನೆರೆಯವನಿಗೆ ಊನವಾಗುವಂತೆ ಮಾಡಿದರೆ, ಅವರು ಮಾಡಿದಂತೆಯೇ ಅವರಿಗೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ಮುರಿತಕ್ಕೆ ಮುರಿತ, ಕಣ್ಣಿಗೆ ಕಣ್ಣು, ಹಲ್ಲಿಗೆ ಹಲ್ಲು, ಅವರು ಒಬ್ಬರಿಗೆ ಊನ ಮಾಡಿದ ಹಾಗೆಯೇ ಅವರಿಗೂ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ಪಶುವನ್ನು ಕೊಲ್ಲುವವರು ಅದಕ್ಕೆ ಬದಲುಕೊಡಬೇಕು. ಮನುಷ್ಯರನ್ನು ಕೊಲ್ಲುವವರನ್ನು ಮರಣಕ್ಕೆ ಒಳಪಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ನಿಮಗೆ ಒಂದೇ ವಿಧವಾದ ನಿಯಮವಿರಬೇಕು. ಸ್ವದೇಶಸ್ಥನಿಗೆ ಇರುವಂತೆಯೇ ಪರಕೀಯನಿಗೂ ಇರಬೇಕು. ಏಕೆಂದರೆ ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ಶಪಿಸಿದವನನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತಂದು, ಅವನನ್ನು ಕಲ್ಲುಗಳಿಂದ ಹೊಡೆಯುವಂತೆ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಮಾತನಾಡಿದನು. ಆಗ ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ಯೆಹೋವ ದೇವರು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ನೀನು ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೀಗೆ ಹೇಳು, ‘ನಾನು ನಿಮಗೆ ಕೊಡುವ ದೇಶದಲ್ಲಿ ನೀವು ಬಂದಾಗ, ದೇಶವು ಯೆಹೋವ ದೇವರಿಗಾಗಿ ಸಬ್ಬತ್ ದಿನವನ್ನು ಕೈಗೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ಆರು ವರ್ಷ ನೀವು ನಿಮ್ಮ ಹೊಲವನ್ನು ಬಿತ್ತಬೇಕು. ಆರು ವರ್ಷ ನೀವು ನಿಮ್ಮ ದ್ರಾಕ್ಷಿತೋಟವನ್ನು ಕತ್ತರಿಸಬೇಕು, ಅವುಗಳಿಂದ ಫಲವನ್ನು ಕೂಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ಆದರೆ ಏಳನೆಯ ವರ್ಷವು ನೆಲಕ್ಕೆ ವಿಶ್ರಾಂತಿಕಾಲವಾಗಿರುವುದು. ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ಸಬ್ಬತ್ ಕಾಲವಾಗಿರುವುದು. ನೀವು ಆ ವರ್ಷದಲ್ಲಿ ನಿಮ್ಮ ಹೊಲವನ್ನು ಬಿತ್ತಬಾರದು. ಇಲ್ಲವೆ ದ್ರಾಕ್ಷಿತೋಟವನ್ನು ಕತ್ತರಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ತನ್ನಷ್ಟಕ್ಕೆ ತಾನೇ ಬೆಳೆದಿರುವ ಪೈರನ್ನು ನೀವು ಕೊಯ್ಯಬಾರದು. ಇಲ್ಲವೆ ಕತ್ತರಿಸದಿರುವ ದ್ರಾಕ್ಷಿಯ ಬಳ್ಳಿಯ ದ್ರಾಕ್ಷಿಹಣ್ಣುಗಳನ್ನು ಕೂಡಿಸಬಾರದು. ಏಕೆಂದರೆ ಅದು ದೇಶಕ್ಕೆ ವಿಶ್ರಾಂತಿಯ ವರ್ಷವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ದೇಶದ ಆ ಸಬ್ಬತ್ ವರ್ಷದಲ್ಲಿ ತಾನಾಗಿಯೇ ಬೆಳೆದದ್ದು ನಿಮ್ಮ ಆಹಾರಕ್ಕಾಗಿ ಇರುವುದು. ಅದು ನಿಮಗೂ, ನಿಮ್ಮ ದಾಸದಾಸಿಯರಿಗೂ, ನಿಮ್ಮ ಕೂಲಿಯವರಿಗೂ, ನಿಮ್ಮೊಂದಿಗೆ ಪ್ರವಾಸಿಯಾಗಿರುವ ಪರಕೀಯರಿಗೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ನಿಮ್ಮ ದೇಶದಲ್ಲಿರುವ ಹುಟ್ಟುವಳಿಯೆಲ್ಲಾ ನಿಮ್ಮ ಪಶು ಮತ್ತು ಕಾಡುಮೃಗಗಳಿಗೆ ಆಹಾರವಾಗಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘ಇದಲ್ಲದೆ ಏಳು ವರ್ಷಕ್ಕೆ ಒಂದರಂತೆ ಏಳು ಸಬ್ಬತ್ ವರ್ಷಗಳನ್ನು ಎಣಿಸಬೇಕು. ಆ ಏಳು ಸಬ್ಬತ್ ವರ್ಷಗಳ ಕಾಲವು ಒಟ್ಟು ನಾಲ್ವತ್ತೊಂಬತ್ತು ವರ್ಷಗಳಾಗಿರುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ಇದಾದ ಮೇಲೆ ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿವಸದಲ್ಲಿ ಐವತ್ತನೆಯ ವಾರ್ಷಿಕೋತ್ಸವಕ್ಕೆ ತುತೂರಿಯನ್ನು ಊದಿಸಬೇಕು. ಪ್ರಾಯಶ್ಚಿತ್ತದ ದಿನದಲ್ಲಿ ನಿಮ್ಮ ದೇಶದ ಎಲ್ಲಾ ಕಡೆಗಳಲ್ಲಿ ತುತೂರಿಯನ್ನು ಊದಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ಐವತ್ತನೆಯ ವರ್ಷವನ್ನು ಪರಿಶುದ್ಧಮಾಡಿ ದೇಶದಲ್ಲಿ ಎಲ್ಲಾ ನಿವಾಸಿಗಳಿಗೆ ಬಿಡುಗಡೆಯನ್ನು ಪ್ರಕಟಿಸಬೇಕು. ಅದು ನಿಮಗೆ ಐವತ್ತನೆಯ ವರ್ಷದ ವಾರ್ಷಿಕೋತ್ಸವವಾಗಿರಬೇಕು. ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ಅವನವನ ಆಸ್ತಿಗೂ, ಅವನವನ ಕುಟುಂಬಕ್ಕೂ, ಹಿಂದಿರುಗಿ ಹೋಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ಐವತ್ತನೆಯ ಆ ವರುಷವು ನಿಮಗೆ ಜೂಬಿಲಿಯಾಗಿರುವುದು. ನೀವು ಬಿತ್ತಲೂಬಾರದು ಮತ್ತು ತನ್ನಷ್ಟಕ್ಕೆ ತಾನೇ ಬೆಳೆಯುವುದನ್ನು ಕೊಯ್ಯಲೂಬಾರದು ಇಲ್ಲವೆ ಕತ್ತರಿಸದಿದ್ದ ದ್ರಾಕ್ಷಿಬಳ್ಳಿಗಳಲ್ಲಿ ದ್ರಾಕ್ಷಿಹಣ್ಣುಗಳನ್ನು ಕೂಡಿಸಲೂಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ಏಕೆಂದರೆ ಅದು ಜೂಬಿಲಿ. ಅದು ನಿಮಗೆ ಪರಿಶುದ್ಧವಾಗಿರುವುದು. ಹೊಲದೊಳಗಿಂದ ಬೆಳೆದ ಹುಟ್ಟುವಳಿಯನ್ನು ನೀವು ತಿನ್ನಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘ಜೂಬಿಲಿಯ ಈ ವರ್ಷದಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನ ಆಸ್ತಿಗೆ ಹಿಂದಿರುಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘ನೆರೆಯವನಿಗೆ ಏನಾದರೂ ಮಾರಾಟ ಮಾಡಿದ್ದರೆ, ಇಲ್ಲವೆ ನೆರೆಯವನಿಂದ ಕೊಂಡುಕೊಂಡಿದ್ದರೆ, ಒಬ್ಬರಿಗೊಬ್ಬರು ಅನ್ಯಾಯಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ಜೂಬಿಲಿಯ ತರುವಾಯ ವರ್ಷಗಳ ಲೆಕ್ಕದ ಪ್ರಕಾರ ನಿನ್ನ ನೆರೆಯವನಿಂದ ಕೊಂಡುಕೊಳ್ಳಬೇಕು. ಫಲದ ವರ್ಷಗಳ ಪ್ರಕಾರ ಅವನು ನಿನಗೆ ಮಾರಾಟಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ವರ್ಷಗಳು ಹೆಚ್ಚಿದಂತೆಯೇ ಫಲದ ಬೆಲೆಯನ್ನೂ ಹೆಚ್ಚಿಸಬೇಕು. ವರ್ಷಗಳು ಕಡಿಮೆಯಿರುವಂತೆಯೇ ಫಲದ ಬೆಲೆಯನ್ನು ಕಡಿಮೆ ಮಾಡಬೇಕು. ಫಲದ ವರ್ಷಗಳ ಸಂಖ್ಯೆಗನುಸಾರವಾಗಿಯೇ ಅವನು ನಿನಗೆ ಮಾರಾಟಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ಆದ್ದರಿಂದ ನೀವು ಒಬ್ಬರಿಗೊಬ್ಬರು ಅನ್ಯಾಯಮಾಡಬಾರದು. ಆದರೆ ದೇವರಿಗೆ ನೀನು ಭಯಪಡಬೇಕು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘ಹೀಗೆ ನೀವು ನನ್ನ ನಿಯಮಗಳನ್ನು ಪಾಲಿಸಬೇಕು, ನನ್ನ ನಿರ್ಣಯಗಳನ್ನು ಕೈಗೊಂಡು ನಡೆಯಬೇಕು. ಆಗ ನೀವು ದೇಶದಲ್ಲಿ ಸುರಕ್ಷಿತವಾಗಿ ವಾಸಿಸುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ಭೂಮಿಯು ತನ್ನ ಫಲವನ್ನು ಕೊಡುವುದು. ನೀವು ತಿಂದು ತೃಪ್ತರಾಗುವಿರಿ, ಅದರಲ್ಲಿ ಸುರಕ್ಷಿತವಾಗಿ ವಾಸಿಸುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ನೀವು, “ನಾವು ಬಿತ್ತುವುದಿಲ್ಲ, ಇಲ್ಲವೆ ನಮ್ಮ ಹುಟ್ಟುವಳಿಯಲ್ಲಿ ಕೂಡಿಸಿಕೊಳ್ಳುವುದಿಲ್ಲ. ಏಳನೆಯ ವರ್ಷದಲ್ಲಿ ನಾವು ಏನು ತಿನ್ನೋಣ,” ಎನ್ನುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ಆಗ ನಾನು, “ಆರನೆಯ ವರ್ಷದಲ್ಲಿ ಮೂರು ವರ್ಷಗಳಿಗೆ ಫಲಫಲಿಸುವಂತೆ ನಿಮ್ಮ ಮೇಲೆ ನನ್ನ ಆಶೀರ್ವಾದವನ್ನು ಕೊಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ನೀವು ಎಂಟನೆಯ ವರ್ಷದಲ್ಲಿ ಬಿತ್ತಿ, ಅದರ ಫಲವನ್ನು ಒಂಬತ್ತನೆಯ ವರ್ಷದವರೆಗೆ ತಿನ್ನುವಿರಿ. ಅದರ ಫಲ ಬರುವವರೆಗೆ ತಿನ್ನುವಿರಿ, ಅದರ ಫಲ ಬರುವವರೆಗೆ ನೀವು ಸಂಗ್ರಹಿಸಿದ ಹಳೆಯದನ್ನೇ ತಿನ್ನುವಿರಿ,” ಎಂದು ಹೇಳುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘ಇದಲ್ಲದೆ ಭೂಮಿಯನ್ನು ಎಂದಿಗೂ ಮಾರಬಾರದು. ಏಕೆಂದರೆ ಭೂಮಿಯು ನನ್ನದು. ನನ್ನೊಂದಿಗೆ ನೀವು ಪರಕೀಯರೂ, ಪ್ರವಾಸಿಗಳೂ ಆಗಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ನಿಮ್ಮ ಸ್ವಾಧೀನದಲ್ಲಿರುವ ನಿಮ್ಮ ಎಲ್ಲಾ ಭೂಮಿಗೆ ಬಿಡುಗಡೆಯನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘ನಿಮ್ಮ ಸಹೋದರನು ಬಡತನದ ನಿಮಿತ್ತವಾಗಿ ತನ್ನ ಸೊತ್ತಿನಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಮಾರಿದರೆ, ಅವನ ಬಂಧುವು ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ಬಿಡಿಸುವ ಬಂಧುವು ಇಲ್ಲದೆ ಹೋದರೆ, ಮಾರಿದವನೇ ಸ್ಥಿತಿವಂತನಾಗಿ ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳುವಂತಾದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ಅವನು ಅದನ್ನು ಮಾರಿದ ವರ್ಷಗಳನ್ನು ಲೆಕ್ಕಿಸಿ, ಅದನ್ನು ಮಾರಿದವನಿಗೆ ಮಿಕ್ಕ ಕ್ರಯವನ್ನು ಪೂರ್ತಿಮಾಡಿ, ತನ್ನ ಸ್ವಂತ ಹೊಲವನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ತಿರುಗಿ ಸಲ್ಲಿಸುವುದಕ್ಕೆ ಅವನಿಗೆ ಆಗದಿದ್ದರೆ, ಅವನು ಮಾರಿದ್ದು ಜೂಬಿಲಿಯ ವರ್ಷದವರೆಗೆ ಕೊಂಡುಕೊಂಡವನ ಕೈಯಲ್ಲಿ ಇರಬೇಕು ಮತ್ತು ಸಂಭ್ರಮದ ವರ್ಷದಲ್ಲಿ ಅದು ಬಿಡುಗಡೆಯಾಗಬೇಕು, ಅವನು ತನ್ನ ಸೊತ್ತನ್ನು ಪಡೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘ಇದಲ್ಲದೆ ಒಬ್ಬನು ಗೋಡೆಯುಳ್ಳ ಪಟ್ಟಣದಲ್ಲಿರುವ ನಿವಾಸದ ಮನೆಯನ್ನು ಮಾರಿದರೆ, ಅದನ್ನು ಮಾರಿದ ಒಂದು ಪೂರ್ಣ ವರ್ಷದೊಳಗಾಗಿ ಅದನ್ನು ಬಿಡುಗಡೆ ಮಾಡಬೇಕು. ಒಂದು ಪೂರ್ಣ ವರ್ಷದೊಳಗಾಗಿ ಅದನ್ನು ಬಿಡಿಸಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ಆದರೆ ವರ್ಷವು ಪೂರ್ಣವಾಗುವುದರೊಳಗಾಗಿ ಅದು ಬಿಡುಗಡೆಯಾಗದಿದ್ದರೆ, ಗೋಡೆಯ ಪಟ್ಟಣದೊಳಗಿರುವ ಆ ಮನೆಯು ಅದನ್ನು ಕೊಂಡುಕೊಂಡವನಿಗೂ ಅವನ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತವಾಗಿ ನಿಲ್ಲುವುದು. ಜೂಬಿಲಿಯ ವರ್ಷದಲ್ಲಿ ಅದು ಬಿಡುಗಡೆಯಾಗಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ಆದರೆ ಸುತ್ತಲೂ ಗೋಡೆಗಳಿಲ್ಲದೆ ಹಳ್ಳಿಗಳಲ್ಲಿರುವ ಮನೆಗಳು ಬಯಲಿನ ಹೊಲಗಳಂತೆ ಎಣಿಸಬೇಕು. ಅವುಗಳನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳುವ ಅಧಿಕಾರವಿರುವದು. ಜೂಬಿಲಿಯ ವರ್ಷದಲ್ಲಿ ಅವು ಬಿಡುಗಡೆ ಆಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘ಲೇವಿಯರ ಪಟ್ಟಣಗಳ ವಿಷಯವಾಗಿಯೂ, ಅವರ ಸ್ವಾಧೀನವಾಗಿರುವ ಪಟ್ಟಣಗಳ ಮನೆಗಳ ವಿಷಯವಾಗಿಯೂ ಲೇವಿಯರು ಯಾವ ಸಮಯದಲ್ಲಿಯಾದರೂ ಬಿಡಿಸಿಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ಲೇವಿಯರಿಂದ ಏನಾದರೂ ಕೊಂಡುಕೊಂಡರೆ, ಕೊಂಡುಕೊಂಡ ಮನೆಯೂ, ಅವನ ಸ್ವಾಸ್ತ್ಯದ ಪಟ್ಟಣವೂ ಜೂಬಿಲಿಯ ವರ್ಷದಲ್ಲಿ ಬಿಡುಗಡೆಯಾಗಬೇಕು. ಏಕೆಂದರೆ ಲೇವಿಯರ ಪಟ್ಟಣಗಳ ಮನೆಗಳು ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ಅವರಿಗೆ ಸ್ವಾಧೀನವಾಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ಆದರೆ ಅವರ ಪಟ್ಟಣಗಳ ಉಪನಗರಗಳ ಹೊಲವನ್ನು ಮಾರಬಾರದು. ಏಕೆಂದರೆ ಅದು ಅವರಿಗೆ ಶಾಶ್ವತವಾದ ಸೊತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘ನಿನ್ನ ಸಹೋದರನು ಬಡವನಾಗಿ ನಿನ್ನ ಬಳಿಯಲ್ಲಿ ಕ್ಷೀಣವಾಗಿ ಬಿದ್ದುಕೊಂಡರೆ, ಅವನು ಪರಕೀಯನಾಗಿದ್ದರೂ, ಪ್ರವಾಸಿಯಾಗಿದ್ದರೂ ಅವನು ನಿನ್ನ ಬಳಿಯಲ್ಲಿ ಬದುಕುವ ಹಾಗೆ ಅವನಿಗೆ ಸಹಾಯಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ನೀನು ಅವನಿಂದ ಬಡ್ಡಿಯನ್ನಾಗಲಿ ಇಲ್ಲವೆ ಲಾಭವನ್ನಾಗಲಿ ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ನಿನ್ನ ಸಹೋದರನು ನಿನ್ನೊಂದಿಗೆ ಬದುಕುವಂತೆ ನಿನ್ನ ದೇವರಿಗೆ ಭಯಪಡು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ನೀನು ಅವನಿಗೆ ಹಣವನ್ನು ಸಾಲವಾಗಿ ಕೊಟ್ಟರೆ ಬಡ್ಡಿಯನ್ನು ಕೇಳಬಾರದು, ನಿನ್ನ ಆಹಾರವನ್ನು ಲಾಭಕ್ಕಾಗಿ ಸಾಲವಾಗಿ ಕೊಡಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ನಿನಗೆ ಕಾನಾನ್ ದೇಶವನ್ನು ಕೊಡುವಂತೆಯೂ, ನಿನಗೆ ದೇವರಾಗಿರುವಂತೆಯೂ ನಿನ್ನನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಕರತಂದ ನಿನ್ನ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘ನಿನ್ನೊಂದಿಗೆ ವಾಸಿಸುವ ನಿನ್ನ ಸಹೋದರನು ಬಡವನಾಗಿದ್ದು ತನ್ನನ್ನೇ ಮಾರಿಕೊಂಡಿದ್ದರೆ, ದಾಸನ ಹಾಗೆ ಸೇವೆಯನ್ನು ಮಾಡುವಂತೆ ಅವನನ್ನು ನೀನು ಬಲಾತ್ಕರಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ಆದರೆ ಕೂಲಿಯಾಳಂತೆಯೂ, ಪ್ರವಾಸಿಯಂತೆಯೂ ಅವನು ನಿನ್ನ ಬಳಿಯಲ್ಲಿ ಇರಲಿ. ಜೂಬಿಲಿ ಸಂವತ್ಸರದವರೆಗೆ ನಿನಗೆ ಸೇವೆಮಾಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ತರುವಾಯ ಅವನು ನಿನ್ನ ಬಳಿಯಿಂದ ತನ್ನ ಮಕ್ಕಳೊಂದಿಗೆ ಹೊರಟು ತನ್ನ ಕುಟುಂಬಕ್ಕೆ ಹಿಂದಿರುಗಬೇಕು. ತನ್ನ ಪಿತೃಗಳ ಸೊತ್ತಿಗೂ ಅವನು ಹಿಂದಿರುಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ಏಕೆಂದರೆ ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ನಾನು ಹೊರಗೆ ಕರತಂದ ಇಸ್ರಾಯೇಲರು ನನ್ನ ಸೇವಕರಾಗಿದ್ದಾರೆ, ದಾಸರನ್ನು ಮಾರುವಂತೆ ಅವರನ್ನು ಮಾರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ನೀನು ಕಠಿಣವಾಗಿ ಅವನ ಮೇಲೆ ಅಧಿಕಾರ ಚಲಾಯಿಸಬಾರದು. ನಿನ್ನ ದೇವರಿಗೆ ಭಯಪಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘ನಿನ್ನ ಸುತ್ತಲೂ ಇರುವ ಇತರ ಜನರು ನಿನಗೆ ದಾಸ ದಾಸಿಯರಾಗಿರುವಂತೆ ಅವರಿಂದ ದಾಸದಾಸಿಯರನ್ನು ನೀನು ಕೊಂಡುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ಇದಲ್ಲದೆ ನಿನ್ನ ಮಧ್ಯದೊಳಗಿರುವ ಪರಕೀಯ ಪ್ರವಾಸಿಗಳ ಮಕ್ಕಳಿಂದ ಮತ್ತು ನಿನ್ನ ಬಳಿಯಲ್ಲಿರುವ ಅವರ ಕುಟುಂಬಗಳಲ್ಲಿ ದೇಶದೊಳಗೆ ಅವರು ಪಡೆದವರಿಂದ ನೀನು ಕೊಂಡುಕೊಳ್ಳಬಹುದು ಮತ್ತು ಅವರು ನಿನ್ನ ಸ್ವತ್ತಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ನಿಮ್ಮ ತರುವಾಯ ಅವರನ್ನು ನಿಮ್ಮ ಮಕ್ಕಳಿಗೆ ಸ್ವತ್ತಾಗುವ ಬಾಧ್ಯತೆಯಾಗಿ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅವರು ಶಾಶ್ವತವಾಗಿ ನಿಮ್ಮ ದಾಸರಾಗಿರುವರು. ಆದರೆ ಇಸ್ರಾಯೇಲರಾದ ನಿಮ್ಮ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬರ ಮೇಲೊಬ್ಬರು ಕಠಿಣವಾದ ದಬ್ಬಾಳಿಕೆಯನ್ನು ನಡೆಸಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘ನಿನ್ನ ಬಳಿಯಲ್ಲಿರುವ ಪರಕೀಯ ಇಲ್ಲವೆ ಪ್ರವಾಸಿಯ ಸಂಪತ್ತು ಹೆಚ್ಚಾಗಲಾಗಿ ನಿನ್ನ ಸಹೋದರನು ಅವನ ಬಳಿಯಲ್ಲಿ ಬಡವನಾಗಿ ನಿನ್ನ ಬಳಿಯಲ್ಲಿರುವ ಪರಕೀಯ ಇಲ್ಲವೆ ಪ್ರವಾಸಿ ಇಲ್ಲವೆ ಪರಕೀಯನ ಸಂತತಿಯಲ್ಲಿ ಹುಟ್ಟಿದವನಿಗೆ ತನ್ನನ್ನು ಮಾರಿಕೊಂಡಿದ್ದರೂ ಅವನಿಗೆ ಬಿಡುಗಡೆಯಾಗಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ಅವನ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನು ಈಡುಕೊಟ್ಟು ಅವನನ್ನು ವಿಮೋಚಿಸಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ಅವನ ಚಿಕ್ಕಪ್ಪನಾಗಲಿ ಇಲ್ಲವೆ ಅವನ ಚಿಕ್ಕಪ್ಪನ ಮಗನಾಗಲಿ ಇಲ್ಲವೆ ಅವನ ಕುಟುಂಬದಲ್ಲಿ ಸಮೀಪವಾಗಿರುವ ಸಂಬಂಧಿಕರಲ್ಲಿ ಯಾರಾಗಲಿ ಅವನನ್ನು ವಿಮೋಚಿಸಬಹುದು. ಇಲ್ಲವೆ ಅವನು ಶಕ್ತನಾಗಿದ್ದರೆ ತನ್ನನ್ನು ತಾನೇ ವಿಮೋಚಿಸಿಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ಅವನು ತನ್ನನ್ನು ಮಾರಿಕೊಂಡ ವರುಷ ಮೊದಲುಗೊಂಡು ಮುಂದಿನ ಜೂಬಿಲಿ ಸಂವತ್ಸರದವರೆಗೆ ಅವನೊಂದಿಗೆ ಲೆಕ್ಕಮಾಡಬೇಕು. ಅವನ ಮಾರಾಟದ ಕ್ರಯವು ವರುಷಗಳ ಲೆಕ್ಕದ ಪ್ರಕಾರ ಕೂಲಿಯಾಳಿನ ಸಮಯಕ್ಕೆ ತಕ್ಕಂತೆ ಅವನೊಂದಿಗೆ ಅದು ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ಜೂಬಿಲಿ ಸಂವತ್ಸರದವರೆಗೆ ಇನ್ನು ಬಹಳ ವರುಷಗಳಿದ್ದರೆ ಅವುಗಳ ಪ್ರಕಾರ ತನ್ನ ವಿಮೋಚನೆಯ ಕ್ರಯವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ಜೂಬಿಲಿ ಸಂವತ್ಸರದವರೆಗೆ ಕೆಲವು ವರುಷಗಳು ಮಾತ್ರ ಉಳಿದಿದ್ದರೆ ಅವನೊಂದಿಗೆ ಎಣಿಸಬೇಕು. ಅವನ ವರ್ಷಗಳ ಮೇರೆಗೆ ತನ್ನ ವಿಮೋಚನೆಯ ಕ್ರಯವನ್ನು ತಿರುಗಿ ಅವನಿಗೆ ಸಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ವರ್ಷದ ಕೂಲಿಯಾಳಿನಂತೆ ಅವನ ಬಳಿಯಲ್ಲಿ ಇರಬೇಕು. ಆದರೆ ಯಜಮಾನನು ಅವನನ್ನು ಕಠಿಣವಾಗಿ ನಡೆಸಿಕೊಳ್ಳುತ್ತಿರುವುದನ್ನು ನೀವು ನೋಡುತ್ತಾ ಸುಮ್ಮನಿರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘ಈ ವರುಷಗಳಲ್ಲಿ ಅವನು ಬಿಡಿಸಿಕೊಳ್ಳದೆ ಹೋದರೆ, ಜೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ಅವನು ಮಕ್ಕಳೊಂದಿಗೆ ಬಿಡುಗಡೆಯಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ಏಕೆಂದರೆ ಇಸ್ರಾಯೇಲರು ನನ್ನ ದಾಸರು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ನಾನು ಹೊರಗೆ ಬರಮಾಡಿದ ಇವರು ನನ್ನ ದಾಸರೇ. ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘ನೀವು ನಿಮಗಾಗಿ ವಿಗ್ರಹಗಳನ್ನಾಗಲಿ, ಕೆತ್ತಿದ ಪ್ರತಿಮೆಯನ್ನಾಗಲಿ ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ, ಇಲ್ಲವೆ ನಿಲ್ಲಿಸುವ ಪ್ರತಿಮೆಯನ್ನು ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ, ಕಲ್ಲಿನ ವಿಗ್ರಹಗಳನ್ನು ನಿಮ್ಮ ದೇಶದಲ್ಲಿಟ್ಟುಕೊಂಡು ಅದಕ್ಕೆ ಅಡ್ಡಬೀಳಬೇಡಿರಿ. ಏಕೆಂದರೆ ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘ನನ್ನ ವಿಶ್ರಾಂತಿಯ ದಿನಗಳನ್ನು ನೀವು ಆಚರಿಸಬೇಕು. ನನ್ನ ಪರಿಶುದ್ಧಸ್ಥಳದ ವಿಷಯದಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವರಾಗಿರಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘ನೀವು ನನ್ನ ನಿಯಮಗಳ ಪ್ರಕಾರ ನಡೆದುಕೊಂಡು, ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಕೈಗೊಂಡು ಅವುಗಳಂತೆ ನಡೆದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ನಿಮಗೆ ಮಳೆಯನ್ನು ತಕ್ಕ ಕಾಲದಲ್ಲಿ ಸುರಿಸುವೆನು. ಆಗ ಭೂಮಿಯು ಅದರ ಬೆಳೆಯನ್ನು ಕೊಡುವುದು. ಭೂಮಿಯ ಮರಗಳು ಅವುಗಳ ಫಲವನ್ನು ಕೊಡುವವು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ಕಣ ತುಳಿಸುವ ಕೆಲಸವು ದ್ರಾಕ್ಷಿ ಬೆಳೆಯುವವರೆಗೂ ದ್ರಾಕ್ಷಿ ಬೆಳೆಯನ್ನು ಕೂಡಿಸುವ ಕೆಲಸವು ಬಿತ್ತನೆಯ ಕಾಲದವರೆಗೂ ನಡೆಯುವವು. ನೀವು ನಿಮ್ಮ ರೊಟ್ಟಿಯನ್ನು ತಿಂದು, ತೃಪ್ತಿಹೊಂದಿ ಸುರಕ್ಷಿತವಾಗಿ ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘ನಾನು ದೇಶದಲ್ಲಿ ಶಾಂತಿಯನ್ನು ಕೊಡುವೆನು, ಯಾರ ಭಯವೂ ಇಲ್ಲದೆ ನೀವು ಮಲಗಿಕೊಳ್ಳುವಿರಿ. ದೇಶದಲ್ಲಿ ದುಷ್ಟಮೃಗಗಳು ಇಲ್ಲದ ಹಾಗೆ ನಾನು ಮಾಡುವೆನು. ಖಡ್ಗ ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಹಾದು ಹೋಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ನೀವು ನಿಮ್ಮ ಶತ್ರುಗಳನ್ನು ಹಿಂದಟ್ಟುವಾಗ, ಅವರು ಖಡ್ಗದಿಂದ ನಿಮ್ಮ ಮುಂದೆ ಬೀಳುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ನಿಮ್ಮಲ್ಲಿಯ ಐದು ಮಂದಿ ನೂರು ಮಂದಿಯನ್ನು ಹಿಂದಟ್ಟುವರು. ನಿಮ್ಮಲ್ಲಿಯ ನೂರು ಮಂದಿ, ಹತ್ತು ಸಾವಿರ ಮಂದಿಯನ್ನು ಅಟ್ಟಿಬಿಡುವರು. ನಿಮ್ಮ ಶತ್ರುಗಳು ಖಡ್ಗದಿಂದ ನಿಮ್ಮ ಮುಂದೆ ಬೀಳುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘ನಾನು ನಿಮ್ಮನ್ನು ಲಕ್ಷಿಸಿ, ನಿಮ್ಮನ್ನು ಅಭಿವೃದ್ಧಿ ಮಾಡಿ, ನಿಮ್ಮನ್ನು ಹೆಚ್ಚಿಸಿ, ನಿಮ್ಮ ಸಂಗಡ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಾಪಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ನೀವು ಹಳೆಯ ಧಾನ್ಯವನ್ನು ತಿಂದು, ಹೊಸದು ಬಂದಾಗ ಹಳೆಯದನ್ನು ಹೊರಗೆ ತರುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ಇದಲ್ಲದೆ ನಾನು ನನ್ನ ಗುಡಾರವನ್ನು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಮಾಡಿಕೊಳ್ಳುವೆನು. ನನ್ನ ಪ್ರಾಣವು ನಿಮ್ಮನ್ನು ತಿರಸ್ಕರಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ನಾನು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ನಡೆದು ನಿಮ್ಮ ದೇವರಾಗಿರುವೆನು. ನೀವು ನನ್ನ ಜನರಾಗಿರುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ಈಜಿಪ್ಟ್ ದೇಶದವರಿಗೆ ನೀವು ದಾಸರಾಗಿರದ ಹಾಗೆ ಅವರ ದೇಶದೊಳಗಿಂದ ನಿಮ್ಮನ್ನು ಹೊರಗೆ ಬರಮಾಡಿ, ನಿಮ್ಮ ನೊಗದ ಕಟ್ಟುಗಳನ್ನು ಮುರಿದು, ನಿಮ್ಮನ್ನು ತಲೆಯೆತ್ತಿ ನಡೆಯುವಂತೆ ಮಾಡಿದ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘ನೀವು ನನ್ನ ಮಾತನ್ನು ಕೇಳದೆ ಎಲ್ಲಾ ಆಜ್ಞೆಗಳ ಪ್ರಕಾರ ನಡೆಯದೆ ಹೋದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ನನ್ನ ನಿಯಮಗಳನ್ನು ನೀವು ತಿರಸ್ಕರಿಸಿದರೆ, ನನ್ನ ನಿರ್ಣಯಗಳಿಗೆ ಅಸಹ್ಯಪಟ್ಟರೆ, ನೀವು ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಮೀರಿ, ನನ್ನ ಎಲ್ಲಾ ಆಜ್ಞೆಗಳ ಪ್ರಕಾರ ಮಾಡದೆ ಹೋದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ನಾನು ಸಹ ಇದನ್ನು ನಿಮಗೆ ಮಾಡುವೆನು: ನಿಮ್ಮ ಮೇಲೆ ಭೀತಿಯನ್ನು ಉಂಟುಮಾಡುವ, ಕಣ್ಣುಗಳನ್ನು ಕ್ಷೀಣಿಸುವಂತೆಯೂ ಹೃದಯವು ಕುಗ್ಗಿ ದುಃಖಕ್ಕೊಳಗಾಗುವಂತೆಯೂ ಮಾಡುವ ಕ್ಷಯರೋಗವನ್ನೂ ಚಳಿಜ್ವರವನ್ನೂ ಬರಮಾಡುವೆನು. ನೀವು ವ್ಯರ್ಥವಾಗಿ ಬೀಜವನ್ನು ಬಿತ್ತುವಿರಿ. ಏಕೆಂದರೆ ನಿಮ್ಮ ಶತ್ರುಗಳು ಅದನ್ನು ತಿಂದುಬಿಡುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ನಾನು ನಿಮಗೆ ವಿಮುಖನಾಗಿರುವೆನು. ಆದ್ದರಿಂದ ನೀವು ನಿಮ್ಮ ವೈರಿಗಳಿಂದ ಸೋತುಹೋಗುವಿರಿ. ನಿಮ್ಮ ವೈರಿಗಳು ನಿಮ್ಮ ಮೇಲೆ ದೊರೆತನ ಮಾಡುವರು. ಓಡಿಸುವವನು ಯಾರೂ ಇಲ್ಲದಿರುವಾಗಲೂ ಓಡಿಹೋಗುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘ಹೀಗೂ ನನ್ನ ಮಾತನ್ನು ಕೇಳದೆ ಹೋದರೆ, ನಾನು ನಿಮ್ಮನ್ನು ನಿಮ್ಮ ಪಾಪಗಳ ನಿಮಿತ್ತ ಏಳರಷ್ಟು ಹೆಚ್ಚಾಗಿ ಶಿಕ್ಷಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ನಿಮ್ಮ ಬಲದ ಗರ್ವವನ್ನು ಮುರಿದುಹಾಕಿ, ನಿಮ್ಮ ಆಕಾಶವನ್ನು ಕಬ್ಬಿಣದ ಹಾಗೆಯೂ ನಿಮ್ಮ ಭೂಮಿಯನ್ನು ಕಂಚಿನಂತೆಯೂ ಮಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ಆಗ ನಿಮ್ಮ ಶಕ್ತಿಯು ವ್ಯರ್ಥವಾಗಿ ಮುಗಿದುಹೋಗುವುದು. ಏಕೆಂದರೆ ನಿಮ್ಮ ಭೂಮಿಯು ತನ್ನ ಬೆಳೆಯನ್ನು ಕೊಡದೆ ಇರುವುದು ಭೂಮಿಯ ಮರಗಳು ತಮ್ಮ ಫಲಗಳನ್ನು ಕೊಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘ನನ್ನ ಮಾತನ್ನು ಕೇಳಲೊಲ್ಲದೆ ನನಗೆ ವಿರೋಧವಾಗಿ ನಡೆದರೆ, ನಾನು ನಿಮ್ಮ ಪಾಪಗಳಿಗೆ ತಕ್ಕಂತೆ ನಿಮ್ಮನ್ನು ಏಳರಷ್ಟು ಹೆಚ್ಚಾಗಿ ಬಾಧಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ಕಾಡುಮೃಗಗಳು ನಿಮ್ಮ ಮೇಲೆ ಬರುವಂತೆ ಮಾಡುವೆನು. ಅವು ನಿಮ್ಮನ್ನು ಮಕ್ಕಳಿಲ್ಲದವರನ್ನಾಗಿ ಮಾಡಿ, ನಿಮ್ಮ ದನಗಳನ್ನು ತಿಂದುಬಿಡುವವು. ನಿಮ್ಮನ್ನು ಸ್ವಲ್ಪ ಮಂದಿಯಾಗಿ ಮಾಡುವುವು. ನಿಮ್ಮ ಮಾರ್ಗಗಳು ಹಾಳಾಗಿ ಹೋಗುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘ನನ್ನಿಂದಾಗುವ ಇವುಗಳಿಂದ ನೀವು ಶಿಕ್ಷಿತರಾಗದೆ ನನಗೆ ವಿರೋಧವಾಗಿ ನಡೆದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ನಾನು ಸಹ ನಿಮಗೆ ವಿರೋಧವಾಗಿ ನಡೆದು, ಇನ್ನೂ ಹೆಚ್ಚಾಗಿ ನಿಮ್ಮ ಪಾಪಗಳ ನಿಮಿತ್ತ, ಏಳರಷ್ಟು ಶಿಕ್ಷಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ಒಡಂಬಡಿಕೆಯನ್ನು ಮುರಿದದ್ದಕ್ಕಾಗಿ, ಮುಯ್ಯಿಗೆ ಮುಯ್ಯಿ ತೀರಿಸುವ ಖಡ್ಗವನ್ನು ನಾನು ನಿಮ್ಮ ಮೇಲೆ ಬರಮಾಡುವೆನು. ನೀವು ನಿಮ್ಮ ಪಟ್ಟಣಗಳಲ್ಲಿ ಸೇರಿದಾಗ, ವ್ಯಾಧಿಯನ್ನು ನಿಮ್ಮೊಳಗೆ ಬರಮಾಡುವೆನು. ನಿಮ್ಮನ್ನು ಶತ್ರುವಿನ ಕೈಗೆ ಒಪ್ಪಿಸಲಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ನಾನು ನಿಮ್ಮ ಅನ್ನಾಧಾರವನ್ನು ಮುರಿದುಹಾಕಿದಾಗ, ಹತ್ತು ಸ್ತ್ರೀಯರು ನಿಮ್ಮ ರೊಟ್ಟಿಯನ್ನು ಒಂದೇ ಒಲೆಯಲ್ಲಿ ಸುಟ್ಟು, ತೂಕದ ಪ್ರಕಾರ ನಿಮಗೆ ರೊಟ್ಟಿಯನ್ನು ಕೊಡುವರು. ನೀವು ಅದನ್ನು ತಿನ್ನುವಿರಿ, ನಿಮಗೆ ತೃಪ್ತಿಯಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘ಇದೆಲ್ಲಾ ಆದರೂ, ನೀವು ನನ್ನ ಮಾತನ್ನು ಕೇಳದೆ ನನಗೆ ವಿರೋಧವಾಗಿ ನಡೆದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ನಾನು ಕೋಪದಿಂದ ನಿಮಗೆ ವಿರೋಧವಾಗಿ ನಡೆದು, ನಿಮ್ಮ ಪಾಪಗಳ ನಿಮಿತ್ತ ನಾನೇ ನಿಮ್ಮನ್ನು ಏಳರಷ್ಟಾಗಿ ಶಿಕ್ಷಿಸುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ನೀವು ನಿಮ್ಮ ಪುತ್ರಪುತ್ರಿಯರ ಮಾಂಸವನ್ನು ತಿನ್ನುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ಇದಲ್ಲದೆ ನಾನು ನಿಮ್ಮ ಉನ್ನತ ಸ್ಥಳಗಳನ್ನು ಹಾಳು ಮಾಡಿ, ನಿಮ್ಮ ಧೂಪವೇದಿಗಳನ್ನು ಕಡಿದುಹಾಕಿ, ನಿಮ್ಮ ಹೆಣಗಳನ್ನು ನಿಮ್ಮ ವಿಗ್ರಹಗಳ ಮೇಲೆ ಹಾಕುವೆನು. ನಿಮ್ಮ ಬಗ್ಗೆ ನಾನು ಅಸಹ್ಯಪಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ನಿಮ್ಮ ಪಟ್ಟಣಗಳನ್ನು ನಾನು ಕೆಡವಿಹಾಕಿ, ನಿಮ್ಮ ಪರಿಶುದ್ಧ ಸ್ಥಳಗಳನ್ನು ಹಾಳು ಮಾಡಿ, ನಿಮ್ಮ ಸುವಾಸನೆಗಳನ್ನು ಮೂಸಿ ನೋಡದೆ ಇರುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ನಾನು ದೇಶವನ್ನು ಹಾಳುಮಾಡುವೆನು. ಅದರಲ್ಲಿ ವಾಸವಾಗುವ ನಿಮ್ಮ ಶತ್ರುಗಳೂ ಅದಕ್ಕೆ ಆಶ್ಚರ್ಯಪಡುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ನಿಮ್ಮನ್ನು ಜನಾಂಗಗಳಲ್ಲಿ ಚದರಿಸಿ, ನಿಮ್ಮ ಹಿಂದೆ ಖಡ್ಗವನ್ನು ಬೀಸುವೆನು. ನಿಮ್ಮ ಭೂಮಿ ಹಾಳಾಗಿರುವುದು, ನಿಮ್ಮ ಪಟ್ಟಣಗಳು ನಾಶವಾಗಿರುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ಆಗ ನಾಡು ಹಾಳಾಗಿರುವ ಎಲ್ಲಾ ದಿನಗಳಲ್ಲಿಯೂ ನೀವು ನಿಮ್ಮ ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿ ಇರುವವರೆಗೂ, ನಾಡು ತನ್ನ ಸಬ್ಬತ್ ಕಾಲವನ್ನು ಅನುಭವಿಸುವುದು. ಆಗ ನೆಲವು ವಿಶ್ರಮಿಸಿಕೊಂಡು ತನ್ನ ವಿಶ್ರಾಂತಿಯ ಕಾಲವನ್ನು ಅನುಭವಿಸುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ನೀವು ನಿಮ್ಮ ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾಗ, ಹಾಳುಬಿದ್ದ ನಿಮ್ಮ ನಾಡು ತಾನು ಹೊಂದದ ವಿಶ್ರಾಂತಿಯನ್ನು ಈಗ ಸುದೀರ್ಘವಾಗಿ ಹೊಂದಿಕೊಳ್ಳುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘ನಿಮ್ಮಲ್ಲಿ ಯಾರು ಉಳಿದು ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿ ಇರುವರೋ, ಅವರ ಹೃದಯದಲ್ಲಿ ಭೀತಿಯನ್ನು ಹುಟ್ಟಿಸುವೆನು. ಬಡಿದಾಡುವ ಎಲೆಯ ಶಬ್ದವು ಅವರನ್ನು ಓಡಿಸುವುದು. ಖಡ್ಗಕ್ಕೆ ಓಡಿ ಹೋದ ಹಾಗೆ ಓಡಿಹೋಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ಓಡಿಸುವವನಿಲ್ಲದೆ ಒಬ್ಬರ ಮೇಲೊಬ್ಬರು ಖಡ್ಗದ ಭಯದಿಂದಾದ ಹಾಗೆ ಬೀಳುವರು. ನಿಮ್ಮ ಶತ್ರುಗಳಿಗೆದುರಾಗಿ ನಿಂತುಕೊಳ್ಳುವುದು ನಿಮ್ಮಿಂದಾಗದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ಜನಾಂಗಗಳೊಳಗೆ ನಾಶವಾಗುವಿರಿ. ನಿಮ್ಮ ಶತ್ರುಗಳ ದೇಶವು ನಿಮ್ಮನ್ನು ತಿಂದುಬಿಡುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ನಿಮ್ಮಲ್ಲಿ ಉಳಿದವರು ತಮ್ಮ ಅಕ್ರಮದಿಂದ ನಿಮ್ಮ ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿ ಕ್ಷೀಣವಾಗುವರು, ತಮ್ಮ ಪಿತೃಗಳ ಅಕ್ರಮಗಳಿಂದ ಅವರ ಸಂಗಡ ಕ್ಷೀಣವಾಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘ಆದರೆ ಅವರು ನನಗೆ ಮಾಡಿದ ತಮ್ಮ ದುಷ್ಕೃತ್ಯದಲ್ಲಿರುವ ತಮ್ಮ ಅಕ್ರಮವನ್ನೂ, ತಮ್ಮ ಪಿತೃಗಳ ಅಕ್ರಮವನ್ನೂ ತಾವು ನನಗೆ ವಿರೋಧವಾಗಿ ನಡೆದುಕೊಂಡದ್ದನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ನಾನು ಸಹ ಅವರಿಗೆ ವಿರೋಧವಾಗಿ ನಡೆದುಕೊಂಡು ಅವರನ್ನು ತಮ್ಮ ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿ ಬರಮಾಡಿದ್ದನ್ನೂ ಅರಿಕೆಮಾಡಿದರೆ, ಆಗಲೇ ತಮ್ಮ ಮೊಂಡತನವನ್ನು ಬಿಟ್ಟು ನನ್ನ ಆಜ್ಞೆಗೆ ತಲೆಬಾಗಿ, ಅವರು ತಮ್ಮ ಅಕ್ರಮದಿಂದ ಉಂಟಾದ ಶಿಕ್ಷೆಗೆ ಒಪ್ಪಿಕೊಳ್ಳುವುದಾದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ನಾನು ಯಾಕೋಬನಿಗೆ, ಇಸಾಕನಿಗೆ ಮತ್ತು ಅಬ್ರಹಾಮನಿಗೆ ಮಾಡಿದ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಂಡು, ದೇಶವನ್ನು ದಯೆಯಿಂದ ನೆನಪಿಸಿಕೊಳ್ಳುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ಅವರು ಬಿಟ್ಟುಹೋದ ಸ್ವದೇಶವು ಯಾರೂ ಇಲ್ಲದೆ ಹಾಳಾದ ವೇಳೆಯಲ್ಲಿ ತನ್ನ ವಿಶ್ರಾಂತಿಯನ್ನು ಅನುಭವಿಸುವುದು. ಆದರೆ ಅವರು ತಮ್ಮ ಪಾಪಗಳಿಗಾಗಿ ಶಿಕ್ಷೆಯನ್ನು ಅನುಭವಿಸುವರು. ಅದು ಏಕೆಂದರೆ, ಅವರು ನನ್ನ ನ್ಯಾಯಗಳನ್ನು ಹೇಸಿ, ತಮ್ಮ ಹೃದಯಗಳಲ್ಲಿ ನನ್ನ ನಿಯಮಗಳನ್ನು ತಾತ್ಸಾರ ಮಾಡಿದ್ದರಿಂದಲೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ಆದರೂ ಅವರು ತಮ್ಮ ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿರುವಾಗ ಅವರನ್ನು ಧಿಕ್ಕರಿಸದೆ, ಅವರನ್ನು ಅಸಹ್ಯಪಡದೆ, ಅವರನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ನಾಶಮಾಡದೆಯೂ, ಅವರ ಸಂಗಡ ಇರುವ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಮುರಿಯದೆಯೂ ಇರುವೆನು. ಏಕೆಂದರೆ ಅವರ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ನಾನು ಅವರ ಪಿತೃಗಳ ಸಂಗಡ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಯನ್ನು ನೆನಪಿಗೆ ತಂದುಕೊಂಡು, ಅವರಿಗೆ ಹಿತವನ್ನೇ ಮಾಡುವೆನು. ನಾನು ಅವರಿಗೆ ದೇವರಾಗಿರಬೇಕೆಂದೇ, ಅವರ ಪಿತೃಗಳನ್ನು ಎಲ್ಲಾ ಜನಾಂಗಗಳ ಮುಂದೆ ಈಜಿಪ್ಟಿನಿಂದ ಬರಮಾಡಿದೆನು. ನಾನೇ ಯೆಹೋವ ದೇವರು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ಯೆಹೋವ ದೇವರು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯ ಮೂಲಕ ತನಗೂ, ಇಸ್ರಾಯೇಲರಿಗೂ ಮಧ್ಯದಲ್ಲಿ ಇಟ್ಟ ನಿಯಮಗಳೂ, ನ್ಯಾಯಗಳೂ, ಆಜ್ಞಾವಿಧಿಗಳೂ ಇವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ಯೆಹೋವ ದೇವರು ಮಾತನಾಡಿ ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ನೀನು ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ಒಬ್ಬನು ಪ್ರತ್ಯೇಕವಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಹರಕೆಮಾಡಿ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡರೆ, ನೀನು ನೇಮಿಸಿದ ಕ್ರಯದ ಪ್ರಕಾರ ಜನರು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ನೀನು ನೇಮಿಸಬೇಕಾದ ಕ್ರಯವು ಯಾವುದೆಂದರೆ, ಇಪ್ಪತ್ತರಿಂದ ಅರವತ್ತು ವಯಸ್ಸುಳ್ಳ ಪುರುಷನಿಗೆ ನೀನು ಪವಿತ್ರ ಸ್ಥಳದ ಶೆಕೆಲ್ ಅನುಸಾರವಾಗಿ ನೇಮಿಸುವ ಕ್ರಯವು ಐವತ್ತು ಶೆಕೆಲ್ ಆಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ಹೆಣ್ಣಾಗಿದ್ದರೆ, ನೀನು ನೇಮಿಸುವ ಕ್ರಯವು ಮೂವತ್ತು ಶೆಕೆಲ್ ಆಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ಐದರಿಂದ ಇಪ್ಪತ್ತು ವಯಸ್ಸುಳ್ಳ ಪುರುಷನ ಕ್ರಯವು ಇಪ್ಪತ್ತು ಶೆಕೆಲ್, ಸ್ತ್ರೀ ಕ್ರಯವು ಹತ್ತು ಶೆಕೆಲ್ ಆಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ಒಂದು ತಿಂಗಳಿಂದ ಐದು ವಯಸ್ಸುಳ್ಳ ಹುಡುಗನ ಕ್ರಯವು ಐದು ಶೆಕೆಲ್, ಹುಡುಗಿಯ ಕ್ರಯವು ಮೂರು ಶೆಕೆಲ್ ಆಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ಅರವತ್ತು ವರುಷವೂ, ಅದಕ್ಕೂ ಹೆಚ್ಚಾದ ಪ್ರಾಯವುಳ್ಳ ಪುರುಷನಾಗಿದ್ದರೆ, ನೀನು ನೇಮಿಸುವ ಕ್ರಯವು ಹದಿನೈದು ಶೆಕೆಲ್, ಸ್ತ್ರೀಗೆ ಹತ್ತು ಶೆಕೆಲ್ ಆಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ಆದರೆ ನೀನು ನೇಮಿಸಿದ ಕ್ರಯವನ್ನು ಕೊಡದಷ್ಟು ಅವನು ಬಡವನಾಗಿದ್ದರೆ, ಅವನನ್ನು ಯಾಜಕನ ಮುಂದೆ ನಿಲ್ಲಿಸಬೇಕು. ಯಾಜಕನು ಅವನಿಗೆ ಕ್ರಯವನ್ನು ನೇಮಿಸಬೇಕು. ಪ್ರಮಾಣ ಮಾಡಿದವನ ಸಂಪತ್ತಿಗೆ ತಕ್ಕಂತೆ ಯಾಜಕನು ಅವನಿಗೆ ಕ್ರಯವನ್ನು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘ಆದರೆ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಪಶುಗಳ ಜಾತಿಯಲ್ಲಿ ಯಾವುದಾಗಿದ್ದರೂ, ಅವುಗಳಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಕೊಡುವಂಥದ್ದು ಪರಿಶುದ್ಧವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ಅದನ್ನು ಒಳ್ಳೆಯದಕ್ಕೆ ಕೆಟ್ಟದ್ದನ್ನಾಗಲಿ, ಕೆಟ್ಟದ್ದಕ್ಕೆ ಒಳ್ಳೆಯದನ್ನಾಗಲಿ ಬದಲು ಮಾಡಬಾರದು, ಮಾರ್ಪಡಿಸಲೂಬಾರದು. ಅವನು ಗೊತ್ತುಮಾಡಿದ ಒಂದು ಪಶುವಿಗೆ ಮತ್ತೊಂದನ್ನು ಬದಲು ಮಾಡಿದರೆ, ಅದು ಮತ್ತು ಅದರ ಬದಲಾಗಿಟ್ಟ ಪಶು ಇವೆರಡೂ ಯೆಹೋವ ದೇವರಿಗೆ ಪರಿಶುದ್ಧವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಪಶುವು ಅಶುದ್ಧವಾಗಿದ್ದರೆ, ಆ ಪಶುವನ್ನು ಅವನು ಯಾಜಕನ ಮುಂದೆ ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ಆಗ ಯಾಜಕನು ಅದು ಒಳ್ಳೆಯದೋ, ಕೆಟ್ಟದ್ದೋ ಎಂದು ಅದಕ್ಕೆ ಕ್ರಯ ಕಟ್ಟಬೇಕು. ಯಾಜಕನು ನಿರ್ಧರಿಸಿದ ಕ್ರಯವೇ ಅಂತಿಮ ಕ್ರಯವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ಹರಕೆ ಮಾಡುವವನು ಅದನ್ನು ಹೇಗಾದರೂ ವಿಮೋಚಿಸಬೇಕೆಂದಿದ್ದರೆ, ನೀನು ನಿರ್ಧರಿಸಿದ ಕ್ರಯಕ್ಕಿಂತ ಹೆಚ್ಚಾಗಿ ಐದನೇ ಪಾಲನ್ನು ಅದಕ್ಕೆ ಕೂಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘ಒಬ್ಬನು ತನ್ನ ಮನೆಯನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಪರಿಶುದ್ಧವಾಗಿರಲೆಂದು ಪ್ರತಿಷ್ಠೆಪಡಿಸಿದರೆ, ಯಾಜಕನು ಅದು ಒಳ್ಳೆಯದೋ, ಕೆಟ್ಟದ್ದೋ ಎಂದು ಪರೀಕ್ಷಿಸಿ ಕ್ರಯವನ್ನು ಕಟ್ಟಬೇಕು. ಯಾಜಕನು ನಿರ್ಧರಿಸಿದ ಬೆಲೆಯೇ ಸ್ಥಿರವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ಆದರೆ ಪ್ರತಿಷ್ಠೆ ಪಡಿಸಿದವನು ತನ್ನ ಮನೆಯನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬೇಕೆಂದಿದ್ದರೆ, ಅವನು ಕಟ್ಟಿದ ಕ್ರಯಕ್ಕಿಂತ ಹೆಚ್ಚಾಗಿ ಐದನೇ ಒಂದು ಭಾಗ ಹಣವನ್ನು ಕೊಡಲಿ, ಆಗ ಅದು ಅವನದಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘ಒಬ್ಬನು ತನ್ನ ಸ್ವಾಸ್ತ್ಯದ ಹೊಲದಲ್ಲಿ ಏನಾದರೂ ಯೆಹೋವ ದೇವರಿಗೆ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ಅದರ ಬೀಜದ ಪ್ರಕಾರ ಕ್ರಯ ಕಟ್ಟಬೇಕು. ಒಂದು ಓಮೆರ್ ಜವೆಗೋಧಿಯನ್ನು, ಬೀಜಕ್ಕೆ ಐವತ್ತು ಬೆಳ್ಳಿ ಶೆಕೆಲ್‌ಗಳನ್ನು ಕೊಡಬೇಕಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ಜೂಬಿಲಿ ಸಂವತ್ಸರ ಮೊದಲುಗೊಂಡು ಅವನು ತನ್ನ ಹೊಲವನ್ನು ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ನೀನು ಕಟ್ಟುವ ಕ್ರಯದ ಪ್ರಕಾರ ಅದು ಸ್ಥಿರವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ಆದರೆ ಜೂಬಿಲಿ ಸಂವತ್ಸರವಾದ ಮೇಲೆ ತನ್ನ ಹೊಲವನ್ನು ಪ್ರತಿಷ್ಠೆ ಮಾಡಿದರೆ, ಜೂಬಿಲಿ ಸಂವತ್ಸರದವರೆಗೆ ಮಿಕ್ಕ ವರ್ಷಗಳ ಲೆಕ್ಕದ ಪ್ರಕಾರ ಯಾಜಕನು ಅವನಿಗೆ ಹಣವನ್ನು ನಿರ್ಧರಿಸಿ, ಕಟ್ಟಿದ ಕ್ರಯದಿಂದ ಕಳೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ಇದಲ್ಲದೆ ಆ ಹೊಲವನ್ನು ಪರಿಶುದ್ಧ ಮಾಡಿದವನು ಅದನ್ನು ಅವನು ವಿಮೋಚಿಸಬೇಕೆಂದಿದ್ದರೆ, ಅವನು ಕಟ್ಟಿದ ಕ್ರಯಕ್ಕಿಂತ ಹೆಚ್ಚಾಗಿ ಐದನೆಯ ಒಂದು ಪಾಲನ್ನು ಕೊಡಬೇಕು. ಆಗ ಅದು ಸ್ಥಿರವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ಆದರೆ ಅವನು ಹೊಲವನ್ನು ವಿಮೋಚಿಸದೆ ಹೋದರೆ, ಇಲ್ಲವೆ ಮತ್ತೊಬ್ಬನಿಗೆ ಆ ಹೊಲವನ್ನು ಮಾರಿದ್ದರೆ, ಅದನ್ನು ಅನಂತರ ವಿಮೋಚಿಸಕೂಡದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ಜೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ಆ ಹೊಲವು ಬಿಡುಗಡೆಯಾಗುವಾಗ ಆ ಹೊಲವು ಯೆಹೋವ ದೇವರಿಗೆ ಪವಿತ್ರವಾದ ಹೊಲದಂತೆ ಆತನ ಸೊತ್ತಾಗಿಯೇ ಇರಬೇಕು, ಅದು ಯಾಜಕನಿಗೆ ಸಲ್ಲಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘ಆದರೆ ತನ್ನ ಹೊಲಗಳಲ್ಲಿ ಅಂದರೆ ಪಿತ್ರಾರ್ಜಿತ ಭೂಮಿಗೆ ಸೇರದಂಥ ಹೊಲವನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಹರಕೆಮಾಡಿ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ಯಾಜಕನು ಅವನಿಗೆ ನೇಮಿಸಿದ ಕ್ರಯದ ಹಣವನ್ನು ಜೂಬಿಲಿ ಸಂವತ್ಸರದವರೆಗೂ ಎಣಿಸಬೇಕು. ಅವನು ಆ ದಿವಸದಲ್ಲಿ ಕಟ್ಟಿದ ಕ್ರಯವನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಮೀಸಲಾದದ್ದು ಎಂದು ಭಾವಿಸಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ಆ ಹೊಲವು ಯಾರಿಗೆ ಸ್ವಂತವಾಗಿದ್ದು, ಯಾರಿಂದ ಕೊಂಡುಕೊಳ್ಳಲಾಗಿದೆಯೋ ಅದು ಜೂಬಿಲಿ ವರ್ಷದಲ್ಲಿ ಅವರಿಗೇ ಹಿಂದಕ್ಕೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ಪವಿತ್ರ ಸ್ಥಳದ ಶೆಕೆಲ್ ಅನುಸಾರವಾಗಿ ನೇಮಿಸುವ ಕ್ರಯವು ಇಪ್ಪತ್ತು ಗೇರಾ ತೂಕದ ಶೆಕೆಲ್ ಮೇರೆಗೆ ನೀವು ಕ್ರಯವನ್ನು ನಿಗದಿಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘ಪಶುಗಳ ಚೊಚ್ಚಲ ಮರಿ ಯೆಹೋವ ದೇವರದಾದ್ದರಿಂದ ಅದನ್ನೂ ಹರಕೆಯಾಗಿ ಕೊಡಬಾರದು. ಅದು ಎತ್ತಾಗಲಿ ಇಲ್ಲವೆ ಕುರಿಯಾಗಲಿ, ಅದು ಯೆಹೋವ ದೇವರದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ಆದರೆ ಅದು ಅಶುದ್ಧ ಪಶುಗಳಲ್ಲಿ ಹುಟ್ಟಿದ್ದಾಗಿದ್ದರೆ, ಹರಕೆ ಮಾಡಿದವನು ನಿರ್ಣಯವಾದ ಬೆಲೆಯೊಂದಿಗೆ ಐದನೆಯ ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಟ್ಟು ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬಹುದು. ಅವನು ಬಿಡಿಸದೆಹೋದರೆ ಅದನ್ನು ಕಟ್ಟಿದ ಕ್ರಯದ ಪ್ರಕಾರ ಮಾರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘ಯಾರಾದರೂ ಮನುಷ್ಯನನ್ನಾಗಲಿ, ಪಶುವನ್ನಾಗಲಿ, ಪಿತ್ರಾರ್ಜಿತ ಹೊಲವನ್ನಾಗಲಿ ತನಗಿದ್ದ ಬೇರೆ ಯಾವುದನ್ನಾಗಲಿ ಒಬ್ಬ ಮನುಷ್ಯನು ಯೆಹೋವ ದೇವರಿಗಾಗಿ ಮೀಸಲಾಗಿಟ್ಟಿದ್ದರೆ, ಅದನ್ನು ಮಾರಬಾರದು ಇಲ್ಲವೆ ವಿಮೋಚಿಸಬಾರದು. ಮೀಸಲಾಗಿರುವ ಪ್ರತಿಯೊಂದೂ ಯೆಹೋವ ದೇವರಿಗೆ ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘ಯೆಹೋವ ದೇವರಿಗೆಂದು ಮೀಸಲಾದದನ್ನು ಯಾರೂ ಕ್ರಯಕೊಟ್ಟು ವಿಮೋಚಿಸಬಾರದು. ಅಂಥವನಿಗೆ ಮರಣವೇ ಆಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘ಭೂಮಿಯ ಬೀಜದಲ್ಲಾಗಲಿ, ಮರದ ಫಲದಲ್ಲಾಗಲಿ ಹತ್ತನೆಯ ಒಂದು ಪಾಲೆಲ್ಲಾ ಯೆಹೋವ ದೇವರದೇ. ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ಯಾವನಾದರೂ ತನ್ನ ಹತ್ತನೆಯ ಪಾಲುಗಳನ್ನು ವಿಮೋಚಿಸಬೇಕೆಂದಿದ್ದರೆ, ಅದಕ್ಕಿಂತ ಹೆಚ್ಚಾಗಿ ಅದರ ಐದನೆಯ ಒಂದು ಪಾಲನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ಇದಲ್ಲದೆ ದನಕುರಿಗಳಲ್ಲಿಯೂ, ಕುರುಬನು ಎಣಿಸುವ ಪಶುಗಳಲ್ಲಿಯೂ ಹತ್ತನೆಯ ಪಾಲು, ಹತ್ತರಲ್ಲಿ ಒಂದು ಯೆಹೋವ ದೇವರಿಗೆ ಪರಿಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ಆ ಪಶು ಒಳ್ಳೆಯದೋ ಕೆಟ್ಟದ್ದೋ ಎಂದು ಅವನು ವಿಚಾರಿಸಬಾರದು. ಅವನು ಅದನ್ನು ಬದಲಾಯಿಸಬಾರದು. ಯಾರಾದರೂ ಅದನ್ನು ಬದಲಾಯಿಸಿದ್ದಾದರೆ, ಆಗ ಎರಡೂ ಪಶುಗಳು ಯೆಹೋವ ದೇವರಿಗೆ ಸೇರುತ್ತದೆ, ಅದು ಪರಿಶುದ್ಧವಾಗಿರುತ್ತದೆ ಅದನ್ನು ವಿಮೋಚಿಸಬಾರದು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ಯೆಹೋವ ದೇವರು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಗೆ ಇಸ್ರಾಯೇಲರಿಗಾಗಿ ಕೊಟ್ಟ ಆಜ್ಞೆಗಳು ಇವೇ.");
INSERT INTO kanokcv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ಇಸ್ರಾಯೇಲರು ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಹೊರಟ ನಂತರದ ಎರಡನೆಯ ವರ್ಷದ ಎರಡನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿವಸದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಮೋಶೆಯ ಸಂಗಡ ಹೀಗೆ ಮಾತನಾಡಿದರು: ");
INSERT INTO kanokcv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ಇಸ್ರಾಯೇಲ್ ಜನಸಮೂಹದ ಗಂಡಸರನ್ನು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳಿಗೆ ಅನುಗುಣವಾಗಿ ಹೆಸರು ಹಿಡಿದು ಒಬ್ಬೊಬ್ಬರನ್ನಾಗಿ ಎಣಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಸೈನಿಕ ಸೇವೆ ಸಲ್ಲಿಸತಕ್ಕವರನ್ನು ಅಂದರೆ, ಇಪ್ಪತ್ತು ವರ್ಷಕ್ಕಿಂತಲೂ ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳ ಎಲ್ಲರನ್ನು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ನೀನು ಮತ್ತು ಆರೋನನು ಪಟ್ಟಿಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ಪ್ರತಿಯೊಂದು ಗೋತ್ರದ ಒಬ್ಬೊಬ್ಬ ಮುಖ್ಯಸ್ಥನು ನಿಮಗೆ ಸಹಾಯಕನಾಗಿರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“ನಿಮಗೆ ಸಹಾಯ ಮಾಡಬೇಕಾದ ಪುರುಷರ ಹೆಸರುಗಳು: “ರೂಬೇನ್ ಗೋತ್ರದಿಂದ ಶೆದೇಯೂರನ ಮಗ ಎಲೀಚೂರ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ಸಿಮೆಯೋನ್ ಗೋತ್ರದಿಂದ ಚುರೀಷದ್ದೈಯನ ಮಗ ಶೆಲುಮೀಯೇಲ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ಯೆಹೂದ ಗೋತ್ರದಿಂದ ಅಮ್ಮೀನಾದಾಬನ ಮಗ ನಹಶೋನ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ಇಸ್ಸಾಕರ್ ಗೋತ್ರದಿಂದ ಚೂವಾರನ ಮಗ ನೆತನೆಯೇಲ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ಜೆಬುಲೂನ್ ಗೋತ್ರದಿಂದ ಹೇಲೋನನ ಮಗ ಎಲೀಯಾಬ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ಯೋಸೇಫನ ಗೋತ್ರದಲ್ಲಿ, ಎಫ್ರಾಯೀಮ್‌ನಿಂದ ಅಮ್ಮೀಹೂದನ ಮಗ ಎಲೀಷಾಮಾ, ಮನಸ್ಸೆ ಗೋತ್ರದಿಂದ ಪೆದಾಚೂರನ ಮಗನಾದ ಗಮಲಿಯೇಲ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ಬೆನ್ಯಾಮೀನ್ ಗೋತ್ರದಿಂದ ಗಿದ್ಯೋನಿನ ಮಗನಾದ ಅಬೀದಾನ, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ದಾನ್ ಗೋತ್ರದಿಂದ ಅಮ್ಮೀಷದ್ದೈಯನ ಮಗ ಅಹೀಗೆಜೆರ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ಆಶೇರ್ ಗೋತ್ರದಿಂದ ಒಕ್ರಾನನ ಮಗ ಪಗೀಯೇಲ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ಗಾದ್ ಗೋತ್ರದಿಂದ ದೆವುಯೇಲನ ಮಗ ಎಲ್ಯಾಸಾಫ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ನಫ್ತಾಲಿ ಗೋತ್ರದಿಂದ ಏನಾನನ ಮಗ ಅಹೀರನು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ಇವರು ಸರ್ವಸಮೂಹದೊಳಗಿಂದ ಆಯ್ದುಕೊಂಡು ನೇಮಕವಾದವರು. ಇವರು ತಮ್ಮ ಪುರಾತನ ಗೋತ್ರಗಳ ನಾಯಕರು. ಇವರು ಇಸ್ರಾಯೇಲಿನ ಗೋತ್ರಗಳ ಪ್ರಮುಖರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ಹೆಸರಿನಿಂದ ಸೂಚಿತರಾದ ಈ ಪುರುಷರನ್ನು ಮೋಶೆ ಮತ್ತು ಆರೋನನು ತಮ್ಮ ಜೊತೆ ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ಎರಡನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿವಸದಲ್ಲಿ ಸಮಸ್ತ ಪುರುಷರನ್ನೂ ಸಮೂಹದವರೆಲ್ಲರನ್ನೂ ಕೂಡಿಸಿದರು. ಜನರು ತಮ್ಮ ಗೋತ್ರ ಮತ್ತು ಕುಟುಂಬಗಳ ಅನುಸಾರವಾಗಿ ತಮ್ಮ ವಂಶಾವಳಿಯನ್ನು ನೊಂದಾಯಿಸಿದರು. ಹಾಗೂ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಹೆಚ್ಚಾದ ವಯಸ್ಸಿನವರ ಹೆಸರುಗಳನ್ನು ಒಬ್ಬೊಬ್ಬರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆಯೇ, ಮೋಶೆ ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಜನಗಣತಿ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ಇಸ್ರಾಯೇಲಿನ ಚೊಚ್ಚಲ ಮಗ ರೂಬೇನನ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ರೂಬೇನನ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 46,500 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ಸಿಮೆಯೋನನ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ಸಿಮೆಯೋನನ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 59,300 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ಗಾದನ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ಗಾದನ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 45,650 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ಯೆಹೂದ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ಯೆಹೂದ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 74,600 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ಇಸ್ಸಾಕಾರನ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ಇಸ್ಸಾಕಾರನ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 54,400 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ಜೆಬುಲೂನನ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ಜೆಬುಲೂನ್ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 57,400 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ಯೋಸೇಫನ ಮಕ್ಕಳಾದ ಎಫ್ರಾಯೀಮನ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ಎಫ್ರಾಯೀಮನ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 40,500 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","ಮನಸ್ಸೆಯ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ಮನಸ್ಸೆಯ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 32,200 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ಬೆನ್ಯಾಮೀನ್ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ಬೆನ್ಯಾಮೀನನ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 35,400 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ದಾನನ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ದಾನನ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 62,700 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ಆಶೇರನ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ಆಶೇರನ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 41,500 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ನಫ್ತಾಲಿಯ ಸಂತತಿಯವರಲ್ಲಿ: ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದ ಪುರುಷರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಅಥವಾ ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸಿನವರು ಗೋತ್ರ ಹಾಗೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಪಟ್ಟಿಮಾಡಲಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ನಫ್ತಾಲಿಯ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 53,400 ಜನರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ಮೋಶೆ, ಆರೋನ್ ಮತ್ತು ಇಸ್ರಾಯೇಲಿನ ಹನ್ನೆರಡು ಗೋತ್ರಗಳ ನಾಯಕರು ಲೆಕ್ಕಮಾಡಿದ ಇಸ್ರಾಯೇಲರ ಜನರು ಇವರೇ. ಪ್ರತಿಯೊಬ್ಬರೂ ತಮ್ಮ ತಮ್ಮ ಕುಟುಂಬವನ್ನು ಪ್ರತಿನಿಧಿಸುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ಹೀಗೆ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಎಣಿಕೆಯಾದವರೆಲ್ಲರೂ ಅವರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಇಪ್ಪತ್ತು ವರ್ಷದವರೂ, ಅದಕ್ಕಿಂತ ಹೆಚ್ಚಾದ ಪ್ರಾಯವುಳ್ಳವರೂ, ಇಸ್ರಾಯೇಲಿನಲ್ಲಿ ಯುದ್ಧಕ್ಕೆ ಶಕ್ತರಾದವರೂ ಆಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ಎಣಿಕೆಯಾದವರು ಒಟ್ಟು 6,03,550 ಮಂದಿಯಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ಲೇವಿಯರ ತಂದೆಗಳ ಗೋತ್ರವನ್ನು ಇತರರೊಂದಿಗೆ ಎಣಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ನೀವು ಲೇವಿಯ ಕುಲವನ್ನು ಎಣಿಸಬಾರದು ಅಥವಾ ಇತರ ಇಸ್ರಾಯೇಲರ ಜನಗಣತಿಯಲ್ಲಿ ಅವರನ್ನು ಸೇರಿಸಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ಆದರೆ ನೀನು ಸಾಕ್ಷಿಯ ಗುಡಾರವನ್ನೂ ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ಅದಕ್ಕೆ ಬೇಕಾದ ಎಲ್ಲವನ್ನೂ ನೋಡಿಕೊಳ್ಳಲು ಲೇವಿಯರನ್ನು ನೇಮಿಸು. ಅವರು ಗುಡಾರವನ್ನೂ ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ಹೊತ್ತುಕೊಳ್ಳುವರು. ಅದರ ಸೇವೆಮಾಡಿ, ಗುಡಾರದ ಸುತ್ತುಮುತ್ತಲೂ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ದೇವದರ್ಶನ ಗುಡಾರವು ಹೊರಡುವಾಗ ಲೇವಿಯರು ಅದನ್ನು ತೆಗೆಯಲಿ. ಗುಡಾರವು ಇಳಿಯುವಾಗ ಲೇವಿಯರು ಅದನ್ನು ನಿಲ್ಲಿಸಲಿ. ಬೇರೆ ಯಾವನಾದರೂ ಸಮೀಪಿಸಿದರೆ ಅವನು ಸಾಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ತಮ್ಮ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬನು ತನ್ನ ದಂಡಿನ ಧ್ವಜದ ಬಳಿ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ಆದರೆ ಲೇವಿಯರು ಸಾಕ್ಷಿಯ ಗುಡಾರದ ಸುತ್ತಲೂ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ಹೀಗೆ ಇಸ್ರಾಯೇಲರ ಸಭೆಯ ಮೇಲೆ ನನ್ನ ಕೋಪಕ್ಕೆ ಆಸ್ಪದವಿರದು. ಲೇವಿಯರು ಸಭೆಯ ಗುಡಾರ ಕಾಯುವ ಜವಾಬ್ದಾರಿಕೆಯುಳ್ಳವರಾಗಿರಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಎಲ್ಲವನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ಯೆಹೋವ ದೇವರು ಮಾತನಾಡಿ ಮೋಶೆ ಮತ್ತು ಆರೋನನಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ಇಸ್ರಾಯೇಲರು ಒಬ್ಬೊಬ್ಬರಾಗಿ ಕುಟುಂಬಗಳ ಗುರುತುಗಳ ಪ್ರಕಾರ ತಮ್ಮ ತಮ್ಮ ದಂಡಿನ ಧ್ವಜಗಳ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ಅವರು ದೇವದರ್ಶನ ಗುಡಾರದ ಎದುರಿನಲ್ಲಿ ಸುತ್ತುಮುತ್ತಲೂ ಇಳಿದುಕೊಳ್ಳಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ದೇವದರ್ಶನ ಗುಡಾರದ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ, ಸೂರ್ಯೋದಯದ ಕಡೆಗೆ ಯೆಹೂದ ದಂಡಿನ ಧ್ವಜದ ಬಳಿಯಲ್ಲಿ ತಮ್ಮ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ಯೆಹೂದ ಮಕ್ಕಳಿಗೆ ಅಮ್ಮೀನಾದಾಬನ ಮಗ ನಹಶೋನನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 74,600 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ಅವರ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವವರು ಇಸ್ಸಾಕಾರನ ಗೋತ್ರದವರು. ಇಸ್ಸಾಕಾರನ ಮಕ್ಕಳಿಗೆ ಚೂವಾರನ ಮಗ ನೆತನೆಯೇಲ್ ಎಂಬ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 54,400 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ಅವನ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವವರು ಜೆಬುಲೂನ್ಯನ ಗೋತ್ರದವರು. ಜೆಬುಲೂನ್ಯನ ಮಕ್ಕಳಿಗೆ ಹೇಲೋನನ ಮಗ ಎಲೀಯಾಬನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 57,400 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ಯೆಹೂದನ ಪಾಳೆಯದಲ್ಲಿ ಎಣಿಸಲಾದ ಅವರ ಸೈನಿಕರ ಸಂಖ್ಯೆ 1,86,400 ಮಂದಿ. ಅವರು ಮೊದಲು ಹೊರಡತಕ್ಕವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ದಕ್ಷಿಣ ದಿಕ್ಕಿನಲ್ಲಿ: ರೂಬೇನ್ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದವರು ಅವರವರ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ರೂಬೇನನ ಮಕ್ಕಳಿಗೆ ಶೆದೇಯೂರನ ಮಗ ಎಲೀಚೂರನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 46,500 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ಅವರ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವವರು ಸಿಮೆಯೋನನ ಗೋತ್ರದವರು. ಸಿಮೆಯೋನನ ಮಕ್ಕಳಿಗೆ ಚುರೀಷದ್ದೈಯನ ಮಗನಾದ ಶೆಲುಮೀಯೇಲನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 59,300 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ತರುವಾಯ ಗಾದ್ ಗೋತ್ರದವರು. ಗಾದನ ಮಕ್ಕಳಿಗೆ ದೆವುಯೇಲನ ಮಗ ಎಲ್ಯಾಸಾಫನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 45,650 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ರೂಬೇನನ ಪಾಳೆಯದಲ್ಲಿ ಎಣಿಸಲಾದ ಸೈನಿಕರ ಸಂಖ್ಯೆ 1,51,450 ಮಂದಿ. ಇವರು ಎರಡನೆಯ ದಂಡಾಗಿ ಹೊರಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ತರುವಾಯ ದೇವದರ್ಶನ ಗುಡಾರವೂ ಲೇವಿಯರ ಪಾಳೆಯವೂ ಪಾಳೆಯಗಳ ಮಧ್ಯದಲ್ಲಿ ಹೊರಡಬೇಕು. ಅವರು ಇಳಿದುಕೊಳ್ಳುವ ಪ್ರಕಾರವೇ, ತಮ್ಮ ತಮ್ಮ ಕಡೆಯಲ್ಲಿಯೂ ತಮ್ಮ ತಮ್ಮ ಧ್ವಜಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ಹೊರಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ಎಫ್ರಾಯೀಮಿನವರ ಪಾಳೆಯದ ಧ್ವಜವು ಅವರ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಪಶ್ಚಿಮದಲ್ಲಿರುವುದು: ಎಫ್ರಾಯೀಮನ ಮಕ್ಕಳಿಗೆ ಅಮ್ಮೀಹೂದನ ಮಗ ಎಲೀಷಾಮಾನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 40,500 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ಅವರ ಬಳಿಯಲ್ಲಿ ಮನಸ್ಸೆ ಗೋತ್ರದವರು. ಮನಸ್ಸೆ ಮಕ್ಕಳಿಗೆ ಪೆದಾಚೂರನ ಮಗ ಗಮಲಿಯೇಲನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 32,200 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ತರುವಾಯ ಬೆನ್ಯಾಮೀನ್ ಗೋತ್ರದವರು. ಬೆನ್ಯಾಮೀನನ ಮಕ್ಕಳಿಗೆ ಗಿದ್ಯೋನಿಯ ಮಗ ಅಬೀದಾನನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 35,400 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ಎಫ್ರಾಯೀಮನ ಪಾಳೆಯದಲ್ಲಿ ಎಣಿಸಲಾದ ಸೈನಿಕರ ಸಂಖ್ಯೆ 1,08,100 ಮಂದಿ. ಇವರು ಮೂರನೆಯವರಾಗಿ ಹೊರಡತಕ್ಕವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ದಾನನ ದಂಡಿನ ಧ್ವಜವು ಅವರವರ ಸೈನ್ಯಗಳ ಪ್ರಕಾರವಾಗಿ ಉತ್ತರದಲ್ಲಿರುವರು: ದಾನನ ಮಕ್ಕಳಿಗೆ ಅಮ್ಮೀಷದ್ದೈಯನ ಮಗ ಅಹೀಗೆಜೆರನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 62,700 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ಅವರ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವವರು ಆಶೇರ್ ಗೋತ್ರದವರು. ಆಶೇರನ ಮಕ್ಕಳಿಗೆ ಒಕ್ರಾನನ ಮಗ ಪಗೀಯೇಲನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 41,500 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ತರುವಾಯ ನಫ್ತಾಲಿ ಗೋತ್ರದವರು. ನಫ್ತಾಲಿ ಮಕ್ಕಳಿಗೆ ಏನಾನನ ಮಗ ಅಹೀರನು ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 53,400 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ದಾನನ ಪಾಳೆಯದಲ್ಲಿ ಎಣಿಸಲಾದ ಸೈನಿಕರ ಸಂಖ್ಯೆ 1,57,600 ಮಂದಿ. ಅವರು ತಮ್ಮ ಧ್ವಜಗಳ ಪ್ರಕಾರ ಕಡೆಯ ದಂಡಾಗಿ ಹೊರಡತಕ್ಕದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ತಮ್ಮ ಕುಟುಂಬಗಳ ಪ್ರಕಾರವಾಗಿ ಎಣಿಕೆಯಾದವರು ಇವರೇ. ಪಾಳೆಯದೊಳಗೆ ಅವರವರ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಎಣಿಕೆಯಾದವರ ಸಂಖ್ಯೆ 6,03,550 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಲೇವಿಯರು ಇಸ್ರಾಯೇಲರೊಳಗೆ ಎಣಿಕೆಯಾಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರಾಯೇಲರು ಎಲ್ಲವನ್ನೂ ಮಾಡಿದರು. ಹಾಗೆಯೇ ತಮ್ಮ ಧ್ವಜಗಳ ಪ್ರಕಾರವೂ ತಮ್ಮ ತಮ್ಮ ವಂಶಗಳ ಪ್ರಕಾರವೂ ತಮ್ಮ ಕುಟುಂಬಗಳ ಪ್ರಕಾರವೂ ಪಾಳೆಯವನ್ನು ಹಾಕಿಕೊಳ್ಳುತ್ತಾ ಮುಂದುವರಿಯುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ಯೆಹೋವ ದೇವರು ಸೀನಾಯಿ ಪರ್ವತದಲ್ಲಿ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿದ ದಿವಸದಲ್ಲಿ ಆರೋನನ ಮತ್ತು ಮೋಶೆಯ ಸಂತತಿಗಳು ಇವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ಆರೋನನ ಮಕ್ಕಳುಗಳ ಹೆಸರುಗಳು: ಚೊಚ್ಚಲ ಮಗನು ನಾದಾಬ್, ತರುವಾಯ ಅಬೀಹೂ, ಎಲಿಯಾಜರ್ ಮತ್ತು ಈತಾಮಾರ್. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ಯಾಜಕರಾಗಿ ಅಭಿಷೇಕ ಹೊಂದಿದ ಆರೋನನ ಮಕ್ಕಳುಗಳ ಹೆಸರುಗಳು ಇವೇ, ಇವರೇ ಯಾಜಕೋದ್ಯೋಗ ಮಾಡುವುದಕ್ಕೆ ಪ್ರತಿಷ್ಠಿತರಾದವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ಆದರೆ ನಾದಾಬ್ ಮತ್ತು ಅಬೀಹೂ ಎಂಬ ಇಬ್ಬರು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಆಜ್ಞಾಪಿಸದೇ ಇದ್ದ ಬೇರೆ ಬೆಂಕಿಯನ್ನು ಅರ್ಪಿಸಿದಾಗ, ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಸತ್ತರು. ಅವರಿಗೆ ಮಕ್ಕಳು ಇರಲಿಲ್ಲ. ಹೀಗೆ ಎಲಿಯಾಜರನು, ಈತಾಮಾರನು ತಮ್ಮ ತಂದೆ ಆರೋನನ ಎದುರಿನಲ್ಲಿ ಯಾಜಕ ಉದ್ಯೋಗವನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ಲೇವಿಯ ಗೋತ್ರವನ್ನು ಹತ್ತಿರ ಕರೆದು, ಯಾಜಕನಾದ ಆರೋನನ ಮುಂದೆ ನಿಲ್ಲಿಸು. ಅವರು ಅವನಿಗೆ ಸಹಾಯ ಮಾಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ಇದಲ್ಲದೆ ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಳಿಯಲ್ಲಿದ್ದು ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆಮಾಡುತ್ತಾ ಆರೋನನಿಗಾಗಿಯೂ ಸಮಸ್ತ ಸಮೂಹದವರಿಗಾಗಿಯೂ ಕರ್ತವ್ಯಗಳನ್ನು ನಿರ್ವಹಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನು ನೋಡಿಕೊಳ್ಳಬೇಕು. ಗುಡಾರದ ಸೇವೆಯನ್ನು ಮಾಡುವ ಮೂಲಕ ಇಸ್ರಾಯೇಲರ ಜವಾಬ್ದಾರಿಗಳನ್ನು ಪೂರೈಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ಲೇವಿಯರನ್ನು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಒಪ್ಪಿಸು. ಇಸ್ರಾಯೇಲರೊಳಗಿಂದ ಅವನಿಗೆ ಪೂರ್ಣವಾಗಿ ಕೊಡಲಾದವರು ಇವರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ಇದಲ್ಲದೆ ಯಾಜಕ ಉದ್ಯೋಗವನ್ನು ನಡೆಸುವುದಕ್ಕಾಗಿ ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ನೇಮಿಸಬೇಕು. ಪರಕೀಯನು ಸಮೀಪಿಸಿದರೆ ಸಾಯಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೀಗೆಂದರು: ");
INSERT INTO kanokcv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ಪ್ರತಿಯೊಬ್ಬ ಇಸ್ರಾಯೇಲಿನ ಮಹಿಳೆಯ ಜೇಷ್ಠ ಮಗನಿಗೆ ಬದಲಾಗಿ ಇಸ್ರಾಯೇಲರೊಳಗಿಂದ ಲೇವಿಯರನ್ನು ತೆಗೆದುಕೊಂಡಿದ್ದೇನೆ. ಲೇವಿಯರು ನನಗೆ ಸೇರಿದವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ಏಕೆಂದರೆ ಜೇಷ್ಠರಾದವರೆಲ್ಲರೂ ನನ್ನವರೇ. ನಾನು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಜೇಷ್ಠರಾದವುಗಳನ್ನೆಲ್ಲಾ ಹೊಡೆದ ದಿವಸದಲ್ಲಿ ನಾನು ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಪುರುಷರಾಗಲಿ, ಪಶುಗಳಾಗಲಿ ಚೊಚ್ಚಲಾದ ಪ್ರತಿಯೊಂದನ್ನು ನನಗಾಗಿ ಪ್ರತ್ಯೇಕಿಸಿದ್ದೇನೆ. ಅವರು ನನ್ನವರಾಗಿರಬೇಕು. ನಾನೇ ಯೆಹೋವ ದೇವರು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ಯೆಹೋವ ದೇವರು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ಲೇವಿಯರನ್ನು ಕುಟುಂಬಗಳಾಗಿಯೂ, ಗೋತ್ರಗಳಾಗಿಯೂ ಎಣಿಕೆ ಮಾಡು. ಒಂದು ತಿಂಗಳು ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಗಂಡಸರೆಲ್ಲರನ್ನೂ ನೀನು ಎಣಿಸು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ಆಗ ಮೋಶೆಯು, ಯೆಹೋವ ದೇವರು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮಾತಿನ ಪ್ರಕಾರವಾಗಿ ಎಣಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ಲೇವಿಯ ಪುತ್ರರ ಹೆಸರುಗಳು: ಗೇರ್ಷೋನ್, ಕೊಹಾತ್ ಮತ್ತು ಮೆರಾರೀ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ಗೇರ್ಷೋನ್ ಗೋತ್ರದವರು: ಲಿಬ್ನೀ ಹಾಗೂ ಶಿಮ್ಮೀ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ಕೊಹಾತನ ಗೋತ್ರದವರು: ಅಮ್ರಾಮ್, ಇಚ್ಹಾರ್, ಹೆಬ್ರೋನ್ ಮತ್ತು ಉಜ್ಜೀಯೇಲ್. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ಮೆರಾರೀಯ ಗೋತ್ರದವರು: ಮಹ್ಲೀ ಮತ್ತು ಮೂಷೀ ಎಂಬವರು. ಗೋತ್ರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರವಾಗಿ ಇವರೇ ಲೇವಿ ವಂಶದವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ಗೇರ್ಷೋನ್ ವಂಶಕ್ಕೆ ಸೇರಿದ ಲಿಬ್ನೀಯ ಕುಟುಂಬವೂ ಶಿಮ್ಮೀಯ ಕುಟುಂಬದವರೂ ಇದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ಒಂದು ತಿಂಗಳೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಅವರ ಎಲ್ಲಾ ಗಂಡಸರ ಸಂಖ್ಯೆಯ ಪ್ರಕಾರ ಎಣಿಕೆಯಾದವರು 7,500 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ಗೇರ್ಷೋನ್ಯರ ಕುಟುಂಬಗಳು ದೇವದರ್ಶನದ ಗುಡಾರದ ಹಿಂದುಗಡೆ ಪಶ್ಚಿಮದ ಕಡೆಗೆ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ಗೇರ್ಷೋನ್ಯರ ಗೋತ್ರಗಳ ಮುಖ್ಯಸ್ಥನು ಲಾಯೇಲನ ಮಗ ಎಲ್ಯಾಸಾಫ್. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ದೇವದರ್ಶನದ ಗುಡಾರದ ಉಪಕರಣಗಳಲ್ಲಿ ಗೇರ್ಷೋನನ ವಂಶದವರು ನೋಡಿಕೊಳ್ಳಬೇಕಾದವುಗಳು ಯಾವವೆಂದರೆ: ಗುಡಾರ, ಅದರ ಮೇಲಿನ ಡೇರೆಯ ಬಟ್ಟೆ, ಅದರ ಹೊದಿಕೆ, ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿರುವ ಪರದೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ಗುಡಾರದ ಮತ್ತು ಬಲಿಪೀಠದ ಸುತ್ತಲಿರುವ ಅಂಗಳದ ತೆರೆಗಳು, ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆ ಮತ್ತು ಅವುಗಳ ಹಗ್ಗಗಳು. ಇಂತಹ ಎಲ್ಲಾ ವಿಧವಾದ ಸೇವೆಯನ್ನು ಗೇರ್ಷೋನ್ಯರು ಮಾಡಬೇಕಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ಅಮ್ರಾಮಿಯರು, ಇಚ್ಹಾರರು, ಹೆಬ್ರೋನಿಯರು, ಉಜ್ಜೀಯೇಲರು; ಇವು ಕೊಹಾತನ ಕುಟುಂಬಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ಕೊಹಾತ್ಯರಲ್ಲಿ ಒಂದು ತಿಂಗಳೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಗಂಡಸರ ಸಂಖ್ಯೆ 8,600 ಮಂದಿ. ಇವರು ಪರಿಶುದ್ಧ ಸ್ಥಳವನ್ನು ನೋಡಿಕೊಳ್ಳುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ಕೊಹಾತ್ಯರ ಗೋತ್ರಗಳವರು ಪರಿಶುದ್ಧ ಸ್ಥಳವನ್ನು ಕಾಯುವ ಜವಾಬ್ದಾರಿಕೆ ಹೊಂದಿದ್ದರು. ಅವರು ಗುಡಾರದ ಬಳಿಯಲ್ಲಿ ದಕ್ಷಿಣದ ಕಡೆಗೆ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ಉಜ್ಜೀಯೇಲನ ಪುತ್ರನಾದ ಎಲೀಚಾಫಾನನು ಕೊಹಾತ್ಯರ ಕುಟುಂಬಗಳ ನಾಯಕನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ಅವರು ನೋಡಿಕೊಳ್ಳಬೇಕಾಗಿದ್ದವುಗಳು ಯಾವವೆಂದರೆ: ಮಂಜೂಷ, ಮೇಜು, ದೀಪಸ್ತಂಭ, ವೇದಿಕೆಗಳು, ದೇವಸ್ಥಾನದ ಸೇವೋಪಕರಣಗಳು ಹಾಗೂ ಒಳಗಣ ಪರದೆ. ಇಂಥ ಎಲ್ಲಾ ವಿಧವಾದ ಸೇವೆಯನ್ನು ಅವರು ಮಾಡಬೇಕಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ಇದಲ್ಲದೆ ಯಾಜಕನಾಗಿರುವ ಆರೋನನ ಮಗ ಎಲಿಯಾಜರನು ಲೇವಿಯರ ಮತ್ತೊಬ್ಬ ನಾಯಕನಾಗಿದ್ದನು. ಪರಿಶುದ್ಧಸ್ಥಳದ ಜವಾಬ್ದಾರಿಕೆಯುಳ್ಳವನ ಮೇಲೆ ವಿಚಾರಕನು ಅವನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ಮೆರಾರೀಯ ಮಹ್ಲೀಯರ ಹಾಗೂ ಮೂಷೀಯರ ಗೋತ್ರಗಳಿಗೆ ಸಂಬಂಧಪಟ್ಟವನು. ಇವು ಮೆರಾರೀ ಗೋತ್ರಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ಅವರಲ್ಲಿ ಎಣಿಕೆಯಾದವರು ಒಂದು ತಿಂಗಳೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಗಂಡಸರ ಸಂಖ್ಯೆ 6,200 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ಅಬೀಹೈಲನ ಮಗ ಜುರೀಯೇಲನು ಮೆರಾರೀ ಗೋತ್ರದ ಮುಖ್ಯಸ್ಥನು. ಅವರು ದೇವದರ್ಶನ ಗುಡಾರದ ಬಳಿಯಲ್ಲಿ ಉತ್ತರ ದಿಕ್ಕಿನ ಕಡೆಗೆ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ಮೆರಾರೀ ಗೋತ್ರದವರು ದೇವದರ್ಶನ ಗುಡಾರದ ಹಲಗೆ, ಅಗುಳಿ, ಕಂಬ, ಕುಣಿಕೆ, ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳು, ಅದರ ಎಲ್ಲಾ ಸೇವೆಯೂ ");
INSERT INTO kanokcv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ಅಂಗಳದ ಸುತ್ತಮುತ್ತಲಿರುವ ಕಂಬಗಳೂ ಅವುಗಳ ಕುಣಿಕೆಗಳೂ ಅವುಗಳ ಗೂಟಗಳೂ ಅವುಗಳ ಹಗ್ಗಗಳೂ ಇವೆಲ್ಲವುಗಳ ಮೇಲ್ವಿಚಾರಣೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ದೇವದರ್ಶನ ಗುಡಾರದ ಎದುರಿನಲ್ಲಿ ಪೂರ್ವದಿಕ್ಕಿಗೆ ಅಂದರೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಮುಂದೆ ಪೂರ್ವದಿಕ್ಕಿಗೆ ಇಳಿದುಕೊಳ್ಳುವವರು ಮೋಶೆ, ಆರೋನ್ ಮತ್ತು ಅವನ ಪುತ್ರರು. ಇವರು ಇಸ್ರಾಯೇಲರಿಗಾಗಿ ಪರಿಶುದ್ಧಸ್ಥಳದ ಮೇಲ್ವಿಚಾರಣೆ ಮಾಡುವವರು. ಬೇರೆ ಯಾರಾದರೂ ಸಮೀಪಿಸಿದರೆ, ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆ ಆಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ಮೋಶೆಯೂ ಆರೋನನೂ ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯ ಪ್ರಕಾರ, ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಮಾಡಿದ ಎಲ್ಲಾ ಲೇವಿಯರು ಒಂದು ತಿಂಗಳೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಗಂಡಸರ ಸಂಖ್ಯೆ 22,000 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ಇಸ್ರಾಯೇಲರಲ್ಲಿರುವ ಜೇಷ್ಠಪುತ್ರರಲ್ಲಿ ಒಂದು ತಿಂಗಳೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳವರ ಲೆಕ್ಕವನ್ನು ತೆಗೆದುಕೋ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ಇಸ್ರಾಯೇಲರಲ್ಲಿರುವ ಜೇಷ್ಠರಾದವರೆಲ್ಲರಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರನ್ನೂ ಇಸ್ರಾಯೇಲರ ಪಶುಗಳಲ್ಲಿರುವ ಸಕಲ ಚೊಚ್ಚಲಾದವುಗಳಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರ ಪಶುಗಳನ್ನೂ ನನಗೋಸ್ಕರ ತೆಗೆದುಕೋ, ‘ನಾನೇ ಯೆಹೋವ ದೇವರು,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ಯೆಹೋವ ದೇವರು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಮೋಶೆ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಜೇಷ್ಠರಾಗಿರುವುದೆಲ್ಲವನ್ನು ಎಣಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ಒಂದು ತಿಂಗಳೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಜೇಷ್ಠರಾದವರೆಲ್ಲರ ಒಟ್ಟು ಸಂಖ್ಯೆ 22,273 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಪುನಃ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಜೇಷ್ಠರಾದವರೆಲ್ಲರಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರನ್ನು ಮತ್ತು ಅವರ ಚೊಚ್ಚಲಾದ ಪಶುಗಳಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರ ಪಶುಗಳನ್ನು ತೆಗೆದುಕೋ. ಲೇವಿಯರು ನನ್ನವರಾಗಿರುವರು. ನಾನೇ ಯೆಹೋವ ದೇವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ಇಸ್ರಾಯೇಲರ ಜೇಷ್ಠರಾದವರಲ್ಲಿ ಲೇವಿಯರಿಗಿಂತ ಹೆಚ್ಚಾಗಿರುವ 273 ಮಂದಿಯ ವಿಮೋಚನೆಯ ಕ್ರಯವಾಗಿ ");
INSERT INTO kanokcv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ಒಬ್ಬೊಬ್ಬನಿಗೆ ಐದು ಶೆಕೆಲ್ ತೆಗೆದುಕೋ. ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, ಅಂದರೆ ಇಪ್ಪತ್ತು ಗೇರಾ ತೂಕದ ಶೆಕೆಲ್ ಈ ಪ್ರಕಾರವಾಗಿ ಇದನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ಅವರೊಳಗೆ ಹೆಚ್ಚಾಗಿರುವವರ ವಿಮೋಚನೆಯ ಕ್ರಯವನ್ನು ಆರೋನನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ ನೀನು ಕೊಡಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ಹೀಗೆ ಮೋಶೆಯು ಲೇವಿಯರಿಂದ ವಿಮೋಚಿಸಲಾದವರಿಗೆ ಹೆಚ್ಚು ಜನರ ವಿಮೋಚನೆಯ ಕ್ರಯವಾದ ಹಣವನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಜೇಷ್ಠರಾದವರಿಂದ ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ ನಿಗದಿಯಾದ 1,365 ಶೆಕೆಲ್‌ಗಳನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ವಿಮೋಚನೆಯ ಹಣವನ್ನು ಆರೋನನಿಗೂ, ಅವನ ಪುತ್ರರಿಗೂ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಮತ್ತು ಆರೋನನ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ಲೇವಿಯರೊಳಗೆ ಕೊಹಾತ್ಯರಲ್ಲಿಯ ಕುಟುಂಬಗಳನ್ನು ಗೋತ್ರಗಳನ್ನಾಗಿ ಲೆಕ್ಕಮಾಡು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ಮೂವತ್ತು ವರ್ಷವಾದವರನ್ನೂ, ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಪುರುಷರನ್ನೂ ಅಂದರೆ ಐವತ್ತು ವರ್ಷದವರವರೆಗೆ ದೇವದರ್ಶನ ಗುಡಾರದಲ್ಲಿ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೆ ಬರುವವರನ್ನು ಲೆಕ್ಕಮಾಡು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಕೊಹಾತ್ಯರು ಮಾಡುವ ಸೇವೆ ಯಾವುದೆಂದರೆ, ದೇವದರ್ಶನ ಗುಡಾರದ ಅತಿಪರಿಶುದ್ಧವಾದ ವಸ್ತುಗಳನ್ನು ಕಾಪಾಡುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ಜನರು ಹೊರಡುವಾಗ, ಆರೋನನೂ, ಅವನ ಮಕ್ಕಳೂ ಒಳಗೆ ಹೋಗಿ ಪರದೆಯನ್ನು ಇಳಿಸಿ, ಅದರಿಂದ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷವನ್ನು ಮುಚ್ಚಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ಅದರ ಮೇಲೆ ಕಡಲುಹಂದಿಯ ಚರ್ಮದ ಹೊದಿಕೆಯನ್ನು ಹೊದಿಸಬೇಕು. ಅದರ ಮೇಲ್ಭಾಗದಲ್ಲಿ ಪೂರ್ಣವಾದ ನೀಲಿವಸ್ತ್ರವನ್ನು ಹಾಸಿ, ಕೋಲುಗಳನ್ನು ಅದರ ಸ್ಥಳದಲ್ಲಿ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“ಸಮ್ಮುಖದ ರೊಟ್ಟಿಯ ಮೇಜಿನ ಮೇಲೆ ಅವರು ನೀಲಿವಸ್ತ್ರವನ್ನು ಹಾಸಿ, ಅದರ ಮೇಲೆ ಪಾತ್ರೆಗಳನ್ನು, ಸೌಟುಗಳನ್ನು, ಬೋಗುಣಿಗಳನ್ನು ಮತ್ತು ಪಾನಾರ್ಪಣೆಯ ಹೂಜಿಗಳನ್ನು ಇಡಬೇಕು. ನಿತ್ಯಾರ್ಪಣೆಯ ರೊಟ್ಟಿಯನ್ನು ಅದರ ಮೇಲೆ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ಅವೆಲ್ಲವುಗಳ ಮೇಲೆ ಕಡುಗೆಂಪಾದ ವಸ್ತ್ರವನ್ನು ಹಾಸಿ, ಅದನ್ನು ಕಡಲುಹಂದಿಯ ಚರ್ಮಗಳ ಹೊದಿಕೆಯಿಂದ ಹೊದಿಸಿ, ಅದರ ಕೋಲುಗಳನ್ನು ಸರಿಯಾದ ಸ್ಥಳದಲ್ಲಿ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“ಇದಲ್ಲದೆ ಅವರು ನೀಲಿವಸ್ತ್ರವನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದರಿಂದ ದೀಪಸ್ತಂಭವನ್ನೂ, ಅದರ ದೀಪಗಳನ್ನೂ, ಅದರ ಬತ್ತಿ ಕತ್ತರಿಸುವ ಸಲಕರಣೆಗಳನ್ನೂ, ಅದರ ಬಟ್ಟಲುಗಳನ್ನೂ, ಅದಕ್ಕೆ ಸೇವೆ ಮಾಡುವ ಸಕಲ ಎಣ್ಣೆಯ ಪಾತ್ರೆಗಳನ್ನೂ ಮುಚ್ಚಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ಅವರು ಅದನ್ನೂ, ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ಕಡಲುಹಂದಿಯ ಚರ್ಮಗಳ ಮುಚ್ಚಳದೊಳಗೆ ಇಟ್ಟು, ಅಡ್ಡ ದಂಡಕ್ಕೆ ಕಟ್ಟಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“ಇದಲ್ಲದೆ ಬಂಗಾರದ ಬಲಿಪೀಠದ ಮೇಲೆ ಅವರು ನೀಲಿವಸ್ತ್ರವನ್ನು ಹಾಸಿ, ಅದನ್ನು ಕಡಲುಹಂದಿಯ ಚರ್ಮಗಳ ಮುಚ್ಚಳದೊಳಗೆ ಮುಚ್ಚಿ, ಅದರ ಕೋಲುಗಳನ್ನು ಸರಿಯಾದ ಸ್ಥಳದಲ್ಲಿ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಸೇವೆ ಮಾಡುವ ಸೇವೆಯ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನು ಅವರು ತೆಗೆದುಕೊಂಡು ನೀಲಿ ವಸ್ತ್ರದಿಂದ ಕಟ್ಟಿ, ಕಡಲುಹಂದಿಯ ಚರ್ಮಗಳ ಹೊದಿಕೆಯಿಂದ ಮುಚ್ಚಿ, ಅಡ್ಡ ದಂಡಕ್ಕೆ ಕಟ್ಟಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“ಬಲಿಪೀಠದ ಬೂದಿಯನ್ನು ತೆಗೆದು, ಅದರ ಮೇಲೆ ಧೂಮ್ರವರ್ಣದ ವಸ್ತ್ರವನ್ನು ಹಾಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ಅದರ ಮೇಲೆ ಸೇವೆ ಮಾಡುವ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನು, ಅಗ್ನಿ ಪಾತ್ರೆಗಳನ್ನು, ಮುಳ್ಳುಗಳನ್ನು, ಸಲಿಕೆಗಳನ್ನು, ಬೋಗುಣಿಗಳನ್ನು, ಬಲಿಪೀಠದ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನು ಅದರ ಮೇಲಿಟ್ಟು, ಕಡಲುಹಂದಿಯ ಚರ್ಮಗಳ ಹೊದಿಕೆಯನ್ನು ಹಾಕಿ, ಹೊರುವ ಕೋಲುಗಳನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ಪರಿಶುದ್ಧ ಸ್ಥಳವನ್ನೂ, ಪರಿಶುದ್ಧಸ್ಥಳದ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ಮುಚ್ಚಿದ ಮೇಲೆ, ಪಾಳೆಯವು ಹೊರಡುವಾಗ ಕೊಹಾತ್ಯರು ಅದನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗುವುದಕ್ಕೆ ಪ್ರವೇಶಿಸಬೇಕು. ಆದರೆ ಅವರು ಸಾಯದೆ ಇರಬೇಕಾದರೋ, ಪರಿಶುದ್ಧವಾದ ಯಾವುದನ್ನೂ ಮುಟ್ಟಬಾರದು. ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಕೊಹಾತ್ಯನ ಪುತ್ರರ ಹೊರೆಗಳು ಇವೇ ಆಗಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“ಯಾಜಕನಾದ ಆರೋನನ ಮಗ ಎಲಿಯಾಜರನ ಕೆಲಸ ಯಾವುದೆಂದರೆ, ದೀಪದ ಎಣ್ಣೆಯೂ, ಸುಗಂಧ ಧೂಪವೂ, ನಿತ್ಯದ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯೂ, ಅಭಿಷೇಕದ ತೈಲವೂ, ಸಮಸ್ತ ಗುಡಾರವೂ, ಅದರಲ್ಲಿರುವ ಸಕಲವೂ, ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿರುವ ಅದರ ಸಾಮಗ್ರಿಗಳೂ ಅವನ ಮೇಲ್ವಿಚಾರಣೆಯಲ್ಲಿರಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ನೀವು ಲೇವಿಯರೊಳಗಿಂದ ಕೊಹಾತ್ಯರ ಗೋತ್ರದ ಕಟುಂಬಗಳು ನಾಶವಾಗಿ ಹೋಗದಂತೆ ನೋಡಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ಅವರು ಮಹಾಪರಿಶುದ್ಧ ವಸ್ತುಗಳ ಸಮೀಪಕ್ಕೆ ಬರುವಾಗ, ಅವರು ಸಾಯದೆ ಬದುಕುವ ಹಾಗೆ ಹೀಗೆ ಎಚ್ಚರಿಕೆ ವಹಿಸಬೇಕು: ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಒಳಗೆ ಪ್ರವೇಶಿಸಿ, ಅವರಲ್ಲಿ ಒಬ್ಬೊಬ್ಬನನ್ನು ಅವನ ಕೆಲಸಕ್ಕೂ ಅವನ ಹೊರೆಯನ್ನೂ ನೇಮಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ಆದರೆ ಕೊಹಾತ್ಯರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಒಳಗೆ ಬಂದು, ಒಂದು ಕ್ಷಣವೂ ಆ ಪವಿತ್ರ ವಸ್ತುಗಳನ್ನು ನೋಡಬಾರದು, ನೋಡಿ ಸಾವನ್ನಪ್ಪದಿರಲಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“ಗೇರ್ಷೋನನ ಪುತ್ರರ ಲೆಕ್ಕವನ್ನು ಸಹ ಅವರ ತಂದೆಗಳ ಮನೆಗಳ ಪ್ರಕಾರವಾಗಿಯೂ, ಅವರ ಕುಲಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ಮೂವತ್ತು ವರುಷವೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಐವತ್ತು ವರುಷಗಳ ಪ್ರಾಯವುಳ್ಳ ಪುರುಷರನ್ನೂ ದೇವದರ್ಶನ ಗುಡಾರದಲ್ಲಿ ಸೇವೆ ಮಾಡುವುದಕ್ಕೂ, ಅದನ್ನು ಪೂರೈಸುವುದಕ್ಕೂ ಸೇರುವವರೆಲ್ಲರನ್ನೂ ಎಣಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“ಗೇರ್ಷೋನ್ಯರ ಕುಟುಂಬಗಳ ಸೇವೆಯೂ ಜವಾಬ್ದಾರಿಕೆ ಯಾವುದೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ಅವರು ಗುಡಾರದ ಪರದೆಗಳನ್ನೂ ದೇವದರ್ಶನ ಗುಡಾರವನ್ನೂ ಅದರ ಹೊದಿಕೆಯನ್ನೂ ಅದರ ಮೇಲಿರುವ ಕಡಲುಹಂದಿಯ ಚರ್ಮಗಳ ಹೊದಿಕೆಯನ್ನೂ ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಿನ ಪರದೆಯನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ಅಂಗಳದ ಪರದೆಗಳನ್ನೂ ಗುಡಾರವನ್ನೂ ಬಲಿಪೀಠವನ್ನೂ ಇವುಗಳ ಸುತ್ತಲಿರುವ ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆಯನ್ನೂ ಅವುಗಳ ಹಗ್ಗಗಳನ್ನೂ, ಅವುಗಳ ಸೇವೆಯ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ ಹೊತ್ತುಕೊಳ್ಳಬೇಕು. ಅವುಗಳಿಗೆ ಮಾಡತಕ್ಕ ಎಲ್ಲಾ ಸೇವೆಯನ್ನು ಹೀಗೆ ಅವರು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ಗೇರ್ಷೋನ್ಯರು ಆರೋನ್, ಅವನ ಪುತ್ರರ ನಿರ್ದೇಶನದ ಮೇರೆಗೆ ಅವರ ಹೊರೆಹೊರುವದನ್ನು ಮತ್ತು ಇತರ ಕೆಲಸಗಳನ್ನು ಮಾಡಲಿ. ನೀವೇ ಹೊರೆಗಳನ್ನು ಗೊತ್ತುಮಾಡಿ ಅವರವರ ವಶಕ್ಕೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ಗೇರ್ಷೋನ್ಯರ ಕುಟುಂಬದವರು ಸಭೆಯ ಗುಡಾರದಲ್ಲಿ ಮಾಡುವ ಸೇವೆಯೂ ಇದೆ. ಯಾಜಕನಾದ ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನ ಕೈಕೆಳಗೆ ಇರುವುದು ಅವರಿಗೆ ಅಪ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“ಮೆರಾರೀಯ ಪುತ್ರರನ್ನು ಅವರ ಕುಲಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ಕುಟುಂಬಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ಎಣಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ಮೂವತ್ತು ವರುಷವೂ, ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಪುರುಷರನ್ನೂ ಅಂದರೆ ಐವತ್ತು ವರ್ಷಗಳವರೆಗೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆ ಮಾಡುವುದಕ್ಕಾಗಿ ಒಳಗೆ ಪ್ರವೇಶಿಸುವವರನ್ನೆಲ್ಲಾ ಎಣಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಅವರು ಮಾಡತಕ್ಕ ಸಮಸ್ತ ಸೇವೆಯ ಪ್ರಕಾರ ಅವರು ಹೊರುವುದಕ್ಕೆ ನೀಡಿದ ಅಪ್ಪಣೆಯು ಏನೆಂದರೆ: ಗುಡಾರದ ಹಲಿಗೆಗಳೂ ಅದರ ಅಡ್ಡ ದಂಡ ಅದರ ಕಂಬಗಳ ಆಧಾರಗಳೂ ಅದರ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳೂ ");
INSERT INTO kanokcv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ಸುತ್ತಲಿರುವ ಅಂಗಳದ ಕಂಬಗಳ ಆಧಾರಗಳೂ ಅದರ ಗದ್ದಿಗೇ ಕಲ್ಲುಗಳೂ ಅದರ ಗೂಟಗಳೂ ಅವುಗಳ ಹಗ್ಗಗಳೂ ಅವುಗಳ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ಅವುಗಳ ಸಮಸ್ತ ಸೇವೆಯ ಪ್ರಕಾರವಾಗಿಯೂ ಅವರು ಹೊರುವುದಕ್ಕೆ ಕೊಟ್ಟ ಅಪ್ಪಣೆಯ ಸಲಕರಣೆಗಳನ್ನು ನೀವು ಹೆಸರೆಸರಾಗಿ ಎಣಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ಮೆರಾರೀಯ ಪುತ್ರರ ಕುಟುಂಬಗಳ ಸೇವೆಯೂ, ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಅವರು ಮಾಡುವ ಸಮಸ್ತ ಸೇವೆಯೂ ಇದೆ. ಅದು ಯಾಜಕನಾದ ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನ ಕೈಕೆಳಗೆ ಇರಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ಮೋಶೆಯೂ, ಆರೋನನೂ, ಸಭೆಯ ಮುಖ್ಯಸ್ಥನೂ, ಕೊಹಾತ್ಯರ ಪುತ್ರರನ್ನು ಅವರ ಕುಲಗಳ ಪ್ರಕಾರವಾಗಿಯೂ, ಅವರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ");
INSERT INTO kanokcv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ಮೂವತ್ತು ವರ್ಷವೂ, ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಪುರುಷರೂ ಎಂದರೆ ಐವತ್ತು ವರ್ಷಗಳವರೆಗೆ ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಕೆಲಸಕ್ಕಾಗಿ ಸೇವೆಯಲ್ಲಿ ಸೇರುವವರೆಲ್ಲರನ್ನು ಎಣಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ಕುಲಗಳ ಪ್ರಕಾರ ಅವರಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 2,750 ಮಂದಿಯಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ಮೋಶೆಗೆ ಯೆಹೋವ ದೇವರು ಅಪ್ಪಣೆ ಮಾಡಿದ ಹಾಗೆ ಮೋಶೆಯೂ, ಆರೋನನೂ ಎಣಿಸಿದ ಕೊಹಾತ್ಯರ ಕುಟುಂಬಗಳಲ್ಲಿ ಎಣಿಕೆಯಾದವರೂ, ದೇವದರ್ಶನ ಗುಡಾರದಲ್ಲಿ ಸೇವೆ ಮಾಡುವವರೆಲ್ಲರೂ ಇವರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ಗೇರ್ಷೋನನ ಪುತ್ರರಲ್ಲಿ ಅವರ ಕುಲಗಳ ಪ್ರಕಾರವಾಗಿಯೂ, ಅವರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ಎಣಿಕೆಯಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ಮೂವತ್ತು ವರ್ಷವೂ, ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಪುರುಷರನ್ನೂ, ಎಂದರೆ ಐವತ್ತು ವರ್ಷಗಳವರೆಗೆ ದೇವದರ್ಶನ ಗುಡಾರದ ಕೆಲಸಕ್ಕಾಗಿ ಸೇವೆಯಲ್ಲಿ ಸೇರುವವರೆಲ್ಲರನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ಎಂದರೆ ಅವರ ಕುಲಗಳ ಪ್ರಕಾರವಾಗಿಯೂ, ಅವರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರವಾಗಿಯೂ, ಅವರಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 2,630 ಮಂದಿಯಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ಯೆಹೋವ ದೇವರ ಅಪ್ಪಣೆಯ ಹಾಗೆ ಮೋಶೆಯೂ, ಆರೋನನೂ ಎಣಿಸಿದ ಗೇರ್ಷೋನನ ಪುತ್ರರ ಕುಟುಂಬಗಳಲ್ಲಿ ಎಣಿಕೆಯಾದವರೂ, ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಸೇವೆ ಮಾಡುವವರೆಲ್ಲರೂ ಇವರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ಮೆರಾರೀಯ ಪುತ್ರರಲ್ಲಿ ಅವರ ಕುಲಗಳ ಪ್ರಕಾರವಾಗಿಯೂ, ಅವರ ತಂದೆಗಳ ಮನೆಯ ಪ್ರಕಾರವಾಗಿಯೂ ಎಣಿಕೆಯಾದವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ಮೂವತ್ತು ವರ್ಷವೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಪುರುಷರನ್ನೂ ಅಂದರೆ ಐವತ್ತು ವರ್ಷಗಳವರೆಗೆ ದೇವದರ್ಶನ ಗುಡಾರದ ಕೆಲಸಕ್ಕಾಗಿ ಸೇವೆಯಲ್ಲಿ ಸೇರುವವರೆಲ್ಲರನ್ನು ");
INSERT INTO kanokcv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ಎಂದರೆ, ಅವರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಅವರಲ್ಲಿ ಎಣಿಕೆಯಾದವರು 3,200 ಮಂದಿಯಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ಮೋಶೆಗೆ ಯೆಹೋವ ದೇವರು ಅಪ್ಪಣೆ ಮಾಡಿದ ಹಾಗೆ ಮೋಶೆಯೂ ಆರೋನನೂ ಎಣಿಸಿದ ಮೆರಾರೀಯ ಪುತ್ರರ ಕುಲಗಳಲ್ಲಿ ಎಣಿಕೆಯಾದವರು ಇವರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ಮೋಶೆಯೂ, ಆರೋನನೂ, ಇಸ್ರಾಯೇಲಿನ ಮುಖ್ಯಸ್ಥರೂ ಎಣಿಸಿದ ಸಮಸ್ತ ಲೇವಿಯರು ಅವರ ಕುಲಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ಅವರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ಎಣಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ದೇವದರ್ಶನ ಗುಡಾರದಲ್ಲಿ ಕೆಲಸ ಮಾಡುವುದಕ್ಕಾಗಿಯೂ, ಹೊರುವುದಕ್ಕಾಗಿಯೂ ಬರುವವರೆಲ್ಲರೂ ಎಂದರೆ, ಅವರಲ್ಲಿ ಮೂವತ್ತು ವರ್ಷವೂ, ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಪುರುಷರನ್ನೂ ಎಂದರೆ, ಐವತ್ತು ವರ್ಷಗಳವರೆಗೆ ");
INSERT INTO kanokcv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ಎಣಿಕೆಯಾದವರು 8,580 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಅಪ್ಪಣೆಕೊಟ್ಟ ಪ್ರಕಾರ ಅವರನ್ನು ಅವರವರ ಸೇವೆಗಾಗಿಯೂ, ಹೊರುವುದಕ್ಕಾಗಿಯೂ ಜವಾಬ್ದಾರಿಕೆ ಕೊಡಲಾಯಿತು. ಹೀಗೆ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಅಪ್ಪಣೆಕೊಟ್ಟ ಪ್ರಕಾರ ಅವರನ್ನು ಎಣಿಸಲಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ಚರ್ಮರೋಗವಿರುವವರೆಲ್ಲರನ್ನು, ಮೇಹಸ್ರಾವವುಳ್ಳವರೆಲ್ಲರನ್ನು ಮತ್ತು ಹೆಣದ ಸೋಂಕಿನಿಂದ ಅಶುದ್ಧರಾದವರೆಲ್ಲರನ್ನು ಪಾಳೆಯದೊಳಗಿಂದ ಹೊರಗೆ ಕಳುಹಿಸಬೇಕೆಂದು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ಸ್ತ್ರೀ ಪುರುಷವೆಂಬ ವ್ಯತ್ಯಾಸವಿಲ್ಲದೆ ಎಲ್ಲರನ್ನು ಹೊರಹಾಕಬೇಕು. ನಾನು ಅವರ ಮಧ್ಯದಲ್ಲಿ ವಾಸಮಾಡುವ ಪಾಳೆಯವನ್ನು ಅವರು ಅಶುದ್ಧ ಮಾಡದ ಹಾಗೆ ನೀವು ಅವರನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಕಳುಹಿಸಬೇಕು,” ಎಂಬುದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ಆಗ ಇಸ್ರಾಯೇಲರು ಹಾಗೆ ಮಾಡಿ, ಅವರನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಕಳುಹಿಸಿದರು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ ಪ್ರಕಾರ ಇಸ್ರಾಯೇಲರು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ‘ಪುರುಷನಾದರೂ ಸ್ತ್ರೀಯಾದರೂ ಮತ್ತೊಬ್ಬರಿಗೆ ಮೋಸಮಾಡಿ ಯೆಹೋವ ದೇವರಿಗೆ ಅಪನಂಬಿಗಸ್ತರಾದರೆ, ಆ ವ್ಯಕ್ತಿ ಅಪರಾಧಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ಅವನು ಮಾಡಿದ ಪಾಪವನ್ನು ಅರಿಕೆ ಮಾಡಬೇಕು. ಅವನ ಅಪರಾಧದ ಬದಲುಕೊಟ್ಟು, ಅದರ ಸಂಗಡ ಅದರ ಐದನೆಯ ಪಾಲನ್ನು ಕೂಡಿಸಿ, ಯಾರಿಗೆ ಅಪರಾಧ ಮಾಡಿದರೋ, ಅವರಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ಆದರೆ ಅಪರಾಧಕ್ಕೆ ಬದಲು ಕೊಡುವುದಕ್ಕೆ ಆ ಮನುಷ್ಯನಿಗೆ ಸಂಬಂಧಿಕನು ಇಲ್ಲದಿದ್ದರೆ ಅದು ಯೆಹೋವ ದೇವರಿಗೆ ಸೇರಬೇಕು. ಅದು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಅರ್ಪಿಸಲಾಗುವ ಪ್ರಾಯಶ್ಚಿತ್ತದ ಟಗರು, ಇವೆರಡೂ ಯಾಜಕನಿಗೆ ಸೇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ಇಸ್ರಾಯೇಲರು ತರುವ ಸಕಲ ಪರಿಶುದ್ಧವಾದ ಕಾಣಿಕೆಗಳೆಲ್ಲಾ ಯಾಜಕನಿಗೇ ಸಲ್ಲಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ಪ್ರತಿ ಮನುಷ್ಯನ ಪರಿಶುದ್ಧವಾದ ಕಾಣಿಕೆಗಳು ಅವನದಾಗಿಯೇ ಆಗಿರುತ್ತವೆ. ಆದರೆ ಯಾಜಕನಿಗೆ ಕೊಟ್ಟದ್ದು ಯಾಜಕರದಾಗುತ್ತದೆ,’ ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು, ‘ಯಾವನ ಹೆಂಡತಿಯಾದರೂ ದಾರಿತಪ್ಪಿ ಅವನಿಗೆ ಅಪನಂಬಿಗಸ್ತಳಾಗಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ಇಲ್ಲವೆ ಒಬ್ಬನು ಅವಳ ಸಂಗಡ ಮಲಗಿ ಸಂಗಮ ಮಾಡಿದ್ದು, ಅವಳ ಗಂಡನ ಕಣ್ಣುಗಳಿಗೆ ಮರೆಯಾಗಿದ್ದರೆ, ಅವಳು ಅಶುದ್ಧಳೆಂಬುದು ಗುಪ್ತವಾಗಿದ್ದರೆ, ಅವಳಿಗೆ ವಿರೋಧವಾಗಿ ಸಾಕ್ಷಿ ಇಲ್ಲದೆ, ಅವಳನ್ನು ಹಿಡಿಯದೇ ಇದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ಆಕೆ ಅಶುದ್ಧಳಾಗಿದ್ದಾಳೆಂದು ಆಕೆಯ ಮೇಲೆ ಅಸೂಯೆಗೊಂಡು ಸಂಶಯಪಟ್ಟರೆ, ಆಕೆ ಅಶುದ್ಧಳಾಗದಿದ್ದರೂ, ಆಕೆಯೊಡನೆ ಅಸೂಯೆ ಸಂಶಯ ಹೊಂದಿದರೆ, ಆಗ ");
INSERT INTO kanokcv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ಆ ಮನುಷ್ಯನು ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ಅವಳಿಗೋಸ್ಕರ ಕಾಣಿಕೆಯಾಗಿ ಒಂದು ಓಮರ್ ಜವೆಗೋಧಿಯ ಹಿಟ್ಟನ್ನು ತರಬೇಕು. ಅದರ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನಾದರೂ ಸಾಂಬ್ರಾಣಿಯನ್ನಾದರೂ ಹಾಕಬಾರದು. ಏಕೆಂದರೆ ಅದು ಸಂಶಯವನ್ನು ಸೂಚಿಸುವುದಕ್ಕೂ ಅಪರಾಧವನ್ನು ಹೊರಪಡಿಸುವುದಕ್ಕೂ ಜ್ಞಾಪಕಕ್ಕೆ ತರುವ ಕಾಣಿಕೆಯೂ ಆಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘ಯಾಜಕನು ಅವಳನ್ನು ಸಮೀಪಕ್ಕೆ ಕರೆದು, ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ಆಗ ಯಾಜಕನು ಪವಿತ್ರ ನೀರನ್ನು ಮಣ್ಣಿನ ಗಡಿಗೆಗಳಲ್ಲಿ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಗುಡಾರದ ನೆಲದಲ್ಲಿರುವ ಧೂಳನ್ನು ಯಾಜಕನು ತೆಗೆದುಕೊಂಡು, ಆ ನೀರಿನೊಳಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ಯಾಜಕನು ಆ ಸ್ತ್ರೀಯನ್ನು ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ನಿಲ್ಲಿಸಿ, ಆಕೆಯ ತಲೆಯ ಮೇಲಿರುವ ಮುಸುಕನ್ನು ತೆಗೆದು, ಅವಳ ಕೈಗಳಲ್ಲಿ ಸಂಶಯ ಸೂಚಿಸುವ ಕಾಣಿಕೆಯಾದ ನೈವೇದ್ಯದ ಹಿಟ್ಟನ್ನು ಇಡಬೇಕು. ಯಾಜಕನ ಕೈಯಲ್ಲಿ ಶಾಪತರುವ ಕಹಿಯಾದ ನೀರು ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ಯಾಜಕನು ಅವಳನ್ನು ಪ್ರಮಾಣ ಮಾಡಿಸಿ, ಸ್ತ್ರೀಗೆ ಹೇಳಬೇಕಾದದ್ದು, “ಮದುವೆಯಾಗಿ ಗಂಡನೊಂದಿಗೆ ಸಂಸಾರ ನಡೆಸುವಾಗ, ಒಬ್ಬ ಪರಪುರುಷನು ನಿನ್ನ ಸಂಗಡ ಮಲಗಿರದಿದ್ದರೆ, ನಿನ್ನ ಗಂಡನನ್ನು ಬಿಟ್ಟು ನೀನು ಜಾರತ್ವ ಮಾಡದೆ ಇದ್ದರೆ, ಶಾಪವನ್ನು ಉಂಟುಮಾಡುವ ಈ ನೀರು ನಿನಗೆ ಯಾವ ಹಾನಿಮಾಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ಆದರೆ ನೀನು ನಿನ್ನ ಗಂಡನನ್ನು ಬಿಟ್ಟು, ಜಾರತ್ವ ಮಾಡಿ ಅಶುದ್ಧಳಾಗಿದ್ದರೆ, ನಿನ್ನ ಗಂಡನನ್ನು ಬಿಟ್ಟು, ಮತ್ತೊಬ್ಬನು ನಿನ್ನ ಸಂಗಡ ಮಲಗಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ಯೆಹೋವ ದೇವರು ನಿನ್ನ ತೊಡೆಯನ್ನು ಕ್ಷೀಣವಾಗುವಂತೆಯೂ ನಿನ್ನ ಹೊಟ್ಟೆಯನ್ನು ಉಬ್ಬುವಂತೆಯೂ ಮಾಡುವನು. ನಿನ್ನ ಜನರು ನಿನ್ನನ್ನು ಶಪಿಸುವರು, ತಿರಸ್ಕರಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ಶಪಿಸುವಂಥ ಈ ನೀರು ನಿನ್ನೊಳಗೆ ಸೇರಿ ನಿನ್ನ ಹೊಟ್ಟೆ ಉಬ್ಬುವಂತೆ, ತೊಡೆಯನ್ನು ಕ್ಷೀಣವಾಗಿ ಹೋಗುವಂತೆ ನಿನ್ನ ಜನನೇಂದ್ರಿಯಗಳು ಬತ್ತಿಹೋಗುವಂತೆ ಮಾಡಲಿ ಎಂದು ಹೇಳಬೇಕು, ಈ ಪ್ರಕಾರ ಯಾಜಕನು ಆ ಸ್ತ್ರೀಯನ್ನು ಶಾಪದ ಪ್ರಮಾಣ ಮಾಡಿಸಬೇಕು.” “ ‘ಅದಕ್ಕೆ ಆ ಸ್ತ್ರೀಯು, “ಆಮೆನ್, ಆಮೆನ್,” ಎಂದು ಹೇಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘ಇದಲ್ಲದೆ ಯಾಜಕನು ಈ ಶಾಪವನ್ನು ಪುಸ್ತಕದಲ್ಲಿ ಬರೆದು, ಕಹಿಯಾದ ನೀರಿನಿಂದ ತೊಳೆದು, ");
INSERT INTO kanokcv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ಆ ಸ್ತ್ರೀಗೆ ಶಪಿಸುವಂಥಹ ಕಹಿಯಾದ ನೀರನ್ನು ಕುಡಿಸಬೇಕು. ಆಗ ಶಪಿಸುವ ನೀರು ಅವಳಲ್ಲಿ ಸೇರಿ ಕಹಿಯಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ಬಳಿಕ ಯಾಜಕನು ಆ ಸ್ತ್ರೀಯ ಕೈಯಿಂದ ಸಂಶಯ ಸೂಚಕ ಕಾಣಿಕೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಆ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ನೈವೇದ್ಯ ಮಾಡಿ, ಬಲಿಪೀಠದ ಸಮೀಪಕ್ಕೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ಆಗ ಯಾಜಕನು ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಕಾಣಿಕೆಯಿಂದ ಒಂದು ಹಿಡಿ ತೆಗೆದುಕೊಂಡು, ಬಲಿಪೀಠದ ಮೇಲೆ ಸುಟ್ಟು, ಸ್ತ್ರೀಗೆ ಆ ನೀರನ್ನು ಕುಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ಆಕೆಗೆ ಆ ನೀರನ್ನು ಕುಡಿಸಿದ ಮೇಲೆ ಆಕೆಯು ಅಶುದ್ಧಳಾಗಿ ತನ್ನ ಗಂಡನಿಗೆ ಅಪರಾಧ ಮಾಡಿದ್ದಾಗಿದ್ದರೆ, ಶಪಿಸುವ ನೀರು ಆಕೆಯೊಳಗೆ ಸೇರಿ ಕಹಿಯಾಗುವುದು. ಅವಳ ಹೊಟ್ಟೆ ಉಬ್ಬಿ, ಅವಳ ತೊಡೆ ಕ್ಷೀಣವಾಗುವುದು. ಆಗ ಆ ಸ್ತ್ರೀ ತನ್ನ ಜನರ ಮಧ್ಯದಲ್ಲಿ ಶಾಪಗ್ರಸ್ತಳಾಗಿರುವಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ಆದರೆ ಆ ಸ್ತ್ರೀ ಅಶುದ್ಧಳಲ್ಲದೆ ಶುದ್ಧಳಾಗಿದ್ದರೆ, ಅವಳು ನಿರಪರಾಧಿಯಾಗಿದ್ದು ಸಂತಾನವನ್ನು ಪಡೆಯುವಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘ಸಂಶಯ ಪರಿಹಾರದ ನಿಯಮವು ಇದೇ. ಒಬ್ಬ ಹೆಂಡತಿ ತನ್ನ ಗಂಡನನ್ನು ಬಿಟ್ಟು ಜಾರತ್ವ ಮಾಡಿ, ಅಶುದ್ಧಳಾಗಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ಅಥವಾ ಪುರುಷನು ಸಂಶಯಗೊಂಡು ಅವನು ತನ್ನ ಹೆಂಡತಿ ಮೇಲೆ ರೋಷಗೊಂಡಿದ್ದರೆ, ಅವನು ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ನಿಲ್ಲಿಸಲಿ. ಆಗ ಯಾಜಕನು ಅವಳಿಗೆ ಈ ಸಮಸ್ತ ಆಜ್ಞೆಗಳ ಪ್ರಕಾರ ಮಾಡುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ಆಗ ಗಂಡನು ನಿರಪರಾಧಿಯಾಗಿರುವನು. ಆದರೆ ಹೆಂಡತಿಯು ತನ್ನ ಅಕ್ರಮವನ್ನು ಹೊತ್ತುಕೊಳ್ಳುವಳು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ: ‘ಪುರುಷನಾದರೂ, ಸ್ತ್ರೀಯಾದರೂ ಯೆಹೋವ ದೇವರಿಗೆ ಪ್ರತ್ಯೇಕಿಸಿಕೊಳ್ಳುವ ಹಾಗೆ ನಾಜೀರ ವ್ರತ ಕೈಗೊಂಡರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ದ್ರಾಕ್ಷಾರಸಕ್ಕೂ ಮದ್ಯಪಾನಕ್ಕೂ ದೂರವಾಗಿದ್ದು, ದ್ರಾಕ್ಷಾರಸದ ಹುಳಿಯನ್ನೂ ಮದ್ಯಪಾನದ ಹುಳಿಯನ್ನೂ ಕುಡಿಯದೆ, ದ್ರಾಕ್ಷಿಯಿಂದ ಮಾಡಿದ ಯಾವ ಪಾನವನ್ನಾದರೂ ಕುಡಿಯದೆ ಹಸಿಯದಾಗಲಿ, ಒಣಗಿದ್ದಾಗಲಿ ದ್ರಾಕ್ಷಿಹಣ್ಣನ್ನು ತಿನ್ನದೆ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ತಮ್ಮ ನಾಜೀರತನದ ದಿವಸಗಳಲ್ಲೆಲ್ಲಾ ದ್ರಾಕ್ಷಿ ಬೀಜ ಮೊದಲುಗೊಂಡು ಸಿಪ್ಪೆಯವರೆಗೂ, ದ್ರಾಕ್ಷಿಬಳ್ಳಿಯಲ್ಲಿ ಬೆಳೆದದ್ದು ಯಾವುದನ್ನಾದರೂ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘ಅವರ ನಾಜೀರ ವ್ರತದ ದಿನಗಳಲ್ಲೆಲ್ಲಾ ಕ್ಷೌರಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು. ಅವರು ಯೆಹೋವ ದೇವರಿಗೆ ತಮ್ಮನ್ನು ಪ್ರತ್ಯೇಕಿಸಿಕೊಂಡ ದಿವಸಗಳು ಪೂರ್ತಿಯಾಗುವವರೆಗೆ ಅವರು ಪರಿಶುದ್ಧರಾಗಿರುವರು, ಅವರು ತಮ್ಮ ತಲೆಗೂದಲನ್ನು ಕತ್ತರಿಸದೇ ಬೆಳೆಯಬಿಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘ಅವರು ಯೆಹೋವ ದೇವರಿಗೆ ತಮ್ಮನ್ನು ಪ್ರತ್ಯೇಕಿಸಿಕೊಂಡ ದಿವಸಗಳಲ್ಲೆಲ್ಲಾ ಸತ್ತವರ ಬಳಿಗೆ ಬರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ಅವರು ತಂದೆತಾಯಿ, ಸಹೋದರ ಸಹೋದರಿ ಸತ್ತರೂ ಅವರು ಅವರಿಗೋಸ್ಕರ ಅಪವಿತ್ರರಾಗಬಾರದು. ಏಕೆಂದರೆ ದೇವರಿಗೆ ಅವರ ಸಮರ್ಪಣೆಯ ಸಂಕೇತವು ಅವರ ತಲೆಯ ಮೇಲೆ ಇದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ಅವರ ಸಮರ್ಪಣೆಯ ದಿವಸಗಳಲ್ಲೆಲ್ಲಾ ಅವರು ಯೆಹೋವ ದೇವರಿಗೆ ಮೀಸಲಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘ಅವರ ಬಳಿಯಲ್ಲಿ ಯಾರಾದರೂ ಆಕಸ್ಮಿಕವಾಗಿ ಸತ್ತದ್ದರಿಂದ ಅವರ ತಲೆಯ ಕೂದಲು ಅಶುದ್ಧವಾದರೆ, ಅವರು ಶುದ್ಧರಾಗುವ ದಿವಸದಲ್ಲಿ ಅಂದರೆ ಏಳನೆಯ ದಿವಸದಲ್ಲಿ ತಮ್ಮ ತಲೆಯನ್ನು ಬೋಳಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ಎಂಟನೆಯ ದಿವಸದಲ್ಲಿ ಅವರು ಯಾಜಕನ ಬಳಿಗೆ ಸಭೆಯ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನು ಇಲ್ಲವೆ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನು ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ಯಾಜಕನು ಒಂದನ್ನು ದೋಷಪರಿಹಾರಕ ಬಲಿಯಾಗಿಯೂ, ಇನ್ನೊಂದನ್ನು ದಹನಬಲಿಯಾಗಿ ಅರ್ಪಿಸಿ, ಅವರು ಶವದ ಹತ್ತಿರವಿದ್ದು ಪಾಪಮಾಡಿದ್ದರಿಂದ, ಅವರಿಗೋಸ್ಕರ ಆ ದಿವಸದಲ್ಲಿ ಅವರ ತಲೆಯನ್ನು ಪ್ರತಿಷ್ಠಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ಎಷ್ಟು ದಿನಗಳವರೆಗೆ ತಮ್ಮನ್ನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡಿದ್ದಾರೋ, ಅಷ್ಟು ದಿನಗಳವರೆಗೆ ಹೊಸದಾಗಿ ತಮ್ಮನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಳ್ಳಬೇಕು ಮತ್ತು ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಯಾಗಿ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಅವರ ಸಮರ್ಪಣೆಯ ಅವಧಿಯಲ್ಲಿ ಅವರು ಅಶುದ್ಧವಾದುದರಿಂದ ಮೊದಲಿನ ದಿವಸಗಳು ವ್ಯರ್ಥವಾದುವೆಂದು ಪರಿಗಣಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘ಇದು ನಾಜೀರ ವ್ರತವು. ಅವರ ಸಮರ್ಪಣೆಯ ದಿವಸಗಳು ಪೂರ್ಣವಾದ ಮೇಲೆ ಅವರನ್ನು ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ಅವರು ಯೆಹೋವ ದೇವರಿಗೆ ತಮ್ಮ ಅರ್ಪಣೆಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಅದೇನೆಂದರೆ, ದಹನಬಲಿಗಾಗಿ ಒಂದು ವರ್ಷದ ಕಳಂಕವಿಲ್ಲದ ಒಂದು ಟಗರಿನ ಮರಿಯನ್ನೂ, ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಒಂದು ವರ್ಷದ ಕಳಂಕವಿಲ್ಲದ ಒಂದು ಹೆಣ್ಣು ಕುರಿಮರಿಯನ್ನೂ, ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಒಂದು ಕಳಂಕವಿಲ್ಲದ ಟಗರನ್ನೂ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ಮಾಡಿದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳ ಒಂದು ಬುಟ್ಟಿಯನ್ನೂ, ಎಣ್ಣೆ ಹಚ್ಚಿದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ದೋಸೆಗಳನ್ನೂ, ಧಾನ್ಯದ್ರವ್ಯ ಪಾನದ್ರವ್ಯ ಇವುಗಳನ್ನೆಲ್ಲಾ ಅರ್ಪಣೆಯಾಗಿ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘ಇವುಗಳನ್ನು ಯಾಜಕನು ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ತಂದು, ಅವರ ದೋಷಪರಿಹಾರಕ ಬಲಿಯನ್ನೂ ಅವರ ದಹನಬಲಿಯನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ಆ ಟಗರನ್ನು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಬುಟ್ಟಿಯ ಸಂಗಡ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮಾಧಾನದ ಬಲಿಯಾಗಿ ಅರ್ಪಿಸಬೇಕು. ಇದಲ್ಲದೆ ಯಾಜಕನು ಅವರ ಧಾನ್ಯವನ್ನೂ, ಪಾನದ್ರವ್ಯವನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘ಇದಲ್ಲದೆ ನಾಜೀರರು ತಮ್ಮ ಸಮರ್ಪಣೆಯನ್ನು ಸಂಕೇತಿಸುವ ಕೂದಲನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿಯಲ್ಲಿ ಕ್ಷೌರಮಾಡಿಸಿಕೊಂಡು, ಪ್ರತ್ಯೇಕಿಸಿದ ತಮ್ಮ ತಲೆಗೂದಲನ್ನು ತೆಗೆದುಕೊಂಡು, ಸಮಾಧಾನದ ಬಲಿಗಳ ಬಲಿಯ ಕೆಳಗಿರುವ ಬೆಂಕಿಯಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘ಯಾಜಕನು ಬೇಯಿಸಿದ ಆ ಟಗರಿನ ಮುಂದೊಡೆಯನ್ನೂ, ಆ ಪುಟ್ಟಿಯೊಳಗಿಂದ ಹುಳಿಯಿಲ್ಲದ ಒಂದು ರೊಟ್ಟಿಯನ್ನೂ, ಹುಳಿಯಿಲ್ಲದ ಒಂದು ದೋಸೆಯನ್ನೂ, ಆ ನಾಜೀರರ ಪ್ರತ್ಯೇಕಿಸಿದ ಕೂದಲನ್ನು ಕ್ಷೌರಮಾಡಿಸಿದ ತರುವಾಯ ಅವರ ಕೈಗಳಲ್ಲಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ಯಾಜಕನು ಅವುಗಳನ್ನು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸುವ ಅರ್ಪಣೆಗಾಗಿ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಸಮರ್ಪಿಸಬೇಕು. ನೈವೇದ್ಯ ಮಾಡುವ ಎದೆಯ ಸಂಗಡ ಅದು ಯಾಜಕನಿಗೆ ಪರಿಶುದ್ಧವಾಗಿದೆ. ಆಮೇಲೆ ನಾಜೀರರು ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಯಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘ಪ್ರಮಾಣ ಮಾಡಿಕೊಂಡ ನಾಜೀರರ ನಿಯಮವು ಇದೇ. ಸಂಬಂಧಪಟ್ಟದ್ದರೊಂದಿಗೆ ತಮ್ಮ ಕೈಲಾದ ಮಟ್ಟಿಗೆ ಅವರು ತಮ್ಮ ಪ್ರತ್ಯೇಕಿಸುವಿಕೆಗಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆ ಅರ್ಪಿಸತಕ್ಕದ್ದು. ನಾಜೀರ ವ್ರತದ ಕ್ರಮದ ಪ್ರಕಾರ, ನೀವು ಮಾಡಿದ ಪ್ರಮಾಣಕ್ಕನುಸಾರವಾಗಿ ತಮ್ಮ ವ್ರತದ ಕ್ರಮಗಳನ್ನು ನೆರವೇರಿಸಬೇಕು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“ನೀನು ಆರೋನನಿಗೆ ಮತ್ತು ಅವನ ಪುತ್ರರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ನೀವು ಇಸ್ರಾಯೇಲರನ್ನು ಆಶೀರ್ವದಿಸುವಾಗ ಈ ಪ್ರಕಾರ ಅವರಿಗೆ ಹೇಳಬೇಕು: ");
INSERT INTO kanokcv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “ಯೆಹೋವ ದೇವರು ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸಲಿ, ನಿಮ್ಮನ್ನು ಕಾಪಾಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಮುಖವನ್ನು ನಿಮ್ಮ ಕಡೆಗೆ ಪ್ರಕಾಶಿಸುವಂತೆ ಮಾಡಿ, ನಿಮಗೆ ಕೃಪೆ ತೋರಿಸಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಮುಖವನ್ನು ನಿಮ್ಮ ಕಡೆಗೆ ಎತ್ತಿ, ನಿಮಗೆ ಸಮಾಧಾನ ಅನುಗ್ರಹಿಸಲಿ.” ’ ");
INSERT INTO kanokcv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“ಹೀಗೆ ಅವರು ನನ್ನ ಹೆಸರನ್ನು ಇಸ್ರಾಯೇಲರ ಮೇಲೆ ಉಚ್ಛರಿಸುವರು. ನಾನೇ ಅವರನ್ನು ಆಶೀರ್ವದಿಸುವೆನು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ಮೋಶೆಯು ದೇವದರ್ಶನ ಗುಡಾರವನ್ನು ನಿಲ್ಲಿಸಿ, ಅಭಿಷೇಕಿಸಿ ಪರಿಶುದ್ಧ ಮಾಡಿದ ದಿನದಲ್ಲಿ ಅದರ ಎಲ್ಲಾ ಸಲಕರಣೆಗಳನ್ನೂ, ಬಲಿಪೀಠವನ್ನೂ, ಅದರ ಎಲ್ಲಾ ಸಾಮಗ್ರಿಗಳನ್ನೂ ಅಭಿಷೇಕಿಸಿ ಪರಿಶುದ್ಧ ಮಾಡಿದನು. ಅನಂತರ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ಇಸ್ರಾಯೇಲರ ಪ್ರಧಾನರು ಎಂದರೆ ಗೋತ್ರದ ಪ್ರಮುಖರು, ಕುಲಾಧಿಪತಿಗಳು ಜನಗಣತಿಯ ನೇತೃತ್ವವನ್ನು ವಹಿಸಿಕೊಂಡಿದ್ದವರು ಕಾಣಿಕೆಗಳನ್ನು ತಂದು ಸಮರ್ಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ಅವರು ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ತಂದ ಅರ್ಪಣೆ ಏನೆಂದರೆ ಆರು ಕಮಾನುಬಂಡಿಗಳು, ಹನ್ನೆರಡು ಎತ್ತುಗಳು, ಪ್ರಧಾನರಲ್ಲಿ ಇಬ್ಬರಿಗೆ ಒಂದು ಬಂಡಿಯಂತೆ, ಒಬ್ಬೊಬ್ಬನಿಗೆ ಒಂದೊಂದು ಎತ್ತುಗಳನ್ನು ಅವರು ದೇವದರ್ಶನ ಗುಡಾರದ ಮುಂದೆ ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ಯೆಹೋವ ದೇವರು ಮಾತನಾಡಿ ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ಅವುಗಳನ್ನು ಅವರಿಂದ ತೆಗೆದುಕೋ, ಅವು ದೇವದರ್ಶನ ಗುಡಾರದ ಸೇವೆಮಾಡುವುದಕ್ಕೋಸ್ಕರ ಇರಬೇಕು. ಅವುಗಳನ್ನು ಲೇವಿಯರಿಗೆ ಅವನವನ ಕೆಲಸಕ್ಕೆ ತಕ್ಕಂತೆ ಕೊಡಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ಆಗ ಮೋಶೆಯು ಆ ಬಂಡಿಗಳನ್ನೂ, ಎತ್ತುಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ಲೇವಿಯರಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ಎರಡು ಬಂಡಿಗಳನ್ನೂ, ನಾಲ್ಕು ಎತ್ತುಗಳನ್ನೂ, ಗೇರ್ಷೋನನ ಪುತ್ರರಿಗೆ ಅವರ ಕೆಲಸಕ್ಕೆ ತಕ್ಕ ಪ್ರಕಾರ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ಯಾಜಕನಾದ ಆರೋನನ ಮಗ ಈತಾಮಾರನ ಕೈಕೆಳಗಿರುವ ನಾಲ್ಕು ಬಂಡಿಗಳನ್ನೂ, ಎಂಟು ಎತ್ತುಗಳನ್ನೂ ಮೆರಾರೀಯ ಪುತ್ರರಿಗೆ ಅವರ ಕೆಲಸಕ್ಕೆ ತಕ್ಕಂತೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ಆದರೆ ಕೊಹಾತ್ಯರಿಗೆ ಯಾವುದನ್ನೂ ಕೊಡಲಿಲ್ಲ. ಏಕೆಂದರೆ ಅವರು ತಮ್ಮ ಹೆಗಲುಗಳ ಮೇಲೆ ಪರಿಶುದ್ಧಸ್ಥಳದ ವಸ್ತುಗಳನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗುವುದೇ ಅವರಿಗೆ ಸೇವೆಯಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ಬಲಿಪೀಠವನ್ನು ಅಭಿಷೇಕಿಸಿದ ದಿನದಂದು ಪ್ರತಿಷ್ಠೆಗಾಗಿ ಅದರ ಮುಂದೆ ಬಂದು, ಪ್ರಧಾನರು ತಮ್ಮ ಕಾಣಿಕೆಗಳನ್ನು ಅರ್ಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ಒಬ್ಬೊಬ್ಬ ಪ್ರಧಾನನು ತನ್ನ ತನ್ನ ದಿವಸದಲ್ಲಿ ಬಲಿಪೀಠದ ಪ್ರತಿಷ್ಠೆಗಾಗಿ ತಮ್ಮ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ಮೊದಲನೆಯ ದಿವಸದಲ್ಲಿ ತನ್ನ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸಿದವನು ಯೆಹೂದ ಗೋತ್ರದ ಅಮ್ಮೀನಾದಾಬನ ಮಗ ನಹಶೋನನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ಅವನ ಅರ್ಪಣೆ ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಚೊಕ್ಕ ಬೆಳ್ಳಿಯ ಒಂದು ತಟ್ಟೆ ಮತ್ತು 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಇವೆರಡು ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ 10 ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಒಂದು ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರುಷದ ಐದು ಕುರಿಮರಿಗಳೂ ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ಇದು ಅಮ್ಮೀನಾದಾಬನ ಮಗ ನಹಶೋನನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ಎರಡನೆಯ ದಿವಸದಲ್ಲಿ ಇಸ್ಸಾಕಾರನ ಗೋತ್ರದ ಪ್ರಧಾನನಾಗಿರುವ ಚೂವಾರನ ಮಗ ನೆತನೆಯೇಲ್ ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ಅವನ ಅರ್ಪಣೆ ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳಿಯ್ಳ ತಟ್ಟೆ, 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ಸಮಾಧಾನದ ಬಲಿಗಳ ಬಲಿಗಾಗಿ ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಚೂವಾರನ ಮಗ ನೆತನೆಯೇಲ್ ಇವನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ಮೂರನೆಯ ದಿವಸದಲ್ಲಿ ಜೆಬುಲೂನ್ ಮಕ್ಕಳಿಗೆ ಪ್ರಧಾನನಾಗಿರುವ ಹೇಲೋನನ ಮಗ ಎಲೀಯಾಬನು ಅರ್ಪಿಸಿದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ಅವನ ಅರ್ಪಣೆ ಏನೆಂದರೆ: ದೇವರ ಸೇವೆಗೆ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ತಟ್ಟೆ, 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ 10 ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ಮತ್ತು ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಹೇಲೋನನ ಮಗ ಎಲೀಯಾಬನ ಸಮರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ನಾಲ್ಕನೆಯ ದಿನದಲ್ಲಿ ರೂಬೇನನ ಮಕ್ಕಳಿಗೆ ಪ್ರಧಾನನಾಗಿರುವ ಶೆದೇಯೂರನ ಮಗ ಎಲೀಚೂರನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ಅವನ ಅರ್ಪಣೆಯು ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆ, 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಎರಡು ಹೋರಿಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಶೆದೇಯೂರನ ಮಗ ಎಲೀಚೂರನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ಐದನೆಯ ದಿನದಲ್ಲಿ ಸಿಮೆಯೋನನ ಗೋತ್ರದ ಪ್ರಧಾನನಾಗಿರುವ ಚುರೀಷದ್ದೈಯನ ಮಗ ಶೆಲುಮೀಯೇಲನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ಅವನ ಅರ್ಪಣೆಯು ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳಿಯ್ಳ ತಟ್ಟೆ, 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ಪಾಪ ಪರಿಹಾರದ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಎರಡು ಹೋರಿಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಚುರೀಷದ್ದೈಯನ ಮಗ ಶೆಲುಮೀಯೇಲನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ಆರನೆಯ ದಿನದಲ್ಲಿ ಗಾದನ ಗೋತ್ರದ ಪ್ರಧಾನನಾಗಿರುವ ದೆವುಯೇಲನ ಮಗ ಎಲ್ಯಾಸಾಫನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ಅವನ ಅರ್ಪಣೆಯು ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ತಟ್ಟೆ, 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರುಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ದೆವುಯೇಲನ ಮಗ ಎಲ್ಯಾಸಾಫನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಎಫ್ರಾಯೀಮ್ ಗೋತ್ರದ ಪ್ರಧಾನನಾದ ಅಮ್ಮೀಹೂದನ ಮಗ ಎಲೀಷಾಮನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ಅವನ ಅರ್ಪಣೆ ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ತಟ್ಟೆ, ಪರಿಶುದ್ಧಸ್ಥಳದ ಪ್ರಕಾರ 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ 10 ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಒಂದು ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಅಮ್ಮೀಹೂದನ ಮಗ ಎಲೀಷಾಮನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಮನಸ್ಸೆ ಗೋತ್ರದ ಪ್ರಧಾನನಾದ ಪೆದಾಚೂರನ ಮಗ ಗಮಲಿಯೇಲನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ಅವನ ಅರ್ಪಣೆಯು ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ತಟ್ಟೆ, 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ 10 ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಒಂದು ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರುಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಪೆದಾಚೂರನ ಮಗ ಗಮಲಿಯೇಲನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ಒಂಬತ್ತನೆಯ ದಿನದಲ್ಲಿ ಬೆನ್ಯಾಮೀನನ ಗೋತ್ರದ ಪ್ರಧಾನನಾದ ಗಿದ್ಯೋನಿಯ ಮಗ ಅಬೀದಾನನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ಅವನ ಅರ್ಪಣೆಯು ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ತಟ್ಟೆ, 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ 10 ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಒಂದು ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರುಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಗಿದ್ಯೋನಿಯ ಮಗ ಅಬೀದಾನನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ದಾನನ ಗೋತ್ರದ ಪ್ರಧಾನವಾದ ಅಮ್ಮೀಷದ್ದೈಯನ ಮಗ ಅಹೀಗೆಜೆರನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ಅವನ ಅರ್ಪಣೆಯು ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ತಟ್ಟೆ, 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ 10 ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರುಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಅಮ್ಮೀಷದ್ದೈಯನ ಮಗ ಅಹೀಗೆಜೆರನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ಹನ್ನೊಂದನೆಯ ದಿನದಲ್ಲಿ ಆಶೇರನ ಗೋತ್ರದ ಪ್ರಧಾನನಾದ ಒಕ್ರಾನನ ಮಗ ಪಗೀಯೇಲನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ಅವನ ಅರ್ಪಣೆಯು ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ತಟ್ಟೆ, ಪರಿಶುದ್ಧಸ್ಥಳದ ಪ್ರಕಾರ 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ 10 ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿ ಒಂದು ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಒಕ್ರಾನನ ಮಗ ಪಗೀಯೇಲನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ಹನ್ನೆರಡನೆಯ ದಿನದಲ್ಲಿ ನಫ್ತಾಲಿಯ ಗೋತ್ರದ ಪ್ರಧಾನನಾದ ಏನಾನನ ಮಗ ಅಹೀರನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ಅವನ ಅರ್ಪಣೆಯು ಏನೆಂದರೆ: ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದ ತೂಕ ನೇಮಕವಾದ ಪ್ರಕಾರ, 130 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ತಟ್ಟೆ, 70 ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು, ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಈ ಎರಡೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟಿನಿಂದ ತುಂಬಿದ್ದವು, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ಧೂಪದಿಂದ ತುಂಬಿದ್ದ 10 ಶೆಕೆಲ್ ತೂಕದ ಬಂಗಾರದ ಒಂದು ಚಮಚ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಕುರಿಮರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ಸಮಾಧಾನದ ಸಮರ್ಪಣೆಯ ಎರಡು ಎತ್ತುಗಳೂ, ಐದು ಟಗರುಗಳೂ, ಐದು ಹೋತಗಳೂ, ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಮರಿಗಳು. ಇದು ಏನಾನನ ಮಗ ಅಹೀರನ ಅರ್ಪಣೆಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ಇದು ಬಲಿಪೀಠದ ಪ್ರತಿಷ್ಠೆಗಾಗಿ ಅದನ್ನು ಅಭಿಷೇಕ ಮಾಡಿದ ದಿನದಲ್ಲಿ ಇಸ್ರಾಯೇಲಿನ ಪ್ರಧಾನರು ಅರ್ಪಿಸಿದ್ದು: ಬೆಳ್ಳಿಯ 12 ತಟ್ಟೆಗಳೂ, ಬೆಳ್ಳಿಯ 12 ಬಟ್ಟಲುಗಳೂ, ಬಂಗಾರದ 12 ಚಮಚಗಳೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ಬೆಳ್ಳಿಯ ಒಂದೊಂದು ತಟ್ಟೆಗಳ ತೂಕವು 130 ಶೆಕೆಲ್, ಒಂದೊಂದು ಬಟ್ಟಲಿನ ತೂಕವು 70 ಶೆಕೆಲ್. ಬೆಳ್ಳಿಯ ಎಲ್ಲಾ ಸಾಮಗ್ರಿಗಳ ತೂಕ ಪರಿಶುದ್ಧಸ್ಥಳದ ನೇಮದ ಪ್ರಕಾರ 2,400 ಶೆಕೆಲ್. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ಧೂಪ ತುಂಬಿದ್ದ 12 ಬಂಗಾರದ ಚಮಚಗಳು, ಪರಿಶುದ್ಧಸ್ಥಳದ ಪ್ರಕಾರ ಒಂದೊಂದಕ್ಕೆ 10 ಚಮಚಗಳ ಬಂಗಾರವೆಲ್ಲಾ 120 ಶೆಕೆಲ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ದಹನಬಲಿಗಾಗಿ ಇರುವ ಒಟ್ಟು ಪಶುಗಳು: 12 ಹೋರಿಗಳು, 12 ಟಗರುಗಳು, ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಗಳು 12, ಅವುಗಳೊಂದಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆ. ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ 12 ಹೋತಗಳು, ");
INSERT INTO kanokcv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ಸಮಾಧಾನದ ಬಲಿಗಾಗಿರುವ ಒಟ್ಟು ಪಶುಗಳು: 24 ಹೋರಿಗಳು, 60 ಟಗರುಗಳು, 60 ಹೋತಗಳು, ಒಂದು ವರ್ಷದ ಗಂಡು ಕುರಿಮರಿಗಳು 60. ಅದನ್ನು ಅಭಿಷೇಕಿಸಿದ ತರುವಾಯ ಬಲಿಪೀಠಕ್ಕೆ ಮಾಡಿದ ಪ್ರತಿಷ್ಠೆ ಇದಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಪ್ರವೇಶಿಸಿದಾಗ, ಅವನು ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಮೇಲೆ ಇರುವ ಕರುಣಾಸನದ ಮೇಲಿನಿಂದ ಎರಡು ಕೆರೂಬಿಗಳ ಮಧ್ಯದಿಂದ ತನ್ನ ಸಂಗಡ ಮಾತನಾಡುವ ಧ್ವನಿಯನ್ನು ಮೋಶೆಯು ಕೇಳಿದನು. ಹೀಗೆ ದೇವರು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ: ");
INSERT INTO kanokcv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“ಆರೋನನ ಸಂಗಡ ಮಾತನಾಡಿ ಅವನಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು, ‘ನೀನು ದೀಪಗಳನ್ನು ಹಚ್ಚುವಾಗ ಆ ಏಳು ದೀಪಗಳೂ ದೀಪಸ್ತಂಭದ ಎದುರಿಗಿರುವ ಸ್ಥಳಕ್ಕೆ ಪ್ರಕಾಶಕೊಡುವಂತೆ ನೋಡಿಕೊಳ್ಳಬೇಕು’ ಎಂದು ಹೇಳಿದರು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ಆರೋನನು ಹಾಗೆಯೇ ಮಾಡಿ, ದೀಪಸ್ತಂಭದ ಎದುರಿನ ಪ್ರದೇಶಕ್ಕೆ ಬೆಳಕುಕೊಡುವಂತೆ ಅದರ ದೀಪಗಳನ್ನು ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಹಚ್ಚಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ದೀಪಸ್ತಂಭವೂ ಅದರ ಬುಡಭಾಗವೂ, ಪುಷ್ಪಾಲಂಕಾರಗಳೂ ಬಂಗಾರದ ನಕಾಸಿ ಕೆಲಸದಿಂದ ಹೊಡೆದು ಮಾಡಲಾಗಿತ್ತು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ತೋರಿಸಿದ ಮಾದರಿಯ ಪ್ರಕಾರವೇ ಅವನು ಅದನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ಲೇವಿಯರನ್ನು ಇಸ್ರಾಯೇಲರೊಳಗಿಂದ ತೆಗೆದುಕೊಂಡು ಅವರನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ ಶುದ್ಧಮಾಡು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ಅವರನ್ನು ಶುದ್ಧಮಾಡುವುದಕ್ಕೆ ಅವರಿಗೆ ಮಾಡಬೇಕಾದದ್ದೇನೆಂದರೆ ಶುದ್ಧೀಮಾಡುವ ನೀರನ್ನು ಅವರ ಮೇಲೆ ಚಿಮುಕಿಸು. ಅವರು ಸರ್ವಾಂಗ ಕ್ಷೌರ ಮಾಡಿಸಿಕೊಳ್ಳಲಿ. ಅವರು ತಮ್ಮ ವಸ್ತ್ರಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಲಿ. ಹೀಗೆ ಅವರು ತಮ್ಮನ್ನು ತಾವೇ ಶುದ್ಧ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ಅವರು ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿಯನ್ನು, ಅದರೊಂದಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಬೆರೆಸಿದ ನಯವಾದ ಹಿಟ್ಟನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಮತ್ತೊಂದು ಹೋರಿಯನ್ನೂ ನೀನು ತೆಗೆದುಕೋ. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ಆಗ ನೀನು ಲೇವಿಯರನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮುಂದೆ ಕರೆತಂದು, ಇಸ್ರಾಯೇಲರ ಸಮೂಹವನ್ನೆಲ್ಲಾ ಒಟ್ಟುಗೂಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ನೀನು ಲೇವಿಯರನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಕರೆತಂದಾಗ, ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಕೈಗಳನ್ನು ಲೇವಿಯರ ಮೇಲೆ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ಲೇವಿಯರು ಇಸ್ರಾಯೇಲರ ಪರವಾಗಿ ಯೆಹೋವ ದೇವರ ಸೇವೆಯನ್ನು ಮಾಡುವುದಕ್ಕೆ ಸಿದ್ಧರಾಗುವಂತೆ ಆರೋನನು ಅವರನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯದಂತೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“ಲೇವಿಯರು ತಮ್ಮ ಕೈಗಳನ್ನು ಆ ಹೋರಿಗಳ ತಲೆಗಳ ಮೇಲೆ ಇಡಬೇಕು. ಆಗ ನೀನು ಲೇವಿಯರಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಒಂದು ಹೋರಿಯನ್ನು ದೋಷಪರಿಹಾರಕ ಬಲಿಗಾಗಿಯೂ ಮತ್ತೊಂದು ಹೋರಿಯನ್ನು ದಹನಬಲಿಗಾಗಿಯೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ತರುವಾಯ ನೀನು ಲೇವಿಯರನ್ನು ಆರೋನನ ಮುಂದೆಯೂ ಅವನ ಪುತ್ರರ ಮುಂದೆಯೂ ನಿಲ್ಲಿಸಿ, ಅವರನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ನೈವೇದ್ಯದಂತೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ಹೀಗೆ ನೀನು ಲೇವಿಯರನ್ನು ಇಸ್ರಾಯೇಲರೊಳಗಿಂದ ಪ್ರತ್ಯೇಕಿಸಬೇಕು, ಆಗ ಲೇವಿಯರು ನನ್ನವರಾಗುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“ಅದರ ತರುವಾಯ ಲೇವಿಯರು ಸೇವೆ ಮಾಡವುದಕ್ಕೆ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಪ್ರವೇಶಿಸುವರು. ಆಗ ನೀನು ಅವರನ್ನು ಶುದ್ಧೀಮಾಡಿ, ನೈವೇದ್ಯದಂತೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ಏಕೆಂದರೆ ಅವರು ಇಸ್ರಾಯೇಲರಲ್ಲಿ ನನಗೆ ಸಂಪೂರ್ಣವಾಗಿ ಸಮರ್ಪಿತರಾದವರು. ಚೊಚ್ಚಲು ಮಕ್ಕಳಿಗೆ ಬದಲಾಗಿ, ಅಂದರೆ ಇಸ್ರಾಯೇಲರ ಜೇಷ್ಠಪುತ್ರರಿಗೆ ಬದಲಾಗಿ ನಾನು ಅವರನ್ನೇ ನನಗೋಸ್ಕರ ತೆಗೆದುಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ಏಕೆಂದರೆ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಮನುಷ್ಯರಾದರೂ ಪಶುಗಳಾದರೂ ಜೇಷ್ಠರಾದದ್ದೆಲ್ಲಾ ನನ್ನದೇ. ನಾನು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಚೊಚ್ಚಲಾದದ್ದನ್ನೆಲ್ಲಾ ನಾನು ಸಂಹರಿಸಿದಾಗ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಚೊಚ್ಚಲಾದದ್ದನ್ನು ನನ್ನ ಸ್ವಂತಕ್ಕಾಗಿ ಪ್ರತ್ಯೇಕಿಸಿಕೊಂಡೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ಇಸ್ರಾಯೇಲರಲ್ಲಿರುವ ಎಲ್ಲಾ ಜೇಷ್ಠಪುತ್ರರಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರನ್ನು ನಾನು ತೆಗೆದುಕೊಂಡೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಸೇವೆಯನ್ನು ಮಾಡುವುದಕ್ಕೂ ಇಸ್ರಾಯೇಲರಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕೂ ಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೆ ಇಸ್ರಾಯೇಲರು ಸಮೀಪಿಸುವಾಗ ಇಸ್ರಾಯೇಲರೊಳಗೆ ವ್ಯಾಧಿಯು ಇರದಂತೆ ನಾನು ಲೇವಿಯರನ್ನು ಇಸ್ರಾಯೇಲರೊಳಗಿಂದ ಆರೋನನಿಗೂ, ಅವನ ಪುತ್ರರಿಗೂ ದಾನವಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ.” ");
INSERT INTO kanokcv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಲೇವಿಯರ ವಿಷಯದಲ್ಲಿ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆಯೂ ಆರೋನನೂ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರೆಲ್ಲರೂ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ಲೇವಿಯರು ತಮ್ಮನ್ನು ಶುದ್ಧಿಮಾಡಿಕೊಂಡು, ತಮ್ಮ ವಸ್ತ್ರಗಳನ್ನು ತೊಳೆದುಕೊಂಡರು. ಆರೋನನು ಅವರನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ನೈವೇದ್ಯದಂತೆ ಅರ್ಪಿಸಿದನು. ಅವರು ಶುದ್ಧರಾಗುವ ಹಾಗೆ ಆರೋನನು ಅವರಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ತರುವಾಯ ಲೇವಿಯರು ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಆರೋನನ ಮುಂದೆಯೂ, ಅವನ ಪುತ್ರರ ಮುಂದೆಯೂ ಅವರ ಸೇವೆ ಮಾಡುವುದಕ್ಕೆ ಒಳಗೆ ಪ್ರವೇಶಿಸಿದರು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಲೇವಿಯರ ವಿಷಯವಾಗಿ ಹೇಗೆ ಆಜ್ಞಾಪಿಸಿದರೋ, ಹಾಗೆಯೇ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ಲೇವಿಯರಿಗೆ ಸಂಬಂಧಪಟ್ಟದ್ದು ಇದಾಗಿದೆ: ಇಪ್ಪತ್ತೈದು ವರ್ಷವೂ, ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳವರೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆಗಾಗಿ ಒಳಗೆ ಸೇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ಆದರೆ ಐವತ್ತು ವರ್ಷದವರಾದ ನಂತರ ಸೇವೆಯನ್ನು ಬಿಟ್ಟು ನಿವೃತ್ತರಾಗಬೇಕು ಮತ್ತು ತದನಂತರ ಕೆಲಸಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ಆದರೆ ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಅಪ್ಪಣೆಯನ್ನು ಕೈಗೊಂಡು ತಮ್ಮ ಸಹೋದರರೊಂದಿಗೆ ಕೆಲಸಮಾಡಲಿ, ಆದರೆ ಅವರು ಸೇವೆಯನ್ನು ತಾವಾಗಿ ಮಾಡಬಾರದು. ಈ ಪ್ರಕಾರ ನೀನು ಲೇವಿಯರಿಗೆ ಕರ್ತವ್ಯಗಳನ್ನು ಆಜ್ಞಾಪಿಸಬೇಕು,” ಎಂಬುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ಇಸ್ರಾಯೇಲರು ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಹೊರಟ ಎರಡನೆಯ ವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳಿನಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೀಗೆ ಹೇಳಿದರು: ");
INSERT INTO kanokcv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ಇಸ್ರಾಯೇಲರು ಪಸ್ಕವನ್ನು ನೇಮಿಸಿದ ಸಮಯದಲ್ಲಿ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ಈ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿವಸದ ಸಂಜೆಯಲ್ಲಿ ಅದನ್ನು ಆಚರಿಸಬೇಕು. ಅದರ ಆಜ್ಞಾವಿಧಿಗಳ ಪ್ರಕಾರವಾಗಿಯೂ, ಅದರ ಎಲ್ಲಾ ನಿಯಮಗಳ ಪ್ರಕಾರವಾಗಿಯೂ ಅದನ್ನು ಆಚರಿಸಿರಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ಆಗ ಮೋಶೆಯು ಪಸ್ಕವನ್ನು ಆಚರಿಸುವುದಕ್ಕೆ ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ಅವರು ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿವಸದ ಸಂಜೆ ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಪಸ್ಕವನ್ನು ಆಚರಿಸಿದರು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೆಲ್ಲದರ ಪ್ರಕಾರ, ಇಸ್ರಾಯೇಲರು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ಆದರೆ ಕೆಲವು ಜನರು ಮನುಷ್ಯನ ಶವವನ್ನು ಮುಟ್ಟಿದ್ದರಿಂದ ಅಶುದ್ಧರಾಗಿ ಆ ದಿವಸದಲ್ಲಿ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಲಾಗಲಿಲ್ಲ ಅದಕ್ಕೆ ಅದೇ ದಿನ ಅವರು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಬಳಿಗೆ ಬಂದು ");
INSERT INTO kanokcv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ನಾವು ಮನುಷ್ಯನ ಶವದ ಸೋಂಕಿನಿಂದ ಅಶುದ್ಧರಾಗಿದ್ದೇವೆ. ಆದ್ದರಿಂದ ನಾವು ಇಸ್ರಾಯೇಲರೊಡನೆ ನೇಮಕವಾದ ಸಮಯದಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಬಲಿಯನ್ನು ಅರ್ಪಿಸಲು ನಮಗೆ ಏಕೆ ಅಡ್ಡಿಯಾಗಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ಮೋಶೆ ಅವರಿಗೆ, “ಸ್ವಲ್ಪ ಕಾಯಿರಿ, ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ವಿಷಯದಲ್ಲಿ ಏನು ಆಜ್ಞಾಪಿಸುತ್ತಾರೋ ನಾನು ಕೇಳುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಸಂಗಡ ಮಾತನಾಡಿ ಅವನಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ, “ನಿಮ್ಮಲ್ಲಿಯೂ, ನಿಮ್ಮ ಸಂತತಿಯಲ್ಲಿಯೂ ಯಾವನಾದರೂ ಶವದ ಸೋಂಕಿನಿಂದ ಅಶುದ್ಧನಾಗಿದ್ದರೂ, ಇಲ್ಲವೆ ದೂರ ಪ್ರಯಾಣದಲ್ಲಿದ್ದರೂ ಯೆಹೋವ ದೇವರಿಗೆ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ಆದರೆ ಅಂಥವರು ಎರಡನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿವಸದ ಸಂಜೆಯಲ್ಲಿ ಆಚರಿಸಲಿ. ಆ ಕುರಿಯನ್ನು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳ ಸಂಗಡ ಕಹಿಯಾದ ಸೊಪ್ಪುಗಳೊಂದಿಗೆ ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ಅವರು ಅದರಿಂದ ಮರುದಿವಸಕ್ಕೆ ಏನನ್ನೂ ಉಳಿಸಬಾರದು. ಅದರಲ್ಲಿ ಎಲುಬುಗಳಲ್ಲಿ ಒಂದನ್ನಾದರೂ ಮುರಿಯಬಾರದು, ಪಸ್ಕದ ಸಮಸ್ತ ಕಟ್ಟಳೆಗಳ ಪ್ರಕಾರವಾಗಿ ಅದನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ಆದರೆ ಒಬ್ಬ ಮನುಷ್ಯನೂ ಆಚಾರವಾಗಿ ಶುದ್ಧನಾದವನು, ಪ್ರಯಾಣ ಮಾಡದವನಾಗಿದ್ದು ಪಸ್ಕವನ್ನು ಆಚರಿಸಲು ತಪ್ಪಿದರೆ, ಅವನನ್ನು ಅವನ ಜನರೊಳಗಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ಅವನು ಯೆಹೋವ ದೇವರ ಅರ್ಪಣೆಯನ್ನು ಅದರ ಸಮಯದಲ್ಲಿ ತರದಿದ್ದ ಕಾರಣ ಆ ಮನುಷ್ಯನು ತನ್ನ ಪಾಪವನ್ನು ಹೊತ್ತುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ಪರದೇಶಿಯಾದವನು ನಿಮ್ಮ ಸಂಗಡ ಇದ್ದು, ಯೆಹೋವ ದೇವರಿಗೆ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕೆಂದು ಬಯಸಿದರೆ, ಅದರ ಆಜ್ಞಾವಿಧಿಗಳ ಪ್ರಕಾರವೇ ಆಚರಿಸಲಿ. ಸ್ಥಳೀಯ ಮೂಲದ ಇಸ್ರಾಯೇಲರಿಗೂ ಮತ್ತು ನಿಮ್ಮ ನಡುವೆ ವಾಸಿಸುವ ಪರದೇಶಸ್ತನಿಗೂ ಒಂದೇ ನಿಯಮ ಇರಬೇಕು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಎತ್ತಿ ನಿಲ್ಲಿಸಿದ ದಿವಸದಲ್ಲಿ ಮೇಘವು ಸಾಕ್ಷಿ ಗುಡಾರವನ್ನು ಮುಚ್ಚಿತು. ಸಂಜೆಯಿಂದ ಮುಂಜಾನೆಯವರೆಗೆ ಅದು ಬೆಂಕಿಯಂತೆ ಗುಡಾರದ ಮೇಲೆ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ಈ ಪ್ರಕಾರ ಯಾವಾಗಲೂ, ಮೇಘವು ರಾತ್ರಿಯಲ್ಲಿ ಬೆಂಕಿಯಂತೆ ಅದನ್ನು ಮುಚ್ಚುತ್ತಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ಆ ಮೇಘವು ಗುಡಾರದ ಮೇಲಿನಿಂದ ಹೋದಾಗ, ಇಸ್ರಾಯೇಲರು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದರು, ಮೇಘವು ನೆಲಸಿದ ಸ್ಥಳದಲ್ಲಿ ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಗುಡಾರಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಇಸ್ರಾಯೇಲರು ಪ್ರಯಾಣಮಾಡಿದರು. ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಗುಡಾರಗಳನ್ನು ಹಾಕಿದರು. ಮೇಘವು ಗುಡಾರದ ಮೇಲೆ ನೆಲಸಿರುವ ಕಾಲವೆಲ್ಲಾ ಅವರು ತಮ್ಮ ಗುಡಾರಗಳಲ್ಲಿ ವಾಸಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ಮೇಘವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮೇಲೆ ಅನೇಕ ದಿವಸಗಳು ತಡಮಾಡಿದಾಗ, ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರ ಅಪ್ಪಣೆಯನ್ನು ಅನುಸರಿಸಿ ಪ್ರಯಾಣ ಮಾಡದೆ ಇರುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ಇದಲ್ಲದೆ ಮೇಘವು ಗುಡಾರದ ಮೇಲೆ ಸ್ವಲ್ಪ ದಿವಸಗಳು ಇರುವಾಗ, ಅವರು ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಇಳಿದುಕೊಳ್ಳುತ್ತಿದ್ದರು. ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ಮೇಘವು ಸಂಜೆಯಿಂದ ಮುಂಜಾನೆಯವರೆಗೆ ಇದ್ದು, ಬೆಳಿಗ್ಗೆ ಮೇಲಕ್ಕೆ ಎದ್ದಾಗ, ಅವರು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದರು, ಹಗಲುರಾತ್ರಿ ಇದ್ದು ಮೇಘವು ಮೇಲಕ್ಕೇರಿದಾಗ ಅವರು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ಆ ಮೇಘವು ಎರಡು ದಿವಸಗಳಾದರೂ, ಒಂದು ತಿಂಗಳಾದರೂ, ಒಂದು ವರ್ಷವಾದರೂ ಗುಡಾರದ ಮೇಲೆ ನೆಲೆಸಿ ತಡಮಾಡಿದರೆ ಇಸ್ರಾಯೇಲರು ಪ್ರಯಾಣ ಮಾಡದೆ ಅಲ್ಲೇ ಇಳಿದುಕೊಳ್ಳುತ್ತಿದ್ದರು. ಅದು ಮೇಲೆ ಎದ್ದಾಗ ಮಾತ್ರ ಅವರು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಅವರು ಇಳಿದುಕೊಳ್ಳುತ್ತಾ, ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಪ್ರಯಾಣ ಮಾಡುತ್ತಾ ಇದ್ದರು. ಮೋಶೆಗೆ ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಯೆಹೋವ ದೇವರ ಅಪ್ಪಣೆಯನ್ನು ಕೈಗೊಳ್ಳುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಅವನಿಗೆ ಹೇಳಿದ್ದು: ");
INSERT INTO kanokcv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“ನಕ್ಷೆಯ ಕೆಲಸದಿಂದ ಹೊಡೆದು ಮಾಡಿದ ಬೆಳ್ಳಿಯ ತಗಡಿನ ಎರಡು ತುತೂರಿಗಳನ್ನು ನೀನು ಮಾಡಿಸಬೇಕು. ಸಭೆಯನ್ನು ಕರೆಯುವುದಕ್ಕಾಗಿಯೂ, ಪಾಳೆಯಗಳ ಪ್ರಯಾಣಕ್ಕಾಗಿಯೂ ನೀನು ಅವುಗಳನ್ನು ಉಪಯೋಗಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ಅವುಗಳನ್ನು ಊದುವಾಗ ಜನರೆಲ್ಲರೂ ನಿನ್ನ ಹತ್ತಿರ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಕೂಡಿಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ಒಂದನ್ನು ಮಾತ್ರ ಊದುವಾಗ, ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಮುಖ್ಯಸ್ಥರಾದ ಪ್ರಧಾನರು ನಿನ್ನ ಬಳಿಗೆ ಕೂಡಿಬರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ನೀವು ಜಯಧ್ವನಿಯಂತೆ ಊದುವಾಗ ಪೂರ್ವದಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವ ಪಾಳೆಯಗಳು ಮುಂದೆ ಹೊರಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ನೀವು ಎರಡನೆಯ ಸಾರಿ ಆರ್ಭಟವಾಗಿ ಊದುವಾಗ, ದಕ್ಷಿಣದಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವ ಪಾಳೆಯಗಳು ಪ್ರಯಾಣ ಮಾಡಬೇಕು. ಅವರ ಪ್ರಯಾಣಕ್ಕೆ ಹೊರಡಬೇಕಾದಾಗ ಆರ್ಭಟವಾಗಿ ಊದಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ಆದರೆ ಸಭೆಯನ್ನು ಕೂಡಿಸುವಾಗ ನೀವು ಸಾಧಾರಣವಾಗಿ ಊದಿಸಬೇಕೇ ಹೊರತು ಆರ್ಭಟವಾಗಿ ಊದಿಸಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“ಯಾಜಕರಾಗಿರುವ ಆರೋನನ ಪುತ್ರರು ತುತೂರಿಗಳನ್ನು ಊದಬೇಕು. ಇವು ನಿಮ್ಮ ಸಂತತಿಗಳಲ್ಲಿ ನಿಮಗೆ ನಿತ್ಯವಾದ ಕಟ್ಟಳೆಯಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ನಿಮ್ಮನ್ನು ಉಪದ್ರವಪಡಿಸುವ ವೈರಿಗೆ ವಿರೋಧವಾಗಿ ಯುದ್ಧಕ್ಕೆ ಹೊರಡುವಾಗ ಜನರನ್ನು ಎಚ್ಚರಿಸುವಂತೆ ತುತೂರಿಗಳನ್ನು ಆರ್ಭಟವಾಗಿ ಊದಬೇಕು. ಆಗ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮನ್ನು ನೆನಪು ಮಾಡಿಕೊಂಡು ಶತ್ರುಗಳಿಂದ ನಿಮ್ಮನ್ನು ಬಿಡಿಸುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ನಿಮ್ಮ ಸಂತೋಷದ ದಿವಸದಲ್ಲಿಯೂ, ನಿಮ್ಮ ಹಬ್ಬಗಳಲ್ಲಿಯೂ ನಿಮ್ಮ ತಿಂಗಳಿನ ಆರಂಭದಲ್ಲಿಯೂ ತುತೂರಿಗಳನ್ನು ಊದಬೇಕು. ನಿಮ್ಮ ದಹನಬಲಿಗಳನ್ನೂ ಸಮಾಧಾನದ ಬಲಿಯನ್ನೂ ಅರ್ಪಿಸುವಾಗ ಅವುಗಳನ್ನು ಊದಬೇಕು. ಅವುಗಳ ಧ್ವನಿಯು ನಿಮ್ಮನ್ನು ನಿಮ್ಮ ದೇವರ ಜ್ಞಾಪಕಕ್ಕೆ ತರುವುದು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ.” ");
INSERT INTO kanokcv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ಎರಡನೆಯ ವರ್ಷದ ಎರಡನೆಯ ತಿಂಗಳಿನ ಇಪ್ಪತ್ತನೆಯ ದಿವಸದಲ್ಲಿ ಮೇಘವು ಸಾಕ್ಷಿ ಗುಡಾರದ ಮೇಲಿನಿಂದ ಎದ್ದಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ಆಗ ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಕ್ರಮಗಳ ಪ್ರಕಾರ ಸೀನಾಯಿ ಮರುಭೂಮಿಯಿಂದ ಪ್ರಯಾಣಮಾಡಿದರು. ಮೇಘವು ಪಾರಾನ್ ಎಂಬ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಳಿಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಅವರು ಪ್ರಯಾಣಮಾಡಿದ್ದು ಇದು ಮೊದಲನೇ ಸಾರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ಯೆಹೂದನ ಪಾಳೆಯದ ಧ್ವಜವು ಅದರ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಮೊದಲು ಹೊರಟಿತು. ಅವರ ಸೈನ್ಯದ ಮೇಲೆ ಅಮ್ಮೀನಾದಾಬನ ಮಗ ನಹಶೋನನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ಇಸ್ಸಾಕಾರನ ಮಕ್ಕಳ ಗೋತ್ರದ ಸೈನ್ಯದ ಮೇಲೆ ಚೂವಾರನ ಮಗ ನೆತನೆಯೇಲ್ ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ಜೆಬುಲೂನನ ಗೋತ್ರದ ಸೈನ್ಯದ ಮೇಲೆ ಹೇಲೋನನ ಮಗ ಎಲೀಯಾಬನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ಆಗ ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಇಳಿಸಿದಾಗ ಗೇರ್ಷೋನನ ಮಕ್ಕಳೂ, ಮೆರಾರೀಯರೂ ಗುಡಾರವನ್ನು ಹೊತ್ತುಕೊಂಡು ಮುಂದೆ ಹೊರಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ರೂಬೇನನ ಪಾಳೆಯದ ಧ್ವಜವು ಅವರ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಹೊರಟಿತು. ಅವನ ಸೈನ್ಯದ ಮೇಲೆ ಶೆದೇಯೂರನ ಮಗ ಎಲೀಚೂರನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ಸಿಮೆಯೋನನ ಗೋತ್ರದ ಸೈನ್ಯದ ಮೇಲೆ ಚುರೀಷದ್ದೈಯನ ಮಗ ಶೆಲುಮೀಯೇಲನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ಗಾದನ ಗೋತ್ರದ ಸೈನ್ಯದ ಮೇಲೆ ದೆವುಯೇಲನ ಮಗ ಎಲ್ಯಾಸಾಫನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ಅವರ ಹಿಂದೆ ಪರಿಶುದ್ಧ ವಸ್ತುಗಳನ್ನು ಹೊರುವ ಕೊಹಾತ್ಯರು ಹೊರಟರು. ಇವರು ಬರುವಷ್ಟರೊಳಗೆ ಉಳಿದ ಲೇವಿಯರು ಗುಡಾರವನ್ನು ನಿಲ್ಲಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ಎಫ್ರಾಯೀಮನ ಪಾಳೆಯದ ಧ್ವಜವು ಅವನ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಹೊರಟಿತು. ಅವರ ಸೈನ್ಯದ ಮೇಲೆ ಅಮ್ಮೀಹೂದನ ಮಗ ಎಲೀಷಾಮನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ಮನಸ್ಸೆಯ ಗೋತ್ರದ ಮೇಲೆ ಪೆದಾಚೂರನ ಮಗ ಗಮಲಿಯೇಲನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ಬೆನ್ಯಾಮೀನನ ಗೋತ್ರದ ಸೈನ್ಯದ ಮೇಲೆ ಗಿದ್ಯೋನಿಯ ಮಗ ಅಬೀದಾನನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ದಾನನ ಪಾಳೆಯದ ಧ್ವಜವು ಸಮಸ್ತ ಪಾಳೆಯಗಳ ಹಿಂದೆ ಅವರ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಹೊರಟಿತು. ಅವನ ಸೈನ್ಯದ ಮೇಲೆ ಅಮ್ಮೀಷದ್ದೈಯನ ಮಗ ಅಹೀಗೆಜೆರನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ಆಶೇರನ ಗೋತ್ರದ ಸೈನ್ಯಗಳ ಮೇಲೆ ಒಕ್ರಾನನ ಮಗ ಪಗೀಯೇಲನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ನಫ್ತಾಲಿಯ ಗೋತ್ರದ ಸೈನ್ಯದ ಮೇಲೆ ಏನಾನ ಮಗ ಅಹೀರನು ಇದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ಈ ಪ್ರಕಾರ ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಗೋತ್ರಗಳ ಪ್ರಕಾರ ಪ್ರಯಾಣವಾಗಿ ಹೊರಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ಮೋಶೆ ತನ್ನ ಮಾವನಾಗಿದ್ದ ಮಿದ್ಯಾನನಾದ ರೆಯೂವೇಲನ ಮಗ ಹೊಬಾಬನಿಗೆ, “ಯೆಹೋವ ದೇವರು ನಮಗೆ ಕೊಡುತ್ತೇನೆಂದು ಹೇಳಿದ ದೇಶಕ್ಕೆ ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದೇವೆ. ನಮ್ಮ ಸಂಗಡ ನೀನೂ ಬಾ, ನಾವು ನಿನಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡುವೆವು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರನ್ನು ಕುರಿತು ಒಳ್ಳೆಯವುಗಳನ್ನು ವಾಗ್ದಾನ ಮಾಡಿದ್ದಾರೆ,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ಆಗ ಅವನು ಅವನಿಗೆ, “ನಾನು ಬರುವುದಿಲ್ಲ. ನನ್ನ ದೇಶಕ್ಕೂ ನನ್ನ ಬಂಧುಗಳ ಬಳಿಗೂ ನಾನು ಹೋಗುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ಅದಕ್ಕೆ ಮೋಶೆ, “ನಮ್ಮನ್ನು ಬಿಡಬೇಡ. ಏಕೆಂದರೆ ನಾವು ಎಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳಬೇಕೆಂಬುದು ನಿನಗೆ ಮಾತ್ರ ತಿಳಿದಿದೆ. ನೀನು ನಮಗೆ ಕಣ್ಣುಗಳಾಗಿರುವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ನೀನು ನಮ್ಮ ಸಂಗಡ ಬಂದರೆ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಕೊಡುವುದಕ್ಕಿರುವ ಒಳ್ಳೆಯದನ್ನು ನಾವು ನಿನ್ನೊಂದಿಗೆ ಹಂಚಿಕೊಳ್ಳುವೆವು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ಅವರು ಯೆಹೋವ ದೇವರ ಪರ್ವತದ ಬಳಿಯಿಂದ ಮೂರು ದಿವಸಗಳವರೆಗೆ ಪ್ರಯಾಣಮಾಡಿದರು. ಯೆಹೋವ ದೇವರ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷವು ಅವರಿಗೆ ಇಳಿದುಕೊಳ್ಳುವ ಸ್ಥಳವನ್ನು ಹುಡುಕುವುದಕ್ಕೆ ಅವರ ಮೂರು ದಿವಸಗಳ ಪ್ರಯಾಣದಲ್ಲಿ ಅವರ ಮುಂದಾಗಿ ಹೋಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ಅವರು ಪಾಳೆಯದಿಂದ ಹೊರಟಾಗ, ಯೆಹೋವ ದೇವರ ಮೇಘವು ಹಗಲಿನಲ್ಲಿ ಅವರ ಮೇಲೆ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ಇದಲ್ಲದೆ ಮಂಜೂಷವು ಹೊರಡುವಾಗ ಮೋಶೆಯು ಹೀಗೆ ಹೇಳುತ್ತಿದ್ದನು, “ಯೆಹೋವ ದೇವರೇ, ಎದ್ದೇಳಿರಿ, ನಿಮ್ಮ ಶತ್ರುಗಳು ಚದರಿಹೋಗಲಿ. ನಿಮ್ಮನ್ನು ಹಗೆ ಮಾಡುವವರು ನಿಮ್ಮ ಎದುರಿನಿಂದ ಓಡಿಹೋಗಲಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ಮಂಜೂಷವು ನಿಂತಾಗ ಅವನು ಹೀಗೆ ಹೇಳುತ್ತಿದ್ದನು, “ಯೆಹೋವ ದೇವರೇ, ಸಾವಿರಾರು ಇಸ್ರಾಯೇಲರ ಕುಟುಂಬಗಳ ಬಳಿಗೆ ಹಿಂದಿರುಗು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ಇಸ್ರಾಯೇಲ್ ಜನರು ತಮಗೆ ಕಷ್ಟವಾಯಿತೆಂದು ಗೊಣಗುಟ್ಟಿದಾಗ, ಯೆಹೋವ ದೇವರು ಅದನ್ನು ಕೇಳಿ ಕೋಪಗೊಂಡು ಅವರ ಮಧ್ಯದಲ್ಲಿ ಬೆಂಕಿ ಬೀಳುವಂತೆ ಮಾಡಿದ್ದರಿಂದ ಅವರ ಪಾಳೆಯದ ಕಟ್ಟಕಡೆಯ ಭಾಗದಲ್ಲಿದ್ದವರು ಸುಟ್ಟುಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ಆಗ ಜನರು ಮೋಶೆಗೆ ಕೂಗಿಕೊಂಡದ್ದರಿಂದ, ಮೋಶೆಯು ಯೆಹೋವ ದೇವರಿಗೆ ಪ್ರಾರ್ಥನೆಮಾಡಿದನು ಆಗ ಬೆಂಕಿಯು ಆರಿಹೋಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ಯೆಹೋವ ದೇವರು ಹತ್ತಿಸಿದ ಬೆಂಕಿಯು ಅವರಲ್ಲಿ ದಹಿಸಿದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ತಬೇರ ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ಅವರೊಳಗಿದ್ದ ಮಿಶ್ರ ಗುಂಪಿನ ಜನರು ಮಾಂಸಕ್ಕಾಗಿ ದುರಾಶೆಪಟ್ಟರು. ಇಸ್ರಾಯೇಲರು ಸಹ ತಿರುಗಿ ಅಳುತ್ತಾ, “ನಮಗೆ ಮಾಂಸವನ್ನು ತಿನ್ನುವುದಕ್ಕೆ ಕೊಡುವವರು ಯಾರು? ");
INSERT INTO kanokcv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ನಾವು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಉಚಿತವಾಗಿ ತಿಂದ ಮೀನನ್ನೂ ಸವತೆ ಕಾಯಿಯನ್ನೂ ಕರ್ಬೂಜಗಳನ್ನೂ ನೀರುಳ್ಳಿ ಈರುಳ್ಳಿ ಬೆಳ್ಳುಳ್ಳಿಗಳನ್ನೂ ಜ್ಞಾಪಿಸಿಕೊಳ್ಳುತ್ತೇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ಆದರೆ ಈಗ ನಮ್ಮ ಪ್ರಾಣವು ಬತ್ತಿಹೋಯಿತು, ಈ ಮನ್ನವಲ್ಲದೆ ಬೇರೆ ಯಾವುದೂ ನಮ್ಮ ಕಣ್ಣುಗಳ ಮುಂದೆ ಇರುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ಆ ಮನ್ನವು ಕೊತ್ತಂಬರಿ ಬೀಜದ ಹಾಗೆ ಇತ್ತು. ಅದು ಗುಗ್ಗುಲದಂತೆ ಕಾಣಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ಜನರು ಹೊರಗೆ ಹೋಗಿ ಅದನ್ನು ಕೂಡಿಸಿ, ಬೀಸುವ ಕಲ್ಲುಗಳಲ್ಲಿ ಬೀಸಿ ಇಲ್ಲವೆ ಒರಳಿನಲ್ಲಿ ಕುಟ್ಟಿ, ಪಾತ್ರೆಗಳಲ್ಲಿ ಬೇಯಿಸಿ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡುತ್ತಿದ್ದರು. ಅದರ ರುಚಿಯು ಓಲಿವ್ ಎಣ್ಣೆಯಿಂದ ಮಾಡಿದ ರೊಟ್ಟಿಯಹಾಗೆ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ರಾತ್ರಿಯಲ್ಲಿ ಮಂಜು ಪಾಳೆಯದ ಮೇಲೆ ಬೀಳುವಾಗ ಅದರೊಂದಿಗೆ ಮನ್ನವು ಬೀಳುತ್ತಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ಆಗ ಪ್ರತಿಯೊಂದು ಕುಟುಂಬದ ಜನರು ತಮ್ಮ ಗುಡಾರದ ಬಾಗಿಲಿನಲ್ಲಿ ನಿಂತು ಅಳುವುದನ್ನು ಮೋಶೆ ಕೇಳಿದನು. ಯೆಹೋವ ದೇವರು ಬಹಳ ಕೋಪಗೊಂಡರು. ಮೋಶೆ ಗಲಿಬಿಲಿಗೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರಿಗೆ, “ಈ ಎಲ್ಲಾ ಜನರ ಭಾರವನ್ನು ನನ್ನ ಮೇಲೆ ಹೊರಿಸಿ ನೀವು ಏಕೆ ತೊಂದರೆಯನ್ನು ನಿಮ್ಮ ಸೇವಕನ ಮೇಲೆ ತಂದಿದ್ದೀರಿ? ನಿಮ್ಮನ್ನು ಅತೃಪ್ತಿಗೊಳಿಸಲು ನಾನೇನು ಮಾಡಿದ್ದೇನೆ? ");
INSERT INTO kanokcv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ನಾನು ಈ ಎಲ್ಲಾ ಜನರನ್ನು ಗರ್ಭಧರಿಸಿ ಜನ್ಮವಿತ್ತೆನೋ? ದಾದಿಯು ಹಸುಗೂಸನ್ನು ಎತ್ತಿಕೊಂಡು ಹೋಗುವಂತೆ, ಈ ಜನರನ್ನು ತನ್ನ ತೋಳುಗಳಲ್ಲಿ ಎತ್ತಿಕೊಂಡು ಅವರ ಪಿತೃಗಳಿಗೆ ನೀವು ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶಕ್ಕೆ ನಡೆಸಬೇಕೆಂದು ನೀವು ನನಗೇಕೆ ಹೇಳಿದ್ದೀರಿ? ");
INSERT INTO kanokcv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ಈ ಸಮಸ್ತ ಜನರಿಗೆ ಕೊಡುವುದಕ್ಕೆ ಮಾಂಸವು ನನಗೆ ಎಲ್ಲಿಂದ ದೊರಕುವುದು? ‘ನಮಗೆ ತಿನ್ನಲು ಮಾಂಸವನ್ನು ಕೊಡು,’ ಎಂದು ನನ್ನ ಬಳಿಗೆ ಬಂದು ಅಳುತ್ತಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ನಾನು ಒಬ್ಬೊಂಟಿಗನಾಗಿ ಈ ಸಮಸ್ತ ಜನರನ್ನು ಹೊತ್ತುಕೊಳ್ಳುವುದಕ್ಕೆ ಶಕ್ತನಲ್ಲ. ಅದು ನನಗೆ ಅತಿದೊಡ್ಡ ಭಾರವಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ಈ ರೀತಿಯಲ್ಲಿ ನೀವು ನನ್ನನ್ನು ನಡೆಸುವುದಾದರೆ, ಈಗಲೇ ನನ್ನನ್ನು ಕೊಂದುಬಿಡಿ. ನಿಮ್ಮ ದೃಷ್ಟಿಯಲ್ಲಿ ನನಗೆ ದಯೆ ದೊರೆತರೆ, ನಾನು ನನ್ನ ಸ್ವಂತ ನಾಶವನ್ನು ಎದುರಿಸದಂತೆ ಕಾಪಾಡಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಜನರ ನಾಯಕರೆಂದೂ, ಹಿರಿಯರೆಂದೂ, ಅವರ ಮೇಲಿನ ಉದ್ಯೋಗಸ್ಥರೆಂದೂ ನೀನು ತಿಳಿದುಕೊಂಡಂತಹ ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರೊಳಗಿರುವ ಎಪ್ಪತ್ತು ಮಂದಿಯನ್ನು ಕೂಡಿಸಿ, ಅವರನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಕಡೆಗೆ ಕರೆದುಕೊಂಡು ಬಾ. ಅವರು ಅಲ್ಲಿ ನಿನ್ನ ಸಂಗಡ ನಿಂತಿರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ಆಗ ನಾನು ಇಳಿದುಬಂದು, ಅಲ್ಲಿ ನಿನ್ನ ಸಂಗಡ ಮಾತನಾಡುವೆನು. ನಿನಗೆ ನಾನು ಅನುಗ್ರಹಿಸಿರುವ ಆತ್ಮಶಕ್ತಿಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಅವರಿಗೂ ಕೊಡುವೆನು. ಆಗ ನೀನು ಅದನ್ನು ಒಬ್ಬನೇ ಹೊತ್ತುಕೊಳ್ಳದ ಹಾಗೆ ಅವರು ನಿನ್ನ ಸಂಗಡ ಜನರ ಭಾರವನ್ನು ಹೊರುವರು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ಜನರಿಗೆ ನೀನು, “ ‘ನಾಳೆಗಾಗಿ ನಿಮ್ಮನ್ನು ಪರಿಶುದ್ಧ ಮಾಡಿಕೊಳ್ಳಿರಿ. ಆಗ ಮಾಂಸವನ್ನು ತಿನ್ನುವಿರಿ. ನಮಗೆ ಯಾವನು ಮಾಂಸವನ್ನು ತಿನ್ನುವುದಕ್ಕೆ ಕೊಡುವನು? ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ನಮಗೆ ಒಳ್ಳೆಯದು ಇತ್ತು,’ ಎಂದು ಹೇಳಿ, ಯೆಹೋವ ದೇವರು ಕೇಳುವಂತೆ ಅತ್ತಿರಿ. ಆದಕಾರಣ ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ತಿನ್ನುವುದಕ್ಕೆ ಮಾಂಸವನ್ನು ಕೊಡುವನು ಮತ್ತು ನೀವು ಅದನ್ನು ತಿನ್ನುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ನೀವು ತಿನ್ನುವುದು ಒಂದು ದಿನವಲ್ಲ, ಎರಡು ದಿನವೂ ಅಲ್ಲ, ಐದು ದಿನವೂ ಅಲ್ಲ, ಹತ್ತು ದಿನವಲ್ಲ, ಇಪ್ಪತ್ತು ದಿನವೂ ಅಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ಅದು ನಿಮ್ಮ ಮೂಗಿನಿಂದ ಬಂದು, ನಿಮಗೆ ಅಸಹ್ಯವಾಗುವ ತನಕ ಪೂರ್ತಿ ತಿಂಗಳವರೆಗೆ ಮಾಂಸವನ್ನು ತಿನ್ನುವಿರಿ. ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿರುವ ಯೆಹೋವ ದೇವರನ್ನು ಅಲಕ್ಷ್ಯಮಾಡಿ, ಅವರ ಎದುರಿನಲ್ಲಿ ಅತ್ತು, ‘ನಾವು ಏಕೆ ಈಜಿಪ್ಟಿನಿಂದ ಬಂದೆವು,’ ಎಂದು ಹೇಳುತ್ತೀರಲ್ಲಾ, ಎಂದು ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ಆದರೆ ಮೋಶೆಯು, “ನನ್ನ ಸಂಗಡ ಇರುವ ಜನರು ಆರು ಲಕ್ಷ ಕಾಲಾಳುಗಳು. ಅವರು ಒಂದು ತಿಂಗಳು ಪೂರ್ತಿ ತಿನ್ನುವ ಹಾಗೆ, ಅವರಿಗೆ ನಾನು ಮಾಂಸವನ್ನು ಕೊಡುವೆನೆಂದು ನೀವು ಹೇಳಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ಅವರಿಗೆ ಸಾಕಾಗುವ ಹಾಗೆ ಕುರಿದನಗಳನ್ನು ಅವರಿಗೋಸ್ಕರ ಕೊಯ್ಯಬೇಕೋ? ಅವರಿಗೆ ಸಾಕಾಗುವ ಹಾಗೆ ಸಮುದ್ರದ ಮೀನುಗಳನ್ನೆಲ್ಲಾ ಕೂಡಿಸಿ ತರಬೇಕೋ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಯೆಹೋವ ದೇವರ ಕೈ ಮೋಟುಗೈಯೋ? ನನ್ನ ಮಾತು ನೆರವೇರುತ್ತದೋ, ಇಲ್ಲವೋ ಎಂದು ನೀನು ನೋಡುವೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ಆಗ ಮೋಶೆ ಹೋಗಿ ಯೆಹೋವ ದೇವರ ಮಾತುಗಳನ್ನು ಜನರಿಗೆ ಹೇಳಿ, ಜನರ ಹಿರಿಯರಲ್ಲಿ ಎಪ್ಪತ್ತು ಮಂದಿಯನ್ನು ಕೂಡಿಸಿ, ಗುಡಾರದ ಸುತ್ತಲೂ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ಯೆಹೋವ ದೇವರು ಮೇಘದೊಳಗಿಂದ ಇಳಿದು, ಅವನ ಸಂಗಡ ಮಾತನಾಡಿ, ಅವನ ಮೇಲಿರುವ ಆತ್ಮಶಕ್ತಿಯಲ್ಲಿ ಕಿಂಚಿತ್ತನ್ನು ತೆಗೆದು, ಹಿರಿಯರಾದ ಎಪ್ಪತ್ತು ಮಂದಿಯ ಮೇಲೆ ಇಟ್ಟರು. ಆದ್ದರಿಂದ ಆತ್ಮವು ಅವರ ಮೇಲೆ ನೆಲೆಯಾಗಿದ್ದಾಗ ಅವರು ಪ್ರವಾದಿಸಿದರು. ಆಮೇಲೆ ಅವರು ಪ್ರವಾದಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ಆದರೆ ಇಬ್ಬರು ಮನುಷ್ಯರು ಪಾಳೆಯದಲ್ಲಿ ಉಳಿದರು. ಅವರಲ್ಲಿ ಒಬ್ಬನ ಹೆಸರು ಎಲ್ದಾದ್. ಮತ್ತೊಬ್ಬನ ಹೆಸರು ಮೇದಾದ್. ಇವರು ನಾಯಕರ ಪಟ್ಟಿಯಲ್ಲಿದ್ದವರಾಗಿದ್ದರು. ಇವರ ಮೇಲೆ ಆತ್ಮವು ನೆಲೆಯಾಯಿತು. ಇವರು ಗುಡಾರಕ್ಕೆ ಹೊರಟು ಹೋಗದೆ, ಪಾಳೆಯದಲ್ಲಿ ಪ್ರವಾದಿಸುತ್ತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ಆಗ ಒಬ್ಬ ಯೌವನಸ್ಥನು ಓಡಿಬಂದು ಮೋಶೆಗೆ, “ಎಲ್ದಾದನೂ, ಮೇದಾದನೂ ಪಾಳೆಯದಲ್ಲಿ ಪ್ರವಾದಿಸುತ್ತಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ಅದಕ್ಕೆ ಯೌವನಸ್ಥರಲ್ಲಿ ಒಬ್ಬನೂ, ಮೋಶೆಯ ಸೇವಕನೂ ಆಗಿದ್ದ ನೂನನ ಮಗ ಯೆಹೋಶುವನು, “ನನ್ನ ಒಡೆಯನಾದ ಮೋಶೆಯೇ, ಅವರನ್ನು ತಡೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ಮೋಶೆಯು ಅವನಿಗೆ, “ನನ್ನ ನಿಮಿತ್ತವಾಗಿ ನೀನು ಹೊಟ್ಟೆಕಿಚ್ಚು ಪಡುತ್ತೀಯೋ? ಯೆಹೋವ ದೇವರ ಜನರೆಲ್ಲಾ ಪ್ರವಾದಿಗಳಾಗಿದ್ದು, ಯೆಹೋವ ದೇವರು ತನ್ನ ಆತ್ಮವನ್ನು ಅವರ ಮೇಲೆ ಇಟ್ಟರೆ ಎಷ್ಟೋ ಒಳ್ಳೆಯದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ಆಗ ಮೋಶೆಯೂ, ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರೂ ಪಾಳೆಯದೊಳಗೆ ಬಂದು ಸೇರಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ಯೆಹೋವ ದೇವರ ಕಡೆಯಿಂದ ಒಂದು ಗಾಳಿಯು ಹೊರಟು ಸಮುದ್ರದ ಕಡೆಯಿಂದ ಲಾವಕ್ಕಿಗಳನ್ನು ತಂದು, ಪಾಳೆಯದ ಸುತ್ತಲೂ ಈ ಕಡೆ ಒಂದು ದಿನದ ದೂರದ ಪ್ರಯಾಣದಷ್ಟು, ಆ ಕಡೆ ಒಂದು ದಿನದ ದೂರದ ಪ್ರಯಾಣದಷ್ಟು ಪಾಳೆಯದ ಬಳಿಯಲ್ಲಿ ಭೂಮಿಯ ಮೇಲೆ ಎರಡು ಮೊಳ ಎತ್ತರದಲ್ಲಿ ಅವುಗಳನ್ನು ಬೀಳುವಂತೆ ಮಾಡಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ಜನರು ಆ ದಿನವೆಲ್ಲಾ, ಆ ರಾತ್ರಿಯೆಲ್ಲಾ, ಮರು ದಿವಸವೆಲ್ಲಾ ಲಾವಕ್ಕಿಗಳನ್ನು ಕೂಡಿಸಿದರು. ಕಡಿಮೆ ಕೂಡಿಸಿದವನು ಸಾವಿರ ಕಿಲೋಗ್ರಾಮಿನಷ್ಟು ಕೂಡಿಸಿದನು. ಅವರು ಪಾಳೆಯದ ಸುತ್ತಲೂ ಅವುಗಳನ್ನು ಹರಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ಆದರೆ ಮಾಂಸವು ಇನ್ನೂ ಅವರ ಹಲ್ಲುಗಳ ನಡುವೆ ಇದ್ದಾಗ, ಅದನ್ನು ಅಗಿಯುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಯೆಹೋವ ದೇವರು ಜನರನ್ನು ಘೋರ ವ್ಯಾಧಿಯಿಂದ ಸಾಯಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ಆಶೆ ಪಟ್ಟವರನ್ನು ಅಲ್ಲಿ ಹೂಳಿಟ್ಟಿದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಕಿಬ್ರೋತ್ ಹತಾವ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ತರುವಾಯ ಜನರು ಕಿಬ್ರೋತ್ ಹತಾವದಿಂದ ಹೊರಟು ಹಚೇರೋತಿಗೆ ಪ್ರಯಾಣಮಾಡಿ ಬಂದು, ಅಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ಮೋಶೆಯು ಕೂಷ್ ದೇಶದ ಸ್ತ್ರೀಯನ್ನು ವಿವಾಹವಾಗಿದ್ದನು. ಆಕೆಯ ನಿಮಿತ್ತವಾಗಿ ಮಿರ್ಯಾಮಳೂ ಆರೋನನೂ ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ಮಾತನಾಡಲಿಕ್ಕೆ ಪ್ರಾರಂಭಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ಅವರು, “ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಮುಖಾಂತರ ಮಾತ್ರವೇ ಮಾತನಾಡಿದ್ದಾರೋ? ನಮ್ಮ ಮುಖಾಂತರ ಮಾತಾಡಲಿಲ್ಲವೋ?” ಎಂದರು. ಅವರು ಆಡಿದ ಮಾತು ಯೆಹೋವ ದೇವರಿಗೆ ಕೇಳಿಸಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ಆದರೆ ಮೋಶೆ ಎಂಬವನು ಭೂಲೋಕದಲ್ಲಿರುವ ಸಕಲ ಮನುಷ್ಯರೆಲ್ಲರಿಗಿಂತ ಬಹು ದೀನನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ಯೆಹೋವ ದೇವರು ಫಕ್ಕನೆ ಮೋಶೆಗೂ ಆರೋನನಿಗೂ ಮಿರ್ಯಾಮಳಿಗೂ, “ನೀವು ಮೂವರು ಹೊರಗೆ ದೇವದರ್ಶನ ಗುಡಾರದ ಸಮೀಪಕ್ಕೆ ಬನ್ನಿರಿ,” ಎಂದರು. ಆಗ ಆ ಮೂವರೂ ಹೊರಗೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ಯೆಹೋವ ದೇವರು ಮೇಘ ಸ್ತಂಭದಲ್ಲಿ ಇಳಿದು ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ನಿಂತು, ಆರೋನನನ್ನೂ ಮಿರ್ಯಾಮಳನ್ನೂ ಕರೆದಾಗ, ಅವರಿಬ್ಬರು ಮುಂದೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ಯೆಹೋವ ದೇವರು ಅವರಿಗೆ ಹೀಗೆ ಹೇಳಿದನು, “ನನ್ನ ಮಾತುಗಳನ್ನು ಈಗ ಕೇಳಿರಿ: “ನಿಮ್ಮಲ್ಲಿ ಒಬ್ಬ ಪ್ರವಾದಿ ಇದ್ದರೆ ಯೆಹೋವ ದೇವರಾದ ನಾನು ದರ್ಶನದಲ್ಲಿ ಪ್ರಕಟಿಸುವೆನು, ಇಲ್ಲವೆ ಕನಸಿನಲ್ಲಿಯೂ ನಾನು ಅವನೊಡನೆ ಮಾತನಾಡುವೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ಆದರೆ ನನ್ನ ಸೇವಕನಾದ ಮೋಶೆಯು ಹಾಗಲ್ಲ. ಅವನು ನನ್ನ ಮನೆಯಲ್ಲೆಲ್ಲಾ ನಂಬಿಗಸ್ತನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ನಾನು ಗೂಢವಾಗಿ ಅಲ್ಲ ಸ್ಪಷ್ಟವಾಗಿ, ಮುಖಾಮುಖಿಯಾಗಿ ಅಂದರೆ, ಪ್ರತ್ಯಕ್ಷವಾಗಿ ಅವನ ಸಂಗಡ ಮಾತನಾಡುತ್ತೇನೆ. ಅವನು ಯೆಹೋವ ದೇವರ ರೂಪವನ್ನು ದೃಷ್ಟಿಸುವನು. ಹೀಗಿರಲು ನೀವು ನನ್ನ ಸೇವಕನಾದ ಮೋಶೆಗೆ ವಿರೋಧವಾಗಿ ಮಾತನಾಡುವುದಕ್ಕೆ ಏಕೆ ಭಯಪಡಲಿಲ್ಲ?” ");
INSERT INTO kanokcv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ಆಗ ಯೆಹೋವ ದೇವರು ಅವರ ಮೇಲೆ ಕೋಪಗೊಂಡು ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ಆ ಮೇಘವು ಗುಡಾರದ ಮೇಲಿನಿಂದ ತೊಲಗಿ ಹೋಯಿತು. ಮಿರ್ಯಾಮಳು ಹಿಮದ ಹಾಗೆ ಕುಷ್ಠವುಳ್ಳವಳಾದಳು. ಆರೋನನು ಮಿರ್ಯಾಮಳ ಕಡೆಗೆ ನೋಡಿದಾಗ, ಇಗೋ, ಅವಳು ಕುಷ್ಠರೋಗಿಯಾಗಿದ್ದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ಆರೋನನು ಮೋಶೆಗೆ, “ಅಯ್ಯೋ ನನ್ನ ಒಡೆಯನೇ, ನಾವು ಪಾಪಮಾಡಿದೆವು. ಬುದ್ಧಿ ಇಲ್ಲದೆ ಮಾಡಿದ ಈ ಪಾಪವನ್ನು ನಮ್ಮ ಮೇಲೆ ಹಾಕಬೇಡ. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ತನ್ನ ತಾಯಿಯ ಗರ್ಭದಿಂದ ಹೊರಗೆ ಬಂದಾಗಲೇ ಅರ್ಧ ಮಾಂಸ ಕೊಳೆತು ಹೋದ ಶಿಶುವಿನ ಶವದಂತೆ ಆಕೆಯನ್ನು ಇರಗೊಡಿಸಬೇಡ ಎಂದು ನಾನು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರಿಗೆ, “ದೇವರೇ, ಅವಳನ್ನು ಈಗ ಗುಣಪಡಿಸು, ಎಂದು ನಾನು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಆಕೆಯ ತಂದೆ ಅವಳ ಮುಖದ ಮೇಲೆ ಉಗುಳಿದರೆ, ಆಕೆ ಏಳು ದಿನ ನಾಚಿಕೆಯಿಂದ ಮರೆಯಾಗಿರುವುದಿಲ್ಲವೇ? ಹಾಗಾದರೆ ಆಕೆಯು ಏಳು ದಿವಸ ಪಾಳೆಯದ ಹೊರಗೆ ಇರಲಿ, ತರುವಾಯ ಅವಳನ್ನು ನೀನು ಪಾಳೆಯದೊಳಗೆ ಸೇರಿಸಿಕೊಳ್ಳಬಹುದು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ಹಾಗೆಯೇ ಮಿರ್ಯಾಮಳನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಏಳು ದಿವಸ ಮರೆಯಾಗಿ ಇಟ್ಟರು. ಮಿರ್ಯಾಮಳು ತಿರುಗಿ ಒಳಗೆ ಬರುವವರೆಗೆ ಜನರು ಪ್ರಯಾಣ ಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ತರುವಾಯ ಜನರು ಹಚೇರೋತಿನಿಂದ ಹೊರಟು ಪಾರಾನ್ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ ಕೊಡುವ ಕಾನಾನ್ ದೇಶವನ್ನು ಪರೀಕ್ಷಿಸುವ ಹಾಗೆ ನೀನು ಜನರನ್ನು ಕಳುಹಿಸು. ಅವರವರ ಪಿತೃಗಳ ಗೋತ್ರದ ಪ್ರಕಾರ ಅವರೊಳಗೆ ಅಧಿಕಾರಿಯಾಗಿರುವ ಪ್ರತಿಯೊಬ್ಬನನ್ನು ಕಳುಹಿಸು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ಆಗ ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯಂತೆ ಪಾರಾನ್ ಮರುಭೂಮಿಯಿಂದ ಅವರನ್ನು ಕಳುಹಿಸಿದನು. ಅವರೆಲ್ಲರೂ ಇಸ್ರಾಯೇಲರ ಮುಖ್ಯಸ್ಥರಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ಅವರ ಹೆಸರುಗಳು ಯಾವುವೆಂದರೆ: ರೂಬೇನನ ಗೋತ್ರದ ಜಕ್ಕೂರನ ಮಗ ಶಮ್ಮೂವ, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ಸಿಮೆಯೋನ್ ಗೋತ್ರದ ಹೋರಿಯನ ಮಗ ಶಾಫಾಟನು, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ಯೆಹೂದ ಗೋತ್ರದ ಯೆಫುನ್ನೆಯ ಮಗ ಕಾಲೇಬನು, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ಇಸ್ಸಾಕಾರ್ ಗೋತ್ರದ ಯೋಸೇಫನ ಮಗ ಇಗಾಲ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ಎಫ್ರಾಯೀಮ್ ಗೋತ್ರದ ನೂನನ ಮಗ ಹೋಶೇಯ, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ಬೆನ್ಯಾಮೀನ್ ಗೋತ್ರದ ರಾಫೂವನ ಮಗ ಪಲ್ಟೀ, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ಜೆಬುಲೂನ್ ಗೋತ್ರದ ಸೋದೀಯ ಮಗ ಗದ್ದೀಯೇಲ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ಯೋಸೇಫನ ಗೋತ್ರ ಅಂದರೆ ಮನಸ್ಸೆ ಗೋತ್ರದ ಸೂಸೀಯ ಮಗ ಗದ್ದೀ, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ದಾನನ ಗೋತ್ರದ ಗೆಮಲ್ಲೀಯನ ಮಗ ಅಮ್ಮಿಯೇಲ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ಆಶೇರ್ ಗೋತ್ರದ ಮೀಕಾಯೇಲನ ಮಗ ಸೆತೂರ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ನಫ್ತಾಲಿ ಗೋತ್ರದ ವಾಪೆಸೀಯನ ಮಗ ನಹಬೀ. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ಗಾದನ ಗೋತ್ರದ ಮಾಕೀಯನ ಮಗ ಗೆಯೂಯೇಲ್. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕಾಗಿ ಮೋಶೆ ಕಳುಹಿಸಿದ ಮನುಷ್ಯರ ಹೆಸರುಗಳು ಇವೇ. ಮೋಶೆ ನೂನನ ಮಗ ಹೋಶೇಯನಿಗೆ ಯೆಹೋಶುವ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ಮೋಶೆ ಕಾನಾನ್ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕೆ ಅವರನ್ನು ಕಳುಹಿಸುವಾಗ ಅವರಿಗೆ, “ನೀವು ನೆಗೆವ ಮಾರ್ಗವಾಗಿ ಮಲೆನಾಡಿಗೆ ಹತ್ತಿಹೋಗಿರಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ಆ ದೇಶವು ಎಂಥಾದ್ದೋ? ಅದರಲ್ಲಿ ವಾಸಿಸುವ ಜನರು ಬಲವುಳ್ಳವರೋ, ಬಲಹೀನರೋ? ಸ್ವಲ್ಪ ಜನರೋ, ಬಹಳ ಜನರೋ? ಎಂದೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ಅವರು ವಾಸಿಸುವ ದೇಶವು ಎಂಥಾದ್ದೋ? ಅದು ಒಳ್ಳೆಯದಾಗಿದೆಯೋ, ಕೆಟ್ಟದ್ದಾಗಿದೆಯೋ? ಅವರು ವಾಸಿಸುವ ಪಟ್ಟಣಗಳು ಎಂಥವುಗಳೋ? ಅವರು ವಾಸಿಸುವುದು ಡೇರೆಗಳಲ್ಲಿಯೋ, ಬಲವಾದ ಕೋಟೆಗಳಲ್ಲಿಯೋ? ಎಂದೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ಆ ಭೂಮಿಯು ಎಂಥಾದ್ದೋ? ಸಾರವಾದದ್ದೋ? ನಿಸ್ಸಾರವಾದದ್ದೋ? ಮರಗಳುಳ್ಳದ್ದೋ? ಇಲ್ಲದಿರುವುದೋ? ಎಂದು ನೋಡಿರಿ. ನೀವು ಧೈರ್ಯವುಳ್ಳವರಾಗಿದ್ದು, ಆ ಭೂಮಿಯ ಫಲವನ್ನು ತರಬೇಕು,” ಎಂದನು. ಆ ಕಾಲವು ಪ್ರಥಮ ದ್ರಾಕ್ಷಿ ಹಣ್ಣುಗಳ ಕಾಲವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ಆಗ ಅವರು ಏರಿಹೋಗಿ ಚಿನ್ ಎಂಬ ಮರುಭೂಮಿಯಿಂದ ಹಮಾತಿನ ಕಡೆಯಲ್ಲಿರುವ ರೆಹೋಬಿನವರೆಗೂ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ಅವರು ನೆಗೆವನ್ನು ದಾಟಿ ಹೆಬ್ರೋನಿನವರೆಗೆ ಬಂದರು. ಅಲ್ಲಿ ಅನಾಕನ ಮಕ್ಕಳಾದ ಅಹೀಮನ್, ಶೇಷೈ, ತಲ್ಮೈ ಎಂಬ ಉನ್ನತರಾದ ಪುರುಷರು ಇದ್ದರು. ಹೆಬ್ರೋನ್ ಪಟ್ಟಣವು ಈಜಿಪ್ಟ್ ದೇಶದ ಚೋವನ್ ಪಟ್ಟಣಕ್ಕಿಂತ ಏಳು ವರ್ಷಗಳು ಮೊದಲು ನಿರ್ಮಿಸಲಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ಅವರು ಎಷ್ಕೋಲ್ ಹಳ್ಳದವರೆಗೂ ಬಂದು, ಅಲ್ಲಿ ದ್ರಾಕ್ಷಿ ಹಣ್ಣುಗಳ ಗೊಂಚಲಿನ ಕೊಂಬೆಯನ್ನು ಕೊಯ್ದು, ಅದನ್ನು ಅಡ್ಡ ಕೋಲಿನ ಮೇಲೆ ಇಬ್ಬರಾಗಿ ಹೊತ್ತುಕೊಂಡು ಹೋದರು. ಇದಲ್ಲದೆ ದಾಳಿಂಬೆ, ಅಂಜೂರ ಹಣ್ಣುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ಇಸ್ರಾಯೇಲರು ಅಲ್ಲಿ ದ್ರಾಕ್ಷಿ ಗೊಂಚಲನ್ನು ಕೊಯ್ದದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಎಷ್ಕೋಲ್ ಹಳ್ಳವೆಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ಅವರು ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿ, ನಲವತ್ತು ದಿವಸಗಳಾದ ಮೇಲೆ ತಿರುಗಿ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ಅವರು ಹೋಗಿ ಮೋಶೆ ಆರೋನರ ಬಳಿಗೂ, ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಸಭೆಯ ಬಳಿಗೂ ಪಾರಾನ್ ಮರುಭೂಮಿಯಲ್ಲಿರುವ ಕಾದೇಶಿಗೂ ಬಂದು, ಅವರಿಗೂ, ಸಮಸ್ತ ಸಭೆಗೂ ವಿಷಯವನ್ನು ವಿವರಿಸಿ, ಆ ದೇಶದ ಫಲಗಳನ್ನು ಅವರಿಗೆ ತೋರಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ಅವರು ಮೋಶೆಗೆ, “ನೀನು ನಮ್ಮನ್ನು ಕಳುಹಿಸಿದ ದೇಶಕ್ಕೆ ಹೋದೆವು. ಅದು ನಿಜವಾಗಿಯೂ ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶವೇ. ಅದರ ಫಲವು ಇವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ಆದರೆ ಆ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿರುವ ಜನರು ಬಲಿಷ್ಠರು. ಪಟ್ಟಣಗಳು ಭದ್ರವಾಗಿಯೂ, ಬಹಳ ದೊಡ್ಡದಾಗಿಯೂ ಇವೆ. ಅನಾಕನ ಮಕ್ಕಳನ್ನು ನಾವು ಅಲ್ಲಿ ಕಂಡೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ಅಮಾಲೇಕ್ಯರು ದೇಶದ ನೆಗೆವನಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾರೆ. ಹಿತ್ತಿಯರೂ ಯೆಬೂಸಿಯರೂ ಅಮೋರಿಯರೂ ಪರ್ವತಗಳಲ್ಲಿಯೂ; ಕಾನಾನ್ಯರು ಸಮುದ್ರದ ಬಳಿಯಲ್ಲಿಯೂ ಯೊರ್ದನಿನ ತೀರದಲ್ಲಿಯೂ ವಾಸವಾಗಿದ್ದಾರೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ನಂತರ ಕಾಲೇಬನು ಮೋಶೆಯ ಎದುರಿನಲ್ಲಿ ಜನರನ್ನು ಸುಮ್ಮನಿರಿಸಿ, “ನಾವು ತಕ್ಷಣವೇ ಏರಿಹೋಗಿ ಅದನ್ನು ಸ್ವಾಧೀನ ಮಾಡಿಕೊಳ್ಳೋಣ. ಏಕೆಂದರೆ ಅದನ್ನು ಜಯಿಸಲು ನಾವು ನಿಜವಾಗಿಯೂ ಶಕ್ತರಾಗಿದ್ದೇವೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ಆದರೆ ಅವನ ಸಂಗಡ ಹೋದ ಜನರು, “ಆ ಜನರ ಬಳಿಗೆ ಹೋಗುವುದಕ್ಕೆ ನಮ್ಮಿಂದಾಗುವುದಿಲ್ಲ, ಅವರು ನಮಗಿಂತ ಬಲಿಷ್ಠರಾಗಿದ್ದಾರೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ಅವರು ಸಂಚರಿಸಿ ನೋಡಿದಂಥ ದೇಶದ ವಿಷಯವಾಗಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಅಶುಭ ಸಮಾಚಾರವನ್ನು ಹೇಳುವವರಾಗಿ, “ನಾವು ಸಂಚರಿಸಿ ನೋಡಿ ಬಂದ ದೇಶವು ತನ್ನಲ್ಲಿ ವಾಸವಾಗಿರುವವರನ್ನೇ ತಿಂದುಬಿಡುವ ದೇಶವಾಗಿದೆ. ನಾವು ಅದರಲ್ಲಿ ನೋಡಿದ ಜನರೆಲ್ಲಾ ಮಹಾ ಶರೀರದ ಮನುಷ್ಯರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ಅಲ್ಲಿ ನೆಫೀಲಿಯರನ್ನು ಅಂದರೆ ನೆಫೀಲಿಯ ವಂಶದವರಾದ ಮಹಾಶರೀರವುಳ್ಳ ಪುರುಷರನ್ನು ನೋಡಿದೆವು. ನಾವು ಅವರ ಮುಂದೆ ಮಿಡತೆಗಳ ಹಾಗೆ ಇದ್ದೆವು. ಅವರ ದೃಷ್ಟಿಗೂ ನಾವು ಹಾಗೆಯೇ ಕಾಣಿಸಿದೆವು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ಆಗ ಜನರೆಲ್ಲರೂ ತಮ್ಮ ಸ್ವರವೆತ್ತಿ ಆ ರಾತ್ರಿಯೆಲ್ಲಾ ಅತ್ತರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ಇಸ್ರಾಯೇಲರೆಲ್ಲರು ಮೋಶೆಗೂ ಆರೋನನಿಗೂ ವಿರೋಧವಾಗಿ ಗೊಣಗುಟ್ಟಿದರು. ಅವರು, “ನಾವು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿ ಸತ್ತಿದ್ದರೆ ಇಲ್ಲವೆ ಈ ಮರುಭೂಮಿಯಲ್ಲಾದರೂ ಸತ್ತಿದ್ದರೆ ಚೆನ್ನಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ನಾವು ಖಡ್ಗದಿಂದ ಕೊಲೆಯಾಗುವ ಹಾಗೆಯೂ ನಮ್ಮ ಹೆಂಡತಿಯರು ಮಕ್ಕಳು ಸುಲಿಗೆಯಾಗುವ ಹಾಗೆಯೂ ಯೆಹೋವ ದೇವರು ನಮ್ಮನ್ನು ಈ ದೇಶಕ್ಕೆ ಏಕೆ ಬರಮಾಡಿದ್ದಾರೆ? ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆ ನಾವು ತಿರುಗಿ ಹೋಗುವುದು ನಮಗೆ ಒಳ್ಳೆಯದಲ್ಲವೋ? ");
INSERT INTO kanokcv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ನಾವು ನಾಯಕನನ್ನು ನೇಮಿಸಿಕೊಂಡು ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆ ಹಿಂದಿರುಗೋಣ ಬನ್ನಿರಿ,” ಎಂದು ಒಬ್ಬರಿಗೊಬ್ಬರು ಹೇಳಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ಆಗ ಮೋಶೆಯೂ ಆರೋನನೂ ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಜನರ ಕೂಟದ ಮುಂದೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ಇದಲ್ಲದೆ ಕಾನಾನ್ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿದವರಲ್ಲಿದ್ದ ನೂನನ ಮಗ ಯೆಹೋಶುವನೂ, ಯೆಫುನ್ನೆಯ ಮಗ ಕಾಲೇಬನೂ ತಮ್ಮ ವಸ್ತ್ರಗಳನ್ನು ಹರಿದುಕೊಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಜನಸಮೂಹಕ್ಕೆ, “ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕೆ ನಾವು ದಾಟಿಹೋದ ದೇಶವು ಅತ್ಯುತ್ತಮವಾದ ದೇಶವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ಯೆಹೋವ ದೇವರು ನಮ್ಮನ್ನು ಇಷ್ಟಪಟ್ಟರೆ ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶವಾಗಿರುವ ಆ ದೇಶಕ್ಕೆ ನಮ್ಮನ್ನು ಬರಮಾಡಿ, ಅದನ್ನು ನಮಗೆ ಕೊಡುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ಆದ್ದರಿಂದ ನೀವಾದರೋ ಯೆಹೋವ ದೇವರಿಗೆ ತಿರುಗಿ ಬೀಳಬೇಡಿರಿ. ಆ ದೇಶದ ಜನರಿಗೆ ಭಯಪಡಬೇಡಿರಿ. ಏಕೆಂದರೆ ನಾವು ಅವರನ್ನು ನುಂಗಿಬಿಡುವೆವು. ಅವರ ಆಶ್ರಯವು ಅವರ ಬಳಿಯಿಂದ ಹೋಯಿತು. ಯೆಹೋವ ದೇವರು ನಮ್ಮ ಸಂಗಡ ಇದ್ದಾರೆ, ಅವರಿಗೆ ಭಯಪಡಬೇಡಿರಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ಆಗ ಸಭೆಯವರೆಲ್ಲರೂ ಅವರಿಗೆ ಕಲ್ಲೆಸೆಯಬೇಕೆಂದಿದ್ದರು. ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯು ದೇವದರ್ಶನ ಗುಡಾರದಲ್ಲಿ ಇಸ್ರಾಯೇಲರಿಗೆಲ್ಲಾ ಪ್ರತ್ಯಕ್ಷವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಈ ಜನರು ಎಷ್ಟರವರೆಗೆ ನನಗೆ ಕೋಪವನ್ನೆಬ್ಬಿಸುವರು? ನಾನು ಅವರ ಮಧ್ಯದಲ್ಲಿ ಮಾಡಿದ ಸಕಲ ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ಕಣ್ಣಾರೆ ನೋಡಿಯೂ ನನ್ನನ್ನು ಎಷ್ಟು ಮಾತ್ರಕ್ಕು ನಂಬದೆ ಇರುವರು? ");
INSERT INTO kanokcv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ನಾನು ಅವರನ್ನು ವ್ಯಾಧಿಯಿಂದ ಹೊಡೆದು ನಿರ್ಮೂಲ ಮಾಡುವೆನು. ನಿನ್ನನ್ನು ಅವರಿಗಿಂತ ದೊಡ್ಡದಾದ ಮತ್ತು ಬಲವುಳ್ಳ ಜನಾಂಗವನ್ನಾಗಿ ಮಾಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ಆಗ ಮೋಶೆ ಯೆಹೋವ ದೇವರಿಗೆ, “ಹಾಗಾದರೆ ಈ ಸುದ್ದಿಯನ್ನು ಈಜಿಪ್ಟಿನವರು ಕೇಳುವರು. ನೀವು ಅವರಿಂದ ಈ ಜನರನ್ನು ನಿಮ್ಮ ಶಕ್ತಿಯಿಂದ ಬರಮಾಡಿದೆಯಲ್ಲಾ! ");
INSERT INTO kanokcv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ಅವರು ಈ ದೇಶದ ನಿವಾಸಿಗಳಿಗೆ ಅದನ್ನು ಹೇಳುವರು. ನೀವು ಈ ಜನರ ಸಂಗಡ ಇದ್ದೀಯೆಂದೂ, ಯೆಹೋವ ದೇವರಾದ ನೀವೇ ಮುಖಾಮುಖಿಯಾಗಿ ಕಾಣಿಸಿಕೊಳ್ಳುತ್ತೀರಿ ಎಂದೂ ನೀವು ಹಗಲು ಹೊತ್ತಿನಲ್ಲಿ ಮೇಘಸ್ತಂಭದಲ್ಲಿಯೂ, ರಾತ್ರಿಯಲ್ಲಿ ಅಗ್ನಿಸ್ತಂಭದಲ್ಲಿಯೂ ಅವರ ಮುಂದೆ ನಡೆಯುತ್ತೀರಿ ಎಂದೂ ನೀವಿರುವ ಮೇಘವು ಇಸ್ರಾಯೇಲರ ಮೇಲೆ ಇರುವುದಾಗಿಯೂ ಎಂದೂ ಅವರು ಈಗಾಗಲೇ ಕೇಳಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ಈಗ ನೀವು ಈ ಜನರನ್ನೆಲ್ಲಾ ಕೊಂದುಹಾಕಿದರೆ, ನಿಮ್ಮ ಪ್ರಖ್ಯಾತಿಯನ್ನು ಕೇಳಿದ ಜನಾಂಗಗಳು ನಿಮ್ಮ ವಿಷಯದಲ್ಲಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","ಯೆಹೋವ ದೇವರು ಈ ಜನರನ್ನು ಅವರಿಗೆ ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನಮಾಡಿದ ದೇಶಕ್ಕೆ ತರಲಾರದ ಕಾರಣ ಅವರನ್ನು ಮರುಭೂಮಿಯಲ್ಲಿ ಕೊಂದುಹಾಕಿದರು,” ಎಂದು ಹೇಳುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“ಈಗ ನೀವು ಹೇಳಿದ ಪ್ರಕಾರ ಯೆಹೋವ ದೇವರ ಶಕ್ತಿಯು ದೊಡ್ಡದಾಗಿರಲಿ ಎಂದು ನಾನು ಬೇಡುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","ಯೆಹೋವ ದೇವರು ದೀರ್ಘಶಾಂತನು, ಮಹಾ ಪ್ರೀತಿಯುಳ್ಳವನು, ತಿರುಗಿಬೀಳುವುದನ್ನು ಮತ್ತು ಪಾಪವನ್ನು ಕ್ಷಮಿಸುವಾತನು, ಆದರೂ ಅಪರಾಧಿಯನ್ನು ಶಿಕ್ಷಿಸದೆ ಬಿಡದವನೂ ತಂದೆಗಳ ದೋಷವನ್ನು ಮಕ್ಕಳ ಮೇಲೆಯೂ ಮೊಮ್ಮಕ್ಕಳ ಮೇಲೆಯೂ ಮೂರನೆಯ ಮತ್ತು ನಾಲ್ಕನೆಯ ತಲೆಗಳವರೆಗೂ ಶಿಕ್ಷಿಸುವಾತನೂ ಎಂದು ನೀವು ಹೇಳಿದ್ದೀರಲ್ಲಾ? ");
INSERT INTO kanokcv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ನಿಮ್ಮ ಪ್ರೀತಿಯು ದೊಡ್ಡದಾಗಿರುವ ಪ್ರಕಾರವೂ ನೀವು ಈಜಿಪ್ಟಿನಿಂದ ಇಲ್ಲಿಯವರೆಗೆ ಈ ಜನರ ಪಾಪಗಳನ್ನು ಮನ್ನಿಸಿದ ಪ್ರಕಾರ ಈಗಲೂ ಈ ಜನರ ಪಾಪವನ್ನು ಮನ್ನಿಸಿರಿ,” ಎಂದು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ಆಗ ಯೆಹೋವ ದೇವರು, “ನಿನ್ನ ಮಾತಿನ ಪ್ರಕಾರ ಮನ್ನಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ಆದರೆ ನನ್ನ ಜೀವದಾಣೆ, ಭೂಮಿಯೆಲ್ಲಾ ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯಿಂದ ತುಂಬಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ಏಕೆಂದರೆ ನನ್ನ ಮಹಿಮೆಯನ್ನೂ, ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿಯೂ, ಮರುಭೂಮಿಯಲ್ಲಿಯೂ ನಾನು ಮಾಡಿದ ಸೂಚಕಕಾರ್ಯಗಳನ್ನೂ ನೋಡಿದ ಈ ಸಕಲ ಜನರು, ನನ್ನನ್ನು ಈಗ ಹತ್ತು ಸಾರಿ ಪರೀಕ್ಷಿಸಿ, ನನ್ನ ಮಾತನ್ನು ಕೇಳದೆ ಹೋದದ್ದರಿಂದ, ");
INSERT INTO kanokcv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ನಾನು ಅವರ ಪಿತೃಗಳಿಗೆ ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶವನ್ನು ನಿಶ್ಚಯವಾಗಿ ಅವರು ನೋಡುವುದಿಲ್ಲ, ನನ್ನನ್ನು ಅಲಕ್ಷ್ಯ ಮಾಡಿದವರೆಲ್ಲರೂ ಅದನ್ನು ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ಆದರೆ ನನ್ನ ಸೇವಕನಾದ ಕಾಲೇಬನಲ್ಲಿ ಬೇರೆ ಆತ್ಮವಿದ್ದುದರಿಂದಲೂ, ಅವನು ಹೃದಯಪೂರ್ವಕವಾಗಿ ನನ್ನನ್ನು ಹಿಂಬಾಲಿಸಿದ್ದುದರಿಂದಲೂ ಅವನು ಸಂಚರಿಸಿ ಬಂದ ಆ ದೇಶಕ್ಕೆ ಅವನನ್ನು ಸೇರಿಸುವೆನು. ಅವನ ಸಂತಾನವು ಅದನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ಅಮಾಲೇಕ್ಯರೂ, ಕಾನಾನ್ಯರೂ ತಗ್ಗಿನಲ್ಲಿ ವಾಸ ಮಾಡುತ್ತಿರುವುದರಿಂದ ನಾಳೆ ನೀವು ತಿರುಗಿಕೊಂಡು, ಕೆಂಪುಸಮುದ್ರದ ಮಾರ್ಗವಾಗಿ ಮರುಭೂಮಿಗೆ ಹೊರಡಿರಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಆರೋನನ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ಈ ದುಷ್ಟಜನರು ನನಗೆ ವಿರೋಧವಾಗಿ ಗೊಣಗುಟ್ಟುವುದನ್ನು ನಾನು ಎಷ್ಟು ಕಾಲ ಸಹಿಸಲಿ? ಇಸ್ರಾಯೇಲರು ನನಗೆ ವಿರೋಧವಾಗಿ ಗೊಣಗುಟ್ಟಿದ್ದನ್ನು ನಾನು ಕೇಳಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ಆದ್ದರಿಂದ ನೀನು ಅವರಿಗೆ, ‘ನನ್ನ ಜೀವದಾಣೆ, ನೀವು ನನ್ನ ಕಿವಿಗಳು ಕೇಳುವಂತೆ ಮಾತನಾಡಿದ ಪ್ರಕಾರವೇ ನಿಮಗೆ ಮಾಡುವೆನು,’ ಎಂದು ಯೆಹೋವ ದೇವರು ಹೇಳುತ್ತಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ಈ ಮರುಭೂಮಿಯಲ್ಲಿ ನನಗೆ ವಿರೋಧವಾಗಿ ಗೊಣಗುಟ್ಟಿದವರೆಲ್ಲರೂ ನಿಮ್ಮ ಪೂರ್ಣ ಸಂಖ್ಯೆಯ ಪ್ರಕಾರ ಎಣಿಸಿದ ಇಪ್ಪತ್ತು ವರುಷವೂ, ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳವರೂ ಸತ್ತು ಹೋಗುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ಯೆಫುನ್ನೆಯ ಮಗ ಕಾಲೇಬನೂ, ನೂನನ ಮಗ ಯೆಹೋಶುವನ ಹೊರತು ನಾನು ನಿಮ್ಮನ್ನು ವಾಸಮಾಡುವುದಕ್ಕೆ ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶಕ್ಕೆ ನಿಸ್ಸಂದೇಹವಾಗಿ ನೀವೆಲ್ಲರೂ ಬಾರದೆ ಇರುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ಆದರೆ ಸೆರೆಯಾಗುವರೆಂದು ನೀವು ಹೇಳಿದ ನಿಮ್ಮ ಮಕ್ಕಳನ್ನು ಅಲ್ಲಿಗೆ ತರುವೆನು, ನೀವು ಅಲಕ್ಷ್ಯಮಾಡಿದ ದೇಶವನ್ನು ಅವರು ಅನುಭವಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ನಿಮ್ಮ ವಿಷಯವಾಗಿಯಾದರೋ ನಿಮ್ಮ ಹೆಣಗಳು ಈ ಮರುಭೂಮಿಯಲ್ಲಿ ಬೀಳುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ಇದಲ್ಲದೆ ನಿಮ್ಮ ಮಕ್ಕಳು ನಲವತ್ತು ವರುಷ ಮರುಭೂಮಿಯಲ್ಲಿ ಅಲೆದಾಡಿ, ನಿಮ್ಮ ಹೆಣಗಳು ಮರುಭೂಮಿಯಲ್ಲಿ ಹಾಳಾಗಿ ಹೋಗುವ ತನಕ ನಿಮ್ಮ ಅಪನಂಬಿಗಸ್ತಿಕೆಯನ್ನು ಅನುಭವಿಸುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ನೀವು ಆ ದೇಶವನ್ನು ಪರೀಕ್ಷಿಸಿದ ನಲವತ್ತು ದಿವಸಗಳ ಪ್ರಕಾರ ಒಂದು ದಿನಕ್ಕೆ ಒಂದು ವರುಷವಾಗಿ ಈ ಪ್ರಕಾರ ನಲವತ್ತು ವರುಷ ನಿಮ್ಮ ಅಪರಾಧಗಳನ್ನು ಹೊತ್ತು, ನನ್ನ ವಾಗ್ದಾನವನ್ನು ಭಂಗಪಡಿಸಿದ ಫಲವನ್ನು ನೀವು ಅನುಭವಿಸುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ಯೆಹೋವ ದೇವರಾದ ನಾನು ಇದನ್ನು ಮಾತನಾಡಿದ್ದೇನೆ. ನನಗೆ ವಿರೋಧವಾಗಿ ಸೇರಿರುವ ಈ ದುಷ್ಟ ಸಭೆಗೆಲ್ಲಾ ಇದನ್ನು ನಿಶ್ಚಯವಾಗಿ ಮಾಡುವೆನು. ಈ ಮರುಭೂಮಿಯಲ್ಲಿ ಅವರು ಕ್ಷೀಣವಾಗಿ ಅದರಲ್ಲೇ ಸಾಯುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ದೇಶವನ್ನು ಪರೀಕ್ಷಿಸುವುದಕ್ಕೆ ಮೋಶೆಯ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಹಿಂದಿರುಗಿ, ಆ ದೇಶದ ವಿಷಯವಾಗಿ ಕೆಟ್ಟ ಸುದ್ದಿಯನ್ನು ಎಬ್ಬಿಸಿ, ಸಮಸ್ತ ಸಭೆಯನ್ನು ಮೋಶೆಗೆ ವಿರೋಧವಾಗಿ ಗೊಣಗುಟ್ಟುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ಅಶುಭ ಸಮಾಚಾರವನ್ನು ತಂದ ಆ ಮನುಷ್ಯರು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ವ್ಯಾಧಿಯಿಂದ ಸತ್ತರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ಆದರೆ ದೇಶವನ್ನು ಪರೀಕ್ಷಿಸುವುದಕ್ಕೆ ಹೋದ ಮನುಷ್ಯರೊಳಗೆ ಇಬ್ಬರಾದ ನೂನನ ಮಗ ಯೆಹೋಶುವನೂ, ಯೆಫುನ್ನೆಯ ಮಗ ಕಾಲೇಬನೂ ಉಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ ಈ ಮಾತುಗಳನ್ನು ಹೇಳಿದಾಗ, ಜನರು ಬಹಳವಾಗಿ ದುಃಖಪಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ಮರುದಿವಸ ಬೆಳಿಗ್ಗೆ ಅವರು ಎದ್ದು, ಬೆಟ್ಟದ ತುದಿಯ ಮೇಲಕ್ಕೆ ಏರಿ, “ಇಗೋ, ಯೆಹೋವ ದೇವರು ವಾಗ್ದಾನ ಮಾಡಿದ ಸ್ಥಳಕ್ಕೆ ಏರಿ ಹೋಗುವುದಕ್ಕೆ ಇದ್ದೇವೆ. ನಾವು ಪಾಪಮಾಡಿದ್ದೇವೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ಆಗ ಮೋಶೆಯು, “ನೀವು ಏಕೆ ಹೀಗೆ ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯನ್ನು ಮೀರುತ್ತೀರಿ? ಅದು ಸಫಲವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ಸಂಗಡ ಇಲ್ಲ ಅದಕ್ಕಾಗಿ ನಿಮ್ಮ ಶತ್ರುಗಳು ನಿಮ್ಮನ್ನು ಪರಾಜಯಗೊಳಿಸದಂತೆ ಏರಿ ಹೋಗಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ಅಮಾಲೇಕ್ಯರೂ, ಕಾನಾನ್ಯರೂ ನಿಮ್ಮ ಎದುರಿನಲ್ಲಿರುವುದರಿಂದ ನೀವು ಅವರ ಖಡ್ಗಕ್ಕೆ ತುತ್ತಾಗುವಿರಿ. ನೀವು ಯೆಹೋವ ದೇವರ ಕಡೆಯಿಂದ ತಿರುಗಿದ ಕಾರಣ, ಆತನು ನಿಮ್ಮ ಸಂಗಡ ಇರುವುದಿಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ಆದರೆ ಅವರು ಹಟಮಾಡಿ, ಬೆಟ್ಟದ ತುದಿಯ ಮೇಲೆ ಏರಿಹೋದರು. ಆದರೆ ಯೆಹೋವ ದೇವರ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷವೂ ಮೋಶೆಯೂ ಪಾಳೆಯದಿಂದ ಹೊರಡಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ಆಗ ಆ ಬೆಟ್ಟದಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಅಮಾಲೇಕ್ಯರೂ, ಕಾನಾನ್ಯರೂ ಇಳಿದು, ಅವರನ್ನು ಹೊಡೆದು, ಹೊರ್ಮಾದವರೆಗೆ ಅಟ್ಟಿಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರಿಗೆ, ‘ನಾನು ನಿಮಗೆ ಕೊಡುವ ನಿಮ್ಮ ನಿವಾಸಗಳ ದೇಶಕ್ಕೆ ಬಂದಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ಯೆಹೋವ ದೇವರಿಗೆ ಪಶುಗಳಿಂದಾದರೂ ಕುರಿಗಳಿಂದಾದರೂ ಸುವಾಸನೆಯನ್ನುಂಟುಮಾಡುವ ದಹನಬಲಿಯಾಗಲಿ, ಹರಕೆಯನ್ನು ಈಡೇರಿಸುವ ಬಲಿಯನ್ನಾಗಲಿ, ಉಚಿತವಾದ ಸಮರ್ಪಣೆಯಾಗಲಿ, ನಿಮ್ಮ ಪವಿತ್ರ ಹಬ್ಬಗಳಲ್ಲಿಯಾಗಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಅರ್ಪಿಸಲಾಗಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ಅದರೊಂದಿಗೆ ಯೆಹೋವ ದೇವರಿಗೆ ತನ್ನ ಬಲಿಯನ್ನು ಅರ್ಪಿಸುವಾಗ ಧಾನ್ಯ ಅರ್ಪಣೆಗಾಗಿ ಸುಮಾರು ಒಂದುವರೆ ಕಿಲೋಗ್ರಾಂ ಗೋಧಿ ಹಿಟ್ಟನ್ನು ಒಂದು ಲೀಟರ್ ಓಲಿವ್ ಎಣ್ಣೆಗೆ ಬೆರೆಸಲಾಗುತ್ತದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ಪಾನದ ಅರ್ಪಣೆಗಾಗಿ ದಹನಬಲಿಯ ಸಂಗಡ ಒಂದು ಕುರಿಗೋಸ್ಕರ ಒಂದು ಲೀಟರ್ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘ಟಗರನ್ನು ಅರ್ಪಿಸುವಾಗ ಅದರೊಂದಿಗೆ ಧಾನ್ಯ ಅರ್ಪಣೆಗಾಗಿ ಸುಮಾರು ಒಂದೂವರೆ ಲೀಟರ್ ಓಲಿವ್ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಮೂರು ಕಿಲೋಗ್ರಾಂ ನಯವಾದ ಹಿಟ್ಟನ್ನು ನೀನು ಸಿದ್ಧಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ಪಾನದ ಸಮರ್ಪಣೆಯಾಗಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಗಾಗಿ ಒಂದು ಲೀಟರ್ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘ನೀನು ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಗಾಗಿ ಇಲ್ಲವೆ ಪ್ರಮಾಣವನ್ನು ಈಡೇರಿಸುವ ಬಲಿಗಾಗಿ ಇಲ್ಲವೆ ಸಮಾಧಾನದ ಬಲಿಗಳಿಗಾಗಿ ಹೋರಿಯನ್ನು ನೀನು ಸಿದ್ಧಮಾಡುವಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ನೀವು ಆ ಹೋರಿಯೊಂದಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯಾಗಿ ಸುಮಾರು ಎರಡು ಲೀಟರ್ ಓಲಿವ್ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಐದು ಕಿಲೋಗ್ರಾಂ ಗೋಧಿ ಹಿಟ್ಟನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ಇದಲ್ಲದೆ, ಪಾನದ್ರವ್ಯಕ್ಕಾಗಿ ಒಂದುವರೆ ಲೀಟರ್ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಇದು ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾದ ದಹನಬಲಿಯಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ಹೀಗೆ ಒಂದು ಹೋರಿ, ಟಗರು, ಕುರಿಮರಿ, ಮೇಕೆ, ಇವುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದು ಬಲಿಪ್ರಾಣಿಯ ಸಂಗಡ ಈ ಪ್ರಕಾರ ಮಾಡತಕ್ಕದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ನೀವು ಸಿದ್ಧಪಡಿಸಿದ ಬಲಿಗಳ ಲೆಕ್ಕದ ಪ್ರಕಾರ ನೀವು ಒಂದೊಂದನ್ನು ಅದರ ಲೆಕ್ಕದ ಪ್ರಕಾರ ಮಾಡತಕ್ಕದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘ಯೆಹೋವ ದೇವರಿಗೆ ಸುಗಂಧದ ದಹನಬಲಿಯನ್ನು ಅರ್ಪಿಸುವಾಗ ಸ್ಥಳೀಯ ಮೂಲದ ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಇವುಗಳನ್ನು ಈ ರೀತಿಯಾಗಿಯೇ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ನಿಮ್ಮ ಸಂಗಡ ಪ್ರಯಾಣ ಮಾಡುವ ಪರದೇಶಿಯಾಗಲಿ ಇಲ್ಲವೆ ನಿಮ್ಮ ಮುಂದಿನ ಸಂತತಿಯವರ ಸಂಗಡ ಇರುವವನಾಗಲಿ, ಯೆಹೋವ ದೇವರಿಗೆ ಸುಗಂಧದ ದಹನಬಲಿಯನ್ನು ಸಮರ್ಪಿಸಿದಾಗ, ನೀವು ಹೇಗೆ ಮಾಡುತ್ತೀರೋ ಹಾಗೆಯೇ ಅವನು ಮಾಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ನಿಮಗೂ ನಿಮ್ಮ ಕೂಡ ಪ್ರಯಾಣ ಮಾಡುವ ಪರಕೀಯನಿಗೂ ಒಂದೇ ಕಟ್ಟಳೆ ಇರಬೇಕು. ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ನೀವು ಇರುವ ಪ್ರಕಾರ ಪರಕೀಯನೂ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ನಿಮಗೂ, ನಿಮ್ಮ ಕೂಡ ಪ್ರಯಾಣ ಮಾಡುವ ಪರಕೀಯನಿಗೂ ಒಂದೇ ಪ್ರಮಾಣವೂ ಒಂದೇ ನ್ಯಾಯವೂ ಇರಬೇಕು,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರಿಗೆ: ‘ನಾನು ನಿಮ್ಮನ್ನು ಕರೆದುಕೊಂಡುಹೋಗುವ ದೇಶಕ್ಕೆ ನೀವು ಸೇರಿದನಂತರ, ");
INSERT INTO kanokcv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ಆ ದೇಶದ ಆಹಾರವನ್ನು ತಿನ್ನುವಾಗ, ನೀವು ಅದರಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ನೀವು ಕಣದಲ್ಲಿರುವ ಗೋಧಿಯಲ್ಲಿ ಪ್ರಥಮ ಫಲವನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಅರ್ಪಿಸುವಂತೆ ಕಣಕದಿಂದ ಮಾಡುವ ನಿಮ್ಮ ಪ್ರಥಮ ಬೀಸಿದ ಹಿಟ್ಟಿನ ರೊಟ್ಟಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ನೀವು ಮತ್ತು ನಿಮ್ಮ ಸಂತತಿಯವರು ನಿಮ್ಮ ಕಣದಿಂದ ಮಾಡಿದ ಪ್ರಥಮ ರೊಟ್ಟಿಯನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘ನೀವು ತಪ್ಪಿ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ ಈ ಸಕಲ ಆಜ್ಞೆಗಳ ಪ್ರಕಾರ ಮಾಡದಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ನಿಮಗೆ ಆಜ್ಞೆಗಳನ್ನು ಕೊಟ್ಟ ದಿವಸ ಮೊದಲುಗೊಂಡು, ನಿಮ್ಮ ಸಂತತಿಗಳವರೆಗೂ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಕೈಯಿಂದ ನಿಮಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ನೀವು ಮಾಡದೆ ಹೋದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ಅದು ಸಭೆಗೆ ತಿಳಿಯದೆ ತಪ್ಪು ಆಗಿರುವ ಪಕ್ಷದಲ್ಲಿ, ಸಭೆಯು ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾದ ದಹನಬಲಿಗಾಗಿ ಒಂದು ಎಳೆಯ ಹೋರಿಯನ್ನು ಕ್ರಮದ ಪ್ರಕಾರ ಅದರ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ, ಪಾನದ ಸಮರ್ಪಣೆಯನ್ನೂ, ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಮೇಕೆಗಳಿಂದ ಒಂದು ಹೋತವನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ಯಾಜಕನು ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಸಭೆಗೋಸ್ಕರ ಅವರಿಗೆ ಕ್ಷಮೆಯಾಗುವ ಹಾಗೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಏಕೆಂದರೆ ಅದು ತಿಳಿಯದೆ ಮಾಡಲಾಗಿತ್ತು. ಆದರೂ ಅವರು ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಯಾಗಿ ತಮ್ಮ ಸಮರ್ಪಣೆಯನ್ನೂ, ತಮ್ಮ ತಪ್ಪಿಗೋಸ್ಕರ ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯನ್ನೂ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ಆಗ ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಸಮೂಹದವರಿಗೂ, ಅವರೊಳಗೆ ಪರಕೀಯನಾಗಿ ಪ್ರವಾಸಿಯಾಗಿರುವವನಿಗೂ ಅದು ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ಏಕೆಂದರೆ ಎಲ್ಲರೂ ತಿಳುವಳಿಕೆ ಇಲ್ಲದವರಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘ಯಾವನಾದರೂ ಒಬ್ಬನು ತಿಳಿಯದೆ ಪಾಪ ಮಾಡುವುದಾದರೆ, ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ವರ್ಷದ ಮೇಕೆಯನ್ನು ತರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ತಿಳಿಯದೆ ಪಾಪ ಮಾಡಿದವನಿಗೋಸ್ಕರ ಯಾಜಕನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ಅದು ಪಾಪಕ್ಷಮಾಪಣೆಯಾಗುವ ಹಾಗೆ ಅದಕ್ಕೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ಸ್ಥಳೀಯ ಮೂಲದ ಇಸ್ರಾಯೇಲರಿಗೂ ಅವರಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿರುವ ಪರಕೀಯನಿಗೂ ತಿಳಿಯದೆ ಪಾಪಮಾಡಿದವನಿಗೂ ಒಂದೇ ನಿಯಮ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘ಯಾವನಾದರೂ ಅಂದರೆ ದೇಶದಲ್ಲಿ ಹುಟ್ಟಿದವನಾಗಲಿ, ಪರಕೀಯನಾಗಲಿ ಬೇಕೆಂದು ಪಾಪಮಾಡಿದರೆ, ಅವನು ಯೆಹೋವ ದೇವರನ್ನು ನಿಂದಿಸಿದ್ದಾನೆ. ಆ ಮನುಷ್ಯನನ್ನು ಸ್ವಜನರಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ಅವನು ಯೆಹೋವ ದೇವರ ವಾಕ್ಯವನ್ನು ಅವಮಾನ ಮಾಡಿ, ಅವರ ಆಜ್ಞೆಗಳನ್ನು ಮೀರಿದ್ದರಿಂದ, ಆ ಮನುಷ್ಯನನ್ನು ನಿಶ್ಚಯವಾಗಿ ತೆಗೆದುಹಾಕಬೇಕು. ಅವನ ಅಕ್ರಮವು ಅವನ ಮೇಲೆ ಇರುವುದು,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ಇಸ್ರಾಯೇಲರು ಮರುಭೂಮಿಯಲ್ಲಿದ್ದಾಗ, ಅವರು ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ಸೌದೆಯನ್ನು ಕೂಡಿಸುವ ಒಬ್ಬನನ್ನು ಕಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ಆಗ ಸೌದೆ ಕೂಡಿಸುವುದನ್ನು ಕಂಡುಕೊಂಡವರು ಅವನನ್ನು ಮೋಶೆ ಆರೋನರ ಬಳಿಗೆ ಮತ್ತು ಸಮಸ್ತ ಸಮುದಾಯದ ಬಳಿಗೆ ತಂದು, ");
INSERT INTO kanokcv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ಅವನಿಗೆ ಏನು ಮಾಡಬೇಕೆಂದು ಸ್ಪಷ್ಟವಾಗಿ ತಿಳಿಯದ ಕಾರಣ, ಅವನನ್ನು ಕಾವಲಲ್ಲಿ ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಆ ಮನುಷ್ಯನು ಖಂಡಿತವಾಗಿಯೂ ಸಾಯಲೇಬೇಕು, ಸಭೆಯೆಲ್ಲಾ ಪಾಳೆಯದ ಹೊರಗೆ ಅವನನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ಆಗ ಸಮೂಹದವರೆಲ್ಲಾ ಅವನನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡುಹೋಗಿ, ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವನನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ: ‘ಅವರು ತಮ್ಮ ತಲತಲಾಂತರಗಳಲ್ಲಿ ತಮ್ಮ ವಸ್ತ್ರಗಳ ಸೆರಗುಗಳ ಅಂಚಿನಲ್ಲಿ ಗೊಂಡೆಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬೇಕು. ಸೆರಗಿನ ಗೊಂಡೆಗಳ ಮೇಲೆ ನೀಲಿ ದಾರವನ್ನು ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ಅದನ್ನು ನೀವು ಗೊಂಡೆಯಾಗಿ ಇಟ್ಟುಕೊಂಡು, ಅದನ್ನು ನೋಡುವಾಗ, ಯೆಹೋವ ದೇವರ ಸಕಲ ಆಜ್ಞೆಗಳನ್ನು ನೆನಸಿ ಅವುಗಳ ಪ್ರಕಾರಮಾಡಿ, ನಿಮ್ಮ ಹೃದಯ ಹಾಗೂ ಇಚ್ಛೆಗನುಸಾರ ನಿಮ್ಮ ಕಣ್ಣುಗಳು ಜಾರತ್ವ ಮಾಡುವಂತೆ ಹಿಂಬಾಲಿಸದೆ ಇರುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ನೀವು ನನ್ನ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ನೆನಸಿ, ಅವುಗಳ ಪ್ರಕಾರಮಾಡಿ, ನಿಮ್ಮ ದೇವರಿಗೆ ಪ್ರತಿಷ್ಠಿತರಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ನಾನು ನಿಮ್ಮ ದೇವರಾಗುವದಕ್ಕೆ ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ತಂದ ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರು ನಾನೇ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ಆಗ ಲೇವಿಯ ಮಗನಾದ ಕೊಹಾತನ ಮೊಮ್ಮಗ ಇಚ್ಹಾರನ ಮಗ ಕೋರಹನೂ ರೂಬೇನ್ ಗೋತ್ರದವರಾದ ಎಲೀಯಾಬನ ಮಕ್ಕಳಾದ ದಾತಾನನೂ ಅಬೀರಾಮನೂ ಮತ್ತು ಪೆಲೆತನ ಮಗನಾದ ಓನನೂ ಜನರನ್ನು ತೆಗೆದುಕೊಂಡು ");
INSERT INTO kanokcv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ಇಸ್ರಾಯೇಲರೊಳಗಿಂದ ಸಭೆಯ ಪ್ರಧಾನರಾಗಿಯೂ ಸಭೆಯ ಪ್ರಸಿದ್ಧರಾಗಿಯೂ ಹೆಸರು ಹೊಂದಿದವರಾಗಿಯೂ ಇರುವ ಇನ್ನೂರ ಐವತ್ತು ಮಂದಿಯೊಂದಿಗೆ ಮೋಶೆಗೆ ಎದುರಾಗಿ ತಿರುಗಿಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ಅವರು ಮೋಶೆಗೂ, ಆರೋನನಿಗೂ ವಿರೋಧವಾಗಿ ಕೂಡಿಕೊಂಡು, “ನೀವು ಹೆಚ್ಚು ಅಧಿಕಾರ ತೆಗೆದುಕೊಳ್ಳುತ್ತೀರಿ, ಏಕೆಂದರೆ ಈ ಸಮೂಹದಲ್ಲಿರುವ ಎಲ್ಲರೂ ಪರಿಶುದ್ಧರು. ಯೆಹೋವ ದೇವರು ಅವರ ಮಧ್ಯದಲ್ಲಿದ್ದಾರೆ. ಹೀಗಿರಲಾಗಿ ನಿಮ್ಮನ್ನು ನೀವೇ ಹೆಚ್ಚಿಸಿಕೊಳ್ಳುವುದು ಏಕೆ?” ಎಂದು ಅವರಿಗೆ ಕೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ಮೋಶೆಯು ಇದನ್ನು ಕೇಳಿದಾಗ, ಬೋರಲು ಬಿದ್ದು, ");
INSERT INTO kanokcv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ಕೋರಹನಿಗೂ, ಅವನ ಸಮಸ್ತ ಸಮೂಹಕ್ಕೂ, “ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಹತ್ತಿರ ಬರಮಾಡಿಕೊಳ್ಳುವ ಹಾಗೆ ತನ್ನವರು ಯಾರಾರೆಂಬುದನ್ನು ಮತ್ತು ಪರಿಶುದ್ಧ ಯಾರು ಎಂಬುದನ್ನು ನಾಳೆ ತೋರಿಸುವರು. ಅವರು ಯಾರನ್ನು ಆಯ್ದುಕೊಳ್ಳುವರೋ, ಅವರನ್ನು ಹತ್ತಿರ ಬರಮಾಡಿಕೊಳ್ಳುವರು. ನೀವು ಇದನ್ನು ಮಾಡಿರಿ: ");
INSERT INTO kanokcv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ಕೋರಹನೂ, ಅವನ ಸಮೂಹವೆಲ್ಲವೂ ಧೂಪ ಸುಡುವ ಪಾತ್ರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ನಾಳೆ ಅವುಗಳಲ್ಲಿ ಬೆಂಕಿಯನ್ನು ಹಾಕಿ, ಅವುಗಳ ಮೇಲೆ ಧೂಪವನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಹಾಕಿರಿ. ಆಗ ಯೆಹೋವ ದೇವರು ಯಾವನನ್ನು ಆಯ್ದುಕೊಳ್ಳುವರೋ ಅವನೇ ಪರಿಶುದ್ಧನಾಗಿರುವನು. ಲೇವಿಯರೇ, ನೀವು ಬಹಳ ಮಿತಿಮೀರಿ ಹೋಗುತ್ತಿರುವಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ಮೋಶೆಯು ಕೋರಹನಿಗೆ, “ಲೇವಿಯ ಪುತ್ರರೇ, ಈಗ ಕೇಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ಯೆಹೋವ ದೇವರ ಗುಡಾರದ ಸೇವೆಯನ್ನು ಮಾಡುವುದಕ್ಕೂ, ಸಮೂಹದ ಮುಂದೆ ಇರುವ ಅವರ ಸೇವೆಯಲ್ಲಿ ನಿಲ್ಲುವುದಕ್ಕೂ ಇಸ್ರಾಯೇಲರ ದೇವರು ನಿಮ್ಮನ್ನು ಹತ್ತಿರ ಬರಮಾಡಿಕೊಳ್ಳುವ ವಿಷಯದಲ್ಲಿ ಇಸ್ರಾಯೇಲರೊಳಗಿಂದಲೇ ನಿಮ್ಮನ್ನು ಪ್ರತ್ಯೇಕಿಸಿದ್ದು, ನಿಮಗೆ ಅಲ್ಪವಾಗಿ ತೋರಿತೋ? ");
INSERT INTO kanokcv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ದೇವರು ನಿನ್ನನ್ನೂ, ನಿನ್ನ ಸಂಗಡ ಲೇವಿಯ ಪುತ್ರರಾದ ನಿನ್ನ ಸಹೋದರರೆಲ್ಲರನ್ನೂ ತಮ್ಮ ಹತ್ತಿರ ಬರಮಾಡಿಕೊಂಡಿದ್ದಾರೆ. ನೀವು ಯಾಜಕತ್ವವನ್ನು ಸಹ ಹುಡುಕುತ್ತೀರೋ? ");
INSERT INTO kanokcv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ಈ ಕಾರಣದಿಂದ ನೀನೂ, ನಿನ್ನ ಸಮಸ್ತ ಗುಂಪು ಯೆಹೋವ ದೇವರಿಗೆ ವಿರೋಧವಾಗಿ ಒಟ್ಟಾಗಿ ಕೂಡಿಕೊಂಡಿರಿ. ನೀವು ಆರೋನನಿಗೆ ವಿರೋಧವಾಗಿ ಗೊಣಗುಟ್ಟುವುದು ಯಾಕೆ?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ಆಗ ಮೋಶೆ ಎಲೀಯಾಬನ ಪುತ್ರರಾದ ದಾತಾನನನ್ನೂ, ಅಬೀರಾಮನನ್ನೂ ಕರೆಯಕಳುಹಿಸಿದನು. ಆದರೆ ಅವರು, “ನಾವು ಬರುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ನೀನು ಮರುಭೂಮಿಯಲ್ಲಿ ನಮ್ಮನ್ನು ಸಾಯಿಸುವುದಕ್ಕೆ ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶದೊಳಗಿಂದ ನಮ್ಮನ್ನು ಹೊರಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಂದದ್ದು ನಿನಗೆ ಸಾಕಾಗಲಿಲ್ಲವೋ? ನೀನು ಅರಸನಾಗಿ ನಮ್ಮನ್ನು ಆಳಬೇಕೋ? ");
INSERT INTO kanokcv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ಅಷ್ಟುಮಾತ್ರವಲ್ಲದೆ, ನೀನು ನಮ್ಮನ್ನು ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಬರಲಿಲ್ಲ. ಹೊಲಗಳನ್ನೂ ದ್ರಾಕ್ಷಿತೋಟಗಳನ್ನೂ ನಮಗೆ ಸ್ವಾಧೀನಕ್ಕೆ ಕೊಡಲಿಲ್ಲ. ಈ ಮನುಷ್ಯರ ಕಣ್ಣಿಗೆ ಮಣ್ಣು ಹಾಕಬೇಕೆಂದಿದ್ದೀಯೋ? ನಾವು ಬರುವುದಿಲ್ಲ!” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ಆಗ ಮೋಶೆಯು ಬಹಳವಾಗಿ ಕೋಪಿಸಿಕೊಂಡು ಯೆಹೋವ ದೇವರಿಗೆ, “ಅವರ ಬಲಿಯನ್ನು ನೀವು ಗೌರವಿಸಬೇಡಿ, ನಾನು ಅವರಿಂದ ಒಂದು ಕತ್ತೆಯನ್ನಾದರೂ ತೆಗೆದುಕೊಳ್ಳಲಿಲ್ಲ. ಅವರಲ್ಲಿ ಒಬ್ಬನಿಗಾದರೂ ಕೇಡು ಮಾಡಲಿಲ್ಲ,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ಮೋಶೆಯು ಕೋರಹನಿಗೆ, “ನೀನೂ, ನಿನ್ನ ಸಮೂಹವೆಲ್ಲವೂ ಯೆಹೋವ ದೇವರ ಎದುರಿನಲ್ಲಿ ಇರಬೇಕು. ನೀನೂ, ಅವರೂ, ಆರೋನನೂ ನಾಳೆ ಬಂದು, ");
INSERT INTO kanokcv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ಒಬ್ಬೊಬ್ಬನು ತನ್ನ ತನ್ನ ಧೂಪ ಪಾತ್ರೆಯನ್ನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳಲ್ಲಿ ಧೂಪವನ್ನು ಹಾಕಿ, ಒಬ್ಬನಿಗೆ ಒಂದರ ಪ್ರಕಾರ ಇನ್ನೂರ ಐವತ್ತು ಧೂಪ ಪಾತ್ರೆಗಳಾದ ನಿಮ್ಮ ಧೂಪ ಪಾತ್ರೆಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಎದುರಿಗೆ ತನ್ನಿರಿ. ನೀನೂ, ಆರೋನನೂ, ನಿಮ್ಮ ನಿಮ್ಮ ಧೂಪದ ಪಾತ್ರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬನ್ನಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ಆಗ ಅವರು ತಮ್ಮ ತಮ್ಮ ಧೂಪ ಪಾತ್ರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳ ಮೇಲೆ ಬೆಂಕಿಯನ್ನು ಹಾಕಿ, ಧೂಪವನ್ನು ಅದರ ಮೇಲೆ ಹಾಕಿ, ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಿನ ಮುಂದೆ ಮೋಶೆ ಆರೋನರ ಸಂಗಡ ನಿಂತರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ಕೋರಹನು ಅವರಿಗೆ ಎದುರಾಗಿ ಸಮಸ್ತ ಸಮೂಹವನ್ನು ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರ ಕೂಡಿಸಿದನು. ಆಗ ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯು ಸಮಸ್ತ ಸಮೂಹಕ್ಕೆ ತೋರಿಬಂತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಆರೋನನ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ಈ ಜನರ ಮಧ್ಯದೊಳಗಿಂದ ನಿಮ್ಮನ್ನು ಪ್ರತ್ಯೇಕಿಸಿಕೊಳ್ಳಿರಿ. ನಾನು ಅವರನ್ನು ಕ್ಷಣಮಾತ್ರದಲ್ಲಿ ದಹಿಸಿಬಿಡುತ್ತೇನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ಆಗ ಅವರು ಬೋರಲು ಬಿದ್ದು, “ದೇವರೇ, ಎಲ್ಲಾ ಮಾನವರ ಆತ್ಮಗಳ ದೇವರೇ, ಒಬ್ಬ ಮನುಷ್ಯನ ಪಾಪದ ದೆಸೆಯಿಂದ ನೀವು ಸಮಸ್ತ ಸಭೆಯ ಮೇಲೆ ಕೋಪಿಸಿಕೊಳ್ಳುತ್ತೀರೋ?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ನೀನು ಜನರ ಸಮೂಹಕ್ಕೆ, ‘ಕೋರಹ, ದಾತಾನ್, ಅಬೀರಾಮರ ನಿವಾಸದ ಸುತ್ತಲಿಂದ ದೂರವಿರಬೇಕು,’ ಎಂದು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ಮೋಶೆಯು ಎದ್ದು ದಾತಾನ್, ಅಬೀರಾಮರ ಬಳಿಗೆ ಹೋದನು. ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರು ಅವನ ಹಿಂದೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ಅವನು ಸಮೂಹದವರಿಗೆ, “ನೀವು ಈ ದುಷ್ಟ ಮನುಷ್ಯರ ಡೇರೆಗಳ ಬಳಿಯಿಂದ ತೊಲಗಿಹೋಗಿರಿ. ನೀವು ಅವರ ಎಲ್ಲಾ ಪಾಪಗಳ ದೆಸೆಯಿಂದ ನಾಶವಾಗದಂತೆ ಅವರಿಗಿರುವ ಯಾವುದನ್ನು ಮುಟ್ಟಬೇಡಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ಆಗ ಅವರು ಕೋರಹನ ದಾತಾನ್, ಅಬೀರಾಮರ ಡೇರೆಗಳ ಸುತ್ತಲಿಂದ ದೂರ ಹೋದರು. ದಾತಾನನೂ, ಅಬೀರಾಮನೂ ತಮ್ಮ ಹೆಂಡತಿಯರೂ, ಪುತ್ರರೂ, ಚಿಕ್ಕ ಮಕ್ಕಳೂ ತಮ್ಮ ಗುಡಾರಗಳ ಬಾಗಿಲುಗಳಲ್ಲಿ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ಆಗ ಮೋಶೆಯು, “ಈ ಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ಮಾಡುವುದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ನನ್ನನ್ನು ಕಳುಹಿಸಿದ್ದಾರೆ, ಅವುಗಳು ನನ್ನ ಸ್ವಂತ ಆಲೋಚನೆಗಳಂತೆ ಮಾಡಲಿಲ್ಲ ಎಂದು ನೀವು ಇದರಿಂದ ತಿಳಿದುಕೊಳ್ಳುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ಇವರು ಎಲ್ಲಾ ಮನುಷ್ಯರ ಹಾಗೆ ಸತ್ತರೆ, ಇಲ್ಲವೆ ಎಲ್ಲಾ ಮನುಷ್ಯರ ಶಿಕ್ಷೆ ಇವರಿಗೂ ಪ್ರಾಪ್ತವಾದರೆ ಯೆಹೋವ ದೇವರು ನನ್ನನ್ನು ಕಳುಹಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ಆದರೆ ಯೆಹೋವ ದೇವರು ಹೊಸದನ್ನು ಮಾಡಿ, ಭೂಮಿಯು ತನ್ನ ಬಾಯಿತೆರೆದು, ಇವರನ್ನೂ, ಇವರಿಗಿರುವ ಎಲ್ಲದನ್ನೂ ನುಂಗಿ, ಇವರು ತೀವ್ರವಾಗಿ ಪಾತಾಳಕ್ಕೆ ಇಳಿಯುವಂತೆ ಮಾಡಿ, ಈ ಮನುಷ್ಯರು ಯೆಹೋವ ದೇವರನ್ನು ರೇಗಿಸಿದ್ದಾರೆಂದು ನೀವು ತಿಳಿದುಕೊಳ್ಳುವಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ಅವನು ಹೇಳ ಬೇಕಾದವುಗಳನ್ನೆಲ್ಲಾ ಹೇಳಿ ಮುಗಿಸಿದಾಗಲೇ, ಅವರ ಕೆಳಗಿರುವ ನೆಲವು ಸೀಳಿ ");
INSERT INTO kanokcv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ಭೂಮಿಯು ತನ್ನ ಬಾಯಿತೆರೆದು, ಅವರನ್ನೂ, ಅವರ ಮನೆಗಳನ್ನೂ, ಕೋರಹನಿಗೆ ಸಂಬಂಧಪಟ್ಟ ಸಕಲ ಜನರನ್ನೂ, ಅವರಿಗಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ನುಂಗಿಬಿಟ್ಟಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ಅವರು ತಮಗೆ ಸಂಬಂಧಪಟ್ಟವುಗಳೆಲ್ಲವುಗಳ ಸಂಗಡ ಸಜೀವಿಗಳಾಗಿ ಪಾತಾಳಕ್ಕೆ ಇಳಿದರು. ಭೂಮಿಯು ಅವರ ಮೇಲೆ ಮುಚ್ಚಿಕೊಂಡಿತು. ಹೀಗೆ ಅವರು ಸಭೆಯ ಮಧ್ಯದೊಳಗಿಂದ ನಾಶವಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ಆಗ ಅವರ ಸುತ್ತಲಿದ್ದ ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಓಡಿಹೋದರು, ಏಕೆಂದರೆ ಅವರು, “ಭೂಮಿಯು ನಮ್ಮನ್ನು ಸಹ ನುಂಗಿಬಿಟ್ಟೀತು,” ಎಂದು ಹೆದರಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ಯೆಹೋವ ದೇವರ ಬಳಿಯಿಂದ ಬೆಂಕಿಯು ಹೊರಟು, ಧೂಪವನ್ನು ಅರ್ಪಿಸಿದ ಇನ್ನೂರ ಐವತ್ತು ಮಂದಿಯನ್ನು ದಹಿಸಿಬಿಟ್ಟಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“ಯಾಜಕನಾದ ಆರೋನನ ಮಗ ಎಲಿಯಾಜರನಿಗೆ, ಧೂಪದ ಪಾತ್ರೆಗಳು ಪರಿಶುದ್ಧವಾಗಿರುವುದರಿಂದ ಸುಟ್ಟುಹೋದವರ ಮಧ್ಯದಿಂದ ಅವನು ಅವುಗಳನ್ನು ಎತ್ತಬೇಕು. ಆ ಬೆಂಕಿಯನ್ನು ದೂರ ಚೆಲ್ಲು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ತಮ್ಮ ಪ್ರಾಣಕ್ಕೆ ವಿರೋಧವಾಗಿ ಪಾಪಮಾಡಿದ ಮನುಷ್ಯರ ಧೂಪದ ಪಾತ್ರೆಗಳನ್ನು ಬಲಿಪೀಠವನ್ನು ಮುಚ್ಚತಕ್ಕ ಅಗಲವಾದ ತಗಡುಗಳನ್ನಾಗಿ ಮಾಡಬೇಕು. ಏಕೆಂದರೆ ಅವುಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ಅರ್ಪಿಸಿದ ಕಾರಣ ಅವು ಪರಿಶುದ್ಧವಾದವುಗಳು. ಇಸ್ರಾಯೇಲರಿಗೆ ಅವು ಗುರುತುಗಳಾಗಿರಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ಆಗ ಯಾಜಕನಾದ ಎಲಿಯಾಜರನು ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಮೂಲಕ ಹೇಳಿದ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಸುಟ್ಟು ಹೋದವರು ಅರ್ಪಿಸಿದ ಕಂಚಿನ ಧೂಪದ ಪಾತ್ರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ಬಲಿಪೀಠವನ್ನು ಮುಚ್ಚುವುದಕ್ಕಾಗಿ ಅವುಗಳನ್ನು ಅಗಲವಾದ ತಗಡುಗಳನ್ನಾಗಿ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ಆರೋನನ ಸಂತಾನವಲ್ಲದ ಪರಕೀಯನು ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ಧೂಪವನ್ನು ಅರ್ಪಿಸಬಾರದು, ಅರ್ಪಿಸಿದರೆ ಕೋರಹ ಮತ್ತು ಅವನ ಸಮೂಹಕ್ಕೆ ಆದ ಸ್ಥಿತಿಯೇ ಇವರಿಗೂ ಉಂಟಾಗುವುದೆಂಬುದನ್ನು ಇಸ್ರಾಯೇಲರಿಗೆ ಜ್ಞಾಪಿಸುವದಕ್ಕಾಗಿ ಅದು ಗುರುತಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ಆದರೆ ಮರುದಿನದಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಸಮೂಹವೆಲ್ಲಾ ಮೋಶೆಗೆ ವಿರೋಧವಾಗಿಯೂ ಆರೋನನಿಗೆ ವಿರೋಧವಾಗಿಯೂ ಗೊಣಗುಟ್ಟುತ್ತಾ, “ನೀವು ಯೆಹೋವ ದೇವರ ಜನರನ್ನು ಕೊಂದುಹಾಕಿದ್ದೀರಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ಜನರು ಮೋಶೆಗೂ ಆರೋನನಿಗೂ ವಿರೋಧವಾಗಿ ಕೂಡಿಕೊಂಡಾಗ, ಅವರು ದೇವದರ್ಶನ ಗುಡಾರದ ಕಡೆಗೆ ನೋಡಲಾಗಿ, ಮೇಘವು ಅದನ್ನು ಮುಚ್ಚಿಕೊಂಡು, ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯು ಕಾಣಬಂತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ಮೋಶೆಯೂ ಆರೋನನೂ ದೇವದರ್ಶನ ಗುಡಾರದ ಮುಂದೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ನೀನು ಈ ಜನರ ಮಧ್ಯದಿಂದ ಎದ್ದು ಬಾ. ನಾನು ಅವರನ್ನು ಕ್ಷಣಮಾತ್ರದಲ್ಲಿ ದಹಿಸಿಬಿಡುತ್ತೇನೆ,” ಎಂದರು. ಆಗ ಅವರಿಬ್ಬರು ಬೋರಲು ಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ನೀನು ಧೂಪದ ಪಾತ್ರೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದರ ಮೇಲೆ ಬಲಿಪೀಠದ ಬೆಂಕಿಯನ್ನು ಇಟ್ಟು, ಧೂಪ ಹಾಕಿ, ಶೀಘ್ರವಾಗಿ ಜನರೊಳಗೆ ಹೋಗಿ, ಅವರಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ಮಾಡು. ಏಕೆಂದರೆ ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಿಂದ ಕೋಪವು ಹೊರಟು, ಅವರೊಳಗೆ ವ್ಯಾಧಿಯು ಪ್ರಾರಂಭವಾಯಿತು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ಆರೋನನು, ಮೋಶೆಯು ಹೇಳಿದ ಹಾಗೆ ಅದನ್ನು ತೆಗೆದುಕೊಂಡು, ಜನಸಮೂಹದ ಮಧ್ಯಕ್ಕೆ ಓಡಿಬಂದನು. ಆಗ ವ್ಯಾಧಿಯು ಜನರೊಳಗೆ ಪ್ರಾರಂಭವಾಗಿತ್ತು. ಅವನು ಧೂಪವನ್ನು ಇಟ್ಟು, ಜನರಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ಅವನು ಸತ್ತವರಿಗೂ ಜೀವವುಳ್ಳವರಿಗೂ ಮಧ್ಯ ನಿಂತುಕೊಂಡದ್ದರಿಂದ ವ್ಯಾಧಿಯು ಶಮನವಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ಕೋರಹನ ನಿಮಿತ್ತ ಸತ್ತು ಹೋದವರ ಹೊರತಾಗಿ ವ್ಯಾಧಿಯಲ್ಲಿ ಸತ್ತವರು ಹದಿನಾಲ್ಕು ಸಾವಿರ ಏಳು ನೂರು ಮಂದಿಯಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ಆ ವ್ಯಾಧಿಯು ನಿಂತು ಹೋದಾಗ ಆರೋನನು ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿಯಲ್ಲಿದ್ದ ಮೋಶೆಯ ಬಳಿಗೆ ಹಿಂದಿರುಗಿ ಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರಿಂದ ಅವರ ಪಿತೃಗಳ ಗೋತ್ರಗಳ ಪ್ರಕಾರ, ಅವರ ಪ್ರಧಾನರೆಲ್ಲರ ಪಿತೃಗಳ ಮನೆಯ ಪ್ರಕಾರ ಕೋಲುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ಒಬ್ಬೊಬ್ಬನ ಹೆಸರನ್ನು ಅವನವನ ಕೋಲಿನ ಮೇಲೆ ನೀನು ಬರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ಆರೋನನ ಹೆಸರನ್ನು ಲೇವಿಯ ಕೋಲಿನ ಮೇಲೆ ಬರೆಯಬೇಕು. ಏಕೆಂದರೆ ಅವರ ಪಿತೃಗಳ ಗೋತ್ರದ ಮುಖ್ಯಸ್ಥನಿಗೆ ಒಂದು ಕೋಲು ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ಅವುಗಳನ್ನು ದೇವದರ್ಶನ ಗುಡಾರದಲ್ಲಿ ನಾನು ನಿಮ್ಮ ಸಂಗಡ ಸಂಧಿಸುವ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಮುಂದೆ ಇಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ನಾನು ಯಾವನನ್ನು ಆಯ್ದುಕೊಳ್ಳುತ್ತೇನೋ, ಆ ಮನುಷ್ಯನ ಕೋಲು ಚಿಗುರುವುದು. ಹೀಗೆ ಇಸ್ರಾಯೇಲರು ನಿಮಗೆ ವಿರೋಧವಾಗಿ ಗೊಣಗುಟ್ಟುವುದನ್ನು ನಾನು ನಿಲ್ಲಿಸಿಬಿಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ಹಾಗೆಯೇ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿದನು. ಅವರ ಪ್ರಧಾನರೆಲ್ಲರೂ ತಮ್ಮ ಪಿತೃಗಳ ಗೋತ್ರಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬ ಪ್ರಧಾನನಿಗೋಸ್ಕರ ಒಂದೊಂದು ಕೋಲಿನ ಪ್ರಕಾರ ಹನ್ನೆರಡು ಕೋಲುಗಳನ್ನು ಕೊಟ್ಟರು. ಆರೋನನ ಕೋಲು ಸಹ ಅವರ ಕೋಲುಗಳ ಮಧ್ಯದಲ್ಲಿ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ಆಗ ಮೋಶೆಯು ಆ ಕೋಲುಗಳನ್ನು ಸಾಕ್ಷಿಯ ಗುಡಾರದ ಒಳಗೆ ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ಇಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ಮರುದಿವಸದಲ್ಲಿ, ಮೋಶೆಯು ಸಾಕ್ಷಿ ಗುಡಾರದೊಳಗೆ ಪ್ರವೇಶಿಸುವಾಗ, ಲೇವಿಯ ಮನೆಯ ಕೋಲಾಗಿದ್ದ ಆರೋನನ ಕೋಲು ಚಿಗುರಿ, ಮೊಗ್ಗು ಬಿಟ್ಟು, ಹೂವು ಅರಳಿ ಬಾದಾಮಿ ಹಣ್ಣುಗಳನ್ನು ಫಲಿಸಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ಆಗ ಮೋಶೆಯು ಕೋಲುಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಿಂದ ಎಲ್ಲಾ ಇಸ್ರಾಯೇಲರಿಗೆ ತೋರಿಸುವುದಕ್ಕಾಗಿ ಹೊರಗೆ ತಂದನು. ಆಗ ಅವರು ನೋಡಿ ತಮ್ಮ ತಮ್ಮ ಕೋಲುಗಳನ್ನು ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಆರೋನನ ಕೋಲನ್ನು ಎದುರು ಬೀಳುವವರಿಗೆ ಗುರುತಾಗಿ ಇಟ್ಟುಕೊಳ್ಳುವುದಕ್ಕೆ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷದ ಮುಂದೆ ತಿರುಗಿ ಇಡು. ಗೊಣಗುಟ್ಟುವುದನ್ನು ನೀನು ಸಂಪೂರ್ಣವಾಗಿ ತೆಗೆದುಬಿಡಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಮೋಶೆ ಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ಆಗ ಇಸ್ರಾಯೇಲರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ನಾವೆಲ್ಲರೂ ಸಾಯುತ್ತೇವೆ, ನಾಶವಾಗುತ್ತೇವೆ. ನಾವೆಲ್ಲರೂ ನಾಶವಾಗುತ್ತೇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ಯೆಹೋವ ದೇವರ ಗುಡಾರದ ಸಮೀಪಕ್ಕೆ ಬರುವವರೆಲ್ಲರೂ ಸಾಯುವರು. ಹಾಗೆಯೇ ನಾವೆಲ್ಲರೂ ಸಾಯಬೇಕೋ?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ಯೆಹೋವ ದೇವರು ಆರೋನನಿಗೆ, “ನೀನೂ, ನಿನ್ನ ಪುತ್ರರೂ, ನಿನ್ನ ಪಿತೃಗಳ ಮನೆಯವರೂ ಪರಿಶುದ್ಧ ಸ್ಥಳಕ್ಕೆ ವಿರೋಧವಾಗಿ ನಡೆಯುವ ಕಾರ್ಯಗಳ ಜವಾಬ್ದಾರಿ ವಹಿಸಬೇಕು. ಯಾಜಕತ್ವಕ್ಕೆ ವಿರೋಧವಾಗಿ ನಡೆಯುವ ಅಕ್ರಮಗಳಿಗೆ ನೀನು ಮತ್ತು ನಿನ್ನ ಪುತ್ರರು ಮಾತ್ರ ಹೊಣೆಯಾಗಿರುತ್ತೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ನಿನ್ನ ಗೋತ್ರದ ಮೂಲಪುರುಷನಾದ ಲೇವಿ ವಂಶದವರನ್ನು ಸಹ ನಿನ್ನ ಸಂಗಡ ಸೇರಿಸಿಕೋ. ಏಕೆಂದರೆ ಅವರು ನಿನ್ನ ಕೂಡ ಇದ್ದು, ನಿನಗೆ ಸೇವೆಮಾಡಬೇಕು. ಆದರೆ ನೀನು ಮತ್ತು ನಿನ್ನ ಮಕ್ಕಳ ಸಹಿತವಾಗಿ ಸಾಕ್ಷಿ ಗುಡಾರದ ಮುಂದೆ ಸೇವೆಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ಅವರು ನಿನಗೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಕಾರ್ಯಗಳಿಗೂ ಜವಾಬ್ದಾರರಾಗಿರುವರು. ಆದರೆ ಪರಿಶುದ್ಧಸ್ಥಳದ ಸಲಕರಣೆಗಳ ಹತ್ತಿರವಾಗಲಿ, ಬಲಿಪೀಠದ ಹತ್ತಿರವಾಗಲಿ ಅವರು ಬರಬಾರದು, ಬಂದರೆ ಅವರು ಮಾತ್ರವಲ್ಲ ನೀವೂ ಸಹ ಸಾಯುವಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ಆದರೆ ಅವರು ನಿನ್ನ ಸಹಾಯಕರಾಗಿದ್ದು, ದೇವದರ್ಶನದ ಗುಡಾರದ ಎಲ್ಲಾ ಕಾರ್ಯಗಳಿಗೂ ಅದನ್ನು ಕಾಪಾಡುವುದಕ್ಕೂ ಜವಾಬ್ದಾರರಾಗಿರುವರು. ಬೇರೆ ಕುಲದವರು ನಿಮ್ಮ ಸಮೀಪಕ್ಕೆ ಬರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“ಇಸ್ರಾಯೇಲರ ಮೇಲೆ ಇನ್ನು ಮುಂದೆ ಎಂದಿಗೂ ನನ್ನ ಕೋಪಾಗ್ನಿಯು ಬಾರದ ಹಾಗೆ ಪರಿಶುದ್ಧ ಸ್ಥಳವನ್ನು ಮತ್ತು ಬಲಿಪೀಠವನ್ನು ನೀವೇ ನೋಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ನಾನು ನಿಮ್ಮ ಸಹೋದರರಾದ ಲೇವಿಯರನ್ನು ಇಸ್ರಾಯೇಲರೊಳಗಿಂದ ತೆಗೆದುಕೊಂಡಿದ್ದೇನೆ. ದೇವದರ್ಶನ ಗುಡಾರದ ಸೇವೆಯನ್ನು ಮಾಡುವುದಕ್ಕೆ ಅವರು ಯೆಹೋವ ದೇವರಿಗಾಗಿ ನಿಮಗೆ ಕಾಣಿಕೆಯಾಗಿ ಸಮರ್ಪಿತರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ಆದ್ದರಿಂದ ನೀನು ನಿನ್ನ ಪುತ್ರರ ಸಹಿತವಾಗಿ ನಿಮ್ಮ ಯಾಜಕತ್ವವನ್ನು ಕಾಪಾಡಬೇಕು. ಬಲಿಪೀಠದ ಸಮಸ್ತ ಕಾರ್ಯಗಳಿಗೋಸ್ಕರ ತೆರೆಯ ಒಳಗೆ ನೀವು ಸೇವೆಮಾಡಬೇಕು. ನಿಮ್ಮ ಯಾಜಕತ್ವ ಸೇವೆಯನ್ನು ನಿಮಗೆ ದಾನವಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ಪರಕೀಯನು ಸಮೀಪಕ್ಕೆ ಬಂದರೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ಯೆಹೋವ ದೇವರು ಮಾತನಾಡಿ ಆರೋನನಿಗೆ, “ನನಗೆ ಕೊಡುವ ಎಲ್ಲಾ ಕಾಣಿಕೆಗಳ ಮೇಲೆ ನಿನ್ನನ್ನು ನೇಮಿಸಿದ್ದೇನೆ. ಇಸ್ರಾಯೇಲರು ನನಗೆ ಸಮರ್ಪಿಸುವ ಎಲ್ಲಾ ಪರಿಶುದ್ಧವಾದ ಕಾಣಿಕೆಗಳನ್ನೆಲ್ಲಾ ನಿನಗೂ ನಿನ್ನ ಮಕ್ಕಳಿಗೂ ಶಾಶ್ವತ ಪಾಲನ್ನು ನೀಡುತ್ತೇನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ದಹನಬಲಿಗೆ ಒಳಗಾಗದ ಮಹಾಪರಿಶುದ್ಧವಾದ ವಸ್ತುಗಳು ನಿನಗೆ ಕಾಣಿಕೆಯಾಗಿ ಸಲ್ಲಬೇಕು ಯಾವುವೆಂದರೆ ಇಸ್ರಾಯೇಲರು ನನಗೆ ಸಮರ್ಪಿಸುವ ಧಾನ್ಯ, ದೋಷಪರಿಹಾರಕ ಬಲಿಗಳು ಮತ್ತು ಪ್ರಾಯಶ್ಚಿತ್ತ ಬಲಿಗಳು, ಇವುಗಳಲ್ಲಿ ದಹನವಾಗದೆ ಉಳಿದವುಗಳು ಮಹಾಪರಿಶುದ್ಧವಾದದರಿಂದ ನಿನಗೂ ನಿನ್ನ ಪುತ್ರರಿಗೂ ಸೇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ಮಹಾಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ನೀನು ಅದನ್ನು ತಿನ್ನಬೇಕು. ಪುರುಷರು ಅದನ್ನು ತಿನ್ನಬಹುದು. ಅದು ನಿನಗೆ ಪರಿಶುದ್ಧವಾಗಿರುವುದೆಂದು ಪರಿಗಣಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ಅವರು ಕೊಟ್ಟ ಅರ್ಪಣೆಯೂ ಇಸ್ರಾಯೇಲರು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸುವ ಎಲ್ಲಾ ಸಮರ್ಪಣೆಗಳೂ ನಿನ್ನದಾಗಿರುವುವು. ಅವುಗಳನ್ನು ನಾನು ನಿನಗೂ, ನಿನ್ನ ಪುತ್ರಪುತ್ರಿಯರಿಗೂ ಶಾಶ್ವತ ನಿಯಮವಾಗಿ ಸಲ್ಲಬೇಕೆಂದು ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ. ನಿನ್ನ ಮನೆಯಲ್ಲಿರುವ ಶುದ್ಧನಾದ ಪ್ರತಿಯೊಬ್ಬನೂ ಅದನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“ಜನರು ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸುವ ಪ್ರಥಮ ಫಲಗಳನ್ನು ಅಂದರೆ ಎಲ್ಲಾ ಉತ್ತಮವಾದ ಎಣ್ಣೆಯೂ ಉತ್ತಮವಾದ ಹೊಸ ದ್ರಾಕ್ಷಾರಸ, ಧಾನ್ಯವೂ ನಿನಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ಅವರು ಯೆಹೋವ ದೇವರಿಗೆ ತರುವ ಅವರ ದೇಶದಲ್ಲಿರುವ ಎಲ್ಲವುಗಳ ಪ್ರಥಮ ಫಲಗಳು ನಿನ್ನವುಗಳಾಗಿರುವುವು. ನಿನ್ನ ಮನೆಯಲ್ಲಿರುವ ಶುದ್ಧನಾದ ಪ್ರತಿಯೊಬ್ಬನೂ ಅದನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರಿಗೆ ಹರಕೆಮಾಡಿ ಸಮರ್ಪಿಸಿದ ಪ್ರತಿಯೊಂದೂ ನಿನ್ನದಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ಮನುಷ್ಯರಲ್ಲಾಗಲಿ, ಪಶುಗಳಲ್ಲಾಗಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸುವ ಚೊಚ್ಚಲಾದದ್ದೆಲ್ಲಾ ನಿನ್ನದಾಗಿರಬೇಕು. ಆದರೆ ಮನುಷ್ಯರ ಚೊಚ್ಚಲಾದದ್ದನ್ನೂ ಅಪವಿತ್ರವಾದ ಗಂಡು ಪಶುಗಳ ಚೊಚ್ಚಲಾದದ್ದನ್ನೂ ನೀನು ವಿಮೋಚಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ಅವು ಒಂದು ತಿಂಗಳಿನ ಪ್ರಾಯಕ್ಕೆ ಬಂದಾಗ, ದೇವರ ಸೇವೆಗೆ ನಿಗದಿಯಾದ ಇಪ್ಪತ್ತು ಗೇರಾ ತೂಕದ ನಾಣ್ಯದ ಮೇರೆಗೆ ಐದು ಶೆಕೆಲ್ ನಾಣ್ಯವನ್ನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ವಿಮೋಚಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“ಆದರೆ ಆಕಳಿನ ಚೊಚ್ಚಲನ್ನಾದರೂ ಕುರಿಯ ಚೊಚ್ಚಲನ್ನಾದರೂ ಮೇಕೆಯ ಚೊಚ್ಚಲನ್ನಾದರೂ ನೀನು ಬಿಟ್ಟುಬಿಡಬಾರದು. ಅವು ಪರಿಶುದ್ಧವಾಗಿವೆ, ಅವುಗಳ ರಕ್ತವನ್ನು ಬಲಿಪೀಠದ ಮೇಲೆ ಚಿಮುಕಿಸಬೇಕು, ಅವುಗಳ ಕೊಬ್ಬನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯ ದಹನಬಲಿ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸುವ ಎದೆಯೂ ಬಲಭುಜವೂ ನಿನ್ನದಾಗಿರುವ ಪ್ರಕಾರ ಅವುಗಳ ಮಾಂಸವೂ ನಿನ್ನದಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರಿಗೆ ನೈವೇದ್ಯ ಮಾಡುವ ಪರಿಶುದ್ಧವಾದ ಬಲಿಗಳನ್ನೆಲ್ಲಾ ನಿನಗೂ ನಿನ್ನ ಪುತ್ರಪುತ್ರಿಯರಿಗೂ ಕ್ರಮ ಪ್ರಕಾರವಾದ ಭಾಗವಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ಇದು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ನಿನಗೂ ನಿನ್ನ ಸಂಗಡ ಇರುವ ನಿನ್ನ ಸಂತತಿಗೂ ಶಾಶ್ವತವಾದ ಉಪ್ಪಿನ ಒಡಂಬಡಿಕೆಯಾಗಿರಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ಯೆಹೋವ ದೇವರು ಆರೋನನಿಗೆ, “ನಿನಗೆ ಅವರ ದೇಶದಲ್ಲಿ ಯಾವ ಸ್ವಾಸ್ತ್ಯವೂ ಇರಬಾರದು, ನಿನಗೆ ಅವರ ಮಧ್ಯದಲ್ಲಿ ಯಾವ ಪಾಲೂ ಇರಬಾರದು. ನಾನೇ ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ನಿನ್ನ ಪಾಲೂ ನಿನ್ನ ಸ್ವಾಸ್ತ್ಯವೂ ಆಗಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“ಅವರು ದೇವದರ್ಶನ ಗುಡಾರದ ಸೇವೆಯನ್ನೂ ಮಾಡುವುದರಿಂದ ನಾನು ಲೇವಿಯ ಮಕ್ಕಳಿಗೆ ಅವರ ಸೇವೆಗೋಸ್ಕರ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಹತ್ತನೆಯ ಭಾಗವನ್ನು ಸೊತ್ತಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ಇನ್ನು ಮೇಲೆ ಇಸ್ರಾಯೇಲರು ಪಾಪವನ್ನು ಹೊತ್ತುಕೊಂಡು ಸಾಯದ ಹಾಗೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸಮೀಪಕ್ಕೆ ಬರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ಆದರೆ ಲೇವಿಯರೇ ದೇವದರ್ಶನ ಗುಡಾರದ ಸೇವೆಯನ್ನು ಮಾಡಬೇಕು. ಅವರು ಅಲ್ಲಿ ಅಕ್ರಮವಾಗದಂತೆ ನೋಡಿಕೊಳ್ಳುವ ಜವಾಬ್ದಾರಿಯನ್ನು ಹೊತ್ತಿರಬೇಕು. ಇದು ನಿಮ್ಮ ಸಂತತಿಗಳಿಗೆ ಶಾಶ್ವತ ಕಟ್ಟಳೆಯಾಗಿದೆ, ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ಲೇವಿಯರಿಗೆ ಸ್ವಾಸ್ತ್ಯ ಇರಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರಿಗೆ ಬಲಿಯಾಗಿ ಅರ್ಪಿಸುವ ಹತ್ತನೆಯ ಒಂದು ಪಾಲನ್ನು ಲೇವಿಯರಿಗೆ ಸ್ವಾಸ್ತ್ಯಕ್ಕಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ಆದಕಾರಣ, ‘ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ಅವರಿಗೆ ಸೊತ್ತು ಇರಬಾರದು ಎಂದು ನಾನು ಅವರಿಗೆ ಹೇಳಿದ್ದೇನೆ,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ನೀನು ಲೇವಿಯರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ನಿಮಗೆ ಸ್ವಾಸ್ತ್ಯಕ್ಕಾಗಿ ಕೊಟ್ಟ ಹತ್ತನೆಯ ಒಂದು ಪಾಲನ್ನು ಇಸ್ರಾಯೇಲರಿಂದ ನೀವು ತೆಗೆದುಕೊಳ್ಳುವಾಗ ಅದರಲ್ಲಿ ಹತ್ತನೆಯದರಿಂದ ಒಂದು ಪಾಲನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ಈ ನಿಮ್ಮ ಸಮರ್ಪಣೆಯನ್ನು ಕಣದ ಧಾನ್ಯದ ಹಾಗೆಯೂ ದ್ರಾಕ್ಷಿತೊಟ್ಟಿಯ ರಸದಂತೆಯೂ ಪರಿಗಣಿಸಲಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ಈ ಪ್ರಕಾರ ನೀವು ಸಹ ಇಸ್ರಾಯೇಲರ ಕಡೆಯಿಂದ ತೆಗೆದುಕೊಳ್ಳುವ ನಿಮ್ಮ ಎಲ್ಲಾ ಹತ್ತನೆಯ ಒಂದು ಭಾಗವನ್ನು ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಅರ್ಪಿಸಬೇಕು, ನೀವು ಅದರಿಂದ ಯೆಹೋವ ದೇವರ ಯಾಜಕನಾದ ಆರೋನನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ನಿಮ್ಮ ಎಲ್ಲಾ ಕಾಣಿಕೆಗಳಲ್ಲಿ ಅದರ ಒಂದೊಂದರ ಉತ್ತಮವಾದದ್ದನ್ನು ಅದರೊಳಗಿನ ಪರಿಶುದ್ಧವಾದ ಭಾಗವನ್ನೇ ಯೆಹೋವ ದೇವರಿಗೆ ಸಮರ್ಪಣೆಯಾಗಿ ಅರ್ಪಿಸಬೇಕು.’ ");
INSERT INTO kanokcv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“ನೀನು ಲೇವಿಯರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ನೀವು ಅದರಲ್ಲಿ ಉತ್ತಮವಾದದ್ದನ್ನು ಸಮರ್ಪಿಸಿದ ನಂತರ ಉಳಿದವುಗಳನ್ನು ಕಣದಲ್ಲಿನ ದವಸದಂತೆಯೂ ದ್ರಾಕ್ಷಿತೊಟ್ಟಿಯ ರಸದಂತೆಯೂ ಪರಿಗಣಿಸಲಾಗುತ್ತದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ನೀವೂ ನಿಮ್ಮ ಮನೆಯವರೂ ಅದನ್ನು ಸಕಲ ಸ್ಥಳಗಳಲ್ಲಿ ತಿನ್ನಬಹುದು. ಏಕೆಂದರೆ ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ನೀವು ಮಾಡುವ ಸೇವೆಗೋಸ್ಕರ ಅದು ನಿಮಗೆ ಪ್ರತಿಫಲವಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ಆದಕಾರಣ ನೀವು ಅದರಲ್ಲಿ ಉತ್ತಮವಾದದ್ದನ್ನು ಅರ್ಪಿಸಿದಾಗ, ಅದರ ದೆಸೆಯಿಂದ ಯಾವ ದೋಷಕ್ಕೂ ನೀವು ಗುರಿಯಾಗುವುದಿಲ್ಲ. ಇಸ್ರಾಯೇಲರು ಸಮರ್ಪಿಸುವ ಪರಿಶುದ್ಧವಾದವುಗಳನ್ನು ಅಪವಿತ್ರ ಮಾಡದಿದ್ದರೆ ನೀವು ಸಾಯುವುದಿಲ್ಲ,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಹಾಗೂ ಆರೋನನ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ಯೆಹೋವ ದೇವರಾದ ನಾನು ಆಜ್ಞಾಪಿಸಿದ ನಿಯಮದ ಕಟ್ಟಳೆ ಏನೆಂದರೆ, ಎಂದೂ ನೊಗವನ್ನು ಹೊರದಂಥ, ಮಚ್ಚೆ ಇಲ್ಲದಂಥ ಮತ್ತು ಕಳಂಕವಿಲ್ಲದ ಕೆಂದಾಕಳನ್ನು ನಿಮಗೆ ತಂದು ಕೊಡುವಂತೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ನೀವು ಅದನ್ನು ಯಾಜಕನಾದ ಎಲಿಯಾಜರನಿಗೆ ಕೊಡಬೇಕು. ಅವನು ಅದನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡುಹೋಗಿ, ತನ್ನ ಮುಂದೆ ವಧೆಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ಯಾಜಕನಾದ ಎಲಿಯಾಜರನು ತನ್ನ ಬೆರಳಿನಿಂದ ಅದರ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದನ್ನು ಏಳು ಸಾರಿ ದೇವದರ್ಶನ ಗುಡಾರದ ಮುಂಭಾಗಕ್ಕೆ ನೇರವಾಗಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ಹಸುವನ್ನು ಅವನ ಎದುರಿನಲ್ಲಿಯೇ ಸುಡಿಸಬೇಕು. ಅದರ ತೊಗಲನ್ನೂ ಮಾಂಸವನ್ನೂ ರಕ್ತವನ್ನೂ ಮತ್ತು ಅದರ ಸಗಣಿಯ ಕೂಡ ಸುಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ಯಾಜಕನು ದೇವದಾರು ಕಟ್ಟಿಗೆಯನ್ನೂ ಹಿಸ್ಸೋಪನ್ನೂ ರಕ್ತವರ್ಣವುಳ್ಳ ದಾರವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹಸುವಿನ ದಹನದಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ಆಗ ಯಾಜಕನು ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ತೊಳೆದುಕೊಂಡು, ತನ್ನ ಶರೀರವನ್ನು ನೀರಿನಲ್ಲಿ ತೊಳೆದುಕೊಂಡ ನಂತರ ಪಾಳೆಯದೊಳಗೆ ಬರಬಹುದು. ಆದರೂ ಯಾಜಕನು ಸಂಜೆಯವರೆಗೂ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ಅದನ್ನು ಸುಡುವವನು ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ನೀರಿನಲ್ಲಿ ತೊಳೆದುಕೊಂಡು, ಸ್ನಾನಮಾಡಬೇಕು. ಅವನೂ ಸಹ ಆ ದಿನದ ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ಶುದ್ಧನಾದವನೊಬ್ಬನು ಆ ಆಕಳಿನ ಬೂದಿಯನ್ನು ಕೂಡಿಸಿ, ಪಾಳೆಯದ ಹೊರಗೆ ಶುದ್ಧವಾದ ಒಂದು ಸ್ಥಳದಲ್ಲಿ ಇಡಬೇಕು. ಅದನ್ನು ಇಸ್ರಾಯೇಲ್ ಸಮೂಹದವರ ಉಪಯೋಗಕ್ಕಾಗಿ ನೀವು ಜೋಪಾನವಾಗಿಡಬೇಕು. ಅದು ದೋಷಪರಿಹಾರಕವಾದುದು. ಆದ್ದರಿಂದ ಶುದ್ಧೀಕರಣ ನೀರನ್ನು ಸಿದ್ಧಪಡಿಸುವುದಕ್ಕಾಗಿ ಅಲ್ಲೇ ಇಟ್ಟಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ಹಸುವಿನ ಬೂದಿಯನ್ನು ಕೂಡಿಸಿದವನು ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು, ಸಂಜೆಯವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು. ಇದು ಇಸ್ರಾಯೇಲರಿಗೂ ಅವರ ಮಧ್ಯದಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿರುವ ಪರಕೀಯನಿಗೂ ಶಾಶ್ವತ ಕಟ್ಟಳೆಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ಮನುಷ್ಯನ ಶವವನ್ನು ಮುಟ್ಟಿದವನು ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ಅವನು ಇದರಿಂದ ಮೂರನೆಯ ದಿವಸದಲ್ಲಿ ತನ್ನನ್ನು ಶುದ್ಧೀಕರಿಸಿಕೊಂಡು ಏಳನೆಯ ದಿವಸದಲ್ಲಿ ಶುದ್ಧನಾಗಬೇಕು. ಆದರೆ ಅವನು ಮೂರನೆಯ ದಿವಸದಲ್ಲಿ ತನ್ನನ್ನು ಶುದ್ಧಮಾಡಿಕೊಳ್ಳದಿದ್ದರೆ, ಏಳನೆಯ ದಿವಸದಲ್ಲಿ ಶುದ್ಧನಾಗಲಾರನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ಸತ್ತ ಮನುಷ್ಯನ ಶವವನ್ನು ಮುಟ್ಟಿ, ಶುದ್ಧಮಾಡಿಕೊಳ್ಳದವನು ಯೆಹೋವ ದೇವರ ಗುಡಾರವನ್ನು ಅಪವಿತ್ರಪಡಿಸುತ್ತಾನೆ, ಅಂಥವನನ್ನು ಇಸ್ರಾಯೇಲಿನವರೊಳಗಿಂದ ತೆಗೆದುಹಾಕಬೇಕು, ಶುದ್ಧೀಕರಣದ ನೀರು ಅವನ ಮೇಲೆ ಚಿಮುಕಿಸದ ಕಾರಣ ಅವನು ಅಶುದ್ಧನಾಗಿದ್ದಾನೆ. ಅವನ ಅಶುದ್ಧತ್ವವು ಇನ್ನೂ ಅವನ ಮೇಲೆ ಇರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ಒಬ್ಬ ಮನುಷ್ಯನು ಡೇರೆಯಲ್ಲಿ ಸತ್ತರೆ, ಅವನ ವಿಷಯವಾದ ನಿಯಮವೇನೆಂದರೆ: ಆ ಡೇರೆಯೊಳಗೆ ಪ್ರವೇಶಿಸುವವರೆಲ್ಲರೂ, ಡೇರೆಯಲ್ಲಿರುವವರೆಲ್ಲರೂ ಏಳು ದಿವಸಗಳವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ಮುಚ್ಚಳ ಹಾಕದೆ ತೆರೆದಿರುವ ಸಾಮಾನುಗಳೆಲ್ಲಾ ಅಶುದ್ಧವಾಗಿರುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“ಇದಲ್ಲದೆ ಬಯಲಿನಲ್ಲಿ ಖಡ್ಗದಿಂದ ಹತನಾದ ವ್ಯಕ್ತಿಯನ್ನು ಮುಟ್ಟಿದವರೂ ಅಥವಾ ಬೇರೆ ಯಾವ ಮನುಷ್ಯನ ಶವವಾಗಲಿ, ಮನುಷ್ಯನ ಎಲುಬನ್ನಾಗಲಿ, ಸಮಾಧಿಯನ್ನಾಗಲಿ ಮುಟ್ಟಿದವರೆಲ್ಲರೂ ಏಳು ದಿವಸ ಅಪವಿತ್ರರಾಗಿರುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ಅಪವಿತ್ರನಾದವನನ್ನು ಶುದ್ಧಪಡಿಸಬೇಕಾದರೆ ಆ ದೋಷಪರಿಹಾರಕವಾದ ಬೂದಿಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಒಂದು ಪಾತ್ರೆಯೊಳಗಿಟ್ಟು, ಅದರ ಮೇಲೆ ಹರಿಯುವ ನೀರನ್ನು ಹಾಕಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ಪವಿತ್ರನಾದವನೊಬ್ಬನು ಹಿಸ್ಸೋಪನ್ನು ತೆಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಅದ್ದಿ, ಆ ಡೇರೆಯ ಮೇಲೆಯೂ, ಸಮಸ್ತ ಸಲಕರಣೆಗಳ ಮೇಲೆಯೂ, ಅದರಲ್ಲಿರುವ ಜನರ ಮೇಲೆಯೂ ಚಿಮುಕಿಸಬೇಕು. ಹಾಗೆಯೇ ಎಲುಬನ್ನಾಗಲಿ, ಹತನಾದವನ ಅಥವಾ ಬೇರೆ ಮನುಷ್ಯನ ಶವವಾಗಲಿ, ಸಮಾಧಿಯನ್ನಾಗಲಿ ಮುಟ್ಟಿದವರ ಮೇಲೆಯೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ಪವಿತ್ರನಾದವನು ಅಪವಿತ್ರನಾದವನ ಮೇಲೆ ಮೂರನೆಯ ದಿವಸದಲ್ಲಿಯೂ, ಏಳನೆಯ ದಿವಸದಲ್ಲಿಯೂ ಅದನ್ನು ಚಿಮುಕಿಸಲಿ. ಏಳನೆಯ ದಿವಸದಲ್ಲಿ ಅವನು ತನ್ನನ್ನು ಪವಿತ್ರ ಮಾಡಿಕೊಂಡು, ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ತೊಳೆದುಕೊಂಡು, ನೀರಿನಲ್ಲಿ ಸ್ನಾನ ಮಾಡಲಿ. ಹೀಗೆ ಸಂಜೆಯಲ್ಲಿ ಪವಿತ್ರನಾಗುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ಆದರೆ ಅಪವಿತ್ರನಾಗಿದ್ದು, ತನ್ನನ್ನು ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳದವನು ಸಭೆಯ ಮಧ್ಯದಿಂದ ತೆಗೆದುಹಾಕಬೇಕು ಏಕೆಂದರೆ ಅವನು ಯೆಹೋವ ದೇವರ ಪರಿಶುದ್ಧ ಸ್ಥಳವನ್ನು ಅಪವಿತ್ರ ಮಾಡಿದ್ದಾನೆ. ನೀರು ಅವನ ಮೇಲೆ ಚಿಮಿಕಿಸಿಕೊಳ್ಳದ ಕಾರಣ ಅವನು ಅಪವಿತ್ರನೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ಇದು ಅವರಿಗೆ ಶಾಶ್ವತ ಕಟ್ಟಳೆಯಾಗಿರಬೇಕು. “ಶುದ್ಧೀಕರಣದ ನೀರನ್ನು ಚಿಮುಕಿಸುವವನು ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು ಮತ್ತು ಆ ನೀರು ಯಾರಿಗೆ ಸೋಂಕುವುದೋ ಅವನು ಆ ದಿನದ ಸಂಜೆಯವರೆಗೆ ಅಪವಿತ್ರನಾಗಿರುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ಇದಲ್ಲದೆ ಅಪವಿತ್ರನಾದವನು ಮುಟ್ಟುವಂಥಾದ್ದೆಲ್ಲ ಅಪವಿತ್ರವಾಗುವುದು, ಅವನನ್ನು ಮುಟ್ಟಿದವನು ಸಂಜೆಯವರೆಗೆ ಅಪವಿತ್ರನಾಗಿರುವನು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ಇಸ್ರಾಯೇಲರ ಸರ್ವ ಸಮೂಹದವರು ಚಿನ್ ಎಂಬ ಮರುಭೂಮಿಗೆ ಮೊದಲನೆಯ ತಿಂಗಳಿನಲ್ಲಿ ಬಂದರು. ಜನರು ಕಾದೇಶಿನಲ್ಲಿ ವಾಸಿಸುವಾಗ ಅಲ್ಲಿ ಮಿರ್ಯಾಮಳು ಮರಣಹೊಂದಿದಳು, ಆಕೆಯ ಶವವನ್ನು ಅಲ್ಲಿಯೇ ಸಮಾಧಿಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ಆಗ ಜನರಿಗೆ ನೀರು ಇಲ್ಲದೆ ಇರಲಾಗಿ ಅವರು ಮೋಶೆಗೂ ಆರೋನನಿಗೂ ವಿರೋಧವಾಗಿ ಕೂಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ಜನರು ಮೋಶೆಯ ಸಂಗಡ ವ್ಯಾಜ್ಯವಾಡಿ, “ನಮ್ಮ ಸಹೋದರರು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಸತ್ತು ಹೋದಾಗಲೇ, ನಾವು ಸಹ ಸತ್ತು ಹೋಗಿದ್ದರೆ ಚೆನ್ನಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ನಾವೂ ನಮ್ಮ ಪಶುಗಳೂ ಸಾಯುವ ಹಾಗೆ ನೀವು ಏಕೆ ಯೆಹೋವ ದೇವರ ಸಭೆಯವರಾದ ನಮ್ಮನ್ನೂ ಈ ಮರುಭೂಮಿಗೆ ತಂದಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ಈ ಕೆಟ್ಟ ಸ್ಥಳಕ್ಕೆ ನಮ್ಮನ್ನು ತರುವುದಕ್ಕೆ ಏಕೆ ನಮ್ಮನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಕರಕೊಂಡು ಬಂದಿರಿ. ಈ ಸ್ಥಳದಲ್ಲಿ ಧಾನ್ಯವಾದರೂ ಅಂಜೂರವಾದರೂ ದ್ರಾಕ್ಷಿ ತೋಟವಾದರೂ ದಾಳಿಂಬೆ ಹಣ್ಣಾದರೂ ಇಲ್ಲ. ಕುಡಿಯುವುದಕ್ಕೆ ನೀರು ಸಹ ಇಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ಆಗ ಮೋಶೆ, ಆರೋನನೂ ಜನಸಮೂಹದ ಎದುರಿನಿಂದ ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಿನೊಳಗೆ ಹೋಗಿ, ಸಾಷ್ಟಾಂಗವೆರಗಿದರು. ಯೆಹೋವ ದೇವರ ಮಹಿಮೆಯು ಅವರಿಗೆ ಕಾಣಬಂತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ಕೋಲನ್ನು ತೆಗೆದುಕೊಂಡು ನೀನು ನಿನ್ನ ಸಹೋದರ ಆರೋನನು ಜನರನ್ನು ಕೂಡಿಸಿಕೊಂಡು, ಅವರ ಕಣ್ಣುಗಳ ಮುಂದೆ ಬಂಡೆಯ ಸಂಗಡ ಮಾತನಾಡಿರಿ. ಅದು ತನ್ನ ನೀರನ್ನು ಕೊಡುವುದು. ನೀನು ಅವರಿಗೋಸ್ಕರ ಬಂಡೆಯೊಳಗಿಂದ ನೀರನ್ನು ಹೊರಗೆ ತರುವೆ, ಜನರಿಗೂ ಅವರ ಪಶುಗಳಿಗೂ ನೀನು ಕುಡಿಯಲು ಕೊಡಬಹುದು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ಆಗ ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಟು, ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆ ಕೋಲನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ಮೋಶೆಯೂ, ಆರೋನನೂ ಜನರನ್ನು ಬಂಡೆಯ ಮುಂದೆ ಕೂಡಿಸಿ, ಅವರಿಗೆ, “ತಿರುಗಿ ಬಿದ್ದವರೇ ಕೇಳಿರಿ, ನಾವು ನಿಮಗೋಸ್ಕರ ಈ ಬಂಡೆಯೊಳಗಿಂದ ನೀರನ್ನು ಹೊರಡಿಸಬೇಕೋ?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ಮೋಶೆಯು ತನ್ನ ಕೈಯನ್ನು ಎತ್ತಿ, ತನ್ನ ಕೋಲಿನಿಂದ ಬಂಡೆಯನ್ನು ಎರಡು ಸಾರಿ ಹೊಡೆದನು. ಆಗ ಬಹಳ ನೀರು ಹೊರಗೆ ಬಂತು, ಜನರೂ ಅವರ ಪಶುಗಳೂ ಕುಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆ ಮತ್ತು ಆರೋನನ ಸಂಗಡ ಮಾತನಾಡಿ, “ನನ್ನಲ್ಲಿ ವಿಶ್ವಾಸವಿಡದೆ ಹೋದಕಾರಣ ನೀವು ಇಸ್ರಾಯೇಲರ ಕಣ್ಣುಗಳ ಮುಂದೆ ನನ್ನನ್ನು ಪರಿಶುದ್ಧನಾಗಿ ಗೌರವಿಸುವುದಕ್ಕೆ, ನಾನು ಅವರಿಗೆ ಕೊಡುವ ದೇಶದಲ್ಲಿ ನೀವು ಅವರನ್ನು ಸೇರಿಸುವುದಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರ ಸಂಗಡ ವ್ಯಾಜ್ಯವಾಡಿದ್ದಕ್ಕಾಗಿ ದೇವರು ಅವರಲ್ಲಿ ತಮ್ಮನ್ನು ಪರಿಶುದ್ಧ ಮಾಡಿಕೊಂಡ ಮೆರೀಬಾ ಸ್ಥಳದ ನೀರು ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ಮೋಶೆಯು ಕಾದೇಶಿನಿಂದ ಎದೋಮಿನ ಅರಸನ ಬಳಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ, “ನಿಮ್ಮ ಸಹೋದರರಾದ ಇಸ್ರಾಯೇಲರು ಹೇಳುವುದೇನೆಂದರೆ, ನಮಗೆ ಉಂಟಾದ ಸಕಲ ಆಯಾಸವನ್ನು ನೀನು ಅರಿತಿದ್ದೀ. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ನಮ್ಮ ಪಿತೃಗಳು ಈಜಿಪ್ಟಿಗೆ ಇಳಿದು ಹೋದರು. ಈಜಿಪ್ಟಿನಲ್ಲಿ ಬಹಳ ದಿವಸ ವಾಸವಾಗಿದ್ದೆವು ಮತ್ತು ಈಜಿಪ್ಟಿನವರು ನಮಗೂ, ನಮ್ಮ ಪಿತೃಗಳಿಗೆ ಕೇಡನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ಆದಕಾರಣ ನಾವು ಯೆಹೋವ ದೇವರಿಗೆ ಕೂಗಿದೆವು. ಅವರು ನಮ್ಮ ಧ್ವನಿಯನ್ನು ಕೇಳಿ, ದೂತನನ್ನು ಕಳುಹಿಸಿ, ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನೊಳಗಿಂದ ನಮ್ಮನ್ನು ಹೊರಗೆ ತಂದರು. “ನಾವು ನಿನ್ನ ಮೇರೆಯ ಕಡೇ ಊರಾದ ಕಾದೇಶಿಯದಲ್ಲಿ ಇದ್ದೇವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ನಮ್ಮನ್ನು ನಿನ್ನ ದೇಶದೊಳಗಿಂದ ದಾಟಿ ಹೋಗಗೊಡಿಸು; ನಾವು ಹೊಲವನ್ನಾದರೂ, ದ್ರಾಕ್ಷಿ ತೋಟವನ್ನಾದರೂ ದಾಟಿ ಹೋಗುವುದಿಲ್ಲ; ರಾಜಮಾರ್ಗದಲ್ಲಿ ಮಾತ್ರ ಹೋಗುತ್ತೇವೆ; ನಿನ್ನ ಮೇರೆಯನ್ನು ನಾವು ದಾಟುವವರೆಗೆ ಬಲಗಡೆಗಾದರೂ, ಎಡಗಡೆಗಾದರೂ ನಾವು ತಿರುಗುವುದಿಲ್ಲ,” ಎಂದು ವಿನಂತಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ಎದೋಮ್ಯರು ದೂತರಿಗೆ, “ನೀನು ಈ ಕಡೆಯಲ್ಲಿ ದಾಟಿ ಹೋಗಬೇಡ. ಹೋದರೆ ನಾನು ಖಡ್ಗದಿಂದ ನಿನ್ನ ಮೇಲೆ ದಾಳಿಗೆ ಬರುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ಅದಕ್ಕೆ ಇಸ್ರಾಯೇಲರು ಅವನಿಗೆ, “ನಾವು ರಾಜಮಾರ್ಗದಲ್ಲಿ ಹೋಗುತ್ತೇವೆ. ನಮ್ಮ ಪಶುಗಳು ನಿನ್ನ ನೀರು ಕುಡಿದರೆ, ಅದರ ಕ್ರಯವನ್ನು ಕೊಡುತ್ತೇವೆ. ನಮ್ಮ ಕಾಲುಗಳಿಂದ ದಾಟಿ ಹೋಗುವುದೇ ಹೊರತು ಮತ್ತೇನೂ ಮಾಡುವುದಿಲ್ಲ,” ಎಂದು ಹೇಳಿ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ಆದರೆ ಅವನು, “ನೀವು ದಾಟಬಾರದು,” ಎಂದನು. ಎದೋಮ್ಯರು ಬಹುಜನರಿಂದಲೂ, ಬಲವುಳ್ಳ ಕೈಯಿಂದಲೂ ಅವರಿಗೆ ಎದುರಾಗಿ ಯುದ್ಧಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ಈ ಪ್ರಕಾರ ಎದೋಮ್ಯನು ಇಸ್ರಾಯೇಲರನ್ನು ತನ್ನ ಮೇರೆಯಲ್ಲಿ ದಾಟಗೊಡಿಸಲಿಲ್ಲ. ಆದಕಾರಣ ಇಸ್ರಾಯೇಲರು ಅವನ ಕಡೆಯಿಂದ ತಿರುಗಿಕೊಂಡು ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಸಮೂಹದವರು ಕಾದೇಶಿನಿಂದ ಪ್ರಯಾಣಮಾಡಿ, ಹೋರ್ ಎಂಬ ಬೆಟ್ಟದ ಬಳಿಗೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ಆಗ ಯೆಹೋವ ದೇವರು ಎದೋಮ್ಯ ದೇಶದ ಮೇರೆಯ ಮೇಲಿರುವ ಹೋರ್ ಎಂಬ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“ಆರೋನನು ತನ್ನ ಪಿತೃಗಳ ಸಂಗಡ ಸೇರುವನು, ಏಕೆಂದರೆ ನೀವು ಮೆರೀಬಾದ ನೀರಿನ ಹತ್ತಿರ ನನ್ನ ಮಾತಿಗೆ ತಿರುಗಿಬಿದ್ದದರಿಂದ, ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ ಕೊಡುವ ದೇಶಕ್ಕೆ ಅವನು ಪ್ರವೇಶಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ಆರೋನನನ್ನೂ, ಅವನ ಮಗ ಎಲಿಯಾಜರನನ್ನೂ ತೆಗೆದುಕೊಂಡು, ಅವರನ್ನು ಹೋರ್ ಬೆಟ್ಟಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಾ. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ಆರೋನನ ವಸ್ತ್ರಗಳನ್ನು ತೆಗೆದು, ಅವುಗಳನ್ನು ಅವನ ಮಗ ಎಲಿಯಾಜರನಿಗೆ ತೊಡಿಸು. ಆರೋನನು ಅಲ್ಲಿ ದೇಹವನ್ನು ಬಿಟ್ಟು ತನ್ನ ಪಿತೃಗಳ ಬಳಿಗೆ ಸೇರಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಮಾಡಿದನು. ಅವರು ಸಮಸ್ತ ಸಭೆಯವರು ನೋಡುತ್ತಿರುವಾಗ ಹೋರ್ ಬೆಟ್ಟವನ್ನೇರಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ಮೋಶೆಯು ಆರೋನನ ವಸ್ತ್ರಗಳನ್ನು ತೆಗೆದು, ಅವನ ಮಗ ಎಲಿಯಾಜರನಿಗೆ ತೊಡಿಸಿದನು. ಆಗ ಆರೋನನು ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿ ಸತ್ತನು. ಮೋಶೆಯೂ, ಎಲಿಯಾಜರನೂ ಬೆಟ್ಟದಿಂದ ಇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ಆರೋನನು ತೀರಿಹೋದನೆಂದು ಸಭೆಯೆಲ್ಲಾ ನೋಡಿದಾಗ, ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಆರೋನನಿಗೋಸ್ಕರ ಮೂವತ್ತು ದಿವಸಗಳವರೆಗೂ ದುಃಖಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ನೆಗೆವನಲ್ಲಿ ವಾಸಿಸುವ ಕಾನಾನ್ಯನಾದ ಅರಾದ್ ಪಟ್ಟಣದ ಅರಸನು, ಇಸ್ರಾಯೇಲರು ಅತಾರೀಮ್ ಮಾರ್ಗವಾಗಿ ಬರುತ್ತಿದ್ದಾರೆಂದು ಕೇಳಿ, ಅವರ ಸಂಗಡ ಯುದ್ಧಮಾಡಿ, ಅವರಲ್ಲಿ ಕೆಲವರನ್ನು ಸೆರೆಹಿಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ಆಗ ಇಸ್ರಾಯೇಲರು ಯೆಹೋವ ದೇವರಿಗೆ ಪ್ರಮಾಣಮಾಡಿ, “ನೀನು ಈ ಜನರನ್ನು ನಮ್ಮ ಕೈಯಲ್ಲಿ ನಿಜವಾಗಿ ಒಪ್ಪಿಸಿಕೊಟ್ಟರೆ, ನಾವು ಅವರ ಪಟ್ಟಣಗಳನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ನಾಶಮಾಡುವೆವು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ಆಗ ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರ ಧ್ವನಿಯನ್ನು ಕೇಳಿ ಕಾನಾನ್ಯರನ್ನು ಒಪ್ಪಿಸಿಕೊಟ್ಟನು. ಇಸ್ರಾಯೇಲರು ಅವರನ್ನೂ ಅವರ ಪಟ್ಟಣಗಳನ್ನೂ ಸಂಪೂರ್ಣವಾಗಿ ನಾಶಮಾಡಿದರು. ಆ ಸ್ಥಳಕ್ಕೆ ಹೊರ್ಮಾ ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ಅವರು ಹೋರ್ ಎಂಬ ಬೆಟ್ಟದಿಂದ ಹೊರಟು, ಎದೋಮ್ಯರ ದೇಶವನ್ನು ಸುತ್ತಿಕೊಂಡು ಹೋಗುವುದಕ್ಕೆ ಕೆಂಪುಸಮುದ್ರದ ಮಾರ್ಗವಾಗಿ ಪ್ರಯಾಣಮಾಡಿದರು. ಆದರೆ ಜನರು ಈ ಪ್ರಯಾಣದಿಂದ ಆಯಾಸವಾಗಿ ಬಹಳ ಕುಂದಿಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ಆದಕಾರಣ ಜನರು ದೇವರಿಗೂ ಮೋಶೆಗೂ ವಿರೋಧವಾಗಿ ಮಾತನಾಡಿ, “ನಾವು ಮರುಭೂಮಿಯಲ್ಲಿ ಸಾಯುವ ಹಾಗೆ ನಮ್ಮನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಏಕೆ ಬರಮಾಡಿದ್ದೀರಿ? ಇಲ್ಲಿ ರೊಟ್ಟಿ ಇಲ್ಲ, ನೀರೂ ಇಲ್ಲ. ನಾವು ಈ ನಿಸ್ಸಾರವಾದ ರೊಟ್ಟಿಯನ್ನು ತಿಂದು ನಮಗೆ ಬೇಸರವಾಗಿದೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ಆಗ ಯೆಹೋವ ದೇವರು ಜನರೊಳಗೆ ವಿಷಸರ್ಪಗಳನ್ನು ಕಳುಹಿಸಿದರು. ಅವು ಜನರನ್ನು ಕಚ್ಚಿದ್ದರಿಂದ, ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಬಹುಜನರು ಸತ್ತುಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ಆದ್ದರಿಂದ ಜನರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು, “ನಾವು ಯೆಹೋವ ದೇವರಿಗೂ ನಿನಗೂ ವಿರೋಧವಾಗಿ ಮಾತನಾಡಿ ಪಾಪಮಾಡಿದ್ದೇವೆ. ಯೆಹೋವ ದೇವರು ನಮ್ಮ ಮೇಲಿಂದ ಸರ್ಪಗಳನ್ನು ದೂರಮಾಡುವ ಹಾಗೆ ಪ್ರಾರ್ಥನೆ ಮಾಡು,” ಎಂದರು. ಆಗ ಮೋಶೆಯು ಜನರಿಗೋಸ್ಕರ ಪ್ರಾರ್ಥನೆಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಕಂಚಿನಿಂದ ಒಂದು ಸರ್ಪವನ್ನು ಮಾಡಿಸಿಕೊಂಡು, ಒಂದು ಕಂಬದ ಮೇಲೆ ಇಡು. ಆಗ ಕಚ್ಚಿಸಿಕೊಂಡವರೆಲ್ಲರೂ ಅದರ ಮೇಲೆ ದೃಷ್ಟಿ ಇಟ್ಟರೆ ಅವರು ಬದುಕುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ಆಗ ಮೋಶೆಯು ಕಂಚಿನ ಸರ್ಪವನ್ನು ಮಾಡಿ ಕಂಬದ ಮೇಲೆ ಇಟ್ಟನು. ಸರ್ಪದಿಂದ ಕಚ್ಚಿಸಿಕೊಂಡವರಲ್ಲಿ ಯಾರು ಆ ಕಂಚಿನ ಸರ್ಪದ ಕಡೆಗೆ ದೃಷ್ಟಿ ಇಟ್ಟು ನೋಡಿದರೋ, ಅವರು ಬದುಕಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ಇಸ್ರಾಯೇಲರು ಹೊರಟು ಓಬೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ಓಬೋತಿನಿಂದ ಹೊರಟು ಮೋವಾಬ್ ದೇಶಕ್ಕೆದುರಾಗಿ ಸೂರ್ಯೋದಯದ ಕಡೆಯಲ್ಲಿರುವ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಯ್ಯೇ ಅಬಾರೀಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ಅಲ್ಲಿಂದ ಅವರು ಹೊರಟು ಜೆರೆದ್ ಎಂಬ ಹಳ್ಳದ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ಅಲ್ಲಿಂದ ಹೊರಟು ಅಮೋರಿಯರ ಪ್ರದೇಶದಿಂದ ಹೊರಗೆ ಬರುವ ಮರುಭೂಮಿಯಲ್ಲಿರುವ ಅರ್ನೋನ್ ಹೊಳೆಯ ಈಚೆಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ಏಕೆಂದರೆ ಅರ್ನೋನ್ ಮೋವಾಬರಿಗೂ ಅಮೋರಿಯರಿಗೂ ಮಧ್ಯದ ಮೋವಾಬಿನ ಗಡಿಯಾಗಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ಆದಕಾರಣ ಯೆಹೋವ ದೇವರ ಯುದ್ಧಗಳ ಪುಸ್ತಕದಲ್ಲಿ ಹೀಗೆಂದು ಬರೆದಿದೆ: “ಸೂಫಕ್ಕೆ ಸೇರಿದ ವಾಹೇಬನ್ನು, ಅರ್ನೋನ್ ");
INSERT INTO kanokcv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ಹೊಳೆಗೆ ಸೇರುವ ಹಳ್ಳಗಳನ್ನು, ಆರ್ ಪಟ್ಟಣದ ತನಕ ಮೋವಾಬಿನ ಎಲ್ಲೆಯಾಗಿರುವ ಕೊರಕಲನ್ನು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ಅವರು ಅಲ್ಲಿಂದ ಬೇರ್ ಎಂಬಲ್ಲಿಗೆ ಬಂದರು. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಜನರನ್ನು ಸೇರಿಸು. ನಾನು ಅವರಿಗೆ ನೀರನ್ನು ಕೊಡುವೆನು,” ಎಂದು ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ ಮಾತು ಇಲ್ಲಿನ ಬಾವಿಯನ್ನು ಕುರಿತೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ಆಗ ಇಸ್ರಾಯೇಲರು ಈ ಹಾಡನ್ನು ಹಾಡಿದರು: “ಬಾವಿಯೇ, ಉಕ್ಕು, ಜನರೇ, ಅದರ ಬಗ್ಗೆ ನೀವು ಹಾಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ಪ್ರಭುಗಳು ಈ ಬಾವಿಯನ್ನು ಅಗೆದರು. ಜನರ ಅಧಿಪತಿಗಳು ನ್ಯಾಯಾಧಿಪತಿಯ ಸಲಹೆಯ ಮೇರೆಗೆ ತಮ್ಮ ಕೋಲುಗಳಿಂದ ಅದನ್ನು ತೋಡಿದರು.” ಆಮೇಲೆ ಅವರು ಮರುಭೂಮಿಯಿಂದ ಮತ್ತಾನಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ಇದಲ್ಲದೆ ಅವರು ಮತ್ತಾನದಿಂದ ನಹಲಿಯೇಲಕ್ಕೆ ಬಂದರು. ನಹಲಿಯೇಲದಿಂದ ಬಾಮೋತಿಗೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ಬಾಮೋತಿನಿಂದ ಮೋವಾಬ್ ದೇಶದಲ್ಲಿರುವ ಕಣಿವೆಯಿಂದ ಪಿಸ್ಗಾ ಎಂಬ ಬೆಟ್ಟದ ತುದಿಗೆ ಬಂದರು. ಆ ಬೆಟ್ಟದ ಮೇಲಿನಿಂದ ಕೆಳಗಿರುವ ಮರಳುಗಾಡು ಕಾಣಿಸುತ್ತದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ಆಗ ಇಸ್ರಾಯೇಲರು ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನ ಬಳಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ನಾವು ನಿನ್ನ ದೇಶವನ್ನು ದಾಟಿಹೋಗುವುದಕ್ಕೆ ನಮಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು. ನಾವು ಯಾವುದೇ ಹೊಲಗಳಲ್ಲಿಯಾಗಲಿ, ದ್ರಾಕ್ಷಿತೋಟಗಳಲ್ಲಿಯಾಗಲಿ ಹೋಗುವುದಿಲ್ಲ, ಬಾವಿಯ ನೀರನ್ನು ಕುಡಿಯದೆ, ನಿನ್ನ ದೇಶವನ್ನು ದಾಟುವವರೆಗೆ ರಾಜಮಾರ್ಗದಲ್ಲಿಯೇ ಹೋಗುತ್ತೇವೆ,” ಎಂದು ಬೇಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ಆದರೆ ಸೀಹೋನನು ಇಸ್ರಾಯೇಲರನ್ನು ತನ್ನ ಮೇರೆಯಲ್ಲಿ ದಾಟಗೊಡಿಸದೆ, ತನ್ನ ಜನರೆಲ್ಲರನ್ನೂ ಕೂಡಿಸಿಕೊಂಡು, ಇಸ್ರಾಯೇಲರನ್ನು ಎದುರಿಸಲು ಮರುಭೂಮಿಗೆ ಹೊರಟನು. ಅವನು ಯಹಚಕ್ಕೆ ಬಂದು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಯುದ್ಧಮಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ಆದರೆ ಇಸ್ರಾಯೇಲರು ಅವನನ್ನು ಖಡ್ಗದಿಂದ ಹೊಡೆದು, ಅವನ ದೇಶವನ್ನು ಅರ್ನೋನ್ ನದಿಯಿಂದ ಯಬ್ಬೋಕ್ ನದಿಯವರೆಗೆ ಅಮ್ಮೋನನ ಮಕ್ಕಳ ಮೇರೆಯವರೆಗೂ ಸ್ವಾಧೀನಪಡಿಸಿಕೊಂಡರು. ಏಕೆಂದರೆ ಅಮ್ಮೋನನ ಮಕ್ಕಳ ಮೇರೆಯು ಬಲಿಷ್ಠವಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ಇಸ್ರಾಯೇಲರು ಆ ಪಟ್ಟಣಗಳನ್ನೆಲ್ಲಾ ವಶಮಾಡಿಕೊಂಡರು. ಇಸ್ರಾಯೇಲರು ಅಮೋರಿಯರ ಸಮಸ್ತ ಪಟ್ಟಣಗಳಲ್ಲಿಯೂ ಹೆಷ್ಬೋನಿನಲ್ಲಿಯೂ ಅದರ ಸಮಸ್ತ ಗ್ರಾಮಗಳಲ್ಲಿಯೂ ವಾಸಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ಹೆಷ್ಬೋನ್ ಪಟ್ಟಣವು ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನ ಪಟ್ಟಣವಾಗಿತ್ತು. ಅವನು ಮೋವಾಬ್ ದೇಶದ ಹಿಂದಿನ ಅರಸನ ಸಂಗಡ ಯುದ್ಧಮಾಡಿ, ಅವನ ಸಮಸ್ತ ದೇಶವನ್ನು ಅರ್ನೋನ್ ನದಿಯವರೆಗೂ ಅವನಿಂದ ವಶಪಡಿಸಿಕೊಂಡಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ಇದರ ಬಗ್ಗೆ ಕವಿಗಳು ಹೀಗೆಂದು ಹಾಡಿದ್ದಾರೆ: “ಹೆಷ್ಬೋನಿಗೆ ಬನ್ನಿರಿ ಅದನ್ನು ತಿರುಗಿ ಕಟ್ಟಬೇಕು. ಸೀಹೋನನ ಪಟ್ಟಣವನ್ನು ಪುನಃಸ್ಥಾಪನೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“ಏಕೆಂದರೆ ಬೆಂಕಿ ಹೆಷ್ಬೋನಿನಿಂದಲೂ, ಜ್ವಾಲೆಯು ಸೀಹೋನನ ಪಟ್ಟಣದಿಂದಲೂ ಹೊರಟು, ಮೋವಾಬಿನ ಆರ್ ಎಂಬ ಪಟ್ಟಣವನ್ನೂ, ಅರ್ನೋನ್ ಹೊಳೆಯ ಬಳಿಯಲ್ಲಿರುವ ಎತ್ತರ ಸ್ಥಳಗಳ ಪ್ರಭುಗಳನ್ನೂ ದಹಿಸಿಬಿಟ್ಟಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ಮೋವಾಬೇ, ನಿನಗೆ ದಿಕ್ಕಾರ! ಕೆಮೋಷಿನ ಜನವೇ ನಿಮಗೆ ದುರ್ಗತಿ ಉಂಟಾಯಿತಲ್ಲಾ! ಅವನು ತನ್ನ ಪುತ್ರರನ್ನು ದೇಶಭ್ರಷ್ಟರನ್ನಾಗಿಯೂ ತನ್ನ ಪುತ್ರಿಯರನ್ನು ಸೆರೆಯವರನ್ನಾಗಿಯೂ ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನ ಸೆರೆಗೆ ಒಪ್ಪಿಸಿಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“ನಾವು ಅವರನ್ನು ಪದಚ್ಚುತಿಗೊಳಿಸಿದೆವು. ಹೆಷ್ಬೋನು ದೀಬೋನಿನವರೆಗೂ ನಾಶವಾಯಿತು. ನಾವು ಅವರನ್ನು ಮೇದೆಬಾಕ್ಕೆ ಮುಟ್ಟುವ ನೋಫಹದ ತನಕ ಹಾಳುಮಾಡಿದೆವು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ಹೀಗೆ ಇಸ್ರಾಯೇಲರು ಅಮೋರಿಯರ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ಇದಲ್ಲದೆ ಮೋಶೆಯು ಯಜ್ಜೇರನ್ನು ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕೆ ಗೂಢಚಾರರನ್ನು ಕಳುಹಿಸಿದನು. ಅವರು ಅವರ ಗ್ರಾಮಗಳನ್ನು ವಶಪಡಿಸಿಕೊಂಡು, ಅಲ್ಲಿರುವ ಅಮೋರಿಯರನ್ನು ಹೊರಡಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ಅವರು ತಿರುಗಿ ಬಾಷಾನಿನ ಹಾದಿ ಏರಿದರು. ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನು ಎದ್ರೈಯಲ್ಲಿ ಯುದ್ಧಮಾಡುವುದಕ್ಕೆ ತನ್ನ ಸಮಸ್ತ ಜನರ ಸಂಗಡ ಅವರಿಗೆದುರಾಗಿ ಹೊರಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು ಅವನಿಗೆ ಭಯಪಡಬೇಡ, ಏಕೆಂದರೆ ನಿನ್ನ ಕೈಯೊಳಗೆ ನಾನು ಅವನನ್ನೂ ಅವನ ಸಮಸ್ತ ಜನರನ್ನೂ ಅವನ ದೇಶವನ್ನೂ ಕೊಟ್ಟಿದ್ದೇನೆ. ನೀನು ಹೆಷ್ಬೋನಿನಲ್ಲಿ ವಾಸಮಾಡಿದ ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನಿಗೆ ಮಾಡಿದ ಪ್ರಕಾರ ಇವನಿಗೂ ಮಾಡಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ಈ ಪ್ರಕಾರ ಅವರು ಅವನನ್ನೂ ಅವನ ಮಕ್ಕಳನ್ನೂ ಅವನ ಸಮಸ್ತ ಜನರನ್ನೂ ಅವನಿಗೆ ಒಬ್ಬನಾದರೂ ಉಳಿಯದಂತೆ ಹೊಡೆದು, ಅವನ ದೇಶವನ್ನು ವಶಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ನಂತರ ಇಸ್ರಾಯೇಲರು ಹೊರಟು ಯೊರ್ದನಿಗೆ ಈಚೆಯಲ್ಲಿರುವ ಮೋವಾಬಿನ ಬಯಲುಗಳಲ್ಲಿ ಯೆರಿಕೋ ಪಟ್ಟಣಕ್ಕೆ ಎದುರಾಗಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ಆದರೆ ಚಿಪ್ಪೋರನ ಮಗ ಬಾಲಾಕನು ಇಸ್ರಾಯೇಲರು ಅಮೋರಿಯರಿಗೆ ಮಾಡಿದ್ದನ್ನೆಲ್ಲಾ ನೋಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ಇದಲ್ಲದೆ ಮೋವಾಬಿನವರು, ಇಸ್ರಾಯೇಲರು ಬಹಳ ಜನರಾಗಿರುವುದರಿಂದ ಅವರಿಗೆ ಬಹಳವಾಗಿ ಅಂಜಿದರು. ಮೋವಾಬಿನವರು ಇಸ್ರಾಯೇಲರಿಗೆ ದಿಗಿಲುಪಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ಮೋವಾಬ್ಯರು ಮಿದ್ಯಾನ್ಯರ ಹಿರಿಯರಿಗೆ, “ಎತ್ತು ಅಡವಿಯ ಹುಲ್ಲನ್ನು ಮೇಯುವಂತೆ, ಈಗ ಈ ಸಮೂಹವು ನಮ್ಮ ಸುತ್ತಲಿರುವುದನ್ನೆಲ್ಲಾ ಮೇಯುವುದು,” ಎಂದನು. ಆ ಕಾಲದಲ್ಲಿ ಚಿಪ್ಪೋರನ ಮಗ ಬಾಲಾಕನು ಮೋವಾಬ್ಯರ ಅರಸನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ಇವನು ಸ್ವಜನರ ನಾಡಾದ ಯೂಫ್ರೇಟೀಸ್ ನದಿಯ ತೀರದಲ್ಲಿರುವ ಪೆತೋರೂರಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ, ಬೆಯೋರನ ಮಗ ಬಿಳಾಮನನ್ನೂ ಕರೆಯಿಸಿ, “ಒಂದು ಜನಾಂಗವು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಟು ಬಂದಿದೆ. ಅದು ದೇಶವನ್ನೆಲ್ಲಾ ಆವರಿಸಿಕೊಂಡು, ನನಗೆದುರಾಗಿ ವಾಸಿಸುತ್ತಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ಅವರು ನನಗಿಂತ ಬಲವುಳ್ಳವರಾಗಿದ್ದರಿಂದ ಈಗ ನೀನು ದಯಮಾಡಿ ಬಂದು, ಈ ಜನರನ್ನು ನನಗಾಗಿ ಶಪಿಸು. ಆಗ ನಾನು ಅವರನ್ನು ಗೆದ್ದು, ದೇಶದೊಳಗಿಂದ ಹೊರಡಿಸುವುದಕ್ಕೆ ನನ್ನಿಂದ ಸಾಧ್ಯವಾಗಬಹುದು. ಏಕೆಂದರೆ ನೀನು ಯಾವನನ್ನು ಆಶೀರ್ವದಿಸುತ್ತೀಯೋ, ಅವನು ಆಶೀರ್ವಾದ ಹೊಂದಿರುವನು; ನೀನು ಯಾವನನ್ನು ಶಪಿಸುತ್ತೀಯೋ, ಅವನು ಶಾಪಗ್ರಸ್ತನಾಗಿರುವನು; ಎಂದು ನಾನು ಬಲ್ಲೆನು,” ಎಂದು ಹೇಳಿ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ಆಗ ಮೋವಾಬಿನ ಹಿರಿಯರೂ ಮಿದ್ಯಾನಿನ ಹಿರಿಯರೂ ಭವಿಷ್ಯವಾಣಿ ಕೇಳಲು ಸಲ್ಲಿಸಬೇಕಾದ ಕಾಣಿಕೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋದರು. ಅವರು ಬಿಳಾಮನ ಬಳಿಗೆ ಬಂದು, ಅವನಿಗೆ ಬಾಲಾಕನ ಮಾತುಗಳನ್ನು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ಅವನು ಅವರಿಗೆ, “ಈ ರಾತ್ರಿ ಇಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳಿರಿ. ಯೆಹೋವ ದೇವರು ನನಗೆ ಹೇಳುವ ಪ್ರಕಾರ ನಿಮಗೆ ಉತ್ತರವನ್ನು ಕೊಡುವೆನು,” ಎಂದು ಹೇಳಿದನು. ಆದಕಾರಣ ಮೋವಾಬಿನ ಪ್ರಭುಗಳು ಬಿಳಾಮನ ಸಂಗಡ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ದೇವರು ಬಿಳಾಮನ ಬಳಿಗೆ ಬಂದು, “ನಿನ್ನ ಸಂಗಡ ಇರುವ ಈ ಮನುಷ್ಯರು ಯಾರು?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ಬಿಳಾಮನು ದೇವರಿಗೆ, “ಚಿಪ್ಪೋರನ ಮಗನಾಗಿಯೂ ಮೋವಾಬಿನ ಅರಸನಾಗಿಯೂ ಇರುವ ಬಾಲಾಕನು ನನ್ನ ಬಳಿಗೆ ಹೇಳಿ ಕಳುಹಿಸಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘ಇಗೋ, ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಹೊರಟಿರುವ ಒಂದು ಜನಾಂಗವು ದೇಶವನ್ನೆಲ್ಲಾ ಆವರಿಸಿಕೊಂಡಿದೆ. ಈಗ ನೀನು ಬಂದು ನನಗೋಸ್ಕರ ಅವರನ್ನು ಶಪಿಸು. ಒಂದು ವೇಳೆ ಅವರ ಸಂಗಡ ಯುದ್ಧಮಾಡಿ ಹೊರಗೆ ಹಾಕುವುದಕ್ಕೆ ನನ್ನಿಂದ ಸಾಧ್ಯವಾಗಬಹುದು,’ ಎಂದು ಹೇಳಿ ಕಳುಹಿಸಿದ್ದಾನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ಆಗ ದೇವರು ಬಿಳಾಮನಿಗೆ, “ನೀನು ಅವರ ಸಂಗಡ ಹೋಗಬೇಡ, ನೀನು ಆ ಜನರನ್ನು ಶಪಿಸಬೇಡ, ಏಕೆಂದರೆ ಅವರು ನನ್ನಿಂದ ಆಶೀರ್ವಾದ ಹೊಂದಿದವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ಬಿಳಾಮನು ಉದಯದಲ್ಲಿ ಎದ್ದು ಬಾಲಾಕನ ಪ್ರಭುಗಳಿಗೆ, “ನಿಮ್ಮ ದೇಶಕ್ಕೆ ಹೋಗಿರಿ. ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ಸಂಗಡ ಹೋಗುವುದಕ್ಕೆ ನನಗೆ ಅಪ್ಪಣೆ ಕೊಡಲಿಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ಆದಕಾರಣ ಮೋವಾಬಿನ ಪ್ರಭುಗಳು ಎದ್ದು ಬಾಲಾಕನ ಬಳಿಗೆ ಬಂದು, “ಬಿಳಾಮನು ನಮ್ಮ ಸಂಗಡ ಬರಲಿಲ್ಲ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ಆದರೆ ಬಾಲಾಕನು ತಿರುಗಿ ಇವರಿಗಿಂತ ಹೆಚ್ಚು ಘನವುಳ್ಳವರಾದ ಅನೇಕ ಪ್ರಧಾನರನ್ನು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ಅವರು ಬಿಳಾಮನ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, “ಚಿಪ್ಪೋರನ ಮಗ ಬಾಲಾಕನು ಹೀಗೆ ಹೇಳುತ್ತಾನೆ: ನೀನು ದಯಮಾಡಿ ನನ್ನ ಬಳಿಗೆ ಬರಲು ಅಡ್ಡಿಮಾಡುವ ಯಾವುದಕ್ಕೂ ಅವಕಾಶ ಕೊಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ಏಕೆಂದರೆ ನಾನು ನಿನ್ನನ್ನು ಬಹಳವಾಗಿ ಘನಪಡಿಸುವೆನು. ನೀನು ಹೇಳುವುದನ್ನೆಲ್ಲಾ ನಾನು ಮಾಡುವೆನು. ಆದಕಾರಣ ನೀನು ದಯಮಾಡಿ ಬಂದು ಈ ಜನರನ್ನು ನನಗಾಗಿ ಶಪಿಸು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ಬಿಳಾಮನು ಪ್ರತ್ಯುತ್ತರವಾಗಿ ಬಾಲಾಕನ ಸೇವಕರಿಗೆ, “ಬಾಲಾಕನು ನನಗೆ ತನ್ನ ಮನೆ ತುಂಬುವಷ್ಟು ಬೆಳ್ಳಿಬಂಗಾರ ಕೊಟ್ಟರೂ ನಾನು ನನ್ನ ದೇವರಾಗಿರುವ ಯೆಹೋವ ದೇವರ ಮಾತನ್ನು ಮೀರಿ ಹೆಚ್ಚು ಕಡಿಮೆ ಏನನ್ನೂ ಮಾಡಲಾರೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ಆದರೆ ಈಗ ಯೆಹೋವ ದೇವರು ನನಗೆ ಮತ್ತೇನು ಹೇಳುವರೆಂದು ನಾನು ತಿಳಿದುಕೊಳ್ಳುವ ಹಾಗೆ, ನೀವು ಸಹ ದಯಮಾಡಿ ಈ ರಾತ್ರಿ ಇಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳಿರಿ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ಆಗ ದೇವರು ಬಿಳಾಮನ ಬಳಿಗೆ ರಾತ್ರಿಯಲ್ಲಿ ಬಂದು ಅವನಿಗೆ, “ಈ ಮನುಷ್ಯರು ನಿನ್ನನ್ನು ಕರೆಯುವುದಕ್ಕೆ ಬಂದಿದ್ದರೆ, ನೀನು ಎದ್ದು ಅವರ ಸಂಗಡ ಹೋಗು. ಆದರೆ ನಾನು ನಿನಗೆ ಹೇಳುವ ಮಾತಿನಂತೆಯೇ ನೀನು ಮಾಡಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ಬಿಳಾಮನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು, ತನ್ನ ಕತ್ತೆಯನ್ನು ಹತ್ತಿ, ಮೋವಾಬಿನ ಪ್ರಧಾನರ ಸಂಗಡ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ಆದರೆ ಅವನು ಹೋದದ್ದರಿಂದ ದೇವರಿಗೆ ಕೋಪ ಬಂದಿತು. ಯೆಹೋವ ದೇವರ ದೂತನು ಅವನಿಗೆ ಎದುರಾಳಿಯಾಗಿ ಮಾರ್ಗದಲ್ಲಿ ನಿಂತುಕೊಂಡನು. ಬಿಳಾಮನು ತನ್ನ ಕತ್ತೆಯ ಮೇಲೆ ಹತ್ತಿಕೊಂಡಿದ್ದನು. ಅವನ ಇಬ್ಬರು ಆಳುಗಳು ಅವನ ಸಂಗಡ ಇದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ಕತ್ತೆಯು ಮಾರ್ಗದಲ್ಲಿ ನಿಂತಿದ್ದ ಯೆಹೋವ ದೇವರ ದೂತನನ್ನೂ, ಅವನ ಕೈಯಲ್ಲಿರುವ ಬಿಚ್ಚುಗತ್ತಿಯನ್ನೂ ನೋಡಿ, ಮಾರ್ಗದಿಂದ ವಾರೆಯಾಗಿ ಹೊಲದೊಳಗೆ ಹೋಯಿತು. ಆಗ ಬಿಳಾಮನು ಕತ್ತೆಯನ್ನು ಮಾರ್ಗದೊಳಗೆ ತಿರುಗಿಸುವುದಕ್ಕೆ ಅದನ್ನು ಹೊಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ಆದರೆ ಯೆಹೋವ ದೇವರ ದೂತನು ದ್ರಾಕ್ಷಿತೋಟಗಳ ನಡುವಿನ ಕಿರಿದಾದ ಹಾದಿಯಲ್ಲಿ ಎರಡೂ ಕಡೆಯಲ್ಲಿ ಗೋಡೆ ಇದ್ದಲ್ಲಿ ನಿಂತನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ಕತ್ತೆಯು ಯೆಹೋವ ದೇವರ ದೂತನನ್ನು ನೋಡಿ ಗೋಡೆಗೆ ಒತ್ತಿಕೊಂಡು, ಬಿಳಾಮನ ಕಾಲನ್ನು ಗೋಡೆಗೆ ಒತ್ತಿ ಹಾಕಿತು. ಅವನು ಅದನ್ನು ಮತ್ತೆ ಹೆಚ್ಚಾಗಿ ಹೊಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ಆಗ ಯೆಹೋವ ದೇವರ ದೂತನು ಮುಂದೆ ಹೋಗಿ ಬಲಕ್ಕೂ ಎಡಕ್ಕೂ ತಿರುಗುವುದಕ್ಕೆ ಮಾರ್ಗವಿಲ್ಲದ ಇಕ್ಕಟ್ಟಿನ ಸ್ಥಳದಲ್ಲಿ ನಿಂತನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ಕತ್ತೆಯು ಯೆಹೋವ ದೇವರ ದೂತನನ್ನು ನೋಡಿ ಬಿಳಾಮನ ಕೆಳಗೆ ಬಿತ್ತು. ಆದಕಾರಣ ಬಿಳಾಮನು ಕೋಪಿಸಿಕೊಂಡು ಕತ್ತೆಯನ್ನು ಬೆತ್ತದಿಂದ ಹೊಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ಆಗ ಯೆಹೋವ ದೇವರು ಕತ್ತೆಗೆ ಮಾತಾಡುವ ಶಕ್ತಿಯನ್ನು ಕೊಟ್ಟರು. ಅದು ಬಿಳಾಮನಿಗೆ, “ಈಗ ನನ್ನನ್ನು ಮೂರು ಸಾರಿ ಹೊಡೆಯುವ ಹಾಗೆ ನಾನು ನಿನಗೆ ಏನು ಮಾಡಿದೆನು?” ಎಂದು ಕೇಳಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ಬಿಳಾಮನು ಕತ್ತೆಗೆ, “ನೀನು ನನಗೆ ಹಾಸ್ಯಮಾಡಿದೆಯಲ್ಲಾ? ನನ್ನ ಕೈಯಲ್ಲಿ ಖಡ್ಗ ಇದ್ದಿದ್ದರೆ, ನಾನು ಈಗಲೇ ನಿನ್ನನ್ನು ಕೊಂದು ಹಾಕುತ್ತಿದ್ದೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ಕತ್ತೆಯು ಬಿಳಾಮನಿಗೆ, “ಈ ದಿವಸದವರೆಗೂ ನೀನು ಯಾವಾಗಲೂ ಸವಾರಿಮಾಡುತ್ತಿದ್ದ ಕತ್ತೆಯು ನಾನಲ್ಲವೋ? ನಾನು ಎಂದಾದರೂ ನಿನಗೆ ಈ ರೀತಿ ಮಾಡಿದೆನೋ?” ಎಂದು ಪ್ರಶ್ನಿಸಿತು. ಅದಕ್ಕವನು, “ಇಲ್ಲ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ಆಗ ಯೆಹೋವ ದೇವರು ಬಿಳಾಮನ ಕಣ್ಣುಗಳನ್ನು ತೆರೆದರು. ಅವನು ಮಾರ್ಗದಲ್ಲಿ ನಿಂತಿದ್ದ ಯೆಹೋವ ದೇವರ ದೂತನನ್ನೂ, ಆತನ ಕೈಯಲ್ಲಿರುವ ಬಿಚ್ಚುಗತ್ತಿಯನ್ನೂ ನೋಡಿ ಬೋರಲು ಬಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ಯೆಹೋವ ದೇವರ ದೂತನು ಅವನಿಗೆ, “ನಿನ್ನ ಕತ್ತೆಯನ್ನು ಈಗ ಮೂರು ಸಾರಿ ಹೊಡೆದದ್ದು ಏಕೆ? ಇಗೋ, ನಿನ್ನ ಮಾರ್ಗವು ನನ್ನ ಮುಂದೆ ವಕ್ರವಾಗಿರುವುದರಿಂದ ನಾನು ನಿನ್ನನ್ನು ತಡೆಯುವುದಕ್ಕೆ ಬಂದಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ಆ ಕತ್ತೆ ನನ್ನನ್ನು ನೋಡಿ, ನನ್ನ ಮುಂದೆ ಈಗ ಮೂರು ಸಾರಿ ಓರೆಯಾಗಿ ಹೋಯಿತು. ಅದು ನನ್ನ ಮುಂದೆ ಓರೆಯಾಗಿ ಹೋಗದಿದ್ದರೆ, ನಿಶ್ಚಯವಾಗಿ ಆಗಲೇ ನಿನ್ನನ್ನು ಕೊಂದುಹಾಕಿ ಕತ್ತೆಯನ್ನು ಉಳಿಸುತ್ತಿದ್ದೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ಆಗ ಬಿಳಾಮನು ಯೆಹೋವ ದೇವರ ದೂತನಿಗೆ, “ನಾನು ಪಾಪಮಾಡಿದ್ದೇನೆ. ನೀನು ನನಗೆದುರಾಗಿ ಮಾರ್ಗದಲ್ಲಿ ನಿಂತಿದ್ದಿ ಎಂದು ನನಗೆ ತಿಳಿಯಲಿಲ್ಲ. ಹೀಗಿರಲಾಗಿ ಅದು ನಿನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ಕೆಟ್ಟದ್ದಾದರೆ, ನಾನು ತಿರುಗಿ ಹಿಂದಕ್ಕೆ ಹೋಗುತ್ತೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ಆದರೆ ಯೆಹೋವ ದೇವರ ದೂತನು ಬಿಳಾಮನಿಗೆ, “ಈ ಮನುಷ್ಯರ ಸಂಗಡ ಹೋಗು ಆದರೆ ನಾನು ನಿನಗೆ ಹೇಳುವುದನ್ನೇ ಹೇಳಬೇಕೇ ಹೊರತು ಬೇರೆ ಯಾವದನ್ನೂ ಹೇಳಬಾರದು,” ಎಂದನು. ಹಾಗೆಯೇ ಬಿಳಾಮನು ಬಾಲಾಕನ ಪ್ರಭುಗಳ ಸಂಗಡ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ಬಿಳಾಮನು ಬಂದನೆಂದು ಬಾಲಾಕನು ಕೇಳಿದಾಗ, ಅವನು ಕಡೆಯ ಮೇರೆಯಲ್ಲಿರುವ ಅರ್ನೋನ್ ಹೊಳೆಯ ತೀರದಲ್ಲಿದ್ದ ಮೋವಾಬಿನ ಪಟ್ಟಣಕ್ಕೆ ಬರಮಾಡಿಕೊಳ್ಳಲು ಹೊರಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ನಾನು ನಿನಗೆ ತುರ್ತಾಗಿ ಬರುವಂತೆ ಹೇಳಿ ಕಳುಹಿಸಲಿಲ್ಲವೋ? ನೀನು ನನ್ನ ಬಳಿಗೆ ಏಕೆ ಬರಲಿಲ್ಲ? ನಾನು ನಿನ್ನನ್ನು ಘನಪಡಿಸಲು ನಿಶ್ಚಯವಾಗಿ ಸಾಮರ್ಥ್ಯವುಳ್ಳವನಲ್ಲವೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ಇಗೋ, ನಾನು ನಿನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದೇನೆ. ಆದರೆ ಈಗ ನಿನಗೆ ಇಷ್ಟವಾಗುವಂಥದ್ದನ್ನು ಹೇಳುವುದು ನನಗೆ ಸಾಧ್ಯವಿಲ್ಲ? ದೇವರು ನನ್ನಿಂದ ಆಡಿಸಿದ ಮಾತನ್ನೇ ಹೇಳುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ಆಗ ಬಿಳಾಮನು ಬಾಲಾಕನ ಸಂಗಡ ಹೋದನು. ಇಬ್ಬರು ಕಿರ್ಯತ್ ಹುಚೋತಿಗೆ ಬಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ಬಾಲಾಕನು ಎತ್ತುಗಳನ್ನೂ ಕುರಿಗಳನ್ನೂ ಅರ್ಪಿಸಿದನು. ಅದರಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಬಿಳಾಮನಿಗೂ ಅವನ ಸಂಗಡ ಇದ್ದ ಪ್ರಭುಗಳಿಗೂ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ಮರುದಿವಸದಲ್ಲಿ ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು ಕರೆದುಕೊಂಡು ಬಾಮೋತ್ ಬಾಳ್ ದೇವತೆಯ ಎತ್ತರವಾದ ಸ್ಥಳಕ್ಕೆ ಹತ್ತಿ, ಅಲ್ಲಿಂದ ಅವನು ಇಸ್ರಾಯೇಲ್ ಜನರ ಒಂದು ಭಾಗವನ್ನು ತೋರಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ಆಗ ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ಇಲ್ಲಿ ನನಗೆ ಏಳು ಬಲಿಪೀಠಗಳನ್ನು ಕಟ್ಟಿ, ನನಗೆ ಏಳು ಹೋರಿಗಳನ್ನೂ ಏಳು ಟಗರುಗಳನ್ನೂ ಸಿದ್ಧಮಾಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ಬಿಳಾಮನು ಹೇಳಿದ ಪ್ರಕಾರ ಬಾಲಾಕನು ಮಾಡಿದನು. ಬಾಲಾಕನು ಮತ್ತು ಬಿಳಾಮನು ಒಂದೊಂದು ಹೋರಿಯನ್ನೂ ಒಂದೊಂದು ಟಗರನ್ನೂ ಬಲಿಪೀಠದ ಮೇಲೆ ಅರ್ಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ಆಗ ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ನೀನು ನಿನ್ನ ದಹನಬಲಿಯ ಹತ್ತಿರ ನಿಂತುಕೋ, ನಾನು ಸ್ವಲ್ಪ ದೂರಹೋಗಿ ಬರುತ್ತೇನೆ. ಯೆಹೋವ ದೇವರು ನನಗೆ ದರ್ಶನ ಕೊಡಬಹುದು, ಅವರು ನನಗೆ ಸೂಚಿಸುವ ಸಂಗತಿಗಳನ್ನು ನಿನಗೆ ತಿಳಿಸುವೆನು,” ಎಂದು ಹೇಳಿ, ಒಂದು ಎತ್ತರವಾದ ಸ್ಥಳಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ಆಗ ದೇವರು ಬಿಳಾಮನನ್ನು ಸಂಧಿಸಿದರು. ಬಿಳಾಮನು ಅವರಿಗೆ, “ನಾನು ಏಳು ಬಲಿಪೀಠಗಳನ್ನು ಸಿದ್ಧಮಾಡಿ, ಒಂದೊಂದು ಬಲಿಪೀಠದ ಮೇಲೆ ಒಂದೊಂದು ಹೋರಿಯನ್ನೂ, ಒಂದೊಂದು ಟಗರನ್ನೂ ಅರ್ಪಿಸಿದ್ದೇನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ಯೆಹೋವ ದೇವರು ಬಿಳಾಮನ ಬಾಯಲ್ಲಿ ತನ್ನ ಮಾತನ್ನು ಇಟ್ಟು ಅವನಿಗೆ, “ನೀನು ಬಾಲಾಕನ ಬಳಿಗೆ ತಿರುಗಿ ಹೋಗಿ, ನಾನು ಹೇಳಿದ್ದನ್ನು ತಿಳಿಸು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ಆಗ ಅವನು ಬಾಲಾಕನ ಬಳಿಗೆ ತಿರುಗಿಬಂದನು. ಬಾಲಾಕನೂ ಮೋವಾಬಿನ ಸಕಲ ಪ್ರಭುಗಳೂ ಅವನು ಮಾಡಿದ ದಹನಬಲಿಯ ಹತ್ತಿರ ನಿಂತಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ಆಗ ಅವನು ಪದ್ಯರೂಪವಾಗಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಬಾಲಾಕನು ನನ್ನನ್ನು ಅರಾಮಿನಿಂದಲೂ, ಮೋವಾಬಿನ ಅರಸನು ಪೂರ್ವ ಪರ್ವತಗಳಿಂದಲೂ ಕರೆಯಿಸಿ, ‘ನನಗೋಸ್ಕರ ಯಾಕೋಬನನ್ನು ಶಪಿಸಿ ಬಾ, ಇಸ್ರಾಯೇಲನ್ನು ಎದುರಿಸುವುದಕ್ಕೆ ಬಾ,’ ಎಂದು ನನಗೆ ಹೇಳಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ದೇವರು ಶಪಿಸದವನನ್ನು ನಾನು ಹೇಗೆ ಶಪಿಸಲಿ? ಯೆಹೋವ ದೇವರು ಎದುರಿಸದವನನ್ನು ನಾನು ಹೇಗೆ ಎದುರಿಸಲಿ? ");
INSERT INTO kanokcv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ಬೆಟ್ಟಗಳ ತುದಿಯಿಂದ ಅವರನ್ನು ನೋಡುತ್ತೇನೆ. ಎತ್ತರದ ಗುಡ್ಡಗಳಿಂದ ಅವರನ್ನು ದೃಷ್ಟಿಸಿದ್ದೇನೆ. ನಾನು ಆ ಪ್ರತ್ಯೇಕವಾಗಿ ವಾಸಿಸುವ ಜನರನ್ನು ನೋಡುತ್ತೇನೆ. ಆ ಜನಾಂಗವು ತಾನು ಇತರ ಜನಾಂಗಗಳಂತೆ ಸಾಧಾರಣವೆಂದು ಎಣಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ಧೂಳಿನಷ್ಟು ಅಸಂಖ್ಯವಾದ ಯಾಕೋಬರನ್ನು ಎಣಿಸುವುದಕ್ಕೂ, ಇಸ್ರಾಯೇಲಿನ ನಾಲ್ಕನೆಯ ಒಂದು ಪಾಲನ್ನು ಲೆಕ್ಕ ಮಾಡುವುದಕ್ಕೂ ಯಾರಿಂದಾದೀತು? ನೀತಿವಂತನು ಸಾಯುವಂತೆ ನಾನೂ ಸಾಯಬೇಕು. ನನ್ನ ಅಂತ್ಯವು ಅವರಂತೆಯೇ ಆಗಲಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ಆಗ ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ಇದೇನು ನೀನು ನನಗೆ ಮಾಡಿದ್ದು? ನನ್ನ ಶತ್ರುಗಳನ್ನು ಶಪಿಸುವುದಕ್ಕೆ ನಿನ್ನನ್ನು ಕರೆಯಿಸಿದೆನು, ನೀನು ಅವರನ್ನು ಶಪಿಸದೆ ಸಂಪೂರ್ಣವಾಗಿ ಆಶೀರ್ವದಿಸಿದೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ಅದಕ್ಕೆ ಅವನು ಉತ್ತರವಾಗಿ, “ಯೆಹೋವ ದೇವರು ನನ್ನ ಬಾಯಿಯೊಳಗೆ ಇಡುವ ಮಾತನ್ನೇ ನಾನು ನುಡಿಯಬೇಕಲ್ಲವೇ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ಬಾಲಾಕನು ಅವನಿಗೆ, “ನೀನು ಅವರನ್ನು ನೋಡತಕ್ಕ ಮತ್ತೊಂದು ಸ್ಥಳಕ್ಕೆ ನನ್ನೊಂದಿಗೆ ಬಾ, ಅವರನ್ನೆಲ್ಲಾ ನೋಡದೆ ಸಮೀಪದಲ್ಲಿ ಇರುವವರನ್ನು ಮಾತ್ರ ನೋಡುವೆ. ಅಲ್ಲಿಂದ ಅವರನ್ನು ನನಗೋಸ್ಕರ ಶಪಿಸು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ಹೀಗೆ ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು ಪಿಸ್ಗಾದ ತುದಿಗೆ ಚೋಫೀಮ್ ಬಯಲಿಗೆ ಕರೆದುಕೊಂಡು ಹೋಗಿ ಏಳು ಬಲಿಪೀಠಗಳನ್ನು ಕಟ್ಟಿ ಒಂದೊಂದು ಬಲಿಪೀಠದ ಮೇಲೆ ಒಂದೊಂದು ಹೋರಿಯನ್ನೂ, ಒಂದೊಂದು ಟಗರನ್ನೂ ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ಆಗ ಅವನು ಬಾಲಾಕನಿಗೆ, “ಇಲ್ಲಿ ನಿನ್ನ ದಹನಬಲಿಯ ಹತ್ತಿರ ನಿಂತುಕೋ. ನಾನು ಅಲ್ಲಿ ಯೆಹೋವ ದೇವರನ್ನು ಎದುರುಗೊಳ್ಳುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ಆಗ ಯೆಹೋವ ದೇವರು ಬಿಳಾಮನ ಎದುರಿಗೆ ಬಂದು ಅವನ ಬಾಯಿಯೊಳಗೆ ವಾಕ್ಯವನ್ನಿಟ್ಟು, “ನೀನು ಬಾಲಾಕನ ಬಳಿಗೆ ತಿರುಗಿ ಹೋಗಿ ನಾನು ಹೇಳಿದಂತೆಯೇ ತಿಳಿಸು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ಅವನ ಸಂಗಡ ಮೋವಾಬಿನ ಪ್ರಧಾನರೂ ಅವನ ದಹನಬಲಿಯ ಹತ್ತಿರ ನಿಂತುಕೊಂಡಿದ್ದರು. ಬಾಲಾಕನು ಅವನಿಗೆ, “ಯೆಹೋವ ದೇವರು ಏನು ಹೇಳಿದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ಅವನು ಪದ್ಯರೂಪವಾಗಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಬಾಲಾಕನೇ, ಎದ್ದು ಕೇಳು; ಚಿಪ್ಪೋರನ ಮಗನೇ, ನನಗೆ ಕಿವಿಗೊಡು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ದೇವರು ಮನುಷ್ಯನಂತೆ ಸುಳ್ಳಾಡುವವರಲ್ಲ. ನರಪುತ್ರರಂತೆ ಮನಸ್ಸನ್ನು ಬದಲಾಯಿಸಿಕೊಳ್ಳುವವರಲ್ಲ. ಅವರು ನುಡಿದದ್ದನ್ನು ಮಾಡದಿರುವರೇ? ವಾಗ್ದಾನ ಮಾಡಿದ್ದನ್ನು ಅವರು ನೆರವೇರಿಸದಿರುವರೇ? ");
INSERT INTO kanokcv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ಆಶೀರ್ವದಿಸುವುದಕ್ಕೆ ನಾನು ಅಪ್ಪಣೆ ಹೊಂದಿದ್ದೇನೆ. ಅವರು ಆಶೀರ್ವದಿಸಿದ ನಂತರ ನಾನು ಅದನ್ನು ಬದಲಾಯಿಸಲಾರೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“ಯೆಹೋವ ದೇವರು ಯಾಕೋಬನಲ್ಲಿ ಆಪತ್ತನ್ನು ಕಾಣಲಿಲ್ಲ. ಇಸ್ರಾಯೇಲಿನಲ್ಲಿ ವಿಪತ್ತನ್ನು ನೋಡಲಿಲ್ಲ. ಅವರ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಅವರ ಸಂಗಡ ಇದ್ದಾರೆ. ಅರಸನ ಜಯಧ್ವನಿಯು ಅವರಲ್ಲಿ ಉಂಟು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ದೇವರು ಅವರನ್ನು ಈಜಿಪ್ಟಿನೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ್ದಾರೆ. ಅವರಿಗೆ ಕಾಡುಕೋಣದಂಥ ಬಲವುಂಟು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ನಿಶ್ಚಯವಾಗಿ ಯಾಕೋಬನಲ್ಲಿ ಕಣಿಕೇಳುವದು ಇಲ್ಲ. ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಶಕುನನೋಡುವದು ಇಲ್ಲ. ‘ನೋಡಿರಿ, ದೇವರು ಎಂತಹ ಮಹತ್ಕಾರ್ಯವನ್ನು ಮಾಡಿದ್ದಾರೆ,’ ಎಂದು ಯಾಕೋಬನ ವಿಷಯವಾಗಿಯೂ, ಇಸ್ರಾಯೇಲಿನ ವಿಷಯವಾಗಿಯೂ ಹೇಳುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ಇಗೋ, ಜನಾಂಗವು ದೊಡ್ಡ ಸಿಂಹದ ಹಾಗೆ ಏಳುವುದು. ಸಿಂಹದ ಮರಿಯ ಹಾಗೆ ಎದ್ದೇಳುವುದು. ಅದು ಬೇಟೆಯನ್ನು ತಿಂದು, ಹತರಾದವರ ರಕ್ತವನ್ನು ಕುಡಿಯುವವರೆಗೆ ಮಲಗದು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ಆಗ ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ಅವರನ್ನು ಶಪಿಸಲೂ ಬೇಡ, ಆಶೀರ್ವದಿಸಲೂ ಬೇಡ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ಆದರೆ ಬಿಳಾಮನು ಉತ್ತರವಾಗಿ, “ಬಾಲಾಕನಿಗೆ ಯೆಹೋವ ದೇವರು ಹೇಳುವುದನ್ನೆಲ್ಲಾ ನಾನು ಮಾಡುವೆನೆಂದು ನಿನಗೆ ಹೇಳಲಿಲ್ಲವೋ?” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ಆಗ ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ದಯಮಾಡಿ ಬಾ, ನಾನು ನಿನ್ನನ್ನು ಬೇರೆ ಒಂದು ಸ್ಥಳಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋಗುವೆನು. ನೀನು ಅಲ್ಲಿಂದ ನನಗೋಸ್ಕರ ಅವರನ್ನು ಶಪಿಸುವುದು ಒಂದು ವೇಳೆ ದೇವರಿಗೆ ಯುಕ್ತವಾಗಿದ್ದೀತು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ಆದಕಾರಣ ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು ಕಾಡಿಗೆದುರಾಗಿರುವ ಪೆಯೋರಿಯ ತುದಿಗೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ನನಗೆ ಇಲ್ಲಿ ಏಳು ಬಲಿಪೀಠಗಳನ್ನು ಕಟ್ಟಿ, ಇಲ್ಲಿ ನನಗೆ ಏಳು ಹೋರಿಗಳನ್ನೂ, ಏಳು ಟಗರುಗಳನ್ನೂ ಸಿದ್ಧಮಾಡು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ಬಿಳಾಮನು ಹೇಳಿದ ಪ್ರಕಾರ ಬಾಲಾಕನು ಮಾಡಿ, ಬಲಿಪೀಠದ ಮೇಲೆ ಒಂದೊಂದು ಹೋರಿಯನ್ನೂ, ಒಂದೊಂದು ಟಗರನ್ನೂ ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ಆದರೆ ಇಸ್ರಾಯೇಲನ್ನು ಆಶೀರ್ವದಿಸುವುದಕ್ಕೆ ಯೆಹೋವ ದೇವರ ದೃಷ್ಟಿಗೆ ಒಳ್ಳೆಯದೆಂದು ಬಿಳಾಮನು ನೋಡಿದಾಗ, ಅವನು ಮುಂಚಿನ ಹಾಗೆ ಶಕುನವನ್ನು ಕಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ಹೋಗದೆ, ತನ್ನ ಮುಖವನ್ನು ಮರುಭೂಮಿಯ ಕಡೆಗೆ ತಿರುಗಿಸಿಕೊಂಡನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ಬಿಳಾಮನು ತನ್ನ ಕಣ್ಣೆತ್ತಿ ಇಸ್ರಾಯೇಲರು ಅವರವರ ಗೋತ್ರಗಳ ಪ್ರಕಾರ ತಮ್ಮ ಡೇರೆಗಳಲ್ಲಿ ವಾಸವಾಗಿರುವುದನ್ನು ನೋಡಿದಾಗ, ದೇವರಾತ್ಮ ಪ್ರೇರಿತನಾಗಿ ");
INSERT INTO kanokcv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ಹೀಗೆ ಪ್ರವಾದಿಸಿದನು: “ಇದು ಬೆಯೋರನ ಮಗ ಬಿಳಾಮನ ಪ್ರವಾದನೆ: ಸ್ಪಷ್ಟ ಕಣ್ಣುಳ್ಳವನು ನುಡಿದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ದೇವರ ಮಾತುಗಳನ್ನು ಕೇಳಿದವನೂ, ಸರ್ವಶಕ್ತರ ದರ್ಶನವನ್ನು ನೋಡಿದವನೂ, ಪರವಶನಾಗಿ ತೆರೆದ ಕಣ್ಣುಳ್ಳವನೂ ಹೇಳಿದ್ದು: ");
INSERT INTO kanokcv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“ಯಾಕೋಬೇ, ನಿನ್ನ ಡೇರೆಗಳೂ; ಇಸ್ರಾಯೇಲರೇ, ನಿಮ್ಮ ಗುಡಾರಗಳೂ ಉತ್ತಮವಾಗಿವೆ! ");
INSERT INTO kanokcv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“ಅವು ಕಣಿವೆಗಳ ಹಾಗೆ ವಿಸ್ತರಿಸಿವೆ. ನದಿತೀರದಲ್ಲಿರುವ ತೋಟಗಳ ಹಾಗೆಯೂ, ಯೆಹೋವ ದೇವರು ನೆಟ್ಟ ಅಗರು ಮರಗಳ ಹಾಗೆಯೂ ನೀರಿನ ಬಳಿಯಲ್ಲಿರುವ ದೇವದಾರುಗಳ ಹಾಗೆಯೂ ಇರುತ್ತವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ಅವರ ತೊಟ್ಟಿಗಳಿಂದ ನೀರು ಹರಿಯುವಂತೆ ಮಾಡುವರು. ಅವರ ಬಿತ್ತನೆಗೆ ಬೇಕಾದಷ್ಟು ನೀರು ಇರುವುದು. “ಅವರ ಅರಸನು ಅಗಾಗ್ ರಾಜನಿಗಿಂತಲೂ ಉನ್ನತವಾಗಿರುವನು. ಅವರ ರಾಜ್ಯವು ಅಭಿವೃದ್ಧಿ ಹೊಂದುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“ದೇವರು ಅವರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ತಂದನು. ಈ ಕಾಡುಕೋಣದಂತೆ ಬಲ ಅವರಿಗೆ ಉಂಟು. ಅವರು ತನ್ನ ವೈರಿಗಳಾಗಿರುವ ಜನಾಂಗಗಳನ್ನು ತಿಂದು, ಅವರ ಎಲುಬುಗಳನ್ನು ಚೂರುಮಾಡಿ, ತಮ್ಮ ಬಾಣಗಳಿಂದ ಗಾಯಮಾಡುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ಅವರು ಸಿಂಹದ ಹಾಗೆಯೂ, ಸಿಂಹಣಿ ಹಾಗೆಯೂ ಬಾಗಿ ಮಲಗುತ್ತಾನೆ. ಅವನನ್ನು ಎಬ್ಬಿಸುವವನು ಯಾರು? “ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸುವವನಿಗೆ ಆಶೀರ್ವಾದ ಉಂಟಾಗಲಿ. ಶಪಿಸುವವನಿಗೆ ಶಾಪ ಉಂಟಾಗಲಿ.” ");
INSERT INTO kanokcv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ಆಗ ಬಾಲಾಕನು ಬಿಳಾಮನ ಮೇಲೆ ಕೋಪಗೊಂಡು, ಚಪ್ಪಾಳೆ ಹೊಡೆದು ಬಿಳಾಮನಿಗೆ, “ನನ್ನ ಶತ್ರುಗಳನ್ನು ಶಪಿಸುವುದಕ್ಕೆ ನಿನ್ನನ್ನು ಕರೆದೆನು. ಆದರೆ ಇಗೋ, ನೀನು ಈ ಮೂರು ಸಾರಿಯೂ ಆಶೀರ್ವದಿಸಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ಈಗ ನಿನ್ನ ಸ್ಥಳಕ್ಕೆ ಓಡಿಹೋಗು. ನಾನು ನಿನ್ನನ್ನು ಬಹು ಗೌರವಿಸಬೇಕೆಂದಿದ್ದೆ. ಆದರೆ ಇಗೋ, ಯೆಹೋವ ದೇವರು ನಿನಗೆ ಘನತೆ ಬಾರದಂತೆ ತಡೆದಿದ್ದಾನೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ನೀನು ನನ್ನ ಬಳಿಗೆ ಕಳುಹಿಸಿದ ದೂತರಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ಬಾಲಾಕನು ನನಗೆ ತನ್ನ ಮನೆ ತುಂಬ ಬೆಳ್ಳಿಬಂಗಾರಗಳನ್ನು ಕೊಟ್ಟರೂ, ನನ್ನ ಹೃದಯದಿಂದ ಒಳ್ಳೆಯದನ್ನಾದರೂ, ಕೆಟ್ಟದ್ದನ್ನಾದರೂ ಮಾಡುವುದಕ್ಕೆ ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯನ್ನು ಮೀರಲಾರೆನು. ಯೆಹೋವ ದೇವರು ಏನು ಹೇಳುತ್ತಾರೋ, ಅದನ್ನೇ ಹೇಳುವೆನೆಂದು ನಾನು ಹೇಳಲಿಲ್ಲವೋ’? ಈಗ, ನನ್ನ ಜನರ ಬಳಿಗೆ ಹೋಗುತ್ತೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ಬಾ, ಈ ಜನರು ನಿನ್ನ ಜನರಿಗೆ ಕಡೇ ದಿವಸಗಳಲ್ಲಿ ಏನು ಮಾಡುವರೋ, ಅದನ್ನು ನಿನಗೆ ತಿಳಿಸುವೆನು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ಆಗ ಅವನು ಪದ್ಯರೂಪವಾಗಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಬೆಯೋರನ ಮಗ ಬಿಳಾಮನು ಹೇಳಿದ್ದು: ಸ್ಪಷ್ಟ ಕಣ್ಣುಳ್ಳ ಮನುಷ್ಯನು ನುಡಿದದ್ದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ದೇವರ ಮಾತುಗಳನ್ನು ಕೇಳಿದವನೂ, ಮಹೋನ್ನತನ ಜ್ಞಾನವನ್ನು ತಿಳಿದವನೂ, ಸರ್ವಶಕ್ತರ ದರ್ಶನವನ್ನು ನೋಡಿದವನೂ, ಪರವಶನಾಗಿದ್ದು ತೆರೆದ ಕಣ್ಣುಳ್ಳವನೂ ಹೇಳಿದ್ದು: ");
INSERT INTO kanokcv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“ನಾನು ಅವನನ್ನು ನೋಡುವೆನು, ಈಗಲ್ಲ. ಅವನನ್ನು ದೃಷ್ಟಿಸುವೆನು, ಸಮೀಪದಲ್ಲಿ ಅಲ್ಲ. ಯಾಕೋಬನಿಂದ ನಕ್ಷತ್ರ ಉದಯಿಸುವುದು. ಇಸ್ರಾಯೇಲನಿಂದ ರಾಜದಂಡ ಏಳುವುದು. ಅದು ಮೋವಾಬಿನ ಮೂಲೆಗಳನ್ನು ಹೊಡೆದು, ಸೇಥನ ಎಲ್ಲಾ ಮಕ್ಕಳನ್ನು ಸಂಹರಿಸುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ಎದೋಮು ಸ್ವಾಧೀನವಾಗುವುದು; ಸೇಯೀರನವರು ತನ್ನ ಶತ್ರುಗಳಿಗೆ ಸ್ವಾಧೀನವಾಗುವುದು; ಇಸ್ರಾಯೇಲು ಪರಾಕ್ರಮ ಕಾರ್ಯಮಾಡುವುದು, ");
INSERT INTO kanokcv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ಯಾಕೋಬನೊಳಗಿಂದ ಒಬ್ಬನು ಬಂದು ಆಳುವನು, ಅವನು ಪಟ್ಟಣದಲ್ಲಿ ಉಳಿದದ್ದನ್ನು ನಾಶಮಾಡುವನು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ಅನಂತರ ಬಿಳಾಮನು ಅಮಾಲೇಕ್ಯರನ್ನು ನೋಡಿ ಪದ್ಯರೂಪವಾಗಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಜನಾಂಗಗಳಲ್ಲಿ ಮೊದಲನೆಯವನೇ ಅಮಾಲೇಕ್ಯನು, ಆದರೆ ಅವನು ಕೊನೆಗೆ ನಾಶವಾಗುವನು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ಬಳಿಕ ಕೇನ್ಯರನ್ನು ಅವನು ನೋಡಿ ಪದ್ಯರೂಪವಾಗಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ನಿನ್ನ ನಿವಾಸವು ಬಲವಾಗಿದೆ. ನಿನ್ನ ಗೂಡನ್ನು ಬಂಡೆಯಲ್ಲಿ ಹಾಕಿದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ಆದರೂ ಅಸ್ಸೀರಿಯರು ನಿನ್ನನ್ನು ಸೆರೆಹಿಡಿಯುವಷ್ಟರಲ್ಲೇ ನೀವು ಕೇನ್ಯರೂ ಹಾಳಾಗುವರು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ಇದಲ್ಲದೆ ಅವನು ಪದ್ಯರೂಪವಾಗಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಅಯ್ಯೋ! ದೇವರು ಇದನ್ನು ಮಾಡುವಾಗ ಯಾರು ಬದುಕುವರು? ");
INSERT INTO kanokcv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ಕಿತ್ತೀಮೆಂಬ ತೀರದಿಂದ ಹಡಗುಗಳು ಬಂದು, ಅಸ್ಸೀರಿಯರನ್ನೂ, ಏಬೆರ್ ಜನರನ್ನೂ ಸೋಲಿಸುವುವು. ಅವನು ಸಹ ಸದಾಕಾಲಕ್ಕೂ ನಾಶವಾಗುವನು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ಆಗ ಬಿಳಾಮನು ಎದ್ದು ತನ್ನ ಸ್ಥಳಕ್ಕೆ ತಿರುಗಿಹೋದನು. ಬಾಲಾಕನು ಸಹ ತನ್ನ ಮಾರ್ಗವಾಗಿ ಹೋದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ಆಗ ಇಸ್ರಾಯೇಲರು ಶಿಟ್ಟೀಮಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾಗ, ಅವರು ಮೋವಾಬಿನ ಪುತ್ರಿಯರ ಸಂಗಡ ಜಾರತ್ವ ಮಾಡಲಾರಂಭಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ಆ ಮಹಿಳೆಯರು ಇಸ್ರಾಯೇಲರನ್ನು ತಮ್ಮ ದೇವರುಗಳ ಬಲಿಗಳಿಗೆ ಕರೆದರು. ಇವರು ತಿಂದು ಅವರ ದೇವರುಗಳಿಗೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ಹೀಗೆ ಇಸ್ರಾಯೇಲರು ಬಾಳ್ ಪೆಯೋರಿನೊಂದಿಗೆ ತಾವೇ ಕೂಡಿ ಪೂಜಿಸಿದ್ದರಿಂದ ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲಿನ ಮೇಲೆ ಕೋಪಗೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಯೆಹೋವ ದೇವರ ಕೋಪಾಗ್ನಿಯು ಇಸ್ರಾಯೇಲಿನಿಂದ ತಿರುಗಿಕೊಳ್ಳುವ ಹಾಗೆ ನೀನು ಜನರ ಮುಖ್ಯಸ್ಥರೆಲ್ಲರನ್ನು ತೆಗೆದುಕೊಂಡು, ಅವರನ್ನು ಹಗಲು ಹೊತ್ತಿನಲ್ಲಿ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಕೊಂದುಹಾಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ಆದ್ದರಿಂದ ಮೋಶೆ ಇಸ್ರಾಯೇಲಿನ ನ್ಯಾಯಾಧಿಪತಿಗಳಿಗೆ, “ನಿಮ್ಮಲ್ಲಿ ಒಬ್ಬೊಬ್ಬನೂ ಬಾಳ್ ಪೆಯೋರಿನೊಂದಿಗೆ ಕೂಡಿ ಪೂಜಿಸಿರುವ ನಿನ್ನ ಜನರನ್ನು ಕೊಲ್ಲಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ಆಗ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಒಬ್ಬನು ಮೋಶೆಗೆ ಹಾಗೂ ದೇವದರ್ಶನ ಗುಡಾರದ ಮುಂದೆ ಅಳುತ್ತಿರುವ ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಸಮೂಹಕ್ಕೂ ಕಾಣುವ ಹಾಗೆ ಒಬ್ಬ ಮಿದ್ಯಾನ್ ಮಹಿಳೆಯನ್ನು ಕರೆತಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ಕೂಡಲೆ ಮಾಹಾಯಾಜಕ ಆರೋನನ ಮಗನಾಗಿದ್ದ ಎಲಿಯಾಜರನ ಮಗ ಫೀನೆಹಾಸನು ಅದನ್ನು ನೋಡಿ, ಜನರ ಮಧ್ಯದಿಂದ ಎದ್ದು, ತನ್ನ ಕೈಯಲ್ಲಿ ಈಟಿಯನ್ನು ಹಿಡಿದುಕೊಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ಇಸ್ರಾಯೇಲಿನವನಾದ ಆ ಮನುಷ್ಯನ ಹಿಂದೆ ಡೇರೆಯೊಳಗೆ ಪ್ರವೇಶಿಸಿ, ಇಸ್ರಾಯೇಲಿನವನನ್ನೂ ಆ ಮಹಿಳೆಯನ್ನೂ ಒಂದೇ ಬಾರಿಗೆ ಇಬ್ಬರ ಹೊಟ್ಟೆಯನ್ನು ತಿವಿದನು. ಹೀಗೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಉಂಟಾಗಿದ್ದ ವ್ಯಾಧಿಯು ನಿಂತುಹೋಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ಆದರೂ, ವ್ಯಾಧಿಯಿಂದ ಸತ್ತವರು 24,000 ಮಂದಿಯಾಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ಯಾಜಕನಾದ ಆರೋನನ ಮೊಮ್ಮಗನೂ, ಎಲಿಯಾಜರನ ಮಗ ಫೀನೆಹಾಸನು ಇಸ್ರಾಯೇಲರಲ್ಲಿ ನನಗೋಸ್ಕರ ಆಸಕ್ತನಾಗಿದ್ದು, ನಾನು ನನ್ನ ರೋಷದಿಂದ ಅವರನ್ನು ನಾಶಮಾಡದ ಹಾಗೆ, ನನ್ನ ಕೋಪವನ್ನು ಅವರ ಮೇಲಿನಿಂದ ತಿರುಗಿಸಿಬಿಟ್ಟಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ಆದಕಾರಣ, ನಾನು ಅವನೊಂದಿಗೆ ನನ್ನ ಸಮಾಧಾನದ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡುತ್ತೇನೆ ಎಂದು ಹೇಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ಅವನು ತನ್ನ ದೇವರ ಗೌರವವನ್ನು ಕಾಪಾಡಲು ಆಸಕ್ತನಾಗಿದ್ದು, ಇಸ್ರಾಯೇಲರಿಗೋಸ್ಕರ ಪಾಪ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಿದ್ದರಿಂದ, ಅವನಿಗೂ ಅವನ ಹಿಂದೆ ಬರುವ ಅವನ ಸಂತತಿಗೂ ನಿತ್ಯ ಯಾಜಕತ್ವದ ಒಡಂಬಡಿಕೆ ಮಾಡಿದ್ದೇನೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ಮಿದ್ಯಾನ್ ಸ್ತ್ರೀಯ ಸಂಗಡ ಹತನಾದ ಆ ಇಸ್ರಾಯೇಲಿನವನ ಹೆಸರು ಜಿಮ್ರಿ, ಅವನು ಸಿಮೆಯೋನ್ ಕುಲದವರಲ್ಲಿ ಗೋತ್ರದ ಮುಖ್ಯಸ್ಥನಾಗಿದ್ದ ಸಾಲೂ ಎಂಬುವನ ಮಗನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ಹತಳಾದ ಆ ಮಿದ್ಯಾನ್ ಸ್ತ್ರೀಯ ಹೆಸರು ಕೊಜ್ಬೀ, ಅವಳು ಮಿದ್ಯಾನ್ಯರ ಪ್ರಜೆಯ ಮುಖ್ಯಸ್ಥನೂ ಮನೆಗೆ ಯಜಮಾನನೂ ಆಗಿರುವ ಚೂರ್ ಎಂಬವನ ಮಗಳಾಗಿದ್ದಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ಮಿದ್ಯಾನ್ಯರನ್ನು ವೈರಿ ಎಂದು ತಿಳಿದು ಹೊಡೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ಅವರು ಪೆಯೋರಿನ ವಿಷಯದಲ್ಲಿಯೂ, ಪೆಯೋರಿಗೋಸ್ಕರ ವ್ಯಾಧಿಯ ದಿವಸದಲ್ಲಿ ಹತಳಾದ ತಮ್ಮ ಸಹೋದರಿಯಾಗಿಯೂ, ಮಿದ್ಯಾನ್ಯರ ಪ್ರಧಾನನ ಮಗಳಾಗಿಯೂ, ಇದ್ದ ಕೊಜ್ಬೀಯ ವಿಷಯದಲ್ಲಿಯೂ ನಿಮಗೆ ಮಾಡಿದ ಮೋಸಗಳಿಂದ ನಿಮಗೆ ಉಪದ್ರವ ಕೊಡುತ್ತಾರೆ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ವ್ಯಾಧಿಯ ತರುವಾಯ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೂ, ಆರೋನನ ಮಗನೂ, ಯಾಜಕನೂ ಆಗಿರುವ ಎಲಿಯಾಜರನ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಸಮೂಹದವರಲ್ಲಿ ಇಪ್ಪತ್ತು ವರ್ಷವೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳವರನ್ನು ಯುದ್ಧಕ್ಕೆ ಹೋಗುವುದಕ್ಕೆ ಶಕ್ತರಾದವರೆಲ್ಲರನ್ನು ಜನಗಣತಿ ಮಾಡಿ ಅವರ ಗೋತ್ರಗಳ ಪ್ರಕಾರ ತೆಗೆದುಕೊಳ್ಳಿರಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ಆಗ ಮೋಶೆಯೂ ಯಾಜಕನಾದ ಎಲಿಯಾಜರನೂ ಮೋವಾಬಿನ ಬಯಲುಗಳಲ್ಲಿ ಯೆರಿಕೋವಿಗೆದುರಾಗಿ ಯೊರ್ದನಿನ ಹತ್ತಿರ ಅವರ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ, ಇಪ್ಪತ್ತು ವರ್ಷದವರನ್ನೂ ಅದಕ್ಕೆ ಅಧಿಕವಾದ ಪ್ರಾಯವುಳ್ಳವರನ್ನೂ ಎಣಿಸಬೇಕು.” ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಹೊರಟು ಬಂದಿದ್ದ ಇಸ್ರಾಯೇಲರು ಇವರು: ");
INSERT INTO kanokcv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ಇಸ್ರಾಯೇಲನ ಚೊಚ್ಚಲ ಮಗ ರೂಬೇನನೂ, ರೂಬೇನನ ಮಕ್ಕಳೂ; ಹನೋಕನೂ, ಇವನಿಂದ ಹನೋಕ್ಯರ ಕುಟುಂಬ; ಪಲ್ಲೂವಿನಿಂದ ಪಲ್ಲೂವಿಯರ ಕುಟುಂಬ; ");
INSERT INTO kanokcv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ಹೆಚ್ರೋನನಿಂದ ಹೆಚ್ರೋನ್ಯರ ಕುಟುಂಬ; ಕರ್ಮೀಯಿಂದ ಕರ್ಮೀಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ಇವೇ ರೂಬೇನ್ಯರ ಕುಟುಂಬಗಳು. ಇವರಲ್ಲಿ ಎಣಿಕೆಯಾದವರ ಸಂಖ್ಯೆ 43,730 ಪುರುಷರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ಪಲ್ಲೂವಿನ ಪುತ್ರ ಎಲೀಯಾಬನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ಎಲೀಯಾಬನ ಪುತ್ರರು ನೆಮೂಯೇಲ್, ದಾತಾನ್, ಅಬೀರಾಮ್. ಈ ದಾತಾನನೂ, ಅಬೀರಾಮನೂ ಜನರಲ್ಲಿ ಪ್ರಸಿದ್ಧರಾಗಿದ್ದು; ಕೋರಹನ ಗುಂಪಿನಲ್ಲಿದ್ದು; ಯೆಹೋವ ದೇವರಿಗೂ ಮೋಶೆ ಆರೋನರಿಗೂ ವಿರೋಧವಾಗಿ ಹೋರಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ಭೂಮಿಯು ತನ್ನ ಬಾಯಿಯನ್ನು ತೆರೆದು, ಅವರನ್ನು ಕೋರಹನೊಂದಿಗೆ ನುಂಗಿಬಿಟ್ಟಿತು. ಹಾಗೆಯೇ ಆ ಗುಂಪಿನವರಲ್ಲಿ ಬೆಂಕಿಯು ಇನ್ನೂರ ಐವತ್ತು ಮಂದಿಯನ್ನು ದಹಿಸಿಬಿಟ್ಟಿತು. ಹೀಗೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಎಚ್ಚರಿಕೆ ಉಂಟಾಗುವಂತೆ ಮಾಡಿತು. ಅವರು ದೃಷ್ಟಾಂತವಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ಆದರೂ ಕೋರಹನ ಮಕ್ಕಳು ಸಾಯಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಸಿಮೆಯೋನನ ಪುತ್ರರು. ನೆಮೂಯೇಲನಿಂದ ನೆಮೂಯೇಲ್ಯರ ಕುಟುಂಬ; ಯಾಮೀನನಿಂದ ಯಾಮೀನ್ಯರ ಕುಟುಂಬ; ಯಾಕೀನನಿಂದ ಯಾಕೀನ್ಯರ ಕುಟುಂಬ; ");
INSERT INTO kanokcv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ಜೆರಹನ ವಂಶಸ್ಥರಾದ ಜೆರಹಿಯರು, ಸೌಲನಿಂದ ಸೌಲ್ಯರ ಕುಟುಂಬ; ");
INSERT INTO kanokcv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ಸಿಮೆಯೋನ್ ಕುಲದವರಾದ ಇವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 22,200 ಪುರುಷರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಗಾದನ ಮಕ್ಕಳು: ಚೆಫೋನನ ವಂಶಸ್ಥರಾದ ಚೆಫೋನ್ಯರು, ಹಗ್ಗೀಯಿಂದ ಹಗ್ಗೀಯರ ಕುಟುಂಬ ಶೂನೀಯಿಂದ ಶೂನೀಯರ ಕುಟುಂಬ; ");
INSERT INTO kanokcv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ಒಜ್ನೀಯ ವಂಶಸ್ಥರಾದ ಒಜ್ನೀಯರು, ಏರೀಯ ವಂಶಸ್ಥರಾದ ಏರೀಯರು, ");
INSERT INTO kanokcv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ಅರೋದನಿಂದ ಅರೋದ್ಯರ ಕುಟುಂಬ; ಅರೇಲೀಯಿಂದ ಅರೇಲೀಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ಗಾದನ ಮಕ್ಕಳ ಕುಟುಂಬಗಳು ಇವೇ. ಇವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 40,500 ಪುರುಷರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ಯೆಹೂದನ ಪುತ್ರರು: ಏರ್, ಓನಾನನೂ. ಆದರೆ ಏರನೂ ಓನಾನನೂ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಸತ್ತರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಯೆಹೂದನ ಪುತ್ರರು. ಶೇಲಹನಿಂದ ಶೇಲಾನ್ಯರ ಕುಟುಂಬ; ಪೆರೆಚನಿಂದ ಪೆರೆಚ್ಯರ ಕುಟುಂಬ; ಜೆರಹನಿಂದ ಜೆರಹಿಯರ ಕುಟುಂಬ; ");
INSERT INTO kanokcv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ಪೆರೆಚನ ಪುತ್ರರು, ಹೆಚ್ರೋನನಿಂದ ಹೆಚ್ರೋನ್ಯರ ಕುಟುಂಬ. ಹಾಮೂಲನಿಂದ ಹಾಮೂಲ್ಯರು ಕುಟುಂಬ ");
INSERT INTO kanokcv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ಯೆಹೂದನ ಕುಟುಂಬಗಳಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 76,500 ಪುರುಷರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಇಸ್ಸಾಕಾರನ ಪುತ್ರರು. ತೋಲನ ವಂಶಸ್ಥರಾದ ತೋಲಾಯರು, ಪುವ್ವನಿಂದ ಪೂನ್ಯರ ಕುಟುಂಬ; ");
INSERT INTO kanokcv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ಯಾಶೂಬನಿಂದ ಯಾಶೂಬ್ಯರ ಕುಟುಂಬ; ಶಿಮ್ರೋನನಿಂದ ಶಿಮ್ರೋನ್ಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ಇಸ್ಸಾಕಾರನ ಕುಟುಂಬಗಳು ಇವೇ. ಇವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 64,300 ಪುರುಷರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ಜೆಬುಲೂನನ ಪುತ್ರರು: ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಸೆರೆದನಿಂದ ಸೆರೆದ್ಯರ ಕುಟುಂಬ; ಏಲೋನನ ವಂಶಸ್ಥರಾದ ಏಲೋನ್ಯರು, ಯಹಲೇಲನಿಂದ ಯಹಲೇಲ್ಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ಜೆಬುಲೂನ್ ಕುಟುಂಬಗಳು ಇವೇ. ಇವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 60,500 ಪುರುಷರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಯೋಸೇಫನ ಪುತ್ರರು: ಮನಸ್ಸೆ, ಎಫ್ರಾಯೀಮ್. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ಮನಸ್ಸೆಯ ಪುತ್ರರು: ಮಾಕೀರನಿಂದ ಮಾಕೀರ್ಯರ ಕುಟುಂಬ; ಮಾಕೀರನು ಗಿಲ್ಯಾದನನ್ನು ಪಡೆದನು. ಗಿಲ್ಯಾದನಿಂದ ಗಿಲ್ಯಾದ್ಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ಗಿಲ್ಯಾದನ ಪುತ್ರರು ಇವರೇ. ಈಯೆಜೆರನಿಂದ ಈಯೆಜೆರ್ಯರ ಕುಟುಂಬ; ಹೇಲೆಕನಿಂದ ಹೇಲೆಕ್ಯರ ಕುಟುಂಬ; ");
INSERT INTO kanokcv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ಅಸ್ರೀಯೇಲನಿಂದ ಅಸ್ರೀಯೇಲ್ಯರ ಕುಟುಂಬ, ಶೆಕೆಮನಿಂದ ಶೆಕೆಮ್ಯರ ಕುಟುಂಬ; ");
INSERT INTO kanokcv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ಶೆಮೀದಾಯನಿಂದ ಶೆಮೀದಾಯರ ಕುಟುಂಬ; ಹೇಫೆರನಿಂದ ಹೇಫೆರ್ಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ಹೇಫೆರನ ಮಗ ಚಲ್ಪಹಾದನಿಗೆ ಪುತ್ರರಿರಲಿಲ್ಲ. ಪುತ್ರಿಯರು ಇದ್ದರು. ಚಲ್ಪಹಾದನ ಪುತ್ರಿಯರ ಹೆಸರುಗಳು ಮಹ್ಲಾ, ನೋವಾ, ಹೊಗ್ಲಾ, ಮಿಲ್ಕಾ, ತಿರ್ಚಾ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ಮನಸ್ಸೆಯ ಕುಟುಂಬಗಳು ಇವೇ. ಇವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 52,700 ಪುರುಷರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಎಫ್ರಾಯೀಮನ ಪುತ್ರರು: ಶೂತೆಲಹನಿಂದ ಶೂತೆಲಹ್ಯರ ಕುಟುಂಬ; ಬೆಕೆರನಿಂದ ಬೆಕೆರ್ಯರ ಕುಟುಂಬ; ತಹನನಿಂದ ತಹನಿಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ಶೂತೆಲಹನ ಪುತ್ರರು: ಏರಾನನಿಂದ ಏರಾನ್ಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ಎಫ್ರಾಯೀಮನ ಪುತ್ರರ ಎಫ್ರಾಯೀಮನ ಪುತ್ರರುಗಳು ಇವೇ. ಅವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 32,500. ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಯೋಸೇಫನ ಮಕ್ಕಳು ಇವರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಬೆನ್ಯಾಮೀನನ ಪುತ್ರರು: ಬೆಳಗನಿಂದ ಬೆಲಗ್ಯರ ಕುಟುಂಬ; ಅಷ್ಬೇಲನಿಂದ ಅಷ್ಬೇಲ್ಯರ ಕುಟುಂಬ; ಅಹೀರಾಮನಿಂದ ಅಹೀರಾಮ್ಯರ ಕುಟುಂಬ; ");
INSERT INTO kanokcv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ಶೂಫಾಮನಿಂದ ಶೂಫಾಮ್ಯರ ಕುಟುಂಬ; ಹೂಫಾಮನಿಂದ ಹೂಫಾಮ್ಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ಬೆಳಗನ ಪುತ್ರರು ಆರ್ದನೂ ನಾಮಾನನೂ. ಅರ್ದನಿಂದ ಅರ್ದ್ಯರ ಕುಟುಂಬ; ನಾಮಾನನಿಂದ ನಾಮಾನ್ಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಬೆನ್ಯಾಮೀನನ ಪುತ್ರರು ಇವರೇ. ಇವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 45,600. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ದಾನನ ಪುತ್ರರು: ಶೂಹಾಮನಿಂದ ಶೂಹಾಮ್ಯರ ಕುಟುಂಬ; ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ದಾನನ ಕುಟುಂಬಗಳು ಇವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ಶೂಹಾಮ್ಯರ ಸಮಸ್ತ ಕುಟುಂಬಗಳಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 64,400. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಆಶೇರನ ಮಕ್ಕಳು: ಇಮ್ನಾಹನನಿಂದ ಇಮ್ನಾಹರ ಕುಟುಂಬ; ಇಷ್ವೀಯಿಂದ ಇಷ್ವೀಯರ ಕುಟುಂಬ; ಬೆರೀಯನಿಂದ ಬೆರೀಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ಬೆರೀಯನ ಕುಮಾರರು: ಹೆಬೆರನಿಂದ ಹೆಬೆರ್ಯರ ಕುಟುಂಬ; ಮಲ್ಕೀಯೇಲನಿಂದ ಮಲ್ಕೀಯೇಲ್ಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ಆಶೇರನ ಮಗಳ ಹೆಸರು ಸೆರಹ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ಲೆಕ್ಕಾನುಸಾರವಾದ ಆಶೇರನ ಪುತ್ರರ ಕುಟುಂಬಗಳು ಇವೇ. ಇವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 53,400. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ನಫ್ತಾಲಿಯ ಪುತ್ರರು: ಯಹಚೇಲನಿಂದ ಯಹಚೇಲ್ಯರ ಕುಟುಂಬ; ಗೂನೀಯ ವಂಶಸ್ಥರಾದ ಗೂನೀಯರು, ");
INSERT INTO kanokcv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ಯೇಚೆರನಿಂದ ಯೇಚೆರ್ಯರ ಕುಟುಂಬ; ಶಿಲ್ಲೇಮನಿಂದ ಶಿಲ್ಲೇಮ್ಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ನಫ್ತಾಲಿಯ ಕುಟುಂಬಗಳು ಇವೇ. ಇವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರು 45,400. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರ ಸಂಖ್ಯೆ 6,01,730. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ಇವರಿಗೆ ನಾಡನ್ನು ಹೆಸರುಗಳ ಲೆಕ್ಕದ ಪ್ರಕಾರ ಸೊತ್ತಾಗಿ ಹಂಚಿಕೊಡು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ಹೆಚ್ಚು ಮಂದಿಯುಳ್ಳ ಗೋತ್ರಕ್ಕೆ ಹೆಚ್ಚಾಗಿಯೂ ಕಡಿಮೆ ಮಂದಿಯುಳ್ಳ ಗೋತ್ರಕ್ಕೆ ಕಡಿಮೆಯಾಗಿಯೂ ಕೊಡು. ಹೀಗೆ ಒಬ್ಬೊಬ್ಬನಿಗೆ ತನ್ನ ಲೆಕ್ಕದ ಪ್ರಕಾರ ಅವನವನ ಸೊತ್ತನ್ನು ಹಂಚಿಕೊಡು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ಇದಲ್ಲದೆ ಚೀಟು ಹಾಕುವುದರಿಂದ ದೇಶವನ್ನು ಪಾಲುಮಾಡಬೇಕು. ತಮ್ಮ ಗೋತ್ರಗಳ ಕುಟುಂಬಗಳ ಹೆಸರುಗಳ ಪ್ರಕಾರ ಅವರು ತಮ್ಮ ಪಾಲನ್ನು ಪಡೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ಹೆಚ್ಚಾದ ಜನಕ್ಕೂ ಕಡಿಮೆಯಾದ ಜನಕ್ಕೂ ಅವರ ಸ್ವಾಸ್ತ್ಯವು ಚೀಟಿಯ ಪ್ರಕಾರ ಪಾಲಾಗಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ಲೇವಿಯರಲ್ಲಿ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಎಣಿಕೆಯಾದವರು ಇವರೇ. ಗೇರ್ಷೋನನ ವಂಶದವರಾದ ಗೇರ್ಷೋನ್ಯರು, ಕೊಹಾತನಿಂದ ಕೊಹಾತ್ಯರ ಕುಟುಂಬ; ಮೆರಾರೀಯಿಂದ ಮೆರಾರೀಯರ ಕುಟುಂಬ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ಲೇವಿಯರ ಕುಟುಂಬಗಳು ಇವೇ. ಲಿಬ್ನೀಯರ ಕುಟುಂಬ; ಹೆಬ್ರೋನಿಯರ ಕುಟುಂಬ; ಮಹ್ಲೀಯರ ಕುಟುಂಬ; ಮೂಷೀಯರ ಕುಟುಂಬ; ಕೋರಹೀಯರ ಕುಟುಂಬ. ಕೊಹಾತನು ಅಮ್ರಾಮನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ಅಮ್ರಾಮನ ಹೆಂಡತಿಯ ಹೆಸರು ಯೋಕೆಬೆದಳು. ಆಕೆಯು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಲೇವಿಯಿಂದ ಹುಟ್ಟಿದ ಮಗಳು. ಆಕೆಯು ಅಮ್ರಾಮನಿಗೆ ಆರೋನನನ್ನೂ ಮೋಶೆಯನ್ನೂ ಅವರ ಸಹೋದರಿಯಾದ ಮಿರ್ಯಾಮಳನ್ನೂ ಹೆತ್ತಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ಆರೋನನಿಗೆ ನಾದಾಬನೂ ಅಬೀಹೂ ಎಲಿಯಾಜರನೂ ಈತಾಮಾರನೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ಆದರೆ ನಾದಾಬನೂ ಅಬೀಹೂ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಆಜ್ಞಾಪಿಸದೇ ಇದ್ದ ಬೇರೆ ಅಗ್ನಿಯನ್ನು ಅರ್ಪಿಸಿದ್ದರಿಂದ ಸತ್ತರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿತರಾದವರು ಒಂದು ತಿಂಗಳೂ ಹಾಗೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಪ್ರಾಯವುಳ್ಳ ಗಂಡಸರ ಸಂಖ್ಯೆ 23,000 ಆಗಿತ್ತು. ಇವರಿಗೆ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಸೊತ್ತು ದೊರೆಯದ ಕಾರಣ ಅವರು ಇಸ್ರಾಯೇಲರೊಳಗೆ ಲೆಕ್ಕಿತರಾಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ಇವರನ್ನು ಮೋಶೆಯೂ ಯಾಜಕನಾದ ಎಲಿಯಾಜರನೂ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಯೆರಿಕೋ ಪಟ್ಟಣಕ್ಕೆದುರಾಗಿ ಯೊರ್ದನ್ ನದಿಯ ಮೇಲಿರುವ ಮೋವಾಬಿನ ಬೈಲುಗಳಲ್ಲಿ ಎಣಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ಆದರೆ ಮೋಶೆಯೂ ಯಾಜಕನಾದ ಆರೋನನೂ ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಸ್ರಾಯೇಲರನ್ನು ಎಣಿಸಿದಾಗ, ಎಣಿಕೆಯಾದವರಲ್ಲಿ ಒಬ್ಬನಾದರೂ ಇವರ ಲೆಕ್ಕದಲ್ಲಿ ಸೇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ಏಕೆಂದರೆ ಅವರು ಮರುಭೂಮಿಯಲ್ಲಿ ನಿಶ್ಚಯವಾಗಿ ಸಾಯಲಿ ಎಂದು ಯೆಹೋವ ದೇವರು ಅವರಿಗೆ ಹೇಳಿದ್ದರು. ಈ ಪ್ರಕಾರ ಯೆಫುನ್ನೆಯ ಮಗ ಕಾಲೇಬನೂ ನೂನನ ಮಗ ಯೆಹೋಶುವನೂ ಇವರನ್ನು ಬಿಟ್ಟು ಒಬ್ಬನೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ಯೋಸೇಫನ ಮಗನಾದ ಮನಸ್ಸೆಯ ಕುಟುಂಬಗಳಿಗೆ ಸೇರಿದ ಚಲ್ಪಹಾದ ಎಂಬುವನು. ಇವನು ಮಾಕೀರನ ಮರಿಮಗ, ಗಿಲ್ಯಾದನ ಮೊಮ್ಮಗ ಹಾಗು ಹೇಫೆರನ ಮಗ. ಈ ಚಲ್ಪಹಾದನಿಗೆ ಮಹ್ಲಾ, ನೋವಾ, ಹೊಗ್ಲಾ, ಮಿಲ್ಕಾ ಮತ್ತು ತಿರ್ಚಾ ಎಂಬ ಪುತ್ರಿಯರಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ಇವರು ಸಭೆಯ ಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರದಲ್ಲಿದ್ದ ಮೋಶೆ, ಯಾಜಕನಾದ ಎಲಿಯಾಜರ್, ಪ್ರಧಾನರು ಮತ್ತು ಸಮಸ್ತ ಸಭೆಯವರ ಮುಂದೆ ಬಂದು ನಿಂತು ಅವರಿಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“ನಮ್ಮ ತಂದೆಯು ಮರುಭೂಮಿಯಲ್ಲಿ ಸತ್ತನು. ಅವನು ಕೋರಹನ ಗುಂಪಿನಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ವಿರೋಧವಾಗಿ ಕೂಡಿಕೊಂಡವರ ಗುಂಪಿನೊಳಗಿರದೆ, ತನ್ನ ಪಾಪದಲ್ಲಿಯೇ ಸತ್ತನು. ಅವನಿಗೆ ಪುತ್ರರು ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ಹಾಗಾದರೆ ನಮ್ಮ ತಂದೆಗೆ ಮಗನಿಲ್ಲದಿರುವುದರಿಂದ, ಅವನ ಹೆಸರನ್ನು ತನ್ನ ಕುಟುಂಬದಿಂದ ಏಕೆ ತೆಗೆಯಬೇಕು? ನೀನು ನಮ್ಮ ತಂದೆಯ ಸಹೋದರರ ಮಧ್ಯದಲ್ಲಿ ಒಂದು ಸೊತ್ತನ್ನು ನಮಗೆ ಕೊಡು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ಮೋಶೆಯು ಅವರ ವ್ಯಾಜ್ಯವನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ತಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","ಚಲ್ಪಹಾದನ ಪುತ್ರಿಯರು ಹೇಳಿದ್ದು ಸರಿ, ನೀನು ಅವರಿಗೆ ಅವರ ತಂದೆಯ ಸಹೋದರರ ಮಧ್ಯದಲ್ಲಿ ಒಂದು ಸೊತ್ತನ್ನು ನಿಶ್ಚಯವಾಗಿ ಕೊಡಬೇಕು, ಅವರ ತಂದೆಯ ಸೊತ್ತನ್ನು ಅವರಿಗೆ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾಡನಾಡಿ ನೀನು ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ: ‘ಒಬ್ಬನು ಮಗನಿಲ್ಲದೆ ಸತ್ತರೆ, ನೀವು ಅವನ ಸೊತ್ತನ್ನು ಅವನ ಮಗಳಿಗೆ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ಅವನಿಗೆ ಸಹೋದರರು ಇಲ್ಲದಿದ್ದರೆ, ನೀವು ಅವನ ಸೊತ್ತನ್ನು ಅವನ ತಂದೆಯ ಸಹೋದರರಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ಆದರೆ ಅವನ ತಂದೆಗೆ ಸಹೋದರರು ಇಲ್ಲದಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ಅವನ ಕುಟುಂಬದೊಳಗೆ ಅವನಿಗೆ ಹೆಚ್ಚಾಗಿ ಸಮೀಪವಾದ ಬಂಧುವಿಗೆ ಅವನ ಸೊತ್ತನ್ನು ಕೊಡಬೇಕು. ಅವನೇ ಅದನ್ನು ಪಡೆದುಕೊಳ್ಳಲಿ. ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ, ಇದು ಇಸ್ರಾಯೇಲರಿಗೆ ನ್ಯಾಯದ ಕಟ್ಟಳೆಯಾಗಿರಬೇಕು,’ ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಈ ಅಬಾರೀಮ್ ಪರ್ವತದ ಮೇಲೆ ಏರಿ, ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ ಕೊಟ್ಟ ದೇಶವನ್ನು ನೋಡು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ಅದನ್ನು ನೋಡಿದ ಮೇಲೆ, ನಿನ್ನ ಸಹೋದರನಾದ ಆರೋನನ ಪ್ರಕಾರ ನೀನೂ ಸಹ ನಿನ್ನ ಜನರ ಬಳಿಗೆ ಸೇರುತ್ತೀ. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ಏಕೆಂದರೆ ನೀವು ಚಿನ್ ಎಂಬ ಮರುಭೂಮಿಯಲ್ಲಿ, ಇಸ್ರಾಯೇಲ್ ಜನಸಮೂಹದವರು ನನ್ನೊಡನೆ ವಾಗ್ವಾದ ಮಾಡಿದಾಗ ಅವರ ಮುಂದೆ ನೀರಿನ ಬಳಿಯಲ್ಲಿ ನನ್ನನ್ನು ಗೌರವಿಸದೆ, ನನ್ನ ಆಜ್ಞೆಯನ್ನು ಮೀರಿದಿರಿ. ಆ ನೀರು ಎಂದರೆ ಚಿನ್ ಎಂಬ ಮರುಭೂಮಿಯ ಕಾದೇಶಿನಲ್ಲಿರುವ ಮೆರೀಬಾದ ನೀರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ಎಲ್ಲಾ ಮನುಷ್ಯರ ಆತ್ಮಗಳ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಈ ಜನಸಮೂಹದ ಮೇಲೆ ಒಬ್ಬ ಮನುಷ್ಯನನ್ನು ನೇಮಿಸಿ ಇಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ಅವನು ಅವರ ಮುಂದಾಗಿ ಹೋಗಲಿ, ಅವರ ಮುಂದಾಗಿ ಬರಲಿ. ಅವರನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗಲಿ, ಕರೆದುಕೊಂಡು ಬರಲಿ. ಯೆಹೋವ ದೇವರ ಈ ಜನಸಮೂಹವು ಕುರುಬನಿಲ್ಲದ ಕುರಿಗಳ ಹಾಗೆ ಇರಬಾರದು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ಆಗ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ, “ಪವಿತ್ರಾತ್ಮವುಳ್ಳವನಾಗಿರುವ ನೂನನ ಮಗ ಯೆಹೋಶುವನನ್ನು ತೆಗೆದುಕೊಂಡು, ನಿನ್ನ ಕೈಯನ್ನು ಅವನ ಮೇಲೆ ಇಟ್ಟು, ");
INSERT INTO kanokcv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ಅವನನ್ನು ಯಾಜಕನಾದ ಎಲಿಯಾಜರನ ಮುಂದೆಯೂ ಸಮಸ್ತ ಸಭೆಯ ಮುಂದೆಯೂ ನಿಲ್ಲಿಸಿ, ಅವರಿಗೆದುರಾಗಿ ಅವನನ್ನು ನೇಮಿಸು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಸಭೆಯು ಅವನಿಗೆ ವಿಧೇಯರಾಗುವಂತೆ, ನಿನಗಿರುವ ಗೌರವವನ್ನು ಅವನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ಅವನು ಯಾಜಕನಾದ ಎಲಿಯಾಜರನ ಮುಂದೆ ನಿಲ್ಲಬೇಕು. ಎಲಿಯಾಜರನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಊರೀಮ್ ನ್ಯಾಯದ ಪ್ರಕಾರ ಅವನಿಗೋಸ್ಕರ ವಿಚಾರಣೆಯನ್ನು ಮಾಡಬೇಕು. ಯೆಹೋಶುವನ ಆಜ್ಞೆಯ ಪ್ರಕಾರವೇ ಅವನು ಮತ್ತು ಅವನ ಸಂಗಡ ಇರುವ ಸಮಸ್ತ ಇಸ್ರಾಯೇಲರ ಸಮೂಹವೂ ಹೊರಡಬೇಕು ಹಾಗು ಹಿಂದಿರುಗಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಅವನು ಮಾಡಿ, ಯೆಹೋಶುವನನ್ನು ತೆಗೆದುಕೊಂಡು, ಅವನನ್ನು ಯಾಜಕನಾದ ಎಲಿಯಾಜರನ ಮುಂದೆಯೂ, ಸಮಸ್ತ ಸಭೆಯ ಮುಂದೆಯೂ ನಿಲ್ಲಿಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ಅವನ ಮೇಲೆ ತನ್ನ ಕೈಗಳನ್ನು ಇಟ್ಟು, ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಅವನನ್ನು ನೇಮಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಿ ಅವರಿಗೆ, ‘ನನಗೆ ಸುವಾಸನೆಗೋಸ್ಕರ ಅರ್ಪಿಸುವ ಅಂದರೆ, ದಹನಬಲಿಗಾಗಿ ಆಹಾರವನ್ನು ಅದರ ನೇಮಕವಾದ ಸಮಯದಲ್ಲಿ ನನಗೆ ಅರ್ಪಿಸುವಂತೆ ನೀವು ನೋಡಿಕೊಳ್ಳಿರಿ.’ ");
INSERT INTO kanokcv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ನೀನು ಅವರಿಗೆ ಹೇಳಬೇಕಾದದ್ದು: ‘ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಬೇಕಾದ ಅರ್ಪಣೆ ಏನೆಂದರೆ, ನಿಯಮಿತವಾಗಿ ಪ್ರತಿದಿನ ದೋಷರಹಿತ ಒಂದು ವರ್ಷದ ಎರಡು ಕುರಿಮರಿಗಳನ್ನು ದಹನಬಲಿಯಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ಒಂದು ಕುರಿಮರಿಯನ್ನು ಮುಂಜಾನೆಯಲ್ಲಿಯೂ ಮತ್ತೊಂದನ್ನು ಸಾಯಂಕಾಲದಲ್ಲಿಯೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ಧಾನ್ಯ ಅರ್ಪಣೆಗಾಗಿ ಸುಮಾರು ಒಂದು ಲೀಟರ್ ಕುಟ್ಟಿ ತೆಗೆದ ಓಲಿವ್ ಎಣ್ಣೆಯನ್ನು ಸುಮಾರು ಒಂದುವರೆ ಕಿಲೋಗ್ರಾಂ ಗೋಧಿಹಿಟ್ಟಿಗೆ ಬೆರೆಸಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ಇದು ಸೀನಾಯಿ ಪರ್ವತದಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯ ದಹನಬಲಿಗಾಗಿ ನೇಮಿಸಿದ ನಿತ್ಯ ದಹನಬಲಿಯು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ಒಂದು ಕುರಿಮರಿಯೊಂದಿಗೆ ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಒಂದು ಲೀಟರ್ ಹುದುಗಿದ ದ್ರಾಕ್ಷಾರಸದ ಪಾನದ ಅರ್ಪಣೆಯನ್ನು ಯೆಹೋವ ದೇವರಿಗೋಸ್ಕರ ಸುರಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ಎರಡನೆಯ ಕುರಿಮರಿಯನ್ನು ಸಂಜೆಯಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ಅದರ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ ಪಾನದ ಅರ್ಪಣೆಯನ್ನೂ ಬೆಳಿಗ್ಗೆ ಮಾಡಿದಂತೆಯೇ, ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾಗಿರುವಂತೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಬಲಿಯನ್ನು ನೀನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘ಆದರೆ ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ದೋಷರಹಿತ ಒಂದು ವರ್ಷದ ಎರಡು ಕುರಿಮರಿಗಳನ್ನೂ, ಓಲಿವ್ ಎಣ್ಣೆ ಕಲಸಿದ ಎಫಾದ ಹತ್ತನೇ ಎರಡು ಭಾಗ ಗೋಧಿಹಿಟ್ಟನ್ನೂ, ಅದಕ್ಕೆ ತಕ್ಕ ಪಾನದ ಸಮರ್ಪಣೆಯನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ನಿತ್ಯ ದಹನಬಲಿಯ ಹೊರತು, ಪ್ರತಿ ಸಬ್ಬತ್ ದಿನಕ್ಕೆ ತಕ್ಕ ದಹನಬಲಿಯೂ ಅದರ ಪಾನದ ಅರ್ಪಣೆಯೂ ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘ತಿಂಗಳುಗಳ ಆರಂಭದಲ್ಲಿ ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ದಹನಬಲಿಗಾಗಿ ದೋಷರಹಿತ ಎರಡು ಎಳೆಯ ಹೋರಿಗಳನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ಒಂದೊಂದು ಹೋರಿಗೆ ಧಾನ್ಯ ಅರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಕಲಸಿದ ಎಫಾದ ಹತ್ತನೇ ಮೂರು ಭಾಗ ಹಿಟ್ಟನ್ನೂ, ಟಗರಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಕಲಸಿದ ಎಫಾದ ಹತ್ತನೇ ಎರಡು ಭಾಗ ಹಿಟ್ಟನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ಕುರಿಮರಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಕಲಸಿದ ಎಫಾದ ಹತ್ತನೇ ಒಂದು ಭಾಗ ಹಿಟ್ಟನ್ನೂ, ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯ ದಹನಬಲಿಗಾಗಿ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಬಲಿಯೂ ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ಇವುಗಳಿಗೆ ತಕ್ಕ ಪಾನದ ಅರ್ಪಣೆಗಳು ಎಂದರೆ, ಹೋರಿಗೆ ಸುಮಾರು ಎರಡು ಲೀಟರ್ ದ್ರಾಕ್ಷಾರಸವು, ಟಗರಿಗೆ ಸುಮಾರು ಒಂದುವರೆ ಲೀಟರ್ ದ್ರಾಕ್ಷಾರಸವು, ಕುರಿಮರಿಗೆ ಸುಮಾರು ಒಂದು ಲೀಟರ್ ದ್ರಾಕ್ಷಾರಸವು ಇರಬೇಕು. ಇದು ವರ್ಷದ ಪ್ರತಿ ತಿಂಗಳಿನ ಆರಂಭದಲ್ಲಿ ಹೀಗೆ ದಹನಬಲಿಯನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ಇದಲ್ಲದೆ ನಿತ್ಯ ದಹನಬಲಿಯ ಹೊರತು, ಯೆಹೋವ ದೇವರಿಗೆ ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಅದಕ್ಕೆ ತಕ್ಕ ಪಾನದ ಅರ್ಪಣೆಯನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘ಆದರೆ ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನವು ಯೆಹೋವ ದೇವರ ಪಸ್ಕಹಬ್ಬವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ಆ ತಿಂಗಳ ಹದಿನೈದನೆಯ ದಿನವು ಹಬ್ಬವಾಗಿದೆ. ಏಳು ದಿನಗಳವರೆಗೆ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನು ತಿನ್ನಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಪರಿಶುದ್ಧ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆ ಸೇರಬೇಕು. ಯಾವ ತರವಾದ ಉದ್ಯೋಗವನ್ನು ನೀವು ಆ ದಿನದಲ್ಲಿ ಮಾಡಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ಆದರೆ ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ದಹನಬಲಿಯನ್ನು ಅರ್ಪಿಸಬೇಕು. ಯಾವುದೆಂದರೆ: ಎರಡು ಎಳೆಯ ಹೋರಿಗಳು, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳು. ಇವು ದೋಷವಿಲ್ಲದೆ ಪೂರ್ಣಾಂಗವಾಗಿಯೇ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ಅವುಗಳ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ, ಎಣ್ಣೆ ಕಲಸಿದ ಐದು ಕಿಲೋಗ್ರಾಂ ಹಿಟ್ಟನ್ನು ಒಂದೊಂದು ಹೋರಿಗೆ, ಹತ್ತನೇ ಎರಡು ಭಾಗ ಟಗರಿಗೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ಮತ್ತು ಏಳು ಕುರಿಮರಿಗಳಲ್ಲಿ ಒಂದೊಂದಕ್ಕೆ ಸುಮಾರು ಒಂದುವರೆ ಕಿಲೋಗ್ರಾಂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ನಿಮಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಲು ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ನಿತ್ಯ ದಹನಬಲಿಯಾಗಿರುವ ಮುಂಜಾನೆಯ ದಹನಬಲಿಯ ಹೊರತಾಗಿ ಇವುಗಳನ್ನು ನೀವು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ಈ ಪ್ರಕಾರ ನೀವು ಏಳು ದಿವಸಗಳ ಮಟ್ಟಿಗೆ ಪ್ರತಿದಿನವೂ ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಗಾಗಿ ದಹನಬಲಿಯ ಆಹಾರವನ್ನು ಅರ್ಪಿಸಬೇಕು. ಅದನ್ನೂ ಅದಕ್ಕೆ ತಕ್ಕ ಪಾನಾರ್ಪಣೆಯನ್ನೂ ನಿತ್ಯವಾದ ದಹನಬಲಿಯ ಹೊರತಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ಏಳನೆಯ ದಿವಸದಲ್ಲಿ ಪರಿಶುದ್ಧವಾದ ಸಭೆ ಕೂಡಬೇಕು. ಆ ದಿನದಲ್ಲಿ ನೀವು ದೈನಂದಿನ ಉದ್ಯೋಗವನ್ನೂ ಮಾಡಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘ಪ್ರಥಮ ಫಲಗಳ ದಿವಸದಲ್ಲಿಯೂ ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ನಿಮ್ಮ ವಾರಗಳಲ್ಲಿ ಹೊಸ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನು ಅರ್ಪಿಸುವಾಗ, ಆ ದಿನದಲ್ಲಿ ನೀವು ಉದ್ಯೋಗವನ್ನೂ ಮಾಡದೆ ಪವಿತ್ರ ಸಭೆ ಕೂಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯುಳ್ಳ ದಹನಬಲಿಯಾಗಿ ಎರಡು ಎಳೆಯ ಹೋರಿಗಳನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ಅವುಗಳ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಕಲಸಿದ ಸುಮಾರು ಐದು ಕಿಲೋಗ್ರಾಂ ಹಿಟ್ಟನ್ನು ಪ್ರತಿಯೊಂದು ಹೋರಿಗೆ, ಸುಮಾರು ಮೂರುವರೆ ಕಿಲೋಗ್ರಾಂ ಟಗರಿಗೂ ");
INSERT INTO kanokcv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ಏಳು ಕುರಿಮರಿಗಳಲ್ಲಿ ಸುಮಾರು ಒಂದುವರೆ ಕಿಲೋಗ್ರಾಂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ನಿಮಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕೆ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ನಿತ್ಯವಾದ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ ಹೊರತಾಗಿ ಇವುಗಳ ಜೊತೆಗೆ ನೀವು ದೋಷವಿಲ್ಲದ ಪ್ರಾಣಿಗಳನ್ನೂ ಅವುಗಳಿಗೆ ತಕ್ಕ ಪಾನದ ಅರ್ಪಣೆಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘ಏಳನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿವಸದಲ್ಲಿ ನೀವು ಪರಿಶುದ್ಧ ಸಭೆಯಾಗಿ ಕೂಡಿಬರಬೇಕು. ದೈನಂದಿನ ಉದ್ಯೋಗವನ್ನು ನೀವು ಮಾಡಬಾರದು. ಅದು ನಿಮಗೆ ತುತೂರಿಗಳನ್ನು ಊದುವ ದಿವಸವಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ನೀವು ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಗಾಗಿ ದೋಷವಿಲ್ಲದ ಒಂದು ಎಳೆಯ ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳನ್ನೂ ದಹನಬಲಿಯಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ಅವುಗಳಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯಾಗಿ ಎಣ್ಣೆಯಿಂದ ಕಲಸಿದ ಹಿಟ್ಟನ್ನು ಹೋರಿಗೆ ಎಫಾದ ಹತ್ತನೇ ಮೂರು ಭಾಗ, ಟಗರಿಗೆ ಹತ್ತನೇ ಎರಡು ಭಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ಆ ಏಳು ಕುರಿಮರಿಗಳಲ್ಲಿ ಒಂದೊಂದಕ್ಕೆ ಹತ್ತನೇ ಒಂದು ಭಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ನಿಮಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವುದಕ್ಕೆ ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ಇದಲ್ಲದೆ ಪ್ರತಿ ತಿಂಗಳಿನ ಮತ್ತು ನಿತ್ಯವಾದ ದಹನಬಲಿಗಳಿಗೆ ಹೆಚ್ಚುವರಿಯಾಗಿ ಅವುಗಳ ಧಾನ್ಯ ಅರ್ಪಣೆಯನ್ನು ಮತ್ತು ಪಾನ ಅರ್ಪಣೆಗಳನ್ನು ನಿರ್ದಿಷ್ಟಪಡಿಸಿದಂತೆ ಸಮರ್ಪಣೆಯಾಗಬೇಕು, ಅವು ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಗಾಗಿ ಅರ್ಪಿಸುವ ದಹನಬಲಿಯಾಗಿರುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿವಸದಲ್ಲಿ ನೀವು ಪರಿಶುದ್ಧ ಸಭೆಯನ್ನು ಕೂಡಿಸಬೇಕು. ನೀವು ಎಲ್ಲವನ್ನು ವರ್ಜಿಸಿ, ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ಆದರೆ ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯಾದ ದಹನಬಲಿಗಾಗಿ ದೋಷವಿಲ್ಲದ ಒಂದು ಎಳೆಯ ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ಅವುಗಳ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಕಲಸಿದ ಹಿಟ್ಟನ್ನು, ಹೋರಿಗೆ ಎಫಾದ ಹತ್ತನೇ ಮೂರು ಭಾಗ, ಟಗರಿಗೆ ಎಫಾದ ಹತ್ತನೇ ಎರಡು ಭಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ಏಳು ಕುರಿಮರಿಗಳಲ್ಲಿ ಒಂದೊಂದಕ್ಕೆ ಹತ್ತನೇ ಒಂದು ಭಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಗಾಗಿ ಒಂದು ಹೋತನ್ನು ಅರ್ಪಿಸುವದರ ಜೊತೆಗೆ ಪ್ರಾಯಶ್ಚಿತ್ತದ ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯನ್ನೂ ನಿತ್ಯ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯ ಸಮರ್ಪಣೆಯನ್ನೂ ಅವುಗಳಿಗೆ ತಕ್ಕ ಪಾನದ ಅರ್ಪಣೆಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿವಸದಲ್ಲಿ ನೀವು ಪರಿಶುದ್ಧ ಸಭೆಯಾಗಿ ಕೂಡಿಬರಬೇಕು. ದೈನಂದಿನ ಉದ್ಯೋಗವನ್ನು ಮಾಡಬಾರದು. ಯೆಹೋವ ದೇವರಿಗೆ ಏಳು ದಿವಸ ಹಬ್ಬವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ದಹನಬಲಿಯಾಗಿ ಬಲಿಯನ್ನು ಅರ್ಪಿಸಬೇಕು. ಏನೆಂದರೆ, ದೋಷವಿಲ್ಲದ ಹದಿಮೂರು ಎಳೆಯ ಹೋರಿಗಳನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ಅವುಗಳ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಕಲಸಿದ ಹಿಟ್ಟನ್ನು ಹದಿಮೂರು ಹೋರಿಗಳಲ್ಲಿ ಒಂದೊಂದಕ್ಕೆ ಎಫಾದ ಹತ್ತನೇ ಮೂರು ಭಾಗ, ಎರಡು ಟಗರುಗಳಲ್ಲಿ ಒಂದೊಂದಕ್ಕೆ ಎಫಾದ ಹತ್ತನೇ ಎರಡು ಭಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ಹದಿನಾಲ್ಕು ಕುರಿಮರಿಗಳಲ್ಲಿ ಒಂದೊಂದಕ್ಕೆ ಎಫಾದ ಹತ್ತನೇ ಒಂದು ಭಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಇದಲ್ಲದೆ ನಿತ್ಯ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯ ಸಮರ್ಪಣೆ ಮತ್ತು ಪಾನದ ಅರ್ಪಣೆಯನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘ಎರಡನೆಯ ದಿವಸದಲ್ಲಿ ಕಳಂಕವಿಲ್ಲದ ಹನ್ನೆರಡು ಎಳೆಯ ಹೋರಿಗಳನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ಹೋರಿಗಳಿಗೆ, ಟಗರುಗಳಿಗೆ ಮತ್ತು ಕುರಿಮರಿಗಳಿಗೆ ಲೆಕ್ಕದ ಪದ್ಧತಿಯ ಪ್ರಕಾರ ಅವುಗಳ ಧಾನ್ಯ ಪಾನಗಳ ಅರ್ಪಣೆಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ದೋಷಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಒಂದು ಹೋತನ್ನಲ್ಲದೆ ನಿತ್ಯ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯಪಾನ ಅರ್ಪಣೆಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘ಮೂರನೆಯ ದಿವಸದಲ್ಲಿ ದೋಷವಿಲ್ಲದ ಹನ್ನೊಂದು ಹೋರಿಗಳನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ಹೋರಿಗಳಿಗೆ, ಟಗರುಗಳಿಗೆ ಮತ್ತು ಕುರಿಮರಿಗಳಿಗೆ ಅವುಗಳ ಲೆಕ್ಕದ ಪದ್ಧತಿಯ ಪ್ರಕಾರ ಅವುಗಳ ಧಾನ್ಯ ಪಾನಗಳ ಅರ್ಪಣೆಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಒಂದು ಹೋತನ್ನಲ್ಲದೆ ನಿತ್ಯ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯಪಾನ ಅರ್ಪಣೆಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘ನಾಲ್ಕನೆಯ ದಿವಸದಲ್ಲಿ ದೋಷವಿಲ್ಲದ ಹತ್ತು ಹೋರಿಗಳನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ಹೋರಿಗಳಿಗೆ, ಟಗರುಗಳಿಗೆ ಮತ್ತು ಕುರಿಮರಿಗಳಿಗೆ ಅವುಗಳ ಲೆಕ್ಕದ ಪದ್ಧತಿಯ ಪ್ರಕಾರ ಅವುಗಳ ಧಾನ್ಯ ಪಾನಗಳ ಅರ್ಪಣೆಗಳನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಇದಲ್ಲದೆ ನಿತ್ಯ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯಪಾನ ಅರ್ಪಣೆಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘ಐದನೆಯ ದಿವಸದಲ್ಲಿ ದೋಷವಿಲ್ಲದ ಒಂಬತ್ತು ಹೋರಿಗಳನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ಹೋರಿಗಳಿಗೆ, ಟಗರುಗಳಿಗೆ ಮತ್ತು ಕುರಿಮರಿಗಳಿಗೆ ಲೆಕ್ಕದ ಪದ್ಧತಿಯ ಪ್ರಕಾರ ಅವುಗಳ ಧಾನ್ಯಪಾನ ಬಲಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಒಂದು ಹೋತನ್ನಲ್ಲದೆ ನಿತ್ಯ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯಪಾನ ಅರ್ಪಣೆಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘ಆರನೆಯ ದಿವಸದಲ್ಲಿ ದೋಷವಿಲ್ಲದ ಎಂಟು ಹೋರಿಗಳನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ಹೋರಿಗಳಿಗೆ, ಟಗರುಗಳಿಗೆ ಮತ್ತು ಕುರಿಮರಿಗಳಿಗೆ ಲೆಕ್ಕದ ಪದ್ಧತಿಯ ಪ್ರಕಾರ ಅವುಗಳ ಧಾನ್ಯ ಪಾನಗಳ ಅರ್ಪಣೆಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಒಂದು ಹೋತನ್ನಲ್ಲದೆ ನಿತ್ಯ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯಪಾನ ಅರ್ಪಣೆಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘ಏಳನೆಯ ದಿವಸದಲ್ಲಿ ದೋಷವಿಲ್ಲದ ಏಳು ಹೋರಿಗಳನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಕುರಿಮರಿಗಳನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ಹೋರಿಗಳಿಗೆ, ಟಗರುಗಳಿಗೆ ಮತ್ತು ಕುರಿಮರಿಗಳಿಗೆ ಅವುಗಳ ಲೆಕ್ಕದ ಪದ್ಧತಿಯ ಪ್ರಕಾರ ಅವುಗಳ ಧಾನ್ಯ ಪಾನಗಳ ಅರ್ಪಣೆಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಒಂದು ಹೋತನ್ನಲ್ಲದೆ ನಿತ್ಯ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯಪಾನ ಅರ್ಪಣೆಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಹಬ್ಬದ ಸಭೆಯಾಗಿ ಕೂಡಿಬರಬೇಕು. ದೈನಂದಿನ ಕೆಲಸವನ್ನು ನೀವು ಮಾಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ಯೆಹೋವ ದೇವರಿಗೆ ಸುವಾಸನೆಯ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ದಹನಬಲಿಗಾಗಿ ದೋಷವಿಲ್ಲದ ಒಂದು ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳನ್ನೂ ");
INSERT INTO kanokcv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ಹೋರಿಗೆ, ಟಗರಿಗೆ ಮತ್ತು ಕುರಿಮರಿಗಳಿಗೆ ಅವುಗಳ ಲೆಕ್ಕದ ಪದ್ಧತಿಯ ಪ್ರಕಾರ ಅವುಗಳ ಧಾನ್ಯ ಪಾನಗಳ ಅರ್ಪಣೆಗಳನ್ನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ಪಾಪ ಪರಿಹಾರಕ ಬಲಿಯಾಗಿ ಒಂದು ಹೋತನ್ನಲ್ಲದೆ ನಿತ್ಯ ದಹನಬಲಿಯನ್ನೂ ಅದರ ಧಾನ್ಯಪಾನ ಅರ್ಪಣೆಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘ಇದಲ್ಲದೆ ನಿಮ್ಮ ಹರಕೆಯನ್ನೂ ನಿಮ್ಮ ಉಚಿತವಾದ ಬಲಿಗಳನ್ನೂ ನಿಮ್ಮ ದಹನಬಲಿಗಳನ್ನೂ ನಿಮ್ಮ ಧಾನ್ಯಪಾನ ಅರ್ಪಣೆಗಳನ್ನೂ ನಿಮ್ಮ ಸಮಾಧಾನ ಬಲಿಗಳನ್ನೂ ನೀವು ನಿಮ್ಮ ಹಬ್ಬಗಳಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಮಾಡತಕ್ಕೆ ಸಮರ್ಪಣೆಗಳು ಇವೇ.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ಯೆಹೋವ ದೇವರು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೆಲ್ಲದರ ಪ್ರಕಾರ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರ ಗೋತ್ರಗಳ ನಾಯಕರ ಸಂಗಡ ಮಾತನಾಡಿ, “ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanokcv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ಯಾವನಾದರೂ ಯೆಹೋವ ದೇವರಿಗೆ ಹರಕೆಯನ್ನು ಮಾಡಿದರೆ, ಇಲ್ಲವೆ ಕಟ್ಟಳೆಯಿಂದ ತನ್ನ ಪ್ರಾಣವನ್ನು ಬಾಧಿಸುವ ಆಣೆ ಇಟ್ಟುಕೊಂಡರೆ, ಅವನು ತನ್ನ ಮಾತನ್ನು ತಪ್ಪಿಸಬಾರದು. ಬಾಯಿಂದ ಹೊರಟ ಮಾತುಗಳ ಪ್ರಕಾರ ಎಲ್ಲವನ್ನೂ ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“ಸ್ತ್ರೀಯು ಯೆಹೋವ ದೇವರಿಗೆ ಹರಕೆಮಾಡಿ, ತನ್ನ ಕನ್ಯಾವಸ್ಥೆಯಲ್ಲಿ ತಂದೆಯ ಮನೆಯಲ್ಲಿ ದೇವರಿಗೆ ಹರಕೆಯನ್ನು ಮಾಡಿದಾಗ, ಇಲ್ಲವೆ ಯಾವುದಾದರೊಂದನ್ನು ಮುಟ್ಟುವುದಿಲ್ಲವೆಂದು ಪ್ರತಿಜ್ಞೆ ಮಾಡಿದಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ಅವಳ ತಂದೆಯು ಆ ವಿಷಯವನ್ನು ತಿಳಿದು ಮೌನವಾಗಿದ್ದರೆ, ಅವಳು ಆ ಹರಕೆ ಮತ್ತು ಪ್ರಮಾಣಗಳನ್ನು ನೆರವೇರಿಸಲೇಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ಆದರೆ ಅವಳ ತಂದೆ ಅದನ್ನು ಕೇಳಿ ಅವಳನ್ನು ತಡೆದರೆ, ಅವಳ ಎಲ್ಲಾ ಹರಕೆಗಳೂ ಪ್ರತಿಜ್ಞೆಗಳೂ ವ್ಯರ್ಥವಾಗುತ್ತವೆ. ಅವಳ ತಂದೆ ಅವಳನ್ನು ತಡೆದ ಕಾರಣ ಯೆಹೋವ ದೇವರು ಅವಳನ್ನು ಕ್ಷಮಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ಆದರೆ ಅವಳಿಗೆ ಗಂಡನಿರುವ ವೇಳೆಯಲ್ಲಿ ಅವಳ ಮೇಲೆ ಹರಕೆಗಳು ಇಲ್ಲವೆ ಪ್ರಾಣವನ್ನು ಬಂಧಿಸುವ ಬಾಯಿಂದ ಬಂದ ಮಾತು ಇದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ಅವಳ ಗಂಡನು ಆ ವಿಷಯವನ್ನು ತಿಳಿದು ಸುಮ್ಮನಿದ್ದ ಪಕ್ಷದಲ್ಲಿ ಅವಳ ಹರಕೆಗಳೂ ಪ್ರತಿಜ್ಞೆಗಳೂ ನೆರವೇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ಆದರೆ ಅವಳ ಗಂಡನು ಅದನ್ನು ಕೇಳಿದಾಗ ಬೇಡವೆಂದು ತಡೆದು, ಅವಳ ಮೇಲೆ ಇರುವ ಅವಳ ಹರಕೆಯನ್ನೂ ಇಲ್ಲವೆ ಯೋಚಿಸದೆ ಮಾಡಿದ ಪ್ರತಿಜ್ಞೆಯನ್ನೂ ನಿರರ್ಥಕ ಮಾಡಿದ ಪಕ್ಷದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಅವಳಿಗೆ ಕ್ಷಮಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“ಇದಲ್ಲದೆ ವಿಧವೆಯಾದರೂ ವಿವಾಹ ವಿಚ್ಛೇದಿತ ಮಹಿಳೆಯಾದರೂ ಇಂತಹ ಹರಕೆ ಇಲ್ಲವೆ ಪ್ರಮಾಣ ಮಾಡಿಕೊಂಡರೆ ಅವಳು ಅದನ್ನು ನೆರವೇರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ಅವಳು ತನ್ನ ಗಂಡನ ಮನೆಯಲ್ಲಿ ಅಂತಹ ಹರಕೆ ಇಲ್ಲವೆ ಪ್ರತಿಜ್ಞೆಯನ್ನು ಮಾಡಿದಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ಅವಳ ಗಂಡನು ಅದನ್ನು ಕೇಳಿ ಅದಕ್ಕೆ ಮೌನವಾಗಿದ್ದು, ಅವಳನ್ನು ತಡೆಯದ ಪಕ್ಷದಲ್ಲಿ, ಅವಳ ಸಮಸ್ತ ಹರಕೆಗಳೂ ಪ್ರತಿಜ್ಞೆಗಳೂ ನಿಲ್ಲುವುವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ಆದರೆ ಅವಳ ಗಂಡನು ಅವುಗಳನ್ನು ಕೇಳಿದ ದಿವಸದಲ್ಲೇ ಅವುಗಳನ್ನು ಪೂರ್ಣವಾಗಿ ನಿರರ್ಥಕ ಮಾಡಿದ ಪಕ್ಷದಲ್ಲಿ ಅವಳ ಹರಕೆಗಳಿಗೋಸ್ಕರವೂ ಅವಳು ಕೈಗೊಂಡ ಕಟ್ಟಳೆಗೋಸ್ಕರವೂ ಅವಳ ತುಟಿಗಳಿಂದ ಹೊರಟದ್ದು ಯಾವುದಾಗಲಿ ನಿಲ್ಲದು. ಅವಳ ಗಂಡನು ಅವುಗಳನ್ನು ನಿರರ್ಥಕ ಮಾಡಿದ್ದಾನೆ. ಯೆಹೋವ ದೇವರು ಅವಳಿಗೆ ಕ್ಷಮಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ಸಮಸ್ತ ಪ್ರಮಾಣವನ್ನೂ ಪ್ರಾಣವನ್ನು ಕುಂದಿಸುವ ಸಮಸ್ತ ಹರಕೆಗಳನ್ನೂ, ಅವಳ ಗಂಡನು ಅದನ್ನು ಸ್ಥಾಪಿಸಬಹುದು ಅಥವಾ ಅದನ್ನು ರದ್ದುಗೊಳಿಸಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ಆದರೆ ಅವಳ ಗಂಡನು ಅದಕ್ಕೆ ದಿನದಿನಕ್ಕೆ ಪೂರ್ಣವಾಗಿ ಸುಮ್ಮನಿದ್ದರೆ, ಅವನು ಅವಳ ಸಮಸ್ತ ಹರಕೆಗಳನ್ನೂ ಅವಳ ಮೇಲಿರುವ ಸಮಸ್ತ ಪ್ರತಿಜ್ಞೆಗಳನ್ನೂ ಅನುಮೋದಿಸಿದಂತಾಗುವುದು. ಅವನು ಕೇಳಿದ ದಿನದಲ್ಲಿ ಅದಕ್ಕೆ ಸುಮ್ಮನಿರುವುದರಿಂದ ಅವುಗಳನ್ನು ಸ್ಥಾಪಿಸಿದ್ದಾನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ಆದರೆ ಅವನು ಕೇಳಿದ ತರುವಾಯ ಅವುಗಳನ್ನು ಹೇಗಾದರೂ ನಿರರ್ಥಕ ಮಾಡಿದರೆ, ಅವನೇ ಅವಳ ಅಕ್ರಮವನ್ನು ಹೊರಬೇಕು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ಗಂಡ ಹೆಂಡತಿಯರ ವಿಷಯದಲ್ಲಿಯೂ ತಂದೆಯ ಮನೆಯಲ್ಲಿ ಕನ್ಯಾವಸ್ಥೆಯಲ್ಲಿರುವ ಮಗಳ ವಿಷಯದಲ್ಲಿಯೂ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಕಟ್ಟಳೆಗಳು ಇವೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಂದ ಮಿದ್ಯಾನ್ಯರಿಗೆ ಮುಯ್ಯನ್ನು ತೀರಿಸಬೇಕು. ತರುವಾಯ ನೀನು ನಿನ್ನ ಪೂರ್ವಜರ ಬಳಿಗೆ ಸೇರಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ಆಗ ಮೋಶೆಯು ಜನರ ಸಂಗಡ ಮಾತನಾಡಿ, “ನಿಮ್ಮೊಳಗಿಂದ ಜನರು ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧಮಾಡಿಕೊಳ್ಳಲಿ. ಅವರು ಮಿದ್ಯಾನ್ಯರಿಗೆ ವಿರೋಧವಾಗಿ ಹೋಗಿ, ಯೆಹೋವ ದೇವರ ಪ್ರತೀಕಾರವನ್ನು ಅವರಿಗೆ ತೀರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ಇಸ್ರಾಯೇಲರ ಸಮಸ್ತ ಗೋತ್ರಗಳೊಳಗೆ ಒಂದೊಂದು ಗೋತ್ರದಿಂದ ಸಾವಿರ ಮಂದಿಯನ್ನು ಯುದ್ಧಕ್ಕೆ ಕಳುಹಿಸಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ಆಗ ಇಸ್ರಾಯೇಲರ ಒಂದೊಂದು ಗೋತ್ರದಿಂದ ಸಾವಿರ ಮಂದಿಯಾಗಿ ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧವಾದ ಹನ್ನೆರಡು ಸಾವಿರ ಮಂದಿಯನ್ನು ಲೆಕ್ಕಿಸಿಕೊಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ಮೋಶೆ ಒಂದೊಂದು ಗೋತ್ರದಿಂದ ಸಾವಿರ ಮಂದಿಯಾಗಿರುವ ಅವರನ್ನೂ ಯಾಜಕನಾದ ಎಲಿಯಾಜರನ ಮಗ ಫೀನೆಹಾಸನನ್ನೂ ಪರಿಶುದ್ಧ ಸಲಕರಣೆಗಳ ಸಂಗಡವೂ ಸೂಚಿಸುವದಕ್ಕೋಸ್ಕರ ತುತೂರಿಗಳ ಸಂಗಡವೂ ಯುದ್ಧಕ್ಕೆ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಅವರು ಮಿದ್ಯಾನ್ಯರ ಮೇಲೆ ಯುದ್ಧಮಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ಗಂಡಸರೆಲ್ಲರನ್ನು ಕೊಂದುಹಾಕಿದರು. ಈ ಹತರಾದವರಲ್ಲದೆ ಮಿದ್ಯಾನಿನ ಅರಸರನ್ನು ಕೊಂದುಹಾಕಿದರು. ಅವರು ಮಿದ್ಯಾನಿನ ಐದು ಮಂದಿ ಅರಸರಾಗಿರುವ ಎವೀ, ರೆಕೆಮ್, ಚೂರ್, ಹೂರ್, ರೆಬಾ, ಬೆಯೋರನ ಮಗ ಬಿಳಾಮನನ್ನೂ ಖಡ್ಗದಿಂದ ಕೊಂದುಹಾಕಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ಇಸ್ರಾಯೇಲರು ಮಿದ್ಯಾನ್ಯರ ಸ್ತ್ರೀಯರನ್ನೂ, ಅವರ ಮಕ್ಕಳನ್ನೂ ಸೆರೆಹಿಡಿದು, ಅವರ ಸಮಸ್ತ ಪಶುಗಳನ್ನೂ, ಅವರ ಸಮಸ್ತ ಹಿಂಡುಗಳನ್ನೂ, ಅವರ ಸಮಸ್ತ ಸಲಕರಣೆಗಳನ್ನೂ ಸುಲಿಗೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ಅವರು ವಾಸಮಾಡಿದ ಸಮಸ್ತ ಪಟ್ಟಣಗಳನ್ನೂ, ಅವರ ಸಮಸ್ತ ಕೋಟೆಗಳನ್ನೂ ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ಮನುಷ್ಯರಲ್ಲಿಯೂ, ಪಶುಗಳಲ್ಲಿಯೂ ಸಮಸ್ತ ಸುಲಿಗೆಯನ್ನೂ, ಸಮಸ್ತ ಲೂಟಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ಅವರು ಸೆರೆಯವರನ್ನೂ, ಲೂಟಿಯನ್ನೂ, ಸುಲಿಗೆಯನ್ನೂ ಮೋಶೆ, ಯಾಜಕನಾದ ಎಲಿಯಾಜರನು, ಇಸ್ರಾಯೇಲರ ಸಭೆ ಇವರ ಬಳಿಗೆ ಯೆರಿಕೋ ಪಟ್ಟಣಕ್ಕೆ ಎದುರಾಗಿ ಯೊರ್ದನ್ ನದಿಯ ಮೇಲೆ ಇರುವ ಮೋವಾಬಿನ ಬಯಲುಗಳಲ್ಲಿ ಇದ್ದ ಪಾಳೆಯದೊಳಗೆ ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ಮೋಶೆಯೂ, ಯಾಜಕನಾದ ಎಲಿಯಾಜರನೂ, ಸಮೂಹದ ಪ್ರಧಾನರೆಲ್ಲರೂ ಅವರಿಗೆ ಎದುರಾಗಿ ಪಾಳೆಯದ ಹೊರಗೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ಆದರೆ ಮೋಶೆಯು ಯುದ್ಧದಿಂದ ಬಂದ ಸಹಸ್ರಾಧಿಪತಿಗಳೂ ಶತಾಧಿಪತಿಗಳೂ ಆಗಿರುವ ಪಾಳೆಯದ ಮೇಲೆ ಕೋಪಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ಮೋಶೆಯು ಅವರಿಗೆ, “ಹೆಂಗಸರನ್ನೆಲ್ಲಾ ಉಳಿಸಿದರೋ? ");
INSERT INTO kanokcv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ಇವರೇ ಬಿಳಾಮನ ಮಾತಿನಿಂದ ಪೆಯೋರನ ಕಾರ್ಯದಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ವಿರೋಧವಾಗಿ ದ್ರೋಹ ಮಾಡುವುದಕ್ಕೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಕಾರಣವಾಗಿದ್ದರು. ಯೆಹೋವ ದೇವರ ಸಭೆಯೊಳಗೆ ಇವರಿಂದಲೇ ವ್ಯಾಧಿಯಾಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ಆದಕಾರಣ ಈಗ ಬಾಲಕರನ್ನೂ, ಎಲ್ಲಾ ಪುರುಷನನ್ನು ಅರಿತಿರುವ ಎಲ್ಲಾ ಸ್ತ್ರೀಯರನ್ನು ಕೊಂದುಹಾಕಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ಆದರೆ ಪುರುಷನನ್ನು ಅರಿಯದ ಎಲ್ಲಾ ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ನಿಮಗಾಗಿ ಉಳಿಸಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“ಇದಲ್ಲದೆ ನಿಮ್ಮಲ್ಲಿ ಪ್ರಾಣ ತೆಗೆದವರು ಮತ್ತು ಶವವನ್ನು ಮುಟ್ಟಿದವರು ಏಳು ದಿವಸ ಪಾಳೆಯದ ಹೊರಗೆ ಇರಬೇಕು. ನೀವೂ, ನಿಮ್ಮ ಸೆರೆಯವರೂ ಮೂರನೆಯ ಹಾಗೂ ಏಳನೆಯ ದಿವಸಗಳಲ್ಲಿ ನಿಮ್ಮನ್ನು ಶುದ್ಧ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ಎಲ್ಲಾ ಬಟ್ಟೆಗಳನ್ನೂ, ಎಲ್ಲಾ ಚರ್ಮದ ಸಲಕರಣೆಗಳನ್ನೂ, ಮೇಕೆ ಕೂದಲಿಂದ ಮಾಡಿದ್ದೆಲ್ಲವನ್ನೂ, ಕಟ್ಟಿಗೆ ಸಲಕರಣೆಗಳೆಲ್ಲವನ್ನೂ ಶುದ್ಧಮಾಡಬೇಕು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ಯಾಜಕನಾದ ಎಲಿಯಾಜರನು ಯುದ್ಧಕ್ಕೆ ಹೋದ ಪಾಳೆಯದ ಜನರಿಗೆ, “ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ನ್ಯಾಯದ ಕಟ್ಟಳೆಯು ಇದೇ: ");
INSERT INTO kanokcv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ಬೆಂಕಿ ತಾಳುವ ಬಂಗಾರ, ಬೆಳ್ಳಿ, ಕಂಚು, ಕಬ್ಬಿಣ, ತವರ, ಸೀಸ ಮೊದಲಾದವುಗಳನ್ನು ");
INSERT INTO kanokcv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ನೀವು ಬೆಂಕಿಯಿಂದ ದಾಟಿಸಬೇಕು. ಆಗ ಅವು ಶುದ್ಧವಾಗುವುವು. ಶುದ್ಧೀಕರಣದ ನೀರಿನಲ್ಲಿ ಅದ್ದಿ ಶುದ್ಧಮಾಡಬೇಕು. ಆಗ ಅವು ಶುದ್ಧವಾಗುವುವು. ಆದರೆ ಬೆಂಕಿ ತಾಳದ ಸಮಸ್ತವನ್ನು ನೀವು ನೀರಿನಿಂದ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ಏಳನೆಯ ದಿವಸದಲ್ಲಿ ನೀವು ನಿಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಶುದ್ಧರಾಗಬೇಕು. ತರುವಾಯ ಪಾಳೆಯದೊಳಗೆ ಬರಬೇಕು,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“ನೀನೂ, ಯಾಜಕನಾದ ಎಲಿಯಾಜರನೂ, ಕುಲಾಧಿಪತಿಗಳೂ ಸೈನಿಕರ ಕೈಗೆ ಸಿಕ್ಕಿರುವ ಮನುಷ್ಯರನ್ನೂ ಪಶುಗಳನ್ನೂ ಲೆಕ್ಕಮಾಡಿ ಒಟ್ಟು ಎಷ್ಟೆಂದು ತಿಳಿದುಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ಆ ಸುಲಿಗೆಯನ್ನು ಯುದ್ಧಕ್ಕೆ ಹೊರಟ ಯುದ್ಧಭಟರಿಗೂ, ಸಮಸ್ತ ಸಭೆಗೂ ಎರಡು ಪಾಲನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ಜನರಿಂದಲೂ, ಪಶುಗಳಿಂದಲೂ, ಕತ್ತೆಗಳಿಂದಲೂ, ಕುರಿಗಳಿಂದಲೂ ಐನೂರರಲ್ಲಿ ಒಂದು ಪ್ರಾಣವನ್ನು ಯುದ್ಧಕ್ಕೆ ಹೊರಟ ಯುದ್ಧಭಟರ ಕಡೆಯಿಂದ ಯೆಹೋವ ದೇವರಿಗೆ ಕಪ್ಪವಾಗಿ ಎತ್ತಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ಅವರ ಅರ್ಧ ಪಾಲಿನಿಂದ ಅದನ್ನು ತೆಗೆದುಕೊಂಡು, ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಣೆಯಾಗಿ, ಯಾಜಕನಾದ ಎಲಿಯಾಜರನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ಇಸ್ರಾಯೇಲರ ಅರ್ಧ ಪಾಲಿನಿಂದ ಜನರಿಂದಲೂ, ಕತ್ತೆಗಳಿಂದಲೂ, ಮಂದೆಗಳಿಂದಲೂ, ಸಮಸ್ತ ಪಶುಗಳಿಂದಲೂ ಐವತ್ತರಲ್ಲಿ ಒಂದು ಪಾಲು ತೆಗೆದುಕೊಂಡು, ಅವುಗಳನ್ನು ಯೆಹೋವ ದೇವರ ಗುಡಾರವನ್ನು ನಿರ್ವಹಿಸುವ ಲೇವಿಯರಿಗೆ ಕೊಡಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ಆಗ ಮೋಶೆಯೂ, ಯಾಜಕನಾದ ಎಲಿಯಾಜರನೂ ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ಯುದ್ಧಭಟರು ತೆಗೆದುಕೊಂಡು ಬಂದ ಲೂಟಿಯಲ್ಲಿ ಉಳಿದ ಸುಲಿಗೆ ಎಷ್ಟೆಂದರೆ 6,75,000 ಕುರಿಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 ಪಶುಗಳು; ");
INSERT INTO kanokcv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ಕತ್ತೆಗಳು 61,000; ");
INSERT INTO kanokcv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ಪುರುಷರನ್ನು ಅರಿಯದ ಸ್ತ್ರೀಯರು 32,000 ಮಂದಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ಯುದ್ಧಕ್ಕೆ ಹೊರಟವರ ಅರ್ಧ ಭಾಗದ ಲೆಕ್ಕವಿದು: 3,37,500 ಕುರಿಗಳಿಂದ ");
INSERT INTO kanokcv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ಯೆಹೋವ ದೇವರಿಗೆ ಕೊಡಲಾದ ಕಪ್ಪವು 675; ");
INSERT INTO kanokcv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ಹಾಗೆಯೇ ಅವರಿಗೆ ದೊರಕಿದ 36,000 ದನಕರುಗಳಲ್ಲಿ ಯೆಹೋವ ದೇವರಿಗೆ ಉಂಟಾದ ಕಪ್ಪವು 72 ದನಕರುಗಳು; ");
INSERT INTO kanokcv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500 ಕತ್ತೆಗಳು; ಅವುಗಳಿಂದ ಯೆಹೋವ ದೇವರಿಗೆ ಉಂಟಾದ ಕಪ್ಪವು 61; ");
INSERT INTO kanokcv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 ಜನರು, ಅವರಿಂದ ಯೆಹೋವ ದೇವರಿಗೆ ಉಂಟಾದ ಕಪ್ಪವು 32 ಜನ. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರಿಗೆ ಪಡೆಯುವ ಕಪ್ಪವನ್ನು ಯಾಜಕನಾದ ಎಲಿಯಾಜರನಿಗೆ ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ಮೋಶೆಯು ಯುದ್ಧಕ್ಕೆ ಹೋದ ಜನರಿಂದ ತೆಗೆದುಕೊಂಡು ಇಸ್ರಾಯೇಲರಿಗೆ ಹಂಚಿದ ಅರ್ಧ ಭಾಗದ ವಿವರ: ");
INSERT INTO kanokcv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ಕುರಿಗಳಿಂದ ಸಭೆಯ ಅರ್ಧ 3, 37,500 ಕುರಿಗಳು; ");
INSERT INTO kanokcv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 ಪಶುಗಳು; ");
INSERT INTO kanokcv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 ಕತ್ತೆಗಳು; ");
INSERT INTO kanokcv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","16,000 ಜನರು; ");
INSERT INTO kanokcv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರ ಅರ್ಧದಿಂದ ಮನುಷ್ಯರಲ್ಲಿಯೂ ಪಶುಗಳಲ್ಲಿಯೂ ಐವತ್ತರಲ್ಲಿ ಒಂದು ಪಾಲನ್ನು ತೆಗೆದುಕೊಂಡು, ಯೆಹೋವ ದೇವರು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಯೆಹೋವ ದೇವರ ಗುಡಾರವನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಲೇವಿಯರಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ಆಗ ಸೈನ್ಯದ ಅಧಿಕಾರಿಗಳಾದ ಸಹಸ್ರಾಧಿಪತಿಗಳೂ ಶತಾಧಿಪತಿಗಳೂ ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು, ");
INSERT INTO kanokcv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ಮೋಶೆಗೆ ಅವರು, “ನಿನ್ನ ಸೇವಕರಾದ ನಾವು ನಮ್ಮ ಕೈಯಲ್ಲಿದ್ದ ಯುದ್ಧಭಟರ ಲೆಕ್ಕವನ್ನು ತೆಗೆದುಕೊಂಡೆವು. ಅವರೊಳಗೆ ಒಬ್ಬನಾದರೂ ಕಡಿಮೆಯಾಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ಆದ್ದರಿಂದ ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ನಮ್ಮ ಪ್ರಾಣಗಳಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ನಾವು ಒಬ್ಬೊಬ್ಬನಿಗೆ ಸಿಕ್ಕಿದಂಥ ಬಂಗಾರದ ವಸ್ತುಗಳಾದ ಸರಪಣಿಗಳನ್ನೂ, ಕಡಗಗಳನ್ನೂ, ಉಂಗುರಗಳನ್ನೂ, ವಾಲೆಗಳನ್ನೂ, ಪದಕಗಳನ್ನೂ ಯೆಹೋವ ದೇವರಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ತಂದಿದ್ದೇವೆ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ಮೋಶೆಯೂ, ಯಾಜಕನಾದ ಎಲಿಯಾಜರನೂ ವಿಚಿತ್ರ ಕೆಲಸವಾಗಿರುವ ಬಂಗಾರವನ್ನೆಲ್ಲಾ ಅದರಿಂದ ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ಸಹಸ್ರಾಧಿಪತಿಗಳೂ, ಶತಾಧಿಪತಿಗಳೂ ಯೆಹೋವ ದೇವರಿಗೆ ಅರ್ಪಿಸಿದ ಕಾಣಿಕೆಯ ಒಟ್ಟು ತೂಕ 16,750 ಶೆಕೆಲ್‌ಗಳು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ಯುದ್ಧದ ಜನರು ಒಬ್ಬೊಬ್ಬನು ಸ್ವಂತವಾಗಿ ಸುಲಿದುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ಆಗ ಮೋಶೆಯೂ, ಯಾಜಕನಾದ ಎಲಿಯಾಜರನೂ ಸಹಸ್ರಾಧಿಪತಿಗಳ ಮತ್ತು ಶತಾಧಿಪತಿಗಳ ಕೈಯಿಂದ ಬಂಗಾರವನ್ನು ತೆಗೆದುಕೊಂಡು, ಯೆಹೋವ ದೇವರ ಸಮ್ಮುಖದಲ್ಲಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಜ್ಞಾಪಕಕ್ಕಾಗಿ ದೇವದರ್ಶನ ಗುಡಾರದೊಳಗೆ ತಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ರೂಬೇನನ ಮಕ್ಕಳಿಗೂ ಗಾದನ ಮಕ್ಕಳಿಗೂ ಅಧಿಕ ಸಂಖೆಯಲ್ಲಿ ಪಶುಗಳು ಇದ್ದವು. ಅವರು ಯಜ್ಜೇರ್, ಗಿಲ್ಯಾದ್ ಎಂಬ ದೇಶಗಳನ್ನು ನೋಡಿದಾಗ, ಅದು ಪಶುಗಳಿಗೆ ತಕ್ಕ ಸ್ಥಳವೆಂದು ತಿಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ಆದ್ದರಿಂದ ಗಾದನ ಮಕ್ಕಳೂ ರೂಬೇನನ ಮಕ್ಕಳೂ ಮೋಶೆ ಮತ್ತು ಯಾಜಕನಾದ ಎಲಿಯಾಜರನ ಬಳಿಗೂ ಸಭೆಯ ಪ್ರಧಾನರಿಗೂ ಬಳಿಗೂ ಬಂದು ಮಾತನಾಡಿ: ");
INSERT INTO kanokcv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“ಅಟಾರೋತ್, ದೀಬೋನ್, ಯಜ್ಜೇರ್, ನಿಮ್ರಾ, ಹೆಷ್ಬೋನ್, ಎಲೆಯಾಲೆ, ಸೆಬಾಮ್, ನೆಬೋ, ಬೆಯೋನ್ ಎಂಬವುಗಳು, ");
INSERT INTO kanokcv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರ ಸಮೂಹಕ್ಕೆ ಅಧೀನಪಡಿಸಿದ ಪ್ರದೇಶವು ಪಶುಗಳ ಮೇವಿಗೆ ಸೂಕ್ತವಾಗಿದೆ. ನಿಮ್ಮ ಸೇವಕರಿಗೂ ಪಶುಗಳು ಉಂಟು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ಆದ್ದರಿಂದ ನಮಗೆ ನಿಮ್ಮ ದೃಷ್ಟಿಯಲ್ಲಿ ದಯೆಯು ಸಿಕ್ಕಿದ್ದಾದರೆ, ಈ ದೇಶವನ್ನು ನಿಮ್ಮ ಸೇವಕರಿಗೆ ಸ್ವಾಸ್ತ್ಯಕ್ಕಾಗಿ ಕೊಡಬೇಕು. ನಮ್ಮನ್ನು ಯೊರ್ದನ್ ನದಿಯ ಆಚೆಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಡಿರಿ,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ಆಗ ಮೋಶೆಯು ಗಾದನ ಮಕ್ಕಳಿಗೂ, ರೂಬೇನನ ಮಕ್ಕಳಿಗೂ, “ನಿಮ್ಮ ಸಹೋದರರು ಯುದ್ಧಕ್ಕೆ ಹೋಗುವಾಗ ನೀವು ಇಲ್ಲಿ ಕುಳಿತಿರಬೇಕೋ? ");
INSERT INTO kanokcv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ಯೆಹೋವ ದೇವರು ಅವರಿಗೆ ಕೊಟ್ಟ ದೇಶಕ್ಕೆ ಹೋಗುವುದಕ್ಕೆ ನೀವು ಇಸ್ರಾಯೇಲರ ಹೃದಯಗಳನ್ನು ಅಧೈರ್ಯಪಡಿಸುವುದು ಏಕೆ? ");
INSERT INTO kanokcv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ನಾನು ದೇಶವನ್ನು ನೋಡುವುದಕ್ಕೆ ಕಾದೇಶ್ ಬರ್ನೇಯದಿಂದ ಅವರನ್ನು ಕಳುಹಿಸಿದಾಗ, ನಿಮ್ಮ ಪಿತೃಗಳು ಹಾಗೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ಹೇಗೆಂದರೆ ಅವರು ಎಷ್ಕೋಲೆಂಬ ಹಳ್ಳದವರೆಗೆ ಬಂದು, ದೇಶವನ್ನು ನೋಡಿದಾಗ, ಇಸ್ರಾಯೇಲರ ಹೃದಯವನ್ನು ಯೆಹೋವ ದೇವರು ಅವರಿಗೆ ಕೊಟ್ಟ ದೇಶದ ಒಳಗೆ ಹೋಗದ ಹಾಗೆ ಅಧೈರ್ಯಪಡಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ಯೆಹೋವ ದೇವರು ಅದೇ ಸಮಯದಲ್ಲಿ ಕೋಪೋದ್ರೇಕವುಳ್ಳವರಾಗಿ ಪ್ರಮಾಣಮಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","ಅವರು ನನ್ನನ್ನು ಪೂರ್ಣಮನಸ್ಸಿನಿಂದ ಹಿಂಬಾಲಿಸದೆ ಇರುವುದರಿಂದ, ನಾನು ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೋಬರಿಗೆ ಪ್ರಮಾಣ ಮಾಡಿದ ದೇಶವನ್ನು ಈಜಿಪ್ಟಿನೊಳಗಿಂದ ಹೊರಬಂದ ಇಪ್ಪತ್ತು ವರ್ಷವೂ ಅದಕ್ಕಿಂತ ಅಧಿಕವಾದ ಪ್ರಾಯವುಳ್ಳ ಜನರಲ್ಲಿ ");
INSERT INTO kanokcv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ಯೆಹೋವ ದೇವರನ್ನು ಪೂರ್ಣಮನಸ್ಸಿನಿಂದ ಹಿಂಬಾಲಿಸಿದ ಕೆನಿಜ್ಜೀಯನಾದ ಯೆಫುನ್ನೆಯ ಮಗನಾಗಿರುವ ಕಾಲೇಬ್ ಮತ್ತು ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನ ಹೊರತು ಬೇರಾರೂ ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ಯೆಹೋವ ದೇವರು ಇಸ್ರಾಯೇಲರ ಮೇಲೆ ಕೋಪೋದ್ರೇಕಗೊಂಡದ್ದರಿಂದ, ಅವರ ದೃಷ್ಟಿಯಲ್ಲಿ ಕೆಟ್ಟತನವನ್ನು ಮಾಡಿದ ಸಂತತಿಯು ದಹಿಸುವವರೆಗೆ ಅವರನ್ನು ಮರುಭೂಮಿಯಲ್ಲಿ ನಲವತ್ತು ವರ್ಷ ಅಲೆದಾಡುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“ನಿಮ್ಮ ಪಿತೃಗಳ ಬದಲಾಗಿ ಬಂದಿರುವ ನೀವು, ಪಾಪಿಗಳಾಗಿ ಇಸ್ರಾಯೇಲ್ ಕುರಿತು ಯೆಹೋವ ದೇವರ ಕೋಪವನ್ನೂ ಮತ್ತಷ್ಟು ಹೆಚ್ಚಿಸುತ್ತಿದ್ದೀರಲ್ಲಾ. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ಏಕೆಂದರೆ ನೀವು ದೇವರ ಕಡೆಯಿಂದ ತೊಲಗಿದರೆ, ದೇವರು ಅವರನ್ನು ಮರುಭೂಮಿಯಲ್ಲಿಯೇ ಇರಿಸಿಬಿಡುವನು. ನೀವು ಈ ಸಮಸ್ತ ಜನರ ನಾಶಕ್ಕೆ ನೀವೇ ಕಾರಣರಾಗುವಿರಿ,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ಆಗ ಅವರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು, “ನಾವು ಇಲ್ಲಿ ನಮ್ಮ ಪಶುಗಳಿಗೋಸ್ಕರ ಹಟ್ಟಿಗಳನ್ನೂ, ನಮ್ಮ ಸ್ತ್ರಿಯರಿಗೋಸ್ಕರ ಮತ್ತು ಮಕ್ಕಳಿಗೋಸ್ಕರ ಪಟ್ಟಣಗಳನ್ನೂ ಕಟ್ಟುವೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ಆದರೆ ನಾವು ಇಸ್ರಾಯೇಲರ ಮುಂದೆ ಅವರನ್ನು ಅವರ ಸ್ಥಳದೊಳಗೆ ಸೇರಿಸುವವರೆಗೆ ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧರಾಗಿ ಓಡುವೆವು. ನಮ್ಮ ಸ್ತ್ರೀಯರು ಮತ್ತು ಮಕ್ಕಳು ಮಾತ್ರ ಈ ದೇಶದ ನಿವಾಸಿಗಳ ದೆಸೆಯಿಂದ ಭದ್ರವಾದ ಊರುಗಳಲ್ಲಿ ವಾಸವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಒಬ್ಬೊಬ್ಬನು ತನ್ನ ಸೊತ್ತನ್ನು ಹೊಂದಿಕೊಳ್ಳುವವರೆಗೆ, ನಾವು ನಮ್ಮ ಮನೆಗಳಿಗೆ ತಿರುಗುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ನಾವು ಯೊರ್ದನ್ ನದಿಯ ಆಚೆಯಲ್ಲಿ ಅವರ ಸಂಗಡ ಸೊತ್ತನ್ನು ತೆಗೆದುಕೊಳ್ಳುವುದಿಲ್ಲ. ಏಕೆಂದರೆ ನಮ್ಮ ಸೊತ್ತು ನಮಗೆ ಯೊರ್ದನ್ ನದಿಯ ಈಚೆ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಬಂತು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ಮೋಶೆಯು ಅವರಿಗೆ, “ನೀವು ಈ ಕಾರ್ಯವನ್ನು ಮಾಡಿದರೆ, ನೀವು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧವಾಗಿದ್ದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ನಿಮ್ಮಲ್ಲಿ ಸಿದ್ಧವಾದವರೆಲ್ಲರೂ ಯೆಹೋವ ದೇವರು ತಮ್ಮ ಶತ್ರುಗಳನ್ನು ತಮ್ಮ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಡಿಸುವವರೆಗೆ, ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಯೊರ್ದನ್ ನದಿಯನ್ನು ದಾಟಿದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ದೇಶವು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ವಶವಾದ ತರುವಾಯ, ನೀವು ಯೆಹೋವ ದೇವರ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ದೃಷಿಯಲ್ಲಿ ನಿರಪರಾಧಿಗಳಾಗಿದ್ದು, ಈ ದೇಶವು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ನಿಮ್ಮ ಸೊತ್ತಾಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“ಆದರೆ ನೀವು ಈ ಪ್ರಕಾರ ಮಾಡದಿದ್ದರೆ ಇಗೋ, ಯೆಹೋವ ದೇವರ ವಿರೋಧವಾಗಿ ಪಾಪಮಾಡಿದವರಾಗುವಿರಿ, ನಿಮ್ಮ ಪಾಪ ನಿಮ್ಮನ್ನು ಹಿಡಿದುಕೊಳ್ಳುವುದೆಂದು ತಿಳಿದುಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ನಿಮ್ಮ ಸ್ತ್ರಿಯರಿಗೋಸ್ಕರ ಮತ್ತು ಮಕ್ಕಳಿಗೋಸ್ಕರ ಪಟ್ಟಣಗಳನ್ನೂ ಕಟ್ಟಿ, ನಿಮ್ಮ ಬಾಯಿಂದ ಹೊರಟದ್ದನ್ನು ಮಾಡಿರಿ,” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ಗಾದನ ಮಕ್ಕಳೂ, ರೂಬೇನನ ಮಕ್ಕಳೂ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ನಮ್ಮ ಒಡೆಯನು ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ನಿನ್ನ ಸೇವಕರು ಮಾಡುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ನಮ್ಮ ಮಕ್ಕಳೂ, ನಮ್ಮ ಹೆಂಡತಿಯರೂ, ನಮ್ಮ ಸಂಪತ್ತೂ ನಮ್ಮ ಪಶುಗಳೆಲ್ಲಾ ಅಲ್ಲಿ ಗಿಲ್ಯಾದಿನ ಪಟ್ಟಣಗಳಲ್ಲಿ ಇರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ಆದರೆ ನಿನ್ನ ಸೇವಕರು ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧವಾದವರೆಲ್ಲರೂ ನಮ್ಮ ಒಡೆಯನು ಹೇಳಿದ ಪ್ರಕಾರ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಯುದ್ಧಕ್ಕೆ ದಾಟಿಹೋಗುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ಆಗ ಮೋಶೆಯು ಅವರ ವಿಷಯವಾಗಿ ಯಾಜಕನಾದ ಎಲಿಯಾಜರನಿಗೂ, ನೂನನ ಮಗ ಯೆಹೋಶುವನಿಗೂ, ಇಸ್ರಾಯೇಲರ ಗೋತ್ರಗಳ ಮುಖ್ಯ ಯಜಮಾನರಿಗೂ ಆಜ್ಞೆಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ಮೋಶೆಯು ಅವರಿಗೆ, “ಗಾದನ ಮಕ್ಕಳೂ, ರೂಬೇನನ ಮಕ್ಕಳೂ ಎಲ್ಲರೂ ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧವಾಗಿದ್ದು, ನಿಮ್ಮ ಸಂಗಡ ಯೊರ್ದನ್ ನದಿಯನ್ನು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ದಾಟಿದರೆ, ದೇಶವು ನಿಮ್ಮ ಮುಂದೆ ವಶವಾಗಿದ್ದಾಗ ನೀವು ಅವರಿಗೆ ಗಿಲ್ಯಾದ್ ದೇಶವನ್ನು ಸೊತ್ತಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ಆದರೆ ಅವರು ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧವಾಗಿ ನಿಮ್ಮ ಸಂಗಡ ದಾಟಿ ಬಾರದಿದ್ದರೆ, ಅವರು ನಿಮ್ಮೊಂದಿಗೆ ಕಾನಾನ್ ದೇಶದಲ್ಲಿಯೇ ಸೊತ್ತನ್ನು ಹೊಂದಿಕೊಳ್ಳಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ಆಗ ಗಾದನ ಮಕ್ಕಳೂ, ರೂಬೇನನ ಮಕ್ಕಳೂ ಉತ್ತರವಾಗಿ, “ಯೆಹೋವ ದೇವರು ನಿನ್ನ ಸೇವಕರಿಗೆ ಹೇಳಿದ್ದಂತೆಯೇ ನಾವು ಮಾಡುವೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ನಾವು ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧವಾಗಿ ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಕಾನಾನ್ ದೇಶಕ್ಕೆ ದಾಟಿ ಹೋಗುವೆವು. ಆದರೆ ಯೊರ್ದನ್ ನದಿಯ ಈಚೆಯಲ್ಲಿರುವ ನಮ್ಮ ಸೊತ್ತಿನ ಭಾಗವೇ ನಮಗಿರಲಿ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ಹಾಗೆಯೇ ಮೋಶೆಯು ಗಾದನ ಮಕ್ಕಳಿಗೂ, ರೂಬೇನನ ಮಕ್ಕಳಿಗೂ, ಯೋಸೇಫನ ಮಗನಾದ ಮನಸ್ಸೆಯ ಅರ್ಧ ಗೋತ್ರಕ್ಕೂ, ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನ ರಾಜ್ಯವನ್ನೂ, ಅರಸನಾದ ಓಗನ ರಾಜ್ಯವನ್ನೂ, ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನ ರಾಜ್ಯವನ್ನೂ, ಅದರ ಭೂಮಿಯನ್ನೂ, ಅದರ ಮೇರೆಗಳಲ್ಲಿ ಸುತ್ತಮುತ್ತಲ ಪಟ್ಟಣಗಳನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ಗಾದನ ಮಕ್ಕಳು ದೀಬೋನ್, ಅಟಾರೋತ್, ಅರೋಯೇರ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ಅಟ್ರೋತ್ಷೋಫಾನ್, ಯಜ್ಜೇರ್, ಯೊಗ್ಬೆಹಾ, ");
INSERT INTO kanokcv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ಬೇತ್ ನಿಮ್ರಾ ಮತ್ತು ಬೇತ್ ಹಾರಾನ್ ಎಂಬ ಭದ್ರವಾದ ಪಟ್ಟಣಗಳನ್ನೂ, ಕುರಿಗಳಿಗೆ ಹಟ್ಟಿಗಳನ್ನೂ ಕಟ್ಟಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ರೂಬೇನನ ಮಕ್ಕಳು ಹೆಷ್ಬೋನ್, ಎಲೆಯಾಲೆ, ಕಿರ್ಯಾತಯಿಮ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ನೆಬೋ, ಬಾಳ್ ಮೆಯೋನ್ ಎಂದು ಬೇರೆ ಈ ಹೆಸರು ಹೊಂದಿದ ಈ ಪಟ್ಟಣಗಳನ್ನೂ ಸಿಬ್ಮಾವನ್ನೂ ಕಟ್ಟಿ, ತಾವು ಕಟ್ಟಿದ ಪಟ್ಟಣಗಳಿಗೆ ಬೇರೆ ಹೆಸರುಗಳನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ಮನಸ್ಸೆಯ ಮಗ ಮಾಕೀರನ ಮಕ್ಕಳು ಗಿಲ್ಯಾದ್ ದೇಶಕ್ಕೆ ಹೋಗಿ, ಅದನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದರಲ್ಲಿದ್ದ ಅಮೋರಿಯರನ್ನು ಹೊರಡಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ಮೋಶೆಯು ಗಿಲ್ಯಾದನ್ನು ಮನಸ್ಸೆಯ ಮಗ ಮಾಕೀರನಿಗೆ ಕೊಟ್ಟಿದ್ದರಿಂದ, ಅವನು ಅದರಲ್ಲಿ ವಾಸಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ಆದರೆ ಮನಸ್ಸೆಯ ಮಗ ಯಾಯೀರನು ಹೋಗಿ, ಅವರ ನಗರಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ಅವುಗಳಿಗೆ ಯಾಯೀರನ ಹಳ್ಳಿಗಳೆಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ನೋಬಹನು ಹೋಗಿ ಕೆನಾತ್ ಎಂಬ ಪಟ್ಟಣವನ್ನೂ, ಅದರ ಗ್ರಾಮಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು, ಅದಕ್ಕೆ ತನ್ನ ಹೆಸರಿನ ಹಾಗೆ ನೋಬಹ ಎಂಬ ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ಮೋಶೆ ಆರೋನರ ನಾಯಕತ್ವದಲ್ಲಿ ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ತಮ್ಮ ಸೈನ್ಯಗಳ ಪ್ರಕಾರ ಹೊರಟ ಇಸ್ರಾಯೇಲರ ಪ್ರಯಾಣದ ಹಂತಗಳ ವಿವರ ಇಲ್ಲಿವೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಅವರ ಪ್ರಯಾಣದಲ್ಲಿ ತಂಗಿದ್ದ ಸ್ಥಳಗಳ ವಿವರಗಳನ್ನು ಬರೆದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ಅವರ ಪ್ರಯಾಣಗಳ ವಿವರಗಳು ಯಾವುವೆಂದರೆ: ಅವರು ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿವಸದಲ್ಲಿ ಪಸ್ಕಹಬ್ಬದ ಮರುದಿನ ಇಸ್ರಾಯೇಲರು ಸಮಸ್ತ ಈಜಿಪ್ಟನವರ ಎದುರಿನಲ್ಲೇ ಅಟ್ಟಹಾಸದಿಂದ ರಮ್ಸೇಸಿನಿಂದ ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ಹೇಗೆಂದರೆ ಆ ಕಾಲದಲ್ಲಿ ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟಿನವರ ಸಮಸ್ತ ಚೊಚ್ಚಲಿನವರನ್ನು ಹೊಡೆದು ಆ ಮಕ್ಕಳ ಶವಗಳನ್ನು ಹೂಣಿಟ್ಟರು, ಯೆಹೋವ ದೇವರು ಅವರ ದೇವರುಗಳಿಗೂ ಶಿಕ್ಷೆ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ಇಸ್ರಾಯೇಲರು ರಮ್ಸೇಸಿನಿಂದ ಹೊರಟು ಸುಕ್ಕೋತಿನಲ್ಲಿ ಇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ಸುಕ್ಕೋತಿನಿಂದ ಹೊರಟು ಮರುಭೂಮಿಯ ಮೇರೆಯಲ್ಲಿರುವ ಏತಾಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ಏತಾಮಿನಿಂದ ಹೊರಟು ಬಾಲ್ಜೆಫೋನಿಗೆ ಎದುರಾಗಿರುವ ಪೀಹಹೀರೋತಿಗೆ ತಿರುಗಿಕೊಂಡು, ಮಿಗ್ದೋಲಿಗೆ ಎದುರಾಗಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ಪೀಹಹೀರೋತಿನಿಂದ ಹೊರಟು ಸಮುದ್ರದೊಳಗಿಂದ ಮರುಭೂಮಿಗೆ ದಾಟಿದರು. ಆಗ ಅವರು ಮೂರು ದಿವಸದ ಪ್ರಯಾಣಮಾಡಿ ಏತಾಮೆಂಬ ಮರುಭೂಮಿಯಲ್ಲಿ ನಡೆದು ಮಾರಾದಲ್ಲಿ ಇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ಮಾರಾದಿಂದ ಹೊರಟು ಏಲೀಮಿಗೆ ಬಂದರು. ಎಲೀಮಿನಲ್ಲಿ ಹನ್ನೆರಡು ನೀರಿನ ಒರತೆಗಳೂ, ಎಪ್ಪತ್ತು ಖರ್ಜೂರ ಮರಗಳೂ ಇದ್ದುದರಿಂದ ಅಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ಏಲೀಮಿನಿಂದ ಹೊರಟು ಕೆಂಪುಸಮುದ್ರದ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ಕೆಂಪು ಸಮುದ್ರದಿಂದ ಹೊರಟು ಸೀನೆಂಬ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡು, ");
INSERT INTO kanokcv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ಸೀನೆಂಬ ಮರುಭೂಮಿಯಿಂದ ಹೊರಟು ದೊಫ್ಕದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ದೊಫ್ಕದಿಂದ ಹೊರಟು ಆಲೂಷದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ಆಲೂಷದಿಂದ ಹೊರಟು ರೆಫೀದೀಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ಆದರೆ ಅಲ್ಲಿ ಜನರಿಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ನೀರು ಇರಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ರೆಫೀದೀಮಿನಿಂದ ಹೊರಟು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ಸೀನಾಯಿ ಮರುಭೂಮಿಯಿಂದ ಹೊರಟು ಕಿಬ್ರೋತ್ ಹತಾವದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ಕಿಬ್ರೋತ್ ಹತಾವದಿಂದ ಹೊರಟು ಹಚೇರೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ಹಚೇರೋತಿನಿಂದ ಹೊರಟು ರಿತ್ಮದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ರಿತ್ಮದಿಂದ ಹೊರಟು ರಿಮ್ಮೋನ್ ಪೆರೆಚಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ರಿಮ್ಮೋನ್ ಪೆರೆಚಿನಿಂದ ಹೊರಟು ಲಿಬ್ನದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ಲಿಬ್ನದಿಂದ ಹೊರಟು ರಿಸ್ಸದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ರಿಸ್ಸದಿಂದ ಹೊರಟು ಕೆಹೇಲಾತಾನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ಕೆಹೇಲಾತಾನಿಂದ ಹೊರಟು ಶೆಫೆರ್ ಪರ್ವತದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ಶೆಫೆರ್ ಪರ್ವತದಿಂದ ಹೊರಟು ಹರಾದಾದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ಹರಾದಾದಿಂದ ಹೊರಟು ಮಖೇಲೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ಮಖೇಲೋತಿನಿಂದ ಹೊರಟು ತಹತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ತಹತಿನಿಂದ ಹೊರಟು ತೆರಹದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ತೆರಹದಿಂದ ಹೊರಟು ಮಿತ್ಕಾದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ಮಿತ್ಕಾದಿಂದ ಹೊರಟು ಹಷ್ಮೋನಾದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ಹಷ್ಮೋನಾದಿಂದ ಹೊರಟು ಮೋಸೇರೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ಮೋಸೇರೋತಿನಿಂದ ಹೊರಟು ಬೆನೇಯಾಕಾನಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ಬೆನೇಯಾಕಾನಿನಿಂದ ಹೊರಟು ಹೋರ್ಹಗಿದ್ಗಾದಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ಹೋರ್ಹಗಿದ್ಗಾದಿನಿಂದ ಹೊರಟು ಯೊಟ್ಬಾತದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ಯೊಟ್ಬಾತದಿಂದ ಹೊರಟು ಅಬ್ರೋನಾದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ಅಬ್ರೋನಾದಿಂದ ಹೊರಟು ಎಚ್ಯೋನ್ ಗೆಬೆರಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ಎಚ್ಯೋನ್ ಗೆಬೆರಿನಿಂದ ಹೊರಟು ಕಾದೇಶೆಂಬ ಚಿನ್ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ಕಾದೇಶಿನಿಂದ ಹೊರಟು ಎದೋಮ್ ದೇಶದ ಅಂತ್ಯದಲ್ಲಿರುವ ಹೋರ್ ಗುಡ್ಡದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ಆಗ ಯಾಜಕನಾದ ಆರೋನನು ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಹೋರ್ ಗುಡ್ಡದ ಮೇಲೆ ಏರಿ, ಅಲ್ಲಿ ಇಸ್ರಾಯೇಲರು ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಹೊರಟ ನಾಲ್ವತ್ತನೆಯ ವರ್ಷದ ಐದನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿವಸದಲ್ಲಿ ನಿಧನ ಹೊಂದಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","ಆರೋನನು ಹೋರ್ ಗುಡ್ಡದಲ್ಲಿ ಮರಣಹೊಂದಿದಾಗ ಅವನು ನೂರ ಇಪ್ಪತ್ತಮೂರು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ಆಗ ಕಾನಾನ್ ದೇಶದ ನೆಗೆವನಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಕಾನಾನ್ಯನಾದ ಅರಾದ್ ಪಟ್ಟಣದ ಅರಸನು ಇಸ್ರಾಯೇಲರು ಬರುವುದನ್ನು ಕೇಳಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ಹೋರ್ ಗುಡ್ಡದಿಂದ ಅವರು ಹೊರಟು ಚಲ್ಮೋನದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ಚಲ್ಮೋನದಿಂದ ಹೊರಟು ಪೂನೋನಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ಪೂನೋನಿನಿಂದ ಹೊರಟು ಓಬೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ಓಬೋತಿನಿಂದ ಹೊರಟು ಮೋವಾಬಿನ ಮೇರೆಯಲ್ಲಿರುವ ಇಯ್ಯೇ ಅಬಾರೀಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ಇಯೀಮಿನಿಂದ ಹೊರಟು ದೀಬೋನ್ ಗಾದಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ದೀಬೋನ್ ಗಾದಿನಿಂದ ಹೊರಟು ಅಲ್ಮೋನ್ ದಿಬ್ಲಾತಯಿಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ಅಲ್ಮೋನ್ ದಿಬ್ಲಾತಯಿಮಿನಿಂದ ಹೊರಟು ನೆಬೋವಿನ ಪೂರ್ವದಲ್ಲಿರುವ ಅಬಾರೀಮ್ ಬೆಟ್ಟಗಳಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ಅಬಾರೀಮ್ ಬೆಟ್ಟಗಳಿಂದ ಹೊರಟು ಯೆರಿಕೋವಿಗೆ ಎದುರಾಗಿ ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿರುವ ಮೋವಾಬಿನ ಬಯಲುಗಳಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ಅವರು ಯೊರ್ದನ್ ನದಿಯ ಬಳಿಯಲ್ಲಿರುವ ಬೇತ್ ಯೆಷೀಮೋತಿನಿಂದ ಮೋವಾಬಿನ ಬಯಲುಗಳಲ್ಲಿರುವ ಆಬೇಲ್ ಶಿಟ್ಟೀಮಿನ ಪರ್ಯಂತರದವರೆಗೂ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ಯೆಹೋವ ದೇವರು ಯೆರಿಕೋವಿಗೆದುರಾಗಿ ಯೊರ್ದನಿನ ತೀರದಲ್ಲಿರುವ ಮೋವಾಬಿನ ಬಯಲುಗಳಲ್ಲಿ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ: ‘ನೀವು ಯೊರ್ದನನ್ನು ದಾಟಿ, ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಬರುವಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ನಿಮ್ಮ ಮುಂದೆ ಆ ದೇಶದ ಸಮಸ್ತ ನಿವಾಸಿಗಳನ್ನು ಹೊರಡಿಸಿ, ಅವರ ಚಿತ್ರಗಳನ್ನೂ ಅವರು ಕೆತ್ತಿದ ವಿಗ್ರಹಗಳನ್ನೂ ನಾಶಮಾಡಿ, ಅವರ ಸಮಸ್ತ ಪವಿತ್ರ ಸ್ಥಳಗಳನ್ನೂ ಹಾಳುಮಾಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ನೀವು ಆ ದೇಶವನ್ನು ತೆಗೆದುಕೊಂಡು ಅದರಲ್ಲಿ ವಾಸಮಾಡಿರಿ. ಏಕೆಂದರೆ ಅದನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳುವುದಕ್ಕೆ ಆ ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ನೀವು ದೇಶವನ್ನು ನಿಮ್ಮ ಗೋತ್ರಗಳ ಪ್ರಕಾರ ಚೀಟುಹಾಕಿ, ಸ್ವಾಧೀನಮಾಡಿ ಹಂಚಿಕೊಳ್ಳಬೇಕು. ಹೆಚ್ಚಾದವರಿಗೆ ಸೊತ್ತನ್ನು ಹೆಚ್ಚಿಸಿ, ಕಡಿಮೆಯಾದವರಿಗೆ ಸೊತ್ತನ್ನು ಕಡಿಮೆ ಮಾಡಬೇಕು. ಒಬ್ಬೊಬ್ಬನಿಗೆ ಚೀಟು ಎಲ್ಲಿ ಬೀಳುವುದೋ, ಅದೇ ಅವನಿಗಾಗಬೇಕು. ನಿಮ್ಮ ಪಿತೃಗಳ ಗೋತ್ರದ ಪ್ರಕಾರ ನೀವು ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘ಆದರೆ ನೀವು ನಿಮ್ಮ ಮುಂದೆ ದೇಶದ ನಿವಾಸಿಗಳನ್ನು ಹೊರಡಿಸದಿದ್ದರೆ, ನೀವು ಉಳಿಸಿದವರು ನಿಮ್ಮ ಕಣ್ಣುಗಳಲ್ಲಿ ಮುಳ್ಳುಗಳಾಗಿಯೂ, ನಿಮ್ಮ ಪಕ್ಕೆಗಳಲ್ಲಿ ಕಂಟಕಗಳಾಗಿಯೂ ಇರುವರು. ನೀವು ವಾಸಿಸುವ ದೇಶದಲ್ಲಿ ಅವರು ನಿಮ್ಮನ್ನು ಶ್ರಮೆಪಡಿಸುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ಇದಲ್ಲದೆ ನಾನು ಅವರಿಗೆ ಮಾಡಬೇಕೆಂದಿದ್ದ ಹಾಗೆ ನಿಮಗೆ ಮಾಡುವೆನು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಿ, ಅವರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ನೀವು ಕಾನಾನ್ ದೇಶದೊಳಗೆ ಬರುವಾಗ, ನಿಮಗೆ ಸೊತ್ತಾಗಿ ಬರುವ ಕಾನಾನ್ ದೇಶವು ಅದರ ಮೇರೆಗಳ ಪ್ರಕಾರ ಹೀಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘ನಿಮ್ಮ ದಕ್ಷಿಣ ಕಡೆಯು ಚಿನ್ ಮರುಭೂಮಿಯಿಂದ ಎದೋಮಿಗೆ ಅನುಸಾರವಾಗಿರಬೇಕು. ನಿಮ್ಮ ದಕ್ಷಿಣ ಮೇರೆಯು, ಉಪ್ಪಿನ ಸಮುದ್ರದ ಪೂರ್ವದ ಕಡೆಯಿಂದ ಆರಂಭಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ನಿಮ್ಮ ಮೇರೆಯು ದಕ್ಷಿಣದಿಂದ ಅಕ್ರಬ್ಬೀಮ್ ದಿನ್ನೆಗೆ ತಿರುಗಿ, ಚಿನ್‌ಗೆ ಹಾದು, ಕಾದೇಶ್ ಬರ್ನೇಯಕ್ಕೆ ದಕ್ಷಿಣದಲ್ಲಿ ಮುಗಿದು, ಅಲ್ಲಿಂದ ಹಚರದ್ದಾರಿಗೆ ಹೊರಟು, ಅಚ್ಮೋನಿಗೆ ಹಾದು ಹೋಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ಅಚ್ಮೋನಿನಿಂದ ಈಜಿಪ್ಟಿನ ಹಳ್ಳಕ್ಕೆ ತಿರುಗಿ ಸಮುದ್ರ ತೀರದಲ್ಲಿ ಮುಗಿಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","ಪಶ್ಚಿಮದಲ್ಲಿ ದೊಡ್ಡ ಸಮುದ್ರವೇ ನಿಮಗೆ ಮೇರೆಯಾಗಿರಬೇಕು. ಇದೇ ನಿಮ್ಮ ಪಶ್ಚಿಮ ಮೇರೆಯಾಗಿರುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","ನಿಮ್ಮ ಉತ್ತರ ಮೇರೆ ಯಾವುದೆಂದರೆ ನೀವು ದೊಡ್ಡ ಸಮುದ್ರದಿಂದ ಹೋರ್ ಪರ್ವತದವರೆಗೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ಸಾಲು ಮಾಡಿಕೊಂಡು ಹೋರ್ ಪರ್ವತದಿಂದ ನೀವು ಲೆಬೊ ಹಮಾತಿನ ಪ್ರದೇಶದವರೆಗೆ ಸಾಲು ಮಾಡಿರಿ. ಮೇರೆಯು ಚೆದಾದಿಗೆ ಹೊರಟು ");
INSERT INTO kanokcv_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ಜಿಫ್ರೋನಿಗೆ ಹೋಗಿ, ಹಚರ್ ಏನಾನಿನಲ್ಲಿ ಮುಗಿಯಲಿ. ಇದು ನಿಮ್ಮ ಉತ್ತರ ಮೇರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","ಪೂರ್ವದ ಮೇರೆಗೋಸ್ಕರ ಹಚರ್ ಏನಾನಿನಿಂದ ಶೆಫಾಮಿಗೆ ಸಾಲು ಮಾಡಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ಶೆಫಾಮಿನಿಂದ ಮೇರೆ ಆಯಿನಿನ ಪೂರ್ವದಲ್ಲಿರುವ ರಿಬ್ಲಾಕ್ಕೆ ಇಳಿದು, ಕಿನ್ನೆರೆತ್ ಸಮುದ್ರದ ಪೂರ್ವ ತೀರವನ್ನು ಮುಟ್ಟಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ಅಲ್ಲಿಂದ ಮೇರೆಯು ಯೊರ್ದನ್ ನದಿಗೆ ಅನುಸಾರವಾಗಿ ಇಳಿದು, ಉಪ್ಪಿನ ಸಮುದ್ರದಲ್ಲಿ ಮುಗಿಯುವುದು. “ ‘ಇದು ಅದರ ಸುತ್ತಮುತ್ತಲ ಮೇರೆಗಳ ಪ್ರಕಾರ ನಿಮ್ಮ ದೇಶವಾಗಿರಬೇಕು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಿ, “ನೀವು ಚೀಟುಹಾಕಿ ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳಬೇಕಾದ ದೇಶವು ಒಂಬತ್ತುವರೆ ಗೋತ್ರಗಳಿಗೆ ಕೊಡಬೇಕೆಂದು ಯೆಹೋವ ದೇವರು ಆಜ್ಞಾಪಿಸಿದ ದೇಶವು ಇದೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ಏಕೆಂದರೆ ರೂಬೇನ್ಯರ ಮಕ್ಕಳ ಗೋತ್ರವೂ, ಗಾದನ ಮಕ್ಕಳ ಗೋತ್ರವೂ, ಮನಸ್ಸೆಯ ಅರ್ಧ ಗೋತ್ರವೂ ತಮ್ಮ ಪಿತೃಗಳ ಮನೆಯ ಪ್ರಕಾರವಾಗಿ ತಮ್ಮ ಸೊತ್ತನ್ನು ಪಡೆದುಕೊಂಡಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ಎರಡೂವರೆ ಗೋತ್ರಗಳು ತಮ್ಮ ಸೊತ್ತನ್ನು ಯೊರ್ದನಿನ ಈಚೆಯಲ್ಲಿ ಯೆರಿಕೋವಿಗೆ ಸೂರ್ಯನು ಉದಯಿಸುವ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಪಡೆದುಕೊಂಡಿದ್ದಾರೆ,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ದೇಶವನ್ನು ನಿಮಗೆ ಹಂಚಬೇಕಾದ ಜನರ ಹೆಸರುಗಳು ಇವೇ. ಯಾಜಕನಾದ ಎಲಿಯಾಜರನೂ, ನೂನನ ಮಗ ಯೆಹೋಶುವನೂ ");
INSERT INTO kanokcv_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ದೇಶದ ಸೊತ್ತನ್ನು ಹಂಚುವುದಕ್ಕೆ ನೀವು ಒಂದೊಂದು ಗೋತ್ರದಿಂದ ಒಬ್ಬೊಬ್ಬ ಪ್ರಧಾನನನ್ನು ತೆಗೆದುಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“ಈ ಜನರ ಹೆಸರುಗಳು ಇವೇ. “ಯೆಹೂದನ ಕುಟುಂಬದಿಂದ ಯೆಫುನ್ನೆಯ ಮಗ ಕಾಲೇಬನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ಸಿಮೆಯೋನನ ಮಕ್ಕಳ ಗೋತ್ರದಿಂದ ಅಮ್ಮೀಹೂದನ ಮಗ ಶಮುವೇಲನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ಬೆನ್ಯಾಮೀನನ ಗೋತ್ರದಿಂದ ಕಿಸ್ಲೋನನ ಮಗ ಎಲೀದಾದ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ದಾನನ ಮಕ್ಕಳ ಗೋತ್ರದ ಪ್ರಧಾನನು, ಯೊಗ್ಲೀಯ ಮಗ ಬುಕ್ಕೀ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ಯೋಸೇಫನ ಮಕ್ಕಳಾದ ಮನಸ್ಸೆಯ ಗೋತ್ರದ ಪ್ರಧಾನನು ಏಫೋದನ ಮಗ ಹನ್ನೀಯೇಲನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ಎಫ್ರಾಯೀಮ್ ಮಕ್ಕಳ ಗೋತ್ರದ ಪ್ರಧಾನನು ಶಿಫ್ಟಾನನ ಮಗ ಕೆಮೂಯೇಲನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ಜೆಬುಲೂನನ ಮಕ್ಕಳ ಗೋತ್ರದ ಪ್ರಧಾನನು ಪರ್ನಾಕನ ಮಗ ಎಲೀಚಾಫಾನ್, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ಇಸ್ಸಾಕಾರನ ಮಕ್ಕಳ ಗೋತ್ರದ ಪ್ರಧಾನನು ಅಜ್ಜಾನನ ಮಗ ಪಲ್ಟೀಯೇಲನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ಆಶೇರನ ಮಕ್ಕಳ ಗೋತ್ರದ ಪ್ರಧಾನನು ಶೆಲೋಮಿಯ ಮಗ ಅಹೀಹೂದನೂ, ");
INSERT INTO kanokcv_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ನಫ್ತಾಲಿಯ ಮಕ್ಕಳ ಗೋತ್ರದ ಪ್ರಧಾನನು ಅಮ್ಮೀಹೂದನ ಮಗ ಪೆದಹೇಲನೂ.” ");
INSERT INTO kanokcv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಸೊತ್ತನ್ನು ಹಂಚುವುದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ನೇಮಿಸಿದ ಮನುಷ್ಯರು ಇವರೇ. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ಯೆಹೋವ ದೇವರು ಯೆರಿಕೋವಿಗೆ ಎದುರಾಗಿ ಯೊರ್ದನಿನ ಬಳಿಯಲ್ಲಿರುವ ಮೋವಾಬಿನ ಬಯಲುಗಳಲ್ಲಿ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕಾದದ್ದೇನೆಂದರೆ, ಅವರು ತಮ್ಮ ಸ್ವಾಸ್ತ್ಯದ ಭಾಗದಿಂದ ಲೇವಿಯರಿಗೆ ವಾಸಮಾಡುವುದಕ್ಕೆ ಕೆಲವು ಪಟ್ಟಣಗಳನ್ನು ಕೊಡಬೇಕು. ಪಟ್ಟಣಗಳ ಸುತ್ತಮುತ್ತಲಿರುವ ಹುಲ್ಲುಗಾವಲು ಪ್ರದೇಶಗಳನ್ನು ನೀವು ಲೇವಿಯರಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ನಂತರ ಅವರು ವಾಸಮಾಡುವದಕ್ಕೆ ಪಟ್ಟಣಗಳು, ಅವರು ಹೊಂದಿರುವ ಪಶುಗಳಿಗೋಸ್ಕರವೂ ಮತ್ತು ಅವರ ಎಲ್ಲಾ ಇತರ ಪ್ರಾಣಿಗಳಿಗೂ ಹುಲ್ಲುಗಾವಲು ಪ್ರದೇಶಗಳನ್ನು ಹೊಂದಿರುತ್ತಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“ನೀವು ಲೇವಿಯರಿಗೆ ಕೊಡಬೇಕಾದ ಪಟ್ಟಣಗಳ ಉಪನಗರಗಳು, ಪಟ್ಟಣದ ಗೋಡೆಯಿಂದ ಸುತ್ತಲೂ ಸಾವಿರ ಮೊಳ ಅಗಲವಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ನೀವು ಪಟ್ಟಣದ ಹೊರಗೆ ಪೂರ್ವದಲ್ಲಿ ಎರಡು ಸಾವಿರ ಮೊಳ, ದಕ್ಷಿಣದಲ್ಲಿ ಎರಡು ಸಾವಿರ ಮೊಳ, ಪಶ್ಚಿಮದಲ್ಲಿ ಎರಡು ಸಾವಿರ ಮೊಳ, ಉತ್ತರದಲ್ಲಿ ಎರಡು ಸಾವಿರ ಮೊಳ ಅಳೆಯಬೇಕು. ಮಧ್ಯದಲ್ಲಿ ಪಟ್ಟಣವಿರಬೇಕು. ಹೀಗೆ ಅವರ ಪಟ್ಟಣಗಳ ಉಪನಗರಗಳು ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“ನೀವು ಲೇವಿಯರಿಗೆ ಕೊಡುವ ಪಟ್ಟಣಗಳೊಳಗೆ ಮನುಷ್ಯ ಹತ್ಯೆ ಮಾಡಿದವನು ಅಲ್ಲಿಗೆ ಓಡುವ ಹಾಗೆ ಆರು ಆಶ್ರಯದ ಪಟ್ಟಣಗಳನ್ನು ನೇಮಿಸಬೇಕು. ಅವುಗಳ ಹೊರತು ನೀವು ನಲವತ್ತೆರಡು ಪಟ್ಟಣಗಳನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ನೀವು ಲೇವಿಯರಿಗೆ ಕೊಡಬೇಕಾದ ಸಮಸ್ತ ಪಟ್ಟಣಗಳು, ಅವುಗಳ ಉಪನಗರಗಳ ಸಂಗಡ ನಲವತ್ತೆಂಟು ಪಟ್ಟಣಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ನೀವು ಇಸ್ರಾಯೇಲರ ಸ್ವಾಧೀನದಿಂದ ಕೊಡುವ ಪಟ್ಟಣಗಳನ್ನು ಹೆಚ್ಚಾದವರ ಕಡೆಯಿಂದ ಹೆಚ್ಚಾಗಿ, ಕಡಿಮೆಯಾದವರ ಕಡೆಯಿಂದ ಕಡಿಮೆಯಾಗಿ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಒಬ್ಬೊಬ್ಬನು ತಾನು ಹೊಂದುವ ಸೊತ್ತಿಗನುಸಾರವಾಗಿ ತನ್ನ ಪಟ್ಟಣಗಳೊಳಗಿಂದ ಲೇವಿಯರಿಗೆ ಕೊಡಬೇಕು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ಯೆಹೋವ ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ನೀನು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ನೀವು ಯೊರ್ದನನ್ನು ದಾಟಿ, ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಬರುವಾಗ, ");
INSERT INTO kanokcv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ಕೈತಪ್ಪಿ ಒಬ್ಬನನ್ನು ಕೊಂದರೆ, ನೀವು ಓಡಿಹೋಗುವ ಹಾಗೆ ನಿಮಗೆ ಆಶ್ರಯಕ್ಕಾಗಿ ಪಟ್ಟಣಗಳನ್ನು ನೇಮಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ಕೊಂದವನು ಸಭೆಯ ಮುಂದೆ ನ್ಯಾಯತೀರ್ಪಿಗೆ ನಿಲ್ಲುವವರೆಗೂ ಸೇಡು ತೀರಿಸುವವನ ದೆಸೆಯಿಂದ ಸಾಯದಂತೆ ಅವು ನಿಮಗೆ ಆಶ್ರಯದ ಪಟ್ಟಣಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ನೀವು ಕೊಡುವ ಪಟ್ಟಣಗಳೊಳಗೆ ಆರು ಆಶ್ರಯದ ಪಟ್ಟಣಗಳು ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ಯೊರ್ದನಿನ ಈಚೆಯಲ್ಲಿ ಮೂರು ಪಟ್ಟಣಗಳನ್ನು ಮತ್ತು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಮೂರು ಪಟ್ಟಣಗಳನ್ನು ಆಶ್ರಯದ ಪಟ್ಟಣಗಳಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ಕೈತಪ್ಪಿ ಪ್ರಾಣಹತ್ಯೆ ಮಾಡುವವರೆಲ್ಲರೂ, ಅಲ್ಲಿಗೆ ಓಡಿಹೋಗುವುದಕ್ಕೆ ಈ ಆರು ಪಟ್ಟಣಗಳು ಇಸ್ರಾಯೇಲರಿಗೂ, ಪರಕೀಯರಿಗಾಗಿ ಅವರಲ್ಲಿ ವಾಸಮಾಡುವವರಿಗೂ ಆಶ್ರಯಕ್ಕಾಗಿ ಇರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘ಒಬ್ಬನು ಕಬ್ಬಿಣದಿಂದ ಮತ್ತೊಬ್ಬನನ್ನು ಸಾಯುವ ಹಾಗೆ ಹೊಡೆದರೆ, ಅವನು ಕೊಲೆಪಾತಕನು. ಆ ಕೊಲೆಪಾತಕನನ್ನು ನಿಜವಾಗಿಯೂ ಸಾಯಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ಒಬ್ಬನು ಸಾಯುವಂತೆ ಕಲ್ಲನ್ನು ಎಸೆದು ಮತ್ತೊಬ್ಬನನ್ನು ಸಾಯುವ ಹಾಗೆ ಹೊಡೆದರೆ, ಅವನು ಕೊಲೆಪಾತಕನು. ಆ ಕೊಲೆಪಾತಕನನ್ನು ನಿಜವಾಗಿಯೂ ಸಾಯಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","ಇಲ್ಲವೆ ಯಾರಾದರೂ ಮನುಷ್ಯನನ್ನು ಕೊಲ್ಲುವಷ್ಟು ದೊಡ್ಡ ಮರದ ಆಯುಧವನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದು ಮತ್ತೊಬ್ಬನನ್ನು ಹೊಡೆದುಕೊಂದರೆ, ಆ ವ್ಯಕ್ತಿಯು ಕೊಲೆಗಾರ; ಆ ಕೊಲೆಪಾತಕನಿಗೆ ನಿಜವಾಗಿಯೂ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ರಕ್ತಪಾತಕ್ಕೆ ಸೇಡು ತೀರಿಸಿಕೊಳ್ಳುವವನು ಕೊಲೆಪಾತಕನನ್ನು ಕೊಲ್ಲಬೇಕು. ಅವನು ಕೊಲೆಪಾತಕನನ್ನು ನೋಡಿದಾಗ, ಅವನನ್ನೂ ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ಒಬ್ಬನು ಮತ್ತೊಬ್ಬನನ್ನು ಹಗೆಮಾಡಿ ಸಾಯುವ ಹಾಗೆ ಹೊಡೆದರೆ, ಇಲ್ಲವೆ ನೂಕುವುದರಿಂದಲಾದರೂ, ಸಮಯ ನೋಡಿಕೊಂಡು ಅವನ ಮೇಲೆ ಯಾವುದನ್ನಾದರೂ ಬಲವಾಗಿ ಎಸೆದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ಇಲ್ಲವೆ ಹಗೆತನ ಮಾಡಿ ಅವನು ಸಾಯುವ ಹಾಗೆ ತನ್ನ ಕೈಯಿಂದ ಹೊಡೆದರೆ ಅವನು ಕೊಲೆಪಾತಕನೇ, ಹೊಡೆದವನನ್ನು ನಿಜವಾಗಿ ಸಾಯಿಸಬೇಕು. ರಕ್ತಪಾತಕ್ಕೆ ಸೇಡು ತೀರಿಸುವವನು ಅವನನ್ನು ಸಂಧಿಸುವಾಗಲೇ ಆ ಕೊಲೆಪಾತಕನನ್ನು ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘ಆದರೆ ಶತ್ರುತ್ವವಿಲ್ಲದೆ ಆಕಸ್ಮಿಕವಾಗಿ ಅವನನ್ನು ನೂಕುವುದರಿಂದಲಾದರೂ, ಸಮಯ ಸಾಧಿಸದೆ ಯಾವುದಾದರೊಂದು ವಸ್ತುವನ್ನು ಅವನ ಮೇಲೆ ಎಸೆದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ಇಲ್ಲವೆ ಶತ್ರುತ್ವವಿಲ್ಲದೆ ಅವನ ಕೇಡನ್ನು ಹುಡುಕದೆ ಅವನನ್ನು ನೋಡದೆ ಮರಣವಾಗುವಂತೆ ಯಾವುದಾದರೊಂದು ಕಲ್ಲನ್ನು ಅವನು ಸಾಯುವ ಹಾಗೆ ಅವನ ಮೇಲೆ ಬೀಳ ಮಾಡಿದರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ಆಗ ಸಭೆಯು ಈ ನ್ಯಾಯಗಳ ಪ್ರಕಾರ ಕೊಲ್ಲುವವನಿಗೂ, ರಕ್ತಪಾತಕ್ಕೆ ಸೇಡು ತೀರಿಸುವವನಿಗೂ ನ್ಯಾಯತೀರಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ಸಭೆಯು ಕೊಂದವನನ್ನು ರಕ್ತದ ಸೇಡು ತೀರಿಸುವವನ ಕೈಯಿಂದ ತಪ್ಪಿಸಿ, ಅವನು ಓಡಿ ಹೋದ ಆಶ್ರಯದ ಪಟ್ಟಣಕ್ಕೆ ತಿರುಗಿ ಸೇರಿಸಬೇಕು. ಅಲ್ಲೇ ಅವನು ಪರಿಶುದ್ಧ ಎಣ್ಣೆಯಿಂದ ಅಭಿಷೇಕ ಹೊಂದಿದ ಮಹಾಯಾಜಕನು ಸಾಯುವವರೆಗೂ ವಾಸಮಾಡಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘ಆದರೆ ಕೊಲೆಪಾತಕನು ತಾನು ಓಡಿ ಹೋದ ಆಶ್ರಯದ ಪಟ್ಟಣದ ಮೇರೆಯನ್ನು ಯಾವ ಸಮಯದಲ್ಲಾದರೂ ಮೀರಿ ಹೊರಟರೆ, ");
INSERT INTO kanokcv_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ರಕ್ತಕ್ಕೆ ಸೇಡು ತೀರಿಸುವವನು ಅವನನ್ನು ತನ್ನ ಆಶ್ರಯದ ಪಟ್ಟಣದ ಮೇರೆಯ ಹೊರಗೆ ಕಂಡುಕೊಂಡು ಕೊಲೆಪಾತಕನನ್ನು ಕೊಂದರೆ, ಅವನಿಗೆ ರಕ್ತಾಪರಾಧವಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ಏಕೆಂದರೆ ಅವನು ತನ್ನ ಆಶ್ರಯದ ಪಟ್ಟಣದ ಮಹಾಯಾಜಕನು ಸಾಯುವವರೆಗೂ ವಾಸಮಾಡಬೇಕಾಗಿತ್ತು. ಮಹಾಯಾಜಕನ ಮರಣದ ತರುವಾಯ ಕೊಲೆಪಾತಕನು ತನ್ನ ಸೊತ್ತಿರುವ ದೇಶಕ್ಕೆ ಹೋಗಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘ಹೀಗೆ ಇವು ನಿಮ್ಮ ಸಮಸ್ತ ನಿವಾಸಿಗಳಲ್ಲಿ ನಿಮ್ಮ ಸಂತತಿಗಳಿಗೆಲ್ಲಾ ನ್ಯಾಯದ ಕಟ್ಟಳೆಯಾಗಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘ಪ್ರಾಣಹತ್ಯೆ ಮಾಡಿದ ಕೊಲೆಪಾತಕನನ್ನು ಸಾಕ್ಷಿಗಳನ್ನು ವಿಚಾರಿಸಿಕೊಂಡೇ ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯನ್ನು ವಿಧಿಸಬೇಕು. ಒಬ್ಬನೇ ಸಾಕ್ಷಿಯು ಒಂದು ಪ್ರಾಣಕ್ಕೆ ವಿರೋಧವಾಗಿ ಸಾಯುವ ಹಾಗೆ ಸಾಕ್ಷಿ ಕೊಡಬಾರದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘ಸಾಯತಕ್ಕ ಕೊಲೆಪಾತಕನ ಪ್ರಾಣಕ್ಕೋಸ್ಕರ ಈಡನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಡಿರಿ. ಏಕೆಂದರೆ ಅವನು ನಿಜವಾಗಿಯೂ ಸಾಯಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘ತನ್ನ ಆಶ್ರಯದ ಪಟ್ಟಣಕ್ಕೆ ಓಡಿಹೋದವನಿಗೋಸ್ಕರ ಅವನು ತಿರುಗಿಬಂದು ಮಹಾಯಾಜಕನು ಸಾಯುವವರೆಗೂ ಸ್ವದೇಶದಲ್ಲಿ ವಾಸಮಾಡುವ ಹಾಗೆ ಈಡನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘ಹೀಗೆ ನೀವು ವಾಸಿಸುವ ದೇಶವನ್ನು ನೀವು ಅಪವಿತ್ರ ಮಾಡಬೇಡಿರಿ. ಏಕೆಂದರೆ ದೇಶವನ್ನು ಅಪವಿತ್ರ ಮಾಡುವಂಥಾದ್ದು ರಕ್ತವೇ. ಹತರಾದವರ ರಕ್ತಕ್ಕಾಗಿ ಕೊಂದವನ ರಕ್ತದಿಂದಲೇ ಹೊರತು ಬೇರೆ ಪ್ರಾಯಶ್ಚಿತ್ತವಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ಆದ್ದರಿಂದ ನೀವು ವಾಸಮಾಡುವ ದೇಶವನ್ನು ನೀವು ಅಶುದ್ಧ ಮಾಡಬೇಡಿರಿ. ಏಕೆಂದರೆ ನಾನು ಅದರೊಳಗೆ ವಾಸಿಸುತ್ತೇನೆ. ಯೆಹೋವ ದೇವರಾಗಿರುವ ನಾನೇ ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುತ್ತೇನೆ,’ ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ಆಗ ಯೋಸೇಫನ ಪುತ್ರರ ಕುಟುಂಬದವರಾದ ಮನಸ್ಸೆಯ ಮಗನಾಗಿರುವ ಮಾಕೀರನ ಮಗನಾದ ಗಿಲ್ಯಾದನ ಮಕ್ಕಳ ಕುಟುಂಬಗಳ ಮುಖ್ಯಸ್ಥರು ಮೋಶೆ ಹಾಗೂ ಇಸ್ರಾಯೇಲರ ಕುಲನಾಯಕರ ಸಮೀಪಕ್ಕೆ ಬಂದು ಮಾತನಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“ಚೀಟುಹಾಕಿ ನಾಡನ್ನು ಇಸ್ರಾಯೇಲರಿಗೆ ಸೊತ್ತಾಗಿ ಕೊಡುವುದಕ್ಕೆ ಯೆಹೋವ ದೇವರು ನಮ್ಮ ಒಡೆಯನಾದ ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದರು. ನಮ್ಮ ಸಹೋದರನಾದ ಚಲ್ಪಹಾದನ ಸೊತ್ತನ್ನು ಅವನ ಪುತ್ರಿಯರಿಗೆ ಕೊಡಬೇಕೆಂದು ದೇವರಿಂದ ಅಪ್ಪಣೆಯಾಗಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ಆದರೆ ಅವರು ಇಸ್ರಾಯೇಲರ ಬೇರೆ ಗೋತ್ರದವರಿಗೆ ಮದುವೆಯಾದರೆ, ಅವರ ಸೊತ್ತು ಅಂದರೆ, ನಮ್ಮ ಪಿತೃಗಳ ಸೊತ್ತಿನಿಂದ ಅವರನ್ನು ಮದುವೆಮಾಡಿಕೊಂಡ ಗೋತ್ರದವರಿಗೆ ಸೊತ್ತು ಹೋಗುತ್ತದೆ. ಇದರಿಂದ ನಮ್ಮ ಸೊತ್ತಿನ ಭಾಗ ಕಡಿಮೆಯಾಗಿ ಹೋಗುವುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ಇಸ್ರಾಯೇಲರಿಗೆ ಜೂಬಿಲಿ ವರ್ಷ ಬಂದಾಗ ಅವರ ಸೊತ್ತು ಅವರು ಸೇರಿಕೊಳ್ಳುವ ಗೋತ್ರಕ್ಕೆ ಸೇರಿಕೊಳ್ಳುತ್ತದೆ. ಹೀಗೆ ಅವರ ಸೊತ್ತು ಅಂದರೆ, ನಮ್ಮ ಪಿತೃಗಳ ಗೋತ್ರದ ಸೊತ್ತಿನಿಂದ ತೆಗೆಯಲಾಗುವುದು.” ");
INSERT INTO kanokcv_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ಆಗ ಮೋಶೆಯು ಯೆಹೋವ ದೇವರ ಆಜ್ಞೆಯಂತೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಿ, “ಯೋಸೇಫನ ಪುತ್ರರ ಗೋತ್ರದವರು ಸರಿಯಾಗಿ ಮಾತನಾಡುತ್ತಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ಯೆಹೋವ ದೇವರು ಚಲ್ಪಹಾದನ ಪುತ್ರಿಯರ ವಿಷಯದಲ್ಲಿ ಆಜ್ಞಾಪಿಸಿದ ಮಾತು ಏನೆಂದರೆ: ಅವರು ತಮ್ಮ ಮನಸ್ಸು ಬಂದವರೊಂದಿಗೆ ಮದುವೆಮಾಡಿಕೊಳ್ಳಲಿ, ಆದರೆ ತಮ್ಮ ತಂದೆಯ ಕುಟುಂಬದ ಗೋತ್ರದವರಿಗೆ ಮಾತ್ರ ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ಇಸ್ರಾಯೇಲರ ಸೊತ್ತು ಒಂದು ಗೋತ್ರದಿಂದ ಮತ್ತೊಂದು ಗೋತ್ರದ ಕೈಗೆ ಹೋಗಬಾರದು. ಏಕೆಂದರೆ ಇಸ್ರಾಯೇಲರು, ಒಬ್ಬೊಬ್ಬನು ತನ್ನ ಪಿತೃಗಳ ಗೋತ್ರದ ಸೊತ್ತನ್ನು ತಾನೇ ಹೊಂದಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ಇದಕ್ಕಾಗಿ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಒಬ್ಬೊಬ್ಬನು ತನ್ನ ಪಿತೃಗಳ ಸೊತ್ತನ್ನು ಸ್ವಾಧೀನ ಮಾಡಿಕೊಳ್ಳುವಂತೆ ಇಸ್ರಾಯೇಲರ ಗೋತ್ರಗಳೊಳಗೆ ಸೊತ್ತನ್ನು ಹೊಂದಿರುವ ಒಬ್ಬೊಬ್ಬ ಪುತ್ರಿಯು ತನ್ನ ಪಿತೃವಿನ ಕುಟುಂಬದ ಗೋತ್ರದಲ್ಲಿರುವವನೊಂದಿಗೇ ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ಒಂದು ಸೊತ್ತು ಒಂದು ಗೋತ್ರದಿಂದ ಮತ್ತೊಂದು ಗೋತ್ರಕ್ಕೆ ಹಸ್ತಾಂತರಗೊಳ್ಳಬಾರದು ಆದರೆ ಇಸ್ರಾಯೇಲರ ಗೋತ್ರಗಳಲ್ಲಿ ಒಬ್ಬೊಬ್ಬನು ತನ್ನ ಸೊತ್ತಿಗೆ ತಾನೇ ಹೊಂದಿಕೊಳ್ಳಬೇಕು,” ಎಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ಯೆಹೋವ ದೇವರು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಚಲ್ಪಹಾದನ ಪುತ್ರಿಯರು ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ಚಲ್ಪಹಾದನ ಪುತ್ರಿಯರಾದ ಮಹ್ಲಾ, ತಿರ್ಚಾ, ಹೊಗ್ಲಾ, ಮಿಲ್ಕಾ, ನೋವಾ, ತಮ್ಮ ಚಿಕ್ಕಪ್ಪಂದಿರ ಪುತ್ರರನ್ನು ಮದುವೆಯಾದರು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ಯೋಸೇಫನ ಮಗನಾದ ಮನಸ್ಸೆಯ ಪುತ್ರರ ಕುಟುಂಬದವರೊಡನೆ ಮದುವೆಯಾದರು. ಈ ಪ್ರಕಾರ ಅವರ ಸೊತ್ತು ತಮ್ಮ ಪಿತೃವಿನ ಗೋತ್ರದಲ್ಲಿಯೇ ಉಳಿಯಿತು. ");
INSERT INTO kanokcv_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ಯೆಹೋವ ದೇವರು ಯೆರಿಕೋವಿಗೆದುರಾಗಿ ಯೊರ್ದನಿನ ತೀರದಲ್ಲಿರುವ ಮೋವಾಬಿನ ಬಯಲುಗಳಲ್ಲಿ ಮೋಶೆಯ ಮೂಲಕವಾಗಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ ಆಜ್ಞೆಗಳೂ, ನ್ಯಾಯಗಳೂ ಇವೇ.");
INSERT INTO kanokcv_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ಯೊರ್ದನ್ ನದಿಯ ಆಚೆ ಪಾರಾನ್, ತೋಫೆಲ್, ಲಾಬಾನ್, ಹಚೇರೋತ್, ದೀಜಾಹಾಬ್ ಎಂಬ ಊರುಗಳ ನಡುವೆ, ಮರುಭೂಮಿಯಲ್ಲಿ ಅರಾಬಾ ಎಂಬ ತಗ್ಗಾದ ಪ್ರದೇಶದಲ್ಲಿ ಸೂಫಿಗೆ ಎದುರಾಗಿ, ಮೋಶೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಿದ ಮಾತುಗಳು ಇವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ಹೋರೇಬಿನಿಂದ ಕಾದೇಶ್ ಬರ್ನೇಯಕ್ಕೆ ಸೇಯೀರ್ ಬೆಟ್ಟದ ಮಾರ್ಗವಾಗಿ ಹನ್ನೊಂದು ದಿವಸ ಪ್ರಯಾಣ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ನಲ್ವತ್ತನೆಯ ವರ್ಷದಲ್ಲಿ ಹನ್ನೊಂದನೇ ತಿಂಗಳಿನ ಮೊದಲನೇ ದಿನದಲ್ಲಿ, ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ, ಯೆಹೋವ ದೇವರು ಅವನಿಗೆ ಅವರ ವಿಷಯವಾಗಿ ಆಜ್ಞಾಪಿಸಿದ್ದೆಲ್ಲದರ ಪ್ರಕಾರ ಮಾತನಾಡಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ಅವನು ಹೆಷ್ಬೋನಿನಲ್ಲಿ ವಾಸಮಾಡಿದ ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನನ್ನು ಸೋಲಿಸಿದ ಮೇಲೆಯೂ, ಅಷ್ಟಾರೋತ್‌ನಲ್ಲಿ, ವಾಸಮಾಡಿದ ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನನ್ನೂ ಎದ್ರೈಯಲ್ಲಿ ಸೋಲಿಸಿದ ಮೇಲೆಯೂ ಮೋಶೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಈ ಮಾತುಗಳನ್ನು ತಿಳಿಸಿದನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ಯೊರ್ದನ್ ನದಿಯ ಆಚೆ ಮೋವಾಬ್ಯರ ದೇಶದಲ್ಲಿ ಮೋಶೆ ಈ ನಿಯಮವನ್ನು ವಿವರಿಸುವುದಕ್ಕೆ ಪ್ರಾರಂಭಿಸಿದನು: ");
INSERT INTO kanokcv_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಹೋರೇಬಿನಲ್ಲಿ ನಮಗೆ, “ನೀವು ಈ ಬೆಟ್ಟದಲ್ಲಿ ವಾಸಮಾಡಿದ್ದು ಸಾಕು, ");
INSERT INTO kanokcv_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ತಿರುಗಿಕೊಂಡು ಹೊರಟು ಅಮೋರಿಯರ ಬೆಟ್ಟಕ್ಕೂ, ಅದರ ಅರಾಬಾ ಸಮೀಪದ ಎಲ್ಲಾ ಪ್ರದೇಶದ ಗುಡ್ಡದಲ್ಲಿಯೂ ತಗ್ಗಿನಲ್ಲಿಯೂ ನೆಗೆವನಲ್ಲಿಯೂ ಸಮುದ್ರ ತೀರದಲ್ಲಿಯೂ ಇರುವ ಎಲ್ಲಾ ಸ್ಥಳಗಳಿಗೂ ಕಾನಾನ್ಯರ ದೇಶಕ್ಕೂ, ಲೆಬನೋನಿಗೂ ಯೂಫ್ರೇಟೀಸ್ ಎಂಬ ಮಹಾನದಿಯ ಬಳಿಗೂ ಹೋಗಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ಆ ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ನೀವು ಹೋಗಿ ಯೆಹೋವ ದೇವರಾದ ನಾನು ನಿಮ್ಮ ಪಿತೃಗಳಾದ ಅಬ್ರಹಾಮನಿಗೂ ಇಸಾಕನಿಗೂ ಯಾಕೋಬನಿಗೂ ಅವರ ತರುವಾಯ ಹುಟ್ಟುವ ಅವರ ಸಂತತಿಗೂ ಕೊಡುತ್ತೇನೆಂದು ಪ್ರಮಾಣ ಮಾಡಿದ ದೇಶವನ್ನು ಸ್ವತಂತ್ರಿಸಿಕೊಳ್ಳಿರಿ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ಆ ಕಾಲದಲ್ಲಿ ನಾನು ನಿಮಗೆ, “ನಾನೊಬ್ಬನೇ ನಿಮ್ಮ ಭಾರವನ್ನು ಹೊರಲಾರೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮನ್ನು ಹೆಚ್ಚಿಸಿದ್ದಾರೆ. ನೀವು ಈ ಹೊತ್ತು ಆಕಾಶದ ನಕ್ಷತ್ರಗಳ ಹಾಗೆ ಹೆಚ್ಚಾಗಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ನೀವು ಈಗ ಇರುವುದಕ್ಕಿಂತ ಇನ್ನೂ ಸಾವಿರದಷ್ಟಾಗುವಂತೆ ನಿಮ್ಮ ಪಿತೃಗಳ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮನ್ನು ಹೆಚ್ಚಿಸಲಿ, ಅವರು ವಾಗ್ದಾನ ಮಾಡಿದ ಪ್ರಕಾರ ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ಆದರೆ ನಿಮ್ಮ ಸಮಸ್ಯೆಗಳನ್ನೂ ಹೊಣೆಯನ್ನೂ ವ್ಯಾಜ್ಯಗಳನ್ನೂ ನಾನೊಬ್ಬನೇ ಸಹಿಸುವುದು ಹೇಗೆ? ");
INSERT INTO kanokcv_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ಆದ್ದರಿಂದ ನೀವು ಪ್ರತಿಯೊಂದು ಗೋತ್ರದಿಂದ ಜ್ಞಾನಿಗಳೂ ವಿವೇಕಿಗಳೂ ಪ್ರಖ್ಯಾತರೂ ಆದ ವ್ಯಕ್ತಿಗಳನ್ನು ಆರಿಸಿಕೊಳ್ಳಿರಿ. ನಾನು ಅವರನ್ನು ನಿಮಗೆ ಅಧಿಪತಿಗಳಾಗಿ ನೇಮಿಸುತ್ತೇನೆ,” ಎಂದು ಹೇಳಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ಅದಕ್ಕೆ ನೀವು ನನಗೆ ಉತ್ತರವಾಗಿ, “ನೀನು ಹೇಳಿದ ಮಾತು ಮಾಡುವುದಕ್ಕೆ ಒಳ್ಳೆಯದು,” ಎಂದಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ಆಗ ನಾನು ನಿಮ್ಮಲ್ಲಿ ಪ್ರಸಿದ್ಧರಾದ ಜ್ಞಾನಿಗಳನ್ನು ಕರೆಯಿಸಿ, ಒಂದೊಂದು ಗೋತ್ರದಲ್ಲಿ ಸಾವಿರ ಮಂದಿಯ ಮೇಲೆ, ನೂರು ಮಂದಿಯ ಮೇಲೆ, ಐವತ್ತು ಮಂದಿಯ ಮೇಲೆ, ಹತ್ತು ಮಂದಿಯ ಮೇಲೆ ಅಧಿಕಾರಿಗಳನ್ನಾಗಿ ನೇಮಿಸಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","ಆ ನ್ಯಾಯಾಧಿಪತಿಗಳಿಗೆ ಆ ಕಾಲದಲ್ಲಿ ನಾನು, “ನಿಮ್ಮ ಸಹೋದರರು ತಮ್ಮಲ್ಲಿ ಮಾಡುವ ವ್ಯಾಜ್ಯಗಳನ್ನು ವಿಚಾರಿಸಬೇಕು. ಅದು ಇಸ್ರಾಯೇಲರ ವ್ಯಾಜ್ಯವಾಗಿರಬಹುದು. ಇಸ್ರಾಯೇಲರಲ್ಲದವರ ವ್ಯಾಜ್ಯವಾಗಿರಬಹುದು. ಎಲ್ಲವನ್ನು ನೀವು ನ್ಯಾಯದ ಪ್ರಕಾರವೇ ತೀರ್ಮಾನಿಸಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ನ್ಯಾಯದಲ್ಲಿ ನೀವು ಮುಖದಾಕ್ಷಿಣ್ಯ ಮಾಡಬೇಡಿರಿ. ಹಿರಿಯನನ್ನು ಹೇಗೋ ಹಾಗೆಯೇ ಕಿರಿಯನನ್ನು ಕೇಳಬೇಕು. ಯಾವ ಮನುಷ್ಯನಿಗೂ ಹೆದರಬೇಡಿರಿ. ಆದರೆ ನ್ಯಾಯ ತೀರ್ವಿಕೆಯು ದೇವರದೇ. ನಿಮಗೆ ಕಠಿಣವಾದ ವ್ಯಾಜ್ಯಗಳನ್ನು ನನ್ನ ಮುಂದೆ ತನ್ನಿರಿ, ನಾನು ಅದನ್ನು ತೀರಿಸುವೆನು,” ಎಂದು ಹೇಳಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ಹೀಗೆ ನೀವು ಮಾಡತಕ್ಕ ಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ಆ ಕಾಲದಲ್ಲಿ ನಿಮಗೆ ಆಜ್ಞಾಪಿಸಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ಆಗ ನಾವು ಹೋರೇಬಿನಿಂದ ಹೊರಟು ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ, ನೀವು ಅಮೋರಿಯರ ಬೆಟ್ಟದ ಮಾರ್ಗದಲ್ಲಿ ನೋಡಿದ ಆ ದೊಡ್ಡ ಭಯಂಕರವಾದ ಮರುಭೂಮಿಯನ್ನೆಲ್ಲಾ ದಾಟಿ, ಕಾದೇಶ್ ಬರ್ನೇಯಕ್ಕೆ ಬಂದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ಆಗ ನಾನು ನಿಮಗೆ, “ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಕೊಡುವ ಅಮೋರಿಯರ ಮಲೆನಾಡಿಗೆ ಹತ್ತಿರ ಬಂದಿದ್ದೀರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಟ್ಟಿದ್ದಾರೆ, ನಿಮ್ಮ ಪಿತೃಗಳ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ಹೇಳಿದ ಪ್ರಕಾರ ಅದನ್ನು ಏರಿ ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳಿರಿ. ಭಯಪಡಬೇಡಿರಿ, ಧೈರ್ಯವಾಗಿರಿ,” ಎಂದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ಆಗ ನೀವೆಲ್ಲರು ನನ್ನ ಬಳಿಗೆ ಬಂದು, “ನಮಗಿಂತ ಮುಂದಾಗಿ ಜನರನ್ನು ಕಳುಹಿಸೋಣ. ಅವರು ನಮಗೆ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿ, ನಾವು ಮೇಲೆ ಹೋಗತಕ್ಕ ಮಾರ್ಗದ ವಿಷಯದಲ್ಲಿಯೂ ನಾವು ಪ್ರವೇಶಿಸುವ ಪಟ್ಟಣಗಳ ವಿಷಯದಲ್ಲಿಯೂ ನಮಗೆ ಸಮಾಚಾರವನ್ನು ತರಲಿ,” ಎಂದು ಹೇಳಿದಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ಆ ಮಾತು ನನಗೆ ಒಳ್ಳೆಯದೆಂದು ತೋಚಿತು. ನಾನು ನಿಮ್ಮಲ್ಲಿ ಗೋತ್ರಕ್ಕೆ ಒಬ್ಬನ ಪ್ರಕಾರ ಹನ್ನೆರಡು ಮಂದಿಯನ್ನು ಆರಿಸಿಕೊಂಡೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ಅವರು ಹೋಗಿ ಬೆಟ್ಟವನ್ನೇರಿ, ಎಷ್ಕೋಲೆಂಬ ಹಳ್ಳದ ಬಳಿಗೆ ಬಂದು, ಅದನ್ನು ಸಂಚರಿಸಿ ನೋಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ಆ ದೇಶದ ಫಲದಲ್ಲಿ ಕೆಲವನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು, ನಮ್ಮ ಬಳಿಗೆ ತಂದು ತೋರಿಸಿ, “ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಕೊಡುವ ದೇಶವು ಒಳ್ಳೆಯದು,” ಎಂದು ವರದಿಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","ಆದರೆ ನೀವು ಮೇಲೆ ಹತ್ತಿ ಹೋಗುವುದಕ್ಕೆ ಮನಸ್ಸಿಲ್ಲದೆ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರ ಅಪ್ಪಣೆಗೆ ತಿರುಗಿಬಿದ್ದಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ನೀವು ನಿಮ್ಮ ಗುಡಾರಗಳಲ್ಲಿ ಗೊಣಗುಟ್ಟಿ, “ಯೆಹೋವ ದೇವರು ನಮ್ಮನ್ನು ಹಗೆ ಮಾಡಿದ್ದರಿಂದ, ನಮ್ಮನ್ನು ಅಮೋರಿಯರ ಕೈಗೆ ಒಪ್ಪಿಸಿ, ನಮ್ಮನ್ನು ನಾಶಮಾಡುವುದಕ್ಕೆ ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ನಾವು ಎಲ್ಲಿಗೆ ಏರಿಹೋಗೋಣ? ನಮ್ಮ ಸಹೋದರರು, ‘ಆ ಜನರು ನಮಗಿಂತ ಬಲಿಷ್ಠರೂ ಎತ್ತರವಾದವರೂ ಪಟ್ಟಣಗಳು ದೊಡ್ಡವೂ, ಆಕಾಶವನ್ನು ಮುಟ್ಟುವ ಗೋಡೆಯುಳ್ಳವುಗಳೂ ಆಗಿವೆ. ಇದಲ್ಲದೆ ರಾಕ್ಷಸಾಕಾರದ ಅನಾಕ್ಯರ ಮಕ್ಕಳನ್ನು ಅಲ್ಲಿ ನೋಡಿದೆವು’ ಎಂದು ಹೇಳಿ ನಮ್ಮ ಹೃದಯಗಳನ್ನು ಅಧೈರ್ಯಪಡಿಸಿದ್ದಾರೆ,” ಎಂದು ಹೇಳಿದಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","ಆಗ ನಾನು ನಿಮಗೆ, “ಅಂಜಬೇಡಿರಿ, ಅವರಿಗೆ ಭಯಪಡಬೇಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ನಿಮ್ಮ ಮುಂದೆ ಹೋಗುವ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಈಜಿಪ್ಟಿನಲ್ಲಿಯೂ ಮರುಭೂಮಿಯಲ್ಲಿಯೂ ನಿಮ್ಮ ಕಣ್ಣು ಮುಂದೆ, ಯುದ್ಧಮಾಡಿದಂತೆಯೇ ಈಗಲೂ ನಿಮಗೋಸ್ಕರ ಯುದ್ಧಮಾಡುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ನೀವು ಈ ಸ್ಥಳಕ್ಕೆ ಸೇರುವ ತನಕ ನಿಮ್ಮ ಪ್ರಯಾಣದಲ್ಲೆಲ್ಲಾ ಒಬ್ಬ ತಂದೆ ತನ್ನ ಮಗನನ್ನು ಹೇಗೆ ಹೊರುತ್ತಾನೋ ಹಾಗೆಯೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮನ್ನು ಹೊತ್ತು ತಂದರಲ್ಲವೇ?” ಎಂದು ನಿಮಗೆ ಹೇಳಿದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ಆದರೆ ಈ ಕಾರ್ಯದಲ್ಲಿ ನೀವು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರನ್ನು ನಂಬಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ಅವರೇ ನಿಮಗೆ ಇಳಿದುಕೊಳ್ಳುವುದಕ್ಕೆ ಸ್ಥಳವನ್ನು ಗೊತ್ತುಮಾಡಿ ನೀವು ಹೋಗತಕ್ಕ ಮಾರ್ಗವನ್ನು ನಿಮಗೆ ತೋರಿಸಲು ರಾತ್ರಿ ಹೊತ್ತು ಬೆಂಕಿಯಲ್ಲಿಯೂ ಹಗಲು ಹೊತ್ತು ಮೇಘದಲ್ಲಿಯೂ ನಿಮ್ಮ ಮುಂದೆ ಹೋದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ಮಾತುಗಳನ್ನು ಕೇಳಿ, ಬೇಸರಗೊಂಡು, ಪ್ರಮಾಣಮಾಡಿ, ");
INSERT INTO kanokcv_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“ಕೆಟ್ಟ ಸಂತತಿಯಾದ ಈ ಮನುಷ್ಯರಲ್ಲಿ ಒಬ್ಬನಾದರೂ ನಾನು ನಿಮ್ಮ ಪಿತೃಗಳಿಗೆ ಕೊಡುತ್ತೇನೆಂದು ಪ್ರಮಾಣ ಮಾಡಿದ ಒಳ್ಳೆಯ ದೇಶವನ್ನು ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ಯೆಫುನ್ನೆಯ ಮಗ ಕಾಲೇಬನು ಮಾತ್ರ ಅದನ್ನು ನೋಡುವನು. ಅವನು ಯೆಹೋವ ದೇವರನ್ನು ಪೂರ್ಣವಾಗಿ ಹಿಂಬಾಲಿಸಿದ್ದರಿಂದ, ಅವನು ಸಂದರ್ಶಿಸಿದ ದೇಶವನ್ನು ಅವನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ ಕೊಡುವೆನು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","ನನ್ನ ಮೇಲೆಯೂ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ವಿಷಯವಾಗಿ ಬೇಸರಮಾಡಿಕೊಂಡು, “ನೀನು ಸಹ ಅದರಲ್ಲಿ ಪ್ರವೇಶಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ಆದರೆ ನಿನ್ನ ಮುಂದೆ ನಿಂತಿರುವ ನೂನನ ಮಗ ಯೆಹೋಶುವನು ಅಲ್ಲಿಗೆ ಸೇರುವನು. ಅವನನ್ನು ಧೈರ್ಯಗೊಳಿಸು. ಅವನೇ ಆ ನಾಡನ್ನು ಇಸ್ರಾಯೇಲಿಗೆ ಸ್ವಾಧೀನಪಡಿಸುವನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ಇದಲ್ಲದೆ ಸೆರೆಯಾಗಿ ಹೋಗುವರೆಂದು ನೀವು ಹೇಳಿದ ನಿಮ್ಮ ಚಿಕ್ಕವರೂ ಈ ಹೊತ್ತು ಒಳ್ಳೆಯದು, ಕೆಟ್ಟದ್ದು ಅರಿಯದ ನಿಮ್ಮ ಮಕ್ಕಳು ಅದರಲ್ಲಿ ಪ್ರವೇಶಿಸುವರು. ನಾನು ಅವರಿಗೆ ಅದನ್ನು ಕೊಡುವೆನು, ಅವರು ಅದನ್ನು ಸ್ವತಂತ್ರಿಸಿಕೊಳ್ಳುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ನೀವಾದರೋ ತಿರುಗಿಕೊಂಡು ಕೆಂಪು ಸಮುದ್ರ ಮಾರ್ಗವಾಗಿ ಮರುಭೂಮಿಗೆ ಹೊರಟು ಹೋಗಿರಿ,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ಆಗ ನೀವು ಉತ್ತರಕೊಟ್ಟು ನನಗೆ, “ಯೆಹೋವ ದೇವರಿಗೆ ಪಾಪಮಾಡಿದ್ದೇವೆ. ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೆಲ್ಲದರ ಪ್ರಕಾರ ನಾವು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಯುದ್ಧ ಮಾಡುತ್ತೇವೆ. ನೀವೆಲ್ಲರು ನಿಮ್ಮ ಯುದ್ಧದ ಆಯುಧಗಳನ್ನು ಕಟ್ಟಿಕೊಂಡ ಮೇಲೆ ಬೆಟ್ಟಕ್ಕೆ ಹೊರಟುಹೋಗುವುದು ಸಣ್ಣ ಕೆಲಸ,” ಎಂದು ಹೇಳಿದಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ಆದರೆ ಯೆಹೋವ ದೇವರು ನನಗೆ, “ ‘ಏರಿ ಹೋಗಬೇಡಿರಿ, ಯುದ್ಧಮಾಡಬೇಡಿರಿ. ಏಕೆಂದರೆ ನಾನು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಇಲ್ಲ. ನೀವು ನಿಮ್ಮ ಶತ್ರುಗಳಿಂದ ಸೋಲನ್ನು ಅನುಭವಿಸುವಿರಿ,’ ಎಂದು ಅವರಿಗೆ ಹೇಳು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ಇದನ್ನು ನಾನು ನಿಮಗೆ ಹೇಳಲಾಗಿ ನೀವು ಕೇಳದೆ, ಯೆಹೋವ ದೇವರ ಅಪ್ಪಣೆಗೆ ತಿರುಗಿಬಿದ್ದು, ಗರ್ವದಿಂದ ಧೈರ್ಯಮಾಡಿ ಬೆಟ್ಟವನ್ನೇರಿದಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ಆಗ ಆ ಬೆಟ್ಟದಲ್ಲಿ ವಾಸಮಾಡುತ್ತಿದ್ದ ಅಮೋರಿಯರು ನಿಮಗೆ ವಿರುದ್ಧವಾಗಿ ಹೊರಟು, ಜೇನುಹುಳಗಳು ಮುತ್ತಿದಂತೆ ನಿಮ್ಮ ಬೆನ್ನು ಹತ್ತಿ, ಸೇಯೀರಿನಲ್ಲಿ ಹೊರ್ಮಾದವರೆಗೂ ನಿಮ್ಮನ್ನು ಸಂಹಾರ ಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ನೀವು ತಿರುಗಿಕೊಂಡು ಯೆಹೋವ ದೇವರ ಮುಂದೆ ಅತ್ತಿರಿ. ಆದರೆ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ಧ್ವನಿಗೆ ಕಿವಿಗೊಡಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ಆಮೇಲೆ ನೀವು ಕಾದೇಶಿನಲ್ಲಿ ಬಹಳ ದಿವಸ ವಾಸವಾಗಿದ್ದಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ಆಗ ಯೆಹೋವ ದೇವರು ನನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಮರುಭೂಮಿಗೆ ಹೊರಟು ಕೆಂಪುಸಮುದ್ರದ ಮಾರ್ಗದಲ್ಲಿ ಅನೇಕ ದಿನಗಳು ಸೇಯೀರ್ ಬೆಟ್ಟದ ಮಲೆನಾಡನ್ನು ಸುತ್ತುತ್ತಿದ್ದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ಆಮೇಲೆ ಯೆಹೋವ ದೇವರು ನನಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“ನೀವು ಈ ಬೆಟ್ಟವನ್ನು ಸುತ್ತಿದ್ದು ಸಾಕು. ಉತ್ತರಕ್ಕೆ ತಿರುಗಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ನೀವು ಜನರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ನೀವು ಸೇಯೀರಿನಲ್ಲಿ ವಾಸಮಾಡುವ ನಿಮ್ಮ ಸಹೋದರರಾದ ಏಸಾವನ ಪುತ್ರರ ಗಡಿಯನ್ನು ದಾಟಬೇಕು. ಅವರು ನಿಮಗೆ ಭಯಪಡುವರು. ಆದ್ದರಿಂದ ನೀವು ಬಹಳ ಜಾಗ್ರತೆಯಿಂದಿರಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ಅವರನ್ನು ಯುದ್ಧಕ್ಕೆ ಪ್ರಚೋದಿಸಬೇಡಿರಿ. ನಾನು ನಿಮಗೆ ಅವರ ದೇಶದಲ್ಲಿ ಪಾದವಿಡುವಷ್ಟು ಸ್ಥಳವನ್ನಾದರೂ ಕೊಡುವುದಿಲ್ಲ. ಏಕೆಂದರೆ ಸೇಯೀರ್ ಬೆಟ್ಟವನ್ನು ನಾನು ಏಸಾವನಿಗೆ ಸ್ವದೇಶವಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ನೀವು ಅಲ್ಲಿ ಉಣ್ಣುವ ಆಹಾರವನ್ನು ಮತ್ತು ಕುಡಿಯುವ ನೀರನ್ನು ಸಹ ಹಣಕೊಟ್ಟು ಕೊಂಡುಕೊಳ್ಳಬೇಕು.’ ” ");
INSERT INTO kanokcv_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ಏಕೆಂದರೆ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ಎಲ್ಲಾ ಕೈಕೆಲಸದಲ್ಲಿ ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದಾರೆ. ನೀವು ಈ ದೊಡ್ಡ ಮರುಭೂಮಿಯಲ್ಲಿ ಸಂಚಾರ ಮಾಡಿದ್ದನ್ನು ದೇವರು ಗಮನಿಸಿದ್ದಾರೆ. ಈ ನಲವತ್ತು ವರ್ಷ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಿಮ್ಮ ಸಂಗಡ ಇದ್ದರು. ನಿಮಗೆ ಏನೂ ಕಡಿಮೆ ಆಗಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","ಈ ಪ್ರಕಾರ ನಾವು ಸೇಯೀರಿನಲ್ಲಿ ವಾಸಮಾಡುವ ನಮ್ಮ ಸಹೋದರರಾದ ಏಸಾವನ ಮಕ್ಕಳ ಕಡೆಯಿಂದ ಓರೆಯಾಗಿ ತಿರುಗಿಕೊಂಡು ಅರಾಬಾದ ಮಾರ್ಗವನ್ನು ಬಿಟ್ಟು ಏಲತ್, ಎಚ್ಯೋನ್ ಗೆಬೆರ್ ಎಂಬ ಪಟ್ಟಣಗಳಿಂದ ಪ್ರಯಾಣಮಾಡಿ, ಮೋವಾಬಿನ ಮರುಭೂಮಿಯ ಮಾರ್ಗವಾಗಿ ಹಾದು ಹೋದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ಆಗ ಯೆಹೋವ ದೇವರು ನನಗೆ, “ಮೋವಾಬ್ಯರಿಗೆ ಕಿರುಕುಳ ನೀಡಬೇಡಿರಿ ಅಥವಾ ಅವರನ್ನು ಯುದ್ಧಕ್ಕೆ ಪ್ರಚೋದಿಸಬೇಡಿರಿ. ಏಕೆಂದರೆ ನಾನು ಅವರ ದೇಶದಲ್ಲಿ ನಿನಗೆ ಸೊತ್ತನ್ನು ಕೊಡುವುದಿಲ್ಲ. ನಾನು ಅದನ್ನು ಲೋಟನ ಮಕ್ಕಳಿಗೆ ಆರ್ ಎಂಬ ಪ್ರದೇಶವನ್ನು ಕೊಟ್ಟೆನಲ್ಲವೇ?” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","ಅದರೊಳಗೆ ಪೂರ್ವದಲ್ಲಿ ಏಮಿಯರು ವಾಸವಾಗಿದ್ದರು. ಅವರು ಅನಾಕ್ಯರ ಹಾಗೆ ಬಲಿಷ್ಠರೂ ಬಹುಜನರೂ ಎತ್ತರವಾದವರೂ ಆಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ಅವರು ಅನಾಕ್ಯರ ಹಾಗೆ ರೆಫಾಯರಿಗೆ ಸೇರಿದವರೆಂದು ಹೇಳುವದುಂಟು. ಮೋವಾಬ್ಯರು ಅವರನ್ನು ಏಮಿಯರೆಂದು ಕರೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ಅದೇ ಪೂರ್ವಕಾಲದಲ್ಲಿ ಹೋರಿಯರು ಸೇಯೀರಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದರು. ತರುವಾಯ ಇಸ್ರಾಯೇಲರು ತಮಗೆ ಯೆಹೋವ ದೇವರು ಕೊಟ್ಟ ನಾಡನ್ನು ಹೇಗೆ ಸ್ವಾಧೀನ ಮಾಡಿಕೊಂಡರೋ, ಹಾಗೆಯೇ ಏಸಾವ್ಯರು ಬಂದು ಹೋರಿಯರನ್ನು ಸಂಹರಿಸಿ, ಅವರ ನಾಡಿನಲ್ಲಿ ವಾಸಮಾಡಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“ಈಗ ಎದ್ದು ಜೆರೆದ್ ಹಳ್ಳವನ್ನು ದಾಟಿರಿ,” ಎಂದು ಯೆಹೋವ ದೇವರು ಹೇಳಿದ ಮೇಲೆ ನಾವು ಜೆರೆದ್ ಹಳ್ಳವನ್ನು ದಾಟಿದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ನಾವು ಕಾದೇಶ್ ಬರ್ನೇಯವನ್ನು ಬಿಟ್ಟಂದಿನಿಂದ ಜೆರೆದ್ ಹಳ್ಳವನ್ನು ದಾಟಿದವರೆಗೆ ಗತಿಸಿದ ಕಾಲವು ಮೂವತ್ತೆಂಟು ವರ್ಷ. ಯೆಹೋವ ದೇವರು ಅವರಿಗೆ ಪ್ರಮಾಣ ಮಾಡಿದ ಪ್ರಕಾರ ಅಷ್ಟರಲ್ಲಿ ಆ ಸಂತತಿಯ ಸೈನಿಕರೆಲ್ಲರು ಸತ್ತುಹೋಗಿದ್ದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ಪಾಳೆಯದಿಂದ ಅವರನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ಹೊರಹಾಕುವವರೆಗೂ ಯೆಹೋವ ದೇವರ ಹಸ್ತವು ಅವರ ಮೇಲಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ಉಳಿದ ಯುದ್ಧ ಮಾಡುವವರು ಜನರೊಳಗಿಂದ ಸತ್ತು ಹೋದ ಮೇಲೆ, ");
INSERT INTO kanokcv_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ಯೆಹೋವ ದೇವರು ನನ್ನೊಂದಿಗೆ ಮಾತನಾಡಿ ನನಗೆ, ");
INSERT INTO kanokcv_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“ಇಂದು ನೀನು ಮೋವಾಬಿನ ಮೇರೆಯಾದ ಆರ್ ಎಂಬ ಸ್ಥಳವನ್ನು ದಾಟಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ಅಮ್ಮೋನ್ಯರ ಹತ್ತಿರಕ್ಕೆ ನೀವು ಬಂದಾಗ, ಅವರಿಗೆ ಕಿರುಕುಳ ನೀಡಬೇಡಿರಿ ಅಥವಾ ಅವರನ್ನು ಯುದ್ಧಕ್ಕೆ ಪ್ರಚೋದಿಸಬೇಡಿರಿ. ನಾನು ಆ ದೇಶವನ್ನು ಲೋಟನ ವಂಶದವರಾದ ಅಮ್ಮೋನಿಯರಿಗೆ ಸೊತ್ತಾಗಿ ಕೊಟ್ಟಿರುವದರಿಂದ ನಿಮಗೆ ಅದರಲ್ಲಿ ಯಾವ ಭಾಗವನ್ನೂ ಕೊಡುವುದಿಲ್ಲ” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","ಪೂರ್ವಕಾಲದಲ್ಲಿ ರೆಫಾಯರು ಆ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದುದರಿಂದ ಅದು ಸಹ ರೆಫಾಯರ ದೇಶವೆನಿಸಿಕೊಳ್ಳುತ್ತದೆ. ಅಮ್ಮೋನಿಯರು ಅವರಿಗೆ ಜಂಜುಮ್ಯರೆಂದು ಕರೆದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ಅವರು ಅನಾಕ್ಯರ ಹಾಗೆ ಬಲಿಷ್ಠರೂ ಬಹುಜನರೂ ಎತ್ತರವಾದವರೂ ಆಗಿದ್ದರು. ಆದರೆ ಯೆಹೋವ ದೇವರು ಅವರನ್ನು ಅಮ್ಮೋನಿಯರ ಮುಂದೆ ತೆಗೆದುಹಾಕಿದ್ದರು. ಹೀಗೆ ಅಮ್ಮೋನಿಯರು ಅವರನ್ನು ಹೊರಡಿಸಿ, ಅವರ ಬದಲಾಗಿ ವಾಸಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ಯೆಹೋವ ದೇವರು ಸೇಯೀರಿನಲ್ಲಿ ವಾಸವಾಗಿರುವ ಏಸಾವನ ಮಕ್ಕಳಿಗೆ ಮಾಡಿದ ಹಾಗೆ ಆಯಿತು. ದೇವರು ಅವರ ಮುಂದೆ ಹೋರಿಯರನ್ನು ತೆಗೆದುಹಾಕಿದರು. ಹೀಗೆ ಅವರು ಹೋರಿಯರನ್ನು ಹೊರಡಿಸಿ, ಇವರ ಬದಲಾಗಿ ಇಂದಿನವರೆಗೂ ವಾಸಿಸುತ್ತಿದ್ದಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ಹಾಗೆ ಗಾಜಾ ಪಟ್ಟಣದವರೆಗೂ ವಾಸವಾಗಿದ್ದ ಅವ್ವೀಯರನ್ನು ಕಫ್ತೋರಿಂದ ಬಂದ ಕಫ್ತೋರ್ಯರು ನಾಶಮಾಡಿ, ಅವರ ಬದಲಾಗಿ ವಾಸಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“ಈಗ ಏಳಿರಿ, ಹೊರಡಿರಿ, ಅರ್ನೋನ್ ಹಳ್ಳವನ್ನು ದಾಟಿರಿ, ಇಗೋ, ಹೆಷ್ಬೋನಿನ ಅರಸ ಅಮೋರಿಯನಾದ ಸೀಹೋನನನ್ನೂ, ಅವನ ದೇಶವನ್ನೂ ನಿಮ್ಮ ಕೈಯಲ್ಲಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ಅವನ ಸಂಗಡ ಯುದ್ಧಮಾಡಿ, ಆ ದೇಶವನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳುವುದಕ್ಕೆ ಆರಂಭಮಾಡಿರಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ಇದೇ ದಿವಸ ಆಕಾಶದ ಕೆಳಗಿರುವ ಜನಾಂಗಗಳ ಮೇಲೆ ನಿಮ್ಮ ಹೆದರಿಕೆಯೂ ಮತ್ತು ಭಯವೂ ಉಂಟಾಗುವಂತೆ ಮಾಡುತ್ತೇನೆ. ಅವರು ನಿಮ್ಮ ಸುದ್ದಿಯನ್ನು ಕೇಳಿ ನಡುಗಿ ಅಂಜುವರು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","ಆಗ ನಾನು ಕೆದೇಮೋತೆಂಬ ಮರುಭೂಮಿಯಿಂದ ಹೆಷ್ಬೋನಿನ ಅರಸನಾದ ಸೀಹೋನನಿಗೆ ಸಮಾಧಾನದ ಸುದ್ದಿಯನ್ನು ತಿಳಿಸುವಂತೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ, ");
INSERT INTO kanokcv_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“ನಾವು ನಿನ್ನ ನಾಡನ್ನು ದಾಟಿಹೋಗುವುದಕ್ಕೆ ನಮಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು. ನಾವು ಎಡಕ್ಕೂ ಬಲಕ್ಕೂ ತಿರುಗದೆ ರಾಜ ಮಾರ್ಗದಿಂದಲೇ ಹೋಗುವೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ನಾವು ಊಣ್ಣುವುದಕ್ಕೆ ಆಹಾರವನ್ನೂ ಕುಡಿಯಲು ನೀರನ್ನು ಹಣಕೊಟ್ಟು ನಿಮ್ಮಿಂದ ಕೊಂಡುಕೊಳ್ಳುತ್ತೇವೆ. ಕಾಲ್ನಡಿಗೆಯಿಂದ ನಿಮ್ಮ ನಾಡನ್ನು ಹಾದು ಹೋಗುತ್ತೇವಷ್ಟೆ. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ನಾವು ಯೊರ್ದನಿನ ಆಚೆಗೆ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಕೊಡುವ ದೇಶಕ್ಕೆ ಹೋಗುವವರಿದ್ದೇವೆ. ಸೇಯೀರಿನಲ್ಲಿ ವಾಸಮಾಡುವ ಏಸಾವನ ಮಕ್ಕಳೂ ಆರ್ ಪ್ರದೇಶದಲ್ಲಿ ವಾಸಮಾಡುವ ಮೋವಾಬ್ಯರೂ ನಮಗೆ ದಾರಿಕೊಟ್ಟಂತೆ ನೀವೂ ನಮಗೆ ಕೊಡಬೇಕು,” ಎಂದೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ಆದರೆ ಹೆಷ್ಬೋನಿನ ಅರಸನಾದ ಸೀಹೋನನು ನಮ್ಮನ್ನು ತನ್ನ ಬಳಿಯಿಂದ ದಾಟಿಹೋಗಲು ಸಮ್ಮತಿಸಲಿಲ್ಲ. ಏಕೆಂದರೆ ಅವನನ್ನು ನಿಮ್ಮ ಕೈಯಲ್ಲಿ ಒಪ್ಪಿಸುವ ಹಾಗೆ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಅವನ ಬುದ್ಧಿಯನ್ನು ಮಂಕುಮಾಡಿ, ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸಿದರು. ಈಗಾಗಲೇ ಅದು ನೆರವೇರಿದೆ. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ಇದಲ್ಲದೆ ಯೆಹೋವ ದೇವರು ನನಗೆ, “ಸೀಹೋನನನ್ನೂ ಅವನ ದೇಶವನ್ನೂ ನಿನ್ನ ಮುಂದೆ ಒಪ್ಪಿಸುವುದಕ್ಕೆ ಆರಂಭಮಾಡಿದ್ದೇನೆ, ಅವನ ದೇಶವನ್ನು ಸೊತ್ತಾಗಿ ಹೊಂದುವಂತೆ ವಶಪಡಿಸಿಕೊಳ್ಳುವುದಕ್ಕೆ ಆರಂಭಮಾಡು,” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","ಆಗ ಸೀಹೋನನು ತನ್ನ ಜನರೆಲ್ಲರ ಸಂಗಡ ನಮ್ಮೊಡನೆ ಯುದ್ಧಮಾಡುವುದಕ್ಕೆ ಯಹಚಗೆ ಹೊರಟುಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಅವನನ್ನು ನಮ್ಮ ಕೈಗೆ ಕೊಟ್ಟುಬಿಟ್ಟಿದ್ದರಿಂದ, ಅವನನ್ನೂ ಅವನ ಮಕ್ಕಳನ್ನೂ ಅವನ ಜನರೆಲ್ಲರನ್ನೂ ಸೋಲಿಸಿದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ಆ ಕಾಲದಲ್ಲಿ ಅವನ ಪಟ್ಟಣಗಳನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು, ಪ್ರತಿಯೊಂದು ಪಟ್ಟಣದ ಗಂಡಸರನ್ನೂ ಹೆಂಗಸರನ್ನೂ ಚಿಕ್ಕವರನ್ನೂ ನಿರ್ಮೂಲ ಮಾಡಿದೆವು. ಒಬ್ಬರನ್ನೂ ಉಳಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ಪಶುಗಳನ್ನು ಮಾತ್ರ ನಮಗೆ ತೆಗೆದುಕೊಂಡು, ಪಟ್ಟಣಗಳನ್ನು ಸೂರೆಮಾಡಿದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ಅರ್ನೋನಿನ ತೀರದಲ್ಲಿರುವ ಅರೋಯೇರ್ ಹಳ್ಳದ ಪಟ್ಟಣವು ಮೊದಲ್ಗೊಂಡು ಗಿಲ್ಯಾದಿನವರೆಗೂ ಒಂದು ಪಟ್ಟಣವಾದರೂ ನಮಗೆ ಅಸಾಧ್ಯವಾಗಿರಲಿಲ್ಲ. ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಅವುಗಳನ್ನೆಲ್ಲಾ ನಮ್ಮ ಕೈಗೆ ಒಪ್ಪಿಸಿದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ಅಮ್ಮೋನಿಯರ ದೇಶದ ಯಬ್ಬೋಕ್ ನದಿಯ ಬಳಿಯಲ್ಲಿರುವ ಸ್ಥಳವನ್ನೂ ಪರ್ವತ ಪಟ್ಟಣವನ್ನೂ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಮಗೆ ಬೇಡವೆಂದ ಕಾರಣ, ಆ ಸ್ಥಳಗಳನ್ನು ನೀವು ಅತಿಕ್ರಮಿಸಲಿಲ್ಲ. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ಆಗ ನಾವು ಹಿಂದಿರುಗಿ ಬಾಷಾನಿನ ಕಡೆಗೆ ಮೇಲಕ್ಕೆ ಹೊರಟೆವು. ಆಗ ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನು ತನ್ನ ಸಮಸ್ತ ಜನರ ಸಂಗಡ ನಮಗೆ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧಮಾಡುವುದಕ್ಕೆ ಎದ್ರೈಗೆ ಹೊರಟುಬಂದನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ಆಗ ಯೆಹೋವ ದೇವರು ನನಗೆ, “ನೀನು ಅವನಿಗೆ ಭಯಪಡಬೇಡ. ಏಕೆಂದರೆ ನಿನ್ನ ಕೈಯೊಳಗೆ ನಾನು ಅವನನ್ನೂ, ಅವನ ಸಮಸ್ತ ಜನರನ್ನೂ, ಅವನ ದೇಶವನ್ನೂ ಕೊಟ್ಟಿದ್ದೇನೆ. ನೀನು ಹೆಷ್ಬೋನಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನಿಗೆ ಮಾಡಿದ ಪ್ರಕಾರ ಇವನಿಗೂ ಮಾಡಬೇಕು,” ಎಂದರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ಈ ಪ್ರಕಾರ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನನ್ನೂ ಅವನ ಜನರೆಲ್ಲರನ್ನೂ ನಮ್ಮ ಕೈಗಳಲ್ಲಿ ಒಪ್ಪಿಸಿದರು. ಒಬ್ಬನಾದರೂ ತಪ್ಪಿಸಿಕೊಂಡು ಬದುಕುಳಿಯದಂತೆ ಅವರನ್ನು ಹೊಡೆದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ಆ ಕಾಲದಲ್ಲಿ ಅವನ ಪಟ್ಟಣಗಳನ್ನೆಲ್ಲಾ ಜಯಿಸಿದೆವು. ನಾವು ಅವರಿಂದ ವಶಪಡಿಸಿಕೊಳ್ಳದ ಪಟ್ಟಣವು ಒಂದೂ ಇರಲಿಲ್ಲ. ಬಾಷಾನಿನಲ್ಲಿರುವ ಓಗನ ರಾಜ್ಯದಲ್ಲಿ ಅಂದರೆ, ಅರ್ಗೋಬಿನ ಸಮಸ್ತ ಸುತ್ತಲಿನ ಪ್ರದೇಶದ ಅರವತ್ತು ಪಟ್ಟಣಗಳನ್ನು ತೆಗೆದುಕೊಂಡೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ಆ ಪಟ್ಟಣಗಳೆಲ್ಲಾ ಎತ್ತರವಾದ ಗೋಡೆ, ಬಾಗಿಲು, ಅಗುಳಿಗಳಿಂದ ಭದ್ರವಾಗಿದ್ದವು. ಅವುಗಳಲ್ಲದೆ ಬಯಲುಸೀಮೆಯ ಪಟ್ಟಣಗಳು ಬಹಳ ಇದ್ದವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ನಾವು ಹೆಷ್ಬೋನಿನ ಅರಸನಾದ ಸೀಹೋನನ ಪಟ್ಟಣಗಳಿಗೆ ಮಾಡಿದ ಪ್ರಕಾರ ಅವುಗಳನ್ನೆಲ್ಲಾ ಸಂಪೂರ್ಣವಾಗಿ ನಿರ್ಮೂಲ ಮಾಡಿದೆವು. ಪುರುಷರನ್ನೂ ಸ್ತ್ರೀಯರನ್ನೂ ಮಕ್ಕಳನ್ನೂ ಪ್ರತಿಯೊಂದು ಪಟ್ಟಣವನ್ನೂ ಸಂಪೂರ್ಣವಾಗಿ ನಿರ್ಮೂಲ ಮಾಡಿದೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ಎಲ್ಲಾ ಪಶುಗಳನ್ನೂ ಪಟ್ಟಣಗಳನ್ನೂ ಸೂರೆಮಾಡಿಬಿಟ್ಟೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ಆ ಕಾಲದಲ್ಲಿ ನಾವು ಯೊರ್ದನ್ ನದಿಯ ಈಚೆಯಲ್ಲಿ ಅರ್ನೋನ್ ನದಿಯಿಂದ ಹೆರ್ಮೋನ್ ಬೆಟ್ಟದವರೆಗೆ ಇರುವ ದೇಶವನ್ನು ಅಮೋರಿಯರ ಇಬ್ಬರು ಅರಸರ ಕೈಯಿಂದ ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","ಹೆರ್ಮೋನಿಗೆ ಸೀದೋನ್ಯರು ಸಿರ್ಯೋನೆಂದೂ ಅಮೋರಿಯರು ಸೆನೀರ್ ಎಂದೂ ಕರೆಯುತ್ತಾರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ಬಯಲುಸೀಮೆಯ ಎಲ್ಲಾ ಪಟ್ಟಣಗಳನ್ನೂ, ಎಲ್ಲಾ ಗಿಲ್ಯಾದನ್ನೂ ಬಾಷಾನಿನಲ್ಲಿ ಓಗನ ರಾಜ್ಯದಲ್ಲಿ ಪಟ್ಟಣಗಳಾದ ಸಲ್ಕಾ ಎದ್ರೈವರೆಗೆ ಎಲ್ಲಾ ಬಾಷಾನನ್ನೂ ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡೆವು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","ರೆಫಾಯರಲ್ಲಿ ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನು ಮಾತ್ರ ಉಳಿದಿದ್ದನು. ಅವನ ಮಂಚವು ಕಬ್ಬಿಣದ ಮಂಚ. ಅದು ಅಮ್ಮೋನಿಯರ ರಬ್ಬಾದಲ್ಲಿ ಈಗಲೂ ಉಂಟಲ್ಲವೋ? ಅದರ ಉದ್ದ ಪುರುಷನ ಕೈ ಅಳತೆಯ ಪ್ರಕಾರ ಒಂಬತ್ತು ಮೊಳ, ಅಗಲ ನಾಲ್ಕು ಮೊಳ ಇತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","ಆ ಕಾಲದಲ್ಲಿ ನಾವು ಸ್ವತಂತ್ರಿಸಿಕೊಂಡ ದೇಶವನ್ನು ಅರ್ನೋನ್ ಹಳ್ಳದ ಸಮೀಪದಲ್ಲಿರುವ ಅರೋಯೇರಿನಿಂದ ಮೊದಲ್ಗೊಂಡು, ಅರ್ಧ ಗಿಲ್ಯಾದ್ ಬೆಟ್ಟವನ್ನೂ, ಅದರ ಪಟ್ಟಣಗಳನ್ನೂ ರೂಬೇನ್ಯರ ಪ್ರದೇಶದವರೆಗೂ, ಗಾದನ ಪ್ರದೇಶದವರೆಗೂ ಕೊಟ್ಟೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ಮಿಕ್ಕ ಗಿಲ್ಯಾದನ್ನು ಓಗನ ರಾಜ್ಯವಾದ ಎಲ್ಲಾ ಬಾಷಾನನ್ನೂ ಮನಸ್ಸೆಯ ಅರ್ಧ ಗೋತ್ರಕ್ಕೆ ಕೊಟ್ಟೆನು. ಅರ್ಗೋಬ್ ಎನಿಸಿಕೊಳ್ಳುವ ಸಮಸ್ತ ಸೀಮೆಯನ್ನೂ, ರೆಫಾಯರ ದೇಶವೆಂದು ಎನಿಸಿಕೊಳ್ಳುವ ಸಮಸ್ತ ಬಾಷಾನನ್ನೂ ಅವರಿಗೆ ಕೊಟ್ಟೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ಮನಸ್ಸೆಯ ಮಗ ಯಾಯೀರನು ಅರ್ಗೋಬಿನ ದೇಶವನ್ನೆಲ್ಲಾ ಗೆಷೂರ್ಯರ, ಮಾಕಾತ್ಯರ ಮೇರೆಯವರೆಗೆ ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡು, ಆ ಬಾಷಾನಿಗೆ ತನ್ನ ಹೆಸರಿನ ಪ್ರಕಾರ ಇಂದಿನವರೆಗೆ ಹವ್ವೋತ್ ಯಾಯೀರೆಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","ಗಿಲ್ಯಾದನ್ನು ಮಾಕೀರನಿಗೆ ಕೊಟ್ಟೆನು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ಗಿಲ್ಯಾದ್ ಮೊದಲುಗೊಂಡು ಅರ್ನೋನ್ ತಗ್ಗಿನವರೆಗೂ ಯಬ್ಬೋಕ್ ಹೊಳೆಯವರೆಗೂ ಇರುವ ಪ್ರದೇಶವನ್ನು ರೂಬೇನ್ಯರಿಗೂ ಗಾದ್ಯರಿಗೂ ಕೊಟ್ಟೆನು. ಅರ್ನೋನ್ ತಗ್ಗಿನ ಮಧ್ಯಭಾಗವೇ ಅವರ ಮೇರೆ. ಅವರಿಗೂ ಅಮ್ಮೋನಿಯರಿಗೂ ನಡುವೆ ಇರುವ ಯಬ್ಬೋಕ್ ಹೊಳೆಯು ಅವರ ಮೇರೆ. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ಅದಲ್ಲದೆ ಪಶ್ಚಿಮದಲ್ಲಿ ಅವರ ಪ್ರದೇಶ ಅರಾಬಾದ ಯೊರ್ದನ್ ನದಿಯವರೆಗೆ ಹರಡಿತ್ತು, ಅದರಲ್ಲಿ ಕಿನ್ನೆರೆತ್ ಮೊದಲ್ಗೊಂಡು ಪೂರ್ವದಲ್ಲಿರುವ ಪಿಸ್ಗಾದ ಕೆಳಗಿರುವ ಉಪ್ಪಿನ ಸಮುದ್ರವಾದ ಬಯಲು ಸಮುದ್ರದವರೆಗೆ ವ್ಯಾಪಿಸಿತ್ತು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ಆ ಕಾಲದಲ್ಲಿ ನಾನು ರೂಬೇನ್ಯರಿಗೂ ಗಾದ್ಯರಿಗೂ ಮತ್ತು ಮನಸ್ಸೆಯ ಅರ್ಧ ಗೋತ್ರಕ್ಕೂ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, “ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ಈ ದೇಶವನ್ನು ಸೊತ್ತಾಗಿ ಕೊಟ್ಟಿದ್ದಾರೆ. ನಿಪುಣರಾಗಿರುವ ನೀವೆಲ್ಲರು ನಿಮ್ಮ ಸಹೋದರರಾದ ಇಸ್ರಾಯೇಲರ ಮುಂದೆ ಆಯುಧ ಧರಿಸಿಕೊಂಡು ನದಿದಾಟಿ ಹೋಗಬೇಕು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","ನಿಮಗೆ ಬಹಳ ಪಶುಗಳಿವೆ ಎಂದು ನನಗೆ ಗೊತ್ತಿದೆ. ಆದರೆ ನಿಮ್ಮ ಹೆಂಡತಿಯರೂ ಮಕ್ಕಳೂ ಪಶುಗಳೂ ನಾನು ನಿಮಗೆ ಕೊಟ್ಟ ಪಟ್ಟಣಗಳಲ್ಲಿ ವಾಸವಾಗಿರಲಿ. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ಯೆಹೋವ ದೇವರು ನಿಮಗೆ ವಿಶ್ರಾಂತಿ ಕೊಟ್ಟ ಹಾಗೆಯೇ ನಿಮ್ಮ ಸಹೋದರರಿಗೂ ವಿಶ್ರಾಂತಿಯನ್ನು ಕೊಡುವರು. ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಯೊರ್ದನಿನ ಆಚೆಯಲ್ಲಿ ಅವರಿಗೆ ಕೊಟ್ಟ ದೇಶವನ್ನು ಅವರು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳುವರು. ಅದುವರೆಗೆ ನೀವು ಅವರೊಂದಿಗೆ ಸೇರಿ ಯುದ್ಧಕ್ಕೆ ಹೋಗಿರಿ. ಅನಂತರ ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ನಾನು ನಿಮಗೆ ಕೊಟ್ಟ ಸ್ಥಳಗಳಗೆ ಹಿಂತಿರುಗಿ ಬರಬಹುದು.” ");
INSERT INTO kanokcv_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ಆ ಕಾಲದಲ್ಲಿ ನಾನು ಯೆಹೋಶುವನಿಗೆ ಆಜ್ಞಾಪಿಸಿ, “ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವ ದೇವರು ಆ ಇಬ್ಬರು ಅರಸರಿಗೆ ಮಾಡಿದ್ದನ್ನೆಲ್ಲಾ ನಿನ್ನ ಕಣ್ಣುಗಳು ನೋಡಿದವು. ನೀನು ಹಾದುಹೋಗುವ ಎಲ್ಲಾ ರಾಜ್ಯಗಳನ್ನೂ ಯೆಹೋವ ದೇವರು ಹಾಗೆಯೇ ಮಾಡುವರು. ");
INSERT INTO kanokcv_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ನೀವು ಅವುಗಳಿಗೆ ಭಯ