﻿USE sofia;
DROP TABLE IF EXISTS sofia.kanirv_vpl;
CREATE TABLE kanirv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kanirv_vpl WRITE;
INSERT INTO kanirv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ಆದಿಯಲ್ಲಿ ದೇವರು ಆಕಾಶವನ್ನು, ಭೂಮಿಯನ್ನು ಸೃಷ್ಟಿಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ಭೂಮಿಯು ಕ್ರಮವಿಲ್ಲದೆಯೂ ಬರಿದಾಗಿಯೂ ಇತ್ತು. ಆದಿಸಾಗರದ ಮೇಲೆ ಕತ್ತಲಿತ್ತು. ದೇವರಾತ್ಮವು ಸಾಗರದ ಮೇಲೆ ಚಲಿಸುತ್ತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ಅನಂತರ ದೇವರು “ಬೆಳಕಾಗಲಿ” ಎಂದು ಆಜ್ಞಾಪಿಸಲು ಬೆಳಕಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ದೇವರು ಆ ಬೆಳಕನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ದೇವರು ಬೆಳಕನ್ನೂ ಕತ್ತಲನ್ನೂ ಬೇರ್ಪಡಿಸಿ ಬೆಳಕಿಗೆ “ಹಗಲು” ಎಂದೂ, ಕತ್ತಲೆಗೆ “ಇರುಳು” ಎಂದೂ ಹೆಸರಿಟ್ಟನು. ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಮೊದಲನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ಬಳಿಕ ದೇವರು “ಜಲರಾಶಿಗಳ ನಡುವೆ ವಿಸ್ತಾರವಾದ ಗುಮ್ಮಟವು ಉಂಟಾಗಲಿ ಅದು ಕೆಳಗಿನ ನೀರುಗಳನ್ನೂ ಮೇಲಿನ ನೀರುಗಳನ್ನೂ ಬೇರೆ ಬೇರೆ ಮಾಡಲಿ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ದೇವರು ವಿಸ್ತಾರವಾದ ಗುಮ್ಮಟವನ್ನು ಮಾಡಿ ಅದರ ಕೆಳಗಿದ್ದ ನೀರುಗಳನ್ನು ಅದರ ಮೇಲಿದ್ದ ನೀರುಗಳಿಂದ ವಿಂಗಡಿಸಿದನು. ಅದು ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ದೇವರು ಆ ಗುಮ್ಮಟಕ್ಕೆ “ಆಕಾಶ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಎರಡನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ಅನಂತರ ದೇವರು, “ಆಕಾಶದ ಕೆಳಗಿರುವ ನೀರೆಲ್ಲಾ ಒಂದೇ ಸ್ಥಳದಲ್ಲಿ ಒಟ್ಟಿಗೆ ಕೂಡಿಕೊಳ್ಳಲಿ ಮತ್ತು ಒಣನೆಲವು ಕಾಣಿಸಲಿ” ಅಂದನು. ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ದೇವರು ಒಣನೆಲಕ್ಕೆ “ಭೂಮಿ” ಎಂದೂ ಜಲರಾಶಿಗೆ “ಸಮುದ್ರ” ಎಂದೂ ಹೆಸರಿಟ್ಟನು. ಆತನು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ನೋಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ತರುವಾಯ ದೇವರು, “ಭೂಮಿಯು ಹುಲ್ಲನ್ನು, ಸಸ್ಯಗಳನ್ನೂ, ಬೀಜಬಿಡುವ ಕಾಯಿಪಲ್ಯದ ಗಿಡಗಳನ್ನೂ ಬೆಳೆಯಿಸಲಿ ಮತ್ತು ಬೀಜವುಳ್ಳ ಹಣ್ಣಿನ ಮರಗಳನ್ನು ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ ಫಲಿಸಲಿ” ಎಂದು ಹೇಳಿದನು, ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ಭೂಮಿಯಲ್ಲಿ ಸಸ್ಯಗಳು ಬೆಳೆದವು. ತಮ್ಮ ತಮ್ಮ ಜಾತಿಯ ಪ್ರಕಾರ ಬೀಜಬಿಡುವ ಕಾಯಿಪಲ್ಯದ ಗಿಡಗಳು ಉಂಟಾದವು. ತಮ್ಮ ತಮ್ಮ ಜಾತಿಗನುಸಾರವಾಗಿ ಬೀಜವುಳ್ಳ ಹಣ್ಣಿನ ಮರಗಳು ಉತ್ಪತ್ತಿಯಾದವು. ದೇವರು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡನು ");
INSERT INTO kanirv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಮೂರನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ಬಳಿಕ ದೇವರು, “ಆಕಾಶ ಮಂಡಲದಲ್ಲಿ ಬೆಳಕುಗಳು ಉಂಟಾಗಲಿ. ಅವು ಹಗಲಿರುಳುಗಳನ್ನು ಬೇರೆ ಬೇರೆ ಮಾಡಲಿ. ಅವು ಕಾಲಗಳನ್ನೂ, ದಿನಸಂವತ್ಸರಗಳನ್ನೂ ಸೂಚಿಸುವ ಗುರುತುಗಳಾಗಿರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ಭೂಮಿಯ ಮೇಲೆ ಬೆಳಕು ಕೊಡುವುದಕ್ಕೆ ಅವು ಆಕಾಶಮಂಡಲದಲ್ಲಿ ದೀಪಗಳಂತಿರಲಿ” ಅಂದನು. ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ದೇವರು ಹಗಲನ್ನಾಳುವುದಕ್ಕೆ ದೊಡ್ಡ ದೀಪವನ್ನೂ ಇರುಳನ್ನಾಳುವುದಕ್ಕೆ ಚಿಕ್ಕ ದೀಪವನ್ನೂ ಹೀಗೆ ಎರಡು ದೊಡ್ಡ ದೀಪಗಳನ್ನು ಉಂಟು ಮಾಡಿದನು. ಆತನು ನಕ್ಷತ್ರಗಳನ್ನು ಸಹ ಉಂಟು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ದೇವರು ಆ ಬೆಳಕುಗಳನ್ನು ಆಕಾಶದಲ್ಲಿ ನಿಲ್ಲಿಸಿ ಭೂಮಿಯ ಮೇಲೆ ಬೆಳಕು ಕೊಡುವುದಕ್ಕೂ ");
INSERT INTO kanirv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ಹಗಲಿರುಳುಗಳನ್ನು ಆಳುವುದಕ್ಕೂ ಬೆಳಕನ್ನು, ಕತ್ತಲನ್ನು ಬೇರೆ ಬೇರೆ ಮಾಡುವುದಕ್ಕೂ ಅವುಗಳನ್ನು ನೇಮಿಸಿದನು. ದೇವರು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ನಾಲ್ಕನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ತರುವಾಯ ದೇವರು, “ಗುಂಪು ಗುಂಪಾಗಿ ಚಲಿಸುವ ಜಲಜಂತುಗಳು ನೀರಿನಲ್ಲಿ ತುಂಬಿಕೊಳ್ಳಲಿ, ಪಕ್ಷಿಗಳು ಭೂಮಿಯ ಮೇಲೆ ಅಂತರಿಕ್ಷದಲ್ಲಿ ಹಾರಾಡಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ಹೀಗೆ ದೇವರು ಮಹಾ ಜಲಚರಗಳನ್ನೂ ನೀರಿನಲ್ಲಿ ತುಂಬಿರುವ ಸಕಲ ವಿಧವಾದ ಜೀವಿಗಳನ್ನೂ ರೆಕ್ಕೆಗಳುಳ್ಳ ಸಕಲವಿಧವಾದ ಪಕ್ಷಿಗಳನ್ನೂ ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ ಉಂಟುಮಾಡಿದನು. ಆತನು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ಇದಲ್ಲದೆ ದೇವರು, “ಅವುಗಳಿಗೆ ನೀವು ಅಭಿವೃದ್ಧಿಯಾಗಿ ಹೆಚ್ಚಿರಿ, ಜಲಚರಗಳು ಸಮುದ್ರದ ನೀರಿನಲ್ಲಿ ತುಂಬಿಕೊಳ್ಳಲಿ, ಪಕ್ಷಿಗಳು ಭೂಮಿಯ ಮೇಲೆ ಹೆಚ್ಚಲಿ” ಎಂದು ಹೇಳಿ ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಐದನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ಬಳಿಕ ದೇವರು, “ಭೂಮಿಯಿಂದ ಜೀವಜಂತುಗಳು ಉಂಟಾಗಲಿ; ಪಶು, ಕ್ರಿಮಿಗಳೂ ಕಾಡುಮೃಗಗಳು, ತಮ್ಮ ತಮ್ಮ ಜಾತಿಗನುಸಾರವಾಗಿ ಹುಟ್ಟಲಿ” ಅಂದನು. ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ದೇವರು ಕಾಡುಮೃಗಗಳನ್ನೂ, ಪಶುಗಳನ್ನೂ, ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಕ್ರಿಮಿಕೀಟಗಳನ್ನೂ ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ ಉಂಟುಮಾಡಿದನು. ಆತನು ಅದನ್ನು ಒಳ್ಳೆಯದೆಂದು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ಆಮೇಲೆ ದೇವರು, ನಮ್ಮ ಸ್ವರೂಪದಲ್ಲಿ ನಮ್ಮ ಹೋಲಿಕೆಗೆ ಸರಿಯಾಗಿ ಮನುಷ್ಯರನ್ನು ಉಂಟು ಮಾಡೋಣ. ಅವರು ಸಮುದ್ರದಲ್ಲಿರುವ ಮೀನುಗಳ ಮೇಲೆಯೂ, ಅಂತರಿಕ್ಷದಲ್ಲಿ ಹಾರಾಡುವ ಪಕ್ಷಿಗಳ ಮೇಲೆಯೂ, ಪ್ರಾಣಿಗಳ ಮೇಲೆಯೂ, ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಎಲ್ಲಾ ಕ್ರಿಮಿಕೀಟಗಳ ಮೇಲೆಯೂ ಎಲ್ಲಾ ಭೂಮಿಯ ಮೇಲೆಯೂ ದೊರೆತನಮಾಡಲಿ ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ಹೀಗೆ ದೇವರು; “ಮನುಷ್ಯನನ್ನು ತನ್ನ ಸ್ವರೂಪದಲ್ಲಿ ಉಂಟುಮಾಡಿದನು. ದೇವರ ಸ್ವರೂಪದಲ್ಲಿ ಅವನನ್ನು ಉಂಟುಮಾಡಿದನು. ಅವರನ್ನು ಗಂಡುಹೆಣ್ಣಾಗಿ ಸೃಷ್ಟಿ ಮಾಡಿದನು.” ");
INSERT INTO kanirv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ಇದಲ್ಲದೆ ದೇವರು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ, “ನೀವು ಬಹು ಸಂತಾನವುಳ್ಳವರಾಗಿ ಹೆಚ್ಚಿರಿ. ಭೂಮಿಯಲ್ಲಿ ತುಂಬಿಕೊಂಡು ಅದನ್ನು ವಶಮಾಡಿಕೊಳ್ಳಿರಿ. ಸಮುದ್ರದ ಮೀನುಗಳ ಮೇಲೆಯೂ ಆಕಾಶದ ಪಕ್ಷಿಗಳ ಮೇಲೆಯೂ ಭೂಮಿಯಲ್ಲಿ ಚಲಿಸುವ ಎಲ್ಲಾ ಜೀವಿಗಳ ಮೇಲೆಯೂ ದೊರೆತನ ಮಾಡಿರಿ” ಎಂದು ಅವರಿಗೆ ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ಅಲ್ಲದೆ ದೇವರು, “ಇಗೋ, ಸಮಸ್ತ ಭೂಮಿಯ ಮೇಲಿರುವ ಬೀಜವುಳ್ಳ ಎಲ್ಲಾ ಪೈರುಗಳನ್ನೂ, ಬೀಜವುಳ್ಳ ಎಲ್ಲಾ ಹಣ್ಣಿನ ಮರಗಳನ್ನೂ ನಿಮಗೆ ಆಹಾರಕ್ಕಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ ");
INSERT INTO kanirv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ಇದಲ್ಲದೆ ಭೂಮಿಯ ಮೇಲೆ ತಿರುಗಾಡುವ ಮೃಗಗಳು, ಆಕಾಶದಲ್ಲಿ ಹಾರಾಡುವ ಪಕ್ಷಿಗಳು, ನೆಲದಲ್ಲಿ ಹರಿದಾಡುವ ಕ್ರಿಮಿಕೀಟಗಳು ಮೊದಲಾದ ಜೀವಿಗಳಿಗೆ ಹಸುರಾದ ಸಸ್ಯಗಳನ್ನೆಲ್ಲಾ ಆಹಾರಕ್ಕಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ಅದು ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ದೇವರು ತಾನು ಉಂಟುಮಾಡಿದ್ದನ್ನೆಲ್ಲಾ ನೋಡಲಾಗಿ ಅವೆಲ್ಲವೂ ಬಹು ಒಳ್ಳೆಯದಾಗಿ ತೋರಿತು. ಸಾಯಂಕಾಲವೂ ಉದಯಕಾಲವೂ ಆಗಿ ಆರನೆಯ ದಿನವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ಹೀಗೆ ಭೂಮಿಯು ಆಕಾಶಗಳು ಅವುಗಳಲ್ಲಿರುವ ಸಮಸ್ತವೂ ನಿರ್ಮಿತವಾದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ದೇವರು ತನ್ನ ಸೃಷ್ಟಿಕಾರ್ಯವನ್ನು ಮುಗಿಸಿಬಿಟ್ಟು ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ದೇವರು ತನ್ನ ಸೃಷ್ಟಿ ಕಾರ್ಯವನ್ನು ಮುಗಿಸಿದ ನಂತರ ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಂಡಿದ್ದರಿಂದ ಆ ದಿನವನ್ನು ಪರಿಶುದ್ಧ ದಿನವಾಗಿರಲಿ ಎಂದು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ಯೆಹೋವನಾದ ದೇವರು ಭೂಮಿಯು ಆಕಾಶಗಳನ್ನು ನಿರ್ಮಾಣ ಮಾಡಿದ ಚರಿತ್ರೆ ಇದೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ಯೆಹೋವನಾದ ದೇವರು ಭೂಮ್ಯಾಕಾಶಗಳನ್ನು ಉಂಟುಮಾಡಿದಾಗ ಯಾವ ವಿಧವಾದ ಗಿಡವೂ ಭೂಮಿಯಲ್ಲಿ ಇರಲಿಲ್ಲ. ಯಾವ ಸಸ್ಯವೂ ಮೊಳೆತಿರಲಿಲ್ಲ. ಏಕೆಂದರೆ ಯೆಹೋವನಾದ ದೇವರು ಭೂಮಿಯ ಮೇಲೆ ಮಳೆಯನ್ನು ಸುರಿಸಿರಲಿಲ್ಲ. ಭೂಮಿಯನ್ನು ವ್ಯವಸಾಯ ಮಾಡುವುದಕ್ಕೆ ಮನುಷ್ಯನೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ಆದರೂ ಭೂಮಿಯಿಂದ ನೀರಿನ ಬುಗ್ಗೆ ಉಕ್ಕಿ ಮೇಲೆ ಬಂದು ನೆಲವನ್ನೆಲ್ಲಾ ತೋಯಿಸುತ್ತಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ಹೀಗಿರಲು ಯೆಹೋವನಾದ ದೇವರು ನೆಲದ ಮಣ್ಣಿನಿಂದ ಮನುಷ್ಯನನ್ನು ಸೃಷ್ಟಿಸಿ ಅವನ ಮೂಗಿನಲ್ಲಿ ಜೀವಶ್ವಾಸವನ್ನು ಊದಿದನು. ಆಗ ಮನುಷ್ಯನು ಬದುಕುವ ಪ್ರಾಣಿಯಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ಇದಲ್ಲದೆ ಯೆಹೋವನಾದ ದೇವರು ಮೂಡಣ ದಿಕ್ಕಿನಲ್ಲಿರುವ ಏದೆನ್ ಸೀಮೆಯಲ್ಲಿ ಒಂದು ಉದ್ಯಾನವನವನ್ನು ಸೃಷ್ಟಿಸಿ ತಾನು ಉಂಟುಮಾಡಿದ ಮನುಷ್ಯನನ್ನು ಅದರಲ್ಲಿ ತಂಗುವಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ಆನಂತರ ಯೆಹೋವನಾದ ದೇವರು ನೋಡುವುದಕ್ಕೆ ರಮ್ಯವಾಗಿಯೂ, ತಿನ್ನುವುದಕ್ಕೆ ಉತ್ತಮವಾಗಿಯೂ ಇರುವ ಎಲ್ಲಾ ತರಹದ ಮರಗಳನ್ನು ಆ ಭೂಮಿಯಲ್ಲಿ ಬೆಳೆಯುವಂತೆ ಮಾಡಿದನು. ಅದಲ್ಲದೆ ಆ ವನದ ಮಧ್ಯದಲ್ಲಿ ಜೀವದಾಯಕ ವೃಕ್ಷವನ್ನೂ ಒಳ್ಳೇದರ ಕೆಟ್ಟದ್ದರ ಅರಿವನ್ನು ಹುಟ್ಟಿಸುವ ವೃಕ್ಷವನ್ನು ಬೆಳೆಯಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ಏದೆನ್ ಸೀಮೆಯಲ್ಲಿ ಒಂದು ನದಿ ಹುಟ್ಟಿ ಆ ವನವನ್ನು ತೋಯಿಸುತ್ತಿತು. ಅದು ಅಲ್ಲಿಂದ ನಾಲ್ಕು ಉಪನದಿಗಳಾಗಿ ಕವಲೊಡೆದಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ಮೊದಲನೆಯದರ ಹೆಸರು ಪೀಶೋನ್, ಅದು ಬಂಗಾರ ದೊರೆಯುವ ಹವೀಲ ದೇಶವನ್ನೆಲ್ಲಾ ಸುತ್ತಿ ಹರಿಯುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ಆ ಪ್ರದೇಶದ ಬಂಗಾರವು ಅಮೂಲ್ಯವಾದದ್ದು. ಅಲ್ಲಿ ಬದೋಲಖ ಧೂಪವೂ, ಗೋಮೇಧಿಕದ ಅಮೂಲ್ಯ ರತ್ನವು ಸಿಕ್ಕುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ಎರಡನೆಯ ನದಿಯ ಹೆಸರು ಗೀಹೋನ್, ಅದು ಕೂಷ್ ದೇಶವನ್ನೆಲ್ಲಾ ಸುತ್ತಿ ಹರಿಯುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ಮೂರನೆಯ ನದಿಯ ಹೆಸರು ಟೈಗ್ರೀಸ್; ಅದು ಅಶ್ಶೂರ್ ದೇಶದ ಪೂರ್ವಕ್ಕೆ ಹರಿಯುವುದು. ನಾಲ್ಕನೆಯದು ಯೂಫ್ರೆಟಿಸ್ ನದಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ಯೆಹೋವನಾದ ದೇವರು ಆ ಮನುಷ್ಯನನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗಿ ಏದೆನ್ ತೋಟವನ್ನು ವ್ಯವಸಾಯ ಮಾಡುವುದಕ್ಕೂ ಕಾಯುವುದಕ್ಕೂ ಅದರಲ್ಲಿ ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ಇದಲ್ಲದೆ ಯೆಹೋವನಾದ ದೇವರು ಆ ಮನುಷ್ಯನಿಗೆ, “ನೀನು ತೋಟದಲ್ಲಿರುವ ಎಲ್ಲಾ ಮರಗಳ ಹಣ್ಣುಗಳನ್ನು ಯಥೇಚ್ಛವಾಗಿ ತಿನ್ನಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ಒಳ್ಳೇದರ ಕೆಟ್ಟದ್ದರ ಅರಿವನ್ನು ಹುಟ್ಟಿಸುವ ಈ ಮರದ ಹಣ್ಣನ್ನು ಮಾತ್ರ ತಿನ್ನಬಾರದು. ತಿಂದ ದಿನವೇ ಸತ್ತು ಹೋಗುವೆ” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ಅನಂತರ ಯೆಹೋವನಾದ ದೇವರು, “ಮನುಷ್ಯನು ಒಂಟಿಯಾಗಿರುವುದು ಒಳ್ಳೆಯದಲ್ಲ. ಅವನಿಗೆ ಸರಿಯಾದ ಸಹಕಾರಿಯನ್ನು ಉಂಟುಮಾಡುವೆನು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ಯೆಹೋವನು ಎಲ್ಲಾ ಭೂಜಂತುಗಳನ್ನೂ ಆಕಾಶದ ಪಕ್ಷಿಗಳನ್ನೂ, ನೆಲದ ಮಣ್ಣಿನಿಂದ ಸೃಷ್ಟಿಸಿ ಇವುಗಳಿಗೆ ಮನುಷ್ಯನು ಏನೇನು ಹೆಸರಿಡುವನೋ ನೋಡೋಣ ಎಂದು ಅವನ ಬಳಿಗೆ ಬರಮಾಡಿದನು. ಮನುಷ್ಯನು ಒಂದೊಂದು ಪ್ರಾಣಿಗೆ ಯಾವ ಯಾವ ಹೆಸರಿಟ್ಟನೋ ಅದೇ ಅವುಗಳ ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ಹೀಗೆ ಆದಾಮನು ಎಲ್ಲಾ ಪಶುಗಳಿಗೂ, ಆಕಾಶದ ಪಕ್ಷಿಗಳಿಗೂ, ಕಾಡುಮೃಗಗಳಿಗೂ ಹೆಸರಿಟ್ಟನು. ಆದರೆ ಆ ಮನುಷ್ಯನಿಗೆ ಸರಿಯಾದ ಸಹಕಾರಿ ಸಿಗಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ಹೀಗಿರುವಲ್ಲಿ ಯೆಹೋವನಾದ ದೇವರು ಆ ಮನುಷ್ಯನಿಗೆ ಗಾಢನಿದ್ರೆಯನ್ನು ಬರಮಾಡಿ ಅವನ ಪಕ್ಕೆಯ ಎಲುಬುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಕೊಂಡು ಅದರ ಸ್ಥಳವನ್ನು ಮಾಂಸದಿಂದ ತುಂಬಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ಯೆಹೋವನು ಮನುಷ್ಯನಿಂದ ತೆಗೆದ ಎಲುಬನ್ನು, ಸ್ತ್ರೀಯನ್ನಾಗಿ ಮಾಡಿ ಆಕೆಯನ್ನು ಅವನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ಅವನು ಆಕೆಯನ್ನು ನೋಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","“ಈಗ ಸರಿ, ಈಕೆಯು ನನ್ನ ಎಲುಬುಗಳಿಂದ ಬಂದ ಎಲುಬು, ನನ್ನ ಮಾಂಸದಿಂದ ಬಂದ ಮಾಂಸವೂ ಆಗಿದ್ದಾಳೆ. ಈಕೆಯು ಮನುಷ್ಯನಿಂದ ಉತ್ಪತ್ತಿಯಾದ ಕಾರಣ ನಾರೀ ಎನ್ನಿಸಿಕೊಳ್ಳುವಳು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ಈ ಕಾರಣದಿಂದ ಪುರುಷನು ತಂದೆತಾಯಿಗಳನ್ನು ಬಿಟ್ಟು ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಸೇರಿಕೊಳ್ಳುವನು. ಅವರಿಬ್ಬರು ಒಂದೇ ಶರೀರವಾಗಿರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ಆ ಮನುಷ್ಯನು ಮತ್ತು ಅವನ ಹೆಂಡತಿ ಬೆತ್ತಲೆಯಾಗಿದ್ದರೂ ನಾಚಿಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ಯೆಹೋವನಾದ ದೇವರು ಉಂಟುಮಾಡಿದ ಎಲ್ಲಾ ಕಾಡುಮೃಗಗಳಲ್ಲಿ ಸರ್ಪವು ಅತಿ ಯುಕ್ತಿಯುಳ್ಳದ್ದಾಗಿತ್ತು. ಸರ್ಪವು ಸ್ತ್ರೀಯ ಬಳಿಗೆ ಬಂದು, “ಏನಮ್ಮಾ, ತೋಟದಲ್ಲಿರುವ ಯಾವ ಮರದ ಹಣ್ಣನ್ನು ನೀವು ತಿನ್ನಬಾರದೆಂದು ದೇವರು ಅಪ್ಪಣೆ ಕೊಟ್ಟಿರುವುದು ನಿಜವೋ?” ಎಂದು ಕೇಳಲು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ಆ ಸ್ತ್ರೀಯು ಸರ್ಪಕ್ಕೆ, “ತೋಟದಲ್ಲಿರುವ ಎಲ್ಲಾ ಮರಗಳ ಹಣ್ಣುಗಳನ್ನು ತಿನ್ನಬಹುದು, ");
INSERT INTO kanirv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ಆದರೆ ತೋಟದ ಮಧ್ಯದಲ್ಲಿರುವ ಆ ಮರದ ಹಣ್ಣಿನ ವಿಷಯವಾಗಿ, ‘ನೀವು ಇದನ್ನು ತಿನ್ನಲೂ ಬಾರದು, ಮುಟ್ಟಲೂ ಕೂಡದು, ತಿಂದರೆ ಸಾಯುವಿರಿ’ ಎಂದು ದೇವರು ಹೇಳಿದ್ದಾನೆ” ಅಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ಆಗ ಸರ್ಪವು ಸ್ತ್ರೀಗೆ, “ನೀವು ನಿಶ್ಚಯವಾಗಿ ಸಾಯುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ನೀವು ಇದರ ಹಣ್ಣನ್ನು ತಿಂದ ಕ್ಷಣವೇ ನಿಮ್ಮ ಕಣ್ಣುಗಳು ತೆರೆಯುವವು, ನೀವು ದೇವರುಗಳಂತೆ ಆಗಿ ಒಳ್ಳೆಯದರ ಮತ್ತು ಕೆಟ್ಟದ್ದರ ಬೇಧವನ್ನು ತಿಳಿಯುವಿರಿ, ಇದು ದೇವರಿಗೆ ಚೆನ್ನಾಗಿ ಗೊತ್ತು” ಎಂದು ಹೇಳಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ಆಗ ಸ್ತ್ರೀಯು ಆ ಮರದ ಹಣ್ಣು ತಿನ್ನುವುದಕ್ಕೆ ಉತ್ತಮವಾಗಿಯೂ, ನೋಡುವುದಕ್ಕೆ ರಮ್ಯವಾಗಿಯೂ, ಜ್ಞಾನೋದಯಕ್ಕೆ ಅಪೇಕ್ಷಿಸತಕ್ಕದ್ದಾಗಿಯೂ ಇದೆ ಎಂದು ತಿಳಿದು ಅದನ್ನು ತೆಗೆದುಕೊಂಡು ತಿಂದಳು ಮತ್ತು ಸಂಗಡ ಇದ್ದ ಗಂಡನಿಗೂ ಕೊಡಲೂ, ಅವನೂ ತಿಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ಕೂಡಲೆ ಅವರಿಬ್ಬರ ಕಣ್ಣುಗಳು ತೆರೆದವು. ತಾವು ಬೆತ್ತಲೆಯಾಗಿದ್ದೇವೆಂದು ತಿಳಿದು ಅಂಜೂರದ ಎಲೆಗಳನ್ನು ಜೋಡಿಸಿ ಉಟ್ಟುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ತರುವಾಯ ಯೆಹೋವನಾದ ದೇವರು ಸಂಜೆಯ ತಂಗಾಳಿಯಲ್ಲಿ ತೋಟದೊಳಗೆ ಸಂಚರಿಸುತ್ತಿರುವಾಗ ಆ ಮನುಷ್ಯನು ಮತ್ತು ಸ್ತ್ರೀಯು ಆತನ ಸಪ್ಪಳವನ್ನು ಕೇಳಿ ಆತನಿಗೆ ಕಾಣಿಸಬಾರದೆಂದು ತೋಟದ ಮರಗಳ ಹಿಂದೆ ಅಡಗಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ಆಗ ಯೆಹೋವ ದೇವರು ಮನುಷ್ಯನನ್ನು ಕರೆದು, “ನೀನು ಎಲ್ಲಿದ್ದೀ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ಅದಕ್ಕೆ ಅವನು, “ನೀನು ತೋಟದಲ್ಲಿ ಸಂಚರಿಸುವ ಸಪ್ಪಳವನ್ನು ನಾನು ಕೇಳಿ, ಬೆತ್ತಲೆಯಾಗಿರುವುದರಿಂದ ಹೆದರಿ ಅಡಗಿಕೊಂಡೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ಅದಕ್ಕಾತನು, “ನೀನು ಬೆತ್ತಲೆಯಾಗಿದ್ದೀಯೆಂದು ನಿನಗೆ ತಿಳಿಸಿದವರಾರು? ತಿನ್ನಬಾರದೆಂದು ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮರದ ಹಣ್ಣನ್ನು ತಿಂದಿದ್ದಿಯಾ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ಅದಕ್ಕೆ ಆ ಮನುಷ್ಯನು, “ನನ್ನ ಜೊತೆಯಲ್ಲಿರುವುದಕ್ಕೆ ನೀನು ಕೊಟ್ಟ ಈ ಸ್ತ್ರೀಯು, ಆ ಮರದ ಹಣ್ಣನ್ನು ನನಗೆ ಕೊಟ್ಟಳು, ನಾನು ತಿಂದೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ಯೆಹೋವನಾದ ದೇವರು ಆ ಸ್ತ್ರೀಗೆ, “ಇದೇನು ನೀನು ಮಾಡಿದ್ದು?” ಎಂದು ಕೇಳಲು, ಆ ಸ್ತ್ರೀಯು, “ಸರ್ಪವು ನನ್ನನ್ನು ವಂಚಿಸಿತು, ನಾನು ತಿಂದೆನು” ಎಂದು ಉತ್ತರ ಕೊಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ಆಗ ಯೆಹೋವನಾದ ದೇವರು ಸರ್ಪಕ್ಕೆ; “ನೀನು ಈ ಕಾರ್ಯವನ್ನು ಮಾಡಿದ್ದರಿಂದ ಎಲ್ಲಾ ಪಶುಗಳಲ್ಲಿಯೂ ಅಡವಿಯ ಎಲ್ಲಾ ಕಾಡುಮೃಗಗಳಲ್ಲಿಯೂ ಶಾಪಗ್ರಸ್ತನಾಗಿರುವೆ. ನೀನು ಹೊಟ್ಟೆಯಿಂದ ಹರಿದು ನಿನ್ನ ಜೀವಮಾನದ ದಿನಗಳಲ್ಲೆಲ್ಲಾ ಮಣ್ಣನ್ನೇ ತಿನ್ನುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ನಿನಗೂ, ಈ ಸ್ತ್ರೀಗೂ, ನಿನ್ನ ಸಂತಾನಕ್ಕೂ ಈ ಸ್ತ್ರೀಯ ಸಂತಾನಕ್ಕೂ ಹಗೆತನವಿರುವ ಹಾಗೆ ಮಾಡುವೆನು. ಈಕೆಯ ಸಂತಾನವು ನಿನ್ನ ತಲೆಯನ್ನು ಜಜ್ಜುವುದು. ನೀನು ಅವನ ಹಿಮ್ಮಡಿಯನ್ನು ಕಚ್ಚುವಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ಆ ನಂತರ ಆ ಸ್ತ್ರೀಗೆ, “ನಾನು ನಿನ್ನ ಗರ್ಭವೇದನೆಯನ್ನು ಅಧಿಕವಾಗಿ ಹೆಚ್ಚಿಸುವೆನು ನೀನು ನೋವಿನಿಂದ ಮಕ್ಕಳನ್ನು ಹಡೆಯುವಿ. ಗಂಡನ ಮೇಲೆ ನಿನಗೆ ಬಯಕೆ ಇರುವುದು, ಆದರೆ ಅವನು ನಿನ್ನ ಮೇಲೆ ಆಳ್ವಿಕೆ ಮಾಡುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ಅನಂತರ ಆ ಪುರುಷನಿಗೆ, “ತಿನ್ನಬಾರದೆಂದು ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮರದ ಫಲವನ್ನು ನಿನ್ನ ಹೆಂಡತಿಯ ಮಾತು ಕೇಳಿ ತಿಂದ ಕಾರಣ, ನಿನ್ನ ನಿಮಿತ್ತ ಭೂಮಿಯು ಶಾಪಗ್ರಸ್ಥವಾಯಿತು. ನಿನ್ನ ಜೀವಮಾನವೆಲ್ಲಾ ಕಷ್ಟಪಟ್ಟು ಬೆವರು ಸುರಿಸಿ ದುಡಿದು ಭೂಮಿಯ ಹುಟ್ಟುವಳಿಯನ್ನು ತಿನ್ನಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ಆ ಭೂಮಿಯಲ್ಲಿ ಮುಳ್ಳುಗಿಡಗಳೂ ಕಳೆಗಳೂ ಬಹಳವಾಗಿ ಬೆಳೆಯುವವು, ಹೊಲದ ಬೆಳೆಗಳು ನಿನಗೆ ಆಹಾರವಾಗಿರುವವು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ನೀನು ಪುನಃ ಮಣ್ಣಿಗೆ ಸೇರುವ ತನಕ ಬೆವರು ಸುರಿಸುತ್ತಾ ಬೇಕಾದ ಆಹಾರವನ್ನು ಸಂಪಾದಿಸಬೇಕು. ನೀನು ಮಣ್ಣಿನಿಂದ ತೆಗೆಯಲ್ಪಟ್ಟವನಾಗಿರುವುದರಿಂದ ನೀನು ಮಣ್ಣೇ; ಪುನಃ ಮಣ್ಣಿಗೆ ಸೇರತಕ್ಕವನಾಗಿದ್ದೀ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ಆ ಮನುಷ್ಯನು ತನ್ನ ಹೆಂಡತಿಗೆ ಹವ್ವ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಆದುದರಿಂದ ಬದುಕಿರುವವರೆಲ್ಲರಿಗೂ ಆಕೆಯೇ ಮೂಲತಾಯಿಯಾಗಿದ್ದಾಳೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ಯೆಹೋವ ದೇವರು ಆದಾಮನಿಗೂ ಅವನ ಹೆಂಡತಿಗೂ ಚರ್ಮದ ಅಂಗಿಗಳನ್ನು ಮಾಡಿ ತೊಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ಯೆಹೋವ ದೇವರು “ಈ ಮನುಷ್ಯನು ಒಳ್ಳೆಯದರ ಮತ್ತು ಕೆಟ್ಟದ್ದರ ಬೇಧವನ್ನರಿತು ನಮ್ಮಲ್ಲಿ ಒಬ್ಬನಂತಾದನಲ್ಲಾ? ಇದರಿಂದ ಇವನು ಕೈಚಾಚಿ ಜೀವವೃಕ್ಷದ ಫಲವನ್ನು ಸಹ ತಿಂದು ಶಾಶ್ವತವಾಗಿ ಬದುಕುವವನಾಗಬಾರದು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ಆದ್ದರಿಂದ ಯೆಹೋವನು ಅವನನ್ನು ಸೃಷ್ಟಿಸಿದ ಮಣ್ಣಿನ ಭೂಮಿಯನ್ನೇ ವ್ಯವಸಾಯ ಮಾಡುವುದಕ್ಕಾಗಿ ಅವನನ್ನು ಏದೆನ್ ತೋಟದಿಂದ ಹೊರಗೆ ಕಳುಹಿಸಿ ಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ಹೀಗೆ ಆತನು ಮನುಷ್ಯನನ್ನು ಹೊರಗೆ ಹಾಕಿ, ಜೀವವೃಕ್ಷಕ್ಕೆ ಹೋಗುವ ದಾರಿಯನ್ನು ಕಾಯುವುದಕ್ಕೆ, ಏದೆನ್ ವನದ ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿ ಕೆರೂಬಿಯರನ್ನೂ, ಎಲ್ಲಾ ಕಡೆಯಲ್ಲಿ ಧಗಧಗಿಸುತ್ತಾ ಉರಿಯುವ ಜ್ವಾಲೆಯ ಕತ್ತಿಯನ್ನು ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ಆದಾಮನು ತನ್ನ ಹೆಂಡತಿಯಾದ ಹವ್ವಳನ್ನು ಸಂಗಮಿಸಲು ಆಕೆ ಗರ್ಭಿಣಿಯಾಗಿ ಕಾಯಿನನನ್ನು ಹೆತ್ತು, “ನಾನು ಯೆಹೋವನ ಅನುಗ್ರಹದಿಂದ ಗಂಡು ಮಗುವನ್ನು ಪಡೆದಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ತರುವಾಯ ಅವನ ತಮ್ಮನಾದ ಹೇಬೆಲನನ್ನು ಹೆತ್ತಳು. ಹೇಬೆಲನು ಕುರಿಕಾಯುವವನಾದನು. ಕಾಯಿನನು ವ್ಯವಸಾಯಗಾರನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ಕಾಲಾಂತರದಲ್ಲಿ ಕಾಯಿನನು ಹೊಲದ ಬೆಳೆಯಲ್ಲಿ ಕೆಲವನ್ನು ತಂದು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ಹೇಬೆಲನು ಹಾಗೆಯೇ ತನ್ನ ಹಿಂಡಿನಿಂದ ಚೊಚ್ಚಲ ಕುರಿಗಳನ್ನು ಕಾಣಿಕೆಯಾಗಿ ತಂದು ಅವುಗಳ ಕೊಬ್ಬನ್ನು ಹೋಮ ಮಾಡಿದನು, ಯೆಹೋವನು ಹೇಬೆಲನನ್ನೂ ಅವನ ಕಾಣಿಕೆಯನ್ನು ಮೆಚ್ಚಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ಆದರೆ ಕಾಯಿನನನ್ನೂ ಅವನ ಕಾಣಿಕೆಯನ್ನೂ ಮೆಚ್ಚಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಕಾಯಿನನು ಬಹು ಕೋಪಗೊಂಡನು, ಅವನ ಮುಖವು ಸಿಟ್ಟಿನಿಂದ ಕಳೆಗುಂದಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ಆಗ ಯೆಹೋವನು ಕಾಯಿನನಿಗೆ, “ನೀನು ಕೋಪಗೊಂಡಿದ್ದೇಕೆ? ");
INSERT INTO kanirv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ನಿನ್ನ ಮುಖವು ಕಳೆಗುಂದಲು ಕಾರಣವೇನು? ನೀನು ತಲೆ ತಗ್ಗಿಸಲು ಕಾರಣವೇನು? ನೀನು ಒಳ್ಳೆಯ ಕೆಲಸ ಮಾಡಿದ್ದರೆ ನಿನ್ನ ತಲೆಯು ಎತ್ತಲ್ಪಡುವುದಲ್ಲವೇ? ಪಾಪವು ನಿನ್ನನ್ನು ಹಿಡಿಯಬೇಕೆಂದು ಬಾಗಿಲಲ್ಲಿ ಹೊಂಚಿಕೊಂಡಿರುವುದು, ಅದು ನಿನ್ನನ್ನು ತನ್ನ ಹಿಡಿತದಲ್ಲಿ ಇಟ್ಟುಕೊಳ್ಳುವುದು. ಆದರೆ ನೀನು ಅದನ್ನು ಹಿಡಿತದಲ್ಲಿ ಇರಿಸಿಕೊಳ್ಳಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ತರುವಾಯ ಕಾಯಿನನು ತನ್ನ ತಮ್ಮನಾದ ಹೇಬೆಲನ ಸಂಗಡ ಮಾತನಾಡಿದನು. ಅವರು ಹೊಲದಲ್ಲಿದ್ದಾಗ ಕಾಯಿನನು ತನ್ನ ತಮ್ಮನ ಮೇಲೆ ಬಿದ್ದು ಅವನನ್ನು ಕೊಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ಯೆಹೋವನು ಕಾಯಿನನಿಗೆ, “ನಿನ್ನ ತಮ್ಮನಾದ ಹೇಬೆಲನು ಎಲ್ಲಿ?” ಎಂದು ಕೇಳಲು ಅವನು, “ನಾನರಿಯೆ, ನನ್ನ ತಮ್ಮನಿಗೆ ನಾನೇನು ಕಾವಲುಗಾರನೋ?” ಎಂದು ಉತ್ತರ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ಅದಕ್ಕೆ ಯೆಹೋವನು, “ನೀನು ಏನು ಮಾಡಿದೆ? ನಿನ್ನ ತಮ್ಮನ ರಕ್ತವು ಭೂಮಿಯ ಕಡೆಯಿಂದ ಕೂಗಿ ನನಗೆ ಮೊರೆಯಿಡುತ್ತಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ಈಗ ನೀನು ನಿನ್ನ ಕೈಯಿಂದ ಸುರಿಸಿದ, ನಿನ್ನ ತಮ್ಮನ ರಕ್ತದಿಂದ ನೆನೆದ ಈ ಭೂಮಿಯಿಂದ ನಿನಗೆ ಶಾಪ ಬಂತು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ನೀನು ಭೂಮಿಯನ್ನು ವ್ಯವಸಾಯ ಮಾಡಿದರೂ, ಅದು ಇನ್ನು ಮುಂದೆ ನಿನಗೆ ಫಲಕೊಡುವುದಿಲ್ಲ. ನೀನು ಭೂಲೋಕದಲ್ಲಿ ಅಲೆದಾಡುವವನು ದೇಶ ಭ್ರಷ್ಟನೂ ಆಗಿರುವಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ಆಗ ಕಾಯಿನನು ಯೆಹೋವನಿಗೆ, “ನನ್ನ ಅಪರಾಧದ ಫಲ ಸಹಿಸಲಾರದಷ್ಟಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ಇಗೋ, ನೀನು ಈ ಹೊತ್ತು ನನ್ನನ್ನು ಸ್ವದೇಶದಿಂದ ಓಡಿಸಿ ಬಿಟ್ಟಿದ್ದೀಯಲ್ಲಾ! ನಿನ್ನ ಸಮ್ಮುಖದಿಂದ ಮರೆಯಾಗಿರುವೆನು. ಆದ್ದರಿಂದ ನಾನು ಭೂಮಿಯಲ್ಲಿ ಅಲೆಮಾರಿಯಾಗಿ ದೇಶಭ್ರಷ್ಟನೂ ಆಗಬೇಕಾಯಿತು; ಇದಲ್ಲದೆ ನನ್ನನ್ನು ಕಂಡವರು ನನ್ನನ್ನು ಕೊಲ್ಲುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ಅದಕ್ಕೆ ಯೆಹೋವನು, “ಕಾಯಿನನ ಪ್ರಾಣವನ್ನು ತೆಗೆದವನಿಗೆ ಏಳರಷ್ಟು ಪ್ರತಿದಂಡನೆಯಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ಕಾಯಿನನನ್ನು ಕಂಡವರು ಕೊಲ್ಲದ ಹಾಗೆ ಯೆಹೋವನು ಅವನ ಮೇಲೆ ಒಂದು ಗುರುತನ್ನು ಇಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ಆಗ ಕಾಯಿನನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಟು ಹೋಗಿ ಏದೆನ್ ಪೂರ್ವದಲ್ಲಿದ್ದ ನೋದ್ ಎಂಬ ದೇಶದಲ್ಲಿ ನೆಲೆಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ಕಾಯಿನನು ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಸಂಗಮಿಸಲು ಅವಳು ಗರ್ಭಿಣಿಯಾಗಿ ಹನೋಕನನ್ನು ಹೆತ್ತಳು. ಇದಲ್ಲದೆ ಕಾಯಿನನು ಒಂದು ಊರನ್ನು ಕಟ್ಟಿ ಅದಕ್ಕೆ ಹನೋಕ್ ಎಂದು ತನ್ನ ಮಗನ ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ಹನೋಕನಿಂದ ಈರಾದನು ಹುಟ್ಟಿದನು. ಈರಾದನು ಮೆಹೂಯಾಯೇಲನನ್ನು ಪಡೆದನು; ಮೆಹೂಯಾಯೇಲನು ಮೆತೂಷಾಯೇಲನನ್ನು ಪಡೆದನು; ಮೆತೂಷಾಯೇಲನು ಲೆಮೆಕನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ಲೆಮೆಕನು ಆದಾ, ಚಿಲ್ಲಾ ಎಂಬ ಇಬ್ಬರು ಹೆಂಡತಿಯರನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ಆದಾಳು ಯಾಬಾಲನನ್ನು ಹೆತ್ತಳು; ದನಕರುಗಳನ್ನು ಸಾಕುತ್ತಾ ಗುಡಾರಗಳಲ್ಲಿ ವಾಸಿಸುವವರೆಲ್ಲರ ಮೂಲ ಪುರುಷನು ಇವನೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ಇವನ ತಮ್ಮನ ಹೆಸರು ಯೂಬಾಲನು; ಇವನು ಕಿನ್ನರಿ ಮತ್ತು ಕೊಳಲುಗಳನ್ನು ನುಡಿಸುವವರ ಮೂಲ ಪುರುಷನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ಚಿಲ್ಲಾ ಎಂಬುವವಳು ತೂಬಲ್ ಕಾಯಿನನನ್ನು ಹೆತ್ತಳು. ಇವನು ಕಬ್ಬಿಣ ಮತ್ತು ತಾಮ್ರದ ಆಯುಧಗಳನ್ನು ಮಾಡುವ ಕುಲುಮೆಗಾರರಿಗೆ ಮೂಲ ಪುರುಷ. ತೂಬಲ್ ಕಾಯಿನನ ತಂಗಿಯ ಹೆಸರು ನಯಮಾ. ");
INSERT INTO kanirv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ಲೆಮೆಕನು ತನ್ನ ಹೆಂಡತಿಯರಿಗೆ ಹೀಗೆಂದನು; “ಆದಾ, ಚಿಲ್ಲಾ, ನನ್ನ ಮಾತಿಗೆ ಕಿವಿಕೊಡಿರಿ; ಲೆಮೆಕನ ಹೆಂಡತಿಯರೇ, ನಾನು ಹೇಳುವುದನ್ನು ಗಮನಿಸಿರಿ. ನನಗೆ ಗಾಯ ಮಾಡಿದ ಒಬ್ಬ ಮನುಷ್ಯನನ್ನು ಕೊಂದೆನು; ನನ್ನನ್ನು ಹೊಡೆದ ಒಬ್ಬ ಪ್ರಾಯಸ್ಥನನ್ನು ಹತಮಾಡಿದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ಕಾಯಿನನನ್ನು ಕೊಂದವನಿಗೆ ಏಳರಷ್ಟು ಪ್ರತಿದಂಡನೆ ಬರುವುದಾದರೆ, ಲೆಮೆಕನನ್ನು ಹೊಡೆಯುವವನಿಗೆ ಎಪ್ಪತ್ತೇಳರಷ್ಟಾಗುವುದು ಅಲ್ಲವೇ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ಆದಾಮನು ತಿರುಗಿ ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಸಂಗಮಿಸಲು ಆಕೆ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತು, “ಕಾಯಿನನು ಕೊಂದು ಹಾಕಿದ ಹೇಬೆಲನಿಗೆ ಬದಲಾಗಿ ದೇವರು ನನಗೆ ಬೇರೊಬ್ಬ ಮಗನನ್ನು ಕೊಟ್ಟನು” ಎಂದು, ಆ ಮಗುವಿಗೆ “ಸೇತ್” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ತರುವಾಯ ಸೇತನು ಮಗನನ್ನು ಪಡೆದು ಅವನಿಗೆ, “ಎನೋಷ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ಜನರು, “ಯೆಹೋವ” ಎಂಬ ಹೆಸರನ್ನು ಹೇಳಿಕೊಂಡು ಆರಾಧಿಸುವುದಕ್ಕೆ ಅಂದಿನಿಂದ ಪ್ರಾರಂಭಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ಆದಾಮನ ವಂಶದವರ ದಾಖಲೆ: ದೇವರು ಸೃಷ್ಟಿಕಾಲದಲ್ಲಿ ಮನುಷ್ಯನನ್ನು ತನ್ನ ಹೋಲಿಕೆಗನುಸಾರವಾಗಿ ಸೃಷ್ಟಿ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ಅವರನ್ನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣಾಗಿ ಉಂಟು ಮಾಡಿದನು. ಇದಲ್ಲದೆ, ಅವರನ್ನು ಸೃಷ್ಟಿಸಿದ ದಿನದಲ್ಲಿ, ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ ಅವರಿಗೆ “ಮನುಷ್ಯ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ಆದಾಮನು ನೂರಮೂವತ್ತು ವರ್ಷದವನಾದಾಗ, ರೂಪದಲ್ಲಿ ತನ್ನ ಹೋಲಿಕೆಗೆ ಸರಿಯಾದ ಮಗನನ್ನು ಪಡೆದು ಅವನಿಗೆ ಸೇತನೆಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ಸೇತನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಆದಾಮನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಎಂಟುನೂರು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ಆದಾಮನು ಒಟ್ಟು ಒಂಭೈನೂರ ಮೂವತ್ತು ವರ್ಷ ಬದುಕಿ ನಂತರ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ಸೇತನು ನೂರ ಐದು ವರ್ಷದವನಾದಾಗ, ಎನೋಷನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ಎನೋಷನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಸೇತನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು, ಎಂಟುನೂರ ಏಳು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ಸೇತನು ಒಟ್ಟು ಒಂಭೈನೂರ ಹನ್ನೆರಡು ವರ್ಷ ಬದುಕಿ ನಂತರ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ಎನೋಷನು ತೊಂಭತ್ತು ವರ್ಷದವನಾದಾಗ, ಕೇನಾನನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ಕೇನಾನನು ಹುಟ್ಟಿದ ಮೇಲೆ ಎನೋಷನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಎಂಟುನೂರ ಹದಿನೈದು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ಎನೋಷನು ಒಟ್ಟು ಒಂಭೈನೂರ ಐದು ವರ್ಷ ಬದುಕಿ ನಂತರ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ಕೇನಾನನು ಎಪ್ಪತ್ತು ವರ್ಷದವನಾದಾಗ, ಮಹಲಲೇಲನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ಮಹಲಲೇಲನು ಹುಟ್ಟಿದ ಮೇಲೆ ಕೇನಾನನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಎಂಟುನೂರ ನಲ್ವತ್ತು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ಕೇನಾನನು ಒಟ್ಟು ಒಂಭೈನೂರ ಹತ್ತು ವರ್ಷ ಬದುಕಿ ನಂತರ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ಮಹಲಲೇಲನು ಅರವತ್ತೈದು ವರ್ಷದವನಾದಾಗ ಯೆರೆದನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ಯೆರೆದನು ಹುಟ್ಟಿದ ಮೇಲೆ ಮಹಲಲೇಲನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಎಂಟುನೂರ ಮೂವತ್ತು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ಮಹಲಲೇಲನು ಒಟ್ಟು ಎಂಟುನೂರ ತೊಂಭತ್ತೈದು ವರ್ಷ ಬದುಕಿ ನಂತರ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ಯೆರೆದನು ನೂರ ಅರುವತ್ತೆರಡು ವರ್ಷದವನಾದಾಗ ಹನೋಕನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ಹನೋಕನು ಹುಟ್ಟಿದ ಮೇಲೆ ಯೆರೆದನು ಎಂಟುನೂರು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ಯೆರೆದನು ಒಟ್ಟು ಒಂಭೈನೂರ ಅರುವತ್ತೆರಡು ವರ್ಷ ಬದುಕಿ ನಂತರ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ಹನೋಕನು ಅರುವತ್ತೈದು ವರ್ಷದವನಾದಾಗ ಮೆತೂಷೆಲಹನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ಮೆತೂಷೆಲಹನು ಹುಟ್ಟಿದ ಮೇಲೆ ಹನೋಕನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ದೇವರ ಅನ್ಯೋನ್ಯತೆಯಲ್ಲಿ ಮುನ್ನೂರು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ಹನೋಕನು ಬದುಕಿದ ಒಟ್ಟು ಕಾಲ ಮುನ್ನೂರ ಅರುವತ್ತೈದು ವರ್ಷಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ಹನೋಕನು ದೇವರೊಂದಿಗೆ ಅನ್ಯೋನ್ಯವಾಗಿ ನಡೆದುಕೊಳ್ಳುತ್ತಾ ಇರುವಾಗ ದೇವರು ಅವನನ್ನು ಕರೆದುಕೊಂಡ ಕಾರಣ ಕಣ್ಮರೆಯಾಗಿ ಕಾಣದೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ಮೆತೂಷೆಲಹನು ನೂರ ಎಂಭತ್ತೇಳು ವರ್ಷದವನಾದಾಗ ಲೆಮೆಕನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ಲೆಮೆಕನು ಹುಟ್ಟಿದ ಮೇಲೆ ಮೆತೂಷೆಲಹನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಏಳುನೂರ ಎಂಭತ್ತೆರಡು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ಮೆತೂಷೆಲಹನು ಒಟ್ಟು ಒಂಭೈನೂರ ಅರುವತ್ತೊಂಭತ್ತು ವರ್ಷ ಬದುಕಿ ನಂತರ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ಲೆಮೆಕನು ನೂರ ಎಂಭತ್ತೆರಡು ವರ್ಷದವನಾದಾಗ ಒಬ್ಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ಅವನಿಗೆ “ನೋಹ” ಎಂದು ಹೆಸರಿಟ್ಟು, “ಯೆಹೋವನು ಶಾಪಕೊಟ್ಟ ಭೂಮಿಯಲ್ಲಿ ನಾವು ಕೈಕೆಸರಾಗಿಸಿಕೊಂಡು ಅನುಭವಿಸುತ್ತಿರುವ ಶ್ರಮೆಗೆ ಈ ಮಗನಿಂದ ಆದರಣೆ ಸಿಕ್ಕುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ನೋಹನು ಹುಟ್ಟಿದ ಮೇಲೆ ಲೆಮೆಕನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಐನೂರ ತೊಂಭತ್ತೈದು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ಲೆಮೆಕನು ಒಟ್ಟು ಏಳುನೂರ ಎಪ್ಪತ್ತೇಳು ವರ್ಷ ಬದುಕಿ ನಂತರ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ನೋಹನು ಐನೂರು ವರ್ಷದವನಾದಾಗ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್ ಎಂಬ ಮೂರು ಮಂದಿ ಗಂಡು ಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ಭೂಮಿಯ ಮೇಲೆ ಮನುಷ್ಯರ ಸಂಖ್ಯೆ ಹೆಚ್ಚಾಯಿತು. ಇವರಿಗೆ ಹುಟ್ಟಿದ ಹೆಣ್ಣುಮಕ್ಕಳು ");
INSERT INTO kanirv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ಸೌಂದರ್ಯವುಳ್ಳವರಾಗಿರುವುದನ್ನು ನೋಡಿ ದೇವಪುತ್ರರು ತಮಗೆ ಇಷ್ಟವಾದವರನ್ನು ಹೆಂಡತಿಯರನ್ನಾಗಿ ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ಆಗ ಯೆಹೋವನು, “ನನ್ನ ಆತ್ಮವು ಮನುಷ್ಯರಲ್ಲಿ ಶಾಶ್ವತವಾಗಿ ಹೆಣಗಲು ಸಾಧ್ಯವಿಲ್ಲ; ಏಕೆಂದರೆ ಅವರು ರಕ್ತಮಾಂಸ ಹೊಂದಿರುವ ಮರ್ತ್ಯರೇ. ಅವರು ನೂರ ಇಪ್ಪತ್ತು ವರ್ಷ ಬದುಕುವರು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ಅನಂತರ ದೇವಪುತ್ರರು ಮನುಷ್ಯ ಪುತ್ರಿಯರೊಂದಿಗೆ ಸಂಗಮಿಸಿದಾಗ ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ಆ ಕಾಲದಿಂದಲೂ ಅದಾದ ನಂತರವೂ ಜಗದಲ್ಲಿ ನೆಫೀಲಿಯರು ಇದ್ದರು. ಇವರೇ ಪೂರ್ವಕಾಲದಲ್ಲಿ ಪ್ರಸಿದ್ಧರಾಗಿದ್ದ ಪರಾಕ್ರಮಶಾಲಿಗಳು ಎಂದು ಹೆಸರಾದವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ಮನುಷ್ಯರ ಕೆಟ್ಟತನವು ಭೂಮಿಯ ಮೇಲೆ ಹೆಚ್ಚಾಗಿರುವುದನ್ನೂ, ಅವರು ತಮ್ಮ ಹೃದಯದಲ್ಲಿ ಯೋಚಿಸುವುದೆಲ್ಲವು ಯಾವಾಗಲೂ ಕೆಟ್ಟ ಆಲೋಚನೆಗಳನ್ನೇ ಮಾಡುತ್ತಿರುವುದನ್ನು ಯೆಹೋವನು ನೋಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ಯೆಹೋವನು ಭೂಮಿಯ ಮೇಲೆ ಮನುಷ್ಯರನ್ನು ಉಂಟುಮಾಡಿದ್ದಕ್ಕೆ ವ್ಯಥೆಪಟ್ಟು, ತನ್ನ ಹೃದಯದಲ್ಲಿ ನೊಂದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ಇದಲ್ಲದೆ ಯೆಹೋವನು, “ನಾನು ಸೃಷ್ಟಿಸಿದ ಮನುಷ್ಯ ಜಾತಿಯನ್ನು ಭೂಮಿಯ ಮೇಲಿನಿಂದ ಅಳಿಸಿಬಿಡುವೆನು; ಮನುಷ್ಯರೊಂದಿಗೆ ಸಕಲ ಕಾಡುಮೃಗ, ಕ್ರಿಮಿ, ಕೀಟ, ಪಕ್ಷಿಗಳನ್ನೂ ನಾಶ ಮಾಡುವೆನು. ನಾನು ಅವರನ್ನು ಸೃಷ್ಟಿಮಾಡಿದ್ದಕ್ಕೆ ದುಃಖವಾಗುತ್ತಿದೆ” ಎಂದು ದುಃಖಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ಆದರೆ ನೋಹನ ನಡವಳಿಕೆ ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚುಗೆಯಾದುದರಿಂದ ನೋಹನಿಗೆ ಯೆಹೋವನ ದಯೆ ದೊರಕಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ನೋಹನ ಚರಿತ್ರೆ: ನೋಹನು ಸತ್ಯವಂತನೂ ಎಲ್ಲಾ ಜನರಲ್ಲಿ ನೀತಿವಂತನು ಆಗಿದ್ದನು; ಅವನು ದೇವರೊಂದಿಗೆ ಅನ್ಯೋನ್ಯವಾಗಿ ನಡೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ನೋಹನು ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್ ಎಂಬ ಮೂರು ಮಂದಿ ಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ಭೂಲೋಕದವರು ದೇವರ ದೃಷ್ಟಿಯಲ್ಲಿ ಕೆಟ್ಟ ನಡತೆಯಿಂದ ದೋಷಿಗಳಾಗಿದ್ದರು. ಹಿಂಸೆ ಮತ್ತು ಅನ್ಯಾಯ ಭೂಮಿಯನ್ನು ತುಂಬಿಕೊಂಡಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ದೇವರು ಭೂಮಿಯನ್ನು ನೋಡಿದಾಗ ಅದು ಕೆಟ್ಟುಹೋಗಿ ಕಲುಷಿತಗೊಂಡಿತ್ತು. ಭೂನಿವಾಸಿಗಳೆಲ್ಲರೂ ತಮ್ಮ ನಡವಳಿಕೆಯನ್ನು ಕೆಡಿಸಿಕೊಂಡಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ಆಗ ದೇವರು ನೋಹನಿಗೆ, “ಎಲ್ಲಾ ಮನುಷ್ಯರಿಗೆ ಅಂತ್ಯವನ್ನು ತೀರ್ಮಾನಿಸಿದ್ದೇನೆ; ಭೂಲೋಕವು ಅನ್ಯಾಯದಿಂದಲೂ ಹಿಂಸೆಯಿಂದಲೂ ತುಂಬಿದೆ; ನಾನು ಭೂಮಿಯೊಂದಿಗೆ ಅವರನ್ನೂ ಅಳಿಸಿ ಬಿಡುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ನೀನು ನಿನಗೋಸ್ಕರ ತುರಾಯಿ ಮರದಿಂದ ನಾವೆಯನ್ನು ಮಾಡಿಕೋ; ಅದರಲ್ಲಿ ತುಂಬ ಕೋಣೆಗಳು ಇರಬೇಕು; ಒಳಕ್ಕೂ ಹೊರಕ್ಕೂ ರಾಳವನ್ನು ಹಚ್ಚು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ನೀನು ಅದನ್ನು ಮಾಡಬೇಕಾದ ವಿಧಾನ ಹೇಗೆಂದರೆ, ಅದು ಮುನ್ನೂರು ಮೊಳ ಉದ್ದವೂ, ಐವತ್ತು ಮೊಳ ಅಗಲವೂ, ಮೂವತ್ತು ಮೊಳ ಎತ್ತರವೂ ಉಳ್ಳದ್ದಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ಅದರ ಚಾವಣಿಯ ಕೆಳಗೆ ಸುತ್ತಲೂ ಒಂದು ಮೊಳ ಎತ್ತರದ ಕಿಟಕಿಯನ್ನು ಮಾಡಬೇಕು; ಪಕ್ಕದಲ್ಲಿ ಬಾಗಿಲನ್ನಿಡಬೇಕು. ನಾವೆಯಲ್ಲಿ ಒಂದರ ಮೇಲೆ ಒಂದಾಗಿ ಮೂರು ಅಂತಸ್ತುಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ನಾನಂತೂ ಭೂಮಿಯ ಮೇಲೆ ಜಲಪ್ರಳಯವನ್ನು ಬರಮಾಡಿ ಆಕಾಶದ ಕೆಳಗಿರುವ ಸಕಲಪ್ರಾಣಿಗಳನ್ನೂ ನಾಶಮಾಡುವೆನು; ಭೂಮಿಯಲ್ಲಿರುವ ಸಮಸ್ತವೂ ಲಯವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","“ಆದರೆ ನಿನ್ನೊಂದಿಗೆ ನಾನು ಒಂದು ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡುತ್ತೇನೆ. ನೀನೂ ನಿನ್ನ ಹೆಂಡತಿ, ಮಕ್ಕಳು, ಸೊಸೆಯರು ಸಹಿತವಾಗಿ ನಾವೆಯಲ್ಲಿ ಸೇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ಇದಲ್ಲದೆ ಜೀವಿಗಳ ಪ್ರತಿ ಜಾತಿಯಲ್ಲಿಯೂ ಒಂದು ಗಂಡು ಒಂದು ಹೆಣ್ಣು ಹೀಗೆ ಎರಡೆರಡನ್ನು ನಾವೆಯಲ್ಲಿ ಸೇರಿಸಿ, ನಿನ್ನೊಂದಿಗೆ ಉಳಿಸಿ ಕಾಪಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ಪಶು, ಪಕ್ಷಿ, ಕಾಡುಮೃಗ, ಕ್ರಿಮಿ, ಕೀಟ ಇವುಗಳ ಸಕಲ ಜಾತಿಗಳಲ್ಲಿಯೂ ಎರಡೆರಡು ಬದುಕುವುದಕ್ಕಾಗಿ ನಿನ್ನ ಬಳಿಗೆ ಬರುವವು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ನಿನಗೂ ಅವುಗಳಿಗೂ ಪೋಷಣೆಯಾಗುವಂತೆ ಸಕಲ ವಿಧವಾದ ಆಹಾರ ಪದಾರ್ಥಗಳನ್ನು ನಿನ್ನ ಬಳಿಯಲ್ಲಿ ಕೂಡಿಸಿಟ್ಟುಕೊಳ್ಳಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ದೇವರು ಅಪ್ಪಣೆಕೊಟ್ಟ ಪ್ರಕಾರವೇ ನೋಹನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ಆಗ ಯೆಹೋವನು ನೋಹನಿಗೆ, “ನೀನೂ ನಿನ್ನ ಮನೆಯವರೆಲ್ಲರೂ ನಾವೆಯಲ್ಲಿ ಸೇರಿರಿ; ಈಗಿರುವ ಮನುಷ್ಯ ಸಂತತಿಯಲ್ಲಿ ನೀನೊಬ್ಬನೇ ನನ್ನ ಮುಂದೆ ನೀತಿಯಿಂದ ನಡೆಯುವುದನ್ನು ನೋಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ಎಲ್ಲಾ ಶುದ್ಧ ಪಶುಗಳಲ್ಲಿ ಏಳೇಳು ಗಂಡುಹೆಣ್ಣುಗಳನ್ನು ಶುದ್ಧವಲ್ಲದ ಪಶುಗಳಲ್ಲಿ ಎರಡೆರಡು ಗಂಡುಹೆಣ್ಣುಗಳನ್ನೂ ನಿನ್ನೊಂದಿಗೆ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ಪಕ್ಷಿಗಳಲ್ಲಿಯೂ ಏಳೇಳು ಗಂಡು ಹೆಣ್ಣುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಹೀಗೆ ಆಯಾ ಜಾತಿಯನ್ನು ಭೂಮಿಯ ಮೇಲೆ ಉಳಿಸಿ ಕಾಪಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ಏಳು ದಿನಗಳ ನಂತರ ನಾನು ಭೂಮಿಯ ಮೇಲೆ ನಲ್ವತ್ತು ದಿನ ಹಗಲಿರುಳು ಮಳೆಯನ್ನು ಸುರಿಸಿ, ನಾನು ಸೃಷ್ಟಿಮಾಡಿದ ಜೀವರಾಶಿಗಳನ್ನೆಲ್ಲಾ ಭೂಮಿಯ ಮೇಲಿನಿಂದ ನಾಶಮಾಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೆಲ್ಲಾ ನೋಹನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ಭೂಮಿಯ ಮೇಲೆ ಜಲಪ್ರಳಯವುಂಟಾದಾಗ ನೋಹನು ಆರುನೂರು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ಆಗ ನೋಹನು ಪ್ರಳಯದಿಂದ ತಪ್ಪಿಸಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಹೆಂಡತಿ, ಮಕ್ಕಳು, ಸೊಸೆಯರು ಸಹಿತವಾಗಿ ನಾವೆಯಲ್ಲಿ ಸೇರಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ದೇವರು ನೋಹನಿಗೆ ಅಪ್ಪಣೆಕೊಟ್ಟಂತೆ ಶುದ್ಧ, ಅಶುದ್ಧ, ಪಶು ಪಕ್ಷಿಗಳಲ್ಲಿಯೂ ಕ್ರಿಮಿಕೀಟಗಳಲ್ಲಿಯೂ ");
INSERT INTO kanirv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ಗಂಡು ಹೆಣ್ಣುಗಳು ಜೋಡಿ ಜೋಡಿಯಾಗಿ ಬಂದು ದೇವರ ಅಪ್ಪಣೆಯಂತೆ ನೋಹನ ನಾವೆಯಲ್ಲಿ ಸೇರಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ಆ ಏಳು ದಿನಗಳಾದ ನಂತರ ಜಲಪ್ರಳಯವು ಭೂಮಿ ಮೇಲೆ ಬಂತು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ನೋಹನ ಜೀವಮಾನದ ಆರುನೂರು ವರ್ಷದ ಎರಡನೆಯ ತಿಂಗಳಿನ ಹದಿನೇಳನೆಯ ದಿನದಲ್ಲಿ ಭೂಮಿಯ ಕೆಳಗಿರುವ ಸಾಗರದ ಒರತೆಗಳು ತೆರೆದುಕೊಂಡವು; ಆಕಾಶದ ತೂಬುಗಳೂ ತೆರೆದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ನಲ್ವತ್ತು ದಿನ ಹಗಲಿರುಳು ಭೂಮಿಯ ಮೇಲೆ ಬಿರುಮಳೆ ಸುರಿಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ಆ ದಿನದಲ್ಲಿ ನೋಹನೂ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತರೆಂಬ ಅವನ ಮಕ್ಕಳು, ಅವನ ಹೆಂಡತಿಯೂ ಮೂರು ಮಂದಿ ಸೊಸೆಯರೂ ನಾವೆಯಲ್ಲಿ ಸೇರಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ಎಲ್ಲಾ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಅಂದರೆ ಸಕಲ ಜಾತಿಯ ಮೃಗ, ಪಶು, ಕ್ರಿಮಿಕೀಟಗಳಲ್ಲಿಯೂ ಪಕ್ಷಿ ಮೊದಲಾದ ರೆಕ್ಕೆಯಿರುವ ಎಲ್ಲಾ ಜೀವಿಗಳಲ್ಲಿಯೂ ");
INSERT INTO kanirv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ಎರಡೆರಡು ತಮ್ಮ ತಮ್ಮ ಜಾತಿಗನುಸಾರವಾಗಿ ನೋಹನ ಬಳಿಗೆ ಬಂದು ನಾವೆಯಲ್ಲಿ ಸೇರಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ದೇವರು ನೋಹನಿಗೆ ಅಪ್ಪಣೆ ಕೊಟ್ಟಂತೆ ಎಲ್ಲಾ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಒಂದು ಗಂಡು ಒಂದು ಹೆಣ್ಣು ಈ ಮೇರೆಗೆ ಸೇರಿದವು. ಯೆಹೋವನು ನೋಹನನ್ನು ಒಳಗೆ ಇಟ್ಟು ಬಾಗಿಲನ್ನು ಮುಚ್ಚಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ಜಲಪ್ರಳಯವು ನಲ್ವತ್ತು ದಿನ ಭೂಮಿಯ ಮೇಲೆ ಬಂದು ನೀರು ಹೆಚ್ಚುತ್ತಾ ನಾವೆಯನ್ನು ಮೇಲಕ್ಕೆ ಎತ್ತಲು ಅದು ನೀರಿನ ಮೇಲೆ ತೇಲಾಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ನೀರು ಪ್ರಬಲವಾಗಿ ಭೂಮಿಯ ಮೇಲೆ ಹೆಚ್ಚಲು ನಾವೆಯು ಅದರ ಮೇಲೆ ಚಲಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ನೀರು ಭೂಮಿಯ ಮೇಲೆ ಅತ್ಯಧಿಕವಾಗಿ ಪ್ರಬಲವಾಗಿದ್ದರಿಂದ ಆಕಾಶಮಂಡಲದ ಕೆಳಗಿರುವ ಎಲ್ಲಾ ದೊಡ್ಡ ಬೆಟ್ಟಗಳೂ ಮುಚ್ಚಿಹೋದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ನೀರು ಆ ಬೆಟ್ಟಗಳಿಂತಲೂ ಹದಿನೈದು ಮೊಳ ಮೇಲಕ್ಕೆ ಹೆಚ್ಚಲು ಅವುಗಳು ಸಂಪೂರ್ಣ ಮುಚ್ಚಿಹೋದುದರಿಂದ, ");
INSERT INTO kanirv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ಪಶು, ಪಕ್ಷಿ, ಮೃಗ, ಕ್ರಿಮಿಕೀಟಗಳು ಮನುಷ್ಯರ ಸಹಿತವಾಗಿ ಭೂಮಿಯ ಮೇಲೆ ಚಲಿಸುವ ಸಕಲ ಭೂಜಂತುಗಳೆಲ್ಲವೂ ನಾಶವಾದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ಮೂಗಿನಿಂದ ಉಸಿರಾಡುವ ಭೂಜಂತುಗಳೆಲ್ಲವೂ ಸತ್ತವು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ಮನುಷ್ಯ ಮೊದಲುಗೊಂಡು ಪಶು, ಪಕ್ಷಿ, ಕ್ರಿಮಿಕೀಟಗಳ ವರೆಗೂ ಭೂಮಿಯ ಮೇಲಿದ್ದದ್ದೆಲ್ಲಾ ನಾಶವಾಯಿತು; ನೋಹನೂ ಅವನೊಂದಿಗೆ ನಾವೆಯಲ್ಲಿದ್ದ ಜೀವಿಗಳೂ ಮಾತ್ರ ಉಳಿದುಕೊಂಡವು. ");
INSERT INTO kanirv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ಪ್ರಳಯದ ನೀರು ಭೂಮಿಯ ಮೇಲೆ ನೂರೈವತ್ತು ದಿನ ಪ್ರಬಲವಾಗಿ ನಿಂತಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ತರುವಾಯ ದೇವರು ನೋಹನನ್ನೂ ಅವನ ಸಂಗಡ ನಾವೆಯಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಮೃಗಪಶುಗಳನ್ನೂ ನೆನಪಿಗೆ ತಂದುಕೊಂಡು ಭೂಲೋಕದ ಮೇಲೆ ಗಾಳಿ ಬೀಸುವಂತೆ ಮಾಡಲಾಗಿ ನೀರು ತಗ್ಗಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ಭೂಮಿಯ ಅಡಿಯಲ್ಲಿದ್ದ ಸಾಗರದ ಸೆಲೆಗಳೂ ಆಕಾಶದ ತೂಬುಗಳೂ ಮುಚ್ಚಿಕೊಂಡವು. ಆಕಾಶದಿಂದ ಸುರಿಯುತ್ತಿದ್ದ ಮಳೆ ನಿಂತು ಹೋಯಿತು. ಭೂಮಿಯ ಮೇಲಿದ್ದ ನೀರು ಕ್ರಮೇಣವಾಗಿ ತಗ್ಗುತ್ತಾ ಬಂತು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ಹೀಗೆ ನೂರೈವತ್ತು ದಿನಗಳಾದ ಮೇಲೆ ನೀರು ಕಡಿಮೆಯಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೇಳನೆಯ ದಿನದಲ್ಲಿ ನಾವೆಯು ಅರಾರಾಟ್ ಬೆಟ್ಟದಲ್ಲಿ ನಿಂತಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ಹತ್ತನೆಯ ತಿಂಗಳಿನವರೆಗೂ ನೀರು ಕಡಿಮೆಯಾಗುತ್ತಾ ಬಂದಿತು. ಹತ್ತನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಬೆಟ್ಟಗಳ ಶಿಖರಗಳು ಕಾಣಿಸಲಾರಂಭಿಸಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ನಲ್ವತ್ತು ದಿನಗಳಾದ ಮೇಲೆ ನೋಹನು ತಾನು ಮಾಡಿದ ನಾವೆಯ ಕಿಟಕಿಯನ್ನು ತೆರೆದು ಕಾಗೆಯೊಂದನ್ನು ಹೊರಕ್ಕೆ ಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ಭೂಮಿಯ ಮೇಲಿದ್ದ ನೀರು ಒಣಗುವ ತನಕ ಆ ಕಾಗೆ ಹೋಗುತ್ತಾ ಬರುತ್ತಾ ಇತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ಹೀಗಿರಲಾಗಿ ನೀರು ಕಡಿಮೆ ಆಯಿತೋ ಇಲ್ಲವೋ ಎಂದು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕೆ ನೋಹನು ಪಾರಿವಾಳವೊಂದನ್ನು ಹೊರಕ್ಕೆ ಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ಆದರೆ ನೀರು ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಇದ್ದುದರಿಂದ ಪಾರಿವಾಳವು ಕಾಲಿಡುವುದಕ್ಕೆ ಸ್ಥಳ ಕಾಣದೆ ತಿರುಗಿ ನಾವೆಗೆ ಬಂದಿತು. ನೋಹನು ಕೈಚಾಚಿ ಅದನ್ನು ಹಿಡಿದು ನಾವೆಯಲ್ಲಿ ತನ್ನ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ಅವನು ಇನ್ನೂ ಏಳು ದಿನಗಳ ನಂತರ ಪಾರಿವಾಳವನ್ನು ತಿರುಗಿ ಹೊರಕ್ಕೆ ಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ಸಂಜೆಯಲ್ಲಿ ಆ ಪಾರಿವಾಳವು ಅವನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬರಲು, ಆಹಾ, ಅದರ ಬಾಯಲ್ಲಿ ಎಣ್ಣೆ ಮರದ ಹೊಸ ಚಿಗುರು ಇತ್ತು. ನೋಹನು ಅದನ್ನು ನೋಡಿ ನೀರು ಭೂಮಿಯ ಮೇಲಿಂದ ಇಳಿದು ಹೋಯಿತೆಂದು ತಿಳಿದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ಮತ್ತೆ ಏಳು ದಿನದ ಮೇಲೆ ಪಾರಿವಾಳವನ್ನು ಬಿಡಲು ಅದು ಅವನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬರಲೇ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ಆರುನೂರ ಒಂದನೆಯ ವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಭೂಮಿಯ ಮೇಲಿದ್ದ ನೀರು ಇಳಿದಿತ್ತು. ನೋಹನು ನಾವೆಯ ಗವಾಕ್ಷಿಯನ್ನು ತೆಗೆದು ನೋಡಲಾಗಿ, ಆಹಾ, ಭೂಮಿಯು ಪೂರ್ಣವಾಗಿ ಒಣಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ಎರಡನೆಯ ತಿಂಗಳಿನ ಇಪ್ಪತ್ತೇಳನೆಯ ದಿನದಲ್ಲಿ ಭೂಮಿ ಒಣಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ಆಗ ದೇವರು ನೋಹನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ನೀನು, ನಿನ್ನ ಹೆಂಡತಿ, ಮಕ್ಕಳು, ಸೊಸೆಯರ ಸಹಿತವಾಗಿ ನಾವೆಯನ್ನು ಬಿಟ್ಟು ಹೊರಗೆ ಬಾ; ");
INSERT INTO kanirv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ನಿನ್ನ ಬಳಿಯಲ್ಲಿರುವ ಪಶು, ಪಕ್ಷಿ, ಕ್ರಿಮಿಕೀಟ ಮುಂತಾದ ಎಲ್ಲಾ ಜೀವಿಗಳೂ ಹೊರಗೆ ಬರಲಿ; ಅವುಗಳಿಗೆ ಭೂಮಿಯ ಮೇಲೆ ಬಹು ಸಂತಾನವಾಗಲಿ; ಅವು ಅಭಿವೃದ್ಧಿಯಾಗಿ ಹೆಚ್ಚಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ನೋಹನು ಹೆಂಡತಿ ಮಕ್ಕಳು ಸೊಸೆಯರು ಸಹಿತವಾಗಿ ಹೊರಗೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ಎಲ್ಲಾ ಮೃಗಗಳು, ಪಶು ಪಕ್ಷಿಗಳು, ಕ್ರಿಮಿಕೀಟಗಳ ಸಹಿತವಾಗಿ ತಮ್ಮತಮ್ಮ ಜಾತಿಗನುಸಾರವಾಗಿ ನಾವೆಯಿಂದ ಹೊರಗೆ ಬಂದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ಆಗ ನೋಹನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿ, ಅದರ ಮೇಲೆ ಶುದ್ಧವಾದ ಪ್ರತಿ ಪಶು ಪಕ್ಷಿಗಳಿಂದ ಆಯ್ದುಕೊಂಡು ಸರ್ವಾಂಗಹೋಮ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಗಮಗಮಿಸಲು ಆತನು ಹೃದಯದೊಳಗೆ, “ಮನುಷ್ಯರ ಹೃದಯದ ಆಲೋಚನೆ ಚಿಕ್ಕಂದಿನಿಂದಲೇ ಕೆಟ್ಟದ್ದು, ಆದರೂ ನಾನು ಇನ್ನು ಮೇಲೆ ಅವರ ನಿಮಿತ್ತವಾಗಿ ಭೂಮಿಯನ್ನು ಶಪಿಸುವುದಿಲ್ಲ. ನಾನು ಎಲ್ಲಾ ಜೀವಿಗಳನ್ನೂ ಈಗ ನಾಶಮಾಡಿದಂತೆ ಇನ್ನು ಮೇಲೆ ನಾಶ ಮಾಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ಭೂಮಿಯು ಇರುವವರೆಗೆ ಬಿತ್ತುವ ಕಾಲವೂ ಕೊಯ್ಯುವ ಕಾಲವೂ ಚಳಿಯೂ, ಮಳೆಯೂ, ಬೇಸಿಗೆ ಕಾಲವೂ, ಹಿಮಕಾಲವೂ, ಹಗಲೂ, ಇರುಳೂ ಇವುಗಳ ಕ್ರಮ ನಿಂತುಹೋಗುವುದಿಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ದೇವರು ನೋಹನನ್ನೂ, ಅವನ ಮಕ್ಕಳನ್ನೂ ಆಶೀರ್ವದಿಸಿ ಅವರಿಗೆ, “ನೀವು ಬಹುಸಂತಾನವುಳ್ಳವರಾಗಿ ಹೆಚ್ಚಿರಿ; ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ತುಂಬಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಮೃಗಗಳೂ, ಆಕಾಶದ ಎಲ್ಲಾ ಪಕ್ಷಿಗಳೂ, ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಎಲ್ಲಾ ಕ್ರಿಮಿಗಳೂ, ಸಮುದ್ರದ ಮೀನುಗಳೂ ನಿಮಗೆ ಹೆದರುವವು. ನಾನು ಅವುಗಳನ್ನೆಲ್ಲಾ ನಿಮ್ಮ ಸ್ವಾಧೀನಕ್ಕೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ಭೂಮಿಯ ಮೇಲೆ ಚಲಿಸುವ ಎಲ್ಲಾ ಕ್ರಿಮಿಕೀಟಗಳೂ ನಿಮಗೆ ಆಹಾರವಾಗಿರುವವು. ನಾನು ನಿಮ್ಮ ಆಹಾರಕ್ಕೆ ಹಸಿರುಪಲ್ಯಗಳನ್ನು ನಿಮಗೆ ಕೊಟ್ಟಂತೆ ಇವುಗಳನ್ನೂ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ಆದರೆ ಮಾಂಸವನ್ನು ಅದರ ಜೀವಸತ್ವವಾದ ರಕ್ತದೊಂದಿಗೆ ನೀವು ತಿನ್ನಬಾರದು. ಏಕೆಂದರೆ ರಕ್ತದಲ್ಲಿ ಜೀವ ಇದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ಇದಲ್ಲದೆ ನಿಮ್ಮ ರಕ್ತ ಸುರಿಸಿ ಜೀವ ತೆಗೆಯುವವನಿಗೆ ಮುಯ್ಯಿತೀರಿಸುವೆನು. ಮೃಗವಾಗಿದ್ದರೆ, ಅದಕ್ಕೂ ಮುಯ್ಯಿತೀರಿಸುವೆನು. ಮನುಷ್ಯನಾಗಿದ್ದರೆ, ಹತನಾದವನು ಅವನ ಸಹೋದರನಾದುದರಿಂದ ಅವನಿಗೂ ಮುಯ್ಯಿ ತೀರಿಸುವೆನು. ನರಹತ್ಯವು ಸಹೋದರ ಹತ್ಯವಲ್ಲವೇ? ");
INSERT INTO kanirv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ದೇವರು ಮನುಷ್ಯರನ್ನು ತನ್ನ ಸ್ವರೂಪದಲ್ಲಿ ಉಂಟುಮಾಡಿದ್ದರಿಂದ ಯಾರು ಮನುಷ್ಯನ ರಕ್ತವನ್ನು ಸುರಿಸುತ್ತಾನೋ ಅವನ ರಕ್ತವನ್ನು ಮನುಷ್ಯನೇ ಸುರಿಸುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ನೀವು ಅಭಿವೃದ್ಧಿಯಾಗಿ ಹೆಚ್ಚಿರಿ; ಭೂಮಿಯ ಮೇಲೆ ನಿಮಗೆ ಬಹುಸಂತಾನವಾಗಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ಇದಲ್ಲದೆ ದೇವರು ನೋಹನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ, ");
INSERT INTO kanirv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ಕೇಳಿರಿ ನಾನು ನಿಮ್ಮೊಂದಿಗೂ, ನಿಮ್ಮ ತರುವಾಯ ನಿಮ್ಮ ಸಂತತಿಯವರೊಂದಿಗೂ, ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಳ್ಳುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ನಿಮ್ಮೊಂದಿಗೆ ನಾವೆಯಿಂದ ಹೊರಟು ಬಂದ ಪಶು ಪಕ್ಷಿ, ಮೃಗ, ಸಕಲ ಭೂಜಂತುಗಳೊಂದಿಗೂ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಾಪಿಸುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ಆ ಒಡಂಬಡಿಕೆ ಯಾವುದೆಂದರೆ, ಇನ್ನು ಮೇಲೆ ಯಾವ ಪ್ರಾಣಿಗಳೂ ಜಲಪ್ರಳಯದಿಂದ ನಾಶವಾಗುವುದಿಲ್ಲ; ಇನ್ನು ಮುಂದೆ ಭೂಮಿಯನ್ನು ಹಾಳುಮಾಡುವ ಜಲಪ್ರಳಯವು ಬರುವುದೇ ಇಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ದೇವರು ಪುನಃ ಹೇಳಿದ್ದೇನಂದರೆ, “ನಾನು ನಿಮ್ಮನ್ನೂ ನಿಮ್ಮ ಸಂಗಡ ಇರುವ ಸಮಸ್ತ ಜೀವರಾಶಿಗಳನ್ನೂ ಕುರಿತು ತಲತಲಾಂತರಗಳಲ್ಲಿಯೂ ಮಾಡುವ ಈ ಒಡಂಬಡಿಕೆಗೆ ಮೇಘಗಳಲ್ಲಿ ನಾನು ಇಟ್ಟಿರುವ ಈ ಕಾಮನಬಿಲ್ಲೇ ಗುರುತಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ನನಗೂ ಭೂಜೀವಿಗಳಿಗೂ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಗೆ ಇದೇ ಗುರುತಾಗಿರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ನಾನು ಭೂಲೋಕದ ಮೇಲೆ ಮೇಘಗಳನ್ನು ಕವಿಸುವಾಗ ಆ ಕಾಮನಬಿಲ್ಲು ಮೇಘಗಳಲ್ಲಿ ಕಂಡುಬರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ಆಗ ನಾನು ನಿಮ್ಮನ್ನೂ, ಎಲ್ಲಾ ಜೀವರಾಶಿಗಳನ್ನೂ ಕುರಿತು ಮಾಡಿದ ಒಡಂಬಡಿಕೆಯನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳುವೆನು. ಇನ್ನು ಮುಂದೆ ನೀರು ಹೆಚ್ಚಿ ಎಲ್ಲಾ ಭೂಜೀವಿಗಳನ್ನು ಹಾಳುಮಾಡುವ ಪ್ರಳಯವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ಆ ಕಾಮನಬಿಲ್ಲು ಮೇಘಗಳಲ್ಲಿ ಕಾಣಿಸುವಾಗ ನಾನು ಅದನ್ನು ನೋಡಿ ದೇವರಾದ ನನಗೂ ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಜೀವಜಂತುಗಳಿಗೂ ಆದ ಶಾಶ್ವತವಾದ ಒಡಂಬಡಿಕೆಯನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳುವೆನು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ಮತ್ತು ದೇವರು ನೋಹನಿಗೆ, “ನನಗೂ ಎಲ್ಲಾ ಭೂಜೀವಿಗಳಿಗೂ ಆದ ಒಡಂಬಡಿಕೆಗೆ ಇದೇ ಗುರುತು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ನಾವೆಯಿಂದ ಹೊರಟುಬಂದ ನೋಹನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್. ಹಾಮನು ಕಾನಾನನ ತಂದೆಯು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ಈ ಮೂವರು ನೋಹನ ಮಕ್ಕಳು. ಇವರಿಂದಲೇ ಜನರು ಉತ್ಪತ್ತಿಯಾಗಿ ಭೂಮಿಯಲ್ಲೆಲ್ಲಾ ಹರಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ನೋಹನು ವ್ಯವಸಾಯಗಾರನಾಗಿದ್ದನು; ದ್ರಾಕ್ಷಿ ತೋಟ ಮಾಡುವುದನ್ನು ಮೊದಲು ಪ್ರಾರಂಭಿಸಿದವನು ಇವನೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ಒಂದು ದಿನ ಅವನು ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿದು ಅಮಲೇರಿ ತನ್ನ ಗುಡಾರದಲ್ಲಿ ಬೆತ್ತಲೆಯಾಗಿ ಬಿದ್ದಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ಕಾನಾನನ ತಂದೆಯಾದ ಹಾಮನು ತಂದೆಯು ಬೆತ್ತಲೆಯಾಗಿರುವುದನ್ನು ಕಂಡು, ಹೊರಗಿದ್ದ ತನ್ನ ಸಹೋದರರಾದ ಶೇಮ್ ಮತ್ತು ಯೆಫೆತರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ಆಗ ಶೇಮ್ ಮತ್ತು ಯೆಫೆತರು ಕಂಬಳಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ತಮ್ಮಿಬ್ಬರ ಬೆನ್ನಿನ ಮೇಲೆ ಹಾಕಿಕೊಂಡು ಹಿಂಭಾಗವಾಗಿ ನಡೆದು ತಂದೆಗೆ ಹೊದಿಸಿ ಅವನ ಬೆತ್ತಲೆತನವನ್ನು ಮುಚ್ಚಿದರು. ಅವರು ಹಿಮ್ಮುಖರಾಗಿದ್ದುದ್ದರಿಂದ ತಂದೆಯು ಬೆತ್ತಲೆಯಾಗಿದ್ದದ್ದನ್ನು ನೋಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ನೋಹನು ದ್ರಾಕ್ಷಾರಸದ ಅಮಲಿನಿಂದ ಎಚ್ಚೆತ್ತು ಕಿರಿಯ ಮಗನು ಮಾಡಿದ್ದನ್ನು ತಿಳಿದು, ");
INSERT INTO kanirv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“ಕಾನಾನನು ಶಾಪಗ್ರಸ್ತನಾಗಲಿ. ಅವನು ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ ದಾಸಾನುದಾಸನಾಗಲಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ಅವನು ಇನ್ನೂ ನುಡಿದದ್ದೇನೆಂದರೆ, “ಶೇಮನ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಸ್ತೋತ್ರವಾಗಲಿ; ಕಾನಾನನು ಅವರಿಗೆ ದಾಸನಾಗಿರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ಯೆಫೆತನ ಮೇರೆಯನ್ನು ದೇವರು ವಿಸ್ತರಿಸಲಿ, ಅವನು ಶೇಮನ ಗುಡಾರಗಳಲ್ಲಿ ವಾಸವಾಗಿರಲಿ, ಕಾನಾನನು ಅವರಿಗೆ ದಾಸನಾಗಿರಲಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ಪ್ರಳಯವಾದ ಮೇಲೆ ನೋಹನು ಮುನ್ನೂರೈವತ್ತು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ನೋಹನು ಒಂಭೈನೂರ ಐವತ್ತು ವರ್ಷ ಬದುಕಿ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ನೋಹನ ಮಕ್ಕಳಾದ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್ ಎಂಬುವವರ ಸಂತಾನದವರ ಚರಿತ್ರೆ: ಜಲಪ್ರಳಯದ ನಂತರ ಅವರಿಗೆ ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ಯೆಫೆತನ ಸಂತಾನದವರು ಯಾರೆಂದರೆ - ಗೋಮೆರ್, ಮಾಗೋಗ್, ಮಾದಯ್, ಯಾವಾನ್, ತೂಬಲ್, ಮೆಷೆಕ್, ತೀರಾಸ್ ಎಂಬವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ಗೋಮೆರನ ಸಂತಾನದವರು - ಅಷ್ಕೆನಸ್, ರೀಫತ್, ತೋಗರ್ಮ ಎಂಬವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ಯಾವಾನನ ಸಂತಾನದವರು - ಎಲೀಷಾ, ತಾರ್ಷೀಷ್, ಕಿತ್ತೀಮ್, ದೋದಾ ಎಂಬ ಸ್ಥಳದವರು. ಇವರು ಸಮುದ್ರದ ರೇವು ಪ್ರದೇಶಗಳಲ್ಲಿ ಹರಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ದೇಶ, ಭಾಷೆ, ಕುಲ, ಜನಾಂಗಗಳ ಪ್ರಕಾರ ಇವರೇ ಯೆಫೆತನ ವಂಶದವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ಹಾಮನ ಸಂತಾನದವರು ಯಾರೆಂದರೆ - ಕೂಷ್, ಮಿಚ್ರಯಿಮ್, ಪೂತ್, ಕಾನಾನ್ ಎಂಬುವವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ಕೂಷನ ಸಂತಾನದವರು ಯಾರೆಂದರೆ - ಸೆಬಾ, ಹವೀಲ, ಸಬ್ತಾ, ರಗ್ಮ, ಸಬ್ತಕಾ ಎಂಬವರು. ರಗ್ಮ ಸಂತಾನದವರು - ಶೆಬಾ, ದೆದಾನ್ ಎಂಬುವವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ಕೂಷನು ನಿಮ್ರೋದನನ್ನು ಪಡೆದನು. ಅವನು ಭೂಮಿಯ ಮೇಲಿನ ಮೊದಲನೆಯ ಪರಾಕ್ರಮಶಾಲಿಯಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ಯೆಹೋವನ ದೃಷ್ಟಿಯಲ್ಲಿ ನಿಮ್ರೋದನು ದಿಟ್ಟ ಬೇಟೆಗಾರನಾಗಿದ್ದನು. ಆದುದರಿಂದ “ಯೆಹೋವನು ನಿನ್ನನ್ನು ದಿಟ್ಟ ಬೇಟೆಗಾರನಾಗಿಸಲಿ” ಎಂಬ ಗಾದೆ ಇಂದಿನವರೆಗೂ ಹೇಳುವುದುಂಟು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ಶಿನಾರ್ ದೇಶದಲ್ಲಿರುವ ಬಾಬೆಲ್, ಯೆರೆಕ್, ಅಕ್ಕದ್, ಕಲ್ನೇ ಎಂಬ ಪಟ್ಟಣಗಳೇ ಅವನ ರಾಜ್ಯದ ಮೂಲ ಪಟ್ಟಣಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ಅವನು ಆ ದೇಶದಿಂದ ಹೊರಟು ಅಶ್ಶೂರ್ ದೇಶಕ್ಕೆ ಬಂದು ನಿನೆವೆ, ರೆಹೋಬೋತೀರ್, ಕೆಲಹ ಎಂಬ ಪಟ್ಟಣಗಳನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ನಿನೆವೆಗೂ ಕೆಲಹಕ್ಕೂ ಮಧ್ಯದಲ್ಲಿ ಇರುವ ರೆಸೆನ್ ಪಟ್ಟಣವನ್ನೂ ಕಟ್ಟಿಸಿದನು. ರೆಸೆನ್ ಮಹಾಪಟ್ಟಣವೆಂದು ಪ್ರಸಿದ್ಧವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ಮಿಚ್ರಯಿಮ್ಯರಿಂದ ಲೂದ್ಯರು, ಅನಾಮ್ಯರು, ಲೆಹಾಬ್ಯರು, ನಫ್ತುಹ್ಯರು, ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ಪತ್ರುಸ್ಯರು, ಕಸ್ಲುಹ್ಯರು, ಕಫ್ತೋರ್ಯರು ಫಿಲಿಷ್ಟಿಯರಿಂದ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ಕಾನಾನ್ ವಂಶದಲ್ಲಿ ಮೊದಲು ಹುಟ್ಟಿದವನು ಸೀದೋನ್; ಆ ಮೇಲೆ ಹೇತ್ ಹುಟ್ಟಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ಇದಲ್ಲದೆ ಯೆಬೂಸಿಯರು, ಅಮೋರಿಯರು, ಗಿರ್ಗಾಷಿಯರು, ");
INSERT INTO kanirv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ಹಿವ್ವಿಯರು, ಅರ್ಕಿಯರು, ಸೀನಿಯರು ಕಾನಾನನಿಂದ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ಕಾಲ ಕ್ರಮೇಣವಾಗಿ ಈ ಕಾನಾನ್ಯರ ವಂಶಸ್ಥರಾದ ಸೀನಿಯರು, ಅರ್ವಾದಿಯರು, ಚೆಮಾರಿಯರು, ಹದೋರಾಮರು, ಹಮಾತಿಯರು ಹರಡಿ ಕಾನಾನನಿಂದ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ಕಾನಾನ್ಯರ ಸೀಮೆಯು ಸೀದೋನ್ ಪಟ್ಟಣದಿಂದ ಗೆರಾರಿಗೆ ಹೋಗುವ ದಾರಿಯಲ್ಲಿರುವ ಗಾಜಾ ಪಟ್ಟಣದ ವರೆಗೂ ಮತ್ತು ಸೊದೋಮ್, ಗೊಮೋರ, ಅದ್ಮಾ, ಚೆಬೋಯಿಮ್ ಎಂಬ ಪಟ್ಟಣಗಳಿಗೆ ಹೋಗುವ ದಾರಿಯಲ್ಲಿರುವ ಲೆಷಾ ಊರಿನವರೆಗೂ ಇರುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ಕುಲ, ಭಾಷೆ, ದೇಶ, ಜನಾಂಗಗಳ ಪ್ರಕಾರ ಇವರೇ ಹಾಮನ ವಂಶದವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ಇಬ್ರಿಯರೆಲ್ಲರಿಗೆ ಮೂಲಪುರುಷನನೂ, ಯೆಫೆತನ ಅಣ್ಣನೂ ಆಗಿದ್ದ ಶೇಮನಿಗೂ ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ಶೇಮನ ಮಕ್ಕಳು - ಏಲಾಮ್, ಅಶ್ಶೂರ್, ಅರ್ಪಕ್ಷದ್, ಲೂದ್, ಅರಾಮ್ ಎಂಬವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ಅರಾಮ್ ಸಂತಾನದವರು - ಊಸ್, ಹೂಲ್, ಗೆತೆರ್, ಮಷ್ ಎಂಬವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ಅರ್ಪಕ್ಷದನಿಂದ ಶೆಲಹನೂ, ಶೆಲಹನಿಂದ ಎಬರನೂ ಹುಟ್ಟಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ಎಬರನಿಗೆ ಇಬ್ಬರು ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ಒಬ್ಬನಿಗೆ ಪೆಲೆಗೆಂಬ ಹೆಸರು; ಅವನ ಕಾಲದಲ್ಲಿ ಭೂಮಿಯು ವಿಭಾಗಿಸಲ್ಪಟ್ಟಿತ್ತು. ಅವನ ತಮ್ಮನ ಹೆಸರು ಯೊಕ್ತಾನ್. ");
INSERT INTO kanirv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ಯೊಕ್ತಾನನ ಸಂತಾನದವರು - ಅಲ್ಮೋದಾದ್, ಶೆಲೆಪ್, ಹಚರ್ಮಾವೆತ್, ಯೆರಹ, ");
INSERT INTO kanirv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ಹದೋರಾಮ್, ಊಜಾಲ್, ದಿಕ್ಲಾ, ");
INSERT INTO kanirv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ಓಬಾಲ್, ಅಬೀಮಯೇಲ್, ಶೆಬಾ, ಓಫೀರ್, ಹವೀಲ, ಯೋಬಾಬ್ ಎಂಬವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ಹದೋರಾಮ್, ಊಜಾಲ್, ದಿಕ್ಲಾ, ಓಬಾಲ್, ಅಬೀಮಯೇಲ್, ಶೆಬಾ, ಓಫೀರ್, ಹವೀಲ, ಯೋಬಾಬ್ ಈ ಕುಲಗಳೆಲ್ಲಾ ಯೊಕ್ತಾನನಿಂದ ಹುಟ್ಟಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ಇವರ ನಿವಾಸವು ಮೇಶಾ ಸೀಮೆ ಮೊದಲುಗೊಂಡು ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿರುವ ಸೆಫಾರ್ ಎಂಬ ಬೆಟ್ಟದ ವರೆಗೂ ಇತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ಕುಲ, ಭಾಷೆ, ಜನಾಂಗಗಳ ಪ್ರಕಾರ ಇವರೇ ಶೇಮನ ವಂಶದವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ಜನಾಂಗಗಳ ಸಂತತಿಯ ಪ್ರಕಾರ ಇವರೇ ನೋಹನ ವಂಶದವರು. ಜಲಪ್ರಳಯವಾದ ನಂತರ ಭೂಮಿಯ ಮೇಲೆ ಹರಡಿಕೊಂಡ ಜನಾಂಗಗಳು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ಆಗ ಭೂಲೋಕದವರೆಲ್ಲರಿಗೂ ಒಂದೇ ಭಾಷೆ; ಒಂದೇ ಮಾತು ಇತ್ತು. ಭಾಷಾಭೇದಗಳೇನೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ಜನರು ಪೂರ್ವ ದಿಕ್ಕಿಗೆ ಪ್ರಯಾಣಮಾಡುತ್ತಿರುವಾಗ ಶಿನಾರ್ ದೇಶದ ಬಯಲು ಸೀಮೆಯನ್ನು ಕಂಡು ಅಲ್ಲೇ ನೆಲೆಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","“ಅವರೆಲ್ಲರೂ ಬನ್ನಿ, ನಾವು ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡಿ, ಚೆನ್ನಾಗಿ ಸುಡೋಣ,” ಎಂದು ಅವರು ಒಬ್ಬರಿಗೊಬ್ಬರು ಮಾತನಾಡಿಕೊಂಡರು. ಅವರು ಕಲ್ಲಿಗೆ ಬದಲಾಗಿ ಇಟ್ಟಿಗೆಯನ್ನು, ಸುಣ್ಣಕ್ಕೆ ಬದಲಾಗಿ ಜೇಡಿಮಣ್ಣನ್ನು ಉಪಯೋಗಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ಅವರು, “ಬನ್ನಿರಿ, ಒಂದು ಪಟ್ಟಣವನ್ನು ಕಟ್ಟೋಣ, ಆಕಾಶವನ್ನು ಮುಟ್ಟುವ ಒಂದು ಗೋಪುರವನ್ನೂ ಕಟ್ಟಿ ದೊಡ್ಡ ಹೆಸರನ್ನು ಸಂಪಾದಿಸಿಕೊಳ್ಳೋಣ; ಹೀಗೆ ಮಾಡಿದರೆ ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಚದರಿಹೋಗುವುದಕ್ಕೆ ಆಸ್ಪದವಾಗುವುದಿಲ್ಲ” ಎಂದು ತಮ್ಮತಮ್ಮೊಳಗೆ ಮಾತನಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ಮನುಷ್ಯರು ಕಟ್ಟುತ್ತಿದ್ದ ಆ ಪಟ್ಟಣವನ್ನೂ, ಗೋಪುರವನ್ನೂ ನೋಡುವುದಕ್ಕೆ ಯೆಹೋವನು ಇಳಿದು ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ನೋಡಿದ ಮೇಲೆ ಯೆಹೋವನು, “ಇವರು ಒಂದೇ ಜನಾಂಗ; ಇವರೆಲ್ಲರಿಗೂ ಒಂದೇ ಭಾಷೆ. ಪ್ರಾರಂಭದಲ್ಲೇ ಇವರು ಇಷ್ಟು ದೊಡ್ಡ ಯೋಜನೆಯೊಂದಿಗೆ ಒಟ್ಟಾಗಿ ಕೆಲಸ ಮಾಡಲಾರಂಭಿಸಿದ್ದಾರೆ. ಇನ್ನು ಮುಂದೆ ಇವರು ಏನು ಮಾಡಲು ಉದ್ದೇಶಿಸಿದರೂ ಇವರಿಗೆ ಯಾವುದೂ ಅಸಾಧ್ಯವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ಇವರಲ್ಲಿ ಒಬ್ಬರ ಮಾತು ಒಬ್ಬರಿಗೆ ತಿಳಿಯದಂತೆ ಇವರ ಭಾಷೆಯನ್ನು ಗಲಿಬಿಲಿ ಮಾಡೋಣ ಬನ್ನಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ಯೆಹೋವನು ಅದೇ ಪ್ರಕಾರ ಅವರನ್ನು ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ಚದರಿಸಿ ಬಿಟ್ಟನು. ಅವರು ಆ ಪಟ್ಟಣ ಕಟ್ಟುವುದನ್ನು ನಿಲ್ಲಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ಸಮಸ್ತ ಲೋಕದ ಭಾಷೆಯನ್ನು ಯೆಹೋವನು ಅಲ್ಲಿ ಗಲಿಬಿಲಿ ಮಾಡಿ, ಅವರನ್ನು ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ಚದರಿಸಿದ್ದರಿಂದ ಆ ಪಟ್ಟಣಕ್ಕೆ ಬಾಬೆಲ್ (ದೇವರ ಬಾಗಿಲು) ಎಂಬ ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ಶೇಮನ ವಂಶವೃಕ್ಷ: ಜಲಪ್ರಳಯವು ಕಳೆದು ಎರಡು ವರ್ಷಗಳಾದ ಮೇಲೆ ಶೇಮನು ನೂರು ವರ್ಷದವನಾಗಿ ಅರ್ಪಕ್ಷದನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ಶೇಮನು ಅರ್ಪಕ್ಷದನನ್ನು ಪಡೆದ ಮೇಲೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಐನೂರು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ಅರ್ಪಕ್ಷದನು ಮೂವತ್ತೈದು ವರ್ಷದವನಾಗಿ ಶೆಲಹನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ಅರ್ಪಕ್ಷದನು ಶೆಲಹನನ್ನು ಪಡೆದ ಮೇಲೆ ಗಂಡು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ನಾನೂರ ಮೂರು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ಶೆಲಹನು ಮೂವತ್ತನಾಲ್ಕು ವರ್ಷದವನಾಗಿ ಎಬರನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ಶೆಲಹನು ಎಬರನನ್ನು ಪಡೆದ ಮೇಲೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ನಾನೂರ ಮೂರು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ಎಬರನು ಮೂವತ್ತನಾಲ್ಕು ವರ್ಷದವನಾಗಿ ಪೆಲೆಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ಎಬರನು ಪೆಲೆಗನನ್ನು ಪಡೆದ ಮೇಲೆ ಗಂಡು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ನಾನೂರ ಮೂವತ್ತು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ಪೆಲೆಗನು ಮೂವತ್ತು ವರ್ಷದವನಾಗಿ ರೆಗೂವನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ಪೆಲೆಗನು ರೆಗೂವನನ್ನು ಪಡೆದ ಮೇಲೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಇನ್ನೂರ ಒಂಭತ್ತು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ರೆಗೂವನು ಮೂವತ್ತೆರಡು ವರ್ಷದವನಾಗಿ ಸೆರೂಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ಸೆರೂಗನು ರೆಗೂವನನ್ನು ಪಡೆದ ಮೇಲೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಇನ್ನೂರ ಏಳು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ಸೆರೂಗನು ಮೂವತ್ತು ವರ್ಷದವನಾಗಿ ನಾಹೋರನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ಸೆರೂಗನು ನಾಹೋರನನ್ನು ಪಡೆದ ಮೇಲೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ಇನ್ನೂರು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ನಾಹೋರನು ಇಪ್ಪತ್ತೊಂಭತ್ತು ವರ್ಷದವನಾಗಿ ತೆರಹನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ನಾಹೋರ್ ತೆರಹನನ್ನು ಪಡೆದ ಮೇಲೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಪಡೆದು ನೂರ ಹತ್ತೊಂಬತ್ತು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ತೆರಹನು ಎಪ್ಪತ್ತು ವರ್ಷದವನಾಗಿ ಅಬ್ರಾಮ, ನಾಹೋರ್, ಹಾರಾನ್ ಎಂಬ ಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ತೆರಹನ ವಂಶದವರ ಚರಿತ್ರೆಯು: ತೆರಹನು ಅಬ್ರಾಮ, ನಾಹೋರ್, ಹಾರಾನ್ ಎಂಬುವರನ್ನು ಪಡೆದನು. ಹಾರಾನನು ಲೋಟನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ಹಾರಾನನು ತಾನು ಹುಟ್ಟಿದ ದೇಶದೊಳಗೆ ಕಲ್ದೀಯರ ಊರ್ ಎಂಬ ಪಟ್ಟಣದಲ್ಲಿ ತನ್ನ ತಂದೆಯಾದ ತೆರಹನ ಮುಂದೆಯೇ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ಅಬ್ರಾಮನೂ ನಾಹೋರನೂ ಮದುವೆಮಾಡಿಕೊಂಡರು. ಅಬ್ರಾಮನ ಹೆಂಡತಿಯ ಹೆಸರು ಸಾರಯಳು, ನಾಹೋರನ ಹೆಂಡತಿಯ ಹೆಸರು ಮಿಲ್ಕಾ. ಈಕೆಯು ಹಾರಾನನ ಮಗಳು; ಹಾರಾನನು ಮಿಲ್ಕಳಿಗೂ ಇಸ್ಕಳಿಗೂ ತಂದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ಸಾರಯಳು ಬಂಜೆಯಾಗಿದುದರಿಂದ ಆಕೆಗೆ ಮಕ್ಕಳಿರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ತೆರಹನು ತನ್ನ ಮಗನಾದ ಅಬ್ರಾಮನನ್ನೂ, ತನಗೆ ಮೊಮ್ಮಗನೂ, ಹಾರಾನನಿಗೆ ಮಗನೂ ಆಗಿರುವ ಲೋಟನನ್ನೂ, ತನಗೆ ಸೊಸೆಯೂ ಅಬ್ರಾಮನಿಗೆ ಹೆಂಡತಿಯೂ ಆಗಿರುವ ಸಾರಯಳನ್ನೂ ಕರೆದುಕೊಂಡು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಹೋಗಬೇಕೆಂದು ಕಲ್ದೀಯರ ಊರ್ ಎಂಬ ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟು ಅವರು ಹಾರಾನ ಪಟ್ಟಣಕ್ಕೆ ಬಂದು ಅಲ್ಲೇ ವಾಸಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ತೆರಹನು ಇನ್ನೂರ ಐದು ವರ್ಷ ಬದುಕಿ ನಂತರ ಹಾರಾನಿನಲ್ಲಿ ಸತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ, “ನೀನು, ನಿನ್ನ ಸ್ವದೇಶವನ್ನೂ, ಬಂಧುಬಳಗವನ್ನೂ, ತಂದೆಯ ಮನೆಯನ್ನೂ ಬಿಟ್ಟು ನಾನು ತೋರಿಸುವ ದೇಶಕ್ಕೆ ಹೊರಟು ಹೋಗು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ನಾನು ನಿನ್ನನ್ನು ಮಹಾ ಜನಾಂಗವಾಗುವಂತೆ ಮಾಡಿ, ಆಶೀರ್ವದಿಸಿ, ನಿನ್ನ ಹೆಸರನ್ನು ಪ್ರಖ್ಯಾತಿಗೆ ತರುವೆನು. ನೀನು ಆಶೀರ್ವಾದದ ನಿಧಿಯಾಗುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವವರನ್ನು ನಾನು ಆಶೀರ್ವದಿಸುವೆನು; ನಿನ್ನನ್ನು ಶಪಿಸುವವರನ್ನು ನಾನು ಶಪಿಸುವೆನು. ನಿನ್ನ ಮೂಲಕ ಭೂಲೋಕದ ಎಲ್ಲಾ ಜನಾಂಗಗಳಿಗೆ ಆಶೀರ್ವಾದವುಂಟಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ಯೆಹೋವನು ಹೇಳಿದ ಪ್ರಕಾರ ಅಬ್ರಾಮನು ಹೊರಟುಹೋದನು. ಲೋಟನೂ ಅವನ ಸಂಗಡ ಹೋದನು. ಅಬ್ರಾಮನು ಹಾರಾನ್ ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟು ಹೊರಟಾಗ ಎಪ್ಪತ್ತೈದು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ಅಬ್ರಾಮನು ತನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಯಳನ್ನೂ, ತನ್ನ ತಮ್ಮನ ಮಗನಾದ ಲೋಟನನ್ನೂ, ತಾನೂ ಲೋಟನೂ ಹಾರಾನಿನಲ್ಲಿ ಸಂಪಾದಿಸಿದ್ದ ಎಲ್ಲಾ ಸೊತ್ತನ್ನೂ, ದಾಸ ದಾಸಿಯರನ್ನೂ ತೆಗೆದುಕೊಂಡು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ಅಬ್ರಾಮನು ಆ ದೇಶದಲ್ಲಿ ಸಂಚರಿಸುತ್ತಾ ಶೆಕೆಮ್ ಸ್ಥಳದಲ್ಲಿರುವ ಮೋರೆ ಎಂಬ ವೃಕ್ಷದ ಬಳಿಗೆ ಬಂದನು. ಆ ಕಾಲದಲ್ಲಿ ಕಾನಾನ್ಯರು ದೇಶದಲ್ಲಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ಅಲ್ಲಿ ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ ದರ್ಶನದಲ್ಲಿ, “ನಾನು ಈ ದೇಶವನ್ನು ನಿನ್ನ ಸಂತಾನಕ್ಕೆ ಕೊಡುವೆನು” ಅಂದನು. ತನಗೆ ದರ್ಶನಕೊಟ್ಟ ಯೆಹೋವನಿಗೆ ಅಬ್ರಾಮನು ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ಅವನು ಅಲ್ಲಿಂದ ಹೊರಟು ಬೇತೇಲಿನ ಪೂರ್ವದಲ್ಲಿರುವ ಗುಡ್ಡಕ್ಕೆ ಬಂದು ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿ ಇಳಿದುಕೊಂಡನು. ಪಶ್ಚಿಮಕ್ಕೆ ಬೇತೇಲ್, ಪೂರ್ವಕ್ಕೆ ಆಯಿ ಎಂಬ ಊರುಗಳಿದ್ದವು. ಅಲ್ಲಿಯೂ ಅಬ್ರಾಮನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸಿ ಆತನ ಹೆಸರಿನಲ್ಲಿ ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ತರುವಾಯ ಅಬ್ರಾಮನು ಅಲ್ಲಿಂದ ಹೊರಟು ಕಾನಾನ್ ದೇಶದ ದಕ್ಷಿಣ ಸೀಮೆಗೆ ಪ್ರಯಾಣ ಮಾಡುತ್ತಾ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ದಕ್ಷಿಣ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಘೋರ ಕ್ಷಾಮವಿದ್ದುದರಿಂದ, ಅಬ್ರಾಮನು ಅಲ್ಲಿರದೆ, ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಕೆಲವು ಕಾಲ ಇರಬೇಕೆಂದು ಆ ಬೆಟ್ಟದ ಸೀಮೆಯಿಂದ ಇಳಿದು ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ಅವನು ಐಗುಪ್ತ ದೇಶದ ಹತ್ತಿರಕ್ಕೆ ಬಂದಾಗ ತನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಯಳಿಗೆ, “ಕೇಳು, ನೀನು ಸುಂದರಿ ಎಂದು ನಾನು ಬಲ್ಲೆ; ");
INSERT INTO kanirv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ಐಗುಪ್ತ ದೇಶದವರು ನಿನ್ನನ್ನು ಕಂಡು, ಈಕೆಯು ಇವನ ಹೆಂಡತಿ ಎಂದು ತಿಳಿದು ನನ್ನನ್ನು ಕೊಂದು ನಿನ್ನನ್ನು ಉಳಿಸಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ಆದಕಾರಣ ನೀನು ನನಗೆ ತಂಗಿಯಾಗಬೇಕೆಂದು ಅವರಿಗೆ ಹೇಳು; ಹೀಗೆ ಹೇಳಿದರೆ ನಿನ್ನ ನಿಮಿತ್ತ ನನಗೆ ಹಿತವಾಗುವುದು, ನಾನು ನಿನ್ನ ದೆಸೆಯಿಂದ ಸಾಯದೆ ಬದುಕುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ಅಬ್ರಾಮನು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಬಂದಾಗ ಐಗುಪ್ತರು ಅವನ ಸಂಗಡ ಇದ್ದ ಸ್ತ್ರೀಯನ್ನು ನೋಡಿ ಬಹು ಸುಂದರಿ ಎಂದು ಅಂದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ಫರೋಹನ ರಾಜಕುಮಾರರು ಆಕೆಯನ್ನು ನೋಡಿ ಬಂದು, ಅವನ ಮುಂದೆ ಹೊಗಳಲಾಗಿ ಫರೋಹನು ಆ ಸ್ತ್ರೀಯನ್ನು ಅರಮನೆಗೆ ಕರೆಯಿಸಿ ಆಕೆಯ ನಿಮಿತ್ತ ಅಬ್ರಾಮನಿಗೆ ಉಪಕಾರ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ಆಗ ಅಬ್ರಾಮನಿಗೆ ಕುರಿ, ಎತ್ತು, ಗಂಡು, ಹೆಣ್ಣು ಕತ್ತೆಗಳು, ದಾಸದಾಸಿಯರು, ಒಂಟೆಗಳು, ದೊರಕಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ಆದರೆ ಯೆಹೋವನು ಫರೋಹನಿಗೂ ಅವನ ಮನೆಯವರಿಗೂ ಅಬ್ರಾಮನ ಹೆಂಡತಿಯಾದ ಸಾರಯಳ ನಿಮಿತ್ತ ಬಹಳ ಉಪದ್ರವಗಳಿಂದ ಬಾಧಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ಆಗ ಫರೋಹನು ಅಬ್ರಾಮನನ್ನು ಕರೆಯಿಸಿ, “ನೀನು ಏಕೆ ಹೀಗೆ ಮಾಡಿದೆ? ಆಕೆ ನಿನ್ನ ಹೆಂಡತಿಯೆಂದು ಏಕೆ ನನಗೆ ತಿಳಿಸಲಿಲ್ಲ? ");
INSERT INTO kanirv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ತಂಗಿಯೆಂದು ಯಾಕೆ ಹೇಳಿದೆ? ಹೀಗೆ ಹೇಳಿದ್ದರಿಂದ ಆಕೆಯನ್ನು ಹೆಂಡತಿಯನ್ನಾಗಿ ತೆಗೆದುಕೊಂಡೆನಲ್ಲಾ. ಇಗೋ ನಿನ್ನ ಹೆಂಡತಿ; ಕರೆದುಕೊಂಡು ಹೋಗು” ಎಂದು ಹೇಳಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ಫರೋಹನು ಅವನ ವಿಷಯವಾಗಿ ತನ್ನ ಸೇವಕರಿಗೆ ಅಪ್ಪಣೆಕೊಡಲು ಅವರು ಅಬ್ರಾಮನನ್ನೂ ಅವನ ಹೆಂಡತಿಯನ್ನೂ ಅವನಿಗೆ ಇದ್ದದ್ದೆಲ್ಲವನ್ನೂ ಒಟ್ಟಿಗೆ ಸೇರಿಸಿ ಕಳುಹಿಸಿ ಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ಹೀಗೆ ಅಬ್ರಾಮನು ತನ್ನದನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು ಹೆಂಡತಿಯನ್ನೂ, ಲೋಟನನ್ನೂ ಸಂಗಡ ಕರೆದುಕೊಂಡು ಐಗುಪ್ತದೇಶವನ್ನು ಬಿಟ್ಟು ಕಾನಾನ್ ದೇಶದ ದಕ್ಷಿಣ ಪ್ರಾಂತ್ಯಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ಅಬ್ರಾಮನು ಬಹು ಐಶ್ವರ್ಯವಂತನಾಗಿದ್ದನು; ಅವನಿಗೆ ಪಶುಗಳೂ ಬೆಳ್ಳಿಬಂಗಾರವೂ ಇದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ಅವನು ದಕ್ಷಿಣ ದೇಶವನ್ನು ಬಿಟ್ಟು ಮುಂದೆ ಪ್ರಯಾಣ ಮಾಡುತ್ತಾ ಬೇತೇಲಿನವರೆಗೆ ಅಂದರೆ ಬೇತೇಲಿಗೂ ಆಯಿ ಎಂಬ ಊರಿಗೂ ");
INSERT INTO kanirv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ನಡುವೆ ಪೂರ್ವದಲ್ಲಿ ಗುಡಾರ ಹಾಕಿಸಿ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿದ್ದ ಸ್ಥಳಕ್ಕೆ ಅಬ್ರಾಮನು ಹಿಂತಿರುಗಿ ಬಂದು ಅಲ್ಲಿ ಯೆಹೋವನ ಹೆಸರಿನಲ್ಲಿ ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ಅಬ್ರಾಮನ ಜೊತೆಯಲ್ಲಿದ್ದ ಲೋಟನಿಗೂ ಕುರಿ, ಎತ್ತು, ಕುಟುಂಬಗಳು ಇದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ಆ ಸ್ಥಳವು ಅವರಿಬ್ಬರ ಜೀವನಕ್ಕೆ ಸಾಲದೆ ಹೋಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ಅವರಿಬ್ಬರ ಆಸ್ತಿ ಬಹಳವಾಗಿದ್ದುದರಿಂದ ಅವರು ಒಟ್ಟಿಗೆ ವಾಸವಾಗಿರುವುದು ಅಸಾಧ್ಯವಾಯಿತು. ಇದರಿಂದ ಅಬ್ರಾಮನ ದನ ಕಾಯುವವರಿಗೂ ಲೋಟನ ದನ ಕಾಯುವವರಿಗೂ ಜಗಳವಾಗುತ್ತಿತ್ತು. ಇದಲ್ಲದೆ ಕಾನಾನ್ಯರೂ ಪೆರಿಜೀಯರೂ ಆ ಕಾಲದಲ್ಲಿ ದೇಶದೊಳಗೆ ವಾಸವಾಗಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ಹೀಗಿರಲು ಅಬ್ರಾಮನು ಲೋಟನಿಗೆ, “ನನಗೂ ನಿನಗೂ, ನನ್ನ ದನ ಕಾಯುವವರಿಗೂ ನಿನ್ನ ದನ ಕಾಯುವವರಿಗೂ ಜಗಳವಾಗಬಾರದು; ನಾವು ಸಹೋದರರಲ್ಲವೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ದೇಶವೆಲ್ಲಾ ನಿನ್ನ ಎದುರಿಗೆ ಇದೆ; ದಯವಿಟ್ಟು ನನ್ನನ್ನು ಬಿಟ್ಟು ಪ್ರತ್ಯೇಕವಾಗಿ ಹೋಗು. ನೀನು ಎಡಗಡೆಗೆ ಹೋದರೆ ನಾನು ಬಲಗಡೆಗೆ ಹೋಗುವೆನು; ನೀನು ಬಲಗಡೆಗೆ ಹೋದರೆ ನಾನು ಎಡಗಡೆಗೆ ಹೋಗುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ಲೋಟನು ಕಣ್ಣೆತ್ತಿ ನೋಡಲಾಗಿ, ಯೊರ್ದನ್ ಹೊಳೆಯ ಸುತ್ತಲಿನ ಪ್ರದೇಶವು ಚೋಗರಿನವರೆಗೆ ನೀರಾವರಿಯ ಪ್ರದೇಶವೆಂದು ತಿಳಿದುಕೊಂಡನು. ಯೆಹೋವನು ಸೊದೋಮ್ ಗೊಮೋರ ಪಟ್ಟಣಗಳನ್ನು ನಾಶಮಾಡುವುದಕ್ಕಿಂತ ಮೊದಲು ಆ ಸೀಮೆಯು ಯೆಹೋವನ ವನದಂತೆಯೂ, ಐಗುಪ್ತ ದೇಶದಂತೆಯೂ ನೀರಾವರಿಯ ಪ್ರದೇಶವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ಆದುದರಿಂದ ಲೋಟನು ಯೊರ್ದನ್ ಹೊಳೆಯ ಸುತ್ತಣ ಪ್ರದೇಶವನ್ನು ಆರಿಸಿಕೊಂಡು ಮೂಡಣ ಕಡೆಗೆ ಹೊರಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ಹೀಗೆ ಅವರಿಬ್ಬರೂ ಪ್ರತ್ಯೇಕವಾದರು. ಅಬ್ರಾಮನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡಿದನು. ಲೋಟನು ಯೊರ್ದನ್ ಹೊಳೆಯ ಸುತ್ತಣ ಊರುಗಳಲ್ಲಿ ವಾಸ ಮಾಡುತ್ತಾ ಸೊದೋಮಿನ ಸಮೀಪದಲ್ಲಿ ಗುಡಾರ ಹಾಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ಆದರೆ ಸೊದೋಮ್ ಪಟ್ಟಣದ ಜನರು ಯೆಹೋವನ ದೃಷ್ಟಿಯಲ್ಲಿ ಬಹು ದುಷ್ಟರೂ ಪಾಪಿಷ್ಠರು ಆಗಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ಲೋಟನು ಅಬ್ರಾಮನನ್ನು ಬಿಟ್ಟು ಬೇರೆಯಾದ ನಂತರ ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ, “ನೀನಿರುವ ಸ್ಥಳದಿಂದ ದಕ್ಷಿಣಕ್ಕೂ, ಉತ್ತರಕ್ಕೂ, ಪೂರ್ವಕ್ಕೂ, ಪಶ್ಚಿಮಕ್ಕೂ, ಕಣ್ಣೆತ್ತಿ ನೋಡು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ನೀನು ನೋಡುವ ಈ ದೇಶವನ್ನೆಲ್ಲಾ ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಗೂ ಶಾಶ್ವತವಾಗಿ ಕೊಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ನಿನ್ನ ಸಂತಾನದವರನ್ನು ಭೂಮಿಯ ಧೂಳಿನಷ್ಟು ಅಸಂಖ್ಯವಾಗಿ ಮಾಡುವೆನು. ಭೂಮಿಯಲ್ಲಿರುವ ಧೂಳನ್ನು ಲೆಕ್ಕಮಾಡುವುದಾದರೆ ನಿನ್ನ ಸಂತಾನವನ್ನೂ ಲೆಕ್ಕಿಸಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ನೀನೆದ್ದು, ಈ ದೇಶದ ಎಲ್ಲಾ ಕಡೆಯಲ್ಲಿಯೂ ತಿರುಗಾಡು; ಇದನ್ನು ನಿನಗೆ ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ತರುವಾಯ ಅಬ್ರಾಮನು ಗುಡಾರವನ್ನು ತೆಗೆದುಕೊಂಡು ಹೆಬ್ರೋನಿನಲ್ಲಿರುವ ಮಮ್ರೆ ಮೋರೆ ಎಂಬ ತೋಪಿಗೆ ಬಂದು ಅಲ್ಲೇ ವಾಸಮಾಡಿಕೊಂಡು, ಯೆಹೋವನಿಗೆ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ಆ ದಿನಗಳಲ್ಲಿ ಶಿನಾರಿನ ಅರಸನಾದ ಅಮ್ರಾಫೆಲನು, ಎಲ್ಲಜಾರಿನ ಅರಸನಾದ ಅರಿಯೋಕನು, ಏಲಾಮಿನ ಅರಸನಾದ ಕೆದೊರ್ಲಗೋಮರನು, ಗೋಯಿಮದ ಅರಸನಾದ ತಿದ್ಗಾಲನು ಈ ನಾಲ್ವರು ಈಗಿನ ಲವಣಸಮುದ್ರ ಎನ್ನಿಸಿಕೊಳ್ಳುವ ಸಿದ್ದೀಮ್, ");
INSERT INTO kanirv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ತಗ್ಗು ಪ್ರದೇಶದಲ್ಲಿ ಒಟ್ಟಾಗಿ ಕೂಡಿದ್ದ ಸೊದೋಮಿನ ಅರಸನಾದ ಬೆರಗನು, ಗೊಮೋರದ ಅರಸನಾದ ಬಿರ್ಶಗನು, ಅದ್ಮಾಹದ ಅರಸನಾದ ಶಿನಾಬನು, ಚೆಬೋಯಿಮನ ಅರಸನಾದ ಶೆಮೇಬರನ, ಬೇಲಗ (ಅಂದರೆ ಚೋಗರದ) ಎಂಬ ಐದು ಅರಸರ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ಈ ಐದು ಅರಸರು ಈಗಿನ ಲವಣಸಮುದ್ರ ಎನ್ನಿಸಿಕೊಳ್ಳುವ ಸಿದ್ದೀಮ್, ತಗ್ಗಿನ ಪ್ರದೇಶದಲ್ಲಿ ಒಟ್ಟಾಗಿ ಕೂಡಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ಬೆರಗ ಮೊದಲಾದ ಈ ಐದು ಅರಸರು ಹನ್ನೆರಡು ವರ್ಷ ಕೆದೊರ್ಲಗೋಮರನಿಗೆ ಅಧೀನರಾಗಿದ್ದು ಹದಿಮೂರನೆಯ ವರ್ಷದಲ್ಲಿ ತಿರುಗಿ ಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ಹದಿನಾಲ್ಕನೆಯ ವರ್ಷದಲ್ಲಿ ಕೆದೊರ್ಲಗೋಮರನೂ ಅವನಿಗೆ ಸೇರಿದ್ದ ರಾಜರೂ ಬಂದು ಅಷ್ಟರೋತ್ ಕರ್ನಯಿಮಿನಲ್ಲಿ ರೆಫಾಯರನ್ನೂ ಹಾಮಿನಲ್ಲಿ ಜೂಜ್ಯರನ್ನೂ ಶಾವೆಕಿರ್ಯಾತಯಿಮಿನಲ್ಲಿ ಏಮಿಯರನ್ನೂ ಸೋಲಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ಇದಲ್ಲದೆ ಸೇಯೀರೆಂಬ ಬೆಟ್ಟದ ಸೀಮೆಯಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಹೋರಿಯರನ್ನು, ಅಲ್ಲೇ ಸೋಲಿಸಿ ಮರಳುಗಾಡಿನ ಹತ್ತಿರವಿರುವ ಎಲ್ಪಾರಾನಿನ ವರೆಗೂ ಹಿಂದಟ್ಟಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ಆ ಮೇಲೆ ಅವರು ಹಿಂದಿರುಗಿಕೊಂಡು ಕಾದೇಶ್ ಎನ್ನುವ ಎನ್ಮಿಷ್ಟಾಟಿಗೆ ಬಂದು ಅಮಾಲೇಕ್ಯರ ಸಮಸ್ತ ನಾಡನ್ನೂ ಹಚಚೋನ್ ತಾಮರಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಅಮೋರಿಯರನ್ನೂ ಗೆದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ಆಗ ಸೊದೋಮ್, ಗೊಮೋರ, ಅದ್ಮಾಹ, ಚೆಬೋಯಿಮ್ ಹಾಗೂ ಚೋಗರೆಂಬ ಬೇಲಗದ ರಾಜರು ಹೊರಟು ಅವರಿಗೆದುರಾಗಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ಅಂದರೆ ಏಲಾಮಿನ ರಾಜನಾದ ಕೆದೊರ್ಲಗೋಮರ್, ಗೋಯಿಮದ ರಾಜನಾದ ತಿದ್ಗಾಲ, ಶಿನಾರ್ ಅರಸನಾದ ಅಮ್ರಾಫೆಲ್, ಎಲ್ಲಸಾರಿನ ರಾಜನಾದ ಅರಿಯೋಕ ಇವರಿಗೆ ವಿರೋಧವಾಗಿ ಸಿದ್ದೀಮ್ ಎಂಬ ತಗ್ಗಿನಲ್ಲಿ ತಮ್ಮ ದಂಡನ್ನು ನಿಲ್ಲಿಸಿದರು. ಹೀಗೆ ನಾಲ್ಕು ಮಂದಿ ರಾಜರು ಐದು ಮಂದಿ ರಾಜರನ್ನು ಎದುರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ಆದರೆ ಸಿದ್ದೀಮ್ ತಗ್ಗು ಪ್ರದೇಶ ಕಲ್ಲರಗಿನ ಕೆಸರುಗುಣಿಗಳಿಂದ ತುಂಬಿತ್ತು. ಸೊದೋಮ್ ಗೊಮೋರಗಳ ರಾಜರ ಕಡೆಯವರು ಓಡಿಹೋಗುವಾಗ ಆ ಗುಣಿಗಳಲ್ಲಿ ಬಿದ್ದು ಸತ್ತರು; ಉಳಿದವರು ಬೆಟ್ಟಗಳಿಗೆ ಓಡಿಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ಗೆದ್ದ ಆ ನಾಲ್ಕು ಅರಸರು ಸೊದೋಮ್ ಗೊಮೋರ ಪಟ್ಟಣಗಳನ್ನು ಸೂರೆಮಾಡಿ ಅವುಗಳಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಸಂಪತ್ತನ್ನೂ ದವಸವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ಸೊದೋಮಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಅಬ್ರಾಮನ ತಮ್ಮನ ಮಗನಾದ ಲೋಟನನ್ನೂ ಅವನ ಆಸ್ತಿ ಸಹಿತ ಹಿಡಿದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ತಪ್ಪಿಸಿಕೊಂಡವನೊಬ್ಬನು, ಇಬ್ರಿಯನಾದ ಅಬ್ರಾಮನ ಬಳಿಗೆ ಬಂದು ಈ ಸಂಗತಿಯನ್ನು ತಿಳಿಸಿದನು. ಅಬ್ರಾಮನು ಅಮೋರಿಯನಾದ ಮಮ್ರೆಯನ ಮೋರೆ ತೋಪಿನ ಬಳಿಯಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ಮಮ್ರೆಯನಿಗೆ ಎಷ್ಕೋಲ ಮತ್ತು ಆನೇರ ಎಂಬ ಸಹೋದರರಿದ್ದರು; ಇವರಿಬ್ಬರಿಗೂ ಅಬ್ರಾಮನಿಗೂ ಒಡಂಬಡಿಕೆಯಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ಅಬ್ರಾಮನು ತನ್ನ ತಮ್ಮನ ಮಗನು ಸೆರೆಗೆ ಸಿಕ್ಕಿದ್ದನ್ನು ಕೇಳಿ ತನ್ನ ಮನೆಯಲ್ಲೇ ಹುಟ್ಟಿ ಬೆಳೆದ ಶಿಕ್ಷಿತರಾದ ಮುನ್ನೂರ ಹದಿನೆಂಟು ಮಂದಿ ಆಳುಗಳನ್ನು ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧಮಾಡಿಕೊಂಡು ಹೊರಟು ಆ ರಾಜರನ್ನು ದಾನೂರಿನವರೆಗೂ ಹಿಂದಟ್ಟಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ಅವನು ರಾತ್ರಿ ವೇಳೆಯಲ್ಲಿ ತನ್ನ ದಂಡನ್ನು ಎರಡು ಭಾಗಮಾಡಿ ತನ್ನ ಭಟರೊಡನೆ ಅವರ ಮೇಲೆ ಬಿದ್ದು, ಹೊಡೆದು, ದಮಸ್ಕ ಪಟ್ಟಣದ ಉತ್ತರಕಡೆಯಲ್ಲಿರುವ ಹೋಬಾ ಊರಿನ ತನಕ ಅವರನ್ನು ಹಿಂದಟ್ಟಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ರಾಜರು ಅಪಹರಿಸಿದ್ದ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ಅವನು ತಿರುಗಿ ಪಡೆದುಕೊಂಡನು. ತನ್ನ ತಮ್ಮನ ಮಗನಾದ ಲೋಟನನ್ನೂ ಅವನ ಆಸ್ತಿಯನ್ನೂ ಬಿಡಿಸಿಕೊಂಡದ್ದಲ್ಲದೆ, ಸೆರೆಯಲ್ಲಿದ್ದ ಸ್ತ್ರೀಯರನ್ನೂ, ಉಳಿದಿದ್ದ ಜನರನ್ನು ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ಅವನು ಕೆದೊರ್ಲಗೋಮರನ್ನೂ ಅವನೊಂದಿಗೆ ಇದ್ದ ರಾಜರನ್ನೂ ಸೋಲಿಸಿ ಬಂದ ಮೇಲೆ ಸೊದೋಮಿನ ಅರಸನು ಅವನನ್ನು ಅರಸನ ತಗ್ಗು ಎನ್ನಿಸಿಕೊಳ್ಳುವ ಶಾವೆ ತಗ್ಗಿನಲ್ಲಿ ಅಬ್ರಾಮನನ್ನು ಎದುರುಗೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ಸಾಲೇಮಿನ ಅರಸನಾದ ಮೆಲ್ಕೀಚೆದೆಕನು ಸಹ ಬಂದು ರೊಟ್ಟಿಯನ್ನೂ ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಕೊಟ್ಟನು. ಇವನು ಪರಾತ್ಪರನಾದ ದೇವರ ಯಾಜಕನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ಇವನು ಅಬ್ರಾಮನನ್ನು ಆಶೀರ್ವದಿಸಿ, “ಭೂಮ್ಯಾಕಾಶವನ್ನು ನಿರ್ಮಾಣಮಾಡಿದ ಪರಾತ್ಪರನಾದ ದೇವರ ಆಶೀರ್ವಾದವು ಅಬ್ರಾಮನಿಗೆ ದೊರೆಯಲಿ; ");
INSERT INTO kanirv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ಪರಾತ್ಪರನಾದ ದೇವರು ನಿನ್ನ ಶತ್ರುಗಳನ್ನು ನಿನ್ನ ಕೈಗೆ ಒಪ್ಪಿಸಿದ್ದಕ್ಕಾಗಿ ಆತನಿಗೆ ಸ್ತೋತ್ರ” ಎಂದು ಹೇಳಿದನು. ಅಬ್ರಾಮನು ತಾನು ಗೆದ್ದು ತಂದಿದ್ದ ಎಲ್ಲಾ ವಸ್ತುಗಳಲ್ಲಿ ಹತ್ತನೆಯ ಒಂದು ಭಾಗವನ್ನು ಯಾಜಕನಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ಸೊದೋಮಿನ ಅರಸನು, ಅಬ್ರಾಮನಿಗೆ, “ನೀನು ಬಿಡಿಸಿ ತಂದ ಜನರನ್ನು ನನಗೆ ಒಪ್ಪಿಸು; ಆಸ್ತಿಯನ್ನು ನೀನೇ ತೆಗೆದುಕೋ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ಅಬ್ರಾಮನು, ಸೊದೋಮಿನ ಅರಸನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","“ಒಂದು ದಾರವನ್ನಾಗಲಿ, ಕೆರದ ಬಾರನ್ನಾಗಲಿ ನಿನ್ನದರಲ್ಲಿ ಯಾವುದನ್ನೂ ನಾನು ತೆಗೆದುಕೊಳ್ಳುವುದಿಲ್ಲವೆಂದು ಭೂಮ್ಯಾಕಾಶಗಳನ್ನು ನಿರ್ಮಾಣಮಾಡಿದ ಪರಾತ್ಪರನಾದ ದೇವರಾಗಿರುವ ಯೆಹೋವನ ಕಡೆಗೆ ಕೈ ಎತ್ತಿ ಪ್ರಮಾಣಮಾಡುತ್ತೇನೆ. ‘ನನ್ನಿಂದ ಅಬ್ರಾಮನು ಐಶ್ವರ್ಯವಂತನಾದನೆಂದು ಹೇಳಿಕೊಳ್ಳುವುದಕ್ಕೆ ನಿನಗೆ ಆಸ್ಪದವಾಗಬಾರದು, ನನಗೆ ಏನೂ ಬೇಡ.’ ");
INSERT INTO kanirv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ಆಳುಗಳು ತಿಂದದ್ದು ಹೊರತು ನನ್ನ ಜೊತೆಯವರಾದ ಆನೇರ ಎಷ್ಕೋಲ ಮಮ್ರೆಯರಿಗೆ ಬರತಕ್ಕ ಪಾಲು ಮಾತ್ರ ಅವರಿಗೆ ಇರಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ಈ ಸಂಗತಿಗಳು ನಡೆದ ಮೇಲೆ ಅಬ್ರಾಮನಿಗೆ ದರ್ಶನದಲ್ಲಿ ಯೆಹೋವನ ವಾಕ್ಯವುಂಟಾಗಿ ಹೇಳಿದೇನೆಂದರೆ, “ಅಬ್ರಾಮನೇ, ಭಯಪಡಬೇಡ, ನಾನು ನಿನಗೆ ಗುರಾಣಿಯಾಗಿದ್ದೇನೆ ಮತ್ತು ನಿನಗೆ ಅತ್ಯಧಿಕ ಬಹುಮಾನವು ದೊರೆಯುವುದು.” ");
INSERT INTO kanirv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ಅದಕ್ಕೆ ಅಬ್ರಾಮನು, “ಕರ್ತನಾದ ಯೆಹೋವನೇ, ನನಗೆ ಏನು ಕೊಟ್ಟರೇನು? ನಾನು ಸಂತಾನವಿಲ್ಲದವನು. ಮತ್ತು ನನ್ನ ಆಸ್ತಿಯೆಲ್ಲಾ, ದಮಸ್ಕದವನಾದ ಎಲೀಯೆಜರನ ಪಾಲಾಗುತ್ತದೆಯಲ್ಲಾ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ಪುನಃ ಅಬ್ರಾಮನು ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು ನನಗೆ ಸಂತಾನ ಕೊಡಲಿಲ್ಲವಾದ್ದರಿಂದ, ನೋಡು, ನನ್ನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವನೇ ನನಗೆ ಬಾಧ್ಯಸ್ಥನಾಗಬೇಕಾಯಿತು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ಯೆಹೋವನ ವಾಕ್ಯವು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿ, “ಈ ಮನುಷ್ಯನು ನಿನಗೆ ಬಾಧ್ಯಸ್ಥನಾಗುವುದಿಲ್ಲ; ಆದರೆ ನಿನ್ನ ಹೊಟ್ಟೆಯಲ್ಲಿ ಹುಟ್ಟುವವನೇ ನಿನಗೆ ಬಾಧ್ಯಸ್ಥನಾಗುವನು” ಎಂದು ಹೇಳಿ ಅಬ್ರಾಮನನ್ನು ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದು, ");
INSERT INTO kanirv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","“ಆಕಾಶದ ಕಡೆಗೆ ನೋಡು, ನಕ್ಷತ್ರಗಳನ್ನು ಲೆಕ್ಕಿಸುವುದು ನಿನ್ನಿಂದಾದರೆ ಲೆಕ್ಕಿಸು.” ನಂತರ ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ, “ನಿನ್ನ ಸಂತಾನವು ನಕ್ಷತ್ರಗಳಷ್ಟಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ಅಬ್ರಾಮನು ಯೆಹೋವನನ್ನು ನಂಬಿದನು; ಯೆಹೋವನು ಅವನ ನಂಬಿಕೆಯನ್ನು ಅವನ ಲೆಕ್ಕಕ್ಕೆ ನೀತಿಯೆಂದು ಪರಿಗಣಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ನಂತರ ಆತನು ಅಬ್ರಾಮನಿಗೆ, “ಈ ದೇಶವನ್ನು ನಿನಗೆ ಬಾಧ್ಯಸ್ಥವಾಗಿ ಕೊಡುವುದಕ್ಕೋಸ್ಕರ ನಿನ್ನನ್ನು ಊರ್ ಎಂಬ ಕಲ್ದೀಯರ ಪಟ್ಟಣದಿಂದ ಬರಮಾಡಿದ ಯೆಹೋವನು ನಾನೇ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","“ಕರ್ತನಾದ ಯೆಹೋವನೇ, ನಾನು ಇದನ್ನು ಬಾಧ್ಯವಾಗಿ ಹೊಂದುವೆನೆಂದು ತಿಳಿದುಕೊಳ್ಳುವುದು ಹೇಗೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ಅದಕ್ಕೆ ಆತನು ಯೆಹೋವನಿಗೆ, “ನೀನು ಮೂರು ವರ್ಷದ ಮಣಕ, ಒಂದು ಆಡು, ಒಂದು ಟಗರು, ಒಂದು ಬೆಳವಕ್ಕಿ, ಒಂದು ಪಾರಿವಾಳದ ಮರಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಾ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ಅವನು ಇವುಗಳನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು ಬಂದು ಮೃಗಗಳನ್ನು ಎರಡಾಗಿ ಸೀಳಿ, ಒಂದು ತುಂಡನ್ನು ಇನ್ನೊಂದರ ಎದುರಾಗಿ ಇಟ್ಟನು; ಪಕ್ಷಿಗಳನ್ನು ಮಾತ್ರ ಸೀಳಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ಆ ಪಶುಗಳ ಮೇಲೆ ಹದ್ದುಗಳು ಎರಗಲು ಅಬ್ರಾಮನು ಅವುಗಳನ್ನು ಓಡಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ಹೊತ್ತು ಮುಣುಗುತ್ತಿರುವಾಗ ಅಬ್ರಾಮನಿಗೆ ಗಾಢನಿದ್ರೆ ಹತ್ತಿತು; ಕಾರ್ಗತ್ತಲು ಅವನ ಮೇಲೆ ಕವಿಯಿತು; ಅವನು ಮಹಾಭೀತಿಯಿಂದ ಭಯಭ್ರಾಂತನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ಆಗ ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ, “ನೀನು ಚೆನ್ನಾಗಿ ತಿಳಿಯತಕ್ಕದ್ದೇನೆಂದರೆ, ನಿನ್ನ ಸಂತತಿಯವರು ಅನ್ಯದೇಶದಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿ ವಾಸವಾಗಿದ್ದು ಆ ದೇಶದವರಿಗೆ ದಾಸರಾಗುವರು. ನಾನೂರು ವರ್ಷ ಆ ದೇಶದವರಿಂದ ಬಾಧೆಪಡುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ಅವರನ್ನು ದಾಸರನ್ನಾಗಿ ಮಾಡಿಸಿಕೊಂಡ ಜನಾಂಗವನ್ನು ನಾನು ದಂಡಿಸಿದ ನಂತರ ಅವರು ಬಹಳ ಸಂಪತ್ತುಳ್ಳವರಾಗಿ ಆ ದೇಶದಿಂದ ಬಿಡುಗಡೆಯಾಗಿ ಹೊರಟು ಬರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ನೀನಂತೂ ಸಮಾಧಾನದೊಡನೆ ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರುವಿ, ಬಹಳ ವೃದ್ಧನಾಗಿ ಉತ್ತರಕ್ರಿಯೆಯನ್ನು ಹೊಂದುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ನಿನ್ನ ಸಂತತಿಯ ನಾಲ್ಕನೆಯ ತಲೆಮಾರಿನವರು ಇಲ್ಲಿಗೆ ತಿರುಗಿ ಬರುವರು, ಅಮೋರಿಯರ ಅಪರಾಧವು ಇನ್ನೂ ಪೂರ್ಣಸ್ಥಿತಿಗೆ ಬರಲಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ಹೊತ್ತು ಮುಳುಗಿ ಕಾರ್ಗತ್ತಲಾದಾಗ, ಇಗೋ, ಹೊಗೆ ಹಾಯುವ ಒಲೆಯೂ ಉರಿಯುವ ದೀಪವೂ ಕಾಣಿಸಿ ಆ ತುಂಡುಗಳ ಮಧ್ಯದಲ್ಲಿ ಹಾದು ಹೋದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ಆ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ಅಬ್ರಾಮನ ಸಂಗಡ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಂಡು, “ಐಗುಪ್ತ ದೇಶದ ನದಿಯಿಂದ ಯೂಫ್ರೆಟಿಸ್ ಮಹಾ ನದಿಯವರೆಗೂ ಇರುವ ಈ ದೇಶವನ್ನೆಲ್ಲಾ ನಿನ್ನ ಸಂತತಿಯವರಿಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ಕೇನಿಯರೂ, ಕೆನಿಜೀಯರೂ, ಕದ್ಮೋನಿಯರೂ, ");
INSERT INTO kanirv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ಹಿತ್ತಿಯರೂ, ಪೆರಿಜೀಯರೂ, ರೆಫಾಯರೂ, ");
INSERT INTO kanirv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ಅಮೋರಿಯರೂ, ಕಾನಾನ್ಯರೂ, ಗಿರ್ಗಾಷಿಯರೂ, ಯೆಬೂಸಿಯರೂ ವಾಸವಾಗಿರುವ ದೇಶವನ್ನು ನಾನು ನಿನ್ನ ಸಂತತಿಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ,” ಎಂದು ವಾಗ್ದಾನ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ಅಬ್ರಾಮನ ಹೆಂಡತಿಯಾದ ಸಾರಯಳಿಗೆ ಮಕ್ಕಳಿರಲಿಲ್ಲ. ಆಕೆಗೆ ಐಗುಪ್ತ ದೇಶದವಳಾದ ಹಾಗರಳೆಂಬ ದಾಸಿಯಿದ್ದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ಹೀಗಿರಲಾಗಿ ಸಾರಯಳು ಅಬ್ರಾಮನಿಗೆ, “ಯೆಹೋವನು ನನಗೆ ಮಕ್ಕಳನ್ನು ಕೊಡಲಿಲ್ಲವಲ್ಲಾ; ನೀನು ನನ್ನ ದಾಸಿಯಾದ ಹಾಗರಳ ಬಳಿಗೆ ಹೋಗಬೇಕು; ಒಂದು ವೇಳೆ ಅವಳ ಮೂಲಕ ನನಗೆ ಸಂತಾನವಾದೀತು” ಎಂದು ಹೇಳಲು ಅಬ್ರಾಮನು ಆಕೆಯ ಮಾತಿಗೆ ಸಮ್ಮತಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ಅಬ್ರಾಮನು ಹತ್ತು ವರ್ಷಗಳ ಕಾಲ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ವಾಸಿಸಿದ ಮೇಲೆ ಅವನ ಹೆಂಡತಿಯಾದ ಸಾರಯಳು ಐಗುಪ್ತಳಾದ ಹಾಗರಳೆಂಬ ದಾಸಿಯನ್ನು ಕರೆದು ತನ್ನ ಗಂಡನಿಗೆ ಹೆಂಡತಿಯಾಗಿ ಒಪ್ಪಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ಅವನು ಹಾಗರಳನ್ನು ಸಂಗಮಿಸಲು ಆಕೆಯು ಬಸುರಾದಳು. ತಾನು ಬಸುರಾದೆನೆಂದು ತಿಳಿದುಕೊಂಡಾಗ ಅವಳು ತನ್ನ ಯಜಮಾನಿಯನ್ನು ತಾತ್ಸಾರ ಮಾಡತೊಡಗಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ಆಗ ಸಾರಯಳು ಅಬ್ರಾಮನಿಗೆ, “ನನ್ನ ಗೋಳು ನಿನಗೆ ತಟ್ಟಲಿ; ನನ್ನ ದಾಸಿಯನ್ನು ನಿನಗೆ ಹೆಂಡತಿಯಾಗಿ ಒಪ್ಪಿಸಿದೆನಷ್ಟೆ; ಅವಳು ತಾನು ಬಸುರಾದೆನೆಂದು ತಿಳಿದು ನನ್ನನ್ನು ತಾತ್ಸಾರಮಾಡುತ್ತಿದ್ದಾಳೆ; ನಿನಗೂ ನನಗೂ ನಡುವೆ ಯೆಹೋವನೇ ನ್ಯಾಯತೀರಿಸಲಿ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ಆಗ ಅಬ್ರಾಮನು, “ನಿನ್ನ ದಾಸಿಯು ನಿನ್ನ ಕೈಯಲ್ಲೇ ಇದ್ದಾಳಲ್ಲಾ; ನಿನ್ನಗೆ ಮನಸ್ಸು ಬಂದಂತೆ ಮಾಡು” ಎಂದನು. ಆಗ ಸಾರಯಳು ಅವಳನ್ನು ಬಾಧಿಸಲು ಅವಳು ಓಡಿಹೋದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ಅವಳು ಮರಳುಗಾಡಿನಲ್ಲಿ ಶೂರಿನ ಮಾರ್ಗದ ನೀರಿನ ಬುಗ್ಗೆಯ ಹತ್ತಿರ ಇರುವಾಗ ಯೆಹೋವನ ದೂತನು ಅವಳನ್ನು ಕಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“ಸಾರಯಳ ದಾಸಿಯಾದ ಹಾಗರಳೇ, ಎಲ್ಲಿಂದ ಬಂದಿ? ಎಲ್ಲಿಗೆ ಹೋಗುತ್ತೀ?” ಎಂದು ಕೇಳಲು ಅವಳು, “ನನ್ನ ಯಜಮಾನಿಯಾದ ಸಾರಯಳ ಬಳಿಯಿಂದ ಓಡಿಹೋಗುತ್ತಾ ಇದ್ದೇನೆ” ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ಅದಕ್ಕೆ ಯೆಹೋವನ ದೂತನು, “ನೀನು ಯಜಮಾನಿಯ ಬಳಿಗೆ ಹಿಂದಿರುಗಿ ಹೋಗಿ ಅವಳಿಗೆ ಅಧೀನಳಾಗಿ ನಡೆದುಕೋ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ಅದಲ್ಲದೆ ಯೆಹೋವನ ದೂತನು ಅವಳಿಗೆ, “ನಿನಗೆ ಬಹುಸಂತಾನವಾಗುವಂತೆ ಮಾಡುವೆನು; ನಿನ್ನ ಸಂತತಿಯು ಲೆಕ್ಕಿಸಲಾಗದಷ್ಟು ಹೆಚ್ಚಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ಯೆಹೋವನ ದೂತನು ಅವಳಿಗೆ, “ನೀನು ಗರ್ಭಿಣಿಯಾಗಿದಿಯಾ; ನಿನಗೆ ಮಗನು ಹುಟ್ಟುವನು; ಯೆಹೋವನು ನಿನ್ನ ಕಷ್ಟದ ಕೂಗಿಗೆ ಕಿವಿಗೊಟ್ಟಿದ್ದರಿಂದ ಆ ಮಗನಿಗೆ ಇಷ್ಮಾಯೇಲ್ ಎಂದು ಹೆಸರಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ಆ ಮನುಷ್ಯ ಕಾಡು ಕತ್ತೆಯಂತೆ ಇರುವನು. ಅವನು ಎಲ್ಲರ ಮೇಲೆ ಕೈಯೆತ್ತುವನು; ಹಾಗೆಯೇ ಅವನ ಮೇಲೆ ಎಲ್ಲರೂ ಕೈಯೆತ್ತುವರು. ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ ಎದುರಾಗಿ ವಾಸವಾಗಿರುವನು” ಎಂದು ಹೇಳಿ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ಆಮೇಲೆ ಆಕೆಯು ತನ್ನ ಸಂಗಡ ಮಾತನಾಡಿದ ಯೆಹೋವನಿಗೆ, “ನೀನು ನನ್ನನ್ನು ನೋಡುವ ದೇವರು” ಎಂದು ಹೆಸರಿಟ್ಟಳು: ಏಕೆಂದರೆ, “ನನ್ನನ್ನು ನೋಡುವಾತನನ್ನು ನಾನು ಇಲ್ಲಿಯೂ ನೋಡುವಂತಾಯಿತಲ್ಲಾ” ಎಂದುಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ಈ ಸಂಗತಿಯಿಂದ ಅಲ್ಲಿರುವ ಬಾವಿಗೆ “ಬೆರ್ ಲಹೈರೋಯಿ” ಎಂದು ಹೆಸರಾಯಿತು. ಅದು ಕಾದೇಶಿಗೂ ಬೆರೆದಿಗೂ ಮಧ್ಯದಲ್ಲಿ ಇದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ಹಾಗರಳು ಅಬ್ರಾಮನಿಂದ ಒಬ್ಬ ಮಗನನ್ನು ಹೆತ್ತಳು. ಅಬ್ರಾಮನು ಅವನಿಗೆ ಇಷ್ಮಾಯೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ಹಾಗರಳು ಇಷ್ಮಾಯೇಲನನ್ನು ಹೆತ್ತಾಗ ಅಬ್ರಾಮನು ಎಂಭತ್ತಾರು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ಅಬ್ರಾಮನು ತೊಂಭತೊಂಭತ್ತು ವರ್ಷದವನಾದಾಗ ಯೆಹೋವನು ಅವನಿಗೆ ದರ್ಶನದಲ್ಲಿ, “ನಾನು ಸರ್ವಶಕ್ತನಾದ ದೇವರು; ನನ್ನೆದುರಿನಲ್ಲಿ ದೋಷ ಇಲ್ಲದವನಾಗಿ ನಡೆದುಕೊ. ");
INSERT INTO kanirv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ನಾನು ನಿನ್ನ ಸಂಗಡ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಳ್ಳುತ್ತೇನೆ; ಅತ್ಯಧಿಕವಾದ ಸಂತತಿಯನ್ನು ನಿನಗೆ ಕೊಡುವೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ಅಬ್ರಾಮನು ಅಡ್ಡಬೀಳಲು ದೇವರು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ನಾನು ನಿನ್ನೊಂದಿಗೆ ಒಂದು ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಳ್ಳುತ್ತೇನೆ; ಅದೇನೆಂದರೆ ನೀನು ಅನೇಕ ಜನಾಂಗಗಳಿಗೆ ಮೂಲಪುರುಷನಾಗುವಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ಇನ್ನು ಮುಂದೆ ನಿನಗೆ ಅಬ್ರಾಮ ಎಂದು ಹೆಸರಿರುವುದಿಲ್ಲ. ನಿನ್ನನ್ನು ಅನೇಕ ಜನಾಂಗಗಳಿಗೆ ಮೂಲಪಿತೃವಾಗಿ ನೇಮಿಸಿರುವುದರಿಂದ ನಿನಗೆ ಇನ್ನು ಮೇಲೆ ಅಬ್ರಹಾಮ ಎಂದು ಹೆಸರಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ನಿನಗೆ ಅತ್ಯಧಿಕವಾದ ಸಂತಾನವನ್ನು ಕೊಡುವೆನು ನಿನ್ನಿಂದ ಜನಾಂಗಗಳು ಉತ್ಪತ್ತಿಯಾಗಿ ಅರಸರು ಹುಟ್ಟುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ನಾನು ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಗೂ ದೇವರಾಗಿರುವೆನೆಂದೂ ನಿನಗೋಸ್ಕರವೂ ನಿನ್ನ ಸಂತತಿಯ ಎಲ್ಲಾ ತಲತಲಾಂತರಗಳಿಗೋಸ್ಕರವೂ ಮಾಡಿಕೊಂಡ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಿರಪಡಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ನೀನು ಪ್ರವಾಸಿಯಾಗಿರುವ ಕಾನಾನ್ ದೇಶವನ್ನೆಲ್ಲಾ ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಗೂ ಶಾಶ್ವತ ಸ್ವತ್ತಾಗಿ ಕೊಟ್ಟು ಎಂದೆಂದಿಗೂ ಅವರಿಗೆ ದೇವರಾಗಿರುವೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ಇದಲ್ಲದೆ ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ, “ನೀನಂತೂ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಕೈಕೊಂಡು ನಡೆಯಬೇಕು. ನೀನು ಮಾತ್ರವಲ್ಲದೆ ನಿನ್ನ ಸಂತತಿಯವರು ತಲತಲಾಂತರಗಳಲ್ಲಿ ಅದನ್ನು ಕೈಕೊಂಡು ನಡೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ನೀನೂ ನಿನ್ನ ಸಂತತಿಯುವರೂ ಕೈಕೊಳ್ಳಬೇಕಾದ ನನ್ನ ಒಡಂಬಡಿಕೆ ಯಾವುದೆಂದರೆ, ನಿಮ್ಮಲ್ಲಿರುವ ಗಂಡಸರೆಲ್ಲರಿಗೂ ಸುನ್ನತಿಯಾಗಬೇಕು ಎಂಬುದೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ಅದೇ ನಿಮಗೂ ನನಗೂ ಉಂಟಾದ ಒಡಂಬಡಿಕೆಯ ಗುರುತಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ಮುಂದಿನ ಎಲ್ಲಾ ತಲತಲಾಂತರವಾಗಿ ಬರುವ ನಿಮ್ಮ ಪ್ರತಿಯೊಂದು ಗಂಡು ಮಗುವಿಗೂ, ಎಂಟು ದಿನಗಳಾದ ಮೇಲೆ ಸುನ್ನತಿ ಮಾಡಿಸಬೇಕು; ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವನಾಗಲಿ, ನಿನ್ನ ಸಂತತಿಯಲ್ಲದೆ ಪರರ ಮಕ್ಕಳಾಗಲಿ, ಅನ್ಯರಿಂದ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡವನಾಗಲಿ; ");
INSERT INTO kanirv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ನಿನ್ನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವನಿಗೂ, ನೀನು ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡವನಿಗೂ ತಪ್ಪದೆ ಸುನ್ನತಿಯಾಗಬೇಕು. ಹೀಗೆ ನಾನು ಮಾಡುವ ಒಡಂಬಡಿಕೆಯ ಗುರುತು ನಿಮ್ಮ ಶರೀರದಲ್ಲೇ ಇದ್ದು, ಶಾಶ್ವತವಾದ ಒಡಂಬಡಿಕೆಯನ್ನು ಸೂಚಿಸುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ಸುನ್ನತಿಮಾಡಿಸಿಕೊಳ್ಳದ ಪುರುಷನಿಗೆ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಉಲ್ಲಂಘಿಸಿದಂತೆ ಆಗುವ ಕಾರಣ ಅವನನ್ನು ಕುಲದಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ಇದಲ್ಲದೆ ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ, “ನೀನು ಇನ್ನು ಮುಂದೆ ನಿನ್ನ ಹೆಂಡತಿಯನ್ನು ಸಾರಯಳೆಂದು ಕರೆಯದೆ ‘ಸಾರಾ’ (ರಾಣಿ) ಎಂದು ಕರೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ನಾನು ಆಕೆಯನ್ನು ಆಶೀರ್ವದಿಸಿ, ಆಕೆಯಿಂದ ನಿನಗೆ ಒಬ್ಬ ಮಗನನ್ನು ಕೊಡುವೆನು. ನಾನು ಆಕೆಯನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದರಿಂದ ಆಕೆಯಿಂದ ಅನೇಕ ಜನಾಂಗಗಳೂ ಅರಸರೂ ಉತ್ಪತ್ತಿಯಾಗುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ಅಬ್ರಹಾಮನು ಅಡ್ಡ ಬಿದ್ದು ನಕ್ಕು, “ನೂರು ವರ್ಷದವನಿಗೆ ಮಗ ಹುಟ್ಟುವುದುಂಟೇ? ತೊಂಭತ್ತು ವರ್ಷದವಳಾದ ಸಾರಳು ಹೆರಲು ಸಾಧ್ಯವೇ?” ಎಂದು ಮನಸ್ಸಿನಲ್ಲಿ ಅಂದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ಅಬ್ರಹಾಮನು ದೇವರಿಗೆ, “ಇಷ್ಮಾಯೇಲ್ ಇದ್ದಾನಲ್ಲಾ, ಅವನೇ ನಿನ್ನ ದಯೆ ಹೊಂದಿ ಬಾಳಲಿ” ಎನ್ನಲು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ದೇವರು, “ಹಾಗಲ್ಲ ನಿನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಳಲ್ಲಿಯೇ ನಿನಗೆ ಮಗನು ಹುಟ್ಟುವನು. ಅವನಿಗೆ ‘ಇಸಾಕ’ ಎಂದು ಹೆಸರಿಡಬೇಕು. ಅವನ ಸಂಗಡ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಾಪಿಸಿಕೊಳ್ಳುವೆನು; ಅದು ಅವನ ಸಂತತಿಯವರಲ್ಲಿಯೂ ಶಾಶ್ವತವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ಇಷ್ಮಾಯೇಲನ ವಿಷಯದಲ್ಲಿ ನೀನು ಮಾಡಿದ ಬಿನ್ನಹವನ್ನು ಕಿವಿಗೊಟ್ಟು ಕೇಳಿದ್ದೇನೆ. ಅವನನ್ನೂ ಆಶೀರ್ವದಿಸಿದ್ದೇನೆ; ಅವನನ್ನು ಅಭಿವೃದ್ಧಿಮಾಡಿ ಅವನಿಗೆ ಅತ್ಯಧಿಕವಾದ ಸಂತಾನವನ್ನು ಕೊಡುವೆನು. ಅವನು ಹನ್ನೆರಡು ಮಂದಿ ಅರಸರನ್ನು ಪಡೆಯುವನು, ಅವನಿಂದ ಮಹಾ ಜನಾಂಗವಾಗುವಂತೆ ಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ಆದರೆ ಆ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಇಸಾಕನೊಂದಿಗೆ ಸ್ಥಾಪಿಸಿಕೊಳ್ಳುತ್ತೇನೆ; ಬರುವ ವರ್ಷ ಇದೇ ವೇಳೆಗೆ ಸಾರಳು ಅವನನ್ನು ಹೆರುವಳು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ಆ ನಂತರ ದೇವರು ಅಬ್ರಹಾಮನ ಸಂಗಡ ಮಾತನಾಡುವುದನ್ನು ಮುಗಿಸಿ ಅವನ ಬಳಿಯಿಂದ ಮೇಲಕ್ಕೆ ಏರಿ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ಅದೇ ದಿನದಲ್ಲಿ ಅಬ್ರಹಾಮನು ತನ್ನ ಮಗನಾದ ಇಷ್ಮಾಯೇಲನಿಗೂ ತನ್ನ ಮನೆಯಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಗಂಡಸರಿಗೂ, ಅಂದರೆ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವರಿಗೆ ಮಾತ್ರವಲ್ಲದೆ, ತಾನು ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡವರಿಗೂ ದೇವರ ಅಪ್ಪಣೆಯಂತೆ ಸುನ್ನತಿಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ಅಬ್ರಹಾಮನಿಗೆ ಸುನ್ನತಿಯಾದಾಗ ಅವನಿಗೆ ತೊಂಭತ್ತೊಂಭತ್ತು ವರ್ಷವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ಇಷ್ಮಾಯೇಲನಿಗೆ ಸುನ್ನತಿಯಾದಾಗ ಅವನಿಗೆ ಹದಿಮೂರು ವರ್ಷವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ಅಬ್ರಹಾಮನಿಗೂ ಅವನ ಮಗನಾದ ಇಷ್ಮಾಯೇಲನಿಗೂ ಒಂದೇ ದಿನದಲ್ಲಿ ಸುನ್ನತಿಯಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ಅವನ ಮನೆಯಲ್ಲಿದ್ದ ಗಂಡಸರೆಲ್ಲರಿಗೂ ಅಂದರೆ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದವರಿಗೆ ಮಾತ್ರವಲ್ಲದೆ, ಅನ್ಯರಿಂದ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡವರಿಗೂ ಅವನೊಂದಿಗೆ ಸುನ್ನತಿಯಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ಅಬ್ರಹಾಮನು ಬಿಸಿಲೇರಿದಾಗ ಮಮ್ರೆಯ ಮೋರೆ ತೋಪಿನ ತನ್ನ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಕುಳಿತಿರುವಾಗ ಯೆಹೋವನು ಅವನಿಗೆ ಪ್ರತ್ಯಕ್ಷನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ಹೇಗೆಂದರೆ, ಅಬ್ರಹಾಮನು ಕಣ್ಣೆತ್ತಿ ನೋಡಲು ಅವನೆದುರಿನಲ್ಲಿ ಮೂವರು ಪುರುಷರು ನಿಂತಿದ್ದರು. ಕೂಡಲೆ ಅವರನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಅವನು ಗುಡಾರದ ಬಾಗಿಲಿನಿಂದ ಓಡಿ ಹೋಗಿ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“ಕರ್ತನೇ, ನಿನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ನನಗೆ ದಯೆ ದೊರೆತಿದ್ದರೆ; ದಾಸನ ಗುಡಾರಕ್ಕೆ ದಯಮಾಡದೆ ಮುಂದೆ ಹೋಗಬೇಡಿರಿ. ನೀವು ದಾಸನಿರುವ ಸ್ಥಳದ ಹತ್ತಿರ ಹಾದು ಹೋಗುತ್ತೀರಲ್ಲಾ. ");
INSERT INTO kanirv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ನೀರು ತರಿಸಿಕೊಡುತ್ತೇನೆ; ನಿಮ್ಮ ಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಮರದ ನೆರಳಿನಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ಸ್ವಲ್ಪ ಆಹಾರ ತರುತ್ತೇನೆ, ಊಟವಾದ ಮೇಲೆ ನೀವು ಮುಂದಕ್ಕೆ ಪ್ರಯಾಣ ಮಾಡಬಹುದು” ಎನ್ನಲು ಅವರು, “ನೀನು ಹೇಳಿದಂತೆ ಮಾಡಬಹುದು” ಅಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ಆಗ ಅಬ್ರಹಾಮನು ಗುಡಾರದಲ್ಲಿದ್ದ ಸಾರಳ ಬಳಿಗೆ ಓಡಿಹೋಗಿ ಆಕೆಗೆ, “ಹಸನಾದ ಮೂರು ಸೇರು ಹಿಟ್ಟನ್ನು ನಾದಿ ಬೇಗ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ಆ ಮೇಲೆ ಅವನು ದನಗಳ ಕಡೆಗೆ ಓಡಿಹೋಗಿ ಕೊಬ್ಬಿದ ಎಳೇ ಕರುವನ್ನು ತೆಗೆದು ಆಳಿನ ಕೈಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ಆಳು ಬೇಗನೆ ಕೊಬ್ಬಿದ ಕರುವನ್ನು ಕಡಿದು, ಅಡಿಗೆ ಮಾಡಿದನು. ತರುವಾಯ ಅಬ್ರಹಾಮನು ಹಾಲು ಮೊಸರನ್ನೂ ಅಡಿಗೆ ಮಾಡಿದ ಮಾಂಸವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಂದು ಆ ಮನುಷ್ಯರಿಗೆ ಬಡಿಸಿದನು. ಅವರು ಮರದ ಕೆಳಗೆ ಕುಳಿತು ಊಟ ಮಾಡುವವರೆಗೂ ಅವನು ಹತ್ತಿರ ನಿಂತು ಅವರಿಗೆ ಉಪಚಾರ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ಬಳಿಕ ಅವರು ಅವನಿಗೆ, “ನಿನ್ನ ಪತ್ನಿಯಾದ ಸಾರಳು ಎಲ್ಲಿದ್ದಾಳೆ” ಎಂದು ಕೇಳಲು ಅವನು “ಅಗೋ, ಗುಡಾರದಲ್ಲಿದ್ದಾಳೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ಅದಕ್ಕೆ ಆತನು, “ಬರುವ ವರ್ಷ ಇದೇ ವೇಳೆಗೆ ನಾನು ತಪ್ಪದೆ ತಿರುಗಿ ನಿನ್ನ ಬಳಿಗೆ ಬರುತ್ತೇನೆ; ಬಂದಾಗ ನಿನ್ನ ಪತ್ನಿಯಾದ ಸಾರಳಿಗೆ ಮಗನಿರುವನು” ಎಂದನು. ಆ ಮಾತು ಹಿಂದೆ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ನಿಂತಿದ್ದ ಸಾರಳ ಕಿವಿಗೆ ಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ಅಬ್ರಹಾಮನೂ ಸಾರಳೂ ಬಹುವೃದ್ಧರಾಗಿದ್ದರು; ಸಾರಳಿಗೆ ಮುಟ್ಟು ನಿಂತು ಹೋಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ಹೀಗಿರಲಾಗಿ ಸಾರಳು, “ನನ್ನಂಥ ಮುದುಕಿಗೆ ಭೋಗವಾದೀತೇ?” ನನ್ನ ಯಜಮಾನನೂ ಮುದುಕನಲ್ಲವೇ ಎಂದು ತನ್ನೊಳಗೆ ನಕ್ಕಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ಯೆಹೋವನು ಅಬ್ರಹಾಮನಿಗೆ, “ಸಾರಳು ನಕ್ಕು, ಮುದುಕಿಯಾದ, ನಾನು ಮಗುವನ್ನು ಹೆರುವುದಾದೀತೇ ಎಂದು ಹೇಳಿದ್ದೇನು? ");
INSERT INTO kanirv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ಯೆಹೋವನಿಗೆ ಅಸಾಧ್ಯವಾದದ್ದುಂಟೋ? ನಾನು ಹೇಳಿದಂತೆಯೇ ಬರುವ ವರ್ಷದ ಇದೇ ಕಾಲದಲ್ಲಿ ನಾನು ನಿನ್ನ ಬಳಿಗೆ ಬಂದಾಗ ಸಾರಳಿಗೆ ಮಗನಿರುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ಆಗ ಸಾರಳು ಭಯಪಟ್ಟು, “ನಾನು ನಗಲಿಲ್ಲ” ಎಂದು ಸುಳ್ಳಾಡಿದಾಗ, ಆತನು ಅದಕ್ಕೆ, “ಹಾಗಲ್ಲ, ನೀನು ನಕ್ಕಿದ್ದುಂಟು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ತರುವಾಯ ಆ ಮನುಷ್ಯರು ಅಲ್ಲಿಂದ ಹೊರಟು ಸೊದೋಮಿನ ಕಡೆಗೆ ನೋಡಿದರು. ಅಬ್ರಹಾಮನು ಅವರನ್ನು ಕಳುಹಿಸಿಕೊಡಲು ಅವರ ಜೊತೆಯಲ್ಲೇ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ಆಗ ಯೆಹೋವನು ತನ್ನೊಳಗೆ, “ನಾನು ಮಾಡಬೇಕೆಂದಿರುವ ಕಾರ್ಯವನ್ನು ಅಬ್ರಹಾಮನಿಗೆ ಮರೆಮಾಡುವುದು ಸರಿಯೋ? ");
INSERT INTO kanirv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ಅವನಿಂದ ಬಲಿಷ್ಠವಾದ ಮಹಾ ಜನಾಂಗವು ಹುಟ್ಟಬೇಕಲ್ಲಾ; ಅವನ ಮೂಲಕ ಭೂಮಿಯ ಎಲ್ಲಾ ಜನಾಂಗಗಳಿಗೂ ಆಶೀರ್ವಾದ ಉಂಟಾಗುವುದಲ್ಲಾ; ");
INSERT INTO kanirv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ಅವನು ತನ್ನ ಮಕ್ಕಳಿಗೂ ಮನೆಯವರಿಗೂ ನ್ಯಾಯ ನೀತಿಗಳನ್ನು ತಿಳಿಸಿ ಯೆಹೋವನ ಮಾರ್ಗವನ್ನು ಅನುಸರಿಸಬೇಕೆಂದು ಬೋಧಿಸುವಂತೆ ಅವನನ್ನು ನಾನು ಆರಿಸಿಕೊಂಡೆನಲ್ಲಾ; ಅವನು ಹೀಗೆ ಮಾಡುವುದರಿಂದ ಯೆಹೋವನಾದ ನನ್ನ ವಾಗ್ದಾನವು ನೆರವೇರುವುದು” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ಇದಲ್ಲದೆ ಯೆಹೋವನು, “ಸೊದೋಮ್ ಗೊಮೋರಗಳ ದೊಡ್ಡ ಮೊರೆ ನನಗೆ ಮುಟ್ಟಿತು; ಆ ಊರಿನವರ ಮೇಲೆ ಹೊರಿಸಿರುವ ಪಾಪವು ಎಷ್ಟೋ ಘೋರವಾದದ್ದು, ");
INSERT INTO kanirv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ನಾನು ಇಳಿದು ಹೋಗಿ, ನನಗೆ ಮುಟ್ಟಿದ ಮೊರೆಯಂತೆಯೇ ಅವರು ಮಾಡಿರುವರೋ ಇಲ್ಲವೋ ಎಂದು ನೋಡಿ ತಿಳಿದುಕೊಳ್ಳುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ಆ ಮನುಷ್ಯರು ಅಲ್ಲಿಂದ ಸೊದೋಮಿನ ಕಡೆಗೆ ಹೋದರು; ಆದರೆ ಅಬ್ರಹಾಮನು ಯೆಹೋವನಿಗೆ ಎದುರಾಗಿ ಇನ್ನೂ ನಿಂತುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ಆಗ ಅಬ್ರಹಾಮನು ಹತ್ತಿರಕ್ಕೆ ಬಂದು, “ನೀನು ದುಷ್ಟರ ಸಂಗಡ ನೀತಿವಂತರನ್ನೂ ನಾಶಮಾಡುವಿಯಾ? ");
INSERT INTO kanirv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ಒಂದು ವೇಳೆ ಆ ಪಟ್ಟಣದೊಳಗೆ ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರಿದ್ದಾರು; ಅದರಲ್ಲಿ ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರಿದ್ದರೂ ಆ ಸ್ಥಳವನ್ನು ಉಳಿಸದೆ ನಾಶಮಾಡುವಿಯಾ? ");
INSERT INTO kanirv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ಆ ರೀತಿಯಾಗಿ ದುಷ್ಟರಿಗೂ ಶಿಷ್ಟರಿಗೂ ಭೇದ ಮಾಡದೆ ದುಷ್ಟರ ಸಂಗಡ ನೀತಿವಂತರನ್ನೂ ಸಂಹರಿಸುವುದು ನಿನ್ನಿಂದ ಎಂದಿಗೂ ಆಗಬಾರದು; ಸರ್ವಲೋಕಕ್ಕೆ ನ್ಯಾಯತೀರಿಸುವವನು ನ್ಯಾಯವನ್ನೇ ನಡಿಸುವನಲ್ಲವೇ” ಎಂದು ಹೇಳಲು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ಯೆಹೋವನು, “ಸೊದೋಮನಲ್ಲಿ ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರು ನನಗೆ ಸಿಕ್ಕಿದರೆ ಅವರ ನಿಮಿತ್ತ ಪಟ್ಟಣವನ್ನೆಲ್ಲಾ ಉಳಿಸುವೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ಅದಕ್ಕೆ ಅಬ್ರಹಾಮನು, “ಇಗೋ, ಮಣ್ಣೂ ಬೂದಿಯೂ ಆಗಿರುವ ನಾನು ಸ್ವಾಮಿಯ ಸಂಗಡ ವಾದಿಸುವುದಕ್ಕೆ ಧೈರ್ಯಗೊಂಡಿದ್ದೇನೆ; ");
INSERT INTO kanirv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ಒಂದು ವೇಳೆ ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರಲ್ಲಿ ಐದು ಮಂದಿ ಕಡಿಮೆ ಇದ್ದರೆ ಪಟ್ಟಣವನ್ನೆಲ್ಲಾ ನಾಶ ಮಾಡುವಿಯಾ?” ಎಂದು ಕೇಳಲು ಯೆಹೋವನು, “ಅಲ್ಲಿ ನಲ್ವತ್ತೈದು ಮಂದಿ ನೀತಿವಂತರು ಸಿಕ್ಕಿದರೆ ಅದನ್ನು ನಾಶ ಮಾಡುವುದಿಲ್ಲ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ಅಬ್ರಹಾಮನು ಆತನ ಸಂಗಡ ಇನ್ನೂ ಮಾತನಾಡಿ, “ಒಂದು ವೇಳೆ ಅಲ್ಲಿ ನಲ್ವತ್ತು ಮಂದಿ ಸಿಕ್ಕಾರು” ಎನ್ನಲು ಆತನು, “ನಲ್ವತ್ತು ಮಂದಿ ಸಿಕ್ಕಿದರೆ ಆ ಪಟ್ಟಣವನ್ನು ನಾಶ ಮಾಡುವುದಿಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ಅಬ್ರಹಾಮನು, “ಕರ್ತನೇ, ಕೋಪಮಾಡಬಾರದು; ಇನ್ನೂ ಮಾತನಾಡುತ್ತೇನೆ; ಒಂದು ವೇಳೆ ಮೂವತ್ತು ಮಂದಿ ಅಲ್ಲಿ ಸಿಕ್ಕಾರು” ಎನ್ನಲು ಆತನು, “ಅಲ್ಲಿ ಮೂವತ್ತು ಮಂದಿ ಸಿಕ್ಕಿದರೆ ಅದನ್ನು ನಾಶ ಮಾಡುವುದಿಲ್ಲ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ಅವನು, “ಇಗೋ, ಸ್ವಾಮಿಯ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ಧೈರ್ಯಗೊಂಡಿದ್ದೇನೆ; ಒಂದು ವೇಳೆ ಇಪ್ಪತ್ತು ಮಂದಿ ಅಲ್ಲಿ ಸಿಕ್ಕಾರು” ಎನ್ನಲು ಆತನು, “ಇಪ್ಪತ್ತು ಮಂದಿಯಿದ್ದರೆ ಅವರ ನಿಮಿತ್ತ ಆ ಪಟ್ಟಣವನ್ನು ಉಳಿಸುವೆನು, ನಾಶ ಮಾಡುವುದಿಲ್ಲ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ಅಬ್ರಹಾಮನು, “ಕರ್ತನೇ, ಸಿಟ್ಟಾಗಬಾರದು; ಇನ್ನು ಒಂದೇ ಸಾರಿ ಮಾತನಾಡುತ್ತೇನೆ; ಒಂದು ವೇಳೆ ಹತ್ತು ಮಂದಿ ಸಿಕ್ಕಾರು” ಎನ್ನಲು ಆತನು, “ಹತ್ತು ಮಂದಿಯ ನಿಮಿತ್ತವೂ ಅದನ್ನು ಉಳಿಸುವೆನು, ನಾಶ ಮಾಡುವುದಿಲ್ಲ.” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ಯೆಹೋವನು ಅಬ್ರಹಾಮನ ಸಂಗಡ ಮಾತನಾಡುವುದನ್ನು ನಿಲ್ಲಿಸಿ ಅಲ್ಲಿಂದ ಹೊರಟು ಹೋದನು; ಅಬ್ರಹಾಮನು ತನ್ನ ಸ್ಥಳಕ್ಕೆ ಹಿಂದಿರುಗಿ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ಆ ದೂತರಿಬ್ಬರು ಸಾಯಂಕಾಲದಲ್ಲಿ ಸೊದೋಮಿಗೆ ಬಂದಾಗ ಲೋಟನು ಸೊದೋಮಿನ ಊರು ಬಾಗಿಲಲ್ಲಿ ಕುಳಿತುಕೊಂಡಿದ್ದನು. ಅವನು ಅವರನ್ನು ಕಂಡಾಗ ಎದ್ದು, ಎದುರುಗೊಂಡು ತಲೆ ಬಾಗಿ ನಮಸ್ಕರಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“ಸ್ವಾಮಿಗಳೇ, ನಿಮ್ಮ ದಾಸನ ಮನೆಗೆ ಬಂದು ಇಳಿದುಕೊಂಡು ಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಿರಿ; ಬೆಳಿಗ್ಗೆ ನಿಮ್ಮ ಮಾರ್ಗ ಹಿಡಿದುಕೊಂಡು ಹೋಗಬಹುದು” ಅಂದನು. ಅವರು, “ಹಾಗಲ್ಲ, ಬೀದಿಯಲ್ಲೇ ರಾತ್ರಿ ಕಳೆಯುತ್ತೇವೆ” ಎನ್ನಲು ");
INSERT INTO kanirv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ಅವನು ಅವರನ್ನು ಬಹಳ ಬಲವಂತ ಮಾಡಿದ್ದರಿಂದ ಅವರು ಅವನ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವುದಕ್ಕೆ ಒಪ್ಪಿದರು. ಅವರು ಮನೆಗೆ ಬಂದಾಗ ಅವನು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಿ ಔತಣವನ್ನು ಮಾಡಿಸಲು ಅವರು ಊಟಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ಅವರು ಮಲಗುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಹುಡುಗರು ಮುದುಕರು ಸಹಿತವಾಗಿ ಸೊದೋಮಿನ ಪಟ್ಟಣದವರೆಲ್ಲರೂ ಒಗ್ಗಟ್ಟಾಗಿ ಮನೆಯನ್ನು ಮುತ್ತಿಗೆ ಹಾಕಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ಲೋಟನಿಗೆ, “ಈ ರಾತ್ರಿ ನಿನ್ನ ಬಳಿಗೆ ಬಂದ ಮನುಷ್ಯರು ಎಲ್ಲಿ? ಅವರನ್ನು ಹೊರಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಾ; ಅವರೊಡನೆ ನಮಗೆ ಸಂಗಮವಾಗಬೇಕೆಂದು” ಕೂಗಿ ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ಲೋಟನು ಅವರ ಬಳಿಗೆ ಹೊರಕ್ಕೆ ಬಂದು ತನ್ನ ಹಿಂದೆ ಕದಹಾಕಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“ಅಣ್ಣಂದಿರೇ, ಈ ದುಷ್ಟತನವನ್ನು ಮಾಡಬೇಡಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ಕೇಳಿರಿ, ನನಗೆ ಪುರುಷನನ್ನು ಅರಿಯದ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳು ಇದ್ದಾರೆ; ಅವರನ್ನಾದರೂ ನಿಮಗೆ ತಂದು ಒಪ್ಪಿಸುತ್ತೇನೆ; ಅವರನ್ನು ಮನಸ್ಸು ಬಂದಂತೆ ಮಾಡಬಹುದು; ಆದರೆ ಆ ಮನುಷ್ಯರು ನನ್ನ ಆಶ್ರಯಕ್ಕೆ ಬಂದವರು; ಅವರಿಗೆ ಏನೂ ಮಾಡಕೂಡದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ಅವರು ದಾರಿ ಬಿಡು ಎಂದು ಹೇಳಿ, “ಇವನು ಯಾರೋ ಒಬ್ಬ ಪರದೇಶಿಯಾಗಿ ಬಂದು ಈಗ ನ್ಯಾಯಾಧಿಪತಿಯಾಗಬೇಕೆಂದಿದ್ದಾನೆ; ಆ ಮನುಷ್ಯರಿಗೆ ಕೇಡು ಮಾಡುವುದಕ್ಕಿಂತ ಹೆಚ್ಚಾಗಿ ನಿನಗೇ ಕೇಡು ಮಾಡುತ್ತೇವೆ” ಎಂದು ಹೇಳಿ ಲೋಟನ ಮೇಲೆ ಬಿದ್ದು ಬಹಳವಾಗಿ ತುಳಿದು ಬಾಗಿಲನ್ನು ಮುರಿಯಲು ಸಮೀಪಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ಆದರೆ ಒಳಗಿದ್ದ ಆ ಮನುಷ್ಯರು ಕೈಚಾಚಿ ಲೋಟನನ್ನು ತಮ್ಮ ಕಡೆಗೆ ಎಳೆದುಕೊಂಡು ಮನೆಯೊಳಗೆ ಸೇರಿಸಿ ಕದ ಮುಚ್ಚಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ಇದಲ್ಲದೆ ಅವರು ಮನೆಯ ಹೊರಗಿದ್ದ ಮನುಷ್ಯರಿಗೆ ಚಿಕ್ಕವರಿಗೂ ದೊಡ್ಡವರಿಗೂ ಕೂಡ ಕಣ್ಣು ಮೊಬ್ಬಾಗುವಂತೆ ಮಾಡಿದ್ದರಿಂದ ಅವರು ಬಾಗಿಲು ಯಾವುದೆಂದು ತಿಳಿಯದೆ ಬೇಸರಗೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ಆಗ ಆ ದೂತರು ಲೋಟನಿಗೆ, “ಇಲ್ಲಿ ನಿನಗೆ ಇನ್ನಾರಿದ್ದಾರೆ? ಅಳಿಯಂದಿರನ್ನೂ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನೂ ಪಟ್ಟಣದಲ್ಲಿ ನಿನಗಿರುವ ಎಲ್ಲರನ್ನೂ ಊರ ಹೊರಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಾ. ");
INSERT INTO kanirv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ನಾವು ಈ ಸ್ಥಳವನ್ನು ನಾಶಮಾಡುವುದಕ್ಕೆ ಬಂದವರು. ಇಲ್ಲಿಯವರ ವಿಷಯವಾಗಿ ಬಲು ದೊಡ್ಡ ಮೊರೆಯು ಯೆಹೋವನಿಗೆ ಮುಟ್ಟಿದ್ದರಿಂದ ಇವರನ್ನು ನಾಶಮಾಡುವುದಕ್ಕಾಗಿ ಆತನು ನಮ್ಮನ್ನು ಕಳುಹಿಸಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ಆಗ ಲೋಟನು ಹೊರಕ್ಕೆ ಹೋಗಿ ತನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಗೊತ್ತುಮಾಡಿಕೊಂಡಿದ್ದ ಅಳಿಯಂದಿರಿಗೆ ಈ ಸಂಗತಿಯನ್ನು ತಿಳಿಸಿ, “ನೀವೆದ್ದು, ಈ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಹೋಗಿರಿ ಯೆಹೋವನು ಈ ಊರನ್ನು ನಾಶಮಾಡುತ್ತಾನೆ” ಎಂದು ಹೇಳಿದನು. ಆದರೆ ಅವರು ಲೋಟನು ಅಪಹಾಸ್ಯ ಮಾಡುತ್ತಿದ್ದಾನೆ ಎಂದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ಹೊತ್ತು ಮೂಡುವುದಕ್ಕೆ ಮುಂಚೆ ಆ ದೂತರು ಲೋಟನಿಗೆ, “ನೀನೆದ್ದು ಇಲ್ಲಿರುವ ನಿನ್ನ ಹೆಂಡತಿಯನ್ನೂ ನಿನ್ನ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನೂ ಬೇಗ ಕರೆದುಕೊಂಡು ಹೋಗು; ಊರಿಗೆ ಉಂಟಾಗುವ ದಂಡನೆಯಿಂದ ನಿನಗೂ ನಾಶವುಂಟಾದೀತು” ಎಂದು ಹೇಳಿ ತ್ವರೆಪಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ಅವನು ತಡಮಾಡಲು ಯೆಹೋವನು ಅವನನ್ನು ಕನಿಕರಿಸಿದ್ದರಿಂದ ಆ ಮನುಷ್ಯರು ಅವನನ್ನೂ ಅವನ ಹೆಂಡತಿ ಮಕ್ಕಳನ್ನೂ ಕೈಹಿಡಿದು ಹೊರಗೆ ತಂದು ಪಟ್ಟಣದ ಆಚೆಗೆ ಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ಅವರನ್ನು ಹೊರಗೆ ತಂದ ಮೇಲೆ ಅವರಲ್ಲಿ ಒಬ್ಬನು, “ಓಡಿಹೋಗು, ಪ್ರಾಣವನ್ನು ಉಳಿಸಿಕೋ; ಹಿಂದಕ್ಕೆ ತಿರುಗಿ ನೋಡಬೇಡ; ಈ ಪ್ರದೇಶದೊಳಗೆ ಎಲ್ಲಿಯೂ ನಿಲ್ಲದೆ ಬೆಟ್ಟದ ಸೀಮೆಗೆ ಓಡಿಹೋಗು; ನಿನಗೂ ನಾಶವುಂಟಾದೀತು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ಅದಕ್ಕೆ ಲೋಟನು, “ಕರ್ತನೇ, ಅದು ನನ್ನಿಂದಾಗದು; ");
INSERT INTO kanirv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ನೀನು ನಿನ್ನ ದಾಸನ ಮೇಲೆ ದಯೆ ಇಟ್ಟು ನನ್ನ ಪ್ರಾಣವನ್ನು ಉಳಿಸಿದ್ದು ಬಹು ವಿಶೇಷವಾದ ಉಪಕಾರವೇ; ಆದರೆ ಬೆಟ್ಟಕ್ಕೆ ಓಡಿ ಹೋಗಲಾರೆನು; ನಾನು ಹೋಗುತ್ತಿರುವಾಗ ಆ ವಿಪತ್ತು ನನಗೂ ಉಂಟಾಗಿ ಸತ್ತೇನು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ಆಗೋ, ಅಲ್ಲಿ ಒಂದು ಪಟ್ಟಣ ಹತ್ತಿರವಾಗಿದೆ; ಅದು ಸಣ್ಣದು; ಅಲ್ಲಿಗಾದರೂ ಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆಯಾದರೆ ನನ್ನ ಪ್ರಾಣ ಉಳಿಯುವುದು; ಆ ಊರು ಸಣ್ಣದಲ್ಲವೇ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ಅದಕ್ಕಾತನು, “ಈ ವಿಷಯದಲ್ಲಿಯೂ ನಿನ್ನ ಬೇಡಿಕೆಯನ್ನು ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ, ನೋಡು; ನೀನು ಹೇಳಿದ ಊರನ್ನು ನಾನು ಕೆಡವಿ ಹಾಕುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ಬೇಗ ಅಲ್ಲಿಗೆ ಹೋಗಿ ತಪ್ಪಿಸಿಕೋ; ನೀನು ಆ ಪಟ್ಟಣವನ್ನು ಮುಟ್ಟುವ ತನಕ ನಾನೇನೂ ಮಾಡುವುದಕ್ಕಾಗುವುದಿಲ್ಲ” ಎಂದನು. ಇದರಿಂದ ಆ ಊರಿಗೆ ಚೋಗರ್ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ಲೋಟನು ಚೋಗರ್ ಮುಟ್ಟುವಷ್ಟರಲ್ಲಿ ಸೂರ್ಯನು ಉದಯಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ಆಗ ಯೆಹೋವನು ಸೊದೋಮ್ ಗೊಮೋರಗಳ ಮೇಲೆ ಆಕಾಶದಿಂದ ಅಗ್ನಿಗಂಧಕಗಳನ್ನು ಸುರಿಸಿ ");
INSERT INTO kanirv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ಆ ಪಟ್ಟಣಗಳನ್ನೂ ಸುತ್ತಲಿರುವ ಸೀಮೆಯೆಲ್ಲವನ್ನೂ ಊರುಗಳಲ್ಲಿದ್ದ ಜನರೆಲ್ಲರನ್ನೂ ಭೂಮಿಯ ಮೇಲಣ ಎಲ್ಲಾ ಬೆಳೆಯನ್ನೂ ಹಾಳುಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ಲೋಟನ ಹೆಂಡತಿ ಅವನ ಹಿಂದೆ ಬರುತ್ತಿರುವಾಗ ಹಿಂತಿರುಗಿ ನೋಡಿದ್ದರಿಂದ ಉಪ್ಪಿನ ಕಂಬವಾದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ಇತ್ತಲಾಗಿ ಅಬ್ರಹಾಮನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು ತಾನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಂತಿದ್ದ ಸ್ಥಳಕ್ಕೆ ತಿರುಗಿ ಬಂದು ಸೊದೋಮ್ ಗೊಮೋರಗಳ ಕಡೆಗೂ ");
INSERT INTO kanirv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ಸೊದೋಮ್ ಗೊಮೋರದ ಸುತ್ತಲಿನ ಎಲ್ಲಾ ದಿಕ್ಕುಗಳ ಕಡೆಗೂ ನೋಡಿದಾಗ, ಅಯ್ಯೋ, ಆ ಪ್ರದೇಶದಿಂದ ಹೊಗೆಯು ಆವಿಗೆಯ ಹೊಗೆಯಂತೆ ಮೇಲಕ್ಕೇರುತ್ತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ದೇವರು ಆ ಪ್ರದೇಶದ ಪಟ್ಟಣಗಳನ್ನು ನಾಶಮಾಡಿದಾಗ, ಅಬ್ರಹಾಮನನ್ನು ನೆನಪುಮಾಡಿಕೊಂಡನು. ಲೋಟನು ವಾಸವಾಗಿದ್ದ ಪಟ್ಟಣಗಳನ್ನು ಹಾಳುಮಾಡಿ ಆ ಸ್ಥಳದೊಳಗಿಂದ ಲೋಟನನ್ನು ಹೊರಗೆ ಕಳುಹಿಸಿ ಪಾರುಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ಲೋಟನು ಚೋಗರಿನಲ್ಲಿರುವುದಕ್ಕೆ ಹೆದರಿ ತನ್ನ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಅಲ್ಲಿ ವಾಸಮಾಡಿದನು. ಅವನೂ ಅವನ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳೂ ಒಂದು ಗವಿಯಲ್ಲಿ ವಾಸಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ಹೀಗಿರುವಲ್ಲಿ ಹಿರೀಮಗಳು ತನ್ನ ತಂಗಿಗೆ, “ನಮ್ಮ ತಂದೆ ಮುದುಕನಷ್ಟೆ; ಸರ್ವಲೋಕದ ಪದ್ಧತಿಯ ಮೇರೆಗೆ ನಮ್ಮನ್ನು ಮದುವೆ ಮಾಡಿಕೊಳ್ಳುವ ಪುರುಷರು ಎಲ್ಲಿಯೂ ಇಲ್ಲ; ");
INSERT INTO kanirv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ನಾವು ತಂದೆಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸಿ, ಅವನ ಸಂಗಡ ಮಲಗಿಕೊಂಡು ತಂದೆಯಿಂದ ಸಂತಾನವನ್ನು ಪಡೆದುಕೊಳ್ಳೋಣ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ಆ ರಾತ್ರಿ ಅವರು ತಂದೆಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸಿದಾಗ ಹಿರೀ ಮಗಳು ಅವನ ಸಂಗಡ ಮಲಗಿಕೊಂಡಳು; ಯಾವಾಗ ಮಲಗಿಕೊಂಡಳೋ ಯಾವಾಗ ಎದ್ದು ಹೋದಳೋ ಅವನಿಗೇನೂ ತಿಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ಮಾರನೆಯ ದಿನ ಹಿರಿಯವಳು ಕಿರಿಯವಳಿಗೆ, “ನಿನ್ನೆಯ ರಾತ್ರಿ ನಾನೇ ಅಪ್ಪನ ಸಂಗಡ ಮಲಗಿಕೊಂಡೆನು; ಈ ರಾತ್ರಿಯೂ ಅವನಿಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸೋಣ; ಆ ಮೇಲೆ ನೀನು ಅವನ ಸಂಗಡ ಮಲಗಿಕೋ; ಹೀಗೆ ನಮ್ಮ ತಂದೆಯಿಂದ ಸಂತಾನವನ್ನು ಪಡೆದುಕೊಳ್ಳೋಣ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ಆ ರಾತ್ರಿಯೂ ಅವರು ತಂದೆಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸಿದ ಮೇಲೆ ಕಿರಿಯ ಮಗಳು ಅವನ ಸಂಗಡ ಮಲಗಿಕೊಂಡಳು; ಅವಳು ಯಾವಾಗ ಮಲಗಿದಳೋ ಯಾವಾಗ ಎದ್ದು ಹೋದಳೋ ಅವನಿಗೇನೂ ತಿಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ಹೀಗೆ ಲೋಟನ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳು ತಂದೆಯಿಂದ ಬಸುರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ಹಿರಿಯವಳು ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತು ಅದಕ್ಕೆ “ಮೋವಾಬ್” (ತಂದೆಯಿಂದ ಹುಟ್ಟಿದವನು) ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಇಂದಿನ ವರೆಗೂ ಇರುವ ಮೋವಾಬ್ಯರಿಗೆ ಅವನೇ ಮೂಲಪುರುಷನು. ");
INSERT INTO kanirv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ಕಿರಿಯ ಮಗಳು ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತು ಅದಕ್ಕೆ “ಬೆನಮ್ಮಿ” (ರಕ್ತ ಸಂಬಂಧಿಕನ ಮಗ) ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಇಂದಿನವರೆಗೂ ಇರುವ ಅಮ್ಮೋನಿಯರಿಗೆ ಇವನೇ ಮೂಲಪುರುಷನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ಅಬ್ರಹಾಮನು ಅಲ್ಲಿಂದ ಕಾನಾನ್ ದೇಶದ ದಕ್ಷಿಣ ಸೀಮೆಗೆ ಪ್ರಯಾಣ ಮಾಡುತ್ತಾ ಕಾದೇಶಿಗೂ ಶೂರಿಗೂ ನಡುವೆ ವಾಸ ಮಾಡಿ ಕೆಲವು ಕಾಲ ಗೆರಾರಿನಲ್ಲೂ ವಾಸಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ಅವನು ತನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಳನ್ನು ತಂಗಿಯೆಂದು ಹೇಳಿಕೊಂಡದ್ದರಿಂದ, ಗೆರಾರಿನ ಅರಸನಾದ ಅಬೀಮೆಲೆಕನು ಆಕೆಯನ್ನು ಕರೆಸಿ ತನ್ನ ಮನೆಯಲ್ಲಿ ಇರಿಸಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ಆದರೆ ಆ ರಾತ್ರಿ ದೇವರು ಅಬೀಮೆಲೆಕನ ಕನಸಿನಲ್ಲಿ ಬಂದು, “ನೀನು ಆ ಸ್ತ್ರೀಯನ್ನು ಸೇರಿಸಿಕೊಂಡಿರುವುದರಿಂದ ಮರಣಕ್ಕೆ ಯೋಗ್ಯನಾಗಿದ್ದಿ; ಆಕೆ ಮತ್ತೊಬ್ಬ ಪುರುಷನ ಹೆಂಡತಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ಅಬೀಮೆಲೆಕನು ಆಕೆಯನ್ನು ಸಂಗಮಿಸಿರಲಿಲ್ಲ. ಅವನು, “ಕರ್ತನೇ, ನೀತಿವಂತರಾದ ಜನರನ್ನೂ ನಾಶಮಾಡುವಿಯಾ? ");
INSERT INTO kanirv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ಆ ಮನುಷ್ಯನು ಈಕೆ ತನಗೆ ತಂಗಿಯಾಗಬೇಕೆಂದು ಹೇಳಿದನು. ಈಕೆಯೂ ಅವನು ತನಗೆ ಅಣ್ಣನಾಗಬೇಕೆಂದು ಹೇಳಿದಳು. ನಾನು ಯಥಾರ್ಥ ಮನಸ್ಸಿನಿಂದಲೂ, ಶುದ್ಧ ಹಸ್ತದಿಂದಲೂ ಇದನ್ನು ಮಾಡಿದೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ಅದಕ್ಕೆ ದೇವರು, “ನೀನು, ಇದನ್ನು ಯಥಾರ್ಥ ಮನಸ್ಸಿನಿಂದ ಮಾಡಿದೆ ಎಂಬುದನ್ನು ನಾನು ಬಲ್ಲೆ; ಆದಕಾರಣ ನೀನು ನನಗೆ ವಿರುದ್ಧವಾಗಿ ಪಾಪಮಾಡದಂತೆ ನಾನು ನಿನ್ನನ್ನು ತಡೆದು ಆಕೆಯನ್ನು ಮುಟ್ಟಗೊಡಿಸಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ಹೀಗಿರುವಲ್ಲಿ ಆ ಮನುಷ್ಯನ ಹೆಂಡತಿಯನ್ನು ಅವನಿಗೆ ಒಪ್ಪಿಸಿಬಿಡು. ಅವನು ಪ್ರವಾದಿ, ನಿನಗೋಸ್ಕರ ಅವನು ನನಗೆ ವಿಜ್ಞಾಪಿಸುವನು ಮತ್ತು ನೀನು ಬದುಕುವಿ. ಆಕೆಯನ್ನು ಒಪ್ಪಿಸದಿದ್ದರೆ ನೀನೂ ನಿನ್ನವರೆಲ್ಲರೂ ಮರಣಹೊಂದುವಿರಿ ಇದು ಖಂಡಿತ ಎಂದು ತಿಳಿದುಕೋ” ಎಂದು ಕನಸಿನಲ್ಲಿ ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ಬೆಳಿಗ್ಗೆ ಅಬೀಮೆಲೆಕನು ತನ್ನ ಸೇವಕರೆಲ್ಲರನ್ನು ಕೂಡಿಸಿ ಈ ಸಂಗತಿಗಳನ್ನೆಲ್ಲಾ ತಿಳಿಸಲು ಅವರು ಬಹಳ ಭಯಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನನ್ನು ಕರೆದು, “ನೀನು ನಮಗೆ ಮಾಡಿದ್ದೇನು? ನಾನು ಯಾವ ಪಾಪ ಮಾಡಿದ್ದರಿಂದ ನೀನು ನನ್ನನ್ನೂ ನನ್ನ ರಾಜ್ಯವನ್ನೂ ಮಹಾಪಾತಕಕ್ಕೆ ಒಳಪಡಿಸಿದಿ? ನೀನು ಮಾಡಬಾರದ ಕಾರ್ಯಗಳನ್ನು ಮಾಡಲು ನಾನು ನಿನಗೇನು ಮಾಡಿದೆ” ಎಂದು ಹೇಳಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","“ನೀನು ಯಾವ ಉದ್ದೇಶದಿಂದ ಈ ಕಾರ್ಯವನ್ನು ಮಾಡಿದೆ” ಎಂದು ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನನ್ನು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ಅದಕ್ಕೆ ಅಬ್ರಹಾಮನು, “ಈ ಸ್ಥಳದವರು ದೇವರ ಭಯಭಕ್ತಿ ಇಲ್ಲದವರಾಗಿ ನನ್ನ ಹೆಂಡತಿಯ ನಿಮಿತ್ತ ನನ್ನನ್ನು ಕೊಂದಾರೆಂದು ಭಾವಿಸಿದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ಅದಲ್ಲದೆ ಆಕೆ ನಿಜವಾಗಿ ನನ್ನ ತಂಗಿ, ನನ್ನ ತಂದೆಯ ಮಗಳೇ; ಆದರೆ ನನ್ನ ತಾಯಿಯ ಮಗಳಲ್ಲವಾದುದರಿಂದ ನನಗೆ ಹೆಂಡತಿಯಾದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ನಾನು ದೇವರ ಸಂಕಲ್ಪದಿಂದ ತಂದೆಯ ಮನೆಯನ್ನು ಬಿಟ್ಟು ದೇಶಾಂತರ ಹೋಗುವುದಕ್ಕೆ ಹೊರಟಾಗ ನಾನು ಆಕೆಗೆ, ‘ನಾವು ಹೋಗುವ ಎಲ್ಲಾ ಸ್ಥಳಗಳಲ್ಲಿಯೂ ನನಗೆ ನಿನ್ನಿಂದ ಒಂದು ದಯೆ ಆಗಬೇಕು. ಅದು, ಏನೆಂದರೆ ನೀನು ನನ್ನನ್ನು ಅಣ್ಣನೆಂಬುದಾಗಿ ಹೇಳಬೇಕು’ ಎಂದು ತಿಳಿಸಿದೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ಆಗ ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನಿಗೆ ಕುರಿದನಗಳನ್ನೂ ದಾಸದಾಸಿಯರನ್ನೂ ಕೊಟ್ಟು, ಅವನ ಹೆಂಡತಿಯಾದ ಸಾರಳನ್ನು ಅವನಿಗೆ ಒಪ್ಪಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","“ಇಗೋ, ಇದು ನನ್ನ ದೇಶ; ಇದರೊಳಗೆ ನಿನಗೆ ಇಷ್ಟವಿದ್ದ ಕಡೆಯಲ್ಲಿ ನೀನು ವಾಸ ಮಾಡಬಹುದು” ಎಂದು ಅಬೀಮೆಲೆಕನು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ಇದಲ್ಲದೆ ಅವನು ಸಾರಳಿಗೆ, “ನಿನ್ನ ಅಣ್ಣನಿಗೆ ಸಾವಿರ ರೂಪಾಯಿ ಕೊಟ್ಟಿದ್ದೇನೆ; ನಡೆದದ್ದನ್ನು ನಿನ್ನ ಕಡೆಯವರು ಗಮನಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳದಂತೆ ಇರಲು ಇದು ಪ್ರಾಯಶ್ಚಿವಾಗಿರಲಿ; ನೀನು ಮಾನಸ್ಥಳೆಂದು ಇದರಿಂದ ಎಲ್ಲರೂ ತಿಳಿದುಕೊಳ್ಳುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ತರುವಾಯ ಅಬ್ರಹಾಮನು ದೇವರನ್ನು ಬೇಡಿಕೊಳ್ಳಲು ದೇವರು ಅಬೀಮೆಲೆಕನನ್ನೂ, ಅವನ ಪತ್ನಿಯನ್ನೂ ಮತ್ತು ದಾಸಿಯರನ್ನೂ ವಾಸಿಮಾಡಿದ್ದರಿಂದ ಅವರಿಗೆ ಮಕ್ಕಳಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ಅಬ್ರಹಾಮನ ಹೆಂಡತಿಯಾದ ಸಾರಳ ನಿಮಿತ್ತ ಮೊದಲು ಯೆಹೋವನು ಅಬೀಮೆಲೆಕನ ಮನೆಯಲ್ಲಿದ್ದ ಸ್ತ್ರೀಯರೆಲ್ಲರನ್ನು ಬಂಜೆಯರನ್ನಾಗಿ ಮಾಡಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ಯೆಹೋವನು ತಾನು ವಾಗ್ದಾನ ಮಾಡಿದಂತೆಯೇ ಸಾರಳ ಮೇಲೆ ದಯವಿಟ್ಟು ಆಕೆಗೆ ಕೊಟ್ಟ ಮಾತನ್ನು ನೆರವೇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ಅದರಂತೆ ಸಾರಳು ಬಸುರಾಗಿ, ದೇವರು ಮೊದಲು ಸೂಚಿಸಿದ ಕಾಲದಲ್ಲಿ ಅಬ್ರಹಾಮನಿಂದ ಅವನ ಮುಪ್ಪಿನಲ್ಲೇ ಅವನಿಗೆ ಒಬ್ಬ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ಅಬ್ರಹಾಮನು ಸಾರಳಲ್ಲಿ ತನ್ನಿಂದ ಹುಟ್ಟಿದ ಮಗನಿಗೆ “ಇಸಾಕ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ದೇವರ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಅಬ್ರಹಾಮನು ಇಸಾಕನಿಗೆ ಸುನ್ನತಿ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ಇಸಾಕನು ಹುಟ್ಟಿದಾಗ ಅಬ್ರಹಾಮನು ನೂರು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ಸಾರಳು, “ದೇವರು ನನ್ನನ್ನು ಸಂತೋಷಪಡಿಸಿ ನಗುವಂತೆ ಮಾಡಿದ್ದಾನೆ; ಇದುವರೆಗೂ ಈ ಬಗ್ಗೆ ಕೇಳಿದವರು ನನ್ನೊಡನೆ ನಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ಸಾರಳೂ ಮಕ್ಕಳಿಗೆ ಮೊಲೆ ಕುಡಿಸುವಳೆಂದು ಯಾರಾದರೂ ಅಬ್ರಹಾಮನಿಗೆ ಹೇಳಲು ಸಾಧ್ಯವಿತ್ತೇ? ಆದರೆ ದೇವರ ಚಿತ್ತದಿಂದ ನನ್ನ ಮುಪ್ಪಿನಲ್ಲಿ ಮತ್ತು ಅಬ್ರಹಾಮನ ಮುಪ್ಪಿನಲ್ಲೇ ಅವನಿಗೆ ಮಗನನ್ನು ಹೆತ್ತಿದ್ದೇನಲ್ಲಾ” ಎಂದು ಹೇಳಿಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ಆ ಕೂಸು ಬೆಳೆದು ಮೊಲೆಬಿಟ್ಟಿತು. ಇಸಾಕನು ಮೊಲೆ ಬಿಟ್ಟ ದಿನದಲ್ಲಿ ಅಬ್ರಹಾಮನು ದೊಡ್ಡ ಔತಣವನ್ನು ಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ಆದರೆ ಐಗುಪ್ತಳಾದ ಹಾಗರಳಲ್ಲಿ ಅಬ್ರಹಾಮನಿಗೆ ಹುಟ್ಟಿದ್ದ ಮಗನು ಇಸಾಕನ ವಿಷಯದಲ್ಲಿ ಹಾಸ್ಯಮಾಡುವುದನ್ನು ಕಂಡು ಸಾರಳು, ");
INSERT INTO kanirv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ಅಬ್ರಹಾಮನಿಗೆ, “ಈ ದಾಸಿಯನ್ನೂ ಅವಳ ಮಗನನ್ನೂ ಹೊರಗೆ ಹಾಕು; ಈ ದಾಸಿಯ ಮಗನು ನನ್ನ ಮಗನಾದ ಇಸಾಕನೊಂದಿಗೆ ಬಾಧ್ಯಸ್ಥನಾಗಬಾರದು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ಮಗನ ಬಗ್ಗೆ ಆಡಿದ ಈ ಮಾತು ಅಬ್ರಹಾಮನಿಗೆ ಬಹು ದುಃಖವುಂಟುಮಾಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ಆದರೆ ದೇವರು ಅವನಿಗೆ, “ಮಗನ ಮತ್ತು ದಾಸಿಯ ದೆಸೆಯಿಂದ ನಿನಗೆ ವ್ಯಥೆಯಾಗಬಾರದು; ಸಾರಳು ಹೇಳಿದಂತೆಯೇ ಮಾಡು; ಇಸಾಕನಿಂದ ಹುಟ್ಟುವವರೇ ನಿನ್ನ ಸಂತತಿ ಅನ್ನಿಸಿಕೊಳ್ಳುವರು; ");
INSERT INTO kanirv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ಈ ದಾಸಿಯ ಮಗನು ನಿನ್ನಿಂದ ಹುಟ್ಟಿದವನಾದುದರಿಂದ ಅವನಿಂದಲೂ ಬಹು ಜನಾಂಗವಾಗುವಂತೆ ಆಶೀರ್ವಾದ ಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ಮಾರನೆಯ ದಿನ ಬೆಳಗ್ಗೆ ಅಬ್ರಹಾಮನು ಎದ್ದು, ಹಾಗರಳಿಗೆ ಬುತ್ತಿಯನ್ನೂ, ಒಂದು ತಿತ್ತಿ ತಣ್ಣೀರನ್ನೂ ಅವಳ ಹೆಗಲಿನ ಮೇಲೆ ಇಟ್ಟು, ಮಗುವನ್ನು ಒಪ್ಪಿಸಿ ಅವಳನ್ನು ಕಳುಹಿಸಿಬಿಟ್ಟನು. ಅವಳು ಹೊರಟು ಬೇರ್ಷೆಬದ ಕಾಡಿನಲ್ಲಿ ಅಲೆಯುತ್ತಿದ್ದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ತಿತ್ತಿಯಲ್ಲಿದ್ದ ನೀರು ಮುಗಿದ ಮೇಲೆ ಅವಳು ಮಗುವನ್ನು ಒಂದು ಗಿಡದ ನೆರಳಿನಲ್ಲಿ ಮಲಗಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ಕಲ್ಲೆಸೆಯುವಷ್ಟು ದೂರ ಹೋಗಿ ಕುಳಿತುಕೊಂಡು, “ಮಗುವು ಸಾಯುವುದನ್ನು ನೋಡಲಾರೆನು” ಎಂದು ಹೇಳಿ ಜೋರಾಗಿ ಅತ್ತಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ಆ ಹುಡುಗನ ಮೊರೆಯು ದೇವರಿಗೆ ಕೇಳಿಸಿತು; ದೇವದೂತನು ಆಕಾಶದಿಂದ ಹಾಗರಳನ್ನು ಕರೆದು ಆಕೆಗೆ, “ಹಾಗರಳೇ, ನಿನಗೇನಾಯಿತು? ಹೆದರಬೇಡ; ಆ ಹುಡುಗನ ಕೂಗು ದೇವರಿಗೆ ಕೇಳಿಸಿತು; ");
INSERT INTO kanirv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ನೀನು ಎದ್ದು ಮಗನನ್ನು ಎತ್ತಿಕೊಂಡು ಸಂತೈಸು. ಏಕೆಂದರೆ ಅವನಿಂದ ಮಹಾ ಜನಾಂಗವಾಗುವಂತೆ ಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ಇದಲ್ಲದೆ ದೇವರು ಅವಳ ಕಣ್ಣನ್ನು ತೆರೆದಿದ್ದರಿಂದ, ಅವಳು ಅಲ್ಲಿ ನೀರಿನ ಬಾವಿಯನ್ನು ಕಂಡು ತಿತ್ತಿಯಲ್ಲಿ ನೀರನ್ನು ತುಂಬಿಕೊಂಡು ಮಗನಿಗೆ ಕುಡಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ದೇವರು ಆ ಹುಡುಗನ ಸಂಗಡ ಇದ್ದನು; ಅವನು ಬೆಳೆದು ಕಾಡಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದು ಬಿಲ್ಲುಗಾರನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ಅವನು ಪಾರಾನಿನ ಅರಣ್ಯದಲ್ಲಿ ವಾಸ ಮಾಡಿದನು. ಅವನ ತಾಯಿ ಐಗುಪ್ತ ದೇಶದಿಂದ ಕನ್ಯೆಯನ್ನು ತಂದು ಅವನಿಗೆ ಮದುವೆ ಮಾಡಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ಆ ಕಾಲದಲ್ಲಿ ಅಬೀಮೆಲೆಕನು ತನ್ನ ಸೇನಾಧಿಪತಿಯಾದ ಫೀಕೋಲನ ಸಮೇತ ಅಬ್ರಹಾಮನಿಗೆ, “ನೀನು ಮಾಡುವ ಎಲ್ಲಾ ಕೆಲಸಗಳಲ್ಲಿಯೂ ದೇವರು ನಿನ್ನ ಸಂಗಡ ಇದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ಆದುದರಿಂದ ನೀನು ನನಗೂ, ನನ್ನ ಮಕ್ಕಳಿಗೂ, ನನ್ನ ಸಂತತಿಗೂ ಅನ್ಯಾಯ ಮಾಡದೆ, ನಾನು ನಿನಗೆ ಹಿತವನ್ನು ಮಾಡಿದಂತೆಯೇ, ನನಗೂ, ನೀನು ವಾಸಿಸುವ ಈ ದೇಶಕ್ಕೂ ಹಿತವನ್ನು ಮಾಡುವುದಾಗಿ ದೇವರ ಮೇಲೆ ಪ್ರಮಾಣ ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ಅದಕ್ಕೆ ಅಬ್ರಹಾಮನು “ಹಾಗೆಯೇ” ಪ್ರಮಾಣಮಾಡುತ್ತೇನೆ ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ಅಬೀಮೆಲೆಕನ ಆಳುಗಳು ಒಂದು ಬಾವಿಯನ್ನು ಬಲವಂತವಾಗಿ ಸ್ವಾಧೀನಪಡಿಸಿಕೊಂಡದ್ದರಿಂದ ಅಬ್ರಹಾಮನು ಅಬೀಮೆಲೆಕನ ಮೇಲೆ ತಪ್ಪು ಹೊರಿಸಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ಅಬೀಮೆಲೆಕನು, “ಈ ಕೆಲಸವನ್ನು ಮಾಡಿದವರು ಯಾರೋ ನಾನರಿಯೆ; ನೀನು ನನಗೆ ತಿಳಿಸಲೂ ಇಲ್ಲ, ಈಗಿನ ವರೆಗೆ ನಾನು ಈ ಸಂಗತಿಯನ್ನು ಕೇಳಲೂ ಇಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ಆ ನಂತರ ಅಬ್ರಹಾಮನು ಕುರಿದನಗಳನ್ನು ಅಬೀಮೆಲೆಕನಿಗೆ ದಾನ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ತರುವಾಯ ಅಬ್ರಹಾಮನು ಹಿಂಡಿನ ಏಳು ಹೆಣ್ಣು ಕುರಿಮರಿಗಳನ್ನು ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನಿಗೆ “ನೀನು ಈ ಏಳು ಹೆಣ್ಣು ಕುರಿಮರಿಗಳನ್ನು ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಲು ಕಾರಣವೇನು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ಅದಕ್ಕೆ ಅಬ್ರಹಾಮನು, “ಈ ಬಾವಿಯನ್ನು ತೋಡಿಸಿದವನು ನಾನೇ ಎಂಬುದಕ್ಕೆ ಸಾಕ್ಷಿಯಾಗಿ ನೀನು ಈ ಏಳು ಹೆಣ್ಣು ಕುರಿಮರಿಗಳನ್ನು ನನ್ನ ಕೈಯಿಂದ ತೆಗೆದುಕೊಳ್ಳಬೇಕು” ಎಂದು ಹೇಳಿ, ಅವರಿಬ್ಬರೂ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ಅವರಿಬ್ಬರು ಅಲ್ಲಿ ಪ್ರಮಾಣಮಾಡಿದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಬೇರ್ಷೆಬ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ಬೇರ್ಷೆಬದಲ್ಲಿ ಅವರು ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡ ತರುವಾಯ ಅಬೀಮೆಲೆಕನೂ ಅವನ ಸೇನಾಧಿಪತಿಯಾದ ಫೀಕೋಲನೂ ಫಿಲಿಷ್ಟಿಯರ ದೇಶಕ್ಕೆ ಹಿಂತಿರುಗಿ ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ಅಬ್ರಹಾಮನು ಬೇರ್ಷೆಬದಲ್ಲಿ ಪಿಚುಲ ವೃಕ್ಷವನ್ನು ನೆಟ್ಟು ಅಲ್ಲಿ ನಿತ್ಯದೇವರಾದ ಯೆಹೋವನ ಹೆಸರನ್ನು ಹೇಳಿಕೊಂಡು ಆರಾಧಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ಅಬ್ರಹಾಮನು ಫಿಲಿಷ್ಟಿಯರ ದೇಶದಲ್ಲಿ ಬಹಳ ದಿನಗಳ ಕಾಲ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ಈ ಸಂಗತಿಗಳು ಆದ ಮೇಲೆ ದೇವರು ಅಬ್ರಹಾಮನನ್ನು ಪರೀಕ್ಷಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ಹೇಗೆಂದರೆ ಆತನು ಅವನನ್ನು, “ಅಬ್ರಹಾಮನೇ” ಎಂದು ಕರೆಯಲು ಅವನು, “ಇಗೋ, ಇದ್ದೇನೆ” ಎಂದನು. ಆಗ ಆತನು, “ನಿನಗೆ ಪ್ರಿಯನಾಗಿರುವ ಒಬ್ಬನೇ ಮಗನಾದ ಇಸಾಕನನ್ನು ಕರೆದುಕೊಂಡು ಮೊರೀಯ ದೇಶಕ್ಕೆ ಹೋಗಿ ಅಲ್ಲಿ ಅವನನ್ನು ನಾನು ಹೇಳುವ ಒಂದು ಬೆಟ್ಟದ ಮೇಲೆ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಅರ್ಪಿಸಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ಅದರಂತೆ ಮುಂಜಾನೆಯೇ ಎದ್ದು ಅಬ್ರಹಾಮನು ಕತ್ತೆಗೆ ತಡಿ ಹಾಕಿಸಿ, ಯಜ್ಞಕ್ಕೆ ಬೇಕಾದ ಕಟ್ಟಿಗೆಯನ್ನು ಒಡೆಸಿ ಅದನ್ನು ತೆಗೆದುಕೊಂಡು ತನ್ನ ಸೇವಕರಲ್ಲಿ ಇಬ್ಬರನ್ನೂ, ತನ್ನ ಮಗನಾದ ಇಸಾಕನನ್ನೂ ಕರೆದುಕೊಂಡು ದೇವರು ಹೇಳಿದ ಸ್ಥಳಕ್ಕೆ ಹೊರಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಅಬ್ರಹಾಮನು ಕಣ್ಣೆತ್ತಿ ನೋಡುವಾಗ ಆ ಸ್ಥಳವು ದೂರದಲ್ಲಿ ಕಾಣಿಸಲು ಅವನು ತನ್ನ ಸೇವಕರಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","“ನೀವು ಇಲ್ಲೇ ಕತ್ತೆಯ ಬಳಿಯಲ್ಲಿರಿ; ನಾನೂ ನನ್ನ ಮಗನೂ ಅಲ್ಲಿಗೆ ಹೋಗಿ ದೇವಾರಾಧನೆ ಮಾಡಿಕೊಂಡು ನಿಮ್ಮ ಬಳಿಗೆ ಬರುತ್ತೇವೆ” ಎಂದು ಅಬ್ರಹಾಮನು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ಆನಂತರ ಅಬ್ರಹಾಮನು ಯಜ್ಞಕ್ಕೆ ಬೇಕಾದ ಕಟ್ಟಿಗೆಯನ್ನು ತನ್ನ ಮಗನಾದ ಇಸಾಕನ ಮೇಲೆ ಹೊರಿಸಿ, ತನ್ನ ಕೈಯಲ್ಲೇ ಬೆಂಕಿಯನ್ನೂ ಕತ್ತಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡ ನಂತರ ಅವರಿಬ್ಬರೂ ಹೊರಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ಹೋಗುವಾಗ ಇಸಾಕನು ತನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನಿಗೆ, “ಅಪ್ಪಾ” ಎಂದು ಕರೆಯಲು ಅಬ್ರಹಾಮನು, “ಏನು ಮಗನೇ” ಎಂದನು. ಇಸಾಕನು, “ಇಗೋ, ಬೆಂಕಿಯೂ ಕಟ್ಟಿಗೆಯೂ ಉಂಟು; ಆದರೆ ಹೋಮಕ್ಕೆ ಬೇಕಾದ ಕುರಿ ಎಲ್ಲಿ” ಎಂದು ಕೇಳಿದ್ದಕ್ಕೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ಅಬ್ರಹಾಮನು, “ಮಗನೇ, ಹೋಮಕ್ಕೆ ಬೇಕಾದ ಕುರಿಮರಿಯನ್ನು ದೇವರೇ ಒದಗಿಸುವನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ದೇವರು ಹೇಳಿದ ಸ್ಥಳಕ್ಕೆ ಅವರು ಸೇರಿದಾಗ ಅಬ್ರಹಾಮನು ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿ, ಕಟ್ಟಿಗೆಯನ್ನು ಜೋಡಿಸಿ ತನ್ನ ಮಗನಾದ ಇಸಾಕನ ಕೈಕಾಲುಗಳನ್ನು ಕಟ್ಟಿ ಅವನನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಇದ್ದ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ಮಲಗಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ಅಬ್ರಹಾಮನು ತನ್ನ ಮಗನನ್ನು ಕೊಲ್ಲುವುದಕ್ಕೆ, ಕೈಚಾಚಿ ಕತ್ತಿಯನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ಆಗ ಯೆಹೋವನ ದೂತನು ಆಕಾಶದೊಳಗಿನಿಂದ, “ಅಬ್ರಹಾಮನೇ, ಅಬ್ರಹಾಮನೇ” ಎಂದು ಅವನನ್ನು ಕರೆದನು. ಅದಕ್ಕೆ ಅಬ್ರಹಾಮನು, “ಇಗೋ, ಇದ್ದೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ಆ ದೂತನು ಅವನಿಗೆ, “ಹುಡುಗನ ಮೇಲೆ ಕೈ ಹಾಕಬೇಡ, ಅವನಿಗೆ ಏನೂ ಮಾಡಬೇಡ. ನೀನು ನಿನ್ನ ಒಬ್ಬನೇ ಮಗನನ್ನು ನನಗೆ ಸಮರ್ಪಿಸುವುದಕ್ಕೆ ಹಿಂಜರಿಯಲಿಲ್ಲ. ಈಗ ನೀನು ದೇವರಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವನು ಎಂದು ನನಗೆ ಗೊತ್ತಾಯಿತು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ಅಬ್ರಹಾಮನು ಕಣ್ಣೆತ್ತಿ ನೋಡಲಾಗಿ ತನ್ನ ಹಿಂದೆ, ಒಂದು ಟಗರು ಪೊದೆಯಲ್ಲಿ ಕೊಂಬುಗಳಿಂದ ಸಿಕ್ಕಿ ಹಾಕಿಕೊಂಡಿರುವುದನ್ನು ಕಂಡನು. ಅವನು ಹೋಗಿ ಅದನ್ನು ಹಿಡಿದು ತಂದು ತನ್ನ ಮಗನಿಗೆ ಬದಲಾಗಿ ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ಆ ಸ್ಥಳಕ್ಕೆ ಅಬ್ರಹಾಮನು “ಯೆಹೋವ ಯೀರೆ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ಯೆಹೋವನು ಬೆಟ್ಟದಲ್ಲಿ ಒದಗಿಸುವನು ಎಂಬುದಾಗಿ ಇಂದಿನವರೆಗೂ ಹಾಗೆ ಹೇಳುವ ಪದ್ಧತಿ ಇದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ಯೆಹೋವನ ದೂತನು ಆಕಾಶದೊಳಗಿನಿಂದ ಎರಡನೆಯ ಸಾರಿ ಅಬ್ರಹಾಮನನ್ನು ಕರೆದು ಅವನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“ನೀನು ನಿನ್ನ ಒಬ್ಬನೇ ಮಗನನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕೆ ಹಿಂದೆಗೆಯದೆ ಹೋದುದರಿಂದ, ಯೆಹೋವನಾದ ನಾನು ನಿನಗೆ ಪ್ರಮಾಣವಾಗಿ ಹೇಳುವುದೇನಂದರೆ ");
INSERT INTO kanirv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ನಾನು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿಯೇ ಆಶೀರ್ವದಿಸುವೆನು; ನಿನ್ನ ಸಂತತಿಯನ್ನು ಅಧಿಕವಾಗಿ ಹೆಚ್ಚಿಸುವೆನು, ಅದನ್ನು ಆಕಾಶದ ನಕ್ಷತ್ರಗಳಂತೆಯೂ, ಸಮುದ್ರ ತೀರದಲ್ಲಿರುವ ಮರಳಿನಂತೆಯೂ ಅಸಂಖ್ಯವಾಗುವಂತೆ ಮಾಡುವೆನು; ಅವರು ಶತ್ರುಗಳ ಪಟ್ಟಣಗಳನ್ನು ಸ್ವತ್ತಾಗಿ ಮಾಡಿಕೊಳ್ಳುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ನೀನು ನನ್ನ ಮಾತಿಗೆ ವಿಧೇಯನಾಗಿ ಭೂಮಿಯ ಎಲ್ಲಾ ಜನಾಂಗಗಳಿಗೆ ನಿನ್ನ ಸಂತತಿಯ ಮೂಲಕ ಆಶೀರ್ವಾದವುಂಟಾಗುವುದು ಎಂಬುದಾಗಿ ಯೆಹೋವನು ವಾಗ್ದಾನ ಮಾಡಿದ್ದಾನೆ.” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ತರುವಾಯ ಅಬ್ರಹಾಮನು ತನ್ನ ಸೇವಕರ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಂದನು. ಅವರು ಹೊರಟು ಅವನ ಜೊತೆಯಲ್ಲಿ ಬೇರ್ಷೆಬಕ್ಕೆ ಹೋದರು. ಅಬ್ರಹಾಮನು ಬೇರ್ಷೆಬದಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ಅಬ್ರಹಾಮನು ತನ್ನ ತಮ್ಮನಾದ ನಾಹೋರನಿಗೆ ಮಿಲ್ಕಳಲ್ಲಿ ಮಕ್ಕಳು ಹುಟ್ಟಿದ್ದಾರೆ ಎಂಬ ವರ್ತಮಾನವನ್ನು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ಅವರು ಯಾರೆಂದರೆ: ಅವನ ಚೊಚ್ಚಲಮಗನಾದ ಊಚ್, ಇವನ ತಮ್ಮನಾದ ಬೂಜ್, ಅರಾಮನ ತಂದೆಯಾದ ಕೆಮೂವೇಲನು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ಕೆಸೆದ್, ಹಜೋ, ಪಿಲ್ದಾಷ್, ಇದ್ಲಾಫ್, ಬೆತೂವೇಲ್ ಎಂಬವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ಬೆತೂವೇಲನು ರೆಬೆಕ್ಕಳನ್ನು ಪಡೆದನು. ಈ ಎಂಟು ಮಂದಿಯನ್ನು ಮಿಲ್ಕಳು ಅಬ್ರಹಾಮನ ತಮ್ಮನಾದ ನಾಹೋರನಿಂದ ಪಡೆದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ಇದಲ್ಲದೆ ಅವನ ಉಪಪತ್ನಿಯಾದ ರೂಮಳೆಂಬುವಳು ಟೆಬಹ, ಗಹಮ್, ತಹಷ್, ಮಾಕಾ ಎಂಬವರನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ಸಾರಳು ನೂರಿಪ್ಪತ್ತೇಳು ವರ್ಷ ಬದುಕಿದಳು. ಇದು ಅವಳ ಒಟ್ಟು ಜೀವಮಾನ ಕಾಲದ ವರ್ಷಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ಸಾರಳು ಕಾನಾನ್ ದೇಶದಲ್ಲಿರುವ ಹೆಬ್ರೋನೆಂಬ ಕಿರ್ಯತರ್ಬದಲ್ಲಿ ಸತ್ತಳು. ಅಬ್ರಹಾಮನು ಬಂದು ಆಕೆಗಾಗಿ ಗೋಳಾಡಿ ಕಣ್ಣೀರು ಸುರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ಆಮೇಲೆ ಆಕೆಯ ಶವದ ಬಳಿಯಿಂದ ಅಬ್ರಹಾಮನು ಎದ್ದು ಹಿತ್ತಿಯರ ಬಳಿಗೆ ಹೋಗಿ ಅವರಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ನಾನು ನಿಮ್ಮಲ್ಲಿ ಪರದೇಶದವನೂ, ಪ್ರವಾಸಿಯೂ ಆಗಿದ್ದೇನೆ. ಈಗ ಮರಣಹೊಂದಿರುವ ನನ್ನ ಪತ್ನಿಯ ಸಮಾಧಿಗೋಸ್ಕರ ಸ್ವಲ್ಪ ಭೂಮಿಯನ್ನು ನನ್ನ ಸ್ವಂತಕ್ಕೆ ಕೊಡಿ” ಎಂದು ಕೇಳಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ಹಿತ್ತಿಯರು ಅಬ್ರಹಾಮನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ಸ್ವಾಮಿ, ನಮ್ಮ ಮಾತನ್ನು ಕೇಳು. ನೀನು ನಮಗೆ ಮಹಾ ಪ್ರಭುವಾಗಿದ್ದೀಯಷ್ಟೆ. ಮರಣಹೊಂದಿರುವ ನಿನ್ನ ಪತ್ನಿಯ ದೇಹವನ್ನು ನಮಗಿರುವ ಸಮಾಧಿಯೊಳಗೆ ಶೇಷ್ಠವಾದದ್ದರಲ್ಲಿ ಇಡಬಹುದು. ನಿನ್ನ ಹೆಂಡತಿಯ ಶವವನ್ನು ಇಡುವುದಕ್ಕೆ ನಮ್ಮೊಳಗೆ ಯಾರೂ ಸ್ಮಶಾನ ಭೂಮಿಯನ್ನು ಕೊಡುವುದಕ್ಕೆ ಹಿಂದೆಗೆಯುವುದಿಲ್ಲ” ಎಂದು ಉತ್ತರ ಕೊಡಲು ");
INSERT INTO kanirv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ಅಬ್ರಹಾಮನು ಎದ್ದು, ಹಿತ್ತಿಯರಾಗಿದ್ದ ಆ ದೇಶದವರಿಗೆ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ಅವನು ಅವರ ಸಂಗಡ ಪುನಃ ಮಾತನಾಡಿ, “ನಾನು ನಿಮ್ಮಲ್ಲಿ ನನ್ನ ಪತ್ನಿಯ ಶವವನ್ನು ಸಮಾಧಿಮಾಡುವುದು ನಿಮಗೆ ಒಪ್ಪಿಗೆಯಾಗಿದ್ದರೆ ನನಗೆ ನಿಮ್ಮಲ್ಲಿ ಒಂದು ವಿಜ್ಞಾಪನೆ ಇದೆ. ನೀವು ಚೋಹರನ ಮಗನಾದ ಎಫ್ರೋನನ ಸಂಗಡ ನನಗೋಸ್ಕರ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ಅವನ ಭೂಮಿಯ ಅಂಚಿನಲ್ಲಿರುವ ಮಕ್ಪೇಲ ಗವಿಯನ್ನು ನನಗೆ ಕೊಡಿಸಿ ಎಂದು ಕೇಳಿದನು. ಅವನು ನನ್ನ ಸ್ವಂತಕ್ಕೆ ಈ ಸಮಾಧಿಯ ಸ್ಥಳ ನಿಮ್ಮೆದುರಿನಲ್ಲಿ ನನಗೆ ಕೊಟ್ಟರೆ ಪೂರ್ಣ ಕ್ರಯವನ್ನು ಕೊಡುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ಎಫ್ರೋನನು ಅಲ್ಲಿ ಹಿತ್ತಿಯರ ನಡುವೆ ಕುಳಿತಿದ್ದನು. ಹೀಗಿರಲಾಗಿ ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನನು ಹಿತ್ತಿಯರಾಗಿದ್ದ ಆ ಊರಿನವರೆಲ್ಲರ ಎದುರಿನಲ್ಲಿ ಅಬ್ರಹಾಮನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ಹಾಗಲ್ಲ ಸ್ವಾಮಿ, ನನ್ನ ಮಾತನ್ನು ಲಾಲಿಸು. ಆ ಭೂಮಿಯನ್ನೂ ಅದರಲ್ಲಿರುವ ಗವಿಯನ್ನೂ ನಿನಗೆ ದಾನವಾಗಿ ಕೊಡುತ್ತೇನೆ; ನನ್ನ ಜನರ ಮುಂದೆಯೇ ಕೊಡುತ್ತೇನೆ; ಮರಣಹೊಂದಿದ ನಿನ್ನ ಪತ್ನಿಯನ್ನು ಅದರಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಬಹುದು” ");
INSERT INTO kanirv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ಎಂದು ಹೇಳಲು ಅಬ್ರಹಾಮನು ಆ ದೇಶದ ಜನರಿಗೆ ನಮಸ್ಕರಿಸಿ ಅವರೆಲ್ಲರ ಮುಂದೆ ");
INSERT INTO kanirv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ಎಫ್ರೋನನಿಗೆ, “ಕೊಡಲಿಕ್ಕೆ ಮನಸ್ಸಿದ್ದರೆ ದಯವಿಟ್ಟು ನಾನು ಅರಿಕೆಮಾಡುವುದನ್ನು ಕೇಳು; ಆ ಭೂಮಿಗೆ ಕ್ರಯವನ್ನು ಕೊಡುತ್ತೇನೆ. ನನ್ನಿಂದ ಕ್ರಯ ತೆಗೆದುಕೊಂಡರೆ ಅದರಲ್ಲಿ ನನ್ನ ಪತ್ನಿಗೆ ಸಮಾಧಿ ಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ಅದಕ್ಕೆ ಎಫ್ರೋನನು ಅಬ್ರಹಾಮನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ಸ್ವಾಮಿ, ನನ್ನ ಮಾತನ್ನು ಲಾಲಿಸು; ನಾನೂರು ಬೆಳ್ಳಿ ನಾಣ್ಯಗಳ ಬೆಲೆಬಾಳುವ ಭೂಮಿಯ ವಿಷಯದಲ್ಲಿ ನಿನಗೂ ನನಗೂ ವಾದವೇತಕ್ಕೆ? ಸಮಾಧಿಮಾಡಬಹುದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ಅಬ್ರಹಾಮನು ಎಫ್ರೋನನ ಮಾತಿಗೆ ಒಪ್ಪಿದನು. ಎಫ್ರೋನನು ಹಿತ್ತಿಯರ ಎದುರಿನಲ್ಲಿ ಹೇಳಿದ ನಾನೂರು ನಾಣ್ಯಗಳನ್ನು ಅಬ್ರಹಾಮನು ವರ್ತಕರಲ್ಲಿ ಸಲ್ಲುವ ಬೆಳ್ಳಿಯಿಂದ ತೂಕ ಮಾಡಿಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ಹೀಗೆ ಮಮ್ರೆಗೆ ಎದುರಾಗಿರುವ ಮಕ್ಪೇಲಕ್ಕೆ ಸೇರಿದ ಎಫ್ರೋನನ ಭೂಮಿಯು, ಅದಕ್ಕೆ ಸೇರಿದ ಗವಿಯು ಅದರಲ್ಲಿ ಮತ್ತು ಅದರ ಸುತ್ತಣ ಅಂಚಿನಲ್ಲಿ ಇದ್ದ ಮರಗಳ ಸಹಿತವಾಗಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ಅಬ್ರಹಾಮನ ಸ್ವಂತ ಭೂಮಿಯೆಂದು ಹಿತ್ತಿಯರಾಗಿದ್ದ ಆ ಊರಿನವರೆಲ್ಲರ ಮುಂದೆ ತೀರ್ಮಾನವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ಇದಾದ ಮೇಲೆ ಅಬ್ರಹಾಮನು ತನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಳ ಶವವನ್ನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಹೆಬ್ರೋನೆಂಬ ಮಮ್ರೆಗೆ ಎದುರಾಗಿರುವ ಮಕ್ಪೇಲದ ಭೂಮಿಯಲ್ಲಿರುವ ಗವಿಯೊಳಗೆ ಹೂಣಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ಹಿತ್ತಿಯರು ಆ ಭೂಮಿಯನ್ನೂ ಅದರಲ್ಲಿರುವ ಗವಿಯನ್ನೂ ಸ್ವಂತವಾದ ಸ್ಮಶಾನ ಭೂಮಿಯನ್ನಾಗಿ ಅಬ್ರಹಾಮನಿಗೆ ಕೊಟ್ಟು ದೃಢಪಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ಅಬ್ರಹಾಮನು ದಿನ ತುಂಬಿದ ವೃದ್ಧನಾಗಿದ್ದನು. ಯೆಹೋವನು ಅವನನ್ನು ಸಕಲ ವಿಷಯಗಳಲ್ಲಿ ಅಭಿವೃದ್ಧಿಪಡಿಸಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ಹೀಗಿರಲು ಅವನು ತನಗಿದ್ದ ಆಸ್ತಿಯ ಮೇಲೆ ಆಡಳಿತ ಮಾಡುತ್ತಿದ್ದ ಹಿರಿಯ ಸೇವಕನಿಗೆ ಅಬ್ರಹಾಮನು, “ನೀನು ನನ್ನ ತೊಡೆಯ ಕೆಳಗೆ ಕೈಯಿಡು ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ಅನಂತರ ಯೆಹೋವನ ಆಣೆ ನಾನು ವಾಸವಾಗಿರುವ ಈ ಕಾನಾನ್ಯರ ಪುತ್ರಿಯರೊಳಗಿಂದ ನನ್ನ ಮಗನಾದ ಇಸಾಕನಿಗೆ ಹೆಣ್ಣನ್ನು ತಂದು ಮದುವೆ ಮಾಡದೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ನನ್ನ ದೇಶದ, ನನ್ನ ಸಂಬಂಧಿಕರೊಳಗಿಂದ ಇಸಾಕನಿಗೆ ಹೆಣ್ಣನ್ನು ತಂದು ಮದುವೆ ಮಾಡುತ್ತೇನೆ ಎಂದು ಪರಲೋಕದ ಮತ್ತು ಭೂಲೋಕದ ತಂದೆಯಾಗಿರುವ ಯೆಹೋವನ ಮೇಲೆ ಪ್ರಮಾಣ ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ಅದಕ್ಕೆ ಆ ಸೇವಕನು, “ಒಂದು ವೇಳೆ ನನ್ನೊಡನೆ ಈ ದೇಶಕ್ಕೆ ಬರುವುದಕ್ಕೆ ಆ ಸ್ತ್ರೀಗೆ ಮನಸ್ಸಿಲ್ಲದೆ ಹೋದರೆ, ನೀನು ಬಿಟ್ಟು ಬಂದ ಆ ದೇಶಕ್ಕೆ ನಾನು ನಿನ್ನ ಮಗನನ್ನು ತಿರುಗಿ ಕರೆದುಕೊಂಡು ಹೋಗಬೇಕೋ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ಅಬ್ರಹಾಮನು ಅವನಿಗೆ, “ಅಲ್ಲಿಗೆ ನನ್ನ ಮಗನನ್ನು ಎಂದಿಗೂ ಕರೆದುಕೊಂಡು ಹೋಗಲೇ ಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ನನ್ನ ತಂದೆಯ ಮನೆಯಿಂದಲೂ ನಾನು ಹುಟ್ಟಿದ ದೇಶದಿಂದಲೂ ನನ್ನನ್ನು ಕರತಂದು, ‘ನಿನ್ನ ಸಂತತಿಗೆ ಈ ದೇಶವನ್ನು ಕೊಡುವೆನು’ ಎಂದು ಪ್ರಮಾಣಮಾಡಿ ಹೇಳಿದ ಪರಲೋಕದ ದೇವರಾದ ಯೆಹೋವನು ನಿನ್ನ ಮುಂದೆ ತನ್ನ ದೂತನನ್ನು ಕಳುಹಿಸಿ, ನೀನು ಅಲ್ಲಿಂದ ನನ್ನ ಮಗನಿಗೋಸ್ಕರ ಹೆಣ್ಣನ್ನು ತೆಗೆದುಕೊಂಡು ಬರುವಂತೆ ಅನುಕೂಲಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ನಿನ್ನನ್ನು ಹಿಂಬಾಲಿಸಿ ಬರುವುದಕ್ಕೆ ಆ ಸ್ತ್ರೀಗೆ ಮನಸ್ಸಿಲ್ಲದೆ ಹೋದರೆ ನಾನು ಮಾಡಿಸಿದ ಪ್ರಮಾಣದಿಂದ ನೀನು ಬಿಡುಗಡೆಯಾಗಿರುವಿ. ಆದರೆ ನನ್ನ ಮಗನನ್ನು ತಿರುಗಿ ಅಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಹೋಗಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ಆಗ ಆ ಸೇವಕನು ತನ್ನ ದಣಿಯಾದ ಅಬ್ರಹಾಮನ ತೊಡೆಯ ಕೆಳಗೆ ಕೈಯಿಟ್ಟು ಅವನು ಹೇಳಿದಂತೆಯೇ ಪ್ರಮಾಣಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ತರುವಾಯ ಆ ಸೇವಕನು ತನ್ನ ದಣಿಯ ಒಂಟೆಗಳಲ್ಲಿ ಹತ್ತು ಒಂಟೆಗಳನ್ನು ಸಿದ್ಧಮಾಡಿ, ದಣಿಯ ಬಳಿಯಿದ್ದ ಶ್ರೇಷ್ಠವಾದ ಒಡವೆಗಳನ್ನು ತನ್ನ ವಶಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೊರಟು, ಅರಾಮ್ ನಾಹಾರಾಯಿಮ್ ಸೀಮೆಗೆ ಸೇರಿದ ನಾಹೋರನು ವಾಸಿಸಿದ ಊರನ್ನು ಮುಟ್ಟಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ಸಾಯಂಕಾಲದಲ್ಲಿ ಸ್ತ್ರೀಯರು ನೀರು ತರುವುದಕ್ಕೆ ಹೋಗುವಾಗ ಅವನು ಊರಿನ ಹೊರಗಡೆ ಬಾವಿಯ ಹತ್ತಿರ ಒಂಟೆಗಳನ್ನು ಮಲಗಿಸಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","“ನನ್ನ ದಣಿಯಾದ ಅಬ್ರಹಾಮನ ದೇವರಾಗಿರುವ ಯೆಹೋವನೇ, ಈ ಹೊತ್ತು ನಾನು ಬಂದ ಕಾರ್ಯವನ್ನು ನೀನು ಸಫಲಪಡಿಸಿ ನನ್ನ ದಣಿಯಾದ ಅಬ್ರಹಾಮನಿಗೆ ದಯೆಯನ್ನು ತೋರಿಸಬೇಕೆಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ಇಗೋ, ನೀರಿನ ಬುಗ್ಗೆಯ ಬಳಿಯಲ್ಲಿ ನಿಂತಿದ್ದೇನೆ; ಈ ಊರಿನ ಹೆಣ್ಣುಮಕ್ಕಳು ನೀರಿಗೆ ಬರುತ್ತಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ನಾನು ಯಾವ ಹುಡುಗಿಗೆ, ‘ನೀನು ದಯವಿಟ್ಟು ನಿನ್ನ ಕೊಡವನ್ನು ಇಳಿಸಿ ನನಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ನೀರನ್ನು ಕೊಡು’ ಎಂದು ಹೇಳುವಾಗ, ‘ನೀನು ಕುಡಿಯಬಹುದು ಮತ್ತು ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ನೀರು ಕೊಡುತ್ತೇನೆ’ ಎನ್ನುವಳೋ, ಅವಳೇ ನಿನ್ನ ದಾಸನಾದ ಇಸಾಕನಿಗೆ ನೀನು ನೇಮಿಸಿರುವ ಕನ್ಯೆಯಾಗಲಿ. ನನ್ನ ದಣಿಯ ಮೇಲೆ ನಿನ್ನ ದಯೆಯಿದೆ ಎಂದು ಇದರಿಂದ ನನಗೆ ಗೊತ್ತಾಗುವುದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ಅವನು ಹೀಗೆ ಅಂದುಕೊಳ್ಳುತ್ತಿರುವಾಗಲೇ ಅಬ್ರಹಾಮನ ತಮ್ಮನಾದ ನಾಹೋರನ ಹೆಂಡತಿಯಾಗಿರುವ ಮಿಲ್ಕಳ ಮಗನಾದ ಬೆತೂವೇಲನಿಗೆ ಹುಟ್ಟಿದ ರೆಬೆಕ್ಕಳು ಹೆಗಲಿನ ಮೇಲೆ ಕೊಡವನ್ನಿಟ್ಟುಕೊಂಡು ಊರ ಹೊರಗೆ ಬರುವುದನ್ನು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ಆ ಹುಡುಗಿ ಬಹು ಸುಂದರಿಯೂ ಇನ್ನೂ ಮದುವೆಯಾಗದ ಕನ್ಯೆಯಾಗಿದ್ದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ಆಕೆ ಬುಗ್ಗೆಯ ಬಳಿಗೆ ಹೋಗಿ ಕೊಡದಲ್ಲಿ ನೀರು ತುಂಬಿಕೊಂಡು ಮೇಲಕ್ಕೆ ಬಂದಾಗ ಆ ಸೇವಕನು ಓಡಿಬಂದು ಎದುರುಗೊಂಡು, “ಅಮ್ಮಾ, ದಯಮಾಡಿ ನಿನ್ನ ಕೊಡದಿಂದ ನನಗೆ ಸ್ವಲ್ಪ ನೀರನ್ನು ಕುಡಿಯುವುದಕ್ಕೆ ಕೊಡು” ಎಂದು ಕೇಳಿಕೊಳ್ಳಲು ಆಕೆಯು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ಆಕೆ ತಕ್ಷಣವೇ ಕೊಡವನ್ನು ತನ್ನ ಕೈಯ ಮೇಲೆ ಇಳಿಸಿ “ಕುಡಿಯಿರಿ” ಎಂದು ಕುಡಿಯಲು ಕೊಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ನೀರು ಕೊಟ್ಟ ಮೇಲೆ, “ನಾನು ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ಬೇಕಾದಷ್ಟು ನೀರು ತಂದು ಕೊಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ಕೊಡದಲ್ಲಿದ್ದ ನೀರನ್ನು ನೀರಿನ ತೊಟ್ಟಿಯೊಳಗೆ ಹೊಯ್ಯಿದು ತಿರುಗಿ ತರುವುದಕ್ಕೆ ಬಾವಿಗೆ ತ್ವರೆಯಾಗಿ ಹೋದಳು. ಹೀಗೆ ಅವನ ಎಲ್ಲಾ ಒಂಟೆಗಳಿಗೂ ನೀರನ್ನು ತಂದು ಕೊಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ಅಷ್ಟರಲ್ಲಿ ಆ ಮನುಷ್ಯನು ಏನೂ ಮಾತನಾಡದೆ ಆಕೆಯನ್ನು ದೃಷ್ಟಿಸಿ ನೋಡುತ್ತಾ, ಯೆಹೋವನು ತನ್ನ ಪ್ರಯಾಣವನ್ನು ಸಫಲ ಮಾಡಿದನೋ ಇಲ್ಲವೋ ಎಂದು ತಿಳಿಯುವುದಕ್ಕಾಗಿ ಕಾದುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ಒಂಟೆಗಳು ಕುಡಿದ ನಂತರ ಅವನು ಆಕೆಗೆ ಅರ್ಧ ತೊಲಾ ತೂಕವುಳ್ಳ ಒಂದು ಚಿನ್ನದ ಮೂಗುತಿಯನ್ನು, ಆಕೆಯ ಕೈಗಳಿಗೆ ಹತ್ತು ತೊಲಾ ತೂಕವುಳ್ಳ ಎರಡು ಚಿನ್ನದ ಬಳೆಗಳನ್ನೂ ಕೊಟ್ಟು, “ನೀನು ಯಾರ ಮಗಳು? ದಯವಿಟ್ಟು ನನಗೆ ಹೇಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ನಿನ್ನ ತಂದೆಯ ಮನೆಯಲ್ಲಿ ನಾವು ಇಳಿದು ಕೊಳ್ಳುವುದಕ್ಕೆ ಸ್ಥಳವಿದೆಯೋ?” ಎಂದು ಕೇಳಲು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ಆಕೆಯು ಅವನಿಗೆ, “ನಾನು ನಾಹೋರನಿಗೆ ಮಿಲ್ಕಳಲ್ಲಿ ಹುಟ್ಟಿದ ಬೆತೂವೇಲನ ಮಗಳು” ಎಂದು ಉತ್ತರಕೊಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ಇದಲ್ಲದೆ ಆಕೆಯು ಅವನಿಗೆ, “ಹುಲ್ಲೂ ಮೇವೂ ನಮ್ಮಲ್ಲಿ ಸಾಕಷ್ಟು ಇದೆ ಮತ್ತು ನೀನು ಉಳಿದುಕೊಳ್ಳುವುದಕ್ಕೂ ಸ್ಥಳವಿದೆ” ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ಆ ಮನುಷ್ಯನು ಇದನ್ನು ಕೇಳಿ ಅಡ್ಡಬಿದ್ದು ಯೆಹೋವನಿಗೆ ನಮಸ್ಕರಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“ನನ್ನ ದಣಿಯಾದ ಅಬ್ರಹಾಮನ ದೇವರಾಗಿರುವ ಯೆಹೋವನಿಗೆ ಸ್ತೋತ್ರವಾಗಲಿ. ಆತನು ತನ್ನ ಪ್ರೀತಿಯನ್ನೂ ಸತ್ಯತೆಯನ್ನೂ ನನ್ನ ದಣಿಯಿಂದ ತೆಗೆಯಲಿಲ್ಲ; ನನ್ನನ್ನು ನನ್ನ ದಣಿಯ ಬಂಧುಗಳ ಮನೆಗೆ ನೆಟ್ಟನೆ ದಾರಿಯಿಂದಲೇ ಕರೆದುಕೊಂಡು ಬಂದಿದ್ದಾನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ಆ ಹುಡುಗಿಯು ಓಡಿ ಹೋಗಿ ನಡೆದ ಸಂಗತಿಯನ್ನು ತಾಯಿಯ ಮನೆಯವರಿಗೆ ತಿಳಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ರೆಬೆಕ್ಕಳಿಗೆ ಲಾಬಾನನೆಂಬ ಅಣ್ಣನಿದ್ದನು. ಅವನು ಬುಗ್ಗೆಯ ಹತ್ತಿರ ಒಂಟೆಗಳ ಬಳಿಯಲ್ಲಿ ನಿಂತಿದ್ದ ಆ ಮನುಷ್ಯನ ಬಳಿಗೆ ಓಡಿಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ತನ್ನ ತಂಗಿಯ ಬಳಿ ಇದ್ದ ಮೂಗುತಿಯನ್ನೂ ಬಳೆಗಳನ್ನೂ ನೋಡಿ, ಆ ಮನುಷ್ಯನು ನನ್ನ ಸಂಗಡ ಹೇಗೆ ಮಾತನಾಡಿದನೆಂದು ರೆಬೆಕ್ಕಳು ಹೇಳಿದ ಮಾತುಗಳನ್ನು ಕೇಳಿ, ಬುಗ್ಗೆಯ ಹತ್ತಿರ ಒಂಟೆಗಳ ಬಳಿಯಲ್ಲಿ ನಿಂತಿದ್ದ ಆ ಮನುಷ್ಯನ ಬಳಿಗೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ಅವನಿಗೆ, “ಯೆಹೋವನ ಆಶೀರ್ವಾದವನ್ನು ಹೊಂದಿದವನೇ, ಒಳಗೆ ಬಾ; ಯಾಕೆ ಹೊರಗೆ ನಿಂತಿರುತ್ತೀ? ನಿನಗೋಸ್ಕರ ನನ್ನ ಮನೆಯಲ್ಲಿ ಒಂಟೆಗಳಿಗೆ ಬೇಕಾದ ಸ್ಥಳವನ್ನೂ ಸಿದ್ಧಮಾಡಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ಆ ಮನುಷ್ಯನು ಮನೆಯೊಳಕ್ಕೆ ಬಂದಾಗ ಲಾಬಾನನು ಒಂಟೆಗಳ ಹೊರೆಗಳನ್ನು ಇಳಿಸಿ ಅವುಗಳಿಗೆ ಹುಲ್ಲನ್ನು, ಮೇವನ್ನು ಕೊಡಿಸಿ ಆ ಮನುಷ್ಯನ ಮತ್ತು ಅವನ ಸಂಗಡ ಇದ್ದವರ ಕಾಲುಗಳನ್ನು ತೊಳೆಯುವುದಕ್ಕೆ ನೀರನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ಆದರೆ ಅವನಿಗೆ ಊಟಕ್ಕೆ ಬಡಿಸಿದಾಗ, ಅವನು, “ನಾನು ಬಂದ ಕೆಲಸವನ್ನು ಹೇಳದೆ ಊಟ ಮಾಡುವುದಿಲ್ಲ” ಅನ್ನಲು ಲಾಬಾನನು, “ಹೇಳು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ಆಗ ಅವನು, “ನಾನು ಅಬ್ರಹಾಮನ ಸೇವಕನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ಯೆಹೋವನು ನನ್ನ ದಣಿಯನ್ನು ಬಹಳವಾಗಿ ಅಭಿವೃದ್ಧಿಪಡಿಸಿ ಅವನಿಗೆ ಕುರಿದನಗಳನ್ನೂ, ಬೆಳ್ಳಿ ಬಂಗಾರವನ್ನೂ, ದಾಸದಾಸಿಯರನ್ನೂ, ಒಂಟೆಗಳನ್ನೂ, ಕತ್ತೆಗಳನ್ನೂ ಕೊಟ್ಟಿದ್ದರಿಂದ ಅವನು ಧನವಂತನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ನನ್ನ ದಣಿಯ ಪತ್ನಿಯಾದ ಸಾರಳು ವೃದ್ಧಾಪ್ಯದಲ್ಲಿ ಅವನಿಗೆ ಮಗನನ್ನು ಹೆತ್ತಳು; ಆ ಮಗನಿಗೆ ನನ್ನ ದಣಿಯು ತನಗಿರುವುದನ್ನೆಲ್ಲಾ ಕೊಟ್ಟಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ಇದಲ್ಲದೆ ನನ್ನ ದಣಿಯು ನನ್ನಿಂದ ಪ್ರಮಾಣ ಮಾಡಿಸಿ, ‘ನಾನು ವಾಸವಾಗಿರುವ ಕಾನಾನ್ ದೇಶದವರಿಂದ ನನ್ನ ");
INSERT INTO kanirv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ಮಗನಿಗೆ ಹೆಣ್ಣನ್ನು ತೆಗೆದುಕೊಳ್ಳದೆ, ನನ್ನ ತಂದೆಯ ಮನೆಗೂ ನನ್ನ ಬಂಧುಗಳ ಬಳಿಗೂ ಹೋಗಿ ಅವರಲ್ಲೇ ಹೆಣ್ಣನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕೆಂದು ಹೇಳಿ ನನ್ನಿಂದ ಪ್ರಮಾಣ ಮಾಡಿಸಿದನು.’ ");
INSERT INTO kanirv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ನಾನು ನನ್ನ ದಣಿಗೆ, ‘ಒಂದು ವೇಳೆ ನನ್ನ ಹಿಂದೆ ಬರುವುದಕ್ಕೆ ಆ ಕನ್ಯೆಗೆ ಮನಸ್ಸಿಲ್ಲದೆ ಹೋದರೆ’” ಎಂದು ಹೇಳಲು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ಅವನು ನನಗೆ, “ನಾನು ಆರಾಧನೆ ಮಾಡುತ್ತಾ ಬಂದಿರುವ ನನ್ನ ದೇವರಾದ ಆ ಯೆಹೋವನು ತನ್ನ ದೂತನನ್ನು ನಿನ್ನೊಂದಿಗೆ ಕಳುಹಿಸಿ ನೀನು ನನ್ನ ತಂದೆಯ ಮನೆತನಕ್ಕೆ ಸೇರಿರುವ ಬಂಧುಗಳಲ್ಲಿ ನನ್ನ ಮಗನಿಗೆ ಹೆಣ್ಣು ತೆಗೆದುಕೊಳ್ಳುವಂತೆ ಅನುಕೂಲ ಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ಆ ಮೇಲೆ ನಾನು ಮಾಡಿಸಿದ ಪ್ರಮಾಣದಿಂದ ನೀನು ಹೋದಾಗ ನನ್ನ ಬಂಧುಗಳಲ್ಲಿ ಅವರು ಹೆಣ್ಣನ್ನು ಕೊಡದಿದ್ದರೆ ನಾನು ಮಾಡಿಸಿದ ಪ್ರಮಾಣದಿಂದ ನೀನು ಬಿಡುಗಡೆಯಾಗಿರುವಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","ನಾನು ಈ ಹೊತ್ತು ಈ ಊರಿನ ಬುಗ್ಗೆಯ ಬಳಿಗೆ ಬಂದಾಗ, “ನನ್ನ ದಣಿಯಾದ ಅಬ್ರಹಾಮನ ದೇವರಾಗಿರುವ ಯೆಹೋವನೇ, ನೀರಿನ ಬುಗ್ಗೆಯ ಬಳಿಯಲ್ಲಿ ನಿಂತಿದ್ದೇನಷ್ಟೆ; ನೀನು ನನ್ನ ಪ್ರಯಾಣವನ್ನು ಸಫಲಮಾಡುವುದಾದರೆ ");
INSERT INTO kanirv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ನೀರಿಗೆ ಬರುವ ಯಾವ ಸ್ತ್ರೀಗೆ, ‘ನೀನು ದಯವಿಟ್ಟು, ನಿನ್ನ ಕೊಡದಿಂದ ನನಗೆ ಸ್ವಲ್ಪ ನೀರನ್ನು ಕುಡಿಯುವುದಕ್ಕೆ ಕೊಡಮ್ಮಾ’ ಎಂದು ನಾನು ಕೇಳುವಾಗ, ಅವಳು, ");
INSERT INTO kanirv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","‘ಕುಡಿಯಿರಿ ಮತ್ತು ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ನೀರು ತಂದು ಕೊಡುತ್ತೇನೆ ಅನ್ನುವಳೋ ಅವಳೇ ಯೆಹೋವನಿಂದ ನನ್ನ ದಣಿಯ ಮಗನಿಗೆ ನೇಮಕವಾದ ಕನ್ಯೆಯಾಗಿರಲಿ’ ಎಂದು, ");
INSERT INTO kanirv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ನಾನು ನನ್ನ ಮನಸ್ಸಿನಲ್ಲಿ ಅಂದುಕೊಳ್ಳುತ್ತಿರುವಾಗಲೇ, ರೆಬೆಕ್ಕಳು ಹೆಗಲಿನ ಮೇಲೆ ಕೊಡವನ್ನು ಹೊತ್ತುಕೊಂಡು ಬರುವುದನ್ನು ಕಂಡೆನು. ಆಕೆಯು ಬುಗ್ಗೆಗೆ ಇಳಿದು ನೀರನ್ನು ತೆಗೆದುಕೊಂಡು ಬಂದಾಗ ನಾನು ಆಕೆಗೆ, ‘ನನಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ನೀರನ್ನು ಕೊಡು’ ಎಂದು ಕೇಳಿದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ಆ ಕ್ಷಣವೇ ಆಕೆ ಕೊಡವನ್ನು ಹೆಗಲಿನಿಂದ ಇಳಿಸಿ, ‘ಕುಡಿಯಿರಿ, ನಿಮ್ಮ ಒಂಟೆಗಳಿಗೂ ತಂದು ಕೊಡುತ್ತೇನೆ’ ಎಂದಳು. ನಾನು ಕುಡಿದ ಮೇಲೆ ಆಕೆ ಒಂಟೆಗಳಿಗೂ ನೀರು ತಂದುಕೊಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ನೀನು ಯಾರ ಮಗಳೆಂದು ನಾನು ಕೇಳಿದ್ದಕ್ಕೆ ಆಕೆಯು, ‘ನಾನು ನಾಹೋರನಿಗೆ ಮಿಲ್ಕಳಲ್ಲಿ ಹುಟ್ಟಿದ ಬೆತೂವೇಲನ ಮಗಳು’ ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ಅದನ್ನು ಕೇಳಿ ನಾನು ಆಕೆಯ ಮೂಗಿಗೆ ಮೂಗುತಿಯನ್ನೂ ಕೈಗಳಿಗೆ ಬಳೆಗಳನ್ನೂ ಇಟ್ಟು ನನ್ನ ದಣಿಯಾದ ಅಬ್ರಹಾಮನ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿ ಆತನು ನನ್ನ ದಣಿಯ ಮಗನಿಗೋಸ್ಕರ ಅವನ ತಮ್ಮನ ಮಗಳನ್ನೇ ತೆಗೆದುಕೊಳ್ಳುವಂತೆ ನನ್ನನ್ನು ಸತ್ಯದ ದಾರಿಯಲ್ಲಿ ಕರೆದುಕೊಂಡು ಬಂದುದಕ್ಕಾಗಿ ಆತನನ್ನು ಕೊಂಡಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ಹೀಗಿರುವಲ್ಲಿ ನೀವು ನನ್ನ ದಣಿಗೆ ಪ್ರೀತಿಯಿಂದಲೂ, ನಂಬಿಕೆಯಿಂದಲೂ ನಡೆಯುವುದಕ್ಕೆ ಒಪ್ಪಿದರೆ ನನಗೆ ಹೇಳಿರಿ; ಇಲ್ಲವಾದರೆ ಇಲ್ಲವೆನ್ನಿರಿ; ಆಗ ನಾನು ಬಲಗಡೆಗಾಗಲಿ ಎಡಗಡೆಗಾಗಲಿ ನನ್ನ ಪ್ರಯಾಣ ಮುಂದುವರೆಸುತ್ತೇನೆ” ಎಂದು ವಿವರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ಅದಕ್ಕೆ ಲಾಬಾನನೂ, ಬೆತೂವೇಲನೂ, “ಈ ಕಾರ್ಯವು ಯೆಹೋವನಿಂದಲೇ ಉಂಟಾಯಿತು; ನಾವಂತೂ ಹೌದೆಂದೂ, ಅಲ್ಲವೆಂದೂ ಹೇಳಲಾರೆವು. ರೆಬೆಕ್ಕಳನ್ನು ನಿನ್ನ ವಶಕ್ಕೆ ಕೊಡುತ್ತೇವೆ; ");
INSERT INTO kanirv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ಕರೆದುಕೊಂಡು ಹೋಗಬಹುದು; ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ರೆಬೆಕ್ಕಳು ನಿನ್ನ ದಣಿಯ ಮಗನಿಗೆ ಹೆಂಡತಿಯಾಗಲಿ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ಅಬ್ರಹಾಮನ ಸೇವಕನು ಅವರ ಮಾತನ್ನು ಕೇಳಿದಾಗ ಯೆಹೋವನಿಗೆ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ಆ ಮೇಲೆ ತಾನು ತಂದಿದ್ದ ಬೆಳ್ಳಿ ಬಂಗಾರದ ಒಡವೆಗಳನ್ನೂ, ವಸ್ತ್ರಗಳನ್ನೂ ತೆಗೆದು ರೆಬೆಕ್ಕಳಿಗೆ ಕೊಟ್ಟನು. ಆಕೆಯ ಅಣ್ಣನಿಗೂ ತಾಯಿಗೂ ಸಹ ಬೆಲೆಯುಳ್ಳ ವಸ್ತುಗಳನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ಬಳಿಕ ಅವನೂ ಅವನ ಸಂಗಡ ಬಂದ ಸೇವಕರೂ ಊಟ ಉಪಚಾರಗಳನ್ನು ಮುಗಿಸಿಕೊಂಡು ರಾತ್ರಿಯೆಲ್ಲಾ ಅಲ್ಲೇ ಇದ್ದರು. ಬೆಳಗ್ಗೆ ಎದ್ದಾಗ ಅವನು, “ನನ್ನ ದಣಿಯ ಬಳಿಗೆ ಹೊರಡುವುದಕ್ಕೆ ನನಗೆ ಅಪ್ಪಣೆಯಾಗಲಿ” ಎಂದು ಕೇಳಲು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ರೆಬೆಕ್ಕಳ ಅಣ್ಣನೂ, ತಾಯಿಯೂ ಅವನಿಗೆ, “ಹುಡುಗಿಯು ಇನ್ನು ಹತ್ತು ದಿನವಾದರೂ ನಮ್ಮಲ್ಲಿರಲಿ; ಆ ಮೇಲೆ ಆಕೆ ಹೋಗಬಹುದು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ಅವನು ಅವರಿಗೆ, “ಯೆಹೋವನು ನನ್ನ ಪ್ರಯಾಣವನ್ನು ಸಫಲಮಾಡಿದ್ದಾನೆ; ಆದುದರಿಂದ ನನ್ನನ್ನು ತಡೆಯಬೇಡಿರಿ, ನನ್ನ ದಣಿಯ ಬಳಿಗೆ ಹೋಗುವುದಕ್ಕೆ ನನಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು” ಎಂದು ಹೇಳಲು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ಅವರು, “ನಾವು ಹುಡುಗಿಯನ್ನು ಕರೆದು ಆಕೆಯ ಅಭಿಪ್ರಾಯವನ್ನು ತಿಳಿದುಕೊಳ್ಳುತ್ತೇವೆ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ಅವರು ರೆಬೆಕ್ಕಳನ್ನು ಕರೆದು ಆಕೆಗೆ, “ಅಮ್ಮಾ ಈ ಮನುಷ್ಯನ ಜೊತೆಯಲ್ಲಿ ನೀನು ಹೋಗುವಿಯಾ?” ಎಂದು ಕೇಳಿದರು. ಅದಕ್ಕೆ ಅವಳು “ಹೋಗುತ್ತೇನೆ” ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ಆಗ ಅವರು ತಮ್ಮ ತಂಗಿಯಾದ ರೆಬೆಕ್ಕಳನ್ನೂ, ಅವಳ ದಾಸಿಯರನ್ನು, ಸಂಗಡ ಬಂದ ಅಬ್ರಹಾಮನ ಮನುಷ್ಯರ ಸಂಗಡ ಕಳುಹಿಸಿ ಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ಮತ್ತು ರೆಬೆಕ್ಕಳಿಗೆ, “ತಂಗಿ, ನಿನ್ನಿಂದ ಸಾವಿರ, ಹತ್ತು ಸಾವಿರ ಸಂತಾನವಾಗಲಿ; ನಿನ್ನ ಸಂತಾನದವರು ತಮ್ಮ ವೈರಿಗಳ ಸ್ವತ್ತನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳಲಿ” ಎಂದು ಹೇಳಿ ಹರಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ರೆಬೆಕ್ಕಳೂ ಆಕೆಯ ದಾಸಿಯರೂ ಒಂಟೆಗಳ ಮೇಲೆ ಹತ್ತಿದವರಾಗಿ ಅಬ್ರಹಾಮನ ಸೇವಕನ ಹಿಂದೆ ಹೋದರು. ಹೀಗೆ ಆ ಸೇವಕರು ರೆಬೆಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ಹೊರಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ಅಷ್ಟರಲ್ಲಿ ಇಸಾಕನು ಬೆರ್ ಲಹೈರೋಯಿ ಬಾವಿಗೆ ಹೋಗಿ ಬಂದಿದ್ದನು; ಅವನು ಕಾನಾನ್ ದೇಶದ ದಕ್ಷಿಣ ಸೀಮೆಯಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ಇಸಾಕನು ಸಂಜೆ ವೇಳೆಯಲ್ಲಿ ಧ್ಯಾನ ಮಾಡುವುದಕ್ಕಾಗಿ ಬಯಲು ಪ್ರದೇಶಕ್ಕೆ ಹೋಗಿದ್ದನು. ಅಲ್ಲಿ ಕಣ್ಣೆತ್ತಿ ನೋಡಲಾಗಿ ಒಂಟೆಗಳು ಬರುವುದನ್ನು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ರೆಬೆಕ್ಕಳು ಕಣ್ಣೆತ್ತಿ ಇಸಾಕನನ್ನು ನೋಡಿ ಒಂಟೆಯಿಂದ ಕೆಳಗೆ ಇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ಆಕೆಯು ಆ ಸೇವಕನಿಗೆ, “ನಮ್ಮನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಅಡವಿಯಲ್ಲಿ ನಡೆದು ಬರುವ ಆ ಮನುಷ್ಯನು ಯಾರು?” ಎಂದು ಕೇಳಿದಳು. ಅವನೇ ನನ್ನ ದಣಿಯೆಂದು ಅವನು ಹೇಳಿದಾಗ ಆಕೆ ಮುಸುಕು ಹಾಕಿಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ಆ ಸೇವಕನು ತಾನು ಮಾಡಿದ ಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ಇಸಾಕನಿಗೆ ತಿಳಿಸಿದ ನಂತರ ಇಸಾಕನು ಆಕೆಯನ್ನು ತನ್ನ ತಾಯಿಯಾದ ಸಾರಳ ಗುಡಾರಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ಈ ರೀತಿಯಾಗಿ ಇಸಾಕನು ರೆಬೆಕ್ಕಳನ್ನು ವರಿಸಿದನು, ಆಕೆ ಅವನ ಹೆಂಡತಿಯಾದಳು. ಅವನು ಆಕೆಯನ್ನು ಪ್ರೀತಿಸಿ ತನ್ನ ತಾಯಿ ಸಾರಳು ಸತ್ತ ದುಃಖವನ್ನು ಶಮನ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ಅಬ್ರಹಾಮನು ಕೆಟೂರಳೆಂಬ ಇನ್ನೊಬ್ಬ ಹೆಂಡತಿಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ಆಕೆ ಅವನಿಗೆ ಜಿಮ್ರಾನ್, ಯೊಕ್ಷಾನ್, ಮೆದಾನ್, ಮಿದ್ಯಾನ್, ಇಷ್ಬಾಕ್, ಶೂಹ ಇವರನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ಯೊಕ್ಷಾನನು ಶೆಬಾ, ದೆದಾನ್ ಎಂಬಿವರನ್ನು ಪಡೆದನು. ಅಶ್ಮೂರ್ಯರೂ, ಲೆಟೂಶ್ಯರೂ, ಲೆಯುಮ್ಯರೂ ದೆದಾನನಿಂದ ಹುಟ್ಟಿದವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ಗೇಫಾ, ಗೇಫೆರ್, ಹನೋಕ್, ಅಬೀದಾ, ಎಲ್ದಾಯ ಎಂಬುವವರು ಮಿದ್ಯಾನನಿಂದ ಹುಟ್ಟಿದರು. ಇವರೆಲ್ಲರೂ ಕೆಟೂರಳ ಸಂತತಿಯವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ಅಬ್ರಹಾಮನು ತನಗಿದ್ದ ಆಸ್ತಿಯನ್ನೆಲ್ಲಾ ಇಸಾಕನಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ಅಬ್ರಹಾಮನು ತನ್ನ ಉಪಪತ್ನಿಯರ ಮಕ್ಕಳಿಗೆ ಕೆಲವು ಸೊತ್ತುಗಳನ್ನು ದಾನಮಾಡಿ ತಾನು ಇನ್ನೂ ಜೀವದಿಂದಿರುವಾಗಲೇ ಅವರನ್ನು ತನ್ನ ಮಗನಾದ ಇಸಾಕನ ಬಳಿಯಿಂದ ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿರುವ ಕೆದೆಮ್ ದೇಶಕ್ಕೆ ಕಳುಹಿಸಿ ಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ಅಬ್ರಹಾಮನು ನೂರ ಎಪ್ಪತ್ತೈದು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ಅಬ್ರಹಾಮನು ಪೂರ್ಣಾಯುಷ್ಯದಿಂದ ದಿನತುಂಬಿದ ಮುದುಕನಾಗಿ ಪ್ರಾಣ ಬಿಟ್ಟು ತನ್ನ ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ಅವನ ಮಕ್ಕಳಾದ ಇಸಾಕ್, ಇಷ್ಮಾಯೇಲರು ಹಿತ್ತಿಯನಾದ ಚೋಹರನ ಮಗ ಎಫ್ರೋನನ ಭೂಮಿಯಲ್ಲಿರುವ ಮಕ್ಪೇಲದ ಗವಿಯಲ್ಲಿ ಅವನನ್ನು ಸಮಾಧಿಮಾಡಿದರು. ಅದು ಮಮ್ರೆಯ ತೋಪಿನ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ಅಬ್ರಹಾಮನು ಅದನ್ನು ಹಿತ್ತಿಯರಿಂದ ಕೊಂಡುಕೊಂಡಿದ್ದನು. ಅದರಲ್ಲಿ ಅಬ್ರಹಾಮನಿಗೂ, ಅವನ ಹೆಂಡತಿಯಾದ ಸಾರಳಿಗೂ ಸಮಾಧಿ ಆಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ಅಬ್ರಹಾಮನು ತೀರಿಹೋದ ನಂತರ ದೇವರ ಅನುಗ್ರಹವು ಅವನ ಮಗನಾದ ಇಸಾಕನ ಮೇಲೂ ಉಂಟಾಯಿತು. ಇಸಾಕನು ಬೆರ್ ಲಹೈರೋಯಿಯ ಹತ್ತಿರ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ಅಬ್ರಹಾಮನಿಗೆ ಸಾರಳ ಐಗುಪ್ತ ದಾಸಿಯಾದ ಹಾಗರಳಲ್ಲಿ ಹುಟ್ಟಿದ ಇಷ್ಮಾಯೇಲನ ವಂಶದ ಚರಿತ್ರೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ಇಷ್ಮಾಯೇಲನ ಮಕ್ಕಳಿಗೂ ಇವರಿಂದ ಹುಟ್ಟಿದ ಕುಲಗಳಿಗೂ ಇರುವ ಹೆಸರುಗಳು ಯಾವುದೆಂದರೆ: ಮೊದಲು ಹುಟ್ಟಿದವನು ನೆಬಾಯೋತ್, ಆ ಮೇಲೆ ಹುಟ್ಟಿದವರು ಕೇದಾರ್, ಅದ್ಬಯೇಲ್, ಮಿಬ್ಸಾಮ್, ");
INSERT INTO kanirv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ಮಿಷ್ಮಾ, ದೂಮಾ, ಮಸ್ಸಾ, ");
INSERT INTO kanirv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ಹದದ್, ತೇಮಾ, ಯಟೂರ್, ನಾಫೀಷ್, ಕೇದ್ಮಾ ಎಂಬುವವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ವಂಶ ಪಾರಂಪರೆಯಾಗಿ ಊರುಗಳಲ್ಲಿಯೂ, ಪಾಳೆಯಗಳಲ್ಲಿಯೂ ವಾಸಿಸುವ ಇಷ್ಮಾಯೇಲನ ಸಂತಾನದವರೂ ಇವರೇ ಆಗಿದ್ದಾರೆ. ಇವರ ಕುಲಗಳ ಸಂಖ್ಯೆಗಳಿಗನುಸಾರವಾಗಿ ಹನ್ನೆರಡು ಮಂದಿ ಅರಸರಿರುತ್ತಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ಇಷ್ಮಾಯೇಲನು ನೂರಮೂವತ್ತೇಳು ವರ್ಷ ಬದುಕಿದನು. ನಂತರ ಅವನು ಪ್ರಾಣ ಬಿಟ್ಟು ತನ್ನ ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ಇಷ್ಮಾಯೇಲ್ಯರು ಹವೀಲದಿಂದ ಐಗುಪ್ತ ದೇಶದ ಮೂಡಲಲ್ಲಿರುವ ಅಶ್ಶೂರಿನ ದಾರಿಯಲ್ಲಿರುವ ಶೂರಿನ ತನಕ ವಾಸಮಾಡಿದರು. ಹೀಗೆ ಅವರು ತಮ್ಮ ಸಂಬಂಧಿಕರ ಎದುರಾಗಿ ವಾಸಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ಅಬ್ರಹಾಮನ ಮಗನಾದ ಇಸಾಕನ ಚರಿತ್ರೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ಅಬ್ರಹಾಮನು ಇಸಾಕನನ್ನು ಪಡೆದನು. ಇಸಾಕನು ನಲವತ್ತು ವರ್ಷದವನಾದಾಗ ಅರಾಮ್ಯನಾದ ಬೆತೂವೇಲನ ಮಗಳೂ ಅರಾಮ್ಯನಾದ ಲಾಬಾನನ ತಂಗಿಯೂ ಆಗಿದ್ದ ರೆಬೆಕ್ಕಳನ್ನು ಪದ್ದನ್ ಅರಾಮಿನಿಂದ ಕರೆದುತಂದು ಹೆಂಡತಿಯನ್ನಾಗಿ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ಆಕೆ ಬಂಜೆಯಾಗಿರಲಾಗಿ ಇಸಾಕನು ಆಕೆಗೊಸ್ಕರ ಯೆಹೋವನನ್ನು ಬೇಡಿಕೊಂಡನು. ಯೆಹೋವನು ಅವನ ವಿಜ್ಞಾಪನೆಯನ್ನು ಲಾಲಿಸಿದ್ದರಿಂದ ರೆಬೆಕ್ಕಳು ಬಸುರಾದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ಆಕೆಯ ಗರ್ಭದಲ್ಲಿ ಶಿಶುಗಳು ಒಂದನ್ನೊಂದು ನೂಕಾಡುತ್ತಿದ್ದಾಗ ಆಕೆಯು, “ಹೀಗಾದರೆ ನಾನು ಹೇಗೆ ಬದುಕಬೇಕು” ಎಂದು ಹೇಳಿ ಇದರ ವಿಷಯದಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ವಿಚಾರಿಸುವುದಕ್ಕೆ ಹೋದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ಯೆಹೋವನು ಆಕೆಗೆ, “ನಿನ್ನ ಗರ್ಭದಲ್ಲಿ ಎರಡು ಜನಾಂಗಗಳು ಇವೆ; ಆ ಎರಡು ಜನಾಂಗಗಳು ಹುಟ್ಟಿನಿಂದಲೇ ಭಿನ್ನವಾಗಿರುವವು; ಅವುಗಳಲ್ಲಿ ಒಂದು ಮತ್ತೊಂದಕ್ಕಿಂತ ಬಲಿಷ್ಠವಾಗುವುದು; ಹಿರಿಯವನು ಕಿರಿಯವನಿಗೆ ಸೇವೆ ಮಾಡುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ಆಕೆ ದಿನತುಂಬಿದಾಗ ಅವಳಿ ಮಕ್ಕಳನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ಮೊದಲು ಹುಟ್ಟಿದ್ದು ಕೆಂಪಾಗಿಯೂ ಮೈಮೇಲೆಲ್ಲಾ ಕೂದಲಿನ ವಸ್ತ್ರದಂತೆ ರೋಮವುಳ್ಳದ್ದಾಗಿಯೂ ಇತ್ತು. ಅದಕ್ಕೆ “ಏಸಾವ” ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ಎರಡನೆಯ ಶಿಶುವು ಏಸಾವನ ಹಿಮ್ಮಡಿಯನ್ನು ಕೈಯಿಂದ ಹಿಡಿದುಕೊಂಡು ಹುಟ್ಟಿದ್ದರಿಂದ ಅದಕ್ಕೆ “ಯಾಕೋಬ” ಎಂದು ಹೆಸರಿಟ್ಟರು. ಇವರಿಬ್ಬರು ಹುಟ್ಟಿದಾಗ ಇಸಾಕನು ಅರುವತ್ತು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ಆ ಹುಡುಗರಿಬ್ಬರೂ ಬೆಳೆದಾಗ ಅವರಲ್ಲಿ ಏಸಾವನು ಬೇಟೆಯಾಡುವುದರಲ್ಲಿ ನಿಪುಣನಾಗಿದ್ದನು; ಅವನು ಅರಣ್ಯವಾಸಿ. ಯಾಕೋಬನು ಸಾಧು ಮನುಷ್ಯನಾಗಿ ಗುಡಾರಗಳಲ್ಲೇ ವಾಸಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ಬೇಟೆಯ ಮಾಂಸವು ಇಸಾಕನಿಗೆ ಇಷ್ಟವಾದುದರಿಂದ ಅವನು ಏಸಾವನನ್ನು ಪ್ರೀತಿಸಿದನು; ರೆಬೆಕ್ಕಳು ಯಾಕೋಬನನ್ನು ಪ್ರೀತಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ಒಂದು ದಿನ ಯಾಕೋಬನು ಅಡಿಗೆ ಮಾಡುತ್ತಿರುವಾಗ ಏಸಾವನು ಕಾಡಿನಿಂದ ದಣಿದು ಬಂದು ಅವನಿಗೆ, “ನಾನು ಬಹಳ ದಣಿದು ಬಂದಿದ್ದೇನೆ; ");
INSERT INTO kanirv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ಆ ಕೆಂಪಾದ ರುಚಿ ಪದಾರ್ಥವನ್ನು ಈಗಲೇ ತಿನ್ನುವುದಕ್ಕೆ ಕೊಡು” ಎಂದು ಕೇಳಿದನು. ಈ ಸಂಗತಿಯಿಂದ ಏಸಾವನಿಗೆ “ಎದೋಮ್” ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ಯಾಕೋಬನು ಅವನಿಗೆ, “ನೀನು ಮೊದಲು ನಿನ್ನ ಚೊಚ್ಚಲತನದ ಹಕ್ಕನ್ನು ನನಗೆ ಮಾರಿ ಬಿಡು” ಅನ್ನಲು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ಏಸಾವನು, “ಆಗಲಿ” ನನ್ನಂಥ ಸಾಯುವವನಿಗೆ ಚೊಚ್ಚಲತನದಿಂದ ಪ್ರಯೋಜನವೇನು ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ಆಗ ಯಾಕೋಬನು ಮೊದಲು ಪ್ರಮಾಣಮಾಡು ಅಂದಾಗ ಏಸಾವನು ಪ್ರಮಾಣಮಾಡಿ ಅವನಿಗೆ ತನ್ನ ಚೊಚ್ಚಲತನದ ಹಕ್ಕನ್ನು ಕೊಟ್ಟುಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ಆಗ ಯಾಕೋಬನು ಏಸಾವನಿಗೆ ರೊಟ್ಟಿಯನ್ನೂ ಅಲಸಂದಿ ಗುಗ್ಗರಿಯ ಪಲ್ಯವನ್ನು ಕೊಟ್ಟನು. ಏಸಾವನು ತಿಂದು ಕುಡಿದು ಎದ್ದು ಹೋದನು. ಹೀಗೆ ಅವನು ತನ್ನ ಚೊಚ್ಚಲತನದ ಹಕ್ಕನ್ನು ತಾತ್ಸಾರ ಮಾಡಿ ಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ಅಬ್ರಹಾಮನ ಕಾಲದಲ್ಲಿ ಬಂದ ಮೊದಲನೆಯ ಬರಗಾಲವಲ್ಲದೆ ಇನ್ನೊಂದು ಬರಗಾಲವು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಬಂದಿತು. ಆಗ ಇಸಾಕನು ಫಿಲಿಷ್ಟಿಯರ ಅರಸನಾದ ಅಬೀಮೆಲೆಕನ ಬಳಿಗೆ ಗೆರಾರಿಗೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ಅಲ್ಲಿ ಯೆಹೋವನು ಇಸಾಕನಿಗೆ ದರ್ಶನಕೊಟ್ಟು, “ನೀನು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಇಳಿದು ಹೋಗಬೇಡ; ನಾನು ಹೇಳುವ ದೇಶದಲ್ಲಿ ನೀನು ವಾಸಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ನೀನು ಈ ದೇಶದಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿರು; ನಾನು ನಿನ್ನ ಬಳಿಯಲ್ಲಿದ್ದು ನಿನ್ನನ್ನು ಅಭಿವೃದ್ಧಿಪಡಿಸಿ ನಿನಗೂ, ನಿನ್ನ ಸಂತತಿಯವರಿಗೂ ಈ ಪ್ರದೇಶಗಳನ್ನೆಲ್ಲಾ ಕೊಡುವೆನು. ಹೀಗೆ ನಿನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನಿಗೆ ಮಾಡಿದ ವಾಗ್ದಾನವನ್ನು ನೆರವೇರಿಸುವೆನು, ");
INSERT INTO kanirv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ನಿನ್ನ ಸಂತತಿಯವರನ್ನು ಆಕಾಶದಲ್ಲಿರುವ ನಕ್ಷತ್ರಗಳಂತೆ ಹೆಚ್ಚಿಸುವೆನು. ನಿನ್ನ ಸಂತತಿಗೆ ಈ ಪ್ರದೇಶಗಳನ್ನೆಲ್ಲಾ ಕೊಡುವೆನು. ನಿನ್ನ ಸಂತತಿಯ ಮೂಲಕ ಭೂಮಿಯ ಎಲ್ಲಾ ಜನಾಂಗಗಳಿಗೂ ಆಶೀರ್ವಾದವುಂಟಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ಏಕೆಂದರೆ ಅಬ್ರಹಾಮನು ನನ್ನ ಮಾತಿಗೆ ವಿಧೇಯನಾಗಿ ನನ್ನ ವಿಧಿಗಳನ್ನು, ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು, ನನ್ನ ನೇಮಗಳನ್ನು, ನನ್ನ ಕಟ್ಟಳೆಗಳನ್ನು, ಕೈಗೊಂಡು ನಡೆದನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ಇಸಾಕನು ಗೆರಾರಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ಆ ಸ್ಥಳದ ಜನರು ಅವನ ಹೆಂಡತಿಯನ್ನು ನೋಡಿ ಆಕೆಯನ್ನು ಕುರಿತು ವಿಚಾರಿಸಿದಾಗ ಅವನು ರೆಬೆಕ್ಕಳು ಸುಂದರಿಯಾಗಿರುವುದರಿಂದ ಈ ಸ್ಥಳದ ಜನರು ಈಕೆಯ ನಿಮಿತ್ತ ನನ್ನನ್ನು ಕೊಂದಾರು ಅಂದುಕೊಂಡು ಆಕೆಯನ್ನು ತನ್ನ ಹೆಂಡತಿ ಎಂದು ಹೇಳುವುದಕ್ಕೆ ಭಯಪಟ್ಟು ತಂಗಿಯಾಗಬೇಕು ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ಅವನು ಆ ಸ್ಥಳದಲ್ಲಿ ಬಹಳ ದಿನ ಇದ್ದ ಮೇಲೆ ಒಂದು ದಿನ ಫಿಲಿಷ್ಟಿಯರ ಅರಸನಾದ ಅಬೀಮೆಲೆಕನು ಕಿಟಿಕಿಯಿಂದ ನೋಡಿದಾಗ ಇಸಾಕನು ತನ್ನ ಹೆಂಡತಿಯಾದ ರೆಬೆಕ್ಕಳ ಸಂಗಡ ಸರಸವಾಡುವುದನ್ನು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ಆಗ ಅಬೀಮೆಲೆಕನು ಇಸಾಕನನ್ನು ಕರೆಯಿಸಿ, “ನಿಶ್ಚಯವಾಗಿ ಈಕೆಯ ನಿನ್ನ ಹೆಂಡತಿಯಲ್ಲವೇ, ತಂಗಿ ಎಂದು ಯಾಕೆ ಹೇಳಿದೆ” ಎಂದು ಕೇಳಲು ಇಸಾಕನು, “ಜನರು ಈಕೆಯ ನಿಮಿತ್ತ ನನ್ನನ್ನು ಕೊಂದಾರೆಂದು ಹಾಗೆ ಹೇಳಿದೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ಅದಕ್ಕೆ ಅಬೀಮೆಲೆಕನು, “ನೀನು ನಮಗೆ ಹೀಗೆ ಯಾಕೆ ಮಾಡಿದೆ? ಜನರಲ್ಲಿ ಒಬ್ಬನು ನಿನ್ನ ಹೆಂಡತಿಯೊಡನೆ ಸಂಗಮಿಸುವುದಕ್ಕೆ ಆಸ್ಪದವಾಗುತ್ತಿತ್ತು. ನಿನ್ನ ಮೂಲಕ ನಮಗೆ ದೋಷ ಪ್ರಾಪ್ತವಾಗುತ್ತಿತ್ತಲ್ಲಾ?” ");
INSERT INTO kanirv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ಎಂದು ಹೇಳಿ ಅಬೀಮೆಲೆಕನು ತನ್ನ ಪ್ರಜೆಗಳಿಗೆ, “ಈ ಮನುಷ್ಯನಿಗಾಗಲಿ ಇವನ ಹೆಂಡತಿಗಾಗಲಿ ಕೇಡುಮಾಡುವವನಿಗೆ ತಪ್ಪದೆ ಮರಣ ದಂಡನೆಯಾಗುವುದು” ಎಂದು ಆಜ್ಞೆ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ಇಸಾಕನು ಆ ದೇಶದಲ್ಲಿ ಬೀಜವನ್ನು ಬಿತ್ತಿ ಅದೇ ವರ್ಷದಲ್ಲಿ ನೂರರಷ್ಟು ಬೆಳೆಯನ್ನು ಕೊಯ್ದನು; ಯೆಹೋವನು ಅವನನ್ನು ಅಭಿವೃದ್ಧಿಪಡಿಸಿದನು; ");
INSERT INTO kanirv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ಅವನ ಐಶ್ವರ್ಯವು ದಿನೇ ದಿನೇ ಹೆಚ್ಚಿದ್ದರಿಂದ ಬಹು ಧನವಂತನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ಅವನಿಗೆ ದನಕುರಿಗಳೂ, ಸಂಪತ್ತೂ, ಸೇವಕರು ಹೇರಳವಾಗಿದ್ದುದನ್ನು ನೋಡಿ ಫಿಲಿಷ್ಟಿಯರು ಹೊಟ್ಟೆಕಿಚ್ಚುಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ಅವನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನ ಸೇವಕರು ಅಬ್ರಹಾಮನ ಕಾಲದಲ್ಲೇ ತೋಡಿದ್ದ ಬಾವಿಗಳನ್ನು ಫಿಲಿಷ್ಟಿಯರು ಮಣ್ಣುಹಾಕಿ ಮುಚ್ಚಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ಹೀಗಿರಲಾಗಿ ಅಬೀಮೆಲೆಕನು ಇಸಾಕನಿಗೆ, “ನೀನು ನಮಗಿಂತ ಬಹು ಬಲಿಷ್ಠನಾಗಿದ್ದೀ; ");
INSERT INTO kanirv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ಆದ್ದರಿಂದ ನಮ್ಮ ಬಳಿಯಿಂದ ಹೊರಟುಹೋಗಬೇಕು” ಎಂದು ಹೇಳಲು ಇಸಾಕನು ಅಲ್ಲಿಂದ ಹೋಗಿ ಗೆರಾರ್ ತಗ್ಗಿನ ಬಯಲಿನಲ್ಲಿ ಬಿಡಾರ ಮಾಡಿಕೊಂಡು ಅಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ಅಬ್ರಹಾಮನು ತೋಡಿಸಿದ್ದ ಬಾವಿಗಳನ್ನು ಅವನು ಸತ್ತ ನಂತರ ಫಿಲಿಷ್ಟಿಯರು ಮುಚ್ಚಿ ಹಾಕಿದ್ದರಿಂದ ಇಸಾಕನು ಅವುಗಳನ್ನು ತಿರುಗಿ ಅಗೆಸಿ, ತಂದೆ ಇಟ್ಟಿದ್ದ ಹೆಸರುಗಳನ್ನೇ ಇಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ಇಸಾಕನ ಸೇವಕರು ತಗ್ಗಿನಲ್ಲಿ ಅಗೆಯುವಾಗ ಅವರಿಗೆ ಉಕ್ಕುವ ಒರತೆಯ ನೀರಿನ ಬಾವಿಯು ಸಿಕ್ಕಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ಗೆರಾರಿನ ದನ ಕಾಯುವವರು ಬಂದು ಆ ನೀರು ತಮ್ಮದು ಎಂದು ಹೇಳಿ ಇಸಾಕನ ದನ ಕಾಯುವವರ ಸಂಗಡ ಜಗಳವಾಡಿದ್ದರಿಂದ ಇಸಾಕನು ಆ ಬಾವಿಗೆ “ಏಸೆಕ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ತರುವಾಯ ಅವನ ಜನರು ಬೇರೊಂದು ಬಾವಿಯನ್ನು ತೋಡಿದಾಗ ಆ ದೇಶದವರು ಅದಕ್ಕಾಗಿಯೂ ಜಗಳವಾಡಿದ್ದರಿಂದ ಅವನು ಅದಕ್ಕೆ “ಸಿಟ್ನಾ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ಅವನು ಅಲ್ಲಿಂದ ಹೊರಟು ಮತ್ತೊಂದು ಬಾವಿಯನ್ನೂ ತೋಡಿಸಿದಾಗ ಅದರ ವಿಷಯದಲ್ಲಿ ಯಾರೂ ಜಗಳವಾಡದೆ ಹೋದುದರಿಂದ ಅವನು, “ಈಗ ಯೆಹೋವನು ನಮಗೋಸ್ಕರ ಸ್ಥಳ ಮಾಡಿದ್ದರಿಂದ ಅಭಿವೃದ್ಧಿಯಾಗುವೆವು” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ “ರೆಹೋಬೋತ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ಇಸಾಕನು ಅಲ್ಲಿಂದ ಹೊರಟು ಗಟ್ಟಾ ಹತ್ತಿ ಬೇರ್ಷೆಬಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ಆ ರಾತ್ರಿ ಯೆಹೋವನು ಅವನಿಗೆ ಕಾಣಿಸಿಕೊಂಡು, “ನಾನು ನಿನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನ ದೇವರು; ನೀನು ಭಯಪಡಬೇಡ; ನಾನು ನಿನ್ನ ಸಂಗಡ ಇದ್ದೇನೆ; ನನ್ನ ಸೇವಕನಾದ ಅಬ್ರಹಾಮನ ನಿಮಿತ್ತ ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿ ನಿನ್ನ ಸಂತತಿಯನ್ನು ಹೆಚ್ಚಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ಇಸಾಕನು ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸಿ ಯೆಹೋವನ ಹೆಸರನ್ನು ಹೇಳಿಕೊಂಡು ಆರಾಧಿಸಿ ಅಲ್ಲಿ ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿಸಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ಅಲ್ಲಿಯೂ ಇಸಾಕನ ಸೇವಕರು ಬಾವಿಯನ್ನು ಅಗೆದರು. ಆ ಸಮಯದಲ್ಲಿ ಅಬೀಮೆಲೆಕನು ತನ್ನ ಮಂತ್ರಿಯಾದ ಅಹುಜ್ಜತನನ್ನೂ, ಸೇನಾಪತಿಯಾದ ಫೀಕೋಲನನ್ನೂ ಸಂಗಡ ಕರೆದುಕೊಂಡು ಗೆರಾರಿನಿಂದ ಇಸಾಕನ ಬಳಿಗೆ ಬರಲು ಇಸಾಕನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ನೀವು, “ನನ್ನನ್ನು ದ್ವೇಷಿಸಿ ನಿಮ್ಮ ಬಳಿಯಿಂದ ಕಳುಹಿಸಿ ಬಿಟ್ಟಿರಲ್ಲಾ; ಈಗ ನನ್ನ ಬಳಿಗೆ ಯಾಕೆ ಬಂದಿರಿ” ಎಂದು ಅವರನ್ನು ಕೇಳಿದ್ದಕ್ಕೆ ಅವರು, ");
INSERT INTO kanirv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","“ಯೆಹೋವನು ನಿನ್ನ ಸಂಗಡ ಇದ್ದಾನೆ ಎಂದು ನಮಗೆ ಸ್ಪಷ್ಟವಾಗಿ ಕಂಡು ಬಂದುದರಿಂದ ನೀನೂ, ನಾವೂ ಒಬ್ಬರಿಗೊಬ್ಬರು ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಳ್ಳೋಣವೆಂದು ಆಲೋಚಿಸಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ನಾವು ನಿನಗೆ ಯಾವ ಕೇಡನ್ನೂ ಮಾಡದೆ ಹಿತವನ್ನೇ ಮಾಡಿ ನಿನ್ನನ್ನು ಸಮಾಧಾನದಿಂದ ಕಳುಹಿಸಿದೆವಲ್ಲಾ. ಅದರಂತೆ ನೀನು ನಮಗೆ ಕೇಡನ್ನು ಮಾಡುವುದಿಲ್ಲವೆಂಬುದಾಗಿ ಪ್ರಮಾಣಮಾಡಬೇಕು. ನೀನು ಈಗ ಯೆಹೋವನ ದಯೆಯನ್ನು ಹೊಂದಿದವನಾಗಿದ್ದೀಯಲ್ಲವೇ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ಆಗ ಇಸಾಕನು ಅವರಿಗೆ ಔತಣವನ್ನು ಮಾಡಿಸಿದನು. ಅವರೆಲ್ಲರೂ ಭೋಜನ ಉಪಚಾರಗಳನ್ನು ಮುಗಿಸಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ಅವರು ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಒಬ್ಬರಿಗೊಬ್ಬರು ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಂಡರು. ಇಸಾಕನು ಅವರನ್ನು ಕಳುಹಿಸಲು ಅವರು ಸಮಾಧಾನದಿಂದ ಹೊರಟುಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ಅದೇ ದಿನದಲ್ಲಿ ಇಸಾಕನ ಸೇವಕರು ಬಂದು, “ನಮಗೆ ನೀರು ಸಿಕ್ಕಿತು” ಎಂದು ಹೇಳಿ ತಾವು ತೋಡಿದ ಬಾವಿಯ ಸಂಗತಿಯನ್ನು ತಿಳಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ಅವನು ಆ ಬಾವಿಗೆ “ಷಿಬಾ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ಆದುದರಿಂದ ಅಲ್ಲಿರುವ ಊರಿಗೆ ಇಂದಿನವರೆಗೂ “ಬೇರ್ಷೆಬ” ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ಏಸಾವನು ನಲವತ್ತು ವರ್ಷದವನಾದಾಗ ಹಿತ್ತಿಯನಾದ ಬೇರಿಯ ಮಗಳಾದ ಯೆಹೂದೀತಳನ್ನೂ ಹಿತ್ತಿಯನಾದ ಏಲೋನನ ಮಗಳಾದ ಬಾಸೆಮತಳನ್ನೂ ಮದುವೆ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ಇವರ ದೆಸೆಯಿಂದ ಇಸಾಕನಿಗೂ ರೆಬೆಕ್ಕಳಿಗೂ ಮನೋವ್ಯಥೆ ಉಂಟಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ಇಸಾಕನು ಮುಪ್ಪಿನಿಂದ ಕಣ್ಣು ಕಾಣಲಾರದಷ್ಟು ಮೊಬ್ಬಾಗಿರಲು ಅವನು ತನ್ನ ಹಿರೀಮಗನಾದ ಏಸಾವನನ್ನು ಕರೆದು, “ಮಗನೇ” ಎನ್ನಲು ಏಸಾವನು, “ಇಗೋ ಇದ್ದೇನೆ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ಇಸಾಕನು ಅವನಿಗೆ, “ನಾನು ಮುದುಕನಾಗಿದ್ದೇನೆ; ಯಾವಾಗ ಸಾಯುವೆನೋ ಗೊತ್ತಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ಆದುದರಿಂದ ನೀನು ಬಿಲ್ಲು ಬತ್ತಳಿಕೆ ಮುಂತಾದ ಆಯುಧಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ");
INSERT INTO kanirv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ಕಾಡಿಗೆ ಹೋಗಿ ಬೇಟೆಯಾಡಿ ಬೇಟೆ ಮಾಂಸದಿಂದ ನನಗೆ ಇಷ್ಟವಾಗಿರುವ ರುಚಿಪದಾರ್ಥವನ್ನು ನನ್ನ ಊಟಕ್ಕೆ ಸಿದ್ಧಪಡಿಸು, ಸಾವು ಬರುವುದಕ್ಕಿಂತ ಮೊದಲು ನಾನು ಅದನ್ನು ತಿಂದು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ಇಸಾಕನು ತನ್ನ ಮಗನಾದ ಏಸಾವನಿಗೆ ಹೇಳಿದ ಮಾತು ರೆಬೆಕ್ಕಳ ಕಿವಿಗೆ ಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ಏಸಾವನು ಬೇಟೆಯಾಡುವುದಕ್ಕೆ ಕಾಡಿಗೆ ಹೋಗಿದ್ದಾಗ ರೆಬೆಕ್ಕಳು ತನ್ನ ಮಗನಾದ ಯಾಕೋಬನಿಗೆ, “ನಿನ್ನ ತಂದೆಯು ನಿನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘ನೀನು ಹೋಗಿ ಬೇಟೆಯಾಡಿ ಬೇಟೆಯ ಮಾಂಸದಿಂದ ನನ್ನ ಊಟಕ್ಕೆ ರುಚಿಪದಾರ್ಥವನ್ನು ಸಿದ್ಧಮಾಡು; ಸಾವು ಬರುವುದಕ್ಕಿಂತ ಮೊದಲು ನಾನು ನಿನ್ನನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಆಶೀರ್ವದಿಸುತ್ತೇನೆ’ ಎಂದು ಹೇಳುವುದನ್ನು ಕೇಳಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ಆದುದರಿಂದ ಮಗನೇ, ನೀನು ನನ್ನ ಮಾತಿಗೆ ಕಿವಿಗೊಟ್ಟು ನನ್ನ ಅಪ್ಪಣೆಯಂತೆ ಮಾಡು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ಆಡಿನ ಹಿಂಡಿನೊಳಗೆ ಹೋಗಿ ಎರಡು ಒಳ್ಳೆ ಆಡಿನ ಮರಿಗಳನ್ನು ಬೇಗ ತೆಗೆದುಕೊಂಡು ಬಾ; ಅವುಗಳಿಂದ ನಿನ್ನ ತಂದೆಗೆ ಇಷ್ಟವಾಗಿರುವ ರುಚಿಪದಾರ್ಥವನ್ನು ನಾನೇ ಸಿದ್ಧಮಾಡುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ನೀನು ಅದನ್ನು ಅವನ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಬಡಿಸಬೇಕು; ಹೀಗೆ ಮಾಡಿದರೆ ಅವನು ಸಾಯುವುದಕ್ಕಿಂತ ಮೊದಲು ನಿನ್ನನ್ನೇ ಆಶೀರ್ವದಿಸುವನು” ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ಅದಕ್ಕೆ ಯಾಕೋಬನು ತನ್ನ ತಾಯಿ ರೆಬೆಕ್ಕಳಿಗೆ, “ನನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನು ಮೈತುಂಬ ಅಧಿಕವಾಗಿ ರೋಮವುಳ್ಳವನಾಗಿದ್ದಾನೆ. ನಾನು ನುಣುಪಾದ ಚರ್ಮವುಳ್ಳವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ಒಂದು ವೇಳೆ ತಂದೆಯು ನನ್ನನ್ನು ಮುಟ್ಟಿ ನೋಡಿದರೆ ನಾನು ಅವನಿಗೆ ಮೋಸ ಮಾಡುವವನಾಗಿ ಕಂಡು ಬಂದರೆ, ಆಶೀರ್ವಾದಕ್ಕಿಂತ ಶಾಪವನ್ನೇ ಹೊಂದುವೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ಅವನ ತಾಯಿಯು ಅವನಿಗೆ, “ಮಗನೇ, ಅವನು ನಿನಗೆ ಶಾಪಕೊಟ್ಟರೆ ಆ ಶಾಪ ನನಗಿರಲಿ; ನೀನು ನನ್ನ ಮಾತನ್ನು ಕೇಳಿ ಆಡಿನ ಮರಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬಾ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ಅವನು ಹೋಗಿ ಅವುಗಳನ್ನು ತಂದು ತಾಯಿಗೆ ಕೊಟ್ಟನು. ರೆಬೆಕ್ಕಳು ಅವನ ತಂದೆಗೆ ಇಷ್ಟವಾಗಿದ್ದ ಸವಿಯೂಟವನ್ನು ಸಿದ್ಧಪಡಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ಆಮೇಲೆ ರೆಬೆಕ್ಕಳು ಮನೆಯಲ್ಲಿ ತನ್ನ ವಶದಲ್ಲಿದ್ದ ಹಿರೀಮಗನಾದ ಏಸಾವನ ಶ್ರೇಷ್ಠ ವಸ್ತ್ರಗಳನ್ನು ತೆಗೆದು, ತನ್ನ ಕಿರಿಯ ಮಗನಾದ ಯಾಕೋಬನಿಗೆ ಹೊದಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ಆ ಆಡಿನ ಮರಿಗಳ ಚರ್ಮಗಳನ್ನು ಅವನ ಕೈಗಳಿಗೂ, ನುಣುಪಾದ ಕೊರಳಿಗೂ ಸುತ್ತಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ನಂತರ ತಾನು ಸಿದ್ಧಮಾಡಿದ್ದ ರುಚಿಪದಾರ್ಥವನ್ನೂ ರೊಟ್ಟಿಯನ್ನೂ ತನ್ನ ಮಗನಾದ ಯಾಕೋಬನ ಕೈಯಲ್ಲಿ ಕೊಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ಅವನು ತಂದೆಯ ಬಳಿಗೆ ಹೋಗಿ, “ಅಪ್ಪಾ” ಎಂದು ಕರೆಯಲು, ತಂದೆಯು, “ಏನು ಮಗನೇ, ನೀನು ಯಾರು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ಯಾಕೋಬನು ಅವನಿಗೆ, “ನಾನು ನಿನ್ನ ಹಿರೀಮಗನಾದ ಏಸಾವನು; ನಿನ್ನ ಅಪ್ಪಣೆಯಂತೆ ಊಟ ಸಿದ್ಧಪಡಿಸಿಕೊಂಡು ತಂದಿದ್ದೇನೆ. ಎದ್ದು, ಕುಳಿತುಕೊಂಡು ನಾನು ತಂದಿರುವ ಬೇಟೆ ಮಾಂಸವನ್ನು ಊಟಮಾಡಿ ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸು” ಎಂದು ಹೇಳಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ಇಸಾಕನು, “ಏನು ಮಗನೇ, ಇಷ್ಟು ಬೇಗ ಬೇಟೆ ಹೇಗೆ ಸಿಕ್ಕಿತು” ಎಂದು ಕೇಳಿದ್ದಕ್ಕೆ ಅವನು, “ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವನು ಅದನ್ನು ನನ್ನೆದುರಿಗೆ ಬರಮಾಡಿದನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ಇಸಾಕನು ಯಾಕೋಬನಿಗೆ, “ಕಂದಾ, ನನ್ನ ಬಳಿಗೆ ಬಾ; ನೀನು ನನ್ನ ಮಗನಾದ ಏಸಾವನೋ ಅಲ್ಲವೋ ನಿನ್ನನ್ನು ಮುಟ್ಟಿ ತಿಳಿದುಕೊಳ್ಳಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯ ಹತ್ತಿರಕ್ಕೆ ಬಂದಾಗ ಇಸಾಕನು ಅವನನ್ನು ಮುಟ್ಟಿ ನೋಡಿ, “ಸ್ವರವೇನೋ ಯಾಕೋಬನ ಸ್ವರವಾಗಿದೆ, ಕೈಗಳು ಏಸಾವನ ಕೈಗಳು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ಯಾಕೋಬನ ಕೈಗಳು ಏಸಾವನ ಕೈಗಳಂತೆ ರೋಮವುಳ್ಳವುಗಳಾಗಿದ್ದರಿಂದ ಇಸಾಕನು ಅವನ ಗುರುತನ್ನು ಹಿಡಿಯಲಾರದೆ ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ಅವನು, “ನೀನು ನಿಜವಾದ ನನ್ನ ಮಗನಾದ ಏಸಾವನೋ” ಎಂದು ಕೇಳಿದ್ದಕ್ಕೆ ಯಾಕೋಬನು, “ಹೌದು” ಎನ್ನಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ಇಸಾಕನು, “ಆ ಪದಾರ್ಥವನ್ನು ಹತ್ತಿರಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಬಾ; ನೀನು ತಂದ ಬೇಟೆ ಮಾಂಸವನ್ನು ನಾನು ಊಟಮಾಡಿದ ಮೇಲೆ ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ಯಾಕೋಬನು ಅದನ್ನು ಅವನ ಹತ್ತಿರಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಬರಲು ಅವನು ತಿಂದನು; ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ಆಮೇಲೆ ಅವನ ತಂದೆಯಾದ ಇಸಾಕನು ಅವನಿಗೆ, “ಮಗನೇ, ನೀನು ಹತ್ತಿರ ಬಂದು ನನಗೆ ಮುದ್ದಿಡು” ಎಂದು ಹೇಳಲು ಅವನು ಹತ್ತಿರ ಬಂದು ತಂದೆಗೆ ಮುದ್ದಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ಇಸಾಕನು ಅವನ ವಸ್ತ್ರಗಳ ವಾಸನೆಯನ್ನು ಮೂಸಿ ನೋಡಿ ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿ, “ಆಹಾ, ನನ್ನ ಮಗನ ಸುವಾಸನೆಯು, ಯೆಹೋವನು ಆಶೀರ್ವದಿಸಿದ ಹೊಲದ ಸುವಾಸನೆಯಂತಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ದೇವರು ನಿನಗೆ ಆಕಾಶದ ಮಂಜನ್ನೂ, ಸಾರವುಳ್ಳ ಭೂಮಿಯನ್ನೂ ಕೊಟ್ಟು ದವಸಧಾನ್ಯಗಳನ್ನೂ, ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಹೇರಳವಾಗಿ ಅನುಗ್ರಹಿಸಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ಜನಗಳು ನಿನ್ನನ್ನು ಆರಾಧಿಸಲಿ, ಜನಾಂಗಗಳು ನಿನಗೆ ಅಧೀನವಾಗಲಿ. ನಿನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ ನೀನು ದೊರೆಯಾಗಿರು, ನಿನ್ನ ತಾಯಿಯ ಮಕ್ಕಳು ನಿನಗೆ ಅಡ್ಡಬೀಳಲಿ. ನಿನ್ನನ್ನು ಶಪಿಸುವವರಿಗೆ ಶಾಪವೂ, ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವವರಿಗೆ ಆಶೀರ್ವಾದವೂ ಉಂಟಾಗಲಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ಇಸಾಕನು ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದ ಮೇಲೆ ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯ ಬಳಿಯಿಂದ ಹೊರಟುಹೋದ ಕ್ಷಣವೇ ಅವನ ಅಣ್ಣನಾದ ಏಸಾವನು ಬೇಟೆಯಿಂದ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ಅವನೂ ಸವಿಯೂಟವನ್ನು ಸಿದ್ಧಮಾಡಿ ತನ್ನ ತಂದೆಯ ಬಳಿಗೆ ತಂದು ಅವನಿಗೆ, “ಅಪ್ಪಾ, ನೀನು ಎದ್ದು ನಿನ್ನ ಮಗನಾದ ನಾನು ಬೇಟೆಯಿಂದ ತಂದಿರುವ ಮಾಂಸವನ್ನು ಊಟಮಾಡಿ ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ಅವನ ತಂದೆಯಾದ ಇಸಾಕನು, “ನೀನು ಯಾರು?” ಎಂದು ಅವನನ್ನು ಕೇಳಲು ಅವನು, “ನಾನು ನಿನ್ನ ಚೊಚ್ಚಲ ಮಗನಾದ ಏಸಾವನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ಅದಕ್ಕೆ ಇಸಾಕನು ಬಹಳವಾಗಿ ಗಡಗಡನೆ ನಡುಗುತ್ತಾ, “ಯಾರೋ ಬೇರೊಬ್ಬನು ಬೇಟೆ ಮಾಂಸವನ್ನು ತಂದು ನನಗೆ ಕೊಟ್ಟುಹೋದನಲ್ಲಾ. ನೀನು ಬರುವುದಕ್ಕಿಂತ ಮೊದಲೇ ಅವನು ತಂದಿದ್ದರಲ್ಲಿ ನಾನು ಊಟಮಾಡಿ ಅವನನ್ನೇ ಆಶೀರ್ವದಿಸಿದೆನು; ಅವನಿಗೆ ಮಾಡಿದ ಆಶೀರ್ವಾದ ತಪ್ಪಲಾರದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ಏಸಾವನು ತನ್ನ ತಂದೆಯ ಮಾತುಗಳನ್ನು ಕೇಳಿ ದುಃಖಾಕ್ರಾಂತನಾಗಿ ಬಹಳವಾಗಿ ಅಳುತ್ತಾ, “ಅಪ್ಪಾ, ತಂದೆಯೇ, ನನ್ನನ್ನು ಸಹ ಆಶೀರ್ವದಿಸು” ಎಂದು ಬೇಡಿಕೊಳ್ಳಲು ಇಸಾಕನು, ");
INSERT INTO kanirv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","“ನಿನ್ನ ತಮ್ಮನು ಮೋಸದಿಂದ ಬಂದು ನಿನಗಾಗಬೇಕಾಗಿದ್ದ ಆಶೀರ್ವಾದವನ್ನು ಪಡೆದುಕೊಂಡನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ಅದಕ್ಕೆ ಏಸಾವನು, “ಯಾಕೋಬನೆಂಬ ಹೆಸರು ಅವನಿಗೆ ಉಂಟಾದದ್ದು ನ್ಯಾಯವಲ್ಲವೋ? ಎರಡು ಸಾರಿ ನನ್ನನ್ನು ವಂಚಿಸಿದ್ದಾನೆ, ಹಿಂದೆ ನನ್ನ ಚೊಚ್ಚಲತನದ ಹಕ್ಕನ್ನು ಅಪಹರಿಸಿದನು; ಈಗ ಬಂದು ನನಗಾಗ ಬೇಕಾಗಿದ್ದ ಆಶೀರ್ವಾದವನ್ನೂ ತೆಗೆದುಕೊಂಡಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿ ತನ್ನ ತಂದೆಯನ್ನು, “ನನಗೋಸ್ಕರವೂ ನಿನ್ನ ಬಳಿ ಆಶೀರ್ವಾದವಿಲ್ಲವೋ” ಎಂದು ಕೇಳಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ಇಸಾಕನು ಏಸಾವನಿಗೆ, “ನನ್ನ ಮಗನೇ, ಅವನನ್ನು ನಿನ್ನ ದೊರೆಯನ್ನಾಗಿ ನೇಮಿಸಿದ್ದೇನೆ; ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರನ್ನು ಅವನಿಗೆ ಸೇವಕನನ್ನಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ; ದವಸಧಾನ್ಯಗಳನ್ನೂ ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಅವನ ಪೋಷಣೆಗಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ ನೋಡು. ಹೀಗಿರುವಲ್ಲಿ ನಾನು ನಿನಗೋಸ್ಕರ ಏನು ಮಾಡಲಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ಏಸಾವನು ಅವನಿಗೆ, “ಅಪ್ಪಾ, ತಂದೆಯೇ, ನಿನ್ನಲ್ಲಿ ಒಂದೇ ಒಂದು ಆಶೀರ್ವಾದ ಮಾತ್ರ ಇರುವುದೋ? ಅಪ್ಪಾ, ನನ್ನನ್ನೂ ಆಶೀರ್ವದಿಸಬೇಕು” ಎಂದು ಹೇಳಿ ಗೋಳಾಡುತ್ತಾ ಅಳಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ಅವನ ತಂದೆಯಾದ ಇಸಾಕನು ಅವನಿಗೆ, “ಸಾರವುಳ್ಳ ಭೂಮಿಯೂ ಮೇಲಿನಿಂದ ಬೀಳುವ ಆಕಾಶದ ಮಂಜು ಇರುವ ಸ್ಥಳದಲ್ಲಿ ನಿನ್ನ ನಿವಾಸವಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ನೀನು ಕತ್ತಿಯಿಂದಲೇ ಜೀವನ ಮಾಡುವಿ. ನಿನ್ನ ತಮ್ಮನಿಗೆ ಸೇವಕನಾಗಿರುವಿ. ಆದರೂ ನೀನು ತಾಳ್ಮೆ ಮೀರುವಾಗ, ಅವನು ನಿನ್ನ ಹೆಗಲಿನ ಮೇಲೆ ಹೊರಿಸಿರುವ ನೊಗವನ್ನು ಮುರಿದು ಹಾಕುವಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ತಂದೆಯು ಯಾಕೋಬನಿಗೆ ಮಾಡಿದ ಆಶೀರ್ವಾದದ ನಿಮಿತ್ತ ಏಸಾವನು ಯಾಕೋಬನನ್ನು ಹಗೆಮಾಡಿ ತನ್ನ ಮನಸ್ಸಿನೊಳಗೆ, “ತಂದೆಗೋಸ್ಕರ ದುಃಖಿಸುವ ಕಾಲ ಸಮೀಪಿಸಿತು. ತರುವಾಯ ನನ್ನ ತಮ್ಮನಾದ ಯಾಕೋಬನನ್ನು ಕೊಲ್ಲುವೆನು” ಎಂದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ಹಿರಿಮಗನಾದ ಏಸಾವನು ಹೇಳಿದ ಮಾತು ರೆಬೆಕ್ಕಳಿಗೆ ತಿಳಿದುಬಂದಾಗ ಆಕೆಯು ತನ್ನ ಕಿರಿಯ ಮಗನಾದ ಯಾಕೋಬನನ್ನು ಕರೆದು ಅವನಿಗೆ, “ನೋಡು, ನಿನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನು ನಿನ್ನನ್ನು ಕೊಂದು ಸಮಾಧಾನದಿಂದ ಇರಬೇಕೆಂದುಕೊಂಡಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ಆದುದರಿಂದ ಮಗನೇ, ನನ್ನ ಮಾತಿಗೆ ವಿಧೇಯನಾಗು; ನೀನು ಎದ್ದು ಹಾರಾನಿನಲ್ಲಿರುವ ನನ್ನ ಅಣ್ಣನಾದ ಲಾಬಾನನ ಬಳಿಗೆ ಹೊರಟುಹೋಗು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ಕೆಲವು ಕಾಲ, ನಿನ್ನ ಅಣ್ಣನ ಕೋಪವು ಶಮನವಾಗುವ ವರೆಗೂ ಅವನ ಬಳಿಯಲ್ಲೇ ಇರು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ನಿನ್ನ ಅಣ್ಣನು ನೀನು ಮಾಡಿರುವುದನ್ನು ಮರೆತು, ತನ್ನ ಕೋಪವನ್ನು ಮರೆತು ಬಿಟ್ಟಾಗ ನಾನು ನಿನ್ನನ್ನು ಅಲ್ಲಿಂದ ಕರೆಯಿಸುವೆನು. ನಾನು ಒಂದೇ ದಿನದಲ್ಲಿ ನಿಮ್ಮಿಬ್ಬರನ್ನೂ ಕಳೆದುಕೊಳ್ಳುವುದು ಏಕೆ?” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ರೆಬೆಕ್ಕಳು ಇಸಾಕನಿಗೆ, “ಹಿತ್ತಿಯರಾದ ಈ ಸ್ತ್ರೀಯರ ದೆಸೆಯಿಂದ ನನಗೆ ಬೇಸರವಾಗಿದೆ, ಯಾಕೋಬನೂ ಈ ದೇಶದಲ್ಲಿರುವ ಹಿತ್ತಿಯ ಸ್ತ್ರೀಯನ್ನು ಆರಿಸಿಕೊಂಡು ಮದುವೆ ಮಾಡಿಕೊಂಡರೆ, ನಾನು ಇನ್ನೂ ಬದುಕುವುದರಿಂದ ಪ್ರಯೋಜನವೇನು?” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ಆಗ ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಕರೆದು ಆಶೀರ್ವದಿಸಿ ಅವನಿಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, “ನೀನು ಕಾನಾನ್ಯರ ಹೆಣ್ಣನ್ನು ಮದುವೆಯಾಗಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ಪದ್ದನ್ ಅರಾಮ್ ದೇಶದಲ್ಲಿರುವ ನಿನ್ನ ತಾಯಿಯ ತಂದೆಯಾದ ಬೆತೂವೇಲನ ಮನೆಗೆ ಹೊರಟು ಹೋಗು. ಅಲ್ಲಿ ನಿನ್ನ ತಾಯಿಯ ಸಹೋದರನಾದ ಲಾಬಾನನ ಹೆಣ್ಣು ಮಕ್ಕಳಲ್ಲಿ ಒಬ್ಬಳನ್ನು ಮದುವೆ ಮಾಡಿಕೋ. ");
INSERT INTO kanirv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ಸರ್ವಶಕ್ತನಾದ ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿ ನಿನಗೆ ಬಹಳ ಸಂತತಿಯನ್ನು ಕೊಟ್ಟು ನಿನ್ನಿಂದ ಅನೇಕ ಜನಾಂಗಗಳು ಹುಟ್ಟುವಂತೆ ಅನುಗ್ರಹಿಸಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ ಕೊಟ್ಟಿರುವ ಆಶೀರ್ವಾದವನ್ನು ನಿನಗೂ, ನಿನ್ನ ಸಂತತಿಗೂ ಕೊಡಲಿ, ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ ವಾಗ್ದಾನ ಮಾಡಿದ ಹಾಗೆ, ನೀನು ಈಗ ಪ್ರವಾಸಿಯಾಗಿರುವ ದೇಶವನ್ನು ಸ್ವತ್ತಾಗಿ ಹೊಂದುವಂತೆ ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿ ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಗೂ ಕೊಡಲಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಕಳುಹಿಸಿದಾಗ ಅವನು ಪದ್ದನ್ ಅರಾಮನಲ್ಲಿದ್ದ ಯಾಕೋಬನ ಮತ್ತು ಏಸಾವನ ತಾಯಿಯಾದ ರೆಬೆಕ್ಕಳ ಅಣ್ಣನಾದ ಅರಾಮಿನವನಾದ ಬೆತೂವೇಲನ ಮಗನಾಗಿದ್ದ ಲಾಬಾನನ ಬಳಿಗೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಆಶೀರ್ವದಿಸಿ ಪದ್ದನ್ ಅರಾಮಿನಲ್ಲಿ ಹೆಣ್ಣನ್ನು ಹುಡುಕಿ ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಲು ಕಳುಹಿಸಿದ್ದನ್ನೂ, ಅವನು ಯಾಕೋಬನನ್ನು ಆಶೀರ್ವದಿಸುವಾಗ ಅವನಿಗೆ, ನೀನು ಕಾನಾನ್ಯರ ಹೆಣ್ಣನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಾರದೆಂದು ಅಪ್ಪಣೆಕೊಟ್ಟದ್ದನ್ನೂ, ಏಸಾವನು ನೋಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ಯಾಕೋಬನು ತನ್ನ ತಂದೆತಾಯಿಗಳ ಮಾತಿಗೆ ವಿಧೇಯನಾಗಿ ಪದ್ದನ್ ಅರಾಮಿಗೆ ಹೋದದ್ದನ್ನೂ ಸಹ ಏಸಾವನು ನೋಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ಕಾನಾನ್ಯರ ಹೆಣ್ಣು ಮಕ್ಕಳು ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನಿಗೆ ಇಷ್ಟವಿಲ್ಲವೆಂದು ಏಸಾವನು ತಿಳಿದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ಏಸಾವನು ಇಷ್ಮಾಯೇಲನ ಬಳಿಗೆ ಹೋಗಿ ಅಬ್ರಹಾಮನ ಮಗನೂ ಇಷ್ಮಾಯೇಲನ ಮಗಳೂ ನೆಬಾಯೋತನ ತಂಗಿಯೂ ಆಗಿರುವ ಮಹಲತಳನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ಆಗ ಯಾಕೋಬನು ಹಾರಾನಿಗೆ ಹೋಗಬೇಕೆಂದು ಬೇರ್ಷೆಬದಿಂದ ಹೊರಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ಅವನು ಪ್ರಯಾಣಾರ್ಥವಾಗಿ ಹೋಗುತ್ತಿರುವಾಗ ಹೊತ್ತು ಮುಳುಗಿದ್ದರಿಂದ ಆ ರಾತ್ರಿ ಅಲ್ಲಿಯೇ ಉಳಿದುಕೊಂಡನು. ಅವನು ಅಲ್ಲಿದ್ದ ಕಲ್ಲುಗಳಲ್ಲಿ ಒಂದು ಕಲ್ಲನ್ನು ತಲೆದಿಂಬಾಗಿ ಇಟ್ಟುಕೊಂಡು ಆ ಸ್ಥಳದಲ್ಲಿ ಮಲಗಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ಆ ರಾತ್ರಿ ಅವನು ಒಂದು ಕನಸು ಕಂಡನು. ಆ ಕನಸಿನಲ್ಲಿ ಒಂದು ಏಣಿಯು ಭೂಮಿಯ ಮೇಲೆ ನಿಂತಿತು. ಅದರ ತುದಿ ಆಕಾಶವನ್ನು ಮುಟ್ಟಿತು. ಅದರ ಮೇಲೆ ದೇವ ದೂತರು ಏರುತ್ತಾ ಇಳಿಯುತ್ತಾ ಇದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ಇದಲ್ಲದೆ ಯೆಹೋವನು ಅದರ ಮೇಲೆ ನಿಂತುಕೊಂಡು, “ನಿನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನ ದೇವರೂ, ಇಸಾಕನ ದೇವರೂ ಆಗಿರುವ ಯೆಹೋವನು ನಾನೇ. ನೀನು ಮಲಗಿರುವ ಭೂಮಿಯನ್ನು ನಿನಗೂ, ನಿನ್ನ ಸಂತತಿಗೂ ಕೊಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ನಿನ್ನ ಸಂತತಿಯು ಭೂಮಿಯ ಧೂಳಿನಷ್ಟು ಅಸಂಖ್ಯವಾಗುವುದು. ನೀನು ಪೂರ್ವ, ಪಶ್ಚಿಮ, ದಕ್ಷಿಣ ಉತ್ತರ ದಿಕ್ಕುಗಳಿಗೆ ಹರಡಿಕೊಳ್ಳುವಿ. ನಿನ್ನಿಂದಲೂ, ನಿನ್ನ ಸಂತತಿಯಿಂದಲೂ, ಭೂಮಿಯ ಎಲ್ಲಾ ಕುಲದವರು ಆಶೀರ್ವಾದ ಹೊಂದುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ಇಗೋ, ನಾನು ನಿನ್ನ ಸಂಗಡ ಇದ್ದು ನೀನು ಹೋಗುವಲ್ಲೆಲ್ಲಾ ನಿನ್ನನ್ನು ಕಾಪಾಡಿ, ಪುನಃ ಈ ದೇಶಕ್ಕೆ ಬರಮಾಡುವೆನು. ಏಕೆಂದರೆ ನಾನು ನಿನಗೆ ಹೇಳಿದ್ದನ್ನೆಲ್ಲಾ ನೆರವೇರಿಸದ ಹೊರತು ಬಿಡುವುದಿಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ಯಾಕೋಬನು ನಿದ್ದೆಯಿಂದ ಎಚ್ಚೆತ್ತು, “ನಿಜವಾಗಿ ಯೆಹೋವನು ಈ ಸ್ಥಳದಲ್ಲಿ ನೆಲೆಸಿದ್ದಾನೆ. ಇದು ನನಗೆ ತಿಳಿಯದೆ ಹೋಯಿತು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ಅವನು ಭಯಪಟ್ಟವನಾಗಿ, “ಈ ಸ್ಥಳವು ಪವಿತ್ರವಾದ್ದದು. ಇದು ದೇವರ ಮನೆಯೇ ಹೊರತು ಬೇರೆಯಲ್ಲ, ಇದು ಪರಲೋಕದ ಬಾಗಿಲು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ಯಾಕೋಬನು ಬೆಳಗ್ಗೆ ಎದ್ದು ತಾನು ತಲೆದಿಂಬಾಗಿ ಇಟ್ಟುಕೊಂಡಿದ್ದ ಕಲ್ಲನ್ನು ತೆಗೆದುಕೊಂಡು ಅದನ್ನು ಸ್ತಂಭವಾಗಿ ನಿಲ್ಲಿಸಿ ಅದರ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಹೊಯ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ಇದಲ್ಲದೆ ಅವನು ಆ ಸ್ಥಳಕ್ಕೆ “ಬೇತೇಲ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ಅದಕ್ಕಿಂತ ಮೊದಲು ಆ ಪಟ್ಟಣಕ್ಕೆ “ಲೂಜ್” ಎಂದು ಹೆಸರಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ಯಾಕೋಬನು ಅಲ್ಲಿ ಪ್ರಮಾಣ ಮಾಡಿ, “ದೇವರು ನನ್ನ ಸಂಗಡ ಇದ್ದು ನಾನು ಹೋಗುವ ಈ ಮಾರ್ಗದಲ್ಲಿ ನನ್ನನ್ನು ಕಾಪಾಡಿ ಉಣ್ಣುವುದಕ್ಕೆ ಆಹಾರವನ್ನೂ, ಉಡುವುದಕ್ಕೆ ವಸ್ತ್ರವನ್ನೂ, ನನಗೆ ಕೊಟ್ಟು, ");
INSERT INTO kanirv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ತಿರುಗಿ ನನ್ನನ್ನು ನನ್ನ ತಂದೆಯ ಮನೆಗೆ ಸುರಕ್ಷಿತವಾಗಿ ಬರಮಾಡಿದರೆ ಯೆಹೋವನೇ ನನಗೆ ದೇವರಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ಇದಲ್ಲದೆ ನಾನು ಸ್ತಂಭವಾಗಿ ನಿಲ್ಲಿಸಿದ ಈ ಕಲ್ಲು ದೇವರ ಮನೆಯಾಗುವುದು. ಆಗ ನೀನು ನನಗೆ ಕೊಡುವುದರಲ್ಲೆಲ್ಲಾ ಹತ್ತರಲ್ಲಿ ಒಂದು ಭಾಗವನ್ನು ನಿನಗೆ ನಾನು ಖಂಡಿತವಾಗಿ ಕೊಡುವೆನು” ಎಂದು ಹರಕೆಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ಆಗ ಯಾಕೋಬನು ಪ್ರಯಾಣ ಮಾಡಿ ಪೂರ್ವ ದಿಕ್ಕಿನ ಜನರ ಸೀಮೆಗೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ಅವನು ಕಣ್ಣೆತ್ತಿ ನೋಡಲಾಗಿ ಹೊಲದಲ್ಲಿ ಬಾವಿಯನ್ನು ಕಂಡನು. ಬಾವಿಯ ಹತ್ತಿರ ಮೂರು ಕುರಿಹಿಂಡುಗಳು ಮಲಗಿದ್ದವು. ಆ ಬಾವಿಯ ನೀರನ್ನು ಮಂದೆಗಳಿಗೆ ಕುಡಿಸುತ್ತಿದ್ದರು. ಆ ಬಾವಿಯ ಮೇಲೆ ಒಂದು ದೊಡ್ಡ ಕಲ್ಲನ್ನು ಇಡಲಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ಹಿಂಡುಗಳೆಲ್ಲಾ ಅಲ್ಲಿ ಕೂಡಿದಾಗ ಕುರಿಕಾಯುವವರು ಬಾವಿಯ ಮೇಲೆ ಮುಚ್ಚಿದ್ದ ಕಲ್ಲನ್ನು ಉರುಳಿಸಿ ಕುರಿಗಳಿಗೆ ನೀರು ಕುಡಿಸಿ ತಿರುಗಿ ಕಲ್ಲನ್ನು ಬಾವಿಯ ಮೇಲೆ ಮುಚ್ಚುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ಯಾಕೋಬನು ಅವರಿಗೆ, “ಅಣ್ಣಂದಿರೇ, ನೀವು ಎಲ್ಲಿಯವರು?” ಎಂದು ಕೇಳಲು ಅವರು, “ನಾವು ಖಾರಾನ್ ಊರಿನವರು” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ಅದಕ್ಕೆ ಅವನು ಅವರಿಗೆ, “ನಾಹೋರನ ಮಗನಾದ ಲಾಬಾನನನ್ನು ನೀವು ಬಲ್ಲಿರೋ?” ಎಂದು ಕೇಳಿದ್ದಕ್ಕೆ, “ನಾವು ಅವನನ್ನು ಬಲ್ಲೆವು” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ಅವನು ಅವರಿಗೆ, “ಅವನು ಕ್ಷೇಮವಾಗಿದ್ದಾನೋ?” ಎಂದು ಕೇಳಲು ಅವರು, “ಕ್ಷೇಮವಾಗಿದ್ದಾನೆ. ಅಗೋ, ಅವನ ಮಗಳಾದ ರಾಹೇಲಳು ಕುರಿಗಳ ಸಂಗಡ ಬರುತ್ತಿದ್ದಾಳೆ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ಯಾಕೋಬನು ಅವರಿಗೆ, “ಇನ್ನೂ ಹೊತ್ತು ಬಹಳ ಇದೆ, ಮಂದೆಗಳಿಗೆ ನೀರನ್ನು ಕುಡಿಸಿ ಪುನಃ ಮೇಯಿಸಿಕೊಂಡು ಬನ್ನಿರಿ ಅನ್ನಲು ಅವರು, ");
INSERT INTO kanirv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ಮಂದೆಗಳೆಲ್ಲವು ಬಂದ ನಂತರ ಅವರು ಬಾವಿಯ ಮೇಲೆ ಮುಚ್ಚಿರುವ ಕಲ್ಲನ್ನು ತೆಗೆದು; ಅನಂತರ ಕುರಿಗಳಿಗೆ ನೀರು ಕುಡಿಸುತ್ತೇವೆ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ಅವನು ಅವರೊಂದಿಗೆ ಮಾತನಾಡುತ್ತಿರುವಾಗಲೇ ರಾಹೇಲಳು ತನ್ನ ತಂದೆಯ ಕುರಿಗಳ ಸಂಗಡ ಬಂದಳು; ಆಕೆಯೇ ಅವುಗಳನ್ನು ಮೇಯಿಸುತ್ತಿದ್ದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ಯಾಕೋಬನು ತನ್ನ ತಾಯಿಯ ಅಣ್ಣನಾದ ಲಾಬಾನನ ಮಗಳಾದ ರಾಹೇಲಳನ್ನೂ ಲಾಬಾನನ ಕುರಿಗಳನ್ನೂ ಕಂಡಾಗ ಬಾವಿಯ ಹತ್ತಿರಕ್ಕೆ ಹೋಗಿ ಅದರ ಮೇಲೆ ಮುಚ್ಚಿದ್ದ ಕಲ್ಲನ್ನು ಸರಿಸಿ ಲಾಬನನ ಕುರಿಗಳಿಗೆ ನೀರು ಕುಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ಯಾಕೋಬನು ರಾಹೇಲಳಿಗೆ ಮುದ್ದಿಟ್ಟು ಜೋರಾಗಿ ಅತ್ತು ಆಕೆಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","“ನಾನು ನಿನ್ನ ತಂದೆಯ ಸೋದರಳಿಯನೂ ರೆಬೆಕ್ಕಳ ಮಗನಾದ ಯಾಕೋಬನೆಂದು ತಿಳಿಸಿದನು” ಆಗ ರಾಹೇಲಳು ಓಡಿಹೋಗಿ ಆ ಮಾತನ್ನು ತನ್ನ ತಂದೆಗೆ ತಿಳಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ಲಾಬಾನನು ತನ್ನ ಸಹೋದರಿಯ ಮಗನಾದ ಯಾಕೋಬನು ಬಂದಿರುವ ವರ್ತಮಾನವನ್ನು ಕೇಳಿದಾಗ ಅವನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಓಡಿಬಂದು ಅಪ್ಪಿಕೊಂಡು ಮುದ್ದಿಟ್ಟು ತನ್ನ ಮನೆಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ ಎಲ್ಲಾ ಸಂಗತಿಗಳನ್ನು ತಿಳಿಸಲು ಲಾಬಾನನು ಅವನಿಗೆ, “ನಿಜವಾಗಿ ನೀನು ನನ್ನ ರಕ್ತ ಸಂಬಂಧಿಯಾಗಿದ್ದಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ಅವನು ಒಂದು ತಿಂಗಳಿನವರೆಗೂ ಲಾಬಾನನ ಬಳಿಯಲ್ಲಿ ವಾಸಮಾಡಿದನು. ಆ ಮೇಲೆ ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ನೀನು ನನ್ನ ಸಂಬಂಧಿಯೆಂದು ಸುಮ್ಮನೆ ಸೇವೆ ಮಾಡುವುದು ನ್ಯಾಯವೋ? ನಿನ್ನ ಕೆಲಸಕ್ಕಾಗಿ ನಾನು ನಿನಗೆ ಏನು ಕೊಡಲಿ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ಲಾಬಾನನಿಗೆ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳಿದ್ದರು; ದೊಡ್ಡವಳ ಹೆಸರು ಲೇಯಾ, ಚಿಕ್ಕವಳ ಹೆಸರು ರಾಹೇಲ್. ");
INSERT INTO kanirv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ಲೇಯಾ ಎಂಬಾಕೆಯ ಕಣ್ಣುಗಳು ಕಾಂತಿ ಹೀನವಾಗಿದ್ದವು. ಆದರೆ ರಾಹೇಲಳು ಬಹು ಸುಂದರಿಯು ಲಾವಣ್ಯವತಿಯೂ ಆಗಿದ್ದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನು ಪ್ರೀತಿಸಿ, “ನಿನ್ನ ಕಿರಿಯ ಮಗಳಾದ ರಾಹೇಲಳಿಗೋಸ್ಕರ ಏಳು ವರ್ಷ ಸೇವೆ ಮಾಡುವೆನು” ಎಂದು ಹೇಳಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ಲಾಬಾನನು, “ಆಕೆಯನ್ನು ಬೇರೊಬ್ಬನಿಗೆ ಕೊಡುವುದಕ್ಕಿಂತ ನಿನಗೆ ಕೊಡುವುದೇ ಒಳ್ಳೆಯದು. ಆದುದರಿಂದ ನೀನು ನನ್ನ ಸಂಗಡ ವಾಸವಾಗಿರು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ಈ ಪ್ರಕಾರ ಯಾಕೋಬನು ರಾಹೇಲಳಿಗೋಸ್ಕರ ಏಳು ವರ್ಷ ಸೇವೆ ಮಾಡಿದನು. ಅವನು ಆಕೆಯನ್ನು ಬಹಳವಾಗಿ ಪ್ರೀತಿಸಿದ್ದರಿಂದ ಅದು ಅವನಿಗೆ ಸ್ವಲ್ಪ ಕಾಲದಂತೆ ಕಾಣಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ತರುವಾಯ ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ನನಗೆ ಗೊತ್ತು ಮಾಡಿದ ಕಾಲವು ಪೂರ್ತಿಯಾದವು. ರಾಹೇಲಳನ್ನು ನನಗೆ ಮದುವೆಮಾಡಿ ನನ್ನ ಸ್ವಾಧೀನಕ್ಕೆ ಕೊಡು” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ಆಗ ಲಾಬಾನನು ಆ ಸ್ಥಳದವರೆಲ್ಲರನ್ನು ಕರೆಸಿ ಔತಣವನ್ನು ಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ಸಾಯಂಕಾಲದಲ್ಲಿ ತನ್ನ ಹಿರೀಮಗಳಾದ ಲೇಯಳನ್ನೇ ಯಾಕೋಬನಿಗೆ ಒಪ್ಪಿಸಿಕೊಟ್ಟನು. ಅವನು ಆಕೆಯನ್ನು ಸಂಗಮಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ಲೇಯಳಿಗೆ ಜಿಲ್ಪಾ ಎಂಬ ಒಬ್ಬ ದಾಸಿಯನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ಬೆಳಗ್ಗೆ ಆಕೆ ಲೇಯಳೆಂದು ಯಾಕೋಬನಿಗೆ ತಿಳಿದು ಬರಲು ಅವನು ಲಾಬಾನನಿಗೆ, “ಇದೇನು ನೀನು ನನಗೆ ಮಾಡಿದ್ದು? ರಾಹೇಲಳಿಗೋಸ್ಕರ ನಿನಗೆ ಸೇವೆಮಾಡಿದೆನಲ್ಲಾ; ಯಾಕೆ ನನಗೆ ಮೋಸ ಮಾಡಿದೆ” ಎಂದು ಕೇಳಿದ್ದಕ್ಕೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ಲಾಬಾನನು, “ಹಿರಿ ಮಗಳಿಗಿಂತ ಮೊದಲು ಕಿರಿಯ ಮಗಳನ್ನು ಮದುವೆ ಮಾಡಿಸಿಕೊಡುವುದು ನಮ್ಮ ದೇಶದ ಪದ್ಧತಿಯಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ಆಕೆಯ ಮದುವೆಯ ವಾರವನ್ನು ಪೂರೈಸು. ಅನಂತರ ಈ ನನ್ನ ಕಿರಿಯ ಮಗಳನ್ನೂ ನಿನಗೆ ಕೊಡುತ್ತೇನೆ; ಈಕೆಗೋಸ್ಕರ ನೀನು ಇನ್ನೂ ಏಳು ವರ್ಷ ಸೇವೆಮಾಡು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ಯಾಕೋಬನು ಅದಕ್ಕೆ ಒಪ್ಪಿ ಹಿರಿಯವಳ ಮದುವೆಯ ವಾರವನ್ನು ತೀರಿಸಿದನು. ಆಗ ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ರಾಹೇಲಳನ್ನು ಯಾಕೋಬನಿಗೆ ಮದುವೆ ಮಾಡಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ರಾಹೇಲಳಿಗೆ ಬಿಲ್ಹಾ ಎಂಬ ದಾಸಿಯನ್ನು ಕೂಡ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನೂ ಸಂಗಮಿಸಿ ಆಕೆಯನ್ನು ಲೇಯಳಿಗಿಂತ ಹೆಚ್ಚಾಗಿ ಪ್ರೀತಿಸಿದನು. ಆಕೆಗೋಸ್ಕರ ಲಾಬಾನನ ಬಳಿಯಲ್ಲಿ ಇನ್ನೂ ಏಳು ವರ್ಷ ಸೇವೆಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ಲೇಯಳು ಯಾಕೋಬನಿಗೆ ಅಲಕ್ಷ್ಯವಾಗಿದ್ದಾಳೆಂಬುದನ್ನು ಯೆಹೋವನು ನೋಡಿ, ಆಕೆಯು ಗರ್ಭಧರಿಸುವಂತೆ ಅನುಗ್ರಹಿಸಿದನು; ಆದರೆ ರಾಹೇಲಳು ಬಂಜೆಯಾಗಿದ್ದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ಲೇಯಳು ಗರ್ಭಿಣಿಯಾಗಿ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತು, “ಯೆಹೋವನು ನನ್ನ ವ್ಯಥೆಯನ್ನು ನೋಡಿದ್ದಾನೆ, ಇನ್ನು ಮುಂದೆ ನನ್ನ ಗಂಡನು ನನ್ನನ್ನು ಪ್ರೀತಿಸುವನು ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ ‘ರೂಬೇನ್ ಎಂದು’ ಹೆಸರಿಟ್ಟಳು.” ");
INSERT INTO kanirv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ಆಕೆ ತಿರುಗಿ ಗರ್ಭಿಣಿಯಾಗಿ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತು, “ನಾನು ಗಂಡನ ಅಲಕ್ಷ್ಯಕ್ಕೆ ಗುರಿಯಾದೆನೆಂದು ಯೆಹೋವನು ತಿಳಿದಿದ್ದರಿಂದ ಈ ಮಗುವನ್ನೂ ದಯಪಾಲಿಸಿದನೆಂದು ಹೇಳಿ ಅದಕ್ಕೆ ‘ಸಿಮೆಯೋನ್’ ಎಂದು ಹೆಸರಿಟ್ಟಳು.” ");
INSERT INTO kanirv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ಆಕೆಯು ತಿರುಗಿ ಗರ್ಭಧರಿಸಿ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತು, “ಈಗಲಾದರೂ ನನ್ನ ಗಂಡನೂ ನಾನೂ ಒಂದಾಗುವೆವು, ಅವನಿಗೆ ಮೂರು ಮಂದಿ ಗಂಡು ಮಕ್ಕಳನ್ನು ಹೆತ್ತಿದ್ದೇನಲ್ಲಾ” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ “ಲೇವಿಯೆಂದು” ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ಆಕೆಯು ತಿರುಗಿ ಗರ್ಭಿಣಿಯಾಗಿ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತು, “ಈಗ ಯೆಹೋವನಿಗೆ ಉಪಕಾರ ಸ್ತುತಿಮಾಡುವೆನು” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ “ಯೆಹೂದಾ” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಆ ಮೇಲೆ ಆಕೆಗೆ ಗರ್ಭಧಾರಣೆಯಾಗುವುದು ನಿಂತಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ರಾಹೇಲಳು ತಾನು ಯಾಕೋಬನಿಗೆ ಮಕ್ಕಳನ್ನು ಹೆರದೆ ಇರುವುದನ್ನು ನೋಡಿ ತನ್ನ ಅಕ್ಕನ ಮೇಲೆ ಹೊಟ್ಟೆಕಿಚ್ಚುಪಟ್ಟು, ಯಾಕೋಬನಿಗೆ, “ಮಕ್ಕಳನ್ನು ನನಗೆ ಕೊಡು, ಇಲ್ಲದಿದ್ದರೆ ಸಾಯುವೆನು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ಯಾಕೋಬನು ರಾಹೇಲಳ ಮೇಲೆ ಕೋಪಗೊಂಡು, “ದೇವರು ನಿನಗೆ ಮಕ್ಕಳನ್ನು ಕೊಡದೆ ಹೋದ ಮೇಲೆ ಕೊಡಲಿಕ್ಕೆ ನನ್ನಿಂದಾದೀತೋ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ಅದಕ್ಕೆ ಆಕೆಯು, “ನನ್ನ ದಾಸಿಯಾದ ಬಿಲ್ಹಾ ಇದ್ದಾಳಲ್ಲಾ, ಅವಳನ್ನು ಸಂಗಮಿಸು, ಅವಳು ಬಸುರಾದರೆ ಆ ಮಗುವನ್ನು ನನ್ನ ಮಡಿಲಲ್ಲಿ ಹಾಕಲಿ. ಆಗ ನನಗೂ ಸಂತಾನವಾಗುವುದು” ಎಂದು ಹೇಳಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ತನ್ನ ದಾಸಿಯಾದ ಬಿಲ್ಹಳನ್ನು ಯಾಕೋಬನಿಗೆ ಹೆಂಡತಿಯಾಗುವುದಕ್ಕೆ ಒಪ್ಪಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ಯಾಕೋಬನು ಅವಳನ್ನು ಸಂಗಮಿಸಲು ಬಿಲ್ಹಳು ಗರ್ಭಿಣಿಯಾಗಿ ಗಂಡು ಮಗುವನ್ನು ಹೆರಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ರಾಹೇಲಳು, “ದೇವರು ನನ್ನ ಕಡೆಗೆ ನ್ಯಾಯತೀರಿಸಿದ್ದಾನೆ. ಆತನು ನನ್ನ ಮೊರೆಯನ್ನು ಕೇಳಿ ನನಗೆ ಮಗನನ್ನು ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ “ದಾನ್” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ರಾಹೇಲಳ ದಾಸಿಯಾದ ಬಿಲ್ಹಳು ತಿರುಗಿ ಬಸುರಾಗಿ ಯಾಕೋಬನಿಗೆ ಎರಡನೆಯ ಗಂಡು ಮಗುವನ್ನು ಹೆರಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ರಾಹೇಲಳು, “ನನ್ನ ಅಕ್ಕನ ಸಂಗಡ ಬಲವಾಗಿ ಹೋರಾಡಿ ಜಯಿಸಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ “ನಫ್ತಾಲಿ” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ಲೇಯಳು ತನಗೆ ಹೆರಿಗೆ ನಿಂತುಹೋಗಿರುವುದನ್ನು ತಿಳಿದು ತನ್ನ ದಾಸಿಯಾದ ಜಿಲ್ಪಳನ್ನು ಯಾಕೋಬನ ಹೆಂಡತಿಯಾಗುವುದಕ್ಕೆ ಒಪ್ಪಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ಲೇಯಳ ದಾಸಿಯಾದ ಜಿಲ್ಪಳು ಯಾಕೋಬನಿಗೆ ಗಂಡು ಮಗುವನ್ನು ಹೆರಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ಲೇಯಳು, “ನನಗೆ ಶುಭವಾಯಿತೆಂದು” ಹೇಳಿ ಅದಕ್ಕೆ “ಗಾದ್” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ಲೇಯಳ ದಾಸಿಯಾದ ಜಿಲ್ಪಳು ಯಾಕೋಬನಿಗೆ ಇನ್ನೊಂದು ಗಂಡು ಮಗುವನ್ನು ಹೆರಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ಲೇಯಳು, “ನಾನು ಧನ್ಯಳಾದೆ, ಸ್ತ್ರೀಯರು ನನ್ನನ್ನು ಧನ್ಯಳೆಂದು ಹೊಗಳುವರು” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ “ಆಶೇರ್” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ಗೋದಿ ಸುಗ್ಗಿಯ ಕಾಲದಲ್ಲಿ ರೂಬೇನನು ಅಡವಿಗೆ ಹೋಗಿದ್ದಾಗ ಕಾಮಜನಕ ಹಣ್ಣುಗಳನ್ನು ಕಂಡು ತನ್ನ ತಾಯಿಯಾದ ಲೇಯಳಿಗೆ ತಂದು ಕೊಡಲು ರಾಹೇಲಳು ಆಕೆಗೆ, “ನಿನ್ನ ಮಗನು ತಂದಿರುವ ಕಾಮಜನಕ ಹಣ್ಣುಗಳಲ್ಲಿ ಕೆಲವನ್ನು ನನಗೆ ಕೊಡು” ಎಂದು ಕೇಳಿಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ಅದಕ್ಕೆ ಲೇಯಳು, “ನೀನು ನನ್ನ ಗಂಡನನ್ನು ತೆಗೆದುಕೊಂಡದ್ದು ಸಾಲದೋ? ನನ್ನ ಮಗನು ತಂದ ಕಾಮಜನಕ ಹಣ್ಣುಗಳನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕೆಂದು ಅಪೇಕ್ಷಿಸುತ್ತೀಯಾ?” ಎಂದು ಹೇಳಲು ರಾಹೇಲಳು, “ಒಳ್ಳೆಯದು, ನೀನು ನಿನ್ನ ಮಗನು ತಂದ ಹಣ್ಣುಗಳನ್ನು ನನಗೆ ಕೊಟ್ಟರೆ ಗಂಡನು ಈ ಹೊತ್ತು ರಾತ್ರಿ ನಿನ್ನಲ್ಲೇ ಇರಲಿ” ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ಸಾಯಂಕಾಲದಲ್ಲಿ ಯಾಕೋಬನು ಅಡವಿಯಿಂದ ಬರುವಾಗ ಲೇಯಳು ಅವನೆದುರಿಗೆ ಹೋಗಿ, “ನೀನು ನನ್ನಲ್ಲಿ ಬರಬೇಕು, ನಾನು ನನ್ನ ಮಗನು ತಂದ ಕಾಮಜನಕ ಹಣ್ಣುಗಳನ್ನು ಕೊಟ್ಟು ನಿನ್ನನ್ನು ಸಂಪಾದಿಸಿಕೊಂಡಿದ್ದೇನೆ” ಎಂದಳು. ಆ ಹೊತ್ತು ರಾತ್ರಿ ಅವನು ಆಕೆಯೊಂದಿಗೆ ಇದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ದೇವರು ಲೇಯಳ ಪ್ರಾರ್ಥನೆಯನ್ನು ಕೇಳಿದನು. ಆಕೆಯು ಗರ್ಭಿಣಿಯಾಗಿ ಯಾಕೋಬನಿಗೆ ಐದನೆಯ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ಲೇಯಳು, “ನನ್ನ ದಾಸಿಯನ್ನು ನನ್ನ ಗಂಡನ ವಶಕ್ಕೆ ಒಪ್ಪಿಸಿದ್ದರಿಂದ ದೇವರು ನನಗೆ ಪ್ರತಿಫಲವನ್ನು ಕೊಟ್ಟಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ “ಇಸ್ಸಾಕಾರ್” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ಲೇಯಳು ಪುನಃ ಗರ್ಭಿಣಿಯಾಗಿ ಯಾಕೋಬನಿಗೆ ಆರನೆಯ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ಲೇಯಳು, “ದೇವರು ನನಗೆ ಒಳ್ಳೆಯ ವರದಾನವನ್ನು ಕೊಟ್ಟಿದ್ದಾನೆ. ನಾನು ನನ್ನ ಗಂಡನಿಗೆ ಆರು ಮಂದಿ ಗಂಡು ಮಕ್ಕಳನ್ನು ಹೆತ್ತದ್ದರಿಂದ ಅವನು ನನ್ನೊಡನೆಯೇ ವಾಸಿಸುವನು” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ “ಜೆಬುಲೂನ್” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ತರುವಾಯ ಆಕೆಯು ಹೆಣ್ಣು ಮಗುವನ್ನು ಹೆತ್ತು ಅದಕ್ಕೆ “ದೀನಾ” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ಆಮೇಲೆ ದೇವರು ರಾಹೇಲಳನ್ನು ನೆನಪಿಸಿಕೊಂಡು ಆಕೆಯ ಮೊರೆಯನ್ನು ಕೇಳಿ ಆಕೆಗೆ ಮಕ್ಕಳಾಗುವಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ಆಕೆಯು ಗರ್ಭಿಣಿಯಾಗಿ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತು, “ದೇವರು ನನಗಿದ್ದ ಅವಮಾನವನ್ನು ಪರಿಹರಿಸಿದ್ದಾನೆ” ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ಇದಲ್ಲದೆ ಆಕೆಯು, “ಯೆಹೋವನು ಇನ್ನೊಂದು ಗಂಡು ಮಗುವನ್ನು ನನಗೆ ದಯಪಾಲಿಸುವನು” ಎಂದು ಹೇಳಿ ಅದಕ್ಕೆ “ಯೋಸೇಫ್” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ರಾಹೇಲಳು ಯೋಸೇಫನನ್ನು ಹೆತ್ತ ನಂತರ ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ನಾನು ನನ್ನ ದೇಶದಲ್ಲಿರುವ ಸ್ವಂತ ಊರಿಗೆ ಹೋಗಲು ನನಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ನಾನು ಸೇವೆಮಾಡಿ ಪಡೆದುಕೊಂಡ ಹೆಂಡತಿಯರನ್ನೂ ನನ್ನ ಮಕ್ಕಳನ್ನೂ ನನ್ನೊಂದಿಗೆ ಕಳುಹಿಸಿಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ನಾನು ನಿನಗೆ ಮಾಡಿದ ಸೇವೆಯನ್ನು ನೀನು ಬಲ್ಲವನಾಗಿರುವೆ” ಎಂದು ಹೇಳಲು ಲಾಬಾನನು ಅವನಿಗೆ, “ನನ್ನ ಮೇಲೆ ದಯೆ ಇಟ್ಟು ನನ್ನ ಬಳಿಯಲ್ಲೇ ಇರು. ಯೆಹೋವನು ನಿನ್ನ ನಿಮಿತ್ತ ನನ್ನನ್ನು ಅಭಿವೃದ್ಧಿಪಡಿಸಿದ್ದಾನೆಂದು ಚೆನ್ನಾಗಿ ತಿಳಿದುಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ನಾನು ನಿನಗೆ ಏನು ಕೊಡಬೇಕು ಹೇಳು ಕೊಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ಅದಕ್ಕೆ ಯಾಕೋಬನು, “ನಾನು ನಿನಗೆ ಮಾಡಿದ ಸೇವೆಯನ್ನೂ ನನ್ನ ವಶದಲ್ಲಿದ್ದ ನಿನ್ನ ಪಶುಪ್ರಾಣಿಗಳು ಅಭಿವೃದ್ದಿಯಾದುದ್ದನ್ನೂ ನೀನು ಬಲ್ಲೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ನಾನು ಬರುವುದಕ್ಕೆ ಮೊದಲು ನಿನಗಿದ್ದದ್ದು ಸ್ವಲ್ಪವೇ. ಈಗ ಅದು ಬಹಳವಾಗಿ ಹೆಚ್ಚಿದೆ. ನಾನು ಕೈಹಾಕಿದ ಎಲ್ಲಾ ಕೆಲಸದಲ್ಲಿಯೂ ಯೆಹೋವನು ನಿನ್ನನ್ನು ಅಭಿವೃದ್ಧಿಪಡಿಸಿದ್ದಾನೆ. ಇನ್ನು ನಾನು ನನ್ನ ಸ್ವಂತ ಮನೆಗೋಸ್ಕರ ಯಾವಾಗ ಸಂಪಾದನೆ ಮಾಡಿಕೊಳ್ಳಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ಅದಕ್ಕೆ ಲಾಬಾನನು, “ನಿನಗೆ ನಾನೇನು ಕೊಡಬೇಕು ಹೇಳು” ಅನ್ನಲು ಯಾಕೋಬನು, “ನನಗೆ ಏನೂ ಕೊಡಬೇಡ, ನೀನು ನನಗೆ ಈ ಒಂದು ಕಾರ್ಯ ಮಾತ್ರ ಮಾಡಿದರೆ ಸಾಕು, ನಾನು ಪುನಃ ನಿನ್ನ ಹಿಂಡನ್ನು ಮೇಯಿಸಿ ಕಾಯುವೆನು” ");
INSERT INTO kanirv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ಅದೇನೆಂದರೆ, “ಈ ಹೊತ್ತು ನಾನು ನಿನ್ನ ಹಿಂಡಿನೊಳಗೆ ಹೋಗಿ, ಕುರಿಗಳಲ್ಲಿ ಚುಕ್ಕೆ ಮತ್ತು ಮಚ್ಚೆಗಳಿರುವವುಗಳನ್ನೂ, ಕುರಿಗಳಲ್ಲಿ ಕಪ್ಪಾಗಿರುವವುಗಳನ್ನೂ, ಆಡುಗಳಲ್ಲಿ ಚುಕ್ಕೆ ಮತ್ತು ಮಚ್ಚೆಗಳಿರುವುಗಳನ್ನೂ ವಿಂಗಡಿಸುವೆನು. ಅವೇ ನನ್ನ ಸಂಬಳವಾಗಿರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ಹೀಗಿದ್ದರೆ ಬರುವ ಕಾಲದಲ್ಲಿ ನನ್ನ ಸಂಬಳಕ್ಕಾಗಿ ನಾನು ನಿನ್ನ ಮುಂದೆ ಬಂದಾಗ ನನ್ನ ಪ್ರಾಮಾಣಿಕತೆಯೇ ನನಗೆ ಸಾಕ್ಷಿ ಕೊಡುವುದು. ಆಡುಗಳಲ್ಲಿ ಚುಕ್ಕೆ ಮಚ್ಚೆಗಳಿಲ್ಲದ್ದು, ಕುರಿಗಳಲ್ಲಿ ಕಪ್ಪಿಲ್ಲದ್ದು, ನನ್ನ ಬಳಿಯಲ್ಲಿ ಸಿಕ್ಕಿದರೆ ಅದನ್ನು ಕದ್ದದ್ದೆಂದು ಎಣಿಸಬಹುದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ಅದಕ್ಕೆ ಲಾಬಾನನು, “ಒಳ್ಳೆಯದು, ನೀನು ಹೇಳಿದಂತೆಯೇ ಆಗಲಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ಅದೇ ದಿನ ಲಾಬಾನನು ಆಡುಗಳಲ್ಲಿ ರೇಖೆ ಮಚ್ಚೆ ಇದ್ದವುಗಳನ್ನೂ, ಮೇಕೆಗಳಲ್ಲಿ ಚುಕ್ಕೆ ಮಚ್ಚೆ ಇದ್ದವುಗಳನ್ನೂ, ಅಂದರೆ ಸ್ವಲ್ಪ ಬಿಳುಪಾದ ಬಣ್ಣವು ತೋರಿದ ಎಲ್ಲವುಗಳನ್ನೂ, ಕುರಿಗಳಲ್ಲಿ ಕಪ್ಪಾಗಿದ್ದುವುಗಳನ್ನೂ ವಿಂಗಡಿಸಿ ತನ್ನ ಮಕ್ಕಳ ವಶಕ್ಕೆ ಒಪ್ಪಿಸಿಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ಲಾಬಾನನು ತನಗೂ, ಯಾಕೋಬನಿಗೂ ಮೂರು ದಿನದ ಪ್ರಯಾಣದಷ್ಟು ದೂರ ಅಂತರವನ್ನು ಬಿಟ್ಟನು. ಯಾಕೋಬನು ಲಾಬಾನನ ಹಿಂಡಿನಲ್ಲಿ ಮಿಕ್ಕಾದವುಗಳನ್ನು ಮೇಯಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ಹೀಗಿರುವಲ್ಲಿ ಯಾಕೋಬನು ಚಿನಾರು, ಬಾದಾಮಿ, ಅರ್ಮೋನ್ ಎಂಬ ಮರಗಳ ಹಸಿ ಕೋಲುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಪಟ್ಟೆಪಟ್ಟೆಯಾಗಿ ತೊಗಟೆಯನ್ನು ಸುಲಿದು, ");
INSERT INTO kanirv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ಅವುಗಳಲ್ಲಿರುವ ಬಿಳಿಯ ಬಣ್ಣವು ಕಾಣಿಸುವಂತೆ ಮಾಡಿದನು. ಆ ಕೋಲುಗಳನ್ನು ಆಡುಕುರಿಗಳ ಹಿಂಡು ನೀರು ಕುಡಿಯುವ ತೊಟ್ಟಿಗಳಲ್ಲಿ ಇಟ್ಟನು. ಆಡುಕುರಿಗಳಿಗೆ ನೀರು ಕುಡಿಯುವ ಸಮಯ, ಸಂಗಮ ಸಮಯ. ");
INSERT INTO kanirv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ಆಡುಕುರಿಗಳು ಆ ಕೋಲುಗಳನ್ನು ನೋಡುತ್ತಾ ಸಂಗಮಮಾದಿದ್ದರಿಂದ ರೇಖೆ, ಚುಕ್ಕೆ, ಮಚ್ಚೆಗಳುಳ್ಳ ಮರಿಗಳನ್ನು ಈಯುತ್ತಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ಯಾಕೋಬನು ಆ ಮರಿಗಳನ್ನು ಲಾಬಾನನ ಹಿಂಡಿಗೆ ಸೇರಿಸದೆ ತನ್ನವೆಂದು ಪ್ರತ್ಯೇಕಿಸಿದನು ಮತ್ತು ಲಾಬಾನನ ಆಡು ಕುರಿಗಳ ಮುಖಗಳನ್ನು ರೇಖೆಯುಳ್ಳ ಆ ಆಡುಗಳ ಮತ್ತು ಕಪ್ಪಾದ ಕುರಿಗಳ ಕಡೆಗೆ ತಿರುಗಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ಇದಲ್ಲದೆ ಬಲಿಷ್ಠವಾದ ಆಡು ಕುರಿಗಳು ಸಂಗಮಮಾಡುವಾಗ ಆ ಕೋಲುಗಳನ್ನು ನೋಡುತ್ತಾ ಸಂಗಮಮಾಡಲಿ ಎಂದು ಯಾಕೋಬನು ತೊಟ್ಟಿಗಳಲ್ಲಿ ಕೋಲುಗಳನ್ನಿಟ್ಟನು. ಆದರೆ ಆಡುಕುರಿಗಳು ಬಲಹೀನವಾಗಿದ್ದಾಗ ಅವನು ಕೋಲುಗಳನ್ನು ತೊಟ್ಟಿಗಳಲ್ಲಿ ಇಡುತ್ತಿರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ಹೀಗಾಗಿ ಬಲಹೀನವಾದ ಹಿಂಡು ಲಾಬಾನನ ಪಾಲಿಗೆ ಬಂದವು, ಬಲಿಷ್ಠವಾದವುಗಳು ಯಾಕೋಬನು ಪಾಲಿಗೆ ಬಂದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ಈ ಪ್ರಕಾರ ಯಾಕೋಬನು ಬಹಳ ಸಂಪತ್ತುಳ್ಳವನಾದನು. ಅವನಿಗೆ ಕುರಿಹಿಂಡುಗಳು, ದಾಸದಾಸಿಯರು, ಒಂಟೆ ಕತ್ತೆಗಳು, ಹೇರಳವಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","“ನಮ್ಮ ತಂದೆಯ ಆಸ್ತಿಯೆಲ್ಲಾ ಯಾಕೋಬನ ಪಾಲಾಯಿತು, ನಮ್ಮ ತಂದೆಯ ಆಸ್ತಿಯಿಂದಲೇ ಅವನಿಗೆ ಇಷ್ಟೊಂದು ಐಶ್ವರ್ಯವುಂಟಾಯಿತು” ಎಂಬುದಾಗಿ ಲಾಬಾನನ ಮಕ್ಕಳು ಹೇಳಿಕೊಳ್ಳುವ ಮಾತುಗಳು ಯಾಕೋಬನ ಕಿವಿಗೆ ಬಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ಇದಲ್ಲದೆ ಯಾಕೋಬನು ಲಾಬಾನನ ಮುಖಭಾವವನ್ನು ನೋಡಿದಾಗ ಅದು ಮೊದಲಿದ್ದಂತೆ ತೋರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ಮತ್ತು ಯೆಹೋವನು ಯಾಕೋಬನಿಗೆ, “ನೀನು ನಿನ್ನ ತಂದೆಯ ದೇಶಕ್ಕೂ ನಿನ್ನ ಬಂಧುಗಳ ಬಳಿಗೂ ಹಿಂತಿರುಗಿ ಹೋಗು, ನಾನು ನಿನ್ನೊಂದಿಗೆ ಇರುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ಹೀಗಿರುವುದರಿಂದ ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನೂ, ಲೇಯಳನ್ನೂ, ತನ್ನ ಆಡುಕುರಿಗಳ ಹಿಂಡನ್ನು ಮೇಯಿಸುತ್ತಿದ್ದ ಅಡವಿಗೆ ಕರೆಕಳುಹಿಸಿ ");
INSERT INTO kanirv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ಅವರಿಗೆ ಹೇಳಿದ್ದೇನಂದರೆ, “ನಿಮ್ಮ ತಂದೆಯ ಮುಖಭಾವವು ನನ್ನ ವಿಷಯದಲ್ಲಿ ಮೊದಲಿದ್ದಂತೆ ಇಲ್ಲವೆಂದು ತೋರಿಬಂತು. ಆದರೂ ನನ್ನ ತಂದೆಯ ದೇವರು ನನ್ನೊಂದಿಗೆ ಇದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ನಾನು ನಿಮ್ಮ ತಂದೆಯ ಸೇವೆಯನ್ನು ಪೂರ್ಣಬಲದಿಂದ ಮಾಡಿದ್ದೇನೆ, ನೀವೂ ಅದನ್ನು ಬಲ್ಲಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ಆದರೆ ನಿಮ್ಮ ತಂದೆಯು ನನ್ನನ್ನು ವಂಚಿಸಿ ನನ್ನ ಸಂಬಳವನ್ನು ಹತ್ತು ಸಾರಿ ಬದಲಾಯಿಸಿದನು, ನನಗೆ ಕೇಡುಮಾಡುವುದಕ್ಕೆ ದೇವರು ಅವನಿಗೆ ಅವಕಾಶಕೊಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ನಿಮ್ಮ ತಂದೆ ನನಗೆ, ‘ಚುಕ್ಕೆಯುಳ್ಳದ್ದು ನಿನ್ನ ಸಂಬಳವಾಗಿರಲಿ’ ಎಂದು ಅವನು ಹೇಳಿದಾಗ ಹಿಂಡಿನ ಆಡುಕುರಿಗಳೆಲ್ಲವೂ ಚುಕ್ಕೆಯುಳ್ಳದ್ದನ್ನೇ ಈಯಿತು. ಅವನು ‘ರೇಖೆಯುಳ್ಳದ್ದು ನಿನ್ನ ಸಂಬಳವಾಗಿರಲಿ’ ಎಂದು ಹೇಳಿದಾಗ ಆಡುಕುರಿಗಳೆಲ್ಲವೂ ರೇಖೆಯುಳ್ಳ ಮರಿಗಳನ್ನೇ ಈದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ಹೀಗೆ ದೇವರು ನಿಮ್ಮ ತಂದೆಯ ಆಡುಕುರಿಗಳನ್ನು, ಪಶುಪ್ರಾಣಿಗಳನ್ನು ಅವನಿಂದ ತೆಗೆದು ನನಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“ಕುರಿಗಳು ಗರ್ಭಧರಿಸುವ ಕಾಲದಲ್ಲಿ ನಾನು ಕನಸಿನಲ್ಲಿ ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ ಕುರಿಗಳೊಂದಿಗೆ ಸಂಗಮಿಸಿದ ಆಡುಗಳೆಲ್ಲವೂ ರೇಖೆ, ಚುಕ್ಕೆ ಮಚ್ಚೆಗಳುಳ್ಳವುಗಳಾಗಿ ಕಾಣಿಸಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ಆ ಕನಸಿನಲ್ಲಿ ದೇವದೂತನು, ‘ಯಾಕೋಬನೇ’ ಎಂದು ಕರೆಯಲು ನಾನು, ‘ಇದ್ದೇನೆ’ ಎಂದು ಹೇಳಿದಾಗ ");
INSERT INTO kanirv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ಆತನು ನನಗೆ, ‘ಲಾಬಾನನು ನಿನ್ನ ವಿಷಯದಲ್ಲಿ ನಡೆದುಕೊಂಡ ರೀತಿಯನ್ನು ನಾನು ನೋಡಿದ್ದೇನೆ, ಆದುದರಿಂದ ನೀನು ಕಣ್ಣೆತ್ತಿ ಕುರಿಗಳೊಂದಿಗೆ ಸಂಗಮಿಸುವ ಆಡುಗಳನ್ನು ನೋಡು. ರೇಖೆಯೂ, ಚುಕ್ಕೆಯೂ, ಮಚ್ಚೆಯೂ ಉಳ್ಳವುಗಳಾಗಿವೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ನೀನು ಸ್ತಂಭವನ್ನು ಅಭಿಷೇಕಿಸಿ ನನಗೆ ಪ್ರಮಾಣ ಮಾಡಿದ ಬೇತೇಲಿನ ದೇವರು ನಾನೇ. ಈಗ ನೀನೆದ್ದು ಈ ದೇಶವನ್ನು ಬಿಟ್ಟು ನೀನು ಹುಟ್ಟಿದ ದೇಶಕ್ಕೂ ಬಂಧುಗಳ ಬಳಿಗೂ ಹಿಂತಿರುಗಿ ಹೋಗು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ಯಾಕೋಬನು ಈ ಮಾತುಗಳನ್ನಾಡಿದಾಗ ರಾಹೇಲಳು ಮತ್ತು ಲೇಯಳು, “ನಮ್ಮ ತಂದೆಯ ಮನೆಯಲ್ಲಿ ನಮಗೆ ಪಾಲೂ ಸ್ವಾಸ್ತ್ಯತೆ ಇನ್ನೇನಿದೆ? ");
INSERT INTO kanirv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ಅವನು ನಮ್ಮನ್ನು ಅನ್ಯರೆಂದು ಎಣಿಸುತ್ತಾನಲ್ಲಾ; ಅವನು ನಮ್ಮನ್ನು ಮಾರಿ ನಮ್ಮ ಮೂಲಕ ಸಿಕ್ಕಿದ ಹಣವನ್ನು ತಾನೇ ನುಂಗಿಬಿಟ್ಟನಲ್ಲಾ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ಆದ್ದರಿಂದ ದೇವರು ನಮ್ಮ ತಂದೆಯಿಂದ ತೆಗೆದುಕೊಂಡ ಆಸ್ತಿಯನ್ನೆಲ್ಲಾ ನಮಗೂ, ನಮ್ಮ ಮಕ್ಕಳಿಗೂ ಕೊಟ್ಟನಲ್ಲಾ, ದೇವರು ನಿನಗೆ ಹೇಳಿದಂತೆಯೇ ಮಾಡು” ಎಂದು ಉತ್ತರ ಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ಆಗ ಯಾಕೋಬನು ತನ್ನ ಮಕ್ಕಳನ್ನೂ, ಹೆಂಡತಿಯರನ್ನೂ ಒಂಟೆಗಳ ಮೇಲೆ ಹತ್ತಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ತಾನು ಸಂಪಾದಿಸಿಕೊಂಡಿದ್ದ ಎಲ್ಲಾ ಆಸ್ತಿಯನ್ನೂ, ಪದ್ದನ್ ಅರಾಮ್ ದೇಶದಲ್ಲಿ ಸಂಪಾದಿಸಿಕೊಂಡಿದ್ದ ಎಲ್ಲಾ ಪಶುಪ್ರಾಣಿಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನ ಬಳಿಗೆ ಹೋಗುವುದಕ್ಕಾಗಿ ಹೊರಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ಆಗ ಲಾಬಾನನು ತನ್ನ ಕುರಿಗಳ ಉಣ್ಣೆಯನ್ನು ಕತ್ತರಿಸುವುದಕ್ಕೋಸ್ಕರ ಹೋಗಿದ್ದನು. ಹೀಗಿರುವಲ್ಲಿ ರಾಹೇಲಳು ತನ್ನ ತಂದೆಯ ಮನೆಯಲ್ಲಿದ್ದ ವಿಗ್ರಹಗಳನ್ನು ಕದ್ದುಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ಆದರೆ ಯಾಕೋಬನು ತಾನು ಹೋಗುತ್ತೇನೆಂದು ಅರಾಮ್ಯನಾದ ಲಾಬಾನನಿಗೆ ತಿಳಿಸದೆ ಅವನನ್ನು ಮೋಸಗೊಳಿಸಿ ಹೊರಟುಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ಹೀಗೆ ಅವನು ತನ್ನ ಆಸ್ತಿಯನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು ಯೂಫ್ರೆಟಿಸ್ ಮಹಾ ನದಿಯನ್ನು ದಾಟಿ ಗಿಲ್ಯಾದೆಂಬ ಬೆಟ್ಟದ ಸೀಮೆಯ ದಾರಿಯನ್ನು ಹಿಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ಯಾಕೋಬನು ಹೊರಟುಹೋದ ವರ್ತಮಾನವು ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಲಾಬಾನನಿಗೆ ತಿಳಿದುಬರಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ಅವನು ತನ್ನ ಬಂಧುಗಳನ್ನು ಕೂಡಿಸಿಕೊಂಡು, ಏಳು ದಿನ ಪ್ರಯಾಣಮಾಡಿ ಯಾಕೋಬನನ್ನು ಹಿಂದಟ್ಟಿ ಗಿಲ್ಯಾದ್ ಬೆಟ್ಟದ ಸೀಮೆಯಲ್ಲಿ ಅವನನ್ನು ಸಂಧಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ಆದರೆ ರಾತ್ರಿಯಲ್ಲಿ ದೇವರು ಅರಾಮ್ಯನಾದ ಲಾಬಾನನ ಕನಸಿನಲ್ಲಿ ಬಂದು, “ನೀನು ಯಾಕೋಬನ ಸಂಗಡ ಒಳ್ಳೆಯದನ್ನಾಗಲಿ ಕೆಟ್ಟದ್ದನ್ನಾಗಲಿ ಮಾತನಾಡದಂತೆ ಎಚ್ಚರಿಕೆಯಾಗಿರು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ತರುವಾಯ ಲಾಬಾನನೂ ಯಾಕೋಬನನ್ನು ಸಂಧಿಸಿದಾಗ ಯಾಕೋಬನು ಬೆಟ್ಟದಲ್ಲಿ ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿಕೊಂಡಿದ್ದನು. ಲಾಬಾನನು ಸಹ ತನ್ನವರೊಡನೆ ಅದೇ ಗಿಲ್ಯಾದ್ ಬೆಟ್ಟದಲ್ಲಿ ಗುಡಾರವನ್ನು ಹಾಕಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ಇದೇನು ನೀನು ಮಾಡಿದ್ದು? ನೀನು ನನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಯುದ್ಧದಲ್ಲಿ ಸೆರೆಹಿಡಿದವರಂತೆ ತೆಗೆದುಕೊಂಡು ನನಗೆ ಏನೂ ಹೇಳದೆ ಹೊರಟುಬಂದೆಯಲ್ಲಾ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ಯಾಕೆ ನನ್ನನ್ನು ಮೋಸಗೊಳಿಸಿ ಕಳ್ಳತನದಿಂದ ಹೊರಟು ಬಂದಿ? ನನಗೆ ತಿಳಿಸಿದ್ದರೆ ನಾನು ಸಂತೋಷದಿಂದ ಹಾಡು, ವೀಣೆ, ತಾಳ ಮುಂತಾದ ವಾದ್ಯಗಳೊಡನೆ ನಿನ್ನನ್ನು ಕಳುಹಿಸುತ್ತಿದ್ದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ಆದರೆ ನೀನು ನನ್ನ ಹೆಣ್ಣು ಮಕ್ಕಳಿಗೂ ಮೊಮ್ಮಕ್ಕಳಿಗೂ, ಮುದ್ದಿಡುವುದಕ್ಕಾದರೂ ಆಗದಂತೆ ಮಾಡಿದಿ. ನೀನು ಮಾಡಿದ್ದು ಹುಚ್ಚು ಕೆಲಸ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ನಿಮಗೆ ಕೇಡುಮಾಡುವುದಕ್ಕೆ ನನ್ನಲ್ಲಿ ಸಾಮರ್ಥ್ಯ ಇದೆ. ಆದರೆ ಕಳೆದ ರಾತ್ರಿಯಲ್ಲಿ ನಿಮ್ಮ ತಂದೆಯ ದೇವರು, ‘ಯಾಕೋಬನಿಗೆ ಒಳ್ಳೆಯದನ್ನಾಗಲೀ, ಕೆಟ್ಟದನ್ನಾಗಲಿ ಹೇಳದ ಹಾಗೆ ಎಚ್ಚರವಾಗಿರು’ ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ಆದರೆ ತಂದೆಯ ಮನೆಗೆ ಹೋಗುವುದಕ್ಕೆ ನಿನಗೆ ಬಹಳ ಆಶೆಯಿರುವುದರಿಂದ ಹೋಗಬೇಕಾಯಿತು. ಆದರೆ ನೀನು ನನ್ನ ದೇವರುಗಳನ್ನು ಕದ್ದದ್ದು ಯಾಕೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ಅದಕ್ಕೆ ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ನೀನು ನಿನ್ನ ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ಬಲಾತ್ಕಾರದಿಂದ ಹಿಂದಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳುವಿ ಎಂದು ಭಯಪಟ್ಟು ಹೊರಟು ಬಂದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ನಿನ್ನ ದೇವರುಗಳು ಯಾರ ಬಳಿಯಲ್ಲಿ ಸಿಕ್ಕುತ್ತವೆಯೋ ಅವರು ಸಾಯಲಿ. ನಮ್ಮ ಬಂಧುಗಳ ಮುಂದೆಯೇ ನನ್ನ ಆಸ್ತಿಯನ್ನು ಪರೀಕ್ಷಿಸಬಹುದು. ಅದರಲ್ಲಿ ನಿನ್ನದೇನಾದರೂ ಸಿಕ್ಕಿದರೆ ಅದನ್ನು ತೆಗೆದುಕೋ” ಎಂದು ಹೇಳಿದನು. ರಾಹೇಲಳು ಆ ದೇವರುಗಳನ್ನು ಕದ್ದದ್ದು ಯಾಕೋಬನಿಗೆ ತಿಳಿದಿರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ಲಾಬಾನನು ಯಾಕೋಬನ ಗುಡಾರದಲ್ಲಿಯೂ, ಲೇಯಳ ಗುಡಾರದಲ್ಲಿಯೂ, ಆ ಇಬ್ಬರು ದಾಸಿಯರ ಗುಡಾರದಲ್ಲಿಯೂ ಹುಡುಕಿದನು. ಆದರೂ ಅವನಿಗೇನೂ ಸಿಕ್ಕಲ್ಲಿಲ್ಲ. ಲೇಯಳ ಗುಡಾರವನ್ನು ಬಿಟ್ಟು ರಾಹೇಲಳ ಗುಡಾರಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ರಾಹೇಲಳು ಆ ವಿಗ್ರಹಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಒಂಟೆಯ ಸಬರದೊಳಗಿಟ್ಟು (ತಡಿಯ ಚೀಲದಲ್ಲಿ) ಅವುಗಳ ಮೇಲೆ ಕುಳಿತ್ತಿದ್ದಳು. ಲಾಬಾನನು ಗುಡಾರದಲ್ಲಿದ್ದ ವಸ್ತುಗಳನ್ನೆಲ್ಲಾ ನೋಡಿದರೂ ಅವುಗಳನ್ನು ಕಾಣಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ರಾಹೇಲಳು ತನ್ನ ತಂದೆಗೆ, “ಅಪ್ಪಾ, ನಾನು ನಿನ್ನ ಮುಂದೆ ಎದ್ದು ನಿಂತುಕೊಳ್ಳದೆ ಹೋದರೂ ಕೋಪಿಸಿಕೊಳ್ಳಬೇಡ, ನಾನು ಮೈಲಿಗೆಯಾಗಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದಳು. ಅವನು ಚೆನ್ನಾಗಿ ಹುಡುಕಿದರೂ ಆ ವಿಗ್ರಹಗಳನ್ನು ಕಂಡುಕೊಳ್ಳದೆ ಹೊರಟು ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ಆಗ ಯಾಕೋಬನು ಕೋಪಗೊಂಡು ಲಾಬಾನನನ್ನು ಗದರಿಸಿ, “ನೀನು ಇಷ್ಟು ಆತುರ ಪಟ್ಟು ನನ್ನನ್ನು ಹಿಂದಟ್ಟಿ ಬರುವಂತೆ ನಾನೇನು ದ್ರೋಹ ಮಾಡಿದೆನು? ");
INSERT INTO kanirv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ನನ್ನ ವಸ್ತುಗಳನ್ನೆಲ್ಲಾ ಪರೀಕ್ಷಿಸಿ ನೋಡುವಂತೆ ನಾನೇನು ತಪ್ಪುಮಾಡಿದೆನು? ನಿನ್ನ ಸೊತ್ತು ಏನಾದರೂ ನನ್ನಲ್ಲಿ ಸಿಕ್ಕಿದೆಯೋ? ನನ್ನ ಬಳಗದವರ ಮುಂದೆಯೂ ನಿನ್ನ ಬಂಧುಗಳ ಮುಂದೆಯೂ ಅದನ್ನು ತಂದು ಇಡು. ಇವರೇ ನಮ್ಮಿಬ್ಬರ ನ್ಯಾಯವನ್ನು ತೀರಿಸಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“ನಾನು ಇಪ್ಪತ್ತು ವರ್ಷ ನಿನ್ನ ಸಂಗಡ ಇದ್ದೆನು. ನಿನ್ನ ಹಿಂಡಿನ ಹೆಣ್ಣು ಆಡುಕುರಿಗಳನ್ನು ಕಂದು ಹಾಕಲಿಲ್ಲ. ನಿನ್ನ ಹಿಂಡಿನ ಟಗರುಗಳನ್ನು ನಾನೇನೂ ತಿಂದುಬಿಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ಕಾಡುಮೃಗಗಳಿಂದ ಕೊಲ್ಲಲ್ಪಟ್ಟ ಕುರಿ, ಆಡುಗಳನ್ನು ನಿನ್ನ ಭಾಗಕ್ಕೆ ಹಾಕದೆ ನಾನೇ ನಷ್ಟವನ್ನು ಹೊತ್ತೆನು. ಹಗಲಿನಲ್ಲಿ, ಇರುಳಿನಲ್ಲಿ ಕಳೆದು ಹೋದದ್ದರ ಲೆಕ್ಕವನ್ನು ನನ್ನಿಂದ ತೆಗೆದುಕೊಂಡೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ಹಗಲಿನಲ್ಲಿ ಬಿಸಿಲಿನಿಂದಲೂ, ಇರುಳಲ್ಲಿ ಚಳಿಯಿಂದಲೂ ಬಾಧೆಪಟ್ಟೆನು, ನಿದ್ದೆಮಾಡುವುದಕ್ಕಾದರೂ ಅವಕಾಶ ಸಿಗಲಿಲ್ಲ, ನನ್ನ ಸ್ಥಿತಿ ಹೀಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ಇಪ್ಪತ್ತು ವರ್ಷ ನಿನ್ನ ಮನೆಯಲ್ಲಿದ್ದೆನು. ನಿನ್ನ ಇಬ್ಬರು ಹೆಣ್ಣು ಮಕ್ಕಳಿಗೋಸ್ಕರ ಹದಿನಾಲ್ಕು ವರ್ಷವೂ ನಿನ್ನ ಆಡು ಕುರಿಗಳಿಗೋಸ್ಕರ ಆರು ವರ್ಷವೂ ಸೇವೆಮಾಡಿದೆನು. ಆದರೆ ನೀನು ನನ್ನ ಸಂಬಳವನ್ನು ಹತ್ತು ಸಾರಿ ಬದಲಾಯಿಸಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ನನ್ನ ತಂದೆಯ ದೇವರೂ, ಅಬ್ರಹಾಮನ ದೇವರೂ, ಇಸಾಕನು ಭಯಭಕ್ತಿಯಿಂದ ಸೇವಿಸಿದ ದೇವರು ನನ್ನೊಂದಿಗೆ ಇಲ್ಲದೆ ಹೋಗಿದ್ದರೆ, ನಿಶ್ಚಯವಾಗಿ ನೀನು ನನ್ನನ್ನು ಬರಿಗೈಯಿಂದ ಕಳುಹಿಸಿಬಿಡುತ್ತಿದ್ದೆ, ದೇವರು ನನ್ನ ಕಷ್ಟವನ್ನೂ ನಾನು ಪಟ್ಟ ಪ್ರಯಾಸ ಗೊತ್ತಿದ್ದರಿಂದಲೇ ನಿನ್ನೆಯ ರಾತ್ರಿ ನಿನ್ನನ್ನು ಗದರಿಸಿದನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ಅದಕ್ಕೆ ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ಈ ಪುತ್ರಿಯರು ನನ್ನ ಪುತ್ರಿಯರಲ್ಲವೇ, ಈ ಮಕ್ಕಳು ನನ್ನ ಮೊಮ್ಮಕ್ಕಳಲ್ಲವೇ, ಈ ಹಿಂಡುಗಳೂ ನನ್ನವೇ, ನಿನ್ನ ಕಣ್ಣು ಮುಂದೆ ಇರುವುದೆಲ್ಲವೂ ನನ್ನದೇ. ಹಾಗಾದರೆ ಈ ನನ್ನ ಪುತ್ರಿಯರಿಗೋಸ್ಕರವೂ, ಇವರು ಹೆತ್ತ ಮಕ್ಕಳಿಗೋಸ್ಕರವೂ ಈಗ ನಾನೇನು ಮಾಡಲಿ? ");
INSERT INTO kanirv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ಆದುದರಿಂದ ನಾವಿಬ್ಬರು ಸೇರಿ ಒಂದು ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಳ್ಳೋಣ ಬಾ, ಅದು ನನಗೂ ನಿನಗೂ ಮಧ್ಯದಲ್ಲಿ ಸಾಕ್ಷಿಯಾಗಿರಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ಆಗ ಯಾಕೋಬನು ಒಂದು ಕಲ್ಲನ್ನು ತೆಗೆದುಕೊಂಡು ಸ್ತಂಭವಾಗಿ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ಯಾಕೋಬನು ತನ್ನ ಕಡೆಯವರಿಗೆ, “ಕಲ್ಲುಗಳನ್ನು ಕೂಡಿಸಿರಿ” ಎಂದು ಹೇಳಲು ಅವರು ಕಲ್ಲುಗಳನ್ನು ಕೂಡಿಸಿ ಗುಡ್ಡೆ ಮಾಡಿದರು. ಅವರೆಲ್ಲರೂ ಆ ಗುಡ್ಡೆಯ ಬಳಿಯಲ್ಲಿ ಭೋಜನವನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ಆ ಗುಡ್ಡೆಗೆ ಲಾಬಾನನು “ಯಗರಸಾಹದೂತ” ಎಂದೂ ಯಾಕೋಬನು “ಗಲೇದ್” ಎಂದೂ ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ಆಗ ಲಾಬಾನನು, “ಈ ಹೊತ್ತು ನಿನಗೂ ನನಗೂ ಆದ ಒಡಂಬಡಿಕೆಗೆ ಈ ಗುಡ್ಡೆಯೇ ಸಾಕ್ಷಿ” ಎಂದು ಹೇಳಿದುದರಿಂದ ಅದಕ್ಕೆ ಗಲೇದ್ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ಅದಲ್ಲದೆ ಅವನು, “ನಾವು ಒಬ್ಬರಿಗೊಬ್ಬರು ಅಗಲಿರುವಾಗ ಯೆಹೋವನೇ ನಮ್ಮಿಬ್ಬರನ್ನೂ ನೋಡಿಕೊಳ್ಳುತ್ತಾ ಇರುವನು” ಎಂದು ಹೇಳಿದ್ದರಿಂದ ಅದಕ್ಕೆ ಮಿಚ್ಪಾ ಎಂದು ಹೆಸರಾಯಿತು ");
INSERT INTO kanirv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ಮತ್ತು ಲಾಬಾನನು, “ನೀನು ನನ್ನ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ನೋಯಿಸಿದರೆ ಅಥವಾ ಬೇರೆ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡರೆ ವಿಚಾರಿಸುವವರು ಮನುಷ್ಯರೊಳಗೆ ಯಾರೂ ಇಲ್ಲದಿದ್ದರೂ ದೇವರೇ ನಮ್ಮ ಒಡಂಬಡಿಕೆಗೆ ಸಾಕ್ಷಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ಇದಲ್ಲದೆ ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ನಿನಗೂ ನನಗೂ ನಡುವೆ ನಾನು ನಿಲ್ಲಿಸಿರುವ ಈ ಸ್ತಂಭವನ್ನು ನೋಡು, ಈ ಗುಡ್ಡೆಯನ್ನೂ ನೋಡು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ನಾನು ಕೇಡು ಮಾಡುವುದಕ್ಕೋಸ್ಕರ ಈ ಗುಡ್ಡೆಯನ್ನು, ದಾಟಿ ನಿನ್ನ ಬಳಿಗೆ ಬರುವುದಿಲ್ಲ. ಹಾಗೆಯೇ ನೀನು ಈ ಗುಡ್ಡೆಯನ್ನೂ ಈ ಸ್ತಂಭವನ್ನು ದಾಟಿ ನನ್ನ ಬಳಿಗೆ ಬರಕೂಡದು. ಇದಕ್ಕೆ ಈ ಗುಡ್ಡೆಯೂ ಸ್ತಂಭವೂ ಸಾಕ್ಷಿಯಾಗಿರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ಅಬ್ರಹಾಮನ ದೇವರು, ನಾಹೋರನ ದೇವರು, ಅವರ ತಂದೆಯ ದೇವರು ನಿನಗೂ ನನಗೂ ನ್ಯಾಯತೀರಿಸಲಿ” ಎಂದನು. ಅದೇ ಪ್ರಕಾರ ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನು ಭಯಭಕ್ತಿಯಿಂದ ಆರಾಧಿಸುವ ದೇವರ ಮೇಲೆ ಆಣೆಯಿಟ್ಟು ಪ್ರಮಾಣ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ಯಾಕೋಬನು ಆ ಬೆಟ್ಟದ ಮೇಲೆ ಯಜ್ಞವನ್ನು ಮಾಡಿ ತನ್ನ ಬಂಧುಗಳನ್ನು ತನ್ನೊಡನೆ ಊಟಮಾಡಲು ಕರೆಯಿಸಿದನು. ಅವರು ಊಟ ಮಾಡಿ ಬೆಟ್ಟದಲ್ಲಿಯೇ ರಾತ್ರಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ಮುಂಜಾನೆ ಲಾಬಾನನು ಎದ್ದು ತನ್ನ ಹೆಣ್ಣು ಮಕ್ಕಳಿಗೂ, ಮೊಮ್ಮಕ್ಕಳಿಗೂ ಮುದ್ದಿಟ್ಟು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ ತನ್ನ ಮನೆಗೆ ಹಿಂತಿರುಗಿ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ಯಾಕೋಬನು ಮುಂದೆ ಪ್ರಯಾಣಮಾಡಲು ದೇವದೂತರು ಅವನೆದುರಿಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ಯಾಕೋಬನು ಅವರನ್ನು ನೋಡಿದಾಗ, “ಇದು ದೇವರ ಸೇನಾನಿವೇಶ” ಎಂದು ಹೇಳಿ ಆ ಸ್ಥಳಕ್ಕೆ “ಮಹನಯಿಮ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ಬಳಿಕ ಯಾಕೋಬನು ತನಗಿಂತ ಮೊದಲು ಎದೋಮ್ಯರ ಪ್ರದೇಶವಾಗಿರುವ ಸೇಯೀರ್ ಸೀಮೆಗೆ ತನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನ ಬಳಿಗೆ ಸೇವಕರನ್ನು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ಕಳುಹಿಸುವಾಗ ಅವರಿಗೆ “ನೀವು ನನ್ನ ಪ್ರಭುವಾದ ಏಸಾವನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ, ‘ನಿನ್ನ ಸೇವಕನಾದ ಯಾಕೋಬನು ಇಷ್ಟು ದಿನ ಲಾಬಾನನ ಬಳಿಯಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು ");
INSERT INTO kanirv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ಈಗ ಅವನಿಗೆ ಎತ್ತು, ಕತ್ತೆ ಮುಂತಾದ ಪಶುಗಳ ಹಿಂಡುಗಳೂ ದಾಸದಾಸಿಯರು ಇದ್ದಾರೆ. ಅವನು ತಮ್ಮ ದಯೆ ಆತನ ಮೇಲೆ ಇರಬೇಕೆಂದು ತಿಳಿಸುವುದಕ್ಕೆ ನಿಮ್ಮನ್ನು ಕಳುಹಿಸಿದ್ದಾನೆ’” ಎಂದು ಹೇಳಿರಿ ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ತರುವಾಯ ಆ ಸೇವಕರು ಯಾಕೋಬನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಂದು, “ನಾವು ನಿನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನ ಹತ್ತಿರಕ್ಕೆ ಹೋಗಿ ಬಂದಿದ್ದೇವೆ, ಅವನು ನಾನೂರು ಜನರ ಸಮೇತ ನಿನ್ನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಬರುತ್ತಾನೆ” ಎಂದು ಹೇಳಿದಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ಯಾಕೋಬನಿಗೆ ಬಹು ಭಯವೂ ಕಳವಳವೂ ಉಂಟಾದವು. ಅವನು ತನ್ನೊಂದಿಗಿದ್ದ ಜನರನ್ನು, ಕುರಿದನಗಳನ್ನು ಹಾಗೂ ಒಂಟೆಗಳನ್ನು ಎರಡು ಗುಂಪುಗಳಾಗಿ ವಿಭಾಗಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ಏಕೆಂದರೆ, “ಏಸಾವನು ಒಂದು ಗುಂಪಿನ ಮೇಲೆ ಬಿದ್ದರೂ ಮತ್ತೊಂದು ಗುಂಪು ತಪ್ಪಿಸಿಕೊಂಡು ಹೋಗಬಹುದು” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ಇದಲ್ಲದೆ ಯಾಕೋಬನು ದೇವರನ್ನು ಪ್ರಾರ್ಥಿಸಿ, “ಯೆಹೋವನೇ, ನನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನ ದೇವರೇ, ನನ್ನ ತಂದೆಯಾದ ಇಸಾಕನ ದೇವರೇ, ‘ನಿನ್ನ ಸ್ವದೇಶಕ್ಕೂ, ಬಂಧುಗಳ ಬಳಿಗೂ ತಿರುಗಿ ಹೋಗಬೇಕೆಂದು ನನಗೆ ಆಜ್ಞಾಪಿಸಿ ನಿನಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡುವೆನೆಂದು’ ನನಗೆ ವಾಗ್ದಾನ ಮಾಡಿದ ಯೆಹೋವನೇ, ");
INSERT INTO kanirv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ನೀನು ನಿನ್ನ ದಾಸನಾದ ನನ್ನ ಮೇಲೆ ಎಷ್ಟೋ ನಂಬಿಕೆಯನ್ನಿಟ್ಟು ನಿನ್ನ ವಾಗ್ದಾನವನ್ನು ನೆರವೇರಿಸಿದ್ದೀಯಲ್ಲಾ. ನಾನು ಅದಕ್ಕೆ ಕೇವಲ ಅಯೋಗ್ಯನು. ನಾನು ಮೊದಲು ಈ ಯೊರ್ದನ್ ನದಿಯನ್ನು ದಾಟಿದಾಗ ನನ್ನ ಬಳಿಯಲ್ಲಿ ಒಂದು ಕೋಲು ಮಾತ್ರವೇ ಇತ್ತು. ಈಗ ಎರಡು ಗುಂಪುಗಳಿಗೆ ಒಡೆಯನಾಗಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ನನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನು ಬಂದು ನನ್ನನ್ನೂ, ನನ್ನ ಮಕ್ಕಳನ್ನೂ, ಅವರ ತಾಯಿಯರನ್ನೂ ಕೊಂದುಹಾಕುವನೋ ಎಂದು ನನಗೆ ಭಯವಿದೆ. ಅವನ ಕೈಗೆ ಸಿಕ್ಕದಂತೆ ನಮ್ಮನ್ನು ಕಾಪಾಡಬೇಕೆಂದು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","‘ನಿನಗೆ ಖಂಡಿತವಾಗಿ ಒಳ್ಳೆಯದನ್ನು ಮಾಡಿ, ನಿನ್ನ ಸಂತತಿಯನ್ನು ಸಮುದ್ರದ ಉಸುಬಿನಂತೆ ಅಸಂಖ್ಯವಾಗಿ ಅಭಿವೃದ್ಧಿ ಮಾಡುವೆನೆಂದು ನೀನು ನನಗೆ ಹೇಳಿದ್ದೀಯಲ್ಲಾ?’” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ಯಾಕೋಬನು ಆ ರಾತ್ರಿ ಅಲ್ಲೇ ತಂಗಿದನು. ತಾನು ತಂದದ್ದರಲ್ಲಿ ಕೆಲವನ್ನು ಸಹೋದರನಾದ ಏಸಾವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ಇನ್ನೂರು ಆಡುಕುರಿ, ಇಪ್ಪತ್ತು ಹೋತ, ಇಪ್ಪತ್ತು ಟಗರು, ಮರಿಯೊಡನೆ ಹಾಲು ಕರೆಯುವ ");
INSERT INTO kanirv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ಮೂವತ್ತು ಒಂಟೆ, ನಲ್ವತ್ತು ಆಕಳು, ಹತ್ತು ಹೋರಿ ಇಪ್ಪತ್ತು ಹೆಣ್ಣುಕತ್ತೆ, ಹತ್ತು ಗಂಡುಕತ್ತೆ ಇವುಗಳನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ಇವುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದು ಹಿಂಡನ್ನು ತನ್ನ ಸೇವಕನಿಗೆ ಒಪ್ಪಿಸಿ, “ನೀವು ನನಗಿಂತ ಮುಂಚಿತವಾಗಿ ನದಿಯನ್ನು ದಾಟಿ ಹೋಗಿರಿ ಮತ್ತು ಪ್ರತಿ ಹಿಂಡು ಹಿಂಡಿಗೂ ಮಧ್ಯದಲ್ಲಿ ಅಂತರವಿರಲಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ಮೊದಲನೆಯ ಹಿಂಡಿನ ಮೇಲ್ವಿಚಾರಕನಿಗೆ, “ನನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನು ನಿನ್ನೆದುರಿಗೆ ಬಂದು, ‘ನೀನು ಯಾರ ಸೇವಕನು? ಎಲ್ಲಿಗೆ ಹೋಗುತ್ತೀ? ನಿನ್ನ ಮುಂದೆ ಇರುವ ಇವೆಲ್ಲಾ ಯಾರದು?’” ಎಂದು ಕೇಳಿದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ಆಗ ನೀನು, “ಇವು ನಿಮ್ಮ ಸೇವಕನಾದ ಯಾಕೋಬನದು. ತನ್ನ ಪ್ರಭುಗಳಾದ ನಿಮಗೆ ಇವುಗಳನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕಳುಹಿಸಿಕೊಟ್ಟಿದ್ದಾನೆ. ಅವನೂ ನಮ್ಮ ಹಿಂದೆ ಬರುತ್ತಿದ್ದಾನೆ” ಎಂದು ಉತ್ತರಕೊಡಬೇಕು ಎಂಬುದಾಗಿ ಅಪ್ಪಣೆಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ಹಾಗೆಯೇ ಎರಡನೆಯವನಿಗೂ ಮೂರನೆಯವನಿಗೂ ಹಿಂಡುಗಳ ಹಿಂದೆ ಹೋದವರೆಲ್ಲರಿಗೂ, “ನೀವು ಏಸಾವನನ್ನು ನೋಡುವಾಗ ಇದೇ ರೀತಿಯಾಗಿ ಹೇಳಬೇಕು. ನಿನ್ನ ಸೇವಕನಾದ ಯಾಕೋಬನೇ ನಮ್ಮ ಹಿಂದೆ ಬರುತ್ತಿದ್ದಾನೆ ಎನ್ನಿರಿ” ಎಂದು ಅಪ್ಪಣೆಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ಯಾಕೋಬನು ತನ್ನೊಳಗೆ, “ನನ್ನ ಮುಂದೆ ಹೋಗುವ ಈ ಕಾಣಿಕೆಯಿಂದ ಏಸಾವನನ್ನು ಸಮಾಧಾನಪಡಿಸುವೆನು. ಆಮೇಲೆ ಅವನನ್ನು ಸಂಧಿಸುವಾಗ, ಒಂದು ವೇಳೆ ನನ್ನನ್ನು ಪ್ರೀತಿಯಿಂದ ಸ್ವೀಕರಿಸುವನೇನೋ” ಎಂದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ಹೀಗೆ ಆ ಕಾಣಿಕೆಯು ಅವನ ಮುಂದಾಗಿ ಹೊರಟು ಹೋಯಿತು. ತಾನು ಆ ರಾತ್ರಿ ತನ್ನ ಪಾಳೆಯದಲ್ಲೇ ಉಳಿದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ಆ ರಾತ್ರಿ ಅವನು ತನ್ನ ಇಬ್ಬರು ಹೆಂಡತಿಯರನ್ನು, ಇಬ್ಬರು ದಾಸಿಯರನ್ನು ಹಾಗೂ ಹನ್ನೊಂದು ಮಂದಿ ಮಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ಯಬ್ಬೋಕ್ ಹೊಳೆಯನ್ನು ದಾಟಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ಅವರನ್ನೂ, ತನ್ನ ಆಸ್ತಿಯೆಲ್ಲವನ್ನೂ ದಾಟಿಸಿದ ಮೇಲೆ ");
INSERT INTO kanirv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ಯಾಕೋಬನು ಒಂಟಿಯಾಗಿ ಹಿಂದೆ ನಿಂತಿರಲು ಯಾರೋ ಒಬ್ಬ ಪುರುಷನು ಬೆಳಗಾಗುವ ತನಕ ಅವನ ಸಂಗಡ ಹೋರಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ಆ ಪುರುಷನು ತಾನು ಗೆಲ್ಲದೆ ಇರುವುದನ್ನು ಕಂಡು ಯಾಕೋಬನ ತೊಡೆಯ ಕೀಲನ್ನು ಮುಟ್ಟಿದ್ದರಿಂದ ಯಾಕೋಬನು ಅವನ ಸಂಗಡ ಹೋರಾಡುತ್ತಿರುವಾಗಲೇ ಅವನ ತೊಡೆಯ ಕೀಲು ತಪ್ಪಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ಆ ಪುರುಷನು, “ನನ್ನನ್ನು ಬಿಡು, ಬೆಳಗಾಗುತ್ತಿದೆ” ಎನ್ನಲು, ಯಾಕೋಬನು, “ನೀನು ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸದ ಹೊರತು ನಾನು ನಿನ್ನನ್ನು ಬಿಡುವುದಿಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ಆ ಪುರುಷನು, “ನಿನ್ನ ಹೆಸರೇನು?” ಎಂದು ಕೇಳಿದ್ದಕ್ಕೆ ಅವನು, “ಯಾಕೋಬನು” ಎಂದಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ಅವನು ಯಾಕೋಬನಿಗೆ, “ಇನ್ನು ಮೇಲೆ ನೀನು ಯಾಕೋಬನೆಂದು ಕರೆಯಲ್ಪಡುವುದಿಲ್ಲ; ನೀನು ದೇವರ ಸಂಗಡಲೂ, ಮನುಷ್ಯರ ಸಂಗಡಲೂ ಹೋರಾಡಿ ಗೆದ್ದವನಾದುದರಿಂದ ನಿನಗೆ ‘ಇಸ್ರಾಯೇಲ್’ ಎಂದು ಹೆಸರಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ಯಾಕೋಬನು, “ನೀನು ನಿನ್ನ ಹೆಸರನ್ನು ನನಗೆ ತಿಳಿಸಬೇಕು” ಎಂದು ಅವನನ್ನು ಕೇಳಿಕೊಂಡಾಗ ಆತನು, “ನನ್ನ ಹೆಸರನ್ನು ವಿಚಾರಿಸುವುದೇಕೆ?” ಎಂದು ಹೇಳಿ ಅಲ್ಲಿ ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ಆಗ ಯಾಕೋಬನು, “ನಾನು ದೇವರನ್ನು ಪ್ರತ್ಯಕ್ಷವಾಗಿ ನೋಡಿದೆನಲ್ಲಾ; ಆದರೂ ನನ್ನ ಪ್ರಾಣ ಉಳಿದಿದೆ” ಎಂದು ಹೇಳಿ ಆ ಸ್ಥಳಕ್ಕೆ ಪೆನೀಯೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು, ");
INSERT INTO kanirv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ಅವನು, ಪೆನೂವೇಲನ್ನು ದಾಟುತ್ತಿರುವಾಗ ಸೂರ್ಯೋದಯವಾಯಿತು. ಆದರೆ ಯಾಕೋಬನು ತೊಡೆಯ ನೋವಿನ ನಿಮಿತ್ತ ಕುಂಟುತ್ತಾ ನಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ಆ ಪುರುಷನು ಯಾಕೋಬನ ತೊಡೆಯ ಕೀಲನ್ನು ಮುಟ್ಟಿದ್ದರಿಂದ ಇಸ್ರಾಯೇಲ್ಯರು ಇಂದಿನ ವರೆಗೂ ತೊಡೆಯ ಕೀಲಿನ ಮೇಲಿರುವ ಸೊಂಟದ ಮಾಂಸವನ್ನು ತಿನ್ನುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ಯಾಕೋಬನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ, ಏಸಾವನು ನಾನೂರು ಮಂದಿ ಜನರ ಸಮೇತ ಬರುವುದನ್ನು ಕಂಡನು. ಆಗ ಅವನು ಲೇಯಳಿಗೂ ರಾಹೇಲಳಿಗೂ ಇಬ್ಬರು ದಾಸಿಯರಿಗೂ ಅವರವರ ಮಕ್ಕಳನ್ನು ಒಪ್ಪಿಸಿ ಅವರನ್ನು ಬೇರೆ ಬೇರೆ ಮಾಡಿ ");
INSERT INTO kanirv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ಮುಂದುಗಡೆಯಲ್ಲಿ ದಾಸಿಯರನ್ನೂ ಅವರ ಮಕ್ಕಳನ್ನೂ ಅವರ ಹಿಂದೆ ಲೇಯಳನ್ನೂ ಆಕೆಯ ಮಕ್ಕಳನ್ನೂ ಕಡೆಯಲ್ಲಿ ರಾಹೇಲಳನ್ನೂ ಯೋಸೇಫನನ್ನೂ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ತಾನೇ ಅವರ ಮುಂದಾಗಿ ಹೋಗಿ ತನ್ನ ಅಣ್ಣನು ಹತ್ತಿರ ಸಮೀಪಿಸುತ್ತಿರುವಾಗ ಏಳು ಸಾರಿ ನೆಲದವರೆಗೆ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ಆಗ ಏಸಾವನು ಅವನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಓಡಿ ಬಂದು ಅವನ ಕೊರಳನ್ನು ಅಪ್ಪಿಕೊಂಡು ಮುದ್ದಿಟ್ಟನು. ಅವರಿಬ್ಬರೂ ಅತ್ತರು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ತರುವಾಯ ಏಸಾವನು ಕಣ್ಣೆತ್ತಿ ಆ ಸ್ತ್ರೀಯರನ್ನೂ ಮಕ್ಕಳನ್ನೂ ಕಂಡು, “ನಿನ್ನ ಜೊತೆಯಲ್ಲಿರುವ ಜನರು ಯಾರು?” ಎಂದು ಕೇಳಲು ಯಾಕೋಬನು ಅವನಿಗೆ, “ದೇವರು ನಿನ್ನ ಸೇವಕನಿಗೆ ಕೃಪೆಯಿಂದ ಅನುಗ್ರಹಿಸಿಕೊಟ್ಟ ಮಕ್ಕಳೇ ಇವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ಆಗ ಅವನ ದಾಸಿಯರಿಬ್ಬರೂ ತಮ್ಮ ಮಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ಹತ್ತಿರಕ್ಕೆ ಬಂದು ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ಆ ಮೇಲೆ ಲೇಯಳು ತನ್ನ ಮಕ್ಕಳೊಡನೆ ಬಂದು ಅಡ್ಡಬಿದ್ದಳು. ಕೊನೆಗೆ ಯೋಸೇಫನೂ ರಾಹೇಲಳೂ ಬಂದು ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ಏಸಾವನು, “ನಾನು ದಾರಿಯಲ್ಲಿ ಕಂಡ ಆ ಪಶುಗಳು ಯಾತಕ್ಕೆ?” ಎಂದು ಕೇಳಲು ಯಾಕೋಬನು, “ಸ್ವಾಮಿಯವರ ದಯೆ ನನಗೆ ದೊರಕಬೇಕೆಂದು ನಾನು ತಮಗೆ ಅವುಗಳನ್ನು ಕಳುಹಿಸಿಕೊಟ್ಟೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ಏಸಾವನು ಅದಕ್ಕೆ, “ತಮ್ಮನೇ, ನನಗೆ ಬೇಕಾದಷ್ಟು ಆಸ್ತಿಯುಂಟು, ನಿನ್ನದು ನಿನಗೇ ಇರಲಿ” ಎನ್ನಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ಯಾಕೋಬನು, “ಹಾಗಲ್ಲ, ನಿನಗೆ ನನ್ನ ಮೇಲೆ ದಯೆಯಿದ್ದರೆ, ನಾನು ಸಮರ್ಪಿಸುವ ಕಾಣಿಕೆಯನ್ನು ಅಂಗೀಕರಿಸಬೇಕು. ನಿನ್ನನ್ನು ನೋಡಿದ್ದು ದೇವರನ್ನು ನೋಡಿದ ಹಾಗಾಯಿತು, ನನ್ನನ್ನು ಪ್ರೀತಿಯಿಂದ ಅಂಗೀಕರಿಸಿದ್ದೇ ವಿಶೇಷ ಸಂಗತಿಯಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ದೇವರು ನನಗೆ ಕೃಪೆಯನ್ನು ತೋರಿದ್ದರಿಂದ ನನಗೆ ಸಮೃದ್ಧಿಯುಂಟಾಯಿತು. ಆದಕಾರಣ ನಾನು ಸಮರ್ಪಿಸುವ ಉಡುಗೊರೆಯನ್ನು ನೀನು ದಯವಿಟ್ಟು ಅಂಗೀಕರಿಸಬೇಕು” ಎಂದು ಹೇಳಿ ಏಸಾವನನ್ನು ಬಲವಂತ ಮಾಡಿದ್ದರಿಂದ ಅವನು ಆ ಉಡುಗೊರೆಯನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ತರುವಾಯ ಏಸಾವನು, “ನಾವು ಮುಂದಕ್ಕೆ ಪ್ರಯಾಣವನ್ನು ಬೆಳೆಸೋಣ. ನಾನು ಮುಂದಾಗಿ ಹೋಗುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ಅದಕ್ಕೆ ಯಾಕೋಬನು, “ನನ್ನ ಮಕ್ಕಳು ಎಳೇ ಪ್ರಾಯದವರು ಇದಲ್ಲದೆ ಎಳೆಯ ದನಕುರಿಗಳು ನನ್ನ ಬಳಿಯಲ್ಲಿರುವುದು ಪ್ರಭುವಿಗೆ ತಿಳಿದಿದೆ. ಒಂದು ದಿನ ಹೆಚ್ಚಾಗಿ ಅವುಗಳನ್ನು ನಡಿಸಿದರೆ ಆಡುಕುರಿಗಳ ಹಿಂಡುಗಳೆಲ್ಲವೂ ಸತ್ತು ಹೋದಾವು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ತಾವು ದಯವಿಟ್ಟು ಸೇವಕನಿಗಿಂತಲೂ ಮುಂಚೆ ಹೋಗಬಹುದು ನಾನು ನನ್ನ ಮುಂದಿರುವ ಆಡುಕುರಿಗಳ ನಡಿಗೆಗೂ ಮಕ್ಕಳ ಶಕ್ತಿಗೂ ಸರಿಯಾಗಿ ಮೆಲ್ಲಮೆಲ್ಲನೆ ನಡೆದು ನನ್ನ ಪ್ರಭುವಿನ ಸೀಮೆಯಾಗಿರುವ ಸೇಯೀರಿಗೆ ಬರುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ಏಸಾವನು, “ನನ್ನ ಆಳುಗಳಲ್ಲಿ ಕೆಲವರನ್ನು ನಿನ್ನ ಸಂಗಡ ಬಿಟ್ಟು ಹೋಗುತ್ತೇನೆ” ಎನ್ನಲು ಯಾಕೋಬನು, “ಅದರ ಅಗತ್ಯವೇನು? ಒಡೆಯನೇ, ತಮ್ಮ ದಯೆ ನನ್ನ ಮೇಲಿದ್ದರೆ ಸಾಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ಹೀಗೆ ಏಸಾವನು ಆ ದಿನವೇ ಸೇಯೀರ್ ಸೀಮೆಗೆ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ಯಾಕೋಬನು ಪ್ರಯಾಣಮಾಡಿ ಸುಕ್ಕೋತಿಗೆ ಬಂದನು. ಅಲ್ಲಿ ತನಗೋಸ್ಕರ ಮನೆಯನ್ನೂ ದನಗಳಿಗೆ ಆಶ್ರಯವನ್ನೂ ಮಾಡಿಸಿದನು. ಆದುದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ “ಸುಕ್ಕೋತ್” ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ಯಾಕೋಬನು ಪದ್ದನ್ ಅರಾಮಿನಿಂದ ಬಂದು, ಕಾನಾನ್ ದೇಶದ ಶೆಕೆಮ್ ಪಟ್ಟಣವನ್ನು ಸುರಕ್ಷಿತವಾಗಿ ಸೇರಿದನು. ಆ ಊರಿನ ಬಳಿಯಲ್ಲಿ ತನ್ನ ಗುಡಾರಗಳನ್ನು ಹಾಕಿಸಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ಅವನು ತನ್ನ ಗುಡಾರಗಳನ್ನು ಹಾಕಿಸಿದ ಭೂಮಿಯನ್ನು ಹಮೋರನ ಮಕ್ಕಳಿಗೆ ನೂರು ನಾಣ್ಯ ಕೊಟ್ಟು ಅವರಿಂದ ಕೊಂಡುಕೊಂಡನು. ಹಮೋರನು ಶೆಕೆಮನ ತಂದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ಅಲ್ಲಿ ಯಾಕೋಬನು ಯೆಹೋವನ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸಿ ಅದಕ್ಕೆ “ಏಲ್ ಎಲೋಹೆ ಇಸ್ರಾಯೇಲ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ಯಾಕೋಬನಿಗೆ ಲೇಯಳಲ್ಲಿ ಹುಟ್ಟಿದ ಮಗಳಾದ ದೀನಳು ಒಂದು ದಿನ ಆ ದೇಶದ ಸ್ತ್ರೀಯರನ್ನು ನೋಡುವುದಕ್ಕೆ ಹೊರಗೆ ಬಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ದೇಶಾಧಿಪತಿಯಾಗಿರುವ ಹಿವ್ವಿಯನಾದ ಹಮೋರನ ಮಗ ಶೆಕೆಮನು ಆಕೆಯನ್ನು ನೋಡಿ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಮಾನಭಂಗಪಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ಅವನ ಮನಸ್ಸು ಯಾಕೋಬನ ಮಗಳಾದ ದೀನಳ ಮೇಲೆಯೇ ಇತ್ತು. ಆ ಹುಡುಗಿಯನ್ನು ಪ್ರೀತಿಸಿ ಆಕೆಯ ಸಂಗಡ ಮನವೊಲಿಸುವ ಮಾತುಗಳನ್ನಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ಶೆಕೆಮನು ತನ್ನ ತಂದೆಯಾದ ಹಮೋರನಿಗೆ, “ನೀನು ಈ ಹುಡುಗಿಯನ್ನು ನನಗೆ ಮದುವೆಮಾಡಿಸಬೇಕು” ಎಂದು ಕೇಳಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ಯಾಕೋಬನು ತನ್ನ ಮಗಳಾದ ದೀನಳಿಗೆ ಶೆಕೆಮನಿಂದ ಮಾನಭಂಗವಾದ ವರ್ತಮಾನವನ್ನು ಕೇಳಿದಾಗ ಅವನ ಗಂಡುಮಕ್ಕಳು ಅಡವಿಯಲ್ಲಿ ದನಗಳನ್ನು ಕಾಯುತ್ತಿದ್ದರು. ಅವರು ಬರುವ ತನಕ ಅವನು ಸುಮ್ಮನೇ ಇದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ಅಷ್ಟರಲ್ಲಿ ಶೆಕೆಮನ ತಂದೆಯಾದ ಹಮೋರನು ಯಾಕೋಬನ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ಯಾಕೋಬನ ಗಂಡುಮಕ್ಕಳು ತಂಗಿಯ ಸಂಗತಿಯನ್ನು ಕೇಳಿ ಅಡವಿಯಿಂದ ಬಂದಾಗ ವ್ಯಸನಪಟ್ಟು ಬಹಳ ಕೋಪಗೊಂಡರು. ಶೆಕೆಮನು ಯಾಕೋಬನ ಮಗಳ ಮಾನಭಂಗ ಮಾಡಿ ಇಸ್ರಾಯೇಲರೊಳಗೆ ಬಹಳ ಅವಮಾನಕರವಾದ ಕೆಲಸವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ಹಮೋರನು ಅವರಿಗೆ, “ನನ್ನ ಮಗನಾದ ಶೆಕೆಮನು ನಿಮ್ಮ ಹುಡುಗಿಯನ್ನು ಬಹಳ ಆಶೆಯಿಂದ ಮೋಹಿಸಿದ್ದಾನೆ, ಆಕೆಯನ್ನು ಅವನಿಗೆ ಮದುವೆ ಮಾಡಿಕೊಡಬೇಕು ಎಂದು ನಿಮ್ಮನ್ನು ಕೇಳಿಕೊಳ್ಳುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ಇದಲ್ಲದೆ ನೀವು ನಮ್ಮಲ್ಲೇ ವಾಸವಾಗಿದ್ದು ನಿಮ್ಮ ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನು ನಮಗೆ ಕೊಡುತ್ತಾ ನಮ್ಮ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ನೀವು ತೆಗೆದುಕೊಳ್ಳುತ್ತಾ ನಮ್ಮೊಂದಿಗೆ ಬೀಗರಾಗಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ದೇಶವೆಲ್ಲಾ ನಿಮ್ಮ ಮುಂದೆ ಇದೆ ಅಲ್ಲಿ ವಾಸಮಾಡಿಕೊಂಡು ವ್ಯಾಪಾರ ಮಾಡಿ, ಆಸ್ತಿಯನ್ನು ಸಂಪಾದಿಸಿಕೊಳ್ಳಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ಬಳಿಕ ಶೆಕೆಮನು ಆ ಹುಡುಗಿಯ ತಂದೆಗೂ ಅಣ್ಣಂದಿರಿಗೂ, “ನಿಮ್ಮ ದಯೆ ನನ್ನ ಮೇಲೆ ಇರಲಿ, ನೀವು ಹೇಳುವಷ್ಟು ಕೊಡುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ನೀವು ಹೇಳುವ ಮೇರೆಗೆ ಎಷ್ಟಾದರೂ ತೆರವನ್ನೂ ಕಾಣಿಕೆಯನ್ನೂ ಹೆಣ್ಣಿಗಾಗಿ ಕೊಡುತ್ತೇನೆ. ಆದರೆ ಆ ಹುಡುಗಿಯನ್ನು ನನಗೆ ಹೆಂಡತಿಯಾಗಿ ಕೊಡಿರಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ಶೆಕೆಮನು ತಮ್ಮ ತಂಗಿಯಾದ ದೀನಳನ್ನು ಮಾನಭಂಗ ಮಾಡಿದ್ದರಿಂದ ಯಾಕೋಬನ ಮಕ್ಕಳು ಅವನಿಗೂ ಅವನ ತಂದೆಯಾದ ಹಮೋರನಿಗೂ ವಂಚನೆಯ ಉತ್ತರಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ಯಾಕೋಬನ ಮಕ್ಕಳು ಅವರಿಗೆ, “ನಾವು ಈ ಕಾರ್ಯವನ್ನು ಮಾಡಲಾರೆವು. ಸುನ್ನತಿಯಿಲ್ಲದವನಿಗೆ ನಮ್ಮ ತಂಗಿಯನ್ನು ಕೊಡುವುದಕ್ಕಾಗುವುದಿಲ್ಲ, ಹಾಗೆ ಕೊಡುವುದು ನಮಗೆ ಅವಮಾನ. ");
INSERT INTO kanirv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ನಿಮ್ಮಲ್ಲಿನ ಪುರುಷರೆಲ್ಲರೂ ಸುನ್ನತಿಮಾಡಿಸಿಕೊಂಡು ನಮ್ಮ ಹಾಗೆ ಆಗಬೇಕು. ಹೀಗಾಗುವ ಪಕ್ಷದಲ್ಲಿ ಮಾತ್ರ ನಾವು ನಿಮ್ಮ ಮಾತಿಗೆ ಒಪ್ಪುವೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ನಮ್ಮ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ನಿಮಗೆ ಕೊಡುತ್ತಾ ನಿಮ್ಮ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ನಾವು ತೆಗೆದುಕೊಳ್ಳುತ್ತಾ ನಿಮ್ಮಲ್ಲಿ ವಾಸಮಾಡಿ ನಿಮ್ಮೊಂದಿಗೆ ಒಂದೇ ಕುಲವಾಗಿರುವೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ಆದರೆ ನೀವು ನಮ್ಮ ಮಾತಿಗೆ ಒಪ್ಪದೆ ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳದೆ ಹೋದರೆ ನಾವು ನಮ್ಮ ಹುಡುಗಿಯನ್ನು ಕರೆದುಕೊಂಡು ಹೊರಟು ಹೋಗುತ್ತೇವೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ಅವರ ಮಾತುಗಳು ಹಮೋರನಿಗೂ, ಅವನ ಮಗನಾದ ಶೆಕೆಮನಿಗೂ ಒಳ್ಳೆಯದೆಂದು ತೋಚಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ಆ ಯೌವನಸ್ಥನು ಯಾಕೋಬನ ಮಗಳನ್ನು ಮೆಚ್ಚಿಕೊಂಡಿದ್ದರಿಂದ ಅವರು ಹೇಳಿದಂತೆ ಮಾಡುವುದಕ್ಕೆ ತಡಮಾಡಲಿಲ್ಲ. ಅವನು ತನ್ನ ತಂದೆಯ ಮನೆಯವರೆಲ್ಲರಿಗಿಂತ ಗೌರವವುಳ್ಳವನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ಆಗ ಹಮೋರನೂ ಅವನ ಮಗನಾದ ಶೆಕೆಮನೂ ಊರ ಬಾಗಿಲಿಗೆ ಬಂದು ಊರಿನವರೆಲ್ಲರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ಈ ಜನರು ನಮ್ಮ ಸಂಗಡ ಸಮಾಧಾನವಾಗಿದ್ದಾರೆ, ಆದ್ದರಿಂದ ಅವರು ನಮ್ಮ ದೇಶದಲ್ಲೇ ವಾಸ ಮಾಡಿಕೊಂಡು ವ್ಯಾಪಾರ ಮಾಡಲಿ. ಈ ದೇಶವು ಅವರಿಗೂ ನಮಗೂ ಸಾಕಾಗುವಷ್ಟು ವಿಸ್ತಾರವಾಗಿದೆ. ನಾವು ಅವರ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಮದುವೆಮಾಡಿಕೊಳ್ಳೋಣ ನಮ್ಮ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಅವರಿಗೆ ಕೊಡೋಣ. ");
INSERT INTO kanirv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","“ಆದರೆ ಅವರು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡವರಾದ್ದರಿಂದ ನಮ್ಮಲ್ಲಿಯೂ ಪುರುಷರೆಲ್ಲರು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳಬೇಕನ್ನುತ್ತಾರೆ. ಹೀಗಾದರೆ ಮಾತ್ರ ಅವರು ನಮ್ಮಲ್ಲಿ ವಾಸ ಮಾಡುವುದಕ್ಕೂ ನಮ್ಮ ಸಂಗಡ ಒಂದೇ ಕುಲವಾಗುವುದಕ್ಕೂ ಒಪ್ಪುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ಅವರ ಕುರಿದನಗಳೂ, ಅವರ ಆಸ್ತಿಯೂ ಅವರ ಎಲ್ಲಾ ಪಶುಪ್ರಾಣಿಗಳೂ ನಮ್ಮದಾಗುವುದಲ್ಲವೇ? ಆದುದರಿಂದ ಅವರು ನಮ್ಮಲ್ಲಿ ವಾಸಮಾಡುವ ಹಾಗೆ ನಾವು ಅವರ ಮಾತಿಗೆ ಒಪ್ಪಿಕೊಳ್ಳೋಣ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ಆಗ ಪಟ್ಟಣದ ದ್ವಾರದಲ್ಲಿ ಹೋಗುವವರೆಲ್ಲಾ, ಹಮೋರನ ಮಗನಾದ ಶೆಕೆಮನೂ ಹೇಳಿದ ಮಾತಿಗೆ ಊರಿನವರೆಲ್ಲರೂ ಸಮ್ಮತಿಸಿದ್ದರಿಂದ ಅವರಲ್ಲಿದ್ದ ಪುರುಷರೆಲ್ಲರೂ ಸುನ್ನತಿಮಾಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಅವರು ಗಾಯದಿಂದ ಬಹು ಬಾಧೆಪಡುತ್ತಿರುವಾಗ ಯಾಕೋಬನ ಮಕ್ಕಳೂ, ದೀನಳ ಅಣ್ಣಂದಿರಾದ ಸಿಮೆಯೋನ್, ಲೇವಿ ಎಂಬ ಇಬ್ಬರು ಕೈಯಲ್ಲಿ ಕತ್ತಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಧೈರ್ಯವಾಗಿ ಪಟ್ಟಣಕ್ಕೆ ಬಂದು ಗಂಡಸರನ್ನೆಲ್ಲಾ ಕೊಂದು ಹಾಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ಊರಿನವರ ಮೇಲೆ ಬಿದ್ದು ಹಮೋರ ಮತ್ತು ಅವನ ಮಗನಾದ ಶೆಕೆಮ್ ಸಹಿತವಾಗಿ ಪುರುಷರೆಲ್ಲರನ್ನೂ ದಾಕ್ಷಿಣ್ಯವಿಲ್ಲದೆ ಕತ್ತಿಯಿಂದ ಕೊಂದು ಶೆಕೆಮನ ಮನೆಯಿಂದ ದೀನಳನ್ನು ಕರೆದುಕೊಂಡು ಹೊರಟುಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ಅವರು ಹತವಾದ ನಂತರ ಯಾಕೋಬನ ಮಕ್ಕಳು ಬಂದು, ಇವರು ನಮ್ಮ ತಂಗಿಯನ್ನು ಮಾನಭಂಗಪಡಿಸಿದ್ದಾರೆ ಎಂದು ಹೇಳಿ ಊರನ್ನು ಸೂರೆಮಾಡಿಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ಅವರ ಕುರಿಗಳನ್ನು, ದನಗಳನ್ನು ಹಾಗೂ ಕತ್ತೆಗಳನ್ನು ಊರಿನಲ್ಲಿಯೂ ಅಡವಿಯಲ್ಲಿಯೂ ಇದ್ದ ಅವರ ಆಸ್ತಿಯೆಲ್ಲವನ್ನೂ ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ಅವರ ಮಕ್ಕಳನ್ನೂ ಹೆಂಡತಿಯರನ್ನೂ ಸೆರೆಹಿಡಿದು ಮನೆಯಲ್ಲಿದ್ದುದ್ದೆಲ್ಲವನ್ನು ಕೊಳ್ಳೆ ಹೊಡೆದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ಆಗ ಯಾಕೋಬನು ಸಿಮೆಯೋನನಿಗೂ ಲೇವಿಗೂ, “ನೀವು ಈ ದೇಶದ ನಿವಾಸಿಗಳಾದ ಕಾನಾನ್ಯರಲ್ಲಿಯೂ ಪೆರಿಜೀಯರಲ್ಲಿಯೂ ನನ್ನ ಹೆಸರನ್ನು ಕೆಡಿಸಿದ್ದರಿಂದ ನನ್ನನ್ನು ಅಪಾಯಕ್ಕೆ ಗುರಿಮಾಡಿದ್ದೀರಿ. ನನಗಿರುವ ಜನರು ಸ್ವಲ್ಪವೇ. ಈ ದೇಶದವರು ಒಟ್ಟಾಗಿ ನನ್ನ ವಿರುದ್ಧ ಯುದ್ಧಕ್ಕೆ ಬಂದು ನನ್ನನ್ನು ಹೊಡೆದರೆ ನಾನೂ ನನ್ನ ಮನೆಯವರೆಲ್ಲರೂ ನಾಶವಾಗುವೆವು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ಅದಕ್ಕೆ ಅವರು, “ನಮ್ಮ ತಂಗಿಯನ್ನು ವೇಶ್ಯೆಯಂತೆ ಉಪಯೋಗಿಸಿಕೊಂಡಿದ್ದು ಸರಿಯೇ” ಎಂದು ಕೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ದೇವರು ಯಾಕೋಬನಿಗೆ, “ನೀನು ಈ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಗಟ್ಟಾ ಹತ್ತಿ ಬೇತೇಲಿಗೆ ಹೋಗಿ ಅಲ್ಲಿ ವಾಸಮಾಡು. ನೀನು ನಿನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನ ಬಳಿಯಿಂದ ಓಡಿ ಹೋದ ಕಾಲದಲ್ಲಿ ದೇವರು ಅಲ್ಲಿ ನಿನಗೆ ದರ್ಶನಕೊಟ್ಟನಲ್ಲಾ, ಆತನಿಗಾಗಿ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ಆಗ ಯಾಕೋಬನು ತನ್ನ ಮನೆಯವರಿಗೂ ತನ್ನ ಸಂಗಡ ಇದ್ದವರೆಲ್ಲರಿಗೂ “ನಿಮ್ಮ ಮಧ್ಯಲ್ಲಿರುವ ಅನ್ಯ ದೇವರುಗಳನ್ನು ತೆಗೆದುಹಾಕಿ ನಿಮ್ಮನ್ನು ಶುದ್ಧಪಡಿಸಿಕೊಂಡು, ವಸ್ತ್ರಗಳನ್ನು ಬದಲಾಯಿಸಿರಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ನಾವು ಇಲ್ಲಿಂದ ಬೇತೇಲಿಗೆ ಹೋಗೋಣ. ಕಷ್ಟಕಾಲದಲ್ಲಿ ನನ್ನ ವಿಜ್ಞಾಪನೆಯನ್ನು ಲಾಲಿಸಿ ನಾನು ಹೋದ ಮಾರ್ಗದಲ್ಲೆಲ್ಲಾ ನನ್ನ ಸಂಗಡ ಇದ್ದ ದೇವರಿಗೆ ಅಲ್ಲಿ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ಆಗ ಅವರು ತಮ್ಮಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಅನ್ಯ ದೇವರುಗಳನ್ನು, ತಮ್ಮ ಕಿವಿಯಲ್ಲಿದ್ದ ಓಲೆಗಳನ್ನು ಯಾಕೋಬನಿಗೆ ಕೊಟ್ಟರು. ಅವನು ಅವುಗಳನ್ನು ಶೆಕೆಮ್ ಪಟ್ಟಣದ ಹತ್ತಿರವಿರುವ ಏಲಾ ಮರದ ಕೆಳಗೆ ಹೂಣಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ಆಮೇಲೆ ಅವರು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿರುವಾಗ, ಸುತ್ತಲಿರುವ ಊರುಗಳಲ್ಲಿ ದೇವರ ಭಯವು ಇದ್ದುದರಿಂದ ಅವರು ಯಾಕೋಬನ ಮಕ್ಕಳನ್ನು ಬೆನ್ನಟ್ಟಿ ಬರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ಹೀಗೆ ಯಾಕೋಬನೂ ಅವನ ಸಂಗಡ ಇದ್ದ ಜನರೆಲ್ಲರೂ ಕಾನಾನ್ ದೇಶದಲ್ಲಿರುವ ಬೇತೇಲ್ ಎಂಬ ಲೂಜಿಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ಅವನು ತನ್ನ ಅಣ್ಣನ ಬಳಿಯಿಂದ ಓಡಿಹೋದಾಗ ದೇವರು ಅವನಿಗೆ ಪ್ರತ್ಯಕ್ಷನಾದನು. ಅದುದರಿಂದ ಅವನು ಅಲ್ಲಿ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸಿ ಆ ಸ್ಥಳಕ್ಕೆ ಏಲ್ ಬೇತೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ಅಲ್ಲಿ ರೆಬೆಕ್ಕಳ ದಾಸಿಯಾದ ದೆಬೋರಳು ಸತ್ತು ಹೋದಾಗ, ಅವರು ಆಕೆಯನ್ನು ಬೇತೇಲಿನ ತಗ್ಗಿನಲ್ಲಿರುವ ಅಲ್ಲೋನ್ ಮರದ ಬುಡದಲ್ಲಿ ಸಮಾಧಿಮಾಡಿದರು. ಆ ಸ್ಥಳಕ್ಕೆ ಅಲ್ಲೋನ್ ಬಾಕೂತ್ ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ಯಾಕೋಬನು ಪದ್ದನ್ ಅರಾಮಿನಿಂದ ಬಂದಾಗ ದೇವರು ಪುನಃ ಅವನಿಗೆ ದರ್ಶನ ಕೊಟ್ಟು ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ದೇವರು ಅವನಿಗೆ, “ಈಗ ನಿನಗೆ ಯಾಕೋಬನೆಂದು ಹೆಸರಿರುವುದು. ಇನ್ನು ಮೇಲೆ ನೀನು ಯಾಕೋಬನೆಂದು ಕರೆಯಿಸಿಕೊಳ್ಳದೆ ‘ಇಸ್ರಾಯೇಲ್’ ಎಂದು ಕರೆಯಿಸಿಕೊಳ್ಳುವೆ” ಎಂದು ಹೇಳಿ ಅವನಿಗೆ ಇಸ್ರಾಯೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ದೇವರು ಅವನಿಗೆ, “ನಾನೇ ಸರ್ವಶಕ್ತನಾದ ದೇವರು, ನೀನು ಬಹು ಸಂತಾನವುಳ್ಳವನಾಗಿ ಹೆಚ್ಚುವೆ, ನಿನ್ನಿಂದ ಜನಾಂಗವೂ, ಜನಾಂಗಗಳ ಗುಂಪು ಉಂಟಾಗುವುದು. ಅನೇಕ ಜನಾಂಗಗಳ ಅರಸರು ನಿನ್ನಿಂದ ಹುಟ್ಟುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ನಾನು ಅಬ್ರಹಾಮ ಮತ್ತು ಇಸಾಕರಿಗೆ ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶವನ್ನು ನಿನಗೂ ನಿನ್ನ ತರುವಾಯ ಬರುವ ನಿನ್ನ ಸಂತತಿಯವರಿಗೂ ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ಅನಂತರ ದೇವರು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿದ ಸ್ಥಳದಿಂದ ಮೇಲಕ್ಕೇರಿ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ಯಾಕೋಬನು ತನ್ನ ಸಂಗಡ ದೇವರು ಮಾತನಾಡಿದ ಸ್ಥಳದಲ್ಲಿ ಕಲ್ಲಿನ ಸ್ತಂಭವನ್ನು ನಿಲ್ಲಿಸಿ ಅದರ ಮೇಲೆ ಪಾನಕಾಭಿಷೇಕಮಾಡಿ ಎಣ್ಣೆಯನ್ನು ಹೊಯ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ಯಾಕೋಬನು ತನ್ನ ಸಂಗಡ ದೇವರು ಮಾತನಾಡಿದ ಸ್ಥಳಕ್ಕೆ “ಬೇತೇಲ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ಅವರು ಬೇತೇಲಿನಿಂದ ಪ್ರಯಾಣಮಾಡುತ್ತಿರಲು ಎಫ್ರಾತಿಗೆ ಸೇರುವುದಕ್ಕೆ ಇನ್ನೂ ಸ್ವಲ್ಪ ದೂರವಿದ್ದಾಗ ರಾಹೇಲಳು ಪ್ರಸವ ವೇದನೆಯಿಂದ ನರಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ಆಕೆಯು ಹೆರಿಗೆಯ ನೋವಿನಿಂದ ಬಹು ಕಷ್ಟಪಡುತ್ತಿರುವಾಗ ಸೂಲಗಿತ್ತಿಯು ಆಕೆಗೆ, “ಅಂಜಬೇಡ ಇನ್ನೊಂದು ಗಂಡು ಮಗುವು ಹುಟ್ಟುವುದು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ಆದರೆ ರಾಹೇಲಳು ಸತ್ತುಹೋದಳು. ಪ್ರಾಣಬಿಡುವಾಗ ಆಕೆಯು ಆ ಮಗುವಿಗೆ, “ಬೆನೋನಿ” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಆದರೆ ಅದರ ತಂದೆಯು ಅದಕ್ಕೆ, “ಬೆನ್ಯಾಮೀನ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ರಾಹೇಲಳು ಸತ್ತ ಮೇಲೆ, ಬೇತ್ಲೆಹೇಮ್ ಎಂಬ ಎಫ್ರಾತಿಗೆ ಹೋಗುವ ದಾರಿಯಲ್ಲಿ ಆಕೆಯನ್ನು ಸಮಾಧಿಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ಯಾಕೋಬನು ಆಕೆಯ ಸಮಾಧಿಯ ಮೇಲೆ ಸ್ತಂಭವನ್ನು ನಿಲ್ಲಿಸಿದನು. ಅದು ಇಂದಿನವರೆಗೂ “ರಾಹೇಲಳ ಸಮಾಧಿಯ ಸ್ತಂಭ” ಎಂದೇ ಎನಿಸಿಕೊಂಡಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ಅಲ್ಲಿಂದ ಇಸ್ರಾಯೇಲನು ಪ್ರಯಾಣ ಮಾಡಿ ಮಿಗ್ದಲ್ ಏದರಿನ ಆಚೆಯಲ್ಲಿ ತನ್ನ ಗುಡಾರವನ್ನು ಹಾಕಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ಇಸ್ರಾಯೇಲನು ಆ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾಗ ರೂಬೇನನು ತನ್ನ ತಂದೆಯ ಉಪಪತ್ನಿಯಾದ ಬಿಲ್ಹಳನ್ನು ಸಂಗಮಿಸಿದನು. ಈ ಸಂಗತಿಯು ಇಸ್ರಾಯೇಲನಿಗೆ ತಿಳಿಯಿತು. ಯಾಕೋಬನಿಗೆ ಹನ್ನೆರಡು ಮಂದಿ ಗಂಡು ಮಕ್ಕಳಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ಯಾಕೋಬನಿಗೆ ಲೇಯಳಲ್ಲಿ ಹುಟ್ಟಿದವರು ಯಾರೆಂದರೆ: ಯಾಕೋಬನ ಚೊಚ್ಚಲ ಮಗನಾದ ರೂಬೇನ್ ಮತ್ತು ಸಿಮೆಯೋನ್, ಲೇವಿ, ಯೆಹೂದ, ಇಸ್ಸಾಕಾರ್, ಜೆಬುಲೂನ್. ");
INSERT INTO kanirv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ರಾಹೇಲಳಲ್ಲಿ ಹುಟ್ಟಿದವರು: ಯೋಸೇಫನು ಮತ್ತು ಬೆನ್ಯಾಮೀನನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ರಾಹೇಲಳ ದಾಸಿಯಾದ ಬಿಲ್ಹಳಲ್ಲಿ ಹುಟ್ಟಿದವರು: ದಾನ್, ನಫ್ತಾಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ಲೇಯಳ ದಾಸಿಯಾದ ಜಿಲ್ಪಳಲ್ಲಿ ಹುಟ್ಟಿದವರು: ಗಾದ್, ಆಶೇರ್. ಪದ್ದನ್ ಅರಾಮಿನಲ್ಲಿ ಯಾಕೋಬನಿಗೆ ಹುಟ್ಟಿದ ಮಕ್ಕಳು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನ ಬಳಿಗೆ ಮಮ್ರೆಗೆ ಬಂದನು. ಮಮ್ರೆಯು ಹೆಬ್ರೋನೆಂಬ ಕಿರ್ಯತರ್ಬಕ್ಕೆ ಸೇರಿರುವುದು. ಅದು ಅಬ್ರಹಾಮ ಇಸಾಕರು ಪರದೇಶಸ್ಥರಾಗಿ ವಾಸವಾಗಿದ್ದ ಸ್ಥಳ. ");
INSERT INTO kanirv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ಇಸಾಕನು ದಿನತುಂಬಿದ ಮುದುಕನಾಗಿದ್ದು ನೂರ ಎಂಭತ್ತನೆಯ ವರ್ಷದಲ್ಲಿ ಪ್ರಾಣಬಿಟ್ಟು ತನ್ನ ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ಇಸಾಕನ ಮಕ್ಕಳಾದ ಏಸಾವ, ಯಾಕೋಬರು ಅವನನ್ನು ಸಮಾಧಿಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ಎದೋಮ್ ಎಂಬ ಏಸಾವನ ವಂಶಾವಳಿ ಇದು: ");
INSERT INTO kanirv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ಏಸಾವನು ಕಾನಾನ್ಯರ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆಮಾಡಿಕೊಂಡನು. ಅವರು ಯಾರೆಂದರೆ, ಹಿತ್ತಿಯನಾದ ಏಲೋನನ ಮಗಳಾಗಿದ್ದ ಆದಾ, ಹಿವ್ವಿಯನಾದ ಸಿಬಿಯೋನನ ಮಗಳಾದ ಅನಾಹಳ ಮಗಳು ಒಹೊಲೀಬಾಮಳನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ಮತ್ತು ಇಷ್ಮಾಯೇಲನ ಮಗಳೂ ನೆಬಾಯೋತನ ತಂಗಿಯೂ ಆಗಿದ್ದ ಬಾಸೆಮತ್ ಇವರನ್ನು ಮದುವೆಯಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ಆದಾಳು ಏಸಾವನಿಗೆ ಎಲೀಫಜನನ್ನು ಹೆತ್ತಳು. ಬಾಸೆಮತಳು ರೆಗೂವೇಲನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ಒಹೊಲೀಬಾಮಳು ಯೆಗೂಷನನ್ನು ಯಳಾಮನನ್ನೂ, ಕೋರಹನನ್ನು ಹೆತ್ತಳು. ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಏಸಾವನಿಗೆ ಹುಟ್ಟಿದ ಮಕ್ಕಳು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ತರುವಾಯ ಏಸಾವನು ತನ್ನ ಹೆಂಡತಿಯರನ್ನೂ, ಗಂಡುಹೆಣ್ಣು ಮಕ್ಕಳನ್ನೂ, ತನ್ನ ಮನೆಗೆ ಸೇರಿದ ಸೇವಕರೆಲ್ಲರನ್ನೂ, ತನಗಿದ್ದ ಎಲ್ಲಾ ಪಶುಪ್ರಾಣಿಗಳ ಹಿಂಡುಗಳನ್ನೂ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಸಂಪಾದಿಸಿದ್ದ ಆಸ್ತಿಯೆಲ್ಲವನ್ನೂ ತೆಗೆದುಕೊಂಡು ತನ್ನ ತಮ್ಮನಾದ ಯಾಕೋಬನ ಬಳಿಯಿಂದ ಬೇರೆ ದೇಶಕ್ಕೆ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ಅವರ ಸಂಪತ್ತು ಹೆಚ್ಚಿದ್ದದರಿಂದ ಅವರಿಬ್ಬರೂ ಒಂದೇ ಸ್ಥಳದಲ್ಲಿರುವುದಕ್ಕೆ ಸಾಧ್ಯವಿರಲಿಲ್ಲ. ಅವರಿಗೆ ಪಶುಪ್ರಾಣಿಗಳು ಬಹಳವಾಗಿದ್ದುದರಿಂದ ಅವರು ಪ್ರವಾಸವಾಗಿದ್ದ ದೇಶವು ಅವರಿಗೆ ಸಾಲದೆ ಹೋಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ಹೀಗೆ ಏಸಾವನು ಸೇಯೀರ್ ಬೆಟ್ಟದ ಸೀಮೆಗೆ ಹೋಗಿ ಅಲ್ಲೇ ವಾಸವಾಗಿದ್ದನು. ಏಸಾವನೆಂದರೆ ಎದೋಮನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ಸೇಯೀರ್ ಬೆಟ್ಟದ ಸೀಮೆಯಲ್ಲಿದ್ದ ಎದೋಮ್ಯರ ಮೂಲಪುರುಷನಾದ ಏಸಾವನ ವಂಶದ ಚರಿತ್ರೆ: ");
INSERT INTO kanirv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ಏಸಾವನ ಮಕ್ಕಳ ಹೆಸರುಗಳು ಯಾವುವೆಂದರೆ: ಎಲೀಫಜನು, ಏಸಾವನ ಹೆಂಡತಿಯಾದ ಆದಾ ಎಂಬಾಕೆಯ ಮಗನು. ರೆಗೂವೇಲನು ಏಸಾವನ ಹೆಂಡತಿಯಾದ ಬಾಸೆಮತಳ ಮಗನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ಎಲೀಫಜನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ತೇಮಾನ್, ಓಮಾರ್, ಚೆಫೋ, ಗತಾಮ್, ಕೆನೆಜ್, ");
INSERT INTO kanirv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ತಿಮ್ನ ಎಂಬವಳು ಏಸಾವನ ಮಗನಾದ ಎಲೀಫಜನಿಗೆ ಉಪಪತ್ನಿಯಾಗಿದ್ದು ಆಕೆಯು ಅವನಿಗೆ ಅಮಾಲೇಕನನ್ನು ಹೆತ್ತಳು. ಇವರೇ ಏಸಾವನ ಹೆಂಡತಿಯಾದ ಆದಾ ಎಂಬಾಕೆಯ ಮಕ್ಕಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ರೆಗೂವೇಲನ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ನಹತ್, ಜೆರಹ, ಶಮ್ಮಾ ಮಿಜ್ಜಾ ಇವರು ಏಸಾವನ ಹೆಂಡತಿಯಾದ ಬಾಸೆಮತಳ ಪುತ್ರರು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ಏಸಾವನ ಹೆಂಡತಿಯಾದ ಸಿಬಿಯೋನನ ಮಗಳಾದ ಅನಾಹನ ಮಗಳಾದ ಒಹೊಲೀಬಾಮಳ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ಯೆಗೂಷ್ ವಂಶಸ್ಥರನ್ನು, ಯಳಾಮ ಕೋರಹ ಇವರನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ಏಸಾವನ ಪುತ್ರರ ಮುಖಂಡರು ಯಾರೆಂದರೆ: ಏಸಾವನ ಚೊಚ್ಚಲ ಮಗನಾದ ಎಲೀಫಜನಿಂದ ಹುಟ್ಟಿದವರು ಯಾರೆಂದರೆ: ತೇಮಾನ್, ಓಮಾರ್, ಚೆಫೋ, ಕೆನೆಜ್, ");
INSERT INTO kanirv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ಕೋರಹ, ಗತಾಮ್, ಅಮಾಲೇಕ್, ಇವರೇ, ಈ ಕುಲಪತಿಗಳು ಎದೋಮ್ಯರ ದೇಶದಲ್ಲಿದ್ದ ಎಲೀಫಜನಿಂದ ಬಂದವರು. ಇವರು ಆದಾಳ ಮೊಮ್ಮಕ್ಕಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ಏಸಾವನ ಮಗನಾದ ರೆಗೂವೇಲನಿಗೆ ಹುಟ್ಟಿದವರು ಯಾರೆಂದರೆ: ನಹತ್, ಜೆರಹ, ಶಮ್ಮಾ, ಮಿಜ್ಜಾ ಎಂಬ ಕುಲನಾಯಕರು ಹುಟ್ಟಿದರು. ಇವರು ಎದೋಮ್ಯರ ದೇಶದಲ್ಲಿ ಏಸಾವನ ಹೆಂಡತಿಯಾದ ಬಾಸೆಮತಳಿಗೆ ಹುಟ್ಟಿದ ಮೊಮ್ಮಕ್ಕಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ಏಸಾವನ ಹೆಂಡತಿಯಾಗಿದ್ದ ಒಹೊಲೀಬಾಮಳ ಮಗಳಾದ ಅನಾಳ ಸಂತಾನದ ಕುಲನಾಯಕರು ಯಾರೆಂದರೆ: ಯೆಗೂಷ್, ಯಳಾಮ, ಮತ್ತು ಕೋರಹ. ಇವರೇ ಅನಾಹನ ಮಗಳೂ ಏಸಾವನ ಹೆಂಡತಿಯೂ ಆಗಿದ ಒಹೊಲೀಬಾಮಳ ಸಂತಾನದವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ಎದೋಮನೆನ್ನಿಸಿಕೊಳ್ಳುವ ಏಸಾವನಿಂದ ಹುಟ್ಟಿದ ಕುಲಗಳಿಗೆ ಇವರೇ ಮುಖಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ಆ ಸೀಮೆಯ ಮೂಲನಿವಾಸಿಗಳು ಹೋರಿಯನಾದ ಸೇಯೀರಿನಿಂದ ಹುಟ್ಟಿದವರು. ಅವರು ಯಾರೆಂದರೆ: ಲೋಟಾನ್, ಶೋಬಾಲ್, ಸಿಬೆಯೋನ್, ಅನಾಹ, ");
INSERT INTO kanirv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ದೀಶೋನ್, ಏಚೆರ್, ದೀಶಾನ್ ಇವರು ಎದೋಮ್ಯರ ದೇಶದಲ್ಲಿ ಸೇಯೀರನ ಸಂತತಿಯವರಾದ ಹೋರಿಯಲ್ಲಿ ಹುಟ್ಟಿದ ಮುಖಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ಲೋಟಾನನ ಮಕ್ಕಳು: ಹೋರಿ, ಹೇಮಾಮ್, ಲೋಟಾನನ ತಂಗಿ ತಿಮ್ನಾ. ");
INSERT INTO kanirv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ಶೋಬಾಲನ ಮಕ್ಕಳು: ಅಲ್ವಾನ್, ಮಾನಹತ್, ಗೇಬಾಲ್, ಶೆಫೋ ಮತ್ತು ಓನಾಮ್. ");
INSERT INTO kanirv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ಸಿಬೆಯೋನನ ಮಕ್ಕಳು: ಅಯ್ಯಾ ಮತ್ತು ಅನಾಹ ಎಂಬವರು. ಈ ಅನಾಹನೇ ತನ್ನ ತಂದೆಯಾದ ಸಿಬಿಯೋನನ ಕತ್ತೆಗಳನ್ನು ಮೇಯಿಸುತ್ತಿದ್ದಾಗ ಕಾಡಿನಲ್ಲಿ ಬಿಸಿ ನೀರಿನ ಒರತೆಗಳನ್ನು ಕಂಡುಕೊಂಡವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ಅನಾಹನ ಮಕ್ಕಳು: ದೀಶೋನ್ ಮತ್ತು ಅನಾಹನ ಮಗಳಾದ ಒಹೊಲೀಬಾಮಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ದೀಶೋನನ ಮಕ್ಕಳು: ಹೆಮ್ದಾನ್, ಎಷ್ಬಾನ್, ಇತ್ರಾನ್, ಕೆರಾನ್. ");
INSERT INTO kanirv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ಏಚೆರನ ಮಕ್ಕಳು: ಬಿಲ್ಹಾನ್, ಜಾವಾನ್, ಅಕಾನ್. ");
INSERT INTO kanirv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ದೀಶಾನನ ಮಕ್ಕಳು: ಊಚ್ ಮತ್ತು ಅರಾನ್. ");
INSERT INTO kanirv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ಹೋರಿಯರಿಂದ ಹುಟ್ಟಿದ ಮುಖಂಡರು: ಲೋಟಾನ್, ಶೋಬಾಲ್, ಸಿಬೆಯೋನ್, ಅನಾಹ ");
INSERT INTO kanirv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ದೀಶೋನ್, ಏಚೆರ್, ದೀಶಾನ್ ಇವರೇ. ಇವರು ಹೋರಿಯರಿಂದ ಹುಟ್ಟಿದವರಾಗಿ ಸೇಯೀರ್ ಸೀಮೆಯಲ್ಲಿ ಅಧಿಪತ್ಯ ನಡಿಸಿದ ಮುಖಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ಇಸ್ರಾಯೇಲ್ಯರ ಅರಸರು ಆಳುವುದಕ್ಕಿಂತ ಮೊದಲು ಎದೋಮ್ಯರ ದೇಶದಲ್ಲಿ ಆಳುತ್ತಿದ್ದ ಅರಸರ ಚರಿತ್ರೆ: ");
INSERT INTO kanirv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ಬೆಯೋರನ ಮಗನಾದ ಬೆಲಗನು ಎದೋಮ್ಯರನ್ನು ಆಳಿದನು. ಅವನ ಪಟ್ಟಣದ ಹೆಸರು ದಿನ್ಹಾಬಾ. ");
INSERT INTO kanirv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ಬೆಲಗನು ಸತ್ತ ನಂತರ ಬೊಚ್ರದವನಾದ ಜೆರಹನ ಮಗನಾಗಿದ್ದ ಯೋಬಾಬನು ಅಧಿಪತ್ಯಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ಯೋಬಾಬನು ಸತ್ತ ನಂತರ ತೇಮಾನೀಯರ ಹುಷಾಮನು ಅವನಿಗೆ ಬದಲಾಗಿ ಆಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ಹುಷಾಮನು ಸತ್ತ ನಂತರ ಮೋವಾಬ್ಯರ ಬಯಲಿನಲ್ಲಿ ಮಿದ್ಯಾನರನ್ನು ಸೋಲಿಸಿದ ಬೆದದನ ಮಗನಾದ ಹದದನು ಅರಸನಾದನು. ಅವನ ರಾಜಧಾನಿಯ ಹೆಸರು ಅವೀತ್. ");
INSERT INTO kanirv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ಹದದನು ಸತ್ತ ನಂತರ ಮಸ್ರೇಕದವನಾದ ಸಮ್ಲಾಹನು ಪಟ್ಟಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ಸಮ್ಲಾಹನು ಸತ್ತ ಮೇಲೆ ನದಿ ತೀರದಲ್ಲಿರುವ ರೆಹೋಬೋತೂರಿನ ಸೌಲನು ಅರಸನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ಸೌಲನು ಸತ್ತ ನಂತರ ಅಕ್ಬೋರನ ಮಗನಾದ ಬಾಳ್ಹಾನಾನನು ಅರಸನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ಅಕ್ಬೋರನ ಮಗನಾದ ಬಾಳ್ಹಾನಾನನು ಸತ್ತ ಮೇಲೆ ಹದರನು ಅರಸನಾದನು. ಅವನ ರಾಜಧಾನಿಯ ಹೆಸರು ಪಾಗು. ಅವನ ಹೆಂಡತಿಯ ಹೆಸರು ಮಹೇಟಬೇಲ್; ಆಕೆಯು ಮೇಜಾಹಾಬನ ಮಗಳಾದ ಮಟ್ರೇದಳ ಮಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ಸ್ಥಳ, ಕುಲ, ಹೆಸರುಗಳ ಪ್ರಕಾರವಾಗಿ ಏಸಾವನಿಂದ ಹುಟ್ಟಿದ ಕುಲಪತಿಗಳ ಹೆಸರುಗಳು ಯಾವುವೆಂದರೆ: ತಿಮ್ನ, ಅಲ್ವಾ, ಯೆತೇತ, ");
INSERT INTO kanirv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ಒಹೋಲಿಬಾಮ, ಏಲಾ, ಪೀನೋನ್, ");
INSERT INTO kanirv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ಕೆನೆಜ್, ತೇಮಾನ್, ಮಿಪ್ಚಾರ್ ");
INSERT INTO kanirv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ಮಗ್ದೀಯೇಲ್ ಗೀರಾಮ್ ಇವರೇ ತಮ್ಮ ದೇಶದ ನಿವಾಸ ಸ್ಥಳಗಳ ಪ್ರಕಾರ ಎದೋಮ್ಯರ ಮುಖಂಡರು. ಈ ಎದೋಮ್ಯರ ಮೂಲ ಪುರುಷನೇ ಏಸಾವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯು ಪ್ರವಾಸವಾಗಿದ್ದ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ಇದು ಯಾಕೋಬನ ವಂಶದವರ ಚರಿತ್ರೆ: ಯೋಸೇಫನು ಹದಿನೇಳು ವರ್ಷದವನಾಗಿದ್ದಾಗ ತನ್ನ ಅಣ್ಣಂದಿರ ಜೊತೆಯಲ್ಲಿ ಅಂದರೆ, ತನ್ನ ತಂದೆಯ ಹೆಂಡತಿಯರಾದ ಬಿಲ್ಹಾ ಮತ್ತು ಜಿಲ್ಪಾರ ಮಕ್ಕಳ ಜೊತೆಯಲ್ಲಿ ಆಡು ಕುರಿಗಳನ್ನು ಮೇಯಿಸುತ್ತಿದ್ದನು. ಅವರು ಏನಾದರೂ ಕೆಟ್ಟ ಕೆಲಸ ಮಾಡುವಾಗ ಅವನು ತಂದೆಗೆ ತಿಳಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ಯೋಸೇಫನು ಇಸ್ರಾಯೇಲನಿಗೆ ಮುಪ್ಪಿನಲ್ಲಿ ಹುಟ್ಟಿದವನಾಗಿದ್ದುದರಿಂದ ಅವನನ್ನು ತನ್ನ ಎಲ್ಲಾ ಮಕ್ಕಳಿಗಿಂತ ಹೆಚ್ಚಾಗಿ ಪ್ರೀತಿಸುತ್ತಿದ್ದನು, ಅಲ್ಲದೆ ಅವನಿಗೆ ಬಣ್ಣಬಣ್ಣದ ಒಂದು ನಿಲುವಂಗಿಯನ್ನು ಹೊಲಿಸಿ ಕೊಟ್ಟಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರು, ತಮ್ಮ ತಂದೆಯು ಎಲ್ಲಾ ಮಕ್ಕಳಿಗಿಂತಲೂ ಇವನನ್ನೇ ಹೆಚ್ಚಾಗಿ ಪ್ರೀತಿಸುತ್ತಿರುವುದನ್ನು ನೋಡಿ ಯೋಸೇಫನನ್ನು ಹಗೆಮಾಡಿ ಅವನೊಡನೆ ಸ್ನೇಹಭಾವದಿಂದ ಮಾತನಾಡಲಾರದೆ ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ಒಂದು ದಿನ ಯೋಸೇಫನು ಕನಸು ಕಂಡು ಅದನ್ನು ತನ್ನ ಅಣ್ಣಂದಿರಿಗೆ ತಿಳಿಸಿದಾಗ ಅವರು ಅವನನ್ನು ಇನ್ನೂ ಹೆಚ್ಚಾಗಿ ದ್ವೇಷಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ಅವನು ಅವರಿಗೆ, “ನಾನು ಕನಸಿನಲ್ಲಿ ಕಂಡದ್ದನ್ನು ಹೇಳುತ್ತೇನೆ, ದಯವಿಟ್ಟು ಕೇಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ಆ ಕನಸಿನಲ್ಲಿ ನಾವು ಹೊಲದಲ್ಲಿ ಸಿವುಡುಗಳನ್ನು ಕಟ್ಟುತ್ತಾ ಇದ್ದೆವು. ಆಗ ನನ್ನ ಸಿವುಡು ಎದ್ದು ನಿಂತಿತು. ನಿಮ್ಮ ಸಿವುಡುಗಳು ಸುತ್ತಲೂ ಬಂದು ನನ್ನ ಸಿವುಡಿಗೆ ಅಡ್ಡಬಿದ್ದದ್ದನ್ನು ಕಂಡೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ಅದಕ್ಕೆ ಅವನ ಅಣ್ಣಂದಿರು ಅವನಿಗೆ, “ನೀನು ನಿಜವಾಗಿ ನಮ್ಮನ್ನು ಆಳುವಿಯಾ? ನೀನು ನಮ್ಮ ಮೇಲೆ ದೊರೆತನ ಮಾಡುವಿಯಾ?” ಎಂದು ಹೇಳಿ ಅವನ ಕನಸುಗಳಿಗಾಗಿಯೂ, ಅದನ್ನು ಅವನು ಅವರಿಗೆ ತಿಳಿಸಿದ್ದಕ್ಕಾಗಿಯು ಮತ್ತಷ್ಟು ಅವನನ್ನು ದ್ವೇಷಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ಅವನು ಇನ್ನೊಂದು ಕನಸನ್ನು ಕಂಡನು. ಅದನ್ನು ತನ್ನ ಅಣ್ಣಂದಿರಿಗೆ ತಿಳಿಸಿದನು. ಅವನು ಅವರಿಗೆ, “ಇನ್ನೊಂದು ಕನಸು ಕಂಡಿದ್ದೇನೆ. ಅದರಲ್ಲಿ ಸೂರ್ಯಚಂದ್ರರೂ, ಹನ್ನೊಂದು ನಕ್ಷತ್ರಗಳೂ ನನಗೆ ಅಡ್ಡ ಬಿದ್ದವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ಅವನು ಈ ಕನಸನ್ನು ತನ್ನ ತಂದೆಗೂ ಮತ್ತು ಅಣ್ಣಂದಿರಿಗೂ ತಿಳಿಸಿದಾಗ ತಂದೆಯು ಅವನಿಗೆ, “ಇದು ಎಂಥಾ ಕನಸು ನೀನು ಕಂಡದ್ದು? ನಾನೂ ನಿನ್ನ ತಾಯಿಯೂ, ಅಣ್ಣತಮ್ಮಂದಿರೂ ನಿನ್ನ ಮುಂದೆ ಅಡ್ಡ ಬೀಳುವುದಕ್ಕೆ ಬಂದೆವೋ?” ಎಂದು ಹೇಳಿ ಗದರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ಹೀಗೆ ಯೋಸೇಫನ ಅಣ್ಣಂದಿರು ಅವನ ಮೇಲೆ ಹೊಟ್ಟೆಕಿಚ್ಚುಪಟ್ಟರು. ಆದರೆ ಅವನ ತಂದೆಯು ಅವನ ಮಾತುಗಳನ್ನು ಮನಸ್ಸಿನಲ್ಲಿ ಇಟ್ಟುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ಅವನ ಅಣ್ಣಂದಿರು ತಂದೆಯ ಆಡುಕುರಿ ಹಿಂಡುಗಳನ್ನು ಮೇಯಿಸುವುದಕ್ಕೆ ಶೆಕೆಮಿಗೆ ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ಅಣ್ಣಂದಿರು ಶೆಕೆಮಿನಲ್ಲಿ ಆಡುಕುರಿಗಳನ್ನು ಮೇಯಿಸುತ್ತಿದ್ದಾರಲ್ಲಾ ಅವರ ಬಳಿಗೆ ನಿನ್ನನ್ನು ಕಳುಹಿಸುತ್ತೇನೆ, ಹೋಗು” ಎಂದು ಹೇಳಿದನು. ಅದಕ್ಕೆ ಅವನು, “ಆಗಲಿ, ಹೋಗುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ಇಸ್ರಾಯೇಲ್ಯನು ಅವನಿಗೆ, “ನೀನು ಶೆಕೆಮಿಗೆ ಹೋಗಿ ನಿನ್ನ ಅಣ್ಣಂದಿರ ಯೋಗ ಕ್ಷೇಮವನ್ನೂ, ಆಡುಕುರಿಗಳ ಹಿಂಡಿನ ಯೋಗ ಕ್ಷೇಮವನ್ನೂ ವಿಚಾರಿಸಿಕೊಂಡು ಬಾ” ಎಂದು ಅಪ್ಪಣೆ ಕೊಟ್ಟು, ಅವನನ್ನು ಹೆಬ್ರೋನ್ ಕಣಿವೆಯಿಂದ ಕಳುಹಿಸಲು ಯೋಸೇಫನು ಹೊರಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ಅವನು ಶೆಕೆಮಿಗೆ ಬಂದು ಅಲ್ಲಿ ಅಡವಿಯೊಳಗೆ ತಿರುಗಾಡುತ್ತಿರುವಾಗ ಒಬ್ಬ ಮನುಷ್ಯನು ಅವನನ್ನು ಕಂಡು, “ಏನು ಹುಡುಕುತ್ತೀ?” ಎಂದು ವಿಚಾರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ಅದಕ್ಕೆ ಅವನು, “ನನ್ನ ಅಣ್ಣಂದಿರನ್ನು ಹುಡುಕುತ್ತಾ ಇದ್ದೇನೆ. ಅವರು ಆಡುಕುರಿಗಳನ್ನು ಎಲ್ಲಿ ಮೇಯಿಸುತ್ತಾರೆ ದಯವಿಟ್ಟು ಹೇಳು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ಅದಕ್ಕೆ ಆ ಮನುಷ್ಯನು, “ಅವರು ಇಲ್ಲಿಂದ ಹೊರಟುಹೋದರು. ಅವರು ನಾವು ದೋತಾನಿಗೆ ಹೋಗೋಣ ಎಂಬುದಾಗಿ ಮಾತನಾಡುವುದನ್ನು ನಾನು ಕೇಳಿಸಿಕೊಂಡೆನು” ಎಂದು ಹೇಳಲು ಯೋಸೇಫನು ಅವರನ್ನು ಹುಡುಕುತ್ತಾ ಹೋಗಿ ದೋತಾನಿನಲ್ಲಿ ಅವರನ್ನು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ಅವರು ಅವನನ್ನು ದೂರದಿಂದ ನೋಡಿ ಅವನು ತಮ್ಮ ಬಳಿಗೆ ಬರುವಷ್ಟರೊಳಗೆ ಅವನನ್ನು ಕೊಲ್ಲುವುದಕ್ಕೆ ಒಳಸಂಚು ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ಅವರು ಒಬ್ಬರಿಗೊಬ್ಬರು, “ಅಗೋ ಆ ಕನಸುಗಾರನು ಬರುತ್ತಿದ್ದಾನೆ ನೋಡಿರಿ ");
INSERT INTO kanirv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ಬನ್ನಿರಿ, ಈಗ ನಾವು ಅವನನ್ನು ಕೊಂದು ಈ ಗುಂಡಿಗಳಲ್ಲಿ ಒಂದರೊಳಗೆ ಹಾಕಿ, ಕಾಡುಮೃಗವು ಅವನನ್ನು ತಿಂದು ಬಿಟ್ಟಿತೆಂದು ಹೇಳೋಣ. ಆಗ ಅವನ ಕನಸುಗಳು ಏನಾಗುವವೋ? ನೋಡೋಣ” ಎಂದು ಒಬ್ಬರಿಗೊಬ್ಬರು ಮಾತನಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ರೂಬೇನನು ಈ ಮಾತನ್ನು ಕೇಳಿ, “ನಾವು ಅವನ ಪ್ರಾಣವನ್ನು ತೆಗೆಯಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ರೂಬೇನನು ಅವನನ್ನು ಅವರ ಕೈಯಿಂದ ತಪ್ಪಿಸಿ ತಂದೆಗೆ ತಿರುಗಿ ಒಪ್ಪಿಸಬೇಕೆಂದು ನೆನಸಿ ಅವರಿಗೆ, “ಇವನ ರಕ್ತ ಸುರಿಸಬೇಡಿರಿ, ಅವನನ್ನು ಈ ಕಾಡಿನಲ್ಲಿರುವ ಈ ಗುಂಡಿಯೊಳಗೆ ಹಾಕಿರಿ, ಅವನ ಮೇಲೆ ಕೈಹಾಕಬೇಡಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ಯೋಸೇಫನು ತನ್ನ ಅಣ್ಣಂದಿರ ಹತ್ತಿರಕ್ಕೆ ಬಂದಾಗ ಅವರು ಅವನ ಮೇಲಿದ್ದ ನಿಲುವಂಗಿಯನ್ನು ತೆಗೆದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ಅವನನ್ನು ಹಿಡಿದು ಆ ಗುಂಡಿಯೊಳಗೆ ಹಾಕಿದರು. ಆ ಗುಂಡಿ ನೀರಿಲ್ಲದೆ ಬರಿದಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ಆ ಮೇಲೆ ಅವರು ಊಟಕ್ಕೆ ಕುಳಿತುಕೊಂಡಾಗ ಅವರು ತಮ್ಮ ಕಣ್ಣುಗಳನ್ನೆತ್ತಿ ನೋಡಲಾಗಿ, ಇಷ್ಮಾಯೇಲರ ಗುಂಪು ಒಂಟೆಗಳ ಮೇಲೆ ಪರಿಮಳ ದ್ರವ್ಯ, ಸುಗಂಧ ತೈಲ, ರಕ್ತಬೋಳ, ಇವುಗಳನ್ನು ಹೇರಿಕೊಂಡು ಗಿಲ್ಯಾದಿನಿಂದ ಐಗುಪ್ತದೇಶಕ್ಕೆ ಪ್ರಯಾಣಮಾಡುತ್ತಾ ಬರುವುದನ್ನು ಕಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ಆಗ ಯೆಹೂದನು ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ, “ನಾವು ನಮ್ಮ ತಮ್ಮನನ್ನು ಕೊಂದು ಹಾಕಿ ಅವನ ರಕ್ತವನ್ನು ಮರೆಮಾಡಿದರೆ ಲಾಭವೇನು? ");
INSERT INTO kanirv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ಬನ್ನಿರಿ, ಅವನನ್ನು ಆ ಇಷ್ಮಾಯೇಲ್ಯರಿಗೆ ಮಾರಿಬಿಡೋಣ. ನಾವು ಅವನ ಮೇಲೆ ಕೈಹಾಕಬಾರದು. ಅವನು ನಮ್ಮ ಒಡಹುಟ್ಟಿದ ತಮ್ಮನಲ್ಲವೇ” ಎಂದು ಹೇಳಿದನು. ಆ ಮಾತಿಗೆ ಅವನ ಅಣ್ಣಂದಿರು ಒಪ್ಪಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ಅಷ್ಟರಲ್ಲಿ ಮಿದ್ಯಾನ್ಯರಾದ ವರ್ತಕರು ಹಾದುಹೋಗುತ್ತಿದ್ದರು. ಅವರು ಯೋಸೇಫನನ್ನು ಗುಂಡಿಯೊಳಗಿಂದ ಮೇಲೆ ಎತ್ತಿ ಆ ಇಷ್ಮಾಯೇಲ್ಯರಿಗೆ ಇಪ್ಪತ್ತು ಬೆಳ್ಳಿಯ ನಾಣ್ಯಗಳಿಗೆ ಅವನನ್ನು ಮಾರಿದರು. ಅವರು ಅವನನ್ನು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ರೂಬೇನನು ತಿರುಗಿ ಆ ಗುಂಡಿಯ ಹತ್ತಿರಕ್ಕೆ ಬಂದು ಅದರಲ್ಲಿ ಯೋಸೇಫನು ಇಲ್ಲದೆ ಇರುವುದನ್ನು ಕಂಡು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ಅವನು ತನ್ನ ತಮ್ಮಂದಿರ ಬಳಿಗೆ ಬಂದು, “ಅಯ್ಯೋ, ಹುಡುಗನು ಇಲ್ಲವಲ್ಲಾ, ನಾನೆಲ್ಲಿಗೆ ಹೋಗಲಿ?” ಎಂದು ಗೋಳಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ಆ ಮೇಲೆ ಅವರು ಒಂದು ಹೋತವನ್ನು ಕೊಯ್ದು ಅದರ ರಕ್ತದಲ್ಲಿ ಯೋಸೇಫನ ಅಂಗಿಯನ್ನು ಅದ್ದಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ಆ ಬಣ್ಣದ ನಿಲುವಂಗಿಯನ್ನು ತಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ತಂದು, “ಇದು ನಮಗೆ ಸಿಕ್ಕಿತು. ಇದು ನಿನ್ನ ಮಗನ ಅಂಗಿಯೋ ಏನೋ ದಯವಿಟ್ಟು ನೋಡು” ಎಂದು ಅವನಿಗೆ ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ಯಾಕೋಬನು ಅದರ ಗುರುತು ಹಿಡಿದು, “ಈ ಅಂಗಿ ನನ್ನ ಮಗನದೇ ಹೌದು, ಕಾಡುಮೃಗವು ಅವನನ್ನು ಕೊಂದು ತಿಂದು ಬಿಟ್ಟಿದೆ. ಯೋಸೇಫನನ್ನು ಸಂದೇಹವಿಲ್ಲದೆ ಸೀಳಿಹಾಕಿರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ಯಾಕೋಬನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡು ನಡುವಿಗೆ ಗೋಣಿಯನ್ನು ಕಟ್ಟಿಕೊಂಡು ತನ್ನ ಮಗನಿಗಾಗಿ ಬಹು ದಿನಗಳವರೆಗೂ ದುಃಖಪಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ಅವನ ಗಂಡುಮಕ್ಕಳೂ ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳೂ ಎಲ್ಲರೂ ಅವನ ದುಃಖ ಶಮನಮಾಡುವುದಕ್ಕೆ ಪ್ರಯತ್ನಿಸಿದ್ದಾಗ್ಯೂ ಅವನು ಸಮಾಧಾನ ಆದರಣೆ ಹೊಂದಲಾರದೇ, “ನಾನು ಹೀಗೆ ದುಃಖಪಡುತ್ತಾ ನನ್ನ ಮಗನೊಂದಿಗೆ ಸಮಾಧಿ ಸೇರುವೆನು” ಎಂದನು. ಹೀಗೆ ತಂದೆಯು ಮಗನಿಗೋಸ್ಕರ ದುಃಖಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ಇದಲ್ಲದೆ ಆ ಮಿದ್ಯಾನ್ಯರು ಯೋಸೇಫನನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಐಗುಪ್ತ ದೇಶದ ಫರೋಹನ ಉದ್ಯೋಗಸ್ಥನಾದ ಪೋಟೀಫರನಿಗೆ ಮಾರಿದರು. ಇವನು ಅರಸನ ಮೈಗಾವಲಿನವರ ದಳಪತಿಯೂ ಆಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ಆ ಕಾಲದಲ್ಲಿ ಯೆಹೂದನು ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರನ್ನು ಬಿಟ್ಟು ಗಟ್ಟಾ ಇಳಿದು ಅದುಲ್ಲಾಮಿನ ಊರಿನವನಾದ ಹೀರಾ ಎಂಬುವವನ ಹತ್ತಿರ ಉಳಿದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ಅಲ್ಲಿ ಯೆಹೂದನು ಕಾನಾನ್ಯನಾದ ಶೂಗನ ಮಗಳನ್ನು ಕಂಡು ಅವಳನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡನು ");
INSERT INTO kanirv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ಅವಳು ಬಸುರಾಗಿ ಗಂಡುಮಗುವನ್ನು ಹೆತ್ತಳು ಅದಕ್ಕೆ ಯೆಹೂದನು “ಏರ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ಅವಳು ಎರಡನೆಯ ಸಾರಿ ಬಸುರಾಗಿ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತಾಗ ಅದಕ್ಕೆ “ಓನಾನ್” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ಅವಳು ಪುನಃ ಗರ್ಭಿಣಿಯಾಗಿ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತಳು. ಅದಕ್ಕೆ “ಶೇಲಹ” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಅವಳು ಆ ಮಗುವನ್ನು ಹೆತ್ತಾಗ ಯೆಹೂದನು ಕಜೀಬೂರಿನಲ್ಲಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ಯೆಹೂದನು ತನ್ನ ಚೊಚ್ಚಲು ಮಗನಾದ ಏರನಿಗೆ “ತಾಮಾರ್” ಎಂಬ ಹೆಣ್ಣನ್ನು ತಂದು ಮದುವೆ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ಆದರೆ ಯೆಹೂದನ ಚೊಚ್ಚಲ ಮಗನಾದ ಏರನು ಯೆಹೋವನ ದೃಷ್ಟಿಯಲ್ಲಿ ಕೆಟ್ಟವನಾಗಿದ್ದುದರಿಂದ ಯೆಹೋವನು ಅವನನ್ನು ಸಾಯುವಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ಬಳಿಕ ಯೆಹೂದನು ಓನಾನನಿಗೆ, “ನೀನು ನಿನ್ನ ಅಣ್ಣನ ಹೆಂಡತಿಯನ್ನು ಮದುವೆಮಾಡಿಕೊಂಡು ಮೈದುನ ಧರ್ಮಕ್ಕೆ ಸರಿಯಾಗಿ ನಡೆದು ನಿನ್ನ ಅಣ್ಣನಿಗೆ ಸಂತತಿಯನ್ನು ಉಂಟು ಮಾಡು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ಆದರೆ ಓನಾನನು ಈ ರೀತಿ ಆಗುವ ಸಂತಾನವು ತನ್ನದಾಗುವುದಿಲ್ಲವೆಂದು ತಿಳಿದು ಅಣ್ಣನಿಗೆ ಸಂತತಿಯನ್ನು ಹುಟ್ಟಿಸಬಾರದೆಂದು ಯೋಚಿಸಿ ತನ್ನ ಅತ್ತಿಗೆಯೊಂದಿಗೆ ಸಂಗಮಿಸುವಾಗೆಲ್ಲಾ ಅವಳು ಗರ್ಭಧರಿಸದಂತೆ ತನ್ನ ವೀರ್ಯವನ್ನು ನೆಲದ ಮೇಲೆ ಸುರಿಸುತಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ಈ ನಡತೆ ಯೆಹೋವನ ದೃಷ್ಟಿಯಲ್ಲಿ ಕೆಟ್ಟದ್ದಾಗಿದ್ದುದರಿಂದ ಆತನು ಅವನನ್ನೂ ಸಾಯಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ಆ ಮೇಲೆ ಯೆಹೂದನು ಒಂದು ವೇಳೆ ಶೇಲಹನು ತನ್ನ ಅಣ್ಣಂದಿರಂತೆಯೇ ಸತ್ತಾನೆಂದು ಯೋಚಿಸಿ ತನ್ನ ಸೊಸೆಯಾದ ತಾಮಾರಳಿಗೆ, “ನನ್ನ ಮಗನಾದ ಶೇಲಹನು ಪ್ರಾಯಸ್ಥನಾಗುವ ತನಕ ನೀನು ವಿಧವೆಯಾಗಿದ್ದು ನಿನ್ನ ತಂದೆಯ ಮನೆಯಲ್ಲಿರು” ಎಂದು ಹೇಳಿದನು. ಅವಳು ತಂದೆಯ ಮನೆಗೆ ಹೋಗಿ ಅಲ್ಲೇ ವಾಸಮಾಡಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ಬಹಳ ದಿನಗಳಾದ ಮೇಲೆ ಯೆಹೂದನ ಹೆಂಡತಿಯಾಗಿದ್ದ ಶೂಗನ ಮಗಳು ತೀರಿಕೊಂಡಳು. ಯೆಹೂದನು ತನಗೆ ದುಃಖಶಮನವಾದ ಮೇಲೆ ತನ್ನ ಕುರಿಗಳ ಉಣ್ಣೆ ಕತ್ತರಿಸುವವರ ಬಳಿಗೆ ತನ್ನ ಸ್ನೇಹಿತನಾದ ಹೀರಾ ಎಂಬ ಅದುಲ್ಲಾಮ್ಯನ ಜೊತೆಯಲ್ಲಿ ಗಟ್ಟಾ ಹತ್ತಿ ತಿಮ್ನಾ ಊರಿಗೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ಆಗ ತಾಮಾರಳಿಗೆ, “ಮಾವನು ತನ್ನ ಕುರಿಗಳ ಉಣ್ಣೇ ಕತ್ತರಿಸುವುದಕ್ಕೋಸ್ಕರ ತಿಮ್ನಾ ಊರಿಗೆ ಹೋಗುತ್ತಿದ್ದಾನೆ” ಎಂದು ತಿಳಿದು ಬಂದಿತು ");
INSERT INTO kanirv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ಆಗ ಆಕೆಯು ಶೇಲಹನು ಪ್ರಾಯಸ್ಥನಾದಾಗ್ಯೂ ನನ್ನನ್ನು ಅವನಿಗೆ ಮದುವೆ ಮಾಡಿಸಲಿಲ್ಲವಲ್ಲಾ ಅಂದುಕೊಂಡು ತನ್ನ ವಿಧವಾ ವಸ್ತ್ರವನ್ನು ತೆಗೆದಿಟ್ಟು ಮುಸುಕನ್ನು ಹಾಕಿಕೊಂಡು ವೇಶ್ಯಾಸ್ತ್ರೀಯಂತೆ ಅಲಂಕೃತಳಾಗಿ ತಿಮ್ನಾ ಊರಿನ ದಾರಿಯಲ್ಲಿರುವ ಏನಯಿಮ್ ಊರಿನ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಕುಳಿತುಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ಯೆಹೂದನು ಆಕೆಯನ್ನು ಕಂಡಾಗ ಮುಖದ ಮೇಲೆ ಮುಸುಕು ಇದ್ದದರಿಂದ ಸೊಸೆ ಎಂದು ತಿಳಿಯದೆ ವೇಶ್ಯಾಸ್ತ್ರೀಯೆಂದು ಭಾವಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ಮಾರ್ಗದಿಂದ ಓರೆಯಾಗಿ ಆಕೆಯ ಬಳಿಗೆ ಹೋಗಿ, “ನಾನು ನಿನ್ನ ಬಳಿಗೆ ಬರಲೇ ಎಂದು ಕೇಳಿದನು” ಆಕೆ, “ನೀನು ನನ್ನಲ್ಲಿ ಬರಬೇಕಾದರೆ, ನನಗೆ ಏನು ಕೊಡುತ್ತೀ?” ಎಂದು ಕೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ಅವನು, “ಹಿಂಡಿನಿಂದ ಒಂದು ಹೋತಮರಿಯನ್ನು ಕಳುಹಿಸುತ್ತೇನೆ” ಅಂದಾಗ ಆಕೆ, “ನೀನು ಆದನ್ನು ಕೊಡುವ ತನಕ ನನ್ನಲ್ಲಿ ಏನಾದರೂ ಒತ್ತೆಯಿಡಬೇಕು” ಎಂದು ಹೇಳಿದ್ದಕ್ಕೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ಅವನು, “ಏನು ಒತ್ತೇ ಇಡಲಿ” ಎಂದು ಕೇಳಿದನು. ಆಗ ಆಕೆಯು “ನಿನ್ನ ಮುದ್ರೆ, ನಿನ್ನ ದಾರ, ನಿನ್ನ ಕೈಕೋಲು ಈ ಮೂರನ್ನು ಒತ್ತೆಯಾಗಿ ಇಡು” ಅಂದಳು. ಅವನು ಅವುಗಳನ್ನು ಕೊಟ್ಟು ಆಕೆಯನ್ನು ಸಂಗಮಿಸಲು ಆಕೆಯು ಅವನಿಗೆ ಗರ್ಭಿಣಿಯಾದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ತರುವಾಯ ಆಕೆ ತಾನು ಹಾಕಿಕೊಂಡಿದ್ದ ಮುಸುಕನ್ನು ತೆಗೆದಿಟ್ಟು ತಿರುಗಿ ವಿಧವೆಯ ವಸ್ತ್ರಗಳನ್ನು ಉಟ್ಟುಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ಯೆಹೂದನು ತಾನು ಇಟ್ಟಿದ್ದ ಒತ್ತೆಯನ್ನು ಆ ಹೆಂಗಸಿನ ಕೈಯಿಂದ ಬಿಡಿಸಿಕೊಳ್ಳುವುದಕ್ಕೊಸ್ಕರ ತನ್ನ ಸ್ನೇಹಿತನಾದ ಅದುಲ್ಲಾಮ್ಯನ ಕೈಯಲ್ಲಿ ಹೋತಮರಿಯನ್ನು ಕಳುಹಿಸಿದಾಗ ಆಕೆಯು ಅವನಿಗೆ ಸಿಗಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ಅವನು ಅವಳ ಊರಿನವರನ್ನು, “ಏನಯಿಮಿನ ದಾರಿಯ ಬಳಿಯಲ್ಲಿ ಕುಳಿತಿದ್ದ ವೇಶ್ಯಾಸ್ತ್ರೀ ಎಲ್ಲಿರುವಳು” ಎಂದು ಕೇಳಿದ್ದಕ್ಕೆ ಅವರು, “ಇಲ್ಲಿ ಯಾವ ವೇಶ್ಯಾಸ್ತ್ರೀಯೂ ಇಲ್ಲ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ಅವನು ಯೆಹೂದನ ಬಳಿಗೆ ಹಿಂದಿರುಗಿ ಬಂದು, “ನಾನು ಅವಳನ್ನು ಕಾಣಲಿಲ್ಲ ಮತ್ತು ಅಲ್ಲಿ ವಿಚಾರಿಸಿದಾಗ ಆ ಊರಿನವರು ಅಲ್ಲಿ ಯಾವ ವೇಶ್ಯಾಸ್ತ್ರೀಯೂ ಇಲ್ಲವೆಂದರು” ಎಂದು ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ಅದಕ್ಕೆ ಯೆಹೂದನು, “ನಾವು ಅಪಹಾಸ್ಯಕ್ಕೆ ಒಳಗಾಗದ ಹಾಗೆ ಆ ವಸ್ತುಗಳನ್ನು ಅವಳೇ ಇಟ್ಟುಕೊಳ್ಳಲಿ. ನಾನಂತೂ ಹೋತಮರಿಯನ್ನು ಕಳುಹಿಸಿಕೊಟ್ಟೆನು. ಅವಳು ನಿನಗೆ ಸಿಕ್ಕಲಿಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ಸುಮಾರು ಮೂರು ತಿಂಗಳಾದ ಮೇಲೆ ಯೆಹೂದನಿಗೆ, “ನಿನ್ನ ಸೊಸೆಯಾದ ತಾಮಾರಳು ವ್ಯಭಿಚಾರದಿಂದ ಬಸುರಾಗಿದ್ದಾಳೆ” ಎಂಬ ವರ್ತಮಾನವನ್ನು ತಿಳಿಸಿದರು. ಆಗ ಯೆಹೂದನು, “ಆಕೆಯನ್ನು ಹೊರಗೆ ಕರತನ್ನಿರಿ, ಆಕೆಯನ್ನು ಸುಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ಆಕೆಯನ್ನು ಹೊರಕ್ಕೆ ತಂದಾಗ, ಆಕೆಯು ತನ್ನ ಮಾವನಿಗೆ, “ಈ ಸಾಮಾನುಗಳನ್ನು ಕಳುಹಿಸಿ, ಇವು ಯಾವ ಮನುಷ್ಯನದೋ, ಅವನಿಂದಲೇ ನಾನು ಗರ್ಭಿಣಿಯಾಗಿದ್ದೇನೆ. ಮುದ್ರೆ, ದಾರ, ಕೋಲು ಇವುಗಳ ಗುರುತನ್ನು ತಿಳಿಯಬಹುದು” ಎಂದು ಕೇಳಿಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ಯೆಹೂದನು ಅವುಗಳ ಗುರುತನ್ನು ತಿಳಿದು, “ನಾನು, ನನ್ನ ಮಗನಾದ ಶೇಲಹನನ್ನು ಆಕೆಗೆ ಮದುವೆ ಮಾಡಿಸಲಿಲ್ಲ. ಆದುದರಿಂದ ಆಕೆಯು ನನಗಿಂತಲೂ ನೀತಿವಂತಳು” ಎಂದು ಹೇಳಿದನು. ಅವನು ಪುನಃ ಆಕೆಯ ಸಹವಾಸ ಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ತಾಮಾರಳಿಗೆ ಹೆರಿಗೆ ಕಾಲ ಬಂದಾಗ ಆಕೆಯ ಗರ್ಭದಲ್ಲಿ ಅವಳಿ ಮಕ್ಕಳಿರುವುದು ಕಂಡುಬಂದಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ಆಕೆಯು ಹೆರುವಾಗ ಒಂದು ಮಗುವು ಮುಂದಕ್ಕೆ ಕೈಚಾಚಲು ಸೂಲಗಿತ್ತಿಯು, “ಇದು ಮೊದಲು ಹೊರಗೆ ಬಂದದ್ದು” ಎಂದು ಹೇಳಿ ಅದರ ಕೈಗೆ ಕೆಂಪು ದಾರವನ್ನು ಕಟ್ಟಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ಅದು ಕೈಯನ್ನು ಹಿಂದಕ್ಕೆ ತೆಗೆಯಲು, ಅದರೊಡನೆ ಇದ್ದ ಮತ್ತೊಂದು ಶಿಶುವು ಹೊರಗೆ ಬಂದಿತು. ಸೂಲಗಿತ್ತಿಯು ಇದನ್ನು ಕಂಡು, “ನೀನು ಛೇದಿಸಿಕೊಂಡು ಬಂದೆಯಾ?” ಎಂದು ಹೇಳಿ, ಅದಕ್ಕೆ “ಪೆರೆಚ್” ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ತರುವಾಯ ಕೈಗೆ ಕೆಂಪು ನೂಲು ಕಟ್ಟಿಸಿಕೊಂಡ ಶಿಶುವು ಹೊರಗೆ ಬಂದಿತು. ಅದಕ್ಕೆ “ಜೆರಹ” ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ಯೋಸೇಫನನ್ನು ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿದ್ದ ಇಷ್ಮಾಯೇಲರು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹೋದರು. ಅಲ್ಲಿ ಒಬ್ಬ ಐಗುಪ್ತ್ಯನು ಅವನನ್ನು ಅವರಿಂದ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡನು. ಇವನು ಫರೋಹನ ಉದ್ಯೋಗಸ್ಥನು, ಐಗುಪ್ತರ ದಂಡಿನ ಮುಖ್ಯಸ್ಥನು ಆಗಿದ್ದ ಪೋಟೀಫರನು ಎಂಬುವನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ಯೆಹೋವನು ಯೋಸೇಫನ ಸಂಗಡ ಇದ್ದುದರಿಂದ ಅವನು ಕೃತಾರ್ಥನಾದನು. ಐಗುಪ್ತನಾದ ತನ್ನ ದಣಿಯ ಮನೆಯೊಳಗೆ ಯೋಸೇಫನು ಸೇವಕನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ಯೆಹೋವನು ಯೋಸೇಫನ ಸಂಡಗವಿದ್ದು ಅವನು ಮಾಡುವ ಕೆಲಸವನ್ನೆಲ್ಲಾ ಸಫಲವಾಗುವಂತೆ ಮಾಡುತ್ತಾನೆಂದು ಅವನ ದಣಿಯು ತಿಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ಆದುದರಿಂದ ಅವನ ದಣಿಯು ಯೋಸೇಫನ ಮೇಲೆ ದಯೆ ಇಟ್ಟು, ಅವನನ್ನು ಸ್ವಂತ ಸೇವಕನನ್ನಾಗಿ ನೇಮಿಸಿಕೊಂಡನು. ಇದಲ್ಲದೆ ಆ ದಣಿಯು ಅವನಿಗೆ ತನ್ನ ಮನೆಯಲ್ಲಿ ಪಾರುಪತ್ಯವನ್ನು ಕೊಟ್ಟು ತನ್ನ ಆಸ್ತಿಯನ್ನೆಲ್ಲಾ ಅವನ ವಶಕ್ಕೆ ಒಪ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ಅವನು ಯೋಸೇಫನನ್ನು ತನ್ನ ಮನೆಯ ಮೇಲೆಯೂ, ಆಸ್ತಿಯ ಮೇಲೆಯೂ ಮೇಲ್ವಿಚಾರಕನನ್ನಾಗಿ ಇಟ್ಟಿದ್ದರಿಂದ ಯೆಹೋವನು ಯೋಸೇಫನ ನಿಮಿತ್ತವಾಗಿ ಆ ಐಗುಪ್ತನ ಮನೆಯನ್ನು ಅಭಿವೃದ್ಧಿಗೆ ತಂದನು. ಮನೆಯಲ್ಲಾಗಲಿ, ಹೊಲದಲ್ಲಾಗಲಿ ಅವನಿಗಿದ್ದ ಎಲ್ಲಾದರ ಮೇಲೆ ಯೆಹೋವನ ಆಶೀರ್ವಾದವುಂಟಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ಅವನು ತನ್ನ ಆಸ್ತಿಯನ್ನೆಲ್ಲಾ ಯೋಸೇಫನ ವಶಕ್ಕೆ ಒಪ್ಪಿಸಿದನು. ಇವನು ತನ್ನ ಬಳಿಯಲ್ಲೇ ಇದ್ದುದರಿಂದ ತಾನು ತಿನ್ನುವ ಆಹಾರ ಒಂದನ್ನೇ ಹೊರತು ಬೇರೆ ಯಾವ ವಿಷಯದಲ್ಲೂ ಚಿಂತಿಸುತ್ತಿರಲಿಲ್ಲ. ಯೋಸೇಫನು ರೂಪವಂತನೂ, ಸುಂದರನೂ ಆಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ಹೀಗಿರುವಲ್ಲಿ ಯೋಸೇಫನ ದಣಿಯ ಹೆಂಡತಿಯು ಅವನನ್ನು ಮೋಹಿಸಿ “ನನ್ನ ಸಂಗಡ ಸಂಗಮಿಸಲು ಬಾ” ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ಆದರೆ ಅವನು ಒಪ್ಪದೆ, “ನನ್ನ ದಣಿಯು ತನ್ನ ಆಸ್ತಿಯನ್ನೆಲ್ಲಾ ನನ್ನ ವಶಕ್ಕೆ ಒಪ್ಪಿಸಿರುವುದಲ್ಲದೆ ನಾನು ಇಲ್ಲಿ ಇರುವುದರಿಂದ ಮನೆಯೊಳಗೆ ನಡೆಯುವ ಯಾವ ಕೆಲಸವನ್ನೂ ಚಿಂತಿಸದೇ ಇದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ಈ ಮನೆಯಲ್ಲಿ ನನಗಿಂತ ಯಾರೂ ದೊಡ್ಡವರಲ್ಲ. ನೀನು ಅವನ ಧರ್ಮಪತ್ನಿಯಾದುದರಿಂದ ನಿನ್ನನ್ನು ಮಾತ್ರ ನನಗೆ ಅಧೀನ ಮಾಡಲಿಲ್ಲ. ಹೀಗಿರುವಲ್ಲಿ ನಾನು ಇಂಥಾ ಮಹಾ ದುಷ್ಟ ಕಾರ್ಯವನ್ನು ಮಾಡಿ ದೇವರಿಗೆ ವಿರೋಧವಾಗಿ ಹೇಗೆ ಪಾಪ ಮಾಡಲಿ?” ಎಂದು ತನ್ನ ದಣಿಯ ಹೆಂಡತಿಗೆ ಉತ್ತರ ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ಅವಳು ಯೋಸೇಫನ ಸಂಗಡ ಪ್ರತಿದಿನವೂ ಈ ಮಾತನ್ನು ಆಡಿದ್ದಾಗ್ಯೂ ಅವನು ಅದಕ್ಕೆ ಕಿವಿಗೊಡದೆ ಆಕೆಯನ್ನು ಮೋಹಿಸುವುದಕ್ಕಾಗಲಿ, ಆಕೆಯ ಬಳಿಯಲ್ಲಿರುವುದಕ್ಕಾಗಲೀ ಒಪ್ಪಿಕೊಳ್ಳಲೇ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ಹೀಗಿರಲು ಒಂದು ದಿನ ಅವನು ತನ್ನ ಕೆಲಸದ ಮೇಲೆ ಮನೆಗೆ ಬಂದಾಗ ಮನೆಯೊಳಗೆ ಯಾವ ಸೇವಕರೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ಆಕೆ ಅವನ ಬಟ್ಟೆಯನ್ನು ಹಿಡಿದುಕೊಂಡು, “ನನ್ನೊಂದಿಗೆ ಸಂಗಮಿಸಲು ಬಾ” ಎಂದು ಕರೆಯಲು, ಅವನು ತನ್ನ ಬಟ್ಟೆಯನ್ನು ಆಕೆಯ ಕೈಯಲ್ಲೇ ಬಿಟ್ಟು ತಪ್ಪಿಸಿಕೊಂಡು ಹೊರಗೆ ಓಡಿಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ಅವನು ತನ್ನ ಬಟ್ಟೆಯನ್ನು ಅವಳ ಕೈಯಲ್ಲಿ ಬಿಟ್ಟು ತಪ್ಪಿಸಿಕೊಂಡು ಹೋದದ್ದನ್ನು ಆಕೆಯು ನೋಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ಮನೆಯ ಸೇವಕರನ್ನು ಕರೆದು ಅವರಿಗೆ, “ನೋಡಿರಿ, ನನ್ನ ಯಜಮಾನನು ಒಬ್ಬ ಇಬ್ರಿಯನನ್ನು ನಮ್ಮೊಳಗೆ ಸೇರಿಸಿ ನಮ್ಮನ್ನು ಅವಮಾನಕ್ಕೆ ಗುರಿಮಾಡಿದ್ದಾನೆ. ಅವನು ನನ್ನನ್ನು ಮಾನಭಂಗಪಡಿಸುವುದಕ್ಕೆ ನನ್ನ ಹತ್ತಿರ ಬಂದನು. ನಾನು ಗಟ್ಟಿಯಾಗಿ ಕೂಗಿಕೊಂಡೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ನಾನು ಕೂಗುವುದನ್ನು ಕೇಳಿ ಅವನು ತನ್ನ ಬಟ್ಟೆಯನ್ನು ನನ್ನ ಬಳಿಯಲ್ಲೇ ಬಿಟ್ಟು ತಪ್ಪಿಸಿಕೊಂಡು ಓಡಿಹೋದನು” ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ತನ್ನ ಯಜಮಾನನು ಮನೆಗೆ ಬರುವ ತನಕ ಆಕೆಯು ಆ ಬಟ್ಟೆಯನ್ನು ತನ್ನ ಬಳಿಯಲ್ಲಿಯೇ ಇಟ್ಟುಕೊಂಡಿದ್ದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ಯಜಮಾನನು ಬಂದಾಗ ಆಕೆಯು ಅದೇ ಮಾತನ್ನು ಹೇಳಿ ಅವನಿಗೆ, “ನೀನು ನಮ್ಮಲ್ಲಿ ಸೇರಿಸಿಕೊಂಡ ಆ ಇಬ್ರಿಯ ಸೇವಕನು ನನ್ನನ್ನು ಮಾನಭಂಗಪಡಿಸುವುದಕ್ಕೆ ನನ್ನ ಬಳಿಗೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ನಾನು ಜೋರಾಗಿ ಕೂಗಿಕೊಂಡಾಗ ಅವನು ತನ್ನ ಬಟ್ಟೆಯನ್ನು ಬಿಟ್ಟು ತಪ್ಪಿಸಿಕೊಂಡು ಓಡಿಹೋದನು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ನಿನ್ನ ಸೇವಕನು ಹೀಗೆ ನನಗೆ ಮಾಡಿದನೆಂಬುದಾಗಿ ತನ್ನ ಹೆಂಡತಿ ಹೇಳಿದ ಮಾತುಗಳನ್ನು ಯೋಸೇಫನ ದಣಿಯು ಕೇಳಿದಾಗ ಬಹಳ ಸಿಟ್ಟುಗೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ಆಗ ಯೋಸೇಫನ ದಣಿಯು ಅವನನ್ನು ಹಿಡಿದು ಅರಸನ ಕೈದಿಗಳನ್ನಿಡುವ ಸೆರೆಮನೆಯಲ್ಲಿ ಹಾಕಿಸಿದನು. ಅಲ್ಲಿ ಯೋಸೇಫನು ಸೆರೆಯಲ್ಲಿ ಇರಬೇಕಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ಆದರೆ ಯೆಹೋವನು ಯೋಸೇಫನ ಸಂಗಡ ಇದ್ದು ಅವನ ಮೇಲೆ ಕರುಣೆಯನ್ನಿಟ್ಟು ಸೆರೆಮನೆಯ ಯಜಮಾನನಿಂದ ದಯೆ ದೊರಕುವಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ಸೆರೆಮನೆಯ ಯಜಮಾನನು ಸೆರೆಯಲ್ಲಿದ್ದವರೆಲ್ಲರನ್ನೂ ಯೋಸೇಫನ ವಶಕ್ಕೆ ಒಪ್ಪಿಸಿ ಅವನನ್ನು ಮೇಲ್ವಿಚಾರಕನನ್ನಾಗಿ ಮಾಡಿದನು. ಅವರು ಮಾಡಬೇಕಾದ ಎಲ್ಲ ಕೆಲಸವನ್ನು ಯೋಸೇಫನೇ ಮಾಡಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ಯೆಹೋವನು ಅವನ ಸಂಗಡ ಇದ್ದು ಅವನು ನಡಿಸಿದ್ದೆಲ್ಲವನ್ನು ಸಫಲಗೊಳಿಸಿದ್ದರಿಂದ ಅವನ ವಶಕ್ಕೆ ಒಪ್ಪಿಸಿದ್ದ ಯಾವ ವಿಷಯದ ಕುರಿತಾಗಿಯೂ ಸೆರೆಮನೆಯ ಯಜಮಾನನು ಯೋಚಿಸದೆ ನಿಶ್ಚಿಂತನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ಈ ಸಂಗತಿಗಳಾದ ಮೇಲೆ ಐಗುಪ್ತ ದೇಶದ ಅರಸನಾದ ಫರೋಹನಿಗೆ ಪಾನಗಳನ್ನು ಕೊಡುವವನೂ, ಆಹಾರಗಳನ್ನು ಮಾಡಿ ಕೊಡುವವನೂ ತಮ್ಮ ಅರಸನಿಗೆ ವಿರೋಧವಾಗಿ ಅಪರಾಧ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ಫರೋಹನು ಆ ಇಬ್ಬರು ಉದ್ಯೋಗಸ್ಥರ ಮೇಲೆ, ಅಂದರೆ ಪಾನದಾಯಕರಲ್ಲಿ ಮುಖ್ಯಸ್ಥನ ಮೇಲೆಯೂ ಅಡಿಗೆ ಭಟ್ಟರಲ್ಲಿ ಮುಖ್ಯಸ್ಥನ ಮೇಲೆಯೂ ಕೋಪಿಸಿಕೊಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ಅವರನ್ನು ಮೈಗಾವಲಿನವರ ಅಧಿಪತಿಯ ಮನೆಯೊಳಗೆ ಕಾವಲಲ್ಲಿರಿಸಿದನು. ಅದು ಯೋಸೇಫನು ಬಂಧಿಯಾಗಿದ್ದ ಸೆರೆಮನೆಯಾಗಿತ್ತು ");
INSERT INTO kanirv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ಸೆರೆಮನೆಯ ಅಧಿಪತಿಯು ಯೋಸೇಫನನ್ನು ಅವರ ಉಪಚಾರಕ್ಕೆ ನೇಮಿಸಿದ್ದರಿಂದ ಯೋಸೇಫನು ಅವರಿಗೆ ಸೇವೆ ಮಾಡುವವನಾದನು. ಹೀಗೆ ಅವರು ಕೆಲವು ಕಾಲ ಸೆರೆಯಲ್ಲಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ಐಗುಪ್ತ ಅರಸನು ಸೆರೆಯಲ್ಲಿ ಹಾಕಿಸಿದ್ದ ಪಾನದಾಯಕನಿಗೂ, ಅಡಿಗೆ ಭಟ್ಟನಿಗೂ, ಒಂದೇ ರಾತ್ರಿ ಕನಸುಬಿತ್ತು. ಅವರವರ ಕನಸಿಗೆ ಬೇರೆ ಬೇರೆ ಅರ್ಥವಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ಬೆಳಿಗ್ಗೆ ಯೋಸೇಫನು ಅವರ ಬಳಿಗೆ ಬಂದಾಗ ಅವರು ಬಹು ಚಿಂತೆಯುಳ್ಳವರಾಗಿ ಕಾಣಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ಅದನ್ನು ಅವನು ನೋಡಿ, “ನಿಮ್ಮ ಮುಖವು ಈ ಹೊತ್ತು ಏಕೆ ಕಳೆಗುಂದಿದೆ?” ಎಂದು ತನ್ನ ದಣಿಯ ಮನೆಯೊಳಗೆ ತನ್ನೊಂದಿಗೆ ಕಾವಲಲ್ಲಿದ್ದ ಫರೋಹನ ಉದ್ಯೋಗಸ್ಥರನ್ನು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ಅವರು ಅವನಿಗೆ, “ನಮಗೆ ಕನಸುಬಿತ್ತು. ಅದರ ಅರ್ಥವನ್ನು ಹೇಳುವವರು ಯಾರೂ ಇಲ್ಲ” ಎಂದು ಹೇಳಲು ಯೋಸೇಫನು ಅವರಿಗೆ, “ಕನಸುಗಳ ಅರ್ಥವು ದೇವರಿಂದ ದೊರಕಬಹುದಲ್ಲವೇ? ದಯಮಾಡಿ ನಿಮ್ಮ ಕನಸನ್ನು ನನಗೆ ತಿಳಿಸಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ಆಗ ಪಾನದಾಯಕರಲ್ಲಿ ಮುಖ್ಯಸ್ಥನು ಯೋಸೇಫನಿಗೆ, “ನನ್ನ ಕನಸಿನಲ್ಲಿ ಒಂದು ದ್ರಾಕ್ಷಾಲತೆಯನ್ನು ನನ್ನ ಮುಂದೆ ಕಂಡೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ಅದಕ್ಕೆ ಮೂರು ದ್ರಾಕ್ಷಾಲತೆಯ ಕೊಂಬೆಗಳಿದ್ದವು. ಅದು ಚಿಗುರುತ್ತಲೇ ಹೂವುಗಳನ್ನು ಬಿಟ್ಟಿತು; ಆ ಹೂವುಗಳು ಗೊಂಚಲುಗಳಾಗಿ ಹಣ್ಣಾದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ಫರೋಹನ ಪಾನಪಾತ್ರೆಯು ನನ್ನ ಕೈಯಲ್ಲಿದ್ದದರಿಂದ ನಾನು ಆ ದ್ರಾಕ್ಷಿಯ ಗೊಂಚಲುಗಳನ್ನು ಕೊಯ್ದು ಪಾತ್ರೆಯಲ್ಲಿ ಹಿಂಡಿ ಪಾತ್ರೆಯನ್ನು ಫರೋಹನ ಕೈಗೆ ಒಪ್ಪಿಸಿದೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ಅದಕ್ಕೆ ಯೋಸೇಫನು, “ಆ ಕನಸಿನ ಅರ್ಥವೇನೆಂದರೆ, ಆ ಮೂರು ದ್ರಾಕ್ಷಾಲತೆಯ ಕೊಂಬೆಗಳೇ ಮೂರು ದಿನಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ಈ ಹೊತ್ತಿಗೆ ಇನ್ನು ಮೂರು ದಿನಗಳಾದ ಮೇಲೆ ಫರೋಹನು ನಿನ್ನನ್ನು ಮೇಲಕ್ಕೆ ಎತ್ತಿ, ನಿನ್ನ ಉದ್ಯೋಗಕ್ಕೆ ಪುನಃ ನಿನ್ನನ್ನು ನೇಮಿಸುವನು. ನೀನು ಮೊದಲು ಫರೋಹನ ಪಾನದಾಯಕನಾಗಿದ್ದು ಅವನ ಕೈಗೆ ಪಾನಪಾತ್ರೆಯನ್ನು ಒಪ್ಪಿಸುತ್ತಿದ್ದಂತೆಯೇ ಮುಂದೆಯೂ ಒಪ್ಪಿಸುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ಆದರೆ ನೀನು ಸುಖದಿಂದಿರುವಾಗ ನನ್ನನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಂಡು ನನಗೆ ದಯೆ ತೋರಿಸಿ ಫರೋಹನಿಗೆ ನನ್ನ ಸಂಗತಿಯನ್ನು ತಿಳಿಸಿ ನನ್ನನ್ನು ಈ ಸೆರೆಯಿಂದ ಬಿಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ಏಕೆಂದರೆ ನಾನು ಇಬ್ರಿಯ ದೇಶದವನು. ಕೆಲವರು ನನ್ನನ್ನು ಕದ್ದು ಈ ದೇಶಕ್ಕೆ ತಂದರು. ಇಲ್ಲಿಯೂ ನಾನು ಯಾವ ತಪ್ಪು ಮಾಡದೆ ಸೆರೆಯಲ್ಲಿ ಬಿದ್ದಿರುವೆನು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ಅವನು ಹೇಳಿದ ಅರ್ಥವು ಶುಭಕರವಾದದ್ದೆಂದು ಅಡಿಗೆಭಟ್ಟರಲ್ಲಿ ಮುಖ್ಯಸ್ಥನು ತಿಳಿದು ಯೋಸೇಫನಿಗೆ, ನಾನೂ ಕಂಡ ಕನಸನ್ನು ಹೇಳುತ್ತೇನೆ ಕೇಳು, “ನನಗೆ ಬಿದ್ದ ಕನಸಿನಲ್ಲಿ ಸೊಗಸಾದ ರೊಟ್ಟಿ ಪದಾರ್ಥಗಳು ತುಂಬಿದ್ದ ಮೂರು ಪುಟ್ಟಿಗಳು ನನ್ನ ತಲೆಯ ಮೇಲಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ಮೇಲಿನ ಪುಟ್ಟಿಯಲ್ಲಿ ಫರೋಹನಿಗೋಸ್ಕರ ಎಲ್ಲಾ ವಿಧವಾದ ರೊಟ್ಟಿ ಪದಾರ್ಥಗಳು ಇದ್ದವು. ಪಕ್ಷಿಗಳು ಬಂದು ಅವುಗಳನ್ನು ನನ್ನ ತಲೆಯ ಮೇಲಿದ್ದ ಪುಟ್ಟಿಯೊಳಗಿಂದಲೇ ತಿಂದುಹಾಕಿದವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ಅದಕ್ಕೆ ಯೋಸೇಫನು, “ನಿನ್ನ ಕನಸಿನ ಅರ್ಥವೇನೆಂದರೆ, ಆ ಮೂರು ಪುಟ್ಟಿಗಳೇ ಮೂರು ದಿನಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ಈ ಹೊತ್ತಿಗೆ ಮೂರು ದಿನಗಳೊಳಗೆ ಫರೋಹನು ನಿನ್ನ ತಲೆಯನ್ನು ತೆಗೆಸುವನು, ನಿನ್ನನ್ನು ಮರಕ್ಕೆ ತೂಗು ಹಾಕಿಸುವನು, ಪಕ್ಷಿಗಳು ಬಂದು ನಿನ್ನ ಮಾಂಸವನ್ನು ತಿಂದುಬಿಡುವವು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಫರೋಹನ ಜನ್ಮ ದಿನವಾದುದರಿಂದ ಅವನು ತನ್ನ ಸೇವಕರೆಲ್ಲರಿಗೆ ಔತಣವನ್ನು ಮಾಡಿಸಿ ಮುಖ್ಯಪಾನದಾಯಕನನ್ನೂ ಮತ್ತು ಮುಖ್ಯ ಅಡಿಗೆಭಟ್ಟನನ್ನು ಬಿಡಿಸಿ ಸೇವಕರ ಮಧ್ಯದಲ್ಲಿ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ಪಾನದಾಯಕರ ಮುಖ್ಯಸ್ಥನನ್ನು ಪುನಃ ಅವನ ಉದ್ಯೋಗಕ್ಕೆ ನೇಮಿಸಿದನು. ಅವನು ಪಾನ ಪಾತ್ರೆಯನ್ನು ಫರೋಹನ ಕೈಗೆ ಕೊಡುವವನಾದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ಆದರೆ ಮುಖ್ಯ ಅಡಿಗೆಭಟ್ಟನನ್ನು ಫರೋಹನು ಗಲ್ಲಿಗೆ ಹಾಕಿಸಿದನು. ಹೀಗೆ ಯೋಸೇಫನು ಹೇಳಿದಂತೆಯೇ ಆಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ಆದಾಗ್ಯೂ ಮುಖ್ಯಪಾನದಾಯಕನು ಯೋಸೇಫನನ್ನು ನೆನಪುಮಾಡಿಕೊಳ್ಳದೆ ಅವನನ್ನು ಮರೆತುಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ಎರಡು ವರ್ಷಗಳು ಕಳೆದ ಮೇಲೆ ಫರೋಹನಿಗೆ ಕನಸುಬಿತ್ತು. ಆ ಕನಸಿನಲ್ಲಿ ಅವನು ನೈಲ್ ನದಿಯ ತೀರದಲ್ಲಿ ನಿಂತಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ಅಷ್ಟರಲ್ಲಿ ಲಕ್ಷಣವಾದ ಏಳು ಕೊಬ್ಬಿದ ಆಕಳುಗಳು ಆ ನೈಲ್ ನದಿಯೊಳಗಿಂದ ಬಂದು ಹುಲ್ಲುಗಾವಲಲ್ಲಿ ಮೇಯುತ್ತಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ಅವುಗಳ ಹಿಂದೆ ಅವಲಕ್ಷಣವಾದ ಹಾಗೂ ಬಡಕಲಾದ ಏಳು ಆಕಳುಗಳು ನೈಲ್ ನದಿಯೊಳಗಿಂದ ಬಂದು ಮೊದಲು ಕಾಣಿಸಿದ ಆಕಳುಗಳ ಹತ್ತಿರ ನದಿಯ ತೀರದಲ್ಲಿ ನಿಂತವು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ಅವಲಕ್ಷಣವಾದ ಈ ಬಡ ಏಳು ಆಕಳುಗಳು ಲಕ್ಷಣವಾದ ಆ ಕೊಬ್ಬಿದ ಆಕಳುಗಳನ್ನು ತಿಂದು ಬಿಟ್ಟವು. ಆಗ ಫರೋಹನಿಗೆ ಎಚ್ಚರವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ಅವನು ಮತ್ತೆ ನಿದ್ರೆಮಾಡಿದಾಗ ಮತ್ತೊಂದು ಕನಸು ಬಿತ್ತು. ಅದೇನೆಂದರೆ, ಒಳ್ಳೆಯ ಪುಷ್ಟಿಯುಳ್ಳ ಏಳು ತೆನೆಗಳು ಒಂದೇ ದಂಟಿನಲ್ಲಿ ಹುಟ್ಟಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ಅವುಗಳ ಹಿಂದೆ ಮೂಡಣ ಗಾಳಿಯಿಂದ ಬತ್ತಿ ಒಣಗಿಹೋಗಿದ್ದ ಬೇರೆ ಏಳು ತೆನೆಗಳು ಮೊಳೆತು ಬಂದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ಆ ಬತ್ತಿ ಹೋಗಿದ್ದ ಈ ತೆನೆಗಳು ಆ ಏಳು ಪುಷ್ಟಿಯುಳ್ಳ ತೆನೆಗಳನ್ನು ನುಂಗಿಬಿಟ್ಟವು. ಆಗ ಫರೋಹನು ಎಚ್ಚೆತ್ತು, ಅದನ್ನು ಕನಸೆಂದು ತಿಳಿದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ಬೆಳಿಗ್ಗೆ ಫರೋಹನು ಮನದಲ್ಲಿ ಕಳವಳಗೊಂಡು, ಐಗುಪ್ತದೇಶದಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಜೋಯಿಸರನ್ನೂ, ವಿದ್ವಾಂಸರನ್ನೂ ಬರುವಂತೆ ಹೇಳಿಕಳುಹಿಸಿದನು. ಅವರಿಗೆ ತನ್ನ ಕನಸನ್ನು ತಿಳಿಸಲಾಗಿ, ಅದರ ಅರ್ಥವನ್ನು ಅವನಿಗೆ ಹೇಳ ಬಲ್ಲವರು ಅವರಲ್ಲಿ ಒಬ್ಬನೂ ಸಿಕ್ಕಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ಹೀಗಿರುವಾಗ ಪಾನದಾಯಕರಲ್ಲಿ ಮುಖ್ಯಸ್ಥನು ಫರೋಹನಿಗೆ, “ಅರಸನೇ, ಈ ಹೊತ್ತು ನನ್ನ ತಪ್ಪುಗಳನ್ನು ಜ್ಞಾಪಕ ಮಾಡಿಕೊಳ್ಳುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ಫರೋಹನು ತಮ್ಮ ಸೇವಕರ ಮೇಲೆ ಸಿಟ್ಟುಗೊಂಡು ನನ್ನನ್ನೂ, ಅಡಿಗೆ ಭಟ್ಟರಲ್ಲಿ ಮುಖ್ಯಸ್ಥನನ್ನೂ ಮೈಗಾವಲಿನವರ ಅಧಿಪತಿಯ ಮನೆಯೊಳಗೆ ಕಾವಲಲ್ಲಿ ಇಟ್ಟಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ನಮ್ಮಿಬ್ಬರಿಗೂ ಒಂದೇ ರಾತ್ರಿಯಲ್ಲಿ ಕನಸುಬಿತ್ತು. ಒಬ್ಬೊಬ್ಬನ ಕನಸಿಗೆ ಬೇರೆ ಬೇರೆ ಅರ್ಥವಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ಅಲ್ಲಿ ನಮ್ಮ ಸಂಗಡ ಇಬ್ರಿಯನಾದ ಒಬ್ಬ ಪ್ರಾಯಸ್ಥನಿದ್ದನು. ಅವನು ಮೈಗಾವಲಿನವರ ಅಧಿಪತಿಯ ಸೇವಕನು. ನಾವು ಅವನಿಗೆ ನಮ್ಮ ಕನಸುಗಳನ್ನು ತಿಳಿಸಿದಾಗ ಅವನು ಅವುಗಳ ಅರ್ಥವನ್ನು ನಮಗೆ ತಿಳಿಸಿದನು. ನಮ್ಮ ನಮ್ಮ ಕನಸಿನ ಪ್ರಕಾರ ಅರ್ಥವನ್ನು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ಮಾತ್ರವಲ್ಲದೆ ಅವನು ನಮಗೆ ಹೇಳಿದ ಅರ್ಥಕ್ಕೆ ಸರಿಯಾಗಿ ಕಾರ್ಯವು ನಡೆಯಿತು. ಅವನು ಹೇಳಿದಂತೆಯೇ ನನ್ನ ಉದ್ಯೋಗವು ಪುನಃ ನನಗೆ ದೊರಕಿತು. ಅಡಿಗೆ ಭಟ್ಟರ ಮುಖ್ಯಸ್ಥನೋ ಗಲ್ಲಿಗೆ ಹಾಕಲ್ಪಟ್ಟನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ಫರೋಹನು ಇದನ್ನು ಕೇಳಿದಾಗ ಯೋಸೇಫನನ್ನು ಕರೆದುಕೊಂಡು ಬರಲು ಹೇಳಿಕಳುಹಿಸಿದನು. ಯೋಸೇಫನನು ಬೇಗನೆ ಸೆರೆಮನೆಯಿಂದ ಬಿಡುಗಡೆ ಮಾಡಿದರು. ಆತನು ಕ್ಷೌರಮಾಡಿಸಿಕೊಂಡು ಬಟ್ಟೆ ಬದಲಾಯಿಸಿಕೊಂಡು ಫರೋಹನ ಸನ್ನಿಧಿಗೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ಆಗ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನಾನು ಒಂದು ಕನಸನ್ನು ಕಂಡಿದ್ದೇನೆ. ಅದರ ಅರ್ಥವನ್ನು ಹೇಳ ಬಲ್ಲವರು ಯಾರೂ ಇಲ್ಲ. ಆದರೆ ನೀನು ಕನಸನ್ನು ಕೇಳುತ್ತಲೇ ಅದರ ಅರ್ಥವನ್ನು ಹೇಳ ಬಲ್ಲವನೆಂಬ ವರ್ತಮಾನವನ್ನು ಕೇಳಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ಅದಕ್ಕೆ ಯೋಸೇಫನು, “ನನ್ನಲ್ಲಿ ಅಂಥ ಸಾಮರ್ಥ್ಯವೇನೂ ಇಲ್ಲ. ಆದರೆ ದೇವರು ಫರೋಹನಿಗೆ ಶುಭಕರವಾದ ಉತ್ತರವನ್ನೂ ಕೊಡುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ಆಗ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನನ್ನ ಕನಸಿನೊಳಗೆ ನಾನು ನೈಲ್ ನದಿಯ ತೀರದಲ್ಲಿ ನಿಂತುಕೊಂಡಿದ್ದೆನು.” ");
INSERT INTO kanirv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ನೈಲ್ ನದಿಯೊಳಗಿಂದ ಲಕ್ಷಣವಾದ ಏಳು ಕೊಬ್ಬಿದ ಆಕಳುಗಳು ಬಂದು ಹುಲ್ಲುಗಾವಲಲ್ಲಿ ಮೇಯುತ್ತಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ಅವುಗಳ ಹಿಂದೆ ಅವಲಕ್ಷಣವಾದ ಕೊಬ್ಬಿಲ್ಲದ ಬಡಕಲಾದ ಆಕಳುಗಳು ಏರಿ ಬಂದವು. ಇಂಥ ಆಕಳುಗಳನ್ನು ನಾನು ಐಗುಪ್ತದೇಶದಲ್ಲಿ ಎಲ್ಲಿಯೂ ನೋಡಿರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ಅದಲ್ಲದೆ ಅವಲಕ್ಷಣವಾದ ಆ ಬಡ ಆಕಳುಗಳು ಮೊದಲು ಕಾಣಿಸಿದ ಆ ಏಳು ಕೊಬ್ಬಿದ ಆಕಳುಗಳನ್ನು ತಿಂದು ಬಿಟ್ಟವು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ಇವು ಅವುಗಳನ್ನು ತಿಂದ ಮೇಲೂ ಅವು ತಿಂದ ಹಾಗೆ ತೋರಿಬರಲಿಲ್ಲ. ಅವು ಮೊದಲಿದ್ದಂತೆ ಬಡವಾಗಿಯೇ ಇದ್ದವು. ಆಗ ನನಗೆ ಎಚ್ಚರವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“ನನಗೆ ಬಿದ್ದ ಇನ್ನೊಂದು ಕನಸಿನೊಳಗೆ ಏಳು ಒಳ್ಳೆ ಪುಷ್ಟಿಯುಳ್ಳ ತೆನೆಗಳು ಒಂದೇ ದಂಟಿನಲ್ಲಿ ಹುಟ್ಟಿ ಬಂದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ಅವುಗಳ ಹಿಂದೆ ಮೂಡಣ ಗಾಳಿಯಿಂದ ಬತ್ತಿ ಒಣಗಿ ಹೋಗಿದ್ದ ಬೇರೆ ಏಳು ತೆನೆಗಳು ಮೊಳೆತು ಬಂದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ಬತ್ತಿ ಹೋಗಿದ್ದ ತೆನೆಗಳು ಆ ಏಳು ಒಳ್ಳೆ ತೆನೆಗಳನ್ನು ನುಂಗಿಬಿಟ್ಟವು. ಈ ಕನಸುಗಳನ್ನು ಜೋಯಿಸರಿಗೆ ತಿಳಿಸಿದೆನು. ಆದರೆ ಅವುಗಳ ಅರ್ಥವನ್ನು ವಿವರಿಸಿ ಹೇಳುವುದಕ್ಕೆ ಯಾರಿಂದಲೂ ಆಗಲಿಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ಯೋಸೇಫನು ಫರೋಹನಿಗೆ, “ತಾವು ಕಂಡ ಎರಡು ಕನಸುಗಳು ಒಂದೇಯಾಗಿದೆ. ದೇವರು ತಾನು ಮಾಡಬೇಕೆಂದಿರುವುದನ್ನು ಇವುಗಳ ಮೂಲಕ ತಮಗೆ ತಿಳಿಸಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ಆ ಏಳು ಒಳ್ಳೆ ಆಕಳುಗಳು ಏಳು ವರ್ಷಗಳು ಆ ಏಳು ಒಳ್ಳೆ ತೆನೆಗಳು ಏಳು ವರ್ಷಗಳು. ಎರಡು ಕನಸುಗಳ ಅರ್ಥ ಒಂದೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ಒಳ್ಳೆ ಆಕಳುಗಳ ಹಿಂದೆ ಬಂದ ಅವಲಕ್ಷಣವಾದ ಬಡ ಆಕಳುಗಳೂ ಮೂಡಣ ಗಾಳಿಯಿಂದ ಬತ್ತಿ ಹೋಗಿದ್ದ ಆ ಏಳು ತೆನೆಗಳೂ ಬರವುಂಟಾಗುವ ಏಳು ವರ್ಷಗಳನ್ನು ಸೂಚಿಸುತ್ತವೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ದೇವರು ತಾನು ಮಾಡಬೇಕೆಂದಿರುವುದನ್ನು ಫರೋಹನಿಗೆ ತಿಳಿಸಿದ್ದಾನೆ ಎಂಬುದಾಗಿ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಬಹು ವಿಶೇಷವಾದ ಏಳು ಸುಭಿಕ್ಷ ವರ್ಷಗಳೂ ಬರುವವು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ಅವುಗಳ ತರುವಾಯ ಏಳು ದುರ್ಭಿಕ್ಷ ವರ್ಷಗಳೂ ಬರುವವು. ಆಗ ಐಗುಪ್ತದವರು ಮೊದಲಿದ್ದ ಸುಭಿಕ್ಷವನ್ನು ಮರೆತುಬಿಡುವರು. ಆ ಬರದಿಂದ ದೇಶವು ಹಾಳಾಗಿ ಹೋಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ಮುಂದೆ ಬರುವ ಕ್ಷಾಮವು ಅತ್ಯಂತ ಘೋರವಾಗಿರುವುದರಿಂದ ಮೊದಲಿದ್ದ ಸಮೃದ್ಧಿಯ ಗುರುತೇ ಕಾಣಿಸದೆ ಹೋಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ಫರೋಹನಿಗೆ ಕನಸು ಎರಡು ರೀತಿಯಾಗಿ ಬಿದ್ದಿದ್ದರಿಂದ ದೇವರು ಈ ಕಾರ್ಯವನ್ನು ನಿಶ್ಚಯಿಸಿ ಇದನ್ನು ಬೇಗ ಮಾಡುವನು ಎಂಬುದಾಗಿ ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ಆದುದರಿಂದ ಫರೋಹನು ವಿವೇಕಿಯೂ, ಬುದ್ಧಿವಂತನೂ ಆಗಿರುವ ಪುರುಷನನ್ನು ಆರಿಸಿಕೊಂಡು ಅವನನ್ನು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಅಧಿಕಾರಿಯಾಗಿ ನೇಮಿಸಬೇಕು, ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ಫರೋಹನು ಐಗುಪ್ತ ದೇಶದ ಎಲ್ಲಾ ಭಾಗಗಳಲ್ಲಿಯೂ ಅಧಿಕಾರಿಗಳನ್ನು ನೇಮಿಸಿ ಅವರ ಕೈಯಿಂದ ಸುಭಿಕ್ಷವಾದ ಏಳು ವರ್ಷಗಳಲ್ಲಿ ದೇಶದ ಬೆಳೆಯೊಳಗೆ ಐದರಲ್ಲಿ ಒಂದು ಪಾಲನ್ನು ಕಂದಾಯವಾಗಿ ಎತ್ತಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ಅವರು ಮುಂದೆ ಬರುವ ಒಳ್ಳೆಯ ವರ್ಷಗಳಲ್ಲಿ ಆಹಾರ ಪದಾರ್ಥಗಳನ್ನು, ದವಸಧಾನ್ಯಗಳನ್ನೂ ಶೇಖರಿಸಿ ಫರೋಹನ ವಶದೊಳಗೆ ಪಟ್ಟಣಗಳಲ್ಲಿಟ್ಟು ಕಾಯಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ಆ ಆಹಾರ ಪದಾರ್ಥಗಳನ್ನು ಶೇಖರಿಸಿಕೊಳ್ಳುವುದರಿಂದ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಉಂಟಾಗುವ ಏಳು ವರ್ಷಗಳ ಬರಗಾಲದಲ್ಲಿ ಜನರು ಸಾಯುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ಆ ಮಾತು ಫರೋಹನಿಗೂ ಅವನ ಸೇವಕರಿಗೂ ಒಳ್ಳೇದಾಗಿ ತೋರಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ಫರೋಹನು ತನ್ನ ಸೇವಕರಿಗೆ, “ಇವನಲ್ಲಿ ದೇವರ ಆತ್ಮ ಉಂಟಲ್ಲಾ. ಇಂಥ ಯೋಗ್ಯನಾದ ಪುರುಷನು ನಮಗೆ ಸಿಕ್ಕಾನೋ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ದೇವರು ಇದನ್ನೆಲ್ಲಾ ನಿನಗೆ ತಿಳಿಸಿರುವುದರಿಂದ ನಿನಗೆ ಸಮಾನನಾದ ಬುದ್ಧಿ, ವಿವೇಕವುಳ್ಳ ಪುರುಷನು ಯಾರೂ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ನೀನೇ ಅರಮನೆಯಲ್ಲಿ ಸರ್ವಾಧಿಕಾರಿಯಾಗಿರಬೇಕು. ನಿನ್ನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಪ್ರಜೆಗಳೆಲ್ಲರೂ ನಡೆದುಕೊಳ್ಳಬೇಕು. ಸಿಂಹಾಸನದ ವಿಷಯದಲ್ಲಿ ಮಾತ್ರ ನಾನು ನಿನಗಿಂತ ದೊಡ್ಡವನಾಗಿರುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನೋಡು ಐಗುಪ್ತ ದೇಶದ ಮೇಲೆಲ್ಲಾ ನಿನ್ನನ್ನು ಅಧಿಕಾರಿಯನ್ನಾಗಿ ನೇಮಿಸಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ಫರೋಹನು ತನ್ನ ಕೈಯಿಂದ ಉಂಗುರವನ್ನು ತೆಗೆದು ಯೋಸೇಫನ ಬೆರಳಿಗೆ ತೊಡಿಸಿ ಅವನಿಗೆ ನಾರುಮಡಿಯನ್ನು ಹೊದಿಸಿ ಅವನ ಕೊರಳಿಗೆ ಚಿನ್ನದ ಸರವನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ತನಗಿದ್ದ ಎರಡನೇ ರಥದಲ್ಲಿ ಅವನನ್ನು ಕುಳ್ಳಿರಿಸಿ, “ಅವನ ಮುಂದೆ ಅಡ್ಡ ಬೀಳಿರಿ” ಎಂದು ಪ್ರಕಟಣೆ ಹೊರಡಿಸಿ ಅವನನ್ನು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಸರ್ವಾಧಿಕಾರಿಯನ್ನಾಗಿ ಇಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ಅಲ್ಲದೆ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನಾನು ಫರೋಹನು. ನಿನ್ನ ಅಪ್ಪಣೆಯಿಲ್ಲದೆ ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಒಬ್ಬನೂ ಕೈಯನ್ನಾಗಲಿ, ಕಾಲನ್ನಾಗಲಿ ಕದಲಿಸಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ಇದಲ್ಲದೆ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ “ಸಾಫ್ನತ್ಪನ್ನೇಹ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ತರುವಾಯ ಓನನ ಯಾಜಕನಾದ ಪೋಟೀಫೆರನ ಮಗಳಾದ ಆಸನತ್ ಎಂಬಾಕೆಯನ್ನು ಅವನಿಗೆ ಮದುವೆಮಾಡಿಸಿದನು. ಯೋಸೇಫನು ಐಗುಪ್ತದೇಶದ ಮೇಲೆ ಅಧಿಕಾರಿಯಾಗಿ ದೇಶದಲ್ಲೆಲ್ಲಾ ಸಂಚರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ಯೋಸೇಫನು ಐಗುಪ್ತ ದೇಶದ ಅರಸನಾದ ಫರೋಹನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಂತಾಗ ಮೂವತ್ತು ವರ್ಷದವನಾಗಿದ್ದನು. ಅವನು ಫರೋಹನ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಟು ಐಗುಪ್ತದೇಶದಲ್ಲೆಲ್ಲಾ ಸಂಚಾರಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ಸುಭಿಕ್ಷವಾದ ಏಳು ವರ್ಷಗಳಲ್ಲಿ ಭೂಮಿಯು ಹೇರಳವಾಗಿ ಫಲಕೊಟ್ಟಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ಐಗುಪ್ತದೇಶದಲ್ಲಿ ಸುಭಿಕ್ಷವಾದ ಆ ಏಳು ವರ್ಷಗಳ ಬೆಳೆಯನ್ನು ಯೋಸೇಫನು ಕೂಡಿಸಿ ಪಟ್ಟಣಗಳಲ್ಲಿ ಶೇಖರಿಸಿ ಇಡುವ ವ್ಯವಸ್ಥೆಮಾಡಿದನು. ಒಂದೊಂದು ಪಟ್ಟಣದ ಸುತ್ತಲೂ ಹೊಲಗಳ ಬೆಳೆಯನ್ನು ಆಯಾ ಪಟ್ಟಣದಲ್ಲಿಯೇ ಶೇಖರಿಸಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ಯೋಸೇಫನು ದವಸಧಾನ್ಯವನ್ನು ಸಮುದ್ರ ತೀರದ ಮರಳಿನಂತೆ ರಾಶಿರಾಶಿಯಾಗಿ ಶೇಖರಿಸಿ ಲೆಕ್ಕ ಮಾಡುವುದನ್ನು ಬಿಟ್ಟುಬಿಟ್ಟನು. ಅದನ್ನು ಲೆಕ್ಕ ಮಾಡುವುದಕ್ಕೆ ಆಗದೇ ಹೋಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ಬರಗಾಲ ಬರುವುದಕ್ಕಿಂತ ಮೊದಲು ಯೋಸೇಫನಿಗೆ ಇಬ್ಬರು ಗಂಡು ಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ಇವರು ಓನ್ ಪಟ್ಟಣದ ಯಾಜಕನಾದ ಪೋಟೀಫೆರನ ಮಗಳಾದ ಆಸನತ್ ಎಂಬಾಕೆಯಲ್ಲಿ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ಚೊಚ್ಚಲು ಮಗನು ಹುಟ್ಟಿದಾಗ ಯೋಸೇಫನು, “ನಾನು ನನ್ನ ಎಲ್ಲಾ ಕಷ್ಟವನ್ನು, ತಂದೆಯ ಮನೆಯವರನ್ನೂ ಮರೆತುಬಿಡುವಂತೆ ದೇವರು ಮಾಡಿದನು” ಎಂದು ಹೇಳಿ ಅವನಿಗೆ “ಮನಸ್ಸೆ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ಎರಡನೆಯ ಮಗನು ಹುಟ್ಟಿದಾಗ, “ನನಗೆ ಸಂಕಟ ಬಂದ ದೇಶದಲ್ಲೇ ದೇವರು ಅಭಿವೃದ್ಧಿಯನ್ನು ದಯಪಾಲಿಸಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿ ಆ ಮಗನಿಗೆ “ಎಫ್ರಾಯೀಮ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಸುಭಿಕ್ಷದ ಏಳು ವರ್ಷಗಳು ಮುಗಿದ ತರುವಾಯ ");
INSERT INTO kanirv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ಯೋಸೇಫನು ಹೇಳಿದ ಪ್ರಕಾರ ಕ್ಷಾಮದ ಏಳು ವರ್ಷಗಳು ಪ್ರಾರಂಭವಾಯಿತು. ಬರವು ಸುತ್ತಲಿರುವ ಎಲ್ಲಾ ದೇಶಗಳಲ್ಲಿಯೂ ಹಬ್ಬಿತು. ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಮಾತ್ರ ಆಹಾರವಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಬರ ಬಂದಾಗ ಪ್ರಜೆಗಳು ಆಹಾರ ಬೇಕೆಂದು ಫರೋಹನಿಗೆ ಮೊರೆಯಿಟ್ಟರು. ಅವನು ಅವರಿಗೆ, “ಯೋಸೇಫನ ಬಳಿಗೆ ಹೋಗಿರಿ, ಅವನು ಹೇಳಿದಂತೆ ಮಾಡಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ಬರವು ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಹರಡಿಕೊಂಡಿದಾಗ ಯೋಸೇಫನು ಕಣಜಗಳನ್ನೆಲ್ಲಾ ತೆಗೆದು ಐಗುಪ್ತರಿಗೆ ಧಾನ್ಯವನ್ನು ಮಾರಿದನು. ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಬರವು ಬಹುಘೋರವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ಇದಲ್ಲದೆ ಭೂಮಿಯಲ್ಲೆಲ್ಲಾ ಬರವು ಬಹುಘೋರವಾಗಿದುದರಿಂದ ಎಲ್ಲಾ ದೇಶದವರೂ ಧಾನ್ಯವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಐಗುಪ್ತಕ್ಕೆ ಯೋಸೇಫನ ಬಳಿಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ದವಸಧಾನ್ಯವುಂಟೆಂದು ಯಾಕೋಬನು ತಿಳಿದಾಗ ತನ್ನ ಮಕ್ಕಳಿಗೆ, “ನೀವು ಒಬ್ಬರನ್ನೊಬ್ಬರು ನೋಡಿಕೊಂಡಿರುವುದೇಕೆ?” ");
INSERT INTO kanirv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","“ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ದವಸಧಾನ್ಯ ಉಂಟೆಂಬುದನ್ನು ಕೇಳಿದ್ದೇನೆ. ನಾವು ಸಾಯದೆ ಬದುಕುವಂತೆ ನೀವು ಅಲ್ಲಿಗೆ ಹೋಗಿ ಬೇಕಾದ ದವಸವನ್ನು ಖರೀದಿಸಿಕೊಂಡು ಬನ್ನಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ಯೋಸೇಫನ ಹತ್ತು ಮಂದಿ ಅಣ್ಣಂದಿರು ಧಾನ್ಯವನ್ನು ಖರೀದಿಸಿಕೊಂಡು ತರುವುದಕ್ಕಾಗಿ ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ಆದರೆ ಯಾಕೋಬನು ಯೋಸೇಫನ ತಮ್ಮನಾದ ಬೆನ್ಯಾಮೀನನಿಗೆ “ಕೇಡು ಉಂಟಾದೀತೆಂದು” ಹೇಳಿ ಅಣ್ಣಂದಿರ ಜೊತೆಯಲ್ಲಿ ಕಳುಹಿಸಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ಧಾನ್ಯವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೋಸ್ಕರ ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಬಂದವರಲ್ಲಿ ಇಸ್ರಾಯೇಲನ ಮಕ್ಕಳೂ ಇದ್ದರು, ಏಕೆಂದರೆ ಕಾನಾನ್ ದೇಶದಲ್ಲಿಯೂ ಬರವಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ಐಗುಪ್ತ ದೇಶದ ಮೇಲೆ ಅಧಿಕಾರವನ್ನು ನಡಿಸಿ ಜನರಿಗೆ ಧಾನ್ಯವನ್ನು ಮಾರುವವನು ಯೋಸೇಫನೇ ಆಗಿದ್ದನು. ಹೀಗಿರುವುದರಿಂದ ಅವನ ಅಣ್ಣಂದಿರು ಬಂದು ಅವನ ಮುಂದೆಯೇ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ಯೋಸೇಫನು ಅವರನ್ನು ಕಂಡಾಗ ಅವರ ಗುರುತು ಹಿಡಿದು ತನ್ನ ಅಣ್ಣಂದಿರೆಂದು ತಿಳಿದರೂ ಅವರಿಗೆ ಅನ್ಯನಂತೆ ತೋರ್ಪಡಿಸಿಕೊಂಡು ಕಠಿಣ ನುಡಿಯಿಂದ, “ನೀವು ಎಲ್ಲಿಂದ ಬಂದವರು” ಎಂದು ಕೇಳಿದನು. ಅವರು, “ಧಾನ್ಯವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೊಸ್ಕರ ಕಾನಾನ್ ದೇಶದಿಂದ ಬಂದಿದ್ದೇವೆ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ಅಣ್ಣಂದಿರ ಗುರುತು ಯೋಸೇಫನಿಗೆ ತಿಳಿದಿದ್ದರೂ ಅವನ ಗುರುತು ಅವರಿಗೆ ತಿಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ಯೋಸೇಫನು ಅವರ ವಿಷಯದಲ್ಲಿ ತನಗೆ ಬಿದ್ದ ಕನಸುಗಳನ್ನು ನೆನಪಿಗೆ ತಂದುಕೊಂಡನು. ಅವರಿಗೆ ಅವನು, “ನೀವು ಗೂಢಚಾರರು. ನಮ್ಮ ದೇಶದ ಭದ್ರತೆಯಿಲ್ಲದ ಸ್ಥಳಗಳನ್ನು ನೋಡುವುದಕ್ಕಾಗಿ ಬಂದವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ಅದಕ್ಕೆ ಅವರು, “ಇಲ್ಲ ಸ್ವಾಮಿ, ತಮ್ಮ ಸೇವಕರಾದ ನಾವು ಆಹಾರ ಪದಾರ್ಥಗಳನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಬಂದಿದ್ದೇವೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ನಾವೆಲ್ಲರೂ ಒಬ್ಬನೇ ತಂದೆಯ ಮಕ್ಕಳು. ನಾವು ಸತ್ಯವಂತರಾಗಿದ್ದೇವೆ ಹೊರತು ಗೂಢಚಾರರಲ್ಲ” ಅಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ಅವನು ಅವರಿಗೆ, “ಇಲ್ಲ, ನಮ್ಮ ದೇಶದ ಭದ್ರತೆಯಿಲ್ಲದ ಸ್ಥಳಗಳನ್ನು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕೆ ಬಂದ್ದಿದೀರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ಅದಕ್ಕೆ ಅವರು, “ತಮ್ಮ ಸೇವಕರಾದ ನಾವು ಹನ್ನೆರಡು ಮಂದಿ ಅಣ್ಣತಮ್ಮಂದಿರು, ನಾವು ಕಾನಾನ್ ದೇಶದವರು, ಒಬ್ಬ ತಂದೆಯ ಮಕ್ಕಳು. ನಮ್ಮಲ್ಲಿ ಚಿಕ್ಕವನು ತಂದೆಯ ಬಳಿಯಲ್ಲಿದ್ದಾನೆ. ಮತ್ತೊಬ್ಬನು ಇಲ್ಲ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ಯೋಸೇಫನು ಅವರಿಗೆ, “ನಾನು ಈಗಾಗಲೇ ಹೇಳಿದಂತೆ ನೀವು ಗೂಢಚಾರರೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ನೀವು ಪರೀಕ್ಷಿಸಲ್ಪಡುವುದು ಹೇಗೆಂದರೆ, ನಿಮ್ಮ ಚಿಕ್ಕ ತಮ್ಮನು ಬರಬೇಕು. ಅವನು ಬಂದ ಹೊರತು ಫರೋಹನ ಜೀವದಾಣೆ ನೀವು ಇಲ್ಲಿಂದ ಹೊರಟು ಹೋಗಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ಅವನನ್ನು ಕರೆದುಕೊಂಡು ಬರುವುದಕ್ಕೆ ನಿಮ್ಮಲ್ಲಿ ಒಬ್ಬನನ್ನು ಕಳುಹಿಸಿರಿ. ಅವನು ಬರುವವರೆಗೂ ನಿಮ್ಮನ್ನು ಸೆರೆಯಲ್ಲಿ ಇಡುತ್ತೇನೆ. ಹೀಗೆ ನಾನು ನಿಮ್ಮ ಮಾತುಗಳನ್ನು ಪರೀಕ್ಷಿಸಿ ನೀವು ಸತ್ಯವಂತರೋ ಅಲ್ಲವೋ ಎಂದು ತಿಳಿದುಕೊಳ್ಳುತ್ತೇನೆ. ನಿಮ್ಮ ತಮ್ಮನು ಬಾರದೆ ಹೋದರೆ ಫರೋಹನ ಜೀವದಾಣೆ ನೀವು ಗೂಢಚಾರರೇ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ಅವರೆಲ್ಲರನ್ನು ಅವನು, ಮೂರು ದಿನ ಕಾವಲಿನಲ್ಲಿರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಯೋಸೇಫನು ಅವರಿಗೆ, “ನಾನು ದೇವರಿಗೆ ಭಯಪಡುವವನು. ನೀವು ಸತ್ಯವಂತರಾಗಿದ್ದರೆ ಒಂದು ಕೆಲಸವನ್ನು ಮಾಡಿ ಬದುಕಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ನಿಮ್ಮಲ್ಲಿ ಒಬ್ಬನನ್ನು ಮಾತ್ರ ಸೆರೆಯಲ್ಲಿರಿಸುತ್ತೇನೆ. ಮಿಕ್ಕವರು ನಿಮ್ಮ ಮನೆಯವರಿಗೆ ಧಾನ್ಯವನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ನಿಮ್ಮ ತಮ್ಮನನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು. ಕರೆದುಕೊಂಡು ಬಂದರೆ ನಿಮ್ಮ ಮಾತನ್ನು ಸತ್ಯವೆಂದು ನಾನು ತಿಳಿದುಕೊಳ್ಳುವುದರಿಂದ ನೀವು ಸಾಯುವುದಿಲ್ಲ” ಎಂದನು. ಅವರು ಹಾಗೆಯೇ ಮಾಡಲು ಒಪ್ಪಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ಆಗ ಅವರು ತಮ್ಮ ತಮ್ಮೊಳಗೆ ಮಾತನಾಡಿಕೊಂಡು, “ನಾವು ನಮ್ಮ ತಮ್ಮನಿಗೆ ಮಾಡಿದ್ದು ಅಪರಾಧವೇ ಸರಿ. ಅವನು ನಮ್ಮನ್ನು ಬೇಡಿಕೊಂಡಾಗ ನಾವು ಅವನ ಪ್ರಾಣಸಂಕಟವನ್ನು ತಿಳಿದರೂ ಅವನ ಮೊರೆಗೆ ಕಿವಿಗೊಡಲಿಲ್ಲ. ಆ ಕಾರಣದಿಂದಲೇ ಈ ಸಂಕಟವು ನಮಗೆ ಪ್ರಾಪ್ತವಾಗಿದೆ” ಎಂದು ಮಾತನಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ಅದಕ್ಕೆ ರೂಬೇನನು, “ಆ ಹುಡುಗನಿಗೆ ಏನೂ ಕೇಡು ಮಾಡಬೇಡಿರಿ ಎಂದು ನಾನು ಹೇಳಿದೆನಲ್ಲವೆ. ನೀವು ಕೇಳಲಿಲ್ಲ. ಆದುದರಿಂದ ಅವನಿಗಾದ ಪ್ರಾಣ ಹಾನಿಯ ವಿಷಯದಲ್ಲಿ ನಾವು ಈಗ ಉತ್ತರ ಹೇಳಬೇಕಾಗಿ ಬಂದಿದೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ಯೋಸೇಫನು ದ್ವಿಭಾಷೆಯಲ್ಲಿ ಮಾತನಾಡಬಲ್ಲ ಅನುವಾದಕರೊಂದಿಗೆ ಮಾತನಾಡಿದ್ದರಿಂದ ಅವರು ತಮ್ಮ ಮಾತು ಅವನಿಗೆ ಗೊತ್ತಾಗುತ್ತದೆಂದು ತಿಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ಯೋಸೇಫನಾದರೋ ಅವರ ಬಳಿಯಿಂದ ಹೊರಟು ಹೋಗಿ ಅತ್ತನು. ತರುವಾಯ ಅವರ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಂದು ಅವರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರೊಳಗೆ ಸಿಮೆಯೋನನನ್ನು ಹಿಡಿಸಿ ಅವರ ಕಣ್ಣೆದುರಿಗೆ ಅವನಿಗೆ ಬೇಡಿಗಳನ್ನು ಹಾಕಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ಆ ಮೇಲೆ ಯೋಸೇಫನು ತನ್ನ ಆಳುಗಳಿಗೆ ಆ ಮನುಷ್ಯರ ಚೀಲಗಳಲ್ಲಿ ಧಾನ್ಯವನ್ನು ತುಂಬಿಸಿ ಒಬ್ಬೊಬ್ಬನ ಚೀಲದಲ್ಲಿ ಅವರವರು ತಂದಿದ್ದ ಹಣವನ್ನು ಅವರ ಚೀಲಗಳಲ್ಲೇ ಇಟ್ಟು ಅವರ ಪ್ರಯಾಣಕ್ಕೆ ಬೇಕಾದ ಆಹಾರವನ್ನು ಕೊಡಬೇಕೆಂದು ಅಪ್ಪಣೆ ಮಾಡಲು ಅವರು ಹಾಗೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ಇವರು ತಾವು ಕೊಂಡ ಧಾನ್ಯವನ್ನು ಕತ್ತೆಗಳ ಮೇಲೆ ಹೇರಿಕೊಂಡು ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ದಾರಿಯಲ್ಲಿ ಅವರು ಒಂದು ಸ್ಥಳದಲ್ಲಿ ಇಳಿದುಕೊಂಡಾಗ ಅವರಲ್ಲಿ ಒಬ್ಬನು ತನ್ನ ಕತ್ತೆಗೆ ಆಹಾರವನ್ನು ಕೊಡಬೇಕೆಂದು ತನ್ನ ಚೀಲವನ್ನು ಬಿಚ್ಚಿದಾಗ ಅದರ ಬಾಯಲ್ಲಿ ತಾನು ತಂದಿದ್ದ ಹಣವನ್ನು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ಅವನು ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ, “ನಾನು ಕೊಟ್ಟ ಹಣವು ಹಿಂದಕ್ಕೆ ಬಂದಿದೆ. ಇಗೋ, ಅದು ನನ್ನ ಚೀಲದಲ್ಲಿದೆ” ಎಂದು ಹೇಳಲು ಅವರು ಧೈರ್ಯಗೆಟ್ಟು ನಡುಗುತ್ತಾ ಒಬ್ಬರನ್ನೊಬ್ಬರು ನೋಡಿ, “ದೇವರು ನಮಗೆ ಹೀಗೆ ಮಾಡಿದ್ದೇನು?” ಎಂದು ಅಂದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ಅವರು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ತಮ್ಮ ತಂದೆಯಾದ ಯಾಕೋಬನ ಬಳಿಗೆ ಬಂದು ನಡೆದ ಎಲ್ಲ ವಿಷಯವನ್ನು ತಿಳಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ಆ ದೇಶಾಧಿಪತಿ ನಮ್ಮ ಸಂಗಡ ಕಟುವಾಗಿ ಮಾತನಾಡಿ ನಮ್ಮನ್ನು ಗೂಢಚಾರರೆಂದು ಭಾವಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ನಾವು ಅವನಿಗೆ, “ನಾವು ಸತ್ಯವಂತರೇ ಹೊರತು ಗೂಢಚಾರರಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ನಾವು ಒಬ್ಬ ತಂದೆಯಿಂದಲೆ ಹುಟ್ಟಿದ ಹನ್ನೆರಡು ಮಂದಿ ಅಣ್ಣತಮ್ಮಂದಿರಾಗಿದ್ದೇವೆ. ನಮ್ಮಲ್ಲಿ ಒಬ್ಬನಿಲ್ಲ. ಚಿಕ್ಕವನು ಈಗ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ನಮ್ಮ ತಂದೆಯ ಬಳಿಯಲ್ಲಿದಾನೆ” ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ಅದಕ್ಕೆ “ದೇಶಾಧಿಪತಿ, ನೀವು ಸತ್ಯವಂತರೋ ಅಲ್ಲವೋ ಎಂಬುದು ಗೊತ್ತಾಗುವುದಕ್ಕಾಗಿ ನಿಮ್ಮೊಳಗೆ ಒಬ್ಬನನ್ನು ನನ್ನ ಬಳಿಯಲ್ಲಿ ಬಿಟ್ಟು ನಿಮ್ಮ ಮನೆಯವರ ಕ್ಷಾಮ ನಿವಾರಣೆಗೆ ಬೇಕಾದದ್ದನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ನಿಮ್ಮ ತಮ್ಮನನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು, ಕರೆದುಕೊಂಡು ಬಂದರೆ ನೀವು ಗೂಢಚಾರರಲ್ಲ ಸತ್ಯವಂತರೇ ಎಂದು ತಿಳಿದುಕೊಂಡು ನಿಮ್ಮ ಅಣ್ಣನನ್ನು ಸೆರೆಯಿಂದ ಬಿಡಿಸುತ್ತೇನೆ ಮತ್ತು ನೀವು ಈ ದೇಶದಲ್ಲಿ ವ್ಯಾಪಾರ ಮಾಡಬಹುದು” ಎಂದು ಹೇಳಿದನು ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ಅವರು ತಮ್ಮ ಚೀಲಗಳನ್ನು ಬಿಚ್ಚಿ ನೋಡಿದಾಗ ಪ್ರತಿಯೊಬ್ಬನ ಚೀಲದಲ್ಲಿಯೂ ಅವರವರ ಹಣದ ಗಂಟು ಸಿಕ್ಕಿತು. ಅವರು, ಅವರ ತಂದೆಯೂ ಹಣದ ಗಂಟುಗಳನ್ನು ಕಂಡಾಗ ಭಯಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ಆಗ ಅವರ ತಂದೆಯಾದ ಯಾಕೋಬನು, “ಅವರಿಗೆ ನನ್ನನ್ನು ಮಕ್ಕಳಿಲ್ಲದವನಂತೆ ಮಾಡಿದ್ದೀರಿ. ಯೋಸೇಫನು ಇಲ್ಲ, ಸಿಮೆಯೋನನು ಇಲ್ಲ. ಬೆನ್ಯಾಮೀನನ್ನೂ ಕರೆದುಕೊಂಡು ಹೋಗಬೇಕೆಂದಿದ್ದೀರಿ. ಈ ಕಷ್ಟವೆಲ್ಲಾ ನನ್ನ ಮೇಲೆಯೇ ಬಂದಿತಲ್ಲಾ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ರೂಬೇನನು ತನ್ನ ತಂದೆಗೆ, “ನಾನು ಈ ಹುಡುಗನನ್ನು ತಿರುಗಿ ತಂದು ಒಪ್ಪಿಸದೆ ಹೋದರೆ ನನ್ನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳನ್ನು ಕೊಂದು ಹಾಕಬಹುದು. ಇವನನ್ನು ನನ್ನ ವಶಕ್ಕೆ ಕೊಟ್ಟರೆ ನಾನು ತಪ್ಪದೆ ಇವನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ಆದರೆ ಯಾಕೋಬನು ಅವರಿಗೆ, “ನನ್ನ ಮಗನು ನಿಮ್ಮ ಸಂಗಡ ಹೋಗಬಾರದು. ಇವನ ಒಡಹುಟ್ಟಿದವನು ಸತ್ತು ಹೋದನು. ಇವನೊಬ್ಬನೇ ಉಳಿದಿದ್ದಾನೆ. ಮಾರ್ಗದಲ್ಲಿ ಇವನಿಗೇನಾದರೂ ಕೇಡಾದರೆ ಈ ಮುದಿ ತಲೆ ದುಃಖದಿಂದಲೇ ಸಮಾಧಿಗೆ ಸೇರಲು ನೀವು ಕಾರಣರಾಗುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಬರವು ಬಹು ಘೋರವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ಅವರು ಐಗುಪ್ತ ದೇಶದಿಂದ ತಂದಿದ್ದ ದವಸಧಾನ್ಯವು ಮುಗಿದ ನಂತರ ಅವರ ತಂದೆಯು ಅವರಿಗೆ, “ನೀವು ಪುನಃ ಹೋಗಿ ಇನ್ನೂ ಸ್ವಲ್ಪ ಧಾನ್ಯವನ್ನು ಖರೀದಿಸಿಕೊಂಡು ಬನ್ನಿರಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ಅದಕ್ಕೆ ಯೆಹೂದನು ತನ್ನ ತಂದೆಗೆ ಹೇಳಿದ್ದೇನಂದರೆ, “ಆ ಮನುಷ್ಯನು ನಮಗೆ ‘ನಿಮ್ಮ ತಮ್ಮನನ್ನು ಕರೆದುಕೊಂಡು ಬಂದ ಹೊರತು ನನ್ನ ಮುಖವನ್ನು ನೋಡಬಾರದು’ ಎಂದು ಖಂಡಿತವಾಗಿ” ಹೇಳಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ನೀನು ನಮ್ಮ ತಮ್ಮನನ್ನು ನಮ್ಮ ಜೊತೆಯಲ್ಲಿ ಕಳುಹಿಸಿದರೆ ನಾವು ಹೋಗಿ, ನಿನಗೆ ಧಾನ್ಯವನ್ನು ಖರೀದಿಸಿಕೊಂಡು ತರುತ್ತೇವೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ಅವನನ್ನು ನೀನು ಕಳುಹಿಸದೆ ಹೋದರೆ ನಾವು ಹೋಗುವುದಿಲ್ಲ. ಏಕೆಂದರೆ ಆ “ಮನುಷ್ಯನು ನಿಮ್ಮ ತಮ್ಮನು ನಿಮ್ಮ ಸಂಗಡ ಇಲ್ಲದಿದ್ದರೆ ನನ್ನ ಮುಖವನ್ನು ನೋಡಬಾರದು” ಎಂದು ಹೇಳಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ಅದಕ್ಕೆ ಇಸ್ರಾಯೇಲನು, “ಇನ್ನೊಬ್ಬ ತಮ್ಮನಿದ್ದಾನೆಂದು ಆ ಮನುಷ್ಯನಿಗೆ ಹೇಳಿ, ನೀವು ಯಾಕೆ ನನಗೆ ಕೇಡು ಮಾಡಿದಿರಿ?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ಅವರು, “ನಮ್ಮ ವಿಷಯದಲ್ಲಿಯೂ ನಮ್ಮ ಮನೆಯವರ ವಿಷಯದಲ್ಲಿಯೂ ಆ ಮನುಷ್ಯನು ಸೂಕ್ಷ್ಮವಾಗಿ ವಿಚಾರಿಸಿದನು, ಮತ್ತೆ ಅವನು ನಿಮ್ಮ ತಂದೆಯು ಇನ್ನೂ ಬದುಕಿದ್ದಾನೋ? ನಿಮಗೆ ಇನ್ನೊಬ್ಬ ತಮ್ಮನಿದ್ದಾನೋ? ಎಂದು ಕೇಳಿದನು. ಆ ಪ್ರಶ್ನೆಗಳಿಗೆ ತಕ್ಕಂತೆ ನಾವು ಉತ್ತರಕೊಟ್ಟೆವು. ಅವನು ನಿಮ್ಮ ತಮ್ಮನನ್ನು ಕರೆದುಕೊಂಡು ಬನ್ನಿರಿ ಎಂದು ಹೇಳುವನೆಂದು ನಮಗೆ ಹೇಗೆ ತಿಳಿಯುವುದು” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ಆಗ ಯೆಹೂದನು ತನ್ನ ತಂದೆಯಾದ ಇಸ್ರಾಯೇಲನಿಗೆ, “ಆ ಹುಡುಗನನ್ನು ನನ್ನ ಜೊತೆಯಲ್ಲಿ ಕಳುಹಿಸಿಕೊಡು, ನಾವು ಹೋಗುವೆವು. ಆಗ ನೀನೂ, ನಾವು ಮತ್ತು ನಮ್ಮ ಮಕ್ಕಳೂ ಸಾಯದೆ ಬದುಕುವೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ನಾನು ಅವನಿಗೋಸ್ಕರ ಹೊಣೆಯಾಗಿರುವೆನು. ಅವನ ವಿಷಯ ನನ್ನನ್ನೇ ಕೇಳಬಹುದು. ನಾನು ಅವನನ್ನು ತಿರುಗಿ ಕರೆದುಕೊಂಡು ಬಂದು ನಿನ್ನೆದುರಿನಲ್ಲಿ ನಿಲ್ಲಿಸದೆ ಹೋದರೆ ಆ ಅಪರಾಧ ಎಂದೆಂದಿಗೂ ನನ್ನ ಮೇಲೆ ಇರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ನಾವು ತಡಮಾಡದೆ ಹೋಗಿದ್ದರೆ ಇಷ್ಟರೊಳಗೆ ಎರಡನೆಯ ಸಾರಿ ಹೋಗಿ ಬರುತ್ತಿದ್ದೆವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ಅದಕ್ಕೆ ಅವರ ತಂದೆಯಾದ ಇಸ್ರಾಯೇಲನು ಅವರಿಗೆ, “ಹಾಗಿದ್ದರೆ, ನೀವು ಹೀಗೆ ಮಾಡಿರಿ. ಈ ದೇಶದಲ್ಲಿ ದೊರಕುವ ಶ್ರೇಷ್ಠವಾದ ವಸ್ತುಗಳಲ್ಲಿ ಕೆಲವನ್ನು ನಿಮ್ಮ ಚೀಲದಲ್ಲಿ ಇಟ್ಟುಕೊಂಡು ಆ ಮನುಷ್ಯನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ಸ್ವಲ್ಪ ತೈಲ, ಜೇನು, ಸುಗಂಧದ್ರವ್ಯ, ಕಾಕಂಬಿ, ಹಾಲುಮಡ್ಡಿ, ರಕ್ತಬೋಳ, ಗೋಡಂಬಿ, ಬಾದಾಮಿ ಇವುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ಇದಲ್ಲದೆ ಎರಡರಷ್ಟು ಹಣವನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ಅವರು ನಿಮ್ಮ ಚೀಲಗಳ ಬಾಯಲ್ಲಿ ಹಾಕಿ ಹಿಂದಕ್ಕೆ ಕಳುಹಿಸಿದ ಹಣವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ಒಂದು ವೇಳೆ ಅದು ಅವರಿಗೆ ತಿಳಿಯದೆ ಇದ್ದಿರಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ನಿಮ್ಮ ತಮ್ಮನನ್ನೂ ಕರೆದುಕೊಂಡು, ತಿರುಗಿ ಆ ಮನುಷ್ಯನ ಬಳಿಗೆ ಹೋಗಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ಸರ್ವಶಕ್ತನಾದ ದೇವರು ನಿಮ್ಮ ಇನ್ನೊಬ್ಬ ಅಣ್ಣನನ್ನೂ, ಬೆನ್ಯಾಮೀನನನ್ನೂ ನಿಮ್ಮೊಂದಿಗೆ ಕಳುಹಿಸಿಕೊಡುವಂತೆ ನಿಮ್ಮ ಮೇಲೆ ಕರುಣೆ ತೋರುವಂತೆ ಮಾಡಲಿ. ನಾನಂತೂ ಮಕ್ಕಳನ್ನು ಕಳೆದುಕೊಂಡವನಾಗಿರಬೇಕು ಎಂದರೆ ಹಾಗೆಯೇ ಆಗಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ಆಗ ಆ ಮನುಷ್ಯರು ಕಾಣಿಕೆಯನ್ನು ಸಿದ್ಧಮಾಡಿಕೊಂಡು, ಎರಡರಷ್ಟು ಹಣವನ್ನೂ ತೆಗೆದುಕೊಂಡು, ಬೆನ್ಯಾಮೀನನನ್ನು ತಮ್ಮ ಜೊತೆಯಲ್ಲಿ ಕರೆದುಕೊಂಡು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹೋಗಿ ಯೋಸೇಫನ ಎದುರಿನಲ್ಲಿ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ಬೆನ್ಯಾಮೀನನು ಅವರ ಸಂಗಡ ಇರುವುದನ್ನು ಯೋಸೇಫನು ಕಂಡು ತನ್ನ ಗೃಹನಿರ್ವಾಹಕನನ್ನು ಕರೆಯಿಸಿ, “ಈ ಮನುಷ್ಯರನ್ನು ಮನೆಯೊಳಗೆ ಕರೆದುಕೊಂಡು ಹೋಗು, ಒಳ್ಳೆ ಕೊಬ್ಬಿದ ಪಶುವನ್ನು ಕೊಯ್ದು ಅಡುಗೆ ಸಿದ್ಧಮಾಡು. ಏಕೆಂದರೆ ಈ ಮನುಷ್ಯರು ಈ ಹೊತ್ತು ಮಧ್ಯಾಹ್ನ ನನ್ನ ಸಂಗಡ ಊಟ ಮಾಡುವರು” ಎಂದು ಅಪ್ಪಣೆಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ಯೋಸೇಫನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಗೃಹನಿರ್ವಾಹಕನು ಅವರನ್ನು ಯೋಸೇಫನ ಮನೆಯೊಳಗೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ಯೋಸೇಫನ ಮನೆಗೆ ಕರೆತಂದದ್ದರಿಂದ ಅವರು ಭಯಪಟ್ಟು, “ಮೊದಲನೆಯ ಸಾರಿ ನಮ್ಮ ಚೀಲಗಳಲ್ಲಿ ಹಿಂದಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋದ ಹಣದ ನಿಮಿತ್ತವೇ ಅವನು ನಮ್ಮನ್ನು ತನ್ನ ಮನೆಯೊಳಗೆ ಕರೆಸಿದ್ದಾನೆ. ನಮ್ಮ ಮೇಲೆ ಫಕ್ಕನೆ ಬಿದ್ದು, ನಮ್ಮನ್ನೂ, ನಮ್ಮ ಕತ್ತೆಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ನಮ್ಮನ್ನು ದಾಸರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಲು ಇಲ್ಲಿಗೆ ಕರೆಸಿದ್ದಾನೆ” ಎಂದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ಆಗ ಅವರು ಯೋಸೇಫನ ಗೃಹನಿರ್ವಾಹಕನ ಬಳಿಗೆ ಹೋಗಿ ಮನೆಯ ಬಾಗಿಲ ಬಳಿ ನಿಂತುಕೊಂಡು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿ ಅವನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“ಅಯ್ಯಾ, ಮೊದಲನೆಯ ಸಾರಿ ನಾವು ಆಹಾರ ಪದಾರ್ಥಗಳನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ಬಂದಿದ್ದೇವು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ನಾವು ಹೊರಟುಹೋದ ನಂತರ ಇಳಿದುಕೊಂಡಿದ್ದ ಸ್ಥಳದಲ್ಲಿ ನಮ್ಮ ಚೀಲಗಳನ್ನು ಬಿಚ್ಚಿ ನೋಡಿದಾಗ ಪ್ರತಿಯೊಬ್ಬನ ಹಣವು ತೂಕದಲ್ಲಿ ಏನೂ ಕಡಿಮೆಯಿಲ್ಲದೆ ನಮ್ಮ ನಮ್ಮ ಚೀಲದಲ್ಲೇ ಇತ್ತು. ಅದನ್ನು ಹಿಂತಿರುಗಿಸಲು ತಂದಿದ್ದೇವೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ದವಸವನ್ನು ಕೊಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ಬೇರೆ ಹಣವನ್ನೂ ತಂದಿದ್ದೇವೆ. ಆ ಹಣವನ್ನು ನಮ್ಮ ಚೀಲಗಳಲ್ಲಿ ಯಾರು ಇಟ್ಟರೋ ನಮಗೆ ತಿಳಿಯದು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ಅದಕ್ಕೆ ಅವನು, “ನೀವು ಸಮಾಧಾನವಾಗಿರಿ. ನೀವೇನೂ ಭಯಪಡಬೇಡಿರಿ ನಿಮಗೂ ನಿಮ್ಮ ತಂದೆಗೂ ದೇವರಾಗಿರುವಾತನು ನಿಮ್ಮ ಚೀಲಗಳಲ್ಲಿ ಹಣವನ್ನು ಇಟ್ಟಿರಬೇಕು. ನಿಮ್ಮ ಹಣವು ನನಗೆ ಮುಟ್ಟಿತು” ಎಂದು ಹೇಳಿ, ಅವನು ಸಿಮೆಯೋನನನ್ನು ಅವರ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ಅವರೆಲ್ಲರನ್ನೂ ಯೋಸೇಫನ ಮನೆಯೊಳಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ಕಾಲುಗಳನ್ನು ತೊಳೆಯುವುದಕ್ಕೆ ನೀರನ್ನು ಕೊಡಿಸಿ, ಅವರ ಕತ್ತೆಗಳಿಗೂ ಮೇವು ಹಾಕಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ತಾವು ಅಲ್ಲೇ ಊಟ ಮಾಡಬೇಕೆಂಬ ಸಂಗತಿಯನ್ನು ಅವರು ಕೇಳಿದ್ದರಿಂದ ತಾವು ತಂದಿದ್ದ ಕಾಣಿಕೆಯನ್ನು ಯೋಸೇಫನಿಗೆ ಕೊಡಲು ಸಿದ್ಧಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ಯೋಸೇಫನು ಮನೆಗೆ ಬಂದಾಗ, ಅವರು ತಮ್ಮ ಕೈಯಲ್ಲಿದ್ದ ಕಾಣಿಕೆಯನ್ನು ಮನೆಯೊಳಗೆ ತಂದು, ಅವನಿಗೆ ಕೊಟ್ಟು, ಅವನ ಮುಂದೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ಅವನು ಅವರ ಯೋಗ ಕ್ಷೇಮವನ್ನು ವಿಚಾರಿಸಿ ಅವರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀವು ಹೇಳಿದ, ಮುದುಕನಾಗಿರುವ ನಿಮ್ಮ ತಂದೆ ಕ್ಷೇಮವೋ? ಅವನು ಇನ್ನೂ ಬದುಕಿದ್ದಾನೋ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ಅವರು ಅದಕ್ಕೆ, “ನಿನ್ನ ಸೇವಕನಾದ ನಮ್ಮ ತಂದೆ ಕ್ಷೇಮವಾಗಿದ್ದಾನೆ. ಅವನು ಇನ್ನೂ ಬದುಕಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿ, ತಮ್ಮ ತಲೆಗಳನ್ನು ಬಾಗಿಸಿ ಅವನಿಗೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ಆಗ ಅವನು ಕಣ್ಣೆತ್ತಿ ತನ್ನ ಒಡಹುಟ್ಟಿದ ತಮ್ಮನಾದ ಬೆನ್ಯಾಮೀನನನ್ನು ನೋಡಿ, “ನೀವು ಹೇಳಿದ ನಿಮ್ಮ ಕಿರಿಯ ತಮ್ಮನು ಇವನೋ?” ಎಂದು ಕೇಳಿ ಅವನಿಗೆ, “ಮಗನೇ, ದೇವರ ದಯೆ ನಿನ್ನ ಮೇಲೆ ಇರಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ಯೋಸೇಫನು ಅವಸರವಾಗಿ ಎದ್ದು ತನ್ನ ಕೋಣೆಯೊಳಗೆ ಹೋದನು. ಏಕೆಂದರೆ ತನ್ನ ಕರಳು ತಮ್ಮನ ಮೇಲೆ ಮರುಗಿದ್ದರಿಂದ ಅವನು ತನ್ನ ಕೋಣೆಯೊಳಗೆ ಹೋಗಿ ಅಲ್ಲಿ ಅತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ಆ ಮೇಲೆ ಮುಖವನ್ನು ತೊಳೆದುಕೊಂಡು ಹೊರಗೆ ಬಂದು, ಮನಸ್ಸನ್ನು ಬಿಗಿ ಹಿಡಿದು, “ಊಟಕ್ಕೆ ಬಡಿಸಿರಿ” ಎಂದು ಅಪ್ಪಣೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ಪರಿಚಾರಕರು ಅವನಿಗೂ ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೂ ಅವನ ಸಂಗಡವಿದ್ದ ಐಗುಪ್ತರಿಗೂ ಬೇರೆ ಬೇರೆಯಾಗಿ ಊಟಕ್ಕೆ ಬಡಿಸಿದರು. ಏಕೆಂದರೆ ಐಗುಪ್ತರು ಇಬ್ರಿಯರ ಜೊತೆ ಸಹಪಂಕ್ತಿಯಲ್ಲಿ ಊಟಮಾಡುತ್ತಿರಲಿಲ್ಲ. ಅದು ಐಗುಪ್ತರಿಗೆ ಅಸಹ್ಯವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ಯೋಸೇಫನು ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರನ್ನು ಹಿರಿಯವನು ಮೊದಲುಗೊಂಡು ಕಿರಿಯವನವರೆಗೂ ಅವರವರ ವಯಸ್ಸಿನ ಪ್ರಕಾರವೇ ಕುಳಿತುಕೊಳ್ಳುವಂತೆ ಮಾಡಿದ್ದರಿಂದ, ಅವರು ತಮ್ಮೊಳಗೆ ಆಶ್ಚರ್ಯಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ಯೋಸೇಫನು ತನ್ನ ಮುಂದಿಟ್ಟಿದ್ದ ಆಹಾರಗಳಲ್ಲಿ ಭಾಗಗಳನ್ನು ಕಳುಹಿಸಿದಾಗ, ಬೆನ್ಯಾಮೀನನಿಗೆ ಬಂದ ಭಾಗವು ಮಿಕ್ಕಾದವರ ಭಾಗಗಳಿಗಿಂತ ಐದರಷ್ಟು ಹೆಚ್ಚಾಗಿತ್ತು. ಅವರು ಪಾನಮಾಡಿ ಅವನ ಸಂಗಡ ಸಂತೋಷದಿಂದ ಇದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ಯೋಸೇಫನು ತರುವಾಯ ತನ್ನ ಗೃಹನಿರ್ವಾಹಕನಿಗೆ, “ಆ ಮನುಷ್ಯರು ಚೀಲಗಳನ್ನು ಹೊರುವಷ್ಟು ಧಾನ್ಯವನ್ನು ತುಂಬಿಸಿ, ಒಬ್ಬೊಬ್ಬನ ಚೀಲದ ಬಾಯಲ್ಲಿ ಅವನವನ ಹಣದ ಗಂಟನ್ನು ಇಡಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ಕಿರಿಯವನ ಚೀಲದಲ್ಲಿ ಅವನು ದವಸಕ್ಕೆ ತಂದ ಹಣವನ್ನಲ್ಲದೇ, ತನ್ನ ಬೆಳ್ಳಿಯ ಪಾನ ಪಾತ್ರೆಯನ್ನು ಇಡಬೇಕು” ಎಂದು ಅಪ್ಪಣೆಕೊಡಲು, ಗೃಹನಿರ್ವಾಹಕನು ಹಾಗೆಯೇ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ಅವರೆಲ್ಲರೂ ಬೆಳಿಗ್ಗೆ ಹೊತ್ತು ಮೂಡುವಾಗ ಅಪ್ಪಣೆ ಪಡೆದು, ಕತ್ತೆಗಳ ಸಹಿತವಾಗಿ ಹೊರಟುಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ಅವರು ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟು ಸ್ವಲ್ಪ ದೂರ ಹೋಗುವಷ್ಟರಲ್ಲಿ, ಯೋಸೇಫನು ತನ್ನ ಗೃಹನಿರ್ವಾಹಕನಿಗೆ, “ನೀನು ಎದ್ದು ಆ ಮನುಷ್ಯರನ್ನು ಹಿಂದಟ್ಟು, ಅವರು ಸಿಕ್ಕಿದಾಗ ನೀವು ಉಪಕಾರಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ಯಾಕೆ ಅಪಕಾರ ಮಾಡಿದ್ದೀರಿ? ");
INSERT INTO kanirv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ಆ ಪಾತ್ರೆಯಲ್ಲಿ ನನ್ನ ದಣಿಯು ಪಾನಮಾಡುತ್ತಾನಲ್ಲವೇ? ಅವನು ದೈವೋಕ್ತಿಯನ್ನು ಹೇಳುವವನಲ್ಲವೆ? ನೀವು ಹೀಗೆ ಮಾಡಿದ್ದು ಕೆಟ್ಟಕೆಲಸ” ಎಂದು ಅವರಿಗೆ ಹೇಳು ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ಗೃಹನಿರ್ವಾಹಕನು ಅವರನ್ನು ಹಿಂದಟ್ಟಿ, ಅವರಿಗೆ ಈ ಮಾತುಗಳನ್ನು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ಅವರು ಅವನಿಗೆ, “ನಮ್ಮ ಒಡೆಯನೇ, ಇಂಥಾ ಮಾತುಗಳನ್ನು ಹೇಳುವುದೇನು? ನಿನ್ನ ಸೇವಕರು ಇಂಥಾ ಕೃತ್ಯವನ್ನು ಎಂದಿಗೂ ಮಾಡುವವರಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ಮೊದಲು ನಮ್ಮ ಚೀಲಗಳ ಬಾಯಲ್ಲಿ ನಮಗೆ ಸಿಕ್ಕಿದ ಹಣವನ್ನು ನಾವು ಕಾನಾನ್ ದೇಶದಿಂದ ತಿರುಗಿ ನಿಮಗೆ ಕೊಡಲು ತಂದೆವು. ಹೀಗಿರುವಾಗ ನಾವು ನಿನ್ನ ದಣಿಯ ಮನೆಯೊಳಗಿಂದ ಬೆಳ್ಳಿ ಬಂಗಾರವನ್ನು ಹೇಗೆ ಕದ್ದುಕೊಂಡೇವು? ");
INSERT INTO kanirv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ಆ ಪಾತ್ರೆಯು ನಿನ್ನ ಸೇವಕರೊಳಗೆ ಯಾರ ಬಳಿಯಲ್ಲಿ ಸಿಕ್ಕುತ್ತದೋ, ಅವನು ಮರಣ ದಂಡನೆಯನ್ನು ಹೊಂದಲಿ. ಅದಲ್ಲದೆ ನಾವೆಲ್ಲರೂ ನಮ್ಮ ಸ್ವಾಮಿಗೆ ದಾಸರಾಗುವೆವು” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ಅದಕ್ಕೆ ಅವನು, “ಒಳ್ಳೆಯದು, ನೀವು ಹೇಳಿದಂತೆ ಆಗಲಿ. ಆ ಪಾತ್ರೆ ಯಾವನ ಬಳಿಯಲ್ಲಿ ಸಿಕ್ಕುತ್ತದೋ, ಅವನು ನನಗೆ ದಾಸನಾಗಬೇಕು. ಉಳಿದವರು ನಿರಪರಾಧಿಗಳು” ಎಂದು ಹೇಳಿದಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ಅವರು ತಟ್ಟನೆ, ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ತನ್ನ ಚೀಲವನ್ನು ನೆಲಕ್ಕಿಳಿಸಿ ಅವುಗಳನ್ನು ಬಿಚ್ಚಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ಅವನು ಹಿರಿಯವನಿಂದ ಹಿಡಿದು ಕಿರಿಯವನ ತನಕ ಪರೀಕ್ಷಿಸಿ ನೋಡಿದನು. ಆ ಪಾತ್ರೆಯು ಬೆನ್ಯಾಮೀನನ ಚೀಲದಲ್ಲಿ ಸಿಕ್ಕಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ಸಿಕ್ಕಿದಾಗ, ಅವರು ದುಃಖಾಕ್ರಾಂತರಾಗಿ ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡು ಕತ್ತೆಗಳ ಮೇಲೆ ಚೀಲಗಳನ್ನು ಹೇರಿ ಪಟ್ಟಣಕ್ಕೆ ಹಿಂತಿರುಗಿ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ಯೆಹೂದನೂ ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರೂ ಯೋಸೇಫನ ಮನೆಗೆ ಬಂದಾಗ ಅವನು ಇನ್ನು ಅಲ್ಲೇ ಇದ್ದನು. ಅವರು ಅವನೆದುರಿಗೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ಯೋಸೇಫನು ಅವರಿಗೆ, “ನೀವು ಮಾಡಿರುವ ಈ ಕೃತ್ಯವು ಏನು? ನನ್ನಂಥ ಮನುಷ್ಯನು ದೈವೋಕ್ತಿಗಳನ್ನು ಬಲ್ಲೆನೆಂದು ನಿಮಗೆ ತಿಳಿದಿರಲಿಲ್ಲವೋ?” ಎಂದು ಕೇಳಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ಯೆಹೂದನು, “ನಾವು ನಮ್ಮ ಸ್ವಾಮಿಗೆ ಏನು ಹೇಳೋಣ? ನಾವು ಏನು ಮಾತನಾಡೋಣ? ನಾವು ನೀತಿವಂತರಾಗಿ ತೋರುವಂತೆ ಏನು ಮಾಡೋಣ? ನಿನ್ನ ಸೇವಕರ ಪಾಪಕೃತ್ಯವನ್ನು ದೇವರು ಹೊರಪಡಿಸಿದ್ದಾನೆ. ಈ ಪಾತ್ರೆಯು ಯಾರ ಬಳಿಯಲ್ಲಿ ಸಿಕ್ಕಿತೋ ಅವನು ಮಾತ್ರವಲ್ಲದೆ ನಾವೆಲ್ಲರೂ ನಮ್ಮ ಸ್ವಾಮಿಗೆ ಗುಲಾಮರಾದೆವು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ಯೋಸೇಫನು, “ಹಾಗೆ ಎಂದಿಗೂ ಆಗಬಾರದು. ಈ ಪಾತ್ರೆಯು ಯಾರ ಬಳಿಯಲ್ಲಿ ಸಿಕ್ಕಿತೋ ಅವನು ಮಾತ್ರವೇ ನನಗೆ ಗುಲಾಮನಾಗಿರಲಿ. ನೀವಾದರೋ ಸಮಾಧಾನವಾಗಿ ನಿಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ಹೋಗಿರಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ಯೆಹೂದನು ಹತ್ತಿರಕ್ಕೆ ಬಂದು, “ನನ್ನ ಒಡೆಯನೇ, ನಿನ್ನ ಸೇವಕನಾದ ನಾನು ಒಂದು ಮಾತನ್ನು ನನ್ನ ಒಡೆಯನಿಗೆ ಬಿಡಿಸಿ ಹೇಳುವುದಕ್ಕೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು. ನಿನ್ನ ದಾಸನ ಮೇಲೆ ಕೋಪಗೊಳ್ಳಬಾರದು. ಏಕೆಂದರೆ ನೀನು ಫರೋಹನಿಗೆ ಸಮಾನನು ಎಂದು ನಾನು ಬಲ್ಲೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ತಾವು ತಮ್ಮ ಸೇವಕರಾದ ನಮ್ಮನ್ನು ಕುರಿತು, ‘ನಿಮಗೆ ತಂದೆಯಾಗಲಿ, ತಮ್ಮನಾಗಲಿ ಇದ್ದಾನೋ?’ ಎಂದು ಕೇಳಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ನಾವು ‘ನಮಗೆ ಮುದುಕನಾದ ತಂದೆಯಿದ್ದಾನೆ, ಅವನಿಗೆ ಮುಪ್ಪಿನಲ್ಲಿ ಹುಟ್ಟಿದ ಒಬ್ಬ ಚಿಕ್ಕ ಮಗನೂ ಇದ್ದಾನೆ, ಅವನ ಒಡಹುಟ್ಟಿದವನು ಸತ್ತು ಹೋಗಿದ್ದಾನೆ. ಆದುದರಿಂದ ಅವನ ತಾಯಿಯಲ್ಲಿ ಹುಟ್ಟಿದವರೊಳಗೆ ಅವನೊಬ್ಬನೇ ಉಳಿದಿದ್ದಾನೆ. ಅವನ ಮೇಲೆ ತಂದೆಗೆ ಬಹಳ ಪ್ರೀತಿಯುಂಟು’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“ಅದಕ್ಕೆ ತಾವು, ‘ನಾನು ಆ ಹುಡುಗನನ್ನು ನೋಡಬೇಕು ಅವನನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬನ್ನಿರಿ’ ಎಂದು ಅಪ್ಪಣೆಕೊಡಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ನಾವು ಸ್ವಾಮಿಯವರಿಗೆ, ‘ಆ ಹುಡುಗನು ತನ್ನ ತಂದೆಯನ್ನು ಬಿಟ್ಟು ಬರುವುದಿಲ್ಲ. ಅವನು ತಂದೆಯನ್ನು ಅಗಲಿದರೆ ತಂದೆಯು ಸಾಯುವನು’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ಅದಕ್ಕೆ ನೀವು, ‘ನಿಮ್ಮ ತಮ್ಮನು ನಿಮ್ಮ ಸಂಗಡ ಬಾರದಿದ್ದರೆ ನೀವು ಇನ್ನೊಂದು ಸಾರಿ ನನ್ನ ಮುಖವನ್ನು ನೋಡಬಾರದು’ ಎಂದು ಅಪ್ಪಣೆಕೊಟ್ಟಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ನಾವು ನಿಮ್ಮ ಸೇವಕನಾದ ನಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ಹೋಗಿ ಸ್ವಾಮಿಯ ಮಾತುಗಳನ್ನು ತಿಳಿಸಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“ನಮ್ಮ ತಂದೆಯು, ‘ನೀವು ಪುನಃ ಹೋಗಿ ನಮಗೆ ಧಾನ್ಯವನ್ನು ಕೊಂಡು ಕೊಂಡು ಬನ್ನಿ’ ಎಂದು ಹೇಳಿದಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ನಾವು ಆತನಿಗೆ, ‘ಹೇಗೆ ಹೋಗುವುದು, ತಮ್ಮನು ನಮ್ಮ ಸಂಗಡ ಇದ್ದರೆ ಮಾತ್ರ ನಾವು ಹೋಗುತ್ತೇವೆ. ಇಲ್ಲವಾದರೇ, ನಾವು ಆ ಮನುಷ್ಯನ ಮುಖವನ್ನು ನೋಡಲು ಆಗುವುದಿಲ್ಲ’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ಅದಕ್ಕೆ ನಿನ್ನ ಸೇವಕನಾದ, ನಮ್ಮ ತಂದೆಯು, ‘ನನ್ನ ಪತ್ನಿಯಲ್ಲಿ ನನಗೆ ಇಬ್ಬರು ಗಂಡು ಮಕ್ಕಳು ಹುಟ್ಟಿರುವುದು ನಿಮಗೆ ತಿಳಿದೇ ಇದೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ಅವರಲ್ಲಿ ಒಬ್ಬನು ನನ್ನ ಬಳಿಯಿಂದ ಹೊರಟು ಹೋದನು. ಅವನು ಸಂದೇಹವಿಲ್ಲದೆ ಮೃಗದಿಂದ ಸೀಳಿ ಹಾಕಲ್ಪಟ್ಟಿರಬೇಕೆಂದು ತಿಳಿದೆನು. ಅಂದಿನಿಂದ ನಾನು ಅವನನ್ನು ಕಾಣಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ಈಗ ಇವನನ್ನೂ ನನ್ನ ಬಳಿಯಿಂದ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕೆಂದಿದ್ದೀರಿ. ಇವನಿಗೂ ಕೇಡು ಬಂದರೆ ಈ ಮುದಿ ತಲೆಯು ದುಃಖದಿಂದ ಸಮಾಧಿಗೆ ಸೇರಲು ನೀವು ಕಾರಣರಾಗುವಿರಿ’ ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“ನಮ್ಮ ತಂದೆಯ ಪ್ರಾಣವು ಇವನ ಪ್ರಾಣವು ಒಂದೇ ಆಗಿರುವುದರಿಂದ ನಾವು ನಿನ್ನ ಸೇವಕನಾದ ನಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ಹೋದಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ಈ ಹುಡುಗನು ನಮ್ಮ ಸಂಗಡ ಇಲ್ಲದೆ ಇರುವುದನ್ನು ತಿಳಿದ ಕೂಡಲೇ ನಮ್ಮ ತಂದೆಯು ಸಾಯುವನು. ತಮ್ಮ ಸೇವಕರಾದ ನಾವು ನಮ್ಮ ಮುಪ್ಪಾದ ತಂದೆ ದುಃಖದಿಂದಲೇ ಸಮಾಧಿಗೆ ಸೇರಲು ಕಾರಣರಾಗುವೆವು. ");
INSERT INTO kanirv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ಸೇವಕನಾದ ನಾನು ತಂದೆಯ ಬಳಿಯಲ್ಲಿ ಈ ಹುಡುಗನಿಗೆ ಹೊಣೆಯಾಗಿ, ‘ನಾನು ಇವನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಾರದೆ ಹೋದರೆ, ಎಂದೆಂದಿಗೂ ತಂದೆಗೆ ದೋಷಿಯಾಗಿರುವೆನು’ ಎಂದು ಮಾತು ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“ಆದುದರಿಂದ ಸೇವಕನಾದ ನಾನು ಈ ಹುಡುಗನ ಬದಲಾಗಿ ಸ್ವಾಮಿಗೆ ಗುಲಾಮನಾಗುವಂತೆಯೂ ಇವನು ತನ್ನ ಅಣ್ಣಂದಿರ ಸಂಗಡ ಹೋಗುವಂತೆಯೂ ಅನುಗ್ರಹ ಮಾಡಬೇಕೆಂದು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ಈ ಹುಡುಗನನ್ನು ಬಿಟ್ಟು ನಾನು ನನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಹೇಗೆ ಹೋಗಲಿ? ಹೋದರೆ, ನನ್ನ ತಂದೆಗೆ ಆಗುವ ಆಘಾತ, ದುಃಖ ನನ್ನಿಂದ ನೋಡಲಾಗದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ಯೋಸೇಫನು ಇದನ್ನು ಕೇಳಿ ತನ್ನ ಎದುರಿನಲ್ಲಿ ನಿಂತಿದ್ದವರ ಮುಂದೆ ದುಃಖವನ್ನು ತಾಳಲಾರದೆ, “ಎಲ್ಲರನ್ನು ನನ್ನ ಬಳಿಯಿಂದ ಹೊರಗೆ ಕಳುಹಿಸಿರಿ” ಎಂದು ಕೂಗಿದನು. ಯೋಸೇಫನು ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ ತನ್ನ ಗುರುತು ಸಿಕ್ಕುವಂತೆ ಮಾಡುವ ವೇಳೆಯಲ್ಲಿ ಬೇರೆ ಯಾರೂ ಹತ್ತಿರ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ಅವನು ಗಟ್ಟಿಯಾಗಿ ಅತ್ತದ್ದರಿಂದ ಐಗುಪ್ತರಿಗೂ, ಫರೋಹನ ಮನೆಯವರಿಗೂ ಆ ಶಬ್ದವು ಕೇಳಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ಅವನು, “ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ ನಾನು ಯೋಸೇಫನು, ನನ್ನ ತಂದೆ ಇನ್ನೂ ಇದ್ದಾನೋ?” ಎಂದು ಹೇಳಲು ಅವರು ಅವನ ಮುಂದೆ ತತ್ತರಗೊಂಡು ಉತ್ತರಕೊಡಲಾರದೆ ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ಯೋಸೇಫನು, “ನನ್ನ ಹತ್ತಿರಕ್ಕೆ ದಯಮಾಡಿ ಬನ್ನಿರಿ” ಎಂದು ಅಣ್ಣಂದಿರಿಗೆ ಹೇಳಲು ಅವರು ಹತ್ತಿರಕ್ಕೆ ಬಂದರು. ಅವನು ಅವರಿಗೆ “ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಮಾರಿಬಿಟ್ಟ ನಿಮ್ಮ ತಮ್ಮನಾದ ಯೋಸೇಫನು ನಾನೇ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ನೀವು ನನ್ನನ್ನು ಹಾಗೆ ಮಾರಿದ್ದಕ್ಕಾಗಿ ವ್ಯಸನಪಟ್ಟು ದುಃಖಿಸಬೇಡಿರಿ. ಪ್ರಾಣ ಸಂರಕ್ಷಣೆಗಾಗಿ ದೇವರು ನನ್ನನ್ನು ನಿಮ್ಮ ಮುಂದೆ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ದೇಶಕ್ಕೆ ಬರ ಬಂದು ಎರಡು ವರ್ಷವಾಗಿದೆಯಷ್ಟೆ. ಇನ್ನೂ ಐದು ವರ್ಷಗಳ ಪರ್ಯಂತರ ಬಿತ್ತುವುದಕ್ಕಾಗಲಿ, ಕೊಯ್ಯುವುದಕ್ಕಾಗಲಿ, ಅವಕಾಶವಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ನಿಮ್ಮ ಸಂತತಿ ಭೂಮಿಯ ಮೇಲೆ ಉಳಿಯುವಂತೆಯೂ ನೀವು ಈ ವಿಪತ್ತಿಗೆ ಸಿಕ್ಕದೆ, ಬಹು ಜನವಾಗುವಂತೆಯೂ ದೇವರು ನನ್ನನ್ನು ಮೊದಲು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“ದೇವರೇ ನನ್ನನ್ನು ಇಲ್ಲಿಗೆ ಕಳುಹಿಸಿದನಲ್ಲದೆ ನೀವು ಕಳುಹಿಸಲಿಲ್ಲ. ನನ್ನ ತಂದೆಯು ನನ್ನನ್ನು ಫರೋಹನ ಮಂತ್ರಿಯನ್ನಾಗಿಯೂ, ಫರೋಹನ ಅರಮನೆಯಲ್ಲಿ ಅಧಿಪತಿಯನ್ನಾಗಿಯೂ, ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಸರ್ವಾಧಿಕಾರಿಯನ್ನಾಗಿಯೂ ಮಾಡಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ನೀವು ಬೇಗ ನನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ, ‘ನಿನ್ನ ಮಗನಾದ ಯೋಸೇಫನು ಹೀಗೆನ್ನುತ್ತಾನೆ, ದೇವರು ನನ್ನನ್ನು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಸರ್ವಾಧಿಕಾರಿಯನ್ನಾಗಿ ನೇಮಿಸಿದ್ದಾನೆ. ನೀನು ತಡಮಾಡದೆ ನನ್ನ ಬಳಿಗೆ ಬಾ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ಗೋಷೆನ್ ಸೀಮೆಯಲ್ಲಿ ನೀನು ವಾಸಮಾಡಬಹುದು. ನೀನೂ, ನಿನ್ನ ಮಕ್ಕಳೂ, ಮೊಮ್ಮಕ್ಕಳೂ, ಕುರಿದನಗಳೂ ಮೊದಲಾದ ಎಲ್ಲವೂ ನನ್ನ ಬಳಿಯಲ್ಲೇ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ಈ ಬರಗಾಲ ಮುಗಿಯುವುದಕ್ಕೆ ಇನ್ನೂ ಐದು ವರ್ಷ ಹೋಗಬೇಕು. ಆದ್ದರಿಂದ ನಿನಗೂ, ನಿನ್ನ ಮನೆಯವರಿಗೂ ನಿನಗಿರುವ ಎಲ್ಲವುಗಳಿಗೂ ಬಡತನವುಂಟಾಗದಂತೆ ಇಲ್ಲಿ ನಿನ್ನನ್ನು ಪೋಷಿಸುವೆನೆಂದು’ ಹೇಳುತ್ತಾನೆ ಎಂಬುದಾಗಿ ತಿಳಿಸಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“ನಾನು ಸ್ವತಃ ನಿಮ್ಮ ಸಂಗಡ ಮಾತನಾಡಿದ್ದೆನಲ್ಲಾ. ಅದಕ್ಕೆ ನೀವೇ ಸಾಕ್ಷಿ. ನನ್ನ ಒಡಹುಟ್ಟಿದವನಾದ ಬೆನ್ಯಾಮೀನನೂ ಸಾಕ್ಷಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ನನಗಿರುವ ಎಲ್ಲಾ ವೈಭವವನ್ನೂ, ನೀವು ಕಂಡಿದ್ದೆಲ್ಲವನ್ನು ತಂದೆಗೆ ತಿಳಿಸಿ ಬೇಗನೆ ಅವನನ್ನು ಇಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು” ಎಂದು ಹೇಳಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ತನ್ನ ತಮ್ಮನಾದ ಬೆನ್ಯಾಮೀನನ ಕೊರಳನ್ನು ಅಪ್ಪಿಕೊಂಡು ಅತ್ತನು. ಬೆನ್ಯಾಮೀನನೂ ಅವನ ಕೊರಳನ್ನು ಅಪ್ಪಿಕೊಂಡು ಅತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ಇದಲ್ಲದೆ ಅವನು ತನ್ನ ಅಣ್ಣಂದಿರಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನಿಗೂ ಮುದ್ದಿಟ್ಟು ಅವರನ್ನು ಅಪ್ಪಿಕೊಂಡು ಅತ್ತನು. ತರುವಾಯ ಅವರು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ಯೋಸೇಫನ ಅಣ್ಣತಮ್ಮಂದಿರು ಬಂದ ಸಮಾಚಾರವು ಫರೋಹನ ಮನೆಯವರಿಗೆ ತಿಳಿದಾಗ ಫರೋಹನಿಗೂ ಅವನ ಪರಿವಾರದವರಿಗೂ ಸಂತೋಷವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ಫರೋಹನು ಯೋಸೇಫನನ್ನು ಕರೆಯಿಸಿ, “ನೀನು ನಿನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ ತಿಳಿಸಬೇಕಾದ ನನ್ನ ಆಜ್ಞೆ ಏನೆಂದರೆ ‘ನಿಮ್ಮ ಕತ್ತೆಗಳ ಮೇಲೆ ಸಾಮಾನುಗಳನ್ನು ಹೇರಿ ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಹೋಗಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ನಿಮ್ಮ ತಂದೆಯನ್ನೂ ಮನೆಯವರನ್ನೂ ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬನ್ನಿರಿ. ನಾನು ನಿಮಗೆ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ದೊರಕುವ ಉತ್ತಮ ವಸ್ತುಗಳನ್ನು ನಿಮಗೆ ಕೊಡುವೆನು ಮತ್ತು ನೀವು ಈ ದೇಶದ ಸುಖವನ್ನು ಅನುಭವಿಸುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ಮತ್ತು ನಿಮ್ಮ ಹೆಂಡತಿ ಮಕ್ಕಳಿಗೋಸ್ಕರ ಐಗುಪ್ತ ದೇಶದಿಂದ ರಥಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ನಿಮ್ಮ ತಂದೆಯನ್ನು ಕರೆದುಕೊಂಡು ಬನ್ನಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ನಿಮ್ಮ ಸಾಮಗ್ರಿಗಳಿಗಾಗಿ ಚಿಂತಿಸಬೇಡಿರಿ. ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಇರುವ ಉತ್ತಮ ವಸ್ತುಗಳು ನಿಮ್ಮದೇ’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ಇಸ್ರಾಯೇಲನ ಮಕ್ಕಳು ಅದೇ ರೀತಿಯಾಗಿ ಮಾಡಿದರು. ಫರೋಹನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಯೋಸೇಫನು ಅವರಿಗೆ ರಥಗಳನ್ನೂ ಮಾರ್ಗಕ್ಕೆ ಬೇಕಾದ ಆಹಾರವನ್ನೂ ಕೊಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ಇದಲ್ಲದೆ ಪ್ರತಿಯೊಬ್ಬನಿಗೂ ಶ್ರೇಷ್ಠ ವಸ್ತ್ರಗಳನ್ನು ಕೊಟ್ಟನು. ಬೆನ್ಯಾಮೀನನಿಗೋ ಮುನ್ನೂರು ಬೆಳ್ಳಿ ನಾಣ್ಯಗಳನ್ನೂ ಹಾಗೂ ಐದು ಶ್ರೇಷ್ಠ ವಸ್ತ್ರಗಳನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ತನ್ನ ತಂದೆಗೋಸ್ಕರ ಐಗುಪ್ತ ದೇಶದ ಒಳ್ಳೆಯ ವಸ್ತುಗಳನ್ನು ಹತ್ತು ಕತ್ತೆಗಳ ಮೇಲೆ ಹೇರಿಸಿ, ಹತ್ತು ಹೆಣ್ಣುಕತ್ತೆಗಳ ಮೇಲೆ ತನ್ನ ತಂದೆಗೆ ಪ್ರಯಾಣಕ್ಕೆ ಬೇಕಾದ ದವಸ ಧಾನ್ಯಗಳನ್ನು, ರೊಟ್ಟಿ ಮತ್ತು ಇತರ ಆಹಾರವನ್ನು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ಆಗ ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ, “ನೀವು ದಾರಿಯಲ್ಲಿ ಜಗಳಮಾಡಬೇಡಿರಿ” ಎಂದು ಬುದ್ಧಿ ಹೇಳಿ ಅವರಿಗೆ ಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆಕೊಟ್ಟನು. ಅವರು ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ಅವರು ಐಗುಪ್ತ ದೇಶವನ್ನು ಬಿಟ್ಟು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಸೇರಿ ತಂದೆಯಾದ ಯಾಕೋಬನ ಬಳಿಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ಅವನಿಗೆ, “ಯೋಸೇಫನು ಇನ್ನೂ ಜೀವದಿಂದ ಇದ್ದಾನೆ ಅವನು ಐಗುಪ್ತ ದೇಶದ ಸರ್ವಾಧಿಕಾರಿಯಾಗಿದ್ದಾನೆ” ಎಂದು ತಿಳಿಸಲು, ಅವನು ಆಶ್ಚರ್ಯಪಟ್ಟು ನಂಬಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ತರುವಾಯ ಯೋಸೇಫನು ಹೇಳಿ ಕಳುಹಿಸಿದ್ದ ಎಲ್ಲಾ ಮಾತುಗಳನ್ನು ಕೇಳಿ ತನ್ನ ಪ್ರಯಾಣಕ್ಕೋಸ್ಕರ ಯೋಸೇಫನ ಕಡೆಯಿಂದ ಬಂದ ರಥಗಳನ್ನು ನೋಡಿದಾಗ ಯಾಕೋಬನ ಆತ್ಮವು ಉಲ್ಲಾಸಗೊಂಡಿತು, ಅಲ್ಲದೆ ಅವನಿಗೆ ಹೊಸ ಜೀವ ಬಂದಂತಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ಆಗ ಇಸ್ರಾಯೇಲನು, “ನನ್ನ ಮಗನಾದ ಯೋಸೇಫನು ಜೀವಂತವಾಗಿದ್ದಾನೆ. ನಾನು ಸಾಯುವುದಕ್ಕಿಂತ ಮೊದಲು ಹೋಗಿ ಅವನನ್ನು ನೋಡುವೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ಇಸ್ರಾಯೇಲನು ತನಗಿದ್ದ ಸರ್ವಸ್ವವನ್ನು ತೆಗೆದುಕೊಂಡು, ಪ್ರಯಾಣ ಮಾಡಿ ಬೇರ್ಷೆಬಕ್ಕೆ ಬಂದು ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನ ದೇವರಿಗೆ ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ಅಲ್ಲಿ ದೇವರು ರಾತ್ರಿಯ ದರ್ಶನದಲ್ಲಿ ಇಸ್ರಾಯೇಲನಿಗೆ, “ಯಾಕೋಬನೇ, ಯಾಕೋಬನೇ” ಎಂದು ಕರೆಯಲು, ಅವನು, “ಇಗೋ ಇದ್ದೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ಆತನು ಅವನಿಗೆ, “ನಾನೇ ದೇವರು, ನಿನ್ನ ತಂದೆಯ ದೇವರು ನಾನೇ; ನೀನು ಗಟ್ಟಾ ಇಳಿದು ಹೆದರದೆ ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹೋಗು; ಅಲ್ಲಿ ನಿನ್ನಿಂದ ಮಹಾ ಜನಾಂಗವುಂಟಾಗುವಂತೆ ಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ನಾನೇ ನಿನ್ನೊಂದಿಗೆ ಐಗುಪ್ತಕ್ಕೆ ಬರುವೆನು; ಅಲ್ಲಿಂದ ನಿಶ್ಚಯವಾಗಿ ನಿನ್ನನ್ನು ಪುನಃ ಕರೆದುಕೊಂಡು ಬರುವೆನು; (ನಿನ್ನ ಅವಸಾನಕಾಲದಲ್ಲಿ) ನಿನ್ನ ಮರಣದ ಸಮಯದಲ್ಲಿ ಯೋಸೇಫನು ನಿನ್ನೊಂದಿಗೆ ಇದ್ದು ಸಂತೈಸುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ಬಳಿಕ ಯಾಕೋಬನು ಬೇರ್ಷೆಬದಿಂದ ಹೊರಟನು. ಫರೋಹನು ಅವನನ್ನು ಕರೆದುಕೊಂಡು ಬರುವುದಕ್ಕೆ ಕಳುಹಿಸಿದ್ದ ರಥಗಳಲ್ಲಿ ಇಸ್ರಾಯೇಲನ ಮಕ್ಕಳು, ತಮ್ಮ ತಂದೆಯಾದ ಯಾಕೋಬನನ್ನೂ, ಹೆಂಡತಿ ಮಕ್ಕಳನ್ನೂ ಕುಳ್ಳಿರಿಸಿಕೊಂಡು ಹೊರಟರು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ಯಾಕೋಬನೂ, ಅವನ ಮನೆಯವರೆಲ್ಲರೂ ತಮ್ಮ ದನಕುರಿಗಳನ್ನೂ ತಾವು ಕಾನಾನ್‌ ದೇಶದಲ್ಲಿ ಸಂಪಾದಿಸಿಕೊಂಡಿದ್ದ ಸಂಪತ್ತುಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಐಗುಪ್ತ ದೇಶವನ್ನು ತಲುಪಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ಹೀಗೆ ಯಾಕೋಬನು ತನ್ನ ಗಂಡು ಹೆಣ್ಣು ಮಕ್ಕಳನ್ನೂ, ಮೊಮ್ಮಕ್ಕಳನ್ನೂ, ತನ್ನ ಮನೆಯವರೆಲ್ಲರನ್ನೂ ತನ್ನ ಸಂಗಡಲೇ ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಬಂದು ಸೇರಿದ ಇಸ್ರಾಯೇಲನ ಮಕ್ಕಳ ಹೆಸರುಗಳು: ಯಾಕೋಬನು ಮತ್ತು ಅವನ ಚೊಚ್ಚಲ ಮಗನಾದ ರೂಬೇನನು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ರೂಬೇನನ ಮಕ್ಕಳು: ಹನೋಕ್, ಫಲ್ಲೂ, ಹೆಚ್ರೋನ್, ಕರ್ಮೀ. ");
INSERT INTO kanirv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ಸಿಮೆಯೋನನ ಮಕ್ಕಳು: ಯೆಮೂವೇಲ್, ಯಾಮೀನ್, ಓಹದ್, ಯಾಕೀನ್, ಚೋಹರ್ ಮತ್ತು ಕಾನಾನ್ಯ ಸ್ತ್ರೀಯಲ್ಲಿ ಹುಟ್ಟಿದ ಸೌಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ಲೇವಿಯ ಮಕ್ಕಳು: ಗೇರ್ಷೋನ್, ಕೆಹಾತ್, ಮೆರಾರೀ. ");
INSERT INTO kanirv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ಯೆಹೂದನ ಮಕ್ಕಳು: ಏರ್, ಓನಾನ್, ಶೇಲಾಹ, ಪೆರೆಚ್, ಜೆರಹ. ಇವರಲ್ಲಿ ಏರ್, ಓನಾನ್ ಎಂಬವರು ಕಾನಾನ್ ದೇಶದಲ್ಲೇ ಸತ್ತು ಹೋಗಿದ್ದರು. ಪೆರೆಚನ ಮಕ್ಕಳು: ಹೆಚ್ರೋನ್, ಹಾಮೂಲ್. ");
INSERT INTO kanirv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ಇಸ್ಸಾಕಾರನ ಮಕ್ಕಳು: ತೋಲಾ, ಪುವ್ವಾ, ಯೋಬ್, ಶಿಮ್ರೋನ್. ");
INSERT INTO kanirv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ಜೆಬುಲೂನನ ಮಕ್ಕಳು: ಸೆರೆದ್, ಏಲೋನ್, ಯಹ್ಲೇಲ್ ");
INSERT INTO kanirv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ಇವರೆಲ್ಲರು ಲೇಯಳ ಸಂತತಿಯವರು. ಆಕೆಯು ಯಾಕೋಬನಿಗೆ ಇವರನ್ನೂ, ದೀನಳೆಂಬ ಹೆಣ್ಣು ಮಗಳನ್ನೂ ಪದ್ದನ್ ಅರಾಮಿನಲ್ಲಿ ಪಡೆದಳು. ಆಕೆಯಿಂದ ಹುಟ್ಟಿದ ಗಂಡು ಹೆಣ್ಣು ಮಕ್ಕಳು ಮೂವತ್ತು ಮೂರು ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ಗಾದನ ಮಕ್ಕಳು: ಚಿಪ್ಯೋನ್, ಹಗ್ಗೀ, ಶೂನೀ, ಎಚ್ಬೋನ್, ಏರೀ, ಅರೋದೀ, ಅರೇಲೀ; ");
INSERT INTO kanirv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ಆಶೇರನ ಮಕ್ಕಳು: ಇಮ್ನಾ, ಇಷ್ವಾ, ಇಷ್ವೀ, ಬೆರೀಗಾ, ಇವರ ತಂಗಿಯಾದ ಸೆರಹ; ಬೆರೀಗನ ಮಕ್ಕಳಾದ ಹೆಬೆರ್, ಮಲ್ಕೀಯೇಲ್. ");
INSERT INTO kanirv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ಇವರೆಲ್ಲರು ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ಲೇಯಳಿಗೆ ಕೊಟ್ಟ ಜಿಲ್ಪಳ ಸಂತತಿಯವರು. ಈಕೆಯಿಂದ ಯಾಕೋಬನಿಗಾದ ಮಕ್ಕಳೂ ಮೊಮ್ಮಕ್ಕಳೂ ಹದಿನಾರು ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ಯಾಕೋಬನ ಹೆಂಡತಿಯಾದ ರಾಹೇಲಳ ಮಕ್ಕಳು ಯೋಸೇಫ್, ಬೆನ್ಯಾಮೀನ್. ");
INSERT INTO kanirv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಯೋಸೇಫನಿಗೆ ಓನ್ ಪಟ್ಟಣದ ಪುರೋಹಿತನಾದ ಪೋಟೀಫೆರನ ಮಗಳಾದ ಆಸನತ್ ಎಂಬಾಕೆಯಲ್ಲಿ ಹುಟ್ಟಿದವರು ಮನಸ್ಸೆ ಮತ್ತು ಎಫ್ರಾಯೀಮ್. ");
INSERT INTO kanirv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ಬೆನ್ಯಾಮೀನನ ಮಕ್ಕಳು: ಬಿಳಾ, ಬೆಕೆರ್, ಅಶ್ಬೇಲ್, ಗೇರಾ, ನಾಮಾನ್, ಏಹೀ, ರೋಷ್, ಮುಪ್ಪೀಮ್, ಹುಪ್ಪೀಮ್, ಆರ್ದ್. ");
INSERT INTO kanirv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ಈ ಹದಿನಾಲ್ಕು ಮಂದಿಯು ರಾಹೇಲಳ ಮೂಲಕ ಯಾಕೋಬನಿಂದಾದ ಸಂತತಿಯವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ದಾನನ ಮಗನು: ಹುಶೀಮ್. ");
INSERT INTO kanirv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ನಫ್ತಾಲಿಯ ಮಕ್ಕಳು: ಯಹೇಲ್, ಗೂನೀ, ಯೇಚೆರ್, ಶಿಲ್ಲೇಮ್. ");
INSERT INTO kanirv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ಇವರು ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ರಾಹೇಲಳಿಗೆ ಕೊಟ್ಟ ಬಿಲ್ಹಳ ಸಂತತಿಯವರು. ಈಕೆಯಿಂದ ಯಾಕೋಬನಿಗಾದ ಮಕ್ಕಳೂ ಮೊಮ್ಮಕ್ಕಳೂ ಏಳು ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ಯಾಕೋಬನ ಸೊಸೆಯರಲ್ಲದೆ ಯಾಕೋಬನಿಂದಲೇ ಹುಟ್ಟಿ ಅವನೊಂದಿಗೆ ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹೋದವರು ಒಟ್ಟು ಅರವತ್ತಾರು ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ಅವರಲ್ಲದೆ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಯೋಸೇಫನಿಗೆ ಹುಟ್ಟಿದವರು ಇಬ್ಬರು. ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹೋದ ಯಾಕೋಬನ ಕುಟುಂಬದವರೆಲ್ಲರು ಒಟ್ಟು ಎಪ್ಪತ್ತು ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ಯಾಕೋಬನು ಗೋಷೆನ್ ಸೀಮೆಯ ದಾರಿಯನ್ನು ವಿಚಾರಿಸುವುದಕ್ಕೆ ಯೆಹೂದನನ್ನು ಮುಂದಾಗಿ ಯೋಸೇಫನ ಬಳಿಗೆ ಕಳುಹಿಸಿದನು. ಅವರು ಗೋಷೆನ್ ಸೀಮೆಗೆ ಬಂದಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ಯೋಸೇಫನು ತನ್ನ ರಥವನ್ನು ಸಿದ್ಧಪಡಿಸಿಕೊಂಡು ತನ್ನ ತಂದೆಯಾದ ಇಸ್ರಾಯೇಲನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೋಸ್ಕರ ಗೋಷೆನಿಗೆ ಹೋಗಿ ಅವನನ್ನು ಸಂಧಿಸಿ, ತಂದೆಯನ್ನು ಬಹಳ ಹೊತ್ತಿನ ವರೆಗೆ ಅಪ್ಪಿಕೊಂಡು ಅತ್ತನು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನಿಗೆ, “ನಾನು ನಿನ್ನ ಮುಖವನ್ನು ನೋಡಿ, ನೀನು ಇನ್ನೂ ಜೀವದಿಂದಿರುವುದನ್ನು ಕಂಡು ಸಂತೃಪ್ತನಾಗಿ ಸಾಯುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ಯೋಸೇಫನು ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರನ್ನೂ, ತಂದೆಯ ಮನೆಯವರೆಲ್ಲರನ್ನು ಕುರಿತು “ನಾನು ಹೋಗಿ ಫರೋಹನ ಸನ್ನಿಧಾನದಲ್ಲಿ ನೀವು ಬಂದ ವರ್ತಮಾನವನ್ನು ತಿಳಿಸಿ, ಕಾನಾನ್‌ ದೇಶದಲ್ಲಿದ್ದ ನನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರೂ, ತನ್ನ ತಂದೆಯ ಮನೆಯವರೂ ನನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದಾರೆ; ");
INSERT INTO kanirv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ಅವರು ಕುರಿಕಾಯುವವರು, ಪಶುಪಾಲನೆ ಮಾಡುವುದು ಅವರ ಕಸುಬು; ಅವರು ತಮ್ಮ ಕುರಿದನಗಳನ್ನೂ ತಮಗಿರುವ ಸರ್ವಸ್ವವನ್ನೂ ತಂದಿದ್ದಾರೆ” ಎಂದು ಹೇಳುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ಫರೋಹನು ನಿಮ್ಮನ್ನು ಕರೆಯಿಸಿ, “ನಿಮ್ಮ ಕಸುಬು ಏನು?” ಎಂದು ಕೇಳಿದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","“ನೀವು ಚಿಕ್ಕಂದಿನಿಂದ ಇದುವರೆಗೂ ನಿನ್ನ ಸೇವಕರಾದ ನಾವು ನಮ್ಮ ಪೂರ್ವಿಕರ ಪದ್ಧತಿಯ ಮೇರೆಗೆ ಪಶುಪಾಲಕರು ಎಂದು ಹೇಳಿರಿ. ಪಶುಪಾಲಕರು ಐಗುಪ್ತರಿಗೆ ಅಸಹ್ಯವಾಗಿರುವುದರಿಂದ, ಗೋಷೆನ್ ಸೀಮೆಯನ್ನು ನಿಮ್ಮ ನಿವಾಸಕ್ಕಾಗಿ ನೇಮಿಸುವನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ಆಗ ಯೋಸೇಫನು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, “ನನ್ನ ತಂದೆಯೂ, ಅಣ್ಣತಮ್ಮಂದಿರೂ, ಕುರಿದನಗಳನ್ನೂ, ಸಮಸ್ತ ಆಸ್ತಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಕಾನಾನ್‌ ದೇಶದಿಂದ ಬಂದು ಗೋಷೆನ್ ಸೀಮೆಯಲ್ಲಿ ಉಳಿದುಕೊಂಡಿದ್ದಾರೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ಅಲ್ಲದೆ ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಲ್ಲಿ ಐದು ಮಂದಿಯನ್ನು ಕರೆದುಕೊಂಡು ಬಂದು ಫರೋಹನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ಫರೋಹನು ಯೋಸೇಫನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ, “ನಿಮ್ಮ ಕಸುಬು ಏನು?” ಎಂದು ಅವರನ್ನು ಕೇಳಲು ಅವರು, “ನಿನ್ನ ಸೇವಕರಾದ ನಾವು ನಮ್ಮ ಪೂರ್ವಿಕರ ಹಾಗೆ ಕುರಿಕಾಯುವವರು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ಅದಲ್ಲದೆ ಅವರು ಫರೋಹನಿಗೆ, “ಕಾನಾನ್‌ ದೇಶದಲ್ಲಿ ಬರಗಾಲವು ಘೋರವಾಗಿರುವುದರಿಂದ ನಿನ್ನ ಸೇವಕರ ಕುರಿದನಗಳಿಗೆ ಮೇವು ಸಿಕ್ಕಲಿಲ್ಲ; ಆದುದರಿಂದ ಈ ದೇಶದಲ್ಲಿ ಸ್ವಲ್ಪಕಾಲ ಇರಬೇಕೆಂದು ಬಂದಿದ್ದೇವೆ. ನಾವು ಗೋಷೆನ್ ಸೀಮೆಯಲ್ಲಿ ವಾಸಮಾಡುವಂತೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು” ಎಂದು ಬೇಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ಆಗ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ತಂದೆಯೂ, ಅಣ್ಣತಮ್ಮಂದಿರೂ ನಿನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದಾರೆ; ");
INSERT INTO kanirv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ಐಗುಪ್ತ ದೇಶವು ನಿನ್ನ ಮುಂದೆ ಇದೆ, ಅದರೊಳಗೆ ಉತ್ತಮ ಭಾಗದಲ್ಲಿ ನಿನ್ನ ತಂದೆ, ನಿನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರು ವಾಸಮಾಡುವಂತೆ ಮಾಡು. ಅವರು ಗೋಷೆನ್ ಸೀಮೆಯಲ್ಲಿ ವಾಸಮಾಡಲಿ; ಅವರಲ್ಲಿ ಯಾರಾದರೂ ಸಮರ್ಥರೆಂದು ತಿಳಿದರೆ ಅವರನ್ನು ನನ್ನ ಕುರಿದನ ಮಂದೆಗಳ ಮೇಲ್ವಿಚಾರಣೆಗಾಗಿ ನೇಮಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯಾದ ಯಾಕೋಬನನ್ನು ಕರೆದುಕೊಂಡು ಫರೋಹನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಲ್ಲಿಸಲು, ಯಾಕೋಬನು ಫರೋಹನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ಫರೋಹನು, “ನಿನಗೆ ಈಗ ಎಷ್ಟು ವರ್ಷ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ಯಾಕೋಬನು ಫರೋಹನಿಗೆ, “ನನ್ನ ಇಹಲೋಕ ಪ್ರಯಾಣದ ಕಾಲವು ನೂರಮೂವತ್ತು ವರ್ಷಗಳು. ನಾನು ಜೀವಿಸಿರುವ ಕಾಲವು ಸ್ವಲ್ಪವಾಗಿಯೂ ಹಾಗೂ ದುಃಖಕರವಾಗಿಯೂ ಇತ್ತು; ಆದರೂ ನನ್ನ ಪೂರ್ವಿಕರು ಜೀವಿಸಿದಷ್ಟು ವರ್ಷಗಳು ನನಗಾಗಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ಪುನಃ ಯಾಕೋಬನು ಫರೋಹನನ್ನು ಆಶೀರ್ವದಿಸಿ ಅವನ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ಫರೋಹನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೂ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೂ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡಲು ಉತ್ತಮವಾಗಿದ್ದ ರಮ್ಸೇಸ್ ಪ್ರದೇಶದಲ್ಲಿ ಸ್ವತ್ತು ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೂ, ಅಣ್ಣತಮ್ಮಂದಿರಿಗೂ, ತಂದೆಯ ಮನೆಯವರೆಲ್ಲರಿಗೂ ಅವರವರ ಕುಟುಂಬಗಳಿಗೆ ಸೇರಿದವರ ಲೆಕ್ಕದ ಪ್ರಕಾರ ಆಹಾರವನ್ನು ಕೊಟ್ಟು ಅವರನ್ನು ಸಂರಕ್ಷಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ಬರವು ಬಹು ಘೋರವಾಗಿದ್ದುದರಿಂದ ದೇಶದ ಯಾವ ಭಾಗದಲ್ಲಿಯೂ ಆಹಾರ ಸಿಕ್ಕುತ್ತಿರಲಿಲ್ಲ. ಆ ಬರದ ನಿಮಿತ್ತ ಐಗುಪ್ತ ದೇಶವು ಹಾಗೂ ಕಾನಾನ್‌ ದೇಶವು ಕ್ಷಾಮದಿಂದ ಬರಡಾದವು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ಯೋಸೇಫನು ಜನರಿಗೆ ಧಾನ್ಯವನ್ನು ಮಾರುತ್ತಾ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿಯೂ, ಕಾನಾನ್‌ ದೇಶದಲ್ಲಿಯೂ ಇದ್ದ ಎಲ್ಲಾ ಹಣವನ್ನು ಕೂಡಿಸಿಕೊಂಡು ಫರೋಹನ ಬೊಕ್ಕಸದೊಳಗೆ ತುಂಬಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ಐಗುಪ್ತ ದೇಶದಲ್ಲಿಯೂ, ಕಾನಾನ್‌ ದೇಶದಲ್ಲಿಯೂ ಇದ್ದ ಹಣವೆಲ್ಲಾ ಮುಗಿದುಹೋದ ನಂತರ ಐಗುಪ್ತರೆಲ್ಲರೂ ಯೋಸೇಫನ ಬಳಿಗೆ ಬಂದು, “ನಮ್ಮ ಹಣವೆಲ್ಲಾ ಮುಗಿದುಹೋಯಿತು; ನೀನು ನಮಗೆ ಆಹಾರವನ್ನು ಕೊಡಬೇಕು; ನಾವು ನಿನ್ನ ಮುಂದೆ ಸತ್ತರೆ ಪ್ರಯೋಜನವೇನು?” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ಅದಕ್ಕೆ ಯೋಸೇಫನು, “ನಿಮ್ಮ ಕುರಿದನಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬನ್ನಿರಿ; ಹಣವಿಲ್ಲದಿದ್ದರೆ ಕುರಿದನಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ಧಾನ್ಯವನ್ನು ನಿಮಗೆ ಕೊಡುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ಅವರು ತಮ್ಮ ಕುರಿದನಗಳನ್ನು ಯೋಸೇಫನ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಬರಲು, ಅವನು ಅವರ ಕುದುರೆಗಳನ್ನೂ, ಕುರಿದನಗಳನ್ನೂ, ಕತ್ತೆಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಅವರಿಗೆ ಧಾನ್ಯವನ್ನು ಕೊಟ್ಟನು. ಆ ವರ್ಷದಲ್ಲಿ ಅವರ ಕುರಿದನಗಳನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು ಧಾನ್ಯವನ್ನು ಕೊಟ್ಟು ಅವರನ್ನು ಸಂರಕ್ಷಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ಆ ವರ್ಷ ಕಳೆದ ನಂತರ ಅವರು ಎರಡನೆಯ ವರ್ಷದಲ್ಲಿ ಅವನ ಬಳಿಗೆ ಬಂದು, “ನಮ್ಮ ಹಣವೆಲ್ಲಾ ಮುಗಿದು ಹೋಗಿದೆ; ನಮ್ಮ ಕುರಿದನಗಳು ಸ್ವಾಮಿಯ ವಶವಾದವು; ಹೀಗಿರುವುದರಿಂದ ನಮ್ಮ ಭೂಮಿಯೂ, ನಮ್ಮ ದೇಹಗಳೂ ಹೊರತು ಬೇರೆ ಇನ್ನೇನೂ ಉಳಿದಿಲ್ಲವೆಂದು ನಮ್ಮ ಸ್ವಾಮಿಗೆ ಮರೆಮಾಡದೆ ತಿಳಿಸುತ್ತೇವೆ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","“ನಿನ್ನ ಕಣ್ಣೆದುರಿಗೆ ನಾವು ಏಕೆ ಸಾಯಬೇಕು; ನಮ್ಮ ಭೂಮಿಯು ಏಕೆ ಹಾಳಾಗಬೇಕು; ನಮ್ಮನ್ನೂ ನಮ್ಮ ಭೂಮಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಧಾನ್ಯವನ್ನು ಕೊಡು; ನಾವು ನಮ್ಮ ಭೂಮಿಯನ್ನು ಫರೋಹನಿಗೆ ಕೊಟ್ಟುಬಿಟ್ಟು ಅವನಿಗೆ ಗುಲಾಮರಾಗುವೆವು. ನಾವು ಸಾಯದೆ ಬದುಕಬೇಕಾದರೆ ಮತ್ತು ಭೂಮಿಯು ಹಾಳಾಗದ ಹಾಗೆ ನೀನು ನಮಗೆ ಬಿತ್ತನೆ ಬೀಜವನ್ನು ಕೊಡಬೇಕು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ಹೀಗೆ ಯೋಸೇಫನು ಐಗುಪ್ತರಿಂದ ಎಲ್ಲಾ ಸಾಗುವಳಿಯ ಭೂಮಿಯನ್ನು ಫರೋಹನಿಗಾಗಿ ಕೊಂಡುಕೊಂಡನು. ಪ್ರತಿಯೊಬ್ಬ ಐಗುಪ್ತನ್ನು ತನ್ನ ಹೊಲಗದ್ದೆಗಳನ್ನು ಮಾರಿಬಿಟ್ಟನು. ಬರವು ಐಗುಪ್ತದಲ್ಲಿ ಘೋರವಾಗಿದ್ದದರಿಂದ ಅವರೆಲ್ಲರ ಭೂಮಿಯು ಫರೋಹನ ವಶವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ಯೋಸೇಫನು ಐಗುಪ್ತ ದೇಶದ ಒಂದು ಮೇರೆಯಿಂದ ಮತ್ತೊಂದು ಮೇರೆಯವರೆಗೂ ಪ್ರಜೆಗಳನ್ನು ದಾಸರನ್ನಾಗಿ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ಪುರೋಹಿತರ ಭೂಮಿಯನ್ನು ಮಾತ್ರ ಅವನು ಕೊಂಡುಕೊಳ್ಳಲಿಲ್ಲ. ಪುರೋಹಿತರು ಫರೋಹನ ಕಡೆಯಿಂದ ಭತ್ಯೆ ಸಿಕ್ಕಿದ್ದರಿಂದ ಅವರು ಫರೋಹನು ಕೊಟ್ಟ ಭತ್ಯೆದಿಂದಲೇ ಜೀವನ ಮಾಡುತ್ತಿದ್ದರು; ಆದುದರಿಂದ ತಮ್ಮ ಭೂಮಿಯನ್ನು ಮಾರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ಯೋಸೇಫನು ಪ್ರಜೆಗಳಿಗೆ, “ನಾನು ಈ ಹೊತ್ತು ನಿಮ್ಮನ್ನೂ ನಿಮ್ಮ ಭೂಮಿಯನ್ನೂ ಫರೋಹನಿಗೋಸ್ಕರ ಕೊಂಡುಕೊಂಡಿದ್ದೇನೆ ಎಂದು ತಿಳಿದುಕೊಳ್ಳಿರಿ. ಇಗೋ, ಬಿತ್ತನೆಗಾಗಿ ನಿಮಗೆ ಬೀಜವನ್ನು ಕೊಟ್ಟಿದ್ದೇನೆ; ಭೂಮಿಯನ್ನು ಬಿತ್ತಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ಪೈರು ಕೊಯ್ಯುವ ಕಾಲದಲ್ಲಿ ಐದರಲ್ಲೊಂದು ಪಾಲು ಫರೋಹನಿಗೆ ಸಲ್ಲಬೇಕು; ಮಿಕ್ಕ ನಾಲ್ಕು ಪಾಲು ನಿಮ್ಮದು; ಅದು ಬೀಜಕ್ಕೆ ಆಗುತ್ತದೆ ಮತ್ತು ನಿಮಗೂ ನಿಮ್ಮ ಮನೆಯವರಿಗೂ ನಿಮ್ಮ ಕುಟುಂಬಕ್ಕೆ ಸೇರಿದವರೆಲ್ಲರಿಗೂ ಆಹಾರಕ್ಕಾಗುತ್ತದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ಅದಕ್ಕೆ ಅವರು, “ನಮ್ಮ ಪ್ರಾಣಗಳನ್ನು ಉಳಿಸಿದ್ದೀ; ನಮ್ಮ ಸ್ವಾಮಿಯ ದಯೆ ನಿಮ್ಮ ಮೇಲಿರಲಿ; ನಾವು ಫರೋಹನಿಗೆ ಗುಲಾಮರಾಗಿದ್ದೇವೆ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ಬೆಳೆಯಲ್ಲಿ ಐದನೆಯ ಒಂದು ಪಾಲು ಫರೋಹನಿಗೆ ಸಲ್ಲಬೇಕೆಂಬುದನ್ನು ಯೋಸೇಫನು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಕಟ್ಟಳೆಯಾಗಿ ಮಾಡಿದನು. ಈ ದಿನದ ವರೆಗೂ ಅದು ಹಾಗೆಯೇ ಇದೆ. ಪುರೋಹಿತರ ಭೂಮಿ ಮಾತ್ರ ಫರೋಹನಿಗೆ ಸ್ವಾಧೀನವಾಗಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ಇಸ್ರಾಯೇಲರು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಸೇರಿರುವ ಗೋಷೆನ್ ಸೀಮೆಯಲ್ಲಿ ವಾಸಮಾಡಿದರು. ಅದರಲ್ಲಿ ಅವರು ಆಸ್ತಿಯನ್ನು ಸಂಪಾದಿಸಿ ಬಹುಸಂತಾನವಾಗಿ ಬಹಳವಾಗಿ ಹೆಚ್ಚಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ಯಾಕೋಬನು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಹದಿನೇಳು ವರ್ಷ ಬದುಕಿದನು. ಅವನ ಜೀವಿತ ಕಾಲದ ದಿನಗಳು ನೂರ ನಲ್ವತ್ತೇಳು ವರ್ಷಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ಇಸ್ರಾಯೇಲನಿಗೆ ಮರಣಕಾಲ ಸಮೀಪಿಸಿದಾಗ ಅವನು ತನ್ನ ಮಗನಾದ ಯೋಸೇಫನನ್ನು ಕರೆಯಿಸಿ, “ಈಗ ನಿನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ನಾನು ದಯೆ ಹೊಂದ್ದಿದೆಯಾದ್ದರೆ ಪದ್ದತಿಯ ಪ್ರಕಾರ ನಿನ್ನ ಕೈಯನ್ನು ನನ್ನ ತೊಡೆಯ ಕೆಳಗೆ ಇಟ್ಟು ನನಗೆ ಉಪಕಾರವನ್ನು ನಂಬಿಗಸ್ತಿಕೆಯಿಂದ ತೋರಿಸು. ನನ್ನನ್ನು ಐಗುಪ್ತದೇಶದಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಬೇಡ. ");
INSERT INTO kanirv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ನಾನು ಮರಣ ಹೊಂದಿ ನನ್ನ ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರಿದಾಗ ನನ್ನ ಮೃತ ದೇಹವನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಆ ಪೂರ್ವಿಕರ ಸ್ಮಶಾನ ಭೂಮಿಯಲ್ಲಿಯೇ ಸಮಾಧಿ ಮಾಡಬೇಕು. ಹಾಗೆ ಮಾಡುತ್ತೇನೆಂಬುದಾಗಿ ನನಗೆ ಪ್ರಮಾಣ ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಲು, ಅವನು, “ನೀನು ಹೇಳಿದಂತೆಯೇ ಮಾಡುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ಇಸ್ರಾಯೇಲನು, “ಪ್ರಮಾಣಮಾಡು” ಎನ್ನಲು ಅವನು ಪ್ರಮಾಣ ಮಾಡಿದನು. ಆಗ ಇಸ್ರಾಯೇಲನು ತನ್ನ ಊರುಕೋಲಿನ ಮೇಲೆ ಬಾಗಿ ದೇವರಿಗೆ ನಮಸ್ಕಾರ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ಕೆಲವು ಕಾಲವಾದ ಮೇಲೆ ಯೋಸೇಫನಿಗೆ, “ಅವನ ತಂದೆಯು ಅಸ್ವಸ್ಥನಾಗಿದ್ದಾನೆ” ಎಂಬ ವಾರ್ತೆಯು ದೊರಕಿತು. ಆಗ ಯೋಸೇಫನು ಮನಸ್ಸೆ ಎಫ್ರಾಯೀಮರೆಂಬ ತನ್ನಿಬ್ಬರು ಮಕ್ಕಳನ್ನು ತನ್ನ ಸಂಗಡ ಕರೆದುಕೊಂಡು ತಂದೆಯ ಬಳಿಗೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","“ನಿನ್ನ ಮಗನಾದ ಯೋಸೇಫನು ನಿನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದಾನೆ” ಎಂದು ಯಾಕೋಬನಿಗೆ ತಿಳಿಸಲು, ಇಸ್ರಾಯೇಲನು ಚೇತರಿಸಿಕೊಂಡು ಹಾಸಿಗೆಯ ಮೇಲೆ ಎದ್ದು ಕುಳಿತುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ಯಾಕೋಬನು, ಯೋಸೇಫನಿಗೆ, “ಸರ್ವಶಕ್ತನಾದ ದೇವರು ಕಾನಾನ್ ದೇಶದ ಲೂಜ್ ಎಂಬಲ್ಲಿ ನನಗೆ ದರ್ಶನ ಕೊಟ್ಟು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ಆತನು ನನಗೆ, ‘ನಿನ್ನನ್ನು ಅಭಿವೃದ್ಧಿಪಡಿಸಿ ನಿನ್ನ ಸಂತತಿಯನ್ನು ಹೆಚ್ಚಿಸುವೆನು. ಅನೇಕ ಜನಾಂಗಗಳು ನಿನ್ನಿಂದುಟಾಗುವಂತೆ ಮಾಡುವೆನು. ನಿನ್ನ ತರುವಾಯ ನಿನ್ನ ಸಂತತಿಗೆ ಈ ದೇಶವನ್ನು ಶಾಶ್ವತ ಸೊತ್ತನ್ನಾಗಿ ಕೊಡುವೆನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ನಿನ್ನ ಬಳಿಗೆ ಬರುವುದಕ್ಕಿಂತ ಮೊದಲು ಇಲ್ಲಿ ಹುಟ್ಟಿದ ನಿನ್ನಿಬ್ಬರು ಮಕ್ಕಳು ನನಗೆ ಮಕ್ಕಳಾಗಿರಬೇಕು. ರೂಬೇನ್ ಸಿಮೆಯೋನರು ನನ್ನ ಮಕ್ಕಳಾಗಿರುವಂತೆಯೆ ಎಫ್ರಾಯೀಮ್ ಮನಸ್ಸೆಯರೂ ನನ್ನ ಮಕ್ಕಳಾಗಿರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ಅವರ ತರುವಾಯ ನೀನು ಪಡೆದ ಮಕ್ಕಳು ನಿನ್ನವರಾಗಿರಲಿ. ಅವರು ತಮ್ಮ ಅಣ್ಣಂದಿರ ಸ್ವತ್ತಿನಲ್ಲಿ ಬಾಧ್ಯತೆ ಹೊಂದಿ, ಅವರ ಕುಲದ ಹೆಸರನ್ನೇ ಇಟ್ಟುಕೊಳ್ಳಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ನಾನು ಪದ್ದನ್ ಅರಾಮಿನಿಂದ ಬರುವಾಗ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಎಫ್ರಾತನ್ನು ಸೇರುವುದಕ್ಕೆ ಇನ್ನೂ ಸ್ವಲ್ಪ ದೂರವಿದ್ದಾಗ ರಾಹೇಲಳು ದಾರಿಯಲ್ಲೇ ಸತ್ತುಹೋದಳು. ಬೇತ್ಲೆಹೇಮ್ ಎಂಬ ಎಫ್ರಾತಿಗೆ ಹೋಗುವ ಮಾರ್ಗದಲ್ಲಿ ಆಕೆಗೆ ಸಮಾಧಿ ಮಾಡಿದೆನು ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ನಂತರ ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನ ಮಕ್ಕಳನ್ನು ನೋಡಿ, “ಇವರು ಯಾರು?” ಎಂದು ಕೇಳಲು, ");
INSERT INTO kanirv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೆ, “ಇವರು ಈ ದೇಶದಲ್ಲಿ ನನಗೆ ದೇವರು ಅನುಗ್ರಹಿಸಿದ ಮಕ್ಕಳು” ಎಂದು ಹೇಳಿದನು. ಅದಕ್ಕವನು, “ನಾನು ಇವರನ್ನು ಆಶೀರ್ವದಿಸುತ್ತೇನೆ. ನನ್ನ ಹತ್ತಿರ ಕರೆದುಕೊಂಡು ಬಾ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ಇಸ್ರಾಯೇಲನು ವೃದ್ಧಾಪ್ಯದಿಂದ ಮೊಬ್ಬು ಕಣ್ಣುಳ್ಳವನಾಗಿ ನೋಡಲಾರದೆ ಇದ್ದನು. ಯೋಸೇಫನು ಅವರನ್ನು ಅವನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಲು ಅವನು ಅವರನ್ನು ಮುದ್ದಿಟ್ಟು ಅಪ್ಪಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ಆಗ ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ಮುಖವನ್ನು ತಿರುಗಿ ನೋಡುವೆನೆಂದು ನಾನು ನೆನಸಿರಲಿಲ್ಲ. ಆದರೆ ನಾನು ನಿನ್ನನ್ನು ಮಾತ್ರವಲ್ಲದೆ ನಿನ್ನ ಸಂತಾನವನ್ನೂ ನೋಡುವಂತೆ ದೇವರು ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ಆಗ ಯೋಸೇಫನು ಅವರನ್ನು ತಂದೆಯ ಮಡಿಲಿನಿಂದ ಎತ್ತಿಕೊಂಡು ತನ್ನ ತಂದೆಗೆ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ತರುವಾಯ ಯೋಸೇಫನು ತನ್ನ ಬಲಗಡೆಯಲ್ಲಿ ಇಸ್ರಾಯೇಲನ ಎಡಗೈಗೆ ಎದುರಾಗಿ ಎಫ್ರಾಯೀಮನನ್ನೂ, ತನ್ನ ಎಡಗಡೆಯಲ್ಲಿ ಇಸ್ರಾಯೇಲನ ಬಲಗೈಗೆ ಎದುರಾಗಿ ಮನಸ್ಸೆಯನ್ನೂ ನಿಲ್ಲಿಸಿ, ಅವರಿಬ್ಬರನ್ನೂ ತನ್ನ ತಂದೆಯ ಬಳಿ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ಮನಸ್ಸೆಯು ಚೊಚ್ಚಲ ಮಗನಾಗಿದ್ದರೂ, ಇಸ್ರಾಯೇಲನು ತನ್ನ ಕೈಗಳನ್ನು ಅಡ್ಡವಾಗಿ ಚಾಚಿ ಕಿರಿಯವನಾದ ಎಫ್ರಾಯೀಮನ ತಲೆಯ ಮೇಲೆ ಬಲಗೈಯನ್ನೂ, ಮನಸ್ಸೆಯ ತಲೆಯ ಮೇಲೆ ಎಡಗೈಯನ್ನೂ ಇಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ನಂತರ ಅವನು ಯೋಸೇಫನನ್ನು, ಆಶೀರ್ವದಿಸಿ, “ನನ್ನ ಪೂರ್ವಿಕರಾದ ಅಬ್ರಹಾಮ ಇಸಾಕರು ಸೇವಿಸಿದ ದೇವರೇ, ನನ್ನನ್ನು ಚಿಕ್ಕಂದಿನಿಂದ ಈ ದಿನದ ವರೆಗೂ ಪರಾಂಬರಿಸುತ್ತಾ ಬಂದ ದೇವರು, ");
INSERT INTO kanirv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ನನ್ನನ್ನು ಎಲ್ಲಾ ಕೇಡುಗಳಿಂದ ತಪ್ಪಿಸಿ ಕಾಪಾಡುತ್ತಾ ಬಂದ ದೂತನಾಗಿಯೂ ಇರುವಾತನು ಈ ಹುಡುಗರನ್ನು ಆಶೀರ್ವದಿಸಲಿ. ಇವರು ನನ್ನ ಹೆಸರನ್ನು, ನನ್ನ ಪೂರ್ವಿಕರಾದ ಅಬ್ರಹಾಮ ಇಸಾಕರ ಹೆಸರಿನಿಂದ ಇವರ ಹೆಸರುಗಳು ನೆಲೆಗೊಳ್ಳಲಿ, ಇವರು ಭೂಮಿಯ ಮೇಲೆ ಹೆಚ್ಚಿ ಬಹು ಸಂತಾನವನ್ನು ಪಡೆಯಲಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ತನ್ನ ತಂದೆಯು ಬಲಗೈಯನ್ನು ಎಫ್ರಾಯೀಮನ ತಲೆಯ ಮೇಲೆ ಇಡುವುದನ್ನು ಯೋಸೇಫನು ಕಂಡು ಅಸಮಾಧಾನಪಟ್ಟು ಅವನ ಕೈಯನ್ನು ಎಫ್ರಾಯೀಮನ ತಲೆಯಿಂದ ಎತ್ತಿ ಮನಸ್ಸೆಯ ತಲೆಯ ಮೇಲೆ ಇಟ್ಟು, ");
INSERT INTO kanirv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ಯೋಸೇಫನು ತಂದೆಗೆ, “ಅಪ್ಪಾ, ಇವನೇ ಚೊಚ್ಚಲ ಮಗನು ಬಲಗೈಯನ್ನು ಇವನ ತಲೆಯ ಮೇಲೆ ಇಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ಆದರೆ ಅವನ ತಂದೆ ಒಪ್ಪದೆ, “ಮಗನೇ ನಾನು ಬಲ್ಲೆ. ನನಗೆ ಗೊತ್ತು. ಇವನಿಂದಲೂ ಜನಾಂಗವುಂಟಾಗುವುದು. ಇವನು ಬಲಿಷ್ಠನಾಗುವನು. ಆದರೂ ಇವನಿಗಿಂತಲೂ ಇವನ ತಮ್ಮನು ಬಲಿಷ್ಠನಾಗುವನು. ತಮ್ಮನ ಸಂತತಿಯಲ್ಲಿಯೇ ಜನರು ಹೇರಳವಾಗಿ ಹುಟ್ಟುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ಆ ದಿನದಲ್ಲಿ ಅವನು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ, “ನಿಮ್ಮ ಹೆಸರಿನಲ್ಲಿ ಇಸ್ರಾಯೇಲರು ಆಶೀರ್ವದಿಸಲ್ಪಡುವರು. ಎಫ್ರಾಯೀಮ್ ಹಾಗೂ ಮನಸ್ಸೆಯ ಹಾಗೆ ದೇವರು ನಿಮ್ಮನ್ನೂ ಆಶೀರ್ವದಿಸಲಿ” ಎಂದು ಹೇಳಿ ಎಫ್ರಾಯೀಮನನ್ನು ಮನಸ್ಸೆಯ ಮುಂದೆ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ಇಸ್ರಾಯೇಲನು ಯೋಸೇಫನಿಗೆ, “ನನಗೆ ಮರಣವು ಸಮೀಪಿಸಿದೆ, ಆದರೆ ದೇವರು ನಿಮ್ಮೊಂದಿಗಿದ್ದು, ನಿಮ್ಮನ್ನು ಪೂರ್ವಿಕರ ದೇಶಕ್ಕೆ ಪುನಃ ಬರಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ಇದಲ್ಲದೆ, ನಾನು ನಿನ್ನ ಅಣ್ಣಂದಿರಿಗೆ ಕೊಟ್ಟ ಪಾಲಿಗಿಂತ ಹೆಚ್ಚಾಗಿ ನಾನು ಕತ್ತಿ ಬಿಲ್ಲುಗಳಿಂದ ಅಮೋರಿಯರ ವಶದಿಂದ ತಪ್ಪಿಸಿ ಪಡೆದ ಬೆಟ್ಟದ ತಪ್ಪಲನ್ನು ನಿನಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ಯಾಕೋಬನು ತನ್ನ ಮಕ್ಕಳನ್ನು ಕರೆಯಿಸಿ ಅವರಿಗೆ, ನೀವೆಲ್ಲರೂ ಕೂಡಿ ಬನ್ನಿರಿ. ಮುಂದಿನ ದಿನಗಳಲ್ಲಿ ನಿಮಗೆ ಸಂಭವಿಸುವುದನ್ನು ನಿಮಗೆ ತಿಳಿಸುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ಯಾಕೋಬನ ಮಕ್ಕಳೇ, ನೀವೆಲ್ಲರೂ ಕೂಡಿ ಬಂದು ಕೇಳಿರಿ. ನಿಮ್ಮ ತಂದೆಯಾದ ಇಸ್ರಾಯೇಲನ ಮಾತನ್ನು ಲಾಲಿಸಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","ರೂಬೇನನೇ, ನೀನು ನನ್ನ ಚೊಚ್ಚಲಮಗನೂ, ನನ್ನ ಚೈತನ್ಯಸ್ವರೂಪನೂ, ನನ್ನ ಪ್ರಥಮಫಲವೂ, ಗೌರವದಲ್ಲಿಯೂ, ಅಧಿಕಾರದಲ್ಲಿಯೂ ಪ್ರಮುಖನೂ ಆಗಿದ್ದೀ. ");
INSERT INTO kanirv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ಆದರೆ ದಡಮೀರಿದ ಪ್ರವಾಹದಂತಿರುವ ನೀನು ಇನ್ನು ಶ್ರೇಷ್ಠನಾಗುವುದಿಲ್ಲ. ಏಕೆಂದರೆ ನೀನು ನಿನ್ನ ತಂದೆಯ ಹಾಸಿಗೆಯನ್ನು ಹತ್ತಿ, ಅದನ್ನು ಹೊಲೆ ಮಾಡಿದಿಯಲ್ಲಾ. ಇವನು ನನ್ನ ಮಂಚವನ್ನು ಹತ್ತಿದನು! ");
INSERT INTO kanirv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","ಸಿಮೆಯೋನನು ಲೇವಿಯೂ ಅಣ್ಣತಮ್ಮಂದಿರು. ಇವರ ಕತ್ತಿಗಳು ಹಿಂಸಾಚಾರದ ಆಯುಧಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ನನ್ನ ಪ್ರಾಣವೇ ಅವರ ಗುಪ್ತವಾದ ದುರಾಲೋಚನೆಗಳಿಗೆ ನೀನು ಒಳಪಡಬಾರದು. ನನ್ನ ಮನವೇ ಅವರ ಗುಂಪಿಗೆ ನೀನು ಸೇರಬೇಡ. ಆದುದರಿಂದ ನನ್ನ ಹೃದಯವು ಸಂತೋಷಿಸುತ್ತದೆ. ಅವರು ಕೋಪೋದ್ರೆಕದಿಂದ ಮನುಷ್ಯರನ್ನು ಸಂಹರಿಸಿದರು. ಮದದಿಂದ ಎತ್ತುಗಳನ್ನು ದುರ್ಬಲಗೊಳಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ಅವರ ಕೋಪವು ಭಯಂಕರವಾಗಿಯೂ ಅವರ ರೌದ್ರವು ಕ್ರೂರವಾಗಿಯೂ ಇದ್ದು ಅದು ಶಾಪಗ್ರಸ್ಥವಾದುದಾಗಿದೆ. ಯಾಕೋಬನ ಕುಲದವರಲ್ಲಿ ಅವರನ್ನು ವಿಭಾಗಿಸುವೆನು. ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಅವರನ್ನು ಚದುರಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","ಯೆಹೂದನೇ, ನಿನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರು ನಿನ್ನನ್ನೇ ಸ್ತುತಿಸುವರು. ನಿನ್ನ ಕೈ ನಿನ್ನ ಶತ್ರುಗಳ ಕುತ್ತಿಗೆಯ ಮೇಲಿರುವುದು. ನಿನ್ನ ಸಹೋದರರು ನಿನಗೆ ಆಡ್ಡ ಬೀಳುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ಯೆಹೂದನು ಪ್ರಾಯದ ಸಿಂಹದಂತಿದ್ದಾನೆ. ನನ್ನ ಪುತ್ರನೇ, ನೀನು ಮೃಗವನ್ನು ಹಿಡಿದು ಕೊಂದು ಬೆಟ್ಟವನ್ನು ಸೇರಿದ ಸಿಂಹದೋಪಾದಿಯಲ್ಲಿದ್ದೀ. ಅವನು ಸಿಂಹದಂತೆ ಕಾಲು ಮುದುರಿ ಹೊಂಚುಹಾಕಿಕೊಂಡಿದ್ದಾನೆ. ಮೃಗ ರಾಜನಿಗೆ ಸಮನಾದ ಇವನನ್ನು ಕೆಣಕುವುದು ಯಾರಿಂದಾದೀತು? ");
INSERT INTO kanirv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ರಾಜದಂಡವನ್ನು ಹಿಡಿಯತಕ್ಕವನು ಶಿಲೋವಿನಿಂದ ಬರುವ ತನಕ ಆ ದಂಡವು ಯೆಹೂದನ ಕೈಯಿಂದ ತಪ್ಪುವುದಿಲ್ಲ. ಮುದ್ರೆ ಕೋಲು ಅವನ ಪಾದಗಳ ಬಳಿಯಿಂದ ಕದಲುವುದಿಲ್ಲ. ಅನ್ಯಜನಾಂಗಗಳೂ ಅವನಿಗೆ ವಿಧೇಯರಾಗಿರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ಅವನು ತನ್ನ ವಾಹನ ಮೃಗವನ್ನು ವಿಶಿಷ್ಟವಾದ ದ್ರಾಕ್ಷಾಲತೆಗೆ ಕಟ್ಟುವನು. ದ್ರಾಕ್ಷಿಯ ಬಳ್ಳಿಗೆ ತನ್ನ ಕತ್ತೆಮರಿಯನ್ನು ಬಿಗಿಯುವನು; ದ್ರಾಕ್ಷಾರಸದಲ್ಲಿ ತನ್ನ ಅಂಗಿಗಳನ್ನು ಒಗೆಯುವನು; ದ್ರಾಕ್ಷಾರಸದಲ್ಲಿಯೇ ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ಅದ್ದಿ ತೊಳೆಯುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ದ್ರಾಕ್ಷಾರಸದ ಸಮೃದ್ಧಿಯಿಂದ ಅವನ ಕಣ್ಣುಗಳು ಕೆಂಪಾಗಿ ಇರುವವು. ಹಾಲಿನ ಸಮೃದ್ಧಿಯಿಂದ ಅವನ ಹಲ್ಲುಗಳು ಬೆಳ್ಳಗಾಗಿ ಇರುವವು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ಜೆಬುಲೂನನು ಸಮುದ್ರದ ಕರಾವಳಿಯಲ್ಲಿ ವಾಸಮಾಡುವನು. ಅವನಿಗೆ ಹಡಗುಗಳು ಸೇರುವ ಬಂದರು ಇರುವುದು. ಅವನ ಸೀಮೆಯ ಒಂದು ಮೇರೆ ಚೀದೋನಿಗೆ ಮುಟ್ಟುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ಇಸ್ಸಾಕಾರನು ಕುರಿಯ ಹಟ್ಟಿಗಳ ನಡುವೆ ಮಲಗಿಕೊಂಡಿರುವ ಬಲವುಳ್ಳ ಕತ್ತೆಯಂತಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ತಾನು ಸೇರಿದ ಪ್ರದೇಶವು ವಿಶ್ರಾಂತಿಗೆ ಅನುಕೂಲವೂ ಸುಖಾಸ್ಪದವೂ ಆಗಿರುವುದನ್ನು ಕಂಡನು. ಅವನು ಹೊರೆಯನ್ನು ಹೊರುವುದಕ್ಕೆ ಬೆನ್ನು ಬಗ್ಗಿಸಿಕೊಂಡು ಬಿಟ್ಟೀ ಸೇವೆಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ದಾನನು ಇಸ್ರಾಯೇಲರ ಕುಲಗಳಲ್ಲಿ ಒಂದರಂತೆ ತನ್ನ ಜನರಿಗೆ ನ್ಯಾಯತೀರಿಸುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ದಾನನು ಮಾರ್ಗದ ಮಧ್ಯದಲ್ಲಿರುವ ವಿಷಸರ್ಪದಂತೆ ಇರುವನು ಅದು ಕುದುರೆಯ ಹಿಮ್ಮಡಿಯನ್ನು ಕಚ್ಚುವುದು. ಸವಾರನು ಕೆಳಗೆ ಅಂಗಾತವಾಗಿ ಬೀಳುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ಯೆಹೋವನೇ, ನಾನು ನಿನ್ನ ರಕ್ಷಣೆಯ ಮಾರ್ಗವನ್ನು ನಿರೀಕ್ಷಿಸಿಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ಗಾದನ ಮೇಲೆ ಸುಲಿಗೆ ಮಾಡುವವರು ಬೀಳಲು, ಇವನು ಅವರನ್ನು ಹಿಮ್ಮಟ್ಟಿಕೊಂಡು ಹೋಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ಆಶೇರನಿಗೆ ಧಾನ್ಯ ಸಮೃದ್ಧಿಯಾಗುವುದು. ಅವನಲ್ಲಿ ರಾಜಭೋಗ ಪದಾರ್ಥಗಳು ದೊರಕುವವು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","ನಫ್ತಾಲಿಯು ಸ್ವತಂತ್ರವಾಗಿ ಜಿಂಕೆಯಂತಿದ್ದಾನೆ. ಅವನಿಂದ ಇಂಪಾದ ಮಾತುಗಳುಂಟಾಗುವವು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","ಯೋಸೇಫನು ಫಲಭರಿತವಾದ ವೃಕ್ಷವು, ಒರತೆಯ ಬಳಿಯಲ್ಲಿರುವ ಫಲವತ್ತಾದ ವೃಕ್ಷವೇ ಆಗಿದ್ದಾನೆ. ಗೋಡೆಯ ಆಚೆಗೆ ಅದರ ರೆಂಬೆಗಳು ಹರಡಿವೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ಬಿಲ್ಲುಗಾರರು ಅವನನ್ನು ಆಕ್ರಮಿಸುವರು, ಹಗೆತನದಿಂದ ಬಾಣವನ್ನು ಅವನ ಮೇಲೆ ಪ್ರಯೋಗಿಸುವರು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ಆದರೂ ಯಾಕೋಬನ ವಂಶಸ್ಥರನ್ನು ರಕ್ಷಿಸುವ ಪರಾಕ್ರಮಿಯ ಭುಜಬಲದಿಂದಲೂ, ಇಸ್ರಾಯೇಲನಿಗೆ ಪಾಲಕನೂ ಬಂಡೆಯೂ ಆಗಿರುವಾತನಿಂದಲೂ ಅವನ ಕೈಗಳ ಬಿಲ್ಲು ಸ್ಥಿರವಾಗಿ ನಿಂತಿರುವುದು. ಅವನ ಕೈಗಳು ಯಾಕೋಬನ ಒಡೆಯನಿಂದ ಬಲಗೊಂಡಿವೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ನಿನ್ನ ತಂದೆಯ ದೇವರು ನಿನಗೆ ಸಹಾಯ ಹಸ್ತವಾಗಿದ್ದಾನೆ. ನಿನ್ನ ತಂದೆಯ ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವನು. ಸರ್ವಶಕ್ತನಾದ ದೇವರು, ಆತನು ಮೇಲಣ ಆಕಾಶದಿಂದಲೂ, ಕೆಳಗಣ ಸಾಗರದ ಸೆಲೆಗಳಿಂದಲೂ, ಸ್ತನದಿಂದಲೂ, ಗರ್ಭಫಲದಿಂದಲೂ ಉಂಟಾಗುವ ಸೌಭಾಗ್ಯಗಳನ್ನು ಕೊಟ್ಟು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ನಿನ್ನ ತಂದೆಯ ಆಶೀರ್ವಾದಗಳು ನಿನ್ನ ಪೂರ್ವಿಕರ ಆಶೀರ್ವಾದಕ್ಕಿಂತಲೂ ಮೀಗಿಲಾಗಿರುತ್ತದೆ. ಆದಿಯಿಂದಲೂ ಪರ್ವತಗಳಿಂದ ಉಂಟಾಗುವ ಎಲ್ಲಾ ಮೇಲುಗಳಿಗಿಂತಲೂ, ಸದಾಕಾಲ ಪ್ರಕೃತಿಯಿಂದ ಉಂಟಾಗುವ ಎಲ್ಲಾ ಸುಫಲಗಳು ಕೊನೆಯವರೆಗೂ ಯೋಸೇಫನಿಗೂ ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೂ ಸಮೃದ್ಧಿಯಾಗಿ ದೊರೆಯುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“ಬೆನ್ಯಾಮೀನನು ಕುರಿಗಳನ್ನು ಹಿಡಿದುಕೊಳ್ಳುವ ತೋಳದಂತಿದ್ದಾನೆ. ರಾತ್ರಿ ಹಿಡಿದುಕೊಂಡದ್ದನ್ನು ಬೆಳಿಗ್ಗೆ ತಿನ್ನುತ್ತಾನೆ. ಕೊಳ್ಳೆಮಾಡಿದ್ದನ್ನು ಸಂಜೆಯಲ್ಲಿ ಹಂಚಿಕೊಳ್ಳುವನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ಇವರೆಲ್ಲರೂ ಇಸ್ರಾಯೇಲನಿಂದುಂಟಾದ ಹನ್ನೆರಡು ಕುಲಗಳು. ಅವರ ತಂದೆ ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ ಹೇಳಿದ ನುಡಿಗಳು ಇವುಗಳೇ. ಅವನು ಪ್ರತಿಯೊಬ್ಬನಿಗೂ ಅವನವನಿಗೆ ತಕ್ಕ ಆಶೀರ್ವಾದದ ಪ್ರಕಾರ ಆಶೀರ್ವಚನಗಳನ್ನು ನುಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ಇಸ್ರಾಯೇಲನು ತನ್ನ ಮಕ್ಕಳಿಗೆ ಆಜ್ಞಾಪಿಸಿ ಹೇಳಿದ್ದೇನಂದರೆ, “ನಾನು ನನ್ನ ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರಬೇಕಾದ ಕಾಲವು ಸಮೀಪಿಸಿತು. ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನನ ಭೂಮಿಯಲ್ಲಿರುವ ಗವಿಯೊಳಗೆ ನನ್ನನ್ನು ನನ್ನ ಪೂರ್ವಿಕರ ಬಳಿಯಲ್ಲಿ ಸಮಾಧಿಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ಆ ಗವಿಯು ಕಾನಾನ್ ದೇಶದ ಮಮ್ರೆಗೆದುರಾಗಿರುವ ಮಕ್ಪೇಲ ಎಂಬ ಬಯಲಿನಲ್ಲಿ ಇದೆ. ಅದನ್ನು ಅಬ್ರಹಾಮನು ಅದರ ಸುತ್ತಲಿರುವ ಭೂಮಿ ಸಹಿತವಾಗಿ ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನನಿಂದ ಸ್ವಂತ ಸ್ಮಶಾನ ಭೂಮಿಗಾಗಿ ಕೊಂಡುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ಅಲ್ಲಿ ಅಬ್ರಹಾಮನಿಗೂ ಅವನ ಪತ್ನಿಯಾದ ಸಾರಳಿಗೂ ಸಮಾಧಿಯಾಯಿತು. ಅಲ್ಲೇ ಇಸಾಕನಿಗೂ ಅವನ ಹೆಂಡತಿಯಾದ ರೆಬೆಕ್ಕಳಿಗೂ ಸಮಾಧಿಯಾಯಿತು. ಅಲ್ಲಿ ನಾನು ಲೇಯಳನ್ನು ಸಮಾಧಿಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ಹೊಲದೊಂದಿಗೆ ಹಿತ್ತಿಯರಿಂದ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡ ಆ ಗುಹೆಯೊಳಗೆ ನನಗೂ ಸಮಾಧಿಮಾಡಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ಯಾಕೋಬನು ತನ್ನ ಮಕ್ಕಳಿಗೆ ಅಪ್ಪಣೆ ಕೊಡುವುದನ್ನು ಮುಗಿಸಿದ ನಂತರ ಹಾಸಿಗೆಯ ಮೇಲೆ ತನ್ನ ಕಾಲುಗಳನ್ನು ಮಡಚಿಕೊಂಡು ಪ್ರಾಣಬಿಟ್ಟು ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ಆಗ ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯ ಮುಖದ ಮೇಲೆ ಬಿದ್ದು ಕಣ್ಣೀರು ಸುರಿಸುತ್ತಾ ಅವನಿಗೆ ಮುದ್ದಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ತರುವಾಯ ಯೋಸೇಫನು ತನ್ನ ಸೇವಕರಾದ ವೈದ್ಯರಿಗೆ, “ನನ್ನ ತಂದೆಯ ಶವವನ್ನು ಸುಗಂಧ ದ್ರವ್ಯಗಳಿಂದ ತುಂಬಿ ಸಿದ್ಧಪಡಿಸಿರಿ” ಎಂದು ಅಪ್ಪಣೆ ಕೊಡಲು ಅವರು ಇಸ್ರಾಯೇಲನ ಶವವನ್ನು ಸುಗಂಧ ದ್ರವ್ಯಗಳಿಂದ ತುಂಬಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ನಲ್ವತ್ತು ದಿನಗಳು ಸುಗಂಧದ್ರವ್ಯಗಳನ್ನು ತುಂಬುವ ಪದ್ಧತಿಯಿರುವುದರಿಂದ ಅಷ್ಟು ದಿನ ಸಿದ್ಧಪಡಿಸುತ್ತಾ ಇದ್ದರು. ಐಗುಪ್ತರು ಅವನಿಗೋಸ್ಕರ ಎಪ್ಪತ್ತು ದಿನ ಶೋಕಾಚರಣೆಯಲ್ಲಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ಶೋಕಾಚರಣೆಯು ಮುಗಿದ ನಂತರ ಯೋಸೇಫನು ಫರೋಹನ ಪರಿವಾರದವರಿಗೆ, “ದಯವಿಟ್ಟು ನೀವು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಈ ವಿಷಯವನ್ನು ಮನಮುಟ್ಟುವಂತೆ ಮಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘ನನ್ನ ತಂದೆಯು, ತಾನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಸಿದ್ಧ ಮಾಡಿಕೊಂಡಿರುವ ಸ್ಥಳದಲ್ಲಿಯೇ ತನಗೆ ಸಮಾಧಿ ಮಾಡಬೇಕೆಂದು ಸಾಯುವುದಕ್ಕಿಂತ ಮೊದಲು ನನ್ನಿಂದ ಪ್ರಮಾಣ ಮಾಡಿಸಿದನು. ಆದ್ದರಿಂದ ನನ್ನ ಮೇಲೆ ಕಟಾಕ್ಷವಿದ್ದರೆ ನೀವು ಈ ಸಂಗತಿಯನ್ನು ಫರೋಹನಿಗೆ ತಿಳಿಸಿ ನಾನು ಹೋಗಿ ತಂದೆಗೆ ಸಮಾಧಿ ಮಾಡಿ ಬರುವುದಕ್ಕೆ ಅಪ್ಪಣೆ ಕೊಡಿಸಬೇಕೆಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ’” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ಫರೋಹನು ಈ ಸಂಗತಿಯನ್ನು ಕೇಳಿ ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ತಂದೆ ಪ್ರಮಾಣ ಮಾಡಿಸಿದ ಮೇರೆಗೆ ನೀನು ಹೋಗಿ ಅವನಿಗೆ ಸಮಾಧಿ ಮಾಡಿಬರಬಹುದು” ಎಂದು ಅಪ್ಪಣೆಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ಯೋಸೇಫನು ತಂದೆಗೆ ಸಮಾಧಿ ಮಾಡುವುದಕ್ಕೆ ಹೊರಟಾಗ ಅವನ ಜೊತೆಯಲ್ಲಿ ಫರೋಹನ ಸೇವಕರೆಲ್ಲರೂ, ಅರಮನೆಯ ಮುಖಂಡರೆಲ್ಲರೂ, ಐಗುಪ್ತ ದೇಶದ ಮುಖ್ಯಸ್ಥರೆಲ್ಲರೂ ");
INSERT INTO kanirv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ಯೋಸೇಫನ ಮನೆಯವರೆಲ್ಲರೂ, ಅಣ್ಣತಮ್ಮಂದಿರೂ, ತಂದೆಯ ಮನೆಯವರೆಲ್ಲರೂ ಹೋದರು. ಅವರು ತಮ್ಮ ಹೆಂಡತಿ ಮಕ್ಕಳನ್ನು ಕುರಿದನಗಳನ್ನು ಮಾತ್ರ ಗೋಷೆನ್ ಸೀಮೆಯಲ್ಲಿ ಬಿಟ್ಟು ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ಇದಲ್ಲದೆ ಅವನ ಸಂಗಡ ರಥಗಳೂ, ಕುದುರೆಗಳೂ ಸಹ ಹೋದವು. ಯೋಸೇಫನ ಹಿಂದೆ ಹೊರಟು ಹೋದವರು ಬಹು ಮಂದಿಯಾಗಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ಅವರು ಯೊರ್ದನ್ ಹೊಳೆಯಿಂದಾಚೆ ಇರುವ ಆಟಾದ್ ಎಂಬ ಕಣಕ್ಕೆ ಬಂದು ಅಲ್ಲಿ ಅತ್ಯಧಿಕವಾಗಿ ಗೋಳಾಡಿದರು. ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೋಸ್ಕರ ಏಳು ದಿನಗಳ ತನಕ ಶೋಕಾಚರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ಆ ದೇಶದ ಜನರಾಗಿದ್ದ ಕಾನಾನ್ಯರು ಯೊರ್ದನ್ ಹೊಳೆಯಿಂದಾಚೆ ಇರುವ ಆಟಾದ್ ಎಂಬ ಕಣದಲ್ಲಿ ನಡೆದ ಗೋಳಾಟವನ್ನು ನೋಡಿ ಐಗುಪ್ತರಿಗೆ ಬಂದಿರುವ ಈ ಶೋಕವು ಬಹು ವಿಶೇಷವಾಗಿದೆ ಎಂದು ಹೇಳಿದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ “ಆಬೇಲ್ ಮಿಚ್ರಯಿಮ್” ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ಯಾಕೋಬನ ಮಕ್ಕಳು ತಂದೆಯ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ಅವನ ಶವವನ್ನು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಹೊತ್ತುಕೊಂಡು ಹೋಗಿ ಮಕ್ಪೇಲ ಎಂಬ ಬಯಲಿನಲ್ಲಿರುವ ಗುಹೆಯೊಳಗೆ ಸಮಾಧಿಮಾಡಿದರು. ಅಬ್ರಹಾಮನು ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನನಿಂದ ಮಮ್ರೆಗೆದುರಿನಲ್ಲಿರುವ ಆ ಗವಿಯನ್ನು ಸುತ್ತಲಿರುವ ಭೂಮಿ ಸಹಿತ ಸ್ವಂತ ಸ್ಮಶಾನ ಭೂಮಿಯನ್ನಾಗಿ ಕೊಂಡುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ತಂದೆಗೆ ಸಮಾಧಿ ಮಾಡಿದ ಮೇಲೆ ಯೋಸೇಫನೂ ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರೂ ತಂದೆಯ ಉತ್ತರ ಕ್ರಿಯೆಗೋಸ್ಕರ ಜೊತೆಯಲ್ಲಿ ಹೋಗಿದ್ದವರೆಲ್ಲರೂ ಐಗುಪ್ತಕ್ಕೆ ಹಿಂದಿರುಗಿ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ಯೋಸೇಫನ ಅಣ್ಣತಮ್ಮಂದಿರು ತಂದೆ ಸತ್ತದ್ದನ್ನು ಕಂಡು, “ಒಂದು ವೇಳೆ ಯೋಸೇಫನು ನಮ್ಮನ್ನು ದ್ವೇಷಿಸಿ ನಾವು ಅವನಿಗೆ ಮಾಡಿದ ಎಲ್ಲಾ ಕೇಡಿಗೆ ಪ್ರತಿಯಾಗಿ ನಮಗೆ ಶಿಕ್ಷೆಯನ್ನು ಕೊಡಬಹುದು” ಎಂದು ತಮ್ಮತಮ್ಮೊಳಗೆ ಮಾತನಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ಅವರು ಯೋಸೇಫನಿಗೆ, ನಿನ್ನ ತಂದೆಯು ಸಾಯುವುದಕ್ಕಿಂತ ಮೊದಲು ನಮಗೆ ಅಪ್ಪಣೆ ಮಾಡಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“ನಿನ್ನ ಅಣ್ಣಂದಿರಾದ ನಾವು ನಿನಗೆ ಕೇಡು ಮಾಡಿದ್ದು ನಿಜವೇ. ಆದರೂ ನಮ್ಮ ತಂದೆಯ ದೇವರನ್ನು ಆರಾಧಿಸುವವರು, ಸೇವಕರೂ ಆದ ನಮ್ಮ ಅಪರಾಧವನ್ನು ಕ್ಷಮಿಸಬೇಕೆಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತೇವೆ” ಎಂದು ಯೋಸೇಫನ ಬಳಿ ಬೇಡಿಕೊಳ್ಳಿರಿ ಎಂದು ಹೇಳಿದರು. ಯೋಸೇಫನು ಈ ಮಾತುಗಳನ್ನು ಕೇಳಿ ಕಣ್ಣೀರು ಸುರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ಇದಲ್ಲದೆ ಅಣ್ಣಂದಿರು ತಾವೇ ಬಂದು ಅವನ ಮುಂದೆ ಅಡ್ಡಬಿದ್ದು, “ಇಗೋ ನಾವು ನಿನಗೆ ಗುಲಾಮರು” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ಯೋಸೇಫನು ಅವರಿಗೆ, “ಹೆದರಬೇಡಿರಿ, ನಾನೇನು ದೇವರ ಸ್ಥಾನದಲ್ಲಿ ಇದ್ದೇನೋ? ");
INSERT INTO kanirv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ನೀವಂತೂ ನನಗೆ ಕೇಡಾಗಬೇಕೆಂದು ಎಣಿಸಿದಿರಿ. ಆದರೆ ದೇವರು ನನ್ನನ್ನು ಮೇಲಾಗಬೇಕೆಂದು ಸಂಕಲ್ಪಿಸಿದನು; ಆದುದರಿಂದ ಇಂದು ನೀವು ಕಾಣುವಂತೆ, ಅನೇಕ ಜನರ ಪ್ರಾಣವು ಸಂರಕ್ಷಿಸಲ್ಪಟ್ಟಿತ್ತು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ಆದುದರಿಂದ ನೀವು ಸ್ವಲ್ಪವೂ ಭಯಪಡಬೇಡಿರಿ. ನಾನು ನಿಮ್ಮನ್ನೂ, ನಿಮಗೆ ಸೇರಿದವರೆಲ್ಲರನ್ನೂ ಪೋಷಿಸುವೆನು. ಎಂದು ಹೇಳಿ ಅವರನ್ನು ಸಂತೈಸಿ ಅವರ ಸಂಗಡ ಪ್ರೀತಿಯಿಂದ ಮಾತನಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ಹೀಗೆ ಯೋಸೇಫನು, ಅವನ ತಂದೆಯ ಮನೆಯವರೂ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡಿದರು. ಯೋಸೇಫನು ನೂರಹತ್ತು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ಅವನು ಎಫ್ರಾಯೀಮನ ಮಕ್ಕಳ ಮೊಮ್ಮಕ್ಕಳನ್ನು ಅಂದರೆ ಮೂರನೇ ತಲೆಮಾರಿನವರೆಗೂ ನೋಡಿದನು. ಮತ್ತು ಮನಸ್ಸೆಯ ಮಗನಾದ ಮಾಕೀರನಿಗೂ ಮಕ್ಕಳು ಹುಟ್ಟಿದಾಗ ಅವರೂ ಯೋಸೇಫನ ಮಡಿಲಿನಲ್ಲಿಯೇ ಬೆಳೆದರು. ಅವರನ್ನು ತನ್ನ ತೊಡೆಯ ಮೇಲೆ ಮಲಗಿಸಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ಯೋಸೇಫನು ತನ್ನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ, “ನನಗೆ ಅವಸಾನಕಾಲ ಸಮೀಪಿಸಿತು. ಆದರೆ ದೇವರು ನಿಶ್ಚಯವಾಗಿ ನಿಮ್ಮನ್ನು ಪರಾಂಬರಿಸಿ ತಾನು ಅಬ್ರಹಾಮ, ಇಸಾಕ್, ಯಾಕೋಬರಿಗೆ ಕೊಡುತ್ತೇನೆಂದು ಪ್ರಮಾಣಮಾಡಿ ಹೇಳಿದ ದೇಶಕ್ಕೆ ನೀವು ಹೋಗಿ ಸೇರುವಂತೆ ಮಾಡುವನು” ಎಂದು ತಿಳಿದುಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ಇದಲ್ಲದೆ ಯೋಸೇಫನು ಇಸ್ರಾಯೇಲನ ಮಕ್ಕಳಿಗೆ, “ದೇವರು ನಿಸ್ಸಂದೇಹವಾಗಿ ನಿಮ್ಮನ್ನು ಪರಾಂಬರಿಸುವನು. ಆಗ ನೀವು ನನ್ನ ಶವವನ್ನು ನಿಮ್ಮ ಸಂಗಡ ಹೊತ್ತುಕೊಂಡು ಹೋಗಬೇಕು” ಎಂದು ಅವರಿಂದ ಪ್ರಮಾಣಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ಯೋಸೇಫನು ನೂರಹತ್ತು ವರ್ಷದವನಾಗಿ ಪ್ರಾಣ ಬಿಟ್ಟನು. ಅವನ ಶವಕ್ಕೆ ಸುಗಂಧದ್ರವ್ಯಗಳನ್ನು ತುಂಬಿ ಐಗುಪ್ತ ದೇಶದೊಳಗೆ ಅದನ್ನು ಪೆಟ್ಟಿಗೆಯಲ್ಲಿ ಇರಿಸಿದರು.");
INSERT INTO kanirv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ಯಾಕೋಬನೊಂದಿಗೆ ಐಗುಪ್ತದೇಶಕ್ಕೆ ತಮ್ಮತಮ್ಮ ಮನೆಯವರ ಸಂಗಡ ಬಂದ ಇಸ್ರಾಯೇಲರ ಮಕ್ಕಳ ಹೆಸರುಗಳು: ");
INSERT INTO kanirv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ರೂಬೇನ್, ಸಿಮೆಯೋನ್, ಲೇವಿ, ಯೆಹೂದ, ");
INSERT INTO kanirv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ಇಸ್ಸಾಕಾರ್, ಜೆಬುಲೂನ್ ಮತ್ತು ಬೆನ್ಯಾಮೀನ್, ");
INSERT INTO kanirv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ದಾನ್, ಗಾದ್, ನಫ್ತಾಲಿ ಮತ್ತು ಆಶೇರ್. ");
INSERT INTO kanirv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ಯಾಕೋಬನ ಎಲ್ಲಾ ಸಂತತಿಯವರು ಒಟ್ಟು ಎಪ್ಪತ್ತು ಮಂದಿ. ಆದರೆ ಯೋಸೇಫನು ಮೊದಲೇ ಐಗುಪ್ತದೇಶದಲ್ಲಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ಆ ನಂತರ ಯೋಸೇಫನೂ, ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರೂ, ಆ ಸಂತತಿಯವರೆಲ್ಲರೂ ಮರಣ ಹೊಂದಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ಆದರೆ ಇಸ್ರಾಯೇಲರ ಮಕ್ಕಳು ಅತ್ಯಧಿಕವಾಗಿ ಅಭಿವೃದ್ಧಿಯಾಗಿ, ಹೆಚ್ಚಿನ ಸಂಖ್ಯೆಯಲ್ಲಿ ಬೆಳೆದು ಬಲ ಹೊಂದಿದರು. ಆ ದೇಶವು ಅವರಿಂದ ತುಂಬಿಹೋಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ತರುವಾಯ ಯೋಸೇಫನನ್ನು ಅರಿಯದ ಹೊಸ ಅರಸನು ಐಗುಪ್ತದೇಶದ ಆಳ್ವಿಕೆಗೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ಅರಸನು ತನ್ನ ಜನರಿಗೆ, “ಇಸ್ರಾಯೇಲರು ಹೆಚ್ಚಿನ ಸಂಖ್ಯೆಯಲ್ಲಿದ್ದಾರೆ ಮತ್ತು ನಮಗಿಂತ ಬಹಳ ಬಲಶಾಲಿಗಳೂ ಆಗಿದ್ದಾರೆ ನೋಡಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ನಮಗೆ ಯುದ್ಧವೇನಾದರೂ ಸಂಭವಿಸಿದರೆ ಅವರು ನಮ್ಮ ಶತ್ರುಗಳೊಂದಿಗೆ ಸೇರಿಕೊಂಡು, ನಮಗೆ ವಿರುದ್ಧವಾಗಿ ಹೋರಾಡಿ ದೇಶವನ್ನು ಬಿಟ್ಟುಹೋದಾರು. ಆದ್ದರಿಂದ ಅವರು ನಮ್ಮ ದೇಶವನ್ನು ಬಿಟ್ಟು ಹೋಗದಂತೆ ನಾವು ಉಪಾಯ ಮಾಡೋಣ” ಎಂದು ಹೇಳಿ ");
INSERT INTO kanirv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ಅವರನ್ನು ಬಿಟ್ಟೀ ಕೆಲಸಗಳಿಂದ ಪೀಡಿಸುವುದಕ್ಕಾಗಿ, ಬಿಟ್ಟೀಕೆಲಸ ಮಾಡಿಸುವ ಅಧಿಕಾರಿಗಳನ್ನು ಅವರ ಮೇಲೆ ಇರಿಸಿದನು. ಅವರು ಫರೋಹನನಿಗೆ ಪಿತೋಮ್ ಮತ್ತು ರಾಮ್ಸೇಸ್ ಎಂಬ ಉಗ್ರಾಣ ಪಟ್ಟಣಗಳನ್ನು ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ಐಗುಪ್ತರು ಇಸ್ರಾಯೇಲರನ್ನು ಉಪದ್ರವಪಡಿಸಿದಷ್ಟೂ, ಅವರು ಬಹಳವಾಗಿ ಹೆಚ್ಚಿ ಹರಡಿಕೊಂಡಿದ್ದರಿಂದ ಐಗುಪ್ತರು ಇಸ್ರಾಯೇಲರ ವಿಷಯದಲ್ಲಿ ಬಹಳ ಹೆದರಿಕೆಯುಳ್ಳವರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ಐಗುಪ್ತರು ಇಸ್ರಾಯೇಲರಿಂದ ಕ್ರೂರವಾಗಿ ಸೇವೆಮಾಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ಮಣ್ಣಿನ ಕೆಲಸದಲ್ಲಿಯೂ, ಇಟ್ಟಿಗೆಮಾಡುವ ಕೆಲಸದಲ್ಲಿಯೂ, ವ್ಯವಸಾಯದ ಎಲ್ಲಾ ವಿಧವಾದ ಕೆಲಸದಲ್ಲಿಯೂ ಕಠಿಣವಾಗಿ ದುಡಿಸಿಕೊಂಡು ಅವರ ಜೀವಿತವನ್ನೇ ಬೇಸರಪಡಿಸಿದರು. ಐಗುಪ್ತರು ಇಸ್ರಾಯೇಲರಿಂದ ಮಾಡಿಸಿದ ಎಲ್ಲಾ ಕೆಲಸಗಳು ಬಹಳ ಕಠಿಣವಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ಇದಲ್ಲದೆ ಐಗುಪ್ತ ದೇಶದ ಅರಸನು “ಶಿಪ್ರಾ” ಮತ್ತು “ಪೂಗಾ” ಎಂಬ ಹೆಸರಿನ ಇಬ್ರಿಯ ಸೂಲಗಿತ್ತಿಯರೊಂದಿಗೆ ಮಾತನಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ಅವನು ಅವರಿಗೆ, “ನೀವು ಇಬ್ರಿಯ ಹೆಂಗಸರಿಗೆ ಹೆರಿಗೆ ಮಾಡಿಸುವಾಗ ಅವರು ಹೆರುವ ಮಗುವು ಗಂಡು ಮಗುವಾಗಿದ್ದರೆ ಕೊಂದುಹಾಕಿರಿ, ಹೆಣ್ಣಾಗಿದ್ದರೆ ಬದುಕಲು ಬಿಡಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ಆದರೆ ಸೂಲಗಿತ್ತಿಯರು ದೇವರಿಗೆ ಭಯಪಟ್ಟು ಐಗುಪ್ತರ ಅರಸನ ಮಾತಿನಂತೆ ಮಾಡದೆ ಗಂಡು ಮಕ್ಕಳನ್ನು ಜೀವದಿಂದ ಉಳಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ಆಗ ಐಗುಪ್ತದ ಅರಸನು ಸೂಲಗಿತ್ತಿಯರನ್ನು ಕರೆಯಿಸಿ, “ನೀವು ಅವರ ಗಂಡು ಮಕ್ಕಳನ್ನು ಉಳಿಸಿದ್ದೇನು? ಹೀಗೆ ಯಾಕೆ ಮಾಡಿದಿರಿ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ಸೂಲಗಿತ್ತಿಯರು ಫರೋಹನಿಗೆ, “ಇಬ್ರಿಯರ ಸ್ತ್ರೀಯರು ಐಗುಪ್ತ ಸ್ತ್ರೀಯರಂತೆ ಅಲ್ಲ, ಅವರು ಬಹು ಚುರುಕು ಬುದ್ಧಿಯವರು. ಸೂಲಗಿತ್ತಿಯು ಅವರ ಹತ್ತಿರ ಬರುವುದಕ್ಕೆ ಮೊದಲೇ ಮಗುವನ್ನು ಹೆರುತ್ತಿದ್ದರು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ಆದ್ದರಿಂದ ದೇವರು ಆ ಸೂಲಗಿತ್ತಿಯರಿಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡಿದನು. ಇದರಿಂದ ಇಸ್ರಾಯೇಲ್ ಜನರು ಹೆಚ್ಚಾಗಿ ಬಹಳ ಬಲಗೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ಸೂಲಗಿತ್ತಿಯರು ದೇವರಿಗೆ ಭಯಪಟ್ಟಿದ್ದರಿಂದ, ಆತನು ಅವರಿಗೆ ವಂಶಾಭಿವೃದ್ಧಿಯನ್ನು ಅನುಗ್ರಹಿಸಿದನು. ಇಸ್ರಾಯೇಲರು ಹೆಚ್ಚಿ ಬಲಗೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ತರುವಾಯ ಫರೋಹನು ತನ್ನ ಜನರಿಗೆ, “ಇಬ್ರಿಯರ ಗಂಡು ಕೂಸುಗಳನ್ನೆಲ್ಲಾ ನೈಲ್ ನದಿಯಲ್ಲಿ ಹಾಕಬೇಕು, ಹೆಣ್ಣುಕೂಸುಗಳನ್ನೆಲ್ಲಾ ಉಳಿಸಬೇಕು” ಎಂದು ಆಜ್ಞೆ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ಆ ನಂತರ ಲೇವಿಯ ವಂಶದವನಾದ ಒಬ್ಬನು ಲೇವಿ ಕುಲದ ಕನ್ಯೆಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ಆಕೆಯು ಗರ್ಭಿಣಿಯಾಗಿ ಗಂಡು ಮಗುವನ್ನು ಹೆತ್ತಳು. ಅದು ಸುಂದರವಾದ ಕೂಸೆಂದು ತಿಳಿದು ಮೂರು ತಿಂಗಳು ಅದನ್ನು ಬಚ್ಚಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ಆಕೆ ಅದನ್ನು ಇನ್ನು ಹೆಚ್ಚುಕಾಲ ಮರೆಮಾಡಲಾಗದೆ, ಆಪಿನ ಪೆಟ್ಟಿಗೆಯನ್ನು ತೆಗೆದುಕೊಂಡು ಜೇಡಿಮಣ್ಣನ್ನೂ ರಾಳವನ್ನು ಹಚ್ಚಿ, ಕೂಸನ್ನು ಅದರಲ್ಲಿ ಮಲಗಿಸಿ, ನೈಲ್ ನದಿಯ ಅಂಚಿನಲ್ಲಿರುವ ಜಂಬುಹುಲ್ಲಿನಲ್ಲಿ ಇಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ಕೂಸಿಗೆ ಏನಾಗುವುದೆಂದು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕೆ, ಆ ಕೂಸಿನ ಅಕ್ಕ ಸ್ವಲ್ಪ ದೂರದಲ್ಲಿ ನಿಂತುಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ಅಷ್ಟರಲ್ಲಿ ಫರೋಹನ ಮಗಳು ಸ್ನಾನಕ್ಕಾಗಿ ನೈಲ್ ನದಿಯ ಬಳಿಗೆ ಬಂದಳು. ಆಕೆಯ ಸೇವಕಿಯರು ನದಿಯ ದಡದಲ್ಲಿ ತಿರುಗಾಡುತ್ತಿದ್ದರು. ಆಕೆ ಜಂಬುಹುಲ್ಲಿನ ಪೆಟ್ಟಿಗೆಯನ್ನು ಕಂಡು, ದಾಸಿಯೊಬ್ಬಳನ್ನು ಕಳುಹಿಸಿ ಅದನ್ನು ತರಿಸಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ಪೆಟ್ಟಿಗೆಯನ್ನು ತೆರೆದು ನೋಡುವಾಗ, ಆಹಾ! ಅಳುವ ಕೂಸು. ಆಕೆಗೆ ಅದರ ಮೇಲೆ ಕನಿಕರಹುಟ್ಟಿ, “ಇದು ಇಬ್ರಿಯರ ಮಕ್ಕಳಲ್ಲಿ ಒಂದಾಗಿರಬಹುದು” ಎಂದುಕೊಂಡಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ಆಗಲೇ ಮಗುವಿನ ಅಕ್ಕ ಬಂದು, “ಫರೋಹನ ಮಗಳಿಗೆ ನಿನಗೋಸ್ಕರ ಈ ಕೂಸನ್ನು ಮೊಲೆಕೊಟ್ಟು ಸಾಕುವುದಕ್ಕೆ ಇಬ್ರಿಯ ಸ್ತ್ರೀಯರಲ್ಲಿ ಒಬ್ಬ ದಾದಿಯನ್ನು ನಾನು ಕರೆದುಕೊಂಡು ಬರಬಹುದೋ?” ಎಂದು ಕೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ಫರೋಹನ ಮಗಳು ಆಕೆಗೆ, “ಹೋಗು ಕರೆದುಕೊಂಡು ಬಾ” ಎಂದಳು. ಆ ಹುಡುಗಿ ಹೋಗಿ ಕೂಸಿನ ತಾಯಿಯನ್ನೇ ಕರೆದುತಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ಫರೋಹನ ಮಗಳು ಮಗುವಿನ ತಾಯಿಗೆ, “ನೀನು ಈ ಮಗುವನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ನನಗೋಸ್ಕರ ಹಾಲುಕೊಟ್ಟು ಸಾಕಬೇಕು. ನಾನು ನಿನಗೆ ಸಂಬಳವನ್ನು ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದಳು. ಆ ಸ್ತ್ರೀಯು ಕೂಸನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಸಾಕಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ಆ ಹುಡುಗನು ಬೆಳೆದಾಗ, ಅವನನ್ನು ಫರೋಹನ ಮಗಳ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಬಂದಳು, ಅವನು ಆಕೆಗೆ ಮಗನಾದನು. “ಇವನನ್ನು ನೀರಿನೊಳಗಿನಿಂದ ಎಳೆದುಕೊಂಡಿದ್ದೇನೆ,” ಎಂದು ಹೇಳಿ ಆಕೆಯು ಅವನಿಗೆ “ಮೋಶೆ” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ಮೋಶೆಯು ದೊಡ್ಡವನಾದ ಮೇಲೆ, ಸ್ವಜನರ ಬಳಿಗೆ ಹೋಗಿ ಅವರ ಬಿಟ್ಟೀಕೆಲಸಗಳನ್ನು ನೋಡುತ್ತಿದ್ದನು. ಆಗ ಒಬ್ಬ ಐಗುಪ್ತ್ಯದವನು ತನ್ನ ಸ್ವಂತ ಜನರಾದ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನಾದ ಇಬ್ರಿಯನನ್ನು ಹೊಡೆಯುವುದನ್ನು ಕಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ಮೋಶೆ ಅತ್ತಿತ್ತ ನೋಡಿ, ಯಾರೂ ಇಲ್ಲವೆಂದು ತಿಳಿದು, ಆ ಐಗುಪ್ತ್ಯದವನನ್ನು ಹೊಡೆದು ಕೊಂದುಹಾಕಿ ಅವನ ಶವವನ್ನು ಮರಳಿನಲ್ಲಿ ಮುಚ್ಚಿಹಾಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ಮರುದಿನ ಅವನು ಮತ್ತೆ ಹೊರಗೆ ಹೋದಾಗ, ಇಬ್ರಿಯರಾದ ಇಬ್ಬರು ಜಗಳವಾಡುತ್ತಿದ್ದರು. ಅನ್ಯಾಯಮಾಡುತ್ತಿದ್ದವನಿಗೆ ಅವನು, “ಏನಯ್ಯಾ, ನೀನು ಯಾಕೆ ಸ್ವಕುಲದವರನ್ನು ಹೊಡೆಯುತ್ತೀ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ಆ ಮನುಷ್ಯನು ಅವನಿಗೆ, “ನಿನ್ನನ್ನು ನಮ್ಮ ಮೇಲೆ ಅಧಿಕಾರಿಯನ್ನಾಗಿಯೂ, ನ್ಯಾಯಾಧಿಪತಿಯನ್ನಾಗಿಯೂ, ಇಟ್ಟವರು ಯಾರು? ಆ ಐಗುಪ್ತ್ಯನನ್ನು ಕೊಂದು ಹಾಕಿದಂತೆ ನನ್ನನ್ನೂ ಕೊಂದುಹಾಕಬೇಕೆಂದಿದ್ದಿಯೋ?” ಅಂದನು. ಈ ಮಾತನ್ನು ಕೇಳಿ ಮೋಶೆಯು ಭಯಪಟ್ಟು, “ನಿಶ್ಚಯವಾಗಿ ನಾನು ಮಾಡಿದ ಕಾರ್ಯವು ಬಯಲಿಗೆ ಬಂತಲ್ಲಾ” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ನಡೆದ ಸಂಗತಿಯು ಫರೋಹನಿಗೆ ತಿಳಿದುಬಂದಾಗ, ಅವನು ಮೋಶೆಯನ್ನು ಕೊಲ್ಲಬೇಕೆಂದು ಆಲೋಚಿಸುತ್ತಿದ್ದನು. ಆದುದರಿಂದ ಮೋಶೆಯು ಫರೋಹನ ಬಳಿಯಿಂದ ಓಡಿಹೋಗಿ ಮಿದ್ಯಾನ್ ದೇಶದಲ್ಲಿದ್ದ ಒಂದು ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ಕುಳಿತುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ಮಿದ್ಯಾನರ ಯಾಜಕನಿಗೆ ಏಳು ಮಂದಿ ಹೆಣ್ಣು ಮಕ್ಕಳಿದ್ದರು. ಅವರು ಬಂದು ತಮ್ಮ ತಂದೆಯ ಕುರಿ ಮಂದೆಗಳಿಗೆ ನೀರು ಕುಡಿಸುವುದಕ್ಕಾಗಿ, ನೀರನ್ನು ಸೇದಿ ತೊಟ್ಟಿಗಳಲ್ಲಿ ತುಂಬಿಸುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ಕುರುಬರು ಬಂದು ಅವರನ್ನು ಬಾವಿಯ ಬಳಿಯಿಂದ ಓಡಿಸಲು, ಮೋಶೆಯು ಅವರಿಗೆ ಸಹಾಯಕನಾಗಿ ಬಂದು ಅವರ ಕುರಿಗಳಿಗೆ ನೀರನ್ನು ಕುಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ಆ ನಂತರ ಆ ಹೆಣ್ಣುಮಕ್ಕಳು ತಮ್ಮ ತಂದೆಯಾದ ರೆಗೂವೇಲನ ಬಳಿಗೆ ಬಂದಾಗ ಅವನು ಅವರಿಗೆ, “ಏಕೆ ಈ ಹೊತ್ತು ಬೇಗ ಬಂದಿದ್ದಿರಲ್ಲ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ಅದಕ್ಕೆ ಅವರು, “ಐಗುಪ್ತದವನಾದ ಒಬ್ಬ ಮನುಷ್ಯನು ನಮ್ಮನ್ನು ಕುರುಬರ ಕೈಯಿಂದ ತಪ್ಪಿಸಿದಲ್ಲದೆ, ಅವನು ನಮಗೋಸ್ಕರ ನೀರು ಸೇದಿ ಕುರಿಗಳಿಗೆ ಕುಡಿಸಿದನು” ಅಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ಆಗ ಅವನು ತನ್ನ ಮಕ್ಕಳಿಗೆ, “ಅವನು ಎಲ್ಲಿದ್ದಾನೆ? ಏಕೆ ಆ ಮನುಷ್ಯನನ್ನು ಬಿಟ್ಟು ಬಂದಿರಿ? ಅವನನ್ನು ಕರೆಯಿರಿ, ಅವನು ನಮ್ಮೊಂದಿಗೆ ಊಟಮಾಡಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ಮೋಶೆಯು ಆ ಮನುಷ್ಯನೊಂದಿಗೆ ವಾಸಮಾಡಲು ಬಯಸಿದನು. ಅವನು ತನ್ನ ಮಗಳಾದ ಚಿಪ್ಪೋರಳನ್ನು ಮೋಶೆಗೆ ಮದುವೆಮಾಡಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ಆಕೆ ಗಂಡು ಮಗುವನ್ನು ಹೆರಲು ಮೋಶೆ ನಾನು ಅನ್ಯದೇಶದಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿದ್ದೇನೆಂದು ಹೇಳಿ ಅದಕ್ಕೆ ಗೇರ್ಷೋಮ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ಹೀಗೆ ಬಹಳ ದಿನಗಳು ಕಳೆದ ನಂತರ ಐಗುಪ್ತ ದೇಶದ ಅರಸನು ಸತ್ತನು. ಇಸ್ರಾಯೇಲರು ತಾವು ಮಾಡಬೇಕಾದ ಬಿಟ್ಟೀ ಕೆಲಸಕ್ಕಾಗಿ ನಿಟ್ಟುಸಿರು ಬಿಟ್ಟು ಗೋಳಾಡುತ್ತಾ ಇದ್ದರು. ಆ ಗೋಳು ದೇವರಿಗೆ ಮುಟ್ಟಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ದೇವರು ಅವರ ನರಳಾಟವನ್ನು ಕೇಳಿ, ತಾನು ಅಬ್ರಹಾಮ, ಇಸಾಕ, ಯಾಕೋಬನ ಸಂಗಡ ಮಾಡಿದ ಒಡಂಬಡಿಕೆಯನ್ನು ನೆನಪಿಗೆ ತಂದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ದೇವರು ಇಸ್ರಾಯೇಲರನ್ನು ನೋಡಿ ಅವರ ವಿಷಯದಲ್ಲಿ ಕನಿಕರಪಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ಮೋಶೆಯು ತನ್ನ ಮಾವನಾದ, ಮಿದ್ಯಾನ್ಯರ ಯಾಜಕನಾದ ಇತ್ರೋನನ ಮಂದೆಯನ್ನು ಮೇಯಿಸುತ್ತಿರಲಾಗಿ ಆ ಮಂದೆಯನ್ನು ಅಡವಿಯ ಮತ್ತೊಂದುಭಾಗಕ್ಕೆ ನಡಿಸಿಕೊಂಡು ಹೋಗುತ್ತಾ, “ಹೋರೇಬ್” ಎಂಬ ದೇವರ ಬೆಟ್ಟಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ಆಗ ಯೆಹೋವನ ದೂತನು ಮುಳ್ಳಿನ ಪೊದೆಯೊಳಗಿನಿಂದ ಉರಿಯುವ ಬೆಂಕಿ ಜ್ವಾಲೆಯಲ್ಲಿ ಅವನಿಗೆ ಕಾಣಿಸಿಕೊಂಡನು. ಮೋಶೆಯು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ, ಆ ಮುಳ್ಳಿನ ಪೊದೆಯು ಬೆಂಕಿಯಿಂದ ಉರಿಯುತ್ತಿತ್ತು; ಆದರೆ ಅದು ಸುಟ್ಟು ಹೋಗಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ಆಗ ಮೋಶೆ, “ಇದೇನು ಆಶ್ಚರ್ಯ! ಪೊದೆಯು ಸುಟ್ಟು ಹೋಗುತ್ತಿಲ್ಲವಲ್ಲಾ! ಇದನ್ನು ಹತ್ತಿರಕ್ಕೆ ಹೋಗಿ ನೋಡುವೆನು” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ಅವನು ಅದನ್ನು ನೋಡುವುದಕ್ಕೆ ಹತ್ತಿರ ಬರುವುದನ್ನು ಯೆಹೋವನು ಕಂಡನು. ಆಗ ದೇವರು ಆ ಪೊದೆಯೊಳಗಿಂದ “ಮೋಶೆಯೇ, ಮೋಶೆಯೇ” ಎಂದು ಅವನನ್ನು ಕರೆದನು. ಅದಕ್ಕೆ ಮೋಶೆ, “ಇಗೋ ಇದ್ದೇನೆ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ದೇವರು ಅವನಿಗೆ, “ನೀನು ಪೊದೆಯ ಹತ್ತಿರ ಬರಬೇಡ! ನಿನ್ನ ಕಾಲಿನ ಕೆರಗಳನ್ನು ತೆಗೆದುಹಾಕು, ಯಾಕೆಂದರೆ ನೀನು ನಿಂತಿರುವ ಸ್ಥಳವು ಪರಿಶುದ್ಧ ಸ್ಥಳವಾಗಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ಇದಲ್ಲದೆ ಆತನು ಅವನಿಗೆ, “ನಾನು ನಿನ್ನ ತಂದೆಯಾದ, ಅಬ್ರಹಾಮನ ದೇವರು, ಇಸಾಕನ ದೇವರು, ಯಾಕೋಬನ ದೇವರೂ ಆಗಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ಮೋಶೆಯು ದೇವರನ್ನು ನೋಡುವುದಕ್ಕೆ ಭಯಪಟ್ಟು ಮುಖವನ್ನು ಮುಚ್ಚಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ಆಗ ಯೆಹೋವನು, “ಐಗುಪ್ತ ದೇಶದಲ್ಲಿರುವ ನನ್ನ ಜನರ ದುರವಸ್ಥೆಯನ್ನು ನಿಶ್ಚಯವಾಗಿ ನೋಡಿದ್ದೇನೆ. ಬಿಟ್ಟೀ ಕೆಲಸ ಮಾಡುವ ವಿಷಯದಲ್ಲಿ, ಅವರು ಇಟ್ಟ ಮೊರೆಯು ನನಗೆ ಕೇಳಿಸಿತು. ಅವರ ದುಃಖವನ್ನೆಲ್ಲಾ ನಾನು ಬಲ್ಲೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ಆದಕಾರಣ ಅವರನ್ನು ಐಗುಪ್ತ್ಯರ ಕೈಯೊಳಗಿಂದ ಬಿಡಿಸುವುದಕ್ಕೂ ಆ ದೇಶದಿಂದ ಅವರನ್ನು ಹಾಲೂ ಮತ್ತು ಜೇನೂ ಹರಿಯುವ ವಿಸ್ತಾರವಾದ ಒಳ್ಳೆಯ ದೇಶಕ್ಕೆ ಅಂದರೆ ಕಾನಾನ್ಯರು, ಹಿತ್ತಿಯರು, ಅಮೋರಿಯರು, ಪೆರಿಜೀಯರು, ಹಿವ್ವಿಯರು, ಯೆಬೂಸಿಯರು ವಾಸವಾಗಿರುವ ದೇಶಕ್ಕೆ ನಡೆಸಿಕೊಂಡು ಹೋಗುವುದಕ್ಕೂ ಇಳಿದು ಬಂದಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ಈಗ ಇಸ್ರಾಯೇಲರ ಕೂಗು ನನಗೆ ಮುಟ್ಟಿದೆ. ಐಗುಪ್ತ್ಯರು ಅವರಿಗೆ ಕೊಡುವ ಉಪದ್ರವವನ್ನು ನಾನು ನೋಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ಆದುದರಿಂದ ಈಗ ಬಾ, ನನ್ನ ಜನರಾದ ಇಸ್ರಾಯೇಲರನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಗೆ ಬರಮಾಡುವುದಕ್ಕೆ ನಿನ್ನನ್ನು ಫರೋಹನ ಬಳಿಗೆ ಕಳುಹಿಸುತ್ತೇನೆ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ಆಗ ಮೋಶೆಯು ದೇವರಿಗೆ, “ಫರೋಹನ ಬಳಿಗೆ ಹೋಗುವುದಕ್ಕೂ ಮತ್ತು ಇಸ್ರಾಯೇಲರನ್ನು ಐಗುಪ್ತದೇಶದಿಂದ ಕರೆದುಕೊಂಡು ಬರುವುದಕ್ಕೂ ನಾನು ಎಷ್ಟರವನು?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ಅದಕ್ಕೆ ದೇವರು, “ನಿಶ್ಚಯವಾಗಿ ನಾನು ನಿನ್ನ ಸಂಗಡ ಇರುವೆನು. ನೀನು ನನ್ನ ಜನರನ್ನು ಐಗುಪ್ತದೇಶದಿಂದ ಹೊರಗೆ ತಂದಾಗ ನೀವು ಈ ಬೆಟ್ಟದಲ್ಲೇ ನನ್ನನ್ನು ಆರಾಧಿಸುವಿರಿ. ನಿನ್ನನ್ನು ಕಳುಹಿಸಿದವನು ನಾನೇ ಎಂಬುವುದಕ್ಕೆ ಇದು ನಿನಗೆ ಗುರುತಾಗಿರುವುದು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ಅದಕ್ಕೆ ಮೋಶೆಯು ದೇವರಿಗೆ, “ನಾನು ಇಸ್ರಾಯೇಲರ ಬಳಿಗೆ ಹೋಗಿ, ‘ನಿಮ್ಮ ಪೂರ್ವಿಕರ ದೇವರು ನನ್ನನ್ನು ನಿಮ್ಮ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾನೆ’ ಎಂದು ಹೇಳಿದಾಗ, ನನಗೆ ಒಂದು ವೇಳೆ ಅವರು, ಆತನ ಹೆಸರು ಏನು? ಎಂದು ಕೇಳಿದರೆ ನಾನೇನು ಉತ್ತರಕೊಡಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ದೇವರು ಮೋಶೆಗೆ, “ಇರುವಾತನೇ ಆಗಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. “ಮತ್ತು ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ, ಇರುವಾತನೆಂಬುವವನು ನನ್ನನ್ನು ನಿಮ್ಮ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾನೆ ಎಂದು ಹೇಳಬೇಕು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ದೇವರು ಪುನಃ ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ, ನಿಮ್ಮ ಪೂರ್ವಿಕರಾದ ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೋಬರ ದೇವರಾಗಿರುವ ಯೆಹೋವನು ನನ್ನನ್ನು ನಿಮ್ಮ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾನೆ” ಎಂದು ಹೇಳಬೇಕು. ಇದು ಸದಾಕಾಲಕ್ಕೂ ಇರುವ ನನ್ನ ಹೆಸರು. ಇದು ತಲಾಂತರಕ್ಕೂ ನನ್ನನ್ನು ಸ್ಮರಿಸಬೇಕಾದ ನಾಮ. ");
INSERT INTO kanirv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ಆತನು, ನೀನು ಹೋಗಿ ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿ ಅವರಿಗೆ, “ನಿಮ್ಮ ಪೂರ್ವಿಕರ ದೇವರು ಅಂದರೆ ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೋಬರ ದೇವರು ಆಗಿರುವ ಯೆಹೋವನು ನನಗೆ ದರ್ಶನಕೊಟ್ಟು ನಿಮ್ಮನ್ನು ಕಟಾಕ್ಷಿಸಿ ಐಗುಪ್ತದೇಶದಲ್ಲಿ ನಿಮಗೆ ಸಂಭವಿಸಿದ್ದನ್ನೆಲ್ಲಾ ನಿಶ್ಚಯವಾಗಿ ನಾನು ನೋಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ನಿಮಗುಂಟಾದ ದುರವಸ್ಥೆಯಿಂದ ನಿಮ್ಮನ್ನು ಬಿಡಿಸಿ, ಹಾಲೂ ಮತ್ತು ಜೇನೂ ಹರಿಯುವ ದೇಶಕ್ಕೆ ಅಂದರೆ ಕಾನಾನ್ಯರೂ, ಹಿತ್ತಿಯರೂ, ಅಮೋರಿಯರೂ, ಪೆರಿಜೀಯರೂ, ಹಿವ್ವಿಯರೂ, ಯೆಬೂಸಿಯರೂ, ವಾಸವಾಗಿರುವ ದೇಶಕ್ಕೆ ಬರಮಾಡಬೇಕೆಂದು ನಿರ್ಣಯಿಸಿದ್ದೇನೆ” ಎಂಬುದಾಗಿ ಅವರಿಗೆ ಹೇಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","ಅವರು ನಿನ್ನ ಮಾತಿಗೆ ಕಿವಿಗೊಡುವರು. ನೀನು ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರು ಐಗುಪ್ತದೇಶದ ಅರಸನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ, “ಇಬ್ರಿಯರ ದೇವರಾಗಿರುವ ಯೆಹೋವನು ನಮಗೆ ಪ್ರತ್ಯಕ್ಷನಾದನು. ಆದುದರಿಂದ ನಾವು ಮರುಭೂಮಿಯಲ್ಲಿ ಮೂರು ದಿನದ ಪ್ರಯಾಣದಷ್ಟು ದೂರ ಹೋಗಿ ನಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವನಿಗಾಗಿ ಯಜ್ಞಮಾಡಬೇಕಾಗಿದೆ, ಅದಕ್ಕೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು” ಎಂದು ಕೇಳಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ಆ ಐಗುಪ್ತದ ಅರಸನು ನೀವು ಎಷ್ಟು ಬಲವಂತ ಮಾಡಿದರೂ ನಿಮ್ಮನ್ನು ಬಿಡುವುದಿಲ್ಲವೆಂದು ನನಗೆ ತಿಳಿದಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ಆದಕಾರಣ ನಾನು ನನ್ನ ಕೈಯನ್ನು ಚಾಚಿ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ಮಾಡಿ ಅದನ್ನು ನಾನಾ ವಿಧವಾಗಿ ಬಾಧಿಸುವೆನು. ಅನಂತರ ಅರಸನು ನಿಮ್ಮನ್ನು ಕಳುಹಿಸಿಕೊಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“ಇದಲ್ಲದೆ ಈ ನನ್ನ ಜನರ ಮೇಲೆ ಐಗುಪ್ತ್ಯರಿಗೆ ದಯೆಯುಂಟಾಗುವಂತೆ ಮಾಡುವೆನು. ಆದ್ದರಿಂದ ನೀವು ಹೊರಡುವಾಗ ಬರಿಗೈಯಲ್ಲಿ ಬರಬೇಕಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ನಿಮ್ಮಲ್ಲಿನ ಪ್ರತಿಯೊಬ್ಬ ಸ್ತ್ರೀಯು ನೆರೆಹೊರೆಯ ಹೆಂಗಸರಿಂದಲೂ, ನಿಮ್ಮ ಮನೆಗಳ ಅತಿಥಿಗಳಾಗಿ ತಂಗಿರುವ ಹೆಂಗಸರಿಂದಲೂ ಬೆಳ್ಳಿ ಬಂಗಾರದ ಒಡವೆಗಳನ್ನೂ, ಬಟ್ಟೆಗಳನ್ನೂ ಕೇಳಿಕೊಳ್ಳಲಿ. ನೀವು ಅವುಗಳನ್ನು ನಿಮ್ಮ ಗಂಡು ಹೆಣ್ಣು ಮಕ್ಕಳಿಗೆ ತೊಡಿಸಿರಿ. ಹೀಗೆ ನೀವು ಐಗುಪ್ತ್ಯರನ್ನು ಸುಲಿಗೆ ಮಾಡಿಹೊರಟು ಬರುವಿರಿ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ಅದಕ್ಕೆ ಮೋಶೆಯು ಉತ್ತರವಾಗಿ, “ಅವರು ನನ್ನನ್ನು ನಂಬದೆ, ನನ್ನ ಮಾತಿಗೆ ಕಿವಿಗೊಡದೆ, ಯೆಹೋವನು ನಿನಗೆ ಕಾಣಿಸಿಕೊಂಡೇ ಇಲ್ಲ ಎಂದು ಹೇಳಬಹುದು?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ಅದಕ್ಕೆ ಯೆಹೋವನು ಅವನಿಗೆ, “ನಿನ್ನ ಕೈಯಲ್ಲಿರುವುದೇನು?” ಎಂದು ಕೇಳಿದನು. ಅವನು, ಇದು “ಇದು ಒಂದು ಕೋಲು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ಯೆಹೋವನು ಅವನಿಗೆ, “ಅದನ್ನು ನೆಲದ ಮೇಲೆ ಹಾಕು” ಎಂದನು. ಅವನು ನೆಲದಲ್ಲಿ ಹಾಕುತ್ತಲೇ ಅದು ಹಾವಾಯಿತು! ಮೋಶೆ ಅದಕ್ಕೆ ಭಯಪಟ್ಟು ಓಡಿಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಿನ್ನ ಕೈಚಾಚಿ ಅದರ ಬಾಲವನ್ನು ಹಿಡಿ” ಎಂದು ಹೇಳಿದನು. ಅವನು ಅದನ್ನು ಹಿಡಿದ ಕೂಡಲೇ ಅದು ಕೋಲಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ಆಗ ಯೆಹೋವನು ಅವನಿಗೆ, “ಇದರಿಂದ ಅವರು ತಮ್ಮ ಪೂರ್ವಿಕರಾದ ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೋಬರ ದೇವರಾಗಿರುವ ಯೆಹೋವನು, ನಿನಗೆ ಕಾಣಿಸಿಕೊಂಡಿರುವುದು ನಿಜ ಎಂದು ನಂಬುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ಯೆಹೋವನು ತಿರುಗಿ ಅವನಿಗೆ, “ನಿನ್ನ ಕೈಯನ್ನು ಎದೆಯಭಾಗದೊಳಗೆ ಇಟ್ಟುಕೋ” ಎಂದು ಹೇಳಿದನು. ಅವನು ಹಾಗೆ ಇಟ್ಟುಕೊಂಡು ಹೊರಗೆ ತೆಗೆಯಲು ಅವನ ಕೈ ಕುಷ್ಠ ಹತ್ತಿ ಹಿಮದಂತೆ ಬೆಳ್ಳಗಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ಯೆಹೋವನು ಅವನಿಗೆ ನಿನ್ನ ಕೈಯನ್ನು ತಿರುಗಿ ಎದೆಯಭಾಗದೊಳಗೆ “ಸೇರಿಸು” ಎಂದು ಹೇಳಿದನು. ಅವನು ಅದನ್ನು ತಿರುಗಿ ಎದೆಯಭಾಗದೊಳಗೆ ಸೇರಿಸಿ ತೆಗೆದು ನೋಡಿದಾಗ ಅದು ಉಳಿದ ದೇಹದಂತೆ ಆಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ಆಗ ಯೆಹೋವನು ಅವನಿಗೆ, “ಅವರು ನಿನ್ನನ್ನು ನಂಬದೆ, ಮೊದಲನೆಯ ಸೂಚಕಕಾರ್ಯವನ್ನು ಗಮನಿಸದೆ ತಿರಸ್ಕರಿಸಿದರೂ, ಎರಡನೆಯ ಸೂಚಕಕಾರ್ಯವನ್ನು ನಂಬುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ಆ ಎರಡು ಸೂಚಕಕಾರ್ಯಗಳನ್ನೂ, ಅವರು ನಂಬದೆಯೂ, ನಿನ್ನ ಮಾತನ್ನು ಕೇಳದೆಯೂ ಹೋದರೆ, ನೀನು ನೈಲ್ ನದಿಯ ನೀರನ್ನು ತೆಗೆದುಕೊಂಡು ಒಣಗಿದ ನೆಲದ ಮೇಲೆ ಸುರಿಯಬೇಕು. ಆಗ ಒಣಗಿದ ನೆಲದಲ್ಲಿ ಸುರಿದ ನೀರು ರಕ್ತವಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ಆಗ ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, “ಕರ್ತನೇ, ನಾನು ಮೊದಲಿನಿಂದಲೂ, ನೀನು ನಿನ್ನ ದಾಸನ ಸಂಗಡ ಮಾತನಾಡಿದ ಮೇಲೆಯೂ ನಾನು ವಾಕ್ಚಾತುರ್ಯವಿಲ್ಲದವನು. ನಾನು ತೊದಲುವವನಾಗಿದ್ದು ನನ್ನ ನಾಲಿಗೆಯೂ ಮಂದವಾಗಿವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ಅದಕ್ಕೆ ಯೆಹೋವನು ಅವನಿಗೆ, “ಮನುಷ್ಯರಿಗೆ ಬಾಯಿಕೊಟ್ಟವನು ಯಾರು? ಒಬ್ಬನನ್ನು ಮೂಕನಾಗಿ, ಕಿವುಡನಾಗಿ, ದೃಷ್ಠಿಯುಳ್ಳವನಾಗಿ ಹಾಗೂ ಕುರುಡನಾಗಿ ಉಂಟುಮಾಡಿದವನಾರು? ಯೆಹೋವನಾದ ನಾನೇ ಅಲ್ಲವೇ? ");
INSERT INTO kanirv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ಹಾಗಾದರೆ ಈಗಲೇ ನೀನು ಹೊರಡು, ನಾನು ನಿನ್ನಗೆ ಮಾತನಾಡಲು ಬೇಕಾದ ಸಾಮರ್ಥ್ಯವನ್ನು ಕೊಡುತ್ತಾ, ನೀನು ಮಾತನಾಡಬೇಕಾದದ್ದನ್ನು ನಿನಗೆ ಬೋಧಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ಅದಕ್ಕೆ ಮೋಶೆಯು, “ಕರ್ತನೇ, ದಯವಿಟ್ಟು ನೀನು ಬೇರೊಬ್ಬನನ್ನು ಕಳುಹಿಸಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ಆಗ ಯೆಹೋವನು ಮೋಶೆಯ ಮೇಲೆ ಕೋಪಗೊಂಡು ಅವನಿಗೆ, “ಲೇವಿಯನಾದ ಆರೋನನು ನಿನ್ನ ಸಹೋದರನಲ್ಲವೇ? ಅವನು ಚೆನ್ನಾಗಿ ಮಾತನಾಡಬಲ್ಲವನೆಂದು ನನಗೆ ತಿಳಿದಿದೆ. ಅವನೇ ನಿನ್ನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಬರುತ್ತಾನೆ. ಅವನು ನಿನ್ನನ್ನು ನೋಡಿದಾಗ ಅವನು ತನ್ನ ಹೃದಯದಲ್ಲಿ ಸಂತೋಷಿಸುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ನೀನು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಬೇಕಾದ ಮಾತುಗಳನ್ನು ಅವನಿಗೆ ತಿಳಿಸಿಕೊಡು. ನಿನ್ನ ಬಾಯಿಗೂ ಅವನ ಬಾಯಿಗೂ ಸಹಾಯವಾಗಿದ್ದು ನೀವು ಮಾಡಬೇಕಾದದ್ದನ್ನು ಬೋಧಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ಅವನು ನಿನಗೆ ಬದಲಾಗಿ ಜನರ ಸಂಗಡ ಮಾತನಾಡುವನು. ಅವನು ನಿನಗೆ ಬಾಯಂತಿರುವನು. ನೀನು ಅವನಿಗೆ ದೇವರಂತಿರುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ಇದಲ್ಲದೆ ಈ ಕೋಲನ್ನು ನಿನ್ನ ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. ಇದರಿಂದಲೇ ಆ ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ಮಾಡುವಿ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ಆಗ ಮೋಶೆ ತನ್ನ ಮಾವನಾದ ಇತ್ರೋನನ ಬಳಿಗೆ ಹಿಂದಿರುಗಿ ಬಂದು ಅವನಿಗೆ, “ನಾನು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿರುವ ನನ್ನ ಸಹೋದರರ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಿ ಅವರು ಜೀವದಿಂದ ಇದ್ದಾರೋ ಇಲ್ಲವೋ ಎಂದು ಹೋಗಿ ನೋಡುವೆನು” ಎಂದನು. ಇತ್ರೋನನು ಮೋಶೆಗೆ, “ನೀನು ಸಮಾಧಾನದಿಂದ ಹೋಗು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ಯೆಹೋವನು ಮಿದ್ಯಾನಿನಲ್ಲಿ ಮೋಶೆಗೆ, ನೀನು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹಿಂತಿರುಗಿ ಹೋಗು. ನಿನ್ನ ಪ್ರಾಣವನ್ನು ತೆಗೆಯಬೇಕೆಂದಿದ್ದವರೆಲ್ಲರೂ ಸತ್ತು ಹೋದರು ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ಮೋಶೆ ತನ್ನ ಹೆಂಡತಿಯನ್ನೂ ಮಕ್ಕಳನ್ನೂ ಕತ್ತೆಯ ಮೇಲೆ ಕುಳ್ಳಿರಿಸಿ ಅವರನ್ನು ಕರೆದುಕೊಂಡು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹೊರಟುಹೋದನು. ಜೊತೆಯಲ್ಲಿ ಅವನು ದೇವದಂಡವನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ಯೆಹೋವನು ಮೋಶೆಗೆ ಇಂತೆಂದನು, “ನೀನು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹಿಂತಿರುಗಿ ಬಂದಾಗ ನಾನು ನಿನ್ನ ಕೈಯಿಂದ ಮಾಡಿದ ಮಹತ್ಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ಫರೋಹನ ಮುಂದೆ ಮಾಡಬೇಕು. ಆದರೂ ನಾನು ಅವನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸುವೆನು. ಆದ್ದರಿಂದ ಅವನು ಜನರನ್ನು ಹೋಗಲು ಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ಆಗ ನೀನು ಫರೋಹನಿಗೆ, ‘ಇಸ್ರಾಯೇಲನು ನನ್ನ ಮಗನು, ನನಗೆ ಚೊಚ್ಚಲಮಗನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ಹಾಗೂ ನನ್ನ ಮಗನು ನಿನ್ನ ದೇಶದಿಂದ ಹೊರಟು ನನ್ನನ್ನು ಆರಾಧಿಸುವುದಕ್ಕೆ ಅವನಿಗೆ ಅಪ್ಪಣೆಕೊಡಬೇಕು. ಅದಕ್ಕೆ ನೀನು ಒಪ್ಪದೇ ಹೋದರೆ, ನಾನು ನಿನಗಿರುವ ಚೊಚ್ಚಲಮಗನನ್ನು ಸಾಯಿಸುವೆನೆಂದು ಯೆಹೋವನು ಹೇಳುತ್ತಾನೆ’” ಎಂದು ತಿಳಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ಇದಲ್ಲದೆ ಮೋಶೆಯು ಹೋಗುವ ದಾರಿಯಲ್ಲಿ, ಛತ್ರದಲ್ಲಿದ್ದಾಗ ಯೆಹೋವನು ಅವನೆದುರಿಗೆ ಬಂದು ಅವನ ಪ್ರಾಣವನ್ನು ತೆಗೆಯಬೇಕೆಂದಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ಹೀಗಿರುವಾಗ ಚಿಪ್ಪೋರಳು ಕಲ್ಲಿನ ಚೂರಿಯಿಂದ ತನ್ನ ಮಗನಿಗೆ ಸುನ್ನತಿ ಮಾಡಿ ಅದನ್ನು ಮೋಶೆಯ ಪಾದಗಳಿಗೆ ಮುಟ್ಟಿಸಿದಳು. ನಂತರ ಅವಳು, “ನೀನು ನನಗೆ ರಕ್ತಧಾರೆಯಿಂದಾದ ಮದಲಿಂಗನು” ಎಂದಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ಆಗ ಯೆಹೋವನು ಅವನನ್ನು ಉಳಿಸಿದನು. ಆಗ ಅವಳು, “ಸುನ್ನತಿಯ ನಿಮಿತ್ತವೇ ನೀನು ನನಗೆ ರಕ್ತಧಾರೆಯಿಂದಾದ ಮದಲಿಂಗನು” ಎಂಬ ಮಾತನ್ನು ಹೇಳಿದಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ಇದಲ್ಲದೆ ಯೆಹೋವನು ಆರೋನನಿಗೆ, “ನೀನು ಮೋಶೆಯನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಮರುಭೂಮಿಗೆ ಹೊರಟುಹೋಗು” ಎಂದನು. ಅವನು ಹೋಗಿ ದೇವರ ಬೆಟ್ಟದಲ್ಲೇ ಅವನನ್ನು ಎದುರುಗೊಂಡು ಮುದ್ದಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ಆಗ ಮೋಶೆಯು ಆರೋನನಿಗೆ, ತನ್ನನ್ನು ಕಳುಹಿಸಿದ ಯೆಹೋವನ ಎಲ್ಲಾ ಮಾತುಗಳನ್ನೂ, ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಸೂಚಕಕಾರ್ಯಗಳನ್ನೂ, ತಾನು ಮಾಡಿದವುಗಳನ್ನೆಲ್ಲಾ ಆರೋನನಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ತರುವಾಯ ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಹೋಗಿ ಇಸ್ರಾಯೇಲ್ಯರ ಹಿರಿಯರನ್ನೆಲ್ಲಾ ಒಟ್ಟಿಗೆ ಸೇರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ ಮಾತುಗಳನ್ನೆಲ್ಲಾ ಆರೋನನು ಅವರಿಗೆ ತಿಳಿಸಿ ಜನರ ಕಣ್ಣುಗಳ ಮುಂದೆ ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ಜನರು ನಂಬಿದರು. ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರನ್ನು ಕಟಾಕ್ಷಿಸಿ ತಮ್ಮ ದುರವಸ್ಥೆಯನ್ನು ಮನಸ್ಸಿಗೆ ತಂದುಕೊಂಡನೆಂಬುದನ್ನು, ಇಸ್ರಾಯೇಲರು ಕೇಳಿದಾಗ ತಲೆಬಾಗಿಸಿ ಆರಾಧಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ಬಳಿಕ ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಫರೋಹನ ಸನ್ನಿಧಿಗೆ ಹೋಗಿ, “ಇಸ್ರಾಯೇಲರ ದೇವರಾದ ಯೆಹೋವನು, ನನ್ನ ಜನರು ನನಗಾಗಿ ಅರಣ್ಯದೊಳಗೆ ಜಾತ್ರೆ ನಡೆಸುವಂತೆ ಅವರಿಗೆ ಅಪ್ಪಣೆ ಕೊಡಬೇಕು ಎಂದು ಹೇಳಿದ್ದಾನೆ” ಅಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ಅದಕ್ಕೆ ಫರೋಹನು, “ಯೆಹೋವನೆಂಬುವವನು ಯಾರು? ನಾನು ಅವನ ಮಾತನ್ನು ಕೇಳಿ ಇಸ್ರಾಯೇಲರನ್ನು ಹೋಗಗೊಡಿಸುವುದೇತಕ್ಕೆ? ಯೆಹೋವನು ಯಾರೋ ನನಗೆ ಗೊತ್ತಿಲ್ಲ. ಇದು ಮಾತ್ರವಲ್ಲದೆ, ಇಸ್ರಾಯೇಲರನ್ನು ಹೋಗಲು ನಾನು ಬಿಡುವುದೇ ಇಲ್ಲ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ಆಗ ಅವರು, “ಇಬ್ರಿಯರ ದೇವರು ನಮ್ಮನ್ನು ಎದುರುಗೊಂಡನು. ಅಪ್ಪಣೆಯಾದರೆ ನಾವು ಮರುಭೂಮಿಯಲ್ಲಿ ಮೂರು ದಿನ ಪ್ರಯಾಣಮಾಡಿ, ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೋಸ್ಕರ ಯಜ್ಞಮಾಡಿ ಬರುವೆವು. ಇಲ್ಲವಾದರೆ ಆತನು ನಮ್ಮನ್ನು ವ್ಯಾಧಿಯಿಂದಾದರೂ, ಕತ್ತಿಯಿಂದಾದರೂ ಸಂಹಾರಮಾಡುವನು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ಐಗುಪ್ತರ ಅರಸನು ಅವರಿಗೆ, “ಮೋಶೆ ಮತ್ತು ಆರೋನರೇ, ಈ ಜನರು ತಮ್ಮ ಕೆಲಸವನ್ನು ಮಾಡದಂತೆ ಯಾಕೆ ಅಡ್ಡಿ ಮಾಡುತ್ತೀರಿ? ನಿಮ್ಮ ಬಿಟ್ಟೀ ಕೆಲಸಕ್ಕೆ ಹೋಗಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ಫರೋಹನು, “ಇಬ್ರಿಯರು ದೇಶದಲ್ಲಿ ಹೆಚ್ಚಾಗಿದ್ದಾರೆ. ಅವರು ತಮ್ಮ ಬಿಟ್ಟೀ ಕೆಲಸಗಳನ್ನು ಮಾಡದಂತೆ ನಿಲ್ಲಿಸಿ ಬಿಡುತ್ತಿದ್ದೀರಲ್ಲಾ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ಆ ದಿನದಲ್ಲಿ ಫರೋಹನು ಬಿಟ್ಟೀಮಾಡಿಸುವವರನ್ನು ಮತ್ತು ಅವರ ಅಧಿಕಾರಿಗಳನ್ನು ಕರೆಯಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ಇನ್ನು ಮೇಲೆ ನೀವು ಆ ಜನರಿಗೆ ಇಟ್ಟಿಗೆ ಮಾಡುವುದಕ್ಕೆ ಹುಲ್ಲನ್ನು ಕೊಡಬಾರದು. ಅವರೇ ಹೋಗಿ ಹುಲ್ಲನ್ನು ಶೇಖರಿಸಿಕೊಳ್ಳಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ಆದರೂ ಅವರು ಈವರೆಗೆ ಮಾಡಿದ ಇಟ್ಟಿಗೆಗಳ ಲೆಕ್ಕದಲ್ಲಿ ಏನೂ ಕಡಿಮೆಯಾಗಬಾರದು ಎಂದು ಅವರಿಗೆ ಹೇಳಬೇಕು. ಅವರು ಮೈಗಳ್ಳರೇ, ಆದುದರಿಂದಲೇ ಅವರು, ‘ನಾವು ಹೋಗಿ ನಮ್ಮ ದೇವರಿಗೆ ಯಜ್ಞಮಾಡಿ ಬರುವುದಕ್ಕೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು’ ಎಂದು ಕೂಗಿಕೊಳ್ಳುತ್ತಿದ್ದಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ಈ ಜನರು ವ್ಯರ್ಥವಾದ ಮಾತುಗಳಿಗೆ ಗಮನ ಕೊಡದಂತೆ ನೀವು ಅವರ ಮೇಲೆ ಹೆಚ್ಚು ಕೆಲಸವನ್ನು ಹೊರಿಸಿರಿ. ಅವರು ದುಡಿಯಲಿ” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ಆಗ ಬಿಟ್ಟೀಕೆಲಸವನ್ನು ಮಾಡಿಸುವವರೂ ಮತ್ತು ಅಧಿಕಾರಿಗಳೂ ಹೊರಗೆ ಹೋಗಿ ಆ ಜನರಿಗೆ, “ನಿಮಗೆ ಹುಲ್ಲನ್ನು ಕೊಡಬಾರದೆಂದು ಫರೋಹನ ಅಪ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ನಿಮಗೆ ಹುಲ್ಲು ಎಲ್ಲಿ ದೊರಕುವುದೋ ಅಲ್ಲಿಗೆ ನೀವೇ ಹೋಗಿ ತೆಗೆದುಕೊಳ್ಳಿರಿ. ಆದರೂ ನೀವು ಮಾಡಬೇಕಾದ ಕೆಲಸದಲ್ಲಿ ಸ್ವಲ್ಪವೂ ಕಡಿಮೆಯಾಗಬಾರದು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ಹೀಗಿರಲಾಗಿ ಜನರು ಹುಲ್ಲನ್ನು ಕೂಡಿಸಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಚದರಿಹೋಗಿ ಹುಡುಕತೊಡಗಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ಇದಲ್ಲದೆ ಬಿಟ್ಟೀ ಕೆಲಸ ಮಾಡಿಸುವವರು, “ನಿಮಗೆ ಹುಲ್ಲು ಇದ್ದಾಗ ಹೇಗೋ ಹಾಗೆ ಪ್ರತಿದಿನದ ಕೆಲಸವನ್ನು ಅದೇ ದಿನದಲ್ಲೇ ಮುಗಿಸಬೇಕು” ಎಂದು ಹೇಳಿ ಅವರನ್ನು ಅವಸರ ಪಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ಫರೋಹನ ಅಧಿಕಾರಿಗಳು ತಾವೇ ನೇಮಿಸಿದ ಇಸ್ರಾಯೇಲರ ಮೇಲ್ವಿಚಾರಕರಿಗೆ, “ನೀವು ಮೊದಲು ಇಟ್ಟಿಗೆಗಳ ಲೆಕ್ಕ ಒಪ್ಪಿಸುತ್ತಿದ್ದಂತೆ ನಿನ್ನೆ ಹಾಗೂ ಈ ಹೊತ್ತು ಯಾಕೆ ಒಪ್ಪಿಸಲಿಲ್ಲ” ಎಂದು ಹೇಳಿ ಅವರನ್ನು ಹೊಡೆದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ಹೀಗಿರಲು ಇಸ್ರಾಯೇಲರ ಮೇಲ್ವಿಚಾರಕರು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, “ಏಕೆ ನಿನ್ನ ದಾಸರಿಗೆ ಹೀಗೆ ಮಾಡುತ್ತಿರುವಿರಿ ಸ್ವಾಮೀ? ");
INSERT INTO kanirv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ನಿನ್ನ ದಾಸರಿಗೆ, ನೇಮಿಸಿದ ಅಧಿಕಾರಿಗಳು ಹುಲ್ಲನ್ನು ಕೊಡದೆ ‘ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡಿರಿ!’ ಎಂದು ಹೇಳುತ್ತಾ ನಮ್ಮನ್ನು ಹೊಡೆಯುತ್ತಿದ್ದಾರೆ. ಹೀಗೆ ನಿನ್ನ ಜನರು ಮಾಡುತ್ತಿರುವುದು ಪಾಪಕಾರ್ಯವಾಗಿದೆ” ಎಂದು ಗೋಳಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ಅದಕ್ಕೆ ಅವನು, “ನೀವು ಮೈಗಳ್ಳರು, ನೀವು ಮೈಗಳ್ಳರಾದ ಕಾರಣ, ‘ನಾವು ಹೋಗಿ ಯೆಹೋವನಿಗೆ ಯಜ್ಞವನ್ನರ್ಪಿಸಿ ಬರಬೇಕು’ ಎಂದು ಹೇಳುತ್ತಿದ್ದೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ಆದ್ದರಿಂದ ಈಗ ಕೆಲಸಕ್ಕೆ ನಡೆಯಿರಿ ನಿಮಗೆ ಹುಲ್ಲನ್ನು ಕೊಡುವುದಿಲ್ಲ. ಆದರೂ ನೇಮಿಸಿದ ಇಟ್ಟಿಗೆಗಳ ಲೆಕ್ಕವನ್ನು ತಪ್ಪದೆ ಒಪ್ಪಿಸಬೇಕು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ದಿನ ದಿನವೂ ಒಪ್ಪಿಸಬೇಕಾದ ಇಟ್ಟಿಗೆಗಳ ಲೆಕ್ಕ ಕಡಿಮೆಯಾಗಬಾರದೆಂಬ ಅಪ್ಪಣೆಯಾಗಿದ್ದರಿಂದ ಇಸ್ರಾಯೇಲರ ಮೇಲ್ವಿಚಾರಕರು ತಾವು ದುರವಸ್ಥೆಯಲ್ಲಿ ಸಿಕ್ಕಿಕೊಂಡಿವೆಂದು ತಿಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ಅವರು ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಗೆ ಬಂದಾಗ ತಮ್ಮನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ನಿಂತಿದ್ದ ಮೋಶೆ ಮತ್ತು ಆರೋನರನ್ನು ನೋಡಿ ");
INSERT INTO kanirv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ಮೋಶೆ ಹಾಗು ಆರೋನರಿಗೆ, “ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ನೋಡಿ ನ್ಯಾಯತೀರಿಸಲಿ. ಏಕೆಂದರೆ ಫರೋಹನು ಮತ್ತು ಅವನ ಸೇವಕರೂ ನಮ್ಮನ್ನು ನೋಡಿ ಅಸಹ್ಯಪಡುವಂತೆ ನೀವು ಮಾಡಿರುವಿರಿ. ನಮ್ಮನ್ನು ಸಂಹಾರಮಾಡುವುದಕ್ಕೆ ಅವರ ಕೈಗೆ ಕತ್ತಿಯನ್ನು ಕೊಟ್ಟಿದ್ದೀರಿ” ಅಂದರು. “ಯೆಹೋವನು ನಿಮ್ಮ ತಪ್ಪನ್ನು ವಿಚಾರಿಸಿ ತಕ್ಕ ಶಿಕ್ಷೆಯನ್ನು ವಿಧಿಸಲಿ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ಆಗ ಮೋಶೆಯು ಯೆಹೋವನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಂದು, “ಸ್ವಾಮೀ, ಈ ಜನರಿಗೆ ಕೇಡನ್ನು ಮಾಡಿದ್ದೀಯಲ್ಲಾ? ನನ್ನನ್ನು ಕಳುಹಿಸಿದ್ದು ಯಾಕೆ? ");
INSERT INTO kanirv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ನಾನು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ನಿನ್ನ ಹೆಸರಿನಲ್ಲಿ ಮಾತನಾಡಿದಂದಿನಿಂದ ಅವನು ಈ ಜನರಿಗೆ ಕೇಡನ್ನೇ ಮಾಡುತ್ತಿದ್ದಾನೆ. ನೀನು ನಿನ್ನ ಜನರನ್ನು ಎಷ್ಟು ಮಾತ್ರವೂ ತಪ್ಪಿಸಲಿಲ್ಲವಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ಆನಂತರ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನು ಫರೋಹನಿಗೆ ಮಾಡುವುದನ್ನು ನೀನು ಈಗ ನೋಡುವೆ. ಅವನು ನನ್ನ ಬಲವಾದ ಹಸ್ತವನ್ನು ನೋಡಿ ಅವರನ್ನು ಹೋಗಗೊಡಿಸುವನು. ನನ್ನ ಭುಜಬಲದಿಂದ ಪೀಡಿತನಾಗಿ ಅವರನ್ನು ತನ್ನ ದೇಶದಿಂದ ಹೊರಡಿಸುವನು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ದೇವರು ಮೋಶೆಯ ಸಂಗಡ ಪುನಃ ಮಾತನಾಡಿ ಇಂತೆಂದನು, “ನಾನೇ ಯೆಹೋವನು, ");
INSERT INTO kanirv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ನಾನು ಅಬ್ರಹಾಮನಿಗೂ, ಇಸಾಕನಿಗೂ, ಯಾಕೋಬನಿಗೂ ಸರ್ವಶಕ್ತನಾದ ದೇವರಾಗಿ ಕಾಣಿಸಿಕೊಂಡಿದ್ದೆನು. ಆದರೆ ಯೆಹೋವನೆಂಬ ನನ್ನ ಹೆಸರಿನಲ್ಲಿ ಅವರಿಗೆ ಗೋಚರವಾಗಿರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ನಾನು ಅವರಿಗೆ ಕಾನಾನ್ ದೇಶವನ್ನು ಅಂದರೆ, ಅವರು ಪರದೇಶದವರಾಗಿ ವಾಸವಾಗಿದ್ದ ಪ್ರವಾಸದ ದೇಶವನ್ನು ನಾನು ಅವರಿಗೆ ಕೊಡುವೆನೆಂದು ಅವರ ಸಂಗಡ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡಿರುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ಐಗುಪ್ತರು ದಾಸರಾಗಿ ಮಾಡಿಕೊಂಡಿರುವ ಇಸ್ರಾಯೇಲರ ಗೋಳು ಈಗ ನನಗೆ ಕೇಳಿಸಿತು. ನಾನು ಮಾಡಿದ ವಾಗ್ದಾನವನ್ನು ಪುನಃ ನೆನಪುಮಾಡಿಕೊಂಡೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ಆದುದರಿಂದ, ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ನನ್ನ ಹೆಸರಿನಲ್ಲಿ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ನಾನೇ ಯೆಹೋವನು ಐಗುಪ್ತರು ನಿಮ್ಮಿಂದ ಮಾಡಿಸುವ ಬಿಟ್ಟೀ ಕೆಲಸಗಳನ್ನು ತಪ್ಪಿಸಿ, ಅವರ ದಾಸತ್ವದಿಂದ ನಿಮ್ಮನ್ನು ಬಿಡಿಸಿ, ನನ್ನ ಕೈಚಾಚಿ ಅವರಿಗೆ ಮಹಾ ಶಿಕ್ಷೆಗಳನ್ನು ವಿಧಿಸಿ ನಿಮ್ಮನ್ನು ರಕ್ಷಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ನಾನು ನಿಮ್ಮನ್ನು ನನ್ನ ಪ್ರಜೆಗಳನ್ನಾಗಿ ಆರಿಸಿಕೊಂಡು ನಿಮಗೆ ದೇವರಾಗಿರುವೆನು. ಐಗುಪ್ತ್ಯರು ಮಾಡಿಸುವ ಬಿಟ್ಟೀ ಸೇವೆಯನ್ನು ನಾನು ನಿಮಗೆ ತಪ್ಪಿಸಿದಾಗ ಯೆಹೋವನೆಂಬ ನಾನೇ ನಿಮ್ಮ ದೇವರಾಗಿದ್ದೇನೆ ಎಂಬುದು ನಿಮಗೆ ತಿಳಿಯುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ಇದಲ್ಲದೆ ಅಬ್ರಹಾಮ್, ಇಸಾಕ್ ಮತ್ತು ಯಾಕೋಬರಿಗೆ ನಾನು ಕೈ ಎತ್ತಿ ಪ್ರಮಾಣಮಾಡಿದ ದೇಶದಲ್ಲಿ ನಿಮ್ಮನ್ನು ಬರಮಾಡಿ, ಅದನ್ನು ನಿಮಗೆ ಸ್ವತ್ತಾಗಿ ಕೊಡುವೆನೆಂದು ಹೇಳಿದವನು ಯೆಹೋವನೆಂಬ ನಾನೇ’ ಎಂದು ಅವರಿಗೆ ಹೇಳು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ಮೋಶೆ ಈ ಮಾತುಗಳನ್ನು ಅದೇ ಪ್ರಕಾರವಾಗಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಿದಾಗ, ಅವರ ಮನಸ್ಸು ಕುಗ್ಗಿಹೋದದ್ದರಿಂದಲೂ, ಕಠಿಣವಾಗಿ ದಾಸತ್ವದ ಸೇವೆ ಮಾಡಬೇಕಾಗಿ ಬಂದದ್ದರಿಂದಲೂ ಅವರು ಮೋಶೆಯ ಮಾತಿಗೆ ಕಿವಿಗೊಡಲೇ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ಆಗ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ನೀನು ಐಗುಪ್ತ್ಯರ ಅರಸನಾದ ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಅವನು ಇಸ್ರಾಯೇಲರನ್ನು ತನ್ನ ದೇಶದಿಂದ ಹೊರಟು ಹೋಗುವಂತೆ ಅವನ ಸಂಗಡ ಮಾತನಾಡು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ಅದಕ್ಕೆ ಮೋಶೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ, “ಇಗೋ, ಇಸ್ರಾಯೇಲರೇ ನನ್ನ ಮಾತುಗಳನ್ನು ಕೇಳುತ್ತಿಲ್ಲ; ಹೀಗಿರುವಾಗ ತೊದಲು ಮಾತನಾಡುವ ನನ್ನ ಮಾತುಗಳಿಗೆ ಫರೋಹನು ಕಿವಿಗೊಟ್ಟಾನೇ?” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ, ಇಸ್ರಾಯೇಲರನ್ನು ಐಗುಪ್ತದೇಶದೊಳಗಿಂದ ಬರಮಾಡಬೇಕೆಂದು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸಿ ಅವರನ್ನು ಇಸ್ರಾಯೇಲರ ಬಳಿಗೂ ಐಗುಪ್ತದ ಅರಸನಾದ ಫರೋಹನ ಬಳಿಗೂ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ಇಸ್ರಾಯೇಲ್ ಗೋತ್ರಗಳ ಕುಟುಂಬಗಳ ಮುಖ್ಯಸ್ಥರು: ಇಸ್ರಾಯೇಲನ ಚೊಚ್ಚಲು ಮಗನಾದ ರೂಬೇನನ ಮಕ್ಕಳು: ಹನೋಕ್, ಫಲ್ಲು, ಹೆಚ್ರೋನ್, ಕರ್ಮೀ. ಇವರೇ ರೂಬೇನಿನಿಂದ ಉಂಟಾದ ಗೋತ್ರಗಳ ಮೂಲ ಪುರುಷರು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ಸಿಮೆಯೋನನ ಮಕ್ಕಳಾದ; ಯೆಮೂಯೇಲ್, ಯಾಮೀನ್, ಓಹದ್, ಯಾಕೀನ್, ಚೋಹರ್ ಮತ್ತು ಕಾನಾನ್ಯ ಸ್ತ್ರೀಯಲ್ಲಿ ಹುಟ್ಟಿದ ಸೌಲ ಇವರು ಸಿಮೆಯೋನನಿಂದುಂಟಾದ ಗೋತ್ರಗಳಿಗೆ ಮೂಲ ಪುರುಷರು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ವಂಶಾವಳಿಗಳ ಪ್ರಕಾರ ಲೇವಿಯರ ಮಕ್ಕಳು: ಗೇರ್ಷೋನ್, ಕೆಹಾತ್, ಮೆರಾರೀ, ಇವರೇ. ಲೇವಿಯು ನೂರ ಮೂವತ್ತೇಳು ವರ್ಷ ಬದುಕಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ಗೋತ್ರಗಳಿಗನುಸಾರವಾಗಿ ಗೇರ್ಷೋನನ ಮಕ್ಕಳು: ಲಿಬ್ನೀ ಮತ್ತು ಶಿಮ್ಮಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ಕೊಹಾತನ ಮಕ್ಕಳು: ಅಮ್ರಾಮ್, ಇಚ್ಹಾರ್, ಹೆಬ್ರೋನ್, ಉಜ್ಜೀಯೇಲ್. ಕೆಹಾತನು ನೂರ ಮೂವತ್ತಮೂರು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ಮೆರಾರೀಯ ಮಕ್ಕಳು: ಮಹ್ಲೀ, ಮೂಷೀ ವಂಶಾವಳಿಗಳ ಪ್ರಕಾರ ಲೇವಿಯಿಂದುಂಟಾದ ಗೋತ್ರಗಳು ಇವೇ ಆಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ಅಮ್ರಾಮನು ತನ್ನ ತಂದೆಯ ತಂಗಿ ಯೋಕೆಬೆದಳನ್ನು ಮದುವೆಮಾಡಿಕೊಂಡನು. ಆಕೆಯು ಅವನಿಗೆ ಆರೋನನನ್ನೂ, ಮೋಶೆಯನ್ನೂ ಹೆತ್ತಳು. ಅಮ್ರಾಮನು ನೂರಮೂವತ್ತೇಳು ವರ್ಷ ಬದುಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ಇಚ್ಹಾರನ ಮಕ್ಕಳು ಕೋರಹ, ನೆಫೆಗ್ ಮತ್ತು ಚಿಕ್ರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ಉಜ್ಜೀಯೇಲನ ಮಕ್ಕಳು: ಮೀಷಾಯೇಲ್, ಎಲ್ಜಾಫಾನ್ ಮತ್ತು ಸಿತ್ರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ಆರೋನನು ಅಮ್ಮೀನಾದಾಬನ ಮಗಳೂ ನಹಶೋನನ ತಂಗಿಯೂ ಆಗಿದ್ದ, ಎಲೀಶೇಬಳನ್ನು ಮದುವೆಯಾದನು. ಆಕೆಯಲ್ಲಿ ಅವನಿಗೆ ನಾದಾಬ್, ಅಬೀಹೂ, ಎಲ್ಲಾಜಾರ್, ಈತಾಮಾರ್ ಎಂಬವರು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ಕೋರಹನ ಮಕ್ಕಳು: ಅಸ್ಸೀರ್, ಎಲ್ಕಾನ್, ಅಬೀಯಾಸಾಫ್ ಇವರೇ ಕೋರಹೀಯರ ಗೋತ್ರಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ಆರೋನನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನು ಪೂಟಿಯೇಲನ ಹೆಣ್ಣು ಮಕ್ಕಳಲ್ಲಿ ಒಬ್ಬಾಕೆಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡನು. ಆಕೆ ಅವನಿಗೆ ಫೀನೆಹಾಸನನ್ನು ಹೆತ್ತಳು. ಅವರವರ ಗೋತ್ರದ ಪ್ರಕಾರ ಇವರೇ ಲೇವಿಯರ ಪೂರ್ವಿಕರು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ಇಸ್ರಾಯೇಲರನ್ನು ಅವರ ಗೋತ್ರಗಳಿಗನುಸಾರವಾಗಿ, ಐಗುಪ್ತದೇಶದಿಂದ ಹೊರಗೆ ಬರಮಾಡಬೇಕೆಂದು ಯೆಹೋವನು ಯಾರಿಗೆ ಹೇಳಿದನೋ ಅವರೇ ಆರೋನ್ ಮತ್ತು ಮೋಶೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ಇಸ್ರಾಯೇಲರನ್ನು ಐಗುಪ್ತದೇಶದಿಂದ ಹೊರಗೆ ಬರಮಾಡುವುದಕ್ಕಾಗಿ ಐಗುಪ್ತ್ಯರ ಅರಸನಾದ ಫರೋಹನ ಸಂಗಡ ಮಾತನಾಡಿದಂತಹ ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ಯೆಹೋವನು ಐಗುಪ್ತದೇಶದಲ್ಲಿ, ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿದಾಗ ");
INSERT INTO kanirv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ಆತನು ಮೋಶೆಗೆ, “ನಾನು ಯೆಹೋವನು ನಾನು ನಿನಗೆ ಹೇಳುವುದನ್ನೆಲ್ಲಾ ನೀನು ಐಗುಪ್ತ್ಯರ ಅರಸನಾದ ಫರೋಹನನಿಗೆ ತಿಳಿಸು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ಆದರೆ ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, “ಇಗೋ, ಸ್ವಾಮಿ ನಾನು ಮಾತನಾಡುವುದರಲ್ಲಿ ಜಾಣನಲ್ಲ, ಫರೋಹನು ನನ್ನ ಮಾತನ್ನು ಹೇಗೆ ಕೇಳಾನು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ ಇಂತೆಂದನು, “ನಿನ್ನನ್ನು ಫರೋಹನಿಗೆ ದೇವರಂತೆ ನೇಮಿಸಿದ್ದೇನೆ. ನೋಡು, ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನು ನಿನಗೋಸ್ಕರ ಪ್ರವಾದಿಯಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸುವುದ್ದನ್ನೆಲ್ಲಾ ನೀನು ಹೇಳಬೇಕು. ಇಸ್ರಾಯೇಲರು ದೇಶದಿಂದ ಹೊರಟುಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆಕೊಡಬೇಕೆಂಬುದಾಗಿ ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನೇ ಫರೋಹನ ಮುಂದೆ ಮಾತನಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ಆದರೂ ನಾನು ಫರೋಹನ ಮನಸ್ಸಿನಲ್ಲಿ ಹಠವನ್ನು ಹುಟ್ಟಿಸಿ, ಐಗುಪ್ತದೇಶದಲ್ಲಿ ಅನೇಕ ಸೂಚಕಕಾರ್ಯಗಳನ್ನೂ ಮತ್ತು ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನೂ ಮಾಡಿ ನನ್ನ ಶಕ್ತಿಯನ್ನು ತೋರಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ಫರೋಹನು ನಿಮ್ಮ ಮಾತನ್ನು ಕೇಳುವುದಿಲ್ಲ. ಆಗ ನಾನು ಐಗುಪ್ತದೇಶದವರನ್ನು ಬಾಧಿಸಿ, ಅವರಿಗೆ ಮಹಾಶಿಕ್ಷೆಗಳನ್ನು ವಿಧಿಸಿ, ನನ್ನ ಜನರಾಗಿರುವ ಇಸ್ರಾಯೇಲರ ಸೈನ್ಯವನ್ನೆಲ್ಲಾ ಐಗುಪ್ತದೇಶದಿಂದ ಹೊರತರುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ನಾನು ಐಗುಪ್ತ್ಯರಿಗೆ ವಿರೋಧವಾಗಿ ಕೈಚಾಚಿ ಅವರ ಮಧ್ಯದಿಂದ ಇಸ್ರಾಯೇಲರನ್ನು ಹೊರತಂದಾಗ ನಾನು ಯೆಹೋವನು ಎಂಬುವುದನ್ನು ಐಗುಪ್ತ್ಯರು ತಿಳಿದುಕೊಳ್ಳುವರು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ಯೆಹೋವನ ಆಜ್ಞೆಯಂತೆಯೇ ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ಅವರು ಫರೋಹನ ಹತ್ತಿರ ಮಾತನಾಡಿದ ಕಾಲದಲ್ಲಿ ಮೋಶೆ ಎಂಬತ್ತು ವರ್ಷದವನೂ ಮತ್ತು ಆರೋನನು ಎಂಭತ್ತಮೂರು ವರ್ಷದವನೂ ಆಗಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ಯೆಹೋವನು ಮೋಶೆ ಹಾಗೂ ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ಫರೋಹನು ನಿಮಗೆ ‘ನಾನು ನಿಮ್ಮ ಮಾತನ್ನು ನಂಬುವಂತೆ ನೀವು ಮಹತ್ಕಾರ್ಯವನ್ನು ನನ್ನ ಮುಂದೆ ಮಾಡಬೇಕು’ ಎಂದು ಹೇಳಿದರೆ ಮೋಶೆಯು ಆರೋನನಿಗೆ, ‘ನಿನ್ನ ಕೈಯಲ್ಲಿರುವ ಕೋಲನ್ನು ಫರೋಹನ ಮುಂದೆ ನೆಲದಲ್ಲಿ ಹಾಕು’ ಎಂದು ಹೇಳಬೇಕು. ಅದು ಸರ್ಪವಾಗುವುದು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ಮೋಶೆ ಆರೋನರು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ತಮಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡಿದರು. ಆರೋನನು ತನ್ನ ಕೋಲನ್ನು ಫರೋಹನ ಮತ್ತು ಅವನ ಪರಿವಾರದವರ ಮುಂದೆ ನೆಲದಲ್ಲಿ ಹಾಕಿದಾಗ ಅದು ಸರ್ಪವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ಫರೋಹನು ಐಗುಪ್ತದೇಶದ ವಿದ್ವಾಂಸರನ್ನೂ ಮತ್ತು ಮಂತ್ರವಾದಿಗಳನ್ನೂ ಕರೆಯಿಸಿದಾಗ ಆ ಮಾಂತ್ರಿಕರು ತಮ್ಮ ಮಂತ್ರವಿದ್ಯೆಗಳಿಂದ ಅದೇ ರೀತಿಯಾಗಿ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ಅವರು ತಮ್ಮ ತಮ್ಮ ಕೋಲುಗಳನ್ನು ನೆಲಕ್ಕೆ ಹಾಕಲು ಅವು ಸರ್ಪಗಳಾದವು. ಆದರೆ ಆರೋನನ ಕೋಲು ಅವರ ಕೋಲುಗಳನ್ನು ನುಂಗಿಬಿಟ್ಟಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ಯೆಹೋವನು ಮೊದಲು ಹೇಳಿದಂತೆಯೇ ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಯಿತು. ಅವನು ಅವರ ಮಾತಿಗೆ ಕಿವಿಗೊಡದೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಗಿದೆ, ತಾನು ಜನರಿಗೆ ಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆಕೊಡುವುದಿಲ್ಲ ಎನ್ನುತ್ತಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ನೀನು ಬೆಳಿಗ್ಗೆ ಫರೋಹನ ಬಳಿಗೆ ಹೋಗು, ಅವನು ನೀರಿನ ಬಳಿಗೆ ಇಳಿದು ಬರುತ್ತಾನಲ್ಲಾ. ಸರ್ಪವಾಗಿ ಮಾರ್ಪಾಟುಮಾಡಿದ ಆ ಕೋಲನ್ನು ನಿನ್ನ ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಅವನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ನೈಲ್ ನದಿ ತೀರದಲ್ಲಿ ನಿಂತುಕೊಂಡು ಅವನಿಗೆ ಹೀಗನ್ನಬೇಕು, ");
INSERT INTO kanirv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","‘ಇಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವನು ನನ್ನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ಕಳುಹಿಸಿ, ಅರಣ್ಯದಲ್ಲಿ ತನ್ನನ್ನು ಆರಾಧಿಸುವಂತೆ ತನ್ನ ಜನರಿಗೆ ಅಪ್ಪಣೆಕೊಡಬೇಕೆಂದು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಾನಷ್ಟೇ. ಈ ವರೆಗೂ ನೀನು ಅದನ್ನು ಲಕ್ಷ್ಯಕ್ಕೆ ತರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ಆದುದರಿಂದ ಯೆಹೋವನು ಹೇಳುವುದೇನೆಂದರೆ, ನೀನು ನನ್ನನ್ನು ಯೆಹೋವನೆಂದು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ನನ್ನ ಸೇವಕನ ಕೈಯಲ್ಲಿರುವ ಕೋಲಿನಿಂದ ನೈಲ್ ನದಿಯ ನೀರನ್ನು ಹೊಡೆಸುವೆನು. ಆಗ ಅದು ರಕ್ತವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ನದಿಯಲ್ಲಿರುವ ಮೀನುಗಳು ಸಾಯುವವು. ನದಿಯು ಹೊಲಸಾಗಿ ನಾರುವುದು. ಅದನ್ನು ಕುಡಿಯುವುದಕ್ಕೆ ಐಗುಪ್ತರಿಗೆ ಹೇಸಿಗೆಯಾಗುವುದು’ ಎಂದು ಹೇಳಬೇಕು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ನೀನು ಆರೋನನಿಗೆ ‘ನಿನ್ನ ಕೋಲನ್ನು ತೆಗೆದುಕೊಂಡು ಐಗುಪ್ತದೇಶದಲ್ಲಿರುವ ಹೊಳೆ, ಕಾಲುವೆ, ಕೆರೆ, ಕೊಳ ಮೊದಲಾದ ನೀರಿರುವ ಎಲ್ಲಾ ಸ್ಥಳಗಳ ಮೇಲೆ ಅದನ್ನು ಚಾಚು’ ಎಂದು ಹೇಳಬೇಕು. ಅವನು ಚಾಚುವಾಗ ಆ ನೀರೆಲ್ಲಾ ರಕ್ತವಾಗುವುದು. ಐಗುಪ್ತದೇಶದಲ್ಲೆಲ್ಲಾ ಮರದ ಪಾತ್ರೆಗಳಲ್ಲಿಯೂ, ಕಲ್ಲಿನ ಪಾತ್ರೆಗಳಲ್ಲಿಯೂ ಇರುವ ನೀರು ರಕ್ತವಾಗುವುದು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಯೆಹೋವನು ತಮಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡಿದರು. ಆರೋನನು ಫರೋಹನ ಮತ್ತು ಅವನ ಪರಿವಾರದ ಮುಂದೆ ಕೋಲನ್ನು ಎತ್ತಿ, ನೈಲ್ ನದಿಯಲ್ಲಿರುವ ನೀರನ್ನು ಹೊಡೆಯಲು ಅದೆಲ್ಲಾ ರಕ್ತವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ಅದರಲ್ಲಿದ್ದ ಮೀನುಗಳು ಸತ್ತುಹೋದವು. ನದಿಯು ದುರ್ವಾಸನೆಗೊಂಡಿದ್ದರಿಂದ ಐಗುಪ್ತರು ನೈಲ್ ನದಿಯ ನೀರನ್ನು ಕುಡಿಯಲಾರದೆ ಹೋದರು. ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ರಕ್ತವೇ ಕಾಣುತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ಆದರೆ ಐಗುಪ್ತ್ಯ ದೇಶದ ಮಾಂತ್ರಿಕರು ತಮ್ಮ ಮಂತ್ರವಿದ್ಯೆಗಳಿಂದ ಅದೇ ರೀತಿಯಾಗಿ ಮಾಡಿದ್ದರಿಂದ ಫರೋಹನ ಹೃದಯವು ಇನ್ನೂ ಕಠಿಣವಾಯಿತು. ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಅವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಮಾತನ್ನು ಕೇಳದೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ಫರೋಹನು ಆ ಮಹತ್ಕಾರ್ಯವನ್ನು ಲಕ್ಷ್ಯಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳದೆ ತನ್ನ ಮನೆಗೆ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ಐಗುಪ್ತ್ಯರೆಲ್ಲರೂ ನದಿಯ ನೀರನ್ನು ಕುಡಿಯಲಾರದೆ ಕುಡಿಯುವ ನೀರಿಗಾಗಿ ನದಿಯ ಸುತ್ತಲೂ ಗುಂಡಿಗಳನ್ನು ತೆಗೆದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ಯೆಹೋವನು ನೈಲ್ ನದಿಯನ್ನು ಹೊಡೆದ ಮೇಲೆ ಏಳು ದಿನಗಳು ತುಂಬಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ನಂತರ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಅವನಿಗೆ, “ನೀನು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಹೀಗೆ ಹೇಳಬೇಕು, ‘ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸುವುದೇನೆಂದರೆ: ನನ್ನನ್ನು ಆರಾಧಿಸುವುದಕ್ಕೆ ನನ್ನ ಜನರಿಗೆ ಅಪ್ಪಣೆಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ಅಪ್ಪಣೆಕೊಡದೆ ಹೋದರೆ, ನಾನು ನಿನ್ನ ದೇಶದಲ್ಲೆಲ್ಲಾ ಕಪ್ಪೆಗಳಿಂದ ಉಪದ್ರವ ಕೊಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ನೈಲ್ ನದಿಯಲ್ಲಿ ಕಪ್ಪೆಗಳು ಅಸಂಖ್ಯಾತವಾಗಿ ಹುಟ್ಟುವವು. ಅವು ಹೊರಟು ಬಂದು ನಿನ್ನ ಅರಮನೆಯಲ್ಲಿಯೂ, ಮಲಗುವ ಕೋಣೆಯಲ್ಲಿಯೂ, ಮಂಚದ ಮೇಲೆಯೂ ಬರುವುದಲ್ಲದೆ ನಿನ್ನ ಪರಿವಾರದವರ ಮನೆಗಳಲ್ಲಿಯೂ, ನಿನ್ನ ಪ್ರಜೆಗಳ ಮೇಲೆಯೂ, ಒಲೆಗಳಲ್ಲಿಯೂ, ಹಿಟ್ಟು ನಾದುವ ಪಾತ್ರೆಗಳಲ್ಲಿಯೂ ಬರುವವು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ನಿನ್ನ ಮೇಲೆಯೂ, ನಿನ್ನ ಪ್ರಜೆಗಳ ಮೇಲೆಯೂ ಮತ್ತು ಪರಿವಾರದವರ ಮೇಲೆಯೂ ಕಪ್ಪೆಗಳು ಹರಡಿಕೊಳ್ಳುವವು.’” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ಯೆಹೋವನು ಪುನಃ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ನೀನು ಆರೋನನಿಗೆ, ನಿನ್ನ ಕೋಲನ್ನು ಹಿಡಿದುಕೊಂಡು ಹೊಳೆ, ಕಾಲುವೆ, ಕೆರೆ ಇವುಗಳ ಮೇಲೆ ಅದನ್ನು ಹಿಡಿದುಕೊಂಡು ಕೈಯನ್ನು ಚಾಚು. ಆಗ ಐಗುಪ್ತ ದೇಶದ ಮೇಲೆಲ್ಲಾ ಕಪ್ಪೆಗಳು ಬರುವವು” ಎಂದು ಹೇಳಬೇಕು ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ಆರೋನನು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ನೀರಿರುವ ಎಲ್ಲಾ ಸ್ಥಳಗಳ ಮೇಲೆ ತನ್ನ ಕೈಚಾಚಲು ಕಪ್ಪೆಗಳು ಹೊರಟು ಬಂದು ದೇಶವನ್ನೆಲ್ಲಾ ತುಂಬಿಕೊಂಡವು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ಮಂತ್ರವಾದಿಗಳು ತಮ್ಮ ಮಂತ್ರವಿದ್ಯೆಗಳಿಂದ ಹಾಗೆಯೇ ಮಾಡಿ, ಐಗುಪ್ತ ದೇಶದ ಮೇಲೆ ಕಪ್ಪೆಗಳನ್ನು ಬರಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ಆಗ ಫರೋಹನು ಮೋಶೆ ಮತ್ತು ಆರೋನರನ್ನು ಕರೆಯಿಸಿ, “ನೀವು ಯೆಹೋವನನ್ನು ಬೇಡಿಕೊಂಡು ಈ ಕಪ್ಪೆಗಳನ್ನು ನನ್ನ ಬಳಿಯಿಂದಲೂ, ನನ್ನ ಪ್ರಜೆಗಳ ಬಳಿಯಿಂದಲೂ ತೊಲಗಿಸಬೇಕು, ಹಾಗೆ ಮಾಡಿದರೆ ನಿಮ್ಮ ಜನರು ಯೆಹೋವನಿಗೋಸ್ಕರ ಯಜ್ಞಮಾಡುವಂತೆ ಅವರಿಗೆ ನಾನು ಅಪ್ಪಣೆ ಕೊಡುವೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ಅದಕ್ಕೆ ಮೋಶೆ ಫರೋಹನಿಗೆ, “ಈ ಕಪ್ಪೆಗಳು ನಿನ್ನ ಬಳಿಯಿಂದಲೂ, ನಿನ್ನ ಪ್ರಜೆಗಳ ಬಳಿಯಿಂದಲೂ, ನಿನ್ನ ಮನೆಗಳಿಂದಲೂ ತೊಲಗಿ ನೈಲ್ ನದಿಯಲ್ಲಿ ಮಾತ್ರ ಉಳಿಯುವಂತೆ ನಿನಗೋಸ್ಕರವೂ, ನಿನ್ನ ಪರಿವಾರದವರಿಗೋಸ್ಕರವೂ ನಾನು ಯಾವಾಗ ಬೇಡಿಕೊಳ್ಳಲಿ? ನಿನ್ನ ಚಿತ್ತಕ್ಕೆ ಸರಿ ತೋರುವಂತೆ ನೀನೇ ಅದಕ್ಕೊಂದು ಕಾಲವನ್ನು ನೇಮಿಸಬೇಕು” ಎಂದು ಫರೋಹನನ್ನು ವಿನಂತಿಸಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ಫರೋಹನು ಮೋಶೆಗೆ, “ನಾಳೆ” ಎಂದನು. ಆಗ ಮೋಶೆಯು, “ನಿನ್ನ ಮಾತಿನ ಪ್ರಕಾರವೇ ಆಗಲಿ, ಇದರಿಂದ ನಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವನಿಗೆ ಸಮಾನರು ಬೇರೆ ಯಾರೂ ಇಲ್ಲವೆಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ಕಪ್ಪೆಗಳು ನಿನ್ನನ್ನೂ, ನಿನ್ನ ಮನೆಗಳನ್ನೂ, ನಿನ್ನ ಪ್ರಜಾಪರಿವಾರದವರನ್ನೂ ಬಿಟ್ಟು, ನೈಲ್ ನದಿಯಲ್ಲಿ ಮಾತ್ರ ಇರುವವು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಟು ಹೋದರು. ಆಗ ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, ನೀನು ಫರೋಹನ ಮೇಲೆ ಬರಮಾಡಿರುವ ಕಪ್ಪೆಗಳನ್ನು ತೊಲಗಿಸಬೇಕೆಂದು ಮೊರೆಯಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ಯೆಹೋವನು ಮೋಶೆಯ ಮಾತಿನ ಪ್ರಕಾರವೇ ಮಾಡಿದನು. ಮನೆಗಳಲ್ಲಿಯೂ, ಅಂಗಳಗಳಲ್ಲಿಯೂ, ಬಯಲಿನಲ್ಲಿಯೂ ಇದ್ದ ಕಪ್ಪೆಗಳು ಸತ್ತುಹೋದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ಜನರು ಅವುಗಳನ್ನು ರಾಶಿ ರಾಶಿಯಾಗಿ ಕೂಡಿಸಿದರು. ದೇಶವೆಲ್ಲಾ ದುರ್ವಾಸನೆಯಿಂದ ತುಂಬಿಹೋಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ಆದರೆ ಫರೋಹನು ಕಪ್ಪೆಗಳ ಕಾಟವು ತೀರಿತೆಂದು ತಿಳಿದುಕೊಂಡಾಗ, ತನ್ನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡಿಕೊಂಡನು. ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಅವನು, ಮೋಶೆ ಮತ್ತು ಆರೋನನ ಮಾತನ್ನು ಕೇಳದೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, “ನೀನು ಆರೋನನಿಗೆ, ‘ನಿನ್ನ ಕೋಲನ್ನು ಚಾಚಿ ಭೂಮಿಯ ಧೂಳನ್ನು ಹೊಡೆ, ಆಗ ಐಗುಪ್ತ ದೇಶದ ಭೂಮಿಯಲ್ಲಿದ್ದ ಧೂಳೆಲ್ಲಾ ಹೇನುಗಳಾಗುವುದು’” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ಅವರು ಹಾಗೆಯೇ ಮಾಡಿದರು. ಆರೋನನು ಕೋಲನ್ನು ಹಿಡಿದುಕೊಂಡು ಅದನ್ನು ಚಾಚಿ, ಭೂಮಿಯ ಧೂಳನ್ನು ಹೊಡೆದನು. ಆಗ ಮನುಷ್ಯರ ಮೇಲೆಯೂ, ಪಶುಗಳ ಮೇಲೆಯೂ ಹೇನುಗಳು ಬಂದವು. ಐಗುಪ್ತ ದೇಶದ ಭೂಮಿಯಲ್ಲಿದ್ದ ಧೂಳು ಹೇನುಗಳಾದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ಮಂತ್ರಗಾರರು ತಮ್ಮ ಮಂತ್ರವಿದ್ಯೆಗಳಿಂದ ಹಾಗೆಯೇ ಹೇನುಗಳನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕೆ ಪ್ರಯತ್ನಿಸಿದರೂ ಆಗದೆ ಹೋಯಿತು. ಆ ಹೇನುಗಳು ಮನುಷ್ಯರ ಮೇಲೆಯೂ ಪಶುಗಳ ಮೇಲೆಯೂ ಇದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ಆಗ ಆ ಮಂತ್ರಗಾರರು ಫರೋಹನಿಗೆ, “ಇದು ದೇವರ ಕೈಕೆಲಸವೇ ಸರಿ” ಎಂದು ಹೇಳಿದರು. ಆದರೂ ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಗಿತ್ತು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಮುಂತಿಳಿಸಿದಂತೆಯೇ ಫರೋಹನು ಅವರ ಮಾತನ್ನು ಕೇಳದೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಫರೋಹನ ಮುಂದೆ ನಿಂತುಕೋ. ಅವನು ಹೊರಗೆ ನದಿಯ ಬಳಿಗೆ ಬರುತ್ತಾನೆ. ನೀನು ಅವನಿಗೆ ಹೀಗೆಂದು ಹೇಳು, ‘ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸುವುದೇನೆಂದರೆ, ನನ್ನನ್ನು ಆರಾಧಿಸುವಂತೆ ನನ್ನ ಜನರಿಗೆ ಅಪ್ಪಣೆಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ಆದರೆ ನೀನು, ನನ್ನ ಜನರಿಗೆ ಅಪ್ಪಣೆಕೊಡದೇ ಹೋದರೆ, ನಾನು ನಿನಗೂ, ನಿನ್ನ ಪರಿವಾರದವರಿಗೂ, ನಿನ್ನ ಮನೆಗಳಿಗೂ ನೊಣಗಳ ಕಾಟವುಂಟಾಗುವಂತೆ ಮಾಡುವೆನು. ಐಗುಪ್ತ್ಯರ ಮನೆಗಳಲ್ಲಿಯೂ, ಅವರ ಎಲ್ಲಾ ಭೂಮಿಗಳಲ್ಲಿಯೂ ಆ ನೊಣಗಳು ತುಂಬಿಕೊಳ್ಳುವವು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ಆದರೆ ಆ ದಿನದಲ್ಲಿ ನಾನೇ, ಭೂಲೋಕದಲ್ಲಿ ಯೆಹೋವನೆಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವಂತೆ ನನ್ನ ಜನರು ವಾಸವಾಗಿರುವ ಗೋಷೆನ್ ಸೀಮೆಯನ್ನು ಪ್ರತ್ಯೇಕಿಸುವೆನು. ಅಲ್ಲಿ ಆ ನೊಣಗಳ ಕಾಟವು ಇರುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ಹೀಗೆ ನನ್ನ ಜನಕ್ಕೂ, ನಿನ್ನ ಜನಕ್ಕೂ ನಡುವೆ ವ್ಯತ್ಯಾಸವನ್ನುಂಟು ಮಾಡುವೆನು. ನಾಳೆಯೇ ಈ ಮಹತ್ಕಾರ್ಯ ಉಂಟಾಗುವುದು’ ಎಂದು ಹೇಳಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ಯೆಹೋವನು ಹಾಗೆಯೇ ಮಾಡಿದನು. ಬಾಧಿಸುವ ನೊಣಗಳು ಫರೋಹನ ಅರಮನೆಯಲ್ಲಿಯೂ, ಅವನ ಪರಿವಾರದವರ ಮನೆಗಳಲ್ಲಿಯೂ, ಸಮಸ್ತ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿಯೂ ವಿಪರೀತವಾಗಿ ತುಂಬಿಕೊಂಡವು. ಅವುಗಳಿಂದ ದೇಶವು ಹಾಳಾಗಿಹೋಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ಆಗ ಫರೋಹನು ಮೋಶೆ ಮತ್ತು ಆರೋನರನ್ನು ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನೀವು ಹೋಗಿ ಈ ದೇಶದಲ್ಲಿಯೇ ನಿಮ್ಮ ದೇವರಿಗೆ ಯಜ್ಞವನ್ನರ್ಪಿಸಿರಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ಆದರೆ ಮೋಶೆ, “ಹಾಗೆ ಮಾಡುವುದು ಸರಿಯಲ್ಲ, ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ನಾವು ಯಜ್ಞವನ್ನರ್ಪಿಸುವುದು ಐಗುಪ್ತ್ಯರಿಗೆ ಅಸಹ್ಯವಾಗಿದೆ. ಐಗುಪ್ತ್ಯರಿಗೆ ಅಸಹ್ಯವಾಗಿರುವುದನ್ನು ಅವರ ಕಣ್ಣೆದುರಿಗೆ ಯಜ್ಞ ಅರ್ಪಿಸಿದರೆ ಅವರು ನಮ್ಮನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲುವರಲ್ಲವೇ? ");
INSERT INTO kanirv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ನಾವು ಅರಣ್ಯದಲ್ಲಿ ಮೂರು ದಿನಗಳ ಪ್ರಯಾಣ ಮಾಡಿ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸುವ ಪ್ರಕಾರ ಯಜ್ಞಮಾಡಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ಅದಕ್ಕೆ ಫರೋಹನು ಅವರಿಗೆ, “ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಅರಣ್ಯದಲ್ಲಿ ಯಜ್ಞಮಾಡುವಂತೆ ನಾನು ನಿಮಗೆ ಅಪ್ಪಣೆ ಕೊಡುತ್ತೇನೆ. ಆದರೆ ಬಹಳ ದೂರ ಹೋಗಬಾರದು. ನನಗೋಸ್ಕರ ಪ್ರಾರ್ಥನೆ ಮಾಡಿರಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ಅದಕ್ಕೆ ಮೋಶೆಯು, “ನಾನು ನಿನ್ನ ಬಳಿಯಿಂದ ಹೊರಟು ಹೋದ ಕೂಡಲೇ, ಫರೋಹನಾದ ನಿನಗೂ, ನಿನ್ನ ಪರಿವಾರದವರಿಗೂ ನೊಣಗಳ ಬಾಧೆಯು ನಾಳೆಯಿಂದ ಇರಬಾರದೆಂಬುದಾಗಿ ನಾನು ಯೆಹೋವನನ್ನು ಬೇಡಿಕೊಳ್ಳುವೆನು. ಆದರೆ ಯೆಹೋವನಿಗೆ ಯಜ್ಞವನ್ನರ್ಪಿಸುವುದಕ್ಕೆ ನೀನು ನನ್ನ ಜನರಿಗೆ ಅಪ್ಪಣೆಕೊಡದೆ ಇನ್ನು ಮುಂದೆ ವಂಚನೆಮಾಡಬಾರದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ಮೋಶೆ ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಟು ಹೋಗಿ ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥನೆಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ಮೋಶೆಯು ಪ್ರಾರ್ಥಿಸಿದಂತೆಯೇ ಯೆಹೋವನು ಮಾಡಿದನು. ಆ ನೊಣಗಳೆಲ್ಲಾ ಫರೋಹನ ಬಳಿಯಿಂದಲೂ, ಅವನ ಪ್ರಜಾಪರಿವಾರದವರ ಬಳಿಯಿಂದಲೂ ತೊಲಗಿಹೋದವು. ಒಂದೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ಆದರೂ ಫರೋಹನು ತನ್ನ ಹೃದಯವನ್ನು ಕಠಿಣಮಾಡಿಕೊಂಡು ಜನರಿಗೆ ಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆ ಕೊಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು, ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ, ‘ಇಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವನು ತನ್ನನ್ನು ಆರಾಧಿಸುವಂತೆ ತನ್ನ ಜನರಿಗೆ ಅಪ್ಪಣೆಕೊಡಬೇಕೆಂಬುದಾಗಿ ಹೇಳಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ನೀನು ಅವರಿಗೆ ಅಪ್ಪಣೆ ಕೊಡದೆ ಇನ್ನೂ ಅವರನ್ನು ತಡೆದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ಯೆಹೋವನು ಅಡವಿಯಲ್ಲಿರುವ ನಿನ್ನ ಎಲ್ಲಾ ಪಶುಗಳಿಗೂ, ಕುದುರೆ, ಕತ್ತೆ, ಒಂಟೆ, ದನ, ಕುರಿ, ಆಡು ಇವೆಲ್ಲವುಗಳಿಗೂ ವಿರೋಧವಾಗಿ ತನ್ನ ಕೈಯನ್ನು ಎತ್ತಿ ಘೋರವ್ಯಾಧಿಯನ್ನು ಉಂಟುಮಾಡುವನೆಂದು ತಿಳಿದುಕೋ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರ ಪಶುಗಳಿಗೂ, ಐಗುಪ್ತರ ಪಶುಗಳಿಗೂ ವ್ಯತ್ಯಾಸವನ್ನುಂಟು ಮಾಡುವನು. ಇಸ್ರಾಯೇಲರಿಗಿರುವ ಪಶುಗಳಲ್ಲಿ ಒಂದೂ ಸಾಯುವುದಿಲ್ಲ’ ಎಂದು ಹೇಳಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ಇದಲ್ಲದೆ ಯೆಹೋವನು, “ನಿರ್ದಿಷ್ಟವಾದ ಸಮಯವನ್ನು ನೇಮಿಸಿ, ನಾಳೆಯೇ ಈ ಕಾರ್ಯವನ್ನು ಈ ದೇಶದಲ್ಲಿ ಮಾಡುವನು ಎಂದು ಹೇಳು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ಮರುದಿನ ಯೆಹೋವನು ಆ ಕಾರ್ಯವುಂಟಾಗುವಂತೆ ಮಾಡಿದನು. ಐಗುಪ್ತ್ಯರ ಪಶುಗಳೆಲ್ಲಾ ಸತ್ತುಹೋದವು. ಇಸ್ರಾಯೇಲರ ಪಶುಗಳಲ್ಲಿ ಒಂದೂ ಸಾಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ಫರೋಹನು ವಿಚಾರಿಸಿದಾಗ, ಇಸ್ರಾಯೇಲ್ಯರ ಪಶುಗಳಲ್ಲಿ ಒಂದೂ ಸಾಯಲಿಲ್ಲವೆಂಬುದನ್ನು ತಿಳಿದುಕೊಂಡನು. ಆದರೂ ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಗಿದ್ದರಿಂದ ಆ ಜನರಿಗೆ ಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆಕೊಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ, “ನೀವು ಒಲೆಯ ಬೂದಿಯನ್ನು ಕೈತುಂಬಾ ತೆಗೆದುಕೊಳ್ಳಿರಿ. ಮೋಶೆ ಅದನ್ನು ಫರೋಹನ ಕಣ್ಣುಗಳ ಮುಂದೆ ಆಕಾಶದ ಕಡೆಗೆ ತೂರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ಆಗ ಅದು ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಧೂಳಿನ ಕಣಗಳಾಗಿ ಮಾರ್ಪಟ್ಟು ಅದು ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಮನುಷ್ಯರ ಮೇಲೆಯೂ ಪಶುಗಳ ಮೇಲೆಯೂ ಹುಣ್ಣುಗಳಾಗುವ ಬೊಕ್ಕೆಗಳು ಏಳುವಂತೆ ಮಾಡುವವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ಅದರಂತೆ ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಒಲೆಯ ಬೂದಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಫರೋಹನ ಮುಂದೆ ನಿಂತರು. ಮೋಶೆಯು ಆ ಬೂದಿಯನ್ನು ಆಕಾಶದ ಕಡೆಗೆ ತೂರಿದನು. ಆಗ ಅದು ಮನುಷ್ಯರ ಮೇಲೆಯೂ, ಪಶುಗಳ ಮೇಲೆಯೂ ಹರಡಿ ಹುಣ್ಣುಗಳಾಗುವಂತೆ ಬೊಕ್ಕೆಗಳನ್ನೆಬ್ಬಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ಇದಲ್ಲದೆ ಮಂತ್ರಗಾರರು, ಹುಣ್ಣುಗಳ ದೆಸೆಯಿಂದ ಮೋಶೆಯ ಮುಂದೆ ನಿಲ್ಲಲಾರದೆ ಹೋದರು. ಏಕೆಂದರೆ ಹುಣ್ಣುಗಳು ಮಂತ್ರಗಾರರ ಮೇಲೆಯೂ, ಐಗುಪ್ತ್ಯರ ಮೇಲೆಯೂ ಎದ್ದಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ಆದರೂ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದಂತೆಯೇ ಆಯಿತು. ಯೆಹೋವನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಮಾಡಿದ್ದರಿಂದ ಅವನು ಅವರ ಮಾತಿಗೆ ಕಿವಿಗೊಡದೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಫರೋಹನ ಮುಂದೆ ನಿಂತುಕೊಂಡು ಅವನಿಗೆ, ‘ಇಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸುವುದೇನೆಂದರೆ, ನನ್ನನ್ನು ಆರಾಧಿಸುವಂತೆ ನನ್ನ ಜನರಿಗೆ ಅಪ್ಪಣೆಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ಈ ಸಾರಿ ನಾನು ನನ್ನ ವಶದಲ್ಲಿರುವ ಈ ಬಾಧೆಗಳನ್ನು ನಿನ್ನ ಪ್ರಜಾಪರಿವಾರದವರಿಗೆ ಉಂಟಾಗುವಂತೆಯೂ, ನಿನ್ನ ಹೃದಯಕ್ಕೂ ತಗಲುವಂತೆಯೂ ಮಾಡುವೆನು. ಆದುದರಿಂದ ಸಮಸ್ತ ಲೋಕದಲ್ಲಿ ನನಗೆ ಸಮಾನರು ಬೇರೆ ಯಾರೂ ಇಲ್ಲವೆಂದು ನನ್ನ ವಿಷಯದಲ್ಲಿ ತಿಳಿದುಕೊಳ್ಳುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ನಾನು ಕೈಯನ್ನೆತ್ತಿ ನಿನ್ನನ್ನೂ, ನಿನ್ನ ಪ್ರಜೆಗಳನ್ನೂ, ವ್ಯಾಧಿಯಿಂದ ಬಾಧಿಸುವೆನು. ನಿನ್ನನ್ನು ಭೂಮಿಯೊಳಗಿಂದ ನಿರ್ಮೂಲ ಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ಆದರೆ ನಾನು ನಿನ್ನಲ್ಲಿ ನನ್ನ ಶಕ್ತಿಯನ್ನು ತೋರಿಸಿ, ನನ್ನ ಹೆಸರನ್ನು ಲೋಕದಲ್ಲೆಲ್ಲಾ ಪ್ರಸಿದ್ಧಿಪಡಿಸಬೇಕೆಂಬ ಉದ್ದೇಶದಿಂದಲೇ ನಿನ್ನನ್ನು ಸಾಯಿಸದೇ ಉಳಿಸಿರುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ನೀನು ನನ್ನ ಜನರನ್ನು ಇನ್ನೂ ಹೋಗಗೊಡಿಸದೆ ಅವರ ಮುಂದೆ, ಅಡ್ಡಿ ಆತಂಕಗಳನ್ನು ಒಡ್ಡುತ್ತಿರುವೆಯಾ? ");
INSERT INTO kanirv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ಹಾಗಾದರೆ, ನಾಳೆ ಇಷ್ಟು ಹೊತ್ತಿಗೆ ವಿಪರೀತವಾದ ಆನೆಕಲ್ಲಿನ ಮಳೆ ಬೀಳುವಂತೆ ಮಾಡುವೆನು. ಐಗುಪ್ತ ರಾಜ್ಯವು ಸ್ಥಾಪಿತವಾದ ದಿನ ಮೊದಲುಗೊಂಡು ಇಂದಿನವರೆಗೂ ಅಂಥ ಕಲ್ಲಿನ ಮಳೆ ಬಿದ್ದಿರುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ಆದಕಾರಣ ನೀನು ಆಳುಗಳನ್ನು ಕಳುಹಿಸಿ ನಿನ್ನ ಪಶುಗಳನ್ನೂ, ನಿನಗೆ ಹೊಲದಲ್ಲಿರುವುದೆಲ್ಲವನ್ನೂ ಬೇಗ ಭದ್ರಪಡಿಸು. ಮನೆಯೊಳಗೆ ಬಾರದೆ ಬಯಲಿನಲ್ಲೇ ಇರುವ ಎಲ್ಲಾ ಮನುಷ್ಯರೂ, ಪಶುಗಳೂ ಆ ಕಲ್ಲಿನ ಮಳೆಯ ಹೊಡೆತದಿಂದ ಸಾಯುವರು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ಆಗ ಫರೋಹನ ಸೇವಕರಲ್ಲಿ ಯಾರಾರು ಯೆಹೋವನ ಮಾತಿಗೆ ಹೆದರಿದರೋ ಅವರು ತಮ್ಮ ಆಳುಗಳನ್ನೂ ಪಶುಗಳನ್ನೂ ಬೇಗ ಮನೆಗೆ ಬರಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ಯಾರು ಯೆಹೋವನ ಮಾತನ್ನು ಮನಸ್ಸಿಗೆ ತೆಗೆದುಕೊಳ್ಳಲಿಲ್ಲವೋ, ಅವರು ತಮ್ಮ ಆಳುಗಳನ್ನೂ, ಪಶುಗಳನ್ನೂ ಹೊಲದಲ್ಲಿಯೇ ಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಆಕಾಶಕ್ಕೆ ನಿನ್ನ ಕೈಚಾಚು, ಆಗ ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಮನುಷ್ಯರ ಮೇಲೆಯೂ, ಪಶುಗಳ ಮೇಲೆಯೂ, ಹೊಲದಲ್ಲಿರುವ ಎಲ್ಲಾ ಪೈರುಗಳ ಮೇಲೆಯೂ ಆನೆಕಲ್ಲಿನ ಮಳೆ ಬೀಳುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ಮೋಶೆಯು ತನ್ನ ಕೋಲನ್ನು ಆಕಾಶದ ಕಡೆಗೆ ಚಾಚಿದಾಗ ಯೆಹೋವನು ಗುಡುಗನ್ನು, ಆನೆಕಲ್ಲಿನ ಮಳೆಯನ್ನು ಕಳುಹಿಸಿದನು. ಸಿಡಿಲುಗಳು ನೆಲಕ್ಕೆ ಅಪ್ಪಳಿಸಿದವು. ಯೆಹೋವನು ಐಗುಪ್ತ ದೇಶದ ಮೇಲೆ ಆನೆಕಲ್ಲಿನ ಮಳೆಯನ್ನು ಸುರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ಆನೆಕಲ್ಲಿನ ಮಳೆಯು ಬಹು ರಭಸವಾಗಿತ್ತು. ಅದರೊಂದಿಗೆ ಮಿಂಚು ಫಳಫಳನೆ ಹೊಳೆಯುತಿತ್ತು. ಐಗುಪ್ತ್ಯದವರು ಒಂದು ರಾಷ್ಟ್ರವಾದಂದಿನಿಂದ ಆ ದೇಶದಲ್ಲಿ ಅಂಥ ಘೋರವಾದ ಆನೆಕಲ್ಲಿನ ಮಳೆ ಆಗಿರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ಆ ಮಳೆಯಿಂದ ಐಗುಪ್ತ ದೇಶದ ಎಲ್ಲಾ ಕಡೆಗಳಲ್ಲಿದ್ದ ಮನುಷ್ಯರು, ಪಶುಗಳು, ಬಯಲಿನಲ್ಲಿದ್ದ ಎಲ್ಲವೂ ನಾಶವಾದವು. ಆನೆಕಲ್ಲಿನ ಮಳೆಯಿಂದ ಹೊಲಗಳಲ್ಲಿದ್ದ ಪೈರುಗಳು ಹಾಳಾದವು. ಹೊಲಗಳಲ್ಲಿದ್ದ ಮರಗಳು ಮುರಿದುಹೋದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ಇಸ್ರಾಯೇಲರು ವಾಸವಾಗಿದ್ದ ಗೋಷೆನ್ ಸೀಮೆಯಲ್ಲಿ ಮಾತ್ರ ಆನೆಕಲ್ಲಿನ ಮಳೆ ಬೀಳಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ಆಗ ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನಾನು ಅಪರಾಧಿಯೆಂದು ಈಗ ಒಪ್ಪಿಕೊಳ್ಳುತ್ತೇನೆ. ಯೆಹೋವನು ನ್ಯಾಯವಂತನು. ನಾನೂ ನನ್ನ ಜನರೂ ದೋಷಿಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ಈ ಭಯಂಕರವಾದ ಗುಡುಗು ಮತ್ತು ಆನೆಕಲ್ಲಿನ ಮಳೆಯೂ ಬಹಳ ಹೆಚ್ಚಾದವು. ಇವುಗಳನ್ನು ನಿಲ್ಲಿಸುವುದಕ್ಕೆ ಯೆಹೋವನನ್ನು ಪ್ರಾರ್ಥಿಸಿರಿ. ಈ ದೇಶವನ್ನು ಬಿಟ್ಟು ಹೊರಡುವುದಕ್ಕೆ ನಿಮಗೆ ಅಪ್ಪಣೆ ಕೊಡುತ್ತೇನೆ. ಇನ್ನು ನಿಮ್ಮನ್ನು ತಡೆಯುವುದಿಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ಅದಕ್ಕೆ ಮೋಶೆ, “ನಾನು ಈ ಪಟ್ಟಣದಿಂದಾಚೆಗೆ ಹೋದ ಕೂಡಲೇ ಕೈಯೆತ್ತಿ ಯೆಹೋವನನ್ನು ಪ್ರಾರ್ಥಿಸುವೆನು. ಆಗ ಗುಡುಗು ಮತ್ತು ಆನೆಕಲ್ಲಿನ ಮಳೆಯು ನಿಂತುಹೋಗುವದು. ಇದರಿಂದ ಸಮಸ್ತ ಭೂಲೋಕವು ಯೆಹೋವನ ಅಧೀನದಲ್ಲಿದೆ ಎಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ಆದರೂ ನೀನಾಗಲಿ, ನಿನ್ನ ಪರಿವಾರದವರಾಗಲಿ, ದೇವರಾಗಿರುವ ಯೆಹೋವನಿಗೆ ಆಗಲೂ ಭಯಪಡುವುದಿಲ್ಲವೆಂದು ಬಲ್ಲೆನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ಜವೆಗೋದಿ ಮತ್ತು ಅಗಸೆ ಬೆಳೆಗಳು ನಾಶವಾದವು. ಏಕೆಂದರೆ ಜವೆಗೋದಿ ತೆನೆ ಬಿಟ್ಟಿತ್ತು, ಅಗಸೆ ಮೊಗ್ಗು ಬಿಟ್ಟಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ಆದರೆ ಗೋದಿ ಮತ್ತು ಕಡಲೆ ಹಿಂದಿನ ಬೆಳೆಗಳಾಗಿದ್ದುದರಿಂದ ಅವುಗಳಿಗೆ ಹಾನಿಯಾಗಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ಮೋಶೆಯು ಫರೋಹನನ್ನು ಬಿಟ್ಟು ಪಟ್ಟಣದಿಂದ ಹೊರಕ್ಕೆ ಬಂದು ಕೈಯನ್ನೆತ್ತಿ ಯೆಹೋವನನ್ನು ಪ್ರಾರ್ಥಿಸಿದನು. ಗುಡುಗೂ, ಆನೆಕಲ್ಲಿನ ಮಳೆಯೂ ನಿಂತುಹೋದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ಆದರೆ ಆನೆಕಲ್ಲು ಮಳೆ, ಗುಡುಗು ನಿಂತುಹೋದದ್ದನ್ನು ಫರೋಹನು ಕಂಡಾಗ ಅವನೂ, ಅವನ ಪರಿವಾರದವರೂ ತಮ್ಮ ಹೃದಯಗಳನ್ನು ಕಠಿಣಮಾಡಿಕೊಂಡು ಇನ್ನೂ ಪಾಪ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ಯೆಹೋವನು ಮೋಶೆಯಿಂದ ಹೇಳಿಸಿದಂತೆಯೇ ಆಯಿತು. ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಗಿತ್ತು. ಅವನು ಇಸ್ರಾಯೇಲರನ್ನು ಹೋಗಲು ಬಿಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಫರೋಹನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಹೋಗು. ನಾನು ಫರೋಹನ ಮತ್ತು ಅವನ ಪರಿವಾರದವರ ಹೃದಯಗಳನ್ನು ಕಠಿಣಗೊಳಿಸಿದ್ದೇನೆ. ಏಕೆಂದರೆ ನಾನು ಈ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ಅವರ ಮುಂದೆ ನಡೆಸುವುದಕ್ಕೆ ಇದು ಕಾರಣವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಮಕ್ಕಳಿಗೂ, ಮೊಮ್ಮಕ್ಕಳಿಗೂ ನಾನು ಐಗುಪ್ತ್ಯರ ನಡುವೆ ನಡೆಸಿರುವ ಈ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ವಿವರಿಸಿ ಯೆಹೋವನು ಐಗುಪ್ತ್ಯರನ್ನು ತನಗೆ ಇಷ್ಟಬಂದ ಹಾಗೆ ಶಿಕ್ಷಿಸಿದನು ಎಂಬುದಾಗಿ ತಿಳಿಸಬೇಕು. ಹೀಗೆ ನಾನು ಫರೋಹನ ಹೃದಯವನ್ನು, ಅವನ ಪರಿವಾರದವರ ಹೃದಯಗಳನ್ನೂ ಕಠಿಣಮಾಡಿದ್ದೇನೆ. ಇದಲ್ಲದೆ ಈ ಮಹತ್ಕಾರ್ಯಗಳಿಂದ ನೀವು ನನ್ನನ್ನೇ ಯೆಹೋವನೆಂದು ತಿಳಿದುಕೊಳ್ಳುವಿರಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ, “ಇಬ್ರಿಯರ ದೇವರಾಗಿರುವ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸುವುದೇನೆಂದರೆ, ‘ನೀನು ನನ್ನ ಮುಂದೆ ತಗ್ಗಿಸಿಕೊಳ್ಳದೆ ಇರುವುದು ಇನ್ನು ಎಲ್ಲಿಯವರೆಗೆ? ನನ್ನನ್ನು ಆರಾಧಿಸುವಂತೆ ನನ್ನ ಜನರಿಗೆ ಅಪ್ಪಣೆ ಕೊಡು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ಅಪ್ಪಣೆಕೊಡದೆ ಹೋದರೆ ನಾಳೆ ನಿನ್ನ ರಾಜ್ಯದೊಳಗೆ ಮಿಡತೆಗಳನ್ನು ಬರುವಂತೆ ಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ಅವು ಭೂಮಿಯನ್ನೆಲ್ಲಾ ಆವರಿಸಿಕೊಳ್ಳುವವು. ನೆಲವೇ ಕಾಣಿಸದೆ ಹೋಗುವುದು. ಆನೆಕಲ್ಲಿನ ಮಳೆಯಿಂದ ನಾಶವಾಗದೆ ಉಳಿದಿದ್ದೆಲ್ಲವನ್ನು ಮಿಡತೆಗಳು ತಿಂದುಬಿಡುವವು. ಹೊಲದಲ್ಲಿರುವ ನಿಮ್ಮ ಎಲ್ಲಾ ಮರಗಳ ಎಲೆ ಚಿಗುರುಗಳನ್ನೂ ತಿಂದುಬಿಡುವವು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ಅವು ನಿನ್ನ ಮನೆಗಳಲ್ಲಿಯೂ, ನಿನ್ನ ಪರಿವಾರದವರ ಮನೆಗಳಲ್ಲಿಯೂ, ಐಗುಪ್ತ್ಯರೆಲ್ಲರ ಮನೆಗಳಲ್ಲಿಯೂ ತುಂಬಿಕೊಂಡಿರುವವು. ನಿಮ್ಮ ಪೂರ್ವಿಕರ ಕಾಲದಿಂದ ಇಂದಿನವರೆಗೂ ಅಂಥ ಮಿಡತೆಯ ದಂಡನ್ನು ಎಂದೂ ಅವರು ನೋಡಿರುವುದಿಲ್ಲ’” ಎಂದು ಹೇಳಿದರು. ಇದನ್ನು ಹೇಳಿ ಮೋಶೆ ತಿರುಗಿಕೊಂಡು ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ಆಗ ಫರೋಹನ ಪರಿವಾರದವರು ಅವನಿಗೆ, “ಈ ಮನುಷ್ಯನು ಇನ್ನು ಎಷ್ಟು ದಿನ ನಮಗೆ ಉರುಲಾಗಿರಬೇಕು. ಆ ಜನರು ಹೋಗಿ ತಮ್ಮ ದೇವರಾದ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸುವುದಕ್ಕೆ ಅಪ್ಪಣೆಕೊಡು. ಐಗುಪ್ತ ದೇಶವು ಹಾಳಾಯಿತೆಂದು ಇನ್ನು ನಿನ್ನ ಮನಸ್ಸಿಗೆ ಬರಲಿಲ್ಲವೋ?” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ಅದನ್ನು ಕೇಳಿ ಫರೋಹನು, ಮೋಶೆ ಮತ್ತು ಆರೋನರನ್ನು ತಿರುಗಿ ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನೀವು ಹೋಗಿ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಬಹುದು. ಆದರೆ ಯಾರಾರು ಹೋಗಬೇಕನ್ನುತ್ತೀರಿ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ಮೋಶೆ ಅವನಿಗೆ, “ನಾವು ಯೆಹೋವನಿಗೆ ಜಾತ್ರೆಯನ್ನು ಆಚರಿಸಬೇಕಾಗಿದೆ. ಆದಕಾರಣ ಚಿಕ್ಕವರು ಮೊದಲುಗೊಂಡು, ಮುದುಕರವರೆಗೂ ಎಲ್ಲರೂ ಹೋಗುತ್ತೇವೆ; ಗಂಡು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನೂ, ದನಕುರಿಗಳ ಮಂದೆಯನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗುತ್ತೇವೆ” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ಅದಕ್ಕೆ ಫರೋಹನು, “ನಾನು ನಿಮ್ಮನ್ನು ಮತ್ತು ನಿಮ್ಮ ಮಕ್ಕಳನ್ನು ಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆ ಕೊಡುವುದಿಲ್ಲ; ಕಳುಹಿಸಿಕೊಟ್ಟರೆ, ಯೆಹೋವನು ನಿಮ್ಮ ಸಂಗಡವಿರುವನು. ನೋಡಿ, ನೀವು ದುರಾಲೋಚನೆಯಿಂದ ಕೂಡಿದವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ನಿಮ್ಮಲ್ಲಿ ಗಂಡಸರು ಮಾತ್ರ ಹೋಗಿ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿ ಬರಬಹುದು. ನೀವು ಕೇಳಿಕೊಂಡದ್ದು ಅಷ್ಟೇ ಅಲ್ಲವೇ” ಎಂದು ಹೇಳಿ ಅವರನ್ನು ಫರೋಹನು ತನ್ನ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಡಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಐಗುಪ್ತ ದೇಶದ ಮೇಲೆ ನಿನ್ನ ಕೈಯನ್ನು ಚಾಚಿ, ಮಿಡತೆಗಳನ್ನು ಬರಮಾಡು. ಆನೆಕಲ್ಲಿನ ಮಳೆಯಿಂದ ನಾಶವಾಗದೆ ಉಳಿದಿರುವ ಪೈರುಗಳನ್ನೆಲ್ಲಾ ಮಿಡತೆಗಳು ತಿಂದುಬಿಡಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ಮೋಶೆ ತನ್ನ ಕೋಲನ್ನು ಐಗುಪ್ತ ದೇಶದ ಮೇಲೆ ಚಾಚಿದಾಗ, ಯೆಹೋವನು ಹಗಲಿರುಳು ಮೂಡಣದಿಕ್ಕಿನಿಂದ ಗಾಳಿಯನ್ನು ಬೀಸುವಂತೆ ಮಾಡಿದನು. ಹೊತ್ತಾರೆ ಗಾಳಿಯ ದೆಸೆಯಿಂದ ಮಿಡತೆಗಳು ಬಂದಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ಮಿಡತೆಗಳು ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಬಂದಿಳಿದು ಐಗುಪ್ತ ದೇಶದ ಎಲ್ಲಾ ಕಡೆಯಲ್ಲಿಯೂ ಅಪರಿಮಿತವಾಗಿ ಮುತ್ತಿಕೊಂಡವು. ಅಂಥ ಮಿಡತೆಯ ದಂಡು ಹಿಂದೆಂದೂ ಬಂದಿರಲಿಲ್ಲ, ಮುಂದೆಯೂ ಬರಲು ಸಾಧ್ಯವಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ಅವು ಭೂಮಿಯನ್ನೆಲ್ಲಾ ಮುಚ್ಚಿಕೊಂಡಿದ್ದರಿಂದ ನೆಲವು ಕಾಣದೇ ಹೋಯಿತು. ಆನೆಕಲ್ಲಿನ ಮಳೆಯಿಂದ ನಾಶವಾಗದೆ ಉಳಿದಿದ್ದ ಎಲ್ಲಾ ಪೈರುಗಳನ್ನೂ, ಮರಗಳಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಕಾಯಿಗಳನ್ನೂ ಅವು ತಿಂದುಬಿಟ್ಟವು. ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಮರಗಳಲ್ಲಾಗಲಿ, ಹೊಲದ ಗಿಡಗಳಲ್ಲಾಗಲಿ ಹಸುರಾದದ್ದು ಒಂದೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ಆಗ ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ತ್ವರೆಯಾಗಿ ಕರೆಯಿಸಿ, “ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೂ, ನಿಮಗೂ ವಿರುದ್ಧವಾಗಿ ಪಾಪಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ಆದರೂ ಈ ಒಂದೇ ಸಾರಿ ನನ್ನ ಪಾಪಗಳನ್ನು ಕ್ಷಮಿಸಬೇಕು. ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಈ ಮರಣಕರವಾದ ವಿಪತ್ತನ್ನು ನನ್ನ ಬಳಿಯಿಂದ ತೊಲಗಿಸುವಂತೆ ಆತನನ್ನು ಪ್ರಾರ್ಥಿಸಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ಮೋಶೆ ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಟು ಯೆಹೋವನನ್ನು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ಯೆಹೋವನು ಪಶ್ಚಿಮದಿಂದ ಬಿರುಗಾಳಿ ಬೀಸುವಂತೆ ಮಾಡಿದನು. ಅದು ಆ ಮಿಡತೆಗಳನ್ನು ಎತ್ತಿಕೊಂಡು ಹೋಗಿ ಕೆಂಪುಸಮುದ್ರದೊಳಗೆ ಹಾಕಿಬಿಟ್ಟಿತು. ಐಗುಪ್ತ ದೇಶದ ಮೇರೆಗಳೊಳಗೆ ಒಂದು ಮಿಡತೆಯೂ ನಿಲ್ಲಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ಆದರೆ ಯೆಹೋವನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಮಾಡಿದ್ದರಿಂದ ಅವನು ಇಸ್ರಾಯೇಲರನ್ನು ಕಳುಹಿಸಿಕೊಡಲು ಒಪ್ಪಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಆಕಾಶಕ್ಕೆ ನಿನ್ನ ಕೈಯನ್ನು ಚಾಚು. ಆಗ ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಕತ್ತಲು ಉಂಟಾಗುವುದು. ಆ ಕತ್ತಲೆಯಿಂದಾಗಿ ಜನರು ತಡವರಿಸುತ್ತಾ ನಡೆಯುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ಮೋಶೆ ಆಕಾಶಕ್ಕೆ ಕೈಯನ್ನು ಚಾಚಿದಾಗ ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ಮೂರು ದಿನ ಕಾರ್ಗತ್ತಲೆ ಮುಚ್ಚಿಕೊಂಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ಮೂರು ದಿನಗಳವರೆಗೆ ಅವರು ಒಬ್ಬರನ್ನೊಬ್ಬರು ನೋಡಲಿಲ್ಲ. ಯಾರೂ ತಮ್ಮ ಸ್ಥಳದಿಂದ ಏಳಲೂ ಇಲ್ಲ. ಆದರೆ ಇಸ್ರಾಯೇಲರು ವಾಸವಾಗಿದ್ದ ಸ್ಥಳಗಳಲ್ಲಿ ಬೆಳಕು ಇತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ಆಗ ಫರೋಹನು ಮೋಶೆಯನ್ನು ಕರೆಯಿಸಿ ಅವನಿಗೆ, “ನೀವು ಹೋಗಿ ಯೆಹೋವನಿಗೆ ಆರಾಧನೆ ಮಾಡಿ ಬರಬಹುದು. ನಿಮ್ಮ ಮನೆಗಳಿಗೆ ಸೇರಿದವರೂ ಹೋಗಬಹುದು. ನಿಮ್ಮ ಕುರಿದನಗಳನ್ನು ಮಾತ್ರ ಇಲ್ಲೇ ಬಿಟ್ಟುಹೋಗಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ಅದಕ್ಕೆ ಮೋಶೆಯು, “ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ನಾವು ಯಜ್ಞಹೋಮಗಳನ್ನು ಮಾಡುವಂತೆ ಬೇಕಾದ ಪಶುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಲು ಅಪ್ಪಣೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ನಮ್ಮ ಎಲ್ಲಾ ಪಶುಗಳನ್ನೂ ಸಹ ನಮ್ಮ ಸಂಗಡ ತೆಗೆದುಕೊಂಡು ಹೋಗುವೆವು. ಒಂದು ಗೊರಸನ್ನಾದರೂ ನಾವು ಬಿಟ್ಟು ಹೋಗುವುದಿಲ್ಲ. ಆ ಪಶುಗಳಿಂದಲೇ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಆರಾಧನೆಯನ್ನು ಸಲ್ಲಿಸಬೇಕು. ಯಾವ ಪಶುಗಳನ್ನು ಅರ್ಪಿಸಬೇಕೆಂಬುದು ನಾವು ಅಲ್ಲಿಗೆ ಸೇರುವುದಕ್ಕೆ ಮೊದಲು ನಮಗೆ ತಿಳಿಯದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ಆದರೆ ಯೆಹೋವನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣ ಮಾಡಿದ್ದರಿಂದ ಅವನು ಅವರನ್ನು ಕಳುಹಿಸಲಾರದೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ಆಗ ಫರೋಹನು ಮೋಶೆಗೆ, “ನನ್ನನ್ನು ಬಿಟ್ಟುಹೋಗು. ಇನ್ನು ಮುಂದೆ ನನ್ನ ಮುಖವನ್ನು ನೋಡದಂತೆ ಎಚ್ಚರಿಕೆಯಾಗಿರು. ಏಕೆಂದರೆ ನೀನು ನನ್ನ ಮುಖವನ್ನು ನೋಡಿದ ದಿನದಲ್ಲಿ ನೀನು ಸಾಯುವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ಅದಕ್ಕೆ ಮೋಶೆಯು, “ನೀನು ಸರಿಯಾಗಿ ಹೇಳಿದೆ. ಇನ್ನು ಮೇಲೆ ನಾನು ನಿನ್ನ ಮುಖವನ್ನು ಪುನಃ ನೋಡುವುದಿಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಫರೋಹನಿಗೂ ಮತ್ತು ಐಗುಪ್ತ್ಯರಿಗೂ ಇನ್ನೊಂದು ಉಪದ್ರವವನ್ನು ಬರಮಾಡುತ್ತೇನೆ. ಅದು ಬಂದನಂತರ ಅವನು ನಿಮಗೆ ಇಲ್ಲಿಂದ ಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆ ಕೊಡುವನು. ಮಾತ್ರವಲ್ಲದೆ ನಿಮ್ಮೆಲ್ಲರನ್ನು ಬಲವಂತದಿಂದ ಕಳುಹಿಸಿ ಬಿಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ಆದುದರಿಂದ ಸ್ತ್ರೀಪುರುಷರೆಲ್ಲರೂ ತಮ್ಮ ತಮ್ಮ ನೆರೆಹೊರೆಯವರಿಂದ ಬೆಳ್ಳಿಬಂಗಾರದ ಒಡವೆಗಳನ್ನು ಕೇಳಿಕೊಳ್ಳಬೇಕೆಂಬುದಾಗಿ ಜನರಿಗೆ ಸ್ಪಷ್ಟವಾಗಿ ಹೇಳು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರ ಮೇಲೆ ಐಗುಪ್ತ್ಯರಲ್ಲಿ ದಯೆಯನ್ನು ಹುಟ್ಟಿಸಿದನು. ಇದಲ್ಲದೆ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಫರೋಹನ ಪ್ರಜಾಪರಿವಾರದವರು ಹಾಗು ಜನರು ಮೋಶೆಯನ್ನು ಮಹಾಶ್ರೇಷ್ಠಪುರುಷನೆಂದು ಭಾವಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ಆಗ ಮೋಶೆ ಫರೋಹನಿಗೆ, “ಯೆಹೋವನು ಅಪ್ಪಣೆಮಾಡುವುದೇನೆಂದರೆ, ‘ನಾನು ಮಧ್ಯರಾತ್ರಿಯಲ್ಲಿ ಐಗುಪ್ತ್ಯರ ನಡುವೆ ಹಾದುಹೋಗುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ಆಗ ಸಿಂಹಾಸನದ ಮೇಲೆ ಕುಳಿತಿರುವ ಫರೋಹನ ಚೊಚ್ಚಲು ಮಗನು ಮೊದಲುಗೊಂಡು, ಬೀಸುವಕಲ್ಲಿನ ಹಿಂದೆ ಕುಳಿತಿರುವ ದಾಸಿಯ ಚೊಚ್ಚಲು ಮಗನವರೆಗೂ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿರುವ ಚೊಚ್ಚಲು ಮಕ್ಕಳೆಲ್ಲರೂ ಸಾಯುವರು. ಪಶುಗಳಲ್ಲಿಯೂ ಚೊಚ್ಚಲಾದವುಗಳೆಲ್ಲಾ ಸಾಯುವವು. ");
INSERT INTO kanirv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ಆಗ ಐಗುಪ್ತ ದೇಶದಲ್ಲೆಲ್ಲಾ ದೊಡ್ಡ ಗೋಳಾಟವುಂಟಾಗುವುದು, ಅಂಥ ಗೋಳಾಟವು ಈವರೆಗೆ ದೇಶದಲ್ಲಿ ಎಂದೂ ಉಂಟಾಗಿರಲಿಲ್ಲ, ಮುಂದೆಯೂ ಉಂಟಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ಆದರೆ ಐಗುಪ್ತ್ಯರಿಗೂ, ಇಸ್ರಾಯೇಲರಿಗೂ ಯೆಹೋವನು ವ್ಯತ್ಯಾಸಮಾಡಿದ್ದಾನೆಂಬುದು ನಿಮಗೆ ತಿಳಿಯುವಂತೆ ಇಸ್ರಾಯೇಲರಲ್ಲಿರುವ ಮನುಷ್ಯರ ಎದುರಿಗಾಗಲಿ, ಪಶುಗಳ ಎದುರಿಗಾಗಲಿ ಒಂದು ನಾಯಿಯಾದರೂ ಬೊಗಳುವುದಿಲ್ಲ’ ");
INSERT INTO kanirv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ಆಗ ನಿನ್ನ ಪರಿವಾರದವರೆಲ್ಲರೂ, ನನ್ನ ಬಳಿಗೆ ಬಂದು ಅಡ್ಡಬಿದ್ದು, ‘ನೀನೂ ನಿನ್ನ ಅಧೀನದಲ್ಲಿರುವ ಜನರೆಲ್ಲರೂ ನಮ್ಮನ್ನು ಬಿಟ್ಟು ಹೋಗಬೇಕು’ ಎಂದು ಬೇಡುವರು. ಆ ಮೇಲೆ ನಾನು ಹೊರಟುಹೋಗುವೆನು” ಎಂದು ಹೇಳಿದನು. ಮೋಶೆ ಈ ಮಾತನ್ನು ಹೇಳಿ ಕೋಪಾವೇಶವುಳ್ಳವನಾಗಿ ಫರೋಹನನ್ನು ಬಿಟ್ಟು ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ನನ್ನ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ಇನ್ನೂ ಹೆಚ್ಚಾಗಿ ನಡೆಯಬೇಕಾಗಿರುವುದರಿಂದ ಫರೋಹನು ನಿಮ್ಮ ಮಾತನ್ನು ಕೇಳುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಫರೋಹನ ಮುಂದೆ ಆ ಮಹತ್ಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ಮಾಡಿದರು. ಆದರೆ ಯೆಹೋವನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಮಾಡಿದ್ದರಿಂದ ಫರೋಹನು ಇಸ್ರಾಯೇಲರಿಗೆ ತನ್ನ ದೇಶವನ್ನು ಬಿಟ್ಟು ಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆ ಕೊಡದೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ಎಲ್ಲಾ ತಿಂಗಳುಗಳಲ್ಲಿ ಇದೇ ನಿಮಗೆ ಮೊದಲ ತಿಂಗಳಾಗಿರಬೇಕು. ಇದೇ ನಿಮಗೆ ಪ್ರತಿ ವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ಇದರ ವಿಷಯದಲ್ಲಿ ನೀವು ಇಸ್ರಾಯೇಲರ ಸಮೂಹಕ್ಕೆಲ್ಲಾ ಹೀಗೆ ಅಪ್ಪಣೆಮಾಡಬೇಕು, ‘ಈ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ನಿಮ್ಮ ನಿಮ್ಮ ಗೋತ್ರಗಳ ಪ್ರತಿಯೊಂದು ಮನೆಯವರು ಒಂದೊಂದು ಕುರಿಮರಿಯನ್ನಾಗಲಿ, ಆಡುಮರಿಯನ್ನಾಗಲಿ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ಕುಟುಂಬವು ಚಿಕ್ಕದಾಗಿದ್ದರೆ, ಒಂದು ಕುರಿಮರಿಯನ್ನು ಪೂರ್ಣವಾಗಿ ತಿನ್ನುವುದಕ್ಕೆ ಆಗದೆ ಹೋದ ಪಕ್ಷಕ್ಕೆ ನೆರೆಮನೆಯ ಕುಟುಂಬದವರೊಂದಿಗೆ ಸೇರಿ, ಒಬ್ಬೊಬ್ಬನು ಎಷ್ಟೆಷ್ಟು ತಿನ್ನುವನೆಂದು ಗೊತ್ತುಮಾಡಿಕೊಂಡು ಜನಗಳ ಸಂಖ್ಯಾನುಸಾರ ಮರಿಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ಆ ಮರಿಯು ಊನವಿಲ್ಲದ ಒಂದು ವರ್ಷದ ಗಂಡುಮರಿಯಾಗಿರಬೇಕು. ನೀವು ಕುರಿಗಳಿಂದಾಗಲಿ ಅಥವಾ ಆಡುಗಳಿಂದಾಗಲಿ ಅದನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ಈ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದವರೆಗೆ ಅವುಗಳನ್ನು ಇಟ್ಟುಕೊಂಡಿದ್ದು, ಆ ದಿನದ ಸಂಜೆ ವೇಳೆಯಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರೆಲ್ಲರೂ ಒಟ್ಟಿಗೆ ಸೇರಿ ಅವುಗಳನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ಅವರು ಅವುಗಳ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದು ತಾವು ಆ ಭೋಜನವನ್ನು ಮಾಡುವ ಮನೆಬಾಗಿಲಿನ ಎರಡು ನಿಲುವುಪಟ್ಟಿಗಳಿಗೂ, ಮೇಲಿನ ಪಟ್ಟಿಗೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ಆ ರಾತ್ರಿಯಲ್ಲಿಯೇ ಆ ಮಾಂಸವನ್ನು ಭೋಜನಮಾಡಬೇಕು. ಅದನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಸುಟ್ಟು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳ ಮತ್ತು ಕಹಿಯಾದ ಸೊಪ್ಪಿನ ಪಲ್ಯಗಳ ಸಂಗಡ ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ಅದನ್ನು ಹಸಿಯಾಗಿಯೂ ನೀರಿನಲ್ಲಿ ಬೇಯಿಸಿಯೂ ತಿನ್ನಕೂಡದು. ಅದರ ತಲೆ, ತೊಡೆ, ಹೊಟ್ಟೆ, ಇವುಗಳ ಸಹಿತವಾಗಿ ಬೆಂಕಿಯಲ್ಲೇ ಸುಟ್ಟು ತಿನ್ನಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ಮರುದಿನದ ಬೆಳಗಿನವರೆಗೆ ಅದರಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನಾದರೂ ಉಳಿಸಕೂಡದು, ಬೆಳಗಿನವರೆಗೆ ಉಳಿದದ್ದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ಆ ಭೋಜನವನ್ನು ಮಾಡಬೇಕಾದ ಕ್ರಮ ಹೇಗೆಂದರೆ: ನೀವು ನಡುವನ್ನು ಕಟ್ಟಿಕೊಂಡು, ಕೆರವನ್ನು ಮೆಟ್ಟಿಕೊಂಡು, ಕೋಲುಹಿಡಿದು, ತ್ವರೆಯಾಗಿ ಮಾಡಬೇಕು. ಇದು ಯೆಹೋವನಿಗೆ ಆಚರಿಸತಕ್ಕ ಪಸ್ಕಹಬ್ಬವು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","ಆ ರಾತ್ರಿ ನಾನು ಐಗುಪ್ತದೇಶದ ಮೇಲೆ ಹಾದುಹೋಗಿ ಮನುಷ್ಯರಲ್ಲಾಗಲಿ, ಪಶುಗಳಲ್ಲಾಗಲಿ, ಚೊಚ್ಚಲಾಗಿರುವುದನ್ನೆಲ್ಲಾ ಸಂಹರಿಸುವೆನು. ಐಗುಪ್ತ ದೇಶದ ಸಮಸ್ತ ದೇವತೆಗಳಿಗೂ ನ್ಯಾಯತೀರಿಸುವೆನು. ನಾನೇ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ಆದರೆ ನೀವು ಇರುವ ಎಲ್ಲಾ ಮನೆಗಳ ಬಾಗಿಲಿಗೆ ಹಚ್ಚಿರುವ ರಕ್ತವು ನಿಮಗೆ ಗುರುತಾಗಿರುವುದು. ಆ ರಕ್ತವನ್ನು ನಾನು ನೋಡುವಾಗ ನಿಮಗೆ ಯಾವ ನಷ್ಟವನ್ನೂ ಮಾಡದೇ ಮುಂದಕ್ಕೆ ದಾಟಿಹೋಗುವೆನು. ನಾನು ಐಗುಪ್ತ್ಯದವರನ್ನು ಸಂಹರಿಸುವಾಗ ನಿಮಗೆ ಯಾವ ಹಾನಿಯೂ ಉಂಟಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","ಈ ದಿನವು ನಿಮಗೆ ಜ್ಞಾಪಕಾರ್ಥವಾಗಿರುವುದು. ಯೆಹೋವನ ಘನಕ್ಕಾಗಿ ಆ ಹಬ್ಬವನ್ನು ತಲತಲಾಂತರಕ್ಕೂ ಆಚರಿಸಬೇಕು. ಅದನ್ನು ಶಾಶ್ವತನಿಯಮವೆಂದು ಎಂದೆಂದಿಗೂ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“‘ಏಳು ದಿನಗಳವರೆಗೆ ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು. ಮೊದಲನೆಯ ದಿನದಲ್ಲಿಯೇ ಹುಳಿಹಿಟ್ಟನ್ನು ನಿಮ್ಮ ಮನೆಯೊಳಗಿಂದ ತೆಗೆದುಬಿಡಬೇಕು. ಏಕೆಂದರೆ ಮೊದಲನೆಯ ದಿನದಿಂದ ಏಳನೆಯ ದಿನದವರೆಗೆ ಹುಳಿರೊಟ್ಟಿಯನ್ನು ತಿನ್ನುವವನು ಇಸ್ರಾಯೇಲಿನೊಳಗಿಂದ ತೆಗೆದುಹಾಕಲ್ಪಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಪರಿಶುದ್ಧ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆ ಸೇರಬೇಕು. ಏಳನೆಯ ದಿನದಲ್ಲಿಯೂ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆ ಸೇರಬೇಕು. ಈ ಎರಡು ದಿನಗಳಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನು ಮಾಡಕೂಡದು. ಊಟಕ್ಕೆ ಬೇಕಾದದ್ದನ್ನು ಮಾತ್ರ ಮಾಡಬಹುದೇ ಹೊರತು ಬೇರೆ ಯಾವ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ಏಕೆಂದರೆ ಈ ದಿನದಲ್ಲಿಯೇ ನಾನು ನಿಮ್ಮ ಸೈನ್ಯಗಳನ್ನು ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ್ದರಿಂದ ನೀವೂ, ನಿಮ್ಮ ಸಂತತಿಯವರೂ ಈ ದಿನವನ್ನು ಆಚರಣೆಗೆ ತರಬೇಕು. ಇದು ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ಸಾಯಂಕಾಲ ಮೊದಲುಗೊಂಡು ಅದೇ ತಿಂಗಳಿನ ಇಪ್ಪತ್ತೊಂದನೆಯ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನೇ ತಿನ್ನಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ಆ ಏಳು ದಿನಗಳವರೆಗೆ ನಿಮ್ಮ ಮನೆಗಳಲ್ಲಿ ಹುಳಿಹಿಟ್ಟು ಇರಬಾರದು. ಹುಳಿ ಬೆರಸಿದ್ದನ್ನು ಯಾರು ತಿನ್ನುವರೋ ಅವನು ಪರದೇಶದವನಾಗಲಿ, ಸ್ವದೇಶದವನಾಗಲಿ ಇಸ್ರಾಯೇಲ ಸಮೂಹದೊಳಗಿಂದ ತೆಗೆದುಹಾಕಲ್ಪಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ನೀವು ನಿಮ್ಮ ಮನೆಗಳಲ್ಲಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕೇ ಹೊರತು, ಹುಳಿಕಲಸಿದ ಯಾವುದನ್ನೂ ತಿನ್ನಕೂಡದು’” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ಆಗ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರೆಲ್ಲರನ್ನೂ ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನೀವು, ನಿಮ್ಮ ನಿಮ್ಮ ಕುಟುಂಬಗಳಿಗೋಸ್ಕರ ಮಂದೆಯಿಂದ ಮರಿಗಳನ್ನು ಆರಿಸಿಕೊಂಡು ಪಸ್ಕಹಬ್ಬಕ್ಕೆ ಕೊಯ್ಯಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಕಟ್ಟನ್ನು ತೆಗೆದುಕೊಂಡು ಬೋಗುಣಿಯಲ್ಲಿರುವ ರಕ್ತದಲ್ಲಿ ಅದನ್ನು ಅದ್ದಿ ಬಾಗಿಲಿನ ಮೇಲಿನ ಅಡ್ಡಪಟ್ಟಿಗೂ, ಅದರ ಪಕ್ಕದಲ್ಲಿರುವ ಎರಡು ನಿಲುವುಪಟ್ಟಿಗಳಿಗೂ ಹಚ್ಚಬೇಕು. ತರುವಾಯ ನಿಮ್ಮಲ್ಲಿ ಒಬ್ಬರೂ ಬೆಳಗಾಗುವವರೆಗೆ ಮನೆಯ ಬಾಗಿಲನ್ನು ಬಿಟ್ಟು ಹೊರಗೆ ಹೋಗಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ಯೆಹೋವನು ಐಗುಪ್ತ್ಯರನ್ನು ಹತಮಾಡುವುದಕ್ಕೆ ದೇಶದ ನಡುವೆ ಹಾದುಹೋಗುವನು. ಆಗ ನಿಮ್ಮ ನಿಮ್ಮ ಮನೆಬಾಗಿಲಿನ ಮೇಲಣ ಪಟ್ಟಿಯಲ್ಲಿಯೂ, ಎರಡು ನಿಲುವು ಪಟ್ಟಿಗಳಲ್ಲಿಯೂ ಆ ರಕ್ತವನ್ನು ಕಂಡು ಮುಂದಕ್ಕೆ ದಾಟಿ ಹೋಗುವನು. ನಿಮ್ಮ ಪ್ರಾಣ ತೆಗೆಯುವುದಕ್ಕೆ ಸಂಹಾರಕನು ನಿಮ್ಮ ಮನೆಗಳಲ್ಲಿ ಬರುವುದೇ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ಇದು ನಿಮಗೂ, ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತವಾದ ನಿಯಮವೆಂದು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ಯೆಹೋವನು ತನ್ನ ಮಾತಿನ ಮೇರೆಗೆ ನಿಮಗೆ ಕೊಡುವ ದೇಶಕ್ಕೆ ನೀವು ಬಂದಾಗ, ಈ ಆಚರಣೆಯನ್ನು ಕೈಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ಮುಂದೆ ನಿಮ್ಮ ಮಕ್ಕಳು, ‘ನೀವು ನಡೆಸುವ ಈ ಆಚರಣೆ ಏನು?’ ಎಂದು ನಿಮ್ಮನ್ನು ಕೇಳುವಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ನೀವು ಅವರಿಗೆ, ‘ಯೆಹೋವನು ಐಗುಪ್ತ್ಯರನ್ನು ಸಂಹರಿಸಿದಾಗ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿದ್ದ ಇಸ್ರಾಯೇಲರ ಮನೆಗಳಲ್ಲಿ ಪ್ರವೇಶಿಸದೆ ಮುಂದಕ್ಕೆ ದಾಟಿ ನಮ್ಮ ಮನೆಯವರನ್ನು ಉಳಿಸಿದ್ದರಿಂದ ನಾವು ಯೆಹೋವನ ಪಸ್ಕವೆಂಬ ಈ ಆಚರಣೆಯನ್ನು ನಡೆಸಲೇಬೇಕು ಎಂದು ಹೇಳಬೇಕು’” ಎಂದನು. ಆಗ ಜನರು ತಲೆಬಾಗಿ ಯೆಹೋವನಿಗೆ ನಮಸ್ಕರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ಇಸ್ರಾಯೇಲರು ಅಲ್ಲಿಂದ ಹೊರಟು ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ಮಧ್ಯರಾತ್ರಿಯಲ್ಲಿ ಯೆಹೋವನು ಸಿಂಹಾಸನದಲ್ಲಿರುವ ಫರೋಹನ ಚೊಚ್ಚಲು ಮಗನು ಮೊದಲುಗೊಂಡು ಸೆರೆಯಲ್ಲಿದ್ದ ಸೆರೆಯವನ ಚೊಚ್ಚಲು ಮಗನವರೆಗೂ, ಐಗುಪ್ತ ದೇಶದಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಮಕ್ಕಳನ್ನೂ ಸಂಹಾರ ಮಾಡಿದನು. ಪಶುಗಳ ಚೊಚ್ಚಲು ಮರಿಗಳನ್ನೂ ಸಂಹಾರಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ಆ ರಾತ್ರಿಯಲ್ಲಿ ಫರೋಹನೂ, ಅವನ ಪರಿವಾರದವರೂ, ಐಗುಪ್ತ್ಯರೆಲ್ಲರೂ ಎದ್ದು ನೋಡಲಾಗಿ ಸಾವಿಲ್ಲದ ಮನೆ ಒಂದೂ ಇರಲಿಲ್ಲ. ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ದೊಡ್ಡ ಗೋಳಾಟವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ಫರೋಹನು ಆ ರಾತ್ರಿಯಲ್ಲೇ ಮೋಶೆ ಮತ್ತು ಆರೋನರನ್ನು ಕರೆಯಿಸಿ ಅವರಿಗೆ, “ನೀವು ಎದ್ದು ನನ್ನ ಜನರ ಮಧ್ಯದಿಂದ ಹೊರಟುಹೋಗಿರಿ. ನೀವು ಕೇಳಿಕೊಂಡ ಮೇರೆಗೆ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸುವುದಕ್ಕೆ ನೀವು ಮತ್ತು ಇಸ್ರಾಯೇಲರು ಹೊರಟುಹೋಗಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ನೀವು ಕೇಳಿಕೊಂಡಂತೆ ನಿಮ್ಮ ಕುರಿದನಗಳ ಹಿಂಡುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ಅದಲ್ಲದೆ ನನ್ನನ್ನೂ ಸಹ ಆಶೀರ್ವದಿಸಿರಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ಐಗುಪ್ತರು, “ನಾವೆಲ್ಲರು ಸಾಯುತ್ತೇವೆ” ಎಂದುಕೊಂಡು ಇಸ್ರಾಯೇಲರನ್ನು ತಮ್ಮ ದೇಶದಿಂದ ಬೇಗನೇ ಕಳುಹಿಸಿಬಿಡುವುದಕ್ಕೆ ಅಪೇಕ್ಷೆಪಟ್ಟು ಅವರನ್ನು ಬಲವಂತಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ಆದುದರಿಂದ ಜನರು ಹಿಟ್ಟಿಗೆ ಹುಳಿಹಾಕುವುದಕ್ಕಿಂತ ಮೊದಲೇ ನಾದುವ ಪಾತ್ರೆಗಳ ಸಂಗಡ ಕಣಕದ ಮುದ್ದೆಯನ್ನು ಬಟ್ಟೆಯಲ್ಲಿ ಗಂಟುಕಟ್ಟಿ ಹೆಗಲಿನ ಮೇಲೆ ಹಾಕಿಕೊಂಡು ಹೊರಟುಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ಇಸ್ರಾಯೇಲರು ಮೋಶೆಯ ಮಾತಿನ ಮೇರೆಗೆ ಐಗುಪ್ತ್ಯರಿಂದ ಬೆಳ್ಳಿ ಬಂಗಾರದ ಒಡವೆಗಳನ್ನು, ಬಟ್ಟೆಗಳನ್ನು ಕೇಳಿ ಪಡೆದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ಯೆಹೋವನು ಅವರ ಮೇಲೆ ಐಗುಪ್ತ್ಯರಲ್ಲಿ ದಯೆಯನ್ನು ಹುಟ್ಟಿಸಿದ್ದರಿಂದ ಅವರು ಕೇಳಿಕೊಂಡದ್ದೆಲ್ಲವನ್ನು ಐಗುಪ್ತರು ಕೊಟ್ಟರು. ಹೀಗೆ ಇಸ್ರಾಯೇಲರು ಐಗುಪ್ತ್ಯರ ಸೊತ್ತನ್ನು ಸುಲಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ಇಸ್ರಾಯೇಲರು ರಾಮ್ಸೇಸ್ ಪಟ್ಟಣದಿಂದ ಹೊರಟು ಸುಕ್ಕೋತಿಗೆ ಬಂದರು. ಹೆಂಗಸರು ಮಕ್ಕಳು ಅಲ್ಲದೆ ಗಂಡಸರು ಮಾತ್ರ ಸುಮಾರು ಆರುಲಕ್ಷ ಮಂದಿ ಇದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ಅವರೊಂದಿಗೆ ಬಹು ಮಂದಿ ಅನ್ಯರೂ ಹೊರಟುಬಂದಿದ್ದರು. ಕುರಿದನಗಳ ಹಿಂಡೂ ಪಶುಗಳೂ ಅವರ ಸಂಗಡ ಹೊರಟುಹೋದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ಅವರು ಐಗುಪ್ತ ದೇಶದಿಂದ ತಂದ ನಾದಿದ ಹಿಟ್ಟಿನಿಂದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಿಕೊಂಡರು. ಅವರು ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಡಿಸಲ್ಪಟ್ಟು ಸ್ವಲ್ಪವಾದರೂ ಸಮಯ ಸಿಕ್ಕದೆ ಹೋದದರಿಂದ ಕಣಕದಲ್ಲಿ ಹುಳಿಯನ್ನು ಕಲಸಿರಲಿಲ್ಲ ಮತ್ತು ಬೇರೆ ಯಾವ ಆಹಾರವನ್ನೂ ಸಿದ್ಧಪಡಿಸಿಕೊಂಡಿರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ಇಸ್ರಾಯೇಲರು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಸುಮಾರು ನಾನೂರಮೂವತ್ತು ವರ್ಷ ವಾಸವಾಗಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ನಾನೂರಮೂವತ್ತು ವರ್ಷಗಳು ಕಳೆದನಂತರ ಅದೇ ದಿನದಲ್ಲಿಯೇ ಯೆಹೋವನ ಸೈನ್ಯಗಳೆಲ್ಲಾ ಐಗುಪ್ತ ದೇಶವನ್ನು ಬಿಟ್ಟು ಹೊರಟುಹೋದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ಯೆಹೋವನು ಆ ರಾತ್ರಿಯಲ್ಲಿಯೇ ಅವರನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ್ದರಿಂದ ಅವರು ಈ ರಾತ್ರಿಯಲ್ಲಿ ಆತನ ಘನಕ್ಕಾಗಿ ಜಾಗರಣೆಯನ್ನು ಮಾಡಿದರು. ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ತಲತಲಾಂತರಕ್ಕೂ ಯೆಹೋವನಿಗೆ ಜಾಗರಣೆಯನ್ನು ಆಚರಿಸಬೇಕಾದ ರಾತ್ರಿಯು ಇದೇ ಆಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ಪಸ್ಕವನ್ನು ಆಚರಿಸಬೇಕಾದ ಕ್ರಮ ಹೇಗೆಂದರೆ, ಅನ್ಯನೊಬ್ಬನೂ ಅದರಲ್ಲಿ ಭೋಜನ ಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ಆದರೆ ನೀವು ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡ ಪ್ರತಿಯೊಬ್ಬ ಗುಲಾಮನು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡ ನಂತರ ಅದನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ಪರದೇಶದವರೂ, ಕೂಲಿಯವರೂ ಅದನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ಅವರವರ ಮನೆಯಲ್ಲಿಯೇ ಅದನ್ನು ಊಟಮಾಡಬೇಕು. ಅದರಲ್ಲಿ ಸ್ವಲ್ಪ ಮಾಂಸವನ್ನಾದರೂ ಮನೆಯಿಂದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬಾರದು. ಆ ಪಶುವಿನ ಒಂದು ಎಲುಬನ್ನಾದರೂ ಮುರಿಯಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರೆಲ್ಲರೂ ಈ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ವಾಸವಾಗಿರುವ ಪರದೇಶದವನು ಯೆಹೋವನಿಗೆ ಈ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕೆಂದು ಅಪೇಕ್ಷಿಸಿದರೆ ಅವನೂ, ಅವನಿಗೆ ಸೇರಿರುವ ಗಂಡಸರೆಲ್ಲರೂ ಸುನ್ನತಿಮಾಡಿಸಿಕೊಳ್ಳಬೇಕು. ತರುವಾಯ ಅವನು ಈ ಹಬ್ಬವನ್ನು ಆಚರಿಸುವುದಕ್ಕೆ ಸಮೀಪ ಬರಲಿ. ಅಂಥವನು ಸ್ವದೇಶದವನಂತೆಯೇ ಇರುವನು. ಆದರೆ ಸುನ್ನತಿಮಾಡಿಸಿಕೊಳ್ಳದವನು ಆ ಭೋಜನವನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ಸ್ವದೇಶದವನಿಗೂ, ನಿಮ್ಮಲ್ಲಿ ವಾಸವಾಗಿರುವ ಪರದೇಶದವನಿಗೂ ಒಂದೇ ನಿಯಮವಿರಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ಅದೇ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರನ್ನು ಅವರವರ ಸೈನ್ಯಗಳ ಪ್ರಕಾರವಾಗಿ ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಗೆ ತಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಹುಟ್ಟಿರುವ ಪ್ರತಿಯೊಂದು ಚೊಚ್ಚಲ ಗಂಡನ್ನು ನನಗಾಗಿ ಪ್ರತಿಷ್ಠಿಸಬೇಕು. ಮನುಷ್ಯರಲ್ಲಾಗಲೀ, ಪಶುಗಳಲ್ಲಾಗಲೀ ಹುಟ್ಟುವ ಪ್ರಥಮ ಗರ್ಭಫಲವು ನನ್ನದಾಗಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ, “ನೀವು ದಾಸತ್ವದಲ್ಲಿದ್ದ ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ಬಿಡುಗಡೆಯಾದ ಈ ದಿನವನ್ನು ನೆನಪಿನಲ್ಲಿಟ್ಟುಕೊಳ್ಳಿರಿ. ಯೆಹೋವನು ತನ್ನ ಭುಜಬಲದಿಂದ ನಿಮ್ಮನ್ನು ಆ ಸ್ಥಳದಿಂದ ಬಿಡಿಸಿದ್ದಾನೆ. ಈ ದಿನದಲ್ಲಿ ನೀವು ಹುಳಿಬೆರೆಸಿದ್ದನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ಚೈತ್ರ ಮಾಸದ ಈ ದಿನದಲ್ಲೇ ನೀವು ಹೊರಗೆ ಬಂದಿರುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ಯೆಹೋವನು ನಿಮ್ಮ ಪೂರ್ವಿಕರಿಗೆ ಪ್ರಮಾಣಮಾಡಿ ಹೇಳಿದಂತೆ, ನಿಮ್ಮನ್ನು ಹಾಲೂ ಮತ್ತು ಜೇನೂ ಹರಿಯುವ ದೇಶಕ್ಕೆ ಅಂದರೆ ಕಾನಾನ್ಯರು, ಹಿತ್ತಿಯರು, ಅಮೋರಿಯರು, ಹಿವ್ವಿಯರು, ಯೆಬೂಸಿಯರು ವಾಸವಾಗಿರುವ ದೇಶಕ್ಕೆ ಕರೆದು ತಂದು ಅದನ್ನು ನಿಮಗೆ ಕೊಟ್ಟಾಗ ನೀವು ಈ ತಿಂಗಳಲ್ಲಿ ಈ ಆಚರಣೆಯನ್ನು ನಡೆಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ಏಳು ದಿನ ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು, ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವನ ಘನಕ್ಕಾಗಿ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ಆ ಏಳು ದಿನವೂ ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು. ಮಾತ್ರವಲ್ಲದೆ, ನಿಮ್ಮಲ್ಲಿ ಹುಳಿಹಿಟ್ಟು ಕಾಣಿಸಬಾರದು. ಇಲ್ಲವೆ ಹುಳಿಹಿಟ್ಟು ನಿಮ್ಮ ಗಡಿಯಲ್ಲೇ ಕಾಣಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ಆ ದಿನದಲ್ಲಿ ನೀವು ನಿಮ್ಮ ಮಕ್ಕಳಿಗೆ, ನಮ್ಮ ಜನರು ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಟು ಬಂದಾಗ ಯೆಹೋವನು ನಮಗೋಸ್ಕರ ಮಾಡಿದ್ದನ್ನು ನೆನಪು ಮಾಡಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಈ ಆಚರಣೆಯನ್ನು ಆಚರಿಸುತ್ತೇವೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ಯೆಹೋವನು ತನ್ನ ಭುಜಬಲದಿಂದ ನಿಮ್ಮನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಬಿಡಿಸಿದ್ದರಿಂದ ಆತನ ನಿಯಮವನ್ನು ಕುರಿತು ನೀವು ಹೇಳಬೇಕು. ಈ ಆಚರಣೆಯು ನಿಮ್ಮ ಕೈಗಳ ಮೇಲೆ ಗುರುತಾಗಿಯೂ, ಹಣೆಗೆ ಕಟ್ಟಿಕೊಂಡಿರುವ ಜ್ಞಾಪಕಪಟ್ಟಿಯಂತೆಯೂ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ಹೀಗಿರುವುದರಿಂದ ಪ್ರತಿವರ್ಷವು ನಿಯಮಿತವಾದ ಕಾಲದಲ್ಲಿ ನೀವು ಈ ಆಚರಣೆಯನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“ಯೆಹೋವನು ನಿಮಗೂ ನಿಮ್ಮ ಪೂರ್ವಿಕರಿಗೂ ಪ್ರಮಾಣಮಾಡಿದ ಪ್ರಕಾರ ನಿಮ್ಮನ್ನು ಕಾನಾನ್ಯರ ದೇಶಕ್ಕೆ ಬರಮಾಡಿ ಆ ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಟ್ಟ ನಂತರ, ");
INSERT INTO kanirv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ನಿಮ್ಮಲ್ಲಿಯೂ ನಿಮ್ಮ ಪಶುಗಳಲ್ಲಿಯೂ ಹುಟ್ಟುವ ಪ್ರಥಮ ಗರ್ಭಫಲವು ಗಂಡಾದ ಪಕ್ಷಕ್ಕೆ ಅದು ಯೆಹೋವನ ಭಾಗವೆಂದು ತಿಳಿದುಕೊಂಡು ಅದನ್ನು ಆತನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ಮೊದಲು ಹುಟ್ಟಿದ ಕತ್ತೆಯ ಚೊಚ್ಚಲಮರಿಗೆ ಬದಲಾಗಿ ಕುರಿಮರಿಯನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬಹುದು. ಹಾಗೆ ಬಿಡಿಸದೆ ಹೋದರೆ ಅದರ ಕುತ್ತಿಗೆ ಮುರಿದು ಕೊಲ್ಲಬೇಕು. ಮನುಷ್ಯರ ಚೊಚ್ಚಲ ಗಂಡು ಮಕ್ಕಳನ್ನು ಯೆಹೋವನಿಗಾಗಿ ಬಿಡಿಸಿಕೊಳ್ಳಲೇ ಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ಮುಂದೆ ನಿಮ್ಮ ಮಕ್ಕಳು, ‘ಇದರ ಅರ್ಥ ಏನು?’ ಎಂದು ನಿಮ್ಮನ್ನು ವಿಚಾರಿಸುವಾಗ ನೀವು ಅವರಿಗೆ, ‘ನಾವು ದಾಸತ್ವದಲ್ಲಿದ್ದ ಐಗುಪ್ತ ದೇಶದಿಂದ ಯೆಹೋವನು ತನ್ನ ಭುಜಬಲದಿಂದ ನಮ್ಮನ್ನು ಬಿಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ಫರೋಹನು ಹಠಹಿಡಿದು ನಮ್ಮನ್ನು ಹೋಗಗೊಡಿಸದೇ ಇದ್ದಾಗ ಯೆಹೋವನು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಮನುಷ್ಯರ ಚೊಚ್ಚಲಮಕ್ಕಳನ್ನು, ಪಶುಗಳ ಚೊಚ್ಚಲು ಮರಿಗಳನ್ನು ಅಂತೂ ಆ ದೇಶದಲ್ಲಿ ಚೊಚ್ಚಲಾಗಿದ್ದ ಎಲ್ಲವನ್ನು ಸಂಹಾರ ಮಾಡಿದನು. ಆದಕಾರಣ ಗಂಡಾಗಿ ಹುಟ್ಟುವ ಪ್ರಥಮ ಗರ್ಭಫಲವನ್ನೆಲ್ಲಾ ನಾವು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವುದುಂಟು. ಮನುಷ್ಯರಿಂದಾದ ಪ್ರಥಮ ಗರ್ಭಫಲವನ್ನಾದರೋ ಅದನ್ನು ಬದಲುಕೊಟ್ಟು ಬಿಡಿಸುತ್ತೇವೆ’” ಎಂದು ಹೇಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ಯೆಹೋವನು ಭುಜಬಲದಿಂದ ನಿಮ್ಮನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಬಿಡಿಸಿದ ಸಂಗತಿಯನ್ನು ನೀವು ಜ್ಞಾಪಕದಲ್ಲಿಟ್ಟುಕೊಳ್ಳುವುದರ ಗುರುತಾಗಿ ಅದನ್ನು ನಿಮ್ಮ ಕೈಗಳ ಮೇಲೆಯೂ, ಹಣೆಯ ಮೇಲೆ ಜ್ಞಾಪಕಪಟ್ಟಿಯಂತೆಯೂ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ಫರೋಹನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆ ಕೊಟ್ಟಾಗ, ಫಿಲಿಷ್ಟಿಯರ ದೇಶದ ಮಾರ್ಗವು ಸಮೀಪವಾಗಿದ್ದರೂ ದೇವರು ಆ ದಾರಿಯಲ್ಲಿ ಅವರನ್ನು ಹೋಗಗೊಡಿಸಲಿಲ್ಲ. ಏಕೆಂದರೆ, “ದೇವರು, ಜನರು ಯುದ್ಧವನ್ನು ನೋಡಿ ಗಾಬರಿಯಾಗಿ ಮನಸ್ಸನ್ನು ಬದಲಾಯಿಸಿಕೊಂಡು ಐಗುಪ್ತಕ್ಕೆ ಹಿಂದಿರುಗಿ ಹೋದಾರೂ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ಹೀಗಿರುವುದರಿಂದ ಯೆಹೋವನು ಜನರನ್ನು ಕೆಂಪುಸಮುದ್ರದ ಸಮೀಪದಲ್ಲಿರುವ ಮರುಭೂಮಿಯನ್ನು ಬಳಸಿಕೊಂಡು ಹೋಗುವಂತೆ ಮಾಡಿದನು. ಆದರೂ ಇಸ್ರಾಯೇಲರು ಯುದ್ಧಸನ್ನದ್ದರಾಗಿ ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ಹೊರಟುಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ಇದಲ್ಲದೆ ಯೋಸೇಫನು ಇಸ್ರಾಯೇಲರಿಗೆ, “ದೇವರು ನಿಸ್ಸಂದೇಹವಾಗಿ ನಿಮ್ಮನ್ನು ಪರಾಂಬರಿಸಿ ತನ್ನ ವಾಗ್ದಾನವನ್ನು ನೆರವೇರಿಸುವವನಾಗಿರುವುದರಿಂದ ನೀವು ಹೋಗುವಾಗ ನನ್ನ ದೇಹದ ಅಸ್ತಿಮೂಳೆಗಳನ್ನು ನಿಮ್ಮ ಸಂಗಡ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು” ಎಂದು ಖಂಡಿತವಾದ ಪ್ರಮಾಣವನ್ನು ಮಾಡಿಸಿದ್ದರಿಂದ ಮೋಶೆಯು ಅವನ ಮೂಳೆಗಳನ್ನು ತನ್ನ ಸಂಗಡ ತೆಗೆದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ಅವರು ಸುಕ್ಕೋತಿನಿಂದ ಪ್ರಯಾಣ ಮಾಡಿ ಮರಳುಗಾಡಿನ ಅಂಚಿನಲ್ಲಿರುವ ಏತಾಮಿನಲ್ಲಿ ಪಾಳೆಯಮಾಡಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ಯೆಹೋವನು ಹಗಲು ಹೊತ್ತಿನಲ್ಲಿ ದಾರಿತೋರಿಸುವುದಕ್ಕೆ ಮೇಘಸ್ತಂಭದಲ್ಲಿಯೂ, ರಾತ್ರಿವೇಳೆಯಲ್ಲಿ ಬೆಳಕುಕೊಡುವುದಕ್ಕೆ ಅಗ್ನಿಸ್ತಂಭದಲ್ಲಿಯೂ ಇದ್ದು ಅವನ್ನು ನಡೆಸುತಿದ್ದನು. ಈ ರೀತಿಯಲ್ಲಿ ಅವರು ಹಗಲಿರುಳು ಪ್ರಯಾಣಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ಹಗಲಿನಲ್ಲಿ ಮೇಘಸ್ತಂಭವಾಗಿ, ರಾತ್ರಿಯಲ್ಲಿ ಅಗ್ನಿಸ್ತಂಭವಾಗಿ ಜನರನ್ನು ಬಿಟ್ಟು ಹೋಗದೆ ಅಲ್ಲಿಯೇ ಇರುತ್ತಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ");
INSERT INTO kanirv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ಇಸ್ರಾಯೇಲರು ಹಿಂದಿರುಗಿ ಹೋಗಿ ಪೀಹಹೀರೋತಿನ ಪೂರ್ವಕಡೆಯಲ್ಲಿ ಮಿಗ್ದೋಲಿಗೂ ಕೆಂಪು ಸಮುದ್ರಕ್ಕೂ ನಡುವೆ ಬಾಳ್ಚೆಫೋನಿಗೆ ಎದುರಾಗಿ ಇಳಿದುಕೊಳ್ಳಬೇಕೆಂದು ಅವರಿಗೆ ಹೇಳು. ಅದರ ಎದುರಾಗಿಯೇ ಸಮುದ್ರದ ಬಳಿಯಲ್ಲೇ ಅವರು ಇಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ಫರೋಹನು ಅದನ್ನು ಕಂಡು ಇಸ್ರಾಯೇಲರನ್ನು ಕುರಿತು, ‘ಅವರಿಗೆ ದಾರಿತಪ್ಪಿದೆ, ಎಲ್ಲಾ ಕಡೆಯಲ್ಲಿಯೂ ಮರುಭೂಮಿ ಅವರನ್ನು ಸುತ್ತುವರಿದಿದೆ’ ಎಂದು ಅಂದುಕೊಳ್ಳುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ನಾನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸುವೆನು. ಆದುದರಿಂದ ಅವನು ಅವರನ್ನು ಬೆನ್ನಟ್ಟಿ ಬರುವನು. ಆಗ ನಾನು ಫರೋಹನಲ್ಲಿಯೂ, ಅವನ ಸೈನ್ಯದಲ್ಲಿಯೂ ಮಹಿಮೆಗೊಳ್ಳುವೆನು. ‘ನಾನೇ ಯೆಹೋವನು’ ಎಂದು ಐಗುಪ್ತ್ಯರಿಗೆ ತಿಳಿದು ಬರುವುದು” ಎಂದು ಹೇಳಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರಾಯೇಲರು ನಡೆದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ಇಸ್ರಾಯೇಲರು ಓಡಿಹೋದರೆಂಬ ವರ್ತಮಾನವು ಐಗುಪ್ತದ ಅರಸನಾದ ಫರೋಹನಿಗೆ ತಿಳಿದುಬಂದಾಗ, ಅವರ ವಿಷಯದಲ್ಲಿ ಫರೋಹನ ಮತ್ತು ಅವನ ಪರಿವಾರದವರ ಹೃದಯವು ಅವರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಕಠಿಣಗೊಂಡಿತು. ಅವರು, “ಇದೇನು ನಾವು ಮಾಡಿದ್ದು? ನಮಗೆ ದಾಸರಾಗಿದ್ದ ಇಸ್ರಾಯೇಲರನ್ನು ಹೊರಟು ಹೋಗುವುದಕ್ಕೆ ಬಿಟ್ಟೆವಲ್ಲಾ” ಎಂದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ಆಗ ಫರೋಹನು ತನ್ನ ರಥಬಲವನ್ನು ಸಿದ್ಧಪಡಿಸಿಕೊಂಡು ತನ್ನ ಭಟರೊಡನೆ ಹೊರಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ಶ್ರೇಷ್ಠವಾದ ಆರುನೂರು ರಥಗಳನ್ನೂ, ಐಗುಪ್ತ ದೇಶದ ಎಲ್ಲಾ ರಥಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬೆನ್ನಟ್ಟಿ ಹೋದನು. ಆ ಎಲ್ಲಾ ರಥಗಳಲ್ಲಿ ಅಧಿಪತಿಗಳನ್ನೂ ಕರೆಸಿ ಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ಯೆಹೋವನು ಐಗುಪ್ತ ದೇಶದ ಅರಸನಾದ ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸಿದ್ದರಿಂದ ಅವನು ಇಸ್ರಾಯೇಲರನ್ನು ಬೆನ್ನಟ್ಟಿಹೋದನು. ಆದರೆ ಇಸ್ರಾಯೇಲರು ಯುದ್ಧಸನ್ನದ್ಧರಾಗಿ ಹೊರಟು ಬಂದಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ಐಗುಪ್ತ್ಯರು ಅಂದರೆ ಫರೋಹನ ಕುದುರೆಗಳೂ, ರಥಗಳೂ, ಅವನ ರಾಹುತರೂ, ಸೈನ್ಯದವರೆಲ್ಲರೂ ಅವರ ಹಿಂದೆ ಹೊರಟು ಇಸ್ರಾಯೇಲರು ಪೀಹಹೀರೋತಿನ ಹತ್ತಿರ ಬಾಳ್ಚೆಫೋನಿನ ಎದುರಾಗಿ ಸಮುದ್ರ ತೀರದಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುತ್ತಿರುವಾಗಲೇ ಅವರ ಸಮೀಪಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ಫರೋಹನು ಸಮೀಪಿಸುತ್ತಿರುವಾಗ ಇಸ್ರಾಯೇಲರು ಕಣ್ಣೆತ್ತಿ ತಮ್ಮ ಹಿಂದೆ ಹೊರಟು ಬಂದಿದ್ದ ಐಗುಪ್ತ್ಯರನ್ನು ಕಂಡು, ಬಹಳ ಭಯಪಟ್ಟವರಾಗಿ ಯೆಹೋವನಿಗೆ ಮೊರೆಯಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ಅವರು ಮೋಶೆಗೆ, “ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಸಮಾಧಿಗಳಿರಲಿಲ್ಲವೆಂದು ಮರುಭೂಮಿಯಲ್ಲಿ ಸಾಯಲಿ ಎಂದು ನಮ್ಮನ್ನು ಇಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದೆಯೋ? ಯಾಕೆ ನೀನು ನಮಗೆ ಈ ರೀತಿಮಾಡಿ ಐಗುಪ್ತ ದೇಶದಿಂದ ಕರೆದುಕೊಂಡು ಬಂದೆ? ");
INSERT INTO kanirv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ನಾವು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿರುವಾಗಲೇ, ‘ನೀನು ನಮ್ಮ ಗೊಡವೆಗೆ ಬರಬೇಡ. ನಾವು ಐಗುಪ್ತ್ಯರಿಗೆ ದಾಸರಾಗಿಯೇ ಇರುವೆವು’ ಎಂಬುದಾಗಿ ನಿನಗೆ ಹೇಳಲಿಲ್ಲವೇ. ನಾವು ಈ ಮರುಭೂಮಿಯಲ್ಲಿ ಸಾಯುವುದಕ್ಕಿಂತ ಐಗುಪ್ತ್ಯರಿಗೆ ದಾಸರಾಗಿರುವುದೇ ಮೇಲಲ್ಲವೇ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ಆದರೆ ಮೋಶೆ ಆ ಜನರಿಗೆ, “ನೀವು ಅಂಜಬೇಡಿರಿ. ಸುಮ್ಮನೆ ನಿಂತುಕೊಂಡಿದ್ದು ಯೆಹೋವನು ಈ ಹೊತ್ತು ನಿಮ್ಮನ್ನು ರಕ್ಷಿಸುವ ರೀತಿಯನ್ನು ನೋಡಿರಿ. ನೀವು ಈ ಹೊತ್ತು ನೋಡುವ ಐಗುಪ್ತ್ಯರನ್ನು ಇನ್ನು ಮುಂದೆ ಎಂದಿಗೂ ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ಯೆಹೋವನೇ ನಿಮಗಾಗಿ ಯುದ್ಧಮಾಡುವನು. ನೀವಂತು ಸುಮ್ಮನೇ ನಿಂತುಕೊಂಡಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು ನನಗೆ ಮೊರೆಯಿಡುವುದೇನು? ಮುಂದಕ್ಕೆ ಹೊರಡಬೇಕೆಂದು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ನೀನು ನಿನ್ನ ಕೋಲನ್ನು ಎತ್ತಿ ಸಮುದ್ರದ ಮೇಲೆ ಕೈಚಾಚಿ ಅದನ್ನು ವಿಭಾಗಿಸು, ಆಗ ಇಸ್ರಾಯೇಲರು ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲಿ ಒಣಗಿದ ನೆಲದ ಮೇಲೆ ನಡೆದುಕೊಂಡು ಹೋಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ನಾನಂತೂ ಐಗುಪ್ತ್ಯರ ಹೃದಯಗಳನ್ನು ಕಠಿಣಪಡಿಸುವೆನು. ಅವರು ಇವರನ್ನು ಹಿಂದಟ್ಟುವರು. ಆಗ ನಾನು ಫರೋಹನ ಮೇಲೆಯೂ, ಅವನ ಸಮಸ್ತ ಸೈನ್ಯದವರ ಮೇಲೆಯೂ, ರಥಗಳ ಮೇಲೆಯೂ ಮತ್ತು ಕುದುರೆಗಳ ಮೇಲೆಯೂ ಪ್ರಖ್ಯಾತಿಗೊಳ್ಳುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ನಾನು ಫರೋಹನನಲ್ಲಿಯೂ ಅವನ ರಥಗಳಲ್ಲಿಯೂ, ಕುದುರೆಗಳಲ್ಲಿಯೂ ಪ್ರಖ್ಯಾತಿ ಹೊಂದಿದ ನಂತರ ನಾನೇ ಯೆಹೋವನು ಎಂಬುದನ್ನು ಐಗುಪ್ತ್ಯರು ತಿಳಿದುಕೊಳ್ಳುವರು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ಆಗ ಇಸ್ರಾಯೇಲರ ದಂಡಿನ ಮುಂದೆ ಹೋಗುತ್ತಿದ್ದ ದೇವದೂತನು ತನ್ನ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಅವರ ಹಿಂದಕ್ಕೆ ಬಂದನು. ಅವರ ಮುಂದಾಗಿ ಹೋಗುತ್ತಿದ್ದ ಮೇಘಸ್ತಂಭವು ಅಲ್ಲಿಂದ ಬಂದು ಅವರ ಹಿಂದೆ ನಿಂತುಕೊಂಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ಆ ಮೇಘಸ್ತಂಭವು ಐಗುಪ್ತ್ಯರ ಪಾಳೆಯಕ್ಕೂ, ಇಸ್ರಾಯೇಲರ ಪಾಳೆಯಕ್ಕೂ ನಡುವೆ ಬಂದಿತು. ಅದು ಐಗುಪ್ತ್ಯರಿಗೆ ಕತ್ತಲನ್ನೂ, ಇಸ್ರಾಯೇಲರಿಗೆ ರಾತ್ರಿಯಲ್ಲಿ ಬೆಳಕನ್ನು ಕೊಟ್ಟಿದ್ದರಿಂದ ಆ ರಾತ್ರಿಯೆಲ್ಲಾ ಒಬ್ಬರ ಹತ್ತಿರಕ್ಕೆ ಒಬ್ಬರು ಬರಲಾಗಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ಮೋಶೆ ಸಮುದ್ರದ ಮೇಲೆ ಕೈಚಾಚಿದಾಗ, ಯೆಹೋವನು ಆ ರಾತ್ರಿಯೆಲ್ಲಾ ಮೂಡಣ ದಿಕ್ಕಿನಿಂದ ಬಲವಾದ ಬಿರುಗಾಳಿಯನ್ನು ಬೀಸುವಂತೆ ಮಾಡಿ ಸಮುದ್ರದ ನೀರನ್ನು ಒಂದು ಕಡೆಗೆ ನೂಕಿ ಅದರ ತಳದಲ್ಲಿ ಒಣನೆಲವು ಕಾಣಿಸುವಂತೆ ಮಾಡಿದನು. ನೀರು ಇಬ್ಭಾಗವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ಇಸ್ರಾಯೇಲರು ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲಿ ಒಣನೆಲದಲ್ಲಿ ನಡೆದುಹೋದರು. ನೀರು ಅವರ ಎಡಗಡೆ ಮತ್ತು ಬಲಗಡೆಗಳಲ್ಲಿ ಗೋಡೆಯಂತೆ ನಿಂತುಕೊಂಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ಐಗುಪ್ತ್ಯರೂ ಅಂದರೆ ಫರೋಹನ ಕುದುರೆಗಳೂ, ರಥಗಳೂ, ರಾಹುತರೂ ಅವರನ್ನು ಬೆನ್ನಟ್ಟುವವರಾಗಿ ಅವರ ಹಿಂದೆಯೇ ಸಮುದ್ರದೊಳಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ಬೆಳಗಿನ ಜಾವದಲ್ಲಿ ಯೆಹೋವನು ಆ ಅಗ್ನಿ ಸ್ತಂಭ ಮತ್ತು ಮೇಘ ಸ್ತಂಭದೊಳಗಿನಿಂದ ಐಗುಪ್ತ್ಯರ ದಂಡಿನ ಕಡೆಗೆ ನೋಡಿ ಅವರಲ್ಲಿ ಗಲಿಬಿಲಿಯನ್ನು ಉಂಟುಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ಯೆಹೋವನು ಅವರ ರಥಗಳ ಚಕ್ರದ ಕೀಲುಗಳಲ್ಲಿ ವ್ಯತ್ಯಾಸ ಮಾಡಿಬಿಟ್ಟದ್ದರಿಂದ ಐಗುಪ್ತರು ಬಹು ಕಷ್ಟದಿಂದ ರಥಗಳನ್ನು ಸಾಗಿಸಿಕೊಂಡು ಹೋಗಬೇಕಾಯಿತು. ಆಗ ಐಗುಪ್ತ್ಯರು, “ನಾವು ಇಸ್ರಾಯೇಲರ ಮುಂದೆ ನಿಲ್ಲಲಾರೆವು, ಓಡಿ ಹೋಗೋಣ, ಯೆಹೋವನು ಅವರಿಗೋಸ್ಕರ ನಮಗೆ ವಿರೋಧವಾಗಿ ಯುದ್ಧಮಾಡುತ್ತಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ಅಷ್ಟರಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಸಮುದ್ರದ ಮೇಲೆ ನಿನ್ನ ಕೈಚಾಚು, ಆಗ ಅದರ ನೀರು ಮೊದಲಿನಂತೆ ಬಂದು ಐಗುಪ್ತ್ಯರನ್ನೂ, ಅವರ ರಥಗಳನ್ನೂ, ರಾಹುತರನ್ನೂ ಮುಳುಗಿಸುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ಮೋಶೆ ಸಮುದ್ರದ ಮೇಲೆ ಕೈಚಾಚಿದನು. ಬೆಳಗಾಗುವಾಗಲೇ ಸಮುದ್ರದ ನೀರು ಮೊದಲಿದ್ದಂತೆಯೇ ತುಂಬಿಕೊಂಡಿತು. ಐಗುಪ್ತ್ಯರು ಓಡಿಹೋಗುತ್ತಾ ಅದರ ಎದುರಾಗಿಯೇ ಬಂದರು. ಹೀಗೆ ಯೆಹೋವನು ಐಗುಪ್ತ್ಯರನ್ನು ಸಮುದ್ರದೊಳಗೆ ತಳ್ಳಿಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ನೀರು ಮೊದಲಿನಂತೆ ಬಂದು ಆ ರಥಗಳನ್ನೂ, ರಾಹುತರನ್ನೂ, ಅವರ ಹಿಂದೆ ಸಮುದ್ರದೊಳಗೆ ಹೋಗಿದ್ದ ಫರೋಹನ ಸೈನ್ಯದವರೆಲ್ಲರನ್ನೂ ಮುಳುಗಿಸಿಬಿಟ್ಟಿತ್ತು, ಅವರಲ್ಲಿ ಒಬ್ಬರಾದರೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ಇಸ್ರಾಯೇಲರಾದರೋ, ಸಮುದ್ರದೊಳಗೆ ಒಣನೆಲದಲ್ಲೇ ನಡೆದುಹೋದರು. ನೀರು ಅವರ ಎಡಗಡೆ ಮತ್ತು ಬಲಗಡೆಗಳಲ್ಲಿ ಗೋಡೆಯಂತೆ ನಿಂತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ಆ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ಇಸ್ರಾಯೇಲ್ಯರನ್ನು ಐಗುಪ್ತ್ಯರ ಕೈಯಿಂದ ರಕ್ಷಿಸಿದನು. ಐಗುಪ್ತ್ಯರು ಸತ್ತು ಸಮುದ್ರ ತೀರದಲ್ಲಿ ಬಿದ್ದಿರುವುದನ್ನು ಇಸ್ರಾಯೇಲರು ನೋಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ಯೆಹೋವನು ಐಗುಪ್ತ್ಯರಲ್ಲಿ ಮಾಡಿದ ಈ ಪರಾಕ್ರಮ ಕಾರ್ಯವನ್ನು ಇಸ್ರಾಯೇಲರು ನೋಡಿ ಯೆಹೋವನಿಗೆ ಭಯಪಟ್ಟು ಆತನಲ್ಲಿಯೂ ಆತನ ಸೇವಕನಾದ ಮೋಶೆಯಲ್ಲಿಯೂ ನಂಬಿಕೆಯನ್ನಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ಆಗ ಮೋಶೆಯೂ, ಇಸ್ರಾಯೇಲರೂ ಯೆಹೋವನನ್ನು ಸ್ತುತಿಸುವುದಕ್ಕಾಗಿ ಈ ಕೀರ್ತನೆಯನ್ನು ಹಾಡಿದರು: “ಯೆಹೋವನಿಗೆ ಸ್ತೋತ್ರ ಗಾನಮಾಡೋಣ; ಆತನು ಮಹಾಜಯಶಾಲಿಯಾದವನು. ಕುದುರೆಗಳನ್ನು ಮತ್ತು ರಾಹುತರನ್ನು ಸಮುದ್ರದಲ್ಲಿ ಕೆಡವಿ ನಾಶಮಾಡಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ನನ್ನ ಬಲವೂ, ಕೀರ್ತನೆಯೂ ಯಾಹುವೇ. ಆತನಿಂದ ನನಗೆ ರಕ್ಷಣೆ ಉಂಟಾಯಿತು. ನಮ್ಮ ದೇವರು ಆತನೇ, ಆತನನ್ನು ಸ್ತುತಿಸುವೆನು, ನಮ್ಮ ಪೂರ್ವಿಕರ ದೇವರು ಆತನೇ, ಆತನ ಮಹಿಮೆಯನ್ನು ಪ್ರಖ್ಯಾತಿಪಡಿಸುವೆವು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ಯೆಹೋವನು ಯುದ್ಧವೀರನು; ಯೆಹೋವ ಎಂಬುದು ಆತನ ನಾಮವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ಆತನು ಫರೋಹನ ರಥಗಳನ್ನೂ, ಸ್ಯೆನಿಕರನ್ನೂ ಸಮುದ್ರದಲ್ಲಿ ಕೆಡವಿಹಾಕಿದನು. ಫರೋಹನ ಶ್ರೇಷ್ಠ ವೀರರನ್ನು ಕೆಂಪುಸಮುದ್ರದಲ್ಲಿ ಮುಳುಗಿಸಿ ಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ಆಳವಾದ ಸಾಗರವು ಅವರನ್ನು ಮುಚ್ಚಿಬಿಟ್ಟಿತು. ಅವರು ಕಲ್ಲಿನಂತೆ ಸಮುದ್ರದ ತಳವನ್ನು ಸೇರಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ಯೆಹೋವನೇ, ನಿನ್ನ ಬಲಗೈಯಲ್ಲಿರುವ ಶಕ್ತಿ ಎಷ್ಟೋ ಮಹಿಮೆಯುಳ್ಳದ್ದಾಗಿದೆ. ಯೆಹೋವನೇ, ನಿನ್ನ ಬಲಗೈ ಶತ್ರುಗಳನ್ನು ಪುಡಿಪುಡಿಮಾಡಿಬಿಡುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ನೀನು ಅತ್ಯಧಿಕ ಮಹತ್ವವುಳ್ಳವನಾಗಿ ನಿನ್ನೆದುರಿಗೆ ನಿಲ್ಲುವವರನ್ನು ಕೆಡವಿಬಿಟ್ಟಿರುವೆ. ನಿನ್ನ ಕೋಪಾಗ್ನಿಯು ಹೊರಟು ಅವರನ್ನು ಒಣಗಿದ ಹುಲ್ಲನ್ನೋ ಎಂಬಂತೆ ಸುಟ್ಟು ಭಸ್ಮಮಾಡಿ ಬಿಟ್ಟಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ನಿನ್ನ ಮೂಗಿನ ಶ್ವಾಸದಿಂದ ಸಮುದ್ರದ ನೀರು ಒಟ್ಟುಗೂಡಿದವು; ಪ್ರವಾಹವು ಗೋಡೆಯೋಪಾದಿಯಲ್ಲಿ ನಿಂತುಕೊಂಡಿತು; ಸಾಗರದಾಳದೊಳಗಿನ ನೀರು ಗಟ್ಟಿಯಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ಶತ್ರುವು, ‘ನಾವು ಇವರನ್ನು ಹಿಂದಟ್ಟಿ ಹಿಡಿಯುವೆವು, ಅವರ ಸೊತ್ತನ್ನು ಅಪಹರಿಸಿ ಹಂಚಿಕೊಳ್ಳುವೆವು; ಅವರಲ್ಲಿ ನಮ್ಮ ಬಯಕೆಯನ್ನು ತೀರಿಸಿಕೊಳ್ಳುವೆವು. ನಾವು ಖಡ್ಗವನ್ನು ಹಿಡಿದು; ಶಕ್ತಿಯಿಂದ ಅವರನ್ನು ಸಂಹಾರಮಾಡುವೆವು’ ಎಂಬುದಾಗಿ ಮಾತನಾಡಿಕೊಳ್ಳುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ಆದರೆ ನೀನು ಗಾಳಿಯನ್ನು ಊದಿದಾಗ, ಸಮುದ್ರವು ಅವರನ್ನು ಮುಚ್ಚಿಕೊಂಡಿತು; ಅವರು ಮಹಾಸಾಗರದೊಳಗೆ ಸೀಸದ ಗುಂಡಿನಂತೆ ಮುಳುಗಿಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ಯೆಹೋವನೇ, ದೇವರುಗಳಲ್ಲಿ ನಿನಗೆ ಸಮಾನರು ಯಾರು? ನಿನ್ನ ಹಾಗೆ ಪರಿಶುದ್ಧತ್ವದಲ್ಲಿ ಸರ್ವೋತ್ತಮನು ಮಹಿಮೆ ಹೊಂದಿದವನು, ಭಯಂಕರನೂ, ಅದ್ಭುತ ಕೃತ್ಯಗಳನ್ನು ನಡಿಸುವವನೂ ಆಗಿರುವ ನಿನಗೆ ಸಮಾನರು ಯಾರಿದ್ದಾರೆ? ");
INSERT INTO kanirv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ನೀನು ನಿನ್ನ ಬಲಗೈಯನ್ನು ಚಾಚಿದಾಗ, ಭೂಮಿಯು ಬಾಯ್ದೆರೆದು ಶತ್ರುಗಳನ್ನು ನುಂಗಿಬಿಟ್ಟಿತಲ್ಲಾ. ");
INSERT INTO kanirv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ನಿನ್ನ ಒಡಂಬಡಿಕೆಯ ನಂಬಿಗಸ್ತಿಕೆಯಲ್ಲಿ ನೀನು ನಿನ್ನ ಪ್ರಜೆಯನ್ನು ಬಿಡುಗಡೆ ಮಾಡಿರುವೆ. ನಿನ್ನ ಶಕ್ತಿಯಿಂದ ಅವರನ್ನು ನೀನು ವಾಸಮಾಡುವ ಪರಿಶುದ್ಧ ನಿವಾಸಕ್ಕೆ ನಡೆಸಿರುವೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ಜನಾಂಗಗಳು ಇದನ್ನು ಕೇಳಿ ನಡುಗುವರು. ಫಿಲಿಷ್ಟಿಯದಲ್ಲಿ ವಾಸಿಸುವವರು ಭಯಭೀತರಾಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ಎದೋಮ್ಯರ ಪ್ರಭುಗಳು ದಿಗ್ಭ್ರಮೆಗೊಳ್ಳುವರು; ಮೋವಾಬ್ಯರ ಸೈನಿಕರು ನಡುಗುವರು; ಕಾನಾನಿನ ನಿವಾಸಿಗಳೆಲ್ಲರೂ ಕರಗಿ ಹೋಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ಭಯವೂ, ಹೆದರಿಕೆಯೂ, ಅವರಿಗುಂಟಾಗುವುದು. ನಿನ್ನ ಭುಜಬಲದ ಶಕ್ತಿಯಿಂದ ಅವರು ಕಲ್ಲಿನಂತೆ ಸ್ತಬ್ಧರಾಗುವರು. ಅಷ್ಟರಲ್ಲಿ ಯೆಹೋವನೇ, ನೀನು ಕಾಪಾಡಿದ ನಿನ್ನ ಪ್ರಜೆಗಳು ದಾಟಿ ಹೋಗಿ ದೇಶವನ್ನು ಸೇರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ನೀನು ಅವರನ್ನು ನಿನ್ನ ಸ್ವಕೀಯ ದೇಶವಾಗಿರುವ ಬೆಟ್ಟದ ಸೀಮೆಗೆ ತಂದು ಬಲಪಡಿಸುವಿ, ಯೆಹೋವನೇ, ನೀನು ಸ್ವಂತ ನಿವಾಸಕ್ಕಾಗಿ ಕಟ್ಟಿಕೊಂಡಿರುವ ಸ್ಥಳದವರೆಗೂ ಕರ್ತನೇ, ನೀನು ನಿನಗಾಗಿ ಸಿದ್ಧಪಡಿಸಿಕೊಂಡಿರುವ ಪವಿತ್ರ ಪರ್ವತದವರೆಗೂ ಅವರನ್ನು ಬರಮಾಡುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ಯೆಹೋವನೇ ಯುಗಯುಗಾಂತರಗಳಲ್ಲಿಯೂ ಅರಸನಾಗಿ ಆಳುವವನು.” ");
INSERT INTO kanirv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ಫರೋಹನ ಕುದುರೆಗಳು, ರಥಗಳೂ, ರಾಹುತರೂ ಸಮುದ್ರದೊಳಗೆ ಬಂದಾಗ ಯೆಹೋವನು ಸಮುದ್ರದ ನೀರನ್ನು ಅವರ ಮೇಲೆ ತಿರುಗಿ ಬರಮಾಡಿ ಮುಳುಗಿಸಿಬಿಟ್ಟನು. ಆದರೆ ಇಸ್ರಾಯೇಲರಾದರೋ ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲಿನ ಒಣ ನೆಲದ ಮೇಲೆ ದಾಟಿ ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ಆಗ ಪ್ರವಾದಿನಿಯಾಗಿದ್ದ ಆರೋನನ ಸಹೋದರಿ ಮಿರ್ಯಾಮಳು ಕೈಯಲ್ಲಿ ತಾಳವನ್ನು ತೆಗೆದುಕೊಂಡಳು. ಸ್ತ್ರೀಯರೆಲ್ಲರೂ ಕೈಗಳಲ್ಲಿ ತಾಳಗಳನ್ನು ಹಿಡಿದುಕೊಂಡು ನಾಟ್ಯವಾಡುತ್ತಾ, ಆಕೆಯ ಹಿಂದೆ ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ಮಿರ್ಯಾಮಳು ಅವರಿಗೆ ಹೀಗೆ ಹಾಡಿದಳು: “ಯೆಹೋವನಿಗೆ ಕೀರ್ತನೆ ಹಾಡಿರಿ, ಆತನು ಮಹೋನ್ನತನಾದ ದೇವರಾಗಿದ್ದಾನೆ. ಕುದುರೆಗಳನ್ನೂ, ರಾಹುತರನ್ನೂ ಸಮುದ್ರದಲ್ಲಿ ಮುಳುಗಿಸಿ ನಾಶಮಾಡಿದನು.” ");
INSERT INTO kanirv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ಆನಂತರ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರನ್ನು ಕೆಂಪುಸಮುದ್ರದ ಮೂಲಕವಾಗಿ ನಡೆಸಿದನು. ಅವರು ಶೂರ್ ಮರುಭೂಮಿಯಲ್ಲಿ ಮೂರು ದಿನಗಳು ನೀರಿಲ್ಲದೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ತರುವಾಯ ಅವರು ಮಾರಾ ಎಂಬ ಸ್ಥಳಕ್ಕೆ ಬಂದರು. ಆದರೆ ಆ ಸ್ಥಳದ ನೀರು ಕಹಿಯಾಗಿದ್ದರಿಂದ ಅವರಿಗೆ ಅದನ್ನು ಕುಡಿಯುವುದಕ್ಕೆ ಆಗದೆ ಹೋಯಿತು. ಆದ್ದರಿಂದಲೇ ಆ ಸ್ಥಳಕ್ಕೆ ಮಾರಾ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ಜನರು ಮೋಶೆಗೆ, “ನಾವೇನು ಕುಡಿಯಬೇಕು?” ಎಂದು ಅವನಿಗೆ ವಿರುದ್ಧವಾಗಿ ಗುಣಗುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಿದನು. ಆಗ ಯೆಹೋವನು ಅವನಿಗೆ ಒಂದು ಗಿಡವನ್ನು ತೋರಿಸಿದನು. ಅವನು ಅದನ್ನು ನೀರಿನಲ್ಲಿ ಹಾಕಿದಾಗ, ನೀರು ಸಿಹಿಯಾಯಿತು. ಅಲ್ಲಿ ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರಿಗಾಗಿ ಒಂದು ನಿಯಮವನ್ನು ಮಾಡಿ ಅವರನ್ನು ಪರೀಕ್ಷಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ಯೆಹೋವನು ಅವರಿಗೆ, “ನೀವು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಮಾತನ್ನು ಶ್ರದ್ಧೆಯಿಂದ ಕೇಳಿ, ಆತನ ದೃಷ್ಟಿಗೆ ಸರಿಬೀಳುವುದನ್ನು ಮಾಡಿ, ಆತನ ಆಜ್ಞೆಗಳಿಗೆ ವಿಧೇಯರಾಗಿದ್ದು, ಆತನ ಕಟ್ಟಳೆಗಳನ್ನೆಲ್ಲಾ ಅನುಸರಿಸಿ ನಡೆದರೆ, ನಾನು ಐಗುಪ್ತ್ಯರಿಗೆ ಉಂಟುಮಾಡಿದ ವ್ಯಾಧಿಗಳಲ್ಲಿ ಒಂದನ್ನೂ ನಿಮಗೆ ಬರಗೊಡಿಸುವುದಿಲ್ಲ. ಯೆಹೋವನೆಂಬ ನಾನೇ ನಿಮಗೆ ಆರೋಗ್ಯದಾಯಕನೂ, ನಿಮ್ಮನ್ನು ಗುಣಪಡಿಸುವವನೂ ಆಗಿದ್ದೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ಆ ನಂತರ ಅವರು ಏಲೀಮಿಗೆ ಬಂದರು. ಅಲ್ಲಿ ಹನ್ನೆರಡು ನೀರಿನ ಬುಗ್ಗೆಗಳೂ, ಎಪ್ಪತ್ತು ಖರ್ಜೂರದ ಮರಗಳೂ ಇದ್ದವು. ಆ ನೀರಿನ ಬಳಿಯಲ್ಲಿ ಅವರು ಇಳಿದು ಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ಇಸ್ರಾಯೇಲರ ಸಮೂಹವೆಲ್ಲಾ ಏಲೀಮಿನಿಂದ ಪ್ರಯಾಣ ಮಾಡಿ ಅವರು ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಟ ಎರಡನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ಎಲೀಮಿಗೂ ಸೀನಾಯಿ ಬೆಟ್ಟಕ್ಕೂ ನಡುವೆಯಿರುವ ಸೀನ್ ಎಂಬ ಮರುಭೂಮಿಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ಆಗ ಇಸ್ರಾಯೇಲರ ಸಮೂಹವೆಲ್ಲಾ ಮರುಭೂಮಿಯಲ್ಲಿ ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಮೇಲೆ ಗುಣುಗುಟ್ಟತೊಡಗಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ಇಸ್ರಾಯೇಲರು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ, “ಈ ಸಮೂಹವನ್ನೆಲ್ಲಾ ಹಸಿವೆಯಿಂದ ಸಾಯಿಸಬೇಕೆಂದು ನೀವು ನಮ್ಮನ್ನು ಈ ಮರುಭೂಮಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದಿದ್ದೀರಿ. ನಾವು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿದ್ದಾಗ ಮಾಂಸದ ಪಾತ್ರೆಗಳ ಬಳಿಯಲ್ಲಿ ಕುಳಿತುಕೊಂಡು ಹೊಟ್ಟೆತುಂಬಾ ರೊಟ್ಟಿಯನ್ನು ತಿನ್ನುತ್ತಿದ್ದಾಗ ಯೆಹೋವನ ಕೈಯಿಂದ ಸತ್ತು ಹೋಗಿದ್ದರೆ ಎಷ್ಟೋ ಒಳ್ಳೆಯದಾಗಿತ್ತು” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನು ಆಕಾಶದಿಂದ ನಿಮಗಾಗಿ ಆಹಾರವನ್ನು ಸುರಿಸುತ್ತೇನೆ. ಜನರು ಪ್ರತಿದಿನವೂ ಹೊರಗೆ ಹೋಗಿ ಆ ದಿನಕ್ಕೆ ಬೇಕಾಗುವಷ್ಟನ್ನು ಮಾತ್ರ ಕೂಡಿಸಿಕೊಳ್ಳಬೇಕು. ಇದರಿಂದ ಅವರು ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಅನುಸರಿಸಿ ನಡೆಯುವರೋ ಇಲ್ಲವೋ ಎಂದು ಪರೀಕ್ಷಿಸುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ಆರನೆಯ ದಿನದಲ್ಲಿ ಮಾತ್ರ ಅವರು ತಂದದ್ದನ್ನು ಸಿದ್ಧಮಾಡುವಾಗ ಅದು ಪ್ರತಿದಿನದಲ್ಲಿ ಕೂಡಿಸಿಕೊಂಡದ್ದಕ್ಕಿಂತಲೂ ಎರಡರಷ್ಟಾಗಿರುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಇಸ್ರಾಯೇಲರಿಗೆ, “ನಿಮ್ಮನ್ನು ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದಾತನು ಯೆಹೋವನೇ ಎಂಬುದು ಇಂದು ಸಾಯಂಕಾಲದಲ್ಲಿ ನಿಮಗೆ ಗೊತ್ತಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ಮುಂಜಾನೆಯಲ್ಲಿ ಯೆಹೋವನ ಮಹಿಮೆಯು ನಿಮಗೆ ಕಾಣಿಸುವುದು, ಏಕೆಂದರೆ ನೀವು ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ಗುಣುಗುಟ್ಟಿದ್ದನ್ನು ಆತನು ಕೇಳಿದ್ದಾನೆ. ನಮ್ಮ ಮೇಲೆ ನೀವು ಗುಣುಗುಟ್ಟುವುದೇನು? ನಾವು ಎಷ್ಟು ಮಾತ್ರದವರು?” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ಆಗ ಮೋಶೆ, “ಯೆಹೋವನು ಸಾಯಂಕಾಲದ ಹೊತ್ತಿನಲ್ಲಿ ನಿಮಗೆ ಮಾಂಸಾಹಾರವನ್ನೂ, ಮುಂಜಾನೆಯಲ್ಲಿ ಬೇಕಾದಷ್ಟು ರೊಟ್ಟಿಯನ್ನೂ ಕೊಡುವನು. ನಿಮ್ಮ ಗುಣುಗುಟ್ಟುವಿಕೆಯು ಯೆಹೋವನಿಗೆ ಕೇಳಿಸಿತು. ನಾನು ಮತ್ತು ಆರೋನನು ಎಷ್ಟರವರು? ನಿಮ್ಮ ಗುಣುಗುಟ್ಟುವಿಕೆ ಯೆಹೋವನ ವಿರುದ್ಧವೇ ಹೊರತು ನಮ್ಮ ವಿರುದ್ಧವಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ನೀನು ಇಸ್ರಾಯೇಲರ ಸಮೂಹದ ಬಳಿಗೆ ಹೋಗಿ ಅವರಿಗೆ, ‘ಯೆಹೋವನು ನಿಮ್ಮ ಗುಣುಗುಟ್ಟುವಿಕೆಯನ್ನು ಕೇಳಿದ್ದಾನೆ. ಆದುದರಿಂದ ನೀವೆಲ್ಲರೂ ಆತನ ಸನ್ನಿಧಿಗೆ ಒಟ್ಟಾಗಿ ಸೇರಿ ಬರಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ಆರೋನನು ಇಸ್ರಾಯೇಲರ ಸಮೂಹಕ್ಕೆಲ್ಲಾ ಈ ಮಾತುಗಳನ್ನು ತಿಳಿಸುತ್ತಿರುವಾಗ, ಅವರು ಮರುಭೂಮಿಯ ಕಡೆಗೆ ನೋಡಲಾಗಿ, ಮೇಘದಲ್ಲಿ ಯೆಹೋವನ ತೇಜಸ್ಸು ಅವರಿಗೆ ಕಾಣಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“ಇಸ್ರಾಯೇಲರ ಗುಣುಗುಟ್ಟುವಿಕೆಯು ನನಗೆ ಕೇಳಿಸಿತು. ನೀನು ಅವರಿಗೆ, ‘ನೀವು ಸಾಯಂಕಾಲದಲ್ಲಿ ಮಾಂಸವನ್ನೂ, ಮುಂಜಾನೆಯಲ್ಲಿ ಬೇಕಾದಷ್ಟು ರೊಟ್ಟಿಯನ್ನೂ ತಿನ್ನುವಿರಿ. ಇದರಿಂದ ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಎಂಬುದು ನಿಮಗೆ ಗೊತ್ತಾಗುವುದೆಂದು ಹೇಳಬೇಕು’” ಎಂಬುದೇ. ");
INSERT INTO kanirv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ಸಾಯಂಕಾಲವಾಗುತ್ತಲೇ ಲಾವಕ್ಕಿಗಳು ಬಂದು ಅವರ ಪಾಳೆಯವನ್ನು ತುಂಬಿಕೊಂಡವು. ಅದಲ್ಲದೆ ಹೊತ್ತಾರೆಯಲ್ಲಿ ಮಂಜು ಪಾಳೆಯದ ಸುತ್ತಲೂ ಬಿದ್ದಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ಆ ಮಂಜು ಕರಗಿ ಹೋದ ಮೇಲೆ ಮರುಭೂಮಿಯ ನೆಲದಲ್ಲಿ ಮಂಜಿನ ಹನಿಗಳಂತೆ ಏನೋ ಸಣ್ಣ ಸಣ್ಣ ರವೆಗಳು ಕಾಣಿಸಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ಇಸ್ರಾಯೇಲರು ಅದನ್ನು ಕಂಡು ಒಬ್ಬರಿಗೊಬ್ಬರು, “ಇದೇನಿರಬಹುದು?” ಎಂದು ಅಂದುಕೊಂಡರು. ಅದು ಏನೆಂದು ಅವರಿಗೆ ತಿಳಿಯಲಿಲ್ಲ. ಮೋಶೆ ಅವರಿಗೆ, “ಇದು ಯೆಹೋವನು ನಿಮಗಾಗಿ ತಿನ್ನುವುದಕ್ಕೆ ಕೊಟ್ಟಿರುವ ರೊಟ್ಟಿಯಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ಯೆಹೋವನು ಇದರ ವಿಷಯದಲ್ಲಿ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ: ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನ ಕುಟುಂಬದವರ ಸಂಖ್ಯಾನುಸಾರ ತಲೆಗೆ ಮೂರು ಸೇರಿನಂತೆ ತನ್ನ ಡೇರೆಯವರಿಗಾಗಿ ಕೂಡಿಸಿಕೊಳ್ಳಲಿ. ಪ್ರತಿಯೊಬ್ಬನು ತಾನು ಎಷ್ಟು ತಿನ್ನುವನೋ ಅದರ ಪ್ರಾಕಾರ ನೀವು ಕೂಡಿಸಿಕೊಳ್ಳಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ಇಸ್ರಾಯೇಲರು ಹಾಗೆಯೇ ಮಾಡಿದರು. ಕೆಲವರು ಹೆಚ್ಚಾಗಿ, ಕೆಲವರು ಕಡಿಮೆಯಾಗಿ ಕೂಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ಅವರು ಅದನ್ನು ಸೇರಿನಿಂದ ಅಳತೆಮಾಡಿದರು. ಬಹಳ ಕೂಡಿಸಿದವನಿಗೆ ಏನೂ ಹೆಚ್ಚಾಗಲಿಲ್ಲ, ಸ್ವಲ್ಪವಾಗಿ ಕೂಡಿಸಿದವನಿಗೆ ಏನೂ ಕಡಿಮೆಯಾಗಲಿಲ್ಲ. ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ಭೋಜನಕ್ಕೆ ಸರಿಯಾಗುವಷ್ಟನ್ನು ಕೂಡಿಸಿಕೊಂಡಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ಅದಲ್ಲದೆ ಮೋಶೆ ಅವರಿಗೆ, “ಇದನ್ನು ಯಾರೂ ಮರು ದಿನದವರೆಗೆ ಇಟ್ಟುಕೊಳ್ಳಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ಆದಾಗ್ಯೂ ಅವರು ಮೋಶೆಯ ಮಾತನ್ನು ಕೇಳದೆ, ಅದರಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಮರು ದಿನದವರೆಗೆ ಇಟ್ಟುಕೊಂಡಾಗ ಅದು ಹುಳ ಬಿದ್ದು ಹೊಲಸುವಾಸನೆ ಹಿಡಿದು ಕೆಟ್ಟುಹೋಯಿತು. ಅದಕ್ಕೆ ಮೋಶೆ ಅವರ ಮೇಲೆ ಕೋಪಗೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ಜನರು ಪ್ರತಿದಿನ ಮುಂಜಾನೆಯಲ್ಲಿ ತಮ್ಮ ಭೋಜನಕ್ಕೆ ತಕ್ಕಷ್ಟು ಕೂಡಿಸಿಕೊಂಡರು. ಬಿಸಿಲು ಹೆಚ್ಚಾದಾಗ ಅದು ಕರಗಿಹೋಗುತ್ತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ಆರನೆಯ ದಿನ ಎರಡರಷ್ಟು ಆಹಾರವು, ಅಂದರೆ ಒಬ್ಬೊಬ್ಬನಿಗೆ ಎರಡೆರಡು ಸೇರಿನಂತೆ ಆರಿಸಿ ತುಂಬಿಟ್ಟುಕೊಂಡಿದ್ದರಿಂದ ಸಮೂಹದ ಅಧಿಕಾರಿಗಳೆಲ್ಲರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು ಈ ಸಂಗತಿಯನ್ನು ತಿಳಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ಅದಕ್ಕೆ ಅವನು, “ಇದು ಯೆಹೋವನು ಹೇಳಿದ ಮಾತು, ‘ನಾಳೆ ಯೆಹೋವನಿಗೆ ವಿಶ್ರಾಂತಿಯ ಪರಿಶುದ್ಧ ಸಬ್ಬತ ದಿನವಾಗಿದೆ. ಈ ದಿನವೇ ಸುಡಬೇಕಾದದ್ದನ್ನು ಸುಟ್ಟು, ಬೇಯಿಸಬೇಕಾದದ್ದನ್ನು ಬೇಯಿಸಿರಿ. ಇದರಲ್ಲಿ ಮಿಕ್ಕಾದದ್ದನ್ನೆಲ್ಲಾ ನಾಳೆಯವರೆಗೆ ಇಟ್ಟುಕೊಳ್ಳಿರಿ’” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ಮೋಶೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವರು ಮರು ದಿನದವರೆಗೆ ಅದನ್ನು ಇಟ್ಟುಕೊಂಡರು. ಆದರೆ ಅದು ಕೆಟ್ಟು ಹೋಗಿರಲಿಲ್ಲ, ಹುಳ ಬೀಳಲ್ಲೂ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ಆಗ ಮೋಶೆ ಅವರಿಗೆ, “ಈ ಹೊತ್ತು ಅದನ್ನು ಊಟ ಮಾಡಿರಿ. ಈ ದಿನವು ಯೆಹೋವನ ಸಬ್ಬತ್ ದಿನವಾಗಿರುವುದರಿಂದ ಈ ದಿನ ಅದು ಹೊಲದಲ್ಲಿ ಕಾಣಿಸಿಕೊಳ್ಳುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ಆರು ದಿನ ಅದನ್ನು ಕೂಡಿಸಿಡಬೇಕು. ಏಳನೆಯ ದಿನ ಸಬ್ಬತ್ ದಿನವಾಗಿರುವುದರಿಂದ ಅದು ದೊರೆಯುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ಹಾಗೆಯೇ ಆಯಿತು. ಜನರಲ್ಲಿ ಕೆಲವರು ಏಳನೆಯ ದಿನದಲ್ಲಿ ಅದನ್ನು ಕೂಡಿಸಿಕೊಳ್ಳುವುದಕ್ಕೆ ಹೋದಾಗ ಅವರಿಗೆ ಏನೂ ಸಿಕ್ಕಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀವು ಎಲ್ಲಿಯವರೆಗೆ ನನ್ನ ಆಜ್ಞೆಗಳನ್ನೂ, ನಾನು ಮಾಡಿರುವ ನಿಯಮಗಳನ್ನೂ ಅನುಸರಿಸದೆ ಅಲಕ್ಷ್ಯ ಮಾಡುವಿರಿ? ");
INSERT INTO kanirv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ನೋಡಿರಿ, ಯೆಹೋವನು ನಿಮಗೆ ಸಬ್ಬತ್ ದಿನವನ್ನು ಆಚರಿಸಬೇಕೆಂದು ಅಪ್ಪಣೆಕೊಟ್ಟಿರುವುದರಿಂದಲೇ ಆರನೆಯ ದಿನದಲ್ಲಿ ಎರಡು ದಿನದ ಆಹಾರವು ನಿಮಗೆ ದೊರಕುವಂತೆ ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ. ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ತಾನಿರುವ ಸ್ಥಳದಲ್ಲಿ ಇರಬೇಕು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಒಬ್ಬನೂ ತನ್ನ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಹೊರಗೆ ಹೋಗಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ಆದುದರಿಂದ ಏಳನೆಯ ದಿನದಲ್ಲಿ ಜನರು ಕೆಲಸವನ್ನು ಮಾಡದೆ ವಿಶ್ರಮಿಸಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ಇಸ್ರಾಯೇಲರು ಆ ಆಹಾರಕ್ಕೆ “ಮನ್ನ” ಎಂದು ಹೆಸರಿಟ್ಟರು. ಅದು ಬಿಳಿ ಕೊತ್ತುಂಬರಿ ಕಾಳಿನಂತಿದ್ದು ರುಚಿಯಲ್ಲಿ ಜೇನುತುಪ್ಪ ಸವರಿದ ದೋಸೆಯಂತೆ ಇತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ಮೋಶೆಯು ಜನರಿಗೆ, “ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದು ಇದೇ, ‘ನಾನು ಐಗುಪ್ತ ದೇಶದಿಂದ ನಿಮ್ಮನ್ನು ಹೊರಗೆ ಬರಮಾಡಿದಾಗ ಮರುಭೂಮಿಯಲ್ಲಿ ತಿನ್ನುವುದಕ್ಕೆ ಕೊಟ್ಟ ಆಹಾರವನ್ನು ನಿಮ್ಮ ಸಂತಾನದವರು ನೋಡುವ ಹಾಗೆ ಅವರಿಗಾಗಿ ನೀವು ಒಂದು ಸೇರು ಮನ್ನವನ್ನು ತುಂಬಿಸಿ ಸುರಕ್ಷಿತವಾಗಿ ಇಟ್ಟುಕೊಳ್ಳಬೇಕು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ಆದಕಾರಣ ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ನೀನು ಒಂದು ಪಾತ್ರೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದರಲ್ಲಿ ಒಂದು ಸೇರಿನಷ್ಟು ಮನ್ನವನ್ನು ಹಾಕಿ ನಿಮ್ಮ ಸಂತತಿಯವರು ನೋಡುವುದಕ್ಕಾಗಿ ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಇಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ, ಆರೋನನು ಆಜ್ಞಾಶಾಸನ ಮಂಜೂಷದ ಪಕ್ಕದಲ್ಲಿ ಅದನ್ನು ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ಇಸ್ರಾಯೇಲರು ತಾವು ವಾಸಮಾಡಲಿರುವ ಪ್ರದೇಶಕ್ಕೆ ಬರುವವರೆಗೆ ಅಂದರೆ ಕಾನಾನ್ ದೇಶವನ್ನು ಬಂದು ಸೇರುವವರೆಗೆ ನಲ್ವತ್ತು ವರ್ಷ ಮನ್ನವನ್ನೇ ಊಟಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ಓಮೆರ್ ಎಂಬುದು ಏಫಾದಲ್ಲಿ ಹತ್ತನೆಯ ಒಂದು ಪಾಲು ಹಿಡಿಯುವಂಥ ಒಂದು ಅಳತೆಯ ಮಾಪನವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ತರುವಾಯ ಇಸ್ರಾಯೇಲರ ಸಮೂಹವೆಲ್ಲಾ ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ “ಸೀನ್” ಎಂಬ ಮರುಭೂಮಿಯಿಂದ ಹೊರಟು ಮುಂದೆ ಪ್ರಯಾಣ ಮಾಡಿ ರೆಫೀದೀಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ಅಲ್ಲಿಯೂ ಜನರಿಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ನೀರು ಇರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ಆದಕಾರಣ ಜನರು ಮೋಶೆಯ ಮೇಲೆ ಗುಣುಗುಟ್ಟುತ್ತಾ, “ನಮಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ನೀರು ದೊರಕಿಸಿಕೊಡಬೇಕು” ಎಂದು ಗದ್ದಲವೆಬ್ಬಿಸಲು, ಮೋಶೆಯು ಅವರಿಗೆ, “ನನ್ನ ಸಂಗಡ ಏಕೆ ಜಗಳವಾಡುತ್ತೀರಿ? ಯೆಹೋವನನ್ನು ಏಕೆ ಪರೀಕ್ಷಿಸುತ್ತೀರಿ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ಅಲ್ಲಿ ಜನರು ಬಾಯಾರಿಕೆಯಿಂದ, ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ಗುಣುಗುಟ್ಟಿ, “ನೀನು ನಮ್ಮನ್ನೂ, ನಮ್ಮ ಮಕ್ಕಳನ್ನೂ, ದನಗಳನ್ನೂ ಐಗುಪ್ತ ದೇಶದಿಂದ ಇಲ್ಲಿಗೆ ಕರೆದುತಂದು ಈಗ ನೀರಿಲ್ಲದೆ ಸಾಯುವ ಹಾಗೆ ಮಾಡಿದ್ದೇಕೆ?” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ಆಗ ಮೋಶೆ ಯೆಹೋವನಿಗೆ ಮೊರೆಯಿಟ್ಟು, “ಈ ಜನರಿಗಾಗಿ ನಾನೇನು ಮಾಡಲಿ? ಅವರು ನನ್ನನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲುವ ಹಾಗಿದ್ದಾರಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ಅದಕ್ಕೆ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ನೈಲ್ ನದಿಯನ್ನು ಹೊಡೆದ ಕೋಲನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡು ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರಲ್ಲಿ ಕೆಲವರನ್ನು ಕರೆದುಕೊಂಡು ಜನರ ಮುಂದೆ ಹೊರಟು, ನಾನು ತೋರಿಸುವ ಸ್ಥಳಕ್ಕೆ ಹೋಗು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ಅಲ್ಲಿ ಹೋರೇಬಿನಲ್ಲಿರುವ ಬಂಡೆಯ ಮೇಲೆ ನಾನೇ ನಿನಗೆದುರಾಗಿ ನಿಂತುಕೊಳ್ಳುವೆನು. ನೀನು ಆ ಬಂಡೆಯನ್ನು ಹೊಡೆದಾಗ, ಜನರು ಕುಡಿಯುವಂತೆ ನೀರು ಹೊರಗೆ ಬರುವುದು” ಎಂದನು. ಮೋಶೆ ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರ ಎದುರಿನಲ್ಲಿ ಹಾಗೆಯೇ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ಇಸ್ರಾಯೇಲರು, “ಯೆಹೋವನು ನಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಇದ್ದಾನೋ ಇಲ್ಲವೋ?” ಎಂದು ಯೆಹೋವನನ್ನು ಅಲ್ಲಿ ಪರೀಕ್ಷಿಸಿದ್ದರಿಂದ, ಮೋಶೆ ಆ ಸ್ಥಳಕ್ಕೆ ಮಸ್ಸಾ ಎಂತಲೂ ಅವರು ಗದ್ದಲ ಮಾಡಿದ್ದರಿಂದ ಅದಕ್ಕೆ ಮೆರೀಬಾ ಎಂತಲೂ ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ಅಮಾಲೇಕ್ಯರು ರೆಫೀದೀಮಿನಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಯುದ್ಧಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ಆಗ ಮೋಶೆಯು ಯೆಹೋಶುವನಿಗೆ, “ನೀನು ನಮ್ಮ ಜನರಲ್ಲಿ ಕೆಲವರನ್ನು ಆರಿಸಿಕೊಂಡು ಅಮಾಲೇಕ್ಯರೊಡನೆ ಯುದ್ಧಮಾಡಬೇಕು. ನಾನು ನಾಳೆ ದೇವರ ಕೋಲನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡು ಗುಡ್ಡದ ಮೇಲೆ ನಿಂತುಕೊಳ್ಳುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ಮೋಶೆಯ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಯೆಹೋಶುವನು ಅಮಾಲೇಕ್ಯರೊಡನೆ ಯುದ್ಧಮಾಡಿದನು. ಮೋಶೆಯೂ, ಆರೋನನೂ ಮತ್ತು ಹೂರನು ಗುಡ್ಡದ ಮೇಲೆ ಏರಿ ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ಮೋಶೆಯು ತನ್ನ ಕೈಗಳನ್ನು ಮೇಲಕ್ಕೆ ಎತ್ತಿದಾಗ ಇಸ್ರಾಯೇಲರು ಬಲಗೊಳ್ಳುವರು. ಅವನು ತನ್ನ ಕೈಯನ್ನು ಇಳಿಸಿದಾಗ ಅಮಾಲೇಕ್ಯರು ಬಲಗೊಳ್ಳುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ಮೋಶೆಯ ಕೈಗಳು ಭಾರವಾದಾಗ, ಆರೋನ ಮತ್ತು ಹೂರನು ಒಂದು ಕಲ್ಲನ್ನು ತಂದು ಇಟ್ಟರು. ಮೋಶೆಯು ಅದರ ಮೇಲೆ ಕುಳಿತುಕೊಂಡನು. ಆರೋನನು ಒಂದು ಕಡೆಯಲ್ಲಿಯೂ, ಹೂರನು ಇನ್ನೊಂದು ಕಡೆಯಲ್ಲಿಯೂ ನಿಂತುಕೊಂಡು ಮೋಶೆಯ ಕೈಗಳನ್ನು ಎತ್ತಿ ಹಿಡಿಯಲು ಸಹಾಯ ಮಾಡಿದರು. ಹೀಗೆ ಅವನ ಕೈಗಳು ಸೂರ್ಯನು ಮುಳುಗುವವರೆಗೆ ಕೆಳಗಿಳಿಸದೆ ಇದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ಯೆಹೋಶುವನು ಅಮಾಲೇಕ್ಯರನ್ನು ಮತ್ತು ಅವರ ಭಟರನ್ನು ಖಡ್ಗದಿಂದ ಸೋಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಇದನ್ನು ಜ್ಞಾಪಕಾರ್ಥಕವಾಗಿ ಒಂದು ಗ್ರಂಥದಲ್ಲಿ ಬರೆ. ಅದನ್ನು ಯೆಹೋಶುವನಿಗೆ ತಿಳಿಸು. ಏಕೆಂದರೆ ನಾನು ಅಮಾಲೇಕ್ಯರ ನೆನಪು ಭೂಮಿಯ ಮೇಲೆ ಇರದಂತೆ ಸಂಪೂರ್ಣವಾಗಿ ನಾಶಮಾಡಿ ಬಿಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ಆ ಸ್ಥಳದಲ್ಲಿ ಮೋಶೆಯು ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸಿ ಅದಕ್ಕೆ “ಯೆಹೋವ ನಿಸ್ಸಿ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ಮೋಶೆಯು, “ಅಮಾಲೇಕ್ಯರ ಕೈಯು ಯೆಹೋವನ ಸಿಂಹಾಸನಕ್ಕೆ ವಿರೋಧವಾಗಿ ಎತ್ತಲ್ಪಟ್ಟಿದ್ದರಿಂದ ಯೆಹೋವನ ಸಿಂಹಾಸನದಾಣೆಗೂ ಅಮಾಲೇಕ್ಯರ ಮೇಲೆ ಯೆಹೋವನಿಗೆ ತಲತಲಾಂತರಗಳಲ್ಲಿ ಯುದ್ಧವಿರುವುದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ದೇವರು ಮೋಶೆಗೂ ತನ್ನ ಜನರಾದ ಇಸ್ರಾಯೇಲರಿಗೂ ಮಹೋಪಕಾರಗಳನ್ನು ಮಾಡಿದ್ದನ್ನೂ, ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಕರತಂದದ್ದನ್ನೂ, ಮಿದ್ಯಾನ್ಯರ ಆಚಾರ್ಯನೂ ಮೋಶೆಯ ಮಾವನೂ ಆಗಿದ್ದ ಇತ್ರೋವನು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ಆಗ ಮೋಶೆಯ ಮಾವನಾದ ಇತ್ರೋವನು ತನ್ನ ಬಳಿಗೆ ಕಳುಹಿಸಲ್ಪಟ್ಟಿದ್ದ ಮೋಶೆಯ ಹೆಂಡತಿಯಾದ ಚಿಪ್ಪೋರಳನ್ನೂ, ಆಕೆಯ ಇಬ್ಬರು ಗಂಡು ಮಕ್ಕಳನ್ನೂ ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ಆ ಪುತ್ರರಲ್ಲಿ ಒಬ್ಬನಿಗೆ “ಗೇರ್ಷೋಮ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ಏಕೆಂದರೆ ಮೋಶೆಯು, “ನಾನು ಅನ್ಯದೇಶದಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ತನ್ನ ಇನ್ನೊಬ್ಬ ಮಗನಿಗೆ ಮೋಶೆಯು, “ನನ್ನ ತಂದೆಯ ದೇವರು ನನಗೆ ಸಹಾಯಕನಾಗಿದ್ದು ನನ್ನನ್ನು ಫರೋಹನ ಕತ್ತಿಗೆ ತಪ್ಪಿಸಿ ಕಾಪಾಡಿದನು” ಎಂದು ಹೇಳಿ, ಆ ಮಗನಿಗೆ “ಎಲೀಯೆಜೆರ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ಮೋಶೆಯ ಮಾವನಾದ ಇತ್ರೋವನು ಮೋಶೆಯ ಮಕ್ಕಳನ್ನು, ಹೆಂಡತಿಯನ್ನು ಕರೆದುಕೊಂಡು ಮರುಭೂಮಿಯಲ್ಲಿ ದೇವರ ಬೆಟ್ಟದ ಹತ್ತಿರ ಇಳಿದುಕೊಂಡಿದ್ದ ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ಅವನು ಮೋಶೆಗೆ, “ನಿನ್ನ ಮಾವನಾದ ಇತ್ರೋವನಾದ ನಾನು ನಿನ್ನ ಹೆಂಡತಿಯನ್ನು, ನಿನ್ನ ಇಬ್ಬರು ಮಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ನಿನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ಮೋಶೆಯು ತನ್ನ ಮಾವನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕೆ ಹೊರಟು ಆತನನ್ನು ವಂದಿಸಿ ಮುದ್ದಿಟ್ಟನು. ಅವರು ಪರಸ್ಪರ ಯೋಗಕ್ಷೇಮವನ್ನು ವಿಚಾರಿಸಿದ ಮೇಲೆ ಡೇರೆಯೊಳಗೆ ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ಆ ನಂತರ ಮೋಶೆಯು ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರ ಪರವಾಗಿ ಫರೋಹನಿಗೂ, ಐಗುಪ್ತ್ಯರಿಗೂ ಮಾಡಿದ್ದೆಲ್ಲವನ್ನೂ, ದಾರಿಯಲ್ಲಿ ತಮಗುಂಟಾದ ಎಲ್ಲಾ ಕಷ್ಟಗಳನ್ನೂ, ಯೆಹೋವನು ಆ ಕಷ್ಟಗಳಿಂದ ತಪ್ಪಿಸಿದ್ದನ್ನೂ ತನ್ನ ಮಾವನಿಗೆ ವಿವರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ಯೆಹೋವನು ಐಗುಪ್ತ್ಯರ ಕೈಯಿಂದ ಇಸ್ರಾಯೇಲರನ್ನು ಬಿಡಿಸಿ ಅವರಿಗೆ ಉಪಕಾರವನ್ನು ಮಾಡಿದ್ದಕ್ಕಾಗಿ ಇತ್ರೋವನು ಸಂತೋಷ ಪಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ಇತ್ರೋವನು, “ಐಗುಪ್ತ್ಯರ ಕೈಯಿಂದಲೂ, ಫರೋಹನ ಕೈಯಿಂದಲೂ ನಿಮ್ಮನ್ನು ಬಿಡುಗಡೆ ಮಾಡಿದ ಯೆಹೋವನಿಗೆ ಸ್ತೋತ್ರವಾಗಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ಯೆಹೋವನು ತನ್ನ ಜನರನ್ನು ಅವರ ಕೈಯಿಂದ ಬಿಡಿಸಿ, ಆ ಐಗುಪ್ತ್ಯರು ಯಾವ ವಿಷಯದಲ್ಲಿ ಗರ್ವಪಡುತ್ತಿದ್ದರೋ, ಆ ವಿಷಯದಲ್ಲಿ ಅವರನ್ನು ತಗ್ಗಿಸಿದ್ದರಿಂದ ಯೆಹೋವನು ಎಲ್ಲಾ ದೇವರುಗಳಿಗಿಂತಲೂ ದೊಡ್ಡವನೆಂದು ಈಗ ತಿಳಿದುಕೊಂಡಿದ್ದೇನೆ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ಇದಲ್ಲದೆ ಮೋಶೆಯ ಮಾವನಾದ ಇತ್ರೋವನು ದೇವರಿಗೆ ಸರ್ವಾಂಗಹೋಮ ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ಆರೋನನು, ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರೆಲ್ಲರೂ ಅವನ ಸಂಗಡ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಹಭೋಜನವನ್ನು ಮಾಡುವುದಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ಮರುದಿನ ಮೋಶೆ ಜನರಿಗೆ ನ್ಯಾಯತೀರಿಸುವುದಕ್ಕಾಗಿ ಕುಳಿತಿರಲು ಮುಂಜಾನೆಯಿಂದ ಸಾಯಂಕಾಲದವರೆಗೂ ಜನರು ಅವನ ಹತ್ತಿರ ನಿಂತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ಮೋಶೆಯು ಜನರಿಗಾಗಿ ಮಾಡುತ್ತಿರುವುದೆಲ್ಲವನ್ನು ಮಾವನು ನೋಡಿ ಅವನಿಗೆ, “ನೀನು ಯಾತಕ್ಕೆ ಜನರಿಗಾಗಿ ಇಷ್ಟು ಪ್ರಯಾಸ ಪಡುತ್ತಿರುವೆ? ನೀನು ಒಬ್ಬನೇ ನ್ಯಾಯತೀರಿಸುವುದಕ್ಕೆ ಕುಳಿತಿರುವುದೇಕೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ಮೋಶೆ ತನ್ನ ಮಾವನಿಗೆ, “ದೇವರ ನಡೆಸುವಿಕೆಯನ್ನು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಜನರು ನನ್ನ ಹತ್ತಿರ ಬರುತ್ತಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ಹಾಗೆಯೇ ಅವರೊಳಗೆ ವ್ಯಾಜ್ಯವೇನಾದರೂ ಉಂಟಾಗಿದ್ದರೆ ನನ್ನ ಬಳಿಗೆ ಬರುತ್ತಾರೆ. ನಾನು ವಿಚಾರಣೆ ಮಾಡಿ ಅವರಿಗೆ ನ್ಯಾಯತೀರಿಸಿ ದೇವರ ಆಜ್ಞಾವಿಧಿಗಳನ್ನು ಬೋಧಿಸುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ಅದನ್ನು ಕೇಳಿ ಮೋಶೆಯ ಮಾವನು ಅವನಿಗೆ, “ನೀನು ಮಾಡುತ್ತಿರುವ ಈ ಕಾರ್ಯವಿಧಾನ ಸರಿಯಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ಈ ಕೆಲಸ ಬಹಳ ಕಷ್ಟವಾದದ್ದು. ನಿನ್ನೊಬ್ಬನಿಂದಲೇ ಅದನ್ನು ನಡೆಸಲಾಗದು. ನೀನು ನಿನ್ನ ಸಂಗಡ ಇರುವ ಈ ಜನರೂ ನಿಶ್ಚಯವಾಗಿ ಬಳಲಿಹೋಗುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ನನ್ನ ಮಾತನ್ನು ಕೇಳು. ನಾನು ನಿನಗೆ ಒಂದು ಆಲೋಚನೆಯನ್ನು ಹೇಳುತ್ತೇನೆ ಮತ್ತು ದೇವರು ನಿನ್ನ ಸಂಗಡ ಇರಲಿ. ನೀನು ಜನರಿಗೂ, ದೇವರಿಗೂ ಮಧ್ಯಸ್ಥನಾಗಿದ್ದು ಜನರ ವ್ಯಾಜ್ಯಗಳನ್ನು ದೇವರ ಹತ್ತಿರಕ್ಕೆ ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ನೀನು ದೇವರ ಆಜ್ಞಾವಿಧಿಗಳನ್ನು ಬೋಧಿಸಿ, ಅವರು ನಡೆಯಬೇಕಾದ ಮಾರ್ಗವನ್ನೂ, ಮಾಡಬೇಕಾದ ಕಾರ್ಯಗಳನ್ನೂ ಅವರಿಗೆ ತಿಳಿಯಪಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ಆದರೆ ನೀನು ಸಮಸ್ತ ಜನರೊಳಗೆ ಸಮರ್ಥರೂ, ಭಕ್ತರೂ, ನಂಬಿಗಸ್ತರೂ, ಲಂಚಮುಟ್ಟದವರೂ ಆಗಿರುವ ಪುರುಷರನ್ನು ಆರಿಸಿಕೊಂಡು ಅವರನ್ನು ಸಾವಿರ ಮಂದಿಯ ಮೇಲೆಯೂ, ನೂರು ಮಂದಿಯ ಮೇಲೆಯೂ, ಐವತ್ತು ಮಂದಿಯ ಮೇಲೆಯೂ, ಹತ್ತು ಮಂದಿಯ ಮೇಲೆಯೂ ಅಧಿಕಾರಿಗಳನ್ನಾಗಿ ನೇಮಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ಅವರೇ ಯಾವಾಗಲೂ ಜನರಿಗೆ ನ್ಯಾಯವನ್ನು ತೀರಿಸಲಿ. ಅವರು ದೊಡ್ಡ ವ್ಯಾಜ್ಯಗಳನ್ನು ನಿನ್ನ ಮುಂದೆ ತರಲಿ. ಸಣ್ಣ ವ್ಯಾಜ್ಯಗಳನ್ನೆಲ್ಲಾ ಅವರೇ ತೀರಿಸಲಿ. ಅವರು ನಿನ್ನೊಂದಿಗೆ ಈ ಭಾರವನ್ನು ಹೊರುವುದರಿಂದ ನಿನಗೆ ಸುಲಭವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ದೇವರು ನಿನಗೆ ಹೀಗೆ ಮಾಡುವುದಕ್ಕೆ ಅಪ್ಪಣೆಕೊಡುವುದಾದರೆ, ನೀನು ಈ ಕೆಲಸದ ಹೊರೆಯನ್ನು ನಿರ್ವಹಿಸಲು ಸಾಧ್ಯವಾಗುವುದು. ಇದು ಮಾತ್ರವಲ್ಲದೆ ಈ ಜನರೆಲ್ಲರೂ ಸಂತುಷ್ಟರಾಗಿ ತಮ್ಮ ತಮ್ಮ ಮನೆಗಳಿಗೆ ಹೋಗುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ಮೋಶೆ ತನ್ನ ಮಾವನ ಮಾತಿಗೆ ಒಪ್ಪಿಕೊಂಡು ಅವನು ಹೇಳಿದಂತೆಯೇ ಎಲ್ಲವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಸಮರ್ಥರಾದವರನ್ನು ಆರಿಸಿಕೊಂಡು ಸಾವಿರ ಮಂದಿಯ ಮೇಲೆಯೂ, ನೂರು ಮಂದಿಯ ಮೇಲೆಯೂ, ಐವತ್ತು ಮಂದಿಯ ಮೇಲೆಯೂ, ಹತ್ತು ಮಂದಿಯ ಮೇಲೆಯೂ ಅಧಿಕಾರಿಗಳನ್ನಾಗಿ ನೇಮಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ಇವರು ಯಾವಾಗಲೂ ಜನರಿಗೆ ನ್ಯಾಯತೀರಿಸುವವರಾಗಿ ಕಠಿಣ ವ್ಯಾಜ್ಯಗಳನ್ನು ಮೋಶೆಯ ಬಳಿಗೆ ತರುತ್ತಾ, ಸುಲಭವಾದ ವ್ಯಾಜ್ಯಗಳನ್ನು ತಾವೇ ತೀರಿಸುತ್ತಾ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ತರುವಾಯ ಮೋಶೆ ತನ್ನ ಮಾವನಿಗೆ ಅಪ್ಪಣೆ ಕೊಡಲಾಗಿ, ಅವನು ಸ್ವದೇಶಕ್ಕೆ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ಇಸ್ರಾಯೇಲರು ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಟ ಮೂರನೆಯ ತಿಂಗಳಿನ ಅದೇ ದಿನದಲ್ಲಿ ಸೀನಾಯಿ ಮರುಭೂಮಿಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ಇಸ್ರಾಯೇಲರು ರೇಫೀದೀಮನ್ನು ಬಿಟ್ಟು ಮರುಭೂಮಿಗೆ ಬಂದು ಮರುಭೂಮಿಯಲ್ಲಿ ಡೇರೆ ಹಾಕಿ ಸೀನಾಯಿ ಬೆಟ್ಟಕ್ಕೆ ಎದುರಾಗಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ಮೋಶೆ ಬೆಟ್ಟವನ್ನೇರಿ ದೇವರ ಸನ್ನಿಧಿಗೆ ಹೋದನು. ಆಗ ಯೆಹೋವನು ಬೆಟ್ಟದ ಮೇಲಿಂದ ಮೋಶೆಯನ್ನು ಕರೆದು ಅವನಿಗೆ, “ನೀನು ಯಾಕೋಬನ ಮನೆತನದವರಾದ ಇಸ್ರಾಯೇಲರಿಗೆ ಈ ಮಾತುಗಳನ್ನು ತಿಳಿಸಿ ಹೇಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘ನಾನು ಐಗುಪ್ತ್ಯರಿಗೆ ಮಾಡಿದ್ದನ್ನೂ, ಹದ್ದು ತನ್ನ ಮರಿಗಳನ್ನು ರೆಕ್ಕೆಗಳ ಮೇಲೆ ಹೊತ್ತುಕೊಳ್ಳುವಂತೆ ನಾನು ನಿಮ್ಮನ್ನು ಹೊತ್ತುಕೊಂಡು ಈ ಸ್ಥಳಕ್ಕೆ ಬರಮಾಡಿದ್ದನ್ನೆಲ್ಲಾ ನೀವು ನೋಡಿದ್ದೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ಆದ್ದರಿಂದ ನೀವು ನನ್ನ ಮಾತುಗಳನ್ನು ಶ್ರದ್ಧೆಯಿಂದ ಕೇಳಿ, ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಕಾಪಾಡಿಕೊಂಡರೆ, ನೀವು ಎಲ್ಲಾ ಜನಾಂಗಗಳಲ್ಲಿ ನನಗೆ ಸ್ವಕೀಯ ಜನರಾಗಿರುವಿರಿ. ಸಮಸ್ತ ಭೂಮಿಯು ನನ್ನದೇ. ");
INSERT INTO kanirv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ನೀವು ನನಗೆ ಶ್ರೇಷ್ಠ ಯಾಜಕರೂ, ಪರಿಶುದ್ಧ ಜನರೂ ಆಗಿರುವಿರಿ’ ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಬೇಕಾದ ಮಾತುಗಳು ಇವೇ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ಆಗ ಮೋಶೆ ಬಂದು ಜನರ ಹಿರಿಯರನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದ ಈ ಮಾತುಗಳನ್ನೆಲ್ಲಾ ಅವರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ಜನರೆಲ್ಲರೂ ಒಗ್ಗಟ್ಟಾಗಿ, “ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಮಾಡುವೆವು” ಎಂದು ಉತ್ತರಕೊಟ್ಟರು. ಮೋಶೆ ಯೆಹೋವನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಿ ಅವರು ಹೇಳಿದ ಮಾತುಗಳನ್ನು ಆತನಿಗೆ ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಇಗೋ, ನಾನು ನಿನ್ನ ಸಂಗಡ ಮಾತನಾಡುವಾಗ, ಜನರು ಕೇಳಿ ಯಾವಾಗಲೂ ನಿನ್ನನ್ನು ನಂಬುವಂತೆ ನಾನು ಮೇಘದೊಳಗಿನಿಂದ ನಿನ್ನ ಬಳಿಗೆ ಬರುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ಮೋಶೆ ಜನರ ಮಾತುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು ಜನರ ಬಳಿಗೆ ಹೋಗಿ, ಈ ದಿನ ಮತ್ತು ನಾಳೆ ಅವರನ್ನು ಶುದ್ಧಗೊಳಿಸು. ನನ್ನ ಬರುವಿಕೆಗಾಗಿ ಅವರನ್ನು ಸಿದ್ಧಗೊಳಿಸು. ಅವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಅವರು ಸಿದ್ಧರಾಗಿರಬೇಕು. ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ಸಮಸ್ತ ಜನರಿಗೂ ಪ್ರತ್ಯಕ್ಷನಾಗಿ ಸೀನಾಯಿ ಬೆಟ್ಟದ ಮೇಲೆ ಇಳಿದು ಬರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ಜನರು ಹತ್ತಿರ ಬಾರದಂತೆ ನೀನು ಬೆಟ್ಟದ ಸುತ್ತಲೂ ಗಡಿಯನ್ನು ಮಾಡಿಸಿ ಜನರಿಗೆ, ‘ಎಚ್ಚರಿಕೆಯಾಗಿರಿ, ನೀವು ಈ ಬೆಟ್ಟವನ್ನು ಏರದಂತೆಯೂ ಅದರ ಗಡಿಯನ್ನು ಮುಟ್ಟದಂತೆಯೂ ಜಾಗ್ರತೆಯಿಂದಿರಬೇಕು. ಬೆಟ್ಟವನ್ನು ಮುಟ್ಟಿದವರೆಲ್ಲಾ ಖಂಡಿತವಾಗಿ ಸತ್ತುಹೋಗುವರು.’ ");
INSERT INTO kanirv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ಅಂಥವನನ್ನು ಯಾರೂ ಮುಟ್ಟಬಾರದು. ಕಲ್ಲೆಸೆದು ಅಥವಾ ಬಾಣವನ್ನು ಎಸೆದು ಖಂಡಿತವಾಗಿ ಅವನನ್ನು ಕೊಲ್ಲಬೇಕು. ಮನುಷ್ಯನಾಗಲಿ, ಪಶುಗಳಾಗಲಿ ಬೆಟ್ಟವನ್ನು ಮುಟ್ಟಿದರೆ ಸಾಯಲೇಬೇಕು. ಕೊಂಬಿನ ಧ್ವನಿ ದೀರ್ಘವಾಗಿ ಕೇಳಿಸಿದಾಗ ಅವರು ಬೆಟ್ಟದ ಸಮೀಪಕ್ಕೆ ಬರಬೇಕು” ಎಂದು ಹೇಳು ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ಮೋಶೆ ಬೆಟ್ಟದಿಂದಿಳಿದು ಜನರ ಬಳಿಗೆ ಬಂದು, ಅವರನ್ನು ಶುದ್ಧಗೊಳಿಸಿದನು. ಅವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಶುದ್ಧರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ಆಗ ಮೋಶೆ ಜನರಿಗೆ, “ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಸಿದ್ಧವಾಗಿರಿ. ಯಾವ ಪುರುಷನೂ ಸ್ತ್ರೀಸಂಗ ಮಾಡಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಸೂರ್ಯೋದಯವಾಗಲು ಆ ಬೆಟ್ಟದ ಮೇಲೆ ಗುಡುಗು, ಮಿಂಚೂ, ಕಾರ್ಮುಗಿಲೂ, ತುತ್ತೂರಿಯ ಮಹಾಧ್ವನಿಯೂ ಉಂಟಾಗಲು ಪಾಳೆಯಲ್ಲಿದ್ದ ಜನರೆಲ್ಲರೂ ನಡುಗಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ದೇವದರ್ಶನಕ್ಕಾಗಿ ಮೋಶೆ ಜನರನ್ನು ಪಾಳೆಯದ ಹೊರಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬರಲು, ಅವರು ಬೆಟ್ಟದ ಕೆಳಗೆ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ಯೆಹೋವನು ಬೆಂಕಿಯೊಳಗೆ ಸೀನಾಯಿ ಬೆಟ್ಟದ ಮೇಲೆ ಇಳಿದು ಬಂದನು. ಆದುದರಿಂದ ಆ ಬೆಟ್ಟವೆಲ್ಲಾ ಹೊಗೆಯಿಂದ ಆವರಿಸಿಕೊಂಡಿತು. ಆ ಹೊಗೆ ಆವಿಗೆಯ ಹೊಗೆಯಂತೆ ಏರಿತು. ಅದಲ್ಲದೆ ಬೆಟ್ಟವೆಲ್ಲಾ ಬಹಳವಾಗಿ ಕಂಪಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ತುತ್ತೂರಿಯ ಧ್ವನಿ ಹೆಚ್ಚಾಗುತ್ತಾ ಬಂದಾಗ, ಮೋಶೆಯು ದೇವರ ಸಂಗಡ ಮಾತನಾಡಿದನು. ಆಗ ದೇವರು ಎತ್ತರದ ಧ್ವನಿಯಲ್ಲಿ ಅವನಿಗೆ ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ಯೆಹೋವನು ಸೀನಾಯಿ ಬೆಟ್ಟದ ಶಿಖರಕ್ಕೆ ಇಳಿದು ಬಂದನು. ಆತನು ಬೆಟ್ಟದ ತುದಿಗೆ ಬಾ ಎಂದು ಮೋಶೆಯನ್ನು ಕರೆಯಲು ಅವನು ಬೆಟ್ಟವನ್ನೇರಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಇಳಿದು ಹೋಗಿ ಜನರನ್ನು ಎಚ್ಚರಿಸಬೇಕು. ಅವರು ನೋಡಬೇಕೆಂಬ ಆಶೆಯಿಂದ ಗಡಿಯನ್ನು ದಾಟಿ ಯೆಹೋವನ ಹತ್ತಿರಕ್ಕೆ ಬಂದರೆ ಅವರಲ್ಲಿ ಬಹಳ ಜನರು ನಾಶವಾಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಬರುವ ಯಾಜಕರೂ ತಮ್ಮನ್ನು ಶುದ್ಧಿಪಡಿಸಿಕೊಳ್ಳಬೇಕು. ಇಲ್ಲವಾದರೆ ಯೆಹೋವನು ಪಕ್ಕನೆ ಅವರನ್ನೂ ಸಂಹಾರಮಾಡುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ಅದಕ್ಕೆ ಮೋಶೆ ಯೆಹೋವನಿಗೆ, “ಜನರು ಸೀನಾಯಿ ಬೆಟ್ಟವನ್ನೇರುವುದಕ್ಕೆ ಆಗುವುದಿಲ್ಲ. ಯಾಕೆಂದರೆ ‘ಬೆಟ್ಟದ ಸುತ್ತಲೂ ಗಡಿಯನ್ನು ಹಾಕಿ ನಿನಗಾಗಿ ಶುದ್ಧಮಾಡು’” ಎಂದು ಆಜ್ಞಾಪಿಸಿರುವೆಯಲ್ಲಾ ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಇಳಿದುಹೋಗಿ ಆರೋನನ್ನು ನಿನ್ನ ಸಂಗಡ ಕರೆದುಕೊಂಡು ಮೇಲಕ್ಕೆ ಬಾ. ಆದರೆ ಯಾಜಕರೂ, ಜನರೂ ಆ ಗಡಿಯನ್ನು ದಾಟಿ ಯೆಹೋವನ ಹತ್ತಿರ ಬರಬಾರದು. ದಾಟಿ ಬಂದರೆ ನಾನು ಅವರನ್ನು ಪಕ್ಕನೇ ಸಂಹಾರ ಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ಮೋಶೆ ಜನರ ಬಳಿಗೆ ಇಳಿದುಹೋಗಿ ಆ ಮಾತುಗಳನ್ನು ಅವರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ದೇವರು ಈ ಎಲ್ಲಾ ಆಜ್ಞಾವಿಧಿಗಳನ್ನು ಅವರಿಗೆ ಕೊಟ್ಟನು: ");
INSERT INTO kanirv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ನೀನು ಗುಲಾಮತನದಲ್ಲಿದ್ದ ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ನಿನ್ನನ್ನು ಬಿಡುಗಡೆಮಾಡಿದ ಯೆಹೋವನು ಎಂಬ ‘ನಾನೇ ನಿನ್ನ ದೇವರು’ ");
INSERT INTO kanirv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","ನಾನಲ್ಲದೆ ನಿಮಗೆ ಬೇರೆ ದೇವರುಗಳು ಇರಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“ಯಾವ ಮೂರ್ತಿಯನ್ನೂ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ಆಕಾಶದಲ್ಲಾಗಲಿ, ಭೂಮಿಯಲ್ಲಾಗಲಿ, ಭೂಮಿಯ ಕೆಳಗಣ ನೀರಿನಲ್ಲಾಗಲಿ ಇರುವ ಯಾವುದರ ರೂಪವನ್ನೂ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ಅವುಗಳಿಗೆ ಅಡ್ಡ ಬೀಳಬಾರದು, ಪೂಜೆ ಮಾಡಬಾರದು. ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವನೆಂಬ ನಾನು ನನಗೆ ಸಲ್ಲತಕ್ಕ ಗೌರವವನ್ನು ಮತ್ತೊಬ್ಬನಿಗೆ ಬಿಟ್ಟುಕೊಡುವುದಿಲ್ಲ. ಆದುದರಿಂದ ನನ್ನನ್ನು ದ್ವೇಷಿಸುವವರ ವಿಷಯದಲ್ಲಿ ತಂದೆಗಳ ದೋಷಫಲವನ್ನು ಮಕ್ಕಳ ಮೇಲೆ, ಮೂರು ನಾಲ್ಕು ತಲೆಗಳವರೆಗೆ ಬರಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ನನ್ನನ್ನು ಪ್ರೀತಿಸಿ ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಕೈಗೊಳ್ಳುವವರಿಗಾದರೋ ಸಾವಿರ ತಲೆಗಳವರೆಗೆ ದಯೆತೋರಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವನ ಹೆಸರನ್ನು ಅಯೋಗ್ಯಕಾರ್ಯಕ್ಕಾಗಿ ಎತ್ತಬಾರದು. ಯೆಹೋವನು ತನ್ನ ಹೆಸರನ್ನು ಅಯೋಗ್ಯಕಾರ್ಯಕ್ಕಾಗಿ ಎತ್ತುವವನನ್ನು ಶಿಕ್ಷಿಸದೆ ಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“ಸಬ್ಬತ್ ದಿನವನ್ನು ದೇವರ ದಿನವೆಂದು ಆಚರಣೆಗೆ ತರುವುದಕ್ಕೆ ನೆನಪಿನಲ್ಲಿಟ್ಟುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ಆರು ದಿನಗಳು ನೀನು ದುಡಿದು ನಿನ್ನ ಕೆಲಸವನ್ನೆಲ್ಲಾ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ಆದರೆ ಏಳನೆಯ ದಿನವು ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಮೀಸಲಾದ ವಿಶ್ರಾಂತಿಯ ಸಬ್ಬತ್ ದಿನವಾಗಿದೆ. ಆ ದಿನದಲ್ಲಿ ನೀನು ಯಾವ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ನಿನ್ನ ಗಂಡುಮಕ್ಕಳು, ಹೆಣ್ಣುಮಕ್ಕಳು, ಗಂಡಾಳು, ಹೆಣ್ಣಾಳು, ಪಶುಪ್ರಾಣಿಗಳು ನಿನ್ನ ಊರಿನಲ್ಲಿರುವ ಅನ್ಯದೇಶದವನು ಸಹ ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ಆರು ದಿನಗಳಲ್ಲಿ ಯೆಹೋವನು ಭೂಮ್ಯಾಕಾಶಗಳನ್ನೂ, ಸಮುದ್ರವನ್ನೂ, ಅವುಗಳಲ್ಲಿರುವ ಸಮಸ್ತವನ್ನೂ ನಿರ್ಮಾಣ ಮಾಡಿ, ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಂಡನು. ಆದುದರಿಂದ ಯೆಹೋವನು ಸಬ್ಬತ್ ದಿನವನ್ನು ತನ್ನ ಪರಿಶುದ್ಧ ದಿನವಾಗಿರಲಿ ಎಂದು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“ನಿನ್ನ ತಂದೆತಾಯಿಗಳನ್ನು ಸನ್ಮಾನಿಸಬೇಕು, ಸನ್ಮಾನಿಸಿದರೆ ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವನು ನಿನಗೆ ಅನುಗ್ರಹಿಸುವ ದೇಶದಲ್ಲಿ ನೀನು ಬಹುಕಾಲ ಬದುಕುವಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“ಕೊಲೆ ಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“ವ್ಯಭಿಚಾರಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“ಕದಿಯಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“ಮತ್ತೊಬ್ಬನ ಮೇಲೆ ಸುಳ್ಳುಸಾಕ್ಷಿ ಹೇಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ಮತ್ತೊಬ್ಬನ ಮನೆಯನ್ನು ನೋಡಿ ಆಶೆಪಡಬಾರದು. ಮತ್ತೊಬ್ಬನ ಹೆಂಡತಿ, ಗಂಡಾಳು, ಹೆಣ್ಣಾಳು, ಎತ್ತು, ಕತ್ತೆ ಮುಂತಾದ ಯಾವುದನ್ನೂ ಬಯಸಬಾರದು.” ");
INSERT INTO kanirv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ಆ ಗುಡುಗು, ಮಿಂಚು, ತುತ್ತೂರಿಯ ಧ್ವನಿ, ಹಾಗೂ ಬೆಟ್ಟದಿಂದ ಹೊರಬರುತ್ತಿದ್ದ ಹೊಗೆಯನ್ನು ಜನರೆಲ್ಲರೂ ನೋಡಿ, ನಡುಗುತ್ತಾ ದೂರದಲ್ಲಿ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ಅವರು ಮೋಶೆಗೆ, “ನೀನೇ ನಮ್ಮ ಸಂಗಡ ಮಾತನಾಡು, ನಾವು ಕೇಳುತ್ತೇವೆ. ದೇವರು ನಮ್ಮ ಸಂಗಡ ಮಾತನಾಡಿದರೆ ನಾವು ಸತ್ತು ಹೋಗುತ್ತೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ಅದಕ್ಕೆ ಮೋಶೆಯು ಜನರಿಗೆ, “ಭಯಪಡಬೇಡಿರಿ, ದೇವರು ನಿಮ್ಮನ್ನು ಪರೀಕ್ಷಿಸುವುದಕ್ಕಾಗಿ, ನೀವು ಪಾಪ ಮಾಡದಂತೆ ಆತನ ಮೇಲಿನ ಭಯವು ನಿಮಗೆ ಇರಬೇಕೆಂತಲೂ ಇಳಿದು ಬಂದಿದ್ದಾನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ಜನರು ದೂರದಲ್ಲಿ ನಿಂತಿದ್ದರು. ಮೋಶೆಯು ದೇವರಿರುವ ಆ ಕಾರ್ಗತ್ತಲಿನ ಸಮೀಪಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೀಗೆಂದನು, “ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ; ‘ನಾನು ಆಕಾಶದಿಂದ ನಿಮ್ಮ ಸಂಗಡ ಮಾತನಾಡಿದ್ದನ್ನು ನೀವು ನೋಡಿದ್ದೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ನೀವು ಬೆಳ್ಳಿ ಬಂಗಾರಗಳ ದೇವರುಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","ನೀವು ನನ್ನ ಯಜ್ಞವೇದಿಯನ್ನು ಮಣ್ಣಿನಿಂದ ಮಾಡಬೇಕು. ನೀವು ಅದರ ಮೇಲೆ ನಿಮ್ಮ ಸರ್ವಾಂಗಹೋಮ, ಸಮಾಧಾನಯಜ್ಞ, ಕುರಿದನಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ನಾನು ನನ್ನ ಹೆಸರನ್ನು ಗೌರವಿಸುವಂತೆ ಮಾಡುವ ಎಲ್ಲಾ ಸ್ಥಳಗಳಲ್ಲಿಯೂ ನಾನು ನಿಮ್ಮ ಬಳಿಗೆ ಬಂದು ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ನೀವು ನನಗಾಗಿ ಕಲ್ಲಿನಿಂದ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟುವುದಾದರೆ, ಅದನ್ನು ಕೆತ್ತಿರುವ ಕಲ್ಲುಗಳಿಂದ ಕಟ್ಟಬಾರದು. ಏಕೆಂದರೆ ಉಳಿ, ಮುಂತಾದುದನ್ನು ಅದರ ಮೇಲೆ ಉಪಯೋಗಿಸಿದರೆ ಅದು ಅಪವಿತ್ರವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ಅದಲ್ಲದೆ ನನ್ನ ಯಜ್ಞವೇದಿಯನ್ನು ನಿಮ್ಮ ನಗ್ನತೆಯು ಕಾಣುವ ಹಾಗೆ ಮೆಟ್ಟಲುಗಳನ್ನು ಬಳಸಿ ಅದನ್ನು ಹತ್ತಬಾರದು’” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“ಈಗ ನೀನು ಅವರ ಮುಂದೆ ಇಡಬೇಕಾದ ನ್ಯಾಯವಿಧಿಗಳು ಯಾವುದೆಂದರೆ; ");
INSERT INTO kanirv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“‘ನಿಮ್ಮಲ್ಲಿ ಯಾರಾದರೂ ಇಬ್ರಿಯನೊಬ್ಬನನ್ನು ದಾಸತ್ವಕ್ಕಾಗಿ ಕೊಂಡುಕೊಂಡರೆ, ಆ ಇಬ್ರಿಯನು ಆರು ವರ್ಷ ದಾಸನಾಗಿದ್ದು ಏಳನೆಯ ವರ್ಷದಲ್ಲಿ ಏನೂ ಕೊಡದೆ ಬಿಡುಗಡೆಯಾಗಿ ಹೋಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ಪುರುಷನು ಒಂಟಿಯಾಗಿ ಬಂದಿದ್ದರೆ ಒಂಟಿಯಾಗಿಯೇ ಹೊರಟುಹೋಗಬೇಕು. ಮದುವೆಯಾಗಿ ಬಂದಿದ್ದರೆ ಅವನ ಹೆಂಡತಿಯೂ ಅವನ ಜೊತೆ ಹೋಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ಅವನ ಯಜಮಾನನು ಅವನಿಗೆ ಮದುವೆಮಾಡಿಸಿದ ಪಕ್ಷದಲ್ಲಿ ಆ ಹೆಂಡತಿಯಲ್ಲಿ ಗಂಡು ಇಲ್ಲವೆ ಹೆಣ್ಣುಮಕ್ಕಳು ಹುಟ್ಟಿದ್ದರೆ, ಆ ಹೆಂಡತಿಯೂ ಅವಳ ಮಕ್ಕಳೂ ಯಜಮಾನನ ಸೊತ್ತಾಗುವರು. ದಾಸನು ಒಂಟಿಗನಾಗಿಯೇ ಹೊರಟುಹೋಗಬೇಕು.’” ");
INSERT INTO kanirv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ಆದರೆ ದಾಸನು, “ನಾನು ನನ್ನ ಯಜಮಾನನ್ನೂ, ನನ್ನ ಹೆಂಡತಿ ಮಕ್ಕಳನ್ನು ಪ್ರೀತಿಸುತ್ತೇನೆ. ಆದುದರಿಂದ ನಾನು ಬಿಡುಗಡೆಯಾಗಿ ಹೋಗುವುದಕ್ಕೆ ನನಗೆ ಮನಸಿಲ್ಲ” ಎಂದು ಸ್ಪಷ್ಟವಾಗಿ ಹೇಳಿದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ಅವನ ಯಜಮಾನನು ದೇವರ ಬಳಿಗೆ ಅವನನ್ನು ಕರೆದುಕೊಂಡು ಬಂದು ಬಾಗಿಲಿನ ಹತ್ತಿರ ಅಥವಾ ಬಾಗಿಲಿನ ನಿಲುವು ಪಟ್ಟಿಗಳ ಹತ್ತಿರ ನಿಲ್ಲಿಸಿ ಅವನ ಕಿವಿಯನ್ನು ದಬ್ಬಳದಿಂದ ಚುಚ್ಚಿ ಗುರುತು ಮಾಡಬೇಕು. ಆಗ ಅವನು ಶಾಶ್ವತವಾಗಿ ಅವನಿಗೆ ದಾಸನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ಯಾರಾದರೂ ತನ್ನ ಮಗಳನ್ನು ದಾಸಿಯನ್ನಾಗಿ ಮಾರಿದರೆ, ದಾಸರು ಬಿಡುಗಡೆಯಾಗಿ ಹೋಗುವ ಪ್ರಕಾರ ಅವಳು ಬಿಡುಗಡೆಯಾಗಿ ಹೋಗಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ಅವಳನ್ನು ನಿಶ್ಚಯ ಮಾಡಿಕೊಂಡ ಯಜಮಾನನಿಗೆ ಒಂದು ವೇಳೆ ಮೆಚ್ಚಿಕೆಯಾಗದೆ ಹೋದರೆ ಅವಳನ್ನು ಬಿಡಿಸಿ ಕೊಲ್ಲುವುದಕ್ಕೆ ಅವನು ಅನುಮತಿ ನೀಡಬೇಕು. ಅವನು ಕೊಟ್ಟ ಮಾತಿಗೆ ತಪ್ಪಿದವನಾದ್ದರಿಂದ ಅನ್ಯಜನರಿಗೆ ಅವಳನ್ನು ಮಾರುವುದಕ್ಕೆ ಅವನಿಗೆ ಅಧಿಕಾರವಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ಒಂದು ವೇಳೆ ಅವನು ತನ್ನ ಮಗನಿಗೆ ಅವಳನ್ನು ನಿಶ್ಚಯ ಮಾಡಿಕೊಂಡರೆ ಮಗಳಂತೆ ಆಕೆಯನ್ನು ನೋಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ಯಜಮಾನನು ಇನ್ನೊಬ್ಬಳನ್ನು ಮದುವೆಯಾದರೆ ಮೊದಲನೆಯವಳಿಗೆ ಅನ್ನ, ವಸ್ತ್ರ, ದಾಂಪತ್ಯದ ಹಕ್ಕುಗಳನ್ನು ಕಡಿಮೆಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ಈ ಮೂರರಲ್ಲಿ ಯಾವುದನ್ನೂ ನಡೆಸದೆ ಹೋದರೆ ಅವಳು ಏನೂ ಕೊಡದೆ ಬಿಡುಗಡೆಯಾಗಿ ಹೋಗಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","ಮನುಷ್ಯನನ್ನು ಹೊಡೆದು ಕೊಂದವನು ಖಂಡಿತವಾಗಿ ಸಾಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ಆದರೆ ಕೊಲ್ಲಬೇಕೆಂಬ ಯೋಚನೆಯಿಲ್ಲದೆ ದೇವರ ಸಂಕಲ್ಪದಿಂದ ಆ ಕೊಲೆ ನಡೆದಿದೆಯಾದರೆ, ಆ ಕೊಲೆಮಾಡಿದವನು ಓಡಿಹೋಗುವಂತೆ ಅವನಿಗೆ ನಾನು ಒಂದು ಸ್ಥಳವನ್ನು ನೇಮಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ಆದರೆ ಒಬ್ಬನು ತನ್ನ ನೆರೆಯವನನ್ನು ಕೊಲ್ಲಬೇಕೆಂಬ ಉದ್ದೇಶದಿಂದಲೇ ಅವನನ್ನು ಮೋಸದಿಂದ ಕೊಂದರೆ, ಅವನು ಸಾಯುವಂತೆ ನೀನು ಅವನನ್ನು ನನ್ನ ಯಜ್ಞವೇದಿಯ ಬಳಿಯಿಂದ ಕರೆದುಕೊಂಡು ಹೋಗಿ ಕೊಂದುಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","ಯಾರಾದರೂ ತನ್ನ ತಂದೆಯನ್ನಾಗಲಿ ತಾಯಿಯನ್ನಾಗಲಿ ಹೊಡೆದರೆ ಖಂಡಿತವಾಗಿ ಅವನು ಸಾಯಲೇಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","ಯಾರಾದರೂ ಒಬ್ಬ ಮನುಷ್ಯನನ್ನು ಅಪಹರಿಸಿಕೊಂಡು ಹೋಗಿ ಮಾರಿದರೆ ಅಥವಾ ಅವನು ಬಂಧಿಸಲ್ಪಟ್ಟಾಗ, ಅಪಹರಿಸಲ್ಪಟ್ಟವನು ಅವನೊಂದಿಗಿದ್ದರೆ ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","ತಂದೆಯನ್ನಾಗಲಿ ತಾಯಿಯನ್ನಾಗಲಿ ಶಪಿಸುವವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ಇಬ್ಬರು ಜಗಳವಾಡುತ್ತಿರುವಲ್ಲಿ ಒಬ್ಬನು ಮತ್ತೊಬ್ಬನನ್ನು ಕಲ್ಲಿನಿಂದಾಗಲಿ, ಮುಷ್ಠಿಯಿಂದಾಗಲೀ ಹೊಡೆದಿದ್ದರಿಂದ ಗಾಯಪಟ್ಟವನು ಸಾಯದೆ ಕೆಲವು ಕಾಲ ಹಾಸಿಗೆ ಹಿಡಿದು, ");
INSERT INTO kanirv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ತರುವಾಯ ಅವನು ಎದ್ದು ಕೋಲೂರಿಕೊಂಡು ತಿರುಗಾಡುವುದಾದರೆ ಅವನನ್ನು ಹೊಡೆದವನಿಗೆ ಶಿಕ್ಷೆಯನ್ನು ವಿಧಿಸಬಾರದು. ಆದರೆ ಪೆಟ್ಟುತಿಂದ ಮನುಷ್ಯನು ಗುಣಹೊಂದುವವರೆಗೂ ಆಗುವ ಖರ್ಚನ್ನು ಹೊಡೆದವನು ಕೊಡಬೇಕು ಮತ್ತು ಅವನು ಪೂರ್ಣ ಸ್ವಸ್ಥನಾಗುವಂತೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ಒಬ್ಬನು ತನ್ನ ದಾಸನನ್ನಾಗಲಿ, ದಾಸಿಯನ್ನಾಗಲಿ ಕೋಲಿನಿಂದ ಹೊಡೆದು ಸಾಯುವಂತೆ ಹೊಡೆದರೆ, ಅವನಿಗೆ ತಕ್ಕ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ಆ ದಾಸನು ಆಗಲೇ ಸಾಯದೆ ಒಂದೆರಡು ದಿನ ಬದುಕಿದ್ದರೆ, ಯಜಮಾನನಿಗೆ ಶಿಕ್ಷೆಯನ್ನು ವಿಧಿಸಕೂಡದು. ಏಕೆಂದರೆ ಆ ದಾಸನು ಅವನ ಸೊತ್ತಾಗಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ಗಂಡಸರು ಜಗಳವಾಡುವಾಗ ಗರ್ಭಿಣಿಯಾದ ಹೆಂಗಸಿಗೆ ಏಟು ತಗಲಿದ್ದರಿಂದ ಅವಳಿಗೆ ಗರ್ಭಸ್ರಾವವಾದರೆ, ಆ ಸ್ತ್ರೀಯ ಗಂಡನು ಕೇಳಿದಷ್ಟು ಮತ್ತು ನ್ಯಾಯಾಲಯವು ವಿಧಿಸುವಷ್ಟು ದಂಡವನ್ನು ಹೊಡೆದವನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ಬೇರೆ ಹಾನಿಯಾದ ಪಕ್ಷದಲ್ಲಿ ಪ್ರಾಣಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ಪ್ರಾಣವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ಕಣ್ಣಿಗೆ ಕಣ್ಣನ್ನು, ಹಲ್ಲಿಗೆ ಹಲ್ಲನ್ನು, ಕೈಗೆ ಕೈಯನ್ನು, ಕಾಲಿಗೆ ಕಾಲನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ಬರೆಗೆ ಬರೆಯನ್ನು, ಗಾಯಕ್ಕೆ ಗಾಯವನ್ನು, ಏಟಿಗೆ ಏಟನ್ನು ಪ್ರತಿಯಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ಯಾವನಾದರೂ ತನ್ನ ದಾಸನ ಅಥವಾ ದಾಸಿಯ ಕಣ್ಣನ್ನು ಹೊಡೆದು ನಷ್ಟಪಡಿಸಿದರೆ ಆ ಕಣ್ಣಿಗೆ ಈಡಾಗಿ (ಬದಲಾಗಿ) ಅವರನ್ನು ಅವನು ಬಿಡುಗಡೆಮಾಡಿ ಕಳುಹಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ಒಬ್ಬನು ದಾಸನ ಅಥವಾ ದಾಸಿಯ ಹಲ್ಲನ್ನು ಉದುರಿಸಿದರೆ ಹಲ್ಲಿಗೆ ಈಡಾಗಿ ಅವರನ್ನು ಬಿಡುಗಡೆಮಾಡಿ ಕಳುಹಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ಯಾವುದಾದರೂ ಒಂದು ಎತ್ತು ಪುರುಷನನ್ನಾಗಲಿ, ಸ್ತ್ರೀಯನ್ನಾಗಲಿ, ತಿವಿದು ಕೊಂದರೆ ಆ ಎತ್ತನ್ನು ಖಂಡಿತವಾಗಿ ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ಅದರ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು. ಆದರೆ ಆ ಎತ್ತಿನ ಯಜಮಾನನು ನಿರಪರಾಧಿಯಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ಆದರೆ ಆ ಎತ್ತು ಮೊದಲಿನಿಂದ ಹಾಯುವಂಥದೆಂದು ಯಜಮಾನನಿಗೆ ತಿಳಿದಿದ್ದರೂ ಅವನು ಅದನ್ನು ಕಟ್ಟಿಹಾಕದೇ ಹೋದದ್ದರಿಂದ ಅದು ಪುರುಷನನ್ನಾಗಲಿ, ಸ್ತ್ರೀಯನ್ನಾಗಲಿ ಕೊಂದು ಹಾಕಿದರೆ ಆ ಎತ್ತನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ಅಲ್ಲದೆ ಅದರ ಯಜಮಾನನೂ ಮರಣದಂಡನೆಗೆ ಗುರಿಯಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ಆದರೆ ಯಜಮಾನನಿಗೆ ಹಣವನ್ನು ನೇಮಿಸಿದರೆ ಅವನು ತನಗೆ ನೇಮಕವಾದ ಹಣವನ್ನು ಕೊಟ್ಟು ತನ್ನ ಪ್ರಾಣವನ್ನು ಉಳಿಸಿಕೊಳ್ಳಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ಆ ಎತ್ತು ಮಗನನ್ನಾಗಲಿ ಅಥವಾ ಮಗಳನ್ನಾಗಲಿ ತಿವಿದರೆ ನ್ಯಾಯತೀರ್ಪಿನ ಪ್ರಕಾರ ಅದರ ಯಜಮಾನನಿಗೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ದಾಸನನ್ನಾದರೂ ಅಥವಾ ದಾಸಿಯನ್ನಾದರೂ ಎತ್ತು ತಿವಿದರೆ ದಾಸನ ಅಥವಾ ದಾಸಿಯ ಯಜಮಾನನಿಗೆ ಮೂವತ್ತು ಬೆಳ್ಳಿನಾಣ್ಯಗಳನ್ನು ಕೊಡಬೇಕು, ಮತ್ತು ಆ ಎತ್ತನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ಒಬ್ಬನು ಗುಂಡಿಯನ್ನು ಅಗೆದರೆ ಇಲ್ಲವೆ ಅಗೆದು ಅದನ್ನು ಮುಚ್ಚದೇ ಇದ್ದು ಅದರಲ್ಲಿ ಎತ್ತಾಗಲಿ, ಕತ್ತೆಯಾಗಲಿ ಆ ಗುಂಡಿಯಲ್ಲಿ ಬಿದ್ದು ಸತ್ತರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ಆ ಗುಂಡಿಯನ್ನು ಅಗೆಸಿದವನು ಉಂಟಾದ ನಷ್ಟಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ಈಡು ಕೊಡಬೇಕು. ಎತ್ತಿನ ಯಜಮಾನನಿಗೆ ತೃಪ್ತಿಯಾಗುವಷ್ಟು ಕ್ರಯವನ್ನು ಕೊಡಬೇಕು. ಸತ್ತ ಎತ್ತನ್ನು ತಾನೇ ತೆಗೆದುಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ಒಬ್ಬನ ಎತ್ತು ಮತ್ತೊಬ್ಬನ ಎತ್ತನ್ನು ಹಾಯ್ದು ಕೊಂದರೆ ಜೀವದಿಂದಿರುವ ಎತ್ತನ್ನು ಮಾರಿ ಅದರ ಕ್ರಯವನ್ನು ಕೊಡಬೇಕು. ಸತ್ತ ಎತ್ತನ್ನೂ ಇಬ್ಬರೂ ಸಮವಾಗಿ ಹಂಚಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ಆದರೆ ಆ ಎತ್ತು ಮೊದಲಿನಿಂದಲೂ ಹಾಯುವಂಥದ್ದೇ ಎಂದು ಅದರ ಯಜಮಾನನಿಗೆ ತಿಳಿದಿದ್ದರೂ ಅದನ್ನು ಕಟ್ಟಿಹಾಕದೇ ಹೋದದ್ದರಿಂದ ಅವನು ಎತ್ತಿಗೆ ಪ್ರತಿಯಾಗಿ ಎತ್ತನ್ನು ಖಂಡಿತವಾಗಿ ಬದಲು ಕೊಡಬೇಕು. ಆದರೆ ಸತ್ತ ಎತ್ತನ್ನು ತಾನೇ ತೆಗೆದುಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","ಒಬ್ಬನು ಎತ್ತನ್ನಾಗಲಿ, ಕುರಿಯನ್ನಾಗಲಿ ಕದ್ದುಕೊಂಡು ಕೊಯ್ದರೆ ಇಲ್ಲವೆ ಮಾರಿದರೆ ಅವನು ಒಂದು ಎತ್ತಿಗೆ ಬದಲಾಗಿ ಐದು ಎತ್ತುಗಳನ್ನು ಒಂದು ಕುರಿಗೆ ಬದಲಾಗಿ ನಾಲ್ಕು ಕುರಿಗಳನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ಒಬ್ಬ ಕಳ್ಳನು ಕಳ್ಳತನ ಮಾಡುತ್ತಿರುವಾಗಲೇ ಕೈಗೆ ಸಿಕ್ಕಿದಾಗ ಅವನನ್ನು ಕೊಂದರೆ ಅದನ್ನು ನರಹತ್ಯೆಯೆಂದು ಎಣಿಸಕೂಡದು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ಸೂರ್ಯೋದಯವಾದ ನಂತರ ಒಬ್ಬನು ಕಳ್ಳತನಮಾಡಿ ಸಿಕ್ಕಿಬಿದ್ದಾಗ, ಅವನನ್ನು ಹೊಡೆದು ಕೊಂದರೆ ಅದನ್ನು ನರಹತ್ಯೆಯೆಂದು ಎಣಿಸಬೇಕು. ಅವನು ಕದ್ದದ್ದನ್ನೆಲ್ಲಾ ಪೂರ್ತಿಯಾಗಿ ಹಿಂತಿರುಗಿಸಬೇಕು. ಅವನಲ್ಲಿ ಕೊಡಲು ಏನೂ ಇಲ್ಲದ ಪಕ್ಷಕ್ಕೆ ಅವನು ಆ ಕಳ್ಳತನ ಮಾಡಿದ್ದರಿಂದ ಗುಲಾಮನಾಗಿ ಮಾರಲ್ಪಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ಕಳ್ಳತನ ಮಾಡಿದ ಎತ್ತಾಗಲಿ, ಕತ್ತೆಯಾಗಲಿ, ಆಡು, ಕುರಿಯಾದರೂ ಜೀವದಿಂದಲೇ ಕದ್ದವನ ಬಳಿಯಲ್ಲಿ ಸಿಕ್ಕಿದರೆ ಅವನು ಎರಡರಷ್ಟು ಈಡು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ಒಬ್ಬನು ತನ್ನ ಹೊಲದಲ್ಲಾಗಲಿ, ದ್ರಾಕ್ಷಿತೋಟದಲ್ಲಾಗಲಿ ತನ್ನ ದನಗಳನ್ನು ಮೇಯಿಸಿ, ಮತ್ತೊಬ್ಬನ ಹೊಲದಲ್ಲಾಗಲಿ, ದ್ರಾಕ್ಷಿತೋಟದಲ್ಲಾಗಲಿ ಮೇಯುವಂತೆ ಮಾಡಿದರೆ, ತನ್ನ ಹೊಲದ ಅಥವಾ ದ್ರಾಕ್ಷಿತೋಟದ ಉತ್ತಮ ಭಾಗವನ್ನು ಅವನಿಗೆ ಈಡು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","ಒಬ್ಬನು ಹೊತ್ತಿಸಿದ ಬೆಂಕಿ ಆಕಸ್ಮಾತ್ತಾಗಿ ಮುಳ್ಳಿನ ಗಿಡಗಳಿಗೆ ಬೆಂಕಿ ಹತ್ತಿಕೊಂಡು ಮತ್ತೊಬ್ಬನ ದವಸದ ರಾಶಿಗಳಾಗಲಿ, ಬೆಳೆಯಾಗಲಿ, ಹೊಲವಾಗಲಿ ಸುಟ್ಟು ಹೋದರೆ ಬೆಂಕಿ ಹೊತ್ತಿಸಿದವನು ಅದಕ್ಕೆ ಈಡುಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ಒಬ್ಬನು ಹಣವನ್ನಾಗಲಿ, ಒಡವೆಗಳನ್ನಾಗಲಿ ಕಾಪಾಡುವುದಕ್ಕೆ ಮತ್ತೊಬ್ಬನಿಗೆ ಒಪ್ಪಿಸಿದಾಗ ಅದು ಆ ಮನುಷ್ಯನ ಮನೆಯಲ್ಲಿ ಕಳ್ಳತನವಾಗಿ, ಕಳ್ಳನು ಸಿಕ್ಕಿಕೊಂಡರೆ ಎರಡರಷ್ಟು ದಂಡವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ಕಳ್ಳನು ಸಿಕ್ಕದೇ ಹೋದರೆ ಆ ಮನೆಯ ಯಜಮಾನನು ತಾನೇ ಆ ಒಡವೆಗಳನ್ನು ಕದ್ದನೋ ಇಲ್ಲವೋ ಎಂಬುದನ್ನು ದೃಢಪಡಿಸುವುದಕ್ಕಾಗಿ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಕಾಣಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ವಂಚನೆಯಾಯಿತೆಂಬ ಅನುಮಾನ ಹುಟ್ಟಿದ ಪ್ರತಿಯೊಂದರ ವಿಷಯದಲ್ಲಿಯೂ, ಅದು ಎತ್ತು, ಕತ್ತೆ, ಕುರಿ ಅಥವಾ ಬಟ್ಟೆಗಳ ವಿಷಯವಾದರೂ, ಕಳೆದುಕೊಂಡ ಬೇರೆ ಯಾವ ವಸ್ತುವಿನ ವಿಷಯವಾದರೂ, ಇಬ್ಬರು ಅದು ತಮ್ಮದೆಂದು ಹೇಳುವಾಗ ಆ ಇಬ್ಬರ ವ್ಯಾಜ್ಯವು ದೇವರ ಸನ್ನಿಧಿಗೆ ಬರಬೇಕು. ದೇವರು ಯಾರನ್ನು ದ್ರೋಹಿಯೆಂದು ನಿರ್ಣಯಿಸುತ್ತಾನೋ ಅವನು ಎರಡರಷ್ಟು ತನ್ನ ನೆರೆಯವನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ಒಬ್ಬನು ತನ್ನ ನೆರೆಯವನಿಗೆ ಕತ್ತೆಯನ್ನಾಗಲಿ, ಎತ್ತನ್ನಾಗಲಿ, ಕುರಿಯನ್ನಾಗಲಿ ಬೇರೆ ಯಾವ ಪಶುವನ್ನಾಗಲಿ ಕಾಪಾಡುವುದಕ್ಕೆ ಕೊಟ್ಟಿದ್ದು, ಅದು ಸತ್ತರೆ ಇಲ್ಲವೆ ಗಾಯಗೊಂಡರೆ ಇಲ್ಲವೆ ಯಾರೂ ತಿಳಿಯದಂತೆ ಕಳ್ಳತನವಾದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ಆ ಮನುಷ್ಯನು ತಾನೇ ಆ ಸೊತ್ತಿನ ವಿಷಯದಲ್ಲಿ ಮೋಸಮಾಡಲಿಲ್ಲ ಎಂಬುದನ್ನು ದೃಢಪಡಿಸುವುದಕ್ಕಾಗಿ ಯೆಹೋವನ ಮೇಲೆ ಪ್ರಮಾಣಮಾಡಬೇಕು. ಆಗ ಪಶುವಿನ ಒಡೆಯನು ಆ ಪ್ರಮಾಣವಾಕ್ಯವನ್ನು ನಂಬಬೇಕು. ಪ್ರಮಾಣಮಾಡಿದವನು ಅದಕ್ಕೆ ಈಡುಕೊಡಬೇಕಾದ ಅಗತ್ಯವಿರುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ಆದರೆ ಆ ಪಶುವು ಅವನ ಬಳಿಯಿಂದ ಕಳವಾದರೆ ಆ ವ್ಯಕ್ತಿ ಅದರ ಯಜಮಾನನಿಗೆ ಪ್ರತಿಯಾಗಿ ಈಡುಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ಕಾಡುಮೃಗವು ಆ ಪಶುವನ್ನು ಕೊಂದಿದ್ದರೆ, ಅದರ ಹೆಣವನ್ನು ಗುರುತಿಗಾಗಿ ತೋರಿಸಲಿ. ಕಾಡುಮೃಗ ಕೊಂದಿದ್ದಕ್ಕೆ ಈಡು ಕೊಡಬೇಕಾದ ಅಗತ್ಯವಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ಒಬ್ಬನು ಮತ್ತೊಬ್ಬನಿಂದ ಪಶುವನ್ನು ಸ್ವಲ್ಪ ಕಾಲಕ್ಕೆ ಬಾಡಿಗೆಗೆ ತೆಗೆದುಕೊಂಡಿರಲಾಗಿ ಆ ಪಶುವಿನ ಒಡೆಯನು ಅದರ ಹತ್ತಿರವಿಲ್ಲದ ಸಮಯದಲ್ಲಿ ಅದು ಗಾಯಗೊಂಡರೆ ಇಲ್ಲವೆ ಸತ್ತುಹೋದರೆ ಸಾಲ ತೆಗೆದುಕೊಂಡವನು ಈಡುಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ಯಜಮಾನನು ಅದರ ಹತ್ತಿರದಲ್ಲೇ ಇದಿದ್ದರೆ, ಅವನಿಗೆ ಈಡುಕೊಡಬೇಕಾದ ಅಗತ್ಯವಿಲ್ಲ. ಅದನ್ನು ಬಾಡಿಗೆಗೆ ತೆಗೆದುಕೊಂಡಿದ್ದರೆ ಅದಕ್ಕೆ ಉಂಟಾದ ನಷ್ಟವು ಬಾಡಿಗೆಯ ಲೆಕ್ಕಕ್ಕೆ ಎಣಿಕೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","ನಿಶ್ಚಿತಾರ್ಥವಾಗದ ಹೆಣ್ಣನ್ನು ಒಬ್ಬನು ಮರುಳುಗೊಳಿಸಿ ಸಂಗಮಿಸಿದರೆ ಅವಳಿಗೋಸ್ಕರ ತಕ್ಕ ತೆರವನ್ನು ಕೊಟ್ಟು ಅವಳನ್ನು ಮದುವೆಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ಅವಳ ತಂದೆ ಅವಳನ್ನು ಅವನಿಗೆ ಕೊಡುವುದಕ್ಕೆ ಒಪ್ಪದೇ ಹೋದರೆ ಆ ಮನುಷ್ಯನು ತಕ್ಕ ಹಣವನ್ನು ದಂಡವಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","ಮಾಟಗಾರ್ತಿಯನ್ನು ಜೀವದಿಂದ ಉಳಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","ಪಶುಸಂಗ ಮಾಡಿದವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","ಯೆಹೋವನೊಬ್ಬನಿಗೇ ಹೊರತಾಗಿ ಬೇರೊಬ್ಬ ದೇವರಿಗೆ ಯಜ್ಞ ಅರ್ಪಿಸುವವನು ಸಂಪೂರ್ಣವಾಗಿ ನಾಶವಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","ಪರದೇಶದವನಿಗೆ ಅನ್ಯಾಯ ಮಾಡಬಾರದು ಉಪದ್ರವ ಕೊಡಬಾರದು ನೀವು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಪರದೇಶಿಗಳಾಗಿದ್ದೀರಲ್ಲವೇ? ");
INSERT INTO kanirv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","ವಿಧವೆಯರನ್ನಾಗಲಿ, ದಿಕ್ಕಿಲ್ಲದ ಮಕ್ಕಳನ್ನಾಗಲಿ, ತೊಂದರೆಪಡಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ನೀವು ಇಂಥವರನ್ನು ತೊಂದರೆಪಡಿಸಿದರೆ ಅವರು ನನಗೆ ಮೊರೆಯಿಡುವರು ಆ ಮೊರೆಗೆ ನಾನು ಕಿವಿಗೊಡುವೆನೆಂದು ತಿಳಿದುಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ನಾನು ಕೋಪಗೊಂಡು ನಿಮ್ಮ ಶತ್ರುಗಳನ್ನು ಕತ್ತಿಯಿಂದ ಸಂಹಾರಮಾಡಿಸುವೆನು. ನಿಮ್ಮ ಹೆಂಡತಿಯರು ವಿಧವೆಯರಾಗುವರು. ನಿಮ್ಮ ಮಕ್ಕಳು ದಿಕ್ಕಿಲ್ಲದವರಾಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","ನನ್ನ ಜನರಲ್ಲಿ ಒಬ್ಬ ಬಡವನಿಗೆ ನೀನು ಹಣ ಕೊಟ್ಟರೆ ಅವನನ್ನು ಸಾಲಗಾರನಂತೆ ಕಾಣಬಾರದು. ಅವನಿಂದ ಬಡ್ಡಿಯನ್ನು ಕೇಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ನೀನು ಒಬ್ಬನ ಕಂಬಳಿಯನ್ನು ಅಡವು ಇಟ್ಟುಕೊಂಡರೆ ಸೂರ್ಯನು ಮುಳುಗುವಷ್ಟರಲ್ಲಿ ಅದನ್ನು ಹಿಂದಕ್ಕೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ಏಕೆಂದರೆ ಅದು ಅವನಿಗೆ ಒಂದೇ ಹೊದಿಕೆಯಾಗಿದೆ. ಅದೇ ಅವನ ಮೈಗೆ ಉಡುಪು. ಅವನು ಬೇರೆ ಯಾವುದನ್ನು ಹೊದ್ದುಕೊಂಡು ಮಲಗಬೇಕು? ಅವನು ನನಗೆ ಮೊರೆಯಿಟ್ಟರೆ ನಾನು ಕಿವಿಗೊಟ್ಟು ಕೇಳುವೆನು. ಏಕೆಂದರೆ ನಾನು ದಯಾಪರನು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","ದೇವರನ್ನು ದೂಷಿಸಬಾರದು. ನಿನ್ನ ಜನರ ಅಧಿಕಾರಿಗಳನ್ನು ನೀನು ಶಪಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","ನಿಮ್ಮ ಕಣದಿಂದ ಹಾಗೂ ದ್ರಾಕ್ಷಾಲತೆಯಿಂದ ನನಗೆ ಸಲ್ಲಿಸತಕ್ಕದ್ದನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕೆ ತಡಮಾಡಬಾರದು. ನಿಮ್ಮ ಚೊಚ್ಚಲು ಗಂಡು ಮಕ್ಕಳನ್ನು ನನಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ಅದರಂತೆಯೇ ನಿಮ್ಮ ಕುರಿ, ದನಗಳ ಚೊಚ್ಚಲು ಮರಿಗಳನ್ನು ನನಗೆ ಸಮರ್ಪಿಸಬೇಕು. ಏಳು ದಿನಗಳ ಕಾಲ ಆ ಮರಿ ತನ್ನ ತಾಯಿಯೊಂದಿಗಿರಲಿ. ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಅದನ್ನು ನನಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","ನೀವು ನನಗೆ ಪರಿಶುದ್ಧ ಜನರಾಗಿರಬೇಕು. ಆದುದರಿಂದ ಕಾಡುಮೃಗ ಕೊಂದದ್ದನ್ನು ನೀವು ತಿನ್ನಬಾರದು, ಅದನ್ನು ನಾಯಿಗಳಿಗೆ ಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","ಸುಳ್ಳು ಸುದ್ದಿಯನ್ನು ಹಬ್ಬಿಸಬಾರದು. ದುಷ್ಟರೊಂದಿಗೆ ಸೇರಿ ಸುಳ್ಳು ಸಾಕ್ಷಿಯನ್ನು ಹೇಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ದುಷ್ಟ ಕಾರ್ಯವನ್ನು ಮಾಡುವವರು ಬಹಳಮಂದಿ ಇದ್ದಾರೆ, ಆದಾಗ್ಯೂ ನೀವು ಅವರ ಜೊತೆಯಲ್ಲಿ ಸೇರಬಾರದು. ಬಹು ಮಂದಿಯ ಮಾತಿಗೆ ಒಪ್ಪಿ ನ್ಯಾಯವನ್ನು ಕೆಡಿಸುವ ಸಾಕ್ಷಿಯನ್ನು ಹೇಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ಇದಲ್ಲದೆ ಬಡವನ ಮೇಲಿನ ಕರುಣೆಯಿಂದ ಪಕ್ಷಪಾತದ ತೀರ್ಮಾನವನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","ನಿನ್ನ ವೈರಿಯ ಎತ್ತಾಗಲಿ, ಕತ್ತೆಯಾಗಲಿ ತಪ್ಪಿಸಿಕೊಂಡು ಹೋಗಿರಲಾಗಿ ಅದು ನಿನಗೆ ಸಿಕ್ಕಿದರೆ ಅದನ್ನು ಅವನ ಬಳಿಗೆ ಹೋಗಿ ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ನಿನ್ನನ್ನು ಹಗೆಮಾಡುವವನ ಕತ್ತೆಯ ಹೊರೆಯ ಕೆಳಗೆ ಬಿದ್ದಿರುವುದನ್ನು ಕಂಡರೆ, ಅದನ್ನು ಎಬ್ಬಿಸುವುದಕ್ಕೆ ಮನಸ್ಸಿಲ್ಲದಿದ್ದರೂ ಅವನಿಗೆ ಸಹಾಯ ಮಾಡಿ ಎಬ್ಬಿಸಲೇಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","ನಿಮ್ಮಲ್ಲಿರುವ ಬಡವರ ನ್ಯಾಯಕೋರಿ ನಿಮ್ಮ ಬಳಿಗೆ ಬಂದಾಗ ನೀವು ಅನ್ಯಾಯವಾಗಿ ತೀರ್ಮಾನಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ಮೋಸದ ಕಾರ್ಯಕ್ಕೆ ದೂರವಾಗಿರಬೇಕು. ನಿರಪರಾಧಿಯೂ, ನೀತಿವಂತನಾಗಿಯೂ ಇರುವ ಮನುಷ್ಯನಿಗೆ ಮರಣದಂಡನೆಯನ್ನು ವಿಧಿಸಲೇಬಾರದು. ಅಂಥ ದುಷ್ಟನಿಗೆ ನಾನು ಶಿಕ್ಷೆಯನ್ನು ವಿಧಿಸದೇ ಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ಲಂಚವನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಾರದು, ಲಂಚವು ಕಣ್ಣುಳ್ಳವರನ್ನು ಕುರುಡರಂತೆ ಮಾಡುತ್ತದೆ, ನಿರಪರಾಧಿಗೆ ದೊರಕಬೇಕಾದ ನ್ಯಾಯವನ್ನು ತಪ್ಪಿಸುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","ಪರದೇಶದವನಿಗೆ ಉಪದ್ರವವನ್ನು ಕೊಡಬಾರದು. ನೀವೂ ಐಗುಪ್ತದೇಶದಲ್ಲಿ ಪರದೇಶದವರಾಗಿದ್ದೀರಷ್ಟೇ. ಅಂಥವರ ಮನೋವ್ಯಥೆಯನ್ನು ತಿಳಿದವರಾಗಿದ್ದೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ಆರು ವರ್ಷ ನಿಮ್ಮ ಹೊಲವನ್ನು ಬಿತ್ತನೆಮಾಡಿ ಅದರ ಬೆಳೆಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ಆದರೆ ಏಳನೆಯ ವರ್ಷದಲ್ಲಿ ಆ ಭೂಮಿಯನ್ನು ಉಳದೆ ಬೀಳುಬಿಡಬೇಕು. ನಿಮ್ಮ ದೇಶದ ಬಡವರು ಅದರಲ್ಲಿ ಬೆಳೆಯುವುದನ್ನು ತಿನ್ನಲಿ. ಮಿಕ್ಕದ್ದನ್ನು ಕಾಡುಮೃಗಗಳು ಮೇಯಲಿ. ನಿಮ್ಮ ದ್ರಾಕ್ಷಿತೋಟಗಳ ಮತ್ತು ಎಣ್ಣೇ ಮರಗಳ ತೋಪುಗಳ ವಿಷಯದಲ್ಲಿಯೂ ಇದೇ ರೀತಿಯಲ್ಲಿ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ಆರು ದಿನಗಳು ನಿಮ್ಮ ಕೆಲಸವನ್ನು ನಡಿಸಿ ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನು ಮಾಡದೇ ಇರಬೇಕು. ಆ ಹೊತ್ತು ನಿಮ್ಮ ಎತ್ತುಗಳು, ಕತ್ತೆಗಳು, ದಾಸ, ದಾಸಿಯರು, ಪರದೇಶಸ್ಥರು ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ನಾನು ನಿಮಗೆ ಹೇಳಿದ್ದನ್ನೆಲ್ಲಾ ಜಾಗರೂಕತೆಯಿಂದ ಕೈಕೊಳ್ಳಬೇಕು. ಅನ್ಯ ದೇವರುಗಳ ಹೆಸರುಗಳನ್ನು ಸ್ಮರಿಸಬಾರದು, ಅವುಗಳನ್ನು ಉಚ್ಚರಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","ನೀವು ವರ್ಷಕ್ಕೆ ಮೂರಾವರ್ತಿ ನನಗೆ ಹಬ್ಬಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕಾದ ಹಬ್ಬ. ನಾನು ನಿಮಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ನೀವು ಚೈತ್ರಮಾಸದಲ್ಲಿ ನೇಮಕವಾದ ಕಾಲದಲ್ಲಿ ಏಳು ದಿನವೂ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು. ಆ ತಿಂಗಳಲ್ಲಿಯೇ ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಟು ಬಂದ ನೆನಪಿಗಾಗಿ ಇದನ್ನು ಆಚರಿಸಬೇಕು. ಕೈಯಲ್ಲಿ ಕಾಣಿಕೆಯಿಲ್ಲದೆ ಬರಿಗೈಯಲ್ಲಿ ನನ್ನ ಸನ್ನಿಧಿಗೆ ಯಾರು ಬರಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","ಅದಲ್ಲದೆ ನೀವು ಬಿತ್ತಿದ ಹೊಲದಲ್ಲಿ ಪ್ರಥಮಫಲವು ದೊರೆತಾಗ ಸುಗ್ಗಿಯ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ಹೊಲ ತೋಟಗಳ ಬೆಳೆಯನ್ನೂ ಕೂಡಿಸುವಾಗ ಅಂದರೆ ವರ್ಷದ ಕೊನೆಯಲ್ಲಿ ಸುಗ್ಗಿ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ವರ್ಷಕ್ಕೆ ಮೂರಾವರ್ತಿ ನಿಮ್ಮಲ್ಲಿರುವ ಗಂಡಸರೆಲ್ಲರೂ ಕರ್ತನಾದ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಒಟ್ಟಾಗಿ ಸೇರಿ ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","ನನಗೆ ಯಜ್ಞವನ್ನು ಮಾಡುವಾಗ ಆ ಯಜ್ಞಪಶುವಿನ ರಕ್ತದೊಡನೆ ಹುಳಿಯಾದ ಹಿಟ್ಟನ್ನು ಸಮರ್ಪಿಸಬಾರದು. ನನ್ನ ಹಬ್ಬದಲ್ಲಿ ನೀವು ನನಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಪಶುವಿನ ಕೊಬ್ಬನ್ನು ಮರುದಿನದವರೆಗೆ ಇಡಲೇಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ನಿಮ್ಮ ಬೆಳೆಯ ಪ್ರಥಮಫಲದಲ್ಲಿ ಅತಿ ಶ್ರೇಷ್ಠವಾದದ್ದನ್ನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಮಂದಿರಕ್ಕೆ ತರಬೇಕು. ಹೋತ ಮರಿಯನ್ನು ಅದರ ತಾಯಿಯ ಹಾಲಿನಲ್ಲಿ ಬೇಯಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ಇಗೋ ದಾರಿಯಲ್ಲಿ ನಿಮ್ಮನ್ನು ಕಾಪಾಡುವುದಕ್ಕೂ, ನಾನು ಗೊತ್ತುಮಾಡಿರುವ ಸ್ಥಳಕ್ಕೆ ನಿಮ್ಮನ್ನು ಕರೆತರುವುದಕ್ಕೂ ದೂತನನ್ನು ನಿಮ್ಮ ಮುಂದಾಗಿ ಕಳುಹಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ನೀವು ಆತನಲ್ಲಿ ಲಕ್ಷ್ಯವಿಟ್ಟು ಆತನ ಮಾತಿಗೆ ವಿಧೇಯರಾಗಿರಬೇಕು. ಆತನನ್ನು ಧಿಕ್ಕರಿಸಿದರೆ ನಿಮ್ಮ ಅಪರಾಧವನ್ನು ಕ್ಷಮಿಸಲಾರನು. ನನ್ನ ನಾಮಮಹಿಮೆ ಆತನಲ್ಲಿ ಇರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ನೀವು ಆತನ ಮಾತುಗಳನ್ನು ಶ್ರದ್ಧೆಯಿಂದ ಆಲಿಸಿ ನನ್ನ ಆಜ್ಞೆಗಳ ಪ್ರಕಾರ ನಡೆದುಕೊಂಡರೆ ನಾನು ನಿಮ್ಮ ಶತ್ರುಗಳಿಗೆ ಶತ್ರುವಾಗಿಯೂ, ನಿಮ್ಮನ್ನು ಪೀಡಿಸುವವರನ್ನು ಪೀಡಿಸುವವನಾಗಿಯೂ ಇರುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ನನ್ನ ದೂತನು ನಿಮ್ಮ ಮುಂದಾಗಿ ಹೊರಟು ಅಮೋರಿಯರು, ಹಿತ್ತಿಯರು, ಪೆರಿಜೀಯರು, ಕಾನಾನ್ಯರು, ಹಿವ್ವಿಯರು, ಯೆಬೂಸಿಯರೂ ಇರುವ ದೇಶಕ್ಕೆ ನಿಮ್ಮನ್ನು ಸೇರಿಸುವನು. ಅವರನ್ನಾದರೋ ನಾನು ನಿರ್ಮೂಲಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ಅವರ ದೇವತೆಗಳಿಗೆ ನೀವು ಅಡ್ಡಬಿದ್ದು ನಮಸ್ಕರಿಸಲೂ ಬಾರದು, ಅವರ ಆಚರಣೆಗಳನ್ನು ಅನುಸರಿಸಲೇ ಬಾರದು. ಆ ಜನಗಳನ್ನು ನಿರ್ಮೂಲಮಾಡಿ ವಿಗ್ರಹಸ್ತಂಭಗಳನ್ನು ನಾಶಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನೊಬ್ಬನನ್ನೇ ಆರಾಧಿಸಬೇಕು. ಆಗ ಆತನು ನಿಮ್ಮ ಅನ್ನಪಾನಗಳನ್ನು ಆಶೀರ್ವದಿಸುವನು. ನಿಮ್ಮಲ್ಲಿರುವ ವ್ಯಾಧಿಯನ್ನು ತೆಗೆದುಹಾಕುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಗರ್ಭಪಾತವಾಗಲಿ, ಬಂಜೆತನವಾಗಲಿ ಇರುವುದೇ ಇಲ್ಲ. ನಿಮಗೆ ಸಂಪೂರ್ಣವಾದ ಆಯುಷ್ಯವನ್ನು ದಯಪಾಲಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ನೀವು ಹೋಗುವ ಎಲ್ಲಾ ಕಡೆಗಳಲ್ಲಿಯೂ ನಾನು ಜನಗಳ ಮನಸ್ಸಿನಲ್ಲಿ ಹೆದರಿಕೆಯನ್ನುಂಟು ಮಾಡಿ ಅವರನ್ನು ಕಳವಳಗೊಳಿಸಿ, ನಿಮ್ಮ ವಿರೋಧಿಗಳೆಲ್ಲರೂ ಓಡಿಹೋಗುವಂತೆ ಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ಅದಲ್ಲದೆ ಕಡಜದ ಹುಳಗಳನ್ನು ನಿಮಗೆ ಮುಂಚಿತವಾಗಿ ಕಳುಹಿಸಿ ಹಿವ್ವಿಯರು, ಕಾನಾನ್ಯರು, ಹಿತ್ತಿಯರು ನಿಮ್ಮ ಮುಂದೆ ನಿಲ್ಲದಂತೆ ಅವು ಅವರನ್ನು ಓಡಿಸಿಬಿಡುವಂತೆ ಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ಆದರೆ ನಾನು ಒಂದೇ ವರ್ಷದೊಳಗೆ ಅವರೆಲ್ಲರನ್ನು ಅಲ್ಲಿಂದ ಹೊರಡಿಸುವುದಿಲ್ಲ. ಏಕೆಂದರೆ ದೇಶದಲ್ಲಿ ಜನರು ಕಡಿಮೆಯಾಗುವುದರಿಂದ ಕಾಡುಮೃಗಗಳು ಹೆಚ್ಚಿ ನಿಮಗೆ ತೊಂದರೆಯಾದೀತು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ನೀವು ಅಭಿವೃದ್ಧಿಯಾಗಿ ದೇಶದಲ್ಲೆಲ್ಲಾ ತುಂಬಿಕೊಳ್ಳುವ ತನಕ ಅವರನ್ನು ಸ್ವಲ್ಪ ಸ್ವಲ್ಪವಾಗಿ ಹೊರಡಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ಕೆಂಪುಸಮುದ್ರದಿಂದ ಫಿಲಿಷ್ಟಿಯರ ದೇಶದ ಬಳಿಯಲ್ಲಿರುವ ಸಮುದ್ರದವರೆಗೂ ಮತ್ತು ಈ ಅರಣ್ಯದಿಂದ ಯೂಫ್ರೆಟಿಸ್ ಮಹಾನದಿಯವರೆಗೂ ಇರುವ ದೇಶವನ್ನೆಲ್ಲಾ ನಿಮಗಾಗಿ ನೇಮಿಸಿ ಅದರಲ್ಲಿರುವ ನಿವಾಸಿಗಳನ್ನು ನಿಮಗೆ ಅಧೀನಪಡಿಸುವೆನು. ನೀವು ಅವರನ್ನು ಹೊರಡಿಸುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ನೀವು ಅವರೊಡನೆ ಅವರ ದೇವತೆಗಳೊಡನೆ ಆಗಲಿ ಯಾವುದೇ ವಿಧವಾದ ಒಡಂಬಡಿಕೆಯನ್ನೂ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ಅವರು ನಿಮ್ಮ ದೇಶದಲ್ಲೇ ವಾಸವಾಗಿರಬಾರದು. ವಾಸವಾಗಿದ್ದರೆ ನನಗೆ ವಿರುದ್ಧವಾಗಿ ನೀವು ಪಾಪ ಮಾಡುವಂತೆ ಅವರು ಪ್ರೇರೇಪಿಸುವರು. ನೀವು ಅವರ ದೇವತೆಗಳನ್ನು ಪೂಜಿಸಿದರೆ ಆ ಪೂಜೆಯು ನಿಮಗೆ ಉರುಲಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು, ಆರೋನ್, ನಾದಾಬ್, ಅಬೀಹೂ ಹಾಗೂ ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರಲ್ಲಿ ಎಪ್ಪತ್ತು ಮಂದಿ ಈ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಯೆಹೋವನ ಬಳಿಗೆ ಬಂದು ದೂರದಲ್ಲಿ ನಿಂತು ಅಡ್ಡಬಿದ್ದು ಆರಾಧಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ಮೋಶೆ ಒಬ್ಬನೇ ಯೆಹೋವನ ಸಮೀಪಕ್ಕೆ ಬರಬೇಕೇ ಹೊರತು ಬೇರೆ ಯಾರು ಸಮೀಪಕ್ಕೆ ಬರಬಾರದು. ಮಿಕ್ಕ ಜನರು ಬೆಟ್ಟವನ್ನು ಹತ್ತಲೇಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ಮೋಶೆ ಜನರ ಬಳಿಗೆ ಬಂದು ಯೆಹೋವನ ಎಲ್ಲಾ ಮಾತುಗಳನ್ನೂ ಮತ್ತು ಅಜ್ಞಾವಿಧಿಗಳನ್ನೂ ವಿವರಿಸಲು ಜನರೆಲ್ಲರೂ, “ಯೆಹೋವನ ಮಾತುಗಳನ್ನೆಲ್ಲಾ ಅನುಸರಿಸಿ ನಡೆಯುವೆವು” ಎಂದು ಒಕ್ಕೊರಳಿನಿಂದ ಉತ್ತರಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ಮೋಶೆಯು ಯೆಹೋವನ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ಬರೆದಿಟ್ಟನು. ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಆ ಬೆಟ್ಟದ ತಪ್ಪಲಲ್ಲಿ ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸಿ ಇಸ್ರಾಯೇಲರ ಹನ್ನೆರಡು ಕುಲಗಳಿಗೆ ಸರಿಯಾಗಿ ಹನ್ನೆರಡು ಕಲ್ಲಿನ ಕಂಬಗಳನ್ನು ಸ್ಥಾಪನೆಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ಇಸ್ರಾಯೇಲರ ಯೌವನಸ್ಥರಿಗೆ ನೀವು ಯೆಹೋವನಿಗೋಸ್ಕರ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನು ಮಾಡಿ ಸಮಾಧಾನ ಯಜ್ಞಕ್ಕಾಗಿ ಹೋರಿಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕೆಂದು ಅಪ್ಪಣೆಕೊಟ್ಟು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ಅನಂತರ ಮೋಶೆ ಆ ರಕ್ತದಲ್ಲಿ ಅರ್ಧವನ್ನು ತೆಗೆದುಕೊಂಡು ಬಟ್ಟಲುಗಳಲ್ಲಿ ತುಂಬಿ ಅರ್ಧವನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಪ್ರೋಕ್ಷಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ತರುವಾಯ ಒಡಂಬಡಿಕೆಯ ಗ್ರಂಥವನ್ನು ತೆಗೆದುಕೊಂಡು ಜನರಿಗೆ ಕೇಳಿಸುವಂತೆ ಓದಿದನು. ಅವರು ಕೇಳಿ, “ಯೆಹೋವನ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ನಾವು ಅನುಸರಿಸಿ ವಿಧೇಯರಾಗುವೆವು” ಅಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ಆಗ ಮೋಶೆಯು ಆ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ಜನರ ಮೇಲೆ ಚಿಮುಕಿಸಿ, “ಇಗೋ ಈ ಗ್ರಂಥದಲ್ಲಿ ಹೇಳಿರುವ ಎಲ್ಲಾ ಆಜ್ಞೆಗಳ ಪ್ರಕಾರ ಯೆಹೋವನು ನಿಮ್ಮ ಸಂಗಡ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಯ ರಕ್ತವು ಇದೇ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ಮೋಶೆ, ಆರೋನ್, ನಾದಾಬ್, ಅಬೀಹೂ ಹಾಗೂ ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರಲ್ಲಿ ಎಪ್ಪತ್ತು ಜನರು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ಅವರಿಗೆ ಇಸ್ರಾಯೇಲರ ದೇವರ ದರ್ಶನವಾಯಿತು. ಅವರು ದೇವರನ್ನು ನೋಡಿದರು. ಆಕಾಶಮಂಡಲದಂತೆ ಅತಿ ನಿರ್ಮಲವಾದ ಇಂದ್ರನೀಲಮಣಿಯ ನೆಲಗಟ್ಟು ಆತನ ಪಾದಪೀಠವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ಆತನು ಇಸ್ರಾಯೇಲರ ಮುಖಂಡರಿಗೆ ಯಾವ ಕೇಡನ್ನೂ ಮಾಡಲಿಲ್ಲ. ಅವರು ದೇವರನ್ನು ನೋಡಿ ಅನ್ನಪಾನಗಳನ್ನು ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಬಂದು ನನ್ನ ಹತ್ತಿರದಲ್ಲೇ ಇರು. ನೀನು ಆ ಧರ್ಮಶಾಸ್ತ್ರವನ್ನೂ ಮತ್ತು ಆಜ್ಞೆಗಳನ್ನೂ ಜನರಿಗೆ ಬೋಧಿಸುವಂತೆ ನಾನು ಅವುಗಳನ್ನು ಬರೆದಿರುವ ಶಿಲಾಶಾಸನಗಳನ್ನು ನಿನಗೆ ಕೊಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ಮೋಶೆಯು ತನ್ನ ಶಿಷ್ಯನಾದ ಯೆಹೋಶುವನೊಂದಿಗೆ ಎದ್ದು ದೇವರ ಬೆಟ್ಟದ ಮೇಲಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ಇದಕ್ಕೆ ಮೊದಲು ಅವನು ಹಿರಿಯರಿಗೆ, “ನಾವು ತಿರುಗಿ ನಿಮ್ಮ ಬಳಿಗೆ ಬರುವ ತನಕ ನೀವು ಇಲ್ಲೇ ಕಾದುಕೊಂಡಿರಿ. ಆರೋನನು ಮತ್ತು ಹೂರನು ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿರುವರು. ಯಾರಿಗಾದರೂ ವ್ಯಾಜ್ಯವಿದ್ದ ಪಕ್ಷಕ್ಕೆ ಅವರ ಹತ್ತಿರಕ್ಕೆ ಹೋಗಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ಮೋಶೆಯು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿದನು ಮತ್ತು ಮೇಘವು ಬೆಟ್ಟವನ್ನು ಆವರಿಸಿಕೊಂಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ಯೆಹೋವನ ತೇಜಸ್ಸು ಸೀನಾಯಿಬೆಟ್ಟದ ಮೇಲೆ ನೆಲೆಗೊಂಡಿತ್ತು ಮತ್ತು ಆ ಮೇಘವು ಆರು ದಿನಗಳ ವರೆಗೂ ಬೆಟ್ಟವನ್ನು ಆವರಿಸಿಕೊಂಡಿತ್ತು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ಮೇಘದೊಳಗಿನಿಂದ ಮೋಶೆಯನ್ನು ಕೂಗಿ ಕರೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ಯೆಹೋವನ ತೇಜಸ್ಸು ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿ ದಹಿಸುವ ಬೆಂಕಿಯಂತೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಕಾಣಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ಮೋಶೆಯು ಆ ಮೇಘದೊಳಗೆ ಪ್ರವೇಶಿಸಿ ಬೆಟ್ಟವನ್ನೇರಿದನು. ಅವನು ಆ ಬೆಟ್ಟದಲ್ಲಿ ನಲ್ವತ್ತು ದಿನ ಹಗಲಿರುಳು ಆ ಬೆಟ್ಟದಲ್ಲಿಯೇ ಇದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ಇಸ್ರಾಯೇಲರು ನನಗಾಗಿ ಕಾಣಿಕೆಯನ್ನು ತರಬೇಕೆಂದು ಅವರಿಗೆ ಹೇಳು. ಮನಃಪೂರ್ವಕವಾಗಿ ಕೊಡುವವರಿಂದಲೇ ಆ ಕಾಣಿಕೆಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ನೀನು ಅವರಿಂದ ತೆಗೆದುಕೊಳ್ಳಬೇಕಾದ ಕಾಣಿಕೆಗಳು ಯಾವುವೆಂದರೆ, ಚಿನ್ನ, ಬೆಳ್ಳಿ, ಹಾಗೂ ತಾಮ್ರ ಎಂಬ ಲೋಹಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ನೀಲಿ, ನೇರಳೆ, ರಕ್ತಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳೂ, ನಾರುಬಟ್ಟೆಗಳೂ, ಆಡು ಕೂದಲಿನ ಉಣ್ಣೆಯ ಬಟ್ಟೆಗಳೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ಹದಮಾಡಿರುವ ಕೆಂಪುಬಣ್ಣದ ಟಗರಿನ ತೊಗಲುಗಳು, ಕಡಲಪ್ರಾಣಿಯ ತೊಗಲುಗಳೂ, ಜಾಲೀಮರವೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ದೀಪಕ್ಕೆ ಬೇಕಾದ ಎಣ್ಣೆಯೂ, ಅಭಿಷೇಕ ತೈಲಕ್ಕೆ ಮತ್ತು ಪರಿಮಳಧೂಪಕ್ಕೆ ಬೇಕಾದ ಸುಗಂಧದ್ರವ್ಯಗಳೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ಮಹಾಯಾಜಕನ ಕವಚಕ್ಕೆ ಹಾಗೂ ಎದೆಗೆ ಧರಿಸುವ ಪದಕದ ಮೇಲೆ ಇರಿಸಲು ಬೇಕಾಗಿರುವ ಗೋಮೇಧಕರತ್ನಗಳು ಹಾಗೂ ಇತರ ರತ್ನಗಳೂ ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“ನಾನು ಅವರ ಮಧ್ಯದಲ್ಲಿ ವಾಸಮಾಡುವುದಕ್ಕೆ ನನಗೆ ಒಂದು ಗುಡಾರವನ್ನು ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ನಾನು ನಿನಗೆ ತೋರಿಸುವ ಮಾದರಿಯಲ್ಲಿಯೇ ಗುಡಾರವನ್ನೂ ಅದರಲ್ಲಿರುವ ಎಲ್ಲಾ ಸಾಮಾನುಗಳನ್ನೂ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“ನೀನು ಜಾಲೀಮರದಿಂದ ಒಂದು ಮಂಜೂಷವನ್ನು ಮಾಡಿಸಬೇಕು. ಅದು ಎರಡುವರೆ ಮೊಳ ಉದ್ದವು, ಒಂದುವರೆ ಮೊಳ ಅಗಲವು ಹಾಗೂ ಒಂದುವರೆ ಮೊಳ ಎತ್ತರವು ಆಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ಚೊಕ್ಕ ಬಂಗಾರದ ತಗಡುಗಳನ್ನು ಅದರ ಹೊರಗಡೆಯೂ ಹಾಗೂ ಒಳಗಡೆಯೂ ಹೊದಿಸಬೇಕು. ಅದರ ಮೇಲೆ ಸುತ್ತಲೂ ಚಿನ್ನದ ತೋರಣ ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ನಾಲ್ಕು ಬಂಗಾರದ ಬಳೆಗಳನ್ನು ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿರುವ ಒಂದೊಂದು ಕಾಲಿಗೂ ಎರಡೆರಡು ಬಳೆಗಳನ್ನು ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ಆ ಮಂಜೂಷವನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ನೀನು ಜಾಲೀಮರದ ಕಂಬಗಳನ್ನು ಮಾಡಿಸಿ ಅವುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ಮಂಜೂಷದ ಎರಡು ಕಡೆಗಳಲ್ಲಿರುವ ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ಆ ಕಂಬಗಳನ್ನು ಮಂಜೂಷದ ಬಳೆಗಳಿಂದ ತೆಗೆಯದೇ ಅವುಗಳಲ್ಲಿಯೇ ಬಿಟ್ಟಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ಆ ಮಂಜೂಷದಲ್ಲಿ ನಾನು ನಿನಗೆ ಕೊಡುವ ಆಜ್ಞಾಶಾಸನವನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ಚೊಕ್ಕ ಬಂಗಾರದ ಕೃಪಾಸನವನ್ನು ಮಾಡಿಸಬೇಕು. ಅದು ಎರಡುವರೆ ಮೊಳ ಉದ್ದವು, ಒಂದುವರೆ ಮೊಳ ಅಗಲವೂ ಆಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ಕೃಪಾಸನದ ಎರಡು ಕೊನೆಗಳಲ್ಲಿ ಎರಡು ಬಂಗಾರದ ಕೆರೂಬಿಗಳನ್ನು ಕೆತ್ತನೆ ಕೆಲಸದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ಕೃಪಾಸನದ ಒಂದೊಂದು ಕೊನೆಯಲ್ಲಿ ಒಂದೊಂದು ಕೆರೂಬಿಯನ್ನು ಮಾಡಿಸಿ ಅವುಗಳನ್ನು ಕೃಪಾಸನಕ್ಕೆ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ಆ ಕೆರೂಬಿಗಳು ಮೇಲಕ್ಕೆ ರೆಕ್ಕೆಗಳನ್ನು ಚಾಚಿರುವಂತೆಯೂ ಮತ್ತು ಕೃಪಾಸನವನ್ನು ತಮ್ಮ ರೆಕ್ಕೆಗಳಿಂದ ಮುಚ್ಚಿರುವಂತೆಯೂ ಇರಿಸಬೇಕು. ಅವುಗಳ ಮುಖಗಳು ಎದುರುಬದುರಾಗಿ ಕೃಪಾಸನವನ್ನು ನೋಡುವಂತಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ಆ ಕೃಪಾಸನವನ್ನು ಮಂಜೂಷದ ಮೇಲಿರಿಸಬೇಕು. ನಾನು ನಿನಗೆ ಕೊಡುವ ಆಜ್ಞಾಶಾಸನಗಳನ್ನು ಆ ಮಂಜೂಷದೊಳಗೆ ಇರಿಸಬೇಕು ");
INSERT INTO kanirv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ಅಲ್ಲಿಯೇ ನಾನು ನಿನಗೆ ದರ್ಶನವನ್ನು ಕೊಡುವೆನು. ಕೃಪಾಸನದ ಮೇಲೆ ಆಜ್ಞಾಶಾಸನಗಳನ್ನು ಇಟ್ಟಿರುವ ಮಂಜೂಷದ ಮೇಲಣ ಎರಡು ಕೆರೂಬಿಗಳ ನಡುವೆಯೇ ನಾನು ಇದ್ದು ನಿನ್ನ ಸಂಗಡ ಮಾತನಾಡಿ ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕಾಗಿರುವ ಎಲ್ಲಾ ಸಂಗತಿಗಳನ್ನು ತಿಳಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ನೀನು ಜಾಲೀಮರದಿಂದ ಒಂದು ಮೇಜನ್ನು ಮಾಡಿಸಬೇಕು. ಅದು ಎರಡು ಮೊಳ ಉದ್ದವಾಗಿಯೂ, ಒಂದು ಮೊಳ ಅಗಲವಾಗಿಯೂ, ಒಂದುವರೆ ಮೊಳ ಎತ್ತರವಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ಅದಕ್ಕೆ ಚೊಕ್ಕ ಬಂಗಾರದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿ, ಸುತ್ತಲೂ ಚಿನ್ನದ ತೋರಣ ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ಮೇಜಿನ ಸುತ್ತಲೂ ಅಂಗೈ ಅಗಲದ ಅಡ್ಡ ಪಟ್ಟಿಯನ್ನು ಮಾಡಿಸಿ ಅದಕ್ಕೂ ಚಿನ್ನದ ತೋರಣ ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ನಾಲ್ಕು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿಸಿ ಮೇಜಿನ ನಾಲ್ಕು ಕಾಲುಗಳಿಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ಆ ಬಳೆಗಳು ಅಡ್ಡಪಟ್ಟಿಗೆಗೆ ಅಂಟಿಕೊಂಡಿರಬೇಕು. ಮೇಜನ್ನು ಎತ್ತುವುದಕ್ಕಾಗಿ ಕೋಲುಗಳನ್ನು ಅವುಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ಆ ಕೋಲುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸಿ ಅವುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಬೇಕು. ಅವುಗಳಿಂದಲೇ ಮೇಜನ್ನು ಎತ್ತಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ಮೇಜಿನ ಮೇಲಿಡಬೇಕಾದ ಹರಿವಾಣಗಳನ್ನು, ಧೂಪಾರತಿಗಳನ್ನು, ಹೂಜಿಗಳನ್ನು, ಪಾನದ್ರವ್ಯವನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕೆ ಬೇಕಾದ ಬಟ್ಟಲುಗಳನ್ನು ಚೊಕ್ಕ ಬಂಗಾರದಿಂದಲೇ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ನೈವೇದ್ಯದ ರೊಟ್ಟಿಗಳು ಪ್ರತಿದಿನ ಆ ಮೇಜಿನ ಮೇಲೆ ನನ್ನ ಸಮ್ಮುಖದಲ್ಲಿಯೇ ಇಟ್ಟಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“ಚೊಕ್ಕ ಬಂಗಾರದ ದೀಪಸ್ತಂಭವನ್ನು ಮಾಡಿಸಬೇಕು. ಅದರ ಕೆಳಭಾಗವನ್ನು ಕಂಬವನ್ನೂ ನಕಾಸಿ ಕೆಲಸದಿಂದ ಮಾಡಿಸಬೇಕು. ಆ ದೀಪಸ್ತಂಭದ ಬುಡದಿಂದಲೇ ಅಖಂಡವಾಗಿ ಪುಷ್ಪದ ಗೊಂಚಲುಗಳು, ಅರಳಿದ ಪುಷ್ಪಗಳು ಮೊಗ್ಗುಗಳು ಅಲಂಕಾರವಾಗಿ ಕೆತ್ತಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ಕಂಬದ ಒಂದೊಂದು ಪಾರ್ಶ್ವದಲ್ಲಿಯೂ ಮೂರು ಮೂರು ಕೊಂಬೆಗಳಂತೆ ಹಾಗೆ ಆರು ಕೊಂಬೆಗಳೂ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ಪ್ರತಿಯೊಂದು ಕೊಂಬೆಗಳಲ್ಲಿ ಬಾದಾಮಿ ಹೂವುಗಳಂತಿರುವ ಮೂರು ಮೂರು ಹೂವುಗಳೂ ಮೊಗ್ಗುಗಳೂ ಇರಬೇಕು. ದೀಪಸ್ತಂಭದಿಂದ ಬರುವ ಆರು ಕೊಂಬೆಗಳನ್ನು ಹಾಗೆಯೇ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ದೀಪಸ್ತಂಭದ ಕಂಬದಲ್ಲಿ ಪುಷ್ಪಗುಚ್ಛಗಳೂ, ಪುಷ್ಪಗಳೂ, ಮೊಗ್ಗುಗಳು ಇರುವ ಬಾದಾಮಿ ಹೂವುಗಳಂತೆ ನಾಲ್ಕು ಪುಷ್ಪಾಲಂಕಾರಗಳೂ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ಎರಡೆರಡು ಕೊಂಬೆಗಳು ಕವಲು ಒಡೆದಿರುವ ಸ್ಥಳಗಳಲ್ಲೆಲ್ಲಾ ಒಂದೊಂದು ಮೊಗ್ಗು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ಪುಷ್ಪಪಾತ್ರೆಗಳೂ, ಕೊಂಬುಗಳೂ ಸಹಿತವಾದ ದೀಪಸ್ತಂಭವನ್ನೆಲ್ಲಾ ಒಟ್ಟಿಗೆ ಚೊಕ್ಕ ಬಂಗಾರದಿಂದ ನಕಾಸಿ ಕೆಲಸದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ಅದಕ್ಕೆ ಏಳು ಹಣತೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಆ ಹಣತೆಗಳ ಬೆಳಕು ಎದುರಿನಿಂದ ಬೀಳುವಂತೆ ಅವುಗಳನ್ನು ಹಚ್ಚಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ದೀಪದ ಕುಡಿತೆಗೆಯುವ ಕತ್ತರಿಗಳೂ, ಕತ್ತರಿಸಿದ ಕುಡಿಗಳನ್ನು ಹಾಕುವ ಬಟ್ಟಲುಗಳನ್ನೂ ಚೊಕ್ಕ ಬಂಗಾರದಿಂದಲೇ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ದೀಪಸ್ತಂಭವೂ ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳೂ ಒಂದು ತಲಾಂತು ಚೊಕ್ಕ ಬಂಗಾರವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ನೋಡು, ಬೆಟ್ಟದಲ್ಲಿ ನಾನು ನಿನಗೆ ತೋರಿಸಿದ ಮಾದರಿಯಲ್ಲಿಯೇ ಎಲ್ಲವನ್ನು ಎಚ್ಚರಿಕೆಯಿಂದ ಮಾಡಿಸಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ನನ್ನ ನಿವಾಸಕ್ಕಾಗಿ ಒಂದು ಗುಡಾರವನ್ನು ಹತ್ತು ಪರದೆಗಳಿಂದ ಮಾಡಿಸಬೇಕು. ಅವು ನಯವಾಗಿ ಹೊಸೆದ ನಾರಿನ ಬಟ್ಟೆಗಳಾಗಿರಬೇಕು. ಅವುಗಳಲ್ಲಿ ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕಡುಗೆಂಪು ವರ್ಣಗಳ ದಾರದಿಂದ ಕೆರೂಬಿಗಳನ್ನು ನೇಯ್ಗೆಯಿಂದ ಕಸೂತಿ ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ಪ್ರತಿಯೊಂದು ಬಟ್ಟೆಯೂ ಇಪ್ಪತ್ತೆಂಟು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ನಾಲ್ಕು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇರಬೇಕು. ಎಲ್ಲಾ ಪರದೆಗಳು ಒಂದೇ ಅಳತೆಯಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ಐದೈದು ಬಟ್ಟೆಯ ಪರದೆಗಳನ್ನು ಒಂದೊಂದಾಗಿ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ಈ ಎರಡು ಜೋಡಣೆಗಳಲ್ಲಿ ಒಂದೊಂದರ ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ನೀಲಿ ದಾರದಿಂದ ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ಆ ಕುಣಿಕೆಗಳು ಐವತ್ತೈವತ್ತರ ಮೇರೆಗೆ ಒಂದಕ್ಕೊಂದು ಎದುರುಬದುರಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ಅದಲ್ಲದೆ ಐವತ್ತು ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿಸಿ ಆ ಪರದೆಗಳನ್ನು ಒಂದಕ್ಕೊಂದು ಹೆಣೆದು ಒಂದೇ ಗುಡಾರವಾಗುವಂತೆ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","ಈ ಗುಡಾರದ ಮೇಲೆ ಹೊದಿಸುವುದಕ್ಕಾಗಿ ಆಡಿನ ರೋಮದಿಂದ ಹನ್ನೊಂದು ಪರದೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ಒಂದೊಂದು ಪರದೆಯು ಮೂವತ್ತು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ನಾಲ್ಕು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇರಬೇಕು. ಎಲ್ಲಾ ಪರದೆಗಳು ಒಂದೇ ಅಳತೆಯಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ಐದು ಪರದೆಗಳನ್ನು ಒಂದಾಗಿ ಜೋಡಿಸಿ ಮಿಕ್ಕ ಆರು ಪರದೆಗಳನ್ನು ಒಂದಾಗಿ ಜೋಡಿಸಿ ಆರನೆಯ ಪರದೆಯನ್ನು ಗುಡಾರದ ಮುಂಭಾಗದಲ್ಲಿ ಮಡಿಸಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ಹೀಗೆ ಜೋಡಿಸಿ ಹೆಣೆದ ಪರದೆಗಳ ಅಂಚಿನಲ್ಲಿ ಐವತ್ತೈವತ್ತು ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ತಾಮ್ರದ ಐವತ್ತು ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿಸಿ ಆ ಕೊಂಡಿಗಳನ್ನು ಕುಣಿಕೆಗಳಲ್ಲಿ ಸಿಕ್ಕಿಸಿ ಸಮಸ್ತವು ಸೇರಿ ಒಂದೇ ಗುಡಾರವಾಗುವಂತೆ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ಹೊದಿಕೆಯ ಪರದೆಗಳಲ್ಲಿ ಅರ್ಧ ಪರದೆ ಹೆಚ್ಚಾಗಿರುವುದು, ಆ ಹೆಚ್ಚಿನ ಭಾಗವು ಗುಡಾರದ ಹಿಂಭಾಗದಲ್ಲಿ ಮಡಿಸಿ ತೂಗಾಡುವಂತೆ ಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ಹೊದಿಕೆಯ ಪರದೆಗಳ ಉದ್ದದಲ್ಲಿ ಈ ಕಡೆ ಒಂದು ಮೊಳವೂ, ಆ ಕಡೆ ಒಂದು ಮೊಳವೂ ಹೆಚ್ಚಾಗಿರುವುದು. ಅದು ಒಳಗಣ ಗುಡಾರವನ್ನು ಮುಚ್ಚುವಂತೆ ಈ ಕಡೆಯೂ ಆ ಕಡೆಯೂ ತೂಗಾಡುವಂತಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ಈ ಹೊದಿಕೆಗೆ ಹೊದಿಸುವುದಕ್ಕಾಗಿ ಹದಮಾಡಿರುವ ಕೆಂಪುಬಣ್ಣದ ಟಗರಿನ ತೊಗಲುಗಳಿಂದ ಒಂದು ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಕಡಲಪ್ರಾಣಿಯ ತೊಗಲುಗಳಿಂದ ಮತ್ತೊಂದು ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","ಗುಡಾರಕ್ಕೆ ಬೇಕಾದ ಚೌಕಟ್ಟುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟು ಹತ್ತು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ಮತ್ತು ಒಂದೂವರೆ ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟು ಅಡ್ಡಪಟ್ಟಿಗಳಿಂದ ಜೋಡಿಸಲ್ಪಟ್ಟ ಎರಡು ನಿಲುವು ಪಟ್ಟಿಗಳುಳ್ಳದ್ದಾಗಿರಬೇಕು. ಗುಡಾರದ ಎಲ್ಲಾ ಚೌಕಟ್ಟುಗಳನ್ನೂ ಹಾಗೆಯೇ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ಗುಡಾರದ ದಕ್ಷಿಣದಿಕ್ಕಿನಲ್ಲಿ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ನಲ್ವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳನ್ನು (ಅಡಿಗಲ್ಲು) ಮಾಡಿಸಿ ಆ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳ ಕೆಳಗೆ ಇಡಬೇಕು. ಒಂದೊಂದು ಚೌಕಟ್ಟಿನಲ್ಲಿರುವ ಎರಡು ಪಟ್ಟಿಗಳಿಗೆ ಒಂದೊಂದು ಗದ್ದಿಗೆ ಕಲ್ಲು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ಹಾಗೆಯೇ ಗುಡಾರದ ಉತ್ತರದಿಕ್ಕಿನಲ್ಲಿಯೂ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ಮತ್ತು ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟಿಗೆ ಎರಡೆರಡು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ಗುಡಾರದ ಹಿಂಭಾಗಕ್ಕೆ ಅಂದರೆ ಪಶ್ಚಿಮ ದಿಕ್ಕಿನಲ್ಲಿ ಆರು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ಗುಡಾರದ ಹಿಂಭಾಗದ ಎರಡು ಮೂಲೆಗಳಿಗೆ ಬೇರೆ ಎರಡು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ಅವುಗಳನ್ನು ಅಡಿಯಿಂದ ತುದಿಯವರೆಗೂ ಜೋಡಿಸಿರಬೇಕು. ಮೇಲ್ಭಾಗದಲ್ಲಿಯೂ ಒಂದೇ ಬಳೆಗೆ ಜೋಡಿಸಿರಬೇಕು. ಹಾಗೆ ಎರಡು ಮೂಲೆಗಳಿಗೂ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ಹೀಗೆ ಹಿಂಭಾಗದಲ್ಲಿ ಎಂಟು ಚೌಕಟ್ಟುಗಳೂ ಮತ್ತು ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟಿಗೆ ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳೂ ಅಂತೂ ಹದಿನಾರು ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","ಜಾಲೀಮರದಿಂದ ಅಗುಳಿಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಗುಡಾರದ ಎರಡು ಕಡೆಯ ಚೌಕಟ್ಟುಗಳಿಗೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ಅದರ ಹಿಂದುಗಡೆಯ ಅಂದರೆ ಪಶ್ಚಿಮ ಕಡೆಯ ಚೌಕಟ್ಟುಗಳಿಗೂ ಐದೈದು ಅಗುಳಿಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ಚೌಕಟ್ಟುಗಳ ಮಧ್ಯದಲ್ಲಿರುವ ಅಗುಳಿಯು ಒಂದು ಕೊನೆಯಿಂದ ಮತ್ತೊಂದು ಕೊನೆಯವರೆಗೂ ತಲುಪುವಂತಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ಆ ಚೌಕಟ್ಟುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿ ಅವುಗಳಲ್ಲಿ ಆ ಅಗುಳಿಗಳಿಗಾಗಿ ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಆ ಅಗುಳಿಗಳನ್ನೂ ಚಿನ್ನದ ತಗಡುಗಳಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ನಾನು ಬೆಟ್ಟದಲ್ಲಿ ನಿನಗೆ ತೋರಿಸಿಕೊಟ್ಟ ರೀತಿಯಲ್ಲೇ ಗುಡಾರವನ್ನು ಬಿಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","ನೀಲಿ, ನೆರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳು ಹಾಗೂ ನಯವಾಗಿ ಹೊಸೆದ ಹತ್ತಿಯ ನೂಲಿನಿಂದ ಪರದೆಯನ್ನು ಮಾಡಿಸಿ, ಅದಕ್ಕೆ ಕೆರೂಬಿಗಳಿಗಾಗಿ ಕೌಶಲ್ಯಪೂರ್ಣವಾಗಿ ಕಸೂತಿ ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ಜಾಲೀಮರದಿಂದ ನಾಲ್ಕು ಕಂಬಗಳನ್ನು ಮಾಡಿಸಿ, ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿ, ನಾಲ್ಕು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳನ್ನು ಮೇಲೆ ನಿಲ್ಲಿಸಿ ಚಿನ್ನದ ಕೊಂಡಿಗಳಿಂದ ಆ ಪರದೆಯನ್ನು ಆ ನಾಲ್ಕು ಕಂಬಗಳಿಗೆ ಸಿಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ಆ ಪರದೆಯನ್ನು ಕೊಂಡಿಗಳಿಗೆ ಸಿಕ್ಕಿಸಿದಾಗ ಅದರೊಳಗೆ ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷವನ್ನು ತರಿಸಿಡಬೇಕು. ಆ ಪರದೆಯು ಪವಿತ್ರಸ್ಥಾನವೆಂಬುದನ್ನೂ ಮತ್ತು ಮಹಾಪವಿತ್ರಸ್ಥಾನವನ್ನೂ ವಿಂಗಡಿಸುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ಮಹಾಪವಿತ್ರಸ್ಥಾನದಲ್ಲಿ ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷದ ಮೇಲೆ ಕೃಪಾಸನವನ್ನು ತಂದಿರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ಪರದೆಯ ಹೊರಗಡೆಯಲ್ಲಿ ಮೇಜನ್ನೂ ಮೇಜಿಗೆ ಎದುರಾಗಿ ಗುಡಾರದ ದಕ್ಷಿಣ ದಿಕ್ಕಿನಲ್ಲಿ ದೀಪಸ್ತಂಭವನ್ನೂ ಇರಿಸಬೇಕು. ಮೇಜು ಉತ್ತರ ಭಾಗದಲ್ಲಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಮರೆಯಾಗಿ ನಯವಾಗಿ ಹೊಸೆದ ನಾರಿನ ಪರದೆಯಲ್ಲಿ ನೀಲಿ, ನೆರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳಿಂದ ಕಸೂತಿ ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ಆ ಪರದೆ ತೂಗಿಸುವುದಕ್ಕಾಗಿ ಜಾಲೀಮರದಿಂದ ಐದು ಕಂಬಗಳನ್ನು ಮಾಡಿಸಿ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಬೇಕು. ಅವುಗಳ ಕೊಂಡಿಗಳನ್ನು ಚಿನ್ನದಿಂದ ಮಾಡಿಸಿ ಅವುಗಳಿಗಾಗಿ ಐದು ತಾಮ್ರದ ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ಯಜ್ಞವೇದಿಯನ್ನು ಜಾಲೀಮರದಿಂದ ಐದು ಮೊಳ ಉದ್ದವಾಗಿಯೂ, ಐದು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಚಚ್ಚೌಕವಾಗಿ ಮಾಡಿಸಬೇಕು. ಅದರ ಎತ್ತರವು ಮೂರು ಮೊಳವಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ನಾಲ್ಕು ಕೊಂಬುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಆ ಕೊಂಬುಗಳು ಯಜ್ಞವೇದಿಯಿಂದಲೇ ಬಂದವುಗಳಾಗಿರಬೇಕು. ಆ ಯಜ್ಞವೇದಿಗೆ ತಾಮ್ರದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ಅದರಲ್ಲಿರುವ ಬೂದಿಯನ್ನು ತೆಗೆಯುವುದಕ್ಕಾಗಿ ತಟ್ಟೆಗಳನ್ನೂ, ಸಲಿಕೆಗಳನ್ನೂ, ಬೋಗುಣಿಗಳನ್ನೂ, ಮುಳ್ಳುಚಮಚಗಳನ್ನೂ, ಹಾಗೂ ಅಗ್ಗಿಷ್ಟಿಕೆಗಳನ್ನೂ ಮಾಡಿಸಬೇಕು. ಆ ಉಪಕರಣಗಳೆಲ್ಲಾ ತಾಮ್ರದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ಯಜ್ಞವೇದಿಗೆ ಹೆಣಿಗೆ ಕೆಲಸದಿಂದ ತಾಮ್ರದ ಜಾಲರಿಯನ್ನು ಮಾಡಿಸಬೇಕು, ಆ ಜಾಲರಿಯ ನಾಲ್ಕು ಮೂಲೆಗಳಿಗೆ ತಾಮ್ರದ ಬಳೆಗಳನ್ನು ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ಆ ಜಾಲರಿಯು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲಿರುವ ಕಟ್ಟೆಯ ಕೆಳಗಿನವರೆಗೆ ಇದ್ದು ಯಜ್ಞವೇದಿಯ ಅಡಿಯಿಂದ ನಡುವಿನ ತನಕ ಇರುವಂತೆ ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ಯಜ್ಞವೇದಿಯನ್ನು ಹೊರುವ ಕೋಲುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸಿ, ತಾಮ್ರದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ಆ ಕೋಲುಗಳನ್ನು ಆ ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಿದಾಗ ಅವು ಯಜ್ಞವೇದಿಯನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಅದರ ಎರಡೂ ಕಡೆಗಳಲ್ಲಿ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ಆ ಯಜ್ಞವೇದಿಯನ್ನು ಹಲಗೆಗಳಿಂದ ಟೊಳ್ಳಾದ ಪೆಟ್ಟಿಗೆಯಂತೆ ಮಾಡಿಸಬೇಕು. ನಾನು ಬೆಟ್ಟದಲ್ಲಿ ನಿನಗೆ ತೋರಿಸಿದಂತೆ ಅದನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","ಪರಿಶುದ್ಧ ಗುಡಾರಕ್ಕೆ ಅಂಗಳವನ್ನು ಮಾಡಿಸಬೇಕು. ಆ ದಕ್ಷಿಣ ಭಾಗದ ಅಂಗಳಕ್ಕೆ ಪರದೆಗಳು ಇರಬೇಕು. ಆ ಪರದೆಗಳನ್ನು ನಯವಾಗಿ ಹೊಸೆದ ಹತ್ತಿಯ ನೂಲಿನಿಂದ ಬಟ್ಟೆಯಿಂದ ಮಾಡಿಸಬೇಕು. ಅವು ನೂರು ಮೊಳ ಉದ್ದವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ಆ ಕಡೆಯಲ್ಲಿ ಇಪ್ಪತ್ತು ಕಂಬಗಳು. ಅವುಗಳಿಗೆ ಇಪ್ಪತ್ತು ತಾಮ್ರದ ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳು ಇರಬೇಕು. ಕಂಬಗಳಿಗೆ ಬೆಳ್ಳಿಯ ಕೊಂಡಿಗಳೂ ಪಟ್ಟಿಗಳೂ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ಅದೇ ರೀತಿಯಲ್ಲಿ ಉತ್ತರ ಕಡೆಯಲ್ಲಿಯೂ ನೂರು ಮೊಳ ಉದ್ದವಾದ ಪರದೆಗಳೂ, ಇಪ್ಪತ್ತು ಕಂಬಗಳು, ಇಪ್ಪತ್ತು ತಾಮ್ರದ ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳು ಇರಬೇಕು ಕಂಬಗಳ ಕೊಂಡಿಗಳೂ, ಪಟ್ಟಿಗಳೂ ಬೆಳ್ಳಿಯವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ಪಶ್ಚಿಮ ಕಡೆಯಲ್ಲಿ ಅಂಗಳದ ಅಗಲಕ್ಕೆ ಐವತ್ತು ಮೊಳ ಉದ್ದವಾದ ಪರದೆಗಳೂ ಹತ್ತು ಕಂಬಗಳೂ, ಹತ್ತು ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳೂ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ಪೂರ್ವದ ದಿಕ್ಕಿನಲ್ಲಿಯೂ ಅಂಗಳದ ಅಗಲವು ಐವತ್ತು ಮೊಳವಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ಒಂದು ಕಡೆಯಲ್ಲಿ ಹದಿನೈದು ಮೊಳ ಉದ್ದವಾದ ಪರದೆಗಳಿದ್ದು ಅವುಗಳಿಗೆ ಮೂರು ಸ್ತಂಭಗಳೂ, ಮೂರು ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ಮತ್ತೊಂದು ಕಡೆಯಲ್ಲಿ ಹದಿನೈದು ಮೊಳ ಉದ್ದವಾದ ಪರದೆಗಳಿದ್ದು ಅವುಗಳಿಗೆ ಮೂರು ಸ್ತಂಭಗಳೂ, ಮೂರು ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳು ಇರಬೇಕು ");
INSERT INTO kanirv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ಅಂಗಳದ ಬಾಗಿಲಲ್ಲೇ ಇಪ್ಪತ್ತು ಮೊಳದ ಪರದೆಯೂ ಇರಬೇಕು. ಅದನ್ನು ನಯವಾಗಿ ಹೊಸೆದ ನಾರಿನ ನೂಲು, ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರದಿಂದ ಕಸೂತಿ ಕೆಲಸದವರ ಕೈಯಿಂದ ಮಾಡಿಸಬೇಕು. ಬಾಗಿಲಿಗೆ ನಾಲ್ಕು ಕಂಬಗಳೂ ನಾಲ್ಕು ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ಅಂಗಳದ ಸುತ್ತಲಿರುವ ಎಲ್ಲಾ ಕಂಬಗಳಿಗೂ, ಬೆಳ್ಳಿಯ ಪಟ್ಟಿಗಳೂ, ಬೆಳ್ಳಿಯ ಕೊಂಡಿಗಳೂ, ತಾಮ್ರದ ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ಅಂಗಳವು ನೂರು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ಸುತ್ತಲೂ ಐವತ್ತು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇರಬೇಕು. ಅದರ ಸುತ್ತಲಿರುವ ಪರದೆಯು ನಯವಾಗಿ ಹೊಸೆದ ಹತ್ತಿಯ ನೂಲಿನಿಂದ ಬಟ್ಟೆಯಿಂದ ಮಾಡಿದ್ದು ಅದಕ್ಕೆ ಐದು ಮೊಳ ಎತ್ತರವಿರಬೇಕು. ಅದಕ್ಕೆ ತಾಮ್ರದ ಗದ್ದಿಗೆ ಕಲ್ಲುಗಳಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ಗುಡಾರದ ಸಕಲವಿಧವಾದ ಕೆಲಸಕ್ಕೆ ಬೇಕಾದ ಉಪಕರಣಗಳೂ, ಗುಡಾರದ ಗೂಟಗಳೂ, ಅಂಗಳದ ಗೂಟಗಳೂ ತಾಮ್ರದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","ದೀಪವು ಯಾವಾಗಲೂ ಉರಿಯುವಂತೆ ಇಸ್ರಾಯೇಲ್ಯರು ಒಲಿವ್ ಮರದ ಕಾಯಿಗಳನ್ನು ಕುಟ್ಟಿ ನಿರ್ಮಲವಾದ ಒಲಿವ್ ಎಣ್ಣೆಯನ್ನು ತೆಗೆದುಕೊಂಡು ಬರುವಂತೆ ಅವರಿಗೆ ಅಪ್ಪಣೆಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ದೇವದರ್ಶನ ಗುಡಾರದಲ್ಲಿ ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷದ ಮುಂದಿರುವ ಪರದೆಯ ಹೊರಗೆ ಆರೋನನೂ, ಅವನ ಮಕ್ಕಳೂ ಅದನ್ನು ಸಾಯಂಕಾಲದಿಂದ ಉದಯದವರೆಗೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಆ ದೀಪವು ಉರಿಯುತ್ತಿರುವಂತೆ ಸರಿಪಡಿಸುತ್ತಿರಬೇಕು. ಇಸ್ರಾಯೇಲ್ಯರು ಅವರ ಸಂತತಿಯವರು ಈ ನಿಯಮವನ್ನು ತಲತಲಾಂತರದವರೆಗೆ ಶಾಶ್ವತವಾಗಿ ಅನುಸರಿಸಬೇಕು. ಅದು ಅವರಿಗೆ ನಿತ್ಯ ನಿಯಮವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ನನಗೆ ಯಾಜಕನ ಸೇವೆ ಮಾಡುವುದಕ್ಕೆ ನೀನು ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನನ್ನೂ, ಅವನ ಮಕ್ಕಳಾದ ನಾದಾಬ್, ಅಬೀಹೂ, ಎಲ್ಲಾಜಾರ್, ಈತಾಮಾರ್ ಎಂಬುವರನ್ನೂ ಇಸ್ರಾಯೇಲ್ಯರಿಂದ ನಿನ್ನ ಹತ್ತಿರಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಾ. ");
INSERT INTO kanirv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನಿಗೆ ಗೌರವವೂ, ಅಲಂಕಾರವೂ ಉಂಟಾಗುವಂತೆ ಅವನಿಗೆ ದೀಕ್ಷಾವಸ್ತ್ರಗಳನ್ನು (ಪರಿಶುದ್ಧವಸ್ತುಗಳು) ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ಯಾರಿಗೆ ನಾನು ಜ್ಞಾನದ ವರವನ್ನು ಪರಿಪೂರ್ಣವಾಗಿ ಅನುಗ್ರಹಿಸಿದ್ದೇನೋ ಅಂಥ ಜ್ಞಾನಿಗಳೆಲ್ಲರ ಸಂಗಡ ನೀನು ಮಾತನಾಡಿ ಅವರ ಕೈಯಿಂದ ಆ ವಸ್ತ್ರಗಳನ್ನು ಸಿದ್ಧಪಡಿಸಬೇಕು. ಆರೋನನು ಅವುಗಳನ್ನು ಧರಿಸಿಕೊಂಡು ನನ್ನ ಯಾಜಕನಾಗುವುದಕ್ಕೆ ಪ್ರತಿಷ್ಠಿತನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ಅವರು ಮಾಡಬೇಕಾದ ವಸ್ತ್ರಗಳು ಯಾವುವೆಂದರೆ; ಎದೆಯ ಪದಕದ ಚೀಲ, ಏಫೋದ್, ನಿಲುವಂಗಿ, ಕಸೂತಿ ಕೆಲಸದ ಮೇಲಂಗಿ, ಮುಂಡಾಸ ಹಾಗೂ ನಡುಕಟ್ಟು ಇವುಗಳೇ. ನಿನ್ನ ಸಹೋದರನಾದ ಆರೋನನೂ ಅವನ ಮಕ್ಕಳೂ ನನ್ನ ಯಾಜಕರಾಗುವುದಕ್ಕೆ ಅವರಿಗೋಸ್ಕರ ಈ ದೀಕ್ಷಾವಸ್ತ್ರಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ಜನರು ಕಾಣಿಕೆಯಾಗಿ ಕೊಡುವ ಚಿನ್ನವನ್ನು, ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರವನ್ನು, ಹಾಗೂ ನಾರಿನ ಬಟ್ಟೆಯನ್ನು ಆ ಕೆಲಸಕ್ಕಾಗಿ ಉಪಯೋಗಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","ಏಫೋದೆಂಬ ಕವಚವನ್ನು ನಯವಾಗಿ ಹೊಸೆದ ಹತ್ತಿಯ ದಾರದಿಂದ ಮಾಡಿಸಿ ಅದನ್ನು ಚಿನ್ನ, ನೀಲಿ, ನೇರಳೆ ಹಾಗೂ ಕಡುಗೆಂಪು ದಾರಗಳಿಂದಲೂ ಕಸೂತಿ ಹಾಕಿಸಿ ಅಲಂಕರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ಆ ಕವಚಕ್ಕೆ ಹೆಗಲಿನ ಮೇಲೆ ಎರಡು ಪಟ್ಟಿಗಳು ಇರಬೇಕು. ಅದರ ಎರಡು ತುದಿಗಳು ಜೋಡಿಸಲ್ಪಟ್ಟಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ಕವಚದ ಮೇಲಿರುವ ಕಸೂತಿ ಕೆಲಸದ ನಡುಕಟ್ಟು ಏಕವಾಗಿದ್ದು ಅದರಂತೆಯೇ ನಯವಾಗಿ ಹೊಸೆದ ಹತ್ತಿಯ ದಾರದಿಂದ ಮಾಡಲ್ಪಟ್ಟು ಚಿನ್ನದ ದಾರದಿಂದಲೂ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರದಿಂದಲೂ ಅಲಂಕೃತವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ಮತ್ತು ನೀನು ಎರಡು ಗೋಮೇಧಕ ಅಮೂಲ್ಯರತ್ನಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಕುಲಗಳ ಹೆಸರುಗಳನ್ನು ಕೆತ್ತಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ಒಂದು ರತ್ನದಲ್ಲಿ ಆರು ಹೆಸರುಗಳನ್ನೂ ಮತ್ತೊಂದು ರತ್ನದಲ್ಲಿ ಮಿಕ್ಕ ಆರು ಹೆಸರುಗಳನ್ನು ಅವರವರ ಜನನ ಕ್ರಮದ ಪ್ರಕಾರ ಕೆತ್ತಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ಮುದ್ರೆಗಳನ್ನು ಕೆತ್ತುವ ಹಾಗೆ ಆ ಶಿಲ್ಪಿಗರಿಂದ ಎರಡೂ ರತ್ನಗಳಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಕುಲಗಳ ಹೆಸರುಗಳನ್ನು ಕೆತ್ತಿಸಿ, ಅದಕ್ಕೆ ಚಿನ್ನವನ್ನು ಆ ಮುದ್ರೆಗಳ ಮೇಲೆ ಇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ಆ ಎರಡು ರತ್ನಗಳನ್ನು ಹೆಗಲಿನ ಮೇಲಿರುವ ಏಫೋದಿನ ಪಟ್ಟಿಗಳಲ್ಲಿ ಹಾಕಿಸಬೇಕು. ಅವು ಇಸ್ರಾಯೇಲರ ಜ್ಞಾಪಕಾರ್ಥವಾದ ರತ್ನಗಳಾಗಿರುವವು. ಆರೋನನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಹೋಗುವಾಗೆಲ್ಲಾ ಇಸ್ರಾಯೇಲರ ಕುಲಗಳ ಹೆಸರುಗಳನ್ನು ಆತನ ನೆನಪಿಗೆ ತರುವುದಕ್ಕಾಗಿ ತನ್ನ ಎರಡೂ ಭುಜಗಳ ಮೇಲೆ ಅವುಗಳನ್ನು ಧರಿಸಿಕೊಂಡು ಹೋಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ಆ ರತ್ನಗಳನ್ನು ಜೋಡಿಸುವುದಕ್ಕೆ ಚಿನ್ನದ ಸರಿಗೆಯನ್ನು ಹೆಣೆದು ಗೂಡುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ಮತ್ತು ಹೆಣಿಗೆ ಕೆಲಸದಿಂದ ಹುರಿಗಳಂತಿರುವ ಎರಡು ಚೊಕ್ಕ ಬಂಗಾರದ ಸರಪಣಿಗಳನ್ನು ಮಾಡಿಸಿ ರತ್ನಗಳ ಗೂಡುಗಳಿಗೆ ಸಿಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","ನ್ಯಾಯತೀರ್ಪಿನ ಎದೆಯ ಪದಕದ ಕವಚವನ್ನು ಕಸೂತಿ ಕೆಲಸದಿಂದ ಮಾಡಿಸಬೇಕು. ಅದನ್ನು ಏಫೋದ್ ಅನ್ನು ಮಾಡಿಸಿದ ಹಾಗೆಯೇ ಚಿನ್ನದ ದಾರದಿಂದಲೂ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರದಿಂದಲೂ ನಯವಾಗಿ ಹೊಸೆದ ಹತ್ತಿಯ ದಾರದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ಅದು ಒಂದು ಗೇಣುದ್ದವಾಗಿಯೂ ಮತ್ತು ಒಂದು ಗೇಣಗಲವಾಗಿಯೂ ಎರಡು ಪದರುಳ್ಳದ್ದಾಗಿ ಚಚ್ಚೌಕವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ಅದರ ಮುಂಭಾಗದಲ್ಲಿ ನಾಲ್ಕು ಸಾಲುಗಳಾಗಿ ರತ್ನಗಳನ್ನು ಹೆಚ್ಚಿಸಿರಬೇಕು. ಮೊದಲನೆಯ ಸಾಲಿನಲ್ಲಿ ಮಾಣಿಕ್ಯ, ಪುಷ್ಯರಾಗ ಮತ್ತು ಸ್ಫಟಿಕಗಳು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ಎರಡನೆಯ ಸಾಲಿನಲ್ಲಿ ಪಚ್ಚೆ, ನೀಲರತ್ನ ಮತ್ತು ವಜ್ರಗಳಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ಮೂರನೆಯ ಸಾಲಿನಲ್ಲಿ ಸುವರ್ಣರತ್ನ, ಸುಗಂಧಿ ಮತ್ತು ಪದ್ಮರಾಗಗಳು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ನಾಲ್ಕನೆಯ ಸಾಲಿನಲ್ಲಿ ಪೀತರತ್ನ, ಬೆರುಲ್ಲ, ವೈಡೂರ್ಯಗಳನ್ನೂ ಚಿನ್ನದ ಮಣಿಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ಇಸ್ರಾಯೇಲರ ಕುಲಗಳ ಸಂಖ್ಯೆಗೆ ಅನುಗುಣವಾಗಿ ಹನ್ನೆರಡು ರತ್ನಗಳಿರಬೇಕು. ಮುದ್ರೆಗಳನ್ನು ಕೆತ್ತುವ ರೀತಿಯಲ್ಲಿ ಒಂದೊಂದು ರತ್ನದಲ್ಲಿ ಒಂದೊಂದು ಕುಲದ ಹೆಸರನ್ನು ಕೆತ್ತಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ಅದಲ್ಲದೆ ಆ ಪದಕದ ಮೇಲ್ಗಡೆಯಲ್ಲಿ ಹುರಿಗಳಂತಿರುವ ಚೊಕ್ಕ ಬಂಗಾರದ ಸರಪಣಿಗಳನ್ನು ಹೆಣಿಗೆ ಕೆಲಸಗಳಿಂದ ಮಾಡಿಸಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ಎರಡು ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿಸಿ ಎದೆಯ ಪದಕದ ಕವಚದ ಎರಡು ಮೂಲೆಗಳಿಗೆ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ಆ ಎರಡು ಸರಪಣಿಗಳನ್ನು ಎದೆಯ ಪದಕದ ಕವಚದ ಮೂಲೆಗಳಲ್ಲಿರುವ ಕೊಂಡಿಗಳಿಗೆ ಸಿಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ಆ ಸರಪಣಿಗಳ ಕೊನೆಗಳನ್ನು ಏಫೋದ್ ಕವಚದ ಹೆಗಲಿನ ಪಟ್ಟಿಗಳಲ್ಲಿರುವ ಎರಡು ಕೊಂಡಿಗಳಲ್ಲಿ ಸಿಕ್ಕಿಸಿ ಮುಂಭಾಗದಲ್ಲಿರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ಅದಲ್ಲದೆ ಎರಡು ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿಸಿ ಎದೆ ಪದಕದ ಒಳಗಣ ಅಂಚಿನ ಮೂಲೆಗಳಲ್ಲಿ ಕವಚದ ಹತ್ತಿರದಲ್ಲೆ ಇಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ಮತ್ತು ಬೇರೆ ಎರಡು ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿಸಿ ಏಫೋದ್ ಕವಚದ ಎರಡು ಹೆಗಲಿನ ಪಟ್ಟಿಗಳ ಮುಂಭಾಗದ ಕೆಳಗೆ ಕವಚವನ್ನು ಜೋಡಿಸಿರುವ ಸ್ಥಳದ ಹತ್ತಿರ ಕಸೂತಿ ಹಾಕಿಸಿದ ನಡುಕಟ್ಟಿನ ಮೇಲ್ಗಡೆಯಲ್ಲಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ಎದೆಯ ಪದಕವು ಕಸೂತಿಹಾಕಿದ ನಡುಕಟ್ಟಿನ ಮೇಲ್ಗಡೆಯಲ್ಲಿ ಬಿಗಿಯಾಗಿರುವಂತೆಯೂ, ಏಫೋದ್ ಕವಚದಿಂದ ಕಳಚಿಬೀಳದಂತೆಯೂ ಅದರ ಕೊಂಡಿಗಳನ್ನು ಏಫೋದ್ ಕವಚದ ಕೊಂಡಿಗಳಿಗೆ ನೀಲಿ ದಾರದಿಂದ ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","ನ್ಯಾಯತೀರ್ಪಿನ ಎದೆಯ ಪದಕದ ಮೇಲೆ ಇಸ್ರಾಯೇಲರ ಕುಲಗಳ ಹೆಸರುಗಳು ಬರೆದಿರುವುದರಿಂದ ಆರೋನನು ಪವಿತ್ರಸ್ಥಾನದೊಳಗೆ ಹೋಗುವಾಗೆಲ್ಲಾ ಆ ಹೆಸರುಗಳನ್ನು ಸತತವಾಗಿ ಯೆಹೋವನ ನೆನಪಿಗೆ ತರುವುದಕ್ಕಾಗಿ ಅದನ್ನು ತನ್ನ ಎದೆಯ ಮೇಲೆ ನಿತ್ಯವೂ ಧರಿಸುವನು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ದೈವನಿರ್ಣಯವನ್ನು ತಿಳಿಸುವ ಊರೀಮ್ ತುಮ್ಮೀಮ್‌ ಆ ಎದೆಯ ಪದಕದಲ್ಲಿ ಇಡಬೇಕು. ಆರೋನನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಹೋಗುವಾಗ ಅವು ಅವನ ಎದೆಯ ಮೇಲೆ ಇರುವವು. ಇಸ್ರಾಯೇಲರು ಕೈಕೊಳ್ಳಬೇಕಾದ ದೈವನಿರ್ಣಯವನ್ನು ಆರೋನನು ಹೀಗೆ ತನ್ನ ಹೃದಯದ ಮೇಲೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಯಾವಾಗಲೂ ಧರಿಸಿಕೊಂಡಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ಮಹಾಯಾಜಕನು ಏಫೋದ್ ಕವಚದ ಸಂಗಡ ಧರಿಸಿಕೊಳ್ಳಬೇಕಾದ ಮೇಲಂಗಿಯನ್ನು ನೀನು ನೀಲಿಬಣ್ಣದ ಬಟ್ಟೆಯಿಂದಲೇ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ತಲೆತೂರಿಸುವುದಕ್ಕೆ ಅದರಲ್ಲಿ ಸಂದು ಇರಬೇಕು. ಅದು ಹರಿಯದಂತೆ ಆ ಸಂದಿನ ಸುತ್ತಲೂ ನೇಯಿಗೆ ಕಸೂತಿಯನ್ನು ಅದರೊಂದಿಗೆ ಒಂದು ಪಟ್ಟಿಯನ್ನು ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ನಿಲುವಂಗಿಯ ಅಂಚಿನ ಸುತ್ತಲೂ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರದಿಂದ ದಾಳಿಂಬ ಹಣ್ಣುಗಳನ್ನು ಅವುಗಳ ನಡುವೆ ಚಿನ್ನದ ಗೆಜ್ಜೆಗಳನ್ನು ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ಚಿನ್ನದ ಗೆಜ್ಜೆಯೂ ದಾಳಿಂಬೆಯೂ ಒಂದಾದ ಮೇಲೆ ಒಂದು ಆ ನಿಲುವಂಗಿಯ ಅಂಚಿನ ಸುತ್ತಲೂ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ಆರೋನನು ಯಾಜಕ ಸೇವೆ ಮಾಡುವ ಸಮಯದಲ್ಲಿ ಅದನ್ನು ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ಅವನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಪವಿತ್ರಸ್ಥಾನದೊಳಗೆ ಹೋಗುವಾಗಲೂ ಬರುವಾಗಲೂ ಸಾಯದಂತಿರಲು ಆ ಗೆಜ್ಜೆಗಳ ಶಬ್ದವು ಕೇಳಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ಚೊಕ್ಕ ಬಂಗಾರದಿಂದ ಒಂದು ಪಟ್ಟಿಯನ್ನು ಮಾಡಿಸಿ ಮುದ್ರೆಯನ್ನು ಕೆತ್ತಿಸುವ ರೀತಿಯಲ್ಲಿ ಅದರ ಮೇಲೆ “ಯೆಹೋವನಿಗೆ ಮೀಸಲು” ಎಂಬ ಲಿಪಿಯನ್ನು ಕೆತ್ತಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ಅದನ್ನು ಮುಂಡಾಸಕ್ಕೆ ಬಿಗಿಯುವುದಕ್ಕಾಗಿ ನೀಲಿ ದಾರವನ್ನು ಅದಕ್ಕೆ ಕಟ್ಟಿಸಬೇಕು. ಅದು ಮುಂಡಾಸದ ಮುಂಭಾಗದಲ್ಲಿ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ಇಸ್ರಾಯೇಲ್ಯರು ಕಾಣಿಕೆಯಾಗಿ ಸಮರ್ಪಿಸುವ ದೇವರ ಎಲ್ಲಾ ಪವಿತ್ರವಸ್ತುಗಳ ವಿಷಯದಲ್ಲಿ ದೋಷವೇನಾದರೂ ಇದ್ದರೆ ಆರೋನನು ಆ ಪಟ್ಟವನ್ನು ಯಾವಾಗಲೂ ಹಣೆಯ ಮೇಲೆ ಧರಿಸಿ ಆ ದೋಷ ಫಲವನ್ನು ವಹಿಸಿಕೊಳ್ಳುವುದರಿಂದ ಅವರು ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚಿಕೆಯುಳ್ಳವರಾಗಿರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ಆರೋನನು ಧರಿಸಬೇಕಾದ ಒಳ ಅಂಗಿಯನ್ನು ಹತ್ತಿಯ ನೂಲಿನಿಂದ ಕಸೂತಿ ಹಾಕಿಸಿ ನೇಯಿಸಬೇಕು. ಅವನ ಮುಂಡಾಸವನ್ನು ಹತ್ತಿಯ ನೂಲಿನಿಂದ ಮಾಡಿಸಬೇಕು. ಅವನ ನಡುಕಟ್ಟನ್ನು ಕಸೂತಿ ಕೆಲಸದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ಆರೋನನ ಮಕ್ಕಳಿಗೆ ತಕ್ಕ ಗೌರವಕ್ಕಾಗಿಯೂ, ಅಲಂಕಾರಕ್ಕಾಗಿಯೂ ಅವರಿಗೆ ಮೇಲಂಗಿಗಳನ್ನು, ನಡುಕಟ್ಟುಗಳನ್ನು ಮತ್ತು ಮುಂಡಾಸಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ಅವರು ನನಗೆ ಯಾಜಕಸೇವೆ ಮಾಡುವುದಕ್ಕಾಗಿ ಆ ವಸ್ತ್ರಗಳನ್ನು ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನಿಗೂ, ಅವನ ಮಕ್ಕಳಿಗೂ ತೊಡಿಸಿ, ಅವರನ್ನು ಅಭಿಷೇಕಿಸಿ, ಸೇವೆಗಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿ ಶುದ್ಧೀಕರಿಸಿಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ಅದಲ್ಲದೆ ಅವರ ನಗ್ನತೆಯನ್ನು ಮರೆಮಾಡುವುದಕ್ಕಾಗಿ ಅವರಿಗೆ ಸೊಂಟದಿಂದ ತೊಡೆಯ ತನಕ ಇರುವ ನಾರಿನ ಚಡ್ಡಿಗಳನ್ನು ಸಣಬಿನ ದಾರದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ಆರೋನನೂ, ಅವನ ಮಕ್ಕಳೂ ದೇವದರ್ಶನ ಗುಡಾರದೊಳಗೆ ಹೋಗುವಾಗಲೂ, ಪವಿತ್ರಸ್ಥಾನದಲ್ಲಿ ಸೇವೆಮಾಡುವುದಕ್ಕೆ ಯಜ್ಞವೇದಿಯ ಹತ್ತಿರಕ್ಕೆ ಬರುವಾಗಲೂ ಇವುಗಳನ್ನು ಧರಿಸಿಕೊಂಡಿರಬೇಕು. ಇಲ್ಲವಾದರೆ ಅವರು ಆ ಅಪರಾಧದ ಫಲವನ್ನು ಅನುಭವಿಸಿ ಸತ್ತಾರು. ಅವನಿಗೂ ಅವನ ವಂಶಸ್ಥರಿಗೂ ಇದು ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ಅವರು ನನಗೆ ಯಾಜಕರಾಗುವಂತೆ ಅವರನ್ನು ಪ್ರತಿಷ್ಠಿಸುವುದಕ್ಕೆ ನೀನು ಮಾಡಬೇಕಾಗಿರುವ ಕಾರ್ಯಗಳೆನೆಂದರೆ; ಒಂದು ಹೋರಿ ಮತ್ತು ಕರುವನ್ನು ಯಾವ ದೋಷವಿಲ್ಲದ ಎರಡು ಟಗರುಗಳನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ಮತ್ತು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು, ಎಣ್ಣೆ ಮಿಶ್ರಿತವಾದ ಹುಳಿಯಿಲ್ಲದ ಹೋಳಿಗೆಗಳನ್ನು, ಎಣ್ಣೆ ಸವರಿದ ಹುಳಿಯಿಲ್ಲದ ಕಡಬುಗಳನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ಗೋದಿಯ ಹಿಟ್ಟಿನಿಂದ ಮಾಡಿಸಿ ಒಂದೇ ಪುಟ್ಟಿಯಲ್ಲಿ ತುಂಬಿಸಬೇಕು. ಆ ನಂತರ ಆ ಪುಟ್ಟಿಯನ್ನು, ಹೋರಿಯನ್ನು ಮತ್ತು ಎರಡು ಟಗರುಗಳೊಂದಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ಆಗ ಆರೋನನನ್ನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳನ್ನೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ಆ ವಸ್ತ್ರಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಒಳ ಅಂಗಿಯನ್ನು ಏಫೋದ್ ಕವಚದ ಸಂಗಡ ತೊಟ್ಟುಕೊಳ್ಳತಕ್ಕ ನಿಲುವಂಗಿಯನ್ನೂ, ಏಫೋದ್ ಕವಚವನ್ನು ಎದೆಯ ಪದಕವನ್ನೂ ಆರೋನನಿಗೆ ತೊಡಿಸಿ ಏಫೋದ್ ಕವಚದ ಕಸೂತಿ ಹಾಕಿದ ನಡುಕಟ್ಟನ್ನು ಕಟ್ಟಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ಅವನ ತಲೆಗೆ ಮುಂಡಾಸವನ್ನು ಹಾಕಿಸಿ, ಮುಂಡಾಸದ ಮೇಲೆ ಪವಿತ್ರ ಪಟ್ಟವನ್ನು ಕಟ್ಟಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ಅಭಿಷೇಕತೈಲವನ್ನು ಅವನ ಮೇಲೆ ಸುರಿದು ಅವನನ್ನು ಅಭಿಷೇಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ತರುವಾಯ ಅವನ ಮಕ್ಕಳನ್ನು ಹತ್ತಿರಕ್ಕೆ ಕರೆದು, ಅವರಿಗೆ ಮೇಲಂಗಿಗಳನ್ನು ತೊಡಿಸಿ ");
INSERT INTO kanirv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ಆರೋನನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ ನಡುಕಟ್ಟುಗಳನ್ನು ಕಟ್ಟಿಸಿ ಮುಂಡಾಸಗಳನ್ನು ಇಡಬೇಕು. ಅಂದಿನಿಂದ ಯಾಜಕತ್ವವು ಅವರಿಗೆ ಶಾಶ್ವತವಾದ ಹಕ್ಕಾಗಿರುವುದು. ಹೀಗೆ ಆರೋನನೂ ಅವನ ಮಕ್ಕಳೂ ಯಾಜಕ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿತರಾಗಿರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","ತರುವಾಯ ನೀನು ಆ ಹೋರಿಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಎದುರಿಗೆ ತಂದು, ಆರೋನನೂ ಅವನ ಮಕ್ಕಳೂ ಅದರ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ಆ ನಂತರ ನೀನು ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲೇ ವಧಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ಆ ಹೋರಿಯ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಬೆರಳಿನಿಂದ ಯಜ್ಞವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ ಮಿಕ್ಕ ರಕ್ತವನ್ನೆಲ್ಲಾ ಯಜ್ಞವೇದಿಯ ಬುಡಕ್ಕೆ ಹೊಯ್ಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ಅದರ ಪಿತ್ತಕೋಶದ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರಕೋಶಗಳನ್ನೂ ಅವುಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ಹೋರಿಯ ಮಾಂಸವನ್ನು, ಚರ್ಮವನ್ನು ಮತ್ತು ಕಲ್ಮಷವನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ಏಕೆಂದರೆ ಇದು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞ. ");
INSERT INTO kanirv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ತರುವಾಯ ನೀನು ಆ ಟಗರುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಕೊಂಡು ಆರೋನನೂ ಅವನ ಮಕ್ಕಳೂ ಅದರ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ನೀನು ಅದನ್ನು ವಧಿಸಿ ಅದರ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ನಾಲ್ಕು ಕಡೆಗಳಿಗೆ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ಆ ನಂತರ ನೀನು ಆ ಟಗರನ್ನು ತುಂಡು ತುಂಡಾಗಿ ಕತ್ತರಿಸಿ ಅದರ ಕರಳುಗಳನ್ನೂ, ಕಾಲುಗಳನ್ನೂ ತೊಳೆದು ಅದರ ತುಂಡುಗಳನ್ನೂ, ತಲೆಯನ್ನೂ ಒಟ್ಟಿಗೆ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ಅದನ್ನೆಲ್ಲಾ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ಇದು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಹೋಮವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","ಆ ಮೇಲೆ ನೀನು ಎರಡನೆಯ ಟಗರನ್ನು ತೆಗೆದುಕೊಂಡು ಆರೋನನೂ ಅವನ ಮಕ್ಕಳೂ ಅದರ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ನಂತರ ಅದನ್ನು ವಧಿಸಿ ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಆರೋನನ ಮತ್ತು ಅವನ ಮಕ್ಕಳ ಬಲಗಿವಿಯ ತುದಿಗೂ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ, ಬಲಗಾಲಿನ ಹೆಬ್ಬೆರಳಿಗೂ ಹಚ್ಚಿ, ಮಿಕ್ಕ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲು ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ಅದಲ್ಲದೆ ನೀನು ಯಜ್ಞವೇದಿಯ ಮೇಲಿರುವ ರಕ್ತದಲ್ಲಿಯೂ, ಅಭಿಷೇಕ ತೈಲದಲ್ಲಿಯೂ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಆರೋನನ ಮತ್ತು ಅವನ ವಸ್ತ್ರಗಳ ಮೇಲೆಯೂ ಅವನ ಮಕ್ಕಳ ಮತ್ತು ಅವರ ವಸ್ತ್ರಗಳ ಮೇಲೆಯೂ ಚಿಮುಕಿಸಬೇಕು. ಹೀಗೆ ಅವನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ಅವರ ವಸ್ತ್ರಗಳ ಸಹಿತವಾಗಿ ಪರಿಶುದ್ಧರಾಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ಪ್ರತಿಷ್ಠೆಗಾಗಿ ಸಮರ್ಪಿಸಲ್ಪಟ್ಟ ಟಗರಾಗಿರುವುದರಿಂದ ಅದರ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಅಂದರೆ ಬಾಲದ ಕೊಬ್ಬನ್ನು, ವಪೆಯನ್ನು, ಪಿತ್ತಕೋಶದ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನು, ಎರಡು ಮೂತ್ರಕೋಶಗಳನ್ನು ಅವುಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನು ಹಾಗೂ ಬಲತೊಡೆಯನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ಮತ್ತು ಯೆಹೋವನಿಗೆದುರಾಗಿ ಪುಟ್ಟಿಯಲ್ಲಿ ಇಟ್ಟಿದ್ದ ಹುಳಿಯಿಲ್ಲದ ಪದಾರ್ಥಗಳಲ್ಲಿ ಒಂದು ರೊಟ್ಟಿಯನ್ನು, ಎಣ್ಣೆ ಮಿಶ್ರವಾದ ಒಂದು ಹೋಳಿಗೆಯನ್ನು ಮತ್ತು ಒಂದು ಕಡುಬನ್ನು ತೆಗೆದುಕೊಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ಅವುಗಳನ್ನೆಲ್ಲಾ ಆರೋನನ ಮತ್ತು ಅವನ ಮಕ್ಕಳ ಕೈಗೆ ಕೊಟ್ಟು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ಆಮೇಲೆ ಅವುಗಳನ್ನು ಅವರ ಕೈಯಿಂದ ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಯೆಹೋವನಿಗಾಗಿ ಸುಡಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ಸುಗಂಧ ಹೋಮವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ಮತ್ತು ಆರೋನನ ಪಟ್ಟಾಭೀಷೇಕಕ್ಕಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿದ ಟಗರಿನ ಎದೆಯ ಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು ಅದನ್ನು ನೈವೇದ್ಯವಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿವಾಳಿಸಬೇಕು. ಅದು ನಿನಗೇ ಸಲ್ಲತಕ್ಕ ಪಾಲಾಗಿರುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ಆರೋನನನ್ನೂ ಅವನ ಮಕ್ಕಳನ್ನೂ ಪ್ರತಿಷ್ಠೆ ಮಾಡುವಾಗ ಸಮರ್ಪಿಸಿದ ಟಗರಿನ ಮಾಂಸದಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿದ ಎದೆಯ ಭಾಗವನ್ನೂ ಯಾಜಕರ ಭಾಗಕ್ಕೆ ಪ್ರತ್ಯೇಕಿಸಿದ ತೊಡೆಯನ್ನೂ ದೇವರದೆಂದು ಭಾವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ಶಾಶ್ವತ ನಿಯಮವಾಗಿ ಇಸ್ರಾಯೇಲರು ಅವುಗಳನ್ನು ಆರೋನನಿಗೂ ಅವನ ವಂಶಸ್ಥರಿಗೂ ಕೊಡತಕ್ಕದ್ದು. ಅವು ಯಾಜಕರ ಭಾಗಕ್ಕಾಗಿ ಪ್ರತ್ಯೇಕಿಸಲ್ಪಟ್ಟಿವೆ. ಇಸ್ರಾಯೇಲರು ಸಮಾಧಾನ ಯಜ್ಞಕ್ಕಾಗಿ ಪಶುಗಳನ್ನು ವಧಿಸಿ ಯೆಹೋವನಿಗೆ ನೈವೇದ್ಯ ಮಾಡುವಾಗೆಲ್ಲಾ ಆ ಭಾಗಗಳನ್ನು ಯಾಜಕರಿಗಾಗಿ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","ಆರೋನನ ಪವಿತ್ರವಾದ ಯಾಜಕದೀಕ್ಷಾವಸ್ತ್ರಗಳು ಅವನ ತರುವಾಯ ಅವನ ವಂಶಸ್ಥರಿಗೂ ಉಪಯೋಗವಾಗಬೇಕು. ಅವರು ಅದರಲ್ಲಿಯೇ ನನಗಾಗಿ ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ಅವನ ಮಕ್ಕಳಲ್ಲಿ ಅವನಿಗೆ ಬದಲಾಗಿ ಮಹಾಯಾಜಕನಾಗುವವನು ಪವಿತ್ರಸ್ಥಾನದಲ್ಲಿ ದೇವರ ಸೇವೆಯನ್ನು ನಡೆಸುವುದಕ್ಕೆ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಪ್ರವೇಶಿಸಿದಂದಿನಿಂದ ಏಳು ದಿನಗಳವರೆಗೆ ಆ ವಸ್ತ್ರಗಳನ್ನು ಧರಿಸಿಕೊಂಡಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","ಆರೋನನು ಪ್ರತಿಷ್ಠೆಗಾಗಿ ಸಮರ್ಪಿಸಿದ ಟಗರಿನ ಮಾಂಸವನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಅಂಗಳದಲ್ಲಿ ಬೇಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ಆರೋನನೂ ಅವನ ಮಕ್ಕಳೂ ಆ ಟಗರಿನ ಮಾಂಸವನ್ನೂ ಪುಟ್ಟಿಯಲ್ಲಿರುವ ರೊಟ್ಟಿಯನ್ನೂ ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲೊಳಗೆ ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ಅವರನ್ನು ಯಾಜಕ ಸೇವೆಗೆ ನೇಮಿಸುವುದಕ್ಕೂ ದೇವರ ಪವಿತ್ರ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸುವುದಕ್ಕೂ ಯಾವ ಪದಾರ್ಥಗಳು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಸಮರ್ಪಿಸಲ್ಪಟ್ಟವೋ ಅವುಗಳನ್ನು ಅವರು ತಿನ್ನಬೇಕೇ ಹೊರತು ಇತರರು ತಿನ್ನಬಾರದು ಏಕೆಂದರೆ ಅವು ಪರಿಶುದ್ಧವಾದವುಗಳಾಗಿ ಮೀಸಲಾದುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ಪ್ರತಿಷ್ಠೆಗೆ ಸಂಬಂಧಪಟ್ಟ ಮಾಂಸದಲ್ಲಾಗಲಿ, ರೊಟ್ಟಿಯಲ್ಲಾಗಲಿ ಏನಾದರೂ ಮರುದಿನದ ಉದಯದ ವರೆಗೆ ಉಳಿದರೆ ಅದನ್ನು ಸುಟ್ಟುಬಿಡಬೇಕು. ಅದು ಪವಿತ್ರವಾದುದರಿಂದ ಯಾರೂ ಅದನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ ರೀತಿಯಲ್ಲಿ ಏಳು ದಿನಗಳ ಕಾಲ ಹೀಗೆ ಅವರನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಬೇಕು. ಆರೋನನನ್ನೂ ಅವನ ಮಕ್ಕಳನ್ನೂ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ಪ್ರತಿದಿನವೂ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಒಂದು ಹೋರಿಯನ್ನು ಯಜ್ಞಮಾಡಬೇಕು. ಅದಲ್ಲದೆ ಯಜ್ಞವೇದಿಯನ್ನು ಶುದ್ಧಮಾಡುವುದಕ್ಕಾಗಿ ಅದರ ಮೇಲೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಸಮರ್ಪಿಸಿ, ಅದನ್ನು ದೇವರ ಸೇವೆಗಾಗಿ ಪ್ರತಿಷ್ಠಿಸುವುದಕ್ಕಾಗಿ ಅಭಿಷೇಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ಹೀಗೆ ಏಳು ದಿನಗಳವರೆಗೂ ಯಜ್ಞವೇದಿಯ ನಿಮಿತ್ತವಾಗಿ ದೋಷಪರಿಹಾರಕ ಆಚಾರವನ್ನು ನಡಿಸಿ ಅದನ್ನು ಪ್ರತಿಷ್ಠಿಸಬೇಕು. ಯಜ್ಞವೇದಿಯು ಅತಿ ಪರಿಶುದ್ಧವಾಗಿರಬೇಕು. ಯಜ್ಞವೇದಿಯನ್ನು ಮುಟ್ಟುವವರೆಲ್ಲರೂ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ನಿತ್ಯವೂ ಸಮರ್ಪಿಸಬೇಕಾದವುಗಳು, ಒಂದು ವರ್ಷದ ಎರಡು ಕುರಿಮರಿಗಳನ್ನು ಪ್ರತಿದಿನವೂ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ಅವುಗಳಲ್ಲಿ ಒಂದನ್ನು ಉದಯಕಾಲದಲ್ಲಿ ಮತ್ತೊಂದನ್ನು ಸಾಯಂಕಾಲದಲ್ಲಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ಒಂದೂವರೆ ಸೇರು ಶ್ರೇಷ್ಠವಾದ ಎಣ್ಣೆಯನ್ನೂ ಮೂರು ಸೇರು ಗೋದಿಹಿಟ್ಟನ್ನೂ ಬೆರಸಿ ಧಾನ್ಯಸಮರ್ಪಣೆಗಾಗಿ ಆ ಮೊದಲನೆಯ ಕುರಿಯ ಸಂಗಡ ಅರ್ಪಿಸಬೇಕು. ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಾಗಿ ಒಂದು ಪಾವು ದ್ರಾಕ್ಷಾರಸವನ್ನು ಅದರೊಂದಿಗೆ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ಸಾಯಂಕಾಲದಲ್ಲಿ ಎರಡನೆಯ ಕುರಿಯನ್ನು ಹೋಮಮಾಡುವಾಗ ಹೊತ್ತಾರೆಯಲ್ಲಿ ಮಾಡಿದ ಪ್ರಕಾರವೇ ಅದರೊಂದಿಗೆ ಭೋಜನ ನೈವೇದ್ಯವನ್ನೂ, ಪಾನದ್ರವ್ಯವನ್ನೂ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯ ಹೋಮವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ಈ ಸರ್ವಾಂಗಹೋಮವನ್ನು ನೀವೂ ನಿಮ್ಮ ಸಂತತಿಯವರು ಪ್ರತಿನಿತ್ಯ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಎದುರಿನಲ್ಲಿ ಮಾಡಬೇಕು. ಆ ಗುಡಾರದಲ್ಲಿ ನಾನು ನಿಮ್ಮೊಂದಿಗೆ ಮಾತನಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ಅಲ್ಲಿಯೇ ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ ದರ್ಶನವನ್ನು ಕೊಡುವೆನು. ಅಲ್ಲಿ ಕಾಣಿಸುವ ನನ್ನ ತೇಜಸ್ಸಿನಿಂದ ಆ ಸ್ಥಳವು ಪರಿಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ನಾನು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನೂ ಯಜ್ಞವೇದಿಯನ್ನೂ ಪರಿಶುದ್ಧಗೊಳಿಸುವೆನು. ಆರೋನನನ್ನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳನ್ನೂ ನನಗೆ ಯಾಜಕ ಸೇವೆ ಮಾಡುವಂತೆ ಶುದ್ಧೀಕರಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ನಾನು ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ವಾಸವಾಗಿದ್ದು ಅವರಿಗೆ ದೇವರಾಗಿರುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ಅವರ ಮಧ್ಯದಲ್ಲಿ ವಾಸಮಾಡುವುದಕ್ಕಾಗಿಯೇ ಅವರನ್ನು ಐಗುಪ್ತದೇಶದಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದ ನಾನೇ ಅವರ ದೇವರಾದ ಯೆಹೋವನು ಎಂದು ಅವರು ತಿಳಿದುಕೊಳ್ಳುವರು. ಅವರ ದೇವರಾದ ಯೆಹೋವನು ನಾನೇ. ");
INSERT INTO kanirv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“ಸುಗಂಧದ್ರವ್ಯಗಳಿಂದ ಧೂಪಹಾಕುವುದಕ್ಕೆ ನೀವು ಜಾಲೀಮರದಿಂದ ಒಂದು ಧೂಪವೇದಿಯನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ಅದು ಒಂದು ಮೊಳ ಉದ್ದವಾಗಿಯು, ಒಂದು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇದ್ದು ಚಚ್ಚೌಕವಾಗಿರಬೇಕು. ಅದರ ಎತ್ತರವು ಎರಡು ಮೊಳವಾಗಿರಬೇಕು. ಅದರ ಕೊಂಬುಗಳು ಅದರಿಂದಲೇ ಆಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ಅದರ ಮೇಲ್ಭಾಗಕ್ಕೆ, ನಾಲ್ಕು ಬದಿಗಳಿಗೆ ಹಾಗೂ ಕೊಂಬುಗಳಿಗೆ, ಚೊಕ್ಕ ಬಂಗಾರದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಬೇಕು. ಸುತ್ತಲೂ ಚಿನ್ನದ ಅರುಗನ್ನು (ಅಂಚು) ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ಅದರ ತೋರಣದ ಕೆಳಗೆ ಯಜ್ಞವೇದಿಯ ಎರಡು ಪಾರ್ಶ್ವಗಳಲ್ಲಿ ಎರಡೆರಡು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮೂಲೆಗಳಲ್ಲಿಯೇ ಹಾಕಿಸಬೇಕು. ಯಜ್ಞವೇದಿಯನ್ನು ಹೊರುವುದಕ್ಕೆ ಕಂಬಗಳನ್ನು ಅವುಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ಆ ಕಂಬಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸಿ ಅವುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ಆಜ್ಞಾಶಾಸನವಿರುವ ಮಂಜೂಷದ ಮುಂದಣ ಪರದೆಗೆ ಎದುರಾಗಿ, ಅಂದರೆ ಆಜ್ಞಾಶಾಸನವಿರುವ ಮಂಜೂಷದ ಮೇಲಿರುವಂಥ ಮತ್ತು ನಾನು ನಿನಗೆ ದರ್ಶನ ಕೊಡುವಂಥ ಕೃಪಾಸನದ ಮುಂದೆ ಅದನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“ಆರೋನನು ಪ್ರತಿನಿತ್ಯ ಹೊತ್ತಾರೆಯಲ್ಲಿ ದೀಪಗಳನ್ನು ಸರಿಪಡಿಸುವಾಗಲೂ ");
INSERT INTO kanirv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ಸಾಯಂಕಾಲದಲ್ಲಿ ದೀಪಗಳನ್ನು ಹೊತ್ತಿಸುವಾಗಲೂ ಅದರ ಮೇಲೆ ಸುಗಂಧದ್ರವ್ಯಗಳಿಂದ ಧೂಪವನ್ನು ಹಾಕಬೇಕು. ಹೀಗೆ ನಿಮ್ಮಿಂದಲೂ ನಿಮ್ಮ ಸಂತತಿಯವರಿಂದಲೂ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿರಂತರವಾದ ಧೂಪ ಸಮರ್ಪಣೆಯು ನಡೆಯುತ್ತಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ಆ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಬೇರೆ ಯಾವ ಧೂಪವನ್ನೂ ಹಾಕಬಾರದು. ಅದರ ಮೇಲೆ ಇತರೆ ಹೋಮವನ್ನಾಗಲಿ, ಭೋಜನದ್ರವ್ಯವನ್ನಾಗಲಿ ಹಾಗೂ ಪಾನದ್ರವ್ಯವನ್ನಾಗಲಿ ಸಮರ್ಪಿಸಕೂಡದು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ಆರೋನನು ಅವನ ಸಂತತಿಯವರೂ ವರ್ಷಕ್ಕೆ ಒಂದು ಸಾರಿ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ಪಶುವಿನ ರಕ್ತವನ್ನು ಆ ಯಜ್ಞವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ ಅದರ ಕುರಿತಾಗಿ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ಅತಿ ಪರಿಶುದ್ಧವಾಗಿದೆ.” ");
INSERT INTO kanirv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ನೀನು ಇಸ್ರಾಯೇಲ್ಯರ ಜನಗಣತಿ ಮಾಡಿಸಿ ಅವರನ್ನು ಲೆಕ್ಕಿಸುವಾಗ ಅವರಿಗೆ ಬಾಧೆಯುಂಟಾಗಿ ವ್ಯಾಧಿ ಸಂಭವಿಸದಂತೆ ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ತನ್ನ ಪ್ರಾಣಕ್ಕಾಗಿ ವಿಮೋಚನ ಕ್ರಯವನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ಲೆಕ್ಕಿತರಾದವರಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ದೇವರ ಸೇವೆಗೆ ನೇಮಕವಾದ ಇಪ್ಪತ್ತು ಗೇರಾ ತೂಕದ ರೂಪಾಯಿಯ ಮೇರೆಗೆ ಅರ್ಧ ಶೆಕೆಲ್ ಕಾಣಿಕೆಯನ್ನು ಕೊಡಬೇಕು. ಈ ಅರ್ಧ ಶೆಕೆಲ್ ಯೆಹೋವನಿಗೆ ಪವಿತ್ರವಾದ ಕಾಣಿಕೆಯಾಗಿರುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ಲೆಕ್ಕ ಮಾಡಿದವರಲ್ಲಿ ಇಪ್ಪತ್ತು ವರ್ಷದವರೂ ಹಾಗೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳವರೂ ಆ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ಪ್ರಾಣಗಳ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಡುವುದರಲ್ಲಿ ಐಶ್ವರ್ಯವಂತರಾದರೂ ಅರ್ಧಶೆಕೆಲಿಗಿಂತ ಹೆಚ್ಚು ಕೊಡಬಾರದು. ಬಡವರು ಕಡಿಮೆ ಕೊಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ನೀನು ಪ್ರಾಣಗಳ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಹಣವನ್ನು ಇಸ್ರಾಯೇಲರಿಂದ ತೆಗೆದುಕೊಂಡು ಅದನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆಗೆ ಉಪಯೋಗಿಸಬೇಕು. ಇಸ್ರಾಯೇಲರ ಪ್ರಾಣಗಳನ್ನು ಉಳಿಸಬೇಕೆಂಬುದಾಗಿ ಆ ಕಾಣಿಕೆಯು ಯೆಹೋವನಾದ ನನ್ನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಜ್ಞಾಪಕವಾಗಿರುವುದು.” ");
INSERT INTO kanirv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ಸ್ನಾನಕ್ಕಾಗಿ ಒಂದು ತಾಮ್ರದ ತೊಟ್ಟಿಯನ್ನೂ ಅದಕ್ಕೆ ತಾಮ್ರದ ಪೀಠವನ್ನೂ ಮಾಡಿಸಿ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೂ, ಯಜ್ಞವೇದಿಗೂ ನಡುವೆ ಇಟ್ಟು ಅದರಲ್ಲಿ ನೀರು ತುಂಬಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ಆರೋನನೂ ಅವನ ಮಕ್ಕಳೂ ಅದರಿಂದ ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಹೋಗುವಾಗ ಹಾಗೂ ದೇವರ ಸೇವೆಯನ್ನು ಮಾಡುವವರಾಗಿ ಯೆಹೋವನಿಗೆ ಹೋಮವನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕಾಗಿ ಯಜ್ಞವೇದಿಯ ಬಳಿಗೆ ಬರುವಾಗ ಜೀವದಿಂದಿರಲು ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ತೊಳೆದುಕೊಳ್ಳದೆ ಬಂದರೆ ಮರಣ ಶಿಕ್ಷೆಯಾಗುವುದು. ಇದು ಅವನಿಗೂ ಮತ್ತು ಅವನ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತ ನಿಯಮವಾಗಿರಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ಇದಲ್ಲದೆ ಯೆಹೋವನು ಮೋಶೆಗೆ ಪುನಃ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ನೀನು ಸುಗಂಧದ್ರವ್ಯಗಳಲ್ಲಿ ದೇವರ ಸೇವೆಗೆ ನೇಮಕವಾದ ತೂಕದ ಮೇರೆಗೆ ಐನೂರು ಶೆಕೆಲ್ ಅಚ್ಚರಕ್ತಬೋಳ, ಅದರರ್ಧ ಅಂದರೆ ಇನ್ನೂರೈವತ್ತು ಶೆಕೆಲ್ ಶ್ರೇಷ್ಠವಾದ ಲವಂಗ, ");
INSERT INTO kanirv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ಐನೂರು ಸುಗಂಧವಾದ ಚೆಕ್ಕೆ, ಮತ್ತು ಒಂದು ಹೀನ್ ಒಲೀವ್ ಎಣ್ಣೆ ಇವುಗಳನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ಸುಗಂಧ ದ್ರವ್ಯಕಾರರ ಪದ್ದತಿಯ ಮೇರೆಗೆ ಮಿಶ್ರಮಾಡಿ ಪರಿಶುದ್ಧವಾದ ಅಭಿಷೇಕ ತೈಲವನ್ನು ಮಾಡಿಸಬೇಕು. ಇದು ಪರಿಶುದ್ಧವಾದ ಅಭಿಷೇಕ ತೈಲವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ಆದುದರಿಂದ ದೇವದರ್ಶನದ ಗುಡಾರ, ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷ, ಮೇಜು, ಮೇಜಿನ ಉಪಕರಣಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ದೀಪಸ್ತಂಭ, ದೀಪಸ್ತಂಭದ ಉಪಕರಣಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ಧೂಪವೇದಿ, ಯಜ್ಞವೇದಿ, ಯಜ್ಞವೇದಿಯ ಉಪಕರಣಗಳು ಹಾಗು ನೀರಿನ ತೊಟ್ಟಿ ಅದರ ಪೀಠ ಇವುಗಳನ್ನೆಲ್ಲಾ ಅಭಿಷೇಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ಅವು ಅತಿ ಪರಿಶುದ್ಧವಾಗುವಂತೆ ಅವುಗಳನ್ನು ಶುದ್ಧೀಕರಿಸಬೇಕು. ಅವುಗಳನ್ನು ಮುಟ್ಟುವವರೆಲ್ಲರೂ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ಅದಲ್ಲದೆ ಆರೋನನೂ ಅವನ ಮಕ್ಕಳೂ ನನಗೆ ಯಾಜಕರಾಗುವಂತೆ ಅವರನ್ನು ಅಭಿಷೇಕಿಸಿ ಶುದ್ಧೀಕರಿಸಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸತಕ್ಕದ್ದೇನೆಂದರೆ, “ನೀವೂ ನಿಮ್ಮ ಸಂತತಿಯವರೂ ಈ ತೈಲವನ್ನು ನನ್ನ ಸೇವೆಗೆ ನೇಮಕವಾದ ಪರಿಶುದ್ಧ ಅಭಿಷೇಕ ತೈಲವೆಂದು ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ಜನರು ಮೈಗೆ ಹಚ್ಚಿಕೊಳ್ಳುವುದಕ್ಕೆ ಇದನ್ನು ಉಪಯೋಗಿಸಬಾರದು. ಈ ವಿಧಾನದ ಮೇರೆಗೆ ಬೇರೆ ಕೆಲಸಕ್ಕಾಗಿ ತೈಲವನ್ನು ಮಾಡಲೇಬಾರದು. ಇದು ದೇವರ ವಸ್ತು. ಇದು ಪರಿಶುದ್ಧವಾದದ್ದು ಎಂದು ನೀವು ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ಇದರಂತೆ ತೈಲವನ್ನು ಮಾಡುವವನಾಗಲಿ ಇದನ್ನು ಯಾಜಕನಲ್ಲದವನ ಮೇಲೆ ಹಚ್ಚುವವನಾಗಲಿ ತನ್ನ ಕುಲದಿಂದ ಬಹಿಷ್ಕೃತನಾಗುವನು.” ");
INSERT INTO kanirv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ಅದಲ್ಲದೆ ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, “ನೀನು ಹಾಲುಮಡ್ಡಿ, ಗುಗ್ಗುಲ ಹಾಗೂ ಗಂಧದ ಚೆಕ್ಕೆ ಎಂಬ ಪರಿಮಳ ದ್ರವ್ಯಗಳನ್ನು ಸ್ವಚ್ಛವಾದ ಧೂಪವನ್ನೂ ಸಮಭಾಗವಾಗಿ ತೆಗೆದುಕೊಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ಸುಗಂಧ ದ್ರವ್ಯ ತಯಾರಿಸುವವರ ಕೌಶಲ್ಯಕ್ಕೆ ತಕ್ಕಂತೆ ಕಲಿಸಿ ಉಪ್ಪು ಹಾಕಿ ದೇವರ ಸೇವೆಗೆ ಪವಿತ್ರವಾದ ಧೂಪದ್ರವ್ಯವನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ಅದರಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಪುಡಿಮಾಡಿಸಿ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷದ ಎದುರಾಗಿ ನಾನು ನಿನಗೆ ದರ್ಶನ ಕೊಡುವ ಸ್ಥಳದಲ್ಲಿ ಇರಿಸಬೇಕು. ಅದು ಅತಿ ಪರಿಶುದ್ಧವಾದದ್ದೆಂದು ನೀವು ಭಾವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ನೀವು ಆ ಧೂಪದ್ರವ್ಯದ ವಿಧಾನದ ಮೇರೆಗೆ ನಿಮ್ಮ ಸ್ವಂತಕ್ಕೋಸ್ಕರ ಧೂಪದ್ರವ್ಯವನ್ನು ಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು. ಅದು ಯೆಹೋವನ ಸೇವೆಗೆ ಮಾತ್ರ ಉಪಯೋಗಿಸಬೇಕಾದ ಮೀಸಲಾದ ಪವಿತ್ರ ಪದಾರ್ಥವೆಂದು ಭಾವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ಸುವಾಸನೆಗೋಸ್ಕರ ಅಂಥದನ್ನು ಮಾಡಿಕೊಳ್ಳುವವನು ತನ್ನ ಕುಲದಿಂದ ಬಹಿಷ್ಕಾರಕ್ಕೆ ಗುರಿಯಾಗುವನು.” ");
INSERT INTO kanirv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೀಗೆಂದನು, ");
INSERT INTO kanirv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ನೋಡು, ನಾನು ಯೆಹೂದ ಕುಲದವನಾದ ಹೂರನ ಮೊಮ್ಮಗನೂ, ಊರಿಯನ ಮಗನೂ ಆಗಿರುವ ಬೆಚಲೇಲನೆಂಬುವನನ್ನು ಹೆಸರು ಹಿಡಿದು ಕರೆದಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ಕಲಾತ್ಮಕವಾದ ವಿನ್ಯಾಸಗಳನ್ನು ಮಾಡುವುದಕ್ಕೂ, ಚಿನ್ನ, ಬೆಳ್ಳಿ ಹಾಗು ತಾಮ್ರಗಳಿಂದ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ರತ್ನಗಳನ್ನು ಕೆತ್ತುವುದಕ್ಕೂ, ಮರದಲ್ಲಿ ಕೆತ್ತನೇ ಕೆಲಸಗಳನ್ನು ಮಾಡುವುದಕ್ಕೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ಅವನಿಗೆ ದೇವರಾತ್ಮವನ್ನು ದಯಪಾಲಿಸಿ, ಅದಕ್ಕೆ ಬೇಕಾದ ಜ್ಞಾನ, ವಿದ್ಯೆ, ವಿವೇಕಗಳನ್ನೂ ಸಕಲ ಶಿಲ್ಪ ಕಲಾಜ್ಞಾನವನ್ನೂ ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ಅವನೊಂದಿಗೆ ದಾನ್ ಕುಲದವನಾದ ಅಹೀಸಾಮಾಕನ ಮಗನಾದ ಒಹೋಲೀಯಾಬನನ್ನೂ ನೇಮಿಸಿದ್ದೇನೆ. ಅದಲ್ಲದೆ ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೆಲ್ಲವನ್ನೂ ಮಾಡುವುದಕ್ಕೆ ಜ್ಞಾನಿಗಳಾದವರೆಲ್ಲರ ಹೃದಯಗಳಲ್ಲಿ ಜ್ಞಾನವನ್ನುಂಟುಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ದೇವದರ್ಶನದ ಗುಡಾರ, ಆಜ್ಞಾಶಾಸನಗಳನ್ನು ಇಟ್ಟಿರುವ ಮಂಜೂಷ ಅದರ ಮೇಲಿರುವ ಕೃಪಾಸನ, ಗುಡಾರದ ಎಲ್ಲಾ ಉಪಕರಣಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ಮೇಜು ಅದರ ಉಪಕರಣಗಳು, ಚೊಕ್ಕ ಬಂಗಾರದ ದೀಪಸ್ತಂಭ ಅದರ ಉಪಕರಣಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ಧೂಪವೇದಿ, ಯಜ್ಞವೇದಿ ಅದರ ಉಪಕರಣಗಳು, ನೀರಿನ ತೊಟ್ಟಿ ಅದರ ಪೀಠ, ");
INSERT INTO kanirv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ಅಲಂಕಾರವಾದ ದೀಕ್ಷಾವಸ್ತ್ರಗಳು ಅಂದರೆ ಆರೋನನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ ಬೇಕಾದ ಪವಿತ್ರ ಯಾಜಕವಸ್ತ್ರಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ಅಭಿಷೇಕತೈಲ ಮತ್ತು ಪವಿತ್ರಸ್ಥಾನದ ಸೇವೆಗೆ ಬೇಕಾದ ಪರಿಮಳಧೂಪ ಇವುಗಳನ್ನೆಲ್ಲಾ ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವರು ಮಾಡುವರು.” ");
INSERT INTO kanirv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ಯೆಹೋವನು ಮತ್ತೆ ಮೋಶೆಗೆ ಹೀಗೆಂದನು, ");
INSERT INTO kanirv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕಾದದ್ದೇನೆಂದರೆ: ನಾನು ನೇಮಿಸಿದ ಪವಿತ್ರ ಸಬ್ಬತ್ ದಿನಗಳನ್ನು ನೀವು ತಪ್ಪದೇ ಆಚರಿಸಬೇಕು. ನಿಮ್ಮನ್ನು ಶುದ್ಧಿಪಡಿಸುವ ಯೆಹೋವನು ನಾನೇ ಎಂದು ನೀವು ತಿಳಿದುಕೊಳ್ಳುವಂತೆ ಇದೇ ನನಗೂ ನಿಮಗೂ ನಿಮ್ಮ ಸಂತತಿಯವರ ಮಧ್ಯ ಇರುವ ಗುರುತು. ");
INSERT INTO kanirv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ಆದಕಾರಣ ನೀವು ಸಬ್ಬತ್ ದಿನವನ್ನು ಪರಿಶುದ್ಧವಾದ ದಿನವೆಂದು ಎಣಿಸಿ ಆಚರಿಸಬೇಕು. ಅದನ್ನು ಅಶುದ್ಧಪಡಿಸುವ ಪ್ರತಿಯೊಬ್ಬನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾವನಾದರೂ ಕೆಲಸವನ್ನು ಮಾಡಿದರೆ ಅವನನ್ನು ಕುಲದಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ಆರು ದಿನಗಳು ಕೆಲಸ ಮಾಡಬೇಕು. ಏಳನೆಯ ದಿನ ಸಂಪೂರ್ಣವಾಗಿ ಕೆಲಸವನ್ನು ನಿಲ್ಲಿಸಬೇಕಾದ ಸಬ್ಬತ್ ದಿನವಾಗಿದೆ. ಅದು ಯೆಹೋವನಿಗೆ ಪರಿಶುದ್ಧವಾದ ದಿನ. ಇಂಥ ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ಕೆಲಸವೇನಾದರೂ ಮಾಡುವವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ಆದುದರಿಂದ ಇಸ್ರಾಯೇಲರು ಸಬ್ಬತ್ ದಿನವನ್ನು ಆಚರಿಸಬೇಕು. ಈ ಆಚರಣೆಯು ಅವರಿಗೂ, ಅವರ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ಇದು ನನಗೂ ಇಸ್ರಾಯೇಲರಿಗೂ ನಡುವೆಯಿರುವ ಸದಾಕಾಲದ ಗುರುತು. ಏಕೆಂದರೆ ಆರು ದಿನಗಳಲ್ಲಿ ಯೆಹೋವನು ಭೂಮ್ಯಾಕಾಶಗಳನ್ನು ಉಂಟುಮಾಡಿ ಏಳನೆಯ ದಿನದಲ್ಲಿ ಕೆಲಸವನ್ನು ಮಾಡದೇ ವಿಶ್ರಮಿಸಿಕೊಂಡನಲ್ಲವೇ?” ");
INSERT INTO kanirv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ಯೆಹೋವನು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡುವುದನ್ನು ಮುಗಿಸಿದ ಮೇಲೆ ಅವನಿಗೆ ಆ ಎರಡು ಆಜ್ಞಾಶಾಸನಗಳನ್ನು ಕೊಟ್ಟನು. ಅವು ದೇವರ ಕೈಯಿಂದ ಬರೆಯಲ್ಪಟ್ಟ ಶಿಲಾಶಾಸನಗಳಾಗಿವೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ಮೋಶೆಯು ಬೆಟ್ಟದಿಂದ ಇಳಿದು ಬರುವುದರಲ್ಲಿ ತಡವಾದುದನ್ನು ಇಸ್ರಾಯೇಲರು ನೋಡಿ, ಆರೋನನ ಬಳಿಗೆ ಒಟ್ಟಾಗಿ ಸೇರಿ ಬಂದು ಆತನಿಗೆ, “ಏಳು, ನಮ್ಮನ್ನು ಮುನ್ನಡೆಸಿಕೊಂಡು ಹೋಗುವುದಕ್ಕೆ ನಮಗೊಬ್ಬ ದೇವರನ್ನು ಮಾಡಿಕೊಡು ಏಕೆಂದರೆ ಐಗುಪ್ತದೇಶದಿಂದ ನಮ್ಮನ್ನು ಕರೆದುಕೊಂಡು ಬಂದ ಆ ಮೋಶೆಯು ಏನಾದನೋ ಗೊತ್ತಿಲ್ಲ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ಅದಕ್ಕೆ ಆರೋನನು ಅವರಿಗೆ, “ನಿಮ್ಮ ಹೆಂಡತಿಯರ ಹಾಗು ಗಂಡುಹೆಣ್ಣು ಮಕ್ಕಳ ಕಿವಿಯಲ್ಲಿ ಹಾಕಿಕೊಂಡಿರುವ ಚಿನ್ನದ ಓಲೆಗಳನ್ನು ಬಿಚ್ಚಿ ನನಗೆ ಒಪ್ಪಿಸಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ಅವರೆಲ್ಲರೂ ತಮ್ಮ ಕಿವಿಗಳಲ್ಲಿದ್ದ ಚಿನ್ನದ ಓಲೆಗಳನ್ನು ಬಿಚ್ಚಿ ಆರೋನನ ಬಳಿಗೆ ತಂದು ಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ಅವನು ಆ ಚಿನ್ನವನ್ನು ತನ್ನ ವಶಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋರಿಕರುವಿನ ಆಕಾರವನ್ನು ಉಳಿಯಿಂದ ರೂಪಿಸಿ ಎರಕ ಹೊಯ್ಯಿಸಿದನು. ಆಗ ಅವರು “ಇಸ್ರಾಯೇಲರೇ ನೋಡಿರಿ, ಇದೇ ನಿಮ್ಮನ್ನು ಐಗುಪ್ತದೇಶದಿಂದ ಕರೆದುಕೊಂಡು ಬಂದ ದೇವರು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ಆರೋನನು ಅದನ್ನು ನೋಡಿದಾಗ ಹೋರಿಕರುವಿಗೆ ಎದುರಾಗಿ ಒಂದು ಯಜ್ಞವೇದಿಯನ್ನು ಕಟ್ಟಿಸಿ, “ನಾಳೆ ಯೆಹೋವನಿಗೆ ಹಬ್ಬವಾಗಬೇಕು” ಎಂದು ಪ್ರಕಟಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ಆದುದರಿಂದ ಮರುದಿನದಲ್ಲಿ ಜನರು ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನೂ ಸಮರ್ಪಿಸಿದರು. ಆನಂತರ ಜನರು ತಿನ್ನುವುದಕ್ಕೂ ಕುಡಿಯುವುದಕ್ಕೂ ಕುಳಿತುಕೊಂಡರು. ಆಮೇಲೆ ಕುಣಿದಾಡಲು ಎದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ಹೀಗಿರಲಾಗಿ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಬೆಟ್ಟದಿಂದ ಇಳಿದುಹೋಗು ಐಗುಪ್ತದೇಶದಿಂದ ನೀನು ಕರೆದುಕೊಂಡು ಬಂದ ನಿನ್ನ ಜನರು ಕೆಟ್ಟುಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ನಾನು ಅವರಿಗೆ ಅಜ್ಞಾಪಿಸಿದ ಮಾರ್ಗವನ್ನು ಅವರು ಬೇಗನೇ ಬಿಟ್ಟು ಹೋಗಿ ತಮಗೆ ಎರಕ ಹೊಯ್ದ ಹೋರಿಕರುವನ್ನು ಮಾಡಿಸಿಕೊಂಡು ಅದಕ್ಕೆ ಅಡ್ಡಬಿದ್ದು ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಿ, ‘ಇಸ್ರಾಯೇಲ್ಯರೇ ನೋಡಿರಿ ಇದೇ ನಿಮ್ಮನ್ನು ಐಗುಪ್ತದೇಶದಿಂದ ಕರೆದುಕೊಂಡು ಬಂದ ದೇವರು ಎಂದು ಹೇಳಿಕೊಳ್ಳುತ್ತಿದ್ದಾರೆ’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ಅದಲ್ಲದೆ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಈ ಜನರ ಸ್ವಭಾವವನ್ನು ನಾನು ನೋಡಿದ್ದೇನೆ. ಇವರು ಮೊಂಡುತನವುಳ್ಳ ಜನರಾಗಿದ್ದಾರೆ ");
INSERT INTO kanirv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ಆದಕಾರಣ ನೀನು ನನ್ನನ್ನು ತಡೆಯಬೇಡ. ನನ್ನ ಕೋಪಾಗ್ನಿ ಉರಿಯಲಿ, ಅವರನ್ನು ಭಸ್ಮಮಾಡಿಬಿಡುವೆನು. ತರುವಾಯ ನಿನ್ನಿಂದಲೇ ಒಂದು ಮಹಾ ಜನಾಂಗವನ್ನು ಉಂಟುಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ಆಗ ಮೋಶೆ ತನ್ನ ದೇವರಾದ ಯೆಹೋವನನ್ನು ಬೇಡಿಕೊಂಡು, “ಯೆಹೋವನೇ ನೀನು ಮಹಾ ಶಕ್ತಿಯಿಂದಲೂ, ಭುಜಬಲದಿಂದಲೂ ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಗೆ ಕರೆತಂದ ನಿನ್ನ ಪ್ರಜೆಗಳ ಮೇಲೆ ಕೋಪದಿಂದುರಿಯುವುದೇತಕೆ? ");
INSERT INTO kanirv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ಐಗುಪ್ತ್ಯರು ನಿನ್ನ ವಿಷಯದಲ್ಲಿ, ‘ಯೆಹೋವನು ಕೇಡು ಮಾಡಬೇಕೆಂಬ ಅಭಿಪ್ರಾಯದಿಂದಲೇ ಇಸ್ರಾಯೇಲರನ್ನು ಇಲ್ಲಿಂದ ಕರೆದುಕೊಂಡು ಹೋದನಲ್ಲಾ. ಅವರನ್ನು ಬೆಟ್ಟಗಳಲ್ಲಿ ಸಾಯಿಸಲಿಕ್ಕೂ ಭೂಮಿಯಿಂದ ನಿರ್ಮೂಲ ಮಾಡುವುದಕ್ಕೂ ಅವರನ್ನು ಕರೆದುಕೊಂಡು ಹೋದನೆಂದು ಹೇಳಿಕೊಳ್ಳುವುದೇತಕ್ಕೆ?’ ನೀನು ರೋಷಾಗ್ನಿಯನ್ನು ಬಿಟ್ಟು ನಿನ್ನ ಪ್ರಜೆಗಳಿಗೆ ಕೆಡುಕನ್ನು ಮಾಡದೆ ಮನಸ್ಸನ್ನು ಬದಲು ಮಾಡಿಕೋ. ");
INSERT INTO kanirv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ನಿನ್ನ ಸೇವಕರಾದ ಅಬ್ರಹಾಮ್, ಇಸಾಕ್ ಹಾಗು ಯಾಕೋಬರನ್ನು ನೆನಪಿಗೆ ತಂದುಕೋ. ನೀನು ನಿನ್ನ ಜೀವದಾಣೆ ಪ್ರಮಾಣ ಮಾಡಿ ಅವರಿಗೆ, ‘ನಾನು ನಿಮ್ಮ ಸಂತತಿಯನ್ನು ಹೆಚ್ಚಿಸಿ ಆಕಾಶದ ನಕ್ಷತ್ರಗಳಷ್ಟು ಅಸಂಖ್ಯವಾಗಿ ಈ ಪ್ರದೇಶವನ್ನೆಲ್ಲಾ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಕೊಡುವೆನೆಂದೂ ಇಸ್ರಾಯೇಲರು ಈ ದೇಶವನ್ನು ಶಾಶ್ವತವಾಗಿ ಸ್ವಾಧೀನ ಮಾಡಿಕೊಳ್ಳುವರೆಂದೂ ಮಾತುಕೊಡಲಿಲ್ಲವೇ’” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ಆಗ ಯೆಹೋವನು ತನ್ನ ಪ್ರಜೆಗಳಿಗೆ ಮಾಡುವೆನೆಂದು ತಾನು ಹೇಳಿದ ಕೇಡಿನ ವಿಷಯದಲ್ಲಿ ಮನಸ್ಸನ್ನು ಬದಲಾಯಿಸಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ಆಜ್ಞಾಶಾಸನಗಳಾದ ಆ ಎರಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳನ್ನು ಮೋಶೆಯು ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡು ಬೆಟ್ಟದಿಂದ ಇಳಿದು ಬಂದನು. ಆ ಹಲಿಗೆಗಳ ಎರಡು ಪಕ್ಕಗಳಲ್ಲಿಯೂ ಅಕ್ಷರಗಳು ಬರೆದಿದ್ದವು. ಈ ಕಡೆಯೂ ಆ ಕಡೆಯೂ ಬರಹವಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ಆ ಶಿಲಾಶಾಸನಗಳು ದೇವರ ಕೆಲಸವೇ ಆಗಿದ್ದು, ಅವುಗಳಲ್ಲಿ ಕೆತ್ತಿದ ಅಕ್ಷರಗಳು ದೇವರೇ ಬರೆದದ್ದಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ಇಸ್ರಾಯೇಲರು ಉತ್ಸಾಹದಿಂದ ಕೂಗಾಡುತ್ತಾ ಇರಲಾಗಿ ಯೆಹೋಶುವನು ಆ ಶಬ್ದವನ್ನು ಕೇಳಿ, “ಪಾಳೆಯದ ಕಡೆಯಿಂದ ಯುದ್ಧಧ್ವನಿ ಕೇಳಿಸುತ್ತದೆ” ಎಂದು ಮೋಶೆಗೆ ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ಅದಕ್ಕವನು, “ನನಗೆ ಕೇಳಿಸುವುದು ಜಯ ಧ್ವನಿಯೂ ಅಲ್ಲ, ವಿಜಯಗೀತೆಯೂ ಅಲ್ಲ ಸೋತು ಗೋಳಾಡುವವರ ಧ್ವನಿಯೂ ಅಲ್ಲ, ಗಾನಮಾಡುವವರ ಉಲ್ಲಾಸದ ಧ್ವನಿಯೇ ಆಗಿದೆ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ಮೋಶೆಯು ಪಾಳೆಯದ ಹತ್ತಿರಕ್ಕೆ ಬಂದು ಆ ಹೋರಿಕರುವನ್ನೂ ಮತ್ತು ಜನರು ಕುಣಿದಾಡುವುದನ್ನೂ ಕಂಡಾಗ ಬಹು ಕೋಪಗೊಂಡು ಕೈಯಲ್ಲಿದ್ದ ಶಿಲಾಶಾಸನಗಳನ್ನು ಬೆಟ್ಟದ ತಗ್ಗಿನಲ್ಲಿ ನೆಲಕ್ಕೆ ಹಾಕಿ ಒಡೆದುಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ಜನರು ಮಾಡಿಸಿಕೊಂಡಿದ್ದ ಹೋರಿಕರುವನ್ನು ಅವನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟು ಅರೆದು ಪುಡಿ ಪುಡಿ ಮಾಡಿ ನೀರಿನಲ್ಲಿ ಕಲಸಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಆ ನೀರನ್ನು ಕುಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ಆಗ ಮೋಶೆ ಆರೋನನನ್ನು ಕುರಿತು, “ನೀನು ಈ ಜನರಿಂದ ಮಹಾ ಅಪರಾಧವನ್ನು ಮಾಡಿಸಿದಿಯಲ್ಲಾ ಹೀಗೆ ಮಾಡಿಸುವುದಕ್ಕೆ ಇವರು ನಿನಗೇನು ಮಾಡಿದರು?” ಎಂದು ವಿಚಾರಿಸಲು, ");
INSERT INTO kanirv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ಆರೋನನು, “ಸ್ವಾಮಿಯವರು, ರೋಷಗೊಳ್ಳಬಾರದು ಈ ಜನರು ದುಷ್ಟಸ್ವಭಾದವರು, ಹಠಮಾರಿಗಳು ಎಂಬುದು ನಿನಗೆ ಗೊತ್ತಿಲ್ಲವೇ? ");
INSERT INTO kanirv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ಅವರು ನನ್ನ ಬಳಿಗೆ ಬಂದು, ‘ನಮ್ಮನ್ನು ಮುನ್ನಡೆಸಿಕೊಂಡು ಹೋಗುವುದಕ್ಕೆ ಒಬ್ಬ ದೇವರನ್ನು ಮಾಡಿಸಿಕೊಡು, ಐಗುಪ್ತ ದೇಶದಿಂದ ನಮ್ಮನ್ನು ಕರೆದುಕೊಂಡು ಬಂದ ಮೋಶೆಗೆ ಏನಾಯಿತೋ ಗೊತ್ತಿಲ್ಲ’ ಅಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ಅದಕ್ಕೆ ನಾನು ‘ಯಾರಲ್ಲಿ ಚಿನ್ನದ ಒಡವೆಯಿದೆಯೋ ಅವರೆಲ್ಲರೂ ಅದನ್ನು ಬಿಚ್ಚಿ ನನಗೆ ಕೊಡಬೇಕು’ ಅಂದೆನು. ಅವರು ಹಾಗೆ ಕೊಡಲಾಗಿ ನಾನು ಆ ಚಿನ್ನವನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಹಾಕಿದಾಗ ಈ ಹೋರಿಕರುವಿನ ರೂಪವು ಉಂಟಾಯಿತು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ಮೋಶೆಯು ಜನರು ಅಂಕೆ ತಪ್ಪಿ ತಮ್ಮ ಇಷ್ಟಬಂದಂತೆ ಮಾಡುವುದಕ್ಕೆ ಆರೋನನು ಅವರನ್ನು ಸಡಿಲವಾಗಿ ಬಿಟ್ಟಿದ್ದರಿಂದ ಅವನ ವಿರೋಧಿಗಳು ಅಪಹಾಸ್ಯಮಾಡುವುದಕ್ಕೆ ಆಸ್ಪದವಾಯಿತು, ");
INSERT INTO kanirv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ಅವರು ಕ್ರಮವಿಲ್ಲದೆ ಸ್ವೇಚ್ಛೆಯಾಗಿ ನಡೆದುಕೊಳ್ಳುವುದನ್ನು ನೋಡಿ ಪಾಳೆಯದ ಬಾಗಿಲಲ್ಲಿ ನಿಂತುಕೊಂಡು, “ಯೆಹೋವನ ಪಕ್ಷದವರೆಲ್ಲರೂ ನನ್ನ ಬಳಿಗೆ ಬರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ಆಗ ಲೇವಿಯ ಕುಲದವರೆಲ್ಲರೂ ಅವನ ಬಳಿಗೆ ಸೇರಿ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ಮೋಶೆ ಅವರಿಗೆ, “ಇಸ್ರಾಯೇಲರ ದೇವರಾದ ಯೆಹೋವನು ಅಪ್ಪಣೆಮಾಡುವುದೇನೆಂದರೆ, ‘ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ಕತ್ತಿಯನ್ನು ಸೊಂಟಕ್ಕೆ ಕಟ್ಟಿಕೊಂಡು ಪಾಳೆಯದ ಮಧ್ಯದಲ್ಲಿ ಒಂದು ಬಾಗಿಲಿನಿಂದ ಮತ್ತೊಂದು ಬಾಗಿಲಿನ ವರೆಗೂ ಹೋಗುತ್ತಾ ಬರುತ್ತಾ ತಮ್ಮತಮ್ಮ ಸಹೋದರ, ಗೆಳೆಯ ಮತ್ತು ನೆರೆಯವ ಎಂದು ಲಕ್ಷಿಸದೆ ಜನರನ್ನು ಸಂಹರಿಸಬೇಕು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ಲೇವಿಯ ಕುಲದವರು ಮೋಶೆಯ ಆಜ್ಞೆಯ ಪ್ರಕಾರವೇ ಮಾಡಿದರು. ಆ ದಿನದಲ್ಲಿ ಜನರೊಳಗೆ ಹೆಚ್ಚು ಕಡಿಮೆ ಮೂರು ಸಾವಿರ ಮಂದಿ ಹತರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ಮೋಶೆಯು ಲೇವಿಯರಿಗೆ, “ಈ ಹೊತ್ತು ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ಮಗನನ್ನಾದರೂ ಸಹೋದರರನ್ನಾದರೂ ಲಕ್ಷ್ಯಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳದೇ ನಿಮ್ಮನ್ನು ಯೆಹೋವನ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡಿದ್ದೀರಿ. ಆದುದರಿಂದ ಆತನು ಈ ದಿನ ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ಮರುದಿನದಲ್ಲಿ ಮೋಶೆಯು ಜನರಿಗೆ, “ನೀವು ಮಹಾ ಪಾಪವನ್ನು ಮಾಡಿರುವಿರಿ. ಆದರೂ ನಾನು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಹೋಗುವೆನು. ಒಂದು ವೇಳೆ ನೀವು ಮಾಡಿದ ಪಾಪಕೃತ್ಯಕ್ಕೆ ಪ್ರಾಯಶ್ಚಿತ್ತವನ್ನು ನಾನು ಮಾಡಬಹುದೇನೋ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ಆಗ ಮೋಶೆ ಯೆಹೋವನ ಬಳಿಗೆ ತಿರುಗಿ ಹೋಗಿ, “ಅಯ್ಯೋ! ಈ ಜನರು ಮಹಾ ಪಾಪವನ್ನು ಮಾಡಿದ್ದಾರೆ. ಚಿನ್ನದ ಹೋರಿಕರುವನ್ನು ಮಾಡಿ ದೇವರೆಂದುಕೊಂಡಿದ್ದಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ಆದರೂ ನೀನು ಕರುಣೆಯಿಟ್ಟು ಅವರ ಪಾಪವನ್ನು ಕ್ಷಮಿಸಬೇಕು. ಇಲ್ಲವಾದರೆ ನೀನು ಬರೆದಿರುವ ಜೀವಿತರ ಪುಸ್ತಕದಿಂದ ನನ್ನ ಹೆಸರನ್ನೂ ಅಳಿಸಿಬಿಡಬೇಕೆಂದು ಕೇಳಿಕೊಳ್ಳುತ್ತೇನೆ” ಎಂದು ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ಅದಕ್ಕೆ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಯಾರು ನನ್ನ ಮಾತನ್ನು ಮೀರಿ ಪಾಪಮಾಡಿದರೋ ಅವರ ಹೆಸರುಗಳನ್ನೇ ನನ್ನ ಬಳಿಯಲ್ಲಿರುವ ಪುಸ್ತಕದಿಂದ ನಾನು ಅಳಿಸಿಬಿಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ನೀನು ಇಲ್ಲಿಂದ ಹೊರಟು ನಾನು ನಿನಗೆ ಹೇಳಿದ ದೇಶಕ್ಕೆ ಈ ಜನರನ್ನು ನಡೆಸಿಕೊಂಡು ಹೋಗು. ನೋಡು, ನನ್ನ ದೂತನು ನಿನ್ನ ಮುಂದೆ ನಡೆದು ಮುನ್ನಡೆಸುವನು, ಆದರೂ ನನ್ನ ನ್ಯಾಯತೀರ್ಪಿನ ದಿನದಲ್ಲಿ ನಾನು ಅವರ ಪಾಪಕ್ಕೆ ತಕ್ಕಂತೆ ಅವರನ್ನು ದಂಡಿಸುವೆನು.” ");
INSERT INTO kanirv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ಇಸ್ರಾಯೇಲರು ಆರೋನನ ಕೈಯಿಂದ ಆ ಹೋರಿಕರುವನ್ನು ಮಾಡಿಸಿಕೊಂಡಿದ್ದರಿಂದ ಯೆಹೋವನು ಅವರನ್ನು ದಂಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಕರೆದುತಂದ ಈ ಜನರನ್ನು ನಿನ್ನ ಸಂಗಡ ಕರೆದುಕೊಂಡು ಈ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು, ‘ನಾನು ಅಬ್ರಹಾಮ, ಇಸಾಕ ಮತ್ತು ಯಾಕೋಬರಿಗೆ ಮತ್ತು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಕೊಡುವೆನೆಂದು’ ಪ್ರಮಾಣ ಮಾಡಿದ ದೇಶಕ್ಕೆ ಹೊರಟುಹೋಗು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ನಾನು, ನಿನಗಿಂತ ಮುಂದಾಗಿ ಒಬ್ಬ ದೂತನನ್ನು ಕಳುಹಿಸಿ ಕಾನಾನ್ಯರನ್ನು, ಅಮೋರಿಯರನ್ನು, ಹಿತ್ತಿಯರನ್ನು, ಪೆರಿಜೀಯರನ್ನು, ಹಿವ್ವಿಯರನ್ನು ಹಾಗು ಯೆಬೂಸಿಯರನ್ನು ಹೊರದೂಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ಹಾಲೂ ಮತ್ತು ಜೇನೂ ಹರಿಯುವ ದೇಶಕ್ಕೆ ನೀನು ಹೋಗು. ಆದರೆ ನಾನು ನಿಮ್ಮ ಸಂಗಡ ಬರುವುದಿಲ್ಲ, ಏಕೆಂದರೆ ನೀವು ಮೊಂಡುತನದ ಜನರು. ನಾನು ದಾರಿಯಲ್ಲಿ ನಿಮ್ಮನ್ನು ಸಂಹರಿಸಿಬಿಟ್ಟೇನು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ಇಸ್ರಾಯೇಲ್ ಜನರು ದೋಷಾರೋಪಣೆಯ ಈ ವಾಕ್ಯವನ್ನು ಕೇಳಿದಾಗ ದುಃಖಪಟ್ಟರು. ಅವರಲ್ಲಿ ಒಬ್ಬರೂ ಆಭರಣಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೀಗೆಂದನು. “ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ನೀವು ಮೊಂಡುತನವುಳ್ಳ ಜನರು, ನಾನು ಒಂದು ಕ್ಷಣ ಮಾತ್ರ ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಬರುವುದಾದರೆ, ನಾನು ನಿಮ್ಮನ್ನು ನಿರ್ಮೂಲ ಮಾಡಿಬಿಡುವೆನು. ಆದಕಾರಣ ನಿಮ್ಮ ಆಭರಣಗಳನ್ನು ಈಗ ತೆಗೆದುಬಿಡಿರಿ. ನಿಮಗೆ ನಾನು ಏನು ಮಾಡಬೇಕೆಂಬುದನ್ನು ಆಲೋಚಿಸಿಕೊಳ್ಳುವೆನು’” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ಅದರಂತೆಯೇ ಇಸ್ರಾಯೇಲ್ಯರು ಹೋರೇಬ್ ಬೆಟ್ಟದಿಂದ ಮುಂದೆ ಆಭರಣಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ಮೋಶೆಯು ಗುಡಾರವನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ದೂರವಾಗಿ ಹಾಕಿದ್ದನು. ಅದಕ್ಕೆ ದೇವದರ್ಶನದ ಗುಡಾರ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಯೆಹೋವನ ಉತ್ತರವನ್ನು ಬಯಸಿದವರೆಲ್ಲರೂ ಪಾಳೆಯದ ಹೊರಗಿದ್ದ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೆ ಹೋಗುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ಮೋಶೆಯು ಆ ಗುಡಾರಕ್ಕೆ ಹೋಗುವಾಗಲೆಲ್ಲಾ ಜನರೆಲ್ಲರೂ ಎದ್ದು ತಮ್ಮ ತಮ್ಮ ಡೇರೆಗಳ ಬಾಗಿಲಲ್ಲಿ ನಿಂತು, ಮೋಶೆಯು ಆ ಗುಡಾರದೊಳಕ್ಕೆ ಹೋಗುವ ತನಕ ಅವನನ್ನು ನೋಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ಮೋಶೆಯು ಆ ಗುಡಾರದೊಳಕ್ಕೆ ಹೋದಕೂಡಲೆ ಮೇಘಸ್ತಂಭವು ಇಳಿದು ಆ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ನಿಲ್ಲುತ್ತಿತ್ತು ಹಾಗು ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡುತ್ತಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ಆ ಮೇಘಸ್ತಂಭವು ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ನಿಂತಿದ್ದನ್ನು ಜನರೆಲ್ಲರೂ ನೋಡಿ ತಮ್ಮ ತಮ್ಮ ಡೇರೆಗಳ ಬಾಗಿಲಲ್ಲೇ ಅಡ್ಡಬೀಳುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ಮನುಷ್ಯರೊಳಗೆ ಒಬ್ಬನೂ ತನ್ನ ಸ್ನೇಹಿತನೊಡನೆ ಹೇಗೆ ಮಾತನಾಡುವನೋ ಹಾಗೆಯೇ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮುಖಾಮುಖಿಯಾಗಿ ಮಾತನಾಡುತ್ತಿದ್ದನು. ಆನಂತರ ಮೋಶೆಯು ಪಾಳೆಯಕ್ಕೆ ಹಿಂತಿರುಗಿ ಬರುವನು. ಆದರೆ ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನೆಂಬ ಯೌವನಸ್ಥನಾದ ಅವನ ಶಿಷ್ಯನು ಆ ಗುಡಾರದಲ್ಲಿಯೇ ಇರುತ್ತಿದ್ದನು, ಅದರ ಬಳಿಯಿಂದ ದೂರ ಸರಿಯುತ್ತಿರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “‘ಈ ಜನರನ್ನು ಆ ಸೀಮೆಗೆ ನಡೆಸಿಕೊಂಡು ಹೋಗಬೇಕೆಂದು’ ನೀನು ನನಗೆ ಆಜ್ಞಾಪಿಸಿದಿಯಷ್ಟೇ. ನನ್ನ ಸಂಗಡ ಯಾರನ್ನು ಕಳುಹಿಸಿ ಕೊಡುವೆಯೆಂಬುದನ್ನು ನನಗೆ ತಿಳಿಸಲಿಲ್ಲವಲ್ಲಾ. ‘ಆದರೆ ನಾನು ನಿನ್ನನ್ನು ಚೆನ್ನಾಗಿ ಬಲ್ಲೆನು. ನಿನಗೆ ನನ್ನ ದಯೆ ದೊರಕಿತೆಂದೂ’ ನೀನು ನನಗೆ ಹೇಳಿರುವೆಯಲ್ಲಾ. ");
INSERT INTO kanirv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ನನ್ನ ಮೇಲೆ ದಯೆಯಿರುವುದಾದರೆ ನಿನ್ನ ಮಾರ್ಗವನ್ನು ನನಗೆ ತೋರಿಸು ನಾನು ನಿನ್ನನ್ನು ಅರಿತುಕೊಳ್ಳುವಂತೆ ನಿನ್ನ ಕೃಪೆಯನ್ನು ನನಗೆ ದಯಪಾಲಿಸು ಆಗ ನಿನ್ನ ದಯೆ ನನಗೆ ದೊರೆಯಿತೆಂದು ನನಗೆ ತಿಳಿಯುವುದು. ಈ ಜನಾಂಗವು ನಿನ್ನ ಪ್ರಜೆಯೆಂಬುದನ್ನು ನೆನಪುಮಾಡಿಕೋ” ಎಂದು ಅರಿಕೆಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ಅದಕ್ಕೆ ಯೆಹೋವನು, “ನನ್ನ ಪ್ರಸನ್ನತೆಯು ನಿನ್ನ ಜೊತೆಯಲ್ಲಿ ಬರುವುದು, ನಾನು ನಿಮಗೆ ವಿಶ್ರಾಂತಿಯನ್ನು ನೀಡುವೆನು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ಮೋಶೆಯು ಆತನಿಗೆ, “ನಿನ್ನ ಪ್ರಸನ್ನತೆಯು ನಮ್ಮ ಸಂಗಡ ಬಾರದೇ ಹೋದರೆ ನಮ್ಮನ್ನು ಇಲ್ಲಿಂದ ಹೋಗಗೊಡಿಸಬೇಡ. ");
INSERT INTO kanirv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ನನಗೂ ನಿನ್ನ ಪ್ರಜೆಗಳಾದ ಇವರಿಗೂ ನಿನ್ನ ದಯೆಯು ದೊರಕಿತೆಂಬುದು ನೀನು ನಮ್ಮ ಸಂಗಡ ಬರುವುದರಿಂದಲೇ ಹೊರತು ಬೇರೆ ಯಾವುದರಿಂದ ತಿಳಿದುಬರುವುದು? ಇದರಿಂದ ನಾನೂ ಮತ್ತು ನಿನ್ನ ಪ್ರಜೆಗಳಾದ ಇವರೂ ಭೂಮಿಯಲ್ಲಿರುವ ಬೇರೆ ಎಲ್ಲಾ ಜನಗಳಿಗಿಂತಲೂ ವಿಶೇಷತೆಯುಳ್ಳವರೆಂಬುದು ಗೊತ್ತಾಗುವುದು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಿನಗೆ ನನ್ನ ದಯೆಯು ದೊರಕಿರುವುದರಿಂದಲೂ, ನಾನು ನಿನ್ನ ಹೆಸರನ್ನು ಬಲ್ಲವನಾಗಿರುವುದರಿಂದಲೂ ನಿನಗೋಸ್ಕರ ಈ ಕಾರ್ಯವನ್ನು ಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ಅದಕ್ಕೆ ಮೋಶೆಯು, “ನಿನ್ನ ಮಹಿಮೆಯನ್ನು ದಯಮಾಡಿ ನನಗೆ ತೋರಿಸು” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ಸರ್ವೋತ್ತಮತ್ವವನ್ನು ಅದಕ್ಕೆ ಆತನು, “ನಾನು ನನ್ನ ಮಹಿಮೆಯನ್ನು ಪೂರ್ಣವಾಗಿ ನಿನ್ನೆದುರಿಗೆ ಬರುವಂತೆ ಮಾಡುವೆನು. ಯೆಹೋವನೆಂಬ ನನ್ನ ನಾಮದ ಪೂರ್ಣ ಮಹತ್ವವನ್ನು ನಿನ್ನೆದುರಾಗಿ ಪ್ರಕಟಿಸುವೆನು. ನಾನು ಯಾರ ಮೇಲೆ ದಯೆತೋರಿಸಬೇಕೆಂದಿರುವೆನೋ ಅವನ ಮೇಲೆ ದಯೆ ತೋರಿಸುವೆನು, ಯಾರನ್ನು ಕರುಣಿಸಬೇಕೆಂದಿರುವೆನೋ ಅವನನ್ನು ಕರುಣಿಸುವೆನು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ಆದರೆ ಆತನು ಅವನಿಗೆ, “ನೀನು ನನ್ನ ಮುಖವನ್ನು ನೋಡುವುದಕ್ಕೆ ಸಾಧ್ಯವಿಲ್ಲ. ಏಕೆಂದರೆ ಮನುಷ್ಯರಲ್ಲಿ ಯಾರೂ ನನ್ನನ್ನು ನೋಡಿ ಬದುಕಿರಲಾರನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ಮತ್ತು ಯೆಹೋವನು ಅವನಿಗೆ, “ನೋಡು, ಇಲ್ಲಿ ನನ್ನ ಸಮೀಪದಲ್ಲೇ ಒಂದು ಸ್ಥಳವಿದೆ. ನೀನು ಈ ಬಂಡೆಯ ಮೇಲೆಯೇ ನಿಂತುಕೊಂಡಿರು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ನನ್ನ ಮಹಿಮೆಯು ನಿನ್ನೆದುರಿಗೆ ದಾಟಿಹೋಗುವಾಗ ನಾನು ಈ ಬಂಡೆಯ ಸಂದಿನಲ್ಲಿ ನಿನ್ನನ್ನು ಇರಿಸಿ ನನ್ನ ಮುಂದೆ ದಾಟಿ ಹೋಗುವ ತನಕ ನಿನ್ನನ್ನು ಕೈಯಿಂದ ಮರೆಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ತರುವಾಯ ನಾನು ನನ್ನ ಕೈಯನ್ನು ತೆಗೆದಾಗ ನೀನು ನನ್ನ ಹಿಂಭಾಗವನ್ನು ನೋಡುವಿಯೇ ಹೊರತು ನನ್ನ ಮುಖವು ನಿನಗೆ ಕಾಣಿಸುವುದಿಲ್ಲ” ಎಂದು ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಮೊದಲಿನ ಕಲ್ಲಿನ ಹಲಗೆಗಳಂತೆ ಇನ್ನೂ ಎರಡು ಕಲ್ಲಿನ ಹಲಗೆಗಳನ್ನು ಕೆತ್ತಿಸಿಕೋ. ನೀನು ಒಡೆದು ಬಿಟ್ಟ ಆ ಮೊದಲನೆಯ ಹಲಗೆಗಳ ಮೇಲಿದ್ದ ವಾಕ್ಯಗಳನ್ನು ಈ ಹಲಗೆಗಳ ಮೇಲೆ ನಾನು ಬರೆಯುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ಬೆಳಿಗ್ಗೆ ನೀನು ಸಿದ್ಧನಾಗಿ, ಸೀನಾಯಿ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಅಲ್ಲಿ ಬೆಟ್ಟದ ತುದಿಯ ಮೇಲೆ ನನ್ನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಂತಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ಯಾರೂ ನಿನ್ನ ಜೊತೆಯಲ್ಲಿ ಬೆಟ್ಟದ ಮೇಲಕ್ಕೆ ಬರಬಾರದು. ಈ ಬೆಟ್ಟದ ಮೇಲೆ ಯಾರೂ ಎಲ್ಲಿಯೂ ಕಾಣಿಸಕೂಡದು; ಕುರಿದನಗಳೂ ಬೆಟ್ಟದ ಬಳಿಯಲ್ಲಿ ಮೇಯಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ಆದಕಾರಣ ಮೋಶೆಯು ಮೊದಲಿದ್ದ ಹಲಗೆಗಳಂತೆ ಎರಡು ಕಲ್ಲಿನ ಹಲಗೆಗಳನ್ನು ಕೆತ್ತಿಸಿಕೊಂಡು, ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಬೆಳಗ್ಗೆ ಎದ್ದು ಆ ಎರಡು ಕಲ್ಲಿನ ಹಲಗೆಗಳನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಸೀನಾಯಿಬೆಟ್ಟವನ್ನು ಹತ್ತಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ಆಗ ಯೆಹೋವನು ಮೇಘದಲ್ಲಿ ಇಳಿದು ಬಂದು ಅಲ್ಲಿ ಅವನ ಹತ್ತಿರ ನಿಂತು ಯೆಹೋವನೆಂಬ ತನ್ನ ನಾಮವನ್ನು ಪ್ರಕಟಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ಯೆಹೋವನು ಮೋಶೆಗೆ ಎದುರಾಗಿ ಹೋಗುತ್ತಾ ಪ್ರಕಟಿಸಿ ಹೇಳಿದ್ದೇನೆಂದರೆ; “ಯೆಹೋವನೆಂಬ ದೇವರು ಕರುಣಾಳುವು, ಕೃಪಾಳುವು, ದೀರ್ಘಶಾಂತವುಳ್ಳವನು, ಪ್ರೀತಿಯುಳ್ಳವನು ಹಾಗು ನಂಬಿಗಸ್ತನಾದ ದೇವರು ಆಗಿದ್ದೇನೆ; ");
INSERT INTO kanirv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ಸಾವಿರಾರು ತಲೆಮಾರುಗಳವರೆಗೂ ದಯೆತೋರಿಸುವವನು; ದೋಷಾಪರಾಧ ಪಾಪಗಳನ್ನು ಕ್ಷಮಿಸುವವನು; ಆದರೂ ಅಪರಾಧಿಗಳನ್ನು ಶಿಕ್ಷಿಸದೆ ಬಿಡುವುದಿಲ್ಲ; ತಂದೆಗಳ ದೋಷಫಲವನ್ನು ಮಕ್ಕಳ ಮೇಲೆ ಮೂರು ನಾಲ್ಕು ತಲೆಮಾರುಗಳವರೆಗೆ ಬರಮಾಡುವವನು ಆಗಿದ್ದಾನೆ” ಎಂಬುದೇ. ");
INSERT INTO kanirv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ಮೋಶೆ ತ್ವರೆಪಟ್ಟು ನೆಲಕ್ಕೆ ಬಾಗಿ ನಮಸ್ಕರಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“ಕರ್ತನೇ, ನಿನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ದಯೆಯು ನನಗೆ ದೊರಕಿರುವುದಾದರೆ ನೀನೇ ನಮ್ಮ ಜೊತೆಯಲ್ಲಿ ಬರಬೇಕು. ನಮ್ಮ ಜನರು ಮೊಂಡುಬುದ್ಧಿಯವರೇ; ಆದಾಗ್ಯೂ ನೀನು ನಮ್ಮ ಪಾಪಗಳನ್ನೂ, ಅಧರ್ಮಗಳನ್ನು ಕ್ಷಮಿಸಿ ನಿನ್ನ ಸ್ವತ್ತಾಗಿ ನಮ್ಮನ್ನು ಸ್ವೀಕರಿಸಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ಯೆಹೋವನು ಹೇಳಿದ್ದೇನೆಂದರೆ, “ಕೇಳು, ನಾನು ಒಂದು ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಾಪಿಸುತ್ತೇನೆ, ಲೋಕದಲ್ಲಿ ಎಲ್ಲಿಯೂ ಯಾವ ಜನಾಂಗದಲ್ಲಿಯಾದರೂ ನಡೆಯದಂಥ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ನಿನ್ನ ಜನರೆಲ್ಲರು ನೋಡುವಂತೆ ನಡೆಸುವೆನು. ನಿಮ್ಮ ಸುತ್ತಮುತ್ತಲಿರುವ ಎಲ್ಲಾ ಜನರೂ ಯೆಹೋವನು ಮಾಡುವ ಮಹತ್ಕಾರ್ಯವನ್ನು ನೋಡುವರು. ನಾನು ನಿಮ್ಮ ವಿಷಯದಲ್ಲಿ ಮಾಡಬೇಕೆಂದಿರುವುದು ಭಯಂಕರವಾದದ್ದಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ನಾನು ಈ ದಿನ ನಿಮಗೆ ಆಜ್ಞಾಪಿಸುವುದನ್ನು ನೀವು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು. ಇಗೋ, ನಾನು ಅಮೋರಿಯರನ್ನು, ಕಾನಾನ್ಯರನ್ನು, ಹಿತ್ತಿಯರನ್ನು, ಪೆರಿಜೀಯರನ್ನು, ಹಿವ್ವಿಯರನ್ನು ಹಾಗು ಯೆಬೂಸಿಯರನ್ನು ನಿಮ್ಮ ಎದುರಿನಿಂದ ಹೊರಡಿಸಿಬಿಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ನೀವು ಹೋಗಿ ಸೇರುವ ದೇಶದ ನಿವಾಸಿಗಳ ಸಂಗಡ ಯಾವ ಒಡಂಬಡಿಕೆಯನ್ನೂ ಮಾಡಿಕೊಳ್ಳದಂತೆ ಎಚ್ಚರಿಕೆಯಿಂದಿರಿ; ಹಾಗೆ ಮಾಡಿಕೊಂಡರೆ ಅದು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಉರುಲಿನಂತಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ಆದರೆ ನೀವು ಅವರ ಯಜ್ಞವೇದಿಗಳನ್ನು ಕೆಡವಿ ಅವರ ಕಲ್ಲುಕಂಬಗಳನ್ನು ಒಡೆದು ಅಶೇರವೆಂಬ ವಿಗ್ರಹಸ್ತಂಭಗಳನ್ನು ಕಡಿದುಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ಏಕೆಂದರೆ ತೀಕ್ಷ್ಣತೆಯುಳ್ಳವನು ಎಂಬ ಹೆಸರುಳ್ಳ ಯೆಹೋವನು ತನಗೆ ಸಲ್ಲಬೇಕಾದ ಗೌರವವನ್ನು ಮತ್ತೊಬ್ಬನಿಗೆ ಸಲ್ಲಗೊಡಿಸದ್ದರಿಂದ ನೀವು ಬೇರೆ ಯಾವ ದೇವರ ಮುಂದೆಯೂ ಅಡ್ಡಬೀಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ನೀವು ಆ ದೇಶದ ನಿವಾಸಿಗಳ ಸಂಗಡ ಒಡಂಬಡಿಕೆಮಾಡಿಕೊಳ್ಳದಂತೆ ಜಾಗರೂಕರಾಗಿರಿ, ಮಾಡಿಕೊಂಡರೆ ಅವರು ತಮ್ಮ ದೇವತೆಗಳನ್ನು ಪೂಜಿಸಿ ಯಜ್ಞಗಳನ್ನು ಮಾಡುವಾಗ ಅವರಲ್ಲಿ ಒಬ್ಬನು ಯಜ್ಞಭೋಜನಕ್ಕೆ ನಿಮ್ಮನ್ನೂ ಕರೆದಾನು, ನೀವು ಹೋಗಿ ಭೋಜನ ಮಾಡಬೇಕಾದೀತು, ");
INSERT INTO kanirv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ಅದಲ್ಲದೆ ನೀವು ನಿಮ್ಮ ಪುತ್ರರಿಗಾಗಿ ಅವರಲ್ಲಿ ಪುತ್ರಿಯರನ್ನು ತೆಗೆದುಕೊಳ್ಳುವುದಕ್ಕೆ ಅದು ಮಾರ್ಗವಾಗುವುದು; ತರುವಾಯ ಆ ಸೊಸೆಯರು ತವರುಮನೆಯ ದೇವತೆಗಳನ್ನು ಪೂಜಿಸುವವರಾಗಿ ನಿಮ್ಮ ಮಕ್ಕಳನ್ನೂ ಅನ್ಯದೇವರುಗಳ ಪೂಜೆ ಎಂಬ ವ್ಯಭಿಚಾರಕ್ಕೆ ಎಳೆದಾರು, ಎಚ್ಚರ. ");
INSERT INTO kanirv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","ಎರಕದ ವಿಗ್ರಹಗಳನ್ನು ಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ನಾನು ನಿಮಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ನೀವು ಚೈತ್ರಮಾಸದಲ್ಲಿ ನೇಮಕವಾದ ಕಾಲದಲ್ಲಿ ಏಳು ದಿನಗಳ ಕಾಲ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕು. ನೀವು ಚೈತ್ರಮಾಸದಲ್ಲಿಯೇ ಐಗುಪ್ತದೇಶದಿಂದ ಬಿಡುಗಡೆಯಾಗಿ ಬಂದಿರಲ್ಲವೇ? ");
INSERT INTO kanirv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ಪ್ರಥಮ ಗರ್ಭಫಲವೆಲ್ಲಾ ಅಂದರೆ ನಿಮ್ಮ ದನ ಕುರಿಗಳಲ್ಲಿ ಹುಟ್ಟುವ ಚೊಚ್ಚಲು ಮರಿಗಳೆಲ್ಲಾ ಗಂಡಾದ ಪಕ್ಷಕ್ಕೆ ನನ್ನದೇ. ");
INSERT INTO kanirv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ಕತ್ತೆಯ ಮರಿಗೆ ಬದಲಾಗಿ ಕುರಿಮರಿಯನ್ನು ಕೊಟ್ಟು ಆ ಕತ್ತೆಮರಿಯನ್ನು ಬಿಡಿಸಬಹುದು; ಹಾಗೆ ಬಿಡಿಸಲೊಲ್ಲದೆ ಹೋದರೆ ಅದರ ಕುತ್ತಿಗೆ ಮುರಿದು ಕೊಂದುಬಿಡಬೇಕು. ಆದರೆ ನಿಮ್ಮ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನು ಬದಲು ಕೊಟ್ಟು ಬಿಡಿಸಿಕೊಳ್ಳಲೇ ಬೇಕು. ಒಬ್ಬರೂ ಬರಿಗೈಯಲ್ಲಿ ನನ್ನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಕಾಣಿಸಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ಆರು ದಿನಗಳು ನಿಮ್ಮ ಕೆಲಸವನ್ನು ಮಾಡಿ ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡದೆ ಸ್ವಸ್ಥರಾಗಿರಬೇಕು. ಉಳುವ ಕಾಲದಲ್ಲಿಯೂ, ಕೊಯ್ಯುವ ಕಾಲದಲ್ಲಿಯೂ ಹಾಗೆಯೇ ಏಳನೆಯ ದಿನದಲ್ಲಿ ಕೆಲಸಮಾಡದೆ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“ಗೋದಿ ಬೆಳೆಯ ಪ್ರಥಮ ಫಲದ ಸಮರ್ಪಣೆಯನ್ನು ಪಸ್ಕಹಬ್ಬವಾಗಿ ಏಳು ವಾರಗಳ ನಂತರ ಸುಗ್ಗಿ ಹಬ್ಬವನ್ನು ಆಚರಿಸುವಾಗ ಸಮರ್ಪಿಸಬೇಕು. ವರ್ಷದ ಅಂತ್ಯದಲ್ಲಿ ಫಲಸಂಗ್ರಹದ ಹಬ್ಬವನ್ನೂ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ವರ್ಷಕ್ಕೆ ಮೂರಾವರ್ತಿ ನಿಮ್ಮಲ್ಲಿರುವ ಗಂಡಸರೆಲ್ಲರೂ ಇಸ್ರಾಯೇಲರ ದೇವರಾಗಿರುವ ಕರ್ತನಾದ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ನಾನು ನಿಮ್ಮ ಎದುರಿನಿಂದ ಅನ್ಯಜನಾಂಗಗಳನ್ನು ಹೊರಡಿಸಿ ನಿಮ್ಮ ದೇಶವನ್ನು ವಿಸ್ತರಿಸುವೆನು. ನೀವು ವರ್ಷಕ್ಕೆ ಮೂರಾವರ್ತಿ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಹೋಗುವಾಗ ಯಾರೂ ನಿಮ್ಮ ಭೂಮಿಯನ್ನು ಆಶೆಪಟ್ಟು ಅಪಹರಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ನನಗೆ ಯಜ್ಞವನ್ನು ಮಾಡುವಾಗ ಆ ಯಜ್ಞಪಶುವಿನ ರಕ್ತದೊಡನೆ ಹುಳಿಹಿಟ್ಟನ್ನು ಸಮರ್ಪಿಸಕೂಡದು. ಪಸ್ಕದಲ್ಲಿ ನೀವು ಸಮರ್ಪಿಸಿದ ಯಜ್ಞಮಾಂಸವನ್ನು ಮರುದಿನದ ಸೂರ್ಯೋದಯದವರೆಗೂ ಉಳಿಸಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","ಭೂಮಿಯ ಪ್ರಥಮ ಫಲಗಳಲ್ಲಿ ಶ್ರೇಷ್ಠವಾದುದನ್ನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಮಂದಿರಕ್ಕೆ ತರಬೇಕು. ಆಡುಮರಿಯನ್ನು ಅದರ ತಾಯಿಯ ಹಾಲಿನಲ್ಲಿ ಬೇಯಿಸಕೂಡದು.” ");
INSERT INTO kanirv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಈ ವಾಕ್ಯಗಳನ್ನು ಬರೆ, ಏಕೆಂದರೆ ಈ ವಾಕ್ಯಗಳ ಮೇರೆಗೆ ನಿನ್ನ ಸಂಗಡಲೂ ಇಸ್ರಾಯೇಲರ ಸಂಗಡಲೂ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಂಡಿದ್ದೇನೆ” ಎಂದು ಅಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ಮೋಶೆಯು ಆ ಬೆಟ್ಟದಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಹಗಲಿರುಳು ನಲ್ವತ್ತು ದಿನ ಇದ್ದನು. ಆ ದಿನಗಳಲ್ಲಿ ಅವನು ಏನೂ ತಿನ್ನಲಿಲ್ಲ, ಏನೂ ಕುಡಿಯಲಿಲ್ಲ. ಆತನು ಒಡಂಬಡಿಕೆಯ ವಾಕ್ಯಗಳನ್ನು ಅಂದರೆ ಹತ್ತು ಆಜ್ಞೆಗಳನ್ನು ಆ ಕಲ್ಲಿನ ಹಲಗೆಗಳ ಮೇಲೆ ಬರೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ಮೋಶೆಯು ಆಜ್ಞಾಶಾಸನಗಳಾದ ಆ ಎರಡು ಕಲ್ಲಿನ ಹಲಗೆಗಳನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡು ಸೀನಾಯಿ ಬೆಟ್ಟದಿಂದ ಇಳಿದುಬಂದಾಗ ಅವನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಇದ್ದು ಆತನ ಸಂಗಡ ಸಂಭಾಷಿಸಿದ್ದರಿಂದ ಅವನ ಮುಖವು ಪ್ರಕಾಶಮಾನವಾಗಿತ್ತು; ಆದರೆ ಅ ಪ್ರಭಾವವು ಅವನಿಗೆ ತಿಳಿದಿರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ಮೋಶೆಯ ಮುಖವು ಪ್ರಕಾಶಮಾನವಾಗಿರುವುದನ್ನು ಆರೋನನೂ ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ನೋಡಿ ಅವನ ಹತ್ತಿರಕ್ಕೆ ಬರುವುದಕ್ಕೆ ಭಯಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ಆದರೆ ಮೋಶೆಯು ಅವರನ್ನು ಕರೆಯಲು ಆರೋನನೂ ಸಮೂಹದ ನಾಯಕರೆಲ್ಲರೂ ಅವನ ಬಳಿಗೆ ಬಂದರು; ಮೋಶೆ ಅವರ ಸಂಗಡ ಮಾತನಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ತರುವಾಯ ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಹತ್ತಿರಕ್ಕೆ ಬಂದರು. ಮೋಶೆಯು ತಾನು ಸೀನಾಯಿಬೆಟ್ಟದಲ್ಲಿ ಯೆಹೋವನಿಂದ ಹೊಂದಿದ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ಅವರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ಮೋಶೆಯು ಅವರ ಸಂಗಡ ಮಾತನಾಡಿ ಮುಗಿಸಿದ ನಂತರ ತನ್ನ ಮುಖದ ಮೇಲೆ ಮುಸುಕುಹಾಕಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ಮೋಶೆಯು ಯೆಹೋವನ ಸಂಗಡ ಮಾತನಾಡಬೇಕೆಂದು ಆತನ ಸನ್ನಿಧಿಗೆ ಹೋಗುವಾಗಲೆಲ್ಲಾ ಈ ಮುಸುಕನ್ನು ಹಾಕಿಕೊಳ್ಳುತ್ತಿದ್ದನು. ಹೊರಗೆ ಬಂದಾಗ ಆ ಮುಸುಕನ್ನು ತೆಗೆದಿಡುತ್ತಿದ್ದನು. ಅವನು ಹೊರಗೆ ಬಂದಾಗ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೆಲ್ಲಾ ಇಸ್ರಾಯೇಲರಿಗೆ ತಿಳಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ಮೋಶೆಯ ಮುಖವು ಪ್ರಕಾಶಮಾನವಾಗಿರುವುದನ್ನು ಇಸ್ರಾಯೇಲರು ನೋಡುತ್ತಿದ್ದರು. ಆದಕಾರಣ ಅವನು ಯೆಹೋವನ ಸಂಗಡ ಮಾತನಾಡುವುದಕ್ಕೆ ಹೋಗುವವರೆಗೆ ತನ್ನ ಮುಖದ ಮೇಲೆ ಆ ಮುಸುಕನ್ನು ಪುನಃ ಹಾಕಿಕೊಂಡಿರುತ್ತಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ಮೋಶೆ ಇಸ್ರಾಯೇಲರ ಸಮೂಹವನ್ನೆಲ್ಲಾ ಸೇರಿಸಿ ಅವರಿಗೆ, “ನೀವು ಅನುಸರಿಸಬೇಕೆಂದು ಯೆಹೋವನು ನಿಮಗೆ ಹೀಗೆ ಅಪ್ಪಣೆ ಮಾಡಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ಆರು ದಿನಗಳು ನೀವು ಕೆಲಸ ಮಾಡಬೇಕು; ಏಳನೆಯ ದಿನವು ಪರಿಶುದ್ಧವಾದ ದಿನ; ಅದು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾದ ಸಬ್ಬತ್ ದಿನವಾಗಿರುವುದರಿಂದ ಅಂದು ನೀವು ಸಂಪೂರ್ಣವಾಗಿ ಕೆಲಸವನ್ನು ನಿಲ್ಲಿಸಿಬಿಡಬೇಕು; ಆ ದಿನದಲ್ಲಿ ಕೆಲಸಮಾಡುವವನಿಗೆ ಮರಣದಂಡನೆಯಾಗಬೇಕು; ");
INSERT INTO kanirv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ನೀವು ವಾಸಿಸುವ ಯಾವ ಸ್ಥಳದಲ್ಲಿಯಾದರೂ ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ಬೆಂಕಿಯನ್ನೂ ಹೊತ್ತಿಸಬಾರದು ಎಂದು” ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲ್ಯರ ಸರ್ವಸಮೂಹಕ್ಕೆ ಹೀಗೆಂದನು: “ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ನೀವು ನಿಮ್ಮ ನಿಮ್ಮೊಳಗೆ ಯೆಹೋವನಿಗಾಗಿ ಕಾಣಿಕೆಯನ್ನು ತೆಗೆದುಕೊಡಬೇಕು; ಒಳ್ಳೆಯ ಮನಸ್ಸಿರುವವರೆಲ್ಲರೂ ಕಾಣಿಕೆಯನ್ನು ತಂದುಕೊಡಬೇಕು. ಯೆಹೋವನಿಗೆ ತರಬೇಕಾದ ಆ ಕಾಣಿಕೆಯು ಎಂಥದಾಗಿರಬೇಕೆಂದರೆ; ಚಿನ್ನ, ಬೆಳ್ಳಿ, ತಾಮ್ರ ಎಂಬ ಲೋಹಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳು, ನಾರುಬಟ್ಟೆಗಳು, ಉಣ್ಣೆಯ ಬಟ್ಟೆಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ಹದಮಾಡಿರುವ ಕೆಂಪುಬಣ್ಣದ ಟಗರಿನ ತೊಗಲುಗಳು, ಕಡಲಪ್ರಾಣಿಯ ತೊಗಲುಗಳು, ಜಾಲೀಮರವು, ದೀಪಕ್ಕೆ ಬೇಕಾದ ಎಣ್ಣೆಯು, ");
INSERT INTO kanirv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ಅಭಿಷೇಕತೈಲಕ್ಕೆ ಮತ್ತು ಪರಿಮಳಧೂಪಕ್ಕೆ ಬೇಕಾದ ಸುಗಂಧದ್ರವ್ಯಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ಏಫೋದ್ ಕವಚಕ್ಕೆ ಬೇಕಾಗಿರುವ ರತ್ನಗಳು ಹಾಗು ಎದೆಪದಕದಲ್ಲಿ ಹಚ್ಚಬೇಕಾದ ನಾನಾ ರತ್ನಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“ನಿಮ್ಮಲ್ಲಿರುವ ಜ್ಞಾನಿಗಳಾದ ಶಿಲ್ಪಿಗಳು ಬಂದು ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದವುಗಳನ್ನೆಲ್ಲಾ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ಅವರು ಮಾಡಬೇಕಾದವುಗಳು ಯಾವುವೆಂದರೆ; ದೇವದರ್ಶನದ ಗುಡಾರ, ಅದರ ಮೇಲ್ಹೊದಿಕೆಗಳು, ಕೊಂಡಿಗಳು, ಚೌಕಟ್ಟುಗಳು, ಅಗುಳಿಗಳು, ಕಂಬಗಳು, ಗದ್ದಿಗೆಕಲ್ಲುಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷ, ಅದನ್ನು ಹೊರುವ ಕಂಬಗಳು, ಕೃಪಾಸನ, ಅದನ್ನು ಮರೆಮಾಡುವ ಪರದೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ಮೇಜು, ಅದರ ಕಂಬಗಳು, ಅದರ ಉಪಕರಣಗಳು, ಅದರ ಮೇಲೆ ಇಡತಕ್ಕ ನೈವೇದ್ಯದ ರೊಟ್ಟಿಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ದೀಪಸ್ತಂಭ, ಅದರ ಉಪಕರಣಗಳು, ಹಣತೆಗಳು, ದೀಪಕ್ಕೆ ಬೇಕಾದ ಎಣ್ಣೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ಧೂಪವೇದಿ, ಅದರ ಕಂಬಗಳು, ಅಭಿಷೇಕ ತೈಲ, ಪರಿಮಳಧೂಪದ್ರವ್ಯ, ಗುಡಾರದ ಬಾಗಿಲಿನ ಪರದೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ಯಜ್ಞವೇದಿ, ಅದರ ತಾಮ್ರದ ಜಾಳಿಗೆ, ಕಂಬಗಳು, ಉಪಕರಣಗಳು, ಬೋಗುಣಿ, ಅದರ ಪೀಠ, ");
INSERT INTO kanirv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ಅಂಗಳದ ತೆರೆಗಳು, ಕಂಬಗಳು, ಗದ್ದಿಗೆಕಲ್ಲುಗಳು, ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ಗುಡಾರದ ಗೂಟಗಳು, ಅಂಗಳದ ಗೂಟಗಳು, ಇವುಗಳ ಹಗ್ಗಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ಪವಿತ್ರಸ್ಥಾನದ ಸೇವೆಗೆ ಬೇಕಾದ ಸುಂದರವಾದ ದೀಕ್ಷಾವಸ್ತ್ರಗಳು ಅಂದರೆ ಮಹಾಯಾಜಕನಾದ ಆರೋನನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ ಬೇಕಾದ ಪವಿತ್ರ ಯಾಜಕವಸ್ತ್ರಗಳು ಇವೇ” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ಇಸ್ರಾಯೇಲರು ಮತ್ತು ಸಮೂಹದವರೆಲ್ಲರೂ ಮೋಶೆಯ ಎದುರಿನಿಂದ ಹೊರಟು ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ಯಾರನ್ನು ಹೃದಯವು ಪ್ರೇರೇಪಿಸಿತೋ, ಯಾರ ಮನಸ್ಸು ಸಿದ್ಧವಾಗಿತ್ತೋ ಅವರೆಲ್ಲರೂ ಬಂದು ದೇವದರ್ಶನದ ಗುಡಾರದ ಕೆಲಸಕ್ಕಾಗಿಯೂ ಅದರ ಸಮಸ್ತ ಸೇವೆಗಳಿಗಾಗಿಯೂ, ಪವಿತ್ರ ವಸ್ತ್ರಗಳಿಗಾಗಿಯೂ ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಗಳನ್ನು ತಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ಸಿದ್ಧಚಿತ್ತರಾದ ಗಂಡಸರೂ, ಹೆಂಗಸರೂ ಬಂದು ಯೆಹೋವನಿಗೆ ಚಿನ್ನದ ಕಾಣಿಕೆಗಳನ್ನು ಅಂದರೆ ಕಡಗ, ಮೂಗುತಿ, ಮುದ್ರೆಯುಂಗರ, ಕಂಠಮಾಲೆ ಮೊದಲಾದ ಚಿನ್ನದ ಒಡವೆಗಳನ್ನು ಸಮರ್ಪಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ಯಾರಲ್ಲಿ ನೀಲಿ, ನೇರಳೆ ಹಾಗು ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳು, ನಾರುಬಟ್ಟೆಯು, ಉಣ್ಣೆ ಬಟ್ಟೆಯು, ಹದಮಾಡಿದ ಕೆಂಪುಬಣ್ಣದ ಟಗರಿನ ತೊಗಲುಗಳು ಹಾಗು ಕಡಲಪ್ರಾಣಿಯ ತೊಗಲುಗಳು ಇದ್ದವೋ ಅವರು ಅವುಗಳನ್ನು ತಂದುಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ಯಾರಲ್ಲಿ ಬೆಳ್ಳಿ ಇಲ್ಲವೇ ತಾಮ್ರ ಇತ್ತೋ ಅವರು ಅವುಗಳನ್ನೇ ತಂದು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಿದರು. ಯಾರ ಬಳಿಯಲ್ಲಿ ಗುಡಾರದ ಕೆಲಸಕ್ಕೆ ಬೇಕಾದ ಜಾಲೀಮರವಿತ್ತೋ ಅವರು ಅದನ್ನು ತಂದುಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ನಿಪುಣೆಯರಾದ ಸ್ತ್ರೀಯರು ತಮ್ಮ ಕೈಗಳಿಂದ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ನೂಲನ್ನೂ, ಹತ್ತಿಯ ನೂಲನ್ನೂ ನೇಯ್ದು ಆ ನೂಲನ್ನು ತಂದುಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ಬುದ್ಧಿವಂತೆಯರಾದ ಬೇರೆ ಸ್ತ್ರೀಯರು ಆಡಿನ ಕೂದಲುಗಳನ್ನು ನೇಯ್ದು ತಂದುಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ಅಧಿಪತಿಗಳು ಏಫೋದ್ ಕವಚಕ್ಕೆ ಬೇಕಾದ ಗೋಮೇಧಕ ರತ್ನಗಳನ್ನು, ಎದೆಪದಕದಲ್ಲಿ ಇಡಬೇಕಾದ ರತ್ನಗಳನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ದೀಪಕ್ಕೆ ಬೇಕಾದ ಎಣ್ಣೆಯನ್ನು ಹಾಗು ಅಭಿಷೇಕತೈಲಕ್ಕೆ ಮತ್ತು ಪರಿಮಳಧೂಪಕ್ಕೆ ಬೇಕಾದ ಸುಗಂಧದ್ರವ್ಯಗಳನ್ನು ತಂದುಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ಮೋಶೆಯ ಮೂಲಕ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ಎಲ್ಲಾ ಕೆಲಸಕಾರ್ಯಗಳಿಗಾಗಿ ಆತನಿಗೆ ಕಾಣಿಕೆಗಳನ್ನು ತಂದುಕೊಡುವುದಕ್ಕೆ ಹೃದಯದಿಂದ ಪ್ರೇರೇಪಿತರಾಗಿ ಇಸ್ರಾಯೇಲ್ಯರ ಸ್ತ್ರೀಪುರುಷರೆಲ್ಲರೂ ಮನಃಪೂರ್ವಕವಾಗಿಯೇ ತಂದುಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲ್ಯರಿಗೆ ಹೀಗೆಂದನು, “ನೋಡಿರಿ, ಯೆಹೋವನು ಯೆಹೂದ ಕುಲದವನಾದ ಹೂರನ ಮೊಮ್ಮಗನೂ, ಊರಿಯ ಮಗನೂ ಆಗಿರುವ ಬೆಚಲೇಲನೆಂಬವನನ್ನು ಹೆಸರು ಹಿಡಿದು ಕರೆದಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ಕಲಾತ್ಮಕವಾದ ವಿನ್ಯಾಸಗಳನ್ನು ಕಲ್ಪಿಸುವುದಕ್ಕೂ, ಚಿನ್ನ, ಬೆಳ್ಳಿ ಹಾಗು ತಾಮ್ರಗಳಿಂದ ಕೆಲಸ ಮಾಡುವುದಕ್ಕೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ರತ್ನಗಳನ್ನು ಕೆತ್ತುವುದಕ್ಕೂ, ಮರದಲ್ಲಿ ಕೆತ್ತನೇ ಕೆಲಸವನ್ನು ಮಾಡುವುದಕ್ಕೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ಅವನಿಗೆ ದೇವರಾತ್ಮವನ್ನು ಕೊಟ್ಟು ಅವನಿಗೆ ಬೇಕಾದ ಜ್ಞಾನ, ವಿದ್ಯೆ, ವಿವೇಕಗಳನ್ನೂ ಸಕಲ ಶಿಲ್ಪಕಲಾಜ್ಞಾನವನ್ನೂ ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ಅದಲ್ಲದೆ ಮತ್ತೊಬ್ಬರಿಗೆ ಕಲಿಸಿಕೊಡುವುದಕ್ಕೆ ಸಹ ಅವನಿಗೂ ಮತ್ತು ದಾನ್ ಕುಲದ ಅಹೀಸಾಮಾಕನ ಮಗನಾದ ಒಹೋಲೀಯಾಬನಿಗೂ ವರಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ಕಸೂತಿ ಕೆಲಸ ಕಲ್ಪಿಸುವವರು, ನೀಲಿ, ನೇರಳೆ ಕಡುಗೆಂಪು ವರ್ಣದ ದಾರದಿಂದಲೂ, ಹತ್ತಿಬಟ್ಟೆಯಿಂದಲೂ ಕಸೂತಿ ಕೆಲಸ ಮಾಡುವವರು, ನೇಯುವವರು, ಅಂತೂ ಎಲ್ಲಾ ಕಸಬುದಾರರು ಮಾಡುವ ಕೆಲಸಗಳನ್ನು ಕಸಿಮಾಡುವುದಕ್ಕೂ ಯೆಹೋವನು ಅವರಿಗೆ ಜ್ಞಾನವನ್ನು ಪರಿಪೂರ್ಣವಾಗಿ ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ.” ");
INSERT INTO kanirv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“ಬೆಚಲೇಲನು ಹಾಗೂ ಒಹೋಲೀಯಾಬನು ಮತ್ತು ಬೇರೆ ಜ್ಞಾನಿಗಳೆಲ್ಲರು ಅಂದರೆ ಯೆಹೋವನಿಂದ ಜ್ಞಾನವಿವೇಕಗಳನ್ನು ಹೊಂದಿ ಪವಿತ್ರ ದೇವಮಂದಿರವನ್ನು ನಿರ್ಮಾಣ ಮಾಡುವ ಕೆಲಸಕ್ಕಾಗಿ ಬೇಕಾದ ಸಕಲವಿಧವಾದ ವಸ್ತುಗಳನ್ನು ಮಾಡುವ ಕ್ರಮ ತಿಳಿದಿರುವವರು, ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಎಲ್ಲವನ್ನೂ ಮಾಡುವರು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ಬೆಚಲೇಲನನ್ನೂ ಒಹೋಲೀಯಾಬನನ್ನೂ ಮತ್ತು ಯಾರ ಹೃದಯದಲ್ಲಿ ಯೆಹೋವನು ಜ್ಞಾನವನ್ನು ಕೊಟ್ಟಿದ್ದನೋ, ಯಾರಾರಿಗೆ ಈ ಕೆಲಸಮಾಡುವುದಕ್ಕೆ ಹೃದಯದಲ್ಲಿ ಪ್ರೇರಣೆಯಾಯಿತೋ ಅಂಥ ಜ್ಞಾನಿಗಳೆಲ್ಲರನ್ನೂ ಮೋಶೆಯು ತನ್ನ ಹತ್ತಿರಕ್ಕೆ ಕರೆಯಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ಅವರು ದೇವಮಂದಿರವನ್ನು ನಿರ್ಮಿಸುವ ಕೆಲಸಕ್ಕೆ ಇಸ್ರಾಯೇಲ್ಯರು ತಂದಿದ್ದ ಕಾಣಿಕೆಗಳನ್ನೆಲ್ಲಾ ಮೋಶೆಯಿಂದ ಪಡೆದುಕೊಂಡರು. ಇಸ್ರಾಯೇಲರು ಪ್ರತಿದಿನ ಹೊತ್ತಾರೆಯಲ್ಲಿ ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು ಕಾಣಿಕೆಗಳನ್ನು ಮನಃಪೂರ್ವಕವಾಗಿ ಕೊಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ಆಗ ದೇವಮಂದಿರದ ಕೆಲಸವನ್ನು ಮಾಡುತ್ತಿದ್ದ ಆ ಜ್ಞಾನಿಗಳೆಲ್ಲರು, ");
INSERT INTO kanirv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ತಮ್ಮ ತಮ್ಮ ಕೆಲಸವನ್ನು ಬಿಟ್ಟು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, “ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ಕೆಲಸಕ್ಕೆ ಬೇಕಾಗಿರುವುದಕ್ಕಿಂತಲೂ ಬಹಳ ಹೆಚ್ಚಾಗಿ ಜನರು ಕಾಣಿಕೆಗಳನ್ನು ತರುತ್ತಿದ್ದಾರೆ ಎಂದು” ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ಆಗ ಮೋಶೆಯು ಇದನ್ನು ಗಮನಿಸಿ, “ದೇವಮಂದಿರದ ಕೆಲಸಕ್ಕಾಗಿ ಯಾವ ಪುರುಷನಾಗಲಿ, ಸ್ತ್ರೀಯಾಗಲಿ ಇನ್ನು ಮುಂದೆ ಕಾರ್ಯಗಳನ್ನೂ ಮಾಡಬಾರದು” ಎಂದು ಅಪ್ಪಣೆಮಾಡಿ ಅದನ್ನು ಪಾಳೆಯದಲ್ಲಿ ಪ್ರಕಟಿಸಿದನು. ಜನರು ಕಾಣಿಕೆಗಳನ್ನು ತರುವುದನ್ನು ನಿಲ್ಲಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ಏಕೆಂದರೆ ಕೆಲಸವನ್ನೆಲ್ಲಾ ಮಾಡುವುದಕ್ಕೆ ಸಾಕಾಗುವುದಕ್ಕಿಂತಲೂ ಹೆಚ್ಚು ಸಾಮಗ್ರಿಗಳಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ಆ ಕೆಲಸ ಮಾಡುತ್ತಿದ್ದ ಜ್ಞಾನಿಗಳೆಲ್ಲರು ಹೊಸೆದ ನಾರಿನ ಹತ್ತು ಪರದೆಗಳಿಂದ ಗುಡಾರವನ್ನು ಮಾಡಿ ಆ ಪರದೆಗಳಲ್ಲಿ ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕಡುಗೆಂಪು ವರ್ಣಗಳ ದಾರಗಳಿಂದ ನೇಯ್ಗೆಯವರಂತೆ ಕೆರೂಬಿಗಳನ್ನು ಮಾಡಿ ಅದಕ್ಕೆ ಚಮತ್ಕಾರವಾಗಿ ಕಸೂತಿ ಹಾಕಿ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ಪ್ರತಿಯೊಂದು ಪರದೆಯು ಇಪ್ಪತ್ತೆಂಟು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ನಾಲ್ಕು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇದ್ದವು. ಎಲ್ಲಾ ಪರದೆಗಳು ಸಮಾನ ಅಳತೆಯಲ್ಲಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ಐದೈದು ಪರದೆಗಳನ್ನು ಒಂದೊಂದಾಗಿ ಜೋಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ಈ ಎರಡು ಜೋಡಣೆಗಳಲ್ಲಿ ಒಂದೊಂದರ ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ");
INSERT INTO kanirv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ನೀಲಿ ದಾರದಿಂದ ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಿದರು; ಆ ಕುಣಿಕೆಗಳನ್ನು ಐವತ್ತೈವತ್ತರ ಮೇರೆಗೆ ಒಂದಕ್ಕೊಂದು ಎದುರಾಗಿ ಇರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ಅದಲ್ಲದೆ ಐವತ್ತು ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿ ಆ ಪರದೆಗಳನ್ನು ಒಂದಕ್ಕೊಂದು ಜೋಡಿಸಿದರು; ಹೀಗೆ ಅದು ಒಂದೇ ಗುಡಾರ ಆಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ಬೆಚಲೇಲನು ಗುಡಾರದ ಮೇಲೆ ಹೊದಿಸುವುದಕ್ಕಾಗಿ ಉಣ್ಣೆಯ ಹನ್ನೊಂದು ಪರದೆಗಳಿಂದ ಆ ಗುಡಾರಕ್ಕೆ ಮೇಲಣ ಡೇರೆಯನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ಒಂದೊಂದು ಪರದೆಯು ಮೂವತ್ತು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ನಾಲ್ಕು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇದ್ದವು; ಎಲ್ಲಾ ಪರದೆಗಳೂ ಒಂದೇ ಅಳತೆಯಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ಐದು ಪರದೆಗಳನ್ನು ಒಂದಾಗಿ ಜೋಡಿಸಿ ಮಿಕ್ಕ ಆರು ಪರದೆಗಳನ್ನೂ ಒಂದಾಗಿ ಜೋಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ಒಂದೊಂದರ ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ಐವತ್ತೈವತ್ತು ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ಒಂದೇ ಡೇರೆಯಾಗುವಂತೆ ಸಮಸ್ತವನ್ನು ಜೋಡಿಸುವುದಕ್ಕಾಗಿ ತಾಮ್ರದ ಐವತ್ತು ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ಅದಲ್ಲದೆ ಹದಮಾಡಿರುವ ಟಗರಿನ ತೊಗಲುಗಳಿಂದ ಒಂದು ಮೇಲ್ಹೊದಿಕೆಯನ್ನೂ, ಕಡಲಪ್ರಾಣಿಯ ತೊಗಲುಗಳಿಂದ ಮತ್ತೊಂದು ಮೇಲ್ಹೊದಿಕೆಯನ್ನೂ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ಗುಡಾರಕ್ಕೆ ಜಾಲೀಮರದಿಂದ ನೆಟ್ಟಗೆ ನಿಂತಿರುವ ಹಲಗೆಗಳಿಂದ ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟೂ ಹತ್ತು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ಒಂದುವರೆ ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇತ್ತು; ");
INSERT INTO kanirv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟೂ ಅಡ್ಡಪಟ್ಟಿಗಳಿಂದ ಜೋಡಿಸಲ್ಪಟ್ಟ ಎರಡು ನಿಲುವುಪಟ್ಟಿಗಳುಳ್ಳದ್ದಾಗಿತ್ತು; ಗುಡಾರದ ಎಲ್ಲಾ ಚೌಕಟ್ಟುಗಳನ್ನೂ ಹಾಗೆ ಮಾಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ಗುಡಾರದ ದಕ್ಷಿಣದಿಕ್ಕಿನಲ್ಲಿ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು; ");
INSERT INTO kanirv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ನಲ್ವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೆಕಲ್ಲುಗಳನ್ನು ಮಾಡಿ ಆ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳ ಕೆಳಗೆ ಇಟ್ಟರು; ಒಂದೊಂದು ಚೌಕಟ್ಟಿನಲ್ಲಿರುವ ಎರಡು ನಿಲುವುಪಟ್ಟಿಗಳ ಕೆಳಗೆ ಒಂದೊಂದು ಗದ್ದಿಗೆಕಲ್ಲನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ಹಾಗೆಯೇ ಗುಡಾರದ ಉತ್ತರದಿಕ್ಕಿನಲ್ಲಿ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ");
INSERT INTO kanirv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ಮತ್ತು ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟಿಗೆ ಎರಡೆರಡು ಗದ್ದಿಗೆಕಲ್ಲುಗಳ ಮೇರೆಗೆ ನಲ್ವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೆಕಲ್ಲಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ಗುಡಾರದ ಹಿಂಭಾಗಕ್ಕೆ ಅಂದರೆ ಪಶ್ಚಿಮದಿಕ್ಕಿನಲ್ಲಿ ಆರು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ಗುಡಾರದ ಹಿಂಭಾಗದ ಎರಡು ಮೂಲೆಗಳಿಗೆ ಬೇರೆ ಎರಡು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ಅವು ಬುಡದಿಂದ ತುದಿಯವರೆಗೂ ಅಂದರೆ ಮೊದಲನೆಯ ಬಳೆಯವರೆಗೂ ಜೋಡಿಸಿದ್ದವು; ಹಾಗೆ ಎರಡು ಮೂಲೆಗಳಿಗೂ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ಹೀಗೆ ಎಂಟು ಚೌಕಟ್ಟುಗಳೂ ಮತ್ತು ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟಿಗೆ ಎರಡೆರಡು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೆಕಲ್ಲುಗಳೂ ಒಟ್ಟು ಹದಿನಾರು ಗದ್ದಿಗೆಕಲ್ಲುಗಳಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ಜಾಲೀಮರದಿಂದ ಅಗುಳಿಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ಗುಡಾರದ ಎರಡು ಕಡೆಗಳ ಚೌಕಟ್ಟುಗಳಿಗೂ ಅದರ ಹಿಂದುಗಡೆಯ ಅಂದರೆ ಪಶ್ಚಿಮ ಕಡೆಯ ಚೌಕಟ್ಟುಗಳಿಗೂ ಐದೈದು ಅಗುಳಿಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ಚೌಕಟ್ಟುಗಳ ನಟ್ಟನಡುವೆಯಲ್ಲಿರುವ ಅಗುಳಿಯು ಒಂದು ಕೊನೆಯಿಂದ ಮತ್ತೊಂದು ಕೊನೆಯವರೆಗೂ ಮುಟ್ಟುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ಆ ಚೌಕಟ್ಟುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿ ಅವುಗಳಲ್ಲಿ ಆ ಅಗುಳಿಗಳಿಗಾಗಿ ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿದರು. ಆ ಅಗುಳಿಗಳನ್ನೂ ಚಿನ್ನದ ತಗಡುಗಳಿಂದ ಹೊದಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ನಯವಾಗಿ ಹೊಸೆದ ನಾರಿನ ಪರದೆಯಲ್ಲಿ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳಿಂದ ಕೆರೂಬಿಗಳಿಗೆ ಚಮತ್ಕಾರವಾಗಿ ಕಸೂತಿಹಾಕಿ ಒಂದು ತೆರೆಯನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ಅದಕ್ಕೆ ಜಾಲೀಮರದಿಂದ ನಾಲ್ಕು ಕಂಬಗಳನ್ನು ಮಾಡಿ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿದರು; ಅವುಗಳಿಗೆ ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿ ನಾಲ್ಕು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೆಕಲ್ಲುಗಳನ್ನು ಎರಕಹೊಯಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ಡೇರೆಯ ಬಾಗಿಲಿಗೆ ಹುರಿ ನಾರಿನ ಪರದೆಯಲ್ಲಿ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರದಿಂದ ಕಸೂತಿಹಾಕಿ ಪರದೆಯನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ಆ ಪರದೆಯನ್ನು ತೂಗು ಹಾಕುವುದಕ್ಕಾಗಿ ಐದು ಕಂಬಗಳನ್ನೂ ಅವುಗಳ ಕೊಂಡಿಗಳನ್ನೂ ಮಾಡಿ ಅವುಗಳ ಸುತ್ತಲ ಮೆಟ್ಟಿಲುಗಳಿಗೂ, ಕಟ್ಟುಗಳಿಗೂ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿದರು. ಅವುಗಳ ಐದು ತಳಭಾಗಗಳನ್ನು ತಾಮ್ರದಿಂದ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ಬೆಚಲೇಲನು ಜಾಲೀಮರದಿಂದ ಮಂಜೂಷವನ್ನು ಮಾಡಿಸಿದನು. ಅದು ಎರಡುವರೆ ಮೊಳ ಉದ್ದ, ಒಂದುವರೆ ಮೊಳ ಅಗಲ ಹಾಗೂ ಒಂದುವರೆ ಮೊಳ ಎತ್ತರವೂ ಆಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ಚೊಕ್ಕ ಬಂಗಾರದ ತಗಡುಗಳನ್ನು ಅದರ ಹೊರಗಡೆಯೂ ಮತ್ತು ಒಳಗಡೆಯೂ ಹೊದಿಸಿದನು. ಅದರ ಮೇಲೆ ಸುತ್ತಲು ಚಿನ್ನದ ಕಿರೀಟವನ್ನು ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ನಾಲ್ಕು ಬಂಗಾರದ ಬಳೆಗಳನ್ನು ಎರಕಹೊಯಿಸಿ ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಅಂದರೆ, ಒಂದೊಂದು ಕಡೆಯಲ್ಲಿ ಎರಡೆರಡು ಬಳೆಗಳನ್ನು ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ಮತ್ತು ಜಾಲೀಮರದ ಕಂಬಗಳನ್ನು ಮಾಡಿ ಅವುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ಮಂಜೂಷವನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಕಂಬಗಳನ್ನು ಮಂಜೂಷದ ಪಾರ್ಶ್ವಗಳಲ್ಲಿರುವ ಬಳೆಗಳಲ್ಲಿ ಅದನ್ನು ಸಿಕ್ಕಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ಇದಲ್ಲದೆ ಚೊಕ್ಕಬಂಗಾರದಿಂದ ಕೃಪಾಸನವನ್ನು ಮಾಡಿದನು. ಅದು ಎರಡುವರೆ ಮೊಳ ಉದ್ದವು, ಒಂದುವರೆ ಮೊಳ ಅಗಲವೂ ಆಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ಬೆಚಲೇಲನು ಕೃಪಾಸನದ ಎರಡು ಕೊನೆಗಳಲ್ಲಿ ಕೆರೂಬಿಗಳ ಎರಡು ಬಂಗಾರದ ಆಕಾರಗಳನ್ನು ನಕಾಸಿಕೆಲಸದಿಂದ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ಕೃಪಾಸನದ ಒಂದೊಂದು ಕೊನೆಯಲ್ಲಿ ಒಂದೊಂದು ಕೆರೂಬಿಗಳನ್ನು ಮಾಡಿ ಅವುಗಳನ್ನು ಕೃಪಾಸನಕ್ಕೆ ಜೋಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ಆ ಕೆರೂಬಿಗಳು ಮೇಲಕ್ಕೆ ರೆಕ್ಕೆಗಳನ್ನು ಚಾಚಿರುವಂತೆಯೂ, ಕೃಪಾಸನವನ್ನು ತಮ್ಮ ರೆಕ್ಕೆಗಳಿಂದ ಮುಚ್ಚುವಂತೆಯೂ ಇದ್ದವು. ಅವುಗಳ ಮುಖಗಳು ಎದುರು ಬದುರಾಗಿ ಕೃಪಾಸನವನ್ನು ನೋಡುತ್ತಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ಬೆಚಲೇಲನು ಜಾಲೀಮರದಿಂದ ಮೇಜನ್ನು ಮಾಡಿದನು. ಅದು ಎರಡು ಮೊಳ ಉದ್ದವೂ ಒಂದು ಮೊಳ ಅಗಲವೂ ಒಂದುವರೆ ಮೊಳ ಎತ್ತರವೂ ಆಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ಅದಕ್ಕೆ ಚೊಕ್ಕ ಬಂಗಾರದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿ ಸುತ್ತಲೂ ಚಿನ್ನದ ತೋರಣಗಳನ್ನು ಕಟ್ಟಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ಮೇಜಿನ ಸುತ್ತಲು ಅಂಗೈ ಅಗಲದ ಅಡ್ಡಪಟ್ಟಿಗಳನ್ನು ಮಾಡಿ ಅದಕ್ಕೂ ನಾಲ್ಕು ಚಿನ್ನದ ತೋರಣ ಕಟ್ಟಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ಮೇಜನ್ನು ಎತ್ತುವ ಕಂಬಗಳನ್ನು ಸೇರಿಸುವುದಕ್ಕಾಗಿ ಅದಕ್ಕೆ ನಾಲ್ಕು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಎರಕಹೊಯಿಸಿ ಅದರ ನಾಲ್ಕು ಕಾಲುಗಳಲ್ಲಿ ಜೋಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ಆ ಬಳೆಗಳು ಅಡ್ಡಪಟ್ಟಿಗೆ ಸೇರಿಕೊಂಡಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ಮೇಜನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗುವವರಿಗಾಗಿ ಜಾಲೀಮರದಿಂದ ಕಂಬಗಳನ್ನು ಮಾಡಿ, ಅವುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ಮೇಜಿನ ಮೇಲೆ ಇಡಬೇಕಾದ ಉಪಕರಣಗಳನ್ನು ಅಂದರೆ ಹರಿವಾಣಗಳು, ಧೂಪಾರತಿಗಳು, ಹೂಜಿಗಳು, ಪಾನದ್ರವ್ಯವನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕೆ ಬೇಕಾದ ಬಟ್ಟಲುಗಳು ಇವುಗಳನ್ನು ಚೊಕ್ಕ ಬಂಗಾರದಿಂದ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ಮತ್ತು ಚೊಕ್ಕ ಬಂಗಾರದ ದೀಪಸ್ತಂಭವನ್ನು ಮಾಡಿದನು. ಅದರ ಬುಡವನ್ನು ಮತ್ತು ಕಂಬವನ್ನು ನಕಾಸಿಕೆಲಸದಿಂದ ಮಾಡಿದನು. ಆ ದೀಪಸ್ತಂಭವನ್ನು ಅಖಂಡವಾಗಿ ಪುಷ್ಪದಗೊಂಚಲುಗಳು, ಪುಷ್ಪಗಳು, ಮೊಗ್ಗುಗಳು ಅಲಂಕಾರವಾಗಿ ಅದರಿಂದಲೇ ಹೊರಟಂತೆ ಕೆತ್ತಲಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ಕಂಬದ ಒಂದೊಂದು ಪಾರ್ಶ್ವದಲ್ಲಿ ಮೂರು ಮೂರು ಕೊಂಬೆಗಳಂತೆ ಒಟ್ಟು ಆರು ಕೊಂಬೆಗಳು ಇದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ಪ್ರತಿಯೊಂದು ಕೊಂಬೆಯಲ್ಲಿ ಬಾದಾಮಿ ಹೂವುಗಳಂತಿರುವ ಮೂರು ಮೂರು ಪುಷ್ಪಾಕೃತಿಗಳಿದ್ದವು; ಒಂದೊಂದು ಆಕೃತಿಗೆ ಒಂದೊಂದು ಪುಷ್ಪವೂ, ಒಂದು ಮೊಗ್ಗು ಇದ್ದವು. ಆರು ಕೊಂಬೆಗಳಲ್ಲಿಯೂ ಹಾಗೆಯೇ ಇದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ದೀಪಸ್ತಂಭದಲ್ಲಿ ಬಾದಾಮಿ ಹೂವುಗಳಂತಿರುವ ಪುಷ್ಪಗಳೂ, ಮೊಗ್ಗುಗಳೂ ಇರುವ ಹೂ ಗೊಂಚಲುಗಳಂತೆ ನಾಲ್ಕು ಪುಷ್ಪಾಕೃತಿಗಳು ಇದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ಎರಡೆರಡು ಕೊಂಬೆಗಳು ಕವಲು ಒಡೆದಿರುವ ಸ್ಥಳಗಳಲ್ಲೆಲ್ಲಾ ಒಂದೊಂದು ಮೊಗ್ಗು, ಕೊಂಬೆಗಳ ಕೆಳಗೆ ಕವಲೊಡೆದಿರುವ ಜಾಗಗಳಲ್ಲಿಯೂ ಒಂದೊಂದು ಮೊಗ್ಗು ಹೀಗೆ ಕೊಂಬೆಗಳ ಆರು ಶಾಖೆಗಳಲ್ಲಿಯೂ ಮೊಗ್ಗುಗಳಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ಮೊಗ್ಗುಗಳು, ಶಾಖೆಗಳು ಒಂದೇ ಕಡೆಯಿಂದ ಉದ್ಭವಗೊಂಡಿದ್ದವು. ದೀಪಸ್ತಂಭವನ್ನೆಲ್ಲಾ ಒಟ್ಟಿಗೆ ಚೊಕ್ಕಬಂಗಾರದಿಂದ ಏಕವಾಗಿ ಮಾಡಲಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ಅದರ ಏಳು ಹಣತೆಗಳನ್ನೂ ಅದರ ಕತ್ತರಿಗಳನ್ನೂ ದೀಪದ ಕುಡಿತೆಗೆಯುವ ಬಟ್ಟಲುಗಳನ್ನೂ ಚೊಕ್ಕ ಬಂಗಾರದಿಂದ ಮಾಡಲಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ದೀಪಸ್ತಂಭವನ್ನೂ ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನೂ ಒಂದು ತಲಾಂತು ಚೊಕ್ಕ ಬಂಗಾರದಿಂದ ಮಾಡಲಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ಅವನು ಜಾಲೀಮರದಿಂದ ಧೂಪವೇದಿಯನ್ನು ಮಾಡಿಸಿದನು. ಅದು ಒಂದು ಮೊಳ ಉದ್ದವಾಗಿಯೂ, ಒಂದು ಮೊಳ ಅಗಲವಾಗಿಯು ಇದ್ದು ಚಚ್ಚೌಕವಾಗಿತ್ತು; ಅದರ ಎತ್ತರವು ಎರಡು ಮೊಳವಾಗಿತ್ತು. ಅದರ ಕೊಂಬುಗಳು ಅದರೊಂದಿಗೆ ಏಕವಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ಅದರ ಮೇಲ್ಭಾಗಕ್ಕೂ ಹಲಗೆಗಳಿಗೂ ನಾಲ್ಕು ಪಕ್ಕಗಳಲ್ಲಿದ್ದ ಹಲಗೆಗಳಿಗೂ ಮತ್ತು ಕೊಂಬುಗಳಿಗೂ ಚೊಕ್ಕ ಬಂಗಾರದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿದನು. ಸುತ್ತಲೂ ಚಿನ್ನದ ತೋರಣ ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ಅದನ್ನು ಎತ್ತುವ ಕೋಲುಗಳನ್ನು ಸೇರಿಸುವುದಕ್ಕಾಗಿ ತೋರಣದ ಕೆಳಗೆ ವೇದಿಕೆಯ ಎರಡು ಪಾರ್ಶ್ವಗಳ ಮೂಲೆಗಳಲ್ಲಿ ಎರಡೆರಡು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಜೋಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ಜಾಲೀಮರದಿಂದ ಕೋಲುಗಳನ್ನು ಮಾಡಿ ಅವುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ಅದಲ್ಲದೆ ಅವನು ದೇವರ ಪವಿತ್ರ ಸೇವೆಗೆ ನೇಮಕವಾದ ಪಟ್ಟಾಭಿಷೇಕತೈಲವನ್ನೂ ಪರಿಮಳದ್ರವ್ಯಗಳಿಂದ ಮಾಡಿದ ಸ್ವಚ್ಛವಾದ ಧೂಪದ್ರವ್ಯವನ್ನೂ ಸುಗಂಧದ್ರವ್ಯಮಾಡುವವರ ವಿಧಾನದ ಪ್ರಕಾರವೇ ತಯಾರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ಅವನು ದಹನ ಬಲಿಯ ಯಜ್ಞವೇದಿಯನ್ನು ಜಾಲೀಮರದಿಂದ ಕಟ್ಟಿದನು. ಅದು ಐದು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ಐದು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಚಚ್ಚೌಕವಾಗಿತ್ತು; ಅದರ ಎತ್ತರ ಮೂರು ಮೊಳವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ನಾಲ್ಕು ಕೊಂಬುಗಳನ್ನು ಮಾಡಿದನು; ಅವು ಯಜ್ಞವೇದಿಯಿಂದಲೇ ಮಾಡಲ್ಪಟ್ಟಿದ್ದವು. ಆ ವೇದಿಗೆ ತಾಮ್ರದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ಯಜ್ಞವೇದಿಯ ಉಪಕರಣಗಳನ್ನೆಲ್ಲಾ ಅಂದರೆ ಅದರ ಬಟ್ಟಲುಗಳು, ಸಲಿಕೆಗಳು, ತೊಟ್ಟಿಗಳು, ಮುಳ್ಳುಚಮಚಗಳು, ಅಗ್ಗಿಷ್ಟಿಕೆಗಳು ಇವುಗಳನ್ನೆಲ್ಲಾ ತಾಮ್ರದಿಂದ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ಯಜ್ಞವೇದಿಗೆ ಹೆಣಿಗೆ ಕೆಲಸದಿಂದ ತಾಮ್ರದ ಜಾಲರಿಯನ್ನು ಮಾಡಿಸಿದನು. ಅದು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲಿರುವ ಕಟ್ಟೆಯ ಕೆಳಗೆ ಯಜ್ಞವೇದಿಯ ಬುಡದಿಂದ ನಡುವಿನ ತನಕ ಇರುವಂತೆ ಹಾಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ಯಜ್ಞವೇದಿಯನ್ನು ಎತ್ತಿ ಹಿಡಿಯುವ ಕಂಬಗಳನ್ನು ಸೇರಿಸುವುದಕ್ಕಾಗಿ ತಾಮ್ರದ ಜಾಲರಿಯ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ನಾಲ್ಕು ಬಳೆಗಳನ್ನು ಎರಕಹೊಯಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ಯಜ್ಞವೇದಿಯನ್ನು ಹೊರುವ ಕಂಬಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸಿ ತಾಮ್ರದ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ಎರಡು ಬದಿಗಳಲ್ಲಿರುವ ಬಳೆಗಳಲ್ಲಿ ಅವುಗಳನ್ನು ಸೇರಿಸಿದನು. ಆ ಯಜ್ಞವೇದಿಯನ್ನು ಹಲಗೆಗಳಿಂದ ಬರಿದಾಗಿರುವ ಒಂದು ಪೆಟ್ಟಿಗೆಯಂತೆ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಸೇವೆ ಮಾಡುತ್ತಿದ್ದ ಸ್ತ್ರೀಯರು ಕೊಟ್ಟ ದರ್ಪಣಗಳಿಂದ ತಾಮ್ರದ ತೊಟ್ಟಿಯನ್ನೂ, ಅದರ ಪೀಠವನ್ನೂ ಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ಗುಡಾರಕ್ಕೆ ಅಂಗಳವನ್ನು ಮಾಡಿಸಿದನು. ಆ ಅಂಗಳದ ದಕ್ಷಿಣದಿಕ್ಕಿನಲ್ಲಿ ಇದ್ದ ಪರದೆಗಳು ನಯವಾದ ನಾರಿನ ಬಟ್ಟೆಯಿಂದ ಮಾಡಲಾಗಿತ್ತು, ನೂರುಮೊಳ ಉದ್ದವಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ಅವುಗಳಿಗೆ ಇಪ್ಪತ್ತು ಕಂಬಗಳೂ ಇಪ್ಪತ್ತು ತಾಮ್ರದ ಗದ್ದಿಗೆಕಲ್ಲುಗಳೂ ಇದ್ದವು; ಕಂಬಗಳ ಕೊಂಡಿಗಳೂ ಹಾಗೂ ಕಟ್ಟುಗಳೂ ಬೆಳ್ಳಿಯವುಗಳಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ಉತ್ತರದ ಕಡೆಯಲ್ಲಿಯೂ ನೂರು ಮೊಳ ಉದ್ದವಾದ ಪರದೆಗಳಿದ್ದವು ಅವುಗಳಿಗೆ ಇಪ್ಪತ್ತು ಕಂಬಗಳೂ ಇಪ್ಪತ್ತು ತಾಮ್ರದ ಗದ್ದಿಗೆಕಲ್ಲುಗಳೂ ಇದ್ದವು; ಕಂಬಗಳ ಕೊಂಡಿಗಳೂ ಕಟ್ಟುಗಳೂ ಬೆಳ್ಳಿಯವುಗಳಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ಪಶ್ಚಿಮ ಕಡೆಯಲ್ಲಿ ಐವತ್ತು ಮೊಳ ಉದ್ದವಾದ ತೆರೆಗಳಿದ್ದವು ಅವುಗಳಿಗೆ ಹತ್ತು ಕಂಬಗಳೂ ಹತ್ತು ಗದ್ದಿಗೆಕಲ್ಲುಗಳೂ ಇದ್ದವು; ಕಂಬಗಳ ಕೊಂಡಿಗಳೂ ಕಟ್ಟುಗಳೂ ಬೆಳ್ಳಿಯವಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿಯೂ ಅಂಗಳದ ಅಗಲವು ಐವತ್ತು ಮೊಳವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","ಅಲ್ಲಿ ಬಾಗಿಲಿನ ಎರಡೂ ಕಡೆಗಳಲ್ಲಿಯೂ ಹದಿನೈದು ಮೊಳ ಉದ್ದವಾದ ತೆರೆಗಳಿದ್ದವು ಅವುಗಳಿಗೆ ಮೂರು ಮೂರು ಕಂಬಗಳೂ ಮೂರು ಮೂರು ಗದ್ದಿಗೆಕಲ್ಲುಗಳೂ ಇದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ಅಂಗಳದ ಸುತ್ತಲಿರುವ ಪರದೆಗಳೆಲ್ಲವು ನಯವಾಗಿ ಹೆಣೆದ ಹತ್ತಿಯ ಬಟ್ಟೆಯಿಂದ ಮಾಡಲ್ಪಟ್ಟಿದ್ದವು; ");
INSERT INTO kanirv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ಕಂಬಗಳ ಗದ್ದಿಗೆಕಲ್ಲುಗಳು ತಾಮ್ರದವುಗಳು; ಕಂಬಗಳ ಕೊಂಡಿಗಳೂ, ಕಟ್ಟುಗಳೂ ಬೆಳ್ಳಿಯವು; ಅವುಗಳ ಬೋದಿಗೆಗಳು ಬೆಳ್ಳಿಯ ತಗಡುಗಳಿಂದ ಹೊದಿಸಲ್ಪಟ್ಟವು. ಅಂಗಳದ ಎಲ್ಲಾ ಕಂಬಗಳಿಗೂ ಬೆಳ್ಳಿಯ ಕಟ್ಟುಗಳಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ಅಂಗಳದ ಬಾಗಿಲಲ್ಲಿದ್ದ ಪರದೆಯು ನಯವಾದ ಹತ್ತಿಯ ಬಟ್ಟೆಯಿಂದಲೂ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳಿಂದಲೂ ಕಸೂತಿ ಕೆಲಸದವರ ಕೈಯಿಂದ ಮಾಡಿದ ಹಾಗೆಯೇ ಮಾಡಲ್ಪಟ್ಟಿದ್ದವು. ಅದರ ಉದ್ದವು ಇಪ್ಪತ್ತು ಮೊಳವಾಗಿತ್ತು; ಅದರ ಅಗಲವು ಅಂಗಳದ ಮಿಕ್ಕ ಪರದೆಗಳಂತೆ ಐದು ಮೊಳ. ");
INSERT INTO kanirv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ಬಾಗಿಲಿಗೆ ನಾಲ್ಕು ಕಂಬಗಳೂ ನಾಲ್ಕು ತಾಮ್ರದ ಗದ್ದಿಗೆಕಲ್ಲುಗಳೂ ಇದ್ದವು; ಕಂಬಗಳ ಕೊಂಡಿಗಳಿಗೆ, ಕಟ್ಟುಗಳಿಗೆ ಹಾಗು ಬೋದಿಗೆಗಳಿಗೆ ಹೊದಿಸಲ್ಪಟ್ಟ ತಗಡುಗಳು ಬೆಳ್ಳಿಯವಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ಗುಡಾರದ ಗೂಟಗಳೂ ಅಂಗಳದ ಗೂಟಗಳೂ ತಾಮ್ರದವುಗಳಾಗಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಅಂದರೆ ಒಡಂಬಡಿಕೆಯ ನಿಯಮದ ಗುಡಾರವನ್ನು ಮಾಡುವುದರಲ್ಲಿ ಉಪಯೋಗಿಸಿದ ಪದಾರ್ಥಗಳ ಲೆಕ್ಕಾಚಾರ: ಮೋಶೆಯ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಮಹಾಯಾಜಕನಾದ ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನು ಲೇವಿಯರ ಕೈಯಿಂದ ಲೆಕ್ಕಮಾಡಿಸಿದ ದೇವದರ್ಶನದ ಗುಡಾರದ ಖರ್ಚು ವೆಚ್ಚಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೆಲ್ಲಾ ಯೆಹೂದ ಕುಲದ ಹೂರನ ಮೊಮ್ಮಗನೂ ಊರಿಯ ಮಗನೂ ಆಗಿದ್ದ ಬೆಚಲೇಲನೇ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ಅವನ ಜೊತೆಯಲ್ಲಿ ದಾನ್ ಕುಲದ ಅಹೀಸಾಮಾಕನ ಮಗನಾದ ಒಹೋಲೀಯಾಬನು ಸೇರಿದ್ದನು; ಇವನು ಶಿಲ್ಪವಿದ್ಯೆಬಲ್ಲವನಾಗಿದ್ದನು, ಕಲಾತ್ಮಕ ಕೆಲಸವನ್ನು ಮಾಡಿಸುವವನು ಹಾಗು ಹತ್ತಿಯ ಬಟ್ಟೆಯಲ್ಲಿ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ನೂಲಿನಿಂದ ಕಸೂತಿ ಕೆಲಸ ಮಾಡುವವನು ಆಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ದೇವಮಂದಿರದ ಸಕಲವಿಧವಾದ ಕೆಲಸಗಳಲ್ಲಿ ಉಪಯೋಗಿಸಿದ ಕಾಣಿಕೆಯ ಬಂಗಾರವು ದೇವರ ಸೇವೆಗೆ ನೇಮಕವಾದ ಶೆಕೆಲಿನ ಮೇರೆಗೆ ಇಪ್ಪತ್ತೊಂಬತ್ತು ತಲಾಂತು ಮತ್ತು ಏಳುನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್. ");
INSERT INTO kanirv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ಸಮೂಹದ ಜನಗಣತಿಯಲ್ಲಿ ದಾಖಲಿಸಿದ ಜನರಿಂದ ದೇವರ ಸೇವೆಗೆಂದು ಸಂಗ್ರಹಿಸಿದ ಬೆಳ್ಳಿಯ ತೂಕವು ದೇವರ ಸೇವೆಗೆ ನೇಮಕವಾದ ಶೆಕೆಲಿನ ಮೇರೆಗೆ ನೂರು ತಲಾಂತು ಹಾಗು ಸಾವಿರದ ಏಳುನೂರ ಎಪ್ಪತ್ತೈದು ಶೆಕೆಲ್. ");
INSERT INTO kanirv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ದೇವರ ಸೇವೆಗೆ ನೇಮಕವಾದ ಶೆಕೆಲಿನ ಮೇರೆಗೆ ಒಂದೊಂದು “ಬೆಕಾ” ಅಂದರೆ ಅರ್ಧ ಶೆಕೆಲ್ ಆಗಿತ್ತು. ಜನಗಣತಿಯಲ್ಲಿ ಎಣಿಸಲ್ಪಟ್ಟವರಲ್ಲಿ ಇಪ್ಪತ್ತು ವರ್ಷದವರು ಹಾಗೂ ಅದಕ್ಕೂ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳವರ ಲೆಕ್ಕ ಆರು ಲಕ್ಷದ ಮೂರು ಸಾವಿರದ ಐನೂರ ಐವತ್ತು ಮಂದಿಯಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ದೇವಮಂದಿರದ ಗದ್ದಿಗೆಕಲ್ಲುಗಳನ್ನೂ ಪರದೆಯ ಕಂಬಗಳ ಮೆಟ್ಟುವಕಲ್ಲುಗಳನ್ನೂ ಎರಕಹೊಯ್ಯುವುದರಲ್ಲಿ ಒಂದೊಂದು ಗದ್ದಿಗೆಕಲ್ಲಿಗೆ ಒಂದೊಂದು ತಲಾಂತಿನ ಮೇರೆಗೆ ನೂರು ತಲಾಂತು ಬೆಳ್ಳಿಯು ಉಪಯೋಗಿಸಲಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ಮಿಕ್ಕ ಸಾವಿರದ ಏಳುನೂರ ಎಪ್ಪತ್ತೈದು ಶೆಕೆಲಿನಿಂದ ಕಂಬಗಳಿಗೆ ಕೊಂಡಿಗಳನ್ನೂ ಕಟ್ಟುಗಳನ್ನೂ ಮಾಡಿ ಅವುಗಳ ಅಗುಳಿಗಳಿಗೆ ತಗಡುಗಳನ್ನು ಹೊದಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ಜನರು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟ ತಾಮ್ರದ ಲೆಕ್ಕವು ಎಪ್ಪತ್ತು ತಲಾಂತು ಮತ್ತು ಎರಡು ಸಾವಿರದ ನಾನೂರು ಶೆಕೆಲ್ ಗಳಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ಅವುಗಳಿಂದ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಮೆಟ್ಟುವಕಲ್ಲುಗಳನ್ನು, ತಾಮ್ರದ ಯಜ್ಞವೇದಿಯನ್ನು, ಅದರ ತಾಮ್ರದ ಜಾಲರಿಯನ್ನು, ಯಜ್ಞವೇದಿಯ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ಅಂಗಳದ ಗದ್ದಿಗೆಕಲ್ಲುಗಳನ್ನು, ಅಂಗಳದ ಬಾಗಿಲಿನ ಮೆಟ್ಟುವ ಕಲ್ಲುಗಳನ್ನು ಹಾಗು ಗುಡಾರದ ಮತ್ತು ಅಂಗಳದ ಎಲ್ಲಾ ಗೂಟಗಳನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳಿಂದ ದೇವಮಂದಿರದ ಸೇವೆಗೆ ಅಲಂಕಾರವಾದ ವಸ್ತ್ರಗಳನ್ನೂ ಮತ್ತು ಆರೋನನಿಗೆ ಪರಿಶುದ್ಧ ವಸ್ತ್ರಗಳನ್ನೂ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ಮಹಾಯಾಜಕನ ಏಫೋದೆಂಬ ಕವಚವನ್ನು ನಯವಾಗಿ ಹೊಸೆದ ಹತ್ತಿಯ ಬಟ್ಟೆಯಿಂದಲೂ ಚಿನ್ನದ ದಾರದಿಂದಲೂ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳಿಂದಲೂ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರದೊಡನೆಯೂ ಹತ್ತಿಯ ಬಟ್ಟೆಯೊಡನೆಯೂ ಕಸೂತಿ ಕೆಲಸದವರ ಪದ್ಧತಿಯ ಮೇರೆಗೆ ಕಸೂತಿ ಕೆಲಸವನ್ನು ಮಾಡುವುದಕ್ಕಾಗಿ ಬಂಗಾರವನ್ನು ಬಡಿದು ಹಗುರವಾದ ತಗಡುಗಳನ್ನು ಮಾಡಿ ಸಣ್ಣ ಸಣ್ಣ ಎಳೆಗಳಾಗಿ ಕತ್ತರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ಏಫೋದ್ ಕವಚಕ್ಕೆ ಹೆಗಲಿನ ಮೇಲೆ ಎರಡು ಪಟ್ಟಿಗಳನ್ನು ಮಾಡಿದರು; ಅದರ ಎರಡು ಅಂಚುಗಳು ಜೋಡಿಸಲ್ಪಟ್ಟಿದ್ದವು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ಕವಚದ ಮೇಲಿರುವ ಕಸೂತಿ ನಡುಕಟ್ಟು ಕವಚಕ್ಕೆ ಏಕವಾಗಿದ್ದು ಅದರಂತೆಯೇ ನಯವಾಗಿ ಹೊಸೆದ ಹತ್ತಿಯ ಬಟ್ಟೆಯಿಂದಲು, ಚಿನ್ನದ ದಾರಗಳಿಂದಲು ಹಾಗೂ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರದಿಂದಲೂ ಮಾಡಲ್ಪಟ್ಟಿತ್ತು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅದನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ಮುದ್ರಾಕ್ಷವನ್ನು ಕೆತ್ತುವ ರೀತಿಯಲ್ಲಿ ಗೋಮೇಧಕರತ್ನಗಳಲ್ಲಿ ಇಸ್ರಾಯೇಲನ ಹನ್ನೆರಡು ಮಕ್ಕಳ ಹೆಸರುಗಳನ್ನು ಕೆತ್ತಿ ಆ ರತ್ನಗಳನ್ನು ಕುಂದಣದಲ್ಲಿ ಹಚ್ಚಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಆ ರತ್ನಗಳನ್ನು ಇಸ್ರಾಯೇಲರ ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಅವುಗಳನ್ನು ಏಫೋದ್ ಕವಚದ ಹೆಗಲಿನ ಮೇಲಿರುವ ಪಟ್ಟಿಗಳಲ್ಲಿ ಬಿಗಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ಏಫೋದ್ ಕವಚದಂತೆಯೇ ಕಸೂತಿಯಿಂದಲೂ ಕೆಲಸದಿಂದ ಚಿನ್ನದ ದಾರಗಳಿಂದಲೂ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳಿಂದಲೂ ನಯವಾದ ನಾರಿನ ಬಟ್ಟೆಯಲ್ಲಿ ಎದೆಯಪದಕವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ಅದು ಚಚ್ಚೌಕವಾಗಿತ್ತು. ಆ ಎದೆಯಪದಕವು ಎರಡು ಪದರುಗಳ್ಳುಳದ್ದಾಗಿತ್ತು; ಅದು ಒಂದು ಗೇಣು ಉದ್ದವೂ ಒಂದು ಗೇಣು ಅಗಲವೂ ಆಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ಅದರ ಮುಂಭಾಗದಲ್ಲಿ ನಾಲ್ಕು ಸಾಲುಗಳಾಗಿ ರತ್ನಗಳನ್ನು ಇರಿಸಿದರು. ಮೊದಲನೆಯ ಸಾಲಿನಲ್ಲಿ ಮಾಣಿಕ್ಯ, ಪುಷ್ಯರಾಗ ಮತ್ತು ಸ್ಫಟಿಕಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ಎರಡನೆಯ ಸಾಲಿನಲ್ಲಿ ಪಚ್ಚೆ, ನೀಲಮಣಿ ಮತ್ತು ವಜ್ರಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ಮೂರನೆಯ ಸಾಲಿನಲ್ಲಿ ಸುವರ್ಣರತ್ನ, ಸುಗಂಧಿ ಮತ್ತು ಪದ್ಮರಾಗಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ನಾಲ್ಕನೆಯ ಸಾಲಿನಲ್ಲಿ ಪೀತರತ್ನ, ಬೆರುಲ್ಲ ಮತ್ತು ವೈಡೂರ್ಯಗಳು ಇದ್ದವು. ಈ ರತ್ನಗಳನ್ನು ಕುಂದಣಗಳಲ್ಲಿ ಇರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ಇಸ್ರಾಯೇಲರ ಕುಲಗಳ ಸಂಖ್ಯೆಯ ಪ್ರಕಾರ ಹನ್ನೆರಡು ರತ್ನಗಳಿದ್ದವು; ಮುದ್ರಾಕ್ಷಗಳಲ್ಲಿ ಕೆತ್ತುವ ರೀತಿಯಲ್ಲಿ ಒಂದೊಂದು ರತ್ನದಲ್ಲಿ ಒಂದೊಂದು ಕುಲದ ಹೆಸರು ಕೆತ್ತಲ್ಪಟ್ಟಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ಎದೆಪದಕದ ಮೇಲ್ಗಡೆಯಲ್ಲಿ ಹುರಿಗಳಂತಿರುವ ಚೊಕ್ಕಬಂಗಾರದ ಸರಪಣಿಗಳನ್ನು ನೇಯ್ಗೆಯ ಕೆಲಸದಿಂದ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ಎರಡು ಚಿನ್ನದ ಬಳೆಗಳನ್ನೂ ಎರಡು ಚಿನ್ನದ ಉಂಗುರಗಳನ್ನೂ ಮಾಡಿ ಆ ಉಂಗುರಗಳನ್ನು ಎದೆಪದಕದ ಎರಡು ಮೂಲೆಗಳಿಗೆ ಜೋಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ಹೆಣಿಗೇಕೆಲಸದ ಆ ಎರಡು ಚಿನ್ನದ ಸರಪಣಿಗಳನ್ನು ಪದಕದ ಮೂಲೆಗಳಲ್ಲಿರುವ ಉಂಗುರಗಳಿಗೆ ಜೋಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ಹೆಣಿಗೇಕೆಲಸದ ಆ ಸರಪಣಿಗಳ ಅಂಚುಗಳನ್ನು ಏಫೋದ್ ಕವಚದ ಹೆಗಲಿನ ಪಟ್ಟಿಗಳಲ್ಲಿರುವ ಎರಡು ಬಳೆಗಳ ಮುಂಭಾಗಕ್ಕೆ ಜೋಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ಅದಲ್ಲದೆ ಎರಡು ಚಿನ್ನದ ಉಂಗುರಗಳನ್ನು ಮಾಡಿ ಪದಕದ ಒಳಗಣ ಅಂಚಿನ ಮೂಲೆಗಳಲ್ಲಿ ಕವಚದ ಹತ್ತಿರದಲ್ಲೇ ಇಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ಅವರು ಬೇರೆ ಎರಡು ಚಿನ್ನದ ಉಂಗುರಗಳನ್ನು ಮಾಡಿ ಕವಚದ ಎರಡು ಹೆಗಲಿನ ಪಟ್ಟಿಗಳ ಮುಂಭಾಗದ ಕೆಳಗೆ, ಏಫೋದ್ ಕವಚವನ್ನು ಜೋಡಿಸಿರುವ ಸ್ಥಳದ ಹತ್ತಿರ ಆ ಕಸೂತಿಯ ನಡುಕಟ್ಟಿನ ಮೇಲ್ಗಡೆಯಲ್ಲಿ ಇರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ಎದೆಯಪದಕವು ಕಸೂತಿಯ ನಡುಕಟ್ಟಿನ ಮೇಲ್ಗಡೆಯಲ್ಲಿ ಬಿಗಿಯಾಗಿರುವಂತೆಯೂ ಕವಚದಿಂದ ಕಳಚಿಬೀಳದಂತೆಯೂ ಅದರ ಉಂಗುರಗಳನ್ನು ಕವಚದ ಉಂಗುರಗಳಿಗೆ ನೀಲಿ ದಾರದಿಂದ ಕಟ್ಟಿದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇದನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ಬೆಚಲೇಲನು ಏಫೋದ್ ಕವಚದ ಸಂಗಡ ತೊಟ್ಟುಕೊಳ್ಳಬೇಕಾದ ನಿಲುವಂಗಿಯನ್ನು ನೀಲಿಬಣ್ಣದ ಬಟ್ಟೆಯಿಂದಲೇ ನೇಕಾರನ ಕೆಲಸದಿಂದ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ತಲೆತೂರಿಸುವುದಕ್ಕೆ ಅದರಲ್ಲಿ ಕೊರಳು ಪಟ್ಟಿಯನ್ನು ಮಾಡಿ ಅದು ಹರಿಯದಂತೆ ಅದರ ಸುತ್ತಲೂ ನೇಯ್ಗೆ ಕಸೂತಿಯನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ನಿಲುವಂಗಿಯ ಅಂಚಿನ ಸುತ್ತಲೂ ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರಗಳಿಂದ ದಾಳಿಂಬೆ ಹಣ್ಣಿನಂತೆ ಚೆಂಡುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ಮತ್ತು ಚೊಕ್ಕ ಬಂಗಾರದಿಂದ ಗೆಜ್ಜೆಗಳನ್ನು ಮಾಡಿ ನಿಲುವಂಗಿಯ ಅಂಚಿನಲ್ಲಿ ದಾಳಿಂಬೆ ಚೆಂಡುಗಳ ನಡುವೆ ಇಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ಚಿನ್ನದ ಗೆಜ್ಜೆಯೂ ದಾಳಿಂಬೆಯಂತಿರುವ ಚೆಂಡೂ ಒಂದಾದ ಮೇಲೆ ಒಂದು ದೇವರ ಸೇವೆಗಾಗಿ ಇರುವ ಆ ನಿಲುವಂಗಿಯ ಅಂಚಿನ ಸುತ್ತಲೂ ಇದ್ದವು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅದನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ಅವರು ಆರೋನನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ ನಯವಾದ ನಾರಿನಿಂದ ನೇಕಾರರ ಕೆಲಸದ ರೀತಿಯಲ್ಲಿ ಮೇಲಂಗಿಗಳನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ನಯವಾದ ನಾರಿನಿಂದ ಮಹಾಯಾಜಕನ ಮುಂಡಾಸವನ್ನು, ಯಾಜಕರ ಅಲಂಕಾರವಾದ ಮುಂಡಾಸಗಳನ್ನು ಹಾಗೂ ಚಡ್ಡಿಗಳನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ಮತ್ತು ನೀಲಿ, ನೇರಳೆ, ಕಡುಗೆಂಪು ವರ್ಣಗಳುಳ್ಳ ದಾರದಿಂದಲೂ ಕಸೂತಿ ಕೆಲಸದ ರೀತಿಯಲ್ಲಿ ನಡುಕಟ್ಟನ್ನೂ ಮಾಡಿದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅದನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ಅವರು ಚೊಕ್ಕ ಬಂಗಾರದಿಂದ ಪರಿಶುದ್ಧ ಕಿರೀಟಕ್ಕೆ ಬಾಸಿಂಗವನ್ನು ಮಾಡಿ ಮುದ್ರೆಯನ್ನು ಕೆತ್ತುವ ರೀತಿಯಲ್ಲಿ ಅದರಲ್ಲಿ, ಯೆಹೋವನಿಗೆ ಮೀಸಲು ಎಂಬ ಲಿಪಿಯನ್ನು ಬರೆದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ಅದನ್ನು ಮುಂಡಾಸಕ್ಕೆ ಜೋಡಿಸುವುದಕ್ಕಾಗಿ ನೀಲಿ ದಾರವನ್ನು ಅದಕ್ಕೆ ಕಟ್ಟಿದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅದನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ಈ ರೀತಿಯಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಕೆಲಸವೆಲ್ಲಾ ಮುಗಿಯಿತು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರಾಯೇಲರು ಅದನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ಆಗ ಅವರು ಆ ದೇವದರ್ಶನ ಗುಡಾರವನ್ನು ಮೋಶೆಯ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಬಂದರು. ಗುಡಾರವನ್ನು, ಅದಕ್ಕೆ ಸಂಬಂಧಪಟ್ಟ ಉಪಕರಣಗಳೆಲ್ಲವನ್ನೂ ಅಂದರೆ ಅದರ ಕೊಂಡಿಗಳನ್ನು, ಚೌಕಟ್ಟುಗಳನ್ನು, ಅಗುಳಿಗಳನ್ನು, ಕಂಬಗಳನ್ನು, ಮೆಟ್ಟುವಕಲ್ಲುಗಳನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ಹದಮಾಡಿರುವ ಕೆಂಪುಬಣ್ಣದ ಟಗರಿನ ತೊಗಲುಗಳಿಂದ ಮಾಡಿದ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು, ಕಡಲಪ್ರಾಣಿಯ ತೊಗಲುಗಳಿಂದ ಮಾಡಿದ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಹಾಗೂ ಗರ್ಭಗುಡಿಯನ್ನು ಮರೆಮಾಡುವ ಪರದೆಯನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷವನ್ನು, ಅದರ ಕೋಲುಗಳನ್ನು, ಕೃಪಾಸನವನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ಮೇಜನ್ನು, ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು, ನೈವೇದ್ಯದ ರೊಟ್ಟಿಯನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ಚೊಕ್ಕ ಬಂಗಾರದ ದೀಪಸ್ತಂಭವನ್ನು, ಅದರ ಮೇಲಿಡಬೇಕಾದ ಹಣತೆಗಳನ್ನು, ಅದರ ಉಪಕರಣಗಳನ್ನು, ದೀಪಕ್ಕೆ ಬೇಕಾದ ಎಣ್ಣೆಯನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ಚಿನ್ನದ ಧೂಪವೇದಿಯನ್ನು, ಅಭಿಷೇಕತೈಲವನ್ನು, ಸುವಾಸನೆಯುಳ್ಳ ಧೂಪವನ್ನು, ಗುಡಾರದ ಬಾಗಿಲಿನ ಪರದೆಯನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ತಾಮ್ರದ ಯಜ್ಞವೇದಿಯನ್ನು, ಅದರ ತಾಮ್ರದ ಜಾಲರಿಯನ್ನು, ಅದರ ಕೋಲುಗಳನ್ನು, ಉಪಕರಣಗಳನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ತೊಟ್ಟಿಯನ್ನು, ಅದರ ಪೀಠವನ್ನು, ಅಂಗಳದ ತೆರೆಗಳನ್ನು, ಕಂಬಗಳನ್ನು, ಮೆಟ್ಟುವಕಲ್ಲುಗಳನ್ನು, ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆಯನ್ನು, ಅದರ ಹಗ್ಗಗಳನ್ನು, ಗೂಟಗಳನ್ನು, ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆಗೆ ಬೇಕಾದ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ದೇವಮಂದಿರದೊಳಗೆ ನಡೆಯುವ ದೇವರಕಾರ್ಯಗಳಿಗೆ ಅಲಂಕಾರ ವಸ್ತ್ರ ಅಂದರೆ ಆರೋನನಿಗೆ ಬೇಕಾದ ಪವಿತ್ರ ವಸ್ತ್ರಗಳನ್ನು ಯಾಜಕಸೇವೆ ಮಾಡುವವರಾದ ಅವನ ಮಕ್ಕಳಿಗೆ ಬೇಕಾದ ವಸ್ತ್ರಗಳನ್ನು ತಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಂತೆಯೇ ಇಸ್ರಾಯೇಲರು ಆ ಕೆಲಸಗಳನ್ನೆಲ್ಲಾ ಮಾಡಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ಅವರು ಮಾಡಿದ್ದ ಕೆಲಸವನ್ನು ಮೋಶೆಯು ಪರೀಕ್ಷಿಸಿ ನೋಡಲಾಗಿ ಯೆಹೋವನ ಅಪ್ಪಣೆಯಂತೆಯೇ ಅವರು ಎಲ್ಲವನ್ನು ಮಾಡಿದ್ದರಿಂದ ಮೋಶೆಯು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಪ್ರಥಮ ದಿನದಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ತೆರೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷವನ್ನು ಅದರಲ್ಲಿ ಇಟ್ಟು ಆ ಮಂಜೂಷವನ್ನು ಪರದೆಯಿಂದ ಮರೆಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ಆ ಮೇಲೆ ಮೇಜನ್ನು ಒಳಗೆ ತಂದು ಅದರ ಮೇಲಿಡಬೇಕಾದದ್ದನ್ನು ಸರಿಯಾಗಿ ಇಡಬೇಕು; ದೀಪಸ್ತಂಭವನ್ನು ಒಳಗೆ ತಂದು ಅದರ ಹಣತೆಗಳನ್ನು ಸರಿಯಾಗಿ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷದ ಎದುರಾಗಿ ಚಿನ್ನದ ಧೂಪವೇದಿಯನ್ನು ಇಟ್ಟು ಗುಡಾರದ ಬಾಗಿಲಿನ ಪರದೆಯನ್ನು ಕಟ್ಟಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಿನ ಮುಂದೆ ಸರ್ವಾಂಗಹೋಮ ಯಜ್ಞವೇದಿಯನ್ನು ಇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೂ, ಯಜ್ಞವೇದಿಗೂ ನಡುವೆ ದೊಡ್ಡ ತೊಟ್ಟಿಯೊಂದನ್ನು ಇಟ್ಟು ಅದರಲ್ಲಿ ನೀರನ್ನು ತುಂಬಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ಅಂಗಳದ ಸುತ್ತಲಿನ ಆವರಣವನ್ನು ತೆರೆದು, ಅಂಗಳದ ಬಾಗಿಲಿಗೆ ಪರದೆಯನ್ನು ತೂಗಿಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ನೀನು ಅಭಿಷೇಕತೈಲವನ್ನು ತೆಗೆದುಕೊಂಡು ಗುಡಾರವನ್ನೂ ಅದರಲ್ಲಿರುವುದೆಲ್ಲವನ್ನೂ ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನೂ ಅಭಿಷೇಕಿಸಿ ನನಗಾಗಿ ಪ್ರತಿಷ್ಠಿಸಬೇಕು; ಅಂದಿನಿಂದ ಅದು ಪರಿಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ಯಜ್ಞವೇದಿಯನ್ನೂ ಅದರ ಉಪಕರಣಗಳನ್ನೂ ಅಭಿಷೇಕಿಸಿ ಸರ್ವಾಂಗಹೋಮ ಯಜ್ಞವೇದಿಯನ್ನು ಪ್ರತಿಷ್ಠಿಸಬೇಕು; ಆ ಯಜ್ಞವೇದಿ ಅತ್ಯಂತ ಪರಿಶುದ್ಧವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ನೀನು ತಾಮ್ರದ ಬೋಗುಣಿಯನ್ನೂ ಅದರ ಪೀಠವನ್ನೂ ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“ಅದಲ್ಲದೆ ಆರೋನನನ್ನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳನ್ನೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರಕ್ಕೆ ಬರಮಾಡಿ ");
INSERT INTO kanirv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ಆರೋನನು ನನಗೆ ಯಾಜಕನಾಗುವಂತೆ ಅವನಿಗೆ ಪವಿತ್ರವಾದ ದೀಕ್ಷಾವಸ್ತ್ರಗಳನ್ನು ತೊಡಿಸಿ ಅವನನ್ನು ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ಆ ನಂತರ ನೀನು ಅವನ ಮಕ್ಕಳನ್ನು ಬರಮಾಡಿ ");
INSERT INTO kanirv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ಅವರಿಗೆ ಅಂಗಿಗಳನ್ನು ತೊಡಿಸಿ ಅವರು ನನಗೋಸ್ಕರ ಯಾಜಕರಾಗುವುದಕ್ಕಾಗಿ ನೀನು ಅವರ ತಂದೆಯನ್ನು ಅಭಿಷೇಕಿಸಿದಂತೆಯೇ ಅವರನ್ನೂ ಅಭಿಷೇಕಿಸಬೇಕು. ಈ ಅಭಿಷೇಕದಿಂದ ಯಾಜಕತ್ವವು ಅವರಿಗೂ ಅವರ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತವಾಗಿರುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆ ಎಲ್ಲವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ಎರಡನೆಯ ವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಪ್ರಥಮದಿನದಲ್ಲಿ ಮೋಶೆ ಗುಡಾರವನ್ನು ತೆರೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ಮೋಶೆಯು ಗುಡಾರವನ್ನು ತೆರೆದು ಅದಕ್ಕೆ ಮೆಟ್ಟುವಕಲ್ಲುಗಳನ್ನು ಹಾಕಿ ಚೌಕಟ್ಟುಗಳನ್ನು ನಿಲ್ಲಿಸಿ ಅಗುಳಿಗಳನ್ನು ಕೊಟ್ಟು ಕಂಬಗಳನ್ನು ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ಗುಡಾರದ ಮೇಲೆ ಡೇರೆಯ ಬಟ್ಟೆಯನ್ನು ಹಾಸಿ ಆ ಡೇರೆಗೆ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಹಾಕಿ ಅದನ್ನು ಮರೆಮಾಡಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆ ಅದನ್ನೆಲ್ಲಾ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ಅವನು ಆಜ್ಞಾಶಾಸನಗಳನ್ನು ಮಂಜೂಷದಲ್ಲಿಟ್ಟು ಮಂಜೂಷಕ್ಕೆ ಕೋಲುಗಳನ್ನು ಹಾಕಿ ಕೃಪಾಸನವನ್ನು ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ಮೋಶೆಯು ಮಂಜೂಷವನ್ನು ಗುಡಾರದೊಳಕ್ಕೆ ತಂದು, ಅದರ ಮುಂದೆ ಪರದೆಯನ್ನು ಇರಿಸಿ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷವನ್ನು ಮರೆಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ಮೋಶೆ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಉತ್ತರ ಭಾಗದಲ್ಲಿ ತೆರೆಯ ಹೊರಗಡೆ ಮೇಜನ್ನು ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆ ಮೇಜಿನ ಮೇಲೆ ರೊಟ್ಟಿಗಳನ್ನು ಕ್ರಮವಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ಅವನು ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಮೇಜಿಗೆ ಎದುರಾಗಿ ಗುಡಾರದ ದಕ್ಷಿಣ ಭಾಗದಲ್ಲಿ ದೀಪಸ್ತಂಭವನ್ನು ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆ, ಅದರ ಹಣತೆಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಕ್ರಮವಾಗಿ ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ಮತ್ತು ಅವನು ಚಿನ್ನದ ಧೂಪವೇದಿಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ತೆರೆಯ ಎದುರಿಗೆ ಇರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಹಾಗೆಯೇ, ಅದರ ಮೇಲೆ ಪರಿಮಳ ದ್ರವ್ಯಗಳ ಧೂಪವನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ಅವನು ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಪರದೆಯನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಮುಂದೆ ಸರ್ವಾಂಗಹೋಮ ಯಜ್ಞವೇದಿಯನ್ನು ಇಟ್ಟು ಅದರ ಮೇಲೆ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಮತ್ತು ಧಾನ್ಯಸಮರ್ಪಣೆಯನ್ನೂ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಮೋಶೆ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೂ, ಯಜ್ಞವೇದಿಗೂ ನಡುವೆ ನೀರಿನ ತೊಟ್ಟಿಯನ್ನು ಇರಿಸಿ ತೊಳೆದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಅದರಲ್ಲಿ ನೀರು ತುಂಬಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ಮೋಶೆಯು, ಆರೋನನು ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ಅದರಲ್ಲಿ ಕೈಕಾಲು ತೊಳೆದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಹೋಗುವಾಗಲೂ, ಯಜ್ಞವೇದಿಯ ಹತ್ತಿರ ಬರುವಾಗಲೂ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ಮೋಶೆಯು ಗುಡಾರಕ್ಕೂ ಯಜ್ಞವೇದಿಗೂ ಸುತ್ತಲು ಅಂಗಳದ ಆವರಣವನ್ನು ತೆರೆದು ಅಂಗಳದ ಬಾಗಿಲಿಗೆ ಪರದೆಯನ್ನು ಹಾಕಿದನು. ಈ ಪ್ರಕಾರ ಮೋಶೆ ಆ ಕೆಲಸವನ್ನೆಲ್ಲಾ ಮುಗಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ಆಗ ಮೇಘವು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಮುಚ್ಚಿತು; ಯೆಹೋವನ ತೇಜಸ್ಸು ಗುಡಾರವನ್ನು ತುಂಬಿಕೊಂಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ಮೇಘವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮೇಲೆ ನೆಲೆಗೊಂಡಿದ್ದು ಯೆಹೋವನ ತೇಜಸ್ಸು ಪರಿಶುದ್ಧ ನಿವಾಸದ ತುಂಬಾ ಅವರಿಸಿ ಯೆಹೋವನ ಮಹಿಮೆಯು ಗುಡಾರದೊಳಗೆ ತುಂಬಿಕೊಂಡ್ದಿದರಿಂದಲೂ ಮೋಶೆಯು ಗುಡಾರದ ಒಳಗೆ ಪ್ರವೇಶಿಸಲು ಸಾಧ್ಯವಾಗಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ಆ ಮೇಘವು ಗುಡಾರವನ್ನು ಬಿಟ್ಟು ಮೇಲಕ್ಕೆ ಹೋದಾಗ ಇಸ್ರಾಯೇಲರು ಮುಂದೆ ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ಆ ಮೇಘವು ಮೇಲಕ್ಕೆ ಹೋಗದೇ ಇದ್ದು ಅದು ಹೊರಡುವ ತನಕ ಅವರು ಪ್ರಯಾಣ ಮಾಡದೆ ಇರುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ಇಸ್ರಾಯೇಲರ ಎಲ್ಲಾ ಪ್ರಯಾಣಗಳಲ್ಲಿಯೂ ಅವರ ಕಣ್ಣುಗಳ ಮುಂದೆ ಹಗಲು ಹೊತ್ತಿನಲ್ಲಿ ಯೆಹೋವನ ಮೇಘವು ಗುಡಾರದ ಮೇಲೆಯೂ ಇರುತ್ತಿತ್ತು; ರಾತ್ರಿ ವೇಳೆಯಲ್ಲಿ ಆ ಮೇಘದೊಳಗೆ ಅಗ್ನಿಯು ಇರುತ್ತಿತ್ತು.");
INSERT INTO kanirv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ಯೆಹೋವನು ಮೋಶೆಯನ್ನು ಕರೆದು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗಿಂದ ಅವನ ಸಂಗಡ ಮಾತನಾಡಿ ಹೀಗೆಂದನು, ");
INSERT INTO kanirv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ನಿಮ್ಮಲ್ಲಿ ಯಾವನಾದರೂ ಯೆಹೋವನಿಗೆ ಪಶುವನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಸಮರ್ಪಿಸಬೇಕೆಂದಿದ್ದರೆ ಅವನು ಅದನ್ನು ಹಿಂಡಿನ ದನಗಳಿಂದಾಗಲಿ ಅಥವಾ ಆಡುಕುರಿಗಳ ಹಿಂಡಿನಿಂದ ತೆಗೆದುಕೊಂಡು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“‘ಅವನು ದನವನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸುವುದಾದರೆ ಪೂರ್ಣಾಂಗವಾದ ಗಂಡನ್ನು ತರಬೇಕು. ತನ್ನನ್ನು ಯೆಹೋವನು ಮೆಚ್ಚುವಂತೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಅದನ್ನು ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ಅವನು ಆ ಯಜ್ಞ ಪಶುವಿನ ತಲೆಯ ಮೇಲೆ ಕೈಯಿಡಬೇಕು; ಆಗ ಅದು ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡುವುದಕ್ಕಾಗಿ ಅಂಗೀಕಾರವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“‘ಅವನು ಆ ಹೋರಿಯನ್ನು ಯೆಹೋವನ ಎದುರಿನಲ್ಲಿ ವಧಿಸಿದ ಮೇಲೆ ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರು ಅದರ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಎದುರಾಗಿರುವ ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಎರಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ಅನಂತರ ಅವನು ಆ ಯಜ್ಞಪಶುವಿನ ಚರ್ಮವನ್ನು ಸುಲಿದು ಅದರ ದೇಹವನ್ನು ತುಂಡು ತುಂಡಾಗಿ ಕಡಿಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಬೆಂಕಿಯನ್ನಿಟ್ಟು, ಅದರ ಮೇಲೆ ಕಟ್ಟಿಗೆಯನ್ನು ಕೂಡಿಸಿ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ಆಮೇಲೆ ಯಾಜಕರು ಅಂದರೆ ಆರೋನನ ಮಕ್ಕಳು, ಆ ತುಂಡುಗಳನ್ನು, ತಲೆಯನ್ನು ಮತ್ತು ಕೊಬ್ಬನ್ನು ಅದರ ಮೇಲೆ ಕ್ರಮವಾಗಿ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ಅದರ ಕರುಳುಗಳನ್ನು ಮತ್ತು ಕಾಲುಗಳನ್ನು ನೀರಿನಲ್ಲಿ ತೊಳೆದನಂತರ ಯಾಜಕನು ಅದನ್ನು ಪೂರ್ತಿಯಾಗಿ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವ ಸರ್ವಾಂಗಹೋಮವಾಗುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“‘ಒಬ್ಬನು ಆಡನ್ನಾಗಲಿ ಅಥವಾ ಕುರಿಯನ್ನಾಗಲಿ ಸರ್ವಾಂಗಹೋಮವನ್ನಾಗಿ ಅರ್ಪಿಸಬೇಕೆಂದಿದ್ದರೆ ಅವನು ಪೂರ್ಣಾಂಗವಾದ ಗಂಡನ್ನು ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಯಜ್ಞವೇದಿಯ ಉತ್ತರ ಭಾಗದಲ್ಲಿ ವಧಿಸಬೇಕು. ತರುವಾಯ ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರು ಅದರ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ಅವನು ಆ ಪಶುವಿನ ದೇಹವನ್ನು ತುಂಡು ತುಂಡಾಗಿ ಕಡಿದ ಮೇಲೆ ಯಾಜಕನು ಆ ತುಂಡುಗಳನ್ನು, ತಲೆಯನ್ನು ಮತ್ತು ಕೊಬ್ಬನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲಣ ಬೆಂಕಿಯಲ್ಲಿ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ಕ್ರಮವಾಗಿ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ಅದರ ಕರುಳುಗಳನ್ನು ಹಾಗು ಕಾಲುಗಳನ್ನು ನೀರಿನಲ್ಲಿ ತೊಳೆದನಂತರ ಯಾಜಕನು ಅದನ್ನು ಪೂರ್ತಿಯಾಗಿ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಸುಡಬೇಕು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವ ಸರ್ವಾಂಗಹೋಮವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“‘ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಅರ್ಪಿಸುವಂಥದ್ದು ಪಕ್ಷಿಜಾತಿಯಾಗಿದ್ದರೆ ಅದು ಬೆಳವಕ್ಕಿಯಾಗಲಿ ಅಥವಾ ಪಾರಿವಾಳದ ಮರಿಯಾಗಲಿ ಆಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ಯಾಜಕನು ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಬಳಿಗೆ ತಂದು, ಕುತ್ತಿಗೆ ಮುರಿದು ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮ ಮಾಡಬೇಕು. ಅವನು ಅದರ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಪಕ್ಕದಲ್ಲಿ ಹರಿಯುವಂತೆ ಮಾಡಿ ಹಿಂಗಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ಅದರ ಕರುಳುಗಳನ್ನು ಮತ್ತು ರೆಕ್ಕೆಗಳನ್ನು ತೆಗೆದುಬಿಟ್ಟು ಯಜ್ಞವೇದಿಯ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿರುವ ಬೂದಿಯ ಸ್ಥಳದಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ಅವನು ಆ ಪಕ್ಷಿಯನ್ನು ರೆಕ್ಕೆಗಳ ಮಧ್ಯದಲ್ಲಿ ಇಬ್ಭಾಗವಾಗಿ ಹರಿಯಬೇಕು, ಅವನು ಅದನ್ನು ವಿಭಾಗಿಸಬಾರದು. ಆದರೆ ರೆಕ್ಕೆಗಳನ್ನು ಪೂರಾ ಕಿತ್ತುಹಾಕಬಾರದು. ಅನಂತರ ಯಾಜಕನು ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲಣ ಬೆಂಕಿಯಲ್ಲಿರುವ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವ ಸರ್ವಾಂಗಹೋಮವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“‘ಯಾವನಾದರೂ ಯೆಹೋವನಿಗೆ ಧಾನ್ಯನೈವೇದ್ಯವನ್ನು ಮಾಡಬೇಕೆಂದಿದ್ದರೆ ಅದು ಗೋದಿಹಿಟ್ಟಿನದಾಗಿರಬೇಕು. ಅವನು ಅದರ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಹೊಯ್ದು ಅದರ ಮೇಲೆ ಧೂಪವನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ಅದನ್ನು ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರ ಬಳಿಗೆ ತರಬೇಕು. ಯಾಜಕನು ದೇವರಿಗೆ ನೈವೇದ್ಯವಾದದ್ದನ್ನು ಯೆಹೋವನ ಒಳ್ಳೆಯತನವನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹಿಟ್ಟಿನಲ್ಲಿ ಒಂದು ಹಿಡಿಯನ್ನು ಮತ್ತು ಧೂಪವೆಲ್ಲವನ್ನು ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ಆ ನೈವೇದ್ಯದಲ್ಲಿ ಉಳಿದದ್ದು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ವಂಶದವರಿಗೂ ಆಗಬೇಕು; ಅದು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿತವಾದ ಹೋಮಶೇಷಗಳಲ್ಲಿ ಅತಿಪರಿಶುದ್ಧವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“‘ನೀವು ಒಲೆಯಲ್ಲಿ ಅಡಿಗೆಮಾಡಿದ್ದನ್ನು ನೈವೇದ್ಯವಾಗಿ ಸಮರ್ಪಿಸಬೇಕಾದರೆ, ಅದು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹುಳಿಯಿಲ್ಲದ ಗೋದಿಹಿಟ್ಟಿನ ಹೋಳಿಗೆಗಳು ಅಥವಾ ಎಣ್ಣೆ ಹಾಕಿದ ಹುಳಿಯಿಲ್ಲದ ಕಡುಬುಗಳು ಆಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ನೀವು ಅರ್ಪಿಸುವ ಧಾನ್ಯ ನೈವೇದ್ಯವು ಕಬ್ಬಿಣದ ಹಂಚಿನ ಮೇಲೆ ಸುಟ್ಟದ್ದಾದರೆ ಅದು ಎಣ್ಣೆ ಬೆರಸಿದ ಹುಳಿಯಿಲ್ಲದ ಗೋದಿಹಿಟ್ಟಿನದಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ನೀವು ಅದನ್ನು ಚೂರುಚೂರಾಗಿ ಮುರಿದು, ಅದರ ಮೇಲೆ ಎಣ್ಣೆ ಹೊಯ್ಯಬೇಕು. ಇದು ಧಾನ್ಯನೈವೇದ್ಯವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ನೀವು ಅರ್ಪಿಸುವ ಧಾನ್ಯ ನೈವೇದ್ಯ ಬಾಂಡ್ಲಿಯಲ್ಲಿ ಪಕ್ವಮಾಡಿದ್ದಾದರೆ ಅದು ಎಣ್ಣೆ ಹೊಯ್ದ ಗೋದಿಹಿಟ್ಟಿನದಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ನೀವು ಈ ಪದಾರ್ಥಗಳಿಂದ ಮಾಡಿದ ನೈವೇದ್ಯವನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವಾಗ ಅದನ್ನು ಯಾಜಕನಿಗೆ ಒಪ್ಪಿಸಬೇಕು; ಅವನೇ ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ಯಾಜಕನು ನೈವೇದ್ಯವನ್ನು ಯೆಹೋವನ ಒಳ್ಳೆಯತನವನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಅದರಲ್ಲಿ ಸ್ವಲ್ಪಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ಧಾನ್ಯ ನೈವೇದ್ಯದಲ್ಲಿ ಉಳಿದದ್ದು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ವಂಶದವರಿಗೂ ಕೊಡಬೇಕು; ಅದು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿತವಾದ ಹೋಮಶೇಷವಾದ್ದರಿಂದ ಅತಿಪರಿಶುದ್ಧವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“‘ನೀವು ಯೆಹೋವನಿಗೆ ಧಾನ್ಯ ನೈವೇದ್ಯವಾಗಿ ಸಮರ್ಪಿಸುವ ಯಾವ ಪದಾರ್ಥವನ್ನು ಹುಳಿಹಿಟ್ಟಿನಿಂದ ಮಾಡಬಾರದು. ಯಾವ ಹುಳಿಪದಾರ್ಥವನ್ನಾಗಲಿ ಅಥವಾ ಜೇನುತುಪ್ಪವನ್ನಾಗಲಿ ಯೆಹೋವನಿಗೆ ಹೋಮಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ಅವುಗಳನ್ನು ಪ್ರಥಮಫಲವಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬಹುದೇ ಹೊರತು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕಾಗಿ ಅವುಗಳನ್ನು ಹೋಮಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ಎಲ್ಲಾ ನೈವೇದ್ಯ ಪದಾರ್ಥಗಳಿಗೂ ಉಪ್ಪುಹಾಕಿ ಸಮರ್ಪಿಸಬೇಕು. ಉಪ್ಪು ಯೆಹೋವನ ಸಂಗಡ ನಿಮಗಿರುವ ಒಡಂಬಡಿಕೆಯನ್ನು ಸೂಚಿಸುವುದರಿಂದ ಅದು ಯಾವ ನೈವೇದ್ಯ ಪದಾರ್ಥವಾದರೂ ಉಪ್ಪಿಲ್ಲದೆ ಇರಬಾರದು. ನೀವು ಅರ್ಪಿಸುವ ಎಲ್ಲಾ ಪದಾರ್ಥಗಳಲ್ಲಿಯೂ ಉಪ್ಪನ್ನು ಸೇರಿಸಲೇಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“‘ನೀವು ಯೆಹೋವನಿಗೆ ಧಾನ್ಯ ನೈವೇದ್ಯದ ಪ್ರಥಮಫಲವನ್ನು ಸಮರ್ಪಣೆ ಮಾಡಬೇಕಾದರೆ ಗೋದಿಯ ತಾಜವಾದ ಹಸೀ ತೆನೆಗಳನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಸುಟ್ಟು, ಉಮ್ಮಿಗೆಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ಅದು ಧಾನ್ಯನೈವೇದ್ಯ ವಸ್ತುವಾದ್ದರಿಂದ ನೀವು ಅದರ ಮೇಲೆ ಎಣ್ಣೆ ಹೊಯ್ದು ಧೂಪವಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ಯಾಜಕನು ನೈವೇದ್ಯವನ್ನು ಯೆಹೋವನ ಒಳ್ಳೆಯತನವನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಆ ಉಮ್ಮಿಗೆಯಲ್ಲಿಯೂ ಮತ್ತು ಎಣ್ಣೆಯಲ್ಲಿಯೂ ಸ್ವಲ್ಪಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು ಧೂಪವೆಲ್ಲವನ್ನು ಅದಕ್ಕೆ ಸೇರಿಸಿ ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“‘ಯಾವನಾದರೂ ಸಮಾಧಾನಯಜ್ಞವನ್ನು ಮಾಡಬೇಕಾದರೆ ಅವನು ಸಮರ್ಪಿಸುವ ಪಶುವು ದನವಾಗಿದ್ದ ಪಕ್ಷಕ್ಕೆ ಅದು ಗಂಡಾಗಲಿ ಅಥವಾ ಹೆಣ್ಣಾಗಲಿ ಯೆಹೋವನ ದೃಷ್ಟಿಯಲ್ಲಿ ಪೂರ್ಣಾಂಗವಾಗಿಯೇ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ಅವನು ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತಂದು ಅದರ ತಲೆಯ ಮೇಲೆ ಕೈಯನ್ನಿಟ್ಟು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ವಧಿಸಬೇಕು. ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರು ಅದರ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಎರಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ಆ ಯಜ್ಞಪಶುವಿನ ಅಂಗಾಂಶದ ಕೊಬ್ಬನ್ನು, ಕರುಳುಗಳ ಮೇಲಣ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ಎರಡು ಮೂತ್ರಪಿಂಡಗಳ ಮೇಲೆ, ಸೊಂಟದಲ್ಲಿರುವ ಕೊಬ್ಬನ್ನು, ಕಳಿಜದ ಹತ್ತಿರ ಮೂತ್ರಪಿಂಡದ ತನಕ ಇರುವ ಕೊಬ್ಬನ್ನು ತೆಗೆದು ಅವುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರು ಅದನ್ನು ಯಜ್ಞವೇದಿಯಲ್ಲಿ ಉರಿಯುವ ಕಟ್ಟಿಗೆಯ ಮೇಲಿರುವ ಸರ್ವಾಂಗಹೋಮ ದ್ರವ್ಯದೊಡನೆ ಹೋಮಮಾಡಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಹೋಮ ಆಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“‘ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವಂಥದು ಕುರಿ ಅಥವಾ ಆಡು ಆಗಿರುವ ಪಕ್ಷದಲ್ಲಿ, ಅದು ಗಂಡಾಗಲಿ ಅಥವಾ ಹೆಣ್ಣಾಗಲಿ ಪೂರ್ಣಾಂಗವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ಅದು ಕುರಿಯಾಗಿದ್ದರೆ ತಂದವನು ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ಅವನು ಅದರ ತಲೆಯ ಮೇಲೆ ಕೈಯನ್ನಿಟ್ಟು ದೇವದರ್ಶನದ ಗುಡಾರದ ಎದುರಾಗಿ ಅದನ್ನು ವಧಿಸಬೇಕು. ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರು ಅದರ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಎರಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ಆ ಸಮಾಧಾನಯಜ್ಞದ ಪಶುವಿನ ಕೊಬ್ಬನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ಹೇಗೆಂದರೆ, ಬಾಲದ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಬೆನ್ನೆಲುಬಿನ ಬಳಿಯಿಂದ ತೆಗೆದುಬಿಟ್ಟು ಅದನ್ನು, ಅಂಗಾಂಶದ ಕೊಬ್ಬನ್ನು, ಕರುಳುಗಳ ಮೇಲಣ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನು, ಇವುಗಳ ಮೇಲೆ ಸೊಂಟದಲ್ಲಿರುವ ಕೊಬ್ಬನ್ನು ಮತ್ತು ಕಳಿಜದ ಮೇಲೆ ಮೂತ್ರಪಿಂಡಗಳ ತನಕ ಇರುವ ಕೊಬ್ಬನ್ನು ತೆಗೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ಯಾಜಕನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಅವುಗಳನ್ನು ಹೋಮಮಾಡಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ಅಗ್ನಿಯ ಮೂಲಕವಾಗಿ ಅರ್ಪಿಸಿದ ಆಹಾರವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“‘ಸಮರ್ಪಿಸುವಂಥದ್ದು ಆಡು ಆಗಿದ್ದರೆ ಅರ್ಪಿಸುವವನು ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ಅವನು ಅದರ ತಲೆಯ ಮೇಲೆ ಕೈಯನ್ನಿಟ್ಟು, ದೇವದರ್ಶನ ಗುಡಾರದ ಎದುರಾಗಿ ವಧಿಸಬೇಕು. ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರು ಅದರ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಎರಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ಅದರ ಅಂಗಾಂಶದ ಕೊಬ್ಬನ್ನು ಮತ್ತು ಕರುಳುಗಳ ಮೇಲಣ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನು, ಇವುಗಳ ಮೇಲೆ ಸೊಂಟದಲ್ಲಿರುವ ಕೊಬ್ಬನ್ನು ಮತ್ತು ಕಳಿಜದ ಹತ್ತಿರ ಮೂತ್ರಪಿಂಡಗಳ ತನಕ ಇರುವ ಕೊಬ್ಬನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಅಗ್ನಿಯ ಮೂಲಕ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ಯಾಜಕನು ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಹೋಮದ ರೂಪವಾಗಿ ಅರ್ಪಿಸಿದ ಆಹಾರವಾಗಿರುವುದು. ಯಜ್ಞಪಶುಗಳ ಕೊಬ್ಬೆಲ್ಲವೂ ಯೆಹೋವನದು. ");
INSERT INTO kanirv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ಕೊಬ್ಬನ್ನಾಗಲಿ ಅಥವಾ ರಕ್ತವನ್ನಾಗಲಿ ತಿನ್ನಬಾರದೆಂಬುದು ನಿಮಗೂ ಮತ್ತು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ನೀವು ವಾಸಿಸುವ ಎಲ್ಲಾ ಸ್ಥಳಗಳಲ್ಲಿಯೂ ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿದೆ’” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಇಂತೆಂದನು, ");
INSERT INTO kanirv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ ‘ಯಾರೇ ಆಗಲಿ ತಿಳಿಯದೆ ಯೆಹೋವನು ನಿಷೇಧಿಸಿದ ಕಾರ್ಯಗಳಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ಮಾಡಿ ದೋಷಿಯಾದರೆ ಅವನಿಗೆ ದೋಷಪರಿಹಾರ ಮಾಡಿಕೊಳ್ಳುವ ಕ್ರಮ ಹೀಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ಅಭಿಷಿಕ್ತನಾದ ಯಾಜಕನೇ ದೋಷಿಯಾಗಿ ಜನರೆಲ್ಲರನ್ನು ಅಪರಾಧಕ್ಕೆ ಒಳಪಡಿಸಿದರೆ, ತನ್ನ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಅವನು ಪೂರ್ಣಾಂಗವಾದ ಹೋರಿಯನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ಅವನು ಆ ಹೋರಿಯನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತಂದು, ಅದರ ತಲೆಯ ಮೇಲೆ ಕೈಯನ್ನಿಟ್ಟು, ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅದನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ಅಭಿಷಿಕ್ತ ಯಾಜಕನು ಆ ಹೋರಿಯ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ಯಾಜಕನು ಆ ರಕ್ತದಲ್ಲಿ ತನ್ನ ಬೆರಳನ್ನು ಅದ್ದಿ, ಮಹಾಪವಿತ್ರಸ್ಥಾನದ ಮುಂದಿನ ತೆರೆಯ ಎದುರಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಏಳು ಸಾರಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ಆಗ ಯಾಜಕನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಪರಿಮಳಧೂಪವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಆ ರಕ್ತವನ್ನು ಹಚ್ಚಿ, ಹೋರಿಯ ಉಳಿದ ರಕ್ತವನ್ನೆಲ್ಲಾ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಎದುರಾಗಿ ಸರ್ವಾಂಗಹೋಮಮಾಡುವ ಯಜ್ಞವೇದಿಯ ಬುಡದಲ್ಲಿ ಸುರಿದುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ಆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ಹೋರಿಯ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಅಂದರೆ ಅಂಗಾಂಶದ ಕೊಬ್ಬನ್ನು, ಕರುಳುಗಳ ಮೇಲಣ ಕೊಬ್ಬನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನು, ಇವುಗಳ ಮೇಲೆ ಸೊಂಟದ ಹತ್ತಿರ ಇರುವ ಕೊಬ್ಬನ್ನು ಮತ್ತು ಕಳಿಜದ ಹತ್ತಿರದಿಂದ ಮೂತ್ರಪಿಂಡಗಳ ತನಕ ಇರುವ ಕೊಬ್ಬನ್ನು ತೆಗೆದುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ಅವನು ಅವುಗಳನ್ನು ಸಮಾಧಾನಯಜ್ಞದ ಹೋರಿಯಲ್ಲಿ ಪ್ರತ್ಯೇಕಿಸಿದಂತೆಯೇ ಇದರಲ್ಲಿಯೂ ಪ್ರತ್ಯೇಕಿಸಿ ಸರ್ವಾಂಗಹೋಮದ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ಆ ಹೋರಿಯಲ್ಲಿ ಉಳಿದದ್ದನ್ನೆಲ್ಲಾ ಅಂದರೆ ಅದರ ಚರ್ಮ, ಮಾಂಸ, ತಲೆ, ಕಾಲುಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ಕರುಳುಗಳು, ಕರುಳುಗಳಲ್ಲಿರುವ ಕಲ್ಮಷ ಇವುಗಳನ್ನೆಲ್ಲಾ ಪಾಳೆಯದ ಹೊರಗೆ ಯಜ್ಞವೇದಿಯ ಬೂದಿಯನ್ನು ಹಾಕುವ ಶುದ್ಧವಾದ ಸ್ಥಳಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ, ಕಟ್ಟಿಗೆಯ ಮೇಲಿರಿಸಿ, ಬೆಂಕಿಯಲ್ಲಿ ಸುಡಿಸಿಬಿಡಬೇಕು. ಬೂದಿಯನ್ನು ಹಾಕುವ ಸ್ಥಳದಲ್ಲೇ ಅದನ್ನು ಸುಡಿಸಿಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“‘ಇಸ್ರಾಯೇಲರ ಸಮೂಹವೆಲ್ಲಾ ತಿಳಿಯದೆ ದೋಷಿಗಳಾದರೆ ಅಂದರೆ ಯೆಹೋವನು ನಿಷೇಧಿಸಿದ ಕಾರ್ಯಗಳಲ್ಲಿ ಅವರು ಯಾವುದನ್ನಾದರೂ ಮಾಡಿ ದೋಷಕ್ಕೆ ಗುರಿಯಾದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ಮೊದಲು ತಮಗೂ ಮರೆಯಾಗಿದ್ದ ಆ ದೋಷವು ತಿಳಿದುಬಂದ ನಂತರ ಅದನ್ನು ಪರಿಹರಿಸಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಪೂರ್ಣಾಂಗವಾದ ಹೋರಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಆ ಹೋರಿಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ಸಮೂಹದ ಹಿರಿಯರು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅದರ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನಿಟ್ಟು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅದನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ಅಭಿಷಿಕ್ತ ಯಾಜಕನು ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ದೇವದರ್ಶನ ಗುಡಾರದೊಳಗೆ ತಂದು, ");
INSERT INTO kanirv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ಅದರಲ್ಲಿ ಬೆರಳನ್ನು ಅದ್ದಿ, ತೆರೆಯ ಮುಂದೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅದನ್ನು ಏಳು ಸಾರಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ಆ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಧೂಪವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ ಉಳಿದದ್ದನ್ನೆಲ್ಲಾ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಎದುರಾಗಿರುವ ಯಜ್ಞವೇದಿಯ ಬುಡದಲ್ಲಿ ಸುರಿದುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ಅವನು ಹೋರಿಯ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಪ್ರತ್ಯೇಕಿಸಿ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ಅವನು (ಅಭಿಷಿಕ್ತ ಯಾಜಕ) ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ಹೋರಿಯ ವಿಷಯದಲ್ಲಿ ಹೇಗೆ ಮಾಡಬೇಕೆಂದು ವಿಧಿಸಲ್ಪಟ್ಟಿತೋ, ಇದರ ವಿಷಯದಲ್ಲಿಯೂ ಹಾಗೆಯೇ ಮಾಡಬೇಕು. ಯಾಜಕನು ಅವರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡಿದನಂತರ ಅವರಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ಆ ಮೊದಲನೆಯ ಹೋರಿಯನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಸುಡಿಸಿಬಿಟ್ಟ ಪ್ರಕಾರ ಈ ಹೋರಿಯನ್ನು ಸುಡಿಸಿಬಿಡಬೇಕು. ಇದು ಜನಸಮೂಹದ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞ. ");
INSERT INTO kanirv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“‘ಮುಖ್ಯಾಧಿಕಾರಿ ತನ್ನ ದೇವರಾಗಿರುವ ಯೆಹೋವನು ನಿಷೇಧಿಸಿದ ಕಾರ್ಯಗಳಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ತಿಳಿಯದೆ ಮಾಡಿ ದೋಷಿಯಾದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ತನ್ನ ತಪ್ಪು ತನಗೆ ತಿಳಿದುಬಂದಾಗ ಅವನು ಪೂರ್ಣಾಂಗವಾದ ಹೋತವನ್ನು ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ಅವನು ಆ ಹೋತದ ತಲೆಯ ಮೇಲೆ ಕೈಯನ್ನಿಟ್ಟು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸರ್ವಾಂಗಹೋಮದ ಪಶುಗಳನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲೇ ಅದನ್ನು ವಧಿಸಬೇಕು. ಅದು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞ. ");
INSERT INTO kanirv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ಯಾಜಕನು ಆ ಪಶುರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಬೆರೆಳಿನಿಂದ ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ, ಉಳಿದ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಬುಡದಲ್ಲಿ ಸುರಿದುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ಸಮಾಧಾನಯಜ್ಞದ ಪಶುವಿನ ಕೊಬ್ಬನ್ನು ಅವನು ಹೋಮಮಾಡುವ ಪ್ರಕಾರವೇ ಇದರ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನು ಹೋಮಮಾಡಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡುವುದರಿಂದ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“‘ನಿಮ್ಮ ದೇಶದ ಜನರಲ್ಲಿ ಬೇರೆ ಯಾವನಾದರೂ ಯೆಹೋವನು ನಿಷೇಧಿಸಿದ ಕಾರ್ಯಗಳಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ತಿಳಿಯದೆ ಮಾಡಿ ದೋಷಿಯಾದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ತನ್ನ ತಪ್ಪು ತನಗೆ ತಿಳಿದುಬಂದಾಗ ಆ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಪೂರ್ಣಾಂಗವಾದ ಹೆಣ್ಣು ಮೇಕೆಯನ್ನು ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ಅವನು ಅದರ ತಲೆಯ ಮೇಲೆ ಕೈಯನ್ನಿಟ್ಟನಂತರ ಸರ್ವಾಂಗಹೋಮದ ಪಶುಗಳನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲೇ ಅದನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ಯಾಜಕನು ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಬೆರಳಿನಿಂದ ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ, ಉಳಿದ ರಕ್ತವನ್ನೆಲ್ಲಾ ಯಜ್ಞವೇದಿಯ ಬುಡದಲ್ಲಿ ಸುರಿದುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ಸಮಾಧಾನ ಯಜ್ಞಪಶುಗಳ ಕೊಬ್ಬನ್ನು ಪ್ರತ್ಯೇಕಿಸುವ ಪ್ರಕಾರ ಯಾಜಕನು ಇದರ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕೆ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡುವುದರಿಂದ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“‘ಅವನು ತನ್ನ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ತರುವುದು ಕುರಿಯಾದರೆ ಅದು ಪೂರ್ಣಾಂಗವಾದ ಹೆಣ್ಣಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ಅವನು ಅದರ ತಲೆಯ ಮೇಲೆ ಕೈಯನ್ನಿಟ್ಟನಂತರ ಸರ್ವಾಂಗಹೋಮದ ಪಶುಗಳನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲೇ ಅದನ್ನು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ವಧಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ಯಾಜಕನು ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಬೆರಳಿನಿಂದ ತೆಗೆದುಕೊಂಡು, ಯಜ್ಞವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ, ಉಳಿದ ರಕ್ತವನ್ನೆಲ್ಲಾ ಯಜ್ಞವೇದಿಯ ಬುಡದಲ್ಲಿ ಸುರಿದುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ಸಮಾಧಾನ ಯಜ್ಞಪಶುಗಳ ಕೊಬ್ಬನ್ನು ಪ್ರತ್ಯೇಕಿಸುವ ಪ್ರಕಾರ ಯಾಜಕನು ಇದರ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ, ಯಜ್ಞವೇದಿಯಲ್ಲಿ ಉರಿಯುವ ಹೋಮ ದ್ರವ್ಯಗಳ ಮೇಲೆ ಯೆಹೋವನಿಗೆ ಹೋಮಮಾಡಬೇಕು. ಅವನ ತಪ್ಪಿನ ನಿಮಿತ್ತ ಯಾಜಕನು ಹೀಗೆ ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡುವುದರಿಂದ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“‘ನ್ಯಾಯಾಧಿಕಾರಿಯು ತಿಳಿಸಬೇಕೆಂದು ಆಣೆ ಇಟ್ಟರೂ, ಯಾವನಾದರೂ ತಾನು ಕಂಡು ಕೇಳಿದ್ದನ್ನು ತಿಳಿಸದೆಹೋದರೆ ಅವನು ಪಾಪಕ್ಕೆ ಗುರಿಯಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ಯಾವನಿಗಾದರೂ ಅಶುದ್ಧವಾದ ಕಾಡುಮೃಗ, ಪಶು ಮತ್ತು ಜಂತು ಇವುಗಳ ಹೆಣವಾಗಲಿ ಅಥವಾ ಬೇರೆ ಯಾವ ಅಶುದ್ಧವಸ್ತುವಾಗಲಿ ತಗಲಿದರೆ, ದೇವರು ಅದನ್ನು ಅಶುದ್ಧ ಎಂದು ಪರಿಗಣಿಸುವುದರಿಂದ ಅವನಿಗೆ ತಿಳಿಯದೆ ಹೋದರೂ ಅವನು ಅಶುದ್ಧನೂ ಮತ್ತು ದೋಷಿಯೂ ಆಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ಮನುಷ್ಯದೇಹದಿಂದ ಉಂಟಾದ ಯಾವುದಾದರೂ ಒಂದು ಅಶುದ್ಧವಸ್ತು ತಗಲಿದ್ದು ಅವನಿಗೆ ತಿಳಿಯದೆ ಹೋದರೂ ಅದು ಅವನಿಗೆ ತಿಳಿದುಬಂದಾಗ ಅವನು ದೋಷಿಯಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ಯಾವನಾದರೂ ಆಲೋಚಿಸದೆ ಮೇಲಿಗಾಗಲಿ ಅಥವಾ ಕೇಡಿಗಾಗಲಿ ಯಾವುದಾದರೂ ಆಣೆಯಿಟ್ಟುಕೊಂಡರೆ, ಅದು ಅವನಿಗೆ ತಿಳಿಯದೆ ಹೋದರೂ ತಿಳಿದುಬಂದಾಗ ಅವನು ಇದರಿಂದಲೂ ದೋಷಿಯಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ಅವನು ಈ ವಿಷಯಗಳಲ್ಲಿ ಯಾವುದಾದರೂ ಒಂದರಲ್ಲಿ ದೋಷಿಯಾದಾಗ ತಾನು ಮಾಡಿದ ತಪ್ಪನ್ನು ಒಪ್ಪಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ಅವನು ದೋಷದ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಹೆಣ್ಣು ಕುರಿಯನ್ನಾಗಲಿ ಅಥವಾ ಹೆಣ್ಣು ಮೇಕೆಯನ್ನಾಗಲಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“‘ಕುರಿಯನ್ನು ಕೊಡುವುದಕ್ಕೆ ಅವನಿಗೆ ಗತಿಯಿಲ್ಲದ ಪಕ್ಷದಲ್ಲಿ ದೋಷದ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತೆಗೆದುಕೊಂಡು ಬಂದು, ಒಂದನ್ನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಮತ್ತೊಂದನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ಅವನು ಅವುಗಳನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತಂದಾಗ ಯಾಜಕನು ಮೊದಲು ದೋಷಪರಿಹಾರಾರ್ಥವಾದದ್ದನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಅವನು ಅದರ ಕುತ್ತಿಗೆ ಮುರಿಯಬೇಕು; ಆದರೆ ತಲೆಯನ್ನು ಪೂರ್ಣವಾಗಿ ತೆಗೆದುಬಿಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ಆಗ ಅವನು ದೋಷಪರಿಹಾರಾರ್ಥವಾದ ಆ ಪಕ್ಷಿಯ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಯಜ್ಞವೇದಿಯ ಪಕ್ಕಕ್ಕೆ ಚಿಮುಕಿಸಿ ಉಳಿದ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಬುಡದಲ್ಲಿ ಸುರಿಯಬೇಕು. ಅದು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞ. ");
INSERT INTO kanirv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ಅವನು ಎರಡನೆಯ ಪಕ್ಷಿಯನ್ನು ನಿಯಮಗಳಿಗೆ ಅನುಸಾರವಾಗಿ ಅದೇ ರೀತಿಯಲ್ಲಿ ಸರ್ವಾಂಗಹೋಮ ಮಾಡಬೇಕು. ಅವನ ತಪ್ಪಿನ ನಿಮಿತ್ತ ಯಾಜಕನು ಹೀಗೆ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದಾಗ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“‘ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ಕೊಡುವುದಕ್ಕೂ ಗತಿಯಿಲ್ಲದೆ ಹೋದರೆ, ಅವನು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಮೂರು ಸೇರು ಗೋದಿಹಿಟ್ಟನ್ನು ತರಬೇಕು. ಆ ಹೋಮದ್ರವ್ಯವು ದೋಷಪರಿಹಾರಾರ್ಥವಾಗಿ ಇರುವುದರಿಂದ ಅದರ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಹೊಯ್ಯಬಾರದು ಅಥವಾ ಧೂಪವನ್ನು ಇಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ಅವನು ಯಾಜಕನ ಬಳಿಗೆ ಅದನ್ನು ತಂದನಂತರ ಅದು ದೈವಾರ್ಪಿತವೆಂದು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಯಾಜಕನು ಅದರಲ್ಲಿ ಒಂದು ಹಿಡಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಿದ ಹೋಮದ್ರವ್ಯಗಳ ಮೇಲೆ ಯಜ್ಞವೇದಿಯಲ್ಲಿ ಹೋಮಮಾಡಬೇಕು; ಅದು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞ. ");
INSERT INTO kanirv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ಮೇಲೆ ಕಂಡ ವಿಷಯಗಳಲ್ಲಿ ಯಾವ ವಿಧವಾಗಿ ಅವನು ದೋಷಿಯಾದರೂ, ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ಹೀಗೆ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದನಂತರ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ಧಾನ್ಯನೈವೇದ್ಯ ದ್ರವ್ಯದಲ್ಲಿ ಉಳಿದದ್ದು ಹೇಗೆ ಯಾಜಕನಿಗೆ ಸಲ್ಲುತ್ತದೋ ಇದರಲ್ಲಿಯೂ ಉಳಿದದ್ದು ಯಾಜಕನಿಗೆ ಸಲ್ಲಬೇಕು.’” ");
INSERT INTO kanirv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ಯಾವನಾದರೂ ಯೆಹೋವನಿಗೆ ಸಲ್ಲಿಸಬೇಕಾದ ದೇವರ ವಸ್ತುಗಳನ್ನು ಸಮರ್ಪಿಸುವುದರಲ್ಲಿ ಅಜಾಗ್ರತೆಯಿಂದ ದ್ರೋಹಮಾಡಿ ದೋಷಕ್ಕೆ ಒಳಗಾದರೆ ಅವನು ಆ ಅಪರಾಧದ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಪೂರ್ಣಾಂಗವಾದ ಟಗರನ್ನು ಆಡುಕುರಿಗಳ ಹಿಂಡಿನಿಂದ ತೆಗೆದುಕೊಂಡು ಬಂದು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು ಅಥವಾ ದೇವರ ಸೇವೆಗೆ ನೇಮಕವಾದ ಎರಡು ಬೆಳ್ಳಿ ನಾಣ್ಯ ಅಥವಾ ಹೆಚ್ಚು ಬೆಲೆ ಬಾಳುವ ಟಗರನ್ನು ಹಿಂಡಿನಿಂದ ತಂದು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ಅವನು ತಾನು ಅನ್ಯಾಯವಾಗಿ ಇಟ್ಟುಕೊಂಡಿರುವ ದೇವರ ಪವಿತ್ರ ವಸ್ತುಗಳನ್ನು ಮಾತ್ರವಲ್ಲದೆ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಯಾಜಕನಿಗೆ ತಂದುಕೊಡಬೇಕು. ಅವನು ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ತಂದ ಟಗರಿನಿಂದ ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡಿದಾಗ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ಯಾವನಾದರೂ ಯೆಹೋವನು ನಿಷೇಧಿಸಿದ ಕಾರ್ಯಗಳಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ಮಾಡಿ ದೋಷಕ್ಕೆ ಒಳಗಾದರೆ, ಅದು ಅವನಿಗೆ ತಿಳಿಯದೆ ಹೋದರೂ ಅವನು ಅದರಿಂದ ಅಪರಾಧಿಯಾಗಿ ತನ್ನ ಪಾಪಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ಅವನು ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಹಿಂಡಿನಿಂದ ಯೋಗ್ಯವಾಗಿ ತೋರುವ ಪೂರ್ಣಾಂಗವಾದ ಟಗರನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ಅವನು ತಿಳಿಯದೆ ಮಾಡಿದ ತಪ್ಪನ್ನು ಪರಿಹರಿಸುವುದಕ್ಕಾಗಿ ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡಬೇಕು; ಆಗ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ಅವನು ಅಪರಾಧಿಯಾದುದರಿಂದ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಈ ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞವನ್ನು ಮಾಡಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ಯಾವನಾದರೂ ಪಾಪಮಾಡಿ, ಯೆಹೋವನಿಗೆ ವಿರುದ್ಧವಾಗಿ, ಮತ್ತೊಬ್ಬನಿಂದ ತನ್ನ ವಶಕ್ಕೆ ಕೊಡಲ್ಪಟ್ಟ ವಸ್ತುವಿನ ವಿಷಯದಲ್ಲಾಗಲಿ ಅಥವಾ ತನ್ನ ಬಳಿಯಲ್ಲಿ ಇಡಲ್ಪಟ್ಟ ಅಡವಿಟ್ಟ ವಸ್ತುಗಳ ವಿಷಯದಲ್ಲಾಗಲಿ ಸುಳ್ಳಾಡುವುದರಿಂದ, ಮತ್ತೊಬ್ಬನನ್ನು ಮೋಸಗೊಳಿಸಿದ್ದರಿಂದ, ");
INSERT INTO kanirv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ಮತ್ತೊಬ್ಬನು ಕಳೆದುಕೊಂಡದ್ದನ್ನು ತಾನು ಕಂಡು ಸುಳ್ಳಾಣೆಯಿಟ್ಟದ್ದರಿಂದ, ಇವುಗಳಲ್ಲಿ ಯಾವ ವಿಷಯದಲ್ಲಾದರೂ ಒಬ್ಬನು ಪಾಪಮಾಡಿದರೆ ಯೆಹೋವನಿಗೆ ದ್ರೋಹಿಯಾಗಿ ದೋಷಕ್ಕೆ ಒಳಗಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ಅವನು ಪಾಪಮಾಡಿ ಅಪರಾಧಿಯಾಗಿರುವುದರಿಂದ ಅವನು ತಾನು ಕದ್ದದ್ದನ್ನು, ಮೋಸದಿಂದ ಪಡೆದದ್ದನ್ನು ತನ್ನ ವಶಕ್ಕೆ ತೆಗೆದುಕೊಂಡದ್ದನ್ನು, ತಾನು ಕಂಡುಕೊಂಡದ್ದನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ಬೇರೆ ಯಾವುದರ ವಿಷಯದಲ್ಲಿ ಅವನು ಸುಳ್ಳಾಣೆಯಿಟ್ಟನೋ ಅದನ್ನು ಪೂರ್ತಿಯಾಗಿ ತಂದುಕೊಡಬೇಕಲ್ಲದೆ, ಐದನೆಯ ಒಂದು ಪಾಲನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಡಬೇಕು. ಅವನು ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞವನ್ನು ಮಾಡುವ ದಿನದಲ್ಲೇ ಅದನ್ನು ನ್ಯಾಯವಾದ ಅದರ ಒಡೆಯನಿಗೆ ಹಿಂದಕ್ಕೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ಅವನು ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ನಿನಗೆ ಸರಿಯೆಂದು ತೋರುವ ಪೂರ್ಣಾಂಗವಾದ ಟಗರನ್ನು ಹಿಂಡಿನಿಂದ ತಂದು ಅದನ್ನು ಯೆಹೋವನಿಗೆಂದು ಯಾಜಕನಿಗೆ ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದಾಗ ಅವನು ಯಾವ ವಿಷಯದಲ್ಲಿ ಅಪರಾಧಕ್ಕೆ ಒಳಗಾಗಿದ್ದನೋ ಆ ವಿಷಯದಲ್ಲಿ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ಅನಂತರ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“ನೀನು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ವಂಶದವರಿಗೂ ಮುಂದಿನ ಸಂಗತಿಗಳನ್ನು ಆಜ್ಞಾಪಿಸು, ‘ಇವು ಸರ್ವಾಂಗಹೋಮ ವಿಷಯವಾದ ನಿಯಮಗಳು: ಸರ್ವಾಂಗಹೋಮದ್ರವ್ಯವು ರಾತ್ರಿಯೆಲ್ಲಾ ಮತ್ತು ಮರುದಿನದ ಬೆಳಗಿನ ವರೆಗೂ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಉರಿಯುತ್ತಾ ಇರಬೇಕು. ಅದು ನಂದಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ಯಾಜಕನು ನಾರಿನ ನಿಲುವಂಗಿಯನ್ನು ಧರಿಸಿಕೊಂಡು, ಮಾನರಕ್ಷಕವಾದ ನಾರಿನ ಒಳಉಡುಪನ್ನು ಹಾಕಿಕೊಂಡು, ಯಜ್ಞವೇದಿಯ ಮೇಲಣ ಸರ್ವಾಂಗಹೋಮದ್ರವ್ಯದ ಬೂದಿಯನ್ನು ಎತ್ತಿ ಯಜ್ಞವೇದಿಯ ಬಳಿಯಲ್ಲಿ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ಅನಂತರ ಆ ವಸ್ತ್ರಗಳನ್ನು ತೆಗೆದಿಟ್ಟು, ಬೇರೆ ವಸ್ತ್ರಗಳನ್ನು ಹಾಕಿಕೊಂಡು, ಆ ಬೂದಿಯನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಶುದ್ಧವಾದ ಒಂದು ಸ್ಥಳಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ಯಜ್ಞವೇದಿಯ ಮೇಲಣ ಬೆಂಕಿ ಸರ್ವಾಂಗಹೋಮದ್ರವ್ಯದಿಂದ ಉರಿಯುತ್ತಲೇ ಇರಬೇಕು; ಅದು ಆರಿಹೋಗಬಾರದು. ಪ್ರತಿದಿನವೂ ಹೊತ್ತಾರೆಯಲ್ಲಿ ಯಾಜಕನು ಕಟ್ಟಿಗೆಯನ್ನು ತಂದುಹಾಕಿ, ಬೆಂಕಿ ಉರಿಸಿ, ಅದರ ಮೇಲೆ ಹೋಮದ್ರವ್ಯವನ್ನು ಕ್ರಮಪಡಿಸಿ, ಸಮಾಧಾನಯಜ್ಞಪಶುಗಳ ಕೊಬ್ಬನ್ನು ಅದರ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ಬೆಂಕಿಯು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಯಾವಾಗಲೂ ಉರಿಯುತ್ತಿರಬೇಕು; ಆರಿಹೋಗಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“‘ಧಾನ್ಯನೈವೇದ್ಯ ವಿಷಯವಾದ ನಿಯಮಗಳು: ಆರೋನನ ವಂಶದವರು ನೈವೇದ್ಯದ್ರವ್ಯವನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಯಜ್ಞವೇದಿಯ ಎದುರಾಗಿಯೇ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ಅವರಲ್ಲಿ ಒಬ್ಬನು ನೈವೇದ್ಯವಾದದ್ದನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಎಣ್ಣೆ ಹೊಯ್ದ ಹಿಟ್ಟಿನಲ್ಲಿ ಒಂದು ಹಿಡಿಯನ್ನು ಮತ್ತು ಅದರ ಮೇಲಿರುವ ಧೂಪವೆಲ್ಲವನ್ನು ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಿ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ಉಳಿದದ್ದನ್ನು ಆರೋನನೂ ಮತ್ತು ಅವನ ವಂಶದವರೂ ತಿನ್ನಬಹುದು; ಅವರು ಅದರಿಂದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಿಸಿಕೊಂಡು ಪವಿತ್ರಸ್ಥಳದೊಳಗೆ ಅಂದರೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಅಂಗಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ಅದಕ್ಕೆ ಹುಳಿಹಿಟ್ಟು ಸೇರಿಸಿ ಸುಡಬಾರದು. ನನಗೆ ಹೋಮರೂಪವಾಗಿ ಸಮರ್ಪಿಸಿದ ದ್ರವ್ಯಗಳಲ್ಲಿ ಅದನ್ನು ಅವರ ಪಾಲಿಗೆ ಬಿಟ್ಟಿದ್ದೇನೆ. ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ್ರವ್ಯದಂತೆಯೂ ಮತ್ತು ಪ್ರಾಯಶ್ಚಿತ್ತ ಯಜ್ಞದ್ರವ್ಯದಂತೆಯೂ ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ಆರೋನನ ವಂಶದವರಾದ ಗಂಡಸರೆಲ್ಲರೂ ಅದನ್ನು ತಿನ್ನಬಹುದು. ಯೆಹೋವನಿಗೆ ಹೋಮವಾಗಿ ಅರ್ಪಿತವಾದ ದ್ರವ್ಯಗಳಲ್ಲಿ ಅದು ನಿಮಗೂ ಮತ್ತು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಸಲ್ಲತಕ್ಕದ್ದೆಂಬುದು ಶಾಶ್ವತನಿಯಮ. ಆ ದ್ರವ್ಯಗಳಿಗೆ ತಗಲಿದ್ದೆಲ್ಲಾ ಪರಿಶುದ್ಧವಾಗುವುದು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಪುನಃ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ಆರೋನನಿಗೆ ಅಭಿಷೇಕವಾದ ದಿನ ಮೊದಲುಗೊಂಡು ಅವನೂ ಮತ್ತು ಅವನ ವಂಶದವರೂ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಧಾನ್ಯ ನೈವೇದ್ಯ ಕ್ರಮ ಹೇಗೆಂದರೆ, ಅವರು ನಿತ್ಯವೂ ಮೂರು ಸೇರು ಗೋದಿಹಿಟ್ಟನ್ನು, ಹೊತ್ತಾರೆ ಅರ್ಧವನ್ನು ಹಾಗೂ ಸಾಯಂಕಾಲ ಅರ್ಧವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ಕಬ್ಬಿಣದ ಹಂಚಿನ ಮೇಲೆ ಎಣ್ಣೆ ಸವರಿ ಅದನ್ನು ಸುಡಬೇಕು. ಅದನ್ನು ತರುವಾಗ ಅದು ಎಣ್ಣೆಯಿಂದ ನೆನಸಿದ್ದಾಗಿರಬೇಕು. ಅದನ್ನು ಭಾಗಭಾಗವಾಗಿ ಮಾಡಿ ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯುಳ್ಳ ನೈವೇದ್ಯವನ್ನಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ಆರೋನನ ಸಂತತಿಯವರಲ್ಲಿ ಯಾವನು ಅವನ ತರುವಾಯ ಅಭಿಷಿಕ್ತನಾದ ಯಾಜಕನ ಪಟ್ಟಕ್ಕೆ ಬರುವನೋ ಅವನೇ ಅದನ್ನು ಸಮರ್ಪಿಸಬೇಕು; ಇದು ಶಾಶ್ವತನಿಯಮ. ಅದನ್ನು ಯೆಹೋವನಿಗೆ ಸಂಪೂರ್ಣವಾಗಿ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ಯಾಜಕರು ತಮಗೋಸ್ಕರ ಸಮರ್ಪಿಸುವ ನೈವೇದ್ಯದ್ರವ್ಯಗಳನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ಹೋಮಮಾಡಬೇಕು; ಅದನ್ನು ತಿನ್ನಲೇಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಪುನಃ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“ನೀನು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ವಂಶದವರಿಗೂ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ನಿಯಮಗಳು: ಸರ್ವಾಂಗಹೋಮದ ಪಶುವನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲೇ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಪಶುವನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ವಧಿಸಬೇಕು. ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ಅದನ್ನು ಸಮರ್ಪಿಸುವ ಯಾಜಕನು ಅದರ ಮಾಂಸವನ್ನು ಊಟಮಾಡಬೇಕು. ಪವಿತ್ರಸ್ಥಳದೊಳಗೆ ಅಂದರೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಅಂಗಳದಲ್ಲಿ ಅದನ್ನು ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ಆ ಪಶುವಿನ ಮಾಂಸಕ್ಕೆ ಸೋಂಕಿದ್ದೆಲ್ಲವೂ ಪರಿಶುದ್ಧವಾಗುವುದು. ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವಾದರೂ ಬಟ್ಟೆಯ ಮೇಲೆ ಬಿದ್ದರೆ ಆ ಬಟ್ಟೆಯನ್ನು ಪವಿತ್ರಸ್ಥಳದೊಳಗೆ ಒಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ಅದನ್ನು ಬೇಯಿಸಿದ ಮಣ್ಣಿನ ಪಾತ್ರೆಯನ್ನು ಒಡೆದುಬಿಡಬೇಕು. ತಾಮ್ರದ ಪಾತ್ರೆಯಲ್ಲಿ ಬೇಯಿಸಿದ್ದಾದರೆ ಆ ಪಾತ್ರೆಯನ್ನು ಉಜ್ಜಿ ನೀರಿನಿಂದ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ಯಾಜಕರಲ್ಲಿ ಗಂಡಸರೆಲ್ಲರೂ ಅದನ್ನು ತಿನ್ನಬಹುದು; ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ಆದರೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಪಶುಗಳಲ್ಲಿ ಯಾವ ಪಶುವಿನ ರಕ್ತವನ್ನು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ, ಪವಿತ್ರ ಸ್ಥಾನದೊಳಗೆ ತಂದಿರುವರೋ ಅದರ ಮಾಂಸವನ್ನು ತಿನ್ನಲೇಬಾರದು. ಬೆಂಕಿಯಲ್ಲಿ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“‘ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞದ ನಿಯಮಗಳು: ಆ ಯಜ್ಞವು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ಸರ್ವಾಂಗಹೋಮಪಶುವನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲೇ ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞದ ಪಶುವನ್ನು ವಧಿಸಬೇಕು. ಯಾಜಕನು ಅದರ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಎರಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ಅವನು ಅದರ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಅಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ಬಾಲದ ಕೊಬ್ಬನ್ನು, ಅಂಗಾಂಶದ ಕೊಬ್ಬನ್ನು, ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನು, ಇವುಗಳ ಮೇಲೆ ಸೊಂಟದಲ್ಲಿರುವ ಕೊಬ್ಬನ್ನು, ಕಳಿಜದ ಮೇಲಿನಿಂದ ಮೂತ್ರಪಿಂಡಗಳ ತನಕ ಇರುವ ಕೊಬ್ಬನ್ನು ತೆಗೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ಯಾಜಕನು ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಯೆಹೋವನಿಗೆ ಹೋಮಮಾಡಬೇಕು. ಅದು ಪ್ರಾಯಶ್ಚಿತ್ತ ಯಜ್ಞವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ಹೋಮಶೇಷವನ್ನು ಯಾಜಕರಲ್ಲಿ ಗಂಡಸರೆಲ್ಲರೂ ತಿನ್ನಬಹುದು; ಅದು ಮಹಾಪರಿಶುದ್ಧವಾದುದರಿಂದ ಪವಿತ್ರಸ್ಥಳದೊಳಗೆ ಅದನ್ನು ತಿನ್ನಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞದ ಹೋಮಶೇಷದ ವಿಷಯದಲ್ಲಿಯೂ ಮತ್ತು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ಹೋಮಶೇಷದ ವಿಷಯದಲ್ಲಿಯೂ ಒಂದೇ ನಿಯಮಯುಂಟು; ಹೇಗೆಂದರೆ ಆ ಹೋಮಶೇಷವು ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿಸುವ ಯಾಜಕನಿಗೆ ಸಲ್ಲತಕ್ಕದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ಯಾರಾದರೂ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಪಶುವನ್ನು ತಂದಾಗ ಅದರ ಚರ್ಮವು ಆ ಪಶುವನ್ನು ಸಮರ್ಪಿಸುವ ಯಾಜಕನದ್ದಾಗಿಯೇ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ಒಲೆಯಲ್ಲಾಗಲಿ, ಕಬ್ಬಿಣದ ಹಂಚಿನಲ್ಲಾಗಲಿ ಅಥವಾ ಬಾಂಡ್ಲಿಯಲ್ಲಾಗಲಿ ಬೇಯಿಸಿದ ನೈವೇದ್ಯಪದಾರ್ಥವೆಲ್ಲಾ ಸಮರ್ಪಿಸುವ ಯಾಜಕನಿಗೆ ಆಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ಆದರೆ ಎಣ್ಣೆ ಹೊಯ್ದ ಹಿಟ್ಟನ್ನಾಗಲಿ ಅಥವಾ ಬರೀ ಹಿಟ್ಟನ್ನಾಗಲಿ ಯಾರಾದರೂ ನೈವೇದ್ಯಕ್ಕಾಗಿ ತಂದಾಗ ಅದನ್ನು ಆರೋನನ ವಂಶದವರೆಲ್ಲರೂ ಸಮಾನವಾಗಿ ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“‘ಜನರು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸುವ ಸಮಾಧಾನಯಜ್ಞದ ನಿಯಮಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ಯಾರಾದರೂ ಕೃತಜ್ಞತೆಯನ್ನು ತೋರಿಸುವುದಕ್ಕಾಗಿ ಸಮಾಧಾನಯಜ್ಞವನ್ನು ಯೆಹೋವನಿಗೆ ಮಾಡುವುದಾದರೆ ಅದರೊಡನೆ ಎಣ್ಣೆ ಮಿಶ್ರವಾದ ಹುಳಿಯಿಲ್ಲದ ಕಡುಬುಗಳನ್ನು ಮತ್ತು ಎಣ್ಣೆಯಿಂದ ಪೂರಾ ನೆನಸಿದ ಗೋದಿ ಹಿಟ್ಟಿನ ಹೋಳಿಗೆಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ಕೃತಜ್ಞತೆಯನ್ನು ತೋರಿಸುವುದಕ್ಕಾಗಿ ಸಮಾಧಾನಯಜ್ಞದಲ್ಲಿ ಒಪ್ಪಿಸುವ ಪಶುವಿನೊಡನೆ ಹುಳಿರೊಟ್ಟಿಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ಸಮರ್ಪಿಸಿದ ಪ್ರತಿಯೊಂದು ವಿಧವಾದ ಯಜ್ಞದ ಪದಾರ್ಥಗಳಲ್ಲಿಯೂ ಒಂದೊಂದನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ಅವು ಯಜ್ಞವೇದಿಗೆ ಯಜ್ಞಪಶುವಿನ ರಕ್ತವನ್ನು ಎರಚಿದ ಯಾಜಕನಿಗೆ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ಕೃತಜ್ಞತೆಯ ಯಜ್ಞಪಶುವಿನ ಮಾಂಸವನ್ನು ಯಜ್ಞವು ನಡೆದ ದಿನದಲ್ಲೇ ಭೋಜನ ಮಾಡಬೇಕು; ಮರುದಿನದ ವರೆಗೆ ಸ್ವಲ್ಪವನ್ನಾದರೂ ಉಳಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“‘ಯಾರಾದರೂ ಹರಕೆಯನ್ನು ಸಲ್ಲಿಸುವುದಕ್ಕಾಗಲಿ, ಸ್ವ ಇಚ್ಛೆಯಿಂದಾಗಲಿ ಅಂತಹ ಯಜ್ಞವನ್ನು ಮಾಡಿಸಿದರೆ ಅದನ್ನು ಸಮರ್ಪಿಸಿದ ದಿನದಲ್ಲೇ ಅದರ ಮಾಂಸವನ್ನು ಊಟಮಾಡಬೇಕು; ಆದರೆ ಉಳಿದದ್ದನ್ನು ಮರುದಿನದಲ್ಲಿ ತಿನ್ನಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ಮೂರನೆಯ ದಿನದ ವರೆಗೆ ಉಳಿದದ್ದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ಆ ಯಜ್ಞಪಶುವಿನ ಮಾಂಸದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನಾದರೂ ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಊಟಮಾಡಿದರೆ ಆ ಯಜ್ಞವು ಸಮರ್ಪಕವಾದದ್ದಲ್ಲ; ಅರ್ಪಿಸಿದವನಿಗೆ ಅದರಿಂದ ಫಲವೇನೂ ದೊರೆಯುವುದಿಲ್ಲ. ಅದು ಅಸಹ್ಯವಾದುದರಿಂದ ಅದನ್ನು ತಿಂದವನು ಆ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","ಅಶುದ್ಧವಾದ ವಸ್ತುವಿಗೆ ಸೋಂಕಿದ ಮಾಂಸವನ್ನು ತಿನ್ನದೆ ಬೆಂಕಿಯಲ್ಲಿ ಸುಟ್ಟುಬಿಡಬೇಕು. ಶುದ್ಧರಾಗಿರುವವರೆಲ್ಲರೂ ಯಜ್ಞಪಶುವಿನ ಮಾಂಸವನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ಯಾವನಾದರೂ ಅಶುದ್ಧನಾಗಿದ್ದು, ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿತವಾದ ಸಮಾಧಾನ ಯಜ್ಞಪಶುವಿನ ಮಾಂಸವನ್ನು ತಿಂದರೆ ಅವನು ತನ್ನ ಕುಲದಿಂದ ಬಹಿಷ್ಕರಿಸಲ್ಪಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ಯಾವನಿಗಾದರೂ ಮನುಷ್ಯದೇಹದಿಂದ ಉಂಟಾದ ಅಶುದ್ಧವಸ್ತು ಅಥವಾ ಅಶುದ್ಧ ಮೃಗ ಮತ್ತು ನಿಷಿದ್ಧವಸ್ತು ಇವುಗಳಲ್ಲಿ ಯಾವುದಾದರೂ ಸೋಂಕಿದರೆ ಮತ್ತು ಅವನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿತವಾದ ಯಜ್ಞಪಶುವಿನ ಮಾಂಸವನ್ನು ತಿಂದರೆ ತನ್ನ ಕುಲದಿಂದ ಬಹಿಷ್ಕರಿಸಲ್ಪಡಬೇಕು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ನೀವು ಎತ್ತು, ಕುರಿ ಮತ್ತು ಆಡುಗಳ ಕೊಬ್ಬನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ಅಂತಹ ಪಶುವು ರೋಗದಿಂದ ಸತ್ತರೆ ಇಲ್ಲವೇ ಕಾಡುಮೃಗವು ಕೊಂದರೆ, ಅದರ ಕೊಬ್ಬನ್ನು ಬೇರೆ ಕೆಲಸಕ್ಕೆ ಉಪಯೋಗಿಸಬಹುದೇ ಹೊರತು ಎಷ್ಟು ಮಾತ್ರವೂ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ಮನುಷ್ಯರು ಯೆಹೋವನಿಗೆ ಹೋಮಮಾಡುವಂತಹ ಪಶು ಜಾತಿಯ ಕೊಬ್ಬನ್ನು ಯಾವನಾದರೂ ತಿಂದರೆ ಅವನು ಕುಲದಿಂದ ಬಹಿಷ್ಕಾರಕ್ಕೆ ಒಳಗಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ಪಕ್ಷಿಯದಾಗಲಿ ಅಥವಾ ಪಶುವಿನದಾಗಲಿ ಯಾವ ರಕ್ತವನ್ನು ನೀವು ಎಲ್ಲಿಯೂ ಊಟಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ರಕ್ತಭೋಜನವನ್ನು ಮಾಡಿದವನು ಕುಲದಿಂದ ಬಹಿಷ್ಕಾರಕ್ಕೆ ಒಳಗಾಗುವನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ಸಮಾಧಾನಯಜ್ಞದ ಪಶುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವವನು ಆ ಯಜ್ಞದ್ರವ್ಯಗಳಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಸಲ್ಲಬೇಕಾದದ್ದನ್ನು ತಂದುಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ಯೆಹೋವನಿಗೆ ಹೋಮರೂಪವಾಗಿ ಸಮರ್ಪಿಸಬೇಕಾದುದನ್ನು ಅಂದರೆ ಪಶುವಿನ ಕೊಬ್ಬನ್ನು ತನ್ನ ಕೈಯಿಂದಲೇ ಕೊಡಬೇಕು. ಅದರೊಂದಿಗೆ ಅದರ ಎದೆಯ ಭಾಗವನ್ನು ನೈವೇದ್ಯರೂಪವಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿವಾಳಿಸುವುದಕ್ಕಾಗಿ ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ಯಾಜಕನು ಆ ಕೊಬ್ಬನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು; ಎದೆಯ ಭಾಗವು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ವಂಶದವರಿಗೂ ಸೇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ನೀವು ಸಮಾಧಾನಯಜ್ಞದ್ರವ್ಯಗಳಲ್ಲಿ ಬಲತೊಡೆಯನ್ನು ಯಾಜಕನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ಆರೋನನ ವಂಶದವರಲ್ಲಿ ಯಾವನು ಆ ಯಜ್ಞಪಶುವಿನ ರಕ್ತವನ್ನು ಮತ್ತು ಕೊಬ್ಬನ್ನು ಸಮರ್ಪಿಸುತ್ತಾನೋ ಅದರ ಬಲತೊಡೆಯು ಅವನ ಭಾಗವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ಇಸ್ರಾಯೇಲರು ಸಮಾಧಾನಯಜ್ಞಪಶುವಿನ ಮಾಂಸದಲ್ಲಿ ನೈವೇದ್ಯರೂಪವಾಗಿ ನಿವಾಳಿಸುವ ಎದೆಯ ಭಾಗವನ್ನು ಮತ್ತು ಯಾಜಕನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸುವ ತೊಡೆಯನ್ನು ನಾನು ತೆಗೆದುಕೊಂಡು ಮಹಾಯಾಜಕನಾದ ಆರೋನನಿಗೂ ಹಾಗು ಅವನ ವಂಶದವರಿಗೂ ಕೊಟ್ಟು ಇವು ಇಸ್ರಾಯೇಲರಿಂದ ಯಾಜಕರಿಗೆ ಯಾವಾಗಲೂ ಸಲ್ಲಬೇಕೆಂದು ಶಾಶ್ವತವಾದ ನಿಯಮವನ್ನು ಮಾಡಿದ್ದೇನೆ’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ಯೆಹೋವನಿಗೆ ಹೋಮರೂಪವಾಗಿ ಅರ್ಪಿತವಾದ ದ್ರವ್ಯಗಳಲ್ಲಿ ಇವೇ ಆರೋನನಿಗೂ ಅವನ ವಂಶದವರಿಗೂ ಶಾಶ್ವತವಾಗಿ ಸಲ್ಲತಕ್ಕ ಭಾಗಗಳಾಗಿರುವವು. ಮೋಶೆ ಅವರನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಯಾಜಕೋದ್ಯೋಗಕ್ಕಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿದ ದಿನದಲ್ಲೇ ಇದು ನೇಮಕವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ಇಸ್ರಾಯೇಲರು ಇವುಗಳನ್ನು ಯಾಜಕರಿಗೆ ಸಲ್ಲಿಸಬೇಕೆಂದು ಯೆಹೋವನು ಮೋಶೆಯ ಮುಖಾಂತರ ಕೈಯಿಂದ ಅವರನ್ನು ಪ್ರತಿಷ್ಠಿಸಿ ಅಭಿಷೇಕಿಸಿದ ದಿನದಲ್ಲೇ ನೇಮಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ಸರ್ವಾಂಗಹೋಮ, ಧಾನ್ಯನೈವೇದ್ಯ, ದೋಷಪರಿಹಾರಕ ಯಜ್ಞ, ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞ, ಯಾಜಕ ಪ್ರತಿಷ್ಠೆ ಮತ್ತು ಸಮಾಧಾನಯಜ್ಞ ಎಂಬ ಯಜ್ಞಗಳ ವಿಷಯದಲ್ಲಿ ಮೇಲೆ ಹೇಳಿದ ನಿಯಮಗಳನ್ನು ಅನುಸರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ಯೆಹೋವನು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಗೆ ಈ ಎಲ್ಲಾ ಆಜ್ಞೆಗಳನ್ನು ಕೊಟ್ಟನು. ಮೋಶೆ ಸೀನಾಯಿ ಅರಣ್ಯದಲ್ಲಿ ಇಸ್ರಾಯೇಲರು ಅರ್ಪಿಸಬೇಕಾದ ಯಜ್ಞವನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಿ ಅವರಿಗೆ ಮೇಲೆ ಕಂಡ ನಿಯಮಗಳನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“ನೀನು ಆರೋನನನ್ನು ಮತ್ತು ಅವನ ಗಂಡು ಮಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ಅವರಿಗೆ ಬೇಕಾದ ದೀಕ್ಷಾವಸ್ತ್ರಗಳನ್ನು ಮತ್ತು ಅಭಿಷೇಕತೈಲವನ್ನು, ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಸಮರ್ಪಿಸಬೇಕಾದ ಹೋರಿಯನ್ನು, ಎರಡು ಟಗರುಗಳನ್ನು ಮತ್ತು ಹುಳಿಯಿಲ್ಲದ ಭಕ್ಷ್ಯಗಳು ತುಂಬಿರುವ ಪುಟ್ಟಿಯನ್ನು ತೆಗೆದುಕೊಂಡುಬಂದು, ");
INSERT INTO kanirv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ಜನಸಮೂಹವನ್ನೆಲ್ಲಾ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಾ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ಜನಸಮೂಹವೆಲ್ಲಾ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರ ಕೂಡಿಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ಆಗ ಮೋಶೆ ಅವರಿಗೆ, “ನಾನು ಈಗ ಮಾಡುವ ಕಾರ್ಯವು ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ಆಗ ಮೋಶೆ ಆರೋನನನ್ನು ಮತ್ತು ಅವನ ಮಕ್ಕಳನ್ನು ಹತ್ತಿರಕ್ಕೆ ಬರಮಾಡಿಕೊಂಡು ಸ್ನಾನಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ಆ ಮೇಲೆ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಆರೋನನಿಗೆ ನಿಲುವಂಗಿಯನ್ನು ತೊಡಿಸಿ, ನಡುಕಟ್ಟನ್ನು ಸುತ್ತಿ, ಮೇಲಂಗಿಯನ್ನು ತೊಡಿಸಿ, ಏಫೋದ್ ಕವಚವನ್ನು ಹಾಕಿಸಿ, ಕವಚದ ಮೇಲೆ ಸೊಗಸಾಗಿ ನೇಯ್ದ ನಡುಕಟ್ಟನ್ನು ಕಟ್ಟಿದನು, ಅದರಿಂದ ಕವಚವನ್ನು ಅವನಿಗೆ ಹೊದಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ಅವನು ಎದೆಯ ಮೇಲೆ ಪದಕವನ್ನು ಬಿಗಿದು ಆರೋನನಿಗೆ ಹಾಕಿ ಅದರೊಳಗೆ ಊರೀಮ್ ಮತ್ತು ತುಮ್ಮೀಮ್ ಎಂಬ ವಸ್ತುಗಳನ್ನು ಇಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ಅವನ ತಲೆಗೆ ಪೇಟವನ್ನು ಇಟ್ಟು, ಅದರ ಮುಂಭಾಗದಲ್ಲಿ ಬಂಗಾರದ ಪಟ್ಟಿಯನ್ನು ಕಟ್ಟಿದನು; ಅದೇ ಅವನಿಗೆ ಪರಿಶುದ್ಧವಾದ ಕಿರೀಟದಂತೆ ಇತ್ತು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ಅನಂತರ ಮೋಶೆ ಅಭಿಷೇಕತೈಲವನ್ನು ತೆಗೆದುಕೊಂಡು, ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಮತ್ತು ಅದರಲ್ಲಿದ್ದ ಎಲ್ಲವನ್ನು ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಏಳು ಸಾರಿ ಆ ತೈಲವನ್ನು ಚಿಮುಕಿಸಿ, ಯಜ್ಞವೇದಿಯನ್ನು ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು, ಬೋಗುಣಿಯನ್ನು ಅದರ ಪೀಠವನ್ನು ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ಆರೋನನನ್ನು ಪ್ರತಿಷ್ಠಿಸುವುದಕ್ಕಾಗಿ ಆ ತೈಲದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಆರೋನನ ತಲೆಯ ಮೇಲೆ ಹೊಯ್ದು ಅವನನ್ನು ಅಭಿಷೇಕಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ಆ ಮೇಲೆ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಮೋಶೆ ಆರೋನನ ಮಕ್ಕಳನ್ನು ಹತ್ತಿರಕ್ಕೆ ಕರೆದು, ಅವರಿಗೆ ನಿಲುವಂಗಿಗಳನ್ನು ತೊಡಿಸಿ, ನಡುಕಟ್ಟುಗಳನ್ನು ಸುತ್ತಿ, ತಲೆಗೆ ಪೇಟಗಳನ್ನು ಇಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ಅನಂತರ ಅವನು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಹೋರಿಯನ್ನು ತರಿಸಿದನು. ಆಗ ಆರೋನನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ತಮ್ಮ ಕೈಗಳನ್ನು ಅದರ ತಲೆಯ ಮೇಲೆ ಇಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ಆ ಹೋರಿಯನ್ನು ವಧಿಸಿದ ಮೇಲೆ ಮೋಶೆ ಅದರ ರಕ್ತವನ್ನು ತನ್ನ ಬೆರಳಿನಿಂದ ಯಜ್ಞವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಸುತ್ತಲೂ ಹಚ್ಚಿ, ಯಜ್ಞವೇದಿಯನ್ನು ಶುದ್ಧಪಡಿಸಿ, ಉಳಿದ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಬುಡದಲ್ಲಿ ಸುರಿದುಬಿಟ್ಟನು. ಇದರ ನಿಮಿತ್ತ ದೋಷಪರಿಹಾರಕ ಆಚಾರವನ್ನು ನಡೆಸಿ, ಅದನ್ನು ಪ್ರತಿಷ್ಠಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ಆ ಹೋರಿಯ ಕರುಳುಗಳ ಮೇಲಣ ಕೊಬ್ಬನ್ನು, ಕಳಿಜದ ಹತ್ತಿರವಿರುವ ಕೊಬ್ಬನ್ನು, ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನು ಅವುಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನು ಮೋಶೆ ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅದರಲ್ಲಿ ಉಳಿದದ್ದನ್ನೆಲ್ಲಾ ಅಂದರೆ ಅದರ ಚರ್ಮವನ್ನು, ಮಾಂಸವನ್ನು ಮತ್ತು ಕಲ್ಮಷವನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಬೆಂಕಿಯಿಂದ ಸುಡಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ತರುವಾಯ ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಟಗರನ್ನು ತರಿಸಿದನು. ಆರೋನನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ಅದರ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ಅದನ್ನು ವಧಿಸಿದ ಮೇಲೆ ಮೋಶೆ ಅದರ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಎರಚಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ಆ ಟಗರನ್ನು ತುಂಡುತುಂಡಾಗಿ ಕಡಿದ ಮೇಲೆ ಮೋಶೆ ಅದರ ತಲೆಯನ್ನು, ಮಾಂಸಭಾಗಗಳನ್ನು ಮತ್ತು ಕೊಬ್ಬನ್ನು ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ಅದರ ಕರುಳುಗಳನ್ನು ಮತ್ತು ಕಾಲುಗಳನ್ನು ನೀರಿನಿಂದ ತೊಳೆದು, ಮೋಶೆ ಆ ಟಗರನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಪೂರ್ತಿಯಾಗಿ ಹೋಮ ಮಾಡಿದನು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಪರಿಮಳಯುಕ್ತ ಸರ್ವಾಂಗಹೋಮವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ಆ ಮೇಲೆ ಅವನು ಯಾಜಕ ಪಟ್ಟಾಭಿಷೇಕಕ್ಕಾಗಿ ಸಮರ್ಪಿಸಬೇಕಾದ ಎರಡನೆಯ ಟಗರನ್ನು ತರಿಸಿದನು. ಆರೋನನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ಅದರ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ಅದನ್ನು ವಧಿಸಿದ ನಂತರ ಮೋಶೆ ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಆರೋನನ ಬಲಗಿವಿಯ ತುದಿಗೂ, ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಮತ್ತು ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಹಚ್ಚಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ಆಗ ಮೋಶೆ ಆರೋನನ ಮಕ್ಕಳನ್ನು ಹತ್ತಿರಕ್ಕೆ ಕರೆದು, ಆ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಅವರವರ ಬಲಗಿವಿಯ ತುದಿಗೂ, ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಹಚ್ಚಿ, ಉಳಿದ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಎರಚಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ಅವನು ಆ ಟಗರಿನ ಕೊಬ್ಬನ್ನು ಅಂದರೆ ಬಾಲದ ಕೊಬ್ಬು, ಕರುಳುಗಳ ಮೇಲಣ ಎಲ್ಲಾ ಕೊಬ್ಬು, ಕಳಿಜದ ಹತ್ತಿರವಿರುವ ಕೊಬ್ಬು, ಎರಡು ಮೂತ್ರಪಿಂಡಗಳು, ಅವುಗಳ ಮೇಲಿದ್ದ ಕೊಬ್ಬನ್ನು ಮತ್ತು ಬಲತೊಡೆಯನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಪುಟ್ಟಿಯಲ್ಲಿ ಇಟ್ಟಿದ್ದ ಹುಳಿಯಿಲ್ಲದ ಭಕ್ಷ್ಯಗಳಲ್ಲಿ ಒಂದು ರೊಟ್ಟಿಯನ್ನು, ಎಣ್ಣೆಮಿಶ್ರವಾದ ಒಂದು ಹೋಳಿಗೆಯನ್ನು ಹಾಗು ಒಂದು ಕಡುಬನ್ನು ತೆಗೆದುಕೊಂಡು ಈ ಭಕ್ಷ್ಯಗಳನ್ನು ಆ ಕೊಬ್ಬಿನ ಮತ್ತು ಬಲದೊಡೆಯ ಮೇಲೆ ಇಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ಅವನು ಅವೆಲ್ಲವುಗಳನ್ನು ಆರೋನನ ಮತ್ತು ಅವನ ಮಕ್ಕಳ ಕೈಗಳಿಗೆ ಕೊಟ್ಟು ನೈವೇದ್ಯವೆಂದು ಸೂಚಿಸುವುದಕ್ಕೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅದನ್ನು ನಿವಾಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ಆ ಮೇಲೆ ಮೋಶೆ ಅವುಗಳನ್ನು ಅವರ ಕೈಯಿಂದ ತೆಗೆದುಕೊಂಡು ಸರ್ವಾಂಗಹೋಮದ್ರವ್ಯದ ಮೇಲಿಟ್ಟು ಯಜ್ಞವೇದಿಯಲ್ಲಿ ಅದನ್ನು ಹೋಮಮಾಡಿದನು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಪರಿಮಳಯುಕ್ತ ಪಟ್ಟಾಭಿಷೇಕ ಯಜ್ಞವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ಮೋಶೆ ಅದರ ಎದೆಯ ಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು ನೈವೇದ್ಯವಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿವಾಳಿಸಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಆ ಪಟ್ಟಾಭಿಷೇಕಯಜ್ಞದ ಟಗರಿನಲ್ಲಿ ಆ ಎದೆಯ ಭಾಗವೇ ಮೋಶೆಗೆ ಸಲ್ಲಬೇಕಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ಆಗ ಮೋಶೆ ಅಭಿಷೇಕತೈಲದಲ್ಲಿ ಮತ್ತು ಯಜ್ಞವೇದಿಯ ಮೇಲಿದ್ದ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಆರೋನನ ಹಾಗೂ ಅವನ ವಸ್ತ್ರಗಳ ಮೇಲೆಯೂ, ಅವನ ಮಕ್ಕಳ ಮತ್ತು ಅವರ ವಸ್ತ್ರಗಳ ಮೇಲೆಯೂ ಚಿಮುಕಿಸಿದನು. ಹೀಗೆ ಆರೋನನನ್ನು ಅವನ ವಸ್ತ್ರಗಳನ್ನು, ಅವನ ಮಕ್ಕಳನ್ನು ಮತ್ತು ಅವರ ವಸ್ತ್ರಗಳನ್ನು ಪ್ರತಿಷ್ಠಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ಮೋಶೆ ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳಿಗೂ, “ಮಾಂಸವನ್ನು ನೀವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರ ಬೇಯಿಸಿ ಅದನ್ನು ಮತ್ತು ಪಟ್ಟಾಭಿಷೇಕಕ್ಕಾಗಿ ಪುಟ್ಟಿಯಲ್ಲಿ ಇಟ್ಟಿರುವ ಭಕ್ಷ್ಯಗಳನ್ನು ಅಲ್ಲೇ ಊಟಮಾಡಬೇಕು. ‘ಆರೋನನೂ ಅವನ ಮಕ್ಕಳೂ ಅದನ್ನು ತಿನ್ನಬೇಕು’ ಎಂಬುದೇ ನನಗಾದ ಅಪ್ಪಣೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ಆ ಮಾಂಸದಲ್ಲಿಯೂ, ಭಕ್ಷ್ಯಗಳಲ್ಲಿಯೂ ಉಳಿದದ್ದನ್ನು ನೀವು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ಇದಲ್ಲದೆ ಈ ನಿಮ್ಮ ಯಾಜಕೋದ್ಯೋಗದ ದೀಕ್ಷೆಯು ಪೂರೈಸುವುದಕ್ಕೆ ಏಳು ದಿನಗಳು ಆಗುವುದರಿಂದ ನೀವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಆಚೆಗೆ ಹೋಗಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ನಿಮ್ಮ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಈ ಹೊತ್ತು ಏನೇನು ನಡೆಯಿತೋ ಅದನ್ನು ಏಳು ದಿನವೂ ನಡೆಸಬೇಕೆಂದು ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ಆದುದರಿಂದ ನೀವು ಯೆಹೋವನ ಆಜ್ಞೆಯ ಮೇರೆಗೆ ಏಳು ದಿನವೂ ಹಗಲಿರುಳು ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರ ಇರಬೇಕು; ಇಲ್ಲದಿದ್ದರೆ ಸಾಯುವಿರಿ, ಹೀಗೆಯೇ ನನಗೆ ಅಪ್ಪಣೆಯಾಗಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕವಾಗಿ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಆರೋನನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ಅನುಸರಿಸಿ ನಡೆದರು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಮೋಶೆ ಆರೋನನನ್ನು, ಅವನ ಮಕ್ಕಳನ್ನು ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರನ್ನು ಕರೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ಅವನು ಆರೋನನಿಗೆ, “ನೀನು ದೋಷಪರಿಹಾರ ಯಜ್ಞಕ್ಕಾಗಿ ಪೂರ್ಣಾಂಗವಾದ ಹೋರಿಕರುವನ್ನು ಮತ್ತು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಪೂರ್ಣಾಂಗವಾದ ಟಗರನ್ನು ನಿನಗೋಸ್ಕರ ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ನೀನು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿ ಅವರಿಗೆ, ‘ಈ ಹೊತ್ತು ಯೆಹೋವನು ಪ್ರತ್ಯಕ್ಷನಾಗುತ್ತಾನೆ, ಆದುದರಿಂದ ನೀವು ಆತನ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಸಮರ್ಪಿಸಲು ಒಂದು ಹೋತವನ್ನು, ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ವರ್ಷದ ಪೂರ್ಣಾಂಗವಾದ ಕರುವನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ಕುರಿಯನ್ನು ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋರಿಯನ್ನು, ಟಗರನ್ನು ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆಮಿಶ್ರವಾದ ಪದಾರ್ಥವನ್ನು ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನ ಮುಂದೆ ಬರಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸು’” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ಮೋಶೆ ಆಜ್ಞಾಪಿಸಿದ ಮೇರೆಗೆ ಅವರು ಅವುಗಳನ್ನೆಲ್ಲಾ ದೇವದರ್ಶನ ಗುಡಾರದ ಹತ್ತಿರಕ್ಕೆ ತಂದರು. ಸರ್ವಸಮೂಹದವರೆಲ್ಲರೂ ಹತ್ತಿರಕ್ಕೆ ಬಂದು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಂತರು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ಆಗ ಮೋಶೆ ಅವರಿಗೆ, “ನೀವು ಏನು ಮಾಡಬೇಕೆಂದು ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದು ಇದೇ; ಅದರಂತೆ ನಡೆದರೆ ಯೆಹೋವನ ಮಹಿಮೆ ನಿಮಗೆ ಪ್ರತ್ಯಕ್ಷವಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ಆಗ ಮೋಶೆ ಆರೋನನಿಗೆ, “ಯಜ್ಞವೇದಿಯ ಹತ್ತಿರಕ್ಕೆ ಬಂದು ನೀನು ಮಾಡಬೇಕಾದ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು, ಸರ್ವಾಂಗಹೋಮವನ್ನು ಸಮರ್ಪಿಸಿ ನಿನಗೋಸ್ಕರವೂ ಮತ್ತು ನಿನ್ನ ಜನರಿಗೋಸ್ಕರವೂ ದೋಷವನ್ನು ಪರಿಹರಿಸು; ಜನರು ತಂದದ್ದನ್ನು ಸಮರ್ಪಿಸಿ ಯೆಹೋವನ ಆಜ್ಞೆಯಂತೆ ಅವರಿಗಾಗಿ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ಆರೋನನು ಯಜ್ಞವೇದಿಯ ಹತ್ತಿರಕ್ಕೆ ಹೋಗಿ ತನಗೋಸ್ಕರ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ಹೋರಿಯನ್ನು ವಧಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ಆರೋನನ ಮಕ್ಕಳು ಅದರ ರಕ್ತವನ್ನು ಅವನಿಗೆ ಒಪ್ಪಿಸಿದಾಗ ಅವನು ಅದರಲ್ಲಿ ತನ್ನ ಬೆರಳನ್ನು ಅದ್ದಿ, ಯಜ್ಞವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಹಚ್ಚಿ, ಉಳಿದ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಯ ಬುಡದಲ್ಲಿ ಹೊಯ್ದುಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ಆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಪಶುವಿನ ಕೊಬ್ಬನ್ನು, ಮೂತ್ರಪಿಂಡಗಳನ್ನು, ಕಳಿಜದ ಹತ್ತಿರವಿರುವ ಕೊಬ್ಬನ್ನು ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ಅದರ ಮಾಂಸವನ್ನು ಮತ್ತು ಚರ್ಮವನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಬೆಂಕಿಯಿಂದ ಸುಡಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ತರುವಾಯ ಸರ್ವಾಂಗಹೋಮ ಪಶುವನ್ನು ವಧಿಸಿದನು. ಆರೋನನ ಮಕ್ಕಳು ಅದರ ರಕ್ತವನ್ನು ಅವನಿಗೆ ತಂದು ಒಪ್ಪಿಸಿದಾಗ ಅವನು ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಎರಚಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ಅವರು ಆ ಪಶುವಿನ ಮಾಂಸಭಾಗಗಳನ್ನು ಮತ್ತು ತಲೆಯನ್ನು ಒಂದೊಂದಾಗಿ ಒಪ್ಪಿಸಿದಾಗ ಅವನು ಅವುಗಳನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ಅದರ ಕರುಳುಗಳನ್ನು ಮತ್ತು ಕಾಲುಗಳನ್ನು ತೊಳೆದು ಯಜ್ಞವೇದಿಯಲ್ಲಿ ಸರ್ವಾಂಗಹೋಮದ್ರವ್ಯದ ಮೇಲಿಟ್ಟು ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ತರುವಾಯ ಜನಸಮೂಹವು ಸಮರ್ಪಿಸುವ ಪಶುಗಳನ್ನು ಆರೋನನು ತರಿಸಿ ಅವುಗಳಲ್ಲಿ ದೋಷಪರಿಹಾರಕ ಹೋತವನ್ನು ಮೊದಲನೆಯ ಪಶುವಿನಂತೆ ವಧಿಸಿ ಅವರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಅದನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ಸರ್ವಾಂಗಹೋಮ ಪಶುವನ್ನು ಯಥಾವಿಧಿಯಾಗಿ ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ಅವರು ತಂದ ಧಾನ್ಯನೈವೇದ್ಯ ದ್ರವ್ಯಗಳಲ್ಲಿ ಒಂದು ಹಿಡಿಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಹೊತ್ತಾರೆಯ ಸರ್ವಾಂಗಹೋಮದ ಸಂಗಡ ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ಬಳಿಕ ಜನರಿಗೋಸ್ಕರ ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ನೇಮಕವಾದ ಹೋರಿಯನ್ನು ಮತ್ತು ಟಗರನ್ನು ವಧಿಸಿದನು. ಆರೋನನ ಮಕ್ಕಳು ಅವುಗಳ ರಕ್ತವನ್ನು ಒಪ್ಪಿಸಲಾಗಿ ಅವನು ಅದನ್ನು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲೂ ಎರಚಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ಅವರು ಹೋರಿಯ ಕೊಬ್ಬನ್ನು, ಟಗರಿನ ಬಾಲದ ಕೊಬ್ಬನ್ನು, ಅಂಗಾಂಶದ ಕೊಬ್ಬನ್ನು, ಮೂತ್ರಪಿಂಡಗಳನ್ನು, ಕಳಿಜದ ಹತ್ತಿರವಿರುವ ಕೊಬ್ಬನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ಎದೆಯ ಭಾಗಗಳ ಮೇಲೆ ಇಟ್ಟು ಒಪ್ಪಿಸಲಾಗಿ ಅವನು ಆ ಕೊಬ್ಬನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ಮೋಶೆಯು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಆರೋನನು ಅವುಗಳ ಎದೆಯ ಭಾಗಗಳನ್ನು ಮತ್ತು ಬಲತೊಡೆಯನ್ನು ನೈವೇದ್ಯವಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿವಾಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ಆರೋನನು ಆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು, ಸರ್ವಾಂಗಹೋಮವನ್ನು ಮತ್ತು ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸಿದ ನಂತರ ತನ್ನ ಕೈಗಳನ್ನು ಜನರ ಕಡೆಗೆ ಎತ್ತಿ ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ ಇಳಿದು ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ತರುವಾಯ ಮೋಶೆ ಮತ್ತು ಆರೋನನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಹೋದರು. ಅವರು ಅಲ್ಲಿಂದ ಹೊರಗೆ ಬಂದಾಗ ಜನರನ್ನು ಆಶೀರ್ವದಿಸಿದರು. ಆಗ ಯೆಹೋವನ ಮಹಿಮೆಯು ಜನರೆಲ್ಲರಿಗೆ ಪ್ರತ್ಯಕ್ಷವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ಯೆಹೋವನ ಸನ್ನಿಧಿಯಿಂದ ಬೆಂಕಿಯು ಹೊರಟು ಯಜ್ಞವೇದಿಯ ಮೇಲಿದ್ದ ಸರ್ವಾಂಗಹೋಮದ್ರವ್ಯವನ್ನು ಮತ್ತು ಕೊಬ್ಬನ್ನು ದಹಿಸಿಬಿಟ್ಟಿತು. ಜನರೆಲ್ಲರೂ ಅದನ್ನು ಕಂಡು ಉತ್ಸಾಹದಿಂದ ಆರ್ಭಟಿಸಿ, ಅಡ್ಡಬಿದ್ದು ನಮಸ್ಕರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ಆರೋನನ ಮಕ್ಕಳಲ್ಲಿ ನಾದಾಬ್ ಹಾಗೂ ಅಬೀಹೂ ಎಂಬ ಇಬ್ಬರು ತಮ್ಮ ತಮ್ಮ ಧೂಪಾರತಿಗಳಲ್ಲಿ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸದೆ ಇದ್ದ ಬೇರೆ ಬೆಂಕಿಯನ್ನಿಟ್ಟು ಅದರ ಮೇಲೆ ಧೂಪದ್ರವ್ಯವನ್ನು ಹಾಕಿ ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ಆಗ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಿಂದ ಬೆಂಕಿ ಹೊರಟು ಅವರನ್ನು ದಹಿಸಿಬಿಟ್ಟಿತು; ಅವರು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿಯೇ ಸತ್ತರು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ಆಗ ಮೋಶೆ ಆರೋನನಿಗೆ, “ಯೆಹೋವನು ಹೇಳಿದ ಮಾತಿಗೆ ಇದೇ ದೃಷ್ಟಾಂತ; ಆ ಮಾತು ಏನೆಂದರೆ, ‘ನಾನು ಪರಿಶುದ್ಧನೆಂಬುದನ್ನು ನನ್ನ ಬಳಿಯಲ್ಲಿರುವವರ ಮೂಲಕವಾಗಿಯೇ ತೋರ್ಪಡಿಸುವೆನು, ಜನರೆಲ್ಲರಿಗೆ ತಿಳಿಯುವಂತೆ ನನ್ನ ಘನತೆಯನ್ನು ಸ್ಥಾಪಿಸುವೆನು ಎಂಬುದೇ’” ಎಂದು ಹೇಳಿದನು. ಅದಕ್ಕೆ ಆರೋನನು ಮೌನವಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ಮೋಶೆ ಆರೋನನ ಚಿಕ್ಕಪ್ಪನಾದ ಉಜ್ಜಿಯೇಲನ ಮಕ್ಕಳಾದ ಮೀಶಾಯೇಲನನ್ನು ಮತ್ತು ಎಲ್ಸಾಫಾನನನ್ನು ಕರೆಯಿಸಿ, “ನೀವು ಸಮೀಪಕ್ಕೆ ಬಂದು ನಿಮ್ಮ ಅಣ್ಣಂದಿರ ಶವಗಳನ್ನು ದೇವಮಂದಿರದ ಎದುರಿನಿಂದ ಪಾಳೆಯದ ಹೊರಕ್ಕೆ ಹೊತ್ತುಕೊಂಡು ಹೋಗಬೇಕು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ಮೋಶೆಯ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಅವರು ಸಮೀಪಕ್ಕೆ ಬಂದು ಸತ್ತವರು ತೊಟ್ಟುಕೊಂಡಿದ್ದ ನಿಲುವಂಗಿಗಳನ್ನು ತೆಗೆಯದೆ ಅವರ ಶವಗಳನ್ನು ಎತ್ತಿ ಪಾಳೆಯದ ಹೊರಕ್ಕೆ ಹೊತ್ತುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ಮೋಶೆ ಆರೋನನಿಗೂ ಅವನ ಮಕ್ಕಳಾದ ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಎಂಬುವವರಿಗೆ, “ನೀವು ತಲೆಯನ್ನು ಕೆದರಿಕೊಳ್ಳಬಾರದು; ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಳ್ಳಬಾರದು. ಹಾಗೆ ಮಾಡಿದರೆ ನೀವೂ ಸಾಯುವಿರಿ; ಅದಲ್ಲದೆ ಯೆಹೋವನಿಗೆ ಜನಸಮೂಹದವರೆಲ್ಲರ ಮೇಲೆ ಸಿಟ್ಟು ಉಂಟಾಗುವುದು. ಯೆಹೋವನು ಹೊತ್ತಿಸಿದ ಈ ಬೆಂಕಿಯ ದೆಸೆಯಿಂದ ನಿಮ್ಮ ಸಹೋದರರಾಗಿರುವ ಎಲ್ಲಾ ಇಸ್ರಾಯೇಲರ ಮನೆತನದವರೇ ದುಃಖಿಸಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ಯೆಹೋವನ ಅಭಿಷೇಕ ತೈಲವು ನಿಮ್ಮ ಮೇಲಿರುವುದರಿಂದ ನೀವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲನ್ನು ಬಿಟ್ಟು ಹೋಗಬಾರದು; ಹೋದರೆ ಸಾಯುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ಮೋಶೆಯ ಮಾತಿನಂತೆಯೇ ಅವರು ನಡೆದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ಯೆಹೋವನು ಆರೋನನೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ನೀನೂ ಹಾಗು ನಿನ್ನ ಮಕ್ಕಳೂ ದ್ರಾಕ್ಷಾರಸವನ್ನಾಗಲಿ ಅಥವಾ ಮದ್ಯವನ್ನಾಗಲಿ ಕುಡಿದು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಬರಬಾರದು; ಹಾಗೆ ಬಂದರೆ ಸಾಯುವಿರಿ. ಇದು ನಿನಗೂ ಮತ್ತು ನಿನ್ನ ಸಂತತಿಯವರೆಲ್ಲರಿಗೂ ಶಾಶ್ವತನಿಯಮ. ");
INSERT INTO kanirv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ಅದಲ್ಲದೆ ದೇವರಿಗೆ ಮೀಸಲಾದ ವಸ್ತುಗಳನ್ನು ಅಲ್ಲದ ವಸ್ತುಗಳನ್ನು, ಶುದ್ಧವಾದವುಗಳನ್ನು, ಅಶುದ್ಧವಾದವುಗಳನ್ನು ವಿವೇಚಿಸುವುದೂ, ");
INSERT INTO kanirv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಇಸ್ರಾಯೇಲರಿಗೆ ಮಾಡಿದ ಎಲ್ಲಾ ಆಜ್ಞೆಗಳನ್ನು ಜನರಿಗೆ ಬೋಧಿಸುವುದೂ ನಿಮ್ಮ ಕರ್ತವ್ಯವಾಗಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ಮೋಶೆ ಆರೋನನಿಗೂ ಅವನ ಉಳಿದ ಮಕ್ಕಳಾದ ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಎಂಬವರಿಗೆ, “ಯೆಹೋವನಿಗೆ ಅಗ್ನಿಯ ಮೂಲಕ ಸಮರ್ಪಿತವಾದ ದ್ರವ್ಯಗಳಲ್ಲಿ ಉಳಿದಿರುವ ಧಾನ್ಯನೈವೇದ್ಯ ದ್ರವ್ಯವನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದರಿಂದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಿಸಿ, ಯಜ್ಞವೇದಿಯ ಬಳಿಯಲ್ಲಿ ಊಟಮಾಡಬೇಕು. ಅದು ಮಹಾಪರಿಶುದ್ಧವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ಪವಿತ್ರಸ್ಥಳದೊಳಗೇ ಅದನ್ನು ಊಟಮಾಡಬೇಕು. ಜನರು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಿದ ಹೋಮದ್ರವ್ಯಗಳಲ್ಲಿ ಅದು ನಿನಗೂ ಮತ್ತು ನಿನ್ನ ಮಕ್ಕಳಿಗೂ ಸಲ್ಲತಕ್ಕದ್ದೆಂದು ಅಪ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ನೀವು ನೈವೇದ್ಯ ಮಾಡಿದ ಎದೆಯ ಭಾಗವನ್ನು, ಯಾಜಕರಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿದ ತೊಡೆಯನ್ನು ಯಾವುದಾದರೂ ಒಂದು ಶುದ್ಧಸ್ಥಳದಲ್ಲಿ ಊಟಮಾಡಬಹುದು. ನೀನೂ, ನಿನ್ನ ಗಂಡುಮಕ್ಕಳೂ ಹಾಗು ಹೆಣ್ಣುಮಕ್ಕಳೂ ಅದನ್ನು ತಿನ್ನಬಹುದು. ಏಕೆಂದರೆ ಇಸ್ರಾಯೇಲರು ಸಮರ್ಪಿಸುವ ಸಮಾಧಾನಯಜ್ಞದ್ರವ್ಯಗಳಲ್ಲಿ ಇವೇ ನಿನಗೂ ಮತ್ತು ನಿನ್ನ ಮಕ್ಕಳಿಗೂ ಸಲ್ಲಬೇಕೆಂದು ನೇಮಕವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ಜನರು ಹೋಮಕ್ಕಾಗಿ ಕೊಬ್ಬನ್ನು ತಂದು ಸಮರ್ಪಿಸುವಾಗೆಲ್ಲಾ ಯಾಜಕರಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಬೇಕಾದ ಆ ತೊಡೆಯನ್ನು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕಾದ ಆ ಎದೆಯ ಭಾಗವನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ತರಬೇಕು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವು ನಿನಗೂ ಮತ್ತು ನಿನ್ನ ವಂಶದವರಿಗೂ ಸಲ್ಲತಕ್ಕದ್ದು; ಇದು ಶಾಶ್ವತನಿಯಮ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ಜನರೆಲ್ಲರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡಲು ಸಮರ್ಪಿತವಾದ ಹೋತದ ವಿಷಯದಲ್ಲಿ ಅದು ಏನಾಯಿತೆಂದು ಮೋಶೆ ವಿಚಾರಿಸಲಾಗಿ ಅದನ್ನು ಸುಟ್ಟುಬಿಟ್ಟರೆಂದು ತಿಳಿಯಬಂತು. ಇದನ್ನು ಕೇಳಿದಾಗ ಅವನು ಆರೋನನ ಉಳಿದ ಮಕ್ಕಳಾದ ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಎಂಬವರ ಮೇಲೆ ಸಿಟ್ಟುಗೊಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ಆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ್ರವ್ಯವು ಮಹಾಪರಿಶುದ್ಧವಾದದ್ದಲ್ಲವೇ? ನೀವು ಜನಸಮೂಹದ ಪಾಪಗಳನ್ನು ಪರಿಹಾರಮಾಡುವಂತೆಯೂ, ಅವರಿಗೋಸ್ಕರ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡುವಂತೆಯೂ ಅದು ನಿಮ್ಮ ಭಾಗವಾಗಿ ನೇಮಕವಾಗಿದೆಯಲ್ಲಾ. ನೀವು ಯಾಕೆ ಅದನ್ನು ಪವಿತ್ರಸ್ಥಳದೊಳಗೆ ಊಟಮಾಡಲಿಲ್ಲ? ");
INSERT INTO kanirv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ಅದರ ರಕ್ತವು ಪವಿತ್ರಸ್ಥಾನದೊಳಗೆ ತರಬಾರದಾಗಿತ್ತು, ನಾನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ನೀವು ದೇವಸ್ಥಾನದ ಪ್ರಾಕಾರದೊಳಗೆ ಅದನ್ನು ತಿನ್ನಬೇಕಾಗಿತ್ತು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ಅದಕ್ಕೆ ಆರೋನನು ಮೋಶೆಗೆ, “ಇವರು ಈ ಹೊತ್ತು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ತಮಗೋಸ್ಕರ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಮತ್ತು ಸರ್ವಾಂಗಹೋಮವನ್ನು ಸಮರ್ಪಿಸಿದ್ದರೂ ಈ ಆಪತ್ತು ನನಗೆ ಸಂಭವಿಸಿತು; ಹೀಗಿರುವಾಗ ನಾನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ್ರವ್ಯವನ್ನು ಈ ಹೊತ್ತು ಊಟಮಾಡಿದ್ದರೆ ಅದು ಯೆಹೋವನ ದೃಷ್ಟಿಯಲ್ಲಿ ಒಳ್ಳೆಯದಾಗಿ ತೋರುತ್ತಿತ್ತೋ?” ");
INSERT INTO kanirv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ಎಂದು ಉತ್ತರಕೊಡಲಾಗಿ ಮೋಶೆ ಆ ಮಾತನ್ನು ಕೇಳಿ ತೃಪ್ತಿಗೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ನೀವು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು, ‘ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಇವುಗಳ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಬಹುದು, ");
INSERT INTO kanirv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ಅವು ಯಾವುವೆಂದರೆ ಯಾವ ಪ್ರಾಣಿಯ ಕಾಲ್ಗೊರಸು ಸೀಳಿದೆಯೋ ಅದು ಮೆಲುಕುಹಾಕುವಂಥದಾದರೆ ಅದರ ಮಾಂಸವನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ಆದರೆ ಯಾವ ಪ್ರಾಣಿಯು ಮೆಲಕು ಹಾಕಿದರೂ ಗೊರಸು ಸೀಳಲಿರುವುದಿಲ್ಲವೋ ಮತ್ತು ಯಾವ ಪ್ರಾಣಿಯು ಗೊರಸು ಸೀಳಿದರೂ ಮೆಲಕು ಹಾಕುವುದಿಲ್ಲವೋ ಅವುಗಳ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಬಾರದು. ಉದಾಹರಣೆಗೆ, ಒಂಟೆಯು ಮೆಲಕುಹಾಕುವಂಥದು ಸರಿ; ಆದರೂ ಅದಕ್ಕೆ ಸೀಳುಗೊರಸು ಇಲ್ಲವಾದುದರಿಂದ ನೀವು ಅದರ ಮಾಂಸವನ್ನು ಅಶುದ್ಧವೆಂದೆಣಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ಬೆಟ್ಟದ ಮೊಲವೂ ಮೆಲಕುಹಾಕುವಂಥದು; ಆದರೂ ಸೀಳುಗೊರಸು ಇಲ್ಲವಾದುದರಿಂದ ಅದು ನಿಮಗೆ ಅಶುದ್ಧ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ಮೊಲವೂ ಮೆಲಕುಹಾಕುವಂಥದು; ಆದರೂ ಸೀಳುಗೊರಸು ಇಲ್ಲವಾದ ಕಾರಣ ಅದೂ ನಿಮಗೆ ಅಶುದ್ಧ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ಹಂದಿಯ ಗೊರಸು ಸೀಳಿದೆ; ಆದರೂ ಅದು ಮೆಲಕು ಹಾಕುವುದಿಲ್ಲವಾದುದರಿಂದ ಅದು ನಿಮಗೆ ಅಶುದ್ಧ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ಇವುಗಳ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಬಾರದು; ಇವುಗಳ ಹೆಣವನ್ನು ಮುಟ್ಟಬಾರದು; ಇವುಗಳನ್ನು ಅಶುದ್ಧವೆಂದೆಣಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“‘ಜಲಜಂತುಗಳಲ್ಲಿ ನೀವು ತಿನ್ನಬಹುದಾದವುಗಳು ಯಾವುವೆಂದರೆ ಸಮುದ್ರದಲ್ಲಿಯಾಗಲಿ, ನದಿಯಲ್ಲಿಯಾಗಲಿ, ಬೇರೆ ಜಲಾಶಯದಲ್ಲಿಯಾಗಲಿ ಯಾವ ಜಾತಿಯ ಪ್ರಾಣಿಗೆ ರೆಕ್ಕೆ ಇದ್ದು ಮೈಯೆಲ್ಲಾ ಪರೆಪರೆಯಾಗಿರುವುದೋ ಅದರ ಮಾಂಸವನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ಆದರೆ ಸಮುದ್ರದಲ್ಲಿದ್ದರೂ ಅಥವಾ ನದಿಯಲ್ಲಿದ್ದರೂ ಜಲಚರಗಳಾದ ಸಕಲವಿಧವಾದ ಜೀವಜಂತುಗಳಲ್ಲಿ ಯಾವ ಜಾತಿಗೆ ರೆಕ್ಕೆಯೂ ಮತ್ತು ಪರೆಪರೆಯಾದ ಮೈಯೂ ಇರುವುದಿಲ್ಲವೋ ಅದು ನಿಮಗೆ ನಿಷಿದ್ಧವಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ಅಂತಹವು ಸಂಪೂರ್ಣವಾಗಿ ನಿಷಿದ್ಧವಾಗಿರುವುದರಿಂದ ಅವುಗಳ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಬಾರದು; ಅವುಗಳ ಹೆಣಗಳು ನಿಮಗೆ ಅಸಹ್ಯವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ಜಲಜಂತುಗಳಲ್ಲಿ ಯಾವುದಕ್ಕೆ ರೆಕ್ಕೆಗಳೂ, ಪರೆಪರೆಯಾದ ಮೈ ಇಲ್ಲವೋ ಅವು ನಿಮಗೆ ಅಸಹ್ಯವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“‘ನಿಮಗೆ ನಿಷಿದ್ಧವಾದ ಮತ್ತು ಅಸಹ್ಯವಾದ ಪಕ್ಷಿಗಳು ಯಾವುವೆಂದರೆ ಗರುಡ, ಬೆಟ್ಟದ ಹದ್ದು, ");
INSERT INTO kanirv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ಕ್ರೌಂಚ, ಹದ್ದು, ");
INSERT INTO kanirv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ಸಕಲವಿಧವಾದ ಗಿಡುಗ, ");
INSERT INTO kanirv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ಸಕಲವಿಧವಾದ ಕಾಗೆ, ಉಷ್ಟ್ರಪಕ್ಷಿ, ಉಲೂಕ, ಕಡಲಹಕ್ಕಿ, ಸಕಲವಿಧವಾದ ಡೇಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ಗೂಬೆ, ಹೆಗ್ಗೂಬೆ, ನೀರುಕಾಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ಬಿಳಿಗೂಬೆ, ಕರೇಟು, ಕಣಜ ಗೂಬೆ, ರಣಹದ್ದು, ಕಡಲ ಡೇಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ಕೊಕ್ಕರೆ, ಸಕಲವಿಧವಾದ ಬಕ, ಹೆಡೆಹಕ್ಕಿ, ಕಣ್ಣಕಪಡಿ. ಇವುಗಳ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“‘ರೆಕ್ಕೆಯುಳ್ಳವುಗಳಾಗಿ ಕಾಲುಗಳಿಂದ ಹರಿದಾಡುವ ಕ್ರಿಮಿಕೀಟಗಳೆಲ್ಲವೂ ನಿಮಗೆ ನಿಷಿದ್ಧವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ಆದರೆ ಕಾಲುಳ್ಳ ಯಾವ ಕ್ರಿಮಿಕೀಟಗಳಿಗೆ ನೆಲದ ಮೇಲೆ ಹಾರುವುದಕ್ಕೋಸ್ಕರ ಮುದುರಿಕೊಂಡಿರುವ ತೊಡೆಗಳು ಇರುತ್ತವೆಯೋ ಅವುಗಳನ್ನು ನೀವು ತಿನ್ನಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ಸಕಲವಿಧವಾದ ಮಿಡತೆಗಳನ್ನು, ಬೋಳುಮಿಡತೆಗಳನ್ನು, ಜಿಟ್ಟಿಮಿಡತೆಗಳನ್ನು ಮತ್ತು ಸಣ್ಣಮಿಡತೆ ಇವುಗಳನ್ನೆಲ್ಲಾ ತಿನ್ನಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ರೆಕ್ಕೆಯುಳ್ಳವುಗಳಾಗಿ ಕಾಲುಗಳಿಂದ ಹರಿದಾಡುವ ಸಕಲವಿಧವಾದ ಕ್ರಿಮಿಕೀಟಗಳು ನಿಮಗೆ ನಿಷಿದ್ಧವಾಗಿವೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“‘ಅದಲ್ಲದೆ ಮುಂದೆ ಹೇಳಿರುವ ಪ್ರಾಣಿಗಳಿಂದ ನಿಮಗೆ ಅಪವಿತ್ರತೆ ಉಂಟಾಗುತ್ತದೆ. ಅವುಗಳ ಹೆಣ ಯಾವನಿಗೆ ಸೋಂಕುವುದೋ ಅವನು ಆ ದಿನದ ಸಾಯಂಕಾಲದ ವರೆಗೂ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ಅವುಗಳ ಹೆಣವನ್ನು ಎತ್ತಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು ಮತ್ತು ಸಾಯಂಕಾಲದವರೆಗೂ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ಅವು ಯಾವುವೆಂದರೆ, ಯಾವ ಪಶುವಿನ ಗೊರಸು ಸ್ವಲ್ಪ ಸೀಳಿದ್ದರೂ ಇಗ್ಗೊರಸಾಗಿಲ್ಲವೋ ಮತ್ತು ಮೆಲಕುಹಾಕುವುದಿಲ್ಲವೋ ಅದು ನಿಮಗೆ ಅಶುದ್ಧ. ಯಾರನ್ನು ಅವು ಸೋಂಕುವವೋ ಅವನು ಅಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ಚತುಷ್ಪಾದ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಅಂಗಾಲುಗಳಿಂದ ನಡೆಯುವ ಎಲ್ಲವುಗಳು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿರುವವು; ಅವುಗಳ ಹೆಣವನ್ನು ಯಾರು ಮುಟ್ಟುವರೋ ಅವರು ಆ ದಿನದ ಸಾಯಂಕಾಲದ ವರೆಗೂ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ಅವುಗಳ ಹೆಣವನ್ನು ಎತ್ತಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು ಮತ್ತು ಆ ಸಾಯಂಕಾಲದ ವರೆಗೂ ಅಶುದ್ಧನಾಗಿರುವನು. ಅವು ನಿಮಗೆ ಅಶುದ್ಧ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“‘ನೆಲದ ಮೇಲೆ ಸಂಚರಿಸುವ ಸಣ್ಣ ಜಂತುಗಳಲ್ಲಿ ನಿಮಗೆ ಅಶುದ್ಧವಾದವುಗಳು ಯಾವುವೆಂದರೆ ಮುಂಗುಸಿ, ಇಲಿ, ಸಕಲವಿಧವಾದ ಉಡ, ");
INSERT INTO kanirv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ಹಾವರಾಣಿ, ಊಸುರುವಳ್ಳಿ, ಹಲ್ಲಿ, ಬಸವನಹುಳ, ಚಿಟ್ಟಿಲಿ ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ನೆಲದ ಮೇಲೆ ಸಂಚರಿಸುವ ಈ ಅಶುದ್ಧವಾದ ಸಣ್ಣ ಜಂತುಗಳ ಹೆಣವನ್ನು ಮುಟ್ಟುವವನು ಆ ಸಾಯಂಕಾಲದ ವರೆಗೂ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ಇವುಗಳ ಹೆಣವು ಯಾವ ವಸ್ತುವಿನ ಮೇಲೆ ಬೀಳುವುದೋ ಆ ವಸ್ತುವು ಅಶುದ್ಧವಾಗಿರುವುದು. ಅದು ಮರದ ವಸ್ತುವಾಗಲಿ ಬಟ್ಟೆಯಾಗಲಿ, ಚರ್ಮವಾಗಲಿ ಅಥವಾ ಗೋಣಿಯಾಗಲಿ ಅದು ಎಂಥದಾದರೂ, ಯಾವ ಕೆಲಸಕ್ಕೆ ಉಪಯೋಗವಾಗಿದ್ದರೂ ಅದನ್ನು ನೀರಿನಲ್ಲಿ ನೆನಸಬೇಕು; ಅದು ಆ ಸಾಯಂಕಾಲದ ವರೆಗೂ ಅಶುದ್ಧವಾಗಿರುವುದು; ತರುವಾಯ ಶುದ್ಧಿಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ಆ ಜಂತುಗಳ ಹೆಣ ಮಣ್ಣಿನ ಪಾತ್ರೆಯಲ್ಲಿ ಬಿದ್ದರೆ ಆ ಪಾತ್ರೆಯಲ್ಲಿರುವುದೆಲ್ಲಾ ಅಶುದ್ಧವಾಗಿರುವುದು ಮತ್ತು ಆ ಪಾತ್ರೆಯನ್ನು ನೀವು ಒಡೆದುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ಅದರಲ್ಲಿರುವ ತಿನ್ನತಕ್ಕ ಪದಾರ್ಥವೆಲ್ಲಾ ನೀರಿನಿಂದ ನೆನದರೆ ಅಶುದ್ಧವಾಗುವುದು. ಪಾನ ದ್ರವ್ಯವು ಆ ಪಾತ್ರೆಯಲ್ಲಿದ್ದರೆ ಅದೂ ಅಶುದ್ಧವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ಆ ಜಂತುಗಳ ಹೆಣ ಯಾವ ಸಾಮಾನಿನ ಮೇಲೆ ಬಿದ್ದರೂ ಆ ಸಾಮಾನು ಅಶುದ್ಧವಾಗುವುದು. ಒಲೆಗಳಲ್ಲಿ ಅದು ಒಂಟಿ ಒಲೆಯಾಗಿದ್ದರೂ ಅಥವಾ ಜೋಡಿ ಒಲೆಯಾಗಿದ್ದರೂ ಅದು ಅಶುದ್ಧವಾದುದರಿಂದ ಅದನ್ನು ಒಡೆದುಬಿಡಬೇಕು; ಅದು ಅಶುದ್ಧವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ಒರತೆ ಮೊದಲಾದ ಜಲಾಶಯಗಳನ್ನು ಮಾತ್ರ ನೀವು ಶುದ್ಧವೆಂದೆಣಿಸಬೇಕು. ಆದರೆ ಇವುಗಳೊಳಗಿಂದ ಆ ಹೆಣವನ್ನು ಎತ್ತಿದವನು ಅಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ಬಿತ್ತಬೇಕಾದ ಬೀಜದ ಮೇಲೆ ಈ ಜಂತುಗಳ ಹೆಣ ಬಿದ್ದರೆ ಆ ಬೀಜವು ಅಶುದ್ಧವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ನೀರು ಹಾಕಿ ನೆನಸಿದ ಬೀಜದ ಮೇಲೆ ಆ ಹೆಣ ಬಿದ್ದರೆ ಅದು ನಿಮಗೆ ಅಶುದ್ಧ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“‘ಆಹಾರಕ್ಕೆ ಯೋಗ್ಯವಾಗಿರುವ ಪಶುವು ಸತ್ತರೆ ಅದರ ಹೆಣವನ್ನು ಮುಟ್ಟಿದವನು ಆ ದಿನದ ಸಾಯಂಕಾಲದ ವರೆಗೂ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ಆ ಹೆಣದಲ್ಲಿ ಸ್ವಲ್ಪವಾಗಿ ತಿಂದರೂ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು. ಅವನು ಆ ದಿನದ ಸಾಯಂಕಾಲದ ವರೆಗೂ ಅಶುದ್ಧನಾಗಿರುವನು. ಆ ಹೆಣವನ್ನು ಹೊತ್ತವನೂ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು; ಅವನು ಆ ಸಾಯಂಕಾಲದ ವರೆಗೂ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“‘ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಕ್ರಿಮಿಕೀಟಗಳೆಲ್ಲಾ ಅಸಹ್ಯವಾಗಿವೆ; ಅವುಗಳ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ಹೊಟ್ಟೆಯಿಂದ ಹರಿದು ಹೋಗುವುದನ್ನು, ಕಾಲಿನಿಂದ ಹರಿದಾಡುವಂಥದನ್ನು, ಬಹಳ ಕಾಲುಳ್ಳದ್ದನ್ನು ಅಂತೂ ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಯಾವ ಸಣ್ಣ ಜೀವಿಯನ್ನು ನೀವು ತಿನ್ನಬಾರದು; ಅವು ಅಸಹ್ಯವಾಗಿವೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ನೀವು ಅಂತಹ ಯಾವ ಸಣ್ಣ ಜೀವಿಯನ್ನು ತಿಂದು ನಿಮ್ಮನ್ನು ನೀವೇ ಹೇಸಿಗೆಮಾಡಿಕೊಂಡು ಅಶುದ್ಧರಾಗಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ಏಕೆಂದರೆ ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು; ನೀವು ದೇವಜನರಿಗೆ ತಕ್ಕಂತೆ ಇರಬೇಕು. ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವುದರಿಂದ ನೀವೂ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಯಾವ ಜಂತುವಿನಿಂದಾದರೂ ನೀವು ನಿಮ್ಮನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ನಿಮ್ಮ ದೇವರಾಗಿರುವುದಕ್ಕೆ ನಿಮ್ಮನ್ನು ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದ ಯೆಹೋವನು ನಾನೇ; ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವುದರಿಂದ ನೀವೂ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“‘ಇದೇ ಪಶು, ಪಕ್ಷಿ, ಜಲಚರ ಮತ್ತು ಕ್ರಿಮಿಕೀಟಗಳ ವಿಷಯವಾದ ನಿಯಮ. ");
INSERT INTO kanirv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ಇದರಿಂದ ಶುದ್ಧ ಹಾಗು ಅಶುದ್ಧಗಳನ್ನು, ತಿನ್ನಬಹುದಾದ ಜೀವಿಗಳು ಮತ್ತು ತಿನ್ನಬಾರದಾದ ಜೀವಿಗಳ ಕುರಿತು ವಿವೇಚಿಸುವುದಕ್ಕೆ ನಿಮ್ಮಿಂದಾಗುವುದು.’” ");
INSERT INTO kanirv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ಒಬ್ಬ ಸ್ತ್ರೀ ಗಂಡುಮಗುವಿಗೆ ಜನ್ಮ ನೀಡಿದರೆ ತಾನು ತಿಂಗಳ ಮುಟ್ಟಿನಿಂದ ಹೇಗೆ ಅಶುದ್ಧಳಾಗುವಳೋ ಹಾಗೆಯೇ ಏಳು ದಿನಗಳ ತನಕ ಅಶುದ್ಧಳಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಆ ಮಗುವಿಗೆ ಸುನ್ನತಿಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ಆ ಮೇಲೆ ಅವಳ ಶುದ್ಧೀಕರಣ ಪೂರ್ಣಗೊಳ್ಳಲು ಇನ್ನು ಮೂವತ್ತಮೂರು ದಿನ ಆಗುವುದು. ಅದು ಪೂರ್ಣಗೊಳ್ಳುವ ತನಕ ಅವಳು ದೇವರ ಪವಿತ್ರ ವಸ್ತುವನ್ನು ಮುಟ್ಟಬಾರದು ಅಥವಾ ದೇವಸ್ಥಾನಕ್ಕೆ ಬರಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ಹೆಣ್ಣುಮಗುವಿಗೆ ಜನ್ಮ ನೀಡಿದರೆ ತಾನು ತಿಂಗಳ ಮುಟ್ಟಿನಿಂದ ಹೇಗೆ ಅಶುದ್ಧಳಾಗುವಳೋ ಹಾಗೆಯೇ ಎರಡು ವಾರಗಳು ಅಶುದ್ಧಳಾಗಿರಬೇಕು ಮತ್ತು ಶುದ್ಧೀಕರಣ ಪೂರ್ಣಗೊಳ್ಳಲು ಅರುವತ್ತಾರು ದಿನಗಳು ಆಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“‘ಗಂಡುಮಗುವಿಗೆ ಜನ್ಮ ನೀಡಿದರೂ ಅಥವಾ ಹೆಣ್ಣುಮಗುವಿಗೆ ಜನ್ಮ ನೀಡಿದರೂ ಅವಳ ಶುದ್ಧೀಕರಣದ ದಿನಗಳು ಪೂರೈಸಿದಾಗ ಅವಳು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು, ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಪಾರಿವಾಳದ ಮರಿಯನ್ನು ಇಲ್ಲವೆ ಬೆಳವಕ್ಕಿಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತಂದು ಯಾಜಕನಿಗೆ ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ಅವನು ಅವುಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಿ ಅವಳಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದಾಗ ಅವಳಿಗೆ ರಕ್ತಸ್ರಾವದಿಂದುಂಟಾದ ಅಶುದ್ಧತೆಯಿಂದ ಶುದ್ಧಳಾಗುವಳು. ಗಂಡುಮಗುವಿಗಾಗಲಿ ಅಥವಾ ಹೆಣ್ಣು ಮಗುವಿಗಾಗಲಿ ಜನ್ಮ ನೀಡಿದವಳಿಗೆ ಇದೇ ನಿಯಮ. ");
INSERT INTO kanirv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ಕುರಿಯನ್ನು ಕೊಡುವುದಕ್ಕೆ ಗತಿಯಿಲ್ಲದಿದ್ದರೆ ಅವಳು ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತಂದು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದನ್ನು, ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಮತ್ತೊಂದನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಯಾಜಕನು ಅವಳಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದಾಗ ಶುದ್ಧಳಾಗುವಳು’” ಎಂಬುದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ಒಬ್ಬ ಮನುಷ್ಯನ ಮೈಮೇಲೆ ಬಾವಾಗಲಿ, ಗುಳ್ಳೆಯಾಗಲಿ ಅಥವಾ ಹೊಳೆಯುವ ಮಚ್ಚೆಯಾಗಲಿ ಉಂಟಾಗಿ ಅದರಲ್ಲಿ ಕುಷ್ಠರೋಗದ ಲಕ್ಷಣಗಳು ತೋರಿದರೆ ಅವನನ್ನು ಮಹಾಯಾಜಕನಾದ ಆರೋನನ ಬಳಿಗೆ ಇಲ್ಲವೆ ಆರೋನನ ಮಕ್ಕಳಾದ ಯಾಜಕರಲ್ಲಿ ಒಬ್ಬನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ಯಾಜಕನು ಅವನ ಚರ್ಮದಲ್ಲಿರುವ ಮಚ್ಚೆಯನ್ನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಮಚ್ಚೆಯಲ್ಲಿರುವ ರೋಮ ಬೆಳ್ಳಗಾಗಿದ್ದರೆ ಮತ್ತು ಆ ಮಚ್ಚೆ ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿದ್ದರೆ ಅದು ಕುಷ್ಠರೋಗ. ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಿ ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ಆ ಹೊಳೆಯುವ ಮಚ್ಚೆ ಬೆಳ್ಳಗಾಗಿದ್ದು ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿರದೆ ಹೋದರೆ ಮತ್ತು ಅಲ್ಲಿರುವ ರೋಮ ಬೆಳ್ಳಗಾಗದಿದ್ದರೆ ಯಾಜಕನು ಆ ಮಚ್ಚೆಯಿದ್ದವನನ್ನು ಏಳು ದಿನಗಳ ವರೆಗೆ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಮಚ್ಚೆ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಳ್ಳದೆ ಮೊದಲು ಇದ್ದಂತೆಯೇ ಕಾಣಿಸಿದರೆ ಯಾಜಕನು ಇನ್ನು ಏಳು ದಿನಗಳ ವರೆಗೂ ಅವನನ್ನು ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ಆ ಏಳು ದಿನಗಳಾದ ಮೇಲೆ ಯಾಜಕನು ಪುನಃ ಅವನನ್ನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಮಚ್ಚೆ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಳ್ಳದೆ ಮೊಬ್ಬಾಗಿದ್ದರೆ ಯಾಜಕನು ಅದು ಬರೀ ಗುಳ್ಳೆಯೆಂದು ತಿಳಿದು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ಆದರೆ ಅವನು ತನ್ನ ಶುದ್ಧಿಯ ವಿಷಯದಲ್ಲಿ ತನ್ನನ್ನು ಯಾಜಕನಿಗೆ ತೋರಿಸಿಕೊಂಡನಂತರ ಆ ಗುಳ್ಳೆ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಂಡರೆ ಅವನು ಪುನಃ ಯಾಜಕನಿಗೆ ತೋರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಮಚ್ಚೆ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಂಡಿದ್ದರೆ ಅದು ಕುಷ್ಠವೆಂದು ತಿಳಿದು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ಕುಷ್ಠರೋಗದ ಲಕ್ಷಣಗಳು ಯಾವನಲ್ಲಾದರೂ ಕಾಣಿಸಿದರೆ ಅವನನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸುವಾಗ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಬೆಳ್ಳಗಾದ ಬಾವು ಇದ್ದರೆ ಮತ್ತು ಅಲ್ಲಿರುವ ರೋಮವು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ ಮತ್ತು ಆ ಬಾವಿನಲ್ಲಿ ಮಾಂಸ ಕಾಣಿಸಿದರೆ ಅದು ಹಳೇ ಕುಷ್ಠರೋಗದ ಗುರುತು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ಅವನು ಅಶುದ್ಧನಾದುದರಿಂದ ಯಾಜಕನು ಅವನನ್ನು ಪ್ರತ್ಯೇಕಿಸದೆ ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“ಆದರೆ ಒಬ್ಬನ ಚರ್ಮದಲ್ಲಿ ತೊನ್ನು ಹತ್ತಿ ಯಾಜಕನು ನೋಡುವ ಎಲ್ಲಾ ಕಡೆಯಲ್ಲಿಯೂ ತಲೆ ಮೊದಲುಗೊಂಡು ಅಂಗಾಲಿನವರೆಗೂ ಹರಡಿಕೊಂಡಿದ್ದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ತೊನ್ನು ದೇಹದಲ್ಲೆಲ್ಲಾ ವ್ಯಾಪಿಸಿಕೊಂಡಿದ್ದರೆ, ಅಂಥವನನ್ನು ಶುದ್ಧನೆಂದು ಯಾಜಕನು ನಿರ್ಣಯಿಸಬೇಕು. ಅವನ ಚರ್ಮವೆಲ್ಲಾ ಬೆಳ್ಳಗಾಗಿ ಹೋದುದರಿಂದ ಅವನು ಶುದ್ಧನು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ಆದರೆ ಅಂಥವನ ದೇಹದಲ್ಲಿ ಎಲ್ಲಿಯಾದರೂ ಮಾಂಸ ಕಂಡುಬಂದರೆ ಅವನು ಅಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ಯಾಜಕನು ಆ ಮಾಂಸವನ್ನು ನೋಡಿ ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ಅಂತಹ ಮಾಂಸವು ಅಶುದ್ಧವೇ; ಅದು ಕುಷ್ಠವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ಆದರೆ ಆ ಮಾಂಸವು ಅದೇ ಪ್ರಕಾರವಾಗಿ ಇರದೆ ಪುನಃ ಬೆಳ್ಳಗಾದರೆ ಅವನು ಯಾಜಕನ ಬಳಿಗೆ ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಮಚ್ಚೆಯು ಬೆಳ್ಳಗಾಗಿಹೋಗಿದ್ದರೆ ಆ ಮನುಷ್ಯನನ್ನು ಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು; ಅವನು ಶುದ್ಧನೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ಒಬ್ಬನ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಹುಣ್ಣು ಆಗಿದ್ದು ಅದು ವಾಸಿಯಾದ ಮೇಲೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ಅದು ಇದ್ದ ಸ್ಥಳದಲ್ಲಿ ಬಿಳಿ ಬಾವಾಗಲಿ ಅಥವಾ ಕೆಂಪು ಬಿಳುಪು ಮಿಶ್ರವಾಗಿ ಹೊಳೆಯುವ ಕಲೆಯಾಗಲಿ ಉಂಟಾದರೆ ಅವನು ತನ್ನನ್ನು ಯಾಜಕನಿಗೆ ತೋರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಕಲೆ ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿ ಕಂಡರೆ ಮತ್ತು ಅದರಲ್ಲಿರುವ ರೋಮ ಬೆಳ್ಳಗಾಗಿ ಹೋಗಿದ್ದರೆ ಆ ಹುಣ್ಣಿನಲ್ಲಿ ಕುಷ್ಠ ಹುಟ್ಟಿದ್ದರಿಂದ ಅವನು ಅಶುದ್ಧನೆಂದು ಯಾಜಕನು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ಆದರೆ ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಅದರಲ್ಲಿ ಬಿಳಿ ರೋಮವಿಲ್ಲದೆ ಹೋದರೆ ಮತ್ತು ಆ ಕಲೆ ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿರದೆ ಮೊಬ್ಬಾಗಿದ್ದರೆ ಯಾಜಕನು ಅವನನ್ನು ಏಳು ದಿನಗಳು ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ತರುವಾಯ ಅದು ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಂಡಿದ್ದರೆ ಯಾಜಕನು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು; ಅದು ಕುಷ್ಠರೋಗವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ಆದರೆ ಆ ಹೊಳೆಯುವ ಕಲೆ ಹರಡಿಕೊಳ್ಳದೆ ಮೊದಲಿದ್ದಂತೆಯೇ ಇದ್ದರೆ ಅದು ಆ ಹುಣ್ಣಿನ ಕಲೆಯೆಂದು ತಿಳಿದುಕೊಂಡು ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ಒಬ್ಬನ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಬೆಂಕಿಯಿಂದುಂಟಾದ ಬೊಬ್ಬೆ ಇರಲಾಗಿ ಆ ಬೊಬ್ಬೆಯ ಸ್ಥಳವು ಹೊಳೆಯುವ ಕಲೆಯಾಗಿ ಬೆಳ್ಳಗಾಗಿಯಾಗಲಿ ಕೆಂಪು ಬಿಳುಪು ಮಿಶ್ರವಾಗಿ ಇದ್ದರೆ ಯಾಜಕನು ಅದನ್ನು ನೋಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ಅವನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಹೊಳೆಯುವ ಕಲೆಯಲ್ಲಿರುವ ರೋಮವು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ ಮತ್ತು ಆ ಕಲೆಯು ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿ ತೋರಿದರೆ ಅದು ಆ ಬೊಬ್ಬೆಯಲ್ಲಿ ಹುಟ್ಟಿದ ಕುಷ್ಠವೆಂದು ತಿಳಿದು ಯಾಜಕನು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ಆದರೆ ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಹೊಳೆಯುವ ಕಲೆಯಲ್ಲಿ ಬಿಳಿ ರೋಮವಿಲ್ಲದೆ ಹೋದರೆ ಮತ್ತು ಅದು ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿ ಕಾಣದೆ, ಮೊಬ್ಬಾಗಿ ಹೋಗಿದ್ದರೆ ಯಾಜಕನು ಅವನನ್ನು ಏಳು ದಿನಗಳ ತನಕ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸುವಾಗ ಅದು ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಂಡಿದ್ದರೆ ಅದು ಕುಷ್ಠರೋಗವೆಂದು ತಿಳಿದು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ಆ ಹೊಳೆಯುವ ಕಲೆಯು ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಳ್ಳದೆ ಮೊದಲಿನಂತೆಯೇ ಇದ್ದು ಮೊಬ್ಬಾಗಿಹೋಗಿದ್ದರೆ ಅದು ಬೆಂಕಿಸುಟ್ಟ ಬೊಬ್ಬೆಯೆಂದು ತಿಳಿದು ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ಅದು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟ ಕಲೆಯೇ ಹೊರತು ಮತ್ತೇನೂ ಅಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ಹೆಂಗಸಿನ ತಲೆಯಲ್ಲಿ ಆಗಲಿ, ಗಂಡಸಿನ ತಲೆಯಲ್ಲಿ ಆಗಲಿ ಅಥವಾ ಗಡ್ಡದ ಮೇಲೆ ಆಗಲಿ ಕಲೆಯುಂಟಾದರೆ ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ಆಗ ಅದು ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿ ತೋರಿದರೆ ಮತ್ತು ಅದರಲ್ಲಿ ಹಳದಿಬಣ್ಣವುಳ್ಳ ಸಣ್ಣ ಕೂದಲು ಇದ್ದರೆ ಅದು ತಲೆಯಲ್ಲಾಗಲಿ ಅಥವಾ ಗಡ್ಡದಲ್ಲಾಗಲಿ ಉಂಟಾದ ಕುಷ್ಠವನ್ನು ಸೂಚಿಸುವ ಲಕ್ಷಣವಿದ್ದರೆ ಯಾಜಕನು ಅಂಥವನನ್ನು ಅಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ಯಾಜಕನು ಆ ಗಾಯವನ್ನು ನೋಡುವಾಗ ಅದು ಬೇರೆ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿ ಕಾಣದೆ ಹೋದಾಗ್ಯೂ, ಅದು ಇರುವ ಭಾಗದಲ್ಲಿ ಕಪ್ಪು ಕೂದಲು ಇಲ್ಲದಿದ್ದರೆ ಯಾಜಕನು ಅವನನ್ನು ಏಳು ದಿನಗಳ ತನಕ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಗಾಯ ಹರಡಿಕೊಳ್ಳದೆ ಇದ್ದರೆ ಮತ್ತು ಅದು ಇರುವ ಭಾಗದಲ್ಲಿ ಹಳದಿ ಬಣ್ಣದ ಕೂದಲು ಇಲ್ಲದಿದ್ದರೆ ಮತ್ತು ಅದು ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿ ಕಾಣದೆಹೋದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ಅವನು ಕ್ಷೌರಮಾಡಿಸಿಕೊಳ್ಳಬೇಕು. ಆ ಗಾಯ ಇರುವ ಭಾಗವನ್ನು ಮಾತ್ರ ಕ್ಷೌರಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು. ಯಾಜಕನು ಅವನನ್ನು ಇನ್ನು ಏಳು ದಿನಗಳವರೆಗೂ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಪುನಃ ಆ ಗಾಯವನ್ನು ನೋಡುವಾಗ ಅದು ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಳ್ಳದೆ ಹೋಗಿದ್ದರೆ ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ಆಳವಾಗಿ ತೋರದೆ ಇದ್ದರೆ ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡಾಗ ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ಆದರೆ ಅವನು ಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಲ್ಪಟ್ಟ ಮೇಲೆ ಆ ಗಾಯ ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಂಡರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು; ಆದರೆ ಹಳದಿಬಣ್ಣದ ಕೂದಲು ಇದೆಯೋ ಇಲ್ಲವೋ ಎಂದು ನೋಡಬೇಕಾದ ಅಗತ್ಯವಿಲ್ಲ; ಅವನು ಅಶುದ್ಧನೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ಆ ಗಾಯ ಮೊದಲು ಇದ್ದಂತೆಯೇ ಇದ್ದು ಅದರಲ್ಲಿ ಕಪ್ಪು ಕೂದಲು ಹುಟ್ಟಿದ್ದರೆ ಅದು ವಾಸಿಯಾಯಿತು. ಅವನು ಶುದ್ಧನು; ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ಪುರುಷನಿಗಾಗಲಿ ಅಥವಾ ಸ್ತ್ರೀಗಾಗಲಿ ಚರ್ಮದಲ್ಲಿ ಹೊಳೆಯುವ ಬಿಳುಪಾದ ಕಲೆಗಳು ಅಲ್ಲಲ್ಲಿ ಹುಟ್ಟಿದ್ದರೆ ಯಾಜಕನು ಅವುಗಳನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ಆ ಹೊಳೆಯುವ ಕಲೆಗಳು ಮೊಬ್ಬಾದ ಬಿಳೀ ಬಣ್ಣವಾಗಿದ್ದರೆ ಅದು ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಹುಟ್ಟಿದ ಚಿಬ್ಬು; ಅವನು ಶುದ್ಧನು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ಯಾವನ ತಲೆಯ ಕೂದಲು ಉದುರಿ ಹೋಗಿ ಅವನು ಬೋಳುತಲೆಯವನಾದರೂ ಅವನು ಶುದ್ಧನೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ಮುಂದಲೆಯ ಕೂದಲು ಉದುರಿದರೆ ಅವನು ಪಟ್ಟೆತಲೆಯವನಾದರೂ ಶುದ್ಧನೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ಆದರೆ ಬೋಳುತಲೆಯಲ್ಲಾಗಲಿ ಅಥವಾ ಪಟ್ಟೆತಲೆಯಲ್ಲಾಗಲಿ ಕೆಂಪು ಬಿಳುಪು ಮಿಶ್ರವಾದ ಮಚ್ಚೆ ಹುಟ್ಟಿದರೆ ಅದು ಕುಷ್ಠವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಆಗ ಅದರಿಂದುಂಟಾದ ಬಾವು ಕೆಂಪು ಬಿಳುಪು ಮಿಶ್ರವಾಗಿ ಚರ್ಮದಲ್ಲಿನ ಕುಷ್ಠದಂತೆ ತೋರಿದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ಅವನು ಕುಷ್ಠರೋಗಿ ಮತ್ತು ಅಶುದ್ಧನು. ಅವನ ತಲೆಯ ಮೇಲೆ ಕುಷ್ಠದ ಗುರುತು ಕಾಣಿಸಿದ್ದರಿಂದ ಅವನು ಅಶುದ್ಧನೆಂದು ಯಾಜಕನು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ಯಾರಲ್ಲಿ ಕುಷ್ಠದ ಗುರುತು ಕಾಣಿಸಿತೋ ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡು, ತಲೆಯನ್ನು ಕೆದರಿಕೊಂಡು, ಬಾಯಿಯನ್ನು ಬಟ್ಟೆಯಿಂದ ಮುಚ್ಚಿಕೊಂಡು ‘ನಾನು ಅಶುದ್ಧನು, ಅಶುದ್ಧನು’ ಎಂದು ಕೂಗಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ಆ ರೋಗದ ಗುರುತುಗಳು ಅವನಲ್ಲಿ ಇರುವ ದಿನಗಳೆಲ್ಲಾ ಅವನು ಅಶುದ್ಧನಾಗಿರುವನು. ಅವನು ಅಶುದ್ಧನಾದುದರಿಂದ ಪ್ರತ್ಯೇಕವಾಗಿಯೇ ವಾಸವಾಗಿರಬೇಕು; ಅವನ ನಿವಾಸವು ಪಾಳೆಯದ ಹೊರಗೆ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ಕುಷ್ಠರೋಗದ ಗುರುತು ಬಟ್ಟೆಯಲ್ಲಿ ಕಂಡು ಬಂದಾಗ ಅದು ಉಣ್ಣೆಯ ಬಟ್ಟೆಯಾಗಲಿ ಅಥವಾ ನಾರಿನ ಬಟ್ಟೆಯಾಗಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ನಾರಿನ ಅಥವಾ ಉಣ್ಣೆಯ ಹಾಸಿನಲ್ಲಾಗಲಿ, ಹೆಣಿಗೆಯಲ್ಲಾಗಲಿ ಇಲ್ಲವೆ ತೊಗಲಿನಲ್ಲಾಗಲಿ, ತೊಗಲಿನಿಂದ ಮಾಡಲ್ಪಟ್ಟ ವಸ್ತುವಿನಲ್ಲಾಗಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ಆ ಬಟ್ಟೆ, ತೊಗಲು, ಹಾಸು, ಹೆಣಿಗೆ, ತೊಗಲಿನ ಸಾಮಾನುಗಳಲ್ಲಿ ಹಸುರಾಗಿ ಇಲ್ಲವೆ ಕೆಂಪಾಗಿ ಮಚ್ಚೆಕಾಣಿಸಿದರೆ ಅದು ಕುಷ್ಠದ ಗುರುತು; ಅದನ್ನು ಯಾಜಕನಿಗೆ ತೋರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಿ ನೋಡಿ ಏಳು ದಿನಗಳ ವರೆಗೆ ಪ್ರತ್ಯೇಕವಾಗಿ ಇಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಅವನು ಅದನ್ನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಬಟ್ಟೆಯ ಹಾಸಿನಲ್ಲಾಗಲಿ ಅಥವಾ ಹೆಣಿಗೆಯಲ್ಲಾಗಲಿ ಇಲ್ಲವೆ ಯಾವುದಾದರೂ ಒಂದು ಕೆಲಸಕ್ಕೆ ಉಪಯೋಗವಾಗಿರುವ ಆ ತೊಗಲಿನಲ್ಲಿ ಆ ಮಚ್ಚೆ ಹರಡಿಕೊಂಡಿದ್ದರೆ ಅದು ಪ್ರಾಣಕ್ಕೆ ಅಪಾಯಕರವಾದ ಕುಷ್ಠವೇ, ಆ ವಸ್ತುವು ಅಶುದ್ಧ. ");
INSERT INTO kanirv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ಆ ವಸ್ತುವು ಬಟ್ಟೆಯಾದರೂ, ಹಾಸಾದರೂ, ಹೊಕ್ಕಾದರೂ, ಉಣ್ಣೆಯದಾದರೂ, ನಾರಿನದಾದರೂ ಅಥವಾ ತೊಗಲಿನದಾದರೂ ಅದರಲ್ಲಿ ಪ್ರಾಣಕ್ಕೆ ಅಪಾಯಕರವಾದ ಕುಷ್ಠವಿರುವುದರಿಂದ ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಡಿಸಿಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","ಆದರೆ ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ವಸ್ತುವಿನಲ್ಲಿ ಅಂದರೆ ಆ ಬಟ್ಟೆ, ಹಾಸು, ಹೆಣಿಗೆ, ತೊಗಲಿನ ಸಾಮಾನು ಇವುಗಳಲ್ಲಿ ಆ ಮಚ್ಚೆ ಹರಡಿಕೊಳ್ಳದಿದ್ದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ಅದನ್ನು ನೀರಿನಿಂದ ತೊಳೆಯಬೇಕೆಂದು ಯಾಜಕನು ಅಪ್ಪಣೆಕೊಟ್ಟು ಇನ್ನು ಏಳು ದಿನಗಳ ತನಕ ಅದನ್ನು ಪ್ರತ್ಯೇಕವಾಗಿ ಇಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ಆ ಮಚ್ಚೆ ಇದ್ದ ವಸ್ತುಗಳನ್ನು ತೊಳೆಸಿದ ಮೇಲೆ ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ಮಚ್ಚೆಯು ಹರಡಿಕೊಳ್ಳದೆ ಇದ್ದಾಗ್ಯೂ ಅದರ ಬಣ್ಣ ಮೊದಲಿದ್ದಂತೆಯೇ ಇದ್ದರೆ ಆ ವಸ್ತು ಅಶುದ್ಧ. ಕುಷ್ಠರೋಗದ ಗುರುತು ಅದರ ಮೇಲ್ಭಾಗದಿಂದಾಗಲಿ ಅಥವಾ ಕೆಳಭಾಗದಿಂದಾಗಲಿ ಆ ವಸ್ತುವಿನೊಳಗೆ ವ್ಯಾಪಿಸಿದ್ದರಿಂದ ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ಆದರೆ ತೊಳೆದ ಬಟ್ಟೆಯನ್ನು ಯಾಜಕನು ಪರೀಕ್ಷಿಸುವಾಗ ಅದರಲ್ಲಿದ್ದ ಮಚ್ಚೆ ಮೊಬ್ಬಾಗಿಹೋಗಿದ್ದರೆ ಅವನು ಆ ಮಚ್ಚೆ ಇರುವ ಭಾಗವನ್ನು ಆ ಬಟ್ಟೆಯಿಂದಾಗಲಿ, ತೊಗಲಿನಿಂದಾಗಲಿ, ಹಾಸಿನಿಂದಾಗಲಿ, ಹೆಣಿಗೆಯಿಂದಾಗಲಿ ಕತ್ತರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ಆ ಮೇಲೆಯೂ ಕುಷ್ಠದ ಮಚ್ಚೆ ಆ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ಹಾಸಿನಲ್ಲಾಗಲಿ, ಹೆಣಿಗೆಯಲ್ಲಾಗಲಿ ಅಥವಾ ತೊಗಲಿನ ಸಾಮಾನಿನಲ್ಲಾಗಲಿ ಕಂಡು ಬಂದರೆ ಕುಷ್ಠರೋಗವು ಇನ್ನು ಅದರಲ್ಲಿ ಉಂಟೆಂದು ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ಆ ಮಚ್ಚೆ ಇರುವ ವಸ್ತುವನ್ನೇ ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ಆ ಬಟ್ಟೆಯನ್ನಾಗಲಿ, ಹಾಸನ್ನಾಗಲಿ, ಹೆಣಿಗೆಯನ್ನಾಗಲಿ ಅಥವಾ ತೊಗಲಿನ ಸಾಮಾನನ್ನಾಗಲಿ ತೊಳೆದನಂತರ ಆ ಮಚ್ಚೆ ಕಾಣದೆಹೋದರೆ ಅದನ್ನು ಎರಡನೆಯ ಸಾರಿ ತೊಳೆಯಬೇಕು; ಆಗ ಅದು ಶುದ್ಧವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“ಉಣ್ಣೇ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ನಾರಿನ ಬಟ್ಟೆಯಲ್ಲಾಗಲಿ, ಹಾಸಿನಲ್ಲಾಗಲಿ, ಹೆಣಿಗೆಯಲ್ಲಾಗಲಿ ಅಥವಾ ತೊಗಲಿನ ಸಾಮಾನಿನಲ್ಲಾಗಲಿ ಕಂಡುಬಂದ ಕುಷ್ಠರೋಗದ ಗುರುತಿನ ವಿಷಯವಾದ ನಿಯಮ ಇದೇ. ಅದು ಶುದ್ಧವೆಂದು ನಿರ್ಣಯಿಸಬೇಕೋ ಅಥವಾ ಅಶುದ್ಧವೆಂದು ನಿರ್ಣಯಿಸಬೇಕೋ ಎಂಬುದು ಇದರಿಂದ ತಿಳಿಯುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“ಕುಷ್ಠರೋಗಿಯು ಶುದ್ಧನಾಗುವ ದಿನದಲ್ಲಿ ಅವನ ವಿಷಯವಾಗಿ ನಡೆಸಬೇಕಾದ ಕ್ರಮ ಹೇಗೆಂದರೆ, ಅವನನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಹೋಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ಯಾಜಕನು ಪಾಳೆಯದ ಹೊರಗೆ ಹೋಗಿ ಅವನಲ್ಲಿರುವ ಕುಷ್ಠವು ವಾಸಿಯಾಗಿದೆಯೋ ಎಂದು ಪರೀಕ್ಷಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ವಾಸಿಯಾಗಿದೆ ಎಂದು ಕಂಡು ಬಂದರೆ ಶುದ್ಧ ಮಾಡಿಸಿಕೊಳ್ಳುವವನಿಗಾಗಿ ಸಜೀವವಾದ ಮತ್ತು ಶುದ್ಧವಾದ ಎರಡು ಪಕ್ಷಿಗಳನ್ನು, ದೇವದಾರಿನ ಕಟ್ಟಿಗೆಯನ್ನು, ರಕ್ತವರ್ಣವುಳ್ಳ ದಾರವನ್ನು ಮತ್ತು ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಬರಲನ್ನು ತರಬೇಕೆಂದು ಯಾಜಕನು ಆಜ್ಞಾಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ಆ ಪಕ್ಷಿಗಳಲ್ಲಿ ಒಂದನ್ನು ಹರಿಯುವ ನೀರಿನ ಮೇಲೆ ಮಣ್ಣಿನ ಪಾತ್ರೆಯಲ್ಲಿ ವಧಿಸಬೇಕೆಂದು ಯಾಜಕನು ಆಜ್ಞಾಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","“ಅವನು ಮತ್ತೊಂದು ಪಕ್ಷಿಯನ್ನು, ಆ ದೇವದಾರಿನ ಕಟ್ಟಿಗೆಯನ್ನು, ರಕ್ತವರ್ಣವುಳ್ಳ ದಾರವನ್ನು ಮತ್ತು ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಬರಲನ್ನು ತೆಗೆದುಕೊಂಡು ಹರಿಯುವ ನೀರಿನ ಮೇಲೆ ವಧಿಸಿದ ಆ ಮೊದಲನೆಯ ಪಕ್ಷಿಯ ರಕ್ತದಲ್ಲಿ ಈ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ಮತ್ತು ಆ ಪಕ್ಷಿಯನ್ನು ಸಜೀವವಾಗಿಯೇ ಅದ್ದಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ಆಮೇಲೆ ಅವನು ಕುಷ್ಠರೋಗದ ವಿಷಯದಲ್ಲಿ ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನ ಮೇಲೆ ಏಳು ಸಾರಿ ಆ ರಕ್ತವನ್ನು ಚಿಮುಕಿಸಿ, ಅವನನ್ನು ಶುದ್ಧನೆಂದು ನಿರ್ಣಯಿಸಿ, ಆ ಜೀವವುಳ್ಳ ಪಕ್ಷಿಯನ್ನು ಅಡವಿಯ ಕಡೆಗೆ ಬಿಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","ಆಗ ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು, ಸರ್ವಾಂಗಕ್ಷೌರ ಮಾಡಿಸಿಕೊಂಡು ಸ್ನಾನಮಾಡಿದ ಮೇಲೆ ಶುದ್ಧನಾಗುವನು; ತರುವಾಯ ಅವನು ಪಾಳೆಯದೊಳಗೆ ಬರಬಹುದು; ಆದರೂ ಏಳು ದಿನಗಳ ತನಕ ತನ್ನ ಡೇರೆಯ ಹೊರಗೆ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ಏಳನೆಯ ದಿನದಲ್ಲಿ ತನ್ನ ತಲೆಗೂದಲು, ಗಡ್ಡ, ಹುಬ್ಬು, ಮೈಗೂದಲು ಇವುಗಳನ್ನೆಲ್ಲಾ ಕ್ಷೌರಮಾಡಿಸಿಕೊಂಡು, ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು. ಆಗ ಅವನು ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಅವನು ಪೂರ್ಣಾಂಗವಾದ ಎರಡು ಟಗರುಗಳನ್ನು, ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು, ನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಒಂಭತ್ತು ಸೇರು ಗೋದಿಹಿಟ್ಟನ್ನು ಮತ್ತು ಒಂದು ಸೇರು ಎಣ್ಣೆಯನ್ನು ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ಶುದ್ಧಿ ಮಾಡುವ ಯಾಜಕನು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನನ್ನು ಇವುಗಳೊಂದಿಗೆ ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ಯಾಜಕನು ಆ ಟಗರುಗಳಲ್ಲಿ ಒಂದನ್ನು ಮತ್ತು ಆ ಒಂದು ಸೇರು ಎಣ್ಣೆಯನ್ನು ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞವಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ಅವುಗಳನ್ನು ನೈವೇದ್ಯವಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿವಾಳಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಪಶುವನ್ನು ಮತ್ತು ಸರ್ವಾಂಗಹೋಮ ಪಶುವನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲೇ ಅಂದರೆ ದೇವಸ್ಥಾನದ ಪ್ರಾಕಾರದೊಳಗೆ ಆ ಟಗರು ವಧಿಸಲ್ಪಡಬೇಕು. ಏಕೆಂದರೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ್ರವ್ಯದಂತೆಯೇ ಪ್ರಾಯಶ್ಚಿತ್ತ ಯಜ್ಞದ್ರವ್ಯವೂ ಯಾಜಕನಿಗೆ ಸಲ್ಲತಕ್ಕದ್ದು, ಅದು ಮಹಾಪರಿಶುದ್ಧವಾಗಿವೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ಆಗ ಯಾಜಕನು ಆ ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞ ಪಶುವಿನ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನ ಬಲಗಿವಿಯ ತುದಿಗೂ, ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಮತ್ತು ಬಲಗಾಲಿನ ಹೆಬ್ಬೆರಳಿಗೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ಆಗ ಯಾಜಕನು ಆ ಒಂದು ಸೇರು ಎಣ್ಣೆಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತನ್ನ ಎಡಗೈಯಲ್ಲಿ ಹೊಯ್ದುಕೊಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ತನ್ನ ಬಲಗೈಯ ಬೆರಳನ್ನು ಅದರಲ್ಲಿ ಅದ್ದಿ, ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಏಳು ಸಾರಿ ಬೆರಳಿನಿಂದ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ಯಾಜಕನು ತನ್ನ ಕೈಯಲ್ಲಿರುವ ಉಳಿದ ಎಣ್ಣೆಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಶುದ್ಧ ಮಾಡಿಸಿಕೊಳ್ಳುವವನ ಬಲಗಿವಿಯ ತುದಿಗೂ, ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಮತ್ತು ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞ ಪಶುವಿನ ರಕ್ತವನ್ನು ಹಚ್ಚಿದ ಸ್ಥಳಗಳಲ್ಲಿಯೇ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ಅವನು ತನ್ನ ಕೈಯಲ್ಲಿರುವ ಉಳಿದ ಎಣ್ಣೆಯನ್ನು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನ ತಲೆಯ ಮೇಲೆ ಹೊಯ್ದುಬಿಡಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅವನ ದೋಷವನ್ನು ಪರಿಹರಿಸುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“ಅದಲ್ಲದೆ ಯಾಜಕನು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನ ಅಪವಿತ್ರತೆಯನ್ನು ಹೋಗಲಾಡಿಸುವುದಕ್ಕೆ ಆ ಕುರಿಯನ್ನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಸಮರ್ಪಿಸಿ ಅವನ ದೋಷವನ್ನು ಪರಿಹರಿಸುವನು. ಆ ಮೇಲೆ ಯಾಜಕನು ಆ ಎರಡನೆಯ ಟಗರುಮರಿಯನ್ನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ವಧಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ಅವನು ಆ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಮತ್ತು ಧಾನ್ಯನೈವೇದ್ಯವನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಸಮರ್ಪಿಸಬೇಕು. ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ಹೀಗೆ ದೋಷಪರಿಹಾರ ಮಾಡಿದಾಗ ಅವನು ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“ಅವನು ಬಡವನಾಗಿದ್ದು ಅಷ್ಟನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕೆ ಆಗದಿದ್ದರೆ ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಟಗರುಮರಿಯನ್ನು ತಂದು ದೋಷಪರಿಹಾರ ಮಾಡಿಸಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಯಾಜಕನ ಕೈಯಿಂದ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕು; ಮತ್ತು ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಹತ್ತರಲ್ಲಿ ಒಂದು ಭಾಗ ಎಣ್ಣೆ ಕಲಸಿದ ಗೋದಿಹಿಟ್ಟನ್ನು ಮತ್ತು ಒಂದು ಸೇರು ಎಣ್ಣೆಯನ್ನು ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ಅದಲ್ಲದೆ ಅವನು ತನ್ನ ಸ್ಥಿತಿಗೆ ತಕ್ಕಂತೆ ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತಂದು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಒಂದನ್ನು, ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಮತ್ತೊಂದನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ಅವನು ತನ್ನ ಶುದ್ಧೀಕರಣಕ್ಕಾಗಿ ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಇವುಗಳನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತಂದು ಯಾಜಕನಿಗೆ ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ಯಾಜಕನು ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞದ ಕುರಿಯನ್ನು, ಒಂದು ಸೇರು ಎಣ್ಣೆಯನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞದ ಕುರಿಯನ್ನು ವಧಿಸಿದನಂತರ ಯಾಜಕನು ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವವನ ಬಲಗಿವಿಯ ತುದಿಗೂ, ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಮತ್ತು ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ಅನಂತರ ಯಾಜಕನು ಆ ಎಣ್ಣೆಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತನ್ನ ಎಡಗೈಯಲ್ಲಿ ಹೊಯ್ದುಕೊಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ಅದರಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಬಲಗೈಯ ಬೆರಳಿನಿಂದ ಏಳು ಸಾರಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ಆಮೇಲೆ ಯಾಜಕನು ತನ್ನ ಕೈಯಲ್ಲಿರುವ ಎಣ್ಣೆಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಶುದ್ಧ ಮಾಡಿಸಿಕೊಳ್ಳುವವನ ಬಲಗಿವಿಯ ತುದಿಗೂ, ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ, ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞ ಪಶುವಿನ ರಕ್ತವನ್ನು ಹಚ್ಚಿದ ಸ್ಥಳಗಳಲ್ಲಿಯೇ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ಶುದ್ಧ ಮಾಡಿಸಿಕೊಳ್ಳುವವನಿಗಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡುವುದಕ್ಕಾಗಿ ಯಾಜಕನು ತನ್ನ ಕೈಯಲ್ಲಿರುವ ಉಳಿದ ಎಣ್ಣೆಯನ್ನೆಲ್ಲಾ ಅವನ ತಲೆಯ ಮೇಲೆ ಹೊಯ್ಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ತರುವಾಯ ಅವನು ತನ್ನ ಸ್ಥಿತಿಗೆ ತಕ್ಕಂತೆ ತಂದ ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ");
INSERT INTO kanirv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಒಂದನ್ನು ಮತ್ತು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಮತ್ತೊಂದನ್ನು ಧಾನ್ಯನೈವೇದ್ಯದೊಂದಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಶುದ್ಧ ಮಾಡಿಸಿಕೊಳ್ಳುವವನಿಗಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","“ಶುದ್ಧೀಕರಣ ಯಜ್ಞಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ಗತಿಯಿಲ್ಲದ ಕುಷ್ಠರೋಗಿಯ ವಿಷಯದಲ್ಲಿ ಇದೇ ನಿಯಮ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ನಾನು ನಿಮಗೆ ಸ್ವದೇಶವಾಗಿ ಕೊಡುವ ಕಾನಾನ್ ದೇಶಕ್ಕೆ ನೀವು ಬಂದ ನಂತರ ಆ ದೇಶದ ಯಾವ ಮನೆಯ ಗೋಡೆಗಳಲ್ಲಿ ನಾನು ಕುಷ್ಠದ ಗುರುತನ್ನು ಉಂಟುಮಾಡುವೆನೋ, ");
INSERT INTO kanirv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ಆ ಮನೆಯ ಒಡೆಯನು ಯಾಜಕನ ಬಳಿಗೆ ಬಂದು, ‘ನನ್ನ ಮನೆಯಲ್ಲಿ ಕುಷ್ಠರೋಗದ ಗುರುತು ಉಂಟಾದಂತೆ ತೋರುತ್ತದೆ’ ಎಂದು ಅವನಿಗೆ ತಿಳಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ಯಾಜಕನು ತಾನು ಆ ರೋಗದ ಗುರುತನ್ನು ನೋಡಲು ಬರುವುದಕ್ಕೆ ಮೊದಲು ಆ ಮನೆಯನ್ನು ಬರಿದುಮಾಡಲು ಆಜ್ಞಾಪಿಸಬೇಕು. ಹಾಗೆ ಬರಿದುಮಾಡದಿದ್ದರೆ ಆ ಮನೆಯಲ್ಲಿರುವ ಎಲ್ಲಾ ವಸ್ತುಗಳೂ ಅಶುದ್ಧವಾಗುತ್ತದೆ. ಬರಿದುಮಾಡಿದ ಮೇಲೆ ಯಾಜಕನು ಆ ಮನೆಯನ್ನು ನೋಡುವುದಕ್ಕೆ ಒಳಗೆ ಹೋಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ಅವನು ಮನೆಯ ಗೋಡೆಗಳಲ್ಲಿರುವ ರೋಗದ ಗುರುತುಗಳನ್ನು ಪರೀಕ್ಷಿಸಿ ನೋಡುವಾಗ ಆ ಗುರುತುಗಳು ಹಸುರಾಗಿ ಅಥವಾ ಕೆಂಪಾಗಿ ಇದ್ದು, ಗೋಡೆಯ ಮಟ್ಟಕ್ಕಿಂತ ಆಳವಾಗಿ ತೋರಿದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ಯಾಜಕನು ಹೊರಗೆ ಬಂದು ಆ ಮನೆಯನ್ನು ಏಳು ದಿನಗಳವರೆಗೂ ಮುಚ್ಚಿಸಿಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಬಂದು ಪರೀಕ್ಷಿಸಿ ನೋಡುವಾಗ ಆ ಗುರುತು ಮನೆಯ ಗೋಡೆಗಳಲ್ಲಿ ಹಬ್ಬಿಕೊಂಡಿದ್ದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ಆ ಗುರುತುಗಳು ಇರುವ ಕಲ್ಲುಗಳನ್ನು ತೆಗೆದುಬಿಟ್ಟು, ಊರಿನ ಹೊರಗೆ ಅಪವಿತ್ರವಾದ ಸ್ಥಳದಲ್ಲಿ ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ಅದಲ್ಲದೆ ಅವನು ಆ ಮನೆಯ ಗೋಡೆಗಳ ಒಳಗೋಡೆಯನ್ನೆಲ್ಲಾ ಕೆರೆದು, ಅದರ ಮಣ್ಣನ್ನು ಊರಿನ ಹೊರಗೆ ಅಪವಿತ್ರ ಸ್ಥಳದಲ್ಲಿ ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ಆಗ ಅವರು ಬೇರೆ ಕಲ್ಲುಗಳನ್ನು ತರಿಸಿ ಮೊದಲಿದ್ದ ಕಲ್ಲುಗಳ ಸ್ಥಳದಲ್ಲಿ ಹಾಕಿಸಿ, ಹೊಸ ಮಣ್ಣನ್ನು ತರಿಸಿ ಆ ಗೋಡೆಗಳಿಗೆ ಗಿಲಾವು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ಅವನು ಆ ಕಲ್ಲುಗಳನ್ನು ತೆಗಿಸಿ, ಮನೆಯ ಗೋಡೆಗಳನ್ನು ಕೆರೆದು ಗಿಲಾವು ಮಾಡಿಸಿದ ಮೇಲೆ ಆ ರೋಗದ ಗುರುತು ಪುನಃ ಕಂಡುಬಂದರೆ ಯಾಜಕನು ಬಂದು ಅದನ್ನು ನೋಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ಆ ಗುರುತು ಮನೆಯ ಗೋಡೆಗಳಲ್ಲಿ ಹಬ್ಬಿಕೊಂಡಿದ್ದರೆ ಅದು ಪ್ರಾಣಹಾನಿಕರವಾದ ಕುಷ್ಠವೇ; ಆ ಮನೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ಅವನು ಆ ಮನೆಯನ್ನು ಕೆಡವಿ, ಅದರ ಎಲ್ಲಾ ಕಲ್ಲುಗಳನ್ನು, ತೊಲೆಗಳನ್ನು ಮತ್ತು ಮಣ್ಣನ್ನು ಊರಿನ ಹೊರಗೆ ಅಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ಆ ಮನೆಯು ಮುಚ್ಚಿರುವ ದಿನಗಳಲ್ಲಿ ಯಾವನಾದರೂ ಒಳಕ್ಕೆ ಹೋದರೆ ಅವನು ಆ ದಿನದ ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ಆ ಮನೆಯಲ್ಲಿ ಮಲಗಿಕೊಂಡವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು; ಅಲ್ಲಿ ಊಟಮಾಡಿದವನೂ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“ಆದರೆ ತಾನು ಆ ಮನೆಗೆ ಹೊಸದಾಗಿ ಗಿಲಾವು ಮಾಡಿಸಿದ ಮೇಲೆ ಯಾಜಕನು ಬಂದು ಪರೀಕ್ಷಿಸುವಾಗ ಆ ರೋಗದ ಗುರುತು ಕಾಣಿಸದೆಹೋದರೆ, ರೋಗಪರಿಹಾರವಾಗಿ ಆ ಮನೆ ಶುದ್ಧವಾಯಿತೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ಆ ಮನೆಯ ಶುದ್ಧೀಕರಣಕ್ಕಾಗಿ ಅವನು ಎರಡು ಪಕ್ಷಿಗಳನ್ನು, ದೇವದಾರಿನ ಕಟ್ಟಿಗೆಯನ್ನು, ರಕ್ತವರ್ಣವುಳ್ಳ ದಾರವನ್ನು ಮತ್ತು ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಬರಲನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ಅವನು ಒಂದು ಪಕ್ಷಿಯನ್ನು ಒರತೆ ನೀರಿನ ಮೇಲೆ ಮಣ್ಣಿನ ಪಾತ್ರೆಯಲ್ಲಿ ವಧಿಸಬೇಕು, ");
INSERT INTO kanirv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ಆ ದೇವದಾರಿನ ಕಟ್ಟಿಗೆಯನ್ನು, ಹಿಸ್ಸೋಪಿನ ಬರಲನ್ನು, ರಕ್ತವರ್ಣವುಳ್ಳ ದಾರವನ್ನು ಮತ್ತು ಸಜೀವವಾದ ಮತ್ತೊಂದು ಪಕ್ಷಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ತಾನು ವಧಿಸಿದ ಪಕ್ಷಿಯ ರಕ್ತದಲ್ಲಿಯೂ ಹಾಗು ಒರತೆಯ ನೀರಿನಲ್ಲಿಯೂ ಅದ್ದಿ ಏಳು ಸಾರಿ ಆ ಮನೆಯ ಗೋಡೆಗಳಿಗೆ ಪ್ರೋಕ್ಷಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ಹಾಗೆ ಆ ಪಕ್ಷಿಯ ರಕ್ತ, ಸೆಲೇ ನೀರು, ಸಜೀವಪಕ್ಷಿ, ದೇವದಾರಿನ ಕಟ್ಟಿಗೆ, ಹಿಸ್ಸೋಪು, ರಕ್ತವರ್ಣದ ದಾರ ಇವುಗಳಿಂದ ಆ ಮನೆಯನ್ನು ಅವನು ಶುದ್ಧಿಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ಅವನು ಆ ಜೀವವುಳ್ಳ ಪಕ್ಷಿಯನ್ನು ಊರ ಹೊರಕ್ಕೆ ಅಡವಿಯ ಕಡೆಗೆ ಬಿಟ್ಟುಬಿಡಬೇಕು. ಹೀಗೆ ಅವನು ಆ ಮನೆಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡಿದಾಗ ಅದು ಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“ನಾನಾ ವಿಧವಾದ ಕುಷ್ಠರೋಗದ ಗುರುತುಗಳು ಅಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ಕೂದಲು ಬೆಳೆಯದ ಗಾಯ, ಬಟ್ಟೆಯಲ್ಲಿ ಅಥವಾ ಮನೆಯ ಗೋಡೆಯಲ್ಲಿ ಕಾಣಿಸುವ ಕುಷ್ಠ ರೋಗದ ಗುರುತು, ");
INSERT INTO kanirv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ಶರೀರದ ಚರ್ಮದ ಮೇಲೆ ಉಂಟಾಗುವ ಬಾವು, ಗುಳ್ಳೆ, ಹೊಳೆಯುವ ಕಲೆ ");
INSERT INTO kanirv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ಇವುಗಳಲ್ಲಿ ಶುದ್ಧ ಅಥವಾ ಅಶುದ್ಧದ ಭೇದವನ್ನು ತಿಳಿಸುವ ನಿಯಮ ಇದೇ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ನೀವು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕಾದದ್ದೇನೆಂದರೆ, ‘ಒಬ್ಬನ ಜನನೇಂದ್ರಿಯದಲ್ಲಿ ಮೇಹಸ್ರಾವವಾದರೆ ಅದರಿಂದ ಅವನು ಅಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ಆ ಸ್ರಾವವು ಹರಿಯುತ್ತಿದ್ದರು ಅಥವಾ ನಿಂತುಹೋಗಿದ್ದರು ಆ ದೇಹಸ್ಥಿತಿಯಿಂದ ಅವನು ಅಶುದ್ಧನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","ಅಂಥವನು ಮಲಗಿರುವ ಪ್ರತಿಯೊಂದು ಹಾಸಿಗೆಯೂ ಮತ್ತು ಕುಳಿತಿರುವ ಪ್ರತಿಯೊಂದು ಆಸನವೂ ಅಶುದ್ಧವು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ಅವನ ಹಾಸಿಗೆಯನ್ನು ಮುಟ್ಟಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು; ಅವನು ಆ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ಸ್ರಾವವುಳ್ಳವನು ಕುಳಿತಿದ್ದ ಆಸನದ ಮೇಲೆ ಕುಳಿತುಕೊಂಡವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು, ಅವನು ಆ ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","ಅವನ ಶರೀರವನ್ನು ಮುಟ್ಟಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು, ಅವನು ಆ ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ಶುದ್ಧನಾಗಿರುವವನ ಮೇಲೆ ಸ್ರಾವವುಳ್ಳವನು ಉಗುಳಿದರೆ ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು; ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ಸ್ರಾವವುಳ್ಳವನು ಕುಳಿತ್ತಿದ್ದ ತಡಿಯು ಅಶುದ್ಧವು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ಅವನ ಕೆಳಗಿದ್ದ ಯಾವ ವಸ್ತುವನ್ನಾದರೂ ಮುಟ್ಟಿದವನು ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ಅಂತಹ ವಸ್ತುವನ್ನು ಎತ್ತಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು; ಅವನು ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ಸ್ರಾವವುಳ್ಳವನು ಕೈಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳದೆ ಯಾವನನ್ನು ಮುಟ್ಟಿದರೂ ಆ ಮನುಷ್ಯನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು, ಅವನು ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ಸ್ರಾವವುಳ್ಳವನು ಮುಟ್ಟಿದ ಮಣ್ಣಿನ ಪಾತ್ರೆಯನ್ನು ಒಡೆದುಬಿಡಬೇಕು. ಅವನು ಮರದ ಪಾತ್ರೆಯನ್ನು ಮುಟ್ಟಿದರೆ ಅದನ್ನು ನೀರಿನಿಂದ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“‘ಸ್ರಾವವುಳ್ಳವನ ಸ್ರಾವವು ನಿಂತು ವಾಸಿಯಾದಾಗ, ಅವನು ಶುದ್ಧಮಾಡಿಸಿಕೊಳ್ಳುವುದಕ್ಕೆ ಆ ದಿನದಿಂದ ಏಳು ದಿನಗಳನ್ನು ಲೆಕ್ಕಮಾಡಿ, ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು, ಹರಿಯುವ ನೀರಿನಿಂದ ತನ್ನ ಶರೀರವನ್ನು ತೊಳೆದುಕೊಂಡು ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಬಂದು ಯಾಜಕನಿಗೆ ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ಯಾಜಕನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದನ್ನು ಮತ್ತು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಇನ್ನೊಂದನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಅವನ ಸ್ರಾವದ ವಿಷಯದಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅವನಿಗಾಗಿ ದೋಷಪರಿಹಾರ ಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“‘ಒಬ್ಬನಿಗೆ ವೀರ್ಯಸ್ಖಲನವಾದರೆ ಅವನು ಸರ್ವಾಂಗ ಸ್ನಾನಮಾಡಬೇಕು, ಅವನು ಆ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ಯಾವ ಬಟ್ಟೆಯ ಮೇಲಾಗಲಿ ಅಥವಾ ತೊಗಲಿನ ಮೇಲಾಗಲಿ ವೀರ್ಯವು ಬಿದ್ದರೆ ಅದನ್ನು ನೀರಿನಿಂದ ತೊಳೆಯಬೇಕು, ಅದು ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ಪುರುಷನಿಗೆ ಸ್ತ್ರೀಸಂಗದಿಂದ ವೀರ್ಯಸ್ಖಲನವಾದರೆ ಅವರಿಬ್ಬರೂ ಸ್ನಾನಮಾಡಿಕೊಳ್ಳಬೇಕು; ಅವರು ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“‘ಸ್ತ್ರೀಗೆ ರಕ್ತಸ್ರಾವವಾದರೆ ಅವಳು ಏಳು ದಿನಗಳ ತನಕ ಪ್ರತ್ಯೇಕವಾಗಿರಬೇಕು. ಅವಳನ್ನು ಮುಟ್ಟಿದವರು ಆ ದಿನದ ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ಅವಳು ಮುಟ್ಟಾಗಿರುವಾಗ ಯಾವುದರ ಮೇಲೆ ಮಲಗಿದರು ಅಥವಾ ಕುಳಿತುಕೊಂಡರು ಅದು ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ಅವಳ ಹಾಸಿಗೆಯನ್ನು ಮುಟ್ಟಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು; ಅವನು ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ಅವಳು ಯಾವುದರ ಮೇಲೆ ಕುಳಿತ್ತಿದ್ದಳೋ ಅದನ್ನು ಮುಟ್ಟಿದವರು ಅವರ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು; ಅವರು ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ಅವಳು ಮಲಗಿದ್ದ ಹಾಸಿಗೆಯ ಮೇಲಾಗಲಿ ಅಥವಾ ಕುಳಿತ್ತಿದ್ದ ಸ್ಥಳದ ಮೇಲಾಗಲಿ ಇದ್ದ ಯಾವುದನ್ನಾದರೂ ಮುಟ್ಟಿದವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ಪುರುಷನು ಒಂದು ವೇಳೆ ಅಂಥವಳೊಡನೆ ಸಂಗಮಿಸಿದರೆ, ಅವಳ ಋತುಸ್ರಾವ ಅವನಿಗೆ ತಗುಲಿದರೆ, ಅವನು ಏಳು ದಿನಗಳ ತನಕ ಅಶುದ್ಧನಾಗಿರುವನು. ಅಷ್ಟರಲ್ಲಿ ಅವನು ಯಾವ ಹಾಸಿಗೆಯ ಮೇಲೆ ಮಲಗಿಕೊಂಡರೂ ಅದು ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“‘ಸ್ತ್ರೀಗೆ ಮುಟ್ಟಿನ ಕಾಲದಲ್ಲಿ ಮಾತ್ರವಲ್ಲದೆ ಬೇರೆ ದಿನಗಳಲ್ಲಿಯೂ ರಕ್ತಸ್ರಾವವಾದರೆ, ಇಲ್ಲವೆ ಮುಟ್ಟಿನ ಕಾಲಕ್ಕಿಂತ ಹೆಚ್ಚು ದಿನಗಳು ರಕ್ತಸ್ರಾವವಾದರೆ ಅವಳು ತಿಂಗಳಿನ ಮುಟ್ಟಿನಿಂದ ಹೇಗೆ ಅಶುದ್ಧಳೋ ಹಾಗೆಯೇ ಆ ಸ್ರಾವವಾಗುವ ದಿನಗಳಲ್ಲೆಲ್ಲಾ ಅಶುದ್ಧಳಾಗಿರುವಳು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ಆ ಸ್ರಾವವಿರುವ ತನಕ ಅವಳು ಯಾವ ಹಾಸಿಗೆಯ ಮೇಲೆ ಮಲಗಿದರೂ ಅದು ಮುಟ್ಟಿನ ಕಾಲದಲ್ಲಿ ಮಲಗಿದ ಹಾಸಿಗೆಯಂತೆಯೇ ಅಶುದ್ಧವಾಗುವುದು. ಅವಳು ಯಾವುದರ ಮೇಲೆ ಕುಳಿತುಕೊಂಡರೂ ಅದು ಮುಟ್ಟಿನ ಕಾಲದಲ್ಲಿ ಕುಳಿತುಕೊಂಡ ವಸ್ತುವಿನಂತೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ಆ ವಸ್ತುಗಳನ್ನು ಮುಟ್ಟಿದವನು ಅಶುದ್ಧನಾದ್ದರಿಂದ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು; ಅವನು ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ಅವಳಿಗೆ ರಕ್ತಸ್ರಾವ ನಿಂತ ದಿನದಿಂದ ಅವಳು ಏಳು ದಿನಗಳನ್ನು ಲೆಕ್ಕ ಹಾಕಿಕೊಂಡ ತರುವಾಯ ಶುದ್ಧಳಾಗುವಳು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಅವಳು ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ಯಾಜಕನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದನ್ನು ಮತ್ತು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಇನ್ನೊಂದನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಅವಳ ಸ್ರಾವದಿಂದುಂಟಾದ ಅಶುದ್ಧತೆಯ ವಿಷಯವಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅವಳಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“‘ಇಸ್ರಾಯೇಲರು ಅಶುದ್ಧತೆಗೆ ದೂರವಾಗಿರುವಂತೆ ನೀವು ಅವರನ್ನು ಈ ರೀತಿಯಾಗಿ ಕಾಪಾಡಬೇಕು. ಅವರು ಅಪವಿತ್ರರಾಗಿದ್ದು ತಮ್ಮ ಮಧ್ಯದಲ್ಲಿರುವ ನನ್ನ ಗುಡಾರವನ್ನು ಹೊಲೆಮಾಡಿದರೆ ನಾಶವಾಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“‘ಮೇಹಸ್ರಾವವುಳ್ಳವನು, ವೀರ್ಯಸ್ಖಲನದಿಂದ ಅಶುದ್ಧನಾದವನು, ");
INSERT INTO kanirv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ಮುಟ್ಟಾದ ಸ್ತ್ರೀಯು, ಸ್ರಾವವುಂಟಾಗುವ ಸ್ತ್ರೀ ಮತ್ತು ಪುರುಷರು, ಅಶುದ್ಧಳಾದ ಸ್ತ್ರೀಯನ್ನು ಸಂಗಮಿಸಿದವನು ಇವರ ವಿಷಯವಾಗಿ ಇದೇ ನಿಯಮ’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ಆರೋನನ ಇಬ್ಬರು ಮಕ್ಕಳು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಬಂದು ನಾಶವಾದ ಮೇಲೆ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನು ಮನಸ್ಸಿಗೆ ಬಂದಾಗೆಲ್ಲಾ ತೆರೆಯನ್ನು ದಾಟಿ ಮಹಾಪವಿತ್ರವಾದ ಸ್ಥಾನದೊಳಕ್ಕೆ ಮಂಜೂಷದ ಮೇಲಣ ಕೃಪಾಸನದ ಹತ್ತಿರಕ್ಕೆ ಬರಬಾರದೆಂದು ಅವನಿಗೆ ಹೇಳು. ನಾನು ಕೃಪಾಸನದ ಮೇಲೆ ಮೇಘದಲ್ಲಿ ಕಾಣಿಸಿಕೊಳ್ಳುವುದರಿಂದ ಅವನು ನಾಶವಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ಆರೋನನು ಮಹಾಪವಿತ್ರಸ್ಥಾನದೊಳಗೆ ಬರುವಾಗ ಮುಂದೆ ಹೇಳುವ ರೀತಿಯಲ್ಲಿ ಬರಬೇಕು. ಅವನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಹೋರಿಯನ್ನು ಮತ್ತು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಟಗರನ್ನು ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ಅವನು ಪರಿಶುದ್ಧವಾದ ನಾರಿನ ನಿಲುವಂಗಿಯನ್ನು ತೊಟ್ಟುಕೊಂಡು, ನಾರಿನ ಒಳಉಡುಪನ್ನು ಹಾಕಿಕೊಂಡು, ನಾರಿನ ನಡುಕಟ್ಟನ್ನು ಕಟ್ಟಿಕೊಂಡು ಮತ್ತು ತಲೆಗೆ ನಾರಿನ ಪೇಟವನ್ನು ಸುತ್ತಿಕೊಳ್ಳಬೇಕು. ಅವು ದೀಕ್ಷಾವಸ್ತ್ರಗಳಾದುದರಿಂದ ಅವನು ಅವುಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳುವುದಕ್ಕೆ ಮುಂಚೆ ಸ್ನಾನಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ಇಸ್ರಾಯೇಲರ ಜನಸಮೂಹದಿಂದ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋತಗಳನ್ನು ಮತ್ತು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಟಗರನ್ನು ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ಆರೋನನು ತನಗಾಗಿಯೂ ಮತ್ತು ತನ್ನ ಮನೆತನದವರಿಗಾಗಿಯೂ ದೋಷಪರಿಹಾರ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ಆ ಎರಡು ಹೋತಗಳನ್ನು ಅವನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ಆಗ ಅವನು ಆ ಹೋತಗಳಲ್ಲಿ ಒಂದು ಯೆಹೋವನಿಗೋಸ್ಕರವೆಂದು ಮತ್ತೊಂದು ಅಜಾಜೇಲನಿಗೋಸ್ಕರವೆಂದು ಚೀಟುಗಳನ್ನು ಬರೆದು ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ಯಾವ ಹೋತ ಯೆಹೋವನದೆಂದು ಗೊತ್ತಾಗುವುದೋ ಅದನ್ನು ಆರೋನನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ಯಾವ ಹೋತ ಅಜಾಜೇಲನದೆಂದು ಗೊತ್ತಾಗುವುದೋ ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಜೀವವಾಗಿಯೇ ನಿಲ್ಲಿಸಿ, ಅದರ ಮೇಲೆ ದೋಷವನ್ನು ಹೊರಿಸಿ ಅರಣ್ಯಕ್ಕೆ ಅಜಾಜೇಲನಿಗಾಗಿ ಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“ಆರೋನನು ತನಗಾಗಿ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ಹೋರಿಯನ್ನು ಸಮರ್ಪಿಸಿ ತನಗಾಗಿಯೂ ಮತ್ತು ತನ್ನ ಮನೆತನದವರಿಗಾಗಿಯೂ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ಅವನು ತನಗೋಸ್ಕರ ಹೋರಿಯನ್ನು ವಧಿಸಿದ ಮೇಲೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಯಜ್ಞವೇದಿಯಿಂದ ಕೆಂಡಗಳನ್ನು ಧೂಪಾರತಿಯಲ್ಲಿ ತುಂಬಿಸಿ, ಪರಿಮಳಧೂಪದ್ರವ್ಯದ ಚೂರ್ಣದಲ್ಲಿ ಎರಡು ಹಿಡಿ ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ತೆರೆಯೊಳಗೆ ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ಅವನು ಆ ಧೂಪವನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿಯೇ ಕೆಂಡಗಳ ಮೇಲೆ ಹಾಕಬೇಕು. ಅವನಿಗೆ ಪ್ರಾಣನಷ್ಟವಾಗದಂತೆ ಆ ಧೂಪದ ಹೊಗೆಯು ಮೇಘದೋಪಾದಿಯಲ್ಲಿ ಆಜ್ಞಾಶಾಸನಗಳ ಮೇಲಣ ಕೃಪಾಸನವನ್ನು ಆವರಿಸಿಕೊಳ್ಳುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ಆಗ ಅವನು ಆ ಹೋರಿಯ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಕೃಪಾಸನದ ಪೂರ್ವಭಾಗದ ಮೇಲೆ ಬೆರಳಿನಿಂದ ಚಿಮುಕಿಸಿ ಕೃಪಾಸನದ ಎದುರಾಗಿಯೂ ಏಳು ಸಾರಿ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ತರುವಾಯ ಅವನು ಜನರಿಗಾಗಿ ಮಾಡಿದ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ಹೋತವನ್ನು ವಧಿಸಿ, ಅದರ ರಕ್ತವನ್ನು ತೆರೆಯೊಳಗೆ ತಂದು, ಹೋರಿಯ ರಕ್ತದಿಂದ ಮಾಡಿದಂತೆಯೇ ಇದರ ರಕ್ತದಿಂದಲೂ ಮಾಡಿ, ಕೃಪಾಸನದ ಮೇಲೆಯೂ ಮತ್ತು ಅದರ ಎದುರಾಗಿಯೂ ಚಿಮುಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ಹೀಗೆ ಇಸ್ರಾಯೇಲರು ನಾನಾ ವಿಧವಾದ ಅಶುದ್ಧತ್ವ, ಅಪರಾಧ, ದ್ರೋಹ ಇವುಗಳಿಂದ ಮಹಾಪವಿತ್ರಸ್ಥಾನಕ್ಕೆ ಉಂಟುಮಾಡಿದ ದೋಷವನ್ನು ಆರೋನನು ಪರಿಹರಿಸುವನು. ಅಶುದ್ಧರಾದ ಅವರ ನಡುವೆ ಇರುವ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೋಸ್ಕರವೂ ಅವನು ಹಾಗೆಯೇ ದೋಷಪರಿಹಾರ ಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ಅವನು ದೋಷಪರಿಹಾರ ಮಾಡುವುದಕ್ಕಾಗಿ ಮಹಾ ಪವಿತ್ರಸ್ಥಾನದೊಳಗೆ ಹೋಗಿ ಹೊರಗೆ ಬರುವ ತನಕ ಯಾರೂ ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಹೋಗಬಾರದು. ಹಾಗೆ ತನಗಾಗಿಯೂ, ತನ್ನ ಮನೆತನದವರಿಗಾಗಿಯೂ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಎಲ್ಲಾ ಜನಸಮೂಹಕ್ಕಾಗಿಯೂ ದೋಷಪರಿಹಾರ ಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ತರುವಾಯ ಅವನು ಹೊರಗೆ ಬಂದು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಯಜ್ಞವೇದಿಯ ಬಳಿಗೆ ಹೋಗಿ ಅದಕ್ಕಾಗಿ ದೋಷಪರಿಹಾರ ಮಾಡಬೇಕು. ಆ ಹೋರಿಯ ರಕ್ತದಲ್ಲಿಯೂ ಹಾಗೂ ಆ ಹೋತದ ರಕ್ತದಲ್ಲಿಯೂ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಕೊಂಬುಗಳಿಗೆ ಸುತ್ತಲೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ಅವನು ಆ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಅದರ ಮೇಲೆ ಏಳು ಸಾರಿ ಬೆರಳಿನಿಂದ ಚಿಮುಕಿಸಿ ಇಸ್ರಾಯೇಲರಿಂದ ಅದಕ್ಕೆ ಉಂಟಾದ ಅಶುದ್ಧತ್ವವನ್ನು ಹೋಗಲಾಡಿಸಿ ಅದನ್ನು ಪರಿಶುದ್ಧಪಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“ಆರೋನನು ಮಹಾಪವಿತ್ರಸ್ಥಾನ, ದೇವದರ್ಶನದ ಗುಡಾರ, ಯಜ್ಞವೇದಿ ಇವುಗಳಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡಿ ಮುಗಿಸಿದ ಮೇಲೆ ಆ ಸಜೀವವಾದ ಹೋತವನ್ನು ತರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ಅವನು ಅದರ ತಲೆಯ ಮೇಲೆ ಎರಡು ಕೈಗಳನ್ನು ಇಟ್ಟು, ಇಸ್ರಾಯೇಲರ ಎಲ್ಲಾ ಪಾಪಗಳನ್ನು, ದ್ರೋಹಗಳನ್ನು ಮತ್ತು ಅಪರಾಧಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಅರಿಕೆಮಾಡಿ ಆ ಹೋತದ ತಲೆಯ ಮೇಲೆ ಹೊರಿಸಿ, ಅದನ್ನು ಆ ಕೆಲಸಕ್ಕೆ ನೇಮಕವಾದವನ ಕೈಯಿಂದ ಅರಣ್ಯಕ್ಕೆ ಕಳುಹಿಸಿಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ಆ ಹೋತ ಅವರ ಎಲ್ಲಾ ಪಾಪಗಳನ್ನು ತನ್ನ ಮೇಲೆ ಹೊತ್ತುಕೊಂಡು ನಿರ್ಜನವಾದ ಪ್ರದೇಶಕ್ಕೆ ಹೋಗುವಂತೆ ಆ ಮನುಷ್ಯನು ಅದನ್ನು ಅರಣ್ಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡುಹೋಗಿ ಅಲ್ಲೇ ಬಿಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“ತರುವಾಯ ಆರೋನನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಬಂದು ತಾನು ಮಹಾಪವಿತ್ರಸ್ಥಾನದೊಳಗೆ ಹೋಗುವುದಕ್ಕಾಗಿ ಧರಿಸಿಕೊಂಡಿದ್ದ ನಾರುಮಡಿಗಳನ್ನು ತೆಗೆದು ಅಲ್ಲೇ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ಅವನು ಪವಿತ್ರ ಸ್ಥಳದ ಪ್ರಾಕಾರದಲ್ಲಿ ಸ್ನಾನಮಾಡಿ, ತನ್ನ ವಸ್ತ್ರಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ಆಗ ಅವನು ಹೊರಗೆ ಬಂದು ತನಗಾಗಿಯೂ ಮತ್ತು ಜನಸಮೂಹಕ್ಕಾಗಿಯೂ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನು ಸಮರ್ಪಿಸಿ, ತನಗಾಗಿಯೂ ಮತ್ತು ಜನರಿಗಾಗಿಯೂ ದೋಷಪರಿಹಾರ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ಅವನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಪಶುಗಳ ಕೊಬ್ಬನ್ನು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“ಅಜಾಜೇಲನಿಗೆ ಹೋತವನ್ನು ಬಿಟ್ಟುಬಂದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಿಯೇ ಪಾಳೆಯಕ್ಕೆ ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಪಶುಗಳಾದ ಹೋರಿ ಮತ್ತು ಹೋತಗಳ ರಕ್ತವನ್ನು ಮಹಾಪವಿತ್ರಸ್ಥಾನದಲ್ಲಿ ದೋಷಪರಿಹಾರ ಮಾಡುವುದಕ್ಕಾಗಿ ತಂದ ಮೇಲೆ ಅವುಗಳ ಶರೀರಗಳನ್ನು ಪಾಳೆಯದ ಆಚೆಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ, ಚರ್ಮ, ಮಾಂಸ ಮತ್ತು ಕಲ್ಮಷಗಳೆಲ್ಲವನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ಅವುಗಳನ್ನು ಸುಟ್ಟವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಿಯೇ ಪಾಳೆಯದೊಳಗೆ ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ಸ್ವದೇಶಸ್ಥರಾದ ನೀವೂ ಮತ್ತು ನಿಮ್ಮಲ್ಲಿ ವಾಸವಾಗಿರುವ ಅನ್ಯದೇಶದವರು, ಎಲ್ಲರೂ ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ಸಕಲ ವಿಧವಾದ ಕೆಲಸಗಳನ್ನು ಬಿಟ್ಟು ಉಪವಾಸಮಾಡಿ ನಿಮ್ಮ ಆತ್ಮಗಳನ್ನು ಕುಂದಿಸಿಕೊಳ್ಳಬೇಕು. ಇದು ನಿಮಗೆ ಶಾಶ್ವತವಾದ ನಿಯಮ. ");
INSERT INTO kanirv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ಏಕೆಂದರೆ ನೀವು ಪರಿಶುದ್ಧರಾಗುವುದಕ್ಕಾಗಿ ಈ ದಿನದಲ್ಲಿ ನಿಮಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವಾಗುವುದು, ಯೆಹೋವನ ದೃಷ್ಟಿಯಲ್ಲಿ ನಿಮ್ಮ ಎಲ್ಲಾ ದೋಷಗಳು ನಿವಾರಣೆಯಾಗುವವು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ಈ ದಿನ ನೀವು ಸಂಪೂರ್ಣವಾಗಿ ಕೆಲಸವನ್ನು ನಿಲ್ಲಿಸಬೇಕಾದ ಸಬ್ಬತ್ ದಿನವಾಗಿರಬೇಕು; ಇದರಲ್ಲಿ ನೀವು ಉಪವಾಸ ಮಾಡಬೇಕು; ಇದೇ ನಿಮಗೆ ಶಾಶ್ವತನಿಯಮ. ");
INSERT INTO kanirv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“ಆರೋನನ ವಂಶದವರಲ್ಲಿ ಯಾವನಿಗೆ ಪಿತೃಸ್ಥಾನದಲ್ಲಿ ಮಹಾಯಾಜಕನ ಸೇವಾವೃತ್ತಿಯನ್ನು ನಡೆಸುವುದಕ್ಕೆ ಪಟ್ಟಾಭಿಷೇಕವಾಗುವುದೋ ಅವನೇ ಈ ದೋಷಪರಿಹಾರ ಕಾರ್ಯವನ್ನು ಆಚರಿಸಬೇಕು. ಅವನೇ ಆ ಪರಿಶುದ್ಧವಾದ ನಾರುಮಡಿಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ಅವನು ದೇವಸ್ಥಾನ, ದೇವದರ್ಶನದ ಗುಡಾರ, ಯಜ್ಞವೇದಿ, ಯಾಜಕರು, ಜನಸಮೂಹದವರು ಈ ಎಲ್ಲರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ಇಸ್ರಾಯೇಲರ ಎಲ್ಲಾ ದೋಷಗಳನ್ನು ನಿವಾರಣೆಮಾಡುವುದಕ್ಕಾಗಿ ಅವರಿಗೋಸ್ಕರ ವರ್ಷಕ್ಕೆ ಒಂದಾವರ್ತಿ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಬೇಕೆಂಬುದೇ ನಿಮಗೆ ಶಾಶ್ವತನಿಯಮ” ಎಂದು ಹೇಳಿದನು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಆರೋನನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“ನೀನು ಆರೋನನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ ಮತ್ತು ಇಸ್ರಾಯೇಲರಿಗೂ ಹೀಗೆ ಹೇಳಬೇಕು, ");
INSERT INTO kanirv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸುವುದೇನೆಂದರೆ, ‘ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಯಾವನಾದರೂ ಹೋರಿಯನ್ನಾಗಲಿ, ಕುರಿಯನ್ನಾಗಲಿ ಅಥವಾ ಆಡನ್ನಾಗಲಿ ಕೊಯ್ಯುವಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ಅದನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವುದಕ್ಕಾಗಿ ಆತನ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತಾರದೆ, ಪಾಳೆಯದ ಒಳಗಾಗಲಿ ಅಥವಾ ಹೊರಗಾಗಲಿ ವಧಿಸಿದರೆ ಅವನನ್ನು ಕೊಲೆಪಾತಕನೆಂದು ನೀವು ನಿರ್ಣಯಿಸಬೇಕು. ಅವನು ರಕ್ತವನ್ನು ಸುರಿಸಿದವನಾದುದರಿಂದ ಕುಲದಿಂದ ಹೊರಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ಏಕೆಂದರೆ ಯಜ್ಞಪಶುಗಳನ್ನು ಬಯಲಿನಲ್ಲಿ ವಧಿಸುತ್ತಿದ್ದ ಇಸ್ರಾಯೇಲರು ಇನ್ನು ಮೇಲೆ ಅವುಗಳನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಯಾಜಕನ ಬಳಿಗೆ ತಂದು, ಯೆಹೋವನ ಮುಂದೆ ಸಮಾಧಾನಯಜ್ಞವಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ಯಾಜಕನು ಅವುಗಳ ರಕ್ತವನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಮುಂದಿರುವ ಯಜ್ಞವೇದಿಗೆ ಎರಚಿ, ಅವುಗಳ ಕೊಬ್ಬನ್ನು ಹೋಮಮಾಡಿ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ಅವರು ಇದುವರೆಗೆ ಪೂಜಿಸುತ್ತಿದ್ದ ಅಜದೇವತೆಗಳಿಗೆ ಇನ್ನು ಮುಂದೆ ಬಲಿಕೊಟ್ಟು ದೇವದ್ರೋಹಿಗಳಾಗಬಾರದು. ಅವರಿಗೂ ಮತ್ತು ಅವರ ಸಂತತಿಯವರಿಗೂ ಇದು ಶಾಶ್ವತನಿಯಮ.’ ");
INSERT INTO kanirv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ಇದಲ್ಲದೆ ನೀನು ಅವರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ಇಸ್ರಾಯೇಲರಲ್ಲಾಗಲಿ ಅಥವಾ ಅವರ ನಡುವೆ ವಾಸಮಾಡುತ್ತಿರುವ ಅನ್ಯದೇಶದವರಲ್ಲಿಯಾಗಲಿ ಯಾರಾದರೂ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಅಥವಾ, ");
INSERT INTO kanirv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ಬೇರೆ ವಿಧವಾದ ಯಜ್ಞವನ್ನು ಮಾಡುವಾಗ ಅದರ ಪಶುವನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವುದಕ್ಕಾಗಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತೆಗೆದುಕೊಂಡು ಬಾರದಿದ್ದರೆ ಅವನು ಕುಲದಿಂದ ಹೊರಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“‘ಇದಲ್ಲದೆ ಇಸ್ರಾಯೇಲರಲ್ಲಾಗಲಿ ಅಥವಾ ಅವರ ನಡುವೆ ವಾಸವಾಗಿರುವ ಅನ್ಯದೇಶದವರಲ್ಲಾಗಲಿ ಯಾವನಾದರೂ ರಕ್ತಭೋಜನಮಾಡಿದರೆ ನಾನು ಆತನ ಮೇಲೆ ಉಗ್ರವಾದ ಕೋಪವನ್ನು ಮಾಡಿ ಅವನನ್ನು ಕುಲದಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ಏಕೆಂದರೆ ಪ್ರತಿದೇಹಿಗೂ ರಕ್ತವೇ ಪ್ರಾಣಾಧಾರ. ಅಂತಹ ರಕ್ತವನ್ನು ನೀವು ಯಜ್ಞವೇದಿಗೆ ಎರಚಿ ನಿಮಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡಿಕೊಳ್ಳಬೇಕೆಂದು ನಿಮಗೆ ಅನುಗ್ರಹ ಮಾಡಿದ್ದೇನೆ. ರಕ್ತವು ಪ್ರಾಣಾಧಾರವಾಗಿರುವ ಕಾರಣ ಅದರಿಂದ ದೋಷಪರಿಹಾರ ಆಗುತ್ತದಷ್ಟೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ಆದುದರಿಂದ ನಿಮ್ಮಲ್ಲಿಯಾಗಲಿ ಅಥವಾ ನಿಮ್ಮ ನಡುವೆ ವಾಸವಾಗಿರುವ ಅನ್ಯದೇಶದವರಲ್ಲಾಗಲಿ ಯಾರೂ ರಕ್ತಭೋಜನ ಮಾಡಬಾರದೆಂದು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“‘ಇಸ್ರಾಯೇಲರಲ್ಲಾಗಲಿ ಅವರ ನಡುವೆ ವಾಸವಾಗಿರುವ ಅನ್ಯದೇಶದವರಲ್ಲಿಯಾಗಲಿ ಯಾವನಾದರೂ ಬೇಟೆಯಾಡಿ ತಿನ್ನತಕ್ಕ ಮೃಗವನ್ನು ಇಲ್ಲವೆ ಪಕ್ಷಿಯನ್ನು ಹಿಡಿದರೆ ಅವನು ಅದರ ರಕ್ತವನ್ನು ಸುರಿಸಿ ಮಣ್ಣಿನಿಂದ ಮುಚ್ಚಿಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ಏಕೆಂದರೆ ಪ್ರತಿದೇಹಿಗೂ ರಕ್ತವೇ ಪ್ರಾಣಾಧಾರವು. ಆದಕಾರಣ ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ, ಪ್ರತಿಪ್ರಾಣಿಗೂ ರಕ್ತವೇ ಪ್ರಾಣಾಧಾರವಾದುದರಿಂದ ನೀವು ಯಾವ ವಿಧವಾದ ಪ್ರಾಣಿಯ ರಕ್ತವನ್ನು ಉಣ್ಣಬಾರದು; ರಕ್ತಭೋಜನ ಮಾಡಿದವನಿಗೆ ಬಹಿಷ್ಕಾರವಾಗಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“‘ತಾನಾಗಿ ಸತ್ತುಬಿದ್ದದ್ದನ್ನಾಗಲಿ ಅಥವಾ ಕಾಡುಮೃಗ ಕೊಂದದ್ದನ್ನು ತಿಂದವನಾಗಲಿ ಸ್ವದೇಶದವನಾದರೂ ಇಲ್ಲವೇ ಅನ್ಯದೇಶದವನಾದರೂ ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು; ಆ ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿದ್ದು ಬಳಿಕ ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳದೆ ಅಥವಾ ಸ್ನಾನ ಮಾಡದೆ ಹೋದರೆ ತನ್ನ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ನಾನು ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ನೀವು ವಾಸವಾಗಿದ್ದ ಐಗುಪ್ತ ದೇಶದ ಆಚಾರಗಳನ್ನು ಅನುಸರಿಸಬಾರದು; ನಾನು ನಿಮ್ಮನ್ನು ಬರಮಾಡುವ ಕಾನಾನ್ ದೇಶದ ಆಚರಣೆಗಳನ್ನು ನೀವು ಅನುಸರಿಸಬಾರದು, ಅವರಲ್ಲಿರುವ ನಿಯಮಗಳಿಗೆ ನೀವು ಒಳಗಾಗಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ಯೆಹೋವನೆಂಬ ನಾನೇ ನಿಮ್ಮ ದೇವರಾಗಿರುವುದರಿಂದ ನನ್ನ ನಿರ್ಣಯಗಳ ಪ್ರಕಾರವೇ ನೀವು ನಡೆಯಬೇಕು, ನನ್ನ ನಿಯಮಗಳನ್ನು ಅನುಸರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ನನ್ನ ಆಜ್ಞಾನಿಯಮಗಳ ಪ್ರಕಾರ ನಡೆದುಕೊಳ್ಳುವವರು ಆ ಆಜ್ಞಾನಿಯಮಗಳ ಮೂಲಕ ಬದುಕುವರು. ಆದುದರಿಂದ ನೀವು ಅವುಗಳನ್ನೇ ಅನುಸರಿಸಬೇಕು; ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“‘ನಿಮ್ಮಲ್ಲಿ ಯಾರೂ ರಕ್ತಸಂಬಂಧವುಳ್ಳ ಸ್ತ್ರೀಯ ಸಹವಾಸವನ್ನು ಮಾಡಬಾರದು, ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ತಾಯಿಯನ್ನು ಎಷ್ಟು ಮಾತ್ರವೂ ಸಂಗಮಿಸಬಾರದು, ಆಕೆ ಹೆತ್ತವಳಲ್ಲವೇ; ಸಂಗಮಿಸಿದರೆ ತಂದೆಗೆ ಮಾನಭಂಗವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ಮಲತಾಯಿಯ ಜೊತೆ ಸಂಗಮಿಸಬಾರದು; ಆಕೆ ತಂದೆಗೆ ಹೆಂಡತಿಯಾದವಳಲ್ಲವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ತಂದೆಯ ಮಗಳನ್ನಾಗಲಿ ಅಥವಾ ತಾಯಿಯ ಮಗಳನ್ನಾಗಲಿ ಸಂಗಮಿಸಬಾರದು; ಅವರು ಒಡ ಹುಟ್ಟಿದವರು ಇಲ್ಲವೇ ಪರಸ್ತ್ರೀಯಲ್ಲಿ ಹುಟ್ಟಿದವರಾದರೂ ನಿಮಗೆ ಅಕ್ಕತಂಗಿಯರಲ್ಲವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","ಮಗನ ಮಗಳೊಂದಿಗೆ ಅಥವಾ ಮಗಳ ಮಗಳೊಂದಿಗೆ ಸಂಗಮಿಸಬಾರದು; ಅವರು ನಿಮಗೆ ಮಕ್ಕಳಂತಲ್ಲವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ತಂದೆಯ ಮತ್ತೊಬ್ಬ ಹೆಂಡತಿಯಲ್ಲಿ ಹುಟ್ಟಿದವಳ ಜೊತೆ ಸಂಗಮಿಸಬಾರದು; ಆಕೆ ಸಹೋದರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ತಂದೆಯ ಒಡಹುಟ್ಟಿದವಳ ಸಂಗ ಮಾಡಬಾರದು; ಆಕೆ ನಿಮಗೆ ತಂದೆಯ ರಕ್ತಸಂಬಂಧಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ತಾಯಿಯ ಒಡಹುಟ್ಟಿದವಳ ಜೊತೆ ಸಂಗಮಿಸಬಾರದು; ಆಕೆ ನಿಮ್ಮ ತಾಯಿಯ ರಕ್ತಸಂಬಂಧಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ತಂದೆಯ ಅಣ್ಣತಮ್ಮಂದಿರ ಹೆಂಡತಿಯರ ಜೊತೆ ಸಂಗಮಿಸಬಾರದು. ಅವರು ನಿಮ್ಮ ದೊಡ್ಡಮ್ಮ ಇಲ್ಲವೇ ಚಿಕ್ಕಮ್ಮ ಅಲ್ಲವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ಸೊಸೆಯ ಸಹವಾಸ ಮಾಡಬಾರದು; ಆಕೆ ಮಗನ ಹೆಂಡತಿಯಾದವಳಲ್ಲವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ಅತ್ತಿಗೆ ಮತ್ತು ನಾದಿನಿಯರನ್ನು ಸಂಗಮಿಸಬಾರದು; ಅವರು ಅಣ್ಣ ಅಥವಾ ತಮ್ಮಂದಿರ ಹೆಂಡತಿಯರಲ್ಲವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ಒಬ್ಬ ಸ್ತ್ರೀಯನ್ನು ಮದುವೆಮಾಡಿಕೊಂಡರೆ ಆಕೆಯ ಮಗಳನ್ನಾಗಲಿ ಇಲ್ಲವೇ ಮೊಮ್ಮಗಳನ್ನಾಗಲಿ ಸಂಗಮಿಸಬಾರದು; ಅವರು ರಕ್ತಸಂಬಂಧಿಗಳಾದುದರಿಂದ ಅದು ದುಷ್ಟ ಕಾರ್ಯವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ಹೆಂಡತಿಯು ಜೀವದಿಂದಿರುವಾಗಲೇ ಆಕೆಯ ಒಡಹುಟ್ಟಿದವಳನ್ನು ಮದುವೆಮಾಡಿಕೊಂಡು ಹೆಂಡತಿಗೆ ಮನಸ್ತಾಪವನ್ನು ಉಂಟುಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“‘ಮುಟ್ಟಿನಿಂದ ಅಶುದ್ಧಳಾದ ಸ್ತ್ರೀಯನ್ನು ಸಂಗಮಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ಪರಸ್ತ್ರೀ ಸಂಗಮದಿಂದ ಅಶುದ್ಧರಾಗಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“‘ನಿಮ್ಮ ಮಕ್ಕಳಲ್ಲಿ ಯಾರನ್ನಾದರೂ ಮೋಲೆಕನಿಗೆ ಸಮರ್ಪಿಸಿ ನಿಮ್ಮ ದೇವರ ಹೆಸರನ್ನು ಅಪಕೀರ್ತಿಗೆ ಗುರಿಮಾಡಬಾರದು; ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“‘ಸ್ತ್ರೀಯನ್ನು ಸಂಗಮಿಸುವಂತೆ ಪುರುಷನನ್ನು ಸಂಗಮಿಸಬಾರದು; ಅದು ಅಸಹ್ಯವಾದ ಕೆಲಸ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","ಪಶುಸಂಗಮವನ್ನು ಮಾಡಿ ಅಶುದ್ಧರಾಗಬಾರದು. ಯಾವ ಸ್ತ್ರೀಯೂ ಸಂಗಮಕ್ಕಾಗಿ ಪಶುವಿನ ಮುಂದೆ ನಿಲ್ಲಬಾರದು; ಅದು ಸ್ವಭಾವಕ್ಕೆ ವಿರುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“‘ಈ ದುರಾಚಾರಗಳಲ್ಲಿ ಯಾವುದರಿಂದಲೂ ನೀವು ಅಶುದ್ಧರಾಗಬಾರದು. ನಾನು ನಿಮ್ಮ ಎದುರಿನಿಂದ ಮೊದಲು ಹೊರಡಿಸಿದ ಜನಾಂಗಗಳವರು ಇಂಥ ದುರಾಚಾರಗಳಿಂದ ಅಶುದ್ಧರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ಅವರ ದೇಶವು ಅಶುದ್ಧವಾಗಿ ಹೋದುದರಿಂದ ಅವರ ಪಾಪಕೃತ್ಯಗಳಿಗಾಗಿ ಅವರನ್ನು ಶಿಕ್ಷಿಸಿದ್ದೇನೆ; ಆ ದೇಶವು ತನ್ನಲ್ಲಿ ವಾಸಿಸುತ್ತಿದ ಜನರನ್ನು ತ್ಯಜಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ಆದುದರಿಂದ ಸ್ವದೇಶದವರಾದ ನಿಮ್ಮಲ್ಲಿಯೂ ಮತ್ತು ನಿಮ್ಮ ನಡುವೆ ವಾಸವಾಗಿರುವ ಅನ್ಯದೇಶದವರಲ್ಲಿಯೂ ಯಾರೂ ಈ ಅಸಹ್ಯವಾದ ಕಾರ್ಯಗಳಲ್ಲಿ ಒಂದನ್ನಾದರೂ ನಡೆಸದೆ ಎಲ್ಲರೂ ನನ್ನ ಆಜ್ಞಾವಿಧಿಗಳನ್ನು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ನಿಮಗಿಂತ ಮುಂಚೆ ಆ ದೇಶದಲ್ಲಿ ಇದ್ದವರು ಇಂಥ ಅಸಹ್ಯವಾದ ಕೆಲಸಗಳನ್ನು ಮಾಡಿದ್ದರಿಂದ ಆ ದೇಶವು ಅಶುದ್ಧವಾಗಿ ಹೋಯಿತಲ್ಲಾ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ಆ ದೇಶವು ನಿಮಗಿಂತ ಮುಂಚೆ ಇದ್ದ ಜನಾಂಗಗಳನ್ನು ತ್ಯಜಿಸಿದ ಪ್ರಕಾರವೇ ನಿಮ್ಮಿಂದ ಅಶುದ್ಧವಾದರೆ ನಿಮ್ಮನ್ನು ತ್ಯಜಿಸಿಬಿಡುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ಯಾವನಾದರೂ ಈ ಅಸಹ್ಯವಾದ ಕೆಲಸಗಳಲ್ಲಿ ಒಂದನ್ನಾದರೂ ಮಾಡಿದರೆ ಅವನನ್ನು ಕುಲದಿಂದ ಹೊರಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ಆದುದರಿಂದ ನಿಮಗಿಂತ ಮುಂಚೆ ನಡೆಯುತ್ತಿದ್ದ ಅಸಹ್ಯವಾದ ಆಚರಣೆಗಳನ್ನು ನಡೆಸಿ ನಿಮ್ಮನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳದೆ ನನ್ನ ನಿಯಮಗಳನ್ನೇ ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು; ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನೆಂಬ ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವುದರಿಂದ ನೀವೂ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“‘ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನ ತಾಯಿತಂದೆಗಳ ವಿಷಯದಲ್ಲಿ ಭಯಭಕ್ತಿಯಿಂದ ನಡೆದುಕೊಳ್ಳಬೇಕು. ನಾನು ನೇಮಿಸಿರುವ ಸಬ್ಬತ್ ದಿನಗಳನ್ನು ಆಚರಿಸಬೇಕು. ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“‘ಸುಳ್ಳುದೇವರುಗಳ ಕಡೆಗೆ ತಿರುಗಿಕೊಳ್ಳಬಾರದು; ದೇವರೆಂದು ಎರಕದ ವಿಗ್ರಹಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬಾರದು. ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“‘ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವಾಗ ಆತನಿಗೆ ಮೆಚ್ಚಿಕೆಯಾದ ರೀತಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ನೀವು ಮಾಡುವ ಯಜ್ಞದ ಮಾಂಸವನ್ನು ಆ ದಿನದಲ್ಲಿಯಾಗಲಿ ಇಲ್ಲವೇ ಮರುದಿನದಲ್ಲಿಯಾಗಲಿ ಊಟಮಾಡಬೇಕು. ಮೂರನೆಯ ದಿನದವರೆಗೆ ಏನಾದರೂ ಉಳಿದರೆ ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ಮೂರನೆಯ ದಿನದ ತನಕ ಉಳಿದದ್ದು ಹೇಯವಾದುದರಿಂದ ಅದರಲ್ಲಿ ಏನಾದರೂ ತಿಂದರೆ ಆ ಯಜ್ಞವು ಯೆಹೋವನಿಗೆ ಅಂಗೀಕಾರವಾಗುವುದೇ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ಅದರಲ್ಲಿ ಏನಾದರೂ ತಿಂದವನು ಯೆಹೋವನ ಪವಿತ್ರ ದ್ರವ್ಯವನ್ನು ಹೊಲೆಮಾಡಿದವನಾದುದರಿಂದ ತನ್ನ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು; ಅವನನ್ನು ಕುಲದಿಂದ ಹೊರಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“‘ನೀವು ಪೈರುಗಳನ್ನು ಕೊಯ್ಯುವಾಗ ಹೊಲಗಳ ಮೂಲೆಗಳಲ್ಲಿ ಇರುವುದನ್ನೆಲ್ಲಾ ಕೊಯ್ಯಬಾರದು ಮತ್ತು ಕೊಯ್ದಾಗ ಹಕ್ಕಲಾಯಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ದ್ರಾಕ್ಷಿಯ ತೋಟಗಳಲ್ಲಿಯೂ ಹಕ್ಕಲಾಯಬಾರದು; ಉದುರಿದ ಹಣ್ಣುಗಳನ್ನು ಆರಿಸಿಕೊಳ್ಳದೆ ಬಡವರಿಗೂ ಮತ್ತು ಪರದೇಶಿಗಳಿಗೂ ಬಿಟ್ಟುಬಿಡಬೇಕು. ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“‘ಕದಿಯಬಾರದು, “‘ಮೋಸಮಾಡಬಾರದು, “‘ಒಬ್ಬರಿಗೊಬ್ಬರು ಸುಳ್ಳು ಹೇಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“‘ನನ್ನ ಹೆಸರಿನ ಮೇಲೆ ಸುಳ್ಳಾಣೆಯಿಟ್ಟು ನಿಮ್ಮ ದೇವರ ನಾಮವನ್ನು ಅಪಕೀರ್ತಿಗೆ ಒಳಪಡಿಸಬಾರದು. ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“‘ಮತ್ತೊಬ್ಬನನ್ನು ಬಲಾತ್ಕರಿಸಬಾರದು ಅಥವಾ ಅವನ ಸೊತ್ತನ್ನು ಅಪಹರಿಸಬಾರದು. ಅವನ ಕೂಲಿಯನ್ನು ಮರುದಿನದ ವರೆಗೆ ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ಇಟ್ಟುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","ಕಿವುಡರನ್ನು ದೂಷಿಸಬಾರದು; ಕುರುಡರು ನಡೆಯುವ ದಾರಿಯಲ್ಲಿ ಅವರ ಕಾಲು ಎಡವುವಂತೆ ಕಲ್ಲನ್ನು ಇಡಬಾರದು; ನಿಮ್ಮ ದೇವರಿಗೆ ಭಯಭಕ್ತಿಯಿಂದ ನಡೆದುಕೊಳ್ಳಬೇಕು. ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“‘ವ್ಯಾಜ್ಯವನ್ನು ವಿಚಾರಿಸುವಾಗ ಅನ್ಯಾಯವಾದ ತೀರ್ಪನ್ನು ಮಾಡಬಾರದು. ಬಡವನ ಬಡತನವನ್ನಾಗಲಿ ಅಥವಾ ದೊಡ್ಡ ಮನುಷ್ಯನ ಘನತೆಯನ್ನಾಗಲಿ ಲಕ್ಷ್ಯಮಾಡದೆ, ಪಕ್ಷಪಾತವಿಲ್ಲದೆ ತೀರ್ಪನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“‘ಪರಿಚಯವುಳ್ಳವರಲ್ಲಿ ಒಬ್ಬರ ಮೇಲೊಬ್ಬರು ಚಾಡಿಹೇಳಬಾರದು. ನೆರೆಯವನಿಗೆ ಮರಣ ಶಿಕ್ಷೆಯಾಗಲೇಬೇಕು ಎಂದು ಹಠ ಹಿಡಿಯಬಾರದು. ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“‘ಸಹೋದರನ ವಿಷಯವಾಗಿ ಮನಸ್ಸಿನಲ್ಲಿ ದ್ವೇಷವನ್ನು ಇಟ್ಟುಕೊಳ್ಳಬಾರದು. ನೆರೆಯವನ ದೋಷಕ್ಕೆ ನೀವು ಒಳಗಾಗದಂತೆ ಅವನ ತಪ್ಪನ್ನು ಅವನಿಗೆ ತಿಳಿಸಲೇಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“‘ನಿಮ್ಮ ಸ್ವಜನರಲ್ಲಿ ಯಾರಿಗೂ ಕೇಡಿಗೆ ಕೇಡನ್ನು ಮಾಡದೆ, ಮನಸ್ಸಿನಲ್ಲಿ ಮತ್ಸರವನ್ನು ಇಟ್ಟುಕೊಳ್ಳದೆ, ನಿಮ್ಮ ನೆರೆಯವರನ್ನು ನಿಮ್ಮಂತೆಯೇ ಪ್ರೀತಿಸಬೇಕು. ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“‘ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ನೀವು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು. “‘ನಿಮ್ಮ ಪಶುಗಳನ್ನು ಬೇರೆ ಜಾತಿಯ ಪಶುಗಳೊಂದಿಗೆ ಕೂಡಿಸಿ ತಳಿಪಡಿಯಬಾರದು; “‘ನಿಮ್ಮ ಹೊಲಗಳಲ್ಲಿ ಮಿಶ್ರಬೀಜಗಳನ್ನು ಬಿತ್ತಬಾರದು; “‘ನಾರು ಮತ್ತು ಉಣ್ಣೆ ಕೂಡಿರುವ ಬಟ್ಟೆಯನ್ನು ಹಾಕಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“‘ಒಬ್ಬನ ಅಧೀನದಲ್ಲಿರುವ ದಾಸಿ ಹಣಕೊಡುವುದರಿಂದಾಗಲಿ ಅಥವಾ ಉಚಿತವಾಗಿಯಾಗಲಿ ಬಿಡುಗಡೆಯನ್ನು ಹೊಂದದೆ ಇದ್ದರೆ, ಯಾವನಾದರೂ ಅವಳನ್ನು ಸಂಗಮಿಸಿದರೆ ಅವರಿಗೆ ವಿಧಿಸಬೇಕಾದ ಶಿಕ್ಷೆಯ ವಿಷಯವಾಗಿ ನ್ಯಾಯವಿಚಾರಣೆ ಆಗಬೇಕು. ಅವಳು ಸ್ವತಂತ್ರಳಲ್ಲವಾದುದರಿಂದ ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆಯನ್ನು ವಿಧಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ಆ ಪುರುಷನು ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞಕ್ಕಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಒಂದು ಟಗರನ್ನು ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ಅವನ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಯಾಜಕನು ಆ ಟಗರನ್ನು ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞವಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಿ, ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದಾಗ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“‘ನೀವು ಆ ದೇಶದಲ್ಲಿ ಸೇರಿದಾಗ ಆಹಾರಕ್ಕಾಗಿ ಯಾವ ಜಾತಿಯ ಹಣ್ಣಿನ ಸಸಿಯನ್ನು ನೆಟ್ಟರೂ, ಅದರ ಫಲವನ್ನು ಮೂರು ವರ್ಷದ ತನಕ ಅಶುದ್ಧವೆಂದೆಣಿಸಿ ತಿನ್ನದಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ನಾಲ್ಕನೆಯ ವರ್ಷದಲ್ಲಿ ಅದರ ಎಲ್ಲಾ ಹಣ್ಣುಗಳೂ ದೇವರದಾಗಿರಬೇಕು; ಅವುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಕೃತಜ್ಞತೆಯ ಕಾಣಿಕೆಯನ್ನಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ಐದನೆಯ ವರ್ಷದಲ್ಲಿ ಅದರಿಂದ ಉಂಟಾಗುವ ಆದಾಯವು ನಿಮ್ಮದೇ ಆಗಿರುವುದು; ಅದರ ಫಲಗಳನ್ನು ನೀವು ತಿನ್ನಬಹುದು. ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“‘ರಕ್ತಸಹಿತವಾದ ಯಾವ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು. “‘ಯಂತ್ರಮಂತ್ರಗಳನ್ನು ಮಾಡಬಾರದು, ಶಕುನಗಳನ್ನು ನೋಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“‘ಚಂಡಿಕೆ ಬಿಡಬಾರದು ಹಾಗೂ ಗಡ್ಡವನ್ನು ವಿಕಾರಗೊಳಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“‘ಸತ್ತವರಿಗೋಸ್ಕರ ದುಃಖವನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ದೇಹವನ್ನು ಗಾಯಮಾಡಿಕೊಳ್ಳಬಾರದು. ಶರೀರದ ಮೇಲೆ ಹಚ್ಚೇ ಹಾಕಿಸಿಕೊಳ್ಳಬಾರದು. ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“‘ಮಗಳನ್ನು ವೇಶ್ಯೆಯನ್ನಾಗಿ ಮಾಡಬಾರದು. ಹಾಗೆ ಮಾಡಿದರೆ ವೇಶ್ಯಾವಾಟಿಕೆ ಪ್ರಬಲವಾಗಿ ದೇಶದಲ್ಲೆಲ್ಲಾ ತುಂಬಿಹೋಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“‘ನಾನು ನೇಮಿಸಿರುವ ಸಬ್ಬತ್ ದಿನಗಳನ್ನು ನೀವು ಆಚರಿಸಬೇಕು; ನನ್ನ ದೇವಸ್ಥಾನದ ವಿಷಯದಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವರಾಗಿರಬೇಕು. ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“‘ಸತ್ತವರಲ್ಲಿ ವಿಚಾರಿಸುವವರ ಮತ್ತು ಮಂತ್ರವಾದಿಗಳ ಹತ್ತಿರ ಹೋಗಬಾರದು; ಅವರ ಆಲೋಚನೆಯನ್ನು ಕೇಳಿ ಅಶುದ್ಧರಾಗಬಾರದು. ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“‘ವಯೋ ವೃದ್ಧರ ಮುಂದೆ ಎದ್ದು ನಿಂತು ಅವರನ್ನು ಸನ್ಮಾನಿಸಬೇಕು. ನಿಮ್ಮ ದೇವರಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವರಾಗಿರಬೇಕು; ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“‘ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿರುವ ಪರದೇಶದವರಿಗೆ ಅನ್ಯಾಯವೇನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ಅವರು ನಿಮಗೆ ಸ್ವದೇಶದವರಂತೆಯೇ ಇರಬೇಕು; ಅವರನ್ನು ನಿಮ್ಮಂತೆಯೇ ಪ್ರೀತಿಸಬೇಕು. ಐಗುಪ್ತ ದೇಶದಲ್ಲಿದ್ದಾಗ ನೀವೂ ಅನ್ಯರಾಗಿದ್ದಿರಲ್ಲವೇ. ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“‘ನ್ಯಾಯವಿಚಾರಣೆ, ತೂಕ, ಅಳತೆ ಮತ್ತು ಪರಿಮಾಣಗಳಲ್ಲಿ ನೀವು ನ್ಯಾಯವಿರುದ್ಧವಾಗಿ ನಡೆಯಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ತಕ್ಕಡಿ, ತೂಕದ ಕಲ್ಲು, ಕೊಳಗ ಮತ್ತು ಸೇರು ಇವುಗಳೆಲ್ಲಾ ನ್ಯಾಯವಾಗಿಯೇ ಇರಬೇಕು. ನಾನು ನಿಮ್ಮನ್ನು ಐಗುಪ್ತದೇಶದಿಂದ ಬರಮಾಡಿದ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಾನೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ಆದುದರಿಂದ ನನ್ನ ಆಜ್ಞಾವಿಧಿಗಳನ್ನೆಲ್ಲಾ ನೀವು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು. ನಾನು ಯೆಹೋವನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ಇಸ್ರಾಯೇಲರಲ್ಲಾಗಲಿ ಅಥವಾ ಅವರ ನಡುವೆ ವಾಸವಾಗಿರುವ ಪರದೇಶದವರಲ್ಲಾಗಲಿ ಯಾವನಾದರೂ ತನ್ನ ಮಕ್ಕಳಲ್ಲಿ ಯಾರನ್ನಾದರೂ ಮೋಲೆಕನಿಗೆ ಕೊಟ್ಟರೆ, ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು; ದೇಶದ ಜನರು ಅವನನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ಅವನು ತನ್ನ ಮಕ್ಕಳಲ್ಲಿ ಯಾರನ್ನಾದರೂ ಮೋಲೆಕನಿಗೆ ಕೊಟ್ಟು, ನನ್ನ ದೇವಸ್ಥಾನವನ್ನು ಅಶುದ್ಧಮಾಡಿ, ನನ್ನ ಪರಿಶುದ್ಧವಾದ ಹೆಸರನ್ನು ಅಪಕೀರ್ತಿಗೆ ಒಳಪಡಿಸಿದರೆ, ನಾನು ಅವನಿಗೆ ವಿಮುಖನಾಗಿ ಅವನನ್ನು ಕುಲದಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ಆ ಮನುಷ್ಯನು ತನ್ನ ಮಕ್ಕಳಲ್ಲಿ ಯಾರನ್ನಾದರೂ ಮೋಲೆಕನಿಗೆ ಕೊಟ್ಟಾಗ ಸ್ವದೇಶದವರು ಅವನನ್ನು ಕೊಲ್ಲದೆ ಅವನು ಮಾಡಿದ ಕೆಲಸವನ್ನು ನೋಡಿಯೂ ನೋಡದವರಂತಿದ್ದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ಆಗ ನಾನು ಆ ಮನುಷ್ಯನಿಗೂ ಮತ್ತು ಅವನ ಕುಟುಂಬದವರಿಗೂ ವಿಮುಖನಾಗಿ ಅವನನ್ನು ಮಾತ್ರವಲ್ಲದೆ, ಅವನನ್ನು ಹೊಂದಿಕೊಂಡು ದೇವದ್ರೋಹಿಗಳಾಗಿ ಮೋಲೆಕನಿಗೆ ಸೇವೆ ಮಾಡಿದವರೆಲ್ಲರನ್ನು ಕುಲದಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“‘ಯಾವನಾದರೂ ಸತ್ತವರಲ್ಲಿ ವಿಚಾರಿಸುವವರ ಅಥವಾ ಬೇತಾಳಿಕರ ಬಳಿಗೆ ಹೋಗಿ ಅವರ ಆಲೋಚನೆ ಕೇಳಿಕೊಂಡು ದೇವದ್ರೋಹಿಯಾದರೆ, ನಾನು ಆ ಮನುಷ್ಯನಿಗೆ ವಿಮುಖನಾಗಿ ಅವನನ್ನು ಕುಲದಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಾಗಿರುವುದರಿಂದ ನೀವು ನನ್ನವರಾಗಿ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು. ನಾನು ನಿಮ್ಮನ್ನು ಪರಿಶುದ್ಧಜನವಾಗುವಂತೆ ಮಾಡುವ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“‘ತಂದೆಯನ್ನಾಗಲಿ ಅಥವಾ ತಾಯಿಯನ್ನಾಗಲಿ ದೂಷಿಸುವವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ತಂದೆತಾಯಿಗಳನ್ನು ದೂಷಿಸುವುದರಿಂದ ಅವನಿಗೆ ಸಂಭವಿಸಿದ ಮರಣಶಿಕ್ಷೆಗೆ ಅವನೇ ಕಾರಣನು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“‘ಯಾವನಾದರೂ ಪರನ ಪತ್ನಿಯೊಡನೆ ವ್ಯಭಿಚಾರವನ್ನು ಮಾಡಿದರೆ ಅವರಿಬ್ಬರಿಗೂ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ಯಾವನಾದರೂ ಮಲತಾಯಿಯನ್ನು ಸಂಗಮಿಸಿದರೆ ಅವನು ತಂದೆಗೆ ಮಾನಭಂಗಮಾಡಿದ ಹಾಗಾಯಿತು; ಅವರಿಬ್ಬರಿಗೂ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು; ಆ ಶಿಕ್ಷೆಗೆ ಅವರೇ ಕಾರಣರು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ಯಾವನಾದರೂ ಸೊಸೆಯನ್ನು ಸಂಗಮಿಸಿದರೆ ಅವರಿಬ್ಬರಿಗೂ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು; ಅವರು ಧರ್ಮವಿರುದ್ಧವಾದ ಕಾರ್ಯವನ್ನು ಮಾಡಿರುವುದರಿಂದ ಆ ಶಿಕ್ಷೆಗೆ ಅವರೇ ಕಾರಣರು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ಯಾವನಾದರೂ ಸ್ತ್ರೀಯನ್ನು ಸಂಗಮಿಸುವಂತೆ ಪುರುಷನನ್ನು ಸಂಗಮಿಸಿದರೆ ಅವರಿಬ್ಬರೂ ಅಸಹ್ಯವಾದ ಕೆಲಸವನ್ನು ಮಾಡಿದ್ದರಿಂದ ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು; ಆ ಶಿಕ್ಷೆಗೆ ಅವರೇ ಕಾರಣರು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ಯಾವನಾದರೂ ಒಬ್ಬ ಸ್ತ್ರೀಯನ್ನು ಹಾಗೂ ಅವಳ ತಾಯಿಯನ್ನು ಸಂಗಮಿಸಿದರೆ ಅದು ಅತಿದುಷ್ಟಕಾರ್ಯವಾದುದರಿಂದ ಆ ಮೂರು ಜನರನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಡಿಸಿಬಿಡಬೇಕು; ಅಂತಹ ದುರಾಚಾರವು ನಿಮ್ಮಲ್ಲಿ ಎಷ್ಟು ಮಾತ್ರವೂ ನಡೆಯಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ಯಾವನಾದರೂ ಪಶುಸಂಗ ಮಾಡಿದರೆ ಅವನಿಗೆ ಮರಣ ಶಿಕ್ಷೆಯಾಗಬೇಕು; ಆ ಪಶುವನ್ನು ಕೊಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ಯಾವ ಸ್ತ್ರೀಯಾದರೂ ಪಶುವಿನಿಂದ ಸಂಗಮಮಾಡಿಸಿಕೊಂಡರೆ ಆ ಸ್ತ್ರೀಯನ್ನು ಮತ್ತು ಪಶುವನ್ನು ಕೊಲ್ಲಿಸಬೇಕು; ಅವಳಿಗೂ ಹಾಗೂ ಅದಕ್ಕೂ ಮರಣವೇ ನಿಯಮ; ಆ ಮರಣ ಶಿಕ್ಷೆಗೆ ತಾವೇ ಕಾರಣರು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ಯಾವನಾದರೂ ತನ್ನ ಒಡಹುಟ್ಟಿದವಳನ್ನು ಅಂದರೆ ತಂದೆಯ ಮಗಳನ್ನಾಗಲಿ ಅಥವಾ ತಾಯಿಯ ಮಗಳನ್ನಾಗಲಿ ಕರೆದುಕೊಂಡು ಅವಳ ಮಾನವನ್ನು ಇವನೂ ಹಾಗು ಇವನ ಮಾನವನ್ನು ಅವಳೂ ನೋಡಿದರೆ ಅದು ನಾಚಿಕೆಗೇಡಾದ ಕೆಲಸವಾಗಿರುವುದರಿಂದ ಅವರ ಕುಲದವರ ಎದುರಾಗಿಯೇ ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆಯನ್ನು ಮಾಡಿಸಬೇಕು. ಆ ಮನುಷ್ಯನು ಒಡಹುಟ್ಟಿದವಳನ್ನು ಸಂಗಮಿಸಿದ್ದರಿಂದ ತನ್ನ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ಯಾವನಾದರೂ ಮುಟ್ಟಾದ ಸ್ತ್ರೀಯನ್ನು ಸಂಗಮಿಸಿದರೆ ಅವನು ಅವಳ ರಕ್ತಸ್ರಾವದ ಸ್ಥಾನವನ್ನು ಬಯಲುಪಡಿಸಿದವನು, ಅವಳು ಬಯಲುಪಡಿಸಿಕೊಂಡವಳು; ಆದುದರಿಂದ ಅವರಿಬ್ಬರನ್ನು ಕುಲದಿಂದ ಹೊರಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","ತಂದೆಯ ಅಥವಾ ತಾಯಿಯ ಒಡಹುಟ್ಟಿದವಳ ಸಂಗಮ ಮಾಡಬಾರದು; ಹಾಗೆ ಮಾಡಿದವನು ರಕ್ತಸಂಬಂಧಿಯನ್ನು ಸಂಗಮಿಸಿದವನಾದುದರಿಂದ ಅವರಿಬ್ಬರೂ ತಮ್ಮ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ಯಾವನಾದರೂ ದೊಡ್ಡಮ್ಮ ಅಥವಾ ಚಿಕ್ಕಮ್ಮನನ್ನಾಗಲಿ ಸಂಗಮಿಸಿದರೆ ಅವನು ದೊಡ್ಡಪ್ಪ ಮತ್ತು ಚಿಕ್ಕಪ್ಪನವರ ಮಾನವನ್ನು ಭಂಗಪಡಿಸಿದವನಾದುದರಿಂದ ಆ ಸ್ತ್ರೀಪುರುಷರು ಆ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು; ಅವರು ಸಂತಾನವಿಲ್ಲದೆ ಸಾಯುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ಯಾವನಾದರೂ ಅತ್ತಿಗೆ ಇಲ್ಲವೇ ನಾದಿನಿಯರನ್ನು ಸಂಗಮಿಸಿದರೆ ಅದು ಅಶುದ್ಧವಾದ ಕೆಲಸ; ಅವನು ಅಣ್ಣತಮ್ಮಂದಿರ ಮಾನವನ್ನೇ ಭಂಗಪಡಿಸಿದವನು; ಅವರಿಗೆ ಸಂತಾನವಿರುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“‘ಈ ನನ್ನ ಆಜ್ಞಾವಿಧಿಗಳನ್ನೆಲ್ಲಾ ನೀವು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು; ಹಾಗೆ ನಡೆದರೆ ನಾನು ನಿಮ್ಮನ್ನು ಯಾವ ದೇಶಕ್ಕೆ ಬರಮಾಡಿ ಅದನ್ನು ನಿವಾಸಕ್ಕಾಗಿ ಕೊಡುತ್ತೇನೋ ಆ ದೇಶವು ನಿಮ್ಮನ್ನು ತ್ಯಜಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ನಾನು ನಿಮಗಿಂತ ಮೊದಲು ಹೊರಡಿಸಿದ ಜನಾಂಗದ ಆಚಾರಗಳನ್ನು ನೀವು ಅನುಸರಿಸಬಾರದು; ಅವರು ಈ ದುರಾಚಾರಗಳನ್ನೆಲ್ಲಾ ನಡಿಸಿದ್ದರಿಂದ ನನಗೆ ಅಸಹ್ಯವಾದಾರು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ನಿಮಗಾದರೂ, ನೀವು ಅವರ ದೇಶವನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳುವಿರಿ, ಹಾಲೂ ಮತ್ತು ಜೇನೂ ಹರಿಯುವಂಥ ಆ ದೇಶವನ್ನು ನಿಮಗೆ ಸ್ವದೇಶವಾಗುವುದಕ್ಕೆ ಕೊಡುವೆನು ಎಂದು ನಾನು ಮಾತುಕೊಟ್ಟೆನಲ್ಲವೇ. ನಾನು ನಿಮ್ಮನ್ನು ಇತರ ಜನಾಂಗಗಳಿಂದ ಪ್ರತ್ಯೇಕಿಸಿದ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“‘ನೀವು ಶುದ್ಧ ಮತ್ತು ಅಶುದ್ಧ ಪಶುಗಳನ್ನು ಹಾಗು ಪಕ್ಷಿಗಳನ್ನು ಪ್ರತ್ಯೇಕಿಸುವ ವಿವೇಚನೆ ಹೊಂದಿರಬೇಕು. ನಾನು ಅಶುದ್ಧವೆಂದು ನಿರ್ಣಯಿಸಿರುವ ಯಾವ ಪಶು, ಪಕ್ಷಿ ಹಾಗು ಕ್ರಿಮಿಕೀಟಗಳಿಂದಲೂ ನಿಮ್ಮನ್ನು ಅಸಹ್ಯಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ಯೆಹೋವನೆಂಬ ನಾನು ಪರಿಶುದ್ಧನಾಗಿದ್ದೇನೆ, ಮತ್ತು ನೀವು ನನ್ನ ಜನರಾಗುವಂತೆ ನಿಮ್ಮನ್ನು ಇತರ ಜನಾಂಗಗಳಿಂದ ಪ್ರತ್ಯೇಕಿಸಿದ್ದೇನೆ; ಆದುದರಿಂದ ನೀವು ನನಗೆ ಮೀಸಲಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“‘ಸತ್ತವರಲ್ಲಿ ವಿಚಾರಿಸುವವರೂ, ಬೇತಾಳಿಕರೂ ಅವರು ಸ್ತ್ರೀಯರಾಗಲಿ ಅಥವಾ ಪುರುಷರಾಗಲಿ ಅವರು ಮರಣಶಿಕ್ಷೆ ಹೊಂದಬೇಕು. ಕಲ್ಲೆಸೆದು ಅವರನ್ನು ಕೊಲ್ಲಬೇಕು, ಆ ಶಿಕ್ಷೆಗೆ ಅವರೇ ಕಾರಣರು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, “ನೀನು ಆರೋನನ ಮಕ್ಕಳಾದ ಯಾಜಕರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ಕುಲದಲ್ಲಿ ಸತ್ತವರಿಗೋಸ್ಕರ ಯಾವ ಯಾಜಕನೂ ತನ್ನನ್ನು ಅಪವಿತ್ರ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ಆದರೂ ಸಮೀಪ ರಕ್ತಸಂಬಂಧಿಗಳಾದ ತಾಯಿ, ತಂದೆ, ಮಕ್ಕಳು ಮತ್ತು ಅಣ್ಣತಮ್ಮಂದಿರು ಇವರಿಗೋಸ್ಕರ ಈ ನಿಯಮ ಇರುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ಇದಲ್ಲದೆ ಕನ್ನಿಕೆಯಾಗಿರುವ ತಂಗಿ ಇನ್ನು ಮದುವೆಯಾಗದೆ ಅವನ ಆಶ್ರಯದಲ್ಲಿರುವುದರಿಂದ ಅವಳಿಗೋಸ್ಕರ ಅವನು ಅಪವಿತ್ರ ಮಾಡಿಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ಅವನು ಕುಲದಲ್ಲಿ ನಾಯಕನಾಗಿರುವುದರಿಂದ ತನ್ನನ್ನು ಅಪವಿತ್ರ ಮಾಡಿಕೊಳ್ಳಬಾರದು, ಮಾಡಿದರೆ ಯಾಜಕಸೇವೆಗೆ ಅಯೋಗ್ಯನಾದಾನು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","ಅವರು ತಲೆಬೋಳಿಸಿಕೊಳ್ಳಬಾರದು, ಗಡ್ಡವನ್ನು ಕತ್ತರಿಸಿ ವಿಕಾರಗೊಳಿಸಬಾರದು; ದೇಹವನ್ನು ಗಾಯಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ಅವರು ದೇವರಿಗೆ ಮೀಸಲಾಗಿರಬೇಕು; ತಾವು ಸೇವಿಸುವ ದೇವರ ಹೆಸರನ್ನು ಅಪಕೀರ್ತಿಗೆ ಗುರಿಪಡಿಸಬಾರದು. ತಮ್ಮ ದೇವರ ಆಹಾರವನ್ನು ಅಂದರೆ ಯೆಹೋವನ ಹೋಮದ್ರವ್ಯಗಳನ್ನು ಅವರು ಸಮರ್ಪಿಸುವವರು ಆಗಿರುವುದರಿಂದ ಪವಿತ್ರರಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","ಯಾಜಕರು ತಮ್ಮ ದೇವರಿಗೆ ಮೀಸಲಾದವರು ಆಗಿರುವುದರಿಂದ ವೇಶ್ಯ ಸ್ತ್ರೀಯನ್ನಾಗಲಿ, ಮಾನವನ್ನು ಭಂಗಪಡಿಸಿಕೊಂಡ ಸ್ತ್ರೀಯನ್ನಾಗಲಿ ಅಥವಾ ಗಂಡನಿಂದ ಬಿಡಲ್ಪಟ್ಟವಳನ್ನಾಗಲಿ ಹೆಂಡತಿಯನ್ನಾಗಿ ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ಅವರು ನಿಮ್ಮ ದೇವರ ಆಹಾರವನ್ನು ಸಮರ್ಪಿಸುವವರಾದ ಕಾರಣ ಅವರನ್ನು ದೇವರ ಸೇವಕರೆಂದು ಭಾವಿಸಬೇಕು. ನಿಮ್ಮನ್ನು ನನ್ನ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡಿರುವ ಯೆಹೋವನೆಂಬ ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವುದರಿಂದ ಅವರನ್ನು ಪರಿಶುದ್ಧರೆಂದು ನೀವು ಭಾವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ಯಾಜಕನ ಮಗಳು ವೇಶ್ಯೆ ಎಂಬ ನಿಂದೆಗೆ ಒಳಗಾದರೆ ತನ್ನ ತಂದೆಯನ್ನು ನಿಂದೆಗೆ ಒಳಪಡಿಸಿದವಳಾದಳು, ಅವಳನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“‘ಮಹಾಯಾಜಕನು ಅಂದರೆ ತನ್ನ ಸಹೋದರರಲ್ಲಿ ಪ್ರಧಾನನು, ಯಾವನು ತೈಲಾಭಿಷೇಕಹೊಂದಿ, ದೀಕ್ಷಾವಸ್ತ್ರಗಳನ್ನು ಧರಿಸಿ, ಪಟ್ಟಕ್ಕೆ ಬರುವನೋ ಅವನು ದುಃಖಸೂಚನೆಗಾಗಿ ತನ್ನ ತಲೆಯ ಕೂದಲನ್ನು ಕೆದರಿಕೊಳ್ಳಬಾರದು, ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ಅವನು ಶವವಿರುವ ಯಾವ ಸ್ಥಳಕ್ಕೂ ಹೋಗಬಾರದು. ತಂದೆತಾಯಿಗಳ ಮರಣದ ನಿಮಿತ್ತ ತನ್ನನ್ನು ಅಪವಿತ್ರ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ಇದಕ್ಕಾಗಿ ಅವನು ದೇವಸ್ಥಾನವನ್ನು ಬಿಡಲೇ ಬಾರದು; ಬಿಟ್ಟುಹೋದರೆ ತಾನು ಸೇವೆಮಾಡುವ ದೇವರ ಮಂದಿರದ ಗೌರವಕ್ಕೆ ಕುಂದು ಬರುವುದು. ತನ್ನ ದೇವರ ಅಭಿಷೇಕತೈಲವನ್ನು ತಲೆಯ ಮೇಲೆ ಹೊಯ್ಯಿಸಿಕೊಂಡು ಪ್ರತಿಷ್ಠಿತನಾಗಿದ್ದಾನಲ್ಲಾ, ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","ಅವನು ಕನ್ನಿಕೆಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ಅವನು ವಿಧವೆಯನ್ನಾಗಲಿ, ಗಂಡನಿಂದ ಬಿಡಲ್ಪಟ್ಟವಳನ್ನಾಗಲಿ, ಮಾನವನ್ನು ಭಂಗಪಡಿಸಿಕೊಂಡ ಸ್ತ್ರೀಯನ್ನಾಗಲಿ ಅಥವಾ ವೇಶ್ಯ ಸ್ತ್ರೀಯನ್ನಾಗಲಿ ಹೆಂಡತಿಯನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ಸ್ವದೇಶದವರಲ್ಲಿಯ ಕನ್ನಿಕೆಯನ್ನೇ ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ಇಲ್ಲವಾದರೆ ಅವನ ಸಂತತಿಯ ಸ್ವಜನರೊಳಗೆ ಅವನು ಅಪವಾದಕ್ಕೆ ಗುರಿಯಾಗುವನು. ಅವನನ್ನು ನನ್ನ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ಯೆಹೋವನು ನಾನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ನೀನು ಆರೋನನಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ನಿನ್ನ ಸಂತತಿಯವರ ಎಲ್ಲಾ ತಲಾಂತರಗಳಲ್ಲಿಯೂ ಯಾವ ಅಂಗವಿಕಲನೂ ದೇವರ ಆಹಾರವನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕೆ ನನ್ನ ಸನ್ನಿಧಿಗೆ ಬರಬಾರದು; ಅಂಗವಿಕಲನು ಈ ಕಾರ್ಯವನ್ನು ವಹಿಸಿಕೊಳ್ಳಲೇ ಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ಅವನು ಕುರುಡನಾಗಲಿ, ಕುಂಟನಾಗಲಿ, ವಿಕಾರ ಮುಖವುಳ್ಳವನಾಗಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ವಿಪರೀತ ಅವಯವಗಳುಳ್ಳವನಾಗಲಿ, ಕೈಕಾಲು ಮುರಿದವನಾಗಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ಗೂನು ಇಲ್ಲವೇ ಕುಬ್ಜರಾಗಲಿ, ಹೂಗಣ್ಣ ಅಥವಾ ಕಾಯಿಗಣ್ಣನಾಗಲಿ, ಕಜ್ಜಿ, ತುರಿಗಳುಳ್ಳವನಾಗಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ನಪುಂಸಕನಾಗಲಿ, ಬೇರೆ ಯಾವ ಕಳಂಕವಿದ್ದವನಾಗಲಿ ಯೆಹೋವನಿಗೆ ಹೋಮದ್ರವ್ಯಗಳನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕೆ ಸನ್ನಿಧಿಗೆ ಬರಬಾರದು. ಅಂಥವನು ದೇಹದಲ್ಲಿ ದೋಷವಿರುವುದರಿಂದ ದೇವರ ಆಹಾರವನ್ನು ಸಮರ್ಪಿಸಲೇಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ದೇವರಿಗೆ ನೈವೇದ್ಯವಾದ ಆಹಾರದಲ್ಲಿ ಪರಿಶುದ್ಧವಾದದ್ದನ್ನು ಮತ್ತು ಮಹಾಪರಿಶುದ್ಧವಾದುದನ್ನು ಅವನು ಊಟಮಾಡಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ಅವನಿಗೆ ಕಳಂಕವಿರುವುದರಿಂದ ತೆರೆಯನ್ನು ದಾಟಿ ಒಳಗೆ ಬರಬಾರದು; ಯಜ್ಞವೇದಿಯ ಬಳಿಗೆ ಬರಬಾರದು; ನನ್ನ ಪವಿತ್ರಸ್ಥಾನಗಳ ಗೌರವಕ್ಕೆ ಅವನಿಂದ ಕುಂದು ಉಂಟಾಗಬಾರದು; ಆ ಸ್ಥಾನಗಳನ್ನು ನನ್ನ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ಯೆಹೋವನು ನಾನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ಮೋಶೆಯು ಆರೋನನಿಗೂ, ಅವನ ಮಕ್ಕಳಿಗೂ ಮತ್ತು ಇಸ್ರಾಯೇಲರೆಲ್ಲರಿಗೂ ಈ ಆಜ್ಞೆಗಳನ್ನು ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ಆರೋನನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ತಾವು ಅಶುದ್ಧರಾಗಿರುವಾಗ ಇಸ್ರಾಯೇಲರಿಂದ ನನಗೆ ಸಮರ್ಪಿಸಲ್ಪಟ್ಟ ಪರಿಶುದ್ಧ ದ್ರವ್ಯಗಳನ್ನು ಮುಟ್ಟಬಾರದೆಂದು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸು. ಅವರು ನನ್ನ ಪರಿಶುದ್ಧ ನಾಮದ ಘನತೆಗೆ ಕುಂದನ್ನು ತರಬಾರದು; ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ಅವರಿಗೆ ನೀನು ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ನಿಮ್ಮಲ್ಲಿಯಾಗಲಿ ಅಥವಾ ನಿಮ್ಮ ಸಂತತಿಯವರಲ್ಲಾಗಲಿ ಯಾವನಾದರೂ ಅಶುದ್ಧನಾಗಿರುವಾಗ ಇಸ್ರಾಯೇಲರು ಯೆಹೋವನಿಗೆ ಮೀಸಲೆಂದು ಸಮರ್ಪಿಸುವ ದ್ರವ್ಯಗಳ ಬಳಿಗೆ ಬಂದರೆ, ಅವನು ನನ್ನ ಸಾನ್ನಿಧ್ಯಸೇವೆಯಿಂದ ತೆಗೆದು ಹಾಕಬೇಕು; ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ಆರೋನನ ಸಂತತಿಯವರಲ್ಲಿ ಯಾವನಿಗಾದರೂ ಕುಷ್ಠರೋಗವಾಗಲಿ ಅಥವಾ ಮೇಹವಾಗಲಿ ಇದ್ದರೆ ಅವನು ಶುದ್ಧನಾಗುವ ತನಕ ದೇವರಿಗೆ ನೈವೇದ್ಯವಾದ ಪದಾರ್ಥಗಳನ್ನು ಊಟಮಾಡಬಾರದು. ಹೆಣದ ಸಂಪರ್ಕದಿಂದ ಅಶುದ್ಧವಾದುದನ್ನು ಮುಟ್ಟಿದವನಾಗಲಿ, ವೀರ್ಯಸ್ಖಲನ ಮಾಡಿಕೊಂಡವನಾಗಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ಹರಿದಾಡುವ ಅಶುದ್ಧವಾದ ಕ್ರಿಮಿಕೀಟ ಅಥವಾ ಅಶುದ್ಧನಾದ ಮನುಷ್ಯನನ್ನು ಮುಟ್ಟಿದವನು ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","“‘ಅಶುದ್ಧವಾದುದನ್ನು ಮುಟ್ಟುವ ಯಾಜಕನು ಆ ದಿನದ ಸಾಯಂಕಾಲದ ವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ಆದುದರಿಂದ ಸ್ನಾನಮಾಡುವ ತನಕ ಅವನು ನೈವೇದ್ಯದ್ರವ್ಯವನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ಹೊತ್ತುಮುಣುಗಿದ ನಂತರ ಅವನು ಶುದ್ಧನಾಗಿ ನೈವೇದ್ಯದ್ರವ್ಯವನ್ನು ಊಟಮಾಡಬಹುದು. ಅದು ಅವನ ಆಹಾರವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ಅವನು ತಾನಾಗಿ ಸತ್ತುಬಿದ್ದದ್ದನ್ನಾಗಲಿ, ಕಾಡುಮೃಗದಿಂದ ಕೊಲ್ಲಲ್ಪಟ್ಟ ಪ್ರಾಣಿಗಳನ್ನು ತಿಂದು ತನ್ನನ್ನು ಅಪವಿತ್ರಮಾಡಿಕೊಳ್ಳಬಾರದು; ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ಯಾಜಕರು ಈ ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು. ಇವುಗಳನ್ನು ಮೀರಿ ನನ್ನ ನೈವೇದ್ಯವನ್ನು ಅಪವಿತ್ರಪಡಿಸಿದರೆ ಆ ದೋಷದ ಫಲವನ್ನು ಅನುಭವಿಸಿ ಸತ್ತಾರು. ಅವರನ್ನು ನನ್ನ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ಯೆಹೋವನು ನಾನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“‘ಯಾಜಕನಲ್ಲದೆ ಇತರರು ನೈವೇದ್ಯದ ಪದಾರ್ಥವನ್ನು ಊಟಮಾಡಬಾರದು. ಯಾಜಕನ ಬಳಿಯಲ್ಲಿರುವ ಅತಿಥಿಯಾಗಲಿ ಅಥವಾ ಕೂಲಿಯಾಳಾಗಲಿ ಅದನ್ನು ಊಟಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ಆದರೆ ಯಾಜಕನು ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡ ಗುಲಾಮರೂ ಮತ್ತು ಅವನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದ ಗುಲಾಮರು ಅದನ್ನು ಊಟಮಾಡಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ಯಾಜಕನ ಮಗಳು ಯಾಜಕನಲ್ಲದ ಇತರರಿಗೆ ಮದುವೆಯಾಗಿದ್ದರೆ ಅವಳು ನೈವೇದ್ಯದ ಪದಾರ್ಥಗಳನ್ನು ಊಟಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ಯಾಜಕನ ಮಗಳು ವಿಧವೆಯಾಗಲಿ ಅಥವಾ ಗಂಡನಿಂದ ಬಿಡಲ್ಪಟ್ಟವಳಾಗಲಿ, ಮಕ್ಕಳಿಲ್ಲದೆ ಇದ್ದರೆ ಬಾಲ್ಯದಲ್ಲಿ ತಂದೆಯ ಬಳಿಯಲ್ಲಿ ಇದ್ದಂತೆಯೇ ಕನ್ಯೆಯಾಗಿಯೇ ತಂದೆಯ ಮನೆಯನ್ನು ಸೇರಿ ತಂದೆಯ ಆಹಾರದಲ್ಲಿ ಭಾಗಿಯಾಗಬಹುದು. ಯಾಜಕರಲ್ಲದ ಇತರರು ಅದನ್ನು ಊಟಮಾಡಲೇಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ಯಾವನಾದರೂ ತಿಳಿಯದೆ ನೈವೇದ್ಯವಾದದ್ದನ್ನು ಊಟಮಾಡಿದರೆ ಅದನ್ನು ಮತ್ತು ಅದರ ಐದನೆಯ ಭಾಗವನ್ನು ಯಾಜಕನಿಗೆ ತಂದುಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವನಿಗೆ ಮೀಸಲೆಂದು ಇಟ್ಟ ನೈವೇದ್ಯದ ಪದಾರ್ಥಗಳನ್ನು ಯಾಜಕರು ಸಾಧಾರಣವೆಂದು ಎಣಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ಹಾಗೆ ಎಣಿಸಿದರೆ ತಾವು ಆ ನೈವೇದ್ಯಪದಾರ್ಥಗಳನ್ನು ಊಟಮಾಡುವುದರಿಂದ ಪಾಪಕ್ಕೆ ಒಳಗಾಗಿ ಶಿಕ್ಷೆಹೊಂದುವರು. ನನ್ನ ಸೇವೆಗೆ ಅವರನ್ನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ಯೆಹೋವನು ನಾನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“ನೀನು ಆರೋನನಿಗೂ, ಅವನ ಮಕ್ಕಳಿಗೂ ಹಾಗೂ ಇಸ್ರಾಯೇಲರೆಲ್ಲರಿಗೂ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಆಗಲಿ, ಅವರ ನಡುವೆ ವಾಸಿಸುವ ಇತರರಲ್ಲಿಯಾಗಲಿ ಯಾವನಾದರೂ ಹರಕೆಯಾಗಿ ಅಥವಾ ಕಾಣಿಕೆಯಾಗಿ ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮ ಮಾಡುವಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ಅದು ಸಮರ್ಪಕವಾಗುವಂತೆ ದನಗಳಿಂದಾಗಲಿ ಅಥವಾ ಆಡು ಮತ್ತು ಕುರಿಗಳಿಂದಾಗಲಿ ಪೂರ್ಣಾಂಗವಾದ ಗಂಡನ್ನೇ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ಕುಂದುಕೊರತೆ ಇರುವಂಥದ್ದನ್ನು ತರಬಾರದು; ಅಂಥದು ಸಮರ್ಪಣೆ ಆಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ಯಾವನಾದರೂ ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಹರಕೆಯಾಗಿ ಅಥವಾ ಕಾಣಿಕೆಯಾಗಿ ದನವನ್ನು ಅಥವಾ ಹಿಂಡಿನ ಆಡು ಇಲ್ಲವೇ ಕುರಿಗಳನ್ನು ತಂದರೆ ಅವು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಕವಾಗುವುದಕ್ಕಾಗಿ ಅದು ಪೂರ್ಣಾಂಗವಾಗಿಯೇ ಇರಬೇಕು; ಅದರಲ್ಲಿ ಯಾವ ಕುಂದುಕೊರತೆಯೂ ಇರಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ಕುರುಡಾದದ್ದು, ಕುಂಟಾದದ್ದು, ಗಾಯವಾದದ್ದು, ಹುಣ್ಣುಳ್ಳದ್ದು, ಕಜ್ಜಿ ತುರಿಯುಳ್ಳದ್ದು ಇಂಥವುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಲೇಬಾರದು, ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಹೋಮ ಮಾಡಲೇಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ಹೋರಿಯ ಇಲ್ಲವೆ ಕುರಿಯ ಅವಯವಗಳಲ್ಲಿ ಏನಾದರೂ ಹೆಚ್ಚುಕಡಿಮೆ ಇದ್ದರೆ ಅದನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಸಮರ್ಪಿಸಬಹುದೇ ಹೊರತು ಹರಕೆಯಾಗಿ ಒಪ್ಪಿಸಿದರೆ ಅದು ಸಮರ್ಪಣೆ ಆಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ಬೀಜಹೊಡೆದ, ಕುಟ್ಟಿದ, ಒಡೆದ ಮತ್ತು ಕೊಯ್ದ ಪಶುವನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬಾರದು, ಮತ್ತು ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಪಶುಗಳಿಗೆ ಹಾಗೆ ಮಾಡಲೇ ಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ಅನ್ಯದೇಶದವನಿಂದ ತೆಗೆದುಕೊಂಡ ಅಂತಹ ಪಶುವನ್ನು ನಿಮ್ಮ ದೇವರಿಗೆ ಆಹಾರವಾಗಿ ಒಪ್ಪಿಸಬಾರದು; ಅದು ಕುಂದುಳ್ಳದ್ದು, ಪೂರ್ಣಾಂಗವಾದುದಲ್ಲ; ಆದಕಾರಣ ಸಮರ್ಪಣೆ ಆಗುವುದಿಲ್ಲ’” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ಕರುವಾಗಲಿ, ಕುರಿಮರಿಯಾಗಲಿ ಅಥವಾ ಆಡುಮರಿಯಾಗಲಿ ಹುಟ್ಟಿದಾಗ ಅದು ಏಳು ದಿನಗಳ ವರೆಗೆ ತಾಯಿಯ ಬಳಿಯಲ್ಲಿ ಇರಬೇಕು. ಎಂಟನೆಯ ದಿನದಿಂದ ಅದನ್ನು ಯೆಹೋವನಿಗೆ ಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಿದರೆ ಅದು ಅಂಗೀಕಾರವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ಹೆತ್ತ ಆಕಳನ್ನು, ಅದರ ಕರುವನ್ನು ಇಲ್ಲವೆ ಈದ ಆಡು, ಕುರಿಗಳನ್ನು, ಅವುಗಳ ಮರಿಗಳನ್ನು ಒಂದೇ ದಿನದಲ್ಲಿ ವಧಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“ನೀವು ಕೃತಜ್ಞತೆಯನ್ನು ತೋರಿಸುವುದಕ್ಕಾಗಿ ಯೆಹೋವನಿಗೆ ಮಾಡುವ ಯಜ್ಞವನ್ನು ಮೆಚ್ಚಿಗೆಯಾದ ರೀತಿಯಲ್ಲೇ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ಅದೇ ದಿನದಲ್ಲಿ ಅದನ್ನು ಊಟಮಾಡಬೇಕು; ಮರುದಿನದ ವರೆಗೆ ಸ್ವಲ್ಪವನ್ನಾದರೂ ಉಳಿಸಬಾರದು. ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“ಈ ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ನೀವು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು; ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ನನ್ನ ಪರಿಶುದ್ಧ ನಾಮದ ಘನತೆಗೆ ಕುಂದು ತರಬಾರದು; ಇಸ್ರಾಯೇಲರಲ್ಲಿ ನಾನು ಪರಿಶುದ್ಧನೆಂದು ಎಣಿಸಲ್ಪಡಬೇಕು; ನಾನು ನಿಮ್ಮನ್ನು ನನ್ನ ಸೇವೆಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ನಿಮ್ಮ ದೇವರಾಗುವುದಕ್ಕೆ ನಿಮ್ಮನ್ನು ಐಗುಪ್ತದೇಶದಿಂದ ಬರಮಾಡಿದೆನಲ್ಲಾ; ನಾನು ಯೆಹೋವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ಯೆಹೋವನಿಂದ ನೇಮಕವಾದ ಹಬ್ಬಗಳ ದಿನಗಳು ಇವೇ; ಈ ದಿನಗಳಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಜನರು ಸಭೆಸೇರಿಬರಬೇಕೆಂದು ಸಾರಬೇಕು. ನಾನು ನೇಮಿಸಿರುವ ಹಬ್ಬದ ದಿನಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“‘ಆರು ದಿನಗಳಲ್ಲಿ ನೀವು ಕೆಲಸವನ್ನು ಮಾಡಬೇಕು; ಏಳನೆಯ ದಿನ ಯಾವ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು, ಅದು ಸಬ್ಬತ್ ದಿನವಾಗಿದೆ. ಅದರಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾವ ವಿಧವಾದ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ನಿಮ್ಮ ಎಲ್ಲಾ ವಾಸಮಾಡುವ ಸ್ಥಳಗಳಲ್ಲಿ ಅದು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾದ ವಿಶ್ರಾಂತಿ ದಿನವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“‘ಯೆಹೋವನಿಂದ ನೇಮಕವಾದ ಹಬ್ಬದ ಕಾಲಗಳು ಇವೇ; ಈ ಕಾಲಗಳಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರಬೇಕು. ನೇಮಕವಾದ ದಿನಗಳಲ್ಲಿ ಇವುಗಳನ್ನು ಪ್ರಕಟಪಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“‘ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ಸಂಜೆಯ ವೇಳೆಯಲ್ಲಿ ಯೆಹೋವನು ನೇಮಿಸಿದ ಪಸ್ಕ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ಅದೇ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕಾದ ಜಾತ್ರೆಯನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಆಚರಿಸಬೇಕು. ಅದು ಮೊದಲುಗೊಂಡು ಏಳು ದಿನಗಳಲ್ಲಿಯೂ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರಬೇಕು; ಆ ದಿನದಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನು ನಡೆಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ಏಳು ದಿನಗಳಲ್ಲಿಯೂ ನೀವು ಯೆಹೋವನಿಗೆ ಹೋಮವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನು ಮಾಡಬಾರದು’” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ನಾನು ನಿಮಗೆ ಕೊಡುವ ದೇಶದಲ್ಲಿ ನೀವು ಸೇರಿದ ನಂತರ ಅಲ್ಲಿನ ಜವೆಗೋದಿಯ ಪೈರನ್ನು ಕೊಯ್ಯುವಾಗ, ಪ್ರಥಮಫಲದ ಸಿವುಡನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತಂದು ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ನೀವು ದೇವರಿಗೆ ಅಂಗೀಕಾರವಾಗುವಂತೆ ಯಾಜಕನು ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿ ಸಮರ್ಪಿಸುವನು. ಸಬ್ಬತ್ ದಿನದ ಮರು ದಿನದಲ್ಲಿಯೇ ಅದನ್ನು ನಿವಾಳಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ಆ ಸಿವುಡನ್ನು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸುವ ದಿನದಲ್ಲಿ ನೀವು ಒಂದು ವರ್ಷದ ಪೂರ್ಣಾಂಗವಾದ ಟಗರನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ಅದರೊಂದಿಗೆ ಮಾಡಬೇಕಾದ ಧಾನ್ಯನೈವೇದ್ಯವು ಯಾವುದೆಂದರೆ ಎಣ್ಣೆ ಬೆರೆತ ಆರು ಸೇರು ಗೋದಿಯ ಹಿಟ್ಟು. ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕೆ ಇದನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಹೋಮಮಾಡಬೇಕು. ಅದರೊಂದಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಪಾನದ್ರವ್ಯವು ಒಂದುವರೆ ಸೇರು ದ್ರಾಕ್ಷಾರಸ. ");
INSERT INTO kanirv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ನೀವು ನಿಮ್ಮ ದೇವರಿಗೆ ಸಲ್ಲಿಸಬೇಕಾದದ್ದನ್ನು ತಂದು ಕೊಡುವವರೆಗೂ ಆ ವರ್ಷದ ಬೆಳೆಯ ರೊಟ್ಟಿಯನ್ನಾಗಲಿ, ಸುಟ್ಟ ತೆನೆಗಳನ್ನಾಗಲಿ ಅಥವಾ ಹಸಿತೆನೆಗಳನ್ನಾಗಲಿ ತಿನ್ನಲೇಬಾರದು. ನಿಮಗೂ, ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಮತ್ತು ನಿಮ್ಮ ಎಲ್ಲಾ ವಾಸಸ್ಥಾನಗಳಲ್ಲಿಯೂ ಇದು ಶಾಶ್ವತನಿಯಮ. ");
INSERT INTO kanirv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“‘ಸಬ್ಬತ್ ದಿನದ ಮರುದಿನದಿಂದ ಆ ಪ್ರಥಮ ಸಿವುಡನ್ನು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿದ ದಿನ ಮೊದಲುಗೊಂಡು ಪೂರ್ಣವಾಗಿ ಏಳು ವಾರಗಳು ಮುಗಿಯುವಂತೆ ಐವತ್ತು ದಿನಗಳನ್ನು ಲೆಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ಏಳನೆಯ ಸಬ್ಬತ್ ದಿನದ ಮರುದಿನದಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಹೊಸಬೆಳೆಯ ಧಾನ್ಯನೈವೇದ್ಯವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ನಿಮ್ಮ ನಿವಾಸಗಳಿಂದ ತಂದ ಹಿಟ್ಟಿನಲ್ಲಿ ಆರು ಸೇರು ಹಿಟ್ಟಿನಿಂದ ಎರಡು ನೈವೇದ್ಯದ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಬೇಕು. ಇವುಗಳನ್ನು ಹುಳಿಹಾಕಿದ ಗೋದಿಯ ಹಿಟ್ಟಿನಿಂದ ಮಾಡಿ ಪ್ರಥಮಫಲವಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ಆ ರೊಟ್ಟಿಗಳೊಡನೆ ಒಂದು ವರ್ಷದ ಪೂರ್ಣಾಂಗವಾದ ಏಳು ಕುರಿಗಳನ್ನು, ಒಂದು ಹೋರಿಯನ್ನು ಮತ್ತು ಎರಡು ಟಗರುಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಇವು ಧಾನ್ಯದ್ರವ್ಯದೊಡನೆ ಮತ್ತು ಪಾನದ್ರವ್ಯದೊಡನೆ ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವ ಸರ್ವಾಂಗಹೋಮವಾಗುವವು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ಅದಲ್ಲದೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಒಂದು ಹೋತವನ್ನು ಮತ್ತು ಸಮಾಧಾನ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ವರ್ಷದ ಎರಡು ಟಗರುಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ಯಾಜಕನು ಇವುಗಳನ್ನು, ಪ್ರಥಮಫಲದ ರೊಟ್ಟಿಗಳನ್ನು ಮತ್ತು ಎರಡು ಕುರಿಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕು. ಅವು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾಗಿ ಯಾಜಕನಿಗೆ ಸಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ಆ ದಿನದಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರಬೇಕೆಂಬುದಾಗಿ ಪ್ರಕಟಪಡಿಸಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನು ನಡೆಸಬಾರದು. ಇದು ನಿಮಗೂ, ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಮತ್ತು ನಿಮ್ಮ ಎಲ್ಲಾ ನಿವಾಸಗಳಲ್ಲಿ ಶಾಶ್ವತನಿಯಮ. ");
INSERT INTO kanirv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“‘ನಿಮ್ಮ ದೇಶದ ಪೈರನ್ನು ಕೊಯ್ಯುವಾಗ ಹೊಲಗಳ ಮೂಲೆಗಳಲ್ಲಿರುವುದನ್ನೆಲ್ಲಾ ಕೊಯ್ಯಬಾರದು ಮತ್ತು ಹಕ್ಕಲಾಯಬಾರದು. ಇವುಗಳನ್ನು ಬಡವರಿಗೋಸ್ಕರವು ಹಾಗು ಪರದೇಶದವರಿಗೋಸ್ಕರವು ಬಿಟ್ಟುಬಿಡಬೇಕು. ನಾನು ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ಏಳನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ನಿಮಗೆ ಸಂಪೂರ್ಣ ವಿರಾಮವಿರಬೇಕು. ಅದನ್ನು ತುತ್ತೂರಿಗಳ ಧ್ವನಿಯಿಂದ ಪ್ರಕಟಪಡಿಸಬೇಕು. ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ಆ ದಿನದಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನು ನಡೆಸಬಾರದು; ಯೆಹೋವನಿಗೆ ಹೋಮವನ್ನು ಮಾಡಬೇಕು’” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ಅದೇ ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನ ದೋಷಪರಿಹಾರಕ ದಿನ. ಅದರಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರಬೇಕು; ನೀವು ಪೂರ್ಣವಾಗಿ ಉಪವಾಸಮಾಡಬೇಕು ಮತ್ತು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಹೋಮವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ಆ ದಿನದಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನೂ ನಡೆಸಬಾರದು. ಅದು ದೋಷಪರಿಹಾರಕ ದಿನವಾಗಿದೆ, ಅದರಲ್ಲಿ ನಿಮಗೋಸ್ಕರ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೋಷಪರಿಹಾರಕ ಆಚರಣೆ ನಡೆಯುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ಯಾವನಾದರೂ ಆ ದಿನದಲ್ಲಿ ಉಪವಾಸ ಮಾಡದೆಹೋದರೆ ಅವನನ್ನು ಕುಲದಿಂದ ಹೊರಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ಯಾವನಾದರೂ ಆ ದಿನದಲ್ಲಿ ಕೆಲಸವನ್ನು ಮಾಡಿದರೆ ಅವನನ್ನು ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಇರದಂತೆ ನಾಶಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ಆ ದಿನದಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ಇದು ನಿಮಗೂ, ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಮತ್ತು ನಿಮ್ಮ ಎಲ್ಲಾ ನಿವಾಸಗಳಲ್ಲಿ ಶಾಶ್ವತನಿಯಮ. ");
INSERT INTO kanirv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ಆ ಸಬ್ಬತ್ ದಿನವು ಸಂಪೂರ್ಣವಿರಾಮವುಳ್ಳ ದಿನವಾಗಿರಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಉಪವಾಸದಿಂದಿರಬೇಕು. ಆ ತಿಂಗಳಿನ ಒಂಭತ್ತನೆಯ ದಿನದ ಸಾಯಂಕಾಲದಲ್ಲಿ ಪ್ರಾರಂಭಿಸಿ ಮರುದಿನದ ಸಾಯಂಕಾಲದ ವರೆಗೆ ನೀವು ಆ ವಿರಾಮದಿನವನ್ನು ಆಚರಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನ ಮೊದಲುಗೊಂಡು ಏಳು ದಿನಗಳ ವರೆಗೆ ಪರ್ಣಶಾಲೆಗಳ ಜಾತ್ರೆಯನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರಬೇಕು; ಯಾವ ಉದ್ಯೋಗವನ್ನು ನಡೆಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ಆ ಏಳು ದಿನಗಳಲ್ಲಿಯೂ ನೀವು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಹೋಮಮಾಡಬೇಕು. ಎಂಟನೆಯ ದಿನದಲ್ಲಿಯೂ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರಬೇಕು, ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಹೋಮಮಾಡಬೇಕು. ಅದು ಸಭೆಸೇರುವ ದಿನವಾದುದರಿಂದ ಆ ದಿನದಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“‘ಯೆಹೋವನು ನೇಮಿಸಿರುವ ಸಬ್ಬತ್ ದಿನಗಳ ಹೊರತಾಗಿ ಮೇಲೆ ಹೇಳಿದ ದಿನಗಳೇ ಯೆಹೋವನ ಹಬ್ಬದ ದಿನಗಳು. ಆ ದಿನಗಳಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಸೇರುವಂತೆ ನೀವು ಪ್ರಕಟಿಸಬೇಕು. ಆಯಾ ದಿನಕ್ಕೆ ನೇಮಿಸಿರುವ ಪ್ರಕಾರ ಸರ್ವಾಂಗಹೋಮ, ಧಾನ್ಯನೈವೇದ್ಯ, ಸಮಾಧಾನಯಜ್ಞ, ಪಾನದ್ರವ್ಯ ಇವುಗಳನ್ನು ತಂದು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ಯೆಹೋವನಿಗೆ ಒಪ್ಪಿಸಬೇಕಾದ ಕಪ್ಪ, ಕಾಣಿಕೆ, ಹರಕೆ ಇವುಗಳನ್ನು ನೀವು ಯೆಹೋವನು ನೇಮಿಸಿರುವ ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ಮಾತ್ರವಲ್ಲದೆ ಮೇಲೆ ಸೂಚಿಸಿರುವ ಹಬ್ಬದ ದಿನಗಳಲ್ಲಿಯೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“‘ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ನೀವು ತೋಟ ಮತ್ತು ತೋಪುಗಳ ಬೆಳೆಯನ್ನು ಕೂಡಿಸಿದ ನಂತರ ಯೆಹೋವನು ನೇಮಿಸಿದ ಪರ್ಣಶಾಲೆಗಳ ಜಾತ್ರೆಯನ್ನು ಏಳು ದಿನಗಳ ವರೆಗೂ ಆಚರಿಸಬೇಕು. ಮೊದಲನೆಯ ದಿನದಲ್ಲಿಯೂ ಮತ್ತು ಎಂಟನೆಯ ದಿನದಲ್ಲಿಯೂ ಯಾವ ಕೆಲಸವನ್ನು ಮಾಡದೆ ಸಂಪೂರ್ಣ ವಿರಾಮದಿಂದಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಶ್ರೇಷ್ಠವೃಕ್ಷದ ಹಣ್ಣುಗಳನ್ನು, ಖರ್ಜೂರ ಮರದ ಗರಿಗಳನ್ನು, ಎಲೆಗಳು ದಟ್ಟವಾಗಿರುವ ಮರಗಳ ಕೊಂಬೆಗಳನ್ನು ಮತ್ತು ನೀರಿನ ಕಾಲುವೆಗಳ ಬಳಿಯಲ್ಲಿ ಬೆಳೆಯುವ ನೀರವಂಜಿ ಚಿಗುರುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಏಳು ದಿನಗಳ ವರೆಗೆ ಸಂಭ್ರಮವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ಹೀಗೆ ಪ್ರತಿ ವರ್ಷದಲ್ಲಿಯೂ ಏಳು ದಿನಗಳ ವರೆಗೆ ಈ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು; ನಿಮಗೂ ಮತ್ತು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಇದು ಶಾಶ್ವತನಿಯಮ; ಏಳನೆಯ ತಿಂಗಳಿನಲ್ಲಿ ಇದನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ಏಳು ದಿನಗಳು ನೀವು ಪರ್ಣಶಾಲೆಗಳಲ್ಲಿ ವಾಸವಾಗಿರಬೇಕು, ಸ್ವದೇಶಸ್ಥರಾದ ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಪರ್ಣಶಾಲೆಗಳಲ್ಲಿಯೇ ವಾಸವಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ನಾನು ನಿಮ್ಮನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಬರಮಾಡಿದಾಗ ಇಸ್ರಾಯೇಲರು ಪರ್ಣಶಾಲೆಗಳಲ್ಲಿ ವಾಸವಾಗಿರುವಂತೆ ಮಾಡಿದೆನೆಂಬುದಾಗಿ ಇದರಿಂದ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ತಿಳಿಯುವುದು. ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು’” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ಯೆಹೋವನಿಂದ ನೇಮಕವಾದ ಹಬ್ಬಗಳ ದಿನಗಳ ವಿಷಯವಾಗಿ ಮೋಶೆಯು ಅದೇ ಮೇರೆಗೆ ಇಸ್ರಾಯೇಲರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ದೇವಸ್ಥಾನದಲ್ಲಿನ ದೀಪಗಳನ್ನು ಪ್ರತಿನಿತ್ಯವೂ ಉರಿಸುವುದಕ್ಕಾಗಿ ಇಸ್ರಾಯೇಲರು ಎಣ್ಣೆಮರದ ಕಾಯಿಗಳನ್ನು ಕುಟ್ಟಿ ತೆಗೆದ ನಿರ್ಮಲವಾದ ಎಣ್ಣೆಯನ್ನು ನಿನಗೆ ತಂದುಕೊಡಬೇಕೆಂದು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷದ ಪೆಟ್ಟಿಗೆಯ ಮುಂದಣ ತೆರೆಯ ಹೊರಗೆ, ಆ ದೀಪಗಳು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಾಯಂಕಾಲದಿಂದ ಬೆಳಗಿನ ಜಾವದ ವರೆಗೂ ಉರಿಯುತ್ತಿರುವಂತೆ ಆರೋನನು ಅವುಗಳನ್ನು ಸರಿಪಡಿಸಬೇಕು. ಇದು ನಿಮಗೂ ಮತ್ತು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತನಿಯಮ. ");
INSERT INTO kanirv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ಅವನು ಪ್ರತಿನಿತ್ಯವೂ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಹಣತೆಗಳನ್ನು ಆ ಚೊಕ್ಕಬಂಗಾರದ ದೀಪಸ್ತಂಭದ ಮೇಲೆ ಸರಿಯಾಗಿ ಇಟ್ಟು ನಿರ್ವಹಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“ಅದಲ್ಲದೆ ನೀನು ಗೋದಿಯ ಹಿಟ್ಟಿನಿಂದ ಹನ್ನೆರಡು ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಬೇಕು; ಪ್ರತಿಯೊಂದು ರೊಟ್ಟಿಯು ಆರಾರು ಸೇರಿನದಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ಅವುಗಳನ್ನು ಆರಾರು ರೊಟ್ಟಿಗಳ ಮೇರೆಗೆ ಎರಡು ರಾಶಿಗಳಾಗಿ, ಚೊಕ್ಕಬಂಗಾರದ ಮೇಜಿನ ಮೇಲೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ಒಂದೊಂದು ರಾಶಿಯ ಮೇಲೆ ಸ್ವಚ್ಛವಾದ ಧೂಪವನ್ನು ಇಡಬೇಕು. ಆ ರೊಟ್ಟಿಗಳ ನೈವೇದ್ಯವನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಆ ಧೂಪವೇ ಯೆಹೋವನಿಗೆ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ಯಾಜಕನು ಯಾವಾಗಲೂ ಪ್ರತಿ ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ರೊಟ್ಟಿಗಳನ್ನು ತಂದು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಕ್ರಮಪಡಿಸಬೇಕು. ಶಾಶ್ವತವಾದ ನಿಬಂಧನೆಯ ಮೇರೆಗೆ ಅವುಗಳನ್ನು ಇಸ್ರಾಯೇಲರಿಗೋಸ್ಕರ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ಅವು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ಸಂತತಿಯವರಿಗೂ ಸಲ್ಲಬೇಕು. ಮಹಾಪರಿಶುದ್ಧವಾದ ಅವುಗಳನ್ನು ದೇವಸ್ಥಾನದ ಪ್ರಾಕಾರದಲ್ಲಿಯೇ ತಿನ್ನಬೇಕು. ಅವು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿತವಾದ ಹೋಮದ್ರವ್ಯಗಳಿಗೆ ಸೇರಿದವುಗಳಾದುದರಿಂದ ಶಾಶ್ವತನಿಯಮದ ಪ್ರಕಾರ ಯಾಜಕರಿಗೇ ಸಲ್ಲಬೇಕು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ಇಸ್ರಾಯೇಲ್ ಸ್ತ್ರೀಯಲ್ಲಿ ಐಗುಪ್ತ ಪುರುಷನಿಂದ ಹುಟ್ಟಿದವನೊಬ್ಬನು ಇಸ್ರಾಯೇಲರ ಪಾಳೆಯದಲ್ಲಿ, ಇಸ್ರಾಯೇಲನಾದ ಒಬ್ಬ ಮನುಷ್ಯನ ಸಂಗಡ ಜಗಳವಾಡುತ್ತಾ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ಅವನು ಯೆಹೋವನ ಹೆಸರನ್ನು ದೂಷಿಸಿ ಆತನನ್ನು ಶಪಿಸಿದ್ದರಿಂದ ಅವರು ಅವನನ್ನು ಮೋಶೆಯ ಬಳಿಗೆ ಹಿಡಿದು ಕರೆದುಕೊಂಡು ಬಂದರು. ಅವನ ತಾಯಿಯು ದಾನ್ ಕುಲದ ದಿಬ್ರೀಯ ಮಗಳಾದ ಶೆಲೋಮೀತ್ ಎಂಬುವವಳು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ಅವನ ವಿಷಯವಾಗಿ ಯೆಹೋವನ ತೀರ್ಪನ್ನು ತಿಳುಕೊಳ್ಳುವ ತನಕ ಅವನನ್ನು ಕಾವಲಲ್ಲಿರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ದೂಷಿಸಿದ ಆ ಮನುಷ್ಯನನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಒಯ್ಯಬೇಕು. ಅವನ ದೂಷಣೆಯ ಮಾತುಗಳನ್ನು ಕೇಳಿದವರೆಲ್ಲರೂ ಅವನ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನಿಟ್ಟನಂತರ ಸಮೂಹದವರೆಲ್ಲರೂ ಅವನನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ಮತ್ತು ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು, ‘ತನ್ನ ದೇವರನ್ನು ದೂಷಿಸಿದವನು ಆ ದೋಷದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ಯೆಹೋವನ ಹೆಸರನ್ನು ನಿಂದಿಸಿದವನಿಗೆ ಮರಣ ಶಿಕ್ಷೆಯಾಗಬೇಕು; ಸಮೂಹದವರೆಲ್ಲರೂ ಅವನನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ಅನ್ಯದೇಶಸ್ಥನೇ ಆಗಿರಲಿ ಅಥವಾ ಸ್ವದೇಶಸ್ಥನೇ ಆಗಿರಲಿ ಯೆಹೋವನ ಹೆಸರನ್ನು ನಿಂದಿಸಿದರೆ ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“‘ಮನುಷ್ಯನನ್ನು ಕೊಂದವನಿಗೆ ಮರಣ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ಪಶುವನ್ನು ಹೊಡೆದು ಕೊಂದವನಿಂದ ಅದಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ಈಡನ್ನು ಕೊಡಿಸಬೇಕು, ಪ್ರಾಣಿಗೆ ಪ್ರತಿಯಾಗಿ ಪ್ರಾಣಿಯನ್ನು ಕೊಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ಯಾವನಾದರೂ ಮತ್ತೊಬ್ಬನನ್ನು ಅಂಗಹೀನಮಾಡಿದರೆ ಅವನು ಮಾಡಿದಂತೆಯೇ ಅವನಿಗೆ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ಅವಯವವನ್ನು ಮುರಿದವನಿಗೆ ಅವಯವವನ್ನು ಮುರಿಯುವುದೇ ಶಿಕ್ಷೆ. ಕಣ್ಣಿಗೆ ಪ್ರತಿಯಾಗಿ ಕಣ್ಣನ್ನೂ, ಹಲ್ಲಿಗೆ ಪ್ರತಿಯಾಗಿ ಹಲ್ಲನ್ನೂ ತೆಗೆಸಬೇಕು. ಮತ್ತೊಬ್ಬನನ್ನು ಅಂಗಹೀನ ಮಾಡಿದವನಿಗೆ ಈ ಪ್ರಕಾರ ಪ್ರತಿಕಾರ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ಪಶುವನ್ನು ಕೊಂದವನು ಅದಕ್ಕೆ ಬದಲಾಗಿ ಈಡು ಕೊಡಬೇಕು. ಮನುಷ್ಯನನ್ನು ಕೊಂದವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ಅನ್ಯರಿಗಾಗಲಿ ಅಥವಾ ಸ್ವದೇಶದವರಿಗಾಗಲಿ ಪಕ್ಷಪಾತವಿಲ್ಲದೆ ಒಂದೇ ನಿಯಮವಿರಬೇಕು. ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು’” ಎಂಬುದೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ಮೋಶೆ ಈ ಮಾತುಗಳನ್ನು ಇಸ್ರಾಯೇಲರಿಗೆ ತಿಳಿಸಲಾಗಿ ಅವರು ದೂಷಿಸಿದವನಾದ ಆ ಮನುಷ್ಯನನ್ನು ಪಾಳೆಯದ ಹೊರಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಕಲ್ಲೆಸೆದು ಕೊಂದುಬಿಟ್ಟರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರಾಯೇಲರು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ಯೆಹೋವನು ಸೀನಾಯಿಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ನಾನು ನಿಮಗೆ ಕೊಡುವ ದೇಶಕ್ಕೆ ನೀವು ಬಂದಾಗ ಆ ದೇಶವೂ ಯೆಹೋವನ ಗೌರವಾರ್ಥವಾಗಿ ಸಬ್ಬತ್ ಕಾಲವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ಆರು ವರ್ಷಗಳು ನೀವು ಹೊಲದಲ್ಲಿ ಬೀಜವನ್ನು ಬಿತ್ತಬಹುದು, ದ್ರಾಕ್ಷಿ ತೋಟದ ಕೆಲಸವನ್ನು ನಡೆಸಬಹುದು ಮತ್ತು ಹೊಲತೋಟಗಳ ಬೆಳೆಗಳನ್ನು ಸಂಗ್ರಹಿಸಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ಆದರೆ ಏಳನೆಯ ವರ್ಷ ಯಾವ ವ್ಯವಸಾಯ ಮಾಡಬಾರದ ವಿಶ್ರಾಂತಿ ಕಾಲವಾಗಿಯೂ ಮತ್ತು ಯೆಹೋವನಿಗೆ ಆಚರಿಸಬೇಕಾದ ಸಬ್ಬತ್ ಕಾಲವಾಗಿಯೂ ಇರಬೇಕು. ಹೊಲದಲ್ಲಿ ಬೀಜವನ್ನು ಬಿತ್ತಬಾರದು, ದ್ರಾಕ್ಷಿತೋಟದ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ಹೊಲದಲ್ಲಿ ತಾನಾಗಿ ಬೆಳೆದ ಪೈರನ್ನು ನೀವು ಕೂಡಿಸಿಟ್ಟುಕೊಳ್ಳಬಾರದು, ನೀವು ನೋಡಿಕೊಳ್ಳದೆ ಬಿಟ್ಟ ದ್ರಾಕ್ಷಾಲತೆಗಳಲ್ಲಿ ಬಂದ ಹಣ್ಣನ್ನು ಸಂಗ್ರಹಿಸಬಾರದು. ಆ ವರ್ಷವೆಲ್ಲಾ ಭೂಮಿಗೆ ಸಂಪೂರ್ಣವಾಗಿ ವಿಶ್ರಾಂತಿಯಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ಆದರೆ ಅಂತಹ ಸಬ್ಬತ್ ಸಂವತ್ಸರದಲ್ಲಿ ತಾನಾಗಿ ಭೂಮಿಯಲ್ಲಿ ಹುಟ್ಟಿದ್ದು ನಿಮಗೂ, ನಿಮ್ಮ ದಾಸದಾಸಿಯರಿಗೂ, ಕೂಲಿಯವರಿಗೂ, ");
INSERT INTO kanirv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ವಾಸವಾಗಿರುವವರಿಗೂ, ನಿಮ್ಮ ಪಶುಗಳಿಗೂ ಮತ್ತು ದೇಶದಲ್ಲಿರುವ ಕಾಡುಮೃಗಗಳಿಗೂ ಆಹಾರವಾಗಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“‘ಅದಲ್ಲದೆ ಏಳು ವರ್ಷಕ್ಕೊಂದರಂತೆ ಏಳು ಸಬ್ಬತ್ ವರ್ಷಗಳನ್ನು ಲೆಕ್ಕಿಸಬೇಕು. ಆ ಏಳು ಸಬ್ಬತ್ ಸಂವತ್ಸರಗಳ ಕಾಲವು ಅಂದರೆ ನಲ್ವತ್ತೊಂಭತ್ತು ವರ್ಷಗಳು ಕಳೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ಆಮೇಲೆ ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ನಿಮ್ಮ ದೇಶದಲ್ಲೆಲ್ಲಾ ಗಟ್ಟಿಯಾಗಿ ಕೊಂಬನ್ನು ಊದಿಸಬೇಕು. ಸಕಲ ದೋಷಪರಿಹಾರಕವಾದ ಆ ದಿನದಲ್ಲೇ ನಿಮ್ಮ ದೇಶದಲ್ಲೆಲ್ಲಾ ಆ ಕೊಂಬನ್ನು ಊದಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ನೀವು ಐವತ್ತನೆಯ ವರ್ಷವನ್ನು ದೇವರಿಗೆ ಮೀಸಲಾದ ವರ್ಷವೆಂದು ಭಾವಿಸಿ, ಅದರಲ್ಲಿ ದೇಶದ ನಿವಾಸಿಗಳೆಲ್ಲರಿಗೂ ಬಿಡುಗಡೆಯಾಯಿತು ಎಂಬುದಾಗಿ ಸಾರಬೇಕು. ಅದು ಜೂಬಿಲಿ ಸಂವತ್ಸರವಾದುದರಿಂದ ನೀವೆಲ್ಲರು ನಿಮ್ಮ ನಿಮ್ಮ ಸ್ವಂತ ಭೂಮಿಗಳಿಗೂ ಮತ್ತು ಸ್ವಜನರ ಬಳಿಗೂ ಹೋಗಿ ಇರಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ಆ ಐವತ್ತನೆಯ ವರ್ಷದಲ್ಲಿ ಅಂದರೆ ಜೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ನೀವು ಬೀಜವನ್ನು ಬಿತ್ತಬಾರದು, ತಾನಾಗಿ ಬೆಳೆದ ಪೈರನ್ನು ಕೂಡಿಸಿಟ್ಟುಕೊಳ್ಳಬಾರದು; ನೀವು ನೋಡಿಕೊಳ್ಳದೆ ಬಿಟ್ಟ ದ್ರಾಕ್ಷಾಲತೆಗಳಲ್ಲಿ ಬೆಳದ ಹಣ್ಣನ್ನು ಸಂಗ್ರಹಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ಅದು ಜೂಬಿಲಿ ವರ್ಷವಾದುದರಿಂದ ನೀವು ಅದನ್ನು ಮೀಸಲಾದದ್ದೆಂದು ಭಾವಿಸಬೇಕು. ಹೊಲದಲ್ಲಿ ತಾನಾಗಿ ಬೆಳೆದದ್ದನ್ನು ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“‘ಜೂಬಿಲಿ ವರ್ಷದಲ್ಲಿ ನಿಮ್ಮ ನಿಮ್ಮ ಸ್ವಂತ ಭೂಮಿಗಳು ತಿರುಗಿ ನಿಮ್ಮ ವಶಕ್ಕೆ ಬರುವವು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ನೀವು ಸ್ಥಿರಸೊತ್ತನ್ನು ಸ್ವದೇಶದವರೊಡನೆ ಕ್ರಯ ಮತ್ತು ವಿಕ್ರಯ ಮಾಡುವಾಗ ಇದರ ವಿಷಯದಲ್ಲಿ ಅನ್ಯಾಯಮಾಡಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ಹಿಂದಿನ ಜೂಬಿಲಿ ಸಂವತ್ಸರದಿಂದ ಎಷ್ಟು ವರ್ಷವಾಯಿತೆಂದು ಲೆಕ್ಕಿಸಿ, ಸ್ವದೇಶದವನಿಂದ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳಬೇಕು; ಅದರಂತೆ ಮಾರುವವನು ಎಷ್ಟು ವರ್ಷಗಳ ಬೆಳೆಯಾಯಿತೆಂದು ಲೆಕ್ಕಿಸಿ ಕ್ರಯಕ್ಕೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ಮುಂದಣ ಜೂಬಿಲಿ ಸಂವತ್ಸರದ ತನಕ ಹೆಚ್ಚು ವರ್ಷಗಳಾದರೆ ಭೂಮಿಯ ಕ್ರಯವನ್ನು ಹೆಚ್ಚಿಸಬೇಕು, ಕಡಿಮೆಯಾದರೆ ಕಡಿಮೆ ಮಾಡಬೇಕು; ಏಕೆಂದರೆ ಅವನು ಮಾರುವುದು ಭೂಮಿಯನ್ನಲ್ಲ, ಲೆಕ್ಕದ ಪ್ರಕಾರ ಬೆಳೆಗಳನ್ನೇ ಮಾರುತ್ತಾನಲ್ಲಾ. ");
INSERT INTO kanirv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ಆದುದರಿಂದ ನೀವು ಒಬ್ಬರಿಗೊಬ್ಬರು ಅನ್ಯಾಯಮಾಡಬಾರದು; ನಿಮ್ಮ ದೇವರಿಗೆ ಭಯಪಡುವವರಾಗಿರಬೇಕು; ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“‘ನನ್ನ ಆಜ್ಞಾವಿಧಿಗಳನ್ನು ನೀವು ಅನುಸರಿಸಿ ನಡೆಯಬೇಕು. ಆಗ ನೀವು ಆ ದೇಶದಲ್ಲಿ ನಿರ್ಭಯವಾಗಿ ವಾಸವಾಗಿರುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ನಿಮ್ಮ ಭೂಮಿಯು ಫಲವತ್ತಾಗುವುದು, ನೀವು ಸಮೃದ್ಧಿಯಾಗಿ ಊಟಮಾಡುವಿರಿ ಮತ್ತು ಆ ದೇಶದಲ್ಲಿ ನೀವು ನಿರ್ಭಯವಾಗಿ ವಾಸಮಾಡುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“‘ಏಳನೆಯ ವರ್ಷದಲ್ಲಿ ಬೀಜವನ್ನು ಬಿತ್ತುವುದಕ್ಕಾಗಲಿ, ಬೆಳೆದದ್ದನ್ನು ಕೂಡಿಸಿಟ್ಟುಕೊಳ್ಳುವುದಕ್ಕಾಗಲಿ ಅಪ್ಪಣೆ ಇಲ್ಲವಲ್ಲಾ; ಆ ವರ್ಷದಲ್ಲಿ ಏನು ತಿನ್ನಬೇಕು?’ ಎಂದು ವಿಚಾರಿಸುತ್ತೀರೋ ");
INSERT INTO kanirv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ಕೇಳಿರಿ, ಆರನೆಯ ವರ್ಷದ ಬೆಳೆ ನನ್ನ ಅನುಗ್ರಹದಿಂದ ಮೂರು ವರ್ಷಗಳ ಬೆಳೆಯಷ್ಟಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ನೀವು ಎಂಟನೆಯ ವರ್ಷದಲ್ಲಿ ಬೀಜವನ್ನು ಬಿತ್ತಿ, ಅದರ ಬೆಳೆ ದೊರೆಯುವ ತನಕ ಅಂದರೆ ಒಂಭತ್ತನೆಯ ವರ್ಷದ ವರೆಗೆ ಹಿಂದಿನ ವರ್ಷಗಳಲ್ಲಿ ನೀವು ಸಂಗ್ರಹಿಸಿದ ಬೆಳೆಯಿಂದಲೇ ಜೀವನಮಾಡುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“‘ಭೂಮಿಯನ್ನು ಶಾಶ್ವತವಾಗಿ ಮಾರಬಾರದು. ಏಕೆಂದರೆ ಆ ಭೂಮಿ ನನ್ನದು; ನೀವಾದರೋ ಪರದೇಶದವರು ಹಾಗೂ ಪ್ರವಾಸಿಗಳಾಗಿ ನನ್ನ ಆಶ್ರಯದಲ್ಲಿ ಇಳಿದುಕೊಂಡವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ನಿಮ್ಮಲ್ಲಿ ಮತ್ತೊಬ್ಬನ ಸ್ವತ್ತಿನ ಭೂಮಿ ನಿಮ್ಮ ವಶಕ್ಕೆ ಬಂದರೆ ಅದನ್ನು ಈಡುಕೊಟ್ಟು ಬಿಡಿಸಿಕೊಳ್ಳುವ ಅಧಿಕಾರವು ಕೊಟ್ಟವನಿಗೆ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“‘ನಿಮ್ಮ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನು ಬಡವನಾಗಿ ತನ್ನ ಭೂಮಿಯನ್ನು ಏನಾದರೂ ಮಾರಿಕೊಂಡರೆ ಅವನ ಸಮೀಪವಾದ ಬಂಧುವು ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ಬಿಡಿಸುವ ಬಂಧುವು ಇಲ್ಲದೆಹೋದ ಪಕ್ಷಕ್ಕೆ ಮಾರಿದವನೇ ಸ್ಥಿತಿವಂತನಾಗಿ ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳುವಷ್ಟು ಹಣವನ್ನು ಸಂಪಾದಿಸಿದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ಆ ಭೂಮಿಯನ್ನು ಮಾರಿದಂದಿನಿಂದ ಕಳೆದ ವರ್ಷಗಳನ್ನು ಬಿಟ್ಟು ಉಳಿದ ಕ್ರಯವನ್ನು ಕೊಟ್ಟು ತನ್ನ ಭೂಮಿಯನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ಅವನು ಆ ಭೂಮಿಯನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳಲಾರದೆ ಹೋದರೆ ಅದು ಜೂಬಿಲಿ ಸಂವತ್ಸರದ ತನಕ ಕೊಂಡುಕೊಂಡವನ ವಶದಲ್ಲೇ ಇರಬೇಕು. ಜೂಬಿಲಿ ವರ್ಷದಲ್ಲಿ ಅದು ಬಿಡುಗಡೆಯಾಗುವುದು; ಆಗ ಆ ಭೂಮಿ ಪುನಃ ಮಾರಿದವನ ವಶಕ್ಕೆ ಬರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“‘ಯಾವನಾದರೂ ಪೌಳಿ ಗೋಡೆಯುಳ್ಳ ಪಟ್ಟಣದಲ್ಲಿರುವ ಮನೆಯನ್ನು ಮಾರಿದರೆ ಅದನ್ನು ಮಾರಿದ ದಿನ ಮೊದಲುಗೊಂಡು ಒಂದು ವರ್ಷ ಪೂರ್ತಿಯಾಗುವುದರೊಳಗೆ ಈಡುಕೊಟ್ಟು ಬಿಡಿಸಬಹುದು; ಪೂರಾ ಒಂದು ವರ್ಷದ ತನಕ ಅದನ್ನು ಬಿಡಿಸುವ ಅಧಿಕಾರವು ಅವನಿಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ಪೌಳಿಗೋಡೆಯುಳ್ಳ ಪಟ್ಟಣದಲ್ಲಿರುವ ಆ ಮನೆ ಒಂದು ವರ್ಷದೊಳಗಾಗಿ ಬಿಡಿಸಿಕೊಳ್ಳಲು ಸಾಧ್ಯವಾಗದೆ ಹೋದರೆ, ಅದು ಜೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ಬಿಡುಗಡೆಯಾಗಿ ಮಾರಿದವನಿಗೆ ಮತ್ತು ಅವನ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತವಾಗಿ ನಿಲ್ಲುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ಪೌಳಿಗೋಡೆಯಿಲ್ಲದ ಊರುಗಳಲ್ಲಿರುವ ಮನೆಗಳು ಬಯಲಿನ ಹೊಲಗಳಂತೆ ಎಣಿಸಲ್ಪಡಬೇಕು; ಅವುಗಳನ್ನು ಬಿಡಿಸುವ ಅಧಿಕಾರವಿದ್ದು, ಜೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ಅವು ಬಿಡುಗಡೆಯಾಗುವವು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ಆದರೆ ಲೇವಿಯರ ಸ್ವತ್ತಾಗಿರುವ ಪಟ್ಟಣಗಳಲ್ಲಿನ ಮನೆಗಳು ಮಾರಲ್ಪಟ್ಟರೆ ಅವುಗಳನ್ನು ಬಿಡಿಸುವ ಅಧಿಕಾರವು ಲೇವಿಯರಿಗೆ ಯಾವಾಗಲೂ ಇರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ಲೇವಿಯರೊಳಗೆ ಯಾರೂ ಅದನ್ನು ಬಿಡಿಸದೆಹೋದರೆ, ಲೇವಿಯರ ಸ್ವಂತವಾಗಿರುವ ಅಂತಹ ಪಟ್ಟಣಗಳಲ್ಲಿ ಮಾರಲ್ಪಟ್ಟ ಮನೆ ಜೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ಬಿಡುಗಡೆಯಾಗುವುದು. ಲೇವಿಯರ ಪಟ್ಟಣಗಳಲ್ಲಿನ ಮನೆಗಳು ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿರುವ ಅವರ ಸ್ವಾಸ್ತ್ಯವಷ್ಡೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ಅವರು ತಮ್ಮ ಪಟ್ಟಣಗಳಿಗೆ ಸೇರಿರುವ ಹುಲ್ಲುಗಾವಲನ್ನು ಮಾರಲೇಬಾರದು. ಅವು ಅವರಿಗೆ ಶಾಶ್ವತವಾದ ಸ್ವತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“‘ನಿಮ್ಮಲ್ಲಿ ಒಬ್ಬ ಸಹೋದರನು ಬಡತನದಿಂದ ಗತಿಹೀನನಾದರೆ, ಅವನು ಬದುಕಿಕೊಳ್ಳುವಂತೆ ನೀವು ಅವನನ್ನು ನಿಮ್ಮ ನಡುವೆ ಇಳಿದುಕೊಂಡ ವಿದೇಶೀಯನೆಂದು ಅಥವಾ ಪ್ರವಾಸಿಯೆಂದು ಭಾವಿಸಿ ಸಹಾಯಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ನೀವು ಅವನಿಂದ ಬಡ್ಡಿಯನ್ನಾಗಲಿ ಅಥವಾ ಲಾಭವನ್ನಾಗಲಿ ತೆಗೆದುಕೊಳ್ಳಬಾರದು; ಅವನು ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ಬದುಕುವಂತೆ ನೀವು ದೇವರಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವರಾಗಿ ನಡೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ನೀವು ಅವನಿಗೆ ಹಣವನ್ನು ಸಾಲವಾಗಿ ಕೊಟ್ಟರೆ ಬಡ್ಡಿಯನ್ನು ಕೇಳಬಾರದು, ದವಸಕೊಟ್ಟರೆ ಲಾಭವನ್ನು ಕೇಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು; ನಿಮಗೆ ದೇವರಾಗುವುದಕ್ಕೂ ಮತ್ತು ನಿಮಗೆ ಕಾನಾನ್ ದೇಶವನ್ನು ಕೊಡುವುದಕ್ಕೂ ನಿಮ್ಮನ್ನು ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದವನು ನಾನೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“‘ನಿಮ್ಮಲ್ಲಿ ಒಬ್ಬ ಸಹೋದರನು ಬಡವನಾಗಿ ತನ್ನನ್ನೇ ಮಾರಿಕೊಂಡರೆ ಅವನನ್ನು ಗುಲಾಮನಂತೆ ಕೆಲಸ ಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ಅವನು ಕೂಲಿಯವನಂತೆಯೂ ಇಲ್ಲವೇ ಪ್ರವಾಸಿಯಂತೆಯೂ ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿದ್ದು, ಜೂಬಿಲಿ ಸಂವತ್ಸರದ ತನಕ ನಿಮ್ಮ ಸೇವೆಯನ್ನು ಮಾಡಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ಆಗ ಅವನನ್ನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳನ್ನೂ ಬಿಟ್ಟುಬಿಡಬೇಕು; ಅವನು ಸ್ವಜನರ ಬಳಿಗೂ ಪಿತ್ರಾರ್ಜಿತ ಸ್ವತ್ತಿಗೂ ಹೋಗಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ಅವರು ನನಗೆ ಗುಲಾಮರಾಗಿದ್ದಾರೆ; ನಾನು ಅವರನ್ನು ಐಗುಪ್ತದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದೆನು; ದಾಸರನ್ನು ಮಾರುವಂತೆ ಅವರನ್ನು ಮಾರಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ಅವರಿಂದ ಕಠಿಣವಾಗಿ ಸೇವೆಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು; ನಿಮ್ಮ ದೇವರಿಗೆ ಭಯಪಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","ನಿಮಗೆ ದಾಸದಾಸಿಯರು ಬೇಕಾಗಿದ್ದರೆ ಸುತ್ತಲಿರುವ ಅನ್ಯರನ್ನು ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ನಿಮ್ಮ ನಡುವೆ ಇರುವ ವಿದೇಶಿಯರನ್ನೂ ಮತ್ತು ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಅವರಿಂದ ಹುಟ್ಟಿದವರನ್ನೂ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳಬಹುದು; ಅಂಥವರು ನಿಮಗೆ ಸೊತ್ತಾಗಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ನೀವು ಅಂಥವರನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಂಡು ನಿಮ್ಮ ತರುವಾಯ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಸ್ವತ್ತಾಗಿ ಕೊಟ್ಟು ಬಿಡಬಹುದು. ಅವರನ್ನು ಶಾಶ್ವತ ದಾಸರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಬಹುದು. ಇಸ್ರಾಯೇಲರಾದ ನೀವಾದರೋ ಎಲ್ಲರೂ ಸಹೋದರರಾಗಿರುವುದರಿಂದ ಒಬ್ಬರಿಂದ ಒಬ್ಬರು ಕಠಿಣವಾಗಿ ಸೇವೆಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“‘ನಿಮ್ಮ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನು ಬಡವನಾಗಿದ್ದು ನಿಮ್ಮ ನಡುವೆ ಮನೆಮಾಡಿಕೊಂಡ ಧನವಂತನಾದ ಅನ್ಯದೇಶದವನಿಗಾಗಲಿ ಅಥವಾ ಅವನಿಗೆ ಸೇರಿದವನಿಗಾಗಲಿ ತನ್ನನ್ನು ಮಾರಿಕೊಂಡಿದ್ದರೂ ಅವನಿಗೆ ಬಿಡುಗಡೆಯಾಗಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ಅವನ ಬಂಧುಗಳಲ್ಲಿ ಯಾರಾದರೂ ಈಡುಕೊಟ್ಟು ಅವನನ್ನು ಬಿಡಿಸಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ಅವನ ದೊಡ್ಡಪ್ಪ, ಚಿಕ್ಕಪ್ಪಂದಿರಾಗಲಿ, ಇವರ ಮಕ್ಕಳಾಗಲಿ ಅಥವಾ ಸಮೀಪಬಂಧುಗಳಲ್ಲಿ ಯಾರೇ ಆಗಲಿ ಈಡುಕೊಟ್ಟು ಅವನನ್ನು ಬಿಡಿಸಬಹುದು. ಬೇಕಾದಷ್ಟು ಹಣವು ದೊರೆತರೆ ತನ್ನನ್ನು ತಾನೇ ಬಿಡಿಸಿಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ಅವನು ತನ್ನನ್ನು ಮಾರಿಕೊಂಡ ವರ್ಷ ಮೊದಲುಗೊಂಡು ಮುಂದಣ ಜೂಬಿಲಿ ಸಂವತ್ಸರದ ತನಕ ದಣಿಯ ಸಂಗಡ ವರ್ಷಗಳ ಲೆಕ್ಕವನ್ನು ಮಾಡಿ ಆ ಲೆಕ್ಕದ ಮೇರೆಗೆ ಬಿಡುಗಡೆಯ ಕ್ರಯವನ್ನು ಕೊಡಬೇಕು. ಕೂಲಿಯವನ ವಿಷಯದಲ್ಲಿ ಲೆಕ್ಕ ಮಾಡುವಂತೆ ಅವನ ವಿಷಯದಲ್ಲಿಯೂ ಲೆಕ್ಕ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ಜೂಬಿಲಿ ಸಂವತ್ಸರವು ಬರುವುದಕ್ಕೆ ಇನ್ನು ಅನೇಕ ವರ್ಷಗಳಿದ್ದರೆ ಅವುಗಳ ಪ್ರಕಾರವೇ ತನ್ನ ಬಿಡುಗಡೆಯ ಕ್ರಯವನ್ನೂ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ಕೆಲವು ವರ್ಷಗಳು ಮಾತ್ರ ಉಳಿದರೆ ಸ್ವಲ್ಪಭಾಗವನ್ನೂ ದಣಿಗೆ ಕೊಟ್ಟು ತನ್ನನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ಅವನು ವರ್ಷವರ್ಷಕ್ಕೆ ಗೊತ್ತುಮಾಡಿಕೊಂಡ ಕೂಲಿಯವನಂತೆಯೇ ದಣಿಯ ಬಳಿಯಲ್ಲಿರಬೇಕು. ಆ ದಣಿ ಅವನಿಂದ ಕಠಿಣವಾಗಿ ಸೇವೆಮಾಡಿಸಿಕೊಳ್ಳುವುದನ್ನು ನೀವು ನೋಡಿ ಸುಮ್ಮನೆ ಇರಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ಮೇಲೆ ಹೇಳಿದ ರೀತಿಯಲ್ಲಿ ಅವನು ಬಿಡಿಸಿಕೊಳ್ಳದೆ ಹೋದರೆ ಜೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ಅವನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ಬಿಡುಗಡೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ಏಕೆಂದರೆ ಇಸ್ರಾಯೇಲರು ನನ್ನ ದಾಸರೇ; ನಾನು ಅವರನ್ನು ಐಗುಪ್ತದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದೆನಲ್ಲವೇ. ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ನೀವು ವಿಗ್ರಹಗಳನ್ನು ಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು; ಕೆತ್ತಿದ ಪ್ರತಿಮೆಯನ್ನಾಗಲಿ ಅಥವಾ ಕಲ್ಲು ಕಂಬವನ್ನಾಗಲಿ ನಿಲ್ಲಿಸಿಕೊಳ್ಳಬಾರದು; ಅಡ್ಡಬೀಳುವುದಕ್ಕಾಗಿ ವಿಚಿತ್ರವಾಗಿ ಕೆತ್ತಿದ ಕಲ್ಲುಗಳನ್ನು ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಇಡಬಾರದು; ನಾನೇ ಯೆಹೋವನೆಂಬ ನಿಮ್ಮ ದೇವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","ನಾನು ನೇಮಿಸಿರುವ ಸಬ್ಬತ್ ದಿನಗಳನ್ನು ನೀವು ಆಚರಿಸಬೇಕು; ನನ್ನ ದೇವಸ್ಥಾನದ ವಿಷಯದಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವರಾಗಿರಬೇಕು. ನಾನು ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ನೀವು ನನ್ನ ನಿಯಮಗಳನ್ನು ಕೈಕೊಂಡು, ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಅನುಸರಿಸಿ ನಡೆದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ನಾನು ಮುಂಗಾರು ಮತ್ತು ಹಿಂಗಾರು ಮಳೆಗಳನ್ನು ಆಯಾ ಕಾಲದಲ್ಲಿಯೇ ಬರಮಾಡುವೆನು; ನಿಮ್ಮ ಹೊಲಗಳು ಒಳ್ಳೆಯ ಬೆಳೆಯನ್ನು ಕೊಡುವವು ಹಾಗು ತೋಟದ ಮರಗಳು ಹೇರಳವಾದ ಫಲಕೊಡುವವು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ಕಣತುಳಿಸುವ ಕೆಲಸವು ದ್ರಾಕ್ಷಿಯ ಬೆಳೆಯ ಕಾಲದ ತನಕ ಮತ್ತು ದ್ರಾಕ್ಷಿಯ ಬೆಳೆಯನ್ನು ಕೂಡಿಸುವ ಕೆಲಸವು ಬಿತ್ತನೆಯ ಕಾಲದ ವರೆಗೂ ನಡೆಯುವವು, ನೀವು ಸಮೃದ್ಧಿಯಾಗಿ ಊಟ ಮಾಡುವಿರಿ, ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಸುರಕ್ಷಿತವಾಗಿ ವಾಸಮಾಡುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ನಿಮಗೆ ಸಮಾಧಾನವನ್ನು ಅನುಗ್ರಹಿಸುವೆನು; ಯಾರ ಭಯವೂ ಇಲ್ಲದೆ ಮಲಗಿಕೊಳ್ಳುವಿರಿ; ದುಷ್ಟಮೃಗಗಳನ್ನು ದೇಶದಿಂದ ತೆಗೆದುಹಾಕುವೆನು; ನಿಮ್ಮ ದೇಶವು ಶತ್ರುಗಳ ಕತ್ತಿಯಿಂದ ಹಾಳಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ನೀವು ನಿಮ್ಮ ವೈರಿಗಳನ್ನು ಓಡಿಸುವಿರಿ ಮತ್ತು ಅವರನ್ನು ಕತ್ತಿಯಿಂದ ಸಂಹರಿಸುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ನಿಮ್ಮಲ್ಲಿ ಐದು ಜನರು ನೂರು ಜನರನ್ನೂ ಮತ್ತು ನೂರು ಜನರು ಹತ್ತು ಸಾವಿರ ಜನರನ್ನೂ ಓಡಿಸುವರು; ನಿಮ್ಮ ಶತ್ರುಗಳು ನಿಮ್ಮ ಕತ್ತಿಯಿಂದ ಹತರಾಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ನಾನು ನಿಮ್ಮ ಮೇಲೆ ಕಟಾಕ್ಷವಿಟ್ಟು ಬಹುಸಂತಾನವನ್ನು ಕೊಟ್ಟು ಹೆಚ್ಚಿಸುವೆನು; ನಿಮ್ಮೊಂದಿಗೆ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಸ್ಥಿರಪಡಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ನೀವು ಬಹುದಿನದಿಂದ ಇಟ್ಟುಕೊಂಡಿರುವ ಹಳೆಯ ಧಾನ್ಯವನ್ನು ಊಟಮಾಡುವಿರಿ; ಹೊಸದಕ್ಕೆ ಸ್ಥಳ ಉಂಟಾಗುವಂತೆ ಹಳೆಯದನ್ನು ತೆಗೆಯುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ನಾನು ನಿಮ್ಮ ನಡುವೆ ವಾಸಮಾಡುವೆನು; ನಿಮ್ಮನ್ನು ತಳ್ಳಿಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ನಿಮ್ಮ ನಡುವೆ ತಿರುಗಾಡುತ್ತಾ ನಿಮಗೆ ದೇವರಾಗಿರುವೆನು, ನೀವು ನನಗೆ ಪ್ರಜೆಯಾಗಿರುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ನೀವು ಐಗುಪ್ತ್ಯರಿಗೆ ಗುಲಾಮರಾಗಿರಬಾರದೆಂದು ನಿಮ್ಮನ್ನು ಅವರ ದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಾನೇ; ನಿಮ್ಮನ್ನು ಕುಗ್ಗಿಸಿದ ನೊಗವನ್ನು ಮುರಿದು ನೀವು ನೆಟ್ಟಗೆ ನಿಂತು ನಡೆಯುವಂತೆ ಮಾಡಿದವನು ನಾನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ಆದರೆ ನೀವು ನನ್ನ ಮಾತನ್ನು ಕೇಳದೆ ಈ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ಅನುಸರಿಸದೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ನನ್ನ ನಿಯಮಗಳನ್ನು ಬೇಡವೆಂದು ನನ್ನ ವಿಧಿಗಳನ್ನು ತಳ್ಳಿಬಿಟ್ಟರೆ ನೀವು ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಅನುಸರಿಸದೆ ನನ್ನ ನಿಬಂಧನೆಯನ್ನು ಮೀರಿ ನಡೆದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ನಾನು ನಿಮಗೆ ಮಾಡುವುದೇನೆಂದರೆ, ಕ್ಷಯರೋಗ, ಚಳಿಜ್ವರ ಮುಂತಾದ ಭಯಂಕರ ವ್ಯಾಧಿಗಳನ್ನು ನಿಮ್ಮಲ್ಲಿ ಇರುವಂತೆ ಮಾಡುವೆನು; ಇವುಗಳ ದೆಸೆಯಿಂದ ನೀವು ಕಂಗೆಟ್ಟವರಾಗಿಯೂ, ಮನಗುಂದಿದವರಾಗಿಯೂ ಇರುವಿರಿ. ನೀವು ಬೀಜಬಿತ್ತಿದಾಗ ಅದರ ಫಲವು ನಿಮಗೆ ದೊರೆಯದೆ ಹೋಗುವುದು; ಶತ್ರುಗಳು ಬಂದು ಅದನ್ನು ತಿಂದುಬಿಡುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ನಾನು ನಿಮ್ಮ ಮೇಲೆ ಉಗ್ರಕೋಪಗೊಳ್ಳುವುದರಿಂದ ನೀವು ನಿಮ್ಮ ಶತ್ರುಗಳ ಮುಂದೆ ಸೋತು ಹೋಗುವಿರಿ; ನಿಮ್ಮ ವೈರಿಗಳು ನಿಮ್ಮನ್ನು ಆಳುವರು; ಯಾರೂ ಬೆನ್ನಟ್ಟಿ ಬರದಿದ್ದರು ನೀವು ಹೆದರಿ ಓಡುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ಇಷ್ಟಾದರೂ ನೀವು ನನ್ನ ಮಾತಿಗೆ ಲಕ್ಷ್ಯಕೊಡದೆ ಹೋದರೆ ನಾನು ನಿಮ್ಮ ಪಾಪಗಳ ನಿಮಿತ್ತ ಏಳರಷ್ಟಾಗಿ ನಿಮ್ಮನ್ನು ಶಿಕ್ಷಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ನಿಮ್ಮ ಗರ್ವಕ್ಕೆ ಕಾರಣವಾದ ಬಲವನ್ನು ಮುರಿಯುವೆನು. ನಿಮ್ಮ ಮೇಲಿರುವ ಆಕಾಶವನ್ನು ಕಬ್ಬಿಣದಂತೆಯೂ ಹಾಗು ನೀವು ಸಾಗುವಳಿಮಾಡುವ ಭೂಮಿಯನ್ನು ತಾಮ್ರದಂತೆಯೂ ಮಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ನೀವು ದುಡಿದದ್ದೆಲ್ಲಾ ವ್ಯರ್ಥವಾಗುವುದು; ನಿಮ್ಮ ಭೂಮಿಯಲ್ಲಿ ಬೆಳೆಯಾಗುವುದಿಲ್ಲ, ತೋಟಗಳ ಮರಗಳು ಫಲ ಕೊಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ನೀವು ನನ್ನ ಮಾತನ್ನು ಕೇಳದೆ ನನ್ನ ವಿರುದ್ಧವಾಗಿ ನಡೆದರೆ ನಾನು ನಿಮ್ಮ ಪಾಪಗಳ ನಿಮಿತ್ತ ಇನ್ನೂ ಏಳರಷ್ಟಾಗಿ ನಿಮ್ಮನ್ನು ಬಾಧಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ನಿಮ್ಮ ಮೇಲೆ ಕಾಡುಮೃಗಗಳನ್ನು ಬರಮಾಡುವೆನು; ಅವು ನಿಮ್ಮ ಮಕ್ಕಳನ್ನು ಕದ್ದುಕೊಂಡು ಹೋಗುವವು, ನಿಮ್ಮ ಪಶುಗಳನ್ನು ಕೊಲ್ಲುವವು, ನಿಮ್ಮನ್ನು ಸ್ವಲ್ಪ ಜನರನ್ನಾಗಿ ಮಾಡುವವು; ನಿಮ್ಮ ದಾರಿಗಳು ಪಾಳು ಬೀಳುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ಇಷ್ಟು ಶಿಕ್ಷೆಗಳಿಂದಲೂ ನೀವು ನನ್ನ ಆಜ್ಞೆಗೆ ಒಳಗಾಗದೆ ನನಗೆ ವಿರೋಧವಾಗಿ ನಡೆದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ನಿಮ್ಮ ಪಾಪಗಳ ನಿಮಿತ್ತ ನಾನೇ ನಿಮ್ಮನ್ನು ಏಳರಷ್ಟಾಗಿ ಬಾಧಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ಶತ್ರುಗಳ ಕತ್ತಿಯ ಮೂಲಕವಾಗಿ ನಿಮ್ಮನ್ನು ಸಂಹರಿಸುವೆನು; ನೀವು ನನ್ನ ನಿಬಂಧನೆಯನ್ನು ಮೀರಿದ್ದರಿಂದ ಆ ಕತ್ತಿಯು ಪ್ರತಿದಂಡನೆಮಾಡುವುದು. ನೀವು ನಿಮ್ಮ ಪಟ್ಟಣಗಳಲ್ಲಿ ಕೂಡಿರುವಾಗ ನಿಮ್ಮಲ್ಲಿ ಅಂಟುರೋಗ ಉಂಟಾಗುವಂತೆ ಮಾಡುವೆನು; ಹೀಗೆ ನೀವು ಶತ್ರುಗಳ ಕೈಗೆ ಬೀಳುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ನಾನು ನಿಮ್ಮ ಜೀವನಾಧಾರವನ್ನು ತೆಗೆದುಬಿಟ್ಟಾಗ ಹತ್ತು ಜನರು ಹೆಂಗಸರು ಒಂದೇ ಒಲೆಯಲ್ಲಿ ರೊಟ್ಟಿಸುಟ್ಟು, ಅದನ್ನು ತೂಕದ ಪ್ರಕಾರ ಹಂಚಿಕೊಡುವರು; ನೀವು ಅದನ್ನು ಊಟಮಾಡಿದಾಗ ತೃಪ್ತಿಹೊಂದುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ಇದನ್ನೆಲ್ಲಾ ನೀವು ಅನುಭವಿಸಿದ ಮೇಲೆಯೂ ಇನ್ನೂ ನನ್ನ ಮಾತನ್ನು ಕೇಳದೆ ನನಗೆ ವಿರೋಧವಾಗಿ ನಡೆದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ನಾನು ನಿಮ್ಮ ಮೇಲೆ ಕೋಪಗೊಂಡವನಾಗಿ ನಿಮ್ಮ ಪಾಪಗಳ ನಿಮಿತ್ತ ಏಳರಷ್ಟಾಗಿ ಶಿಕ್ಷಿಸುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ನೀವು ನಿಮ್ಮ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳ ಮಾಂಸವನ್ನೇ ತಿನ್ನುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ನಿಮ್ಮ ಪೂಜಾಸ್ಥಳಗಳನ್ನು ಇಲ್ಲದಂತೆ ಮಾಡುವೆನು; ನೀವು ಸೂರ್ಯನ ಪೂಜೆಗೆ ಇಟ್ಟಿರುವ ಕಂಬಗಳನ್ನು ಕಡಿದುಹಾಕುವೆನು; ನಿಮ್ಮ ವಿಗ್ರಹಗಳ ಮೇಲೆ ನಿಮ್ಮ ಹೆಣಗಳನ್ನು ಬೀಸಾಡುವೆನು; ನಾನು ನಿಮ್ಮ ವಿಷಯದಲ್ಲಿ ಅಸಹ್ಯಪಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ನಿಮ್ಮ ಪಟ್ಟಣಗಳನ್ನು ಹಾಳುಮಾಡುವೆನು. ನಿಮ್ಮ ದೇವಸ್ಥಾನಗಳನ್ನು ನಾಶಮಾಡುವೆನು; ನೀವು ಸಮರ್ಪಿಸುವ ಸುಗಂಧದ್ರವ್ಯಗಳ ಪರಿಮಳವನ್ನು ನಾನು ಮೂಸಿಯೂ ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ನಾನು ನಿಮ್ಮ ದೇಶವನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ಹಾಳುಮಾಡುವೆನು; ಅದರಲ್ಲಿ ವಾಸವಾಗಿರುವ ನಿಮ್ಮ ಶತ್ರುಗಳೂ ಅದನ್ನು ನೋಡಿ ಆಶ್ಚರ್ಯಪಡುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ನಿಮ್ಮನ್ನು ಅನ್ಯಜನಗಳಲ್ಲಿ ಚದುರಿಸಿ, ನಿಮ್ಮ ಹಿಂದೆ ಕತ್ತಿಯನ್ನು ಬೀಸುವೆನು. ನಿಮ್ಮ ದೇಶವು ಹಾಳಾಗುವುದು, ನಿಮ್ಮ ಪಟ್ಟಣಗಳು ನಾಶವಾಗುವವು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ನೀವು ನಿಮ್ಮ ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿ ಸೆರೆ ಇರುವ ದಿನಗಳಲ್ಲೆಲ್ಲಾ ನಿಮ್ಮ ದೇಶವು ಹಾಳುಬಿದ್ದು ತನಗೆ ಸಲ್ಲಬೇಕಾಗಿದ್ದ ಸಬ್ಬತ್ ಕಾಲವನ್ನು ಅನುಭವಿಸುವುದು; ಅದು ವಿಶ್ರಾಂತಿಯನ್ನು ಹೊಂದಿ ಸಬ್ಬತ್ ಕಾಲವನ್ನು ಅನುಭವಿಸುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ನೀವು ಅದರಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾಗ ಅದಕ್ಕೆ ತಕ್ಕ ಸಬ್ಬತ್ ಕಾಲದಲ್ಲಿ ದೊರೆಯದ ವಿಶ್ರಾಂತಿಯನ್ನು, ಅದು ಹಾಳುಬಿದ್ದಿರುವ ಎಲ್ಲಾ ದಿನಗಳಲ್ಲಿ ಅನುಭವಿಸುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ನಿಮ್ಮಲ್ಲಿ ಯಾರಾರು ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿ ಉಳಿದಿರುವರೋ ಅವರ ಹೃದಯಗಳಲ್ಲಿ ನಾನು ಭೀತಿಯನ್ನು ಹುಟ್ಟಿಸುವೆನು. ಗಾಳಿಯಿಂದ ಬಡಿದಾಡುವ ಉದುರೆಲೆಯ ಸಪ್ಪಳವೂ ಅವರಲ್ಲಿ ದಿಗಿಲು ಹುಟ್ಟಿಸುವುದು. ಅವರು ಆ ಸಪ್ಪಳವನ್ನು ಕೇಳಿ ಕತ್ತಿಯ ಎದುರಿನಿಂದ ಓಡಿಹೋಗುವವರಂತೆ ಓಡಿಹೋಗುವರು. ಯಾರೂ ಬೆನ್ನಟ್ಟಿ ಬಾರದಿರುವಾಗಲೂ ಅವರು ಓಡಿಹೋಗಿ ಬೀಳುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ಯಾರೂ ಓಡಿಸದಿದ್ದರೂ ಕತ್ತಿಗೆ ಹೆದರಿ ಓಡುವವರಂತೆ ಒಬ್ಬರ ಮೇಲೊಬ್ಬರು ಬೀಳುವರು; ಶತ್ರುಗಳ ಮುಂದೆ ನಿಲ್ಲಲಾರದೆ ತತ್ತರಿಸುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ಅನ್ಯಜನಗಳಲ್ಲಿ ಚದರಿಸಲ್ಪಟ್ಟು ಕಾಣಿಸದೆ ಹೋಗುವಿರಿ, ನಿಮ್ಮ ಶತ್ರುಗಳ ದೇಶವು ನಿಮ್ಮನ್ನು ನುಂಗಿಬಿಡುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ನಿಮ್ಮಲ್ಲಿ ಉಳಿದವರು ತಮ್ಮ ಪಾಪದ ದೆಸೆಯಿಂದಲೂ ಮತ್ತು ತಮ್ಮ ಪೂರ್ವಿಕರ ಪಾಪದ ದೆಸೆಯಿಂದಲೂ ಅವರಂತೆಯೇ ಶತ್ರುಗಳ ದೇಶಗಳಲ್ಲಿ ಕ್ಷೀಣವಾಗಿ ಹೋಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ಆದರೆ ಅವರು ತಾವೂ ಹಾಗು ತಮ್ಮ ಪೂರ್ವಿಕರು ನನಗೆ ದ್ರೋಹಿಗಳಾಗಿ ಪಾಪಮಾಡಿದವರೆಂದೂ ಅರಿಕೆಮಾಡಿದರೆ, ತಾವು ನನಗೆ ವಿರೋಧವಾಗಿ ನಡೆದುದರಿಂದಲೇ ");
INSERT INTO kanirv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ನಾನು ಅವರಿಗೆ ವಿರೋಧವಾಗಿ ನಡೆದುಕೊಂಡು ಶತ್ರುದೇಶದಲ್ಲಿ ಸೆರೆಯವರನ್ನಾಗಿ ಮಾಡಬೇಕಾಯಿತೆಂದೂ ಒಪ್ಪಿ, ತಮ್ಮ ಮೊಂಡತನವನ್ನು ಬಿಟ್ಟು ನನ್ನ ಆಜ್ಞೆಗೆ ತಲೆ ಬಾಗಿ ತಮ್ಮ ಪಾಪದಿಂದುಂಟಾದ ಶಿಕ್ಷೆಯನ್ನು ಸ್ವೀಕರಿಸುವುದಾದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ನಾನು ಯಾಕೋಬ್ ಇಸಾಕ್ ಅಬ್ರಹಾಮ್ ಇವರಿಗೆ ಮಾಡಿದ ಒಡಂಬಡಿಕೆಯನ್ನು ನೆನಪಿಗೆ ತಂದುಕೊಂಡು ನೆರವೇರಿಸುವೆನು; ಅವರ ಸ್ವದೇಶವನ್ನೂ ನಾನು ದಯೆಯಿಂದ ಜ್ಞಾಪಿಸಿಕೊಳ್ಳುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ಅವರು ಬಿಟ್ಟುಹೋದ ಸ್ವದೇಶವು ನಿರ್ಜನವಾಗಿ ಬಿದ್ದಿರುವಾಗ ತನಗೆ ಸಲ್ಲಬೇಕಾದ ಸಬ್ಬತ್ ವಿಶ್ರಾಂತಿಯನ್ನು ಅನುಭವಿಸಬೇಕು. ಅವರು ಯೆಹೋವನ ಆಜ್ಞೆ ಬೇಡವೆಂದು ಆತನ ವಿಧಿಗಳನ್ನು ತಾತ್ಸಾರ ಮಾಡಿದ ಕಾರಣವೇ ತಮ್ಮ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ಆದರೂ ಅವರು ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿರುವಾಗಲೂ ನಾನು ಅವರನ್ನು ಬೇಡವೆನ್ನುವುದಿಲ್ಲ, ತಾತ್ಸಾರಮಾಡುವುದಿಲ್ಲ; ನಾನು ಅವರಿಗೆ ಮಾಡಿದ ಒಡಂಬಡಿಕೆಯನ್ನು ಮೀರುವುದಿಲ್ಲ, ಅವರನ್ನು ಇಲ್ಲದಂತೆ ಮಾಡುವುದಿಲ್ಲ; ನಾನು ಅವರ ದೇವರಾದ ಯೆಹೋವನಲ್ಲವೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ಅವರ ಪೂರ್ವಿಕರ ಸಂಗಡ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಯನ್ನು ನೆನಪಿಗೆ ತಂದುಕೊಂಡು ಅವರಿಗೆ ಹಿತವನ್ನು ಮಾಡುವೆನು. ನಾನು ಅವರಿಗೆ ದೇವರಾಗಿರಬೇಕೆಂದು ಅವರ ಪೂರ್ವಿಕರನ್ನು ಎಲ್ಲಾ ಜನಾಂಗಗಳ ಎದುರಿನಲ್ಲಿಯೇ ಐಗುಪ್ತದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದೆನಲ್ಲವೇ. ನಾನು ಯೆಹೋವನು” ಎಂಬುದೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ಯೆಹೋವನು ಸೀನಾಯಿಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯ ಮೂಲಕವಾಗಿ ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡು ಅವರಿಗೆ ಕೊಟ್ಟ ಆಜ್ಞಾವಿಧಿಗಳೇ ಇವು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ಯಾವನಾದರೂ ಮನುಷ್ಯರ ಪ್ರಾಣಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಹರಕೆಮಾಡಿ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ಅವುಗಳನ್ನು ಬಿಡಿಸುವುದಕ್ಕೆ ದೇವರ ಸೇವೆಗೆ ನೇಮಕವಾದ ಶೆಕೆಲ್ ಮೇರೆಗೆ ನೀವು ಅವನಿಂದ ಕೊಡಿಸಬೇಕಾದ ಈಡು ಹೀಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ಇಪ್ಪತ್ತು ವರ್ಷದಿಂದ ಅರುವತ್ತು ವರ್ಷದ ವರೆಗಿನ ವಯಸ್ಸುಳ್ಳ ಪುರುಷನಿಗೋಸ್ಕರ, ದೇವಾಲಯದ ಶೆಕೆಲ್ ಗೆ ಸರಿಯಾಗಿ ಐವತ್ತು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ಅದೇ ವಯಸ್ಸಿನ ಸ್ತ್ರೀಗೋಸ್ಕರ ಮೂವತ್ತು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ಐದು ವರ್ಷದ ವಯಸ್ಸಿನಿಂದ ಇಪ್ಪತ್ತು ವರ್ಷದ ವಯಸ್ಸಿನ ವರೆಗೆ ಪುರುಷನಿಗೋಸ್ಕರ ಇಪ್ಪತ್ತು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯನ್ನು ಮತ್ತು ಸ್ತ್ರೀಗೋಸ್ಕರ ಹತ್ತು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ಒಂದು ತಿಂಗಳಿನ ವಯಸ್ಸು ಮೊದಲುಗೊಂಡು ಐದು ವರ್ಷದ ವಯಸ್ಸಿನ ಹುಡುಗನಿಗೋಸ್ಕರ ಐದು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯನ್ನು, ಹುಡುಗಿಗೋಸ್ಕರ ಮೂರು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ಅರವತ್ತು ವರ್ಷಗಳ ಪ್ರಾಯವನ್ನು ದಾಟಿದ ಪುರುಷನಿಗೋಸ್ಕರ ಹದಿನೈದು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯನ್ನು ಮತ್ತು ಸ್ತ್ರೀಗೋಸ್ಕರ ಹತ್ತು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ಯಾವನಾದರೂ ಬಡವನಾಗಿ ನೇಮಕವಾದ ಹಣವನ್ನು ಕೊಡಲಾರದೆ ಹೋದರೆ, ಅವನು ಹರಕೆಮಾಡಿ ಪ್ರತಿಷ್ಠಿಸಿದ ಮನುಷ್ಯನನ್ನು ಯಾಜಕನ ಮುಂದೆ ನಿಲ್ಲಿಸಬೇಕು. ಯಾಜಕನು ಹರಕೆಮಾಡಿದವನ ಸ್ಥಿತಿಗತಿಗೆ ತಕ್ಕಂತೆ ಅವನು ಕೊಡಬೇಕಾದ ಹಣ ಇಷ್ಟೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“‘ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬಹುದಾದ ಪಶುವನ್ನು ಯಾವನಾದರೂ ಹರಕೆಮಾಡಿ ಪ್ರತಿಷ್ಠಿಸಿದ್ದಾದರೆ ಅದು ದೇವರ ಸೊತ್ತಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ಅದನ್ನು ಬದಲಾಯಿಸಬಾರದು, ಕೆಟ್ಟದ್ದಕ್ಕೆ ಬದಲಾಗಿ ಒಳ್ಳೆಯದನ್ನೂ ಇಲ್ಲವೇ ಒಳ್ಳೆಯದಕ್ಕೆ ಬದಲಾಗಿ ಕೆಟ್ಟದ್ದನ್ನೂ, ಒಂದಕ್ಕೆ ಬದಲಾಗಿ ಬೇರೊಂದನ್ನೂ ಕೊಡಬಾರದು. ಅವನು ಗೊತ್ತುಮಾಡಿದ ಪಶುವಿಗೆ ಬದಲಾಗಿ ಬೇರೊಂದು ಪಶುವನ್ನು ಪ್ರತ್ಯೇಕಿಸಿಟ್ಟಿರುವ ಪಕ್ಷಕ್ಕೆ, ಮೊದಲನೆಯ ಪಶುವೂ ಹಾಗೂ ಅದಕ್ಕೆ ಬದಲಾಗಿ ಇಟ್ಟ ಪಶುವೂ ಎರಡೂ ಯೆಹೋವನದಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಪಶುವು ಅಶುದ್ಧವಾಗಿದ್ದರೆ, ಅದನ್ನು ಯಾಜಕನ ಮುಂದೆ ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ಅದು ಒಳ್ಳೆಯದೋ ಅಥವಾ ಕೆಟ್ಟದ್ದೋ ಎಂದು ಯಾಜಕನು ನೋಡಿಕೊಂಡು ಅದರ ಬೆಲೆ ಇಷ್ಟೆಂದು ನಿರ್ಣಯಿಸಬೇಕು; ಯಾಜಕನು ನಿರ್ಣಯಿಸಿದ ಬೆಲೆಯೇ ಅಂತಿಮವಾದದ್ದು ಸ್ಥಿರವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ಹರಕೆಮಾಡಿದವನು ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬೇಕೆಂದಿದ್ದರೆ ಅದರ ಕ್ರಯದೊಡನೆ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“‘ಯಾವನಾದರೂ ತನ್ನ ಮನೆಯನ್ನು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ಯಾಜಕನು ಅದು ಉತ್ತಮವಾದ ಮನೆಯೋ ಅಲ್ಲವೋ ಎಂದು ಪರೀಕ್ಷಿಸಿ ಬೆಲೆಯನ್ನು ನಿರ್ಣಯಿಸಬೇಕು; ಯಾಜಕನು ನಿರ್ಣಯಿಸಿದ ಬೆಲೆ ಅಂತಿಮವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ಹರಕೆಮಾಡಿದವನು ಪ್ರತಿಷ್ಠೆ ಮಾಡಿದ ಆ ಮನೆಯನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬೇಕೆಂದಿದ್ದರೆ ಅದರ ಕ್ರಯದೊಡನೆ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಡಬೇಕು; ಆಗ ಆ ಮನೆ ಅವನದಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“‘ಯಾವನಾದರೂ ಪಿತ್ರಾರ್ಜಿತ ಭೂಮಿಯಲ್ಲಿ ಒಂದು ಭಾಗವನ್ನು ಯೆಹೋವನಿಗೆ ಹರಕೆಮಾಡಿ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ಅದರಲ್ಲಿ ಇಷ್ಟು ಬೀಜವನ್ನು ಬಿತ್ತತಕ್ಕದ್ದು ಎಂದು ಆಲೋಚಿಸಿ ಅದರ ಬೆಲೆಯನ್ನು ನಿರ್ಣಯಿಸಬೇಕು. ಒಂದು ಓಮೆರ್ ಜವೆಗೋದಿಯನ್ನು ಬಿತ್ತಬಹುದಾದ ಹೊಲವು ಐವತ್ತು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯ ಬೆಲೆ ಬಾಳುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ಅವನು ಜೂಬಿಲಿ ಸಂವತ್ಸರದಿಂದ ಆ ಹೊಲವನ್ನು ಪ್ರತಿಷ್ಠಿಸಿದರೆ ಈ ಕ್ರಯ ಸ್ಥಿರವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ಜೂಬಿಲಿ ಸಂವತ್ಸರದ ತರುವಾಯ ಪ್ರತಿಷ್ಠೆ ಮಾಡಿದ ಭೂಮಿಯನ್ನು ಹರಕೆಮಾಡಿದರೆ, ಮುಂದಣ ಜೂಬಿಲಿ ಸಂವತ್ಸರಕ್ಕೆ ಕಳೆಯಬೇಕಾದ ವರ್ಷಗಳ ಸಂಖ್ಯೆಯ ಮೇರೆಗೆ ಅದರ ಬೆಲೆಯನ್ನು ಕಡಿಮೆಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ಹರಕೆಮಾಡಿದವನು ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬೇಕೆಂದಿರುವ ಪಕ್ಷಕ್ಕೆ ಅದರ ಕ್ರಯದೊಡನೆ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಡಬೇಕು; ಆಗ ಆ ಹೊಲ ಅವನದಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ತಾನು ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳದೆ ಮತ್ತೊಬ್ಬನಿಗೆ ಮಾರಿದರೆ ಮುಂದೆ ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳುವ ಅಧಿಕಾರವಿರುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ಬಿಡುಗಡೆಯಾಗುವ ಜೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ಆ ಹೊಲವು ಯೆಹೋವನಿಗೆ ಪವಿತ್ರವಾದ ಹೊಲದಂತೆ ಆತನ ಸೊತ್ತಾಗಿಯೇ ಇರಬೇಕು; ಅದು ಯಾಜಕರ ವಶದಲ್ಲಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“‘ಯಾವನಾದರೂ ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡ ಹೊಲವನ್ನು ಅಂದರೆ ಪಿತ್ರಾರ್ಜಿತ ಭೂಮಿಗೆ ಸೇರದಿರುವ ಹೊಲವನ್ನು ಯೆಹೋವನಿಗೆ ಹರಕೆಮಾಡಿ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ಯಾಜಕನು ಮುಂದಣ ಜೂಬಿಲಿ ಸಂವತ್ಸರದ ತನಕ ಇರುವ ವರ್ಷಗಳಿಗೆ ತಕ್ಕಂತೆ ಅದರ ಬೆಲೆಯನ್ನು ನಿರ್ಣಯಿಸಬೇಕು. ಪ್ರತಿಷ್ಠಿಸಿದವನು ನಿರ್ಣಯಿಸಲ್ಪಟ್ಟ ಹಣವನ್ನು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾದದ್ದೆಂದು ಭಾವಿಸಿ ಅದೇ ದಿನದಲ್ಲಿ ಕೊಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ಜೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ಆ ಹೊಲವು ಮಾರಿದವನಿಗೆ ಅಂದರೆ ಯಾರ ಪಿತ್ರಾರ್ಜಿತ ಭೂಮಿಗೆ ಸೇರಿದೆಯೋ ಅವನಿಗೆ ಪುನಃ ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ದೇವರ ಸೇವೆಯಲ್ಲಿ ನೇಮಕವಾದ ಎಲ್ಲಾ ತೂಕವು ದೇವಾಲಯದ ಶೆಕೆಲ್ ಮೇರೆಗೆ ಇರಬೇಕು. ಇಪ್ಪತ್ತು ಗೇರಾ ತೂಕವು ಒಂದು ಶೆಕೆಲಿಗೆ ಸಮವಾಗಿರಬೇಕೆಂದು ಯಾವಾಗಲೂ ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“‘ಶುದ್ಧ ಪಶುವಿನಲ್ಲಿ ಚೊಚ್ಚಲಾಗಿ ಹುಟ್ಟಿದ್ದು ಯೆಹೋವನದಾಗಿರುವುದರಿಂದ ಅದನ್ನು ಯಾರೂ ಹರಕೆಯಾಗಿ ಕೊಡಬಾರದು; ಹೋರಿಯಾಗಿದ್ದರೂ, ಆಡು ಅಥವಾ ಕುರಿಯಾಗಿದ್ದರೂ ಅದು ಯೆಹೋವನ ಸೊತ್ತೇ. ");
INSERT INTO kanirv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ಅಶುದ್ಧ ಪಶುವಿನಲ್ಲಿ ಚೊಚ್ಚಲಮರಿ ಹುಟ್ಟಿದ್ದಾದರೆ ಹರಕೆಮಾಡಿದವನು ನಿರ್ಣಯವಾದ ಬೆಲೆಯೊಂದಿಗೆ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಟ್ಟು ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬಹುದು. ಅವನು ಬಿಡಿಸದೆ ಹೋದರೆ ಅದನ್ನು ನಿರ್ಣಯಿಸಲ್ಪಟ್ಟ ಕ್ರಯಕ್ಕೆ ಮಾರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“‘ಯಾವನಾದರೂ ಮನುಷ್ಯನನ್ನಾಗಲಿ, ಪಶುಪ್ರಾಣಿಯನ್ನಾಗಲಿ, ಪಿತ್ರಾರ್ಜಿತ ಭೂಮಿಯನ್ನಾಗಲಿ ಅಥವಾ ಬೇರೆ ಯಾವುದನ್ನಾಗಲಿ ಯಾವ ಷರತ್ತೂ ಇಲ್ಲದೆ ಸಂಪೂರ್ಣವಾಗಿ ಯೆಹೋವನದಾಗಿರುವುದಕ್ಕೆ ಹರಕೆಮಾಡಿ ಕೊಟ್ಟರೆ, ಅದನ್ನು ಮಾರಲೂ ಬಾರದು, ಬಿಡಿಸಿಕೊಳ್ಳಲೂ ಬಾರದು. ಕೇವಲ ಯೆಹೋವನದಾಗಿರುವುದಕ್ಕೆ ಸಮರ್ಪಿಸುವಂಥದೆಲ್ಲಾ ಯೆಹೋವನಿಗೆ ಮೀಸಲಾಗಿಯೇ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ಕೇವಲ ಯೆಹೋವನ ಸೊತ್ತಾಗುವುದಕ್ಕೆ ಒಪ್ಪಿಸಲ್ಪಟ್ಟದ್ದು ಮನುಷ್ಯ ಜಾತಿಯಾದರೆ ಬಿಡಿಸುವುದಕ್ಕಾಗದು; ಅವನಿಗೆ ಮರಣವೇ ಆಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“‘ಹೊಲದ ಬೆಳೆಯಾಗಲಿ ಇಲ್ಲವೇ ತೋಟದ ಹಣ್ಣುಗಳಾಗಲಿ ಭೂಮಿಯಿಂದುಂಟಾದ ಎಲ್ಲಾ ಆದಾಯದಲ್ಲಿ ಹತ್ತನೆಯ ಒಂದು ಪಾಲು ಯೆಹೋವನದಾಗಿರಬೇಕು, ಅದು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ಯಾವನಾದರೂ ತಾನು ಕೊಡಬೇಕಾದ ಹತ್ತನೆಯ ಒಂದು ಪಾಲಿನಲ್ಲಿ ಏನಾದರೂ ಬಿಡಿಸಿಕೊಳ್ಳಬೇಕೆಂದಿದ್ದರೆ ಅಷ್ಟರೊಡನೆ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ದನಗಳಾಗಲಿ ಇಲ್ಲವೇ ಹಿಂಡಿನ ಆಡು ಅಥವಾ ಕುರಿಗಳಾಗಲಿ ಕುರುಬನು ಲೆಕ್ಕಮಾಡಿದ ಎಲ್ಲಾ ಪಶುಗಳಲ್ಲಿ ಪ್ರತಿ ಹತ್ತನೆಯದು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ಆ ಪಶುವು ಒಳ್ಳೇದೋ ಅಥವಾ ಕೆಟ್ಟದ್ದೋ ಎಂದು ನೋಡಬಾರದು; ಅದನ್ನು ಬದಲಾಯಿಸಬಾರದು. ಕೊಡಬೇಕಾದವನು ಅದನ್ನು ಬದಲಾಯಿಸಿದ್ದಾದರೆ ಅವನು ಮೊದಲು ಲೆಕ್ಕಿಸಿದ್ದೂ ಮತ್ತು ಅದಕ್ಕೆ ಬದಲಾಗಿ ಇಟ್ಟದ್ದೂ ಎರಡೂ ಯೆಹೋವನದಾಗಿರಬೇಕು; ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳುವ ಅಧಿಕಾರವಿರುವುದಿಲ್ಲ’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ಯೆಹೋವನು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯ ಮೂಲಕ ಇಸ್ರಾಯೇಲರಿಗೆ ಕೊಟ್ಟ ಆಜ್ಞೆಗಳು ಇವೇ.");
INSERT INTO kanirv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ಇಸ್ರಾಯೇಲರು ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಟ ಎರಡನೆಯ ವರ್ಷದ ಎರಡನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಸೀನಾಯಿ ಅರಣ್ಯದಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಹೀಗೆ ಮಾತನಾಡಿದನು, ");
INSERT INTO kanirv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದ ಗಂಡಸರನ್ನು ಗೋತ್ರದ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಹೆಸರು ಹಿಡಿದು ಒಬ್ಬೊಬ್ಬರನ್ನಾಗಿ ಲೆಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರನ್ನು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರೆಲ್ಲರನ್ನು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ನೀನೂ ಆರೋನನೂ ಲೆಕ್ಕಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ಈ ಕೆಲಸಕ್ಕಾಗಿ ಕುಲದಲ್ಲಿ ಆಯಾ ಕುಲದ ಒಂದೊಂದು ಮುಖ್ಯಸ್ಥನಾಗಿರುವ ಒಬ್ಬೊಬ್ಬ ಸಹಾಯಕನಿರಬೇಕು ಹಾಗೂ ತನ್ನ ಕುಲಕ್ಕಾಗಿ ಹೋರಾಡುವ ಜನರನ್ನು ಮುಖ್ಯಸ್ಥನು ಮುನ್ನಡೆಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ನಿಮಗೆ ಸಹಾಯಮಾಡಬೇಕಾದ ಪುರುಷರು ಯಾರಾರೆಂದರೆ: ರೂಬೇನ್ ಕುಲದಿಂದ ಶೆದೇಯೂರನ ಮಗನಾದ ಎಲೀಚೂರ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ಸಿಮೆಯೋನ್ ಕುಲದಿಂದ ಚೂರೀಷದ್ದೈಯ ಮಗನಾದ ಶೆಲುಮೀಯೇಲ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ಯೆಹೂದ ಕುಲದಿಂದ ಅಮ್ಮೀನಾದಾಬನ ಮಗನಾದ ನಹಶೋನ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ಇಸ್ಸಾಕಾರ್ ಕುಲದಿಂದ ಚೂವಾರನ ಮಗನಾದ ನೆತನೇಲ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ಜೆಬುಲೂನ್ ಕುಲದಿಂದ ಹೇಲೋನನ ಮಗನಾದ ಎಲೀಯಾಬ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ಯೋಸೇಫನ ವಂಶದವರಲ್ಲಿ: ಎಫ್ರಾಯೀಮ್ ಕುಲದಿಂದ ಅಮ್ಮೀಹೂದನ ಮಗನಾದ ಎಲೀಷಾಮಾ, ಮನಸ್ಸೆ ಕುಲದಿಂದ ಪೆದಾಚೂರನ ಮಗನಾದ ಗಮ್ಲೀಯೇಲ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ಬೆನ್ಯಾಮೀನ್ ಕುಲದಿಂದ ಗಿದ್ಯೋನಿಯ ಮಗನಾದ ಅಬೀದಾನ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ದಾನ್ ಕುಲದಿಂದ ಅಮ್ಮೀಷದ್ದೈಯ ಮಗನಾದ ಅಹೀಗೆಜೆರ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ಆಶೇರ್ ಕುಲದಿಂದ ಒಕ್ರಾನನ ಮಗನಾದ ಪಗೀಯೇಲ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ಗಾದ್ ಕುಲದಿಂದ ರೆಗೂವೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫ್, ");
INSERT INTO kanirv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ನಫ್ತಾಲಿ ಕುಲದಿಂದ ಏನಾನನ ಮಗನಾದ ಅಹೀರ.” ");
INSERT INTO kanirv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ಇವರು ಸರ್ವಸಮೂಹದೊಳಗಿಂದ ಆಯ್ದುಕೊಂಡು ನೇಮಕವಾದವರು. ಇವರು ತಮ್ಮ ಕುಲಗಳಲ್ಲಿ ಪ್ರಧಾನಪುರುಷರು ಹಾಗೂ ಇಸ್ರಾಯೇಲಿನ ಕುಲಗಳ ಪ್ರಮುಖರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ಹೆಸರಿನಿಂದ ಸೂಚಿತರಾದ ಈ ಪುರುಷರನ್ನು ಮೋಶೆಯು ಮತ್ತು ಆರೋನನು ಆರಿಸಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ಅವರು ಎರಡನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಸಮಸ್ತ ಪುರುಷರನ್ನೂ ಸಮೂಹದವರೆಲ್ಲರನ್ನೂ ಕೂಡಿಸಿದರು. ಇಪ್ಪತ್ತು ವರ್ಷ ಹಾಗೂ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳವರೆಲ್ಲರೂ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಗೋತ್ರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ತಮ್ಮತಮ್ಮ ವಂಶಾವಳಿಯನ್ನು ಬರೆಯಿಸಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ಹೀಗೆ ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಮೋಶೆ ಸೀನಾಯಿ ಅರಣ್ಯದಲ್ಲಿ ಅವರನ್ನು ಲೆಕ್ಕಮಾಡಿ ಮೊಟ್ಟಮೊದಲು ಜನಗಣತಿ ಪ್ರಾರಂಭಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ಇಸ್ರಾಯೇಲಿನ ಚೊಚ್ಚಲ ಮಗನಾದ ರೂಬೇನನ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಲೆಕ್ಕಮಾಡಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ರೂಬೇನನ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 46,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ಸಿಮೆಯೋನನ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ಸಿಮೆಯೋನನ ಗೋತ್ರದಲ್ಲಿ ಎಣಿಕೆಯಾದ ಗಂಡಸರು - 59,300 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ಗಾದ್ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರೆಸರಾಗಿ ಲೆಕ್ಕಮಾಡಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ಗಾದ್ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 45,650 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ಯೆಹೂದ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ಯೆಹೂದ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 74,600 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ಇಸ್ಸಾಕಾರ್ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ಇಸ್ಸಾಕಾರ್ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 54,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ಜೆಬುಲೂನ್ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ಜೆಬುಲೂನ್ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 57,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ಯೋಸೇಫನಿಂದ ಹುಟ್ಟಿದವರೊಳಗೆ ಎಫ್ರಾಯೀಮ್ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ಎಫ್ರಾಯೀಮ್ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 40,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","ಮನಸ್ಸೆ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ಮನಸ್ಸೆ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 32,200 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ಬೆನ್ಯಾಮೀನ್ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ಬೆನ್ಯಾಮೀನ್ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 35,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ದಾನ್ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ದಾನ್ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 62,700 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ಆಶೇರ್ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ಆಶೇರ್ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 41,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ನಫ್ತಾಲಿ ವಂಶದವರಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಹೆಸರು ಹಿಡಿದು ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ನಫ್ತಾಲಿ ಗೋತ್ರದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರು - 53,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ಮೋಶೆ, ಆರೋನನೂ ಮತ್ತು ಇಸ್ರಾಯೇಲಿನ ಹನ್ನೆರಡು ಕುಲಗಳ ನಾಯಕರು ಲೆಕ್ಕಮಾಡಿದ ಇಸ್ರಾಯೇಲರ ಜನರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರಾಗಿದ್ದು ಸೈನಿಕರಾಗಿ ಹೊರಡತಕ್ಕವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 6,03,550 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ಆದರೆ ಅವರೊಡನೆ ಲೇವಿ ಕುಲದ ಕುಟುಂಬಗಳು ಲೆಕ್ಕಿಸಲ್ಪಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ಏಕೆಂದರೆ ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ನೀನು ಇಸ್ರಾಯೇಲರನ್ನು ಎಣಿಸುವಾಗ ಲೇವಿ ಕುಲದವರನ್ನು ಎಣಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ಆಜ್ಞಾಶಾಸನಗಳಿರುವ ಗುಡಾರವನ್ನೂ ಅದರ ಸಾಮಾನು, ಉಪಕರಣ ಇವುಗಳನ್ನೂ ನೋಡಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಲೇವಿಯರನ್ನು ನೇಮಿಸಬೇಕು. ಅವರು ಆ ಗುಡಾರವನ್ನೂ ಮತ್ತು ಅದರ ಸಾಮಾನುಗಳನ್ನೂ ಹೊರುವುದಕ್ಕಾಗಿ ಇರಬೇಕು. ಅವರು ಅದರ ಸೇವೆಯನ್ನು ಮಾಡುವವರಾಗಿ ಅದರ ಸುತ್ತಲೂ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ಗುಡಾರವು ಹೊರಡುವಾಗ ಲೇವಿಯರೇ ಅದನ್ನು ಬಿಚ್ಚಬೇಕು; ಇಳಿದುಕೊಳ್ಳುವಾಗ ಲೇವಿಯರೇ ಅದನ್ನು ಹಾಕಬೇಕು. ಇತರರು ಹತ್ತಿರಕ್ಕೆ ಬಂದರೆ ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ಇಸ್ರಾಯೇಲರ ಆಯಾ ಸೈನ್ಯಗಳು ತಮ್ಮ ಡೇರೆಗಳನ್ನು ತಮ್ಮತಮ್ಮ ದಂಡಿನ ಧ್ವಜದ ಹತ್ತಿರ ಹಾಕಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ಆದರೆ ಲೇವಿಯರು ಮಾತ್ರ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಸುತ್ತಲೂ ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಹೀಗಾದರೆ ಯೆಹೋವನ ಕೋಪವು ಇಸ್ರಾಯೇಲರ ಮೇಲೆ ಬರುವುದಕ್ಕೆ ಆಸ್ಪದವಿರುವುದಿಲ್ಲ. ಲೇವಿಯರು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಕಾಯುವವರಾಗಿರಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಎಲ್ಲವನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ಯೆಹೋವನು ಮಾತನಾಡಿ ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಒಬ್ಬೊಬ್ಬರಾಗಿ ಕುಟುಂಬದ ಗುರುತುಗಳ ಪ್ರಕಾರ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸುತ್ತಲೂ ಸ್ವಲ್ಪ ದೂರವಾಗಿ ಡೇರೆಗಳನ್ನು ತಮ್ಮ ತಮ್ಮ ದಂಡಿನ ಧ್ವಜದ ಹತ್ತಿರದಲ್ಲಿ ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಎದುರಿನಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ದೇವದರ್ಶನ ಗುಡಾರದ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಸೂರ್ಯೋದಯವಾಗುವ ಕಡೆಗೆ ಯೆಹೂದ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದವರು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ತಮ್ಮ ದಂಡಿನ ಧ್ವಜದ ಹತ್ತಿರ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಯೆಹೂದ ಕುಲದ ಸೈನ್ಯಾಧಿಪತಿಯು ಅಮ್ಮೀನಾದಾಬನ ಮಗನಾದ ನಹಶೋನನು. ");
INSERT INTO kanirv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 74,600 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ಯೆಹೂದ ಕುಲದ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವವರು ಇಸ್ಸಾಕಾರನ ಕುಲದವರು. ಚೂವಾರನ ಮಗನಾದ ನೆತನೇಲನು ಇಸ್ಸಾಕಾರರ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 54,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ಇಸ್ಸಾಕಾರರ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವವರು ಜೆಬುಲೂನ್ ಕುಲದವರು. ಹೇಲೋನನ ಮಗನಾದ ಎಲೀಯಾಬನು ಜೆಬುಲೂನ್ಯರ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 57,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ಹೀಗೆ ಯೆಹೂದ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದವರ ಸೈನಿಕರ ಒಟ್ಟು ಸಂಖ್ಯೆ 1,86,400 ಮಂದಿ. ಇವರು ಮುಂಭಾಗದಲ್ಲಿ ಹೊರಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ದಕ್ಷಿಣ ದಿಕ್ಕಿನಲ್ಲಿ ರೂಬೇನ್ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದವರು ಸೈನ್ಯ ಸೈನ್ಯವಾಗಿ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಶೆದೇಯೂರನ ಮಗನಾದ ಎಲೀಚೂರನು ರೂಬೇನ್ ಕುಲದ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 46,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ರೂಬೇನ್ ಕುಲದವರ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವವರು ಸಿಮೆಯೋನ್ ಕುಲದವರು. ಚೂರೀಷದ್ದೈಯನ ಮಗನಾದ ಶೆಲುಮೀಯೇಲನು ಸಿಮೆಯೋನ್ ಕುಲದ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 59,300 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ತರುವಾಯ ಗಾದ್ಯರ ಕುಲದವರು. ರೆಗೂವೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫನು ಗಾದ್ ಕುಲದ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 45,650 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ಹೀಗೆ ರೂಬೇನ್ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದ ಸೈನಿಕರ ಒಟ್ಟು ಸಂಖ್ಯೆ 1,51,450 ಮಂದಿ. ಇವರು ಎರಡನೆಯ ದಂಡಾಗಿ ಹೊರಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ಅನಂತರ ಸೈನ್ಯಗಳ ಮಧ್ಯದಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರವು ಲೇವಿಯರ ಪಾಳೆಯದಿಂದ ಹೊರಡಬೇಕು. ಅವರು ಇಳಿದುಕೊಳ್ಳುವ ಪ್ರಕಾರವೇ ತಮ್ಮ ತಮ್ಮ ಧ್ವಜಗಳನ್ನು ಹಿಡಿದುಕೊಂಡು ತಮಗೆ ಗೊತ್ತಾದ ಸ್ಥಾನದಲ್ಲಿ ಹೊರಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ಪಶ್ಚಿಮ ದಿಕ್ಕಿನಲ್ಲಿ ಎಫ್ರಾಯೀಮ್ ದಂಡಿಗೆ ಸೇರಿದವರು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಅಮ್ಮೀಹೂದನ ಮಗನಾದ ಎಲೀಷಾಮಾನು ಎಫ್ರಾಯೀಮ್ ಕುಲದ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 40,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ಎಫ್ರಾಯೀಮ್ ಬಳಿಯಲ್ಲಿ ಮನಸ್ಸೆ ಕುಲದವರೂ ತಮ್ಮ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಪೆದಾಚೂರನ ಮಗನಾದ ಗಮ್ಲೀಯೇಲ್ ಮನಸ್ಸೆ ಕುಲದ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 32,200 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ತರುವಾಯ ಬೆನ್ಯಾಮೀನ ಕುಲದವರು. ಗಿದ್ಯೋನಿಯ ಮಗನಾದ ಅಬೀದಾನ್ ಬೆನ್ಯಾಮೀನ ಕುಲದ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 35,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ಹೀಗೆ ಎಫ್ರಾಯೀಮ್ಯರ ದಂಡಿಗೆ ಸೇರಿದ ಸೈನಿಕರ ಒಟ್ಟು ಸಂಖ್ಯೆ 1,08,100 ಮಂದಿ. ಇವರು ಮೂರನೆಯ ದಂಡಾಗಿ ಹೊರಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ಉತ್ತರ ದಿಕ್ಕಿನಲ್ಲಿ ದಾನ್ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದವರು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಅಮ್ಮೀಷದ್ದೈಯ ಮಗನಾದ ಅಹೀಗೆಜೆರ್ ದಾನ್ ಕುಲದ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 62,700 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ದಾನ್ ಕುಲದ ಬಳಿಯಲ್ಲಿ ಆಶೇರ್ ಕುಲದವರು ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಒಕ್ರಾನನ ಮಗನಾದ ಪಗೀಯೇಲನು ಆಶೇರ್ ಕುಲದವರ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 41,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ತರುವಾಯ ನಫ್ತಾಲಿ ಕುಲದವರು, ಏನಾನನ ಮಗನಾದ ಅಹೀರನು ನಫ್ತಾಲಿ ಕುಲದ ಸೈನ್ಯಾಧಿಪತಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ಅವನ ಸೈನಿಕರ ಸಂಖ್ಯೆ 53,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ಹೀಗೆ ದಾನ್ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದ ಸೈನಿಕರ ಒಟ್ಟು ಸಂಖ್ಯೆ 1,57,600 ಮಂದಿ. ಇವರು ಕಡೆಯ ದಂಡಾಗಿ ಹೊರಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಇಸ್ರಾಯೇಲರ ಗೋತ್ರಗಳ ಪ್ರಕಾರ ದಂಡುಗಳಲ್ಲಿ ಸೈನಿಕರಾಗಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 6,03,550 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಲೇವಿಯರು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಲೆಕ್ಕಹಾಕಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರಾಯೇಲರು ಮಾಡಿದರು. ಹಾಗೆಯೇ ದಂಡು ದಂಡಾಗಿ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳುತ್ತಿದ್ದರು ಮತ್ತು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರವೇ ಹೊರಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ಯೆಹೋವನು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿದ ಕಾಲದಲ್ಲಿದ್ದ ಮೋಶೆ ಮತ್ತು ಆರೋನರ ವಂಶದವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ಆರೋನನ ಮಕ್ಕಳ ಹೆಸರುಗಳು: ಚೊಚ್ಚಲ ಮಗನಾದ ನಾದಾಬ್, ಅಬೀಹೂ, ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಎಂಬುವವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ಇವರು ಯಾಜಕ ಉದ್ಯೋಗವನ್ನು ನಡೆಸುವುದಕ್ಕಾಗಿ ಅಭಿಷೇಕಹೊಂದಿದವರಾಗಿ ಪ್ರತಿಷ್ಠಿತರಾದ ಆರೋನನ ಮಕ್ಕಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ಆದರೆ ನಾದಾಬ್ ಮತ್ತು ಅಬೀಹೂ ಎಂಬುವವರು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸದೇ ಇದ್ದ ಬೇರೆ ಬೆಂಕಿಯಿಂದ ಧೂಪವನ್ನು ಸಮರ್ಪಿಸಿದ್ದರಿಂದ ಆತನ ಸನ್ನಿಧಿಯಲ್ಲೇ ಸತ್ತು ಹೋದರು. ಅವರಿಗೆ ಮಕ್ಕಳಿರಲಿಲ್ಲ. ಆದುದರಿಂದ ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಎಂಬಿಬ್ಬರು ತಮ್ಮ ತಂದೆಯಾದ ಆರೋನನ ಕೈಕೆಳಗೆ ಯಾಜಕಧರ್ಮವನ್ನು ನಡೆಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ನೀನು ಲೇವಿಯ ಕುಲದವರನ್ನು ಹತ್ತಿರಕ್ಕೆ ಕರೆದು ಅವರು ದೇವರ ಸೇವಕಾರ್ಯಕ್ಕಾಗಿ ಯಾಜಕನಾದ ಆರೋನನ ಕೈಕೆಳಗಿರುವಂತೆ ಅವನ ಮುಂದೆ ನಿಲ್ಲಿಸು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","“ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಳಿಯಲ್ಲಿದ್ದು, ಆರೋನನಿಗೋಸ್ಕರವೂ ಸರ್ವಸಮೂಹದವರಿಗೋಸ್ಕರವೂ ದೇವಸ್ಥಾನದ ಸೇವಾಕಾರ್ಯವನ್ನು ನಡೆಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಸಾಮಾನುಗಳನ್ನು ಕಾಯಬೇಕು. ಇಸ್ರಾಯೇಲರಿಗೋಸ್ಕರ ದೇವಸ್ಥಾನದ ಸೇವಕಾರ್ಯವನ್ನು ನಡೆಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“ನೀನು ಲೇವಿಯರನ್ನು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳಿಗೂ ಒಪ್ಪಿಸಬೇಕು. ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಆರೋನನಿಗೆ ಸಂಪೂರ್ಣವಾಗಿ ಒಪ್ಪಿಸಲ್ಪಟ್ಟವರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ಯಾಜಕ ಉದ್ಯೋಗವನ್ನು ನಡೆಸುವುದಕ್ಕಾಗಿ ಆರೋನನನ್ನು ಮತ್ತು ಅವನ ಮಕ್ಕಳನ್ನು ನೇಮಿಸಬೇಕು. ಇತರರು ಆ ಕೆಲಸಕ್ಕೆ ಕೈಹಾಕಿದರೆ ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಅವನಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ನಾನು ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಚೊಚ್ಚಲಾದ ಗಂಡಸರಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರನ್ನು ತೆಗೆದುಕೊಂಡಿದ್ದೇನೆ ಎಂದು ತಿಳಿದುಕೋ. ಆದುದರಿಂದ ಲೇವಿಯರು ನನ್ನ ಸೊತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಚೊಚ್ಚಲಾದವರು ನನ್ನ ಸೊತ್ತು. ಐಗುಪ್ತ ದೇಶದಲ್ಲಿದ್ದ ಚೊಚ್ಚಲಾದದ್ದನ್ನೆಲ್ಲಾ ನಾನು ಸಂಹಾರಮಾಡಿದಾಗ ಇಸ್ರಾಯೇಲರಲ್ಲಿರುವ ಚೊಚ್ಚಲಾದ ಮನುಷ್ಯರನ್ನೂ, ಪಶುಗಳನ್ನೂ ನನ್ನ ಸ್ವಂತವಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡೆನು; ಅವರು ನನ್ನವರಾಗಿರಬೇಕು. ನಾನೇ ಯೆಹೋವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ಯೆಹೋವನು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ನೀನು ಲೇವಿಯರಲ್ಲಿ ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳ ಗಂಡಸರನ್ನೆಲ್ಲಾ ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆ ಅವರನ್ನು ಲೆಕ್ಕಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ಲೇವಿಯ ಮಕ್ಕಳು ಯಾರೆಂದರೆ: ಗೇರ್ಷೋನ್, ಕೆಹಾತ್ ಮತ್ತು ಮೆರಾರೀ ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ಗೋತ್ರಸ್ಥಾಪಕರಾದ ಗೇರ್ಷೋನನ ಮಕ್ಕಳು: ಲಿಬ್ನೀ, ಶಿಮ್ಮೀ ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ಗೋತ್ರಸ್ಥಾಪಕರಾದ ಕೆಹಾತನ ಮಕ್ಕಳು: ಅಮ್ರಾಮ್, ಇಚ್ಹಾರ್, ಹೆಬ್ರೋನ್, ಉಜ್ಜೀಯೇಲ್, ಎಂಬುವವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ಗೋತ್ರಸ್ಥಾಪಕರಾದ ಮೆರಾರೀಯ ಮಕ್ಕಳು: ಮಹ್ಲೀ, ಮೂಷೀ ಎಂಬುವವರು. ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಇವರೇ ಲೇವಿಯ ವಂಶದವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ಗೇರ್ಷೋನ್ ವಂಶದವರಲ್ಲಿ ಲಿಬ್ನೀ ಗೋತ್ರದವರೂ ಶಿಮ್ಮೀ ಗೋತ್ರದವರೂ ಇದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ಅವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳ ಗಂಡಸರ ಸಂಖ್ಯೆ 7,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ಗೇರ್ಷೋನ್ಯರ ಗೋತ್ರದವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಹಿಂದೆ ಅಂದರೆ ಪಶ್ಚಿಮ ದಿಕ್ಕಿನಲ್ಲಿ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ಗೇರ್ಷೋನ್ಯರ ಗೋತ್ರಗಳ ಪ್ರಧಾನಪುರುಷನು ಲಾಯೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫ್. ");
INSERT INTO kanirv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ದೇವದರ್ಶನದ ಗುಡಾರದ ಉಪಕರಣಗಳಲ್ಲಿ ಗೇರ್ಷೋನನ ವಂಶದವರು ನೋಡಿಕೊಳ್ಳಬೇಕಾದವುಗಳು ಯಾವುದೆಂದರೆ: ಗುಡಾರ ಅದರ ಮೇಲಣ ಡೇರೆಯ ಬಟ್ಟೆ, ಅದರ ಮೇಲ್ಹೊದಿಕೆ, ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿರುವ ಪರದೆಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ಗುಡಾರದ ಮತ್ತು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಲಿರುವ ಅಂಗಳದ ತೆರೆಗಳೂ, ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆಗಳು, ಇವುಗಳ ಹಗ್ಗಗಳೂ ಇವೇ. ಇಂತಹ ಸಕಲವಿಧವಾದ ಸೇವಕಾರ್ಯವನ್ನು ಗೇರ್ಷೋನ್ಯರು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ಕೆಹಾತ್ ವಂಶದವರಲ್ಲಿ ಅಮ್ರಾಮ್ ಗೋತ್ರದವರು, ಇಚ್ಹಾರ್ ಗೋತ್ರದವರೂ, ಹೆಬ್ರೋನ್ ಗೋತ್ರದವರೂ, ಉಜ್ಜೀಯೇಲ್ ಗೋತ್ರದವರೂ ಇದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ಅವರಲ್ಲಿ ದೇವಸ್ಥಾನವನ್ನು ನೋಡಿಕೊಳ್ಳತಕ್ಕವರು ಅಂದರೆ ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳ ಗಂಡಸರ ಸಂಖ್ಯೆ 8,600 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ಕೆಹಾತ್ಯರ ಗೋತ್ರಗಳವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ದಕ್ಷಿಣ ದಿಕ್ಕಿನಲ್ಲಿ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ಕೆಹಾತ್ಯರ ಗೋತ್ರಗಳ ಪ್ರಧಾನಪುರುಷನು ಉಜ್ಜೀಯೇಲನ ಮಗನಾದ ಎಲೀಚಾಫಾನ್. ");
INSERT INTO kanirv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ಅವರು ನೋಡಿಕೊಳ್ಳಬೇಕಾದವುಗಳು ಯಾವುದೆಂದರೆ: ಮಂಜೂಷವು, ಮೇಜು, ದೀಪಸ್ತಂಭಗಳು, ಯಜ್ಞವೇದಿಗಳು, ದೇವಸ್ಥಾನದ ಸೇವೆಯ ಉಪಕರಣಗಳು, ಒಳಗಣ ತೆರೆಗಳು ಇವುಗಳೇ. ಇವುಗಳ ಸಕಲವಿಧವಾದ ಸೇವಕಾರ್ಯವನ್ನು ಅವರು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ಅದಲ್ಲದೆ ಮಹಾಯಾಜಕ ಆರೋನನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನು ಲೇವಿಯರ ಪ್ರಧಾನಪುರುಷರ ಅಧ್ಯಕ್ಷನಾಗಿ ದೇವಸ್ಥಾನವನ್ನು ನೋಡಿಕೊಳ್ಳುವವರ ಮೇಲ್ವಿಚಾರಕನಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ಮೆರಾರೀ ವಂಶದವರಲ್ಲಿ ಮಹ್ಲೀ ಗೋತ್ರದವರೂ, ಮೂಷೀ ಗೋತ್ರದವರೂ ಇದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ಅವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳ ಗಂಡಸರ ಸಂಖ್ಯೆ 6,200 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ಮೆರಾರೀಯರ ಗೋತ್ರಗಳ ಪ್ರಧಾನಪುರುಷನು ಅಬೀಹೈಲನ ಮಗನಾದ ಚೂರೀಯೇಲ್. ಇವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಉತ್ತರ ದಿಕ್ಕಿನಲ್ಲಿ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ಮೆರಾರೀ ವಂಶದವರು ನೋಡಿಕೊಳ್ಳಬೇಕಾದವುಗಳು ಯಾವುವೆಂದರೆ: ಗುಡಾರದ ಚೌಕಟ್ಟುಗಳು, ಅಗುಳಿಗಳು, ಕಂಬಗಳು, ಗದ್ದಿಗೆಕಲ್ಲುಗಳು, ಇವುಗಳ ಉಪಕರಣಗಳು, ");
INSERT INTO kanirv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ಅಂಗಳದ ಸುತ್ತಲಿರುವ ಕಂಬಗಳು, ಇವುಗಳ ಗದ್ದಿಗೆಕಲ್ಲುಗಳು, ಗೂಟಗಳು, ಹಗ್ಗಗಳು ಇವುಗಳೇ. ಇವುಗಳ ಸಕಲ ವಿಧವಾದ ಸೇವಕಾರ್ಯವನ್ನು ಇವರೇ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ದೇವದರ್ಶನದ ಗುಡಾರದ ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿ ಅಂದರೆ ಸೂರ್ಯೋದಯವಾಗುವ ದಿಕ್ಕಿನಲ್ಲಿ ಮೋಶೆ, ಆರೋನನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಅವರು ಇಸ್ರಾಯೇಲರಿಗೋಸ್ಕರವಾಗಿ ದೇವಸ್ಥಾನವನ್ನು ನೋಡಿಕೊಳ್ಳಬೇಕು. ಇತರರು ಆ ಕೆಲಸಕ್ಕೆ ಕೈಹಾಕಿದರೆ ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಗೋತ್ರಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಿದ ಲೇವಿಯರ ಅಂದರೆ ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳ ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ 22,000 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ಇದಲ್ಲದೆ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳ ಚೊಚ್ಚಲು ಗಂಡಸರನ್ನು ಹೆಸರು ಹಿಡಿದು ಎಣಿಕೆಮಾಡು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ಇಸ್ರಾಯೇಲರಲ್ಲಿರುವ ಚೊಚ್ಚಲಾದವರಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರನ್ನೂ ಇಸ್ರಾಯೇಲರ ಚೊಚ್ಚಲು ಪಶುಗಳಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರ ಪಶುಗಳನ್ನೂ ನನಗೋಸ್ಕರ ತೆಗೆದುಕೋ, ನಾನೇ ಯೆಹೋವನು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆಯು, ಇಸ್ರಾಯೇಲರಲ್ಲಿದ್ದ ಚೊಚ್ಚಲಾದವರನ್ನು ಲೆಕ್ಕಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ಹೆಸರು ಹಿಡಿದು ಎಣಿಕೆ ಮಾಡಲ್ಪಟ್ಟ ಚೊಚ್ಚಲಾದವರು ಅಂದರೆ ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳ ಗಂಡಸರ ಸಂಖ್ಯೆ 22,273 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ಪುನಃ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ನೀನು ಇಸ್ರಾಯೇಲರ ಚೊಚ್ಚಲಾದವರಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರನ್ನು, ಅವರ ಚೊಚ್ಚಲಾದ ಪಶುಗಳಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರ ಪಶುಗಳನ್ನು ತೆಗೆದುಕೋ. ಲೇವಿಯರೇ ನನ್ನ ಸೊತ್ತಾಗಿರುವರು; ನಾನೇ ಯೆಹೋವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","“ಲೇವಿಯರ ಸಂಖ್ಯೆಗಿಂತ ಹೆಚ್ಚಾಗಿ 273 ಮಂದಿ ಚೊಚ್ಚಲರು ಹೆಚ್ಚಾಗಿ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಇರುವುದರಿಂದ ಅವರನ್ನು ಬಿಡಿಸುವುದಕ್ಕಾಗಿ ಒಬ್ಬೊಬ್ಬರಿಗೆ ಐದೈದು ಶೆಕೆಲ್ ಮೇರೆಗೆ ಈಡು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ದೇವಸ್ಥಾನದ ಸೇವೆಗೆ ನೇಮಕವಾದ ಶೆಕೆಲ್ ಗಳ ಮೇರೆಯ ಪ್ರಕಾರ ಒಬ್ಬೊಬ್ಬನಿಗೆ ಐದು ಬೆಳ್ಳಿಯ ನಾಣ್ಯಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ಅವರೊಳಗೆ ಹೆಚ್ಚಾಗಿರುವವರ ಬಿಡುಗಡೆಗೋಸ್ಕರ ಅವರು ಕೊಡುವ ಹಣವನ್ನು ನೀನು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳಿಗೂ ಕೊಡಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ಅದಕ್ಕೆ ಅನುಸಾರವಾಗಿ ಮೋಶೆ ಲೇವಿಯರಿಗಿಂತ ಹೆಚ್ಚಾದ ಚೊಚ್ಚಲರನ್ನು ಬಿಡಿಸುವುದಕ್ಕಾಗಿ ಹಣವನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಚೊಚ್ಚಲಾದವರಿಂದ ದೇವಸ್ಥಾನದ ಸೇವೆಗೆ ನೇಮಕವಾದ ರೂಪಾಯಿಯಲ್ಲಿ 1,365 ಶೆಕೆಲ್ ಗಳನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ಯೆಹೋವನ ಆಜ್ಞೆಯಂತೆ ಮೋಶೆ ಆ ಬಿಡುಗಡೆಯ ಹಣವನ್ನು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳಿಗೂ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ನೀನು ಲೇವಿಯರೊಳಗೆ ಕೆಹಾತ್ಯರನ್ನು ಅವರ ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದವರೆಗೂ ವಯಸ್ಸುಳ್ಳವರನ್ನು ಎಣಿಕೆಮಾಡು, ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ದೇವದರ್ಶನ ಗುಡಾರದ ವಿಷಯದಲ್ಲಿ ಕೆಹಾತ್ಯರು ಮಾಡಬೇಕಾದ ಕೆಲಸ ಯಾವುದೆಂದರೆ; ಅವರು ಮಹಾಪರಿಶುದ್ಧ ವಸ್ತುಗಳನ್ನು ನೋಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ದಂಡು ಹೊರಡುವಾಗ, ಆರೋನನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ಒಳಗೆ ಬಂದು ಮಹಾಪವಿತ್ರಸ್ಥಾನವನ್ನು ಮರೆಮಾಡುವ ತೆರೆಯನ್ನು ಇಳಿಸಿ ಅದರಿಂದ ಮಂಜೂಷದ ಆಜ್ಞಾಶಾಸನವನ್ನು ಮುಚ್ಚಿಬಿಟ್ಟು, ");
INSERT INTO kanirv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ಅದರ ಮೇಲೆ ಹಸನಾದ ತೊಗಲನ್ನೂ ಮತ್ತು ನೀಲಿ ಬಟ್ಟೆಯನ್ನೂ ಹೊದಿಸಿ, ಮಂಜೂಷದ ಬಳೆಗಳಲ್ಲಿ ಹೊರುವ ಕೋಲುಗಳನ್ನು ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ಬಳಿಕ ಅವರು ಯೆಹೋವನ ಸಮ್ಮುಖದಲ್ಲಿರುವ ಮೇಜಿನ ಮೇಲೆ ನೀಲಿ ಬಟ್ಟೆಯನ್ನು ಹಾಸಿ ಅದರ ಮೇಲೆ ಮೇಜಿಗೆ ಸೇರಿದ ಪಾತ್ರೆಗಳನ್ನೂ, ಧೂಪಾರತಿಗಳನ್ನೂ, ಹೂಜಿಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಯ ಬಟ್ಟಲುಗಳನ್ನೂ ಇಡಬೇಕು. ಯಾವಾಗಲೂ ಇರಬೇಕಾದ ರೊಟ್ಟಿಗಳು ಅದರ ಮೇಲೆ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ಇವೆಲ್ಲವುಗಳ ಮೇಲೆ ಅವರು ಕಡುಗೆಂಪಾದ ಬಟ್ಟೆಯನ್ನು ಹಾಸಿ, ಹಸನಾದ ತೊಗಲನ್ನು ಹೊದಿಸಿ ಹೊರುವ ಕೋಲುಗಳನ್ನು ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ಆ ಮೇಲೆ ಅವರು ದೀಪಸ್ತಂಭವನ್ನೂ ಅದಕ್ಕೆ ಸಂಬಂಧಪಟ್ಟ ಹಣತೆಗಳನ್ನೂ, ಎಣ್ಣೆಯ ಪಾತ್ರೆಗಳನ್ನೂ ");
INSERT INTO kanirv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ನೀಲಿಬಟ್ಟೆಯಿಂದ ಮುಚ್ಚಿಬಿಟ್ಟು ಅದಕ್ಕೂ ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳಿಗೂ ಹಸನಾದ ತೊಗಲನ್ನು ಹೊದಿಸಿ ಅವುಗಳನ್ನು ಅಡ್ಡದಂಡಕ್ಕೆ ಕಟ್ಟಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ತರುವಾಯ ಅವರು ಬಂಗಾರದ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ನೀಲಿಬಟ್ಟೆಯನ್ನು ಹಾಸಿ, ಹಸನಾದ ತೊಗಲನ್ನು ಹೊದಿಸಿ ಹೊರುವ ಕೋಲುಗಳನ್ನು ಅಡ್ಡ ದಂಡಕ್ಕೆ ಕಟ್ಟಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ದೇವಸ್ಥಾನದ ಸರ್ವ ಉಪಕರಣಗಳನ್ನೆಲ್ಲಾ ನೀಲಿಬಟ್ಟೆಯಲ್ಲಿ ಇಟ್ಟು, ಹಸನಾದ ತೊಗಲನ್ನು ಹೊದಿಸಿ ಅಡ್ಡ ದಂಡಕ್ಕೆ ಕಟ್ಟಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ಅವರು ಯಜ್ಞವೇದಿಯ ಬೂದಿಯನ್ನು ತೆಗೆದುಬಿಟ್ಟು ಆ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ನೇರಳೆ ವರ್ಣದ ಬಟ್ಟೆಯನ್ನು ಹಾಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ಅದಕ್ಕೆ ಸಂಬಂಧಪಟ್ಟ ಅಗ್ಗಿಷ್ಟಿಕೆಗಳು, ಮುಳ್ಳುಗಳು, ಸಲಿಕೆಗಳು, ಬೋಗುಣಿಗಳು ಮುಂತಾದ ಉಪಕರಣಗಳನ್ನೆಲ್ಲಾ ಮೇಲೆ ಇಟ್ಟು ಹಸನಾದ ತೊಗಲನ್ನು ಹೊದಿಸಿ ಹೊರುವ ಕೋಲುಗಳನ್ನು ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","ದಂಡು ಹೊರಡುವಾಗ ಆರೋನನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ದೇವಸ್ಥಾನದ ಎಲ್ಲಾ ಸಾಮಾನುಗಳನ್ನು ಮುಚ್ಚಿ ಸಿದ್ಧಮಾಡಿದ ನಂತರ ಕೆಹಾತ್ಯರು ಅವುಗಳನ್ನು ಹೊರುವುದಕ್ಕೆ ಬರಬೇಕು. ಇವರು ದೇವಸ್ಥಾನದ ಸಾಮಾನುಗಳನ್ನು ಮುಟ್ಟಬಾರದು, ಮುಟ್ಟಿದರೆ ಸತ್ತು ಹೋಗುವರು. ದೇವದರ್ಶನದ ಗುಡಾರದ ಸಾಮಾನುಗಳಲ್ಲಿ ಕೆಹಾತ್ಯರು ಹೊರಬೇಕಾದವುಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","ಮಹಾಯಾಜಕ ಆರೋನನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನು ದೀಪದ ಎಣ್ಣೆಯನ್ನೂ, ಪರಿಮಳಧೂಪವನ್ನೂ, ನಿತ್ಯವಾಗಿ ನೈವೇದ್ಯಮಾಡುವ ಧಾನ್ಯದ್ರವ್ಯವನ್ನೂ, ಅಭಿಷೇಕತೈಲವನ್ನೂ ತನ್ನ ವಶದಲ್ಲಿ ಇಟ್ಟುಕೊಳ್ಳಬೇಕು. ಅದಲ್ಲದೆ ದೇವದರ್ಶನದ ಗುಡಾರದ ಎಲ್ಲಾ ಭಾಗಗಳೂ ಅದರಲ್ಲಿಯೂ ಅದರ ಪಾತ್ರೆಗಳಲ್ಲಿಯೂ ಇರುವ ಸಮಸ್ತ ವಸ್ತುಗಳೂ ಅವನ ಮೇಲ್ವಿಚಾರಣೆಯಲ್ಲಿರಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನನ ಸಂಗಡ ಮಾತನಾಡಿ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ಕೆಹಾತ್ಯರ ಗೋತ್ರಕುಟುಂಬಗಳವರು ಲೇವಿಯರೊಡನೆ ಉಳಿಯದೆ ನಾಶವಾಗುವುದಕ್ಕೆ ಆಸ್ಪದಕೊಡಬೇಡಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ಅವರು ಮಹಾಪರಿಶುದ್ಧ ವಸ್ತುಗಳ ಹತ್ತಿರಕ್ಕೆ ಬಂದು ಸಾಯದಂತೆ ನೀವು ಅವರ ವಿಷಯದಲ್ಲಿ ಎಚ್ಚರಿಕೆ ವಹಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ಕೆಹಾತ್ಯರು ಒಳಗೆ ಬಂದು, ಒಂದು ಕ್ಷಣವು ಆ ಪರಿಶುದ್ಧ ವಸ್ತುಗಳನ್ನು ನೋಡಬಾರದು; ನೋಡಿದರೆ ಸತ್ತೇ ಹೋಗುವರು. ಆರೋನನೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳೂ ಒಳಗೆ ಪ್ರವೇಶಿಸಿ ಅವರ ಕೆಲಸಗಳನ್ನು ಅವರವರ ಹೊರೆಗಳನ್ನೂ ಅವರಿಗೆ ನೇಮಿಸಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“ನೀನು ಗೇರ್ಷೋನ್ಯರ ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಎಣಿಕೆಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದವರೆಗೂ ವಯಸ್ಸುಳ್ಳವರಾಗಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆಗೆ ಯೋಗ್ಯರಾದವರನ್ನು ಎಣಿಕೆಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","ಸೇವಾಕಾರ್ಯ ಮಾಡುವುದರಲ್ಲಿಯೂ, ಹೊರೆಗಳನ್ನು ಹೊರುವುದರಲ್ಲಿಯೂ ಗೇರ್ಷೋನ್ಯರ ಗೋತ್ರಕುಟುಂಬದವರು ಮಾಡಬೇಕಾದ ಸೇವೆ ಯಾವುದೆಂದರೆ; ");
INSERT INTO kanirv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಟ್ಟೆಗಳನ್ನು ಹೊರಬೇಕು ಅಂದರೆ ಗುಡಾರ, ಅದರ ಹೊದಿಕೆ, ಅದರ ಮೇಲಣ ಹಸನಾದ ಪ್ರಾಣಿಯ ತೊಗಲಿನ ಹೊದಿಕೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಪರದೆ, ಗುಡಾರದ ಮತ್ತು ಯಜ್ಞವೇದಿಯ ಸುತ್ತಣ ಅಂಗಳದ ತೆರೆಗಳು, ಅದರ ಬಾಗಿಲಿನ ಪರದೆಗಳು, ಹಗ್ಗಗಳು, ಎಲ್ಲಾ ಉಪಕರಣಗಳು ಇವುಗಳನ್ನು ಹೊರಬೇಕು ಮತ್ತು ಇವುಗಳಿಗೆ ಸಂಬಂಧಪಟ್ಟ ಎಲ್ಲಾ ಕೆಲಸವನ್ನು ಅವರು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ಗೇರ್ಷೋನ್ಯರು ಹೊರೆ ಹೊರುವುದರಲ್ಲಿಯೂ ಬೇರೆ ಸೇವಾಕಾರ್ಯ ಮಾಡುವುದರಲ್ಲಿಯೂ ಆರೋನನ ಮತ್ತು ಅವನ ಮಕ್ಕಳ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರವೇ ನಡೆಯಬೇಕು. ನೀವೇ ಹೊರೆಗಳನ್ನು ಗೊತ್ತುಮಾಡಿ ಅವರವರ ವಶಕ್ಕೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ದೇವದರ್ಶನದ ಗುಡಾರದ ವಿಷಯದಲ್ಲಿ ಗೇರ್ಷೋನ್ಯರ ಗೋತ್ರಕುಟುಂಬದವರು ಮಾಡಬೇಕಾದ ಕೆಲಸ ಇದೇ. ಮಹಾಯಾಜಕನಾದ ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನು ಅವರ ಮೇಲ್ವಿಚಾರಣೆ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“ನೀನು ಮೆರಾರೀಯರನ್ನು ಅವರ ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದವರೆಗೂ ವಯಸ್ಸುಳ್ಳ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆ ಮಾಡಲು ಅರ್ಹರಾದವರನ್ನು ಲೆಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ದೇವದರ್ಶನದ ಗುಡಾರದ ವಿಷಯದಲ್ಲಿ ಅವರು ಮಾಡಬೇಕಾದ ಕೆಲಸ ಯಾವುದೆಂದರೆ: ಅವರು ಗುಡಾರದ ಚೌಕಟ್ಟುಗಳನ್ನು, ಅಗುಳಿಗಳನ್ನು, ಕಂಬಗಳನ್ನು, ಅವುಗಳ ಗದ್ದಿಗೆಕಲ್ಲುಗಳನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ಅಂಗಳದ ಕಂಬಗಳನ್ನು, ಇವುಗಳ ಗದ್ದಿಗೆಕಲ್ಲುಗಳನ್ನೂ, ಗೂಟಗಳನ್ನೂ, ಹಗ್ಗಗಳನ್ನೂ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನೂ ಹೊರಬೇಕು; ಇವುಗಳಿಗೆ ಸಂಬಂಧಪಟ್ಟ ಎಲ್ಲಾ ಕೆಲಸವನ್ನು ಅವರು ಮಾಡಬೇಕು. ಅವರವರ ಜವಾಬ್ದಾರಿಗಳನ್ನೆಲ್ಲಾ ನೀವು ಹೆಸರು ಹೇಳಿ ಗೊತ್ತುಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ದೇವದರ್ಶನದ ಗುಡಾರದ ವಿಷಯದಲ್ಲಿ ಮೆರಾರೀಯರ ಗೋತ್ರಕುಟುಂಬದವರು ಮಾಡಬೇಕಾದ ಕೆಲಸ ಇದೇ. ಅವರು ಮಹಾಯಾಜಕ ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನ ಅಧೀನದಲ್ಲಿದ್ದು ಕಾರ್ಯಗಳನ್ನು ಮಾಡಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ಮೋಶೆ ಮತ್ತು ಆರೋನರೂ, ಸಮೂಹದ ಪ್ರಧಾನರೂ ಕೆಹಾತ್ಯರನ್ನು ಅವರ ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಎಣಿಕೆ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ಅವರು ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದವರೆಗೂ ವಯಸ್ಸುಳ್ಳ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆ ಮಾಡಲು ಯೋಗ್ಯರಾದವರನ್ನು ಎಣಿಕೆಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ಅವರಲ್ಲಿ ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಎಣಿಕೆಯಾದವರು 2,750 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ಯೆಹೋವನು ಮೋಶೆಗೆ ಕೊಟ್ಟ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆ ಆರೋನರು ಕೆಹಾತ್ಯರ ಗೋತ್ರಕುಟುಂಬವನ್ನು ಲೆಕ್ಕಿಸಲಾಗಿ ಅವರಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಕೆಲಸವನ್ನು ಮಾಡತಕ್ಕವರು ಇಷ್ಟೇ ಜನರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ಗೇರ್ಷೋನ್ಯರನ್ನು ಅವರ ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದವರೆಗೂ ವಯಸ್ಸುಳ್ಳವರಾಗಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆ ಮಾಡಲು ಅರ್ಹರದವರನ್ನು ಎಣಿಕೆಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ಗುಡಾರದ ಕೆಲಸಕ್ಕೆ ಸೇರತಕ್ಕವರೆಂದು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರು 2,630 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಗೇರ್ಷೋನ್ಯರ ಗೋತ್ರಕುಟುಂಬದವರನು ಎಣಿಕೆಮಾಡಿದಾಗ ಅವರಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಕೆಲಸವನ್ನು ಮಾಡತಕ್ಕವರು ಇಷ್ಟೇ ಜನರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ಮೆರಾರೀಯರಲ್ಲಿ ಅವರ ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಎಣಿಕೆ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದವರೆಗೂ ವಯಸ್ಸುಳ್ಳವರಾಗಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆ ಮಾಡಲು ಅರ್ಹರಾದವರನ್ನು ಎಣಿಕೆ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ಗುಡಾರದ ಕೆಲಸಕ್ಕೆ ಸೇರಿದವರೆಂದು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರು 3,200 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಮೆರಾರೀಯರ ಗೋತ್ರಕುಟುಂಬವನ್ನು ಎಣಿಕೆ ಮಾಡಿದಾಗ ಅವರ ಸಂಖ್ಯೆ ಇಷ್ಟೇ ಎಂದು ಗೊತ್ತಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ಮೋಶೆ ಮತ್ತು ಆರೋನರೂ ಇಸ್ರಾಯೇಲರ ಪ್ರಧಾನರೂ ಲೇವಿಯರಲ್ಲಿ ಅವರ ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದವರೆಗೂ ವಯಸ್ಸುಳ್ಳವರಾಗಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆ ಮಾಡಲು ಅರ್ಹರಾದವರನ್ನು ಎಣಿಕೆ ಮಾಡಿದರು. ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವಕಾರ್ಯವನ್ನು ಮಾಡಲೂ, ಅದರ ಜವಾಬ್ದಾರಿಗಳನ್ನು ನಿರ್ವಹಿಸುವವರನ್ನು ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ಗೋತ್ರಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 8,580. ");
INSERT INTO kanirv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮೇರೆಗೆ ಅವನಿಂದ ಪ್ರತಿಯೊಬ್ಬನಿಗೆ ಅವನವನ ಕೆಲಸವೂ, ಜವಾಬ್ದಾರಿಯೂ ನಿಗದಿಪಡಿಸಲಾಯಿತು. ಹೀಗೆ ಯೆಹೋವನ ಆಜ್ಞೆಯ ಮೇರೆಗೆ ಲೆಕ್ಕವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ಕುಷ್ಠರೋಗಿಗಳನ್ನು, ಸಾಂಕ್ರಾಮಿಕವಾದ ಚರ್ಮರೋಗ ಇರುವವರನ್ನು, ಮೇಹಸ್ರಾವವುಳ್ಳವರನ್ನು ಹಾಗು ಹೆಣದ ಸೋಂಕಿನಿಂದ ಅಶುದ್ಧರಾದವರನ್ನು ಪಾಳೆಯದಿಂದ ಹೊರಡಿಸಬೇಕೆಂದು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ಅಂಥವರು ಗಂಡಸರೇ ಆಗಲಿ ಅಥವಾ ಹೆಂಗಸರೇ ಆಗಲಿ, ಅವರೆಲ್ಲರನ್ನೂ ಪಾಳೆಯದಿಂದ ಹೊರಗೆಹಾಕಬೇಕು. ನಾನೇ ಅವರ ಪಾಳೆಯದಲ್ಲಿ ವಾಸವಾಗಿರುವುದರಿಂದ ಅವರು ಅದನ್ನು ಅಪವಿತ್ರ ಮಾಡಬಾರದು.” ");
INSERT INTO kanirv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರಾಯೇಲರು ಹಾಗೆಯೇ ಮಾಡಿದರು. ಇಸ್ರಾಯೇಲರು ಯೆಹೋವನಿಗೆ ವಿಧೇಯರಾಗಿ ಅಶುದ್ಧರಾದವರನ್ನೆಲ್ಲಾ ಪಾಳೆಯದಿಂದ ಹೊರಗೆ ಕಳುಹಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು: ಯಾವ ಪುರುಷನಾಗಲಿ, ಸ್ತ್ರೀಯಾಗಲಿ ಮತ್ತೊಬ್ಬನನ್ನು ಮೋಸಗೊಳಿಸುವುದರಿಂದ ಯೆಹೋವನಿಗೆ ದ್ರೋಹಮಾಡಿ ಅಪರಾಧಿಗಳಾದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ಅಂಥವರು ತಮ್ಮ ಅಪರಾಧವನ್ನು ಅರಿಕೆಮಾಡಬೇಕು. ಅದಲ್ಲದೆ ಅಪರಾಧ ಮಾಡಿದವನು ನಷ್ಟಪಟ್ಟವನಿಗೆ ಮೂಲದ್ರವ್ಯದ ಬೆಲೆಗೆ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಸೇರಿಸಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","“ಆದರೆ ದಂಡವನ್ನು ತೆಗೆದುಕೊಳ್ಳುವವನು ಮೃತನಾಗಿ ಅವನ ಸಂಬಂಧಿಕರು ಯಾರೂ ಇಲ್ಲದಿದ್ದರೆ, ಆ ದ್ರವ್ಯವು ಯೆಹೋವನಿಗೆ ಸೇರಬೇಕು. ಆ ದ್ರವ್ಯ ಮತ್ತು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಸಮರ್ಪಿಸಲ್ಪಡುವ ಪ್ರಾಯಶ್ಚಿತ್ತದ ಟಗರು ಈ ಎರಡೂ ಯಾಜಕನಿಗೆ ಸೇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ಇಸ್ರಾಯೇಲರು ಪರಿಶುದ್ಧವಾದ ವಸ್ತುಗಳಿಂದ ಪ್ರತ್ಯೇಕಿಸಿ ತರುವ ಕಾಣಿಕೆಗಳೆಲ್ಲಾ ಯಾಜಕನಿಗೇ ಸಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ಪ್ರತಿ ಮನುಷ್ಯನು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾಗಿಟ್ಟದ್ದನ್ನು ಯಾವ ಯಾಜಕನಿಗೆ ತಂದು ಒಪ್ಪಿಸುತ್ತಾನೋ ಅದು ಆ ಯಾಜಕನದ್ದಾಗಿರುತ್ತದೆ.” ");
INSERT INTO kanirv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು: ‘ಯಾರ ಹೆಂಡತಿ ತಪ್ಪು ದಾರಿ ಹಿಡಿದು ಗಂಡನಿಗೆ ಅಪನಂಬಿಗಸ್ತಳಾಗಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ಯಾರ ಕೈಗೆ ಸಿಕ್ಕದೆಯೂ ಸಾಕ್ಷಿ ಇಲ್ಲದೆಯೂ ರಹಸ್ಯವಾಗಿಯೇ ಪರಪುರುಷನೊಡನೆ ಸಂಗಮಿಸಿ ಗಂಡನಿಗೆ ದ್ರೋಹಿಯಾಗಿ ಅಶುದ್ಧಳಾದ ಸಂದರ್ಭದಲ್ಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ಅಥವಾ ಅವಳು ಹಾಗೆ ಮಾಡದೆ ಅಶುದ್ಧಳಾಗದ ಸಂದರ್ಭದಲ್ಲಿಯೂ, ಆಕೆಯು ಕೆಟ್ಟುಹೋದಳೆಂಬ ಸಂಶಯ ಗಂಡನಿಗೆ ಬಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ಆಗ ಅವನು ಮಾಡಬೇಕಾದದ್ದೇನೆಂದರೆ, ಆ ಪುರುಷನು ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು ಮತ್ತು ಅವಳ ಸಂಗತಿಯನ್ನು ವಿಚಾರಿಸುವುದಕ್ಕಾಗಿ ಅವನು ಯಾಜಕನಿಗೆ ಮೂರು ಸೇರು ಜವೆಗೋದಿಯ ಹಿಟ್ಟನ್ನು ಕಾಣಿಕೆಯಾಗಿ ತಂದುಕೊಡಬೇಕು. ಅದು ವ್ಯಭಿಚಾರ ಸಂಶಯವನ್ನು ಸೂಚಿಸುವುದಕ್ಕೂ ಮತ್ತು ಪಾಪವನ್ನು ಹೊರಪಡಿಸುವುದಕ್ಕೂ ಯೆಹೋವನಿಗೆ ನೈವೇದ್ಯವಾದ ಕಾಣಿಕೆಯಾದುದರಿಂದ ಆ ಹಿಟ್ಟಿನ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಹೊಯ್ಯಲೂಬಾರದು, ಧೂಪವನ್ನು ಇಡಲೂಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“‘ಯಾಜಕನು ಅವಳನ್ನು ಕರೆದು ಯೆಹೋವನ ಸಮ್ಮುಖದಲ್ಲಿ ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ಯಾಜಕನು ಮಣ್ಣಿನ ಪಾತ್ರೆಯಲ್ಲಿ ಪರಿಶುದ್ಧ ಜಲವನ್ನು ತೆಗೆದುಕೊಂಡು, ದೇವದರ್ಶನದ ಗುಡಾರದ ನೆಲದಿಂದ ಸ್ವಲ್ಪ ಧೂಳನ್ನು ಆ ನೀರಿನಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ಯಾಜಕನು ಆ ಸ್ತ್ರೀಯನ್ನು ಯೆಹೋವನ ಸಮ್ಮುಖದಲ್ಲಿ ನಿಲ್ಲಿಸಿ, ಅವಳ ತಲೆಯ ಮೇಲಿರುವ ಮುಸುಕನ್ನು ತೆಗೆದು, ಕೂದಲನ್ನು ಕೆದರಿಸಿ ವ್ಯಭಿಚಾರದ ಸಂಶಯವನ್ನು ಸೂಚಿಸುವ ಆ ನೈವೇದ್ಯದ ಹಿಟ್ಟನ್ನು ಅವಳ ಕೈಯಲ್ಲಿ ಇಟ್ಟು, ಶಾಪವನ್ನುಂಟುಮಾಡುವ ವಿಷಕರವಾದ ಆ ನೀರನ್ನು ಯಾಜಕನು ತನ್ನ ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ಯಾಜಕನೂ ಅವಳಿಂದ ಪ್ರಮಾಣಮಾಡಿಸಿ ಹೀಗೆ ಹೇಳಬೇಕು, “ಒಬ್ಬ ಪರಪುರುಷನ ಸಂಗಮಮಾಡದಿದ್ದರೆ, ನಿನ್ನ ಗಂಡನನ್ನು ಬಿಟ್ಟು ನೀನು ಜಾರತ್ವ ಮಾಡದೇ ನಿರಪರಾಧಿಯಾಗಿದ್ದರೆ ಶಪಿಸಲ್ಪಟ್ಟ ವಿಷಕರವಾದ ಈ ನೀರು ನಿನಗೆ ಯಾವ ಹಾನಿಯನ್ನು ಮಾಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ಆದರೆ ನೀನು ನಿನ್ನ ಗಂಡನನ್ನು ಬಿಟ್ಟು ಪರಪುರುಷನೊಡನೆ ಜಾರತ್ವಮಾಡಿ ಅಶುದ್ಧಳಾಗಿದ್ದರೆ ನಿನ್ನ ಗಂಡನನ್ನು ಬಿಟ್ಟು ಮತ್ತೊಬ್ಬನೊಡನೆ ನೀನು ಸಂಗಮಿಸಿದ್ದರೆ,” ");
INSERT INTO kanirv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","“ಯೆಹೋವನು ನಿನ್ನ ತೊಡೆಗಳು ಕ್ಷೀಣವಾಗಿ ಹೋಗುವಂತೆ, ನಿನ್ನ ಹೊಟ್ಟೆಯು ಉಬ್ಬುವಂತೆ ಮಾಡಿ ನಿನ್ನನ್ನು ನಿನ್ನ ಜನರ ಮಧ್ಯದಲ್ಲಿ ಶಾಪಗ್ರಸ್ತಳನ್ನಾಗಿ ನೇಮಿಸಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ಶಾಪವನ್ನುಂಟುಮಾಡುವ ಈ ನೀರು ನಿನ್ನೊಳಗೆ ಸೇರಿ ನಿನ್ನ ಹೊಟ್ಟೆಯು ಉಬ್ಬುವಂತೆ ನಿನ್ನ ತೊಡೆಗಳು ಕ್ಷೀಣವಾಗಿ ಹೋಗುವಂತೆ ನಿನ್ನ ಜನನೇಂದ್ರಿಯಗಳು ಬತ್ತಿ ಹೋಗುವಂತೆ ಮಾಡುವುದು.” ಅದಕ್ಕೆ ಆ ಸ್ತ್ರೀಯು, “ನಾನು ಅಪರಾಧಿಯಾಗಿದ್ದರೆ ಹಾಗೆಯೇ ಆಗಲಿ” ಎಂದು ಹೇಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“‘ಇದಲ್ಲದೆ ಯಾಜಕನು ಈ ಶಾಪವಚನಗಳನ್ನು ಸುರುಳಿಯಲ್ಲಿ ಬರೆದು, ವಿಷಕರ ಜಲದಲ್ಲಿ ಆ ಶಾಪವಚನವನ್ನು ತೊಳೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ಶಾಪವನ್ನುಂಟುಮಾಡುವ ವಿಷಕರವಾದ ನೀರನ್ನು ಆ ಸ್ತ್ರೀಗೆ ಕುಡಿಸಬೇಕು. ಆಗ ಶಪಿಸುವ ನೀರು ಅವಳಲ್ಲಿ ಸೇರಿ ವಿಷಕರವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ಬಳಿಕ ಯಾಜಕನು ಆ ಸ್ತ್ರೀಯ ಕೈಯಿಂದ ವ್ಯಭಿಚಾರದ ಸಂಶಯ ಸೂಚಕವಾದ ಕಾಣಿಕೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಆ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವನ ಸಮ್ಮುಖದಲ್ಲಿ ನೈವೇದ್ಯಮಾಡಿ ಯಜ್ಞವೇದಿಯ ಹತ್ತಿರ ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ಆಗ ಯಾಜಕನು ನೈವೇದ್ಯವಾದದ್ದನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಕಾಣಿಕೆಯಿಂದ ಒಂದು ಹಿಡಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಸುಟ್ಟು ಆ ನೀರನ್ನು ಸ್ತ್ರೀಗೆ ಕುಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ಅವಳು ಅಶುದ್ಧಳಾಗಿ ಗಂಡನಿಗೆ ದ್ರೋಹಮಾಡಿದವಳಾಗಿದ್ದರೆ ಆ ನೀರನ್ನು ಕುಡಿದ ನಂತರ ಆ ನೀರು ಅವಳೊಳಗೆ ಸೇರಿ ವಿಷವಾಗುವುದರಿಂದ ಅವಳ ಹೊಟ್ಟೆ ಉಬ್ಬುವುದು, ಅವಳ ತೊಡೆಗಳು ಕ್ಷೀಣವಾಗಿ ಹೋಗುವವು. ಆಗ ಆ ಸ್ತ್ರೀಯು ತನ್ನ ಜನರ ಮಧ್ಯದಲ್ಲಿ ಶಾಪಗ್ರಸ್ತಳಾಗುವಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ಆದರೆ ಆ ಸ್ತ್ರೀಯು ಪರಿಶುದ್ಧಳಾಗಿ ನಿರಪರಾಧಿಯಾದ ಪಕ್ಷಕ್ಕೆ ಯಾವ ಹಾನಿಯನ್ನು ಅನುಭವಿಸದೆ ಸಂತಾನವನ್ನು ಪಡೆಯುವಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","ಒಬ್ಬ ಹೆಂಡತಿ ತನ್ನ ಗಂಡನನ್ನು ಬಿಟ್ಟು ಜಾರತ್ವಮಾಡಿ ಅಶುದ್ಧಳಾದರೆ ಇಂತಹ ವ್ಯಭಿಚಾರದ ಸಂಶಯವನ್ನು ಪರಿಹರಿಸುವ ನಿಯಮ ಇದೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ಗಂಡನು ಹೆಂಡತಿಯ ವಿಷಯದಲ್ಲಿ ಸಂಶಯ ಪಟ್ಟರೆ ಅವನು ಅವಳನ್ನು ಯೆಹೋವನ ಸಮ್ಮುಖದಲ್ಲಿ ತಂದು ನಿಲ್ಲಿಸಬೇಕು. ಯಾಜಕನು ಅವಳ ವಿಷಯದಲ್ಲಿ ಈ ವಿಧಿನಿಯಮವನ್ನು ನೆರವೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ಆಗ ಗಂಡನು ನಿರಪರಾಧಿಯಾಗುವನು. ಆ ಹೆಂಡತಿಯು ತನ್ನ ಅಕ್ರಮವನ್ನು ಹೊತ್ತುಕೊಳ್ಳುವಳು.’” ");
INSERT INTO kanirv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು: ಯಾವ ಪುರುಷನಾಗಲಿ ಸ್ತ್ರೀಯಾಗಲಿ ನಾಜೀರರ ಹರಕೆಯನ್ನು ಅಂದರೆ ಯೆಹೋವನಿಗೆ ತನ್ನನ್ನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಳ್ಳುವ, ");
INSERT INTO kanirv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ವಿಶೇಷವಾದ ಹರಕೆಯನ್ನು ಮಾಡಿದಾಗ ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಮತ್ತು ಮದ್ಯಪಾನವನ್ನೂ ಮುಟ್ಟಬಾರದು. ದ್ರಾಕ್ಷಾರಸದ ಹುಳಿಯನ್ನಾಗಲಿ ಬೇರೆ ಮದ್ಯಪಾನದ ಹುಳಿಯನ್ನಾಗಲಿ ಕುಡಿಯಬಾರದು. ದ್ರಾಕ್ಷಿ ಹಣ್ಣಿನಿಂದ ಮಾಡಿದ ಯಾವ ಪಾನವನ್ನೂ ಕುಡಿಯಬಾರದು. ಹಸಿ ಅಥವಾ ಒಣಗಿದ ದ್ರಾಕ್ಷಿ ಹಣ್ಣನ್ನೂ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ಅವನು ಹರಕೆಮಾಡಿ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ದಿನಗಳಲ್ಲೆಲ್ಲಾ ದ್ರಾಕ್ಷಾಲತೆಯಿಂದ ಬೆಳೆದ ಬೀಜವನ್ನಾಗಲಿ, ಸಿಪ್ಪೆಯನ್ನಾಗಲಿ ತಿನ್ನಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ಅವನು ತನ್ನ ಹರಕೆಯ ದಿನಗಳಲ್ಲಿ ಕ್ಷೌರಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು. ಅವನು ತನ್ನನ್ನು ಯೆಹೋವನಿಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ದಿನಗಳು ಮುಗಿಯುವ ತನಕ ತಾನು ದೇವರಿಗೆ ಮೀಸಲಾಗಿದ್ದು ತನ್ನ ತಲೆಯ ಕೂದಲನ್ನು ಕತ್ತರಿಸದೆ ಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ತನ್ನನ್ನು ಯೆಹೋವನಿಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ದಿನಗಳಲ್ಲಿ ಯಾವ ಶವವನ್ನೂ ಮುಟ್ಟಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ತಾಯಿ, ತಂದೆ, ಅಣ್ಣ, ತಮ್ಮ, ಅಕ್ಕ, ತಂಗಿ ಇವರಲ್ಲಿ ಯಾರು ಸತ್ತರೂ ಅವರ ನಿಮಿತ್ತ ಅವನು ತನ್ನನ್ನು ದೇವರಿಂದ ಪ್ರತ್ಯೇಕಿಸಿ ಅಪವಿತ್ರಮಾಡಿಕೊಳ್ಳಬಾರದು. ಏಕೆಂದರೆ ತಾನು ದೇವರಿಗೆ ಮೀಸಲಾಗಿ ಬಿಟ್ಟ ಕೂದಲು ತಲೆಯ ಮೇಲೆ ಇದೆಯಲ್ಲಾ. ");
INSERT INTO kanirv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ತಾನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡಿರುವ ದಿನಗಳೆಲ್ಲೆಲ್ಲಾ ಅವನು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾಗಿಯೇ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","ಯಾರಾದರೂ ಆಕಸ್ಮಾತ್ತಾಗಿ ಅವನ ಬಳಿಯಲ್ಲೇ ಸತ್ತರೆ, ತಾನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ತಲೆಯ ಕೂದಲು ಅಪವಿತ್ರವಾದರೆ ಏಳನೆಯ ದಿನದಲ್ಲಿ ಅಂದರೆ ಶುದ್ಧನಾಗುವ ದಿನದಲ್ಲಿ ತಲೆಯನ್ನು ಕ್ಷೌರಮಾಡಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಅವನು ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ಯಾಜಕನು ಒಂದನ್ನು ದೋಷಪರಿಹಾರ ಯಜ್ಞವಾಗಿ, ಇನ್ನೊಂದನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಿ ಶವಸೋಂಕಿದವನಿಗಾಗಿ ದೋಷಪರಿಹಾರ ಮಾಡಿ ಅವನ ತಲೆಯ ಕೂದಲನ್ನು ಆ ದಿನದಿಂದ ಪವಿತ್ರವೆಂದು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ಅವನು ಎಷ್ಟು ದಿನಗಳವರೆಗೆ ತನ್ನನ್ನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡಿದ್ದಾನೋ, ಅಷ್ಟು ದಿನಗಳವರೆಗೆ ಹೊಸದಾಗಿ ತನ್ನನ್ನು ಯೆಹೋವನಿಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಳ್ಳಬೇಕು ಮತ್ತು ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞವಾಗಿ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಮೊದಲು ಮಾಡಿದ್ದ ಹರಕೆಗೆ ವಿಘ್ನಪ್ರಾಪ್ತವಾದುದರಿಂದ ಕಳೆದುಹೋದ ದಿನಗಳು ವ್ಯರ್ಥವಾದುದೆಂದು ಪರಿಗಣಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","ನಾಜೀರನು ತನ್ನ ವ್ರತದಿನಗಳು ಮುಗಿದಾಗ ತನ್ನನ್ನು ಸಮರ್ಪಿಸಬೇಕಾದ ಕ್ರಮವನ್ನು ಅನುಸರಿಸಬೇಕು. ಅವನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಕಾಣಿಕೆಗಳು ಯಾವುವೆಂದರೆ: ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ದೋಷವಿಲ್ಲದ ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಟಗರಿನ ಮರಿಯನ್ನು, ದೋಷಪರಿಹಾರ ಯಜ್ಞಕ್ಕಾಗಿ ದೋಷವಿಲ್ಲದ ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಹೆಣ್ಣು ಕುರಿಮರಿಯನ್ನು, ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ದೋಷವಿಲ್ಲದ ಪೂರ್ಣಾಂಗವಾದ ಟಗರನ್ನು ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ಇದಲ್ಲದೆ ಒಂದು ಪುಟ್ಟಿ ತುಂಬಾ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಹಿಟ್ಟಿನ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳು, ಎಣ್ಣೆ ಹಾಕಿದ ಹುಳಿಯಿಲ್ಲದ ಕಡಬುಗಳನ್ನು ಧಾನ್ಯದ್ರವ್ಯ, ಪಾನದ್ರವ್ಯಗಳೊಡನೆ ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","ಯಾಜಕನು ಇವುಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತಂದು ನಾಜೀರನ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನೂ ಮತ್ತು ಸರ್ವಾಂಗಹೋಮವನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ಆ ಟಗರನ್ನೂ, ಪುಟ್ಟಿ ತುಂಬಾ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನೂ, ಯಾಜಕನು ಯೆಹೋವನಿಗೆ ಸಮಾಧಾನಯಜ್ಞವಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ಅವನು ತಂದ ಧಾನ್ಯದ್ರವ್ಯ ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ನೈವೇದ್ಯಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ಆಗ ನಾಜೀರನು ತನ್ನ ಸಮರ್ಪಣೆಯ ದೀಕ್ಷೆಯನ್ನು ಸೂಚಿಸುವ ತಲೆಯ ಕೂದಲನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿಯಲ್ಲಿ ಕ್ಷೌರಮಾಡಿಸಿಕೊಂಡು, ಆ ಕೂದಲನ್ನು ಸಮಾಧಾನಯಜ್ಞದ್ರವ್ಯಗಳ ಕೆಳಗಿರುವ ಬೆಂಕಿಯಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ತರುವಾಯ ಯಾಜಕನು ಬೇಯಿಸಿದ ಆ ಟಗರಿನ ಮುಂದೊಡೆಯನ್ನೂ, ಪುಟ್ಟಿಯಲ್ಲಿನ ಹುಳಿಯಿಲ್ಲದ ಒಂದು ರೊಟ್ಟಿಯನ್ನು, ಹಾಗೂ ಹುಳಿಯಿಲ್ಲದ ಒಂದು ಕಡುಬನ್ನೂ ತೆಗೆದುಕೊಂಡು ನಾಜೀರನು ಕ್ಷೌರಮಾಡಿಸಿಕೊಂಡ ನಂತರ ಅವನ ಕೈಯಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ಯಾಜಕನು ಅವುಗಳನ್ನು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಬೇಕು. ನೈವೇದ್ಯ ಮಾಡುವ ಎದೆಯ ಭಾಗದಂತೆ ಹಾಗೂ ಯಾಜಕರಿಗಾಗಿ ಪ್ರತ್ಯೇಕಿಸುವ ತೊಡೆಯಂತೆ ಯಾಜಕನಿಗೆ ಸಲ್ಲಿಸಬೇಕು. ಅನಂತರ ಆ ನಾಜೀರನು ದ್ರಾಕ್ಷಾರಸವನ್ನು ಪಾನಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","ಹರಕೆಮಾಡಿಕೊಂಡ ನಾಜೀರರ ವ್ರತ ನಿಯಮವು ಇದೇ. ಅವರು ತಮ್ಮ ವ್ರತಪೂರ್ತಿಗಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಕಾಣಿಕೆ ಇದೇ. ಅವರು ತಮ್ಮ ಶಕ್ತಿಗನುಸಾರ ಹೆಚ್ಚಾಗಿಯೂ ಕೊಡಬಹುದು. ಆದರೆ ತಾವು ಕೊಡುತ್ತೆವೆಂದು ಹರಕೆಮಾಡಿದಷ್ಟು ವ್ರತವಿಧಿಗನುಸಾರವಾಗಿ ಕೊಡಲೇಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“ನೀನು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ಮಕ್ಕಳಿಗೂ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ನೀವು ಇಸ್ರಾಯೇಲರನ್ನು ಹೀಗೆ ಆಶೀರ್ವದಿಸಬೇಕು. ಈ ಪ್ರಕಾರ ಅವರಿಗೆ ಹೇಳಬೇಕು, ");
INSERT INTO kanirv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸಿ ಕಾಪಾಡಲಿ; ");
INSERT INTO kanirv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ಯೆಹೋವನು ಪ್ರಸನ್ನಮುಖದಿಂದ ನಿಮ್ಮನ್ನು ನೋಡಿ ನಿಮ್ಮ ಮೇಲೆ ದಯವಿಡಲಿ; ");
INSERT INTO kanirv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ಯೆಹೋವನು ನಿಮ್ಮ ಮೇಲೆ ಕೃಪಾಕಟಾಕ್ಷವಿಟ್ಟು ಶಾಂತಿಯನ್ನು ಅನುಗ್ರಹಿಸಲಿ’ ಎಂಬುದೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ಹೀಗೆ ಅವರು ಇಸ್ರಾಯೇಲರನ್ನು ಕುರಿತು ನನ್ನ ಹೆಸರನ್ನು ಉಚ್ಚರಿಸುವಾಗ ನಾನು ಅವರನ್ನು ಆಶೀರ್ವದಿಸುವೆನು.” ");
INSERT INTO kanirv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ಮೋಶೆ ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಎತ್ತಿ ನಿಲ್ಲಿಸಿ ಅದನ್ನೂ, ಅದರ ಸಾಮಾನುಗಳನ್ನೂ, ಯಜ್ಞವೇದಿಯನ್ನೂ ಮತ್ತು ಯಜ್ಞವೇದಿಯ ಉಪಕರಣಗಳನ್ನೂ ಯೆಹೋವನಿಗಾಗಿ ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ಆ ದಿನದಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಪ್ರಧಾನ ಪುರುಷರು ಅಂದರೆ ಗೋತ್ರದ ಪ್ರಮುಖರು, ಕುಲಾಧಿಪತಿಗಳು, ಜನಗಣತಿಯ ನೇತೃತ್ವವನ್ನು ವಹಿಸಿಕೊಂಡಿದ್ದವರು ಕಾಣಿಕೆಗಳನ್ನು ತಂದು ಸಮರ್ಪಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ಅವರು ಆರು ಕಮಾನು ಬಂಡಿಯನ್ನೂ ಮತ್ತು ಹನ್ನೆರಡು ಎತ್ತುಗಳನ್ನೂ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ತಂದರು. ನಾಯಕರಾದ ಇಬ್ಬರಿಬ್ಬರೂ ಒಂದು ಕಮಾನು ಬಂಡಿಯನ್ನೂ, ಪ್ರತಿ ನಾಯಕನು ಒಂದು ಜೋಡಿ ಎತ್ತನ್ನೂ, ದೇವದರ್ಶನ ಗುಡಾರದ ಮುಂದೆ ತಂದರು. ಹೀಗೆ ಆರು ಜೊತೆ ಬಂಡಿ ಆರು ಜೊತೆ ಎತ್ತುಗಳನ್ನು ತಂದು ಅರ್ಪಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ನೀನು ಇವರ ಕೈಯಿಂದ ಈ ಕಾಣಿಕೆಯ ವಸ್ತುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವೆಗಾಗಿ ಉಪಯೋಗಿಸು. ಕಾಣಿಕೆಯನ್ನು ಲೇವಿಯರಿಗೆ ಅವರವರ ಕೆಲಸಕ್ಕೆ ತಕ್ಕ ಹಾಗೆ ಕೊಡಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ಮೋಶೆ ಆ ಬಂಡಿಗಳನ್ನೂ ಮತ್ತು ಎತ್ತುಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಲೇವಿಯರಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ಅವನು ಗೇರ್ಷೋನ್ಯ ಸಂತಾನದವರಿಗೆ ಅವರ ಕೆಲಸಕ್ಕೆ ತಕ್ಕ ಹಾಗೆ ಎರಡು ಬಂಡಿಗಳನ್ನು, ಮತ್ತು ಎರಡು ಜೋಡಿ ಎತ್ತುಗಳನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ಮೆರಾರೀ ಸಂತಾನದವರಿಗೆ ಅವರ ಕೆಲಸಕ್ಕೆ ತಕ್ಕ ಹಾಗೆ ನಾಲ್ಕು ಬಂಡಿಗಳನ್ನು ಮತ್ತು ನಾಲ್ಕು ಜೋಡಿ ಎತ್ತುಗಳನ್ನು ಮಹಾಯಾಜಕನಾದ ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನ ಕೈಗೆ ಒಪ್ಪಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ಕೆಹಾತ್ಯರಿಗೆ ಮಾತ್ರ ಏನೂ ಕೊಡಲಿಲ್ಲ. ಏಕೆಂದರೆ ಅವರು ದೇವದರ್ಶನ ಗುಡಾರದ ಸಾಮಾನುಗಳನ್ನು ಸಾಗಿಸುವುದೇ ಅವರಿಗೆ ನೇಮಕವಾದ ಕೆಲಸವಾಗಿತ್ತು. ಅವರು ಅವುಗಳನ್ನು ಹೆಗಲಿನ ಮೇಲೆ ಹೊರುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ಮೋಶೆಯು ಯಜ್ಞವೇದಿಯನ್ನು ಅಭಿಷೇಕಿಸಿದ ದಿನದಲ್ಲಿ, ಕುಲಾಧಿಪತಿಗಳು ಅದರ ಪ್ರತಿಷ್ಠೆಗಾಗಿ ಕಾಣಿಕೆಗಳನ್ನು ತಂದು ಅದರ ಮುಂದೆ ಇಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಒಬ್ಬೊಬ್ಬ ಕುಲಾಧಿಪತಿಯು ತನಗೆ ನೇಮಕವಾದ ದಿನದಲ್ಲಿ ಯಜ್ಞವೇದಿಯ ಪ್ರತಿಷ್ಠೆಗಾಗಿ ತನ್ನ ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸಿದವನು ಯೆಹೂದ ಕುಲಾಧಿಪತಿಯಾದ ಅಮ್ಮೀನಾದಾಬನ ಮಗನಾದ ನಹಶೋನ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆ. ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು, ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ಅಮ್ಮೀನಾದಾಬನ ಮಗನಾದ ನಹಶೋನನು ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ಎರಡನೆಯ ದಿನದಲ್ಲಿ ಇಸ್ಸಾಕಾರ್ ಕುಲಾಧಿಪತಿಯೂ ಚೂವಾರನ ಮಗನೂ ಆದ ನೆತನೇಲನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆಯು; ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಒಂದು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯ ನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ಚೂವಾರನ ಮಗನಾದ ನೆತನೇಲನು ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಜೆಬುಲೂನ್ ಕುಲಾಧಿಪತಿಯೂ, ಹೇಲೋನನ ಮಗನೂ ಆದ ಎಲೀಯಾಬನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆ; ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಒಂದು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು; ");
INSERT INTO kanirv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು, ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ಹೇಲೋನನ ಮಗನಾದ ಎಲೀಯಾಬನು ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ನಾಲ್ಕನೆಯ ದಿನದಲ್ಲಿ ರೂಬೇನ್ ಕುಲಾಧಿಪತಿಯೂ, ಶೆದೇಯೂರನ ಮಗನೂ ಆದ ಎಲೀಚೂರನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ತಟ್ಟೆ; ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ಶೆದೇಯೂರನ ಮಗನಾದ ಎಲೀಚೂರನು ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ಐದನೆಯ ದಿನದಲ್ಲಿ ಸಿಮೆಯೋನ್ ಕುಲಾಧಿಪತಿಯೂ, ಚೂರೀಷದ್ದೈಯ ಮಗನೂ ಆದ ಶೆಲುಮೀಯೇಲನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ತಟ್ಟೆ; ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ಅವನು ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿ ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ಚೂರೀಷದ್ದೈಯ ಮಗನಾದ ಶೆಲುಮೀಯೇಲನು ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ಆರನೆಯ ದಿನದಲ್ಲಿ ಗಾದ್ ಕುಲಾಧಿಪತಿಯೂ, ದೆಗೂವೇಲನ ಮಗನೂ ಆದ ಎಲ್ಯಾಸಾಫನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆ, ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಒಂದು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ಅವನು ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು, ದೆಗೂವೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫನು ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಎಫ್ರಾಯೀಮ್ ಕುಲಾಧಿಪತಿಯೂ, ಅಮ್ಮೀಹೂದನ ಮಗನೂ ಆದ ಎಲೀಷಾಮನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆ; ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಒಂದು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ಅಮ್ಮೀಹೂದನ ಮಗನಾದ ಎಲೀಷಾಮನು ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಮನಸ್ಸೆ ಕುಲಾಧಿಪತಿಯೂ, ಪೆದಾಚೂರನ ಮಗನೂ ಆದ ಗಮ್ಲೀಯೇಲನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಬೆಳ್ಳಿಯ ಒಂದು ತಟ್ಟೆ, ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಬೆಳ್ಳಿಯ ಒಂದು ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ಅವನು ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ಒಂಭತ್ತನೆಯ ದಿನದಲ್ಲಿ ಬೆನ್ಯಾಮೀನ್ ಕುಲಾಧಿಪತಿಯೂ ಗಿದ್ಯೋನಿಯ ಮಗನೂ ಆದ ಅಬೀದಾನನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆ; ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಒಂದು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ಗಿದ್ಯೋನಿಯ ಮಗನಾದ ಅಬೀದಾನನು ಕಾಣಿಕೆಯಾಗಿ ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ದಾನ್ ಕುಲಾಧಿಪತಿಯೂ ಅಮ್ಮೀಷದ್ದೈಯ ಮಗನೂ ಆದ ಅಹೀಗೆಜೆರನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆ; ಎಪ್ಪತ್ತು ಶೆಕಲ್ ತೂಕವುಳ್ಳ ಒಂದು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ಅಮ್ಮೀಷದ್ದೈಯ ಮಗನಾದ ಅಹೀಗೆಜೆರನು ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ಹನ್ನೊಂದನೆಯ ದಿನದಲ್ಲಿ ಆಶೇರ್ ಕುಲಾಧಿಪತಿಯೂ ಒಕ್ರಾನನ ಮಗನೂ ಆದ ಪಗೀಯೇಲನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆಯೂ, ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಒಂದು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ಹನ್ನೆರಡನೆಯ ದಿನದಲ್ಲಿ ನಫ್ತಾಲಿ ಕುಲಾಧಿಪತಿಯೂ ಏನಾನನ ಮಗನೂ ಆದ ಅಹೀರನು ಕಾಣಿಕೆಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ಅವನು ತಂದ ಕಾಣಿಕೆ: ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಮೇರೆಗೆ ನೂರ ಮೂವತ್ತು ಶೆಕೆಲ್ ತೂಕದ ಒಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆ, ಎಪ್ಪತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಒಂದು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು; ಈ ಎರಡರಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಗೋದಿಯ ಹಿಟ್ಟು ತುಂಬಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಹತ್ತು ಶೆಕೆಲ್ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ಅವನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಕುರಿಯನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತ, ");
INSERT INTO kanirv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳು, ಐದು ಟಗರುಗಳು, ಐದು ಹೋತಗಳು ಮತ್ತು ಒಂದು ವರ್ಷದ ಐದು ಕುರಿಗಳನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ಯಜ್ಞವೇದಿ ಅಭಿಷೇಕಿಸಲ್ಪಟ್ಟ ದಿನದಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಕುಲಾಧಿಪತಿಗಳು, ಅದರ ಪ್ರತಿಷ್ಠೆಗಾಗಿ ಕೊಟ್ಟ ಕಾಣಿಕೆಗಳು ಒಟ್ಟಾಗಿ 12 ಬೆಳ್ಳಿಯ ತಟ್ಟೆಗಳು, 12 ಬೆಳ್ಳಿಯ ಬಟ್ಟಲುಗಳು, 12 ಚಿನ್ನದ ಧೂಪಾರತಿಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ಒಂದೊಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆಯು 120 ಶೆಕೆಲ್ ತೂಕವುಳ್ಳದ್ದು, ಒಂದೊಂದು ಬಟ್ಟಲು 70 ಶೆಕೆಲ್ ತೂಕದ್ದು. ಆ ಬೆಳ್ಳಿಯ ಪಾತ್ರೆಗಳ ಒಟ್ಟು ತೂಕ ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಪ್ರಕಾರ 2,400 ಶೆಕೆಲ್. ");
INSERT INTO kanirv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ಒಂದೊಂದು ಚಿನ್ನದ ಧೂಪಾರತಿಯ ತೂಕವು ದೇವಸ್ಥಾನದ ನಾಣ್ಯ ತೂಕದ ಪ್ರಕಾರ ಹತ್ತು ಶೆಕೆಲ್ ಮೇರೆಗೆ ಇರುವುದರಿಂದ ಆ ಹನ್ನೆರಡು ಧೂಪಾರತಿಗಳ ಚಿನ್ನವು ಒಟ್ಟಾಗಿ 120 ಶೆಕೆಲ್. ");
INSERT INTO kanirv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಕೊಟ್ಟ ಒಟ್ಟು ಪಶುಗಳು: 12 ಹೋರಿಗಳು, 12 ಟಗರುಗಳು, ಒಂದು ವರ್ಷದ 12 ಕುರಿಗಳು ಇವುಗಳೊಂದಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಧಾನ್ಯದ್ರವ್ಯವನ್ನೂ ಕೊಟ್ಟರು. ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಕೊಟ್ಟದ್ದು 12 ಹೋತಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಕೊಟ್ಟ ಒಟ್ಟು ಪಶುಗಳು: 24 ಹೋರಿಗಳು, 60 ಟಗರುಗಳು, 60 ಹೋತಗಳು, ಒಂದು ವರ್ಷದ 60 ಕುರಿಗಳು, ಯಜ್ಞವೇದಿಯು ಅಭಿಷೇಕಿಸಲ್ಪಟ್ಟ ನಂತರ ಇದೇ ಅದರ ಪ್ರತಿಷ್ಠೆಗೆ ಸಮರ್ಪಿಸಲ್ಪಟ್ಟ ಕಾಣಿಕೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ಮೋಶೆ ಯೆಹೋವನ ಸಂಗಡ ಮಾತನಾಡಬೇಕೆಂದು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಹೋದಾಗ ಆಜ್ಞಾಶಾಸನಗಳ ಮಂಜೂಷದ ಮೇಲಣ ಕೃಪಾಸನದ ಮೇಲಿನಿಂದ ಆ ಎರಡು ಕೆರೂಬಿಗಳ ನಡುವೆಯಿಂದ ತನ್ನ ಸಂಗಡ ಮಾತನಾಡುವ ಯೆಹೋವನ ಸ್ವರವು ಅವನಿಗೆ ಕೇಳಿಸಿತು. ಹೀಗೆ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kanirv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“ಆರೋನನು ದೇವಸ್ಥಾನದ ದೀಪಗಳನ್ನು ಕ್ರಮಪಡಿಸುವಾಗ ಆ ಏಳು ದೀಪಗಳು ದೀಪಸ್ತಂಭದ ಎದುರಾಗಿರುವ ಸ್ಥಳಕ್ಕೆ ಬೆಳಕುಕೊಡುವಂತೆ ಅವುಗಳನ್ನು ಇಡಬೇಕೆಂದು ಅವನಿಗೆ ಆಜ್ಞಾಪಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಆರೋನನು ಮಾಡಿದನು. ದೀಪಸ್ತಂಭದ ಎದುರಿನ ಪ್ರದೇಶಕ್ಕೆ ಬೆಳಕುಕೊಡುವಂತೆ ಆ ದೀಪಗಳನ್ನು ಕ್ರಮವಾಗಿ ಇಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ದೀಪಸ್ತಂಭವೂ, ಅದರ ಬುಡದ ಭಾಗವೂ, ಪುಷ್ಪಾಲಂಕಾರಗಳೂ ಬಂಗಾರದ ನಕಾಸಿ ಕೆಲಸದಿಂದ ಮಾಡಲ್ಪಟ್ಟಿತ್ತು. ಯೆಹೋವನು ತೋರಿಸಿದ ಮಾದರಿಯಂತೆ ಮೋಶೆ ಅದನ್ನು ಮಾಡಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ನೀನು ಇಸ್ರಾಯೇಲರಿಂದ ಲೇವಿಯರನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ ಶುದ್ಧೀಕರಿಸಿಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ಅವರನ್ನು ಶುದ್ಧೀಕರಿಸಬೇಕಾದ ಕ್ರಮ ಹೇಗೆಂದರೆ: ನೀನು ಅವರ ಮೇಲೆ ದೋಷಪರಿಹಾರಕ ಜಲವನ್ನು ಚಿಮುಕಿಸಬೇಕು. ಅವರು ಸರ್ವಾಂಗ ಕ್ಷೌರಮಾಡಿಸಿಕೊಳ್ಳಲಿ. ಅವರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ತಮ್ಮನ್ನು ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ತರುವಾಯ ಅವರು ಸರ್ವಾಂಗಹೊಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ ಅದರೊಡನೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಧಾನ್ಯನೈವೇದ್ಯ ಅಂದರೆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಗೋದಿಯ ಹಿಟ್ಟನ್ನೂ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಮತ್ತೊಂದು ಹೋರಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ಆಗ ನೀನು ಲೇವಿಯರನ್ನು ದೇವದರ್ಶನ ಗುಡಾರದ ಮುಂದೆ ಕರೆದುಕೊಂಡು ಬಂದು ಇಸ್ರಾಯೇಲರ ಸಮೂಹವನ್ನೆಲ್ಲಾ ಕೂಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ಲೇವಿಯರನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಲ್ಲಿಸಿದಾಗ, ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಕೈಗಳನ್ನು ಲೇವಿಯರ ಮೇಲೆ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ಲೇವಿಯರು ಯೆಹೋವನ ಸೇವಾಕಾರ್ಯವನ್ನು ಮಾಡುವವರಾಗುವಂತೆ ಆರೋನನು ಇಸ್ರಾಯೇಲರ ನಿಮಿತ್ತ ಅವರನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯದಂತೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“ಲೇವಿಯರು ಆ ಹೋರಿಗಳ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನಿಡಬೇಕು. ನಂತರ ನೀನು ಯೆಹೋವನಿಗೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ, ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಮತ್ತೊಂದು ಹೋರಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಅವರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ನೀನು ಆರೋನನ ಮತ್ತು ಅವನ ಮಕ್ಕಳ ಮುಂದೆ ಲೇವಿಯರನ್ನು ನಿಲ್ಲಿಸಿ ಅವರನ್ನು ನೈವೇದ್ಯದಂತೆ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ಹೀಗೆ ನೀನು ಲೇವಿಯರನ್ನು ಇಸ್ರಾಯೇಲರಿಂದ ಪ್ರತ್ಯೇಕಿಸಿದಾಗ ಅವರು ನನ್ನ ಸೊತ್ತಾಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“ಅದಾದ ನಂತರ ಲೇವಿಯರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವಾಕಾರ್ಯವನ್ನು ಮಾಡಬೇಕು. ನೀನು ಅವರನ್ನು ಶುದ್ಧೀಕರಿಸಿ ನೈವೇದ್ಯದಂತೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಇವರು ನನಗೆ ಸಂಪೂರ್ಣವಾಗಿ ಸಮರ್ಪಿತರಾದವರು. ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಚೊಚ್ಚಲ ಮಕ್ಕಳಿಗೆ ಬದಲಾಗಿ ನಾನು ಲೇವಿಯರನ್ನು ನನ್ನ ಸ್ವಂತಕ್ಕಾಗಿ ತೆಗೆದುಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ಇಸ್ರಾಯೇಲರಲ್ಲಿರುವ ಚೊಚ್ಚಲಾದ ಮನುಷ್ಯರೂ ಪಶುಗಳೂ ಎಲ್ಲಾ ನನ್ನ ಸ್ವಂತ ಸೊತ್ತು. ಐಗುಪ್ತ ದೇಶದಲ್ಲಿದ್ದ ಚೊಚ್ಚಲಾದುದನ್ನು ನಾನು ಸಂಹರಿಸಿದಾಗ ಇಸ್ರಾಯೇಲರ ಚೊಚ್ಚಲಾದುದನ್ನು ನನ್ನ ಸ್ವಂತಕ್ಕಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡೆನು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ನಾನು ಇಸ್ರಾಯೇಲರ ಚೊಚ್ಚಲಮಕ್ಕಳಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರನ್ನು ತೆಗೆದುಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ಇಸ್ರಾಯೇಲರಿಗಾಗಿ ದೇವದರ್ಶನ ಗುಡಾರದ ಸೇವಾಕಾರ್ಯವನ್ನು ನಡಿಸುವುದಕ್ಕೂ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡುವುದಕ್ಕೂ ಲೇವಿಯರನ್ನು ಆರೋನನ ಮತ್ತು ಅವನ ಮಕ್ಕಳ ವಶಕ್ಕೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ಹೀಗಿರುವುದರಿಂದ ಇಸ್ರಾಯೇಲರು ದೇವಾಲಯದ ಹತ್ತಿರಕ್ಕೆ ಬಂದಾಗ ಅವರಿಗೆ ಅಪಾಯವು ಸಂಭವಿಸುವುದಿಲ್ಲ.” ");
INSERT INTO kanirv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ಯೆಹೋವನು ಲೇವಿಯರ ವಿಷಯದಲ್ಲಿ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆ, ಆರೋನರೂ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರೆಲ್ಲರೂ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ಲೇವಿಯರು ತಮ್ಮನ್ನು ಶುದ್ಧಪಡಿಸಿಕೊಂಡು ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡರು. ಆರೋನನು ಅವರನ್ನು ನೈವೇದ್ಯದಂತೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಿ, ಅವರನ್ನು ಶುದ್ಧೀಕರಿಸುವುದಕ್ಕಾಗಿ ಅವರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ಆ ಮೇಲೆ ಲೇವಿಯರು ತಮಗೆ ನೇಮಕವಾದ ಕೆಲಸವನ್ನು ದೇವದರ್ಶನ ಗುಡಾರದಲ್ಲಿ ಆರೋನನ ಮತ್ತು ಅವನ ಮಕ್ಕಳ ಕೈಕೆಳಗೆ ಆರಂಭಿಸಿದರು. ಅವರ ವಿಷಯದಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ಪುನಃ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ಲೇವಿಯರು ಅನುಸರಿಸಬೇಕಾದ ಪದ್ಧತಿ ಏನೆಂದರೆ: ಇಪ್ಪತ್ತೈದು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಿನ ವಯಸ್ಸಿನವರು ದೇವದರ್ಶನ ಗುಡಾರದ ಸೇವಮಂಡಳಿಗೆ ಸೇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ಅವರು ಐವತ್ತು ವರ್ಷದವರಾದ ನಂತರ ಆ ಮಂಡಳಿಯನ್ನು ಬಿಟ್ಟು ದೇವಾಲಯದ ಸೇವಾಕಾರ್ಯದಿಂದ ಬಿಡುಗಡೆಯಾಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ಅಂಥವರು ತಮ್ಮ ಸ್ವಕುಲದವರ ಜೊತೆಯಲ್ಲಿ ದೇವದರ್ಶನ ಗುಡಾರವನ್ನು ಕಾಯುವ ಸೇವೆಯನ್ನು ಮಾಡಬಹುದೇ ಹೊರತು ಅವರಿಂದ ಬೇರೆ ಸೇವಾಕಾರ್ಯವನ್ನು ಮಾಡಿಸಬಾರದು. ಲೇವಿಯರು ಕಾಪಾಡಬೇಕಾದ ಕರ್ತವ್ಯಗಳನ್ನು ನೀನು ಹೀಗೆ ಅವರಿಗೆ ನೇಮಿಸಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ಇಸ್ರಾಯೇಲರು ಐಗುಪ್ತ ದೇಶವನ್ನು ಬಿಟ್ಟುಬಂದ ಎರಡನೆಯ ವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳಿನಲ್ಲಿ, ಸೀನಾಯಿ ಅರಣ್ಯದಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ಇಸ್ರಾಯೇಲರು ಪಸ್ಕಹಬ್ಬ ಆಚರಿಸಲು ನೇಮಕವಾದ ಕಾಲದಲ್ಲಿ ಆಚರಿಸಲು ಹೇಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ನಾನು ನೇಮಿಸಿದ ಆಜ್ಞಾವಿಧಿಗಳ ಪ್ರಕಾರ ನೇಮಕವಾದ ಕಾಲದಲ್ಲಿಯೇ ಅಂದರೆ ಈ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ಸಂಜೆಯ ವೇಳೆಯಲ್ಲಿ ನೀವು ಅದನ್ನು ಆಚರಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ಆದಕಾರಣ ಮೋಶೆ ಇಸ್ರಾಯೇಲರಿಗೆ, ನೀವು ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ಹಾಗೆಯೇ ಅವರು ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ಸಂಜೆಯ ವೇಳೆಯಲ್ಲಿ ಸೀನಾಯಿ ಅರಣ್ಯದಲ್ಲಿ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಿದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಎಲ್ಲವನ್ನು ಇಸ್ರಾಯೇಲರು ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ಆದರೆ ಕೆಲವು ಜನರಿಗೆ ಮನುಷ್ಯನ ಶವಸೋಂಕು ಇದ್ದುದರಿಂದ ಅಶುದ್ಧರಾಗಿ ಆ ದಿನದಲ್ಲಿ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಲಾಗದೆ ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಬಳಿಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ಈ ಜನರು ಮೋಶೆಗೆ “ಮನುಷ್ಯನ ಶವಸೋಂಕಿದರಿಂದ ನಾವು ಅಶುದ್ಧರಾದೆವು. ನಾವು ಉಳಿದ ಇಸ್ರಾಯೇಲರೊಡನೆ ನೇಮಕವಾದ ಕಾಲದಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಯಜ್ಞವನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕೆ ಅಪ್ಪಣೆಯಿಲ್ಲವೋ?” ಎಂದು ಕೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ಅದಕ್ಕೆ ಮೋಶೆ ಅವರಿಗೆ, “ಸ್ವಲ್ಪ ಕಾದುಕೊಂಡಿರಿ. ನಿಮ್ಮ ವಿಷಯದಲ್ಲಿ ಯೆಹೋವನು ಏನು ಅಪ್ಪಣೆಮಾಡುವನೋ ನಾನು ವಿಚಾರಿಸುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ಆಗ ಯೆಹೋವನು ಮೋಶೆ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ನಿಮ್ಮಲ್ಲಿಯಾಗಲಿ, ನಿಮ್ಮ ಸಂತತಿಯವರಲ್ಲಿಯಾಗಲಿ ಶವ ಸೋಂಕಿನಿಂದ ಅಶುದ್ಧರಾದವರೂ ಅಥವಾ ದೂರ ಪ್ರಯಾಣದಲ್ಲಿರುವವರೂ ಯೆಹೋವನ ಆಜ್ಞಾನುಸಾರ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಲೇಬೇಕು.’ ");
INSERT INTO kanirv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ಅಂಥವರು ಎರಡನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ಸಂಜೆಯ ವೇಳೆಯಲ್ಲಿ ಅದನ್ನು ಆಚರಿಸಬೇಕು. ಆ ಪಶುವಿನ ಮಾಂಸವನ್ನು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳ ಮತ್ತು ಕಹಿಯಾದ ಸೊಪ್ಪುಗಳ ಸಂಗಡ ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ಅದರಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನಾದರೂ ಮರುದಿನದವರೆಗೆ ಉಳಿಸಬಾರದು. ಆ ಪಶುವಿನ ಒಂದು ಎಲುಬನ್ನಾದರೂ ಮುರಿಯಬಾರದು. ಅಂತೂ ಪಸ್ಕಹಬ್ಬದ ವಿಷಯವಾಗಿರುವ ವಿಧಿನಿಯಮಗಳ ಪ್ರಕಾರವೇ ಅದನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ಆದರೆ ಯಾವನಾದರೂ ಶುದ್ಧನಾಗದೆ, ಪ್ರಯಾಣಮಾಡದೆ ಇದ್ದು ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಲು ತಪ್ಪಿದರೆ ಅವನನ್ನು ಕುಲದಿಂದ ಹೊರಗೆ ಹಾಕಬೇಕು. ಅವನು ಯೆಹೋವನಿಂದ ನೇಮಿತವಾದ ಯಜ್ಞವನ್ನು ನೇಮಕವಾದ ಕಾಲದಲ್ಲಿ ಸಮರ್ಪಿಸದೆ ಹೋದುದರಿಂದ ತನ್ನ ದೋಷಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ನಿಮ್ಮಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿರುವ ಅನ್ಯದೇಶದವನು ಯೆಹೋವನಿಗೆ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕೆಂದು ಅಪೇಕ್ಷಿಸಿದರೆ ಅದರ ವಿಷಯವಾದ ಆಜ್ಞಾವಿಧಿಗಳ ಪ್ರಕಾರವೇ ಅದನ್ನು ಆಚರಿಸಲಿ. ಪರದೇಶದವನಿಗೂ ಸ್ವದೇಶದವನಿಗೂ ಒಂದೇ ನಿಯಮವಿರಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ಇಸ್ರಾಯೇಲರು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಎತ್ತಿ ನಿಲ್ಲಿಸಿದ ದಿನದಲ್ಲಿ ಮೇಘವು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಆವರಿಸಿಕೊಂಡಿತು. ಅದು ಸಂಜೆಯಿಂದ ಮುಂಜಾನೆಯವರೆಗೆ ಬೆಂಕಿಯಂತೆ ಕಾಣಿಸುತ್ತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ನಿತ್ಯವೂ ಹಾಗೆಯೇ ಕಾಣಿಸುತ್ತಿತ್ತು; ಮೇಘವು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಆವರಿಸಿಕೊಂಡಿತು. ರಾತ್ರಿವೇಳೆಯಲ್ಲಿ ಆ ಮೇಘವು ಬೆಂಕಿಯಂತೆ ಕಾಣಿಸುತ್ತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ಆ ಮೇಘವು ಗುಡಾರದಿಂದ ಮೇಲಕ್ಕೆ ಎದ್ದಾಗ ಇಸ್ರಾಯೇಲರು ಮುಂದಕ್ಕೆ ಪ್ರಯಾಣಮಾಡುತ್ತಿದ್ದರು. ಆ ಮೇಘವು ಎಲ್ಲಿ ನಿಲ್ಲುವುದೋ ಅಲ್ಲಿ ಇಸ್ರಾಯೇಲರು ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ಯೆಹೋವನ ಅಪ್ಪಣೆಯನ್ನು ಹೊಂದಿ ಇಸ್ರಾಯೇಲರು ಪ್ರಯಾಣಮಾಡುತ್ತಿದ್ದರು, ಯೆಹೋವನ ಅಪ್ಪಣೆಯನ್ನು ಹೊಂದಿ ಅವರು ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳುತ್ತಿದ್ದರು. ಆ ಮೇಘವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮೇಲಿರುವ ತನಕ ಅವರು ಇದ್ದ ಸ್ಥಳದಲ್ಲೇ ಇರುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ಆ ಮೇಘವು ಬಹುದಿನದವರೆಗೂ ದೇವದರ್ಶನದ ಗುಡಾರದ ಮೇಲೆ ಇರುವಾಗ ಇಸ್ರಾಯೇಲರು ಯೆಹೋವನ ಸೂಚನೆಯನ್ನು ಅನುಸರಿಸಿ ಪ್ರಯಾಣ ಮಾಡದೆ ಇರುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ಒಂದೊಂದು ವೇಳೆಯಲ್ಲಿ ಮೇಘವು ಕೆಲವು ದಿನಗಳು ಮಾತ್ರ ಗುಡಾರದ ಮೇಲೆ ನಿಂತಿರುತ್ತಿತ್ತು. ಯೆಹೋವನ ಆಜ್ಞಾನುಸಾರವಾಗಿ ಅವರು ಇಳಿದುಕೊಳ್ಳುತ್ತಿದ್ದರು. ಯೆಹೋವನ ಆಜ್ಞಾನುಸಾರವಾಗಿ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೊರಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ಕೆಲವು ಸಮಯಗಳಲ್ಲಿ ಮೇಘವು ಸಾಯಂಕಾಲದಿಂದ ಬೆಳಗ್ಗಿನವರೆಗೆ ಇರುತ್ತಿತ್ತು. ಬೆಳಗ್ಗೆ ಅದು ಮೇಲಕ್ಕೆ ಏಳುವಾಗ ಜನರು ಪ್ರಯಾಣಮಾಡುತ್ತಿದ್ದರು. ಕೆಲವು ಸಮಯಗಳಲ್ಲಿ ಅದು ಹಗಲಿರುಳು ನಿಂತಿರುತ್ತಿತ್ತು. ಅದು ಯಾವಾಗ ಮೇಲೇಳುತ್ತಿತ್ತೋ ಆಗ ಜನರು ಹೊರಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ಆ ಮೇಘವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮೇಲೆ ನಿಂತಿರುವುದು ಎರಡು ದಿನವಾದರೂ, ಒಂದು ತಿಂಗಳಾದರೂ, ಒಂದು ವರ್ಷವಾದರೂ ಅಲ್ಲಿಯ ತನಕ ಇಸ್ರಾಯೇಲರು ಪ್ರಯಾಣಮಾಡದೆ ಅಲ್ಲೇ ಇಳಿದುಕೊಂಡಿರುತ್ತಿದ್ದರು. ಮೇಘವು ಏಳುವಾಗ ಅವರು ಹೊರಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ಯೆಹೋವನ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಅವರು ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳುತ್ತಿದ್ದರು. ಯೆಹೋವನ ಆಜ್ಞೆಯ ಪ್ರಕಾರವೇ ಅವರು ಡೇರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೊರಡುತ್ತಿದ್ದರು. ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕವಾಗಿ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವರು ಯೆಹೋವನ ಸೂಚನೆಗಳನ್ನು ಅನುಸರಿಸಿ ನಡೆಯುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“ನೀನು ಬೆಳ್ಳಿಯ ತಗಡಿನಿಂದ ಎರಡು ತುತ್ತೂರಿಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಜನಸಮೂಹದವರನ್ನು ಕೂಡಿಸುವುದಕ್ಕೂ ಮತ್ತು ದಂಡುಗಳನ್ನು ಹೊರಡಿಸುವುದಕ್ಕೂ ಅವುಗಳನ್ನು ಉಪಯೋಗಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ನೀನು ತುತ್ತೂರಿಗಳನ್ನು ಊದಿಸುವಾಗ ಜನಸಮೂಹದವರೆಲ್ಲರೂ ನಿನ್ನ ಹತ್ತಿರ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಕೂಡಿಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ನೀನು ಒಂದನ್ನು ಮಾತ್ರ ಊದಿಸುವಾಗ ಇಸ್ರಾಯೇಲರ ಕುಲಾಧಿಪತಿಗಳಾದ ಪ್ರಧಾನರು ನಿನ್ನ ಬಳಿಗೆ ಕೂಡಿಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ನೀನು ಆರ್ಭಟವಾಗಿ ಊದಿಸುವಾಗ ಪೂರ್ವದಿಕ್ಕಿನ ದಂಡುಗಳು ಹೊರಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ಎರಡನೆಯ ಸಾರಿ ಆರ್ಭಟವಾಗಿ ಊದಿಸುವಾಗ ದಕ್ಷಿಣ ದಿಕ್ಕಿನ ದಂಡುಗಳು ಹೊರಡಬೇಕು. ಹೀಗೆ ಪ್ರಯಾಣಕ್ಕೆ ಹೊರಡಬೇಕಾದಾಗ ಆರ್ಭಟವಾಗಿಯೇ ಊದಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ಜನಸಮೂಹದವರು ಕೂಡಿಬರಬೇಕಾದಾಗ ಸಾಧಾರಣವಾಗಿ ಊದಿಸಬೇಕೇ ಹೊರತು ಆರ್ಭಟವಾಗಿ ಊದಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“ಆರೋನನ ವಂಶಸ್ಥರಾದ ಯಾಜಕರೇ ಆ ತುತ್ತೂರಿಗಳನ್ನು ಊದಬೇಕು. ಇದು ನಿಮಗೂ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತ ನಿಯಮವಾಗಿರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","ನೀವು ಸ್ವದೇಶವನ್ನು ಸೇರಿದ ಮೇಲೆ ನಿಮ್ಮನ್ನು ಉಪದ್ರವಪಡಿಸುವ ಶತ್ರುಗಳನ್ನು ಎದುರಿಸುವುದಕ್ಕಾಗಿ ಯುದ್ಧಕ್ಕೆ ಹೊರಡುವಾಗ ಆ ತುತ್ತೂರಿಗಳನ್ನು ಆರ್ಭಟವಾಗಿ ಊದಿಸಬೇಕು. ಆಗ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ಜ್ಞಾಪಕಕ್ಕೆ ತಂದುಕೊಂಡು ಶತ್ರುಗಳ ಕೈಯಿಂದ ರಕ್ಷಿಸುವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ಇದಲ್ಲದೆ ನೀವು ಉತ್ಸವ ಕಾಲಗಳಲ್ಲಿಯು, ಹಬ್ಬಗಳಲ್ಲಿಯು, ಅಮಾವಾಸ್ಯೆಗಳಲ್ಲಿಯು ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ, ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನೂ ಸಮರ್ಪಿಸುವಾಗ ಆ ತುತ್ತೂರಿಗಳನ್ನು ಊದಿಸಬೇಕು. ಆ ತುತ್ತೂರಿಯ ಧ್ವನಿಯು ನಿಮ್ಮನ್ನು ನಿಮ್ಮ ದೇವರ ಜ್ಞಾಪಕಕ್ಕೆ ತರುವುದು, ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು.” ");
INSERT INTO kanirv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ಎರಡನೆಯ ವರ್ಷದ ಎರಡನೆಯ ತಿಂಗಳಿನ ಇಪ್ಪತ್ತನೆಯ ದಿನದಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಮೇಲಿದ್ದ ಮೇಘವು ಮೇಲಕ್ಕೆ ಎದ್ದಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ಆದುದರಿಂದ ಇಸ್ರಾಯೇಲರು ಸೀನಾಯಿ ಅರಣ್ಯವನ್ನು ಬಿಟ್ಟು ಮುಂದೆ ಮುಂದೆ ಪ್ರಯಾಣಮಾಡಿದರು. ತರುವಾಯ ಆ ಮೇಘವು ಪಾರಾನ್ ಅರಣ್ಯದಲ್ಲಿ ನಿಂತಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಆಜ್ಞಾಪಿಸಿದ ರೀತಿಯಲ್ಲಿ ಅವರು ಪ್ರಯಾಣಮಾಡಿದ್ದು ಇದೇ ಮೊದಲನೆಯ ಸಾರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ಮುಂಭಾಗದಲ್ಲಿ ಯೆಹೂದ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದವರು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ಹೊರಟರು. ಅವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಅಮ್ಮೀನಾದಾಬನ ಮಗನಾದ ನಹಶೋನನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ಇಸ್ಸಾಕಾರ್ ಕುಲದವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಚೂವಾರನ ಮಗನಾದ ನೆತನೇಲನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ಜೆಬುಲೂನ್ ಕುಲದವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಹೇಲೋನನ ಮಗನಾದ ಎಲೀಯಾಬನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ತರುವಾಯ ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ಇಳಿಸಿದಾಗ ಗೇರ್ಷೋನ್ಯರು ಮತ್ತು ಮೆರಾರೀಯರೂ ಅದನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೊರಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ಆಮೇಲೆ ರೂಬೇನ್ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದವರು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ಹೊರಟರು. ಅವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಶೆದೇಯೂರನ ಮಗನಾದ ಎಲೀಚೂರನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ಸಿಮೆಯೋನ್ ಕುಲದವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಚೂರೀಷದ್ದೈಯ ಮಗನಾದ ಶೆಲುಮೀಯೇಲನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ಗಾದ್ ಕುಲದವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ದೆಗೂವೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ಅವರ ಹಿಂದೆ ಕೆಹಾತ್ಯರು ದೇವಾಲಯದ ಸಾಮಾನುಗಳನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೊರಟರು. ಅವರು ಬರುವಷ್ಟರೊಳಗೆ ಉಳಿದ ಲೇವಿಯರು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ನಿಲ್ಲಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ಆ ಮೇಲೆ ಎಫ್ರಾಯೀಮ್ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದವರು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ಹೊರಟರು. ಅವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಅಮ್ಮೀಹೂದನ ಮಗನಾದ ಎಲೀಷಾಮನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ಮನಸ್ಸೆ ಕುಲದವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಪೆದಾಚೂರನ ಮಗನಾದ ಗಮ್ಲೀಯೇಲನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ಬೆನ್ಯಾಮೀನ್ ಕುಲದವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಗಿದ್ಯೋನಿಯ ಮಗನಾದ ಅಬೀದಾನನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ಆ ಮೇಲೆ ಎಲ್ಲಾ ದಂಡುಗಳ ಹಿಂಭಾಗದಲ್ಲಿ ದಾನ್ ಕುಲದ ದಂಡಿಗೆ ಸೇರಿದವರು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ಹೊರಟರು. ಅವರ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಅಮ್ಮೀಷದ್ದೈಯ ಮಗನಾದ ಅಹೀಗೆಜೆರನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ಆಶೇರ್ ಕುಲದವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಒಕ್ರಾನನ ಮಗನಾದ ಪಗೀಯೇಲನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ನಫ್ತಾಲಿ ಕುಲದವರಿಗೆ ಸೇನಾನಾಯಕನಾಗಿ ಇದ್ದವನು ಏನಾನನ ಮಗನಾದ ಅಹೀರನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ಈ ರೀತಿಯಲ್ಲಿ ಇಸ್ರಾಯೇಲರು ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ಹೊರಟು ಪ್ರಯಾಣಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ಮೋಶೆಯು ತನ್ನ ಮಾವನಾಗಿದ್ದ ಮಿದ್ಯಾನ್ಯನಾದ ರೆಗೂವೇಲನ ಮಗನಾದ ಹೋಬಾಬನಿಗೆ, “ಯೆಹೋವನು ನಮಗೆ ಕೊಡುತ್ತೇನೆಂದು ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶಕ್ಕೆ ನಾವು ಪ್ರಯಾಣಮಾಡುತ್ತಾ ಇದ್ದೇವೆ. ಇಸ್ರಾಯೇಲರಿಗೆ ಒಳಿತನ್ನು ಉಂಟುಮಾಡುತ್ತೇನೆಂದು ಯೆಹೋವನು ತಾನೇ ಹೇಳಿದ್ದಾನೆ. ಆದುದರಿಂದ ನೀನೂ ನಮ್ಮ ಜೊತೆಯಲ್ಲಿ ಬಾ; ನಮ್ಮಿಂದ ನಿನಗೂ ಒಳ್ಳೆಯದಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ಆದರೆ ಹೋಬಾಬನು ಮೋಶೆಗೆ, “ನಾನು ಬರುವುದಿಲ್ಲ; ನನ್ನ ಸ್ವದೇಶಕ್ಕೆ, ನನ್ನ ಸ್ವಜನರ ಬಳಿಗೆ ಹೋಗುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ಅದಕ್ಕೆ ಮೋಶೆಯು ಉತ್ತರವಾಗಿ, “ನಮ್ಮನ್ನು ಬಿಟ್ಟು ಹೋಗಬೇಡವೆಂದು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ. ಈ ಮರುಭೂಮಿಯಲ್ಲಿ ಡೇರೆಗಳನ್ನು ಹಾಕುವ ಸ್ಥಳಗಳು ನಿನಗೆ ಮಾತ್ರ ಗೊತ್ತಿದೆ. ಆದುದರಿಂದ ನೀನು ನಮಗೆ ಕಣ್ಣಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ನೀನು ನಮ್ಮ ಸಂಗಡ ಬಂದರೆ ಯೆಹೋವನು ನಮಗೆ ಮಾಡುವ ಒಳ್ಳೆಯದನ್ನೆಲ್ಲಾ ನಾವು ನಿನಗೂ ಉಂಟಾಗುವಂತೆ ಮಾಡುವೆವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ಅವರು ಯೆಹೋವನ ಬೆಟ್ಟವನ್ನು ಬಿಟ್ಟು ಮೂರು ದಿನದ ಪ್ರಯಾಣದಷ್ಟು ದೂರ ಹೋದರು. ಇಳಿದುಕೊಳ್ಳಲು ಸೂಕ್ತವಾದ ಸ್ಥಳವನ್ನು ನೋಡುವುದಕ್ಕಾಗಿ ಯೆಹೋವನ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷವು ಆ ಮೂರು ದಿನಗಳು ಅವರ ಮುಂದಾಗಿ ಹೋಗುತ್ತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ಅವರು ಪಾಳೆಯದಿಂದ ಹೊರಡುವಾಗ ಹಗಲು ಹೊತ್ತಿನಲ್ಲಿ ಯೆಹೋವನ ಮೇಘವು ಅವರ ಮೇಲೆ ಇರುತ್ತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ಯೆಹೋವನ ಮಂಜೂಷ ಪೆಟ್ಟಿಗೆಯು ಹೊರಡುವಾಗ ಮೋಶೆ, “ಯೆಹೋವನೇ, ಎದ್ದು ಹೊರಡೋಣವಾಗಲಿ; ನಿನ್ನ ವೈರಿಗಳು ಚದರಿಹೋಗಲಿ; ನಿನ್ನ ಶತ್ರುಗಳು ಬೆನ್ನು ತೋರಿಸಿ ಓಡಿಹೋಗಲಿ” ಎಂದು ಹೇಳುವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ಅದು ನಿಂತಾಗ ಅವನು, “ಯೆಹೋವನೇ, ಇಸ್ರಾಯೇಲರ ಲಕ್ಷಾಂತರ ಕುಟುಂಬಗಳ ಮಧ್ಯದಲ್ಲಿ ಮರಳಿ ಆಗಮಿಸು” ಎಂದು ಹೇಳುವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ಇಸ್ರಾಯೇಲ ಜನರು ತಮಗೆ ದುರಾವಸ್ಥೆ ಉಂಟಾಯಿತೆಂದು ಯೆಹೋವನಿಗೆ ಕೇಳಿಸುವಂತೆ ಗುಣುಗುಟ್ಟುವವರಾದರು. ಅದಕ್ಕೆ ಆತನು ಕೋಪಗೊಂಡು ಅವರ ಮಧ್ಯದಲ್ಲಿ ಬೆಂಕಿಯನ್ನು ಉಂಟುಮಾಡಿದ್ದರಿಂದ ಪಾಳೆಯದ ಕಡೇ ಭಾಗದಲ್ಲಿದ್ದವರು ಸುಟ್ಟುಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ಆಗ ಜನರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು ಮೊರೆಯಿಟ್ಟರು. ಮೋಶೆ ಅವರಿಗೋಸ್ಕರ ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಲಾಗಿ ಆ ಬೆಂಕಿ ಆರಿಹೋಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ಯೆಹೋವನು ಉಂಟುಮಾಡಿದ ಬೆಂಕಿ ಅವರ ಮಧ್ಯದಲ್ಲಿ ಉರಿದುದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ “ತಬೇರ” ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ಅವರ ಮಧ್ಯದಲ್ಲಿದ್ದ ಇತರ ಜನರು ಮಾಂಸವನ್ನು ಆಶಿಸಿದರು. ಇಸ್ರಾಯೇಲರು ಪುನಃ ಕಣ್ಣೀರಿಡುತ್ತಾ ಅಯ್ಯೋ, “ಮಾಂಸವು ನಮಗೆ ಹೇಗೆ ಸಿಕ್ಕೀತು? ");
INSERT INTO kanirv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ನಾವು ಬಿಟ್ಟಿಯಾಗಿ ತಿನ್ನುತ್ತಿದ್ದ ಮೀನು, ಸೌತೆಕಾಯಿ, ಕರ್ಬೂಜ, ಈರುಳ್ಳಿ ಹಾಗೂ ಬೆಳ್ಳುಳ್ಳಿ ಇವು ನೆನಪಿಗೆ ಬರುತ್ತವೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ಇಲ್ಲಿಯಾದರೋ ನಾವು ಬಲಹೀನರಾಗಿದ್ದೇವೆ. ಈ ಮನ್ನವೇ ಹೊರತು ನಮಗೆ ಇನ್ನೇನೂ ತಿನ್ನುವುದಕ್ಕೆ ಸಿಕ್ಕುವುದಿಲ್ಲ” ಎಂದು ನಿಷ್ಠುರವಾಗಿ ಮಾತನಾಡ ತೊಡಗಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ಆ ಮನ್ನವು ಕೊತ್ತುಂಬರಿ ಬೀಜದ ಹಾಗೆ ಇತ್ತು. ಅದು ಗುಗ್ಗುಲದಂತೆ ಕಾಣಿಸುತ್ತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ಜನರು ತಿರುಗಾಡುತ್ತಾ ಅದನ್ನು ಕೂಡಿಸಿಕೊಂಡು ಬೀಸುವ ಕಲ್ಲುಗಳಿಂದ ಬೀಸಿ, ಇಲ್ಲವೆ ಒರಳಿನಲ್ಲಿ ಕುಟ್ಟಿ ಪಾತ್ರೆಗಳಲ್ಲಿ ಬೇಯಿಸಿ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಿಕೊಂಡರು. ಅದರ ರುಚಿ ಎಣ್ಣೆ ಬೆರಸಿ ಮಾಡಿದ ಭಕ್ಷ್ಯಗಳಂತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ರಾತ್ರಿ ಕಾಲದಲ್ಲಿ ಮಂಜು ಪಾಳೆಯದಲ್ಲಿ ಬೀಳುತ್ತಿದ್ದಾಗ ಅದರೊಂದಿಗೆ ಮನ್ನವೂ ಬೀಳುತ್ತಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ಎಲ್ಲಾ ಕುಟುಂಬದವರೂ ತಮ್ಮ ತಮ್ಮ ಡೇರೆ ಬಾಗಿಲುಗಳಲ್ಲಿ ನಿಂತು ಕಣ್ಣೀರಿಟ್ಟು ಅಳುವ ಆ ಶಬ್ದವು ಮೋಶೆಗೆ ಕೇಳಿಸಿತು. ಆಗ ಯೆಹೋವನು ಬಹಳ ಕೋಪಗೊಂಡನು. ಅವರ ಗುಣುಗುಟ್ಟುವಿಕೆಯಿಂದ ಮೋಶೆಗೆ ಬೇಸರವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ಆಗ ಮೋಶೆ ಯೆಹೋವನಿಗೆ, “ಈ ಜನರನ್ನು ನಡೆಸಿಕೊಂಡು ಹೋಗುವ ಹೊಣೆಯನ್ನು ನನ್ನ ಮೇಲೆ ಹೊರಿಸಿ ನೀನು ಏಕೆ ನಿನ್ನ ದಾಸನಿಗೆ ತೊಂದರೆಯನ್ನು ತಂದಿದ್ದೀ? ನಿನ್ನ ದಯೆಗೆ ನಾನು ಯಾಕೆ ಅಪಾತ್ರನಾದೆ? ");
INSERT INTO kanirv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ನಾನು ಇವರಿಗೆ ಹೆತ್ತ ತಾಯಿಯೇ? ಇವರನ್ನು ಮಗುವನ್ನು ಎತ್ತಿಕೊಂಡು ಹೋಗುವಂತೆ, ಮಡಿಲಲ್ಲಿ ಇಟ್ಟುಕೊಂಡು ಅವರ ಪೂರ್ವಿಕರಿಗೆ ಪ್ರಮಾಣಮಾಡಿದ ದೇಶಕ್ಕೆ ನಡೆಸಬೇಕು ಎಂದು ಹೇಳುತ್ತೀಯಲ್ಲಾ? ");
INSERT INTO kanirv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ಇವರು ನನ್ನ ಬಳಿಗೆ ಅಳುತ್ತಾ ಬಂದು, ‘ಮಾಂಸವನ್ನು ನಮಗೆ ತಿನ್ನಲಿಕ್ಕೆ ಕೊಡು’ ಎಂದು ಕೇಳುತ್ತಾರಲ್ಲಾ, ಇಷ್ಟು ಜನಕ್ಕೆ ಬೇಕಾದ ಮಾಂಸವು ನನಗೆ ಎಲ್ಲಿಂದ ದೊರಕೀತು? ");
INSERT INTO kanirv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ಇಷ್ಟು ಜನರ ಹೊಣೆಯನ್ನು ನಾನೊಬ್ಬನೇ ಹೊರುವುದು ಅಸಾಧ್ಯ; ಅದು ನನ್ನ ಶಕ್ತಿಗೆ ಮೀರಿದ ಕೆಲಸ. ");
INSERT INTO kanirv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ನೀನು ಹೀಗೆ ಮಾಡುವುದಕ್ಕಿಂತ ನನ್ನನ್ನು ಈಗಲೇ ಕೊಂದುಹಾಕಿಬಿಟ್ಟರೆ ಉಪಕಾರವಾಗುತ್ತದೆ; ನನಗಾಗುತ್ತಿರುವ ದುರಾವಸ್ಥೆಯನ್ನು ನಾನು ಸಹಿಸಲಾರೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೇಂದರೆ, “ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಹಿರಿಯರೆಂದೂ ಮತ್ತು ಅಧಿಪತಿಗಳೆಂದೂ ನೀನು ತಿಳಿದುಕೊಂಡಿರುವ ಎಪ್ಪತ್ತು ಮಂದಿಯನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಕರೆದು ಅಲ್ಲಿ ನಿನ್ನೊಡನೆ ನಿಲ್ಲಿಸಿಕೋ. ");
INSERT INTO kanirv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ನಾನು ಅಲ್ಲಿಗೆ ಇಳಿದು ಬಂದು ನಿನ್ನ ಸಂಗಡ ಮಾತನಾಡುವೆನು. ಅದಲ್ಲದೆ ನಾನು ನಿನಗೆ ಅನುಗ್ರಹಿಸಿರುವ ಆತ್ಮದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಅವರಿಗೂ ಪಾಲುಕೊಡುವೆನು. ಆಗ ನೀನೊಬ್ಬನೇ ಈ ಜನರ ಹೊಣೆಯನ್ನು ವಹಿಸಬೇಕಾಗಿರುವುದಿಲ್ಲ; ನಿನ್ನ ಜೊತೆಯಲ್ಲಿ ಇವರೂ ಜವಾಬ್ದಾರಿ ವಹಿಸುವರು.” ");
INSERT INTO kanirv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ಇದಲ್ಲದೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು, “ನಾಳೆಗೆ ನಿಮ್ಮನ್ನು ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳಿರಿ; ನಾಳೆ ನಿಮಗೆ ಮಾಂಸವು ದೊರೆಯುವುದು. ನೀವು ಯೆಹೋವನಿಗೆ ಕೇಳಿಸುವಂತೆ, ‘ನಮಗೆ ಮಾಂಸವನ್ನು ಕೊಡುವವರೇ ಇಲ್ಲ; ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಎಷ್ಟೋ ಸುಖವಾಗಿದ್ದೇವಲ್ಲಾ’ ಎಂದು ಅಳುತ್ತಾ ಹೇಳಿದ್ದರಿಂದ ಯೆಹೋವನೇ ನಿಮಗೆ ಮಾಂಸವನ್ನು ತಿನ್ನಲಿಕ್ಕೆ ಕೊಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ನೀವು ತಿನ್ನುವುದು ಒಂದು ದಿನವಲ್ಲ, ಎರಡು ದಿನವಲ್ಲ, ಐದು ದಿನವಲ್ಲ, ಹತ್ತು ದಿನವಲ್ಲ, ಇಪ್ಪತ್ತು ದಿನವೂ ಅಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ಆದರೆ ನೀವು ಪೂರ್ತಿಯಾಗಿ ಒಂದು ತಿಂಗಳು ಮಾಂಸವನ್ನು ಊಟಮಾಡುವಿರಿ. ಅದು ವಾಕರಿಕೆಯಾಗಿ ನಿಮ್ಮ ಮೂಗಿನಲ್ಲಿ ಹೊರಟು ನಿಮಗೆ ಅಸಹ್ಯವಾಗುವ ತನಕ ಅದನ್ನು ಊಟಮಾಡುವಿರಿ. ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿರುವ ಯೆಹೋವನನ್ನು ನೀವು ಅಲಕ್ಷ್ಯಮಾಡಿ ಆತನ ಎದುರಿನಲ್ಲಿ ಅತ್ತು, ‘ನಾವು ಏಕೆ ಐಗುಪ್ತ ದೇಶವನ್ನು ಬಿಟ್ಟುಬಂದೆವು ಎಂದು ಹೇಳುತ್ತೀರಲ್ಲಾ’ ಎಂದು ಹೇಳು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ಅದಕ್ಕೆ ಮೋಶೆ, “ನನ್ನ ಸಂಗಡ ಇರುವ ಜನರು ಆರು ಲಕ್ಷ ಕಾಲಾಳುಗಳು, ಆದರೂ ನೀನು, ‘ಇವರಿಗೆ ಒಂದು ತಿಂಗಳು ಪೂರ್ತಿಯಾಗಿ ಮಾಂಸವನ್ನು ತಿನ್ನಲು ಕೊಡುತ್ತೇನೆ’ ಎಂದು ಹೇಳಿದ್ದೀ. ");
INSERT INTO kanirv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ಅವರಿಗೆ ಬೇಕಾದಷ್ಟು ಸಿಕ್ಕುವಂತೆ ನಾವು ಹಿಂಡಿನಿಂದ ಆಡು, ಕುರಿ, ದನಗಳನ್ನೂ ಕೊಯ್ಯಬೇಕನ್ನುತ್ತಿಯೋ? ಇಲ್ಲವೆ ಸಮುದ್ರದಲ್ಲಿರುವ ಎಲ್ಲಾ ಮೀನುಗಳನ್ನೂ ಹಿಡಿದುಕೊಳ್ಳಬೇಕೋ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನನ್ನ ಕೈ ಮೋಟುಗೈಯೋ? ನನ್ನ ಮಾತು ನೆರವೇರುತ್ತದೋ, ಇಲ್ಲವೋ ಈಗ ನೀನು ನೋಡುವಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ಮೋಶೆ ಹೊರಟುಹೋಗಿ ಯೆಹೋವನ ಮಾತುಗಳನ್ನು ಜನರಿಗೆ ತಿಳಿಸಿದನು ಮತ್ತು ಅವನು ಜನರ ಹಿರಿಯರಲ್ಲಿ ಎಪ್ಪತ್ತು ಮಂದಿಯನ್ನು ಕೂಡಿಸಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸುತ್ತಲೂ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ಯೆಹೋವನು ಆ ಮೇಘದಲ್ಲಿ ಇಳಿದು ಬಂದು ಅವನ ಸಂಗಡ ಮಾತನಾಡಿದನು. ಮೋಶೆಯ ಮೇಲಿರುವ ಆತ್ಮದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಆ ಎಪ್ಪತ್ತು ಮಂದಿ ಹಿರಿಯರಿಗೂ ಪಾಲುಕೊಟ್ಟನು. ಆ ಆತ್ಮವು ಅವರಿಗೆ ದೊರಕಿದಾಗ ಅವರು ಪರವಶರಾಗಿ ಆ ಸಂದರ್ಭದಲ್ಲಿ ಮಾತ್ರ ಪ್ರವಾದಿಸಿದರು. ಆ ಮೇಲೆ ಅವರು ಎಂದಿಗೂ ಪ್ರವಾದಿಸಲೇ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ಆದರೆ ಎಲ್ದಾದ್, ಮೇದಾದ್ ಎಂಬ ಇಬ್ಬರು ಪಾಳೆಯದೊಳಗೆ ನಿಂತಿದ್ದರು. ಅವರ ಹೆಸರುಗಳು ಬರೆಯಲ್ಪಟ್ಟಿದ್ದಾಗ್ಯೂ ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೆ ಹೋಗಲಿಲ್ಲ. ಆ ಆತ್ಮವು ಅವರ ಮೇಲೆ ಇಳಿದುಬಂದುದರಿಂದ ಅವರು ಪಾಳೆಯದೊಳಗೆ ಪರವಶರಾಗಿ ಪ್ರವಾದಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ಪಾಳೆಯದಿಂದ ಒಬ್ಬ ಹುಡುಗನು ಮೋಶೆಯ ಬಳಿಗೆ ಓಡಿ ಬಂದು, “ಎಲ್ದಾದ್ ಮತ್ತು ಮೇದಾದರು ಪಾಳೆಯದಲ್ಲಿ ಪರವಶರಾಗಿ ಪ್ರವಾದಿಸುತ್ತಿದ್ದಾರೆ” ಎಂದು ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ಮೋಶೆಯ ಶಿಷ್ಯನಾದ ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನು ಮೋಶೆಗೆ, “ಗುರುವೇ, ಅವರು ಪ್ರವಾದಿಸುವುದನ್ನು ನಿಲ್ಲಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ಅದಕ್ಕೆ ಮೋಶೆ, “ನನ್ನ ನಿಮಿತ್ತವಾಗಿ ನೀನು ಹೊಟ್ಟೆಕಿಚ್ಚುಪಡುತ್ತೀಯೋ? ಯೆಹೋವನ ಅನುಗ್ರಹದಿಂದ ಆತನ ಜನರೆಲ್ಲರೂ ಆತ್ಮವನ್ನು ಹೊಂದಿದವರೂ, ಪ್ರವಾದಿಸುವವರೂ ಆದರೆ ಎಷ್ಟೋ ಒಳ್ಳೆಯದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ತರುವಾಯ ಮೋಶೆಯೂ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರೂ ಪಾಳೆಯದೊಳಗೆ ಬಂದು ಸೇರಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ಆಗ ಯೆಹೋವನ ಬಳಿಯಿಂದ ಗಾಳಿ ಹೊರಟು ಸಮುದ್ರದಿಂದ ಲಾವಕ್ಕಿಗಳನ್ನು ಹೊಡೆದುಕೊಂಡು ಪಾಳೆಯದ ಸುತ್ತಲೂ ಒಂದು ದಿನದ ಪ್ರಯಾಣದಷ್ಟು ದೂರದವರೆಗೆ ಭೂಮಿಗಿಂತ ಎರಡು ಮೊಳ ಎತ್ತರದಲ್ಲಿ ಹಾರುತ್ತಾ ಬರುವಂತೆಮಾಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ಇಸ್ರಾಯೇಲರು ಆ ದಿನವೆಲ್ಲಾ, ರಾತ್ರಿಯೆಲ್ಲಾ, ಮರುದಿನವೆಲ್ಲಾ ಲಾವಕ್ಕಿಗಳನ್ನು ಕೂಡಿಸಿದರು. ಯಾರು ಹತ್ತು ಹೋಮೆರಿಗಿಂತ ಕಡಿಮೆ ಕೂಡಿಸಿಕೊಳ್ಳಲಿಲ್ಲ. ಅವರು ಪಾಳೆಯದ ಸುತ್ತಲೂ ಅವುಗಳನ್ನು ಹರಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ಆದರೆ ಮಾಂಸವು ಇನ್ನೂ ಅವರ ಹಲ್ಲುಗಳ ನಡುವೆ ಇದ್ದಾಗ ಅದನ್ನು ಅಗೆಯುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಜನರ ಮೇಲೆ ಯೆಹೋವನ ಕೂಪವು ಉರಿದದ್ದರಿಂದ ಆತನು ಜನರನ್ನು ಘೋರವ್ಯಾಧಿಯಿಂದ ಸಾಯಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ಆಶೆಪಟ್ಟವರನ್ನು ಅಲ್ಲಿ ಹೂಳಿಟ್ಟಿದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ “ಕಿಬ್ರೋತ್ ಹತಾವಾ” ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ತರುವಾಯ ಜನರು ಕಿಬ್ರೋತ್ ಹತಾವದಿಂದ ಪ್ರಯಾಣಮಾಡಿ ಹಚೇರೋತಿಗೆ ಬಂದು ಅಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ಮೋಶೆ ಕೂಷ್ ದೇಶದ ಸ್ತ್ರೀಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡಿದ್ದನು. ಆ ಕಾರಣಕ್ಕಾಗಿ ಮಿರ್ಯಾಮಳೂ ಹಾಗೂ ಆರೋನನೂ ಅವನಿಗೆ ವಿರುದ್ಧವಾಗಿ ಮಾತನಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ಅವರು, “ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕವಾಗಿ ಮಾತ್ರವೇ ಮಾತನಾಡುತ್ತಾನೋ? ನಮ್ಮ ಮೂಲಕ ಆತನು ಮಾತನಾಡುವುದಿಲ್ಲವೇ?” ಎಂದು ಹೇಳಿಕೊಂಡರು. ಅವರು ಆಡಿದ ಮಾತು ಯೆಹೋವನಿಗೆ ಕೇಳಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ಮೋಶೆಯು ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಮನುಷ್ಯರಿಗಿಂತಲೂ ಬಹು ಸಾತ್ವಿಕನು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ಹೀಗಿರಲಾಗಿ ಅವರು ಆಡಿದ ಮಾತನ್ನು ಯೆಹೋವನು ಕೇಳಿ ಫಕ್ಕನೆ ಮೋಶೆ, ಆರೋನ್ ಮತ್ತು ಮಿರ್ಯಾಮರಿಗೆ, “ನೀವು ಮೂರು ಮಂದಿಯೂ ದೇವದರ್ಶನದ ಗುಡಾರಕ್ಕೆ ಬರಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ಆಗ ಆ ಮೂವರು ಹೊರಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ಯೆಹೋವನು ಮೇಘಸ್ತಂಭದೊಳಗೆ ಇಳಿದು ಬಂದು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ನಿಂತು ಆರೋನನ್ನು ಮತ್ತು ಮಿರ್ಯಾಮಳನ್ನು ಹತ್ತಿರಕ್ಕೆ ಕರೆದನು. ಅವರು ಮುಂದೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ಯೆಹೋವನು ಅವರಿಗೆ, “ನನ್ನ ಮಾತನ್ನು ಕೇಳಿರಿ. ನಿಮ್ಮಲ್ಲಿ ಪ್ರವಾದಿಯಿದ್ದರೆ ನಾನು ಅವನಿಗೆ ಜ್ಞಾನದೃಷ್ಟಿಯಲ್ಲಿ ಪ್ರಕಟಿಸುವೆನು, ಮತ್ತು ಕನಸಿನಲ್ಲಿ ಅವನ ಸಂಗಡ ಮಾತನಾಡುವೆನು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ನನ್ನ ಸೇವಕನಾದ ಮೋಶೆಯು ಅಂಥವನಲ್ಲ. ಅವನು ನನ್ನ ಮನೆಯಲ್ಲೆಲ್ಲಾ ನಂಬಿಗಸ್ತನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ನಾನು ಅವನ ಸಂಗಡ ಗುಪ್ತವಾಗಿ ಅಲ್ಲ, ಮುಖಾಮುಖಿಯಾಗಿ ಅಂದರೆ ಪ್ರತ್ಯಕ್ಷವಾಗಿ ಅವನ ಸಂಗಡ ಮಾತನಾಡುತ್ತೇನೆ. ಅವನು ಯೆಹೋವನ ಸ್ವರೂಪವನ್ನೇ ದೃಷ್ಟಿಸುವನು. ಹೀಗಿರಲು ನೀವು ನನ್ನ ಸೇವಕನಾದ ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ಮಾತನಾಡುವುದಕ್ಕೆ ಏಕೆ ಭಯಪಡಲಿಲ್ಲ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ನಂತರ ಯೆಹೋವನು ಅವರ ಮೇಲೆ ಕೋಪಗೊಂಡು ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ಆ ಮೇಘವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮೇಲಿನಿಂದ ಬಿಟ್ಟುಹೋಯಿತು. ಪಕ್ಕನೆ ಮಿರ್ಯಾಮಳಿಗೆ ತೊನ್ನು ಹತ್ತಿದ್ದರಿಂದ ಆಕೆಯ ಚರ್ಮ ಹಿಮದಂತೆ ಬೆಳ್ಳಗಾಗಿ ಹೋಯಿತು. ಆರೋನನು ಮಿರ್ಯಾಮಳನ್ನು ನೋಡಿದಾಗ ಆಕೆಗೆ ತೊನ್ನು ಹಿಡಿದಿದೆ ಎಂದು ತಿಳಿದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ಆಗ ಆರೋನನು ಮೋಶೆಗೆ, “ನನ್ನ ಒಡೆಯನೇ, ನಾವು ವಿವೇಕವಿಲ್ಲದೆ ನಡೆದು ದೋಷಿಗಳಾದೆವು. ಈ ದೋಷದ ಫಲವನ್ನು ನಾವು ಅನುಭವಿಸುವಂತೆ ಮಾಡಬೇಡ ಎಂದು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ಅರ್ಧ ಮಾಂಸ ಕೊಳೆತುಹೋಗಿ ಹುಟ್ಟಿದ ಶಿಶುವಿನಂತೆ ಈಕೆ ಆಗಬಾರದು” ಎಂದು ಬೇಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ಆಗ ಮೋಶೆ ಯೆಹೋವನಿಗೆ, “ದೇವಾ, ಆಕೆಯನ್ನು ವಾಸಿಮಾಡಬೇಕೆಂದು ಬೇಡುತ್ತೇನೆ” ಎಂದು ಮೊರೆಯಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ಅದಕ್ಕೆ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಆಕೆಯ ತಂದೆ ಆಕೆಯ ಮುಖದ ಮೇಲೆ ಉಗುಳಿದರೆ, ಆಕೆ ಏಳು ದಿನ ನಾಚಿಕೆಯಿಂದ ಮರೆಯಾಗುತ್ತಿದ್ದಳಲ್ಲವೇ? ಹಾಗಾದರೆ ಆಕೆ ಏಳು ದಿನ ಪಾಳೆಯದ ಹೊರಗೆ ಇರಲಿ, ತರುವಾಯ ನೀನು ಆಕೆಯನ್ನು ಪಾಳೆಯದೊಳಗೆ ಸೇರಿಸಿಕೊಳ್ಳಬಹುದು” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ಹಾಗೆಯೇ ಮಿರ್ಯಾಮಳು ಏಳು ದಿನಗಳವರೆಗೆ ಪಾಳೆಯದ ಹೊರಗೆ ಇರಬೇಕಾಯಿತು. ಆಕೆಯನ್ನು ತಿರುಗಿ ಸೇರಿಸಿಕೊಳ್ಳುವ ವರೆಗೆ ಇಸ್ರಾಯೇಲರು ಪ್ರಯಾಣಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ತರುವಾಯ ಅವರು ಹಚೇರೋತಿನಿಂದ ಹೊರಟು ಪಾರಾನ್ ಅರಣ್ಯದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ ಕೊಡುವ ಕಾನಾನ್ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕೆ ನೀನು ಒಂದೊಂದು ಕುಲದಿಂದ ಒಬ್ಬೊಬ್ಬ ಮುಖ್ಯಸ್ಥನನ್ನು ಕಳುಹಿಸಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆ ಪಾರಾನ್ ಅರಣ್ಯದಿಂದ ಇಸ್ರಾಯೇಲರ ಮುಖ್ಯಸ್ಥರನ್ನು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ಅವರ ಹೆಸರುಗಳು ಯಾವುವೆಂದರೆ: ರೂಬೇನ್ ಕುಲದ ಜಕ್ಕೂರನ ಮಗನಾದ ಶಮ್ಮೂವ, ");
INSERT INTO kanirv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ಸಿಮೆಯೋನ್ ಕುಲದ ಹೋರಿಯನ ಮಗನಾದ ಶಾಫಾಟ್, ");
INSERT INTO kanirv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ಯೆಹೂದ ಕುಲದ ಯೆಫುನ್ನೆಯನ ಮಗನಾದ ಕಾಲೇಬ್, ");
INSERT INTO kanirv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ಇಸ್ಸಾಕಾರ್ ಕುಲದ ಯೋಸೇಫನ ಮಗನಾದ ಇಗಾಲ್, ");
INSERT INTO kanirv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ಎಫ್ರಾಯೀಮ್ ಕುಲದ ನೂನನ ಮಗನಾದ ಹೋಶೇಯ, ");
INSERT INTO kanirv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ಬೆನ್ಯಾಮೀನ್ ಕುಲದ ರಾಫೂವನ ಮಗನಾದ ಪಲ್ಟೀ, ");
INSERT INTO kanirv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ಜೆಬುಲೂನ್ ಕುಲದ ಸೋದೀಯನ ಮಗನಾದ ಗದ್ದೀಯೇಲ್, ");
INSERT INTO kanirv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ಯೋಸೇಫ್ ಅಂದರೆ ಮನಸ್ಸೆ ಕುಲದ ಸೂಸೀಯನ ಮಗನಾದ ಗದ್ದೀ, ");
INSERT INTO kanirv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ದಾನ್ ಕುಲದ ಗೆಮಲ್ಲೀಯನ ಮಗನಾದ ಅಮ್ಮೀಯೇಲ್, ");
INSERT INTO kanirv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ಆಶೇರ್ ಕುಲದ ಮೀಕಾಯೇಲನ ಮಗನಾದ ಸೆತೂರ್, ");
INSERT INTO kanirv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ನಫ್ತಾಲಿ ಕುಲದ ವಾಪೆಸೀಯನ ಮಗನಾದ ನಹಬೀ, ");
INSERT INTO kanirv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ಗಾದ್ ಕುಲದ ಮಾಕೀಯನ ಮಗನಾದ ಗೆಯೂವೇಲ್. ");
INSERT INTO kanirv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕೆ ಮೋಶೆ ಕಳುಹಿಸಿದ ಮನುಷ್ಯರ ಹೆಸರುಗಳು ಇವೇ. ಮೋಶೆ ನೂನನ ಮಗನಾದ ಹೋಶೇಯನಿಗೆ ಯೆಹೋಶುವನೆಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕೆ ಮೋಶೆ ಅವರನ್ನು ಕಳುಹಿಸುವಾಗ ಅವರಿಗೆ, “ನೀವು ಕಾನಾನ್ ದೇಶದ ದಕ್ಷಿಣ ಪ್ರಾಂತ್ಯದ ಮಾರ್ಗವಾಗಿ ಬೆಟ್ಟದ ಸೀಮೆಗೆ ಹತ್ತಿಹೋಗಿ ಆ ದೇಶದ ಸಂಗತಿಯನ್ನೆಲ್ಲಾ ನೋಡಿ ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ಅಲ್ಲಿನ ನಿವಾಸಿಗಳು ಬಲಿಷ್ಠರೋ ಅಥವಾ ಬಲಹೀನರೋ, ಬಹಳ ಜನರೋ ಅಥವಾ ಸ್ವಲ್ಪ ಜನರೋ, ");
INSERT INTO kanirv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ಅವರ ದೇಶವು ಒಳ್ಳೆಯದೋ ಅಥವಾ ಕೆಟ್ಟದ್ದೋ? ಅವರ ಪಟ್ಟಣಗಳು ಪಾಳೆಯಗಳೋ ಅಥವಾ ಕೋಟೆಗಳೋ? ");
INSERT INTO kanirv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ಭೂಮಿಯು ಸಾರವಾದುದೋ ಅಥವಾ ನಿಸ್ಸಾರವಾದುದೋ, ಮರಗಳುಳ್ಳದ್ದೋ ಅಥವಾ ಬಯಲುಪ್ರದೇಶವೋ ಎಂದು ನೋಡಿ ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ಅದಲ್ಲದೆ ನೀವು ಧೈರ್ಯವುಳ್ಳವರಾಗಿದ್ದು ಆ ದೇಶದ ಉತ್ಪನ್ನಗಳಲ್ಲಿ ಕೆಲವನ್ನು ತರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ಆಗ ದ್ರಾಕ್ಷಾಲತೆಗಳ ಪ್ರಥಮ ಫಲದ ಕಾಲವಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ಅವರು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಚಿನ್ ಅರಣ್ಯದಿಂದ ಹಮಾತಿನ ದಾರಿಯಲ್ಲಿರುವ ರೆಹೋಬಿನ ವರೆಗೆ ಆ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ಅವರು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಕಾನಾನ್ ದೇಶದ ದಕ್ಷಿಣ ಪ್ರಾಂತ್ಯವನ್ನು ದಾಟಿ ಹೆಬ್ರೋನಿಗೆ ಬಂದರು. ಅಲ್ಲಿ ಅಹೀಮನ್, ಶೇಷೈ, ತಲ್ಮೈ ಎಂಬ ಉನ್ನತ ಪುರುಷರು ಇದ್ದರು. ಹೆಬ್ರೋನ್ ಪಟ್ಟಣವು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿರುವ ಚೋವನ್ ಪಟ್ಟಣಕ್ಕಿಂತ ಏಳು ವರ್ಷ ಮೊದಲು ನಿರ್ಮಿಸಲಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ಅವರು ಎಷ್ಕೋಲ್ ಎಂಬ ತಗ್ಗಿಗೆ ಬಂದು ಅಲ್ಲಿ ದ್ರಾಕ್ಷಾಲತೆಯಿಂದ ಒಂದೇ ಗೊಂಚಲುಳ್ಳ ಕೊಂಬೆಯನ್ನು ಕೊಯ್ದರು; ಇಬ್ಬರು ಅದನ್ನು ಅಡ್ಡಕೋಲಿನಿಂದ ಹೊತ್ತುಕೊಂಡು ಬಂದರು. ಕೆಲವು ದಾಳಿಂಬೆ ಮತ್ತು ಅಂಜೂರದ ಹಣ್ಣುಗಳನ್ನೂ ತಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ಇಸ್ರಾಯೇಲರು ಅಲ್ಲಿ ಆ ದ್ರಾಕ್ಷಿಯ ಗೊಂಚಲನ್ನು ಕೊಯ್ದದ್ದರಿಂದಲೇ ಆ ಸ್ಥಳಕ್ಕೆ “ಎಷ್ಕೋಲ್” ಎಂದು ಹೆಸರು ಉಂಟಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ಅವರು ನಲ್ವತ್ತು ದಿನಗಳು ಆ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ಆ ಮೇಲೆ ಪಾರಾನ್ ಅರಣ್ಯದಲ್ಲಿದ್ದ ಮೋಶೆ, ಆರೋನರು ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರ ಬಳಿಗೆ ಕಾದೇಶಿಗೆ ಬಂದು ಅವರಿಗೆ ಸಮಾಚಾರವನ್ನು ತಿಳಿಸಿ ಆ ದೇಶದ ಹಣ್ಣುಗಳನ್ನು ತೋರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ಅವರು ಮೋಶೆಗೆ, “ನೀನು ನಮ್ಮನ್ನು ಕಳುಹಿಸಿದ ದೇಶಕ್ಕೆ ಹೋದೆವು; ಅದು ನಿಜವಾಗಿಯೂ ಹಾಲೂ ಮತ್ತು ಜೇನೂ ಹರಿಯುವ ದೇಶವೇ; ಅಲ್ಲಿನ ಹಣ್ಣುಗಳು ಇಂಥವು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ಆದರೆ ಆ ದೇಶದ ನಿವಾಸಿಗಳು ಬಲಿಷ್ಠರು: ಅವರಿರುವ ಪಟ್ಟಣಗಳು ದೊಡ್ಡದಾಗಿಯೂ, ಕೋಟೆ ಕೊತ್ತಲುಗಳುಳ್ಳದ್ದಾಗಿಯೂ ಇದೆ. ಅದಲ್ಲದೆ ಅಲ್ಲಿ ಉನ್ನತ ಪುರುಷರನ್ನು ನೋಡಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ದಕ್ಷಿಣ ಸೀಮೆಯಲ್ಲಿ ಅಮಾಲೇಕ್ಯರು, ಬೆಟ್ಟದ ಸೀಮೆಯಲ್ಲಿ ಹಿತ್ತಿಯರು, ಯೆಬೂಸಿಯರು, ಅಮೋರಿಯರು ಸಮುದ್ರತೀರದಲ್ಲಿ ಮತ್ತು ಯೊರ್ದನ್ ಹೊಳೆಯ ಬಳಿಯಲ್ಲಿ ಕಾನಾನ್ಯರೂ ವಾಸವಾಗಿದ್ದಾರೆ” ಎಂದು ತಿಳಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ಇಸ್ರಾಯೇಲರು ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ಗುಣುಗುಟ್ಟಿದರು. ಕಾಲೇಬನು ಅವರನ್ನು ಸುಮ್ಮನಿರಿಸಿ, “ನಾವು ನಿರ್ಭಯವಾಗಿ ಆ ಬೆಟ್ಟದ ಸೀಮೆಗೆ ಹತ್ತಿಹೋಗಿ ಅದನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳೋಣ. ಅದನ್ನು ಜಯಿಸಲು ನಾವು ಶಕ್ತರಾಗಿದ್ದೇವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ಆದರೆ ಅವನ ಜೊತೆಯಲ್ಲಿ ಹೋದವರು, “ಆ ಜನರು ನಮಗಿಂತ ಬಲಿಷ್ಠರು; ಅವರನ್ನು ಜಯಿಸಲು ನಮಗೆ ಶಕ್ತಿಸಾಲುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ಅದಲ್ಲದೆ ಇವರು ತಾವು ಸಂಚರಿಸಿ ನೋಡಿದ ದೇಶದ ವಿಷಯವಾಗಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಅಶುಭ ಸಮಾಚಾರವನ್ನು ಹೇಳುವವರಾಗಿ, “ನಾವು ಸಂಚರಿಸಿ ನೋಡಿದ ದೇಶವು ತನ್ನಲ್ಲಿ ವಾಸಿಸುವವರನ್ನು ನುಂಗಿಬಿಡುತ್ತದೆ. ಅದಲ್ಲದೆ ನಾವು ಅದರಲ್ಲಿ ನೋಡಿದ ಜನರೆಲ್ಲರೂ ಬಹಳ ಎತ್ತರವಾದವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ಅಲ್ಲಿ ನೆಫೀಲಿಯರನ್ನು ಅಂದರೆ ನೆಫೀಲಿಯ ವಂಶದವರಾದ ಉನ್ನತ ಪುರುಷರನ್ನು ನೋಡಿದೆವು. ನಾವು ಅವರ ಮುಂದೆ ಮಿಡತೆಗಳಂತೆ ಇದ್ದೇವೆ ಎಂದು ತಿಳಿದುಕೊಂಡೆವು. ಅವರಿಗೂ ನಾವು ಹಾಗೆಯೇ ಕಾಣಿಸಿದೆವು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ಆಗ ಜನಸಮೂಹದವರೆಲ್ಲರೂ ತಮ್ಮ ಸ್ವರ ಎತ್ತಿ ಆ ರಾತ್ರಿಯೆಲ್ಲಾ ಗೋಳಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಗುಣುಗುಟ್ಟಿ, “ನಾವು ಈ ಮರುಭೂಮಿಯಲ್ಲಿ ಸಾಯುವುದಕ್ಕಿಂತ ಐಗುಪ್ತ ದೇಶದಲ್ಲಿಯೇ ಸತ್ತಿದ್ದರೆ ಎಷ್ಟೋ ಒಳ್ಳೆಯದಾಗಿತ್ತು ");
INSERT INTO kanirv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ಯೆಹೋವನು ನಮ್ಮನ್ನು ಯಾಕೆ ಕತ್ತಿಯ ಬಾಯಿಂದ ಸಾಯಿಸುವುದಕ್ಕೆ ಈ ದೇಶಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ನಮ್ಮ ಹೆಂಡತಿಯರು ಮತ್ತು ಮಕ್ಕಳು ಬೇರೆಯವರ ಪಾಲಾಗುವರು. ನಾವು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ತಿರುಗಿ ಹೋಗುವುದು ಒಳ್ಳೆಯದಲ್ಲವೇ” ಎಂದು ಮಾತನಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ಹೀಗೆ ಅವರು ಒಬ್ಬರ ಸಂಗಡಲೊಬ್ಬರು, “ನಾವು ಬೇರೆ ನಾಯಕನನ್ನು ನೇಮಿಸಿಕೊಂಡು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಹಿಂತಿರುಗಿ ಹೋಗೋಣ” ಎಂದು ಮಾತನಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ಆಗ ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರ ಮುಂದೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ಕಾನಾನ್ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿದವರಲ್ಲಿ ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನು ಮತ್ತು ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬನೂ ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ಅವರು ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರಿಗೆ ಹೀಗೆ ಹೇಳಿದರು, “ನಾವು ಸಂಚರಿಸಿ ನೋಡಿದ ದೇಶವು ಅತ್ಯುತ್ತಮವಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ಯೆಹೋವನು ನಮ್ಮನ್ನು ಮೆಚ್ಚಿಕೊಂಡರೆ ಹಾಲೂ, ಜೇನೂ ಹರಿಯುವ ಆ ದೇಶಕ್ಕೆ ನಮ್ಮನ್ನು ಸೇರಿಸಿ ಅದನ್ನು ನಮ್ಮ ಸ್ವಾಧೀನಕ್ಕೆ ಕೊಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ಹೀಗಿರುವುದರಿಂದ ಯೆಹೋವನಿಗೆ ತಿರುಗಿಬೀಳಬೇಡಿರಿ. ಇದಲ್ಲದೆ ಆ ದೇಶದ ಜನರಿಗೆ ಭಯಪಡಬೇಡಿರಿ. ಏಕೆಂದರೆ ನಾವು ಅವರನ್ನು ಸುಲಭವಾಗಿ ಜಯಿಸಿಬಿಡುವೆವು. ಅವರಿಗೆ ನೆರಳಾಗಿದ್ದ ದೇವರು ಅವರನ್ನು ಕೈಬಿಟ್ಟಿದ್ದಾನೆ, ಯೆಹೋವನು ನಮ್ಮ ಸಂಗಡ ಇದ್ದಾನೆ. ಅವರಿಗೆ ಭಯಪಡಬೇಡಿರಿ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ಆದರೆ ಜನಸಮೂಹದವರೆಲ್ಲರೂ ಅವರ ಮಾತುಗಳನ್ನು ಕೇಳದೆ, ಅವರನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕೆಂದು ಹೇಳಿಕೊಳ್ಳುತ್ತಿರುವಾಗ, ಯೆಹೋವನ ತೇಜಸ್ಸು ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಪ್ರಕಾಶಿಸಿ ಇಸ್ರಾಯೇಲರೆಲ್ಲರಿಗೂ ಕಾಣಿಸಿಕೊಂಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಈ ಜನರು ಇನ್ನು ಎಷ್ಟರವರೆಗೆ ನನ್ನನ್ನು ಅಲಕ್ಷ್ಯಮಾಡುವರು? ನಾನು ನಡೆಸಿದ ಎಲ್ಲಾ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ಇವರು ಪ್ರತ್ಯಕ್ಷವಾಗಿ ನೋಡಿದಾಗ್ಯೂ ಇನ್ನು ಎಷ್ಟು ದಿನ ನನ್ನನ್ನು ನಂಬದೆ ಇರುವರು? ");
INSERT INTO kanirv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ನಾನು ಇವರಿಗೆ ವ್ಯಾಧಿಯನ್ನು ಉಂಟುಮಾಡಿ ಇವರನ್ನು ನಿರ್ಮೂಲಮಾಡುವೆನು. ಈ ಜನರಿಗಿಂತ ನಿನ್ನನ್ನು ದೊಡ್ಡದಾಗಿಯೂ, ಬಲಿಷ್ಠವಾಗಿಯೂ ಇರುವ ಜನಾಂಗವಾಗುವಂತೆ ಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ಅದಕ್ಕೆ ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, “ನೀನು ಹೀಗೆ ಮಾಡುವುದಾದರೆ ಐಗುಪ್ತ್ಯರು ಈ ಸುದ್ದಿಯನ್ನು ಕೇಳುವರು. ಅವರ ಕೈಯಿಂದ ನೀನು ಈ ಜನರನ್ನು ಭುಜಪರಾಕ್ರಮದಿಂದ ಬಿಡಿಸಿದ ಈ ಸಂಗತಿಯನ್ನು ಈ ಕಾನಾನ್ ದೇಶದ ನಿವಾಸಿಗಳಿಗೆ ತಿಳಿಸುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ಅಲ್ಲದೆ ಯೆಹೋವನಾದ ನೀನು ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ಇರುವ ಸಂಗತಿಯನ್ನು, ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಪ್ರತ್ಯಕ್ಷವಾಗಿ ಕಾಣಿಸಿಕೊಳ್ಳುವುದನ್ನು, ಹಗಲಿನಲ್ಲಿ ಮೇಘಸ್ತಂಭದಲ್ಲಿಯೂ, ರಾತ್ರಿಯಲ್ಲಿ ಅಗ್ನಿಸ್ತಂಭದಲ್ಲಿಯೂ ಇದ್ದು ಇವರ ಮುಂದೆ ನಡೆದುಹೋಗುವುದಾಗಿ ಹಾಗೂ ನೀನಿರುವ ಮೇಘವು ಇಸ್ರಾಯೇಲರ ಮೇಲೆ ಇರುವುದಾಗಿಯೂ ಈ ದೇಶದವರು ಕೇಳಿದ್ದಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ಹೀಗಿರಲಾಗಿ ನೀನು ಒಂದೇ ಪೆಟ್ಟಿನಿಂದ ಈ ಜನರನ್ನೆಲ್ಲಾ ಸಾಯಿಸಿದರೆ ನಿನ್ನ ಪ್ರಖ್ಯಾತಿಯನ್ನು ಕೇಳಿದ ಜನಾಂಗದವರು ನಿನ್ನ ವಿಷಯದಲ್ಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“‘ಯೆಹೋವನು ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನಮಾಡಿದ ದೇಶದಲ್ಲಿ ಆ ಜನರನ್ನು ಸೇರಿಸುವುದಕ್ಕೆ ಶಕ್ತಿಸಾಲದೆ, ಅವರನ್ನು ಅರಣ್ಯದಲ್ಲಿ ಕೊಂದುಹಾಕಿಬಿಟ್ಟನು’ ಎಂದು ಮಾತನಾಡಿಕೊಳ್ಳುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ಈಗ ನೀನು ಹೇಳಿದ ಪ್ರಕಾರ ಯೆಹೋವನ ಬಲವು ದೊಡ್ಡದಾಗಿರಲಿ ಎಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ. ನಿನ್ನ ವಿಷಯದಲ್ಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘ಯೆಹೋವನು ದೀರ್ಘಶಾಂತನು, ದಯೆಯುಳ್ಳವನು, ಅಪರಾಧ ಪಾಪಗಳನ್ನು ಕ್ಷಮಿಸುವವನು, ಆದರೂ ಅಪರಾಧಿಗಳನ್ನು ಶಿಕ್ಷಿಸದೆ ಬಿಡದವನು, ತಂದೆಗಳ ಪಾಪಫಲವನ್ನು ಮಕ್ಕಳ ಮೇಲೆ ಮೂರು ನಾಲ್ಕು ತಲೆಗಳವರೆಗೆ ಬರಮಾಡುವವನು’ ಎಂದು ಹೇಳಿದ್ದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ನಾವು ಐಗುಪ್ತ ದೇಶದಿಂದ ಬಂದ ದಿನದಿಂದ ಮೊದಲುಗೊಂಡು ಇದುವರೆಗೆ ನೀನು ಈ ಜನರ ಪಾಪಗಳನ್ನು ಕ್ಷಮಿಸಿದ ಪ್ರಕಾರವೇ ಈಗಲೂ ಮಹಾಕೃಪೆಯಿಂದ ಇವರ ಪಾಪವನ್ನು ಕ್ಷಮಿಸಬೇಕೆಂದು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ” ಎಂದು ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ಅದಕ್ಕೆ ಯೆಹೋವನು, “ನಿನ್ನ ಪ್ರಾರ್ಥನೆಯ ಮೇರೆಗೆ ನಾನು ಅವರನ್ನು ಕ್ಷಮಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ಆದರೆ ನನ್ನ ಜೀವದಾಣೆ, ಯೆಹೋವನ ಮಹಿಮೆಯು ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ತುಂಬಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ಈ ಮನುಷ್ಯರೆಲ್ಲರು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿಯೂ, ಮರುಭೂಮಿಯಲ್ಲಿಯೂ, ನಾನು ನಡೆಸಿರುವ ಮಹತ್ಕಾರ್ಯಗಳನ್ನೂ, ನನ್ನ ಮಹಿಮೆಯನ್ನೂ ನೋಡಿದರೂ ನನ್ನ ಮಾತಿಗೆ ಕಿವಿಗೊಡದೆ, ಪದೇ ಪದೇ ನನ್ನನ್ನು ಪರೀಕ್ಷಿಸಿದ್ದರಿಂದ ");
INSERT INTO kanirv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ನಾನು ಅವರ ಪೂರ್ವಿಕರಿಗೆ ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶವನ್ನು ಇವರಲ್ಲಿ ಯಾರೂ ನೋಡುವುದಿಲ್ಲ; ನನ್ನನ್ನು ಅಲಕ್ಷ್ಯಮಾಡಿದ ಇವರಲ್ಲಿ ಯಾರೂ ಅದನ್ನು ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ನನ್ನ ದಾಸನಾದ ಕಾಲೇಬನಿಗೆ ಅವರಂಥ ಮನಸ್ಸುಳ್ಳವನಾಗಿರದೆ ಮನಃಪೂರ್ವಕವಾಗಿ ನನ್ನ ಮಾತನ್ನು ಅನುಸರಿಸಿ ನಡೆದುದ್ದರಿಂದ ಅವನು ಸಂಚರಿಸಿದ ಆ ದೇಶದಲ್ಲಿ ಅವನನ್ನು ಸೇರಿಸುವೆನು, ಅವನ ಸಂತತಿಯವರು ಅದನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ಅಮಾಲೇಕ್ಯರೂ, ಕಾನಾನ್ಯರೂ ಆ ತಗ್ಗಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾರೆ. ನೀವು ನಾಳೆ ಹಿಂದಿರುಗಿ ಕೆಂಪು ಸಮುದ್ರಕ್ಕೆ ಹೋಗುವ ದಾರಿಯಲ್ಲಿ ಅರಣ್ಯಕ್ಕೆ ಪ್ರಯಾಣಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ನನಗೆ ವಿರುದ್ಧವಾಗಿ ಗುಣುಗುಟ್ಟುವ ಈ ದುಷ್ಟ ಸಮೂಹದವರನ್ನು ನಾನು ಎಷ್ಟು ದಿನ ಸಹಿಸಿಕೊಳ್ಳಲಿ? ಇಸ್ರಾಯೇಲರು ನನಗೆ ವಿರುದ್ಧವಾಗಿ ಗುಣುಗುಟ್ಟುವ ಮಾತುಗಳು ನನಗೆ ಕೇಳಿಸಿದವು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ನೀನು ಅವರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು, ‘ಯೆಹೋವನು ಹೇಳುವುದೇನೆಂದರೆ, ನನ್ನ ಜೀವದಾಣೆ, ನೀವು ನನಗೆ ಕೇಳಿಸುವಂತೆ ಅಂದುಕೊಂಡ ಪ್ರಕಾರವೇ ನಾನು ಮಾಡುತ್ತೇನೆ; ನಿಮ್ಮ ಶವಗಳು ಈ ಅರಣ್ಯದಲ್ಲಿಯೇ ಬೀಳುವವು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ನೀವು ನನಗೆ ವಿರುದ್ಧವಾಗಿ ಗುಣುಗುಟ್ಟಿದ್ದರಿಂದ ನಿಮ್ಮಲ್ಲಿ ಎಣಿಕೆಯಾದವರೆಲ್ಲರು ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷಕ್ಕಿಂತ ಹೆಚ್ಚು ವಯಸ್ಸುಳ್ಳವರೆಲ್ಲರೂ ಅರಣ್ಯದಲ್ಲಿಯೇ ಸಾಯುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬನು ಮತ್ತು ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನು ಇವರಿಬ್ಬರೇ ಹೊರತು ನಿಮ್ಮಲ್ಲಿ ಯಾರೂ ನಿಮ್ಮ ವಾಸಕ್ಕಾಗಿ ನಾನು ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನಮಾಡಿದ ದೇಶವನ್ನು ಸೇರುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ಆದರೆ ಇತರರ ಪಾಲಾಗುವರೆಂದು ನೀವು ಹೇಳಿದ ನಿಮ್ಮ ಚಿಕ್ಕ ಮಕ್ಕಳನ್ನು ಅಲ್ಲಿಗೆ ಸೇರಿಸುವೆನು. ನೀವು ಬೇಡವೆಂದು ಹೇಳಿದ ದೇಶವನ್ನು ಅವರು ಅನುಭವಿಸುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ನೀವಂತೂ ಈ ಅರಣ್ಯದಲ್ಲಿ ಸಾಯುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ನಿಮ್ಮೆಲ್ಲರ ಶವಗಳು ಈ ಮರುಭೂಮಿಯಲ್ಲಿ ಬೀಳುವವರೆಗೂ ನೀವು ಮಾಡಿದ ದ್ರೋಹದ ಫಲವನ್ನು ನಿಮ್ಮ ಮಕ್ಕಳು ಅನುಭವಿಸುವವರಾಗಿ ನಲ್ವತ್ತು ವರ್ಷ ಮರುಭೂಮಿಯಲ್ಲಿ ವಾಸಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ನೀವು ಆ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿದ ನಲ್ವತ್ತು ದಿನಗಳ ಪ್ರಕಾರ, ಒಂದು ದಿನಕ್ಕೆ ಒಂದು ವರ್ಷವಾಗಿ ಈ ಪ್ರಕಾರ ನಲ್ವತ್ತು ವರ್ಷ ನಿಮ್ಮ ಪಾಪಫಲವನ್ನು ಅನುಭವಿಸುವವರಾಗಿ ನಾನು ಕೈಬಿಟ್ಟವರ ಗತಿ ಎಂಥದೆಂದು ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ಇದು ಯೆಹೋವನೆಂಬ ನಾನೇ ಹೇಳಿದ ಮಾತು. ನನಗೆ ವಿರುದ್ಧವಾಗಿ ಸೇರಿರುವ ಈ ದುಷ್ಟ ಸಮೂಹದವರೆಲ್ಲರಿಗೆ ಈ ಮಾತಿನ ಪ್ರಕಾರವೇ ಮಾಡುತ್ತೇನೆ. ಈ ಅರಣ್ಯದಲ್ಲಿಯೇ ಇವರೆಲ್ಲರೂ ಸಾಯಬೇಕು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ಆ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕೆ ಮೋಶೆಯಿಂದ ಕಳುಹಿಸಲ್ಪಟ್ಟ ಮನುಷ್ಯರು ಹಿಂದಿರುಗಿ ಬಂದು ಆ ದೇಶದ ವಿಷಯದಲ್ಲಿ ಅಶುಭ ಸಮಾಚಾರವನ್ನು ಹೇಳಿ ಸರ್ವಸಮೂಹದವರನ್ನು ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ಗುಣುಗುಟ್ಟುವಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ಅಶುಭ ಸಮಾಚಾರವನ್ನು ತಂದ ಆ ಮನುಷ್ಯರು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ವ್ಯಾಧಿಯಿಂದ ಸತ್ತರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ಆ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕೆ ಹೋಗಿದ್ದ ಮನುಷ್ಯರಲ್ಲಿ ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನು ಮತ್ತು ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬನು ಮಾತ್ರ ಉಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ಮೋಶೆ ಯೆಹೋವನ ಮಾತುಗಳನ್ನೆಲ್ಲಾ ಇಸ್ರಾಯೇಲರಿಗೆ ತಿಳಿಸಲಾಗಿ ಅವರು ಬಹಳ ದುಃಖಪಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ಮರುದಿನ ಬೆಳಿಗ್ಗೆ ಜನರು ಎದ್ದು, “ನಾವು ಪಾಪ ಮಾಡಿರುವುದು ನಿಜ; ಯೆಹೋವನು ವಾಗ್ದಾನ ಮಾಡಿದ ಸ್ಥಳಕ್ಕೆ ಹತ್ತೋಣ ಬನ್ನಿ” ಎಂದು ಹೇಳಿಕೊಳ್ಳುತ್ತಾ ಆ ಬೆಟ್ಟದ ಮೇಲಕ್ಕೆ ಹತ್ತಿಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ಆದರೆ ಮೋಶೆ ಅವರಿಗೆ, “ನೀವು ಯಾಕೆ ಹೀಗೆ ಮಾಡಿ ಯೆಹೋವನ ಆಜ್ಞೆಯನ್ನು ಮೀರುತ್ತೀರಿ? ಇದು ಸಫಲವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ಯೆಹೋವನು ನಿಮ್ಮ ಸಂಗಡ ಇರುವುದಿಲ್ಲ, ಹತ್ತಬೇಡಿರಿ. ನೀವು ಶತ್ರುಗಳ ಮುಂದೆ ನಿಲ್ಲಲಾರದೆ ಬಿದ್ದು ಸತ್ತುಹೋಗುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ಅಲ್ಲಿ ಅಮಾಲೇಕ್ಯರೂ, ಕಾನಾನ್ಯರೂ ನಿಮ್ಮ ಎದುರಿನಲ್ಲಿ ಇರುವುದರಿಂದ ನೀವು ಅವರ ಕತ್ತಿಯಿಂದ ಸತ್ತುಹೋಗುವಿರಿ. ನೀವು ಯೆಹೋವನ ಮಾತನ್ನು ಅನುಸರಿಸದೆ ತಿರುಗಿಬಿದ್ದ ಕಾರಣ ಆತನು ನಿಮ್ಮೊಂದಿಗೆ ಇರುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ಆದರೂ ಅವರು ಹಟಮಾಡಿ ಆ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿದರು. ಯೆಹೋವನ ಒಡಂಬಡಿಕೆಯ ಮಂಜೂಷವಾಗಲಿ ಮೋಶೆಯಾಗಲಿ ಪಾಳೆಯವನ್ನು ಬಿಟ್ಟು ಹೊರಡಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ಆಗ ಆ ಬೆಟ್ಟದ ಸೀಮೆಯಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಅಮಾಲೇಕ್ಯರೂ ಮತ್ತು ಕಾನಾನ್ಯರೂ ಇಳಿದು ಬಂದು ಇಸ್ರಾಯೇಲರನ್ನು ಹೊಡೆದು ಹೊರ್ಮಾ ಪಟ್ಟಣದವರೆಗೂ ಬೆನ್ನಟ್ಟಿ ಸಂಹರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ನಾನು ನಿಮ್ಮ ವಾಸಕ್ಕಾಗಿ ಕೊಡುವ ದೇಶಕ್ಕೆ ನೀವು ಸೇರಿದ ನಂತರ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕಾಗಿ ಪಶುಗಳಿಂದಾಗಲಿ, ಆಡುಕುರಿ ಹಿಂಡುಗಳಿಂದಾಗಲಿ ಒಂದು ಪಶುವನ್ನು ಹೋಮಮಾಡುವವನು, ಸರ್ವಾಂಗಹೋಮ ಮಾಡುವುದಕ್ಕೂ, ಹರಕೆಸಲ್ಲಿಸುವುದಕ್ಕೂ, ಕೃತಜ್ಞತೆಯನ್ನು ತೋರಿಸುವುದಕ್ಕೂ, ಹಬ್ಬವನ್ನು ಆಚರಿಸುವುದಕ್ಕೂ ಸಮಾಧಾನಯಜ್ಞಮಾಡಿದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ಅದರೊಂದಿಗೆ ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಧಾನ್ಯನೈವೇದ್ಯ ಸಮರ್ಪಿಸುವಾಗ ಒಂದುವರೆ ಸೇರು ಎಣ್ಣೆ ಬೆರಸಿದ ಮೂರು ಸೇರು ಗೋದಿಯ ಹಿಟ್ಟನ್ನೂ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ಪಾನದ್ರವ್ಯಕ್ಕಾಗಿ ಒಂದುವರೆ ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ತರಬೇಕು. ನೀವು ಸರ್ವಾಂಗಹೋಮ ಅಥವಾ ಸಮಾಧಾನಯಜ್ಞವಾಗಿ ಕಾಣಿಕೆಯಾಗಿ ಒಂದೊಂದು ಕುರಿಯೊಂದಿಗೂ ದಹನ ಬಲಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“‘ಇದಲ್ಲದೆ ಟಗರಿನೊಂದಿಗೆ ಯೆಹೋವನಿಗೆ ಪರಿಮಳವನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕೆ, ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎರಡು ಸೇರು ಎಣ್ಣೆ ಬೆರಸಿದ ಆರು ಸೇರು ಗೋದಿಯ ಹಿಟ್ಟನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ಪಾನದ್ರವ್ಯವಾಗಿ ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯಾಗಿ ಎರಡು ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“‘ನೀನು ಸರ್ವಾಂಗಹೋಮ, ಹರಕೆಸಲ್ಲಿಸುವ ಯಜ್ಞ, ಬೇರೆ ವಿಧವಾದ ಸಮಾಧಾನಯಜ್ಞ ಇವುಗಳಿಗಾಗಿ ಹೋರಿಯನ್ನು ಯೆಹೋವನಿಗೆ ದಹನ ಬಲಿಗಾಗಿ ಸಿದ್ಧಮಾಡುವಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ಅವನು ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಮೂರು ಸೇರು ಎಣ್ಣೆ ಬೆರಸಿದ ಒಂಭತ್ತು ಸೇರು ಗೋದಿಯ ಹಿಟ್ಟನ್ನೂ, ಒಂದು ಹೋರಿಯೊಂದಿಗೆ ತರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ಪಾನದ್ರವ್ಯಕ್ಕಾಗಿ ಮೂರು ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ಇದು ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯ ಸುಗಂಧ ಹೋಮವಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“‘ಕುರಿ, ಆಡು, ಟಗರು, ಹೋರಿ ಇವುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದು ಪಶುವಿನ ಸಂಗಡ ಈ ಪ್ರಕಾರ ನೀವು ನೈವೇದ್ಯಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ನೀವು ಸಮರ್ಪಿಸುವ ಪಶುಗಳ ಲೆಕ್ಕದ ಪ್ರಕಾರವೇ ಒಂದೊಂದು ಪಶುವಿನ ಸಂಗಡ ಈ ರೀತಿಯಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","ಸ್ವದೇಶದವರೆಲ್ಲರೂ ಯೆಹೋವನಿಗೆ ಸುಗಂಧ ಹೋಮವನ್ನು ಸಮರ್ಪಿಸುವಾಗ ಈ ರೀತಿಯಾಗಿ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಇಲ್ಲವೆ ನಿಮ್ಮ ಸಂತತಿಯವರ ಮಧ್ಯದಲ್ಲಿ ಒಕ್ಕಲಿರುವ ಅನ್ಯದೇಶದವನಾಗಲಿ ಅಥವಾ ಇಳಿದುಕೊಂಡಿರುವ ಯಾರೇ ಆಗಲಿ ಯೆಹೋವನಿಗೆ ಸುಗಂಧ ಹೋಮ ಮಾಡಬೇಕಾದರೆ ನಿಮ್ಮಂತೆಯೇ ಅವನೂ ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ಸರ್ವರಿಗೂ ಅಂದರೆ ನಿಮಗೂ, ನಿಮ್ಮಲ್ಲಿರುವ ಅನ್ಯದೇಶದವರಿಗೂ ಒಂದೇ ನಿಯಮವಿರಬೇಕು; ಇದು ನಿಮಗೂ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತವಾದ ನಿಯಮ. ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೀವು ಹೇಗೋ, ಅನ್ಯದೇಶದವನೂ ಸಹ ಹಾಗೆಯೇ ಇರುವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ನಿಮಗೂ, ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ಒಕ್ಕಲಿರುವ ಅನ್ಯದೇಶದವನಿಗೂ ಒಂದೇ ವಿಧವಾದ ನಿಯಮಗಳಿರಬೇಕು.’” ");
INSERT INTO kanirv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ನಾನು ನಿಮ್ಮನ್ನು ಕರೆದುಕೊಂಡುಹೋಗುವ ದೇಶಕ್ಕೆ ನೀವು ಸೇರಿದ ನಂತರ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ನೀವು ಭೂಮಿಯಿಂದ ಬೆಳೆದ ಬೆಳೆಯನ್ನು ಉಪಯೋಗಿಸುವಾಗ, ಸ್ವಲ್ಪವನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಕಾಣಿಕೆಯಾಗಿ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ನೀವು ಕಣದಲ್ಲಿ ತುಳಿಸಿದ ದವಸದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಯೆಹೋವನದೆಂದು ಪ್ರತ್ಯೇಕಿಸುವ ಪ್ರಕಾರವೇ ಕಣಕದಿಂದ ಮಾಡುವ ಮೊದಲನೆಯ ರೊಟ್ಟಿಯನ್ನೂ ಕಾಣಿಕೆಯಾಗಿ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","“‘ನೀವೂ ಮತ್ತು ನಿಮ್ಮ ಸಂತತಿಯವರೂ ಕಣಕದಿಂದ ಮಾಡುವ ಮೊದಲನೆಯ ರೊಟ್ಟಿಯನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಕಾಣಿಕೆಯಾಗಿ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","ನಾನು ಮೋಶೆಗೆ ಹೇಳಿದ ಈ ಎಲ್ಲಾ ಆಜ್ಞೆಗಳಿಗೆ ನೀವು ವಿಧೇಯರಾಗಿರದಿದ್ದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ಆತನು ನಿಮಗೆ ಆಜ್ಞೆಗಳನ್ನು ಕೊಟ್ಟ ದಿನದಿಂದ ಮೊದಲುಗೊಂಡು ನಿಮಗೂ ಮತ್ತು ನಿಮ್ಮ ಸಂತತಿಗೂ ಮೋಶೆಯ ಮುಖಾಂತರ ಆಜ್ಞಾಪಿಸಿದಂತೆ ನೀವು ಮಾಡದೆ ಹೋದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ಯಾವಾಗಲಾದರೂ ಸಮೂಹದವರು ತಿಳಿಯದೆ ಮೀರಿ ದ್ರೋಹಿಗಳಾದರೆ, ಸರ್ವಸಮೂಹದವರೆಲ್ಲರು ಒಟ್ಟಾಗಿ ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕಾಗಿ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ, ನೈವೇದ್ಯಕ್ಕಾಗಿ ಅದಕ್ಕೆ ನೇಮಿತವಾದ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ ಮತ್ತು ಪಾನದ್ರವ್ಯಗಳನ್ನೂ, ದೋಷಪರಿಹಾರ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ಯಾಜಕನು ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದಾಗ ಅವರಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ಅವರು ಆ ತಪ್ಪನ್ನು ತಿಳಿಯದೆ ಮಾಡಿದುದರಿಂದ ಮತ್ತು ಅವರು ಅದನ್ನು ಪರಿಹರಿಸುವುದಕ್ಕಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಕಾಣಿಕೆಯಾಗಿ ಸರ್ವಾಂಗ ಹೋಮವನ್ನೂ, ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನೂ ಮಾಡಿಸಿದ್ದರಿಂದ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ಜನರೆಲ್ಲರೂ ಆ ತಪ್ಪನ್ನು ತಿಳಿಯದೆ ಮಾಡಿದ್ದರಿಂದ, ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರಿಗೂ, ಅವರಲ್ಲಿ ಇಳಿದುಕೊಂಡಿರುವ ಅನ್ಯದೇಶದವರಿಗೂ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“‘ಯಾವನಾದರೂ ತಿಳಿಯದೆ ತಪ್ಪು ಮಾಡಿದರೆ ಅವನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ವರ್ಷದ ಆಡನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ತಿಳಿಯದೆ ತಪ್ಪು ಮಾಡಿದವನಿಗೋಸ್ಕರ ಯಾಜಕನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದಾಗ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ಈ ವಿಷಯದಲ್ಲಿ ಇಸ್ರಾಯೇಲರಲ್ಲಿರುವ ಸ್ವದೇಶದವರಿಗೂ, ಅನ್ಯದೇಶದವರಿಗೂ ಒಂದೇ ನಿಯಮವಿರಬೇಕು, ");
INSERT INTO kanirv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","ಆದರೆ ಸ್ವದೇಶದವನಾಗಲಿ, ಅನ್ಯದೇಶದವನಾಗಲಿ ಯಾವನಾದರೂ ಮನಃಪೂರ್ವಕವಾಗಿ ಹಟದಿಂದ ಪಾಪವನ್ನು ಮಾಡಿದರೆ ಅವನು ಯೆಹೋವನನ್ನು ದೂಷಿಸಿದವನಾದುದರಿಂದ ಕುಲದಿಂದ ಹೊರಗೆ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ಆ ಮನುಷ್ಯನು ಯೆಹೋವನ ಮಾತನ್ನು ತಾತ್ಸಾರಮಾಡಿ ಆತನ ಆಜ್ಞೆಯನ್ನು ಮೀರಿದುದರಿಂದ ಕುಲದಿಂದ ಹೊರಗೆ ಹಾಕಬೇಕು. ಅವನು ತನ್ನ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸಲಿ.’” ");
INSERT INTO kanirv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ಇಸ್ರಾಯೇಲರು ಮರುಭೂಮಿಯಲ್ಲಿ ಇದ್ದಾಗ ಒಬ್ಬನು ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ಕಟ್ಟಿಗೆ ಕೂಡಿಸುವುದನ್ನು ಕಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ಅದನ್ನು ನೋಡಿದವರು ಅವನನ್ನು ಮೋಶೆ, ಆರೋನರ ಮತ್ತು ಸರ್ವಸಮೂಹದವರ ಬಳಿಗೆ ಹಿಡಿದುಕೊಂಡು ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ಅಂಥವನಿಗೆ ವಿಧಿಸಬೇಕಾದ ಶಿಕ್ಷೆಯ ವಿಷಯದಲ್ಲಿ ಆ ವರೆಗೂ ನಿಯಮವೇ ಇರಲಿಲ್ಲವಾದ ಕಾರಣ ಅವರು ಅವನನ್ನು ಕಾವಲಲ್ಲಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಆ ಮನುಷ್ಯನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು; ಸರ್ವಸಮೂಹದವರ ಪಾಳೆಯದ ಹೊರಗೆ ಅವನನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ಯೆಹೋವನು ಮೋಶೆಗೆ ಅಪ್ಪಣೆಕೊಟ್ಟಂತೆ ಸರ್ವಸಮೂಹದವರು ಆ ಮನುಷ್ಯನನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಹಿಡಿದುಕೊಂಡುಹೋಗಿ ಕಲ್ಲೆಸೆದು ಕೊಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ನೀನು ಇಸ್ರಾಯೇಲರ ಸಂತತಿಯವರ ಸಂಗಡ ಮಾತನಾಡಿ, ಅವರು ತಮ್ಮ ವಸ್ತ್ರಗಳ ಮೂಲೆಗಳಲ್ಲಿ ಗೊಂಡೆಗಳನ್ನು ಕಟ್ಟಿಕೊಳ್ಳಬೇಕು, ಪ್ರತಿಯೊಂದು ಗೊಂಡೆಯೂ ಒಂದೊಂದು ನೀಲಿ ದಾರದಿಂದ ಕಟ್ಟಿರಬೇಕು ಎಂದು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸು. ");
INSERT INTO kanirv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ಆ ಗೊಂಡೆಗಳ ಉಪಯೋಗವೇನೆಂದರೆ, ನೀವು ಅವುಗಳನ್ನು ನೋಡುವಾಗ ನನ್ನ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ನೆನಪಿಗೆ ತಂದುಕೊಂಡು ಅದನ್ನು ನಡೆಸಬೇಕು ಮತ್ತು ನೀವು ಪೂರ್ವದಲ್ಲಿ ನನಗೆ ದೇವದ್ರೋಹಿಗಳಾಗಿ ಮನಸ್ಸಿಗೂ, ಕಣ್ಣಿಗೂ ತೋರಿದಂತೆ ");
INSERT INTO kanirv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ದಾರಿ ತಪ್ಪಿ ನಡೆದ ಪ್ರಕಾರ ಇನ್ನು ಮುಂದೆ ನಡೆಯದೆ, ನನ್ನ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ಲಕ್ಷಿಸಿ ಅನುಸರಿಸಿ ನಿಮ್ಮ ದೇವರಿಗೆ ಪ್ರತಿಷ್ಠಿತರಾಗಿರಬೇಕೆಂಬುದೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಾನೇ, ನಿಮ್ಮ ದೇವರಾಗುವುದಕ್ಕಾಗಿ ನಿಮ್ಮನ್ನು ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ಬರಮಾಡಿದ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಾನೇ.” ");
INSERT INTO kanirv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ಆಗ ಲೇವಿಯನ ಮರಿಮಗನೂ, ಕೆಹಾತನ ಮೊಮ್ಮಗನೂ, ಇಚ್ಚಾರನ ಮಗನೂ ಆದ ಕೋರಹನು ಮತ್ತು ರೂಬೇನ್ ಕುಲದವರಲ್ಲಿ ಎಲೀಯಾಬನ ಮಕ್ಕಳಾದ ದಾತಾನನೂ, ಅಬೀರಾಮನೂ ಮತ್ತು ಪೆಲೆತನ ಮಗನಾದ ಓನನೂ, ಕೆಲವು ಜನರನ್ನು ಕೂಡಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರಲ್ಲಿದ್ದ ಮುಖ್ಯಸ್ಥರೂ, ಪ್ರಸಿದ್ಧರಾಗಿ ಹೆಸರು ಹೊಂದಿದ ಇನ್ನೂರೈವತ್ತು ಜನರು ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ಪ್ರತಿಭಟಿಸಿ ತಿರುಗಿಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ಅವರು ಒಟ್ಟಾಗಿ ಕೂಡಿಕೊಂಡು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಬಳಿಗೆ ಬಂದು ಅವರಿಗೆ, “ನೀವು ಹೆಚ್ಚು ಅಧಿಕಾರ ನಡೆಸುತ್ತೀರಿ. ಈ ಸಮೂಹದವರಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ದೇವರಿಗೆ ಪ್ರತಿಷ್ಠಿತನಾದವನು, ಯೆಹೋವನು ಇವರೆಲ್ಲರ ಮಧ್ಯದಲ್ಲಿ ಇದ್ದಾನೆ. ಹೀಗಿರಲಾಗಿ ಯೆಹೋವನ ಸಮೂಹದವರಿಗಿಂತಲೂ ನಿಮ್ಮನ್ನು ನೀವೇ ಹೆಚ್ಚಿಸಿಕೊಳ್ಳುವುದು ಏಕೆ?” ಎಂದು ಕೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ಮೋಶೆ ಆ ಮಾತನ್ನು ಕೇಳಿ ಬೋರಲುಬಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ಮೋಶೆಯು ಕೋರಹನಿಗೂ ಮತ್ತು ಅವನ ಎಲ್ಲಾ ಸಮೂಹದವರಿಗೂ, “ತನ್ನವರು ಯಾರು ಎಂಬುದನ್ನು ಯೆಹೋವನು ನಾಳೆ ತಿಳಿಸುವನು. ಯಾರನ್ನು ಯೆಹೋವನು ಪ್ರತಿಷ್ಠಿಸಿದ್ದಾನೋ, ಯಾರನ್ನು ಆದುಕೊಂಡಿದ್ದಾನೋ ಅವರನ್ನು ಮಾತ್ರ ಆತನು ತನ್ನ ಹತ್ತಿರಕ್ಕೆ ಬರಗೊಡಿಸುವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ನೀವು ಇದನ್ನು ಮಾಡಿರಿ, ಕೋರಹನೂ ಮತ್ತು ಅವನ ಸಮೂಹದವರೆಲ್ಲರೂ ಧೂಪಾರತಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ");
INSERT INTO kanirv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ಅವುಗಳಲ್ಲಿ ಕೆಂಡಗಳನ್ನಿಟ್ಟು ನಾಳೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಧೂಪಹಾಕಿರಿ. ಆಗ ಯೆಹೋವನು ಯಾರನ್ನು ಮೆಚ್ಚುವನೋ ಅವನೇ ದೇವರಿಗೆ ಪ್ರತಿಷ್ಠಿತನೆಂದು ತಿಳಿದುಕೊಳ್ಳುವಿರಿ. ಲೇವಿಯರೇ, ನಿಮ್ಮ ವರ್ತನೆ ಅತಿಯಾಯಿತು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ಪುನಃ ಮೋಶೆ ಕೋರಹನಿಗೆ, “ಲೇವಿಯ ಸಂತಾನದವರೇ, ಈಗ ಕೇಳಿರಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ಇಸ್ರಾಯೇಲರ ದೇವರಾದ ಯೆಹೋವನು ತನ್ನ ಗುಡಾರದ ಸೇವಾಕಾರ್ಯವನ್ನು ಮಾಡುವುದಕ್ಕೂ, ಸರ್ವಸಮೂಹದವರಿಗೋಸ್ಕರ ಸೇವೆಯನ್ನು ಮಾಡುವುದಕ್ಕೂ ನಿಮ್ಮನ್ನು ಹತ್ತಿರ ಬರಮಾಡಿಕೊಂಡು, ಸಮೂಹದವರಿಂದ ನಿಮ್ಮನ್ನು ಪ್ರತ್ಯೇಕಿಸಿದ್ದು ನಿಮಗೆ ಅಲ್ಪವಾಗಿ ತೋರುತ್ತದೋ? ");
INSERT INTO kanirv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ಆತನು ನಿನ್ನನ್ನೂ, ನಿನ್ನ ಸ್ವಕುಲದವರಾದ ಲೇವಿಯರನ್ನೂ ತನ್ನ ಹತ್ತಿರ ಬರಮಾಡಿಕೊಂಡಿದ್ದಾನೆ. ನೀವು ಸಹ ಯಾಜಕತ್ವವನ್ನು ಬಯಸುತ್ತಿರೋ? ");
INSERT INTO kanirv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ನೀನು ಮತ್ತು ನಿನ್ನ ಸಮೂಹದವರೆಲ್ಲರು ಯೆಹೋವನಿಗೆ ವಿರುದ್ಧವಾಗಿ ಕೂಡಿಕೊಂಡಿರಿ, ನನಗೆ ವಿಧೇಯನಾಗಿ ನಡೆಯುವ ಆರೋನನ ವಿರುದ್ಧವಾಗಿ ನೀವು ಗುಣಗುಟ್ಟುವುದೇಕೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ಮೋಶೆಯು, ಎಲೀಯಾಬನ ಮಕ್ಕಳಾದ ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮರನ್ನು ಕರೆದುಕೊಂಡು ಬರಲು ಹೇಳಿದರು ಅವರು ಅವನಿಗೆ, “ನಾವು ಬರುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ನೀನು ಹಾಲೂ ಮತ್ತು ಜೇನೂ ಹರಿಯುವ ದೇಶದಿಂದ ಕರೆದುಕೊಂಡು ಬಂದು ನಮ್ಮನ್ನು ಮರುಭೂಮಿಯಲ್ಲಿ ಸಾಯಿಸುವುದು ನಿನಗೆ ಸಾಕಾಗಲಿಲ್ಲವೋ? ನೀನು ನಮ್ಮ ಮೇಲೆ ದೊರೆತನ ಮಾಡಬೇಕು ಎಂದು ಕೋರುತ್ತಿಯೋ? ");
INSERT INTO kanirv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ಅಷ್ಟು ಮಾತ್ರವೇ ಅಲ್ಲ, ನೀನು ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶಕ್ಕೆ ನಮ್ಮನ್ನು ಸೇರಿಸಲಿಲ್ಲ; ಹೊಲಗಳನ್ನೂ, ದ್ರಾಕ್ಷಿತೋಟಗಳನ್ನೂ ನಮಗೆ ಸ್ವಂತಕ್ಕೆ ಕೊಡಲೇ ಇಲ್ಲ; ಈ ಜನರ ಕಣ್ಣಿಗೆ ಮಣ್ಣು ಹಾಕಬೇಕೆಂದಿದ್ದೀಯೋ? ನಾವು ಬರುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ಅದಕ್ಕೆ ಮೋಶೆಯು ಬಹಳ ಕೋಪಗೊಂಡು ಯೆಹೋವನಿಗೆ, “ನೀನು ಅವರ ನೈವೇದ್ಯವನ್ನು ಲಕ್ಷ್ಯಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳಬೇಡ; ನಾನು ಅವರಿಂದ ಒಂದು ಕತ್ತೆಯನ್ನಾದರೂ ತೆಗೆದುಕೊಂಡವನಲ್ಲ; ಅವರಲ್ಲಿ ಒಬ್ಬನಿಗಾದರೂ ಹಾನಿ ಮಾಡಿದವನಲ್ಲ” ಎಂದು ಮನವಿಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ಮೋಶೆ ಕೋರಹನಿಗೆ, “ನಾಳೆ ನೀನೂ, ನಿನ್ನ ಸಮೂಹದವರೆಲ್ಲರೂ ಮತ್ತು ಆರೋನನೂ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಬರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ಅವರಲ್ಲಿ ಒಬ್ಬೊಬ್ಬನು ತನ್ನ ತನ್ನ ಧೂಪಾರತಿಗಳನ್ನು, ಒಟ್ಟಾಗಿ ಇನ್ನೂರೈವತ್ತು ಧೂಪಾರತಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಧೂಪಹಾಕಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಬರಬೇಕು. ಹಾಗೆಯೇ ನೀನು ಮತ್ತು ಆರೋನನು ನಿಮ್ಮ ನಿಮ್ಮ ಧೂಪಾರತಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ಅದಕ್ಕೆ ಅನುಸಾರವಾಗಿ ಅವರೆಲ್ಲರೂ ತಮ್ಮ ತಮ್ಮ ಧೂಪಾರತಿಗಳನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಅವುಗಳಲ್ಲಿ ಕೆಂಡಗಳನ್ನಿಟ್ಟು ಧೂಪದ್ರವ್ಯಗಳನ್ನು ಹಾಕಿ ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಜೊತೆಯಲ್ಲಿ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನಲ್ಲಿ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ಅದಲ್ಲದೆ ಕೋರಹನು ತಮಗೆ ಎದುರಾದ ಸರ್ವಸಮೂಹದವರನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರಕ್ಕೆ ಕೂಡಿಸಿದನು. ಆಗ ಯೆಹೋವನ ತೇಜಸ್ಸು ಸಮೂಹದವರೆಲ್ಲರಿಗೂ ಕಾಣಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನನ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ನೀವು ಈ ಸರ್ವಸಮೂಹದವರಿಂದ ಪ್ರತ್ಯೇಕವಾಗಿ ನಿಲ್ಲಿರಿ; ನಾನು ಇವರನ್ನು ಒಂದು ಕ್ಷಣದಲ್ಲಿ ದಹಿಸಿಬಿಡುತ್ತೇನೆ” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ಅವರು ಬೋರಲುಬಿದ್ದು, “ದೇವರೇ, ಎಲ್ಲಾ ಮನುಷ್ಯರ ಆತ್ಮಗಳಿಗೆ ದೇವರಾಗಿರುವವನೇ, ಇವರಲ್ಲಿ ದೋಷಿಯಾದವನು ಒಬ್ಬನೇ ಆಗಿರಲಾಗಿ ಸರ್ವಸಮೂಹದವರೆಲ್ಲರ ಮೇಲೆ ಕೋಪಗೊಳ್ಳಬಹುದೋ?” ಎಂದು ಬಿನ್ನೈಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ ಉತ್ತರವಾಗಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರಿಗೆ, ‘ಕೋರಹ, ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮರ ಗುಡಾರದಿಂದ ದೂರವಿರಬೇಕು’ ಎಂದು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ಆಗ ಮೋಶೆ ಎದ್ದು ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮರ ಬಳಿಗೆ ಹೋದನು; ಇಸ್ರಾಯೇಲರ ಹಿರಿಯರು ಅವನ ಹಿಂದೆ ಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ಅವನು ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರಿಗೆ, “ನೀವು ಈ ದುಷ್ಟರ ಡೇರೆಗಳ ಬಳಿಯಲ್ಲಿ ಇರದೆ ದೂರ ಹೋಗಬೇಕು; ಇವರ ಸೊತ್ತಿನಲ್ಲಿ ಯಾವುದನ್ನೂ ಮುಟ್ಟಬಾರದು; ಇವರ ದೋಷಗಳಿಗಾಗಿ ಉಂಟಾಗುವ ಶಿಕ್ಷೆ ನಿಮ್ಮನ್ನೂ ಕೊಚ್ಚಿಕೊಂಡು ಹೋದೀತು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ಆದಕಾರಣ ಅವರೆಲ್ಲರೂ ಕೋರಹ, ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮರ ಗುಡಾರದಿಂದ ದೂರ ಹೋದರು. ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮರೂ ಅವರ ಹೆಂಡತಿ, ಮಕ್ಕಳು ಮತ್ತು ಅವರಿಗೆ ಸಂಬಂಧಪಟ್ಟವರೆಲ್ಲರೂ ಹೊರಗೆ ಬಂದು ತಮ್ಮ ತಮ್ಮ ಡೇರೆಗಳ ಬಾಗಿಲುಗಳಲ್ಲಿ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ಆಗ ಮೋಶೆ ಜನರಿಗೆ, “ಈ ಕಾರ್ಯಗಳೆಲ್ಲಾ ನನ್ನ ಆಲೋಚನೆಯಿಂದ ಆಗಲಿಲ್ಲವೆಂದೂ ಮತ್ತು ಯೆಹೋವನೇ ಇವುಗಳನ್ನು ನಡಿಸುವುದಕ್ಕೆ ನನ್ನನ್ನು ಕಳುಹಿಸಿದನೆಂದೂ ನೀವೇ ತಿಳಿದುಕೊಳ್ಳುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ಹೇಗೆಂದರೆ, ಎಲ್ಲರೂ ಸಾಯುವ ರೀತಿಯಲ್ಲೇ ಇವರು ಸತ್ತರೆ, ಇಲ್ಲವೆ ಎಲ್ಲರಿಗೂ ಸಂಭವಿಸುವ ಗತಿ ಇವರಿಗುಂಟಾದರೆ ಯೆಹೋವನು ನನ್ನನ್ನು ಕಳುಹಿಸಲಿಲ್ಲವೆಂದು ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ಆದರೆ ಯೆಹೋವನು ಇವರಿಗೋಸ್ಕರ ಭೂಮಿಯು ಬಾಯ್ದೆರೆದು ಇವರನ್ನೂ, ಇವರ ಸರ್ವಸ್ವವನ್ನೂ ನುಂಗಿ, ಇವರು ಸಜೀವಿಗಳಾಗಿ ಪಾತಾಳಕ್ಕೆ ಹೋಗಿಬಿಟ್ಟರೆ, ಇವರು ಯೆಹೋವನನ್ನು ತಿರಸ್ಕರಿಸಿದವರೆಂದು ನೀವು ತಿಳಿದುಕೊಳ್ಳಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ಮೋಶೆ ಈ ಮಾತುಗಳನ್ನು ಹೇಳಿ ಮುಗಿಸಿದ ಕೂಡಲೆ ಆ ಮನುಷ್ಯರ ಕೆಳಗಿದ್ದ ನೆಲವು ಸೀಳಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ಭೂಮಿಯು ಬಾಯ್ದೆರೆದು ಅವರನ್ನೂ ಮತ್ತು ಕೋರಹನಿಗೆ ಸೇರಿದ ಮನುಷ್ಯರೆಲ್ಲರನ್ನೂ, ಅವರ ಸರ್ವಸ್ವವನ್ನೂ ನುಂಗಿಬಿಟ್ಟಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ಅವರು ಸಜೀವಿಗಳಾಗಿ ತಮ್ಮ ಸರ್ವಸ್ವ ಸಹಿತವಾಗಿ ಪಾತಾಳಕ್ಕೆ ಹೋಗಿಬಿಟ್ಟರು, ಭೂಮಿಯು ಅವರನ್ನು ಮುಚ್ಚಿಕೊಂಡಿತು. ಹೀಗೆ ಅವರು ಸಮೂಹದವರೊಳಗಿಂದ ನಾಶವಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ಅವರ ಸುತ್ತಲಿದ್ದ ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ಹೆದರಿಕೊಂಡು, “ಭೂಮಿಯು ನಮ್ಮನ್ನೂ ಸಹ ನುಂಗಿಬಿಟ್ಟೀತು!” ಎಂದು ಹೇಳಿ ಓಡಿಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ನಂತರ ಯೆಹೋವನ ಬಳಿಯಿಂದ ಬೆಂಕಿಹೊರಟು, ಧೂಪವನ್ನು ಅರ್ಪಿಸುತ್ತಿದ್ದ ಆ ಇನ್ನೂರೈವತ್ತು ಮಂದಿಯನ್ನು ದಹಿಸಬಿಟ್ಟಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ಆಗ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ");
INSERT INTO kanirv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“ಯಾಜಕನಾದ ಆರೋನನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನಿಗೆ, ಧೂಪಾರತಿಗಳು ಪರಿಶುದ್ಧವಾಗಿರುವುದರಿಂದ ದಹಿಸಲ್ಪಟ್ಟವರ ಮಧ್ಯದಿಂದ ಆ ಧೂಪಾರತಿಗಳನ್ನು ತೆಗೆಯಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸು ಮತ್ತು ನೀನು ಅವುಗಳಲ್ಲಿರುವ ಕೆಂಡಗಳನ್ನು ದೂರ ಚೆಲ್ಲು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ತಮ್ಮ ಪಾಪಗಳಿಂದ ಪ್ರಾಣವನ್ನು ಕಳೆದುಕೊಂಡ ಆ ದೋಷಿಗಳ ಧೂಪಾರತಿಗಳು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತಂದ ಕಾರಣ ಅವು ಪರಿಶುದ್ಧವಾದವು. ಆದುದರಿಂದ ಅವುಗಳನ್ನು ತಗಡುಗಳನ್ನಾಗಿ ಮಾಡಿ, ಯಜ್ಞವೇದಿಗೆ ಮುಚ್ಚಳವನ್ನು ಮಾಡಿಸಬೇಕು. ಇಸ್ರಾಯೇಲರಿಗೆ ಅವು ಗುರುತುಗಳಾಗಿರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ಆಗ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಹೇಳಿದ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ದಹಿಸಿಹೋದವರು ಅರ್ಪಿಸಿದ ಆ ತಾಮ್ರದ ಧೂಪಾರತಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ತಗಡುಗಳಾಗಿ ಮಾಡಿಸಿ, ಯಜ್ಞವೇದಿಯನ್ನು ಮುಚ್ಚಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ಆರೋನನ ಸಂತಾನಕ್ಕೆ ಸೇರದ ಬೇರೆ ಜನರು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಬಂದು ಧೂಪವನ್ನು ಸಮರ್ಪಿಸಬಾರದು. ಸಮರ್ಪಿಸಿದರೆ ಕೋರಹನಿಗೂ ಮತ್ತು ಅವನ ಸಮೂಹದವರಿಗೂ ಆದ ಸ್ಥಿತಿಯೇ ಇವರಿಗೂ ಉಂಟಾಗುವುದೆಂಬುದನ್ನು ಇಸ್ರಾಯೇಲರಿಗೆ ಜ್ಞಾಪಿಸುವುದಕ್ಕೆ ಗುರುತಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ಮರುದಿನ ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಮೇಲೆ ಗುಣುಗುಟ್ಟಿ, “ನೀವೇ ಯೆಹೋವನ ಜನರನ್ನು ಸಾಯಿಸಿದಿರಿ” ಎಂದು ಹೇಳುವವರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ಸರ್ವಸಮೂಹದವರೆಲ್ಲರೂ ಹೀಗೆ ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಸೇರಿ ಬಂದಾಗ ದೇವದರ್ಶನದ ಗುಡಾರದ ಮೇಲೆ, ಮೇಘವು ಆವರಿಸಿಕೊಂಡಿತು ಮತ್ತು ಯೆಹೋವನ ತೇಜಸ್ಸು ಅಲ್ಲಿ ಕಾಣಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಮುಂಭಾಗಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ನೀವಿಬ್ಬರೂ ಸಮೂಹದವರಲ್ಲಿ ಇರದೆ ಬೇರೆ ನಿಲ್ಲಬೇಕು. ನಾನು ಒಂದು ಕ್ಷಣಮಾತ್ರದಲ್ಲಿ ಅವರನ್ನು ದಹಿಸಿಬಿಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ಆಗ ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಬೋರಲುಬಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ಯೆಹೋವನ ಕೋಪದಿಂದ ಈ ಜನರೊಳಗೆ ಘೋರವ್ಯಾಧಿಯು ಪ್ರಾರಂಭವಾಯಿತು. ನೀನು ಧೂಪಾರತಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಅದರಲ್ಲಿ ಯಜ್ಞವೇದಿಯಿಂದ ಕೆಂಡಗಳನ್ನು ಇಟ್ಟು ಧೂಪಹಾಕಿ, ಸಮೂಹದವರ ಬಳಿಗೆ ಬೇಗ ಹೋಗಿ ಅವರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ಮೋಶೆ ಹೇಳಿದಂತೆ ಆರೋನನು ಧೂಪಾರತಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಸಮೂಹದವರ ಮಧ್ಯಕ್ಕೆ ಓಡಿದಾಗ ಘೋರವ್ಯಾಧಿಯು ಜನರೊಳಗೆ ಪ್ರಾರಂಭವಾಗಿತ್ತು. ಆದುದರಿಂದ ಅವನು ಧೂಪಹಾಕಿ ಜನರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ಅವನು ಸತ್ತವರಿಗೂ, ಬದುಕುವವರಿಗೂ ಮಧ್ಯದಲ್ಲಿ ನಿಂತುಕೊಂಡುದರಿಂದ ಆ ವ್ಯಾಧಿಯು ಶಮನವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ಕೋರಹನ ನಿಮಿತ್ತ ಸತ್ತುಹೋದವರ ಹೊರತಾಗಿ ಆ ವ್ಯಾಧಿಯಿಂದ ಸತ್ತವರ ಸಂಖ್ಯೆ ಹದಿನಾಲ್ಕು ಸಾವಿರದ ಏಳುನೂರು ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ಆ ವ್ಯಾಧಿ ಶಮನವಾದಾಗ ಆರೋನನು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಮೋಶೆಯ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿ, ‘ಅವರ ಪೂರ್ವಿಕರ ಒಂದೊಂದು ಕುಲದ ಅಧಿಪತಿಯಿಂದ ಗೋತ್ರಗಳ ಪ್ರಕಾರವಾಗಿ ಒಂದೊಂದು ಕೋಲುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಗೋತ್ರಗಳ ಪ್ರಕಾರವಾಗಿ ಒಬ್ಬೊಬ್ಬ ಪ್ರಧಾನರ ಹೆಸರಿನಲ್ಲಿ ಹನ್ನೆರಡು ಕೋಲುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅವನವನ ಕೋಲಿನ ಮೇಲೆ ಅವರ ಹೆಸರನ್ನು ಬರೆಯಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ಲೇವಿ ಕುಲಕ್ಕೂ ಒಂದು ಕೋಲು ಇರುವುದರಿಂದ ಅದರ ಮೇಲೆ ಆರೋನನ ಹೆಸರನ್ನು ಬರೆಯಿಸಬೇಕು ಏಕೆಂದರೆ ಅವರ ಪೂರ್ವಿಕರ ಗೋತ್ರದ ಮುಖ್ಯಸ್ಥನಿಗೆ ಒಂದು ಕೋಲು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ನೀನು ಆ ಕೋಲುಗಳನ್ನು ದೇವದರ್ಶನದ ಗುಡಾರದಲ್ಲಿ ಆಜ್ಞಾಶಾಸನಗಳ ಮುಂದೆ ನಾನು ನಿಮಗೆ ದರ್ಶನಕೊಡುವ ಸ್ಥಳದಲ್ಲಿ ಇಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ನಾನು ಯಾರನ್ನು ಆಯ್ದುಕೊಳ್ಳುತ್ತೇನೋ ಅವನ ಕೋಲು ಚಿಗುರುವುದು. ಇಸ್ರಾಯೇಲರು ನಿಮ್ಮಿಬ್ಬರ ವಿರುದ್ಧವಾಗಿ ಗುಣುಗುಟ್ಟುವುದನ್ನು ನಾನು ನಿಲ್ಲಿಸಿ ಬಿಡುವೆನು’” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ಅದಕ್ಕೆ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರ ಸಂಗಡ ಮಾತನಾಡಿದನು. ಅವರ ಕುಲಾಧಿಪತಿಗಳೆಲ್ಲರೂ ಕುಲಕ್ಕೆ ಒಂದು ಕೋಲಿನ ಪ್ರಕಾರ ಹನ್ನೆರಡು ಕೋಲುಗಳನ್ನು ಅವನ ಕೈಗೆ ಕೊಟ್ಟರು. ಅವುಗಳೊಡನೆ ಆರೋನನ ಕೋಲೂ ಇತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ಮೋಶೆ ಆ ಕೋಲುಗಳನ್ನು ಆಜ್ಞಾಶಾಸನಗಳಿರುವ ಗುಡಾರದಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಇಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ಮರುದಿನ ಮೋಶೆಯು ಆಜ್ಞಾಶಾಸನಗಳಿರುವ ಗುಡಾರದಲ್ಲಿ ಹೋಗಿ ನೋಡಲಾಗಿ ಅಗೋ, ಲೇವಿ ಕುಲಕ್ಕೋಸ್ಕರ ಆರೋನನಿಗೆ ಕೊಟ್ಟಿದ್ದ ಕೋಲು ಚಿಗುರಿ, ಮೊಗ್ಗುಬಿಟ್ಟು ಹೂವಾಗಿ ಬಾದಾಮಿ ಹಣ್ಣುಗಳನ್ನು ಫಲಿಸಿತ್ತು! ");
INSERT INTO kanirv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ಮೋಶೆ ಆ ಕೋಲುಗಳನ್ನೆಲ್ಲಾ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಿಂದ ಇಸ್ರಾಯೇಲರ ಬಳಿಗೆ ತಂದು ತೋರಿಸಿದನು. ಅವರು ನೋಡಿ ತಮ್ಮತಮ್ಮ ಕೋಲುಗಳನ್ನು ಪರೀಕ್ಷಿಸಿ ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಆರೋನನ ಕೋಲನ್ನು ತಿರುಗಿ ಆಜ್ಞಾಶಾಸನಗಳ ಮುಂದೆ ಇಡಬೇಕು. ಅದು ತಿರುಗಿಬೀಳುವವರಿಗೆ ದೃಷ್ಟಾಂತವಾಗಿ ಅಲ್ಲೇ ಇರಬೇಕು. ಇವರು ಇನ್ನು ಮುಂದೆ ನನಗೆ ವಿರುದ್ಧವಾಗಿ ಗುಣುಗುಟ್ಟಿ ನಾಶವಾಗದಂತೆ ನೀನು ಹೀಗೆ ಮಾಡು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರವೇ ಮೋಶೆ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ಇಸ್ರಾಯೇಲರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, “ನಾವು ಇಲ್ಲಿ ಸಾಯುತ್ತೇವೆ; ಇಲ್ಲವೇ ನಾಶವಾಗಿ ಹೋಗುತ್ತೇವೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ಯೆಹೋವನ ಗುಡಾರದ ಹತ್ತಿರಕ್ಕೆ ಬರುವವರೆಲ್ಲರೂ ಸಾಯುತ್ತಾರಷ್ಟೆ; ನಾವೆಲ್ಲರೂ ಹಾಗೆಯೇ ಸಾಯಬೇಕೇನು?” ಎಂದು ಕೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ಆಗ ಯೆಹೋವನು ಆರೋನನಿಗೆ, “ದೇವದರ್ಶನದ ಗುಡಾರದ ವಿಷಯದಲ್ಲಿ ಅಕ್ರಮವೇನಾದರೂ ನಡೆದರೆ ನೀನೂ, ನಿನ್ನ ಸಂತತಿಯವರೂ, ನಿನ್ನ ಕುಲದವರೆಲ್ಲರೂ ಆ ದೋಷದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ಯಾಜಕತ್ವದ ವಿಷಯದಲ್ಲಿ ಅಕ್ರಮವೇನಾದರೂ ನಡೆದರೆ ನೀನೂ, ನಿನ್ನ ಸಂತತಿಯವರು ಮಾತ್ರವೇ ಆ ದೋಷದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ನಿನ್ನ ಕುಲದ ಮೂಲಪುರುಷನಾದ ಲೇವಿ ವಂಶದವರನ್ನು ನೀನು ಹತ್ತಿರಕ್ಕೆ ಕರೆದು ಜೊತೆಯಲ್ಲಿರಿಸಿಕೊಂಡು ನಿನ್ನ ಕೈಕೆಳಗೆ ಸೇವೆಮಾಡಿಸಬೇಕು. ಆದರೆ ಆಜ್ಞಾಶಾಸನಗಳಿರುವ ಗುಡಾರದ ಮುಂದೆ ನೀನೂ, ನಿನ್ನ ಮಕ್ಕಳೂ ಮಾತ್ರ ಸೇವೆಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ಲೇವಿಯರು ನಿನ್ನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ನಡೆದು ಗುಡಾರವನ್ನು ಕಾಯಬೇಕು. ಆದರೆ ಪವಿತ್ರಸ್ಥಾನದ ವಸ್ತುಗಳ ಹತ್ತಿರವಾಗಲಿ ಅಥವಾ ಯಜ್ಞವೇದಿಯ ಹತ್ತಿರವಾಗಲಿ ಅವರು ಬರಬಾರದು, ಬಂದರೆ ಅವರು ಸಾಯುವುದು ಮಾತ್ರವಲ್ಲದೆ ನೀವೂ ಸಾಯುವಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ಅವರೇ ನಿನ್ನ ಜೊತೆಯಲ್ಲಿದ್ದು ದೇವದರ್ಶನದ ಗುಡಾರವನ್ನು ನೋಡಿಕೊಂಡು ಅದರ ಸಕಲ ಸೇವಾಕಾರ್ಯವನ್ನು ಮಾಡಬೇಕು. ಇತರ ಕುಲದವರು ನಿಮ್ಮ ಹತ್ತಿರಕ್ಕೆ ಬರಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ಇನ್ನು ಮುಂದೆ ಇಸ್ರಾಯೇಲರ ಮೇಲೆ ದೇವರ ಕೋಪವುಂಟಾಗದಂತೆ, ನೀವೇ ದೇವಸ್ಥಾನದ ವಸ್ತುಗಳನ್ನೂ, ಯಜ್ಞವೇದಿಯನ್ನೂ ನೋಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ಇಗೋ, ನಾನು ಇಸ್ರಾಯೇಲರೊಳಗಿಂದ ನಿನ್ನ ಕುಲದವರಾದ ಲೇವಿಯರನ್ನು ಆರಿಸಿಕೊಂಡಿದ್ದೇನೆ. ಅವರು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಲ್ಪಟ್ಟ ಕಾಣಿಕೆಯಂತೆ ನಿನ್ನ ವಶದಲ್ಲಿಯೇ ಇದ್ದಾರೆ. ಅವರೇ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವಾಕಾರ್ಯವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ನೀನೂ, ನಿನ್ನ ಸಂತತಿಯವರೂ ಯಾಜಕೋದ್ಯೋಗವನ್ನು ಕೈಕೊಂಡವರಾಗಿ ಯಜ್ಞವೇದಿಯ ಮತ್ತು ತೆರೆಯ ಒಳಗಿನ ಕಾರ್ಯಗಳನ್ನು ನಡೆಸಬೇಕು. ಅವುಗಳ ಸೇವಾಕಾರ್ಯವನ್ನು ನೀವೇ ಮಾಡಬೇಕು. ನಾನು ಯಾಜಕತ್ವವನ್ನು ನಿಮಗೆ ದಾನವಾಗಿ ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ. ಇತರರು ಅದಕ್ಕೆ ಕೈಹಾಕಿದರೆ ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ಯೆಹೋವನು ಆರೋನನಿಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, “ಇಸ್ರಾಯೇಲರು ನನಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿ ಸಮರ್ಪಿಸುವ ಪದಾರ್ಥಗಳನ್ನೆಲ್ಲಾ ಹಾಗೂ ದೇವರ ಪರಿಶುದ್ಧ ವಸ್ತುಗಳನ್ನೆಲ್ಲಾ ನಾನು ನಿನ್ನ ಮತ್ತು ನಿನ್ನ ಸಂತತಿಯವರ ಪಾಲಾಗುವುದಕ್ಕೆ ದಾನಮಾಡಿದ್ದೇನೆ. ಅವು ಸದಾಕಾಲವೂ ನಿಮಗೇ ಸಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ಬೆಂಕಿಯಲ್ಲಿ ಹೋಮಮಾಡದೆ ಉಳಿದಿರುವ ಮಹಾ ಪರಿಶುದ್ಧ ವಸ್ತುಗಳು ನಿನಗೆ ಕಾಣಿಕೆಯಾಗಿ ಸಲ್ಲಬೇಕು. ಇಸ್ರಾಯೇಲರು ನನಗೆ ಸಮರ್ಪಿಸುವ ಎಲ್ಲಾ ಧಾನ್ಯದ್ರವ್ಯ, ದೋಷಪರಿಹಾರಕ ಯಜ್ಞ, ಪ್ರಾಯಶ್ಚಿತ್ತಯಜ್ಞ ಇವುಗಳಲ್ಲಿ ಹೋಮಶೇಷವು ಮಹಾಪರಿಶುದ್ಧವಾದುದರಿಂದ ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಯವರಿಗೂ ಸಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ನೀವು ಮಹಾಪರಿಶುದ್ಧವಾದ ಒಂದು ಸ್ಥಳದಲ್ಲಿ ಅವುಗಳನ್ನು ಊಟಮಾಡಬೇಕು. ನಿಮ್ಮಲ್ಲಿರುವ ಗಂಡಸರೆಲ್ಲರೂ ಅವುಗಳನ್ನು ತಿನ್ನಬಹುದು. ಅವು ಮಹಾಪರಿಶುದ್ಧವಾದವುಗಳೆಂದು ನೀವು ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ಇದಲ್ಲದೆ ಇಸ್ರಾಯೇಲರು ಮಾಡುವ ಸಮಾಧಾನಯಜ್ಞಗಳಿಂದ ನನಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿಕೊಡುವ ದ್ರವ್ಯಗಳೂ, ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸುವ ದ್ರವ್ಯಗಳೂ ನಿಮಗೆ ಸೇರಬೇಕು. ಇವು ನಿನಗೂ, ನಿನ್ನ ಸಂತತಿಯವರಾದ ಸ್ತ್ರೀಪುರುಷರೆಲ್ಲರಿಗೂ ಶಾಶ್ವತ ನಿಯಮವಾಗಿ ಸಲ್ಲಬೇಕೆಂದು ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ. ಇವುಗಳನ್ನು ನಿಮ್ಮ ಮನೆಗಳಲ್ಲಿರುವ ಶುದ್ಧರಾದವರೆಲ್ಲರೂ ಊಟ ಮಾಡಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವ ಪ್ರಥಮಫಲಗಳು ಯಾವುವೆಂದರೆ: ಎಣ್ಣೆ, ದ್ರಾಕ್ಷಾರಸ, ಧಾನ್ಯ ಇವುಗಳಲ್ಲಿ ಶ್ರೇಷ್ಠವಾದದ್ದು ನಿನಗೇ ಸೇರಬೇಕೆಂದು ವಿಧಿಸಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ಅವರು ತಮ್ಮ ದೇಶದ ಎಲ್ಲಾ ಬೆಳೆಗಳಲ್ಲಿ ಯೆಹೋವನಿಗೋಸ್ಕರ ತರುವ ಪ್ರಥಮಫಲಗಳು ನಿನಗೇ ಸಲ್ಲಬೇಕು. ನಿಮ್ಮ ಮನೆಗಳಲ್ಲಿ ಶುದ್ಧರಾಗಿರುವ ಎಲ್ಲರೂ ಅವುಗಳನ್ನು ಊಟಮಾಡಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ಕೇವಲ ಯೆಹೋವನಿಗೋಸ್ಕರ ಇರುವುದಕ್ಕೆ ಇಸ್ರಾಯೇಲರು ಹರಕೆಮಾಡಿ ಸಮರ್ಪಿಸುವುದೆಲ್ಲವೂ ನಿನಗೆ ಸೇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ಮನುಷ್ಯರಲ್ಲಾಗಲಿ, ಪಶುಗಳಲ್ಲಾಗಲಿ ಅವರು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವ ಸಕಲಪ್ರಾಣಿಗಳಲ್ಲಿ ಚೊಚ್ಚಲಾದದ್ದು ನಿನಗೆ ಸಲ್ಲಬೇಕು. ಆದರೆ ಮನುಷ್ಯರ ಚೊಚ್ಚಲಮಕ್ಕಳಿಗೂ, ಅಪವಿತ್ರವಾದ ಪಶುಗಳ ಮರಿಗಳಿಗೂ ಬದಲಾಗಿ ನೀನು ಈಡನ್ನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ಬಿಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ಹೀಗೆ ಬಿಟ್ಟುಬಿಡಬೇಕಾದ ಶಿಶುಗಳು ಒಂದು ತಿಂಗಳಿನ ಪ್ರಾಯಕ್ಕೆ ಬಂದಾಗ, ನೀವು ಗೊತ್ತು ಮಾಡಿದ ಈಡನ್ನು ದೇವರ ಸೇವೆಗೆ ನೇಮಕವಾದ ಇಪ್ಪತ್ತು ಗೇರಾ ತೂಕದ ಶೆಕೆಲ್ ಪ್ರಕಾರ ಐದು ಶೆಕೆಲ್ ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ಬಿಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“ಆಕಳಿನ ಮತ್ತು ಆಡುಕುರಿಗಳ ಚೊಚ್ಚಲುಮರಿಗಳು ದೇವರ ಸೊತ್ತಾಗಿರುವುದರಿಂದ ಅವುಗಳನ್ನು ಬಿಡಬಾರದು. ಅವುಗಳ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಗೆ ಚಿಮುಕಿಸಿಬೇಕು, ಅವುಗಳ ಕೊಬ್ಬನ್ನು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ಅವುಗಳ ಮಾಂಸವು ಸಮಾಧಾನಯಜ್ಞಗಳಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸುವ ಎದೆಯ ಭಾಗದಂತೆಯೂ, ಬಲತೊಡೆಯಂತೆಯೂ ನಿನಗೇ ಸಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿ ಸಮರ್ಪಿಸುವ ದೇವರ ವಸ್ತುಗಳೆಲ್ಲಾ ನಿನಗೂ, ನಿನ್ನ ಸಂತತಿಯವರಾದ ಸ್ತ್ರೀಪುರುಷರೆಲ್ಲರಿಗೂ ಸದಾಕಾಲವೂ ಸಲ್ಲಬೇಕೆಂದು ನಾನು ಅನುಗ್ರಹಮಾಡಿದ್ದೇನೆ. ಇದು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿನ್ನೊಡನೆಯೂ, ನಿನ್ನ ಸಂತತಿಯೊಡನೆಯೂ ಮಾಡಲ್ಪಟ್ಟ ಶಾಶ್ವತವಾದ ಉಪ್ಪಿನ ಒಡಂಬಡಿಕೆಯಾಗಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ಇದಲ್ಲದೆ ಯೆಹೋವನು ಆರೋನನಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ಇಸ್ರಾಯೇಲರ ದೇಶದಲ್ಲಿ ನಿನ್ನ ಸ್ವಂತಕ್ಕಾಗಿ ಯಾವ ಸ್ವತ್ತು ಇರಬಾರದು. ಅವರೊಂದಿಗೆ ನಿನಗೆ ಪಾಲು ಇರುವುದಿಲ್ಲ. ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ನಾನೇ ನಿನಗೆ ಪಾಲಾಗಿಯೂ ಮತ್ತು ಸ್ವತ್ತಾಗಿಯೂ ಇದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“ಲೇವಿಯರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವಾಕಾರ್ಯವನ್ನು ಮಾಡುವುದಕ್ಕಾಗಿ ಇಸ್ರಾಯೇಲರಿಂದ ಸಕಲ ಪದಾರ್ಥಗಳ ಹತ್ತನೆಯ ಪಾಲನ್ನು ಗೊತ್ತುಮಾಡಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ಇನ್ನು ಮುಂದೆ ಇಸ್ರಾಯೇಲರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಹತ್ತಿರಕ್ಕೆ ಬರಬಾರದು, ಬಂದರೆ ಅವರು ಆ ದೋಷದಿಂದ ಸತ್ತುಹೋಗುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ಲೇವಿಯರೇ ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವಾಕಾರ್ಯವನ್ನು ಮಾಡಬೇಕು. ಅದರ ಸಂಬಂಧವಾಗಿ ಅವರು ಮಾಡುವ ಪಾಪಫಲವನ್ನು ತಾವೇ ಅನುಭವಿಸಬೇಕು. ಇದು ನಿಮಗೂ, ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತ ನಿಯಮವಾಗಿರಬೇಕು. ಆದರೆ ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ಲೇವಿಯರಿಗೆ ಸ್ವಂತವಾದ ಸ್ವತ್ತು ಇರುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ಇಸ್ರಾಯೇಲರು ಪ್ರತ್ಯೇಕಿಸಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವ ಹತ್ತನೆಯ ಒಂದು ಭಾಗವನ್ನು ಲೇವಿಯರಿಗೆ ಸ್ವತ್ತಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ಆದುದರಿಂದ ಲೇವಿಯರಿಗೆ ‘ಇತರ ಇಸ್ರಾಯೇಲರೊಂದಿಗೆ ಪಾಲು ದೊರೆಯುವುದಿಲ್ಲ’” ಎಂದು ಹೇಳಿದ ಮಾತಿಗೆ ಇದೇ ಕಾರಣ. ");
INSERT INTO kanirv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ನೀನು ಲೇವಿಯರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ಇಸ್ರಾಯೇಲರ ಸ್ವಂತಕ್ಕಾಗಿ ನಾನು ನೇಮಿಸಿರುವ ಹತ್ತನೆಯ ಒಂದು ಭಾಗವನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ನೀವು ಹೀಗೆ ಸಮರ್ಪಿಸಿದ ಹತ್ತನೆಯ ಒಂದು ಭಾಗದ ಕಣದಲ್ಲಿನ ಧಾನ್ಯವನ್ನೂ, ದ್ರಾಕ್ಷಿತೊಟ್ಟಿಯ ರಸದಿಂದ ಬರಬೇಕಾದ ದಶಮಾಂಶವೆಂದು ಪರಿಗಣಿಸಲ್ಪಡುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ಇಸ್ರಾಯೇಲರಿಂದ ನಿಮಗೆ ಸಲ್ಲುವ ಹತ್ತನೆಯ ಒಂದು ಭಾಗವನ್ನು ಯೆಹೋವನಿಗೆ ಪ್ರತ್ಯೇಕಿಸಿ ಯಾಜಕನಾದ ಆರೋನನಿಗೆ ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ನಿಮಗೆ ಕೊಡಲ್ಪಡುವ ಸಕಲ ಪದಾರ್ಥಗಳಲ್ಲಿಯೂ ನೀವು ಉತ್ತಮ ಭಾಗವನ್ನೇ ದೇವರ ವಸ್ತುವಾಗುವುದಕ್ಕೆ ಯೋಗ್ಯಭಾಗವನ್ನೇ ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿ ಸಮರ್ಪಿಸಬೇಕು’ ");
INSERT INTO kanirv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ಆದುದರಿಂದ ನೀನು ಲೇವಿಯರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು, ‘ನಿಮಗೆ ದೊರಕಿದ್ದರಲ್ಲಿ ನೀವು ಉತ್ತಮವಾದದ್ದನ್ನೇ ಪ್ರತ್ಯೇಕಿಸಿ ಸಮರ್ಪಿಸಿದ ಮೇಲೆ ಉಳಿದದ್ದನ್ನು ಕಣದಲ್ಲಿನ ದವಸದ ಹಾಗೂ, ದ್ರಾಕ್ಷಿತೊಟ್ಟಿಯ ರಸವೆಂದು ಭಾವಿಸಿ ಉಪಯೋಗಿಸಿಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ನೀವೂ, ನಿಮ್ಮ ಮನೆಯವರೂ ಅದನ್ನು ಎಲ್ಲಾ ಸ್ಥಳಗಳಲ್ಲಿ ಊಟಮಾಡಬಹುದು. ನೀವು ದೇವದರ್ಶನದ ಗುಡಾರದ ಸೇವಾಕಾರ್ಯವನ್ನು ಮಾಡಿದ್ದಕ್ಕೆ ಅದು ನಿಮಗೆ ದೊರೆಯುವ ಪ್ರತಿಫಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ಅದರಲ್ಲಿ ಉತ್ತಮ ಭಾಗವನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿದ ನಂತರ ನೀವು ಉಳಿದ ವಿಷಯದಲ್ಲಿ ಯಾವ ದೋಷಕ್ಕೂ ಗುರಿಯಾಗುವುದಿಲ್ಲ. ಇಸ್ರಾಯೇಲರು ಸಮರ್ಪಿಸುವ ದೇವರ ವಸ್ತುಗಳನ್ನು ಅಪವಿತ್ರಮಾಡಿದರೆ ನೀವು ಸಾಯುವಿರಿ’” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಿದನು, ");
INSERT INTO kanirv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ಯೆಹೋವನಾದ ನಾನು ಒಂದು ನಿಯಮವನ್ನು ನೇಮಿಸಿದ್ದೇನೆ, ಅದೇನೆಂದರೆ: ಎಂದೂ ನೊಗವನ್ನು ಹೊರದ ಮತ್ತು ಯಾವ ದೋಷವಿಲ್ಲದ ಪೂರ್ಣಾಂಗವಾದ ಕೆಂದಾಕಳನ್ನು ನಿಮಗೆ ತಂದುಕೊಡಬೇಕೆಂದು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ಅದನ್ನು ನೀವು ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ ಕೈಗೆ ಒಪ್ಪಿಸಬೇಕು. ಅವನು ಅದನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಹೊರಡಿಸಿಕೊಂಡು ಹೋಗಿ ತನ್ನ ಎದುರೇ ಒಬ್ಬನ ಕೈಯಿಂದ ವಧೆಮಾಡಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ತರುವಾಯ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಬೆರಳಿನಿಂದ ದೇವದರ್ಶನದ ಗುಡಾರದ ಮುಂಭಾಗದ ಕಡೆಗೆ ಏಳು ಸಾರಿ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ಆಗ ಅವನು ಆ ಆಕಳನ್ನು ಚರ್ಮ, ಮಾಂಸ, ರಕ್ತ, ಕಲ್ಮಷಗಳ ಸಹಿತವಾಗಿ ತನ್ನ ಎದುರಿನಲ್ಲಿಯೇ ಸುಡಿಸಿಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ಯಾಜಕನು ದೇವದಾರುಮರದ ಕಟ್ಟಿಗೆಯನ್ನೂ, ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಬರಲನ್ನೂ, ರಕ್ತವರ್ಣವುಳ್ಳ ದಾರವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಆ ಆಕಳನ್ನು ಸುಡುವ ಬೆಂಕಿಯಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ಆ ಯಾಜಕನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಿದ ನಂತರ ಪಾಳೆಯದೊಳಗೆ ಬರಬಹುದು. ಆದರೆ ಆ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅವನು ಅಶುದ್ಧನಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ಆ ಆಕಳನ್ನು ಸುಟ್ಟವನೂ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಿ ಆ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ಶುದ್ಧನಾದವನೊಬ್ಬನು ಆ ಆಕಳಿನ ಬೂದಿಯನ್ನು ಕೂಡಿಸಿ ಪಾಳೆಯದ ಹೊರಗೆ ಶುದ್ಧವಾದ ಸ್ಥಳದಲ್ಲಿ ಇಡಬೇಕು. ಅದನ್ನು ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರ ಉಪಯೋಗಕ್ಕಾಗಿ ನೀವು ಜೋಪಾನಮಾಡಬೇಕು. ಆದುದರಿಂದ ಶುದ್ಧೀಕರಣದ ನೀರನ್ನು ಸಿದ್ಧಪಡಿಸುವುದಕ್ಕಾಗಿ ಅದನ್ನು ಅಲ್ಲೇ ಇಟ್ಟಿರಬೇಕು. ಅದು ಅಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ಆ ಕೆಂದಾಕಳ ಬೂದಿಯನ್ನು ಕೂಡಿಸಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ಆ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು. ಇದು ಇಸ್ರಾಯೇಲರಿಗೂ ಮತ್ತು ಅವರಲ್ಲಿರುವ ಪ್ರವಾಸಿಗರಿಗೂ ಶಾಶ್ವತ ನಿಯಮವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ಮನುಷ್ಯನ ಶವ ಸೋಂಕಿದವನು ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಆ ಬೂದಿಯಿಂದ ದೋಷಪರಿಹಾರ ಮಾಡಿಕೊಂಡು ಏಳನೆಯ ದಿನದಲ್ಲಿ ಶುದ್ಧನಾಗುವನು. ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಅವನು ದೋಷಪರಿಹಾರ ಮಾಡಿಕೊಳ್ಳದೆ ಹೋದರೆ ಏಳನೆಯ ದಿನದಲ್ಲಿಯೂ ಶುದ್ಧನಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ಮನುಷ್ಯನ ಶವ ಸೋಂಕಿದವನು ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿಕೊಳ್ಳದೆಹೋದರೆ ಅವನು ಯೆಹೋವನ ಗುಡಾರವನ್ನು ಅಪವಿತ್ರಪಡಿಸುವನು. ಅಂಥವನನ್ನು ಇಸ್ರಾಯೇಲರಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ಶುದ್ಧೀಕರಣದ ನೀರನ್ನು ತನ್ನ ಮೇಲೆ ಚಿಮಿಕಿಸಿಕೊಳ್ಳದೆ ಇರುವುದರಿಂದ ಅವನು ಅಶುದ್ಧನು. ಅವನ ಅಶುದ್ಧತ್ವವು ಇನ್ನೂ ಅವನ ಮೇಲೆ ಇರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ಯಾರಾದರೂ ಡೇರೆಯಲ್ಲಿ ಸತ್ತರೆ ಅವನ ವಿಷಯವಾದ ನಿಯಮವೇನೆಂದರೆ: ಆ ಡೇರೆಯಲ್ಲಿರುವವರೆಲ್ಲರೂ ಮತ್ತು ಅದರೊಳಗೆ ಪ್ರವೇಶಿಸುವವರು ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧರಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ಮುಚ್ಚಳ ಹಾಕದೆ ತೆರೆದಿರುವ ಎಲ್ಲಾ ಪಾತ್ರೆಗಳು ಅಶುದ್ಧವಾಗಿರುವವು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ಬಯಲಿನಲ್ಲಿರುವ ಯಾವನಾದರೂ ಕತ್ತಿಯಿಂದ ಕೊಲ್ಲಲ್ಪಟ್ಟವನಾದರೂ, ಯಾವನಿಗಾದರೂ ಮನುಷ್ಯನ ಶವವಾಗಲಿ, ಮನುಷ್ಯನ ಎಲುಬಾಗಲಿ, ಸಮಾಧಿಯಾಗಲಿ ಸೋಂಕಿದರೆ ಅವನು ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ಅಶುದ್ಧನಾದವನನ್ನು ಶುದ್ಧಪಡಿಸಬೇಕಾದರೆ ಆ ದೋಷಪರಿಹಾರಕವಾದ ಬೂದಿಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಪಾತ್ರೆಯಲ್ಲಿ ಇಟ್ಟು, ಅದರ ಮೇಲೆ ಶುದ್ಧವಾದ ನೀರನ್ನು ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ಆಗ ಶುದ್ಧನಾದವನೊಬ್ಬನು ಆ ನೀರನ್ನು ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಬರಲಿಂದ ಮನುಷ್ಯನು ಸತ್ತ ಆ ಡೇರೆಯ ಮೇಲೆಯೂ, ಅದರಲ್ಲಿದ್ದ ಸಾಮಾನುಗಳ ಮತ್ತು ಮನುಷ್ಯರ ಮೇಲೆಯೂ ಚಿಮಿಕಿಸಬೇಕು. ಹಾಗೆಯೇ ಎಲುಬಾಗಲಿ, ಹತವಾದವನ ಅಥವಾ ಬೇರೆ ಮನುಷ್ಯನ ಶವವಾಗಲಿ, ಸಮಾಧಿಯಾಗಲಿ ಯಾವನಿಗೆ ಸೋಂಕುವುದೋ ಅವನ ಮೇಲೆಯೂ ನೀರನ್ನು ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ಶುದ್ಧನಾದವನು ಮೂರನೆಯ ದಿನದಲ್ಲಿಯೂ, ಏಳನೆಯ ದಿನದಲ್ಲಿಯೂ ಅಶುದ್ಧನಾದವನ ಮೇಲೆ ಅದನ್ನು ಚಿಮಿಕಿಸಬೇಕು. ಅಶುದ್ಧನಾದವನು ಏಳನೆಯ ದಿನದಲ್ಲಿ ದೋಷಪರಿಹಾರ ಹೊಂದಿದವನಾಗಿ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು, ಸ್ನಾನಮಾಡಿ ಸಾಯಂಕಾಲದಲ್ಲಿ ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ಅಶುದ್ಧನಾಗಿ ದೋಷಪರಿಹಾರ ಮಾಡಿಕೊಳ್ಳದವನು ಯೆಹೋವನ ಆಲಯವನ್ನು ಅಪವಿತ್ರಪಡಿಸಿದ ಕಾರಣ ಸಭೆಯಿಂದ ತೆಗೆಯಲ್ಪಡಬೇಕು. ಶುದ್ಧೀಕರಣದ ನೀರನ್ನು ತನ್ನ ಮೇಲೆ ಚಿಮಿಕಿಸಿಕೊಳ್ಳದೆ ಹೋದುದರಿಂದ ಅವನು ಅಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","“ಇದು ಇಸ್ರಾಯೇಲರಿಗೆ ಶಾಶ್ವತ ನಿಯಮವಾಗಿರುವುದು. ಶುದ್ಧೀಕರಣದ ಆ ನೀರನ್ನು ಚಿಮಿಕಿಸಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಳ್ಳಬೇಕು ಮತ್ತು ಆ ನೀರು ಯಾರಿಗೆ ಸೋಂಕುವುದೋ ಅವನು ಆ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ಅಶುದ್ಧನಿಗೆ ಸೋಂಕಿದ ವಸ್ತು ಯಾವುದೇ ಆಗಲಿ ಅಶುದ್ಧವೆಂದು ನೀವು ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ಅದು ಯಾರಿಗೆ ಸೋಂಕುವುದೋ ಅವನೂ ಆ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ಮೊದಲನೆಯ ತಿಂಗಳಿನಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರು “ಚಿನ್” ಎಂಬ ಮರುಭೂಮಿಗೆ ಬಂದು, ಕಾದೇಶಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ಅಲ್ಲಿ ಮಿರ್ಯಾಮಳು ತೀರಿಹೋದಳು. ಆಕೆಯ ಶವವನ್ನು ಅಲ್ಲಿಯೇ ಸಮಾಧಿಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ಸಮೂಹದವರಿಗೆ ನೀರು ಇಲ್ಲದ ಕಾರಣ ಅವರು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಕೂಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ಜನರು ಮೋಶೆಯ ಸಂಗಡ ವ್ಯಾಜ್ಯವಾಡಿ, “ನಮ್ಮ ಜನರು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸತ್ತುಹೋದಾಗಲೇ ನಾವೂ ಸಹ ಸತ್ತುಹೋಗಿದ್ದರೆ ಎಷ್ಟೋ ಒಳ್ಳೆಯದಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ನೀವು ಯೆಹೋವನ ಸಮೂಹದವರಾದ ನಮ್ಮನ್ನೂ, ನಮ್ಮ ಪಶುಗಳನ್ನೂ ಈ ಮರಳುಗಾಡಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದು ಯಾಕೆ ಸಾಯಿಸುತ್ತೀರಿ? ");
INSERT INTO kanirv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ನಮ್ಮನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಬರಮಾಡಿ ಈ ಕೆಟ್ಟ ಸ್ಥಳಕ್ಕೆ ಯಾಕೆ ಕರೆದುಕೊಂಡು ಬಂದಿದ್ದೀರಿ? ಈ ನೆಲದಲ್ಲಿ ಧಾನ್ಯವೂ, ಅಂಜೂರವೂ, ದ್ರಾಕ್ಷಿಯೂ, ದಾಳಿಂಬೆಯೂ ಮತ್ತು ಕುಡಿಯುವುದಕ್ಕೆ ನೀರೂ ಸಹ ಸಿಕ್ಕುವುದಿಲ್ಲ” ಎಂದು ಹೇಳುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಜನಸಮೂಹದ ಎದುರಿನಿಂದ ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಹೋಗಿ ಬೋರಲುಬಿದ್ದಾಗ ಯೆಹೋವನ ತೇಜಸ್ಸು ಅವರಿಗೆ ಕಾಣಿಸಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ಆಗ ಯೆಹೋವನು ಮೋಶೆ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ನೀನು ಕೋಲನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದು ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನ ಜೊತೆಯಲ್ಲಿ ಸಮೂಹದವರನ್ನು ಕೂಡಿಸಿಕೊಂಡು ಅವರ ಎದುರಿನಲ್ಲೇ ಆ ಕಡಿದಾದ ಬಂಡೆಗೆ ನೀರುಕೊಡಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸು. ಅದರೊಳಗಿಂದ ನೀರು ಹೊರಟುಬರುವುದು, ನೀನು ಸಮೂಹದವರಿಗೂ, ಅವರ ಪಶುಗಳಿಗೂ ನೀರನ್ನು ಕುಡಿಯುವುದಕ್ಕೆ ಕೊಡಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆಯು ಆ ಕೋಲನ್ನು ಆತನ ಸನ್ನಿಧಿಯಿಂದ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ಮೋಶೆ ಮತ್ತು ಆರೋನರು ಸಮೂಹದವರನ್ನು ಆ ಕಡಿದಾದ ಬಂಡೆಗೆ ಎದುರಾಗಿ ಕೂಡಿಸಿದರು. ಮೋಶೆ ಅವರಿಗೆ, “ದ್ರೋಹಿಗಳೇ, ಕೇಳಿರಿ, ನಾವು ಈ ಬಂಡೆಯೊಳಗಿಂದಲೇ ನಿಮಗೋಸ್ಕರ ನೀರನ್ನು ಬರಮಾಡಬೇಕೋ?” ");
INSERT INTO kanirv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ಆಗ ಮೋಶೆ ತನ್ನ ಕೈಯನ್ನು ಮೇಲಕ್ಕೆ ಎತ್ತಿ ಕೋಲಿನಿಂದ ಬಂಡೆಯನ್ನು ಎರಡು ಸಾರಿ ಹೊಡೆದನು. ಆಗ ನೀರು ಪ್ರವಾಹವಾಗಿ ಹೊರಟಿತು. ಸಮೂಹದವರೂ ಮತ್ತು ಅವರ ಪಶುಗಳೂ ನೀರು ಕುಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ಆಗ ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ, “ನೀವು ನನ್ನನ್ನು ನಂಬದವರಾಗಿ ಇಸ್ರಾಯೇಲರ ಎದುರಿನಲ್ಲಿ ನನ್ನ ಗೌರವವನ್ನು ಕಾಪಾಡದೆ ಹೋದುದರಿಂದ ಈ ಸಮೂಹದವರಿಗೆ ವಾಗ್ದಾನಮಾಡಿದ ದೇಶಕ್ಕೆ ನೀವು ಅವರನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ಇಸ್ರಾಯೇಲರು ಅಲ್ಲಿ ಯೆಹೋವನ ಸಂಗಡ ವಾದಮಾಡಿದ್ದರಿಂದ ಆ ನೀರು ಬಂದ ಸ್ಥಳಕ್ಕೆ “ಮೆರೀಬಾ” ಎಂದು ಹೆಸರಾಯಿತು. ಅದಲ್ಲದೆ ಅಲ್ಲಿ ಯೆಹೋವನು ತನ್ನ ಪರಿಶುದ್ಧತೆಯನ್ನು ತೋರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ಮೋಶೆ ಕಾದೇಶಿನಿಂದ ಎದೋಮ್ಯರ ಅರಸನ ಬಳಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ, “ನಮ್ಮ ಸಂಬಂಧಿಕರಾದ ಇಸ್ರಾಯೇಲರು ಕೇಳಿಕೊಳ್ಳುವುದೇನೆಂದರೆ, ನಮಗೆ ಸಂಭವಿಸಿದ ಎಲ್ಲಾ ಕಷ್ಟವನ್ನು ತಾವು ಕೇಳಿದ್ದೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ನಮ್ಮ ಪೂರ್ವಿಕರು ಐಗುಪ್ತ ದೇಶಕ್ಕೆ ಇಳಿದು ಹೋದರು. ಅವರು ಅಲ್ಲಿ ಬಹುದಿನ ವಾಸವಾಗಿದ್ದರು. ಐಗುಪ್ತ್ಯರು ನಮ್ಮನ್ನೂ ಮತ್ತು ನಮ್ಮ ಪೂರ್ವಿಕರನ್ನೂ ಉಪದ್ರವಪಡಿಸಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ನಾವು ಯೆಹೋವನಿಗೆ ಮೊರೆಯಿಡಲಾಗಿ, ಆತನು ನಮ್ಮ ಪ್ರಾರ್ಥನೆಯನ್ನು ಕೇಳಿ ದೂತನನ್ನು ಕಳುಹಿಸಿ, ನಮ್ಮನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಬಿಡುಗಡೆಮಾಡಿದನು. ಈಗ ನಾವು ನಮ್ಮ ರಾಜ್ಯದ ಗಡಿಯಲ್ಲಿರುವ ಕಾದೇಶ್ ಎಂಬ ಊರಿನಲ್ಲಿದ್ದೇವೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ತಮ್ಮ ದೇಶವನ್ನು ದಾಟಿಹೋಗುವುದಕ್ಕೆ ನಮಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕೆಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತೇವೆ. ನಾವು ಹೊಲವನ್ನಾದರೂ, ದ್ರಾಕ್ಷಿತೋಟವನ್ನಾದರೂ ದಾಟಿ ಹೋಗುವುದಿಲ್ಲ. ಬಾವಿಗಳ ನೀರನ್ನು ಕುಡಿಯುವುದಿಲ್ಲ. ರಾಜಮಾರ್ಗದಲ್ಲಿಯೇ ನಡೆದು ನಮ್ಮ ದೇಶದ ಗಡಿಯನ್ನು ದಾಟುವ ತನಕ ಬಲಕ್ಕಾಗಲಿ, ಎಡಕ್ಕಾಗಲಿ ತಿರುಗುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ಆದರೆ ಎದೋಮ್ಯರು, “ನಮ್ಮ ದೇಶವನ್ನು ನೀವು ದಾಟಿ ಹೋಗಬಾರದು. ದಾಟುವುದಾದರೆ ನಾವು ನಿಮ್ಮ ಮೇಲೆ ಯುದ್ಧಕ್ಕೆ ಬರುತ್ತೇವೆ” ಎಂದು ಉತ್ತರಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ಅದಕ್ಕೆ ಇಸ್ರಾಯೇಲರು, “ನಾವು ರಾಜಮಾರ್ಗದಲ್ಲಿಯೇ ಹೋಗುವೆವು. ನಾವೂ ಮತ್ತು ನಮ್ಮ ಪಶುಗಳೂ ನಿಮ್ಮ ನೀರನ್ನು ಕುಡಿದರೆ ಅದರ ಬೆಲೆ ಕೊಡುವೆವು. ಬೇರೆ ಏನನ್ನು ಮಾಡದೆ, ಕಾಲ್ನಡೆಯಾಗಿ ದಾಟಿಹೋಗುವುದಕಷ್ಟೇ ನಮಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ಆದರೆ ಎದೋಮ್ಯರು, “ನೀವು ದಾಟಲೇ ಬಾರದು” ಎಂದು ಉತ್ತರಕೊಟ್ಟು ಬಹುಜನರನ್ನು ಕೂಡಿಸಿಕೊಂಡು ಇಸ್ರಾಯೇಲರಿಗೆ ಎದುರಾಗಿ ಯುದ್ಧಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ಎದೋಮ್ಯರು ಇಸ್ರಾಯೇಲರಿಗೆ ತಮ್ಮ ಪ್ರದೇಶದೊಳಗೆ ದಾಟಿಹೋಗುವುದಕ್ಕೆ ಅಪ್ಪಣೆಕೊಡದೆ ಹೋದುದರಿಂದ ಇಸ್ರಾಯೇಲರು ಅವರ ಕಡೆಯಿಂದ ತಿರುಗಿಕೊಂಡು ಬೇರೊಂದು ಮಾರ್ಗವಾಗಿ ಹೊರಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ಆಗ ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರು ಕಾದೇಶಿನಿಂದ ಹೊರಟು ಹೋರ್ ಎಂಬ ಬೆಟ್ಟಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ಯೆಹೋವನು ಎದೋಮ್ಯರ ದೇಶದ ಗಡಿಯ ಹತ್ತಿರವಿರುವ ಹೋರ್ ಎಂಬ ಬೆಟ್ಟದ ಬಳಿಯಲ್ಲಿ ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“ಆರೋನನು ತನ್ನ ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರುವನು. ನೀವಿಬ್ಬರೂ ಮೆರೀಬಾ ಪ್ರವಾಹದ ಹತ್ತಿರ ನನ್ನ ಮಾತಿಗೆ ವಿರುದ್ಧವಾಗಿ ತಿರುಗಿಬಿದ್ದುದರಿಂದ ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ ವಾಗ್ದಾನಮಾಡಿದ ದೇಶದೊಳಗೆ ಆರೋನನು ಸೇರಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ನೀನು ಆರೋನನನ್ನೂ, ಅವನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನನ್ನೂ ಕರೆದುಕೊಂಡು ಹೋರ್ ಬೆಟ್ಟಕ್ಕೆ ಬಾ. ");
INSERT INTO kanirv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ಆರೋನನ ವಸ್ತ್ರಗಳನ್ನು ತೆಗೆದು ಅವನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನಿಗೆ ತೊಡಿಸಬೇಕು. ಆರೋನನು ಅಲ್ಲಿ ತನ್ನ ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆ ಹೀಗೆ ಮಾಡಿದನು. ಸರ್ವಸಮೂಹದವರು ನೋಡುತ್ತಿರಲಾಗಿ ಅವರು ಹೋರ್ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ಮೋಶೆ ಆರೋನನ ವಸ್ತ್ರಗಳನ್ನು ತೆಗೆದು ಅವನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನಿಗೆ ತೊಡಿಸಿದನು. ಆರೋನನು ಅಲ್ಲೇ ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿ ಸತ್ತುಹೋದನು. ತರುವಾಯ ಮೋಶೆಯೂ ಮತ್ತು ಎಲ್ಲಾಜಾರನೂ ಬೆಟ್ಟದಿಂದ ಇಳಿದು ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ಆರೋನನು ಸತ್ತುಹೋದ ಸಂಗತಿಯನ್ನು ಇಸ್ರಾಯೇಲ್ ಸಮೂಹದವರು ಕೇಳಿ ಮೂವತ್ತು ದಿನಗಳು ಅವನಿಗಾಗಿ ಶೋಕಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ಕಾನಾನ್ ದೇಶದ ದಕ್ಷಿಣ ಪ್ರಾಂತ್ಯದಲ್ಲಿದ್ದ ಕಾನಾನ್ಯನಾದ ಅರಾದ್ ಪಟ್ಟಣದ ಅರಸನು, ಅತಾರೀಮ್ ಮಾರ್ಗವಾಗಿ ಇಸ್ರಾಯೇಲರು ಬರುತ್ತಾರೆಂಬ ವರ್ತಮಾನವನ್ನು ಕೇಳಿದಾಗ, ಅವನು ಅವರ ಮೇಲೆ ಯುದ್ಧಮಾಡಿ ಕೆಲವರನ್ನು ಸೆರೆಹಿಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ಇಸ್ರಾಯೇಲರು ಯೆಹೋವನಿಗೆ ಪ್ರಮಾಣಮಾಡಿ, “ನಾವು ಈ ಜನರನ್ನು ಜಯಿಸುವಂತೆ ನೀನು ಅನುಗ್ರಹಿಸಿದರೆ ನಾವು ಅವರ ಗ್ರಾಮಗಳನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ನಾಶಮಾಡುತ್ತೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರ ಪ್ರಾರ್ಥನೆಯನ್ನು ಕೇಳಿ ಕಾನಾನ್ಯರನ್ನು ಜಯಿಸುವಂತೆ ಮಾಡಿದನು. ಅವರನ್ನು ಮತ್ತು ಅವರ ಪಟ್ಟಣಗಳನ್ನು ಇಸ್ರಾಯೇಲರು ಸಂಪೂರ್ಣವಾಗಿ ನಾಶಮಾಡಿದರು. ಆ ಸ್ಥಳಕ್ಕೆ ಹೊರ್ಮಾ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ಇಸ್ರಾಯೇಲರು ಹೋರ್ ಬೆಟ್ಟದಿಂದ ಹೊರಟು ಎದೋಮ್ಯರ ದೇಶವನ್ನು ಸುತ್ತಿಕೊಂಡು ಹೋಗುವುದಕ್ಕೆ ಕೆಂಪು ಸಮುದ್ರದ ಮಾರ್ಗವಾಗಿ ಪ್ರಯಾಣಮಾಡುವಾಗ, ದಾರಿಯಲ್ಲಿ ಆಯಾಸದಿಂದ ಅವರಿಗೆ ಬೇಸರವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ಆಗ ಅವರು ದೇವರಿಗೂ ಮತ್ತು ಮೋಶೆಗೂ ವಿರುದ್ಧವಾಗಿ ಮಾತನಾಡಿ, “ನೀವು ನಮ್ಮನ್ನು ಈ ಮರಳುಗಾಡಿನಲ್ಲಿ ಕೊಲ್ಲಬೇಕೆಂದು ಐಗುಪ್ತ ದೇಶದಿಂದ ಕರೆದುಕೊಂಡು ಬಂದಿರೋ? ಇಲ್ಲಿ ಆಹಾರವೂ ಇಲ್ಲ, ನೀರೂ ಇಲ್ಲ. ಈ ರುಚಿ ಇಲ್ಲದ ಆಹಾರವನ್ನು ತಿಂದು ನಮಗೆ ಬೇಸರವಾಯಿತು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ಅದಕ್ಕೆ ಯೆಹೋವನು ವಿಷಸರ್ಪಗಳನ್ನು ಇಸ್ರಾಯೇಲ್ ಜನರೊಳಗೆ ಬರಮಾಡಿದನು. ಅವು ಜನರನ್ನು ಕಚ್ಚಿದ್ದರಿಂದ ಬಹಳಜನರು ಸತ್ತುಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ಆದುದರಿಂದ ಜನರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು, “ನಾವು ನಿನಗೂ ಮತ್ತು ಯೆಹೋವನಿಗೂ ವಿರುದ್ಧವಾಗಿ ಮಾತನಾಡಿ ದ್ರೋಹಿಗಳಾದೆವು. ಈ ಸರ್ಪಗಳು ನಮ್ಮ ಬಳಿಯಿಂದ ತೊಲಗಿಹೋಗುವಂತೆ ನೀನು ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥನೆಮಾಡಬೇಕು” ಎಂದು ಬೇಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ಮೋಶೆ ಜನರಿಗೋಸ್ಕರ ಪ್ರಾರ್ಥಿಸಲಾಗಿ ಯೆಹೋವನು ಅವನಿಗೆ, “ನೀನು ತಾಮ್ರದಿಂದ ವಿಷಸರ್ಪದ ಆಕಾರವನ್ನು ಮಾಡಿಸಿ ಧ್ವಜಸ್ತಂಭದ ಮೇಲೆ ಎತ್ತಿ ನಿಲ್ಲಿಸಬೇಕು. ಸರ್ಪಗಳಿಂದ ಗಾಯಪಟ್ಟವರು ಅದನ್ನು ನೋಡಿ ಬದುಕಿಕೊಳ್ಳುವರು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ಆದಕಾರಣ ಮೋಶೆ ತಾಮ್ರದಿಂದ ಸರ್ಪವನ್ನು ಮಾಡಿಸಿ ಧ್ವಜಸ್ತಂಭದ ಮೇಲೆ ಇಟ್ಟನು. ಸರ್ಪದಿಂದ ಗಾಯಪಟ್ಟವರಲ್ಲಿ ಯಾರು ಆ ತಾಮ್ರದ ಸರ್ಪವನ್ನು ಲಕ್ಷ್ಯವಿಟ್ಟು ನೋಡಿದರೋ ಅವರೆಲ್ಲರೂ ಬದುಕಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ತರುವಾಯ ಇಸ್ರಾಯೇಲರು ಅಲ್ಲಿಂದ ಹೊರಟು ಓಬೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ಓಬೋತಿನಿಂದ ಹೊರಟು ಮೋವಾಬ್ ದೇಶದ ಮೂಡಲ ದಿಕ್ಕಿನ ಅರಣ್ಯದಲ್ಲಿರುವ ಇಯ್ಯೇ ಅಬಾರೀಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ಅಲ್ಲಿಂದ ಹೊರಟು ಜೆರೆದ್ ತಗ್ಗಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ಅಲ್ಲಿಂದ ಹೊರಟು ಅರ್ನೋನ್ ನದಿಯ ಆಚೆ ಕಡೆಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ಅರ್ನೋನ್ ನದಿಯು ಅಮೋರಿಯರ ಪ್ರದೇಶದಿಂದಾಚೆ ಇರುವ ಅರಣ್ಯದಲ್ಲಿ ಮೋವಾಬ್ಯರಿಗೂ, ಅಮೋರಿಯರಿಗೂ ನಡುವೆ ಇದ್ದು ಮೋವಾಬ್ಯರ ಗಡಿಯಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ಅದಕ್ಕೆ ಅನುಗುಣವಾಗಿ ಯೆಹೋವವಿಜಯ ಎಂಬ ಗ್ರಂಥದಲ್ಲಿ, “ಸೂಫಕ್ಕೆ ಸೇರಿದ ವಾಹೇಬನ್ನೂ, ಮತ್ತು ಅರ್ನೋನ್ ನದಿಗೆ ಕೂಡುವ ಹಳ್ಳಗಳನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ಆರ್ ಪಟ್ಟಣದ ತನಕ ಮೋವಾಬಿನ ಮೇರೆಯಾಗಿರುವ ಕೊರಕಲನ್ನೂ ದಾಟಿದ್ದಾಯಿತು” ಎಂದು ಬರೆದದೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ಅಲ್ಲಿಂದ ಅವರು ಬೇರ್ ಸ್ಥಳಕ್ಕೆ ಬಂದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ ಮಾತು ಇಲ್ಲಿನ ಬಾವಿಯ ವಿಷಯವೇ. ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಜನರನ್ನು ಸೇರಿಸು. ನಾನು ಅವರಿಗೆ ನೀರನ್ನು ಕೊಡುವೆನು” ಅಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ಆಗ ಇಸ್ರಾಯೇಲರು ಈ ಹಾಡನ್ನು ಗಾನಮಾಡಿದರು; “ಬಾವಿಯೇ, ಉಕ್ಕುತ್ತಾ ಬಾ! ಜನರೇ, ಉಲ್ಲಾಸದಿಂದ ಗಾನಮಾಡಿರಿ ");
INSERT INTO kanirv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ಇದು ಪ್ರಧಾನರು ಕೋಲುಗಳಿಂದ ತೋಡಿದ ಬಾವಿ, ಇದು ಜನಾಧಿಪತಿಗಳು ಕೋಲುಗಳಿಂದ ಅಗೆದ ಬಾವಿ” ಎಂಬುವುದೇ. ಅವರು ಅರಣ್ಯವನ್ನು ಬಿಟ್ಟು ಮತ್ತಾನಕ್ಕೂ, ");
INSERT INTO kanirv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ಮತ್ತಾನದಿಂದ ನಹಲೀಯೇಲಿಗೂ, ನಹಲೀಯೇಲಿನಿಂದ ಬಾಮೋತಿಗೂ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ಬಾಮೋತಿನಿಂದ ಮೋವಾಬ್ಯರ ಬಯಲಿನಲ್ಲಿರುವ ತಗ್ಗಿನಿಂದ ಪಿಸ್ಗಾ ಎಂಬ ಬೆಟ್ಟದ ತುದಿಗೆ ಬಂದರು. ಅಲ್ಲಿಂದ ಯೆಷೀಮೋನ್ ಮರಳುಗಾಡು ಕಾಣಿಸುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ಇಸ್ರಾಯೇಲರು ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನ ಬಳಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ನಿನ್ನ ದೇಶವನ್ನು ದಾಟಿಹೋಗುವುದಕ್ಕೆ ನಮಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು. ನಾವು ಹೊಲಗಳಲ್ಲಿಯಾಗಲಿ, ದ್ರಾಕ್ಷಿತೋಟಗಳಲ್ಲಿಯಾಗಲಿ ಹೋಗುವುದಿಲ್ಲ. ಬಾವಿಗಳ ನೀರನ್ನು ಕುಡಿಯುವುದಿಲ್ಲ. ನಿನ್ನ ದೇಶವನ್ನು ದಾಟುವವರೆಗೂ ರಾಜಮಾರ್ಗದಲ್ಲಿಯೇ ನಡೆದು ಹೋಗುವೆವು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ಆದರೆ ತನ್ನ ಸೀಮೆಯನ್ನು ದಾಟಿಹೋಗುವುದಕ್ಕೆ ಸೀಹೋನನು ಇಸ್ರಾಯೇಲರಿಗೆ ಅಪ್ಪಣೆಕೊಡದೆ ತನ್ನ ಜನರೆಲ್ಲರನ್ನೂ ಕೂಡಿಸಿಕೊಂಡು ಅವರನ್ನು ಎದುರಿಸುವುದಕ್ಕೆ ಮರುಭೂಮಿಗೆ ಹೊರಟರು. ಅವನು ಯಹಚಕ್ಕೆ ಬಂದು ಅವರೊಡನೆ ಯುದ್ಧಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ಇಸ್ರಾಯೇಲರು ಅವನ ಜನರನ್ನು ಸೋಲಿಸಿ, ಕತ್ತಿಯಿಂದ ಸಂಹರಿಸಿ ಅರ್ನೋನ್ ನದಿ ಮೊದಲುಗೊಂಡು ಯಬ್ಬೋಕ್ ನದಿಯವರೆಗೂ, ಅಮ್ಮೋನಿಯರ ಗಡಿಯವರೆಗೂ ಸೀಹೋನನ ದೇಶವನ್ನೆಲ್ಲಾ ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡರು. ಏಕೆಂದರೆ ಅಮ್ಮೋನಿಯರ ಮಕ್ಕಳ ಗಡಿಯು ಬಲವುಳ್ಳದ್ದಾಗಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ಇಸ್ರಾಯೇಲರು ಈ ಪಟ್ಟಣಗಳನ್ನೆಲ್ಲಾ ವಶಮಾಡಿಕೊಂಡರು. ಅವರು ಹೆಷ್ಬೋನಿನಲ್ಲಿಯೂ, ಅದಕ್ಕೆ ಸೇರಿದ ಗ್ರಾಮಗಳಲ್ಲಿಯೂ, ಅಮೋರಿಯರ ಬೇರೆ ಎಲ್ಲಾ ಊರುಗಳಲ್ಲಿಯೂ ವಾಸಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ಹೆಷ್ಬೋನ್ ಪಟ್ಟಣವು ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನ ರಾಜಧಾನಿ. ಅವನು ಮೋವಾಬ್ಯರ ಪೂರ್ವದ ಅರಸನ ಮೇಲೆ ಯುದ್ಧಮಾಡಿ ಅರ್ನೋನ್ ನದಿಯ ವರೆಗೂ ಅವನ ದೇಶವನ್ನೆಲ್ಲಾ ಸ್ವಾಧೀನ ಮಾಡಿಕೊಂಡಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ಕವಿಗಳು ಹೇಳಿದ ಪದ್ಯವು ಇದರ ವಿಷಯವಾಗಿಯೇ; “ಹೆಷ್ಬೋನಿಗೆ ಬನ್ನಿರಿ. ಅದನ್ನು ಹೊಸದಾಗಿ ಕಟ್ಟಬೇಕು, ಸೀಹೋನನ ಪಟ್ಟಣವನ್ನು ಪುನಃಸ್ಥಾಪನೆಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ಸೀಹೋನನ ಪಟ್ಟಣವಾದ ಹೆಷ್ಬೋನಿನಿಂದ ಅಗ್ನಿ ಜ್ವಾಲೆಹೊರಟು, ಮೋವಾಬ್ಯರ ರಾಜಧಾನಿಯಾದ ಆರ್ ಎಂಬ ಪಟ್ಟಣವನ್ನೂ ಅರ್ನೋನ್ ಬೆಟ್ಟದ ಮೇಲಿರುವ ಪ್ರಭುಗಳನ್ನು ದಹಿಸಿಬಿಟ್ಟಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ಮೋವಾಬ್ಯರೇ, ನಿಮ್ಮ ಗತಿಯೇನೆಂದು ಹೇಳಲಿ! ಕೆಮೋಷಿನ ಭಕ್ತರೇ, ನಿಮಗೆ ದುರ್ಗತಿಯುಂಟಾಯಿತು. ಆತನು ತನ್ನ ಗಂಡುಮಕ್ಕಳನ್ನು ದೇಶಭ್ರಷ್ಟರನ್ನಾಗಿ ಮಾಡಿದನು. ನಿನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಸೆರೆಯವರನ್ನಾಗಿಯೂ ಮಾಡಿದ್ದಾನಲ್ಲಾ. ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನಿಗೆ ಸೆರೆಯವರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ನಾವು ಅವರನ್ನು ಬಾಣದಿಂದ ಹೊಡೆದೆವು; ಹೆಷ್ಬೋನಿನಿಂದ ದೀಬೋನಿವರೆಗೂ ಎಲ್ಲಾ ನಾಶವಾಯಿತು. ಮೇದೆಬಾ ಊರಿನ ನೆರೆಯಲ್ಲಿರುವ ನೋಫಹದ ತನಕ ಹಾಳುಮಾಡಿ ಬಿಟ್ಟೆವು.” ");
INSERT INTO kanirv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ಹೀಗೆ ಇಸ್ರಾಯೇಲರು ಅಮ್ಮೋರಿಯರ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡುವಂತಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ಅದಲ್ಲದೆ ಮೋಶೆ ಗೂಢಚಾರರ ಮೂಲಕ ಯಗ್ಜೇರನ್ನು ಪರೀಕ್ಷಿಸಿದ ಮೇಲೆ ಇಸ್ರಾಯೇಲರು ಅದರ ಗ್ರಾಮಗಳನ್ನು ವಶಪಡಿಸಿಕೊಂಡು, ಅಲ್ಲಿದ್ದ ಅಮೋರಿಯರನ್ನು ಹೊರಡಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ಇಸ್ರಾಯೇಲರು ಹಿಂದಿರುಗಿ ಬಾಷಾನಿನ ಮಾರ್ಗವಾಗಿ ಹತ್ತಿಹೋಗಲಾಗಿ ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನು ತನ್ನ ಜನರೆಲ್ಲರೊಡನೆ ಅವರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧಮಾಡುವುದಕ್ಕೆ ಎದ್ರೈವೂರಿಗೆ ಹೊರಟುಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಅವನಿಗೆ ಭಯಪಡಬೇಡ, ನಾನು ಅವನನ್ನು ಮತ್ತು ಅವನ ಸಮಸ್ತ ಜನರನ್ನೂ ಅವನ ದೇಶವನ್ನೂ ನಿನ್ನ ಕೈಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ನೀನು ಹೆಷ್ಬೋನಿನಲ್ಲಿದ್ದ ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನಿಗೆ ಮಾಡಿದ ಪ್ರಕಾರವೇ ಇವರಿಗೂ ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ಆದಕಾರಣ ಇಸ್ರಾಯೇಲರು, ಅವರಲ್ಲಿ ಒಬ್ಬನೂ ಉಳಿಯದಂತೆ ಅವನನ್ನೂ, ಅವನ ಮಕ್ಕಳನ್ನೂ, ಅವನ ಜನರನ್ನೆಲ್ಲಾ ನಾಶಮಾಡಿ ಅವನ ದೇಶವನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ತರುವಾಯ ಇಸ್ರಾಯೇಲರು ಪ್ರಯಾಣಮಾಡಿ ಯೆರಿಕೋ ಪಟ್ಟಣಕ್ಕೆ ಎದುರಾಗಿ ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿ ಮೋವಾಬ್ಯರ ಬಯಲಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ಇಸ್ರಾಯೇಲರು ಅಮೋರಿಯರಿಗೆ ಮಾಡಿದನ್ನೆಲ್ಲಾ ಚಿಪ್ಪೋರನ ಮಗನಾದ ಬಾಲಾಕನು ನೋಡಿದನು. ಇವನು ಮೋವಾಬ್ಯರ ಅರಸನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ಇಸ್ರಾಯೇಲರು ಬಹಳ ಜನವಾಗಿರುವುದರಿಂದ ಮೋವಾಬ್ಯರು ಬಹಳ ಭಯಪಟ್ಟು ಹೆದರಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ಮೋವಾಬ್ಯರ ಅರಸನು ಮಿದ್ಯಾನ್ಯರ ಹಿರಿಯರಿಗೆ, “ದನಗಳು ಅಡವಿಯ ಹುಲ್ಲನ್ನೆಲ್ಲಾ ಮೇಯುವಂತೆ ಈ ಸಮೂಹವು ನಮ್ಮನ್ನೂ, ನಮ್ಮ ಸುತ್ತಲಿರುವ ಎಲ್ಲರನ್ನೂ ನಾಶಮಾಡುವ ಹಾಗಿದೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ಅವನು ಬೆಯೋರನ ಮಗನಾದ ಬಿಳಾಮನನ್ನು ಕರೆಯಿಸುವುದಕ್ಕೆ ಸ್ವಜನರ ದೇಶವಾದ ಯೂಫ್ರೆಟಿಸ್ ನದಿಯ ತೀರದಲ್ಲಿರುವ ಪೆತೋರ್ ಎಂಬ ಊರಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ ಅವನಿಗೆ, “ಒಂದು ಜನಾಂಗವು ಐಗುಪ್ತ ದೇಶದಿಂದ ಬಂದಿದೆ. ಅವರು ಭೂಮಿಯನ್ನೆಲ್ಲಾ ಆವರಿಸಿಕೊಂಡು ನನ್ನ ಸಮೀಪಕ್ಕೆ ಬಂದಿದ್ದಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ಆದುದರಿಂದ ನೀನು ದಯಮಾಡಿ ಬಂದು ನನಗೋಸ್ಕರ ಈ ಜನರಿಗೆ ಶಾಪಕೊಡಬೇಕು. ಆಗ ಅವರನ್ನು ಸೋಲಿಸಿ ಈ ದೇಶದಿಂದ ಹೊರಡಿಸಿಬಿಡುವುದಕ್ಕೆ ನನ್ನಿಂದ ಆಗುವುದು. ನಿನ್ನ ಆಶೀರ್ವಾದದಿಂದ ಶುಭವೂ, ನಿನ್ನ ಶಾಪದಿಂದ ಅಶುಭವೂ ಉಂಟಾಗುತ್ತದೆ ಎಂಬುದನ್ನು ನಾನು ಬಲ್ಲೆನು” ಎಂದು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ಮೋವಾಬ್ಯರ ಹಿರಿಯರೂ, ಮಿದ್ಯಾನ್ಯರ ಹಿರಿಯರೂ ಶಕುನದ ಕಾಣಿಕೆಯನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಬಿಳಾಮನ ಹತ್ತಿರಕ್ಕೆ ಬಂದು ಬಾಲಾಕನ ಮಾತುಗಳನ್ನು ತಿಳಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ಬಿಳಾಮನು ಅವರಿಗೆ, “ಈ ರಾತ್ರಿ ನೀವು ಇಲ್ಲಿಯೇ ಇಳಿದುಕೊಂಡಿರಿ. ಯೆಹೋವನು ನನಗೆ ಹೇಳುವ ಮಾತುಗಳನ್ನು ನಿಮಗೆ ತಿಳಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ಆಗ ಆ ರಾತ್ರಿ ಮೋವಾಬ್ಯರ ಪ್ರಧಾನರು ಬಿಳಾಮನ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ದೇವರು ಬಿಳಾಮನಿಗೆ, “ನಿನ್ನ ಬಳಿಯಲ್ಲಿರುವ ಆ ಮನುಷ್ಯರು ಯಾರು?” ಎಂದು ಕೇಳಲು, ");
INSERT INTO kanirv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ಬಿಳಾಮನು ದೇವರಿಗೆ, “ಮೋವಾಬ್ಯರ ಅರಸನೂ, ಚಿಪ್ಪೋರನ ಮಗನಾದ ಬಾಲಾಕನು ನನ್ನ ಬಳಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘ಒಂದು ಜನಾಂಗವು ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಟು ಬಂದಿದೆ. ಅವರು ಭೂಮಿಯನ್ನೆಲ್ಲಾ ಆವರಿಸಿಕೊಂಡಿದ್ದಾರೆ; ನೀನು ಬಂದು ಅವರಿಗೆ ಶಾಪಕೊಡಬೇಕು; ಕೊಟ್ಟರೆ ಅವರನ್ನು ಸೋಲಿಸಿ ಹೊರಡಿಸಿಬಿಡುವುದಕ್ಕೆ ನನ್ನಿಂದ ಆಗುವುದು’” ಎಂದು ಹೇಳಿಕಳುಹಿಸಿದ್ದಾನೆ ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ಅದಕ್ಕೆ ದೇವರು ಬಿಳಾಮನಿಗೆ, “ನೀನು ಅವರ ಜೊತೆಯಲ್ಲಿ ಹೋಗಬಾರದು. ಆ ಜನಾಂಗದವರು ನನ್ನ ಆಶೀರ್ವಾದವನ್ನು ಹೊಂದಿದವರು; ಅವರನ್ನು ಶಪಿಸಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ಬೆಳಿಗ್ಗೆ ಬಿಳಾಮನು ಎದ್ದು ಬಾಲಾಕನ ಪ್ರಧಾನರಿಗೆ, “ನೀವು ನಿಮ್ಮ ದೇಶಕ್ಕೆ ಹೋಗಿರಿ. ನಾನು ನಿಮ್ಮ ಜೊತೆಯಲ್ಲಿ ಬರುವುದಕ್ಕೆ ಯೆಹೋವನು ನನಗೆ ಅಪ್ಪಣೆಕೊಡಲಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ಮೋವಾಬ್ಯರ ಪ್ರಧಾನರು ಹೊರಟು ಬಾಲಾಕನ ಬಳಿಗೆ ಬಂದು, “ಬಿಳಾಮನು ನಮ್ಮ ಜೊತೆಯಲ್ಲಿ ಬರಲ್ಲಿಲ” ಎಂದು ತಿಳಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ಆದರೆ ಬಾಲಾಕನು ಅವರಿಗಿಂತಲೂ ಘನವಂತರಾದ ಹೆಚ್ಚು ಮಂದಿ ಪ್ರಧಾನರನ್ನು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ಇವರು ಬಿಳಾಮನ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, “ಚಿಪ್ಪೋರನ ಮಗನಾದ ಬಾಲಾಕನು ಹೀಗೆ ಹೇಳುತ್ತಾನೆ, ‘ನೀನು ದಯಮಾಡಿ ನನ್ನ ಬಳಿಗೆ ಬರುವುದಕ್ಕೆ ಯಾವ ಅಡ್ಡಿಯನ್ನೂ ಹೇಳಬೇಡ. ");
INSERT INTO kanirv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ಏಕೆಂದರೆ ನಾನು ನಿನ್ನನ್ನು ಬಹಳವಾಗಿ ಘನಪಡಿಸುವೆನು. ನೀನು ಏನು ಹೇಳಿದರೂ ಅದನ್ನು ಮಾಡುತ್ತೇನೆ. ನೀನು ದಯಮಾಡಿ ಬಂದು ಈ ಜನರನ್ನು ನನಗಾಗಿ ಶಪಿಸಬೇಕು’” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ಅದಕ್ಕೆ ಬಿಳಾಮನು ಬಾಲಾಕನ ಸೇವಕರಿಗೆ, “ತನ್ನ ಮನೇ ತುಂಬುವಷ್ಟು ಬೆಳ್ಳಿಬಂಗಾರ ಕೊಟ್ಟರೂ ನಾನು ನನ್ನ ದೇವರಾದ ಯೆಹೋವನ ಆಜ್ಞೆಯನ್ನು ಮೀರಿ ಸಣ್ಣ ಕೆಲಸವನ್ನಾಗಲಿ, ದೊಡ್ಡ ಕೆಲಸವನ್ನಾಗಲಿ ಮಾಡಲಾರೆನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ಆದುದರಿಂದ ನೀವೂ ಕೂಡ ಈ ರಾತ್ರಿ ಇಲ್ಲಿಯೇ ಇಳಿದುಕೊಳ್ಳಿರಿ. ಯೆಹೋವನು ಈಗ ಏನು ಹೇಳುವನೋ ಅದನ್ನು ನಿಮಗೆ ತಿಳಿಸುತ್ತೇನೆ” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ಆ ರಾತ್ರಿ ದೇವರು ಬಿಳಾಮನ ಬಳಿಗೆ ಬಂದು, “ಆ ಮನುಷ್ಯರು ನಿನ್ನನ್ನು ಕರೆಯುವುದಕ್ಕೆ ಬಂದಿರುವುದರಿಂದ ಎದ್ದು ಅವರ ಜೊತೆಯಲ್ಲಿ ಹೋಗು. ಆದರೆ ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸುವ ಪ್ರಕಾರವೇ ನೀನು ಮಾಡಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ಬೆಳಿಗ್ಗೆ ಬಿಳಾಮನು ತನ್ನ ಕತ್ತೆಗೆ ಕಡಿವಾಣ ಹಾಕಿಸಿ ಮೋವಾಬ್ಯರ ಪ್ರಧಾನರ ಜೊತೆಯಲ್ಲಿ ಹೊರಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ಅವನು ಹೋದುದರಿಂದ ದೇವರಿಗೆ ಕೋಪವುಂಟಾಯಿತು. ಯೆಹೋವನ ದೂತನು ಅವನಿಗೆ ಎದುರಾಳಿಯಾಗಿ ದಾರಿಯಲ್ಲಿ ನಿಂತುಕೊಂಡನು. ಬಿಳಾಮನು ತನ್ನ ಕತ್ತೆಯ ಮೇಲೆ ಕುಳಿತುಕೊಂಡಿದ್ದನು. ಅವನ ಇಬ್ಬರು ಆಳುಗಳು ಅವನ ಸಂಗಡ ಇದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ಯೆಹೋವನ ದೂತನು ಬಿಚ್ಚುಕತ್ತಿಯನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡು ದಾರಿಯಲ್ಲೇ ನಿಂತಿರುವುದನ್ನು ಆ ಕತ್ತೆ ನೋಡಿ ದಾರಿಯನ್ನು ಬಿಟ್ಟು ಅಡವಿಯ ಕಡೆಗೆ ಹೋಯಿತು. ಕತ್ತೆಯನ್ನು ದಾರಿಗೆ ತಿರುಗಿಸುವುದಕ್ಕೆ ಬಿಳಾಮನು ಅದನ್ನು ಹೊಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ಆ ಮೇಲೆ ಯೆಹೋವನ ದೂತನು ದ್ರಾಕ್ಷಿತೋಟಗಳ ಸಂದಿನಲ್ಲಿ ನಿಂತುಕೊಂಡನು. ಎರಡು ಕಡೆಯಲ್ಲಿಯೂ ಗೋಡೆಯಿತ್ತು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ಕತ್ತೆ ಯೆಹೋವನ ದೂತನನ್ನು ಪುನಃ ನೋಡಿ ಗೋಡೆಗೆ ಒತ್ತಿಕೊಂಡು ಬಿಳಾಮನ ಕಾಲನ್ನು ಆ ಗೋಡೆಗೆ ಇರುಕಿಸಲು ಅವನು ಅದನ್ನು ತಿರುಗಿ ಹೊಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ಆಗ ಯೆಹೋವನ ದೂತನು ಮುಂದೆ ಹೋಗಿ ಎಡಬಲಕ್ಕೆ ತಿರುಗಲಿಕ್ಕೆ ದಾರಿಯಿಲ್ಲದ ಇಕ್ಕಟ್ಟಾದ ಸ್ಥಳದಲ್ಲಿ ನಿಂತುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ಕತ್ತೆಯು ಯೆಹೋವನ ದೂತನನ್ನು ನೋಡಿ ಬಿಳಾಮನ ಕೆಳಗೆ ಬಿತ್ತು. ಬಿಳಾಮನು ಸಿಟ್ಟುಗೊಂಡು ತನ್ನ ಕೈಕೋಲಿನಿಂದ ಕತ್ತೆಯನ್ನು ಹೊಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ಆಗ ಯೆಹೋವನು ಆ ಕತ್ತೆಗೆ ಮಾತನಾಡುವ ಶಕ್ತಿಯನ್ನು ಕೊಡಲಾಗಿ ಅದು ಬಿಳಾಮನನ್ನು, “ನೀನು ಮೂರು ಸಾರಿ ನನ್ನನ್ನು ಹೊಡೆದದ್ದೇಕೆ? ನಾನು ನಿನಗೇನು ಮಾಡಿದ್ದೇನೆ” ಎಂದು ಕೇಳಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ಅದಕ್ಕೆ ಬಿಳಾಮನು ಕತ್ತೆಗೆ, “ನೀನು ಇಷ್ಟ ಬಂದಂತೆ ನನ್ನನ್ನು ಆಡಿಸಿದೆಯಲ್ಲಾ. ನನ್ನ ಕೈಯಲ್ಲಿ ಕತ್ತಿಯಿದ್ದರೆ ನಿನ್ನನ್ನು ಕೊಂದು ಹಾಕಿಬಿಡುತ್ತಿದ್ದೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ಅದಕ್ಕೆ ಆ ಕತ್ತೆಯು ಬಿಳಾಮನಿಗೆ, “ನಿನ್ನ ಜೀವಮಾನವೆಲ್ಲಾ ಇಂದಿನವರೆಗೂ ನೀನು ಹತ್ತುತ್ತಾ ಇರುವ ನಿನ್ನ ಕತ್ತೆಯು ನಾನಲ್ಲವೇ? ನಾನು ಯಾವಾಗಲಾದರೂ ಈ ರೀತಿಯಾಗಿ ಮಾಡಿದ್ದುಂಟೋ?” ಎಂದಾಗ ಬಿಳಾಮನು “ಇಲ್ಲ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ಅಷ್ಟರಲ್ಲೇ ಯೆಹೋವನು ಬಿಳಾಮನ ಕಣ್ಣುಗಳನ್ನು ತೆರೆದನು. ಯೆಹೋವನ ದೂತನು ಬಿಚ್ಚು ಕತ್ತಿಯನ್ನು ಹಿಡಿದು ದಾರಿಯಲ್ಲೇ ನಿಂತಿರುವುದನ್ನು ಕಂಡು ಬೋರಲುಬಿದ್ದು ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ಯೆಹೋವನ ದೂತನು ಅವನಿಗೆ, “ನೀನು ಮೂರು ಸಾರಿ ಕತ್ತೆಯನ್ನು ಹೊಡೆದದ್ದೇಕೆ? ನೀನು ನನಗೆ ವಿರುದ್ಧವಾದ ಮಾರ್ಗವನ್ನು ಹಿಡಿದುದರಿಂದ ನಿನ್ನನ್ನು ತಡೆಯುವುದಕ್ಕೆ ನಾನೇ ಬಂದಿದ್ದೇನೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ಆ ಕತ್ತೆ ನನ್ನನ್ನು ನೋಡಿ ಮೂರು ಸಾರಿ ನನ್ನ ಎದುರಿನಿಂದ ವಾರೆಯಾಗಿ ತಿರುಗಿಕೊಂಡಿತು. ಹಾಗೆ ತಿರುಗಿಕೊಳ್ಳದಿದ್ದರೆ ನಾನು ಕತ್ತೆಯ ಪ್ರಾಣವನ್ನು ಉಳಿಸಿ ನಿನ್ನನ್ನು ಕೊಂದು ಹಾಕಿಬಿಡುತ್ತಿದ್ದೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ಅದಕ್ಕೆ ಬಿಳಾಮನು ಯೆಹೋವನ ದೂತನಿಗೆ, “ನಾನು ಪಾಪಮಾಡಿದ್ದೇನೆ. ನೀನೇ ನನಗೆ ಎದುರಾಗಿ ದಾರಿಯಲ್ಲಿ ನಿಂತಿರುವುದು ನನಗೆ ತಿಳಿಯಲಿಲ್ಲ. ನಾನು ಮಾಡುವುದು ನಿನಗೆ ಕೆಟ್ಟದ್ದಾಗಿ ತೋರಿದರೆ ಹಿಂದಕ್ಕೆ ಹೋಗುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ಯೆಹೋವನ ದೂತನು ಬಿಳಾಮನಿಗೆ, “ಈ ಮನುಷ್ಯರ ಜೊತೆಯಲ್ಲಿ ಹೋಗು. ಆದರೆ ನಾನು ನಿನಗೆ ಹೇಳುವ ಮಾತನ್ನೇ ಹೊರತು ಬೇರೆ ಯಾವುದನ್ನೂ ಹೇಳಬಾರದು” ಎಂದು ಹೇಳಿದನು. ಬಿಳಾಮನು ಬಾಲಾಕನ ಪ್ರಧಾನರ ಜೊತೆಯಲ್ಲಿ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ಬಿಳಾಮನು ಬಂದ ವರ್ತಮಾನವನ್ನು ಬಾಲಾಕನು ಕೇಳಿ ಅವನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕಾಗಿ ತನ್ನ ದೇಶದ ಗಡಿಯಾದ ಅರ್ನೋನ್ ನದಿಯ ತೀರದಲ್ಲಿರುವ ಮೋವಾಬ್ಯರ ಪಟ್ಟಣಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು ಕಂಡಾಗ, “ನಿನ್ನನ್ನು ಅವಸರದಿಂದ ಕರೆಯುವುದಕ್ಕೆ ದೂತರನ್ನು ಕಳುಹಿಸಿದೆನಲ್ಲಾ? ನೀನು ಏಕೆ ಆಗಲೇ ಬರಲಿಲ್ಲ? ನಿನ್ನನ್ನು ಘನಪಡಿಸುವುದಕ್ಕೆ ನಾನು ಸಮರ್ಥನಲ್ಲವೆಂದು ಭಾವಿಸುತ್ತೀಯೋ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ಅದಕ್ಕೆ ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ನೋಡು, ನಾನು ನಿನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದೇನೆ. ಆದರೆ ನಾನಾಗಿ ಏನಾದರೂ ಹೇಳುವುದಕ್ಕೆ ನನಗೆ ಶಕ್ತಿಯಿಲ್ಲ. ದೇವರು ನನ್ನಿಂದ ಹೇಳಿಸಿದ ಮಾತನ್ನೇ ಹೇಳುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ಆಗ ಬಿಳಾಮನು ಬಾಲಾಕನ ಜೊತೆಯಲ್ಲಿ ಹೋದನು. ಅವರು ಕಿರ್ಯತ್ ಹುಚೋತಿಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ಬಾಲಾಕನು ಹೋರಿಗಳನ್ನೂ, ಕುರಿಗಳನ್ನೂ ವಧಿಸಿ ಯಜ್ಞಮಾಡಿ ಬಿಳಾಮನಿಗೂ, ಅವನ ಸಂಗಡ ಇದ್ದ ಪ್ರಧಾನರಿಗೂ ಊಟಕ್ಕೆ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ಮರುದಿನ ಬೆಳಿಗ್ಗೆ ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು ಕರೆದುಕೊಂಡು “ಬಾಳ್” ಎಂಬ ದೇವತೆಯ ಪೂಜಾಸ್ಥಳಗಳಲ್ಲಿದ್ದ ಗುಡ್ಡವನ್ನು ಹತ್ತಿ ಇಸ್ರಾಯೇಲರ ಒಂದು ಭಾಗವನ್ನು ಅಲ್ಲಿಂದ ತೋರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ಆಗ ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ಇಲ್ಲಿ ಏಳು ಯಜ್ಞವೇದಿಗಳನ್ನು ಕಟ್ಟಿಸು ಮತ್ತು ಏಳು ಹೋರಿಗಳನ್ನು ಮತ್ತು ಏಳು ಟಗರುಗಳನ್ನು ಸಿದ್ಧಪಡಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ಬಾಲಾಕನು ಹಾಗೆಯೇ ಮಾಡಿದನು. ಬಾಲಾಕನು ಮತ್ತು ಬಿಳಾಮನು ಪ್ರತಿ ಯಜ್ಞವೇದಿಯ ಮೇಲೆ ಒಂದು ಹೋರಿಯನ್ನು ಮತ್ತು ಒಂದು ಟಗರನ್ನೂ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ನೀನು ಸರ್ವಾಂಗಹೋಮದ ಸ್ಥಳದಲ್ಲೇ ಇರು. ನಾನು ಸ್ವಲ್ಪ ದೂರ ಹೋಗಿ ಬರುತ್ತೇನೆ. ಯೆಹೋವನು ನನಗೆ ಎದುರಾಗಿ ಬಂದು, ಆತನು ನನಗೆ ಏನನ್ನು ಸೂಚಿಸುವನೋ ಅದನ್ನು ನಿನಗೆ ತಿಳಿಸುವೆನು” ಎಂದು ಹೇಳಿ ಮರವಿಲ್ಲದ ಒಂದು ಎತ್ತರವಾದ ಸ್ಥಳಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ದೇವರು ಬಿಳಾಮನಿಗೆ ಎದುರಾಗಿ ಬಂದಾಗ ಬಿಳಾಮನು ಆತನಿಗೆ, “ನಾನು ಆ ಏಳು ಯಜ್ಞವೇದಿಗಳನ್ನು ಕಟ್ಟಿಸಿ ಒಂದೊಂದು ಯಜ್ಞವೇದಿಯಲ್ಲಿ ಒಂದು ಹೋರಿಯನ್ನು, ಒಂದು ಟಗರನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ಯೆಹೋವನು ಬಿಳಾಮನಿಗೆ ಅವನು ಹೇಳಬೇಕಾದ ಮಾತನ್ನು ಕಲಿಸಿಕೊಟ್ಟು, “ನೀನು ಬಾಲಾಕನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಿ ಹೀಗೆ ಹೇಳಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ಬಿಳಾಮನು ಬಾಲಾಕನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಂದಾಗ ಬಾಲಾಕನು ತಾನು ಸರ್ವಾಂಗಹೋಮವನ್ನು ಸಮರ್ಪಿಸಿದ್ದ ಯಜ್ಞವೇದಿಯ ಹತ್ತಿರ ನಿಂತಿದ್ದನು. ಮೋವಾಬ್ಯರ ಪ್ರಧಾನರೆಲ್ಲರೂ ಅವನ ಬಳಿಯಲ್ಲಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ಆಗ ಬಿಳಾಮನು ಪದ್ಯರೂಪವಾಗಿ ಪ್ರವಾದಿಸಿದ್ದೇನೆಂದರೆ, “ಬಾಲಾಕನು ನನ್ನನ್ನು ಆರಾಮಿನಿಂದ ಕರೆಯಿಸಿದನು, ಮೋವಾಬ್ಯರ ಅರಸನು ಪೂರ್ವ ಪರ್ವತಗಳಿಂದ ನನ್ನನ್ನು ಬರಮಾಡಿದನು, ‘ನೀನು ಬಂದು ಯಾಕೋಬ ವಂಶದವರನ್ನು ನನಗಾಗಿ ಶಪಿಸಬೇಕು.’ ‘ಇಸ್ರಾಯೇಲರನ್ನು ಎದುರಿಸುವುದಕ್ಕೆ ಬಾ.’ ");
INSERT INTO kanirv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ದೇವರು ಶಪಿಸದವನನ್ನು ನಾನು ಹೇಗೆ ಶಪಿಸಲಿ? ಯೆಹೋವನು ಎದುರಿಸದವನನ್ನು ನಾನು ಹೇಗೆ ಎದುರಿಸಲಿ? ");
INSERT INTO kanirv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ಬಂಡೆಗಳ ಶಿಖರದಿಂದ ನಾನು ಅವರನ್ನು ನೋಡುತ್ತೇನೆ; ಗುಡ್ಡದಿಂದ ಅವರನ್ನು ದೃಷ್ಟಿಸುತ್ತೇನೆ. ಆ ಜನಾಂಗವು ಪ್ರತ್ಯೇಕವಾಗಿ ವಾಸಿಸುವುದು. ಆ ಜನಾಂಗವು ಇತರ ಜನಾಂಗಗಳಂತೆ ಸಾಧಾರಣ ಜನರೆಂದು ಎಣಿಸಲ್ಪಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ಯಾಕೋಬನ ಧೂಳನ್ನು ಲೆಕ್ಕಿಸುವುದಕ್ಕೆ ಯಾರಿಂದಾದಿತು? ಇಸ್ರಾಯೇಲಿನ ನಾಲ್ಕನೆಯ ಒಂದು ಭಾಗವನ್ನಾದರೂ ಲೆಕ್ಕಿಸುವುದಕ್ಕೆ ಯಾರಿಂದಾದಿತು? ನೀತಿವಂತನು ಸಾಯುವಂತೆ ನಾನು ಸಾಯಬೇಕು. ಅವರಿಗುಂಟಾಗುವ ಅವಸಾನವು ನನಗೂ ಆಗಬೇಕು!” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ನೀನು ನನಗೆ ಮಾಡಿದ್ದೇನು? ನನ್ನ ಶತ್ರುಗಳನ್ನು ಶಪಿಸುವುದಕ್ಕೆ ಕರೆಯಿಸಿದೆನು. ನೀನು ಅವರನ್ನು ಶಪಿಸದೆ ಆಶೀರ್ವಾದವನ್ನೇ ಮಾಡಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ಅದಕ್ಕೆ ಬಿಳಾಮನು, “ಯೆಹೋವನು ಹೇಳುವ ಮಾತನ್ನೇ ನಾನು ಹೇಳಬೇಕಾಗಿದೆಯಲ್ಲವೇ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ಆಗ ಬಾಲಾಕನು, “ದಯಮಾಡಿ ನನ್ನ ಕೂಡ ಇನ್ನೊಂದು ಸ್ಥಳಕ್ಕೆ ಬಾ. ಅಲ್ಲಿಂದ ಅವರನ್ನು ನೋಡಬಹುದು. ಆದರೆ ಅವರೆಲ್ಲರನ್ನು ನೋಡದೆ ಸಮೀಪದಲ್ಲಿ ಇರುವವರನ್ನು ಮಾತ್ರ ನೋಡುವಿ. ಅಲ್ಲಿ ನನಗಾಗಿ ಅವರನ್ನು ಶಪಿಸಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ಹೀಗೆ ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು ಪಿಸ್ಗಾ ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿರುವ ಚೋಫೀಮ್ ಬಯಲು ಎಂಬ ಸ್ಥಳಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋಗಿ ಅಲ್ಲಿಯೂ ಏಳು ಯಜ್ಞವೇದಿಗಳನ್ನು ಕಟ್ಟಿಸಿ ಪ್ರತಿಯೊಂದು ಯಜ್ಞವೇದಿಯಲ್ಲಿ ಒಂದು ಹೋರಿಯನ್ನೂ, ಒಂದು ಟಗರನ್ನೂ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ನೀನು ಇಲ್ಲೇ ಸರ್ವಾಂಗಹೋಮ ಮಾಡಿರುವ ಸ್ಥಳದಲ್ಲಿ ನಿಂತುಕೋ. ನಾನು ಆ ಕಡೆಗೆ ಹೋಗಿ ಯೆಹೋವನನ್ನು ಎದುರುಗೊಳ್ಳುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ಯೆಹೋವನು ಬಿಳಾಮನಿಗೆ ಎದುರಾಗಿ ಬಂದು ಅವನು ಹೇಳಬೇಕಾದ ಮಾತನ್ನು ಕಲಿಸಿಕೊಟ್ಟನು. ಆಗ ಅವನು ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು ಬಾಲಾಕನ ಬಳಿಗೆ ತಿರುಗಿ ಹೋಗಿ ಹೀಗೆ ಹೇಳಬೇಕು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ಬಿಳಾಮನು ಬಾಲಾಕನ ಬಳಿಗೆ ಬಂದಾಗ ಬಾಲಾಕನು ತಾನು ಸರ್ವಾಂಗಹೋಮವನ್ನು ಸಮರ್ಪಿಸಿದ ವೇದಿಯ ಹತ್ತಿರ ನಿಂತಿದ್ದನು. ಮೋವಾಬ್ಯರ ಪ್ರಧಾನರು ಅವನ ಸಂಗಡ ಇದ್ದರು. ಬಾಲಾಕನು, “ಯೆಹೋವನು ಏನು ಹೇಳಿದ್ದಾನೆ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ಬಿಳಾಮನು ಪದ್ಯರೂಪವಾಗಿ ಪ್ರವಾದಿಸಿದ್ದೇನೆಂದರೆ, “ಬಾಲಾಕನೇ, ಎದ್ದು ಕಿವಿಗೊಟ್ಟು ಕೇಳು. ಚಿಪ್ಪೋರನ ಮಗನೇ, ನನ್ನ ಮಾತನ್ನು ಲಾಲಿಸು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ದೇವರು ಮನುಷ್ಯನಂತೆ ಎರಡು ಮಾತಿನವನಲ್ಲ. ಮಾನವನಂತೆ ಮನಸ್ಸನ್ನು ಬದಲಾಯಿಸುವವನಲ್ಲ. ತಾನು ಹೇಳಿದ ಪ್ರಕಾರ ನಡೆಯದಿರುತ್ತಾನೆಯೇ? ಮಾತುಕೊಟ್ಟ ನಂತರ ನೆರವೇರಿಸುವುದಿಲ್ಲವೋ? ");
INSERT INTO kanirv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ಅವರನ್ನು ಆಶೀರ್ವದಿಸುವುದಕ್ಕೆ ನನಗೆ ಅಪ್ಪಣೆಯಾಯಿತು. ಆತನು ಆಶೀರ್ವದಿಸಿದ ನಂತರ ನಾನು ಬದಲಾಯಿಸಲಾರೆನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ಈ ಯಾಕೋಬನಲ್ಲಿ ಯಾವ ಆಪತ್ತಿನ ಸೂಚನೆಯೂ ಕಾಣುವುದಿಲ್ಲ ಅಥವಾ ಇಸ್ರಾಯೇಲರಿಗೆ ಯಾವ ವಿಪತ್ತಿನ ಸೂಚನೆಯೂ ತೋರುವುದಿಲ್ಲ. ಅವರಿಗೆ ದೇವರಾಗಿರುವ ಯೆಹೋವನು ಅವರ ಸಂಗಡ ಇದ್ದಾನೆ, ಅವರು ತಮ್ಮ ಅರಸನಿಗಾಗಿ ಮಾಡುವ ಜಯ ಘೋಷವು ಕೇಳಿಸುತ್ತ ಇದೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ಅವರನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಕರೆದುಕೊಂಡು ಬಂದವನು ದೇವರೇ, ಅವರು ಕಾಡುಕೋಣದಷ್ಟು ಬಲವುಳ್ಳವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ಯಾಕೋಬರಿಗೆ ವಿರುದ್ಧವಾದ ಶಕುನವಿಲ್ಲ, ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಕಣಿ ಕೇಳುವುದಿಲ್ಲ. ಬದಲಾಗಿ, ಯಾಕೋಬ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ವಿಷಯದಲ್ಲಿ ಹೀಗೆ ಹೇಳುವರು. ‘ದೇವರು ಮಾಡುವ ಕೆಲಸವನ್ನು ನೋಡಿರಿ!’ ");
INSERT INTO kanirv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ಇಗೋ, ಜನಾಂಗದವರು ಎದ್ದು ಪ್ರಾಯದ ಸಿಂಹದಂತೆ ನಿಂತಿದ್ದಾರೆ; ಸಿಂಹವು ಮೃಗವನ್ನು ಕೊಂದು ಮಾಂಸವನ್ನು ತಿಂದು ತೃಪ್ತಿಹೊಂದದ ಹೊರತು ಮಲಗುವುದಿಲ್ಲ ತಾನು ಬೇಟೆಯಾಡಿದ ರಕ್ತವನ್ನು ಕುಡಿದು ಮಲಗುವುದು.” ");
INSERT INTO kanirv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ಆಗ ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ನೀನು ಅವರನ್ನು ಶಪಿಸಲೂ ಬೇಡ; ಆಶೀರ್ವದಿಸಲೂ ಬೇಡ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ಅದಕ್ಕೆ ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ ಉತ್ತರವಾಗಿ, “ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸುವುದನ್ನೆಲ್ಲಾ ನಾನು ಹೇಳಬೇಕೆಂದು ನಿನಗೆ ಹೇಳಲಿಲ್ಲವೇ?” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ತರುವಾಯ ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ಬೇರೊಂದು ಸ್ಥಳಕ್ಕೆ ನಿನ್ನನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗುತ್ತೇನೆ ಬಾ; ಅಲ್ಲಿಯಾದರೂ ನೀನು ಅವರನ್ನು ಶಪಿಸುವುದಕ್ಕೆ ದೇವರು ಅನುಮತಿ ಕೊಡಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ಆದಕಾರಣ ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು ಪೆಗೋರ್ ಎಂಬ ಬೆಟ್ಟದ ತುದಿಗೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ಆ ಬೆಟ್ಟದ ಮೇಲಿನಿಂದ ಕೆಳಗಿರುವ ಯೆಷೀಮೋನ್ ಎಂಬ ಅರಣ್ಯಪ್ರದೇಶವು ಕಾಣಿಸುತ್ತದೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ಆಗ ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ಇಲ್ಲಿಯೂ ಏಳು ಯಜ್ಞವೇದಿಗಳನ್ನು ಕಟ್ಟಿಸಿ ಏಳು ಹೋರಿಗಳನ್ನೂ, ಏಳು ಟಗರುಗಳನ್ನೂ ಸಿದ್ಧಮಾಡು” ಎಂದು ಹೇಳಿದನು ");
INSERT INTO kanirv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ಬಿಳಾಮನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಬಾಲಾಕನು ಪ್ರತಿಯೊಂದು ಯಜ್ಞ ವೇದಿಯಲ್ಲಿ ಒಂದು ಹೋರಿಯನ್ನೂ. ಒಂದು ಟಗರನ್ನೂ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ಇಸ್ರಾಯೇಲರಿಗೆ ಶುಭವಾಗಬೇಕೆಂಬುದು ಯೆಹೋವನ ಚಿತ್ತವೆಂದು ಬಿಳಾಮನು ತಿಳಿದು ಮೊದಲಿನಂತೆ ಶಕುನ ನೋಡುವುದಕ್ಕೆ ಹೋಗದೆ ಅರಣ್ಯದ ಕಡೆಗೆ ಮುಖವನ್ನು ತಿರುಗಿಸಿಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ಬಿಳಾಮನು ಕಣ್ಣೆತ್ತಿ ನೋಡಲಾಗಿ ಕುಲಗಳ ಪ್ರಕಾರ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಂಡಿದ್ದ ಇಸ್ರಾಯೇಲರು ಅವನಿಗೆ ಕಾಣಿಸಿದರು. ಆಗ ಅವನು ದೇವರಾತ್ಮಪ್ರೇರಿತನಾಗಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ಹೀಗೆ ಪ್ರವಾದಿಸಿದನು, “ಬೆಯೋರನ ಮಗನಾದ ಬಿಳಾಮನು ಹೇಳಿದ್ದು, ಮನೋದೃಷ್ಟಿಯಿಂದ ನೋಡುವ ಪುರುಷನು ನುಡಿದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ದೇವರ ಮಾತುಗಳನ್ನು ಕೇಳುವವನಾಗಿಯೂ, ಸರ್ವಶಕ್ತನ ದರ್ಶನವನ್ನು ಹೊಂದುವವನಾಗಿಯೂ ಪರವಶವಾಗಿ ತೆರೆದ ಕಣ್ಣುಳ್ಳವನೂ ಹೇಳಿದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ಯಾಕೋಬೇ, ನಿಮ್ಮ ಡೇರೆಗಳು ಎಷ್ಟೋ ಚೆಲುವಾಗಿವೆ, ಇಸ್ರಾಯೇಲರೇ, ನಿಮ್ಮ ನಿವಾಸಗಳು ಎಷ್ಟೋ ರಮ್ಯವಾಗಿವೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ಅವು ಕಣಿವೆಗಳ ಹಾಗೆಯೇ ವಿಸ್ತರಿಸಿದೆ. ನದಿಯ ಬಳಿಯಲ್ಲಿರುವ ತೋಟಗಳಂತೆಯೂ, ಯೆಹೋವನು ನೆಟ್ಟ ಅಗರು ಮರಗಳ ಹಾಗೆಯೂ ನೀರಿನ ಬಳಿಯಲ್ಲಿರುವ ದೇವದಾರುವೃಕ್ಷಗಳಿಗೂ ಸಮಾನವಾಗಿವೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ತನ್ನ ತೊಟ್ಟಿಗಳಿಂದ ನೀರು ಹರಿಯುತ್ತಲೇ ಇದೆ, ಅವರ ಬಿತ್ತನೆಗೆ ಬೇಕಾದಷ್ಟು ನೀರು ಇರುವುದು. ಅವರ ಅರಸನು ಅಗಾಗ್ ರಾಜನಿಗಿಂತಲೂ ದೊಡ್ಡವನಾಗಿರುವನು. ಅವರ ರಾಜ್ಯವು ಅಭಿವೃದ್ಧಿಯಲ್ಲಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ದೇವರು ಅವನನ್ನು ಐಗುಪ್ತ ದೇಶದಿಂದ ಕರೆದುಕೊಂಡು ಬಂದನು. ಅವರು ಕಾಡುಕೋಣದಷ್ಟು ಬಲವುಳ್ಳವರು. ಅವರು ಶತ್ರುಜನರನ್ನು ನಿರ್ಮೂಲಮಾಡುವರು. ವೈರಿಗಳ ಎಲುಬುಗಳನ್ನು ಮುರಿದುಹಾಕುವರು. ಅವರನ್ನು ಬಾಣಗಳಿಂದ ಗಾಯಪಡಿಸುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ಆ ಜನಾಂಗವು ಸಿಂಹದಂತೆ ಕಾಲುಮುದುರಿ ಹೊಂಚುಹಾಕಿಕೊಂಡಿದೆ, ಮೃಗೇಂದ್ರನಿಗೆ ಸಮನಾದ ಆ ಜನರನ್ನು ಕೆಣಕುವುದು ಯಾರಿಂದಾದೀತು? ಇಸ್ರಾಯೇಲರೇ, ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸುವವನಿಗೆ ಆಶೀರ್ವಾದವೂ, ಶಪಿಸುವವನಿಗೆ ಶಾಪವೂ ಉಂಟಾಗುವುದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ಆಗ ಬಾಲಾಕನು ಬಿಳಾಮನ ಮೇಲೆ ಕೋಪಗೊಂಡು ಚಪ್ಪಾಳೆಹೊಡೆದು ಅವನಿಗೆ, “ನನ್ನ ಶತ್ರುಗಳನ್ನು ಶಪಿಸುವುದಕ್ಕೆ ನಿನ್ನನ್ನು ಕರೆದೆನು. ಆದರೆ ಇಗೋ, ನೀನು ಅವರನ್ನು ಮೂರು ಸಾರಿಯೂ ಆಶೀರ್ವದಿಸಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ಆದಕಾರಣ ನನ್ನನ್ನು ಬಿಟ್ಟು ನಿನ್ನ ಊರಿಗೆ ಹೋಗಿಬಿಡು. ನಿನ್ನನ್ನು ಬಹಳವಾಗಿ ಸನ್ಮಾನಿಸಿ ಘನಪಡಿಸುವೆನೆಂದು ಹೇಳಿಕೊಂಡೆನು. ಆದರೆ ನಿನಗೆ ಸನ್ಮಾನಮಾಡದಂತೆ ಯೆಹೋವನು ಅಡ್ಡಿಮಾಡಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ಅದಕ್ಕೆ ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ನೀನು ನನ್ನ ಬಳಿ ಕಳುಹಿಸಿದ ಸೇವಕನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ಬಾಲಾಕನು ನನಗೆ ತನ್ನ ಮನೇ ತುಂಬುವಷ್ಟು ಬೆಳ್ಳಿಬಂಗಾರವನ್ನು ದಾನಮಾಡಿದರೂ ನಾನು ಯೆಹೋವನ ಆಜ್ಞೆಯನ್ನು ಮೀರಿ ನನ್ನ ಇಷ್ಟದಂತೆ ಒಳ್ಳೇಯದನ್ನಾದರೂ, ಕೆಟ್ಟದ್ದನ್ನಾದರೂ ಮಾಡಲಾರೆ. ಯೆಹೋವನು ಏನು ಹೇಳುತ್ತಾನೋ ಅದನ್ನೇ ಮಾತನಾಡುವೆನು ಎಂದು ಹೇಳಲಿಲ್ಲವೋ?’ ");
INSERT INTO kanirv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ಈಗ ನಾನು ನನ್ನ ಜನರ ಬಳಿಗೆ ಹೋಗುತ್ತೇನೆ. ಆದರೆ ಕಡೆಗೆ ಆ ಜನರು ನಿನ್ನ ಜನರಿಗೆ ಮುಂದಿನ ದಿನಗಳಲ್ಲಿ ಏನು ಮಾಡುವರೋ ಅದನ್ನು ನಿನಗೆ ತಿಳಿಸುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ಬಿಳಾಮನು ಪದ್ಯರೂಪವಾಗಿ ಪ್ರವಾದಿಸಿದನು, “ಬೆಯೋರನ ಮಗನಾದ ಬಿಳಾಮನಿಗುಂಟಾದ ದೈವೋಕ್ತಿ, ಮನೋದೃಷ್ಟಿಯಿಂದ ನೋಡುವ ಪುರುಷನು ನುಡಿದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ದೇವರ ಮಾತುಗಳನ್ನು ಕೇಳುವವನೂ, ಪರಾತ್ಪರನಾದ ದೇವರ ಜ್ಞಾನವನ್ನು ಪಡೆದವನೂ, ಪರವಶವಾಗಿ ಕಣ್ಣುತೆರೆದು, ಸರ್ವಶಕ್ತನ ದರ್ಶನವನ್ನು ಹೊಂದುವವನೂ ಆಗಿರುವ ಪುರುಷನು ನುಡಿದದ್ದು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ನಾನು ಅವನನ್ನು ನೋಡುವೆನು, ಈಗಲ್ಲ. ಆತನನ್ನು ದೃಷ್ಟಿಸುವೆನು, ಆದರೆ ಸಮೀಪದಲ್ಲಿ ಅಲ್ಲ. ಯಾಕೋಬ ವಂಶದವರಲ್ಲಿ ನಕ್ಷತ್ರವು ಉದಯಿಸುವುದು. ಇಸ್ರಾಯೇಲರಲ್ಲಿ ರಾಜದಂಡವು ಏಳುವುದು. ಅದು ಮೋವಾಬ್ಯರ ತಲೆಯನ್ನು ಸೀಳಿಹಾಕುವುದು ಸೇತನ ಎಲ್ಲಾ ಮಕ್ಕಳನ್ನು ಸಂಹರಿಸಿವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ಅದಲ್ಲದೆ ಇಸ್ರಾಯೇಲರು ಎದೋಮ್ಯರ ದೇಶವನ್ನೂ ಸ್ವಾಧೀನಪಡಿಸಿಕೊಂಡಿದ್ದಾರೆ, ಹಗೆಗಳಾದ ಸೇಯೀರಿನವರು ಅವನಿಗೆ ಅಧೀನರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ಇಸ್ರಾಯೇಲರೋ ಬಲಗೊಂಡವರು, ಯಾಕೋಬ್ಯರಿಗೇ ದೊರೆತನವಾಯಿತು, ಪಟ್ಟಣಗಳಿಂದ ತಪ್ಪಿಸಿಕೊಂಡವರೂ ನಾಶವಾದರು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ತರುವಾಯ ಅಮಾಲೇಕ್ಯರನ್ನು ನೋಡಿ ಅವರ ವಿಷಯದಲ್ಲಿ ಪ್ರವಾದಿಸಿದ್ದೇನೆಂದರೆ, “ಅಮಾಲೇಕ್ಯರು ಜನಾಂಗಗಳಲ್ಲಿ ಪ್ರಮುಖರಲ್ಲವೇ, ಆದರೂ ನಾಶನವೇ ಅವರ ಗತಿ.” ");
INSERT INTO kanirv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ಬಳಿಕ ಅವನು ಕೇನ್ಯರನ್ನು ನೋಡಿ ಅವರ ವಿಷಯದಲ್ಲಿ ಪ್ರವಾದಿಸಿದ್ದೇನೆಂದರೆ, “ನಿಮ್ಮ ನಿವಾಸ ಸ್ಥಳವು ಶಾಶ್ವತವಾಗಿಯೇ ತೋರುತ್ತದೆ, ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿ ಗೂಡನ್ನು ಮಾಡಿಕೊಂಡಿದ್ದೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ಆದರೂ ಕೇನ್ಯರೂ ನಾಶವಾಗುವರು. ಅದು ಎಷ್ಟು ದೂರ ಅನ್ನುತ್ತೀರೋ? ಅಶ್ಶೂರ್ಯರೇ ನಿಮ್ಮನ್ನು ಸೆರೆಹಿಡಿದುಕೊಂಡು ಹೋಗುವರು.” ");
INSERT INTO kanirv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ಅವನು ಮತ್ತೂ ಕಡೆಯದಾಗಿ ಪ್ರವಾದಿಸಿದ್ದೇನೆಂದರೆ, “ಅಯ್ಯೋ! ದೇವರು ಹೀಗೆ ಮಾಡುವಾಗ ಯಾರು ಉಳಿಯುವರು? ");
INSERT INTO kanirv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ಕಿತ್ತೀಮೆಂಬ ಸ್ಥಳದಿಂದ ಜನರು ಹಡಗುಗಳಲ್ಲಿ ಬಂದು ಅಶ್ಶೂರ್ಯರನ್ನೂ ಏಬೆರ್ ಜನರನ್ನೂ ಸೋಲಿಸುವರು; ಅವರಿಗೂ ನಾಶನವುಂಟಾಗುವುದು” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ತರುವಾಯ ಬಿಳಾಮನು ಸ್ವದೇಶಕ್ಕೆ ತಿರುಗಿ ಹೋದನು, ಬಾಲಾಕನೂ ಹೊರಟುಹೋದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ಇಸ್ರಾಯೇಲರು ಶಿಟ್ಟೀಮಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾಗ ಅವರು ಮೋವಾಬ್ ಸ್ತ್ರೀಯರೊಡನೆ ಸಹವಾಸ ಮಾಡುವವರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ಆ ಸ್ತ್ರೀಯರು ತಮ್ಮ ದೇವತೆಗಳಿಗೆ ಮಾಡಿದ ಔತಣದ ಯಜ್ಞಗಳಿಗೆ ಇಸ್ರಾಯೇಲರನ್ನು ಆಹ್ವಾನಿಸಿದರು. ಇವರು ಆ ಭೋಜನವನ್ನು ಮಾಡಿ ಅವರ ದೇವತೆಗಳಿಗೆ ನಮಸ್ಕರಿಸುವವರಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ಹೀಗೆ ಇಸ್ರಾಯೇಲರು ಪೆಗೋರದ ಬಾಳನ ಭಕ್ತರಾದರು. ಯೆಹೋವನ ಕೋಪವು ಅವರ ಮೇಲೆ ಹೆಚ್ಚಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ಆದುದರಿಂದ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಜನರ ಮುಖಂಡರೆಲ್ಲರನ್ನೂ ಹಿಡಿಸಿ ಅವರನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಬಹಿರಂಗವಾಗಿ ಕೊಲ್ಲಿಸಬೇಕು. ಹೀಗೆ ಯೆಹೋವನ ಕೋಪಾಗ್ನಿಯನ್ನು ಇಸ್ರಾಯೇಲರಿಂದ ತೊಲಗಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ಆದಕಾರಣ ಮೋಶೆ ಇಸ್ರಾಯೇಲರ ಮುಖಂಡರಿಗೆ, “ಪೆಗೋರದ ಬಾಳ್ ನನ್ನು ಪೂಜಿಸುವ ಜನರು ನಿಮ್ಮ ವಶದಲ್ಲಿದ್ದರೆ ಅಂಥವನಿಗೆ ಮರಣ ಶಿಕ್ಷೆಯನ್ನು ವಿಧಿಸಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಒಬ್ಬನು ಮೋಶೆ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರ ಎದುರಿನಲ್ಲಿಯೇ ತನ್ನ ಸಹೋದರರೊಳಗೆ ಒಬ್ಬ ಮಿದ್ಯಾನ್ ಸ್ತ್ರೀಯನ್ನು ತನ್ನ ಮನೆಯೊಳಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ಕೂಡಲೆ ಮಹಾಯಾಜಕನಾದ ಆರೋನನ ಮೊಮ್ಮಗನೂ, ಎಲ್ಲಾಜಾರನ ಮಗನಾದ ಫೀನೆಹಾಸನು ಸಭೆಯ ಮಧ್ಯದಲ್ಲಿ ಎದ್ದು ಈಟಿಯನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ಅವನು ಇಸ್ರಾಯೇಲನ ಹಿಂದೆ ಹೋಗಿ ಅವನು ಮಲಗುವ ಕೋಣೆಯನ್ನು ಪ್ರವೇಶಿಸಿ ಅವರಿಬ್ಬರನ್ನೂ ಅಂದರೆ ಆ ಇಸ್ರಾಯೇಲನನ್ನೂ ಮತ್ತು ಆ ಸ್ತ್ರೀಯನ್ನೂ ಒಂದೇ ಬಾರಿಗೆ ಹೊಟ್ಟೆಯನ್ನು ತಿವಿದು ಕೊಂದುಹಾಕಿದನು. ಆಗ ಇಸ್ರಾಯೇಲರಿಗೆ ಉಂಟಾಗಿದ್ದ ವ್ಯಾಧಿಯು ನಿಂತು ಹೋಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ಈಗಾಗಲೇ ಆ ವ್ಯಾಧಿಯಿಂದ ಇಪ್ಪತ್ತನಾಲ್ಕು ಸಾವಿರ ಮಂದಿ ಮರಣ ಹೊಂದಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ಆಗ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ನಾನು ನನ್ನ ಗೌರವವನ್ನು ಕಾಪಾಡಿಕೊಳ್ಳುವ ಪ್ರಕಾರ ಮಹಾಯಾಜಕನಾದ ಆರೋನನ ಮೊಮ್ಮಗನೂ, ಎಲ್ಲಾಜಾರನ ಮಗನಾದ ಫೀನೆಹಾಸನು ನನ್ನ ಗೌರವವನ್ನು ಕಾಪಾಡಿದ್ದರಿಂದ ಇಸ್ರಾಯೇಲರ ಮೇಲಿದ್ದ ನನ್ನ ಕೋಪವನ್ನು ತೊಲಗಿಸಿದ್ದಾನೆ. ಹೀಗಿರುವುದರಿಂದ ನಾನು ನನ್ನ ಗೌರವವನ್ನು ಕಾಪಾಡಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಇಸ್ರಾಯೇಲರನ್ನು ನಿರ್ಮೂಲಮಾಡಬೇಕಾದ ಅಗತ್ಯವಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ಆದಕಾರಣ ನಾನು ಅವನ ಸಂಗಡ ಸ್ನೇಹದ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಳ್ಳುತ್ತೇನೆ ಎಂದು ಎಲ್ಲರಿಗೂ ತಿಳಿಸು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ಅವನಿಗೂ, ಅವನ ತರುವಾಯ ಅವನ ಸಂತತಿಯವರಿಗೂ ಯಾಜಕತ್ವವು ಶಾಶ್ವತವಾಗಿಯೇ ಇರುವುದೆಂದು ಒಡಂಬಡಿಕೆ ಮಾಡುತ್ತೇನೆ. ಅವನು ತನ್ನ ದೇವರ ಗೌರವವನ್ನು ಹೆಚ್ಚಿಸಿ ಇಸ್ರಾಯೇಲರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದುದರಿಂದ ನಾನು ಅವನಿಗೆ ಈ ಮಾತನ್ನು ಕೊಟ್ಟಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ಆ ಮಿದ್ಯಾನ್ ಸ್ತ್ರೀಯೊಡನೆ ಹತವಾದವನ ಆ ಇಸ್ರಾಯೇಲಿನವನ ಹೆಸರು ಜಿಮ್ರಿ, ಅವನು ಸಿಮೆಯೋನ್ಯ ಕುಲದವರಲ್ಲಿ ಗೋತ್ರ ಪ್ರಧಾನನಾದ ಸಾಲೂ ಎಂಬುವನ ಮಗನು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ಹತವಾದ ಆ ಮಿದ್ಯಾನ್ ಸ್ತ್ರೀಯ ಹೆಸರು ಕೊಜ್ಬೀ, ಅವಳು ಮಿದ್ಯಾನ್ಯರಲ್ಲಿ ಗೋತ್ರ ಪ್ರಧಾನನಾದ ಚೂರ್ ಎಂಬುವನ ಮಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ನೀನು ಮಿದ್ಯಾನ್ಯರನ್ನು ವೈರಿಯೆಂದು ತಿಳಿದು ಸಂಹರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ಅವರು ಪೆಗೋರದ ವಿಷಯದಲ್ಲಿಯೂ, ಮಿದ್ಯಾನ್ಯರ ಅಧಿಪತಿಯ ಮಗಳಾದ ಕೊಜ್ಬೀ ಎಂಬ ಸ್ತ್ರೀಯ ವಿಷಯದಲ್ಲಿಯೂ ನಿಮ್ಮನ್ನು ಮೋಸಗೊಳಿಸಿ ಹಿಂಸಿಸಿದ್ದಾರೆ. ಆ ಸ್ತ್ರೀಯು ಪೆಗೋರದ ಘಟನೆಗಳ ನಿಮಿತ್ತ ಘೋರ ವ್ಯಾಧಿ ಉಂಟಾದಾಗ ಹತಳಾದವಳು.” ");
INSERT INTO kanirv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ಆ ಘೋರವಾದ ವ್ಯಾಧಿ ನಿಂತ ಮೇಲೆ ಯೆಹೋವನು ಮೋಶೆಗೂ ಮತ್ತು ಆರೋನನ ಮಗನೂ, ಯಾಜಕನೂ ಆಗಿರುವ ಎಲ್ಲಾಜಾರನ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ನೀವು ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರಲ್ಲಿ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಿನ ವಯಸ್ಸುಳ್ಳವರನ್ನು ಅಂದರೆ ಯುದ್ಧಕ್ಕೆ ಹೊರಡತಕ್ಕವರನ್ನು ಗೋತ್ರಗೋತ್ರಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ಆಗ ಮೋಶೆಯೂ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನೂ ಮೋವಾಬ್ಯರ ಬಯಲುಗಳಲ್ಲಿ ಯೆರಿಕೋ ಪಟ್ಟಣಕ್ಕೆ ಎದುರಾಗಿ ಯೊರ್ದನ್ ನದಿಯ ಹತ್ತಿರ ಅವರ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“ಯೆಹೋವನು ಮೋಶೆಗೆ ಅಜ್ಞಾಪಿಸಿದಂತೆ ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಟ್ಟಿದ್ದ ಮತ್ತು ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನೂ ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿ ಮೋವಾಬ್ಯರ ಮೈದಾನದಲ್ಲಿ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಿನ ವಯಸ್ಸುಳ್ಳವರನ್ನು ಲೆಕ್ಕಿಸಿರಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ಇಸ್ರಾಯೇಲನ ಚೊಚ್ಚಲು ಮಗನಾದ ರೂಬೇನನಿಂದುಂಟಾದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ಹನೋಕನ ವಂಶಸ್ಥರಾದ ಹನೋಕ್ಯರು, ಪಲ್ಲೂವಿನ ವಂಶಸ್ಥರಾದ ಪಲ್ಲೂವಿನವರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ಹೆಚ್ರೋನನ ವಂಶಸ್ಥರಾದ ಹೆಚ್ರೋನ್ಯರು, ಕರ್ಮೀಯ ವಂಶಸ್ಥರಾದ ಕರ್ಮೀಯರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ಇವರೇ ರೂಬೇನ್ಯರ ಕುಟುಂಬದವರು, ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 43,730 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ಪಲ್ಲೂವಿನ ಮಗನು ಎಲೀಯಾಬ್. ");
INSERT INTO kanirv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ಎಲೀಯಾಬನ ಮಕ್ಕಳು: ನೆಮೂವೇಲ್, ದಾತಾನ್, ಅಬೀರಾಮ್ ಎಂಬುವವರೇ. ಕೋರಹನ ಗುಂಪಿನವರು ಯೆಹೋವನಿಗೆ ವಿರುದ್ಧವಾಗಿ ವಿವಾದಿಸಿದ ಕಾಲದಲ್ಲಿ ಅವರೊಳಗೆ ಸೇರಿಕೊಂಡು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ವಿರುದ್ಧವಾಗಿ ವಿವಾದಿಸಿದ ಆಲೋಚನಾಕರ್ತರಾದ ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ಭೂಮಿಯು ಬಾಯ್ದೆರೆದು ಅವರನ್ನೂ ಮತ್ತು ಕೋರಹನನ್ನೂ ನುಂಗಿಬಿಟ್ಟಿತು ಮತ್ತು ಬೆಂಕಿಯು ಆ ಗುಂಪಿನವರಲ್ಲಿ ಬೇರೆ ಇನ್ನೂರೈವತ್ತು ಮಂದಿಯನ್ನು ದಹಿಸಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಎಚ್ಚರಿಕೆಯನ್ನು ಉಂಟುಮಾಡಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ಆ ಗುಂಪಿನವರೆಲ್ಲರು ಸತ್ತರೂ ಕೋರಹನ ಮಕ್ಕಳು ಆ ಕಾಲದಲ್ಲಿ ಸಾಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ಸಿಮೆಯೋನ್ ಕುಲದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ನೆಮೂವೇಲನ ವಂಶಸ್ಥರಾದ ನೆಮೂವೇಲ್ಯರು, ಯಾಮೀನನ ವಂಶಸ್ಥರಾದ ಯಾಮೀನ್ಯರು, ಯಾಕೀನನ ವಂಶಸ್ಥರಾದ ಯಾಕೀನ್ಯರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ಜೆರಹನ ವಂಶಸ್ಥರಾದ ಜೆರಹಿಯರು, ಸೌಲನ ವಂಶಸ್ಥರಾದ ಸೌಲ್ಯರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ಸಿಮೆಯೋನ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 22,200 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ಗಾದ್ ಕುಲದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ಚೆಫೋನನ ವಂಶಸ್ಥರಾದ ಚೆಫೋನ್ಯರು, ಹಗ್ಗೀಯ ವಂಶಸ್ಥರಾದ ಹಗ್ಗೀಯರು, ಶೂನೀಯ ವಂಶಸ್ಥರಾದ ಶೂನೀಯರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ಒಜ್ನೀಯ ವಂಶಸ್ಥರಾದ ಒಜ್ನೀಯರು, ಏರೀಯ ವಂಶಸ್ಥರಾದ ಏರೀಯರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ಅರೋದನ ವಂಶಸ್ಥರಾದ ಅರೋದ್ಯರು, ಅರೇಲೀಯ ವಂಶಸ್ಥರಾದ ಅರೇಲೀಯರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ಗಾದ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 40,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ಯೆಹೂದನ ಮಕ್ಕಳಲ್ಲಿ ಏರ್ ಮತ್ತು ಓನಾನರು ಕಾನಾನ್ ದೇಶದಲ್ಲೇ ಸತ್ತರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ಯೆಹೂದನ ಕುಲದಲ್ಲಿ ಉಳಿದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ಶೇಲಹನ ವಂಶಸ್ಥರಾದ ಶೇಲಾನ್ಯರು, ಪೆರೆಹನ ವಂಶಸ್ಥರಾದ ಪೆರೆಚ್ಯರು, ಜೆರಹನ ವಂಶಸ್ಥರಾದ ಜೆರಹಿಯರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ಪೆರೆಚನಿಂದುಂಟಾದ ಕುಟುಂಬಗಳು: ಹೆಚ್ರೋನನ ವಂಶಸ್ಥರಾದ ಹೆಚ್ರೋನ್ಯರೂ ಹಾಮೂಲನ ವಂಶಸ್ಥರಾದ ಹಾಮೂಲ್ಯರೂ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ಯೆಹೂದ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 76,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ಇಸ್ಸಾಕಾರ್ ಕುಲದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ತೋಲನ ವಂಶಸ್ಥರಾದ ತೋಲಾಯರು, ಪುವ್ವನ ವಂಶಸ್ಥರಾದ ಪೂನ್ಯರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ಯಾಶೂಬನ ವಂಶಸ್ಥರಾದ ಯಾಶೂಬ್ಯರು, ಶಿಮ್ರೋನನ ವಂಶಸ್ಥರಾದ ಶಿಮ್ರೋನ್ಯರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ಇಸ್ಸಾಕಾರ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 64,300 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ಜೆಬುಲೂನ್ ಕುಲದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ಸೆರೆದನ ವಂಶಸ್ಥರಾದ ಸೆರೆದ್ಯರು, ಏಲೋನನ ವಂಶಸ್ಥರಾದ ಏಲೋನ್ಯರು, ಯಹಲೇಲನ ವಂಶಸ್ಥರಾದ ಯಹಲೇಲ್ಯರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ಜೆಬುಲೂನ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 60,500 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಯೋಸೇಫನ ಮಕ್ಕಳು ಮನಸ್ಸೆ ಮತ್ತು ಎಫ್ರಾಯೀಮ್. ");
INSERT INTO kanirv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ಮನಸ್ಸೆ ಕುಲದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ಮಾಕೀರನ ವಂಶಸ್ಥರಾದ ಮಾಕೀರ್ಯರು, ಮಾಕೀರನ ಮಗನಾದ ಗಿಲ್ಯಾದನ ವಂಶಸ್ಥರಾದ ಗಿಲ್ಯಾದ್ಯರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ಗಿಲ್ಯಾದನ ವಂಶದವರು ಯಾರೆಂದರೆ: ಈಯೆಜೆರನ ವಂಶಸ್ಥರಾದ ಈಯೆಜೆರ್ಯರು, ಹೇಲೆಕನ ವಂಶಸ್ಥರಾದ ಹೇಲೆಕ್ಯರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ಅಸ್ರೀಯೇಲನ ವಂಶಸ್ಥರಾದ ಅಸ್ರೀಯೇಲ್ಯರು, ಶೆಕೆಮನ ವಂಶಸ್ಥರಾದ ಶೆಕೆಮ್ಯರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ಶೆಮೀದಾಯನ ವಂಶಸ್ಥರಾದ ಶೆಮೀದಾಯರು, ಹೇಫೆರನ ವಂಶಸ್ಥರಾದ ಹೇಫೆರ್ಯರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ಹೇಫೆರನ ಮಗನಾದ ಚಲ್ಪಹಾದನಿಗೆ ಹೆಣ್ಣು ಮಕ್ಕಳು ಹುಟ್ಟಿದರೇ ಹೊರತು ಗಂಡುಮಕ್ಕಳು ಹುಟ್ಟಲಿಲ್ಲ. ಅವನ ಹೆಣ್ಣುಮಕ್ಕಳು: ಮಹ್ಲಾ, ನೋವಾ, ಹೊಗ್ಲಾ, ಮಿಲ್ಕಾ, ತಿರ್ಚಾ ಎಂಬುವವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ಮನಸ್ಸೆ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 52,700 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ಎಫ್ರಾಯೀಮ್ ಕುಲದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ಶೂತೆಲಹನ ವಂಶಸ್ಥರಾದ ಶೂತೆಲಹ್ಯರು, ಬೆಕೆರನ ವಂಶಸ್ಥರಾದ ಬೆಕೆರ್ಯರು, ತಹನನ ವಂಶಸ್ಥರಾದ ತಹನಿಯರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ಶೂತೆಲಹನ ಮಗನಾದ ಏರಾನನ ವಂಶಸ್ಥರಾದ ಏರಾನ್ಯರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ಎಫ್ರಾಯೀಮ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 32,500 ಮಂದಿ. ಇದೇ ಯೋಸೇಫ್ ವಂಶದ ಕುಟುಂಬಗಳ ವಿವರ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ಬೆನ್ಯಾಮೀನ್ ಕುಲದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ಬೆಲಗನ ವಂಶಸ್ಥರಾದ ಬೆಲಗ್ಯರು, ಅಷ್ಬೇಲನ ವಂಶಸ್ಥರಾದ ಅಷ್ಬೇಲ್ಯರು, ಅಹೀರಾಮನ ವಂಶಸ್ಥರಾದ ಅಹೀರಾಮ್ಯರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ಶೂಫಾಮನ ವಂಶಸ್ಥರಾದ ಶೂಫಾಮ್ಯರು, ಹೊಫಾಮನ ವಂಶಸ್ಥರಾದ ಹೊಫಾಮ್ಯರು ಇವರೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ಬೆಲಗನಿಗೆ ಅರ್ದ್, ನಾಮಾನ್ ಎಂಬ ಇಬ್ಬರು ಮಕ್ಕಳಿದ್ದರು. ಅರ್ದನ ವಂಶದವರು ಅರ್ದ್ಯರು, ನಾಮಾನನ ವಂಶದವರು ನಾಮಾನ್ಯರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ಬೆನ್ಯಾಮೀನ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 45,600 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ದಾನ್ ಕುಲದ ಕುಟುಂಬಗಳು ಯಾವುವೆಂದರೆ: ಶೂಹಾಮನ ವಂಶಸ್ಥರಾದ ಶೂಹಾಮ್ಯರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ಶೂಹಾಮ್ಯರ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 64,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ಆಶೇರ್ ಕುಲದ ಕುಟುಂಬಗಳು: ಇಮ್ನಾಹನ ವಂಶಸ್ಥರಾದ ಇಮ್ನಾಹ್ಯರು, ಇಷ್ವೀಯ ವಂಶಸ್ಥರಾದ ಇಷ್ವೀಯರು, ಬೆರೀಯನ ವಂಶಸ್ಥರಾದ ಬೆರೀಯರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ಬೆರೀಯನ ಮಕ್ಕಳಿಂದುಂಟಾದ ಕುಟುಂಬಗಳು: ಹೇಬೆರನ ವಂಶಸ್ಥರಾದ ಹೇಬೆರ್ಯರು, ಮಲ್ಕೀಯೇಲನ ವಂಶಸ್ಥರಾದ ಮಲ್ಕೀಯೇಲ್ಯರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ಆಶೇರನಿಗೆ ಸೆರಹಳೆಂಬ ಮಗಳು ಸಹ ಇದ್ದಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ಆಶೇರ್ ಕುಲದವರಾದ ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರು 53,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ನಫ್ತಾಲಿ ಕುಲದ ಕುಟುಂಬಗಳು: ಯಹಚೇಲನ ವಂಶಸ್ಥರಾದ ಯಹಚೇಲ್ಯರು, ಗೂನೀಯ ವಂಶಸ್ಥರಾದ ಗೂನೀಯರು, ");
INSERT INTO kanirv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ಯೇಚೆರನ ವಂಶಸ್ಥರಾದ ಯೇಚೆರ್ಯರು, ಶಿಲ್ಲೇಮನ ವಂಶಸ್ಥರಾದ ಶಿಲ್ಲೇಮ್ಯರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ನಫ್ತಾಲಿ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 45,400 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ - 6,01,730. ");
INSERT INTO kanirv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ನೀವು ಈ ಕುಲಗಳಿಗೆ ಅವರವರ ಸಂಖ್ಯೆಯ ಪ್ರಕಾರ ಆ ದೇಶವನ್ನು ಸ್ವದೇಶವಾಗುವಂತೆ ಹಂಚಿಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ಹೆಚ್ಚು ಮಂದಿಯುಳ್ಳ ಕುಲಕ್ಕೆ ಹೆಚ್ಚಾಗಿಯೂ, ಕಡಿಮೆ ಮಂದಿಯುಳ್ಳ ಕುಲಕ್ಕೆ ಕಡಿಮೆಯಾಗಿಯೂ ಕೊಡಬೇಕು. ಲೆಕ್ಕಿಸಿದ ಸಂಖ್ಯೆಯ ಪ್ರಕಾರವೇ ಪ್ರತಿಯೊಂದು ಕುಲಕ್ಕೆ ಭೂಮಿಯನ್ನು ಸ್ವತ್ತಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ಪ್ರತಿಯೊಂದು ಕುಲದ ಪಿತೃವಿನ ಹೆಸರನ್ನು ಬರೆದು ಚೀಟುಹಾಕಿ ಆಯಾ ಕುಲಕ್ಕೆ ಸ್ವತ್ತನ್ನು ಗೊತ್ತು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ಹೆಚ್ಚು ಮಂದಿಯುಳ್ಳ ಕುಲಕ್ಕಾಗಲಿ, ಕಡಿಮೆಯಾದ ಕುಲಕ್ಕಾಗಲಿ ಚೀಟು ಬಂದ ಪ್ರಕಾರವೇ ಸ್ವತ್ತನ್ನು ಗೊತ್ತುಮಾಡಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ಲೇವಿಯರೊಳಗೆ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಕುಟುಂಬಗಳು: ಗೇರ್ಷೋನನ ವಂಶದವರಾದ ಗೇರ್ಷೋನ್ಯರು, ಕೆಹಾತನ ವಂಶದವರಾದ ಕೆಹಾತ್ಯರು, ಮೆರಾರೀಯ ವಂಶದವರಾದ ಮೆರಾರೀಯರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ಲೇವಿ ಕುಲದವರ ಕುಟುಂಬಗಳು: ಲಿಬ್ನೀಯರ ಕುಟುಂಬ, ಹೆಬ್ರೋನ್ಯರ ಕುಟುಂಬ, ಮಹ್ಲೀಯರ ಕುಟುಂಬ, ಮೂಷೀಯರ ಕುಟುಂಬ, ಕೋರಹಿಯರ ಕುಟುಂಬ ಇವುಗಳೇ. ಕೆಹಾತನು ಅಮ್ರಾಮನನ್ನು ಪಡೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ಅಮ್ರಾಮನ ಹೆಂಡತಿ ಯಾರೆಂದರೆ: ಐಗುಪ್ತ ದೇಶದಲ್ಲಿ ಲೇವಿಯಿಂದ ಹುಟ್ಟಿದ ಯೋಕೆಬೆದಳು. ಈಕೆಯಲ್ಲಿ ಅಮ್ರಾಮನಿಂದ ಆರೋನನೂ, ಮೋಶೆಯೂ ಮತ್ತು ಇವರ ಅಕ್ಕ ಮಿರ್ಯಾಮಳೂ ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ಆರೋನನಿಂದ ನಾದಾಬ್, ಅಬೀಹೂ, ಎಲ್ಲಾಜಾರ್, ಈತಾಮಾರ್ ಎಂಬುವವರು ಹುಟ್ಟಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ನಾದಾಬ್ ಮತ್ತು ಅಬೀಹೂ ಎಂಬಿಬ್ಬರು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಆತನು ಆಜ್ಞಾಪಿಸದೆ ಇದ್ದ ಬೇರೆ ಬೆಂಕಿಯಿಂದ ಧೂಪವನ್ನು ಸಮರ್ಪಿಸಿದ್ದರಿಂದ ಸತ್ತುಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ಬೇರೆ ಇಸ್ರಾಯೇಲರಿಗೆ ಸ್ವತ್ತು ದೊರಕಿದಂತೆ ಲೇವಿಯರಿಗೆ ಸ್ವತ್ತು ದೊರೆಯದೆ ಹೋದುದರಿಂದ ಅವರು ಇಸ್ರಾಯೇಲರೊಡನೆ ಲೆಕ್ಕಿಸಲ್ಪಡಲಿಲ್ಲ ಲೇವಿಯರೊಳಗೆ ಒಂದು ತಿಂಗಳು ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚು ವಯಸ್ಸುಳ್ಳ ಗಂಡಸರನ್ನು ಲೆಕ್ಕಿಸಲಾಗಿ ಅವರ ಸಂಖ್ಯೆ - 23,000 ಮಂದಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿ ಯೆರಿಕೋ ಪಟ್ಟಣದ ಹತ್ತಿರ ಮೋವಾಬ್ಯರ ಮೈದಾನದಲ್ಲಿ ಮೋಶೆಯೂ ಮತ್ತು ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನೂ ಇಸ್ರಾಯೇಲರ ಜನಸಂಖ್ಯೆಯನ್ನು ಲೆಕ್ಕಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ಮೋಶೆಯೂ ಮತ್ತು ಯಾಜಕನಾದ ಆರೋನನೂ ಸೀನಾಯಿ ಅರಣ್ಯದಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಸಂಖ್ಯೆಯಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರೊಳಗೆ ಒಬ್ಬರಾದರೂ ಇವರಲ್ಲಿ ಇರಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ಅವರೆಲ್ಲರೂ ಅರಣ್ಯದಲ್ಲಿಯೇ ಸಾಯುವರೆಂದು ಯೆಹೋವನು ಅವರ ವಿಷಯದಲ್ಲಿ ಹೇಳಿದ್ದನು. ಆದುದರಿಂದ ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬ್ ಮತ್ತು ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವ ಇವರಿಬ್ಬರ ಹೊರತಾಗಿ ಅವರಲ್ಲಿ ಯಾರೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ಯೋಸೇಫನ ಕುಮಾರ ಮನಸ್ಸೆಯ ವಂಶದವರೊಳಗೆ ಮನಸ್ಸೆಗೆ ಹುಟ್ಟಿದ ಮಾಕೀರನ ಮರಿಮಗನೂ, ಗಿಲ್ಯಾದನ ಮೊಮ್ಮಗನೂ ಹೇಫೆರನ ಮಗನಾದ ಚಲ್ಪಹಾದನ ಹೆಣ್ಣುಮಕ್ಕಳಾದ ಮಹ್ಲಾ, ನೋವಾ, ಹೊಗ್ಲಾ, ಮಿಲ್ಕಾ, ತಿರ್ಚಾ ಎಂಬುವವರು ಮೋಶೆಯ ಬಳಿ ಒಂದು ವಿಜ್ಞಾಪನೆಯನ್ನು ಮಾಡಿಕೊಳ್ಳುವುದಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ಅವರು ದೇವದರ್ಶನದ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿಯಲ್ಲಿ ಮೋಶೆ, ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರ್, ಕುಲಾಧಿಪತಿಗಳು, ಸರ್ವಸಮೂಹದವರೆಲ್ಲರ ಮುಂದೆ ನಿಂತು ಅವರಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“ನಮ್ಮ ತಂದೆ ಮರುಭೂಮಿಯಲ್ಲಿ ಸತ್ತುಹೋದನು. ಅವನು ಕೋರಹನ ಸಮೂಹದವರು ಯೆಹೋವನಿಗೆ ವಿರುದ್ಧವಾಗಿ ತಿರುಗಿಬಿದ್ದವರೊಳಗೆ ಸೇರಿದವನಲ್ಲ. ಅವನು ಸತ್ತದ್ದು ಸ್ವಂತ ಕರ್ಮಫಲವೇ. ಅವನಿಗೆ ಗಂಡು ಮಕ್ಕಳಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ನಮ್ಮ ತಂದೆಗೆ ಗಂಡು ಮಗನಿಲ್ಲದ ಕಾರಣದಿಂದ ಅವನ ಹೆಸರು ಕುಲದಿಂದ ತೆಗೆದು ಹಾಕುವುದು ನ್ಯಾಯವೋ? ತಂದೆಯ ಕುಲದವರೊಂದಿಗೆ ನಮಗೂ ಸ್ವತ್ತನ್ನು ಕೊಡಬೇಕು” ಎಂದು ಕೇಳಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ಮೋಶೆಯು ಅವರ ವಿಜ್ಞಾಪನೆಯನ್ನು ಯೆಹೋವನ ಸಮ್ಮುಖದಲ್ಲಿ ವಿಚಾರಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ಚಲ್ಪಹಾದನ ಹೆಣ್ಣು ಮಕ್ಕಳು ಹೇಳುವುದು ನ್ಯಾಯವಾಗಿದೆ. ಅವರ ತಂದೆಯ ಕುಲದವರೊಂದಿಗೆ ಅವರಿಗೂ ನೀನು ಸ್ವತ್ತನ್ನು ಕೊಡಬೇಕು. ತಂದೆಯ ಸ್ವತ್ತು ಅವರಿಗೆ ಬರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ಯಾವನಾದರೂ ಮಗನಿಲ್ಲದೆ ಸತ್ತರೆ ಅವನ ಸ್ವತ್ತು ಅವನ ಮಗಳಿಗೆ ಆಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ಮಗಳೂ ಇಲ್ಲದ ಪಕ್ಷಕ್ಕೆ ಅವನ ಸ್ವತ್ತನ್ನು ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ಅಣ್ಣತಮ್ಮಂದಿರಿಲ್ಲದ ಪಕ್ಷಕ್ಕೆ ಅವನ ಸ್ವತ್ತನ್ನು ತಂದೆಯ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ಇವರೂ ಇಲ್ಲದಿದ್ದರೆ ಕುಲದವರಲ್ಲಿ ಸಮೀಪಬಂಧುವಿಗೆ ಕೊಡಬೇಕು. ಇವನೇ ಆ ಸ್ವತ್ತನ್ನು ಅನುಭವಿಸಲಿ. ಯೆಹೋವನು ಮೋಶೆಗೆ ಅಪ್ಪಣೆಮಾಡಿದ ಈ ತೀರ್ಮಾನವು ಇಸ್ರಾಯೇಲರಿಗೆ ನ್ಯಾಯನಿಯಮಗಳಾಗಿರಬೇಕು.’” ");
INSERT INTO kanirv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಈ ಅಬಾರೀಮ್ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ನಾನು ಇಸ್ರಾಯೇಲರಿಗೆ ವಾಗ್ದಾನಮಾಡಿದ ದೇಶವನ್ನು ನೋಡು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನು ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರಿದಂತೆಯೇ ನೀನೂ ಆ ದೇಶವನ್ನು ನೋಡಿದ ಮೇಲೆ ಸೇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ಚಿನ್ ಅರಣ್ಯದಲ್ಲಿ ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರು ನನ್ನೊಡನೆ ವಿವಾದಿಸಿದಾಗ ನೀವಿಬ್ಬರೂ ನನ್ನ ಗೌರವವನ್ನು ಅವರ ಎದುರಿನಲ್ಲಿ ಕಾಪಾಡದೆ ನನ್ನ ಆಜ್ಞೆಯನ್ನು ಉಲ್ಲಂಘಿಸಿದ್ದರಿಂದ ಆ ದೇಶವನ್ನು ಸೇರಬಾರದು” ಎಂದು ಹೇಳಿದೆನು. ಚಿನ್ ಅರಣ್ಯದಲ್ಲಿನ ಮೆರೀಬಾ ಕಾದೇಶಿನ ಪ್ರವಾಹದ ಹತ್ತಿರ ನಡೆದ ಸಂಗತಿಯನ್ನು ಸೂಚಿಸಿ ಇದನ್ನು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ಆಗ ಮೋಶೆಯು ಯೆಹೋವನ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ಎಲ್ಲಾ ಮನುಷ್ಯರ ಆತ್ಮಗಳ ದೇವರಾದ ಯೆಹೋವನು ಈ ಜನ ಸಮೂಹದ ಮೇಲೆ ಒಬ್ಬ ಮನುಷ್ಯನನ್ನು ಇಡಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ಯೆಹೋವನು ಅವರ ಮುಂದಾಗಿ ಹೋಗಲಿ ಅಥವಾ ಅವರನ್ನು ಮುನ್ನಡೆಸಲು, ಮುಂದಾಗಿ ಬರಲಿ ಅವರನ್ನು ಹಿಂದಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬರಲು, ಒಬ್ಬ ನಾಯಕನನ್ನು ನೇಮಿಸು ನಿನ್ನವರಾದ ಈ ಜನ ಸಮೂಹವು ಕುರುಬನಿಲ್ಲದ ಕುರಿಗಳಂತೆ ಆಗಬಾರದು” ಎಂದು ಬೇಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ಅದಕ್ಕೆ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನಲ್ಲಿ ನನ್ನ ಆತ್ಮವು ವಾಸಿಸುತ್ತಿದೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ಅವನನ್ನು ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ ಮತ್ತು ಸಮೂಹದವರೆಲ್ಲರ ಮುಂದೆ ನಿಲ್ಲಿಸಿ ಅವನ ಮೇಲೆ ಕೈಯಿಟ್ಟು ಅವರ ಎದುರಿನಲ್ಲೇ ಅಧಿಕಾರವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ಇಸ್ರಾಯೇಲರ ಸಮೂಹದವರೆಲ್ಲರೂ ಅವನಿಗೆ ವಿಧೇಯರಾಗಿರುವಂತೆ ನಿನ್ನ ಬಗ್ಗೆ ಇರುವ ಗೌರವವನ್ನು ಅವನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ಯೆಹೋವನ ಚಿತ್ತವನ್ನು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕೆ ಅವನು ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ ಹತ್ತಿರ ಬರಬೇಕು. ಎಲ್ಲಾಜಾರನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಊರೀಮಿನ ನ್ಯಾಯದ ಪ್ರಕಾರ ಅವನಿಗೋಸ್ಕರ ವಿಚಾರಣೆಯನ್ನು ಮಾಡಬೇಕು. ಯೆಹೋಶುವನೂ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರೂ ಅವನ ಮಾತಿನಂತೆ ಹೊರಡಬೇಕು, ಹಿಂತಿರುಗಬೇಕು, ಅವನ ಮಾತಿನಂತೆ ನಡೆಯಬೇಕು.” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಮೋಶೆಯು ಯೆಹೋಶುವನನ್ನು ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ ಮತ್ತು ಸರ್ವಸಮೂಹದವರ ಮುಂದೆ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ಅವನ ಮೇಲೆ ತನ್ನ ಕೈಗಳನ್ನಿಟ್ಟು ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಅವನಿಗೆ ಅಧಿಕಾರವನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಿ ಅವರಿಗೆ, ‘ನನಗೆ ಸುಗಂಧಹೋಮಮಾಡುವುದಕ್ಕಾಗಿ ಇಸ್ರಾಯೇಲರು ನನಗೋಸ್ಕರ ತರುವ ಆಹಾರವನ್ನು ನೇಮಕವಾದ ಕಾಲಗಳಲ್ಲಿ ತಂದು ಎಚ್ಚರಿಕೆಯಿಂದ ಸಮರ್ಪಿಸಬೇಕೆಂದು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸು.’ ");
INSERT INTO kanirv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ಇದರ ವಿಷಯದಲ್ಲಿ ನೀನು ಹೇಳಬೇಕಾದುದೇನೆಂದರೆ, ‘ನೀವು ಪ್ರತಿದಿನವೂ ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ದೋಷವಿಲ್ಲದ ಒಂದು ವರ್ಷದ ಎರಡು ಕುರಿಮರಿಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ಹೊತ್ತಾರೆಯಲ್ಲಿ ಒಂದು ಕುರಿಯನ್ನು, ಸಾಯಂಕಾಲದಲ್ಲಿ ಒಂದು ಕುರಿಯನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ನೀವು ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಒಂದುವರೆ ಸೇರು ಶ್ರೇಷ್ಠವಾದ ಎಣ್ಣೆಯನ್ನೂ, ಮೂರು ಸೇರು ಹಿಟ್ಟನ್ನು ಬೆರೆಸಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ನೀವು ಪ್ರತಿನಿತ್ಯವೂ ಯೆಹೋವನಿಗೆ ಸುಗಂಧಕರವಾದ ಈ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಮಾಡಬೇಕೆಂಬುದಾಗಿ ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ನೇಮಕವಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ಒಂದು ಕುರಿಮರಿಯೊಂದಿಗೆ ಪರಿಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಒಂದುವರೆ ಸೇರು ಅಮಲೇರುವ ದ್ರಾಕ್ಷಾರಸದ ಪಾನದ್ರವ್ಯ ಅರ್ಪಣೆಗಾಗಿ, ಯೆಹೋವನಿಗೋಸ್ಕರ ಹೊಯ್ದುಬಿಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ಸಾಯಂಕಾಲದಲ್ಲಿ ಇನ್ನೊಂದು ಕುರಿಯನ್ನು ಹೋಮಮಾಡುವಾಗ ಹೊತ್ತಾರೆಯಲ್ಲಿ ಮಾಡಿದ ಪ್ರಕಾರವೇ ಅದರೊಂದಿಗೆ ಧಾನ್ಯದ್ರವ್ಯ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಕರ ಹೋಮವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎರಡು ಪೂರ್ಣಾಂಗವಾದ ದೋಷವಿಲ್ಲದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಯನ್ನು, ಎಣ್ಣೆ ಬೆರಸಿದ ಆರು ಸೇರು ಹಿಟ್ಟನ್ನೂ, ಅದಕ್ಕೆ ತಕ್ಕ ಪಾನದ ಸಮರ್ಪಣೆಯನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮವು ಹೊರತು ಪ್ರತಿ ಸಬ್ಬತ್ತಿಗೆ ತಕ್ಕ ಸರ್ವಾಂಗಹೋಮವು, ಅದರ ಪಾನದ್ರವ್ಯದ ಅರ್ಪಣೆಯೂ ಆಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘ಪ್ರತಿ ತಿಂಗಳ ಆರಂಭದಲ್ಲಿ ನೀವು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಎರಡು ಟಗರು, ಏಳು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ದೋಷವಿಲ್ಲದ ಕುರಿಮರಿಗಳು ಇವುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ಒಂದೊಂದು ಹೋರಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಕಲಸಿದ ಒಂಭತ್ತು ಸೇರು ಹಿಟ್ಟನ್ನೂ, ಟಗರಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಆರು ಸೇರು ಹಿಟ್ಟನ್ನು ಸೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ಕುರಿಮರಿಗೆ ಧಾನ್ಯ ಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಮೂರು ಸೇರು ಹಿಟ್ಟನ್ನು ಯೆಹೋವನಿಗೆ ಸುಗಂಧವಾಸನೆಯ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಬೆಂಕಿಯಿಂದ ಮಾಡಿದ ಬಲಿಯೂ ಇದೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ಇವುಗಳಿಗೆ ತಕ್ಕ ಪಾನದ್ರವ್ಯಾರ್ಪಣೆ ಯಾವುದೆಂದರೆ: ಒಂದೊಂದು ಹೋರಿಗೆ ಮೂರು ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನು, ಟಗರಿಗೆ ಎರಡು ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನು, ಕುರಿಗೆ ಒಂದುವರೆ ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನು, ವರ್ಷದ ಪ್ರತಿ ತಿಂಗಳಿನ ಆರಂಭದಲ್ಲಿ ಹೀಗೆ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮ ಹೊರತು ದೋಷಪರಿಹಾರ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಅದಕ್ಕೆ ತಕ್ಕ ಪಾನದ ಅರ್ಪಣೆಯನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ನೇಮಿಸಿದ ಹಬ್ಬವಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ಅದೇ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ಜಾತ್ರೆ ಪ್ರಾರಂಭವಾಗುವುದು; ಏಳು ದಿನಗಳವರೆಗೂ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಕೂಡಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನು ನಡೆಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳನ್ನೂ, ಒಂದು ಟಗರನ್ನೂ ಮತ್ತು ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ಈ ಪಶುಗಳೂ ಪೂರ್ಣಾಂಗವಾಗಿ ದೋಷವಿಲ್ಲದೆಯೇ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ಇವುಗಳೊಂದಿಗೆ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಹಿಟ್ಟನ್ನು ತಂದುಕೊಡಬೇಕು. ಹೋರಿಗೆ ಒಂಭತ್ತು ಸೇರು, ಟಗರಿಗೆ ಆರು ಸೇರು, ");
INSERT INTO kanirv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ಏಳು ಕುರಿಮರಿಯಲ್ಲಿ ಒಂದೊಂದಕ್ಕೆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಮೂರು ಸೇರನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ಅದಲ್ಲದೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ಪ್ರತಿ ದಿನದ ಪ್ರಾತಃಕಾಲದಲ್ಲಿ ಸರ್ವಾಂಗಹೋಮವಲ್ಲದೆ ಇವುಗಳನ್ನು ಹೆಚ್ಚಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ಆ ಏಳು ದಿನಗಳಲ್ಲಿಯೂ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಸಮರ್ಪಿಸುವುದಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದ ಕ್ರಮದ ಪ್ರಕಾರ ಪ್ರತಿದಿನವೂ ಹೋಮರೂಪವಾಗಿ ಯೆಹೋವನಿಗೆ ಆಹಾರವನ್ನು, ಪಾನದ್ರವ್ಯವನ್ನು ಸಹ ಸಮರ್ಪಿಸಿ ಆತನಿಗೋಸ್ಕರ ಸುವಾಸನೆಯನ್ನುಂಟುಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ಏಳನೆಯ ದಿನದಲ್ಲೂ ಸಭೆಕೂಡಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನು ನಡೆಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘ಪಸ್ಕವಾದ ಏಳು ವಾರಗಳ ಮೇಲೆ ನೀವು ಹೊಸ ಬೆಳೆಯ ಗೋದಿಯನ್ನು ಯೆಹೋವನಿಗೆ ನೈವೇದ್ಯಮಾಡುವಾಗ ಪ್ರಥಮಫಲಾರ್ಪಣೆಯ ದಿನದಲ್ಲಿ ನೀವು ಯಾವ ಉದ್ಯೋಗವನ್ನು ನಡೆಸದೆ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಕೂಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ಆ ದಿನದಲ್ಲಿ ನೀವು ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕೋಸ್ಕರ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಎರಡು ಹೋರಿ, ಒಂದು ಟಗರು, ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಗಳು ಇವುಗಳನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರಸಿದ ಹಿಟ್ಟನ್ನು ಹಾಗೂ ಪ್ರತಿಯೊಂದು ಟಗರಿಗೆ ಒಂಭತ್ತು ಸೇರು, ");
INSERT INTO kanirv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ಹೋರಿಗೆ ಆರು ಸೇರು, ಕುರಿಗೆ ಮೂರು ಸೇರು ಹಿಟ್ಟನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ದೋಷಪರಿಹಾರ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ಈ ಪಶುಗಳೆಲ್ಲಾ ಪೂರ್ಣಾಂಗವಾಗಿ ಕುಂದುಕೊರತೆ ಇಲ್ಲದೆ ಇರಬೇಕು. ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದಕ್ಕೆ ಸೇರಿದ ಧಾನ್ಯದ್ರವ್ಯ, ನೈವೇದ್ಯ ಇವುಗಳನ್ನಲ್ಲದೆ ಮೇಲೆ ಕಂಡ ಯಜ್ಞಗಳನ್ನೂ ಅವುಗಳೊಡನೆ ಕೊಡಬೇಕಾದ ಪಾನದ್ರವ್ಯ, ನೈವೇದ್ಯಗಳನ್ನೂ ಹೆಚ್ಚಾಗಿ ಸಮರ್ಪಿಸಬೇಕು.’” ");
INSERT INTO kanirv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘ತುತ್ತೂರಿಗಳ ಧ್ವನಿಯಿಂದ ಪ್ರಕಟವಾಗುವ ಏಳನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಯಾವ ಉದ್ಯೋಗವನ್ನೂ ನಡೆಸದೆ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಕೂಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ಅದರಲ್ಲಿ ನೀವು ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವ ದೋಷವಿಲ್ಲದ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು, ಏಳು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಆ ಹೋರಿಗೆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಒಂಭತ್ತು ಸೇರು ಹಿಟ್ಟನ್ನು, ಟಗರಿಗೆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಆರು ಸೇರು ಹಿಟ್ಟನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ಆ ಏಳು ಕುರಿಮರಿಗಳಲ್ಲಿ ಒಂದೊಂದಕ್ಕೆ ಮೂರು ಸೇರು ಎಣ್ಣೆ ಬೆರಸಿದ ಹಿಟ್ಟನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ಪ್ರತಿ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಮಾಡಬೇಕಾದ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ, ಅವುಗಳಿಗೆ ನೇಮಕವಾದ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ, ನೈವೇದ್ಯಗಳನ್ನೂ ಮಾತ್ರವಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದ ಯಜ್ಞಗಳನ್ನು ಹೆಚ್ಚಾಗಿ ಮಾಡಬೇಕು. ಅವು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಹೋಮವಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಯಾವ ಕೆಲಸವನ್ನೂ ಮತ್ತು ಊಟವನ್ನು ಮಾಡದೆ ನಿಮ್ಮನ್ನು ತಗ್ಗಿಸಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಕೂಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ನೀವು ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ದೋಷವಿಲ್ಲದ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು, ಏಳು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಹೋರಿಗೆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಒಂಭತ್ತು ಸೇರು ಹಿಟ್ಟನ್ನು, ಟಗರಿಗೆ ಆರು ಸೇರು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹಿಟ್ಟನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ಏಳು ಕುರಿಗಳಲ್ಲಿ ಒಂದೊಂದಕ್ಕೆ ಎಣ್ಣೆ ಬೆರಸಿದ ಮೂರು ಸೇರು ಹಿಟ್ಟನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ಆ ದಿನಕ್ಕೆ ನೇಮಕವಾದ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮ, ಧಾನ್ಯದ್ರವ್ಯ, ಪಾನದ್ರವ್ಯ, ನೈವೇದ್ಯಗಳನ್ನಲ್ಲದೆ ಮೇಲೆ ಕಂಡ ಯಜ್ಞಗಳನ್ನು ಹೆಚ್ಚಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಕೂಡಬೇಕು. ನೀವು ಆ ದಿನದಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನೂ ನಡೆಸಬಾರದು. ಆ ದಿನ ಮೊದಲುಗೊಂಡು ಏಳು ದಿನಗಳವರೆಗೆ ಯೆಹೋವನಿಗೆ ಉತ್ಸವವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ಆ ದಿನದಲ್ಲಿ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮ, ಧಾನ್ಯದ್ರವ್ಯ, ಪಾನದ್ರವ್ಯ, ನೈವೇದ್ಯಗಳನ್ನೂ ಮಾತ್ರವಲ್ಲದೆ ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ದೋಷವಿಲ್ಲದ ಹದಿಮೂರು ಹೋರಿಗಳನ್ನೂ, ಎರಡು ಟಗರುಗಳನ್ನೂ, ಹದಿನಾಲ್ಕು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಗಳನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಪ್ರತಿಯೊಂದು ಹೋರಿಗೆ ಎಣ್ಣೆ ಬೆರಸಿದ ಒಂಭತ್ತು ಸೇರು ಹಿಟ್ಟನ್ನೂ, ಟಗರಿಗೆ ಎಣ್ಣೆ ಬೆರಸಿದ ಆರು ಸೇರು ಹಿಟ್ಟನ್ನು, ");
INSERT INTO kanirv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ಹದಿನಾಲ್ಕು ಕುರಿಮರಿಗಳಿಗೆ ಎಣ್ಣೆ ಬೆರಸಿದ ಮೂರು ಸೇರು ಹಿಟ್ಟನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮವನ್ನು, ಧಾನ್ಯನೈವೇದ್ಯವನ್ನು, ಪಾನದ್ರವ್ಯವನ್ನು ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“‘ಆ ಉತ್ಸವದ ಎರಡನೆಯ ದಿನದಲ್ಲಿ ನೀವು ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮವನ್ನೂ, ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಮಾತ್ರವಲ್ಲದೆ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ದೋಷವಿಲ್ಲದ ಹನ್ನೆರಡು ಹೋರಿ, ಎರಡು ಟಗರು, ಹದಿನಾಲ್ಕು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ನೈವೇದ್ಯಕ್ಕಾಗಿ ಹೋರಿ, ಟಗರು ಮತ್ತು ಕುರಿಮರಿ ಈ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“‘ಮೂರನೆಯ ದಿನದಲ್ಲಿ ದೋಷವಿಲ್ಲದ ಹನ್ನೊಂದು ಹೋರಿ, ಎರಡು ಟಗರು, ಹದಿನಾಲ್ಕು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಗಳನ್ನೂ, ");
INSERT INTO kanirv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ನೈವೇದ್ಯಕ್ಕಾಗಿ ಹೋರಿ, ಟಗರು, ಮತ್ತು ಕುರಿಮರಿಗಳನ್ನು ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಅದರೊಂದಿಗೆ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ, ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“‘ನಾಲ್ಕನೆಯ ದಿನದಲ್ಲಿ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮವನ್ನೂ ಅದಕ್ಕೆ ನೇಮಕವಾದ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಮಾತ್ರವಲ್ಲದೆ ದೋಷವಿಲ್ಲದ ಹತ್ತು ಹೋರಿ, ಎರಡು ಟಗರು, ಹದಿನಾಲ್ಕು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ನೈವೇದ್ಯಕ್ಕಾಗಿ ಹೋರಿ, ಟಗರು ಮತ್ತು ಕುರಿಮರಿ ಈ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಅದರೊಂದಿಗೆ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ, ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“‘ಐದನೆಯ ದಿನದಲ್ಲಿ ನೀವು ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮವನ್ನೂ ಅದಕ್ಕೆ ನೇಮಕವಾದ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಮಾತ್ರವಲ್ಲದೆ ದೋಷವಿಲ್ಲದ ಒಂಭತ್ತು ಹೋರಿ, ಎರಡು ಟಗರು, ಹದಿನಾಲ್ಕು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ನೈವೇದ್ಯಕ್ಕಾಗಿ ಹೋರಿ, ಟಗರು ಮತ್ತು ಕುರಿಮರಿ ಈ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ, ಅದರೊಂದಿಗೆ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ, ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“‘ಆರನೆಯ ದಿನದಲ್ಲಿ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮವನ್ನೂ ಅದಕ್ಕೆ ನೇಮಕವಾದ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಮಾತ್ರವಲ್ಲದೆ ದೋಷವಿಲ್ಲದ ಎಂಟು ಹೋರಿ, ಎರಡು ಟಗರು, ಹದಿನಾಲ್ಕು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ನೈವೇದ್ಯಕ್ಕಾಗಿ ಹೋರಿ, ಟಗರು ಮತ್ತು ಕುರಿಮರಿ ಈ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಅದರೊಂದಿಗೆ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ, ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“‘ಏಳನೆಯ ದಿನದಲ್ಲಿ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮವನ್ನೂ ಅದಕ್ಕೆ ನೇಮಕವಾದ ದೋಷವಿಲ್ಲದ ಏಳು ಹೋರಿ, ಎರಡು ಟಗರು, ಹದಿನಾಲ್ಕು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ನೈವೇದ್ಯಕ್ಕಾಗಿ ಹೋರಿ, ಟಗರು ಮತ್ತು ಕುರಿಮರಿ ಈ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಅದರೊಂದಿಗೆ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ, ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“‘ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ದೇವಾರಾಧನೆಗೆ ಸಭೆ ಕೂಡಿಬರಬೇಕು. ಅದರಲ್ಲಿ ಯಾವ ಉದ್ಯೋಗವನ್ನೂ ನಡೆಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ನೀವು ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಅದಕ್ಕೆ ನೇಮಕವಾದ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಮಾತ್ರವಲ್ಲದೆ ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ದೋಷವಿಲ್ಲದ ಒಂದು ಹೋರಿ, ಒಂದು ಟಗರು, ಏಳು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","“‘ನೈವೇದ್ಯಕ್ಕಾಗಿ ಹೋರಿ, ಟಗರು ಮತ್ತು ಕುರಿಮರಿ ಈ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು ");
INSERT INTO kanirv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಅದರೊಂದಿಗೆ ನಿತ್ಯ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ, ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ, ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“‘ನೀವು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಹರಕೆಯನ್ನು ತೀರಿಸುವುದಕ್ಕಾಗಲಿ ಮಾಡುವ ಸರ್ವಾಂಗಹೋಮ, ಧಾನ್ಯದ್ರವ್ಯ ನೈವೇದ್ಯ, ಪಾನದ್ರವ್ಯ, ಸಮಾಧಾನಯಜ್ಞ ಇವುಗಳನ್ನಲ್ಲದೆ ಹಬ್ಬಗಳ ದಿನಗಳಲ್ಲಿ ಮೇಲೆ ಸೂಚಿಸಿರುವ ಯಜ್ಞಗಳನ್ನೂ ಹೆಚ್ಚಾಗಿ ಮಾಡಬೇಕು.’” ");
INSERT INTO kanirv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ಯೆಹೋವನು ಮಾಡಿದ ಈ ಎಲ್ಲಾ ಆಜ್ಞೆಗಳನ್ನು ಮೋಶೆ ಇಸ್ರಾಯೇಲರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರ ಕುಲಾಧಿಪತಿಗಳಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ಯೆಹೋವನು ಹೀಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಾನೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ಯಾವನಾದರೂ ಯೆಹೋವನಿಗೆ ಹರಕೆ ಮಾಡಿದರೆ ಇಲ್ಲವೆ ತಾನು ಅಶುದ್ಧವಾದುದನ್ನು ಮುಟ್ಟದೆ ಇರುವೆನೆಂದು ಆಣೆಯಿಟ್ಟುಕೊಂಡರೆ ಅವನು ತನ್ನ ಮಾತನ್ನು ಮೀರದೆ ಹೇಳಿದಂತೆಯೇ ನೆರವೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“ಸ್ತ್ರೀಯು ಕನ್ಯಾವಸ್ಥೆಯಲ್ಲಿ ತಂದೆಯ ಮನೆಯಲ್ಲಿದ್ದು ಯೆಹೋವನಿಗೆ ಹರಕೆಯನ್ನು ಮಾಡಿದಾಗ ಇಲ್ಲವೆ ಯಾವುದಾದರೂ ಒಂದನ್ನು ಮುಟ್ಟದೆ ಇರುವೆನೆಂದು ಪ್ರತಿಜ್ಞೆಯನ್ನು ಮಾಡಿಕೊಂಡಾಗ ");
INSERT INTO kanirv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ಅವಳ ತಂದೆಯು ಆ ಸಂಗತಿಯನ್ನು ತಿಳಿದು ಸುಮ್ಮನಿದ್ದರೆ ಅವಳು ಆ ಹರಕೆಯನ್ನು ನೆರವೇರಿಸಲೇಬೇಕು. ಯಾವುದನ್ನು ಮುಟ್ಟದೆ ಇರುವೆನೆಂದು ಹೇಳಿದಳೋ ಅದನ್ನು ಮುಟ್ಟಲೇ ಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ಆದರೆ ತಂದೆ ಆ ಸಂಗತಿಯನ್ನು ತಿಳಿದಾಗ ಹಾಗೆ ಮಾಡಬಾರದೆಂದು ಅಪ್ಪಣೆಕೊಟ್ಟರೆ ಅವಳು ಮಾಡಿದ ಹರಕೆಗಳೂ, ಪ್ರತಿಜ್ಞೆಗಳೂ ವ್ಯರ್ಥವಾಗುವವು. ತಂದೆ ಕ್ಷಮಿಸಿ ಬೇಡವೆಂದು ಹೇಳಿದ್ದರಿಂದ ಯೆಹೋವನು ಅವಳನ್ನು ದೋಷಿಯೆಂದು ಎಣಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ಅವಳು ಮದುವೆಯಾದ ಪಕ್ಷದಲ್ಲಿ ಮಾಡಿದ ಹರಕೆ ಇಲ್ಲವೆ ಯೋಚಿಸದೆ ಮಾಡಿದ ಪ್ರತಿಜ್ಞೆ ನಡೆಯುವಷ್ಟರೊಳಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ಗಂಡನು ಆ ಪ್ರಮಾಣದ ಸಂಗತಿಯನ್ನು ತಿಳಿದು ಸುಮ್ಮನಿದ್ದರೆ ಆ ಹರಕೆಗಳೂ, ಪ್ರತಿಜ್ಞೆಗಳೂ ನಡೆಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ಆದರೆ ಗಂಡನು ಕೇಳಿದಾಗಲೇ ಕ್ಷಮಿಸಿ ಬೇಡವೆಂದು ಅಪ್ಪಣೆಕೊಟ್ಟರೆ ಆ ಹರಕೆಯು ಇಲ್ಲವೆ ಆ ಪ್ರತಿಜ್ಞೆಯು ನಿರರ್ಥಕವಾಗುವವು. ಯೆಹೋವನು ಅವಳನ್ನು ದೋಷಿಯೆಂದು ಎಣಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“ವಿಧವೆಯು ಇಲ್ಲವೆ ಗಂಡನಿಂದ ಬಿಡಲ್ಪಟ್ಟ ಸ್ತ್ರೀಯು ಇಂತಹ ಪ್ರಮಾಣಮಾಡಿಕೊಂಡರೆ ಅದು ನಿಲ್ಲುವುದು. ಅವಳು ಅದನ್ನು ನೆರವೇರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ಮುತ್ತೈದೆಯು ಅಂತಹ ಹರಕೆಯನ್ನಾಗಲಿ, ಪ್ರಮಾಣವನ್ನಾಗಲಿ ಮಾಡಿದಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ಅವಳ ಗಂಡನು ತಿಳಿದು ಅಡ್ಡಿಮಾಡದೆ ಸುಮ್ಮನಿದ್ದರೆ ಆ ಹರಕೆಗಳೂ, ಪ್ರತಿಜ್ಞೆಗಳೂ ನಿಲ್ಲುವವು. ");
INSERT INTO kanirv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ಆದರೆ ಗಂಡನು ಅವುಗಳನ್ನು ತಿಳಿದಾಗಲೇ ಬೇಡವೆಂದರೆ ಅವು ರದ್ದಾಗುವವು. ಗಂಡನು ಕ್ಷಮಿಸಿ ಬೇಡವೆಂದು ಹೇಳಿದ್ದರಿಂದ ಅಂಥವಳು ಯೆಹೋವನಿಗೆ ಹರಕೆ ಮಾಡಿದರೂ, ದೋಷಿಯೆಂದು ಎಣಿಸಲ್ಪಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ಹೆಂಡತಿ ಮಾಡಿದ ಹರಕೆಯನ್ನೂ, ಉಪವಾಸವಾಗಿರುವೆನೆಂದು ಅವಳು ಮಾಡಿದ ಪ್ರಮಾಣವನ್ನೂ ಸ್ಥಾಪಿಸುವುದಕ್ಕಾಗಲಿ ರದ್ದುಮಾಡುವುದಕ್ಕಾಗಲಿ ಗಂಡನಿಗೆ ಅಧಿಕಾರವಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ಆದರೆ ಅವಳ ಗಂಡನು ಯಾವ ಅಡ್ಡಿಯನ್ನೂ ಮಾಡದೆ ಸುಮ್ಮನಿದ್ದರೆ ಅವನು ಅವಳ ಹರಕೆಗಳನ್ನೂ, ಪ್ರತಿಜ್ಞೆಗಳನ್ನೂ ಅವನು ನಮೂದಿಸಿದಂತೆ ಆಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ಅವನು ತರುವಾಯ ಬೇಡವೆಂದರೆ ಆ ಪಾಪದ ಫಲವನ್ನು ಅವನೇ ಅನುಭವಿಸಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ಗಂಡಹೆಂಡತಿಯರ ವಿಷಯವಾಗಿಯೂ, ಇನ್ನೂ ಮದುವೆಯಿಲ್ಲದ ಹೆಂಗಸು ಮತ್ತು ಅವಳ ತಂದೆ ಇವರ ವಿಷಯವಾಗಿಯೂ, ಹರಕೆಗಳ ಸಂಬಂಧವಾಗಿಯೂ ಯೆಹೋವನು ಮೋಶೆಗೆ ಕೊಟ್ಟ ನಿಯಮಗಳು ಇವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೋಸ್ಕರ ಮಿದ್ಯಾನ್ಯರಿಗೆ ಪ್ರತಿದಂಡನೆಯನ್ನು ಮಾಡಬೇಕು. ಅನಂತರ ನೀನು ಪೂರ್ವಿಕರ ಬಳಿಗೆ ಸೇರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ಆಗ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ, “ನಿಮ್ಮೊಳಗಿಂದ ಕೆಲವರು ಮಿದ್ಯಾನ್ಯರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧಕ್ಕೆ ಸಿದ್ಧಮಾಡಿಕೊಳ್ಳಬೇಕು. ಯೆಹೋವನ ಪ್ರತಿದಂಡನೆಯನ್ನು ಅವರಿಗೆ ತೀರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ಇಸ್ರಾಯೇಲರ ಒಂದೊಂದು ಕುಲದಿಂದ ಸಾವಿರ ಜನ ಭಟರನ್ನು ಮಿದ್ಯಾನ್ಯರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧಕ್ಕೆ ಕಳುಹಿಸಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ಆದಕಾರಣ ಇಸ್ರಾಯೇಲರು ಕುಲವೊಂದಕ್ಕೆ ಸಾವಿರ ಮಂದಿಯ ಮೇರೆಗೆ ಯುದ್ಧಕ್ಕೆ ಸನ್ನದ್ಧರಾದ ಹನ್ನೆರಡು ಸಾವಿರ ಮಂದಿಯನ್ನು ಎಣಿಕೆಮಾಡಿ ಕಳುಹಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ಮೋಶೆಯು ಇವರನ್ನು ಯುದ್ಧಕ್ಕೆ ಕಳುಹಿಸುವಾಗ ಕುಲವೊಂದಕ್ಕೆ ಸಾವಿರ ಭಟರನ್ನು, ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ ಮಗನಾದ ಫೀನೆಹಾಸನನ್ನು, ದೇವರ ಸಾಮಾನುಗಳನ್ನೂ, ಆಜ್ಞಾತುತೂರಿಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಅವರೊಡನೆ ಹೋಗಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವರು ಮಿದ್ಯಾನ್ಯರೊಡನೆ ಯುದ್ಧಮಾಡಿ ಗಂಡಸರೆಲ್ಲರನ್ನೂ ಸಂಹಾರಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ಖಡ್ಗದಿಂದ ಹತರಾದವರಲ್ಲಿ ಎವೀ, ರೆಕೆಮ್, ಚೂರ್, ಹೂರ್, ರೆಬಾ ಎಂಬ ಮಿದ್ಯಾನ್ಯರ ಐದು ಮಂದಿ ರಾಜರು ಇದ್ದರು. ಅದಲ್ಲದೆ ಬೆಯೋರನ ಮಗನಾದ ಬಿಳಾಮನನ್ನು ಕೊಂದುಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ಇಸ್ರಾಯೇಲರು ಮಿದ್ಯಾನ್ಯರ ಎಲ್ಲಾ ಹೆಂಗಸರನ್ನೂ, ಮಕ್ಕಳನ್ನೂ ಸೆರೆಹಿಡಿದು ಎಲ್ಲಾ ದನಕುರಿಗಳನ್ನೂ, ಆಸ್ತಿಯನ್ನೂ ಸೂರೆಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ಅವರು ಇದ್ದ ಎಲ್ಲಾ ಊರುಗಳನ್ನೂ, ಪಾಳೆಯಗಳನ್ನೂ ಸುಟ್ಟುಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ಒಂದನ್ನೂ ಬಿಡದೆ ಮನುಷ್ಯರನ್ನೂ, ಪಶುಗಳನ್ನೂ ಸೆರೆಹಿಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ಮತ್ತು ಅವರು ಸೆರೆಯವರನ್ನೂ, ಪಶುಗಳನ್ನೂ, ಆಸ್ತಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಯೆರಿಕೋ ಪಟ್ಟಣದ ಎದುರಾಗಿ ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿ ಮೋವಾಬ್ಯರ ಮೈದಾನದಲ್ಲಿದ್ದ ಪಾಳೆಯಕ್ಕೆ ಮೋಶೆ, ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಸರ್ವಸಮೂಹದವರ ಬಳಿಗೆ ಬಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ಮೋಶೆಯೂ, ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನೂ, ಸಮೂಹದ ಪ್ರಧಾನರೂ ಪಾಳೆಯದ ಹೊರಗೆ ಹೋಗಿ ಅವರನ್ನು ಎದುರುಗೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ಆಗ ಮೋಶೆಯು ಯುದ್ಧ ಭೂಮಿಯಿಂದ ಬಂದ ಸೈನ್ಯದ ಸಹಸ್ರಾಧಿಪತಿಗಳ ಮತ್ತು ಶತಾಧಿಪತಿಗಳ ಮೇಲೆ ಕೋಪಗೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ಮೋಶೆಯು ಅವರಿಗೆ, “ನೀವು ಹೆಂಗಸರನ್ನೆಲ್ಲಾ ಉಳಿಸಿದ್ದೇನು? ");
INSERT INTO kanirv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ಪೆಗೋರದ ಬಾಳನ ಸಂಗತಿಯಲ್ಲಿ ಬಿಳಾಮನ ಆಲೋಚನೆಯನ್ನು ಅನುಸರಿಸಿ ಇಸ್ರಾಯೇಲರನ್ನು ಯೆಹೋವನಿಗೆ ದ್ರೋಹಿಗಳನ್ನಾಗಿ ಮಾಡಿ ಸಮೂಹದವರಲ್ಲಿ ಘೋರವ್ಯಾಧಿ ಉಂಟಾಗುವಂತೆ ಮಾಡಿದವರು ಇವರೇ ಅಲ್ಲವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ಆದಕಾರಣ ನೀವು ಈ ಗುಂಪಿನಲ್ಲಿರುವ ಎಲ್ಲಾ ಗಂಡು ಮಕ್ಕಳನ್ನೂ, ಪುರುಷ ಸಂಗಮಾಡಿದ ಎಲ್ಲಾ ಹೆಂಗಸರನ್ನೂ ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ಪುರುಷ ಸಂಗಮಾಡದಿರುವ ಕನ್ಯೆಯರನ್ನು ನಿಮಗೋಸ್ಕರ ಉಳಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","ನೀವಾದರೋ ಏಳು ದಿನದವರೆಗೂ ಪಾಳೆಯದ ಹೊರಗೆ ಇರಬೇಕು. ಮನುಷ್ಯ ಪ್ರಾಣತೆಗೆದವರೂ, ಶವಸೋಂಕಿದವರೂ, ನಿಮ್ಮವರಾದರೂ, ಸೆರೆಯವರಾದರೂ ಮೂರನೆಯ ಮತ್ತು ಏಳನೆಯ ದಿನಗಳಲ್ಲಿ ದೋಷಪರಿಹಾರ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ಅದಲ್ಲದೆ ಎಲ್ಲಾ ಬಟ್ಟೆಗಳನ್ನೂ, ತೊಗಲಿನ ಸಾಮಾನನ್ನೂ, ಮೇಕೆ ಕೂದಲಿನ ವಸ್ತ್ರಗಳನ್ನು ಮರದ ವಸ್ತುಗಳನ್ನು ಶುದ್ಧ ಮಾಡಿಕೊಳ್ಳಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ಯುದ್ಧಕ್ಕೆ ಹೋಗಿದ್ದ ಭಟರಿಗೆ ಹೀಗೆಂದನು, “ಯೆಹೋವನು ಮೋಶೆಗೆ ಅಪ್ಪಣೆಮಾಡಿದ ನಿಯಮ ಏನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ಬೆಂಕಿಯನ್ನು ತಡೆಯುವ ಚಿನ್ನ, ಬೆಳ್ಳಿ, ತಾಮ್ರ, ಕಬ್ಬಿಣ, ತವರ, ಸೀಸ ಮೊದಲಾದವುಗಳನ್ನು ಬೆಂಕಿದಾಟಿಸಿ ಶುದ್ಧಮಾಡಬೇಕು, ");
INSERT INTO kanirv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ಅವುಗಳನ್ನು ಹೊಲೆ ಹೋಗಲಾಡಿಸುವ ನೀರಿನಿಂದಲೂ ಶುದ್ಧಮಾಡಬೇಕು. ಬೆಂಕಿಯಿಂದ ಸುಡಲಾರದ ವಸ್ತುಗಳನ್ನು ನೀರಿನಿಂದ ತೊಳೆದು ಶುದ್ಧಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ಏಳನೆಯ ದಿನದಲ್ಲಿ ನಿಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡ ನಂತರ ಶುದ್ಧರಾಗುವಿರಿ. ಆ ಮೇಲೆ ನೀವು ಪಾಳೆಯದೊಳಗೆ ಬರಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“ನೀನೂ, ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನೂ, ಕುಲಾಧಿಪತಿಗಳೂ ಸಮೂಹದವರ ಕೈಗೆ ಸಿಕ್ಕಿದ ಮನುಷ್ಯರನ್ನೂ, ಪಶುಗಳನ್ನೂ ಲೆಕ್ಕಿಸಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ಒಟ್ಟು ಎರಡು ಭಾಗಮಾಡಿ ಯುದ್ಧಕ್ಕೆ ಹೋದ ಭಟರಿಗೆ ಅರ್ಧವನ್ನೂ, ಮಿಕ್ಕ ಸಮೂಹದವರಿಗೆ ಅರ್ಧವನ್ನೂ ಹಂಚಿಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ಯುದ್ಧಕ್ಕೆ ಹೋದ ಭಟರಿಗೆ ಬರುವ ಭಾಗದಿಂದ ಮನುಷ್ಯ, ದನ, ಕತ್ತೆ, ಆಡು, ಕುರಿ ಇವುಗಳಲ್ಲಿ ನೀನು ಐನೂರರಲ್ಲಿ ಒಂದರ ಮೇರೆಗೆ ಯೆಹೋವನಿಗೆ ಕಪ್ಪವನ್ನು ಎತ್ತಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ಅವರ ಅರ್ಧಪಾಲಿನಿಂದ ಅದನ್ನು ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನಿಗೆ ಅರ್ಪಣೆಯಾಗಿ ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನಿಗೆ ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ಉಳಿದ ಇಸ್ರಾಯೇಲರಿಗೆ ಬರುವ ಭಾಗದಿಂದ ಮನುಷ್ಯ, ದನ, ಕತ್ತೆ, ಆಡು, ಕುರಿ ಇವುಗಳಲ್ಲಿ ಐವತ್ತರಲ್ಲಿ ಒಂದರ ಮೇರೆಗೆ ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನ ಗುಡಾರವನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಲೇವಿಯರಿಗೆ ಕೊಡಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆಯೂ, ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನೂ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ಭಟರು ತಂದ ಸುಲಿಗೆಯಲ್ಲಿ ಹಂಚಿಕೊಳ್ಳುವುದಕೋಸ್ಕರ ಉಳಿದದ್ದು ಎಷ್ಟೆಂದರೆ: ಕುರಿಗಳು - 6,75,000, ");
INSERT INTO kanirv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ದನಗಳು - 72,000, ");
INSERT INTO kanirv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ಕತ್ತೆಗಳು - 61,000, ");
INSERT INTO kanirv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ಕನ್ಯೆಯರು - 32,000. ");
INSERT INTO kanirv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ಯುದ್ಧಕ್ಕೆ ಹೋಗಿದ್ದ ಭಟರಿಗೆ ದೊರಕಿದ ಅರ್ಧ ಭಾಗವಾಗಿರುವ ಕುರಿಗಳು - 3,37,500. ");
INSERT INTO kanirv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ಕುರಿಗಳಿಂದ ಯೆಹೋವನಿಗೆ ಬಂದ ಕಪ್ಪ - 675. ");
INSERT INTO kanirv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ಹಾಗೆಯೇ ಅವರಿಗೆ ದೊರಕಿದ 36,000, ಎತ್ತುಗಳಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಬಂದ ಕಪ್ಪ - 72. ");
INSERT INTO kanirv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ಕತ್ತೆಗಳಲ್ಲಿ - 30,500 ಯೆಹೋವನಿಗೆ ಬಂದ ಕಪ್ಪ - 61 ");
INSERT INTO kanirv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","16,000 ಕನ್ಯೆಯರಲ್ಲಿ, ಯೆಹೋವನಿಗೆ ಬಂದ ಕಪ್ಪ - 32 ಕನ್ಯೆಯರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆ ಆ ಕಪ್ಪವನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿ ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನಿಗೆ ಒಪ್ಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ಇಸ್ರಾಯೇಲರ ಭಟರು ತಂದ ಸುಲಿಗೆಯಲ್ಲಿ ಮೋಶೆ ಪ್ರತ್ಯೇಕಿಸಿ ಹಂಚಿದ ಅರ್ಧ ಭಾಗ ");
INSERT INTO kanirv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ಎಷ್ಟೆಂದರೆ - 3,37,500 ಆಡುಕುರಿಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ಎತ್ತುಗಳು - 36,000, ");
INSERT INTO kanirv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ಕತ್ತೆಗಳು - 30,500, ");
INSERT INTO kanirv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ಕನ್ಯೆಯರು - 16,000, ಇಷ್ಟು ಇಸ್ರಾಯೇಲ ಸಮೂಹದವರ ಪಾಲಿಗೆ ಬಂದವು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ಇವುಗಳಲ್ಲಿ ಮೋಶೆಯು ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಇಸ್ರಾಯೇಲರಲ್ಲಿ ಐವತ್ತರಲ್ಲಿ ಒಂದರ ಮೇರೆಗೆ ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನ ಗುಡಾರವನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಲೇವಿಯರಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ಆಗ ದಂಡಿನ ಸಹಸ್ರಾಧಿಪತಿಗಳೂ ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","“ನಿನ್ನ ದಾಸರಾದ ನಾವು ನಮ್ಮ ಅಧಿಕಾರದೊಳಗೆ ಇದ್ದ ಭಟರನ್ನು ಲೆಕ್ಕಿಸಲಾಗಿ ಒಬ್ಬನಾದರೂ ಕಡಿಮೆಯಾಗಿಲ್ಲವೆಂದು ಗೊತ್ತಾಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ಆದಕಾರಣ ಯೆಹೋವನು ಕಾಪಾಡಿದ ನಮ್ಮ ಪ್ರಾಣಗಳಿಗೆ ಈಡಾಗಿ ಆತನಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಕಾಣಿಕೆಯಾಗಿ ನಮ್ಮಲ್ಲಿ ಒಬ್ಬೊಬ್ಬನು ತನಗೆ ಸಿಕ್ಕಿದ ಚಿನ್ನದ ಒಡವೆಗಳಲ್ಲಿ ತೋಳ್ಬಳೆ, ಕಡಗ, ಮುದ್ರೆಯುಂಗರ, ಮುರುವು, ಕಂಠಮಾಲೆ ಮುಂತಾದವುಗಳನ್ನು ತಂದಿದ್ದೇವೆ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ಅವರು ಕೊಟ್ಟ ಆ ಚಿನ್ನದ ಒಡವೆಗಳನ್ನು ಮೋಶೆಯೂ, ಮಹಾಯಾಜಕ ಎಲ್ಲಾಜಾರನೂ ತೆಗೆದುಕೊಂಡರು. ಅವುಗಳೆಲ್ಲಾ ವಿಚಿತ್ರವಾದ ಆಭರಣಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ಸಹಸ್ರಾಧಿಪತಿಗಳೂ, ಶತಾಧಿಪತಿಗಳೂ ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿ ಸಮರ್ಪಿಸಿದ ಕಾಣಿಕೆಯ ಒಟ್ಟು ತೂಕ - 16,750 ತೊಲೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ಅದಲ್ಲದೆ ದಂಡಿನವರೆಲ್ಲರೂ ಸ್ವಂತಕ್ಕಾಗಿ ಲೂಟಿಯನ್ನು ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ಸಹಸ್ರಾಧಿಪತಿಗಳೂ, ಶತಾಧಿಪತಿಗಳೂ, ಕೊಟ್ಟ ಚಿನ್ನವನ್ನು ಮೋಶೆಯೂ, ಮಹಾಯಾಜಕ ಎಲ್ಲಾಜಾರನೂ ತೆಗೆದುಕೊಂಡು ಇಸ್ರಾಯೇಲರ ವಿಷಯದಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಜ್ಞಾಪಕ ಮಾಡುವುದಕ್ಕಾಗಿ ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ತಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ರೂಬೇನ್ ಕುಲದವರಿಗೂ, ಗಾದ್ ಕುಲದವರಿಗೂ ಬಹಳ ದನಕುರಿಗಳಿದ್ದವು. ಯಗ್ಜೇರ್, ಗಿಲ್ಯಾದ್ ಎಂಬ ಪ್ರದೇಶವನ್ನು ನೋಡಿದಾಗ ಅವು ದನಕುರಿಗಳ ಮೇವಿಗೆ ತಕ್ಕ ಸ್ಥಳವೆಂದು ತಿಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ಗಾದ್ ಮತ್ತು ರೂಬೇನ್ ಸಂತತಿಯವರು ಮೋಶೆ ಮತ್ತು ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ಬಳಿಗೂ, ಸಮೂಹದ ಪ್ರಧಾನರ ಬಳಿಗೂ ಬಂದು ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“ಅಟಾರೋತ್, ದೀಬೋನ್, ಯಗ್ಜೇರ್, ನಿಮ್ರಾ, ಹೆಷ್ಬೋನ್, ಎಲೆಯಾಲೆ, ಸೆಬಾಮ್, ನೆಬೋ, ಬೆಯೋನ್, ");
INSERT INTO kanirv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ಇವು ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರ ಸಮೂಹಕ್ಕೆ ಅಧೀನಪಡಿಸಿದ ಪಟ್ಟಣಗಳು. ದನಕುರಿಗಳ ಮೇವಿಗೆ ತಕ್ಕ ಪ್ರದೇಶವಾಗಿದೆ. ನಿಮ್ಮ ದಾಸರಾದ ನಮಗೆ ಬಹಳ ದನ ಕುರಿಗಳುಂಟು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ಆದಕಾರಣ ನೀವು, ದಾಸರಾದ ನಮ್ಮ ಮೇಲೆ ದಯೆ ಇಟ್ಟು ನಮ್ಮನ್ನು ಯೊರ್ದನ್ ನದಿಯ ಆಚೆಗೆ ಬರಮಾಡಿದ ಈ ಪ್ರದೇಶವನ್ನೇ ಸ್ವತ್ತಾಗಿ ಕೊಡಬೇಕು” ಎಂದು ಕೇಳಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ಮೋಶೆಯು ಗಾದ್ ಮತ್ತು ರೂಬೇನ್ ಸಂತಾನದವರಿಗೆ, “ನಿಮ್ಮ ಸಹೋದರರು ಯದ್ಧಕ್ಕೆ ಹೋಗುವಾಗ ನೀವು ಅಲ್ಲೇ ಕುಳಿತುಕೊಂಡಿರಬೇಕೇನು? ");
INSERT INTO kanirv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರಿಗೆ ಕೊಟ್ಟ ದೇಶಕ್ಕೆ ಅವರು ಹೋಗದಂತೆ ನೀವು ಏಕೆ ಅವರಿಗೆ ಅಧೈರ್ಯವನ್ನು ಹುಟ್ಟಿಸುತ್ತೀರಿ? ");
INSERT INTO kanirv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ಆ ದೇಶವನ್ನು ನೋಡಿಕೊಂಡು ಬರುವುದಕ್ಕೆ ನಾನು ಕಾದೇಶ್ ಬರ್ನೇಯದಿಂದ ನಿಮ್ಮ ತಂದೆಯರನ್ನು ಕಳುಹಿಸಿದಾಗ ಅವರೂ ಹಾಗೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ಅವರು ಎಷ್ಕೋಲ್ ತಗ್ಗಿಗೆ ಬಂದು ಆ ದೇಶವನ್ನು ನೋಡಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಅಧೈರ್ಯವನ್ನು ಹುಟ್ಟಿಸಿದ್ದರಿಂದ ಇಸ್ರಾಯೇಲರು ತಮಗೆ ಯೆಹೋವನು ವಾಗ್ದಾನಮಾಡಿದ ದೇಶಕ್ಕೆ ಹೋಗಲು ಆಗಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ಆ ಕಾಲದಲ್ಲಿ ಯೆಹೋವನು ಕೋಪಗೊಂಡವನಾಗಿ ಪ್ರಮಾಣಮಾಡಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ಬಂದ ಈ ಜನರೊಳಗೆ ಯಾರೂ ನನ್ನನ್ನು ಪೂರ್ಣಮನಸ್ಸಿನಿಂದ ಅನುಸರಿಸದೆ ಹೋದುದರಿಂದ ನಾನು ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೋಬರಿಗೆ ಪ್ರಮಾಣ ಪೂರ್ವಕವಾಗಿ ಕೊಟ್ಟ ದೇಶವನ್ನು, ಅವರೊಳಗೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಿನ ವಯಸ್ಸಿನವರಲ್ಲಿ ");
INSERT INTO kanirv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ಕೆನಿಜ್ಜೀಯನಾದ ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬನೂ ಮತ್ತು ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನೂ ಇವರಿಬ್ಬರೇ ಹೊರತು ಯಾರೂ ನೋಡುವುದೇ ಇಲ್ಲ’” ಎಂದು ಖಂಡಿತವಾಗಿ ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ಯೆಹೋವನು ಇಸ್ರಾಯೇಲರ ಮೇಲೆ ಕೋಪಗೊಂಡವನಾಗಿ ತನ್ನ ದೃಷ್ಟಿಯಲ್ಲಿ ಕೆಟ್ಟ ನಡತೆಯುಳ್ಳ ಆ ಸಂತತಿಯವರೆಲ್ಲರೂ ನಾಶವಾಗುವ ತನಕ ನಲ್ವತ್ತು ವರ್ಷ, ಇಸ್ರಾಯೇಲರನ್ನು ಮರುಭೂಮಿಯಲ್ಲೇ ತಿರುಗಾಡುವಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“ಈ ದುಷ್ಟ ಸಂತತಿಯವರಾದ ನೀವು ನಿಮ್ಮ ತಂದೆಗಳಿಗೆ ಬದಲಾಗಿ ಬಂದು ಇಸ್ರಾಯೇಲರ ಮೇಲಿದ್ದ ಯೆಹೋವನ ರೋಷಾಗ್ನಿಯನ್ನು ಮತ್ತಷ್ಟು ಹೆಚ್ಚಿಸುತ್ತೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ನೀವು ಆತನನ್ನು ಹಿಂಬಾಲಿಸದೆ ಇರುವ ಕಾರಣ ಆತನು ಆ ಜನರನ್ನು ಮರುಭೂಮಿಯಲ್ಲಿ ಇರಿಸಿದರೆ, ಈ ಸಮಸ್ತ ಜನಾಂಗವನ್ನು ನೀವೇ ನಾಶ ಮಾಡುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ಆಗ ಅವರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು, “ನಾವು ಇಲ್ಲಿ ನಮ್ಮ ದನಕುರಿಗಳಿಗೋಸ್ಕರ ದೊಡ್ಡಿಗಳನ್ನೂ, ನಮ್ಮ ಕುಟುಂಬಗಳಿಗೋಸ್ಕರ ಊರುಗಳನ್ನು ಕಟ್ಟಿಕೊಳ್ಳುವೆವು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ನಾವಾದರೋ ಇಸ್ರಾಯೇಲರನ್ನು ಅವರವರ ಸ್ಥಳಗಳಿಗೆ ಸೇರಿಸುವವರೆಗೂ ಯುದ್ಧಕ್ಕೆ ಸನ್ನದ್ಧರಾಗಿ ಅವರ ಮುಂದೆ ನಡೆಯುವೆವು. ಅಷ್ಟರಲ್ಲಿ ನಮ್ಮ ಕುಟುಂಬಗಳವರು ಈ ದೇಶದ ನಿವಾಸಿಗಳ ಭಯದ ದೆಸೆಯಿಂದ ಕೋಟೆಕೋತ್ತಲುಗಳುಳ್ಳ ಊರುಗಳಲ್ಲಿ ವಾಸಿಸಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ತಮ್ಮ ತಮ್ಮ ಸ್ವತ್ತುಗಳನ್ನು ಸ್ವತಂತ್ರಿಸಿಕೊಳ್ಳುವ ವರೆಗೂ ನಾವು ನಮ್ಮ ಮನೆಗಳಿಗೆ ತಿರುಗಿ ಹೋಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ನಮಗೆ ಯೊರ್ದನ್ ನದಿಯ ಆಚೆ ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿ ಸ್ವತ್ತನ್ನು ಅಪೇಕ್ಷಿಸುವುದಿಲ್ಲ” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ಅದಕ್ಕೆ ಮೋಶೆ ಅವರಿಗೆ, “ನೀವು ಯೆಹೋವನ ಮಾತಿನಂತೆ ನಡೆದರೆ ನಿಮ್ಮಲ್ಲಿರುವ ಭಟರೆಲ್ಲರೂ ಯುದ್ಧಸನ್ನದ್ಧರಾಗಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ಯೊರ್ದನ್ ನದಿಯ ಆಚೆಗೆ ಹೋಗಿ ಯೆಹೋವನು ತನ್ನ ವೈರಿಗಳನ್ನು ಹೊರಡಿಸಿಬಿಟ್ಟು ಆ ದೇಶವನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳುವ ತನಕ ಆತನ ಮುಂದೆ ");
INSERT INTO kanirv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ಯುದ್ಧಮಾಡಿ ತರುವಾಯ ನೀವು ತಿರುಗಿ ಬಂದು ಆತನ ದೃಷ್ಟಿಯಲ್ಲೂ, ಇಸ್ರಾಯೇಲರ ದೃಷ್ಟಿಯಲ್ಲೂ ನಿರ್ದೋಷಿಗಳಾಗಿರುವಿರಿ ಮತ್ತು ಈ ದೇಶವು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲೇ ನಿಮಗೆ ಸ್ವತ್ತಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“ಆದರೆ ನೀವು ಹಾಗೆ ಮಾಡದೆ ಹೋದರೆ, ಯೆಹೋವನಿಗೆ ವಿರುದ್ಧವಾಗಿ ಪಾಪಮಾಡಿದವರಾಗುವಿರಿ ಮತ್ತು ನಿಮ್ಮ ಪಾಪವು ನಿಮ್ಮನ್ನು ಹಿಡಿಯುವ ತನಕ ಹುಡುಕಿಕೊಂಡೇ ಬರುವುದು ಎಂದು ತಿಳಿದುಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ನೀವು ನಿಮ್ಮ ಕುಟುಂಬಗಳಿಗೋಸ್ಕರ ಊರುಗಳನ್ನೂ, ದನಕುರಿಗಳಿಗೋಸ್ಕರ ದೊಡ್ಡಿಗಳನ್ನೂ ಕಟ್ಟಿಕೊಂಡ ತರುವಾಯ ನಿಮ್ಮ ಮಾತಿನ ಪ್ರಕಾರ ಮಾಡಿರಿ” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ಅದಕ್ಕೆ ಗಾದ್ಯರೂ ಮತ್ತು ರೂಬೇನ್ಯರೂ ಮೋಶೆಗೆ, “ಸ್ವಾಮಿಯವರ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ದಾಸರಾದ ನಾವು ಮಾಡುತ್ತೇವೆ ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ನಮ್ಮ ಮಕ್ಕಳು, ಹೆಂಡತಿಯರೂ, ದನಕುರಿಗಳು ನಮ್ಮ ಸಂಪತ್ತು ಇಲ್ಲೇ ಗಿಲ್ಯಾದ್ ದೇಶದ ಊರುಗಳಲ್ಲಿ ಇರಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ನಿನ್ನ ದಾಸರಾದ ನಮ್ಮಲ್ಲಿ ಯುದ್ಧಸನ್ನದ್ಧರೆಲ್ಲರೂ ಸ್ವಾಮಿಯವರ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಯೆಹೋವನ ಮುಂದುಗಡೆಯಲ್ಲಿ ಹೊರಟು ನದಿಯನ್ನು ದಾಟಿ ಯುದ್ಧಮಾಡುವೆವು” ಎಂದು ಉತ್ತರ ಕೊಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ಆದಕಾರಣ ಮೋಶೆ ಅವರ ವಿಷಯವಾಗಿ ಮಹಾಯಾಜಕ ಎಲ್ಲಾಜಾರನಿಗೂ, ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನಿಗೂ ಇಸ್ರಾಯೇಲರ ಮತ್ತು ಗೋತ್ರಗಳ ಕುಲಾಧಿಪತಿಗಳಿಗೂ ಆಜ್ಞೆಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ಮೋಶೆಯು ಅವರಿಗೆ, “ಗಾದ್ಯರಲ್ಲಿಯೂ, ರೂಬೇನ್ಯರಲ್ಲಿಯೂ ಯುದ್ಧಸನ್ನದ್ಧರಾದವರೆಲ್ಲರೂ ನಿಮ್ಮೊಡನೆ ಯೊರ್ದನ್ ನದಿಯನ್ನು ದಾಟಿ ಯೆಹೋವನ ಮುಂದೆ ಯುದ್ಧಮಾಡಿದರೆ ಕಾನಾನ್ ದೇಶವನ್ನು ನೀವು ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡಾಗ ನೀವು ಗಿಲ್ಯಾದ್ ಪ್ರದೇಶವನ್ನು ಅವರಿಗೆ ಸ್ವಾಸ್ತ್ಯವಾಗುವುದಕ್ಕೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ಆದರೆ ಅವರು ನಿಮ್ಮೊಡನೆ ಯುದ್ಧಕ್ಕೆ ಹೋಗದಿದ್ದರೆ ಕಾನಾನ್ ದೇಶದಲ್ಲಿಯೇ ಅವರಿಗೆ ಸ್ವಾಸ್ತ್ಯವಾಗಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ಅದಕ್ಕೆ ಗಾದ್ಯರೂ ರೂಬೇನ್ಯರೂ ಉತ್ತರವಾಗಿ, “ಯೆಹೋವನು ನಿನ್ನ ದಾಸರಾದ ನಮಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮಾಡುವೆವು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ನಾವು ಯೆಹೋವನ ಮುಂದೆ ಯುದ್ಧಸನ್ನದ್ಧರಾಗಿ ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಹೊರಡುವೆವು, ಆಗ ಯೊರ್ದನ್ ನದಿಯ ಆಚೆಯೇ ನಮಗೆ ಸ್ವತ್ತು ದೊರಕಬೇಕು” ಎಂದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ಹೀಗೆ ಮೋಶೆಯು ಗಾದ್ಯರಿಗೂ, ರೂಬೇನ್ಯರಿಗೂ, ಯೋಸೇಫನ ಮಗನಾದ ಮನಸ್ಸೆಯ ಕುಲದವರಲ್ಲಿ ಅರ್ಧಜನರಿಗೂ, ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನ ರಾಜ್ಯವನ್ನೂ, ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನ ರಾಜ್ಯವನ್ನೂ, ಅವುಗಳ ಎಲ್ಲಾ ಊರುಗಳನ್ನೂ ಮತ್ತು ಆ ಊರುಗಳಿಗೆ ಸೇರಿದ ಭೂಮಿಗಳನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ಗಾದ್ಯನ ಮಕ್ಕಳು ದೀಬೋನ್, ಅಟಾರೋತ್, ಅರೋಯೇರ್ ಊರುಗಳನ್ನು ಹೊಸದಾಗಿ ಕಟ್ಟಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ಆಟ್ರೋತ್ಷೋಫಾನ್, ಯಗ್ಜೇರ್, ಯೊಗ್ಬೆಹಾ, ");
INSERT INTO kanirv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ಬೇತ್‌ನಿಮ್ರಾ ಮತ್ತು ಬೇತ್ ಹಾರಾನಿನ ಸುತ್ತ ಗೋಡೆಗಳುಳ್ಳ ಊರುಗಳನ್ನು ಹೊಸದಾಗಿ ಕಟ್ಟಿಕೊಂಡರು. ತಮ್ಮ ದನಕುರಿಗಳಿಗೋಸ್ಕರ ದೊಡ್ಡಿಗಳನ್ನು ಕಟ್ಟಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ರೂಬೇನ್ಯರ ಮಕ್ಕಳು ಹೆಷ್ಬೋನ್, ಎಲೆಯಾಲೆ, ಕಿರ್ಯಾತಯಿಮ್ ಊರುಗಳನ್ನು ಹೊಸದಾಗಿ ಕಟ್ಟಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ಸಿಬ್ಮಾ ಎಂಬ ಊರುಗಳನ್ನೂ, ಬೇರೆ ಹೆಸರಿನಿಂದ ಉಚ್ಚರಿಸತಕ್ಕ ನೆಬೋ, ಬಾಳ್ಮೆಯೋನ್ ಎಂಬವುಗಳನ್ನೂ ಹೊಸದಾಗಿ ಕಟ್ಟಿ ಅವುಗಳಿಗೆ ಬೇರೆ ಹೆಸರುಗಳನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ಮನಸ್ಸೆಯ ಮಗನಾದ ಮಾಕೀರನ ವಂಶದವರು ಗಿಲ್ಯಾದಿಗೆ ಹೋಗಿ ಅದನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡು ಅಲ್ಲಿದ್ದ ಅಮೋರಿಯರನ್ನು ಹೊರಡಿಸಿಬಿಟ್ಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ಮೋಶೆಯು ಮನಸ್ಸೆಯ ಮಗನಾದ ಮಾಕೀರನ ಸಂತತಿಯವರಿಗೆ ಗಿಲ್ಯಾದ್ ಪ್ರದೇಶವನ್ನು ಕೊಡಲಾಗಿ ಅವರು ಅಲ್ಲೇ ವಾಸಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ಮನಸ್ಸೆಯ ವಂಶದವನಾದ ಯಾಯೀರನು ಯುದ್ಧಕ್ಕೆ ಹೊರಟು ಅಮೋರಿಯರ ಗ್ರಾಮಗಳನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡು ಅವುಗಳಿಗೆ ಯಾಯೀರನ ಗ್ರಾಮಗಳೆಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ನೋಬಹನು ಯುದ್ಧಕ್ಕೆ ಹೊರಟು ಕೆನಾತ್ ಎಂಬ ಪಟ್ಟಣವನ್ನೂ ಮತ್ತು ಅದಕ್ಕೆ ಸೇರಿದ ಊರುಗಳನ್ನೂ ಜಯಿಸಿ ಅದಕ್ಕೆ ನೋಬಹ ಎಂದು ತನ್ನ ಹೆಸರನ್ನೇ ಕೊಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಕೈಕೆಳಗೆ ಐಗುಪ್ತ ದೇಶದೊಳಗಿಂದ ಸೈನ್ಯಸೈನ್ಯವಾಗಿ ಹೊರಟ ಇಸ್ರಾಯೇಲರ ಪ್ರಯಾಣಗಳ ವಿವರ: ");
INSERT INTO kanirv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ಮೋಶೆ ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರ ಇಸ್ರಾಯೇಲರ ಪ್ರಯಾಣಗಳ ವಿವರಗಳನ್ನು ಬರೆದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ಪಸ್ಕಹಬ್ಬದ ಮರುದಿನದಲ್ಲಿ ಇಸ್ರಾಯೇಲರು ಐಗುಪ್ತ್ಯರ ಎದುರಿನಲ್ಲೇ ರಮ್ಸೇಸಿನಿಂದ ಹೊರಟರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ಆ ಕಾಲದಲ್ಲಿ ಯೆಹೋವನು ಐಗುಪ್ತ್ಯರ ದೇವತೆಗಳನ್ನು ಶಿಕ್ಷಿಸಿ, ಐಗುಪ್ತ್ಯರ ಚೊಚ್ಚಲಮಕ್ಕಳನ್ನು ಸಂಹರಿಸಿದ್ದರಿಂದ ಅವರು ಆ ಮಕ್ಕಳ ಶವಗಳನ್ನು ಸಮಾಧಿಮಾಡುತ್ತಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ಇಸ್ರಾಯೇಲರು ರಮ್ಸೇಸಿನಿಂದ ಹೊರಟು ಸುಕ್ಕೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ಸುಕ್ಕೋತಿನಿಂದ ಹೊರಟು ಅರಣ್ಯದ ಅಂಚಿನಲ್ಲಿರುವ ಏತಾಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ಏತಾಮಿನಿಂದ ಹೊರಟು ಬಾಳ್ಚೆಫೋನಿಗೆ ಎದುರಾಗಿರುವ ಪೀಹಹೀರೋತಿಗೆ ತಿರುಗಿಕೊಂಡು ಮಿಗ್ದೋಲಿನ ಪೂರ್ವದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ಪೀಹಹೀರೋತಿನಿಂದ ಹೊರಟು ಸಮುದ್ರದ ಮಧ್ಯದಲ್ಲೇ ನಡೆದು ಅರಣ್ಯಕ್ಕೆ ಬಂದರು. ಏತಾಮಿನ ಅರಣ್ಯದಲ್ಲಿ ಮೂರು ದಿನ ಪ್ರಯಾಣಮಾಡಿ ಮಾರಾ ಎಂಬ ಸ್ಥಳದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ಮಾರಾದಿಂದ ಹೊರಟು ಏಲೀಮಿಗೆ ಬಂದರು. ಅಲ್ಲಿ ಹನ್ನೆರಡು ನೀರಿನ ಒರತೆಗಳೂ, ಎಪ್ಪತ್ತು ಖರ್ಜೂರದ ಮರಗಳೂ ಇದ್ದುದರಿಂದ ಅಲ್ಲಿಯೇ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ಏಲೀಮಿನಿಂದ ಹೊರಟು ಕೆಂಪು ಸಮುದ್ರದ ದಡದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ಕೆಂಪು ಸಮುದ್ರದಿಂದ ಹೊರಟು ಸೀನ್ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ಸೀನ್ ಮರುಭೂಮಿಯಿಂದ ಹೊರಟು ದೊಪ್ಕದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ದೊಪ್ಕದಿಂದ ಹೊರಟು ಆಲೂಷಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ಆಲೂಷಿನಿಂದ ಹೊರಟು ರೆಫೀದೀಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ಅಲ್ಲಿ ಜನರಿಗೆ ಕುಡಿಯುವುದಕ್ಕೆ ನೀರು ಸಿಕ್ಕಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ರೆಫೀದೀಮಿನಿಂದ ಹೊರಟು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ಸೀನಾಯಿ ಮರುಭೂಮಿಯಿಂದ ಹೊರಟು ಕಿಬ್ರೋತ್ ಹತಾವದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ಕಿಬ್ರೋತ್ ಹತಾವದಿಂದ ಹೊರಟು ಹಚೇರೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ಹಚೇರೋತಿನಿಂದ ಹೊರಟು ರಿತ್ಮದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ರಿತ್ಮದಿಂದ ಹೊರಟು ರಿಮ್ಮೋನ್ ಪೆರೆಚಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ರಿಮ್ಮೋನ್ ಪೆರೆಚಿನಿಂದ ಹೊರಟು ಲಿಬ್ನದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ಲಿಬ್ನದಿಂದ ಹೊರಟು ರಿಸ್ಸದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ರಿಸ್ಸದಿಂದ ಹೊರಟು ಕೆಹೇಲಾತದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ಕೆಹೇಲಾತದಿಂದ ಹೊರಟು ಶೆಫೆರ್ ಬೆಟ್ಟದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ಶೆಫೆರ್ ಬೆಟ್ಟದಿಂದ ಹೊರಟು ಹರಾದದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ಹರಾದದಿಂದ ಹೊರಟು ಮಖೇಲೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ಮಖೇಲೋತಿನಿಂದ ಹೊರಟು ತಹತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ತಹತಿನಿಂದ ಹೊರಟು ತೆರಹದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ತೆರಹದಿಂದ ಹೊರಟು ಮಿತ್ಕದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ಮಿತ್ಕದಿಂದ ಹೊರಟು ಹಷ್ಮೋನದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ಹಷ್ಮೋನದಿಂದ ಹೊರಟು ಮೋಸೇರೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ಮೋಸೇರೋತಿನಿಂದ ಹೊರಟು ಬೆನೇಯಾಕಾನಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ಬೆನೇಯಾಕಾನಿನಿಂದ ಹೊರಟು ಹೋರ್ಹಗಿದ್ಗಾದಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ಹೋರ್ಹಗಿದ್ಗಾದಿನಿಂದ ಹೊರಟು ಯೊಟ್ಬಾತದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ಯೊಟ್ಬಾತದಿಂದ ಹೊರಟು ಅಬ್ರೋನದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ಅಬ್ರೋನದಿಂದ ಹೊರಟು ಎಚ್ಯೋನ್ ಗೆಬೆರಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ಎಚ್ಯೋನ್ ಗೆಬೆರಿನಿಂದ ಹೊರಟು ಕಾದೇಶೆಂಬ ಚಿನ್ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ಕಾದೇಶಿನಿಂದ ಹೊರಟು ಎದೋಮ್ಯರ ದೇಶದ ಅಂಚಿನಲ್ಲಿರುವ ಹೋರ್ ಬೆಟ್ಟದ ಬಳಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ಮಹಾಯಾಜಕನಾದ ಆರೋನನು ಯೆಹೋವನಿಂದ ಅಪ್ಪಣೆಯನ್ನು ಹೊಂದಿ ಹೋರ್ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ, ಇಸ್ರಾಯೇಲರು ಐಗುಪ್ತ ದೇಶದಿಂದ ಹೊರಟ ನಲ್ವತ್ತನೆಯ ವರ್ಷದ ಐದನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಅಲ್ಲೇ ಪ್ರಾಣಬಿಟ್ಟನು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","ಆರೋನನು ಹೋರ್ ಬೆಟ್ಟದಲ್ಲಿ ಸತ್ತಾಗ ಅವನು ನೂರ ಇಪ್ಪತ್ತಮೂರು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ಇಸ್ರಾಯೇಲರು ಬರುತ್ತಾರೆಂಬ ವರ್ತಮಾನವನ್ನು ಕಾನಾನ್ ದೇಶದ ದಕ್ಷಿಣ ಪ್ರಾಂತ್ಯದಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಕಾನಾನ್ಯನಾದ ಅರಾದ್ ಪಟ್ಟಣದ ಅರಸನು ಕೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ಇಸ್ರಾಯೇಲರು ಹೋರ್ ಬೆಟ್ಟದಿಂದ ಹೊರಟು ಚಲ್ಮೋನದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ಚಲ್ಮೋನದಿಂದ ಹೊರಟು ಪೂನೋನಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ಪೂನೋನಿನಿಂದ ಹೊರಟು ಓಬೋತಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ಓಬೋತಿನಿಂದ ಹೊರಟು ಮೋವಾಬ್ಯರ ಗಡಿಯಲ್ಲಿರುವ ಯೊರ್ದನ್ ನದಿಯ ಆಚೆಯಿರುವ ಇಯ್ಯೀಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ಇಯ್ಯೀಮಿನಿಂದ ಹೊರಟು ದೀಬೋನ್ ಗಾದಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ದೀಬೋನ್ ಗಾದಿನಿಂದ ಹೊರಟು ಅಲ್ಮೋನ್ ದಿಬ್ಲಾತಯಿಮಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ಅಲ್ಮೋನ್ ದಿಬ್ಲಾತಯಿಮಿನಿಂದ ಹೊರಟು ಅಬಾರೀಮ್ ಬೆಟ್ಟಗಳಲ್ಲಿರುವ ನೇಬೋವಿನ ಪೂರ್ವದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ಅಬಾರೀಮ್ ಬೆಟ್ಟಗಳಿಂದ ಹೊರಟು ಯೆರಿಕೋ ಪಟ್ಟಣದ ಹತ್ತಿರ ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿ ಮೋವಾಬ್ಯರ ಮೈದಾನದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ಅವರು ಮೋವಾಬ್ಯರ ಮೈದಾನದಲ್ಲಿ ಬೇತ್ ಯೆಷೀಮೋತಿನಿಂದ ಆಬೇಲ್ ಶಿಟ್ಟೀಮಿನವರೆಗೂ ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿ ಯೆರಿಕೋ ಪಟ್ಟಣದ ಹತ್ತಿರವಿರುವ ಮೋವಾಬ್ಯರ ಮೈದಾನದಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ನೀವು ಯೊರ್ದನ್ ನದಿಯನ್ನು ದಾಟಿ ಕಾನಾನ್ ದೇಶವನ್ನು ಸೇರಿದಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ಆ ದೇಶದ ನಿವಾಸಿಗಳನ್ನೆಲ್ಲಾ ಹೊರಡಿಸಿಬಿಟ್ಟು ಅವರ ವಿಚಿತ್ರವಾದ ಕಲ್ಲುಗಳನ್ನೂ, ಲೋಹವಿಗ್ರಹಗಳನ್ನೂ ನಾಶಮಾಡಿ ಅವರ ಪೂಜಾಸ್ಥಳಗಳನ್ನು ಹಾಳುಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ನಾನು ನಿಮಗೆ ಆ ದೇಶವನ್ನು ಸ್ವದೇಶವಾಗುವುದಕ್ಕೆ ಕೊಟ್ಟದರಿಂದ ನೀವು ಅದನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡು ಅದರಲ್ಲಿ ವಾಸಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ನೀವು ಚೀಟುಹಾಕಿ ಆ ದೇಶವನ್ನು ನಿಮ್ಮನಿಮ್ಮ ಕುಟುಂಬಗಳಿಗೆ ಹಂಚಿಕೊಳ್ಳಬೇಕು. ಹೆಚ್ಚು ಮಂದಿಯುಳ್ಳ ಕುಟುಂಬಕ್ಕೆ ಹೆಚ್ಚಾಗಿಯೂ, ಕಡಿಮೆಯಾದ ಕುಟುಂಬಕ್ಕೆ ಕಡಿಮೆಯಾಗಿಯೂ ಸ್ವತ್ತು ದೊರಕಬೇಕು. ಒಂದೊಂದು ಕುಟುಂಬದ ಚೀಟು ಯಾವ ಯಾವ ಸ್ಥಳವನ್ನು ಸೂಚಿಸುವುದೋ ಆ ಸ್ಥಳದಲ್ಲಿಯೇ ಆ ಕುಟುಂಬದ ಸ್ವಾಸ್ತ್ಯವಿರಬೇಕು. ಒಂದೊಂದು ಕುಲದ ಕುಟುಂಬಗಳು ಒಂದೇ ಪ್ರದೇಶದಲ್ಲಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","ನೀವು ದೇಶದ ನಿವಾಸಿಗಳನ್ನು ಹೊರಡಿಸಿಬಿಡದೆ ಹೋದರೆ ಅವರಲ್ಲಿ ನೀವು ಉಳಿಸಿದವರು ನಿಮಗೆ ಕಣ್ಣುಚುಚ್ಚುವ ಮುಳ್ಳುಗಳಂತೆಯೂ, ಪಕ್ಕೆತಿವಿಯುವ ಶೂಲಗಳಂತೆಯೂ, ಆಗಿ ನೀವು ವಾಸಿಸುವ ದೇಶದಲ್ಲಿ ನಿಮಗೆ ಕಂಟಕರಾಗಿರುವರು. ");
INSERT INTO kanirv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ಅದಲ್ಲದೆ ನಾನು ಅವರಿಗೆ ಏನು ಮಾಡಬೇಕೆಂದು ಯೋಚಿಸಿದೇನೋ ಹಾಗೆ ನಿಮಗೂ ಮಾಡುವೆನು.’” ");
INSERT INTO kanirv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ಸಮಸ್ತ ಕಾನಾನ್ ದೇಶವೇ ನಿಮಗೆ ಸ್ವದೇಶವಾಗಿ ದೊರಕುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ನೀವು ಅಲ್ಲಿ ಸೇರಿದಾಗ ಎದೋಮ್ಯರ ಗಡಿಗಳ ಬಳಿಯಲ್ಲಿರುವ ಚಿನ್ ಅರಣ್ಯವು ನಿಮ್ಮ ದಕ್ಷಿಣದ ಮೇರೆಯಾಗಿರಬೇಕು. ಆ ಮೇರೆಯ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿರುವ ಲವಣಸಮುದ್ರದ ಕೊನೆಯಿಂದ ಪ್ರಾರಂಭಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ದಕ್ಷಿಣಕ್ಕೆ ತಿರುಗಿಕೊಂಡು ಅಕ್ರಬ್ಬೀಮ್ ಎಂಬ ಕಣಿವೆಯ ಮಾರ್ಗವಾಗಿ ಚಿನಿಗೆ ಬರಬೇಕು. ಅದರ ಮೂಲೆ ಕಾದೇಶ್ ಬರ್ನೇಯದ ದಕ್ಷಿಣದ ಕಡೆಯಲ್ಲಿರುವುದು. ಅಲ್ಲಿಂದ ಅದು ಹಚರದ್ದಾರಿಗೆ ಹೊರಟು ಅಚ್ಮೋನಿಗೆ ಹಾದು ಹೋಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ಅಚ್ಮೋನಿನಿಂದ ಐಗುಪ್ತ ದೇಶದ ಹಳ್ಳಕ್ಕೆ ಬಂದು ಸಮುದ್ರದ ದಡದಲ್ಲಿ ಮುಗಿಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","ಪಶ್ಚಿಮ ದಿಕ್ಕಿನಲ್ಲಿ ಮಹಾಸಮುದ್ರದ ದಡವೇ ನಿಮ್ಮ ದೇಶದ ಮೇರೆಯಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","ಉತ್ತರ ದಿಕ್ಕಿನ ಮೇರೆಗಾಗಿ ನೀವು ಮಹಾಸಮುದ್ರದಿಂದ, ");
INSERT INTO kanirv_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ಹೋರ್ ಪರ್ವತದಿಂದ ಹಮಾತಿನವರೆಗೂ ಮತ್ತು ಅಲ್ಲಿಂದ ಚೆದಾದಿನ ಹತ್ತಿರಕ್ಕೆ ಇರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ಆ ಮೇಲೆ ಅದು ಜಿಫ್ರೋನಿಗೆ ಹೋಗಿ ಹಚರೇನಾನಿನ ಬಳಿಯಲ್ಲಿ ಮುಗಿಯಬೇಕು. ಇದು ನಿಮ್ಮ ಉತ್ತರ ದಿಕ್ಕಿನ ಮೇರೆಯಾಗಿರುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","ಪೂರ್ವದಿಕ್ಕಿನ ಮೇರೆಗಾಗಿ ಹಚರೇನಾನಿನಿಂದ ಶೆಫಾಮಿಗೆ ಗುರುತು ಹಾಕಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ಶೆಫಾಮಿನಿಂದ ಅಯಿನಿನ ಪೂರ್ವದಲ್ಲಿರುವ ರಿಬ್ಲಕ್ಕೆ ಬರಬೇಕು. ತರುವಾಯ ಅದು ಗಟ್ಟಾ ಇಳಿದು ಕಿನ್ನೆರೆತ್ ಸಮುದ್ರದ ಪೂರ್ವದಲ್ಲಿರುವ ಬೆಟ್ಟಗಳಿಗೆ ಹೋಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ಅಲ್ಲಿಂದ ಅದು ಯೊರ್ದನ್ ನದಿಗೆ ಇಳಿದು ಅದನ್ನು ಅನುಸರಿಸಿ ಲವಣಸಮುದ್ರದ ಬಳಿಯಲ್ಲಿ ಮುಗಿಯಬೇಕು. ಇವೇ ನಿಮ್ಮ ದೇಶದ ಮೇರೆಗಳು’” ಎಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ಅದಕ್ಕನುಸಾರವಾಗಿ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ, “ನೀವು ಚೀಟುಹಾಕಿ ಹಂಚಿಕೊಳ್ಳಬೇಕೆಂದು ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ದೇಶವು ಇದೇ. ಒಂಭತ್ತುವರೆ ಕುಲದವರಿಗೆ ಇದನ್ನು ಹಂಚಿಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ರೂಬೇನ್ಯರ ಮಕ್ಕಳ ಗೋತ್ರವೂ, ಗಾದ್ಯರ ಮಕ್ಕಳ ಗೋತ್ರವೂ, ಮನಸ್ಸೆ ಕುಲದವರಲ್ಲಿ ಅರ್ಧಗೋತ್ರವೂ ತಮ್ಮ ಪೂರ್ವಿಕರ ಗೋತ್ರಗಳ ಪ್ರಕಾರವಾಗಿ ತಮ್ಮ ಸ್ವತ್ತನ್ನು ಹೊಂದಿದ್ದಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ಎರಡುವರೆ ಗೋತ್ರಗಳು ತಮ್ಮ ಸ್ವತ್ತನ್ನು ಯೊರ್ದನ್ ನದಿಯ ಆಚೆ ಯೆರಿಕೋ ಪಟ್ಟಣದ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಪಡೆದುಕೊಂಡಿದ್ದಾರೆ.” ");
INSERT INTO kanirv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ದೇಶವನ್ನು ನಿಮಗೆ ಹಂಚಬೇಕಾದ ಜನರ ಹೆಸರುಗಳು ಯಾವುವೆಂದರೆ: ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ಮತ್ತು ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನೂ. ");
INSERT INTO kanirv_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ಒಂದೊಂದು ಕುಲದಿಂದ ನೇಮಿಸಲ್ಪಟ್ಟ ಒಬ್ಬ ಕುಲಾಧಿಪತಿಯೂ ಇವರೇ. ಇವರು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ತಮ್ಮ ತಮ್ಮ ಸ್ವತ್ತುಗಳನ್ನು ಹಂಚಿಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ನೀವು ಆಯಾ ಕುಲಗಳಿಂದ ನೇಮಿಸಬೇಕಾದವರು ಯಾರೆಂದರೆ: ಯೆಹೂದ ಕುಲದಿಂದ ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬ್, ");
INSERT INTO kanirv_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ಸಿಮೆಯೋನ್ ಕುಲದಿಂದ ಅಮ್ಮಿಹೂದನ ಮಗ ಶೆಮೂವೇಲ್, ");
INSERT INTO kanirv_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ಬೆನ್ಯಾಮೀನ್ ಕುಲದಿಂದ ಕಿಸ್ಲೋನನ ಮಗ ಎಲೀದಾದ್, ");
INSERT INTO kanirv_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ದಾನ್ ಕುಲದಿಂದ ಯೊಗ್ಲೀಯ ಮಗ ಬುಕ್ಕೀ ಕುಲಾಧಿಪತಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ಯೋಸೇಫನ ವಂಶದವರಲ್ಲಿ: ಮನಸ್ಸೆ ಕುಲದಿಂದ ಏಫೋದನ ಮಗ ಹನ್ನೀಯೇಲ್ ಕುಲಾಧಿಪತಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ಎಫ್ರಾಯೀಮ್ ಕುಲದಿಂದ ಶಿಫ್ಟಾನನ ಮಗ ಕೆಮೂವೇಲ್ ಕುಲಾಧಿಪತಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ಜೆಬುಲೂನ್ ಕುಲದಿಂದ ಪರ್ನಾಕನ ಮಗ ಎಲೀಚಾಫಾನ್ ಕುಲಾಧಿಪತಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ಇಸ್ಸಾಕಾರ್ ಕುಲದಿಂದ ಅಜ್ಜಾನನ ಮಗ ಪಲ್ಟೀಯೇಲ್ ಕುಲಾಧಿಪತಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ಆಶೇರ್ ಕುಲದಿಂದ ಶೆಲೋಮಮೀಯ ಮಗ ಅಹೀಹೂದ್ ಕುಲಾಧಿಪತಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ನಫ್ತಾಲಿ ಕುಲದಿಂದ ಅಮ್ಮಿಹೂದನ ಮಗ ಪೆದಹೇಲ್ ಕುಲಾಧಿಪತಿ ಇವರೇ.” ");
INSERT INTO kanirv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಅವರವರ ಸ್ವತ್ತುಗಳನ್ನು ಹಂಚಿಕೊಡುವುದಕ್ಕೆ ಯೆಹೋವನು ಇವರನ್ನೆಲ್ಲಾ ನೇಮಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿ ಯೆರಿಕೋ ಪಟ್ಟಣದ ಹತ್ತಿರವಿರುವ ಮೋವಾಬ್ಯರ ಮೈದಾನದಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ಇಸ್ರಾಯೇಲರು ತಾವು ಹೊಂದುವ ಸ್ವತ್ತಿನಲ್ಲಿ ಕೆಲವು ಪಟ್ಟಣಗಳನ್ನೂ, ಆ ಪಟ್ಟಣಗಳ ಸುತ್ತಲಿನ ಭೂಮಿಯನ್ನೂ ಲೇವಿಯರಿಗೆ ವಾಸಕ್ಕಾಗಿ ಕೊಡಬೇಕೆಂದು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ಆ ಪಟ್ಟಣಗಳು ಲೇವಿಯರ ವಾಸ ಸ್ಥಳವಾಗುವುದು. ಸುತ್ತಲಿರುವ ಭೂಮಿಗಳು ಅವರ ದನಕುರಿಗಳಿಗಾಗಿಯೂ ಮತ್ತು ಪಶುಗಳಿಗಾಗಿಯೂ ಇರುವವು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ನೀವು ಲೇವಿಯರಿಗೆ ಕೊಡುವ ಪಟ್ಟಣಗಳು ಸುತ್ತಲಿನ ಭೂಮಿಯ ಪ್ರತಿಯೊಂದು ಪಟ್ಟಣಗಳ ಗೋಡೆಯಿಂದ ನಾಲ್ಕು ಕಡೆಯಲ್ಲಿಯೂ ಸಾವಿರ ಮೊಳದಷ್ಟು ವಿಸ್ತರಿಸಿಕೊಂಡಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ನೀವು ಪಟ್ಟಣದ ಹೊರಗಡೆ ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿ ಎರಡು ಸಾವಿರ ಮೊಳ, ದಕ್ಷಿಣದಲ್ಲಿ ಎರಡು ಸಾವಿರ ಮೊಳ, ಪಶ್ಚಿಮದಲ್ಲಿ ಎರಡು ಸಾವಿರ ಮೊಳ, ಉತ್ತರದಲ್ಲಿ ಎರಡು ಸಾವಿರ ಮೊಳ, ಅಳೆಯಬೇಕು. ಮಧ್ಯದಲ್ಲಿ ಪಟ್ಟಣಗಳಿರಬೇಕು. ಹೀಗೆ ಅವರ ಪಟ್ಟಣಗಳ ಉಪನಗರಗಳು ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","ಮನುಷ್ಯನನ್ನು ಹತ್ಯೆಮಾಡಿದವರು ಆಶ್ರಯಕ್ಕಾಗಿ ಓಡಿ ಹೋಗುವುದಕ್ಕೋಸ್ಕರ ನೀವು ನೇಮಿಸುವ ಆರು ಆಶ್ರಯನಗರಗಳನ್ನೂ, ಬೇರೆ ನಲ್ವತ್ತೆರಡು ಪಟ್ಟಣಗಳನ್ನೂ ಅಂತು ನಲ್ವತ್ತೆಂಟು ಪಟ್ಟಣಗಳನ್ನು ಲೇವಿಯರಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ನೀವು ಲೇವಿಯರಿಗೆ ಹುಲ್ಲುಗಾವಲುಗಳ ಸಂಗಡ ಕೊಡಬೇಕಾದ ಸಮಸ್ತ ಪಟ್ಟಣಗಳು ನಲ್ವತ್ತೆಂಟಾಗಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ಇಸ್ರಾಯೇಲರ ಸ್ವತ್ತಿನಲ್ಲಿ ಆಯಾ ಕುಲದ ಸ್ವತ್ತಿನ ಪ್ರಮಾಣಕ್ಕೆ ತಕ್ಕ ಹಾಗೆ ಹೆಚ್ಚಾದ ಜನರುಳ್ಳವರಿಂದ ಹೆಚ್ಚಾಗಿಯೂ, ಕಡಿಮೆಯಾದ ಜನರಿಂದ ಕಡಿಮೆಯಾಗಿಯೂ ಲೇವಿಯರಿಗೋಸ್ಕರ ಊರುಗಳನ್ನು ಕೊಡಿಸಬೇಕು.” ");
INSERT INTO kanirv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು, ‘ನೀವು ಯೊರ್ದನ್ ನದಿಯನ್ನು ದಾಟಿ ಕಾನಾನ್ ದೇಶವನ್ನು ಸೇರಿದ ನಂತರ, ");
INSERT INTO kanirv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ಆಶ್ರಯ ಸ್ಥಾನಗಳಾಗುವುದಕ್ಕೆ ಪಟ್ಟಣಗಳನ್ನು ನೇಮಿಸಬೇಕು. ಕೈತಪ್ಪಿ ಮತ್ತೊಬ್ಬನನ್ನು ಕೊಂದವನು ಅವುಗಳಲ್ಲಿ ಒಂದಕ್ಕೆ ಓಡಿಹೋಗಿ ಸುರಕ್ಷಿತನಾಗಿರಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ಅವನು ಸಭೆಯವರಿಂದ ತೀರ್ಪು ಹೊಂದುವುದಕ್ಕಿಂತ ಮೊದಲೇ ಹತವಾದವನ ಸಮೀಪಬಂಧುವಿನಿಂದ ಸಾಯದಂತೆ ಆ ಆಶ್ರಯ ಪಟ್ಟಣಗಳು ನಿಮ್ಮೊಳಗೆ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ಹೀಗೆ ಆರು ಪಟ್ಟಣಗಳನ್ನು ಆಶ್ರಯದ ಪಟ್ಟಣಗಳಾಗಿ ನೇಮಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ನೀವು ಯೊರ್ದನ್ ನದಿಯ ಆಚೆಯಲ್ಲಿ ಮೂರು ಮತ್ತು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಮೂರು ಪಟ್ಟಣಗಳನ್ನು ನೇಮಿಸಬೇಕು. ಅವು ಆಶ್ರಯದ ಪಟ್ಟಣಗಳಾಗಿ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ಕೈತಪ್ಪಿ ಮತ್ತೊಬ್ಬನನ್ನು ಕೊಂದವನು ಇಸ್ರಾಯೇಲನಾಗಲಿ, ಪರದೇಶದವನಾಗಲಿ ಮತ್ತು ನಿಮ್ಮಲ್ಲಿ ಇಳಿದುಕೊಂಡವನಾಗಲಿ ಆ ಆರು ಪಟ್ಟಣಗಳೊಳಗೆ ಒಂದಕ್ಕೆ ಓಡಿಹೋಗಿ ಆಶ್ರಯಹೊಂದಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“‘ಯಾವನಾದರೂ ಕಬ್ಬಿಣದ ಆಯುಧದಿಂದ ಮತ್ತೊಬ್ಬನನ್ನು ಹೊಡೆದು ಕೊಂದರೆ ಅವನು ನರಹತ್ಯೆ ಮಾಡಿದವನೆಂದು ನೀವು ನಿರ್ಣಯಿಸಬೇಕು. ಅಂಥವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ಯಾವನಾದರೂ ಮನುಷ್ಯನನ್ನು ಕೊಲ್ಲುವಷ್ಟು ದೊಡ್ಡ ಕಲ್ಲನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದು ಮತ್ತೊಬ್ಬನನ್ನು ಹೊಡೆದು ಕೊಂದರೆ ಅವನು ನರಹತ್ಯೆ ಮಾಡಿದವನೇ. ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","ಯಾವನಾದರೂ ಮನುಷ್ಯನನ್ನು ಕೊಲ್ಲುವಷ್ಟು ದೊಡ್ಡ ಮರದ ಆಯುಧವನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದು ಮತ್ತೊಬ್ಬನನ್ನು ಹೊಡೆದು ಕೊಂದರೆ ಅವನು ನರಹತ್ಯೆಮಾಡಿದವನೇ. ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ನರಹತ್ಯೆಮಾಡಿದವನು ಎಲ್ಲಿ ಸಿಕ್ಕಿದರೂ ಅವನನ್ನು ಕೊಲ್ಲಬೇಕಾದವನು ಯಾರೆಂದರೆ ಹತವಾದವನ ಸಮೀಪಬಂಧುವೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ಯಾವನಾದರೂ ಮತ್ತೊಬ್ಬನನ್ನು ಹಗೆಮಾಡಿ ನೂಕುವುದರಿಂದಾಗಲಿ, ಸಮಯ ನೋಡಿಕೊಂಡು ಅವನ ಮೇಲೆ ಏನಾದರೂ ಎಸೆಯುವುದರಿಂದಾಗಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ಇಲ್ಲವೆ ದ್ವೇಷದಿಂದ ಕೈಯಾರೆ ಹೊಡೆಯುವುದರಿಂದಾಗಲಿ ಕೊಂದರೆ ಅವನು ನರಹತ್ಯೆಮಾಡಿದವನೇ. ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ಹತವಾದವನ ಸಮೀಪಬಂಧುವು ಅವನನ್ನು ಎಲ್ಲಿ ಕಂಡರೂ ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“‘ಆದರೆ ಒಬ್ಬನು ಯಾವ ದ್ವೇಷವೂ ಇಲ್ಲದೆ ಆಕಸ್ಮಾತ್ತಾಗಿ ನೂಕುವುದರಿಂದಾಗಲಿ, ಹಾನಿಮಾಡುವ ಸಮಯವನ್ನು ನೋಡಿಕೊಳ್ಳದೆ ಏನಾದರೂ ಎಸೆಯುವುದರಿಂದಾಗಲಿ, ");
INSERT INTO kanirv_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ಕೊಲ್ಲುವಷ್ಟು ದೊಡ್ಡ ಕಲ್ಲನ್ನು ತಿಳಿಯದೆ ಬೀಳಿಸುವುದರಿಂದಾಗಲಿ ಮತ್ತೊಬ್ಬನು ಸತ್ತರೆ ಅವನು ಆ ಮನುಷ್ಯನಿಗೆ ವೈರಿಯಾಗಿರದೆಯೂ ಹಾನಿಯನ್ನು ಮಾಡಬೇಕೆಂಬ ಅಭಿಪ್ರಾಯವಿಲ್ಲದೆಯೂ ಇದ್ದ ಪಕ್ಷಕ್ಕೆ, ");
INSERT INTO kanirv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ಸಭೆಯವರು ಹತ್ಯೆಮಾಡಿದವನಿಗೂ, ಹತವಾದವನ ಸಮೀಪಬಂಧುವಿಗೂ ಈ ಸಂಗತಿಗಳಿಗೆ ಅನುಸಾರವಾಗಿ ನ್ಯಾಯತೀರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ಸಭೆಯು ಹತ್ಯಮಾಡಿದವನನ್ನು ಆ ಸಮೀಪ ಬಂಧುವಿನ ಕೈಯಿಂದ ತಪ್ಪಿಸಿ ಅವನು ಓಡಿಹೋಗಿದ್ದ ಆಶ್ರಯನಗರಕ್ಕೆ ತಿರುಗಿ ಸೇರಿಸಬೇಕು. ಪಟ್ಟಾಭಿಷೇಕ ಹೊಂದಿದ ಮಹಾಯಾಜಕನು ಜೀವದಿಂದಿರುವ ತನಕ ಅವನು ಆ ಪಟ್ಟಣದಲ್ಲೇ ವಾಸಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“‘ಆ ಹತ್ಯೆಮಾಡಿದವನು ಯಾವಾಗಲಾದರೂ ತಾನು ಓಡಿಹೋಗಿದ್ದು ಆಶ್ರಯಪಟ್ಟಣದ ಮೇರೆಯ ಹೊರಗೆ ಹೋಗಿರುವಾಗ, ");
INSERT INTO kanirv_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ಹತವಾದವನ ಸಮೀಪಬಂಧುವು ಅವನನ್ನು ಆಶ್ರಯಪಟ್ಟಣದ ಹೊರಗೆ ಕಂಡು ಕೊಂದುಹಾಕಿದರೆ ಅವನು ಕೊಲೆಪಾತಕನಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ಮಹಾಯಾಜಕನು ಜೀವದಿಂದಿರುವ ತನಕ ಅವನು ಆಶ್ರಯ ಪಟ್ಟಣದೊಳಗೆ ಇರಬೇಕಾಗಿತ್ತು. ಮಹಾಯಾಜಕನು ತೀರಿಹೋದ ನಂತರ ಅವನು ತನ್ನ ಸ್ವಾಸ್ತ್ಯವಿರುವ ಸ್ಥಳಕ್ಕೆ ಹೋಗಬಹುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“‘ನೀವೂ, ನಿಮ್ಮ ಸಂತತಿಯವರೂ ನಿಮ್ಮ ಎಲ್ಲಾ ವಾಸಸ್ಥಳಗಳಲ್ಲಿ ಈ ಮಾತುಗಳಿಗೆ ಅನುಸಾರವಾಗಿ ನ್ಯಾಯತೀರಿಸಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","ಯಾವನಾದರೂ ಮತ್ತೊಬ್ಬನನ್ನು ಕೊಂದಾಗ ನೀವು ಸಾಕ್ಷಿಗಳನ್ನು ವಿಚಾರಿಸಿಕೊಂಡು ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯನ್ನು ವಿಧಿಸಬಾರದು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“‘ಮರಣಶಿಕ್ಷೆಗೆ ಪಾತ್ರನಾದ ಕೊಲೆಪಾತಕನನ್ನು ಉಳಿಸುವುದಕ್ಕೆ ಈಡನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯೇ ಆಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ನೀವು ಆಶ್ರಯಪಟ್ಟಣಕ್ಕೆ ಓಡಿಹೋದವನಿಂದ ಧನವನ್ನು ತೆಗೆದುಕೊಂಡು ಮಹಾಯಾಜಕನು ಜೀವದಿಂದಿರುವಾಗಲೇ ಸ್ವಸ್ಥಳಕ್ಕೆ ಹೋಗಗೊಡಿಸಬಾರದು. ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯೇ ಆಗಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“‘ನೀವು ಹೀಗೆ ನಡೆದುಕೊಂಡರೆ ನಿಮ್ಮ ದೇಶವು ಅಪವಿತ್ರವಾಗುವುದಿಲ್ಲ. ರಕ್ತವು ದೇಶವನ್ನು ಅಪವಿತ್ರ ಮಾಡುವುದು. ಕೊಲ್ಲಲ್ಪಟ್ಟವನ ರಕ್ತಕ್ಕಾಗಿ ಕೊಂದವನ ರಕ್ತದಿಂದಲೇ ಹೊರತು ಬೇರೆ ಪ್ರಾಯಶ್ಚಿತ್ತವಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ನೀವು ವಾಸಿಸುವ ದೇಶವನ್ನು ಅಪವಿತ್ರಮಾಡಬಾರದು. ಯೆಹೋವನೆಂಬ ನಾನೇ ಇಸ್ರಾಯೇಲರ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುತ್ತೇನೆ.’” ");
INSERT INTO kanirv_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ಯೋಸೇಫನ ವಂಶದವರೊಳಗೆ ಮನಸ್ಸೆಯ ಮೊಮ್ಮಗನೂ ಮಾಕೀರನ ಮಗನಾದ ಗಿಲ್ಯಾದನ ಸಂತತಿಯವರ ಮುಖಂಡರು ಮೋಶೆಯ ಮತ್ತು ಇಸ್ರಾಯೇಲರ ಕುಲಾಧಿಪತಿಗಳ ಬಳಿಗೆ ಬಂದು, ");
INSERT INTO kanirv_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“ದೇಶವನ್ನು ಚೀಟುಹಾಕಿ ಇಸ್ರಾಯೇಲರಿಗೆ ಹಂಚಿಕೊಡಬೇಕೆಂದು ಯೆಹೋವನು ಒಡೆಯನಿಗೆ ಆಜ್ಞಾಪಿಸಿ ತರುವಾಯ ನಮ್ಮ ಸ್ವಕುಲದವನಾದ ಚಲ್ಪಹಾದನಿಗೆ ಬರತಕ್ಕ ಸ್ವತ್ತನ್ನು ಅವನ ಹೆಣ್ಣುಮಕ್ಕಳಿಗೆ ಕೊಡಬೇಕು ಎಂದು ಅಪ್ಪಣೆಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ಹೀಗಿರಲು ಅವರು ಇಸ್ರಾಯೇಲರ ಬೇರೆ ಕುಲದವರಿಗೆ ಮದುವೆಯಾದ ಪಕ್ಷಕ್ಕೆ ಅವರ ಸ್ವತ್ತು ನಮ್ಮ ಕುಲದಿಂದ ತೆಗೆಯಲ್ಪಟ್ಟು ಅವರು ಸೇರಿಕೊಳ್ಳುವ ಕುಲಕ್ಕೆ ಹೋಗುವುದು. ಆದುದರಿಂದ ನಮ್ಮ ಸ್ವತ್ತಿಗೆ ನಷ್ಟವುಂಟಾಗುವುದು. ");
INSERT INTO kanirv_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ಇಸ್ರಾಯೇಲರ ಜೂಬಿಲಿ ಸಂವತ್ಸರವು ಬಂದಾಗ ಅವರ ಸ್ವತ್ತು ಅವರು ಸೇರಿಕೊಳ್ಳುವ ಕುಲದ ಸ್ವತ್ತಿಗೆ ಕೂಡಿಕೊಳ್ಳುವುದರಿಂದ ನಮ್ಮ ಕುಲದಿಂದ ತೆಗೆಯಲ್ಪಡುವುದು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ಆಗ ಮೋಶೆಯು ಯೆಹೋವನ ಅಪ್ಪಣೆಯನ್ನು ಹೊಂದಿ ಇಸ್ರಾಯೇಲರಿಗೆ, “ಯೋಸೇಫನ ಕುಲದವರು ಹೇಳುವ ಮಾತು ನ್ಯಾಯವಾಗಿದೆ. ");
INSERT INTO kanirv_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ಆದಕಾರಣ ಯೆಹೋವನು ಚಲ್ಪಹಾದನ ಹೆಣ್ಣುಮಕ್ಕಳ ವಿಷಯವಾಗಿ ಅಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ‘ತಮ್ಮ ಕುಲದ ಕುಟುಂಬಗಳಲ್ಲಿ ಮಾತ್ರವೇ ತಮಗೆ ಇಷ್ಟಬಂದವರನ್ನು ಮದುವೆಮಾಡಿಕೊಳ್ಳಬೇಕು’ ಎಂಬುದೇ. ");
INSERT INTO kanirv_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ಇಸ್ರಾಯೇಲರ ಯಾವ ಸ್ವಾಸ್ತ್ಯವೂ ಒಂದು ಕುಲದಿಂದ ಬೇರೊಂದು ಕುಲಕ್ಕೆ ಹೋಗಬಾರದು. ಇಸ್ರಾಯೇಲರೆಲ್ಲರೂ ತಮ್ಮತಮ್ಮ ಕುಲಗಳ ಸ್ವತ್ತನ್ನು ಹೊಂದಿಕೊಂಡೇ ಇರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ಇದಕ್ಕಾಗಿ ಇಸ್ರಾಯೇಲರ ವಂಶದಲ್ಲಿ ಸ್ವತ್ತನ್ನು ಹೊಂದಿದ ಹೆಣ್ಣುಮಕ್ಕಳು ಸ್ವಕುಲದಲ್ಲಿಯೇ ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ಹೀಗೆ ಯಾವ ಸ್ವಾಸ್ತ್ಯವೂ ಒಂದು ಕುಲದಿಂದ ಬೇರೊಂದು ಕುಲಕ್ಕೆ ಹೋಗದೆ ಇಸ್ರಾಯೇಲರ ಪ್ರತಿಯೊಂದು ಕುಲವು ತನ್ನ ಸ್ವತ್ತನ್ನು ಹೊಂದಿಕೊಂಡೇ ಇರುವುದು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ಚಲ್ಪಹಾದನ ಹೆಣ್ಣುಮಕ್ಕಳು ಯೆಹೋವನ ಆಜ್ಞಾನುಸಾರವೇ ನಡೆದುಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ಚಲ್ಪಹಾದನ ಹೆಣ್ಣುಮಕ್ಕಳಾದ ಮಹ್ಲಾ, ತಿರ್ಚಾ, ಹೊಗ್ಲಾ, ಮಿಲ್ಕಾ, ನೋವಾ ಎಂಬುವವರು ಮನಸ್ಸೆಯ ಕುಲದವರನ್ನು ಮದುವೆಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kanirv_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ಅವರು ಯೋಸೇಫನ ಮಗನಾದ ಮನಸ್ಸೆಯ ಕುಲದವರಿಗೇ ಮದುವೆಯಾದುದರಿಂದ ಅವರ ಸ್ವತ್ತು ತಂದೆಯ ಕುಲದಲ್ಲಿಯೇ ಉಳಿಯಿತು. ");
INSERT INTO kanirv_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ಯೊರ್ದನ್ ನದಿಯ ತೀರದಲ್ಲಿ ಯೆರಿಕೋ ಪಟ್ಟಣದ ಹತ್ತಿರವಿರುವ ಮೋವಾಬ್ಯರ ಮೈದಾನದಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಇಸ್ರಾಯೇಲರಿಗೆ ಕೊಟ್ಟ ಆಜ್ಞಾವಿಧಿಗಳು ಇವೇ.");
INSERT INTO kanirv_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ಯೊರ್ದನ್ ನದಿಯ ಆಚೆ, ಪಾರಾನ್, ತೋಫೆಲ್, ಲಾಬಾನ್, ಹಚೇರೋತ್ ಮತ್ತು ದೀಜಾಹಾಬ್ ಎಂಬ ಸ್ಥಳಗಳ ನಡುವೆ, ಅರಣ್ಯದಲ್ಲಿ ಆರಾಬಾ ಎಂಬ ತಗ್ಗಾದ ಪ್ರದೇಶದಲ್ಲಿ ಸೂಫಿಗೆ ಎದುರಾಗಿ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರೆಲ್ಲರಿಗೆ ಮಾಡಿದ ಉಪದೇಶ ಮತ್ತು ಉಪನ್ಯಾಸಗಳು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ಹೋರೇಬಿನಿಂದ ಸೇಯೀರ್ ಬೆಟ್ಟಗಳ ಮಾರ್ಗವಾಗಿ ಕಾದೇಶ್‌ಬರ್ನೇಯದ ತನಕ ಹನ್ನೊಂದು ದಿನದ ಪ್ರಯಾಣ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ಇಸ್ರಾಯೇಲರು ಐಗುಪ್ತದೇಶವನ್ನು ಬಿಟ್ಟ ನಲ್ವತ್ತನೆಯ ವರ್ಷದ, ಹನ್ನೊಂದನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ತನಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೆಲ್ಲಾ ಮೋಶೆಯು ಇಸ್ರಾಯೇಲರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ಯೆಹೋವನು ಹೆಷ್ಬೋನಿನಲ್ಲಿದ್ದ ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನನ್ನೂ, ಅಷ್ಟಾರೋತ್, ಎದ್ರೈ ಎಂಬ ಪಟ್ಟಣಗಳಲ್ಲಿದ್ದ ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನನ್ನೂ ಜಯಿಸಿದ ತರುವಾಯವೇ ಮೋಶೆಯು ಇದನ್ನೆಲ್ಲಾ ತಿಳಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ಯೊರ್ದನ್ ನದಿಯ ಆಚೆ ಮೋವಾಬ್ಯರ ದೇಶದಲ್ಲಿ ಮೋಶೆಯು ಈ ಮುಂದಣ ಧರ್ಮಶಾಸ್ತ್ರವನ್ನು ವಿವರಿಸುವುದಕ್ಕೆ ಪ್ರಾರಂಭಿಸಿ ಹೀಗೆ ಹೇಳಿದನು: ");
INSERT INTO kanirv_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“ಹೋರೇಬಿನಲ್ಲಿ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಮಗೆ, ‘ನೀವು ಈ ಬೆಟ್ಟದ ಬಳಿಯಲ್ಲಿ ವಾಸಿಸಿದ್ದು ಸಾಕು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ಈಗ ಹಿಂದಿರುಗಿ ಅಮೋರಿಯರು ಇರುವ ಬೆಟ್ಟದ ಸೀಮೆಗೂ ಮತ್ತು ಅದಕ್ಕೆ ಸೇರಿದ ಪ್ರದೇಶದ ಕಡೆಗೆ ಪ್ರಯಾಣಮಾಡಿರಿ. ಅವು ಯಾವುವೆಂದರೆ: ತಗ್ಗಾದ ಪ್ರದೇಶ, ಬೆಟ್ಟದ ಮೇಲಿನ ಪ್ರದೇಶ, ಇಳಕಲಿನ ಪ್ರದೇಶ, ದಕ್ಷಿಣಸೀಮೆ ಮತ್ತು ಸಮುದ್ರತೀರ ಎಂಬ ನಾಡುಗಳನ್ನು ಒಳಗೊಂಡಿರುವ ಕಾನಾನ್ಯರ ದೇಶ, ಲೆಬನೋನ್ ಪರ್ವತ ಮತ್ತು ಯೂಫ್ರೆಟಿಸ್ ಎಂಬ ಮಹಾನದಿಯ ವರೆಗೆ ವಿಸ್ತರಿಸಿಕೊಂಡಿರುವ ಪ್ರದೇಶಗಳಿಗೆ ಹೋಗಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ಆ ದೇಶವನ್ನು ನಿಮಗೇ ಕೊಟ್ಟಿದ್ದೇನೆ. ಯೆಹೋವನೆಂಬ ನಾನು ನಿಮ್ಮ ಪೂರ್ವಿಕರಾದ ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೋಬರಿಗೂ ಮತ್ತು ಅವರ ಸಂತತಿಯವರಿಗೂ ಆ ದೇಶವನ್ನು ಕೊಡುತ್ತೇನೆಂದು ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನ ಮಾಡಿದೆನಲ್ಲಾ. ಅದರಲ್ಲಿ ಪ್ರವೇಶಮಾಡಿ ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳಿರಿ’” ಎಂದು ಅಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ಆ ಕಾಲದಲ್ಲಿ ನಾನು ನಿಮ್ಮ ಸಂಗಡ ಮಾತನಾಡಿ, “ನಿಮ್ಮ ಹೊಣೆಯನ್ನು ನಾನೊಬ್ಬನೇ ಹೊರುವುದು ಅಸಾಧ್ಯ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ಅಧಿಕ ಸಂಖ್ಯೆಯಲ್ಲಿ ಹೆಚ್ಚಿಸಿದ್ದರಿಂದ ನೀವು ಈಗ ಆಕಾಶದ ನಕ್ಷತ್ರಗಳಷ್ಟು ಅಸಂಖ್ಯರಾಗಿದ್ದೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ನೀವು ಈಗ ಇರುವುದಕ್ಕಿಂತಲೂ ಇನ್ನು ಸಾವಿರದಷ್ಟಾಗುವಂತೆ ನಿಮ್ಮ ಪೂರ್ವಿಕರ ದೇವರಾದ ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ಹೆಚ್ಚಿಸಿ, ತಾನು ವಾಗ್ದಾನಮಾಡಿದ ಪ್ರಕಾರವೇ ನಿಮಗೆ ಶುಭಗಳನ್ನು ಅನುಗ್ರಹಿಸಲಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ಆದರೆ ನಿಮ್ಮಿಂದಾಗುವ ತೊಂದರೆಗಳನ್ನೂ, ಹೊಣೆಯನ್ನು ಮತ್ತು ವ್ಯಾಜ್ಯಗಳನ್ನೂ ನಾನೊಬ್ಬನೇ ನಿಭಾಯಿಸುವುದು ಹೇಗೆ? ");
INSERT INTO kanirv_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ಆದುದರಿಂದ ನೀವು ಪ್ರತಿಯೊಂದು ಕುಲದಿಂದ ಬುದ್ಧಿವಿವೇಕಗಳಿಂದ ಪ್ರಸಿದ್ಧರಾದ ಪುರುಷರನ್ನು ಆರಿಸಿಕೊಳ್ಳಿರಿ. ನಾನು ಅವರನ್ನು ನಿಮಗೆ ಅಧಿಪತಿಗಳನ್ನಾಗಿ ನೇಮಿಸುವೆನು” ಎಂದು ಹೇಳಿದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ಅದಕ್ಕೆ ನೀವು, “ನಿನ್ನ ಆಲೋಚನೆಯಂತೆ ನಡೆಯುವುದು ಹಿತವಾದದ್ದೇ” ಎಂದು ಉತ್ತರಕೊಟ್ಟಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ಆಗ ನಾನು ನಿಮ್ಮಲ್ಲಿ ಪ್ರಸಿದ್ಧರಾದ, ಬುದ್ಧಿವಂತರನ್ನು ಆರಿಸಿಕೊಂಡು ಒಂದೊಂದು ಕುಲದಲ್ಲಿ ಸಾವಿರ ಜನರಿಗೆ ಒಬ್ಬರಂತೆ, ನೂರು ಜನರಿಗೆ ಒಬ್ಬರಂತೆ, ಐವತ್ತು ಜನರಿಗೆ ಒಬ್ಬರಂತೆ ಮತ್ತು ಹತ್ತು ಜನರಿಗೆ ಒಬ್ಬರಂತೆ ಅಧಿಕಾರಿಗಳನ್ನಾಗಿಯೂ ಮತ್ತು ಉಪ ಅಧಿಕಾರಿಗಳನ್ನಾಗಿಯೂ ನೇಮಿಸಿದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","ಆ ನ್ಯಾಯಾಧಿಪತಿಗಳಿಗೆ ನಾನು ಆ ಕಾಲದಲ್ಲಿ ಅಪ್ಪಣೆಮಾಡಿ, “ನೀವು ಸ್ವಕುಲದವರ ವ್ಯಾಜ್ಯಗಳನ್ನು ವಿಚಾರಿಸಬೇಕು. ಅವರು ಇಸ್ರಾಯೇಲರೊಡನೆ ವ್ಯಾಜ್ಯವಾಡಿದರೂ, ಅನ್ಯರೊಡನೆ ವ್ಯಾಜ್ಯವಾಡಿದರೂ ನೀವು ನ್ಯಾಯದ ಪ್ರಕಾರವೇ ತೀರ್ಪುಮಾಡಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ನ್ಯಾಯವಿಚಾರಣೆ ಮಾಡುವಾಗ ಮುಖದಾಕ್ಷಿಣ್ಯಮಾಡದೆ, ಪ್ರಮುಖರನ್ನೂ ಹಾಗು ಅಲ್ಪರನ್ನೂ ಸಮಾನವಾಗಿ ಕಾಣಬೇಕು. ನೀವು ದೇವರ ಹೆಸರಿನಲ್ಲಿ ನ್ಯಾಯತೀರಿಸುವವರಾದ ಕಾರಣ ಮನುಷ್ಯರ ಮುಖವನ್ನು ನೋಡಿ ಹೆದರಬೇಡಿರಿ. ನೀವು ತೀರಿಸಲಿಕ್ಕೆ ಆಗದ ವ್ಯಾಜ್ಯಗಳನ್ನು ನನ್ನ ಬಳಿಗೆ ತರಬೇಕು; ನಾನೇ ಅವುಗಳನ್ನು ತೀರಿಸುವೆನು” ಎಂದು ಹೇಳಿದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ಅದಲ್ಲದೆ ನೀವು ಮಾಡಬೇಕಾದ ಎಲ್ಲಾ ಕಾರ್ಯಗಳ ವಿಷಯದಲ್ಲಿಯೂ ನಾನು ಆ ಕಾಲದಲ್ಲಿ ನಿಮಗೆ ಆಜ್ಞೆಕೊಟ್ಟೆನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ನಾವು ಹೋರೇಬಿನಿಂದ ಹೊರಟು ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅಮೋರಿಯರ ಬೆಟ್ಟದ ಸೀಮೆಯ ಮಾರ್ಗವನ್ನು ಹಿಡಿದು ನೀವು ನೋಡಿದ ಆ ಘೋರವಾದ ಮಹಾ ಅರಣ್ಯದಲ್ಲಿ ನಡೆದು ಕಾದೇಶ್‌ಬರ್ನೇಯಕ್ಕೆ ಸೇರಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ಆಗ ನಾನು, “ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಮಗೆ ಕೊಡುವ ಅಮೋರಿಯರ ಬೆಟ್ಟದ ಸೀಮೆಯ ಹತ್ತಿರಕ್ಕೆ ಬಂದಿದ್ದೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಆ ದೇಶವನ್ನು ನಿಮಗೇ ಕೊಟ್ಟಿದ್ದಾನೆ; ನಿಮ್ಮ ಪೂರ್ವಿಕರ ದೇವರಾದ ಯೆಹೋವನು ಹೇಳಿದಂತೆ ಆ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳಿರಿ; ನೀವು ಭಯಪಡದೆ ಧೈರ್ಯವಾಗಿಯೇ ಇರಬೇಕು” ಎಂದು ಹೇಳಿದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ಆಗ ನೀವೆಲ್ಲರೂ ನನ್ನ ಬಳಿಗೆ ಬಂದು, “ನಮಗಿಂತ ಮುಂದಾಗಿ ಜನರನ್ನು ಕಳುಹಿಸುವೆವು. ಅವರು ನಮಗೋಸ್ಕರ ಆ ದೇಶವನ್ನು ಪರೀಕ್ಷಿಸಿ ನೋಡಿ, ನಾವು ಹತ್ತಿ ಹೋಗಬೇಕಾದ ದಾರಿಯ ವಿಷಯದಲ್ಲೂ ಮತ್ತು ಸೇರಬೇಕಾದ ಊರುಗಳ ವಿಷಯದಲ್ಲೂ ನಮಗೆ ವರ್ತಮಾನ ತಿಳಿಸಲಿ” ಎಂದು ಹೇಳಿದಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ಅದು ಒಳ್ಳೆಯ ಆಲೋಚನೆಯೆಂದು ನಾನು ತಿಳಿದುಕೊಂಡು ನಿಮ್ಮಲ್ಲಿ ಕುಲಕ್ಕೆ ಒಬ್ಬೊಬ್ಬನಂತೆ ಹನ್ನೆರಡು ಜನರನ್ನು ಆರಿಸಿಕೊಂಡೆನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ಅವರು ಹೋಗಿ ಆ ಬೆಟ್ಟದ ಸೀಮೆಯನ್ನು ಹತ್ತಿ, ಎಷ್ಕೋಲ್ ಎಂಬ ತಗ್ಗಿನ ಬಳಿಗೆ ಬಂದು ಆ ಪ್ರದೇಶದಲ್ಲಿ ಸಂಚರಿಸಿ ನೋಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ಅವರು ಅಲ್ಲಿನ ಹಣ್ಣುಗಳಲ್ಲಿ ಕೆಲವನ್ನು ತಂದು ತೋರಿಸಿ, “ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಮಗೆ ಕೊಡುವ ಆ ದೇಶವು ಒಳ್ಳೆಯ ದೇಶ” ಎಂದು ನಮಗೆ ತಿಳಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","ಆದರೂ ನೀವು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ನೋಡಲು ಇಷ್ಟಪಡದೆ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಆಜ್ಞೆಯನ್ನು ಉಲ್ಲಂಘಿಸಿದಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ನೀವು ನಿಮ್ಮ ಡೇರೆಗಳಲ್ಲಿ ಗುಣುಗುಟ್ಟುತ್ತಾ, “ಯೆಹೋವನು ನಮ್ಮನ್ನು ಐಗುಪ್ತದೇಶದಿಂದ ಬರಮಾಡಿದ್ದು ಹಗೆತನದಿಂದಲೇ; ಆತನು ನಮ್ಮನ್ನು ಸಂಹರಿಸಬೇಕೆಂದು ಅಮೋರಿಯರ ಕೈಗೆ ಒಪ್ಪಿಸುತ್ತಾನೆ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ನಾವು ಹೋಗಬೇಕಾದ ಆ ಸೀಮೆ ಎಂಥದೆಂದು ಆಲೋಚಿಸಿರಿ; ಅಲ್ಲಿ ಹೋಗಿದ್ದ ನಮ್ಮ ಸಹೋದರರು ನಮಗೆ, ‘ಆ ದೇಶದ ಜನರು ನಮಗಿಂತ ಬಲಿಷ್ಠರಾಗಿಯೂ ಮತ್ತು ಎತ್ತರವಾಗಿಯೂ ಇದ್ದಾರೆ. ಅವರಿರುವ ಪಟ್ಟಣಗಳು ದೊಡ್ಡದಾಗಿಯೂ ಮತ್ತು ಆಕಾಶವನ್ನು ಮುಟ್ಟುವ ಕೋಟೆಕೊತ್ತಲುಗಳಿಂದ ಇವೆ. ಅಲ್ಲಿ ನಾವು ಎತ್ತರವಾದ ಪುರುಷರನ್ನು ಅಂದರೆ ಅನಾಕೀಮ್ ವಂಶಸ್ಥರ ಮಕ್ಕಳನ್ನು ನೋಡಿದ್ದೇವೆ’ ಎಂದು ಹೇಳಿ ನಮ್ಮ ಧೈರ್ಯವನ್ನು ಕೆಡಿಸಿದ್ದಾರೆ” ಅಂದುಕೊಳ್ಳುತ್ತಿದ್ದಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","ಅದಕ್ಕೆ ನಾನು, “ಕಳವಳಪಡಬೇಡಿರಿ, ಅವರಿಗೆ ಭಯಪಡಬೇಡಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ನಿಮ್ಮ ಮುಂದೆ ಮಾರ್ಗದರ್ಶಕನಾಗಿ ಹೋಗುವ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಐಗುಪ್ತ ದೇಶದಲ್ಲಿಯೂ, ನೀವು ನೋಡಿದ ಅರಣ್ಯದಲ್ಲಿಯೂ ಪ್ರತ್ಯಕ್ಷನಾಗಿ ನಿಮಗೋಸ್ಕರ ಯುದ್ಧಮಾಡಿದಂತೆಯೇ ಈಗಲೂ ನಿಮ್ಮವನಾಗಿ ಯುದ್ಧಮಾಡುವನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ನೀವು ಈ ಸ್ಥಳಕ್ಕೆ ಸೇರುವ ತನಕ ನಿಮ್ಮ ಪ್ರಯಾಣದಲ್ಲೆಲ್ಲಾ ಒಬ್ಬ ತಂದೆ ತನ್ನ ಮಗನನ್ನು ಹೇಗೆ ಮುನ್ನಡೆಸುತ್ತಾನೋ ಹಾಗೆಯೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ಹೊತ್ತನಲ್ಲವೇ?” ಎಂದು ನಿಮಗೆ ಹೇಳಿದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ಆದರೂ ನೀವು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನನ್ನು ನಂಬಲೇ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ನೀವು ಹೋಗಬೇಕಾದ ದಾರಿಯನ್ನು ತೋರಿಸುವುದಕ್ಕೂ, ದಂಡು ಇಳಿಯಬೇಕಾದ ಸ್ಥಳಗಳನ್ನು ಗೊತ್ತುಮಾಡುವುದಕ್ಕೂ ರಾತ್ರಿಯಲ್ಲಿ ಬೆಂಕಿಯೋಪಾದಿಯಲ್ಲಿಯೂ ಮತ್ತು ಹಗಲಿನಲ್ಲಿ ಮೇಘದೋಪಾದಿಯಲ್ಲಿಯೂ ನಿಮ್ಮ ಮಾರ್ಗದಲ್ಲಿ ನಿಮ್ಮನ್ನು ಮುನ್ನಡೆಸಿದ ದೇವರನ್ನು ನೀವು ನಂಬಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","ಯೆಹೋವನು ನಿಮ್ಮ ಮಾತುಗಳನ್ನು ಕೇಳಿ ಕೋಪಗೊಂಡನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","ಆತನು, “ನಿಮ್ಮ ಪೂರ್ವಿಕರಿಗೆ ವಾಗ್ದಾನಮಾಡಿದ ಆ ಒಳ್ಳೇ ದೇಶವನ್ನು ಈ ದುಷ್ಟ ಸಂತತಿಯವರಲ್ಲಿ ಯಾರೂ ನೋಡುವುದಿಲ್ಲ” ಎಂದು ಪ್ರಮಾಣಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ಮತ್ತು ಯೆಹೋವನು “ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬನೊಬ್ಬನೇ ಯೆಹೋವನನ್ನು ಮನಃಪೂರ್ವಕವಾಗಿ ಅನುಸರಿಸಿದ್ದರಿಂದ, ಅವನೇ ಅದನ್ನು ನೋಡುವನು. ಅವನು ಸಂಚರಿಸಿದ ಪ್ರದೇಶವನ್ನು ಅವನಿಗೂ ಮತ್ತು ಅವನ ಸಂತತಿಯವರಿಗೂ ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","ಅದು ಮಾತ್ರವಲ್ಲದೆ ಯೆಹೋವನು ನಿಮ್ಮಿಂದ ನನ್ನ ಮೇಲೆಯೂ ಕೋಪಗೊಂಡು, “ನೀನೂ ಆ ದೇಶಕ್ಕೆ ಸೇರುವುದಿಲ್ಲ; ");
INSERT INTO kanirv_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ಆದರೆ ನಿನ್ನ ಮುಂದೆ ನಿಂತಿರುವ ನಿನ್ನ ಸೇವಕನು, ನೂನನ ಮಗನೂ ಆದ ಯೆಹೋಶುವನು ಅಲ್ಲಿಗೆ ಸೇರುವನು. ಅವನೇ ಇಸ್ರಾಯೇಲರಿಗೆ ಆ ದೇಶವನ್ನು ಸ್ವಾಧೀನಪಡಿಸುವನು. ಆದುದರಿಂದ ಅವನನ್ನು ಧೈರ್ಯಗೊಳಿಸು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ಆದರೆ ಪರರ ಪಾಲಾಗುವರೆಂದು ನೀವು ಹೇಳಿದ ನಿಮ್ಮ ಮನೆಯವರೂ ಹಾಗು ಒಳ್ಳೆಯದನ್ನು ಮತ್ತು ಕೆಟ್ಟದ್ದನ್ನು ಅರಿಯದ ನಿಮ್ಮ ಮಕ್ಕಳೂ ಅಲ್ಲಿಗೆ ಸೇರುವರು. ಅವರಿಗೇ ಆ ದೇಶವನ್ನು ಕೊಡುವೆನು; ಅವರು ಅದನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳುವರು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ನೀವಾದರೋ ಹಿಂದಿರುಗಿ ಕೆಂಪು ಸಮುದ್ರದ ಮಾರ್ಗವನ್ನು ಹಿಡಿದು ಅರಣ್ಯಕ್ಕೆ ಹೊರಟುಹೋಗಿರಿ” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ಅದಕ್ಕೆ ನೀವು, “ನಾವು ಯೆಹೋವನಿಗೆ ದ್ರೋಹಿಗಳಾದೆವು. ಆದರೂ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ನಾವೇ ಈಗ ಆ ಬೆಟ್ಟದ ಸೀಮೆಯನ್ನು ಹತ್ತಿ ಯುದ್ಧಮಾಡುವೆವು” ಎಂದು ಉತ್ತರಕೊಟ್ಟಿರಿ. ಮತ್ತು ನೀವೆಲ್ಲರೂ ನಿಮ್ಮ ನಿಮ್ಮ ಆಯುಧಗಳನ್ನು ತೆಗೆದುಕೊಂಡು, ಆ ಬೆಟ್ಟದ ಸೀಮೆಯನ್ನು ಹತ್ತಿ ಜಯಿಸುವುದು ಅಲ್ಪಕಾರ್ಯವೆಂದು ಭಾವಿಸಿ ಹೊರಡುವುದಕ್ಕಿದ್ದಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ಆದರೆ ಯೆಹೋವನು ನನಗೆ, “ನಾನು ಇವರ ಮಧ್ಯದಲ್ಲಿ ಇರುವುದಿಲ್ಲವಾದುದರಿಂದ ಇವರು ಸೋತುಹೋಗುವರು. ಇವರು ಯುದ್ಧಮಾಡಲೂ ಬಾರದು, ಆ ಬೆಟ್ಟದ ಸೀಮೆಗೆ ಹೋಗಲೂ ಬಾರದು ಎಂದು ಇವರಿಗೆ ಆಜ್ಞಾಪಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ನಾನು ಆ ಮಾತನ್ನು ನಿಮಗೆ ತಿಳಿಸಿದರೂ, ನೀವು ಕಿವಿಗೊಡದೆ ಯೆಹೋವನ ಆಜ್ಞೆಯನ್ನು ತಾತ್ಸಾರಮಾಡಿ ಸೊಕ್ಕಿನಿಂದ ಆ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿದಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ಆಗ ಬೆಟ್ಟದಲ್ಲಿದ್ದ ಅಮೋರಿಯರು ನಿಮಗೆ ವಿರುದ್ಧವಾಗಿ ಹೊರಟು ಜೇನುಹುಳಗಳಂತೆ ನಿಮ್ಮನ್ನು ಮುತ್ತಿ ಸೇಯೀರಿನಲ್ಲಿ ಹೊರ್ಮದ ವರೆಗೂ ಬೆನ್ನಟ್ಟಿ ಸಂಹರಿಸಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ನೀವು ಹಿಂದಿರುಗಿ ಬಂದು ಯೆಹೋವನ ಮುಂದೆ ಗೋಳಾಡಿದಾಗ ಆತನು ನಿಮ್ಮ ಮೊರೆಯನ್ನು ಕೇಳಲೂ ಇಲ್ಲ ಮತ್ತು ರಕ್ಷಿಸಲೂ ಇಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ಆ ಮೇಲೆ ನೀವು ಕಾದೇಶಿನಲ್ಲಿ ಬಹುಕಾಲ ವಾಸವಾಗಿದ್ದಿರಿ ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ಆಗ ಯೆಹೋವನು ನನಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ನಾವು ಹಿಂದಿರುಗಿ ಅರಣ್ಯಕ್ಕೆ ಹೊರಟು ಕೆಂಪು ಸಮುದ್ರದ ಮಾರ್ಗದಲ್ಲಿ ನಡೆದು ಅನೇಕ ದಿನಗಳು ಸೇಯೀರ್ ಬೆಟ್ಟದ ಸೀಮೆಯನ್ನು ಸುತ್ತುತ್ತಿದ್ದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ಆ ಮೇಲೆ ಯೆಹೋವನು ನನಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“ನೀವು ಈ ಬೆಟ್ಟದ ಸೀಮೆಯನ್ನು ಸುತ್ತಿದ್ದು ಸಾಕು; ಉತ್ತರದಿಕ್ಕಿಗೆ ತಿರುಗಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ಮತ್ತು ನೀನು ಇಸ್ರಾಯೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು, ‘ಸೇಯೀರ್ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿರುವ ನಿಮ್ಮ ಬಂಧುಗಳಾದ ಏಸಾವನ ವಂಶದವರ ದೇಶವನ್ನು ದಾಟುವುದಕ್ಕಿದ್ದೀರಷ್ಟೆ. ಅವರು ನಿಮಗೆ ಭಯಪಡುವರು; ನೀವು ಅವರ ಸಂಗಡ ಯುದ್ಧಕ್ಕೆ ಹೋಗದೆ ಬಹಳ ಜಾಗರೂಕತೆಯಿಂದಿರಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ನಾನು ಸೇಯೀರ್ ಬೆಟ್ಟದ ಸೀಮೆಯನ್ನು ಏಸಾವ್ಯರಿಗೇ ಸ್ವದೇಶವಾಗಿ ಕೊಟ್ಟಿರುವುದರಿಂದ ಅದರಲ್ಲಿ ನಿಮಗೆ ಹೆಜ್ಜೆಯಿಡುವಷ್ಟು ನೆಲವನ್ನಾದರೂ ಕೊಡುವುದಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ನೀವು ಅಲ್ಲಿ ಹಣವನ್ನು ಕೊಟ್ಟು ಆಹಾರಪದಾರ್ಥಗಳನ್ನು ತಿನ್ನಬೇಕು; ನೀರನ್ನು ಕೊಂಡುಕೊಂಡು ಕುಡಿಯಬೇಕು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ನೀವು ಕೈಹಾಕಿದ ಎಲ್ಲಾ ಕೆಲಸಗಳನ್ನೂ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಸಫಲಪಡಿಸಿದ್ದಾನಲ್ಲಾ. ಈ ದೊಡ್ಡ ಅರಣ್ಯದಲ್ಲಿ ನೀವು ಸಂಚರಿಸುತ್ತಿರುವಾಗೆಲ್ಲಾ ಆತನು ನಿಮ್ಮನ್ನು ಪರಾಂಬರಿಸುತ್ತಾ ಬಂದನು. ಈ ನಲ್ವತ್ತು ವರ್ಷ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಿಮ್ಮ ಸಂಗಡ ಇದ್ದುದರಿಂದ ನಿಮಗೆ ಏನೂ ಕೊರತೆಯಾಗಲಿಲ್ಲ’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","ಆದಕಾರಣ ನಾವು ಸೇಯೀರಿನಲ್ಲಿರುವ ನಮ್ಮ ಬಂಧುಗಳಾದ ಏಸಾವ್ಯರಿಗೆ ಗೊತ್ತಾಗದಂತೆ ಎಚ್ಚರಿಕೆಯಿಂದ ಅರಾಬದ ಮಾರ್ಗವನ್ನು ಬಿಟ್ಟು ಏಲತ್ ಮತ್ತು ಎಚ್ಯೋನ್ ಗೆಬೆರ್ ಎಂಬ ಪಟ್ಟಣಗಳಿಂದ ಪ್ರಯಾಣಮಾಡಿ ಮೋವಾಬ್ಯರ ಅಡವಿಯ ದಾರಿಯಲ್ಲಿ ನಡೆದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ಆಗ ಯೆಹೋವನು ನನಗೆ, “ನೀವು ಮೋವಾಬ್ಯರಿಗೆ ವೈರಿಗಳಾಗಿ ನಡೆದು ಅವರೊಡನೆ ಯುದ್ಧಮಾಡಬಾರದು. ಲೋಟನ ವಂಶದವರಾದ ಅವರಿಗೆ ನಾನು ಆರ್ ಎಂಬ ಪ್ರದೇಶವನ್ನು ಸ್ವದೇಶವಾಗುವುದಕ್ಕೆ ಕೊಟ್ಟಿರುವುದರಿಂದ ಅದರಲ್ಲಿ ನಿಮಗೆ ಸ್ವತ್ತನ್ನು ಕೊಡುವುದಿಲ್ಲ” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","ಏಮಿಯರು ಮೊದಲು ಆ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದರು. ಅವರು ಬಲಿಷ್ಠರೂ, ಬಹುಜನರೂ ಮತ್ತು ಅನಾಕೀಮ್ಯರಂತೆ ಎತ್ತರವಾದ ಪುರುಷರಾಗಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ಅವರು ಅನಾಕ್ಯರಂತೆ ರೆಫಾಯರಿಗೆ ಸೇರಿದವರೆಂದು ಹೇಳುವುದುಂಟು; ಆದರೆ ಮೋವಾಬ್ಯರು ಅವರನ್ನು ಏಮಿಯರೆಂದು ಹೇಳುತ್ತಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ಹೋರಿಯರು ಸಹ ಪೂರ್ವಕಾಲದಲ್ಲಿ ಸೇಯೀರಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದರು. ತರುವಾಯ ಇಸ್ರಾಯೇಲರು ತಮಗೆ ಯೆಹೋವನು ಕೊಟ್ಟ ದೇಶವನ್ನು ಹೇಗೆ ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡರೋ ಹಾಗೆಯೇ ಏಸಾವ್ಯರು ಬಂದು ಹೋರಿಯರನ್ನು ಸಂಹರಿಸಿ ಅವರ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","ಆಗ ನಾನು, “ಎದ್ದು ಜೆರೆದ್ ಹಳ್ಳವನ್ನು ದಾಟಿರಿ” ಎಂದು ಹೇಳಲು ನಾವು ಜೆರೆದ್ ಹಳ್ಳವನ್ನು ದಾಟಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ನಾವು ಕಾದೇಶ್‌ಬರ್ನೇಯದಿಂದ ಹೊರಟು ಜೆರೆದ್ ಹಳ್ಳವನ್ನು ದಾಟಲು ಮೂವತ್ತೆಂಟು ವರ್ಷವಾಯಿತು. ಯೆಹೋವನು ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ಹೇಳಿದ್ದಂತೆ ಅಷ್ಟರಲ್ಲಿ ಆ ತಲೆಮಾರಿನ ಸೈನಿಕರೆಲ್ಲರೂ ಸತ್ತುಹೋಗಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ಯೆಹೋವನ ಹಸ್ತವು ಅವರಿಗೆ ವಿರುದ್ಧವಾಗಿದ್ದುದರಿಂದ ಪಾಳೆಯದಲ್ಲಿ ಒಬ್ಬನೂ ಉಳಿಯದಂತೆ ನಾಶವಾದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ಆ ಕಾಲದಲ್ಲಿ ಯುದ್ಧನಿಪುಣರಾಗಿದ್ದ ಸೈನಿಕರೆಲ್ಲರೂ ಸತ್ತುಹೋದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ಆಗ ಯೆಹೋವನು ನನ್ನೊಂದಿಗೆ ಮಾತನಾಡಿ ನನಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“ನೀವು ಈಗ ಮೋವಾಬ್ಯರ ಪ್ರಾಂತ್ಯವಾಗಿರುವ ಆರ್ ಎಂಬ ಪ್ರದೇಶವನ್ನು ದಾಟುವವರಾಗಿದ್ದೀರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ಮುಂದೆ ನೀವು ಅಮೋನಿಯರ ಹತ್ತಿರಕ್ಕೆ ಬರುವಾಗ ಅವರಿಗೆ ತೊಂದರೆಪಡಿಸಲೂ ಬೇಡಿರಿ, ಅವರಿಗೆ ವೈರಿಗಳಾಗಿ ನಡೆದು ಯುದ್ಧಮಾಡಲೂಬೇಡಿರಿ. ನಾನು ಆ ದೇಶವನ್ನು ಲೋಟನ ವಂಶದವರಾದ ಅಮ್ಮೋನಿಯರಿಗೆ ಸ್ವತ್ತಾಗಿ ಕೊಟ್ಟಿರುವುದರಿಂದ ನಿಮಗೆ ಅದರಲ್ಲಿ ಯಾವ ಭಾಗವನ್ನಾದರೂ ಕೊಡುವುದಿಲ್ಲ.” ");
INSERT INTO kanirv_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","ಪೂರ್ವಕಾಲದಲ್ಲಿ ರೆಫಾಯರು ಆ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದುದರಿಂದ ಅದು ರೆಫಾಯರ ದೇಶವೆನಿಸಿಕೊಳ್ಳುತ್ತದೆ. ಅಮ್ಮೋನಿಯರು ಅವರನ್ನು ಜಂಜುಮ್ಯರೆಂದು ಹೇಳುತ್ತಾರೆ. ");
INSERT INTO kanirv_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ಅವರು ಬಲಿಷ್ಠರೂ, ಬಹುಜನರೂ ಮತ್ತು ಅನಾಕ್ಯರಂತೆ ಎತ್ತರವಾದ ಪುರುಷರೂ ಆಗಿದ್ದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ಆದರೆ ಹೇಗೆ ಯೆಹೋವನು ಸೇಯೀರಿನಲ್ಲಿರುವ ಏಸಾವ್ಯರಿಗೋಸ್ಕರ ಹೋರಿಯರನ್ನು ಹೊರಡಿಸಿದಾಗ ಏಸಾವ್ಯರು ಆ ದೇಶವನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡು ಇಂದಿನವರೆಗೂ ಅಲ್ಲೇ ವಾಸವಾಗಿದ್ದಾರೋ, ");
INSERT INTO kanirv_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ಮತ್ತು ಹೇಗೆ ಕಫ್ತೋರಿಂದ ಬಂದ ಕಫ್ತೋರ್ಯರು ಗಾಜಾ ಪಟ್ಟಣದವರೆಗೂ ಹಳ್ಳಿಗಳಲ್ಲಿದ್ದ ಅವ್ವಿಯರನ್ನು ನಾಶಮಾಡಿ ಅವರ ಸ್ಥಳದಲ್ಲಿ ವಾಸಮಾಡಿದರೋ, ಹಾಗೆಯೇ ಯೆಹೋವನು ರೆಫಾಯರನ್ನು ಅಮ್ಮೋನಿಯರ ನಾಡಿನಿಂದ ಹೊರಗೆ ಹೋಗುವಂತೆ ಮಾಡಿದನು. ಅಮ್ಮೋನಿಯರು ಆ ದೇಶವನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡು ಅವರಲ್ಲಿ ವಾಸಮಾಡ ತೊಡಗಿದರು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“ಈಗ ನೀವು ಹೊರಟು ಅರ್ನೋನ್ ಹಳ್ಳವನ್ನು ದಾಟಿರಿ. ಅಮೋರಿಯನಾಗಿರುವ ಹೆಷ್ಬೋನಿನ ಅರಸನಾದ ಸೀಹೋನನು ನಿಮ್ಮಿಂದ ಸೋತುಹೋಗುವನು, ಅವನ ರಾಜ್ಯವು ನಿಮಗೇ ವಶವಾಗಬೇಕೆಂದು ನಾನು ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ. ಅವನೊಡನೆ ಯುದ್ಧಮಾಡಿ, ಆ ದೇಶವನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳುವುದಕ್ಕೆ ಪ್ರಾರಂಭಿಸಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ಲೋಕದಲ್ಲಿರುವ ಎಲ್ಲಾ ಜನಗಳಿಗೂ ನಿಮ್ಮಿಂದ ದಿಗಿಲೂ ಮತ್ತು ಹೆದರಿಕೆಯೂ ಉಂಟಾಗುವಂತೆ ಮಾಡುತ್ತೇನೆ. ಇಂದಿನಿಂದ ನಿಮ್ಮ ಸುದ್ದಿಯನ್ನು ಕೇಳಿದ ಮಾತ್ರಕ್ಕೆ ಎಲ್ಲರೂ ಗಡಗಡನೆ ನಡುಗಿ ಸಂಕಟಪಡುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","ಆಗ ನಾನು ಕೆದೇಮೋತಿನ ಅರಣ್ಯದಿಂದ ಹೆಷ್ಬೋನಿನ ಅರಸನಾದ ಸೀಹೋನನ ಬಳಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ ಅವನಿಗೆ, ");
INSERT INTO kanirv_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“ನಿನ್ನ ದೇಶವನ್ನು ದಾಟಿಹೋಗುವುದಕ್ಕೆ ನಮಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕು. ನಾವು ಎಡಬಲಕ್ಕೆ ತಿರುಗದೆ ದಾರಿಹಿಡಿದು ನಡೆದುಹೋಗುವೆವು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ನಮ್ಮಿಂದ ಕ್ರಯ ತೆಗೆದುಕೊಂಡು ಆಹಾರಪದಾರ್ಥಗಳನ್ನೂ ಮತ್ತು ಕುಡಿಯಲಿಕ್ಕೆ ನೀರನ್ನೂ ಕೊಡಿರಿ. ");
INSERT INTO kanirv_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ನಾವು ಯೊರ್ದನ್ ನದಿಯನ್ನು ದಾಟಿ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಮಗೆ ಕೊಡುವ ದೇಶವನ್ನು ಸೇರಬೇಕೆಂದಿದ್ದೇವೆ. ಸೇಯೀರಿನಲ್ಲಿರುವ ಏಸಾವ್ಯರೂ ಮತ್ತು ಆರ್ ಪ್ರದೇಶದಲ್ಲಿರುವ ಮೋವಾಬ್ಯರೂ ನಮಗೆ ದಾರಿ ಕೊಟ್ಟಂತೆ ನೀನೂ ಕೊಡಬೇಕು. ಕಾಲ್ನಡೆಯಾಗಿ ನಿನ್ನ ದೇಶವನ್ನು ದಾಟಿಹೋಗುವುದಕ್ಕೆ ನಿನ್ನ ಅಪ್ಪಣೆಯಾಗಬೇಕೇ ಹೊರತು ಬೇರೆ ಏನೂ ಬೇಕಿಲ್ಲ” ಎಂದು ಸಮಾಧಾನಕರವಾದ ಮಾತುಗಳಿಂದ ಹೇಳಿ ಕಳುಹಿಸಿದೆನು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ಆದರೆ ಯೆಹೋವನು ಅವನಿಗೆ ಮೂರ್ಖಬುದ್ಧಿಯನ್ನು ಕೊಟ್ಟು ಹಟವನ್ನು ಹುಟ್ಟಿಸಿದ್ದರಿಂದ ಅವನು ಸಮ್ಮತಿಸಲಿಲ್ಲ. ಅವನು ನಿಮ್ಮಿಂದ ಸೋತುಹೋಗಬೇಕೆಂಬುದೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಸಂಕಲ್ಪವಾಗಿತ್ತು; ಅದು ಈಗಾಗಲೇ ನೆರವೇರಿತಲ್ಲಾ. ");
INSERT INTO kanirv_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ತರುವಾಯ ಯೆಹೋವನು ನನಗೆ, “ಈಗ ನಾನು ಸೀಹೋನನನ್ನೂ ಮತ್ತು ಅವನ ದೇಶವನ್ನೂ ನಿಮಗೆ ವಶಪಡಿಸುವುದಕ್ಕೆ ಪ್ರಾರಂಭಿಸಿದ್ದೇನೆ; ಅದನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಳ್ಳುವುದಕ್ಕೆ ಪ್ರಾರಂಭಮಾಡಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","ಸೀಹೋನನು ತನ್ನ ಜನರೆಲ್ಲರ ಸಮೇತ ನಮ್ಮೊಡನೆ ಯುದ್ಧಮಾಡುವುದಕ್ಕೆ ಯಹಜಿಗೆ ಹೊರಟುಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಅವನನ್ನು ನಮ್ಮಿಂದ ಪರಾಜಯಪಡಿಸಿದನು. ನಾವು ಅವನನ್ನೂ, ಅವನ ಮಕ್ಕಳನ್ನೂ ಮತ್ತು ಜನರೆಲ್ಲರನ್ನೂ ಸಂಹರಿಸಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ಆ ಕಾಲದಲ್ಲಿ ನಾವು ಅವನ ಎಲ್ಲಾ ಪಟ್ಟಣಗಳನ್ನು ಸ್ವಾಧೀನಮಾಡಿಕೊಂಡು ಅವುಗಳಲ್ಲಿದ್ದ ಗಂಡಸರನ್ನೂ, ಹೆಂಗಸರನ್ನು ಮತ್ತು ಮಕ್ಕಳನ್ನೂ ನಿಶ್ಶೇಷವಾಗಿ ಹತಮಾಡಿದೆವು; ಒಬ್ಬನನ್ನೂ ಉಳಿಸಲಿಲ್ಲ. ");
INSERT INTO kanirv_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ಪಶುಗಳನ್ನು ಮಾತ್ರ ಉಳಿಸಿ ನಮ್ಮ ಸ್ವಂತಕ್ಕಾಗಿ ತೆಗೆದುಕೊಂಡು ಊರುಗಳನ್ನು ಸೂರೆಮಾಡಿಬಿಟ್ಟೆವು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ಅರ್ನೋನ್ ತಗ್ಗಿನ ಅಂಚಿನಲ್ಲಿರುವ ಅರೋಯೇರ್ ಪಟ್ಟಣವು ಮತ್ತು ತಗ್ಗಿನಲ್ಲಿಯೇ ಇರುವ ಪಟ್ಟಣವು ಇವುಗಳು ಮೊದಲುಗೊಂಡು ಗಿಲ್ಯಾದ್ ಸೀಮೆಯವರೆಗೂ ಯಾವ ಪಟ್ಟಣವನ್ನು ಜಯಿಸಲು ನಮಗೆ ಅಸಾಧ್ಯವಾಗಲಿಲ್ಲ. ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಅವುಗಳನ್ನೆಲ್ಲಾ ನಮ್ಮ ಕೈಗೆ ಸಿಕ್ಕುವಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ಅಮ್ಮೋನಿಯರ ದೇಶವನ್ನು ಮಾತ್ರ ಅಂದರೆ ಯಬ್ಬೋಕ್ ಹೊಳೆಯ ಬಳಿಯಲ್ಲಿರುವ ಪ್ರದೇಶವು ಮತ್ತು ಬೆಟ್ಟದ ಸೀಮೆಯ ಊರುಗಳು ಇವೇ ಮೊದಲಾದ ಸ್ಥಳಗಳನ್ನು ನೀವು ಅತಿಕ್ರಮಿಸಲಿಲ್ಲ; ಅಲ್ಲಿಗೆ ಹೋಗಲೇ ಬಾರದೆಂದು ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ತರುವಾಯ ನಾವು ಹಿಂದಿರುಗಿ ಬಾಷಾನಿನ ಮಾರ್ಗವನ್ನು ಹಿಡಿದು ಮೇಲಕ್ಕೆ ಹೋದಾಗ ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನು ತನ್ನ ಜನರೆಲ್ಲರ ಸಮೇತ ನಮಗೆ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧಮಾಡುವುದಕ್ಕೆ ಎದ್ರೈ ಊರಿಗೆ ಹೊರಟುಬಂದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ಆಗ ಯೆಹೋವನು ನನಗೆ, “ಅವನಿಗೆ ಭಯಪಡಬೇಡ; ನಾನು ಅವನನ್ನೂ, ಅವನ ಸಮಸ್ತ ಜನರನ್ನೂ ಮತ್ತು ದೇಶವನ್ನೂ ನಿನ್ನ ಕೈವಶಮಾಡಿದ್ದೇನೆ. ನೀನು ಹೆಷ್ಬೋನಿನಲ್ಲಿದ್ದ ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನಿಗೆ ಮಾಡಿದ ಪ್ರಕಾರವೇ ಇವನಿಗೂ ಮಾಡಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kanirv_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನೂ ಅವನ ಜನರೆಲ್ಲರೂ ನಮ್ಮಿಂದ ಸೋತುಹೋಗುವಂತೆ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ಮಾಡಲಾಗಿ ಅವರಲ್ಲಿ ಒಬ್ಬರಾದರೂ ಉಳಿಯದಂತೆ ಅವರನ್ನು ಹತಮಾಡಿದೆವು. ");
INSERT INTO kanirv_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ಆ ಕಾಲದಲ್ಲಿ ನಾವು ಅವನ ಎಲ್ಲಾ ಪಟ್ಟಣಗಳನ್ನು ಜಯಿಸಿದೆವು; ನಾವು ಜಯಿಸದೇ ಇದ್ದ ಪಟ್ಟಣವು ಒಂದೂ