﻿USE sofia;
DROP TABLE IF EXISTS sofia.kan2010_vpl;
CREATE TABLE kan2010_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kan2010_vpl WRITE;
INSERT INTO kan2010_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ಆದಿಯಲ್ಲಿ ದೇವರು ಆಕಾಶವನ್ನೂ ಭೂಮಿಯನ್ನೂ ಸೃಷ್ಟಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ಭೂಮಿಯು ಅಸ್ತವ್ಯಸ್ತವಾಗಿಯೂ ಬರಿದಾಗಿಯೂ ಇತ್ತು. ಭೂಮಿಯ ಮೇಲೆ ಏನೂ ಇರಲಿಲ್ಲ. ಸಾಗರದ ಮೇಲೆ ಕತ್ತಲು ಕವಿದಿತ್ತು. ದೇವರಾತ್ಮನು ಜಲಸಮೂಹಗಳ ಮೇಲೆ ಚಲಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ಆಗ ದೇವರು, “ಬೆಳಕಾಗಲಿ” ಅನ್ನಲು ಬೆಳಕಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ದೇವರಿಗೆ ಬೆಳಕು ಒಳ್ಳೆಯದಾಗಿ ಕಂಡಿತು. ಬಳಿಕ ದೇವರು ಕತ್ತಲೆಯಿಂದ ಬೆಳಕನ್ನು ಬೇರ್ಪಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ದೇವರು ಬೆಳಕಿಗೆ ಹಗಲೆಂದೂ ಕತ್ತಲೆಗೆ ರಾತ್ರಿಯೆಂದೂ ಹೆಸರಿಟ್ಟನು. ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಮುಂಜಾನೆಯೂ ಆಗಿ ಮೊದಲನೆ ದಿನವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ಬಳಿಕ ದೇವರು, “ಜಲಸಮೂಹಗಳ ನಡುವೆ ಗುಮಟ ಉಂಟಾಗಲಿ. ಅದು ಕೆಳಭಾಗದ ನೀರುಗಳನ್ನು ಮೇಲ್ಭಾಗದ ನೀರುಗಳಿಂದ ಬೇರ್ಪಡಿಸಲಿ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ಹೀಗೆ ದೇವರು ಗುಮಟವನ್ನು ಉಂಟುಮಾಡಿ ಅದರ ಕೆಳಭಾಗದ ನೀರುಗಳನ್ನು ಅದರ ಮೇಲ್ಭಾಗದ ನೀರುಗಳಿಂದ ಬೇರ್ಪಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ದೇವರು ಆ ಗುಮಟಕ್ಕೆ ಆಕಾಶವೆಂದು ಹೆಸರಿಟ್ಟನು. ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಮುಂಜಾನೆಯೂ ಆಗಿ ಎರಡನೆ ದಿನವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ಬಳಿಕ ದೇವರು, “ಆಕಾಶದ ಕೆಳಗಿರುವ ನೀರೆಲ್ಲಾ ಒಟ್ಟಿಗೆ ಸೇರಿಕೊಂಡು ಒಣನೆಲವು ಕಾಣಿಸಲಿ” ಅಂದನು. ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ದೇವರು ಒಣನೆಲಕ್ಕೆ ಭೂಮಿಯೆಂದೂ ಒಟ್ಟಿಗೆ ಸೇರಿಕೊಂಡಿದ್ದ ನೀರಿಗೆ ಸಮುದ್ರವೆಂದೂ ಹೆಸರಿಟ್ಟನು. ದೇವರಿಗೆ ಇವು ಒಳ್ಳೆಯದಾಗಿ ಕಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ಬಳಿಕ ದೇವರು, “ಭೂಮಿಯು ಸಸ್ಯರಾಶಿಯನ್ನು ಬೆಳೆಸಲಿ; ಬೀಜಗಳನ್ನು ಫಲಿಸುವ ಸಸ್ಯಗಳು ಬೆಳೆಯಲಿ; ತನ್ನತನ್ನ ಜಾತಿಗನುಸಾರವಾಗಿ ಬೀಜವುಳ್ಳ ಹಣ್ಣುಗಳನ್ನು ಫಲಿಸುವ ಹಣ್ಣಿನ ಮರಗಳು ಭೂಮಿಯ ಮೇಲೆ ಬೆಳೆಯಲಿ” ಅಂದನು. ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ಸಸಿಗಳು ಭೂಮಿಯ ಮೇಲೆ ಬೆಳೆದವು. ಅವುಗಳಲ್ಲಿ ಬೀಜ ಫಲಿಸುವ ಗಿಡಗಳೂ ಬೀಜವುಳ್ಳ ಹಣ್ಣುಗಳನ್ನು ಫಲಿಸುವ ಮರಗಳೂ ಇದ್ದವು. ಪ್ರತಿಯೊಂದು ಸಸಿಯು ತನ್ನದೇ ಆದ ರೀತಿಯ ಬೀಜವನ್ನು ಫಲಿಸಿತು. ದೇವರಿಗೆ ಇವು ಒಳ್ಳೆಯದಾಗಿ ಕಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಮುಂಜಾನೆಯೂ ಆಗಿ ಮೂರನೆ ದಿನವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ಬಳಿಕ ದೇವರು, “ಆಕಾಶದಲ್ಲಿ ಬೆಳಕುಗಳು ಉಂಟಾಗಲಿ. ಈ ಬೆಳಕುಗಳು ಹಗಲುರಾತ್ರಿಗಳನ್ನು ಬೇರ್ಪಡಿಸಲಿ. ಈ ಬೆಳಕುಗಳು ವಿಶೇಷವಾದ ಗುರುತುಗಳಾಗಿದ್ದು, ವಿಶೇಷವಾದ ಸಮಯಗಳನ್ನೂ ದಿನಗಳನ್ನೂ ವರ್ಷಗಳನ್ನೂ ತೋರಿಸಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ಈ ಬೆಳಕುಗಳು ಆಕಾಶದಲ್ಲಿದ್ದು ಭೂಮಿಯ ಮೇಲೆ ಬೆಳಕನ್ನು ಪ್ರಕಾಶಿಸಲಿ” ಅಂದನು. ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ಆದ್ದರಿಂದ ದೇವರು ಎರಡು ದೊಡ್ಡಬೆಳಕುಗಳನ್ನು ಸೃಷ್ಟಿಸಿದನು. ಹಗಲನ್ನಾಳುವುದಕ್ಕಾಗಿ ದೊಡ್ಡಬೆಳಕನ್ನೂ ರಾತ್ರಿಯನ್ನಾಳುವುದಕ್ಕಾಗಿ ಅದಕ್ಕಿಂತ ಚಿಕ್ಕಬೆಳಕನ್ನು ಸೃಷ್ಟಿಸಿದನು. ಆತನು ನಕ್ಷತ್ರಗಳನ್ನು ಸಹ ಸೃಷ್ಟಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ಈ ಬೆಳಕುಗಳು ಭೂಮಿಯ ಮೇಲೆ ಪ್ರಕಾಶಿಸಲೆಂದು ದೇವರು ಅವುಗಳನ್ನು ಆಕಾಶದಲ್ಲಿರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ಹಗಲನ್ನು ಮತ್ತು ರಾತ್ರಿಯನ್ನು ಆಳಲೆಂದು ದೇವರು ಈ ಬೆಳಕುಗಳನ್ನು ಆಕಾಶದಲ್ಲಿರಿಸಿದನು. ಇವು ಬೆಳಕನ್ನು ಕತ್ತಲೆಯಿಂದ ಬೇರ್ಪಡಿಸಿದವು. ದೇವರಿಗೆ ಇವು ಒಳ್ಳೆಯದಾಗಿ ಕಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಮುಂಜಾನೆಯೂ ಆಗಿ ನಾಲ್ಕನೆ ದಿನವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ಬಳಿಕ ದೇವರು, “ನೀರಿನಲ್ಲಿ ಅನೇಕ ಜಲಚರಗಳು ತುಂಬಿಕೊಳ್ಳಲಿ. ಭೂಮಿಯ ಮೇಲೆ ಆಕಾಶದಲ್ಲಿ ಪಕ್ಷಿಗಳು ಹಾರಾಡಲಿ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ಹೀಗೆ ದೇವರು ಸಮುದ್ರದ ಬೃಹದಾಕಾರದ ಪ್ರಾಣಿಗಳನ್ನು, ಸಮುದ್ರದಲ್ಲಿ ಚಲಿಸುವ ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಜೀವಿಗಳನ್ನು ಮತ್ತು ರೆಕ್ಕೆಗಳುಳ್ಳ ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಪಕ್ಷಿಗಳನ್ನು ಸೃಷ್ಟಿಸಿದನು. ಆತನಿಗೆ ಇವು ಒಳ್ಳೆಯದಾಗಿ ಕಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ಇದಲ್ಲದೆ ದೇವರು, “ಪ್ರಾಣಿಗಳು ಅಸಂಖ್ಯಾತವಾಗಿ ಸಮುದ್ರಗಳನ್ನು ತುಂಬಿಕೊಳ್ಳಲಿ; ಪಕ್ಷಿಗಳು ಅಸಂಖ್ಯಾತವಾಗಿ ಭೂಮಿಯಲ್ಲೆಲ್ಲಾ ಹರಡಿಕೊಳ್ಳಲಿ” ಎಂದು ಹೇಳಿ ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಮುಂಜಾನೆಯೂ ಆಗಿ ಐದನೆ ದಿನವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ಬಳಿಕ ದೇವರು, “ಭೂಮಿಯು ಅನೇಕ ಬಗೆಯ ಪ್ರಾಣಿಗಳನ್ನು ಅವುಗಳ ಜಾತಿಗನುಸಾರವಾಗಿ ಹುಟ್ಟಿಸಲಿ. ಪ್ರತಿಯೊಂದು ಬಗೆಯ ದೊಡ್ಡ ಪ್ರಾಣಿಗಳು ಮತ್ತು ಹರಿದಾಡುವ ಚಿಕ್ಕ ಪ್ರಾಣಿಗಳು ಹುಟ್ಟಿಕೊಂಡು ಅಭಿವೃದ್ಧಿಯಾಗಲಿ” ಅಂದನು. ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ಹೀಗೆ ದೇವರು ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಕಾಡುಪ್ರಾಣಿಗಳನ್ನು, ಸಾಕುಪ್ರಾಣಿಗಳನ್ನು ಮತ್ತು ಹರಿದಾಡುವ ಎಲ್ಲಾ ಕ್ರಿಮಿಗಳನ್ನು ಸೃಷ್ಟಿಸಿದನು. ಆತನಿಗೆ ಇವು ಒಳ್ಳೆಯದಾಗಿ ಕಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ಬಳಿಕ ದೇವರು, “ಈಗ ನಾವು ಮನುಷ್ಯನನ್ನು ನಮ್ಮ ಸ್ವರೂಪದಲ್ಲಿ ನಮ್ಮ ಹೋಲಿಕೆಗೆ ಸರಿಯಾಗಿ ನಿರ್ಮಿಸೋಣ. ಮನುಷ್ಯರು ಸಮುದ್ರದಲ್ಲಿರುವ ಎಲ್ಲಾ ಮೀನುಗಳ ಮೇಲೆ, ಆಕಾಶದಲ್ಲಿ ಹಾರಾಡುವ ಎಲ್ಲಾ ಪಕ್ಷಿಗಳ ಮೇಲೆ ಮತ್ತು ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಎಲ್ಲಾ ಕ್ರಿಮಿಗಳ ಮೇಲೆ ದೊರೆತನ ಮಾಡಲಿ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ಹೀಗೆ ದೇವರು ಮನುಷ್ಯನನ್ನು ತನ್ನ ಸ್ವರೂಪದಲ್ಲಿ ತನ್ನ ಹೋಲಿಕೆಗೆ ಸರಿಯಾಗಿ ಸೃಷ್ಟಿಸಿದನು. ಆತನು ಅವರನ್ನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಗಳಾಗಿ ರೂಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ದೇವರು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ, “ನೀವು ಅನೇಕ ಮಕ್ಕಳನ್ನು ಪಡೆದು ಭೂಮಿಯಲ್ಲೆಲ್ಲಾ ಹರಡಿಕೊಂಡು ಅದನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳಿರಿ. ಸಮುದ್ರದಲ್ಲಿರುವ ಮೀನುಗಳ ಮೇಲೆ, ಆಕಾಶದಲ್ಲಿರುವ ಪಕ್ಷಿಗಳ ಮೇಲೆ ಮತ್ತು ಭೂಮಿಯ ಮೇಲೆ ಚಲಿಸುವ ಪ್ರತಿಯೊಂದು ಜೀವಿಯ ಮೇಲೆ ದೊರೆತನ ಮಾಡಿರಿ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ಇದಲ್ಲದೆ ದೇವರು ಅವರಿಗೆ, “ಬೀಜಫಲಿಸುವ ಎಲ್ಲಾ ಸಸಿಗಳನ್ನು ಮತ್ತು ಬೀಜವುಳ್ಳ ಹಣ್ಣುಗಳನ್ನು ಫಲಿಸುವ ಎಲ್ಲಾ ಮರಗಳನ್ನು ನಿಮಗೆ ಆಹಾರವಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರಾಣಿಗಳಿಗೆಲ್ಲಾ ಆಕಾಶದಲ್ಲಿ ಹಾರಾಡುವ ಪಕ್ಷಿಗಳಿಗೆಲ್ಲಾ ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಕ್ರಿಮಿಕೀಟಗಳಿಗೆಲ್ಲಾ ಆಹಾರಕ್ಕಾಗಿ ಸಸ್ಯರಾಶಿಯನ್ನು ಕೊಟ್ಟಿದ್ದೇನೆ” ಅಂದನು. ಹಾಗೆಯೇ ಆಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ದೇವರು ತಾನು ಸೃಷ್ಟಿಸಿದ್ದನ್ನೆಲ್ಲಾ ನೋಡಿದಾಗ, ಅವು ಆತನಿಗೆ ಒಳ್ಳೆಯದಾಗಿ ಕಂಡವು. ಹೀಗೆ ಸಾಯಂಕಾಲವೂ ಮುಂಜಾನೆಯೂ ಆಗಿ ಆರನೆ ದಿನವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ಹೀಗೆ ಭೂಮಿಯೂ ಆಕಾಶವೂ ಅವುಗಳಲ್ಲಿರುವ ಪ್ರತಿಯೊಂದೂ ನಿರ್ಮಿತವಾದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ದೇವರು ತನ್ನ ಸೃಷ್ಟಿಕಾರ್ಯವನ್ನು ಮುಕ್ತಾಯಗೊಳಿಸಿ ಏಳನೆ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ದೇವರು ತನ್ನ ಎಲ್ಲಾ ಸೃಷ್ಟಿಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ಮುಗಿಸಿ ಏಳನೆ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಂಡದ್ದರಿಂದ ಆ ದಿನವು “ಪರಿಶುದ್ಧ ದಿನವಾಗಿರಲಿ” ಎಂದು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ಇದು ಆಕಾಶದ ಮತ್ತು ಭೂಮಿಯ ಚರಿತ್ರೆ. ದೇವರು ಭೂಮಿಯನ್ನು ಮತ್ತು ಆಕಾಶವನ್ನು ಸೃಷ್ಟಿಸಿದಾಗ ನಡೆದ ಸಂಗತಿಗಳೇ ಈ ಚರಿತ್ರೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ಆಗ ಭೂಮಿಯ ಮೇಲೆ ಯಾವ ಮರಗಿಡಗಳೂ ಇರಲಿಲ್ಲ. ಭೂಮಿಯ ಮೇಲೆ ಯಾವ ಸಸಿಯೂ ಬೆಳೆಯುತ್ತಿರಲಿಲ್ಲ; ಯಾಕೆಂದರೆ ಯೆಹೋವನು ಭೂಮಿಯ ಮೇಲೆ ಇನ್ನೂ ಮಳೆಯನ್ನು ಸುರಿಸಿರಲಿಲ್ಲ; ಭೂಮಿಯನ್ನು ಬೇಸಾಯ ಮಾಡಲು ಯಾರೂ ಇರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ಭೂಮಿಯಿಂದ ನೀರು ಚಿಮ್ಮಿಬಂದು ನೆಲವನ್ನೆಲ್ಲಾ ತೋಯಿಸುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ಹೀಗಿರಲು ದೇವರಾದ ಯೆಹೋವನು ನೆಲದಿಂದ ಮಣ್ಣನ್ನು ತೆಗೆದುಕೊಂಡು ಮನುಷ್ಯನನ್ನು ರೂಪಿಸಿ ಮೂಗಿನಲ್ಲಿ ಜೀವಶ್ವಾಸವನ್ನು ಊದಿದನು. ಆಗ ಮನುಷ್ಯನು ಸಜೀವಿಯಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ದೇವರಾದ ಯೆಹೋವನು ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿದ್ದ ಏದೆನ್ ಸೀಮೆಯಲ್ಲಿ ಒಂದು ತೋಟವನ್ನು ಮಾಡಿ ತಾನು ಸೃಷ್ಟಿಸಿದ ಮನುಷ್ಯನನ್ನು ಆ ತೋಟದಲ್ಲಿರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ದೇವರಾದ ಯೆಹೋವನು ಆ ತೋಟದಲ್ಲಿ ಸುಂದರವಾದ ಪ್ರತಿಯೊಂದು ಮರವನ್ನು ಮತ್ತು ಊಟಕ್ಕೆ ಬೇಕಾದ ಒಳ್ಳೆಯ ಹಣ್ಣುಗಳನ್ನು ಬಿಡುವ ಪ್ರತಿಯೊಂದು ಮರವನ್ನು ಬೆಳೆಸಿದನು. ಇದಲ್ಲದೆ ತೋಟದ ಮಧ್ಯಭಾಗದಲ್ಲಿ ಜೀವದಾಯಕ ಮರವನ್ನೂ ಅಲ್ಲದೆ ಒಳ್ಳೆಯದರ ಮತ್ತು ಕೆಟ್ಟದ್ದರ ಬಗ್ಗೆ ಜ್ಞಾನ ಕೊಡುವ ಮರವನ್ನೂ ಬೆಳೆಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ಏದೆನಿನಿಂದ ಹರಿದುಬರುತ್ತಿದ್ದ ನದಿಯು ತೋಟಕ್ಕೆ ಬೇಕಾದ ನೀರನ್ನು ಒದಗಿಸುತ್ತಿತ್ತು. ಬಳಿಕ ಅದೇ ನದಿಯು ಶಾಖೆಗಳಾಗಿ ಒಡೆದು ನಾಲ್ಕು ಉಪನದಿಗಳಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ಮೊದಲನೆ ನದಿಯ ಹೆಸರು ಪೀಶೋನ್. ಹವೀಲ ದೇಶದಲ್ಲೆಲ್ಲಾ ಹರಿಯುತ್ತಿದ್ದ ನದಿ ಇದೇ. ");
INSERT INTO kan2010_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ಈ ದೇಶದಲ್ಲಿ ಒಳ್ಳೆಯ ಬಂಗಾರ ದೊರೆಯುತ್ತಿತ್ತು. ಅಲ್ಲದೆ ಗುಗ್ಗುಲ ಗೋಮೇಧಿಕ ರತ್ನವೂ ದೊರಕುತ್ತಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ಎರಡನೆ ನದಿಯ ಹೆಸರು ಗೀಹೋನ್. ಇಥಿಯೋಪಿಯ ದೇಶದಲ್ಲೆಲ್ಲಾ ಹರಿಯುತ್ತಿದ್ದ ನದಿ ಇದೇ. ");
INSERT INTO kan2010_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ಮೂರನೆ ನದಿಯ ಹೆಸರು ಟೈಗ್ರಿಸ್. ದಕ್ಷಿಣ ಅಸ್ಸೀರಿಯ ದೇಶದಲ್ಲಿ ಹರಿಯುತ್ತಿದ್ದ ನದಿ ಇದೇ. ನಾಲ್ಕನೆ ನದಿಯ ಹೆಸರು ಯೂಫ್ರೇಟೀಸ್. ");
INSERT INTO kan2010_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ದೇವರಾದ ಯೆಹೋವನು ಆ ಮನುಷ್ಯನನ್ನು ಏದೆನ್ ತೋಟಕ್ಕೆ ಕರೆದೊಯ್ದು ವ್ಯವಸಾಯ ಮಾಡುವುದಕ್ಕಾಗಿಯೂ ಅದನ್ನು ನೋಡಿಕೊಳ್ಳುವುದಕ್ಕೂ ಅದರಲ್ಲಿರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ದೇವರಾದ ಯೆಹೋವನು ಆ ಮನುಷ್ಯನಿಗೆ, “ತೋಟದಲ್ಲಿರುವ ಯಾವ ಮರದ ಹಣ್ಣನ್ನು ಬೇಕಾದರೂ ನೀನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ಆದರೆ ಒಳ್ಳೆಯದು ಮತ್ತು ಕೆಟ್ಟದ್ದರ ಬಗ್ಗೆ ಜ್ಞಾನ ಕೊಡುವ ಮರದ ಹಣ್ಣನ್ನು ಮಾತ್ರ ನೀನು ತಿನ್ನಕೂಡದು. ಒಂದುವೇಳೆ ಆ ಮರದ ಹಣ್ಣನ್ನು ತಿಂದರೆ ನೀನು ಸಾಯುವೆ!” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ಬಳಿಕ ದೇವರಾದ ಯೆಹೋವನು, “ಮನುಷ್ಯನು ಒಬ್ಬಂಟಿಗನಾಗಿರುವುದು ಒಳ್ಳೆಯದಲ್ಲವೆಂದು ನನಗೆ ತೋರುತ್ತದೆ. ಅವನಿಗೆ ಸರಿಹೊಂದುವ ಸಹಕಾರಿಣಿಯನ್ನು ಉಂಟುಮಾಡುವೆನು” ಎಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ದೇವರಾದ ಯೆಹೋವನು ನೆಲದ ಮಣ್ಣಿನಿಂದ ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಪಶುವನ್ನೂ ಆಕಾಶದಲ್ಲಿರುವ ಪ್ರತಿಯೊಂದು ಪಕ್ಷಿಯನ್ನೂ ನಿರ್ಮಿಸಿ ಮನುಷ್ಯನ ಬಳಿಗೆ ಬರಮಾಡಿದನು. ಅವುಗಳಿಗೆಲ್ಲಾ ಮನುಷ್ಯನು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ಭೂಮಿಯ ಮೇಲಿನ ಎಲ್ಲಾ ಪಶುಗಳಿಗೂ ಆಕಾಶದಲ್ಲಿ ಹಾರಾಡುವ ಎಲ್ಲಾ ಪಕ್ಷಿಗಳಿಗೂ ಮತ್ತು ಕಾಡಿನಲ್ಲಿರುವ ಎಲ್ಲಾ ಕ್ರೂರಪ್ರಾಣಿಗಳಿಗೂ ಮನುಷ್ಯನು ಹೆಸರಿಟ್ಟನು. ಮನುಷ್ಯನು ಅನೇಕಾನೇಕ ಪ್ರಾಣಿಗಳನ್ನು ಮತ್ತು ಪಕ್ಷಿಗಳನ್ನು ನೋಡಿದನು. ಆದರೆ ಅವುಗಳಲ್ಲಿ ತನಗೆ ಸರಿಹೊಂದುವ ಸಹಕಾರಿಣಿಯನ್ನು ಅವನು ಕಾಣಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ಆದ್ದರಿಂದ ದೇವರಾದ ಯೆಹೋವನು ಮನುಷ್ಯನಿಗೆ ಗಾಢವಾದ ನಿದ್ರೆಯನ್ನು ಬರಮಾಡಿ ಅವನ ದೇಹದ ಪಕ್ಕೆಲುಬುಗಳಲ್ಲಿ ಒಂದನ್ನು ತೆಗೆದುಕೊಂಡು ಆ ಪಕ್ಕೆಲುಬಿನ ಸ್ಥಳವನ್ನು ಮಾಂಸದಿಂದ ಮುಚ್ಚಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ಆತನು ಮನುಷ್ಯನ ಪಕ್ಕೆಲುಬಿನಿಂದ ಸ್ತ್ರೀಯನ್ನು ಸೃಷ್ಟಿಸಿ ಅವಳನ್ನು ಮನುಷ್ಯನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ಆಗ ಅವನು ಆಕೆಯನ್ನು ನೋಡಿ, “ಈಗ ಸರಿ, ಈಕೆ ನನ್ನಂತೆಯೇ ಇದ್ದಾಳೆ. ಈಕೆಯ ಎಲುಬುಗಳು ನನ್ನ ಎಲುಬುಗಳಿಂದ ಬಂದಿವೆ. ಈಕೆಯ ದೇಹವು ನನ್ನ ದೇಹದಿಂದ ಬಂದಿದೆ. ಈಕೆ ಮನುಷ್ಯನಿಂದ ಉತ್ಪತ್ತಿಯಾದವಳು. ಆದ್ದರಿಂದ ಈಕೆಗೆ ನಾನು ‘ಸ್ತ್ರೀ’ ಎಂದು ಹೆಸರಿಡುವೆ” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ಆದ್ದರಿಂದ ಪುರುಷನು ತನ್ನ ತಂದೆತಾಯಿಗಳನ್ನು ಬಿಟ್ಟು ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಸೇರಿಕೊಳ್ಳುವನು. ಅವರಿಬ್ಬರೂ ಒಂದೇ ಶರೀರವಾಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ಆ ಪುರುಷನು ಮತ್ತು ಅವನ ಹೆಂಡತಿ ಬೆತ್ತಲೆಯಾಗಿದ್ದರೂ ನಾಚಿಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ದೇವರಾದ ಯೆಹೋವನು ಸೃಷ್ಟಿಸಿದ ಪ್ರಾಣಿಗಳಲ್ಲೆಲ್ಲಾ ಹಾವು ಅತಿ ಬುದ್ಧಿವಂತವಾದ ಮತ್ತು ಕುತಂತ್ರವುಳ್ಳ ಜಂತುವಾಗಿತ್ತು. ಹಾವು ಸ್ತ್ರೀಯನ್ನು ಮೋಸಗೊಳಿಸಬೇಕೆಂದಿತ್ತು. ಹಾವು ಅವಳಿಗೆ, “ಅಮ್ಮಾ, ಈ ತೋಟದಲ್ಲಿರುವ ಯಾವ ಮರದ ಹಣ್ಣನ್ನೂ ನೀವು ತಿನ್ನಕೂಡದೆಂದು ದೇವರು ನಿಮಗೆ ಹೇಳಿರುವುದು ನಿಜವೇ?” ಎಂದು ಕೇಳಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ಸ್ತ್ರೀಯು ಹಾವಿಗೆ, “ಇಲ್ಲ! ದೇವರು ಹಾಗೆ ಹೇಳಲಿಲ್ಲ! ತೋಟದಲ್ಲಿರುವ ಮರಗಳ ಹಣ್ಣುಗಳನ್ನು ನಾವು ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ಆದರೆ ಒಂದು ಮರದ ಹಣ್ಣನ್ನು ಮಾತ್ರ ನಾವು ತಿನ್ನಕೂಡದು. ದೇವರು ನಮಗೆ, ‘ತೋಟದ ಮಧ್ಯದಲ್ಲಿರುವ ಮರದ ಹಣ್ಣನ್ನು ನೀವು ತಿನ್ನಕೂಡದು; ಆ ಮರವನ್ನು ಮುಟ್ಟಕೂಡದು, ಇಲ್ಲವಾದರೆ ನೀವು ಸಾಯುವಿರಿ’ ಎಂದು ಹೇಳಿದ್ದಾನೆ” ಎಂಬುದಾಗಿ ಉತ್ತರಕೊಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ಅದಕ್ಕೆ ಹಾವು ಸ್ತ್ರೀಗೆ, “ನೀವು ಸಾಯುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ನೀವು ಆ ಮರದ ಹಣ್ಣನ್ನು ತಿಂದರೆ ನಿಮಗೆ ಒಳ್ಳೆಯದರ ಮತ್ತು ಕೆಟ್ಟದ್ದರ ಬಗ್ಗೆ ಜ್ಞಾನ ಬರುತ್ತದೆಯೆಂದು ದೇವರಿಗೆ ಗೊತ್ತಿದೆ. ಅಲ್ಲದೆ ನೀವು ದೇವರಿಗೆ ಸರಿಸಮಾನರಾಗುವಿರಿ” ಎಂದು ಹೇಳಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ಸ್ತ್ರೀಗೆ ಆ ಮರವು ಸುಂದರವಾಗಿ ಕಂಡಿತು. ಅದರ ಹಣ್ಣು ಆಕೆಗೆ ತಿನ್ನಲು ಯೋಗ್ಯವಾಗಿ ಕಂಡಿತು. ಆ ಮರವು ತನ್ನನ್ನು ಜ್ಞಾನಿಯನ್ನಾಗಿ ಮಾಡುತ್ತದೆಯೆಂದು ಆಕೆ ಉತ್ಸಾಹಗೊಂಡಳು. ಆದ್ದರಿಂದ ಸ್ತ್ರೀಯು ಆ ಮರದ ಹಣ್ಣನ್ನು ಕಿತ್ತುಕೊಂಡು ತಿಂದಳು; ತನ್ನೊಂದಿಗಿದ್ದ ಗಂಡನಿಗೂ ಸ್ವಲ್ಪ ಹಣ್ಣನ್ನು ಕೊಟ್ಟಳು. ಅವನು ಸಹ ಅದನ್ನು ತಿಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ಕೂಡಲೇ ಪುರುಷನಲ್ಲಿಯೂ ಸ್ತ್ರೀಯಲ್ಲಿಯೂ ಬದಲಾವಣೆಗಳಾದವು. ಅವರ ಕಣ್ಣುಗಳು ತೆರೆದವು. ಅವರಿಗೆ ಎಲ್ಲವೂ ವಿಚಿತ್ರವಾಗಿ ಕಂಡವು. ತಾವು ಬೆತ್ತಲೆಯಿಂದಿರುವುದನ್ನು ಕಂಡು ಅಂಜೂರದ ಎಲೆಗಳನ್ನು ಕಿತ್ತು ಒಂದಕ್ಕೊಂದು ಜೋಡಿಸಿ ಸುತ್ತಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ಅಂದು ಸಂಜೆ ತಂಗಾಳಿ ಬೀಸುತ್ತಿರಲು ದೇವರಾದ ಯೆಹೋವನು ತೋಟದಲ್ಲಿ ತಿರುಗಾಡುತ್ತಿದ್ದನು. ಆತನ ಸಪ್ಪಳವನ್ನು ಕೇಳಿದ ಪುರುಷನು ಮತ್ತು ಅವನ ಹೆಂಡತಿಯು ತೋಟದ ಮರಗಳ ಮರೆಯಲ್ಲಿ ಅಡಗಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ದೇವರಾದ ಯೆಹೋವನು ಪುರುಷನಿಗೆ, “ನೀನು ಎಲ್ಲಿರುವೆ?” ಎಂದು ಕೂಗಿ ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ಅದಕ್ಕೆ ಪುರುಷನು, “ನೀನು ತೋಟದಲ್ಲಿ ತಿರುಗಾಡುತ್ತಿರುವ ಸಪ್ಪಳವನ್ನು ನಾನು ಕೇಳಿದೆನು. ಆದರೆ ನಾನು ಬೆತ್ತಲೆಯಾಗಿದ್ದರಿಂದ ಭಯದಿಂದ ಅಡಗಿಕೊಂಡೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ದೇವರು ಪುರುಷನಿಗೆ, “ನೀನು ಬೆತ್ತಲೆಯಾಗಿರುವೆ ಎಂದು ನಿನಗೆ ಹೇಳಿದವರು ಯಾರು? ವಿಶೇಷವಾದ ಆ ಮರದ ಹಣ್ಣನ್ನು ನೀನು ತಿಂದೆಯಾ? ಆ ಮರದ ಹಣ್ಣನ್ನು ತಿನ್ನಕೂಡದೆಂದು ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೆನಲ್ಲಾ!” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ಅದಕ್ಕೆ ಪುರುಷನು, “ನೀನು ನನಗಾಗಿ ಕೊಟ್ಟ ಸ್ತ್ರೀಯು ಆ ಮರದ ಹಣ್ಣನ್ನು ನನಗೆ ಕೊಟ್ಟಳು; ಆದ್ದರಿಂದ ನಾನು ತಿಂದೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ಆಗ ದೇವರಾದ ಯೆಹೋವನು ಸ್ತ್ರೀಗೆ, “ನೀನು ಮಾಡಿದ್ದೇನು?” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕೆ ಸ್ತ್ರೀಯು, “ಆ ಹಾವಿನ ಮೋಸಕ್ಕೆ ಒಳಗಾಗಿ ನಾನು ಆ ಹಣ್ಣನ್ನು ತಿಂದೆ” ಅಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ಆಗ ದೇವರಾದ ಯೆಹೋವನು ಹಾವಿಗೆ, “ನೀನು ಮಾಡಿದ ಈ ಕೆಟ್ಟಕಾರ್ಯದಿಂದ ನಿನಗೂ ಕೇಡುಗಳಾಗುತ್ತವೆ. ಬೇರೆಲ್ಲಾ ಪ್ರಾಣಿಗಳಿಗಿಂತಲೂ ನಿನಗೆ ಹೀನಸ್ಥಿತಿ ಉಂಟಾಗುವುದು. ನೀನು ಹೊಟ್ಟೆಯಿಂದಲೇ ತೆವಳಿಕೊಂಡು ನಿನ್ನ ಜೀವಮಾನವೆಲ್ಲಾ ಮಣ್ಣನ್ನೇ ತಿನ್ನುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ನೀನು ಮತ್ತು ಸ್ತ್ರೀಯು ಒಬ್ಬರಿಗೊಬ್ಬರು ವೈರಿಗಳಾಗಿರುವಂತೆ ಮಾಡುವೆನು. ನಿನ್ನ ಮಕ್ಕಳು ಮತ್ತು ಅವಳ ಮಕ್ಕಳು ಒಬ್ಬರಿಗೊಬ್ಬರು ವೈರಿಗಳಾಗಿರುವರು. ನೀನು ಆಕೆಯ ಮಗನ ಪಾದವನ್ನು ಕಚ್ಚುವೆ. ಆದರೆ ಅವನು ನಿನ್ನ ತಲೆಯನ್ನು ಜಜ್ಜಿ ಹಾಕುವನು” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ಬಳಿಕ ದೇವರಾದ ಯೆಹೋವನು ಸ್ತ್ರೀಗೆ, “ನೀನು ಗರ್ಭಿಣಿಯಾಗಿರುವಾಗ ಬಹು ಸಂಕಟಪಡುವೆ. ನೀನು ಮಕ್ಕಳನ್ನು ಹೆರುವಾಗ ಬಹಳ ವೇದನೆಪಡುವೆ. ನೀನು ಗಂಡನನ್ನು ಬಹಳವಾಗಿ ಇಷ್ಟಪಡುವೆ; ಆದರೆ ಅವನು ನಿನ್ನನ್ನು ಆಳುವನು” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ಆಮೇಲೆ ದೇವರಾದ ಯೆಹೋವನು ಪುರುಷನಿಗೆ, “ವಿಶೇಷವಾದ ಆ ಮರದ ಹಣ್ಣನ್ನು ತಿನ್ನಕೂಡದೆಂದು ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೆ. ಆದರೆ ನೀನು ನಿನ್ನ ಹೆಂಡತಿಯ ಮಾತನ್ನು ಕೇಳಿ ಆ ಮರದ ಹಣ್ಣನ್ನು ತಿಂದೆ. ನಿನ್ನ ದೆಸೆಯಿಂದ ನಾನು ಭೂಮಿಯನ್ನು ಶಪಿಸುವೆನು. ಭೂಮಿಯು ಫಲಿಸುವ ಆಹಾರಕ್ಕಾಗಿ ನೀನು ನಿನ್ನ ಜೀವಮಾನದ ದಿನಗಳಲ್ಲೆಲ್ಲಾ ಕಷ್ಟಪಟ್ಟು ದುಡಿಯಲೇಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ಭೂಮಿಯು ನಿನಗೋಸ್ಕರ ಮುಳ್ಳುಗಿಡಗಳನ್ನೂ ಕಳೆಗಳನ್ನೂ ಬೆಳೆಸುವುದು. ಹೊಲದಲ್ಲಿ ಬೆಳೆಯುವ ಬೆಳೆಯನ್ನು ನೀನು ತಿನ್ನುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ನಿನ್ನ ಮುಖದಲ್ಲಿ ಬೆವರು ಹರಿಯುವ ತನಕ ನೀನು ಆಹಾರಕ್ಕಾಗಿ ಕಷ್ಟಪಟ್ಟು ದುಡಿಯುವೆ. ನೀನು ಸಾಯುವ ದಿನದವರೆಗೆ ಕಷ್ಟಪಟ್ಟು ಕೆಲಸ ಮಾಡುವೆ. ಆಮೇಲೆ ನೀನು ಮಣ್ಣಾಗುವೆ. ನಾನು ನಿನ್ನನ್ನು ನಿರ್ಮಿಸಲು ಮಣ್ಣನ್ನು ಉಪಯೋಗಿಸಿದೆ. ನೀನು ಸತ್ತಾಗ ಮತ್ತೆ ಮಣ್ಣೇ ಆಗುವೆ” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ಆದಾಮನು ತನ್ನ ಹೆಂಡತಿಗೆ ಹವ್ವ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಆದಾಮನು ಹವ್ವ ಎಂದು ಹೆಸರಿಡಲು ಕಾರಣವೇನೆಂದರೆ ಈ ಲೋಕದಲ್ಲಿ ಹುಟ್ಟಿದ ಪ್ರತಿಯೊಬ್ಬರಿಗೂ ಆಕೆಯೇ ಮೂಲ ತಾಯಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ದೇವರಾದ ಯೆಹೋವನು ಪ್ರಾಣಿಯ ಚರ್ಮದಿಂದ ಉಡುಪುಗಳನ್ನು ಮಾಡಿ ಆದಾಮನಿಗೆ ಮತ್ತು ಅವನ ಹೆಂಡತಿಗೆ ತೊಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ದೇವರಾದ ಯೆಹೋವನು, “ಮನುಷ್ಯನು ಒಳ್ಳೆಯದರ ಮತ್ತು ಕೆಟ್ಟದ್ದರ ಬಗ್ಗೆ ತಿಳಿದುಕೊಂಡು ನಮ್ಮಂತಾದನು. ಈಗ ಮನುಷ್ಯನು ಜೀವದಾಯಕ ಮರದ ಹಣ್ಣನ್ನೇನಾದರೂ ತೆಗೆದುಕೊಂಡು ತಿಂದರೆ ಅವನು ಸದಾಕಾಲ ಬದುಕುವನು” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ಆದ್ದರಿಂದ ಆತನು ಆದಾಮನನ್ನು ಅವನು ಉತ್ಪತ್ತಿಗೊಂಡಿದ್ದ ನೆಲದಲ್ಲಿ ವ್ಯವಸಾಯ ಮಾಡಲು ಬಲವಂತವಾಗಿ ಏದೆನ್ ತೋಟದಿಂದ ಹೊರಡಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ಅಲ್ಲದೆ ಏದೆನ್ ತೋಟವನ್ನು ಸಂರಕ್ಷಿಸುವುದಕ್ಕಾಗಿ ಆತನು ಕೆರೂಬಿದೂತರನ್ನು ತೋಟದ ಪೂರ್ವಭಾಗದಲ್ಲಿ ಇರಿಸಿದನು. ಇದಲ್ಲದೆ ಆತನು ಬೆಂಕಿಯ ಖಡ್ಗವನ್ನು ಅಲ್ಲಿಟ್ಟನು. ಈ ಖಡ್ಗವು ಎಲ್ಲಾ ದಿಕ್ಕುಗಳತ್ತ ತಿರುಗುತ್ತಾ ಧಗಧಗನೆ ಪ್ರಜ್ವಲಿಸುತ್ತಾ ಜೀವದಾಯಕ ಮರದ ಮಾರ್ಗವನ್ನು ಕಾಯುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ಆದಾಮ ಮತ್ತು ಹವ್ವಳು ಕೂಡಿದರು. ಆದ್ದರಿಂದ ಹವ್ವಳಿಗೆ ಒಂದು ಮಗು ಜನಿಸಿತು. ಹವ್ವಳು, “ಯೆಹೋವನ ಸಹಾಯದಿಂದ ಗಂಡುಮಗುವನ್ನು ಪಡೆದಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ಕಾಯಿನ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ಆಮೇಲೆ, ಹವ್ವಳಿಗೆ ಮತ್ತೊಂದು ಮಗು ಜನಿಸಿತು. ಈ ಮಗುವೇ ಕಾಯಿನನ ತಮ್ಮನಾದ ಹೇಬೆಲ. ಹೇಬೆಲನು ಕುರುಬನಾದನು ಕಾಯಿನನು ರೈತನಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ಸ್ವಲ್ಪ ಕಾಲದ ನಂತರ ಕಾಯಿನನು ದೇವರಿಗೆ ಕೃತಜ್ಞತಾ ಕಾಣಿಕೆಯನ್ನು ತಂದನು. ಕಾಯಿನನು ತಾನು ಹೊಲದಲ್ಲಿ ಬೆಳೆದ ಕೆಲವು ಆಹಾರಪದಾರ್ಥಗಳನ್ನು ತಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ಹೇಬೆಲನು ತನ್ನ ಕುರಿಮಂದೆಯಿಂದ ಒಳ್ಳೆಯ ಚೊಚ್ಚಲ ಕುರಿಗಳನ್ನು ಮತ್ತು ಅವುಗಳ ಒಳ್ಳೆಯ ಕೊಬ್ಬಿದ ಭಾಗಗಳನ್ನು ತಂದನು. ಯೆಹೋವನು ಹೇಬೆಲನ ಕಾಣಿಕೆಯನ್ನು ಸ್ವೀಕರಿಸಿದನು; ");
INSERT INTO kan2010_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ಆದರೆ ಕಾಯಿನನ ಕಾಣಿಕೆಯನ್ನು ಸ್ವೀಕರಿಸಲಿಲ್ಲ. ಇದರಿಂದ ಕಾಯಿನನು ದುಃಖಿತನಾದನು ಮತ್ತು ಬಹಳ ಕೋಪಗೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ಯೆಹೋವನು ಕಾಯಿನನಿಗೆ, “ಏಕೆ ಕೋಪಗೊಂಡಿರುವೆ? ನಿನ್ನ ಮುಖ ವ್ಯಸನದಿಂದಿರುವುದೇಕೆ? ");
INSERT INTO kan2010_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ನೀನು ಒಳ್ಳೆಯ ಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದರೆ ನಾನು ನಿನ್ನನ್ನು ಸ್ವೀಕರಿಸಿಕೊಳ್ಳುವೆನು. ಆದರೆ ನೀನು ಕೆಟ್ಟಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದರೆ, ಆ ಪಾಪವು ನಿನ್ನೊಂದಿಗಿರುತ್ತದೆ. ನಿನ್ನ ಪಾಪವು ನಿನ್ನನ್ನು ತನ್ನ ಹಿಡಿತದಲ್ಲಿಟ್ಟುಕೊಳ್ಳಲು ಇಷ್ಟಪಡುತ್ತದೆ. ಆದರೆ ನೀನು ಆ ಪಾಪವನ್ನು ನಿನ್ನ ಹಿಡಿತದಲ್ಲಿಟ್ಟುಕೊಳ್ಳಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ಕಾಯಿನನು ತನ್ನ ತಮ್ಮನಾದ ಹೇಬೆಲನಿಗೆ, “ನಾವು ಹೊಲಕ್ಕೆ ಹೋಗೋಣ ಬಾ” ಎಂದು ಹೇಳಿದನು. ಅಂತೆಯೇ ಕಾಯಿನನು ಮತ್ತು ಹೇಬೆಲನು ಹೊಲಕ್ಕೆ ಹೋದರು. ಅಲ್ಲಿ ಕಾಯಿನನು ತನ್ನ ತಮ್ಮನ ಮೇಲೆರಗಿ ಅವನನ್ನು ಕೊಂದುಹಾಕಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ತರುವಾಯ ಯೆಹೋವನು ಕಾಯಿನನಿಗೆ, “ನಿನ್ನ ತಮ್ಮನಾದ ಹೇಬೆಲನೆಲ್ಲಿ?” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕೆ ಕಾಯಿನನು, “ನನಗೆ ಗೊತ್ತಿಲ್ಲ. ನನ್ನ ತಮ್ಮನನ್ನು ಕಾಯುವುದಾಗಲಿ ನೋಡಿಕೊಳ್ಳುವುದಾಗಲಿ ನನ್ನ ಕೆಲಸವೇ?” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ಅದಕ್ಕೆ ಯೆಹೋವನು, “ನೀನು ಮಾಡಿದ್ದೇನು? ನೀನು ನಿನ್ನ ತಮ್ಮನನ್ನೇ ಕೊಲೆಮಾಡಿದೆ! ಅವನ ರಕ್ತವು ಭೂಮಿಯ ಕಡೆಯಿಂದ ನನ್ನನ್ನು ಕೂಗುತಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ನೀನು ನಿನ್ನ ತಮ್ಮನನ್ನು ಕೊಂದುಹಾಕಿದೆ. ನಿನ್ನ ಕೈಗಳಿಂದ ಸುರಿಸಿದ ಅವನ ರಕ್ತವನ್ನು ಕುಡಿಯಲು ಭೂಮಿಯು ಬಾಯಿ ತೆರೆಯಿತು. ಆದ್ದರಿಂದ ಈಗ ಅದು ಶಾಪಗ್ರಸ್ತವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ಕಳೆದ ದಿನಗಳಲ್ಲಿ ನೀನು ಸಸಿಗಳನ್ನು ನೆಟ್ಟಾಗ ಸಸಿಗಳು ಚೆನ್ನಾಗಿ ಬೆಳೆದವು. ಆದರೆ ಈಗ ನೀನು ಸಸಿ ನೆಟ್ಟರೂ ಭೂಮಿ ಫಲಿಸುವುದಿಲ್ಲ. ನಿನಗೆ ಭೂಮಿಯ ಮೇಲೆ ಮನೆ ಇರುವುದಿಲ್ಲ. ನೀನು ಸ್ಥಳದಿಂದ ಸ್ಥಳಕ್ಕೆ ಅಲೆದಾಡುವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ಅದಕ್ಕೆ ಕಾಯಿನನು ಯೆಹೋವನಿಗೆ, “ಈ ಶಿಕ್ಷೆಯನ್ನು ನಾನು ಸಹಿಸಲಾರೆ! ");
INSERT INTO kan2010_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ನೀನು ನನ್ನನ್ನು ನನ್ನ ದೇಶದಿಂದ ಬಲವಂತವಾಗಿ ಹೊರಡಿಸುತ್ತಿರುವೆ. ನಿನ್ನನ್ನು ನೋಡುವುದಕ್ಕಾಗಲಿ ನಿನ್ನ ಸಮೀಪದಲ್ಲಿ ಇರುವುದಕ್ಕಾಗಲಿ ನನಗೆ ಸಾಧ್ಯವಿರುವುದಿಲ್ಲ! ನನಗೆ ಮನೆಯೂ ಇಲ್ಲ! ನಾನು ಭೂಮಿಯ ಮೇಲೆ ಸ್ಥಳದಿಂದ ಸ್ಥಳಕ್ಕೆ ಬಲವಂತವಾಗಿ ಅಲೆದಾಡಬೇಕಾಗುವುದು. ನನ್ನನ್ನು ಕಂಡವರು ನನ್ನನ್ನು ಕೊಲ್ಲುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ಅದಕ್ಕೆ ಯೆಹೋವನು ಕಾಯಿನನಿಗೆ, “ಆ ರೀತಿ ಆಗದಂತೆ ನಾನು ನೋಡಿಕೊಳ್ಳುವೆ! ಕಾಯಿನನೇ, ನಿನ್ನನ್ನು ಯಾವನಾದರೂ ಕೊಂದರೆ, ನಾನು ಅವನನ್ನು ಏಳರಷ್ಟು ಶಿಕ್ಷಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ಆಮೇಲೆ ಯೆಹೋವನು ಕಾಯಿನನ ಮೇಲೆ ಒಂದು ಗುರುತಿಟ್ಟನು. ಅವನನ್ನು ಯಾರೂ ಕೊಲ್ಲಕೂಡದೆಂದು ಆ ಗುರುತು ಸೂಚಿಸುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ಕಾಯಿನನು ಯೆಹೋವನ ಪ್ರಸನ್ನತೆಯಿಂದ ದೂರ ಹೊರಟುಹೋದನು. ಕಾಯಿನನು ನೋದು ಎಂಬ ನಾಡಿನಲ್ಲಿ ವಾಸಿಸಿದನು. ಅದು ಏದೆನ್ ತೋಟಕ್ಕೆ ಪೂರ್ವದಲ್ಲಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ಕಾಯಿನ ಮತ್ತು ಅವನ ಹೆಂಡತಿಗೆ ಒಂದು ಗಂಡುಮಗು ಹುಟ್ಟಿತು. ಅವರು ಆ ಮಗುವಿಗೆ ಹನೋಕ ಎಂದು ಹೆಸರಿಟ್ಟರು. ಕಾಯಿನನು ಒಂದು ಊರನ್ನು ಕಟ್ಟಿದನು. ಆ ಊರಿಗೆ ಅವನು ತನ್ನ ಮಗನ ಹೆಸರನ್ನೇ ಇಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ಹನೋಕನು ಈರಾದ್ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ಈರಾದನು ಮೆಹೂಯಾಯೇಲ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ಮೆಹೂಯಾಯೇಲನು ಮೆತೂಷಾಯೇಲ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ಮೆತೂಷಾಯೇಲನು ಲೆಮೆಕ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ಲೆಮೆಕನು ಇಬ್ಬರು ಹೆಂಗಸರನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡನು. ಮೊದಲನೆ ಹೆಂಡತಿಯ ಹೆಸರು ಆದಾ; ಎರಡನೆ ಹೆಂಡತಿಯ ಹೆಸರು ಚಿಲ್ಲಾ. ");
INSERT INTO kan2010_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ಆದಳಿಗೆ ಯಾಬಾಲ ಎಂಬ ಮಗನು ಹುಟ್ಟಿದನು. ಗುಡಾರಗಳಲ್ಲಿದ್ದುಕೊಂಡು ಪಶುಗಳನ್ನು ಸಾಕಿಕೊಂಡು ಜೀವನ ಮಾಡುತ್ತಿದ್ದ ಜನರಿಗೆ ಯಾಬಾಲನೇ ಮೂಲಪಿತೃ. ");
INSERT INTO kan2010_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ಆದಳಿಗೆ ಮತ್ತೊಬ್ಬ ಮಗ ಹುಟ್ಟಿದನು. ಅವನೇ ಯೂಬಾಲ. ಕಿನ್ನರಿಕೊಳಲುಗಳನ್ನು ನುಡಿಸುವ ಜನರಿಗೆ ಯೂಬಾಲನೇ ಮೂಲಪಿತೃ. ");
INSERT INTO kan2010_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ಚಿಲ್ಲಾಳಿಗೆ ತೂಬಲ್‌ಕಾಯಿನ ಎಂಬ ಮಗನು ಹುಟ್ಟಿದನು. ಕಬ್ಬಿಣ ಮತ್ತು ತಾಮ್ರಗಳಿಂದ ಉಪಕರಣ ಮಾಡುತ್ತಿದ್ದವರಿಗೆ ತೂಬಲ್‌ಕಾಯಿನನೇ ಮೂಲಪಿತೃ. ತೂಬಲ್‌ಕಾಯಿನನ ತಂಗಿ ನಯಮಾ. ");
INSERT INTO kan2010_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ಲೆಮೆಕನು ತನ್ನ ಹೆಂಡತಿಯರಿಗೆ ಹೀಗೆಂದನು: “ಆದಾ, ಚಿಲ್ಲಾ, ನನ್ನ ಮಾತನ್ನು ಕೇಳಿ! ಲೆಮೆಕನ ಹೆಂಡತಿಯರೇ, ನಾನು ಹೇಳುವುದನ್ನು ಕೇಳಿ. ಒಬ್ಬನು ನನಗೆ ಗಾಯ ಮಾಡಿದ, ಆದ್ದರಿಂದ ನಾನು ಅವನನ್ನು ಕೊಂದೆ, ಒಬ್ಬ ಯುವಕನು ನನ್ನನ್ನು ಹೊಡೆದ, ಆದ್ದರಿಂದ ನಾನು ಅವನನ್ನು ಕೊಂದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ಕಾಯಿನನನ್ನು ಕೊಂದವರಿಗೆ ಏಳರಷ್ಟು ಶಿಕ್ಷೆಯಾಗುವುದು! ಆದರೆ ನನ್ನನ್ನು ಕೊಂದವರಿಗೆ ಎಪ್ಪತ್ತೇಳರಷ್ಟು ಶಿಕ್ಷೆಯಾಗುವುದು!” ");
INSERT INTO kan2010_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ಆದಾಮನು ತಿರಿಗಿ ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಕೂಡಲು, ಆಕೆಗೆ ಮತ್ತೊಬ್ಬ ಮಗ ಹುಟ್ಟಿದನು. ಹವ್ವಳು, “ದೇವರು ನನಗೆ ಮತ್ತೊಬ್ಬ ಮಗನನ್ನು ಕೊಟ್ಟನು. ಕಾಯಿನನು ಕೊಂದ ಹೇಬೆಲನಿಗೆ ಬದಲಾಗಿ ದೇವರು ನನಗೆ ಗಂಡುಮಗುವನ್ನು ಕೊಟ್ಟನು” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ಸೇತ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ಸೇತನು ಒಬ್ಬ ಮಗನನ್ನು ಪಡೆದನು. ಆ ಮಗುವಿಗೆ ಅವನು ಎನೋಷ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಆ ಕಾಲದಲ್ಲಿ ಜನರು ಯೆಹೋವನ ಮೇಲೆ ಭರವಸೆ ಇಡಲಾರಂಭಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ಇದು ಆದಾಮನ ಕುಟುಂಬ ಚರಿತ್ರೆ. ದೇವರು ಮನುಷ್ಯನನ್ನು ತನ್ನ ಹೋಲಿಕೆಗೆ ಸರಿಯಾಗಿ ಸೃಷ್ಟಿ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ದೇವರು ಅವರನ್ನು ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಗಳಾಗಿ ಉಂಟುಮಾಡಿದನು. ಆತನು ಅವರನ್ನು ನಿರ್ಮಿಸಿದ ದಿನದಲ್ಲೇ ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ ಅವರಿಗೆ, “ಮನುಷ್ಯ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ಆದಾಮನು 130 ವರ್ಷದವನಾದಾಗ ಮತ್ತೊಬ್ಬ ಮಗನನ್ನು ಪಡೆದನು. ಆ ಮಗನು ರೂಪದಲ್ಲಿ ಆದಾಮನಂತಿದ್ದನು. ಆದಾಮನು ಅವನಿಗೆ ಸೇತ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ಸೇತನು ಹುಟ್ಟಿದ ಮೇಲೆ ಆದಾಮನು 800 ವರ್ಷ ಜೀವಿಸಿದನು. ಆ ಕಾಲಾವಧಿಯಲ್ಲಿ ಅವನು ಇತರ ಗಂಡುಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ಹೀಗೆ ಆದಾಮನು ಒಟ್ಟು 930 ವರ್ಷ ಜೀವಿಸಿ ಮರಣಹೊಂದಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ಸೇತನು 105 ವರ್ಷದವನಾದಾಗ ಎನೋಷ್ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ಎನೋಷನು ಹುಟ್ಟಿದ ಮೇಲೆ ಸೇತನು 807 ವರ್ಷ ಜೀವಿಸಿದನು. ಆ ಕಾಲಾವಧಿಯಲ್ಲಿ ಸೇತನು ಇತರ ಗಂಡುಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ಹೀಗೆ ಸೇತನು ಒಟ್ಟು 912 ವರ್ಷ ಜೀವಿಸಿ ಮರಣಹೊಂದಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ಎನೋಷನು 90 ವರ್ಷದವನಾದಾಗ ಕೇನಾನ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ಕೇನಾನನು ಹುಟ್ಟಿದ ಮೇಲೆ ಎನೋಷನು 815 ವರ್ಷ ಜೀವಿಸಿದನು. ಆ ಕಾಲಾವಧಿಯಲ್ಲಿ ಅವನು ಬೇರೆ ಗಂಡುಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ಹೀಗೆ ಎನೋಷನು ಒಟ್ಟು 905 ವರ್ಷ ಜೀವಿಸಿ ಮರಣಹೊಂದಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ಕೇನಾನನು 70 ವರ್ಷದವನಾದಾಗ ಅವನು ಮಹಲಲೇಲ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ಮಹಲಲೇಲನು ಹುಟ್ಟಿದ ಮೇಲೆ ಕೇನಾನನು 840 ವರ್ಷ ಜೀವಿಸಿದನು. ಆ ಕಾಲಾವಧಿಯಲ್ಲಿ ಕೇನಾನನು ಇತರ ಗಂಡುಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ಹೀಗೆ ಕೇನಾನನು ಒಟ್ಟು 910 ವರ್ಷ ಜೀವಿಸಿ ಮರಣಹೊಂದಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ಮಹಲಲೇಲನು 65 ವರ್ಷದವನಾದಾಗ ಯೆರೆದ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ಯೆರೆದನು ಹುಟ್ಟಿದ ಮೇಲೆ ಮಹಲಲೇಲನು 830 ವರ್ಷ ಜೀವಿಸಿದನು. ಆ ಕಾಲಾವಧಿಯಲ್ಲಿ ಅವನು ಇತರ ಗಂಡುಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ಹೀಗೆ ಮಹಲಲೇಲನು ಒಟ್ಟು 895 ವರ್ಷ ಜೀವಿಸಿ ಮರಣಹೊಂದಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ಯೆರೆದನು 162 ವರ್ಷದವನಾದಾಗ ಹನೋಕ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ಹನೋಕನು ಹುಟ್ಟಿದ ಮೇಲೆ ಯೆರೆದನು 800 ವರ್ಷ ಜೀವಿಸಿದನು. ಆ ಕಾಲಾವಧಿಯಲ್ಲಿ ಅವನು ಇತರ ಗಂಡುಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ಹೀಗೆ ಯೆರೆದನು ಒಟ್ಟು 962 ವರ್ಷ ಜೀವಿಸಿ ಮರಣಹೊಂದಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ಹನೋಕನು 65 ವರ್ಷದವನಾದಾಗ ಮೆತೂಷೆಲಹ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ಮೆತೂಷೆಲಹನು ಹುಟ್ಟಿದ ಮೇಲೆ ಹನೋಕನು ದೇವರ ಅನ್ಯೋನ್ಯತೆಯಲ್ಲಿ 300 ವರ್ಷ ಜೀವಿಸಿದನು. ಆ ಕಾಲಾವಧಿಯಲ್ಲಿ ಅವನು ಇತರ ಗಂಡುಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ಹೀಗೆ ಹನೋಕನು ಒಟ್ಟು 365 ವರ್ಷ ಜೀವಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ಹನೋಕನು ದೇವರ ಅನ್ಯೋನ್ಯತೆಯಲ್ಲಿ ಜೀವಿಸುತ್ತಿದ್ದಾಗ, ದೇವರು ಅವನನ್ನು ತನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡನು. ಅಂದಿನಿಂದ ಅವನು ಕಣ್ಮರೆಯಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ಮೆತೂಷೆಲಹನು 187 ವರ್ಷದವನಾದಾಗ ಲೆಮೆಕ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ಲೆಮೆಕನು ಹುಟ್ಟಿದ ಮೇಲೆ ಮೆತೂಷೆಲಹನು 782 ವರ್ಷ ಜೀವಿಸಿದನು. ಆ ಕಾಲಾವಧಿಯಲ್ಲಿ ಅವನು ಇತರ ಗಂಡುಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ಹೀಗೆ ಮೆತೂಷೆಲಹನು ಒಟ್ಟು 969 ವರ್ಷ ಜೀವಿಸಿ ಮರಣಹೊಂದಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ಲೆಮೆಕನು 182 ವರ್ಷದವನಾದಾಗ ಒಬ್ಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ಲೆಮೆಕನು, “ನಾವು ರೈತರಾಗಿ ಕಷ್ಟಪಟ್ಟು ಕೆಲಸ ಮಾಡುತ್ತೇವೆ, ಯಾಕೆಂದರೆ ದೇವರು ಭೂಮಿಯನ್ನು ಶಪಿಸಿದನು. ಆದರೆ ಈ ಮಗನು ನಮಗೆ ವಿಶ್ರಾಂತಿ ಕೊಡುವನು” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ನೋಹ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ನೋಹನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಲೆಮೆಕನು 595 ವರ್ಷ ಜೀವಿಸಿದನು. ಆ ಕಾಲದಲ್ಲಿ ಅವನು ಇತರ ಗಂಡುಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ಹೀಗೆ ಲೆಮೆಕನು ಒಟ್ಟು 777 ವರ್ಷ ಜೀವಿಸಿ ಮರಣಹೊಂದಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ನೋಹನು 500 ವರ್ಷದವನಾದಾಗ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್ ಎಂಬ ಮೂವರು ಗಂಡುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ಭೂಮಿಯಲ್ಲಿ ಜನಸಂಖ್ಯೆಯು ಹೆಚ್ಚುತ್ತಲೇ ಇತ್ತು. ಅವರಿಗೆ ಸುಂದರವಾದ ಹೆಣ್ಣುಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","4","ಜನರ ದುಷ್ಟತನ ಈ ಹೆಣ್ಣುಮಕ್ಕಳ ಸೌಂದರ್ಯವನ್ನು ಕಂಡ ದೇವಪುತ್ರರು ತಮಗೆ ಬೇಕಾದ ಸ್ತ್ರೀಯರನ್ನು ಆರಿಸಿಕೊಂಡು ಮದುವೆಯಾದರು. ಈ ಸ್ತ್ರೀಯರು ಮಕ್ಕಳನ್ನು ಹೆತ್ತರು. ಆ ಕಾಲದಲ್ಲಿ ಮತ್ತು ಆ ಕಾಲದನಂತರ ನೆಫೇಲಿಯರು ಆ ನಾಡಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದರು. ಅವರು ಪ್ರಸಿದ್ಧರಾದ ಪರಾಕ್ರಮಶಾಲಿಗಳಾಗಿದ್ದರು. ಬಳಿಕ ಯೆಹೋವನು, “ಜನರು ಕೇವಲ ಮಾನವರಷ್ಟೆ; ನನ್ನ ಆತ್ಮವು ಅವರಿಂದ ಯಾವಾಗಲೂ ತೊಂದರೆಗೆ ಗುರಿಯಾಗಕೂಡದು. ಅವರು 120 ವರ್ಷ ಬದುಕುವಂತೆ ಮಾಡುವೆನು” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ಭೂಮಿಯ ಮೇಲಿರುವ ಜನರು ತುಂಬ ದುಷ್ಟರಾಗಿದ್ದು ಯಾವಾಗಲೂ ಕೆಟ್ಟವಿಷಯಗಳ ಬಗ್ಗೆ ಆಲೋಚಿಸುತ್ತಿರುವುದನ್ನು ಯೆಹೋವನು ನೋಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ಭೂಮಿಯ ಮೇಲೆ ತಾನು ಮನುಷ್ಯರನ್ನು ಸೃಷ್ಟಿಸಿದ್ದಕ್ಕಾಗಿ ಯೆಹೋವನು ದುಃಖಪಟ್ಟು ತನ್ನ ಹೃದಯದಲ್ಲಿ ನೊಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ಆದ್ದರಿಂದ ಯೆಹೋವನು, “ನಾನು ಸೃಷ್ಟಿಸಿದ ಜನರನ್ನೆಲ್ಲ ಭೂಮುಖದಿಂದ ನಾಶಮಾಡುವೆನು. ಪ್ರತಿಯೊಬ್ಬ ಮನುಷ್ಯನನ್ನೂ ಪ್ರತಿಯೊಂದು ಪ್ರಾಣಿಯನ್ನೂ ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಪ್ರತಿಯೊಂದು ಜಂತುವನ್ನೂ ಆಕಾಶದಲ್ಲಿ ಹಾರಾಡುವ ಪಕ್ಷಿಗಳನ್ನೂ ನಾಶಮಾಡುವೆನು. ಇವುಗಳನ್ನೆಲ್ಲಾ ಸೃಷ್ಟಿಸಿದ್ದರಿಂದ ನನಗೆ ದುಃಖವಾಯಿತು” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ಆದರೆ ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚಿಕೆಯಾಗುವಂತೆ ನಡೆದುಕೊಂಡ ಒಬ್ಬ ಮನುಷ್ಯನಿದ್ದನು. ಅವನೇ ನೋಹ. ");
INSERT INTO kan2010_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ಇದು ನೋಹನ ಚರಿತ್ರೆ. ಅವನು ತನ್ನ ಜೀವಮಾನವೆಲ್ಲಾ ನೀತಿವಂತನಾಗಿದ್ದನು; ಯಾವಾಗಲೂ ದೇವರನ್ನೇ ಅನುಸರಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ಅವನಿಗೆ ಮೂವರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು: ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್. ");
INSERT INTO kan2010_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","ದೇವರು ಭೂಮಿಯ ಕಡೆಗೆ ನೋಡಿದಾಗ ಜನರಿಂದ ಅದು ಕೆಟ್ಟುಹೋಗಿರುವುದನ್ನು ಕಂಡನು. ಎಲ್ಲೆಲ್ಲೂ ಹಿಂಸೆ ತುಂಬಿಕೊಂಡಿತ್ತು; ಜನರು ದುಷ್ಟರಾಗಿಯೂ ಕ್ರೂರಿಗಳಾಗಿಯೂ ತಮ್ಮ ಜೀವಿತವನ್ನು ಕೆಡಿಸಿಕೊಂಡಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ಆದ್ದರಿಂದ ದೇವರು ನೋಹನಿಗೆ, “ನಾನು ಎಲ್ಲಾ ಜನರಿಗೂ ಅಂತ್ಯವನ್ನು ಬರಮಾಡಬೇಕೆಂದಿದ್ದೇನೆ; ಯಾಕೆಂದರೆ ಅವರು ಕೋಪ, ಹಿಂಸೆಗಳಿಂದ ಭೂಮಿಯನ್ನು ತುಂಬಿಸಿದ್ದಾರೆ. ಆದಕಾರಣ ನಾನು ಎಲ್ಲಾ ಜೀವಿಗಳನ್ನು ನಾಶಮಾಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ನಿನಗೋಸ್ಕರ ಒಂದು ನಾವೆಯನ್ನು ತುರಾಯಿ ಮರದಿಂದ ತಯಾರಿಸು. ಆ ನಾವೆಯಲ್ಲಿ ಕೋಣೆಗಳನ್ನು ಮಾಡು. ಇಡೀ ನಾವೆಗೆ ಒಳಭಾಗದಲ್ಲೂ ಹೊರಭಾಗದಲ್ಲೂ ರಾಳವನ್ನು ಹಚ್ಚು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“ನೀನು ತಯಾರಿಸುವ ನಾವೆಯು ನಾನೂರೈವತ್ತು ಅಡಿ ಉದ್ದವಾಗಿಯೂ ಎಪ್ಪತ್ತೈದು ಅಡಿ ಅಗಲವಾಗಿಯೂ ನಲವತ್ತೈದು ಅಡಿ ಎತ್ತರವಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ಕಿಟಕಿಯ ಮೇಲ್ಛಾವಣಿಗೆ ಹದಿನೆಂಟು ಇಂಚು ಕೆಳಗಿರಲಿ. ನಾವೆಯ ಪಾರ್ಶ್ವದಲ್ಲಿ ಬಾಗಿಲಿರಲಿ. ನಾವೆಯಲ್ಲಿ ಮೇಲಂತಸ್ತು ಮಧ್ಯಂತಸ್ತು ಮತ್ತು ಕೆಳಂತಸ್ತು ಎಂಬ ಮೂರು ಅಂತಸ್ತುಗಳಿರಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“ನಾನು ನಿನಗೆ ಹೇಳುತ್ತಿರುವುದನ್ನು ಅರ್ಥಮಾಡಿಕೊ. ನಾನು ಭೂಮಿಯ ಮೇಲೆ ಮಹಾ ಜಲಪ್ರಳಯವನ್ನು ತರುವೆನು. ಆಕಾಶದ ಕೆಳಗಿರುವ ಎಲ್ಲಾ ಜೀವಿಗಳನ್ನು ನಾಶಮಾಡುವೆನು. ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದೂ ಸಾಯುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ನಾನು ನಿನ್ನೊಂದಿಗೆ ವಿಶೇಷ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಳ್ಳುವೆ. ಅದೇನೆಂದರೆ, ನೀನು ಮತ್ತು ನಿನ್ನ ಹೆಂಡತಿ, ನಿನ್ನ ಗಂಡುಮಕ್ಕಳು ಮತ್ತು ಸೊಸೆಯಂದಿರು ನಾವೆಯೊಳಗೆ ಹೋಗುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ಇದಲ್ಲದೆ, ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಜೀವಿಯಲ್ಲಿ ಒಂದು ಗಂಡನ್ನೂ ಒಂದು ಹೆಣ್ಣನ್ನೂ ನಾವೆಯೊಳಗೆ ಸೇರಿಸಿಕೊ. ನಿನ್ನೊಡನೆ ಅವುಗಳನ್ನು ಜೀವದಿಂದುಳಿಸಿ ಕಾಪಾಡು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಪಕ್ಷಿಗಳಲ್ಲಿ ಎರಡೆರಡೂ ಪ್ರತಿಯೊಂದು ಪ್ರಾಣಿಗಳಲ್ಲಿ ಎರಡೆರಡೂ ಮತ್ತು ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಪ್ರತಿಯೊಂದು ಜಂತುಗಳಲ್ಲಿ ಎರಡೆರಡೂ ತಮ್ಮ ಪ್ರಾಣಗಳನ್ನು ಉಳಿಸಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ನಿನ್ನೊಂದಿಗಿರಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ಭೂಮಿಯ ಮೇಲೆ ದೊರೆಯುವ ಎಲ್ಲಾ ಬಗೆಯ ಆಹಾರವನ್ನು ನಿಮಗಾಗಿಯೂ ಮತ್ತು ಪ್ರಾಣಿಗಳಿಗಾಗಿಯೂ ನಾವೆಯಲ್ಲಿ ತುಂಬಿಸಿಕೊ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ದೇವರು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ನೋಹನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ಆಮೇಲೆ ಯೆಹೋವನು ನೋಹನಿಗೆ, “ಈ ಕಾಲದವರಲ್ಲಿ ನೀನೊಬ್ಬನೇ ನೀತಿವಂತನಾಗಿರುವೆ. ಆದ್ದರಿಂದ ನಿನ್ನ ಕುಟುಂಬದವರೆಲ್ಲರನ್ನು ಕರೆದುಕೊಂಡು ನಾವೆಯೊಳಗೆ ಹೋಗು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ಎಲ್ಲಾ ಬಗೆಯ ಶುದ್ಧಪ್ರಾಣಿಗಳಲ್ಲಿ ಏಳೇಳು ಜೋಡಿಗಳನ್ನು (ಏಳು ಗಂಡನ್ನು ಮತ್ತು ಏಳು ಹೆಣ್ಣನ್ನು) ತೆಗೆದುಕೊ. ಭೂಮಿಯ ಮೇಲಿನ ಇತರ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಒಂದೊಂದು ಜೋಡಿಯನ್ನು (ಒಂದು ಗಂಡನ್ನು ಮತ್ತು ಒಂದು ಹೆಣ್ಣನ್ನು) ತೆಗೆದುಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ಎಲ್ಲಾ ಬಗೆಯ ಪಕ್ಷಿಗಳಲ್ಲಿ ಏಳೇಳು ಜೋಡಿಗಳನ್ನು (ಏಳು ಗಂಡನ್ನು ಮತ್ತು ಏಳು ಹೆಣ್ಣನ್ನು) ತೆಗೆದುಕೊ. ಉಳಿದ ಜೀವಿಗಳೆಲ್ಲ ನಾಶವಾದಮೇಲೆ, ಇವು ತಮ್ಮ ಸಂತತಿಗಳನ್ನು ಮುಂದುವರಿಸಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ಏಳು ದಿನಗಳ ನಂತರ ನಾನು ದೊಡ್ಡ ಮಳೆಯನ್ನು ಭೂಮಿಯ ಮೇಲೆ ಸುರಿಸುವೆನು. ಈ ಮಳೆಯು ನಲವತ್ತು ದಿವಸ ಹಗಲಿರುಳು ಸುರಿಯುವುದು. ನಾನು ನಿರ್ಮಿಸಿದ ಪ್ರತಿಯೊಂದು ಜೀವಿಯನ್ನೂ ನಾನು ಭೂಮಿಯ ಮೇಲಿಂದ ಅಳಿಸಿಬಿಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೆಲ್ಲ ನೋಹನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ಮಳೆಯು ಆರಂಭವಾದಾಗ ನೋಹನ ವಯಸ್ಸು ಆರುನೂರು ವರ್ಷ. ");
INSERT INTO kan2010_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ಜಲಪ್ರಳಯದಿಂದ ತಪ್ಪಿಸಿಕೊಳ್ಳಲು ನೋಹನು ತನ್ನ ಹೆಂಡತಿ, ತನ್ನ ಗಂಡುಮಕ್ಕಳು ಮತ್ತು ಸೊಸೆಯರೊಂದಿಗೆ ನಾವೆಯೊಳಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ಎಲ್ಲಾ ಶುದ್ಧಪ್ರಾಣಿಗಳು, ಭೂಮಿಯ ಮೇಲಿರುವ ಇತರ ಎಲ್ಲಾ ಪ್ರಾಣಿಗಳು, ಪಕ್ಷಿಗಳು ಮತ್ತು ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಪ್ರತಿಯೊಂದೂ ");
INSERT INTO kan2010_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ನೋಹನೊಂದಿಗೆ ನಾವೆಯೊಳಗೆ ಹೋದವು. ದೇವರ ಆಜ್ಞೆಯಂತೆ ಈ ಪ್ರಾಣಿಗಳು ಜೋಡಿಜೋಡಿಯಾಗಿ ನಾವೆಯೊಳಗೆ ಹೋದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ಏಳು ದಿನಗಳ ನಂತರ ಜಲಪ್ರಳಯ ಪ್ರಾರಂಭವಾಯಿತು. ಭೂಮಿಯ ಮೇಲೆ ಮಳೆ ಸುರಿಯತೊಡಗಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","13","ಎರಡನೆ ತಿಂಗಳಿನ ಹದಿನೇಳನೆಯ ದಿನದಂದು ಭೂಮಿಯ ಕೆಳಗಿರುವ ಸಾಗರದ ಸೆಲೆಗಳು ಒಡೆದು ಭೂಮಿಯೊಳಗಿಂದ ನೀರು ಮೇಲೇರತೊಡಗಿತು; ಭೂಮಿಯ ಮೇಲೆ ಭಾರಿಮಳೆ ಸುರಿಯತೊಡಗಿತು. ಆಕಾಶದ ಕಿಟಕಿ ತೆರೆದಿದೆಯೋ ಎಂಬಂತೆ ನಲವತ್ತು ದಿವಸ ಹಗಲಿರುಳು ಮಳೆ ಸುರಿಯಿತು. ಆ ದಿನದಂದು ನೋಹ ಮತ್ತು ಅವನ ಹೆಂಡತಿ, ಅವನ ಗಂಡುಮಕ್ಕಳಾದ ಶೇಮ್, ಹಾಮ್, ಯೆಫೆತ್ ಮತ್ತು ಅವನ ಸೊಸೆಯಂದಿರು ನಾವೆಯೊಳಗೆ ಹೋದರು. ಆಗ ನೋಹನು ಆರುನೂರು ವರ್ಷದ ವೃದ್ಧನಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ಅವರು ನಾವೆಯೊಳಗೆ ಇದ್ದರು. ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಪ್ರಾಣಿಗಳು, ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಪಶುಗಳು, ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಕ್ರಿಮಿಗಳು ಮತ್ತು ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಪಕ್ಷಿಗಳು ನಾವೆಯೊಳಗೆ ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ಉಸಿರಾಡುವ ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಪ್ರಾಣಿಗಳು ತಮ್ಮತಮ್ಮ ಜಾತಿಗನುಸಾರವಾಗಿ ಎರಡೆರಡಾಗಿ ಬಂದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ದೇವರ ಆಜ್ಞೆಯಂತೆ ಈ ಪ್ರಾಣಿಗಳೆಲ್ಲಾ ನಾವೆಯೊಳಗೆ ಪ್ರವೇಶಿಸಿದವು. ಆಗ ಯೆಹೋವನು ನಾವೆಯ ಬಾಗಿಲನ್ನು ಮುಚ್ಚಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ಭೂಮಿಯ ಮೇಲೆ ಜಲಪ್ರಳಯವು ನಲವತ್ತು ದಿನಗಳವರೆಗೆ ಇತ್ತು. ನೀರು ಮೇಲೇರುತ್ತಾ ನಾವೆಯನ್ನು ಎತ್ತಲು ಅದು ನೀರಿನ ಮೇಲೆ ತೇಲತೊಡಗಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ನೀರು ಇನ್ನೂ ಮೇಲೇರತೊಡಗಿದ್ದರಿಂದ ನಾವೆಯೂ ಭೂಮಿಯಿಂದ ಬಹು ಮೇಲೆ ಚಲಿಸತೊಡಗಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ನೀರು ಬಹಳವಾಗಿ ಹೆಚ್ಚಿದ್ದರಿಂದ, ಎತ್ತರವಾದ ಬೆಟ್ಟಗಳು ಸಹ ನೀರಿನಿಂದ ಮುಚ್ಚಿಕೊಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ಬೆಟ್ಟಗಳ ಮೇಲೂ ನೀರು ಹೆಚ್ಚತೊಡಗಿತು. ಅತೀ ಎತ್ತರವಾದ ಬೆಟ್ಟಕ್ಕಿಂತಲೂ ಇಪ್ಪತ್ತು ಅಡಿ ಹೆಚ್ಚಾಗಿ ನೀರು ಆವರಿಸಿಕೊಂಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","ಭೂಮಿಯ ಮೇಲಿದ್ದ ಪ್ರತಿಯೊಂದು ಜೀವಿಯು ಸತ್ತುಹೋಯಿತು. ಎಲ್ಲಾ ಪುರಷರು ಮತ್ತು ಸ್ತ್ರೀಯರು ಸತ್ತುಹೋದರು. ಎಲ್ಲಾ ಪಕ್ಷಿಗಳು, ಪಶುಗಳು, ಪ್ರಾಣಿಗಳು ಮತ್ತು ಪ್ರತಿಯೊಂದು ಬಗೆಯ ಕ್ರಿಮಿಗಳು ಸತ್ತುಹೋದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ಹೀಗೆ ದೇವರು ಭೂಮಿಯ ಮೇಲಿದ್ದ ಪ್ರತಿಯೊಂದು ಜೀವಿಯನ್ನು ನಾಶಗೊಳಿಸಿದನು. ಪ್ರತಿಯೊಬ್ಬ ಮನುಷ್ಯನು ನಾಶವಾದನು; ಪ್ರತಿಯೊಂದು ಪ್ರಾಣಿಯು, ಹರಿದಾಡುವ ಪ್ರತಿಯೊಂದು ಕ್ರಿಮಿಯು ಮತ್ತು ಪ್ರತಿಯೊಂದು ಪಕ್ಷಿಯು ನಾಶವಾದವು. ಉಳಿದುಕೊಂಡವರೆಂದರೆ, ನೋಹ ಮತ್ತು ಅವನ ಕುಟುಂಬದವರು ಹಾಗೂ ಅವನೊಡನೆ ನಾವೆಯೊಳಗಿದ್ದ ಜೀವಿಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ನೂರೈವತ್ತು ದಿನಗಳವರೆಗೆ ನೀರು ಭೂಮಿಯನ್ನು ಆವರಿಸಿಕೊಂಡಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ಆದರೆ ದೇವರು ನೋಹನನ್ನು ಮರೆಯಲಿಲ್ಲ. ದೇವರು ನೋಹನನ್ನು ಮತ್ತು ನಾವೆಯಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಪ್ರಾಣಿಗಳನ್ನು ನೆನಪುಮಾಡಿಕೊಂಡನು. ದೇವರು ಭೂಮಿಯ ಮೇಲೆ ಗಾಳಿಯನ್ನು ಬರಮಾಡಿದನು. ನೀರು ಕಡಿಮೆಯಾಗಲು ಪ್ರಾರಂಭಿಸಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ಆಕಾಶದಿಂದ ಸುರಿಯುತ್ತಿದ್ದ ಮಳೆ ನಿಂತುಹೋಯಿತು. ಆಕಾಶದ ತೂಬುಗಳು ಮುಚ್ಚಿಹೋದವು. ಭೂಸೆಲೆಗಳಿಂದ ಉಕ್ಕುತ್ತಿದ್ದ ನೀರು ಸಹ ನಿಂತುಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","ಭೂಮಿಯನ್ನು ಆವರಿಸಿಕೊಂಡಿದ್ದ ನೀರು ನೂರೈವತ್ತು ದಿನಗಳಾದ ಮೇಲೆ ಕ್ರಮೇಣವಾಗಿ ಕಡಿಮೆಯಾಗುತ್ತಾ ಬಂತು. ಏಳನೆಯ ತಿಂಗಳ ಹದಿನೇಳನೆಯ ದಿನದಲ್ಲಿ ನಾವೆಯು ಅರಾರಾಟ್ ನಾಡಿನಲ್ಲಿದ್ದ ಒಂದು ಬೆಟ್ಟದ ಮೇಲೆ ನಿಂತುಕೊಂಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ನೀರು ಕಡಿಮೆಯಾಗತೊಡಗಿದ್ದರಿಂದ ಹತ್ತನೆಯ ತಿಂಗಳ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಬೆಟ್ಟದ ತುದಿಗಳು ಕಾಣತೊಡಗಿದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ನಲವತ್ತು ದಿನಗಳಾದ ಮೇಲೆ, ನೋಹನು ತಾನು ಮಾಡಿದ್ದ ನಾವೆಯ ಕಿಟಕಿಯನ್ನು ತೆರೆದು ನೋಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ನೋಹನು ಒಂದು ಕಾಗೆಯನ್ನು ಹೊರಕ್ಕೆ ಬಿಟ್ಟನು. ಭೂಮಿಯ ಮೇಲಿನ ನೀರು ಒಣಗುವವರೆಗೆ ಆ ಕಾಗೆಯು ಸ್ಥಳದಿಂದ ಸ್ಥಳಕ್ಕೆ ಹಾರಾಡುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ನೆಲ ಒಣಗಿದೆಯೇ, ತೇವವಾಗಿದೆಯೇ ಎಂದು ತಿಳಿದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ನೋಹನು ಒಂದು ಪಾರಿವಾಳವನ್ನು ಸಹ ಹೊರಕ್ಕೆ ಬಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ನೀರು ಇನ್ನೂ ಇದ್ದಕಾರಣ, ಆ ಪಾರಿವಾಳ ಹಿಂತಿರುಗಿ ಬಂತು. ನೋಹನು ಕೈಚಾಚಿ ಅದನ್ನು ಹಿಡಿದುಕೊಂಡು ನಾವೆಯೊಳಗೆ ಸೇರಿಸಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ಏಳು ದಿನಗಳವರೆಗೆ ನೋಹನು ಕಾದುಕೊಂಡಿದ್ದು ಮತ್ತೆ ಪಾರಿವಾಳವನ್ನು ಹೊರಕ್ಕೆ ಬಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ಆ ಸಾಯಂಕಾಲವೂ ಪಾರಿವಾಳ ನೋಹನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಂತು. ಅದರ ಕೊಕ್ಕಿನಲ್ಲಿ ಆಲೀವ್ ಮರದ ಎಲೆಯಿತ್ತು. ಇದರಿಂದ, ಭೂಮಿಯಲ್ಲಿ ಒಣನೆಲವಿದೆಯೆಂದು ನೋಹನು ತಿಳಿದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ಏಳು ದಿನಗಳ ನಂತರ ನೋಹನು ಮತ್ತೆ ಪಾರಿವಾಳವನ್ನು ಹೊರಕ್ಕೆ ಬಿಟ್ಟನು. ಆದರೆ ಅದು ಈ ಸಲ ಹಿಂತಿರುಗಿ ಬರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ಆದ್ದರಿಂದ ನೋಹನು ನಾವೆಯ ಬಾಗಿಲನ್ನು ತೆರೆದು ಸುತ್ತಲೂ ನೋಡಿದನು. ನೆಲವೆಲ್ಲಾ ಒಣಗಿತ್ತು. ಅಂದು ಮೊದಲನೆಯ ವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳ ಮೊದಲನೆಯ ದಿನವಾಗಿತ್ತು. ಆಗ ನೋಹನಿಗೆ ಆರುನೂರ ಒಂದು ವರ್ಷವಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ಎರಡನೆಯ ತಿಂಗಳ ಇಪ್ಪತ್ತೇಳನೆಯ ದಿನದೊಳಗೆ ನೆಲವೆಲ್ಲಾ ಸಂಪೂರ್ಣವಾಗಿ ಒಣಗಿಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","ಆಮೇಲೆ ದೇವರು ನೋಹನಿಗೆ, “ನೀನು, ನಿನ್ನ ಹೆಂಡತಿ, ನಿನ್ನ ಗಂಡುಮಕ್ಕಳು ಮತ್ತು ನಿನ್ನ ಸೊಸೆಯರೊಂದಿಗೆ ನಾವೆಯಿಂದ ಹೊರಗೆ ಬನ್ನಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ನಿಮ್ಮೊಡನೆ ನಾವೆಯೊಳಗಿದ್ದ ಎಲ್ಲಾ ಜೀವಿಗಳು ಅಂದರೆ ಎಲ್ಲಾ ಪಕ್ಷಿಗಳು, ಪ್ರಾಣಿಗಳು ಮತ್ತು ಭೂಮಿಯ ಮೇಲೆ ಹರಿದಾಡುವ ಪ್ರತಿಯೊಂದೂ ಹೊರಗೆ ಬರಲಿ. ಅವುಗಳ ಸಂತಾನವು ಹೆಚ್ಚೆಚ್ಚಾಗಲಿ; ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಅವು ತುಂಬಿಕೊಳ್ಳಲಿ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ಆದ್ದರಿಂದ ನೋಹನು ತನ್ನ ಹೆಂಡತಿ, ಗಂಡುಮಕ್ಕಳು ಮತ್ತು ಸೊಸೆಯರೊಂದಿಗೆ ನಾವೆಯಿಂದ ಹೊರಗೆ ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ಎಲ್ಲಾ ಪ್ರಾಣಿಗಳು, ಪಕ್ಷಿಗಳು, ಹರಿದಾಡುವ ಜೀವಿಗಳು ನಾವೆಯಿಂದ ಹೊರಬಂದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ಆಮೇಲೆ ನೋಹನು ಯೆಹೋವನಿಗಾಗಿ ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿ ಶುದ್ಧವಾದ ಕೆಲವು ಪಶುಪಕ್ಷಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ದೇವರಿಗೆ ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಸರ್ವಾಂಗಹೋಮ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ಈ ಯಜ್ಞಗಳ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚಿಕೆಯಾಯಿತು. ಆಗ ಯೆಹೋವನು ತನ್ನೊಳಗೆ, “ಜನರನ್ನು ದಂಡಿಸುವುದಕ್ಕಾಗಿ ನಾನು ಇನ್ನೆಂದೂ ಭೂಮಿಯನ್ನು ಶಪಿಸುವುದಿಲ್ಲ. ಜನರು ಚಿಕ್ಕಂದಿನಿಂದಲೇ ಕೆಟ್ಟವರು. ಆದ್ದರಿಂದ ನಾನು ಇನ್ನೆಂದೂ ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಜೀವಿಯನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ; ಮತ್ತೆಂದೂ ನಾನು ಹೀಗೆ ಮಾಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ಭೂಮಿ ಇರುವವರೆಗೆ ಬಿತ್ತನೆಕಾಲ, ಸುಗ್ಗಿಕಾಲ ಯಾವಾಗಲೂ ಇರುತ್ತವೆ. ಹಿಮಕಾಲ, ಬೇಸಿಗೆಕಾಲ, ಚಳಿಗಾಲ, ಹಗಲು ಮತ್ತು ರಾತ್ರಿ ಯಾವಾಗಲೂ ಇದ್ದೇ ಇರುತ್ತವೆ” ಎಂದು ಅಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ದೇವರು ನೋಹನನ್ನೂ ಅವನ ಮಕ್ಕಳನ್ನೂ ಆಶೀರ್ವದಿಸಿ ಅವರಿಗೆ, “ಅನೇಕ ಮಕ್ಕಳನ್ನು ಪಡೆದು ಭೂಮಿಯಲ್ಲೆಲ್ಲಾ ತುಂಬಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಪ್ರಾಣಿಯೂ ನಿಮಗೆ ಹೆದರಿ ಭಯಪಡುವುದು; ಆಕಾಶದಲ್ಲಿ ಹಾರಾಡುವ ಪ್ರತಿಯೊಂದು ಪಕ್ಷಿಯೂ ನಿಮಗೆ ಹೆದರಿ ಭಯಪಡುವುದು; ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಪ್ರತಿಯೊಂದು ಕ್ರಿಮಿಯೂ ಮತ್ತು ಸಮುದ್ರದಲ್ಲಿರುವ ಪ್ರತಿಯೊಂದು ಮೀನೂ ನಿಮಗೆ ಹೆದರಿ ಭಯಪಡುವುದು. ನೀವು ಅವುಗಳಿಗೆಲ್ಲಾ ಒಡೆಯರಾಗಿರುತ್ತೀರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ಮೊದಲು, ನಿಮ್ಮ ಆಹಾರಕ್ಕಾಗಿ ಸಸ್ಯಗಳನ್ನು ಕೊಟ್ಟೆನು. ಈಗ ನಿಮ್ಮ ಆಹಾರಕ್ಕಾಗಿ ಪ್ರತಿಯೊಂದು ಪ್ರಾಣಿಯನ್ನೂ ಕೊಟ್ಟಿದ್ದೇನೆ. ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲವನ್ನೂ ನಾನು ನಿಮಗೋಸ್ಕರ ಕೊಟ್ಟಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ಆದರೆ ನಾನು ನಿಮಗೆ ಆಜ್ಞಾಪಿಸುವುದೇನೆಂದರೆ ರಕ್ತದಿಂದ ಕೂಡಿರುವ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ಯಾವನಾದರೂ ನಿಮ್ಮ ಜೀವಹತ್ಯೆ ಮಾಡಿದರೆ, ನಾನು ಅವನ ಜೀವವನ್ನು ತೆಗೆಯುವೆನು. ಯಾವ ಪ್ರಾಣಿಯಾದರೂ ಮನುಷ್ಯನನ್ನು ಕೊಂದರೆ, ನಾನು ಆ ಪ್ರಾಣಿಯ ಪ್ರಾಣವನ್ನು ತೆಗೆಯುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“ದೇವರು ಮನುಷ್ಯನನ್ನು ತನ್ನ ಹೋಲಿಕೆಗನುಸಾರವಾಗಿ ನಿರ್ಮಿಸಿದನು. ಆದ್ದರಿಂದ ಯಾವನು ಮನುಷ್ಯನ ರಕ್ತವನ್ನು ಸುರಿಸುವನೋ ಅವನ ರಕ್ತವನ್ನು ಮನುಷ್ಯನೇ ಸುರಿಸುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“ನೋಹನೇ, ನಿನಗೂ ನಿನ್ನ ಮಕ್ಕಳಿಗೂ ಅನೇಕ ಮಕ್ಕಳು ಹುಟ್ಟಲಿ. ನೀವು ಅಭಿವೃದ್ಧಿಗೊಂಡು ಭೂಮಿಯಲ್ಲಿ ತುಂಬಿಕೊಳ್ಳಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","9","ಆಮೇಲೆ ದೇವರು ನೋಹನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ, “ನಾನು ನಿಮಗೆ ಮತ್ತು ಮುಂದೆ ಜೀವಿಸುವ ನಿಮ್ಮ ಜನರಿಗೆ ವಾಗ್ದಾನ ಮಾಡುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ನಾವೆಯೊಳಗಿಂದ ಬಂದ ಎಲ್ಲಾ ಪಕ್ಷಿಗಳಿಗೆ, ಎಲ್ಲಾ ಪಶುಗಳಿಗೆ ಮತ್ತು ಪ್ರಾಣಿಗಳಿಗೆ ನಾನು ವಾಗ್ದಾನ ಮಾಡುತ್ತೇನೆ. ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಜೀವಿಗೆ ವಾಗ್ದಾನ ಮಾಡುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ನಾನು ನಿಮಗೆ ಮಾಡುವ ವಾಗ್ದಾನವೇನೆಂದರೆ: ಭೂಮಿಯ ಮೇಲಿದ್ದ ಎಲ್ಲಾ ಜೀವಿಗಳು ಜಲಪ್ರಳಯದಿಂದ ನಾಶವಾದವು. ಆದರೆ ಮತ್ತೆಂದಿಗೂ ಈ ರೀತಿ ಆಗುವುದಿಲ್ಲ. ಜಲಪ್ರಳಯವು ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಜೀವಿಗಳನ್ನು ಇನ್ನೆಂದಿಗೂ ನಾಶಗೊಳಿಸುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ಇದಲ್ಲದೆ ದೇವರು, “ನನ್ನ ವಾಗ್ದಾನಕ್ಕೆ ಸಾಕ್ಷಿಯಾಗಿ ನಾನು ನಿಮಗೊಂದು ಗುರುತನ್ನು ಕೊಡುವೆನು. ನಾನು ನಿಮ್ಮೊಡನೆ ಮತ್ತು ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಜೀವಿಯೊಡನೆ ಒಡಂಬಡಿಕೆ ಮಾಡಿಕೊಂಡಿರುವುದನ್ನು ಈ ಗುರುತು ತೋರಿಸುತ್ತದೆ. ಈ ಗುರುತು ಯಾವಾಗಲೂ ಇರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ನಾನು ಮೋಡಗಳಲ್ಲಿ ಇಟ್ಟಿರುವ ಮುಗಿಲುಬಿಲ್ಲು ನನಗೂ ಭೂಮಿಗೂ ಆಗಿರುವ ಒಡಂಬಡಿಕೆಗೆ ಗುರುತಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ನಾನು ಮೋಡಗಳನ್ನು ಭೂಮಿಯ ಮೇಲೆ ಕವಿಸುವಾಗ, ಮೋಡದಲ್ಲಿ ಮುಗಿಲುಬಿಲ್ಲನ್ನು ಕಾಣುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ನಾನು ಈ ಮುಗಿಲುಬಿಲ್ಲನ್ನು ನೋಡುವಾಗ, ನನಗೂ ನಿಮಗೂ ಮತ್ತು ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಜೀವಿಗಳಿಗೂ ಆಗಿರುವ ಒಡಂಬಡಿಕೆಯನ್ನು ನೆನಪುಮಾಡಿಕೊಳ್ಳುವೆನು. ಜಲಪ್ರಳಯವು ಇನ್ನೆಂದಿಗೂ ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಜೀವಿಗಳನ್ನು ನಾಶಗೊಳಿಸುವುದಿಲ್ಲ ಎಂಬುದೇ ಈ ಒಡಂಬಡಿಕೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ನಾನು ಮೋಡಗಳಲ್ಲಿರುವ ಮುಗಿಲುಬಿಲ್ಲನ್ನು ನೋಡುವಾಗ, ಶಾಶ್ವತವಾದ ಈ ಒಡಂಬಡಿಕೆಯನ್ನು ಜ್ಞಾಪಕ ಮಾಡಿಕೊಳ್ಳುವೆನು. ನನಗೂ ಮತ್ತು ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಜೀವಿಗಳಿಗೂ ಆದ ಒಡಂಬಡಿಕೆಯನ್ನು ನೆನಸಿಕೊಳ್ಳುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ಆದ್ದರಿಂದ ದೇವರು ನೋಹನಿಗೆ, “ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಜೀವಿಗಳೊಡನೆ ನಾನು ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಗೆ ಈ ಮುಗಿಲುಬಿಲ್ಲು ಗುರುತಾಗಿರುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ನೋಹನ ಗಂಡುಮಕ್ಕಳು ನೋಹನೊಡನೆ ನಾವೆಯೊಳಗಿಂದ ಹೊರಬಂದರು. ಅವರ ಹೆಸರುಗಳು: ಶೇಮ್, ಹಾಮ್ ಮತ್ತು ಯೆಫೆತ್ (ಹಾಮನು ಕಾನಾನನ ತಂದೆ.) ");
INSERT INTO kan2010_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ಈ ಮೂವರು ನೋಹನ ಗಂಡುಮಕ್ಕಳು. ಭೂಮಿಯ ಮೇಲಿರುವ ಜನರೆಲ್ಲರಿಗೂ ಇವರೇ ಮೂಲಪುರಷರು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ನೋಹನು ರೈತನಾದನು. ಅವನು ಒಂದು ದ್ರಾಕ್ಷಿತೋಟ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ಒಮ್ಮೆ ಅವನು ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿದು ಮತ್ತೇರಿದ್ದರಿಂದ ತನ್ನ ಗುಡಾರದಲ್ಲಿ ಬೆತ್ತಲೆಯಾಗಿ ಮಲಗಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ಕಾನಾನನ ತಂದೆಯಾದ ಹಾಮನು ತನ್ನ ತಂದೆ ಬೆತ್ತಲೆಯಾಗಿ ಮಲಗಿರುವುದನ್ನು ಕಂಡು ಈ ವಿಷಯವನ್ನು ಗುಡಾರದ ಹೊರಗಿದ್ದ ತನ್ನ ಸಹೋದರರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ಆಗ ಶೇಮನು ಮತ್ತು ಯೆಫೆತನು ಒಂದು ಕಂಬಳಿಯನ್ನು ತಮ್ಮ ಬೆನ್ನಿನ ಮೇಲೆ ಹಾಕಿಕೊಂಡು ಹಿಮ್ಮುಖವಾಗಿ ಗುಡಾರದೊಳಗೆ ಬಂದು ತಮ್ಮ ತಂದೆಗೆ ಹೊದಿಸಿದರು. ಅವರು ಅವನ ಬೆತ್ತಲೆ ದೇಹವನ್ನು ನೋಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ಆಮೇಲೆ ನೋಹನು ಎಚ್ಚರಗೊಂಡನು. ಕಿರಿಮಗನಾದ ಹಾಮನು ಏನು ಮಾಡಿದನು ಎಂದು ಅವನಿಗೆ ತಿಳಿಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ಆದ್ದರಿಂದ ನೋಹನು, “ಕಾನಾನನು ತನ್ನ ಸಹೋದರರಿಗೆಲ್ಲಾ ಕೀಳಾದ ಗುಲಾಮನಾಗಿರಲಿ” ಎಂದು ಶಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ಅಲ್ಲದೆ ನೋಹನು, “ಶೇಮನ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಸ್ತೋತ್ರವಾಗಲಿ! ಕಾನಾನನು ಶೇಮನಿಗೆ ಗುಲಾಮನಾಗಿರಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ದೇವರು ಯೆಫೆತನಿಗೆ ಹೆಚ್ಚು ಭೂಮಿಯನ್ನು ಕೊಡಲಿ. ಶೇಮನ ಗುಡಾರಗಳಲ್ಲಿ ದೇವರು ವಾಸಿಸಲಿ ಮತ್ತು ಕಾನಾನನು ಅವರಿಗೆ ಗುಲಾಮನಾಗಿರಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ಜಲಪ್ರಳಯದ ನಂತರ ನೋಹನು ಮುನ್ನೂರೈವತ್ತು ವರ್ಷ ಬದುಕಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ನೋಹನು ಒಟ್ಟು ಒಂಭೈನೂರೈವತ್ತು ವರ್ಷ ಬದುಕಿ ಸತ್ತನು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ನೋಹನ ಗಂಡುಮಕ್ಕಳು: ಶೇಮ್, ಹಾಮ್ ಮತ್ತು ಯೆಫೆತ್. ಜಲಪ್ರಳಯದ ನಂತರ ಈ ಮೂವರು ಅನೇಕ ಗಂಡುಮಕ್ಕಳನ್ನು ಪಡೆದರು. ಶೇಮನಿಗೂ ಹಾಮನಿಗೂ ಯೆಫೆತನಿಗೂ ಹುಟ್ಟಿದ ಗಂಡುಮಕ್ಕಳು: ");
INSERT INTO kan2010_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ಯೆಫೆತನ ಗಂಡುಮಕ್ಕಳು: ಗೋಮೆರ್, ಮಾಗೋಗ್, ಮಾದಯ್, ಯಾವಾನ್, ತೂಬಲ್, ಮೆಷೆಕ್ ಮತ್ತು ತೀರಾಸ್. ");
INSERT INTO kan2010_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ಗೋಮೆರನ ಗಂಡುಮಕ್ಕಳು: ಅಷ್ಕೆನಸ್, ರೀಫತ್ ಮತ್ತು ತೋಗರ್ಮ. ");
INSERT INTO kan2010_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ಯಾವಾನನ ಗಂಡುಮಕ್ಕಳು: ಎಲೀಷಾ, ತಾರ್ಷೀಸ್, ಕಿತ್ತೀಮ್ ಮತ್ತು ದೋದಾನೀಮ್. ");
INSERT INTO kan2010_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ತೀರ ಪ್ರದೇಶದ ಜನರೆಲ್ಲರು ಯೆಫೆತನ ಮಕ್ಕಳ ಸಂತಾನಕ್ಕೆ ಸೇರಿದವರು. ಅವನ ಪ್ರತಿಯೊಬ್ಬ ಮಗನಿಗೂ ಸ್ವಂತ ಭೂಮಿ ಇತ್ತು. ಅವರೆಲ್ಲರ ಕುಟುಂಬಗಳು ವೃದ್ಧಿಗೊಂಡು ಅನೇಕ ಜನಾಂಗಗಳಾದವು. ಪ್ರತಿಯೊಂದು ಜನಾಂಗಕ್ಕೂ ಸ್ವಂತ ಭಾಷೆಯಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ಹಾಮನ ಗಂಡುಮಕ್ಕಳು: ಕೂಷ್, ಮಿಚ್ರಯಿಮ್, ಪೂತ್ ಮತ್ತು ಕಾನಾನ್. ");
INSERT INTO kan2010_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ಕೂಷನ ಗಂಡುಮಕ್ಕಳು: ಸೆಬಾ, ಹವೀಲ, ಸಬ್ತಾ, ರಗ್ಮ ಮತ್ತು ಸಬ್ತಕಾ. ರಗ್ಮನ ಗಂಡುಮಕ್ಕಳು: ಶೆಬಾ ಮತ್ತು ದೆದಾನ್. ");
INSERT INTO kan2010_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ಕೂಷನಿಗೆ ನಿಮ್ರೋದನೆಂಬ ಗಂಡುಮಗನಿದ್ದನು. ನಿಮ್ರೋದನು ಭೂಲೋಕದಲ್ಲಿ ಮಹಾಬಲಶಾಲಿಯಾಗಿದ್ದು ಮೊದಲನೆಯ ಭೂರಾಜನಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ಯೆಹೋವನ ಮುಂದೆ ಅವನು ಚತುರ ಬೇಟೆಗಾರನಾಗಿದ್ದನು. ಆದ್ದರಿಂದ ಜನರು ಬೇರೆಯವರನ್ನು ಅವನಿಗೆ ಹೋಲಿಸಿ, “ಅವನು ನಿಮ್ರೋದನಂತೆ, ಯೆಹೋವನ ಮುಂದೆ ಚತುರ ಬೇಟೆಗಾರ” ಎಂದು ಹೇಳುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ನಿಮ್ರೋದನ ರಾಜ್ಯವು ಶಿನಾರ್ ದೇಶದಲ್ಲಿರುವ ಬಾಬಿಲೋನಿನಲ್ಲಿ, ಯೆರೆಕ್‌ನಲ್ಲಿ ಮತ್ತು ಅಕ್ಕದ್ ಮತ್ತು ಕಲ್ನೇ ಎಂಬ ಪಟ್ಟಣಗಳಲ್ಲಿ ಪ್ರಾರಂಭವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","ನಿಮ್ರೋದನು ಅಶ್ಶೂರಕ್ಕೂ ಹೋದನು. ಅಶ್ಶೂರದಲ್ಲಿ ನಿನೆವೆ, ರೆಹೋಬೋತೀರ್, ಕೆಲಹ ಮತ್ತು ರೆಸೆನ್ ಎಂಬ ಪಟ್ಟಣಗಳನ್ನು ಕಟ್ಟಿದನು. ರೆಸೆನ್ ಪಟ್ಟಣವು ನಿನೆವೆಗೂ ದೊಡ್ಡಪಟ್ಟಣವಾದ ಕೆಲಹಕ್ಕೂ ಮಧ್ಯದಲ್ಲಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","ಮಿಚ್ರಯಿಮನು ಲೂದ್, ಅನಾಮ್, ಲೆಹಾಬ್, ನಪ್ತಹ್, ಪತ್ರುಸ್, ಕಸ್ಲುಹ್ಯ ಮತ್ತು ಕಪ್ತೋರ್ಯ ಎಂಬವರ ತಂದೆ. ಕಸ್ಲುಹ್ಯರು ಫಿಲಿಷ್ಟಿಯರ ಪಿತೃಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ಕಾನಾನನು ಸೀದೋನನ ತಂದೆ. ಕಾನಾನನ ಮೊದಲನೆಯ ಮಗನೇ ಸೀದೋನ್. ಇವನು ಹಿತ್ತಿಯರ ಮೂಲಪಿತೃ. ");
INSERT INTO kan2010_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","18","ಕಾನಾನನು ಯೆಬೂಸಿಯರಿಗೆ, ಅಮೋರಿಯರಿಗೆ, ಗಿರ್ಗಾಷಿಯರಿಗೆ, ಹಿವ್ವಿಯರಿಗೆ, ಅರ್ಕಿಯರಿಗೆ, ಸೀನಿಯರಿಗೆ, ಅರ್ವಾದಿಯರಿಗೆ, ಚೆಮಾರಿಯರಿಗೆ ಮತ್ತು ಹಮಾತಿಯರಿಗೆ ಮೂಲಪುರುಷನು. ಕಾನಾನನ ಕುಟುಂಬಗಳು ಪ್ರಪಂಚದ ನಾನಾ ಭಾಗಗಳಲ್ಲಿ ಹರಡಿಕೊಂಡಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ಕಾನಾನ್ಯರ ಸೀಮೆಯು ಸೀದೋನಿನ ಉತ್ತರದಿಂದಿಡಿದು ಗೆರಾರಿನ ದಕ್ಷಿಣದವರೆಗೂ, ಗಾಜಾದಿಂದ ಪೂರ್ವದ ಸೊದೋಮ್ ಗೊಮೋರ ಪಟ್ಟಣಗಳವರೆಗೂ, ಅದ್ಮಾ ಮತ್ತು ಚೆಬೋಯಿಮ್‌ಗಳಿಂದ ಲೆಷಾದವರೆಗೆ ವಿಸ್ತರಿಸಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ಅವರೆಲ್ಲರೂ ಹಾಮನ ಸಂತತಿಯವರು. ಆ ಕುಟುಂಬಗಳವರೆಲ್ಲರು ತಮ್ಮ ಸ್ವಂತ ಭಾಷೆಗಳನ್ನು ಮತ್ತು ತಮ್ಮ ಸ್ವಂತ ನಾಡುಗಳನ್ನು ಹೊಂದಿದ್ದರು. ಅವುಗಳೆಲ್ಲ ಪ್ರತ್ಯೇಕ ಜನಾಂಗಗಳಾದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ಶೇಮನು ಯೆಫೆತನ ಅಣ್ಣ. ಶೇಮನ ಸಂತತಿಯವರಲ್ಲಿ ಎಬರನೂ ಒಬ್ಬನು. ಎಬರನು ಹೀಬ್ರೂ ಜನರ ಮೂಲಪಿತೃ. ");
INSERT INTO kan2010_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ಶೇಮನ ಗಂಡುಮಕ್ಕಳು: ಏಲಾಮ್, ಅಶ್ಶೂರ್, ಅರ್ಪಕ್ಷದ್, ಲೂದ್ ಮತ್ತು ಅರಾಮ್. ");
INSERT INTO kan2010_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ಅರಾಮನ ಗಂಡುಮಕ್ಕಳು: ಊಸ್, ಹೂಲ್, ಗೆತೆರ್ ಮತ್ತು ಮಷ್. ");
INSERT INTO kan2010_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ಅರ್ಪಕ್ಷದನು ಶೆಲಹನ ತಂದೆ, ಶೆಲಹನು ಎಬರನ ತಂದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ಎಬರನಿಗೆ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ಮೊದಲನೆಯ ಮಗನು ಹುಟ್ಟಿದ ಕಾಲದಲ್ಲಿ ಭೂಮಿಯ ಜನಾಂಗಗಳು ವಿಂಗಡವಾದದ್ದರಿಂದ ಅವನಿಗೆ ಪೆಲೆಗ್ ಎಂದು ಹೆಸರಿಟ್ಟನು; ಎರಡನೆಯ ಮಗನ ಹೆಸರು ಯೊಕ್ತಾನ್. ");
INSERT INTO kan2010_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ಯೊಕ್ತಾನನ ಗಂಡುಮಕ್ಕಳು: ಅಲ್ಮೋದಾದ್, ಶೆಲೆಪ್, ಹಚರ್ಮಾವೆತ್ ಮತ್ತು ಯೆರಹ, ");
INSERT INTO kan2010_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ಹದೋರಾಮ್, ಊಜಾಲ್, ದಿಕ್ಲಾ. ");
INSERT INTO kan2010_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ಓಬಾಲ್, ಅಬೀಮಯೇಲ್, ಶೆಬಾ, ");
INSERT INTO kan2010_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ಓಫೀರ್, ಹವೀಲ ಮತ್ತು ಯೋಬಾಬ್. ");
INSERT INTO kan2010_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ಇವರೆಲ್ಲರೂ ಮೇಶಾ ಸೀಮೆಯನ್ನು ಮೊದಲುಗೊಂಡು ಪೂರ್ವದ ಬೆಟ್ಟಗುಡ್ಡದ ಪ್ರದೇಶದಲ್ಲಿ ವಾಸಿಸಿದರು. ಸೆಫಾರಿಗೆ ಹೋಗುವ ದಿಕ್ಕಿನಲ್ಲಿ ಮೇಶಾ ಸೀಮೆಯಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ಇವರೆಲ್ಲರೂ ಶೇಮನ ಕುಟುಂಬಕ್ಕೆ ಸೇರಿದವರು. ಇವರೆಲ್ಲರು ಕುಟುಂಬಾನುಸಾರವಾಗಿಯೂ ಭಾಷಾನುಸಾರವಾಗಿಯೂ ದೇಶಾನುಸಾರವಾಗಿಯೂ ಜನಾಂಗಗಳಿಗನುಸಾರವಾಗಿಯೂ ಹರಡಿಕೊಂಡಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ನೋಹನ ಗಂಡುಮಕ್ಕಳಿಂದ ಉಂಟಾದ ವಂಶಗಳವರ ಪಟ್ಟಿಯಿದು. ಅವರು ತಮ್ಮ ಜನಾಂಗಗಳಿಗನುಸಾರವಾಗಿ ಹರಡಿಕೊಂಡಿದ್ದರು. ಜಲಪ್ರಳಯದ ನಂತರ ಭೂಮಿಯಲ್ಲೆಲ್ಲಾ ಹರಡಿಕೊಂಡವರು ಈ ವಂಶಗಳವರೇ. ");
INSERT INTO kan2010_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ಜಲಪ್ರಳಯದ ನಂತರ ಇಡೀ ಪ್ರಪಂಚದ ಜನರು ಒಂದೇ ಭಾಷೆಯನ್ನು ಮಾತಾಡುತ್ತಿದ್ದರು. ಎಲ್ಲಾ ಜನರು ಒಂದೇ ಭಾಷೆಯ ಪದಗಳನ್ನು ಬಳಸುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ಜನರು ಪೂರ್ವದಿಕ್ಕಿನಿಂದ ಪ್ರಯಾಣಮಾಡಿ ಶಿನಾರ್ ಪ್ರದೇಶದಲ್ಲಿ ಬಯಲು ಸೀಮೆಯನ್ನು ಕಂಡು ಅಲ್ಲೇ ಉಳಿದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ಅವರು ಒಬ್ಬರಿಗೊಬ್ಬರು ಮಾತಾಡುತ್ತಾ, “ಬನ್ನಿ, ಒಳ್ಳೆಯ ಸುಟ್ಟ ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡೋಣ” ಎಂದು ನಿರ್ಧರಿಸಿದರು. ಅವರು ತಮ್ಮ ಮನೆಗಳನ್ನು ಕಟ್ಟಲು ಕಲ್ಲುಗಳ ಬದಲಾಗಿ ಇಟ್ಟಿಗೆಗಳನ್ನೂ ಗಾರೆಗೆ ಬದಲಾಗಿ ಕಲ್ಲರಗನ್ನೂ ಉಪಯೋಗಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ಬಳಿಕ ಅವರು, “ನಾವು ನಮಗಾಗಿ ಒಂದು ಪಟ್ಟಣವನ್ನೂ ಆಕಾಶವನ್ನು ಮುಟ್ಟುವಂಥ ಗೋಪುರವನ್ನೂ ಕಟ್ಟಿದರೆ ನಾವು ಪ್ರಸಿದ್ಧರಾಗುತ್ತೇವೆ. ಆಗ ನಾವು ಭೂಮಿಯಲ್ಲೆಲ್ಲಾ ಚದರಿಹೋಗದೆ ಒಂದೇ ಸ್ಥಳದಲ್ಲಿ ವಾಸಿಸಲು ಸಾಧ್ಯವಾಗುತ್ತದೆ” ಎಂದು ಮಾತಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ಯೆಹೋವನು ಪಟ್ಟಣವನ್ನೂ ಗೋಪುರವನ್ನೂ ನೋಡಲು ಇಳಿದುಬಂದನು. ಜನರು ಅವುಗಳನ್ನು ಕಟ್ಟುತ್ತಿರುವುದನ್ನು ಕಂಡು ");
INSERT INTO kan2010_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ಯೆಹೋವನು, “ಈ ಜನರೆಲ್ಲರು ಒಂದೇ ಭಾಷೆಯನ್ನು ಮಾತಾಡುವುದರಿಂದ ಒಟ್ಟಾಗಿ ಸೇರಿಕೊಂಡಿದ್ದಾರೆ. ಪ್ರಾರಂಭದಲ್ಲೇ ಇಂಥ ಕಾರ್ಯವನ್ನು ಮಾಡುತ್ತಿರುವ ಇವರು ಮುಂದೆ ಏನು ಬೇಕಾದರೂ ಮಾಡಲು ಶಕ್ತರಾಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ಆದ್ದರಿಂದ ನಾವು ಕೆಳಗೆ ಹೋಗಿ ಅವರ ಭಾಷೆಯನ್ನು ತಾರುಮಾರು ಮಾಡೋಣ; ಆಗ ಅವರು ಒಬ್ಬರನ್ನೊಬ್ಬರು ಅರ್ಥಮಾಡಿಕೊಳ್ಳುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ಅಂತೆಯೇ ಯೆಹೋವನು ಜನರನ್ನು ಭೂಮಿಯ ಮೇಲೆಲ್ಲಾ ಚದರಿಸಿಬಿಟ್ಟನು. ಆದ್ದರಿಂದ ಆ ಪಟ್ಟಣವನ್ನು ಕಟ್ಟಿ ಪೂರೈಸಲು ಅವರಿಗೆ ಸಾಧ್ಯವಾಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ಯೆಹೋವನು ಇಡೀ ಲೋಕದ ಭಾಷೆಯನ್ನು ತಾರುಮಾರು ಮಾಡಿದ್ದು ಆ ಸ್ಥಳದಲ್ಲೇ. ಆದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಬಾಬಿಲೋನ್ ಎಂದು ಹೆಸರಾಯಿತು. ಹೀಗೆ ಯೆಹೋವನು ಜನರನ್ನು ಆ ಸ್ಥಳದಿಂದ ಭೂಮಿಯಲ್ಲೆಲ್ಲಾ ಚದರಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ಇದು ಶೇಮನ ಕುಟುಂಬ ಚರಿತ್ರೆ. ಜಲಪ್ರಳಯದ ಎರಡು ವರ್ಷಗಳ ನಂತರ ಶೇಮನು 100 ವರ್ಷದವನಾಗಿದ್ದಾಗ ಅರ್ಪಕ್ಷದ್ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ಆ ಬಳಿಕ ಶೇಮನು 500 ವರ್ಷ ಬದುಕಿದ್ದನು. ಅವನು ಇತರ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ಅರ್ಪಕ್ಷದನು 35 ವರ್ಷದವನಾಗಿದ್ದಾಗ ಶೆಲಹ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ಶೆಲಹನು ಜನಿಸಿದ ಮೇಲೆ ಅರ್ಪಕ್ಷದನು 403 ವರ್ಷ ಬದುಕಿದ್ದನು. ಆ ಅವಧಿಯಲ್ಲಿ ಅವನು ಇತರ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ಶೆಲಹನು 30 ವರ್ಷದವನಾಗಿದ್ದಾಗ ಎಬರ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ಎಬರನು ಹುಟ್ಟಿದ ಮೇಲೆ ಶೆಲಹನು 403 ವರ್ಷ ಬದುಕಿದ್ದನು. ಆ ಕಾಲದಲ್ಲಿ ಅವನು ಇತರ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ಎಬರನು 34 ವರ್ಷದವನಾಗಿದ್ದಾಗ ಪೆಲೆಗ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ಪೆಲೆಗನು ಹುಟ್ಟಿದ ಮೇಲೆ ಎಬರನು 430 ವರ್ಷಕ್ಕಿಂತಲೂ ಹೆಚ್ಚು ವರ್ಷ ಬದುಕಿದ್ದನು. ಆ ಕಾಲದಲ್ಲಿ ಅವನು ಬೇರೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ಪೆಲೆಗನು 30 ವರ್ಷದವನಾಗಿದ್ದಾಗ ರೆಗೂವ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ರೆಗೂವನು ಹುಟ್ಟಿದ ಮೇಲೆ ಪೆಲೆಗನು 209 ವರ್ಷ ಬದುಕಿದ್ದನು. ಆ ಕಾಲದಲ್ಲಿ ಅವನು ಬೇರೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ರೆಗೂವನು 32 ವರ್ಷದವನಾಗಿದ್ದಾಗ ಸೆರೂಗ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ಸೆರೂಗನು ಹುಟ್ಟಿದ ಮೇಲೆ ರೆಗೂವನು 207 ವರ್ಷ ಬದುಕಿದ್ದನು. ಆ ಕಾಲದಲ್ಲಿ ಅವನು ಬೇರೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ಸೆರೂಗನು 30 ವರ್ಷದವನಾಗಿದ್ದಾಗ ನಾಹೋರ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ನಾಹೋರನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಸೆರೂಗನು 200 ವರ್ಷ ಬದುಕಿದ್ದನು. ಆ ಕಾಲದಲ್ಲಿ ಅವನು ಬೇರೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ನಾಹೋರನು 29 ವರ್ಷದವನಾಗಿದ್ದಾಗ ತೆರಹ ಎಂಬ ಮಗನನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ತೆರಹನು ಹುಟ್ಟಿದ ಮೇಲೆ ನಾಹೋರನು 119 ವರ್ಷ ಬದುಕಿದ್ದನು. ಆ ಕಾಲದಲ್ಲಿ ಅವನು ಬೇರೆ ಗಂಡು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ತೆರಹನು 70 ವರ್ಷದವನಾಗಿದ್ದಾಗ ಅಬ್ರಾಮ, ನಾಹೋರ, ಹಾರಾನ ಎಂಬ ಗಂಡುಮಕ್ಕಳನ್ನು ಪಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ಇದು ತೆರಹನ ಕುಟುಂಬ ಚರಿತ್ರೆ. ತೆರಹನು ಅಬ್ರಾಮ, ನಾಹೋರ ಮತ್ತು ಹಾರಾನ ಎಂಬವರ ತಂದೆ. ಹಾರಾನನು ಲೋಟನ ತಂದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ಹಾರಾನನು ಬಾಬಿಲೋನಿನ ತನ್ನ ಸ್ವಂತ ಸ್ಥಳವಾದ ಊರ್ ಎಂಬಲ್ಲಿ ಸತ್ತುಹೋದನು. ಹಾರಾನನು ಸತ್ತಾಗ ಅವನ ತಂದೆ ಇನ್ನೂ ಜೀವಂತವಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ಅಬ್ರಾಮ ಮತ್ತು ನಾಹೋರ ಮದುವೆ ಮಾಡಿಕೊಂಡರು. ಅಬ್ರಾಮನ ಹೆಂಡತಿಯ ಹೆಸರು ಸಾರಯಳು. ನಾಹೋರನ ಹೆಂಡತಿಯ ಹೆಸರು ಮಿಲ್ಕಾ. ಈಕೆಯು ಹಾರಾನನ ಮಗಳು. ಹಾರಾನನು ಮಿಲ್ಕಾ ಮತ್ತು ಇಸ್ಕ ಎಂಬವರ ತಂದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ಸಾರಯಳಿಗೆ ಮಕ್ಕಳಿರಲಿಲ್ಲ, ಯಾಕೆಂದರೆ, ಆಕೆ ಬಂಜೆಯಾಗಿದ್ದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ತೆರಹನು ತನ್ನ ಕುಟುಂಬವನ್ನು ಕರೆದುಕೊಂಡು ಬಾಬಿಲೋನಿನ ಊರ್ ಎಂಬ ಸ್ವಂತ ಸ್ಥಳದಿಂದ ಹೊರಟು ಕಾನಾನಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದನು. ತೆರಹನು ತನ್ನ ಮಗನಾದ ಅಬ್ರಾಮನನ್ನೂ ತನ್ನ ಮೊಮ್ಮಗನೂ ಹಾರಾನನಿಗೆ ಮಗನೂ ಆಗಿರುವ ಲೋಟನನ್ನೂ ಮತ್ತು ತನಗೆ ಸೊಸೆಯೂ ಅಬ್ರಾಮನ ಹೆಂಡತಿಯೂ ಆಗಿರುವ ಸಾರಯಳನ್ನೂ ಕರೆದುಕೊಂಡು ಹಾರಾನ್ ಪಟ್ಟಣಕ್ಕೆ ಹೋಗಿ ಅಲ್ಲೇ ವಾಸಿಸಲು ತೀರ್ಮಾನಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ತೆರಹನು ಇನ್ನೂರೈದು ವರ್ಷ ಬದುಕಿ ಹಾರಾನಿನಲ್ಲಿ ಸತ್ತುಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ, “ನಿನ್ನ ದೇಶವನ್ನೂ ನಿನ್ನ ಜನರನ್ನೂ ಬಿಟ್ಟು ಹೊರಡು. ನಿನ್ನ ತಂದೆಯ ಕುಟುಂಬವನ್ನು ಬಿಟ್ಟು ನಾನು ತೋರಿಸುವ ದೇಶಕ್ಕೆ ಹೋಗು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ನಾನು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು; ನಿನ್ನನ್ನು ದೊಡ್ಡ ಜನಾಂಗವನ್ನಾಗಿ ಮಾಡಿ ನಿನ್ನ ಹೆಸರನ್ನು ಪ್ರಖ್ಯಾತಿಪಡಿಸುವೆನು; ನೀನು ಆಶೀರ್ವಾದದಾಯಕನಾಗುವಂತೆ ಮಾಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ನಿನಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡುವವರನ್ನು ಆಶೀರ್ವದಿಸುವೆನು; ನಿನಗೆ ಕೇಡುಮಾಡುವವರನ್ನು ಶಿಕ್ಷಿಸುವೆನು. ನಿನ್ನ ನಿಮಿತ್ತವಾಗಿ ಲೋಕದವರೆಲ್ಲರೂ ಆಶೀರ್ವಾದ ಹೊಂದುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ಆದ್ದರಿಂದ ಅಬ್ರಾಮನು ಯೆಹೋವನಿಗೆ ವಿಧೇಯನಾದನು. ಅವನು ಹಾರಾನ್ ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟು ಹೊರಟನು. ಅವನೊಡನೆ ಲೋಟನು ಸಹ ಹೋದನು. ಆಗ ಅಬ್ರಾಮನಿಗೆ ಎಪ್ಪತ್ತೈದು ವರ್ಷ ವಯಸ್ಸಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ಅಬ್ರಾಮನು ಹಾರಾನ್ ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟು ಒಬ್ಬಂಟಿಗನಾಗಿ ಹೋಗಲಿಲ್ಲ. ಅಬ್ರಾಮನು ತನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಯಳನ್ನೂ ತನ್ನ ತಮ್ಮನ ಮಗನಾದ ಲೋಟನನ್ನೂ ತನ್ನೊಂದಿಗೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ಹಾರಾನ್ ಪಟ್ಟಣದಲ್ಲಿ ತಮಗಿದ್ದ ಸ್ವತ್ತುಗಳನ್ನೆಲ್ಲ ಅವರು ತೆಗೆದುಕೊಂಡು ಹೋದರು. ಅಬ್ರಾಮನು ಹಾರಾನ್ ಪಟ್ಟಣದಲ್ಲಿ ಹೊಂದಿದ್ದ ಸೇವಕರು ಸಹ ಅವನೊಡನೆ ಹೋದರು. ಅಬ್ರಾಮನು ಮತ್ತು ಅವನ ಸಂಗಡಿಗರು ಹಾರಾನ್ ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಪ್ರಯಾಣಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ಅಬ್ರಾಮನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರಿಸಿದನು. ಅವನು ಶೆಕೆಮ್ ನಗರವನ್ನು ತಲುಪಿ, ಅಲ್ಲಿಂದ ಮೋರೆ ಎಂಬ ದೊಡ್ಡ ಓಕ್ ಮರವಿದ್ದ ಸ್ಥಳಕ್ಕೆ ಬಂದನು. ಆ ಕಾಲದಲ್ಲಿ ಕಾನಾನ್ಯರು ಆ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ ಕಾಣಿಸಿಕೊಂಡು, “ನಿನ್ನ ಸಂತತಿಯವರಿಗೆ ಈ ದೇಶವನ್ನು ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ಆ ಸ್ಥಳದಲ್ಲಿ ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ ಕಾಣಿಸಿಕೊಂಡನು. ಆದ್ದರಿಂದ ಅಬ್ರಾಮನು ಯೆಹೋವನನ್ನು ಆರಾಧಿಸುವುದಕ್ಕಾಗಿ ಅಲ್ಲಿ ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ಆಮೇಲೆ ಅಬ್ರಾಮನು ಆ ಸ್ಥಳದಿಂದ ಹೊರಟು ಬೇತೇಲಿಗೆ ಪೂರ್ವದಲ್ಲಿರುವ ಗುಡ್ಡಗಳ ಬಳಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದನು. ಅಲ್ಲಿ ಅಬ್ರಾಮನು ತನ್ನ ಗುಡಾರಗಳನ್ನು ಹಾಕಿದನು. ಪಶ್ಚಿಮಕ್ಕೆ ಬೇತೇಲ್ ಪಟ್ಟಣವಿತ್ತು, ಪೂರ್ವಕ್ಕೆ ಆಯಿ ಪಟ್ಟಣವಿತ್ತು. ಆ ಸ್ಥಳದಲ್ಲಿ ಅವನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿ ಅಲ್ಲಿ ಅವನು ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ತರುವಾಯ ಅವನು ಮತ್ತೆ ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರಿಸಿ ನೆಗೆವ್ ಸ್ಥಳದ ಕಡೆಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ಈ ಕಾಲದಲ್ಲಿ ಭೂಮಿಯು ಒಣಗಿಹೋಗಿತ್ತು; ಮಳೆ ಇರಲಿಲ್ಲ. ಅಲ್ಲಿ ಆಹಾರವನ್ನು ಬೆಳೆಯಲು ಸಾಧ್ಯವಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಅಬ್ರಾಮನು ವಾಸಿಸುವುದಕ್ಕಾಗಿ ಈಜಿಪ್ಟಿಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ತನ್ನ ಹೆಂಡತಿ ಸಾರಯಳು ರೂಪವತಿಯಾಗಿರುವುದು ಅಬ್ರಾಮನಿಗೆ ತಿಳಿದಿತ್ತು. ಆದ್ದರಿಂದ ಈಜಿಪ್ಟಿಗೆ ಹೋಗುವ ಮೊದಲೇ, ಅಬ್ರಾಮನು ಸಾರಯಳಿಗೆ, “ನೀನು ರೂಪವತಿಯೆಂದು ನನಗೆ ಗೊತ್ತಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ಈಜಿಪ್ಟಿನ ಗಂಡಸರು ನಿನ್ನನ್ನು ನೋಡಿ, ‘ಈಕೆ ಇವನ ಹೆಂಡತಿ’ ಎಂದು ತಿಳಿದು ನಿನ್ನನ್ನು ಪಡೆದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ನನ್ನನ್ನು ಕೊಂದು ನಿನ್ನನ್ನು ಜೀವಂತವಾಗಿ ಉಳಿಸುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ಆದ್ದರಿಂದ ನೀನು ನನಗೆ ತಂಗಿಯಾಗಬೇಕೆಂದು ಜನರಿಗೆ ಹೇಳು. ಆಗ ಅವರು ನನ್ನನ್ನು ನಿನ್ನ ಸಹೋದರನೆಂದು ಭಾವಿಸಿ ನನ್ನನ್ನು ಕೊಲ್ಲದೆ ನನಗೆ ದಯೆತೋರುವರು. ಹೀಗೆ ನೀನು ನನ್ನ ಪ್ರಾಣ ಉಳಿಸುವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ಅಂತೆಯೇ ಅಬ್ರಾಮನು ಈಜಿಪ್ಟಿಗೆ ಹೋದನು. ಈಜಿಪ್ಟಿನ ಗಂಡಸರು ಸಾರಯಳನ್ನು ಕಂಡು ಈಕೆ ತುಂಬ ರೂಪವತಿ ಎಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ಈಜಿಪ್ಟಿನ ಕೆಲವು ನಾಯಕರು ಸಹ ಆಕೆಯನ್ನು ಕಂಡರು. ಅವರು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಆಕೆಯ ಅಮೋಘ ಸೌಂದರ್ಯವನ್ನು ತಿಳಿಸಿದರು. ಬಳಿಕ ಆ ನಾಯಕರು ಸಾರಯಳನ್ನು ಫರೋಹನ ಬಳಿಗೆ ಕರೆದೊಯ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ಅಬ್ರಾಮನು ಸಾರಯಳ ಸಹೋದರನೆಂದು ಭಾವಿಸಿ ಫರೋಹನು ಅಬ್ರಾಮನಿಗೆ ದಯೆತೋರಿದನು. ಫರೋಹನು ಅಬ್ರಾಮನಿಗೆ ದನಕುರಿಗಳನ್ನೂ ಕತ್ತೆಗಳನ್ನೂ ಕೊಟ್ಟನು. ಅಲ್ಲದೆ ಅಬ್ರಾಮನಿಗೆ ದಾಸದಾಸಿಯರನ್ನೂ ಒಂಟೆಗಳನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ಫರೋಹನು ಅಬ್ರಾಮನ ಹೆಂಡತಿಯನ್ನು ತೆಗೆದುಕೊಂಡದ್ದರಿಂದ ಯೆಹೋವನು ಫರೋಹನಿಗೂ ಅವನ ಮನೆಯಲ್ಲಿದ್ದವರಿಗೂ ಭಯಂಕರವಾದ ರೋಗಗಳನ್ನು ಬರಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ಆಗ ಫರೋಹನು ಅಬ್ರಾಮನನ್ನು ಕರೆಯಿಸಿ, “ನೀನು ನನಗೆ ತುಂಬ ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡಿರುವೆ; ಸಾರಯಳು ನಿನಗೆ ಹೆಂಡತಿಯಾಗಬೇಕೆಂದು ಯಾಕೆ ತಿಳಿಸಲಿಲ್ಲ? ");
INSERT INTO kan2010_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‘ಈಕೆ ನನಗೆ ತಂಗಿಯಾಗಬೇಕು’ ಎಂದು ಯಾಕೆ ಹೇಳಿದೆ? ನೀನು ಹೀಗೆ ಹೇಳಿದ್ದರಿಂದ ನಾನು ಆಕೆಯನ್ನು ನನ್ನ ಹೆಂಡತಿಯಾಗಲಿಕ್ಕೆ ತೆಗೆದುಕೊಂಡೆ. ಆದರೆ ಈಗ ನಾನು ನಿನ್ನ ಹೆಂಡತಿಯನ್ನು ಮತ್ತೆ ನಿನಗೇ ಕೊಡುತ್ತೇನೆ. ನೀನು ಆಕೆಯನ್ನು ನಿನ್ನೊಂದಿಗೆ ಕರೆದುಕೊಂಡು ಹೊರಟುಹೋಗು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ಆಮೇಲೆ ಫರೋಹನು ತನ್ನ ಜನರಿಗೆ ಅಬ್ರಾಮನನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕಳುಹಿಸಿಕೊಡಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಿದನು. ಆದ್ದರಿಂದ ಅಬ್ರಾಮನು ಮತ್ತು ಅವನ ಹೆಂಡತಿ ಆ ಸ್ಥಳದಿಂದ ಹೊರಟುಹೋದರು; ಅವರು ತಮ್ಮೊಡನೆ ಇದ್ದವುಗಳನ್ನೆಲ್ಲ ತೆಗೆದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ಅಬ್ರಾಮನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಟನು. ಅಬ್ರಾಮನು ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಕರೆದುಕೊಂಡು ತನ್ನವುಗಳನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು ನೆಗೆವ್ ಮೂಲಕ ಪ್ರಯಾಣ ಮಾಡಿದನು. ಲೋಟನು ಸಹ ಅವರೊಡನೆ ಇದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ಆಗ ಅಬ್ರಾಮನು ತುಂಬ ಐಶ್ವರ್ಯವಂತನಾಗಿದ್ದನು. ಅವನಿಗೆ ಅನೇಕ ಪಶುಗಳಿದ್ದವು; ಬಹಳ ಬೆಳ್ಳಿಬಂಗಾರಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ಅಬ್ರಾಮನು ತನ್ನ ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರಿಸಿ ನೆಗೆವ್‌ವನ್ನು ಬಿಟ್ಟು ಬೇತೇಲಿಗೆ ಹಿಂತಿರುಗಿಹೋದನು. ಅವನು ಬೇತೇಲ್‌ ನಗರಕ್ಕೂ ಆಯಿ ನಗರಕ್ಕೂ ಮಧ್ಯದಲ್ಲಿರುವ ಸ್ಥಳಕ್ಕೆ ಹೋದನು. ಅಬ್ರಾಮನು ಮತ್ತು ಅವನ ಕುಟುಂಬದವರು ಇಳಿದುಕೊಂಡಿದ್ದ ಸ್ಥಳವೇ ಇದು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ಅಬ್ರಾಮನು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿದ್ದು ಈ ಸ್ಥಳದಲ್ಲೇ. ಅಬ್ರಾಮನು ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿದ್ದು ಈ ಸ್ಥಳದಲ್ಲೇ. ");
INSERT INTO kan2010_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ಈ ಕಾಲದಲ್ಲಿ ಲೋಟನು ಸಹ ಅಬ್ರಾಮನೊಡನೆ ಪ್ರಯಾಣಮಾಡುತ್ತಿದ್ದನು. ಲೋಟನಿಗೂ ಸಹ ಕುರಿಮಂದೆಗಳೂ ಪಶುಹಿಂಡುಗಳೂ ಗುಡಾರಗಳೂ ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ಅಬ್ರಾಮನಿಗೂ ಲೋಟನಿಗೂ ಬಹಳ ಪಶುಗಳಿದ್ದುದರಿಂದ ಅವುಗಳ ಪೋಷಣೆಗೆ ಆ ಸ್ಥಳವು ಸಾಕಾಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ಅಬ್ರಾಮನ ಮಂದೆಕಾಯುವವರು ಮತ್ತು ಲೋಟನ ಮಂದೆಕಾಯುವವರು ವಾದ ಮಾಡಲಾರಂಭಿಸಿದರು. ಆ ಕಾಲದಲ್ಲಿ ಕಾನಾನ್ಯರು ಮತ್ತು ಪೆರಿಜೀಯರು ಸಹ ಆ ಸ್ಥಳದಲ್ಲಿ ವಾಸವಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ಆದ್ದರಿಂದ ಅಬ್ರಾಮನು ಲೋಟನಿಗೆ, “ನಿನಗೂ ನನಗೂ ಯಾವ ವಾಗ್ವಾದವೂ ಇರಬಾರದು. ನಿನ್ನ ಜನರೂ ನನ್ನ ಜನರೂ ವಾಗ್ವಾದ ಮಾಡಬಾರದು; ನಾವೆಲ್ಲರೂ ಸಹೋದರರಾಗಿದ್ದೇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ನಾವು ಪ್ರತ್ಯೇಕವಾಗೋಣ. ನಿನಗೆ ಬೇಕಾದ ಸ್ಥಳವನ್ನು ನೀನು ಆರಿಸಿಕೊ. ನೀನು ಎಡಗಡೆಗೆ ಹೋಗುವುದಾದರೆ, ನಾನು ಬಲಗಡೆಗೆ ಹೋಗುತ್ತೇನೆ. ನೀನು ಬಲಗಡೆಗೆ ಹೋಗುವುದಾದರೆ, ನಾನು ಎಡಗಡೆಗೆ ಹೋಗುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ಲೋಟನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ ಜೋರ್ಡನ್ ಕಣಿವೆಯೆಲ್ಲಾ ಕಾಣಿಸಿತು. ಅಲ್ಲಿ ಬೇಕಾದಷ್ಟು ನೀರಿರುವುದನ್ನು ಲೋಟನು ನೋಡಿದನು. (ಆ ಕಾಲದಲ್ಲಿ ಸೊದೋಮ್ ಮತ್ತು ಗೊಮೋರ ಪಟ್ಟಣಗಳು ಯೆಹೋವನಿಂದ ನಾಶವಾಗಿರಲಿಲ್ಲ. ಆ ಕಾಲದಲ್ಲಿ ಜೋರ್ಡನ್ ಕಣಿವೆಯು ಚೋಗರ್ ತನಕ ಯೆಹೋವನ ತೋಟದಂತಿತ್ತು. ಅದು ಈಜಿಪ್ಟಿನ ಭೂಮಿಯಂತೆ ಫಲವತ್ತಾಗಿತ್ತು.) ");
INSERT INTO kan2010_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ಆದ್ದರಿಂದ ಲೋಟನು ಜೋರ್ಡನ್ ಕಣಿವೆಯನ್ನೆಲ್ಲಾ ತನಗಾಗಿ ಆರಿಸಿಕೊಂಡನು. ಅವರಿಬ್ಬರೂ ಪ್ರತ್ಯೇಕವಾದರು. ಲೋಟನು ಪೂರ್ವದ ಕಡೆಗೆ ಪ್ರಯಾಣ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ಅಬ್ರಾಮನು ಕಾನಾನ್ ಪ್ರದೇಶದಲ್ಲಿ ಉಳಿದುಕೊಂಡನು. ಲೋಟನು ಕಣಿವೆಯಲ್ಲಿದ್ದ ಪಟ್ಟಣಗಳ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸಿದನು; ದಕ್ಷಿಣದಲ್ಲಿದ್ದ ಸೊದೋಮಿನವರೆಗೂ ಗುಡಾರಗಳನ್ನು ಹಾಕಿಕೊಂಡು ಪಾಳೆಯಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ಸೊದೋಮಿನ ಜನರು ತುಂಬ ಕೆಟ್ಟವರಾಗಿದ್ದರು. ಅವರು ಯಾವಾಗಲೂ ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ಪಾಪಮಾಡುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ಲೋಟನು ಹೊರಟುಹೋದ ಮೇಲೆ ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ, “ಸುತ್ತಲೂ ನೋಡು, ಉತ್ತರದಕ್ಷಿಣಗಳ ಕಡೆಗೂ ಪೂರ್ವಪಶ್ಚಿಮಗಳ ಕಡೆಗೂ ನೋಡು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ನೀನು ನೋಡುವ ಈ ದೇಶವನ್ನೆಲ್ಲಾ ನಿನಗೂ ನಿನ್ನ ನಂತರ ಜೀವಿಸುವ ನಿನ್ನ ಸಂತತಿಯವರಿಗೂ ಕೊಡುತ್ತೇನೆ. ಇದು ಎಂದೆಂದಿಗೂ ನಿನ್ನದಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ನಾನು ನಿನ್ನ ಜನರನ್ನು ಭೂಮಿಯ ಮೇಲಿರುವ ಧೂಳಿನಷ್ಟು ಹೆಚ್ಚಿಸುವೆನು. ಯಾವನಾದರೂ ಭೂಮಿಯ ಮೇಲಿರುವ ಧೂಳಿನ ಕಣಗಳನ್ನು ಲೆಕ್ಕಮಾಡಬಹುದಾದರೆ ನಿನ್ನ ಸಂತತಿಯವರ ಸಂಖ್ಯೆಯು ಅದರಷ್ಟೇ ಇರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ಆದ್ದರಿಂದ ಹೋಗು, ನಿನ್ನ ಭೂಮಿಯಲ್ಲೆಲ್ಲಾ ತಿರುಗಾಡು. ಅದರ ಉದ್ದಗಲಗಳಲ್ಲೆಲ್ಲಾ ತಿರುಗಾಡು; ಯಾಕೆಂದರೆ ನಾನು ಅದನ್ನು ನಿನಗೆ ಕೊಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ಆದ್ದರಿಂದ ಅಬ್ರಾಮನು ತನ್ನ ಗುಡಾರಗಳನ್ನು ಕೀಳಿಸಿ, ದೊಡ್ಡ ಮರಗಳಿರುವ ಮಮ್ರೆಯ ಸಮೀಪಕ್ಕೆ ಹೋಗಿ ವಾಸಿಸತೊಡಗಿದನು. ಇದು ಹೆಬ್ರೋನ್ ನಗರಕ್ಕೆ ಸಮೀಪದಲ್ಲಿತ್ತು. ಆ ಸ್ಥಳದಲ್ಲಿ ಅಬ್ರಾಮನು ಯೆಹೋವನನ್ನು ಆರಾಧಿಸುವುದಕ್ಕಾಗಿ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ಆ ದಿನಗಳಲ್ಲಿ ಅಮ್ರಾಫೆಲನು ಶಿನಾರಿನ ರಾಜನಾಗಿದ್ದನು; ಅರಿಯೋಕನು ಎಲ್ಲಸಾರಿನ ರಾಜನಾಗಿದ್ದನು; ಕೆದೊರ್ಲಗೋಮರನು ಏಲಾಮಿನ ರಾಜನಾಗಿದ್ದನು; ತಿದ್ಗಾಲನು ಗೋಯಿಮದ ರಾಜನಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ಈ ರಾಜರುಗಳೆಲ್ಲ ಸೊದೋಮಿನ ರಾಜನಾದ ಬೆರಗನಿಗೂ ಗೊಮೋರದ ರಾಜನಾದ ಬಿರ್ಶಗನಿಗೂ ಅದ್ಮಾಹದ ರಾಜನಾದ ಶಿನಾಬನಿಗೂ ಚೆಬೋಯೀಮಿನ ರಾಜನಾದ ಶೆಮೇಬರನಿಗೂ ಚೋಗರ್ ಎಂಬ ಬೇಲಗಿನ ರಾಜನಿಗೂ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ಈ ರಾಜರುಗಳೆಲ್ಲ ಸಿದ್ದೀಮ್ ಕಣಿವೆಯಲ್ಲಿ ತಮ್ಮ ಸೈನ್ಯಗಳನ್ನು ಒಟ್ಟಿಗೆ ಸೇರಿಸಿದರು. (ಸಿದ್ದೀಮ್ ಕಣಿವೆಯು ಈಗ ಉಪ್ಪುಸಮುದ್ರವಾಗಿದೆ). ");
INSERT INTO kan2010_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ಈ ರಾಜರುಗಳು ಕೆದೊರ್ಲಗೋಮರನ ಅಧೀನದಲ್ಲಿ ಹನ್ನೆರಡು ವರ್ಷವಿದ್ದರು. ಆದರೆ ಹದಿಮೂರನೆಯ ವರ್ಷದಲ್ಲಿ, ಅವರೆಲ್ಲರೂ ಅವನಿಗೆ ವಿರೋಧವಾಗಿ ದಂಗೆ ಎದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ಆದ್ದರಿಂದ ಹದಿನಾಲ್ಕನೆಯ ವರ್ಷದಲ್ಲಿ, ರಾಜನಾದ ಕೆದೊರ್ಲಗೋಮರನು ಮತ್ತು ಅವನೊಡನಿದ್ದ ರಾಜರುಗಳು ಅವರ ವಿರೋಧವಾಗಿ ಯುದ್ಧಮಾಡಲು ಬಂದರು. ಕೆದೊರ್ಲಗೋಮರನು ಮತ್ತು ಅವನೊಡನಿದ್ದ ರಾಜರುಗಳು ಅಷ್ಟರೋತ್-ಕರ್ನಯಿಮಿನಲ್ಲಿದ್ದ ರೆಫಾಯರನ್ನೂ ಹಾಮಿನಲ್ಲಿದ್ದ ಜೂಜ್ಯರನ್ನೂ ಶಾವೆಕೆರ್ಯಾತಯಿಮಿನಲ್ಲಿದ್ದ ಏಮಿಯರನ್ನೂ ಸೋಲಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ಇದಲ್ಲದೆ ಅವರು ಹೋರಿಯರನ್ನು ಬೆಟ್ಟದ ಸೀಮೆಯಿಂದ ಮರುಭೂಮಿಯ ಸಮೀಪದಲ್ಲಿರುವ ಎಲ್ಪಾರಾನಿನವರೆಗೂ ಹಿಂದಟ್ಟಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ಆ ಬಳಿಕ ರಾಜ ಕೆದೊರ್ಲಗೋಮರನು ಉತ್ತರದ ಕಡೆಗೆ ತಿರುಗಿ ಕಾದೇಶ್ ಎನ್ನುವ ಎನ್ಮಿಷ್ಪಾಟಿಗೆ ಬಂದು ಎಲ್ಲಾ ಅಮಾಲೇಕ್ಯರನ್ನು ಸೋಲಿಸಿದನು. ಇದಲ್ಲದೆ ಅವನು ಹಚಚೋನ್‌ತಾಮರಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಅಮೋರಿಯರನ್ನು ಸೋಲಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ಆ ಕಾಲದಲ್ಲಿ, ಸೊದೋಮಿನ ರಾಜನೂ ಗೊಮೋರದ ರಾಜನೂ ಅದ್ಮಾಹದ ರಾಜನೂ ಚೆಬೋಯೀಮಿನ ರಾಜನೂ ಬೇಲಗದ, ಅಂದರೆ ಚೋಗರದ ರಾಜನೂ ಒಟ್ಟಾಗಿ ಸೇರಿಕೊಂಡು ತಮ್ಮ ಶತ್ರುಗಳ ವಿರುದ್ಧವಾಗಿ ದಂಡೆತ್ತಿಕೊಂಡು ಸಿದ್ದೀಮ್ ಕಣಿವೆಗೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ಅವರು ಏಲಾಮಿನ ರಾಜ ಕೆದೊರ್ಲಗೋಮರನಿಗೂ ಗೋಯಿಮದ ರಾಜ ತಿದ್ಗಾಲನಿಗೂ ಶಿನಾರಿನ ರಾಜ ಅಮ್ರಾಫೆಲನಿಗೂ, ಎಲ್ಲಸಾರಿನ ರಾಜ ಅರಿಯೋಕನಿಗೂ ವಿರುದ್ಧವಾಗಿ ಹೋರಾಡಿದರು. ಹೀಗೆ ನಾಲ್ಕು ಮಂದಿ ರಾಜರು ಐದು ಮಂದಿ ರಾಜರ ವಿರುದ್ಧವಾಗಿ ಹೋರಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ಸಿದ್ದೀಮ್ ಕಣಿವೆಯಲ್ಲಿ ಕಲ್ಲರಗಿನ ಕೆಸರುಕುಣಿಗಳು ಬಹಳಷ್ಟಿದ್ದವು. ಸೊದೋಮ್ ಮತ್ತು ಗೊಮೋರಗಳ ರಾಜರುಗಳು ಮತ್ತು ಅವರ ಸೈನ್ಯಗಳವರು ಓಡಿಹೋಗುವಾಗ ಈ ಕುಣಿಗಳಲ್ಲಿ ಬಿದ್ದುಹೋದರು; ಉಳಿದವರು ಬೆಟ್ಟಗಳಿಗೆ ಓಡಿಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ಗೆದ್ದವರು ಸೊದೋಮ್ ಮತ್ತು ಗೊಮೋರಗಳ ಜನರು ಹೊಂದಿದ್ದ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ತೆಗೆದುಕೊಂಡರು. ಅವರು ಅವರೆಲ್ಲರ ಆಹಾರವನ್ನೂ ಬಟ್ಟೆಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ಅಬ್ರಾಮನ ಸಹೋದರನಾದ ಲೋಟನು ಸೊದೋಮಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ಶತ್ರುಗಳು ಅವನನ್ನು ಸೆರೆಹಿಡಿದು, ಅವನ ಸ್ವತ್ತುಗಳನ್ನೆಲ್ಲ ದೋಚಿಕೊಂಡು ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ತಪ್ಪಿಸಿಕೊಂಡ ಒಬ್ಬನು ಇಬ್ರಿಯನಾದ ಅಬ್ರಾಮನ ಬಳಿಗೆ ಹೋಗಿ ನಡೆದ ವಿಷಯವನ್ನೆಲ್ಲಾ ತಿಳಿಸಿದನು. ಅಬ್ರಾಮನು ಅಮೋರಿಯನಾದ ಮಮ್ರೆಯನ ತೋಪಿನ ಬಳಿಯಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ಮಮ್ರೆ, ಎಷ್ಕೋಲ ಮತ್ತು ಆನೇರ್ ಒಬ್ಬರಿಗೊಬ್ಬರು ಸಹಾಯಮಾಡಲು ಒಂದು ಒಪ್ಪಂದವನ್ನು ಮಾಡಿಕೊಂಡಿದ್ದರು. ಅಲ್ಲದೆ ಅಬ್ರಾಮನಿಗೂ ಸಹಾಯಮಾಡುವುದಾಗಿ ಒಂದು ಒಪ್ಪಂದಕ್ಕೆ ಸಹಿ ಮಾಡಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ಲೋಟನು ಸೆರೆಯಾಳಾಗಿರುವುದು ಅಬ್ರಾಮನಿಗೆ ತಿಳಿಯಿತು. ಆದ್ದರಿಂದ ಅಬ್ರಾಮನು ತನ್ನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದ ಗಂಡಾಳುಗಳನ್ನೆಲ್ಲ ಒಟ್ಟಾಗಿ ಸೇರಿಸಿದನು. ಅವರಲ್ಲಿ ಮುನ್ನೂರ ಹದಿನೆಂಟು ಮಂದಿ ತರಬೇತಿ ಹೊಂದಿದ್ದ ಸೈನಿಕರಾಗಿದ್ದರು. ಅಬ್ರಾಮನು ಅವರೊಡನೆ ಹೊರಟು ಶತ್ರುಗಳನ್ನು ದಾನ್ ಊರಿನವರೆಗೂ ಹಿಂದಟ್ಟಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ಆ ರಾತ್ರಿ ಅವನು ಮತ್ತು ಅವನ ಸೇವಕರು ಹಠಾತ್ತನೆ ಶತ್ರುಗಳನ್ನು ಎದುರಿಸಿ ಸೋಲಿಸಿದರು; ದಮಸ್ಕಕ್ಕೆ ಉತ್ತರದಲ್ಲಿರುವ ಹೋಬಾದವರೆಗೂ ಹಿಂದಟ್ಟಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ಆಮೇಲೆ ಶತ್ರುಗಳು ಅಪಹರಿಸಿದ್ದ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ಮತ್ತು ಲೋಟನ ಆಸ್ತಿಯನ್ನು ಅಬ್ರಾಮನು ತೆಗೆದುಕೊಂಡು ಲೋಟನೊಡನೆ ಬಂದನು. ಅಲ್ಲದೆ ಸೆರೆಹಿಡಿಯಲ್ಪಟ್ಟಿದ್ದ ಸ್ತ್ರೀಯರನ್ನು ಮತ್ತು ಇತರ ಜನರನ್ನು ಹಿಂದಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ಅಬ್ರಾಮನು ಕೆದೊರ್ಲಗೋಮರನನ್ನೂ ಮತ್ತು ಅವನೊಡನಿದ್ದ ರಾಜರುಗಳನ್ನೂ ಸೋಲಿಸಿದ ಮೇಲೆ ತನ್ನ ಮನೆಗೆ ಹಿಂತಿರುಗಿದನು. ಆಗ ಸೊದೋಮಿನ ರಾಜನು ಅಬ್ರಾಮನನ್ನು ಭೇಟಿಯಾಗಲು ಶಾವೆ ಕಣಿವೆಗೆ ಹೋದನು. (ಈಗ ಇದಕ್ಕೆ ರಾಜನ ಕಣಿವೆ ಎಂದು ಕರೆಯುತ್ತಾರೆ.) ");
INSERT INTO kan2010_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ಸಾಲೇಮಿನ ರಾಜನಾದ ಮೆಲ್ಕೀಚೆದೆಕನು ಸಹ ಅಬ್ರಾಮನನ್ನು ಭೇಟಿಯಾಗಲು ಹೋದನು. ಮಹೋನ್ನತನಾದ ದೇವರ ಯಾಜಕನಾಗಿದ್ದ ಅವನು ರೊಟ್ಟಿಯನ್ನೂ ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಂದು, ");
INSERT INTO kan2010_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ಅಬ್ರಾಮನನ್ನು ಹೀಗೆ ಆಶೀರ್ವದಿಸಿದನು: “ಅಬ್ರಾಮನೇ, ಮಹೋನ್ನತನಾದ ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಲಿ. ಆಕಾಶವನ್ನೂ ಭೂಮಿಯನ್ನೂ ಸೃಷ್ಟಿಸಿದಾತನು ಆತನೇ. ");
INSERT INTO kan2010_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ನಿನ್ನ ಶತ್ರುಗಳನ್ನು ಸೋಲಿಸಲು ನಿನಗೆ ಸಹಾಯ ಮಾಡಿದ ಮಹೋನ್ನತನಾದ ದೇವರಿಗೆ ಕೊಂಡಾಟವಾಗಲಿ.” ಅಬ್ರಾಮನು ಯುದ್ಧದಿಂದ ತಂದಿದ್ದ ಎಲ್ಲಾ ವಸ್ತುಗಳಲ್ಲಿ ಹತ್ತನೆಯ ಒಂದು ಭಾಗವನ್ನು ಮೆಲ್ಕೀಚೆದೆಕನಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ಬಳಿಕ ಸೊದೋಮಿನ ರಾಜನು ಅಬ್ರಾಮನಿಗೆ, “ಈ ವಸ್ತುಗಳನ್ನೆಲ್ಲ ನೀನೇ ಇಟ್ಟುಕೊ. ಶತ್ರುಗಳು ವಶಪಡಿಸಿಕೊಂಡಿರುವ ನನ್ನ ಜನರನ್ನು ಮಾತ್ರ ನನಗೆ ಕೊಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ಆದರೆ ಅಬ್ರಾಮನು ಅವನಿಗೆ, “ಆಕಾಶವನ್ನೂ ಭೂಮಿಯನ್ನೂ ಸೃಷ್ಟಿಸಿದ ಮಹೋನ್ನತನಾಗಿರುವ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಪ್ರಮಾಣಮಾಡಿ ಹೇಳುವುದೇನೆಂದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ನಿನ್ನದಾಗಿರುವ ಯಾವುದನ್ನೂ ನಾನು ಇಟ್ಟುಕೊಳ್ಳುವುದಿಲ್ಲ; ಅದು ದಾರವಾಗಿದ್ದರೂ, ಪಾದರಕ್ಷೆಯ ಬಾರಾಗಿದ್ದರೂ, ನಾನಿಟ್ಟುಕೊಳ್ಳುವುದಿಲ್ಲ. ‘ನಾನು ಅಬ್ರಾಮನನ್ನು ಐಶ್ವರ್ಯವಂತನನ್ನಾಗಿ ಮಾಡಿದೆ’ ಎಂದು ನೀನು ಹೇಳಿಕೊಳ್ಳುವುದು ನನಗೆ ಬೇಕಾಗಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ನನ್ನ ಯೌವನಸ್ಥರು ತಿಂದ ಆಹಾರದ ಹೊರತು ಬೇರೆ ಯಾವುದನ್ನೂ ನಾನು ಸ್ವೀಕರಿಸುವುದಿಲ್ಲ. ಆದರೆ ಬೇರೆ ಜನರಿಗೆ ಅವರ ಪಾಲನ್ನು ಕೊಡು. ನಾವು ಯುದ್ಧದಲ್ಲಿ ಗೆದ್ದುತಂದ ವಸ್ತುಗಳನ್ನು ತೆಗೆದುಕೊ; ಆನೇರ್, ಎಷ್ಕೋಲ ಮತ್ತು ಮಮ್ರೆಯರಿಗೆ ಅವರ ಪಾಲನ್ನು ಕೊಡು. ಈ ಜನರು ಯುದ್ಧದಲ್ಲಿ ನನಗೆ ಸಹಾಯ ಮಾಡಿದರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ಈ ಸಂಗತಿಗಳಾದ ಮೇಲೆ, ಅಬ್ರಾಮನಿಗೆ ದರ್ಶನದಲ್ಲಿ ಯೆಹೋವನ ಸಂದೇಶ ಬಂದಿತು. ದೇವರು ಅವನಿಗೆ, “ಅಬ್ರಾಮನೇ ಭಯಪಡಬೇಡ; ನಾನೇ ನಿನಗೆ ಗುರಾಣಿಯಾಗಿದ್ದೇನೆ. ನಾನು ನಿನಗೆ ದೊಡ್ಡ ಪ್ರತಿಫಲವನ್ನು ಕೊಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ಅದಕ್ಕೆ ಅಬ್ರಾಮನು, “ದೇವರಾದ ಯೆಹೋವನೇ, ನೀನು ನನಗೆ ಏನೇ ಕೊಟ್ಟರೂ ನನಗೆ ಸಂತೋಷವಾಗುವುದಿಲ್ಲ. ಯಾಕೆಂದರೆ, ನನಗೆ ಮಗನೇ ಇಲ್ಲ. ಆದ್ದರಿಂದ ನಾನು ಸತ್ತಮೇಲೆ ನನ್ನ ಆಸ್ತಿಯೆಲ್ಲ ನನ್ನ ಸೇವಕನಾದ ದಮಸ್ಕದ ಎಲೀಯೆಜರನ ಪಾಲಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ಮತ್ತೆ ಅಬ್ರಾಮನು, “ನೀನು ನನಗೆ ಮಗನನ್ನೇ ಕೊಟ್ಟಿಲ್ಲ. ಆದ್ದರಿಂದ ನನ್ನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದ ಸೇವಕನೊಬ್ಬನು ನನಗಿರುವುದನ್ನೆಲ್ಲ ಪಡೆದುಕೊಳ್ಳುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ಆಗ ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ, “ನಿನ್ನ ಆಸ್ತಿಯನ್ನೆಲ್ಲ ಪಡೆದುಕೊಳ್ಳುವವನು ನಿನ್ನ ಸೇವಕನಲ್ಲ. ನೀನೇ ಮಗನನ್ನು ಪಡೆಯುವೆ; ನಿನ್ನ ಮಗನೇ ನಿನ್ನ ಆಸ್ತಿಯನ್ನೆಲ್ಲಾ ಪಡೆಯುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ನಂತರ ದೇವರು ಅಬ್ರಾಮನನ್ನು ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದು ಅವನಿಗೆ, “ಆಕಾಶದ ಕಡೆಗೆ ಕಣ್ಣೆತ್ತಿ ನಕ್ಷತ್ರಗಳನ್ನು ನೋಡು. ನೀನು ಲೆಕ್ಕ ಮಾಡಲಾರದಷ್ಟು ನಕ್ಷತ್ರಗಳಿವೆ. ಮುಂದಿನ ಕಾಲದಲ್ಲಿ ನಿನ್ನ ಕುಟುಂಬವು ಅದೇ ರೀತಿಯಲ್ಲಿರುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ಅಬ್ರಾಮನು ಯೆಹೋವನನ್ನು ನಂಬಿದನು. ಆ ನಂಬಿಕೆಯ ನಿಮಿತ್ತವೇ ಯೆಹೋವನು ಅಬ್ರಾಮನನ್ನು ನೀತಿವಂತನೆಂದು ಪರಿಗಣಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ಆತನು ಅಬ್ರಾಮನಿಗೆ, “ಯೆಹೋವನಾದ ನಾನು ನಿನ್ನನ್ನು ಕಲ್ದೀಯರ ಊರ್ ಪಟ್ಟಣದಿಂದ ಬರಮಾಡಿದೆನು. ನಿನಗೆ ಈ ದೇಶವನ್ನು ಕೊಡಬೇಕೆಂತಲೂ ನೀನು ಈ ದೇಶವನ್ನು ಹೊಂದಿಕೊಳ್ಳಬೇಕೆಂತಲೂ ನಾನು ನಿನ್ನನ್ನು ಬರಮಾಡಿದೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ಅದಕ್ಕೆ ಅಬ್ರಾಮನು, “ಯೆಹೋವನೇ, ನನ್ನ ಒಡೆಯನೇ, ನನಗೆ ಈ ದೇಶವು ದೊರೆಯುತ್ತದೆಯೆಂದು ಖಚಿತಪಡಿಸಿಕೊಳ್ಳುವುದು ಹೇಗೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ದೇವರು ಅಬ್ರಾಮನಿಗೆ, “ನಾವು ಒಂದು ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಳ್ಳೋಣ. ಮೂರು ವರ್ಷದ ಒಂದು ಹಸುವನ್ನೂ ಮೂರು ವರ್ಷದ ಒಂದು ಆಡನ್ನೂ ಮತ್ತು ಮೂರು ವರ್ಷದ ಒಂದು ಟಗರನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಾ. ಇದಲ್ಲದೆ ಒಂದು ಬೆಳವಕ್ಕಿಯನ್ನೂ ಒಂದು ಪಾರಿವಾಳವನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಾ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ಅಬ್ರಾಮನು ದೇವರಿಗೋಸ್ಕರ ಅವುಗಳನ್ನೆಲ್ಲ ತೆಗೆದುಕೊಂಡು ಬಂದನು. ಅಬ್ರಾಮನು ಅವುಗಳನ್ನು ಕತ್ತರಿಸಿ ಎರಡೆರಡು ಹೋಳು ಮಾಡಿದನು. ಆಮೇಲೆ ಅಬ್ರಾಮನು ತುಂಡಿಗೆ ತುಂಡನ್ನು ಎದುರಾಗಿಟ್ಟನು. ಅಬ್ರಾಮನು ಪಕ್ಷಿಗಳನ್ನು ಮಾತ್ರ ಎರಡೆರಡು ಹೋಳು ಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ಸ್ವಲ್ಪ ಸಮಯದ ನಂತರ, ದೊಡ್ಡ ಪಕ್ಷಿಗಳು ಆ ಪ್ರಾಣಿಗಳ ಮಾಂಸವನ್ನು ತಿನ್ನಲು ಹಾರಿ ಬಂದವು. ಆದರೆ ಅಬ್ರಾಮನು ಅವುಗಳನ್ನು ಓಡಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ಸಾಯಂಕಾಲವಾಯಿತು, ಸೂರ್ಯ ಮುಳುಗತೊಡಗಿದಾಗ ಅಬ್ರಾಮನಿಗೆ ಗಾಢ ನಿದ್ರೆ ಬಂದಿತು. ಅವನು ನಿದ್ರೆ ಮಾಡುತ್ತಿರುವಾಗ ಕಾರ್ಗತ್ತಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ಆಗ ಯೆಹೋವನು ಅಬ್ರಾಮನಿಗೆ, “ನಿನಗೆ ಈ ವಿಷಯಗಳು ತಿಳಿದಿರಬೇಕು. ನಿನ್ನ ಸಂತತಿಯವರು ಪರದೇಶಿಯರಾಗಿ ತಮ್ಮದಲ್ಲದ ದೇಶದಲ್ಲಿ ವಾಸಮಾಡುವರು. ಅಲ್ಲಿನ ಜನರು ಅವರನ್ನು ಗುಲಾಮರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳುವರು. ಅಲ್ಲಿ ಅವರು ನಾನೂರು ವರ್ಷಗಳವರೆಗೆ ಬಾಧೆಪಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ಆದರೆ ನಾನೂರು ವರ್ಷಗಳಾದ ಮೇಲೆ ಅವರ ಮೇಲೆ ದೊರೆತನ ಮಾಡಿದ ಆ ದೇಶವನ್ನು ನಾನು ದಂಡಿಸುವೆನು; ನಿನ್ನ ಜನರು ಆ ದೇಶವನ್ನು ಬಿಟ್ಟು ಹೊರಡುವರು. ನಿನ್ನ ಜನರು ಅದನ್ನು ಬಿಡುವಾಗ ತಮ್ಮೊಡನೆ ಸಂಪತ್ತುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","“ನೀನು ತುಂಬಾ ಮುದುಕನಾಗುವ ತನಕ ಜೀವಿಸಿ ಸಮಾಧಾನದಿಂದ ಸಾಯುವೆ; ನಿನ್ನನ್ನು ನಿನ್ನ ಕುಟುಂಬದವರೊಡನೆ ಸಮಾಧಿ ಮಾಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ನಾಲ್ಕು ತಲೆಮಾರುಗಳ ನಂತರ ನಿನ್ನ ಜನರು ಈ ನಾಡಿಗೆ ಹಿಂತಿರುಗುವರು. ಆ ಕಾಲದಲ್ಲಿ ನಿನ್ನ ಜನರು ಅಮೋರಿಯರನ್ನು ಸೋಲಿಸುವರು. ಇಲ್ಲಿ ವಾಸಿಸುತ್ತಿರುವ ಅಮೋರಿಯರನ್ನು ನಿನ್ನ ಜನರ ಮೂಲಕ ನಾನೇ ಶಿಕ್ಷಿಸುವೆನು. ಇದು ಮುಂದೆ ನಡೆಯುವ ಸಂಗತಿ. ಯಾಕೆಂದರೆ ಆ ಸಮಯದಲ್ಲಿ ಅಮೋರಿಯರು ಅಂಥ ಶಿಕ್ಷೆ ಅನುಭವಿಸುವಷ್ಟು ಕೆಟ್ಟವರಾಗಿರಲಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ಸೂರ್ಯನು ಮುಳುಗಿದ ಮೇಲೆ ತುಂಬ ಕತ್ತಲಾಯಿತು. ಕಡಿದುಹಾಕಿದ್ದ ಪ್ರತಿಯೊಂದು ಪ್ರಾಣಿಗಳ ದೇಹದ ಎರಡೆರಡು ಹೋಳುಗಳು ಇನ್ನೂ ನೆಲದ ಮೇಲೆ ಇದ್ದವು. ಆ ಸಮಯದಲ್ಲಿ ಇದ್ದಕ್ಕಿದ್ದಂತೆ ಹೊಗೆ ಮತ್ತು ಬೆಂಕಿಗಳಿಂದ ಕೂಡಿದ ದೀವಿಟಿಗೆಯು ಈ ತುಂಡುಗಳ ನಡುವೆ ಹಾದುಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ಆದ್ದರಿಂದ ಅಂದು ಯೆಹೋವನು ಒಂದು ವಾಗ್ದಾನವನ್ನು ಮಾಡಿ ಅಬ್ರಾಮನೊಡನೆ ಒಂದು ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡನು. ಯೆಹೋವನು ಅವನಿಗೆ, “ನಾನು ನಿನ್ನ ಸಂತತಿಯವರಿಗೆ ಈ ನಾಡನ್ನು ಕೊಡುವೆನು. ನಾನು ಅವರಿಗೆ ಈಜಿಪ್ಟ್ ನದಿಯಿಂದ ಯೂಫ್ರೇಟೀಸ್ ಮಹಾನದಿಯವರೆಗೂ ಇರುವ ನಾಡನ್ನು ಕೊಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ಇದು ಕೇನಿಯರ, ಕೆನಿಜೀಯರ, ಕದ್ಮೋನಿಯರ, ");
INSERT INTO kan2010_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ಹಿತ್ತಿಯರ, ಪೆರಿಜೀಯರ, ರೆಷಾಯರ, ");
INSERT INTO kan2010_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ಅಮೋರಿಯರ, ಕಾನಾನ್ಯರ, ಗಿರ್ಗಾಷಿಯರ ಮತ್ತು ಯೆಬೂಸಿಯರ ನಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ಸಾರಯಳು ಅಬ್ರಾಮನ ಹೆಂಡತಿ. ಆಕೆಗೆ ಮಕ್ಕಳಿರಲಿಲ್ಲ. ಸಾರಯಳಿಗೆ ಈಜಿಪ್ಟಿನ ಒಬ್ಬ ಸೇವಕಿಯಿದ್ದಳು. ಅವಳ ಹೆಸರು ಹಾಗರಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ಸಾರಯಳು ಅಬ್ರಾಮನಿಗೆ, “ಯೆಹೋವನು ನನಗೆ ಮಕ್ಕಳನ್ನು ಪಡೆಯುವ ಅವಕಾಶವನ್ನು ಕೊಡಲಿಲ್ಲ. ಆದ್ದರಿಂದ ನನ್ನ ಸೇವಕಿಯಾದ ಹಾಗರಳ ಬಳಿಗೆ ಹೋಗು. ಆಕೆಯಲ್ಲಿ ಹುಟ್ಟುವ ಮಗುವನ್ನು ನನ್ನ ಮಗುವಂತೆ ಸ್ವೀಕರಿಸಿಕೊಳ್ಳುವೆನು” ಎಂದು ಹೇಳಿದಳು. ಅಬ್ರಾಮನು ತನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಯಳಿಗೆ ವಿಧೇಯನಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ಅಬ್ರಾಮನು ಕಾನಾನಿಗೆ ಬಂದು ಹತ್ತು ವರ್ಷಗಳಾದ ಮೇಲೆ ಇದು ನಡೆಯಿತು. ಹೀಗೆ ಸಾರಯಳು ತನ್ನ ಗಂಡನಾದ ಅಬ್ರಾಮನಿಗೆ ಹಾಗರಳನ್ನು ಕೊಟ್ಟಳು. ಹಾಗರಳು ಆಕೆಯ ಈಜಿಪ್ಟಿನ ಸೇವಕಿಯಾಗಿದ್ದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ಹಾಗರಳು ಅಬ್ರಾಮನಿಂದ ಗರ್ಭಿಣಿಯಾದಾಗ ತನ್ನ ಯಜಮಾನಿಯಾದ ಸಾರಯಳನ್ನೇ ಕಡೆಗಣಿಸತೊಡಗಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ಆಗ ಸಾರಯಳು ಅಬ್ರಾಮನಿಗೆ, “ನನ್ನ ಸಂಕಟಕ್ಕೆ ನೀನೇ ಕಾರಣ. ನಾನು ಅವಳನ್ನು ನಿನಗೆ ಕೊಟ್ಟೆನು. ಈಗ ಅವಳು ಗರ್ಭಿಣಿಯಾಗಿದ್ದಾಳೆ ಮತ್ತು ನನ್ನನ್ನೇ ಕಡೆಗಣಿಸುತ್ತಿದ್ದಾಳೆ. ಯೆಹೋವನೇ ನನಗೂ ನಿನಗೂ ನ್ಯಾಯ ತೀರಿಸಲಿ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ಅದಕ್ಕೆ ಅಬ್ರಾಮನು ಸಾರಯಳಿಗೆ, “ನೀನು ಹಾಗರಳ ಯಜಮಾನಿ. ನೀನು ಅವಳಿಗೆ ಏನುಬೇಕಾದರೂ ಮಾಡಬಹುದು” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಸಾರಯಳು ಹಾಗರಳನ್ನು ಶಿಕ್ಷಿಸಿದಳು. ಆಗ ಹಾಗರಳು ಓಡಿಹೋದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ಯೆಹೋವನ ದೂತನು ಹಾಗರಳನ್ನು ಮರುಳುಗಾಡಿನ ಒರತೆಯೊಂದರ ಬಳಿಯಲ್ಲಿ ಕಂಡನು. ಆ ಒರತೆಯು ಶೂರಿಗೆ ಹೋಗುವ ದಾರಿಯ ಬಳಿಯಲ್ಲಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ದೇವದೂತನು ಅವಳಿಗೆ, “ಹಾಗರಳೇ, ನೀನು ಸಾರಯಳ ಸೇವಕಿಯಾಗಿದ್ದರೂ ಯಾಕೆ ಇಲ್ಲಿರುವೆ? ನೀನು ಎಲ್ಲಿಗೆ ಹೋಗುತ್ತಿರುವೆ?” ಎಂದು ಕೇಳಿದನು. ಹಾಗರಳು, “ನನ್ನ ಯಜಮಾನಿಯಾದ ಸಾರಯಳ ಬಳಿಯಿಂದ ಓಡಿಹೋಗುತ್ತಿರುವೆ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ಯೆಹೋವನ ದೂತನು ಹಾಗರಳಿಗೆ, “ಸಾರಯಳು ನಿನ್ನ ಯಜಮಾನಿ. ನೀನು ಆಕೆಯ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಿ ಆಕೆಗೆ ವಿಧೇಯಳಾಗಿರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ಇದಲ್ಲದೆ ಯೆಹೋವನ ದೂತನು ಹಾಗರಳಿಗೆ, “ನಾನು ನಿನ್ನ ಸಂತತಿಯವರನ್ನು ಅಸಂಖ್ಯಾತರನ್ನಾಗಿ ಮಾಡುವೆನು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ಇದಲ್ಲದೆ ದೇವದೂತನು ಆಕೆಗೆ, “ಹಾಗರಳೇ, ಈಗ ನೀನು ಗರ್ಭಿಣಿಯಾಗಿರುವೆ; ನಿನಗೆ ಒಬ್ಬ ಮಗನು ಹುಟ್ಟುವನು. ನೀನು ಅವನಿಗೆ ಇಷ್ಮಾಯೇಲ್ ಎಂದು ಹೆಸರಿಡಬೇಕು; ಯಾಕೆಂದರೆ ಯೆಹೋವನು ನಿನ್ನ ಕಷ್ಟಗಳನ್ನು ಕೇಳಿದ್ದಾನೆ; ಆತನು ನಿನಗೆ ಸಹಾಯ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ಇಷ್ಮಾಯೇಲನು ಕಾಡುಕತ್ತೆಯಂತೆ ಗಡುಸಾಗಿದ್ದು ಸ್ವತಂತ್ರವಾಗಿರುವನು. ಅವನು ಪ್ರತಿಯೊಬ್ಬರಿಗೂ ವಿರೋಧವಾಗಿರುವನು; ಪ್ರತಿಯೊಬ್ಬರೂ ಅವನಿಗೆ ವಿರೋಧವಾಗಿರುವರು. ಅವನು ಸ್ಥಳದಿಂದ ಸ್ಥಳಕ್ಕೆ ಹೋಗುತ್ತಾ ತನ್ನ ಸಹೋದರರ ಸಮೀಪದಲ್ಲಿ ವಾಸಿಸಿದರೂ ಅವರಿಗೆ ವಿರೋಧವಾಗಿರುವನು.” ಎಂದು ಹೇಳಿ ಹೊರಟುಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ಯೆಹೋವನು ತನ್ನೊಡನೆ ಮಾತಾಡಿದ್ದರಿಂದ ಹಾಗರಳು, “ಈ ಸ್ಥಳದಲ್ಲಿಯೂ ದೇವರು ನನ್ನನ್ನು ನೋಡಿ ನನಗಾಗಿ ಚಿಂತಿಸುತ್ತಾನೆ ಎಂದುಕೊಂಡು ಆತನಿಗೆ ‘ನನ್ನನ್ನು ನೋಡುವ ದೇವರು’” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ಆದ್ದರಿಂದ ಆ ಬಾವಿಗೆ ಬೀರ್‌ಲಹೈರೋಯಿ (ಬೀರ್‌ಲಹೈರೋಯಿ. ಇದರರ್ಥ: “ನನ್ನನ್ನು ನೋಡುವ ಜೀವಸ್ವರೂಪನ ಬಾವಿ.”) ಎಂದು ಹೆಸರಾಯಿತು. ಈ ಬಾವಿಯು ಕಾದೇಶಿಗೂ ಬೆರೆದಿಗೂ ನಡುವೆ ಇದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ಹಾಗರಳು ಅಬ್ರಾಮನ ಮಗನಿಗೆ ಜನ್ಮಕೊಟ್ಟಳು. ಅಬ್ರಾಮನು ಆ ಮಗನಿಗೆ ಇಷ್ಮಾಯೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ಅಬ್ರಾಮನಿಗೆ ಎಂಭತ್ತಾರು ವರ್ಷವಾಗಿದ್ದಾಗ ಹಾಗರಳಲ್ಲಿ ಇಷ್ಮಾಯೇಲನು ಜನಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ಅಬ್ರಾಮನಿಗೆ ತೊಂಭತ್ತೊಂಬತ್ತು ವರ್ಷವಾಗಿದ್ದಾಗ ಯೆಹೋವನು ಅವನಿಗೆ ಪ್ರತ್ಯಕ್ಷನಾಗಿ, “ನಾನು ಸರ್ವಶಕ್ತನಾದ ದೇವರು. ನನಗೆ ವಿಧೇಯನಾಗಿದ್ದು ನಿರ್ದೋಷಿಯಾಗಿರು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ನಾನು ನಿನ್ನೊಂದಿಗೆ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಳ್ಳುವೆನು; ನಿನ್ನನ್ನು ದೊಡ್ಡ ಜನಾಂಗವನ್ನಾಗಿ ಮಾಡುವುದಾಗಿ ವಾಗ್ದಾನ ಮಾಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ಆ ಕೂಡಲೇ ಅಬ್ರಾಮನು ದೇವರಿಗೆ ಸಾಷ್ಟಾಂಗನಮಸ್ಕಾರ ಮಾಡಿದನು. ಆಗ ದೇವರು ಅವನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ನಾನು ನಿನಗೆ ಮಾಡುವ ವಾಗ್ದಾನವೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","‘ಅಬ್ರಾಮ’ ಎಂಬ ನಿನ್ನ ಹೆಸರನ್ನು ಬದಲಾಯಿಸಿ ನಿನಗೆ ‘ಅಬ್ರಹಾಮ’ ಎಂದು ಹೆಸರಿಡುವೆನು. ನಿನ್ನನ್ನು ಅಬ್ರಹಾಮ ಎಂದೇ ಕರೆಯುವರು; ಯಾಕೆಂದರೆ ನೀನು ಅನೇಕ ಜನಾಂಗಗಳಿಗೆ ಮೂಲಪಿತೃವಾಗುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ಹೊಸ ಜನಾಂಗಗಳು ನಿನ್ನಿಂದ ಹುಟ್ಟುವವು; ರಾಜರುಗಳು ನಿನ್ನಿಂದ ಬರುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ನಾನು ನಿನ್ನೊಂದಿಗೆ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಳ್ಳುವೆನು. ಈ ಒಡಂಬಡಿಕೆಯು ನಿನ್ನ ಎಲ್ಲಾ ಸಂತತಿಯವರಿಗೆ ಶಾಶ್ವತವಾಗಿ ಅನ್ವಯಿಸುವುದು. ನಾನೇ ನಿನಗೂ ನಿನ್ನ ಎಲ್ಲಾ ಸಂತತಿಯವರಿಗೂ ದೇವರಾಗಿರುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ನೀನು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿರುವ ಈ ಕಾನಾನ್ ದೇಶವನ್ನೆಲ್ಲ ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತವಾಗಿ ಕೊಡುವೆನು. ನಾನೇ ನಿಮ್ಮ ದೇವರಾಗಿರುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ಇದಲ್ಲದೆ ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ, “ನಮ್ಮ ಒಡಂಬಡಿಕೆಯ ಪ್ರಕಾರ ನೀನು ಮತ್ತು ನಿನ್ನ ಸಂತತಿಯವರೆಲ್ಲರೂ ನನ್ನ ಒಡಂಬಡಿಕೆಗೆ ವಿಧೇಯರಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ನೀನೂ ಮತ್ತು ನಿನ್ನ ಎಲ್ಲಾ ಸಂತತಿಯವರು ಕೈಕೊಳ್ಳಬೇಕಾದ ನಿಬಂಧನೆಯೇನೆಂದರೆ, ನಿಮ್ಮಲ್ಲಿ ಹುಟ್ಟಿದ ಪ್ರತಿಯೊಂದು ಗಂಡುಮಗುವಿಗೂ ಸುನ್ನತಿ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","ಇಂದಿನಿಂದ ನಿಮ್ಮಲ್ಲಿ ಗಂಡುಮಗು ಹುಟ್ಟಿ ಎಂಟು ದಿನಗಳಾದ ಮೇಲೆ ಆ ಮಗುವಿಗೆ ಸುನ್ನತಿ ಮಾಡಿಸಬೇಕು; ಈ ನಿಯಮವು ನಿಮ್ಮ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದ ಸೇವಕರಿಗೂ, ಪರದೇಶದಿಂದ ಕೊಂಡುತಂದ ಸೇವಕರಿಗೂ ಸಹ ಅನ್ವಯಿಸುತ್ತದೆ. ನನಗೂ ನಿನಗೂ ಆದ ಒಡಂಬಡಿಕೆಗೆ ಇದು ಗುರುತಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","14","ಹೀಗೆ ಪ್ರತಿಯೊಬ್ಬನಿಗೂ ಸುನ್ನತಿಯಾಗಲೇಬೇಕು. ನಾನು ನಿನ್ನೊಂದಿಗೆ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಯು ಶಾಶ್ವತವಾದದ್ದು ಎಂಬುದಕ್ಕೆ ಈ ಸುನ್ನತಿಯೇ ದೈಹಿಕ ಗುರುತಾಗಿದೆ. ಸುನ್ನತಿಯಾಗಿಲ್ಲದ ಪುರುಷನು ನನ್ನ ಒಡಂಬಡಿಕೆಗೆ ವಿಧೇಯನಾಗದ ಕಾರಣ ಅವನನ್ನು ಕುಲದಿಂದ ತೆಗೆದುಹಾಕಲ್ಪಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ, “ನಿನ್ನ ಹೆಂಡತಿಯಾದ, ಸಾರಯಳಿಗೆ ನಾನು ಒಂದು ಹೆಸರನ್ನು ಕೊಡುತ್ತೇನೆ. ಆಕೆಯ ಹೊಸ ಹೆಸರು ಸಾರಾ. ");
INSERT INTO kan2010_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ನಾನು ಆಕೆಯನ್ನು ಆಶೀರ್ವದಿಸಿ ಆಕೆಗೆ ಒಬ್ಬ ಮಗನನ್ನು ದಯಪಾಲಿಸುವೆನು; ನೀನೇ ಅವನ ತಂದೆ. ಅನೇಕ ಜನಾಂಗಗಳಿಗೂ ರಾಜರುಗಳಿಗೂ ಆಕೆಯು ಮೂಲಮಾತೆಯಾಗಿರುವಳು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ಅಬ್ರಹಾಮನು ದೇವರಿಗೆ ಸಾಷ್ಟಾಂಗನಮಸ್ಕಾರ ಮಾಡಿದನು. ಆದರೆ ಅವನು ಮನಸ್ಸಿನಲ್ಲಿ ನಗುತ್ತಾ, “ನನಗೆ ನೂರು ವರ್ಷ ವಯಸ್ಸಾಗಿರುವುದರಿಂದ ಮಗನನ್ನು ಪಡೆಯಲು ನನಗೂ ಸಾಧ್ಯವಿಲ್ಲ. ಸಾರಳಿಗೆ ತೊಂಭತ್ತು ವರ್ಷ ವಯಸ್ಸಾಗಿರುವುದರಿಂದ ಮಗನನ್ನು ಪಡೆಯಲು ಆಕೆಗೂ ಸಾಧ್ಯವಿಲ್ಲ” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ಆಮೇಲೆ ಅಬ್ರಹಾಮನು ದೇವರಿಗೆ, “ಇಷ್ಮಾಯೇಲನೇ ನಿನ್ನ ಆಶೀರ್ವಾದವನ್ನು ಹೊಂದಿಕೊಂಡು ಜೀವಿಸಬಾರದೇಕೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ಅದಕ್ಕೆ ದೇವರು ಅವನಿಗೆ, “ಇಲ್ಲ! ನಿನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಳಿಗೆ ಒಬ್ಬ ಮಗನು ಹುಟ್ಟುವನು. ನೀನು ಅವನಿಗೆ, ‘ಇಸಾಕ’ ಎಂದು ಹೆಸರಿಡಬೇಕು. ನಾನು ಒಂದು ಒಡಂಬಡಿಕೆಯನ್ನು ಅವನೊಡನೆ ಮಾಡಿಕೊಳ್ಳುವೆನು. ಆ ಒಡಂಬಡಿಕೆಯು ಅವನ ಎಲ್ಲಾ ಸಂತತಿಯವರಲ್ಲಿಯೂ ಶಾಶ್ವತವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“ನೀನು ಇಷ್ಮಾಯೇಲನ ಬಗ್ಗೆ ಮಾಡಿದ ಬಿನ್ನಹವನ್ನು ಕೇಳಿದ್ದೇನೆ. ನಾನು ಅವನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು. ಅವನು ಅನೇಕ ಮಕ್ಕಳನ್ನು ಪಡೆದುಕೊಳ್ಳುವನು. ಹನ್ನೆರಡು ಮಹಾನಾಯಕರುಗಳಿಗೆ ಅವನು ತಂದೆಯಾಗುವನು. ಅವನ ಸಂತತಿಯು ಮಹಾಜನಾಂಗವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ಆದರೆ ನಾನು ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಇಸಾಕನೊಡನೆ ಮಾಡಿಕೊಳ್ಳುವೆನು. ಸಾರಳಲ್ಲಿ ಹುಟ್ಟುವ ಮಗನೇ ಇಸಾಕನು. ಮುಂದಿನ ವರ್ಷ ಇದೇ ಸಮಯದಲ್ಲಿ ಇಸಾಕನು ಹುಟ್ಟುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ದೇವರು ಅಬ್ರಹಾಮನೊಡನೆ ಮಾತಾಡುವುದನ್ನು ಮುಗಿಸಿದ ಮೇಲೆ ಮೇಲೋಕಕ್ಕೆ ಹೊರಟುಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ಅದೇ ದಿನದಲ್ಲಿ ಅಬ್ರಹಾಮನು ಇಷ್ಮಾಯೇಲನಿಗೂ ತನ್ನ ಮನೆಯಲ್ಲಿದ್ದ ಸೇವಕರಿಗೆ ಹುಟ್ಟಿದ ಗಂಡುಮಕ್ಕಳಿಗೂ ಪರದೇಶಿಯರಿಂದ ಕೊಂಡುತಂದಿದ್ದ ಸೇವಕರಿಗೂ ದೇವರು ಹೇಳಿದಂತೆಯೇ ಸುನ್ನತಿ ಮಾಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ಅಬ್ರಹಾಮನು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡಾಗ ತೊಂಭತ್ತೊಂಭತ್ತು ವರ್ಷದವನಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ಇಷ್ಮಾಯೇಲನಿಗೆ ಸುನ್ನತಿಯಾದಾಗ ಅವನಿಗೆ ಹದಿಮೂರು ವರ್ಷವಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ಅಬ್ರಹಾಮನಿಗೂ ಅವನ ಮಗನಿಗೂ ಒಂದೇ ದಿನದಲ್ಲಿ ಸುನ್ನತಿಯಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ಅಬ್ರಹಾಮನ ಮನೆಯಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಗಂಡಸರಿಗೆ ಅಂದರೆ ಅವನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದ ಎಲ್ಲಾ ಸೇವಕರಿಗೆ ಮತ್ತು ಅವನು ಕ್ರಯಕ್ಕೆ ತೆಗೆದುಕೊಂಡಿದ್ದ ಎಲ್ಲಾ ಸೇವಕರಿಗೆ ಸುನ್ನತಿಯಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ಅಬ್ರಹಾಮನು ಮಮ್ರೆಯಲ್ಲಿದ್ದ ಓಕ್ ಮರಗಳ ತೋಪಿನ ಸಮೀಪದಲ್ಲಿ ವಾಸಿಸುತ್ತಿದ್ದಾಗ ಯೆಹೋವನು ಅವನಿಗೆ ಕಾಣಿಸಿಕೊಂಡನು. ಅಂದು ಬಿಸಿಲಿನ ತಾಪದಿಂದಾಗಿ ಅಬ್ರಹಾಮನು ತನ್ನ ಗುಡಾರದ ಬಾಗಿಲ ಬಳಿ ಕುಳಿತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ಅಬ್ರಹಾಮನು ದೃಷ್ಟಿಸಿ ನೋಡಿದಾಗ ತನ್ನ ಮುಂದೆ ಮೂವರು ಪುರುಷರು ನಿಂತಿರುವುದನ್ನು ಕಂಡನು. ಕೂಡಲೇ ಅವರ ಬಳಿಗೆ ಓಡಿಹೋಗಿ ಅವರಿಗೆ ಸಾಷ್ಟಾಂಗನಮಸ್ಕಾರ ಮಾಡಿ ಅವರಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“ಸ್ವಾಮಿಗಳೇ, ನಿಮ್ಮ ಸೇವಕನಾದ ನನ್ನ ಜೊತೆಯಲ್ಲಿ ಸ್ವಲ್ಪ ಸಮಯವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ನಿಮ್ಮ ಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಲು ನೀರನ್ನು ತಂದುಕೊಡುವೆನು. ನೀವು ಮರದ ಕೆಳಗೆ ವಿಶ್ರಾಂತಿ ತೆಗೆದುಕೊಳ್ಳಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ನಾನು ನಿಮಗೆ ಊಟವನ್ನು ತಂದುಕೊಡುವೆನು. ನೀವು ಬೇಕಾದಷ್ಟು ಊಟ ಮಾಡಿದ ನಂತರ ನಿಮ್ಮ ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರಿಸಬಹುದು” ಎಂದು ಹೇಳಿದನು. ಆ ಮೂವರು ಪುರಷರು, “ಸರಿ, ನೀನು ಹೇಳಿದಂತೆಯೇ ಮಾಡು” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ಅಬ್ರಹಾಮನು ಗುಡಾರಕ್ಕೆ ಬೇಗನೆ ಹೋಗಿ ಸಾರಳಿಗೆ, “ಮೂರು ದೊಡ್ಡ ರೊಟ್ಟಿಗಳಿಗೆ ಬೇಕಾಗುವಷ್ಟು ಗೋಧಿ ಹಿಟ್ಟನ್ನು ಬೇಗನೆ ನಾದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ಬಳಿಕ ಅವನು ತನ್ನ ಪಶುಗಳಿದ್ದಲ್ಲಿಗೆ ಓಡಿಹೋಗಿ ಉತ್ತಮವಾದ ಎಳೆಕರುವನ್ನು ತೆಗೆದು ಸೇವಕನಿಗೆ ಕೊಟ್ಟು, “ಬೇಗನೇ ಕರುವನ್ನು ಕೊಯ್ದು, ಊಟಕ್ಕೆ ಸಿದ್ಧಮಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ಅಬ್ರಹಾಮನು ಆ ಮೂವರಿಗೆ ಮಾಂಸದ ಅಡಿಗೆಯನ್ನು ಬಡಿಸಿದನು. ಇದಲ್ಲದೆ ಅವನು ಹಾಲನ್ನೂ ಬೆಣ್ಣೆಯನ್ನೂ ಕೊಟ್ಟನು. ಆ ಮೂವರು ಊಟ ಮಾಡುವಾಗ ಅಬ್ರಹಾಮನು ಅವರ ಸಮೀಪದಲ್ಲಿ ಮರದ ಕೆಳಗೆ ನಿಂತುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ಆ ಪುರುಷರು ಅಬ್ರಹಾಮನಿಗೆ, “ನಿನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಳು ಎಲ್ಲಿ?” ಎಂದು ಕೇಳಿದರು. ಅಬ್ರಹಾಮನು ಅವರಿಗೆ, “ಆಕೆ ಗುಡಾರದಲ್ಲಿ ಇದ್ದಾಳೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ಆಗ ಯೆಹೋವನು ಅವನಿಗೆ, “ನಾನು ಮತ್ತೆ ವಸಂತಕಾಲದಲ್ಲಿ ಬರುತ್ತೇನೆ. ಆ ಸಮಯದಲ್ಲಿ ನಿನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಳಿಗೆ ಒಬ್ಬ ಮಗನಿರುವನು” ಎಂದು ಹೇಳಿದನು. ಸಾರಳು ಗುಡಾರದಲ್ಲಿದ್ದುಕೊಂಡು ಇದನ್ನೆಲ್ಲಾ ಕೇಳಿಸಿಕೊಳ್ಳುತ್ತಿದ್ದಳು. ಅವಳಿಗೆ ಈ ಸಂಗತಿಯೂ ಕೇಳಿಸಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ಅಬ್ರಹಾಮನೂ ಮತ್ತು ಸಾರಳೂ ತುಂಬ ವೃದ್ಧರಾಗಿದ್ದರು. ಸಾರಳಿಗೂ ಮಕ್ಕಳು ಹುಟ್ಟುವ ಕಾಲ ಆಗಿಹೋಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ಆದ್ದರಿಂದ ಸಾರಳಿಗೆ ನಂಬಲಾಗಲಿಲ್ಲ. ಆಕೆ ತನ್ನೊಳಗೆ, “ಈಗಾಗಲೇ ನನಗೆ ವಯಸ್ಸಾಗಿದೆ; ನನ್ನ ಗಂಡನಿಗೂ ವಯಸ್ಸಾಗಿದೆ” ಅಂದುಕೊಂಡಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ಆಗ ಯೆಹೋವನು ಅಬ್ರಹಾಮನಿಗೆ, “ನಾನು ಹೇಳುವುದನ್ನು ಸಾರಳು ನಂಬುತ್ತಿಲ್ಲ. ಆಕೆಯು ನಗುತ್ತಾ ತನ್ನೊಳಗೆ, ‘ನನಗೆ ಮಕ್ಕಳಾಗದಷ್ಟು ವಯಸ್ಸಾಗಿದೆ’ ಎಂದು ಹೇಳಿದ್ದೇಕೆ? ");
INSERT INTO kan2010_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ಯೆಹೋವನಿಗೆ ಅಸಾಧ್ಯವಾದುದುಂಟೇ? ನಾನು ಮತ್ತೆ ವಸಂತಕಾಲದಲ್ಲಿ ಬರುವೆನು. ಆಗ ನಿನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಳಿಗೆ ಒಬ್ಬ ಮಗನಿದ್ದೇ ಇರುವನು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ಆದರೆ ಸಾರಳು ಭಯಪಟ್ಟು, “ನಾನು ನಗಲಿಲ್ಲ” ಅಂದಳು. ಅದಕ್ಕೆ ಯೆಹೋವನು, “ಇಲ್ಲ, ನೀನು ನಕ್ಕಿದ್ದು ನಿಜ!” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ಆಮೇಲೆ ಆ ಪುರುಷರು ಹೋಗಲು ಎದ್ದುನಿಂತರು. ಅವರು ಸೊದೋಮಿನ ಕಡೆಗೆ ಕಣ್ಣೆತ್ತಿ ನೋಡಿ ಆ ಕಡೆಗೆ ನಡೆಯಲಾರಂಭಿಸಿದರು. ಅವರನ್ನು ಕಳುಹಿಸಿಕೊಡಲು ಅಬ್ರಹಾಮನು ಅವರ ಸಂಗಡ ಸ್ವಲ್ಪದೂರ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ಯೆಹೋವನು ತನ್ನೊಳಗೆ ಹೀಗೆಂದುಕೊಂಡನು: “ನಾನು ಈಗ ಮಾಡುವ ಕಾರ್ಯವನ್ನು ಅಬ್ರಹಾಮನಿಗೆ ತಿಳಿಸಲೇ? ");
INSERT INTO kan2010_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ಅಬ್ರಹಾಮನಿಂದ ಬಲಿಷ್ಠವಾದ ಮಹಾಜನಾಂಗ ಹುಟ್ಟುವುದು; ಅವನ ಮೂಲಕ ಈ ಲೋಕದ ಜನರೆಲ್ಲರೂ ಆಶೀರ್ವಾದ ಹೊಂದುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ನಾನು ಅವನೊಡನೆ ವಿಶೇಷವಾದ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡಿದ್ದೇನೆ. ಅವನು ತನ್ನ ಮಕ್ಕಳಿಗೂ ಸಂತತಿಯವರಿಗೂ ನನಗೆ ವಿಧೇಯರಾಗುವಂತೆ ಮತ್ತು ನ್ಯಾಯನೀತಿಗಳಿಂದ ಜೀವಿಸುವಂತೆ ಆಜ್ಞಾಪಿಸಲೆಂದು ನಾನು ಅವನೊಂದಿಗೆ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡೆನು. ಅವರು ಹೀಗೆ ಜೀವಿಸಿದರೆ, ನನ್ನ ವಾಗ್ದಾನಗಳನ್ನೆಲ್ಲಾ ನೆರವೇರಿಸುವೆನು.” ");
INSERT INTO kan2010_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ಇದಲ್ಲದೆ ಯೆಹೋವನು, “ಸೊದೋಮ್ ಮತ್ತು ಗೊಮೋರಗಳ ಜನರು ಬಹಳ ಕೆಟ್ಟವರೆಂದು ಅನೇಕ ಸಲ ಕೇಳಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ಆದ್ದರಿಂದ ನಾನು ಕೆಳಗಿಳಿದು ಅಲ್ಲಿಗೆ ಹೋಗಿ ನಾನು ಕೇಳಿದ್ದು ನಿಜವೇ ಎಂದು ಪರೀಕ್ಷಿಸುವೆನು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ಆದ್ದರಿಂದ ಆ ಪುರುಷರು ಸೊದೋಮಿನ ಕಡೆಗೆ ನಡೆಯತೊಡಗಿದರು. ಆದರೆ ಅಬ್ರಹಾಮನು ಯೆಹೋವನ ಎದುರಿನಲ್ಲಿ ನಿಂತುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ಅಬ್ರಹಾಮನು ಯೆಹೋವನ ಸಮೀಪಕ್ಕೆ ಬಂದು, “ಯೆಹೋವನೇ, ನೀನು ಕೆಟ್ಟವರನ್ನು ನಾಶಮಾಡುವಾಗ ನೀತಿವಂತರನ್ನು ಸಹ ನಾಶಮಾಡಬೇಕೆಂದಿರುವೆಯೋ? ");
INSERT INTO kan2010_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ಒಂದುವೇಳೆ ಆ ಪಟ್ಟಣದಲ್ಲಿ ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರಿದ್ದರೆ ಏನು ಮಾಡುವೆ? ನೀನು ಆ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವಿಯೋ? ಖಂಡಿತವಾಗಿಯೂ ಇಲ್ಲ! ಅಲ್ಲಿ ಜೀವಿಸುತ್ತಿರುವ ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರಿಗಾಗಿ ನೀನು ಆ ಪಟ್ಟಣವನ್ನು ಉಳಿಸಿ ಕಾಪಾಡುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ಖಂಡಿತವಾಗಿಯೂ ನೀನು ಆ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ. ಕೆಟ್ಟವರನ್ನು ಕೊಲ್ಲುವುದಕ್ಕಾಗಿ ನೀನು ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರನ್ನು ಕೊಲ್ಲುವುದಿಲ್ಲ. ಒಂದುವೇಳೆ ನೀನು ಕೊಂದರೆ, ಒಳ್ಳೆಯವರೂ ಕೆಟ್ಟವರೂ ಸರಿಸಮಾನರಾಗುವರು. ಅವರಿಬ್ಬರೂ ದಂಡನೆಗೆ ಗುರಿಯಾಗುವರು. ನೀನು ಲೋಕದವರಿಗೆಲ್ಲ ನ್ಯಾಯಾಧಿಪತಿ. ನೀನು ನ್ಯಾಯವಾದದ್ದನ್ನೇ ಮಾಡುವೆ ಎಂದು ನನಗೆ ಗೊತ್ತಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ಆಮೇಲೆ ಯೆಹೋವನು, “ನಾನು ಸೊದೋಮಿನಲ್ಲಿ ಐವತ್ತು ಮಂದಿ ನೀತಿವಂತರನ್ನು ಕಂಡರೆ, ನಾನು ಇಡೀ ಪಟ್ಟಣವನ್ನೇ ಉಳಿಸಿ ಕಾಪಾಡುವೆನು” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ಆಗ ಅಬ್ರಹಾಮನು ಯೆಹೋವನಿಗೆ, “ನಿನಗೆ ನನ್ನನ್ನು ಹೋಲಿಸಿಕೊಂಡರೆ, ನಾನು ಕೇವಲ ಧೂಳು ಮತ್ತು ಬೂದಿ. ಆದರೆ ಈ ಪ್ರಶ್ನೆಯನ್ನೂ ಕೇಳಲು ನನಗೆ ಅವಕಾಶಕೊಡು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ಒಂದುವೇಳೆ ಐದು ಮಂದಿ ಕಡಿಮೆಯಾಗಿದ್ದು ನಲವತ್ತೈದು ಮಂದಿ ಮಾತ್ರ ನೀತಿವಂತರಿದ್ದರೆ ಆ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವಿಯಾ?” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕೆ ಯೆಹೋವನು ಅವನಿಗೆ, “ನಾನು ನಲವತ್ತೈದು ಮಂದಿ ನೀತಿವಂತರನ್ನು ಕಂಡರೂ ಆ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ಮತ್ತೆ ಅಬ್ರಹಾಮನು ದೇವರಿಗೆ, “ಕೇವಲ ನಲವತ್ತು ಮಂದಿ ನೀತಿವಂತರನ್ನು ಕಂಡರೆ, ನೀನು ಆ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವೆಯಾ?” ಎಂದು ಕೇಳಿದನು. ಯೆಹೋವನು ಅವನಿಗೆ, “ನಲವತ್ತು ಮಂದಿ ನೀತಿವಂತರನ್ನು ಕಂಡರೂ ನಾನು ಆ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ಆಮೇಲೆ ಅಬ್ರಹಾಮನು, “ಯೆಹೋವನೇ, ನನ್ನ ಮೇಲೆ ಸಿಟ್ಟುಗೊಳ್ಳಬೇಡ. ಈ ಪ್ರಶ್ನೆಯನ್ನೂ ಕೇಳುವೆ: ಆ ಪಟ್ಟಣದಲ್ಲಿ ಕೇವಲ ಮೂವತ್ತು ಮಂದಿ ನೀತಿವಂತರಿದ್ದರೆ ನೀನು ಆ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವೆಯಾ?” ಎಂದು ಕೇಳಿದನು. ಯೆಹೋವನು ಅವನಿಗೆ, “ಅಲ್ಲಿ ಮೂವತ್ತು ಮಂದಿ ನೀತಿವಂತರಿದ್ದರೂ ನಾನು ಆ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ಆಮೇಲೆ ಅಬ್ರಹಾಮನು, “ನನ್ನ ಯೆಹೋವನು ಏನೂ ತಿಳಿದುಕೊಳ್ಳದಿರಲಿ. ನಾನು ಮತ್ತೊಂದು ಪ್ರಶ್ನೆ ಕೇಳುವೆ. ಅಲ್ಲಿ ಇಪ್ಪತ್ತು ಮಂದಿ ನೀತಿವಂತರಿದ್ದರೆ ಏನು ಮಾಡುವೆ?” ಎಂದು ಕೇಳಿದನು. ಯೆಹೋವನು ಅವನಿಗೆ, “ಅಲ್ಲಿ ಇಪ್ಪತ್ತು ಮಂದಿ ನೀತಿವಂತರನ್ನು ಕಂಡರೆ ಆ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ಆಮೇಲೆ ಅಬ್ರಹಾಮನು, “ಯೆಹೋವನೇ, ದಯಮಾಡಿ ನನ್ನ ಮೇಲೆ ಸಿಟ್ಟುಗೊಳ್ಳಬೇಡ. ಇದೊಂದು ಸಲ ಮಾತ್ರ ಪ್ರಶ್ನೆ ಕೇಳುವೆ. ಹತ್ತು ಮಂದಿ ನೀತಿವಂತರನ್ನು ಕಂಡರೆ ಏನು ಮಾಡುವೆ?” ಎಂದು ಕೇಳಿದನು. ಯೆಹೋವನು ಅವನಿಗೆ, “ನಾನು ಆ ಪಟ್ಟಣದಲ್ಲಿ ಹತ್ತು ಮಂದಿ ನೀತಿವಂತರನ್ನು ಕಂಡರೂ, ಅದನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ಯೆಹೋವನು ಅಬ್ರಹಾಮನೊಂದಿಗೆ ಮಾತಾಡುವುದನ್ನು ಮುಗಿಸಿದ ಮೇಲೆ ಅಲ್ಲಿಂದ ಹೊರಟುಹೋದನು. ಅಬ್ರಹಾಮನು ಸಹ ತನ್ನ ಮನೆಗೆ ಹಿಂತಿರುಗಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ಆ ಸಾಯಂಕಾಲ, ದೇವದೂತರಿಬ್ಬರು ಸೊದೋಮ್ ನಗರಕ್ಕೆ ಬಂದರು. ನಗರದ ಬಾಗಿಲುಗಳ ಬಳಿ ಕುಳಿತುಕೊಂಡಿದ್ದ ಲೋಟನು ದೇವದೂತರನ್ನು ಕಂಡು, ಅವರ ಬಳಿಗೆ ಹೋಗಿ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ಲೋಟನು ಅವರಿಗೆ, “ಸ್ವಾಮಿಗಳೇ, ದಯವಿಟ್ಟು ನನ್ನ ಮನೆಗೆ ಬನ್ನಿ. ನಾನು ನಿಮ್ಮನ್ನು ಉಪಚರಿಸುವೆನು. ನಿಮ್ಮ ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಈ ರಾತ್ರಿ ನಮ್ಮ ಮನೆಯಲ್ಲೇ ಇರಿ. ನಾಳೆ ಮುಂಜಾನೆ ನಿಮ್ಮ ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರಿಸಬಹುದು” ಎಂದು ಹೇಳಿದನು. ದೇವದೂತರು, “ಈ ಚೌಕದಲ್ಲಿ ನಾವು ಈ ರಾತ್ರಿ ಕಳೆಯುತ್ತೇವೆ” ಎಂದು ಉತ್ತರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ಆದರೆ ಲೋಟನು ತನ್ನ ಮನೆಗೆ ಬರುವಂತೆ ಒತ್ತಾಯಿಸಿದ್ದರಿಂದ ಅವರು ಅವನ ಮನೆಗೆ ಹೋದರು. ಲೋಟನು ಅವರಿಗಾಗಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಸುಡಿಸಿ ಅಡಿಗೆ ಮಾಡಿಸಿದನು. ದೇವದೂತರು ಅದನ್ನು ಊಟಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ಆ ರಾತ್ರಿ ಮಲಗುವುದಕ್ಕಿಂತ ಮುಂಚೆ ಸೊದೋಮಿನ ಗಂಡಸರೆಲ್ಲರೂ ಬಂದು ಲೋಟನ ಮನೆಯ ಸುತ್ತಲೂ ನಿಂತುಕೊಂಡು ಲೋಟನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","“ನಿನ್ನ ಮನೆಗೆ ಬಂದ ಆ ಇಬ್ಬರು ಪುರುಷರು ಎಲ್ಲಿದ್ದಾರೆ? ಅವರನ್ನು ಹೊರಗೆ ಕಳುಹಿಸು. ನಾವು ಅವರನ್ನು ಸಂಭೋಗಿಸಬೇಕು” ಎಂದು ಕೂಗಿ ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ಲೋಟನು ಹೊರಗೆ ಬಂದು ಬಾಗಿಲಿಗೆ ಬೀಗ ಹಾಕಿ, ");
INSERT INTO kan2010_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ಆ ಗಂಡಸರಿಗೆ, “ನನ್ನ ಸಹೋದರರೇ, ನಾನು ನಿಮ್ಮನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತಿದ್ದೇನೆ. ದಯವಿಟ್ಟು ಈ ಕೆಟ್ಟಕಾರ್ಯವನ್ನು ಮಾಡಬೇಡಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ನೋಡಿ! ನನಗೆ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳಿದ್ದಾರೆ. ಅವರು ಹಿಂದೆಂದೂ ಗಂಡಸರೊಡನೆ ಮಲಗಿದವರಲ್ಲ. ನೀವು ಅವರಿಗೆ ಏನುಬೇಕಾದರೂ ಮಾಡಿ, ಆದರೆ ದಯವಿಟ್ಟು ಈ ಪುರುಷರಿಗೆ ಏನನ್ನೂ ಮಾಡಬೇಡಿ. ಇವರು ನನ್ನ ಮನೆಗೆ ಬಂದಿದ್ದಾರೆ; ಇವರನ್ನು ಕಾಪಾಡುವುದು ನನ್ನ ಕರ್ತವ್ಯ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ಮನೆಯ ಸುತ್ತಲೂ ನಿಂತುಕೊಂಡಿದ್ದ ಗಂಡಸರು ಅವನಿಗೆ, “ದಾರಿಬಿಡು” ಎಂದು ಕೂಗಿದರು. ಆಮೇಲೆ ಅವರು ತಮ್ಮೊಳಗೆ, “ಈ ಲೋಟನು ನಮ್ಮ ನಗರಕ್ಕೆ ಪ್ರವಾಸಿಗನಂತೆ ಬಂದು ಈಗ ನಮಗೇ ನ್ಯಾಯವನ್ನು ಹೇಳಿಕೊಡುತ್ತಿದ್ದಾನೆ” ಎಂದು ಮಾತಾಡಿಕೊಂಡರು. ಆಮೇಲೆ ಅವರು ಲೋಟನಿಗೆ, “ನಾವು ಆ ಪುರುಷರಿಗೆ ಮಾಡುವುದಕ್ಕಿಂತ ನಿನಗೇ ಹೆಚ್ಚು ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡುತ್ತೇವೆ” ಎಂದು ಕೂಗಿಹೇಳಿ ಲೋಟನ ಸಮೀಪಕ್ಕೆ ಬಂದು ಬಾಗಿಲನ್ನು ಮುರಿದುಹಾಕಲು ಸಿದ್ಧರಾದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ಆದರೆ ಮನೆಯೊಳಗಿದ್ದ ಇಬ್ಬರು ಪುರುಷರು ಬಾಗಿಲನ್ನು ತೆರೆದು ಲೋಟನನ್ನು ಮನೆಯೊಳಗೆ ಎಳೆದುಕೊಂಡು ಬಾಗಿಲನ್ನು ಮುಚ್ಚಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ಆ ಇಬ್ಬರು ಪುರುಷರು ಮನೆಯ ಹೊರಗೆ ಇದ್ದ ಗಂಡಸರನ್ನೆಲ್ಲಾ ಕುರುಡರಾಗುವಂತೆ ಮಾಡಿದ್ದರಿಂದ ಅವರು ಬಾಗಿಲನ್ನು ಗುರುತಿಸಲಾರದೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ಆ ಇಬ್ಬರು ಪುರುಷರು ಲೋಟನಿಗೆ, “ನಿನ್ನ ಕುಟುಂಬದ ಬೇರೆ ಯಾರಾದರೂ ಈ ನಗರದಲ್ಲಿ ಇದ್ದಾರೆಯೇ? ನಿನಗೆ ಅಳಿಯಂದಿರಾಗಲಿ ಗಂಡುಮಕ್ಕಳಾಗಲಿ ಹೆಣ್ಣುಮಕ್ಕಳಾಗಲಿ ಇಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾರೆಯೇ? ನಿನ್ನ ಕುಟುಂಬದ ಯಾರಾದರೂ ಈ ನಗರದಲ್ಲಿದ್ದರೆ ಈಗಲೇ ಇಲ್ಲಿಂದ ಹೊರಡುವಂತೆ ಅವರಿಗೆ ತಿಳಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ನಾವು ಈ ನಗರವನ್ನು ನಾಶಮಾಡುತ್ತೇವೆ. ಈ ನಗರದ ದುಷ್ಟತನವನ್ನು ಯೆಹೋವನು ನೋಡಿದ್ದಾನೆ. ಆದ್ದರಿಂದ ಇದನ್ನು ನಾಶಮಾಡಲು ಆತನೇ ನಮ್ಮನ್ನು ಕಳುಹಿಸಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ಆದ್ದರಿಂದ ಲೋಟನು ಹೊರಗೆ ಹೋಗಿ, ತನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳೊಡನೆ ನಿಶ್ಚಿತಾರ್ಥವಾಗಿದ್ದ ಅಳಿಯಂದಿರೊಡನೆ ಮಾತಾಡಿ, “ಬೇಗನೆ ಈ ಪಟ್ಟಣವನ್ನು ಬಿಟ್ಟು ಹೊರಡಿರಿ; ಯೆಹೋವನು ಈ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡುವನು” ಎಂದು ಹೇಳಿದನು. ಲೋಟನ ಈ ಮಾತು ಅವರಿಗೆ ತಮಾಷೆಯಂತೆ ಕಂಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ಸೂರ್ಯೋದಯಕ್ಕಿಂತ ಮೊದಲೇ ಹೊರಡುವಂತೆ ದೇವದೂತರು ಲೋಟನನ್ನು ಒತ್ತಾಯಿಸಿ, “ಈ ನಗರವನ್ನು ನಾಶಗೊಳಿಸಲಾಗುವುದು. ಆದ್ದರಿಂದ ನಿನ್ನ ಹೆಂಡತಿಯನ್ನೂ ನಿನ್ನ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನೂ ಕರೆದುಕೊಂಡು ಈ ಸ್ಥಳದಿಂದ ಓಡಿಹೋಗು, ಆಗ ನೀನು ಈ ನಗರದೊಡನೆ ನಾಶವಾಗುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ಆದರೆ ಲೋಟನು ಗಲಿಬಿಲಿಗೊಂಡು ತಡಮಾಡಲು ಆ ಇಬ್ಬರು ಪುರುಷರು ಲೋಟನನ್ನೂ ಅವನ ಹೆಂಡತಿಯನ್ನೂ ಅವನ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನೂ ಕೈಹಿಡಿದುಕೊಂಡು ನಗರದ ಹೊರಕ್ಕೆ ಸುರಕ್ಷಿತವಾಗಿ ತಂದುಬಿಟ್ಟರು. ಹೀಗೆ ಯೆಹೋವನು ಲೋಟನಿಗೂ ಅವನ ಕುಟುಂಬದವರಿಗೂ ದಯೆತೋರಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ಅವರು ನಗರದ ಹೊರಕ್ಕೆ ಬಂದ ಮೇಲೆ ಆ ಪುರುಷರಲ್ಲಿ ಒಬ್ಬನು, “ಈಗ ಓಡಿಹೋಗಿ ನಿಮ್ಮ ಪ್ರಾಣವನ್ನು ಕಾಪಾಡಿಕೊಳ್ಳಿ; ನಗರದ ಕಡೆಗೆ ತಿರುಗಿ ನೋಡಬೇಡಿ; ಕಣಿವೆಯ ಯಾವ ಸ್ಥಳದಲ್ಲೂ ನಿಂತುಕೊಳ್ಳಬೇಡಿ; ತಪ್ಪಿಸಿಕೊಂಡು ಬೆಟ್ಟಗಳಿಗೆ ಓಡಿಹೋಗಿರಿ; ಇಲ್ಲವಾದರೆ, ಈ ನಗರದೊಡನೆ ನೀವೂ ನಾಶವಾಗುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ಆದರೆ ಲೋಟನು ಆ ಪುರುಷರಿಗೆ, “ಸ್ವಾಮಿಗಳೇ, ದಯವಿಟ್ಟು ಬಹುದೂರದವರೆಗೆ ಓಡಿಹೋಗುವಂತೆ ನಮ್ಮನ್ನು ಒತ್ತಾಯಿಸಬೇಡಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ನಿಮ್ಮ ಸೇವಕನಾದ ನನಗೆ ಮಹಾಕರುಣೆಯನ್ನು ತೋರಿ ನನ್ನನ್ನು ಕಾಪಾಡಿದ್ದೀರಿ. ಆದರೆ ನಾನು ಬೆಟ್ಟಗಳವರೆಗೂ ಓಡಿಹೋಗಲಾರೆ. ನಾನು ನಿಧಾನವಾಗಿ ಹೋಗುವುದಾದರೆ ಕೇಡು ಸಂಭವಿಸಿ ಕೊಲ್ಲಲ್ಪಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ಅಗೋ, ಅಲ್ಲಿ ಒಂದು ಚಿಕ್ಕ ಊರಿದೆ. ಆ ಊರಿಗೆ ಓಡಿಹೋಗಲು ನನಗೆ ಅಪ್ಪಣೆಕೊಡಿ. ನಾನು ಅಲ್ಲಿಗೆ ಓಡಿಹೋಗಿ ಸುರಕ್ಷಿತವಾಗಿರುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ಆ ಪುರುಷನು ಲೋಟನಿಗೆ, “ಆಗಲಿ, ನಿನಗೆ ಅಪ್ಪಣೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ನಾನು ಆ ಊರನ್ನು ನಾಶಮಾಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ಆದರೆ ಅಲ್ಲಿಗೆ ಬೇಗನೆ ಓಡಿಹೋಗು, ನೀನು ಆ ಊರಿಗೆ ಸುರಕ್ಷಿತವಾಗಿ ಸೇರುವತನಕ ನಾನು ಸೊದೋಮನ್ನು ನಾಶಗೊಳಿಸಲಾಗುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. (ಆ ಊರಿಗೆ ಚೋಗರ್ ಎಂದು ಕರೆಯಲಾಯಿತು; ಯಾಕೆಂದರೆ ಅದು ಚಿಕ್ಕ ಊರು.) ");
INSERT INTO kan2010_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ಸೂರ್ಯೋದಯವಾಗುವಷ್ಟರಲ್ಲಿ ಲೋಟನು ಚೋಗರಿಗೆ ಪ್ರವೇಶಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ಆಗ ಯೆಹೋವನು ಸೊದೋಮ್ ಮತ್ತು ಗೊಮೋರ ಪಟ್ಟಣಗಳ ಮೇಲೆ ಆಕಾಶದಿಂದ ಉರಿಯುವ ಗಂಧಕದ ಮಳೆಯನ್ನು ಸುರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ಹೀಗೆ ಯೆಹೋವನು ಆ ಎರಡು ನಗರಗಳನ್ನು ನಾಶಮಾಡಿದನು; ಇಡೀ ಕಣಿವೆಯನ್ನೂ ಅದರಲ್ಲಿ ಬೆಳೆಯುತ್ತಿದ್ದ ಸಸ್ಯಗಳನ್ನೂ ನಗರಗಳಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಜನರನ್ನೂ ನಾಶಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ಅವರು ಓಡಿಹೋಗುತ್ತಿರುವಾಗ ಲೋಟನ ಹೆಂಡತಿ ನಗರದ ಕಡೆಗೆ ಹಿಂತಿರುಗಿ ನೋಡಿದಳು. ಆ ಕೂಡಲೇ ಆಕೆಯು ಉಪ್ಪಿನ ಕಂಬವಾದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ಅಂದು ಮುಂಜಾನೆ ಅಬ್ರಹಾಮನು ಎದ್ದು ತಾನು ಯೆಹೋವನ ಮುಂದೆ ನಿಂತುಕೊಂಡಿದ್ದ ಸ್ಥಳಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ಅಬ್ರಹಾಮನು ಸೊದೋಮ್ ಮತ್ತು ಗೊಮೋರ ಪಟ್ಟಣಗಳ ಕಡೆಗೂ ಕಣಿವೆ ಪ್ರದೇಶದ ಕಡೆಗೂ ನೋಡಿದಾಗ ಆ ಪ್ರದೇಶದಿಂದ ಹೊಗೆ ಮೇಲೇರುತ್ತಿರುವುದನ್ನು ಕಂಡನು; ಧಗಧಗಿಸುವ ಬೆಂಕಿಯಿಂದ ಬರುವ ಹೊಗೆಯಂತೆ ಅದು ಕಂಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ದೇವರು ಆ ಸೀಮೆಯ ನಗರಗಳನ್ನು ನಾಶಮಾಡಿದರೂ ಅಬ್ರಹಾಮನನ್ನು ಜ್ಞಾಪಿಸಿಕೊಂಡು ಲೋಟನ ಪ್ರಾಣವನ್ನು ಉಳಿಸಿದನು; ಆದರೆ ಲೋಟನು ವಾಸಿಸುತ್ತಿದ್ದ ನಗರವನ್ನು ನಾಶಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ಚೋಗರ್ ಊರಿನಲ್ಲಿ ವಾಸಮಾಡಿಕೊಂಡಿರಲು ಲೋಟನಿಗೆ ಹೆದರಿಕೆಯಾಯಿತು. ಆದ್ದರಿಂದ ಅವನು ಮತ್ತು ಅವನ ಹೆಣ್ಣುಮಕ್ಕಳು ಬೆಟ್ಟಪ್ರದೇಶಕ್ಕೆ ಹೋಗಿ ಗುಹೆಯೊಂದರಲ್ಲಿ ವಾಸಿಸತೊಡಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ಒಂದು ದಿನ ಹಿರಿಯ ಮಗಳು ತನ್ನ ತಂಗಿಗೆ, “ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ಸ್ತ್ರೀಯರೂ ಪುರುಷರೂ ಮದುವೆಯಾಗುತ್ತಾರೆ. ಆದರೆ ಇಲ್ಲಿ ನಾವು ಮದುವೆಯಾಗಲು ಯಾವ ಗಂಡಸರೂ ಇಲ್ಲ. ನಮ್ಮ ತಂದೆಗೂ ವಯಸ್ಸಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ಆದರೆ ನಾವು ಮಕ್ಕಳನ್ನು ನಮ್ಮ ತಂದೆಯಿಂದಲೇ ಪಡೆದುಕೊಳ್ಳೋಣ. ಆಗ ನಮ್ಮ ಕುಟುಂಬ ಕೊನೆಗೊಳ್ಳುವುದಿಲ್ಲ. ನಮ್ಮ ತಂದೆಯನ್ನು ಮತ್ತನನ್ನಾಗಿ ಮಾಡಿ ಅವನೊಂದಿಗೆ ಮಲಗಿಕೊಳ್ಳೋಣ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ಆ ರಾತ್ರಿ ಅವರು ತಮ್ಮ ತಂದೆಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸಿ ಅಮಲೇರಿಸಿದರು. ಬಳಿಕ ಹಿರಿಯ ಮಗಳು ತನ್ನ ತಂದೆಯ ಹಾಸಿಗೆಗೆ ಹೋಗಿ ಅವನೊಂದಿಗೆ ಮಲಗಿಕೊಂಡಳು. ಲೋಟನು ಮತ್ತನಾಗಿದ್ದುದರಿಂದ ಆಕೆ ಅವನೊಂದಿಗೆ ಮಲಗಿಕೊಂಡದ್ದು ಅವನಿಗೆ ತಿಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ಮರುದಿನ, ಹಿರಿಯ ಮಗಳು ತನ್ನ ತಂಗಿಗೆ, “ಕಳೆದ ರಾತ್ರಿ ನಾನು ನನ್ನ ತಂದೆಯೊಂದಿಗೆ ಮಲಗಿಕೊಂಡೆ. ಈ ರಾತ್ರಿಯೂ ಅವನನ್ನು ದ್ರಾಕ್ಷಾರಸ ಕುಡಿಸಿ ಅಮಲೇರಿಸೋಣ. ಆಮೇಲೆ ನೀನು ಹಾಸಿಗೆಯ ಮೇಲೆ ಅವನೊಂದಿಗೆ ಮಲಗಿಕೊಳ್ಳಬಹುದು. ಹೀಗೆ ನಾವು ಮಕ್ಕಳನ್ನು ನಮ್ಮ ತಂದೆಯಿಂದಲೇ ಪಡೆದುಕೊಳ್ಳೋಣ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ಆ ರಾತ್ರಿಯೂ ಅವರು ತಮ್ಮ ತಂದೆಗೆ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಸಿ ಅಮಲೇರಿಸಿದರು. ಆಮೇಲೆ ಚಿಕ್ಕಮಗಳು ಅವನ ಹಾಸಿಗೆಗೆ ಹೋಗಿ ಅವನೊಂದಿಗೆ ಮಲಗಿಕೊಂಡಳು. ಆಕೆ ಮಲಗಿಕೊಂಡದ್ದು ಲೋಟನಿಗೆ ತಿಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ಹೀಗೆ ಲೋಟನ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳು ತಂದೆಯಿಂದಲೇ ಗರ್ಭಧರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ಹಿರಿಯ ಮಗಳು ಗಂಡುಮಗನನ್ನು ಹೆತ್ತಳು. ಆಕೆ ಅವನಿಗೆ ಮೋವಾಬ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಈಗ ಜೀವಿಸುತ್ತಿರುವ ಎಲ್ಲಾ ಮೋವಾಬ್ಯರಿಗೆ ಮೋವಾಬನೇ ಮೂಲಪುರುಷ. ");
INSERT INTO kan2010_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ಚಿಕ್ಕಮಗಳು ಸಹ ಗಂಡುಮಗುವನ್ನು ಹೆತ್ತಳು. ಆಕೆ ತನ್ನ ಮಗನಿಗೆ ಬೆನಮ್ಮಿ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಈಗ ಜೀವಿಸುತ್ತಿರುವ ಅಮ್ಮೋನಿಯರಿಗೆ ಬೆನಮ್ಮಿಯೇ ಮೂಲಪುರುಷ. ");
INSERT INTO kan2010_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ಅಬ್ರಹಾಮನು ಅಲ್ಲಿಂದ ಹೊರಟು ನೆಗೆವ್‌ಗೆ ಪ್ರಯಾಣಮಾಡಿ ಕಾದೇಶಿಗೂ ಶೂರಿಗೂ ನಡುವೆ ಇದ್ದ ಗೆರಾರ್ ನಗರದಲ್ಲಿ ನೆಲೆಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ಅಬ್ರಹಾಮನು ಗೆರಾರಿನಲ್ಲಿದ್ದಾಗ ಸಾರಳು ತನಗೆ ತಂಗಿಯಾಗಬೇಕೆಂದು ಹೇಳಿಕೊಂಡನು. ಗೆರಾರಿನ ರಾಜನಾಗಿದ್ದ ಅಬೀಮೆಲೆಕನು ಇದನ್ನು ಕೇಳಿ ಸಾರಳನ್ನು ಪಡೆದುಕೊಳ್ಳಲು ಬಯಸಿದನು. ಬಳಿಕ ಅವನು ಕೆಲವು ಸೇವಕರನ್ನು ಕಳುಹಿಸಿ ಆಕೆಯನ್ನು ಕರೆಯಿಸಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ಆದರೆ ಅಂದು ರಾತ್ರಿ ದೇವರು ಅಬೀಮೆಲೆಕನೊಡನೆ ಕನಸಿನಲ್ಲಿ ಮಾತಾಡಿ, “ನೀನು ಸಾಯುವೆ. ನೀನು ತೆಗೆದುಕೊಂಡಿರುವ ಆ ಸ್ತ್ರೀಗೆ ಮದುವೆಯಾಗಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ಅಬೀಮೆಲೆಕನು ಇನ್ನೂ ಸಾರಳೊಡನೆ ಮಲಗಿಕೊಂಡಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಅಬೀಮೆಲೆಕನು, “ಸ್ವಾಮಿ, ನಾನು ತಪ್ಪಿತಸ್ಥನಲ್ಲ. ಒಬ್ಬ ನಿರಪರಾಧಿಯನ್ನು ನೀನು ಕೊಲ್ಲುವೆಯಾ? ");
INSERT INTO kan2010_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‘ಈಕೆ ನನಗೆ ತಂಗಿಯಾಗಬೇಕು’ ಎಂದು ಅಬ್ರಹಾಮನೇ ಹೇಳಿದನು. ಅಲ್ಲದೆ ಈಕೆಯೂ ‘ಅವನು ನನ್ನ ಸಹೋದರ’ ಎಂದು ಹೇಳಿದಳು. ನಾನು ನಿರಪರಾಧಿ. ನಾನು ಮಾಡಲಿದ್ದ ತಪ್ಪು ನನಗೆ ತಿಳಿದಿರಲಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ಆಗ ದೇವರು ಅಬೀಮೆಲೆಕನಿಗೆ ಕನಸಿನಲ್ಲಿ, “ಹೌದು, ನೀನು ನಿರಪರಾಧಿಯೆಂದು ನನಗೆ ಗೊತ್ತಿದೆ. ನೀನು ಮಾಡಲಿದ್ದ ತಪ್ಪು ನಿನಗೆ ತಿಳಿದಿರಲಿಲ್ಲವೆಂದೂ ನನಗೆ ಗೊತ್ತಿದೆ. ಆದ್ದರಿಂದಲೇ ನಾನು ನಿನ್ನನ್ನು ಕಾಪಾಡಿದೆ. ನನಗೆ ವಿರೋಧವಾಗಿ ಪಾಪಮಾಡಲು ನಾನು ನಿನಗೆ ಅವಕಾಶ ಕೊಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ಆದ್ದರಿಂದ ಅಬ್ರಹಾಮನಿಗೆ ಅವನ ಹೆಂಡತಿಯನ್ನು ಒಪ್ಪಿಸಿಬಿಡು. ಅಬ್ರಹಾಮನು ಪ್ರವಾದಿಯಾಗಿರುವುದರಿಂದ ನಿನಗೋಸ್ಕರ ಪ್ರಾರ್ಥಿಸುವನು, ಆಗ ನೀನು ಬದುಕಿಕೊಳ್ಳುವೆ. ನೀನು ಸಾರಳನ್ನು ಅಬ್ರಹಾಮನಿಗೆ ಹಿಂತಿರುಗಿಸದಿದ್ದರೆ, ನೀನೂ ನಿನ್ನ ಇಡೀ ಕುಟುಂಬದವರೂ ಸಾಯುವಿರೆಂದು ನಾನು ಪ್ರಮಾಣ ಮಾಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ಆದ್ದರಿಂದ ಮರುದಿನ ಮುಂಜಾನೆ, ಅಬೀಮೆಲೆಕನು ತನ್ನ ಸೇವಕರನ್ನೆಲ್ಲ ಕರೆಸಿ ತನ್ನ ಕನಸನ್ನು ತಿಳಿಸಿದನು. ಅವರಿಗೆಲ್ಲಾ ತುಂಬ ಭಯವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ಆಮೇಲೆ ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನನ್ನು ಕರೆಸಿ, “ನೀನು ನಮಗೆ ಹೀಗೇಕೆ ಮಾಡಿದೆ? ನಿನಗೆ ವಿರೋಧವಾಗಿ ನಾನೇನು ಮಾಡಿದೆ? ಆಕೆ ತಂಗಿಯಾಗಬೇಕೆಂದು ನೀನೇಕೆ ಸುಳ್ಳು ಹೇಳಿದೆ? ನೀನು ನನ್ನ ರಾಜ್ಯಕ್ಕೆ ಕೇಡನ್ನು ಬರಮಾಡಿರುವೆ. ನೀನು ಹೀಗೆ ಮಾಡಬಾರದಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ನೀನು ಭಯಪಟ್ಟಿದ್ದೇಕೆ? ನನಗೆ ಹೀಗೆ ಮಾಡಿದ್ದೇಕೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ಅಬ್ರಹಾಮನು ಅವನಿಗೆ, “ನನಗೆ ಹೆದರಿಕೆಯಾಗಿತ್ತು. ಈ ಸ್ಥಳದವರಿಗೆ ದೇವರಲ್ಲಿ ಭಯಭಕ್ತಿಯಿಲ್ಲವೆಂದು ನಾನು ಭಾವಿಸಿಕೊಂಡೆ. ಯಾರಾದರೂ ನನ್ನನ್ನು ಕೊಂದು ಸಾರಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಹುದೆಂದು ಯೋಚಿಸಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ಆಕೆ ನನ್ನ ಹೆಂಡತಿಯೇನೋ ನಿಜ, ಆದರೆ ಆಕೆ ನನಗೆ ತಂಗಿಯೂ ಆಗಬೇಕು. ಆಕೆ ನನ್ನ ತಂದೆಯ ಮಗಳು; ನನ್ನ ತಾಯಿಯ ಮಗಳಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ದೇವರು ನನ್ನನ್ನು ತಂದೆಯ ಮನೆಯಿಂದ ಹೊರಡಿಸಿ ಪರಸ್ಥಳಗಳಲ್ಲಿ ಸಂಚರಿಸುವಂತೆ ಮಾಡಿದ್ದರಿಂದ ನಾನು ಸಾರಳಿಗೆ, ‘ನಿನ್ನಿಂದ ನನಗೆ ಒಂದು ಉಪಕಾರವಾಗಬೇಕು. ಅದೇನೆಂದರೆ ನೀನು ನನ್ನನ್ನು ಅಣ್ಣನೆಂಬುದಾಗಿ ಹೇಳಬೇಕು ಎಂದು ಆಕೆಗೆ ತಿಳಿಸಿದೆನು’” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ಆಗ ನಡೆದ ಸಂಗತಿಯನ್ನೆಲ್ಲ ಅರ್ಥಮಾಡಿಕೊಂಡು ಸಾರಳನ್ನು ಅಬ್ರಹಾಮನಿಗೆ ಒಪ್ಪಿಸಿದನು; ಅಲ್ಲದೆ ಕುರಿಗಳನ್ನೂ ದನಗಳನ್ನೂ ಸೇವಕಸೇವಕಿಯರನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನಿಗೆ, “ಇಗೋ, ಇದು ನನ್ನ ದೇಶ. ನಿನಗೆ ಇಷ್ಟವಾದ ಸ್ಥಳದಲ್ಲಿ ವಾಸಮಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ಅಬೀಮೆಲೆಕನು ಸಾರಳಿಗೆ, “ನಾನು ನಿನ್ನ ಅಣ್ಣನಾದ ಅಬ್ರಹಾಮನಿಗೆ ಒಂದು ಸಾವಿರ ಬೆಳ್ಳಿಯ ನಾಣ್ಯಗಳನ್ನು ಕೊಡುವೆ. ನಡೆದ ಈ ಘಟನೆಗಳಿಗೆ ಇದು ಪ್ರಾಯಶ್ಚಿತ್ತವಾಗಿದೆ. ನೀನು ನಿಷ್ಕಳಂಕಳೆಂದು ಇದು ಪ್ರತಿಯೊಬ್ಬರಿಗೂ ಸಾಕ್ಷಿಯಾಗಿರಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","ದೇವರು ಅಬೀಮೆಲೆಕನ ಕುಟುಂಬದಲ್ಲಿರುವ ಎಲ್ಲ ಸ್ತ್ರೀಯರನ್ನು ಬಂಜೆಯರನ್ನಾಗಿ ಮಾಡಿದ್ದನು. ಅಬ್ರಹಾಮನ ಹೆಂಡತಿಯಾದ ಸಾರಳನ್ನು ಅಬೀಮೆಲೆಕನು ಕರೆಸಿಕೊಂಡಿದ್ದೇ ಅದಕ್ಕೆ ಕಾರಣ. ಅಬ್ರಹಾಮನು ದೇವರಲ್ಲಿ ಪ್ರಾರ್ಥಿಸಿದಾಗ ದೇವರು ಅಬೀಮೆಲೆಕನನ್ನೂ ಅವನ ಹೆಂಡತಿಯನ್ನೂ ಸೇವಕಿಯರನ್ನೂ ಗುಣಪಡಿಸಿದ್ದರಿಂದ ಅವರಿಗೆ ಮಕ್ಕಳಾದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ಯೆಹೋವನು ಸಾರಳಿಗೆ ಮಾಡಿದ ವಾಗ್ದಾನವನ್ನು ಮರೆಯದೆ ಈಡೇರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ಸಾರಳು ವೃದ್ಧನಾಗಿದ್ದ ಅಬ್ರಹಾಮನಿಂದ ಗರ್ಭಿಣಿಯಾಗಿ, ಒಂದು ಗಂಡುಮಗುವನ್ನು ಹೆತ್ತಳು. ದೇವರು ವಾಗ್ದಾನ ಮಾಡಿದಂತೆಯೇ ಈ ಸಂಗತಿಗಳೆಲ್ಲ ತಕ್ಕಕಾಲದಲ್ಲಿ ನಡೆದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ಅಬ್ರಹಾಮನು ಸಾರಳಲ್ಲಿ ತನ್ನಿಂದ ಹುಟ್ಟಿದ ಮಗನಿಗೆ ಇಸಾಕ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ಇಸಾಕನಿಗೆ ಎಂಟು ದಿನಗಳಾಗಿದ್ದಾಗ, ದೇವರ ಆಜ್ಞೆಗನುಸಾರವಾಗಿ ಅಬ್ರಹಾಮನು ಅವನಿಗೆ ಸುನ್ನತಿ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ಅಬ್ರಹಾಮನಿಗೆ ನೂರು ವರ್ಷಗಳಾಗಿದ್ದಾಗ, ಅವನ ಮಗನಾದ ಇಸಾಕನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ಸಾರಳು, “ದೇವರು, ನನ್ನನ್ನು ನಗುವಂತೆ ಮಾಡಿದ್ದಾನೆ, ಇದನ್ನು ಕೇಳಿದ ಪ್ರತಿಯೊಬ್ಬರು ನನ್ನೊಡನೆ ನಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ಅಬ್ರಹಾಮನಿಗೆ ಸಾರಳಲ್ಲಿ ಮಗನು ಹುಟ್ಟುತ್ತಾನೆಂದು ಯಾರೂ ಯೋಚಿಸಿರಲಿಲ್ಲ. ಅಬ್ರಹಾಮನು ವೃದ್ಧನಾಗಿದ್ದರೂ ಈಗ ನಾನು ಅವನಿಗೆ ಒಬ್ಬ ಮಗನನ್ನು ಕೊಟ್ಟಿದ್ದೇನೆ” ಅಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ಇಸಾಕನು ಬೆಳೆದು ಊಟಮಾಡುವಷ್ಟು ದೊಡ್ಡವನಾದನು. ಆಗ ಅಬ್ರಹಾಮನು ಒಂದು ದೊಡ್ಡ ಔತಣವನ್ನು ಮಾಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ಮೊದಲು, ಈಜಿಪ್ಟಿನ ಸೇವಕಿಯಾದ ಹಾಗರಳಲ್ಲಿ ಒಬ್ಬ ಮಗನು ಹುಟ್ಟಿದ್ದನು. ಅವನಿಗೂ ಅಬ್ರಹಾಮನು ತಂದೆಯಾಗಿದ್ದನು. ಆದರೆ ಆ ಮೊದಲನೆ ಮಗನು ಇಸಾಕನಿಗೆ ತೊಂದರೆ ಕೊಡುವುದನ್ನು ಸಾರಳು ಗಮನಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ಸಾರಳು ಅಬ್ರಹಾಮನಿಗೆ, “ಆ ಸೇವಕಿಯನ್ನೂ ಅವಳ ಮಗನನ್ನೂ ಕಳುಹಿಸಿಬಿಡು. ನಾವು ಸತ್ತಾಗ ನಮ್ಮ ಆಸ್ತಿಯನ್ನೆಲ್ಲ ನಮ್ಮ ಮಗನಾದ ಇಸಾಕನೇ ಪಡೆದುಕೊಳ್ಳಲಿ; ನಮ್ಮ ಆಸ್ತಿಯಲ್ಲಿ ಇಸಾಕನೊಡನೆ ಅವನು ಪಾಲುಹೊಂದುವುದು ನನಗೆ ಇಷ್ಟವಿಲ್ಲ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ಅಬ್ರಹಾಮನಿಗೆ ತುಂಬ ದುಃಖವಾಯಿತು. ಅವನು ತನ್ನ ಮಗನಾದ ಇಷ್ಮಾಯೇಲನ ಬಗ್ಗೆ ಚಿಂತಿಸತೊಡಗಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ಆದರೆ ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ, “ಆ ಹುಡುಗನ ಕುರಿತಾಗಲಿ ಸೇವಕಿಯ ಕುರಿತಾಗಲಿ ಚಿಂತೆಮಾಡಬೇಡ. ಸಾರಳ ಇಷ್ಟದಂತೆ ಮಾಡು. ಇಸಾಕನೊಬ್ಬನೇ ಬಾಧ್ಯಸ್ತನಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ಆದರೆ ನಿನ್ನ ಸೇವಕಿಯ ಮಗನನ್ನು ಸಹ ನಾನು ಆಶೀರ್ವದಿಸುವೆನು. ಅವನು ನಿನ್ನ ಮಗನು. ಆದ್ದರಿಂದ ಅವನಿಂದಲೂ ನಾನು ದೊಡ್ಡ ಜನಾಂಗವನ್ನು ಉಂಟುಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ಮರುದಿನ ಮುಂಜಾನೆ, ಅಬ್ರಹಾಮನು ಸ್ವಲ್ಪ ಆಹಾರವನ್ನು ಮತ್ತು ಸ್ವಲ್ಪ ನೀರನ್ನು ತೆಗೆದು ಹಾಗರಳಿಗೆ ಕೊಟ್ಟನು. ಹಾಗರಳು ಅವುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ತನ್ನ ಮಗನೊಡನೆ ಅಲ್ಲಿಂದ ಹೊರಟುಹೋದಳು. ಹಾಗರಳು ಆ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಬೇರ್ಷೆಬದ ಮರಳುಗಾಡಿನಲ್ಲಿ ಅಲೆಯತೊಡಗಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ಸ್ವಲ್ಪ ಸಮಯದ ನಂತರ, ಇದ್ದ ನೀರೆಲ್ಲಾ ಮುಗಿದುಹೋಯಿತು. ಕುಡಿಯುವುದಕ್ಕೆ ಏನೂ ಇರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಹಾಗರಳು ತನ್ನ ಮಗನನ್ನು ಪೊದೆಯ ಕೆಳಗೆ ಮಲಗಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ಹಾಗರಳು ಸ್ವಲ್ಪ ದೂರ ನಡೆದುಹೋಗಿ ಕುಳಿತುಕೊಂಡು ತನ್ನ ಮಗನು ಸಾಯುವುದನ್ನು ನೋಡಲಾರದೆ ಅಳತೊಡಗಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ಮಗುವಿನ ಕೂಗು ದೇವರಿಗೆ ಕೇಳಿಸಿತು. ಆಗ ದೇವದೂತನು ಆಕಾಶದಿಂದ ಆಕೆಯನ್ನು ಕರೆದು, “ಹಾಗರಳೇ, ನಿನಗೇನಾಯಿತು? ಭಯಪಡಬೇಡ; ಮಗುವಿನ ಕೂಗನ್ನು ಯೆಹೋವನು ಕೇಳಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ಹೋಗಿ ಮಗುವನ್ನು ಎತ್ತಿಕೊ. ಅವನಿಂದ ದೊಡ್ಡ ಜನಾಂಗವಾಗುವಂತೆ ಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ಆಮೇಲೆ ದೇವರು ಹಾಗರಳಿಗೆ ಒಂದು ಬಾವಿ ಕಾಣಿಸುವಂತೆ ಮಾಡಿದನು. ಹಾಗರಳು ಬಾವಿಗೆ ಹೋಗಿ ತನ್ನ ತಿತ್ತಿಯಲ್ಲಿ ನೀರನ್ನು ತುಂಬಿಸಿಕೊಂಡು ಬಂದು ಮಗುವಿಗೆ ಕುಡಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ದೇವರು ಆ ಮಗುವಿನ ಸಂಗಡವಿದ್ದ ಕಾರಣ ಆ ಮಗುವು ಬೆಳೆದು ದೊಡ್ಡವನಾದನು; ಕಾಡಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದು ಚತುರ ಬಿಲ್ಲುಗಾರನಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ಅವನ ತಾಯಿಯು ಅವನಿಗೆ ಈಜಿಪ್ಟಿನ ಹುಡುಗಿಯನ್ನು ತಂದು ಮದುವೆ ಮಾಡಿಸಿದಳು. ಅವರು ಪಾರಾನ್ ಕಾಡಿನಲ್ಲಿ ತಮ್ಮ ವಾಸವನ್ನು ಮುಂದುವರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ಆಮೇಲೆ ಅಬೀಮೆಲೆಕನು ಮತ್ತು ಫೀಕೋಲನು ಅಬ್ರಹಾಮನೊಡನೆ ಮಾತಾಡಿದರು. ಫೀಕೋಲನು ಅಬೀಮೆಲೆಕನ ಸೈನ್ಯಾಧಿಕಾರಿಯಾಗಿದ್ದನು. ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನಿಗೆ, “ನೀನು ಮಾಡುವ ಪ್ರತಿಯೊಂದರಲ್ಲೂ ದೇವರು ನಿನ್ನೊಡನೆ ಇದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ಆದ್ದರಿಂದ ನೀನು ನನ್ನೊಡನೆ ಮತ್ತು ನನ್ನ ಮಕ್ಕಳೊಡನೆ ನ್ಯಾಯವಾಗಿ ನಡೆದುಕೊಳ್ಳುವುದಾಗಿ ದೇವರ ಮೇಲೆ ಪ್ರಮಾಣಮಾಡು. ನನಗೂ ಮತ್ತು ನೀನು ವಾಸಿಸುತ್ತಿರುವ ಈ ನಾಡಿಗೂ ದಯೆತೋರುವುದಾಗಿ ನೀನು ಪ್ರಮಾಣಮಾಡು. ನಾನು ನಿನಗೆ ದಯೆತೋರಿದಂತೆ ನೀನೂ ನನಗೆ ದಯೆತೋರುವುದಾಗಿ ಪ್ರಮಾಣಮಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ಅದಕ್ಕೆ ಅಬ್ರಹಾಮನು, “ನೀನು ನನ್ನನ್ನು ನೋಡಿಕೊಂಡಂತೆ ನಾನೂ ನಿನ್ನನ್ನು ನೋಡಿಕೊಳ್ಳುವೆನು” ಎಂದು ಪ್ರಮಾಣಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ಆಮೇಲೆ ಅಬ್ರಹಾಮನು ಅಬೀಮೆಲೆಕನಿಗೆ, “ನಿನ್ನ ಸೇವಕರು ನೀರಿದ್ದ ಒಂದು ಬಾವಿಯನ್ನು ವಶಪಡಿಸಿಕೊಂಡಿದ್ದಾರೆ” ಎಂದು ದೂರು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ಅದಕ್ಕೆ ಅಬೀಮೆಲೆಕನು, “ಅದನ್ನು ಯಾರು ಮಾಡಿದರೋ ನನಗೆ ಗೊತ್ತಿಲ್ಲ. ಇಂದಿನವರೆಗೂ ನೀನು ಇದನ್ನು ನನಗೆ ಹೇಳಲೇ ಇಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ಆಗ ಅಬ್ರಹಾಮನು ಮತ್ತು ಅಬೀಮೆಲೆಕನು ಒಂದು ಒಪ್ಪಂದವನ್ನು ಮಾಡಿಕೊಂಡರು. ಅಬ್ರಹಾಮನು ಅವನಿಗೆ ಕೆಲವು ದನಕುರಿಗಳನ್ನು ಒಪ್ಪಂದದ ಗುರುತಾಗಿ ಕೊಟ್ಟನು; ");
INSERT INTO kan2010_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ಅಲ್ಲದೆ ಅಬ್ರಹಾಮನು ಮಂದೆಯ ಏಳು ಹೆಣ್ಣು ಕುರಿಮರಿಗಳನ್ನು ಪ್ರತ್ಯೇಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ಅಬೀಮೆಲೆಕನು ಅಬ್ರಹಾಮನಿಗೆ, “ಈ ಏಳು ಕುರಿಗಳನ್ನು ಇಲ್ಲಿ ಇರಿಸಿರುವುದೇಕೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ಅಬ್ರಹಾಮನು “ಆ ಬಾವಿಯನ್ನು ತೋಡಿಸಿದವನು ನಾನೇ ಎಂಬುದಕ್ಕೆ ಸಾಕ್ಷಿಯಾಗಿ ನೀನು ಈ ಕುರಿಗಳನ್ನು ನನ್ನಿಂದ ಸ್ವೀಕರಿಸಿಕೊಳ್ಳಬೇಕು” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ಅವರು ಆ ಸ್ಥಳದಲ್ಲಿ ಒಪ್ಪಂದ ಮಾಡಿಕೊಂಡಿದ್ದರಿಂದ ಆ ಬಾವಿಗೆ ಬೇರ್ಷೆಬ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ಬೇರ್ಷೆಬದಲ್ಲಿ ಒಪ್ಪಂದವನ್ನು ಮಾಡಿಕೊಂಡ ಮೇಲೆ ಅಬೀಮೆಲೆಕನು ಮತ್ತು ಅವನ ಸೈನ್ಯಾಧಿಕಾರಿಯು ಫಿಲಿಷ್ಟಿಯರ ದೇಶಕ್ಕೆ ಹಿಂತಿರುಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ಅಬ್ರಹಾಮನು ಬೇರ್ಷೆಬದಲ್ಲಿ ವಿಶೇಷವಾದ ಒಂದು ಮರವನ್ನು ನೆಟ್ಟನು. ಆ ಸ್ಥಳದಲ್ಲಿ ಅವನು ಸದಾಕಾಲ ಜೀವಿಸುವ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ಅವನು ಬಹುಕಾಲದವರೆಗೆ ಫಿಲಿಷ್ಟಿಯರ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ಇವುಗಳಾದ ಮೇಲೆ, ದೇವರು ಅಬ್ರಹಾಮನ ನಂಬಿಕೆಯನ್ನು ಪರೀಕ್ಷಿಸಲು ನಿರ್ಧರಿಸಿ, “ಅಬ್ರಹಾಮನೇ!” ಎಂದು ಕರೆದನು. ಅಬ್ರಹಾಮನು, “ಇಗೋ ಇದ್ದೇನೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ಆಗ ದೇವರು ಅವನಿಗೆ, “ನಿನಗೆ ಪ್ರಿಯನಾಗಿರುವ ನಿನ್ನ ಒಬ್ಬನೇ ಮಗನಾದ ಇಸಾಕನನ್ನು ಮೊರೀಯ ದೇಶಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋಗು. ನಾನು ನಿನಗೆ ತಿಳಿಸುವ ಬೆಟ್ಟದ ಮೇಲೆ ಅವನನ್ನು ಯಜ್ಞವನ್ನಾಗಿ ಅರ್ಪಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ಮುಂಜಾನೆ ಅಬ್ರಹಾಮನು ಎದ್ದು ಕತ್ತೆಗೆ ತಡಿ ಹಾಕಿಸಿದನು; ಇಸಾಕನನ್ನೂ ಅವನೊಂದಿಗೆ ಇಬ್ಬರು ಸೇವಕರನ್ನೂ ಕರೆದುಕೊಂಡನು; ಯಜ್ಞಕ್ಕಾಗಿ ಕಟ್ಟಿಗೆಯನ್ನು ತೆಗೆದುಕೊಂಡನು. ಬಳಿಕ ದೇವರು ಹೇಳಿದ್ದ ಸ್ಥಳಕ್ಕೆ ಅವರು ಹೊರಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ಅವರು ಮೂರು ದಿನಗಳವರೆಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಅಬ್ರಹಾಮನು ದೃಷ್ಟಿಸಿ ನೋಡಿದಾಗ ತಾವು ಹೋಗಲಿದ್ದ ಸ್ಥಳವು ದೂರದಲ್ಲಿ ಅವನಿಗೆ ಕಾಣಿಸಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ಆಮೇಲೆ ಅಬ್ರಹಾಮನು ತನ್ನ ಸೇವಕರಿಗೆ, “ನೀವು ಇಲ್ಲೇ ಕತ್ತೆಯೊಂದಿಗಿರಿ; ನಾನೂ ನನ್ನ ಮಗನೂ ಆ ಸ್ಥಳಕ್ಕೆ ಹೋಗಿ ಆರಾಧಿಸುತ್ತೇವೆ. ಬಳಿಕ ನಾವು ಹಿಂತಿರುಗಿ ನಿಮ್ಮ ಬಳಿಗೆ ಬರುತ್ತೇವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ಅಬ್ರಹಾಮನು ಯಜ್ಞಕ್ಕಾಗಿ ಕಟ್ಟಿಗೆಯನ್ನು ತೆಗೆದು ತನ್ನ ಮಗನ ಭುಜದ ಮೇಲೆ ಹೊರಿಸಿದನು. ಅಬ್ರಹಾಮನು ವಿಶೇಷವಾದ ಕತ್ತಿಯನ್ನು ಮತ್ತು ಬೆಂಕಿಯನ್ನು ತೆಗೆದುಕೊಂಡನು. ಅವರಿಬ್ಬರೂ ಆರಾಧಿಸುವುದಕ್ಕಾಗಿ ಆ ಸ್ಥಳಕ್ಕೆ ಹೊರಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ಇಸಾಕನು ತನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನಿಗೆ, “ಅಪ್ಪಾ” ಎಂದು ಕರೆದನು. ಅಬ್ರಹಾಮನು, “ಏನು ಮಗನೇ?” ಎಂದು ಉತ್ತರಿಸಿದನು. ಇಸಾಕನು, “ಕಟ್ಟಿಗೆ ಮತ್ತು ಬೆಂಕಿ ನನಗೆ ಕಾಣಿಸುತ್ತಿವೆ. ಆದರೆ ಯಜ್ಞಕ್ಕೆ ಬೇಕಾದ ಕುರಿಮರಿ ಎಲ್ಲಿ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ಅಬ್ರಹಾಮನು, “ಮಗನೇ, ಯಜ್ಞಕ್ಕೆ ಬೇಕಾದ ಕುರಿಮರಿಯನ್ನು ದೇವರೇ ಒದಗಿಸುವನು” ಎಂದು ಹೇಳಿದನು. ಹೀಗೆ ಅಬ್ರಹಾಮನು ಮತ್ತು ಅವನ ಮಗನು ಆ ಸ್ಥಳಕ್ಕೆ ಹೊರಟು ");
INSERT INTO kan2010_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ದೇವರು ತಿಳಿಸಿದ್ದ ಸ್ಥಳಕ್ಕೆ ಬಂದರು. ಅಲ್ಲಿ ಅಬ್ರಹಾಮನು ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿ ಅದರ ಮೇಲೆ ಕಟ್ಟಿಗೆಯನ್ನು ಜೋಡಿಸಿದನು; ಆಮೇಲೆ ಅವನು ತನ್ನ ಮಗನಾದ ಇಸಾಕನ ಕೈಕಾಲುಗಳನ್ನು ಕಟ್ಟಿ ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲಿದ್ದ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ಮಲಗಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ಬಳಿಕ ಅವನು ತನ್ನ ಮಗನನ್ನು ವಧಿಸಲು ಕತ್ತಿಯನ್ನು ಮೇಲೆತ್ತಲು, ");
INSERT INTO kan2010_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ಯೆಹೋವನ ದೂತನು ಪರಲೋಕದಿಂದ, “ಅಬ್ರಹಾಮನೇ, ಅಬ್ರಹಾಮನೇ!” ಎಂದು ಕರೆದನು. ಅಬ್ರಹಾಮನು, “ಇಗೋ ಇದ್ದೇನೆ” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ಯೆಹೋವನ ದೂತನು, “ನಿನ್ನ ಮಗನನ್ನು ವಧಿಸಬೇಡ. ಅವನಿಗೆ ನೋವು ಮಾಡಬೇಡ. ನೀನು ನನಗೋಸ್ಕರವಾಗಿ ನಿನ್ನ ಒಬ್ಬನೇ ಮಗನನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕೂ ಹಿಂಜರಿಯಲಿಲ್ಲ; ಆದ್ದರಿಂದ ನೀನು ದೇವರಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವನೆಂದು ಈಗ ತೋರಿಬಂದಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ಅಬ್ರಹಾಮನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ ಒಂದು ಟಗರನ್ನು ಕಂಡನು. ಆ ಟಗರಿನ ಕೊಂಬುಗಳು ಒಂದು ಪೊದೆಗೆ ಸಿಕ್ಕಿಕೊಂಡಿದ್ದವು. ಕೂಡಲೇ ಅವನು ಹೋಗಿ, ಆ ಟಗರನ್ನು ಎಳೆದುಕೊಂಡು ಬಂದು ದೇವರಿಗೆ ತನ್ನ ಮಗನ ಬದಲಾಗಿ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ಅಲ್ಲದೆ ಆ ಸ್ಥಳಕ್ಕೆ “ಯೆಹೋವ ಯೀರೆ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ಇಂದಿಗೂ ಜನರು, “ಯೆಹೋವನ ಬೆಟ್ಟದಲ್ಲಿ ಒದಗಿಸಲ್ಪಡುವುದು” ಎಂದು ಹೇಳುತ್ತಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ಯೆಹೋವನ ದೂತನು ಆಕಾಶದಿಂದ ಅಬ್ರಹಾಮನನ್ನು ಎರಡನೆ ಸಲ ಕರೆದು ಅವನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“ನೀನು ನನಗೋಸ್ಕರವಾಗಿ ನಿನ್ನ ಒಬ್ಬನೇ ಮಗನನ್ನು ವಧಿಸಲು ಸಿದ್ಧನಾಗಿದ್ದೆ. ಆದ್ದರಿಂದ ನಾನು ನಿನಗೆ ಈ ವಾಗ್ದಾನವನ್ನು ಮಾಡುತ್ತೇನೆ: ");
INSERT INTO kan2010_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ನಾನು ನಿನ್ನನ್ನು ಖಂಡಿತವಾಗಿಯೂ ಆಶೀರ್ವದಿಸುವೆನು; ನಿನ್ನ ಸಂತತಿಯನ್ನು ಖಂಡಿತವಾಗಿಯೂ ಹೆಚ್ಚಿಸುವೆನು; ನಿನ್ನ ಸಂತತಿಯವರನ್ನು ಆಕಾಶದ ನಕ್ಷತ್ರಗಳಂತೆಯೂ ಸಮುದ್ರತೀರದ ಮರಳಿನಂತೆಯೂ ಅಸಂಖ್ಯಾತರನ್ನಾಗಿ ಮಾಡುವೆನು. ಅವರು ತಮ್ಮ ಶತ್ರುಗಳ ಪಟ್ಟಣಗಳನ್ನು ವಶಪಡಿಸಿಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ನೀನು ನನಗೆ ವಿಧೇಯನಾದದ್ದರಿಂದ ನಿನ್ನ ಸಂತತಿಗಳವರ ಮೂಲಕವಾಗಿ ಭೂಮಿಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದು ಜನಾಂಗವೂ ಆಶೀರ್ವಾದ ಹೊಂದುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ತರುವಾಯ ಅಬ್ರಹಾಮನು ತನ್ನ ಸೇವಕರ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಹೋದನು. ಅವರೆಲ್ಲರೂ ಬೇರ್ಷೆಬಕ್ಕೆ ಮರಳಿ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಬಳಿಕ ಅಬ್ರಹಾಮನು ಅಲ್ಲೇ ವಾಸಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ಈ ಸಂಗತಿಗಳೆಲ್ಲ ನಡೆದ ಮೇಲೆ ಅಬ್ರಹಾಮನಿಗೆ ಒಂದು ಸಂದೇಶ ಬಂದಿತು. ಆ ಸಂದೇಶವು ಹೀಗಿತ್ತು: “ನಿನ್ನ ತಮ್ಮನಾದ ನಾಹೋರ ಮತ್ತು ಅವನ ಹೆಂಡತಿಯಾದ ಮಿಲ್ಕ ಈಗ ಮಕ್ಕಳನ್ನು ಹೊಂದಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ಮೊದಲನೆ ಮಗನ ಹೆಸರು ಊಚ್; ಎರಡನೆ ಮಗನ ಹೆಸರು ಬೂಚ್; ಮೂರನೆ ಮಗನ ಹೆಸರು ಕೆಮೂವೇಲ್. ಇವನು ಅರಾಮನ ತಂದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ಇವರಲ್ಲದೆ ಕೆಸೆದ್, ಹಜೋ, ಪಿಲ್ದಾಷ್, ಇದ್ಲಾಫ್, ಬೆತೂವೇಲ್ ಎಂಬವರು ಸಹ ಇದ್ದಾರೆ.” ");
INSERT INTO kan2010_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ಬೆತೂವೇಲನು ರೆಬೆಕ್ಕಳ ತಂದೆ. ಮಿಲ್ಕಳು ಈ ಎಂಟು ಮಕ್ಕಳ ತಾಯಿ; ನಾಹೋರನು ಅವರ ತಂದೆ. ನಾಹೋರನು ಅಬ್ರಹಾಮನ ಸಹೋದರ. ");
INSERT INTO kan2010_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ಇವರಲ್ಲದೆ, ನಾಹೋರನಿಗೆ ಅವನ ಉಪಪತ್ನಿಯಾದ ರೂಮಳಲ್ಲಿ ನಾಲ್ಕು ಮಂದಿ ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ಆ ಗಂಡುಮಕ್ಕಳು ಯಾರಾರೆಂದರೆ: ಟೆಬಹ, ಗಹಮ್, ತಹಷ್ ಮತ್ತು ಮಾಕಾ. ");
INSERT INTO kan2010_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ಸಾರಳು ನೂರಿಪ್ಪತ್ತೇಳು ವರ್ಷ ಬದುಕಿದ್ದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ಅವಳು ಕಾನಾನ್ ದೇಶದ ಹೆಬ್ರೋನೆಂಬ ಕಿರ್ಯತರ್ಬದಲ್ಲಿ ಮರಣಹೊಂದಿದಳು. ಅಬ್ರಹಾಮನು ಅವಳಿಗೋಸ್ಕರ ಅಲ್ಲಿ ಬಹಳವಾಗಿ ಅತ್ತನು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ಬಳಿಕ ಆಕೆಯ ಶವದ ಬಳಿಯಿಂದ ಎದ್ದು ಹಿತ್ತಿಯರ ಬಳಿಗೆ ಹೋಗಿ, ");
INSERT INTO kan2010_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","ಅವರಿಗೆ, “ನಾನು ಈ ನಾಡಿನವನಲ್ಲ. ನಾನು ಇಲ್ಲಿ ಕೇವಲ ಪ್ರವಾಸಿಗನಷ್ಟೇ. ಆದ್ದರಿಂದ ನನ್ನ ಹೆಂಡತಿಯನ್ನು ಸಮಾಧಿಮಾಡಲು ನನಗೆ ಸ್ವಲ್ಪ ಸ್ಥಳ ಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ಹಿತ್ತಿಯರು ಅಬ್ರಹಾಮನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ಸ್ವಾಮೀ, ನೀನು ನಮ್ಮ ಮಹಾನಾಯಕರುಗಳಲ್ಲಿ ಒಬ್ಬನು. ತೀರಿಕೊಂಡ ನಿನ್ನ ಹೆಂಡತಿಯ ಸಮಾಧಿಗಾಗಿ ನಮ್ಮಲ್ಲಿರುವ ಸ್ಮಶಾನಗಳಲ್ಲಿ ಅತ್ಯುತ್ತಮವಾದ ಸ್ಥಳವನ್ನು ನೀನು ತೆಗೆದುಕೊಳ್ಳಬಹುದು. ನಿನ್ನ ಹೆಂಡತಿಯನ್ನು ಸಮಾಧಿಮಾಡಲು ನಮ್ಮಲ್ಲಿ ಯಾರೂ ಅಡ್ಡಿ ಮಾಡುವುದಿಲ್ಲ” ಎಂದು ಉತ್ತರಕೊಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ಅಬ್ರಹಾಮನು ಎದ್ದುನಿಂತು ಅವರಿಗೆ ನಮಸ್ಕರಿಸಿ, ");
INSERT INTO kan2010_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ಅವರಿಗೆ, “ತೀರಿಹೋದ ನನ್ನ ಹೆಂಡತಿಯನ್ನು ಸಮಾಧಿಮಾಡಲು ನೀವು ನಿಜವಾಗಿಯೂ ಸಹಾಯ ಮಾಡಬೇಕೆಂದಿದ್ದರೆ, ಚೋಹರನ ಮಗನಾದ ಎಫ್ರೋನನ ಸಂಗಡ ನನಗೋಸ್ಕರ ಮಾತಾಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ಮಕ್ಪೇಲದ ಗವಿಯನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ನನಗೆ ಇಷ್ಟವಿದೆ. ಅದು ಎಫ್ರೋನನದು. ಅದು ಅವನ ಜಮೀನಿನ ಅಂಚಿನಲ್ಲಿದೆ. ಅದಕ್ಕಾಗುವ ಬೆಲೆಯನ್ನು ನಾನು ಪೂರ್ತಿ ಕೊಡುತ್ತೇನೆ. ನಾನು ಅದನ್ನು ಸಮಾಧಿಯ ಸ್ಥಳಕ್ಕಾಗಿ ಕೊಂಡುಕೊಂಡಿರುವೆ ಎಂಬುದಕ್ಕೆ ನೀವೆಲ್ಲರೂ ಸಾಕ್ಷಿಗಳಾಗಿರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ಎಫೋನನು ಪಟ್ಟಣದ ಬಾಗಿಲ ಬಳಿಯಲ್ಲಿ ಹಿತ್ತಿಯರೊಂದಿಗೆ ಕುಳಿತುಕೊಂಡಿದ್ದನು. ಕೂಡಲೇ ಅವನು ಅಬ್ರಹಾಮನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ಸ್ವಾಮೀ ನಾನು ಆ ಸ್ಥಳವನ್ನೂ ಆ ಗವಿಯನ್ನೂ ನನ್ನ ಜನರ ಎದುರಿನಲ್ಲಿಯೇ ನಿನಗೆ ಕೊಡುವೆನು. ನಿನ್ನ ಹೆಂಡತಿಯನ್ನು ಅಲ್ಲಿ ಸಮಾಧಿಮಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ಆಗ ಅಬ್ರಹಾಮನು ಹಿತ್ತಿಯರಿಗೆ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ಅಬ್ರಹಾಮನು ಜನರೆಲ್ಲರ ಎದುರಿನಲ್ಲಿ ಎಫ್ರೋನನಿಗೆ, “ಆ ಸ್ಥಳಕ್ಕಾಗುವ ಪೂರ್ತಿ ಬೆಲೆಯನ್ನು ನಾನು ನಿನಗೆ ಕೊಡುತ್ತೇನೆ; ನೀನು ಹಣವನ್ನು ತೆಗೆದುಕೊಳ್ಳುವುದಾದರೆ, ನನ್ನ ಹೆಂಡತಿಯನ್ನು ಅಲ್ಲಿ ಸಮಾಧಿಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ಎಫ್ರೋನನು ಅಬ್ರಹಾಮನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ಸ್ವಾಮೀ, ನನ್ನ ಮಾತನ್ನು ಕೇಳು. ಆ ಸ್ಥಳದ ಬೆಲೆ ನಾನೂರು ಬೆಳ್ಳಿ ರೂಪಾಯಿಗಳಷ್ಟೇ. ಆದರೆ ನಿನಗಾಗಲಿ, ನನಗಾಗಲಿ ಆ ನಾನೂರು ರೂಪಾಯಿ ಹೆಚ್ಚೇನೂ ಅಲ್ಲ. ಸ್ಥಳವನ್ನು ತೆಗೆದುಕೊಂಡು ನಿನ್ನ ಹೆಂಡತಿಯನ್ನು ಸಮಾಧಿಮಾಡು” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ಅಬ್ರಹಾಮನು ಎಫ್ರೋನನ ಮಾತಿಗೆ ಒಪ್ಪಿದನು. ಅಬ್ರಹಾಮನು ಆ ಸ್ಥಳಕ್ಕಾಗಿ ನಾನೂರು ಬೆಳ್ಳಿ ರೂಪಾಯಿಗಳನ್ನು ಹಿತ್ತಿಯರ ಎದುರಿನಲ್ಲಿ ಹೇಳಿದ ಎಫ್ರೋನನಿಗೆ ಎಣಿಸಿಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","ಈ ಜಮೀನು ಮಮ್ರೆಗೆ ಪೂರ್ವದಲ್ಲಿರುವ ಮಕ್ಪೇಲದಲ್ಲಿತ್ತು. ಅಬ್ರಹಾಮನು ಆ ಜಮೀನಿಗೂ ಅದರಲ್ಲಿದ್ದ ಗವಿಗೂ ಜಮೀನಿನಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಮರಗಳಿಗೂ ಒಡೆಯನಾದನು. ಎಫ್ರೋನನಿಗೂ ಅಬ್ರಹಾಮನಿಗೂ ಆದ ಒಪ್ಪಂದಕ್ಕೆ ನಗರದವರೆಲ್ಲರು ಸಾಕ್ಷಿಗಳಾದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ಬಳಿಕ ಅಬ್ರಹಾಮನು ತನ್ನ ಹೆಂಡತಿಯಾದ ಸಾರಳನ್ನು ಮಮ್ರೆಗೆ ಸಮೀಪದಲ್ಲಿದ್ದ ಜಮೀನಿನ ಗವಿಯಲ್ಲಿ ಸಮಾಧಿಮಾಡಿದನು. (ಅದು ಕಾನಾನ್ ದೇಶದ ಹೆಬ್ರೋನ್). ");
INSERT INTO kan2010_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ಅಬ್ರಹಾಮನು ಆ ಜಮೀನನ್ನು ಮತ್ತು ಅದರಲ್ಲಿದ್ದ ಗವಿಯನ್ನು ಹಿತ್ತಿಯರಿಂದ ಕೊಂಡುಕೊಂಡನು. ಅದು ಅವನ ಆಸ್ತಿಯಾಯಿತು. ಅವನು ಅದನ್ನು ಸಮಾಧಿ ಸ್ಥಳವನ್ನಾಗಿ ಉಪಯೋಗಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ಅಬ್ರಹಾಮನು ಬಹಳ ವೃದ್ಧನಾದನು. ಯೆಹೋವನು ಅಬ್ರಹಾಮನನ್ನೂ ಅವನು ಮಾಡಿದ ಪ್ರತಿಯೊಂದನ್ನೂ ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ಅಬ್ರಹಾಮನ ಆಸ್ತಿಯನ್ನೆಲ್ಲಾ ನೋಡಿಕೊಳ್ಳಲು ಒಬ್ಬ ಸೇವಕನಿದ್ದನು. ಅಬ್ರಹಾಮನು ಆ ಸೇವಕನನ್ನು ಕರೆದು, “ನನ್ನ ತೊಡೆಯ ಕೆಳಗೆ ನಿನ್ನ ಕೈಯಿಟ್ಟು ನನಗೆ ಪ್ರಮಾಣಮಾಡು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ಕಾನಾನ್ ದೇಶದ ಕನ್ನಿಕೆಯನ್ನು ನನ್ನ ಮಗನು ಮದುವೆಯಾಗದಂತೆ ನೀನು ನೋಡಿಕೊಳ್ಳುವುದಾಗಿಯೂ ");
INSERT INTO kan2010_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ನನ್ನ ಸ್ವದೇಶದಲ್ಲಿರುವ ನನ್ನ ಸ್ವಜನರ ಬಳಿಗೆ ಹೋಗಿ ನನ್ನ ಮಗನಾದ ಇಸಾಕನಿಗೆ ಕನ್ನಿಕೆಯನ್ನು ಹುಡುಕಿ ಕರೆದುಕೊಂಡು ಬರುವುದಾಗಿಯೂ ಭೂಪರಲೋಕಗಳ ದೇವರಾದ ಯೆಹೋವನ ಮೇಲೆ ಪ್ರಮಾಣಮಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ಸೇವಕನು ಅವನಿಗೆ, “ಆ ಕನ್ಯೆಯು ನನ್ನೊಡನೆ ಈ ದೇಶಕ್ಕೆ ಬರಲು ಒಪ್ಪದಿದ್ದರೆ, ನಾನು ನಿನ್ನ ಮಗನನ್ನು ನಿನ್ನ ಸ್ವದೇಶಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋಗಬೇಕೇ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ಅಬ್ರಹಾಮನು ಅವನಿಗೆ, “ಇಲ್ಲ, ಆ ದೇಶಕ್ಕೆ ನನ್ನ ಮಗನನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗಬೇಡ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ಪರಲೋಕದ ದೇವರಾದ ಯೆಹೋವನು ನನ್ನನ್ನು ಸ್ವದೇಶದಿಂದ ಈ ಸ್ಥಳಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ಆ ದೇಶ ನನ್ನ ತಂದೆಗೂ ನನ್ನ ಕುಟುಂಬಕ್ಕೂ ಸೇರಿದೆ. ಆದರೆ ಯೆಹೋವನು ಈ ದೇಶವನ್ನು ನನ್ನ ಸಂತತಿಗೆ ಕೊಡುವುದಾಗಿ ವಾಗ್ದಾನ ಮಾಡಿದನು. ನೀನು ನನ್ನ ಮಗನಿಗೆ ಕನ್ಯೆಯನ್ನು ಹುಡುಕಿ ಕರೆದುಕೊಂಡು ಬರಲು ಸಾಧ್ಯವಾಗುವಂತೆ ಯೆಹೋವನು ತನ್ನ ದೂತನನ್ನು ನಿನ್ನ ಮುಂದೆ ಕಳುಹಿಸಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ಆದರೆ ಆ ಕನ್ಯೆಯು ನಿನ್ನೊಡನೆ ಬರಲು ಇಷ್ಟಪಡದಿದ್ದರೆ, ಈ ಪ್ರಮಾಣದಿಂದ ನೀನು ಬಿಡುಗಡೆಯಾಗುವೆ. ಆದರೆ ನೀನು ನನ್ನ ಮಗನನ್ನು ನನ್ನ ಸ್ವದೇಶಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋಗಕೂಡದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ಆಗ ಆ ಸೇವಕನು ತನ್ನ ಒಡೆಯನಾದ ಅಬ್ರಹಾಮನ ತೊಡೆಯ ಕೆಳಗೆ ಕೈಯಿಟ್ಟು ಪ್ರಮಾಣ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ಆ ಸೇವಕನು ಅಬ್ರಹಾಮನ ಹತ್ತು ಒಂಟೆಗಳನ್ನು ಸಿದ್ಧಮಾಡಿ ಶ್ರೇಷ್ಠವಾದ ಅನೇಕ ಉಡುಗೊರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಮೆಸೊಪೋಟೊಮಿಯಕ್ಕೆ ಬಂದು ನಾಹೋರನು ವಾಸವಾಗಿದ್ದ ಊರನ್ನು ತಲುಪಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ಅವನು ಊರ ಹೊರಗಿದ್ದ ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ಒಂಟೆಗಳನ್ನು ಮಲಗಿಸಿದನು; ಪ್ರತಿಸಾಯಂಕಾಲ ಸ್ತ್ರೀಯರು ನೀರನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗುವುದಕ್ಕಾಗಿ ಆ ಬಾವಿಗೆ ಬರುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ಆ ಸೇವಕನು, “ಯೆಹೋವನೇ, ನೀನು ನನ್ನ ಒಡೆಯನಾದ ಅಬ್ರಹಾಮನ ದೇವರು. ಈ ದಿನ ಅವನ ಮಗನಿಗಾಗಿ ಕನ್ಯೆಯನ್ನು ಕಂಡುಕೊಳ್ಳಲು ಸಹಾಯಮಾಡು. ನನ್ನ ಒಡೆಯನಾದ ಅಬ್ರಹಾಮನಿಗೋಸ್ಕರವಾಗಿಯೇ ಈ ಉಪಕಾರ ಮಾಡು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ನಾನು ಈ ನೀರಿನ ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ನಿಂತಿರುತ್ತೇನೆ; ಈ ಊರಿನ ಯುವತಿಯರು ನೀರನ್ನು ತೆಗೆದುಕೊಳ್ಳಲು ಇಲ್ಲಿಗೆ ಬರುತ್ತಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ಇಸಾಕನಿಗೆ ಯೋಗ್ಯಳಾದ ಕನ್ಯೆಯನ್ನು ಕಂಡುಕೊಳ್ಳಲು ನಾನು ಒಬ್ಬಳಿಗೆ, ‘ದಯವಿಟ್ಟು ನಿನ್ನ ಕೊಡವನ್ನು ಕೆಳಗಿಳಿಸಿ ಕುಡಿಯಲು ನೀರು ಕೊಡು’ ಎನ್ನುವೆ. ಆಕೆ ನನಗೆ, ‘ನೀನೂ ಕುಡಿ, ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ನೀರು ಕೊಡುತ್ತೇನೆ’ ಎಂದರೆ ಆಕೆಯೇ ನಿನ್ನಿಂದ ಆಯ್ಕೆಗೊಂಡ ಯೋಗ್ಯ ಕನ್ಯೆಯೆಂದೂ ನೀನು ನನ್ನ ಒಡೆಯನಿಗೆ ಕರುಣೆ ತೋರಿದೆಯೆಂದೂ ನಾನು ತಿಳಿದುಕೊಳ್ಳುವೆ” ಎಂದು ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ಆ ಸೇವಕನು ಪ್ರಾರ್ಥನೆ ಮಾಡಿ ಮುಗಿಸುವುದಕ್ಕಿಂತ ಮೊದಲೇ ರೆಬೆಕ್ಕ ಎಂಬ ಯುವತಿಯು ಬಾವಿಯ ಬಳಿಗೆ ಬಂದಳು. ರೆಬೆಕ್ಕಳು ಬೆತೂವೇಲನ ಮಗಳು. ಬೆತೂವೇಲನು ಮಿಲ್ಕಳ ಮತ್ತು ನಾಹೋರನ ಮಗನು. ನಾಹೋರನು ಅಬ್ರಹಾಮನ ತಮ್ಮ. ರೆಬೆಕ್ಕಳು ತನ್ನ ಹೆಗಲ ಮೇಲೆ ನೀರಿನ ಕೊಡವನ್ನು ತೆಗೆದುಕೊಂಡು ಬಾವಿಗೆ ಬಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ಆಕೆ ಬಹು ಸುಂದರಿಯಾಗಿಯೂ ಕನ್ನಿಕೆಯಾಗಿಯೂ ಇದ್ದಳು. ಆಕೆ ಬಾವಿಯ ಬಳಿಗೆ ಹೋಗಿ ಕೊಡದಲ್ಲಿ ನೀರನ್ನು ತುಂಬಿಸಿಕೊಂಡಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ಆಗ ಆ ಸೇವಕನು ಅವಳ ಬಳಿಗೆ ಓಡಿಹೋಗಿ, “ದಯವಿಟ್ಟು ಕುಡಿಯಲು ನಿನ್ನ ಕೊಡದಿಂದ ಸ್ವಲ್ಪ ನೀರನ್ನು ಕೊಡು” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ರೆಬೆಕ್ಕಳು ಕೂಡಲೇ ತನ್ನ ಕೊಡವನ್ನು ಹೆಗಲ ಮೇಲಿಂದ ಕೆಳಗಿಳಿಸಿ ಅವನಿಗೆ ಕುಡಿಯಲು ನೀರನ್ನು ಕೊಟ್ಟು, “ಅಯ್ಯಾ, ನೀರನ್ನು ಕುಡಿ” ಅಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ಅವನು ನೀರು ಕುಡಿದಾದ ಮೇಲೆ ಆಕೆ ಅವನಿಗೆ, “ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ಬೇಕಾದಷ್ಟು ನೀರನ್ನು ತಂದುಕೊಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿ, ");
INSERT INTO kan2010_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ನೀರನ್ನೆಲ್ಲ ತೊಟ್ಟಿಯಲ್ಲಿ ಸುರಿದು ಮತ್ತೆ ನೀರನ್ನು ತೆಗೆದುಕೊಂಡು ಬರಲು ಬಾವಿಯ ಬಳಿಗೆ ಬೇಗಬೇಗನೆ ಹೋದಳು. ಹೀಗೆ ಅವನ ಒಂಟೆಗಳಿಗೆಲ್ಲಾ ನೀರನ್ನು ಕೊಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ಆ ಸೇವಕನು ಆಕೆಯನ್ನೇ ಗಮನಿಸುತ್ತಾ, ಯೆಹೋವನು ತನ್ನ ಪ್ರಾರ್ಥನೆಗೆ ಉತ್ತರ ಕೊಟ್ಟನೋ ಇಲ್ಲವೋ ಎಂದು ಖಚಿತಪಡಿಸಿಕೊಳ್ಳಲು ಕಾದುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ಒಂಟೆಗಳು ನೀರನ್ನು ಕುಡಿದಾದ ಮೇಲೆ ಅವನು ರೆಬೆಕ್ಕಳಿಗೆ ಅರ್ಧತೊಲೆಯ ಒಂದು ಚಿನ್ನದ ಉಂಗುರವನ್ನು ಕೊಟ್ಟನು. ಇದಲ್ಲದೆ ಅವನು ಆಕೆಗೆ ಹತ್ತು ತೊಲೆಯ ಎರಡು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ಆ ಸೇವಕನು, “ನಿನ್ನ ತಂದೆ ಯಾರು? ನನ್ನ ಜನರು ಇಳಿದುಕೊಳ್ಳಲು ನಿನ್ನ ತಂದೆಯ ಮನೆಯಲ್ಲಿ ಸ್ಥಳವಿದೆಯೋ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ರೆಬೆಕ್ಕಳು ಅವನಿಗೆ, “ನನ್ನ ತಂದೆಯ ಹೆಸರು ಬೆತೂವೇಲ. ಅವನು ಮಿಲ್ಕಳ ಮತ್ತು ನಾಹೋರನ ಮಗನು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ಬಳಿಕ, “ಹೌದು, ನಿನ್ನ ಒಂಟೆಗಳಿಗೆ ಹುಲ್ಲೂ ಮೇವೂ ನಮ್ಮಲ್ಲಿವೆ ಮತ್ತು ನೀವು ಇಳಿದುಕೊಳ್ಳಲೂ ಸ್ಥಳವಿದೆ” ಎಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ಆಗ ಆ ಸೇವಕನು ತಲೆಬಾಗಿ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ಬಳಿಕ ಆಕೆಗೆ, “ನನ್ನ ಒಡೆಯನಾದ ಅಬ್ರಹಾಮನ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಸ್ತೋತ್ರವಾಗಲಿ. ಆತನು ನನ್ನ ಒಡೆಯನಿಗೆ ದಯಾಳುವೂ ನಂಬಿಗಸ್ತನೂ ಆಗಿದ್ದಾನೆ. ನನ್ನ ಒಡೆಯನ ಮಗನಿಗಾಗಿ ಯೆಹೋವನು ನನ್ನನ್ನು ನನ್ನ ಒಡೆಯನ ಕುಟುಂಬಕ್ಕೆ ನಡೆಸಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ಆಗ ರೆಬೆಕ್ಕಳು ಬೇಗನೆ ಹೋಗಿ ಈ ಸಂಗತಿಗಳನ್ನೆಲ್ಲಾ ತನ್ನ ಕುಟುಂಬದವರಿಗೆ ತಿಳಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","ರೆಬೆಕ್ಕಳಿಗೆ ಒಬ್ಬ ಅಣ್ಣನಿದ್ದನು. ಅವನ ಹೆಸರು ಲಾಬಾನ. ನಡೆದ ಸಂಗತಿಗಳನ್ನೆಲ್ಲ ರೆಬೆಕ್ಕಳು ಅವನಿಗೆ ತಿಳಿಸಿದಳು. ಲಾಬಾನನು ಆಕೆಯ ಮಾತುಗಳನ್ನೆಲ್ಲ ಕೇಳಿದಾಗ ಮತ್ತು ಉಂಗುರವನ್ನು ಮತ್ತು ಕೈಗಳಲ್ಲಿದ್ದ ಬಳೆಗಳನ್ನು ಕಂಡಾಗ ಬಾವಿಯ ಬಳಿಗೆ ಓಡಿಹೋದನು. ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ಒಂಟೆಗಳ ಹತ್ತಿರ ಆ ಸೇವಕನು ನಿಂತುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ಲಾಬಾನನು ಅವನಿಗೆ, “ಯೆಹೋವನ ಆಶೀರ್ವಾದ ಹೊಂದಿದವನೇ, ಒಳಗೆ ಬಾ. ನೀನು ಹೊರಗಡೆ ನಿಂತುಕೊಳ್ಳಬೇಕಾಗಿಲ್ಲ. ನೀನು ಇಳಿದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಕೋಣೆಯನ್ನೂ ನಿನ್ನ ಒಂಟೆಗಳಿಗಾಗಿ ಸ್ಥಳವನ್ನೂ ಸಿದ್ಧಪಡಿಸಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ಆದ್ದರಿಂದ ಅಬ್ರಹಾಮನ ಸೇವಕನು ಲಾಬಾನನ ಮನೆಗೆ ಹೋದನು. ಒಂಟೆಗಳ ಮೇಲಿದ್ದ ಹೊರೆಗಳನ್ನು ಇಳಿಸಲು ಲಾಬಾನನು ಸಹಾಯಮಾಡಿದನು; ಒಂಟೆಗಳಿಗೆ ಸ್ಥಳಮಾಡಿಕೊಟ್ಟು ಮೇವನ್ನು ಕೊಡಿಸಿದನು; ಆಮೇಲೆ ಆ ಸೇವಕನಿಗೆ ಮತ್ತು ಅವನ ಸಂಗಡ ಇದ್ದವರಿಗೆ, ಕಾಲು ತೊಳೆದುಕೊಳ್ಳಲು ನೀರು ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ನಂತರ ಲಾಬಾನನು ಅವನಿಗೆ ಊಟವನ್ನು ಕೊಟ್ಟನು. ಆದರೆ ಆ ಸೇವಕನು ಊಟಮಾಡದೆ ಅವರಿಗೆ, “ನಾನು ಬಂದ ಉದ್ದೇಶವನ್ನು ತಿಳಿಸದೆ ಊಟಮಾಡುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ಅದಕ್ಕೆ ಲಾಬಾನನು, “ಸರಿ, ಹೇಳು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ಆ ಸೇವಕನು “ನಾನು ಅಬ್ರಹಾಮನ ಸೇವಕನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ಯೆಹೋವನು ನನ್ನ ಒಡೆಯನನ್ನು ಪ್ರತಿಯೊಂದರಲ್ಲಿಯೂ ಬಹಳವಾಗಿ ಆಶೀರ್ವದಿಸಿದ್ದಾನೆ. ನನ್ನ ಒಡೆಯನು ಮಹಾವ್ಯಕ್ತಿಯಾಗಿದ್ದಾನೆ. ಯೆಹೋವನು ಅಬ್ರಹಾಮನಿಗೆ ಅನೇಕ ಕುರಿಹಿಂಡುಗಳನ್ನೂ ದನಕರುಗಳ ಮಂದೆಗಳನ್ನೂ ಕೊಟ್ಟಿದ್ದಾನೆ. ಅಬ್ರಹಾಮನಿಗೆ ಬೇಕಾದಷ್ಟು ಬೆಳ್ಳಿಬಂಗಾರಗಳಿವೆ. ಅನೇಕ ಸೇವಕರಿದ್ದಾರೆ. ಅನೇಕ ಒಂಟೆಗಳೂ ಕತ್ತೆಗಳೂ ಇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ಸಾರಳು ನನ್ನ ಒಡೆಯನ ಹೆಂಡತಿ. ಆಕೆ ತುಂಬಾ ವಯಸ್ಸಾಗಿರುವಾಗ ಒಬ್ಬ ಗಂಡುಮಗನನ್ನು ಹೆತ್ತಳು. ನನ್ನ ಒಡೆಯನು ತನ್ನ ಆಸ್ತಿಯನ್ನೆಲ್ಲ ಆ ಮಗನಿಗೇ ಕೊಟ್ಟಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ನನ್ನ ಒಡೆಯನ್ನು ನನ್ನಿಂದ ಒಂದು ಪ್ರಮಾಣವನ್ನು ಬಲವಂತವಾಗಿ ಮಾಡಿಸಿದನು. ನನ್ನ ಒಡೆಯನು ನನಗೆ, ‘ನನ್ನ ಮಗನಿಗೆ ಕಾನಾನಿನ ಹುಡುಗಿಯೊಡನೆ ಮದುವೆಯಾಗದಂತೆ ನೀನು ನೋಡಿಕೊಳ್ಳಬೇಕು; ನಾವು ಈ ಜನರೊಡನೆ ವಾಸಿಸುತ್ತಿದ್ದೇವೆ. ಆದರೆ ಕಾನಾನಿನ ಹುಡುಗಿಯೊಂದಿಗೆ ನನ್ನ ಮಗನಿಗೆ ಮದುವೆಯಾಗುವುದು ನನಗೆ ಇಷ್ಟವಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ಆದ್ದರಿಂದ ನೀನು ನನ್ನ ಸ್ವದೇಶಕ್ಕೆ ಹೋಗಿ ನನ್ನ ಸ್ವಜನರಿಂದಲೇ ನನ್ನ ಮಗನಿಗೆ ಕನ್ಯೆಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು’ ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ನಾನು ನನ್ನ ಒಡೆಯನಿಗೆ, ‘ಆ ಕನ್ಯೆಯು ಈ ದೇಶಕ್ಕೆ ನನ್ನೊಂದಿಗೆ ಬರಲು ಒಪ್ಪದಿರಬಹುದು’ ಎಂದು ಹೇಳಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ಆದರೆ ನನ್ನ ಒಡೆಯನು ನನಗೆ, ‘ನಾನು ಯೆಹೋವನ ಸೇವೆ ಮಾಡುತ್ತಿದ್ದೇನೆ. ಆದ್ದರಿಂದ ಯೆಹೋವನು ತನ್ನ ದೂತನನ್ನು ನಿನ್ನೊಂದಿಗೆ ಕಳುಹಿಸಿ ನಿನಗೆ ಸಹಾಯ ಮಾಡುವನು. ಅಲ್ಲಿರುವ ನನ್ನ ತಂದೆಯ ಕುಟುಂಬದವರಲ್ಲಿ ನೀನು ನನ್ನ ಮಗನಿಗಾಗಿ ಒಬ್ಬ ಕನ್ಯೆಯನ್ನು ಕಂಡುಕೊಳ್ಳುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ಆದರೆ ನೀನು ನನ್ನ ತಂದೆಯ ನಾಡಿಗೆ ಹೋದಾಗ ಅವರು ನನ್ನ ಮಗನಿಗೆ ಒಬ್ಬ ಕನ್ಯೆಯನ್ನು ಕೊಡಲು ಒಪ್ಪದಿದ್ದರೆ ನೀನು ಈ ಪ್ರಮಾಣದಿಂದ ಬಿಡುಗಡೆಯಾಗಿರುವೆ’ ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“ಇಂದು ನಾನು ಈ ಬಾವಿಯ ಬಳಿಗೆ ಬಂದು, ‘ನನ್ನ ಒಡೆಯನಾದ ಅಬ್ರಹಾಮನ ದೇವರಾಗಿರುವ ಯೆಹೋವನೇ, ದಯವಿಟ್ಟು ನನ್ನ ಪ್ರವಾಸವನ್ನು ಯಶಸ್ವಿಗೊಳಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ನಾನು ಬಾವಿಯ ಬಳಿಯಲ್ಲಿ ನಿಂತುಕೊಂಡು ನೀರನ್ನು ತೆಗೆದುಕೊಳ್ಳಲು ಬರುವ ಒಬ್ಬ ಯುವತಿಗಾಗಿ ಕಾದಿರುತ್ತೇನೆ. ಆಮೇಲೆ ನಾನು ಆಕೆಗೆ, “ದಯವಿಟ್ಟು ಕುಡಿಯಲು ನಿನ್ನ ಕೊಡದಿಂದ ನೀರನ್ನು ಕೊಡು” ಎಂದು ಕೇಳುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ಅವಳು ನನಗೆ, “ನೀನೂ ನೀರನ್ನು ಕುಡಿ, ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ನೀರನ್ನು ತಂದುಕೊಡುವೆ” ಎಂದು ಹೇಳಿದರೆ, ನನ್ನ ಒಡೆಯನ ಮಗನಿಗೆ ಯೆಹೋವನು ಆರಿಸಿಕೊಂಡಿರುವ ಕನ್ನಿಕೆ ಇವಳೇ ಎಂಬುದಾಗಿ ತಿಳಿದುಕೊಳ್ಳುವೆ’ ಎಂದು ಪ್ರಾರ್ಥಿಸಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“ನಾನು ಪ್ರಾರ್ಥನೆ ಮುಗಿಸುವಷ್ಟರಲ್ಲಿ ರೆಬೆಕ್ಕಳು ನೀರಿಗಾಗಿ ಬಾವಿಗೆ ಬಂದಳು. ಆಕೆ ಹೆಗಲ ಮೇಲೆ ಕೊಡವನ್ನು ಹೊತ್ತುಕೊಂಡಿದ್ದಳು. ಆಕೆ ಬಾವಿಗೆ ಹೋಗಿ ನೀರನ್ನು ತೆಗೆದುಕೊಂಡಳು. ನಾನು ಆಕೆಗೆ, ದಯವಿಟ್ಟು ಸ್ವಲ್ಪ ನೀರನ್ನು ಕೊಡು ಎಂದು ಕೇಳಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ಆ ಕೂಡಲೆ ಆಕೆಯು ಕೊಡವನ್ನು ಹೆಗಲಿನಿಂದ ಕೆಳಗಿಳಿಸಿ, ನನಗೆ ನೀರನ್ನು ಕೊಟ್ಟು, ‘ನೀರನ್ನು ಕುಡಿ; ನಿನ್ನ ಒಂಟೆಗಳಿಗೂ ನೀರನ್ನು ತಂದುಕೊಡುವೆ’ ಎಂದು ಹೇಳಿದಳು. ನಾನು ನೀರನ್ನು ಕುಡಿದ ಮೇಲೆ ಆಕೆ ನನ್ನ ಒಂಟೆಗಳಿಗೂ ನೀರನ್ನು ತಂದುಕೊಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ಆಮೇಲೆ ನಾನು ಆಕೆಗೆ, ‘ನಿನ್ನ ತಂದೆ ಯಾರು?’ ಎಂದು ಕೇಳಿದೆ, ಆಕೆ ‘ನನ್ನ ತಂದೆಯ ಹೆಸರು ಬೆತೂವೇಲ. ಅವನು ಮಿಲ್ಕಳ ಮತ್ತು ನಾಹೋರನ ಮಗನು’ ಎಂದು ಹೇಳಿದಳು. ಆಗ ನಾನು ಆಕೆಗೆ ಉಂಗುರವನ್ನೂ ಕೈಬಳೆಗಳನ್ನೂ ಕೊಟ್ಟೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ಆ ಸಮಯದಲ್ಲಿ ನಾನು ತಲೆಬಾಗಿ ಯೆಹೋವನಿಗೆ ವಂದನೆ ಸಲ್ಲಿಸಿದೆನು. ನನ್ನ ಒಡೆಯನಾದ ಅಬ್ರಹಾಮನ ದೇವರಾದ ಯೆಹೋವನನ್ನು ಸ್ತುತಿಸಿ ಕೊಂಡಾಡಿದೆನು; ಯಾಕೆಂದರೆ ಆತನು ನನ್ನನ್ನು ನನ್ನ ಒಡೆಯನ ತಮ್ಮನ ಮೊಮ್ಮಗಳ ಬಳಿಗೆ ನೇರವಾಗಿ ನಡೆಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ಈಗ ನಿಮ್ಮ ಅಭಿಪ್ರಾಯವನ್ನು ತಿಳಿಸಿರಿ. ನೀವು ನನ್ನ ಒಡೆಯನಿಗೆ ಪ್ರೀತಿಯಿಂದಲೂ ನಂಬಿಕೆಯಿಂದಲೂ ನಿಮ್ಮ ಮಗಳನ್ನು ಕೊಡುವಿರಾ? ಅಥವಾ ಕೊಡುವುದಿಲ್ಲವೇ? ನಿಮ್ಮ ಉತ್ತರಕ್ಕನುಸಾರವಾಗಿ ನಾನು ಮುಂದಿನ ಕಾರ್ಯದ ಬಗ್ಗೆ ಆಲೋಚಿಸುವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ಅದಕ್ಕೆ ಲಾಬಾನನು ಮತ್ತು ಬೆತೂವೇಲನು, “ನಿನ್ನನ್ನು ಯೆಹೋವನೇ ಕಳುಹಿಸಿದ್ದಾನೆ. ನಡೆಯತಕ್ಕದ್ದನ್ನು ಬದಲಾಯಿಸಲು ನಮಗೆ ಸಾಧ್ಯವಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ರೆಬೆಕ್ಕಳು ನಿಮ್ಮವಳು. ನೀನು ಆಕೆಯನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗಿ ಯೆಹೋವನ ಇಷ್ಟಕ್ಕನುಸಾರವಾಗಿ ನಿನ್ನ ಒಡೆಯನ ಮಗನಿಗೆ ಮದುವೆ ಮಾಡಿಸು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ಅಬ್ರಹಾಮನ ಸೇವಕನು ಈ ಮಾತುಗಳನ್ನು ಕೇಳಿ ಯೆಹೋವನಿಗೆ ನೆಲದವರೆಗೂ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ಆಮೇಲೆ ಆ ಸೇವಕನು ತಾನು ತಂದಿದ್ದ ಉಡುಗೊರೆಗಳನ್ನು ರೆಬೆಕ್ಕಳಿಗೆ ಕೊಟ್ಟನು. ಅವನು ರೆಬೆಕ್ಕಳಿಗೆ ಬೆಳ್ಳಿಬಂಗಾರಗಳ ಒಡವೆಗಳನ್ನೂ ಶ್ರೇಷ್ಠವಾದ ಬಟ್ಟೆಗಳನ್ನೂ ಕೊಟ್ಟನು. ಇದಲ್ಲದೆ ಅವನು ಬೆಲೆಬಾಳುವ ಉಡುಗೊರೆಗಳನ್ನು ಆಕೆಯ ಅಣ್ಣನಿಗೂ ತಾಯಿಗೂ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ಆ ಸೇವಕನು ಮತ್ತು ಅವನ ಸಂಗಡಿಗರು ಅಲ್ಲಿ ಇಳಿದುಕೊಂಡು ಊಟಮಾಡಿದರು. ಅವರು ಮರುದಿನ ಮುಂಜಾನೆ ಎದ್ದು, “ಈಗ ನಾವು ನಮ್ಮ ಒಡೆಯನ ಬಳಿಗೆ ಹೋಗುತ್ತೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ರೆಬೆಕ್ಕಳ ತಾಯಿ ಮತ್ತು ಅಣ್ಣನು ಅವರಿಗೆ, “ರೆಬೆಕ್ಕಳು ಸ್ವಲ್ಪ ದಿನಗಳವರೆಗೆ ನಮ್ಮ ಜೊತೆ ಇರಲಿ. ಹತ್ತು ದಿನಗಳವರೆಗಾದರೂ ನಮ್ಮೊಡನೆ ಇರಲಿ. ಆಮೇಲೆ ಆಕೆಯನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ಆದರೆ ಆ ಸೇವಕನು ಅವರಿಗೆ, “ನನ್ನನ್ನು ತಡೆಯಬೇಡಿ. ಯೆಹೋವನು ನನ್ನ ಪ್ರಯಾಣವನ್ನು ಯಶಸ್ವಿಗೊಳಿಸಿದ್ದಾನೆ. ಈಗ ನನ್ನನ್ನು ನನ್ನ ಒಡೆಯನ ಬಳಿಗೆ ಕಳುಹಿಸಿಕೊಡಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ರೆಬೆಕ್ಕಳ ಅಣ್ಣ ಮತ್ತು ತಾಯಿ ಅವನಿಗೆ, “ನಾವು ರೆಬೆಕ್ಕಳನ್ನು ಕರೆದು ಆಕೆಯ ಇಷ್ಟವನ್ನು ಕೇಳುತ್ತೇವೆ” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ಅವರು ರೆಬೆಕ್ಕಳನ್ನು ಕರೆದು, “ಈಗಲೇ ಈ ಮನುಷ್ಯನೊಡನೆ ಹೋಗಲು ನಿನಗೆ ಇಷ್ಟವಿದೆಯೋ?” ಎಂದು ಕೇಳಿದರು. ರೆಬೆಕ್ಕಳು, “ಹೌದು, ನಾನು ಹೋಗುತ್ತೇನೆ” ಅಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ಆದ್ದರಿಂದ ಅವರು ರೆಬೆಕ್ಕಳನ್ನು ಅಬ್ರಹಾಮನ ಸೇವಕನೊಂದಿಗೂ ಅವನ ಸಂಗಡಿಗರೊಂದಿಗೂ ಕಳುಹಿಸಿಕೊಟ್ಟರು. ರೆಬೆಕ್ಕಳ ಸೇವಕಿ ಸಹ ಅವರೊಂದಿಗೆ ಹೋದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ಅವರು ಹೊರಡಲು ಸಿದ್ಧರಾಗಿದ್ದಾಗ ಅವರು ರೆಬೆಕ್ಕಳಿಗೆ, “ನಮ್ಮ ತಂಗಿಯೇ, ನೀನು ಕೋಟ್ಯಾನುಕೋಟಿ ಜನರ ತಾಯಿಯಾಗು. ನಿನ್ನ ಸಂತತಿಗಳವರು ತಮ್ಮ ಶತ್ರುಗಳನ್ನು ಸೋಲಿಸಿ ಅವರ ನಗರಗಳನ್ನು ವಶಮಾಡಿಕೊಳ್ಳಲಿ” ಎಂದು ಹೇಳಿ ಹರಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ಆಮೇಲೆ ರೆಬೆಕ್ಕಳು ಮತ್ತು ಆಕೆಯ ಸೇವಕಿಯರು ಒಂಟೆಯ ಮೇಲೆ ಹತ್ತಿ ಕುಳಿತುಕೊಂಡು ಆ ಸೇವಕನನ್ನೂ ಅವನ ಸಂಗಡಿಗರನ್ನೂ ಹಿಂಬಾಲಿಸಿದರು. ಹೀಗೆ ಆ ಸೇವಕನು ರೆಬೆಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ಮನೆಗೆ ಮರಳಿ ಪ್ರಯಾಣಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ಆ ಸಮಯದಲ್ಲಿ, ಇಸಾಕನು ಬೀರ್‌ಲಹೈರೋಯಿಗೆ ಹೋಗಿ ಬಂದಿದ್ದನು; ಯಾಕೆಂದರೆ ಅವನು ನೆಗವ್‌ನಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ಸಾಯಂಕಾಲದಲ್ಲಿ ಇಸಾಕನು ಧ್ಯಾನಮಾಡಲು ಹೊಲಕ್ಕೆ ಹೋದನು. ಇಸಾಕನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ ಬಹುದೂರದಲ್ಲಿ ಒಂಟೆಗಳು ಬರುತ್ತಿರುವುದನ್ನು ಕಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ರೆಬೆಕ್ಕಳು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ ಇಸಾಕನನ್ನು ಕಂಡಳು. ಆಮೇಲೆ ಆಕೆ ಒಂಟೆಯಿಂದ ಬೇಗನೆ ಇಳಿದು ಬಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ಆಕೆ, ಆ ಸೇವಕನಿಗೆ, “ನಮ್ಮನ್ನು ಭೇಟಿಯಾಗಲು ಹೊಲದಲ್ಲಿ ಬರುತ್ತಿರುವ ಆ ಯೌವನಸ್ಥನು ಯಾರು?” ಎಂದು ಕೇಳಿದಳು. ಆ ಸೇವಕನು, “ಅವನು ನನ್ನ ಒಡೆಯನ ಮಗನು” ಎಂದು ಹೇಳಿದನು. ಆ ಕೂಡಲೇ ರೆಬೆಕ್ಕಳು ತನ್ನ ಮುಖಕ್ಕೆ ಮುಸುಕನ್ನು ಹಾಕಿಕೊಂಡಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ಆ ಸೇವಕನು ನಡೆದ ಸಂಗತಿಯನ್ನೆಲ್ಲಾ ಇಸಾಕನಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ನಂತರ ಇಸಾಕನು ಆಕೆಯನ್ನು ಕರೆದುಕೊಂಡು ತನ್ನ ತಾಯಿಯ ಗುಡಾರಕ್ಕೆ ಬಂದನು. ಅಂದು ರೆಬೆಕ್ಕಳು ಇಸಾಕನ ಹೆಂಡತಿಯಾದಳು. ಇಸಾಕನು ಅವಳನ್ನು ಬಹಳವಾಗಿ ಪ್ರೀತಿಸಿದನು. ತಾಯಿಯ ಸಾವಿನಿಂದ ಉಂಟಾಗಿದ್ದ ದುಃಖವು ಕಡಿಮೆಯಾಗಿ ಇಸಾಕನಿಗೆ ಆದರಣೆಯಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ಅಬ್ರಹಾಮನು ಮತ್ತೆ ಮದುವೆಯಾದನು. ಅವನ ಹೊಸ ಹೆಂಡತಿಯ ಹೆಸರು ಕೆಟೂರ. ");
INSERT INTO kan2010_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ಆಕೆ ಅವನಿಗೆ; ಜಿಮ್ರಾನ್, ಯೊಕ್ಷಾನ್, ಮೆದಾನ್, ಮಿದ್ಯಾನ್, ಇಷ್ಬಾಕ್, ಶೂಹ ಎಂಬವರನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ಯೊಕ್ಷಾನನು ಶೆಬಾ ಮತ್ತು ದೆದಾನ್ ಎಂಬವರ ತಂದೆ. ದೆದಾನನ ಸಂತತಿಯವರು: ಅಶ್ಶೂರ್ಯರು ಲೆಟೂಶ್ಯರು ಮತ್ತು ಲೆಯುಮ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ಮಿದ್ಯಾನನ ಗಂಡುಮಕ್ಕಳು: ಗೇಫಾ, ಗೇಫೆರ್, ಹನೋಕ್, ಅಬೀದಾ ಮತ್ತು ಎಲ್ದಾಗ. ಇವರೆಲ್ಲರೂ ಕೆಟೂರಳ ಸಂತತಿಯವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","ಅಬ್ರಹಾಮನು ಸಾಯುವುದಕ್ಕಿಂತ ಮುಂಚೆ ತನ್ನ ದಾಸಿಯ ಗಂಡುಮಕ್ಕಳಿಗೆ ಕೆಲವು ಉಡುಗೊರೆಗಳನ್ನು ಕೊಟ್ಟನು. ಅಬ್ರಹಾಮನು ಆ ಗಂಡುಮಕ್ಕಳನ್ನು ಪೂರ್ವದ ಕಡೆಯಲ್ಲಿದ್ದ ಕೆದೆಮೆಂಬ ದೇಶಕ್ಕೆ ಕಳುಹಿಸಿ ಅವರನ್ನು ಇಸಾಕನಿಂದ ದೂರಮಾಡಿದನು; ಬಳಿಕ ತನ್ನ ಆಸ್ತಿಯನ್ನೆಲ್ಲ ಇಸಾಕನಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ಅಬ್ರಹಾಮನು ನೂರೆಪ್ಪತ್ತೈದು ವರ್ಷ ಜೀವಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ಅವನು ಪೂರ್ಣಾಯುಷ್ಯದಿಂದ ದಿನತುಂಬಿದ ವೃದ್ಧನಾಗಿ ಪ್ರಾಣಬಿಟ್ಟು ತನ್ನ ಪಿತೃಗಳ ಬಳಿಗೆ ಸೇರಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ಅವನ ಗಂಡುಮಕ್ಕಳಾದ ಇಸಾಕ ಮತ್ತು ಇಷ್ಮಾಯೇಲರು ಅವನನ್ನು ಮಕ್ಪೇಲದ ಗವಿಯಲ್ಲಿ ಸಮಾಧಿಮಾಡಿದರು. ಈ ಗವಿಯು ಹಿತ್ತಿಯನಾದ ಚೋಹರನ ಮಗ ಎಫ್ರೋನನ ಜಮೀನಿನಲ್ಲಿದೆ. ಅದು ಮಮ್ರೆಗೆ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ಅಬ್ರಹಾಮನು ಹಿತ್ತಿಯರಿಂದ ಕೊಂಡುಕೊಂಡ ಈ ಗವಿಯಲ್ಲೇ ಅಬ್ರಹಾಮನನ್ನು ಅವನ ಹೆಂಡತಿಯಾದ ಸಾರಳ ಜೊತೆಯಲ್ಲಿ ಸಮಾಧಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ಅಬ್ರಹಾಮನು ತೀರಿಕೊಂಡ ಮೇಲೆ, ದೇವರು ಇಸಾಕನನ್ನು ಆಶೀರ್ವದಿಸಿದನು; ಇಸಾಕನು ಬೀರ್‌ಲಹೈರೋಯಿಯಲ್ಲಿ ತನ್ನ ಜೀವನವನ್ನು ಮುಂದುವರೆಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ಇದು ಇಷ್ಮಾಯೇಲನ ವಂಶಾವಳಿ: ಇಷ್ಮಾಯೇಲನು ಅಬ್ರಹಾಮನ ಮತ್ತು ಹಾಗರಳ ಮಗನು. (ಈಜಿಪ್ಟಿನವಳಾದ ಹಾಗರಳು ಸಾರಳ ಸೇವಕಿ.) ");
INSERT INTO kan2010_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ಇಷ್ಮಾಯೇಲನ ಗಂಡುಮಕ್ಕಳ ಹೆಸರುಗಳು: ಮೊದಲನೆ ಮಗನು ನೆಬಾಯೋತ್. ಆಮೇಲೆ ಹುಟ್ಟಿದವರು: ಕೇದಾರ್, ಅದ್ಬಯೇಲ್, ಮಿಬ್ಸಾಮ್, ");
INSERT INTO kan2010_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ಮಿಷ್ಮಾ, ದೂಮಾ, ಮಸ್ಸಾ, ");
INSERT INTO kan2010_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ಹದದ್, ತೇಮಾ, ಯಟೂರ್, ನಾಫೀಷ್ ಮತ್ತು ಕೇದ್ಮಾ. ");
INSERT INTO kan2010_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನದೇ ಆದ ಪಾಳೆಯವನ್ನು ಹೊಂದಿದ್ದನು. ಆ ಪಾಳೆಯಗಳೇ ಮುಂದೆ ಚಿಕ್ಕ ಪಟ್ಟಣಗಳಾದವು. ಈ ಹನ್ನೆರಡು ಮಂದಿ ಗಂಡುಮಕ್ಕಳು ತಮ್ಮ ಜನರಿಗೆ ಹನ್ನೆರಡು ಮಂದಿ ರಾಜರುಗಳಂತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ಇಷ್ಮಾಯೇಲನು ನೂರ ಮೂವತ್ತೇಳು ವರ್ಷ ಬದುಕಿದನು. ಅವನು ಸತ್ತ ನಂತರ ಅವನನ್ನು ತನ್ನ ಪೂರ್ವಜರ ಸಮಾಧಿಯಲ್ಲಿ ಹೂಣಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ಇಷ್ಮಾಯೇಲನ ಸಂತತಿಯವರು ಮರುಭೂಮಿ ಪ್ರದೇಶದ ಉದ್ದಕ್ಕೂ ಪಾಳೆಯಗಳನ್ನು ಮಾಡಿಕೊಂಡಿದ್ದರು. ಈ ಪ್ರದೇಶವು ಹವೀಲ ಮತ್ತು ಈಜಿಪ್ಟಿನ ಸಮೀಪದಲ್ಲಿರುವ ಶೂರಿನಿಂದ ಆರಂಭಗೊಂಡು ಅಶ್ಶೂರದವರೆಗೂ ಇತ್ತು. ಇಷ್ಮಾಯೇಲನ ಸಂತತಿಗಳವರು ಪದೇಪದೇ ತಮ್ಮ ಸಹೋದರನ ಜನರಿಗೆ ವಿರೋಧವಾಗಿ ಆಕ್ರಮಣ ಮಾಡುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ಇದು ಇಸಾಕನ ಚರಿತ್ರೆ. ಅಬ್ರಹಾಮನಿಗೆ ಇಸಾಕ ಎಂಬ ಹೆಸರಿನ ಮಗನಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ಇಸಾಕನು ನಲವತ್ತು ವರ್ಷದವನಾಗಿದ್ದಾಗ ರೆಬೆಕ್ಕಳನ್ನು ಮದುವೆಯಾದನು. ರೆಬೆಕ್ಕಳು ಪದ್ದನ್ ಅರಾಮಿನವಳು. ಆಕೆ ಬೆತೂವೇಲನ ಮಗಳು ಮತ್ತು ಅರಾಮ್ಯನಾದ ಲಾಬಾನನ ತಂಗಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ಇಸಾಕನ ಹೆಂಡತಿ ಮಕ್ಕಳನ್ನು ಪಡೆಯಲಾಗಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಇಸಾಕನು ತನ್ನ ಹೆಂಡತಿಗೋಸ್ಕರ ಯೆಹೋವನಲ್ಲಿ ಪ್ರಾರ್ಥಿಸಿದನು. ಯೆಹೋವನು ಇಸಾಕನ ಪ್ರಾರ್ಥನೆಯನ್ನು ಕೇಳಿ ರೆಬೆಕ್ಕಳಿಗೆ ಗರ್ಭಧಾರಣೆಯನ್ನು ಅನುಗ್ರಹಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ರೆಬೆಕ್ಕಳು ಗರ್ಭಿಣಿಯಾಗಿದ್ದಾಗ, ಅವಳ ಗರ್ಭದಲ್ಲಿದ್ದ ಕೂಸುಗಳು ಒಂದನ್ನೊಂದು ನೂಕಾಡಿದ್ದರಿಂದ ಅವಳು ಬಹಳ ತೊಂದರೆಪಡಬೇಕಾಯಿತು. ರೆಬೆಕ್ಕಳು ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಿ, “ನನಗೇಕೆ ಹೀಗೆ ಆಗುತ್ತಿದೆ?” ಎಂದು ಕೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ಯೆಹೋವನು ಅವಳಿಗೆ, “ನಿನ್ನ ಗರ್ಭದಲ್ಲಿ ಎರಡು ಜನಾಂಗಗಳಿವೆ. ಎರಡು ಕುಟುಂಬಗಳನ್ನು ಆಳುವವರು ನಿನ್ನಲ್ಲಿ ಹುಟ್ಟುವರು; ಅವರು ವಿಭಾಗವಾಗುವರು. ಒಬ್ಬ ಮಗನು ಮತ್ತೊಬ್ಬನಿಗಿಂತ ಬಲಶಾಲಿಯಾಗಿರುವನು. ದೊಡ್ಡ ಮಗನು ಚಿಕ್ಕ ಮಗನ ಸೇವೆ ಮಾಡುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ದಿನ ತುಂಬಿದ ಮೇಲೆ ರೆಬೆಕ್ಕಳು ಅವಳಿಜವಳಿ ಮಕ್ಕಳನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ಮೊದಲನೆಯ ಮಗುವು ಕೆಂಪಗಿತ್ತು. ಅವನ ಚರ್ಮವು ಕೂದಲಿನ ಉಡುಪಿನಂತಿತ್ತು. ಆದ್ದರಿಂದ ಅವನಿಗೆ “ಏಸಾವ್” ಎಂದು ಹೆಸರಿಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ಎರಡನೆಯ ಮಗು ಹುಟ್ಟಿದಾಗ ಅದು ಏಸಾವನ ಹಿಮ್ಮಡಿಯನ್ನು ಗಟ್ಟಿಯಾಗಿ ಹಿಡಿದುಕೊಂಡಿತ್ತು. ಆದ್ದರಿಂದ ಆ ಮಗುವಿಗೆ “ಯಾಕೋಬ” ಎಂದು ಹೆಸರಿಡಲಾಯಿತು. ಯಾಕೋಬ ಮತ್ತು ಏಸಾವ ಹುಟ್ಟಿದಾಗ ಇಸಾಕನಿಗೆ ಅರವತ್ತು ವರ್ಷ ವಯಸ್ಸಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ಆ ಬಾಲಕರು ಬೆಳೆದು ದೊಡ್ಡವರಾದರು. ಏಸಾವನು ಚತುರ ಬೇಟೆಗಾರನಾದನು. ಹೊಲದಲ್ಲಿರುವುದು ಅವನಿಗೆ ಪ್ರಿಯವಾಗಿತ್ತು. ಆದರೆ ಯಾಕೋಬನು ಸಾಧು ಮನುಷ್ಯನಾಗಿದ್ದನು. ಅವನು ತನ್ನ ಗುಡಾರದಲ್ಲಿರುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ಇಸಾಕನು ಏಸಾವನನ್ನು ಪ್ರೀತಿಸಿದನು. ಏಸಾವನು ಬೇಟೆಯಾಡಿ ತಂದ ಪ್ರಾಣಿಗಳ ಮಾಂಸ ಅವನಿಗೆ ಇಷ್ಟವಾಗಿತ್ತು. ಆದರೆ ರೆಬೆಕ್ಕಳು ಯಾಕೋಬನನ್ನು ಪ್ರೀತಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ಒಂದು ಸಲ ಏಸಾವನು ಬೇಟೆಯಿಂದ ಹಿಂತಿರುಗಿ ಬಂದಾಗ ಹಸಿವೆಯಿಂದ ಆಯಾಸಗೊಂಡಿದ್ದನು ಮತ್ತು ಬಲಹೀನನಾಗಿದ್ದನು. ಯಾಕೋಬನು ಅಲಸಂಧಿ ಗುಗ್ಗರಿ ಮಾಡುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ಆಗ ಏಸಾವನು ಯಾಕೋಬನಿಗೆ, “ಹಸಿವೆಯಿಂದ ನನಗೆ ಆಯಾಸವಾಗಿದೆ. ನನಗೆ ಕೆಂಪಾದ ಸ್ವಲ್ಪ ಅಲಸಂದಿ ಗುಗ್ಗರಿಯನ್ನು ಕೊಡು” ಎಂದು ಕೇಳಿದನು. (ಈ ಕಾರಣದಿಂದ ಜನರು ಅವನಿಗೆ “ಏದೋಮ್” ಎಂದು ಕರೆಯುತ್ತಾರೆ.) ");
INSERT INTO kan2010_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ಆದರೆ ಯಾಕೋಬನು, “ನಿನ್ನ ಚೊಚ್ಚಲತನದ ಹಕ್ಕನ್ನು ನೀನು ನನಗೆ ಈ ದಿನ ಮಾರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ಏಸಾವನು, “ನನಗೆ ಹಸಿವೆಯಿಂದ ಸಾಯುವಂತಾಗಿದೆ. ನಾನು ಸತ್ತುಹೋದರೆ, ನನ್ನ ತಂದೆಯ ಐಶ್ವರ್ಯವೆಲ್ಲ ನನಗೆ ಸಹಾಯ ಮಾಡಲಾರದು. ಆದ್ದರಿಂದ ನಾನು ನನ್ನ ಹಕ್ಕನ್ನು ನಿನಗೆ ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ಆದರೆ ಯಾಕೋಬನು, “ನೀನು ಅದನ್ನು ಕೊಡುವುದಾಗಿ ಪ್ರಮಾಣಮಾಡು” ಅಂದನು. ಆದ್ದರಿಂದ ಏಸಾವನು ಯಾಕೋಬನಿಗೆ ಪ್ರಮಾಣ ಮಾಡಿದನು. ಹೀಗೆ ಏಸಾವನು ತನ್ನ ಚೊಚ್ಚಲತನದ ಹಕ್ಕನ್ನು ಯಾಕೋಬನಿಗೆ ಮಾರಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ಆಗ ಯಾಕೋಬನು ಏಸಾವನಿಗೆ ರೊಟ್ಟಿಯನ್ನೂ ಕುದಿಸಿದ ಅಲಸಂಧಿ ಗುಗ್ಗರಿಯನ್ನೂ ಕೊಟ್ಟನು. ಏಸಾವನು ತಿಂದು ಕುಡಿದು ಅಲ್ಲಿಂದ ಹೊರಟುಹೋದನು. ಹೀಗೆ ಏಸಾವನು ತನ್ನ ಚೊಚ್ಚಲತನದ ಹಕ್ಕುಗಳ ಮೇಲೆ ತನಗೆ ಚಿಂತೆಯಿಲ್ಲದಿರುವುದನ್ನು ತೋರಿಸಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ಅಬ್ರಹಾಮನ ಕಾಲದಲ್ಲಿ ಬಂದಿದ್ದ ಕ್ಷಾಮದಂತೆ ಮತ್ತೊಂದು ಕ್ಷಾಮವು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಬಂದಿತು. ಆದ್ದರಿಂದ ಇಸಾಕನು ಫಿಲಿಷ್ಟಿಯರ ರಾಜನಾದ ಅಬೀಮೆಲೆಕನ ಬಳಿಗೆ ಹೋದನು. ಅಬೀಮೆಲೆಕನು ಗೆರಾರ್ ನಗರದಲ್ಲಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ಯೆಹೋವನು ಇಸಾಕನಿಗೆ ಪ್ರತ್ಯಕ್ಷನಾಗಿ, “ನೀನು ಈಜಿಪ್ಟಿಗೆ ಹೋಗಬೇಡ. ನೀನು ಯಾವ ಪ್ರದೇಶದಲ್ಲಿರಬೇಕೆಂದು ನಾನು ಆಜ್ಞಾಪಿಸಿದೆನೋ ಆ ಪ್ರದೇಶದಲ್ಲಿ ವಾಸಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ನಾನು ನಿನ್ನ ಸಂಗಡವಿದ್ದು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿ ನಿನಗೂ ನಿನ್ನ ಕುಟುಂಬಕ್ಕೂ ಈ ಪ್ರದೇಶಗಳನ್ನೆಲ್ಲ ಕೊಡುವೆನು. ನಾನು ನಿನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನಿಗೆ ಪ್ರಮಾಣ ಮಾಡಿದ್ದನ್ನು ನೆರವೇರಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ನಾನು ನಿನ್ನ ಸಂತಾನವನ್ನು ಆಕಾಶದಲ್ಲಿನ ನಕ್ಷತ್ರಗಳಷ್ಟು ಹೆಚ್ಚಿಸಿ ಅವರಿಗೆ ಈ ಪ್ರದೇಶಗಳನ್ನೆಲ್ಲಾ ಕೊಡುವೆನು. ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಜನಾಂಗಗಳವರು ನಿನ್ನ ಸಂತತಿಯಿಂದ ಆಶೀರ್ವಾದ ಹೊಂದುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ನಾನೇ ಇದನ್ನು ನೆರವೇರಿಸುವೆನು; ಯಾಕೆಂದರೆ ನಿನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನು ನನ್ನ ಮಾತುಗಳಿಗೆ ವಿಧೇಯನಾಗಿ ನಾನು ಹೇಳಿದಂತೆ ಮಾಡಿ ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು, ಕಟ್ಟಳೆಗಳನ್ನು, ನಿಯಮಗಳನ್ನು ಕೈಕೊಂಡು ನಡೆದನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ಆದ್ದರಿಂದ ಇಸಾಕನು ಗೆರಾರಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡು ವಾಸಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ಇಸಾಕನ ಹೆಂಡತಿಯಾದ ರೆಬೆಕ್ಕಳು ತುಂಬ ಸೌಂದರ್ಯವತಿಯಾಗಿದ್ದಳು. ಆ ಸ್ಥಳದ ಗಂಡಸರು ರೆಬೆಕ್ಕಳ ಬಗ್ಗೆ ಇಸಾಕನನ್ನು ಕೇಳಿದರು. ಇಸಾಕನು ಅವರಿಗೆ, “ಆಕೆ ನನ್ನ ತಂಗಿ” ಎಂದು ಹೇಳಿದನು. ರೆಬೆಕ್ಕಳು ತನಗೆ ಹೆಂಡತಿಯಾಗಬೇಕೆಂದು ಅವರಿಗೆ ತಿಳಿದರೆ ಆಕೆಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಲು ಅವರು ತನ್ನನ್ನು ಕೊಲ್ಲಬಹುದೆಂಬ ಹೆದರಿಕೆಯಿಂದ ಇಸಾಕನು ಹಾಗೆ ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ಅಲ್ಲಿ ಇಸಾಕನು ಇದ್ದು ಬಹುಕಾಲವಾಗಿತ್ತು. ಒಮ್ಮೆ ಫಿಲಿಷ್ಟಿಯರ ರಾಜನಾದ ಅಬೀಮೆಲೆಕನು ತನ್ನ ಕಿಟಕಿಯಿಂದ ನೋಡಿದಾಗ, ಇಸಾಕನು ಮತ್ತು ಅವನ ಹೆಂಡತಿ ಸರಸವಾಡುತ್ತಿರುವುದನ್ನು ಕಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ಅಬೀಮೆಲೆಕನು ಇಸಾಕನನ್ನು ಕರೆದು, “ಈ ಸ್ತ್ರೀಯು ನಿನ್ನ ಹೆಂಡತಿ. ಅವಳು ನಿನ್ನ ತಂಗಿಯೆಂದು ಯಾಕೆ ನಮಗೆ ಹೇಳಿದೆ?” ಎಂದು ಕೇಳಿದನು. ಇಸಾಕನು ಅವನಿಗೆ, “ನೀನು ಆಕೆಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಲು ನನ್ನನ್ನು ಕೊಲ್ಲಬಹುದೆಂಬ ಭಯದಿಂದ ಹಾಗೆ ಹೇಳಿದೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ಅಬೀಮೆಲೆಕನು ಅವನಿಗೆ, “ನೀನು ನಮಗೆ ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡಿದೆ. ನಮ್ಮಲ್ಲಿರುವ ಯಾವ ಗಂಡಸಾದರೂ ನಿನ್ನ ಹೆಂಡತಿಯೊಡನೆ ಮಲಗಿಕೊಳ್ಳಲು ನೀನೇ ಆಸ್ಪದ ಮಾಡಿಕೊಟ್ಟಿದ್ದೆ. ಅಂಥದ್ದೇನಾದರೂ ನಡೆದಿದ್ದರೆ ಮಹಾ ಅಪರಾಧವಾಗುತ್ತಿತ್ತು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ಬಳಿಕ ಅಬೀಮೆಲೆಕನು ತನ್ನ ಪ್ರಜೆಗಳಿಗೆ, “ಈ ಮನುಷ್ಯನಿಗಾಗಲಿ ಇವನ ಹೆಂಡತಿಗಾಗಲಿ ಯಾರೂ ಕೇಡುಮಾಡಕೂಡದು. ಇವರಿಗೆ ಕೇಡುಮಾಡುವವನನ್ನು ಕೊಲ್ಲಲಾಗುವುದು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ಇಸಾಕನು ಆ ಪ್ರದೇಶದಲ್ಲಿ ಬೀಜ ಬಿತ್ತಿದನು; ಅವನಿಗೆ ಅದೇ ವರ್ಷದಲ್ಲಿ ಮಹಾ ಸುಗ್ಗಿಯಾಯಿತು. ಯೆಹೋವನು ಅವನನ್ನು ಹೆಚ್ಚಾಗಿ ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ಅವನ ಐಶ್ವರ್ಯವು ಹೆಚ್ಚುತ್ತಾ ಬಂದದ್ದರಿಂದ ಅವನು ಬಹು ಐಶ್ವರ್ಯವಂತನಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ಅವನಿಗೆ ಅನೇಕ ದನಕುರಿಗಳ ಮಂದೆಗಳೂ ಪ್ರಾಣಿಗಳ ಹಿಂಡೂಗಳೂ ಇದ್ದವು. ಇದಲ್ಲದೆ ಅವನಿಗೆ ಅನೇಕ ಸೇವಕರು ಇದ್ದರು. ಇದನ್ನು ಕಂಡು ಫಿಲಿಷ್ಟಿಯರು ಅವನ ಬಗ್ಗೆ ಅಸೂಯೆಪಡುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ಆದ್ದರಿಂದ ಅನೇಕ ವರ್ಷಗಳ ಹಿಂದೆ ಅಬ್ರಹಾಮ ಮತ್ತು ಅವನ ಸೇವಕರು ತೋಡಿದ್ದ ಬಾವಿಗಳಿಗೆ ಫಿಲಿಷ್ಟಿಯರು ಮಣ್ಣುಹಾಕಿ ಮುಚ್ಚಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ಅಬೀಮೆಲೆಕನು ಇಸಾಕನಿಗೆ, “ನಮ್ಮ ದೇಶವನ್ನು ಬಿಟ್ಟುಹೋಗು. ನೀನು ನಮಗಿಂತಲೂ ತುಂಬ ಬಲಿಷ್ಠನಾದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ಆದ್ದರಿಂದ ಇಸಾಕನು ಆ ಸ್ಥಳದಿಂದ ಹೊರಟು ಗೆರಾರಿನ ಚಿಕ್ಕಹೊಳೆಯ ಸಮೀಪದಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಂಡನು. ಇಸಾಕನು ಅಲ್ಲಿ ಇಳಿದುಕೊಂಡು ವಾಸಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ಇದಕ್ಕೂ ಬಹುಕಾಲದ ಹಿಂದೆ, ಅಬ್ರಹಾಮನು ಅನೇಕ ಬಾವಿಗಳನ್ನು ತೋಡಿಸಿದ್ದನು. ಅಬ್ರಹಾಮನು ಸತ್ತುಹೋದ ಮೇಲೆ, ಫಿಲಿಷ್ಟಿಯರು ಆ ಬಾವಿಗಳಿಗೆ ಮಣ್ಣುಹಾಕಿ ಮುಚ್ಚಿದ್ದರು. ಇಸಾಕನು ಆ ಬಾವಿಗಳನ್ನು ಮತ್ತೆ ತೋಡಿಸಿ, ತನ್ನ ತಂದೆ ಕೊಟ್ಟಿದ್ದ ಹೆಸರುಗಳನ್ನೇ ಅವುಗಳಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ಇಸಾಕನ ಸೇವಕರು ಚಿಕ್ಕ ಹೊಳೆಯ ಸಮೀಪದಲ್ಲಿ ಒಂದು ಬಾವಿಯನ್ನು ತೋಡಿದರು. ಆ ಬಾವಿಯಲ್ಲಿ ನೀರಿನ ಸೆಲೆ ಸಿಕ್ಕಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ಆದರೆ ಗೆರಾರಿನ ಕಣಿವೆಯಲ್ಲಿ ಕುರಿಕಾಯುತ್ತಿದ್ದ ಜನರು ಇಸಾಕನ ಸೇವಕರೊಡನೆ ವಾದಮಾಡಿ, “ಈ ನೀರು ನಮ್ಮದು” ಎಂದು ಹೇಳಿದರು. ಆದ್ದರಿಂದ ಇಸಾಕನು ಆ ಬಾವಿಗೆ “ಏಸೆಕ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ಆಮೇಲೆ ಇಸಾಕನ ಸೇವಕರು ಮತ್ತೊಂದು ಬಾವಿಯನ್ನು ತೋಡಿದರು. ಅಲ್ಲಿಯ ಜನರೂ ಆ ಬಾವಿಗಾಗಿ ವಾದಮಾಡಿದರು. ಆದ್ದರಿಂದ ಇಸಾಕನು ಆ ಬಾವಿಗೆ “ಸಿಟ್ನಾ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ಇಸಾಕನು ಅಲ್ಲಿಂದ ಹೊರಟು ಮತ್ತೊಂದು ಬಾವಿಯನ್ನು ತೋಡಿಸಿದನು. ಆ ಬಾವಿಯ ಕುರಿತು ವಾದಮಾಡಲು ಯಾರೂ ಬರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಇಸಾಕನು, “ಈಗ ಯೆಹೋವನು ನಮಗೋಸ್ಕರ ಒಂದು ಸ್ಥಳವನ್ನು ತೋರಿಸಿದ್ದಾನೆ. ನಾವು ಈ ಸ್ಥಳದಲ್ಲಿ ಅಭಿವೃದ್ಧಿಯಾಗೋಣ” ಎಂದು ಹೇಳಿ ಆ ಬಾವಿಗೆ “ರೆಹೋಬೋತ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ಇಸಾಕನು ಆ ಸ್ಥಳದಿಂದ ಬೇರ್ಷೆಬಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ಆ ರಾತ್ರಿ ಯೆಹೋವನು ಇಸಾಕನಿಗೆ ಪ್ರತ್ಯಕ್ಷನಾಗಿ, “ನಾನು ನಿನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನ ದೇವರು. ಭಯಪಡಬೇಡ, ನಾನು ನಿನ್ನ ಸಂಗಡವಿದ್ದೇನೆ. ನಾನು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು. ನಾನು ನಿನ್ನ ಕುಟುಂಬವನ್ನು ಉನ್ನತ ಸ್ಥಿತಿಗೆ ತರುವೆನು. ನನ್ನ ಸೇವಕನಾದ ಅಬ್ರಹಾಮನಿಗಾಗಿಯೇ ಇದನ್ನು ಮಾಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ಆದ್ದರಿಂದ ಆ ಸ್ಥಳದಲ್ಲಿ ಇಸಾಕನು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿದನು. ಇಸಾಕನು ಆ ಸ್ಥಳದಲ್ಲಿ ಪಾಳೆಯಮಾಡಿಕೊಂಡನು; ಅವನ ಸೇವಕರು ಅಲ್ಲಿ ಒಂದು ಬಾವಿಯನ್ನು ತೋಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ಅಬೀಮೆಲೆಕನು ಇಸಾಕನನ್ನು ಕಾಣಲು ಗೆರಾರಿನಿಂದ ಬಂದನು. ಅಬೀಮೆಲೆಕನು ತನ್ನ ಸಲಹೆಗಾರನಾದ ಅಹುಜ್ಜತನನ್ನು ಮತ್ತು ಸೇನಾಪತಿಯಾದ ಫೀಕೋಲನನ್ನು ತನ್ನೊಡನೆ ಕರೆದುಕೊಂಡು ಬಂದಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ಇಸಾಕನು, “ನೀನು ನನ್ನನ್ನು ನೋಡಲು ಬಂದದ್ದೇಕೆ? ಮೊದಲು, ನೀನು ನನ್ನೊಡನೆ ಸ್ನೇಹದಿಂದ ಇರಲಿಲ್ಲ. ಅಲ್ಲದೆ ನಿನ್ನ ದೇಶವನ್ನು ಬಿಟ್ಟುಹೋಗುವಂತೆ ನೀನು ನನ್ನನ್ನು ಬಲವಂತ ಮಾಡಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ಅವರು ಅವನಿಗೆ, “ನಿನ್ನ ಜೊತೆಯಲ್ಲಿ ಯೆಹೋವನು ಇದ್ದಾನೆಂಬುದು ಈಗ ನಮಗೆ ತಿಳಿಯಿತು. ನಾವು ಒಂದು ಒಪ್ಪಂದ ಮಾಡಿಕೊಳ್ಳಬೇಕೆಂಬುದು ನಮ್ಮ ಆಲೋಚನೆ. ನೀನು ನಮಗೆ ಒಂದು ಪ್ರಮಾಣ ಮಾಡಬೇಕಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ನಾವು ನಿನಗೆ ಕೇಡುಮಾಡಲಿಲ್ಲ. ಅದೇ ರೀತಿಯಲ್ಲಿ ಈಗ ನೀನೂ ನಮಗೆ ಕೇಡುಮಾಡುವುದಿಲ್ಲವೆಂದು ಪ್ರಮಾಣಮಾಡಬೇಕು. ನಾವು ನಿನ್ನನ್ನು ದೂರ ಕಳುಹಿಸಿದರೂ ಸಮಾಧಾನದಿಂದ ಕಳುಹಿಸಿಕೊಟ್ಟೆವು. ಯೆಹೋವನು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದಾನೆ ಎಂಬುದು ಈಗ ಸ್ಪಷ್ಟವಾಗಿದೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ಆದ್ದರಿಂದ ಇಸಾಕನು ಅವರಿಗಾಗಿ ಒಂದು ಔತಣವನ್ನು ಮಾಡಿಸಿದನು. ಅವರೆಲ್ಲರೂ ಸಮೃದ್ಧಿಯಾಗಿ ಊಟಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ಮರುದಿನ ಮುಂಜಾನೆ, ಅವರು ಒಬ್ಬರಿಗೊಬ್ಬರು ಪ್ರಮಾಣ ಮಾಡಿಕೊಂಡು, ಸಮಾಧಾನದಿಂದ ಹೊರಟುಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ಆ ದಿನ, ಇಸಾಕನ ಸೇವಕರು ಬಂದು, ತಾವು ತೋಡಿದ್ದ ಬಾವಿಯ ಬಗ್ಗೆ ಹೇಳುತ್ತಾ, “ಬಾವಿಯಲ್ಲಿ ನಮಗೆ ನೀರಿನ ಸೆಲೆ ಸಿಕ್ಕಿತು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ಆದ್ದರಿಂದ ಇಸಾಕನು ಆ ಬಾವಿಗೆ ಷಿಬಾ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಇಂದಿಗೂ ಆ ನಗರಕ್ಕೆ ಬೇರ್ಷೆಬ ಎಂದು ಕರೆಯುತ್ತಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ಏಸಾವನಿಗೆ ನಲವತ್ತು ವರ್ಷಗಳಾಗಿದ್ದಾಗ ಅವನು ಹಿತ್ತಿಯರ ಇಬ್ಬರು ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡನು. ಒಬ್ಬಳು ಬೇರಿಯನ ಮಗಳಾದ ಯೆಹೂದೀತಳು, ಮತ್ತೊಬ್ಬಳು ಏಲೋನನ ಮಗಳಾದ ಬಾಸೆಮತಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ಈ ಮದುವೆಗಳಿಂದ ಇಸಾಕ ಮತ್ತು ರೆಬೆಕ್ಕಳಿಗೆ ತುಂಬ ದುಃಖವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ಇಸಾಕನು ಮುದುಕನಾದಾಗ ಅವನಿಗೆ ಕಣ್ಣುಗಳು ಸ್ಪಷ್ಟವಾಗಿ ಕಾಣುತ್ತಿರಲಿಲ್ಲ. ಒಂದು ದಿನ ಅವನು ತನ್ನ ಹಿರಿಮಗನಾದ ಏಸಾವನನ್ನು ತನ್ನ ಬಳಿಗೆ ಕರೆದು ಅವನಿಗೆ, “ಮಗನೇ” ಅಂದನು. ಏಸಾವನು, “ಇಗೋ ಇದ್ದೇನೆ” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ಇಸಾಕನು ಅವನಿಗೆ, “ನನಗೆ ವಯಸ್ಸಾಯಿತು. ನಾನು ಬಹುಬೇಗನೆ ಸಾಯಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ಆದ್ದರಿಂದ ನಿನ್ನ ಬಿಲ್ಲುಬಾಣಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬೇಟೆಗೆ ಹೋಗು. ನನಗೋಸ್ಕರ ಒಂದು ಪ್ರಾಣಿಯನ್ನು ಬೇಟೆಯಾಡಿಕೊಂಡು ಬಂದು ");
INSERT INTO kan2010_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ನನಗೆ ಇಷ್ಟವಾದ ಅಡಿಗೆಯನ್ನು ತಯಾರಿಸಿ ತೆಗೆದುಕೊಂಡು ಬಾ. ನಾನು ಸಾಯುವ ಮೊದಲೇ ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ಆದ್ದರಿಂದ ಏಸಾವನು ಬೇಟೆಗಾಗಿ ಹೋದನು. ಇಸಾಕನು ತನ್ನ ಮಗನಾದ ಏಸಾವನಿಗೆ ಹೇಳಿದ ಈ ವಿಷಯಗಳನ್ನೆಲ್ಲ ರೆಬೆಕ್ಕಳು ಕೇಳಿಸಿಕೊಂಡಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ರೆಬೆಕ್ಕಳು ತನ್ನ ಮಗನಾದ ಯಾಕೋಬನಿಗೆ, “ಕೇಳು, ನಿನ್ನ ತಂದೆಯು ನಿನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನೊಡನೆ ಮಾತಾಡುತ್ತಿರುವುದನ್ನು ನಾನು ಕೇಳಿಸಿಕೊಂಡೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ನಿನ್ನ ತಂದೆ ಅವನಿಗೆ, ‘ನನಗೋಸ್ಕರ ಒಂದು ಪ್ರಾಣಿಯನ್ನು ಬೇಟೆಯಾಡಿಕೊಂಡು ಬಂದು ನನಗೆ ಇಷ್ಟವಾದ ಅಡಿಗೆಯನ್ನು ತಯಾರಿಸಿ ತೆಗೆದುಕೊಂಡು ಬಾ. ನಾನು ಸಾಯುವ ಮೊದಲೇ ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು’ ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ಆದ್ದರಿಂದ ಮಗನೇ, ನನ್ನ ಮಾತನ್ನು ಕೇಳು ಮತ್ತು ನಾನು ಹೇಳಿದ್ದನ್ನು ಮಾಡು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ನಮ್ಮ ಆಡುಗಳ ಬಳಿಗೆ ಹೋಗಿ ಎರಡು ಆಡುಮರಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬಾ. ನಿಮ್ಮ ತಂದೆಗೆ ಇಷ್ಟವಾದ ಅಡಿಗೆಯನ್ನು ನಾನು ಅವುಗಳ ಮಾಂಸದಿಂದ ಸಿದ್ಧಪಡಿಸುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ನೀನು ಆ ಅಡಿಗೆಯನ್ನು ನಿನ್ನ ತಂದೆಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗು. ಆಗ ಅವನು ತಾನು ಸಾಯುವ ಮೊದಲೇ ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವನು” ಅಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ಅದಕ್ಕೆ ಯಾಕೋಬನು ತನ್ನ ತಾಯಿಯಾದ ರೆಬೆಕ್ಕಳಿಗೆ, “ನನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನಿಗೆ ಮೈತುಂಬ ರೋಮಗಳಿವೆ, ಆದರೆ ನನಗೆ ರೋಮಗಳಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ನನ್ನ ತಂದೆ ನನ್ನನ್ನು ಮುಟ್ಟಿದರೆ, ನಾನು ಏಸಾವನಲ್ಲವೆಂದು ತಿಳಿದುಕೊಳ್ಳುವನು. ಆಗ ಅವನು ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವುದಿಲ್ಲ. ನಾನು ಅವನನ್ನು ಮೋಸಗೊಳಿಸಲು ಪ್ರಯತ್ನಿಸಿದ್ದರಿಂದ ಅವನು ನನ್ನನ್ನು ಶಪಿಸುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ಅದಕ್ಕೆ ರೆಬೆಕ್ಕಳು ಅವನಿಗೆ, “ಅವನು ನಿನಗೆ ಶಾಪಕೊಟ್ಟರೆ, ಆ ಶಾಪವು ನನಗಾಗಲಿ. ನಾನು ಹೇಳಿದಂತೆ ಮಾಡು. ನನಗೋಸ್ಕರ ಆಡುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬಾ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ಆದ್ದರಿಂದ ಯಾಕೋಬನು ಹೋಗಿ ಎರಡು ಆಡುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬಂದನು. ಇಸಾಕನಿಗೆ ಇಷ್ಟವಾದ ರುಚಿಕರವಾದ ಪದಾರ್ಥಗಳನ್ನು ಆಕೆ ಅವುಗಳ ಮಾಂಸದಿಂದ ತಯಾರಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ಅನಂತರ ರೆಬೆಕ್ಕಳು ತನ್ನ ಹಿರಿಯ ಮಗನಾದ ಏಸಾವನಿಗೆ ಇಷ್ಟವಾದ ಉಡುಪನ್ನು ತೆಗೆದುಕೊಂಡಳು. ರೆಬೆಕ್ಕಳು ಆ ಉಡುಪನ್ನು ತನ್ನ ಕಿರಿಮಗನಾದ ಯಾಕೋಬನಿಗೆ ತೊಡಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ಆಡುಗಳ ಚರ್ಮವನ್ನು ಯಾಕೋಬನ ಕೈಗಳಿಗೂ ಕೊರಳಿಗೂ ಸುತ್ತಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ಅನಂತರ ಆಕೆ ತಾನು ಸಿದ್ಧಪಡಿಸಿದ್ದ ಅಡಿಗೆಯನ್ನು ಯಾಕೋಬನಿಗೆ ಕೊಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಹೋಗಿ, “ಅಪ್ಪಾ” ಎಂದು ಕರೆದನು. ಅವನ ತಂದೆ, “ಏನು ಮಗನೇ, ನೀನು ಯಾರು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ಯಾಕೋಬನು ತನ್ನ ತಂದೆಗೆ, “ನಾನು ಏಸಾವ, ನಿನ್ನ ಮೊದಲನೆ ಮಗ. ನೀನು ಹೇಳಿದಂತೆ ನಾನು ಮಾಡಿಕೊಂಡು ಬಂದಿದ್ದೇನೆ. ನಾನು ನಿನಗೋಸ್ಕರ ಬೇಟೆಯಾಡಿದ ಪ್ರಾಣಿಯ ಮಾಂಸವನ್ನು ಕುಳಿತುಕೊಂಡು ತಿನ್ನು. ಅನಂತರ ನೀನು ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ಆದರೆ ಇಸಾಕನು ತನ್ನ ಮಗನಿಗೆ, “ನೀನು ಇಷ್ಟು ಬೇಗನೆ ಬೇಟೆಯಾಡಿಕೊಂಡು ಬಂದೆಯಾ?” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕೆ ಯಾಕೋಬನು, “ನಾನು ಬಹುಬೇಗನೆ ಪ್ರಾಣಿಗಳನ್ನು ಕಂಡುಕೊಳ್ಳುವಂತೆ ನಿನ್ನ ದೇವರಾದ ಯೆಹೋವನು ಸಹಾಯ ಮಾಡಿದನು” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ಬಳಿಕ ಇಸಾಕನು ಯಾಕೋಬನಿಗೆ, “ನನ್ನ ಬಳಿಗೆ ಬಾ, ನನ್ನ ಮಗನನ್ನು ನಾನು ಮುಟ್ಟಿ ತಿಳಿದುಕೊಳ್ಳಬಲ್ಲೆ. ನಾನು ನಿನ್ನನ್ನು ಮುಟ್ಟಿದರೆ, ನೀನು ನಿಜವಾಗಿಯೂ ನನ್ನ ಮಗನಾದ ಏಸಾವನೋ ಇಲ್ಲವೋ ಎಂಬುದನ್ನು ತಿಳಿದುಕೊಳ್ಳಬಲ್ಲೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ಆದ್ದರಿಂದ ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನ ಬಳಿಗೆ ಹೋದನು. ಇಸಾಕನು ಅವನನ್ನು ಮುಟ್ಟಿ, “ನಿನ್ನ ಸ್ವರ ಯಾಕೋಬನ ಸ್ವರವಿದ್ದಂತಿದೆ. ಆದರೆ ನಿನ್ನ ಕೈಗಳು ಏಸಾವನ ಕೈಗಳಂತೆ ರೋಮದಿಂದ ಕೂಡಿವೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ಅವನು ಯಾಕೋಬನೆಂಬುದು ಇಸಾಕನಿಗೆ ತಿಳಿಯಲಿಲ್ಲ. ಯಾಕೆಂದರೆ ಅವನ ಕೈಗಳು ಏಸಾವನ ಕೈಗಳಂತೆ ರೋಮದಿಂದ ಕೂಡಿದ್ದವು. ಆದ್ದರಿಂದ ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ಇಸಾಕನು ಅವನಿಗೆ, “ನೀನು ನಿಜವಾಗಿಯೂ ನನ್ನ ಮಗನಾದ ಏಸಾವನೋ?” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕೆ ಯಾಕೋಬನು, “ಹೌದು, ನಾನೇ” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ಆಗ ಇಸಾಕನು, “ಊಟವನ್ನು ತೆಗೆದುಕೊಂಡು ಬಾ. ನಾನು ಊಟಮಾಡಿ ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ಅಂತೆಯೇ ಯಾಕೋಬನು ಊಟವನ್ನು ತಂದು ಕೊಟ್ಟಾಗ ಊಟಮಾಡಿದನು; ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ಬಳಿಕ ಇಸಾಕನು ಅವನಿಗೆ, “ಮಗನೇ, ನನ್ನ ಬಳಿಗೆ ಬಂದು ನನಗೆ ಮುದ್ದಿಡು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ಅದರಂತೆಯೇ ಯಾಕೋಬನು ತಂದೆಯ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ ಮುದ್ದಿಟ್ಟನು. ಇಸಾಕನು ಏಸಾವನ ಉಡುಪಿನ ವಾಸನೆಯನ್ನು ನೋಡಿ ಅವನನ್ನು ಹೀಗೆ ಆಶೀರ್ವದಿಸಿದನು: “ನನ್ನ ಮಗನ ಸುವಾಸನೆಯು ಯೆಹೋವನು ಆಶೀರ್ವದಿಸಿದ ಪ್ರದೇಶಗಳಂತಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ಯೆಹೋವನು ನಿನಗೆ ಬೇಕಾದಷ್ಟು ಮಳೆಯನ್ನು ಕೊಡಲಿ; ನಿನಗೆ ಸಾರವುಳ್ಳ ಭೂಮಿಯೂ ಮಹಾಸುಗ್ಗಿಗಳೂ ಮತ್ತು ದ್ರಾಕ್ಷಾರಸವೂ ದೊರೆಯಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ಎಲ್ಲಾ ಜನರು ನಿನ್ನ ಸೇವೆಮಾಡಲಿ; ಜನಾಂಗಗಳು ನಿನಗೆ ತಲೆಬಾಗಲಿ. ನೀನು ನಿನ್ನ ಸಹೋದರರ ಮೇಲೆ ಆಡಳಿತ ಮಾಡುವೆ. ನಿನ್ನ ತಾಯಿಯ ಗಂಡುಮಕ್ಕಳು ನಿನಗೆ ತಲೆಬಾಗಿ ವಿಧೇಯರಾಗುವರು. ನಿನ್ನನ್ನು ಶಪಿಸುವ ಪ್ರತಿಯೊಬ್ಬನು ಶಾಪಗ್ರಸ್ಥನಾಗುವನು. ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವ ಪ್ರತಿಯೊಬ್ಬನು ಆಶೀರ್ವದಿಸಲ್ಪಡುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಆಶೀರ್ವದಿಸಿದ ಬಳಿಕ ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನ ಬಳಿಯಿಂದ ಹೊರಟುಹೋಗುವಷ್ಟರಲ್ಲಿ ಏಸಾವನು ಬೇಟೆಯಿಂದ ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ಏಸಾವನು ಸಹ ತನ್ನ ತಂದೆಗೆ ಇಷ್ಟವಾದ ರೀತಿಯಲ್ಲಿ ವಿಶೇಷವಾದ ಆಹಾರವನ್ನು ಸಿದ್ಧಪಡಿಸಿ ತನ್ನ ತಂದೆಯ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಬಂದನು. ಅವನು ತನ್ನ ತಂದೆಗೆ, “ಅಪ್ಪಾ ಎದ್ದೇಳು, ನಿನಗೋಸ್ಕರ ನಿನ್ನ ಮಗನು ಬೇಟೆಯಾಡಿದ ಪ್ರಾಣಿಯ ಮಾಂಸವನ್ನು ತಿನ್ನು, ನಂತರ ನೀನು ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ಇಸಾಕನು ಅವನಿಗೆ, “ನೀನು ಯಾರು?” ಎಂದು ಕೇಳಿದನು. ಅವನು, “ನಾನು ನಿನ್ನ ಹಿರಿಯಮಗನಾದ ಏಸಾವ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ಆಗ ಇಸಾಕನು ತುಂಬ ವ್ಯಸನಗೊಂಡು ಗಡಗಡನೆ ನಡುಗುತ್ತಾ ಅವನಿಗೆ, “ನೀನು ಬರುವುದಕ್ಕಿಂತ ಮೊದಲೇ ಅಡಿಗೆಯನ್ನು ಸಿದ್ಧಪಡಿಸಿ ನನಗೆ ತಂದುಕೊಟ್ಟವನು ಯಾರು? ನಾನು ಅದನ್ನೆಲ್ಲ ತಿಂದು ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದೆನು. ಈಗ ನನ್ನ ಆಶೀರ್ವಾದವನ್ನು ಹಿಂತೆಗೆದುಕೊಳ್ಳಲಾಗದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ಏಸಾವನು ತನ್ನ ತಂದೆಯ ಮಾತುಗಳನ್ನು ಕೇಳಿ ತುಂಬ ಕೋಪಗೊಂಡನು; ವ್ಯಥೆಪಟ್ಟನು; ಗೋಳಾಡಿದನು. ಅವನು ತನ್ನ ತಂದೆಗೆ, “ಹಾಗಾದರೆ, ನನ್ನನ್ನೂ ಆಶೀರ್ವದಿಸಪ್ಪಾ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ಇಸಾಕನು, “ನಿನ್ನ ತಮ್ಮನು ನನ್ನನ್ನು ಮೋಸಗೊಳಿಸಿದನು; ಅವನು ಬಂದು ನಿನ್ನ ಆಶೀರ್ವಾದವನ್ನು ತೆಗೆದುಕೊಂಡನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ಏಸಾವನು, “ಅವನ ಹೆಸರು ಯಾಕೋಬ (ಮೋಸಗಾರ). ಅದೇ ಅವನಿಗೆ ಸರಿಯಾದ ಹೆಸರು. ಅವನು ಎರಡು ಸಲ ನನಗೆ ಮೋಸಮಾಡಿದನು. ನನ್ನ ಚೊಚ್ಚಲತನದ ಹಕ್ಕನ್ನು ತೆಗೆದುಕೊಂಡನು. ಈಗ ನನ್ನ ಆಶೀರ್ವಾದವನ್ನೂ ತೆಗೆದುಕೊಂಡನು” ಎಂದು ಹೇಳಿದನು. ನಂತರ ಏಸಾವನು, “ನನಗೋಸ್ಕರ ಯಾವ ಆಶೀರ್ವಾದವೂ ಉಳಿದಿಲ್ಲವೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ಇಸಾಕನು, “ಇಲ್ಲ, ತುಂಬ ತಡವಾಯಿತು. ನಿನ್ನ ಮೇಲೆ ಆಡಳಿತ ಮಾಡುವ ಅಧಿಕಾರವನ್ನು ನಾನು ಯಾಕೋಬನಿಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ಅವನ ಸಹೋದರರೆಲ್ಲ ಅವನಿಗೆ ಸೇವಕರಾಗಿರುವರು ಎಂದು ನಾನು ಹೇಳಿದ್ದೇನೆ. ಅವನಿಗೆ ಬೇಕಾದಷ್ಟು ದವಸಧಾನ್ಯಗಳೂ ದ್ರಾಕ್ಷಾರಸವೂ ದೊರೆಯುವಂತೆ ಆಶೀರ್ವಾದ ಮಾಡಿದ್ದೇನೆ. ನಿನಗೆ ಕೊಡಲು ನನ್ನಲ್ಲಿ ಏನೂ ಉಳಿದಿಲ್ಲ ಮಗನೇ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ಆದರೆ ಏಸಾವನು ತನ್ನ ತಂದೆಯನ್ನು ಮತ್ತೆ ಬೇಡತೊಡಗಿದನು. “ಅಪ್ಪಾ ನನಗಾಗಿ ಒಂದಾದರೂ ಆಶೀರ್ವಾದವಿಲ್ಲವೇ? ಅಪ್ಪಾ, ನನ್ನನ್ನು ಸಹ ಆಶೀರ್ವದಿಸು” ಎಂದು ಏಸಾವನು ಅಳಲಾರಂಭಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ಆಗ ಇಸಾಕನು ಅವನಿಗೆ ಹೀಗೆ ಹೇಳಿದನು: “ನೀನು ಒಳ್ಳೆಯ ಪ್ರದೇಶದಲ್ಲಿ ಜೀವಿಸುವುದಿಲ್ಲ. ನಿನಗೆ ಬೇಕಾದಷ್ಟು ಇಬ್ಬನಿ ಇರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ನೀನು ಕತ್ತಿಯಿಂದಲೇ ಜೀವಿಸುವೆ. ನೀನು ನಿನ್ನ ತಮ್ಮನ ಸೇವಕನಾಗಿರುವೆ. ಆದರೆ ನೀನು ಬಿಡುಗಡೆಯಾಗಲು ಹೋರಾಡಿ ಅವನ ಹಿಡಿತದಿಂದ ತಪ್ಪಿಸಿಕೊಳ್ಳುವೆ.” ");
INSERT INTO kan2010_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ಅಂದಿನಿಂದ ಏಸಾವನು ಯಾಕೋಬನನ್ನು ದ್ವೇಷಿಸಿದನು. ಏಸಾವನು ತನ್ನೊಳಗೆ, “ನನ್ನ ತಂದೆ ಬಹುಬೇಗನೆ ಸತ್ತುಹೋಗುವನು. ಆಗ ನಾನು ಅವನಿಗಾಗಿ ದುಃಖಿಸಿ ಆ ಬಳಿಕ ಯಾಕೋಬನನ್ನು ಕೊಲ್ಲುವೆನು” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ಏಸಾವನು ಯಾಕೋಬನನ್ನು ಕೊಲ್ಲಬೇಕೆಂದಿರುವುದು ರೆಬೆಕ್ಕಳಿಗೆ ತಿಳಿಯಿತು. ಆಕೆ ಯಾಕೋಬನನ್ನು ಕರೆಸಿ ಅವನಿಗೆ, “ಕೇಳು, ನಿನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನು ನಿನ್ನನ್ನು ಕೊಲ್ಲಬೇಕೆಂದಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ಆದ್ದರಿಂದ ಮಗನೇ, ನಾನು ಹೇಳಿದಂತೆ ಮಾಡು. ನನ್ನ ಅಣ್ಣನಾದ ಲಾಬಾನನು ಹಾರಾನಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾನೆ. ಅವನ ಬಳಿಗೆ ಹೋಗಿ ಅಡಗಿಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ನಿನ್ನ ಅಣ್ಣನ ಕೋಪ ತಣ್ಣಗಾಗುವವರೆಗೆ ನೀನು ಸ್ವಲ್ಪ ಕಾಲ ಅವನೊಂದಿಗಿರು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ಸ್ವಲ್ಪ ಸಮಯದ ನಂತರ, ನೀನು ಮಾಡಿದ್ದನ್ನು ನಿನ್ನ ಅಣ್ಣನು ಮರೆತುಬಿಡುವನು. ಆಗ ನಿನ್ನನ್ನು ಅಲ್ಲಿಂದ ಕರೆದುಕೊಂಡು ಬರಲು ನಾನು ಒಬ್ಬ ಸೇವಕನನ್ನು ಅಲ್ಲಿಗೆ ಕಳುಹಿಸಿಕೊಡುವೆನು. ಒಂದೇ ದಿನದಲ್ಲಿ, ನನ್ನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳನ್ನು ಕಳೆದುಕೊಳ್ಳಲು ನನಗೆ ಇಷ್ಟವಿಲ್ಲ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ನಂತರ ರೆಬೆಕ್ಕಳು ಇಸಾಕನಿಗೆ, “ನಿನ್ನ ಮಗನಾದ ಏಸಾವನು ಹಿತ್ತಿಯರ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡಿದ್ದಾನೆ. ಆ ಸ್ತ್ರೀಯರಿಂದ ನನಗೆ ಸಾಕಾಗಿ ಹೋಗಿದೆ; ಯಾಕೆಂದರೆ ಅವರು ನಮ್ಮ ಜನರಲ್ಲ. ಯಾಕೋಬನು ಸಹ ಇಂಥ ಸ್ತ್ರೀಯರಲ್ಲಿ ಒಬ್ಬಳನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡರೆ ನಾನು ಸಾಯುವುದೇ ಮೇಲು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಕರೆದು ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿ ಅವನಿಗೆ, “ನೀನು ಕಾನಾನಿನ ಸ್ತ್ರೀಯನ್ನು ಮದುವೆಯಾಗಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ಆದ್ದರಿಂದ ಈ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಪದ್ದನ್‌ಅರಾಮಿಗೆ ಹೊರಟು ನಿನ್ನ ತಾಯಿಯ ತಂದೆಯಾದ ಬೆತೂವೇಲನ ಮನೆಗೆ ಹೋಗು. ನಿನ್ನ ತಾಯಿಯ ಅಣ್ಣನಾದ ಲಾಬಾನನು ಅಲ್ಲಿ ವಾಸಿಸುತ್ತಿದ್ದಾನೆ. ಅವನ ಹೆಣ್ಣುಮಕ್ಕಳಲ್ಲಿ ಒಬ್ಬಳನ್ನು ಮದುವೆ ಮಾಡಿಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ಸರ್ವಶಕ್ತನಾದ ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿ, ನಿನಗೆ ಅನೇಕ ಮಕ್ಕಳನ್ನು ಕೊಡುವಂತೆಯೂ ನೀನು ಮಹಾಜನಾಂಗದ ತಂದೆಯಾಗುವಂತೆಯೂ ನಾನು ಪ್ರಾರ್ಥಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ದೇವರು ಅಬ್ರಹಾಮನನ್ನು ಆಶೀರ್ವದಿಸಿದ ರೀತಿಯಲ್ಲಿ ನಿನ್ನನ್ನೂ ನಿನ್ನ ಮಕ್ಕಳನ್ನೂ ಆಶೀರ್ವದಿಸುವಂತೆಯೂ ನೀನು ವಾಸಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಸ್ವಂತ ಭೂಮಿಯನ್ನು ಪಡೆದುಕೊಳ್ಳುವಂತೆಯೂ ನಾನು ಪ್ರಾರ್ಥಿಸುವೆನು. ದೇವರು ಅಬ್ರಹಾಮನಿಗೆ ಕೊಟ್ಟ ಭೂಮಿಯೇ ಅದು” ಎಂದು ಹೇಳಿ ಕಳುಹಿಸಿಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ಅಂತೆಯೇ ಯಾಕೋಬನು ಪದ್ದನ್‌ಅರಾಮಿಗೆ ಹೊರಟು ರೆಬೆಕ್ಕಳ ಅಣ್ಣನಾದ ಲಾಬಾನನ ಬಳಿಗೆ ಹೋದನು. ಬೆತೂವೇಲನು ಲಾಬಾನನ ಮತ್ತು ರೆಬೆಕ್ಕಳ ತಂದೆ. ರೆಬೆಕ್ಕಳು ಯಾಕೋಬನ ಮತ್ತು ಏಸಾವನ ತಾಯಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನು ಯಾಕೋಬನನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದೂ, ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಲು ಪದ್ದನ್‌ಅರಾಮಿಗೆ ಕಳುಹಿಸಿದ್ದೂ, ಕಾನಾನಿನ ಸ್ತ್ರೀಯನ್ನು ಮದುವೆಯಾಗಕೂಡದೆಂದು ಯಾಕೋಬನಿಗೆ ಆಜ್ಞಾಪಿಸಿರುವುದೂ ಏಸಾವನಿಗೆ ತಿಳಿಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ಇದಲ್ಲದೆ ಯಾಕೋಬನು ತನ್ನ ತಂದೆತಾಯಿಗಳಿಗೆ ವಿಧೇಯನಾಗಿ ಪದ್ದನ್‌ಅರಾಮಿಗೆ ಹೋದದ್ದೂ ಏಸಾವನಿಗೆ ಗೊತ್ತಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ತನ್ನ ತಂದೆಗೆ ತನ್ನ ಗಂಡುಮಕ್ಕಳು ಕಾನಾನಿನ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆಯಾಗುವುದು ಇಷ್ಟವಿಲ್ಲವೆಂಬುದೂ ಏಸಾವನಿಗೆ ತಿಳಿಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ಏಸಾವನಿಗೆ ಈಗಾಗಲೇ ಇಬ್ಬರು ಹೆಂಡತಿಯರಿದ್ದರು. ಆದರೂ ಅವನು ಇಷ್ಮಾಯೇಲನ ಬಳಿಗೆ ಹೋಗಿ ಅವನ ಮಗಳಾದ ಮಹಲತ್ ಎಂಬಾಕೆಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡನು. ಇಷ್ಮಾಯೇಲನು ಅಬ್ರಹಾಮನ ಮಗನು. ಮಹಲತಳು ನೆಬಾಯೋತನ ತಂಗಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ಯಾಕೋಬನು ಬೇರ್ಷೆಬವನ್ನು ಬಿಟ್ಟು ಹಾರಾನಿಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ಯಾಕೋಬನು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿರುವಾಗ ಸೂರ್ಯಾಸ್ತವಾಯಿತು. ಆದ್ದರಿಂದ ಯಾಕೋಬನು ಆ ರಾತ್ರಿ ಇಳಿದುಕೊಳ್ಳಲು ಒಂದು ಸ್ಥಳಕ್ಕೆ ಹೋದನು. ಯಾಕೋಬನು ಆ ಸ್ಥಳದಲ್ಲಿ ಒಂದು ಕಲ್ಲನ್ನು ಕಂಡು ಅದರ ಮೇಲೆ ತಲೆಯಿಟ್ಟು ಮಲಗಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ಯಾಕೋಬನಿಗೆ ಒಂದು ಕನಸಾಯಿತು. ಆ ಕನಸಿನಲ್ಲಿ ಒಂದು ಏಣಿ ನೆಲದ ಮೇಲೆ ನಿಂತಿತ್ತು, ಅದರ ತುದಿ ಆಕಾಶವನ್ನು ಮುಟ್ಟಿತ್ತು. ದೇವದೂತರು ಅದರಲ್ಲಿ ಮೇಲೆರುತ್ತಾ ಕೆಳಗಿಳಿಯುತ್ತಾ ಇರುವುದನ್ನು ಯಾಕೋಬನು ಕಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ಯೆಹೋವನು ಏಣಿಯ ತುದಿಯಲ್ಲಿ ನಿಂತಿರುವುದನ್ನು ಯಾಕೋಬನು ಕಂಡನು. ಯೆಹೋವನು ಅವನಿಗೆ, “ನಿನ್ನ ತಾತನಾದ ಅಬ್ರಹಾಮನ ದೇವರಾಗಿರುವ ಯೆಹೋವನೇ ನಾನು. ನಾನು ಇಸಾಕನ ದೇವರು. ಈಗ ನೀನು ಮಲಗಿಕೊಂಡಿರುವ ದೇಶವನ್ನು ನಾನು ನಿನಗೆ ಕೊಡುವೆನು. ನಾನು ಈ ದೇಶವನ್ನು ನಿನಗೂ ನಿನ್ನ ಮಕ್ಕಳಿಗೂ ಕೊಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ಭೂಮಿಯ ಮೇಲೆ ಧೂಳಿನ ಕಣಗಳಿರುವಂತೆ ನಿನಗೆ ಅನೇಕಾನೇಕ ಸಂತತಿಗಳಿರುವರು. ಅವರು ಪೂರ್ವಪಶ್ಚಿಮಗಳಿಗೂ ಉತ್ತರದಕ್ಷಿಣಗಳಿಗೂ ಹರಡಿಕೊಳ್ಳುವರು. ನಿನ್ನ ಮೂಲಕವೂ ನಿನ್ನ ಸಂತತಿಯವರ ಮೂಲಕವೂ ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಕುಲಗಳವರು ಆಶೀರ್ವಾದ ಹೊಂದುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","“ನಾನು ನಿನ್ನ ಸಂಗಡವಿದ್ದು ನೀನು ಹೋಗುವ ಪ್ರತಿಯೊಂದು ಸ್ಥಳದಲ್ಲಿಯೂ ನಿನ್ನನ್ನು ಕಾಪಾಡುವೆನು; ನಿನ್ನನ್ನು ಈ ಸ್ಥಳಕ್ಕೆ ಮತ್ತೆ ಕರೆದುಕೊಂಡು ಬರುವೆನು. ನಾನು ವಾಗ್ದಾನ ಮಾಡಿದ್ದನ್ನು ನೆರವೇರಿಸುವ ತನಕ ನಾನು ನಿನ್ನನ್ನು ಬಿಟ್ಟು ಹೋಗುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ಆಗ ಯಾಕೋಬನು ನಿದ್ರೆಯಿಂದ ಎಚ್ಚೆತ್ತು, “ಖಂಡಿತವಾಗಿಯೂ ಈ ಸ್ಥಳದಲ್ಲಿ ದೇವರಿದ್ದಾನೆ, ಆದರೆ ಅದು ನನಗೆ ಗೊತ್ತಿರಲಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ಯಾಕೋಬನಿಗೆ ಭಯವಾಗಿತ್ತು. ಅವನು, “ಇದು ತುಂಬ ಮಹತ್ವವಾದ ಸ್ಥಳ. ಇದು ದೇವರ ಮನೆ. ಇದು ಸ್ವರ್ಗಕ್ಕೆ ಬಾಗಿಲು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ಯಾಕೋಬನು ಮರುದಿನ ಮುಂಜಾನೆ ಬೇಗನೆ ಎದ್ದು, ತಾನು ಮಲಗಿಕೊಂಡಿದ್ದ ಕಲ್ಲನ್ನು ತೆಗೆದುಕೊಂಡು ಅದನ್ನು ಕಂಬವಾಗಿ ನೆಲದಲ್ಲಿ ನಿಲ್ಲಿಸಿದನು. ನಂತರ ಆ ಕಲ್ಲಿನ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಸುರಿದನು. ಹೀಗೆ ಅವನು ಆ ಕಲ್ಲನ್ನು ದೇವರ ನೆನಪಿಗಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ಆ ಸ್ಥಳದ ಹೆಸರು ಲೂಜ್. ಆದರೆ ಯಾಕೋಬನು ಅದಕ್ಕೆ ಬೇತೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ನಂತರ ಯಾಕೋಬನು ಈ ಪ್ರಮಾಣವನ್ನು ಮಾಡಿದನು: “ದೇವರು ನನ್ನ ಸಂಗಡವಿದ್ದು ನಾನು ಹೋದಲ್ಲೆಲ್ಲ ನನ್ನನ್ನು ಕಾಪಾಡಿ ಊಟಕ್ಕೆ ಆಹಾರವನ್ನೂ, ಉಡಲು ಬಟ್ಟೆಗಳನ್ನೂ ಕೊಟ್ಟು, ");
INSERT INTO kan2010_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ನಾನು ಸಮಾಧಾನದಿಂದ ನನ್ನ ತಂದೆಯ ಮನೆಗೆ ಹಿಂತಿರುಗಿ ಬರುವಂತೆ ಮಾಡಿದರೆ ಯೆಹೋವನೇ ನನ್ನ ದೇವರಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ನಾನು ಕಲ್ಲನ್ನು ನೆಟ್ಟಿರುವ ಈ ಸ್ಥಳವು ದೇವರ ಪವಿತ್ರಸ್ಥಳವಾಗುವುದು. ಇದಲ್ಲದೆ ದೇವರು ನನಗೆ ಕೊಡುವುದರಲ್ಲೆಲ್ಲಾ ಹತ್ತನೆಯ ಒಂದು ಭಾಗವನ್ನು ನಾನು ಆತನಿಗೆ ಕೊಡುತ್ತೇನೆ.” ");
INSERT INTO kan2010_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ಬಳಿಕ ಯಾಕೋಬನು ತನ್ನ ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರಿಸಿದನು. ಅವನು ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿದ್ದ ನಾಡಿಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ಯಾಕೋಬನು ದೃಷ್ಟಿಸಿ ನೋಡಿದಾಗ, ಹೊಲದಲ್ಲಿ ಅವನಿಗೆ ಒಂದು ಬಾವಿ ಕಾಣಿಸಿತು. ಬಾವಿಯ ಸಮೀಪದಲ್ಲಿ ಮೂರು ಕುರಿಮಂದೆಗಳು ಮಲಗಿಕೊಂಡಿದ್ದವು. ಕುರಿಗಳಿಗೆ ಆ ಬಾವಿಯ ನೀರನ್ನೇ ಕುಡಿಸುತ್ತಿದ್ದರು. ಬಾವಿಯ ಮೇಲೆ ಅಗಲವಾದ ದೊಡ್ಡ ಕಲ್ಲನ್ನು ಮುಚ್ಚಲಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ಕುರಿಮಂದೆಗಳೆಲ್ಲ ಒಟ್ಟಿಗೆ ಸೇರಿದ ಮೇಲೆ, ಕುರುಬರು ಬಾವಿಯ ಮೇಲಿನ ಕಲ್ಲನ್ನು ಉರುಳಿಸುತ್ತಿದ್ದರು. ಆಮೇಲೆ ಎಲ್ಲಾ ಕುರಿಗಳು ಬಾವಿಯ ನೀರನ್ನು ಕುಡಿಯುತ್ತಿದ್ದವು. ಕುರಿಗಳು ನೀರು ಕುಡಿದಾದ ಮೇಲೆ ಕುರುಬರು ಕಲ್ಲನ್ನು ಮತ್ತೆ ಮುಚ್ಚುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ಯಾಕೋಬನು ಅಲ್ಲಿದ್ದ ಕುರುಬರಿಗೆ, “ಸಹೋದರರೇ, ನೀವು ಎಲ್ಲಿಯವರು?” ಎಂದು ಕೇಳಿದನು. ಅವರು “ನಾವು ಹಾರಾನಿನವರು” ಎಂದು ಉತ್ತರಕೊಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ನಂತರ ಯಾಕೋಬನು ಅವರಿಗೆ, “ನಾಹೋರನ ಮೊಮ್ಮಗನಾದ ಲಾಬಾನನು ನಿಮಗೆ ಗೊತ್ತೆ?” ಎಂದು ಕೇಳಿದನು. ಕುರುಬರು, “ನಮಗೆ ಗೊತ್ತು” ಎಂದು ಉತ್ತರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ಯಾಕೋಬನು, “ಅವನು ಕ್ಷೇಮವಾಗಿರುವನೇ?” ಎಂದು ಕೇಳಿದನು. ಅವರು, “ಅವನು ಕ್ಷೇಮವಾಗಿದ್ದಾನೆ. ಅಗೋ, ಆ ಕುರಿಗಳೊಂದಿಗೆ ಬರುತ್ತಿರುವವಳೇ ಅವನ ಮಗಳಾದ ರಾಹೇಲಳು” ಎಂದು ಉತ್ತರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ಯಾಕೋಬನು, “ನೋಡಿ, ಇನ್ನೂ ಹೊತ್ತಾಗಿಲ್ಲ; ರಾತ್ರಿಗಾಗಿ ಕುರಿಗಳನ್ನು ಒಟ್ಟಿಗೆ ಸೇರಿಸುವ ಸಮಯವಾಗಿಲ್ಲ; ನೀರು ಕುಡಿಸಿ ಅವುಗಳನ್ನು ಮೇಯಿಸಿರಿ” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ಆ ಕುರುಬರು, “ಕುರಿಮಂದೆಗಳೆಲ್ಲ ಒಟ್ಟಿಗೆ ಸೇರುವವರೆಗೆ ನಾವು ಬಾವಿಯ ಮೇಲಿರುವ ಕಲ್ಲನ್ನು ತೆಗೆದು ಕುರಿಗಳಿಗೆ ನೀರು ಕುಡಿಸುವಂತಿಲ್ಲ; ಅವು ಒಟ್ಟಿಗೆ ಕೂಡಿಬಂದಾಗಲೇ ನೀರು ಕುಡಿಸುತ್ತೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ಯಾಕೋಬನು ಕುರುಬರೊಡನೆ ಮಾತಾಡುತ್ತಿರುವಾಗ ರಾಹೇಲಳು ತನ್ನ ತಂದೆಯ ಕುರಿಗಳೊಡನೆ ಬಂದಳು. (ಕುರಿಗಳನ್ನು ನೋಡಿಕೊಳ್ಳುವುದು ರಾಹೇಲಳ ಕೆಲಸವಾಗಿತ್ತು.) ");
INSERT INTO kan2010_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ರಾಹೇಲಳು ಲಾಬಾನನ ಮಗಳು. ಲಾಬಾನನು ಯಾಕೋಬನ ತಾಯಿಯಾದ ರೆಬೆಕ್ಕಳ ಅಣ್ಣ. ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನು ನೋಡಿದಾಗ ಬಾವಿಯ ಮೇಲಿದ್ದ ಕಲ್ಲನ್ನು ತೆಗೆದುಹಾಕಿ ತನ್ನ ತಾಯಿಯ ಅಣ್ಣನಾದ ಲಾಬಾನನ ಕುರಿಗಳಿಗೆ ನೀರು ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ಬಳಿಕ ಯಾಕೋಬನು ರಾಹೇಲಳಿಗೆ ಮುದ್ದಿಟ್ಟು ಅತ್ತನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ಯಾಕೋಬನು ರಾಹೇಲಳಿಗೆ, ತಾನು ಅವಳ ತಂದೆಯ ಕುಟುಂಬದವನೆಂದೂ ರೆಬೆಕ್ಕಳ ಮಗನೆಂದೂ ತಿಳಿಸಿದನು. ಆಗ ರಾಹೇಲಳು ಮನೆಗೆ ಓಡಿಹೋಗಿ ತನ್ನ ತಂದೆಗೆ ಈ ಸುದ್ದಿಯನ್ನು ತಿಳಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ಲಾಬಾನನು ತನ್ನ ತಂಗಿಯ ಮಗನಾದ ಯಾಕೋಬನ ವಿಷಯವನ್ನು ಕೇಳಿ ಭೇಟಿಯಾಗಲು ಓಡಿಬಂದನು. ಲಾಬಾನನು ಅವನನ್ನು ಅಪ್ಪಿಕೊಂಡು ಮುದ್ದಿಟ್ಟು ಮನೆಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ಯಾಕೋಬನು ನಡೆದ ಪ್ರತಿಯೊಂದನ್ನೂ ಲಾಬಾನನಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ನಂತರ ಲಾಬಾನನು, “ಇದು ಆಶ್ಚರ್ಯವಾಗಿದೆ; ನೀನು ನನ್ನ ಸ್ವಂತ ಕುಟುಂಬದವನು” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಯಾಕೋಬನು ಲಾಬಾನನೊಡನೆ ಒಂದು ತಿಂಗಳವರೆಗೆ ಇದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ಒಂದು ದಿನ ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ನೀನು ಸಂಬಳ ತೆಗೆದುಕೊಳ್ಳದೆ ನನ್ನ ಬಳಿಯಲ್ಲಿ ಕೆಲಸ ಮಾಡುವುದು ಸರಿಯಲ್ಲ. ನೀನು ನನ್ನ ಸಂಬಂಧಿಕನೇ ಹೊರತು ಸೇವಕನಲ್ಲ. ನಾನು ನಿನಗೆ ಎಷ್ಟು ಸಂಬಳ ಕೊಡಲಿ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ಲಾಬಾನನಿಗೆ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳಿದ್ದರು. ಹಿರಿಯವಳ ಹೆಸರು ಲೇಯಾ; ಕಿರಿಯವಳ ಹೆಸರು ರಾಹೇಲ್. ");
INSERT INTO kan2010_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ರಾಹೇಲಳು ಸುಂದರವಾಗಿದ್ದಳು. ಲೇಯಳ ಕಣ್ಣುಗಳು ಸೌಮ್ಯವಾಗಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನು ಪ್ರೀತಿಸಿದನು. ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ನಿನ್ನ ಚಿಕ್ಕಮಗಳಾದ ರಾಹೇಲಳನ್ನು ನನಗೆ ಮದುವೆ ಮಾಡಿಕೊಡುವುದಾದರೆ ನಾನು ನಿನಗೆ ಏಳು ವರ್ಷ ಸೇವೆ ಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ಲಾಬಾನನು, “ಬೇರೊಬ್ಬನು ಆಕೆಯನ್ನು ಮದುವೆಯಾಗುವುದಕ್ಕಿಂತ ನೀನು ಮದುವೆಯಾಗುವುದೇ ಆಕೆಗೆ ಒಳ್ಳೆಯದು. ಆದ್ದರಿಂದ ನನ್ನೊಂದಿಗಿರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ಆದ್ದರಿಂದ ಯಾಕೋಬನು ಅವನೊಂದಿಗೆ ಇದ್ದುಕೊಂಡು ಏಳು ವರ್ಷಗಳವರೆಗೆ ಲಾಬಾನನ ಸೇವೆ ಮಾಡಿದನು. ಆದರೆ ಅವನು ರಾಹೇಲಳನ್ನು ತುಂಬಾ ಪ್ರೀತಿಸುತ್ತಿದ್ದುದರಿಂದ ಆ ಸಮಯವು ಅವನಿಗೆ ತುಂಬಾ ಕಡಿಮೆಯಂತೆ ಕಾಣಿಸಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ಏಳು ವರ್ಷಗಳಾದ ಮೇಲೆ ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ನನಗೆ ರಾಹೇಲಳನ್ನು ಮದುವೆ ಮಾಡಿಕೊಡು. ನನ್ನ ಸೇವೆಯ ಕಾಲ ಮುಗಿದುಹೋಯಿತು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ಆದ್ದರಿಂದ ಲಾಬಾನನು ಆ ಸ್ಥಳದಲ್ಲಿದ್ದ ಜನರಿಗೆಲ್ಲ ಒಂದು ಔತಣಕೂಟವನ್ನು ಏರ್ಪಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ಆ ರಾತ್ರಿ ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ಲೇಯಳನ್ನು ಯಾಕೋಬನ ಬಳಿಗೆ ಕಳುಹಿಸಿದನು. ಯಾಕೋಬನು ಆಕೆಯನ್ನು ಕೂಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(ಲಾಬಾನನು ತನ್ನ ಸೇವಕಿಯಾದ ಜಿಲ್ಪಾಳನ್ನು ತನ್ನ ಮಗಳಿಗೆ ಸೇವಕಿಯನ್ನಾಗಿ ಕೊಟ್ಟನು.) ");
INSERT INTO kan2010_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ಮುಂಜಾನೆ ಯಾಕೋಬನು ಎದ್ದು ನೋಡಿದಾಗ ಅವನೊಂದಿಗೆ ಲೇಯಾ ಇದ್ದಳು. ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ನೀನು ನನಗೆ ಮೋಸ ಮಾಡಿದೆ. ನಾನು ರಾಹೇಲಳನ್ನು ಮದುವೆ ಮಾಡಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ತುಂಬಾ ಕಷ್ಟಪಟ್ಟು ಕೆಲಸ ಮಾಡಿದೆ. ನೀನು ನನಗೇಕೆ ಮೋಸ ಮಾಡಿದೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ಲಾಬಾನನು, “ನಮ್ಮ ದೇಶದಲ್ಲಿ ದೊಡ್ಡ ಮಗಳು ಮದುವೆಯಾಗದ ಹೊರತು ಚಿಕ್ಕಮಗಳಿಗೆ ಮದುವೆ ಮಾಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ಆದರೆ ಆಕೆಯ ಮದುವೆಯ ವಾರವನ್ನು ಮುಂದುವರಿಸು. ನಾನು ನಿನಗೆ ರಾಹೇಲಳನ್ನು ಸಹ ಮದುವೆ ಮಾಡಿಕೊಡುತ್ತೇನೆ. ಆದರೆ ನೀನು ನನಗೆ ಇನ್ನೂ ಏಳು ವರ್ಷ ಸೇವೆ ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ಅಂತೆಯೇ ಯಾಕೋಬನು ಒಂದು ವಾರವನ್ನು ಕಳೆದನು. ಬಳಿಕ ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ರಾಹೇಲಳನ್ನೂ ಅವನಿಗೆ ಹೆಂಡತಿಯನ್ನಾಗಿ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(ಲಾಬಾನನು ತನ್ನ ಸೇವಕಿಯಾದ ಬಿಲ್ಹಾಳನ್ನು ತನ್ನ ಮಗಳಾದ ರಾಹೇಲಳಿಗೆ ಸೇವಕಿಯನ್ನಾಗಿ ಕೊಟ್ಟನು.) ");
INSERT INTO kan2010_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನೂ ಕೂಡಿದನು. ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನು ಲೇಯಳಿಗಿಂತ ಹೆಚ್ಚಾಗಿ ಪ್ರೀತಿಸಿ ಆಕೆಗೋಸ್ಕರ ಇನ್ನೂ ಏಳು ವರ್ಷ ಸೇವೆ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ಯಾಕೋಬನು ರಾಹೇಲಳನ್ನು ಲೇಯಳಿಗಿಂತ ಹೆಚ್ಚಾಗಿ ಪ್ರೀತಿಸುವುದನ್ನು ಯೆಹೋವನು ನೋಡಿದನು. ಆದ್ದರಿಂದ ಯೆಹೋವನು ಲೇಯಳಿಗೆ ಮಕ್ಕಳಾಗುವಂತೆ ಮಾಡಿದನು. ಆದರೆ ರಾಹೇಲಳಿಗೆ ಮಕ್ಕಳಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ಲೇಯಳು ಒಬ್ಬ ಮಗನನ್ನು ಹೆತ್ತಳು. ಆಕೆಯು ತನ್ನೊಳಗೆ, “ಯೆಹೋವನು ನನ್ನ ದುಃಖವನ್ನು ನೋಡಿದ್ದಾನೆ. ನನ್ನ ಗಂಡನು ನನ್ನನ್ನು ಪ್ರೀತಿಸುವುದಿಲ್ಲ. ಈಗಲಾದರೊ ಅವನು ನನ್ನನ್ನು ಪ್ರೀತಿಸಬಹುದು” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ರೂಬೇನ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ಲೇಯಾ ಮತ್ತೆ ಬಸುರಾಗಿ ಮತ್ತೊಬ್ಬ ಮಗನನ್ನು ಹೆತ್ತಳು. ಆಕೆ ತನ್ನೊಳಗೆ, “ನಾನು ಗಂಡನ ಅಲಕ್ಷ್ಯಕ್ಕೆ ಗುರಿಯಾದೆನೆಂದು ಯೆಹೋವನು ತಿಳಿದು ನನಗೆ ಈ ಮಗುವನ್ನು ಕೊಟ್ಟಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ಸಿಮೆಯೋನ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ಲೇಯಾ ಮತ್ತೆ ಬಸುರಾಗಿ ಮತ್ತೊಬ್ಬ ಗಂಡುಮಗನನ್ನು ಹೆತ್ತಳು. ಆಕೆ ತನ್ನೊಳಗೆ, “ಖಂಡಿತವಾಗಿಯೂ ನನ್ನ ಗಂಡ ನನ್ನ ಜೊತೆಗೂಡಿರುವನು. ನಾನು ಅವನಿಗೆ ಮೂರು ಗಂಡುಮಕ್ಕಳನ್ನು ಕೊಟ್ಟಿರುವೆ” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ಲೇವಿ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ನಂತರ ಲೇಯಾ ಮತ್ತೊಬ್ಬ ಗಂಡುಮಗನನ್ನು ಹೆತ್ತಳು. ಲೇಯಳು ತನ್ನೊಳಗೆ, “ಈಗ ನಾನು ಯೆಹೋವನನ್ನು ಸ್ತುತಿಸುವೆನು” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ಯೆಹೂದ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ನಂತರ ಲೇಯಳಿಗೆ ಮಕ್ಕಳಾಗುವುದು ನಿಂತುಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ರಾಹೇಲಳು ತನಗೆ ಮಕ್ಕಳಾಗದಿರುವುದನ್ನು ಗಮನಿಸಿದಳು. ರಾಹೇಲಳಿಗೆ ತನ್ನ ಅಕ್ಕನಾದ ಲೇಯಳ ಮೇಲೆ ಹೊಟ್ಟೆಕಿಚ್ಚಾಯಿತು. ಆದ್ದರಿಂದ ರಾಹೇಲಳು ಯಾಕೋಬನಿಗೆ, “ನನಗೆ ಮಕ್ಕಳನ್ನು ಕೊಡು, ಇಲ್ಲವಾದರೆ ನಾನು ಸಾಯುವೆ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ಯಾಕೋಬನಿಗೆ ರಾಹೇಲಳ ಮೇಲೆ ಕೋಪವಾಯಿತು. ಅವನು ಆಕೆಗೆ, “ನಾನು ದೇವರಲ್ಲ. ನಿನಗೆ ಮಕ್ಕಳಾಗದಂತೆ ಮಾಡಿರುವವನು ದೇವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ನಂತರ ರಾಹೇಲಳು, “ನೀನು ನನ್ನ ಸೇವಕಿಯಾದ ಬಿಲ್ಹಾಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಹುದು. ಆಕೆಯೊಡನೆ ಮಲಗಿಕೊ; ಆಕೆ ನನಗೋಸ್ಕರ ಒಂದು ಮಗುವನ್ನು ಹೆರುವಳು. ಆಗ ನಾನು ಆಕೆಯ ಮೂಲಕ ತಾಯಿಯಾಗುವೆನು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ಅಂತೆಯೇ ರಾಹೇಲಳು ಬಿಲ್ಹಾಳನ್ನು ತನ್ನ ಗಂಡನಾದ ಯಾಕೋಬನಿಗೆ ಕೊಟ್ಟಳು. ಯಾಕೋಬನು ಬಿಲ್ಹಾಳನ್ನು ಕೂಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ಬಿಲ್ಹಾ ಬಸುರಾಗಿ ಯಾಕೋಬನಿಗೆ ಒಬ್ಬ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ರಾಹೇಲಳು, “ದೇವರು ನನ್ನ ಪ್ರಾರ್ಥನೆಯನ್ನು ಕೇಳಿ ನನಗೆ ಒಬ್ಬ ಮಗನನ್ನು ಕೊಡಲು ನಿರ್ಧರಿಸಿದನು” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ದಾನ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ಬಿಲ್ಹಾ ಮತ್ತೆ ಬಸುರಾಗಿ ಯಾಕೋಬನಿಗೆ ಎರಡನೆ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ರಾಹೇಲಳು, “ನನ್ನ ಅಕ್ಕನೊಂದಿಗೆ ಕಷ್ಟಪಟ್ಟು ಹೋರಾಡಿ ಗೆದ್ದಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ನಫ್ತಾಲಿ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ಲೇಯಳು ತನಗೆ ಮಕ್ಕಳಾಗದಿರುವುದನ್ನು ಗಮನಿಸಿ ತನ್ನ ಸೇವಕಿಯಾದ ಜಿಲ್ಪಳನ್ನು ಯಾಕೋಬನಿಗೆ ಕೊಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ಜಿಲ್ಪಳಿಗೂ ಒಬ್ಬ ಮಗನು ಹುಟ್ಟಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ಲೇಯಳು, “ನಾನು ಅದೃಷ್ಟವಂತೆ” ಎಂದು ಹೇಳಿ, ಆ ಮಗುವಿಗೆ ಗಾದ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ಜಿಲ್ಪಳು ಮತ್ತೊಬ್ಬ ಮಗನನ್ನು ಹೆತ್ತಳು. ಲೇಯಳು, “ನಾನು ಧನ್ಯಳಾದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ಈಗ ಸ್ತ್ರೀಯರು ನನ್ನನ್ನು ಧನ್ಯಳೆಂದು ಕರೆಯುವರು” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ಆಶೇರ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ಗೋಧಿಯ ಸುಗ್ಗಿಕಾಲದಲ್ಲಿ, ರೂಬೇನನು ಹೊಲಕ್ಕೆ ಹೋಗಿದ್ದಾಗ ಕಾಮಜನಕಗಿಡದ ಹೂವುಗಳನ್ನು ಕಂಡನು. ರೂಬೇನನು ಈ ಹೂವುಗಳನ್ನು ತನ್ನ ತಾಯಿಯಾದ ಲೇಯಳಿಗೆ ತಂದುಕೊಟ್ಟನು. ರಾಹೇಲಳು ಲೇಯಳಿಗೆ, “ದಯವಿಟ್ಟು, ನಿನ್ನ ಮಗನು ತಂದಿರುವ ಹೂವುಗಳಲ್ಲಿ ನನಗೆ ಸ್ವಲ್ಪಕೊಡು” ಎಂದು ಕೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ಲೇಯಳು, “ನೀನು ಈಗಾಗಲೇ ನನ್ನ ಗಂಡನನ್ನು ತೆಗೆದುಕೊಂಡಿರುವೆ. ಈಗ ನನ್ನ ಮಗನು ತಂದಿರುವ ಹೂವುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಲು ಪ್ರಯತ್ನಿಸುತ್ತಿರುವೆ” ಎಂದು ಹೇಳಿದಳು. ರಾಹೇಲಳು, “ನಿನ್ನ ಮಗನು ತಂದಿರುವ ಹೂವುಗಳನ್ನು ನನಗೆ ಕೊಟ್ಟರೆ, ನೀನು ಈ ರಾತ್ರಿ ಯಾಕೋಬನ ಸಂಗಡ ಮಲಗಿಕೊಳ್ಳಬಹುದು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ಆ ರಾತ್ರಿ ಯಾಕೋಬನು ಹೊಲದಿಂದ ಬಂದನು. ಲೇಯಳು ಅವನನ್ನು ಕಂಡು ಭೇಟಿಯಾಗಲು ಹೋದಳು. ಅವಳು ಅವನಿಗೆ, “ಈ ರಾತ್ರಿ ನೀನು ನನ್ನ ಸಂಗಡ ಮಲಗಿಕೊಳ್ಳುವೆ. ನನ್ನ ಮಗನು ತಂದ ಹೂವುಗಳನ್ನು ನಾನು ನಿನಗೋಸ್ಕರವಾಗಿ ಕೊಟ್ಟಿರುವೆ” ಎಂದು ಹೇಳಿದಳು. ಆದ್ದರಿಂದ ಯಾಕೋಬನು ಆ ರಾತ್ರಿ ಲೇಯಳೊಡನೆ ಮಲಗಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ಲೇಯಳು ಮತ್ತೆ ಬಸುರಾಗುವಂತೆ ದೇವರು ಅನುಗ್ರಹಿಸಿದನು. ಆಕೆ ತನ್ನ ಐದನೆಯ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ಲೇಯಳು, “ದೇವರು ನನಗೆ ಒಂದು ಬಹುಮಾನವನ್ನು ಕೊಟ್ಟನು; ಯಾಕೆಂದರೆ ನಾನು ನನ್ನ ಸೇವಕಿಯನ್ನು ನನ್ನ ಗಂಡನಿಗೆ ಕೊಟ್ಟೆನು” ಎಂದು ಹೇಳಿ, ಆ ಮಗುವಿಗೆ ಇಸ್ಸಾಕಾರ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ಲೇಯಳು ಮತ್ತೆ ಬಸುರಾಗಿ ಆರನೆಯ ಮಗನನ್ನು ಹೆತ್ತಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ಲೇಯಳು, “ದೇವರು ನನಗೆ ಒಂದು ಒಳ್ಳೆಯ ಬಹುಮಾನವನ್ನು ಕೊಟ್ಟಿದ್ದಾನೆ. ಈಗ ಖಂಡಿತವಾಗಿ ಯಾಕೋಬನು ನನ್ನನ್ನು ಸ್ವೀಕರಿಸುವನು, ಯಾಕೆಂದರೆ ನಾನು ಅವನಿಗೆ ಆರು ಗಂಡುಮಕ್ಕಳನ್ನು ಕೊಟ್ಟಿರುವೆ” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ, ಜೆಬುಲೂನ್ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ತರುವಾಯ ಲೇಯಳು ಒಬ್ಬ ಮಗಳನ್ನು ಹೆತ್ತಳು. ಆಕೆ ತನ್ನ ಮಗಳಿಗೆ ದೀನಾ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ನಂತರ, ದೇವರು ರಾಹೇಲಳ ಪ್ರಾರ್ಥನೆಯನ್ನು ಕೇಳಿ ಆಕೆಗೆ ಮಕ್ಕಳಾಗುವಂತೆ ಅನುಗ್ರಹಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","ರಾಹೇಲಳು ಬಸುರಾಗಿ ಒಬ್ಬ ಮಗನನ್ನು ಹೆತ್ತಳು. ರಾಹೇಲಳು, “ದೇವರು ನನಗಿದ್ದ ಅವಮಾನವನ್ನು ತೆಗೆದುಹಾಕಿದ್ದಾನೆ; ನನಗೆ ಒಬ್ಬ ಮಗನನ್ನು ಕೊಟ್ಟಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿ ಆ ಮಗುವಿಗೆ ಯೋಸೇಫ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ಯೋಸೇಫನು ಹುಟ್ಟಿದ ಮೇಲೆ, ಯಾಕೋಬನು ಲಾಬಾನನಿಗೆ, “ಈಗ ನಾನು ನನ್ನ ಸ್ವಂತ ಮನೆಗೆ ಹೋಗಲು ಅನುಮತಿ ಕೊಡು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ನನ್ನ ಹೆಂಡತಿಯರನ್ನೂ ಮಕ್ಕಳನ್ನೂ ನನಗೆ ಕೊಡು. ನಾನು ಹದಿನಾಲ್ಕು ವರ್ಷ ನಿನ್ನ ಸೇವೆಮಾಡಿ ಅವರನ್ನು ಸಂಪಾದಿಸಿಕೊಂಡಿದ್ದೇನೆ. ನಾನು ನಿನಗೆ ಒಳ್ಳೆಯ ಸೇವೆ ಮಾಡಿರುವುದು ನಿನಗೆ ತಿಳಿದಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ಲಾಬಾನನು ಅವನಿಗೆ, “ನಾನು ಹೇಳುವುದನ್ನು ಕೇಳು; ಯೆಹೋವನು ನಿನ್ನ ನಿಮಿತ್ತವಾಗಿ ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದಾನೆಂದು ನನಗೆ ತಿಳಿದಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ಹೇಳು, ನಾನು ನಿನಗೆ ಎಷ್ಟು ಸಂಬಳ ಕೊಡಬೇಕು? ನೀನು ಹೇಳಿದಷ್ಟು ಕೊಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ಯಾಕೋಬನು, “ನಾನು ನಿನಗೋಸ್ಕರ ಕಷ್ಟಪಟ್ಟು ಕೆಲಸ ಮಾಡಿರುವುದು ನಿನಗೆ ಗೊತ್ತಿದೆ. ನಾನು ನಿನ್ನ ಕುರಿಮಂದೆಗಳನ್ನು ನೋಡಿಕೊಂಡಿದ್ದರಿಂದ ಅವು ಹೆಚ್ಚಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ನಾನು ಬಂದಾಗ ನಿನಗೆ ಸ್ವಲ್ಪವಿತ್ತು, ಈಗ ನಿನಗೆ ಬೇಕಾದಷ್ಟಿದೆ. ನಾನು ನಿನಗೋಸ್ಕರ ಮಾಡಿದ್ದನ್ನೆಲ್ಲ ಯೆಹೋವನು ಆಶೀರ್ವದಿಸಿದನು. ನಾನು ನನಗೋಸ್ಕರ ಕೆಲಸ ಮಾಡುವ ಸಮಯವಿದು. ನನ್ನ ಸ್ವಂತ ಮನೆಗೆ ಒದಗಿಸುವ ಸಮಯವಿದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ಲಾಬಾನನು “ಹಾಗಾದರೆ ನಾನು ನಿನಗೇನು ಕೊಡಬೇಕು” ಎಂದು ಕೇಳಿದನು. ಯಾಕೋಬನು, “ನೀನು ನನಗೆ ಏನೂ ಕೊಡಬೇಕಾಗಿಲ್ಲ. (ನಾನು ಕೆಲಸ ಮಾಡಿದ್ದಕ್ಕೆ ನೀನು ಸಂಬಳ ಕೊಟ್ಟರೆ ಸಾಕು.) ಇದೊಂದು ಕಾರ್ಯವನ್ನು ಮಾಡು; ನಾನು ಹೋಗಿ ನಿನ್ನ ಕುರಿಗಳನ್ನು ನೋಡಿಕೊಳ್ಳುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ನಾನು ನಿನ್ನ ಕುರಿಮಂದೆಯೊಳಗೆ ಹೋಗಿ, ಚುಕ್ಕೆಮಚ್ಚೆಗಳಿರುವ ಪ್ರತಿಯೊಂದು ಕುರಿಯನ್ನೂ ಪ್ರತಿಯೊಂದು ಕಪ್ಪು ಕುರಿಯನ್ನೂ ಚುಕ್ಕೆಮಚ್ಚೆಗಳಿರುವ ಪ್ರತಿಯೊಂದು ಮೇಕೆಯನ್ನೂ ತೆಗೆದುಕೊಳ್ಳುವೆನು. ಅದೇ ನನಗೆ ಸಂಬಳ. ");
INSERT INTO kan2010_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ಮುಂದಿನ ದಿನಗಳಲ್ಲಿ ನೀನು ಬಂದು ಪರೀಕ್ಷಿಸಿದಾಗ ನಾನು ಯಥಾರ್ಥನೊ ಇಲ್ಲವೊ ಎಂಬುದನ್ನು ನೀನು ಸುಲಭವಾಗಿ ಕಂಡುಕೊಳ್ಳಬಹುದು. ನಾನೇನಾದರೂ ಚುಕ್ಕೆಯಿಲ್ಲದ ಮೇಕೆಗಳನ್ನಾಗಲಿ ಅಥವಾ ಕಪ್ಪಿಲ್ಲದ ಕುರಿಗಳನ್ನಾಗಲಿ ಹೊಂದಿದ್ದರೆ, ನಾನು ಅದನ್ನು ಕದ್ದುಕೊಂಡದ್ದೆಂದು ನೀನು ಪರಿಗಣಿಸಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ಲಾಬಾನನು, “ನಾನು ಅದಕ್ಕೆ ಒಪ್ಪಿಕೊಂಡಿದ್ದೇನೆ. ನೀನು ಹೇಳಿದಂತೆ ನಾವು ಮಾಡೋಣ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ಆ ದಿನ ಲಾಬಾನನು ಚುಕ್ಕೆಗಳಿದ್ದ ಎಲ್ಲಾ ಹೋತಗಳನ್ನೂ ಮೇಕೆಗಳನ್ನೂ ಕಪ್ಪಾದ ಕುರಿಗಳನ್ನೂ ಪ್ರತ್ಯೇಕಿಸಿದನು. ಲಾಬಾನನು ತನ್ನ ಗಂಡುಮಕ್ಕಳಿಗೆ ಆ ಕುರಿಗಳನ್ನು ನೋಡಿಕೊಳ್ಳಲು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ಆದ್ದರಿಂದ ಅವನ ಗಂಡುಮಕ್ಕಳು ಚುಕ್ಕೆಗಳಿದ್ದ ಅವುಗಳೊಂದಿಗೆ ಮತ್ತೊಂದು ಸ್ಥಳಕ್ಕೆ ಹೋದರು. ಅವರು ಮೂರು ದಿನಗಳವರೆಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಯಾಕೋಬನು ಅಲ್ಲಿದ್ದುಕೊಂಡು ಉಳಿದವುಗಳನ್ನೆಲ್ಲ ನೋಡಿಕೊಳ್ಳತೊಡಗಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ಆದ್ದರಿಂದ ಯಾಕೋಬನು ಲಿಬ್ನೆ, ಲೂಜ್ ಮತ್ತು ಅರ್ಮೋನ್ ಎಂಬ ಮರಗಳಿಂದ ಹಸಿರುಕೊಂಬೆಗಳನ್ನು ಕತ್ತರಿಸಿದನು. ಅವುಗಳನ್ನು ಪಟ್ಟಿಪಟ್ಟಿಯಾಗಿ ತೊಗಟೆ ಸುಲಿದು ಅವುಗಳಲ್ಲಿರುವ ಬಿಳುಪುಬಣ್ಣವು ಕಾಣಿಸುವಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ಯಾಕೋಬನು ಆ ಕೊಂಬೆಗಳನ್ನು ಮಂದೆಗಳ ಎದುರಿಗೆ ನೀರು ಕುಡಿಯುವ ಸ್ಥಳದಲ್ಲಿಟ್ಟನು. ಪ್ರಾಣಿಗಳು ನೀರು ಕುಡಿಯುವುದಕ್ಕೆ ಬಂದಾಗ ಆ ಸ್ಥಳದಲ್ಲಿ ಸಂಗಮ ಮಾಡುತ್ತಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ಮೇಕೆಗಳು ಆ ಕೊಂಬೆಗಳ ಎದುರಿನಲ್ಲಿ ಸಂಗಮ ಮಾಡಿದಾಗ, ಅವುಗಳಲ್ಲಿ ಹುಟ್ಟಿದ ಮರಿಗಳೆಲ್ಲ ಚುಕ್ಕೆಮಚ್ಚೆಗಳಿಂದಲೂ ಕಪ್ಪು ಬಣ್ಣದಿಂದಲೂ ಕೂಡಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ಯಾಕೋಬನು ಚುಕ್ಕೆಯುಳ್ಳ ಮತ್ತು ಕಪ್ಪಾಗಿರುವ ಆಡುಕುರಿಗಳನ್ನು ಮಂದೆಯ ಇತರ ಆಡುಕುರಿಗಳಿಂದ ಬೇರ್ಪಡಿಸಿದನು. ಯಾಕೋಬನು ತನ್ನ ಪಶುಗಳನ್ನು ಲಾಬಾನನ ಪಶುಗಳಿಂದ ಪ್ರತ್ಯೇಕವಾಗಿರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ಬಲವಾದ ಆಡುಕುರಿಗಳು ಸಂಗಮ ಮಾಡುವಾಗಲೆಲ್ಲ ಯಾಕೋಬನು ಆ ಕೊಂಬೆಗಳನ್ನು ಅವುಗಳ ಕಣ್ಣಿಗೆ ಎದುರಾಗಿಡುತ್ತಿದ್ದನು. ಅವುಗಳು ಆ ಕೊಂಬೆಗಳ ಸಮೀಪದಲ್ಲಿ ಸಂಗಮ ಮಾಡುತ್ತಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ಆದರೆ ಬಲಹೀನವಾದ ಪ್ರಾಣಿಗಳು ಸಂಗಮ ಮಾಡುವಾಗ ಯಾಕೋಬನು ಆ ಕೊಂಬೆಗಳನ್ನು ಅಲ್ಲಿ ಇಡುತ್ತಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಬಲಹೀನವಾದ ಆಡುಕುರಿಗಳಿಗೆ ಹುಟ್ಟಿದ ಮರಿಗಳೆಲ್ಲ ಲಾಬಾನನಿಗೆ ಸೇರಿಕೊಂಡವು. ಬಲವಾದ ಆಡುಕುರಿಗಳಿಗೆ ಹುಟ್ಟಿದ ಮರಿಗಳೆಲ್ಲ ಯಾಕೋಬನಿಗೆ ಸೇರಿಕೊಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ಹೀಗೆ ಯಾಕೋಬನು ತುಂಬ ಐಶ್ವರ್ಯವಂತನಾದನು. ಅವನಿಗೆ ದೊಡ್ಡ ಮಂದೆಗಳಿದ್ದವು. ಅನೇಕ ಸೇವಕರಿದ್ದರು; ಒಂಟೆಗಳಿದ್ದವು ಮತ್ತು ಕತ್ತೆಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ಒಂದು ದಿನ ಲಾಬಾನನ ಗಂಡುಮಕ್ಕಳು ಮಾತಾಡುತ್ತಿರುವುದನ್ನು ಯಾಕೋಬನು ಕೇಳಿಸಿಕೊಂಡನು. ಅವರು, “ನಮ್ಮ ತಂದೆ ಹೊಂದಿದ್ದ ಪ್ರತಿಯೊಂದನ್ನೂ ಯಾಕೋಬನು ತೆಗೆದುಕೊಂಡು ಐಶ್ವರ್ಯವಂತನಾಗಿದ್ದಾನೆ; ಅವನು ನಮ್ಮ ತಂದೆಯ ಐಶ್ವರ್ಯವನ್ನೆಲ್ಲ ತೆಗೆದುಕೊಂಡಿದ್ದಾನೆ” ಎಂದು ಹೇಳುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ಲಾಬಾನನು ಮೊದಲಿನಂತೆ ಸ್ನೇಹದಿಂದ ಇಲ್ಲದಿರುವುದನ್ನು ಸಹ ಯಾಕೋಬನು ಗಮನಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ಯೆಹೋವನು ಯಾಕೋಬನಿಗೆ, “ನಿನ್ನ ಪೂರ್ವಿಕರು ವಾಸಿಸಿದ ನಿನ್ನ ಸ್ವಂತ ಸ್ಥಳಕ್ಕೆ ಹಿಂತಿರುಗಿ ಹೋಗು. ನಾನು ನಿನ್ನ ಸಂಗಡವಿರುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ಆದ್ದರಿಂದ ಯಾಕೋಬನು ರಾಹೇಲಳಿಗೆ ಮತ್ತು ಲೇಯಳಿಗೆ ತನ್ನ ಆಡುಕುರಿಗಳು ಮೇಯುತ್ತಿರುವ ಹೊಲದಲ್ಲಿ ತನ್ನನ್ನು ಭೇಟಿಯಾಗಬೇಕೆಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ಯಾಕೋಬನು, ರಾಹೇಲಳಿಗೆ ಮತ್ತು ಲೇಯಾಳಿಗೆ, “ನಿಮ್ಮ ತಂದೆ ನನ್ನ ಮೇಲೆ ಕೋಪದಿಂದಿರುವುದನ್ನು ನಾನು ಗಮನಿಸಿದ್ದೇನೆ. ಮೊದಲು ಅವನು ನನ್ನೊಂದಿಗೆ ಸ್ನೇಹದಿಂದಿದ್ದನು. ಆದರೆ ಈಗ ಅವನು ಸ್ನೇಹದಿಂದಿಲ್ಲ. ಆದರೆ ನನ್ನ ತಂದೆಯ ದೇವರು ನನ್ನೊಂದಿಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ನಿಮ್ಮಿಬ್ಬರಿಗೂ ತಿಳಿದಿರುವಂತೆ, ನಾನು ನಿಮ್ಮ ತಂದೆಗಾಗಿ ನನ್ನಿಂದಾದಷ್ಟು ಕಷ್ಟಪಟ್ಟು ದುಡಿದಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ಆದರೆ ನಿಮ್ಮ ತಂದೆ ನನಗೆ ಮೋಸ ಮಾಡಿದನು. ನಿಮ್ಮ ತಂದೆ ನನ್ನ ಸಂಬಳವನ್ನು ಹತ್ತು ಸಲ ಬದಲಾಯಿಸಿದನು. ಆದರೆ ಆ ಸಮಯದಲ್ಲೆಲ್ಲ ದೇವರು ನನ್ನನ್ನು ಲಾಬಾನನ ಎಲ್ಲಾ ಮೋಸಗಳಿಂದ ಕಾಪಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","“ಒಂದು ಸಲ ಲಾಬಾನನು, ‘ಚುಕ್ಕೆಯಿರುವ ಆಡುಕುರಿಗಳನ್ನೆಲ್ಲ ನೀನು ಇಟ್ಟುಕೊಳ್ಳಬಹುದು. ಇದೇ ನಿನಗೆ ಸಂಬಳ’ ಎಂದು ಹೇಳಿದನು. ಅವನು ಹೀಗೆ ಹೇಳಿದ ಮೇಲೆ ಎಲ್ಲಾ ಆಡುಕುರಿಗಳು ಚುಕ್ಕೆಯಿರುವ ಮರಿಗಳನ್ನು ಈಯ್ದವು. ಆದ್ದರಿಂದ ಅವೆಲ್ಲ ನನ್ನದಾದವು. ಆಗ ಲಾಬಾನನು, ‘ನಾನು ಚುಕ್ಕೆಯಿರುವ ಆಡುಕುರಿಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳುವೆ. ನೀನು ಮಚ್ಚೆಯಿರುವ ಆಡುಕುರಿಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಹುದು. ಅದೇ ನಿನಗೆ ಸಂಬಳ’ ಎಂದು ಹೇಳಿದನು. ಅವನು ಹೀಗೆ ಹೇಳಿದ ಮೇಲೆ, ಎಲ್ಲಾ ಆಡುಕುರಿಗಳು ಮಚ್ಚೆಯಿರುವ ಮರಿಗಳನ್ನು ಈಯ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ಹೀಗೆ ದೇವರು ನಿಮ್ಮ ತಂದೆಯಿಂದ ಆಡುಕುರಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ನನಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“ಪ್ರಾಣಿಗಳು ಸಂಗಮಿಸುವಾಗ ನನಗೆ ಒಂದು ಕನಸಾಯಿತು. ಸಂಗಮಿಸುತ್ತಿದ್ದ ಹೋತಗಳೆಲ್ಲ ಚುಕ್ಕೆಗಳನ್ನು ಮತ್ತು ಮಚ್ಚೆಗಳನ್ನು ಹೊಂದಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ದೇವದೂತನು ಕನಸಿನಲ್ಲಿ ನನ್ನ ಚೊತೆ ಮಾತಾಡಿ ‘ಯಾಕೋಬನೇ’ ಎಂದು ಕರೆದನು. “ನಾನು ‘ಇಗೋ ಇದ್ದೇನೆ’ ಎಂದು ಉತ್ತರಿಸಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“ದೇವದೂತನು ನನಗೆ, ‘ನೋಡು ಚುಕ್ಕೆಮಚ್ಚೆಗಳಿರುವ ಆಡುಕುರಿಗಳು ಮಾತ್ರ ಸಂಗಮಿಸುತ್ತವೆ. ಹೀಗಾಗುವಂತೆ ನಾನೇ ಮಾಡಿರುವೆನು. ನಿನಗೆ ಲಾಬಾನನು ಮಾಡುತ್ತಿರುವ ಅನ್ಯಾಯಗಳನ್ನೆಲ್ಲ ನಾನು ನೋಡಿರುವೆನು. ಆದ್ದರಿಂದ ಹುಟ್ಟುವ ಮರಿಗಳೆಲ್ಲ ನಿನ್ನದಾಗುವಂತೆ ನಾನೇ ಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ಬೇತೇಲಿನಲ್ಲಿ ನಿನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದ ದೇವರು ನಾನೇ. ಆ ಸ್ಥಳದಲ್ಲಿ ನೀನು ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿದೆ. ನೀನು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಆಲಿವ್ ಎಣ್ಣೆಯನ್ನು ಸುರಿದು ನನಗೆ ಒಂದು ಪ್ರಮಾಣವನ್ನು ಮಾಡಿದೆ. ಈಗ ನೀನು ನಿನ್ನ ಹುಟ್ಟುಸ್ಥಳಕ್ಕೆ ಹಿಂತಿರುಗಿ ಹೋಗಬೇಕೆಂಬುದು ನನ್ನ ಅಪೇಕ್ಷೆ’ ಎಂದು ತಿಳಿಸಿದನು” ಎಂಬುದಾಗಿ ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ರಾಹೇಲಳು ಮತ್ತು ಲೇಯಳು ಯಾಕೋಬನಿಗೆ, “ನಮ್ಮ ತಂದೆ ಸಾಯುವಾಗ ನಮಗೆ ಕೊಡಲು ಅವನಲ್ಲಿ ಏನೂ ಇಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ಅವನು ನಮ್ಮನ್ನು ಅನ್ಯರಂತೆ ಕಂಡನು; ಅವನು ನಮ್ಮನ್ನು ನಿನಗೆ ಮಾರಿದ್ದಾನೆ; ನಮ್ಮ ಐಶ್ವರ್ಯವನ್ನೆಲ್ಲ ಅವನು ಉಪಯೋಗಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ದೇವರು ಈ ಐಶ್ವರ್ಯವನ್ನೆಲ್ಲ ನಮ್ಮ ತಂದೆಯಿಂದ ತೆಗೆದುಕೊಂಡಿದ್ದಾನೆ. ಈಗ ಅದು ನಮಗೂ ನಮ್ಮ ಮಕ್ಕಳಿಗೂ ಸೇರಿದೆ. ಆದ್ದರಿಂದ ದೇವರು ನಿನಗೆ ಹೇಳಿದಂತೆಯೇ ಮಾಡು” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ಆದ್ದರಿಂದ ಯಾಕೋಬನು ತನ್ನ ಪ್ರಯಾಣಕ್ಕಾಗಿ ಸಿದ್ಧತೆ ಮಾಡಿದನು. ಅವನು ತನ್ನ ಗಂಡುಮಕ್ಕಳನ್ನು ಮತ್ತು ಹೆಂಡತಿಯರನ್ನು ಒಂಟೆಗಳ ಮೇಲೆ ಕುಳ್ಳಿರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ನಂತರ ಅವರೆಲ್ಲರೂ, ಯಾಕೋಬನ ತಂದೆ ವಾಸಿಸಿದ ಸ್ಥಳವಾದ ಕಾನಾನಿಗೆ ಮರಳಿ ಪ್ರಯಾಣ ಬೆಳೆಸಿದರು. ಯಾಕೋಬನು ಹೊಂದಿದ್ದ ಎಲ್ಲಾ ಆಡುಕುರಿಗಳ ಮಂದೆಗಳು ಅವರ ಮುಂದೆ ನಡೆದವು. ಅವನು ಪದ್ದನ್‌ಅರಾಮಿನಲ್ಲಿದ್ದಾಗ ಹೊಂದಿಕೊಂಡಿದ್ದ ಪ್ರತಿಯೊಂದನ್ನೂ ಅವರು ತೆಗೆದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ಆ ಸಮಯದಲ್ಲಿ ಲಾಬಾನನು ತನ್ನ ಕುರಿಗಳ ಉಣ್ಣೆಯನ್ನು ಕತ್ತರಿಸಲು ಹೋಗಿದ್ದನು. ಅವನು ಇಲ್ಲದಿದ್ದಾಗ, ರಾಹೇಲಳು ಅವನ ಮನೆಯೊಳಗೆ ಹೋಗಿ, ತನ್ನ ತಂದೆಯ ವಿಗ್ರಹಗಳನ್ನು ಕದ್ದುಕೊಂಡಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ಅರಾಮ್ಯನಾದ ಲಾಬಾನನಿಗೆ ಯಾಕೋಬನು ಮೋಸ ಮಾಡಿದನು. ತಾನು ಹೋಗುತ್ತಿರುವುದಾಗಿ ಯಾಕೋಬನು ಅವನಿಗೆ ತಿಳಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ಯಾಕೋಬನು ತನ್ನ ಕುಟುಂಬವನ್ನು ಕರೆದುಕೊಂಡು, ತನ್ನ ಪ್ರತಿಯೊಂದು ಸ್ವತ್ತನ್ನು ತೆಗೆದುಕೊಂಡು ಬೇಗನೆ ಅಲ್ಲಿಂದ ಹೊರಟನು. ಅವರು ಯೂಫ್ರೇಟೀಸ್ ಮಹಾನದಿಯನ್ನು ದಾಟಿ, ಬೆಟ್ಟಗಳ ಸೀಮೆಯಿಂದ ಗಿಲ್ಯಾದ್ ದೇಶದ ಕಡೆಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ಯಾಕೋಬನು ಓಡಿಹೋದದ್ದು ಮೂರು ದಿನಗಳಾದ ಮೇಲೆ ಲಾಬಾನನಿಗೆ ತಿಳಿಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ಆದ್ದರಿಂದ ಲಾಬಾನನು ತನ್ನ ಜನರನ್ನು ಕರೆದುಕೊಂಡು ಯಾಕೋಬನನ್ನು ಬೆನ್ನಟ್ಟಿದನು. ಏಳು ದಿನಗಳಾದ ಮೇಲೆ ಲಾಬಾನನು ಯಾಕೋಬನನ್ನು ಬೆಟ್ಟದ ಸೀಮೆಯಾದ ಗಿಲ್ಯಾದಿನಲ್ಲಿ ಕಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ಆ ರಾತ್ರಿ ದೇವರು ಲಾಬಾನನಿಗೆ ಕನಸಿನಲ್ಲಿ ಕಾಣಿಸಿಕೊಂಡು, “ಎಚ್ಚರಿಕೆಯಾಗಿರು; ನೀನು ಯಾಕೋಬನಿಗೆ ಹೇಳುವ ಪ್ರತಿಯೊಂದು ಮಾತಿನ ಬಗ್ಗೆ ಎಚ್ಚರಿಕೆಯಾಗಿರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ಮರುದಿನ ಮುಂಜಾನೆ ಲಾಬಾನನು ಯಾಕೋಬನನ್ನು ಸಂಧಿಸಿದನು. ಯಾಕೋಬನು ಬೆಟ್ಟದ ಮೇಲೆ ಪಾಳೆಯ ಮಾಡಿಕೊಂಡಿದ್ದನು. ಆದ್ದರಿಂದ ಲಾಬಾನನು ಮತ್ತು ಅವನ ಜನರೆಲ್ಲರು ಬೆಟ್ಟದ ಸೀಮೆಯಾದ ಗಿಲ್ಯಾದಿನಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ನೀನು ನನಗೇಕೆ ಮೋಸ ಮಾಡಿದೆ? ಯುದ್ಧದಲ್ಲಿ ಸೆರೆ ಒಯ್ಯುವ ಸ್ತ್ರೀಯರಂತೆ, ನೀನು ನನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ಬಂದದ್ದೇಕೆ? ");
INSERT INTO kan2010_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ನೀನು ನನಗೆ ಹೇಳದೆ ಓಡಿಬಂದದ್ದೇಕೆ? ನೀನು ನನ್ನನ್ನು ಕೇಳಿದ್ದರೆ ನಾನು ನಿನಗಾಗಿ ಒಂದು ಔತಣಕೂಟವನ್ನೇರ್ಪಡಿಸುತ್ತಿದ್ದೆ. ಅಲ್ಲಿ ಗಾಯನ, ನೃತ್ಯ ಮತ್ತು ವಾದ್ಯಗೋಷ್ಠಿಗಳಿರುತ್ತಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ನಾನು ನನ್ನ ಮೊಮ್ಮಕ್ಕಳಿಗೆ ಮುದ್ದಿಡುವುದಕ್ಕೂ ನನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಬೀಳ್ಕೊಡುವುದಕ್ಕೂ ನೀನು ನನಗೆ ಅವಕಾಶ ಕೊಡಲಿಲ್ಲ. ನಿನ್ನ ಮೂಢತನದಿಂದ ಹೀಗೆ ಮಾಡಿರುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ನಿನಗೆ ಕೇಡುಮಾಡಲು ನನಗೆ ಶಕ್ತಿಯಿದೆ. ಆದರೆ ಕಳೆದ ರಾತ್ರಿ ನಿನ್ನ ತಂದೆಯ ದೇವರು ಕನಸಿನಲ್ಲಿ ನನಗೆ ಕಾಣಿಸಿಕೊಂಡು, ನಿನಗೆ ಕೇಡುಮಾಡಕೂಡದೆಂದು ನನಗೆ ಎಚ್ಚರಿಕೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ನೀನು ನಿನ್ನ ಮನೆಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಬೇಕೆಂಬುದು ನಿನ್ನ ಅಪೇಕ್ಷೆ ಎಂದು ನನಗೆ ತಿಳಿದಿದೆ. ಆದ್ದರಿಂದಲೇ ನೀನು ಹೊರಟು ಬಂದೆ. ಆದರೆ ನೀನು ನನ್ನ ಮನೆಯಿಂದ ವಿಗ್ರಹಗಳನ್ನು ಕದ್ದುಕೊಂಡು ಬಂದದ್ದೇಕೆ?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ಯಾಕೋಬನು, “ನಾನು ನಿನಗೆ ಹೇಳದೆ ಹೊರಟು ಬಂದೆ. ಯಾಕೆಂದರೆ ನನಗೆ ಭಯವಾಗಿತ್ತು; ನೀನು ನಿನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ನನ್ನಿಂದ ತೆಗೆದುಕೊಳ್ಳಬಹುದೆಂದು ನಾನು ಭಾವಿಸಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ಆದರೆ ನಾನು ನಿನ್ನ ವಿಗ್ರಹಗಳನ್ನು ಕದ್ದುಕೊಳ್ಳಲಿಲ್ಲ. ನಿನ್ನ ವಿಗ್ರಹಗಳನ್ನು ತೆಗೆದುಕೊಂಡಿರುವ ಯಾವ ವ್ಯಕ್ತಿಯನ್ನಾದರೂ ಇಲ್ಲಿ ಕಂಡರೆ ಆ ವ್ಯಕ್ತಿಯನ್ನು ಕೊಲ್ಲಲಾಗುವುದು. ನಿನ್ನ ಜನರೇ ನನಗೆ ಸಾಕ್ಷಿಗಳು. ನಿನಗೆ ಸೇರಿದ ಏನಾದರೂ ಇದೆಯೋ ಎಂದು ನೀನೇ ನೋಡಬಹುದು. ನಿನಗೆ ಸೇರಿದ ಯಾವುದಾದರೂ ಇದ್ದರೆ ತೆಗೆದುಕೊ” ಎಂದು ಹೇಳಿದನು. (ಲಾಬಾನನ ವಿಗ್ರಹಗಳನ್ನು ರಾಹೇಲಳು ಕದ್ದುಕೊಂಡಿರುವುದು ಯಾಕೋಬನಿಗೆ ತಿಳಿದಿರಲಿಲ್ಲ.) ");
INSERT INTO kan2010_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ಆದ್ದರಿಂದ ಲಾಬಾನನು ಹೋಗಿ ಯಾಕೋಬನ ಪಾಳೆಯದಲ್ಲಿಯೂ ಗುಡಾರದಲ್ಲಿಯೂ ಲೇಯಳ ಗುಡಾರದಲ್ಲಿಯೂ ಹುಡುಕಿದನು. ಬಳಿಕ ಇಬ್ಬರು ಸೇವಕಿಯರಿದ್ದ ಗುಡಾರಕ್ಕೂ ಹೋಗಿ ಹುಡುಕಿದನು; ಅಲ್ಲಿಯೂ ಅವನಿಗೆ ಅವನ ವಿಗ್ರಹಗಳು ಸಿಕ್ಕಲಿಲ್ಲ. ಅಲ್ಲಿಂದ ರಾಹೇಲಳ ಗುಡಾರಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ರಾಹೇಲಳು ಆ ವಿಗ್ರಹಗಳನ್ನು ತನ್ನ ಒಂಟೆಯ ಸಬರದೊಳಗಿಟ್ಟು ಅದರ ಮೇಲೆ ಕುಳಿತುಕೊಂಡಿದ್ದಳು. ಲಾಬಾನನು ಇಡೀ ಗುಡಾರವನ್ನು ಹುಡುಕಿದರೂ ತನ್ನ ವಿಗ್ರಹಗಳನ್ನು ಕಂಡುಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ಆಗ ರಾಹೇಲಳು ತನ್ನ ತಂದೆಗೆ, “ಅಪ್ಪಾ, ನನ್ನ ಮೇಲೆ ಕೋಪಗೊಳ್ಳಬೇಡ. ನಿನ್ನ ಮುಂದೆ ನಿಂತುಕೊಳ್ಳಲು ನನಗೆ ಸಾಧ್ಯವಿಲ್ಲ. ಯಾಕೆಂದರೆ ನಾನು ಮುಟ್ಟಾಗಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದಳು. ಲಾಬಾನನು ಪಾಳೆಯದಲ್ಲೆಲ್ಲಾ ಹುಡುಕಿದರೂ ತನ್ನ ವಿಗ್ರಹಗಳನ್ನು ಕಂಡುಕೊಳ್ಳಲಾಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ಆಗ ಯಾಕೋಬನು ತುಂಬಾ ಕೋಪಗೊಂಡು, “ನಾನು ಯಾವ ತಪ್ಪು ಮಾಡಿದೆ? ಯಾವ ನಿಯಮವನ್ನು ನಾನು ಉಲ್ಲಂಘಿಸಿರುವೆ? ನನ್ನನ್ನು ಬೆನ್ನಟ್ಟಿಕೊಂಡು ಬಂದು ತಡೆಯಲು ನಿನಗೆ ಯಾವ ಹಕ್ಕಿದೆ? ");
INSERT INTO kan2010_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ನಾನು ಹೊಂದಿರುವ ಪ್ರತಿಯೊಂದನ್ನು ನೀನು ಪರೀಕ್ಷಿಸಿ ನೋಡಿದರೂ ನಿನಗೆ ಸೇರಿರುವ ಯಾವುದೂ ನಿನಗೆ ಸಿಕ್ಕಲಿಲ್ಲ. ನಿನಗೆ ಅಂಥದ್ದೇನಾದರೂ ಸಿಕ್ಕಿದರೆ ತೋರಿಸು. ನನ್ನ ಜನರಿಗೆಲ್ಲ ಕಾಣಿಸುವಂತೆ ಅದನ್ನು ಇಲ್ಲಿಡು. ನಮ್ಮಲ್ಲಿ ಯಾರು ಸರಿಯಾದವರೆಂದು ನಮ್ಮ ಜನರೇ ನಿರ್ಣಯಿಸಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ನಾನು ನಿನಗೋಸ್ಕರ ಇಪ್ಪತ್ತು ವರ್ಷ ದುಡಿದೆ. ಆ ಸಮಯದಲ್ಲೆಲ್ಲ ಯಾವ ಕುರಿಮರಿಯಾಗಲಿ ಆಡಾಗಲಿ ಹುಟ್ಟುವಾಗ ಸಾಯಲಿಲ್ಲ; ನಿನ್ನ ಮಂದೆಗಳಲ್ಲಿನ ಯಾವ ಟಗರನ್ನಾಗಲಿ ನಾನು ತಿಂದುಬಿಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ಕ್ರೂರ ಮೃಗಗಳು ಕುರಿಯನ್ನು ಕೊಂದಾಗಲೆಲ್ಲಾ ಅದಕ್ಕೆ ಬದಲಾಗಿ ನನ್ನ ಕುರಿಯನ್ನು ನಿನಗೆ ಕೊಟ್ಟೆನು. ಸತ್ತುಹೋದ ಪಶುವನ್ನು ನಿನ್ನ ಮುಂದೆ ತಂದು, ‘ಇದು ನನ್ನ ತಪ್ಪಲ್ಲ’ ಎಂದು ನಿನಗೆ ಹೇಳಲಿಲ್ಲ. ಕಳುವು ಹಗಲಲ್ಲಾಗಿದ್ದರೂ ರಾತ್ರಿಯಲ್ಲಾಗಿದ್ದರೂ ಕಳುವಾದ ಪಶುಗಳಿಗೆ ಪ್ರತಿಯಾಗಿ ಪಶುಗಳನ್ನು ನೀನು ನನ್ನಿಂದ ವಸೂಲಿ ಮಾಡಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ಹಗಲಿನಲ್ಲಿ ಸೂರ್ಯನಿಂದ ನನ್ನ ಶಕ್ತಿಯನ್ನು ಕುಂದಿಸಿದೆ; ರಾತ್ರಿಯಲ್ಲಿ ಚಳಿಯಿಂದ ನನಗೆ ನಿದ್ರೆಯು ಬರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ನಾನು ಇಪ್ಪತ್ತು ವರ್ಷ ನಿನಗೆ ಗುಲಾಮನಂತೆ ಸೇವೆ ಮಾಡಿದೆನು. ಮೊದಲ ಹದಿನಾಲ್ಕು ವರ್ಷಗಳಲ್ಲಿ ನಿನ್ನ ಇಬ್ಬರು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ಪಡೆದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ದುಡಿದೆನು. ಕಡೆಯ ಆರು ವರ್ಷಗಳಲ್ಲಿ ನಿನ್ನ ಪಶುಗಳನ್ನು ಪಡೆದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ದುಡಿದೆನು. ಆ ಅವಧಿಯಲ್ಲಿ ನೀನು ನನ್ನ ಸಂಬಳವನ್ನು ಹತ್ತು ಸಲ ಬದಲಾಯಿಸಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ಆದರೆ ನನ್ನ ಪೂರ್ವಿಕರ ದೇವರೂ ಅಬ್ರಹಾಮನ ದೇವರೂ ಇಸಾಕನು ಭಯಪಡುವ ದೇವರೂ ನನ್ನ ಸಂಗಡವಿದ್ದನು. ದೇವರು ನನ್ನ ಜೊತೆಯಲ್ಲಿ ಇಲ್ಲದಿದ್ದರೆ ನೀನು ನನ್ನನ್ನು ಬರಿಗೈಲಿ ಕಳುಹಿಸಿಬಿಡುತ್ತಿದ್ದೆ. ಆದರೆ ನನ್ನ ಕಷ್ಟವನ್ನೂ ನಾನು ಮಾಡಿದ ಕೆಲಸವನ್ನೂ ದೇವರು ನೋಡಿದನು. ನಿನ್ನೆಯ ರಾತ್ರಿ ನಾನು ತಪ್ಪಿತಸ್ಥನಲ್ಲವೆಂದು ದೇವರು ನಿನಗೆ ತೋರಿಸಿಕೊಟ್ಟಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ಈ ಸ್ತ್ರೀಯರು ನನ್ನ ಮಕ್ಕಳು. ಅವರ ಮಕ್ಕಳು ನನಗೆ ಸೇರಿದವರು; ಈ ಪಶುಗಳು ನನ್ನವು. ನೀನು ಇಲ್ಲಿ ನೋಡುವ ಪ್ರತಿಯೊಂದೂ ನನಗೆ ಸೇರಿದ್ದು. ಆದರೆ ನನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನಾಗಲಿ ಅವರ ಮಕ್ಕಳನ್ನಾಗಲಿ ತೆಗೆದುಕೊಳ್ಳಲು ಸಾಧ್ಯವಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ಆದ್ದರಿಂದ ನಿನ್ನೊಡನೆ ಒಂದು ಒಪ್ಪಂದ ಮಾಡಿಕೊಳ್ಳಲು ಸಿದ್ಧನಾಗಿದ್ದೇನೆ. ನಮ್ಮ ಒಪ್ಪಂದಕ್ಕೆ ಸಾಕ್ಷಿಯಾಗಿ ಕಲ್ಲುಗಳ ಒಂದು ಕುಪ್ಪೆಯನ್ನು ಮಾಡೋಣ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ಅಂತೆಯೇ ಯಾಕೋಬನು ಮಾಡಿಕೊಂಡ ಒಪ್ಪಂದಕ್ಕೆ ಸಾಕ್ಷಿಯಾಗಿ ಒಂದು ದೊಡ್ಡ ಕಲ್ಲನ್ನು ತೆಗೆದುಕೊಂಡು ಬಂದು ಅಲ್ಲಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ಅವನು ತನ್ನ ಜನರಿಗೆ ಮತ್ತಷ್ಟು ಕಲ್ಲುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬಂದು ಕಲ್ಲಿನ ಕುಪ್ಪೆ ಮಾಡುವಂತೆ ಹೇಳಿದನು. ಬಳಿಕ ಅವರು ಆ ಕುಪ್ಪೆಯ ಬಳಿಯಲ್ಲಿ ಊಟಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ಲಾಬಾನನು ಆ ಸ್ಥಳಕ್ಕೆ ಯಗರ್‌ಸಾಹದೂತ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಆದರೆ ಯಾಕೋಬನು ಆ ಸ್ಥಳಕ್ಕೆ ಗಲೀದ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ಲಾಬಾನನು ಯಾಕೋಬನಿಗೆ, “ಈ ಕಲ್ಲುಗಳ ಕುಪ್ಪೆಯು ನಮ್ಮಿಬ್ಬರಿಗೂ ನಮ್ಮ ಒಪ್ಪಂದವನ್ನು ಜ್ಞಾಪಕಕ್ಕೆ ತರುತ್ತದೆ” ಎಂದು ಹೇಳಿದನು. ಆದಕಾರಣ ಯಾಕೋಬನು ಆ ಸ್ಥಳಕ್ಕೆ ಗಲೀದ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ಲಾಬಾನನು, “ನಾವು ಒಬ್ಬರನ್ನೊಬ್ಬರು ಅಗಲಿರುವಾಗ ಯೆಹೋವನೇ ನಮ್ಮನ್ನು ನೋಡಿಕೊಳ್ಳಲಿ” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಮಿಚ್ಪಾ ಎಂದೂ ಹೆಸರಿಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ಆಮೇಲೆ ಲಾಬಾನನು “ನೀನು ನನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳನ್ನು ನೋಯಿಸಿದರೆ, ದೇವರು ನಿನ್ನನ್ನು ದಂಡಿಸುವನು ಎಂಬುದನ್ನು ನೆನಪು ಮಾಡಿಕೊ. ನೀನು ಬೇರೆ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡರೆ, ದೇವರು ನಿನ್ನನ್ನು ನೋಡುತ್ತಿದ್ದಾನೆ ಎಂಬುದನ್ನು ನೆನಪು ಮಾಡಿಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ನಮ್ಮಿಬ್ಬರ ಮಧ್ಯದಲ್ಲಿ ನಾನಿಟ್ಟಿರುವ ಈ ಕಲ್ಲುಗಳು ಇಲ್ಲಿವೆ; ನಾವು ಒಪ್ಪಂದ ಮಾಡಿಕೊಂಡಿದ್ದೇವೆ ಎಂಬುದನ್ನು ಸೂಚಿಸುವ ವಿಶೇಷವಾದ ಕಲ್ಲೂ ಇಲ್ಲಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ಈ ಕಲ್ಲುಗಳ ಕುಪ್ಪೆಯೂ ವಿಶೇಷವಾದ ಈ ಕಲ್ಲೂ ನಮ್ಮ ಒಪ್ಪಂದವನ್ನು ನೆನಪುಮಾಡಿಕೊಳ್ಳಲು ನಮ್ಮಿಬ್ಬರಿಗೂ ಸಹಾಯ ಮಾಡುತ್ತವೆ. ನಾನು ನಿನಗೆ ವಿರೋಧವಾಗಿ ಹೋರಾಡುವುದಕ್ಕಾಗಿ ಈ ಕಲ್ಲುಗಳನ್ನು ದಾಟಿ ಬರುವುದಿಲ್ಲ. ನೀನು ನನಗೆ ವಿರೋಧವಾಗಿ ಈ ಕಲ್ಲುಗಳನ್ನು ದಾಟಿ ನನ್ನ ಕಡೆಗೆ ಬರಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ನಾವು ಈ ಒಪ್ಪಂದವನ್ನು ಮುರಿದುಹಾಕಿದರೆ, ನಮ್ಮಲ್ಲಿ ಅಪರಾಧಿಯಾದವನಿಗೆ ಅಬ್ರಹಾಮನ ದೇವರು, ನಾಹೋರನ ದೇವರು ಮತ್ತು ಅವರ ಪೂರ್ವಿಕರ ದೇವರು ನ್ಯಾಯತೀರಿಸಲಿ” ಎಂದು ಹೇಳಿದನು. ಅದೇ ರೀತಿಯಲ್ಲಿ ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನು ಭಯಭಕ್ತಿಯಿಂದ ಸೇವೆಮಾಡುವ ದೇವರ ಮೇಲೆ ಆಣೆಯಿಟ್ಟು ಪ್ರಮಾಣಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ಆಮೇಲೆ ಯಾಕೋಬನು ಒಂದು ಪಶುವನ್ನು ಕೊಂದು ಅದನ್ನು ಬೆಟ್ಟದ ಮೇಲೆ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸಿದನು; ತನ್ನ ಜನರನ್ನು ಊಟಕ್ಕೆ ಆಹ್ವಾನಿಸಿದನು. ಅವರು ಊಟ ಮಾಡಿದ ಮೇಲೆ, ಆ ರಾತ್ರಿ ಬೆಟ್ಟದ ಮೇಲೆ ಇದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ಮರುದಿನ ಮುಂಜಾನೆ ಲಾಬಾನನು ತನ್ನ ಮೊಮ್ಮಕ್ಕಳಿಗೂ ಹೆಣ್ಣುಮಕ್ಕಳಿಗೂ ಮುದ್ದಿಟ್ಟು ಆಶೀರ್ವದಿಸಿ ತನ್ನ ಮನೆಗೆ ಹಿಂತಿರುಗಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ಯಾಕೋಬನು ಅಲ್ಲಿಂದ ಹೊರಟು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿರುವಾಗ ದೇವದೂತರನ್ನು ನೋಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ಆದ್ದರಿಂದ ಅವನು, “ಇದು ದೇವರ ಪಾಳೆಯ” ಎಂದು ಹೇಳಿ “ಮಹನಯಿಮ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ಯಾಕೋಬನ ಅಣ್ಣನಾದ ಏಸಾವನು ಸೇಯೀರ್ ಎಂಬ ಸ್ಥಳದಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ಈ ಸ್ಥಳವು ಎದೋಮಿನ ಗುಡ್ಡಗಾಡು ಪ್ರದೇಶವಾಗಿತ್ತು. ಯಾಕೋಬನು ತನ್ನ ಸಂದೇಶಕರ ಮೂಲಕ ");
INSERT INTO kan2010_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ಏಸಾವನಿಗೆ ಈ ಸಂಗತಿಗಳನ್ನು ತಿಳಿಸಿದನು: “ನಿನ್ನ ಸೇವಕನಾದ ಯಾಕೋಬನು ಹೇಳುವುದೇನೆಂದರೆ, ‘ನಾನು ಕಳೆದ ವರ್ಷಗಳೆಲ್ಲಾ ಲಾಬಾನನೊಡನೆ ಜೀವಿಸಿದೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ನನಗೆ ಅನೇಕ ದನಗಳೂ, ಕತ್ತೆಗಳೂ, ಆಡುಕುರಿಗಳೂ ಮತ್ತು ಸೇವಕಸೇವಕಿಯರೂ ಇದ್ದಾರೆ. ಸ್ವಾಮೀ, ನೀವು ನಮ್ಮನ್ನು ಸ್ವೀಕರಿಸಿಕೊಳ್ಳಬೇಕೆಂದು ಕೇಳಿಕೊಳ್ಳುತ್ತಿದ್ದೇನೆ.’” ");
INSERT INTO kan2010_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ಸಂದೇಶಕರು ಯಾಕೋಬನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಂದು, “ನಾವು ನಿನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನ ಬಳಿಗೆ ಹೋದೆವು. ಅವನು ನಿನ್ನನ್ನು ಭೇಟಿಯಾಗಲು ಬರುತ್ತಿದ್ದಾನೆ. ಅವನೊಡನೆ ನಾನೂರು ಮಂದಿ ಗಂಡಸರಿದ್ದಾರೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ಯಾಕೋಬನಿಗೆ ಭಯವಾಯಿತು. ಅವನು ತನ್ನೊಡನೆ ಇದ್ದ ಜನರನ್ನು ಎರಡು ಗುಂಪುಗಳನ್ನಾಗಿ ವಿಂಗಡಿಸಿದನು. ಅವನು ಎಲ್ಲಾ ಆಡುಕುರಿಗಳನ್ನೂ ದನಕರುಗಳನ್ನೂ ಒಂಟೆಗಳನ್ನೂ ಎರಡು ಗುಂಪುಗಳನ್ನಾಗಿ ವಿಂಗಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“ಒಂದುವೇಳೆ ಏಸಾವನು ಬಂದು ಒಂದು ಗುಂಪನ್ನು ನಾಶಗೊಳಿಸಿದರೆ, ಮತ್ತೊಂದು ಗುಂಪು ಓಡಿಹೋಗಿ ತಪ್ಪಿಸಿಕೊಳ್ಳಬಹುದು” ಎಂಬುದು ಅವನ ಆಲೋಚನೆಯಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ಯಾಕೋಬನು, “ನನ್ನ ತಂದೆಯಾದ ಅಬ್ರಹಾಮನ ದೇವರೇ, ನನ್ನ ತಂದೆಯಾದ ಇಸಾಕನ ದೇವರಾಗಿರುವ ಯೆಹೋವನೇ, ನನ್ನ ದೇಶಕ್ಕೆ ಮತ್ತು ನನ್ನ ಕುಟುಂಬಕ್ಕೆ ಹಿಂತಿರುಗಿ ಬರುವಂತೆ ನೀನು ಹೇಳಿದೆ. ನೀನು ನನಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡುವುದಾಗಿ ಹೇಳಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ನೀನು ನನಗೆ ತುಂಬ ಕರುಣೆ ತೋರಿದೆ. ನೀನು ನನಗೆ ಅನೇಕ ಒಳ್ಳೆಯ ಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದೆ. ಮೊದಲನೆ ಸಲ ನಾನು ಜೋರ್ಡನ್ ನದಿಯನ್ನು ದಾಟಿ ಪ್ರಯಾಣ ಮಾಡಿದಾಗ, ಕೇವಲ ನನ್ನ ಊರುಗೋಲೇ ಹೊರತು ಬೇರೇನೂ ನನಗಿರಲಿಲ್ಲ. ಆದರೆ ಈಗ ಎರಡು ಗುಂಪುಗಳಿಗೆ ಬೇಕಾದ ವಸ್ತುಗಳನ್ನು ನಾನು ಪಡೆದಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ಇಂತಿರಲು, ದಯವಿಟ್ಟು ನನ್ನ ಅಣ್ಣನಿಂದ ನನ್ನನ್ನು ಕಾಪಾಡಬೇಕೆಂದು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತಿರುವೆ. ಏಸಾವನಿಂದ ನನ್ನನ್ನು ಕಾಪಾಡು. ಅವನು ಬಂದು ನಮ್ಮೆಲ್ಲರನ್ನೂ ತಾಯಂದಿರನ್ನೂ ಮಕ್ಕಳನ್ನೂ ಕೊಲ್ಲುವನೆಂಬ ಭಯ ನನಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","‘ನಾನು ನಿನಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡುವೆ. ನಾನು ನಿನ್ನ ಕುಟುಂಬವನ್ನು ಹೆಚ್ಚಿಸಿ ನಿನ್ನ ಮಕ್ಕಳನ್ನು ಸಮುದ್ರದ ಮರಳಿನಷ್ಟು ವೃದ್ಧಿಗೊಳಿಸುವೆನು. ಅವರು ಲೆಕ್ಕಿಸಲಾಗದಷ್ಟು ಅಸಂಖ್ಯಾತವಾಗಿರುವರು’ ಎಂದು ನೀನು ನನಗೆ ವಾಗ್ದಾನ ಮಾಡಿದಿಯಲ್ಲವೇ” ಎಂದು ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ಯಾಕೋಬನು ಆ ರಾತ್ರಿ ಅಲ್ಲಿಯೇ ಉಳಿದುಕೊಂಡು ಏಸಾವನಿಗೆ ಉಡುಗೊರೆಯಾಗಿ ಕೊಡಲು ಕೆಲವು ವಸ್ತುಗಳನ್ನು ಸಿದ್ಧಗೊಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ಯಾಕೋಬನು ಇನ್ನೂರು ಮೇಕೆಗಳನ್ನು, ಇಪ್ಪತ್ತು ಹೋತಗಳನ್ನು, ಇನ್ನೂರು ಕುರಿಗಳನ್ನು ಮತ್ತು ಇಪ್ಪತ್ತು ಟಗರುಗಳನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ಯಾಕೋಬನು ಮೂವತ್ತು ಒಂಟೆಗಳನ್ನು ಮತ್ತು ಅವುಗಳ ಮರಿಗಳನ್ನು ನಲವತ್ತು ಹಸುಗಳನ್ನು ಮತ್ತು ಹತ್ತು ಹೋರಿಗಳನ್ನು, ಇಪ್ಪತ್ತು ಹೆಣ್ಣು ಕತ್ತೆಗಳನ್ನು ಮತ್ತು ಹತ್ತು ಗಂಡು ಕತ್ತೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ಯಾಕೋಬನು ಪಶುಗಳ ಪ್ರತಿಯೊಂದು ಮಂದೆಯನ್ನೂ ತನ್ನ ಸೇವಕರ ವಶಕ್ಕೆ ಕೊಟ್ಟನು. ಆಮೇಲೆ ಯಾಕೋಬನು ಸೇವಕರಿಗೆ, “ಪಶುಗಳ ಪ್ರತಿಯೊಂದು ಗುಂಪನ್ನು ವಿಂಗಡಿಸಿ ನನ್ನ ಮುಂದೆ ಹೋಗಿರಿ; ಅಲ್ಲದೆ ಪ್ರತಿಯೊಂದು ಮಂದೆಯ ನಡುವೆಯೂ ಸ್ವಲ್ಪ ಅಂತರವಿರಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ಯಾಕೋಬನು ಅವರಿಗೆ ಅವರವರ ಕರ್ತವ್ಯಗಳನ್ನು ತಿಳಿಸಿದನು. ಯಾಕೋಬನು ಪಶುಗಳ ಮೊದಲನೆ ಗುಂಪಿನ ಸೇವಕನಿಗೆ, “ನನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನು ನಿನ್ನ ಬಳಿಗೆ ಬಂದು, ‘ಇವು ಯಾರ ಪಶುಗಳು? ನೀನು ಎಲ್ಲಿಗೆ ಹೋಗುತ್ತಿರುವೆ? ನೀನು ಯಾರ ಸೇವಕನು?’ ಎಂದು ಕೇಳುವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ಆಗ ನೀನು, ‘ಪಶುಗಳು ನಿನ್ನ ಸೇವಕನಾದ ಯಾಕೋಬನವು. ನನ್ನ ಒಡೆಯನಾದ ಏಸಾವನೇ, ಯಾಕೋಬನು ಇವುಗಳನ್ನು ನಿನಗೆ ಉಡುಗೊರೆಯಾಗಿ ಕಳುಹಿಸಿದ್ದಾನೆ. ಅಲ್ಲದೆ ಅವನು ಸಹ ನಮ್ಮ ಹಿಂದೆ ಬರುತ್ತಿದ್ದಾನೆ’ ಎಂದು ತಿಳಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ಇದೇ ರೀತಿ ಮಾಡುವಂತೆ ಯಾಕೋಬನು ಎರಡನೆಯ ಸೇವಕನಿಗೆ, ಮೂರನೆಯ ಸೇವಕನಿಗೆ ಮತ್ತು ಉಳಿದೆಲ್ಲಾ ಸೇವಕರಿಗೆ ಆಜ್ಞಾಪಿಸಿದನು. ಅವನು ಅವರಿಗೆ, “ನೀವು ಏಸಾವನನ್ನು ಭೇಟಿಯಾದಾಗ ಇದೇ ರೀತಿ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ನೀವು ಅವನಿಗೆ, ‘ಇದು ನಿನಗೆ ಕಳುಹಿಸಿರುವ ಉಡುಗೊರೆ. ಅಲ್ಲದೆ ನಿನ್ನ ಸೇವಕನಾದ ಯಾಕೋಬನು ನಮ್ಮ ಹಿಂದೆ ಬರುತ್ತಿದ್ದಾನೆ’ ಎಂದು ಹೇಳಬೇಕು” ಎಂದು ತಿಳಿಸಿದನು. “ನಾನು ಈ ಜನರನ್ನು ಉಡುಗೊರೆಗಳೊಡನೆ ಮುಂದೆ ಕಳುಹಿಸಿದರೆ, ಒಂದುವೇಳೆ ಏಸಾವನು ನನ್ನನ್ನು ಕ್ಷಮಿಸಿ ನನ್ನನ್ನು ಸ್ವೀಕರಿಸಿಕೊಳ್ಳಬಹುದು” ಎಂಬುದು ಯಾಕೋಬನ ಆಲೋಚನೆಯಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ಯಾಕೋಬನು ಏಸಾವನಿಗೆ ಉಡುಗೊರೆಗಳನ್ನು ಕಳುಹಿಸಿ ಆ ರಾತ್ರಿ ಪಾಳೆಯದಲ್ಲಿ ಉಳಿದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ಆ ರಾತ್ರಿ, ಯಾಕೋಬನು ಎದ್ದು ತನ್ನ ಇಬ್ಬರು ಹೆಂಡತಿಯರನ್ನೂ ತನ್ನ ಇಬ್ಬರು ದಾಸಿಯರನ್ನೂ ತನ್ನ ಹನ್ನೊಂದು ಮಂದಿ ಗಂಡುಮಕ್ಕಳನ್ನೂ ಕರೆದುಕೊಂಡು ಹೊರಟು ಯಬ್ಬೋಕ್ ಹೊಳೆಯನ್ನು ದಾಟತಕ್ಕ ಸ್ಥಳಕ್ಕೆ ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ಯಾಕೋಬನು ತನ್ನ ಕುಟುಂಬದವರನ್ನೂ ತನ್ನಲ್ಲಿದ್ದ ಪ್ರತಿಯೊಂದನ್ನೂ ಆಚೆದಡಕ್ಕೆ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ಎಲ್ಲರನ್ನೂ ಹೊಳೆ ದಾಟಿಸಿದ ಮೇಲೆ ಕೊನೆಯವನಾಗಿ ತಾನೊಬ್ಬನೇ ಹೊಳೆದಾಟಲು ನಿಂತಿದ್ದಾಗ ಒಬ್ಬ ಪುರುಷನು ಬಂದು ಸೂರ್ಯೋದಯದವರೆಗೂ ಹೋರಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ಯಾಕೋಬನನ್ನು ಸೋಲಿಸಲು ತನಗೆ ಸಾಧ್ಯವಾಗದಿರುವುದನ್ನು ಗಮನಿಸಿದ ಆ ಪುರುಷನು ಯಾಕೋಬನ ತೊಡೆಯನ್ನು ಮುಟ್ಟಿದನು. ಆಗ ಯಾಕೋಬನ ಕೀಲು ತಪ್ಪಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ಆ ಪುರುಷನು ಯಾಕೋಬನಿಗೆ, “ನನ್ನನ್ನು ಬಿಡು, ಸೂರ್ಯೋದಯವಾಗುತ್ತಿದೆ” ಎಂದು ಹೇಳಿದನು. ಆದರೆ ಯಾಕೋಬನು, “ನೀನು ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸದ ಹೊರತು ನಾನು ನಿನ್ನನು ಬಿಡುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ಆ ಪುರುಷನು ಅವನಿಗೆ, “ನಿನ್ನ ಹೆಸರೇನು?” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕೆ ಯಾಕೋಬನು, “ನನ್ನ ಹೆಸರು ಯಾಕೋಬ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ಆಗ ಆ ಪುರುಷನು, “ಇನ್ನು ಮೇಲೆ ನಿನ್ನ ಹೆಸರು ‘ಯಾಕೋಬ’ ಎಂದಿರುವುದಿಲ್ಲ. ಇಂದಿನಿಂದ ನಿನ್ನ ಹೆಸರು ‘ಇಸ್ರೇಲ್’ ಎಂದಾಗುವುದು. ನಾನೇ ನಿನಗೆ ಈ ಹೆಸರನ್ನು ಕೊಟ್ಟಿದ್ದೇನೆ; ಯಾಕೆಂದರೆ ನೀನು ದೇವರೊಡನೆಯೂ ಮನುಷ್ಯರೊಡನೆಯೂ ಹೋರಾಡಿದೆ; ಆದರೂ ನೀನು ಸೋಲಲಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ಯಾಕೋಬನು ಆತನಿಗೆ, “ದಯವಿಟ್ಟು ನಿನ್ನ ಹೆಸರನ್ನು ತಿಳಿಸು” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕೆ ಆ ಪುರುಷನು, “ನನ್ನ ಹೆಸರನ್ನು ವಿಚಾರಿಸುವುದೇಕೆ?” ಎಂದು ಹೇಳಿ ಯಾಕೋಬನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ಆದ್ದರಿಂದ ಯಾಕೋಬನು, “ಈ ಸ್ಥಳದಲ್ಲಿ ನಾನು ದೇವರನ್ನು ಮುಖಾಮುಖಿಯಾಗಿ ನೋಡಿದರೂ ನನ್ನ ಜೀವ ಉಳಿಯಿತು” ಎಂದು ಹೇಳಿ ಆ ಸ್ಥಳಕ್ಕೆ ಪೆನೀಯೇಲ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ಆಮೇಲೆ ಅವನು ಪೆನೀಯೇಲ್‌ನಿಂದ ಹೊರಟುಹೋಗುತ್ತಿರುವಾಗ ಸೂರ್ಯೋದಯವಾಯಿತು. ಯಾಕೋಬನು ತನ್ನ ಕೀಲುನೋವಿನಿಂದ ಕುಂಟುತ್ತಾ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ಈ ಮಾಂಸಖಂಡದಲ್ಲಿ ಯಾಕೋಬನಿಗೆ ನೋವು ಉಂಟಾಗಿದ್ದರಿಂದ ಇಂದಿಗೂ ಇಸ್ರೇಲರು ತೊಡೆಯ ಕೀಲಿನ ಮೇಲಿರುವ ಸೊಂಟದ ಮಾಂಸವನ್ನು ತಿನ್ನುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ಯಾಕೋಬನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ ಏಸಾವನು ನಾನೂರು ಜನರೊಂದಿಗೆ ಬರುವುದನ್ನು ಕಂಡನು. ಯಾಕೋಬನು ತನ್ನ ಕುಟುಂಬವನ್ನು ನಾಲ್ಕು ಗುಂಪುಗಳಾಗಿ ವಿಂಗಡಿಸಿದನು. ಲೇಯಾ ಮತ್ತು ಅವಳ ಮಕ್ಕಳು ಒಂದು ಗುಂಪಿನಲ್ಲಿದ್ದರು. ರಾಹೇಲಳು ಮತ್ತು ಯೋಸೇಫನು ಇನ್ನೊಂದು ಗುಂಪಿನಲ್ಲಿದ್ದರು. ಇಬ್ಬರು ದಾಸಿಯರು ಮತ್ತು ಅವರ ಮಕ್ಕಳು ಎರಡು ಗುಂಪುಗಳಲ್ಲಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ಯಾಕೋಬನು ದಾಸಿಯರನ್ನು ಮತ್ತು ಅವರ ಮಕ್ಕಳನ್ನು ಮುಂಭಾಗದಲ್ಲಿಯೂ ಲೇಯಳನ್ನು ಮತ್ತು ಅವಳ ಮಕ್ಕಳನ್ನು ಅವರ ಹಿಂಭಾಗದಲ್ಲಿಯೂ, ರಾಹೇಲಳನ್ನು ಮತ್ತು ಯೋಸೇಫನನ್ನು ಕೊನೆಯ ಸ್ಥಳದಲ್ಲೂ ಇರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ಯಾಕೋಬನು ತಾನೇ ಮುಂದಾಗಿ ಏಸಾವನ ಬಳಿಗೆ ನಡೆದುಹೋಗುತ್ತಾ ಏಳು ಸಲ ನೆಲದ ತನಕ ಬಗ್ಗಿ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ಏಸಾವನು ಯಾಕೋಬನನ್ನು ಕಂಡಾಗ, ಓಡಿಬಂದು ತನ್ನ ಕೈಗಳಿಂದ ತಬ್ಬಿಕೊಂಡು ಅವನ ಕೊರಳಿನ ಮೇಲೆ ಮುದ್ದಿಟ್ಟನು; ಅವರಿಬ್ಬರೂ ಕಣ್ಣೀರು ಸುರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ಏಸಾವನು ಸ್ತ್ರೀಯರನ್ನು ಮತ್ತು ಮಕ್ಕಳನ್ನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿ, “ನಿನ್ನೊಡನೆ ಇರುವ ಈ ಜನರು ಯಾರು?” ಎಂದು ಕೇಳಿದನು. ಯಾಕೋಬನು, “ದೇವರು ನನಗೆ ಕೊಟ್ಟ ಮಕ್ಕಳೇ ಇವರು. ದೇವರು ನನಗೆ ಒಳ್ಳೆಯವನಾಗಿದ್ದನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ಆಮೇಲೆ ಇಬ್ಬರು ದಾಸಿಯರು ಮತ್ತು ಅವರೊಂದಿಗೆ ಇದ್ದ ಮಕ್ಕಳು ಏಸಾವನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ಆಮೇಲೆ ಲೇಯಾ ಮತ್ತು ಅವಳೊಂದಿಗೆ ಇದ್ದ ಮಕ್ಕಳು ಏಸಾವನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದರು. ತರುವಾಯ, ರಾಹೇಲಳು ಮತ್ತು ಯೋಸೇಫನು ಏಸಾವನ ಬಳಿಗೆ ಹೋಗಿ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ಏಸಾವನು, “ನಾನು ಬರುತ್ತಿರುವಾಗ ಕಂಡ ಆ ಜನರೆಲ್ಲಾ ಯಾರು? ಆ ಪಶುಗಳೆಲ್ಲಾ ಯಾತಕ್ಕೆ?” ಎಂದು ಕೇಳಿದನು. ಯಾಕೋಬನು, “ನೀನು ನನ್ನನ್ನು ಸ್ವೀಕರಿಸಿಕೊಳ್ಳಲಿ ಎಂದು ಅವುಗಳನ್ನು ಉಡುಗೊರೆಗಳನ್ನಾಗಿ ಕಳುಹಿಸಿಕೊಟ್ಟೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ಆದರೆ ಏಸಾವನು, “ತಮ್ಮನೇ, ನೀನು ನನಗೆ ಉಡುಗೊರೆಗಳನ್ನು ಕೊಡಬೇಕಾಗಿಲ್ಲ, ನನಗೆ ಬೇಕಾದಷ್ಟಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ಯಾಕೋಬನು, “ಇಲ್ಲ! ನಾನು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ; ನೀನು ನನ್ನನ್ನು ನಿಜವಾಗಿಯೂ ಸ್ವೀಕರಿಸಿಕೊಳ್ಳುವುದಾದರೆ, ನಾನು ಕೊಡುವ ಉಡುಗೊರೆಗಳನ್ನು ದಯವಿಟ್ಟು ಸ್ವೀಕರಿಸಬೇಕು. ನಿನ್ನ ಮುಖವನ್ನು ಮತ್ತೆ ನೋಡಿ ನನಗೆ ತುಂಬ ಸಂತೋಷವಾಗಿದೆ. ದೇವರ ಮುಖವನ್ನೇ ನೋಡಿದಂತಾಯಿತು. ನೀನು ನನ್ನನ್ನು ಸ್ವೀಕರಿಸಿಕೊಂಡದ್ದರಿಂದ ನನಗೆ ತುಂಬ ಸಂತೋಷವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ಆದ್ದರಿಂದ ನಾನು ಕೊಡುವ ಈ ಉಡುಗೊರೆಗಳನ್ನು ಸ್ವೀಕರಿಸಿಕೊಳ್ಳಬೇಕೆಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತಿರುವೆ. ದೇವರು ನನಗೆ ತುಂಬ ಒಳ್ಳೆಯವನಾಗಿದ್ದನು. ನನಗೆ ಬೇಕಾದದ್ದಕ್ಕಿಂತಲೂ ಹೆಚ್ಚಾಗಿ ನನ್ನಲ್ಲಿದೆ” ಎಂದು ಹೇಳಿದನು. ಹೀಗೆ ಯಾಕೋಬನು ಉಡುಗೊರೆಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳುವಂತೆ ಏಸಾವನನ್ನು ಬೇಡಿಕೊಂಡನು. ಆದ್ದರಿಂದ ಏಸಾವನು ಉಡುಗೊರೆಗಳನ್ನು ಸ್ವೀಕರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ಆಮೇಲೆ ಏಸಾವನು, “ಈಗ ನೀನು ನಿನ್ನ ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರಿಸಬಹುದು. ನಾನು ನಿನ್ನ ಜೊತೆಯಲ್ಲಿ ಬರುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ಆದರೆ ಯಾಕೋಬನು ಅವನಿಗೆ, “ನನ್ನ ಮಕ್ಕಳು ಬಲಹೀನರೆಂದು ನಿನಗೆ ಗೊತ್ತಿದೆ. ನಾನು ನನ್ನ ದನಕುರಿಗಳನ್ನೂ ಅವುಗಳ ಮರಿಗಳನ್ನೂ ಎಚ್ಚರಿಕೆಯಿಂದ ನೋಡಿಕೊಳ್ಳಬೇಕು. ಒಂದೇ ದಿನದಲ್ಲಿ ಬಹುದೂರದವರೆಗೆ ಎಡಬಿಡದೆ ನಡೆಸಿಕೊಂಡು ಹೋದರೆ, ಎಲ್ಲಾ ಪಶುಗಳು ಸತ್ತುಹೋಗುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ಆದ್ದರಿಂದ ನೀನು ಮುಂದಾಗಿ ಹೋಗು. ನಾನು ನಿನ್ನನ್ನು ನಿಧಾನವಾಗಿ ಹಿಂಬಾಲಿಸುವೆನು. ದನಕುರಿಗಳು ಮತ್ತು ಇತರ ಪಶುಗಳು ಸುರಕ್ಷಿತವಾಗಿರುವಂತೆಯೂ ನನ್ನ ಮಕ್ಕಳು ತುಂಬ ಆಯಾಸಗೊಳ್ಳದಂತೆಯೂ ನಾನು ಸಾಕಷ್ಟು ನಿಧಾನವಾಗಿ ಬಂದು ನಿನ್ನನ್ನು ಸೇಯೀರ್‌ನಲ್ಲಿ ಭೇಟಿಯಾಗುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ಅದಕ್ಕೆ ಏಸಾವನು, “ಹಾಗಾದರೆ ನನ್ನ ಜನರಲ್ಲಿ ಕೆಲವರನ್ನು ನಿನ್ನ ಸಹಾಯಕ್ಕಾಗಿ ಬಿಟ್ಟುಹೋಗುವೆನು” ಎಂದು ಹೇಳಿದನು. ಆದರೆ ಯಾಕೋಬನು, “ಅದು ನಿನ್ನ ದಯೆ. ಆದರೆ ಅಂಥ ಅಗತ್ಯವೇನೂ ಇಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ಆದ್ದರಿಂದ ಆ ದಿನ ಏಸಾವನು ಸೇಯೀರಿಗೆ ಮರಳಿ ಪ್ರಯಾಣ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ಆದರೆ ಯಾಕೋಬನು ಸುಕ್ಕೋತಿಗೆ ಹೋದನು. ಆ ಸ್ಥಳದಲ್ಲಿ ಅವನು ತನಗಾಗಿ ಒಂದು ಮನೆಯನ್ನೂ ತನ್ನ ದನಕುರಿಗಳಿಗಾಗಿ ಚಿಕ್ಕ ಕೊಟ್ಟಿಗೆಗಳನ್ನೂ ಕಟ್ಟಿಸಿದನು. ಆದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ “ಸುಕ್ಕೋತ್” ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ಆಮೇಲೆ ಯಾಕೋಬನು ಕಾನಾನ್ ದೇಶದ ಶೆಕೆಮ್ ಪಟ್ಟಣಕ್ಕೆ ಬಂದು ತನ್ನ ಪಾಳೆಯನ್ನು ಪಟ್ಟಣದ ಸಮೀಪದಲ್ಲಿದ್ದ ಒಂದು ಹೊಲದಲ್ಲಿ ಹಾಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ಯಾಕೋಬನು ನೂರು ಬೆಳ್ಳಿನಾಣ್ಯಗಳನ್ನು ಕೊಟ್ಟು ಶೆಕೆಮನ ತಂದೆಯಾದ ಹಮೋರನ ಕುಟುಂಬದಿಂದ ಆ ಹೊಲವನ್ನು ಕೊಂಡುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ದೇವರನ್ನು ಆರಾಧಿಸುವುದಕ್ಕಾಗಿ ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಸಿ ಆ ಸ್ಥಳಕ್ಕೆ “ಇಸ್ರೇಲರ ದೇವರಾದ ಏಲೆಲೋಹೇ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ದೀನಳು ಲೇಯಾ ಮತ್ತು ಯಾಕೋಬನ ಮಗಳು. ದೀನಳು ಒಂದು ದಿನ ಆ ದೇಶದ ಸ್ತ್ರೀಯರನ್ನು ನೋಡಲು ಹೊರಗೆ ಹೋದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ಆ ದೇಶದ ರಾಜನಾಗಿದ್ದ ಹಮೋರನ ಮಗನಾದ ಶೆಕೆಮನು ದೀನಳನ್ನು ಕಂಡು ಅವಳನ್ನು ಎಳೆದುಕೊಂಡು ಹೋಗಿ ಬಲಾತ್ಕಾರ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ಶೆಕೆಮನಿಗೆ ದೀನಳ ಮೇಲೆ ಪ್ರೀತಿಯುಂಟಾಗಿ ಆಕೆಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಲು ಇಷ್ಟಪಟ್ಟನು. ಅವನು ತನ್ನನ್ನು ಮದುವೆಯಾಗಬೇಕೆಂದು ಆಕೆಯ ಸಂಗಡ ಮನವೊಲಿಸುವ ಮಾತುಗಳನ್ನಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ಶೆಕೆಮನು ತನ್ನ ತಂದೆಗೆ, “ದಯವಿಟ್ಟು ಈ ಹುಡುಗಿಯನ್ನು ನನಗೆ ಮದುವೆಮಾಡಿಸು” ಎಂದು ಕೇಳಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ಯಾಕೋಬನು ತನ್ನ ಮಗಳಿಗೆ ಶೆಕೆಮನಿಂದ ಮಾನಭಂಗವಾದ ಸುದ್ದಿಯನ್ನು ಕೇಳಿದನು. ಆದರೆ ಅವನ ಗಂಡುಮಕ್ಕಳೆಲ್ಲ ಕುರಿಗಳೊಂದಿಗೆ ಹೊಲದಲ್ಲಿದ್ದುದರಿಂದ ಅವರು ಮನೆಗೆ ಬರುವತನಕ ಏನೂ ಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ಆ ಸಮಯದಲ್ಲಿ ಶೆಕೆಮನ ತಂದೆಯಾದ ಹಮೋರನು ಯಾಕೋಬನೊಂದಿಗೆ ಮಾತಾಡಲು ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ಹೊಲದಲ್ಲಿದ್ದ ಯಾಕೋಬನ ಗಂಡುಮಕ್ಕಳು ನಡೆದ ಸಂಗತಿಯನ್ನು ಕೇಳಿ ತುಂಬ ಕೋಪಗೊಂಡರು. ಶೆಕೆಮನು ಯಾಕೋಬನ ಮಗಳನ್ನು ಮಾನಭಂಗ ಮಾಡಿ ಇಸ್ರೇಲರಿಗೆ ಅವಮಾನ ಮಾಡಿದ್ದರಿಂದ ಅವರು ಆವೇಶಗೊಂಡರು. ಶೆಕೆಮನು ತುಂಬ ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡಿದ್ದರಿಂದ ಅಣ್ಣಂದಿರು ಹೊಲದಿಂದ ಹಿಂತಿರುಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ಆದರೆ ಹಮೋರನು ದೀನಳ ಅಣ್ಣಂದಿರೊಡನೆ ಮಾತಾಡಿದನು. ಅವನು ಅವರಿಗೆ, “ನನ್ನ ಮಗನಾದ ಶೆಕೆಮನು ದೀನಳನ್ನು ತುಂಬ ಇಷ್ಟಪಡುತ್ತಾನೆ. ಅವನು ಆಕೆಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಳ್ಳಲು ದಯವಿಟ್ಟು ಅವಕಾಶಕೊಡಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ಈ ಮದುವೆಯು ನಮಗಾಗಿರುವ ಒಂದು ವಿಶೇಷ ಒಪ್ಪಂದವನ್ನು ತೋರಿಸುತ್ತದೆ. ಅದೇನೆಂದರೆ, ನಮ್ಮ ಗಂಡಸರು ನಿಮ್ಮ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆಯಾಗಬಹುದು ಮತ್ತು ನಿಮ್ಮ ಗಂಡಸರು ನಮ್ಮ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆಯಾಗಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ನೀವು ನಮ್ಮೊಂದಿಗೆ ಒಂದೇ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿರಬಹುದು. ನಿಮಗೆ ಇಲ್ಲಿ ಜಮೀನು ಮಾಡಿಕೊಳ್ಳಲು ಮತ್ತು ವ್ಯಾಪಾರ ಮಾಡಲು ಸ್ವತಂತ್ರವಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ಶೆಕೆಮನು ಸಹ ಯಾಕೋಬನೊಡನೆ ಮತ್ತು ದೀನಳ ಅಣ್ಣಂದಿರೊಡನೆ ಮಾತಾಡಿದನು. ಶೆಕೆಮನು ಅವರಿಗೆ, “ದಯವಿಟ್ಟು ನನ್ನನ್ನು ಸ್ವೀಕಾರಮಾಡಿ ನೀವು ಏನೇ ಹೇಳಿದರೂ ನಾನು ಮಾಡುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ನಾನು ದೀನಳನ್ನು ಮದುವೆಯಾಗಲು ನೀವು ನನಗೆ ಅವಕಾಶಕೊಟ್ಟರೆ ಸಾಕು. ನಾನು ನಿಮಗೆ ಯಾವ ಉಡುಗೊರೆಯನ್ನು ಬೇಕಾದರೂ ಕೊಡುವೆನು. ನೀವು ಏನು ಕೇಳಿದರೂ ಕೊಡುವೆನು. ಆದರೆ ನನಗೆ ದೀನಳನ್ನು ಮದುವೆ ಮಾಡಿಸಿಕೊಡಿ” ಎಂದು ಕೇಳಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ಯಾಕೋಬನ ಗಂಡುಮಕ್ಕಳು ಶೆಕೆಮನಿಗೂ ಅವನ ತಂದೆಗೂ ಸುಳ್ಳು ಹೇಳಲು ನಿರ್ಧರಿಸಿದರು. ತಮ್ಮ ತಂಗಿಯಾದ ದೀನಳಿಗೆ ಶೆಕೆಮನು ಅಂಥ ಕೆಟ್ಟಕಾರ್ಯವನ್ನು ಮಾಡಿದ್ದರಿಂದ ಅವರು ಇನ್ನೂ ಆವೇಶದಿಂದ ಇದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ಆದ್ದರಿಂದ ಆಕೆಯ ಅಣ್ಣಂದಿರು ಅವನಿಗೆ, “ನೀನು ನಮ್ಮ ತಂಗಿಯನ್ನು ಮದುವೆಯಾಗಲು ನಾವು ಅವಕಾಶ ಕೊಡುವಂತಿಲ್ಲ; ಯಾಕೆಂದರೆ ನಿನಗಿನ್ನೂ ಸುನ್ನತಿಯಾಗಿಲ್ಲ. ನಮ್ಮ ತಂಗಿಯು ನಿನ್ನನ್ನು ಮದುವೆಯಾಗುವುದು ತಪ್ಪಾಗುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ಆದರೆ ನೀನು ಮತ್ತು ನಿಮ್ಮ ಪಟ್ಟಣದಲ್ಲಿರುವ ಪ್ರತಿಯೊಬ್ಬ ಗಂಡಸು ನಮ್ಮಂತೆ ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡರೆ ನೀನು ಆಕೆಯನ್ನು ಮದುವೆಯಾಗಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ಆಮೇಲೆ ನಿಮ್ಮ ಗಂಡಸರು ನಮ್ಮ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆಯಾಗಬಹುದು ಮತ್ತು ನಮ್ಮ ಗಂಡಸರು ನಿಮ್ಮ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆಯಾಗಬಹುದು. ಆಗ ನಾವು ಒಂದೇ ಜನಾಂಗವಾಗುವೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ಆದರೆ ನೀವು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳದಿದ್ದರೆ ನಾವು ದೀನಳನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗುತ್ತೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ಅವರು ಹೇಳಿದ್ದು ಹಮೋರನಿಗೂ ಶೆಕೆಮನಿಗೂ ಒಳ್ಳೆಯದೆಂದು ತೋಚಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ದೀನಳ ಅಣ್ಣಂದಿರು ಹೇಳಿದ್ದನ್ನು ಮಾಡಲು ಶೆಕೆಮನು ಸಂತೋಷದಿಂದ ಒಪ್ಪಿಕೊಂಡನು. ಶೆಕೆಮನಿಗೆ ಅವರ ಕುಟುಂಬದಲ್ಲಿ ತುಂಬ ಗೌರವವಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ಹಮೋರನು ಮತ್ತು ಶೆಕೆಮನು ತಮ್ಮ ನಗರದ ಸಭಾಸ್ಥಳಕ್ಕೆ ಹೋದರು. ಅವರು ಪಟ್ಟಣದ ಗಂಡಸರೊಂದಿಗೆ ಮಾತಾಡಿ, ");
INSERT INTO kan2010_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ಈ ಇಸ್ರೇಲರಿಗೆ ನಮ್ಮ ಸ್ನೇಹಿತರಾಗಿರಲು ಇಷ್ಟ; ಇವರು ನಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದುಕೊಂಡು ನಮ್ಮೊಂದಿಗೆ ಸಮಾಧಾನದಿಂದಿರುವುದು ನಮಗೂ ಇಷ್ಟ; ನಮ್ಮೆಲ್ಲರಿಗೂ ಬೇಕಾಗುವಷ್ಟು ಭೂಮಿ ನಮ್ಮಲ್ಲಿದೆ. ನಾವು ಅವರ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆಯಾಗವುದಕ್ಕೂ ನಮ್ಮ ಸ್ತ್ರೀಯರನ್ನು ಅವರಿಗೆ ಮದುವೆ ಮಾಡಿಕೊಡುವುದಕ್ಕೂ ಸಂತೋಷಪಡುತ್ತೇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ಆದರೆ ನಾವು ಮಾಡಬೇಕಾದ ಒಂದೇ ಒಂದು ಕಾರ್ಯವೇನೆಂದರೆ, ಇಸ್ರೇಲರಂತೆ ನಮ್ಮ ಎಲ್ಲಾ ಗಂಡಸರು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ನಾವು ಹೀಗೆ ಮಾಡಿದರೆ, ಅವರ ಎಲ್ಲಾ ದನಕುರಿಗಳಿಂದಲೂ ಪಶುಗಳಿಂದಲೂ ಐಶ್ವರ್ಯವಂತರಾಗುತ್ತೇವೆ. ನಾವು ಈ ಒಪ್ಪಂದವನ್ನು ಅವರೊಂದಿಗೆ ಮಾಡಿಕೊಂಡರೆ ಅವರು ನಮ್ಮೊಂದಿಗೆ ಇಲ್ಲಿ ವಾಸಿಸುವರು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ಸಭಾಸ್ಥಳದಲ್ಲಿದ್ದ ಗಂಡಸರೆಲ್ಲರೂ ಹಮೋರ ಮತ್ತು ಶೆಕೆಮರ ಮಾತಿಗೆ ಒಪ್ಪಿಕೊಂಡರು. ಬಳಿಕ ಎಲ್ಲಾ ಗಂಡಸರು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ಮೂರು ದಿನಗದರೂ ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡಿದ್ದ ಗಂಡಸರು ಇನ್ನೂ ಗಾಯದ ನೋವಿನಲ್ಲಿದ್ದರು. ಈ ಸಮಯದಲ್ಲಿ ಗಂಡಸರು ಬಲಹೀನರಾಗಿರುತ್ತಾರೆ ಎಂಬುದು ಯಾಕೋಬನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಾದ ಸಿಮೆಯೋನ್ ಮತ್ತು ಲೇವಿಗೆ ತಿಳಿದಿತ್ತು. ಆದ್ದರಿಂದ ಅವರು ಪಟ್ಟಣಕ್ಕೆ ಹೋಗಿ ಅಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಗಂಡಸರನ್ನು ಕೊಂದುಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ದೀನಳ ಅಣ್ಣಂದಿರಾದ ಸಿಮೆಯೋನನು ಮತ್ತು ಲೇವಿಯು ಹಮೋರನನ್ನೂ ಅವನ ಮಗನಾದ ಶೆಕೆಮನನ್ನೂ ಕೊಂದುಹಾಕಿ ದೀನಳನ್ನು ಶೆಕಮನ ಮನೆಯಿಂದ ಕರೆದುಕೊಂಡು ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ಯಾಕೋಬನ ಗಂಡುಮಕ್ಕಳು ಪಟ್ಟಣದೊಳಗೆ ಹೋಗಿ ಅಲ್ಲಿದ್ದ ಪ್ರತಿಯೊಂದನ್ನು ತೆಗೆದುಕೊಂಡರು. ತಮ್ಮ ತಂಗಿಗೆ ಶೆಕೆಮನು ಮಾಡಿದ ಮಾನಭಂಗದಿಂದ ಅವರು ಇನ್ನೂ ಕೋಪದಲ್ಲಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ಹೀಗೆ ದೀನಳ ಅಣ್ಣಂದಿರು ಅವರ ದನಕುರಿಗಳನ್ನೂ ಕತ್ತೆಗಳನ್ನೂ ಪಟ್ಟಣದಲ್ಲಿಯೂ ಹೊಲದಲ್ಲಿಯೂ ಇದ್ದ ಆಸ್ತಿಯೆಲ್ಲವನ್ನೂ ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ಅವರ ಹೆಂಡತಿಯರನ್ನೂ ಮಕ್ಕಳನ್ನೂ ಸೆರೆಹಿಡಿದು ಮನೆಯಲ್ಲಿದ್ದದ್ದನ್ನೆಲ್ಲಾ ದೋಚಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ಆದರೆ ಯಾಕೋಬನು ಸಿಮೆಯೋನನಿಗೆ ಮತ್ತು ಲೇವಿಗೆ, “ನೀವು ನನ್ನನ್ನು ಅಪಾಯಕ್ಕೆ ಗುರಿಮಾಡಿದಿರಿ. ಈ ದೇಶದಲ್ಲಿರುವ ಎಲ್ಲಾ ಕಾನಾನ್ಯರು ಮತ್ತು ಪೆರಿಜೀಯರು ನನ್ನನ್ನು ದ್ವೇಷಿಸಿ ನನಗೆ ವಿರೋಧವಾಗುವರು. ನನಗಿರುವ ಜನರು ಕೆಲವರೇ. ಈ ದೇಶದಲ್ಲಿರುವ ಜನರು ಒಟ್ಟಾಗಿ ಸೇರಿಕೊಂಡು ನನಗೆ ವಿರೋಧವಾಗಿ ಹೋರಾಡಿದರೆ ನಾನೂ ನನ್ನ ಜನರೆಲ್ಲರೂ ನಾಶವಾಗುವೆವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ಆದರೆ ದೀನಳ ಅಣ್ಣಂದಿರು, “ನಮ್ಮ ತಂಗಿಯನ್ನು ಆ ಜನರು ಸೂಳೆಯಂತೆ ಉಪಯೋಗಿಸಿಕೊಳ್ಳಲು ನಾವು ಬಿಡಬೇಕೇ? ಇಲ್ಲ, ನಮ್ಮ ತಂಗಿಗೆ ಆ ಜನರು ಮಾಡಿದ್ದು ತಪ್ಪು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ದೇವರು ಯಾಕೋಬನಿಗೆ, “ನೀನು ಬೇತೇಲ್ ಪಟ್ಟಣಕ್ಕೆ ಹೋಗಿ ಅಲ್ಲೇ ವಾಸಿಸು ಮತ್ತು ಆರಾಧನೆಗಾಗಿ ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿಸು. ನೀನು ನಿನ್ನ ಅಣ್ಣನಾದ ಏಸಾವನ ಬಳಿಯಿಂದ ಓಡಿಹೋಗುತ್ತಿದ್ದಾಗ ದೇವರಾದ ‘ಏಲ್’ ನಿನಗೆ ಅಲ್ಲಿ ಕಾಣಿಸಿಕೊಳ್ಳಲಿಲ್ಲವೇ! ಆತನ ಆರಾಧನೆಗಾಗಿ ಅಲ್ಲಿ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ಆದ್ದರಿಂದ ಯಾಕೋಬನು ತನ್ನ ಕುಟುಂಬದವರಿಗೂ ತನ್ನ ಎಲ್ಲಾ ಸೇವಕರಿಗೂ, “ನಿಮ್ಮಲ್ಲಿರುವ ಮರದ ಮತ್ತು ಲೋಹದ ಎಲ್ಲಾ ಅನ್ಯದೇವರುಗಳನ್ನು ನಾಶಮಾಡಿರಿ. ನಿಮ್ಮನ್ನು ಶುದ್ಧಿ ಮಾಡಿಕೊಂಡು ಶುದ್ಧವಾದ ಬಟ್ಟೆಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ನಾವು ಇಲ್ಲಿಂದ ಹೊರಟು ಬೇತೇಲಿಗೆ ಹೋಗೋಣ; ನಾನು ಕಷ್ಟದಲ್ಲಿದ್ದಾಗ ಸಹಾಯಮಾಡಿದ ದೇವರಿಗಾಗಿ ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಅಲ್ಲಿ ಕಟ್ಟಿಸುತ್ತೇನೆ. ನಾನು ಹೋದಕಡೆಗಳಲ್ಲೆಲ್ಲಾ ಆ ದೇವರು ನನ್ನೊಂದಿಗೆ ಇದ್ದನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ಆದ್ದರಿಂದ ಅವರು ತಮ್ಮಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಅನ್ಯದೇವರುಗಳನ್ನೂ ತಮ್ಮ ಕಿವಿಗಳಲ್ಲಿದ್ದ ವಾಲೆಗಳನ್ನೂ ಯಾಕೋಬನಿಗೆ ಕೊಟ್ಟರು. ಯಾಕೋಬನು ಅವುಗಳನ್ನೆಲ್ಲಾ ಶೆಕೆಮ್ ಪಟ್ಟಣದ ಸಮೀಪದಲ್ಲಿರುವ ಏಲಾವೃಕ್ಷದ ಬುಡದಲ್ಲಿ ಹೂಳಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ಯಾಕೋಬನು ಮತ್ತು ಅವನ ಗಂಡುಮಕ್ಕಳು ಆ ಸ್ಥಳದಿಂದ ಹೊರಟರು. ಆ ಪ್ರದೇಶದಲ್ಲಿದ್ದ ಜನರು ಅವರನ್ನು ಹಿಂಬಾಲಿಸಿ ಕೊಲ್ಲಬೇಕೆಂದಿದ್ದರು. ಆದರೆ ಅವರು ಭಯಪಟ್ಟು ಯಾಕೋಬನನ್ನು ಹಿಂಬಾಲಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ಯಾಕೋಬನು ಮತ್ತು ಅವರ ಜನರು ಲೂಜಿಗೆ ಹೋದರು. ಈಗ ಲೂಜನ್ನು “ಬೇತೇಲ್” ಎಂದು ಕರೆಯುತ್ತಾರೆ. ಅದು ಕಾನಾನ್ ದೇಶದಲ್ಲಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ಯಾಕೋಬನು ಅಲ್ಲಿ ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಸಿದನು. ಯಾಕೋಬನು ತನ್ನ ಅಣ್ಣನ ಬಳಿಯಿಂದ ಓಡಿ ಹೋಗುತ್ತಿದ್ದಾಗ ದೇವರು ಅವನಿಗೆ ಮೊದಲು ಕಾಣಿಸಿಕೊಂಡದ್ದು ಆ ಸ್ಥಳದಲ್ಲೇ. ಆದ್ದರಿಂದ ಯಾಕೋಬನು ಆ ಸ್ಥಳಕ್ಕೆ “ಏಲ್ ಬೇತೇಲ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ರೆಬೆಕ್ಕಳ ದಾಸಿಯಾದ ದೆಬೋರಳು ಅಲ್ಲಿ ಸತ್ತುಹೋದಳು. ಆದ್ದರಿಂದ ಅವರು ಆಕೆಯನ್ನು ಬೇತೇಲಿನ ಬಳಿಯಲ್ಲಿರುವ ಏಲಾವೃಕ್ಷದ ಬುಡದಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಿದರು. ಆ ಸ್ಥಳಕ್ಕೆ “ಅಲ್ಲೋನ್ ಬಾಕೂತ್” ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ಯಾಕೋಬನು ಪದ್ದನ್‌ಅರಾಮಿನಿಂದ ಹಿಂತಿರುಗಿ ಬಂದಾಗ, ದೇವರು ಅವನಿಗೆ ಮತ್ತೆ ಕಾಣಿಸಿಕೊಂಡು ಅವನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ದೇವರು ಯಾಕೋಬನಿಗೆ, “ನಿನ್ನ ಹೆಸರು ಯಾಕೋಬ. ಆದರೆ ನಾನು ಆ ಹೆಸರನ್ನು ಬದಲಾಯಿಸುವೆನು. ಇನ್ನು ಮುಂದೆ ನೀನು ಯಾಕೋಬನೆಂದು ಕರೆಸಿಕೊಳ್ಳುವುದಿಲ್ಲ. ನಿನ್ನ ಹೊಸ ಹೆಸರು ‘ಇಸ್ರೇಲ್’” ಎಂದು ಹೇಳಿ ಅವನಿಗೆ “ಇಸ್ರೇಲ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ದೇವರು ಅವನಿಗೆ, “ನಾನೇ ಸರ್ವಶಕ್ತನಾದ ದೇವರು. ನೀನು ಅನೇಕ ಮಕ್ಕಳನ್ನು ಪಡೆದು ಮಹಾಜನಾಂಗವಾಗಿ ಬೆಳೆಯುವೆ. ಅನೇಕ ಜನಾಂಗಗಳೂ ರಾಜರುಗಳೂ ನಿನ್ನೊಳಗಿಂದ ಬರುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ನಾನು ಅಬ್ರಹಾಮನಿಗೂ ಇಸಾಕನಿಗೂ ವಿಶೇಷವಾದ ದೇಶವನ್ನು ಕೊಟ್ಟೆನು. ಈಗ ನಾನು ಆ ದೇಶವನ್ನು ನಿನಗೆ ಕೊಡುವೆನು. ನಾನು ಆ ದೇಶವನ್ನು ನಿನ್ನ ಮುಂದಿನ ಸಂತತಿಗಳವರಿಗೆ ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ಆಮೇಲೆ ದೇವರು ಆ ಸ್ಥಳದಿಂದ ಹೊರಟುಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","15","ಯಾಕೋಬನು ಈ ಸ್ಥಳದಲ್ಲಿ ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಒಂದು ಸ್ಮಾರಕಕಲ್ಲನ್ನು ನಿಲ್ಲಿಸಿ ಅದರ ಮೇಲೆ ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಎಣ್ಣೆಯನ್ನೂ ಸುರಿದನು. ಇದು ಒಂದು ವಿಶೇಷವಾದ ಸ್ಥಳ. ಯಾಕೆಂದರೆ ಅಲ್ಲಿ ದೇವರು ಯಾಕೋಬನೊಂದಿಗೆ ಮಾತಾಡಿದನು. ಯಾಕೋಬನು ಆ ಸ್ಥಳಕ್ಕೆ “ಬೇತೇಲ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ಯಾಕೋಬನು ಮತ್ತು ಅವನ ಜನರು ಬೇತೇಲಿನಿಂದ ಹೊರಟು ಬೆತ್ಲೆಹೇಮೆಂಬ ಎಫ್ರಾತೂರಿಗೆ ಬರುವುದಕ್ಕಿಂತ ಸ್ವಲ್ಪಮುಂಚೆ ರಾಹೇಲಳಿಗೆ ಹೆರಿಗೆ ಕಾಲ ಬಂದಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ಆದರೆ ರಾಹೇಲಳು ಈ ಹೆರಿಗೆಯಲ್ಲಿ ತುಂಬ ಕಷ್ಟಪಡಬೇಕಾಯಿತು. ಆಕೆಗೆ ಬಹಳ ನೋವಿತ್ತು. ರಾಹೇಲಳ ದಾದಿಯು ಇದನ್ನು ಕಂಡು, ಆಕೆಗೆ, “ರಾಹೇಲಳೇ, ಭಯಪಡಬೇಡ. ನೀನು ಮತ್ತೊಬ್ಬ ಮಗನಿಗೆ ಜನನ ಕೊಡುತ್ತಿರುವೆ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ರಾಹೇಲಳು ಮಗನನ್ನು ಹೆರುವಾಗ ಸತ್ತುಹೋದಳು; ಸಾಯುವುದಕ್ಕೆ ಮೊದಲು, ರಾಹೇಲಳು ಆ ಮಗುವಿಗೆ ಬೆನೋನಿ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಆದರೆ ಯಾಕೋಬನು ಅವನಿಗೆ ಬೆನ್ಯಾಮೀನ್ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಹಾಗೆ ರಾಹೇಳಲು ಮೃತಪಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ರಾಹೇಲಳನ್ನು ಬೆತ್ಲೆಹೇಮೆಂಬ ಎಫ್ರಾತಿಗೆ ಹೋಗುವ ದಾರಿಯಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ಯಾಕೋಬನು ರಾಹೇಲಳ ಗೌರವಾರ್ಥವಾಗಿ ಆಕೆಯ ಸಮಾಧಿಯ ಮೇಲೆ ವಿಶೇಷವಾದ ಒಂದು ಕಲ್ಲನ್ನು ಇಟ್ಟನು. ಇಂದಿಗೂ ಆ ವಿಶೇಷವಾದ ಕಲ್ಲು ಅಲ್ಲಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ಆಮೇಲೆ ಇಸ್ರೇಲನು ತನ್ನ ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರೆಸಿ “ಮಿಗ್ದಲ್‌ಏದರ್” ಗೋಪುರದ ದಕ್ಷಿಣದಲ್ಲಿ ಗುಡಾರವನ್ನು ಹಾಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ಇಸ್ರೇಲನು ಸ್ವಲ್ಪಕಾಲದವರೆಗೆ ಅಲ್ಲಿ ಇಳಿದುಕೊಂಡನು. ಅವನು ಅಲ್ಲಿದ್ದಾಗ ರೂಬೇನನು ಇಸ್ರೇಲನ ದಾಸಿಯಾದ ಬಿಲ್ಹಳೊಡನೆ ಮಲಗಿಕೊಂಡನು. ಇಸ್ರೇಲನು ಇದರ ಬಗ್ಗೆ ಕೇಳಿದಾಗ ತುಂಬ ಕೋಪಗೊಂಡನು. ಯಾಕೋಬನಿಗೆ (ಇಸ್ರೇಲ) ಹನ್ನೆರಡು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ಲೇಯಳ ಗಂಡುಮಕ್ಕಳು: ಯಾಕೋಬನ ಚೊಚ್ಚಲ ಮಗನಾದ ರೂಬೇನ್, ಸಿಮೆಯೋನ್, ಲೇವಿ, ಯೆಹೂದ, ಇಸ್ಸಾಕಾರ್ ಮತ್ತು ಜೆಬುಲೂನ್. ");
INSERT INTO kan2010_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ರಾಹೇಲಳ ಗಂಡುಮಕ್ಕಳು: ಯೋಸೇಫ ಮತ್ತು ಬೆನ್ಯಾಮೀನ್. ");
INSERT INTO kan2010_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ಬಿಲ್ಹಳು ರಾಹೇಲಳ ದಾಸಿ. ಬಿಲ್ಹಳ ಗಂಡುಮಕ್ಕಳು: ದಾನ್ ಮತ್ತು ನಫ್ತಾಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ಜಿಲ್ಪಳು ಲೇಯಳ ದಾಸಿ. ಜಿಲ್ಪಳ ಗಂಡುಮಕ್ಕಳು: ಗಾದ್ ಮತ್ತು ಆಶೇರ್. ಇವರೆಲ್ಲರು ಯಾಕೋಬನಿಗೆ ಪದ್ದನ್‌ಅರಾಮಿನಲ್ಲಿ ಹುಟ್ಟಿದ ಗಂಡುಮಕ್ಕಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ಯಾಕೋಬನು ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನ ಬಳಿಗೆ ಹೆಬ್ರೋನೆಂಬ ಕಿರ್ಯತರ್ಬದಲ್ಲಿದ್ದ ಮಮ್ರೆಗೆ ಬಂದನು. ಅಬ್ರಹಾಮನು ಮತ್ತು ಇಸಾಕನು ವಾಸವಾಗಿದ್ದದ್ದು ಇಲ್ಲೇ. ");
INSERT INTO kan2010_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ಇಸಾಕನು ನೂರೆಂಭತ್ತು ವರ್ಷಗಳವರೆಗೆ ಜೀವಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ಆಮೇಲೆ ಇಸಾಕನು ದಿನ ತುಂಬಿದ ಮುದುಕನಾಗುವವರೆಗೆ ಜೀವಿಸಿ ತೀರಿಕೊಂಡನು. ಅವನ ಮಕ್ಕಳಾದ ಏಸಾವನು ಮತ್ತು ಯಾಕೋಬನು ತಮ್ಮ ಅಜ್ಜನಿಗೆ ಸಮಾಧಿಯಾಗಿದ್ದ ಸ್ಥಳದಲ್ಲೇ ತಮ್ಮ ತಂದೆಗೆ ಸಮಾಧಿ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ಎದೋಮನೆಂಬ ಏಸಾವನ ಕುಟುಂಬ ಚರಿತ್ರೆ: ");
INSERT INTO kan2010_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ಏಸಾವನು ಕಾನಾನ್ ದೇಶದ ಸ್ತ್ರೀಯರನ್ನು ಮದುವೆಯಾದನು. ಏಸಾವನ ಹೆಂಡತಿಯರು: ಹಿತ್ತಿಯನಾದ ಏಲೋನನ ಮಗಳಾದ ಆದಾ; ಹಿವ್ವಿಯನಾದ ಸಿಬೆಯೋನನಿಗೆ ಹುಟ್ಟಿದ ಅನಾಹ ಎಂಬಾಕೆಯ ಮಗಳಾಗಿದ್ದ ಒಹೊಲೀಬಾಮ; ");
INSERT INTO kan2010_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ಇಷ್ಮಾಯೇಲನ ಮಗಳೂ ನೆಬಾಯೋತನ ತಂಗಿಯೂ ಆಗಿದ್ದ ಬಾಸೆಮತ್. ");
INSERT INTO kan2010_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ಏಸಾವನಿಗೆ ಮತ್ತು ಆದಾಳಿಗೆ ಎಲೀಫಜನೆಂಬ ಮಗನಿದ್ದನು. ಬಾಸೆಮತಳಿಗೆ ರೆಗೂವೇಲನೆಂಬ ಮಗನಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ಒಹೊಲೀಬಾಮಳಿಗೆ ಮೂವರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು: ಯೆಗೂಷ, ಯಳಾಮ ಮತ್ತು ಕೋರಹ. ಇವರೆಲ್ಲರೂ ಏಸಾವನ ಗಂಡುಮಕ್ಕಳು ಮತ್ತು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಹುಟ್ಟಿದವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","ಯಾಕೋಬ ಮತ್ತು ಏಸಾವರ ಕುಟುಂಬಗಳು ಬಹಳ ವೃದ್ಧಿಯಾದ ಕಾರಣ ಕಾನಾನ್ ದೇಶವು ಅವರಿಗೆ ಸಾಕಾಗಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಏಸಾವನು ತನ್ನ ತಮ್ಮನಾದ ಯಾಕೋಬನಿಂದ ದೂರ ಹೋದನು. ಏಸಾವನು ತನ್ನ ಹೆಂಡತಿಯರನ್ನೂ ಗಂಡುಹೆಣ್ಣುಮಕ್ಕಳನ್ನೂ ಎಲ್ಲಾ ಸೇವಕರನ್ನೂ ದನಗಳನ್ನೂ ಮತ್ತು ಇತರ ಪಶುಗಳನ್ನೂ ತನಗೆ ಕಾನಾನಿನಲ್ಲಿದ್ದ ಪ್ರತಿಯೊಂದು ಆಸ್ತಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಸೇಯೀರ್ ಬೆಟ್ಟದ ಸೀಮೆಗೆ ಹೋದನು. (ಏಸಾವನಿಗೆ ಎದೋಮ್ ಎಂಬ ಹೆಸರೂ ಇದೆ. ಎದೋಮ್ ಎಂಬುದು ಸೇಯೀರ್ ದೇಶದ ಮತ್ತೊಂದು ಹೆಸರು.) ");
INSERT INTO kan2010_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ಏಸಾವನು ಎದೋಮ್ ಜನರ ತಂದೆ. ಸೇಯೀರ್ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಏಸಾವನ ಕುಟುಂಬದವರ ಹೆಸರುಗಳು: ");
INSERT INTO kan2010_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ಏಸಾವನ ಗಂಡುಮಕ್ಕಳು: ಎಲೀಫಜ, ಇವನು ಏಸಾವನಿಗೆ ಆದಾ ಎಂಬಾಕೆಯಲ್ಲಿ ಹುಟ್ಟಿದ ಮಗನು. ರೆಗೂವೇಲ, ಇವನು ಏಸಾವನಿಗೆ ಬಾಸೆಮತಳಲ್ಲಿ ಹುಟ್ಟಿದ ಮಗನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ಎಲೀಫಜನಿಗೆ ಐದು ಮಂದಿ ಗಂಡುಮಕ್ಕಳಿದ್ದರು: ತೇಮಾನ್, ಓಮಾರ್, ಚೆಪೋ, ಗತಾಮ್ ಮತ್ತು ಕೆನಜ್. ");
INSERT INTO kan2010_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ಎಲೀಫಜನಿಗೆ ತಿಮ್ನ ಎಂಬ ಒಬ್ಬ ದಾಸಿಯೂ ಇದ್ದಳು. ತಿಮ್ನಳಿಗೆ ಮತ್ತು ಎಲೀಫಜನಿಗೆ ಅಮಾಲೇಕ ಎಂಬ ಒಬ್ಬ ಗಂಡುಮಗನಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ರೆಗೂವೇಲನಿಗೆ ನಾಲ್ಕು ಮಂದಿ ಗಂಡುಮಕ್ಕಳಿದ್ದರು: ನಹತ್, ಜೆರಹ, ಶಮ್ಮಾ ಮತ್ತು ಮಿಜ್ಜಾ. ಇವರು ಏಸಾವನ ಮೊಮ್ಮಕ್ಕಳು. ಇವರು ಏಸಾವನ ಹೆಂಡತಿಯಾದ ಬಾಸೆಮತಳ ಸಂತತಿಯವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ಏಸಾವನ ಮೂರನೆ ಹೆಂಡತಿಯು ಅನಾಹನ ಮಗಳಾದ ಒಹೊಲೀಬಾಮ. (ಅನಾಹನು ಸಿಬೆಯೋನನ ಮಗನು.) ಏಸಾವನ ಮತ್ತು ಒಹೊಲೀಬಾಮಳ ಮಕ್ಕಳು: ಯೆಗೂಷ್, ಯಳಾಮ್ ಮತ್ತು ಕೋರಹ. ");
INSERT INTO kan2010_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ಏಸಾವನ ವಂಶಸ್ಥರ ಕುಲಪತಿಗಳು: ಏಸಾವನ ಮೊದಲನೆ ಮಗನಾದ ಎಲೀಫಜ. ಎಲೀಫಜನಿಂದ ಬಂದವರು: ತೇಮಾನ್, ಓಮಾರ್, ಚೆಫೋ, ಕೆನೆಜ್, ");
INSERT INTO kan2010_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ಕೋರಹ, ಗತಾಮ ಮತ್ತು ಅಮಾಲೇಕ. ಈ ಕುಲಪತಿಗಳು ಏಸಾವನ ಹೆಂಡತಿಯಾದ ಆದಾಳ ಸಂತತಿಯವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ಏಸಾವನ ಮಗನಾದ ರೆಗೂವೇಲನು ಈ ಕುಟುಂಬಗಳ ತಂದೆಯಾಗಿದ್ದನು: ನಹತ, ಜೆರಹ, ಶಮ್ಮಾ ಮತ್ತು ಮಿಜ್ಜಾ. ಈ ಕುಟುಂಬಗಳೆಲ್ಲವು ಏಸಾವನ ಹೆಂಡತಿಯಾದ ಬಾಸೆಮತಳ ಸಂತತಿಯವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ಅನಾಹನ ಮಗಳೂ ಏಸಾವನ ಹೆಂಡತಿಯೂ ಆಗಿದ್ದ ಒಹೊಲೀಬಾಮಳಲ್ಲಿ ಹುಟ್ಟಿದವರು: ಯಗೂಷ್, ಯೆಳಾಮ ಮತ್ತು ಕೋರಹ. ಈ ಮೂವರು ತಮ್ಮ ಕುಟುಂಬಗಳ ತಂದೆಯಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ಈ ಕುಟುಂಬಗಳಿಗೆಲ್ಲಾ ಏಸಾವನೇ ಮೂಲಪುರುಷ. ");
INSERT INTO kan2010_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ಏಸಾವನಿಗಿಂತ ಮೊದಲು ಹೋರಿಯ ಜನಾಂಗದ ಸೇಯೀರ್ ಎಂಬವನು ಎದೋಮಿನಲ್ಲಿ ವಾಸವಾಗಿದ್ದನು. ಸೇಯೀರನ ಗಂಡುಮಕ್ಕಳು: ಲೋಟಾನ್, ಶೋಬಾಲ್, ಸಿಬೆಯೋನ್, ಅನಾಹ, ");
INSERT INTO kan2010_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ದೀಶೋನ್, ಏಚೆರ್ ಮತ್ತು ದೀಶಾನ್, ಆ ಗಂಡುಮಕ್ಕಳು ಕುಲಪತಿಗಳಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ಲೋಟಾನನು ಹೋರಿ, ಹೇಮಾಮ್ ಎಂಬುವರ ತಂದೆ. (ತಿಮ್ನಳು ಲೋಟಾನನ ತಂಗಿ.) ");
INSERT INTO kan2010_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ಶೋಬಾಲನು ಅಲ್ಪಾನ್, ಮಾನಹತ್, ಗೇಬಾಲ್, ಶೆಫೋ ಮತ್ತು ಓನಾಮ್ ಎಂಬವರ ತಂದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ಸಿಬೆಯೋನನಿಗೆ ಅಯ್ಯಾ ಮತ್ತು ಅನಾಹ ಎಂಬ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. (ತನ್ನ ತಂದೆಯ ಕತ್ತೆಗಳನ್ನು ಮೇಯಿಸುತ್ತಿದ್ದಾಗ ಬಿಸಿನೀರಿನ ಒರತೆಗಳನ್ನು ಕಂಡುಕೊಂಡವನೇ ಅನಾಹ.) ");
INSERT INTO kan2010_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ಅನಾಹನು ದೀಶೋನ್ ಮತ್ತು ಓಹೊಲೀಬಾಮಳ ತಂದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ದಿಶೋನನಿಗೆ ಹೆಮ್ದಾನ್, ಎಷ್ಬಾನ್, ಇತ್ರಾನ್ ಮತ್ತು ಕೆರಾನ್ ಎಂಬ ನಾಲ್ಕ ಮಂದಿ ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ಏಚೆರನಿಗೆ ಬಿಲ್ಹಾನ್, ಚಾವಾನ್ ಮತ್ತು ಅಕಾನ್ ಎಂಬ ಮೂರು ಮಂದಿ ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ದೀಶಾನನಿಗೆ ಊಚ್ ಮತ್ತು ಅರಾನ್ ಎಂಬ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ಹೋರಿಯರ ಕುಟುಂಬಗಳ ನಾಯಕರುಗಳ ಹೆಸರುಗಳು ಇಂತಿವೆ: ಲೋಟಾನ್, ಶೋಬಾಲ್, ಸಿಬೆಯೋನ್, ಅನಾಹ, ");
INSERT INTO kan2010_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ದೀಶೋನ್, ಏಚೆರ್ ಮತ್ತು ದೀಶಾನ್. ಸೇಯೀರ್‌ನಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಹೋರಿಯ ಕುಟುಂಬಗಳ ನಾಯಕರುಗಳು ಇವರೇ. ");
INSERT INTO kan2010_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ಆ ಸಮಯದಲ್ಲಿ ಎದೋಮಿನಲ್ಲಿ ರಾಜರುಗಳಿದ್ದರು. ಇಸ್ರೇಲರಿಗಿಂತಲೂ ಮುಂಚೆ ಎದೋಮಿಗೆ ರಾಜರುಗಳಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ಬೆಯೋರನ ಮಗನಾದ ಬೆಲಗನು ಎದೋಮಿನ ರಾಜನಾಗಿದ್ದನು. ಅವನು ದಿನ್ಹಾಬಾ ನಗರವನ್ನು ಆಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ಬೆಲಗನು ಸತ್ತಮೇಲೆ, ಯೋಬಾಬನು ರಾಜನಾದನು. ಯೋಬಾಬನು ಬೊಚ್ರದವನಾದ ಚೆರಹನ ಮಗನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ಯೋಬಾಬನು ಸತ್ತಮೇಲೆ ಹುಷಾಮನು ಆಳಿದನು. ಹುಷಾಮನು ತೇಮಾನೀಯರ ದೇಶದವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ಹುಷಾಮನು ಸತ್ತಮೇಲೆ, ಹದದನು ಆ ದೇಶವನ್ನು ಆಳಿದನು. ಹದದನು ಬೆದದನ ಮಗನು. (ಮೊವಾಬ್ಯರನ್ನು ಮಿದ್ಯಾನರ ದೇಶದಲ್ಲಿ ಸೋಲಿಸಿದವನೇ ಬೆದದನು.) ಹದದನು ಅವೀತ್ ಪಟ್ಟಣದವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ಹದದನು ಸತ್ತಮೇಲೆ, ಸಮ್ಲಾಹನು ಆ ದೇಶವನ್ನು ಆಳಿದನು; ಸಮ್ಲಾಹನು ಮಸ್ರೇಕದವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ಸಮ್ಲಾಹನು ಸತ್ತಮೇಲೆ ಸೌಲನು ಆ ದೇಶವನ್ನು ಆಳಿದನು. ಸೌಲನು ಯೂಫ್ರೇಟೀಸ್ ನದಿತೀರದಲ್ಲಿರುವ ರೆಹೋಬೋತೂರಿನವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ಸೌಲನು ಸತ್ತಮೇಲೆ ಆ ದೇಶವನ್ನು ಬಾಳ್ಹಾನಾನನು ಆಳಿದನು. ಬಾಳ್ಹಾನಾನನು ಅಕ್ಬೋರನ ಮಗನು. ");
INSERT INTO kan2010_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ಬಾಳ್ಹಾನಾನನು ಸತ್ತಮೇಲೆ ಆ ದೇಶವನ್ನು ಹದದನು ಆಳಿದನು. ಹದದನು ಪಾಗು ಎಂಬ ಪಟ್ಟಣದವನು. ಹದದನ ಹೆಂಡತಿಯ ಹೆಸರು ಮಹೇಟಬೇಲ್. ಮಹೇಟಬೇಲಳು ಮಟ್ರೇದ ಎಂಬಾಕೆಯ ಮಗಳು. (ಮಟ್ರೇದಳು ಮೇಜಾಹಾಬನ ಮಗಳು.) ");
INSERT INTO kan2010_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","ಏಸಾವನು ಎದೋಮ್ಯರಿಗೆ ಮೂಲಪಿತೃ: ತಿಮ್ನ ಅಲ್ವಾ, ಯತೇತ, ಓಹೊಲೀಬಾಮಾ, ಏಲಾ, ಪೀನೋನ್, ಕೆನೆಜ್, ತೇಮಾನ್, ಮಿಪ್ಚಾರ, ಮಗ್ದೀಯೇಲ್ ಮತ್ತು ಗೀರಾಮ್ ಕುಟುಂಬಗಳವರು ತಮ್ಮ ಕುಟುಂಬಗಳ ಹೆಸರುಗಳನ್ನು ಹೊಂದಿದ್ದ ಪ್ರದೇಶಗಳಲ್ಲಿ ವಾಸಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ಯಾಕೋಬನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ನೆಲೆಸಿದನು. ಅವನ ತಂದೆ ಆ ದೇಶದಲ್ಲೇ ವಾಸವಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ಯಾಕೋಬನ ಕುಟುಂಬದ ಚರಿತ್ರೆಯಿದು: ಯೋಸೇಫನು ಹದಿನೇಳು ವರ್ಷದ ಯೌವನಸ್ಥನಾಗಿದ್ದನು. ಆಡುಕುರಿಗಳನ್ನು ಸಾಕುವುದು ಅವನ ಕಸುಬಾಗಿತ್ತು. ತನ್ನ ಅಣ್ಣಂದಿರೊಡನೆ ಅಂದರೆ ಬಿಲ್ಹಾ ಮತ್ತು ಜಿಲ್ಪಾ ಎಂಬ ತನ್ನ ಮಲತಾಯಿಗಳ ಮಕ್ಕಳೊಡನೆ ಯೋಸೇಫನು ಆಡುಕುರಿಗಳನ್ನು ಮೇಯಿಸುತ್ತಿದ್ದನು. ಅವರೇನಾದರೂ ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡಿದರೆ ಯೋಸೇಫನು ತಂದೆಗೆ ತಿಳಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ಇಸ್ರೇಲನು ತುಂಬ ಮುಪ್ಪಿನವನಾಗಿದ್ದಾಗ ಯೋಸೇಫನು ಹುಟ್ಟಿದ್ದರಿಂದ ಇಸ್ರೇಲನು ತನ್ನ ಬೇರೆ ಗಂಡುಮಕ್ಕಳಿಗಿಂತಲೂ ಹೆಚ್ಚಾಗಿ ಯೋಸೇಫನನ್ನು ಪ್ರೀತಿಸಿದನು. ಯಾಕೋಬನು ತನ್ನ ಮಗನಿಗೆ ಸುಂದರವಾದ ನಿಲುವಂಗಿಯನ್ನು ಮಾಡಿಸಿ ಕೊಟ್ಟಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ತಮ್ಮ ತಂದೆಗೆ ಯೋಸೇಫನ ಮೇಲೆ ಹೆಚ್ಚು ಪ್ರೀತಿಯಿರುವುದನ್ನು ಗಮನಿಸಿದ ಯೋಸೇಫನ ಅಣ್ಣಂದಿರು ಯೋಸೇಫನನ್ನು ದ್ವೇಷಿಸತೊಡಗಿ ಅವನೊಡನೆ ಸ್ನೇಹಭಾವದಿಂದ ಮಾತಾಡುತ್ತಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ಒಂದು ದಿನ ಯೋಸೇಫನು ವಿಶೇಷವಾದ ಕನಸನ್ನು ಕಂಡನು. ಯೋಸೇಫನು ಈ ಕನಸನ್ನು ತನ್ನ ಅಣ್ಣಂದಿರಿಗೆ ತಿಳಿಸಿದಾಗ ಅವರು ಅವನನ್ನು ಮತ್ತಷ್ಟು ದ್ವೇಷಿಸತೊಡಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ಯೋಸೇಫನು ಅವರಿಗೆ, “ನನಗೆ ಒಂದು ಕನಸಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ನಾವೆಲ್ಲರು ಹೊಲದಲ್ಲಿ ಗೋಧಿಯ ಸಿವುಡುಗಳನ್ನು ಕಟ್ಟುತ್ತಿದ್ದೆವು. ಆಗ ನನ್ನ ಸಿವುಡು ಎದ್ದುನಿಂತಿತು; ನನ್ನ ಸಿವುಡಿನ ಸುತ್ತಲೂ ನಿಮ್ಮ ಸಿವುಡುಗಳೆಲ್ಲಾ ಎದ್ದುನಿಂತುಕೊಂಡು ನನ್ನ ಸಿವುಡಿಗೆ ಅಡ್ಡಬಿದ್ದವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ಅವನ ಅಣ್ಣಂದಿರು, “ನೀನು ರಾಜನಾಗಿ ನಮ್ಮನ್ನು ಆಳುವೆ ಎಂಬುದು ಇದರ ಅರ್ಥವೆಂದು ನಿನ್ನ ಆಲೋಚನೆಯೋ?” ಎಂದು ಪ್ರಶ್ನಿಸಿ ಆ ಕನಸಿನ ನಿಮಿತ್ತ ಅವನನ್ನು ಮತ್ತಷ್ಟು ದ್ವೇಷಿಸತೊಡಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ಆಮೇಲೆ ಯೋಸೇಫನಿಗೆ ಮತ್ತೊಂದು ಕನಸಾಯಿತು. ಯೋಸೇಫನು ಈ ಕನಸಿನ ಬಗ್ಗೆಯೂ ತನ್ನ ಅಣ್ಣಂದಿರಿಗೆ ತಿಳಿಸಿದನು. ಯೋಸೇಫನು ಅವರಿಗೆ, “ನನಗೆ ಮತ್ತೊಂದು ಕನಸಾಯಿತು. ಸೂರ್ಯ, ಚಂದ್ರ ಮತ್ತು ಹನ್ನೊಂದು ನಕ್ಷತ್ರಗಳು ನನಗೆ ಅಡ್ಡಬೀಳುವುದನ್ನು ಕಂಡೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೂ ಸಹ ಈ ಕನಸಿನ ಬಗ್ಗೆ ತಿಳಿಸಿದನು. ಆದರೆ ಅವನ ತಂದೆ ಅವನನ್ನು ಗದರಿಸಿ, “ಇದೆಂಥಾ ಕನಸು? ನಾನೂ ನಿನ್ನ ತಾಯಿಯೂ ಮತ್ತು ನಿನ್ನ ಸಹೋದರರೂ ನಿನಗೆ ಅಡ್ಡಬೀಳುತ್ತೇವೆಂದು ನಂಬುತ್ತೀಯೋ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ಯೋಸೇಫನ ಅಣ್ಣಂದಿರಿಗೆ ಅವನ ಮೇಲೆ ಹೊಟ್ಟೆಕಿಚ್ಚು ಹೆಚ್ಚಾಯಿತು. ಆದರೆ ಯೋಸೇಫನ ತಂದೆಯು ಆ ಕನಸುಗಳ ಬಗ್ಗೆ ಆಶ್ಚರ್ಯಚಕಿತನಾಗಿ ಆಲೋಚಿಸತೊಡಗಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ಒಂದು ದಿನ ಯೋಸೇಫನ ಅಣ್ಣಂದಿರು ತಮ್ಮ ತಂದೆಯ ಆಡುಕುರಿಗಳನ್ನು ಕಾಯಲು ಶೆಕೆಮಿಗೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ಇಸ್ರೇಲನು ಯೋಸೇಫನಿಗೆ, “ಶೆಕೆಮಿಗೆ ಹೋಗು. ನಿನ್ನ ಅಣ್ಣಂದಿರು ಅಲ್ಲಿ ನನ್ನ ಆಡುಕುರಿಗಳನ್ನು ಮೇಯಿಸುತ್ತಿದ್ದಾರೆ” ಎಂದು ಹೇಳಿದನು. ಯೋಸೇಫನು, “ಸರಿ, ಹೋಗುವೆನು” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ಇಸ್ರೇಲನು, “ನಿನ್ನ ಅಣ್ಣಂದಿರ ಮತ್ತು ಆಡುಕುರಿಗಳ ಕ್ಷೇಮವನ್ನು ವಿಚಾರಿಸಿಕೊಂಡು ಬಂದು ನನಗೆ ತಿಳಿಸು” ಎಂದು ಹೇಳಿ ಅವನನ್ನು ಹೆಬ್ರೋನಿನ ಕಣಿವೆಯಿಂದ ಶೆಕೆಮಿಗೆ ಕಳುಹಿಸಿಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ಶೆಕೆಮಿನಲ್ಲಿ ದಾರಿತಪ್ಪಿ ಯೋಸೇಫನು ಹೊಲಗಳಲ್ಲಿ ಅಲೆದಾಡುತ್ತಿರಲು ಅವನನ್ನು ಕಂಡ ಒಬ್ಬನು, “ಏನು ಹುಡುಕುತ್ತಿರುವೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ಯೋಸೇಫನು, “ನನ್ನ ಅಣ್ಣಂದಿರನ್ನು ಹುಡುಕುತ್ತಿದ್ದೇನೆ. ಅವರು ತಮ್ಮ ಆಡುಕುರಿಗಳನ್ನು ಎಲ್ಲಿ ಮೇಯಿಸುತ್ತಿದ್ದಾರೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ಅದಕ್ಕೆ ಅವನು, “ಅವರು ಇಲ್ಲಿಂದ ಹೊರಟುಹೋದರು. ದೋತಾನಿಗೆ ಹೋಗೋಣ ಎಂದು ಅವರು ಮಾತಾಡಿಕೊಳ್ಳುವುದನ್ನು ನಾನು ಕೇಳಿದೆ” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಯೋಸೇಫನು ಅವರನ್ನು ಹುಡುಕುತ್ತಾ ಹೋಗಿ ದೋತಾನಿನಲ್ಲಿ ಅವರನ್ನು ಕಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ಯೋಸೇಫನನ್ನು ಬಹುದೂರದಿಂದಲೇ ಕಂಡ ಅವನ ಅಣ್ಣಂದಿರು ಅವನನ್ನು ಕೊಲ್ಲಲು ಒಂದು ಉಪಾಯ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ಅವರು ಒಬ್ಬರಿಗೊಬ್ಬರು, “ಅಗೋ, ಅಲ್ಲಿ ಬರುತ್ತಿದ್ದಾನೆ ಕನಸುಗಾರನಾದ ಯೋಸೇಫ. ");
INSERT INTO kan2010_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ಅವನನ್ನು ಕೊಲ್ಲಲು ಇದೇ ತಕ್ಕ ಸಮಯ. ಅವನನ್ನು ಕೊಂದು ನೀರಿಲ್ಲದ ಬಾವಿಯೊಳಗೆ ದಬ್ಬಿ, ಕ್ರೂರ ಪ್ರಾಣಿಯೊಂದು ಅವನನ್ನು ತಿಂದುಬಿಟ್ಟಿತೆಂದು ನಮ್ಮ ತಂದೆಗೆ ಹೇಳೋಣ. ಆಗ ಅವನ ಕನಸುಗಳೆಲ್ಲ ಹೇಗೆ ನಿಜವಾಗುತ್ತವೊ ನೋಡೋಣ” ಎಂದು ಮಾತಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ಆದರೆ ರೂಬೇನನು ಅವರಿಗೆ, “ಅವನನ್ನು ಕೊಲ್ಲಬೇಡಿ; ");
INSERT INTO kan2010_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ಅರಣ್ಯದಲ್ಲಿರುವ ಬರಿದಾದ ಬಾವಿಗೆ ಅವನನ್ನು ನೂಕಿಬಿಡಿ; ಆದರೆ ಅವನಿಗೆ ನೋವು ಮಾಡಬೇಡಿ” ಎಂದು ಹೇಳಿದನು. ತರುವಾಯ ಯೋಸೇಫನನ್ನು ಬಾವಿಯಿಂದ ಮೇಲೆತ್ತಿ ತಂದೆಗೆ ಅವನನ್ನು ಒಪ್ಪಿಸಬೇಕೆಂಬುದೇ ರೂಬೇನನ ಅಪೇಕ್ಷೆಯಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ಯೋಸೇಫನು ಬಂದಾಗ ಅವನ ಅಣ್ಣಂದಿರು ಅವನನ್ನು ಹಿಡಿದು ಅವನ ನಿಲುವಂಗಿಯನ್ನು ಹರಿದುಹಾಕಿ ");
INSERT INTO kan2010_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ನೀರಿಲ್ಲದ ಒಂದು ಬಾವಿಯೊಳಗೆ ತಳ್ಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ಯೋಸೇಫನು ಬಾವಿಯೊಳಗಿದ್ದಾಗ, ಅವನ ಅಣ್ಣಂದಿರು ಊಟಕ್ಕೆ ಕುಳಿತುಕೊಂಡರು. ಅವರು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ ಗಿಲ್ಯಾದಿನಿಂದ ಈಜಿಪ್ಟಿಗೆ ಹೋಗುತ್ತಿದ್ದ ವ್ಯಾಪಾರಿಗಳನ್ನು ಕಂಡರು. ಅವರ ಒಂಟೆಗಳು ಅನೇಕ ಬಗೆಯ ಸಾಂಬಾರ ಪದಾರ್ಥಗಳನ್ನು ಮತ್ತು ಬೆಲೆಬಾಳುವ ವಸ್ತುಗಳನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗುತ್ತಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ಆದ್ದರಿಂದ ಯೆಹೂದನು ತನ್ನ ಸಹೋದರರಿಗೆ, “ನಾವು ನಮ್ಮ ತಮ್ಮನನ್ನು ಕೊಂದು ಅವನ ಮರಣವನ್ನು ಮರೆಮಾಡಿದರೆ ನಮಗಾಗುವ ಲಾಭವೇನು? ");
INSERT INTO kan2010_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ಈ ವ್ಯಾಪಾರಿಗಳಿಗೆ ನಾವು ಅವನನ್ನು ಮಾರಿದರೆ ನಮಗೆ ಹೆಚ್ಚು ಲಾಭವಾಗುವುದು; ಆಮೇಲೆ ನಮ್ಮ ತಮ್ಮನನ್ನು ಕೊಂದ ಅಪರಾಧವೂ ನಮ್ಮ ಮೇಲಿರುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ಅದಕ್ಕೆ ಉಳಿದ ಸಹೋದರರೆಲ್ಲ ಒಪ್ಪಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ಮಿದ್ಯಾನಿನ ವ್ಯಾಪಾರಿಗಳು ಸಮೀಪಿಸಿದಾಗ, ಅಣ್ಣಂದಿರು ಯೋಸೇಫನನ್ನು ಬಾವಿಯೊಳಗಿಂದ ಹೊರತೆಗೆದು ಇಪ್ಪತ್ತು ಬೆಳ್ಳಿಯ ನಾಣ್ಯಗಳಿಗೆ ಮಾರಿದರು. ವ್ಯಾಪಾರಿಗಳು ಯೋಸೇಫನನ್ನು ಈಜಿಪ್ಟಿಗೆ ಕೊಂಡೊಯ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ಆ ಸಮಯದಲ್ಲಿ ರೂಬೇನನು ತನ್ನ ಸಹೋದರರೊಡನೆ ಇರಲಿಲ್ಲ. ಅವರು ಯೋಸೇಫನನ್ನು ಮಾರಿದ್ದು ಅವನಿಗೆ ಗೊತ್ತಿರಲಿಲ್ಲ. ರೂಬೇನನು ಬಾವಿಗೆ ಹಿಂತಿರುಗಿ ಬಂದಾಗ, ಯೋಸೇಫನನ್ನು ಅಲ್ಲಿ ಕಾಣದೆ ದುಃಖದಿಂದ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ರೂಬೇನನು ತನ್ನ ಸಹೋದರರ ಬಳಿಗೆ ಹೋಗಿ, “ಹುಡುಗನು ಬಾವಿಯೊಳಗೆ ಇಲ್ಲ. ಈಗ ನಾನೇನು ಮಾಡಲಿ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ಬಳಿಕ ಅವರು ಒಂದು ಆಡನ್ನು ಕತ್ತರಿಸಿ ಆಡಿನ ರಕ್ತವನ್ನು ಯೋಸೇಫನ ಸುಂದರವಾದ ನಿಲುವಂಗಿಯ ಮೇಲೆ ಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ಬಳಿಕ ಆ ನಿಲುವಂಗಿಯನ್ನು ತಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ, “ನಾವು ಈ ನಿಲುವಂಗಿಯನ್ನು ಕಂಡೆವು. ಇದು ಯೋಸೇಫನ ನಿಲುವಂಗಿಯೋ?” ಎಂದು ಕೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ತಂದೆಯು ಆ ನಿಲುವಂಗಿಯನ್ನು ನೋಡಿ ಅದನ್ನು ಗುರುತಿಸಿ, “ಹೌದು, ಇದು ಯೋಸೇಫನದೇ. ಯಾವುದೋ ಕ್ರೂರ ಪ್ರಾಣಿಯ ಬಾಯಿಗೆ ತುತ್ತಾದನು” ಎಂದು ಹೇಳಿ ");
INSERT INTO kan2010_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ದುಃಖದಿಂದ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡು ಗೋಣಿತಟ್ಟನ್ನು ಸುತ್ತಿಕೊಂಡು ಬಹುದಿನಗಳವರೆಗೆ ದುಃಖಪಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ಯಾಕೋಬನ ಗಂಡುಮಕ್ಕಳು ಮತ್ತು ಹೆಣ್ಣುಮಕ್ಕಳು ಎಷ್ಟೇ ಸಂತೈಸಿದರೂ ಯಾಕೋಬನಿಗೆ ಆದರಣೆಯಾಗಲಿಲ್ಲ. ಯಾಕೋಬನು ಅವರಿಗೆ, “ನಾನು ಸಾಯುವ ತನಕ ನನ್ನ ಮಗನಿಗಾಗಿ ದುಃಖಪಡುವೆ” ಎಂದು ಹೇಳಿ ದುಃಖಿಸುತ್ತಲೇ ಇದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ಮಿದ್ಯಾನಿನ ವ್ಯಾಪಾರಿಗಳು ಯೋಸೇಫನನ್ನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಮಾರಿದರು. ಅವರು ಅವನನ್ನು ಫರೋಹನ ಕಾವಲುಗಾರರಿಗೆ ನಾಯಕನಾಗಿದ್ದ ಪೋಟೀಫರನಿಗೆ ಮಾರಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ಆ ಕಾಲದಲ್ಲಿ ಯೆಹೂದನು ತನ್ನ ಸಹೋದರರನ್ನು ಬಿಟ್ಟು ಹೀರಾ ಎಂಬುವನೊಂದಿಗೆ ವಾಸಿಸಲು ಹೋದನು. ಅವನು ಅದುಲ್ಲಾಮ್ ಊರಿನವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ಯೆಹೂದನು ಅಲ್ಲಿ ಒಬ್ಬ ಕಾನಾನ್ಯನ ಮಗಳನ್ನು ಕಂಡು ಆಕೆಯನ್ನು ಮದುವೆಮಾಡಿಕೊಂಡನು. ಆ ಹುಡುಗಿಯ ತಂದೆಯ ಹೆಸರು ಶೂಗ. ");
INSERT INTO kan2010_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ಆಕೆಯು ಒಬ್ಬ ಮಗನನ್ನು ಹೆತ್ತಳು. ಅವರು ಅವನಿಗೆ ಏರ ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ಬಳಿಕ ಆಕೆ ಮತ್ತೊಬ್ಬ ಮಗನಿಗೆ ಜನನವಿತ್ತಳು. ಅವರು ಆ ಮಗನಿಗೆ ಓನಾನ ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ಆಕೆಗೆ ಮೂರನೆಯ ಮಗನು ಹುಟ್ಟಿದಾಗ ಆಕೆ ಅದಕ್ಕೆ ಶೇಲಹ ಎಂದು ಹೆಸರಿಟ್ಟಳು. ಆ ಮಗು ಹುಟ್ಟಿದಾಗ ಯೆಹೂದನು ಕಜೀಬೂರಿನಲ್ಲಿ ವಾಸಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ಯೆಹೂದನು ತನ್ನ ಮೊದಲನೆ ಮಗನಾದ ಏರನಿಗಾಗಿ ಒಬ್ಬ ಕನ್ನಿಕೆಯನ್ನು ಆಯ್ಕೆಮಾಡಿದನು. ಆಕೆಯ ಹೆಸರು ತಾಮಾರ. ");
INSERT INTO kan2010_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ಆದರೆ ಏರನು ಅನೇಕ ಕೆಟ್ಟಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದ್ದರಿಂದ ಯೆಹೋವನು ಅವನನ್ನು ಸಾಯಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ಆಗ ಯೆಹೂದನು ಏರನ ತಮ್ಮನಾದ ಓನಾನನಿಗೆ, “ಹೋಗು, ಸತ್ತುಹೋದ ನಿನ್ನ ಅಣ್ಣನ ಹೆಂಡತಿಗೆ ಗಂಡನಂತಿರು. ನಿನ್ನ ಮೂಲಕ ಆಕೆಯಲ್ಲಿ ಹುಟ್ಟುವ ಮಕ್ಕಳು ನಿನ್ನ ಅಣ್ಣನಾದ ಏರನ ಮಕ್ಕಳಾಗಿರಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ತಾಮಾರಳಲ್ಲಿ ತನಗೆ ಹುಟ್ಟುವ ಮಕ್ಕಳು ತನ್ನವರಾಗುವುದಿಲ್ಲವೆಂದು ಅರಿತುಕೊಂಡು ಓನಾನನು ಆಕೆಯನ್ನು ಕೂಡಿದರೂ ವೀರ್ಯವನ್ನು ನೆಲದ ಪಾಲು ಮಾಡುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ಇದು ಯೆಹೋವನ ದೃಷ್ಟಿಯಲ್ಲಿ ಕೆಟ್ಟದ್ದಾಗಿದ್ದರಿಂದ ಆತನು ಓನಾನನನ್ನು ಸಹ ಸಾಯಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ಆಗ ಯೆಹೂದನು ತನ್ನ ಸೊಸೆಯಾದ ತಾಮಾರಳಿಗೆ, “ನಿನ್ನ ತಂದೆಯ ಮನೆಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಿ ಅಲ್ಲಿರು. ನನ್ನ ಮಗನಾದ ಶೇಲಹನು ದೊಡ್ಡವನಾಗುವ ತನಕ ಮದುವೆಯಾಗಬೇಡ” ಎಂದು ಹೇಳಿದನು. ಶೇಲಹನು ಸಹ ತನ್ನ ಅಣ್ಣಂದಿರಂತೆ ಸಾಯಬಹುದೆಂದು ಯೆಹೂದನು ಹೆದರಿಕೊಂಡಿದ್ದನು. ಆದ್ದರಿಂದ ತಾಮಾರಳು ತನ್ನ ತಂದೆಯ ಮನೆಗೆ ಹಿಂತಿರುಗಿ ಹೋದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ಆಮೇಲೆ ಬಹುದಿನಗಳಾದ ಮೇಲೆ ಯೆಹೂದನ ಹೆಂಡತಿಯಾಗಿದ್ದ ಶೂಗನ ಮಗಳು ತೀರಿಕೊಂಡಳು. ಯೆಹೂದನು ತನ್ನ ದುಃಖದ ಸಮಯ ತೀರಿದ ಮೇಲೆ ಅದುಲ್ಲಾಮ್ಯದವನಾದ ತನ್ನ ಸ್ನೇಹಿತ ಹೀರಾನೊಂದಿಗೆ ತನ್ನ ಕುರಿಗಳ ಉಣ್ಣೆ ಕತ್ತರಿಸುವುದಕ್ಕಾಗಿ ತಿಮ್ನಾ ಊರಿಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ಮಾವನು ಉಣ್ಣೆ ಕತ್ತರಿಸುವುದಕ್ಕಾಗಿ ತಿಮ್ನಾ ಊರಿಗೆ ಹೋಗುತ್ತಿರುವುದು ತಾಮಾರಳಿಗೆ ತಿಳಿಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ತಾಮಾರಳು ಯಾವಾಗಲೂ ವಿಧವೆಯ ವಸ್ತ್ರಗಳನ್ನು ಧರಿಸಿಕೊಂಡಿರುತ್ತಿದ್ದಳು. ಆದರೆ ಈಗ ಆಕೆ ಬೇರೆ ಬಟ್ಟೆಗಳನ್ನು ಧರಿಸಿಕೊಂಡು ತನ್ನ ಮುಖವನ್ನು ಮುಸುಕಿನಿಂದ ಮುಚ್ಚಿಕೊಂಡು ತಿಮ್ನಾ ಊರಿನ ಸಮೀಪದಲ್ಲಿರುವ ಏನಯಿಮೂರಿನ ದಾರಿಯಲ್ಲಿ ಕುಳಿತುಕೊಂಡಳು. ಯೆಹೂದನ ಚಿಕ್ಕಮಗನಾದ ಶೇಲಹನು ಬೆಳೆದು ದೊಡ್ಡವನಾಗಿರುವುದು ತಾಮಾರಳಿಗೆ ತಿಳಿದಿತ್ತು. ಆದರೆ ಆಕೆಗೆ ಅವನನ್ನು ಮದುವೆ ಮಾಡಿಸಲು ಯೆಹೂದನು ಆಲೋಚಿಸಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ಯೆಹೂದನು ಆ ದಾರಿಯಲ್ಲಿ ಪ್ರಯಾಣ ಮಾಡುತ್ತಿರಲು ಆಕೆಯನ್ನು ಕಂಡು ವೇಶ್ಯೆಯೆಂದು ಭಾವಿಸಿದನು. (ಆಕೆಯು ವೇಶ್ಯೆಯಂತೆ ಮುಸುಕು ಹಾಕಿಕೊಂಡಿದ್ದಳು.) ");
INSERT INTO kan2010_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ಆದ್ದರಿಂದ ಯೆಹೂದನು ಆಕೆಯ ಬಳಿಗೆ ಹೋಗಿ, “ನಾನು ನಿನ್ನನ್ನು ಕೂಡಬಹುದೇ?” ಎಂದು ಕೇಳಿದನು. (ಆಕೆ ತನ್ನ ಸೊಸೆಯಾದ ತಾಮಾರಳೆಂದು ಯೆಹೂದನಿಗೆ ತಿಳಿದಿರಲಿಲ್ಲ.) ಅವಳು “ನೀನು ನನಗೆ ಏನು ಕೊಡುವೆ?” ಎಂದು ಕೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ಯೆಹೂದನು, “ನನ್ನ ಮಂದೆಯಿಂದ ನಿನಗೆ ಒಂದು ಆಡುಮರಿಯನ್ನು ಕಳುಹಿಸಿಕೊಡುವೆ” ಎಂದು ಉತ್ತರಿಸಿದನು. ಅವಳು “ಸರಿ, ನೀನು ನನಗೆ ಆಡುಮರಿಯನ್ನು ಕಳುಹಿಸಿ ಕೊಡುವ ತನಕ ನನ್ನಲ್ಲಿ ಏನಾದರೂ ಒತ್ತೆಯಿಡಬೇಕು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ಯೆಹೂದನು, “ಏನು ಒತ್ತೆಯಿಡಲಿ?” ಎಂದು ಕೇಳಿದನು. ತಾಮಾರಳು, “ನಿನ್ನ ಪತ್ರಗಳ ಮೇಲೆ ಉಪಯೋಗಿಸುವ ನಿನ್ನ ಮುದ್ರೆಯನ್ನೂ ಅದರ ದಾರವನ್ನೂ ಮತ್ತು ನಿನ್ನ ಊರುಗೋಲನ್ನೂ ಕೊಡು” ಎಂದು ಉತ್ತರಿಸಿದಳು. ಯೆಹೂದನು ಅವುಗಳನ್ನು ಆಕೆಗೆ ಕೊಟ್ಟನು. ಯೆಹೂದನು ಆಕೆಯನ್ನು ಕೂಡಿದನು; ಅವಳು ಗರ್ಭಿಣಿಯಾದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ತಾಮಾರಳು ಮನೆಗೆ ಹೋಗಿ ಮುಸುಕನ್ನು ತೆಗೆದುಹಾಕಿ ಮತ್ತೆ ವಿಧವಾವಸ್ತ್ರಗಳನ್ನು ಧರಿಸಿಕೊಂಡಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ಯೆಹೂದನು ಮಾತು ಕೊಟ್ಟಿದ್ದಂತೆಯೇ ಒಂದು ಆಡುಮರಿಯನ್ನು ತನ್ನ ಸ್ನೇಹಿತನಾದ ಹೀರಾನ ಮೂಲಕ ಏನಯಿಮಿಗೆ ಕಳುಹಿಸಿ ಆ ಮುದ್ರೆಯನ್ನೂ ಊರುಗೋಲನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬರುವಂತೆ ಅವನಿಗೆ ತಿಳಿಸಿದನು. ಆದರೆ ಅವನು ಅವಳನ್ನು ಕಂಡುಹಿಡಿಯಲಾಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ಅವನು ಏನಯಿಮ್ ಊರಿನ ಕೆಲವು ಗಂಡಸರಿಗೆ, “ಇಲ್ಲಿಯ ದಾರಿಯ ಸಮೀಪದಲ್ಲಿರುತ್ತಿದ್ದ ವೇಶ್ಯೆಯು ಎಲ್ಲಿದ್ದಾಳೆ?” ಎಂದು ಕೇಳಿದನು. ಅದಕ್ಕೆ ಅವರು, “ಇಲ್ಲಿ ಯಾವ ವೇಶ್ಯೆಯೂ ಇಲ್ಲ” ಎಂದು ಉತ್ತರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ಆದ್ದರಿಂದ ಅವನು ಯೆಹೂದನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಂದು, “ನಾನು ಆ ವೇಶ್ಯೆಯನ್ನು ಕಂಡುಹಿಡಿಯಲಾಗಲಿಲ್ಲ. ಅದಲ್ಲದೆ ಆ ಸ್ಥಳದ ಗಂಡಸರು ಅಲ್ಲಿ ಒಬ್ಬ ವೇಶ್ಯೆಯೂ ಇಲ್ಲ ಎಂದು ಹೇಳಿದರು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ಅದಕ್ಕೆ ಯೆಹೂದನು, “ಆಕೆ ಆ ವಸ್ತುಗಳನ್ನು ಇಟ್ಟುಕೊಳ್ಳಲಿ. ಜನರು ನಮ್ಮನ್ನು ಕಂಡು ನಗುವುದು ನನಗೆ ಇಷ್ಟವಿಲ್ಲ. ನಾನು ಅವಳಿಗೆ ಆಡನ್ನು ಕೊಡಲು ಪ್ರಯತ್ನಿಸಿದೆ. ಆದರೆ ಅವಳು ನಿನಗೆ ಸಿಕ್ಕಲಿಲ್ಲವಷ್ಟೇ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ಮೂರು ತಿಂಗಳಾದ ಬಳಿಕ, ಯಾರೋ ಒಬ್ಬನು ಯೆಹೂದನಿಗೆ, “ನಿನ್ನ ಸೊಸೆಯಾದ ತಾಮಾರಳು ವ್ಯಭಿಚಾರದಿಂದ ಗರ್ಭಿಣಿಯಾಗಿದ್ದಾಳೆ” ಎಂದು ತಿಳಿಸಿದನು. ಆಗ ಯೆಹೂದನು, “ಆಕೆಯನ್ನು ಎಳೆದುಕೊಂಡು ಹೋಗಿ ಸುಟ್ಟುಬಿಡಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ಆ ಗಂಡಸರು ತಾಮಾರಳನ್ನು ಕೊಲ್ಲಲು ಆಕೆಯ ಬಳಿಗೆ ಹೋದರು. ಆದರೆ ಆಕೆ ತನ್ನ ಮಾವನಿಗೆ, “ನನ್ನನ್ನು ಗರ್ಭಿಣಿ ಮಾಡಿದವನು ಈ ವಸ್ತುಗಳ ಒಡೆಯ. ಈ ವಸ್ತುಗಳನ್ನು ನೋಡು! ಇವು ಯಾರವು? ಈ ಮುದ್ರೆಯೂ ದಾರವೂ ಯಾರವು? ಇದು ಯಾರ ಕೈಕೋಲು?” ಎಂಬ ಸಂದೇಶವನ್ನು ಹೇಳಿ ಕಳುಹಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ಯೆಹೂದನು ಆ ವಸ್ತುಗಳನ್ನು ಗುರುತಿಸಿ, “ಆಕೆ ಸರಿಯಾದದ್ದನ್ನೇ ಮಾಡಿದ್ದಾಳೆ. ನಾನೇ ತಪ್ಪು ಮಾಡಿದೆ. ನಾನು ಆಕೆಗೆ ಮಾತುಕೊಟ್ಟಂತೆ ನನ್ನ ಮಗನಾದ ಶೇಲಹನನ್ನು ಆಕೆಗೆ ಕೊಡಬೇಕಿತ್ತು” ಎಂದು ಹೇಳಿದನು. ಆದರೆ ಯೆಹೂದನು ಆಕೆಯೊಡನೆ ಮತ್ತೆ ಮಲಗಿಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ತಾಮಾರಳಿಗೆ ಹೆರಿಗೆಕಾಲ ಬಂತು. ಆಕೆಗೆ ಅವಳಿಜವಳಿ ಮಕ್ಕಳಾಗುವುದನ್ನು ದಾದಿಯು ಗಮನಿಸಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ಆಕೆಗೆ ಹೆರಿಗೆಯಾಗುವಾಗ ಒಂದು ಮಗು ತನ್ನ ಕೈಚಾಚಿತು. ದಾದಿಯು ಆ ಮಗುವಿನ ಕೈಗೆ ಕೆಂಪುದಾರವನ್ನು ಕಟ್ಟಿ, “ಮೊದಲನೆಯವನು” ಅಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ಆದರೆ ಆ ಮಗು ತನ್ನ ಕೈಯನ್ನು ಹಿಂದಕ್ಕೆ ಎಳೆದುಕೊಂಡಿತು. ಆಮೇಲೆ ಮತ್ತೊಂದು ಮಗುವು ಮೊದಲು ಹುಟ್ಟಿತು. ಆದ್ದರಿಂದ ದಾದಿಯು, “ನೀನು ಮೊದಲನೆಯವನನ್ನು ಛೇದಿಸಿಕೊಂಡು ಬಂದೆ” ಅಂದಳು. ಆದ್ದರಿಂದ ಅವರು ಆ ಮಗುವಿಗೆ “ಪೆರೆಚ್” ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ಆ ಬಳಿಕ ಮತ್ತೊಂದು ಮಗುವು ಹೊರಬಂದಿತು. ಆ ಮಗುವಿನ ಕೈಯಲ್ಲಿ ಕೆಂಪುದಾರವಿತ್ತು. ಅವರು ಅವನಿಗೆ “ಜೆರಹ” ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ಯೋಸೇಫನನ್ನು ಖರೀದಿಮಾಡಿದ ವ್ಯಾಪಾರಿಗಳು ಅವನನ್ನು ಈಜಿಪ್ಟಿಗೆ ತೆಗೆದುಕೊಂಡು ಬಂದು ಫರೋಹನ ಕಾವಲುಗಾರರ ನಾಯಕನಾದ ಪೋಟೀಫರನಿಗೆ ಮಾರಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ಆದರೆ ಯೆಹೋವನ ಸಹಾಯದಿಂದ ಯೋಸೇಫನು ಏಳಿಗೆಯಾಗಿ ತನ್ನ ಯಜಮಾನನಾದ ಈಜಿಪ್ಟಿನ ಪೋಟೀಫರನ ಮನೆಯಲ್ಲಿ ಸೇವಕನಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ಯೆಹೋವನು ಯೋಸೇಫನ ಸಂಗಡವಿದ್ದು ಅವನನ್ನು ಎಲ್ಲಾ ಕೆಲಸಕಾರ್ಯಗಳಲ್ಲಿ ಯಶಸ್ವಿಯಾಗುವಂತೆ ಮಾಡುತ್ತಿರುವುದನ್ನು ಪೋಟೀಫರನು ಗಮನಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ಪೋಟೀಫರನು ಯೋಸೇಫನ ವಿಷಯದಲ್ಲಿ ತುಂಬ ಸಂತೋಷಪಟ್ಟು ಸ್ವಂತ ಸೇವಕನನ್ನಾಗಿ ಮಾಡಿಕೊಂಡನು; ಅಲ್ಲದೆ ಮನೆಯ ಮೇಲ್ವಿಚಾರಣೆಯನ್ನು ಒಪ್ಪಿಸಿಕೊಟ್ಟನು; ತನ್ನ ಆಸ್ತಿಗೆಲ್ಲಾ ಮೇಲಾಧಿಕಾರಿಯನ್ನಾಗಿ ನೇಮಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ಪೋಟೀಫರನು ಯೋಸೇಫನಿಗೆ ಮನೆಯ ಮೇಲ್ವಿಚಾರಣೆಯನ್ನು ಕೊಟ್ಟು ಆಸ್ತಿಗೆ ಅವನನ್ನು ಜವಾಬ್ದಾರನನ್ನಾಗಿ ಮಾಡಿದ ಮೇಲೆ ಯೆಹೋವನು ಪೋಟೀಫರನ ಮನೆಯನ್ನೂ ಬೆಳೆಗಳನ್ನೂ ಆಸ್ತಿಯನ್ನೂ ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ಆದ್ದರಿಂದ ಪೋಟೀಫರನು ತಾನು ಊಟಮಾಡುವ ಆಹಾರವೊಂದನ್ನು ಬಿಟ್ಟು ಉಳಿದೆಲ್ಲದರ ಜವಾಬ್ದಾರಿಯನ್ನು ಯೋಸೇಫನಿಗೆ ವಹಿಸಿ ನಿಶ್ಚಿಂತೆಯಿಂದ ಇದ್ದನು. ಯೋಸೇಫನು ನೋಡಲು ಸುಂದರನಾಗಿಯೂ ರೂಪವಂತನಾಗಿಯೂ ಇದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ಸ್ವಲ್ಪ ಕಾಲದನಂತರ, ಯೋಸೇಫನ ಒಡೆಯನ ಹೆಂಡತಿಯು ಯೋಸೇಫನ ಮೇಲೆ ಆಸೆಪಟ್ಟಳು. ಒಂದು ದಿನ ಆಕೆ ಅವನಿಗೆ, “ನನ್ನೊಂದಿಗೆ ಮಲಗಿಕೊ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ಆದರೆ ಯೋಸೇಫನು ತಿರಸ್ಕರಿಸಿದನು. ಅವನು, “ನನ್ನ ಧಣಿಯು ಈ ಮನೆಯ ಜವಾಬ್ದಾರಿಕೆಗಳನ್ನೆಲ್ಲಾ ನನಗೆ ವಹಿಸಿ ನಿಶ್ಚಿಂತೆಯಿಂದಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ನನ್ನ ಧಣಿಯು ಈ ಮನೆಯ ಸರ್ವಾಧಿಕಾರವನ್ನು ನನಗೆ ಕೊಟ್ಟಿದ್ದರೂ ತನ್ನ ಧರ್ಮಪತ್ನಿಯಾದ ನಿನ್ನನ್ನು ನನಗೆ ಅಧೀನಪಡಿಸಿಲ್ಲ. ಹೀಗಿರಲು ಇಂಥಾ ಮಹಾ ದುಷ್ಕೃತ್ಯವನ್ನು ನಡೆಸಿ ದೇವರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಹೇಗೆ ಪಾಪಮಾಡಲಿ” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ಆ ಸ್ತ್ರೀಯು ಪ್ರತಿದಿನವೂ ಯೋಸೇಫನನ್ನು ಒತ್ತಾಯಿಸಿದಳು. ಆದರೆ ಯೋಸೇಫನು ಆಕೆಯೊಂದಿಗೆ ಮಲಗಿಕೊಳ್ಳಲು ಒಪ್ಪಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ಒಂದು ದಿನ ಯೋಸೇಫನು ತನ್ನ ಕೆಲಸದ ನಿಮಿತ್ತ ಮನೆಯೊಳಗೆ ಹೋದನು. ಆಗ ಮನೆಯಲ್ಲಿ ಇದ್ದವನು ಅವನೊಬ್ಬನೇ. ");
INSERT INTO kan2010_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ಅವನ ಧಣಿಯ ಹೆಂಡತಿಯು ಅವನ ಮೇಲಂಗಿಯನ್ನು ಹಿಡಿದುಕೊಂಡು, “ಬಾ ನನ್ನೊಂದಿಗೆ ಮಲಗಿಕೊ” ಎಂದು ಕರೆದಳು. ಕೂಡಲೇ ಯೋಸೇಫನು ತನ್ನ ಮೇಲಂಗಿಯನ್ನೇ ಬಿಟ್ಟು ಅಲ್ಲಿಂದ ಓಡಿಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ಯೋಸೇಫನು ತನ್ನ ಮೇಲಂಗಿಯನ್ನು ಬಿಟ್ಟು ಓಡಿಹೋದದ್ದರಿಂದ ಸಿಟ್ಟುಗೊಂಡ ಅವಳು ");
INSERT INTO kan2010_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ಮನೆಯ ಹೊರಗಿದ್ದ ಸೇವಕರನ್ನು ಕರೆದು, “ನೋಡಿ, ನಮಗೆ ಅವಮಾನ ಮಾಡುವುದಕ್ಕಾಗಿ ಈ ಇಬ್ರಿಯ ಗುಲಾಮನನ್ನು ಇಲ್ಲಿಗೆ ತರಲಾಗಿದೆ. ಅವನು ಮನೆಯೊಳಗೆ ಬಂದು ನನ್ನ ಮೇಲೆ ಬಲಾತ್ಕಾರ ಮಾಡಲು ಪ್ರಯತ್ನಿಸಿದ. ಆಗ ನಾನು ಗಟ್ಟಿಯಾಗಿ ಕೂಗಿಕೊಂಡೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ನನ್ನ ಕೂಗಿನಿಂದ ಭಯಗೊಂಡು ತನ್ನ ಮೇಲಂಗಿಯನ್ನೇ ಬಿಟ್ಟು ಓಡಿಹೋದ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ಆಕೆ ಆ ಮೇಲಂಗಿಯನ್ನು ತನ್ನ ಗಂಡನೂ ಯೋಸೇಫನಿಗೆ ಧಣಿಯೂ ಆಗಿದ್ದ ಪೋಟೀಫರನು ಬರುವ ತನಕ ಇಟ್ಟುಕೊಂಡಿದ್ದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ಪತಿಯು ಬಂದಾಗ ಆಕೆ ಅದೇ ರೀತಿ ಹೇಳಿ, “ನೀನು ಸೇರಿಸಿಕೊಂಡ ಈ ಇಬ್ರಿಯ ಗುಲಾಮನು ನನ್ನ ಮೇಲೆ ಬಲಾತ್ಕಾರ ಮಾಡಲು ಪ್ರಯತ್ನಿಸಿದ. ");
INSERT INTO kan2010_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ಆದರೆ ನಾನು ಕೂಗಿಕೊಂಡದ್ದರಿಂದ ಅವನು ಮೇಲಂಗಿಯನ್ನೇ ಬಿಟ್ಟು ಓಡಿಹೋದ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ಯೋಸೇಫನ ಧಣಿಯು ತನ್ನ ಹೆಂಡತಿಯ ಮಾತು ಕೇಳಿ ತುಂಬ ಕೋಪಗೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ರಾಜನ ವೈರಿಗಳನ್ನು ಹಾಕುವ ಒಂದು ಸೆರೆಮನೆಯಿತ್ತು. ಆದ್ದರಿಂದ ಪೋಟೀಫರನು ಯೋಸೇಫನನ್ನು ಆ ಸೆರೆಮನೆಗೆ ಹಾಕಿಸಿದನು. ಅಂದಿನಿಂದ ಯೋಸೇಫನು ಅಲ್ಲಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ಆದರೆ ಯೆಹೋವನು ಯೋಸೇಫನ ಸಂಗಡವಿದ್ದು ಕರುಣೆತೋರಿದನು. ಸ್ವಲ್ಪಕಾಲವಾದ ಮೇಲೆ ಸೆರೆಮನೆಯ ಮುಖ್ಯಾಧಿಕಾರಿಯು ಯೋಸೇಫನನ್ನು ಪ್ರೀತಿಸತೊಡಗಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ಅವನು ಎಲ್ಲಾ ಕೈದಿಗಳನ್ನು ಯೋಸೇಫನ ವಶಕ್ಕೆ ಒಪ್ಪಿಸಿದನು. ಅಲ್ಲಿ ಮಾಡಬೇಕಾದದ್ದನ್ನೆಲ್ಲಾ ಯೋಸೇಫನೇ ಮಾಡಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ಯೆಹೋವನು ಯೋಸೇಫನ ಸಂಗಡವಿದ್ದು ಅವನ ಎಲ್ಲಾ ಕೆಲಸಕಾರ್ಯಗಳನ್ನು ಯಶಸ್ವಿಗೊಳಿಸುತ್ತಿದ್ದದ್ದರಿಂದ ಮುಖ್ಯಾಧಿಕಾರಿಯು ಎಲ್ಲಾ ವಿಷಯಗಳನ್ನು ಯೋಸೇಫನಿಗೆ ವಹಿಸಿ ನಿಶ್ಚಿಂತೆಯಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ತರುವಾಯ ಫರೋಹನ ಇಬ್ಬರು ಸೇವಕರು ಫರೋಹನಿಗೆ ಯಾವುದೋ ತಪ್ಪುಮಾಡಿದರು. ಈ ಇಬ್ಬರು ಸೇವಕರುಗಳಲ್ಲಿ ಒಬ್ಬನು ಭಕ್ಷ್ಯಗಾರ ಮತ್ತೊಬ್ಬನು ಪಾನದಾಯಕ. ");
INSERT INTO kan2010_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ಫರೋಹನು ತನ್ನ ಭಕ್ಷ್ಯಗಾರನ ಮೇಲೆಯೂ ಪಾನದಾಯಕನ ಮೇಲೆಯೂ ಕೋಪಗೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ಆದ್ದರಿಂದ ಅವರನ್ನು ಯೋಸೇಫನಿದ್ದ ಸೆರೆಮನೆಗೆ ಹಾಕಿಸಿದನು. ಪೋಟೀಫರನು ಫರೋಹನ ಕಾವಲುಗಾರ ಅಧಿಕಾರಿಯಾಗಿದ್ದು ಈ ಸೆರೆಮನೆಯ ಜವಾಬ್ದಾರಿಯನ್ನು ಹೊಂದಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ಸೆರೆಮನೆಯ ಮುಖ್ಯಾಧಿಕಾರಿಯು ಈ ಇಬ್ಬರು ಕೈದಿಗಳನ್ನು ಯೋಸೇಫನ ವಶಕ್ಕೆ ಒಪ್ಪಿಸಿದನು. ಸ್ವಲ್ಪಕಾಲದವರೆಗೆ ಆ ಇಬ್ಬರು ಸೆರೆಮನೆಯೊಳಗೆ ಇದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ಒಂದು ರಾತ್ರಿ ಆ ಇಬ್ಬರು ಕೈದಿಗಳಿಗೆ ಅಂದರೆ ಭಕ್ಷ್ಯಗಾರನಿಗೂ ಪಾನದಾಯಕನಿಗೂ ಒಂದೊಂದು ಕನಸು ಬಿತ್ತು. ಮತ್ತು ಅವರಿಬ್ಬರ ಕನಸುಗಳು ತಮ್ಮದೇ ಆದ ಅರ್ಥವನ್ನು ಹೊಂದಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ಮರುದಿನ ಮುಂಜಾನೆ ಯೋಸೇಫನು ಅವರ ಬಳಿಗೆ ಹೋದನು. ಅವರಿಬ್ಬರು ಚಿಂತೆಯಿಂದ ಇರುವುದನ್ನು ಯೋಸೇಫನು ಕಂಡು, ");
INSERT INTO kan2010_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","“ಈ ದಿನ ನೀವು ತುಂಬ ಚಿಂತೆಯಿಂದ ಇರುವಂತೆ ಕಾಣುತ್ತಿದೆ, ಕಾರಣವೇನು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ಆ ಇಬ್ಬರು, “ನಾವು ಕಳೆದ ರಾತ್ರಿ ಕನಸನ್ನು ಕಂಡೆವು; ಆದರೆ ನಾವು ಕಂಡ ಕನಸು ನಮಗೆ ಅರ್ಥವಾಗುತ್ತಿಲ್ಲ. ನಮಗೆ ಕನಸುಗಳ ಅರ್ಥವನ್ನು ತಿಳಿಸುವವರಾಗಲಿ ವಿವರಿಸುವವರಾಗಲಿ ಯಾರೂ ಇಲ್ಲ” ಎಂದು ಹೇಳಿದರು. ಯೋಸೇಫನು ಅವರಿಗೆ, “ದೇವರೊಬ್ಬನು ಮಾತ್ರ ಕನಸುಗಳನ್ನು ಅರ್ಥಮಾಡಿಕೊಳ್ಳಬಲ್ಲನು ಮತ್ತು ಕನಸುಗಳ ಅರ್ಥವನ್ನು ಹೇಳಬಲ್ಲನು. ಆದ್ದರಿಂದ ದಯಮಾಡಿ ನಿಮ್ಮ ಕನಸುಗಳನ್ನು ನನಗೆ ತಿಳಿಸಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ಆಗ ಪಾನದಾಯಕನು ಯೋಸೇಫನಿಗೆ, “ನಾನು ಕನಸಿನಲ್ಲಿ ದ್ರಾಕ್ಷಾಲತೆಯನ್ನು ಕಂಡೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ಆ ದ್ರಾಕ್ಷಾಲತೆಯ ಮೇಲೆ ಮೂರು ಕವಲುಗಳಿದ್ದವು. ಆ ಕವಲುಗಳು ಚಿಗುರುತ್ತಲೇ ಹೂವುಗಳನ್ನು ಬಿಟ್ಟವು; ಆ ಹೂವುಗಳು ಹಣ್ಣುಗಳಾದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ನಾನು ಫರೋಹನ ಲೋಟವನ್ನು ಹಿಡಿದುಕೊಂಡಿದ್ದರಿಂದ ದ್ರಾಕ್ಷಿಹಣ್ಣುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಲೋಟದೊಳಗೆ ರಸಹಿಂಡಿ ಲೋಟವನ್ನು ಫರೋಹನಿಗೆ ಕೊಟ್ಟೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ಅದಕ್ಕೆ ಯೋಸೇಫನು, “ನಾನು ಕನಸಿನ ಅರ್ಥವನ್ನು ನಿನಗೆ ತಿಳಿಸುವೆನು. ಆ ಮೂರು ಕವಲುಗಳು ಎಂದರೆ ಮೂರು ದಿನಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ಮೂರುದಿನಗಳೊಳಗಾಗಿ ಫರೋಹನು ನಿನ್ನನ್ನು ಕ್ಷಮಿಸಿ ಮತ್ತೆ ಕೆಲಸಕ್ಕೆ ಸೇರಿಸಿಕೊಳ್ಳುವನು. ನೀನು ಮೊದಲಿನಂತೆ ಅವನಿಗೆ ಪಾನದಾಯಕನಾಗಿರುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ಆದರೆ ನೀನು ಸುಖದಿಂದಿರುವಾಗ ನನ್ನನ್ನು ನೆನಸಿಕೊಂಡು ನನ್ನ ವಿಷಯವಾಗಿ ಫರೋಹನಿಗೆ ತಿಳಿಸಿ ನನಗೆ ಸೆರೆಮನೆಯಿಂದ ಬಿಡುಗಡೆಯಾಗುವಂತೆ ಮಾಡು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ಇಬ್ರಿಯರ ದೇಶದವನಾದ ನನ್ನನ್ನು ಕೆಲವರು ಅಪಹರಿಸಿಕೊಂಡು ಬಂದರು. ಆದರೆ ಇಲ್ಲಿಯೂ ನಾನು ಯಾವ ತಪ್ಪನ್ನೂ ಮಾಡಲಿಲ್ಲ. ಆದ್ದರಿಂದ ನಾನು ಸೆರೆಮನೆಯಲ್ಲಿರಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ಪಾನದಾಯಕನ ಕನಸಿನ ಅರ್ಥವು ಒಳ್ಳೆಯದಾಗಿರುವುದನ್ನು ಕಂಡ ಭಕ್ಷ್ಯಗಾರನು ಯೋಸೇಫನಿಗೆ, “ನನಗೂ ಒಂದು ಕನಸಾಯಿತು. ನನ್ನ ಕನಸಿನಲ್ಲಿ ನನ್ನ ತಲೆಯ ಮೇಲೆ ಮೂರು ಬುಟ್ಟಿಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ಅವುಗಳಲ್ಲಿ ರಾಜನಿಗೋಸ್ಕರವಾಗಿ ಎಲ್ಲಾ ಬಗೆಯ ಭಕ್ಷ್ಯಗಳಿದ್ದವು. ಆದರೆ ಪಕ್ಷಿಗಳು ಆ ಆಹಾರವನ್ನು ತಿನ್ನುತ್ತಿದ್ದವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ಯೋಸೇಫನು, “ಕನಸಿನ ಅರ್ಥವನ್ನು ನಾನು ನಿನಗೆ ತಿಳಿಸುತ್ತೇನೆ. ಮೂರು ಬುಟ್ಟಿಗಳ ಅರ್ಥ ಮೂರು ದಿನಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ಮೂರುದಿನಗಳೊಳಗಾಗಿ ರಾಜನು ನಿನ್ನನ್ನು ಸೆರೆಮನೆಯಿಂದ ಬಿಡಿಸಿ ನಿನ್ನ ಶಿರಚ್ಛೇದನ ಮಾಡಿಸುವನು; ನಿನ್ನ ದೇಹವನ್ನು ಕಂಬಕ್ಕೆ ನೇತುಹಾಕಿಸುವನು; ಪಕ್ಷಿಗಳು ನಿನ್ನ ದೇಹವನ್ನು ತಿಂದುಬಿಡುತ್ತವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ಮೂರನೆಯ ದಿನ ಬಂದಿತು. ಅದು ಫರೋಹನ ಜನ್ಮದಿನವಾಗಿತ್ತು. ಫರೋಹನು ತನ್ನ ಎಲ್ಲಾ ಸೇವಕರಿಗೆ ಔತಣಕೂಟವನ್ನು ಏರ್ಪಡಿಸಿದನು. ಔತಣಕೂಟದಲ್ಲಿ ಫರೋಹನು ಭಕ್ಷ್ಯಗಾರನನ್ನೂ ಮತ್ತು ಪಾನದಾಯಕನನ್ನೂ ಸೆರೆಮನೆಯಿಂದ ಬಿಡುಗಡೆ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ಫರೋಹನು ಪಾನದಾಯಕನನ್ನು ಮತ್ತೆ ಅದೇ ಕೆಲಸಕ್ಕೆ ನೇಮಿಸಿದನು; ಅವನು ಪಾನಪಾತ್ರೆಯನ್ನು ಫರೋಹನ ಕೈಗೆ ಕೊಡುವವನಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ಆದರೆ ಫರೋಹನು ಭಕ್ಷ್ಯಗಾರನನ್ನು ಕೊಲ್ಲಿಸಿದನು. ಯೋಸೇಫನು ಹೇಳಿದಂತೆಯೇ ಪ್ರತಿಯೊಂದು ನಡೆಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ಆದರೆ ಪಾನದಾಯಕನು ಯೋಸೇಫನಿಗೆ ಸಹಾಯ ಮಾಡಬೇಕೆಂಬುದನ್ನು ಮರೆತುಬಿಟ್ಟು ಯೋಸೇಫನ ಬಗ್ಗೆ ಫರೋಹನಿಗೆ ಏನೂ ತಿಳಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ಎರಡು ವರ್ಷಗಳ ನಂತರ ಫರೋಹನಿಗೆ ಒಂದು ಕನಸಾಯಿತು. ಫರೋಹನು ಕನಸಿನಲ್ಲಿ ನೈಲ್ ನದಿಯ ತೀರದಲ್ಲಿ ನಿಂತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ಆಗ ಕೊಬ್ಬಿದ ಮತ್ತು ಲಕ್ಷಣವಾಗಿದ್ದ ಏಳು ಹಸುಗಳು ನದಿಯೊಳಗಿಂದ ಬಂದು ಹುಲ್ಲನ್ನು ಮೇಯುತ್ತಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ಬಳಿಕ ಬಡಕಲಾಗಿದ್ದ ಮತ್ತು ಕುರೂಪವಾಗಿದ್ದ ಏಳು ಹಸುಗಳು ನದಿಯೊಳಗಿಂದ ಬಂದು ಲಕ್ಷಣವಾಗಿದ್ದ ಏಳು ಹಸುಗಳ ಪಕ್ಕದಲ್ಲಿ ನಿಂತುಕೊಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ಕುರೂಪವಾಗಿದ್ದ ಏಳು ಹಸುಗಳು ಲಕ್ಷಣವಾಗಿದ್ದ ಏಳು ಹಸುಗಳನ್ನು ತಿಂದುಬಿಟ್ಟವು. ಆಗ ಫರೋಹನಿಗೆ ಎಚ್ಚರವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ಫರೋಹನು ಮತ್ತೆ ಮಲಗಿಕೊಂಡನು. ಅವನಿಗೆ ಎರಡನೆಯ ಕನಸಾಯಿತು. ಪುಷ್ಟಿಯುಳ್ಳ ಏಳು ತೆನೆಗಳು ಒಂದೇ ಗಿಡದಲ್ಲಿ ಹುಟ್ಟಿದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ಆಮೇಲೆ ಅದೇ ಸಸಿಯ ಮೇಲೆ ಬಿಸಿಗಾಳಿಯಿಂದ ಬತ್ತಿಹೋಗಿದ್ದ ಏಳು ತೆನೆಗಳು ಹುಟ್ಟಿದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ಬತ್ತಿಹೋಗಿದ್ದ ತೆನೆಗಳು ಪುಷ್ಟಿಯಾಗಿದ್ದ ತೆನೆಗಳನ್ನು ತಿಂದುಬಿಟ್ಟವು. ಫರೋಹನು ಎಚ್ಚರಗೊಂಡಾಗ ಅದು ಕೇವಲ ಕನಸೆಂದು ತಿಳಿದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ಮರುದಿನ ಮುಂಜಾನೆ ಈ ಕನಸುಗಳ ಬಗ್ಗೆ ತುಂಬ ಚಿಂತೆಗೊಳಗಾಗಿ ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಮಂತ್ರಗಾರರನ್ನೂ ಎಲ್ಲಾ ವಿದ್ವಾಂಸರನ್ನೂ ಕರೆಯಿಸಿ ಕನಸುಗಳನ್ನು ತಿಳಿಸಿದನು. ಆದರೆ ಅವರಲ್ಲಿ ಯಾರಿಗೂ ಕನಸುಗಳ ಅರ್ಥವನ್ನು ತಿಳಿಸುವುದಕ್ಕಾಗಲಿ ವಿವರಿಸುವುದಕ್ಕಾಗಲಿ ಆಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ಆಗ ಪಾನದಾಯಕನು ಯೋಸೇಫನನ್ನು ಜ್ಞಾಪಿಸಿಕೊಂಡು ಫರೋಹನಿಗೆ, “ನನಗೆ ಸಂಭವಿಸಿದ್ದು ನನ್ನ ನೆನಪಿಗೆ ಬರುತ್ತಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ನೀವು ನನ್ನ ಮೇಲೆ ಮತ್ತು ಭಕ್ಷ್ಯಗಾರನ ಮೇಲೆ ಕೋಪಗೊಂಡು ನಮ್ಮನ್ನು ಸೆರೆಮನೆಗೆ ಹಾಕಿಸಿದಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ಒಂದು ರಾತ್ರಿ ನಮ್ಮಿಬ್ಬರಿಗೂ ಕನಸಾಯಿತು. ಆ ಕನಸುಗಳಿಗೆ ಬೇರೆಬೇರೆಯ ಅರ್ಥಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ನಮ್ಮ ಜೊತೆಯಲ್ಲಿ ಒಬ್ಬ ಇಬ್ರಿಯ ಯುವಕನಿದ್ದನು. ಅವನು ಕಾವಲುಗಾರರ ಅಧಿಕಾರಿಯ ಸೇವಕನಾಗಿದ್ದನು. ನಾವು ಅವನಿಗೆ ನಮ್ಮ ಕನಸುಗಳನ್ನು ತಿಳಿಸಿದೆವು. ಅವನು ನಮಗೆ ಅವುಗಳನ್ನು ವಿವರಿಸಿ ನಮ್ಮ ಕನಸಿನ ಅರ್ಥವನ್ನು ತಿಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ಅವನು ಹೇಳಿದ ಅರ್ಥಕ್ಕೆ ಸರಿಯಾಗಿ ನನಗೆ ಆಯಿತು; ಮೊದಲಿನ ಉದ್ಯೋಗವು ದೊರೆಯಿತು; ಅವನು ಭಕ್ಷ್ಯಗಾರನನ್ನು ಕುರಿತು ತಿಳಿಸಿದಂತೆಯೇ ಅವನಿಗೆ ಮರಣದಂಡನೆ ಆಯಿತು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ಆಗ ಫರೋಹನು ಯೋಸೇಫನನ್ನು ಸೆರೆಮನೆಯಿಂದ ಕರೆಸಿದನು. ಯೋಸೇಫನು ಕ್ಷೌರಮಾಡಿಕೊಂಡು ಶುದ್ಧವಾದ ಬಟ್ಟೆಗಳನ್ನು ಹಾಕಿಕೊಂಡು ಹೋಗಿ ಫರೋಹನ ಮುಂದೆ ನಿಂತುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನನಗೆ ಒಂದು ಕನಸಾಯಿತು. ಆದರೆ ಅದರ ಅರ್ಥವನ್ನು ತಿಳಿಸಬಲ್ಲವರು ಇಲ್ಲಿ ಯಾರೂ ಇಲ್ಲ. ನೀನು ಕನಸುಗಳ ಅರ್ಥವನ್ನು ಹೇಳಬಲ್ಲೆ ಎಂಬುದಾಗಿ ನಿನ್ನ ಬಗ್ಗೆ ಕೇಳಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ಯೋಸೇಫನು, “ಕನಸುಗಳನ್ನು ಅರ್ಥಮಾಡಿಕೊಳ್ಳುವ ಸಾಮರ್ಥ್ಯ ನನ್ನಲ್ಲಿಲ್ಲ. ಆ ಶಕ್ತಿಯನ್ನು ಹೊಂದಿರುವವನು ದೇವರೊಬ್ಬನೇ. ಆದರೆ ದೇವರು ಫರೋಹನಿಗೋಸ್ಕರ ಅರ್ಥವನ್ನು ತಿಳಿಸುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ಆಗ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನನ್ನ ಕನಸಿನಲ್ಲಿ, ನಾನು ನೈಲ್ ನದಿಯ ತೀರದಲ್ಲಿ ನಿಂತುಕೊಂಡಿದ್ದೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ಕೊಬ್ಬಿದ ಮತ್ತು ಲಕ್ಷಣವಾಗಿದ್ದ ಏಳು ಹಸುಗಳು ನದಿಯೊಳಗಿಂದ ಬಂದು ಹುಲ್ಲನ್ನು ಮೇಯುತ್ತಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ಆಗ ಬಡಕಲಾಗಿದ್ದ ಮತ್ತು ಕುರೂಪವಾಗಿದ್ದ ಏಳು ಹಸುಗಳು ನದಿಯೊಳಗಿಂದ ಬಂದು ನಿಂತುಕೊಂಡವು. ಅಂಥಾ ಬಡಕಲು ಹಸುಗಳನ್ನು ನಾನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಎಂದೂ ನೋಡಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ಬಡಕಲಾಗಿದ್ದ ಆ ಹಸುಗಳು ಮೊದಲು ಬಂದ ಲಕ್ಷಣವಾದ ಏಳು ಹಸುಗಳನ್ನು ತಿಂದುಬಿಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ಅವು ಏಳು ಹಸುಗಳನ್ನು ತಿಂದ ಮೇಲೆಯೂ ತಿಂದಂತೆ ಕಾಣುತ್ತಿರಲಿಲ್ಲ; ಅವು ಮೊದಲಿನಂತೆಯೇ ಬಡಕಲಾಗಿದ್ದವು ಮತ್ತು ಕುರೂಪವಾಗಿದ್ದವು. ಆಗ ನನಗೆ ಎಚ್ಚರವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“ನನಗಾದ ಎರಡನೆಯ ಕನಸು ಇಂತಿದೆ: ಒಂದೇ ಗಿಡದಲ್ಲಿ ಪುಷ್ಟಿಯಾದ ಏಳು ತೆನೆಗಳು ಹುಟ್ಟಿದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ಬಳಿಕ ಅದೇ ಗಿಡದಲ್ಲಿ ಮೇಲೆ ಬಿಸಿಗಾಳಿಯಿಂದ ಬತ್ತಿಹೋಗಿದ್ದ ಏಳು ತೆನೆಗಳು ಹುಟ್ಟಿದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ಬತ್ತಿಹೋಗಿದ್ದ ತೆನೆಗಳು ಪುಷ್ಟಿಯಾದ ಏಳು ತೆನೆಗಳನ್ನು ತಿಂದುಬಿಟ್ಟವು. “ನಾನು ಈ ಕನಸುಗಳನ್ನು ಮಂತ್ರಗಾರರಿಗೂ ವಿದ್ವಾಂಸರಿಗೂ ತಿಳಿಸಿದೆನು. ಆದರೆ ಅವರಲ್ಲಿ ಯಾರೂ ನನಗೆ ಈ ಕನಸುಗಳ ಅರ್ಥವನ್ನು ವಿವರಿಸಲಾಗಲಿಲ್ಲ. ಅವುಗಳ ಅರ್ಥವೇನು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ಆಗ ಯೋಸೇಫನು ಫರೋಹನಿಗೆ, “ಆ ಎರಡು ಕನಸುಗಳ ಅರ್ಥವು ಒಂದೇ. ಮುಂದೆ ನಡೆಯಲಿರುವುದನ್ನು ದೇವರು ತಮಗೆ ತಿಳಿಸಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ಒಳ್ಳೆಯ ಏಳು ಹಸುಗಳೇ ಏಳು ವರ್ಷಗಳು. ಒಳ್ಳೆಯ ಏಳು ತೆನೆಗಳೇ ಏಳು ವರ್ಷಗಳು. ಎರಡು ಕನಸುಗಳೂ ಒಂದೇ ಅರ್ಥವನ್ನು ಹೊಂದಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ಬಡಕಲಾದ ಮತ್ತು ಕುರೂಪವಾದ ಏಳು ಹಸುಗಳು ಮತ್ತು ಕೆಟ್ಟುಹೋದ ಕಾಳಿನ ಏಳು ತೆನೆಗಳು, ದೇಶಕ್ಕೆ ಬರುವ ಏಳು ವರ್ಷಗಳ ಬರಗಾಲವನ್ನು ಸೂಚಿಸುತ್ತವೆ. ಈ ಏಳು ವರ್ಷಗಳು ಒಳ್ಳೆಯ ವರ್ಷಗಳ ನಂತರ ಬರುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ಮುಂದೆ ನಡೆಯಲಿರುವುದನ್ನು ದೇವರು ನಿಮಗೆ ತಿಳಿಸಿದ್ದಾನೆ. ನಾನು ಹೇಳಿದಂತೆಯೇ ಸಂಭವಿಸುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ನಿಮಗೆ ಏಳು ವರ್ಷಗಳ ಕಾಲ ಒಳ್ಳೆಯ ಬೆಳೆಯಾಗುವುದು; ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಊಟಕ್ಕೆ ಬೇಕಾದಷ್ಟು ಆಹಾರವಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ಆದರೆ ಆ ಏಳು ವರ್ಷಗಳಾದ ಮೇಲೆ ದೇಶದಲ್ಲೆಲ್ಲಾ ಏಳು ವರ್ಷಗಳವರೆಗೆ ಬರಗಾಲವಿರುವುದು. ಆಗ ಈಜಿಪ್ಟಿನ ಜನರು ತಾವು ಮೊದಲು ಬೆಳೆದ ಆಹಾರವನ್ನೆಲ್ಲಾ ಮರೆತುಬಿಡುವರು. ಈ ಕ್ಷಾಮವು ದೇಶವನ್ನು ನಾಶಮಾಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ಮೊದಲಿನ ಸಮೃದ್ಧಿಯ ಗುರುತೇ ಜನರಿಗೆ ಕಾಣಸಿಗದು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“ಫರೋಹನೇ, ಒಂದೇ ವಿಷಯದ ಮೇಲೆ ಎರಡು ಕನಸುಗಳಾಗಿರುವುದರಿಂದ ದೇವರು ಇದನ್ನು ನಿಶ್ಚಯವಾಗಿಯೂ ಬೇಗನೆ ಬರಮಾಡಲಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ಆದ್ದರಿಂದ ತಾವು ತುಂಬ ಬುದ್ಧಿವಂತನೂ ವಿವೇಕಿಯೂ ಆಗಿರುವ ಒಬ್ಬನನ್ನು ಆರಿಸಿಕೊಂಡು ಅವನನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆ ಆಡಳಿತಾಧಿಕಾರಿಯನ್ನಾಗಿ ನೇಮಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ಅಲ್ಲದೆ ಜನರಿಂದ ಆಹಾರವನ್ನು ಶೇಖರಿಸುವುದಕ್ಕಾಗಿ ತಾವು ಸಂಗ್ರಹಕರನ್ನು ನೇಮಿಸಿ ಒಳ್ಳೆಯ ಏಳು ವರ್ಷಗಳಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬ ಬೆಳೆಗಾರನಿಂದಲೂ ಬೆಳೆಯ ಐದನೆ ಒಂದು ಭಾಗವನ್ನು ಕಂದಾಯ ರೂಪದಲ್ಲಿ ವಸೂಲಿ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ಸಂಗ್ರಹಕಾರರ ಮೂಲಕ ಆಹಾರಪದಾರ್ಥಗಳನ್ನೂ ದವಸಧಾನ್ಯಗಳನ್ನೂ ಶೇಖರಿಸಿ ನಿಮ್ಮ ಉಗ್ರಾಣಗಳಲ್ಲಿಟ್ಟು ನೋಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ಉಗ್ರಾಣಗಳಲ್ಲಿ ಸಾಕಷ್ಟು ಆಹಾರವಿರುವುದರಿಂದ ಈಜಿಪ್ಟಿನವರು ಬರಗಾಲದ ಏಳು ವರ್ಷಗಳಲ್ಲಿ ಆಹಾರವಿಲ್ಲದೆ ಸಾಯುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ಇದು ಫರೋಹನಿಗೂ ಅವನ ಎಲ್ಲಾ ಸೇವಕರಿಗೂ ಒಳ್ಳೆಯದಾಗಿ ಕಂಡುಬಂತು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ಫರೋಹನು ತನ್ನ ಸೇವಕರಿಗೆ, “ಈ ಜವಾಬ್ದಾರಿಯನ್ನು ವಹಿಸಿಕೊಳ್ಳಲು ಯೋಸೇಫನಿಗಿಂತಲೂ ಉತ್ತಮನಾದ ವ್ಯಕ್ತಿಯನ್ನು ಕಂಡುಕೊಳ್ಳಲು ಸಾಧ್ಯವೇ? ದೇವರಾತ್ಮನೇ ಇವನ ಸಂಗಡವಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ದೇವರು ನಿನಗೆ ಈ ಎಲ್ಲಾ ವಿಷಯಗಳನ್ನು ತೋರಿಸಿರುವುದರಿಂದ ನಿನಗಿಂತ ಬುದ್ಧಿವಂತನೂ ವಿವೇಕಿಯೂ ಇಲ್ಲವೇ ಇಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ಆದ್ದರಿಂದ ನಾನು ನಿನ್ನನ್ನು ದೇಶದ ರಾಜ್ಯಪಾಲನನ್ನಾಗಿ ನೇಮಿಸುವೆನು; ಜನರು ನಿನ್ನ ಆಜ್ಞೆಗಳಿಗೆಲ್ಲಾ ವಿಧೇಯರಾಗುವರು. ಈ ದೇಶದಲ್ಲಿ ನಿನಗೆ ಅಧಿಪತಿಯಾಗಿರುವವನು ನಾನೊಬ್ಬನೇ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನಾನು ನಿನ್ನನ್ನು ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆಲ್ಲ ರಾಜ್ಯಪಾಲನನ್ನಾಗಿ ನೇಮಿಸುವೆನು” ಎಂದು ಹೇಳಿ ");
INSERT INTO kan2010_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ರಾಜಮುದ್ರೆಯನ್ನು ಹೊಂದಿದ್ದ ತನ್ನ ಉಂಗುರವನ್ನು ಕೊಟ್ಟನು; ಧರಿಸಿಕೊಳ್ಳಲು ಒಳ್ಳೆಯ ನಾರುಬಟ್ಟೆಯ ನಿಲುವಂಗಿಯನ್ನು ಕೊಟ್ಟನು; ಕೊರಳಿಗೆ ಚಿನ್ನದ ಸರವನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ಫರೋಹನು ಯೋಸೇಫನಿಗೆ ಎರಡನೆಯ ರಾಜರಥವನ್ನು ಸಂಚಾರಕ್ಕಾಗಿ ಕೊಟ್ಟನು. ವಿಶೇಷಕಾವಲುಗಾರರು ಅವನ ರಥದ ಮುಂದೆ ನಡೆದುಹೋಗುತ್ತಾ “ಪ್ರಜೆಗಳೇ, ಯೋಸೇಫನಿಗೆ ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿರಿ” ಎಂದು ಪ್ರಕಟಿಸಿದರು. ಹೀಗೆ ಯೋಸೇಫನು ಈಜಿಪ್ಟಿಗೆಲ್ಲಾ ರಾಜ್ಯಪಾಲನಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ಫರೋಹನು ಅವನಿಗೆ, “ನಾನು ರಾಜ ಫರೋಹ. ಆದ್ದರಿಂದ ನನಗೆ ಇಷ್ಟವಾದದ್ದನ್ನು ಮಾಡುವೆನು. ಆದರೆ ನಿನ್ನ ಅಪ್ಪಣೆಯಿಲ್ಲದೆ ಈಜಿಪ್ಟಿನ ಬೇರೆ ಯಾರೂ ಕೈಯೆತ್ತಲೂ ಸಾಧ್ಯವಿಲ್ಲ, ಕಾಲನ್ನು ಚಲಿಸಲೂ ಸಾಧ್ಯವಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, ಸಾಫ್ನತ್ಪನ್ನೇಹ ಎಂಬ ಹೆಸರನ್ನು ಕೊಟ್ಟನು. ಇದಲ್ಲದೆ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ ಆಸನತ್ ಎಂಬಾಕೆಯನ್ನು ಮದುವೆ ಮಾಡಿಸಿದನು. ಆಕೆ ಓನ್ ನಗರದ ಆಚಾರ್ಯನಾಗಿದ್ದ ಫೋಟೀಫರನ ಮಗಳು. ಹೀಗೆ ಯೋಸೇಫನು ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆಲ್ಲಾ ರಾಜ್ಯಪಾಲನಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ಯೋಸೇಫನು ಈಜಿಪ್ಟ್ ರಾಜನ ಸೇವೆಯನ್ನು ಪ್ರಾರಂಭಿಸಿದಾಗ ಮೂವತ್ತು ವರ್ಷದವನಾಗಿದ್ದನು. ಯೋಸೇಫನು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಸಂಚರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ಏಳು ಒಳ್ಳೆಯ ವರ್ಷಗಳಲ್ಲಿ ದೇಶದಲ್ಲಿ ಬೆಳೆಯು ಚೆನ್ನಾಗಿ ಬೆಳೆಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ಈಜಿಪ್ಟಿನಲ್ಲಿ ಯೋಸೇಫನು ಆ ಏಳು ವರ್ಷಗಳ ಕಾಲದಲ್ಲಿ ಆಹಾರವನ್ನು ಸಂಗ್ರಹಿಸಿ ನಗರಗಳ ಉಗ್ರಾಣಗಳಲ್ಲಿಟ್ಟನು. ಪ್ರತಿಯೊಂದು ನಗರದ ಸುತ್ತುಮುತ್ತಲಿನ ಹೊಲಗಳಲ್ಲಿ ಬೆಳೆದ ದವಸಧಾನ್ಯವನ್ನು ಆಯಾ ನಗರಗಳಲ್ಲಿ ಕೂಡಿಸಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ಯೋಸೇಫನು ಬಹಳ ದವಸಧಾನ್ಯಗಳನ್ನು ಸಂಗ್ರಹಿಸಿದ್ದರಿಂದ ಸಮುದ್ರದ ಮರಳಿನ ರಾಶಿಯೆಂಬಂತೆ ತೋರಿತು; ಲೆಕ್ಕಿಸುವುದಕ್ಕೂ ಅಸಾಧ್ಯವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ಯೋಸೇಫನ ಹೆಂಡತಿ ಆಸನತ್ ಓನ್ ನಗರದಲ್ಲಿ ಆಚಾರ್ಯನಾಗಿದ್ದ ಪೋಟೀಫೆರನ ಮಗಳು. ಬರಗಾಲದ ಮೊದಲನೆಯ ವರ್ಷ ಬರುವುದಕ್ಕಿಂತ ಮೊದಲೇ ಯೋಸೇಫನಿಗೆ ಆಸನತಳಲ್ಲಿ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ಮೊದಲನೆಯ ಮಗನು ಹುಟ್ಟಿದಾಗ, “ನನ್ನ ಎಲ್ಲಾ ಕಷ್ಟಗಳನ್ನೂ ನನ್ನ ತಂದೆಯ ಮನೆಯವರನ್ನೂ ಮರೆತುಬಿಡುವಂತೆ ದೇವರು ನನಗೆ ಸಹಾಯ ಮಾಡಿದನು” ಎಂದು ಹೇಳಿ ಯೋಸೇಫನು ಆ ಮಗುವಿಗೆ, “ಮನಸ್ಸೆ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ಎರಡನೆ ಮಗನು ಹುಟ್ಟಿದಾಗ, “ನನಗೆ ಕಷ್ಟ ಬಂದ ದೇಶದಲ್ಲೇ ದೇವರು ನನ್ನನ್ನು ಅಭಿವೃದ್ಧಿಪಡಿಸಿದನು” ಎಂದು ಹೇಳಿ, ಆ ಮಗುವಿಗೆ, “ಎಫ್ರಾಯೀಮ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ಈಜಿಪ್ಟಿನಲ್ಲಿ ಸಮೃದ್ಧಿಕರವಾದ ಏಳು ವರ್ಷಗಳು ಮುಗಿದ ಮೇಲೆ ");
INSERT INTO kan2010_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ಯೋಸೇಫನು ಹೇಳಿದ್ದಂತೆಯೇ ಕ್ಷಾಮದ ಏಳು ವರ್ಷಗಳು ಆರಂಭಗೊಂಡವು. ಕ್ಷಾಮವು ಸುತ್ತಮುತ್ತಲಿನ ಪ್ರದೇಶಗಳಿಗೆಲ್ಲಾ ಹಬ್ಬಿಕೊಂಡಿತು. ಈಜಿಪ್ಟಿನಲ್ಲಿ ಮಾತ್ರ ಆಹಾರ ದೊರಕುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ಬರಗಾಲವು ಪ್ರಾರಂಭವಾದಾಗ ಜನರು ಆಹಾರಕ್ಕಾಗಿ ಫರೋಹನನ್ನು ಬೇಡಿಕೊಂಡರು. ಫರೋಹನು ಈಜಿಪ್ಟಿನ ಜನರಿಗೆ, “ಯೋಸೇಫನನ್ನು ಕೇಳಿರಿ; ಅವನು ಹೇಳಿದಂತೆ ಮಾಡಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ಎಲ್ಲೆಲ್ಲಿಯೂ ಬರಗಾಲವಾದಾಗ, ಯೋಸೇಫನು ಉಗ್ರಾಣಗಳನ್ನು ತೆಗೆಸಿ ದವಸಧಾನ್ಯಗಳನ್ನು ಜನರಿಗೆ ಮಾರಾಟ ಮಾಡಿಸಿದನು. ಈಜಿಪ್ಟಿನಲ್ಲಿ ಬರವು ಭೀಕರವಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ಕ್ಷಾಮವು ಭಯಂಕರವಾಗಿದ್ದುದರಿಂದ ಎಲ್ಲಾ ದೇಶಗಳವರು ಯೋಸೇಫನಿಂದ ಆಹಾರವನ್ನು ಪಡೆದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಈಜಿಪ್ಟಿಗೆ ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ಈಜಿಪ್ಟಿನಲ್ಲಿ ದವಸಧಾನ್ಯಗಳಿರುವುದಾಗಿ ಕಾನಾನಿನಲ್ಲಿದ್ದ ಯಾಕೋಬನಿಗೆ ತಿಳಿಯಿತು. ಆದ್ದರಿಂದ ಯಾಕೋಬನು ತನ್ನ ಗಂಡುಮಕ್ಕಳಿಗೆ, “ನಾವು ಇಲ್ಲಿ ಏನೂ ಮಾಡದೆ ಕುಳಿತುಕೊಂಡಿರುವುದೇಕೆ? ");
INSERT INTO kan2010_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ಈಜಿಪ್ಟಿನಲ್ಲಿ ದವಸಧಾನ್ಯಗಳಿರುವುದಾಗಿ ನಾನು ಕೇಳಿದ್ದೇನೆ. ಆದ್ದರಿಂದ ನಾವು ಅಲ್ಲಿಗೆ ಹೋಗಿ ನಮ್ಮ ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳೋಣ. ಆಗ ನಾವು ಸಾಯದೆ ಬದುಕಿಕೊಳ್ಳುವೆವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ಆದ್ದರಿಂದ ಯೋಸೇಫನ ಹತ್ತು ಮಂದಿ ಸಹೋದರರು ದವಸಧಾನ್ಯಗಳನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ಈಜಿಪ್ಟಿಗೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ಯಾಕೋಬನು ಬೆನ್ಯಾಮೀನನನ್ನು ಕಳುಹಿಸಲಿಲ್ಲ. (ಬೆನ್ಯಾಮೀನನು ಯೋಸೇಫನ ಒಡಹುಟ್ಟಿದ ಒಬ್ಬನೇ ತಮ್ಮನಾಗಿದ್ದನು.) ಬೆನ್ಯಾಮೀನನಿಗೆ ಏನಾದರೂ ಕೇಡಾಗಬಹುದೆಂಬ ಭಯ ಯಾಕೋಬನಿಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ಕಾನಾನಿನಲ್ಲಿ ಬರಗಾಲ ಭೀಕರವಾಗಿತ್ತು. ಆದ್ದರಿಂದ ದವಸಧಾನ್ಯಗಳನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ಅನೇಕ ಜನರು ಕಾನಾನಿನಿಂದ ಈಜಿಪ್ಟಿಗೆ ಹೋದರು; ಇಸ್ರೇಲನ ಗಂಡುಮಕ್ಕಳೂ ಅವರೊಂದಿಗೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ಯೋಸೇಫನು ಈಜಿಪ್ಟಿನ ರಾಜ್ಯಪಾಲನಾಗಿದ್ದರಿಂದ ಅವನ ಅನುಮತಿಯಿಲ್ಲದೆ ದವಸಧಾನ್ಯಗಳನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ಯಾರಿಗೂ ಸಾಧ್ಯವಿರಲಿಲ್ಲ. ಯೋಸೇಫನ ಸಹೋದರರು ಬಂದು ಅವನ ಮುಂದೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ಯೋಸೇಫನು ಅವರನ್ನು ಕಂಡು, ತನ್ನ ಅಣ್ಣಂದಿರೆಂದು ತಿಳಿದುಕೊಂಡನು. ಆದರೂ ಅವನು ತನಗೆ ಅವರು ಗೊತ್ತೇ ಇಲ್ಲದಂತೆ ಅವರೊಂದಿಗೆ ಕಟುವಾಗಿ ಮಾತಾಡಿ, ಅವರಿಗೆ, “ನೀವು ಎಲ್ಲಿಂದ ಬಂದಿರುವಿರಿ?” ಎಂದು ಕೇಳಿದನು. ಸಹೋದರರು, “ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ಕಾನಾನ್ ದೇಶದಿಂದ ಬಂದಿದ್ದೇವೆ” ಎಂದು ಉತ್ತರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ಯೋಸೇಫನು ತನ್ನ ಅಣ್ಣಂದಿರನ್ನು ಗುರುತಿಸಿದರೂ ಅವನ ಅಣ್ಣಂದಿರು ಯೋಸೇಫನನ್ನು ಗುರುತಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ಆಗ ಯೋಸೇಫನು ತನ್ನ ಅಣ್ಣಂದಿರ ಬಗ್ಗೆ ತಾನು ಕಂಡಿದ್ದ ಕನಸುಗಳ ಬಗ್ಗೆ ಜ್ಞಾಪಿಸಿಕೊಂಡು ಅವರಿಗೆ, “ನೀವು ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ಬಂದಿಲ್ಲ; ನೀವು ಗೂಢಚಾರರು. ನಮ್ಮ ದೇಶದ ದುರ್ಬಲ ಸ್ಥಳಗಳನ್ನು ತಿಳಿದುಕೊಳ್ಳಲು ಬಂದಿರುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ಸಹೋದರರು ಅವನಿಗೆ, “ಇಲ್ಲ! ಸ್ವಾಮೀ, ನಿಮ್ಮ ಸೇವಕರಾದ ನಾವು ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ಬಂದಿದ್ದೇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ನಾವೆಲ್ಲರೂ ಸಹೋದರರು. ನಮ್ಮೆಲ್ಲರಿಗೂ ಒಬ್ಬನೇ ತಂದೆ. ನಾವು ಯಥಾರ್ಥವಾಗಿ ಬಂದವರೇ ಹೊರತು ಗೂಢಚಾರರಲ್ಲ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ಯೋಸೇಫನು ಅವರಿಗೆ, “ಇಲ್ಲ! ನಮ್ಮ ದುರ್ಬಲ ಸ್ಥಳಗಳನ್ನು ಕಂಡುಕೊಳ್ಳುವುದಕ್ಕೆ ನೀವು ಬಂದಿದ್ದೀರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ಅದಕ್ಕೆ ಅವರು, “ಇಲ್ಲ, ನಾವೆಲ್ಲಾ ಸಹೋದರರು. ನಮ್ಮ ಕುಟುಂಬದಲ್ಲಿ ಹನ್ನೆರಡು ಮಂದಿ ಅಣ್ಣತಮ್ಮಂದಿರು. ನಮ್ಮೆಲ್ಲರಿಗೂ ಒಬ್ಬನೇ ತಂದೆ. ನಮ್ಮ ಕಿರಿಯ ತಮ್ಮನು ನಮ್ಮ ತಂದೆಯೊಂದಿಗೆ ಮನೆಯಲ್ಲಿದ್ದಾನೆ; ಇನ್ನೊಬ್ಬ ತಮ್ಮನು ಹೊರಟುಹೋದನು. ತಮ್ಮ ಸೇವಕರಾದ ನಾವು ಕಾನಾನ್ ದೇಶದಿಂದ ಬಂದವರು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ಯೋಸೇಫನು ಅವರಿಗೆ, “ಇಲ್ಲ, ನಾನು ಹೇಳಿದಂತೆ ನೀವು ಗೂಢಚಾರರೇ. ");
INSERT INTO kan2010_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ಆದರೆ ನೀವು ಹೇಳುತ್ತಿರುವುದು ಸತ್ಯವಾಗಿದ್ದರೆ ನಿಮ್ಮ ಚಿಕ್ಕ ತಮ್ಮನು ಇಲ್ಲಿಗೆ ಬರಬೇಕು; ಇಲ್ಲವಾದರೆ ಫರೋಹನ ಜೀವದಾಣೆ, ಅಲ್ಲಿಯವರೆಗೂ ನೀವು ಈ ಸ್ಥಳದಿಂದ ಹೋಗಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ಆದ್ದರಿಂದ ನಿಮ್ಮಲ್ಲೊಬ್ಬನು ಹಿಂತಿರುಗಿ ಹೋಗಿ ನಿಮ್ಮ ಚಿಕ್ಕ ತಮ್ಮನನ್ನು ಇಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು. ಅಲ್ಲಿಯವರೆಗೆ ಉಳಿದವರೆಲ್ಲರೂ ಇಲ್ಲಿ ಸೆರೆಮನೆಯಲ್ಲಿರಬೇಕು. ನೀವು ಹೇಳುತ್ತಿರುವುದು ಸತ್ಯವೋ ಸುಳ್ಳೋ ಆಗ ನನಗೆ ಗೊತ್ತಾಗುವುದು. ಆದರೆ ನೀವಂತೂ ಗೂಢಚಾರರೆಂದು ತಿಳಿದುಕೊಂಡಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ಆಮೇಲೆ ಯೋಸೇಫನು ಅವರೆಲ್ಲರನ್ನು ಮೂರು ದಿನಗಳವರೆಗೆ ಸೆರೆಮನೆಯಲ್ಲಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ಮೂರು ದಿನಗಳಾದ ಮೇಲೆ ಯೋಸೇಫನು ಅವರಿಗೆ, “ನಾನು ದೇವರಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವನು. ನೀವು ಈ ಕಾರ್ಯವೊಂದನ್ನು ಮಾಡಿದರೆ ನಾನು ನಿಮ್ಮನ್ನು ಉಳಿಸುತ್ತೇನೆ; ");
INSERT INTO kan2010_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ನೀವು ಯಥಾರ್ಥವಂತರಾಗಿದ್ದರೆ, ನಿಮ್ಮ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನನ್ನು ಸೆರೆಮನೆಯಲ್ಲಿಡುತ್ತೇನೆ; ಉಳಿದವರು ನಿಮ್ಮ ಜನರಿಗಾಗಿ ದವಸಧಾನ್ಯಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ಆಮೇಲೆ ನಿಮ್ಮ ಕಿರಿಯ ತಮ್ಮನನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದರೆ ನೀವು ಹೇಳುತ್ತಿರುವುದು ಸತ್ಯವೆಂದು ತಿಳಿದುಕೊಳ್ಳುವೆನು” ಎಂದು ಹೇಳಿದನು. ಸಹೋದರರು ಇದಕ್ಕೆ ಒಪ್ಪಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ಅವರು ಒಬ್ಬರಿಗೊಬ್ಬರು, “ನಾವು ನಮ್ಮ ತಮ್ಮನಾದ ಯೋಸೇಫನಿಗೆ ಮಾಡಿದ ಕೆಟ್ಟಕಾರ್ಯಕ್ಕಾಗಿ ಈ ಶಿಕ್ಷೆಯನ್ನು ಅನುಭವಿಸುತ್ತಿದ್ದೇವೆ. ಪ್ರಾಣಸಂಕಟದಲ್ಲಿದ್ದ ಅವನು ತನ್ನನ್ನು ಕಾಪಾಡುವಂತೆ ನಮ್ಮನ್ನು ಬೇಡಿಕೊಂಡರೂ ನಾವು ಅವನ ಮೊರೆಯನ್ನು ತಿರಸ್ಕರಿಸಿದೆವು. ಆದ್ದರಿಂದ ಈಗ ಪ್ರಾಣಸಂಕಟಕ್ಕೀಡಾಗಿದ್ದೇವೆ” ಎಂದು ಮಾತಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ಅದಕ್ಕೆ ರೂಬೇನನು ಅವರಿಗೆ, “ಆ ಹುಡುಗನಿಗೆ ಕೇಡು ಮಾಡಬೇಡಿ ಎಂದು ನಾನು ನಿಮಗೆ ಹೇಳಿದರೂ ನೀವು ನನ್ನ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಈಗ ನಾವು ಅವನ ಮರಣಕ್ಕೆ ತಕ್ಕ ಶಿಕ್ಷೆ ಹೊಂದುತ್ತಿದ್ದೇವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರೊಂದಿಗೆ ಭಾಷಾಂತರಕಾರನ ಮೂಲಕ ಮಾತಾಡುತ್ತಿದ್ದನು. ಆದ್ದರಿಂದ ಆ ಸಹೋದರರು ತಮ್ಮ ಭಾಷೆ ಯೋಸೇಫನಿಗೆ ಅರ್ಥವಾಗುವುದಿಲ್ಲವೆಂದು ತಿಳಿದುಕೊಂಡಿದ್ದರು. ಆದರೆ ಯೋಸೇಫನಿಗೆ ಅವರ ಮಾತುಗಳೆಲ್ಲಾ ಅರ್ಥವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ಅವರ ಮಾತುಗಳಿಂದ ಅವನಿಗೆ ತುಂಬ ದುಃಖವಾಯಿತು. ಆದ್ದರಿಂದ ಯೋಸೇಫನು ಅವರ ಬಳಿಯಿಂದ ಸ್ವಲ್ಪದೂರ ಹೋಗಿ ಕಣ್ಣೀರು ಸುರಿಸಿ ಹಿಂತಿರುಗಿ ಬಂದನು. ಬಳಿಕ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನಾದ ಸಿಮೆಯೋನನನ್ನು ಅವರ ಕಣ್ಣೆದುರಿನಲ್ಲೇ ಬಂಧಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ಆಮೇಲೆ ಯೋಸೇಫನು ತನ್ನ ಸೇವಕರಿಗೆ, “ಅವರ ಚೀಲಗಳಿಗೆ ದವಸಧಾನ್ಯಗಳನ್ನು ತುಂಬಿರಿ” ಎಂದು ಹೇಳಿದನು. ಈ ದವಸಧಾನ್ಯಗಳಿಗೆ ಸಹೋದರರು ಹಣವನ್ನು ಪಾವತಿ ಮಾಡಿದರೂ ಯೋಸೇಫನು ಆ ಹಣವನ್ನು ಇಟ್ಟುಕೊಳ್ಳಲಿಲ್ಲ. ಅವನು ಆ ಹಣವನ್ನು ಅವರವರ ದವಸಧಾನ್ಯಗಳ ಚೀಲಗಳಲ್ಲಿ ಇಡಿಸಿದನು. ಅಲ್ಲದೆ ಪ್ರಯಾಣಕ್ಕೆ ಬೇಕಾದ ವಸ್ತುಗಳನ್ನೂ ಅವರಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ಸಹೋದರರು ದವಸಧಾನ್ಯಗಳನ್ನು ಕತ್ತೆಗಳ ಮೇಲೆ ಹೇರಿಸಿಕೊಂಡು ಅಲ್ಲಿಂದ ಹೊರಟರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ಆ ರಾತ್ರಿ ಸಹೋದರರು ಒಂದು ಸ್ಥಳದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನು ಕತ್ತೆಗೋಸ್ಕರ ಸ್ವಲ್ಪ ದವಸಧಾನ್ಯಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಲು ತನ್ನ ಚೀಲವನ್ನು ಬಿಚ್ಚಿದಾಗ ತಾನು ಪಾವತಿ ಮಾಡಿದ್ದ ಹಣವು ಚೀಲದಲ್ಲಿರುವುದನ್ನು ನೋಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ಅವನು ತನ್ನ ಉಳಿದ ಸಹೋದರರಿಗೆ, “ನೋಡಿ, ನಾನು ದವಸಧಾನ್ಯಗಳಿಗೆ ಕೊಟ್ಟ ಹಣ ಇಲ್ಲೇ ಇದೆ. ಯಾರೋ ಒಬ್ಬನು ಹಣವನ್ನು ಮತ್ತೆ ನನ್ನ ಚೀಲದಲ್ಲಿ ಇಟ್ಟಿರುವನು” ಎಂದು ಹೇಳಿದನು. ಸಹೋದರರಿಗೆ ತುಂಬ ಭಯವಾಯಿತು. ಅವರು ಒಬ್ಬರಿಗೊಬ್ಬರು, “ದೇವರು ನಮಗೆ ಮಾಡುತ್ತಿರುವುದೇನು?” ಎಂದು ಮಾತಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ಸಹೋದರರು ಕಾನಾನ್ ದೇಶದಲ್ಲಿದ್ದ ತಮ್ಮ ತಂದೆಯಾದ ಯಾಕೋಬನ ಬಳಿಗೆ ಹೋದರು. ನಡೆದ ಸಂಗತಿಗಳನ್ನೆಲ್ಲಾ ಯಾಕೋಬನಿಗೆ ಹೇಳುತ್ತಾ, ");
INSERT INTO kan2010_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ಆ ದೇಶದ ರಾಜ್ಯಪಾಲನು ನಮ್ಮನ್ನು ಗೂಢಚಾರರೆಂದು ಭಾವಿಸಿ ನಮ್ಮೊಂದಿಗೆ ಒರಟಾಗಿ ಮಾತನಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ನಾವು ಅವನಿಗೆ, ‘ನಾವು ಯಥಾರ್ಥವಂತರು; ಗೂಢಚಾರರಲ್ಲ’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ನಾವು ಹನ್ನೆರಡು ಮಂದಿ ಅಣ್ಣತಮ್ಮಂದಿರೆಂದೂ ನಮಗೆ ಒಬ್ಬನೇ ತಂದೆಯೆಂದೂ ಅವನಿಗೆ ಹೇಳಿದೆವು. ನಮ್ಮ ಒಬ್ಬ ತಮ್ಮನು ಸತ್ತುಹೋದನೆಂದೂ ನಮ್ಮ ಕಿರಿಯ ತಮ್ಮನು ಕಾನಾನ್ ದೇಶದಲ್ಲಿರುವ ನಮ್ಮ ಮನೆಯಲ್ಲಿರುವನೆಂದೂ ಅವನಿಗೆ ಹೇಳಿದೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“ಆಗ ಆ ದೇಶದ ರಾಜ್ಯಪಾಲನು, ‘ನೀವು ಯಥಾರ್ಥವಂತರೆಂದು ತೋರಿಸಬೇಕಾದರೆ ನಿಮ್ಮ ಸಹೋದರರಲ್ಲಿ ಒಬ್ಬನನ್ನು ನನ್ನ ಬಳಿಯಲ್ಲಿ ಬಿಟ್ಟು ನಿಮ್ಮ ಕುಟುಂಬಗಳಿಗೆ ದವಸಧಾನ್ಯಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ಆಮೇಲೆ ನಿಮ್ಮ ಕಿರಿಯ ತಮ್ಮನನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬನ್ನಿ. ಆಗ ನೀವು ಯಥಾರ್ಥರಾದವರೋ ಗೂಢಚಾರರೋ ಎಂದು ಗೊತ್ತಾಗುವುದು. ನೀವು ಸತ್ಯವನ್ನು ಹೇಳಿದ್ದರೆ ನಿಮ್ಮ ಸಹೋದರನನ್ನು ನಿಮಗೆ ಒಪ್ಪಿಸುವೆನು; ನಮ್ಮ ದೇಶದಲ್ಲಿ ಆಹಾರವನ್ನು ಕೊಳ್ಳಲು ನಿಮಗೆ ಯಾವ ತಡೆಯೂ ಇರುವುದಿಲ್ಲ’ ಎಂದು ಹೇಳಿದನು” ಎಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ಬಳಿಕ ಸಹೋದರರು ತಮ್ಮ ಚೀಲಗಳಿಂದ ದವಸಧಾನ್ಯಗಳನ್ನು ತೆಗೆಯಲು ಹೋದಾಗ ಪ್ರತಿಯೊಬ್ಬ ಸಹೋದರನ ಚೀಲದಲ್ಲಿಯೂ ತಾವು ಪಾವತಿ ಮಾಡಿದ್ದ ಹಣವನ್ನು ಕಂಡು ತುಂಬ ಭಯಗೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ಯಾಕೋಬನು ಅವರಿಗೆ, “ನಾನು ನನ್ನ ಮಕ್ಕಳನ್ನೆಲ್ಲ ಕಳೆದುಕೊಳ್ಳಬೇಕೆಂಬುದು ನಿಮಗೆ ಇಷ್ಟವೇ? ಯೋಸೇಫನು ಇಲ್ಲವಾದನು. ಸಿಮೆಯೋನನೂ ಇಲ್ಲವಾದನು. ಈಗ ಬೆನ್ಯಾಮೀನನನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕೆಂದಿರುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ರೂಬೇನನು ತನ್ನ ತಂದೆಗೆ, “ಅಪ್ಪಾ, ನಾನು ಬೆನ್ಯಾಮೀನನನ್ನು ಕರೆದುಕೊಂಡು ಬರದಿದ್ದರೆ ನೀನು ನನ್ನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳನ್ನು ಕೊಲ್ಲಬಹುದು. ನನ್ನನ್ನು ನಂಬು. ನಾನು ಬೆನ್ಯಾಮೀನನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ಯಾಕೋಬನು, “ನಾನು ನಿಮ್ಮೊಂದಿಗೆ ಬೆನ್ಯಾಮೀನನನ್ನು ಕಳುಹಿಸಿಕೊಡುವುದಿಲ್ಲ. ಅವನ ಸಹೋದರನು ಸತ್ತುಹೋದನು; ನನ್ನ ಹೆಂಡತಿಯಾದ ರಾಹೇಲಳಲ್ಲಿ ಹುಟ್ಟಿದ ಗಂಡುಮಕ್ಕಳಲ್ಲಿ ಇವನೊಬ್ಬನೇ ಉಳಿದಿರುವುದು. ಈಜಿಪ್ಟಿಗೆ ಪ್ರಯಾಣ ಮಾಡುವಾಗ ಇವನಿಗೆ ಅಪಾಯ ಸಂಭವಿಸಿದರೆ ವಯಸ್ಸಾದ ನಾನು ದುಃಖದಿಂದಲೇ ಸಮಾಧಿಗೆ ಸೇರಲು ನೀವು ಕಾರಣವಾಗುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ಬರಗಾಲವು ದೇಶದಲ್ಲಿ ತುಂಬ ಭೀಕರವಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ಅವರು ಈಜಿಪ್ಟಿನಿಂದ ತಂದಿದ್ದ ದವಸಧಾನ್ಯಗಳನ್ನೆಲ್ಲ ಊಟ ಮಾಡಿದರು. ದವಸಧಾನ್ಯಗಳು ಮುಗಿದು ಹೋದಾಗ ಯಾಕೋಬನು, ತನ್ನ ಗಂಡುಮಕ್ಕಳಿಗೆ, “ಈಜಿಪ್ಟಿಗೆ ಮತ್ತೆ ಹೋಗಿ ನಮಗೆ ಊಟಕ್ಕೆ ದವಸಧಾನ್ಯಗಳನ್ನು ಕೊಂಡುಕೊಂಡು ಬನ್ನಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ಯೆಹೂದನು ಯಾಕೋಬನಿಗೆ, “ಆ ದೇಶದ ರಾಜ್ಯಪಾಲನು ನಮಗೆ ಎಚ್ಚರಿಕೆ ಕೊಟ್ಟಿದ್ದಾನೆ. ಅವನು, ‘ನೀವು ನಿಮ್ಮ ಸಹೋದರನನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಾರದೆ ನನ್ನನ್ನು ಭೇಟಿಯಾಗಕೂಡದು’ ಎಂದು ಹೇಳಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ನೀನು ನಮ್ಮೊಡನೆ ಬೆನ್ಯಾಮೀನನನ್ನು ಕಳುಹಿಸಿದರೆ, ನಾವು ಹೋಗಿ ದವಸಧಾನ್ಯಗಳನ್ನು ಕೊಂಡುಕೊಂಡು ಬರುವೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ಆದರೆ ಬೆನ್ಯಾಮೀನನನ್ನು ಕಳುಹಿಸದಿದ್ದರೆ, ನಾವು ಹೋಗುವುದಿಲ್ಲ; ಆ ಮನುಷ್ಯನು ನಮಗೆ ಬೆನ್ಯಾಮೀನನಿಲ್ಲದೆ ಬರಕೂಡದೆಂದು ಎಚ್ಚರಿಕೆ ಕೊಟ್ಟಿದ್ದಾನೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ಇಸ್ರೇಲನು, “ನಿಮಗೆ ಮತ್ತೊಬ್ಬ ಸಹೋದರನಿರುವುದಾಗಿ ನೀವು ಆ ಮನುಷ್ಯನಿಗೆ ಯಾಕೆ ಹೇಳಿದಿರಿ? ನೀವು ಅಂಥ ಕೆಟ್ಟದ್ದನ್ನು ಯಾಕೆ ಮಾಡಿದಿರಿ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ಸಹೋದರರು, “ಆ ಮನುಷ್ಯನು ನಮ್ಮ ವಿಷಯವಾಗಿಯೂ ನಮ್ಮ ಕುಟುಂಬದ ವಿಷಯವಾಗಿಯೂ ತಿಳಿದುಕೊಳ್ಳಲು ಸೂಕ್ಷ್ಮವಾಗಿ ಪ್ರಶ್ನೆಗಳನ್ನು ಕೇಳಿದನು. ಅವನು ನಮಗೆ, ‘ನಿಮ್ಮ ತಂದೆಯು ಇನ್ನೂ ಜೀವಂತವಾಗಿರುವನೇ? ನಿಮಗೆ ಮನೆಯಲ್ಲಿ ಮತ್ತೊಬ್ಬ ಸಹೋದರನಿರುವನೇ?’ ಎಂದು ಕೇಳಿದನು. ನಾವು ಅವನ ಪ್ರಶ್ನೆಗಳಿಗೆ ಮಾತ್ರ ಉತ್ತರಕೊಟ್ಟೆವು. ನಮ್ಮ ಸಹೋದರನನ್ನು ತನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕೆಂದು ಅವನು ಹೇಳುತ್ತಾನೆಂದು ನಮಗೆ ತಿಳಿದಿರಲಿಲ್ಲ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ಆಮೇಲೆ ಯೆಹೂದನು ತನ್ನ ತಂದೆಯಾದ ಇಸ್ರೇಲನಿಗೆ, “ನನ್ನೊಂದಿಗೆ ಬೆನ್ಯಾಮೀನನನ್ನು ಕಳುಹಿಸಿಕೊಡು. ನಾನು ಅವನನ್ನು ನೋಡಿಕೊಳ್ಳುವೆನು. ನಾವು ಈಜಿಪ್ಟಿಗೆ ಹೋಗಿ ಆಹಾರವನ್ನು ತರಬೇಕು. ಇಲ್ಲವಾದರೆ ನಾವೂ ಸಾಯುವೆವು, ನಮ್ಮ ಮಕ್ಕಳೂ ಸಾಯುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ಅವನು ಸುರಕ್ಷಿತವಾಗಿರುವಂತೆ ನಾನು ನೋಡಿಕೊಳ್ಳುವೆನು. ನಾನು ಅವನಿಗೆ ಜವಾಬ್ದಾರನಾಗಿರುತ್ತೇನೆ. ನಾನು ಅವನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ಮತ್ತೆ ಕರೆದುಕೊಂಡು ಬರದಿದ್ದರೆ, ನೀನು ಸದಾಕಾಲ ನನ್ನನ್ನು ದೂಷಿಸಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ಮೊದಲೇ ನೀನು ನಮ್ಮನ್ನು ಕಳುಹಿಸಿಕೊಟ್ಟಿದ್ದರೆ, ಈಗಾಗಲೇ ಎರಡು ಸಲ ಆಹಾರವನ್ನು ತೆಗೆದುಕೊಂಡು ಬರಬಹುದಾಗಿತ್ತು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ಅದಕ್ಕೆ ಅವರ ತಂದೆಯಾದ ಇಸ್ರೇಲನು, “ಇದು ನಿಜವಾಗಿಯೂ ಸತ್ಯವಾಗಿದ್ದರೆ, ನಿನ್ನೊಂದಿಗೆ ಬೆನ್ಯಾಮೀನನನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗು. ಆದರೆ ರಾಜ್ಯಪಾಲನಿಗೆ ಶ್ರೇಷ್ಠವಾದ ಕೆಲವು ಉಡುಗೊರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿ. ನಮ್ಮ ನಾಡಿನಲ್ಲಿ ದೊರಕುವ ಜೇನು, ಆಕ್ರೋಡು, ಬಾದಾಮಿ, ಹಾಲುಮಡ್ಡಿ ಮತ್ತು ಗೋಲರಸ ಇವುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ಈ ಸಲ ಎರಡರಷ್ಟು ಹಣವನ್ನು ನಿಮ್ಮೊಂದಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ. ಕಳೆದ ಸಲ ನೀವು ಪಾವತಿ ಮಾಡಿದ್ದರೂ ಹಿಂತಿರುಗಿಸಲಾದ ಹಣವನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿ. ಒಂದುವೇಳೆ ರಾಜ್ಯಪಾಲನು ತಪ್ಪು ಮಾಡಿದ್ದಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ಬೆನ್ಯಾಮೀನನನ್ನು ಕರೆದುಕೊಂಡು ಆ ಮನುಷ್ಯನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ನೀವು ರಾಜ್ಯಪಾಲನ ಮುಂದೆ ನಿಂತುಕೊಂಡಾಗ ಸರ್ವಶಕ್ತನಾದ ದೇವರು ನಿಮಗೆ ಸಹಾಯ ಮಾಡುವಂತೆ ನಾನು ಪ್ರಾರ್ಥಿಸುತ್ತೇನೆ. ಬೆನ್ಯಾಮೀನನನ್ನೂ ಸಿಮೆಯೋನನನ್ನೂ ಕಳುಹಿಸಿಕೊಡುವಂತೆ ಮತ್ತು ನೀವು ಸುರಕ್ಷಿತವಾಗಿ ಮರಳಿಬರುವಂತೆ ನಾನು ಪ್ರಾರ್ಥಿಸುತ್ತೇನೆ. ಇಲ್ಲವಾದರೆ, ನನ್ನ ಮಗನನ್ನು ಕಳೆದುಕೊಂಡು ನಾನು ಮತ್ತೆ ದುಃಖಿತನಾಗುವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ಆದ್ದರಿಂದ ಸಹೋದರರು ರಾಜ್ಯಪಾಲನಿಗೆ ಕೊಡಲು ಉಡುಗೊರೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡರು; ಮೊದಲನೆ ಸಲ ತೆಗೆದುಕೊಂಡು ಹೋಗಿದ್ದ ಹಣಕ್ಕಿಂತ ಎರಡರಷ್ಟು ಹೆಚ್ಚಾಗಿ ತೆಗೆದುಕೊಂಡರು. ಬೆನ್ಯಾಮೀನನು ಸಹೋದರರೊಂದಿಗೆ ಈಜಿಪ್ಟಿಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ಸಹೋದರರೊಂದಿಗೆ ಬೆನ್ಯಾಮೀನನು ಇರುವುದನ್ನು ಕಂಡ ಯೋಸೇಫನು ತನ್ನ ಸೇವಕನಿಗೆ, “ಈ ಜನರನ್ನು ನನ್ನ ಮನೆಯೊಳಗೆ ಕರೆದುಕೊಂಡು ಹೋಗು; ಕುರಿಯನ್ನು ಕೊಯ್ದು ಅಡಿಗೆ ಮಾಡು. ಈ ಜನರು ಈ ಹೊತ್ತು ಮಧ್ಯಾಹ್ನ ನನ್ನೊಂದಿಗೆ ಊಟಮಾಡುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ಅಂತೆಯೇ ಆ ಸೇವಕನು ಸಹೋದರರನ್ನು ಮನೆಯೊಳಗೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ಆಗ ಸಹೋದರರಿಗೆ ಭಯವಾಯಿತು. ಅವರು, “ಕಳೆದ ಸಲ ನಮ್ಮ ಚೀಲಗಳಿಗೆ ಮತ್ತೆ ಹಾಕಿದ್ದ ಹಣದ ಕಾರಣದಿಂದಾಗಿ ನಮ್ಮನ್ನು ಇಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದಿದ್ದಾರೆ. ನಮ್ಮನ್ನು ತಪ್ಪಿತಸ್ಥರೆಂದು ನಿರ್ಣಯಿಸಿ ನಮ್ಮ ಕತ್ತೆಗಳನ್ನು ವಶಮಾಡಿಕೊಳ್ಳುವರು; ನಮ್ಮನ್ನೂ ಗುಲಾಮರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳುವರು” ಎಂದು ಮಾತಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ಆದ್ದರಿಂದ ಸಹೋದರರು ಯೋಸೇಫನ ಮನೆಯ ಮೇಲ್ವಿಚಾರಕನಾದ ಸೇವಕನ ಬಳಿಗೆ ಹೋಗಿ ಪ್ರವೇಶದ್ವಾರದ ಬಳಿಯಲ್ಲಿ ಅವನೊಂದಿಗೆ ಮಾತಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ಅವರು, “ಸ್ವಾಮೀ, ನಾವು ಪ್ರಮಾಣಮಾಡಿ ಹೇಳುತ್ತೇವೆ. ಇದು ಸತ್ಯ. ಕಳೆದ ಸಲ ನಾವು ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ಬಂದಿದ್ದೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","ಮನೆಗೆ ಹೋಗುವಾಗ ದಾರಿಯಲ್ಲಿ ನಾವು ನಮ್ಮ ಚೀಲಗಳನ್ನು ಬಿಚ್ಚಿದಾಗ ಪ್ರತಿಯೊಂದು ಚೀಲದಲ್ಲಿಯೂ ನಾವು ಪಾವತಿಮಾಡಿದ್ದ ಹಣವನ್ನು ಕಂಡೆವು. ಆ ಹಣವು ಅಲ್ಲಿಗೆ ಹೇಗೆ ಬಂತೋ ನಮಗೆ ಗೊತ್ತಿಲ್ಲ. ಆದರೆ ಆ ಹಣವನ್ನು ನಿಮಗೆ ಕೊಡುವುದಕ್ಕಾಗಿ ನಮ್ಮೊಂದಿಗೆ ತೆಗೆದುಕೊಂಡು ಬಂದಿದ್ದೇವೆ. ಈ ಸಲ ನಾವು ಖರೀದಿ ಮಾಡಬೇಕೆಂದಿರುವ ಆಹಾರಕ್ಕೆ ಕೊಡಲು ಹೆಚ್ಚು ಹಣವನ್ನು ತಂದಿದ್ದೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ಅದಕ್ಕೆ ಸೇವಕನು, “ಭಯಪಡಬೇಡಿ, ಚಿಂತಿಸಬೇಡಿ. ನಿಮ್ಮ ದೇವರೂ ನಿಮ್ಮ ತಂದೆಯ ದೇವರೂ ಹಣವನ್ನು ಉಡುಗೊರೆಯಾಗಿ ನಿಮ್ಮ ಚೀಲಗಳಲ್ಲಿ ಇಟ್ಟಿದ್ದಿರಬೇಕು. ಕಳೆದ ಸಲ ನೀವು ದವಸಧಾನ್ಯಗಳಿಗಾಗಿ ಹಣ ಪಾವತಿ ಮಾಡಿದ್ದು ನನಗೆ ನೆನಪಿದೆ” ಎಂದು ಹೇಳಿದನು. ಬಳಿಕ ಆ ಸೇವಕನು ಸಿಮೆಯೋನನನ್ನು ಸೆರೆಮನೆಯಿಂದ ಕರೆತಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ಸೇವಕನು ಅವರನ್ನು ಯೋಸೇಫನ ಮನೆಯೊಳಗೆ ಕರೆದುಕೊಂಡು ಹೋಗಿ ಅವರಿಗೆ ನೀರನ್ನು ಕೊಟ್ಟನು. ಅವರು ತಮ್ಮ ಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಂಡರು. ಬಳಿಕ ಅವನು ಅವರ ಕತ್ತೆಗಳಿಗೆ ಆಹಾರವನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ತಾವು ಯೋಸೇಫನೊಂದಿಗೆ ಊಟ ಮಾಡುವುದಾಗಿ ಸಹೋದರರಿಗೆ ತಿಳಿಯಿತು. ಆದ್ದರಿಂದ ಅವರು ಅವನಿಗೆ ಕೊಡಲು ತಮ್ಮ ಉಡುಗೊರೆಗಳನ್ನು ಮಧ್ಯಾಹ್ನದವರೆಗೆ ಸಿದ್ಧಪಡಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ಯೋಸೇಫನು ಮನೆಗೆ ಬಂದಾಗ, ಸಹೋದರರು ತಾವು ತಂದಿದ್ದ ಉಡುಗೊರೆಗಳನ್ನು ಅವನಿಗೆ ಕೊಟ್ಟರು. ಬಳಿಕ ಅವರು ನೆಲದವರೆಗೆ ಬಾಗಿ ನಮಸ್ಕರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ಯೋಸೇಫನು ಅವರ ಯೋಗಕ್ಷೇಮವನ್ನು ವಿಚಾರಿಸಿದನು. ಯೋಸೇಫನು “ನೀವು ನನಗೆ ತಿಳಿಸಿದ ನಿಮ್ಮ ವೃದ್ಧನಾದ ತಂದೆ ಕ್ಷೇಮವಾಗಿದ್ದಾನೆಯೇ? ಇನ್ನೂ ಜೀವಂತವಾಗಿರುವನೇ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ಸಹೋದರರು, “ಸ್ವಾಮೀ, ನಮ್ಮ ತಂದೆ ಕ್ಷೇಮವಾಗಿದ್ದಾನೆ. ಅವನು ಇನ್ನೂ ಜೀವಂತವಾಗಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದನು. ಬಳಿಕ ಅವರು ಮತ್ತೆ ಯೋಸೇಫನಿಗೆ ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ಬಳಿಕ ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರನಾದ ಬೆನ್ಯಾಮೀನನನ್ನು ನೋಡಿದನು. (ಬೆನ್ಯಾಮೀನ ಮತ್ತು ಯೋಸೇಫ ಒಂದೇ ತಾಯಿಯ ಮಕ್ಕಳು.) ಯೋಸೇಫನು, “ನೀವು ನನಗೆ ತಿಳಿಸಿದ ನಿಮ್ಮ ಕಿರಿಯ ತಮ್ಮನು ಇವನೋ?” ಎಂದು ಕೇಳಿದನು. ಆಮೇಲೆ ಯೋಸೇಫನು ಬೆನ್ಯಾಮೀನನಿಗೆ “ಮಗನೇ, ದೇವರು ನಿನಗೆ ಒಳ್ಳೆಯದನ್ನು ಮಾಡಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ಯೋಸೇಫನು ತನ್ನ ತಮ್ಮನಾದ ಬೆನ್ಯಾಮೀನನನ್ನು ಬಹಳವಾಗಿ ಪ್ರೀತಿಸುತ್ತಿದ್ದ ಕಾರಣ ಆನಂದದಿಂದ ಅವನ ಕಣ್ಣಲ್ಲಿ ನೀರು ಉಕ್ಕೇರಿ ಬಂದದ್ದರಿಂದ ಕೋಣೆಯೊಳಗೆ ಹೋಗಿ ಕಣ್ಣೀರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ಬಳಿಕ ಯೋಸೇಫನು ತನ್ನ ಮುಖವನ್ನು ತೊಳೆದುಕೊಂಡು ಮತ್ತು ಮನಸ್ಸನ್ನು ಬಿಗಿಹಿಡಿದುಕೊಂಡು ಬಂದು, “ಊಟ ಬಡಿಸಿರಿ” ಎಂದು ಅಪ್ಪಣೆಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ಯೋಸೇಫನೊಬ್ಬನೇ ಒಂದು ಮೇಜಿನಲ್ಲಿ ಊಟ ಮಾಡಿದನು. ಅವನ ಸಹೋದರರು ಒಟ್ಟಾಗಿ ಮತ್ತೊಂದು ಮೇಜಿನಲ್ಲಿ ಊಟ ಮಾಡಿದರು. ಈಜಿಪ್ಟಿನವರು ಬೇರೊಂದು ಮೇಜಿನಲ್ಲಿ ಊಟ ಮಾಡಿದರು. ಇಬ್ರಿಯ ಜನರೊಂದಿಗೆ ಊಟ ಮಾಡುವುದು ತಪ್ಪೆಂಬುದು ಅವರ ನಂಬಿಕೆಯಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ಯೋಸೇಫನ ಎದುರಿನ ಸಾಲಿನಲ್ಲಿ ಕುಳಿತುಕೊಳ್ಳಲು ಯೋಸೇಫನ ಸಹೋದರರಿಗೆ ಹಿರಿಯವನಿಂದ ಮೊದಲುಗೊಂಡು ಕಿರಿಯವನವರೆಗೆ ಕ್ರಮವಾಗಿ ಸ್ಥಳವನ್ನು ಗೊತ್ತುಪಡಿಸಲಾಗಿತ್ತು. ಆದ್ದರಿಂದ ಸಹೋದರರೆಲ್ಲಾ ಅತ್ಯಾಶ್ಚರ್ಯದಿಂದ ಒಬ್ಬರನ್ನೊಬ್ಬರು ನೋಡತೊಡಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ಸೇವಕರು ಯೋಸೇಫನ ಮೇಜಿನಿಂದ ಊಟವನ್ನು ತೆಗೆದುಕೊಂಡು ಅವರಿಗೆ ಬಡಿಸುತ್ತಿದ್ದರು. ಆದರೆ ಸೇವಕರು ಬೆನ್ಯಾಮೀನನಿಗೆ ಬೇರೆಯವರಿಗಿಂತ ಐದರಷ್ಟು ಹೆಚ್ಚಾಗಿ ಕೊಟ್ಟರು. ಸಹೋದರರು ಯಥೇಚ್ಛವಾಗಿ ಊಟ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ಬಳಿಕ ಯೋಸೇಫನು ತನ್ನ ಸೇವಕನಿಗೆ ಆಜ್ಞೆಮಾಡಿದನು. ಯೋಸೇಫನು, “ಈ ಜನರು ತೆಗೆದುಕೊಂಡು ಹೋಗಬಹುದಾದಷ್ಟು ದವಸಧಾನ್ಯಗಳನ್ನು ಇವರ ಚೀಲಗಳಲ್ಲಿ ತುಂಬಿ ಪ್ರತಿಯೊಬ್ಬನ ಹಣವನ್ನೂ ಧಾನ್ಯದೊಂದಿಗೆ ಚೀಲದಲ್ಲಿಡು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ಕಿರಿಯ ಸಹೋದರನ ಚೀಲದಲ್ಲಿಯೂ ಹಣವನ್ನು ಇಡು. ಅಲ್ಲದೆ ನನ್ನ ವಿಶೇಷವಾದ ಬೆಳ್ಳಿ ಬಟ್ಟಲನ್ನು ಸಹ ಅವನ ಚೀಲದಲ್ಲಿಡು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ಅಂತೆಯೇ ಸೇವಕನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ಮರುದಿನ ಮುಂಜಾನೆ ಸಹೋದರರನ್ನು ಮತ್ತು ಅವರ ಕತ್ತೆಗಳನ್ನು ಅವರ ದೇಶಕ್ಕೆ ಮರಳಿ ಕಳುಹಿಸಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ಅವರು ನಗರವನ್ನು ಬಿಟ್ಟುಹೋದ ಮೇಲೆ, ಯೋಸೇಫನು ತನ್ನ ಸೇವಕನಿಗೆ, “ಹೋಗು, ಆ ಜನರನ್ನು ಹಿಂಬಾಲಿಸು. ಅವರನ್ನು ತಡೆದು ಅವರಿಗೆ, ‘ನಾವು ನಿಮಗೆ ಒಳ್ಳೆಯವರಾಗಿದ್ದೆವು; ಆದರೆ ನೀವು ನಮಗೇಕೆ ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡಿದಿರಿ? ನನ್ನ ಒಡೆಯನ ಬೆಳ್ಳಿ ಬಟ್ಟಲನ್ನು ನೀವೇಕೆ ಕದ್ದುಕೊಂಡು ಬಂದಿರಿ? ");
INSERT INTO kan2010_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ಈ ಬಟ್ಟಲಿನಲ್ಲಿ ನನ್ನ ಒಡೆಯನು ಕುಡಿಯುತ್ತಾನೆ. ದೇವರಿಗೆ ಪ್ರಶ್ನೆಗಳನ್ನು ಕೇಳಲು ಅವನು ಈ ಬಟ್ಟಲನ್ನೇ ಉಪಯೋಗಿಸುವನು. ನೀವು ಅವನ ಬಟ್ಟಲನ್ನು ಕದ್ದುಕೊಂಡು ತಪ್ಪುಮಾಡಿದಿರಿ’ ಎಂದು ಹೇಳು” ಎಂಬುದಾಗಿ ತಿಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ಅಂತೆಯೇ ಸೇವಕನು ಸಹೋದರರನ್ನು ಹಿಂಬಾಲಿಸಿ ಅವರನ್ನು ತಡೆದು ನಿಲ್ಲಿಸಿದನು. ಯೋಸೇಫನು ಹೇಳಿದಂತೆಯೇ ಅವನು ಅವರಿಗೆ ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ಆದರೆ ಸಹೋದರರು ಸೇವಕನಿಗೆ, “ರಾಜ್ಯಪಾಲನು ಈ ರೀತಿ ಹೇಳುವುದೇಕೆ? ನಾವು ಇಂಥಾ ಕೃತ್ಯವನ್ನು ಮಾಡಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ಮೊದಲು ನಮ್ಮ ಚೀಲಗಳಲ್ಲಿ ಸಿಕ್ಕಿದ ಹಣವನ್ನು ನಾವು ಕಾನಾನ್ ದೇಶದಿಂದ ಮತ್ತೆ ತಂದುಕೊಟ್ಟೆವು. ಆದ್ದರಿಂದ ಖಂಡಿತವಾಗಿ ನಾವು ನಿನ್ನ ಒಡೆಯನ ಮನೆಯಿಂದ ಬೆಳ್ಳಿಯನ್ನಾಗಲಿ ಬಂಗಾರವನ್ನಾಗಲಿ ಕದ್ದುಕೊಂಡಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ನೀನು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲನ್ನು ನಮ್ಮ ಯಾರ ಚೀಲಗಳಲ್ಲಿ ಕಂಡರೂ, ಆ ವ್ಯಕ್ತಿಯು ಸಾಯಲಿ, ನೀನು ಅವನನ್ನು ಕೊಲ್ಲಬಹುದು; ನಾವು ನಿನ್ನ ಗುಲಾಮರಾಗಿರುವೆವು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ಕನು, “ನೀವು ಹೇಳಿದಂತೆಯೇ ಆಗಲಿ. ಆದರೆ ನಾನು ಅವನನ್ನು ಕೊಲ್ಲುವುದಿಲ್ಲ. ಯಾರಲ್ಲಿ ಬೆಳ್ಳಿಯ ಬಟ್ಟಲು ಸಿಕ್ಕುತ್ತದೊ ಅವನು ನನ್ನ ಗುಲಾಮನಾಗಿರಬೇಕು; ಉಳಿದವರು ಹೋಗಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ಬಳಿಕ ಅವರು ಅವಸರದಿಂದ ತಮ್ಮ ಚೀಲಗಳನ್ನು ನೆಲದ ಮೇಲಿಟ್ಟು ಬಿಚ್ಚಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ಸೇವಕನು ಚೀಲಗಳನ್ನು ಪರೀಕ್ಷಿಸಲು ಹಿರಿಯ ಸಹೋದರನಿಂದ ಆರಂಭಿಸಿ, ಕಿರಿಯವನಾದ ಬೆನ್ಯಾಮೀನನ ಚೀಲದಲ್ಲಿ ಆ ಬೆಳ್ಳಿಯ ಬಟ್ಟಲನ್ನು ಕಂಡುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ಸಹೋದರರು ತುಂಬ ದುಃಖದಿಂದ ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡು ತಮ್ಮ ಚೀಲಗಳನ್ನು ಮತ್ತೆ ಕತ್ತೆಗಳ ಮೇಲೇರಿಸಿಕೊಂಡು ನಗರಕ್ಕೆ ಹಿಂತಿರುಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ಯೆಹೂದ ಮತ್ತು ಅವನ ಸಹೋದರರು ಯೋಸೇಫನ ಮನೆಗೆ ಹಿಂತಿರುಗಿದಾಗ ಯೋಸೇಫನು ಇನ್ನೂ ಅಲ್ಲೇ ಇದ್ದನು. ಸಹೋದರರು ನೆಲದ ಮೇಲೆ ಬಿದ್ದು ತಲೆಬಾಗಿ ನಮಸ್ಕರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ಯೋಸೇಫನು ಅವರಿಗೆ, “ನೀವು ಹೀಗೇಕೆ ಮಾಡಿದಿರಿ? ನಾನು ಶಕುನ ನೋಡಿ ರಹಸ್ಯಗಳನ್ನು ತಿಳಿದುಕೊಳ್ಳಬಲ್ಲೆನೆಂಬುದು ನಿಮಗೆ ಗೊತ್ತಿರಲಿಲ್ಲವೇ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ಯೆಹೂದನು, “ಸ್ವಾಮಿ, ನಾವು ಹೇಳುವಂಥದ್ದು ಏನೂ ಇಲ್ಲ; ವಿವರಿಸಲು ಯಾವ ದಾರಿಯೂ ಇಲ್ಲ; ನಾವು ತಪ್ಪಿತಸ್ಥರಲ್ಲವೆಂದು ತೋರಿಸಲು ಯಾವ ಮಾರ್ಗವೂ ಇಲ್ಲ. ನಾವು ಮಾಡಿದ ಬೇರೊಂದು ಕಾರ್ಯದ ನಿಮಿತ್ತ ದೇವರು ನಮ್ಮನ್ನು ತಪ್ಪಿತಸ್ಥರೆಂದು ನಿರ್ಣಯಿಸಿದ್ದಾನೆ. ಆದ್ದರಿಂದ ನಾವೆಲ್ಲರೂ ಬೆನ್ಯಾಮೀನನೂ ನಿನಗೆ ಗುಲಾಮರಾಗಿರುವೆವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ಆದರೆ ಯೋಸೇಫನು, “ನಾನು ನಿಮ್ಮೆಲ್ಲರನ್ನು ಗುಲಾಮರನ್ನಾಗಿ ಮಾಡುವುದಿಲ್ಲ; ಬಟ್ಟಲನ್ನು ಕದ್ದುಕೊಂಡವನು ಮಾತ್ರ ನನ್ನ ಗುಲಾಮನಾಗಿರಬೇಕು; ಉಳಿದ ನೀವೆಲ್ಲರೂ ನಿಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ಸಮಾಧಾನದಿಂದ ಹೋಗಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ಆಗ ಯೆಹೂದನು ಯೋಸೇಫನ ಬಳಿಗೆ ಹೋಗಿ, “ಸ್ವಾಮಿ, ತಮ್ಮೊಂದಿಗೆ ಬಿಚ್ಚುಮನಸ್ಸಿನಿಂದ ಮಾತನಾಡಲು ದಯವಿಟ್ಟು ಅನುಮತಿಯಾಗಲಿ; ದಯವಿಟ್ಟು ನನ್ನ ಮೇಲೆ ಕೋಪಗೊಳ್ಳಬೇಡಿ. ನೀವು ಸ್ವತಃ ಫರೋಹನಂತೆ ಇರುವಿರೆಂದು ನನಗೆ ತಿಳಿದಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ನಾವು ಮೊದಲನೆಯ ಸಲ ಬಂದಿದ್ದಾಗ, ನೀವು ನಮಗೆ, ‘ನಿಮಗೆ ತಂದೆಯಾಗಲಿ ತಮ್ಮನಾಗಲಿ ಇರುವನೇ?’ ಎಂದು ಕೇಳಿದಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ನಾವು ನಿಮಗೆ, ‘ನಮಗೆ ಒಬ್ಬ ತಂದೆಯಿದ್ದಾನೆ, ಅವನು ವೃದ್ಧನಾಗಿದ್ದಾನೆ; ನಮಗೆ ಪ್ರಾಯದ ತಮ್ಮನಿದ್ದಾನೆ, ನಮ್ಮ ತಂದೆಗೆ ತುಂಬ ವಯಸ್ಸಾಗಿದ್ದಾಗ ಅವನು ಹುಟ್ಟಿದ್ದರಿಂದ ನಮ್ಮ ತಂದೆಯು ಅವನನ್ನು ಪ್ರೀತಿಸುತ್ತಾನೆ. ಆ ಕಿರಿಯ ಮಗನ ಸಹೋದರನು ಸತ್ತುಹೋದನು. ಆದ್ದರಿಂದ ಆ ತಾಯಿಯಲ್ಲಿ ಹುಟ್ಟಿದವರಲ್ಲಿ ಇವನೊಬ್ಬನೇ ಉಳಿದಿದ್ದಾನೆ. ನಮ್ಮ ತಂದೆಯು ಅವನನ್ನು ತುಂಬಾ ಪ್ರೀತಿಸುವನು’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ಬಳಿಕ ನೀವು ನಮಗೆ, ‘ಹಾಗಾದರೆ ಆ ಸಹೋದರನನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬನ್ನಿ, ನಾನು ಅವನನ್ನು ನೋಡಬೇಕು’ ಎಂದು ಹೇಳಿದಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ನಾವು ನಿಮಗೆ ‘ಆ ಯುವಕನು ಬರಲಾರನು. ಅವನು ತನ್ನ ತಂದೆಯನ್ನು ಬಿಟ್ಟುಬರಲಾಗದು. ಅವನ ತಂದೆ ಅವನನ್ನು ಕಳೆದುಕೊಂಡರೆ ತುಂಬ ದುಃಖದಿಂದ ಸತ್ತುಹೋಗುವನು’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ಆದರೆ ನೀವು ನಮಗೆ, ‘ನೀವು ಆ ಕಿರಿಯ ಸಹೋದರನನ್ನು ಕರೆದುಕೊಂಡು ಬರಲೇಬೇಕು; ಇಲ್ಲವಾದರೆ, ನಾನು ನಿಮಗೆ ದವಸಧಾನ್ಯಗಳನ್ನು ಮತ್ತೆ ಮಾರುವುದಿಲ್ಲ’ ಎಂದು ಹೇಳಿದಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ಆದ್ದರಿಂದ ನಾವು ನಮ್ಮ ತಂದೆಯ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಿ ನೀವು ಹೇಳಿದ್ದನ್ನು ಅವನಿಗೆ ತಿಳಿಸಿದೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“ಸ್ವಲ ಸಮಯದ ನಂತರ ನಮ್ಮ ತಂದೆಯು, ‘ಮತ್ತೆ ಹೋಗಿ ಇನ್ನು ಸ್ವಲ್ಪ ಆಹಾರವನ್ನು ನಮಗಾಗಿ ಕೊಂಡುಕೊಂಡು ಬನ್ನಿ’ ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ಆದರೆ ನಾವು ನಮ್ಮ ತಂದೆಗೆ, ‘ನಮ್ಮ ಕಿರಿಯ ತಮ್ಮನಿಲ್ಲದೆ ನಾವು ಹೋಗಲು ಸಾಧ್ಯವಿಲ್ಲ. ನಮ್ಮ ಕಿರಿಯ ತಮ್ಮನನ್ನು ನೋಡುವ ತನಕ, ನಮಗೆ ದವಸಧಾನ್ಯಗಳನ್ನು ಮಾರುವುದಿಲ್ಲ ಎಂದು ರಾಜ್ಯಪಾಲರು ಹೇಳಿದ್ದಾರೆ’ ಎಂದು ಹೇಳಿದೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ಆಗ ನಮ್ಮ ತಂದೆಯು ನಮಗೆ, ‘ನನ್ನ ಹೆಂಡತಿಯಾದ ರಾಹೇಲಳು ನನಗೆ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳನ್ನು ಕೊಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ನಾನು ಒಬ್ಬ ಮಗನನ್ನು ಕಳುಹಿಸಿಕೊಟ್ಟಾಗ, ಅವನು ಕ್ರೂರ ಪ್ರಾಣಿಯಿಂದ ಕೊಲ್ಲಲ್ಪಟ್ಟನು; ಇಂದಿನ ತನಕ ನಾನು ಅವನನ್ನು ನೋಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ನೀವು ನನ್ನ ಮತ್ತೊಬ್ಬ ಮಗನನ್ನು ನನ್ನ ಬಳಿಯಿಂದ ಕರೆದುಕೊಂಡು ಹೋಗುವಾಗ ಅವನಿಗೆ ಏನಾದರೂ ಸಂಭವಿಸಿದರೆ, ನಾನು ದುಃಖ ತಾಳಲಾರದೆ ಸತ್ತುಹೋಗುವೆನು’ ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ನಮ್ಮ ತಂದೆಗಂತೂ ಇವನನ್ನು ಕಂಡರೆ ಪ್ರಾಣಪ್ರೀತಿ. ಆದ್ದರಿಂದ ನಮ್ಮ ಈ ಕಿರಿಯ ತಮ್ಮನಿಲ್ಲದೆ ಹೋದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ನಮ್ಮ ತಂದೆಯೂ ಆ ಕೂಡಲೇ ಸತ್ತುಹೋಗುವನು; ನಮ್ಮ ತಂದೆ ದುಃಖದಿಂದ ಸಾಯಲು ನಾವೇ ಕಾರಣರಾಗುವೆವು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“ನಾನು ಈ ಯುವಕನ ಜವಾಬ್ದಾರಿಯನ್ನು ವಹಿಸಿಕೊಂಡೆನು. ನಾನು ನನ್ನ ತಂದೆಗೆ, ‘ನಾನು ಇವನನ್ನು ಹಿಂದಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬರದಿದ್ದರೆ ನನ್ನ ಜೀವಮಾನವೆಲ್ಲಾ ನೀನು ನನ್ನನ್ನು ದೂಷಿಸಬಹುದು’ ಎಂದು ಹೇಳಿದೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","ಆದ್ದರಿಂದ ನಾನು ನಿಮ್ಮನ್ನು ಬೇಡಿಕೊಳ್ಳುವುದೇನೆಂದರೆ, ಈ ಯುವಕನು ತನ್ನ ಸಹೋದರರೊಂದಿಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಲಿ; ನಾನು ಇಲ್ಲಿ ನಿಮಗೆ ಗುಲಾಮನಾಗಿರುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ನನ್ನ ಜೊತೆಯಲ್ಲಿ ಈ ಹುಡುಗನಿಲ್ಲದೆ ನಾನು ನನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಹೋಗಲು ಸಾಧ್ಯವಿಲ್ಲ. ನಮ್ಮ ತಂದೆಗೆ ಸಂಭವಿಸುವುದನ್ನು ನೋಡಲು ನನಗೆ ತುಂಬ ಭಯವಾಗಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ಯೋಸೇಫನು ಇದನ್ನು ಕೇಳಿ ತನ್ನ ಎದುರಿನಲ್ಲಿದ್ದವರ ಮುಂದೆ ತಾಳಿಕೊಳ್ಳಲಾರದೆ, “ಇಲ್ಲಿರುವ ಎಲ್ಲರನ್ನೂ ಹೊರಗೆ ಕಳುಹಿಸಿರಿ” ಎಂದು ಅಪ್ಪಣೆಕೊಟ್ಟನು. ಅಲ್ಲಿದ್ದವರು ಹೊರಗೆ ಹೋದರು; ಸಹೋದರರು ಮಾತ್ರ ಯೋಸೇಫನೊಡನೆ ಇದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ಆಮೇಲೆ ಯೋಸೇಫನು ಗಟ್ಟಿಯಾಗಿ ಅತ್ತನು. ಫರೋಹನ ಮನೆಯಲ್ಲಿದ್ದ ಈಜಿಪ್ಟಿನವರೆಲ್ಲ ಅದನ್ನು ಕೇಳಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರಿಗೆ, “ನಾನು ನಿಮ್ಮ ತಮ್ಮನಾದ ಯೋಸೇಫ. ನನ್ನ ತಂದೆ ಚೆನ್ನಾಗಿದ್ದಾನೆಯೇ?” ಎಂದು ಕೇಳಿದನು. ಆದರೆ ಸಹೋದರರು ಅವನಿಗೆ ಉತ್ತರಿಸಲಿಲ್ಲ. ಅವರಿಗೆ ಭಯವಾಗಿತ್ತು ಮತ್ತು ಗಲಿಬಿಲಿಗೊಂಡಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ಯೋಸೇಫನು ಮತ್ತೆ ತನ್ನ ಸಹೋದರರಿಗೆ, “ನನ್ನ ಬಳಿಗೆ ಬನ್ನಿ. ನನ್ನ ಹತ್ತಿರ ಬನ್ನಿ ಎಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಸಹೋದರರು ಯೋಸೇಫನ ಹತ್ತಿರ ಹೋದರು. ಯೋಸೇಫನು ಅವರಿಗೆ, “ನಾನು ನಿಮ್ಮ ತಮ್ಮನಾದ ಯೋಸೇಫ. ನೀವು ಈಜಿಪ್ಟಿನವರಿಗೆ ಯಾವನನ್ನು ಗುಲಾಮನನ್ನಾಗಿ ಮಾರಿದಿರೋ ಅವನೇ ನಾನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ಈಗ ಚಿಂತಿಸಬೇಡಿ, ನೀವು ಮಾಡಿದ್ದಕ್ಕೆ ದುಃಖವನ್ನೂ ಪಡಬೇಡಿ. ನಾನು ಇಲ್ಲಿಗೆ ಬರಬೇಕೆಂಬುದು ದೇವರ ಯೋಜನೆಯಾಗಿತ್ತು. ನಾನು ನಿಮ್ಮನ್ನು ರಕ್ಷಿಸಲು ಇಲ್ಲಿಗೆ ಬಂದಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ಈ ಭೀಕರವಾದ ಬರಗಾಲವು ಆರಂಭವಾಗಿ ಈಗಾಗಲೇ ಎರಡು ವರ್ಷಗಳಾಯಿತು. ಇನ್ನೂ ಐದು ವರ್ಷಗಳವರೆಗೆ ಬಿತ್ತನೆ ಇರುವುದಿಲ್ಲ; ಸುಗ್ಗಿಯೂ ಇರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ಆದ್ದರಿಂದ ಈ ದೇಶದಲ್ಲಿ ತನ್ನ ಜನರನ್ನು ಕಾಪಾಡಲು ದೇವರು ನನ್ನನ್ನು ನಿಮಗಿಂತ ಮೊದಲೇ ಇಲ್ಲಿಗೆ ಕಳುಹಿಸಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ನನ್ನನ್ನು ಇಲ್ಲಿಗೆ ಕಳುಹಿಸಿದ್ದು ನಿಮ್ಮ ತಪ್ಪಲ್ಲ. ಅದು ದೇವರ ಯೋಜನೆ. ದೇವರು ನನ್ನನ್ನು ಫರೋಹನ ಅತ್ಯುನ್ನತವಾದ ಅಧಿಕಾರಿಯನ್ನಾಗಿ ಮಾಡಿದ್ದಾನೆ. ನಾನು ಅವನ ಮನೆಗೆಲ್ಲಾ ಮತ್ತು ಈಜಿಪ್ಟಿಗೆಲ್ಲಾ ರಾಜ್ಯಪಾಲನಾಗಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ಬಳಿಕ ಯೋಸೇಫನು, “ನನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಬೇಗನೆ ಹೋಗಿ ಅವನಿಗೆ, ನಿನ್ನ ಮಗನಾದ ಯೋಸೇಫನು ಈ ಸಂದೇಶವನ್ನು ಕಳುಹಿಸಿದ್ದಾನೆ: ‘ದೇವರು ನನ್ನನ್ನು ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆಲ್ಲಾ ರಾಜ್ಯಪಾಲನನ್ನಾಗಿ ಮಾಡಿದ್ದಾನೆ. ತಡಮಾಡದೆ ನನ್ನ ಬಳಿಗೆ ಬಾ. ");
INSERT INTO kan2010_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ನೀನು ಗೋಷೆನ್ ಪ್ರಾಂತ್ಯದಲ್ಲಿ ನನ್ನೊಂದಿಗೆ ವಾಸಿಸುವೆ. ನೀನೂ ನಿನ್ನ ಮಕ್ಕಳೂ ನಿನ್ನ ಮೊಮ್ಮಕ್ಕಳೂ ನಿಮ್ಮ ಎಲ್ಲಾ ಪಶುಗಳೊಡನೆ ಇಲ್ಲಿ ನೆಲೆಸಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ಮುಂದಿನ ಐದು ವರ್ಷಗಳ ಬರಗಾಲದಲ್ಲಿ ನಾನು ನಿಮ್ಮನ್ನು ಪೋಷಿಸುವೆನು. ಆಗ ನಿನಗಾಗಲಿ ನಿನ್ನ ಕುಟುಂಬದವರಿಗಾಗಲಿ ಬಡತನವಿರುವುದಿಲ್ಲ’ ಎಂಬುದಾಗಿ ತಿಳಿಸಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರೊಂದಿಗೆ ಮಾತನ್ನು ಮುಂದುವರಿಸಿ, “ನಾನೇ ಯೋಸೇಫನೆಂದು ನಿಮಗೆ ಈಗ ಗೊತ್ತಾಗಿದೆ; ನಿಮ್ಮ ತಮ್ಮನಾದ ಬೆನ್ಯಾಮೀನನಿಗೂ ಗೊತ್ತಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ಆದ್ದರಿಂದ ಈಜಿಪ್ಟಿನಲ್ಲಿರುವ ಮಹಾ ಐಶ್ವರ್ಯವನ್ನೂ ನೀವು ಇಲ್ಲಿ ನೋಡಿರುವ ಪ್ರತಿಯೊಂದನ್ನೂ ನನ್ನ ತಂದೆಗೆ ತಿಳಿಸಿ ಬೇಗನೆ ಅವನನ್ನು ಕರೆದುಕೊಂಡು ಬನ್ನಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ಆಮೇಲೆ ಯೋಸೇಫನು ತನ್ನ ತಮ್ಮನಾದ ಬೆನ್ಯಾಮೀನನನ್ನು ಅಪ್ಪಿಕೊಂಡು ಅತ್ತನು. ಬೆನ್ಯಾಮೀನನು ಸಹ ಅತ್ತನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ಆಮೇಲೆ ಯೋಸೇಫನು ತನ್ನ ಎಲ್ಲಾ ಸಹೋದರರಿಗೂ ಮುದ್ದಿಟ್ಟು ಅತ್ತನು. ಇದಾದ ಮೇಲೆ ಆ ಸಹೋದರರು ಅವನೊಂದಿಗೆ ಮಾತಾಡತೊಡಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ಯೋಸೇಫನ ಸಹೋದರರು ಅವನ ಬಳಿಗೆ ಬಂದಿರುವುದು ತಿಳಿದಾಗ ಫರೋಹನಿಗೂ ಅವನ ಮನೆಯವರಿಗೂ ತುಂಬ ಸಂತೋಷವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ಆದ್ದರಿಂದ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ತಮಗೆ ಬೇಕಾದ ಎಲ್ಲಾ ಆಹಾರವನ್ನು ತೆಗೆದುಕೊಂಡು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಹಿಂತಿರುಗಿ ಹೋಗಿ ");
INSERT INTO kan2010_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ನಿನ್ನ ತಂದೆಯನ್ನೂ ತಮ್ಮ ಕುಟುಂಬಗಳನ್ನೂ ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಲಿ. ಅವರು ಈಜಿಪ್ಟಿನ ಒಳ್ಳೆಯ ಪ್ರದೇಶದಲ್ಲಿ ವಾಸಿಸಲಿ. ಇಲ್ಲಿರುವ ಉತ್ತಮವಾದ ಆಹಾರವನ್ನು ಅವರು ಊಟಮಾಡಲಿ, ");
INSERT INTO kan2010_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ಅವರು ನಮ್ಮ ಶ್ರೇಷ್ಠವಾದ ರಥಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಹೋಗಿ ನಿನ್ನ ತಂದೆಯನ್ನೂ ಎಲ್ಲಾ ಸ್ತ್ರೀಯರನ್ನೂ ಮಕ್ಕಳನ್ನೂ ಕರೆದುಕೊಂಡು ಬರಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ಅವರ ಸ್ವತ್ತುಗಳ ಬಗ್ಗೆ ಚಿಂತಿಸುವುದು ಬೇಡ; ಈಜಿಪ್ಟಿನಲ್ಲಿ ನಮಗಿರುವ ಉತ್ತಮವಾದವುಗಳನ್ನು ಅವರಿಗೆ ಕೊಡೋಣ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ಅಂತೆಯೇ ಇಸ್ರೇಲನ ಮಕ್ಕಳು ಮಾಡಿದರು. ಫರೋಹನು ಹೇಳಿದಂತೆಯೇ ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರಿಗೆ ಒಳ್ಳೆಯ ರಥಗಳನ್ನೂ ಪ್ರಯಾಣಕ್ಕೆ ಬೇಕಾಗುವಷ್ಟು ಆಹಾರವನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ಯೋಸೇಫನು ಪ್ರತಿಯೊಬ್ಬ ಸಹೋದರನಿಗೂ ಒಂದೊಂದು ಜೊತೆ ಸುಂದರವಾದ ಉಡುಪುಗಳನ್ನು ಕೊಟ್ಟನು. ಆದರೆ ಬೆನ್ಯಾಮೀನನಿಗೆ ಮಾತ್ರ ಐದು ಜೊತೆ ಸುಂದರವಾದ ಉಡುಪುಗಳನ್ನೂ ಮುನ್ನೂರು ಬೆಳ್ಳಿಯ ನಾಣ್ಯಗಳನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೂ ಉಡುಗೊರೆಗಳನ್ನು ಕಳುಹಿಸಿದನು. ಅವನು ಈಜಿಪ್ಟಿನ ಶ್ರೇಷ್ಠವಾದ ವಸ್ತುಗಳನ್ನು ಹತ್ತು ಕತ್ತೆಗಳ ಮೇಲೆ ಕಳುಹಿಸಿದನು. ತನ್ನ ತಂದೆಯ ಮರುಪ್ರಯಾಣಕ್ಕೆ ಬೇಕಾದ ಕಾಳು, ರೊಟ್ಟಿ ಮತ್ತು ಇತರ ಆಹಾರಪದಾರ್ಥಗಳನ್ನೂ ಹತ್ತು ಹೆಣ್ಣುಕತ್ತೆಗಳ ಮೇಲೆ ಹೊರಿಸಿ ಕಳುಹಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ಅವರು ಹೊರಡುವಾಗ ಯೋಸೇಫನು, “ನೇರವಾಗಿ ಮನೆಗೆ ಹೋಗಿ. ದಾರಿಯಲ್ಲಿ ಜಗಳ ಮಾಡಬೇಡಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ಆದ್ದರಿಂದ ಸಹೋದರರು ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟು, ತಮ್ಮ ತಂದೆಯಿರುವ ಕಾನಾನ್ ದೇಶಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ಸಹೋದರರು ತಮ್ಮ ತಂದೆಗೆ, “ಅಪ್ಪಾ, ಯೋಸೇಫನು ಇನ್ನೂ ಬದುಕಿದ್ದಾನೆ; ಅವನು ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆಲ್ಲಾ ರಾಜ್ಯಪಾಲನಾಗಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದರು. ಅವರ ತಂದೆಗೆ ಆಶ್ಚರ್ಯವಾಯಿತು. ಆತನು ಅವರನ್ನು ನಂಬಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ಆದರೆ ಯೋಸೇಫನು ತಮಗೆ ಹೇಳಿದ್ದೆಲ್ಲವನ್ನು ಸಹೋದರರು ತಮ್ಮ ತಂದೆಗೆ ಹೇಳಿದರು. ಆಮೇಲೆ ತನ್ನನ್ನು ಈಜಿಪ್ಟಿಗೆ ಕರೆದುಕೊಂಡು ಬರಲು ಯೋಸೇಫನು ಕಳುಹಿಸಿದ್ದ ರಥಗಳನ್ನು ಯಾಕೋಬನು ನೋಡಿ ಉಲ್ಲಾಸಪಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ಇಸ್ರೇಲನು, “ಈಗ ನಾನು ನಿಮ್ಮನ್ನು ನಂಬುತ್ತೇನೆ. ನನ್ನ ಮಗನಾದ ಯೋಸೇಫನು ಇನ್ನೂ ಬದುಕಿದ್ದಾನೆ. ನಾನು ಸಾಯುವ ಮೊದಲು ಅವನನ್ನು ನೋಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ಆದ್ದರಿಂದ ಇಸ್ರೇಲನು ಈಜಿಪ್ಟಿಗೆ ಪ್ರಯಾಣ ಬೆಳೆಸಿದನು. ಅವನು ಬೇರ್ಷೆಬಕ್ಕೆ ಹೋಗಿ ತನ್ನ ತಂದೆಯಾದ ಇಸಾಕನ ದೇವರನ್ನು ಆರಾಧಿಸಿ ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ಆ ರಾತ್ರಿ ದೇವರು ಕನಸಿನಲ್ಲಿ ಅವನೊಂದಿಗೆ ಮಾತನಾಡಿದನು. ದೇವರು ಅವನನ್ನು, “ಯಾಕೋಬನೇ, ಯಾಕೋಬನೇ” ಎಂದು ಕರೆದನು. ಅದಕ್ಕೆ ಇಸ್ರೇಲನು, “ಇಗೋ, ಇದ್ದೇನೆ” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ದೇವರು ಅವನಿಗೆ, “ನಾನೇ ದೇವರು, ನಾನೇ ನಿನ್ನ ತಂದೆಯ ದೇವರು. ನೀನು ಈಜಿಪ್ಟಿಗೆ ಹೋಗಲು ಹೆದರಬೇಡ. ಈಜಿಪ್ಟಿನಲ್ಲಿ ನಿನ್ನನ್ನು ದೊಡ್ಡ ಜನಾಂಗವನ್ನಾಗಿ ಮಾಡುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ನಾನು ನಿನ್ನೊಂದಿಗೆ ಈಜಿಪ್ಟಿಗೆ ಬರುವೆನು. ಬಳಿಕ ನಾನೇ ನಿನ್ನನ್ನು ಮತ್ತೆ ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬರುವೆನು. ನೀನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಮರಣ ಹೊಂದಿದರೂ ಯೋಸೇಫನು ನಿನ್ನ ಸಂಗಡವಿರುವನು. ನೀನು ಸತ್ತಾಗ ಅವನು ತನ್ನ ಕೈಗಳಿಂದ ನಿನ್ನ ಕಣ್ಣುಗಳನ್ನು ಮುಚ್ಚುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ಆಮೇಲೆ ಯಾಕೋಬನು ಬೇರ್ಷೆಬವನ್ನು ಬಿಟ್ಟು ಈಜಿಪ್ಟಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದನು. ಇಸ್ರೇಲನ ಗಂಡುಮಕ್ಕಳು ತಮ್ಮ ತಂದೆಯನ್ನೂ ತಮ್ಮ ಹೆಂಡತಿಯರನ್ನೂ ತಮ್ಮ ಎಲ್ಲಾ ಮಕ್ಕಳನ್ನೂ ಕರೆದುಕೊಂಡು ಹೋದರು. ಫರೋಹನು ಕಳುಹಿಸಿದ್ದ ರಥಗಳಲ್ಲಿ ಅವರು ಪ್ರಯಾಣ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ಇದಲ್ಲದೆ ಅವರು ತಮ್ಮ ದನಕರುಗಳನ್ನೂ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ತಾವು ಹೊಂದಿದ್ದ ಪ್ರತಿಯೊಂದನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹೋದರು. ಹೀಗೆ ಇಸ್ರೇಲನು ತನ್ನ ಎಲ್ಲಾ ಮಕ್ಕಳೊಂದಿಗೆ ಮತ್ತು ತನ್ನ ಕುಟುಂಬದೊಂದಿಗೆ ಈಜಿಪ್ಟಿಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ಅವನ ಜೊತೆಯಲ್ಲಿ ಅವನ ಗಂಡುಮಕ್ಕಳು, ಹೆಣ್ಣುಮಕ್ಕಳು ಮತ್ತು ಮೊಮ್ಮಕ್ಕಳು ಇದ್ದರು. ಅವನ ಸಂಸಾರದವರೆಲ್ಲ ಅವನ ಜೊತೆ ಈಜಿಪ್ಟಿಗೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ಇಸ್ರೇಲನ ಸಂಗಡ ಈಜಿಪ್ಟಿಗೆ ಹೋದ ಅವನ ಮಕ್ಕಳ ಮತ್ತು ಕುಟುಂಬದವರ ಹೆಸರುಗಳು ಇಂತಿವೆ: ಯಾಕೋಬನ ಮೊದಲನೆಯ ಮಗ ರೂಬೇನನು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ರೂಬೇನನ ಮಕ್ಕಳು: ಹನೋಕ್, ಫಲ್ಲೂ, ಹೆಚ್ರೋನ್ ಮತ್ತು ಕರ್ಮೀ. ");
INSERT INTO kan2010_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ಸಿಮೆಯೋನನ ಮಕ್ಕಳು: ಯೆಮೂವೇಲ್, ಯಾಮೀನ್, ಓಹದ್, ಯಾಕೀನ್, ಚೋಹರ್ ಮತ್ತು ಕಾನಾನ್ಯ ಸ್ತ್ರೀಯಲ್ಲಿ ಹುಟ್ಟಿದ ಸೌಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ಲೇವಿಯ ಮಕ್ಕಳು: ಗೇರ್ಷೋನ್, ಕೆಹಾತ್ ಮತ್ತು ಮೆರಾರೀ. ");
INSERT INTO kan2010_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ಯೆಹೂದನ ಮಕ್ಕಳು: ಏರ್, ಓನಾನ್, ಶೇಲಾಹ, ಪೆರೆಚ್ ಮತ್ತು ಜೆರಹ. (ಏರ್ ಮತ್ತು ಓನಾನ್ ಕಾನಾನಿನಲ್ಲಿ ಇರುವಾಗಲೇ ಸತ್ತುಹೋದರು.) ಪೆರೆಚನ ಮಕ್ಕಳು: ಹೆಚ್ರೋನ್ ಮತ್ತು ಹಾಮೂಲ್. ");
INSERT INTO kan2010_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ಇಸ್ಸಾಕಾರನ ಮಕ್ಕಳು: ತೋಲಾ, ಪುವ್ವಾ, ಯೋಬ್ ಮತ್ತು ಶಿಮ್ರೋನ್. ");
INSERT INTO kan2010_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ಜೆಬೂಲೂನನ ಮಕ್ಕಳು: ಸೆರೆದ್, ಏಲೋನ್, ಯಹ್ಲೇಲ್. ");
INSERT INTO kan2010_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ರೂಬೇನ್, ಸಿಮೆಯೋನ್, ಲೇವಿ, ಯೆಹೂದ, ಇಸ್ಸಾಕಾರ್ ಮತ್ತು ಜೆಬುಲೂನ್. ಇವರು ಯಾಕೋಬನ ಹೆಂಡತಿಯಾದ ಲೇಯಳ ಮಕ್ಕಳು. ಲೇಯಳು ಆ ಮಕ್ಕಳಿಗೆ ಪದ್ದನ್‌ಅರಾಮಿನಲ್ಲಿ ಜನ್ಮಕೊಟ್ಟಳು. ಅಲ್ಲಿ ಅವಳ ಮಗಳಾದ ದೀನ ಸಹ ಜನಿಸಿದಳು. ಈ ಕುಟುಂಬದಲ್ಲಿ ಮೂವತ್ಮೂರು ಮಂದಿ ಇದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ಗಾದನ ಮಕ್ಕಳು: ಚಿಪ್ಯೋನ್, ಹಗ್ಗೀ, ಶೂನೀ, ಎಚ್ಬೋನ್, ಏರೀ, ಅರೋದೀ ಮತ್ತು ಅರೇಲೀ. ");
INSERT INTO kan2010_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ಆಶೇರನ ಮಕ್ಕಳು: ಇಮ್ನಾ, ಇಷ್ವಾ, ಇಷ್ವೀ, ಬೆರೀಗಾ ಮತ್ತು ಇವರ ತಂಗಿಯಾದ ಸೆರಹ. ಬೆರೀಗನ ಗಂಡುಮಕ್ಕಳು: ಹೆಬೆರ್ ಮತ್ತು ಮಲ್ಕೀಯೇಲ್. ");
INSERT INTO kan2010_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ಲೇಯಳಿಗೆ ಜಿಲ್ಪ ಎಂಬ ದಾಸಿಯನ್ನು ಕೊಟ್ಟಿದ್ದನು. ಲೇಯಾಳು ಜಿಲ್ಪಳನ್ನು ಯಾಕೋಬನಿಗೆ ಕೊಟ್ಟಿದ್ದಳು. ಜಿಲ್ಪಳ ಕುಟುಂಬದಲ್ಲಿ ಒಟ್ಟು ಹದಿನಾರು ಮಂದಿಯಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ಬೆನ್ಯಾಮೀನನು ಸಹ ಯಾಕೋಬನೊಂದಿಗಿದ್ದನು. ಬೆನ್ಯಾಮೀನನು ಯಾಕೋಬ ಮತ್ತು ರಾಹೇಲಳ ಮಗನು. (ಯೋಸೇಫನು ಸಹ ರಾಹೇಲಳ ಮಗ. ಆದರೆ ಯೋಸೇಫನು ಈಗಾಗಲೇ ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದನು.) ");
INSERT INTO kan2010_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ಈಜಿಪ್ಟಿನಲ್ಲಿ ಯೋಸೇಫನಿಗೆ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ಅವರು ಯಾರೆಂದರೆ: ಮನಸ್ಸೆ ಮತ್ತು ಎಫ್ರಾಯೀಮ್. (ಯೋಸೇಫನ ಹೆಂಡತಿ “ಆಸನತ್” ಈಕೆ ಓನ್ ಪಟ್ಟಣದ ಆಚಾರ್ಯನಾಗಿದ್ದ ಫೋಟೀಫರನ ಮಗಳು.) ");
INSERT INTO kan2010_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ಬೆನ್ಯಾಮೀನನ ಗಂಡುಮಕ್ಕಳು: ಬಿಳಾ, ಬೆಕೆರ್, ಅಶ್ಬೇಲ್, ಗೇರಾ, ನಾಮಾನ್, ಎಹೀರೋಷ್, ಮುಪ್ಪೀಮ್, ಹುಪ್ಪೀಮ್ ಮತ್ತು ಆರ್ದ್. ");
INSERT INTO kan2010_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ಇವರೆಲ್ಲರು ಯಾಕೋಬನ ಹೆಂಡತಿಯಾದ ರಾಹೇಲಳ ಕುಟುಂಬದವರು. ಈ ಕುಟುಂಬದಲ್ಲಿ ಒಟ್ಟು ಹದಿನಾಲ್ಕು ಮಂದಿಯಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ದಾನನ ಗಂಡುಮಕ್ಕಳು: ಹುಶೀಮ್. ");
INSERT INTO kan2010_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ನಫ್ತಾಲಿಯನ ಗಂಡುಮಕ್ಕಳು: ಯಹೇಲ್, ಗೂನೀ, ಯೇಚೆರ್ ಮತ್ತು ಶಿಲ್ಲೇಮ್. ");
INSERT INTO kan2010_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ಇವರೆಲ್ಲರು ಬಿಲ್ಹಳ ಕುಟುಂಬದವರು. (ಲಾಬಾನನು ತನ್ನ ಮಗಳಾದ ರಾಹೇಲಳಿಗೆ ಕೊಟ್ಟ ದಾಸಿಯೇ ಬಿಲ್ಹ. ರಾಹೇಲಳು ಈ ದಾಸಿಯನ್ನು ಯಾಕೋಬನಿಗೆ ಕೊಟ್ಟಿದ್ದಳು.) ಈ ಕುಟುಂಬದಲ್ಲಿ ಒಟ್ಟು ಏಳು ಮಂದಿಯಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ಯಾಕೋಬನಿಂದಲೇ ಹುಟ್ಟಿದ ಅರವತ್ತಾರು ಮಂದಿ ಈಜಿಪ್ಟಿಗೆ ಹೋದರು. (ಯಾಕೋಬನ ಸೊಸೆಯರನ್ನು ಇಲ್ಲಿ ಸೇರಿಸಿಲ್ಲ.) ");
INSERT INTO kan2010_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ಅಲ್ಲಿ ಯೋಸೇಫನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳು ಸಹ ಇದ್ದರು. ಅವರು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಹುಟ್ಟಿದವರು. ಆದ್ದರಿಂದ ಈಜಿಪ್ಟಿಗೆ ಬಂದ ಯಾಕೋಬನ ಕುಟುಂಬದವರು ಒಟ್ಟು ಎಪ್ಪತ್ತು ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ಯಾಕೋಬನು ಮೊದಲು ಯೆಹೂದನನ್ನು ಯೋಸೇಫನ ಬಳಿಗೆ ಕಳುಹಿಸಿದನು. ಗೋಷೆನ್ ಪ್ರಾಂತ್ಯದಲ್ಲಿ ಯೆಹೂದನು ಯೋಸೇಫನ ಬಳಿಗೆ ಹೋದನು. ಆಮೇಲೆ ಯಾಕೋಬ ಮತ್ತು ಅವನ ಮಕ್ಕಳು ಆ ಪ್ರಾಂತ್ಯಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ತನ್ನ ತಂದೆಯು ಸಮೀಪಿಸುತ್ತಿರುವುದು ಯೋಸೇಫನಿಗೆ ತಿಳಿಯಿತು. ಆದ್ದರಿಂದ ಅವನು ತನ್ನ ತಂದೆಯಾದ ಇಸ್ರೇಲನನ್ನು ಗೋಷೆನಿನಲ್ಲಿ ಭೇಟಿಯಾಗಲು ತನ್ನ ರಥವನ್ನು ಸಿದ್ಧಪಡಿಸಿಕೊಂಡು ಹೋದನು. ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯನ್ನು ಕಂಡಾಗ ಅವನನ್ನು ಅಪ್ಪಿಕೊಂಡು ಬಹಳ ಹೊತ್ತಿನ ತನಕ ಅತ್ತನು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ಆಗ ಇಸ್ರೇಲನು ಯೋಸೇಫನಿಗೆ, “ನಾನು ನಿನ್ನ ಮುಖವನ್ನು ಕಣ್ಣಾರೆ ಕಂಡದ್ದರಿಂದ ನೀನು ಬದುಕಿರುವುದು ನನಗೆ ನಿಶ್ಚಯವಾಯಿತು. ನಾನು ಈಗ ಸಮಾಧಾನದಿಂದ ಸಾಯವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರಿಗೂ ತನ್ನ ತಂದೆಯ ಕುಟುಂಬದವರಿಗೂ, “ನಾನು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, ‘ನನ್ನ ಸಹೋದರರು ಮತ್ತು ನನ್ನ ತಂದೆಯ ಕುಟುಂಬದವರು ಕಾನಾನ್ ದೇಶವನ್ನು ಬಿಟ್ಟು ನನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ಈ ಕುಟುಂಬವು ಕುರುಬರ ಕುಟುಂಬ. ಇವರು ಯಾವಾಗಲೂ ದನಕರುಗಳ ಮತ್ತು ಆಡುಕುರಿಗಳ ಮಂದೆಗಳನ್ನು ಸಾಕುವವರು. ಇವರು ತಮ್ಮ ಎಲ್ಲಾ ಪಶುಗಳನ್ನು ಮತ್ತು ತಾವು ಹೊಂದಿರುವ ಪ್ರತಿಯೊಂದನ್ನು ತಮ್ಮೊಂದಿಗೆ ತಂದಿದ್ದಾರೆ’ ಎಂದು ತಿಳಿಸುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ಫರೋಹನು ನಿಮ್ಮನ್ನು ಕರೆಯಿಸಿ, ‘ನಿಮ್ಮ ಉದ್ಯೋಗವೇನು?’ ಎಂದು ಕೇಳುತ್ತಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ನೀವು ಅವನಿಗೆ, ‘ನಾವು ಕುರುಬರು. ನಮ್ಮ ಜೀವಮಾನವೆಲ್ಲಾ ನಾವು ಪಶುಗಳನ್ನು ಸಾಕುವುದರ ಮೂಲಕ ಜೀವನ ಮಾಡಿದೆವು. ನಮಗಿಂತ ಮೊದಲು ನಮ್ಮ ಪೂರ್ವಿಕರು ಸಹ ಇದೇ ರೀತಿ ಜೀವಿಸಿದರು’ ಎಂದು ಹೇಳಿರಿ. ಆಗ ಅವನು ಗೋಷೆನ್ ಪ್ರಾಂತ್ಯದಲ್ಲಿ ವಾಸಿಸಲು ನಿಮಗೆ ಅವಕಾಶ ಮಾಡಿಕೊಡುತ್ತಾನೆ. ಈಜಿಪ್ಟಿನ ಜನರು ಕುರುಬರನ್ನು ಇಷ್ಟಪಡುವುದಿಲ್ಲ. ಆದ್ದರಿಂದ ನೀವು ಗೋಷೆನಿನಲ್ಲಿ ವಾಸಿಸುವುದು ಒಳ್ಳೆಯದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ಯೋಸೇಫನು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, “ನನ್ನ ತಂದೆಯೂ ನನ್ನ ಸಹೋದರರೂ ಅವರೆಲ್ಲರ ಕುಟುಂಬಗಳವರೂ ಇಲ್ಲಿಗೆ ಬಂದಿದ್ದಾರೆ. ಅವರು ತಮ್ಮ ಎಲ್ಲಾ ಪಶುಗಳನ್ನೂ ಕಾನಾನಿನಲ್ಲಿ ಪಡೆದಿದ್ದ ಪ್ರತಿಯೊಂದನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಂದಿದ್ದಾರೆ. ಈಗ ಅವರು ಗೋಷೆನ್ ಪ್ರಾಂತ್ಯದಲ್ಲಿ ಇದ್ದಾರೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರಲ್ಲಿ ಐದು ಮಂದಿಯನ್ನು ಆರಿಸಿಕೊಂಡು ಫರೋಹನ ಬಳಿಗೆ ಅವರನ್ನು ಕರೆದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ಫರೋಹನು ಸಹೋದರರಿಗೆ, “ನಿಮ್ಮ ಉದ್ಯೋಗವೇನು?” ಎಂದು ಕೇಳಿದನು. ಸಹೋದರರು ಫರೋಹನಿಗೆ, “ಸ್ವಾಮೀ, ನಾವು ಕುರುಬರು. ನಮ್ಮ ಪೂರ್ವಿಕರು ನಮಗಿಂತ ಮೊದಲೇ ಕುರುಬರಾಗಿದ್ದರು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ಅವರು ಫರೋಹನಿಗೆ, “ಬರಗಾಲವು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ತುಂಬ ಘೋರವಾಗಿದೆ. ಯಾವ ಹೊಲದಲ್ಲಿಯೂ ನಮ್ಮ ಪಶುಗಳಿಗೆ ಹುಲ್ಲು ಉಳಿದಿಲ್ಲ. ಆದ್ದರಿಂದ ನಾವು ಈ ದೇಶದಲ್ಲಿ ವಾಸಿಸಲು ಬಂದಿದ್ದೇವೆ. ನಾವು ಗೋಷೆನ್ ಪ್ರಾಂತ್ಯದಲ್ಲಿ ವಾಸಿಸಲು ದಯವಿಟ್ಟು ನಮಗೆ ಅವಕಾಶ ಮಾಡಿಕೊಡಬೇಕೆಂದು ಕೇಳಿಕೊಳ್ಳುತ್ತಿದ್ದೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ಆಗ ಫರೋಹನು ಯೋಸೇಫನಿಗೆ, “ನಿನ್ನ ತಂದೆಯೂ ನಿನ್ನ ಸಹೋದರರೂ ನಿನ್ನ ಬಳಿಗೆ ಬಂದಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ಅವರ ವಾಸಕ್ಕಾಗಿ ಈಜಿಪ್ಟಿನಲ್ಲಿ ಯಾವ ಸ್ಥಳವನ್ನಾದರೂ ಆರಿಸಿಕೊಳ್ಳಬಹುದು. ನಿನ್ನ ತಂದೆಯೂ ನಿನ್ನ ಸಹೋದರರೂ ವಾಸವಾಗಿರಲು ಉತ್ತಮವಾದ ಪ್ರದೇಶವನ್ನು ಕೊಡು. ಅವರು ಗೋಷೆನ್ ಪ್ರಾಂತ್ಯದಲ್ಲಿ ವಾಸಿಸಲಿ. ಅವರು ನಿಪುಣರಾದ ಕುರುಬರಾಗಿದ್ದರೆ, ಅವರು ನನ್ನ ದನಕರುಗಳನ್ನು ಸಹ ನೋಡಿಕೊಳ್ಳಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ಆಗ ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯನ್ನು ಫರೋಹನ ಸನ್ನಿಧಿಗೆ ಕರೆಯಿಸಿದನು. ಯಾಕೋಬನು ಫರೋಹನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ಆಗ ಫರೋಹನು ಯಾಕೋಬನಿಗೆ, “ನಿನಗೆ ಎಷ್ಟು ವಯಸ್ಸಾಗಿದೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ಯಾಕೋಬನು ಫರೋಹನಿಗೆ, “ನಾನು ನನ್ನ ಅಲ್ಪಕಾಲದ ಜೀವನದಲ್ಲಿ ಅನೇಕ ತೊಂದರೆಗಳನ್ನು ಅನುಭವಿಸಿದೆನು. ಈಗ ನನಗೆ ನೂರಮೂವತ್ತು ವರ್ಷ. ನನ್ನ ತಂದೆಯೂ ಅವನ ಪೂರ್ವಿಕರೂ ನನಗಿಂತ ಹೆಚ್ಚು ವರ್ಷ ಜೀವಿಸಿದರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ಯಾಕೋಬನು ಫರೋಹನನ್ನು ಆಶೀರ್ವದಿಸಿದ ಬಳಿಕ ಫರೋಹನ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಟುಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ಫರೋಹನು ಹೇಳಿದಂತೆಯೇ ಯೋಸೇಫನು ಮಾಡಿದನು. ಅವನು ತನ್ನ ತಂದೆಗೂ ಸಹೋದರರಿಗೂ ಈಜಿಪ್ಟಿನಲ್ಲಿ ವಾಸಿಸಲು ಉತ್ತಮವಾದ ಪ್ರದೇಶವನ್ನು ಕೊಟ್ಟನು. ಅದು ರಮ್ಸೇಸ್ ಪಟ್ಟಣದ ಸಮೀಪದಲ್ಲಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೂ ತನ್ನ ಸಹೋದರರಿಗೂ ಮತ್ತು ಅಲ್ಲಿನ ಎಲ್ಲಾ ಜನರಿಗೂ ಬೇಕಾಗಿದ್ದ ಆಹಾರವನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ಬರಗಾಲವು ಹೆಚ್ಚು ಭೀಕರವಾಯಿತು. ದೇಶದಲ್ಲಿ ಎಲ್ಲಿಯೂ ಆಹಾರ ಇರಲಿಲ್ಲ. ಈಜಿಪ್ಟ್ ಮತ್ತು ಕಾನಾನ್ ದೇಶಗಳು ಕೆಟ್ಟಕಾಲದಿಂದ ಬಡದೇಶಗಳಾದವು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ಈಜಿಪ್ಟ್ ಮತ್ತು ಕಾನಾನ್ ದೇಶಗಳ ಜನರು ಧಾನ್ಯಗಳನ್ನು ಕೊಂಡುಕೊಂಡರು. ಯೋಸೇಫನು ಹಣವನ್ನು ಉಳಿಸಿ ಫರೋಹನ ಭಂಡಾರಕ್ಕೆ ಸೇರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ಸ್ವಲ್ಪ ಸಮಯದ ನಂತರ, ಈಜಿಪ್ಟ್ ಮತ್ತು ಕಾನಾನ್ ದೇಶಗಳಲ್ಲಿದ್ದ ಜನರಲ್ಲಿ ಹಣವು ಉಳಿದಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಈಜಿಪ್ಟಿನ ಜನರು ಯೋಸೇಫನ ಬಳಿಗೆ ಹೋಗಿ, “ದಯವಿಟ್ಟು ನಮಗೆ ಆಹಾರವನ್ನು ಕೊಡು. ನಮ್ಮ ಹಣವೆಲ್ಲ ಮುಗಿದುಹೋಗಿದೆ. ನಾವು ಊಟ ಮಾಡದಿದ್ದರೆ ನಿನ್ನೆದುರಿನಲ್ಲೇ ಸಾಯುತ್ತೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ಅದಕ್ಕೆ ಯೋಸೇಫನು, “ನಿಮ್ಮ ದನಕರುಗಳನ್ನು ನನಗೆ ಕೊಡಿರಿ, ನಾನು ನಿಮಗೆ ಆಹಾರವನ್ನು ಕೊಡುತ್ತೇನೆ” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ಆದ್ದರಿಂದ ಜನರು ತಮ್ಮ ದನಕರುಗಳನ್ನೂ ಕುದುರೆಗಳನ್ನೂ ಇತರ ಎಲ್ಲಾ ಪಶುಗಳನ್ನೂ ಕೊಟ್ಟು ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಂಡರು. ಆ ವರ್ಷ ಯೋಸೇಫನು ಅವರಿಗೆ ಆಹಾರವನ್ನು ಕೊಟ್ಟು ಅವರ ಪಶುಗಳನ್ನು ಕೊಂಡುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ಆದರೆ ಮುಂದಿನ ವರ್ಷ, ಪಶುಗಳನ್ನು ಕೊಟ್ಟು ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ಜನರ ಬಳಿ ಪಶುಗಳಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಜನರು ಯೋಸೇಫನಲ್ಲಿಗೆ ಹೋಗಿ, “ನಮ್ಮಲ್ಲಿ ಹಣ ಇಲ್ಲವೆಂಬುದು ನಿನಗೆ ಗೊತ್ತೇ ಇದೆ. ಅಲ್ಲದೆ ನಮ್ಮ ಪಶುಗಳೂ ನಿನ್ನ ಸ್ವತ್ತಾಗಿವೆ. ಆದ್ದರಿಂದ ನಮ್ಮಲ್ಲಿ ಏನೂ ಉಳಿದಿಲ್ಲ. ನೀನು ನೋಡುತ್ತಿರುವ ನಮ್ಮ ಶರೀರ ಮತ್ತು ನಮ್ಮ ಜಮೀನು ಮಾತ್ರ ಉಳಿದಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ನಿನ್ನ ಕಣ್ಣೆದುರಿನಲ್ಲಿಯೇ ನಾವು ಖಂಡಿತವಾಗಿ ಸಾಯುತ್ತೇವೆ. ಆದರೆ ನೀನು ನಮಗೆ ಆಹಾರವನ್ನು ಕೊಟ್ಟರೆ, ನಾವು ಫರೋಹನಿಗೆ ನಮ್ಮ ಭೂಮಿಯನ್ನು ಕೊಟ್ಟು ಅವನ ಗುಲಾಮರಾಗಿರುತ್ತೇವೆ. ಬಿತ್ತನೆ ಮಾಡಲು ನಮಗೆ ಬೀಜವನ್ನು ಕೊಡು. ಆಗ ನಾವು ಬದುಕುತ್ತೇವೆ, ಸಾಯುವುದಿಲ್ಲ. ಮತ್ತು ಭೂಮಿಯೂ ಬೆಳೆಗಳನ್ನು ಫಲಿಸುತ್ತದೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ಆದ್ದರಿಂದ ಯೋಸೇಫನು ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ಜಮೀನನ್ನು ಫರೋಹನಿಗಾಗಿ ಕೊಂಡುಕೊಂಡನು. ಹಸಿವೆಯಿಂದಾಗಿ ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ಜನರು ಯೋಸೇಫನಿಗೆ ತಮ್ಮ ಜಮೀನುಗಳನ್ನು ಮಾರಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ಜನರು ಫರೋಹನ ಗುಲಾಮರಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ಪುರೋಹಿತರು ಹೊಂದಿದ್ದ ಭೂಮಿಯನ್ನು ಮಾತ್ರ ಯೋಸೇಫನು ಕೊಂಡುಕೊಳ್ಳಲಿಲ್ಲ. ಭೂಮಿಯನ್ನು ಮಾರುವ ಅವಶ್ಯಕತೆ ಪುರೋಹಿತರಿಗೆ ಇರಲಿಲ್ಲ. ಯಾಕೆಂದರೆ ಫರೋಹನೇ ಅವರಿಗೆ ಸಂಬಳವನ್ನು ಕೊಡುತ್ತಿದ್ದನು. ಆದ್ದರಿಂದ ಅವರು ಆ ಹಣದಿಂದ ಆಹಾರವನ್ನು ಕೊಂಡುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ಯೋಸೇಫನು ಜನರಿಗೆ, “ಈಗ ನಾನು ನಿಮ್ಮನ್ನೂ ನಿಮ್ಮ ಜಮೀನನ್ನೂ ಫರೋಹನಿಗಾಗಿ ಕೊಂಡುಕೊಂಡಿದ್ದೇನೆ. ಆದ್ದರಿಂದ ನಾನು ನಿಮಗೆ ಬೀಜವನ್ನು ಕೊಡುತ್ತೇನೆ. ನೀವು ನಿಮ್ಮ ಜಮೀನುಗಳಲ್ಲಿ ಬಿತ್ತನೆಮಾಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ಸುಗ್ಗಿಕಾಲ ಬಂದಾಗ, ನಿಮ್ಮ ಬೆಳೆಗಳಲ್ಲಿ ಐದನೆ ಒಂದು ಭಾಗ ಫರೋಹನಿಗೆ ಸೇರಿದ್ದು. ಐದನೆ ನಾಲ್ಕು ಭಾಗವನ್ನು ನಿಮಗೋಸ್ಕರ ಇಟ್ಟುಕೊಳ್ಳಿರಿ. ನೀವು ಆಹಾರಕ್ಕಾಗಿ ಇಟ್ಟುಕೊಳ್ಳುವ ಬೀಜವನ್ನೇ ಮುಂದಿನ ವರ್ಷದ ಬಿತ್ತನೆಗಾಗಿ ಉಪಯೋಗಿಸಬಹುದು. ಹೀಗೆ ನೀವು ನಿಮ್ಮ ಕುಟುಂಬದವರಿಗೂ ಮಕ್ಕಳಿಗೂ ಪೋಷಣೆಮಾಡಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ಆಗ ಜನರು, “ನೀನು ನಮ್ಮ ಜೀವವನ್ನು ಉಳಿಸಿರುವೆ. ನಾವು ಸಂತೋಷದಿಂದ ಫರೋಹನ ಗುಲಾಮರಾಗುತ್ತೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ಆದ್ದರಿಂದ ಯೋಸೇಫನು ಒಂದು ಕಾನೂನನ್ನು ಮಾಡಿದನು. ಅದು ಇಂದಿಗೂ ಜಾರಿಯಲ್ಲಿದೆ. ಆ ಕಾನೂನಿನ ಪ್ರಕಾರ, ಭೂಮಿಯ ಫಸಲಿನಲ್ಲಿ ಐದನೇ ಒಂದು ಭಾಗವು ಫರೋಹನಿಗೆ ಸೇರಿದ್ದಾಗಿದೆ. ಫರೋಹನು ಎಲ್ಲಾ ಜಮೀನಿಗೂ ಒಡೆಯನಾಗಿದ್ದಾನೆ. ಪುರೋಹಿತರ ಭೂಮಿಯು ಮಾತ್ರ ಅವನಿಗೆ ಸೇರಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ಇಸ್ರೇಲನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡನು. ಅವನು ಗೋಷೆನ್ ಪ್ರಾಂತ್ಯದಲ್ಲಿ ವಾಸಿಸಿದನು. ಅವನ ಕುಟುಂಬವು ಬೆಳೆದು ತುಂಬ ದೊಡ್ಡದಾಯಿತು. ಅವರು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಜಮೀನನ್ನು ಪಡೆದುಕೊಂಡರು ಮತ್ತು ಸುಖವಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ಕೋಬನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಹದಿನೇಳು ವರ್ಷಗಳ ಕಾಲ ಜೀವಿಸಿದನು. ಆಗ ಯಾಕೋಬನಿಗೆ ನೂರನಲವತ್ತೇಳು ವರ್ಷವಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ಇಸ್ರೇಲನು ಸಾಯುವ ಕಾಲ ಸಮೀಪಿಸಿತು. ಅವನಿಗೆ ತಾನು ಸಾಯುತ್ತೇನೆಂದು ತಿಳಿದು ಬಂದಾಗ, ತನ್ನ ಮಗನಾದ ಯೋಸೇಫನನ್ನು ಕರೆಯಿಸಿ, “ನೀನು ನನ್ನನ್ನು ಪ್ರೀತಿಸುವುದಾದರೆ, ನಿನ್ನ ಕೈಯನ್ನು ನನ್ನ ತೊಡೆಯ ಕೆಳಗಿಟ್ಟು ಪ್ರಮಾಣಮಾಡು. ನಾನು ಹೇಳಿದ್ದನ್ನು ನಡೆಸುವುದಾಗಿಯೂ ನನಗೆ ನಂಬಿಗಸ್ತನಾಗಿರುವುದಾಗಿಯೂ ಪ್ರಮಾಣ ಮಾಡು. ನಾನು ಸತ್ತಾಗ, ನನ್ನನ್ನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಬೇಡ. ");
INSERT INTO kan2010_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ನನ್ನ ಪೂರ್ವಿಕರನ್ನು ಸಮಾಧಿ ಮಾಡಿದ ಸ್ಥಳದಲ್ಲಿಯೇ ನನ್ನನ್ನು ಸಮಾಧಿ ಮಾಡು. ನನ್ನನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ನಮ್ಮ ಕುಟುಂಬದವರ ಸ್ಮಶಾನದಲ್ಲಿ ಸಮಾಧಿ ಮಾಡು” ಎಂದು ಹೇಳಿದನು. ಯೋಸೇಫನು, “ನೀನು ಹೇಳಿದಂತೆಯೇ ಮಾಡುತ್ತೇನೆ” ಎಂದು ಪ್ರಮಾಣ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ಇಸ್ರೇಲನು, “ನನಗೆ ಪ್ರಮಾಣ ಮಾಡು” ಎಂದು ಹೇಳಿದ್ದರಿಂದ ಯೋಸೇಫನು ಅವನಿಗೆ ಪ್ರಮಾಣ ಮಾಡಿದನು. ಆಮೇಲೆ ಇಸ್ರೇಲನು ಹಾಸಿಗೆಯ ಮೇಲೆ ಮತ್ತೆ ತನ್ನ ತಲೆಬಾಗಿ ದೇವರಿಗೆ ನಮಸ್ಕರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ಸ್ವಲ್ಪ ಕಾಲದ ನಂತರ, ತಂದೆಯು ಬಹಳ ಅನಾರೋಗ್ಯದಿಂದಿರುವುದು ಯೋಸೇಫನಿಗೆ ತಿಳಿಯಿತು. ಆದ್ದರಿಂದ ಅವನು ತನ್ನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಾದ ಮನಸ್ಸೆಯನ್ನು ಮತ್ತು ಎಫ್ರಾಯೀಮನನ್ನು ಕರೆದುಕೊಂಡು ತನ್ನ ತಂದೆಯ ಬಳಿಗೆ ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ಯೋಸೇಫನು ಬಂದಾಗ ಯಾರೋ ಒಬ್ಬನು ಇಸ್ರೇಲನಿಗೆ, “ನಿನ್ನ ಮಗನಾದ ಯೋಸೇಫನು ನಿನ್ನನ್ನು ನೋಡಲು ಬಂದಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದನು. ಆಗ ಅವನು ಬಹಳ ಬಲಹೀನನಾಗಿದ್ದರೂ ಕಷ್ಟಪಟ್ಟು ಹಾಸಿಗೆಯ ಮೇಲೆ ಕುಳಿತುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ಬಳಿಕ ಇಸ್ರೇಲನು ಯೋಸೇಫನಿಗೆ, “ಸರ್ವಶಕ್ತನಾದ ದೇವರು ನನಗೆ ಕಾನಾನ್ ದೇಶದ ಲೂಜ್ ಎಂಬ ಸ್ಥಳದಲ್ಲಿ ಕಾಣಿಸಿಕೊಂಡು ನನ್ನನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ದೇವರು ನನಗೆ, ‘ನಾನು ನಿನಗೆ ಅನೇಕ ಮಕ್ಕಳನ್ನು ಕೊಡುತ್ತೇನೆ; ನಿನ್ನ ಸಂತತಿಯವರು ಅನೇಕ ಜನಾಂಗಗಳಾಗುವರು; ನಿನ್ನ ಸಂತತಿಯವರಿಗೆ ನಾನು ಈ ದೇಶವನ್ನು ಶಾಶ್ವತವಾಗಿ ಕೊಡುವೆನು’ ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ಈಗ ನಿನಗೆ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಿದ್ದಾರೆ. ನಾನು ಈಜಿಪ್ಟಿಗೆ ಬರುವುದಕ್ಕಿಂತ ಮೊದಲೇ ಅವರು ಇಲ್ಲಿ ಹುಟ್ಟಿದರು. ನಿನ್ನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಾದ ಮನಸ್ಸೆ ಮತ್ತು ಎಫ್ರಾಯೀಮ್ ನನ್ನ ಮಕ್ಕಳಂತೆಯೇ ಇದ್ದಾರೆ. ಅವರು ನನಗೆ ರೂಬೇನ್ ಮತ್ತು ಸಿಮೆಯೋನರಂತೆಯೇ ಇದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ಆದ್ದರಿಂದ ಈ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳು ನನಗೆ ಮಕ್ಕಳಂತೆಯೇ ಇರುತ್ತಾರೆ. ನಾನು ಹೊಂದಿರುವ ಪ್ರತಿಯೊಂದರಲ್ಲಿಯೂ ಅವರು ಪಾಲನ್ನು ಹೊಂದುವರು. ಆದರೆ ನಿನಗೆ ಬೇರೆ ಗಂಡುಮಕ್ಕಳಿದ್ದರೆ ಅವರು ಎಫ್ರಾಯೀಮ್ ಮತ್ತು ಮನಸ್ಸೆಯವರಿಗೆ ಮಕ್ಕಳಾಗಿರುತ್ತಾರೆ. ಅಂದರೆ ಎಫ್ರಾಯೀಮ್ ಮತ್ತು ಮನಸ್ಸೆ ಹೊಂದಿರುವ ಪ್ರತಿಯೊಂದರಲ್ಲಿ ಅವರು ಪಾಲನ್ನು ಹೊಂದುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ಪದ್ದನ್‌ಅರಾಮಿನಿಂದ ಹಿಂತಿರುಗಿ ಬರುತ್ತಿರುವಾಗ ರಾಹೇಲಳು ಸತ್ತಳು. ಇದು ನನಗೆ ತುಂಬ ದುಃಖವನ್ನು ಉಂಟುಮಾಡಿತು. ನಾವು ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಎಫ್ರಾತ್ ನಗರದ ಕಡೆಗೆ ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದೆವು. ಆದ್ದರಿಂದ ನಾನು ಅವಳನ್ನು ಬೆತ್ಲೆಹೇಮೆಂಬ ಎಫ್ರಾತ್ ನಗರದ ರಸ್ತೆಯಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಿದೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ಆಮೇಲೆ ಇಸ್ರೇಲನು ಯೋಸೇಫನ ಗಂಡುಮಕ್ಕಳನ್ನು ನೋಡಿ, “ಈ ಹುಡುಗರು ಯಾರು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೆ, “ಇವರು ನನ್ನ ಮಕ್ಕಳು. ದೇವರು ನನಗೆ ಕೊಟ್ಟಿರುವ ಗಂಡುಮಕ್ಕಳೇ ಇವರು” ಎಂದು ಹೇಳಿದನು. ಇಸ್ರೇಲನು, “ಅವರನ್ನು ನನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಾ, ನಾನು ಅವರನ್ನು ಆಶೀರ್ವದಿಸುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ಇಸ್ರೇಲನಿಗೆ ತುಂಬ ವಯಸ್ಸಾಗಿತ್ತು. ಅವನಿಗೆ ಕಣ್ಣು ಸರಿಯಾಗಿ ಕಾಣುತ್ತಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಯೋಸೇಫನು ಅವರನ್ನು ತಂದೆಯ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ಇಸ್ರೇಲನು ಆ ಹುಡುಗರನ್ನು ಅಪ್ಪಿಕೊಂಡು ಮುದ್ದಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ಬಳಿಕ ಇಸ್ರೇಲನು ಯೋಸೇಫನಿಗೆ, “ನಾನು ಮತ್ತೆ ನಿನ್ನ ಮುಖವನ್ನು ನೋಡುತ್ತೇನೆ ಎಂದು ಯೋಚಿಸಿರಲಿಲ್ಲ. ಆದರೆ ನಾನು ನಿನ್ನನ್ನೂ ನಿನ್ನ ಮಕ್ಕಳನ್ನೂ ನೋಡುವಂತೆ ದೇವರು ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ಆಗ ಯೋಸೇಫನು ಇಸ್ರೇಲನ ತೊಡೆಯ ಮೇಲೆ ಕುಳಿತಿದ್ದ ತನ್ನ ಗಂಡುಮಕ್ಕಳನ್ನು ಎತ್ತಿಕೊಂಡನು. ಬಳಿಕ ಅವರು ಇಸ್ರೇಲನ ಮುಂದೆ ಅಡ್ಡಬಿದ್ದು ನಮಸ್ಕರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ಯೋಸೇಫನು ಎಫ್ರಾಯೀಮನನ್ನು ತನ್ನ ಬಲಭಾಗದಲ್ಲಿಯೂ ಮನಸ್ಸೆಯನ್ನು ತನ್ನ ಎಡಭಾಗದಲ್ಲಿಯೂ ಕುಳ್ಳಿರಿಸಿದನು. (ಆದ್ದರಿಂದ ಎಫ್ರಾಯೀಮನು ಇಸ್ರೇಲನ ಎಡಭಾಗದಲ್ಲಿಯೂ ಮನಸ್ಸೆಯು ಬಲಭಾಗದಲ್ಲಿಯೂ ಇದ್ದರು.) ");
INSERT INTO kan2010_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ಆದರೆ ಇಸ್ರೇಲನು ತನ್ನ ಕೈಗಳನ್ನು ವಾರೆ ಮಾಡಿ ತನ್ನ ಬಲಗೈಯನ್ನು ಚಿಕ್ಕ ಮಗನಾದ ಎಫ್ರಾಯೀಮನ ತಲೆಯ ಮೇಲಿಟ್ಟು ಎಡಗೈಯನ್ನು ದೊಡ್ಡ ಮಗನಾದ ಮನಸ್ಸೆಯ ತಲೆಯ ಮೇಲಿಟ್ಟನು. ಮನಸ್ಸೆಯು ಹಿರಿಯ ಮಗನಾಗಿದ್ದರೂ ಇಸ್ರೇಲನು ಮನಸ್ಸೆಯ ತಲೆಯ ಮೇಲೆ ಎಡಗೈಯನ್ನಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ಬಳಿಕ ಇಸ್ರೇಲನು ಯೋಸೇಫನನ್ನು ಆಶೀರ್ವದಿಸಿ ಹೀಗೆಂದನು: “ನನ್ನ ಪೂರ್ವಿಕರಾದ ಅಬ್ರಹಾಮನೂ ಇಸಾಕನೂ ನಮ್ಮ ದೇವರನ್ನು ಆರಾಧಿಸಿದರು. ಆ ದೇವರೇ ನನ್ನನ್ನು ನನ್ನ ಜೀವಮಾನವೆಲ್ಲಾ ನಡೆಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ನನ್ನನ್ನು ಎಲ್ಲಾ ತೊಂದರೆಗಳಿಂದ ಕಾಪಾಡಿದ ದೂತನೇ ಆತನು. ಈ ಹುಡುಗರನ್ನು ಆಶೀರ್ವದಿಸಬೇಕೆಂದು ನಾನು ಆತನಲ್ಲಿ ಪ್ರಾರ್ಥಿಸುವೆನು. ಇಂದಿನಿಂದ ಈ ಮಕ್ಕಳು ನನ್ನ ಹೆಸರನ್ನೇ ಹೊಂದಿಕೊಳ್ಳುವರು. ನನ್ನ ಪೂರ್ವಿಕರಾದ ಅಬ್ರಹಾಮ್ ಮತ್ತು ಇಸಾಕರ ಹೆಸರನ್ನು ಇವರು ಹೊಂದಿಕೊಳ್ಳುವರು. ಇವರು ಭೂಮಿಯ ಮೇಲೆ ಬೆಳೆದು ದೊಡ್ಡ ಕುಟುಂಬಗಳಾಗುವಂತೆಯೂ ದೊಡ್ಡ ಜನಾಂಗಗಳಾಗುವಂತೆಯೂ ನಾನು ಪ್ರಾರ್ಥಿಸುವೆನು.” ");
INSERT INTO kan2010_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ಇಸ್ರೇಲನು ತನ್ನ ಬಲಗೈಯನ್ನು ಎಫ್ರಾಯೀಮನ ತಲೆಯ ಮೇಲಿಟ್ಟಿದ್ದರಿಂದ ಯೋಸೇಫನು ಅಸಮಾಧಾನದಿಂದ ನೋಡಿ ತಂದೆಯ ಕೈಯನ್ನು ಹಿಡಿದುಕೊಂಡನು; ಅಲ್ಲದೆ ತಂದೆಯ ಕೈಯನ್ನು ಎಫ್ರಾಯೀಮನ ತಲೆಯ ಮೇಲಿಂದ ತೆಗೆದುಕೊಂಡು ಮನಸ್ಸೆಯ ತಲೆಯ ಮೇಲೆ ಇಡಬೇಕೆಂದಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಗೆ, “ನೀನು ನಿನ್ನ ಬಲಗೈಯನ್ನು ತಪ್ಪಾಗಿ ಎಫ್ರಾಯೀಮನ ಮೇಲೆ ಇಟ್ಟಿರುವೆ. ಮೊದಲು ಹುಟ್ಟಿದವನು ಮನಸ್ಸೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ಅದಕ್ಕೆ ಅವನ ತಂದೆಯು “ನನಗೆ ಗೊತ್ತು ಮಗನೇ, ನನಗೆ ಗೊತ್ತು. ಮನಸ್ಸೆ ಮೊದಲು ಹುಟ್ಟಿದವನು. ಅವನು ಮಹಾವ್ಯಕ್ತಿಯಾಗುವನು. ಅವನು ಅನೇಕ ಜನರಿಗೆ ತಂದೆಯಾಗುವನು. ಆದರೆ ತಮ್ಮನು ಅಣ್ಣನಿಗಿಂತ ಮಹಾವ್ಯಕ್ತಿಯಾಗುವನು. ಅವನ ಕುಟುಂಬವು ತುಂಬ ದೊಡ್ಡದಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ಅಂದು ಇಸ್ರೇಲನು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿ, “ಇಸ್ರೇಲರು ನಿಮ್ಮ ಹೆಸರುಗಳ ಮೂಲಕ ಬೇರೆಯವರನ್ನು ಆಶೀರ್ವದಿಸುವರು. ‘ದೇವರು ನಿನ್ನನ್ನು ಎಫ್ರಾಯೀಮನಂತೆಯೂ ಮನಸ್ಸೆಯಂತೆಯೂ ಮಾಡಲಿ’ ಎಂದು ಹೇಳುವರು” ಎಂದನು. ಹೀಗೆ, ಇಸ್ರೇಲನು ಎಫ್ರಾಯೀಮನನ್ನು ಮನಸ್ಸೆಗಿಂತ ದೊಡ್ಡವನನ್ನಾಗಿ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ಬಳಿಕ ಇಸ್ರೇಲನು ಯೋಸೇಫನಿಗೆ, “ನೋಡು, ನಾನು ಸಾಯುವ ಕಾಲ ಸಮೀಪಿಸಿದೆ. ಆದರೆ ದೇವರು ಇನ್ನೂ ನಿನ್ನ ಸಂಗಡವಿರುವನು. ಅವನು ನಿನ್ನನ್ನು ನಿನ್ನ ಪೂರ್ವಿಕರ ದೇಶಕ್ಕೆ ಹಿಂತಿರುಗಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ನಾನು ನಿನ್ನ ಸಹೋದರರಿಗೆ ಕೊಟ್ಟ ಪಾಲಿಗಿಂತ ಹೆಚ್ಚಾಗಿ ಬೇರೊಂದನ್ನು ನಿನಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ನಾನು ಅಮೋರಿಯರಿಂದ ಗೆದ್ದುಕೊಂಡಿರುವ ಬೆಟ್ಟವನ್ನು ನಿನಗೆ ಕೊಡುವೆನು. ನಾನು ಅವರೊಂದಿಗೆ ಖಡ್ಗಗಳಿಂದಲೂ ಬಿಲ್ಲುಗಳಿಂದಲೂ ಹೋರಾಡಿ ಆ ಬೆಟ್ಟವನ್ನು ವಶಪಡಿಸಿಕೊಂಡಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ಬಳಿಕ ಯಾಕೋಬನು ತನ್ನ ಗಂಡುಮಕ್ಕಳನ್ನು ತನ್ನ ಬಳಿಗೆ ಕರೆಯಿಸಿ, “ನನ್ನ ಎಲ್ಲಾ ಗಂಡುಮಕ್ಕಳೇ, ನನ್ನ ಬಳಿಗೆ ಬನ್ನಿರಿ. ನಿಮಗೆ ಮುಂದೆ ಏನು ಸಂಭವಿಸುವುದೆಂದು ತಿಳಿಸುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“ಯಾಕೋಬನ ಗಂಡುಮಕ್ಕಳೇ, ಒಟ್ಟಾಗಿ ಬಂದು ಕೇಳಿರಿ. ನಿಮ್ಮ ತಂದೆಯಾದ ಇಸ್ರೇಲನು ಹೇಳುವುದನ್ನು ಕೇಳಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“ರೂಬೇನನೇ, ನೀನು ನನ್ನ ಚೊಚ್ಚಲು ಮಗ. ನೀನೇ ನನ್ನ ಮೊದಲನೆಯ ಮಗ. ನೀನು ನನ್ನ ಇತರ ಎಲ್ಲಾ ಗಂಡುಮಕ್ಕಳಿಗಿಂತ ಶಕ್ತಿಶಾಲಿಯೂ ಗೌರವಯುತನೂ ಆಗಿರುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ಆದರೆ ನೀನು ಪ್ರಳಯದ ಭಯಂಕರವಾದ ಅಲೆಗಳಂತಿರುವೆ. ನೀನು ನನ್ನ ಮಕ್ಕಳಿಗಿಂತ ಅತ್ಯಂತ ಪ್ರಮುಖನಾಗಿರುವುದಿಲ್ಲ. ನಿನ್ನ ತಂದೆಗೆ ಸೇರಿದ ಸ್ತ್ರೀಯೊಂದಿಗೆ ನೀನು ಮಲಗಿಕೊಂಡೆ. ನೀನು ನಿನ್ನ ತಂದೆಯ ಹಾಸಿಗೆಗೆ ಗೌರವವನ್ನು ತೋರಿಸಲಿಲ್ಲ.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“ಸಿಮೆಯೋನನೂ ಲೇವಿಯೂ ಸಹೋದರರಾಗಿದ್ದಾರೆ. ಅವರು ತಮ್ಮ ಖಡ್ಗಗಳಿಂದ ಹೋರಾಡಲು ಇಷ್ಟಪಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ಅವರು ಗುಟ್ಟಾಗಿ ಕೆಟ್ಟಕಾರ್ಯಗಳನ್ನು ಯೋಚಿಸಿದರು. ಅವರ ರಹಸ್ಯಕೂಟಗಳನ್ನು ನನ್ನ ಆತ್ಮವು ಸ್ವೀಕರಿಸುವುದಿಲ್ಲ. ಅವರು ಕೋಪಗೊಂಡಾಗ ಗಂಡಸರನ್ನು ಕೊಂದುಹಾಕಿದರು. ಅವರು ಮೋಜಿಗೆಂದೇ ಪ್ರಾಣಿಗಳನ್ನು ಹಿಂಸಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ಅವರ ಕೋಪವೇ ಅವರಿಗೆ ಶಾಪ. ಅದು ತುಂಬಾ ಶಕ್ತಿಶಾಲಿಯಾದದ್ದು. ಅವರು ಹುಚ್ಚರಾದಾಗ ತುಂಬಾ ಕ್ರೂರಿಗಳು. ಅವರು ಯಾಕೋಬನ ನಾಡಿನಲ್ಲಿ ತಮ್ಮದೇ ಆದ ನಾಡನ್ನು ಹೊಂದಿಕೊಳ್ಳುವುದಿಲ್ಲ. ಅವರು ಇಸ್ರೇಲಿನಲ್ಲೆಲ್ಲಾ ಹರಡಿಕೊಳ್ಳುವರು.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“ಯೆಹೂದನೇ, ನಿನ್ನ ಸಹೋದರರು ನಿನ್ನನ್ನೇ ಹೊಗಳುವರು. ನೀನು ನಿನ್ನ ವೈರಿಗಳನ್ನು ಸೋಲಿಸುವೆ. ನಿನ್ನ ಸಹೋದರರು ನಿನಗೇ ಅಡ್ಡಬೀಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ಯೆಹೂದನು ಪ್ರಾಣಿಯನ್ನು ಕೊಂದ ಪ್ರಾಯದ ಸಿಂಹದಂತಿದ್ದಾನೆ. ಮಗನೇ, ನೀನು ಸಿಂಹದಂತೆ ಬೇಟೆಗಾಗಿ ಹೊಂಚುಹಾಕಿ ನಿಂತಿರುವೆ. ಯೆಹೂದನು ಸಿಂಹದಂತಿರುವನು. ಅವನು ಮಲಗಿ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳುವನು; ಅವನನ್ನು ಕೆಣಕಲು ಯಾರಿಗೂ ಧೈರ್ಯವಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ರಾಜದಂಡವನ್ನು ಹಿಡಿಯತಕ್ಕವನು ಬರುವ ತನಕ ಯೆಹೂದನು ರಾಜದಂಡವನ್ನು ಹಿಡಿದುಕೊಳ್ಳುವನು. ಅವನ ಸಂತತಿಯವರು ಶಾಶ್ವತವಾಗಿ ಆಳುವರು; ಅನ್ಯಜನಾಂಗಗಳು ಅವನಿಗೆ ಕಪ್ಪಕಾಣಿಕೆಗಳನ್ನು ತಂದು ಅವನಿಗೆ ವಿಧೇಯರಾಗಿರುವರು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ಅವನು ತನ್ನ ಕತ್ತೆಯನ್ನು ದ್ರಾಕ್ಷೆಬಳ್ಳಿಗೆ ಕಟ್ಟುವನು; ತನ್ನ ಪ್ರಾಯದ ಕತ್ತೆಯನ್ನು ಉತ್ತಮವಾದ ದ್ರಾಕ್ಷೆಬಳ್ಳಿಗೆ ಕಟ್ಟುವನು. ಅವನು ಉತ್ತಮವಾದ ದ್ರಾಕ್ಷಾರಸದಿಂದ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆಯುವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ಅವನು ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಯುವುದರಿಂದ ಅವನ ಕಣ್ಣುಗಳು ಕೆಂಪಾಗಿರುತ್ತವೆ. ಅವನು ಹಾಲು ಕುಡಿಯುವುದರಿಂದ ಅವನ ಹಲ್ಲುಗಳು ಬಿಳುಪಾಗಿರುತ್ತವೆ.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“ಜೆಬುಲೂನನು ಸಮುದ್ರದ ಕರಾವಳಿಯಲ್ಲಿ ವಾಸಿಸುವನು; ಸಮುದ್ರ ತೀರವು ಅವನ ಹಡಗುಗಳಿಗೆ ಸುರಕ್ಷಿತವಾದ ಸ್ಥಳವಾಗಿದೆ. ಅವನ ನಾಡು ಚೀದೋನ್ ಪಟ್ಟಣದವರೆಗೂ ವಿಸ್ತರಿಸುವುದು.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ಇಸ್ಸಾಕಾರನು ಬಹಳ ಕಷ್ಟಪಟ್ಟು ದುಡಿಯುವ ಕತ್ತೆಯಂತಿದ್ದಾನೆ. ಅವನು ಭಾರವಾದ ಹೊರೆಯನ್ನು ಹೊರುವುದರಿಂದ ಮಲಗಿ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳುವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ಅವನು ತನ್ನ ವಿಶ್ರಾಂತಿಗೆ ಅನುಕೂಲವಾಗಿರುವ ಮತ್ತು ಪ್ರಶಾಂತವಾಗಿರುವ ನಾಡನ್ನು ನೋಡುವನು. ಅವನು ಭಾರವಾದ ಹೊರೆಗಳನ್ನು ಹೊರುವುದಕ್ಕೂ ಗುಲಾಮನಂತೆ ದುಡಿಯುವುದಕ್ಕೂ ಒಪ್ಪಿಕೊಳ್ಳುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ಇತರ ಇಸ್ರೇಲರ ಕುಟುಂಬಗಳಿಗೆ ತೀರ್ಪುಮಾಡುವಂತೆ, ದಾನನು ತನ್ನ ಸ್ವಂತ ಜನರಿಗೆ ತೀರ್ಪು ಮಾಡುತ್ತಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ದಾನನು ರಸ್ತೆಯ ಬಳಿಯಲ್ಲಿರುವ ಹಾವಿನಂತಿರುವನು.” ದಾರಿಯ ಸಮೀಪದಲ್ಲಿ ಮಲಗಿದ್ದು ಕುದುರೆಯ ಹಿಮ್ಮಡಿಯನ್ನು ಕಚ್ಚಿ ಸವಾರನನ್ನು ಬೀಳಿಸುವ ವಿಷಸರ್ಪದಂತಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“ಯೆಹೋವನೇ, ನಿನ್ನಿಂದುಂಟಾಗುವ ರಕ್ಷಣೆಗಾಗಿ ನಾನು ಕಾಯುತ್ತಿದ್ದೇನೆ.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“ಒಂದು ಕಳ್ಳರ ಗುಂಪು ಗಾದನ ಮೇಲೆ ಆಕ್ರಮಣ ಮಾಡುವುದು. ಆದರೆ ಗಾದನು ಅವರನ್ನು ಓಡಿಸಿ ಬಿಡುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“ಆಶೇರನ ನಾಡು ಒಳ್ಳೆಯ ಆಹಾರವನ್ನು ಯಥೇಚ್ಛವಾಗಿ ಫಲಿಸುತ್ತದೆ; ರಾಜನಿಗೆ ಸಾಕಾಗುವಷ್ಟು ಒಳ್ಳೆಯ ಆಹಾರವು ಅವನಲ್ಲಿರುವುದು.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“ನಫ್ತಾಲಿಯು ಸ್ವತಂತ್ರವಾಗಿ ಓಡುವ ಜಿಂಕೆಯಂತಿದ್ದಾನೆ. ಅವನ ಮಾತುಗಳು ಅದರ ಸುಂದರವಾದ ಮರಿಗಳಂತಿವೆ.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“ಯೋಸೇಫನು ಬಹು ಯಶಸ್ವಿಯಾಗಿದ್ದಾನೆ. ಯೋಸೇಫನು ಹಣ್ಣನ್ನು ಅಧಿಕವಾಗಿ ಫಲಿಸುವ ದ್ರಾಕ್ಷೆ ಬಳ್ಳಿಯಂತಿರುವನು. ಅವನು ವಸಂತಕಾಲದಲ್ಲಿ ಬೆಳೆಯುವ ದ್ರಾಕ್ಷೆಬಳ್ಳಿಯಂತಿರುವನು. ಅವನು ಗೋಡೆಯ ಆಚೆಗೆ ಚಾಚಿಕೊಂಡಿರುವ ದ್ರಾಕ್ಷೆಬಳ್ಳಿಯಂತಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ಅನೇಕ ಜನರು ಅವನ ವಿರುದ್ಧವಾಗಿ ಹೋರಾಡಿದರು. ಬಿಲ್ಲುಗಳನ್ನು ಹೊಂದಿದ್ದ ಜನರು ಅವನನ್ನು ಇಷ್ಟಪಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ಆದರೆ ಅವನು ತನ್ನ ಹೋರಾಟದಲ್ಲಿ ಬಲಿಷ್ಠವಾದ ಬಿಲ್ಲಿನಿಂದಲೂ ತನ್ನ ನಿಪುಣವಾದ ತೋಳುಗಳಿಂದಲೂ ಗೆದ್ದನು. ಅವನು ಶಕ್ತಿಯನ್ನು ಯಾಕೋಬನ ಪರಾಕ್ರಮಿಯಿಂದಲೂ ಇಸ್ರೇಲನ ಬಂಡೆಯಾದಾತನಿಂದಲೂ ಕುರುಬನಿಂದಲೂ ");
INSERT INTO kan2010_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ನಿಮ್ಮ ತಂದೆಯ ದೇವರಿಂದಲೂ ಪಡೆದುಕೊಳ್ಳುವನು. ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸುವನು. ಸರ್ವಶಕ್ತನಾದ ದೇವರು ನಿನ್ನನ್ನು ಆಶೀರ್ವದಿಸಲಿ. ಆತನು ಮೇಲಿರುವ ಆಕಾಶದಿಂದ ನಿನಗೆ ಆಶೀರ್ವಾದಗಳನ್ನು ಕೊಡಲಿ. ಆತನು ಕೆಳಗಿನ ಆಳವಾದ ಸಾಗರದ ಸೆಲೆಗಳಿಂದಲೂ ನಿನಗೆ ಆಶೀರ್ವಾದಗಳನ್ನು ಕೊಡಲಿ. ಆತನು ನಿನಗೆ ಸ್ತನ್ಯಗಳಿಂದಲೂ ಗರ್ಭದಿಂದಲೂ ಆಶೀರ್ವಾದಗಳನ್ನು ಕೊಡಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ನನ್ನ ತಂದೆತಾಯಿಗಳಿಗೆ ಅನೇಕಾನೇಕ ಒಳ್ಳೆಯ ಸಂಗತಿಗಳು ಸಂಭವಿಸಿದವು. ನಿನ್ನ ತಂದೆಯಾದ ನಾನು ಅದಕ್ಕಿಂತಲೂ ಹೆಚ್ಚು ಆಶೀರ್ವಾದ ಹೊಂದಿಕೊಂಡೆನು. ನಿನ್ನ ಸಹೋದರರು ನಿನ್ನನ್ನು ದೂರಮಾಡಲು ಪ್ರಯತ್ನಿಸಿದರು. ಆದರೆ ಈಗ ನನ್ನ ಎಲ್ಲಾ ಆಶೀರ್ವಾದಗಳು ನಿನ್ನ ಮೇಲೆ ಎತ್ತರವಾದ ಬೆಟ್ಟದೋಪಾದಿಯಲ್ಲಿ ರಾಶಿಯಂತಿವೆ.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“ಬೆನ್ಯಾಮೀನನು ಹಸಿದಿರುವ ತೋಳದಂತಿದ್ದಾನೆ. ಅವನು ಮುಂಜಾನೆಯಲ್ಲಿ ಕೊಂದು ತಿನ್ನುವನು. ಅವನು ಸಾಯಂಕಾಲ ಮಿಕ್ಕುಳಿದುದ್ದನ್ನು ಹಂಚಿಕೊಳ್ಳುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ಇವು ಇಸ್ರೇಲನ ಹನ್ನೆರಡು ಕುಲಗಳು. ಈ ವಿಷಯಗಳನ್ನೆಲ್ಲ ಅವರ ತಂದೆಯಾದ ಇಸ್ರೇಲನು ಅವರಿಗೆ ಹೇಳಿದನು. ಅವನು ತನ್ನ ಪ್ರತಿಯೊಬ್ಬ ಗಂಡುಮಗನಿಗೆ ಅವನಿಗೆ ತಕ್ಕ ಆಶೀರ್ವಾದವನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ಬಳಿಕ ಇಸ್ರೇಲನು ಅವರಿಗೆ ಈ ಆಜ್ಞೆಯನ್ನು ಕೊಟ್ಟನು: “ನಾನು ಸತ್ತಾಗ, ನನ್ನ ಪೂರ್ವಿಕರ ಸಂಗಡವಿರಲು ಇಷ್ಟಪಡುತ್ತೇನೆ. ನನ್ನ ಪೂರ್ವಿಕರಿಗೆ ಸಮಾಧಿ ಮಾಡಿರುವ ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನನ ಗವಿಯಲ್ಲಿ ನನಗೆ ಸಮಾಧಿಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ಆ ಗವಿಯು ಕಾನಾನ್ ದೇಶದ ಮಮ್ರೆಗೆ ಎದುರಾಗಿರುವ ಮಕ್ಪೇಲ ಎಂಬ ಬಯಲಿನಲ್ಲಿದೆ. ಅಬ್ರಹಾಮನು ತನ್ನ ಸಮಾಧಿಗಾಗಿ ಈ ಸ್ಥಳವನ್ನು ಎಫ್ರೋನನಿಂದ ಕೊಂಡುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ಅಬ್ರಹಾಮನನ್ನು ಮತ್ತು ಅವನ ಹೆಂಡತಿಯಾದ ಸಾರಳನ್ನು ಆ ಗವಿಯಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಲಾಗಿದೆ. ಇಸಾಕನನ್ನು ಮತ್ತು ರೆಬೆಕ್ಕಳನ್ನು ಅಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಲಾಗಿದೆ. ನನ್ನ ಹೆಂಡತಿಯಾದ ಲೇಯಳನ್ನು ನಾನು ಅಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಿದ್ದೇನೆ. ಬೆನ್ಯಾಮೀನ ");
INSERT INTO kan2010_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ಆ ಗುಹೆಯನ್ನು ಮತ್ತು ಆ ಗುಹೆಯಿರುವ ಹೊಲವನ್ನು ಹಿತ್ತಿಯರಿಂದ ಕೊಂಡುಕೊಳ್ಳಲಾಗಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ಯಾಕೋಬನು ತನ್ನ ಗಂಡುಮಕ್ಕಳೊಂದಿಗೆ ಮಾತನಾಡಿದ ಮೇಲೆ ತನ್ನ ಹಾಸಿಗೆಯ ಮೇಲೆ ಕಾಲುಗಳನ್ನು ಮುದುರಿಕೊಂಡು ಪ್ರಾಣಬಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ಇಸ್ರೇಲನು ಸತ್ತಾಗ ಯೋಸೇಫನು ತುಂಬ ದುಃಖಿಸಿದನು. ಅವನು ತನ್ನ ತಂದೆಯನ್ನು ಅಪ್ಪಿಕೊಂಡು ಗೋಳಾಡಿ ಮುದ್ದಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯ ಶವವನ್ನು ಸಿದ್ಧಪಡಿಸಲು ತನ್ನ ಸೇವಕರಾದ ವೈದ್ಯರಿಗೆ ಹೇಳಿದನು. ಆ ವೈದ್ಯರು ಯಾಕೋಬನ ಶರೀರವನ್ನು ಸಮಾಧಿಮಾಡಲು ಸಿದ್ಧಪಡಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ಈಜಿಪ್ಟಿನವರು ಆ ಶರೀರವನ್ನು ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ನಲವತ್ತು ದಿನಗಳವರೆಗೆ ಸಿದ್ಧಪಡಿಸಿದರು. ಬಳಿಕ ಈಜಿಪ್ಟಿನವರು ಯಾಕೋಬನಿಗಾಗಿ ಎಪ್ಪತ್ತು ದಿನಗಳವರೆಗೆ ಗೋಳಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ಎಪ್ಪತ್ತು ದಿನಗಳಾದ ಮೇಲೆ ಯೋಸೇಫನು ಫರೋಹನ ಅಧಿಕಾರಿಗಳಿಗೆ, “ದಯವಿಟ್ಟು ಇದನ್ನು ಫರೋಹನಿಗೆ ತಿಳಿಸಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘ನನ್ನ ತಂದೆಯು ಸಾಯುವಾಗ ನಾನು ಅವನಿಗೆ ಒಂದು ಪ್ರಮಾಣವನ್ನು ಮಾಡಿದೆನು. ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಒಂದು ಗುಹೆಯನ್ನು ಅವನು ತನಗಾಗಿ ಸಿದ್ಧಪಡಿಸಿಕೊಂಡಿದ್ದಾನೆ. ಆದ್ದರಿಂದ, ನಾನು ಹೋಗಿ ನನ್ನ ತಂದೆಯನ್ನು ಸಮಾಧಿಮಾಡಿ ಮತ್ತೆ ಹಿಂತಿರುಗಿ ನಿಮ್ಮ ಬಳಿಗೆ ಬರಲು ದಯವಿಟ್ಟು ಅವಕಾಶ ಕೊಡಿ’ ಎಂದು ತಿಳಿಸಿರಿ” ಎಂಬುದಾಗಿ ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ಫರೋಹನು, “ನಿನ್ನ ಪ್ರಮಾಣವನ್ನು ಉಳಿಸಿಕೊ. ಹೋಗಿ ನಿನ್ನ ತಂದೆಯನ್ನು ಸಮಾಧಿಮಾಡು” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ಆದ್ದರಿಂದ ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯನ್ನು ಸಮಾಧಿಮಾಡಲು ಹೋದನು. ಫರೋಹನ ಎಲ್ಲಾ ಅಧಿಕಾರಿಗಳು ಯೋಸೇಫನೊಂದಿಗೆ ಹೋದರು. ಫರೋಹನ ನಾಯಕರು ಮತ್ತು ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ಹಿರಿಯರು ಯೋಸೇಫನೊಂದಿಗೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ಯೋಸೇಫನ ಕುಟುಂಬದಲ್ಲಿದ್ದ ಜನರು ಮತ್ತು ಅವನ ಸಹೋದರರು ಅವನೊಂದಿಗೆ ಹೋದರು. ಅವನ ತಂದೆಯ ಕುಟುಂಬದವರೆಲ್ಲ ಯೋಸೇಫನೊಂದಿಗೆ ಹೋದರು. (ಮಕ್ಕಳು ಮತ್ತು ಪ್ರಾಣಿಗಳು ಮಾತ್ರ ಗೋಷೆನ್ ಪ್ರಾಂತ್ಯದಲ್ಲಿ ಉಳಿದುಕೊಂಡರು.) ");
INSERT INTO kan2010_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ಗಂಡಸರು ಯೋಸೇಫನೊಂದಿಗೆ ರಥಗಳಲ್ಲಿ ಮತ್ತು ಕುದುರೆಗಳ ಮೇಲೆ ಹೋದರು. ಅದು ಬಹಳ ದೊಡ್ಡ ಗುಂಪಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ಅವರು ಗೋರೆನ್‌ಅಟಾದ್ ಎಂಬಲ್ಲಿಗೆ ಬಂದರು. ಅದು ಜೋರ್ಡನ್ ನದಿಯ ಪೂರ್ವದಲ್ಲಿತ್ತು. ಆ ಸ್ಥಳದಲ್ಲಿ ಅವರು ತುಂಬ ಸಮಯದವರೆಗೆ ಶೋಕಿಸಿದರು. ಆ ಶೋಕವು ಏಳು ದಿನಗಳವರೆಗೆ ಮುಂದುವರೆಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ಕಾನಾನಿನ ಜನರು ಗೋರೆನ್‌ಅಟಾದ್‌ನಲ್ಲಿ ಶೋಕಿಸುತ್ತಿರುವುದನ್ನು ನೋಡಿ, “ಈಜಿಪ್ಟಿನವರು ಬಹಳ ದುಃಖಕರವಾದ ಅಂತ್ಯಕ್ರಿಯೆಯನ್ನು ಮಾಡುತ್ತಿದ್ದಾರೆ” ಎಂದು ಹೇಳಿದರು. ಆದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಆಬೇಲ್ ಮಿಚ್ರಯೀಮ್ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ಹೀಗೆ ಯಾಕೋಬನ ಗಂಡುಮಕ್ಕಳು ತಮ್ಮ ತಂದೆಯ ಆಜ್ಞೆಯಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ಅವರು ಅವನ ಶರೀರವನ್ನು ಕಾನಾನ್ ದೇಶಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಮಕ್ಪೇಲದಲ್ಲಿದ್ದ ಗವಿಯಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಿದರು. ಮಮ್ರೆಯ ಬಯಲಿನಲ್ಲಿದ್ದ ಈ ಗವಿಯನ್ನು ಅಬ್ರಹಾಮನು ಹಿತ್ತಿಯನಾದ ಎಫ್ರೋನನಿಂದ ಸಮಾಧಿಯ ಸ್ಥಳಕ್ಕಾಗಿ ಕೊಂಡುಕೊಂಡಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ತಂದೆಯನ್ನು ಸಮಾಧಿ ಮಾಡಿದನಂತರ ಯೋಸೇಫನೂ ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರೂ ಅವನ ತಂದೆಯ ಉತ್ತರಕ್ರಿಯೆಗಾಗಿ ಅವನೊಂದಿಗೆ ಹೋಗಿದ್ದವರೆಲ್ಲರೂ ಈಜಿಪ್ಟಿಗೆ ಹಿಂತಿರುಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ಯಾಕೋಬನು ಸತ್ತಮೇಲೆ, ಯೋಸೇಫನ ಸಹೋದರರು ಕಳವಳಗೊಂಡರು. ಅವರು “ನಾವು ಮಾಡಿದ ಕಾರ್ಯಕ್ಕೆ ಯೋಸೇಫನು ಇನ್ನು ಮೇಲೆ ನಮ್ಮನ್ನು ದ್ವೇಷಿಸುವನೇ?” ಎಂದು ತಮ್ಮತಮ್ಮೊಳಗೆ ಮಾತಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ಆದ್ದರಿಂದ ಸಹೋದರರು ಯೋಸೇಫನಿಗೆ ಈ ಸಂದೇಶವನ್ನು ಕಳುಹಿಸಿದರು: “ನಿನ್ನ ತಂದೆ ಸಾಯುವ ಮೊದಲು ನಮಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ನೀವು ಯೋಸೇಫನಿಗೆ, ಈ ಸಂದೇಶವನ್ನು ಕೊಡಬೇಕು, ‘ನಾವು ಮಾಡಿದ್ದು ಕೆಟ್ಟಕಾರ್ಯವೇ ನಿಜ. ಅದಕ್ಕಾಗಿ ನೀನು ಅವರನ್ನು ಕ್ಷಮಿಸಬೇಕೆಂದು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತಿದ್ದೇನೆ.’ ಆದ್ದರಿಂದ ನಾವು ಮಾಡಿದ ಕೆಟ್ಟಕಾರ್ಯಕ್ಕಾಗಿ ನೀನು ನಮ್ಮನ್ನು ಕ್ಷಮಿಸಬೇಕು. ನಾವು ನಿನ್ನ ತಂದೆಯ ದೇವರಿಗೆ ಸೇವಕರಾಗಿದ್ದೇವೆ” ಎಂದು ಹೇಳಿದರು. ಈ ವಿಷಯಗಳನ್ನು ಕೇಳಿ ಅವನು ದುಃಖದಿಂದ ಅತ್ತನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ಸಹೋದರರು ಯೋಸೇಫನ ಬಳಿಗೆ ಹೋಗಿ ಅವನ ಮುಂದೆ ಅಡ್ಡಬಿದ್ದು, “ನಾವು ನಿನ್ನ ಸೇವಕರಾಗಿದ್ದೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ಆಗ ಯೋಸೇಫನು ಅವರಿಗೆ, “ಭಯಪಡಬೇಡಿ. ನಾನು ದೇವರಲ್ಲ; ನಿಮ್ಮನ್ನು ಶಿಕ್ಷಿಸಲು ನನಗೆ ಅಧಿಕಾರವಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ನೀವು ನನಗೆ ಕೇಡುಮಾಡಲು ಯೋಚಿಸಿದಿರಿ. ಆದರೆ ದೇವರು ಒಳ್ಳೆಯದನ್ನೇ ಮಾಡಿದನು. ಬಹಳ ಜನರ ಪ್ರಾಣವನ್ನು ಉಳಿಸುವುದಕ್ಕಾಗಿ ನನ್ನನ್ನು ಬಳಸಿಕೊಳ್ಳುವುದು ದೇವರ ಯೋಜನೆಯಾಗಿತ್ತು. ಈಗಲೂ ಆತನದು ಅದೇ ಯೋಜನೆ. ");
INSERT INTO kan2010_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ಆದ್ದರಿಂದ ಭಯಪಡದಿರಿ. ನಾನು ನಿಮ್ಮನ್ನೂ ನಿಮ್ಮ ಮಕ್ಕಳನ್ನೂ ಪೋಷಿಸುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ಯೋಸೇಫನು ತನ್ನ ಸಹೋದರರೊಂದಿಗೆ ಸೌಮ್ಯವಾಗಿ ಮಾತನಾಡಿದ್ದರಿಂದ ಅವರಿಗೆ ತುಂಬ ಸಂತೋಷವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ಯೋಸೇಫನು ತನ್ನ ತಂದೆಯ ಕುಟುಂಬದವರೊಂದಿಗೆ ಈಜಿಪ್ಟಿನಲ್ಲೇ ವಾಸವಾಗಿದ್ದನು. ಯೋಸೇಫನು ತನ್ನ ನೂರಹತ್ತನೆಯ ವರ್ಷದಲ್ಲಿ ತೀರಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ಯೋಸೇಫನು ಜೀವದಿಂದಿದ್ದ ಕಾಲದಲ್ಲಿ, ಎಫ್ರಾಯೀಮನು ಮಕ್ಕಳನ್ನೂ ಮೊಮ್ಮಕ್ಕಳನ್ನೂ ಪಡೆದನು. ಅವನ ಮಗನಾದ ಮನಸ್ಸೆಗೆ ಮಾಕೀರನೆಂಬ ಗಂಡುಮಗನು ಹುಟ್ಟಿದನು. ಯೋಸೇಫನು ಮಾಕೀರನ ಮಕ್ಕಳನ್ನೂ ನೋಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ಯೋಸೇಫನಿಗೆ ಸಾವು ಸಮೀಪಿಸಿದಾಗ ಅವನು ತನ್ನ ಸಹೋದರರಿಗೆ, “ನಾನು ಸಾಯುವ ಕಾಲ ಸಮೀಪಿಸಿದೆ. ಆದರೆ ನಿಮ್ಮನ್ನು ಪೋಷಿಸುವವನು ದೇವರೆಂಬುದು ನಿಮಗೆ ತಿಳಿದಿರಲಿ. ಆತನು ಈ ದೇಶದಿಂದ ನಿಮ್ಮನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗಿ ಅಬ್ರಹಾಮನಿಗೂ ಇಸಾಕನಿಗೂ ಮತ್ತು ಯಾಕೋಬನಿಗೂ ವಾಗ್ದಾನ ಮಾಡಿದ್ದ ದೇಶವನ್ನು ಕೊಡುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ಆಗ ಯೋಸೇಫನು ತನ್ನ ಜನರಿಗೆ ಪ್ರಮಾಣ ಮಾಡಬೇಕೆಂದು ಕೇಳಿಕೊಂಡನು. ಯೋಸೇಫನು, “ದೇವರು ನಿಮ್ಮನ್ನು ಈ ದೇಶದಿಂದ ಹೊರಗೆ ನಡೆಸಿದಾಗ ನನ್ನ ಮೂಳೆಗಳನ್ನು ನಿಮ್ಮೊಂದಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗುವಿರೆಂದು ನೀವು ಪ್ರಮಾಣ ಮಾಡಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ಯೋಸೇಫನು ನೂರಹತ್ತನೆಯ ವರ್ಷದವನಾಗಿದ್ದಾಗ ಸತ್ತುಹೋದನು. ಈಜಿಪ್ಟಿನಲ್ಲಿ ವೈದ್ಯರು ಅವನ ಶರೀರವನ್ನು ಸಮಾಧಿ ಮಾಡಲು ಸಿದ್ಧಪಡಿಸಿ, ಶವಪೆಟ್ಟಿಗೆಯಲ್ಲಿ ಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ಯಾಕೋಬನು (ಇಸ್ರೇಲನು) ತನ್ನ ಗಂಡುಮಕ್ಕಳೊಂದಿಗೆ ಈಜಿಪ್ಟಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದನು; ತಮ್ಮ ಕುಟುಂಬಗಳೊಡನೆ ಹೋದ ಅವನ ಗಂಡುಮಕ್ಕಳು ಯಾರೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ರೂಬೇನ್, ಸಿಮೆಯೋನ್, ಲೇವಿ, ಯೆಹೂದ, ");
INSERT INTO kan2010_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ಇಸ್ಸಾಕಾರ್, ಜೆಬುಲೂನ್, ಬೆನ್ಯಾಮೀನ್, ");
INSERT INTO kan2010_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ದಾನ್, ನಫ್ತಾಲಿ, ಗಾದ್ ಮತ್ತು ಆಶೇರ್. ");
INSERT INTO kan2010_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ಯಾಕೋಬನ ಸಂತತಿಯವರಲ್ಲಿ ಒಟ್ಟು ಎಪ್ಪತ್ತು ಮಂದಿ ಇದ್ದರು. (ಯಾಕೋಬನ ಹನ್ನೆರಡು ಮಂದಿ ಗಂಡುಮಕ್ಕಳಲ್ಲಿ ಒಬ್ಬನಾದ ಯೋಸೇಫನು ಮೊದಲೇ ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದನು.) ");
INSERT INTO kan2010_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ಬಳಿಕ ಯೋಸೇಫನೂ ಅವನ ಸಹೋದರರೂ ಮತ್ತು ಆ ತಲೆಮಾರಿನ ಜನರೆಲ್ಲರೂ ಸತ್ತುಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ಆದರೆ ಇಸ್ರೇಲರಿಗೆ ಅನೇಕ ಮಕ್ಕಳಿದ್ದರು; ಅವರ ಸಂಖ್ಯೆಯು ಹೆಚ್ಚಾಗತೊಡಗಿತು. ಇಸ್ರೇಲರು ಬಲಗೊಂಡರು; ಈಜಿಪ್ಟಿನಲ್ಲೆಲ್ಲಾ ತುಂಬಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ಬಳಿಕ ಒಬ್ಬ ಹೊಸ ರಾಜನು ಈಜಿಪ್ಟನ್ನು ಆಳತೊಡಗಿದನು. ಈ ರಾಜನಿಗೆ ಯೋಸೇಫನ ವಿಷಯವಾಗಿ ತಿಳಿದಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ಈ ರಾಜನು ತನ್ನ ಜನರಿಗೆ, “ಇಸ್ರೇಲರ ಸಂಖ್ಯೆಯು ಹೆಚ್ಚಾಯಿತು; ಅವರು ನಮಗಿಂತಲೂ ಬಲಿಷ್ಠರಾದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ಯುದ್ಧವೇನಾದರೂ ಸಂಭವಿಸಿದರೆ, ಇಸ್ರೇಲರು ನಮ್ಮ ವೈರಿಗಳೊಡನೆ ಸೇರಿಕೊಂಡು ನಮ್ಮನ್ನು ಸೋಲಿಸಿ ನಮ್ಮಿಂದ ತಪ್ಪಿಸಿಕೊಳ್ಳಬಹುದು. ಆದ್ದರಿಂದ ಅವರು ಅಭಿವೃದ್ಧಿಯಾಗದಂತೆ ನಾವು ಉಪಾಯವನ್ನು ಮಾಡೋಣ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ಆದ್ದರಿಂದ ಅವರು ಇಸ್ರೇಲರನ್ನು ಹಿಂಸಿಸಲು ತೀರ್ಮಾನಿಸಿದರು. ಇಸ್ರೇಲರಿಂದ ಬಿಟ್ಟೀಕೆಲಸ ಮಾಡಿಸುವುದಕ್ಕಾಗಿ ಅಧಿಕಾರಿಗಳನ್ನು ನೇಮಿಸಿದರು. ಈ ಅಧಿಕಾರಿಗಳು ರಾಜನಿಗಾಗಿ ಪಿತೋಮ್ ಮತ್ತು ರಾಮ್ಸೇಸ್ ಪಟ್ಟಣಗಳನ್ನು ಇಸ್ರೇಲರಿಂದ ಬಲವಂತವಾಗಿ ಕಟ್ಟಿಸಿದರು; ಧಾನ್ಯಗಳನ್ನು ಮತ್ತು ಇನ್ನಿತರ ವಸ್ತುಗಳನ್ನು ಶೇಖರಿಸುವುದಕ್ಕೆ ರಾಜನು ಈ ಪಟ್ಟಣಗಳನ್ನು ಉಪಯೋಗಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ಈಜಿಪ್ಟಿನವರು ಇಸ್ರೇಲರಿಂದ ಪ್ರಯಾಸಕರವಾದ ಕೆಲಸಗಳನ್ನು ಬಲವಂತವಾಗಿ ಮಾಡಿಸಿದಷ್ಟೂ ಇಸ್ರೇಲರು ಹೆಚ್ಚು ಹರಡಿಕೊಂಡದ್ದರಿಂದ ಈಜಿಪ್ಟಿನ ಜನರು ಇಸ್ರೇಲರಿಗೆ ಹೆಚ್ಚೆಚ್ಚಾಗಿ ಭಯಪಟ್ಚರು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ಅಲ್ಲದೆ ಇನ್ನೂ ಪ್ರಯಾಸಕರವಾದ ಕೆಲಸವನ್ನು ಬಲವಂತದಿಂದ ಮಾಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ಈಜಿಪ್ಟಿನವರು ಇಸ್ರೇಲರ ಜೀವಿತವನ್ನು ಕಷ್ಟಕರವನ್ನಾಗಿ ಮಾಡಿದರು. ಇಸ್ರೇಲರಿಂದ ಇಟ್ಟಿಗೆಗಳನ್ನೂ ಗಾರೆಗಳನ್ನೂ ಬೇಸಾಯವನ್ನೂ ಪ್ರತಿಯೊಂದು ಕೆಲಸವನ್ನು ಬಲವಂತವಾಗಿ ಮಾಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ಇಸ್ರೇಲಿನ ಸ್ತ್ರೀಯರಿಗೆ ಹೆರಿಗೆ ಮಾಡಿಸಲು ಇಬ್ರಿಯರಾದ ಇಬ್ಬರು ದಾದಿಯರಿದ್ದರು. ಇವರ ಹೆಸರು: ಶಿಫ್ರಾ ಮತ್ತು ಪೂಗಾ. ಈಜಿಪ್ಟಿನ ರಾಜನು ಈ ದಾದಿಯರೊಡನೆ ಮಾತಾಡಿ ಅವರಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“ಇಬ್ರಿಯ ಸ್ತ್ರೀಯರಿಗೆ ನೀವು ಹೆರಿಗೆ ಮಾಡುವಾಗ ಹೆಣ್ಣುಮಗು ಹುಟ್ಟಿದರೆ, ಅದನ್ನು ಉಳಿಸಿರಿ; ಗಂಡುಮಗು ಹುಟ್ಟಿದರೆ ಸಾಯಿಸಿರಿ!” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ಆದರೆ ಆ ದಾದಿಯರಿಗೆ ದೇವರಲ್ಲಿ ಭಯಭಕ್ತಿ ಇದ್ದಕಾರಣ ಅವರು ರಾಜನ ಆಜ್ಞೆಗೆ ವಿಧೇಯರಾಗದೆ ಗಂಡುಮಕ್ಕಳನ್ನೂ ಉಳಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ಈಜಿಪ್ಟಿನ ರಾಜನು ದಾದಿಯರನ್ನು ಕರೆದು, “ನೀವು ಹೀಗೇಕೆ ಮಾಡುತ್ತಿದ್ದೀರಿ? ಗಂಡುಮಕ್ಕಳನ್ನು ನೀವು ಉಳಿಸುತ್ತಿರುವುದೇಕೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ದಾದಿಯರು, “ಇಬ್ರಿಯ ಸ್ತ್ರೀಯರು ಈಜಿಪ್ಟಿನ ಸ್ತ್ರೀಯರಿಗಿಂತ ಚುರುಕಾಗಿದ್ದಾರೆ. ನಾವು ಅವರಿಗೆ ಸಹಾಯ ಮಾಡುವುದಕ್ಕಿಂತ ಮೊದಲೇ ಅವರು ಹೆರುತ್ತಾರೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","ಈ ದಾದಿಯರು ದೇವರಲ್ಲಿ ಭಯಭಕ್ತಿಯುಳ್ಳವರಾಗಿದ್ದ ಕಾರಣ ಆತನು ಅವರನ್ನೂ ಅವರ ಕುಟುಂಬಗಳನ್ನೂ ಅಭಿವೃದ್ಧಿಪಡಿಸಿದನು. ಇದಲ್ಲದೆ ಇಸ್ರೇಲರ ಸಂಖ್ಯೆಯು ಅಧಿಕವಾಗಿ ಬೆಳೆಯತೊಡಗಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ಆದ್ದರಿಂದ ಫರೋಹನು ತನ್ನ ಜನರಿಗೆಲ್ಲಾ, “ಇಬ್ರಿಯರಿಗೆ ಹುಟ್ಟುವ ಗಂಡುಕೂಸುಗಳನ್ನೆಲ್ಲಾ ನೈಲ್ ನದಿಗೆ ಎಸೆದುಬಿಡಬೇಕು. ಆದರೆ ಎಲ್ಲಾ ಹೆಣ್ಣುಮಕ್ಕಳು ಬದುಕಲಿ” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ಲೇವಿ ಕುಟುಂಬದ ಒಬ್ಬನು ಲೇವಿ ಕುಟುಂಬಕ್ಕೆ ಸೇರಿದ ಸ್ತ್ರೀಯೊಬ್ಬಳನ್ನು ಮದುವೆಯಾದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ಆ ಸ್ತ್ರೀಯು ಗರ್ಭಿಣಿಯಾಗಿ ಗಂಡುಮಗುವಿಗೆ ಜನ್ಮವಿತ್ತಳು. ಮಗುವು ಸುಂದರವಾಗಿತ್ತು. ಆಕೆ ಮೂರು ತಿಂಗಳವರೆಗೆ ಆ ಮಗುವನ್ನು ಬಚ್ಚಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ಇನ್ನೂ ಹೆಚ್ಚು ಕಾಲ ಬಚ್ಚಿಡಲಾಗದೆ ಆಕೆ ಒಂದು ಬುಟ್ಟಿಯನ್ನು ಮಾಡಿ ಅದಕ್ಕೆ ರಾಳವನ್ನು ಹಚ್ಚಿದಳು. ಆಕೆ ಮಗುವನ್ನು ಬುಟ್ಟಿಯಲ್ಲಿಟ್ಟು ಆ ಬುಟ್ಟಿಯನ್ನು ನೀರಿನಲ್ಲಿ ಎತ್ತರವಾಗಿ ಬೆಳೆದ ಹುಲ್ಲಿನಲ್ಲಿ ಇಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ಮಗುವಿಗೆ ಏನಾಗುವುದೋ ಎಂದು ನೋಡಲು ಮಗುವಿನ ಅಕ್ಕ ಅಲ್ಲಿದ್ದುಕೊಂಡು ಕಾಯುತ್ತಿದ್ದಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ಅದೇ ಸಮಯದಲ್ಲಿ ಫರೋಹನ ಮಗಳು ಸ್ನಾನ ಮಾಡುವುದಕ್ಕೆ ನದಿಗೆ ಹೋದಳು. ಆಕೆಯ ಸೇವಕಿಯರು ನದಿಯ ದಡದಲ್ಲಿ ತಿರುಗಾಡುತ್ತಿದ್ದರು. ಆಕೆ ಎತ್ತರವಾದ ಹುಲ್ಲಿನ ಮೇಲಿದ್ದ ಬುಟ್ಟಿಯನ್ನು ನೋಡಿ ತನ್ನ ಸೇವಕಿಯರಲ್ಲಿ ಒಬ್ಬಳಿಗೆ, “ಹೋಗಿ ಅದನ್ನು ತೆಗೆದುಕೊಂಡು ಬಾ” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ರಾಜನ ಮಗಳು ಬುಟ್ಟಿಯನ್ನು ತೆಗೆದು ನೋಡಿದಾಗ ಅಳುತ್ತಿದ್ದ ಗಂಡುಮಗುವನ್ನು ಕಂಡಳು. ಆಕೆಗೆ ಅದರ ಮೇಲೆ ಮರುಕವಾಯಿತು. ಆಕೆ, “ಇದು ಇಬ್ರಿಯರ ಮಗು” ಎಂದು ಹೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ಮಗುವಿನ ಅಕ್ಕ ಆಕೆಯ ಬಳಿಗೆ ಬಂದು, “ಮಗುವಿಗೆ ಹಾಲು ಕುಡಿಸಲು ಒಬ್ಬ ಇಬ್ರಿಯ ಸ್ತ್ರೀಯನ್ನು ಕರೆದುಕೊಂಡು ಬರಲೇ?” ಎಂದು ಕೇಳಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ಅರಸನ ಮಗಳು, “ಹೋಗಿ, ಕರೆದುಕೊಂಡು ಬಾ” ಅಂದಳು. ಆದ್ದರಿಂದ ಆ ಹುಡುಗಿ ಹೋಗಿ ಮಗುವಿನ ಸ್ವಂತ ತಾಯಿಯನ್ನು ಕರೆದುಕೊಂಡು ಬಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ರಾಜನ ಮಗಳು ತಾಯಿಗೆ, “ಈ ಮಗುವಿಗೆ ಹಾಲು ಕುಡಿಸಿ ನೋಡಿಕೊ, ನಾನು ನಿನಗೆ ಸಂಬಳ ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದಳು. ಆದ್ದರಿಂದ ಆ ಸ್ತ್ರೀ ತನ್ನ ಮಗುವನ್ನು ತೆಗೆದುಕೊಂಡು ಸಾಕಿದಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ಮಗುವು ಬೆಳೆಯಿತು. ಸ್ವಲ್ಪಕಾಲದ ನಂತರ ಆ ಸ್ತ್ರೀಯು ಬಾಲಕನನ್ನು ರಾಜನ ಮಗಳ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದಳು. ರಾಜನ ಮಗಳು ಆ ಬಾಲಕನನ್ನು ತನ್ನ ಸ್ವಂತ ಮಗನೆಂದು ಸ್ವೀಕರಿಸಿದಳು. ಆ ಬಾಲಕನನ್ನು ನೀರಿನೊಳಗಿಂದ ಎಳೆದೆನೆಂದು ಆ ಬಾಲಕನಿಗೆ “ಮೋಶೆ” ಎಂದು ಹೆಸರಿಟ್ಟಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ಮೋಶೆಯು ಬೆಳೆದು ದೊಡ್ಡವನಾದನು. ತನ್ನ ಜನರಾದ ಇಬ್ರಿಯರು ಬಲವಂತಕ್ಕೊಳಗಾಗಿ ಪ್ರಯಾಸಕರವಾದ ಬಿಟ್ಟೀಕೆಲಸಗಳನ್ನು ಮಾಡುವುದನ್ನು ನೋಡಿದನು. ಒಂದು ದಿನ ಈಜಿಪ್ಟಿನವನೊಬ್ಬನು ಇಬ್ರಿಯನೊಬ್ಬನನ್ನು ಹೊಡೆಯುವುದನ್ನು ಕಂಡ ");
INSERT INTO kan2010_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ಮೋಶೆಯು ಸುತ್ತಲೂ ನೋಡಿ ಯಾರೂ ಗಮನಿಸುತ್ತಿಲ್ಲವೆಂದು ತಿಳಿದುಕೊಂಡು ಈಜಿಪ್ಟಿನವನನ್ನು ಕೊಂದು ಮರಳಿನಲ್ಲಿ ಮುಚ್ಚಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ಮರುದಿನ, ಇಬ್ಬರು ಇಬ್ರಿಯರು ಜಗಳವಾಡುತ್ತಿರುವುದನ್ನು ಕಂಡ ಮೋಶೆಯು ಅವರಲ್ಲಿ ತಪ್ಪು ಮಾಡಿದವನಿಗೆ, “ನಿನ್ನ ನೆರೆಯವನಿಗೆ ಯಾಕೆ ಹೊಡೆಯುತ್ತಿರುವೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ಅದಕ್ಕೆ ಆ ಮನುಷ್ಯನು, “ನಿನ್ನನ್ನು ನಮ್ಮ ಅಧಿಕಾರಿಯನ್ನಾಗಿಯೂ ನ್ಯಾಯಾಧಿಪತಿಯನ್ನಾಗಿಯೂ ಮಾಡಿದವರು ಯಾರು? ನಿನ್ನೆ ಆ ಈಜಿಪ್ಟಿನವನನ್ನು ಕೊಂದಂತೆ ನನ್ನನ್ನೂ ಕೊಲ್ಲಬೇಕೆಂದಿರುವಿಯೋ?” ಎಂದು ಉತ್ತರಿಸಿದನು. ಆಗ ಮೋಶೆಗೆ ಭಯವಾಯಿತು. ಮೋಶೆಯು ತನ್ನೊಳಗೆ, “ನಾನು ಮಾಡಿದ್ದು ಪ್ರತಿಯೊಬ್ಬರಿಗೂ ತಿಳಿದಿದೆ” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ಮೋಶೆಯು ಮಾಡಿದ್ದು ಫರೋಹನಿಗೂ ತಿಳಿಯಿತು. ಆದ್ದರಿಂದ ಮೋಶೆಯನ್ನು ಕೊಲ್ಲಿಸಲು ಅವನು ತೀರ್ಮಾನಿಸಿದನು. ಆದರೆ ಮೋಶೆ ಫರೋಹನ ಬಳಿಯಿಂದ ಮಿದ್ಯಾನ್ ದೇಶಕ್ಕೆ ಓಡಿಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ಮೋಶೆಯು ಮಿದ್ಯಾನ್ಯರ ಒಂದು ಬಾವಿಯ ಬಳಿ ಕುಳಿತುಕೊಂಡಿದ್ದನು. ಮಿದ್ಯಾನ್ಯರ ಒಬ್ಬ ಪುರೋಹಿತನಿಗೆ ಏಳು ಮಂದಿ ಹೆಣ್ಣುಮಕ್ಕಳಿದ್ದರು. ಆ ಹುಡುಗಿಯರು ಬಂದು ತಮ್ಮ ತಂದೆಯ ಕುರಿಗಳಿಗೆ ನೀರನ್ನು ಕುಡಿಸಲು ಬಾವಿಯಿಂದ ನೀರು ಸೇದಿ ತೊಟ್ಟಿಗಳಲ್ಲಿ ಹಾಕುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ಅಷ್ಟರಲ್ಲಿ ಅಲ್ಲಿಗೆ ಬಂದ ಕೆಲವು ಕುರುಬರು ನೀರು ಸೇದಲು ಅವರಿಗೆ ಅಡ್ಡಿಮಾಡಿದ್ದರಿಂದ ಮೋಶೆಯು ಅವರಿಗೆ ಸಹಾಯಕನಾಗಿ ಬಂದು ಅವರ ಕುರಿಗಳಿಗೆ ನೀರು ಕುಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ಬಳಿಕ ಅವರು ತಮ್ಮ ತಂದೆಯಾದ ರೆಗೂವೇಲನ ಬಳಿಗೆ ಮರಳಿಹೋದರು. ಅವರ ತಂದೆ, “ಈ ದಿನ ನೀವು ಬಹುಬೇಗನೆ ಮನೆಗೆ ಬಂದಿದ್ದೀರಲ್ಲಾ!” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ಆ ಹುಡುಗಿಯರು, “ಕುರುಬರು ನಮಗೆ ಅಡ್ಡಿ ಮಾಡಿದಾಗ ಈಜಿಪ್ಟಿನವನೊಬ್ಬನು ನಮ್ಮ ನೆರವಿಗೆ ಬಂದು ನಮಗೂ ನಮ್ಮ ಕುರಿಗಳಿಗೂ ನೀರು ಸೇದಿ ಕೊಟ್ಟನು” ಎಂದು ಉತ್ತರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ಅದಕ್ಕೆ ರೆಗೂವೇಲನು ತನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳಿಗೆ, “ಆ ಮನುಷ್ಯನು ಎಲ್ಲಿದ್ದಾನೆ? ಅವನನ್ನು ನೀವು ಯಾಕೆ ಬಿಟ್ಟುಬಂದಿರಿ? ಅವನನ್ನು ಕರೆಯಿರಿ; ಅವನು ನಮ್ಮೊಂದಿಗೆ ಊಟಮಾಡಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ಮೋಶೆಯು ರೆಗೂವೇಲನೊಂದಿಗೆ ವಾಸಮಾಡಲು ಇಷ್ಟಪಟ್ಟನು; ರೆಗೂವೇಲನು ತನ್ನ ಮಗಳಾದ ಚಿಪ್ಪೋರಳನ್ನು ಮೋಶೆಗೆ ಮದುವೆ ಮಾಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ಚಿಪ್ಪೋರಳು ಗಂಡುಮಗುವಿಗೆ ಜನ್ಮವಿತ್ತಳು. ಮೋಶೆಯು ಅನ್ಯದೇಶದಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿದ್ದ ಕಾರಣ ಆ ಮಗುವಿಗೆ “ಗೇರ್ಷೋಮ್” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ಸ್ವಲ್ಪಕಾಲದ ಬಳಿಕ ಈಜಿಪ್ಟಿನ ರಾಜನೂ ಸತ್ತುಹೋದನು. ಇಸ್ರೇಲರು ತಾವು ಮಾಡಬೇಕಾದ ಪ್ರಯಾಸಕರವಾದ ಬಿಟ್ಟೀಕೆಲಸದಿಂದ ನಿಟ್ಟುಸಿರುಬಿಡುತ್ತಾ ಗೋಳಾಡುತ್ತಾ ಇದ್ದರು. ಅವರ ಗೋಳು ದೇವರಿಗೆ ಮುಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ದೇವರು ಅವರ ನರಳಾಟವನ್ನು ಕೇಳಿ ತಾನು ಅಬ್ರಹಾಮನೊಂದಿಗೂ ಇಸಾಕನೊಂದಿಗೂ ಯಾಕೋಬನೊಂದಿಗೂ ಮಾಡಿದ ಒಡಂಬಡಿಕೆಯನ್ನು ಜ್ಞಾಪಕ ಮಾಡಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ದೇವರು ಇಸ್ರೇಲರ ಸಂಕಟಗಳನ್ನು ನೋಡಿ ಅವರಿಗೆ ಸಹಾಯಮಾಡಲು ನಿಶ್ಚಯಿಸಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ಮೋಶೆಯ ಮಾವನ ಹೆಸರು ಇತ್ರೋನನು. ಇತ್ರೋನನು ಮಿದ್ಯಾನಿನ ಯಾಜಕನಾಗಿದ್ದನು. ಮೋಶೆಯು ಇತ್ರೋನನ ಕುರಿಗಳಿಗೆ ಕುರುಬನಾಗಿದ್ದನು. ಒಂದು ದಿನ, ಮೋಶೆಯು ಕುರಿಗಳನ್ನು ಮರುಭೂಮಿಯ ಪಶ್ಚಿಮಭಾಗಕ್ಕೆ ನಡೆಸಿಕೊಂಡು ದೇವರ ಬೆಟ್ಟವೆಂದು ಕರೆಯಲ್ಪಡುವ ಸೀನಾಯಿ ಎಂಬ ಹೋರೇಬ್ ಬೆಟ್ಟಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ಆ ಬೆಟ್ಟದಲ್ಲಿ ಯೆಹೋವನ ದೂತನು ಮೋಶೆಗೆ ಉರಿಯುವ ಪೊದೆಯಲ್ಲಿ ಕಾಣಿಸಿಕೊಂಡನು. ಪೊದೆಯು ಉರಿಯುತ್ತಿದ್ದರೂ ಸುಟ್ಟು ಹೋಗದಿರುವುದನ್ನು ಮೋಶೆ ಗಮನಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ಪೊದೆಯು ಉರಿಯುತ್ತಿದ್ದರೂ ಸುಟ್ಟುಹೋಗದಿರುವುದಕ್ಕೆ ಕಾರಣವೇನೆಂದು ತಿಳಿದುಕೊಳ್ಳಲು ಮೋಶೆಯು ಪೊದೆಯ ಸಮೀಪಕ್ಕೆ ಹೋಗತೊಡಗಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ಮೋಶೆಯು ಪೊದೆಯನ್ನು ನೋಡಲು ಬರುತ್ತಿರುವುದನ್ನು ಯೆಹೋವನು ನೋಡಿದನು. ದೇವರು ಆ ಪೊದೆಯೊಳಗಿಂದ, “ಮೋಶೆ, ಮೋಶೆ!” ಎಂದು ಕರೆದನು. ಅದಕ್ಕೆ ಮೋಶೆ, “ಇಗೋ ಇದ್ದೇನೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ಆಗ ಯೆಹೋವನು, “ಇನ್ನೂ ಹತ್ತಿರ ಬರಬೇಡ. ನಿನ್ನ ಪಾದರಕ್ಷೆಗಳನ್ನು ತೆಗೆದುಹಾಕು. ಏಕೆಂದರೆ ನೀನು ನಿಂತಿರುವ ಸ್ಥಳವು ಪರಿಶುದ್ಧ ಭೂಮಿಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ನಾನು ನಿನ್ನ ಪೂರ್ವಿಕರ ದೇವರು, ನಾನು ಅಬ್ರಹಾಮನ ದೇವರು, ನಾನು ಇಸಾಕನ ದೇವರು, ನಾನು ಯಾಕೋಬನ ದೇವರು” ಎಂದು ಹೇಳಿದನು. ದೇವರನ್ನು ನೋಡುವುದಕ್ಕೆ ಭಯಪಟ್ಟು ಮೋಶೆ ತನ್ನ ಮುಖವನ್ನು ಮುಚ್ಚಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ಆಗ ಯೆಹೋವನು, “ನನ್ನ ಜನರು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಅನುಭವಿಸುತ್ತಿರುವ ಕಷ್ಟಗಳನ್ನು ನೋಡಿದ್ದೇನೆ. ಅಧಿಕಾರಿಗಳು ಅವರನ್ನು ಹಿಂಸಿಸುವಾಗ ಅವರು ಇಟ್ಟ ಮೊರೆಯನ್ನು ಕೇಳಿದ್ದೇನೆ. ಅವರ ದುಃಖವನ್ನೆಲ್ಲಾ ಬಲ್ಲೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ಈಗ ನಾನು ಇಳಿದುಹೋಗಿ ಈಜಿಪ್ಟಿನವರಿಂದ ನನ್ನ ಜನರನ್ನು ರಕ್ಷಿಸುವೆನು. ನಾನು ಅವರನ್ನು ಆ ದೇಶದಿಂದ ಬಿಡುಗಡೆ ಮಾಡಿ ಒಳ್ಳೆಯದಾದ ಮತ್ತು ವಿಶಾಲವಾದ ದೇಶಕ್ಕೆ ಅವರನ್ನು ನಡೆಸುವೆನು. ಅದು ಸಮೃದ್ಧಿಕರವಾದ ದೇಶ. ಕಾನಾನ್ಯರು, ಹಿತ್ತಿಯರು, ಅಮೋರಿಯರು, ಪೆರಿಜೀಯರು, ಹಿವ್ವಿಯರು ಮತ್ತು ಯೆಬೂಸಿಯರು ವಾಸವಾಗಿರುವ ದೇಶ ಅದಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ನಾನು ಇಸ್ರೇಲರ ಮೊರೆಯನ್ನು ಕೇಳಿದ್ದೇನೆ. ಈಜಿಪ್ಟಿನವರು ಅವರಿಗೆ ಕೊಡುವ ಹಿಂಸೆಯನ್ನು ನೋಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ಆದ್ದರಿಂದ ನಾನು ನಿನ್ನನ್ನು ಫರೋಹನ ಬಳಿಗೆ ಕಳುಹಿಸುತ್ತಿದ್ದೇನೆ. ಹೋಗು! ನನ್ನ ಜನರಾದ ಇಸ್ರೇಲರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಬಿಡುಗಡೆ ಮಾಡು!” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ಅದಕ್ಕೆ ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, “ನಾನು ಮಹಾ ವ್ಯಕ್ತಿಯೇನಲ್ಲ! ಫರೋಹನ ಸನ್ನಿಧಾನಕ್ಕೆ ಹೋಗುವುದಕ್ಕೂ ಇಸ್ರೇಲರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಬಿಡಿಸಿಕೊಂಡು ಬರುವುದಕ್ಕೂ ನಾನೆಷ್ಟರವನು?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ಅದಕ್ಕೆ ದೇವರು “ನೀನು ಇದನ್ನು ಮಾಡಬಹುದು; ಯಾಕೆಂದರೆ ನಾನೇ ನಿನ್ನೊಂದಿಗೆ ಇರುವೆನು. ನಿನ್ನನ್ನು ಕಳುಹಿಸಿದವನು ನಾನೇ ಎಂಬುದಕ್ಕೆ ಇದೇ ಸಾಕ್ಷಿಯಾಗಿರುವುದು. ನೀನು ಇಸ್ರೇಲರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಬಿಡಿಸಿಕೊಂಡು ಬಂದಮೇಲೆ ಈ ಬೆಟ್ಟಕ್ಕೆ ಬಂದು ನೀನು ನನ್ನನ್ನು ಆರಾಧಿಸುವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ಆಗ ಮೋಶೆಯು ದೇವರಿಗೆ, “ನಾನು ಇಸ್ರೇಲರ ಬಳಿಗೆ ಹೋಗಿ ‘ನಿಮ್ಮ ಪೂರ್ವಿಕರ ದೇವರು ನನ್ನನ್ನು ನಿಮ್ಮ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾನೆ’ ಎಂದು ಹೇಳಿದರೆ, ಅವರು ‘ಆತನ ಹೆಸರೇನು?’ ಎಂದು ಕೇಳುವರು. ಆಗ ನಾನು ಅವರಿಗೆ ಏನು ಹೇಳಬೇಕು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ಆಗ ದೇವರು ಮೋಶೆಗೆ, “ನಾನು ‘ಇರುವಾತನೇ’ ಆಗಿದ್ದೇನೆ. ನೀನು ಇಸ್ರೇಲರ ಬಳಿಗೆ ಹೋದಾಗ ‘ಇರುವಾತನೇ’ ಎಂಬವನು ನನ್ನನ್ನು ನಿಮ್ಮ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾನೆ ಎಂದು ಹೇಳು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ಇದಲ್ಲದೆ ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಇಸ್ರೇಲರಿಗೆ, ‘ನಿಮ್ಮ ಪೂರ್ವಿಕರ ದೇವರೂ ಅಬ್ರಹಾಮನ ದೇವರೂ ಇಸಾಕನ ದೇವರೂ ಯಾಕೋಬನ ದೇವರೂ ಆಗಿರುವ ಯೆಹೋವನು ನಿಮ್ಮಲ್ಲಿಗೆ ನನ್ನನ್ನು ಕಳುಹಿಸಿದ್ದಾನೆ. ಇದೇ ನನ್ನ ಶಾಶ್ವತವಾದ ಹೆಸರು; ತಲತಲಾಂತರಕ್ಕೂ ನನ್ನನ್ನು ಸ್ಮರಿಸಬೇಕಾದ ಹೆಸರು ಇದೇ ಎಂದು ಹೇಳಬೇಕು’” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ಇದಲ್ಲದೆ ಯೆಹೋವನು ಅವನಿಗೆ, “ನೀನು ಹೋಗಿ ಇಸ್ರೇಲರ ನಾಯಕರನ್ನು ಒಟ್ಟುಗೂಡಿಸಿ ಅವರಿಗೆ, ‘ನಿಮ್ಮ ಪೂರ್ವಿಕರ ದೇವರಾದ ಯೆಹೋವನು ನನಗೆ ಕಾಣಿಸಿಕೊಂಡನು. ಅಬ್ರಹಾಮನ, ಇಸಾಕನ, ಯಾಕೋಬನ ದೇವರು ಹೇಳುವುದೇನೆಂದರೆ, ಈಜಿಪ್ಟಿನಲ್ಲಿ ನಿಮಗೆ ಸಂಭವಿಸಿದವುಗಳನ್ನು ನಾನು ಲಕ್ಷ್ಯವಿಟ್ಟು ನೋಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ಈಜಿಪ್ಟಿನಲ್ಲಿ ನೀವು ಅನುಭವಿಸುತ್ತಿರುವ ಸಂಕಟಗಳಿಂದ ಬಿಡಿಸಬೇಕೆಂದು ತೀರ್ಮಾನಿಸಿದ್ದೇನೆ. ಕಾನಾನ್ಯರು, ಹಿತ್ತಿಯರು, ಅಮೋರಿಯರು, ಪೆರಿಜೀಯರು, ಹಿವ್ವಿಯರು ಮತ್ತು ಯೆಬೂಸಿಯರು ವಾಸವಾಗಿರುವ ಸಮೃದ್ಧಿಕರವಾದ ದೇಶಕ್ಕೆ ನಾನು ನಿಮ್ಮನ್ನು ನಡೆಸುವೆನು!’ ಎಂದು ಹೇಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ಹಿರಿಯರು ನಿನಗೆ ಕಿವಿಗೊಡುವರು. ಆಗ ನೀನು ಮತ್ತು ಹಿರಿಯರು ಈಜಿಪ್ಟಿನ ರಾಜನ ಬಳಿಗೆ ಹೋಗಿ, ‘ಇಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವನು ನಮಗೆ ಕಾಣಿಸಿಕೊಂಡನು. ಆದ್ದರಿಂದ ನಾವು ಮರುಭೂಮಿಯಲ್ಲಿ ಮೂರು ದಿನ ಪ್ರಯಾಣ ಮಾಡಿ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು’ ಎಂದು ಹೇಳಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“ಆದರೆ ಈಜಿಪ್ಟಿನ ರಾಜನು ನಿಮ್ಮನ್ನು ಹೋಗಗೊಡಿಸುವುದಿಲ್ಲ ಎಂಬುದು ನನಗೆ ಗೊತ್ತಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ಆದ್ದರಿಂದ ನಾನು ಕೈಚಾಚಿ ಈಜಿಪ್ಟಿನ ವಿರುದ್ಧ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ಮಾಡಿ ಅನೇಕ ವಿಧದಲ್ಲಿ ಬಾಧಿಸುವೆನು. ಆಗ ಅವನು ನಿಮ್ಮನ್ನು ಹೋಗಗೊಡಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ಈಜಿಪ್ಟಿನ ಜನರು ಇಸ್ರೇಲರಿಗೆ ದಯೆ ತೋರುವಂತೆ ಮಾಡುವೆನು. ಇಸ್ರೇಲರು ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟು ಹೊರಡುವಾಗ ಈಜಿಪ್ಟಿನವರು ಅವರಿಗೆ ಉಡುಗೊರೆಗಳನ್ನು ಕೊಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","“ಪ್ರತಿಯೊಬ್ಬ ಇಬ್ರಿಯ ಸ್ತ್ರೀಯು ಈಜಿಪ್ಟಿನ ನೆರೆಯವರನ್ನಾಗಲಿ ಅಥವಾ ತನ್ನ ಮನೆಯಲ್ಲಿ ವಾಸಿಸುತ್ತಿರುವ ಯಾವುದೇ ಸ್ತ್ರೀಯನ್ನಾಗಲಿ ಕೇಳಿದರೆ ಅವರು ಆಕೆಗೆ ಉಡುಗೊರೆಗಳನ್ನು ಕೊಡುವರು. ನಿನ್ನ ಜನರು ಬೆಳ್ಳಿಬಂಗಾರಗಳನ್ನು, ಶ್ರೇಷ್ಠವಾದ ಬಟ್ಟೆಗಳನ್ನು ಪಡೆಯುವರು. ನೀವು ಈಜಿಪ್ಟನ್ನು ಬಿಡುವಾಗ ಆ ಉಡುಗೊರೆಗಳನ್ನು ನಿಮ್ಮ ಮಕ್ಕಳಿಗೆ ತೊಡಿಸುವಿರಿ. ಈ ರೀತಿಯಲ್ಲಿ ನೀವು ಈಜಿಪ್ಟಿನವರ ಐಶ್ವರ್ಯವನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗುವಿರಿ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ಆಗ ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, “ಆದರೆ ನೀನು ನನ್ನನ್ನು ಕಳುಹಿಸಿರುವೆ ಎಂದು ಇಸ್ರೇಲರು ನಂಬುವುದೂ ಇಲ್ಲ; ಕೇಳುವುದೂ ಇಲ್ಲ. ಅವರು, ‘ಯೆಹೋವನು ನಿನಗೆ ಪ್ರತ್ಯಕ್ಷನಾಗಲಿಲ್ಲ’ ಎಂದು ಹೇಳುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಿನ್ನ ಕೈಯಲ್ಲಿರುವುದೇನು?” ಅಂದನು. ಮೋಶೆ, “ಊರುಗೋಲು” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ಆಗ ಯೆಹೋವನು, “ನಿನ್ನ ಊರುಗೋಲನ್ನು ನೆಲದ ಮೇಲೆ ಬಿಸಾಡು” ಅಂದನು. ಮೋಶೆ, ತನ್ನ ಊರುಗೋಲನ್ನು ನೆಲದ ಮೇಲೆ ಬಿಸಾಡಿದನು. ಆಗ ಕೋಲು ಹಾವಾಯಿತು. ಮೋಶೆ ಅದರ ಬಳಿಯಿಂದ ಓಡಿಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಿನ್ನ ಕೈಚಾಚಿ ಅದರ ಬಾಲವನ್ನು ಹಿಡಿದುಕೊ” ಎಂದು ಹೇಳಿದನು. ಮೋಶೆಯು ಕೈಚಾಚಿ ಹಾವಿನ ಬಾಲವನ್ನು ಹಿಡಿದನು. ಆಗ ಹಾವು ಕೋಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ಆಗ ದೇವರು, “ನಿನ್ನ ಕೋಲನ್ನು ಈ ರೀತಿಯಲ್ಲಿ ಉಪಯೋಗಿಸು. ನಿನ್ನ ಪೂರ್ವಿಕರ, ಅಬ್ರಹಾಮನ, ಇಸಾಕನ ಮತ್ತು ಯಾಕೋಬನ ದೇವರು ನಿನಗೆ ಪ್ರತ್ಯಕ್ಷನಾದನೆಂದು ಆಗ ಅವರು ನಂಬುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನು ನಿನಗೆ ಇನ್ನೊಂದು ಸಾಕ್ಷಿಯನ್ನು ಕೊಡುತ್ತೇನೆ. ನಿನ್ನ ಕೈಯನ್ನು ಉಡಿಯಲ್ಲಿ ಹಾಕು” ಅಂದನು. ಮೋಶೆ ತನ್ನ ಕೈಯನ್ನು ಉಡಿಯಲ್ಲಿ ಹಾಕಿ ಹೊರತೆಗೆದಾಗ ಅದಕ್ಕೆ ತೊನ್ನು ಹಿಡಿದಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ಆಗ ದೇವರು, “ನಿನ್ನ ಕೈಯನ್ನು ತಿರಿಗಿ ಉಡಿಯಲ್ಲಿ ಹಾಕು” ಅಂದನು. ಅಂತೆಯೇ ಮೋಶೆಯು ತನ್ನ ಕೈಯನ್ನು ಮತ್ತೆ ಉಡಿಯಲ್ಲಿ ಹಾಕಿ ಹೊರತೆಗೆದಾಗ ಅದು ಮೊದಲಿನಂತೆ ಆಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ಆಗ ಯೆಹೋವನು ಅವನಿಗೆ, “ನೀನು ನಿನ್ನ ಊರುಗೋಲಿನಿಂದ ಸೂಚಕಕಾರ್ಯ ಮಾಡುವಾಗ ಜನರು ನಿನ್ನನ್ನು ನಂಬುವರು; ನಿನ್ನ ಮಾತಿಗೆ ಲಕ್ಷ್ಯಕೊಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ನೀನು ಈ ಎರಡು ಸೂಚಕಕಾರ್ಯಗಳನ್ನು ತೋರಿಸಿದ ನಂತರವೂ ಅವರು ನಂಬದಿದ್ದರೆ, ನೈಲ್ ನದಿಯಿಂದ ಸ್ವಲ್ಪ ನೀರನ್ನು ತೆಗೆದುಕೊಂಡು ಅದನ್ನು ನೆಲದ ಮೇಲೆ ಸುರಿ; ನೀರು ನೆಲವನ್ನು ಮುಟ್ಟಿದ ಕೊಡಲೇ ರಕ್ತವಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, “ಸ್ವಾಮೀ, ನಾನು ನಿನಗೆ ಸತ್ಯವಾಗಿ ಹೇಳುವುದೇನೆಂದರೆ ನನಗೆ ವಾಕ್ಚಾತುರ್ಯವಿಲ್ಲ. ನನ್ನ ಮಾತೂ ನಾಲಿಗೆಯೂ ಮಂದವಾಗಿವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ಆಗ ಯೆಹೋವನು ಅವನಿಗೆ, “ಮನುಷ್ಯನ ಬಾಯನ್ನು ಯಾರು ಮಾಡಿದರು? ಮನುಷ್ಯನನ್ನು ಕಿವುಡನನ್ನಾಗಿ ಅಥವಾ ಮೂಕನನ್ನಾಗಿ ಮಾಡಬಲ್ಲವರು ಯಾರು? ಮನುಷ್ಯನನ್ನು ಕುರುಡನನ್ನಾಗಿ ಮಾಡಬಲ್ಲವರು ಯಾರು? ಮನುಷ್ಯನಿಗೆ ದೃಷ್ಟಿಕೊಟ್ಟವನು ಯಾರು? ಯೆಹೋವನಾದ ನಾನಲ್ಲವೇ. ");
INSERT INTO kan2010_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ಈಗ ಹೋಗು. ನೀನು ಮಾತಾಡುವಾಗ ನಾನೇ ನಿನ್ನೊಂದಿಗಿರುವೆನು. ನೀನು ಹೇಳಬೇಕಾದ ಮಾತುಗಳನ್ನು ನಾನು ನಿನಗೆ ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ಆದರೆ ಮೋಶೆ, “ನನ್ನ ಯೆಹೋವನೇ, ದಯಮಾಡಿ ನನ್ನ ಬದಲಾಗಿ ಬೇರೊಬ್ಬನನ್ನು ಕಳುಹಿಸು” ಎಂದು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ಯೆಹೋವನು ಮೋಶೆಯ ಮೇಲೆ ಕೋಪಗೊಂಡು, “ಹಾಗಾದರೆ ನಿನ್ನ ಅಣ್ಣನಾದ ಲೇವಿ ಕುಟುಂಬದ ಆರೋನನನ್ನೂ ನಾನು ಉಪಯೋಗಿಸುವೆನು. ಅವನಿಗೆ ವಾಕ್ಚಾತುರ್ಯವಿದೆ. ಈಗ ಅವನು ನಿನ್ನ ಬಳಿಗೆ ಬರುತ್ತಿದ್ದಾನೆ. ನಿನ್ನನ್ನು ಕಂಡು ಅವನಿಗೆ ಸಂತೋಷವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ಅವನು ನಿನ್ನೊಡನೆ ಫರೋಹನ ಬಳಿಗೆ ಬರುವನು. ನೀನು ಹೇಳಬೇಕಾದದ್ದನ್ನು ನಾನೇ ನಿನಗೆ ತಿಳಿಸುವೆನು. ಅದನ್ನು ನೀನು ಆರೋನನಿಗೆ ತಿಳಿಸು. ಆರೋನನು ಫರೋಹನೊಡನೆ ಸರಿಯಾಗಿ ಮಾತಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ಆರೋನನು ಜನರೊಂದಿಗೂ ನಿನ್ನ ಪರವಾಗಿಯೂ ಮಾತಾಡುವನು. ನೀನು ಮಹಾರಾಜನಂತೆ ಇರುವೆ; ಅವನು ನಿನಗೆ ಅಧಿಕೃತ ಮಾತುಗಾರನಂತೆ ಇರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ಆದ್ದರಿಂದ ಹೋಗು. ನಿನ್ನ ಊರುಗೋಲನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹೋಗು. ಯಾಕೆಂದರೆ ಅದರಿಂದಲೇ ನೀನು ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನು ಮಾಡುವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ಬಳಿಕ ಮೋಶೆ ತನ್ನ ಮಾವನಾದ ಇತ್ರೋನನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿದನು. ಮೋಶೆ ಇತ್ರೋನನಿಗೆ, “ಈಜಿಪ್ಟಿನಲ್ಲಿರುವ ನನ್ನ ಜನರ ಬಳಿಗೆ ಹೋಗಿ ಅವರು ಇನ್ನೂ ಜೀವಂತವಾಗಿದ್ದಾರೋ ಏನೋ ನೋಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ಇತ್ರೋನನು ಮೋಶೆಗೆ, “ನೀನು ಸಮಾಧಾನದಿಂದ ಹೋಗಿ ಬಾ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ಮೋಶೆ ಇನ್ನೂ ಮಿದ್ಯಾನಿನಲ್ಲಿದ್ದಾಗ ಯೆಹೋವನು, “ಈಗ ನೀನು ಸುರಕ್ಷಿತವಾಗಿ ಈಜಿಪ್ಟಿಗೆ ಹೋಗಬಹುದು. ನಿನ್ನನ್ನು ಕೊಲ್ಲಬೇಕೆಂದಿದ್ದವರು ಸತ್ತುಹೋಗಿದ್ದಾರೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ಆದ್ದರಿಂದ ಮೋಶೆ ತನ್ನ ಹೆಂಡತಿಯನ್ನೂ ಗಂಡುಮಕ್ಕಳನ್ನೂ ಕತ್ತೆಗಳ ಮೇಲೆ ಕುಳ್ಳಿರಿಸಿ ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆ ಮರಳಿ ಪ್ರಯಾಣ ಮಾಡಿದನು. ಮೋಶೆಯು ಯೆಹೋವನ ಶಕ್ತಿಯಿಂದ ಕೂಡಿದ ತನ್ನ ಊರುಗೋಲನ್ನು ಹಿಡಿದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ಮೋಶೆ ಈಜಿಪ್ಟಿಗೆ ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದಾಗ ಯೆಹೋವನು ಅವನೊಡನೆ ಮಾತಾಡಿ, “ನೀನು ಫರೋಹನೊಂದಿಗೆ ಮಾತಾಡುವಾಗ ನಾನು ತೋರಿಸಿಕೊಟ್ಟ ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ಅವನ ಮುಂದೆ ಮಾಡು. ಆದರೂ ನಾನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಗೊಳಿಸುವುದರಿಂದ ಅವನು ಇಸ್ರೇಲರನ್ನು ಹೋಗಗೊಡಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ಆಗ ನೀನು ಫರೋಹನಿಗೆ, ‘ಇಸ್ರೇಲ್ ಜನಾಂಗವು ಯೆಹೋವನಿಗೆ ಚೊಚ್ಚಲು ಮಗನಂತಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ನನ್ನ ಮಗನು ನಿನ್ನ ದೇಶದಿಂದ ಹೋಗಿ ನನ್ನನ್ನು ಆರಾಧಿಸಲು ನೀನು ಅಪ್ಪಣೆಕೊಡಬೇಕು. ಇಲ್ಲವಾದರೆ ನಾನು ನಿನ್ನ ಚೊಚ್ಚಲಮಗನನ್ನು ಕೊಲ್ಲುವೆನು’ ಎಂದು ಯೆಹೋವನು ಹೇಳುತ್ತಾನೆ” ಎಂಬುದಾಗಿ ತಿಳಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ಮೋಶೆಯು ಈಜಿಪ್ಟಿಗೆ ತನ್ನ ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರೆಸಿ ಛತ್ರವೊಂದರಲ್ಲಿ ಇಳಿದುಕೊಂಡನು. ಆಗ ಯೆಹೋವನು ಮೋಶೆಯನ್ನು ಸಂಧಿಸಿ ಅವನನ್ನು ಕೊಲ್ಲಬೇಕೆಂದಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ಆದರೆ ಚಿಪ್ಪೋರಳು ಕಲ್ಲಿನ ಚೂರಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ತನ್ನ ಮಗನಿಗೆ ಸುನ್ನತಿಮಾಡಿ ಚರ್ಮವನ್ನು ತೆಗೆದುಕೊಂಡು ಮೋಶೆಯ ಪಾದಗಳಿಗೆ ಮುಟ್ಟಿಸಿ, “ನೀನು ನನಗೆ ರಕ್ತಧಾರೆಯಿಂದಾದ ಮದುವಣಿಗನಾದೆ” ಅಂದಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ಆಕೆ ಸುನ್ನತಿಯ ನಿಮಿತ್ತವೇ “ನೀನು ನನಗೆ ರಕ್ತಧಾರೆಯಿಂದಾದ ಮದುವಣಿಗನಾದೆ” ಎಂದು ಹೇಳಿದ್ದರಿಂದ ಯೆಹೋವನು ಅವನನ್ನು ಉಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ಯೆಹೋವನು ಆರೋನನೊಡನೆ ಮಾತಾಡಿ ಅವನಿಗೆ, “ಅರಣ್ಯಕ್ಕೆ ಹೋಗಿ ಮೋಶೆಯನ್ನು ಭೇಟಿಯಾಗು” ಎಂದು ಹೇಳಿದ್ದನು. ಆದ್ದರಿಂದ ಆರೋನನು ಹೋಗಿ ದೇವರ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯನ್ನು ಭೇಟಿಯಾದನು. ಆರೋನನು ಮೋಶೆಯನ್ನು ಕಂಡು ಅವನಿಗೆ ಮುದ್ದಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ಯೆಹೋವನು ಹೇಳಿದ್ದನ್ನೆಲ್ಲಾ ಮೋಶೆಯು ಆರೋನನಿಗೆ ತಿಳಿಸಿದನು. ಯೆಹೋವನು ತನ್ನನ್ನು ಯಾಕೆ ಕಳುಹಿಸಿದನೆಂದೂ ತಾನು ಯಾವ ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನು ಮಾಡಬೇಕೆಂದೂ ಆರೋನನಿಗೆ ವಿವರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ಆದ್ದರಿಂದ ಮೋಶೆ ಆರೋನರು ಹೋಗಿ ಇಸ್ರೇಲ್ ಜನರ ಹಿರಿಯರೆಲ್ಲರನ್ನು ಒಟ್ಟುಗೂಡಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ಆಗ ಆರೋನನು ಜನರೊಂದಿಗೆ ಮಾತಾಡಿದನು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದನ್ನೆಲ್ಲಾ ಅವನು ಅವರಿಗೆ ತಿಳಿಸಿದನು. ಬಳಿಕ ಮೋಶೆ ಜನರೆಲ್ಲರೂ ನೋಡುವಂತೆ ಸಾಕ್ಷ್ಯಾಧಾರಗಳನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ಯೆಹೋವನು ಮೋಶೆಯನ್ನು ಕಳುಹಿಸಿದ್ದಾನೆಂದು ಜನರು ನಂಬಿದರು. ಯೆಹೋವನು ಇಸ್ರೇಲರಿಗೆ ಸಹಾಯಮಾಡಬೇಕೆಂದಿರುವುದನ್ನು ಅವರು ತಿಳಿದು ತಲೆಬಾಗಿ ಆತನನ್ನು ಆರಾಧಿಸಿದರು. ಯೆಹೋವನು ತಮ್ಮ ಸಂಕಟಗಳನ್ನು ನೋಡಿದ್ದರಿಂದ ಅವರು ಆತನನ್ನು ಆರಾಧಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ಮೋಶೆ ಆರೋನರು ಜನರೊಡನೆ ಮಾತಾಡಿದ ನಂತರ ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, “ಇಸ್ರೇಲರ ದೇವರಾದ ಯೆಹೋವನು ನಿನಗೆ, ‘ನನ್ನ ಜನರು ಅರಣ್ಯದೊಳಗೆ ಹೋಗಿ ಜಾತ್ರೆ ನಡೆಸಲು ಅಪ್ಪಣೆಕೊಡಬೇಕು’ ಎನ್ನುತ್ತಾನೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ಆದರೆ ಫರೋಹನು, “ಯೆಹೋವನು ಯಾರು? ನಾನು ಆತನಿಗೆ ಯಾಕೆ ವಿಧೇಯನಾಗಬೇಕು. ಇಸ್ರೇಲರನ್ನು ನಾನು ಯಾಕೆ ಹೋಗಗೊಡಿಸಬೇಕು. ನೀವು ಯೆಹೋವನೆಂದು ಕರೆಯುವ ಆತನನ್ನು ನಾನು ಅರಿಯೆನು, ಆದ್ದರಿಂದ ಇಸ್ರೇಲರನ್ನು ಹೋಗಗೊಡಿಸುವುದಿಲ್ಲ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ಅದಕ್ಕೆ ಮೋಶೆ ಆರೋನರು, “ಇಬ್ರಿಯರ ದೇವರು ನಮ್ಮ ಸಂಗಡ ಮಾತಾಡಿದ್ದಾನೆ. ಆದ್ದರಿಂದ ನಾವು ಅರಣ್ಯದಲ್ಲಿ ಮೂರು ದಿನಗಳವರೆಗೆ ಪ್ರಯಾಣಮಾಡಿ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಯಜ್ಞವನ್ನು ಸಮರ್ಪಿಸುವೆವು. ಇಲ್ಲವಾದರೆ ಆತನು ನಮ್ಮನ್ನು ಕಾಯಿಲೆಯಿಂದಲೋ ಕತ್ತಿಯಿಂದಲೋ ಸಂಹರಿಸುವನು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ಆದರೆ ಈಜಿಪ್ಟಿನ ರಾಜನು ಅವರಿಗೆ, “ಮೋಶೆ ಆರೋನರೇ, ನೀವು ಕೆಲಸಗಾರರಿಗೆ ತೊಂದರೆ ಮಾಡುತ್ತಿದ್ದೀರಿ, ಅವರು ತಮ್ಮ ಕೆಲಸ ಮಾಡಲಿ! ನೀವು ನಿಮ್ಮ ಕೆಲಸವನ್ನು ಮಾಡಿ! ");
INSERT INTO kan2010_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ಇಲ್ಲಿ ಬಹಳ ಮಂದಿ ಕೆಲಸಗಾರರಿದ್ದಾರೆ; ಅವರು ಕೆಲಸ ಮಾಡದಂತೆ ನೀವು ತಡೆಯುವುದೇಕೆ?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ಅದೇ ದಿನ ಫರೋಹನು ಬಿಟ್ಟೀಕೆಲಸ ಮಾಡಿಸುವ ಅಧಿಕಾರಿಗಳಿಗೆ ಮತ್ತು ಮೇಸ್ತ್ರಿಗಳಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ಬೇಕಾದ ಹುಲ್ಲನ್ನು ನೀವು ಜನರಿಗೆ ಇಲ್ಲಿಯವರೆಗೆ ಕೊಟ್ಟಿದ್ದೀರಿ. ಆದರೆ ಈಗ ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡಲು ಅವರೇ ಹುಲ್ಲನ್ನು ಕಂಡುಕೊಳ್ಳಬೇಕೆಂದು ಅವರಿಗೆ ಹೇಳಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ಆದರೂ ಅವರು ಹಿಂದೆ ಮಾಡುತ್ತಿದ್ದಷ್ಟೇ ಇಟ್ಟಿಗೆಗಳನ್ನು ಈಗಲೂ ಮಾಡಬೇಕು. ಅವರು ಸೋಮಾರಿಗಳಾಗಿದ್ದಾರೆ. ಆದಕಾರಣ ತಮ್ಮನ್ನು ಹೋಗಬಿಡಬೇಕೆಂದು ಕೇಳುತ್ತಿದ್ದಾರೆ. ಅವರಿಗೆ ಸಾಕಷ್ಟು ಕೆಲಸವಿಲ್ಲ. ಆದ್ದರಿಂದ ತಮ್ಮ ದೇವರಿಗೆ ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಲು ಹೋಗಗೊಡಿಸಬೇಕೆಂದು ಕೇಳುತ್ತಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ಈ ಜನರಿಗೆ ಇನ್ನೂ ಕಷ್ಟಕರವಾದ ಕೆಲಸವನ್ನು ಕೊಡಿರಿ. ಅವರು ಕಾರ್ಯಮಗ್ನರಾಗಿರುವಂತೆ ನೋಡಿಕೊಳ್ಳಿರಿ. ಆಗ ಅವರಿಗೆ ಮೋಶೆಯ ಸುಳ್ಳುಗಳನ್ನು ಕೇಳುವುದಕ್ಕೆ ಸಮಯವಿರುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ಆದ್ದರಿಂದ ಈಜಿಪ್ಟಿನ ಬಿಟ್ಟೀಕೆಲಸ ಮಾಡಿಸುವ ಅಧಿಕಾರಿಗಳು ಮತ್ತು ಮೇಸ್ತ್ರಿಗಳು ಇಸ್ರೇಲರ ಬಳಿಗೆ ಬಂದು, “ಫರೋಹನು ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡಲು ನಿಮಗೆ ಹುಲ್ಲು ಕೊಡುವುದಿಲ್ಲವೆಂದು ತೀರ್ಮಾನಿಸಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ಆದ್ದರಿಂದ ನೀವೇ ಹೋಗಿ ಹುಲ್ಲನ್ನು ಕಂಡುಕೊಳ್ಳಿರಿ. ಆದರೆ ನೀವು ಮೊದಲು ಮಾಡುತ್ತಿದ್ದಷ್ಟೇ ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ಆದ್ದರಿಂದ ಜನರು ಹುಲ್ಲನ್ನು ಹುಡುಕುತ್ತಾ ಈಜಿಪ್ಟಿನ ಪ್ರತಿಯೊಂದು ಕಡೆಗೂ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ಬಿಟ್ಟೀಕೆಲಸ ಮಾಡಿಸುವ ಅಧಿಕಾರಿಗಳು, ಜನರಿಂದ ಕಷ್ಟಕರವಾದ ಕೆಲಸಗಳನ್ನು ಬಲವಂತದಿಂದ ಮಾಡಿಸುತ್ತಲೇ ಇದ್ದರು. ಮೊದಲು ಅವರಿಗೆ ಹುಲ್ಲನ್ನು ಕೊಟ್ಟಿದ್ದಾಗ ಮಾಡುತ್ತಿದ್ದಷ್ಟೇ ಇಟ್ಟಿಗೆಗಳನ್ನು ಈಗಲು ಬಲವಂತದಿಂದ ಮಾಡಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ಈಜಿಪ್ಟಿನ ಈ ಅಧಿಕಾರಿಗಳು ಇಬ್ರಿಯ ಮೇಸ್ತ್ರಿಗಳನ್ನು ಆರಿಸಿ ಜನರು ಮಾಡಿದ ಕೆಲಸಕ್ಕೆ ಅವರನ್ನು ಜವಾಬ್ದಾರರನ್ನಾಗಿ ಮಾಡಿದರು. ಈಜಿಪ್ಟಿನ ಅಧಿಕಾರಿಗಳು ಇಬ್ರಿಯ ಮೇಸ್ತ್ರಿಗಳನ್ನು ಹೊಡೆದು, “ನೀವು ಹಿಂದೆ ಮಾಡುತ್ತಿದ್ದಷ್ಟೇ ಇಟ್ಟಿಗೆಗಳನ್ನು ಯಾಕೆ ಮಾಡುತ್ತಿಲ್ಲ? ಹಿಂದೆ ನೀವು ಮಾಡಲು ಸಾಧ್ಯವಾಗಿದ್ದರೆ, ಈಗಲೂ ನೀವು ಮಾಡಬಹುದು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ಆಗ ಇಬ್ರಿಯ ಮೇಸ್ತ್ರಿಗಳು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, “ನಿನ್ನ ಸೇವಕರಾದ ನಮಗೆ ನೀನು ಯಾಕೆ ಈ ರೀತಿ ಮಾಡುತ್ತಿ? ");
INSERT INTO kan2010_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ನೀನು ನಮಗೆ ಹುಲ್ಲು ಕೊಡುವುದಿಲ್ಲ. ಆದರೆ ನಾವು ಮೊದಲು ಮಾಡುತ್ತಿದ್ದಷ್ಟೇ ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡಬೇಕೆಂದು ನಮಗೆ ಅಪ್ಪಣೆಯಾಗಿರುವುದರಿಂದ ನಾವು ಅಧಿಕಾರಿಗಳಿಂದ ಹೊಡೆತ ತಿನ್ನಬೇಕಾಯಿತು. ಹೀಗೆ ನಿನ್ನ ಜನರು ತಪ್ಪು ಮಾಡುತ್ತಿದ್ದಾರೆ” ಎಂದು ದೂರು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ಫರೋಹನು, “ನೀವು ಸೋಮಾರಿಗಳು. ನಿಮಗೆ ಕೆಲಸ ಮಾಡಲು ಇಷ್ಟವಿಲ್ಲ. ಆದ್ದರಿಂದ ನಿಮ್ಮನ್ನು ಹೋಗಗೊಡಿಸಬೇಕೆಂದು ನೀವು ನನ್ನನ್ನು ಕೇಳುತ್ತೀರಿ. ಇಲ್ಲಿಂದ ಹೊರಟುಹೋಗಿ ಯೆಹೋವನಿಗೆ ಯಜ್ಞಗಳನ್ನು ಮಾಡಬೇಕೆಂದು ಅಪೇಕ್ಷಿಸುತ್ತೀರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ಈಗ ನಿಮ್ಮ ಕೆಲಸಕ್ಕೆ ಹೋಗಿರಿ! ನಾವು ನಿಮಗೆ ಹುಲ್ಲನ್ನು ಕೊಡುವುದಿಲ್ಲ. ಆದರೆ ನೀವು ಹಿಂದೆ ಮಾಡುತ್ತಿದ್ದಷ್ಟೇ ಇಟ್ಟಿಗೆಗಳನ್ನು ಮಾಡಬೇಕು” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ಇಬ್ರಿಯ ಮೇಸ್ತ್ರಿಗಳಿಗೆ ತಾವು ತೊಂದರೆಯಲ್ಲಿದ್ದೇವೆಂದು ತಿಳಿಯಿತು. ತಾವು ಹಿಂದೆ ಮಾಡುತ್ತಿದ್ದಷ್ಟೇ ಇಟ್ಟಿಗೆಗಳನ್ನು ತಮ್ಮಿಂದ ಮಾಡಲಾಗುವುದಿಲ್ಲವೆಂದು ಅವರಿಗೆ ಗೊತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ಅವರು ಫರೋಹನನ್ನು ಸಂಧಿಸಿ ಹೊರಟುಹೋಗುವಾಗ ತಮಗಾಗಿ ಕಾಯತ್ತಿದ್ದ ಮೋಶೆ ಆರೋನರನ್ನು ಕಂಡು, ");
INSERT INTO kan2010_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","“ನಮಗೆ ಹೋಗಲು ಅಪ್ಪಣೆಕೊಡಬೇಕೆಂದು ನೀವು ಫರೋಹನನ್ನು ಕೇಳಿ ನಮಗೆ ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡಿದಿರಿ. ಫರೋಹನು ಮತ್ತು ಅವನ ಅಧಿಕಾರಿಗಳು ನಮ್ಮನ್ನು ದ್ವೇಷಿಸುವಂತೆ ನೀವು ಮಾಡಿದ್ದರಿಂದ ಯೆಹೋವನು ನಿಮಗೆ ತೀರ್ಪು ನೀಡಲಿ. ಅವರು ನಮ್ಮನ್ನು ಕೊಲ್ಲುವುದಕ್ಕೆ ನೀವು ಅವಕಾಶ ಮಾಡಿಕೊಟ್ಟಿರಿ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ಆಗ ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಿ, “ಯೆಹೋವನೇ, ನಿನ್ನ ಜನರಿಗೆ ಈ ಕೇಡನ್ನು ಏಕೆ ಮಾಡಿದೆ? ನನ್ನನ್ನು ಯಾಕೆ ಇಲ್ಲಿಗೆ ಕಳುಹಿಸಿದೆ? ");
INSERT INTO kan2010_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ನಾನು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ನೀನು ಹೇಳಿದ್ದನ್ನೇ ತಿಳಿಸಿದೆ. ಆದರೆ ಅಂದಿನಿಂದ ಅವನು ಜನರನ್ನು ಕೀಳಾಗಿ ಕಾಣುತ್ತಿದ್ದಾನೆ. ಅಲ್ಲದೆ ನೀನೂ ನಿನ್ನ ಜನರಿಗೆ ಸಹಾಯ ಮಾಡುತ್ತಿಲ್ಲ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನು ಫರೋಹನಿಗೆ ಮಾಡುವುದನ್ನು ಈಗ ನೀನು ನೋಡುವೆ. ನಾನು ನನ್ನ ಮಹಾಶಕ್ತಿಯನ್ನು ಅವನಿಗೆ ವಿರುದ್ಧವಾಗಿ ಉಪಯೋಗಿಸುವುದರಿಂದ ಅವನು ನನ್ನ ಜನರನ್ನು ಹೋಗಗೊಡಿಸುವನು; ಬಲವಂತದಿಂದ ಅವರನ್ನು ಹೊರಡಿಸುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","“ನಾನು ಯೆಹೋವನೇ. ನಾನು ಅಬ್ರಹಾಮನಿಗೂ ಇಸಾಕನಿಗೂ ಯಾಕೋಬನಿಗೂ ಕಾಣಿಸಿಕೊಂಡೆನು. ಅವರು ನನ್ನನ್ನು ‘ಎಲ್ ಶದ್ದಾಯ್’ (ಸರ್ವಶಕ್ತನಾದ ದೇವರು) ಎಂದು ಕರೆದರು. ಆದರೆ ನಾನು ನನ್ನನ್ನು ಯೆಹೋವ ಎಂಬ ನನ್ನ ಹೆಸರಿನಲ್ಲಿ ಅವರಿಗೆ ಗೊತ್ತುಪಡಿಸಿಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ನಾನು ಅವರೊಂದಿಗೆ ಒಂದು ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡೆನು. ಕಾನಾನ್ ದೇಶವನ್ನು ಅವರಿಗೆ ಕೊಡುವುದಾಗಿ ನಾನು ವಾಗ್ದಾನ ಮಾಡಿದೆನು. ಅವರು ಆ ದೇಶದಲ್ಲಿ ಜೀವಿಸಿದರೂ ಅದು ಅವರ ಸ್ವಂತ ದೇಶವಾಗಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ಈಗ ಇಸ್ರೇಲರ ಕಷ್ಟಗಳನ್ನೂ ಬಲ್ಲೆನು; ಅವರು ಈಜಿಪ್ಟಿನವರ ಗುಲಾಮರೆಂದೂ ಬಲ್ಲೆನು; ನಾನು ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಜ್ಞಾಪಿಸಿಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ಆದ್ದರಿಂದ ನನ್ನ ಈ ಮಾತುಗಳನ್ನು ಇಸ್ರೇಲರಿಗೆ ತಿಳಿಸು: ‘ನಾನೇ ಯೆಹೋವನು. ಈಜಿಪ್ಟಿನವರು ನಿಮ್ಮಿಂದ ಮಾಡಿಸುವ ಬಿಟ್ಟೀಕೆಲಸದಿಂದ ತಪ್ಪಿಸಿ ಈಜಿಪ್ಟಿನವರ ಗುಲಾಮಗಿರಿಯಿಂದ ಬಿಡಿಸುವೆನು. ನನ್ನ ಮಹಾಶಕ್ತಿಯಿಂದ ಈಜಿಪ್ಟಿನವರನ್ನು ಭಯಂಕರವಾಗಿ ದಂಡಿಸುವೆನು; ಬಳಿಕ ನಿಮ್ಮನ್ನು ರಕ್ಷಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ನೀವು ನನ್ನ ಜನರಾಗಿರುವಿರಿ; ನಾನು ನಿಮ್ಮ ದೇವರಾಗಿರುವೆನು. ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವನಾದ ನಾನೇ ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನವರ ಬಿಟ್ಟೀಕೆಲಸದಿಂದ ಬಿಡುಗಡೆಗೊಳಿಸಿದೆನೆಂದು ಆಗ ನೀವು ತಿಳಿದುಕೊಳ್ಳುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ಇದಲ್ಲದೆ ಅಬ್ರಹಾಮ, ಇಸಾಕ ಮತ್ತು ಯಾಕೋಬರಿಗೆ ನಾನು ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶಕ್ಕೆ ನಿಮ್ಮನ್ನು ನಡಿಸುವೆನು. ನಾನು ಆ ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಡುವೆನು. ಅದು ನಿಮ್ಮದಾಗಿರುವುದು. ನಾನೇ ಯೆಹೋವನು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ಅಂತೆಯೇ ಮೋಶೆಯು ಇಸ್ರೇಲರಿಗೆ ತಿಳಿಸಿದನು. ಆದರೆ ಜನರು ಬಹು ಪ್ರಯಾಸಪಟ್ಟು ದುಡಿಯುತ್ತಿದ್ದುದರಿಂದ ಮೋಶೆಯ ಮಾತಿಗೆ ಕಿವಿಗೊಡುವಷ್ಟು ತಾಳ್ಮೆ ಅವರಿಗಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ಹೋಗು, ಇಸ್ರೇಲರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕಳುಹಿಸಬೇಕೆಂದು ಫರೋಹನಿಗೆ ಹೇಳು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ಅದಕ್ಕೆ ಮೋಶೆ, “ಇಸ್ರೇಲರು ನನ್ನ ಮಾತನ್ನು ಕೇಳುವುದಿಲ್ಲ! ಆದ್ದರಿಂದ ಫರೋಹನು ನನ್ನ ಮಾತನ್ನು ಖಂಡಿತವಾಗಿ ಕೇಳುವುದಿಲ್ಲ. ನಾನು ಮಾತಾಡುವುದರಲ್ಲಿ ಜಾಣನಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ಆದರೆ, ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಸಂಗಡ ಮಾತಾಡಿ ಇಸ್ರೇಲರೊಡನೆಯೂ ಫರೋಹನೊಡನೆಯೂ ಮಾತಾಡಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಿದನು. ಅಲ್ಲದೆ ಈಜಿಪ್ಟಿನಿಂದ ಇಸ್ರೇಲರನ್ನು ಬಿಡಿಸಿಕೊಂಡು ಹೋಗಬೇಕೆಂದು ಯೆಹೋವನು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ಇಸ್ರೇಲರ ಕುಟುಂಬಗಳ ನಾಯಕರುಗಳ ಹೆಸರುಗಳು ಇಲ್ಲಿವೆ: ಇಸ್ರೇಲನ ಮೊದಲನೆಯ ಮಗನಾದ ರೂಬೇನನಿಗೆ ನಾಲ್ಕು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ಅವರು ಯಾರೆಂದರೆ: ಹನೋಕ್, ಫಲ್ಲು, ಹೆಚ್ರೋನ್ ಮತ್ತು ಕರ್ಮೀ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ಸಿಮೆಯೋನನ ಗಂಡುಮಕ್ಕಳು ಯಾರೆಂದರೆ: ಯೆಮೂಯೇಲ್, ಯಾಮೀನ್, ಓಹದ್, ಯಾಕೀನ್, ಚೋಹರ್ ಮತ್ತು ಸೌಲ. (ಸೌಲನು ಕಾನಾನ್ಯ ಸ್ತ್ರೀಯ ಮಗನು.) ");
INSERT INTO kan2010_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ಲೇವಿಯು ನೂರಮೂವತ್ತೇಳು ವರ್ಷ ಜೀವಿಸಿದನು. ಲೇವಿಯ ಗಂಡುಮಕ್ಕಳ ವಂಶಾವಳಿ: ಗೇರ್ಷೋನ್, ಕೆಹಾತ್ ಮತ್ತು ಮೆರಾರೀ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ಗೇರ್ಷೋನನಿಗೆ ಲಿಬ್ನೀ ಮತ್ತು ಶಿಮ್ಮೀ ಎಂಬ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ಕೆಹಾತನು ನೂರಮೂವತ್ತು ಮೂರು ವರ್ಷ ಜೀವಿಸಿದನು. ಕೆಹಾತನ ಗಂಡುಮಕ್ಕಳು: ಅಮ್ರಾಮ್, ಇಚ್ಹಾರ್, ಹೆಬ್ರೋನ್ ಮತ್ತು ಉಜ್ಜೀಯೇಲ್. ");
INSERT INTO kan2010_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ಮೆರಾರೀಯ ಗಂಡುಮಕ್ಕಳು: ಮಹ್ಲೀ ಮತ್ತು ಮೂಷೀ. ಇಸ್ರೇಲನ ಮಗನಾದ ಲೇವಿಯಿಂದುಂಟಾದ ಗೋತ್ರಗಳು ಇವೇ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ಅಮ್ರಾಮನು ನೂರಮೂವತ್ತೇಳು ವರ್ಷ ಜೀವಿಸಿದನು. ಅಮ್ರಾಮನು ತನ್ನ ತಂದೆಯ ಸಹೋದರಿಯಾದ ಯೋಕೆಬೆದಳನ್ನು ಮದುವೆಯಾದನು. ಅಮ್ರಾಮ್ ಮತ್ತು ಯೋಕೆಬೆದಳು ಆರೋನ ಮತ್ತು ಮೋಶೆಗೆ ಜನ್ಮವಿತ್ತರು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ಇಚ್ಹಾರನ ಗಂಡುಮಕ್ಕಳು: ಕೋರಹ, ನೆಫೆಗ್ ಮತ್ತು ಜಿಕ್ರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ಉಜ್ಜೀಯೇಲನ ಗಂಡುಮಕ್ಕಳು: ಮೀಷಾಯೇಲ್, ಎಲ್ಚಾಫಾನ್ ಮತ್ತು ಸಿತ್ರೀ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ಆರೋನನು ಎಲೀಶೇಬಳನ್ನು ಮದುವೆಯಾದನು. (ಎಲೀಶೇಬಳು ಅಮ್ಮೀನಾದ್ವಾನ ಮಗಳು ಮತ್ತು ನಹಶೋನನ ತಂಗಿ.) ಆರೋನನಿಗೆ ಎಲೀಶೇಬಳಲ್ಲಿ ನಾದ್ವಾ್, ಅಬೀಹೂ, ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಎಂಬ ಗಂಡುಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ಕೋರಹನ ಗಂಡುಮಕ್ಕಳು: ಅಸ್ಸೀರ್, ಎಲ್ಕಾನಾ ಮತ್ತು ಅಬೀಯಾಸಾಫ್. ಇವರೇ ಕೋರಹನ ಕುಲಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ಆರೋನನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನು ಪೂಟಿಯೇಲನ ಮಗಳನ್ನು ಮದುವೆಯಾದನು; ಆಕೆ ಫೀನೆಹಾಸನಿಗೆ ಜನ್ಮವಿತ್ತಳು. ಇವರೆಲ್ಲರೂ ಇಸ್ರೇಲನ ಮಗನಾದ ಲೇವಿಯ ಗೋತ್ರದವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ಮೋಶೆ ಆರೋನರು ಸಹ ಲೇವಿ ಕುಲದವರು. “ನನ್ನ ಜನರನ್ನು ಗುಂಪುಗುಂಪಾಗಿ ಈಜಿಪ್ಟಿನಿಂದ ನಡೆಸಿಕೊಂಡು ಹೋಗಿ” ಎಂದು ದೇವರು ಹೇಳಿದ್ದು ಇವರಿಗೇ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ಇಸ್ರೇಲರು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಟುಹೋಗಲು ಅನುಮತಿ ನೀಡಬೇಕೆಂದು ಈಜಿಪ್ಟಿನ ರಾಜನಾದ ಫರೋಹನೊಂದಿಗೆ ಮಾತಾಡಿದವರು ಮೋಶೆ ಮತ್ತು ಆರೋನರೇ. ");
INSERT INTO kan2010_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಯ ಸಂಗಡ ಈಜಿಪ್ಟಿನಲ್ಲಿ ಮಾತಾಡಿ, ");
INSERT INTO kan2010_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“ನಾನು ಯೆಹೋವನು. ನಾನು ನಿನಗೆ ತಿಳಿಸುವ ಪ್ರತಿಯೊಂದನ್ನು ಈಜಿಪ್ಟಿನ ರಾಜನಿಗೆ ಹೇಳು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ಆದರೆ ಮೋಶೆ ಯೆಹೋವನಿಗೆ, “ನಾನು ಒಳ್ಳೆಯ ಮಾತುಗಾರನಲ್ಲ. ರಾಜನು ನನ್ನ ಮಾತನ್ನು ಕೇಳುವನೇ?” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನು ನಿನ್ನನ್ನು ಫರೋಹನಿಗೆ ಮಹಾರಾಜನಂತೆ ಮಾಡಿರುವೆನು; ಆರೋನನು ಅಧಿಕೃತ ಮಾತುಗಾರನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸುವುದನ್ನೆಲ್ಲಾ ಆರೋನನಿಗೆ ಹೇಳು. ಆಗ ಅವನು ಅವುಗಳನ್ನೆಲ್ಲಾ ರಾಜನಿಗೆ ತಿಳಿಸುವನು. ಇಸ್ರೇಲರು ಈ ದೇಶವನ್ನು ಬಿಟ್ಟು ಹೋಗುವುದಕ್ಕೆ ಫರೋಹನು ಸಮ್ಮತಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ಆದರೆ ನಾನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಗೊಳಿಸುವುದರಿಂದ ಅವನು ನನ್ನ ಆಜ್ಞೆಗಳಿಗೆ ವಿಧೇಯನಾಗುವುದಿಲ್ಲ. ಆಗ ನಾನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಅನೇಕ ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನು ಮಾಡುವೆನು. ಆದರೂ ಅವನು ವಿಧೇಯನಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ಆಗ ನಾನು ಈಜಿಪ್ಟನ್ನು ಭಯಂಕರವಾಗಿ ದಂಡಿಸಿ ನನ್ನ ಜನರನ್ನು ಆ ದೇಶದಿಂದ ಹೊರತರುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ನಾನು ಈಜಿಪ್ಟಿನ ವಿರುದ್ಧವಾಗಿ ನನ್ನ ಕೈಯನ್ನು ಚಾಚಿ ನನ್ನ ಜನರನ್ನು ಅವರ ದೇಶದಿಂದ ಬಿಡುಗಡೆ ಮಾಡಿದಾಗ, ನಾನೇ ಯೆಹೋವನೆಂದು ಅವರು ತಿಳಿದುಕೊಳ್ಳುವರು.” ");
INSERT INTO kan2010_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದವುಗಳಿಗೆಲ್ಲಾ ಮೋಶೆ ಆರೋನರು ವಿಧೇಯರಾದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ಅವರು ಫರೋಹನೊಡನೆ ಮಾತಾಡಿದಾಗ ಮೋಶೆಗೆ ಎಂಭತ್ತು ವರ್ಷ ವಯಸ್ಸಾಗಿತ್ತು. ಆರೋನನಿಗೆ ಎಂಭತ್ತ ಮೂರು ವರ್ಷ ವಯಸ್ಸಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ಫರೋಹನು ನಿಮಗೆ, ಅದ್ಭುತಕಾರ್ಯವೊಂದನ್ನು ಮಾಡಿ ನಿಮ್ಮ ಅಧಿಕಾರವನ್ನು ರುಜುವಾತುಪಡಿಸಬೇಕೆಂದು ಕೇಳುವನು. ಆಗ ಮೋಶೆಯು ಆರೋನನಿಗೆ ಊರುಗೋಲನ್ನು ನೆಲದ ಮೇಲೆ ಬಿಸಾಡಲು ಹೇಳಬೇಕು. ಆರೋನನು ಬಿಸಾಡಿದ ಕೂಡಲೇ ಆ ಕೋಲು ಅವರ ಕಣ್ಣೆದುರಿನಲ್ಲಿಯೇ ಸರ್ಪವಾಗುವುದು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ಆದ್ದರಿಂದ ಮೋಶೆ ಆರೋನರು ಫರೋಹನ ಬಳಿಗೆ ಹೋದರು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದಂತೆಯೇ ಅವರು ಮಾಡಿದರು. ಆರೋನನು ತನ್ನ ಊರುಗೋಲನ್ನು ಫರೋಹನ ಮತ್ತು ಅವನ ಅಧಿಕಾರಿಗಳ ಮುಂದೆ ನೆಲದ ಮೇಲೆ ಬಿಸಾಡಿದಾಗ ಅದು ಸರ್ಪವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ಆಗ ರಾಜನು ತನ್ನ ವಿದ್ವಾಂಸರನ್ನೂ ಮಂತ್ರಗಾರರನ್ನೂ ಕರೆಯಿಸಿದನು. ಅವರು ತಮ್ಮ ಮಂತ್ರವಿದ್ಯೆಯಿಂದ ಅದೇ ರೀತಿ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ಅವರು ತಮ್ಮ ಊರುಗೋಲುಗಳನ್ನು ನೆಲದ ಮೇಲೆ ಬಿಸಾಡಿದಾಗ ಅವು ಸರ್ಪಗಳಾದವು. ಆದರೆ ಆರೋನನ ಕೋಲು ಅವರ ಕೋಲುಗಳನ್ನು ನುಂಗಿಬಿಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ಯೆಹೋವನು ಹೇಳಿದ್ದಂತೆಯೇ ಫರೋಹನ ಹೃದಯವು ಕಠಿಣವಾಯಿತು. ಅವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ಮಾತಿಗೆ ಕಿವಿಗೊಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಫರೋಹನ ಹೃದಯ ಮೊಂಡಾಗಿದೆ; ಅವನು ಜನರನ್ನು ಹೋಗಗೊಡಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ಮುಂಜಾನೆ ಅವನು ನದಿಗೆ ಹೋಗುವನು. ಸರ್ಪವಾಗಿ ಮಾರ್ಪಾಟಾದ ಊರುಗೋಲನ್ನು ತೆಗೆದುಕೊಂಡು ನದಿಯ ತೀರಕ್ಕೆ ಹೋಗಿ ಅವನನ್ನು ಭೇಟಿಯಾಗಿ ಅವನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","‘ಇಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವನು ನನ್ನನ್ನು ನಿನ್ನ ಬಳಿಗೆ ಕಳುಹಿಸಿದ್ದಾನೆ. ಆತನ ಜನರು ಅರಣ್ಯದಲ್ಲಿ ಆತನನ್ನು ಆರಾಧಿಸುವುದಕ್ಕೆ ನೀನು ಅವರಿಗೆ ಅಪ್ಪಣೆಕೊಡಬೇಕೆಂದು ಆತನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸುತ್ತಾನೆ. ಇದುವರೆಗೆ ನೀನು ಯೆಹೋವನ ಮಾತಿಗೆ ಕಿವಿಗೊಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ಆದ್ದರಿಂದ ಆತನೇ ಯೆಹೋವನೆಂದು ನಿನಗೆ ತಿಳಿಯಲೆಂದು ನನ್ನ ಕೈಯಲ್ಲಿರುವ ಕೋಲಿನಿಂದ ನೈಲ್ ನದಿಯ ನೀರನ್ನು ಹೊಡೆಯುವೆನು; ಆ ನದಿಯ ನೀರು ರಕ್ತವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ನದಿಯಲ್ಲಿರುವ ಮೀನುಗಳು ಸಾಯುವವು; ನದಿಯು ಹೊಲಸಾಗುವುದು; ಈಜಿಪ್ಟಿನವರು ನದಿಯ ನೀರನ್ನು ಕುಡಿಯಲಾಗುವುದಿಲ್ಲ’ ಎಂದು ಹೇಳಬೇಕು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಆರೋನನಿಗೆ, ‘ನಿನ್ನ ಕೈಯಲ್ಲಿರುವ ಊರುಗೋಲನ್ನು ನದಿಗಳ, ಕಾಲುವೆಗಳ, ಕೆರೆಗಳ ಮತ್ತು ನೀರಿರುವ ಪ್ರತಿಯೊಂದು ಸ್ಥಳದ ಮೇಲೆ ಚಾಚು’ ಎಂದು ಹೇಳು. ಅವನು ಚಾಚಿದಾಗ ನೀರೆಲ್ಲಾ ರಕ್ತವಾಗುವುದು. ಮರದ ಮತ್ತು ಕಲ್ಲಿನ ಪಾತ್ರೆಗಳಲ್ಲಿರುವ ನೀರು ಸಹ ರಕ್ತವಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆ ಆರೋನರು ಮಾಡಿದರು. ಆರೋನನು ಫರೋಹನ ಮತ್ತು ಅವನ ಅಧಿಕಾರಿಗಳ ಮುಂದೆ ಕೋಲನ್ನು ಎತ್ತಿ ನೈಲ್ ನದಿಯ ನೀರನ್ನು ಹೊಡೆದನು. ಆಗ ನದಿಯ ನೀರೆಲ್ಲಾ ರಕ್ತವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ನದಿಯಲ್ಲಿದ್ದ ಮೀನುಗಳು ಸತ್ತವು; ನದಿಯು ಹೊಲಸಾಗತೊಡಗಿತು. ಆದ್ದರಿಂದ ಈಜಿಪ್ಟಿನವರು ನದಿಯ ನೀರನ್ನು ಕುಡಿಯಲಾಗಲಿಲ್ಲ. ಈಜಿಪ್ಟಿನ ನೀರೆಲ್ಲಾ ರಕ್ತವೇ ಆಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ಮಾಂತ್ರಿಕರು ತಮ್ಮ ಮಂತ್ರವಿದ್ಯೆಯಿಂದ ಅದೇ ರೀತಿ ಮಾಡಿದರು. ಆದ್ದರಿಂದ ಫರೋಹನು ಮೋಶೆ ಆರೋನರ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಇದಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ಫರೋಹನು ತನ್ನ ಮನೆಗೆ ಹೊರಟುಹೋದನು. ಮೋಶೆ ಆರೋನರು ಮಾಡಿದ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ಲಕ್ಷ್ಯಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ಈಜಿಪ್ಟಿನವರು ನದಿಯ ನೀರನ್ನು ಕುಡಿಯಲಾಗಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಅವರು ನದಿಯ ಸುತ್ತಲೂ ಕುಡಿಯುವ ನೀರಿಗಾಗಿ ಬಾವಿಗಳನ್ನು ಅಗೆದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ಯೆಹೋವನು ನೈಲ್ ನದಿಯ ನೀರನ್ನು ರಕ್ತವನ್ನಾಗಿ ಮಾರ್ಪಡಿಸಿದ ಬಳಿಕ ಏಳು ದಿನಗಳು ಕಳೆದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಯೆಹೋವನು ಹೀಗೆನ್ನುತ್ತಾನೆ ಎಂದು ಹೇಳು: ‘ನನ್ನನ್ನು ಆರಾಧಿಸುವುದಕ್ಕೆ ನನ್ನ ಜನರು ಹೋಗಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ನನ್ನ ಜನರನ್ನು ನೀನು ಹೋಗಗೊಡಿಸದಿದ್ದರೆ ನಾನು ಈಜಿಪ್ಟನ್ನು ಕಪ್ಪೆಗಳಿಂದ ತುಂಬಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ನೈಲ್ ನದಿಯು ಕಪ್ಪೆಗಳಿಂದ ತುಂಬಿ ಹೋಗುವುದು. ಕಪ್ಪೆಗಳು ನದಿಯಿಂದ ಬಂದು ನಿಮ್ಮ ಮನೆಗಳನ್ನು ಪ್ರವೇಶಿಸುವವು; ನಿಮ್ಮ ಮಲಗುವ ಕೋಣೆಯಲ್ಲಿಯೂ ನಿಮ್ಮ ಹಾಸಿಗೆಗಳಲ್ಲಿಯೂ ನಿಮ್ಮ ಅಧಿಕಾರಿಗಳ ಮನೆಗಳಲ್ಲಿಯೂ ನಿಮ್ಮ ಒಲೆಗಳಲ್ಲಿಯೂ ನೀರಿನ ಜಾಡಿಗಳಲ್ಲಿಯೂ ಹಿಟ್ಟುನಾದುವ ತಟ್ಟೆಗಳಲ್ಲಿಯೂ ಇರುವವು; ");
INSERT INTO kan2010_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ನಿನ್ನ ಮೇಲೆಯೂ ನಿನ್ನ ಪ್ರಜೆಗಳ ಮೇಲೆಯೂ ನಿನ್ನ ಅಧಿಕಾರಿಗಳ ಮೇಲೆಯೂ ಇರುವವು’” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಆರೋನನಿಗೆ, ‘ನಿನ್ನ ಕೋಲನ್ನು ಹಿಡಿದುಕೊಂಡು ಹೊಳೆಗಳ, ಕಾಲುವೆಗಳ ಮತ್ತು ಕೆರೆಗಳ ಮೇಲೆ ಕೈಚಾಚು’ ಎಂದು ಹೇಳು. ಆಗ ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆ ಕಪ್ಪೆಗಳು ಹೊರಬರುವವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ಅಂತೆಯೇ ಆರೋನನು ಈಜಿಪ್ಟಿನ ನೀರುಗಳ ಮೇಲೆ ತನ್ನ ಕೈಯನ್ನು ಚಾಚಿದಾಗ ಕಪ್ಪೆಗಳು ನೀರುಗಳಿಂದ ಹೊರಬಂದು ಈಜಿಪ್ಟ್ ದೇಶವನ್ನು ಆವರಿಸಿಕೊಳ್ಳತೊಡಗಿದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ಮಾಂತ್ರಿಕರು ತಮ್ಮ ಮಂತ್ರವಿದ್ಯೆಯಿಂದ ಅದೇರೀತಿ ಮಾಡಿ ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆ ಕಪ್ಪೆಗಳನ್ನು ಬರಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ಕರೆಯಿಸಿ, “ನನ್ನಿಂದ ಮತ್ತು ನನ್ನ ಜನರ ಮೇಲಿಂದ ಕಪ್ಪೆಗಳನ್ನು ತೊಲಗಿಸಬೇಕೆಂದು ಯೆಹೋವನನ್ನು ಕೇಳಿಕೊಳ್ಳಿರಿ. ಯೆಹೋವನಿಗೆ ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸಲು ನಾನು ಆತನ ಜನರನ್ನು ಹೋಗಗೊಡಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ಮೋಶೆಯು ಫರೋಹನಿಗೆ, “ಕಪ್ಪೆಗಳು ಯಾವಾಗ ಬಿಟ್ಟುಹೋಗಬೇಕೆಂದು ತಿಳಿಸು. ನಾನು ನಿನಗೋಸ್ಕರ, ನಿನ್ನ ಜನರಿಗೋಸ್ಕರ ಮತ್ತು ನಿನ್ನ ಅಧಿಕಾರಿಗಳಿಗೋಸ್ಕರ ಪ್ರಾರ್ಥಿಸುವೆನು. ಆಗ ಕಪ್ಪೆಗಳು ನಿನ್ನನ್ನೂ ನಿನ್ನ ಮನೆಗಳನ್ನೂ ಬಿಟ್ಟುಹೋಗಿ ನದಿಯಲ್ಲಿ ಮಾತ್ರ ಉಳಿಯುತ್ತವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ಅದಕ್ಕೆ ಫರೋಹನು, “ನಾಳೆ” ಅಂದನು. ಮೋಶೆ, “ನೀನು ಹೇಳಿದಂತೆಯೇ ಆಗುವುದು. ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಸಮಾನನಾದ ದೇವರೇ ಇಲ್ಲವೆಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ಕಪ್ಪೆಗಳು ನಿನ್ನನ್ನೂ ನಿನ್ನ ಮನೆಗಳನ್ನೂ ನಿನ್ನ ಅಧಿಕಾರಿಗಳನ್ನೂ ನಿನ್ನ ಜನರನ್ನೂ ಬಿಟ್ಟುಹೋಗಿ ನದಿಯಲ್ಲಿ ಮಾತ್ರ ಉಳಿದುಕೊಳ್ಳುವವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ಮೋಶೆ ಆರೋನರು ಫರೋಹನ ಬಳಿಯಿಂದ ಹೋದರು. ಫರೋಹನ ವಿರುದ್ಧವಾಗಿ ಕಳುಹಿಸಿದ ಕಪ್ಪೆಗಳನ್ನು ತೊಲಗಿಸಬೇಕೆಂದು ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ಯೆಹೋವನು ಮೋಶೆಯ ಬೇಡಿಕೆಯನ್ನು ಅನುಗ್ರಹಿಸಿದನು. ಕಪ್ಪೆಗಳು ಮನೆಗಳಲ್ಲಿಯೂ ಅಂಗಳಗಳಲ್ಲಿಯೂ ಹೊಲಗಳಲ್ಲಿಯೂ ಸತ್ತುಹೋದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ಅವುಗಳನ್ನು ಕೂಡಿಸಿದಾಗ ರಾಶಿರಾಶಿಗಳಾದವು. ದೇಶವು ದುರ್ವಾಸನೆಯಿಂದ ತುಂಬಿಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ಕಪ್ಪೆಗಳಿಂದ ಬಿಡುಗಡೆಯಾದದ್ದನ್ನು ಫರೋಹನು ಕಂಡು ಮತ್ತೆ ತನ್ನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸಿಕೊಂಡನು. ಮೋಶೆ ಆರೋನರ ಬೇಡಿಕೆಯನ್ನು ಅವನು ಈಡೇರಿಸಲಿಲ್ಲ. ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಇದಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಆರೋನನಿಗೆ, ‘ನಿನ್ನ ಕೋಲನ್ನು ಎತ್ತಿ ನೆಲದ ಧೂಳನ್ನು ಹೊಡೆ’ ಎಂದು ಹೇಳು. ಆಗ ಧೂಳು ಈಜಿಪ್ಟಿನಲ್ಲೆಲ್ಲಾ ಹೇನುಗಳಾಗುವವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ಅವರು ಹಾಗೆಯೇ ಮಾಡಿದರು. ಆರೋನನು ತನ್ನ ಕೈಯಲ್ಲಿದ್ದ ಕೋಲನ್ನು ಎತ್ತಿ ನೆಲದ ಧೂಳನ್ನು ಹೊಡೆದನು. ಆಗ ಈಜಿಪ್ಟಿನ ಪ್ರತಿಯೊಂದು ಸ್ಥಳದ ಧೂಳು ಹೇನುಗಳಾಗಿ ಪ್ರಾಣಿಗಳ ಮೇಲೂ ಜನರ ಮೇಲೂ ಏರಿಕೊಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ಮಾಂತ್ರಿಕರು ತಮ್ಮ ಮಂತ್ರವಿದ್ಯೆಯಿಂದ ಅದೇರೀತಿ ಮಾಡಲು ಪ್ರಯತ್ನಿಸಿದರೂ ಧೂಳಿನಿಂದ ಹೇನುಗಳನ್ನು ಮಾಡಲು ಅವರಿಗೆ ಸಾಧ್ಯವಾಗಲಿಲ್ಲ. ಹೇನುಗಳು ಪ್ರಾಣಿಗಳ ಮೇಲೂ ಜನರ ಮೇಲೂ ಉಳಿದುಕೊಂಡವು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ಆದ್ದರಿಂದ ಮಾಂತ್ರಿಕರು ಫರೋಹನಿಗೆ, “ಇದು ದೇವರ ಕಾರ್ಯವೇ” ಎಂದು ಹೇಳಿದರು. ಆದರೆ ಫರೋಹನು ಅವರ ಮಾತಿಗೆ ಕಿವಿಗೊಡಲಿಲ್ಲ. ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಇದಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಬೆಳಿಗ್ಗೆ ಎದ್ದು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗು. ಫರೋಹನು ನದಿಗೆ ಹೋಗುವನು. ನೀನು ಅವನಿಗೆ, ‘ಯೆಹೋವನು ಹೀಗೆನ್ನುತ್ತಾನೆ: ನನ್ನ ಜನರು ಹೋಗಿ ನನ್ನನ್ನು ಆರಾಧಿಸಲಿ! ");
INSERT INTO kan2010_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ನೀನು ನನ್ನ ಜನರನ್ನು ಹೋಗಗೊಡಿಸದಿದ್ದರೆ, ಹುಳಗಳು ನಿನ್ನ ಮೇಲೆಯೂ ನಿನ್ನ ಅಧಿಕಾರಿಗಳ ಮೇಲೆಯೂ ನಿನ್ನ ಜನರ ಮೇಲೆಯೂ ನಿಮ್ಮ ಮನೆಗಳಲ್ಲಿಯೂ ತುಂಬಿಕೊಳ್ಳುವವು; ನೆಲದ ಮೇಲೆಲ್ಲಾ ಇರುವವು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ಆದರೆ ನಾನು ಈಜಿಪ್ಟಿನವರೊಡನೆ ವರ್ತಿಸುವಂತೆ ಇಸ್ರೇಲರೊಡನೆ ವರ್ತಿಸುವುದಿಲ್ಲ. ನನ್ನ ಜನರು ವಾಸಿಸುವ ಗೋಷೆನ್ ಪ್ರದೇಶದಲ್ಲಿ ಯಾವ ಹುಳವೂ ಇರುವುದಿಲ್ಲ. ನಾನೇ ಭೂಲೋಕವನ್ನು ಆಳುವ ಯೆಹೋವನೆಂದು ಆಗ ನೀನು ತಿಳಿದುಕೊಳ್ಳುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ಆದ್ದರಿಂದ ನಾಳೆ ನನ್ನ ಜನಕ್ಕೂ ನಿನ್ನ ಜನಕ್ಕೂ ವ್ಯತ್ಯಾಸ ಮಾಡುವೆನು. ಅದೇ ನನ್ನ ಸಾಕ್ಷಿ’ ಎಂದು ಹೇಳಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ಯೆಹೋವನು ತಾನು ಹೇಳಿದಂತೆಯೇ ಮಾಡಿದನು. ಲೆಕ್ಕವಿಲ್ಲದಷ್ಟು ಹುಳಗಳು ಈಜಿಪ್ಟಿಗೆ ಬಂದು ಫರೋಹನ ಮನೆಯಲ್ಲಿಯೂ ಅವನ ಅಧಿಕಾರಿಗಳ ಮನೆಗಳಲ್ಲಿಯೂ ತುಂಬಿಕೊಂಡವು. ಇಡೀ ಈಜಿಪ್ಟನ್ನೇ ಅವು ತುಂಬಿಕೊಂಡದ್ದರಿಂದ ದೇಶವು ಹಾಳಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ಆಗ ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ಕರೆಯಿಸಿ, “ನಿಮ್ಮ ದೇವರಿಗೆ ಈ ದೇಶದಲ್ಲಿಯೇ ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ಅದಕ್ಕೆ ಮೋಶೆ, “ಅದು ಸರಿಯಲ್ಲ. ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ನಾವು ಅರ್ಪಿಸುವ ಯಜ್ಞಗಳು ಈಜಿಪ್ಟಿನವರಿಗೆ ನಿಷಿದ್ಧವಾಗಿವೆ. ಹೀಗಿರಲು ಅವರ ಕಣ್ಣೆದುರಿಗೇ ಅಂಥ ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಿದರೆ, ಅವರು ನಮ್ಮನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲುವುದಿಲ್ಲವೇ? ");
INSERT INTO kan2010_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ನಾವು ಅರಣ್ಯದಲ್ಲಿ ಮೂರು ದಿನ ಪ್ರಯಾಣ ಮಾಡಿ ನಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸುವಂತಾಗಲಿ. ಹೀಗೆ ಮಾಡಲು ಯೆಹೋವನೇ ನಮಗೆ ಹೇಳಿದ್ದಾನೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ಅದಕ್ಕೆ ಫರೋಹನು, “ಅರಣ್ಯದಲ್ಲಿ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಲು ನಾನು ನಿಮಗೆ ಅಪ್ಪಣೆ ಕೊಡುವೆನು; ಆದರೆ ಬಹುದೂರ ಹೋಗಬೇಡಿ; ಈಗ ಹೋಗಿ ನನಗೋಸ್ಕರ ಪ್ರಾರ್ಥಿಸಿರಿ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ಅದಕ್ಕೆ ಮೋಶೆ, “ನಾನು ಇಲ್ಲಿಂದ ಹೋದಾಗ, ನಿನಗೂ ನಿನ್ನ ಪ್ರಜೆಗಳಿಗೂ ನಿನ್ನ ಅಧಿಕಾರಿಗಳಿಗೂ ಹುಳಗಳ ಬಾಧೆ ನಾಳೆಯಿಂದ ಇರಬಾರದೆಂಬುದಾಗಿ ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸುವೆನು. ಆದರೆ ಮತ್ತೆ ನೀನು ವಂಚಿಸಿ ಜನರು ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸದಂತೆ ತಡೆಯಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ಮೋಶೆಯು ಫರೋಹನ ಬಳಿಯಿಂದ ಹೋಗಿ ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ಯೆಹೋವನು ಮೋಶೆಯ ಬೇಡಿಕೆಯನ್ನು ಅನುಗ್ರಹಿಸಿದನು. ಯೆಹೋವನು ಫರೋಹನಿಂದಲೂ ಅವನ ಅಧಿಕಾರಿಗಳಿಂದಲೂ ಅವನ ಜನರಿಂದಲೂ ಹುಳಗಳನ್ನು ತೊಲಗಿಸಿದನು. ಯಾವ ಹುಳಗಳೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ಆದರೆ ಫರೋಹನು ಮತ್ತೆ ತನ್ನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸಿಕೊಂಡು ಜನರನ್ನು ಹೋಗಗೊಡಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ ಅವನಿಗೆ ಹೀಗೆ ಹೇಳು: ‘ಇಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವನು ಹೇಳುವುದೇನೆಂದರೆ, ನನ್ನನ್ನು ಆರಾಧಿಸುವುದಕ್ಕೆ ನನ್ನ ಜನರು ಹೋಗಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ನೀನು ಅವರನ್ನು ಬಿಡದೆ ಇನ್ನೂ ತಡೆದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ನಾನು ಕೈಯೆತ್ತಿ ಹೊಲಗಳಲ್ಲಿರುವ ನಿನ್ನ ಪಶುಗಳನ್ನೂ ನಿನ್ನ ಎಲ್ಲಾ ಕುದುರೆಗಳನ್ನೂ ಕತ್ತೆಗಳನ್ನೂ ಒಂಟೆಗಳನ್ನೂ ದನಕರುಗಳನ್ನೂ ಕುರಿಗಳನ್ನೂ ಘೋರವ್ಯಾದಿಯಿಂದ ಸಾಯಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ಆದರೆ ಇಸ್ರೇಲರ ಪಶುಗಳಿಗೂ ಈಜಿಪ್ಟಿನವರ ಪಶುಗಳಿಗೂ ವ್ಯತ್ಯಾಸ ಮಾಡುವೆನು. ಇಸ್ರೇಲರ ಯಾವ ಪಶುವೂ ಸಾಯುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ಇದು ನಡೆಯತಕ್ಕ ಕಾಲವನ್ನು ನಿರ್ಣಯಿಸಿ ನಾಳೆಯೇ ಇದನ್ನು ಕಾರ್ಯರೂಪಕ್ಕೆ ತರುವೆನು’ ಎಂದು ಹೇಳಬೇಕು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ಮರುದಿನ ಯೆಹೋವನು ಈ ಕಾರ್ಯವನ್ನು ಮಾಡಿದನು. ಈಜಿಪ್ಟಿನ ಹೊಲಗಳಲ್ಲಿದ್ದ ಪಶುಗಳೆಲ್ಲಾ ಸತ್ತುಹೋದವು; ಆದರೆ ಇಸ್ರೇಲರಿಗೆ ಸೇರಿದ ಯಾವ ಪಶುವೂ ಸಾಯಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ಇಸ್ರೇಲರ ಯಾವ ಪಶುವಾದರೂ ಸತ್ತಿದೆಯೋ ಎಂದು ತಿಳಿದುಕೊಳ್ಳಲು ಫರೋಹನು ಜನರನ್ನು ಕಳುಹಿಸಿದನು. ಇಸ್ರೇಲರ ಪಶುಗಳಲ್ಲಿ ಒಂದಾದರೂ ಸತ್ತಿರಲಿಲ್ಲ. ಆದರೂ ಫರೋಹನು ತನ್ನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸಿಕೊಂಡದ್ದರಿಂದ ಇಸ್ರೇಲರನ್ನು ಹೋಗಗೊಡಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ, “ನೀವು ಒಲೆಯ ಬೂದಿಯನ್ನು ಕೈತುಂಬ ತೆಗೆದುಕೊಳ್ಳಿರಿ. ಮೋಶೆಯು ಅದನ್ನು ಫರೋಹನ ಮುಂದೆ ಗಾಳಿಯಲ್ಲಿ ತೂರಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ಅದು ಧೂಳಾಗಿ ಈಜಿಪ್ಟಿನಲ್ಲೆಲ್ಲಾ ಹರಡಿಕೊಳ್ಳುವುದು; ಈ ಧೂಳು ಈಜಿಪ್ಟಿನಲ್ಲಿರುವ ಮನುಷ್ಯರನ್ನಾಗಲಿ ಪಶುಗಳನ್ನಾಗಲಿ ತಾಗಿದಾಗ ಅವರ ಚರ್ಮದ ಮೇಲೆ ಹುಣ್ಣುಗಳಾಗುತ್ತವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ಆದ್ದರಿಂದ ಮೋಶೆ ಆರೋನರು ಒಲೆಯಿಂದ ಬೂದಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಫರೋಹನ ಮುಂದೆ ನಿಂತುಕೊಂಡರು. ಅವರು ಬೂದಿಯನ್ನು ಗಾಳಿಯಲ್ಲಿ ತೂರಿದಾಗ ಜನರ ಮೇಲೂ ಪ್ರಾಣಿಗಳ ಮೇಲೂ ಹುಣ್ಣುಗಳಾಗತೊಡಗಿದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ಮೋಶೆಯ ಈ ಕಾರ್ಯವನ್ನು ವಿಫಲಗೊಳಿಸಲು ಮಾಂತ್ರಿಕರಿಗೆ ಸಾಧ್ಯವಾಗಲಿಲ್ಲ. ಯಾಕೆಂದರೆ ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ಜನರಂತೆ ಮಾಂತ್ರಿಕರ ಮೇಲೆಯೂ ಹುಣ್ಣುಗಳಾದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ಆದರೆ ಯೆಹೋವನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಗೊಳಿಸಿದ್ದರಿಂದ ಫರೋಹನು ಮೋಶೆ ಆರೋನರ ಮಾತನ್ನು ಕೇಳಲಿಲ್ಲ. ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಇದಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಮುಂಜಾನೆ ಎದ್ದು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, ಅವನಿಗೆ, ‘ಇಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವನು ಹೀಗೆನ್ನುತ್ತಾನೆ: ನನ್ನನ್ನು ಆರಾಧಿಸಲು ನನ್ನ ಜನರು ಹೋಗಲಿ! ");
INSERT INTO kan2010_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ಇಲ್ಲವಾದರೆ, ನಾನು ನಿನ್ನ ವಿರುದ್ಧವಾಗಿಯೂ ನಿನ್ನ ಅಧಿಕಾರಿಗಳ ವಿರುದ್ಧವಾಗಿಯೂ ನಿನ್ನ ಜನರ ವಿರುದ್ಧವಾಗಿಯೂ ನನ್ನ ಪೂರ್ಣಶಕ್ತಿಯಿಂದ ಉಪದ್ರವಗಳನ್ನು ಕಳುಹಿಸುವೆನು. ಆಗ ನನ್ನಂಥ ದೇವರು ಲೋಕದಲ್ಲಿ ಇಲ್ಲವೇ ಇಲ್ಲವೆಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ನಾನು ನನ್ನ ಶಕ್ತಿಯಿಂದ ನಿನಗೂ ನಿನ್ನ ಜನರಿಗೂ ವ್ಯಾಧಿಯನ್ನು ಬರಮಾಡಿ ನಿಮ್ಮನ್ನು ನಿರ್ಮೂಲ ಮಾಡಬಹುದಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ಆದರೆ, ನನ್ನ ಶಕ್ತಿಯನ್ನು ನಿನಗೆ ತೋರಿಸಬೇಕೆಂದೂ ಲೋಕದ ಜನರೆಲ್ಲರು ನನ್ನ ಬಗ್ಗೆ ತಿಳಿದುಕೊಳ್ಳಬೇಕೆಂದೂ ನಾನು ನಿನ್ನನ್ನು ಇನ್ನೂ ಉಳಿಸಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ಆದರೂ ನೀನು ನನ್ನ ಜನರಿಗೆ ವಿರುದ್ಧವಾಗಿರುವೆ; ಅವರಿಗೆ ಸ್ವತಂತ್ರವನ್ನು ಕೊಡದಿರುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ಆದ್ದರಿಂದ ನಾಳೆ ಇದೇ ಸಮಯಕ್ಕೆ ಸರಿಯಾಗಿ ಭೀಕರವಾದ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯನ್ನು ಸುರಿಸುವೆನು. ಈಜಿಪ್ಟ್ ರಾಜ್ಯವು ಸ್ಥಾಪನೆಯಾದಂದಿನಿಂದ ಇಂಥ ಆಲಿಕಲ್ಲಿನ ಮಳೆ ಬಿದ್ದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ಈಗ ನೀನು ನಿನ್ನ ಪಶುಗಳನ್ನೂ ನಿನ್ನ ಹೊಲದಲ್ಲಿರುವ ನಿನ್ನ ಪ್ರತಿಯೊಂದನ್ನೂ ಸುರಕ್ಷಿತವಾದ ಸ್ಥಳದಲ್ಲಿ ಇರಿಸಬೇಕು. ಮನೆಯೊಳಗಿರದೆ ಹೊಲದಲ್ಲಿರುವ ಮನುಷ್ಯರೂ ಪಶುಗಳೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆಗೆ ಸಿಕ್ಕಿಕೊಂಡು ಸಾಯುವರು’ ಎಂದು ಹೇಳಬೇಕು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ಫರೋಹನ ಅಧಿಕಾರಿಗಳಲ್ಲಿ ಕೆಲವರು ಯೆಹೋವನ ಸಂದೇಶಕ್ಕೆ ಕಿವಿಗೊಟ್ಟು ತಮ್ಮ ಎಲ್ಲಾ ಪಶುಗಳನ್ನೂ ಗುಲಾಮರನ್ನೂ ಮನೆಯೊಳಗೆ ಸೇರಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ಆದರೆ ಇತರರು ಯೆಹೋವನ ಸಂದೇಶವನ್ನು ನಿರ್ಲಕ್ಷ್ಯಮಾಡಿ ತಮ್ಮ ಎಲ್ಲಾ ಗುಲಾಮರನ್ನೂ ಪಶುಗಳನ್ನೂ ಹೊಲಗಳಲ್ಲಿಯೇ ಬಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಿನ್ನ ತೋಳುಗಳನ್ನು ಆಕಾಶದ ಕಡೆಗೆ ಚಾಚು; ಆಗ ಈಜಿಪ್ಟಿನಲ್ಲೆಲ್ಲಾ ಆಲಿಕಲ್ಲಿನ ಮಳೆ ಬೀಳತೊಡಗುವುದು. ಆಲಿಕಲ್ಲಿನ ಮಳೆಯು ಜನರ, ಪ್ರಾಣಿಗಳ ಮತ್ತು ಈಜಿಪ್ಟಿನ ಹೊಲಗಳಲ್ಲಿರುವ ಎಲ್ಲಾ ಸಸ್ಯಗಳ ಮೇಲೆ ಬೀಳುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ಆದ್ದರಿಂದ ಮೋಶೆ ತನ್ನ ಕೋಲನ್ನು ಆಕಾಶದ ಕಡೆಗೆ ಚಾಚಿದನು. ಕೂಡಲೇ ಯೆಹೋವನು, ಗುಡುಗು ಮಿಂಚುಗಳಿಂದ ಕೂಡಿದ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯನ್ನು ಈಜಿಪ್ಟಿನಲ್ಲೆಲ್ಲಾ ಸುರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ಆಲಿಕಲ್ಲಿನ ಮಳೆಯು ಭೀಕರವಾಗಿತ್ತು, ಝಗಝಗಿಸುವ ಮಿಂಚೂ ಅದರೊಂದಿಗಿತ್ತು. ಈಜಿಪ್ಟ್ ಒಂದು ರಾಷ್ಟ್ರವಾದಂದಿನಿಂದ ಇಂಥ ಭೀಕರವಾದ ಆಲಿಕಲ್ಲಿನ ಮಳೆ ಎಂದೂ ಆಗಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ಈಜಿಪ್ಟಿನ ಹೊಲಗಳಲ್ಲಿದ್ದ ಪ್ರತಿಯೊಂದನ್ನೂ ಬಿರುಗಾಳಿ ನಾಶಮಾಡಿತು. ಆಲಿಕಲ್ಲು ಜನರನ್ನೂ ಪ್ರಾಣಿಗಳನ್ನೂ ಸಸ್ಯಗಳನ್ನೂ ನಾಶಮಾಡಿತು; ಹೊಲಗಳಲ್ಲಿದ್ದ ಎಲ್ಲಾ ಮರಗಳನ್ನು ಮುರಿದುಹಾಕಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ಇಸ್ರೇಲರು ವಾಸವಾಗಿದ್ದ ಗೋಷೆನ್ ಪ್ರದೇಶದಲ್ಲಿ ಮಾತ್ರ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯಾಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ಕರೆಸಿ ಅವರಿಗೆ, “ಈ ಸಾರಿ ನಾನು ಪಾಪಮಾಡಿದ್ದೇನೆ. ಯೆಹೋವನೇ ನೀತಿವಂತನು. ನಾನೂ ನನ್ನ ಜನರೂ ದೋಷಿಗಳಾಗಿದ್ದೇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ಭಯಂಕರವಾದ ಗುಡುಗೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯೂ ಬಹಳ ಹೆಚ್ಚಾದವು. ಇವುಗಳನ್ನು ನಿಲ್ಲಿಸಬೇಕೆಂದು ದೇವರನ್ನು ಪ್ರಾರ್ಥಿಸಿರಿ; ನಿಮ್ಮನ್ನು ಈ ದೇಶದಿಂದ ಕಳುಹಿಸಿಕೊಡುತ್ತೇನೆ; ತಡೆಯುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ಮೋಶೆಯು ಫರೋಹನಿಗೆ, “ನಾನು ಪಟ್ಟಣದಿಂದಾಚೆಗೆ ಹೋದಕೂಡಲೇ ಕೈಯೆತ್ತಿ ಯೆಹೋವನಲ್ಲಿ ಪ್ರಾರ್ಥಿಸುವೆನು, ಆಗ ಗುಡುಗೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯೂ ನಿಂತುಹೋಗುವವು. ಭೂಲೋಕವು ಯೆಹೋವನ ಅಧೀನದಲ್ಲಿದೆಯೆಂದು ಆಗ ನೀನು ತಿಳಿದುಕೊಳ್ಳುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ಆದರೆ ನೀನಾಗಲಿ ನಿನ್ನ ಅಧಿಕಾರಿಗಳಾಗಲಿ ಇನ್ನೂ ದೇವರಿಗೆ ಭಯಪಡುವುದಿಲ್ಲ ಎಂಬುದು ನನಗೆ ಗೊತ್ತಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ಅಗಸೆಗೆ ಮೊಗ್ಗೆಯೂ ಬಾರ್ಲಿಗೆ ತೆನೆಯೂ ಬಂದಿದ್ದರಿಂದ ಈ ಎರಡು ಬೆಳೆಗಳು ನಾಶವಾದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ಆದರೆ ಗೋಧಿಯೂ ಕಡಲೆಯೂ ಬೇರೆ ಧಾನ್ಯಗಳ ನಂತರ ಆಗುವ ಬೆಳೆಗಳಾಗಿದ್ದವು. ಆದ್ದರಿಂದ ಈ ಪೈರುಗಳು ನಾಶವಾಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ಮೋಶೆಯು ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಟು ಪಟ್ಟಣದಾಚೆಗೆ ಹೋದಾಗ ಕೈಯೆತ್ತಿ ಯೆಹೋವನಲ್ಲಿ ಪ್ರಾರ್ಥಿಸಿದನು. ಆಗ ಗುಡುಗೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯೂ ನಿಂತುಹೋದವು; ಮಳೆಯೂ ನಿಂತುಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ಮಳೆಯೂ ಆಲಿಕಲ್ಲಿನ ಮಳೆಯೂ ಗುಡುಗೂ ನಿಂತುಹೋದದ್ದನ್ನು ಕಂಡ ಫರೋಹನು ಮತ್ತು ಅವನ ಅಧಿಕಾರಿಗಳು ಮತ್ತೆ ತಮ್ಮ ಹೃದಯಗಳನ್ನು ಕಠಿಣಪಡಿಸಿಕೊಂಡು ಪಾಪ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ಇಸ್ರೇಲರು ಸ್ವತಂತ್ರರಾಗಿ ಹೋಗಲು ಫರೋಹನು ಬಿಡಲಿಲ್ಲ. ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಹೇಳಿಸಿದಂತೆಯೇ ಇದಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಫರೋಹನ ಬಳಿಗೆ ಹೋಗು. ನಾನು ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನು ತೋರಿಸಲು ಅವಕಾಶವಾಗಲೆಂದು ಫರೋಹನ ಮತ್ತು ಅವನ ಅಧಿಕಾರಿಗಳ ಹೃದಯಗಳನ್ನು ಕಠಿಣಪಡಿಸಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ನಾನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಮಾಡಿದ ಸೂಚಕಕಾರ್ಯಗಳನ್ನೂ ಇತರ ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನೂ ನೀವು ನಿಮ್ಮ ಮಕ್ಕಳಿಗೆ ಮತ್ತು ಮೊಮ್ಮಕ್ಕಳಿಗೆ ವಿವರಿಸಿ, ‘ಯೆಹೋವನು ಈಜಿಪ್ಟಿನವರನ್ನು ತನಗೆ ಇಷ್ಟ ಬಂದಂತೆ ಶಿಕ್ಷಿಸಿದನು’ ಎಂಬುದಾಗಿ ತಿಳಿಸಬೇಕೆಂದು ನಾನು ಫರೋಹನ ಮತ್ತು ಅವನ ಅಧಿಕಾರಿಗಳ ಹೃದಯಗಳನ್ನು ಕಠಿಣಪಡಿಸಿದ್ದೇನೆ. ಇದಲ್ಲದೆ ಈ ಮಹತ್ಕಾರ್ಯಗಳ ಮೂಲಕ ನಾನೇ ಯೆಹೋವನೆಂದು ತಿಳಿದುಕೊಳ್ಳುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ಆದ್ದರಿಂದ ಮೋಶೆ ಆರೋನರು ಫರೋಹನ ಬಳಿಗೆ ಹೋಗಿ, “ಇಬ್ರಿಯರ ದೇವರಾದ ಯೆಹೋವನು ಹೀಗೆನ್ನುತ್ತಾನೆ: ‘ನೀನು ಎಲ್ಲಿಯವರೆಗೆ ನನಗೆ ವಿಧೇಯನಾಗುವುದಿಲ್ಲ? ನನ್ನನ್ನು ಆರಾಧಿಸಲು ನನ್ನ ಜನರನ್ನು ಕಳುಹಿಸಿಕೊಡು! ");
INSERT INTO kan2010_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ನೀನು ನನ್ನ ಜನರನ್ನು ಕಳುಹಿಸಿಕೊಡದಿದ್ದರೆ, ನಾಳೆಯೇ ನಿನ್ನ ದೇಶದೊಳಗೆ ಮಿಡತೆಗಳನ್ನು ತರುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ಮಿಡತೆಗಳು ಬಂದು ಭೂಮಿಯನ್ನು ಮುಚ್ಚಿಕೊಳ್ಳುವವು; ನೆಲವೇ ಕಾಣಿಸದೆ ಹೋಗುವುದು. ಆಲಿಕಲ್ಲಿನ ಮಳೆಯಿಂದ ನಾಶವಾಗದೆ ಉಳಿದಿರುವುದನ್ನು ಮಿಡತೆಗಳು ತಿಂದುಬಿಡುತ್ತವೆ; ಹೊಲದಲ್ಲಿರುವ ಎಲ್ಲಾ ಮರಗಳ ಎಲೆಗಳನ್ನು ತಿಂದುಬಿಡುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ಅವು ನಿನ್ನ ಮನೆಗಳಲ್ಲಿಯೂ ನಿನ್ನ ಅಧಿಕಾರಿಗಳ ಮನೆಗಳಲ್ಲಿಯೂ ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ಮನೆಗಳಲ್ಲಿಯೂ ತುಂಬಿರುತ್ತವೆ. ನಿನ್ನ ತಂದೆತಾತಂದಿರೂ ನೋಡಿಲ್ಲದಷ್ಟು ಮಿಡತೆಗಳಿರುತ್ತವೆ’” ಎಂದು ಹೇಳಿದರು. ಬಳಿಕ ಅವರು ಫರೋಹನ ಬಳಿಯಿಂದ ಹೊರಟುಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ಅಧಿಕಾರಿಗಳು ಫರೋಹನಿಗೆ, “ಈ ಜನರಿಂದ ಇನ್ನೆಷ್ಟು ಕಾಲ ನಾವು ಬಳಲಬೇಕು? ಇವರು ಹೋಗಿ ತಮ್ಮ ದೇವರಾದ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಲಿ. ಈಜಿಪ್ಟ್ ನಾಶವಾಗುತ್ತಿದೆ ಎಂಬುದು ನಿನಗಿನ್ನೂ ಮನವರಿಕೆಯಾಗಿಲ್ಲವೇ?” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ಆದ್ದರಿಂದ ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ತನ್ನ ಬಳಿಗೆ ಕರೆಯಿಸಿ, “ಹೋಗಿ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿರಿ. ಆದರೆ ಹೋಗುವವರು ಯಾರೆಂಬುದನ್ನು ನನಗೆ ತಿಳಿಸಿ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ಮೋಶೆಯು, “ಯೌವನಸ್ಥರು, ಮುದುಕರು, ಎಲ್ಲರೂ ಹೋಗುತ್ತೇವೆ. ನಮ್ಮ ಗಂಡು ಹೆಣ್ಣುಮಕ್ಕಳನ್ನೂ ನಮ್ಮ ದನಕುರಿಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡು ಹೋಗುತ್ತೇವೆ. ಯಾಕೆಂದರೆ ಇದು ಯೆಹೋವನ ಜಾತ್ರೆ” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ಫರೋಹನು ಅವರಿಗೆ, “ಯೆಹೋವನಾಣೆ, ನೀವು ನಿಮ್ಮ ಸ್ತ್ರೀಯರನ್ನೂ ಮಕ್ಕಳನ್ನೂ ಕರೆದುಕೊಂಡು ಹೋಗಲು ನಾನು ಅನುಮತಿ ಕೊಡುವುದೇ ಇಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ನೀವು ನನಗೆ ವಿರೋಧವಾಗಿ ಸಂಚುಮಾಡುತ್ತಿರುವುದು ಈಗ ಸ್ಪಷ್ಟವಾಯಿತು” ಎಂದು ಹೇಳಿದನು. ಬಳಿಕ ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ಕಳುಹಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆ ನಿನ್ನ ಕೈಯನ್ನೆತ್ತು. ಆಗ ಮಿಡತೆಗಳು ಬರುವವು! ಮಿಡತೆಗಳು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲೆಲ್ಲಾ ಹರಡಿಕೊಳ್ಳುವವು. ಆಲಿಕಲ್ಲಿನ ಮಳೆಯಿಂದ ನಾಶವಾಗದೆ ಉಳಿದುಕೊಂಡ ಪೈರುಗಳನ್ನೆಲ್ಲಾ ಮಿಡತೆಗಳು ತಿಂದುಬಿಡುವವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ಅಂತೆಯೇ ಮೋಶೆ ಈಜಿಪ್ಟ್ ದೇಶದ ಮೇಲೆ ಕೈ ಚಾಚಿದನು. ಆಗ ಯೆಹೋವನು ಪೂರ್ವದಿಂದ ಬಲವಾದ ಗಾಳಿ ಬೀಸುವಂತೆ ಮಾಡಿದನು. ಗಾಳಿಯು ಹಗಲಿರುಳು ಬೀಸಿತು. ಮುಂಜಾನೆಯಾದಾಗ ಆ ಗಾಳಿಯಿಂದ ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆ ಮಿಡತೆಗಳು ಬಂದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ಮಿಡತೆಗಳು ಈಜಿಪ್ಟ್ ದೇಶದೊಳಗೆ ಹಾರಿಬಂದು ನೆಲದ ಮೇಲೆ ಇಳಿದವು. ಈಜಿಪ್ಟಿನಲ್ಲಿ ಹಿಂದೆಂದೂ ಇಷ್ಟು ಮಿಡತೆಗಳು ಇರಲಿಲ್ಲ; ಇನ್ನು ಮುಂದೆಯೂ ಇರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ಮಿಡತೆಗಳು ನೆಲವನ್ನು ಮುಚ್ಚಿಕೊಂಡವು; ಇದರಿಂದಾಗಿ ನೆಲವು ಕಾಣದಂತಾಯಿತು. ಆಲಿಕಲ್ಲಿನ ಮಳೆಗೆ ನಾಶವಾಗದೆ ಉಳಿದಿದ್ದ ಎಲ್ಲಾ ಪೈರುಗಳನ್ನೂ ಮರಗಳಲ್ಲಿದ್ದ ಕಾಯಿಗಳನ್ನೂ ಅವು ತಿಂದುಬಿಟ್ಟವು. ಈಜಿಪ್ಟಿನಲ್ಲೆಲ್ಲಾ ಮರಗಳಲ್ಲಾಗಲಿ ಗಿಡಗಳಲ್ಲಾಗಲಿ ಹಸುರಾಗಿದ್ದ ಒಂದಾದರೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ಫರೋಹನು ಕೂಡಲೇ ಮೋಶೆ ಆರೋನರನ್ನು ಕರೆಸಿ, “ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನಿಗೂ ನಿಮಗೂ ವಿರುದ್ಧವಾಗಿ ಪಾಪ ಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ಇದೊಂದು ಸಲ ನನ್ನ ಪಾಪಗಳನ್ನು ಕ್ಷಮಿಸಿ ಈ ‘ವಿಪತ್ತನ್ನು’ ನನ್ನಿಂದ ತೊಲಗಿಸಬೇಕೆಂದು ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ಮೋಶೆಯು ಫರೋಹನ ಬಳಿಯಿಂದ ಹೋಗಿ ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ಆದ್ದರಿಂದ ಯೆಹೋವನು ಗಾಳಿಯ ದಿಕ್ಕನ್ನು ಬದಲಾಯಿಸಿ, ಪಶ್ಚಿಮದಿಂದ ಬಲವಾದ ಗಾಳಿ ಬೀಸುವಂತೆ ಮಾಡಿದನು; ಅದು ಮಿಡತೆಗಳನ್ನು ಕೆಂಪು ಸಮುದ್ರಕ್ಕೆ ಹಾರಿಸಿತು. ಈಜಿಪ್ಟಿನಲ್ಲಿ ಒಂದು ಮಿಡತೆಯೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ಆದರೆ ಫರೋಹನು ಮತ್ತೆ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸಿಕೊಂಡು ಇಸ್ರೇಲರನ್ನು ಕಳುಹಿಸಿಕೊಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಿನ್ನ ಕೈಯನ್ನು ಆಕಾಶದ ಕಡೆಗೆ ಚಾಚು. ಆಗ ಕಾರ್ಗತ್ತಲೆಯು ಈಜಿಪ್ಟನ್ನು ಆವರಿಸುವುದು. ಆ ಕಾರ್ಗತ್ತಲೆಯಿಂದ ಜನರು ತಡವರಿಸುತ್ತಾ ನಡೆಯುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ಮೋಶೆ ತನ್ನ ಕೈಯನ್ನು ಆಕಾಶದ ಕಡೆಗೆ ಚಾಚಿದಾಗ ಕಾರ್ಗತ್ತಲು ಈಜಿಪ್ಟನ್ನು ಆವರಿಸಿತು. ಕಾರ್ಗತ್ತಲು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಮೂರು ದಿನಗಳವರೆಗೆ ಇತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ಈ ಮೂರು ದಿನಗಳಲ್ಲಿ ಯಾರೂ ಒಬ್ಬರನ್ನೊಬ್ಬರು ನೋಡಲಾಗಲಿಲ್ಲ. ಯಾವ ಸ್ಥಳಕ್ಕೂ ಹೋಗಲಿಲ್ಲ. ಆದರೆ ಇಸ್ರೇಲರು ವಾಸಿಸುತ್ತಿದ್ದ ಸ್ಥಳಗಳಲ್ಲಿ ಬೆಳಕಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ಫರೋಹನು ಮತ್ತೆ ಮೋಶೆಯನ್ನು ಕರೆಸಿ, “ಹೋಗಿ, ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿರಿ! ನೀವು ನಿಮ್ಮ ಮಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗಬಹುದು. ಆದರೆ ನೀವು ನಿಮ್ಮ ಕುರಿಗಳನ್ನು ದನಕರುಗಳನ್ನು ಇಲ್ಲಿಯೇ ಬಿಟ್ಟುಹೋಗಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ಮೋಶೆಯು, “ನಾವು ನಮ್ಮ ಕುರಿಗಳನ್ನೂ ದನಕರುಗಳನ್ನೂ ಕಾಣಿಕೆಗಳಿಗಾಗಿ ಮತ್ತು ಯಜ್ಞಗಳಿಗಾಗಿ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು; ಮಾತ್ರವಲ್ಲದೆ ");
INSERT INTO kan2010_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ನಮ್ಮ ಪ್ರಾಣಿಗಳನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಂಡು ಹೋಗುವೆವು. ಒಂದನ್ನಾದರೂ ಬಿಟ್ಟುಹೋಗುವುದಿಲ್ಲ; ಯಾವ ಪಶುಗಳನ್ನು ಅರ್ಪಿಸಬೇಕೆಂಬುದು ಅಲ್ಲಿಗೆ ಹೋದಾಗಲೇ ನಮಗೆ ತಿಳಿಯುವುದು. ಆದ್ದರಿಂದ, ನಾವು ಇವುಗಳನ್ನೆಲ್ಲಾ ನಮ್ಮ ಜೊತೆಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ಯೆಹೋವನು ಫರೋಹನ ಹೃದಯವನ್ನು ಮತ್ತೆ ಕಠಿಣಗೊಳಿಸಿದನು. ಆದ್ದರಿಂದ ಫರೋಹನು ಅವರನ್ನು ಕಳುಹಿಸಿಕೊಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ಫರೋಹನು ಮೋಶೆಗೆ, “ಇಲ್ಲಿಂದ ತೊಲಗಿ ಹೋಗು! ನೀನು ನನ್ನ ಸನ್ನಿಧಿಗೆ ಇನ್ನು ಮೇಲೆ ಬರಕೂಡದು. ನೀನು ಮತ್ತೆ ಬಂದರೆ ನಿನಗೆ ಮರಣದಂಡನೆ ವಿಧಿಸುವೆನು” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ಅದಕ್ಕೆ ಮೋಶೆಯು ಫರೋಹನಿಗೆ, “ಸರಿ, ಇನ್ನು ಮೇಲೆ ನಾನು ನಿನ್ನ ಸನ್ನಿಧಿಗೆ ಬರುವುದೇ ಇಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನು ಫರೋಹನಿಗೂ ಈಜಿಪ್ಟಿಗೂ ಮತ್ತೊಂದು ವಿಪತ್ತನ್ನು ಬರಮಾಡುತ್ತೇನೆ. ಆಗ ಅವನು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕಳುಹಿಸುವನು; ನಿಮ್ಮನ್ನು ಬಲವಂತದಿಂದ ಕಳುಹಿಸಿಬಿಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ನೀನು ಇಸ್ರೇಲರಿಗೆ ಈ ಸಂದೇಶವನ್ನು ತಿಳಿಸು: ‘ಸ್ತ್ರೀಯರೂ ಪುರುಷರೂ ತಮ್ಮ ನೆರೆಯವರಿಂದ ಬೆಳ್ಳಿಬಂಗಾರಗಳ ವಸ್ತುಗಳನ್ನು ಕೇಳಿಕೊಳ್ಳಬೇಕು.’ ");
INSERT INTO kan2010_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ಈಜಿಪ್ಟಿನವರು ನಿಮಗೆ ದಯೆತೋರುವಂತೆ ಯೆಹೋವನು ಅವರನ್ನು ಪ್ರೇರೇಪಿಸುವನು. ಈಜಿಪ್ಟಿನ ಜನರು ಮತ್ತು ಫರೋಹನ ಅಧಿಕಾರಿಗಳು ಮೋಶೆಯನ್ನು ಮಹಾಪುರುಷನೆಂದು ತಿಳಿದುಕೊಂಡಿದ್ದಾರೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ಮೋಶೆಯು ಜನರಿಗೆ, “ಯೆಹೋವನು ಹೀಗೆನ್ನುತ್ತಾನೆ: ‘ಇಂದು ಮಧ್ಯರಾತ್ರಿ ನಾನು ಈಜಿಪ್ಟಿನ ಮೂಲಕ ಹಾದುಹೋಗುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ಈಜಿಪ್ಟಿನ ಚೊಚ್ಚಲು ಮಕ್ಕಳೆಲ್ಲರೂ ಅಂದರೆ ಫರೋಹನ ಚೊಚ್ಚಲು ಮಗನಿಂದಿಡಿದು ಧಾನ್ಯವನ್ನು ಬೀಸುವ ಸೇವಕಿಯ ಚೊಚ್ಚಲು ಮಗನವರೆಗೂ ಇರುವ ಚೊಚ್ಚಲು ಮಕ್ಕಳೆಲ್ಲರೂ ಸಾಯುವರು. ಇದಲ್ಲದೆ ಚೊಚ್ಚಲು ಪಶುಗಳೂ ಸಾಯುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ಈಜಿಪ್ಟಿನಲ್ಲೆಲ್ಲಾ ದೊಡ್ಡ ಗೋಳಾಟ ಉಂಟಾಗುವುದು, ಅಂಥ ಗೋಳಾಟ ಈವರೆಗೂ ಆಗಿಲ್ಲ; ಮುಂದೆಯೂ ಆಗುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ಆದರೆ ಇಸ್ರೇಲರಲ್ಲಿ ಯಾರಿಗೂ ಕೇಡಾಗುವುದಿಲ್ಲ. ಒಂದು ನಾಯಿಯೂ ಅವರಿಗೆ ಬೊಗಳುವುದಿಲ್ಲ. ಇಸ್ರೇಲಿನ ಜನರಿಗಾಗಲಿ ಪಶುಗಳಿಗಾಗಲಿ ಕೇಡಾಗುವುದಿಲ್ಲ. ಇಸ್ರೇಲರಿಗೂ ಮತ್ತು ಈಜಿಪ್ಟಿನವರಿಗೂ ನಾನು ವ್ಯತ್ಯಾಸ ಮಾಡಿದ್ದೇನೆಂದು ಆಗ ನೀವು ತಿಳಿದುಕೊಳ್ಳುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ಆಗ ನಿಮ್ಮ ಈ ಗುಲಾಮರೆಲ್ಲರೂ (ಈಜಿಪ್ಟಿನ ಅಧಿಕಾರಿಗಳು) ನನ್ನ ಬಳಿಗೆ ಬಂದು ನನಗೆ ಅಡ್ಡಬಿದ್ದು ನನ್ನನ್ನು ಆರಾಧಿಸುವರು.’ ಅವರು, ‘ಹೊರಟುಹೋಗಿ, ನಿಮ್ಮ ಜನರೆಲ್ಲರನ್ನು ನಿಮ್ಮೊಂದಿಗೆ ಕರೆದುಕೊಂಡು ಹೋಗಿರಿ’ ಎಂದು ಹೇಳುವರು. ಆಗ ನಾನು ಫರೋಹನ ಬಳಿಯಿಂದ ಬಿಟ್ಟುಹೋಗುವೆನು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಫರೋಹನು ನಿನ್ನ ಮಾತಿಗೆ ಕಿವಿಗೊಡುವುದಿಲ್ಲ. ಯಾಕೆಂದರೆ ನಾನು ನನ್ನ ಮಹಾಶಕ್ತಿಯನ್ನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ತೋರಿಸಬೇಕಾಗಿದೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ಯೆಹೋವನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಗೊಳಿಸಿದ್ದರಿಂದ ಫರೋಹನು ಇಸ್ರೇಲರನ್ನು ಕಳುಹಿಸಿಕೊಡಲಿಲ್ಲ; ಆದ್ದರಿಂದ ಮೋಶೆ ಆರೋನರು ಈ ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನೆಲ್ಲಾ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ಮೋಶೆ ಆರೋನರು ಇನ್ನೂ ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದಾಗ ಯೆಹೋವನು ಅವರೊಡನೆ ಮಾತಾಡಿ, ");
INSERT INTO kan2010_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ಈ ತಿಂಗಳು ನಿಮಗೆ ವರ್ಷದ ಮೊದಲನೆ ತಿಂಗಳಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ಈ ಆಜ್ಞೆಯು ಇಡೀ ಇಸ್ರೇಲರ ಸಮೂಹಕ್ಕೆ ಅನ್ವಯಿಸುತ್ತದೆ. ಈ ತಿಂಗಳ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನ ಮನೆಯಲ್ಲಿರುವ ಜನರಿಗಾಗಿ ಒಂದು ಕುರಿಮರಿಯನ್ನು ಅಥವಾ ಒಂದು ಆಡುಮರಿಯನ್ನು ಕೊಯ್ಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ಅದನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ತಿನ್ನಲು ಅವನ ಮನೆಯಲ್ಲಿ ಸಾಕಷ್ಟು ಜನರಿಲ್ಲದಿದ್ದರೆ ಅವನು ತನ್ನ ನೆರೆಯವರನ್ನು ಆಮಂತ್ರಿಸಿ ಅವರೊಂದಿಗೆ ಅದರ ಮಾಂಸವನ್ನು ಹಂಚಿಕೊಳ್ಳಬೇಕು. ಪ್ರತಿಯೊಬ್ಬನಿಗೂ ತಿನ್ನಲು ಸಾಕಷ್ಟು ಮಾಂಸವಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ಅದು ಒಂದು ವರ್ಷದ ಗಂಡು ಕುರಿಯಾಗಿರಬೇಕು ಅಥವಾ ಆಡಾಗಿರಬೇಕು. ಅಲ್ಲದೆ ಕಳಂಕ ರಹಿತವಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ಈ ತಿಂಗಳ ಹದಿನಾಲ್ಕನೆಯ ದಿನದವರೆಗೆ ನೀವು ಆ ಪಶುವನ್ನು ಸಾಕಬೇಕು. ಅಂದು ಸಂಜೆ ಇಸ್ರೇಲರೆಲ್ಲರೂ ಆ ಪಶುಗಳನ್ನು ಕೊಯ್ಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ಈ ಪಶುಗಳ ರಕ್ತವನ್ನು ತೆಗೆದಿಟ್ಟು ಜನರು ಭೋಜನಮಾಡುವ ಮನೆಗಳ ಬಾಗಿಲಿನ ಎರಡು ನಿಲುವು ಕಂಬಗಳಿಗೂ ಮೇಲಿನ ಪಟ್ಟಿಗಳಿಗೂ ಆ ರಕ್ತವನ್ನು ಹಚ್ಚಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“ಅಂದು ರಾತ್ರಿ ಆ ಪಶುವಿನ ಮಾಂಸವನ್ನು ಸುಟ್ಟು ಸಂಪೂರ್ಣವಾಗಿ ತಿನ್ನಬೇಕು. ಅದರೊಡನೆ ಕಹಿಯಾದ ಪಲ್ಯಗಳನ್ನೂ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನೂ ತಿನ್ನಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ನೀವು ಆ ಪಶುವಿನ ಮಾಂಸವನ್ನು ಹಸಿಯಾಗಲಿ ನೀರಿನಲ್ಲಿ ಬೇಯಿಸಿಯಾಗಲಿ ತಿನ್ನಬಾರದು; ಅದರ ಮಾಂಸವನ್ನು ಬೆಂಕಿಯ ಮೇಲಿಟ್ಟು ಬೇಯಿಸಬೇಕು. ಅದರ ತಲೆ, ಕಾಲುಗಳನ್ನೂ ಒಳಗಿನ ಭಾಗಗಳನ್ನೂ ಬೆಂಕಿಯ ಮೇಲೆ ಬೇಯಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ಅದರ ಮಾಂಸವನ್ನೆಲ್ಲಾ ಆ ರಾತ್ರಿಯಲ್ಲಿಯೇ ತಿನ್ನಬೇಕು. ಬೆಳಗಾಗುವವರೆಗೆ ಮಾಂಸವೇನಾದರೂ ಉಳಿದರೆ ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“ನೀವು ಭೋಜನ ಮಾಡುವಾಗ ಪ್ರಯಾಣ ಮಾಡುತ್ತಿರುವಂತೆ ಬಟ್ಟೆ ಧರಿಸಿಕೊಂಡಿರಬೇಕು; ಕೆರಗಳನ್ನು ಹಾಕಿಕೊಂಡು ನಿಮ್ಮ ಊರುಗೋಲನ್ನು ಕೈಯಲ್ಲಿ ಹಿಡಿದಿರಬೇಕು. ನೀವು ಅವಸವಸರವಾಗಿ ತಿನ್ನಬೇಕು. ಯಾಕೆಂದರೆ ಇದು ಯೆಹೋವನ ಪಸ್ಕಹಬ್ಬ. ");
INSERT INTO kan2010_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“ಆ ರಾತ್ರಿ ನಾನು ಈಜಿಪ್ಟಿನ ಮೂಲಕ ಹಾದುಹೋಗಿ ಈಜಿಪ್ಟಿನ ಚೊಚ್ಚಲು ಪಶುಗಳನ್ನೂ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನೂ ಕೊಲ್ಲುವೆನು; ಈಜಿಪ್ಟಿನ ಎಲ್ಲಾ ದೇವರುಗಳಿಗೆ ತೀರ್ಪು ಮಾಡುವೆನು. ನಾನೇ ಯೆಹೋವನೆಂದು ತೋರಿಸಿಕೊಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ಆದರೆ ನಿಮ್ಮ ಮನೆಗಳಿಗೆ ಹಚ್ಚಿರುವ ರಕ್ತವು ಒಂದು ವಿಶೇಷ ಸೂಚನೆಯಾಗಿದೆ. ನಾನು ಆ ರಕ್ತವನ್ನು ನೋಡಿದಾಗ ನಿಮ್ಮ ಮನೆಯನ್ನು ದಾಟಿಹೋಗುವೆನು. ಈಜಿಪ್ಟಿನ ಜನರಿಗೆ ಕೇಡುಗಳಾಗುವಂತೆ ಮಾಡುವೆನು. ಆದರೆ ಆ ವ್ಯಾಧಿಗಳು ನಿಮಗೆ ಹಾನಿ ಮಾಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ಆದ್ದರಿಂದ ನೀವು ಆ ರಾತ್ರಿಯನ್ನು ಯಾವಾಗಲೂ ಜ್ಞಾಪಿಸಿಕೊಳ್ಳುವಿರಿ. ಅದು ನಿಮಗೆ ವಿಶೇಷವಾದ ಹಬ್ಬವಾಗಿರುವುದು. ನಿಮ್ಮ ಸಂತತಿಯವರು ಈ ಹಬ್ಬದಿಂದ ಯೆಹೋವನನ್ನು ಎಂದೆಂದಿಗೂ ಸನ್ಮಾನಿಸುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ಈ ಹಬ್ಬದಲ್ಲಿ ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನು ಏಳು ದಿವಸ ತಿನ್ನುವಿರಿ. ಹಬ್ಬದ ಪ್ರಥಮ ದಿನದಲ್ಲಿ ನೀವು ನಿಮ್ಮ ಮನೆಯಿಂದ ಎಲ್ಲಾ ಹುಳಿಯನ್ನು ತೆಗೆದುಹಾಕುವಿರಿ. ಈ ಹಬ್ಬದ ಏಳು ದಿನಗಳಲ್ಲಿ ಯಾವುದೇ ಹುಳಿಯನ್ನು ತಿನ್ನಬಾರದು. ಯಾವನಾದರೂ ಹುಳಿಯನ್ನು ತಿಂದರೆ, ನೀವು ಅವನನ್ನು ಇಸ್ರೇಲಿನಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ಈ ಹಬ್ಬದ ಪ್ರಥಮ ಮತ್ತು ಕೊನೆಯ ದಿನಗಳಲ್ಲಿ ಪವಿತ್ರ ಸಭೆಯಾಗಿ ಕೂಡಿಬರಬೇಕು. ಈ ಹಬ್ಬದ ದಿನಗಳಲ್ಲಿ ನೀವು ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ಆದರೆ ನಿಮ್ಮ ಭೋಜನಕ್ಕಾಗಿ ಆಹಾರ ಸಿದ್ಧಪಡಿಸಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಹಬ್ಬವನ್ನು ಆಚರಿಸಲೇಬೇಕು. ಯಾಕೆಂದರೆ ಆ ದಿನದಲ್ಲಿಯೇ ನಾನು ನಿಮ್ಮ ಎಲ್ಲಾ ಜನರ ಗುಂಪುಗಳನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಬಿಡಿಸಿ ಕರೆದುಕೊಂಡು ಹೋದೆನು. ಆದ್ದರಿಂದ ನಿಮ್ಮ ಸಂತತಿಯವರೆಲ್ಲರೂ ಆ ದಿನವನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಬೇಕು. ಇದು ಶಾಶ್ವತವಾದ ಕಟ್ಟಳೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ಆದ್ದರಿಂದ ಪ್ರಥಮ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ಸಾಯಂಕಾಲ ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನು ತಿನ್ನಲು ಆರಂಭಿಸಿ ಅದೇ ತಿಂಗಳ ಇಪ್ಪತ್ತೊಂದನೇ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೂ ತಿನ್ನುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ಏಳು ದಿನಗಳವರೆಗೆ ನಿಮ್ಮ ಮನೆಗಳಲ್ಲಿ ಯಾವ ಹುಳಿಯೂ ಇರಬಾರದು. ಯಾವ ಇಸ್ರೇಲಿಯಾದರೂ ಯಾವ ವಿದೇಶಿಯನಾದರೂ ಈ ಹಬ್ಬದಲ್ಲಿ ಹುಳಿಯನ್ನು ತಿಂದರೆ, ಅವನನ್ನು ಇಸ್ರೇಲರ ಸಮುದಾಯದಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ಈ ಹಬ್ಬದಲ್ಲಿ ನೀವು ಹುಳಿಯನ್ನು ತಿನ್ನಬಾರದು. ನೀವು ಎಲ್ಲೇ ವಾಸವಾಗಿದ್ದರೂ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನೇ ತಿನ್ನಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ಆದ್ದರಿಂದ ಮೋಶೆಯು ಹಿರಿಯರ ಸಭೆ ಸೇರಿಸಿ, “ನಿಮ್ಮ ಕುಟುಂಬಗಳಿಗೆ ಬೇಕಾದ ಪಶುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಪಸ್ಕಕ್ಕಾಗಿ ಅವುಗಳನ್ನು ಕೊಯ್ಯಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಬರಲನ್ನು ತೆಗೆದುಕೊಂಡು ರಕ್ತ ತುಂಬಿರುವ ಪಾತ್ರೆಯಲ್ಲಿ ಅದ್ದಿರಿ. ರಕ್ತವನ್ನು ಬಾಗಿಲಿನ ನಿಲುವು ಕಂಬಗಳಿಗೆ ಮತ್ತು ಮೇಲಿನ ಪಟ್ಟಿಗಳಿಗೆ ಹಚ್ಚಿರಿ. ಮುಂಜಾನೆಯಾಗುವವರೆಗೆ ಯಾರೂ ತಮ್ಮ ಮನೆಯನ್ನು ಬಿಟ್ಟು ಹೊರಗೆ ಹೋಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ಆ ಸಮಯದಲ್ಲಿ ಚೊಚ್ಚಲಾದವುಗಳನ್ನು ಸಂಹರಿಸಲು ಯೆಹೋವನು ಈಜಿಪ್ಟಿನ ಮೂಲಕ ಹಾದುಹೋಗುವನು. ಬಾಗಿಲಿನ ನಿಲುವು ಕಂಬಗಳಿಗೆ ಮತ್ತು ಮೇಲಿನ ಪಟ್ಟಿಗಳಿಗೆ ಹಚ್ಚಿದ ರಕ್ತವನ್ನು ಯೆಹೋವನು ನೋಡಿ ಆ ಮನೆಯನ್ನು ಸಂರಕ್ಷಿಸುವನು. ಸಂಹಾರಕನು ನಿಮ್ಮ ಮನೆಯೊಳಗೆ ಬಂದು ಸಂಹರಿಸಲು ಯೆಹೋವನು ಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ನೀವು ಈ ಆಜ್ಞೆಯನ್ನು ಜ್ಞಾಪಕದಲ್ಲಿಡಬೇಕು. ಇದು ನಿಮಗೂ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ಯೆಹೋವನು ನಿಮಗೆ ಕೊಡಲಿರುವ ದೇಶಕ್ಕೆ ನೀವು ಹೋದಾಗಲೂ ಈ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","‘ಈ ಹಬ್ಬವನ್ನು ಮಾಡುವುದೇಕೆ?’ ಎಂದು ನಿಮ್ಮ ಮಕ್ಕಳು ನಿಮ್ಮನ್ನು ಕೇಳುವಾಗ, ");
INSERT INTO kan2010_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","‘ಇದು ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸಲು ಮಾಡುವ ಪಸ್ಕಹಬ್ಬವಾಗಿದೆ. ಯಾಕೆಂದರೆ ನಾವು ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದಾಗ ಯೆಹೋವನು ಇಸ್ರೇಲರ ಮನೆಗಳನ್ನು ಬಿಟ್ಟು ದಾಟಿಹೋದನು; ಈಜಿಪ್ಟಿನವರನ್ನು ಸಂಹರಿಸಿದನು; ಆದರೆ ಆತನು ನಮ್ಮ ಮನೆಗಳಲ್ಲಿದ್ದವರನ್ನು ರಕ್ಷಿಸಿದನು’ ಎಂದು ಹೇಳಬೇಕು. “ಆಗ ಮೋಶೆಯ ಮಾತನ್ನು ಕೇಳುತ್ತಿದ್ದ ಇಸ್ರೇಲರು ಅಡ್ಡಬಿದ್ದು ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿದರು.” ");
INSERT INTO kan2010_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಂತೆಯೇ ಇಸ್ರೇಲರು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ಮಧ್ಯರಾತ್ರಿಯಲ್ಲಿ ಯೆಹೋವನು ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನೆಲ್ಲಾ ಸಂಹರಿಸಿದನು. ಫರೋಹನ ಚೊಚ್ಚಲು ಮಗನಿಂದಿಡಿದು ಸೆರೆಮನೆಯಲ್ಲಿದ್ದ ಕೈದಿಯ ಚೊಚ್ಚಲು ಮಗನವರೆಗೆ ಇರುವ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಮಕ್ಕಳನ್ನು ಆತನು ಸಂಹರಿಸಿದನು. ಚೊಚ್ಚಲು ಪಶುಗಳೂ ಸಂಹರಿಸಲ್ಪಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ಆ ರಾತ್ರಿಯಲ್ಲಿ ಫರೋಹನೂ ಅವನ ಅಧಿಕಾರಿಗಳೂ ಈಜಿಪ್ಟಿನ ಜನರೆಲ್ಲರೂ ಎದ್ದರು. ಈಜಿಪ್ಟಿನಲ್ಲಿ ಮಹಾ ಗೋಳಾಟ ಉಂಟಾಯಿತು. ಯಾಕೆಂದರೆ ಸಾವಿಲ್ಲದ ಮನೆಯೇ ಇರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ಆದ್ದರಿಂದ ಆ ರಾತ್ರಿ, ಫರೋಹನು ಮೋಶೆ ಆರೋನರನ್ನು ಕರೆಸಿ, “ನನ್ನ ಜನರನ್ನು ಬಿಟ್ಟುಹೋಗಿರಿ. ನೀವು ಕೇಳಿಕೊಂಡಂತೆ ನೀವು ಮತ್ತು ನಿಮ್ಮ ಜನರು ಹೊರಟುಹೋಗಿ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ನೀವು ಕೇಳಿಕೊಂಡಂತೆ ನಿಮ್ಮ ಕುರಿಗಳನ್ನೂ ದನಕರುಗಳನ್ನೂ ನಿಮ್ಮೊಂದಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ! ನನ್ನನ್ನು ಆಶೀರ್ವಾದಿಸಿರಿ!” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ಈಜಿಪ್ಟಿನ ಜನರು ಸಹ ತಮ್ಮನ್ನು ಬೇಗನೆ ಬಿಟ್ಟು ಹೋಗಬೇಕೆಂದು ಇಸ್ರೇಲರನ್ನು ಬೇಡಿಕೊಂಡು, “ನೀವು ಬಿಟ್ಟು ಹೋಗದಿದ್ದರೆ, ನಾವೆಲ್ಲಾ ಸಾಯುವೆವು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ತಮ್ಮ ರೊಟ್ಟಿಗೆ ಹುಳಿಹಾಕಲು ಇಸ್ರೇಲರಿಗೆ ಸಮಯವಿರಲಿಲ್ಲ. ಅವರು ಹಿಟ್ಟಿನ ಮುದ್ದೆಯನ್ನು ಬಟ್ಟೆಯಲ್ಲಿ ಸುತ್ತಿ ಹೆಗಲಿನ ಮೇಲೆ ಹೊತ್ತುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ಅಲ್ಲದೆ ಮೋಶೆಯು ಹೇಳಿದಂತೆಯೇ ಇಸ್ರೇಲರು ತಮ್ಮ ನೆರೆಮನೆಯವರ ಬಳಿಗೆ ಹೋಗಿ ಬಟ್ಟೆಗಳನ್ನೂ ಬೆಳ್ಳಿಬಂಗಾರಗಳ ವಸ್ತುಗಳನ್ನೂ ಕೇಳಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ಈಜಿಪ್ಟಿನವರು ಇಸ್ರೇಲರಿಗೆ ದಯೆ ತೋರಿಸುವಂತೆ ಯೆಹೋವನು ಪ್ರೇರೇಪಿಸಿದ್ದರಿಂದ ಈಜಿಪ್ಟಿನವರು ತಮ್ಮ ಸ್ವತ್ತುಗಳನ್ನು ಇಸ್ರೇಲರಿಗೆ ಕೊಟ್ಟುಬಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ಇಸ್ರೇಲರು ರಮ್ಸೇಸ್‌ನಿಂದ ಸುಕ್ಕೋತಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಅವರಲ್ಲಿ ಸುಮಾರು ಆರು ಲಕ್ಷಮಂದಿ ಗಂಡಸರಿದ್ದರು. (ಈ ಸಂಖ್ಯೆಯಲ್ಲಿ ಮಕ್ಕಳು ಮತ್ತು ಹೆಂಗಸರು ಸೇರಿಲ್ಲ.) ");
INSERT INTO kan2010_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ಲೆಕ್ಕವಿಲ್ಲದಷ್ಟು ಕುರಿಗಳೂ ದನಕರುಗಳೂ ಇವರೊಂದಿಗಿದ್ದವು. ಇಸ್ರೇಲರಲ್ಲದ ಬೇರೆ ಜನರು ಸಹ ಇಸ್ರೇಲರೊಂದಿಗೆ ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ರೊಟ್ಟಿಗೆ ಹುಳಿಹಾಕುವಷ್ಟು ಸಮಯವೂ ಜನರಿಗೆ ಇರಲಿಲ್ಲ; ಅವರು ತಮ್ಮ ಪ್ರಯಾಣಕ್ಕಾಗಿ ವಿಶೇಷ ಆಹಾರವನ್ನು ತಯಾರಿಸುವುದಕ್ಕೂ ಆಗಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಅವರು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿ ಮಾಡಿ ತಮ್ಮೊಡನೆ ತೆಗೆದುಕೊಂಡು ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ಇಸ್ರೇಲರು ಈಜಿಪ್ಟಿನಲ್ಲಿ ನಾನೂರಮೂವತ್ತು ವರ್ಷ ವಾಸಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ನಾನೂರಮೂವತ್ತು ವರ್ಷಗಳಾದ ನಂತರ, ಅದೇ ದಿನದಂದು ಯೆಹೋವನ ಸೈನ್ಯಗಳೆಲ್ಲಾ ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟು ಹೊರಟವು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ಆದ್ದರಿಂದ ಯೆಹೋವನು ಅವರನ್ನು ಸಂರಕ್ಷಿಸಿ ಈಜಿಪ್ಟಿನಿಂದ ಹೊರತಂದದ್ದನ್ನು ಜ್ಞಾಪಕಮಾಡುವ ಆ ರಾತ್ರಿ ಬಹು ವಿಶೇಷವಾದ ರಾತ್ರಿಯಾಗಿದೆ. ಇಸ್ರೇಲರೆಲ್ಲರೂ ಆ ರಾತ್ರಿಯನ್ನು ಯಾವಾಗಲೂ ಜ್ಞಾಪಿಸಿಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ, “ಪಸ್ಕಹಬ್ಬದ ನಿಯಮಗಳು ಇಂತಿವೆ: ಯಾವ ಪರದೇಶಿಯೂ ಪಸ್ಕಹಬ್ಬದ ಊಟವನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ಆದರೆ ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಂಡಿರುವ ಗುಲಾಮನು ಪಸ್ಕಹಬ್ಬದ ಊಟವನ್ನು ಮಾಡಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ಆದರೆ ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಕೇವಲ ವಾಸವಾಗಿರುವವರಾಗಲಿ ಕೂಲಿಯಾಳಾಗಲಿ ಪಸ್ಕಹಬ್ಬದ ಊಟ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ಪಸ್ಕಹಬ್ಬದ ಊಟವನ್ನು ಮನೆಯೊಳಗೆ ತಿನ್ನಬೇಕು. ಪಸ್ಕದ ಮಾಂಸವನ್ನು ಮನೆಯಿಂದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಕೂಡದು. ಕುರಿಮರಿಯ ಎಲುಬುಗಳಲ್ಲಿ ಯಾವುದನ್ನೂ ಮುರಿಯಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ಇಸ್ರೇಲರ ಇಡೀ ಸಮೂಹವು ಈ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ವಾಸವಾಗಿರುವ ಪರದೇಶದವನು ಯೆಹೋವನ ಪಸ್ಕ ಭೋಜನದಲ್ಲಿ ಪಾಲುಗಾರನಾಗಬೇಕೆಂದು ಬಯಸಿದರೆ ಅವನು ಸುನ್ನತಿ ಮಾಡಿಸಿಕೊಳ್ಳಬೇಕು. ಆಗ ಅವನು ಇಸ್ರೇಲಿನವನಾಗುವುದರಿಂದ ಭೋಜನದಲ್ಲಿ ಪಾಲುಗಾರನಾಗಬಹುದು. ಆದರೆ ಸುನ್ನತಿಯಾಗಿಲ್ಲದವನು ಪಸ್ಕದ ಊಟ ಮಾಡಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ಪ್ರತಿಯೊಬ್ಬರಿಗೂ ಇದೇ ನಿಯಮ ಅನ್ವಯಿಸುತ್ತದೆ. ಸ್ವದೇಶದವನಿಗೂ ನಿಮ್ಮಲ್ಲಿ ವಾಸವಾಗಿರುವ ಪರದೇಶದವನಿಗೂ ಒಂದೇ ನಿಯಮವಿರಬೇಕು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರೇಲರೆಲ್ಲರೂ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ಆದ್ದರಿಂದ ಅದೇ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ಇಸ್ರೇಲರನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಜನರನ್ನು ಗುಂಪುಗುಂಪುಗಳಾಗಿ ಹೊರತಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ಇಸ್ರೇಲರಲ್ಲಿ ಹುಟ್ಟಿದ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳೆಲ್ಲಾ ನನಗೆ ಮೀಸಲಾಗಿರಬೇಕು; ಪ್ರತಿಯೊಬ್ಬ ಚೊಚ್ಚಲು ಮಗನು ನನ್ನವನೇ. ಪ್ರತಿಯೊಂದು ಚೊಚ್ಚಲು ಪಶುವು ನನ್ನದೇ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ಮೋಶೆಯು ಜನರಿಗೆ, “ನೀವು ಈಜಿಪ್ಟಿನ ಗುಲಾಮತನದಿಂದ ಬಿಡುಗಡೆಯಾದ ಈ ದಿನವನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಿರಿ. ಆದರೆ ಈ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ತನ್ನ ಮಹಾಶಕ್ತಿಯಿಂದ ನಿಮ್ಮನ್ನು ಸ್ವತಂತ್ರರನ್ನಾಗಿ ಮಾಡಿದನು. ನೀವು ಹುಳಿಯಿರುವ ರೊಟ್ಟಿಯನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ಅಬೀಬ್ ತಿಂಗಳಿನ ಈ ದಿನದಲ್ಲಿ ನೀವು ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟು ಹೊರಟಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ಆಗ ಯೆಹೋವನು ಒಂದು ವಿಶೇಷ ವಾಗ್ದಾನವನ್ನು ನಿಮ್ಮ ಪೂರ್ವಿಕರಿಗೆ ಮಾಡಿದನು. ಕಾನಾನ್ಯರು, ಹಿತ್ತಿಯರು, ಅಮೋರಿಯರು, ಹಿವ್ವಿಯರು ಮತ್ತು ಯೆಬೂಸಿಯರು ವಾಸಿಸುವ ಸಮೃದ್ಧಿಕರವಾದ ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಡುವುದಾಗಿ ಯೆಹೋವನು ವಾಗ್ದಾನ ಮಾಡಿದನು. ಆತನು ನಿಮಗೆ ಆ ದೇಶವನ್ನು ಕೊಟ್ಟಾಗ ಪ್ರತಿವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳ ಈ ದಿನವನ್ನು ಆರಾಧನೆಯ ವಿಶೇಷ ದಿನವನ್ನಾಗಿ ಇಟ್ಟುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“ಏಳು ದಿನಗಳವರೆಗೆ ನೀವು ಕೇವಲ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನೇ ತಿನ್ನಬೇಕು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯೊಹೋವನ ಘನತೆಗಾಗಿ ಒಂದು ದೊಡ್ಡ ಹಬ್ಬ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ಆದ್ದರಿಂದ ಹುಳಿಯಿರುವ ರೊಟ್ಟಿಯನ್ನು ಏಳು ದಿನಗಳವರೆಗೆ ತಿನ್ನಬಾರದು. ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಹುಳಿಯಿರುವ ರೊಟ್ಟಿ ಇರಲೇಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ಈ ದಿನದಲ್ಲಿ ನೀವು ನಿಮ್ಮ ಮಕ್ಕಳಿಗೆ, ‘ಯೆಹೋವನು ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಬಿಡಿಸಿಕೊಂಡು ಬಂದದ್ದರಿಂದ ನಾವು ಈ ಹಬ್ಬವನ್ನು ಮಾಡುತ್ತಿದ್ದೇವೆ’ ಎಂದು ಹೇಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“ಈ ಹಬ್ಬವು ನಿಮ್ಮ ಕೈಗಳಲ್ಲಿ ಜ್ಞಾಪಕಪಟ್ಟಿಯಂತಿದ್ದು ಯೆಹೋವನು ತನ್ನ ಮಹಾಶಕ್ತಿಯಿಂದ ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಬಿಡಿಸಿದ್ದನ್ನು ಮತ್ತು ನಿಮಗೆ ಆತನು ನೀಡಿದ ಉಪದೇಶಗಳನ್ನು ನೆನಪಿಗೆ ತರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ಆದ್ದರಿಂದ ಪ್ರತಿವರ್ಷ ನಿಯಮಿತವಾದ ಕಾಲದಲ್ಲಿ ನೀವು ಈ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“ಯೆಹೋವನು ನಿಮಗೆ ಕೊಡುವುದಾಗಿ ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶಕ್ಕೆ ನಿಮ್ಮನ್ನು ನಡಿಸುವನು. ಈಗ ಅಲ್ಲಿ ಕಾನಾನ್ಯರು ವಾಸವಾಗಿದ್ದಾರೆ. ಆದರೆ ದೇವರು ಆ ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಡುವುದಾಗಿ ನಿಮ್ಮ ಪೂರ್ವಿಕರಿಗೆ ವಾಗ್ದಾನ ಮಾಡಿದನು. ದೇವರು ಆ ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಟ್ಟನಂತರ ");
INSERT INTO kan2010_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ನೀವು ನಿಮ್ಮ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನು ಆತನಿಗಾಗಿ ಮೀಸಲಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ಚೊಚ್ಚಲು ಕತ್ತೆಮರಿಯನ್ನು ನೀವು ಯೆಹೋವನಿಂದ ಬಿಡಿಸಿಕೊಳ್ಳಬೇಕೆಂದಿದ್ದರೆ ಅದಕ್ಕೆ ಬದಲಾಗಿ ಒಂದು ಕುರಿಮರಿಯನ್ನು ಕೊಡಬೇಕು. ಕತ್ತೆಮರಿಯನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಲು ಇಷ್ಟಪಡದಿದ್ದರೆ, ಅದರ ಕುತ್ತಿಗೆಯನ್ನು ಮುರಿದು ಕೊಲ್ಲಬೇಕು. ಆದರೆ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನೆಲ್ಲಾ ಯೆಹೋವನಿಂದ ಬಿಡಿಸಿಕೊಳ್ಳಲೇಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“ಮುಂದಿನ ಕಾಲದಲ್ಲಿ ನಿಮ್ಮ ಮಕ್ಕಳು, ‘ನೀವು ಹೀಗೇಕೆ ಮಾಡುತ್ತೀರಿ?’ ಎಂದು ಕೇಳುವಾಗ ನೀವು, ‘ಯೆಹೋವನು ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ತನ್ನ ಮಹಾಶಕ್ತಿಯಿಂದ ರಕ್ಷಿಸಿದನು. ನಾವು ಅಲ್ಲಿ ಗುಲಾಮರಾಗಿದ್ದೆವು, ಆದರೆ ಯೆಹೋವನು ನಮ್ಮನ್ನು ಇಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ಈಜಿಪ್ಟಿನಲ್ಲಿ ಫರೋಹನು ತನ್ನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸಿಕೊಂಡು ನಮ್ಮನ್ನು ಕಳುಹಿಸಿಕೊಡಲಿಲ್ಲ. ಆಗ ಯೆಹೋವನು ಆ ದೇಶದ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನೆಲ್ಲಾ ಸಂಹರಿಸಿದನು. (ಯೆಹೋವನು ಚೊಚ್ಚಲು ಪಶುಗಳನ್ನು ಮತ್ತು ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನು ಕೊಂದನು.) ಆದ್ದರಿಂದ ನಾವು ಚೊಚ್ಚಲಾದ ಪ್ರತಿಯೊಂದು ಗಂಡುಪಶುವನ್ನು ಯೆಹೋವನಿಗೆ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸುತ್ತೇವೆ. ಈ ಕಾರಣದಿಂದಲೇ, ನಮ್ಮ ಪ್ರತಿಯೊಂದು ಗಂಡುಮಗುವನ್ನು ಯೆಹೋವನಿಂದ ಮತ್ತೆ ಖರೀದಿ ಮಾಡುತ್ತೇವೆ’ ಎಂದು ಹೇಳುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ಇದು ನಿಮ್ಮ ಕೈಗೆ ದಾರ ಕಟ್ಟಿದಂತಿರುತ್ತದೆ; ನಿಮ್ಮ ಕಣ್ಣುಗಳ ಮುಂದೆ ಒಂದು ಚಿಹ್ನೆಯಂತೆ ಇರುತ್ತದೆ. ಯೆಹೋವನು ತನ್ನ ಮಹಾಶಕ್ತಿಯಿಂದ ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದನೆಂಬುದನ್ನು ಜ್ಞಾಪಿಸಿಕೊಳ್ಳಲು ಇದು ಸಹಾಯ ಮಾಡುತ್ತದೆ.” ");
INSERT INTO kan2010_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ಇಸ್ರೇಲರು ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟುಹೋಗುವಂತೆ ಫರೋಹನು ಅನುಮತಿ ನೀಡಿದನು. ಇಸ್ರೇಲರು ಫಿಲಿಷ್ಟಿಯರ ದೇಶದ ಮೂಲಕ ಹಾದುಹೋಗುವ ರಸ್ತೆಯಲ್ಲಿ ಹೋಗಲು ಯೆಹೋವನು ಅನುಮತಿ ನೀಡಲಿಲ್ಲ. ಸಮುದ್ರದ ಮೂಲಕ ಹಾದುಹೋಗುವ ಆ ರಸ್ತೆ ಬಹಳ ಹತ್ತಿರವಾಗಿತ್ತು. ಆದರೆ ಯೆಹೋವನು, “ಇಸ್ರೇಲರು ಆ ದಾರಿಯಲ್ಲಿ ಹೋದರೆ, ಯುದ್ಧಮಾಡಬೇಕಾಗುವುದು. ಆಗ ಅವರು ತಮ್ಮ ಮನಸ್ಸುಗಳನ್ನು ಬದಲಾಯಿಸಿ ಈಜಿಪ್ಟಿಗೆ ಹಿಂತಿರುಗಬಹುದು” ಅಂದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ಆದ್ದರಿಂದ ಯೆಹೋವನು ಅವರನ್ನು ಕೆಂಪು ಸಮುದ್ರದ ಅರಣ್ಯದ ಮೂಲಕ ನಡೆಸಿದನು. ಇಸ್ರೇಲರು ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟಾಗ ಯುದ್ಧವಸ್ತ್ರಗಳನ್ನು ಧರಿಸಿಕೊಂಡಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ಮೋಶೆಯು ತನ್ನೊಡನೆ ಯೋಸೇಫನ ಎಲುಬುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋದನು. (ಯೋಸೇಫನು ಸಾಯುವ ಮೊದಲು, ತನಗಾಗಿ ಈ ಕಾರ್ಯವನ್ನು ಮಾಡುವಂತೆ ಇಸ್ರೇಲನ ಪುತ್ರರಿಂದ ಪ್ರಮಾಣ ಮಾಡಿಸಿದ್ದನು. ಯೋಸೇಫನು ಅವರಿಗೆ, “ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ರಕ್ಷಿಸುವಾಗ, ಈಜಿಪ್ಟಿನಿಂದ ನನ್ನ ಎಲುಬುಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗಲು ಮರೆಯಬೇಡಿ” ಎಂದು ಹೇಳಿದ್ದನು.) ");
INSERT INTO kan2010_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ಇಸ್ರೇಲರು ಸುಕ್ಕೋತನ್ನು ಬಿಟ್ಟು ಏತಾಮಿನಲ್ಲಿ ಪಾಳೆಯ ಹಾಕಿದರು. ಏತಾಮು ಮರುಭೂಮಿಗೆ ಹತ್ತಿರವಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ಯೆಹೋವನು ದಾರಿಯನ್ನು ತೋರಿಸಿದನು. ಹಗಲಿನಲ್ಲಿ ಜನರನ್ನು ನಡಿಸಲು ಯೆಹೋವನು ಎತ್ತರವಾದ ಮೇಘಸ್ತಂಭವನ್ನು ಉಪಯೋಗಿಸಿದನು; ರಾತ್ರಿ ವೇಳೆಯಲ್ಲಿ ದಾರಿಯನ್ನು ತೋರಿಸಲು ಯೆಹೋವನು ಎತ್ತರವಾದ ಅಗ್ನಿಸ್ತಂಭವನ್ನು ಉಪಯೋಗಿಸಿದನು. ಈ ಬೆಂಕಿಯು ಅವರಿಗೆ ಬೆಳಕು ಕೊಟ್ಟಿದ್ದರಿಂದ ಅವರು ರಾತ್ರಿಯಲ್ಲಿ ಪ್ರಯಾಣ ಮಾಡಲು ಸಾಧ್ಯವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ಹಗಲಿನಲ್ಲಿ ಎತ್ತರವಾದ ಮೇಘಸ್ತಂಭವೂ ರಾತ್ರಿವೇಳೆಯಲ್ಲಿ ಅಗ್ನಿಸ್ತಂಭವೂ ಯಾವಾಗಲೂ ಅವರ ಮುಂಭಾಗದಲ್ಲಿ ಅವರೊಂದಿಗಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ಪೀಹಹೀರೋತಿನ ಪೂರ್ವಕಡೆಯಲ್ಲಿ ಪ್ರಯಾಣ ಮಾಡಿ ಬಾಳ್ಚೆಫೋನಿಗೆ ಸಮೀಪದಲ್ಲಿರುವ ಮಿಗ್ದೋಲ್ ಮತ್ತು ಕೆಂಪು ಸಮುದ್ರದ ನಡುವೆ ಇಳಿದುಕೊಳ್ಳಬೇಕೆಂದು ಇಸ್ರೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ಇಸ್ರೇಲರು ಅರಣ್ಯದಲ್ಲಿ ದಾರಿ ತಪ್ಪಿದರು; ಅವರಿಗೆ ಹೋಗಲು ಯಾವ ಸ್ಥಳವೂ ಇರುವುದಿಲ್ಲ ಎಂದು ಫರೋಹನು ಭಾವಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ನಾನು ಫರೋಹನ ಹೃದಯವನ್ನು ಕಠಿಣಪಡಿಸುವುದರಿಂದ ಅವನು ನಿಮ್ಮನ್ನು ಬೆನ್ನಟ್ಟುವನು. ಆದರೆ ನಾನು ಫರೋಹನನ್ನು ಮತ್ತು ಅವನ ಸೈನ್ಯವನ್ನು ಸೋಲಿಸುವೆನು. ಇದು ನನಗೆ ಗೌರವವನ್ನು ತರುವುದು. ಆಗ ನಾನೇ ಯೆಹೋವನೆಂದು ಈಜಿಪ್ಟಿನ ಜನರು ತಿಳಿದುಕೊಳ್ಳುವರು” ಎಂದು ಹೇಳಿದನು. ಇಸ್ರೇಲರು ದೇವರಿಗೆ ವಿಧೇಯರಾಗಿ ಆತನು ಹೇಳಿದ್ದನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ಇಸ್ರೇಲರು ತಪ್ಪಿಸಿಕೊಂಡರೆಂಬ ವರದಿಯನ್ನು ಕೇಳಿದಾಗ, ಫರೋಹನ ಮತ್ತು ಅವನ ಅಧಿಕಾರಿಗಳ ಮನಸ್ಸುಗಳು ಬದಲಾದವು. ಫರೋಹನು, “ಇಸ್ರೇಲರನ್ನು ನಾವು ಯಾಕೆ ಹೋಗಲು ಬಿಟ್ಟೆವು? ಅಯ್ಯೋ, ನಾವೀಗ ನಮ್ಮ ಗುಲಾಮರನ್ನು ಕಳೆದುಕೊಂಡೆವಲ್ಲಾ!” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ಆದ್ದರಿಂದ ಫರೋಹನು ತನ್ನ ರಥವನ್ನು ಸಿದ್ಧಮಾಡಿಕೊಂಡು ತನ್ನೊಡನೆ ತನ್ನ ಜನರನ್ನು ಕರೆದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ಫರೋಹನು ತನ್ನ ಆರುನೂರು ರಥಗಳನ್ನೂ ಅವುಗಳ ಚಾಲಕರನ್ನೂ ಮತ್ತು ಅವುಗಳೊಡನೆ ಈಜಿಪ್ಟಿನ ಇತರ ರಥಗಳನ್ನೂ ತೆಗೆದುಕೊಂಡನು. ಪ್ರತಿಯೊಂದು ರಥದಲ್ಲಿ ಒಬ್ಬ ದಳಪತಿ ಇದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ಇಸ್ರೇಲರು ಕ್ರಮಬದ್ಧವಾಗಿ ಹೆಜ್ಜೆಹಾಕುತ್ತಾ ಧೈರ್ಯದಿಂದ ಹೋಗುತ್ತಿದ್ದರು. ಆದರೆ ಈಜಿಪ್ಟಿನ ಅರಸನಾದ ಫರೋಹನ ಹೃದಯವನ್ನು ಯೆಹೋವನು ಕಠಿಣಗೊಳಿಸಿದ್ದರಿಂದ ಅವನು ಇಸ್ರೇಲರನ್ನು ಬೆನ್ನಟ್ಟಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ಈಜಿಪ್ಟಿನ ಸೈನ್ಯದಲ್ಲಿ ಅನೇಕ ರಾಹುತರು ಇದ್ದರು; ರಥಗಳೂ ಇದ್ದವು. ಅವರು ಇಸ್ರೇಲರನ್ನು ಬೆನ್ನಟ್ಟಿದರು. ಇಸ್ರೇಲರು ಪೀಹಹೀರೋತಿನ ಹತ್ತಿರವಿರುವ ಬಾಳ್ಚೆಫೋನಿನ ಎದುರಾಗಿ ಸಮುದ್ರತೀರದಲ್ಲಿ ಇಳಿದುಕೊಳ್ಳುವಾಗಲೇ ಈಜಿಪ್ಟಿನ ಸೈನ್ಯದವರು ಅವರ ಹತ್ತಿರಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ಫರೋಹನೂ ಅವನ ಸೈನ್ಯವೂ ತಮ್ಮ ಕಡೆಗೆ ಬರುತ್ತಿರುವುದನ್ನು ಇಸ್ರೇಲರು ಕಂಡು ಬಹಳ ಭಯಪಟ್ಟರು. ಅವರು ಸಹಾಯಕ್ಕಾಗಿ ಯೆಹೋವನಿಗೆ ಮೊರೆಯಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ಅವರು ಮೋಶೆಗೆ, “ನೀನು ಯಾಕೆ ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದೆ? ನಮ್ಮನ್ನು ಅರಣ್ಯದಲ್ಲಿ ಸಾಯಿಸುವುದಕ್ಕೆ ನೀನು ನಮ್ಮನ್ನು ಕರೆದುಕೊಂಡು ಬಂದೆಯಾ? ನಾವು ಈಜಿಪ್ಟಿನಲ್ಲಿಯೇ ಸಮಾಧಾನದಿಂದ ಸಾಯಬಹುದಾಗಿತ್ತಲ್ಲವೆ? ಈಜಿಪ್ಟಿನಲ್ಲಿ ಸಾಕಷ್ಟು ಸಮಾಧಿಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ನಾವು ನಿನಗೆ ಈಜಿಪ್ಟಿನಲ್ಲೇ, ‘ದಯಮಾಡಿ ನಮ್ಮ ಗೊಡವೆಗೆ ಬರಬೇಡ. ನಾವು ಇಲ್ಲಿದ್ದುಕೊಂಡು ಈಜಿಪ್ಟಿನವರ ಸೇವೆಮಾಡಲು ಬಿಡು’ ಎಂದು ಹೇಳಿದ್ದೆವು. ನಾವು ಇಲ್ಲಿಗೆ ಬಂದು ಅರಣ್ಯದಲ್ಲಿ ಸಾಯುವುದಕ್ಕಿಂತ, ಅಲ್ಲೇ ಗುಲಾಮರಾಗಿ ಇದ್ದಿದ್ದರೆ ಒಳ್ಳೆಯದಾಗಿರುತ್ತಿತ್ತು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ಆದರೆ ಮೋಶೆ ಆ ಜನರಿಗೆ, “ಭಯಪಡಬೇಡಿರಿ! ಓಡಿಹೋಗಬೇಡಿರಿ! ಇಲ್ಲೇ ಇದ್ದು ಯೆಹೋವನು ಈ ದಿನ ನಿಮ್ಮನ್ನು ರಕ್ಷಿಸುವುದನ್ನು ನೋಡಿರಿ. ಈ ದಿನದ ನಂತರ ನೀವು ಇನ್ನೆಂದಿಗೂ ಈ ಈಜಿಪ್ಟಿನವರನ್ನು ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ಯೆಹೋವನು ನಿಮಗೋಸ್ಕರ ಯುದ್ಧಮಾಡುವನು. ಆದ್ದರಿಂದ ನೀವು ಸುಮ್ಮನೆ ಇರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ನನಗೆ ಮೊರೆಯಿಡುತ್ತಿರುವುದೇಕೆ? ಇಸ್ರೇಲರಿಗೆ ಮುಂದೆ ಹೋಗಲು ಆಜ್ಞಾಪಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ನಿನ್ನ ಕೈಯಲ್ಲಿರುವ ಊರುಗೋಲನ್ನು ಕೆಂಪುಸಮುದ್ರದ ಮೇಲೆ ಚಾಚು. ಆಗ ಸಮುದ್ರವು ಇಬ್ಭಾಗವಾಗುವುದು. ಜನರು ಒಣನೆಲದ ಮೇಲೆ ಸಮುದ್ರವನ್ನು ದಾಟಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ಈಜಿಪ್ಟಿನವರು ನಿಮ್ಮನ್ನು ಬೆನ್ನಟ್ಟುವಂತೆ ನಾನು ಅವರ ಹೃದಯಗಳನ್ನು ಕಠಿಣಗೊಳಿಸುವುದರಿಂದ ನಾನು ಫರೋಹನಿಗಿಂತಲೂ ಅವನ ಎಲ್ಲಾ ರಾಹುತರುಗಳಿಗಿಂತಲೂ ರಥಗಳಿಗಿಂತಲೂ ಶಕ್ತಿಶಾಲಿ ಎಂಬುದನ್ನು ನಿಮಗೆ ತೋರಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ಆಗ ನಾನೇ ಯೆಹೋವನೆಂದು ಈಜಿಪ್ಟಿಗೆ ತಿಳಿಯುವುದು. ನಾನು ಫರೋಹನನ್ನೂ ಅವನ ರಾಹುತರನ್ನೂ ರಥಗಳನ್ನೂ ಸೋಲಿಸಿದಾಗ ಅವರು ನನ್ನನ್ನು ಸನ್ಮಾನಿಸುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ಆ ಸಮಯದಲ್ಲಿ ಯೆಹೋವನ ದೂತನು ತನ್ನ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಅವರ ಹಿಂದಕ್ಕೆ ಬಂದನು. ಆದ್ದರಿಂದ ಅವರ ಮುಂಭಾಗದಲ್ಲಿದ್ದ ಮೇಘಸ್ತಂಭವು ಅವರ ಹಿಂಭಾಗಕ್ಕೆ ಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ಹೀಗೆ ಮೋಡವು ಈಜಿಪ್ಟಿನವರಿಗೂ ಇಸ್ರೇಲರಿಗೂ ನಡುವೆ ನಿಂತಿತು. ಅಲ್ಲಿ ಇಸ್ರೇಲರಿಗೆ ಬೆಳಕಿತ್ತು. ಆದರೆ ಈಜಿಪ್ಟಿನವರಿಗೆ ಕತ್ತಲಿತ್ತು. ಆದ್ದರಿಂದ ಈಜಿಪ್ಟಿನವರು ಆ ರಾತ್ರಿ ಇಸ್ರೇಲರ ಸಮೀಪಕ್ಕೆ ಬರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ಮೋಶೆಯು ತನ್ನ ಕೈಯನ್ನು ಕೆಂಪುಸಮುದ್ರದ ಮೇಲೆ ಚಾಚಿದನು; ಆಗ ಯೆಹೋವನು ಪೂರ್ವದಿಂದ ಬಲವಾದ ಗಾಳಿಯನ್ನು ಬೀಸುವಂತೆ ಮಾಡಿದನು. ಗಾಳಿಯು ರಾತ್ರಿಯೆಲ್ಲಾ ಬೀಸಿತು. ಸಮುದ್ರವು ಇಬ್ಭಾಗವಾಗಿ ಮಧ್ಯದಲ್ಲಿ ಒಣನೆಲವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ಇಸ್ರೇಲರು ಒಣನೆಲದ ಮೇಲೆ ಸಮುದ್ರವನ್ನು ದಾಟಿದರು. ನೀರು ಅವರ ಎಡಬಲಗಳಲ್ಲಿ ಗೋಡೆಯಂತೆ ನಿಂತಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ಆಗ ಫರೋಹನು ತನ್ನ ಎಲ್ಲಾ ರಥಗಳೊಡನೆ ಮತ್ತು ರಾಹುತರೊಡನೆ ಅವರನ್ನು ಹಿಂಬಾಲಿಸಿ ಸಮುದ್ರದೊಳಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ಬೆಳಗಿನ ಜಾವ ಇನ್ನೂ ಮೊಬ್ಬಿರುವಾಗ, ಯೆಹೋವನು ಎತ್ತರವಾದ ಮೇಘಸ್ತಂಭದಿಂದ ಮತ್ತು ಅಗ್ನಿಸ್ತಂಭದಿಂದ ಈಜಿಪ್ಟಿನ ಸೈನ್ಯವನ್ನು ದೃಷ್ಟಿಸಿದನು. ಆಗ ಯೆಹೋವನು ಅವರ ಮೇಲೆ ಧಾಳಿಮಾಡಿ ಅವರ ಪಾಳೆಯದಲ್ಲಿ ಗಲಿಬಿಲಿಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ರಥಗಳ ಚಕ್ರಗಳು ನೆಲಕ್ಕೆ ಅಂಟಿಕೊಂಡವು. ರಥಗಳನ್ನು ನಡಿಸುವುದು ಬಹುಕಷ್ಟವಾಗಿತ್ತು. ಈಜಿಪ್ಟಿನವರು “ನಾವು ಇಲ್ಲಿಂದ ಹೋಗೋಣ. ಯೆಹೋವನು ಈಜಿಪ್ಟಿನ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧಮಾಡುತ್ತಿದ್ದಾನೆ. ಯೆಹೋವನು ಇಸ್ರೇಲರಿಗಾಗಿ ಯುದ್ಧ ಮಾಡುತ್ತಿದ್ದಾನೆ” ಎಂದು ಕೂಗಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಿನ್ನ ಕೈಯನ್ನು ಸಮುದ್ರದ ಮೇಲೆ ಚಾಚು; ನೀರು ಈಜಿಪ್ಟಿನವರ ರಥಗಳನ್ನು ಮತ್ತು ರಾಹುತರನ್ನು ಮುಚ್ಚಿಕೊಳ್ಳುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ಆದ್ದರಿಂದ ಹಗಲಿನ ಬೆಳಕು ಪ್ರಕಾಶಿಸುವುದಕ್ಕಿಂತ ಸ್ವಲ್ಪ ಮೊದಲು, ಮೋಶೆಯು ತನ್ನ ಕೈಯನ್ನು ಸಮುದ್ರದ ಮೇಲೆ ಚಾಚಿದನು. ನೀರು ತನ್ನ ಸರಿಯಾದ ಮಟ್ಟಕ್ಕೆ ಹಿಂತಿರುಗಿತು. ಈಜಿಪ್ಟಿನವರು ನೀರಿನಿಂದ ಓಡಿಹೋಗಲು ಬಹಳವಾಗಿ ಪ್ರಯತ್ನಿಸಿದರು. ಆದರೆ ಯೆಹೋವನು ಈಜಿಪ್ಟಿನವರನ್ನು ಸಮುದ್ರದಲ್ಲಿ ಕೆಡವಿಬಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ನೀರು ತನ್ನ ಸರಿಯಾದ ಮಟ್ಟಕ್ಕೆ ಹಿಂತಿರುಗಿ ರಥಗಳನ್ನು ಮತ್ತು ರಾಹುತರನ್ನು ಮುಚ್ಚಿಬಿಟ್ಟಿತು. ಸಮುದ್ರದೊಳಗೆ ಹೋಗಿದ್ದ ಇಸ್ರೇಲರನ್ನು ಬೆನ್ನಟ್ಟಿದ ಫರೋಹನ ಸೈನ್ಯವೆಲ್ಲಾ ನಾಶವಾಯಿತು. ಅವರಲ್ಲಿ ಒಬ್ಬರಾದರೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ಆದರೆ ಇಸ್ರೇಲರು ಒಣನೆಲದಲ್ಲಿ ಸಮುದ್ರವನ್ನು ದಾಟಿದರು. ನೀರು ಅವರ ಎಡಬಲಗಳಲ್ಲಿ ಗೋಡೆಯಂತೆ ನಿಂತಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ಆದ್ದರಿಂದ ಆ ದಿನ ಯೆಹೋವನು ಇಸ್ರೇಲರನ್ನು ಈಜಿಪ್ಟಿನವರಿಂದ ರಕ್ಷಿಸಿದನು. ಇಸ್ರೇಲರು ಕೆಂಪುಸಮುದ್ರದ ದಡದಲ್ಲಿ ಬಿದ್ದಿದ್ದ ಈಜಿಪ್ಟಿನವರ ಹೆಣಗಳನ್ನು ನೋಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ಈಜಿಪ್ಟಿನವರನ್ನು ಯೆಹೋವನು ಸೋಲಿಸಿದಾಗ ಇಸ್ರೇಲರು ಆತನ ಮಹಾಶಕ್ತಿಯನ್ನು ನೋಡಿದರು. ಆದ್ದರಿಂದ ಜನರು ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸಿ ಆತನ ಸೇವಕನಾದ ಮೋಶೆಯಲ್ಲಿ ಭರವಸವಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ಬಳಿಕ ಮೋಶೆ ಮತ್ತು ಇಸ್ರೇಲರು ಯೆಹೋವನಿಗೆ ಈ ಗೀತೆಯನ್ನು ಹಾಡತೊಡಗಿದರು: “ನಾನು ಯೆಹೋವನಿಗೆ ಹಾಡುವೆನು. ಆತನು ಮಹಾಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದ್ದಾನೆ. ಆತನು ಕುದುರೆಯನ್ನೂ ಸವಾರನನ್ನೂ ಸಮುದ್ರದೊಳಗೆ ಮುಳುಗಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ಯೆಹೋವನೇ ನನ್ನ ಬಲ, ಆತನು ನನ್ನನ್ನು ರಕ್ಷಿಸುತ್ತಾನೆ. ನನ್ನ ಬಲವೂ ಕೀರ್ತನೆಯೂ ಯಾಹುವೇ; ಆತನಿಂದ ನಮಗೆ ರಕ್ಷಣೆ ಉಂಟಾಯಿತು. ಯೆಹೋವನು ನನ್ನ ದೇವರು. ಮತ್ತು ನಾನು ಆತನನ್ನು ಸ್ತುತಿಸುತ್ತೇನೆ. ಯೆಹೋವನೇ ನಮ್ಮ ಪೂರ್ವಿಕರ ದೇವರು. ನಾನು ಆತನನ್ನು ಸನ್ಮಾನಿಸುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ಯೆಹೋವನೇ ಯುದ್ಧವೀರನು. ಆತನ ನಾಮಧೇಯವು ಯೆಹೋವನೇ. ");
INSERT INTO kan2010_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ಆತನು ಫರೋಹನ ರಥಗಳನ್ನೂ ಸೈನಿಕರನ್ನೂ ಸಮುದ್ರದೊಳಗೆ ಕೆಡವಿದನು; ಫರೋಹನ ಮಹಾವೀರರನ್ನು ಕೆಂಪು ಸಮುದ್ರದಲ್ಲಿ ಮುಳುಗಿಸಿಬಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ಸಾಗರವು ಅವರನ್ನು ಮುಚ್ಚಿಕೊಂಡಿತು; ಆಳವಾದ ನೀರಿನಲ್ಲಿ ಅವರು ಬಂಡೆಗಳಂತೆ ಮುಳುಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“ನಿನ್ನ ಭುಜಬಲವು ಎಷ್ಟೋ ಶಕ್ತಿಯುಳ್ಳದ್ದಾಗಿದೆ. ಯೆಹೋವನೇ, ನಿನ್ನ ಭುಜಬಲವು ವೈರಿಯನ್ನು ನುಚ್ಚುನೂರು ಮಾಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ನೀನು ಅತ್ಯಧಿಕ ಮಹತ್ವವುಳ್ಳವನಾಗಿ, ನನಗೆದುರು ನಿಲ್ಲುವವರನ್ನು ನಾಶಗೊಳಿಸಿದೆ. ಬೆಂಕಿಯು ಹುಲ್ಲನ್ನು ಸುಡುವಂತೆ ನಿನ್ನ ಕೋಪವು ಅವರನ್ನು ನಾಶಮಾಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ನೀನು ಊದಿದ ಮಹಾಗಾಳಿಯಿಂದ ನೀರು ಒತ್ತಟ್ಟಿಗೆ ಸೇರಿತು. ವೇಗವಾಗಿ ಹರಿಯುವ ನೀರು ಗಟ್ಟಿಯಾದ ಗೋಡೆಯಾಯಿತು. ಸಾಗರಗರ್ಭದೊಳಗಿನ ಜಲವು ಗಟ್ಟಿಯಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“‘ನಾವು ಅವರನ್ನು ಬೆನ್ನಟ್ಟಿ ಹಿಡಿಯುವೆವು; ನಾವು ಅವರ ಸಂಪತ್ತನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಳ್ಳುವೆವು. ನಾವು ಖಡ್ಗದಿಂದ ಅವರನ್ನು ಸಂಹರಿಸುವೆವು. ನಮ್ಮ ಭುಜಬಲದಿಂದ ಅವರ ಸ್ವತ್ತುಗಳನ್ನೆಲ್ಲಾ ವಶಪಡಿಸಿಕೊಳ್ಳುವೆವು’ ಎಂದುಕೊಂಡರು ವೈರಿಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ಆದರೆ ನೀನು ಅವರ ಮೇಲೆ ಊದಿದ ಗಾಳಿಯಿಂದ ಸಮುದ್ರವು ಅವರನ್ನು ಮುಚ್ಚಿಕೊಂಡಿತು; ಅವರು ಸೀಸದಂತೆ ಅಗಾಧವಾದ ಸಮುದ್ರದಲ್ಲಿ ಮುಳುಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“ಯೆಹೋವನೇ, ದೇವರುಗಳಲ್ಲಿ ನಿನಗೆ ಸಮಾನರು ಯಾರು? ಪರಿಶುದ್ಧತೆಯಲ್ಲಿ ನೀನೇ ಸರ್ವೋತ್ತಮನು. ಭಯಂಕರ ಕಾರ್ಯಗಳನ್ನು ಮಾಡಿ ಪ್ರಖ್ಯಾತಿಹೊಂದಿದವನೂ ನೀನೇ. ಅದ್ಭುತಕಾರ್ಯಗಳನ್ನು ಮಾಡುವಾತನೂ ನೀನೇ. ");
INSERT INTO kan2010_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ನೀನು ನಿನ್ನ ಬಲಗೈಯನ್ನು ಚಾಚಿದಾಗ ಭೂಮಿಯು ಶತ್ರುಗಳನ್ನು ನುಂಗಿಬಿಟ್ಟಿತು! ");
INSERT INTO kan2010_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ನೀನು ಬಿಡುಗಡೆ ಮಾಡಿದ ನಿನ್ನ ಜನರನ್ನು ಪ್ರೀತಿಯಿಂದ ನಡೆಸುವೆ. ನಿನ್ನ ಬಲದಿಂದ ನೀನು ಈ ಜನರನ್ನು ನಿನ್ನ ಪವಿತ್ರವಾದ ದೇಶಕ್ಕೆ ನಡಿಸುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","“ಬೇರೆ ಜನಾಂಗಗಳವರು ಇದನ್ನು ಕೇಳಿ ಭಯಭೀತರಾಗುವರು; ಫಿಲಿಷ್ಟಿಯರು ಭಯದಿಂದ ತಲ್ಲಣಿಸುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ಆಗ ಎದೋಮಿನ ಕುಟುಂಬಗಳು ಭಯಭೀತರಾಗುವರು. ಮೋವಾಬಿನ ನಾಯಕರು ಭಯದಿಂದ ನಡುಗುವರು. ಕಾನಾನಿನ ಜನರು ತಮ್ಮ ಧೈರ್ಯವನ್ನು ಕಳೆದುಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ನಿನ್ನ ಭುಜಬಲವನ್ನು ಅವರು ಕಂಡು ಭಯಭೀತರಾಗುವರು. ಯೆಹೋವನ ಜನರು ದಾಟಿ ಹೋಗುವವರೆಗೆ, ನೀನು ರೂಪಿಸಿದ ಜನರು ದಾಟಿ ಹೋಗುವವರೆಗೆ, ಅವರು ಬಂಡೆಯಂತೆ ಮೌನವಾಗಿರುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ನೀನು ನಿನ್ನ ಜನರನ್ನು ನಿನ್ನ ಬೆಟ್ಟದ ಸೀಮೆಗೂ ನಿನ್ನ ಸಿಂಹಾಸನಕ್ಕಾಗಿ ನೀನು ಸಿದ್ಧಮಾಡಿದ ಸ್ಥಳಕ್ಕೂ ನಡಿಸುವೆ. ಯೆಹೋವನೇ, ಒಡೆಯನೇ, ನಿನ್ನ ಕೈಗಳಿಂದ ನಿನ್ನ ಆಲಯವನ್ನು ಕಟ್ಟು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“ಯೆಹೋವನು ಎಂದೆಂದಿಗೂ ಆಳುವನು!” ");
INSERT INTO kan2010_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ಫರೋಹನ ಕುದುರೆಗಳು, ಸವಾರರು, ರಥಗಳು ಸಮುದ್ರದೊಳಕ್ಕೆ ಹೋದಾಗ ಸಮುದ್ರದ ನೀರು ಅವರನ್ನು ಆವರಿಸಿಕೊಳ್ಳುವಂತೆ ಯೆಹೋವನು ಮಾಡಿದನು. ಇಸ್ರೇಲರಾದರೊ ಸಮುದ್ರದೊಳಗಿನ ಒಣನೆಲದಲ್ಲಿ ಸಮುದ್ರವನ್ನು ದಾಟಿಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ಆರೋನನ ಅಕ್ಕ ಮಿರ್ಯಾಮಳು ಪ್ರವಾದಿನಿಯಾಗಿದ್ದು ದಮ್ಮಡಿಯನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡಳು. ಮಿರ್ಯಾಮಳು ಮತ್ತು ಸ್ತ್ರೀಯರು ಹಾಡುವುದಕ್ಕೂ ಕುಣಿಯುವುದಕ್ಕೂ ಪ್ರಾರಂಭಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ಮಿರ್ಯಾಮಳು ಅವರ ಹಾಡಿಗೆ ಹೀಗೆ ಪಲ್ಲವಿ ಹಾಡಿದಳು: “ಯೆಹೋವನಿಗೆ ಗಾನಮಾಡಿರಿ; ಆತನು ಮಹಾಜಯಶಾಲಿಯಾದನು. ಕುದುರೆಗಳನ್ನೂ ರಾಹುತರನ್ನೂ ಸಮುದ್ರದೊಳಗೆ ಮುಳುಗಿಸಿ ನಾಶಮಾಡಿದನು…” ");
INSERT INTO kan2010_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ಮೋಶೆಯು ಇಸ್ರೇಲರನ್ನು ಕೆಂಪುಸಮುದ್ರದಿಂದ ಮುನ್ನಡೆಸಿದನು. ಅವರು ಶೂರಿನ ಅರಣ್ಯದೊಳಗೆ ಹೋದರು. ಅವರು ಅರಣ್ಯದಲ್ಲಿ ಮೂರು ದಿನಗಳವರೆಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಜನರಿಗೆ ಎಲ್ಲಿಯೂ ನೀರು ಸಿಕ್ಕಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ಆ ಬಳಿಕ ಅವರು ಮಾರಾ ಎಂಬ ಸ್ಥಳವನ್ನು ತಲುಪಿದರು. ಅಲ್ಲಿ ನೀರಿತ್ತು. ಆದರೆ ಅವರು ಆ ನೀರನ್ನು ಕುಡಿಯಲಾಗಲಿಲ್ಲ. ಯಾಕೆಂದರೆ ಅದು ಬಹು ಕಹಿಯಾಗಿತ್ತು. (ಆದಕಾರಣವೇ ಆ ಸ್ಥಳಕ್ಕೆ “ಮಾರಾ” ಎಂಬುದಾಗಿ ಹೆಸರು ಕೊಡಲ್ಪಟ್ಟಿತ್ತು.) ");
INSERT INTO kan2010_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ಅವರು ಮೋಶೆಗೆ ದೂರು ಹೇಳತೊಡಗಿದರು. “ಈಗ, ನಾವೇನು ಕುಡಿಯೋಣ?” ಎಂದು ಅವರು ಕೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಲು ಆತನು ಅವನಿಗೆ ಒಂದು ಗಿಡವನ್ನು ತೋರಿಸಿದನು. ಮೋಶೆಯು ಆ ಗಿಡವನ್ನು ನೀರಿನಲ್ಲಿ ಹಾಕಿದಾಗ ಕಹಿನೀರು ಸಿಹಿ ನೀರಾಯಿತು. ಆ ಸ್ಥಳದಲ್ಲಿ ಯೆಹೋವನು ಅವರಿಗಾಗಿ ನಿಯಮವನ್ನು ಮಾಡಿದನು. ಯೆಹೋವನು ಅವರ ನಂಬಿಕೆಯನ್ನು ಸಹ ಪರೀಕ್ಷಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ಆತನು ಅವರಿಗೆ, “ನೀವು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಮಾತನ್ನು ಶ್ರದ್ಧೆಯಿಂದ ಕೇಳಿ ಆತನ ದೃಷ್ಟಿಗೆ ಯೋಗ್ಯವಾದವುಗಳನ್ನು ಮಾಡಬೇಕು; ಆತನ ಆಜ್ಞೆಗಳಿಗೆ ವಿಧೇಯರಾಗಿದ್ದು ಆತನ ಕಟ್ಟಳೆಗಳನ್ನೆಲ್ಲಾ ಅನುಸರಿಸಬೇಕು. ಆಗ ನಾನು ಈಜಿಪ್ಟಿನವರಿಗೆ ಉಂಟುಮಾಡಿದ ಕಾಯಿಲೆಗಳಲ್ಲಿ ಒಂದನ್ನೂ ನಿಮಗೆ ಬರಗೊಡಿಸುವುದಿಲ್ಲ. ಯೆಹೋವನೆಂಬ ನಾನೇ ನಿಮಗೆ ಆರೋಗ್ಯದಾಯಕನಾಗಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ಬಳಿಕ ಜನರು ಏಲೀಮಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಏಲೀಮಿನಲ್ಲಿ ನೀರಿನ ಹನ್ನೆರಡು ಬುಗ್ಗೆಗಳಿದ್ದವು; ಅಲ್ಲಿ ಎಪ್ಪತ್ತು ಖರ್ಜೂರದ ಮರಗಳಿದ್ದವು. ಆದ್ದರಿಂದ ಅವರು ನೀರಿನ ಹತ್ತಿರ ತಮ್ಮ ಪಾಳೆಯ ಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ಬಳಿಕ ಅವರು ಏಲೀಮಿನಿಂದ ಪ್ರಯಾಣಮಾಡಿ ಸಿನ್ ಅರಣ್ಯಕ್ಕೆ ಬಂದರು. ಈ ಸ್ಥಳವು ಏಲೀಮಿನ ಮತ್ತು ಸೀನಾಯ್ ಬೆಟ್ಟದ ನಡುವೆ ಇತ್ತು. ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟ ನಂತರ ಎರಡನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ಅವರು ಈ ಸ್ಥಳಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ಆಗ ಇಸ್ರೇಲರು ಮತ್ತೆ ಮರುಭೂಮಿಯಲ್ಲಿ ಮೋಶೆ ಆರೋನರ ಮೇಲೆ ಗುಣುಗುಟ್ಟಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ಅವರು, “ಯೆಹೋವನು ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಕೊಂದಿದ್ದರೆ ಎಷ್ಟೋ ಒಳ್ಳೆಯದಾಗುತ್ತಿತ್ತು. ನಮಗೆ ಈಜಿಪ್ಟಿನಲ್ಲಿ ಮಾಂಸವೂ ರೊಟ್ಟಿಯೂ ಇತ್ತು. ನಮಗೆ ಬೇಕಿದ್ದ ಆಹಾರವೆಲ್ಲಾ ನಮ್ಮಲ್ಲಿತ್ತು. ಆದರೆ ಈಗ ನೀವು ನಮ್ಮನ್ನು ಈ ಅರಣ್ಯಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಂದಿರಿ. ನಾವೆಲ್ಲರೂ ಇಲ್ಲಿ ಹಸಿವೆಯಿಂದ ಸಾಯುವೆವು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಆಕಾಶದಿಂದ ನಿಮಗೋಸ್ಕರ ರೊಟ್ಟಿ ಸುರಿಯುವಂತೆ ಮಾಡುವೆನು. ಪ್ರತಿದಿನ ಅವರು ಹೊರಗೆ ಹೋಗಿ, ತಮಗೆ ಆ ದಿನದಲ್ಲಿ ತಿನ್ನಲು ಬೇಕಾದ ಆಹಾರವನ್ನು ಕೂಡಿಸಿಕೊಳ್ಳಬೇಕು. ನಾನು ಹೇಳುವುದನ್ನು ಅವರು ಮಾಡುತ್ತಾರೊ ಇಲ್ಲವೊ ಎಂದು ನೋಡಲು ನಾನು ಇದನ್ನು ಮಾಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ಪ್ರತಿದಿನವು ಅವರು ಒಂದು ದಿನಕ್ಕೆ ಬೇಕಾದಷ್ಟು ಆಹಾರವನ್ನು ಕೂಡಿಸಿಕೊಳ್ಳಬೇಕು. ಆದರೆ ಶುಕ್ರವಾರ ಅವರು ತಮ್ಮ ಆಹಾರವನ್ನು ಸಿದ್ಧಪಡಿಸುವಾಗ ಎರಡು ದಿನಗಳಿಗೆ ಬೇಕಾದಷ್ಟು ಆಹಾರವಿರುವುದನ್ನು ಅವರು ನೋಡುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ಆದ್ದರಿಂದ ಮೋಶೆಯು ಮತ್ತು ಆರೋನನು ಇಸ್ರೇಲರಿಗೆ, “ಈ ರಾತ್ರಿ ನೀವು ಯೆಹೋವನ ಶಕ್ತಿಯನ್ನು ನೋಡುವಿರಿ. ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ರಕ್ಷಿಸಿದವನು ಆತನೇ ಎಂದು ತಿಳಿದುಕೊಳ್ಳುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ನಾಳೆ ಬೆಳಿಗ್ಗೆ ನೀವು ಯೆಹೋವನ ಮಹಿಮೆಯನ್ನು ನೋಡುವಿರಿ. ನೀವು ಯೆಹೋವನ ಮೇಲೆ ಗುಣುಗುಟ್ಟಿದ್ದೀರಿ. ಆತನು ನಿಮ್ಮ ಗುಣುಗುಟ್ಟುವಿಕೆಯನ್ನು ಕೇಳಿದ್ದಾನೆ; ಆತನೇ ನಿಮಗೆ ಸಹಾಯ ಮಾಡುವನು. ನಮ್ಮ ಮೇಲೆ ನೀವು ಗುಣುಗುಟ್ಟುತ್ತಾ ಬರಲು ನಾವೆಷ್ಟರವರು? ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆತಂದವನು ಯೆಹೋವನೇ. ಆತನೇ ನಿಮ್ಮ ಅಗತ್ಯತೆಗಳನ್ನು ಪೂರೈಸುವನು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ಅಲ್ಲದೆ ಮೋಶೆಯು, “ನೀವು ಗುಣುಗುಟ್ಟುತ್ತಿರುವುದನ್ನು ಯೆಹೋವನು ಕೇಳಿದ್ದಾನೆ. ಆದ್ದರಿಂದ ರಾತ್ರಿಯಲ್ಲಿ ಆತನು ನಿಮಗೆ ಮಾಂಸವನ್ನು ಕೊಡುವನು. ಪ್ರತಿ ಮುಂಜಾನೆ ನಿಮಗೆ ಬೇಕಾದಷ್ಟು ರೊಟ್ಟಿಯು ದೊರಕುವುದು. ನೀವು (ಆರೋನನ ಮೇಲೂ ನನ್ನ ಮೇಲೂ) ಗುಣುಗುಟ್ಟುತ್ತಿದ್ದೀರಿ? ಆದರೆ ನಮಗೆ ದೂರು ಹೇಳಲು ನಾವೆಷ್ಟರವರು? ನೀವು ಯೆಹೋವನ ವಿರುದ್ಧವಾಗಿ ದೂರು ಹೇಳುತ್ತಿದ್ದೀರೆಂಬುದು ನಿಮ್ಮ ಜ್ಞಾಪಕದಲ್ಲಿರಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ಬಳಿಕ ಮೋಶೆ ಆರೋನನಿಗೆ, “ಇಸ್ರೇಲರೊಂದಿಗೆ ಮಾತಾಡು. ಅವರಿಗೆ, ‘ಯೆಹೋವನ ಮುಂದೆ ಒಟ್ಟಾಗಿ ನೆರೆದು ಬನ್ನಿ: ಯಾಕೆಂದರೆ ಆತನು ನಿಮ್ಮ ಗುಣುಗುಟ್ಟುವಿಕೆಗಳನ್ನು ಕೇಳಿದ್ದಾನೆ’ ಎಂದು ಹೇಳು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ಅರೋನನು ಇಸ್ರೇಲರೆಲ್ಲರೊಂದಿಗೆ ಮಾತಾಡಿದನು. ಅವರೆಲ್ಲರೂ ಒಂದು ಸ್ಥಳದಲ್ಲಿ ಕೂಡಿಬಂದರು. ಆರೋನನು ಅವರೊಂದಿಗೆ ಮಾತಾಡುತ್ತಿದ್ದಾಗ ಅವರೆಲ್ಲರೂ ಅರಣ್ಯದ ಕಡೆಗೆ ತಿರುಗಿನೋಡಿದರು. ಮೇಘದಲ್ಲಿ ಯೆಹೋವನ ಮಹಿಮೆಯು ಪ್ರತ್ಯಕ್ಷವಾದದ್ದನ್ನು ಅವರೆಲ್ಲರೂ ಕಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“ನಾನು ಇಸ್ರೇಲರ ಗುಣುಗುಟ್ಟುವಿಕೆಗಳನ್ನು ಕೇಳಿದ್ದೇನೆ. ಆದ್ದರಿಂದ ಅವರಿಗೆ ಹೀಗೆ ಹೇಳು: ‘ಸೂರ್ಯಾಸ್ತ್ತಮದ ಮುನ್ನ ನೀವು ಮಾಂಸವನ್ನು ತಿನ್ನುವಿರಿ; ಪ್ರತಿ ಮುಂಜಾನೆ ಸೂರ್ಯೋದಯದ ಮುನ್ನ ನಿಮಗೆ ಬೇಕಾದಷ್ಟು ರೊಟ್ಟಿಯನ್ನು ತಿನ್ನುವಿರಿ. ಆಗ ನಾನೇ ದೇವರಾದ ಯೆಹೋವನೆಂಬುದನ್ನು ನೀವು ತಿಳಿದುಕೊಳ್ಳುವಿರಿ; ನನ್ನಲ್ಲಿ ಭರವಸೆ ಇಡುವಿರಿ’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ಸಾಯಂಕಾಲ ಲಾವಕ್ಕಿಗಳು ಪಾಳೆಯದ ಸುತ್ತಲೂ ಬಂದವು. ಜನರು ಮಾಂಸಕ್ಕಾಗಿ ಈ ಪಕ್ಷಿಗಳನ್ನು ಹಿಡಿದರು ಮತ್ತು ಪ್ರತಿ ಮುಂಜಾನೆ ಅವರ ಪಾಳೆಯದ ಸುತ್ತಲೂ ಮಂಜು ನೆಲದ ಮೇಲೆ ಬಿದ್ದಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ಸೂರ್ಯನು ಮೇಲಕ್ಕೇರಿದ ನಂತರ ಮಂಜು ಕರಗಿ ಇಲ್ಲವಾಯಿತು. ಆದರೆ ಮಂಜು ಕರಗಿ ಹೋದನಂತರ ನೆಲದ ಮೇಲೆ ಮಂಜಿನ ಹನಿಗಳಂತಿದ್ದ ತೆಳುವಾದ ಕಾಳುಗಳು ಬಿದ್ದಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ಇಸ್ರೇಲರು ಅದನ್ನು ನೋಡಿ “ಏನದು” ಎಂಬುದಾಗಿ ಒಬ್ಬರನ್ನೊಬ್ಬರು ಕೇಳಿದರು. ಅದು ಏನೆಂದು ಅವರಿಗೆ ಗೊತ್ತಿಲ್ಲದ ಕಾರಣ ಅವರು ಈ ಪ್ರಶ್ನೆಯನ್ನು ಕೇಳಿದರು. ಆದ್ದರಿಂದ ಮೋಶೆ ಅವರಿಗೆ, “ಇದು ಯೆಹೋವನು ನಿಮಗೆ ಕೊಟ್ಟಿರುವ ಆಹಾರ. ");
INSERT INTO kan2010_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸುವುದೇನೆಂದರೆ, ‘ಪ್ರತಿಯೊಬ್ಬನು ತನಗೆ ಬೇಕಾದಷ್ಟನ್ನು ಮಾತ್ರ ಕೂಡಿಸಿಕೊಳ್ಳಬೇಕು. ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ನಿಮ್ಮ ಕುಟುಂಬದಲ್ಲಿರುವ ಪ್ರತಿಯೊಬ್ಬನಿಗೆ ಸುಮಾರು ಮೂರು ಸೇರಿನಷ್ಟು ಕೂಡಿಸಿಕೊಳ್ಳಬೇಕು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ಅಂತೆಯೇ ಇಸ್ರೇಲರು ಮಾಡಿದರು. ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ಆಹಾರವನ್ನು ಕೂಡಿಸಿಕೊಂಡನು. ಕೆಲವರು ಇತರರಿಗಿಂತ ಹೆಚ್ಚಾಗಿ ಕೂಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ಅವರು ತಮ್ಮ ಕುಟುಂಬದಲ್ಲಿದ್ದ ಪ್ರತಿಯೊಬ್ಬರ ಆಹಾರವನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿ ಅಳತೆಮಾಡಿದಾಗ ಅಲ್ಲಿ ಯಾವಾಗಲೂ ಪ್ರತಿಯೊಬ್ಬನಿಗೆ ಬೇಕಾದಷ್ಟು ಮಾತ್ರ ಆಹಾರವಿರುತ್ತಿತ್ತು. ಅದು ಹೆಚ್ಚಾಗಿಯೂ ಇರುತ್ತಿರಲಿಲ್ಲ; ಕಡಿಮೆಯಾಗಿಯೂ ಇರುತ್ತಿರಲಿಲ್ಲ. ಹೀಗೆ ಪ್ರತಿಯೊಬ್ಬನು ತನಗೆ ಮತ್ತು ತನ್ನ ಕುಟುಂಬಕ್ಕೆ ಬೇಕಾದಷ್ಟನ್ನು ಮಾತ್ರ ಕೂಡಿಸಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ಮೋಶೆಯು ಅವರಿಗೆ, “ಆಹಾರವನ್ನು ಮರುದಿನಕ್ಕಾಗಿ ಉಳಿಸಿಕೊಳ್ಳಬೇಡಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ಆದರೆ ಅವರು ಮೋಶೆಯ ಮಾತಿಗೆ ವಿಧೇಯರಾಗಲಿಲ್ಲ. ಕೆಲವು ಜನರು ಮರುದಿನ ತಿನ್ನುವುದಕ್ಕಾಗಿ ಆಹಾರವನ್ನು ಉಳಿಸಿಕೊಂಡರು; ಹೀಗೆ ಉಳಿಸಿಟ್ಟ ಆಹಾರವು ಹುಳಗಳಿಂದ ತುಂಬಿ ಕೊಳೆಯತೊಡಗಿತು. ಮೋಶೆಯು ಹೀಗೆ ಮಾಡಿದ ಜನರ ಮೇಲೆ ಕೋಪಗೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ಪ್ರತಿ ಮುಂಜಾನೆ ಅವರು ಆಹಾರವನ್ನು ಕೂಡಿಸಿಕೊಂಡರು. ಪ್ರತಿಯೊಬ್ಬನು ತಾನು ಎಷ್ಟು ತಿನ್ನಬಹುದೋ ಅಷ್ಟನ್ನೇ ಕೂಡಿಸಿಕೊಂಡನು. ಆದರೆ ಬಿಸಿಲೇರಿದಾಗ ಆಹಾರವು ಕರಗಿಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ಆರನೆಯ ದಿನವಾದ ಶುಕ್ರವಾರದಲ್ಲಿ ಜನರು ಎರಡರಷ್ಟನ್ನು ಕೂಡಿಸಿಕೊಂಡರು. ಅವರು ಪ್ರತಿಯೊಬ್ಬನಿಗೆ ಆರು ಸೇರಿನಷ್ಟು ಕೂಡಿಸಿಕೊಂಡರು. ಆದ್ದರಿಂದ ಜನನಾಯಕರೆಲ್ಲರೂ ಬಂದು ಮೋಶೆಗೆ ಇದನ್ನು ತಿಳಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ಮೋಶೆಯು ಅವರಿಗೆ, “ಯೆಹೋವನೇ ಇದರ ಬಗ್ಗೆ ತಿಳಿಸಿದ್ದನು. ನಾಳೆ ಮುಂಜಾನೆ ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸತಕ್ಕ ವಿಶೇಷ ವಿಶ್ರಾಂತಿ ದಿನವಾದ ಸಬ್ಬತ್ತಾಗಿದೆ. ಆದ್ದರಿಂದ ಇದು ಹೀಗೆ ಸಂಭವಿಸಿತು. ಈ ದಿನಕ್ಕೆ ಬೇಕಾದ ಅಡಿಗೆಯನ್ನು ನೀವು ತಯಾರಿಸಿಕೊಳ್ಳಿರಿ. ಆದರೆ ಈ ಆಹಾರದಲ್ಲಿ ಉಳಿದದ್ದನ್ನು ನಾಳೆ ಪ್ರಾತಃಕಾಲಕ್ಕಾಗಿ ಉಳಿಸಿಕೊಳ್ಳಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ಆದ್ದರಿಂದ ಉಳಿದ ಆಹಾರವನ್ನು ಜನರು ಮರುದಿನಕ್ಕಾಗಿ ಉಳಿಸಿದರು; ಆದರೆ ಆ ಆಹಾರವು ಕೆಡಲಿಲ್ಲ ಮತ್ತು ಹುಳಗಳು ಆ ಆಹಾರಕ್ಕೆ ಬರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ಶನಿವಾರದಲ್ಲಿ ಮೋಶೆಯು ಜನರಿಗೆ, “ಈ ದಿನ ಸಬ್ಬತ್ತಾಗಿದೆ. ಇದು ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸುವುದಕ್ಕಿರುವ ವಿಶೇಷವಾದ ವಿಶ್ರಾಂತಿ ದಿನವಾಗಿದೆ. ನೀವು ನಿನ್ನೆಯಿಂದ ಇಟ್ಟುಕೊಂಡಿದ್ದ ಆಹಾರವನ್ನು ಊಟಮಾಡಿರಿ. ಇಂದು ನೀವು ಹೊಲದಲ್ಲಿ ಯಾವ ಆಹಾರವನ್ನೂ ಕಾಣುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ನೀವು ಆರು ದಿನಗಳಲ್ಲಿ ಆಹಾರವನ್ನು ಕೂಡಿಸಬೇಕು. ಆದರೆ ವಾರದ ಏಳನೆಯ ದಿನವು ಸಬ್ಬತ್ ದಿನವಾಗಿದೆ, ಅಂದರೆ ವಿಶ್ರಾಂತಿಯ ದಿನವಾಗಿದೆ. ಆದ್ದರಿಂದ ಆ ದಿನದಲ್ಲಿ ನೆಲದ ಮೇಲೆ ಯಾವ ಆಹಾರವೂ ಇರುವುದಿಲ್ಲ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಕೆಲವು ಜನರು ಆಹಾರವನ್ನು ಕೂಡಿಸಿಕೊಳ್ಳಲು ಹೊರಗೆ ಹೋದರು. ಆದರೆ ಅವರಿಗೆ ಏನೂ ಸಿಕ್ಕಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಜನರೇ, ನೀವು ಇನ್ನೆಷ್ಟರವರೆಗೆ ನನ್ನ ಆಜ್ಞೆಗಳಿಗೆ ಮತ್ತು ಬೋಧನೆಗಳಿಗೆ ವಿಧೇಯರಾಗುವುದಿಲ್ಲ? ");
INSERT INTO kan2010_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ನೋಡಿರಿ, ಯೆಹೋವನು ಸಬ್ಬತ್ ದಿನವನ್ನು ನಿಮಗೆ ವಿಶ್ರಾಂತಿ ದಿನವನ್ನಾಗಿ ಮಾಡಿದ್ದಾನೆ. ಆದ್ದರಿಂದ ಯೆಹೋವನು ಶುಕ್ರವಾರದಂದು ನಿಮಗೆ ಎರಡು ದಿನಗಳಿಗೆ ಬೇಕಾದಷ್ಟು ಆಹಾರವನ್ನು ಕೊಡುವನು. ಆದ್ದರಿಂದ ಸಬ್ಬತ್ತಿನಲ್ಲಿ ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ಕುಳಿತುಕೊಂಡು ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಬೇಕು. ನೀವು ಇರುವಲ್ಲೇ ಇರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ಆದ್ದರಿಂದ ಜನರು ಸಬ್ಬತ್ತಿನಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ಜನರು ಈ ವಿಶೇಷ ಆಹಾರವನ್ನು ಮನ್ನ ಎಂದು ಕರೆಯತೊಡಗಿದರು. ಮನ್ನವು ಚಿಕ್ಕದಾದ ಬಿಳಿ ಕೊತ್ತಂಬರಿ ಬೀಜಗಳಂತಿದ್ದವು ಮತ್ತು ಜೇನುತುಪ್ಪದಿಂದ ಮಾಡಿದ ತೆಳುವಾದ ರೊಟ್ಟಿಯಂತೆ ರುಚಿಯಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ಮೋಶೆಯು, “ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ, ‘ಮೂರು ಸೇರಿನಷ್ಟು ಮನ್ನವನ್ನು ನಿಮ್ಮ ಮುಂದಿನ ಸಂತತಿಯವರಿಗಾಗಿ ಉಳಿಸಿರಿ. ನಾನು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ನಡೆಸಿದಾಗ ಅರಣ್ಯದಲ್ಲಿ ನಾನು ನಿಮಗೆ ಕೊಟ್ಟ ಈ ಆಹಾರವನ್ನು ನೋಡುವರು’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ಆದ್ದರಿಂದ ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ಒಂದು ಭರಣಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಅದರಲ್ಲಿ ಮೂರು ಸೇರಿನಷ್ಟು ಮನ್ನವನ್ನು ತುಂಬಿಸು. ನಿಮ್ಮ ಮುಂದಿನ ಸಂತತಿಯವರು ನೋಡುವುದಕೋಸ್ಕರ ಇದನ್ನು ಉಳಿಸಿ ಯೆಹೋವನ ಮುಂದೆ ಇಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","(ನಂತರ ಆರೋನನು, ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಮಾಡಿದನು. ಆರೋನನು ಮನ್ನದ ಭರಣಿಯನ್ನು ಒಡಂಬಡಿಕೆಯ ಮುಂದುಗಡೆಯಲ್ಲಿ ಇಟ್ಟನು.) ");
INSERT INTO kan2010_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ನಲವತ್ತು ವರ್ಷಗಳವರೆಗೆ ಜನರು ಮನ್ನವನ್ನು ತಿಂದರು. ಅವರು ವಿಶ್ರಾಂತಿಯ ದೇಶಕ್ಕೆ ಬರುವ ತನಕ, ಅಂದರೆ ಕಾನಾನಿನ ಗಡಿಗೆ ಬರುವವರೆಗೆ ಮನ್ನವನ್ನು ತಿಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(ಅವರು ಮನ್ನವನ್ನು ಅಳೆಯುವುದಕ್ಕೆ ಗೋಮೆರ್ ಎಂಬ ಅಳತೆಯನ್ನು ಉಪಯೋಗಿಸಿದರು.) ");
INSERT INTO kan2010_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ಇಸ್ರೇಲರೆಲ್ಲರೂ ಸಿನ್ ಮರುಭೂಮಿಯಿಂದ ಒಟ್ಟಾಗಿ ಪ್ರಯಾಣಮಾಡಿದರು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಲ್ಲಾ ಅವರು ಸ್ಥಳದಿಂದ ಸ್ಥಳಕ್ಕೆ ಪ್ರಯಾಣಮಾಡಿದರು. ಅವರು ರೆಫೀದೀಮಿಗೆ ಪ್ರಯಾಣಮಾಡಿ ಅಲ್ಲಿ ತಂಗಿದರು. ಅವರಿಗೆ ಕುಡಿಯಲು ಅಲ್ಲಿ ನೀರಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ಆದ್ದರಿಂದ ಅವರು ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ದಂಗೆ ಎದ್ದು ಅವನೊಡನೆ ವಾಗ್ವಾದ ಮಾಡತೊಡಗಿದರು. “ನಮಗೆ ಕುಡಿಯಲು ನೀರು ಕೊಡು” ಎಂದು ಅವರು ಕೇಳಿದರು. ಮೋಶೆ ಅವರಿಗೆ, “ನೀವು ಯಾಕೆ ನನಗೆ ವಿರುದ್ಧವಾಗಿ ದಂಗೆಯೆದ್ದಿರಿ? ನೀವು ಯಾಕೆ ಯೆಹೋವನನ್ನು ಪರೀಕ್ಷಿಸುತ್ತಿದ್ದೀರಿ? ಯೆಹೋವನು ನಮ್ಮೊಡನೆ ಇಲ್ಲವೆಂದು ನೀವು ಭಾವಿಸುತ್ತೀರೋ?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ಆದರೆ ಜನರು ನೀರಿಲ್ಲದೆ ಬಹಳ ಬಾಯಾರಿಕೆಗೆ ಒಳಗಾಗಿದ್ದರು. ಆದ್ದರಿಂದ ಅವರು ಮೋಶೆಯ ಮೇಲೆ ಗುಣುಗುಟ್ಟುತ್ತಿದ್ದರು. “ನೀನು ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದದ್ದೇಕೆ? ನಾವು, ನಮ್ಮ ಮಕ್ಕಳು ಮತ್ತು ನಮ್ಮ ದನಕರುಗಳೆಲ್ಲಾ ನೀರಿಲ್ಲದೆ ಸಾಯುವುದಕ್ಕೆ ನೀನು ನಮ್ಮನ್ನು ಇಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದೆಯಾ?” ಎಂದು ಅವರು ಕೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ಆದ್ದರಿಂದ ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ ಮೊರೆಯಿಟ್ಟು, “ಈ ಜನರ ವಿಷಯದಲ್ಲಿ ನಾನೇನು ಮಾಡಲಿ? ಅವರು ಕಲ್ಲೆಸೆದು ನನ್ನನ್ನು ಕೊಲ್ಲುವುದಕ್ಕೆ ಸಿದ್ಧವಾಗಿದ್ದಾರೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಇಸ್ರೇಲ್ ಜನರ ಮುಂದೆ ಹೋಗು. ನಿನ್ನೊಡನೆ ಜನರ ಕೆಲವು ಹಿರಿಯರನ್ನು ಕರೆದುಕೊ. ನಿನ್ನ ಊರುಗೋಲನ್ನು ಹಿಡಿದುಕೊಂಡು ಹೋಗು. ನೀನು ನೈಲ್ ನದಿಯನ್ನು ಹೊಡೆಯಲು ಉಪಯೋಗಿಸಿದ ಕೋಲು ಇದಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ಹೋರೇಬಿನಲ್ಲಿ ನಾನು ನಿನ್ನ ಮುಂದೆ ಒಂದು ಬಂಡೆಯ ಮೇಲೆ ನಿಲ್ಲುವೆನು. ಊರುಗೋಲಿನಿಂದ ಆ ಬಂಡೆಯನ್ನು ಹೊಡೆ; ಆಗ ನೀರು ಅದರೊಳಗಿಂದ ಬರುವುದು. ಆಗ ಜನರು ಕುಡಿಯಬಹುದು” ಎಂದು ಹೇಳಿದನು. ಅಂತೆಯೇ ಮೋಶೆ ಮಾಡಿದನು. ಇಸ್ರೇಲರ ಹಿರಿಯರು ಇದನ್ನು ನೋಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ಮೋಶೆ ಆ ಸ್ಥಳಕ್ಕೆ ಮಸ್ಸಾ ಮತ್ತು ಮೆರೀಬಾ ಎಂದು ಹೆಸರಿಟ್ಟನು. ಯಾಕೆಂದರೆ ಈ ಸ್ಥಳದಲ್ಲಿ ಇಸ್ರೇಲರು ಅವನಿಗೆ ವಿರುದ್ಧವಾಗಿ ದಂಗೆ ಎದ್ದು ಯೆಹೋವನನ್ನು ಪರೀಕ್ಷಿಸಿದರು. ಯೆಹೋವನು ಅವರೊಡನೆ ಇದ್ದಾನೋ ಇಲ್ಲವೋ ಎಂದು ಜನರು ತಿಳಿಯಬಯಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ರೆಫೀದೀಮಿನಲ್ಲಿ ಅಮಾಲೇಕ್ಯರು ಬಂದು ಇಸ್ರೇಲರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ಆದ್ದರಿಂದ ಮೋಶೆ ಯೆಹೋಶುವನಿಗೆ, “ಕೆಲವು ಪುರುಷರನ್ನು ಆರಿಸಿಕೊಂಡು, ನಾಳೆ ಅಮಾಲೇಕ್ಯರೊಡನೆ ಯುದ್ಧಮಾಡು. ನಾನು ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿ ನಿಂತು ಗಮನಿಸುವೆನು, ದೇವರು ನನಗೆ ಕೊಟ್ಟ ಊರುಗೋಲನ್ನು ನಾನು ಹಿಡಿದುಕೊಂಡಿರುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ಯೆಹೋಶುವನು ಮೋಶೆಯ ಮಾತಿಗೆ ವಿಧೇಯನಾಗಿ ಮರುದಿನ ಅಮಾಲೇಕ್ಯರೊಡನೆ ಯುದ್ಧಮಾಡಲು ಹೋದನು. ಅದೇ ಸಮಯದಲ್ಲಿ ಮೋಶೆಯೂ ಆರೋನನೂ ಹೂರನೂ ಬೆಟ್ಟದ ತುದಿಗೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ಮೋಶೆ ತನ್ನ ಕೈಗಳನ್ನು ಮೇಲೆತ್ತಿದಾಗ ಇಸ್ರೇಲರು ಜಯಗಳಿಸಿದರು. ಆದರೆ ಮೋಶೆಯು ತನ್ನ ಕೈಗಳನ್ನು ಕೆಳಗಿಳಿಸಿದಾಗ ಅಮಾಲೇಕ್ಯರು ಜಯಗಳಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ಸ್ವಲ್ಪ ಸಮಯದ ನಂತರ ಮೋಶೆಯ ತೋಳುಗಳು ಆಯಾಸಗೊಂಡವು. ಆದ್ದರಿಂದ ಅವರು ಒಂದು ದೊಡ್ಡಕಲ್ಲನ್ನು ಇಟ್ಟು ಮೋಶೆಯನ್ನು ಅದರ ಮೇಲೆ ಕುಳ್ಳಿರಿಸಿದರು. ಬಳಿಕ ಆರೋನನು ಮತ್ತು ಹೂರನು ಮೋಶೆಯ ಕೈಗಳನ್ನು ಮೇಲೆತ್ತಿ ಹಿಡಿದುಕೊಂಡರು. ಆರೋನನು ಮೋಶೆಯ ಒಂದು ಕಡೆಯಲ್ಲಿದ್ದನು; ಹೂರನು ಮೋಶೆಯ ಇನ್ನೊಂದು ಕಡೆಯಲ್ಲಿದ್ದನು. ಸೂರ್ಯನು ಮುಳುಗುವವರೆಗೆ ಅವರು ಅವನ ಕೈಗಳನ್ನು ಮೇಲೆತ್ತಿ ಹಿಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ಆದ್ದರಿಂದ ಯೆಹೋಶುವನು ಮತ್ತು ಅವನ ಸೈನಿಕರು ಅಮಾಲೇಕ್ಯರನ್ನು ಯುದ್ಧದಲ್ಲಿ ಸೋಲಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಈ ಯುದ್ಧದ ಕುರಿತು ಬರೆ: ಜನರು ಇಲ್ಲಿ ನಡೆದದ್ದನ್ನು ಜ್ಞಾಪಿಸಿಕೊಳ್ಳುವಂತೆ ಈ ಸಂಗತಿಗಳನ್ನು ಒಂದು ಪುಸ್ತಕದಲ್ಲಿ ಬರೆದಿಡು. ನಾನು ಅಮಾಲೇಕ್ಯರನ್ನು ಭೂಮಿಯ ಮೇಲಿಂದ ಸಂಪೂರ್ಣವಾಗಿ ನಾಶಮಾಡುವೆನೆಂದು ಯೆಹೋಶುವನಿಗೆ ಹೇಳಲು ಮರೆಯಬೇಡ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ಆಗ ಮೋಶೆಯು ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿದನು. ಮೋಶೆಯು ಯಜ್ಞವೇದಿಕೆಗೆ, “ಯೆಹೋವನು ನನ್ನ ಧ್ವಜ” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ಮೋಶೆ, “ನಾನು ನನ್ನ ಕೈಗಳನ್ನು ಯೆಹೋವನ ಸಿಂಹಾಸನದ ಕಡೆಗೆ ಎತ್ತಿದೆನು. ಆದ್ದರಿಂದ ಯೆಹೋವನು ಎಂದಿನಂತೆ ಅಮಾಲೇಕ್ಯರ ವಿರುದ್ಧವಾಗಿ ಯುದ್ಧಮಾಡಿದನು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ಮೋಶೆಯ ಮಾವನಾದ ಇತ್ರೋನನು ಮಿದ್ಯಾನಿನಲ್ಲಿ ಯಾಜಕನಾಗಿದ್ದನು. ಮೋಶೆಗೆ ಮತ್ತು ಇಸ್ರೇಲರಿಗೆ ದೇವರು ಅನೇಕ ರೀತಿಗಳಲ್ಲಿ ಸಹಾಯ ಮಾಡಿದ್ದರ ಬಗ್ಗೆ, ಯೆಹೋವನು ಇಸ್ರೇಲರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ನಡಿಸಿದ್ದರ ಬಗ್ಗೆ ಇತ್ರೋನನು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ಆದ್ದರಿಂದ ಅವನು ಮೋಶೆಯ ಹೆಂಡತಿಯಾದ ಚಿಪ್ಪೋರಳನ್ನು ಕರೆದುಕೊಂಡು ಬಂದನು. (ಚಿಪ್ಪೋರಳನ್ನು ಮೋಶೆಯು ಮನೆಗೆ ಕಳುಹಿಸಿದ್ದರಿಂದ ಆಕೆಯು ಮೋಶೆಯ ಸಂಗಡ ಇರಲಿಲ್ಲ.) ");
INSERT INTO kan2010_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ಇತ್ರೋನನು ಮೋಶೆಯ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳನ್ನೂ ಕರೆದುಕೊಂಡು ಬಂದನು. ಮೊದಲಿನ ಮಗನ ಹೆಸರು ಗೇರ್ಷೋಮ್. ಅವನು ಹುಟ್ಟಿದಾಗ ಮೋಶೆಯು, “ನಾನು ಪರದೇಶದಲ್ಲಿ ಅಪರಿಚಿತನಾಗಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿ ಆ ಹೆಸರನ್ನು ಇಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ಇನ್ನೊಬ್ಬ ಮಗನ ಹೆಸರು ಎಲೀಯೆಜೆರ್. ಇವನು ಹುಟ್ಟಿದಾಗ ಮೋಶೆಯು, “ನನ್ನ ತಂದೆಯ ದೇವರು ನನಗೆ ಸಹಾಯ ಮಾಡಿ ಈಜಿಪ್ಟಿನ ಅರಸನಿಂದ ರಕ್ಷಿಸಿದನು” ಎಂದು ಹೇಳಿ ಆ ಹೆಸರನ್ನು ಇಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ಆದ್ದರಿಂದ ಮೋಶೆಯು ಮರುಭೂಮಿಯಲ್ಲಿ ದೇವರ ಬೆಟ್ಟವಾದ ಸೀನಾಯ್ ಬೆಟ್ಟದ ಬಳಿ ತಂಗಿದ್ದಾಗ ಇತ್ರೋನನು ಮೋಶೆಯ ಬಳಿಗೆ ಹೋದನು. ಇತ್ರೋನನ ಜೊತೆಯಲ್ಲಿ ಮೋಶೆಯ ಹೆಂಡತಿ ಮತ್ತು ಅವನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳು ಇದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ಇತ್ರೋನನು ಮೋಶೆಗೆ, “ನಾನು ನಿನ್ನ ಮಾವನಾದ ಇತ್ರೋನ. ನಾನು ನಿನ್ನ ಹೆಂಡತಿಯನ್ನು ಮತ್ತು ಆಕೆಯ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳನ್ನು ನಿನ್ನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರುತ್ತಿದ್ದೇನೆ” ಎಂಬ ಸಂದೇಶವನ್ನು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ಆದ್ದರಿಂದ ಮೋಶೆ ತನ್ನ ಮಾವನನ್ನು ಭೇಟಿಯಾಗಲು ಹೊರಗೆ ಹೋದನು. ಮೋಶೆ ಅವನ ಮುಂದೆ ತಲೆಬಾಗಿ ಅವನಿಗೆ ಮುದ್ದಿಟ್ಟನು. ಅವರಿಬ್ಬರು ಪರಸ್ಪರ ಕ್ಷೇಮ ಸಮಾಚಾರವನ್ನು ವಿಚಾರಿಸಿಕೊಂಡರು. ಬಳಿಕ ಅವರು ಹೆಚ್ಚು ಮಾತಾಡಲು ಮೋಶೆಯ ಡೇರೆಯೊಳಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ಯೆಹೋವನು ಇಸ್ರೇಲರಿಗೆ ಮಾಡಿದ ಪ್ರತಿಯೊಂದು ಸಂಗತಿಯನ್ನು ಮೋಶೆ ಇತ್ರೋನನಿಗೆ ಹೇಳಿದನು. ಯೆಹೋವನು ಫರೋಹನಿಗೆ ಮತ್ತು ಈಜಿಪ್ಟಿನವರಿಗೆ ಮಾಡಿದ ಸಂಗತಿಗಳ ಬಗ್ಗೆ ಮೋಶೆಯು ಹೇಳಿದನು. ದಾರಿಯ ಉದ್ದಕ್ಕೂ ತಮಗೆ ಬಂದೊದಗಿದ ಎಲ್ಲಾ ಸಮಸ್ಯೆಗಳ ಬಗ್ಗೆ ಮತ್ತು ತೊಂದರೆ ಬಂದೊದಗಿದ ಪ್ರತಿ ಸಾರಿಯೂ ಯೆಹೋವನು ಇಸ್ರೇಲರನ್ನು ಹೇಗೆ ರಕ್ಷಿಸಿದನೆಂಬುದನ್ನು ಮೋಶೆಯು ತನ್ನ ಮಾವನಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ಯೆಹೋವನು ಇಸ್ರೇಲರಿಗೆ ಮಾಡಿದ ಒಳ್ಳೆಯ ಸಂಗತಿಗಳಿಗಾಗಿಯೂ ಈಜಿಪ್ಟಿನವರಿಂದ ಇಸ್ರೇಲರನ್ನು ಯೆಹೋವನು ಬಿಡುಗಡೆಗೊಳಿಸಿದ್ದಕ್ಕಾಗಿಯೂ ಇತ್ರೋನನು ಬಹಳ ಸಂತೋಷಪಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ಇತ್ರೋನನು, “ಯೆಹೋವನನ್ನು ಸ್ತುತಿಸಿರಿ! ಆತನು ನಿಮ್ಮನ್ನು ಫರೋಹನಿಂದಲೂ ಈಜಿಪ್ಟಿನಿಂದಲೂ ರಕ್ಷಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ಈಜಿಪ್ಟಿನವರು ತಾವು ಇಸ್ರೇಲರಿಗಿಂತಲೂ ಉತ್ತಮರೆಂದು ಭಾವಿಸಿಕೊಂಡಿದ್ದರು. ಆದರೆ ಯೆಹೋವನು ಅವರನ್ನು ತಗ್ಗಿಸಿದ್ದರಿಂದ ಎಲ್ಲಾ ದೇವರುಗಳಲ್ಲಿ ಆತನೇ ದೊಡ್ಡವನೆಂದು ಈಗ ನಾನು ತಿಳಿದುಕೊಂಡೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ಇತ್ರೋನನು ದೇವರಿಗೆ ಯಜ್ಞಗಳನ್ನು, ಕಾಣಿಕೆಗಳನ್ನು ಕೊಟ್ಟನು. ಆಗ ಆರೋನನು ಮತ್ತು ಇಸ್ರೇಲರ ಎಲ್ಲಾ ಹಿರಿಯರು ಮೋಶೆಯ ಮಾವನಾದ ಇತ್ರೋನನೊಡನೆ ದೇವರ ಸನ್ನಿಧಿಯಲ್ಲಿ ಊಟಮಾಡಲು ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ಮರುದಿನ ಮೋಶೆಯು ಜನರಿಗೆ ನ್ಯಾಯನಿರ್ಣಯ ಮಾಡಲು ತನ್ನ ಆಸನದ ಮೇಲೆ ಕುಳಿತುಕೊಂಡನು. ಅಲ್ಲಿ ಬಹಳ ಜನರಿದ್ದರು, ಆದ್ದರಿಂದ ಅವರು ಮುಂಜಾನೆಯಿಂದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅವನ ಸುತ್ತಲೂ ನಿಂತುಕೊಂಡಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ಮೋಶೆಯು ಜನರ ನ್ಯಾಯತೀರಿಸುವುದನ್ನು ಇತ್ರೋನನು ನೋಡಿ, “ನೀನು ಯಾಕೆ ಹೀಗೆ ಮಾಡುತ್ತಿರುವೆ? ನೀನೊಬ್ಬನೇ ಯಾಕೆ ನ್ಯಾಯತೀರಿಸಬೇಕು? ಜನರು ದಿನವೆಲ್ಲಾ ನಿನ್ನ ಬಳಿಗೆ ಯಾಕೆ ಬರಬೇಕು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ಆಗ ಮೋಶೆ ತನ್ನ ಮಾವನಿಗೆ, “ಜನರು ನನ್ನ ಬಳಿಗೆ ಬಂದು ದೇವರ ತೀರ್ಮಾನವನ್ನು ಕೇಳಬಯಸುತ್ತಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ಅವರೊಳಗೆ ವ್ಯಾಜ್ಯವಿದ್ದರೆ ಅವರು ನನ್ನ ಬಳಿಗೆ ಬರುತ್ತಾರೆ. ಯಾವನು ನ್ಯಾಯವಂತನೆಂದು ನಾನು ತೀರ್ಮಾನಿಸುತ್ತೇನೆ. ಈ ರೀತಿಯಾಗಿ ನಾನು ದೇವರ ಕಟ್ಟಳೆಗಳನ್ನು ಮತ್ತು ಬೋಧನೆಗಳನ್ನು ಜನರಿಗೆ ಬೋಧಿಸುತ್ತೇನೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ಆದರೆ ಮೋಶೆಯ ಮಾವನು ಅವನಿಗೆ, “ನೀನು ಹೀಗೆ ಮಾಡುತ್ತಿರುವುದು ಒಳ್ಳೆಯದಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ಈ ಕೆಲಸ ನೀನೊಬ್ಬನೇ ಮಾಡುವುದು ಬಹಳ ಪ್ರಯಾಸಕರ. ಇದು ನಿನ್ನನ್ನೂ ಆಯಾಸಗೊಳಿಸುತ್ತದೆ; ಜನರನ್ನೂ ಆಯಾಸಗೊಳಿಸುತ್ತದೆ. ನಿನ್ನೊಬ್ಬನಿಂದಲೇ ಈ ಕೆಲಸವನ್ನು ಮಾಡಲಾಗದು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ಕೇಳು, ನಾನು ನಿನಗೆ ಕೆಲವು ಸಲಹೆಗಳನ್ನು ಕೊಡುವೆನು. ಯೆಹೋವನು ನಿನ್ನೊಡನೆ ಇರಲಿ ಎಂದು ನಾನು ಪ್ರಾರ್ಥಿಸುತ್ತೇನೆ. ನೀನು ಮಾಡಬೇಕಾದದ್ದು ಇವೇ: ಜನರ ವ್ಯಾಜ್ಯಗಳನ್ನು ನೀನು ಕೇಳುವುದನ್ನು ಮುಂದುವರಿಸಬೇಕು; ಈ ಸಂಗತಿಗಳ ಬಗ್ಗೆ ನೀನು ದೇವರೊಂದಿಗೆ ಮಾತಾಡುವುದನ್ನೂ ಮುಂದುವರಿಸಬೇಕು; ");
INSERT INTO kan2010_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ನೀನು ದೇವರ ಕಟ್ಟಳೆಗಳನ್ನು ಮತ್ತು ಬೋಧನೆಗಳನ್ನು ಜನರಿಗೆ ಬೋಧಿಸಬೇಕು; ನಿಬಂಧನೆಗಳನ್ನು ಉಲ್ಲಂಘಿಸದಂತೆ ಅವರನ್ನು ಎಚ್ಚರಿಸಬೇಕು; ಜೀವಿಸಲು ಸರಿಯಾದ ಮಾರ್ಗವನ್ನು ಅವರಿಗೆ ಬೋಧಿಸಬೇಕು; ಅವರು ಮಾಡಬೇಕಾದದ್ದನ್ನು ಅವರಿಗೆ ತಿಳಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ಆದರೆ ನೀನು ಜನರೊಳಗೆ ದೇವಭಕ್ತರೂ ಲಂಚಮುಟ್ಟದವರೂ ಆಗಿರುವವರನ್ನು ಆರಿಸಿಕೊಳ್ಳಬೇಕು. ಅವರನ್ನು ಸಾವಿರ ಜನರ ಮೇಲೆಯೂ ನೂರು ಜನರ ಮೇಲೆಯೂ ಐವತ್ತು ಜನರ ಮೇಲೆಯೂ ಹತ್ತು ಜನರ ಮೇಲೆಯೂ ಅಧಿಕಾರಿಗಳನ್ನಾಗಿ ನೇಮಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ಈ ಅಧಿಕಾರಿಗಳು ಜನರಿಗೆ ನ್ಯಾಯತೀರಿಸಲಿ. ಬಹಳ ಪ್ರಾಮುಖ್ಯವಾದ ವ್ಯಾಜ್ಯವಿದ್ದರೆ, ತೀರ್ಮಾನಕ್ಕಾಗಿ ಅವರು ನಿನ್ನ ಬಳಿಗೆ ಬರಬಹುದು. ಆದರೆ ಇತರ ವ್ಯಾಜ್ಯಗಳನ್ನು ಅವರೇ ತೀರ್ಮಾನಿಸಿಕೊಳ್ಳಬಹುದು. ಈ ರೀತಿಯಾಗಿ ಮಾಡಿದರೆ, ಅದು ನಿನಗೆ ಸುಲಭವಾಗುವುದು. ಮಾತ್ರವಲ್ಲದೆ, ಈ ಜನರು ನಿನ್ನ ಕೆಲಸವನ್ನು ತಮ್ಮೊಳಗೆ ಹಂಚಿಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ನೀನು ಈ ಸಂಗತಿಗಳನ್ನು ಮಾಡಿದರೆ, ಯೆಹೋವನ ಚಿತ್ತವಿದ್ದರೆ, ನೀನು ನಿನ್ನ ಕೆಲಸವನ್ನು ಮಾಡುತ್ತಾ ಮುಂದುವರಿಯಲು ಶಕ್ತನಾಗುವೆ ಮತ್ತು ಅದೇ ಸಮಯದಲ್ಲಿ ಜನರೆಲ್ಲರೂ ತಮ್ಮ ಸಮಸ್ಯೆಗಳನ್ನು ಪರಿಹರಿಸಿಕೊಂಡು ಮನೆಗೆ ಹೋಗಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ಮೋಶೆಯು ತನ್ನ ಮಾವನಾದ ಇತ್ರೋನನು ಹೇಳಿದಂತೆ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ಮೋಶೆಯು ಇಸ್ರೇಲರೊಳಗಿಂದ ನೀತಿವಂತರನ್ನು ಆರಿಸಿಕೊಂಡು ಅವರನ್ನು ಹೀಗೆ ಸಾವಿರ ಜನರ ಮೇಲೆಯೂ ನೂರು ಜನರ ಮೇಲೆಯೂ ಐವತ್ತು ಜನರ ಮೇಲೆಯೂ ಹತ್ತು ಜನರ ಮೇಲೆಯೂ ಅಧಿಕಾರಿಗಳನ್ನಾಗಿ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ಈ ಅಧಿಕಾರಿಗಳು ಜನರ ನ್ಯಾಯಾಧಿಪತಿಗಳಾಗಿದ್ದರು. ಜನರು ತಮ್ಮ ವ್ಯಾಜ್ಯಗಳನ್ನು ಈ ಅಧಿಕಾರಿಗಳ ಬಳಿಗೆ ಯಾವಾಗಲೂ ತರಬಹುದಾಗಿತ್ತು. ಮೋಶೆಯು ಬಹು ಪ್ರಾಮುಖ್ಯವಾದ ವ್ಯಾಜ್ಯಗಳನ್ನು ಮಾತ್ರ ತೀರ್ಮಾನಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ಸ್ವಲ್ಪ ಸಮಯದ ನಂತರ ಮೋಶೆಯು ತನ್ನ ಮಾವನಾದ ಇತ್ರೋನನನ್ನು ಬೀಳ್ಕೊಟ್ಟನು; ಇತ್ರೋನನು ತನ್ನ ಸ್ವದೇಶಕ್ಕೆ ಹಿಂತಿರುಗಿಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ಇಸ್ರೇಲರು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಟ ಮೂರನೆಯ ತಿಂಗಳಲ್ಲಿ ಸೀನಾಯ್ ಮರುಭೂಮಿಯನ್ನು ತಲುಪಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ಜನರು ರೆಫೀದೀಮನ್ನು ಬಿಟ್ಟು ಸೀನಾಯ್ ಮರುಭೂಮಿಗೆ ಬಂದಿದ್ದರು. ಅಲ್ಲಿ ಅವರು ಬೆಟ್ಟದ ಬಳಿ ತಂಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ಆಗ ಮೋಶೆ ಬೆಟ್ಟವನ್ನೇರಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಹೋದನು. ಮೋಶೆಯು ಬೆಟ್ಟದ ಮೇಲೆ ಇದ್ದಾಗ ಯೆಹೋವನು ಅವನಿಗೆ, “ಯಾಕೋಬನ ಮಹಾ ಕುಟುಂಬವಾದ ಇಸ್ರೇಲರಿಗೆ ಈ ಸಂಗತಿಗಳನ್ನು ಹೇಳು: ");
INSERT INTO kan2010_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘ನಾನು ನನ್ನ ವೈರಿಗಳಿಗೆ ಮಾಡುವ ಸಂಗತಿಗಳನ್ನು ನೀವು ನೋಡಿದ್ದೀರಿ. ನಾನು ಈಜಿಪ್ಟಿನವರಿಗೆ ಏನು ಮಾಡಿದೆನೆಂದು ನೀವು ನೋಡಿದಿರಿ. ಹದ್ದು ತನ್ನ ಮರಿಗಳನ್ನು ಹೊತ್ತುಕೊಂಡು ಬರುವಂತೆ ನಾನು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಇಲ್ಲಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದದ್ದನ್ನು ನೀವು ನೋಡಿದಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ಆದ್ದರಿಂದ ನನ್ನ ಆಜ್ಞೆಗಳಿಗೆ ವಿಧೇಯರಾಗಬೇಕೆಂದು ನಾನು ನಿಮಗೆ ಹೇಳುತ್ತೇನೆ. ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಕೈಕೊಂಡು ನಡೆಯಿರಿ. ಆಗ ನೀವು ನನಗೆ ವಿಶೇಷವಾದ ಜನರಾಗುವಿರಿ. ಈ ಲೋಕವೆಲ್ಲಾ ನನ್ನದೇ. ಆದರೆ ನಾನು ನಿಮ್ಮನ್ನು ನನ್ನ ಸ್ವಂತ ಜನಾಂಗವನ್ನಾಗಿ ಆರಿಸಿಕೊಳ್ಳುತ್ತಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ನೀವು ಯಾಜಕರ ರಾಜ್ಯ’ ಎಂಬ ವಿಶೇಷವಾದ ಜನಾಂಗವಾಗುವಿರಿ. ಮೋಶೆಯೇ, ನಾನು ನಿನಗೆ ಹೇಳಿದ ಸಂಗತಿಗಳನ್ನು ನೀನು ಇಸ್ರೇಲರಿಗೆ ಹೇಳಲೇಬೇಕು” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ಆದ್ದರಿಂದ ಮೋಶೆ ಬೆಟ್ಟದಿಂದಿಳಿದು ಬಂದು ಜನರ ಹಿರಿಯರನ್ನು ಒಟ್ಟಾಗಿ ಕರೆಸಿದನು. ಯೆಹೋವನು ಹೇಳಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಿದ ಸಂಗತಿಗಳನ್ನೆಲ್ಲಾ ಮೋಶೆಯು ಹಿರಿಯರಿಗೆ ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ಜನರೆಲ್ಲರೂ ಒಟ್ಟಾಗಿ ಮಾತಾಡಿದರು. “ಯೆಹೋವನು ಹೇಳುವ ಪ್ರತಿಯೊಂದಕ್ಕೂ ನಾವು ವಿಧೇಯರಾಗುವೆವು” ಎಂದು ಅವರು ಅರಿಕೆಮಾಡಿದರು. ಬಳಿಕ ಮೋಶೆಯು ತಿರುಗಿ ಬೆಟ್ಟವನ್ನೇರಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಹೋಗಿ ಜನರ ಪ್ರತಿಕ್ರಿಯೆಯನ್ನು ದೇವರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನು ಕಾರ್ಮುಗಿಲಲ್ಲಿ ನಿನ್ನ ಬಳಿಗೆ ಬರುವೆನು. ನಾನು ನಿನ್ನೊಡನೆ ಮಾತಾಡುವೆನು. ನಿನ್ನೊಡನೆ ಮಾತಾಡುವುದನ್ನು ಜನರೆಲ್ಲರೂ ಕೇಳುವರು. ನೀನು ಹೇಳುವ ಸಂಗತಿಗಳನ್ನು ಜನರು ಯಾವಾಗಲೂ ನಂಬಲು ಸಹಾಯವಾಗುವಂತೆ ನಾನು ಇದನ್ನು ಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ಆಗ ಮೋಶೆಯು ಜನರು ಹೇಳಿದ ಸಂಗತಿಗಳನ್ನೆಲ್ಲಾ ದೇವರಿಗೆ ಅರಿಕೆಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ಈ ದಿನ ಮತ್ತು ನಾಳೆ ನೀನು ಜನರನ್ನು ಒಂದು ವಿಶೇಷ ಸಂದರ್ಶನಕ್ಕಾಗಿ ಸಿದ್ಧಪಡಿಸಬೇಕು. ಜನರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ");
INSERT INTO kan2010_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ಮೂರನೆಯ ದಿನದಲ್ಲಿ ನನಗಾಗಿ ಸಿದ್ಧರಾಗಬೇಕು. ಮೂರನೆಯ ದಿನದಲ್ಲಿ ನಾನು ಸೀನಾಯ್ ಬೆಟ್ಟದ ಮೇಲೆ ಇಳಿದುಬರುವೆನು; ಜನರೆಲ್ಲರೂ ನನ್ನನ್ನು ನೋಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","ಆದರೆ ಬೆಟ್ಟದಿಂದ ದೂರವಿರಬೇಕೆಂದು ನೀನು ಜನರಿಗೆ ಹೇಳಬೇಕು. ಒಂದು ಗೆರೆಯನ್ನು ಹಾಕಿ ಆ ಗೆರೆಯನ್ನು ದಾಟಬಾರದೆಂದು ಅವರಿಗೆ ತಿಳಿಸು. ಯಾವ ವ್ಯಕ್ತಿಯಾಗಲಿ ಬೆಟ್ಟವನ್ನು ಮುಟ್ಟಿದರೆ ಅವನನ್ನು ಕಲ್ಲುಗಳಿಂದಾಗಲಿ ಬಾಣಗಳಿಂದಾಗಲಿ ಕೊಲ್ಲಬೇಕು. ಯಾವ ಪ್ರಾಣಿಯಾದರೂ ಬೆಟ್ಟವನ್ನು ಮುಟ್ಟಿದರೆ ಅದನ್ನು ಕೊಲ್ಲಬೇಕು. ಯಾರೂ ಬೆಟ್ಟವನ್ನು ಮುಟ್ಟಕೂಡದು. ಕೊಂಬಿನ ತುತ್ತೂರಿ ಊದಿದಾಗ ಜನರು ಬೆಟ್ಟದ ಸಮೀಪಕ್ಕೆ ಬರಬೇಕು ಎಂದು ಹೇಳು” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ಮೋಶೆ ಬೆಟ್ಟದಿಂದಿಳಿದು ಹೋದನು. ಅವನು ಜನರ ಬಳಿಗೆ ಹೋಗಿ ವಿಶೇಷ ಸಂದರ್ಶನಕ್ಕಾಗಿ ಅವರನ್ನು ಸಿದ್ಧ ಮಾಡಿದನು. ಜನರು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ಆಗ ಮೋಶೆ ಜನರಿಗೆ, “ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವನೊಡನೆ ಒಂದು ವಿಶೇಷ ಸಂದರ್ಶನಕ್ಕಾಗಿ ಸಿದ್ಧರಾಗಿರಿ. ಅಲ್ಲಿಯವರೆಗೆ, ಪುರುಷರು ಸ್ತ್ರೀಯರ ಸಂಗ ಮಾಡಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ಮೂರನೆಯ ದಿನದ ಮುಂಜಾನೆಯಲ್ಲಿ ಆ ಬೆಟ್ಟದ ಮೇಲೆ ಗುಡುಗು ಮಿಂಚುಗಳು ಉಂಟಾದವು. ಒಂದು ಕಾರ್ಮುಗಿಲು ಬೆಟ್ಟದ ಮೇಲೆ ಇಳಿದುಬಂತು; ತುತ್ತೂರಿಯ ಮಹಾ ಧ್ವನಿಯು ಕೇಳಿಸಿತು. ಪಾಳೆಯದಲ್ಲಿದ್ದ ಜನರೆಲ್ಲರೂ ಭಯಭೀತರಾದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ಆಗ ಮೋಶೆ ದೇವರನ್ನು ಸಂಧಿಸುವುದಕ್ಕಾಗಿ ಜನರನ್ನು ಪಾಳೆಯದಿಂದ ಹೊರಗೆ ನಡಿಸಿ, ಬೆಟ್ಟದ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ಸೀನಾಯಿ ಬೆಟ್ಟವು ಹೊಗೆಯಿಂದ ಕವಿದುಕೊಂಡಿತು. ಕುಲುಮೆಯಿಂದ ಬರುವ ಹೊಗೆಯಂತೆ, ಬೆಟ್ಟದಿಂದ ಹೊಗೆಯು ಮೇಲಕ್ಕೇರಿತು. ಯೆಹೋವನು ಬೆಂಕಿಯಲ್ಲಿ ಬೆಟ್ಟದ ಮೇಲೆ ಇಳಿದು ಬಂದದ್ದರಿಂದ ಇದು ಸಂಭವಿಸಿತು. ಇಡೀ ಬೆಟ್ಟ ನಡುಗಲಾರಂಭಿಸಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ತುತ್ತೂರಿಯ ಧ್ವನಿ ಹೆಚ್ಚುಹೆಚ್ಚಾಯಿತು. ಮೋಶೆಯು ದೇವರೊಂದಿಗೆ ಮಾತಾಡಿದಾಗಲೆಲ್ಲಾ ದೇವರು ಗುಡುಗಿನಂತಿದ್ದ ಧ್ವನಿಯಲ್ಲಿ ಅವನಿಗೆ ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ಯೆಹೋವನು ಸೀನಾಯಿ ಬೆಟ್ಟಕ್ಕೆ ಇಳಿದುಬಂದನು. ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಯನ್ನು ಕರೆದು ಬೆಟ್ಟದ ತುದಿಗೆ ಬರಲು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಮೋಶೆ ಮೇಲಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಕೆಳಗಿಳಿದು ಹೋಗಿ, ಜನರು ನನ್ನನ್ನು ನೋಡಲು ನನ್ನ ಹತ್ತಿರ ಬರಬಾರದೆಂದು ಅವರನ್ನು ಎಚ್ಚರಿಸು. ಇಲ್ಲವಾದರೆ ಅವರಲ್ಲಿ ಅನೇಕರು ಸಾಯುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ಮಾತ್ರವಲ್ಲದೆ ನನ್ನ ಸಮೀಪಕ್ಕೆ ಬರುವ ಯಾಜಕರು ಈ ವಿಶೇಷ ಸಂದರ್ಶನಕ್ಕಾಗಿ ತಮ್ಮನ್ನು ಸಿದ್ಧಪಡಿಸಿಕೊಳ್ಳಬೇಕೆಂದು ಹೇಳು. ಇಲ್ಲವಾದರೆ ನಾನು ಅವರನ್ನೂ ಶಿಕ್ಷಿಸುವೆನು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, “ಜನರು ಬೆಟ್ಟವನ್ನೇರಿ ಬರಲಾರರು. ಬೆಟ್ಟದ ಸುತ್ತಲೂ ಮೇರೆಯನ್ನು ಹಾಕಿ ಅದನ್ನು ಪವಿತ್ರ ಸ್ಧಳವನ್ನಾಗಿ ಪ್ರತ್ಯೇಕಿಸಬೇಕೆಂದು ನೀನೇ ನಮಗೆ ಎಚ್ಚರಿಕೆ ನೀಡಿದೆಯಲ್ಲಾ!” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ಯೆಹೋವನು ಅವನಿಗೆ, “ಜನರ ಬಳಿಗೆ ಇಳಿದುಹೋಗಿ ಆರೋನನನ್ನು ಕರೆದುಕೊಂಡು ಬಾ. ಆದರೆ ಯಾಜಕರಾಗಲಿ ಜನರಾಗಲಿ ಬರಕೂಡದು. ಅವರು ನನ್ನ ಸಮೀಪಕ್ಕೆ ಬಂದರೆ, ನಾನು ಅವರನ್ನು ದಂಡಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ಆದ್ದರಿಂದ ಮೋಶೆ ಜನರ ಬಳಿಗೆ ಇಳಿದುಹೋಗಿ ಈ ಸಂಗತಿಗಳನ್ನು ಅವರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ಬಳಿಕ ಯೆಹೋವನು ಈ ದಶಾಜ್ಞೆಗಳನ್ನು ಅವರಿಗೆ ಕೊಟ್ಟನು: ");
INSERT INTO kan2010_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ಯೆಹೋವನೆಂಬ ನಾನೇ ನಿಮ್ಮ ದೇವರು. ಈಜಿಪ್ಟಿನಲ್ಲಿ ಗುಲಾಮರಾಗಿದ್ದ ನಿಮ್ಮನ್ನು ಆ ದೇಶದಿಂದ ಹೊರಗೆ ನಡಿಸಿದವನು ನಾನೇ. ");
INSERT INTO kan2010_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“ನನ್ನನ್ನಲ್ಲದೆ ಬೇರೆ ಯಾವ ದೇವರುಗಳನ್ನೂ ನೀವು ಆರಾಧಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“ನೀವು ಯಾವ ವಿಗ್ರಹಗಳನ್ನೂ ಮಾಡಬಾರದು. ಆಕಾಶದಲ್ಲಿಯಾಗಲಿ ಭೂಮಿಯ ಮೇಲಾಗಲಿ ನೀರಿನಲ್ಲಾಗಲಿ ಇರುವ ಯಾವುದೇ ವಸ್ತುವಿನ ರೂಪವನ್ನು ನೀವು ಮಾಡಿಕೊಳ್ಳಬಾರದು. ಅವುಗಳಿಗೆ ಅಡ್ಡಬೀಳಲೂ ಬಾರದು ಪೂಜಿಸಲೂ ಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನೆಂಬ ನನಗೆ ಸಲ್ಲತಕ್ಕ ಗೌರವವನ್ನು ನೀವು ಬೇರೆಯವರಿಗೆ ಸಲ್ಲಿಸಿದರೆ ನಾನು ನಿಮ್ಮನ್ನು ದ್ವೇಷಿಸುತ್ತೇನೆ. ನನಗೆ ವಿರುದ್ಧವಾಗಿ ಪಾಪಮಾಡುವವರ ದೋಷಫಲವನ್ನು ಅವರ ಮೂರು ನಾಲ್ಕು ತಲೆಮಾರುಗಳವರೆಗೂ ಬರಮಾಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ಆದರೆ ನನ್ನ ಆಜ್ಞೆಗಳಿಗೆ ವಿಧೇಯರಾಗಿರುವವರಿಗೆ ಅವರ ಸಾವಿರ ತಲೆಮಾರುಗಳವರೆಗೂ ದಯೆತೋರಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಹೆಸರನ್ನು ಅಯೋಗ್ಯ ಕಾರ್ಯಕ್ಕಾಗಿ ಉಪಯೋಗಿಸಬಾರದು. ಯೆಹೋವನು ತನ್ನ ಹೆಸರನ್ನು ಅಯೋಗ್ಯಕಾರ್ಯಕ್ಕಾಗಿ ಉಪಯೋಗಿಸುವವನನ್ನು ಶಿಕ್ಷಿಸದೆ ಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“ನೀವು ಸಬ್ಬತ್ ದಿನವನ್ನು ದೇವರ ದಿನವೆಂದು ಜ್ಞಾಪಕದಲ್ಲಿಟ್ಟುಕೊಂಡು ಅದನ್ನು ಆಚರಿಸಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ವಾರದ ಆರು ದಿನಗಳಲ್ಲಿ ಕೆಲಸಮಾಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ಆದರೆ ಏಳನೆ ದಿನವು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸಲು ಮೀಸಲಾಗಿರುವ ವಿಶ್ರಾಂತಿ ದಿನವಾಗಿದೆ. ಅಂದು ನೀವು ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ನೀವಾಗಲಿ ನಿಮ್ಮ ಗಂಡುಮಕ್ಕಳಾಗಲಿ ಹೆಣ್ಣುಮಕ್ಕಳಾಗಲಿ ಸೇವಕರಾಗಲಿ ಸೇವಕಿಯರಾಗಲಿ ನಿಮ್ಮ ಪಶುಗಳಾಗಲಿ ನಿಮ್ಮಲ್ಲಿರುವ ವಿದೇಶಿಯರಾಗಲಿ ಕೆಲಸ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ಯಾಕೆಂದರೆ ಯೆಹೋವನು ಆರು ದಿನಗಳಲ್ಲಿ ಕೆಲಸ ಮಾಡಿ ಭೂಮ್ಯಾಕಾಶಗಳನ್ನೂ ಸಮುದ್ರವನ್ನೂ ಅವುಗಳಲ್ಲಿರುವ ಸಮಸ್ತವನ್ನೂ ನಿರ್ಮಿಸಿ ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿದನು. ಆದ್ದರಿಂದ ಯೆಹೋವನು ಸಬ್ಬತ್ ದಿನವನ್ನು ಆಶೀರ್ವದಿಸಿ ಅದನ್ನು ತನ್ನ ದಿನವನ್ನಾಗಿ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“ನೀವು ನಿಮ್ಮ ತಂದೆತಾಯಿಗಳನ್ನು ಸನ್ಮಾನಿಸಬೇಕು; ನೀವು ಸನ್ಮಾನಿಸಿದರೆ, ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಿಮಗೆ ಕೊಡುವ ದೇಶದಲ್ಲಿ ಬಹುಕಾಲ ಬಾಳುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“ನೀವು ಯಾರನ್ನೂ ಕೊಲೆ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“ನೀವು ವ್ಯಭಿಚಾರ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“ನೀವು ಕದಿಯಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“ನೀವು ಬೇರೆಯವರ ಮೇಲೆ ಸುಳ್ಳುಸಾಕ್ಷಿ ಹೇಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ನೀವು ನೆರೆಯವನ ಮನೆಯನ್ನು ಆಶಿಸಬಾರದು. ನೀವು ಮತ್ತೊಬ್ಬನ ಹೆಂಡತಿಯನ್ನಾಗಲಿ ಸೇವಕರನ್ನಾಗಲಿ ದಾಸಿಯರನ್ನಾಗಲಿ ಪಶುಗಳನ್ನಾಗಲಿ ಆಶಿಸಬಾರದು.” ");
INSERT INTO kan2010_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ಆಗ ಅಲ್ಲಿದ್ದ ಜನರು ಗುಡುಗಿನ ಧ್ವನಿಯನ್ನು ಕೇಳಿದರು; ಬೆಟ್ಟದ ಮೇಲೆ ಮಿಂಚುಗಳನ್ನು ನೋಡಿದರು; ಹೊಗೆಯು ಬೆಟ್ಟದಿಂದ ಏರುವುದನ್ನು ಕಂಡರು. ಅವರೆಲ್ಲರೂ ಭಯದಿಂದ ನಡುಗಿದರು; ಬೆಟ್ಟದಿಂದ ದೂರದಲ್ಲಿದ್ದುಕೊಂಡು ಅವುಗಳನ್ನೆಲ್ಲಾ ಗಮನಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ಆಗ ಜನರು ಮೋಶೆಗೆ, “ನೀನು ನಮ್ಮೊಡನೆ ಮಾತಾಡು; ನಾವು ನಿನಗೆ ಕಿವಿಗೊಡುವೆವು. ಆದರೆ ಯೆಹೋವನು ನಮ್ಮೊಡನೆ ಮಾತಾಡದಿರಲಿ. ಇಲ್ಲವಾದರೆ ನಾವು ಸಾಯುವೆವು” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ಆಗ ಮೋಶೆಯು ಜನರಿಗೆ, “ಭಯಪಡಬೇಡಿರಿ, ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ಪರೀಕ್ಷಿಸಲು ಬಂದಿದ್ದಾನೆ. ನೀವು ಆತನಲ್ಲಿ ಭಕ್ತಿಯುಳ್ಳವರಾಗಿರಬೇಕೆಂದು ಆತನು ಬಯಸುತ್ತಾನೆ. ಆಗ ನೀವು ಪಾಪ ಮಾಡುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ದೇವರ ಸನ್ನಿಧಾನಕ್ಕೆ ಹೋಗಲು ಮೋಶೆಯು ಕಾರ್ಮುಗಿಲಿನೊಳಗೆ ಹೋದಾಗ, ಜನರು ಬೆಟ್ಟದಿಂದ ದೂರ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ಆಗ ಯೆಹೋವನು ಈ ಸಂಗತಿಗಳನ್ನು ಇಸ್ರೇಲರಿಗೆ ತಿಳಿಸಲು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದನು: “ನಾನು ಪರಲೋಕದಿಂದ ನಿಮ್ಮ ಸಂಗಡ ಮಾತಾಡಿದ್ದನ್ನು ನೀವು ನೋಡಿದ್ದೀರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ಆದ್ದರಿಂದ ನನ್ನೊಡನೆ ಸ್ಪರ್ಧಿಸಲು, ನೀವು ಬೆಳ್ಳಿಬಂಗಾರಗಳಿಂದ ಮೂರ್ತಿಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬಾರದು. ಈ ಸುಳ್ಳು ದೇವರುಗಳನ್ನು ನೀವು ಮಾಡಿಕೊಳ್ಳಲೇಬಾರದು.” ");
INSERT INTO kan2010_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ಒಂದು ವಿಶೇಷ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ನನಗೋಸ್ಕರ ಮಣ್ಣಿನಿಂದ ಕಟ್ಟಿರಿ. ಈ ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಕುರಿದನಗಳನ್ನು ನನಗೆ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನಾಗಿಯೂ ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನಾಗಿಯೂ ಸಮರ್ಪಿಸಿರಿ. ನಾನು ನಿಮಗೆ ಹೇಳುವ ಪ್ರತಿಯೊಂದು ಸ್ಥಳದಲ್ಲಿಯೂ ನನ್ನನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಲು ಹೀಗೆಯೇ ಮಾಡಿರಿ. ಆಗ ನಾನು ಬಂದು ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ನೀವು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಲ್ಲುಗಳಿಂದ ಕಟ್ಟಬೇಕೆಂದಿದ್ದರೆ, ಉಳಿಯಿಂದ ಕೆತ್ತಿದ ಕಲ್ಲುಗಳನ್ನು ಉಪಯೋಗಿಸಬೇಡಿರಿ. ಅಂಥ ಕಲ್ಲುಗಳನ್ನು ಉಪಯೋಗಿಸಿದರೆ, ಯಜ್ಞವೇದಿಕೆಯು ಅಪವಿತ್ರವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ಅಲ್ಲದೆ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಹತ್ತುವುದಕ್ಕೆ ಮೆಟ್ಟಲುಗಳನ್ನು ಮಾಡಬಾರದು. ಮೆಟ್ಟಲುಗಳಿದ್ದರೆ ಜನರು ತಲೆ ಎತ್ತಿ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ನೋಡುವಾಗ ನಿಮ್ಮ ರಹಸ್ಯಾಂಗವು ಕಾಣಿಸೀತು.” ");
INSERT INTO kan2010_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ಬಳಿಕ ದೇವರು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, “ನೀನು ಜನರಿಗೆ ನೇಮಿಸಬೇಕಾದ ಇತರ ಕಟ್ಟಳೆಗಳು ಯಾವುವೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“ನೀವು ಇಬ್ರಿಯ ಗುಲಾಮನನ್ನು ಕೊಂಡುಕೊಂಡರೆ, ಆ ಗುಲಾಮನು ಆರು ವರ್ಷಗಳವರೆಗೆ ಮಾತ್ರ ನಿಮ್ಮ ಸೇವೆಮಾಡುವನು. ಆರು ವರ್ಷಗಳ ನಂತರ, ಅವನು ಬಿಡುಗಡೆಯಾಗುವನು, ಅವನು ಏನೂ ಕೊಡಬೇಕಾಗಿರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ಅವನು ನಿಮ್ಮ ಗುಲಾಮನಾಗುವಾಗ ಮದುವೆಯಾಗಿಲ್ಲದಿದ್ದರೆ, ಅವನು ಬಿಡುಗಡೆ ಹೊಂದುವಾಗಲೂ ಹೆಂಡತಿಯಿಲ್ಲದವನಾಗಿ ಹೋಗುವನು. ಆದರೆ ಅವನು ನಿಮ್ಮ ಗುಲಾಮನಾಗುವಾಗ ಮದುವೆಯಾಗಿದ್ದರೆ ಅವನು ಬಿಡುಗಡೆ ಹೊಂದುವಾಗ ತನ್ನ ಹೆಂಡತಿಯನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ಗುಲಾಮನು ಮದುವೆಯಾಗಿಲ್ಲದಿದ್ದರೆ, ಅವನ ಯಜಮಾನನು ಅವನಿಗೆ ಮದುವೆ ಮಾಡಿಸಬಹುದು. ಆ ಸ್ತ್ರೀಯು ಮಕ್ಕಳನ್ನು ಹೆತ್ತರೆ, ಆಕೆಯೂ ಆಕೆಯ ಮಕ್ಕಳೂ ಯಜಮಾನನ ಸ್ವತ್ತಾಗುವರು. ಗುಲಾಮನು ತನ್ನ ಸೇವಾ ವರ್ಷಗಳನ್ನು ಮುಗಿಸಿದ ತರುವಾಯ ಬಿಡುಗಡೆ ಹೊಂದುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“ಆದರೆ ಒಂದುವೇಳೆ ಆ ಗುಲಾಮನು ತನ್ನ ಯಜಮಾನನ ಸಂಗಡವಿರಲು ದೃಢವಾಗಿ ಬಯಸಿದರೆ ಅವನು, ‘ನಾನು ನನ್ನ ಯಜಮಾನನನ್ನು ಪ್ರೀತಿಸುತ್ತೇನೆ. ನಾನು ನನ್ನ ಹೆಂಡತಿಯನ್ನೂ ಮಕ್ಕಳನ್ನೂ ಪ್ರೀತಿಸುತ್ತೇನೆ. ನಾನು ಬಿಡುಗಡೆ ಹೊಂದದೆ ಇಲ್ಲೇ ಇರುವೆನು’ ಎಂದು ಹೇಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ಹೀಗಾದರೆ ಯಜಮಾನನು ಆ ಗುಲಾಮನನ್ನು ದೇವರ ಸನ್ನಿಧಿಗೆ ಕರೆದುಕೊಂಡು ಬರುವನು. ಯಜಮಾನನು ಗುಲಾಮನನ್ನು ಬಾಗಿಲ ಬಳಿಗೆ ಅಥವಾ ಬಾಗಿಲಿನ ಮರದ ನಿಲುವುಪಟ್ಟಿಗಳ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರುವನು. ಯಜಮಾನನು ಗುಲಾಮನ ಕಿವಿಗೆ ಚೂಪಾದ ಸಲಾಕೆಯಿಂದ ರಂಧ್ರ ಮಾಡುವನು. ಆಗ ಗುಲಾಮನು ತನ್ನ ಜೀವಮಾನಪರ್ಯಂತ ಆ ಯಜಮಾನನಿಗೆ ಸೇವೆ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ಒಬ್ಬನು ತನ್ನ ಮಗಳನ್ನು ಗುಲಾಮಳನ್ನಾಗಿ ಮಾರಲು ತೀರ್ಮಾನಿಸಿದರೆ, ಆಕೆಯನ್ನು ಬಿಡುಗಡೆಗೊಳಿಸುವ ನಿಯಮಗಳು ಗುಲಾಮರಾದ ಪುರುಷರನ್ನು ಬಿಡುಗಡೆಗೊಳಿಸುವ ನಿಯಮಗಳ ಪ್ರಕಾರ ಇರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ಯಜಮಾನನು ತನಗಾಗಿ ಆರಿಸಿಕೊಂಡ ಗುಲಾಮಳನ್ನು ಇಷ್ಟಪಡದಿದ್ದರೆ, ಅವಳನ್ನು ಬಿಡುಗಡೆ ಮಾಡಬಹುದು. (ಅವಳ ತಂದೆಗೆ ಅವಳನ್ನು ಮಾರಬಹುದು.) ಅವಳನ್ನು ವಿದೇಶಿಯರಿಗೆ ಮಾರುವ ಹಕ್ಕನ್ನು ಯಜಮಾನನು ಕಳೆದುಕೊಳ್ಳುತ್ತಾನೆ; ಯಾಕೆಂದರೆ ಆಕೆಯಲ್ಲಿ ಅವನಿಗಿದ್ದ ನಂಬಿಕೆಯು ಮುರಿದುಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ಯಜಮಾನನು ಗುಲಾಮಳನ್ನು ತನ್ನ ಸ್ವಂತ ಮಗನಿಗೆ ಮದುವೆ ಮಾಡಿಸುವುದಾಗಿ ವಾಗ್ದಾನ ಮಾಡಿದರೆ, ಅವಳನ್ನು ಗುಲಾಮಳನ್ನಾಗಿ ನೋಡಿಕೊಳ್ಳದೆ ಸೊಸೆಯಾಗಿ ನೋಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“ಯಜಮಾನನು ಇನ್ನೊಬ್ಬ ಸ್ತ್ರೀಯನ್ನು ಮದುವೆಯಾದರೆ, ಅವನು ತನ್ನ ಮೊದಲನೆಯ ಹೆಂಡತಿಗೆ ಅವನು ಕೊಡುವ ಆಹಾರ ಅಥವಾ ಬಟ್ಟೆಬರೆಗಳಲ್ಲಿ ಏನೂ ಕಡಿಮೆ ಮಾಡಬಾರದು; ಮದುವೆಯ ಮೂಲಕ ಆಕೆಯು ಯಾವ್ಯಾವ ವಸ್ತುಗಳನ್ನು ಹೊಂದಲು ಹಕ್ಕು ಪಡೆದಿರುತ್ತಾಳೊ ಅವೆಲ್ಲವನ್ನು ಅವನು ಆಕೆಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ಅವನು ಆಕೆಗಾಗಿ ಈ ಮೂರು ಸಂಗತಿಗಳನ್ನು ಮಾಡಬೇಕು. ಇಲ್ಲವಾದರೆ ಅವಳು ಬಿಡುಗಡೆಯಾಗಿದ್ದಾಳೆ. ಅವಳು ಅವನಿಗೆ ಯಾವ ಸಾಲವನ್ನೂ ತೀರಿಸಬೇಕಾಗಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ಒಬ್ಬನು ಮತ್ತೊಬ್ಬನನ್ನು ಹೊಡೆದು ಕೊಂದರೆ, ಅವನೂ ಕೊಲ್ಲಲ್ಪಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ಆದರೆ ಕೊಲ್ಲಬೇಕೆಂಬ ಉದ್ದೇಶವಿಲ್ಲದೆ ಹೊಡೆದಾಗ ಸತ್ತುಹೋದರೆ ಅದು ದೇವರ ಸಂಕಲ್ಪವೆಂದು ಪರಿಗಣಿಸಬೇಕು. ನಾನು ನೇಮಿಸಲಿರುವ ಆಶ್ರಯಸ್ಥಳಗಳಿಗೆ ಹೊಡೆದವನು ಓಡಿಹೋಗಿ ಸುರಕ್ಷಿತವಾಗಿ ಬದುಕಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ಆದರೆ ಒಬ್ಬನು ಕೋಪದಿಂದಾಗಲಿ ದ್ವೇಷದಿಂದಾಗಲಿ ಇನ್ನೊಬ್ಬನನ್ನು ಕೊಂದರೆ, ಆ ಕೊಲೆಗಾರನಿಗೆ ದಂಡನೆಯಾಗಬೇಕು. ನನ್ನ ಯಜ್ಞವೇದಿಕೆಯಿಂದ ಅವನನ್ನು ದೂರಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ತಂದೆಯನ್ನಾಗಲಿ ತಾಯಿಯನ್ನಾಗಲಿ ಹೊಡೆಯುವವನನ್ನು ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ಯಾವನಾದರೂ ಮತ್ತೊಬ್ಬನನ್ನು ಕದ್ದು ಗುಲಾಮನನ್ನಾಗಿ ಮಾರಿದರೆ ಅಥವಾ ತನ್ನ ಗುಲಾಮನನ್ನಾಗಿ ಮಾಡಿಕೊಂಡರೆ ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ತಂದೆಯನ್ನಾಗಲಿ ತಾಯಿಯನ್ನಾಗಲಿ ಶಪಿಸುವವನನ್ನೂ ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ಇಬ್ಬರು ಜಗಳವಾಡುತ್ತಿರುವಾಗ ಒಬ್ಬನನ್ನು ಕಲ್ಲಿನಿಂದಾಗಲಿ ಮುಷ್ಟಿಯಿಂದಾಗಲಿ ಹೊಡೆದಾಗ, ಪೆಟ್ಟಾದ ಮನುಷ್ಯನು ಸಾಯದಿದ್ದರೆ, ಹೊಡೆದವನನ್ನು ಕೊಲ್ಲಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ಗಾಯಗೊಂಡವನು ಕೆಲವು ಕಾಲದವರೆಗೆ ಹಾಸಿಗೆಯಲ್ಲಿರಬೇಕಾದರೆ, ಬಳಿಕ ಅವನು ಎದ್ದು ಊರುಗೋಲಿನ ಸಹಾಯದಿಂದ ನಡೆಯಬಲ್ಲವನಾದರೆ, ಹೊಡೆದವನು ಅವನನ್ನು ಆರೈಕೆ ಮಾಡಬೇಕು. ಗಾಯಗೊಂಡವನು ಕೆಲಸಮಾಡಲಾರದೆ ಹೋದ ಸಮಯಕ್ಕೆ ಹೊಡೆದವನು ಹಣ ಕೊಡಬೇಕು; ಅವನು ಸಂಪೂರ್ಣ ವಾಸಿಯಾಗುವವರೆಗೆ ಆರೈಕೆ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“ಕೆಲವು ಸಲ ಯಜಮಾನರು ಗುಲಾಮನನ್ನಾಗಲಿ ಗುಲಾಮಳನ್ನಾಗಲಿ ಹೊಡೆಯುತ್ತಾರೆ. ಹೊಡೆದಾಗ ಆ ವ್ಯಕ್ತಿಯು ಸತ್ತರೆ, ಯಜಮಾನನಿಗೆ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ಆದರೆ ಆ ವ್ಯಕ್ತಿಯು ಸಾಯದೆ ಕೆಲವು ದಿನಗಳ ನಂತರ ಗುಣವಾದರೆ ಯಜಮಾನನಿಗೆ ಶಿಕ್ಷೆಯಾಗಬಾರದು. ಯಾಕೆಂದರೆ ಯಜಮಾನನು ಹಣವನ್ನು ಕೊಟ್ಟು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಕೊಂಡುಕೊಂಡಿದ್ದಾನೆ ಮತ್ತು ಆ ವ್ಯಕ್ತಿಯು ಅವನ ಸ್ವತ್ತಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ಇಬ್ಬರು ಜಗಳವಾಡುವಾಗ ಗರ್ಭಿಣೆ ಸ್ತ್ರೀಗೆ ಪೆಟ್ಟಾಗಿ ಗರ್ಭಸ್ರಾವವಾದರೆ ಅದಕ್ಕೆ ಕಾರಣನಾದ ವ್ಯಕ್ತಿಯು ಅವಳಿಗೆ ದಂಡ ಕೊಡಬೇಕು. ಅವನು ಎಷ್ಟು ದಂಡ ಕೊಡಬೇಕೆಂಬುದನ್ನು ಅವಳ ಗಂಡನು ನ್ಯಾಯಾಧಿಪತಿಗಳ ಸಹಾಯದಿಂದ ತೀರ್ಮಾನಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ಆದರೆ ಆ ಸ್ತ್ರೀಯು ತೀರಿಕೊಂಡರೆ ಅದಕ್ಕೆ ಕಾರಣನಾದವನಿಗೆ ಮರಣದಂಡನೆಯಾಗಬೇಕು. ನೀವು ಪ್ರಾಣಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ಪ್ರಾಣವನ್ನು ಕೊಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ಕಣ್ಣಿಗೆ ಪ್ರತಿಯಾಗಿ ಕಣ್ಣು, ಹಲ್ಲಿಗೆ ಪ್ರತಿಯಾಗಿ ಹಲ್ಲು, ಕೈಗೆ ಪ್ರತಿಯಾಗಿ ಕೈ, ಕಾಲಿಗೆ ಪ್ರತಿಯಾಗಿ ಕಾಲು, ");
INSERT INTO kan2010_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ಬರೆಗೆ ಪ್ರತಿಯಾಗಿ ಬರೆ, ಗಾಯಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ಗಾಯ, ಏಟಿಗೆ ಪ್ರತಿಯಾಗಿ ಏಟು, ಈ ಮೇರೆಗೆ ಪ್ರತಿದಂಡನೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ಯಜಮಾನನು ಗುಲಾಮನಿಗೆ ಹೊಡೆದಾಗ ಗುಲಾಮನು ಕುರುಡನಾದರೆ, ಆ ಗುಲಾಮನು ಬಿಡುಗಡೆ ಹೊಂದಿದ್ದಾನೆ. ಅವನು ತನ್ನ ಬಿಡುಗಡೆಗೆ ತನ್ನ ಕಣ್ಣನ್ನೇ ಪ್ರತಿಯಾಗಿ ಕೊಟ್ಟಿದ್ದಾನೆ. ಗುಲಾಮನ ಅಥವಾ ಗುಲಾಮಳ ವಿಷಯದಲ್ಲಿಯೂ ಇದೇ ನಿಯಮ ಅನ್ವಯಿಸುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ಯಜಮಾನನು ಗುಲಾಮನ ಬಾಯಿಗೆ ಹೊಡೆದದ್ದರಿಂದ, ಗುಲಾಮನು ತನ್ನ ಹಲ್ಲನ್ನು ಕಳೆದುಕೊಂಡರೆ, ಆ ಗುಲಾಮನ ಹಲ್ಲು ಅವನ ಬಿಡುಗಡೆಗೆ ಕೊಟ್ಟ ಹಣವಾಗಿದೆ. ಗುಲಾಮನ ಅಥವಾ ಗುಲಾಮಳ ವಿಷಯದಲ್ಲಿ ಇದೇ ನಿಯಮವು ಅನ್ವಯಿಸುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ಒಬ್ಬನ ಎತ್ತು ಪುರುಷನನ್ನಾಗಲಿ ಸ್ತ್ರೀಯನ್ನಾಗಲಿ ಕೊಂದರೆ, ಆಗ ನೀವು ಕಲ್ಲುಗಳಿಂದ ಆ ಎತ್ತನ್ನು ಕೊಲ್ಲಬೇಕು. ನೀವು ಅದರ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು. ಆದರೆ ಎತ್ತಿನ ಮಾಲಿಕನು ತಪ್ಪಿಸಸ್ಥನಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ಆದರೆ ಹಿಂದೊಮ್ಮೆ ಆ ಎತ್ತು ಜನರಿಗೆ ತಿವಿದಿದ್ದು, ಅದರ ಮಾಲಿಕನಿಗೆ ಇದರ ವಿಷಯದಲ್ಲಿ ಎಚ್ಚರಿಕೆ ನೀಡಿದ್ದರೆ ಆಗ ಆ ಮಾಲಿಕನು ತಪ್ಪಿತಸ್ಥನಾಗಿದ್ದಾನೆ. ಯಾಕೆಂದರೆ ಅವನು ಆ ಎತ್ತನ್ನು ಕಟ್ಟಿಹಾಕಲಿಲ್ಲ ಅಥವಾ ಅದರ ಸ್ಥಳದಲ್ಲಿ ಬಂಧಿಸಿರಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಎತ್ತನ್ನು ಕಟ್ಟಿಹಾಕದೆ ಇದ್ದುದರಿಂದ, ಅದು ಯಾರನ್ನಾದರೂ ಕೊಂದರೆ, ಆಗ ಆ ಮಾಲಿಕನು ತಪ್ಪಿತಸ್ಥನಾಗಿದ್ದಾನೆ. ನೀವು ಎತ್ತನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕಲ್ಲದೆ ಅದರ ಮಾಲಿಕನನ್ನೂ ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ಆದರೆ ಸತ್ತವನ ಕುಟುಂಬದವರು ಅವನಿಂದ ಹಣವನ್ನು ಕೇಳಿದರೆ ಮತ್ತು ಅವನು ಹಣವನ್ನು ಕೊಟ್ಟರೆ, ಅವನು ತನ್ನ ಜೀವವನ್ನು ಬಿಡಿಸಿಕೊಂಡಂತಾಗುವುದು. ಆಗ ಆ ಎತ್ತಿನ ಮಾಲಿಕನನ್ನು ಕೊಲ್ಲಬಾರದು. ಆದರೆ ನ್ಯಾಯಾಧಿಪತಿಗಳು ತೀರ್ಮಾನಿಸುವಷ್ಟು ಹಣವನ್ನು ಅವನು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“ಎತ್ತು ಒಬ್ಬನ ಮಗನನ್ನಾಗಲಿ ಅಥಲಾ ಮಗಳನ್ನಾಗಲಿ ಕೊಂದರೆ ಇದೇ ನಿಯಮವನ್ನು ಪಾಲಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ಆದರೆ ಎತ್ತು ಗುಲಾಮನನ್ನು ಕೊಂದರೆ, ಆಗ ಆ ಪಶುವಿನ ಮಾಲಿಕನು ಗುಲಾಮನ ಯಜಮಾನನಿಗೆ ಮೂವತ್ತು ಬೆಳ್ಳಿಯ ನಾಣ್ಯಗಳನ್ನು ಕೊಡಬೇಕು ಮತ್ತು ಎತ್ತನ್ನು ಕಲ್ಲುಗಳಿಂದ ಹೊಡೆದು ಕೊಲ್ಲಬೇಕು. ಗುಲಾಮನ ಅಥವಾ ಗುಲಾಮಳ ವಿಷಯದಲ್ಲಿ ಇದೇ ನಿಯಮವನ್ನು ಪಾಲಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ಒಬ್ಬ ಮನುಷ್ಯನು ಕುಣಿಯೊಂದನ್ನು ತೋಡಿ ಅದನ್ನು ಮುಚ್ಚಿಲ್ಲದಿದ್ದರೆ ಮತ್ತು ಆ ಕುಣಿಯಲ್ಲಿ ಬೇರೊಬ್ಬನ ಪಶುವು ಬಿದ್ದು ಸತ್ತುಹೋದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ಕುಣಿಯನ್ನು ತೋಡಿದವನು ಆ ಪಶುವಿಗೆ ಪ್ರತಿಯಾಗಿ ಈಡುಕೊಡಬೇಕು. ಅವನು ಈಡುಕೊಟ್ಟ ನಂತರ ಆ ಸತ್ತ ಪಶುವು ಅವನದಾಗುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ಒಬ್ಬನ ಎತ್ತು ಇನ್ನೊಬ್ಬನ ಎತ್ತನ್ನು ಹಾದು ಕೊಂದರೆ ಆಗ ಜೀವಂತವಾಗಿರುವ ಎತ್ತನ್ನು ಮಾರಬೇಕು. ಆ ಎತ್ತನ್ನು ಮಾರಿದ್ದರಿಂದ ಬಂದ ಹಣವನ್ನು ಸಮವಾಗಿ ಹಂಚಿಕೊಳ್ಳಬೇಕು. ಕೊಲ್ಲಲ್ಪಟ್ಟ ಎತ್ತನ್ನು ಸಮವಾಗಿ ಹಂಚಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ಆದರೆ ಒಬ್ಬನ ಎತ್ತು ಮೊದಲೊಮ್ಮೆ ಇತರ ಪಶುಗಳಿಗೆ ಗಾಯಮಾಡಿದ್ದರೆ, ಅದರ ಮಾಲಿಕನು ಅದನ್ನು ಕಟ್ಟಿಹಾಕದೆ ಇದ್ದುದರ ನಿಮಿತ್ತ ತಪ್ಪಿತಸ್ಥನಾಗಿದ್ದಾನೆ. ಅವನು ಸತ್ತ ಎತ್ತಿಗೆ ಪ್ರತಿಯಾಗಿ ಸ್ವಂತ ಎತ್ತನ್ನು ಕೊಡಬೇಕು. ಸತ್ತ ಎತ್ತನ್ನು ತಾನೇ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ಒಬ್ಬನು ಎತ್ತನ್ನಾಗಲಿ ಕುರಿಯನ್ನಾಗಲಿ ಕದ್ದು ಅದನ್ನು ಕೊಯಿದರೆ ಅಥವಾ ಮಾರಿದರೆ, ಅವನು ತಾನು ಕದ್ದ ಎತ್ತಿಗೆ ಪ್ರತಿಯಾಗಿ ಐದು ಎತ್ತುಗಳನ್ನೂ ಅಥವಾ ತಾನು ಕದ್ದ ಕುರಿಗೆ ಪ್ರತಿಯಾಗಿ ನಾಲ್ಕು ಕುರಿಗಳನ್ನೂ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","ಅವನಲ್ಲಿ ಏನೂ ಇಲ್ಲದ ಪಕ್ಷಕ್ಕೆ, ಅವನು ಗುಲಾಮನಾಗುವನು. ಆದರೆ ಆ ಕಳ್ಳನು ಪಶುವನ್ನು ಇನ್ನೂ ಇಟ್ಟುಕೊಂಡಿರುವುದು ನಿಮಗೆ ಗೊತ್ತಾದರೆ, ಅವನು ಕದ್ದ ಪಶುವಿಗೆ ಪ್ರತಿಯಾಗಿ ಎರಡು ಪಶುಗಳನ್ನು ಮಾಲಿಕನಿಗೆ ಕೊಡಿಸಬೇಕು. ಕದ್ದದ್ದು ಎತ್ತಾಗಿರಬಹುದು, ಕತ್ತೆಯಾಗಿರಬಹುದು ಅಥವಾ ಕುರಿಯಾಗಿರಬಹುದು. “ಕಳ್ಳನು ರಾತ್ರಿಯಲ್ಲಿ ಮನೆಗೆ ಕನ್ನ ಹಾಕಲು ಪ್ರಯತ್ನಿಸುತ್ತಿರುವಾಗ ಕೊಲ್ಲಲ್ಪಟ್ಟರೆ, ಅವನನ್ನು ಕೊಂದದ್ದಕ್ಕೆ ಯಾರೂ ತಪ್ಪಿತಸ್ಧರಾಗುವುದಿಲ್ಲ. ಆದರೆ ಇದು ಹಗಲಿನಲ್ಲಿ ನಡೆದರೆ ಕೊಂದವನು ಕೊಲೆಗಾರನಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ಒಬ್ಬನು ತನ್ನ ಹೊಲದಲ್ಲಾಗಲಿ ದ್ರಾಕ್ಷಿತೋಟದಲ್ಲಾಗಲಿ ತನ್ನ ಪಶುವಿಗೆ ಮೇಯಲು ಬಿಡಬಹುದು. ಆದರೆ ಅದು ಅವನ ನೆರೆಯವನ ಹೊಲವನ್ನಾಗಲಿ, ದ್ರಾಕ್ಷಿತೋಟವನ್ನಾಗಲಿ ಹಾಳು ಮಾಡಿದರೆ, ಅವನು ತನ್ನ ನೆರೆಯವನಿಗೆ ಉಂಟಾದ ನಷ್ಟಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ತನ್ನ ಉತ್ತಮ ಬೆಳೆಗಳನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“ಒಬ್ಬನು ತನ್ನ ಹೊಲದಲ್ಲಿರುವ ಮುಳ್ಳಿನ ಪೊದೆಗಳನ್ನು ಸುಟ್ಟುಹಾಕಲು ಬೆಂಕಿಯನ್ನು ಹೊತ್ತಿಸಬಹುದು. ಆದರೆ ಬೆಂಕಿಯು ಹೆಚ್ಚಾಗಿ ಅವನ ನೆರೆಯವನ ಬೆಳೆಯನ್ನಾಗಲಿ ಬೆಳೆಯುತ್ತಿರುವ ಧಾನ್ಯಗಳನ್ನಾಗಲಿ ಸುಟ್ಟುಹಾಕಿದರೆ ಬೆಂಕಿಯನ್ನು ಹೊತ್ತಿಸಿದವನು ತಾನು ಸುಟ್ಟುಹಾಕಿದ ವಸ್ತುಗಳಿಗೆ ಪ್ರತಿಯಾಗಿ ಈಡುಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ಒಬ್ಬನು ತನ್ನ ನೆರೆಯವನ ಮನೆಯಲ್ಲಿ ಸ್ವಲ್ಪ ಹಣವನ್ನಾಗಲಿ ವಸ್ತುಗಳನ್ನಾಗಲಿ ಇಟ್ಟಿದ್ದು, ಆ ಹಣವಾಗಲಿ ವಸ್ತುಗಳಾಗಲಿ ಕಳುವಾದರೆ ಕಳ್ಳನನ್ನು ಕಂಡುಹಿಡಿಯಲು ನೀವು ಪ್ರಯತ್ನಿಸಬೇಕು. ನೀವು ಕಳ್ಳನನ್ನು ಕಂಡುಹಿಡಿದರೆ, ಆಗ ಅವನು ತಾನು ಕದ್ದವಸ್ತುಗಳ ಬೆಲೆಯ ಎರಡರಷ್ಟನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ಆದರೆ ನೀವು ಕಳ್ಳನನ್ನು ಕಂಡುಹಿಡಿಯಲಾಗದಿದ್ದರೆ, ಆ ಮನೆಯ ಮಾಲಿಕನು ತಪ್ಪಿತಸ್ಧನಾಗಿದ್ದಾನೋ ಇಲ್ಲವೋ ಎಂದು ದೇವರು ನಿರ್ಣಯಿಸುವನು. ಮನೆಯ ಮಾಲಿಕನು ದೇವರ ಸನ್ನಿಧಿಗೆ ಹೋಗಬೇಕು. ಅವನು ಕದ್ದಿದ್ದಾನೋ ಇಲ್ಲವೋ ಎಂದು ದೇವರು ತೀರ್ಮಾನಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“ಕಳೆದುಹೋದ ಎತ್ತು, ಕತ್ತೆ, ಕುರಿ, ಬಟ್ಟೆಬರೆ, ಅಥವಾ ವಸ್ತುವಿನ ವಿಷಯದಲ್ಲಿ ಒಬ್ಬನು, ‘ಇದು ನನ್ನದು’ ಎಂದು ಹೇಳಿದರೆ ಮತ್ತು ಇನ್ನೊಬ್ಬನು, ‘ಇಲ್ಲ, ಇದು ನನ್ನದು’ ಎಂದು ಹೇಳಿದರೆ, ಇವರಿಬ್ಬರೂ ದೇವರ ಸನ್ನಿಧಿಗೆ ಹೋಗಬೇಕು. ತಪ್ಪಿತಸ್ಥನಾರೆಂದು ದೇವರು ತೀರ್ಮಾನಿಸುವನು. ತಪ್ಪಿತಸ್ಥನು ಇನ್ನೊಬ್ಬನಿಗೆ ಕಳೆದುಹೋದ ವಸ್ತುವಿನ ಬೆಲೆಯ ಎರಡರಷ್ಟನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“ಸ್ವಲ್ಪಕಾಲದವರೆಗೆ ತನ್ನ ಪಶುವನ್ನು ಪೋಷಿಸಬೇಕೆಂದು ತನ್ನ ನೆರೆಯವನನ್ನು ಕೇಳಿಕೊಳ್ಳಬಹುದು. ಈ ಪಶುವು ಕತ್ತೆಯಾಗಿರಬಹುದು, ಎತ್ತಾಗಿರಬಹುದು, ಕುರಿಯಾಗಿರಬಹುದು ಅಥವಾ ಯಾವುದೇ ಪಶುವಾಗಿರಬಹುದು. ಆದರೆ ಅದು ಸತ್ತರೆ ಅಥವಾ ಅದಕ್ಕೆ ಪೆಟ್ಟಾದರೆ ಅಥವಾ ಕಳುವಾದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ಆ ನೆರೆಯವನು ಆ ಪಶುವನ್ನು ಕದ್ದಿಲ್ಲದ್ದಿದ್ದರೆ ತಾನು ಕದ್ದಿಲ್ಲವೆಂದು ಯೆಹೋವನ ಹೆಸರಿನಲ್ಲಿ ಪ್ರಮಾಣ ಮಾಡಬೇಕು. ಪಶುವಿನ ಮಾಲಿಕನು ಈ ಪ್ರಮಾಣವನ್ನು ಸ್ವೀಕರಿಸಬೇಕು. ನೆರೆಯವನು ಮಾಲಿಕನಿಗೆ ಪಶುವಿಗಾಗಿ ಈಡು ಕೊಡಬೇಕಾಗಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ಆದರೆ ಪಶುವು ಕದಿಯಲ್ಪಟ್ಟಿದ್ದರೆ, ಅವನು ಅದಕ್ಕಾಗಿ ಈಡು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ಕ್ರೂರಪ್ರಾಣಿಗಳು ಆ ಪಶುವನ್ನು ಕೊಂದುಹಾಕಿದ್ದರೆ, ನೆರೆಯವನು ಸತ್ತ ಪಶುವನ್ನು ಸಾಕ್ಷಿಯಾಗಿ ತರಬೇಕು. ನೆರೆಯವನು ಮಾಲಿಕನಿಗೆ ಸತ್ತ ಪಶುವಿಗಾಗಿ ಈಡು ಕೊಡಬೇಕಾಗಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ಒಬ್ಬನು ತನ್ನ ನೆರೆಯವನಿಂದ ಪಶುವನ್ನು ಸ್ವಲ್ಪಕಾಲಕ್ಕೆ ಸಾಲವಾಗಿ ತೆಗೆದುಕೊಂಡಿರುವಾಗ ಅದರ ಮಾಲಿಕನು ಅದರ ಸಮೀಪದಲ್ಲಿ ಇಲ್ಲದಿರುವ ಸಮಯದಲ್ಲಿ ಆ ಪಶುವಿಗೆ ಗಾಯವಾದರೆ ಅಥವಾ ಅದು ಸತ್ತುಹೋದರೆ, ಸಾಲ ತೆಗೆದುಕೊಂಡವನು ಆ ಪಶುವಿಗೆ ಈಡುಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ಆದರೆ ಅದರ ಮಾಲಿಕನು ಪಶುವಿನೊಂದಿಗೆ ಅಲ್ಲಿದ್ದರೆ ಆಗ ನೆರೆಯವನು ಈಡುಕೊಡಬೇಕಾಗಿಲ್ಲ. ನೆರೆಯವನು ಪಶುವನ್ನು ಬಾಡಿಗೆಗೆ ತೆಗೆದುಕೊಂಡಿರುವಾಗ ಆ ಪಶು ಸತ್ತರೆ ಅಥವಾ ಅದಕ್ಕೆ ಪೆಟ್ಟಾದರೆ ಅವನು ಈಡುಕೊಡಬೇಕಾಗಿಲ್ಲ. ಆ ಪಶುವನ್ನು ಉಪಯೋಗಿಸಲು ಅವನು ಕೊಟ್ಟ ಬಾಡಿಗೆಯೇ ಸಾಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“ಒಬ್ಬನು ಕನ್ನಿಕೆಯನ್ನು ಮರುಳುಗೊಳಿಸಿ ಕೂಡಿದರೆ, ಅವನು ಅವಳನ್ನು ಮದುವೆಯಾಗಬೇಕು. ಅವನು ಆಕೆಯ ತಂದೆಗೆ ತಕ್ಕ ತೆರವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ತಂದೆಯು ತನ್ನ ಮಗಳನ್ನು ಅವನಿಗೆ ಕೊಡಲು ನಿರಾಕರಿಸಿದರೂ ಅವನು ತೆರವನ್ನು ಕೊಡಬೇಕು. ಅವನು ಅವಳಿಗೋಸ್ಕರ ಪೂರ್ಣ ತೆರವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“ಮಾಟಗಾರ್ತಿಯನ್ನು ನೀವು ಜೀವಸಹಿತ ಉಳಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“ಪಶುಸಂಗ ಮಾಡಿದವನಿಗೆ ಮರಣದಂಡನೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“ಸುಳ್ಳುದೇವರಿಗೆ ಯಜ್ಞವನ್ನರ್ಪಿಸುವವನನ್ನು ನಾಶ ಮಾಡಬೇಕು. ನೀವು ದೇವರಾದ ಯೆಹೋವನೊಬ್ಬನಿಗೇ ಯಜ್ಞವನ್ನರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“ನೀವು ಮೊದಲು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಪರದೇಶಸ್ಥರಾಗಿದ್ದದ್ದನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಿ. ಆದ್ದರಿಂದ ನೀವು ಮೋಸಮಾಡಬಾರದು; ನಿಮ್ಮ ದೇಶದಲ್ಲಿರುವ ಯಾವ ಪರದೇಶಸ್ಥನಿಗೂ ಕೇಡು ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“ನೀವೆಂದಿಗೂ ವಿಧವೆಯರಿಗೆ ಅಥವಾ ಅನಾಥ ಮಕ್ಕಳಿಗೆ ಕೇಡುಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ನೀವು ಆ ವಿಧವೆಯರಿಗೆ ಅಥವಾ ಅನಾಥರಿಗೆ ಕೇಡುಮಾಡಿದರೆ, ನಾನು ಅವರ ಗೋಳಾಟವನ್ನು ಕೇಳಿ, ");
INSERT INTO kan2010_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ನಿಮ್ಮ ಮೇಲೆ ಕೋಪಗೊಳ್ಳುವೆನು; ಕತ್ತಿಯಿಂದ ನಿಮ್ಮನ್ನು ಕೊಲ್ಲುವೆನು. ಆಗ ನಿಮ್ಮ ಹೆಂಡತಿಯರು ವಿಧವೆಯರಾಗುವರು; ನಿಮ್ಮ ಮಕ್ಕಳು ಅನಾಥರಾಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“ನನ್ನ ಜನರಲ್ಲಿ ಬಡವನಾಗಿರುವವನಿಗೆ ನೀವು ಹಣವನ್ನು ಸಾಲಕೊಟ್ಟರೆ, ನೀವು ಆ ಹಣಕ್ಕೆ ಬಡ್ಡಿ ಕೇಳಬಾರದು. ಬೇಗನೆ ಮರುಪಾವತಿ ಮಾಡುವಂತೆ ಅವನನ್ನು ಬಲವಂತಪಡಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ಯಾವನಾದರೂ ನೀವು ಕೊಟ್ಟ ಸಾಲಕ್ಕೆ ತನ್ನ ಅಂಗಿಯನ್ನು ಒತ್ತೆಯಾಗಿಟ್ಟರೆ, ಸೂರ್ಯನು ಮುಳುಗುವ ಮೊದಲೇ ನೀವು ಆ ಅಂಗಿಯನ್ನು ಅವನಿಗೆ ಹಿಂತಿರುಗಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ಯಾಕೆಂದರೆ ಅವನಿಗೆ ಬೇರೆ ಯಾವ ಹೊದಿಕೆಯೂ ಇಲ್ಲ; ಅದನ್ನೇ ಅವನು ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ಅವನು ಮಲಗಿಕೊಳ್ಳುವಾಗ ಚಳಿಯಿಂದ ನನಗೆ ಮೊರೆಯಿಟ್ಟರೆ, ನಾನು ಅವನ ಮೊರೆಯನ್ನು ಕೇಳಿ ಅವನಿಗೆ ದಯೆತೋರುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ನೀವು ದೇವರನ್ನಾಗಲಿ ಅಥವಾ ನಿಮ್ಮ ನಾಯಕರುಗಳನ್ನಾಗಲಿ ಶಪಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“ಸುಗ್ಗಿಕಾಲದಲ್ಲಿ ನೀವು ಪ್ರಥಮಫಲವಾದ ಧಾನ್ಯವನ್ನು ಮತ್ತು ನಿಮ್ಮ ಪ್ರಥಮಫಲವಾದ ದ್ರಾಕ್ಷಾರಸವನ್ನು ನನಗೆ ಕೊಡಬೇಕು. ನೀವು ಅದನ್ನು ನಿಮಗಾಗಿಯೇ ಇಟ್ಟುಕೊಳ್ಳಬಾರದು. “ನಿಮ್ಮ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನು ನನಗೆ ಪ್ರತಿಷ್ಠಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ಮಾತ್ರವಲ್ಲದೆ, ನಿಮ್ಮ ಕುರಿದನಗಳಲ್ಲಿ ಚೊಚ್ಚಲಾದವುಗಳನ್ನು ನನಗೆ ಅರ್ಪಿಸಬೇಕು. ಚೊಚ್ಚಲಾದವುಗಳು ತನ್ನ ತಾಯಿಯೊಂದಿಗೆ ಏಳು ದಿನಗಳಿರಲಿ. ಬಳಿಕ, ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಅದನ್ನು ನನಗೆ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“ನೀವು ನನ್ನ ವಿಶೇಷ ಜನರಾಗಿದ್ದೀರಿ. ಆದ್ದರಿಂದ ಕ್ರೂರಪ್ರಾಣಿಗಳಿಂದ ಕೊಲ್ಲಲ್ಪಟ್ಟ ಪ್ರಾಣಿಯ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಬಾರದು. ಅದನ್ನು ನಾಯಿಗಳು ತಿನ್ನಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ಬೇರೆಯವರ ವಿರುದ್ಧವಾಗಿ ಸುಳ್ಳು ಹೇಳಬೇಡಿರಿ. ನೀವು ನ್ಯಾಯಾಲಯದಲ್ಲಿ ದುಷ್ಟರ ಸಹಾಯಕ್ಕಾಗಿ ಸುಳ್ಳುಸಾಕ್ಷಿ ಹೇಳದಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“ದುಷ್ಕೃತ್ಯವನ್ನು ಮಾಡುವವರು ಬಹಳ ಮಂದಿಯೆಂದು ಅವರ ಜೊತೆಯಲ್ಲಿ ಸೇರಿಕೊಳ್ಳಬೇಡಿ. ಬಹಳ ಮಂದಿಯ ಮಾತಿಗೆ ಒಪ್ಪಿ ನ್ಯಾಯವನ್ನು ಕೆಡಿಸುವ ಸಾಕ್ಷಿಯನ್ನು ಹೇಳದಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“ಇದಲ್ಲದೆ ಬಡವನೆಂದು ಕರುಣಿಸಿ ಪಕ್ಷಪಾತದ ತೀರ್ಪನ್ನು ನೀಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“ನೀವು ಕಳೆದುಹೋದ ಎತ್ತನ್ನಾಗಲಿ ಕತ್ತೆಯನ್ನಾಗಲಿ ನೋಡಿದರೆ, ಆಗ ನೀವು ಅದನ್ನು ಅದರ ಮಾಲಿಕನಿಗೆ ಹಿಂತಿರುಗಿಸಬೇಕು. ಒಂದುವೇಳೆ ಆ ಮಾಲಿಕನು ನಿಮ್ಮ ವೈರಿಯಾಗಿದ್ದರೂ ನೀವು ಈ ಕಾರ್ಯವನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","“ಬಹು ತೂಕದ ಹೊರೆಯಿಂದ ನಡೆಯಲಾಗದೆ ಬಿದ್ದಿರುವ ಕತ್ತೆಯನ್ನು ನೀವು ನೋಡಿದರೆ ಅದನ್ನು ಎಬ್ಬಿಸಲು ನೀವು ನಿಂತು ಸಹಾಯ ಮಾಡಬೇಕು. ಆ ಕತ್ತೆಯು ನಿಮ್ಮ ವೈರಿಯದಾಗಿದ್ದರೂ ನೀವು ಅದಕ್ಕೆ ಸಹಾಯ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“ಬಡವರು ವ್ಯಾಜ್ಯವಾಡುವಾಗ ನೀವು ಅನ್ಯಾಯವಾದ ತೀರ್ಪನ್ನು ನೀಡಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“ನೀವು ಮೋಸದ ಕಾರ್ಯದಿಂದ ದೂರವಾಗಿರಬೇಕು. ನಿರಪರಾಧಿಯೂ ನೀತಿವಂತನೂ ಆಗಿರುವ ವ್ಯಕ್ತಿಗೆ ಮರಣದಂಡನೆ ವಿಧಿಸಲೇಬಾರದು. ಅಂಥ ದುಷ್ಟತ್ವವನ್ನು ಮಾಡಿದವನಿಗೆ ನಾನು ದಂಡನೆಯನ್ನು ವಿಧಿಸದೆ ಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“ಲಂಚವನ್ನು ತೆಗೆದುಕೊಳ್ಳಕೂಡದು; ಲಂಚವು ಕಣ್ಣುಳ್ಳವರನ್ನು ಕುರುಡರನ್ನಾಗಿ ಮಾಡುತ್ತದೆ; ನಿರಪರಾಧಿಗೆ ಅನ್ಯಾಯವನ್ನು ಬರಮಾಡುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“ನೀವು ಪರದೇಶಸ್ಥರಿಗೆ ತೊಂದರೆ ಕೊಡಬಾರದು. ನೀವು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಪರದೇಶಸ್ಥರಾಗಿದ್ದಿರೆಂಬುದನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ಆರು ವರ್ಷ ನಿಮ್ಮ ಭೂಮಿಯಲ್ಲಿ ಬೀಜಬಿತ್ತಿ ಬೆಳೆಯನ್ನು ಬೆಳೆಯಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ಆದರೆ ಏಳನೆಯ ವರ್ಷದಲ್ಲಿ ನಿಮ್ಮ ಭೂಮಿಯನ್ನು ಬೀಳುಬಿಡಿರಿ; ಬೀಜಬಿತ್ತಬೇಡಿರಿ. ಏಳನೆಯ ವರ್ಷ ನೀವು ಏನನ್ನೂ ಬೆಳೆಸಬಾರದು. ನಿಮ್ಮ ಭೂಮಿಯಲ್ಲಿ ಏನಾದರೂ ಬೆಳೆದರೆ ಅದನ್ನು ಬಡವರು ತಿನ್ನಲಿ. ಉಳಿದದ್ದನ್ನು ಪ್ರಾಣಿಗಳು ಮೇಯಲಿ. ನಿಮ್ಮ ದ್ರಾಕ್ಷಿತೋಟಗಳ ವಿಷಯದಲ್ಲಿಯೂ ಆಲಿವ್ ಮರಗಳ ತೋಪಿನ ವಿಷಯದಲ್ಲಿಯೂ ಇದೇ ನಿಯಮವನ್ನು ಪಾಲಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ಆರು ದಿನಗಳಲ್ಲಿ ನಿಮ್ಮ ಕೆಲಸ ಮಾಡಿರಿ. ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಿರಿ. ಏಳನೆಯ ದಿನದಲ್ಲಿ ನಿಮ್ಮ ಗುಲಾಮರೂ ಎತ್ತುಗಳೂ ಕತ್ತೆಗಳೂ ವಿದೇಶಿಯರೂ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ನೀವು ಈ ಆಜ್ಞೆಗಳಿಗೆಲ್ಲಾ ಜಾಗರೂಕತೆಯಿಂದ ವಿಧೇಯರಾಗಬೇಕು. ಸುಳ್ಳುದೇವರುಗಳನ್ನು ಆರಾಧಿಸಬೇಡಿರಿ. ನೀವು ಅವುಗಳ ಹೆಸರುಗಳನ್ನು ಉಚ್ಚರಿಸಲೂ ಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ಪ್ರತಿವರ್ಷ ನೀವು ಮೂರುಜಾತ್ರೆಗಳನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ತಿನ್ನಬೇಕಾದ ಹಬ್ಬ ಅವುಗಳಲ್ಲಿ ಒಂದಾಗಿದೆ. ನಾನು ನಿಮಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಈ ಜಾತ್ರೆಯಲ್ಲಿ ಏಳು ದಿನ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನು ನೀವು ತಿನ್ನಬೇಕು. ಈ ಹಬ್ಬವು ಏಳು ದಿನಗಳವರೆಗೆ ನಡೆಯುವುದು. ನೀವು ಇದನ್ನು ಅಬೀಬ್ ತಿಂಗಳಲ್ಲಿ ಮಾಡಬೇಕು. ಯಾಕೆಂದರೆ ಈ ತಿಂಗಳಲ್ಲಿಯೇ ನೀವು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಬಂದಿರಿ! ಈ ಹಬ್ಬದಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ನನಗೆ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“ಇದಲ್ಲದೆ ನೀವು ಸುಗ್ಗಿಯ ಜಾತ್ರೆಯನ್ನು ಆಚರಿಸಬೇಕು. ನೀವು ಬಿತ್ತಿದ ಹೊಲಗಳಲ್ಲಿ ಬೆಳೆಗಳನ್ನು ಕೊಯ್ಯುವ ಕಾಲದಲ್ಲಿ ಈ ಜಾತ್ರೆಯು ಆರಂಭವಾಗುವುದು. “ಇದಲ್ಲದೆ ಫಲಸಂಗ್ರಹ ಜಾತ್ರೆಯನ್ನೂ ನೀವು ಆಚರಿಸಬೇಕು. ವರ್ಷಾಂತ್ಯದಲ್ಲಿ ನೀವು ಹೊಲತೋಟಗಳ ಬೆಳೆಗಳನ್ನೆಲ್ಲಾ ಒಟ್ಟುಗೂಡಿಸುವ ಕಾಲದಲ್ಲಿ ಇದು ಆರಂಭವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“ಹೀಗೆ ಪ್ರತಿವರ್ಷ ಮೂರು ಸಲ ಗಂಡಸರೆಲ್ಲರೂ ಒಂದು ವಿಶೇಷ ಸ್ಥಳಕ್ಕೆ ದೇವರಾದ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಬರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ನೀವು ನನಗೆ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸುವಾಗ ಯಜ್ಞಪಶುವಿನ ರಕ್ತದೊಡನೆ ಹುಳಿಬೆರಸಿದ ಏನನ್ನೂ ಸಮರ್ಪಿಸಬಾರದು. ಅಲ್ಲದೆ ಅದರ ಮಾಂಸವನ್ನು ಒಂದೇ ದಿನದಲ್ಲಿ ತಿಂದು ಮುಗಿಸಬೇಕು; ಮರುದಿನದವರೆಗೂ ಇಟ್ಟುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“ಸುಗ್ಗಿ ಕಾಲದಲ್ಲಿ ನಿಮ್ಮ ಬೆಳೆಯ ಫಲವನ್ನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಆಲಯಕ್ಕೆ ತರಬೇಕು. “ಆಡುಮರಿಯನ್ನು ಅದರ ತಾಯಿಯ ಹಾಲಿನಲ್ಲಿ ಬೇಯಿಸಬಾರದು.” ");
INSERT INTO kan2010_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“ಇಗೋ, ನಿಮ್ಮ ಮುಂದೆ ನಾನು ಒಬ್ಬ ದೂತನನ್ನು ಕಳುಹಿಸುತ್ತಿದ್ದೇನೆ. ನಾನು ನಿಮಗಾಗಿ ಸಿದ್ಧಮಾಡಿದ ಸ್ಥಳಕ್ಕೆ ಈ ದೂತನು ನಿಮ್ಮನ್ನು ಮುನ್ನಡೆಸುವನು; ದಾರಿಯುದ್ದಕ್ಕೂ ಸಂರಕ್ಷಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ದೂತನಿಗೆ ವಿಧೇಯರಾಗಿ ಆತನನ್ನು ಹಿಂಬಾಲಿಸಿರಿ. ಆತನಿಗೆ ವಿರೋಧವಾಗಿ ದಂಗೆಯೇಳಬೇಡಿರಿ. ನೀವು ಅವಿಧೇಯರಾದರೆ ಆತನು ನಿಮ್ಮನ್ನು ಕ್ಷಮಿಸುವುದಿಲ್ಲ. ಆತನಲ್ಲಿ ನನ್ನ ಶಕ್ತಿಯು ಇರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ಆತನು ಹೇಳುವ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೀವು ವಿಧೇಯರಾಗಬೇಕು. ನನ್ನ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ನೀವು ಅನುಸರಿಸಬೇಕು. ಆಗ ನಾನು ನಿಮ್ಮ ಸಂಗಡ ಇರುವೆನು. ನಾನು ನಿಮ್ಮ ಶತ್ರುಗಳಿಗೆ ಶತ್ರುವಾಗಿರುವೆನು; ನಿಮಗೆ ಕೇಡುಮಾಡುವವರಿಗೆಲ್ಲಾ ಕೇಡುಮಾಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“ನನ್ನ ದೂತನು ನಿಮ್ಮ ಮುಂದೆ ನಡೆದು ಅಮೋರಿಯರು, ಹಿತ್ತಿಯರು, ಪೆರಿಜೀಯರು, ಕಾನಾನ್ಯರು, ಹಿವ್ವಿಯರು ಮತ್ತು ಯೆಬೂಸಿಯರು ಇರುವ ದೇಶಕ್ಕೆ ನಿಮ್ಮನ್ನು ನಡಿಸುವನು. ನಾನು ಅವರನ್ನೆಲ್ಲಾ ಸೋಲಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“ಅವರ ದೇವರುಗಳನ್ನು ಪೂಜಿಸಬೇಡಿರಿ. ಆ ದೇವರುಗಳಿಗೆ ನಮಸ್ಕರಿಸಬೇಡಿರಿ. ಅವರ ಆಚರಣೆಗಳನ್ನು ಅನುಸರಿಸಬೇಡಿರಿ. ನೀವು ಅವರ ವಿಗ್ರಹಗಳನ್ನು ನಾಶಮಾಡಬೇಕು. ಅವರ ಸ್ಮಾರಕ ಸ್ತಂಭಗಳನ್ನು ಕೆಡವಿಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ನೀವು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನನ್ನೇ ಆರಾಧಿಸಬೇಕು. ಆಗ ಆತನು ನಿಮ್ಮ ಅನ್ನಪಾನಗಳನ್ನು ಆಶೀರ್ವದಿಸುವನು. ನಾನು ನಿಮ್ಮೊಳಗಿಂದ ಎಲ್ಲಾ ವ್ಯಾಧಿಯನ್ನು ತೆಗೆದುಬಿಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ನಿಮ್ಮ ಸ್ತ್ರೀಯರು ಮಕ್ಕಳನ್ನು ಪಡೆಯಲು ಶಕ್ತರಾಗುವರು. ನಿಮ್ಮ ಮಕ್ಕಳು ಹುಟ್ಟುವಾಗಲೇ ಸಾಯುವುದಿಲ್ಲ; ನಿಮಗೆ ದೀರ್ಘಾಯುಷ್ಯವನ್ನು ಅನುಗ್ರಹಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“ನೀವು ನಿಮ್ಮ ವೈರಿಗಳ ವಿರುದ್ಧ ಯುದ್ಧ ಮಾಡುವಾಗ, ನಿಮ್ಮ ವೈರಿಗಳನ್ನೆಲ್ಲಾ ಸೋಲಿಸುವಂತೆ ನಾನು ನಿಮಗೆ ನನ್ನ ಮಹಾಶಕ್ತಿಯಿಂದ ಸಹಾಯ ಮಾಡುವೆನು. ನಿಮ್ಮ ವೈರಿಗಳು ಯುದ್ಧದಲ್ಲಿ ಭಯದಿಂದಲೂ ಗಲಿಬಿಲಿಯಿಂದಲೂ ಓಡಿಹೋಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ನಾನು ನಿಮ್ಮ ಮುಂದೆ ಹೆದ್ದುಂಬಿಯನ್ನು ಕಳುಹಿಸುವೆನು. ನಿಮ್ಮ ವೈರಿಗಳಾದ ಹಿವ್ವಿಯರನ್ನು ಕಾನಾನ್ಯರನ್ನು ಮತ್ತು ಹಿತ್ತಿಯರನ್ನು ಅದು ಬಲವಂತದಿಂದ ಅಟ್ಟಿಬಿಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ಆದರೆ ನಾನು ಒಂದೇ ವರ್ಷದಲ್ಲಿ ಅವರೆಲ್ಲರನ್ನೂ ಅಲ್ಲಿಂದ ಹೊರಡಿಸುವುದಿಲ್ಲ. ಯಾಕೆಂದರೆ ದೇಶದಲ್ಲಿ ಜನರು ಕಡಿಮೆಯಾಗುವುದರಿಂದ ಕ್ರೂರ ಪ್ರಾಣಿಗಳೆಲ್ಲಾ ಹೆಚ್ಚಾಗಿ ನಿಮಗೆ ಬಹಳ ತೊಂದರೆಯಾಗಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ಆದ್ದರಿಂದ ನೀವು ಅಭಿವೃದ್ಧಿಯಾಗಿ ದೇಶದಲ್ಲೆಲ್ಲಾ ತುಂಬಿಕೊಳ್ಳುವತನಕ ಅವರನ್ನು ಸ್ವಲ್ಪ ಸ್ವಲ್ಪವಾಗಿ ಹೊರದೂಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“ಕೆಂಪುಸಮುದ್ರದಿಂದ ಯೂಫ್ರೇಟೀಸ್ ನದಿಯವರೆಗೆ ಇರುವ ಪ್ರದೇಶವನ್ನೆಲ್ಲಾ ಕೊಡುವೆನು. ಪಶ್ಚಿಮ ಗಡಿಯು ಫಿಲಿಷ್ಟಿಯ ಸಮುದ್ರವಾಗಿರುವುದು (ಮೆಡಿಟರೇನಿಯನ್ ಸಮುದ್ರ) ಮತ್ತು ಪೂರ್ವ ಗಡಿಯು ಅರೇಬಿಯಾ ಮರುಭೂಮಿಯಾಗಿರುವುದು. ನೀವು ಅಲ್ಲಿ ವಾಸಿಸುವ ಜನರನ್ನು ಸೋಲಿಸುವಂತೆ ನಾನು ಮಾಡುವೆನು; ಅವರೆಲ್ಲರನ್ನು ನೀವು ಬಲವಂತವಾಗಿ ಹೊರಗಟ್ಟುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“ನೀವು ಆ ಜನರೊಡನೆಯಾಗಲಿ ಅವರ ದೇವರುಗಳೊಡನೆಯಾಗಲಿ ಯಾವ ಒಡಂಬಡಿಕೆಯನ್ನೂ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸಿಸಲು ಅವರನ್ನು ಬಿಡಬೇಡಿರಿ. ಇಲ್ಲವಾದರೆ ಅವರು ನಿಮ್ಮಲ್ಲಿ ದ್ರೋಹ ಬುದ್ಧಿಯನ್ನು ಹುಟ್ಟಿಸಬಹುದು. ನೀವು ಅವರ ದೇವರುಗಳನ್ನು ಪೂಜಿಸಿದರೆ ಆ ಪೂಜೆಯೂ ನಿಮಗೆ ಉರುಲಾಗುವುದು.” ");
INSERT INTO kan2010_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ದೇವರು ಮೋಶೆಗೆ, “ನೀನು ಆರೋನ, ನಾದ್ವಾ್, ಅಬೀಹೂ ಮತ್ತು ಇಸ್ರೇಲರ ಎಪ್ಪತ್ತು ಮಂದಿ ಹಿರಿಯರು ಬೆಟ್ಟವನ್ನೇರಿಬಂದು ದೂರದಿಂದ ನನ್ನನ್ನು ಆರಾಧಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ಬಳಿಕ ನೀನು ಮಾತ್ರ ನನ್ನ ಬಳಿಗೆ ಬರಬೇಕು; ಬೇರೆಯವರು ಬರಕೂಡದು; ಆದರೆ ಉಳಿದ ಜನರು ಬೆಟ್ಟವನ್ನೂ ಏರಕೂಡದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ಮೋಶೆಯು ಯೆಹೋವನ ಎಲ್ಲಾ ನಿಯಮಗಳನ್ನು ಮತ್ತು ಆಜ್ಞೆಗಳನ್ನು ಜನರಿಗೆ ತಿಳಿಸಿದನು. ಆಗ ಜನರೆಲ್ಲರೂ, “ಯೆಹೋವನ ಆಜ್ಞೆಗಳಿಗೆಲ್ಲಾ ನಾವು ವಿಧೇಯರಾಗುವೆವು” ಎಂದು ಒಂದೇ ಸ್ವರದಿಂದ ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ಆದ್ದರಿಂದ ಮೋಶೆ ಯೆಹೋವನ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲಾ ಒಂದು ಸುರುಳಿಯಲ್ಲಿ ಬರೆದನು. ಮರುದಿನ ಮುಂಜಾನೆ, ಅವನು ಬೇಗನೆ ಎದ್ದು ಬೆಟ್ಟದ ಕೆಳಭಾಗದ ಹತ್ತಿರ, ಹನ್ನೆರಡು ಕುಲಗಳಿಗೆ ಒಂದೊಂದರಂತೆ ಹನ್ನೆರಡು ಕಂಬಗಳುಳ್ಳ ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿಸಿದನು. ಇಸ್ರೇಲರ ಹನ್ನೆರಡು ಕುಲಗಳಿಗೆ ಒಂದೊಂದರಂತೆ ಹನ್ನೆರಡು ಕಲ್ಲುಗಳನ್ನು ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ಬಳಿಕ ಮೋಶೆಯು ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕೆ ಇಸ್ರೇಲರ ಯೌವನಸ್ಥರನ್ನು ಕಳುಹಿಸಿದನು. ಅವರು ಯೆಹೋವನಿಗೆ ಎತ್ತುಗಳನ್ನು ಸರ್ವಾಂಗಹೋಮಗಳಾಗಿಯೂ ಸಮಾಧಾನಯಜ್ಞಗಳಾಗಿಯೂ ಅರ್ಪಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ಮೋಶೆಯು ಈ ಪಶುಗಳ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ಅದರಲ್ಲಿ ಅರ್ಧಭಾಗವನ್ನು ಬೋಗುಣಿಗಳಲ್ಲಿ ಹಾಕಿದನು; ಉಳಿದ ಅರ್ಧಭಾಗವನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಸುರಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ವಿಶೇಷ ಒಡಂಬಡಿಕೆಯಿಂದ ಬರೆಯಲ್ಪಟ್ಟಿದ್ದ ಸುರುಳಿಯನ್ನು ಮೋಶೆಯು ಎಲ್ಲಾ ಜನರಿಗೆ ಕೇಳುವಂತೆ ಓದಿದನು. ಆಗ ಜನರು, “ಯೆಹೋವನ ಆಜ್ಞೆಗಳನ್ನೆಲ್ಲ ಅನುಸರಿಸಿ ಆತನಿಗೆ ವಿಧೇಯರಾಗಿರುತ್ತೇವೆ” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ಆಗ ಮೋಶೆ ಯಜ್ಞಗಳ ರಕ್ತದಿಂದ ತುಂಬಿದ ಬೋಗುಣಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಅದರಲ್ಲಿದ್ದ ರಕ್ತವನ್ನು ಜನರ ಮೇಲೆ ಚಿಮಿಕಿಸಿ, “ಈ ಸುರುಳಿಯಲ್ಲಿರುವ ವಾಕ್ಯಗಳಿಗನುಸಾರವಾಗಿ ಯೆಹೋವನು ನಿಮ್ಮೊಡನೆ ಒಂದು ವಿಶೇಷ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಂಡಿದ್ದಾನೆಂಬುದನ್ನು ಈ ರಕ್ತವು ಸೂಚಿಸುತ್ತದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ಬಳಿಕ ಮೋಶೆ, ಆರೋನ, ನಾದ್ವಾ, ಅಬೀಹೂ ಮತ್ತು ಇಸ್ರೇಲರ ಎಪ್ಪತ್ತು ಮಂದಿ ಹಿರಿಯರು ಬೆಟ್ಟವನ್ನೇರಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ಈ ಜನರು ಇಸ್ರೇಲರ ಯೆಹೋವನನ್ನು ನೋಡಿದರು. ದೇವರು ಆಕಾಶಮಂಡಲದಂತೆ ಅತಿ ನಿರ್ಮಲವಾದ ಇಂದ್ರನೀಲಮಣಿಯ ನೆಲಗಟ್ಟಿನ ಮೇಲೆ ನಿಂತುಕೊಂಡಿದ್ದನು! ");
INSERT INTO kan2010_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ಇಸ್ರೇಲರ ನಾಯಕರೆಲ್ಲರೂ ಯೆಹೋವನನ್ನು ನೋಡಿದರು, ಆದರೆ ದೇವರು ಅವರನ್ನು ನಾಶಮಾಡಲಿಲ್ಲ. ಅವರೆಲ್ಲರೂ ದೇವದರ್ಶನ ಮಾಡಿ ಅನ್ನಪಾನಗಳನ್ನು ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಬೆಟ್ಟವನ್ನು ಹತ್ತಿ ಬಂದು ನನ್ನ ಬಳಿಯಲ್ಲಿರು. ನಾನು ನನ್ನ ಉಪದೇಶಗಳನ್ನು ಮತ್ತು ಕಟ್ಟಳೆಗಳನ್ನು ಎರಡು ಕಲ್ಲಿನ ಹಲಗೆಗಳ ಮೇಲೆ ಬರೆದಿದ್ದೇನೆ. ಈ ಉಪದೇಶಗಳನ್ನು ಮತ್ತು ಕಟ್ಟಳೆಗಳನ್ನು ನೀನು ಜನರಿಗೆ ಬೋಧಿಸಬೇಕು. ನಾನು ಈ ಕಲ್ಲಿನ ಹಲಗೆಗಳನ್ನು ನಿನಗೆ ಕೊಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ಆದ್ದರಿಂದ ಮೋಶೆಯು ತನ್ನ ಶಿಷ್ಯನಾದ ಯೆಹೋಶುವನೊಡನೆ ಎದ್ದುನಿಂತು ದೇವರ ಬೆಟ್ಟದ ಮೇಲಕ್ಕೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ಮೋಶೆಯು ಹಿರಿಯರಿಗೆ, “ನಾವು ನಿಮ್ಮ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬರುವ ತನಕ ನೀವು ಇಲ್ಲಿ ಕಾದುಕೊಂಡಿರಿ. ಆರೋನನು ಮತ್ತು ಹೂರನು ನಿಮ್ಮ ಬಳಿಯಿದ್ದಾರೆ; ನಿಮ್ಮಲ್ಲಿ ಯಾರಿಗಾದರೂ ಸಮಸ್ಯೆಯಿದ್ದರೆ ಅವರ ಬಳಿಗೆ ಹೋಗಲಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ಬಳಿಕ ಮೋಶೆ ಬೆಟ್ಟದ ಮೇಲಕ್ಕೆ ಹೋದನು. ಮೋಡವು ಬೆಟ್ಟವನ್ನು ಕವಿದುಕೊಂಡಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ಸೀನಾಯಿ ಬೆಟ್ಟದ ಮೇಲೆ ಯೆಹೋವನ ಮಹಿಮೆಯು ಇಳಿದು ಬಂದಿತು. ಮೋಡವು ಆರುದಿನಗಳವರೆಗೆ ಬೆಟ್ಟವನ್ನು ಕವಿದುಕೊಂಡಿತ್ತು. ಏಳನೆಯ ದಿನದಲ್ಲಿ, ಮೋಡದಿಂದ ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ಇಸ್ರೇಲರಿಗೆ ಯೆಹೋವನ ಮಹಿಮೆಯು ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿ ಉರಿಯುವ ಬೆಂಕಿಯಂತೆ ಕಾಣುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ಬಳಿಕ ಮೋಶೆಯು ಮೋಡದಲ್ಲಿ ಬೆಟ್ಟದ ಮೇಲೆ ಇನ್ನೂ ಎತ್ತರಕ್ಕೆ ಹೋದನು. ಮೋಶೆಯು ಬೆಟ್ಟದಲ್ಲಿ ಹಗಲಿರುಳು ನಲವತ್ತು ದಿವಸ ಇದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ಇಸ್ರೇಲರು ನನಗೆ ಕಾಣಿಕೆಗಳನ್ನು ತರಬೇಕೆಂದು ಅವರಿಗೆ ಹೇಳು. ಪ್ರತಿಯೊಬ್ಬನು ನನಗೆ ಕೊಡುವುದರ ಬಗ್ಗೆ ತನ್ನ ಹೃದಯದಲ್ಲಿ ತೀರ್ಮಾನಿಸಿಕೊಳ್ಳಬೇಕು. ಈ ಕಾಣಿಕೆಗಳನ್ನು ನನಗಾಗಿ ಸ್ವೀಕರಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ಜನರಿಂದ ನೀನು ಸ್ವೀಕರಿಸಬೇಕಾದ ವಸ್ತುಗಳ ಪಟ್ಟಿ ಇಲ್ಲಿದೆ: ಚಿನ್ನ, ಬೆಳ್ಳಿ, ತಾಮ್ರ, ");
INSERT INTO kan2010_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರ, ನಾರುಬಟ್ಟೆ, ಆಡು ಕೂದಲಿನ ಬಟ್ಟೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ಕೆಂಪುಬಣ್ಣದ ಕುರಿದೊಗಲು, ಉತ್ತಮ ತೊಗಲುಗಳು, ಜಾಲೀಮರ, ");
INSERT INTO kan2010_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ದೀಪಗಳಿಗೆ ಬೇಕಾದ ಎಣ್ಣೆ, ಅಭಿಷೇಕತೈಲಕ್ಕೆ ಮತ್ತು ಪರಿಮಳಧೂಪಕ್ಕೆ ಬೇಕಾದ ಸುಗಂಧದ್ರವ್ಯಗಳು, ");
INSERT INTO kan2010_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ಏಪೋದಿಗೆ ದೈವನಿರ್ಣಯದ ಪದಕಚೀಲಕ್ಕೆ ಬೇಕಾದ ಗೋಮೇಧಕ ರತ್ನಗಳು ಮತ್ತು ಇತರ ರತ್ನಗಳು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ಇದಲ್ಲದೆ ದೇವರು ಮೋಶೆಗೆ, “ಜನರು ನನಗೋಸ್ಕರವಾಗಿ ಒಂದು ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಕಟ್ಟಬೇಕು. ಆಗ ನಾನು ಅವರ ನಡುವೆ ಅದರಲ್ಲಿ ವಾಸಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ಪವಿತ್ರ ಗುಡಾರ ಮತ್ತು ಅದರಲ್ಲಿರುವ ಪ್ರತಿಯೊಂದು ವಸ್ತುವೂ ಹೇಗಿರಬೇಕೆಂದು ನಾನು ನಿನಗೆ ತೋರಿಸುವೆನು. ನಾನು ನಿನಗೆ ತೋರಿಸುವ ಮಾದರಿಯ ಪ್ರಕಾರವೇ ಪ್ರತಿಯೊಂದನ್ನು ಮಾಡು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“ಜಾಲೀಮರದಿಂದ ಒಂದು ವಿಶೇಷ ಪೆಟ್ಟಿಗೆಯನ್ನು ಮಾಡಿಸು. ಈ ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಯು ಎರಡೂವರೆ ಮೊಳ ಉದ್ದ, ಒಂದೂವರೆ ಮೊಳ ಅಗಲ ಮತ್ತು ಒಂದೂವರೆ ಮೊಳ ಎತ್ತರ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ಅದರ ಹೊರಮೈಯನ್ನು ಮತ್ತು ಒಳಮೈಯನ್ನು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಹೊದಿಸಬೇಕು. ಪೆಟ್ಟಿಗೆಯ ಅಂಚುಗಳ ಸುತ್ತಲೂ ಚಿನ್ನದ ಗೋಟು ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ಪೆಟ್ಟಿಗೆಯನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗಲು ಅನುಕೂಲವಾಗುವಂತೆ ನಾಲ್ಕು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಎರಕಹೊಯ್ಯಬೇಕು. ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಅಂದರೆ ಒಂದೊಂದು ಕಡೆಯಲ್ಲಿ ಎರಡೆರಡು ಬಳೆಗಳನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ಬಳಿಕ ಪೆಟ್ಟಿಗೆಯನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗಲು ಅನುಕೂಲವಾಗುವಂತೆ ಕಂಬಗಳನ್ನು ಮಾಡಬೇಕು. ಈ ಕಂಬಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿ ಬಂಗಾರದಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ಕಂಬಗಳನ್ನು ಪೆಟ್ಟಿಗೆ ಕೊನೆಗಳಲ್ಲಿರುವ ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಿ ಪೆಟ್ಟಿಗೆಯನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ಕಂಬಗಳು ಯಾವಾಗಲೂ ಪೆಟ್ಟಿಗೆಯ ಬಳೆಗಳಲ್ಲಿ ಇರಬೇಕು. ಕಂಬಗಳನ್ನು ಅವುಗಳಿಂದ ಹೊರಗೆ ತೆಗೆಯಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“ನಾನು ನಿನಗೆ ಕೊಡುವ ಆಜ್ಞಾಶಾಸನವನ್ನು ಅದರೊಳಗೆ ಇಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ಇದಲ್ಲದೆ ದೇವರು ಮೋಶೆಗೆ, “ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಕೃಪಾಸನವನ್ನು ಮಾಡಿಸಬೇಕು. ಅದು ಎರಡೂವರೆ ಮೊಳ ಉದ್ದವಾಗಿರಬೇಕು. ಒಂದೂವರೆ ಮೊಳ ಅಗಲವಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ಬಳಿಕ ಕೆರೂಬಿಯರ ಎರಡು ಬಂಗಾರದ ಆಕಾರಗಳನ್ನು ಮಾಡಿಸಿ ಕೃಪಾಸನದ ಎರಡು ಕೊನೆಗಳಲ್ಲಿ ಇಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ಕೃಪಾಸನದ ಒಂದು ಕೊನೆಯಲ್ಲಿ ಒಂದು ಕೆರೂಬಿಯನ್ನೂ ಇನ್ನೊಂದು ಕೊನೆಯಲ್ಲಿ ಇನ್ನೊಂದು ಕೆರೂಬಿಯನ್ನೂ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ಅವುಗಳ ರೆಕ್ಕೆಗಳು ಆಕಾಶದ ಕಡೆಗೆ ಚಾಚಿರಬೇಕು; ಪೆಟ್ಟಿಗೆಯನ್ನು ಮುಚ್ಚಿಕೊಂಡಿರಬೇಕು. ಅವುಗಳ ಮುಖಗಳು ಎದುರುಬದುರಾಗಿ ಕೃಪಾಸನವನ್ನು ನೋಡುತ್ತಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“ನಾನು ನಿನಗೆ ಕೊಡುವ ಆಜ್ಞಾಶಾಸನವನ್ನು ಪೆಟ್ಟಿಗೆಯಲ್ಲಿಡಬೇಕು; ಕೃಪಾಸನವನ್ನು ಆ ಪೆಟ್ಟಿಗೆಯ ಮೇಲಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ನಾನು ನಿನಗೆ ದರ್ಶನ ಕೊಡುವಾಗ ಒಡಂಬಡಿಕೆ ಪೆಟ್ಟಿಗೆಯ ಮೇಲಿರುವ ಕೆರೂಬಿಗಳ ಮಧ್ಯದಿಂದ ನಿನ್ನ ಸಂಗಡ ಮಾತಾಡುವೆನು; ಇಸ್ರೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕಾದವುಗಳನ್ನು ನಿನಗೆ ತಿಳಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ನೀನು ಜಾಲೀಮರದಿಂದ ಮೇಜನ್ನು ಮಾಡಬೇಕು. ಮೇಜು ಎರಡು ಮೊಳ ಉದ್ದ, ಒಂದು ಮೊಳ ಅಗಲ ಮತ್ತು ಒಂದೂವರೆ ಮೊಳ ಎತ್ತರ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ಶುದ್ಧಬಂಗಾರದ ತಗಡುಗಳನ್ನು ಮೇಜಿಗೆ ಹೊದಿಸಿ ಅದರ ಸುತ್ತಲೂ ಚಿನ್ನದ ಗೋಟು ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ಬಳಿಕ ಮೇಜಿನ ಸುತ್ತಲೂ ಮೂರು ಇಂಚು ಅಗಲದ ಚೌಕಟ್ಟನ್ನು ಮಾಡಿಸಿ ಅದಕ್ಕೂ ಚಿನ್ನದ ಗೋಟು ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ಬಳಿಕ ನಾಲ್ಕು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿಸಿ ಮೇಜಿನ ನಾಲ್ಕು ಕಾಲುಗಳಿಗೆ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ಆ ಬಳೆಗಳು ಅಡ್ಡಪಟ್ಟಿಗೆ ಜೋಡಿಸಿಕೊಂಡಿರಬೇಕು. ಮೇಜನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗುವುದಕ್ಕೆ ಉಪಯೋಗಿಸುವ ಕೋಲುಗಳನ್ನು ಅವುಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ಆ ಕೋಲುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸಿ ಅವುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡನ್ನು ಹೊದಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ತಟ್ಟೆಗಳನ್ನು, ಚಮಚಗಳನ್ನು, ಹೂಜಿಗಳನ್ನು ಮತ್ತು ಬೋಗುಣಿಗಳನ್ನು ಶುದ್ಧಬಂಗಾರದಿಂದ ಮಾಡಬೇಕು. ಹೂಜಿಗಳನ್ನು ಮತ್ತು ಬೋಗುಣಿಗಳನ್ನು ಪಾನದ್ರವ್ಯಗಳನ್ನು ಅರ್ಪಿಸಲು ಉಪಯೋಗಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ನೈವೇದ್ಯದ ರೊಟ್ಟಿಗಳನ್ನು ಮೇಜಿನ ಮೇಲೆ ನನ್ನ ಮುಂದೆ ಇಡು. ಅವು ಅಲ್ಲಿ ನನ್ನ ಮುಂದೆ ಯಾವಾಗಲೂ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“ಬಳಿಕ ಒಂದು ದೀಪಸ್ತಂಭವನ್ನು ಶುದ್ಧಬಂಗಾರದಿಂದ ಮಾಡಿಸಬೇಕು. ಅದರ ಬುಡವನ್ನೂ ಕಂಬವನ್ನೂ ಕಸೂತಿ ಕೆಲಸದಿಂದ ಮಾಡಿಸಬೇಕು. ಆ ದೀಪಸ್ತಂಭವೆಲ್ಲಾ ಅಖಂಡವಾಗಿದ್ದು ಪುಷ್ಪಪಾತ್ರೆಗಳಂತೆಯೂ ಅಲಂಕಾರವಾಗಿ ಕೆತ್ತಲ್ಪಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“ದೀಪಸ್ತಂಭಕ್ಕೆ ಒಂದೊಂದು ಪಾರ್ಶ್ವದಲ್ಲಿ ಮೂರುಮೂರು ಕೊಂಬೆಗಳಂತೆ ಆರು ಕೊಂಬೆಗಳಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ಪ್ರತಿಯೊಂದು ಕೊಂಬೆಯಲ್ಲಿ ಬಾದಾಮಿ ಹೂವುಗಳಂತಿರುವ ಮೂರುಮೂರು ಪುಷ್ಪಾಲಂಕಾರಗಳಿರಬೇಕು. ಒಂದೊಂದು ಅಲಂಕಾರಕ್ಕೆ ಒಂದು ಪುಷ್ಪಪಾತ್ರೆಯೂ ಒಂದು ಪುಷ್ಪವೂ ಇರಬೇಕು. ಆರು ಕೊಂಬೆಗಳನ್ನೂ ಹಾಗೇ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ದೀಪದ ಸ್ತಂಭದಲ್ಲಿ ಪುಷ್ಪಪಾತ್ರೆಗಳೂ ಪುಷ್ಪಗಳೂ ಇರುವ ಬಾದಾಮಿ ಹೂವುಗಳಂತೆ ನಾಲ್ಕು ಪುಷ್ಪಾಲಂಕಾರಗಳು ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ಎರಡೆರಡು ಕೊಂಬೆಗಳು ಕವಲು ಒಡೆದಿರುವ ಸ್ಥಳಗಳಲ್ಲೆಲ್ಲಾ ಒಂದೊಂದು ಪುಷ್ಪಪಾತ್ರೆಯಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ಪುಷ್ಪಪಾತ್ರೆಗಳನ್ನೂ ಕೊಂಬೆಗಳನ್ನೂ ಒಳಗೊಂಡಿರುವ ದೀಪಸ್ತಂಭವು ಅಖಂಡವಾಗಿದ್ದು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದಲೂ ನಕಾಸಿ ಕೆಲಸದಿಂದಲೂ ಮಾಡಿದ್ದಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ಅದಕ್ಕೆ ಏಳು ಹಣತೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಈ ಹಣತೆಗಳು ದೀಪಸ್ತಂಭದ ಮುಂದಿರುವ ಪ್ರದೇಶಕ್ಕೆ ಬೆಳಕು ಕೊಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ಅದರ ಬತ್ತಿಗಳನ್ನು ಕತ್ತರಿಸುವ ಕತ್ತರಿಯನ್ನು ಮತ್ತು ಹರಿವಾಣಗಳನ್ನು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ದೀಪಸ್ತಂಭವನ್ನು ಮತ್ತು ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು ಎಪ್ಪತ್ತೈದು ಪೌಂಡು ");
INSERT INTO kan2010_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ನಾನು ನಿನಗೆ ಬೆಟ್ಟದ ಮೇಲೆ ತೋರಿಸಿದ ಮಾದರಿಯಂತೆಯೇ ಪ್ರತಿಯೊಂದನ್ನು ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಹತ್ತು ಪರದೆಗಳಿಂದ ಮಾಡಿಸಬೇಕು. ಈ ಪರದೆಗಳನ್ನು ನಾರುಬಟ್ಟೆ ಮತ್ತು ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕೆಂಪು ದಾರದಿಂದ ಮಾಡಿಸಬೇಕು. ನುರಿತ ಕೆಲಸಗಾರನು ಪರದೆಗಳಲ್ಲಿ ರೆಕ್ಕೆಗಳಿರುವ ಕೆರೂಬಿಗಳ ಚಿತ್ರವನ್ನು ಕಸೂತಿ ಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ಪ್ರತಿಯೊಂದು ಪರದೆಯ ಅಳತೆಯು ಒಂದೇ ಆಗಿರಬೇಕು. ಪ್ರತಿ ಪರದೆಯು ಇಪ್ಪತ್ತೆಂಟು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ನಾಲ್ಕು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಜೋಡಿಸಿ ಎರಡು ಭಾಗಗಳನ್ನಾಗಿ ಮಾಡಬೇಕು. ಒಂದು ಭಾಗದಲ್ಲಿ ಐದು ಪರದೆಗಳನ್ನೂ ಇನ್ನೊಂದು ಭಾಗದಲ್ಲಿ ಐದು ಪರದೆಗಳನ್ನೂ ಒಟ್ಟಾಗಿ ಜೋಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ಒಂದು ಭಾಗದ ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ಕುಣಿಕೆಗಳನ್ನು ನೀಲಿ ಬಟ್ಟೆಯಿಂದ ಮಾಡಬೇಕು; ಇನ್ನೊಂದು ಭಾಗದ ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿಯೂ ಅದೇ ರೀತಿ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ಒಂದು ಭಾಗದ ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳು ಇರಬೇಕು. ಇನ್ನೊಂದು ಭಾಗದ ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲೂ ಐವತ್ತು ಕುಣಿಕೆಗಳು ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ಬಳಿಕ ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಜೋಡಿಸಲು ಅನುಕೂಲವಾಗುವಂತೆ ಐವತ್ತು ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಹೀಗೆ ಒಂದೇ ಗುಡಾರವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“ಪವಿತ್ರಗುಡಾರದ ಮೇಲೆ ಹೊದಿಸುವುದಕ್ಕೆ ಇನ್ನೊಂದು ಗುಡಾರವನ್ನು ಮಾಡಿಸಬೇಕು. ಈ ಗುಡಾರವನ್ನು ಹನ್ನೊಂದು ಪರದೆಗಳಿಂದ ಮಾಡಿಸಬೇಕು. ಈ ಪರದೆಗಳು ಆಡುಕೂದಲಿನಿಂದ ಮಾಡಲ್ಪಟ್ಟಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ಈ ಎಲ್ಲಾ ಪರದೆಗಳ ಅಳತೆಯು ಒಂದೇ ಆಗಿರಬೇಕು. ಅವು ಮೂವತ್ತು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ನಾಲ್ಕು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ಐದು ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿ ಒಂದು ಭಾಗವನ್ನಾಗಿ ಮಾಡು. ಬಳಿಕ ಉಳಿದ ಆರು ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿ ಇನ್ನೊಂದು ಭಾಗವನ್ನಾಗಿ ಮಾಡು. ಆರನೇ ಪರದೆಯ ಅರ್ಧದಷ್ಟನ್ನು ಡೇರೆಯ ಮುಂದುಗಡೆಯಲ್ಲಿ ಮಡಚಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ಒಂದು ಭಾಗದ ಕೊನೇ ಪರದೆಯ ಕೆಳಗಿನ ಭಾಗದ ಅಂಚಿನಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಬೇಕು. ಇನ್ನೊಂದು ಭಾಗದ ಕೊನೇ ಪರದೆಯ ಕೆಳಭಾಗದಲ್ಲಿಯೂ ಅದೇ ರೀತಿಯಾಗಿ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ಬಳಿಕ ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಜೋಡಿಸಲು ಐವತ್ತು ತಾಮ್ರದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಬೇಕು. ಹೀಗೆ ಒಂದೇ ಗುಡಾರವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ಈ ಗುಡಾರದ ಪರದೆಗಳಲ್ಲಿ ಉಳಿದ ಹೆಚ್ಚಿನ ಭಾಗಗಳನ್ನು ಅಂದರೆ ಉಳಿದ ಅರ್ಧಭಾಗವನ್ನು ಪವಿತ್ರಗುಡಾರದ ಹಿಂಬದಿಯಲ್ಲಿ ತೂಗುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ಪಾರ್ಶ್ವಗಳಲ್ಲಿ ಈ ಗುಡಾರದ ಪರದೆಗಳು, ಪವಿತ್ರಗುಡಾರದ ಕೆಳಗಣ ಅಂಚುಗಳಿಂದ ಕೆಳಗೆ ಒಂದು ಮೊಳದಷ್ಟು ತೂಗಾಡುವವು. ಆದ್ದರಿಂದ ಈ ಡೇರೆಯು ಸಂಪೂರ್ಣವಾಗಿ ಪವಿತ್ರಗುಡಾರವನ್ನು ಮುಚ್ಚಿಕೊಳ್ಳುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ಹೊರಗಿನ ಗುಡಾರಕ್ಕೆ ಸರಿಹೊಂದುವ ಎರಡು ಹೊದಿಕೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಒಂದು ಹೊದಿಕೆಯನ್ನು ಕೆಂಪುಬಣ್ಣದ ಕುರಿದೊಗಲಿನ ಚರ್ಮದಿಂದ ಮಾಡಬೇಕು. ಇನ್ನೊಂದು ಹೊದಿಕೆಯನ್ನು ಉತ್ತಮ ತೊಗಲಿನಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“ಪವಿತ್ರಗುಡಾರದ ಚೌಕಟ್ಟುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ಚೌಕಟ್ಟುಗಳು ಹತ್ತುಮೊಳ ಎತ್ತರವಾಗಿಯೂ ಒಂದೂವರೆ ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ಪ್ರತಿ ಚೌಕಟ್ಟನ್ನು ಮಾಡುವುದಕ್ಕೆ ಎರಡು ಕಡೆಯ ಕೋಲುಗಳನ್ನು ಅಡ್ಡಪಟ್ಟಿಗಳೊಂದಿಗೆ ಒಟ್ಟಾಗಿ ಜೋಡಿಸಬೇಕು. ಪವಿತ್ರಗುಡಾರದ ಎಲ್ಲಾ ಚೌಕಟ್ಟುಗಳು ಒಂದೇ ರೀತಿಯಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ಪವಿತ್ರಗುಡಾರದ ದಕ್ಷಿಣ ಭಾಗಕ್ಕೆ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ಚೌಕಟ್ಟುಗಳಿಗೆ ನಲವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಿಸು. ಪ್ರತಿಯೊಂದು ಕಡೆಯ ಕಂಬಕ್ಕೆ ಒಂದು ಗದ್ದಿಗೇಕಲ್ಲಿನಂತೆ ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟಿಗೆ ಎರಡು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ಪವಿತ್ರಗುಡಾರದ ಇನ್ನೊಂದು ಕಡೆಗೆ ಅಂದರೆ, ಉತ್ತರದಿಕ್ಕಿನಲ್ಲಿಯೂ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟಿನ ಕೆಳಗೆ ಎರಡು ಗದ್ದಿಗೇಕಲ್ಲುಗಳು ಇರುವಂತೆ ಪ್ರತಿಯೊಂದು ಕಡೆಗೆ ನಲವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ಪವಿತ್ರಗುಡಾರದ ಹಿಂಭಾಗಕ್ಕೆ ಅಂದರೆ ಪಶ್ಚಿಮ ದಿಕ್ಕಿನಲ್ಲಿಯೂ ಆರು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ಪವಿತ್ರಗುಡಾರದ ಹಿಂಭಾಗದಲ್ಲಿರುವ ಮೂಲೆಗಳಿಗೆ ಎರಡು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ಮೂಲೆಗಳಲ್ಲಿರುವ ಚೌಕಟ್ಟುಗಳು ಕೆಳಗಿನ ಭಾಗದಲ್ಲಿ ಒಟ್ಟಾಗಿ ಜೋಡಿಸಿರಬೇಕು. ತುದಿಯಲ್ಲಿ ಒಂದು ಬಳೆಯು ಚೌಕಟ್ಟುಗಳನ್ನು ಒಟ್ಟಾಗಿ ಹಿಡಿದುಕೊಂಡಿರುವುದು. ಎರಡು ಮೂಲೆಗಳಿಗೂ ಅದೇ ರೀತಿಯಾಗಿ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ಗುಡಾರದ ಪಶ್ಚಿಮ ದಿಕ್ಕಿನ ಕೊನೆಯಲ್ಲಿ ಒಟ್ಟು ಎಂಟು ಚೌಕಟ್ಟುಗಳಿರುವವು. ಪ್ರತಿ ಚೌಕಟ್ಟಿನ ಕೆಳಗೆ ಎರಡು ಗದ್ದಿಗೇಕಲ್ಲುಗಳಂತೆ ಹದಿನಾರು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇಕಲ್ಲುಗಳಿರುವವು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“ಜಾಲೀಮರದಿಂದ ಪವಿತ್ರಗುಡಾರದ ಚೌಕಟ್ಟುಗಳಿಗೆ ಅಗುಳಿಗಳನ್ನು ಮಾಡಿಸು. ಪವಿತ್ರಗುಡಾರದ ಒಂದು ಭಾಗದಲ್ಲಿ ಐದು ಅಗುಳಿಗಳು ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ಪವಿತ್ರಗುಡಾರದ ಇನ್ನೊಂದು ಭಾಗದಲ್ಲಿ ಐದು ಅಗುಳಿಗಳು ಇರಬೇಕು. ಪವಿತ್ರಗುಡಾರದ ಹಿಂಭಾಗದಲ್ಲಿರುವ, ಅಂದರೆ ಪಶ್ಚಿಮ ಭಾಗದಲ್ಲಿರುವ ಚೌಕಟ್ಟುಗಳಿಗೆ ಐದು ಅಗುಳಿಗಳು ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ಮಧ್ಯದಲ್ಲಿರುವ ಅಗುಳಿಯು ಚೌಕಟ್ಟುಗಳ ಮೂಲಕ ಒಂದು ಕೊನೆಯಿಂದ ಇನ್ನೊಂದು ಕೊನೆಯವರೆಗೂ ಹಾದುಹೋಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","“ಚೌಕಟ್ಟುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡನ್ನು ಹೊದಿಸಬೇಕು; ಅಗುಳಿಗಳನ್ನು ಹಿಡಿದುಕೊಂಡಿರಲು ಚೌಕಟ್ಟುಗಳಿಗೆ ಬಳೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಮಾತ್ರವಲ್ಲದೆ ಅಗುಳಿಗಳನ್ನು ಚಿನ್ನದಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ನಾನು ನಿನಗೆ ಬೆಟ್ಟದಲ್ಲಿ ತೋರಿಸಿದ ಪ್ರಕಾರವೇ ಪವಿತ್ರಗುಡಾರವನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“ಪವಿತ್ರಗುಡಾರದ ಒಳಭಾಗವನ್ನು ವಿಂಗಡಿಸಲು ಉತ್ತಮವಾದ ಹುರಿನಾರಿನ ಬಟ್ಟೆಯಿಂದ ಒಂದು ವಿಶೇಷ ಪರದೆಯನ್ನು ಮಾಡಿಸಬೇಕು. ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕೆಂಪು ದಾರಗಳಿಂದ ಪರದೆಯ ಮೇಲೆ ಕೆರೂಬಿಗಳ ಚಿತ್ರಗಳನ್ನು ಕಸೂತಿಹಾಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ಜಾಲೀಮರದಿಂದ ನಾಲ್ಕು ಕಂಬಗಳನ್ನು ಮಾಡಿಸಿ ಅವುಗಳನ್ನು ಚಿನ್ನದಿಂದ ಹೊದಿಸಬೇಕು. ನಾಲ್ಕು ಕಂಬಗಳ ಮೇಲೆ ಚಿನ್ನದಿಂದ ಮಾಡಿದ ಕೊಂಡಿಗಳನ್ನು ಹಾಕಿಸಬೇಕು. ಕಂಬಗಳ ಕೆಳಗೆ ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಹಾಕಿಸಬೇಕು. ಬಳಿಕ ಚಿನ್ನದ ಕೊಂಡಿಗಳಲ್ಲಿ ಪರದೆಯನ್ನು ತೂಗುಹಾಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ಚಿನ್ನದ ಬಳೆಗಳ ಕೆಳಗೆ ಪರದೆಯನ್ನು ಹಾಕಿಸಬೇಕು; ಪರದೆಯ ಹಿಂಭಾಗದಲ್ಲಿ ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯನ್ನು ಇಡಬೇಕು. ಈ ಪರದೆಯು ಪವಿತ್ರ ಸ್ಥಳವನ್ನು ಮಹಾಪವಿತ್ರ ಸ್ಥಳದಿಂದ ಪ್ರತ್ಯೇಕಿಸುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ಮಹಾಪವಿತ್ರ ಸ್ಥಾನದಲ್ಲಿರುವ ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯ ಮೇಲೆ ಕೃಪಾಸನವನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“ಪರದೆಯ ಇನ್ನೊಂದು ಭಾಗದಲ್ಲಿ ನೀನು ಮಾಡಿಸಿದ ವಿಶೇಷ ಮೇಜನ್ನು ಇಡಬೇಕು. ಮೇಜು ಪರಿಶುದ್ಧ ಗುಡಾರದ ಉತ್ತರಭಾಗದಲ್ಲಿರಬೇಕು. ಬಳಿಕ ದೀಪಸ್ತಂಭವನ್ನು ದಕ್ಷಿಣಭಾಗದಲ್ಲಿಡಬೇಕು. ಇದು ಮೇಜಿನ ಎದುರಿಗೆ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“ಬಳಿಕ ಪವಿತ್ರಗುಡಾರದ ಪ್ರವೇಶಸ್ಥಳವನ್ನು ಮುಚ್ಚುವುದಕ್ಕೆ ಒಂದು ಪರದೆಯನ್ನು ಮಾಡಿಸಬೇಕು. ಈ ಪರದೆಯನ್ನು ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪು ದಾರಗಳಿಂದ ಮತ್ತು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯಿಂದ ಮಾಡಿಸಿ ಅದರಲ್ಲಿ ಚಿತ್ರಗಳನ್ನು ಕಸೂತಿ ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ಈ ಪರದೆಗೆ ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಜಾಲೀಮರದಿಂದ ಐದು ಕಂಬಗಳನ್ನು ಮಾಡಿಸಿ ಅವುಗಳಿಗೆ ಚಿನ್ನದ ತಗಡನ್ನು ಹೊದಿಸಬೇಕು ಮತ್ತು ಈ ಕಂಬಗಳಿಗೆ ಐದು ತಾಮ್ರದ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಜಾಲೀಮರದಿಂದ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಮಾಡಿಸಬೇಕು. ಈ ಯಜ್ಞವೇದಿಕೆಯು ಚೌಕವಾಗಿರಬೇಕು. ಅದು ಐದು ಮೊಳ ಉದ್ದ, ಐದು ಮೊಳ ಅಗಲ ಮತ್ತು ಮೂರು ಮೊಳ ಎತ್ತರ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ಈ ಯಜ್ಞವೇದಿಕೆಯ ನಾಲ್ಕು ಮೂಲೆಗಳಿಗೆ ನಾಲ್ಕು ಕೊಂಬುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಪ್ರತಿಯೊಂದು ಕೊಂಬೂ ಯಜ್ಞವೇದಿಕೆಗೆ ಜೋಡಿಸಲ್ಪಟ್ಟಿರಬೇಕು. ಹೀಗೆ ಅವು ಯಜ್ಞವೇದಿಕೆಯ ಅವಿಭಾಜ್ಯ ಭಾಗವಾಗಿರಬೇಕು. ಬಳಿಕ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ತಾಮ್ರದ ತಗಡಿನಿಂದ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","“ಯಜ್ಞವೇದಿಕೆಯ ಉಪಕರಣಗಳನ್ನೆಲ್ಲಾ ತಾಮ್ರದಿಂದ ಮಾಡಿಸಬೇಕು. ಬಟ್ಟಲುಗಳನ್ನು, ಸಲಿಕೆಗಳನ್ನು, ಬೋಗುಣಿಗಳನ್ನು, ಮುಳ್ಳುಗಳನ್ನು ಮತ್ತು ಅಗ್ಗಿಷ್ಟಿಕೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಇವುಗಳನ್ನು ಯಜ್ಞವೇದಿಕೆಯಿಂದ ಬೂದಿಯನ್ನು ತೆಗೆದು ಶುಚಿಗೊಳಿಸುವುದಕ್ಕೆ ಉಪಯೋಗಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ಯಜ್ಞವೇದಿಕೆಗೆ ಹೆಣಿಗೇ ಕೆಲಸದಿಂದ ತಾಮ್ರದ ಜಾಳಿಗೆ ಮಾಡಿಸಬೇಕು. ಈ ಜಾಳಿಗೆಯ ನಾಲ್ಕುಮೂಲೆಗಳಲ್ಲಿ ನಾಲ್ಕು ತಾಮ್ರದ ಬಳೆಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ಆ ಜಾಳಿಗೆಯು ಯಜ್ಞವೇದಿಕೆಯ ಸುತ್ತಲಿರುವ ಕಟ್ಟೆಯ ಕೆಳಗೆ ಇದ್ದು ಯಜ್ಞವೇದಿಕೆಯ ಬುಡದಿಂದ ಅರ್ಧದಷ್ಟು ಮೇಲಕ್ಕೆ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","“ಯಜ್ಞವೇದಿಕೆಗೆ ಕೋಲುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸಿ ಅವುಗಳಿಗೆ ತಾಮ್ರದ ತಗಡನ್ನು ಹೊದಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ಯಜ್ಞವೇದಿಕೆಯ ಎರಡು ಕಡೆಗಳಲ್ಲಿರುವ ಬಳೆಗಳಲ್ಲಿ ಕೋಲುಗಳನ್ನು ಸೇರಿಸಬೇಕು. ಈ ಕೋಲುಗಳಿಂದ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ಯಜ್ಞವೇದಿಕೆಯ ಪಾರ್ಶ್ವಗಳನ್ನು ಹಲಗೆಗಳಿಂದ ಮಾಡಿಸಬೇಕು. ನಾನು ಬೆಟ್ಟದ ಮೇಲೆ ನಿನಗೆ ತೋರಿಸಿದ ಪ್ರಕಾರವೇ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“ಪವಿತ್ರಗುಡಾರಕ್ಕೆ ಅಂಗಳವನ್ನು ಮಾಡಿಸಬೇಕು. ದಕ್ಷಿಣ ದಿಕ್ಕಿನಲ್ಲಿ ನೂರು ಮೊಳ ಉದ್ದದ ಪರದೆಗಳ ಗೋಡೆಯಿರಬೇಕು. ಈ ಪರದೆಗಳನ್ನು ಉತ್ತಮ ನಾರುಬಟ್ಟೆಯಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ಇಪ್ಪತ್ತು ಕಂಬಗಳನ್ನು ಮತ್ತು ಆ ಕಂಬಗಳಿಗೆ ಇಪ್ಪತ್ತು ತಾಮ್ರದ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಕಂಬಗಳಿಗೆ ಬೆಳ್ಳಿಯ ಕೊಂಡಿಗಳನ್ನು ಮತ್ತು ಪರದೆಯ ಕೋಲುಗಳಿಗೆ ಬೆಳ್ಳಿಯ ಕಂಬಿಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ಉತ್ತರ ದಿಕ್ಕಿನಲ್ಲಿ ಸಹ ನೂರು ಮೊಳ ಉದ್ದದ ಪರದೆಗಳ ಗೋಡೆಯಿರಬೇಕು. ಅದಕ್ಕೆ ಇಪ್ಪತ್ತು ಕಂಬಿಗಳು ಮತ್ತು ಇಪ್ಪತ್ತು ತಾಮ್ರದ ಗದ್ದಿಗೇಕಲ್ಲುಗಳು ಇರಬೇಕು. ಕಂಬಗಳ ಕೊಂಡಿಗಳನ್ನು ಮತ್ತು ಪರದೆಯ ಕಟ್ಟುಗಳನ್ನು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“ಪಶ್ಚಿಮದಿಕ್ಕಿನಲ್ಲಿ ಅಂಗಳದ ಅಗಲಕ್ಕೆ ಐವತ್ತು ಮೊಳ ಉದ್ದದ ಪರದೆಗಳೂ ಹತ್ತು ಕಂಬಗಳೂ ಮತ್ತು ಹತ್ತು ಗದ್ದಿಗೇಕಲ್ಲುಗಳೂ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ಅಂಗಳದ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಐವತ್ತು ಮೊಳ ಉದ್ದ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ಈ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಅಂಗಳದ ಪ್ರವೇಶದ್ವಾರವಿರುತ್ತದೆ. ಪ್ರವೇಶದ್ವಾರದ ಒಂದು ಕಡೆಯಲ್ಲಿ ಹದಿನೈದು ಮೊಳ ಉದ್ದದ ಪರದೆಗಳು, ಮೂರು ಕಂಬಗಳು ಮತ್ತು ಮೂರು ಗದ್ದಿಗೇಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ಇನ್ನೊಂದು ಕಡೆಯಲ್ಲಿ ಹದಿನೈದು ಮೊಳ ಉದ್ದದ ಪರದೆಗಳು, ಮೂರು ಕಂಬಗಳು; ಮೂರು ಗದ್ದಿಗೇಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“ಅಂಗಳದ ದ್ವಾರವನ್ನು ಮುಚ್ಚುವುದಕ್ಕೆ ಇಪ್ಪತ್ತು ಮೊಳ ಉದ್ದದ ಪರದೆಯನ್ನು ಮಾಡಿಸಬೇಕು. ಪರದೆಯನ್ನು ಉತ್ತಮ ನಾರಿನ ಬಟ್ಟೆಯಿಂದ ಮತ್ತು ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕೆಂಪು ದಾರಗಳಿಂದ ಮಾಡಿಸಬೇಕು. ಆ ಪರದೆಯಲ್ಲಿ ಅಲಂಕೃತವಾದ ಚಿತ್ರಗಳನ್ನು ಬುಟೇದಾರೀ ಕೆಲಸದವರಿಂದ ಮಾಡಿಸಬೇಕು. ಆ ಪರದೆಗೆ ನಾಲ್ಕು ಕಂಬಗಳು ಮತ್ತು ನಾಲ್ಕು ಗದ್ದಿಗೇಕಲ್ಲುಗಳು ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ಅಂಗಳದ ಸುತ್ತಲಿರುವ ಕಂಬಗಳನ್ನೆಲ್ಲ ಬೆಳ್ಳಿಯ ಪರದೆ ಕೋಲುಗಳೊಡನೆ ಜೋಡಿಸಬೇಕು. ಕಂಬಗಳ ಕೊಂಡಿಗಳನ್ನು ಬೆಳ್ಳಿಯಿಂದಲೂ ಕಂಬಗಳ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ತಾಮ್ರದಿಂದಲೂ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ಅಂಗಳವು ನೂರು ಮೊಳ ಉದ್ದ ಮತ್ತು ಐವತ್ತು ಮೊಳ ಅಗಲ ಇರಬೇಕು. ಅಂಗಳದ ಸುತ್ತಲಿರುವ ಪರದೆಗಳ ಗೋಡೆಯು ಐದು ಮೊಳ ಎತ್ತರವಿರಬೇಕು. ಪರದೆಗಳನ್ನು ಉತ್ತಮ ನಾರುಬಟ್ಟೆಯಿಂದ ಮಾಡಿಸಬೇಕು. ಕಂಬಗಳ ಕೆಳಗಿರುವ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ತಾಮ್ರದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ಪವಿತ್ರಗುಡಾರದ ಉಪಕರಣಗಳನ್ನೂ ಗುಡಾರದ ಗೂಟಗಳನ್ನೂ ಗುಡಾರದ ಸುತ್ತಲೂ ಇರುವ ಪರದೆಯ ಗೂಟಗಳನ್ನೂ ತಾಮ್ರದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“ಉತ್ತಮವಾದ ಆಲಿವ್‌ಎಣ್ಣೆಯನ್ನು ತರಬೇಕೆಂದು ಇಸ್ರೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸು. ಪ್ರತಿ ಸಾಯಂಕಾಲ ಉರಿಸುವ ದೀಪಕ್ಕೆ ಈ ಎಣ್ಣೆಯನ್ನು ಉಪಯೋಗಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ಆರೋನ ಮತ್ತು ಅವನ ಗಂಡುಮಕ್ಕಳಿಗೆ ದೀಪವನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಕೆಲಸವಿರುವುದು. ಅವರು ದೇವದರ್ಶನಗುಡಾರದ ಮೊದಲಿನ ಕೋಣೆಯೊಳಗೆ ಹೋಗುವರು. ಇದು ಎರಡು ಕೋಣೆಗಳನ್ನು ಪ್ರತ್ಯೇಕಿಸುವ ಪರದೆಯ ಹಿಂದೆ ಒಪ್ಪಂದವಿರುವ ಕೋಣೆಯ ಹೊರಗೆ ಇರುತ್ತದೆ. ಈ ಸ್ಥಳದಲ್ಲಿ ದೀಪವು ಯೆಹೋವನ ಮುಂದೆ ಸಾಯಂಕಾಲದಿಂದ ಮುಂಜಾನೆಯವರೆಗೆ ಯಾವಾಗಲೂ ಉರಿಯುತ್ತಿರುವಂತೆ ಅವರು ನೋಡಿಕೊಳ್ಳುವರು. ಇಸ್ರೇಲರು ಮತ್ತು ಅವರ ಸಂತತಿಯವರು ಈ ನಿಯಮಕ್ಕೆ ಶಾಶ್ವತವಾಗಿ ವಿಧೇಯರಾಗಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಇಸ್ರೇಲರಿಂದ ನಿನ್ನ ಬಳಿಗೆ ಬರಲು ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನಿಗೂ ಅವನ ಗಂಡುಮಕ್ಕಳಾದ ನಾದ್ವಾ್, ಅಬೀಹೂ, ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಎಂಬವರಿಗೂ ಹೇಳು. ಇವರು ಯಾಜಕರಾಗಿ ನನ್ನ ಸೇವೆ ಮಾಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನಿಗೆ ವಿಶೇಷ ಬಟ್ಟೆಗಳನ್ನು ಮಾಡಿಸು. ಈ ಬಟ್ಟೆಗಳು ಅವನಿಗೆ ಘನತೆಯನ್ನೂ ಗೌರವವನ್ನೂ ನೀಡುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ಈ ಬಟ್ಟೆಗಳನ್ನು ಮಾಡುವಂಥ ಕೆಲವು ನಿಪುಣರಿದ್ದಾರೆ. ನಾನು ಅವರಿಗೆ ವಿಶೇಷ ಜ್ಞಾನವನ್ನು ಕೊಟ್ಟಿದ್ದೇನೆ. ಆರೋನನಿಗೆ ಬೇಕಾದ ಬಟ್ಟೆಗಳನ್ನು ಮಾಡಲು ಅವರಿಗೆ ಹೇಳು. ಅವನು ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ನನ್ನ ಸೇವೆಮಾಡುತ್ತಾನೆಂದು ಈ ಬಟ್ಟೆಗಳು ತೋರಿಸುತ್ತವೆ. ಆಗ ಅವನು ಯಾಜಕನಾಗಿ ನನ್ನ ಸೇವೆ ಮಾಡಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ಅವರು ಮಾಡತಕ್ಕ ಬಟ್ಟೆಗಳು ಯಾವುವೆಂದರೆ: ದೈವನಿರ್ಣಯಕ ಪದಕ, ಏಫೋದು, ನೀಲಿಯ ನಿಲುವಂಗಿ, ಹೆಣೆದ ಬಿಳಿಯ ನಿಲುವಂಗಿ, ಮುಂಡಾಸು ಮತ್ತು ನಡುಕಟ್ಟು. ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನಿಗೂ ಅವನ ಗಂಡುಮಕ್ಕಳಿಗೂ ಈ ವಿಶೇಷ ಬಟ್ಟೆಗಳನ್ನು ಅವರು ಮಾಡಬೇಕು. ಆಗ ಆರೋನನೂ ಅವನ ಗಂಡುಮಕ್ಕಳೂ ಯಾಜಕರಾಗಿ ನನ್ನ ಸೇವೆಮಾಡಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ಚಿನ್ನದ ದಾರಗಳು, ನಾರುಬಟ್ಟೆ, ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕೆಂಪುದಾರಗಳನ್ನು ಉಪಯೋಗಿಸಲು ಅವರಿಗೆ ಹೇಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ಏಫೋದನ್ನು ಚಿನ್ನದ ದಾರಗಳು, ನಾರಿನಬಟ್ಟೆ, ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕೆಂಪುದಾರಗಳನ್ನು ಉಪಯೋಗಿಸಿ ಚಾಣಾಕ್ಷತೆಯಿಂದ ಹೆಣೆದು ತಯಾರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ಏಫೋದಿನ ಪ್ರತಿಭುಜದಲ್ಲಿ ಭುಜದ ಪಟ್ಟಿಯಿರಬೇಕು. ಭುಜದ ಈ ಪಟ್ಟಿಗಳು ಏಫೋದಿನ ಎರಡು ಕೊನೆಗಳಿಗೆ ಕಟ್ಟಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","“ಇವರು ಏಫೋದಿಗೆ ಸೇರಿಸಲ್ಪಟ್ಟಿರುವ ನಡುಕಟ್ಟನ್ನು ಬಹಳ ಎಚ್ಚರಿಕೆಯಿಂದ ಹೆಣೆಯಬೇಕು. ಏಫೋದನ್ನು ತಯಾರಿಸಿದಂತೆಯೇ ಈ ನಡುಕಟ್ಟನ್ನು ತಯಾರಿಸಬೇಕು. ಚಿನ್ನದ ದಾರಗಳು, ನಾರುಬಟ್ಟೆ, ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕೆಂಪುದಾರಗಳನ್ನು ಉಪಯೋಗಿಸಿ ಇದನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“ಎರಡು ಗೋಮೇಧಕ ರತ್ನಗಳನ್ನು ತೆಗೆದುಕೊ. ಈ ರತ್ನಗಳ ಮೇಲೆ ಇಸ್ರೇಲನ ಹನ್ನೆರಡು ಗಂಡುಮಕ್ಕಳ ಹೆಸರನ್ನು ಬರೆಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ಒಂದು ರತ್ನದ ಮೇಲೆ ಆರು ಹೆಸರುಗಳನ್ನೂ ಇನ್ನೊಂದು ರತ್ನದ ಮೇಲೆ ಆರು ಹೆಸರುಗಳನ್ನೂ ಬರೆಸು. ಹಿರಿಮಗನಿಂದ ಹಿಡಿದು ಕಿರಿ ಮಗನವರೆಗೆ ಕ್ರಮಾನುಸಾರವಾಗಿ ಹೆಸರುಗಳನ್ನು ಬರೆಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ಈ ಕಲ್ಲುಗಳ ಮೇಲೆ ಇಸ್ರೇಲನ ಗಂಡುಮಕ್ಕಳ ಹೆಸರನ್ನು ಕೆತ್ತಿಸು. ಒಬ್ಬ ಕೆಲಸಗಾರನು ಮುದ್ರೆಯನ್ನು ಮಾಡುವ ರೀತಿಯಲ್ಲಿ ಇದನ್ನು ಮಾಡಿಸು. ಚಿನ್ನದ ಕುಂದಣದಲ್ಲಿ ರತ್ನಗಳನ್ನಿಡು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ಬಳಿಕ ಈ ಎರಡು ರತ್ನಗಳನ್ನು ಏಫೋದಿನ ಪ್ರತಿಭುಜದ ಪಟ್ಟಿಯಲ್ಲಿಡು. ಆರೋನನು ಯೆಹೋವನ ಮುಂದೆ ನಿಲ್ಲುವಾಗ ಈ ವಿಶೇಷ ಅಂಗಿಯನ್ನು ಧರಿಸಿಕೊಂಡಿರುವನು. ಇಸ್ರೇಲನ ಗಂಡುಮಕ್ಕಳ ಹೆಸರುಗಳುಳ್ಳ ಎರಡು ರತ್ನಗಳು ಏಫೋದಿನ ಮೇಲಿರುತ್ತವೆ. ದೇವರು ಇಸ್ರೇಲರನ್ನು ಜ್ಞಾಪಿಸಿಕೊಳ್ಳುವಂತೆ ಈ ರತ್ನಗಳು ಮಾಡುವವು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ಏಫೋದಿನಲ್ಲಿ ಕಲ್ಲುಗಳು ಬಿಗಿಯಾಗಿ ಹಿಡಿದುಕೊಂಡಿರಲು ಉತ್ತಮ ಚಿನ್ನವನ್ನು ಉಪಯೋಗಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ಹೆಣಿಗೆ ಕೆಲಸದಿಂದ ಶುದ್ಧಬಂಗಾರದ ಎರಡು ಸರಪಣಿಗಳನ್ನು ಮಾಡಿಸಿ ಚಿನ್ನದ ಗೂಡುಗಳಿಗೆ ಬಿಗಿಯಾಗಿ ಸಿಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“ಮಹಾಯಾಜಕನಿಗೆ ದೈವನಿರ್ಣಯದ ಪದಕವನ್ನು ಮಾಡಿಸು. ಏಫೋದನ್ನು ಮಾಡಿಸಿದಂತೆ ನಿಪುಣರಾದ ಕೆಲಸಗಾರರಿಂದ ಇದನ್ನು ಮಾಡಿಸಬೇಕು. ಚಿನ್ನದ ದಾರಗಳು, ಉತ್ಕೃಷ್ಟವಾದ ನಾರುಬಟ್ಟೆ, ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕೆಂಪು ದಾರಗಳನ್ನು ಉಪಯೋಗಿಸಿ ಇದನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ಅದು ಚೌಕವಾಗಿದ್ದು ಒಂಭತ್ತು ಇಂಚು ಉದ್ದವಾಗಿಯೂ ಒಂಭತ್ತು ಇಂಚು ಅಗಲವಾಗಿಯೂ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ಅದರ ಮೇಲೆ ಅಂದವಾದ ರತ್ನಗಳನ್ನು ನಾಲ್ಕು ಸಾಲುಗಳಾಗಿ ಹಾಕಿಸಬೇಕು. ರತ್ನಗಳ ಮೊದಲಿನ ಸಾಲಿನಲ್ಲಿ ಮಾಣಿಕ್ಯ, ಪುಷ್ಪರಾಗ, ಸ್ಪಟಿಕಗಳಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ಎರಡನೆಯ ಸಾಲಿನಲ್ಲಿ ಕೆಂಪರಲು, ನೀಲ, ಪಚ್ಚೆಗಳಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ಮೂರನೆಯ ಸಾಲಿನಲ್ಲಿ ಸುವರ್ಣರತ್ನ, ಗೋಮೇಧಕ ಮತ್ತು ಧೂಮ್ರಮಣಿಗಳಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ನಾಲ್ಕನೆಯ ಸಾಲಿನಲ್ಲಿ ಪೀತ ರತ್ನ, ಗೋಮೇಧಕರತ್ನ, ವೈಡೂರ್ಯಗಳಿರಬೇಕು. ಈ ಎಲ್ಲಾ ರತ್ನಗಳನ್ನು ಚಿನ್ನದ ಜವೆಯ ಕಲ್ಲುಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ಇಸ್ರೇಲನ ಗಂಡುಮಕ್ಕಳಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನಿಗೆ ಒಂದೊಂದು ರತ್ನದಂತೆ ದೈವನಿರ್ಣಯ ಪದಕದಲ್ಲಿ ಹನ್ನೆರಡು ರತ್ನಗಳಿರಬೇಕು. ಪ್ರತಿಯೊಂದು ಕಲ್ಲುಗಳಲ್ಲಿ ಇಸ್ರೇಲನ ಗಂಡುಮಕ್ಕಳ ಒಬ್ಬೊಬ್ಬರ ಹೆಸರನ್ನು ಬರೆಸಬೇಕು. ಒಬ್ಬ ಕೆಲಸಗಾರನು ಮುದ್ರೆಯನ್ನು ಕೆತ್ತುವಂತೆ ಈ ಹೆಸರುಗಳನ್ನು ಪ್ರತಿ ರತ್ನದ ಮೇಲೆ ಕೆತ್ತಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ದೈವನಿರ್ಣಯ ಪದಕದಲ್ಲಿ ಶುದ್ಧಬಂಗಾರದ ಸರಪಣಿಗಳನ್ನು ಮಾಡಿಸು. ಈ ಸರಪಣಿಗಳು ಹುರಿಗಳಂತಿರುವ ಹಗ್ಗದಂತೆ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ಬಂಗಾರದ ಎರಡು ಬಳೆಗಳನ್ನು ಮಾಡಿಸಿ ಅದರ ಎರಡು ಕೊನೆಗಳಲ್ಲಿ ಸಿಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ಅದರ ಕೊನೆಯಲ್ಲಿರುವ ಎರಡು ಬಳೆಗಳ ಮೂಲಕ ಚಿನ್ನದ ಎರಡು ಸರಪಣಿಗಳನ್ನು ಸಿಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ಚಿನ್ನದ ಸರಪಣಿಗಳ ಇನ್ನೊಂದು ಕೊನೆಗಳನ್ನು ಎರಡು ಪಟ್ಟಿಗಳಿಗೆ ಬಿಗಿಯಾಗಿ ಕಟ್ಟಿಸಬೇಕು. ಇದು ಮುಂಬದಿಯಲ್ಲಿರುವ ಏಫೋದಿನ ಎರಡು ಭುಜದ ಪಟ್ಟಿಗಳಿಗೆ ಬಿಗಿಯಾಗಿ ಹಿಡಿದುಕೊಂಡಿರುವಂತೆ ಮಾಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ಇನ್ನೂ ಎರಡು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿಸಿ, ಅವುಗಳನ್ನು ದೈವನಿರ್ಣಯದ ಪದಕದ ಬೇರೆ ಎರಡು ಕೊನೆಗಳಿಗೆ ಸಿಕ್ಕಿಸು. ಇದು ದೈವನಿರ್ಣಯದ ಪದಕದ ಒಳಗಣ ಅಂಚಿನಲ್ಲಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ಇನ್ನೆರಡು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿಸಿ ಅವುಗಳನ್ನು ಏಫೋದಿನ ಭುಜಪಟ್ಟಿಗಳ ಮುಂಭಾಗದ ಕೆಳಗೆ ಸಿಕ್ಕಿಸು. ಈ ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಏಫೋದಿನ ನಡುಕಟ್ಟಿನ ಮೇಲ್ಗಡೆ ಇರಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ದೈವನಿರ್ಣಯದ ಪದಕದ ಬಳೆಗಳನ್ನು ಏಫೋದಿನ ಬಳೆಗಳಿಗೆ ಜೋಡಿಸಲು ನೀಲಿದಾರವನ್ನು ಉಪಯೋಗಿಸು. ಈ ರೀತಿಯಲ್ಲಿ ದೈವನಿರ್ಣಯದ ಪದಕವು ನಡುಕಟ್ಟಿಗೆ ಹತ್ತಿರವಾಗಿದ್ದು ಏಫೋದಿಗೆ ಬಿಗಿಯಾಗಿ ಅಂಟಿಕೊಂಡಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“ಆರೋನನು ಪವಿತ್ರಸ್ಥಳವನ್ನು ಪ್ರವೇಶಿಸುವಾಗ, ದೈವನಿರ್ಣಯದ ಪದಕವನ್ನು ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ಈ ರೀತಿ ಎದೆಯ ಮೇಲೆ ಇಸ್ರೇಲನ ಗಂಡುಮಕ್ಕಳ ಹೆಸರುಗಳಿರಬೇಕು. ಅವನು ನ್ಯಾಯತೀರಿಸಲು ಧರಿಸಿಕೊಂಡಿರುವ ದೈವನಿರ್ಣಯದ ಪದಕದ ಮೇಲೆ ಈ ಹೆಸರುಗಳಿರುತ್ತವೆ. ಈ ರೀತಿಯಲ್ಲಿ ಇಸ್ರೇಲನ ಹನ್ನೆರಡು ಮಂದಿ ಗಂಡುಮಕ್ಕಳನ್ನು ಯೆಹೋವನಿಗೆ ಯಾವಾಗಲೂ ಜ್ಞಾಪಿಸಲಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ದೈವನಿರ್ಣಯದ ಪದಕದೊಳಗೆ ಊರೀಮ್ ಮತ್ತು ತುಮ್ಮೀಮ್ ಎಂಬ ವಸ್ತುಗಳನ್ನು ಇಡು. ಆರೋನನು ಯೆಹೋವನ ಮುಂದೆ ಹೋಗುವಾಗ ಅವುಗಳು ಅವನ ಎದೆಯ ಮೇಲಿರುವವು. ಹೀಗೆ ಆರೋನನು ಯೆಹೋವನ ಮುಂದೆ ನಿಲ್ಲುವಾಗಲೆಲ್ಲಾ, ಜನರಿಗೆ ತೀರ್ಪು ನೀಡತಕ್ಕದ್ದನ್ನು ಯಾವಾಗಲೂ ತನ್ನ ಎದೆಯ ಮೇಲೆ ಹೊತ್ತುಕೊಂಡಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ಏಫೋದಿನ ಒಳಗೆ ಹಾಕಿಕೊಳ್ಳಲು ಒಂದು ನಿಲುವಂಗಿಯನ್ನು ನೀಲಿಬಟ್ಟೆಯಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ತಲೆಯನ್ನು ತೂರಿಸುವುದಕ್ಕೆ ಮಧ್ಯದಲ್ಲಿ ಒಂದು ಸಂದು ಮಾಡಿಸು. ಈ ಸಂದಿನ ಸುತ್ತಲೂ ಹೆಣೆದ ಬಟ್ಟೆಯನ್ನು ಹೊಲಿಸು. ಈ ಬಟ್ಟೆಯು ಸಂದು ಹರಿದುಹೋಗದಂತೆ ಕಾಪಾಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ಬಟ್ಟೆಯ ಅಂಚಿನ ಸುತ್ತಲೂ ದಾಳಿಂಬೆ ಹಣ್ಣುಗಳನ್ನು ಮಾಡಲು ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕೆಂಪುದಾರಗಳನ್ನು ಉಪಯೋಗಿಸಬೇಕು. ಆ ದಾಳಿಂಬೆ ಹಣ್ಣಿನ ಚೆಂಡುಗಳನ್ನು ನಿಲುವಂಗಿಯ ಕೆಳಅಂಚಿನಲ್ಲಿ ಸುತ್ತಲೂ ನೇತಾಡುವಂತೆ ಸಿಕ್ಕಿಸಬೇಕು. ದಾಳಿಂಬೆ ಹಣ್ಣಿನ ಚೆಂಡುಗಳ ನಡುವೆ ಚಿನ್ನದ ಗೆಜ್ಜೆಗಳನ್ನು ಸಿಕ್ಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ಹೀಗೆ ನಿಲುವಂಗಿಯ ಕೆಳಅಂಚಿನಲ್ಲಿ ಸುತ್ತಲೂ ಗೆಜ್ಜೆಗಳು ಮತ್ತು ದಾಳಿಂಬೆ ಹಣ್ಣುಗಳು ಇರಬೇಕು. ಪ್ರತಿ ಎರಡು ದಾಳಿಂಬೆ ಹಣ್ಣಿನ ನಡುವೆ ಗೆಜ್ಜೆ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ಆರೋನನು ಯಾಜಕನಾಗಿ ಸೇವೆಮಾಡುವಾಗ ಈ ನಿಲುವಂಗಿಯನ್ನು ಧರಿಸಿಕೊಂಡಿರುವನು. ಯೆಹೋವನ ಮುಂದೆ ನಿಲ್ಲುವುದಕ್ಕೆ ಆರೋನನು ಪವಿತ್ರಸ್ಥಳವನ್ನು ಪ್ರವೇಶಿಸುವಾಗ ಗೆಜ್ಜೆಗಳು ಶಬ್ದ ಮಾಡುತ್ತಿರುತ್ತವೆ. ಅವನು ಪವಿತ್ರಸ್ಥಳವನ್ನು ಬಿಡುವಾಗಲೂ ಗೆಜ್ಜೆಗಳು ಶಬ್ಧ ಮಾಡುತ್ತಿರುತ್ತವೆ. ಹೀಗಾಗಿ ಆರೋನನು ಸಾಯುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“ಶುದ್ಧಬಂಗಾರದ ಪಟ್ಟಿಯನ್ನು ಮಾಡಿಸಿ ಮುದ್ರೆಯನ್ನು ಕೆತ್ತುವ ರೀತಿಯಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಮೀಸಲು ಎಂಬ ಮಾತುಗಳನ್ನು ಚಿನ್ನದಲ್ಲಿ ಕೆತ್ತಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ಚಿನ್ನದ ಪಟ್ಟಿಯನ್ನು ನೀಲಿದಾರಕ್ಕೆ ಬಿಗಿಯಾಗಿ ಕಟ್ಟಿಸಬೇಕು. ನೀಲಿದಾರವನ್ನು ಮುಂಡಾಸದ ಸುತ್ತಲೂ ಅದರಲ್ಲಿ ಕೆತ್ತಿಸಬೇಕು. ಚಿನ್ನದ ಪಟ್ಟಿಯು ಮುಂಡಾಸದ ಮುಂಭಾಗದಲ್ಲಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ಆರೋನನು ಇದನ್ನು ತನ್ನ ಹಣೆಯ ಮೇಲೆ ಧರಿಸಿಕೊಳ್ಳುವನು. ಹೀಗೆ, ಇಸ್ರೇಲರು ಅರ್ಪಿಸಿದ ಕಾಣಿಕೆಗಳಲ್ಲಿ ದೋಷವೇನಾದರೂ ಇದ್ದರೆ ಅವನು ಅದನ್ನು ತನ್ನ ಮೇಲೆ ತೆಗೆದುಕೊಂಡು ತಾನೇ ಅದನ್ನು ವಹಿಸಿಕೊಳ್ಳುವನು. ಇವು ಜನರು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವ ಕಾಣಿಕೆಗಳಾಗಿವೆ. ಜನರ ಕಾಣಿಕೆಗಳನ್ನು ಯೆಹೋವನು ಅಂಗೀಕರಿಸುವಂತೆ ಆರೋನನು ಇದನ್ನು ಯಾವಾಗಲೂ ತನ್ನ ಶಿರದಲ್ಲಿ ಧರಿಸಿಕೊಂಡಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“ಹೆಣೆದ ಅಂಗಿಯನ್ನು ಮತ್ತು ಮುಂಡಾಸವನ್ನು ಮಾಡಲು ಉತ್ಕೃಷ್ಠವಾದ ನಾರಿನ ಬಟ್ಟೆಯನ್ನು ಉಪಯೋಗಿಸು. ನಡುಕಟ್ಟನ್ನು ಬುಟ್ಟೀದಾರಿ ಕೆಲಸದಿಂದ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ಆರೋನನ ಗಂಡುಮಕ್ಕಳಿಗೂ ಅಂಗಿಗಳನ್ನು, ನಡುಕಟ್ಟುಗಳನ್ನು ಮತ್ತು ಮುಂಡಾಸಗಳನ್ನು ಮಾಡಿಸು. ಇವು ಅವರಿಗೆ ಘನತೆ ಮತ್ತು ಗೌರವಗಳನ್ನು ಕೊಡುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ನಿನ್ನ ಸಹೋದರನಾದ ಆರೋನನಿಗೆ ಮತ್ತು ಅವನ ಗಂಡುಮಕ್ಕಳಿಗೆ ಬಟ್ಟೆಗಳನ್ನು ತೊಡಿಸು. ಬಳಿಕ ಅವರನ್ನು ಯಾಜಕರನ್ನಾಗಿ ಮಾಡಲು ವಿಶೇಷ ತೈಲದಿಂದ ಅಭಿಷೇಕಿಸು. ಇದು ಅವರನ್ನು ಪ್ರತಿಷ್ಠಿಸುವುದು ಮತ್ತು ಪವಿತ್ರರನ್ನಾಗಿ ಮಾಡುವುದು. ಅವರು ಯಾಜಕರಾಗಿ ನನ್ನ ಸೇವೆ ಮಾಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“ಯಾಜಕರಿಗೆ ಒಳಗಿನ ಉಡುಪುಗಳನ್ನು ಮಾಡಲು ನಾರುಬಟ್ಟೆಯನ್ನು ಉಪಯೋಗಿಸು. ಈ ಒಳಗಿನ ಉಡುಪುಗಳು ಅವರನ್ನು ಸೊಂಟದಿಂದ ತೊಡೆಯವರೆಗೆ ಮುಚ್ಚುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ಆರೋನನು ಮತ್ತು ಅವನ ಗಂಡುಮಕ್ಕಳು ದೇವದರ್ಶನ ಗುಡಾರದೊಳಗೆ ಪ್ರವೇಶಿಸುವಾಗಲೆಲ್ಲಾ ಈ ಉಡುಪುಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಯಾಜಕರಾಗಿ ಸೇವೆಮಾಡಲು ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಗೆ ಬರುವಾಗ ಅವರು ಈ ಬಟ್ಟೆಗಳನ್ನು ಧರಿಸಿಕೊಂಡಿರಬೇಕು. ಅವರು ಈ ಉಡುಪುಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳದಿದ್ದರೆ, ದೋಷಿಗಳಾಗಿ ಸಾಯುವರು. ಇವುಗಳೆಲ್ಲಾ ಆರೋನನಿಗೂ ಅವನ ನಂತರ ಅವನ ಕುಟುಂಬಸ್ಥರೆಲ್ಲರಿಗೂ ಶಾಶ್ವತವಾದ ಕಟ್ಟಳೆಯಾಗಿವೆ.” ");
INSERT INTO kan2010_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಆರೋನನು ಮತ್ತು ಅವನ ಗಂಡುಮಕ್ಕಳು ಅಭಿಷೇಕಿಸಲ್ಪಟ್ಟ ಮತ್ತು ಪ್ರತ್ಯೇಕಿಸಲ್ಪಟ್ಟ ಯಾಜಕರಾಗಿ ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ನನ್ನ ಸೇವೆಮಾಡಲು ಅವರು ಮಾಡತಕ್ಕದ್ದೇನೆಂಬುದನ್ನು ನಾನೀಗ ಹೇಳುವೆನು. ಯಾವ ಅಂಗದೋಷವಿಲ್ಲದ ಒಂದು ಹೋರಿಮರಿಯನ್ನು ಮತ್ತು ಎರಡು ಟಗರುಗಳನ್ನು ತೆಗೆದುಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ಬಳಿಕ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನೂ ಆಲಿವ್ ಎಣ್ಣೆ ಮಿಶ್ರವಾದ ಹುಳಿಯಿಲ್ಲದ ಹೋಳಿಗೆಗಳನ್ನೂ ಎಣ್ಣೆ ಹಾಕಿದ ತೆಳುವಾದ ಕಡುಬುಗಳನ್ನೂ ಗೋಧಿಹಿಟ್ಟಿನಿಂದ ಮಾಡಿಸಿ ಒಂದೇ ಬುಟ್ಟಿಯಲ್ಲಿ ತುಂಬಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ಬಳಿಕ ಆ ಬುಟ್ಟಿಯನ್ನು ಆರೋನನಿಗೂ ಮತ್ತು ಅವನ ಪುತ್ರರಿಗೂ ಕೊಡು. ಅದೇ ಸಮಯದಲ್ಲಿ ಹೋರಿಯನ್ನು ಮತ್ತು ಎರಡು ಟಗರುಗಳನ್ನು ಅವರಿಗೆ ಕೊಡು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“ತರುವಾಯ ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ದೇವದರ್ಶನಗುಡಾರದ ದ್ವಾರಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಾ. ಅವರನ್ನು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ವಿಶೇಷವಾದ ಬಟ್ಟೆಗಳನ್ನು ಆರೋನನಿಗೆ ತೊಡಿಸು. ಹೆಣೆದ ಅಂಗಿಯನ್ನು ಮತ್ತು ಏಫೋದಿನೊಡನೆ ಧರಿಸತಕ್ಕ ದೈವನಿರ್ಣಯದ ಪದಕವನ್ನು ಅವನಿಗೆ ತೊಡಿಸು. ಬಳಿಕ ಅಂದವಾದ ನಡುಕಟ್ಟನ್ನು ಅವನಿಗೆ ಕಟ್ಟು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ಅವನ ತಲೆಗೆ ಮುಂಡಾಸನ್ನು ಇಡು ಮತ್ತು ಮುಂಡಾಸಕ್ಕೆ ವಿಶೇಷವಾದ ಕಿರೀಟವನ್ನು ಕಟ್ಟಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ಅಭಿಷೇಕತೈಲವನ್ನು ತೆಗೆದುಕೊಂಡು ಆರೋನನ ತಲೆಯ ಮೇಲೆ ಸುರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“ತರುವಾಯ ಆರೋನನ ಪುತ್ರರನ್ನು ಆ ಸ್ಥಳಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಾ. ಅವರಿಗೆ ಹೆಣೆದ ಅಂಗಿಗಳನ್ನು ತೊಡಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ಬಳಿಕ ಅವರ ಸೊಂಟಗಳಿಗೆ ನಡುಕಟ್ಟುಗಳನ್ನು ಸುತ್ತಿಸು. ಅಂದಿನಿಂದ ಅವರು ಯಾಜಕರಾಗಿರುವರು. ವಿಶೇಷವಾದ ಈ ಕಟ್ಟಳೆಯು ಶಾಶ್ವತವಾಗಿರುವುದರಿಂದ ಅವರು ಯಾಜಕರಾಗಿರುವರು. ಹೀಗೆ ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ನೀನು ಯಾಜಕರನ್ನಾಗಿ ಮಾಡುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ತರುವಾಯ ನೀನು ಹೋರಿಯನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಎದುರಿಗೆ ತರಬೇಕು. ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ತಮ್ಮ ಕೈಗಳನ್ನು ಹೋರಿಯ ತಲೆಯ ಮೇಲಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ಬಳಿಕ ದೇವದರ್ಶನಗುಡಾರದ ದ್ವಾರದಲ್ಲಿ ಹೋರಿಯನ್ನು ವಧಿಸು. ಯೆಹೋವನು ಇದನ್ನು ನೋಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ತರುವಾಯ ಹೋರಿಯ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಗೆ ಹೋಗು. ವೇದಿಕೆಯ ಕೊಂಬುಗಳಿಗೆ ನಿನ್ನ ಬೆರಳಿನಿಂದ ರಕ್ತವನ್ನು ಹಚ್ಚು. ಉಳಿದ ರಕ್ತವನ್ನೆಲ್ಲಾ ಯಜ್ಞವೇದಿಕೆಯ ಬುಡಕ್ಕೆ ಸುರಿದುಬಿಡು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ಬಳಿಕ ಹೋರಿಯ ಒಳಗಿನ ಕೊಬ್ಬನ್ನೂ ಪಿತ್ತಕೋಶದ ಸುತ್ತಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನೂ ಮತ್ತು ಅವುಗಳ ಸುತ್ತಲಿರುವ ಕೊಬ್ಬನ್ನೂ ತೆಗೆದುಬಿಡು. ಈ ಕೊಬ್ಬನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ಬಳಿಕ ಹೋರಿಯ ಮಾಂಸ, ಚರ್ಮ, ಇತರ ಭಾಗಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಸುಟ್ಟುಬಿಡು. ಇದು ಯಾಜಕರ ಪಾಪಗಳನ್ನು ಪರಿಹರಿಸುವ ಕಾಣಿಕೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ತರುವಾಯ ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ತಮ್ಮ ಕೈಗಳನ್ನು ಒಂದು ಟಗರಿನ ತಲೆಯ ಮೇಲೆ ಇಡಬೇಕೆಂದು ಹೇಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ಆ ಟಗರನ್ನು ವಧಿಸಿ ಅದರ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ನಾಲ್ಕು ಕಡೆಗಳಿಗೆ ಚೆಲ್ಲು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ಬಳಿಕ ಟಗರನ್ನು ಅನೇಕ ತುಂಡುಗಳಾಗಿ ಕತ್ತರಿಸು. ಟಗರಿನ ಒಳಗಿನ ಎಲ್ಲಾ ಭಾಗಗಳನ್ನು ಮತ್ತು ಕಾಲುಗಳನ್ನು ತೊಳೆಯಬೇಕು. ಅವುಗಳನ್ನು ತಲೆಯ ಮತ್ತು ಟಗರಿನ ಇತರ ತುಂಡುಗಳೊಡನೆ ಇಡು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ತರುವಾಯ ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಇಡೀ ಟಗರನ್ನು ಹೋಮಮಾಡು. ಇದು ವಿಶೇಷವಾದ ಸರ್ವಾಂಗಹೋಮವಾಗಿದೆ. ಇದು ಯೆಹೋವನಿಗೆ ಪರಿಮಳ ವಾಸನೆಯಾಗಿದ್ದು ಆತನಿಗೆ ಮೆಚ್ಚಿಕೆಕರವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ಮತ್ತೊಂದು ಟಗರಿನ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನಿಡಲು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಹೇಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ಆ ಟಗರನ್ನು ವಧಿಸಿ ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊ. ಆ ರಕ್ತವನ್ನು ಆರೋನ ಮತ್ತು ಅವನ ಪುತ್ರರ ಬಲಗಿವಿಯ ತುದಿಗೆ ಹಚ್ಚು. ಅದಲ್ಲದೆ ಅವರ ಬಲಗೈಗಳ ಹೆಬ್ಬೆರಳುಗಳಿಗೂ ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ಹಚ್ಚು. ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ಅವರ ಬಲಗಾಲಿನ ಹೆಬ್ಬೊಟ್ಟಿಗೂ ಹಚ್ಚು. ಬಳಿಕ ಉಳಿದ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ನಾಲ್ಕು ಕಡೆಗಳಿಗೆ ಚೆಲ್ಲು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ತರುವಾಯ ಯಜ್ಞವೇದಿಕೆಯಿಂದ ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊ. ಅದನ್ನು ವಿಶೇಷವಾದ ಅಭೀಷೇಕತೈಲದಲ್ಲಿ ಬೆರಸಿ ಆರೋನನ ಮೇಲೆಯೂ ಅವನ ಬಟ್ಟೆಗಳ ಮೇಲೆಯೂ ಚಿಮಿಕಿಸು. ಅವನ ಪುತ್ರರ ಮತ್ತು ಅವರ ಬಟ್ಟೆಗಳ ಮೇಲೆಯೂ ಚಿಮಿಕಿಸು. ಆಗ ಅವರು ಪರಿಶುದ್ಧಗೊಳ್ಳುವರು, ಅವರ ಬಟ್ಟೆಗಳೂ ಪರಿಶುದ್ಧಗೊಳ್ಳುವವು. ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ನನ್ನ ಸೇವೆ ಮಾಡುತ್ತಾರೆಂದು ಇದು ತೋರಿಸುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“ಬಳಿಕ ಟಗರಿನ ಕೊಬ್ಬನ್ನೂ ತೆಗೆದುಕೊ. (ಇದು ಆರೋನನನ್ನು ಪ್ರಧಾನಯಾಜಕನನ್ನಾಗಿ ಮಾಡುವ ಆಚಾರವಿಧಿಯಲ್ಲಿ ಉಪಯೋಗಿಸಲ್ಪಡುವ ಟಗರು.) ಬಾಲದ ಸುತ್ತಲಿರುವ ಕೊಬ್ಬನ್ನು, ದೇಹದ ಒಳಗಿನ ಅಂಗಗಳನ್ನು ಮುಚ್ಚಿಕೊಂಡಿರುವ ಕೊಬ್ಬನ್ನು, ಪಿತ್ತಕೋಶದ ಸುತ್ತಲಿರುವ ಕೊಬ್ಬನ್ನು, ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನು ಮತ್ತು ಬಲತೊಡೆಯನ್ನು ತೆಗೆದುಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ಬಳಿಕ ನೀನು ಮಾಡಿದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಬುಟ್ಟಿಯನ್ನು ತೆಗೆದುಕೊ. ಇದು ಯೆಹೋವನ ಮುಂದೆ ಇಟ್ಟ ಬುಟ್ಟಿಯಾಗಿದೆ. ಒಂದು ತುಂಡು ರೊಟ್ಟಿ, ಎಣ್ಣೆಯಿಂದ ಮಾಡಿದ ಒಂದು ಹೋಳಿಗೆ, ತೆಳುವಾದ ಒಂದು ಕಡುಬು ಇವುಗಳನ್ನು ಬುಟ್ಟಿಯಿಂದ ತೆಗೆದುಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ಇವುಗಳನ್ನು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಕೊಡು. ಯೆಹೋವನ ಮುಂದೆ ಇವುಗಳನ್ನು ತಮ್ಮ ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಂಡು ನಿವಾಳಿಸಬೇಕೆಂದು ಅವರಿಗೆ ಹೇಳು. ಇದು ಯೆಹೋವನಿಗೆ ವಿಶೇಷವಾದ ನೈವೇದ್ಯಾರ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ಬಳಿಕ ಈ ವಸ್ತುಗಳನ್ನು ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರ ಕೈಯಿಂದ ತೆಗೆದುಕೊಂಡು ಟಗರಿನ ಜೊತೆ ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲಿಡು. ಈ ಸರ್ವಾಂಗಹೋಮವು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಹೋಮವಾಗಿದ್ದು ಆತನನ್ನು ಮೆಚ್ಚಿಸುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“ತರುವಾಯ ಟಗರಿನ ಎದೆಯ ಭಾಗವನ್ನು ತೆಗೆದುಕೊ. (ಆರೋನನನ್ನು ಪ್ರಧಾನಯಾಜಕನನ್ನಾಗಿ ಮಾಡುವ ಆಚಾರವಿಧಿಯಲ್ಲಿ ಉಪಯೋಗಿಸಲ್ಪಡುವ ಟಗರು ಇದಾಗಿದೆ.) ಟಗರಿನ ಎದೆಯ ಭಾಗವನ್ನು ವಿಶೇಷ ಸಮರ್ಪಣೆಯಾಗಿ ಯೆಹೋವನ ಮುಂದೆ ನಿವಾಳಿಸಬೇಕು. ಪಶುವಿನ ಈ ಭಾಗವು ನಿನಗೆ ಸಲ್ಲತಕ್ಕ ಪಾಲು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ಬಳಿಕ ಆರೋನನನ್ನು ಮಹಾಯಾಜಕನನ್ನಾಗಿ ಮಾಡಲು ನಿವಾಳಿಸಲ್ಪಟ್ಟ ಟಗರಿನ ಎದೆಯ ಭಾಗವನ್ನೂ ಯಾಜಕರ ಭಾಗವಾದ ನಿವಾಳಿಸಲ್ಪಟ್ಟ ಟಗರಿನ ತೊಡೆಯನ್ನೂ ತೆಗೆದುಕೊ. ಅವುಗಳನ್ನು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಕೊಡು. ಇದು ಕಾಣಿಕೆಯ ವಿಶೇಷ ಭಾಗವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ಇಸ್ರೇಲರು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಈ ಭಾಗಗಳನ್ನು ಯಾವಾಗಲೂ ಕೊಡುವರು. ಇಸ್ರೇಲರು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸುವ ಕಾಣಿಕೆಗಳಲ್ಲಿ ಈ ಭಾಗಗಳು ಯಾವಾಗಲೂ ಯಾಜಕರಿಗೆ ಸೇರಿದ್ದಾಗಿವೆ. ಅವರು ಯಾಜಕರಿಗೆ ಕೊಡುವ ಈ ಭಾಗಗಳು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಲ್ಪಟ್ಟಂತಿರುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“ಆರೋನನಿಗೋಸ್ಕರ ಮಾಡಿಸಿದ ವಿಶೇಷವಾದ ವಸ್ತ್ರಗಳನ್ನು ಅವನ ತರುವಾಯ ಅವನ ವಂಶಸ್ಥರೂ ಯಾಜಕ ಉದ್ಯೋಗಕ್ಕೆ ಆರಿಸಲ್ಪಟ್ಟಾಗ, ಅವುಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ಆರೋನನ ತರುವಾಯ ಅವನ ಮಗನು ಪ್ರಧಾನಯಾಜಕನಾಗುವನು. ಅವನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಸೇವೆಮಾಡಲು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಪ್ರವೇಶಿಸಿದಂದಿನಿಂದ ಏಳು ದಿನಗಳವರೆಗೆ ಆ ವಸ್ತ್ರಗಳನ್ನು ಧರಿಸಿಕೊಂಡಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“ಆರೋನನನ್ನು ಪ್ರಧಾನಯಾಜಕನನ್ನಾಗಿ ಮಾಡಲು ಉಪಯೋಗಿಸಿದ ಟಗರಿನ ಮಾಂಸವನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರಾಕಾರದಲ್ಲಿ ಬೇಯಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ಬಳಿಕ ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ದೇವದರ್ಶನಗುಡಾರದ ಮುಂಭಾಗದಲ್ಲಿ ಆ ಮಾಂಸವನ್ನೂ ಬುಟ್ಟಿಯಲ್ಲಿರುವ ರೊಟ್ಟಿಯನ್ನೂ ತಿನ್ನಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ಅವರು ಯಾಜಕರಾಗಿ ಮಾಡಲ್ಪಟ್ಟಾಗ ಅವರ ಪಾಪನಿವಾರಣೆಗಾಗಿ ಇವುಗಳನ್ನು ಸಮರ್ಪಿಸಲಾಗಿತ್ತು. ಆದ್ದರಿಂದ ಆ ಸಮರ್ಪಣೆಗಳನ್ನು ಅವರು ಮಾತ್ರ ತಿನ್ನಬೇಕೇ ಹೊರತು ಬೇರೆಯವರು ತಿನ್ನಬಾರದು; ಯಾಕೆಂದರೆ ಅವು ಪರಿಶುದ್ಧವಾಗಿವೆ ಮತ್ತು ಪ್ರತ್ಯೇಕಿಸಲ್ಪಟ್ಟವುಗಳಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ಟಗರಿನ ಮಾಂಸ ಅಥವಾ ರೊಟ್ಟಿಯೇನಾದರೂ ಮರುದಿನ ಮುಂಜಾನೆಯವರೆಗೆ ಉಳಿದರೆ, ಅದನ್ನು ಸುಟ್ಟುಬಿಡಬೇಕು. ನೀವು ಆ ರೊಟ್ಟಿಯನ್ನಾಗಲಿ ಮಾಂಸವನ್ನಾಗಲಿ ತಿನ್ನಬಾರದು. ಯಾಕೆಂದರೆ ಅದನ್ನು ವಿಶೇಷವಾದ ಸಂದರ್ಭದಲ್ಲಿ ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ಮಾತ್ರ ತಿನ್ನಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ ಇವುಗಳನ್ನೆಲ್ಲ ಆರೋನ ಮತ್ತು ಅವನ ಪುತ್ರರಿಗೋಸ್ಕರ ಮಾಡು. ಅವರನ್ನು ಯಾಜಕರನ್ನಾಗಿ ನೇಮಿಸುವ ಸಮಾರಂಭವು ಏಳು ದಿನಗಳವರೆಗೆ ನಡೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ಏಳು ದಿನಗಳವರೆಗೆ ಪ್ರತಿದಿನ ಒಂದು ಹೋರಿಯನ್ನು ವಧಿಸು. ಇದು ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರ ಪಾಪನಿವಾರಣೆಯ ಸಮರ್ಪಣೆಯಾಗಿರುವುದು. ಅದಲ್ಲದೆ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಪರಿಶುದ್ಧಗೊಳಿಸಲು ಅದರ ಮೇಲೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಸಮರ್ಪಿಸಿ ಅದನ್ನು ದೇವರ ಸೇವೆಗೋಸ್ಕರ ಅಭಿಷೇಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ಹೀಗೆ ಏಳು ದಿನಗಳವರೆಗೆ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಶುದ್ಧಗೊಳಿಸಿ ಪವಿತ್ರಗೊಳಿಸಬೇಕು. ಆ ಸಮಯದಲ್ಲಿ ಯಜ್ಞವೇದಿಕೆಯು ಮಹಾಪವಿತ್ರವಾಗಿರುವುದು. ಯಜ್ಞವೇದಿಕೆಗೆ ಸೋಂಕಿದ ವಸ್ತುಗಳೆಲ್ಲವೂ ಪವಿತ್ರವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಪ್ರತಿದಿನ ಯಜ್ಞವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಒಂದು ವರ್ಷದ ಎರಡು ಕುರಿಮರಿಗಳನ್ನು ನೀನು ವಧಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ಮುಂಜಾನೆ ಒಂದು ಕುರಿಮರಿಯನ್ನು ಮತ್ತು ಸಾಯಂಕಾಲ ಮತ್ತೊಂದು ಕುರಿಮರಿಯನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ನೀನು ಮೊದಲಿನ ಕುರಿಮರಿಯನ್ನು ವಧಿಸುವಾಗ ಮೂರು ಸೇರು ಶ್ರೇಷ್ಠ ಗೋಧಿ ಹಿಟ್ಟನ್ನೂ ಸಮರ್ಪಿಸು. ಆ ಹಿಟ್ಟನ್ನು ಒಂದೂವರೆ ಸೇರು ದ್ರಾಕ್ಷಾರಸದೊಂದಿಗೆ ಬೆರೆಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ನೀನು ಸಾಯಂಕಾಲದಲ್ಲಿ ಮತ್ತೊಂದು ಕುರಿಮರಿಯನ್ನು ವಧಿಸುವಾಗಲೂ ಮೂರು ಸೇರು ಶ್ರೇಷ್ಠ ಗೋಧಿಯನ್ನೂ ಅರ್ಧ ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಸಮರ್ಪಿಸು. ಇದು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಹೋಮವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“ನೀನು ಪ್ರತಿದಿನ ಈ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಸಮರ್ಪಣೆಯಾಗಿ ಅರ್ಪಿಸಬೇಕು. ದೇವದರ್ಶನಗುಡಾರದ ದ್ವಾರದಲ್ಲಿ ಯೆಹೋವನ ಮುಂದೆ ಇದನ್ನು ಮಾಡು. ನೀನು ಸಮರ್ಪಣೆಯನ್ನು ಮಾಡುವಾಗ ಯೆಹೋವನಾದ ನಾನು ಅಲ್ಲಿ ನಿನ್ನನ್ನು ಸಂಧಿಸಿ ನಿನ್ನೊಡನೆ ಮಾತಾಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ಆ ಸ್ಥಳದಲ್ಲಿ ನಾನು ಇಸ್ರೇಲರನ್ನು ಸಂಧಿಸುವೆನು. ನನ್ನ ಪ್ರಭಾವದಿಂದ ಆ ಸ್ಥಳವು ಪವಿತ್ರವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“ಅಲ್ಲದೆ ನಾನು ದೇವದರ್ಶನಗುಡಾರವನ್ನೂ ಯಜ್ಞವೇದಿಕೆಯನ್ನೂ ಪವಿತ್ರಗೊಳಿಸುವೆನು. ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಪವಿತ್ರಗೊಳಿಸುವೆನು; ಆಗ ಅವರು ಯಾಜಕರಾಗಿ ನನಗೆ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ನಾನು ಇಸ್ರೇಲರ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುವೆನು ಮತ್ತು ಅವರ ದೇವರಾಗಿರುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ನಾನು ಅವರ ದೇವರಾದ ಯೆಹೋವನಾಗಿದ್ದೇನೆಂದು ಜನರು ತಿಳಿದುಕೊಳ್ಳುವರು. ಅವರ ಮಧ್ಯದಲ್ಲಿ ವಾಸಮಾಡುವುದಕ್ಕಾಗಿ ಈಜಿಪ್ಟಿನಿಂದ ಅವರನ್ನು ಕರೆದುಕೊಂಡು ಬಂದವನು ನಾನೇ ಎಂದು ಅವರು ತಿಳಿದುಕೊಳ್ಳುವರು. ನಾನು ಅವರ ದೇವರಾಗಿರುವ ಯೆಹೋವನೇ.” ");
INSERT INTO kan2010_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಜಾಲೀಮರದಿಂದ ಧೂಪವೇದಿಕೆಯನ್ನು ಮಾಡಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ಈ ಧೂಪವೇದಿಕೆಯು ಚೌಕವಾಗಿ ಒಂದು ಮೊಳ ಉದ್ದ, ಒಂದು ಮೊಳ ಅಗಲ, ಎರಡು ಮೊಳ ಎತ್ತರ ಇರಬೇಕು. ಅದರ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲೂ ಕೊಂಬುಗಳಿರಬೇಕು. ಈ ಕೊಂಬುಗಳು ಧೂಪವೇದಿಕೆಯ ಅವಿಭಾಜ್ಯ ಭಾಗವಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ಧೂಪವೇದಿಕೆಯ ಮೇಲ್ಭಾಗವನ್ನೂ ಎಲ್ಲಾ ಪಾರ್ಶ್ವಗಳನ್ನೂ ಅದರ ಕೊಂಬುಗಳನ್ನೂ ಶುದ್ಧಬಂಗಾರದ ತಗಡಿನಿಂದ ಹೊದಿಸಬೇಕು ಮತ್ತು ಸುತ್ತಲೂ ಚಿನ್ನದ ಕಟ್ಟನ್ನು ಕಟ್ಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ಧೂಪವೇದಿಕೆಯ ಎದುರುಬದುರಾಗಿರುವ ಎರಡು ಗೋಡೆಗಳಲ್ಲಿ ಕಟ್ಟಿನ ಕೆಳಗೆ ಎರಡು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿಸು. ಧೂಪವೇದಿಕೆಯನ್ನು ಹೊರುವ ಕೋಲುಗಳನ್ನು ಈ ಬಳೆಗಳು ಹಿಡಿದುಕೊಂಡಿರುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ಕೋಲುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸು. ಚಿನ್ನದ ತಗಡಿನಿಂದ ಆ ಕೋಲುಗಳನ್ನು ಹೊದಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ವಿಶೇಷ ಪರದೆಯ (ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯನ್ನು ಆವರಿಸಿಕೊಂಡಿರುವ) ಮುಂಭಾಗದಲ್ಲಿ ಧೂಪವೇದಿಕೆಯನ್ನು ಇಡು. ಧೂಪವೇದಿಕೆಯು ಒಡಂಬಡಿಕೆ ಪೆಟ್ಟಿಗೆಯ ಕೃಪಾಸನದ ಮುಂಭಾಗದಲ್ಲಿರುವುದು. ಇದು ನಾನು ನಿನ್ನನ್ನು ಸಂಧಿಸುವ ಸ್ಥಳವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“ಆರೋನನು ಪ್ರತಿಮುಂಜಾನೆ ಧೂಪವೇದಿಕೆಯ ಮೇಲೆ ಸುಗಂಧದ್ರವ್ಯಗಳ ಧೂಪವನ್ನು ಉರಿಸಬೇಕು. ಅವನು ದೀಪಗಳನ್ನು ಸರಿಪಡಿಸಲು ಬರುವಾಗ ಇದನ್ನು ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ತಿರುಗಿ ಸಾಯಂಕಾಲದಲ್ಲಿ ಧೂಪವನ್ನು ಉರಿಸಬೇಕು. ಇದು ಸಾಯಂಕಾಲಗಳಲ್ಲಿ ಅವನು ದೀಪಗಳನ್ನು ಹೊತ್ತಿಸುವ ಸಮಯವಾಗಿರುತ್ತದೆ. ಹೀಗೆ ಪ್ರತಿದಿನ ಯೆಹೋವನ ಮುಂದೆ ನಿತ್ಯವಾದ ಧೂಪಸಮರ್ಪಣೆ ಇರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ಈ ಧೂಪವೇದಿಕೆಯನ್ನು ಬೇರೆ ವಿಧದ ಧೂಪಸಮರ್ಪಣೆಗಾಗಲಿ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕಾಗಲಿ ಯಾವುದೇ ಧಾನ್ಯಸಮರ್ಪಣೆಗಾಗಲಿ ಪಾನದ್ರವ್ಯಸಮರ್ಪಣೆಗಾಗಲಿ ಉಪಯೋಗಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“ಆರೋನನು ವರ್ಷಕ್ಕೊಮ್ಮೆ ಯೆಹೋವನಿಗೆ ವಿಶೇಷ ಯಜ್ಞವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಜನರ ಪಾಪಗಳ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಆರೋನನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ರಕ್ತವನ್ನು ಉಪಯೋಗಿಸುವನು. ಆರೋನನು ಇದನ್ನು ಈ ಯಜ್ಞವೇದಿಕೆಯ ಕೊಂಬುಗಳಲ್ಲಿ ಮಾಡುವನು. ಆ ದಿನವು ದೋಷಪರಿಹಾರಕ ದಿನವೆಂದು ಕರೆಯಲ್ಪಡುವುದು. ಯೆಹೋವನಿಗೆ ಇದು ಅತೀ ಪರಿಶುದ್ಧವಾದ ವಿಶೇಷ ದಿನವಾಗಿದೆ.” ");
INSERT INTO kan2010_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ಇಸ್ರೇಲರನ್ನು ಲೆಕ್ಕಿಸು. ಹೀಗಾಗಿ ಎಷ್ಟು ಮಂದಿ ಜನರಿರುತ್ತಾರೆಂದು ನೀನು ತಿಳಿದುಕೊಳ್ಳುವೆ. ಪ್ರತಿಸಾರಿ ಇದನ್ನು ಮಾಡಿದಾಗ, ಪ್ರತಿಯೊಬ್ಬನು ತನಗೋಸ್ಕರವಾಗಿ ಯೆಹೋವನಿಗೆ ತೆರಿಗೆಯನ್ನು ಕೊಡಬೇಕು. ಆಗ ಜನರಿಗೆ ಯಾವ ಕೇಡುಗಳೂ ಉಂಟಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪ್ರತಿಯೊಬ್ಬನು ಅಧಿಕೃತ ಅಳತೆಗನುಸಾರವಾಗಿರುವ ಅರ್ಧಶೆಕೆಲ್ ಕಪ್ಪಕಾಣಿಕೆಯನ್ನು ಕೊಡಬೇಕು. ಈ ಅರ್ಧಶೆಕೆಲ್ ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರಲ್ಲಿ ಇಪ್ಪತ್ತು ವರ್ಷದವರೂ ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟವರೂ ಈ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ಐಶ್ವರ್ಯವಂತರು ಅರ್ಧಶೆಕೆಲಿಗಿಂತ ಹೆಚ್ಚು ಕೊಡಬಾರದು; ಬಡವರು ಅರ್ಧಶೆಕೆಲಿಗಿಂತ ಕಡಿಮೆ ಕೊಡಬಾರದು. ಜನರೆಲ್ಲರೂ ಈ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಬೇಕು. ಇದು ನಿಮ್ಮ ಪ್ರಾಣರಕ್ಷಣೆಯ ತೆರಿಗೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ಇಸ್ರೇಲರಿಂದ ಈ ಹಣವನ್ನು ಒಟ್ಟುಗೂಡಿಸಬೇಕು. ದೇವದರ್ಶನಗುಡಾರದ ಸೇವೆಗಾಗಿ ಹಣವನ್ನು ಉಪಯೋಗಿಸಬೇಕು. ಯೆಹೋವನು ತನ್ನ ಜನರನ್ನು ಜ್ಞಾಪಿಸಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಈ ಕಪ್ಪವು ಒಂದು ಮಾರ್ಗವಾಗಿದೆ. ಅವರು ತಮ್ಮ ಪ್ರಾಣರಕ್ಷಣೆಗಾಗಿ ಹಣವನ್ನು ಕೊಡುತ್ತಿರುವರು.” ");
INSERT INTO kan2010_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ತಾಮ್ರದ ಗಂಗಾಳವನ್ನು ಮಾಡಿ ಅದನ್ನು ತಾಮ್ರದ ಪೀಠದ ಮೇಲಿಡು. ತೊಳೆದುಕೊಳ್ಳುವುದಕ್ಕೆ ನೀವು ಇದನ್ನು ಉಪಯೋಗಿಸುವಿರಿ. ಗಂಗಾಳವನ್ನು ದೇವದರ್ಶನಗುಡಾರ ಮತ್ತು ಯಜ್ಞವೇದಿಕೆಯ ನಡುವೆ ಇಡು. ಗಂಗಾಳದಲ್ಲಿ ನೀರನ್ನು ತುಂಬಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ಈ ಗಂಗಾಳದಲ್ಲಿರುವ ನೀರಿನಿಂದ ತಮ್ಮ ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ಪ್ರತಿಸಾರಿ ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಪ್ರವೇಶಿಸುವಾಗ ಅಥವಾ ಯೆಹೋವನಿಗಾಗಿ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನು ಅರ್ಪಿಸಲು ಯಜ್ಞವೇದಿಕೆಯ ಹತ್ತಿರಕ್ಕೆ ಬರುವಾಗ ಅವರು ನೀರಿನಿಂದ ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಆಗ ಅವರು ಸಾಯುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ಅವರು ತಮ್ಮ ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳುವುದರಿಂದ ಅವರು ಸಾಯುವುದಿಲ್ಲ. ಆರೋನನಿಗೂ ಅವನ ಸಂತತಿಯವರಿಗೂ ಇದು ಶಾಶ್ವತವಾದ ನಿಯಮ. ತಲೆಮಾರುಗಳವರೆಗೆ ಆರೋನನ ಸಂತತಿಯವರಿಗೆಲ್ಲಾ ಇದೇ ಕಟ್ಟಳೆಯಿರುವುದು.” ");
INSERT INTO kan2010_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ಶ್ರೇಷ್ಠವಾದ ಸುಗಂಧದ್ರವ್ಯಗಳನ್ನು ಮಾಡಿಸು. ಹನ್ನೆರಡು ಪೌಂಡುಗಳಷ್ಟು ಅಚ್ಚ ರಕ್ತಬೋಳ, ಅದರ ಅರ್ಧದಷ್ಟು ಅಂದರೆ ಆರು ಪೌಂಡು ಸುವಾಸನೆಯುಳ್ಳ ದಾಲ್ಚಿನ್ನಿ, ಹನ್ನೆರಡು ಪೌಂಡುಗಳಷ್ಟು ಸುವಾಸನೆಯುಳ್ಳ ಬಜೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ಮತ್ತು ಹನ್ನೆರಡು ಪೌಂಡುಗಳಷ್ಟು ಲವಂಗಚಕ್ಕೆಯನ್ನು ತೆಗೆದುಕೊಂಡು ಬಾ. ಇವುಗಳನ್ನೆಲ್ಲ ಅಧಿಕೃತ ಅಳತೆಮಾಪಕದಿಂದ ಅಳತೆಮಾಡು. ಒಂದು ಗ್ಯಾಲನ್ ಆಲಿವ್ ಎಣ್ಣೆಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಾ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“ಸುವಾಸನೆಯುಳ್ಳ ಪವಿತ್ರ ಅಭಿಷೇಕತೈಲವನ್ನು ಮಾಡಲು ಇವುಗಳನ್ನೆಲ್ಲ ಒಟ್ಟಿಗೆ ಬೆರೆಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ದೇವದರ್ಶನಗುಡಾರವನ್ನು ಮತ್ತು ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯನ್ನು ಅಭಿಷೇಕಿಸಲು ಈ ತೈಲವನ್ನು ಉಪಯೋಗಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ಈ ತೈಲವನ್ನು ಮೇಜಿನ ಮೇಲಿರುವ ಎಲ್ಲಾ ಉಪಕರಣಗಳ ಮೇಲೆ ಸುರಿ. ಈ ತೈಲವನ್ನು ದೀಪ ಮತ್ತು ಅದರ ಉಪಕರಣಗಳೆಲ್ಲದರ ಮೇಲೆ ಸುರಿ. ಆ ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲಿರುವ ಅದರ ಉಪಕರಣಗಳ ಮೇಲೆಯೂ ಈ ತೈಲವನ್ನು ಸುರಿ. ತೈಲವನ್ನು ಧೂಪವೇದಿಕೆಯ ಮೇಲೆ ಸುರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ದೇವರಿಗೆ ಬೆಂಕಿಯ ಮೂಲಕ ಅರ್ಪಿಸುವ ಹೋಮಗಳ ಮೇಲೆಯೂ ತೈಲವನ್ನು ಸುರಿ. ಈ ತೈಲವನ್ನು ಗಂಗಾಳದ ಮೇಲೆಯೂ ಮತ್ತು ಗಂಗಾಳದ ಕೆಳಗಿರುವ ಪೀಠದ ಮೇಲೆಯೂ ಸುರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ಆಗ ನೀನು ಈ ಉಪಕರಣಗಳನ್ನೆಲ್ಲ ಪವಿತ್ರಗೊಳಿಸುವೆ. ಅವುಗಳು ಯೆಹೋವನಿಗೆ ಬಹು ವಿಶೇಷವಾಗಿವೆ. ಅವುಗಳಿಗೆ ಸೋಂಕಿದ್ದೆಲ್ಲವೂ ಪವಿತ್ರವಾಗುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“ಆರೋನನನ್ನು ಮತ್ತು ಅವನ ಪುತ್ರರನ್ನು ಈ ತೈಲದಿಂದ ಅಭಿಷೇಕಿಸು. ಅವರು ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ನನ್ನ ಸೇವೆಮಾಡುತ್ತಾರೆಂದು ಇದು ತೋರಿಸುವುದು. ಆಗ ಅವರು ಅಭಿಷೇಕಿಸಲ್ಪಟ್ಟ ಯಾಜಕರಾಗಿ ನನ್ನ ಸೇವೆಮಾಡಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ಅಭಿಷೇಕತೈಲವು ಪವಿತ್ರವಾದದ್ದು. ಅದನ್ನು ಯಾವಾಗಲೂ ನನಗಾಗಿ ಮಾತ್ರವೇ ಉಪಯೋಗಿಸಬೇಕೆಂದು ಇಸ್ರೇಲರಿಗೆ ಹೇಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ಯಾರೂ ಇದನ್ನು ಸಾಮಾನ್ಯವಾದ ಸುಗಂಧ ವಾಸನೆಯುಳ್ಳ ತೈಲವಾಗಿ ಉಪಯೋಗಿಸಬಾರದು. ಈ ವಿಶೇಷವಾದ ತೈಲವನ್ನು ಮಾಡುವ ರೀತಿಯಲ್ಲಿ ಸಾಮಾನ್ಯವಾದ ಸುಗಂಧ ತೈಲವನ್ನು ಮಾಡಬಾರದು. ಈ ತೈಲವು ಪವಿತ್ರವಾದದ್ದು. ಇದು ನಿಮಗೆ ಬಹಳ ವಿಶೇಷವಾದದ್ದಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ಯಾವನಾದರೂ ಸುಗಂಧ ತೈಲವನ್ನು ಈ ಪವಿತ್ರತೈಲದಂತೆ ಮಾಡಿ ಯಾಜಕನಲ್ಲದ ಒಬ್ಬನಿಗೆ ಅದನ್ನು ಕೊಟ್ಟರೆ, ಅವನನ್ನು ಅವನ ಕುಲದಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ನೀನು ಹಾಲು, ಮಡ್ಡಿ, ಗುಗ್ಗುಲ, ಗಂಧದ ಚೆಕ್ಕೆ ಎಂಬ ಸುಗಂಧ ದ್ರವ್ಯಗಳನ್ನು ಸಮವಾಗಿ ತೆಗೆದುಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ಸುವಾಸನೆಯುಳ್ಳ ಧೂಪವನ್ನು ಮಾಡುವುದಕ್ಕೆ ಈ ಸುಗಂಧ ದ್ರವ್ಯಗಳನ್ನು ಒಟ್ಟಾಗಿ ಬೆರೆಸು. ಸುಗಂಧದ್ರವ್ಯಕಾರನು ಮಾಡುವ ಪ್ರಕಾರವೇ ಇದನ್ನು ಮಾಡು. ಈ ಧೂಪಕ್ಕೆ ಉಪ್ಪನ್ನು ಬೆರೆಸು. ಉಪ್ಪು ಅದನ್ನು ಶುದ್ಧಗೊಳಿಸುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ಸ್ವಲ್ಪ ಧೂಪವನ್ನು ಅರೆದು ಪುಡಿ ಮಾಡು. ಈ ಪುಡಿಯನ್ನು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿರುವ ಒಡಂಬಡಿಕೆ ಪೆಟ್ಟಿಗೆಯ ಮುಂದೆ ನಾನು ನಿನಗೆ ದರ್ಶನ ಕೊಡುವ ಸ್ಥಳದಲ್ಲಿಡು. ಈ ಧೂಪದ ಪುಡಿಯನ್ನು ಅದರ ವಿಶೇಷ ಉದ್ದೇಶಕ್ಕಾಗಿ ಮಾತ್ರವೇ ಉಪಯೋಗಿಸಬೇಕು. ಅದು ಅತಿ ಪರಿಶುದ್ಧವಾದದ್ದು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ನೀನು ಈ ಧೂಪವನ್ನು ಯೆಹೋವನಿಗಾಗಿ ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ಮಾತ್ರ ಉಪಯೋಗಿಸಬೇಕು. ನೀನು ಈ ಧೂಪವನ್ನು ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ತಯಾರಿಸಬೇಕು. ಈ ರೀತಿ ವಿಶೇಷವಾಗಿ ಬೇರೆ ಯಾವ ಧೂಪವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ಸುವಾಸನೆಗೋಸ್ಕರ ಒಬ್ಬನು ತನಗಾಗಿ ಸ್ವಲ್ಪ ಧೂಪವನ್ನು ಈ ರೀತಿಯಲ್ಲಿ ಮಾಡಿದರೆ ಅವನನ್ನು ಅವನ ಜನರಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೀಗೆಂದನು: ");
INSERT INTO kan2010_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ನಾನು ಯೆಹೂದ ಕುಲದಿಂದ ಊರಿಯ ಮಗನಾದ ಬೆಚಲೇಲನನ್ನು ಆರಿಸಿಕೊಂಡಿದ್ದೇನೆ. ಊರಿಯು ಹೂರನ ಮಗನು. ");
INSERT INTO kan2010_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ನಾನು ಬೆಚಲೇಲನನ್ನು ದೇವರಾತ್ಮಭರಿತನನ್ನಾಗಿ ಮಾಡಿದ್ದೇನೆ. ನಾನು ಅವನಿಗೆ ಎಲ್ಲಾ ಬಗೆಯ ಕೆಲಸಗಳನ್ನು ಮಾಡಲು ನಿಪುಣತೆಯನ್ನೂ ಜ್ಞಾನವನ್ನೂ ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ಬೆಚಲೇಲನು ಬಹಳ ಉತ್ತಮ ಚಿತ್ರಕಾರನಾಗಿದ್ದಾನೆ. ಬೆಳ್ಳಿಬಂಗಾರಗಳ ಮತ್ತು ತಾಮ್ರದ ವಸ್ತುಗಳನ್ನು ಅವನು ಮಾಡಬಲ್ಲನು. ");
INSERT INTO kan2010_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ಅವನು ರತ್ನಗಳನ್ನು ಕೆತ್ತಿ ಅಂದವಾದ ಆಭರಣಗಳನ್ನು ಮಾಡಬಲ್ಲನು ಮತ್ತು ಮರಗೆಲಸವನ್ನು ಮಾಡಬಲ್ಲನು. ಅವನು ಎಲ್ಲಾ ತರದ ಕೆಲಸಗಳನ್ನು ಮಾಡಬಲ್ಲನು. ");
INSERT INTO kan2010_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ಅವನೊಂದಿಗೆ ಕೆಲಸ ಮಾಡಲು ನಾನು ಒಹೊಲೀಯಾಬನನ್ನು ಆರಿಸಿಕೊಂಡಿದ್ದೇನೆ. ಒಹೊಲೀಯಾಬನು ದಾನ್ ಕುಲದ ಅಹೀಸಾಮಾಕನ ಮಗನು. ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೆಲ್ಲವನ್ನೂ ಮಾಡುವುದಕ್ಕೆ ಬೇರೆ ಕೆಲಸಗಾರರಿಗೆಲ್ಲಾ ನಿಪುಣತೆಯನ್ನು ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ: ");
INSERT INTO kan2010_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ದೇವದರ್ಶನಗುಡಾರ, ಒಡಂಬಡಿಕೆ ಪೆಟ್ಟಿಗೆ, ಕೃಪಾಸನ, ಗುಡಾರದ ಎಲ್ಲಾ ಉಪಕರಣಗಳು, ");
INSERT INTO kan2010_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ಮೇಜು ಮತ್ತು ಅದರ ಮೇಲಿನ ವಸ್ತುಗಳು, ಬಂಗಾರದ ದೀಪಸ್ತಂಭ ಮತ್ತು ಅದರ ಉಪಕರಣಗಳು, ");
INSERT INTO kan2010_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ಧೂಪವೇದಿಕೆ, ಯಜ್ಞವೇದಿಕೆ ಮತ್ತು ಅವುಗಳ ಉಪಕರಣಗಳು, ಗಂಗಾಳ ಮತ್ತು ಅದರ ಪೀಠ. ");
INSERT INTO kan2010_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ಯಾಜಕನಾದ ಆರೋನನ ಎಲ್ಲಾ ವಿಶೇಷ ಬಟ್ಟೆಗಳು, ಆರೋನನ ಪುತ್ರರು ಯಾಜಕರಾಗಿ ಸೇವೆ ಮಾಡುವಾಗ ಧರಿಸಿಕೊಳ್ಳತಕ್ಕ ಎಲ್ಲಾ ಬಟ್ಟೆಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ಸುವಾಸನೆಯುಳ್ಳ ಅಭಿಷೇಕತೈಲ, ಪವಿತ್ರ ಸ್ಥಳದಲ್ಲಿ ಉಪಯೋಗಿಸುವ ಸುವಾಸನೆಯುಳ್ಳ ಧೂಪ. ನಾನು ನಿನಗೆ ಆಜ್ಞಾಪಿಸಿದ ರೀತಿಯಲ್ಲೇ ಈ ಕೆಲಸಗಾರರು ಈ ವಸ್ತುಗಳನ್ನೆಲ್ಲಾ ಮಾಡತಕ್ಕದ್ದು.” ");
INSERT INTO kan2010_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೀಗೆಂದನು: ");
INSERT INTO kan2010_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ಇದನ್ನು ಇಸ್ರೇಲರಿಗೆ ಹೇಳು: ‘ನೀವು ನನ್ನ ವಿಶೇಷವಾದ ಸಬ್ಬತ್ ದಿನವನ್ನು ಖಂಡಿತವಾಗಿ ಆಚರಿಸಬೇಕು. ಯೆಹೋವನಾದ ನಾನು ನಿಮ್ಮನ್ನು ನನ್ನ ವಿಶೇಷ ಜನರನ್ನಾಗಿ ಮಾಡಿರುವುದಕ್ಕೆ ಇದು ಗುರುತಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘ಸಬ್ಬತ್ ದಿನವನ್ನು ವಿಶೇಷ ದಿನವೆಂದು ಪರಿಗಣಿಸಿ ಆಚರಿಸಿರಿ. ಆ ದಿನವನ್ನು ಬೇರೆ ದಿನದಂತೆ ಪರಿಗಣಿಸಿ ನಡೆಯುವವನಿಗೆ ಮರಣದಂಡನೆಯಾಗಬೇಕು. ಸಬ್ಬತ್ ದಿನದಲ್ಲಿ ಯಾವನಾದರೂ ಕೆಲಸಮಾಡಿದರೆ ಅವನನ್ನು ಬಹಿಷ್ಕರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ಕೆಲಸ ಮಾಡುವುದಕ್ಕೆ ವಾರದಲ್ಲಿ ಬೇರೆ ಆರು ದಿನಗಳಿವೆ. ಆದರೆ ಏಳನೆಯ ದಿನವು ವಿಶ್ರಾಂತಿಯ ಬಹು ವಿಶೇಷವಾದ ದಿನವಾಗಿದೆ. ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸಲು ಅದೊಂದು ವಿಶೇಷ ದಿನವಾಗಿದೆ. ಸಬ್ಬತ್ತಿನ ಸಮಯದಲ್ಲಿ ಕೆಲಸಮಾಡುವವನು ಕೊಲ್ಲಲ್ಪಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ಇಸ್ರೇಲರು ಸಬ್ಬತ್ ದಿನವನ್ನು ಜ್ಞಾಪಿಸಿಕೊಂಡು ಅದನ್ನು ವಿಶೇಷ ದಿನವನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳತಕ್ಕದ್ದು. ಅವರು ಇದನ್ನು ಎಂದೆಂದೂ ಮಾಡತಕ್ಕದ್ದು. ಇದು ಎಂದೆಂದಿಗೂ ಮುಂದುವರಿಯುವ ಒಡಂಬಡಿಕೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ಸಬ್ಬತ್ ನನಗೂ ಮತ್ತು ಇಸ್ರೇಲರಿಗೂ ನಡುವೆ ಎಂದೆಂದೂ ಇರುವ ಸೂಚನೆಯಾಗಿರುವುದು.’” ಯೆಹೋವನು ಆರು ದಿನಗಳಲ್ಲಿ ಕೆಲಸಮಾಡಿ ಆಕಾಶವನ್ನೂ ಭೂಮಿಯನ್ನೂ ಉಂಟುಮಾಡಿದನು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಕೆಲಸ ಮಾಡದೆ ವಿಶ್ರಮಿಸಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ಹೀಗೆ, ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮಾತಾಡುವುದನ್ನು ಮುಗಿಸಿದನು. ಬಳಿಕ ಯೆಹೋವನು ಒಡಂಬಡಿಕೆ ಬರೆಯಲ್ಪಟ್ಟಿದ್ದ ಎರಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳನ್ನು ಮೋಶೆಗೆ ಕೊಟ್ಟನು. ಅವು ದೇವರ ಬೆರಳಿನಿಂದ ಲಿಖಿತವಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ಬಹಳ ಸಮಯ ದಾಟಿಹೋದರೂ ಮೋಶೆ ಬೆಟ್ಟದಿಂದ ಕೆಳಗಿಳಿಯಲಿಲ್ಲವಾದ್ದರಿಂದ ಇಸ್ರೇಲರು ಆರೋನನ ಬಳಿಗೆ ಒಟ್ಟಾಗಿ ಬಂದು, “ನೋಡು, ಮೋಶೆಯು ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ಆದರೆ ಅವನಿಗೇನಾಯಿತೊ ನಮಗೆ ತಿಳಿಯದು. ಆದ್ದರಿಂದ ನಮ್ಮನ್ನು ಮುನ್ನಡೆಸಲು ಕೆಲವು ದೇವರುಗಳನ್ನು ಮಾಡಿಕೊಡು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ಆರೋನನು ಅವರಿಗೆ, “ನಿಮ್ಮ ಹೆಂಡತಿಯ ಮತ್ತು ಗಂಡು ಹೆಣ್ಣುಮಕ್ಕಳಲ್ಲಿರುವ ಚಿನ್ನದ ಓಲೆಗಳನ್ನು ತಂದು ನನಗೆ ಕೊಡಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ಆದ್ದರಿಂದ ಅವರೆಲ್ಲರೂ ತಮ್ಮ ಚಿನ್ನದ ಓಲೆಗಳನ್ನು ತಂದುಕೊಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ಆರೋನನು ಬಸವನ ಮೂರ್ತಿಯನ್ನು ಚಿನ್ನದಿಂದ ಎರಕಹೊಯ್ಯಿಸಿದನು. ಬಳಿಕ ಅವರು, “ಇಸ್ರೇಲರೇ, ನಿಮ್ಮ ದೇವರುಗಳು ಇಲ್ಲಿವೆ! ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದ ದೇವರುಗಳು ಇವುಗಳೇ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ಆರೋನನು ಇವೆಲ್ಲವನ್ನು ನೋಡಿ, ಬಸವನ ಮುಂದೆ ಒಂದು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಟ್ಟಿಸಿದನು. ಬಳಿಕ, “ನಾಳೆ ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸಲು ಒಂದು ವಿಶೇಷ ಹಬ್ಬವಿರುವುದು” ಎಂದು ಪ್ರಕಟಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ಮರುದಿನ ಮುಂಜಾನೆ ಜನರೆಲ್ಲರೂ ಬೇಗನೆ ಎದ್ದು ತಮ್ಮ ಪಶುಗಳನ್ನು ವಧಿಸಿ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನಾಗಿಯೂ ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನಾಗಿಯೂ ಅರ್ಪಿಸಿ ತಿನ್ನುವುದಕ್ಕೂ ಕುಡಿಯುವುದಕ್ಕೂ ಕುಳಿತುಕೊಂಡರು. ಬಳಿಕ ಎದ್ದು ಕುಣಿದಾಡಿದರು ಮತ್ತು ಕೂಗಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ಅದೇ ಸಮಯದಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಬೆಟ್ಟದಿಂದ ಇಳಿದುಹೋಗು. ನೀನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದ ನಿನ್ನ ಜನರು ಭಯಂಕರವಾದ ಪಾಪ ಮಾಡಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ನಾನು ಅವರಿಗೆ ಆಜ್ಞಾಪಿಸಿದವುಗಳಿಗೆ ಬಹುಬೇಗನೆ ಅವಿಧೇಯರಾಗಿದ್ದಾರೆ. ಚಿನ್ನವನ್ನು ಕರಗಿಸಿ ಅದರಿಂದ ಬಸವನನ್ನು ಮಾಡಿಕೊಂಡು ಅದನ್ನು ಪೂಜಿಸುತ್ತಾ ಅದಕ್ಕೆ ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸುತ್ತಿದ್ದಾರೆ. ‘ಇಸ್ರೇಲರೇ ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದ ದೇವರುಗಳು ಇವುಗಳು’ ಎಂದು ಜನರು ಹೇಳುತ್ತಿದ್ದಾರೆ” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನು ಈ ಜನರನ್ನು ನೋಡಿದ್ದೇನೆ. ಅವರು ಬಹಳ ಮೊಂಡರೆಂದು ನಾನು ಬಲ್ಲೆನು. ಅವರು ಯಾವಾಗಲೂ ನಿನಗೆ ವಿರೋಧವಾಗಿ ದಂಗೆ ಏಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ಆದ್ದರಿಂದ ನಾನು ಅವರನ್ನು ಕೋಪದಿಂದ ನಾಶಮಾಡಿಬಿಡುತ್ತೇನೆ. ನನ್ನನ್ನು ತಡೆಯಬೇಡ. ಬಳಿಕ ನಾನು ನಿನ್ನಿಂದ ಒಂದು ಮಹಾಜನಾಂಗವನ್ನು ಉಂಟುಮಾಡುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ಆದರೆ ಮೋಶೆಯು ತನ್ನ ದೇವರಾದ ಯೆಹೋವನಿಗೆ, “ಯೆಹೋವನೇ, ನಿನ್ನ ಕೋಪವು ನಿನ್ನ ಜನರನ್ನು ನಾಶಮಾಡದಿರಲಿ. ನಿನ್ನ ಮಹಾಶಕ್ತಿಯಿಂದಲೂ ಬಲದಿಂದಲೂ ಈ ಜನರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದೆಯಲ್ಲಾ. ");
INSERT INTO kan2010_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ಆದರೆ ನೀನು ನಿನ್ನ ಜನರನ್ನು ನಾಶಮಾಡಿದರೆ, ಈಜಿಪ್ಟಿನವರು, ‘ಯೆಹೋವನು ತನ್ನ ಜನರಿಗೆ ಕೇಡನ್ನು ಮಾಡುವುದಕ್ಕಾಗಿಯೇ ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಹೋದನು. ಆತನು ಅವರನ್ನು ಬೆಟ್ಟಗಳಲ್ಲಿ ಕೊಲ್ಲಬೇಕೆಂದಿದ್ದನು; ತನ್ನ ಜನರನ್ನು ಭೂಮಿಯಿಂದ ನಿರ್ಮೂಲ ಮಾಡಬೇಕೆಂದಿದ್ದನು’ ಎಂದು ಹೇಳುವರು. ಆದ್ದರಿಂದ ನಿನ್ನ ಜನರ ಮೇಲೆ ಕೋಪಗೊಳ್ಳಬೇಡ. ನಿನ್ನ ಕೋಪವನ್ನು ಬಿಟ್ಟುಬಿಡು. ನಿನ್ನ ಜನರನ್ನು ನಾಶಮಾಡಬೇಡ. ");
INSERT INTO kan2010_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ನಿನ್ನ ಸೇವೆಮಾಡಿದ ಅಬ್ರಹಾಮನನ್ನು, ಇಸಾಕನನ್ನು, ಇಸ್ರೇಲನನ್ನು ಜ್ಞಾಪಿಸಿಕೊ. ನೀನು ನಿನ್ನ ಹೆಸರನ್ನು ಉಪಯೋಗಿಸಿ ಆ ಜನರಿಗೆ ವಾಗ್ದಾನವನ್ನು ಮಾಡಿದೆ. ‘ನಾನು ನಿನ್ನ ಸಂತತಿಯವರನ್ನು ಆಕಾಶದ ನಕ್ಷತ್ರಗಳಷ್ಟು ಮಾಡುವೆನು. ನಾನು ವಾಗ್ದಾನ ಮಾಡಿದಂತೆ ಈ ದೇಶವನ್ನೆಲ್ಲಾ ನಿನ್ನ ಸಂತತಿಗಳವರಿಗೆ ಕೊಡುವೆನು. ಈ ದೇಶ ಎಂದೆಂದಿಗೂ ಅವರದಾಗಿರುವುದು’ ಎಂದು ನೀನು ನಿನ್ನ ಹೆಸರಿನಲ್ಲಿ ವಾಗ್ದಾನ ಮಾಡಿದೆಯಲ್ಲಾ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ಆದ್ದರಿಂದ ಯೆಹೋವನು ಜನರಿಗಾಗಿ ಮರುಕಪಟ್ಟು ತನ್ನ ಮನಸ್ಸನ್ನು ಮಾರ್ಪಡಿಸಿಕೊಂಡನು; ತಾನು ಹೇಳಿದ್ದ ಕೇಡನ್ನು ಮಾಡಲಿಲ್ಲ; ತನ್ನ ಜನರನ್ನು ನಾಶಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ಬಳಿಕ ಮೋಶೆ ಬೆಟ್ಟದಿಂದಿಳಿದು ಹೋದನು. ಮೋಶೆಯೊಡನೆ ಆಜ್ಞಾಶಾಸನಗಳ ಎರಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳಿದ್ದವು. ಈ ಆಜ್ಞಾಶಾಸನಗಳ ಕಲ್ಲುಗಳ ಮುಂದೆಯೂ ಹಿಂದೆಯೂ ಬರೆಯಲ್ಪಟ್ಟಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ಯೆಹೋವನು ತಾನೇ ಆ ಕಲ್ಲುಗಳನ್ನು ಮಾಡಿ ಅವುಗಳ ಮೇಲೆ ಬರೆದಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ಇಸ್ರೇಲರ ಗದ್ದಲವನ್ನೂ ಕೂಗಾಟವನ್ನೂ ಯೆಹೋಶುವನು ಕೇಳಿ ಮೋಶೆಗೆ, “ಪಾಳೆಯದ ಕಡೆಯಿಂದ ಯುದ್ಧದ ಧ್ವನಿ ಕೇಳಿಬರುತ್ತಿದೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ಅದಕ್ಕೆ ಮೋಶೆ, “ಅದು ಸೈನ್ಯದ ಜಯಧ್ವನಿಯಲ್ಲ. ಅದು ಸೋಲಿನಿಂದ ಕೂಗುವ ಸೈನ್ಯದ ಧ್ವನಿಯೂ ಅಲ್ಲ. ನಾನು ಕೇಳುತ್ತಿರುವುದು ಗೋಷ್ಠಿಯ ಧ್ವನಿ” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ಮೋಶೆಯು ಪಾಳೆಯದ ಹತ್ತಿರಕ್ಕೆ ಬಂದನು. ಅವನು ಚಿನ್ನದ ಬಸವನನ್ನೂ ಜನರ ನರ್ತನವನ್ನೂ ನೋಡಿ ಬಹುಕೋಪಗೊಂಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳನ್ನು ನೆಲದ ಮೇಲೆ ಬಿಸಾಡಿಬಿಟ್ಟನು; ಅವು ಚೂರುಚೂರಾಗಿ ಒಡೆದುಹೋದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ಬಳಿಕ ಮೋಶೆಯು ಆ ಬಸವನ ಮೂರ್ತಿಯನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಕರಗಿಸಿ ಅದರ ಚಿನ್ನವನ್ನು ಧೂಳಿನಂತೆ ಅರೆದು ನೀರಿಗೆ ಹಾಕಿ ಆ ನೀರನ್ನು ಇಸ್ರೇಲರಿಗೆ ಕುಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ಈ ಜನರು ನಿನಗೇನು ಮಾಡಿದರು? ಇಂಥಾ ಕೆಟ್ಟ ಪಾಪವನ್ನು ಮಾಡುವಂತೆ ಯಾಕೆ ಅವರನ್ನು ನಡಿಸಿದೆ?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ಆರೋನನು, “ಕೋಪಗೊಳ್ಳಬೇಡ. ಇವರು ಯಾವಾಗಲೂ ಪಾಪಮಾಡಲು ಸಿದ್ಧರಾಗಿರುವುದು ನಿನಗೆ ಗೊತ್ತೇ ಇದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ಅವರು ನನಗೆ, ‘ಮೋಶೆಯು ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ನಡೆಸಿದನು. ಆದರೆ ಅವನಿಗೇನಾಯಿತೊ ನಮಗೆ ತಿಳಿಯದು. ಆದ್ದರಿಂದ ನಮ್ಮನ್ನು ಮುನ್ನಡೆಸಲು ದೇವರುಗಳನ್ನು ಮಾಡಿಕೊಡು’ ಎಂದು ಕೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ಆದ್ದರಿಂದ ನಾನು ಅವರಿಗೆ, ‘ನಿಮ್ಮಲ್ಲಿ ಚಿನ್ನದ ಆಭರಣಗಳಿದ್ದರೆ ನನಗೆ ಕೊಡಿರಿ’ ಎಂದು ಹೇಳಿದೆನು. ಅವರು ಆಭರಣಗಳನ್ನು ನನಗೆ ತಂದುಕೊಟ್ಟರು. ನಾನು ಅವುಗಳನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಕರಗಿಸಿ ಈ ಬಸವನ ಮೂರ್ತಿಯನ್ನು ಎರಕಹೊಯ್ದೆನು” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ಜನರು ಅಂಕೆತಪ್ಪಿ ತಮ್ಮ ಇಷ್ಟಬಂದಂತೆ ಮಾಡುವುದಕ್ಕೆ ಆರೋನನು ಅವರನ್ನು ಬಿಟ್ಟುಬಿಟ್ಟಿರುವುದು ಮೋಶೆಗೆ ತಿಳಿಯಿತು. ಜನರು ಕ್ರಮವಿಲ್ಲದೆ ಸ್ವೇಚ್ಛೆಯಿಂದ ನಡೆಯುತ್ತಿದ್ದರು; ಅವರ ಮೂರ್ಖತನವು ಅವರ ವಿರೋಧಿಗಳಿಗೆ ಎದ್ದುಕಾಣುತ್ತಿತ್ತು! ");
INSERT INTO kan2010_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ಆದ್ದರಿಂದ ಪಾಳೆಯದ ದ್ವಾರದಲ್ಲಿ ಮೋಶೆಯು ನಿಂತು, “ಯೆಹೋವನ ಪಕ್ಷದವರು ನನ್ನ ಬಳಿಗೆ ಬರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ಲೇವಿ ಕುಲದವರೆಲ್ಲಾ ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ಆಗ ಮೋಶೆ ಅವರಿಗೆ, “ಇಸ್ರೇಲರ ದೇವರಾದ ಯೆಹೋವನು ಹೇಳುವುದನ್ನು ನಿಮಗೆ ತಿಳಿಸುತ್ತೇನೆ: ‘ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ಕತ್ತಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಪಾಳೆಯದ ಒಂದು ಕೊನೆಯಿಂದ ಇನ್ನೊಂದು ಕೊನೆಯವರೆಗೆ ಹೋಗಿ ಜನರನ್ನು ಶಿಕ್ಷಿಸಬೇಕು. ನಿಮ್ಮ ಸಹೋದರರಾಗಿದ್ದರೂ ಸ್ನೇಹಿತರಾಗಿದ್ದರೂ ಅಥವಾ ನೆರೆಯವರಾಗಿದ್ದರೂ ಸರಿ, ಕೊಲ್ಲಿರಿ’” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ಲೇವಿಕುಲದವರು ಮೋಶೆಯ ಮಾತಿಗೆ ವಿಧೇಯರಾದರು. ಅಂದು ಇಸ್ರೇಲರಲ್ಲಿ ಸುಮಾರು ಮೂರು ಸಾವಿರ ಮಂದಿ ಸತ್ತರು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ಆಗ ಮೋಶೆಯು ಅವರಿಗೆ, “ಇಂದು ನೀವು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾದ ಜನರಾದಿರಿ; ಯಾಕೆಂದರೆ ನೀವು ನಿಮ್ಮ ಸ್ವಂತ ಗಂಡು ಮಗನಿಗೂ ಸಹೋದರನಿಗೂ ವಿರೋಧವಾದಿರಿ. ಇಂದು ಆತನು ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದಾನೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ಮರುದಿನ ಮುಂಜಾನೆ ಮೋಶೆಯು ಜನರಿಗೆ, “ನೀವು ಭಯಂಕರವಾದ ಪಾಪವನ್ನು ಮಾಡಿದ್ದೀರಿ. ಆದರೆ ಈಗ ನಾನು ಯೆಹೋವನ ಬಳಿಗೆ ಹೋಗಿ, ಆತನು ನಿಮ್ಮ ಪಾಪಗಳನ್ನು ಕ್ಷಮಿಸುವಂತೆ ನಾನೇನಾದರೂ ಮಾಡಬಹುದೊ ಎಂದು ವಿಚಾರಿಸುತ್ತೇನೆ” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ಅಂತೆಯೇ ಮೋಶೆಯು ಯೆಹೋವನ ಬಳಿಗೆ ಮರಳಿ ಹೋಗಿ, “ದಯವಿಟ್ಟು ಆಲಿಸು! ಈ ಜನರು ಬಹಳ ಕೆಟ್ಟ ಪಾಪವನ್ನು ಮಾಡಿದ್ದಾರೆ. ಚಿನ್ನದಿಂದ ಮೂರ್ತಿಯನ್ನು ಮಾಡಿಕೊಂಡಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ಅವರ ಈ ಪಾಪವನ್ನು ಕ್ಷಮಿಸು. ನೀನು ಅವರನ್ನು ಕ್ಷಮಿಸುವುದಿಲ್ಲವಾದರೆ ನಿನ್ನ ಜೀವಭಾದ್ಯರ ಪಟ್ಟಿಯ ಪುಸ್ತಕದಿಂದ ನನ್ನ ಹೆಸರನ್ನು ಅಳಿಸಿಬಿಡು” ಎಂದು ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ಆದರೆ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನನಗೆ ವಿರೋಧವಾಗಿ ಪಾಪಮಾಡುವ ಜನರ ಹೆಸರನ್ನು ಮಾತ್ರವೇ ನನ್ನ ಪುಸ್ತಕದಿಂದ ಅಳಿಸುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ಆದ್ದರಿಂದ ಈಗ ಕೆಳಗಿಳಿದು ನಾನು ನಿನಗೆ ಹೇಳುವಲ್ಲಿಗೆ ಜನರನ್ನು ನಡಿಸು. ನನ್ನ ದೂತನು ನಿನ್ನ ಮುಂದೆ ಹೋಗಿ ನಿನ್ನನ್ನು ನಡಿಸುವನು. ಪಾಪಮಾಡಿದ ಜನರನ್ನು ಶಿಕ್ಷಿಸುವ ಸಮಯ ಬಂದಾಗ ಅವರು ಶಿಕ್ಷಿಸಲ್ಪಡುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ಆದ್ದರಿಂದ ಯೆಹೋವನು ಜನರಿಗೆ ಭಯಂಕರವಾದ ವ್ಯಾದಿಯನ್ನು ಬರಮಾಡಿದನು. ಅವರು ಆರೋನನಿಂದ ಬಸವನನ್ನು ಮಾಡಿಸಿಕೊಂಡದ್ದೇ ಇದಕ್ಕೇ ಕಾರಣ. ");
INSERT INTO kan2010_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಮತ್ತು ಈಜಿಪ್ಟಿನಿಂದ ನೀನು ಕರೆದುಕೊಂಡು ಬಂದ ಜನರು ಈ ಸ್ಥಳವನ್ನು ಬಿಡಬೇಕು. ನಾನು ಅಬ್ರಹಾಮನಿಗೆ, ಇಸಾಕನಿಗೆ ಮತ್ತು ಯಾಕೋಬನಿಗೆ ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶಕ್ಕೆ ಹೋಗಿ. ನಾನು ಅವರಿಗೆ ‘ನಿಮ್ಮ ನಂತರ ಜೀವಿಸುವ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಆ ದೇಶವನ್ನು ಕೊಡುವೆನು’ ಎಂದು ನಾನು ಅವರಿಗೆ ವಾಗ್ದಾನ ಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ನಿಮ್ಮ ಮುಂದೆ ಹೋಗುವುದಕ್ಕೆ ನಾನು ಒಬ್ಬ ದೂತನನ್ನು ಕಳುಹಿಸುವೆನು. ಕಾನಾನ್ಯರನ್ನು, ಅಮೋರಿಯರನ್ನು, ಹಿತ್ತಿಯರನ್ನು, ಪೆರಿಜೀಯರನ್ನು, ಹಿವ್ವಿಯರನ್ನು ಮತ್ತು ಯೆಬೂಸಿಯರನ್ನು ನಾನು ಸೋಲಿಸುವೆನು. ನಿಮ್ಮ ದೇಶದಿಂದ ಅವರನ್ನು ಬಲವಂತದಿಂದ ಅಟ್ಟಿಬಿಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ಆದ್ದರಿಂದ ಸಮೃದ್ಧಿಕರವಾದ ಆ ದೇಶಕ್ಕೆ ಹೋಗಿರಿ. ಆದರೆ ನಾನು ನಿಮ್ಮೊಂದಿಗೆ ಬರುವುದಿಲ್ಲ. ನೀವು ನನ್ನ ಆಜ್ಞೆಗೆ ವಿಧೇಯರಾಗದೆ ನನ್ನನ್ನು ಕೋಪಗೊಳಿಸುತ್ತೀರಿ. ನಾನು ನಿಮ್ಮೊಂದಿಗೆ ಬಂದರೆ, ದಾರಿಯಲ್ಲಿ ನಿಮ್ಮನ್ನು ಸಂಹರಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ಈ ದುಃಖದ ಸಮಾಚಾರವನ್ನು ಕೇಳಿ ಜನರು ನೊಂದುಕೊಂಡರು. ಅವರಲ್ಲಿ ಒಬ್ಬರಾದರೂ ತಮ್ಮ ಆಭರಣಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆಂದು ಹೇಳು: ನೀವು ಅವಿಧೇಯರಾದ ಜನರಾಗಿದ್ದೀರಿ. ನಾನು ನಿಮ್ಮೊಡನೆ ಕ್ಷಣಹೊತ್ತು ಸಂಚರಿಸಿದರೆ, ನಿಮ್ಮನ್ನು ಸಂಹರಿಸುವೆನು. ಆದ್ದರಿಂದ ನಿಮ್ಮೆಲ್ಲಾ ಆಭರಣಗಳನ್ನು ತೆಗೆದುಬಿಡಿರಿ. ನೀವು ಮಾಡಬೇಕಾದದ್ದನ್ನು ನಾನೇ ತಿಳಿಸುವೆನು!” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ಇಸ್ರೇಲರು ಹೋರೆಬ್ ಬೆಟ್ಟದಲ್ಲಿದ್ದಾಗ ಆಭರಣಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳುವುದನ್ನು ಬಿಟ್ಟುಬಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ಮೋಶೆಯು ಗುಡಾರವನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಸ್ವಲ್ಪದೂರ ತೆಗೆದುಕೊಂಡು ಹೋಗುತ್ತಿದ್ದನು. ಮೋಶೆಯು ಅದನ್ನು, “ದೇವದರ್ಶನದ ಗುಡಾರ” ಎಂದು ಕರೆದನು. ಯೆಹೋವನಿಂದ ಉತ್ತರವನ್ನು ಕೇಳಬೇಕೆಂದು ಬಯಸುವ ವ್ಯಕ್ತಿಯು ಪಾಳೆಯದ ಹೊರಗಿದ್ದ ದೇವದರ್ಶನ ಗುಡಾರಕ್ಕೆ ಹೋಗುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ಮೋಶೆಯು ಆ ಗುಡಾರದೊಳಗೆ ಹೋಗುವಾಗ ಜನರೆಲ್ಲರೂ ಅವನನ್ನು ಗಮನಿಸುತ್ತಿದ್ದರು. ಜನರು ತಮ್ಮ ಡೇರೆಗಳ ದ್ವಾರಗಳಲ್ಲಿ ನಿಂತುಕೊಂಡು ಮೋಶೆಯು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಪ್ರವೇಶಿಸುವವರೆಗೆ ಅವನನ್ನು ಗಮನಿಸುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ಮೋಶೆಯು ಗುಡಾರದೊಳಕ್ಕೆ ಹೋದಾಗ ಎತ್ತರವಾದ ಮೇಘಸ್ತಂಭವು ಯಾವಾಗಲೂ ಕೆಳಗಿಳಿಯುತ್ತಿತ್ತು. ಆ ಮೇಘಸ್ತಂಭವು ಗುಡಾರದ ದ್ವಾರದಲ್ಲಿ ನಿಲ್ಲುತ್ತಿತ್ತು. ಹೀಗೆ ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಮಾತಾಡುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ಗುಡಾರದ ದ್ವಾರದಲ್ಲಿ ಮೇಘಸ್ತಂಭವಿರುವುದನ್ನು ಜನರು ನೋಡಿದಾಗ, ಅವರು ತಮ್ಮ ಸ್ವಂತ ಡೇರೆಗಳ ದ್ವಾರದಲ್ಲಿ ತಲೆಬಾಗಿ ಯೆಹೋವನನ್ನು ಆರಾಧಿಸುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮುಖಾಮುಖಿಯಾಗಿ ಮಾತಾಡುತ್ತಿದ್ದನು. ಒಬ್ಬನು ತನ್ನ ಸ್ನೇಹಿತನೊಂದಿಗೆ ಮಾತಾಡುವಂತೆ ಯೆಹೋವನು ಮೋಶೆಯೊಂದಿಗೆ ಮಾತಾಡುತ್ತಿದ್ದನು. ಯೆಹೋವನೊಂದಿಗೆ ಮಾತಾಡಿದ ನಂತರ ಮೋಶೆಯು ಪಾಳೆಯಕ್ಕೆ ಮರಳಿ ಹೋಗುತ್ತಿದ್ದನು. ನೂನನ ಮಗನೂ ಯೌವನಸ್ಥನೂ ಆಗಿದ್ದ ಯೆಹೋಶುವನು ಮೋಶೆಯ ಸಹಾಯಕನಾಗಿದ್ದನು. ಮೋಶೆಯು ಗುಡಾರವನ್ನು ಬಿಟ್ಟುಹೋದಾಗ ಯೆಹೋಶುವನು ಗುಡಾರದಲ್ಲಿಯೇ ಇರುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, “ಈ ಜನರನ್ನು ಮುನ್ನಡೆಸಬೇಕೆಂದು ನೀನು ನನಗೆ ಹೇಳಿರುವೆ. ಆದರೆ ನನ್ನೊಂದಿಗೆ ಯಾರನ್ನು ಕಳುಹಿಸುತ್ತೀಯೆಂದು ನೀನು ಹೇಳಲಿಲ್ಲ. ನೀನು ನನಗೆ, ‘ನಾನು ನಿನ್ನನ್ನು ಚೆನ್ನಾಗಿ ಬಲ್ಲೆನು. ನಾನು ನಿನ್ನನ್ನು ಮೆಚ್ಚಿದ್ದೇನೆ’ ಎಂದು ಹೇಳಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ನಾನು ನಿನ್ನನ್ನು ನಿಜವಾಗಿಯೂ ಮೆಚ್ಚಿಸಿರುವುದಾದರೆ, ನಾನು ನಿನ್ನನ್ನು ತಿಳಿದುಕೊಳ್ಳುವಂತೆ ನಿನ್ನ ಮಾರ್ಗಗಳನ್ನು ಬೋಧಿಸು. ಆಗ ನಾನು ನಿನ್ನನ್ನು ಯಾವಾಗಲೂ ಮೆಚ್ಚಿಸಲು ಸಾಧ್ಯವಾಗುವುದು. ಇವರೆಲ್ಲರೂ ನಿನ್ನ ಜನರೆಂದು ಜ್ಞಾಪಕಮಾಡಿಕೊ” ಎಂದು ವಿಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ಯೆಹೋವನು “ನಾನೇ ನಿಮ್ಮೊಡನೆ ಬರುವೆನು. ನಾನೇ ನಿಮ್ಮನ್ನು ಮುನ್ನಡೆಸುವೆನು” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ಆಗ ಮೋಶೆ ಯೆಹೋವನಿಗೆ, “ನೀನು ನಮ್ಮೊಂದಿಗೆ ಬರದಿದ್ದರೆ, ಈ ಸ್ಥಳದಿಂದ ನಮ್ಮನ್ನು ಕಳುಹಿಸಬೇಡ. ");
INSERT INTO kan2010_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ಮಾತ್ರವಲ್ಲದೆ ನನಗೂ ಈ ಜನರಿಗೂ ನಿನ್ನ ದಯೆ ದೊರಕಿದೆಯೆಂದು ನಾವು ತಿಳಿದುಕೊಳ್ಳುವುದಾದರೂ ಹೇಗೆ? ನೀನು ನಮ್ಮೊಡನೆ ಬಂದರೆ, ಆಗ ನಾವು ಇದನ್ನು ಖಚಿತವಾಗಿ ತಿಳಿದುಕೊಳ್ಳುವೆವು. ನೀನು ನಮ್ಮೊಡನೆ ಬಾರದಿದ್ದರೆ, ಆಗ ನಮಗೂ ಭೂಮಿಯ ಮೇಲಿರುವ ಇತರ ಜನರಿಗೂ ಯಾವ ವ್ಯತ್ಯಾಸವಿರುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಿನ್ನ ಕೋರಿಕೆಯನ್ನು ಅನುಗ್ರಹಿಸುತ್ತೇನೆ. ನಾನು ನಿನ್ನನ್ನು ಮೆಚ್ಚಿಕೊಂಡದ್ದರಿಂದಲೇ ಇದನ್ನು ಮಾಡುತ್ತೇನೆ. ನಾನು ನಿನ್ನನ್ನು ಚೆನ್ನಾಗಿ ಬಲ್ಲೆನು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ಬಳಿಕ ಮೋಶೆ, “ಈಗ ದಯವಿಟ್ಟು ನಿನ್ನ ಮಹಿಮೆಯನ್ನು ನನಗೆ ತೋರಿಸು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ಆಗ ಯೆಹೋವನು “ನನ್ನ ನಾಮದ ಮಹತ್ವವನ್ನು ನಿನ್ನ ಮುಂದೆ ದಾಟಿಹೋಗುವಂತೆ ಮಾಡುವೆನು. ನಾನೇ ಯೆಹೋವನು. ನಿನಗೆ ಕೇಳಿಸುವಂತೆ ನನ್ನ ಹೆಸರನ್ನು ಪ್ರಕಟಿಸುವೆನು. ನಾನು ಆರಿಸಿಕೊಂಡ ಜನರಿಗೆ ದಯೆಯನ್ನೂ ಪ್ರೀತಿಯನ್ನೂ ಅನುಗ್ರಹಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ನನ್ನನ್ನು ಯಾರೂ ಮುಖಾಮುಖಿಯಾಗಿ ಕಾಣಲು ಸಾಧ್ಯವಿಲ್ಲ. ನನ್ನನ್ನು ನೋಡಿದ ಯಾವನೂ ಬದುಕಲಾರನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“ಇಲ್ಲಿ ಒಂದು ಬಂಡೆ ಇದೆ. ನೀನು ಆ ಬಂಡೆಯ ಮೇಲೆ ನಿಂತುಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ನನ್ನ ಮಹಿಮೆಯು ಆ ಸ್ಥಳದ ಮೂಲಕ ದಾಟಿಹೋಗುವುದು. ನಾನು ನಿನ್ನನ್ನು ಆ ಬಂಡೆಯ ದೊಡ್ಡದಾದ ಬಿರುಕಿನಲ್ಲಿ ಇರಿಸುವೆನು; ನಾನು ದಾಟಿ ಹೋಗುವಾಗ ನನ್ನ ಕೈಯಿಂದ ನಿನ್ನನ್ನು ಮುಚ್ಚುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ಬಳಿಕ ನನ್ನ ಕೈಯನ್ನು ತೆಗೆಯುವೆನು. ಆಗ ನೀನು ನನ್ನ ಹಿಂಭಾಗವನ್ನು ನೋಡುವೆ; ಆದರೆ ನನ್ನ ಮುಖವು ನಿನಗೆ ಕಾಣಿಸದು” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಒಡೆದುಹೋದ ಮೊದಲಿನ ಎರಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳಂತೆ ಇನ್ನೆರಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳನ್ನು ಮಾಡು. ಮೊದಲಿನ ಕಲ್ಲುಗಳಲ್ಲಿ ಬರೆದಿದ್ದ ಮಾತುಗಳನ್ನೇ ನಾನು ಈ ಕಲ್ಲುಗಳ ಮೇಲೆ ಬರೆಯುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ನಾಳೆ ಮುಂಜಾನೆ ಸೀನಾಯಿ ಬೆಟ್ಟಕ್ಕೇರಿ ಬಾ. ಬೆಟ್ಟದ ಮೇಲೆ ನನ್ನೆದುರಿನಲ್ಲಿ ನಿಂತುಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ನಿನ್ನೊಂದಿಗೆ ಯಾರೂ ಬರಕೂಡದು. ಬೆಟ್ಟದ ಯಾವ ಸ್ಥಳದಲ್ಲಿಯೂ ಯಾರೂ ಕಾಣಿಸಬಾರದು. ನಿಮ್ಮ ಪಶುಗಳಾಗಲಿ ಕುರಿಮಂದೆಗಳಾಗಲಿ ಬೆಟ್ಟದ ಬುಡದಲ್ಲಿ ಹುಲ್ಲು ಮೇಯಕೂಡದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ಆದ್ದರಿಂದ ಮೋಶೆ ಮೊದಲಿನ ಎರಡು ಕಲ್ಲುಗಳಂತೆ ಇನ್ನೆರಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳನ್ನು ಮಾಡಿದನು. ಬಳಿಕ ಮರುದಿನ ಮುಂಜಾನೆ ಬೇಗನೆ ಸೀನಾಯಿ ಬೆಟ್ಟವನ್ನೇರಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಮೋಶೆಯು ಪ್ರತಿಯೊಂದನ್ನು ಮಾಡಿದನು. ಮೋಶೆಯು ಎರಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳನ್ನು ಹಿಡಿದುಕೊಂಡು ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ಮೋಶೆಯು ಬೆಟ್ಟವನ್ನೇರಿ ಹೋದನಂತರ ಯೆಹೋವನು ಮೇಘದಲ್ಲಿ ಅವನ ಬಳಿಗೆ ಇಳಿದು ಬಂದನು. ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಅಲ್ಲಿ ನಿಂತನು ಮತ್ತು ಮೋಶೆಯು ಯೆಹೋವನ ಹೆಸರನ್ನು ಕರೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ಯೆಹೋವನು ಮೋಶೆಯ ಮುಂದೆ ಹಾದುಹೋಗುತ್ತಾ, “ದೇವರಾದ ಯೆಹೋವನು ದಯೆಯೂ ಕನಿಕರವೂ ಉಳ್ಳ ದೇವರಾಗಿದ್ದಾನೆ. ಯೆಹೋವನು ಕೋಪಗೊಳ್ಳುವುದರಲ್ಲಿ ನಿಧಾನವಾಗಿದ್ದಾನೆ. ಯೆಹೋವನು ಮಹಾ ಪ್ರೀತಿಸ್ವರೂಪನಾಗಿದ್ದಾನೆ. ಯೆಹೋವನು ಭರವಸೆಗೆ ಯೋಗ್ಯನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ಯೆಹೋವನು ಸಾವಿರಾರು ತಲೆಗಳವರೆಗೆ ತನ್ನ ದಯೆ ತೋರಿಸುತ್ತಾನೆ. ಜನರು ಮಾಡುವ ಪಾಪಗಳನ್ನು ಯೆಹೋವನು ಕ್ಷಮಿಸುತ್ತಾನೆ. ಆದರೆ ಅಪರಾಧಿಗಳನ್ನು ಶಿಕ್ಷಿಸುವುದಕ್ಕೆ ಆತನು ಮರೆಯುವುದಿಲ್ಲ. ಯೆಹೋವನು ಅಪರಾಧಿಗಳನ್ನು ಶಿಕ್ಷಿಸುವನು ಮತ್ತು ಅವರ ಅಪರಾಧದ ಫಲವು ಅವರ ಮಕ್ಕಳ ಮೇಲೂ ಮೊಮ್ಮಕ್ಕಳ ಮೇಲೂ ಮತ್ತು ಮರಿಮೊಮ್ಮಕ್ಕಳ ಮೇಲೂ ಬರುವಂತೆ ಮಾಡುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ಕೂಡಲೆ ಮೋಶೆಯು ನೆಲದ ಮೇಲೆ ಅಡ್ಡಬಿದ್ದು ಯೆಹೋವನನ್ನು ಆರಾಧಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ಮೋಶೆಯು, “ಯೆಹೋವನೇ, ನಿನ್ನ ದಯೆ ನನಗೆ ದೊರಕುವುದಾದರೆ, ದಯವಿಟ್ಟು ನಮ್ಮೊಂದಿಗೆ ಬಾ. ಇವರು ಅವಿಧೇಯರಾದ ಜನರೆಂದು ನಾನು ಬಲ್ಲೆನು. ಆದರೆ ನಮ್ಮ ಪಾಪಗಳನ್ನು ಕ್ಷಮಿಸು. ನಮ್ಮನ್ನು ನಿನ್ನ ಜನರನ್ನಾಗಿ ಸ್ಪೀಕರಿಸು” ಎಂದು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ಆಗ ಯೆಹೋವನು, “ನಾನು ನಿಮ್ಮೊಂದಿಗೆ ಈ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡುತ್ತಿದ್ದೇನೆ. ಭೂಲೋಕದಲ್ಲಿ ಎಲ್ಲಿಯೇ ಆಗಲಿ ಯಾವ ಜನಾಂಗದಲ್ಲಿಯೇ ಆಗಲಿ ಹಿಂದೆಂದೂ ನಡೆಯದಂತ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ಮಾಡುವೆನು. ಎಲ್ಲಾ ಜನರು ಮತ್ತು ನಿನ್ನೊಂದಿಗಿರುವ ಜನರು ಇವುಗಳನ್ನು ನೋಡಿ ಯೆಹೋವನಾದ ನಾನೇ ಮಹಾ ಮಹಿಮಸ್ವರೂಪನೆಂದು ತಿಳಿದುಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ನಾನು ಈ ದಿನ ಕೊಡುವ ಆಜ್ಞೆಗಳಿಗೆ ವಿಧೇಯರಾಗಿರಿ. ನಿಮ್ಮ ವೈರಿಗಳಾದ ಅಮೋರಿಯರನ್ನು, ಕಾನಾನ್ಯರನ್ನು, ಹಿತ್ತಿಯರನ್ನು, ಪೆರಿಜೀಯರನ್ನು, ಹಿವ್ವಿಯರನ್ನು ಮತ್ತು ಯೆಬೂಸಿಯರನ್ನು ನಾನು ಹೊರಗಟ್ಟುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ಎಚ್ಚರಿಕೆಯಾಗಿರಿ! ನೀವು ಹೋಗುತ್ತಿರುವ ದೇಶದಲ್ಲಿರುವ ಜನರೊಂದಿಗೆ ಯಾವ ಒಪ್ಪಂದವನ್ನೂ ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ನೀವು ಆ ಜನರೊಂದಿಗೆ ಒಪ್ಪಂದ ಮಾಡಿಕೊಂಡರೆ, ಅದು ನಿಮಗೆ ಕೇಡನ್ನು ಬರಮಾಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ಅವರ ವೇದಿಕೆಗಳನ್ನು ನಾಶಮಾಡಿರಿ. ಅವರು ಪೂಜಿಸುವ ಕಲ್ಲುಗಳನ್ನು ಒಡೆದು ಹಾಕಿರಿ. ಅವರ ವಿಗ್ರಹಗಳನ್ನು ಕಡಿದು ಹಾಕಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ಬೇರೆ ಯಾವ ದೇವರನ್ನೂ ಪೂಜಿಸಬೇಡಿರಿ. ನಾನೇ ಯೆಹೋವನು. ‘ಸ್ವಗೌರವವನ್ನು ಕಾಪಾಡಿಕೊಳ್ಳುವವನು’ ಎಂಬುದೇ ನನ್ನ ಹೆಸರು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ಎಚ್ಚರಿಕೆಯಾಗಿರಿ, ಆ ದೇಶದಲ್ಲಿ ವಾಸಿಸುವ ಜನರೊಂದಿಗೆ ಯಾವ ಒಪ್ಪಂದವನ್ನೂ ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ಇಲ್ಲವಾದರೆ ಅವರು ತಮ್ಮ ದೇವರುಗಳನ್ನು ಪೂಜಿಸುವಾಗ ನೀವು ಅವರೊಂದಿಗೆ ಸೇರಿಕೊಳ್ಳುವಿರಿ. ಅವರೊಂದಿಗೆ ಸೇರಿಕೊಳ್ಳುವಂತೆ ನಿಮ್ಮನ್ನು ಆಹ್ವಾನಿಸುವರು; ಅವರ ಯಜ್ಞಾರ್ಪಣೆಗಳನ್ನು ತಿನ್ನುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ನೀವು ಅವರ ಪುತ್ರಿಯರಲ್ಲಿ ಕೆಲವರನ್ನು ನಿಮ್ಮ ಪುತ್ರರಿಗೆ ಹೆಂಡತಿಯರಾಗುವುದಕ್ಕೆ ಆರಿಸಿಕೊಳ್ಳುವಿರಿ. ಅವರ ಪುತ್ರಿಯರು ಸುಳ್ಳುದೇವರುಗಳ ಸೇವೆ ಮಾಡುತ್ತಾರೆ. ನಿಮ್ಮ ಪುತ್ರರನ್ನೂ ಅವರು ಅದೇ ಸೇವೆಗೆ ನಡೆಸುತ್ತಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“ವಿಗ್ರಹಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಹಬ್ಬವನ್ನು ಆಚರಿಸಿರಿ. ನಾನು ನಿಮಗೆ ಮೊದಲು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನು ಏಳು ದಿನಗಳವರೆಗೆ ತಿನ್ನಿರಿ. ನಾನು ಆರಿಸಿಕೊಂಡ ಅಬೀಬ್ ಮಾಸದಲ್ಲಿ ಇದನ್ನು ಮಾಡಿರಿ. ಯಾಕೆಂದರೆ ಆ ತಿಂಗಳಲ್ಲಿ ನೀವು ಈಜಿಪ್ಟಿನಿಂದ ಬಿಡುಗಡೆ ಹೊಂದಿದಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ಸ್ತ್ರೀಯಲ್ಲಿ ಹುಟ್ಟಿದ ಮೊದಲಿನ ಮಗು ಯಾವಾಗಲೂ ನನಗೆ ಸೇರಿದ್ದು. ನಿಮ್ಮ ದನಕುರಿಗಳಲ್ಲಿ ಹುಟ್ಟಿದ ಮೊದಲ ಮರಿಗಳು ನನಗೆ ಸೇರಿದವುಗಳಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ಚೊಚ್ಚಲಾಗಿ ಹುಟ್ಟಿದ ಕತ್ತೆಯನ್ನು ನೀವು ಇಟ್ಟುಕೊಳ್ಳಲು ಬಯಸಿದರೆ, ಆಗ ನೀವು ಕುರಿಮರಿಯನ್ನು ಕೊಟ್ಟು ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳಬಹುದು. ಆದರೆ ನೀವು ಅದನ್ನು ಕೊಂಡುಕೊಳ್ಳದಿದ್ದರೆ, ಅದರ ಕುತ್ತಿಗೆಯನ್ನು ಮುರಿದು ಕೊಂದುಬಿಡಬೇಕು. ನೀವು ನಿಮ್ಮ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನು ನನ್ನಿಂದ ಕೊಂಡುಕೊಳ್ಳಬೇಕು. ಯಾವ ವ್ಯಕ್ತಿಯೂ ಕಾಣಿಕೆಯಿಲ್ಲದೆ, ನನ್ನ ಸನ್ನಿಧಿಗೆ ಬರಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ನೀವು ವಾರದಲ್ಲಿ ಆರುದಿನ ಕೆಲಸ ಮಾಡುವಿರಿ. ಆದರೆ ಏಳನೆಯ ದಿನದಲ್ಲಿ ನೀವು ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಬೇಕು. ನೀವು ಬಿತ್ತುವ ಮತ್ತು ಕೊಯ್ಯುವ ಸಮಯದಲ್ಲಿಯೂ ವಿಶ್ರಮಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“ವಾರಗಳ ಹಬ್ಬವನ್ನು ಆಚರಿಸಿರಿ. ಈ ಹಬ್ಬಕ್ಕಾಗಿ ಗೋಧಿಬೆಳೆಯ ಪ್ರಥಮ ಕಾಳನ್ನು ಉಪಯೋಗಿಸಿರಿ ಮತ್ತು ವರ್ಷಾಂತ್ಯದಲ್ಲಿ ಸುಗ್ಗಿಹಬ್ಬವನ್ನು ಆಚರಿಸಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“ವರ್ಷದಲ್ಲಿ ಮೂರುಸಲ ನಿಮ್ಮಲ್ಲಿರುವ ಗಂಡಸರೆಲ್ಲರೂ, ಇಸ್ರೇಲರ ದೇವರಾಗಿರುವ ಒಡೆಯನಾದ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸೇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“ನೀವು ದೇಶದೊಳಕ್ಕೆ ಹೋದಾಗ, ನಾನು ನಿಮ್ಮ ವೈರಿಗಳನ್ನು ಆ ದೇಶದಿಂದ ಹೊರಗಟ್ಟುವೆನು. ನಾನು ನಿಮ್ಮ ಮೇರೆಗಳನ್ನು ವಿಸ್ತರಿಸುವೆನು. ನಿಮಗೆ ಹೆಚ್ಚೆಚ್ಚಾಗಿ ಭೂಮಿ ದೊರೆಯುವುದು. ಪ್ರತಿ ವರ್ಷ ಮೂರುಸಲ ನೀವು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಹೋಗುವಿರಿ. ಆ ಸಮಯದಲ್ಲಿ ಯಾರೂ ನಿಮ್ಮಿಂದ ಭೂಮಿಯನ್ನು ಅಪಹರಿಸಲು ಪ್ರಯತ್ನಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ನೀವು ಯಜ್ಞಮಾಡುವಾಗ ಆ ಯಜ್ಞಪಶುವಿನ ರಕ್ತದೊಡನೆ ಹುಳಿಹಿಟ್ಟನ್ನು ಸಮರ್ಪಿಸಬಾರದು; “ಪಸ್ಕ ಭೋಜನದ ಮಾಂಸದಲ್ಲಿ ಏನನ್ನೂ ಮರುದಿನದ ಮುಂಜಾನೆಯವರೆಗೆ ಉಳಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“ನೀವು ಕೊಯ್ಯುವ ಪ್ರಥಮವಾದ ಬೆಳೆಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಡಿರಿ. ಅವುಗಳನ್ನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಆಲಯಕ್ಕೆ ತನ್ನಿರಿ. “ಆಡುಮರಿಯನ್ನು ಅದರ ತಾಯಿಯ ಹಾಲಿನಲ್ಲಿ ಎಂದಿಗೂ ಬೇಯಿಸಬಾರದು.” ");
INSERT INTO kan2010_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನು ನಿನಗೆ ಹೇಳಿದ ಸಂಗತಿಗಳನ್ನೆಲ್ಲಾ ಬರೆ. ಆ ಸಂಗತಿಗಳು ನಾನು ನಿನ್ನೊಂದಿಗೆ ಮತ್ತು ಇಸ್ರೇಲರೊಂದಿಗೆ ಮಾಡಿದ ಒಡಂಬಡಿಕೆಯಾಗಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ಮೋಶೆಯು ಅಲ್ಲಿ ಯೆಹೋವನೊಂದಿಗೆ ಹಗಲಿರುಳು ನಲವತ್ತು ದಿನಗಳಿದ್ದನು. ಆ ದಿನಗಳಲ್ಲಿ ಅವನು ಆಹಾರವನ್ನಾಗಲಿ ನೀರನ್ನಾಗಲಿ ಸೇವಿಸಲಿಲ್ಲ. ಮೋಶೆಯು ಒಡಂಬಡಿಕೆಯ ವಾಕ್ಯಗಳನ್ನು ಅಂದರೆ ದಶಾಜ್ಞೆಗಳನ್ನು ಎರಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳ ಮೇಲೆ ಬರೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ತರುವಾಯ ಮೋಶೆಯು ಸೀನಾಯಿ ಬೆಟ್ಟದಿಂದ ಇಳಿದು ಬಂದನು. ಒಡಂಬಡಿಕೆಯ ವಾಕ್ಯಗಳು ಬರೆಯಲ್ಪಟ್ಟಿದ್ದ ಎರಡು ಕಲ್ಲಿನ ಹಲಿಗೆಗಳನ್ನು ಅವನು ಹಿಡಿದುಕೊಂಡಿದ್ದನು. ಯೆಹೋವನು ಅವನೊಡನೆ ಮಾತಾಡಿದ್ದರಿಂದ ಅವನ ಮುಖವು ಹೊಳೆಯುತ್ತಿತ್ತು. ಆದರೆ ಮೋಶೆಗೆ ಇದು ತಿಳಿದಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ಮೋಶೆಯ ಮುಖವು ಶುಭ್ರವಾಗಿ ಹೊಳೆಯುತ್ತಿರುವುದನ್ನು ಆರೋನನೂ ಇಸ್ರೇಲರೆಲ್ಲರೂ ನೋಡಿದರು. ಆದ್ದರಿಂದ ಅವನ ಬಳಿಗೆ ಹೋಗಲು ಅವರು ಭಯಪಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ಆದರೆ ಮೋಶೆ ಅವರನ್ನು ಕರೆದನು. ಆದ್ದರಿಂದ ಆರೋನನೂ ಜನನಾಯಕರೆಲ್ಲರೂ ಮೋಶೆಯ ಬಳಿಗೆ ಹೋದರು. ಮೋಶೆಯು ಅವರೊಡನೆ ಮಾತಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ಅದಾದನಂತರ, ಇಸ್ರೇಲರೆಲ್ಲರೂ ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದರು. ಯೆಹೋವನು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ತನಗೆ ಕೊಟ್ಟ ಆಜ್ಞೆಗಳನ್ನು ಮೋಶೆಯು ಅವರಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ಮೋಶೆಯು ಜನರೊಡನೆ ಮಾತಾಡಿ ಮುಗಿಸಿದಾಗ, ತನ್ನ ಮುಖದ ಮೇಲೆ ಮುಸುಕನ್ನು ಹಾಕಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ಮೋಶೆಯು ಯೆಹೋವನೊಡನೆ ಮಾತಾಡಲು ಆತನ ಸನ್ನಿಧಿಗೆ ಹೋದಾಗಲೆಲ್ಲಾ ಮೋಶೆಯು ಮುಸುಕನ್ನು ತೆಗೆದಿಡುತ್ತಿದ್ದನು. ಬಳಿಕ ಮೋಶೆ ಹೊರಗೆ ಬಂದು ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ಸಂಗತಿಗಳನ್ನು ಇಸ್ರೇಲರಿಗೆ ತಿಳಿಸುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ಮೋಶೆಯ ಮುಖವು ಶುಭ್ರವಾಗಿ ಹೊಳೆಯುತ್ತಿದ್ದುದನ್ನು ಜನರು ನೋಡಿದರು. ಆದ್ದರಿಂದ ಮೋಶೆಯು ಮುಂದಿನ ಸಾರಿ ಯೆಹೋವನೊಡನೆ ಮಾತಾಡಲು ಹೋಗುವವರೆಗೆ ತನ್ನ ಮುಖಕ್ಕೆ ಮುಸುಕು ಹಾಕಿಕೊಂಡಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ಮೋಶೆಯು ಇಸ್ರೇಲರನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿದನು. ಮೋಶೆ ಅವರಿಗೆ, “ನೀವು ಅನುಸರಿಸಬೇಕೆಂದು ಯೆಹೋವನು ನಿಮಗೆ ಆಜ್ಞಾಪಿಸಿದ ಸಂಗತಿಗಳನ್ನು ನಾನು ಹೇಳುವೆನು: ");
INSERT INTO kan2010_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“ಕೆಲಸ ಮಾಡುವುದಕ್ಕೆ ಆರು ದಿನಗಳಿವೆ. ಆದರೆ ಏಳನೆಯ ದಿನವು ನಿಮಗೆ ಬಹು ವಿಶೇಷವಾದ ವಿಶ್ರಾಂತಿ ದಿನವಾಗಿರುವುದು. ಆ ವಿಶೇಷ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸುವುದರ ಮೂಲಕ ನೀವು ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸುವಿರಿ. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಕೆಲಸಮಾಡುವ ವ್ಯಕ್ತಿಯು ಸಂಹರಿಸಲ್ಪಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ನೀವು ವಾಸಿಸುವ ಯಾವ ಸ್ಥಳದಲ್ಲಿಯೂ ಸಬ್ಬತ್‌ದಿನದಂದು ಬೆಂಕಿಯನ್ನು ಹೊತ್ತಿಸಬಾರದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ಮೋಶೆಯು ಇಸ್ರೇಲರಿಗೆ, “ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದು ಇದುವೇ. ");
INSERT INTO kan2010_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ಯೆಹೋವನಿಗಾಗಿ ಕಾಣಿಕೆಗಳನ್ನು ಕೂಡಿಸಿರಿ. ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ತಾನು ಕೊಡುವಂಥದ್ದನ್ನು ತನ್ನ ಹೃದಯದಲ್ಲಿ ತೀರ್ಮಾನಿಸಿಕೊಳ್ಳಬೇಕು. ಬಳಿಕ ಆ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತರಬೇಕು. ಚಿನ್ನ, ಬೆಳ್ಳಿ, ತಾಮ್ರ, ");
INSERT INTO kan2010_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರ ಮತ್ತು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆ, ಆಡಿನ ಕೂದಲು, ");
INSERT INTO kan2010_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ಕೆಂಪುಬಣ್ಣದ ಕುರಿದೊಗಲು, ಕಡಲುಹಂದಿಯ ತೊಗಲು, ಜಾಲೀಮರ, ");
INSERT INTO kan2010_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ದೀಪಗಳಿಗೆ ಬೇಕಾದ ಎಣ್ಣೆ, ಅಭಿಷೇಕತೈಲ ಮತ್ತು ಪರಿಮಳಧೂಪವನ್ನು ತಯಾರಿಸಲು ಬೇಕಾದ ಸುಗಂಧದ್ರವ್ಯ ಇವುಗಳನ್ನು ತನ್ನಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ಏಫೋದಿನಲ್ಲಿ ಮತ್ತು ದೈವನಿರ್ಣಯದ ಪದಕದಲ್ಲಿ ಹಾಕಬೇಕಾಗಿರುವ ಗೋಮೇಧಿಕ ರತ್ನಗಳು ಮತ್ತು ಇತರ ರತ್ನಗಳನ್ನು ತನ್ನಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ವಸ್ತುಗಳನ್ನು ನಿಮ್ಮಲ್ಲಿ ನಿಪುಣರಾದ ಕೆಲಸಗಾರರೆಲ್ಲರೂ ಮಾಡಬೇಕು. ಅವು ಯಾವುವೆಂದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ಪವಿತ್ರಗುಡಾರ, ಅದರ ಹೊರಗಿನ ಡೇರೆ, ಅದರ ಮೇಲ್ಹೊದಿಕೆಗಳು, ಅದರ ಕೊಂಡಿಗಳು, ಚೌಕಟ್ಟುಗಳು, ಅಗುಳಿಗಳು, ಕಂಬಗಳು, ಗದ್ದಿಗೇಕಲ್ಲುಗಳು, ");
INSERT INTO kan2010_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ಪವಿತ್ರಪೆಟ್ಟಿಗೆ ಮತ್ತು ಅದನ್ನು ಹೊರುವ ಕೋಲುಗಳು, ಕೃಪಾಸನ ಮತ್ತು ಪೆಟ್ಟಿಗೆ ಇರುವ ಸ್ಥಳವನ್ನು ಮುಚ್ಚುವ ಪರದೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ಮೇಜು ಮತ್ತು ಅದರ ಕೋಲುಗಳು, ಮೇಜಿನ ಮೇಲಿರುವ ಎಲ್ಲಾ ಉಪಕರಣಗಳು, ಮೇಜಿನ ಮೇಲಿರುವ ನೈವೇದ್ಯರೊಟ್ಟಿ, ");
INSERT INTO kan2010_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ದೀಪಸ್ತಂಭ ಮತ್ತು ಅದರ ಉಪಕರಣಗಳು, ದೀಪಗಳು, ದೀಪಕ್ಕೆ ಬೇಕಾದ ಎಣ್ಣೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ಧೂಪವೇದಿ ಮತ್ತು ಅದರ ಕೋಲುಗಳು, ಅಭಿಷೇಕತೈಲ, ಪರಿಮಳಧೂಪ, ಪವಿತ್ರ ಗುಡಾರದ ಬಾಗಿಲಿನ ಪರದೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ಸರ್ವಾಂಗಹೋಮ ಮಾಡಲು ಯಜ್ಞವೇದಿಕೆ ಮತ್ತು ಅದರ ತಾಮ್ರದ ಜಾಳಿಗೆ, ಕೋಲುಗಳು, ಯಜ್ಞವೇದಿಕೆಗೆ ಬೇಕಾಗುವ ಎಲ್ಲಾ ಉಪಕರಣಗಳು, ಗಂಗಾಳ ಮತ್ತು ಅದರ ಪೀಠ, ");
INSERT INTO kan2010_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ಅಂಗಳದ ಸುತ್ತಲಿನ ಪರದೆಗಳು, ಕಂಬಗಳು, ಗದ್ದಿಗೇಕಲ್ಲುಗಳು, ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ಗುಡಾರದ ಗೂಟಗಳು, ಅಂಗಳದ ಗೂಟಗಳು ಮತ್ತು ಹಗ್ಗಗಳು, ");
INSERT INTO kan2010_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ಮತ್ತು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಯಾಜಕರು ಧರಿಸತಕ್ಕ ವಿಶೇಷವಾದ ಹೆಣೆದ ಬಟ್ಟೆಗಳು. ಈ ಬಟ್ಟೆಗಳನ್ನು ಯಾಜಕನಾದ ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ಯಾಜಕ ಸೇವೆ ಮಾಡುವಾಗ ಧರಿಸಿಕೊಳ್ಳುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ಬಳಿಕ ಇಸ್ರೇಲರೆಲ್ಲರೂ ಮೋಶೆಯ ಬಳಿಯಿಂದ ಹೊರಟುಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ಕಾಣಿಕೆ ಕೊಡುವುದಕ್ಕೆ ಯಾರ್ಯಾರು ಬಯಸಿದರೋ ಅವರೆಲ್ಲರೂ ಬಂದು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸಿದರು. ಈ ಕಾಣಿಕೆಗಳು ದೇವದರ್ಶನಗುಡಾರ, ಅದರ ಎಲ್ಲಾ ವಸ್ತುಗಳು ಮತ್ತು ವಿಶೇಷ ಬಟ್ಟೆಗಳನ್ನು ಮಾಡಲು ಉಪಯೋಗಿಸಲ್ಪಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ಕಾಣಿಕೆ ಕೊಡುವುದಕ್ಕೆ ಬಯಸಿದ ಎಲ್ಲಾ ಗಂಡಸರು, ಹೆಂಗಸರು ಎಲ್ಲಾ ವಿಧದ ಚಿನ್ನದ ಆಭರಣಗಳನ್ನು ತಂದರು. ಅವರು ತಮ್ಮ ಕಡಗ, ಮೂಗುತಿ, ಉಂಗುರ, ಕಂಠಮಾಲೆ ಮತ್ತು ಇತರ ಚಿನ್ನದ ಆಭರಣಗಳನ್ನು ತಂದರು. ಅವರೆಲ್ಲರು ತಮ್ಮ ಎಲ್ಲಾ ಕೊಡುಗೆಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಟ್ಟರು. ಇದು ಯೆಹೋವನಿಗೆ ಕೊಟ್ಟ ವಿಶೇಷವಾದ ಕಾಣಿಕೆಯಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನಲ್ಲಿದ್ದ ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯನ್ನು, ನೀಲಿ, ನೇರಳೆ ಮತ್ತು ಕೆಂಪುದಾರಗಳನ್ನು ಯೆಹೋವನಿಗಾಗಿ ತಂದನು. ಯಾರಲ್ಲಿ ಕೆಂಪುಬಣ್ಣದ ಕುರಿದೊಗಲಾಗಲಿ ಕಡಲುಹಂದಿಯ ತೊಗಲಾಗಲಿ ಇದ್ದವೋ ಅವರು ಅವುಗಳನ್ನು ಯೆಹೋವನಿಗಾಗಿ ತಂದುಕೊಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ಬೆಳ್ಳಿಯನ್ನಾಗಲಿ ತಾಮ್ರವನ್ನಾಗಲಿ ಕೊಡಲು ಬಯಸಿದವರು ಅದನ್ನು ಕೆಲಸಕ್ಕೋಸ್ಕರ ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ತಂದರು. ಜಾಲೀಮರವನ್ನು ಹೊಂದಿದವರು ಅದನ್ನು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಕೊಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ನಿಪುಣರಾದ ಸ್ತ್ರೀಯರು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯನ್ನು, ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ನಿಪುಣರಾಗಿದ್ದ ಇತರ ಸ್ತ್ರೀಯರು ಆಡುಕೂದಲಿನಿಂದ ಬಟ್ಟೆಯನ್ನು ತಯಾರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ನಾಯಕರು ಗೋಮೇಧಿಕ ರತ್ನಗಳನ್ನು ಮತ್ತು ಇತರ ರತ್ನಗಳನ್ನು ತಂದುಕೊಟ್ಟರು. ಅವುಗಳನ್ನು ಯಾಜಕನ ಏಫೋದಿಗೂ ಮತ್ತು ದೈವನಿರ್ಣಯದ ಪದಕಕ್ಕೂ ಉಪಯೋಗಿಸಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ಜನರು ಸುಗಂಧದ್ರವ್ಯಗಳನ್ನೂ ಆಲಿವ್ ಎಣ್ಣೆಯನ್ನೂ ತಂದುಕೊಟ್ಟರು. ಈ ವಸ್ತುಗಳು ಪರಿಮಳಧೂಪ, ಅಭಿಷೇಕತೈಲ ಮತ್ತು ದೀಪಗಳಿಗೆ ಬೇಕಾದ ಎಣ್ಣೆ ಇವುಗಳನ್ನು ಮಾಡಲು ಉಪಯೋಗಿಸಲ್ಪಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ಸಹಾಯ ಮಾಡುವುದಕ್ಕೆ ಬಯಸಿದ ಇಸ್ರೇಲರೆಲ್ಲರೂ ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಗಳನ್ನು ತಂದುಕೊಟ್ಟರು. ಈ ಕಾಣಿಕೆಗಳನ್ನು ಗಂಡಸರು ಮತ್ತು ಹೆಂಗಸರು ಕೊಡುವುದಕ್ಕೆ ಬಯಸಿದ್ದರಿಂದ ಉದಾರವಾಗಿ ಕೊಟ್ಟರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಮತ್ತು ಜನರಿಗೆ ಆಜ್ಞಾಪಿಸಿದ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ಈ ಕಾಣಿಕೆಗಳು ಉಪಯೋಗಿಸಲ್ಪಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ಬಳಿಕ ಮೋಶೆಯು ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆಂದನು: “ನೋಡಿರಿ, ಯೆಹೋವನು ಯೆಹೂದ ಕುಲದಿಂದ ಊರಿಯ ಮಗನಾದ ಬೆಚಲೇಲನನ್ನು ಆರಿಸಿಕೊಂಡಿದ್ದಾನೆ. ಊರಿಯು ಹೂರನ ಮಗ. ");
INSERT INTO kan2010_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ಯೆಹೋವನು ಬೆಚಲೇಲನನ್ನು ದೇವರಾತ್ಮಭರಿತನನ್ನಾಗಿ ಮಾಡಿ, ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ಬೇಕಾದ ವಿಶೇಷ ನಿಪುಣತೆಯನ್ನೂ ಜ್ಞಾನವನ್ನೂ ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ಅವನು ಅಂದವಾಗಿ ನಕ್ಷೆಮಾಡಿ, ಚಿನ್ನ, ಬೆಳ್ಳಿ ಮತ್ತು ತಾಮ್ರಗಳಿಂದ ವಸ್ತುಗಳನ್ನು ಮಾಡಬಲ್ಲನು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ಅವನು ಕಲ್ಲುಗಳನ್ನು, ರತ್ನಗಳನ್ನು ಕತ್ತರಿಸಿ ಜೋಡಿಸಬಲ್ಲನು. ಬೆಚಲೇಲನು ಮರಗೆಲಸವನ್ನು ಮಾಡಿ ಎಲ್ಲಾ ವಿಧದ ಕುಶಲ ವಸ್ತುಗಳನ್ನು ತಯಾರಿಸಬಲ್ಲನು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ಇತರರಿಗೆ ಕಲಿಸುವುದಕ್ಕೆ ಬೇಕಾದ ವಿಶೇಷ ನಿಪುಣತೆಯನ್ನು ಯೆಹೋವನು ಬೆಚಲೇಲನಿಗೂ ಒಹೊಲೀಯಾಬನಿಗೂ ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ. ಒಹೊಲೀಯಾಬನು ದಾನ್ ಕುಲದ ಅಹೀಸಾಮಾಕನ ಮಗನು. ");
INSERT INTO kan2010_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ಯೆಹೋವನು ಇವರಿಬ್ಬರಿಗೆ ಎಲ್ಲಾ ವಿಧದ ಕೆಲಸಗಳನ್ನು ಮಾಡಲು ವಿಶೇಷ ನಿಪುಣತೆಯನ್ನು ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ. ಅವರು ಮರಗೆಲಸವನ್ನೂ ಲೋಹದ ಕೆಲಸವನ್ನೂ ಮಾಡಬಲ್ಲರು. ಅವರು ನೀಲಿ, ನೇರಳೆ ಕೆಂಪುದಾರಗಳಿಂದ ಮತ್ತು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯಿಂದ ಅಲಂಕೃತವಾದ ಬಟ್ಟೆಗಳನ್ನು ನೇಯಿಗೆ ಮಾಡಬಲ್ಲರು; ಅವರು ಉಣ್ಣೆ ಬಟ್ಟೆಗಳನ್ನು ನೇಯಲು ಶಕ್ತರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“ಆದ್ದರಿಂದ ಬೆಚಲೇಲನೂ ಒಹೊಲೀಯಾಬನೂ ಮತ್ತು ಇತರ ಎಲ್ಲಾ ನಿಪುಣರೂ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ಕೆಲಸವನ್ನು ಮಾಡಬೇಕು. ಈ ಪವಿತ್ರಸ್ಥಳವನ್ನು ಕಟ್ಟುವುದಕ್ಕಾಗಿ ಅವಶ್ಯವಿರುವ ಎಲ್ಲಾ ಸೂಕ್ಷ್ಮವಾದ ಕೆಲಸವನ್ನು ಮಾಡುವುದಕ್ಕೆ ಯೆಹೋವನು ಈ ಜನರಿಗೆ ಜ್ಞಾನವನ್ನೂ ತಿಳುವಳಿಕೆಯನ್ನೂ ಅನುಗ್ರಹಿಸಿದ್ದಾನೆ.” ");
INSERT INTO kan2010_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ಬಳಿಕ ಮೋಶೆಯು ಬೆಚಲೇಲನನ್ನೂ ಒಹೊಲೀಯಾಬನನ್ನೂ ಮತ್ತು ಯೆಹೋವನಿಂದ ವಿಶೇಷ ಜ್ಞಾನ ಹೊಂದಿದ ಇತರ ಎಲ್ಲಾ ನಿಪುಣರನ್ನೂ ಕರೆದನು. ಕೆಲಸದಲ್ಲಿ ಸಹಾಯಮಾಡಲು ಇವರು ಬಯಸಿದ್ದರಿಂದ ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ಇಸ್ರೇಲರು ಕಾಣಿಕೆಗಳಾಗಿ ತಂದ ವಸ್ತುಗಳನ್ನೆಲ್ಲಾ ಮೋಶೆಯು ಅವರಿಗೆ ಕೊಟ್ಟನು. ಅವರು ದೇವರ ಪವಿತ್ರಸ್ಥಳವನ್ನು ಕಟ್ಟುವುದಕ್ಕಾಗಿ ಈ ವಸ್ತುಗಳನ್ನು ಉಪಯೋಗಿಸಿದರು. ಪ್ರತಿ ಮುಂಜಾನೆ ಜನರು ಕಾಣಿಕೆಗಳನ್ನು ತರುತ್ತಲೇ ಇದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ಆಗ ಆ ನಿಪುಣರೆಲ್ಲಾ ತಾವು ಮಾಡುತ್ತಿದ್ದ ಪವಿತ್ರಸ್ಥಳದ ಕೆಲಸವನ್ನು ಬಿಟ್ಟು ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಲು ಹೋದರು. ಅವರು, ");
INSERT INTO kan2010_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“ಜನರು ಬಹಳ ಹೆಚ್ಚಾಗಿ ತಂದಿದ್ದಾರೆ! ಗುಡಾರದ ಕೆಲಸವನ್ನು ಮುಗಿಸುವುದಕ್ಕೆ ನಮಗೆ ಬೇಕಾಗಿರುವುದಕ್ಕಿಂತ ಹೆಚ್ಚಾಗಿ ನಮ್ಮಲ್ಲಿ ಇವೆ!” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ಆಗ ಮೋಶೆಯು, “ಪವಿತ್ರಸ್ಥಳದ ಕೆಲಸಕ್ಕಾಗಿ ಯಾವ ಪುರುಷನಾಗಲಿ ಸ್ತ್ರೀಯಾಗಲಿ ಇನ್ನು ಮುಂದೆ ಯಾವುದನ್ನೂ ಕಾಣಿಕೆಯಾಗಿ ಸಿದ್ಧಮಾಡಬಾರದು” ಎಂಬ ಸಂದೇಶವನ್ನು ಪಾಳೆಯದಲ್ಲೆಲ್ಲಾ ಕಳುಹಿಸಿದನು. ಆದ್ದರಿಂದ ಜನರು ಹೆಚ್ಚಾಗಿ ಕೊಡುವುದನ್ನು ನಿಲ್ಲಿಸಬೇಕಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ದೇವರ ಪವಿತ್ರಸ್ಥಳವನ್ನು ಕಟ್ಟುವ ಕೆಲಸವನ್ನು ಮುಗಿಸುವುದಕ್ಕೆ ಬೇಕಾಗಿರುವುದಕ್ಕಿಂತಲೂ ಹೆಚ್ಚಾಗಿ ಜನರು ತಂದಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ತರುವಾಯ ನಿಪುಣರು ಪವಿತ್ರಗುಡಾರವನ್ನು ಮಾಡಲು ಪ್ರಾರಂಭಿಸಿದರು. ಅವರು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯಿಂದಲೂ ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪು ದಾರಗಳಿಂದಲೂ ಹತ್ತು ಪರದೆಗಳನ್ನು ಮಾಡಿದರು. ಅವರು ಕೆರೂಬಿಗಳ ಚಿತ್ರಗಳನ್ನು ಪರದೆಗಳಲ್ಲಿ ಕಸೂತಿ ಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ಪ್ರತಿ ಪರದೆಯೂ ಒಂದೇ ಅಳತೆಯುಳ್ಳದ್ದಾಗಿ ಇಪ್ಪತ್ತೆಂಟು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ನಾಲ್ಕು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ಕೆಲಸಗಾರರು ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಜೋಡಿಸಿ ಪರದೆಗಳ ಎರಡು ಭಾಗಗಳನ್ನಾಗಿ ಮಾಡಿದರು. ಒಂದು ಭಾಗದಲ್ಲಿ ಐದು ಪರದೆಗಳನ್ನೂ ಇನ್ನೊಂದು ಭಾಗದಲ್ಲಿ ಐದು ಪರದೆಗಳನ್ನೂ ಒಟ್ಟಾಗಿ ಜೋಡಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ಬಳಿಕ ಅವರು ಒಂದು ಗುಂಪಿನ ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ಕುಣಿಕೆಗಳನ್ನು ಮಾಡಲು ನೀಲಿಬಟ್ಟೆಯನ್ನು ಉಪಯೋಗಿಸಿದರು. ಇನ್ನೊಂದು ಗುಂಪಿನಲ್ಲಿದ್ದ ಕೊನೆಯ ಪರದೆಯಲ್ಲೂ ಹಾಗೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ಒಂದು ಗುಂಪಿನ ಕೊನೆಯ ಪರದೆಯಲ್ಲೂ ಐವತ್ತು ಕುಣಿಕೆಗಳಿದ್ದವು. ಇನ್ನೊಂದು ಗುಂಪಿನ ಕೊನೆಯ ಪರದೆಯಲ್ಲೂ ಐವತ್ತು ಕುಣಿಕೆಗಳಿದ್ದವು. ಕುಣಿಕೆಗಳನ್ನು ಒಂದಕ್ಕೊಂದು ಎದುರಾಗಿ ಇರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ಬಳಿಕ ಅವರು ಐವತ್ತು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿ ಎರಡು ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿದರು. ಹೀಗೆ ಪವಿತ್ರಗುಡಾರವು ಜೋಡಿಸಲ್ಪಟ್ಟು ಒಂದೇ ಗುಡಾರವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ಬಳಿಕ ಕೆಲಸಗಾರರು ಪವಿತ್ರಗುಡಾರವನ್ನು ಹೊದಿಸುವುದಕ್ಕೆ ಇನ್ನೊಂದು ಗುಡಾರವನ್ನು ಮಾಡಿದರು. ಈ ಗುಡಾರವನ್ನು ಮಾಡಲು ಹನ್ನೊಂದು ಪರದೆಗಳನ್ನು ಉಪಯೋಗಿಸಿದರು. ಅವರು ಆಡುಕೂದಲಿನಿಂದ ಈ ಪರದೆಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ಈ ಎಲ್ಲಾ ಪರದೆಗಳು ಒಂದೇ ಅಳತೆಯುಳ್ಳದ್ದಾಗಿ ಮೂವತ್ತು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ನಾಲ್ಕು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ಕೆಲಸಗಾರರು ಐದು ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿ ಒಂದು ಭಾಗವನ್ನಾಗಿ ಮಾಡಿದರು. ಬಳಿಕ ಅವರು ಇತರ ಆರು ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿ ಇನ್ನೊಂದು ಭಾಗವನ್ನಾಗಿ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ಅವರು ಒಂದು ಭಾಗದ ಕೊನೆಯ ಪರದೆಯ ಅಂಚಿನಲ್ಲಿ ಐವತ್ತು ಕುಣಿಕೆಗಳನ್ನು ಇಟ್ಟರು. ಇನ್ನೊಂದು ಭಾಗದ ಕೊನೆಯ ಪರದೆಯಲ್ಲಿಯೂ ಅದೇ ರೀತಿಯಾಗಿ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ಕೆಲಸಗಾರರು ಎರಡು ಪರದೆಗಳನ್ನು ಒಟ್ಟಾಗಿ ಜೋಡಿಸಲು ಐವತ್ತು ತಾಮ್ರದ ಬಳೆಗಳನ್ನು ಮಾಡಿದರು. ಇದು ಸಮಸ್ತವನ್ನು ಒಂದೇ ಗುಡಾರವಾಗುವಂತೆ ಮಾಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ಬಳಿಕ ಅವರು ಪವಿತ್ರಗುಡಾರಕ್ಕೆ ಎರಡು ಮೇಲ್ಹೊದಿಕೆಗಳನ್ನು ಮಾಡಿದರು. ಒಂದು ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಕೆಂಪು ಬಣ್ಣದ ಕುರಿದೊಗಲುಗಳಿಂದ ಮಾಡಿದರು; ಮತ್ತೊಂದು ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಕಡಲುಹಂದಿಯ ತೊಗಲುಗಳಿಂದ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ಬಳಿಕ ಕೆಲಸಗಾರರು ಪವಿತ್ರಗುಡಾರದ ಚೌಕಟ್ಟುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ಪ್ರತಿಯೊಂದು ಚೌಕಟ್ಟು ಹತ್ತು ಮೊಳ ಉದ್ದವಾಗಿಯೂ ಒಂದು ಮೊಳ ಅಗಲವಾಗಿಯೂ ಇತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ಎರಡು ಕಂಬಗಳಿಗೆ ಎರಡು ಅಡ್ಡಕಂಬಗಳನ್ನು ಜೋಡಿಸಿ ಚೌಕಟ್ಟನ್ನು ಮಾಡಲಾಗಿತ್ತು. ಪವಿತ್ರಗುಡಾರದ ಪ್ರತಿ ಚೌಕಟ್ಟನ್ನು ಅದೇ ರೀತಿಯಲ್ಲಿ ಮಾಡಲಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ಪವಿತ್ರಗುಡಾರದ ದಕ್ಷಿಣ ಭಾಗದಲ್ಲಿ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ಬಳಿಕ ಅವರು ಚೌಕಟ್ಟುಗಳಿಗೆ ನಲವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಿದರು. ಒಂದು ನಿಲುವುಪೆಟ್ಟಿಗೆಗೆ ಒಂದರಂತೆ ಪ್ರತಿ ಚೌಕಟ್ಟಿಗೆ ಎರಡು ಗದ್ದಿಗೇಕಲ್ಲುಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ಅವರು ಪವಿತ್ರಗುಡಾರದ ಇನ್ನೊಂದು ಕಡೆಯ ಉತ್ತರ ಭಾಗದಲ್ಲಿ ಇಪ್ಪತ್ತು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ಅವರು ಪ್ರತಿ ಚೌಕಟ್ಟಿಗೆ ಎರಡು ಗದ್ದಿಗೇಕಲ್ಲುಗಳಂತೆ ನಲವತ್ತು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ಅವರು ಪವಿತ್ರಗುಡಾರದ ಹಿಂಭಾಗಕ್ಕೆ ಅಂದರೆ ಪಶ್ಚಿಮ ಭಾಗಕ್ಕೆ ಇನ್ನೂ ಆರು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ಪವಿತ್ರಗುಡಾರದ ಹಿಂಭಾಗದಲ್ಲಿನ ಮೂಲೆಗಳಿಗೂ ಎರಡು ಚೌಕಟ್ಟುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ಈ ಚೌಕಟ್ಟುಗಳು ಕೆಳಭಾಗಕ್ಕೆ ಒಟ್ಟಾಗಿ ಸೇರಿಸಲ್ಪಟ್ಟಿದ್ದವು; ತುದಿಯಲ್ಲಿ ಒಂದು ಬಳೆಯು ಮೂಲೆ ಚೌಕಟ್ಟುಗಳನ್ನು ಒಟ್ಟಿಗೆ ಹಿಡಿದುಕೊಂಡಿತ್ತು. ಅವರು ಎರಡೂ ಮೂಲೆಗಳಿಗೆ ಹಾಗೆಯೇ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ಪವಿತ್ರಗುಡಾರದ ಪಶ್ಚಿಮ ದಿಕ್ಕಿನಲ್ಲಿ ಒಟ್ಟು ಎಂಟು ಚೌಕಟ್ಟುಗಳಿದ್ದವು. ಪ್ರತಿ ಚೌಕಟ್ಟಿಗೆ ಎರಡು ಗದ್ದಿಗೇಕಲ್ಲುಗಳಂತೆ ಹದಿನಾರು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇಕಲ್ಲುಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ಬಳಿಕ ಕೆಲಸಗಾರರು ಚೌಕಟ್ಟುಗಳಿಗೆ ಅಗುಳಿಗಳನ್ನು ಮಾಡಲು ಜಾಲೀಮರವನ್ನು ಉಪಯೋಗಿಸಿದರು. ಪವಿತ್ರಗುಡಾರದ ಮೊದಲಿನ ಕಡೆಯಲ್ಲಿ ಐದು ಅಗುಳಿಗಳೂ ");
INSERT INTO kan2010_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ಇನ್ನೊಂದು ಕಡೆಯಲ್ಲಿ ಐದು ಅಗುಳಿಗಳೂ ಪವಿತ್ರಗುಡಾರದ ಹಿಂಭಾಗದಲ್ಲಿ ಅಂದರೆ ಪಶ್ಚಿಮ ಭಾಗದಲ್ಲಿ ಐದು ಅಗುಳಿಗಳೂ ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ಚೌಕಟ್ಟುಗಳನ್ನು ಒಂದು ಕೊನೆಯಿಂದ ಇನ್ನೊಂದು ಕೊನೆಯವರೆಗೂ ಹಾದುಹೋಗುವಂತೆ ಅವರು ಮಧ್ಯದ ಅಗುಳಿಯನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ಅವರು ಈ ಚೌಕಟ್ಟುಗಳನ್ನು ಚಿನ್ನದಿಂದ ಹೊದಿಸಿದರು. ಅಗುಳಿಗಳಿಗಾಗಿ ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿದರು; ಅಗುಳಿಗಳನ್ನು ಚಿನ್ನದಿಂದ ಹೊದಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ಮಹಾಪವಿತ್ರಸ್ಥಳದ ದ್ವಾರಕ್ಕೆ ವಿಶೇಷ ಪರದೆಯನ್ನು ಮಾಡಲು ಅವರು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯನ್ನು, ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳನ್ನು ಉಪಯೋಗಿಸಿದರು. ಅವರು ಕೆರೂಬಿಗಳ ಚಿತ್ರಗಳನ್ನು ಪರದೆಯಲ್ಲಿ ಕಸೂತಿ ಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ಅವರು ಜಾಲೀಮರದಿಂದ ನಾಲ್ಕು ಕಂಬಗಳನ್ನು ಮಾಡಿದರು ಮತ್ತು ಕಂಬಗಳನ್ನು ಚಿನ್ನದಿಂದ ಹೊದಿಸಿದರು. ಬಳಿಕ ಅವರು ಕಂಬಗಳಿಗೆ ಚಿನ್ನದ ಕೊಂಡಿಗಳನ್ನು ಮಾಡಿದರು. ಅವರು ಕಂಬಗಳಿಗೆ ನಾಲ್ಕು ಬೆಳ್ಳಿಯ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ಬಳಿಕ ಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಪರದೆಯನ್ನು ಮಾಡಿದರು. ಅವರು ಈ ಪರದೆಯನ್ನು ಮಾಡಲು ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರವನ್ನು, ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯನ್ನು ಉಪಯೋಗಿಸಿದರು ಮತ್ತು ಅವರು ಚಿತ್ರಗಳನ್ನು ಅದರಲ್ಲಿ ಹೆಣೆದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ಬಳಿಕ ಅವರು ಐದು ಕಂಬಗಳನ್ನೂ ಬಾಗಿಲಿನ ಪರದೆಗೆ ಕೊಂಡಿಗಳನ್ನೂ ಮಾಡಿದರು. ಅವರು ಕಂಬಗಳ ತುದಿಯನ್ನು ಮತ್ತು ಪರದೆಯ ಕೋಲುಗಳನ್ನು ಚಿನ್ನದಿಂದ ಹೊದಿಸಿದರು. ಅವರು ಕಂಬಗಳಿಗೆ ಐದು ತಾಮ್ರದ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ಬೆಚಲೇಲನು ಜಾಲೀಮರದಿಂದ ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಯನ್ನು ಮಾಡಿದನು. ಪೆಟ್ಟಿಗೆಯು ಎರಡೂವರೆ ಮೊಳ ಉದ್ದ ಒಂದೂವರೆ ಮೊಳ ಅಗಲ ಮತ್ತು ಒಂದೂವರೆ ಮೊಳ ಎತ್ತರವಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ಪೆಟ್ಟಿಗೆಯ ಹೊರಗಿನ ಮತ್ತು ಒಳಗಿನ ಭಾಗವನ್ನು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಹೊದಿಸಿದನು. ಬಳಿಕ ಪೆಟ್ಟಿಗೆಯ ಸುತ್ತಲೂ ಚಿನ್ನದ ಗೋಟು ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ಅವನು ಚಿನ್ನದ ನಾಲ್ಕು ಬಳೆಗಳನ್ನು ಮಾಡಿಸಿ ಪೆಟ್ಟಿಗೆಯ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಇರಿಸಿದನು. ಈ ಬಳೆಗಳು ಪೆಟ್ಟಿಗೆಯನ್ನು ಹೊತ್ತುಕೊಂಡು ಹೋಗಲು ಉಪಯೋಗಿಸಲ್ಪಡುತ್ತಿದ್ದವು. ಪ್ರತಿಯೊಂದು ಬದಿಯಲ್ಲೂ ಎರಡು ಬಳೆಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ಬಳಿಕ ಪೆಟ್ಟಿಗೆಯನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಕೋಲುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿಸಿದನು. ಅದನ್ನು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಹೊದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ಪೆಟ್ಟಿಗೆಯ ಪಾರ್ಶ್ವಗಳಲ್ಲಿರುವ ಬಳೆಗಳಲ್ಲಿ ಅವನು ಕೋಲುಗಳನ್ನು ಸೇರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ಬಳಿಕ ಅವನು ಅಪ್ಪಟ ಬಂಗಾರದ ಕೃಪಾಸನವನ್ನು ಮಾಡಿಸಿದನು. ಅದು ಎರಡೂವರೆ ಮೊಳ ಉದ್ದ ಮತ್ತು ಒಂದೂವರೆ ಮೊಳ ಅಗಲ ಇತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ಬಳಿಕ ಬೆಚಲೇಲನು ಬಂಗಾರವನ್ನು ಸುತ್ತಿಗೆಯಿಂದ ಕೆತ್ತಿ ಎರಡು ಕೆರೂಬಿಗಳ ಆಕಾರಗಳನ್ನು ಮಾಡಿದನು. ಅವನು ಕೆರೂಬಿದೂತರನ್ನು ಕೃಪಾಸನದ ಕೊನೆಗಳಲ್ಲಿ ಇಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ಒಂದು ಕೆರೂಬಿಯನ್ನು ಕೃಪಾಸನದ ಒಂದು ಕೊನೆಯಲ್ಲೂ ಇನ್ನೊಂದನ್ನು ಮತ್ತೊಂದು ಕೊನೆಯಲ್ಲೂ ಇಟ್ಟನು. ಅವುಗಳನ್ನು ಒಟ್ಟಾಗಿ ಕೃಪಾಸನಕ್ಕೆ ಜೋಡಿಸಿ ಒಂದೇ ವಸ್ತುವನ್ನಾಗಿ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ಕೆರೂಬಿಗಳ ರೆಕ್ಕೆಗಳು ಆಕಾಶದ ಕಡೆಗೆ ಚಾಚಿದ್ದವು. ಅವುಗಳು ಕೃಪಾಸನವನ್ನು ತಮ್ಮ ರೆಕ್ಕೆಗಳಿಂದ ಮುಚ್ಚಿದ್ದವು. ಅವುಗಳ ಮುಖಗಳು ಎದುರುಬದುರಾಗಿ ಕೃಪಾಸನವನ್ನು ನೋಡುತ್ತಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ತರುವಾಯ, ಅವನು ಜಾಲೀಮರದಿಂದ ಮೇಜನ್ನು ಮಾಡಿದನು. ಮೇಜು ಎರಡು ಮೊಳ ಉದ್ದ, ಒಂದು ಮೊಳ ಅಗಲ ಮತ್ತು ಒಂದೂವರೆ ಮೊಳ ಎತ್ತರ ಇತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ಅವನು ಮೇಜನ್ನು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಹೊದಿಸಿದನು; ಮೇಜಿನ ಸುತ್ತಲೂ ಚಿನ್ನದ ಗೋಟನ್ನು ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ಬಳಿಕ ಅವನು ಮೇಜಿನ ಸುತ್ತಲೂ ಮೂರು ಇಂಚು ಅಗಲದ ಚೌಕಟ್ಟನ್ನು ಮಾಡಿದನು; ಆ ಚೌಕಟ್ಟಿಗೆ ಚಿನ್ನದ ಗೋಟನ್ನು ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ಬಳಿಕ ಅವನು ನಾಲ್ಕು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿಸಿ ಮೇಜಿನ ನಾಲ್ಕು ಕಾಲುಗಳಿರುವ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಅವುಗಳನ್ನು ಇರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ಅವನು ಬಳೆಗಳನ್ನು ಮೇಜಿನ ತುದಿಯಲ್ಲಿರುವ ಚೌಕಟ್ಟಿಗೆ ಹತ್ತಿರವಾಗಿ ಇರಿಸಿದನು. ಕೋಲುಗಳಿಂದ ಮೇಜನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಈ ಬಳೆಗಳು ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ಬಳಿಕ ಮೇಜನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಉಪಯೋಗಿಸಲ್ಪಡುತ್ತಿದ್ದ ಕೋಲುಗಳನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿದನು. ಕೋಲುಗಳನ್ನು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಹೊದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ಬಳಿಕ ಅವನು ಮೇಜಿನಲ್ಲಿ ಉಪಯೋಗಿಸಲ್ಪಡುತ್ತಿದ್ದ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ಮಾಡಿದನು. ಅವನು ಅಪ್ಪಟ ಬಂಗಾರದ ತಟ್ಟೆ, ಚಮಚ, ಬೋಗುಣಿ ಮತ್ತು ಹೂಜೆಗಳನ್ನು ಮಾಡಿದನು. ಬೋಗುಣಿ ಮತ್ತು ಹೂಜೆಗಳು ಪಾನದ್ರವ್ಯ ಸಮರ್ಪಣೆಗಳನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕೆ ಉಪಯುಕ್ತವಾಗಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ಬಳಿಕ ಅವನು ದೀಪಸ್ತಂಭವನ್ನು ಮಾಡಿದನು. ಅವನು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಕಂಬವನ್ನು ಮಾಡಿದನು. ತರುವಾಯ ಹೂವು, ಮೊಗ್ಗು ಮತ್ತು ದಳಗಳನ್ನು ಮಾಡಿ ಜೋಡಿಸಿದನು. ಹೀಗೆ ಅವು ಪುಷ್ಪಾಲಂಕಾರವಾದ ಒಂದೇ ವಸ್ತುವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ದೀಪಸ್ತಂಭಕ್ಕೆ ಆರು ಕೊಂಬೆಗಳಿದ್ದವು. ಮೂರು ಕೊಂಬೆಗಳು ಒಂದು ಕಡೆಯಲ್ಲೂ ಇನ್ನು ಮೂರು ಕೊಂಬೆಗಳು ಇನ್ನೊಂದು ಕಡೆಯಲ್ಲಿಯೂ ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ಪ್ರತಿಯೊಂದು ಕೊಂಬೆಗಳಲ್ಲಿ ಮೂರುಮೂರು ಹೂವುಗಳಿದ್ದವು. ಈ ಹೂವುಗಳು ಮೊಗ್ಗು, ದಳಗಳಿಂದ ಕೂಡಿದ ಬಾದಾಮಿಹೂವುಗಳಂತೆ ಮಾಡಲ್ಪಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ದೀಪಸ್ತಂಭದ ಕಂಬದಲ್ಲಿ ಇನ್ನೂ ನಾಲ್ಕು ಹೂವುಗಳಿದ್ದವು. ಅವುಗಳು ಸಹ ಮೊಗ್ಗು, ದಳಗಳಿಂದ ಕೂಡಿದ ಬಾದಾಮಿಯ ಹೂವುಗಳಂತೆ ಮಾಡಲ್ಪಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ಕಂಬದ ಪ್ರತಿಯೊಂದು ಕಡೆಯಲ್ಲಿ ಮೂರುಮೂರು ಕೊಂಬೆಗಳಂತೆ ಆರು ಕೊಂಬೆಗಳಿದ್ದವು. ಕೊಂಬೆಗಳು ಕವಲೊಡೆದಿರುವ ಮೂರು ಸ್ಥಳಗಳಲ್ಲೂ ಒಂದೊಂದು ಹೂವು ಇತ್ತು. ಆ ಹೂವಿಗೆ ಮೊಗ್ಗುಗಳು ಮತ್ತು ದಳಗಳು ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ಹೂವು ಮತ್ತು ಕೊಂಬೆಗಳಿಂದ ಕೂಡಿದ ಇಡೀ ದೀಪಸ್ತಂಭವು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಅಖಂಡವಾಗಿ ಮಾಡಲ್ಪಟ್ಟಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ಅವನು ಈ ದೀಪಸ್ತಂಭಕ್ಕೆ ಏಳು ಹಣತೆಗಳನ್ನು ಮಾಡಿದನು; ಬಳಿಕ ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಬತ್ತಿಗಳನ್ನು ಸರಿಪಡಿಸುವ ಕತ್ತರಿಗಳನ್ನೂ ಹರಿವಾಣಗಳನ್ನೂ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ದೀಪಸ್ತಂಭವನ್ನು ಮತ್ತು ಅದರ ಉಪಕರಣಗಳನ್ನು ಮಾಡಲು ಎಪ್ಪತ್ತೈದು ಪೌಂಡು ಅಪ್ಪಟ ಬಂಗಾರವನ್ನು ಉಪಯೋಗಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ಅವನು ಧೂಪವೇದಿಕೆಯನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿದನು. ಧೂಪವೇದಿಕೆಯು ಚೌಕವಾಗಿತ್ತು. ಅದು ಒಂದು ಮೊಳ ಉದ್ದ, ಒಂದು ಮೊಳ ಅಗಲ ಮತ್ತು ಎರಡು ಮೊಳ ಎತ್ತರ ಇತ್ತು. ಧೂಪವೇದಿಕೆಯಲ್ಲಿ ನಾಲ್ಕು ಕೊಂಬುಗಳಿದ್ದವು. ಪ್ರತಿ ಮೂಲೆಯಲ್ಲಿಯೂ ಒಂದೊಂದು ಕೊಂಬುಗಳಿದ್ದವು. ಈ ಕೊಂಬುಗಳು ಒಟ್ಟಾಗಿ ಧೂಪವೇದಿಕೆಗೆ ಜೋಡಿಸಲ್ಪಟ್ಟು ಅವಿಭಾಜ್ಯವಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ಅವನು ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಮೇಲ್ಭಾಗವನ್ನೂ ಎಲ್ಲಾ ಪಾರ್ಶ್ವಗಳನ್ನೂ ಕೊಂಬುಗಳನ್ನೂ ಹೊದಿಸಿದನು. ಬಳಿಕ ಅವನು ಧೂಪವೇದಿಕೆಯ ಸುತ್ತಲೂ ಚಿನ್ನದ ಗೋಟನ್ನು ಕಟ್ಟಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ಅವನು ಧೂಪವೇದಿಕೆಗೆ ಎರಡು ಚಿನ್ನದ ಬಳೆಗಳನ್ನು ಮಾಡಿಸಿ ಗೋಟಿನ ಕೆಳಗೆ ವೇದಿಕೆಯ ಪ್ರತಿಯೊಂದು ಬದಿಯಲ್ಲಿ ಇರಿಸಿದನು. ಈ ಚಿನ್ನದ ಬಳೆಗಳು ವೇದಿಕೆಯನ್ನು ಕೋಲುಗಳ ಮೂಲಕ ಹೊರುವುದಕ್ಕೆ ಉಪಯುಕ್ತವಾಗಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ಅವನು ಜಾಲೀಮರದಿಂದ ಕೋಲುಗಳನ್ನು ಮಾಡಿಸಿ ಚಿನ್ನದಿಂದ ಅವುಗಳನ್ನು ಹೊದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ತರುವಾಯ ಅವನು ಪವಿತ್ರವಾದ ಅಭಿಷೇಕತೈಲವನ್ನು ಮಾಡಿದನು. ಅವನು ಶುದ್ಧವಾದ ಪರಿಮಳಧೂಪವನ್ನು ಮಾಡಿದನು. ಸುಗಂಧದ್ರವ್ಯಕಾರರ ವಿದ್ಯೆಯ ಮೇರೆಗೆ ಈ ವಸ್ತುಗಳನ್ನು ಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ತರುವಾಯ ಬೆಚಲೇಲನು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಜಾಲೀಮರದಿಂದ ಮಾಡಿದನು. ಈ ವೇದಿಕೆಯು ಸರ್ವಾಂಗಹೋಮಗಳನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕೆ ಕಟ್ಟಲ್ಪಟ್ಟಿತ್ತು. ವೇದಿಕೆಯು ಚೌಕವಾಗಿತ್ತು. ಅದು ಐದು ಮೊಳ ಉದ್ದ, ಐದು ಮೊಳ ಅಗಲ ಮತ್ತು ಮೂರು ಮೊಳ ಎತ್ತರ ಇತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ಅವನು ಯಜ್ಞವೇದಿಕೆಯ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಒಂದೊಂದು ಕೊಂಬುಗಳನ್ನು ಇಟ್ಟು ಪ್ರತಿಯೊಂದೂ ಕೊಂಬನ್ನು ಅದರ ಮೂಲೆಗೆ ಸೇರಿಸಿದನು. ಹೀಗಾಗಿ ಪ್ರತಿಯೊಂದೂ ಅಖಂಡವಾದ ಒಂದೇ ವಸ್ತುವಿನಂತಾಯಿತು. ಅವನು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ತಾಮ್ರದಿಂದ ಹೊದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ಬಳಿಕ ವೇದಿಕೆಯಲ್ಲಿ ಉಪಯೋಗಿಸುವ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು ಅಂದರೆ ಮಡಿಕೆಗಳು, ಸಲಿಕೆಗಳು, ಬೋಗುಣಿಗಳು, ಮುಳ್ಳುಗಳು ಮತ್ತು ಅಗ್ಗಿಷ್ಟಿಗೆಗಳನ್ನು ತಾಮ್ರದಿಂದ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ಬಳಿಕ ಅವನು ವೇದಿಕೆಗೆ ತಾಮ್ರದ ಜಾಳಿಗೆಯನ್ನು ಮಾಡಿದನು. ಜಾಳಿಗೆಯು ಹೆಣಿಗೇ ಕೆಲಸದಿಂದ ಮಾಡಲಾಗಿತ್ತು. ಜಾಳಿಗೆಯು ವೇದಿಕೆಯ ಕೆಳಭಾಗದಲ್ಲಿರುವ ಕಟ್ಟೆಯ ಕೆಳಗೆ ಇಡಲ್ಪಟ್ಟಿತ್ತು. ಅದು ಕೆಳಗಿನಿಂದ ವೇದಿಕೆಯ ಅರ್ಧಭಾಗದಷ್ಟು ಮೇಲಕ್ಕೆ ಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ಬಳಿಕ ಅವನು ತಾಮ್ರದ ಬಳೆಗಳನ್ನು ಮಾಡಿದನು. ಈ ಬಳೆಗಳು ವೇದಿಕೆಯನ್ನು ಕೋಲುಗಳಿಂದ ಹೊರುವುದಕ್ಕೆ ಉಪಯುಕ್ತವಾಗಿದ್ದವು. ಅವನು ಬಳೆಗಳನ್ನು ಜಾಳಿಗೆಯ ನಾಲ್ಕು ಮೂಲೆಗಳಲ್ಲಿ ಇಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ಬಳಿಕ ಅವನು ಜಾಲೀಮರದಿಂದ ಕೋಲುಗಳನ್ನು ಮಾಡಿ ಅವುಗಳನ್ನು ತಾಮ್ರದಿಂದ ಹೊದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ಅವನು ವೇದಿಕೆಯ ಪಾರ್ಶ್ವಗಳಲ್ಲಿದ್ದ ಬಳೆಗಳಲ್ಲಿ ಕೋಲುಗಳನ್ನು ಸೇರಿಸಿದನು. ಕೋಲುಗಳು ವೇದಿಕೆಯನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಉಪಯುಕ್ತವಾಗಿದ್ದವು. ಅವನು ವೇದಿಕೆಯನ್ನು ಪೆಟ್ಟಿಗೆಯಂತೆ ಮಾಡಲು ಹಲಗೆಗಳನ್ನು ಉಪಯೋಗಿಸಿದನು. ಅದು ಟೊಳ್ಳಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ಅವನು ತಾಮ್ರದಿಂದ ಗಂಗಾಳವನ್ನೂ ಅದರ ಪೀಠವನ್ನೂ ಮಾಡಿದನು. ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಸೇವೆ ಮಾಡುತ್ತಿದ್ದ ಸ್ತ್ರೀಯರು ಕೊಟ್ಟ ತಾಮ್ರದ ದರ್ಪಣಗಳನ್ನು ಅದಕ್ಕೆ ಉಪಯೋಗಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ಬಳಿಕ ಅವನು ಅಂಗಳವನ್ನು ಮಾಡಿದನು. ದಕ್ಷಿಣ ಭಾಗದಲ್ಲಿ ನೂರು ಮೊಳ ಉದ್ದದ ಪರದೆಯ ಗೋಡೆಯನ್ನು ಮಾಡಿದನು. ಪರದೆಗಳು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯಿಂದ ಮಾಡಲಾಗಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ದಕ್ಷಿಣ ಭಾಗದಲ್ಲಿದ್ದ ಪರದೆಗಳಿಗೆ ಇಪ್ಪತ್ತು ಕಂಬಗಳಿದ್ದವು. ಕಂಬಗಳಿಗೆ ಇಪ್ಪತ್ತು ತಾಮ್ರದ ಗದ್ದಿಗೇಕಲ್ಲುಗಳಿದ್ದವು. ಕಂಬಗಳ ಕೊಂಡಿಗಳು ಮತ್ತು ಪರದೆಯ ಕೋಲುಗಳು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಲ್ಪಟ್ಟಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ಅಂಗಳದ ಉತ್ತರ ಭಾಗದಲ್ಲಿಯೂ ನೂರು ಮೊಳ ಉದ್ದದ ಪರದೆಗಳ ಗೋಡೆಯಿತ್ತು. ಅವುಗಳಿಗೆ ಇಪ್ಪತ್ತು ಕಂಬಗಳು, ಇಪ್ಪತ್ತು ತಾಮ್ರದ ಗದ್ದಿಗೇಕಲ್ಲುಗಳು ಇದ್ದವು. ಕಂಬಗಳ ಕೊಂಡಿಗಳು ಮತ್ತು ಪರದೆಯ ಕೋಲುಗಳು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಲ್ಪಟ್ಟಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ಅಂಗಳದ ಪಶ್ಚಿಮ ಭಾಗದಲ್ಲಿ ಪರದೆಗಳ ಗೋಡೆಯು ಐವತ್ತು ಮೊಳ ಉದ್ದವಾಗಿತ್ತು. ಅಲ್ಲಿ ಹತ್ತು ಕಂಬಗಳೂ ಹತ್ತು ಗದ್ದಿಗೇಕಲ್ಲುಗಳೂ ಇದ್ದವು. ಕಂಬಗಳ ಕೊಂಡಿಗಳು ಮತ್ತು ಪರದೆಯ ಕೋಲುಗಳು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಲ್ಪಟ್ಟಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ಅಂಗಳದ ಪೂರ್ವ ಭಾಗವು ಐವತ್ತು ಮೊಳ ಅಗಲವಾಗಿತ್ತು. ಅಂಗಳದ ಪ್ರವೇಶದ್ವಾರವು ಈ ಭಾಗದಲ್ಲಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ಬಾಗಿಲಿನ ಒಂದು ಕಡೆಯಲ್ಲಿ ಪರದೆಗಳ ಗೋಡೆಯು ಹದಿನೈದು ಮೊಳ ಉದ್ದವಾಗಿತ್ತು. ಆ ಕಡೆಯಲ್ಲಿ ಮೂರು ಕಂಬಗಳೂ ಮೂರು ಗದ್ದಿಗೇಕಲ್ಲುಗಳೂ ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ಬಾಗಿಲಿನ ಇನ್ನೊಂದು ಕಡೆಯಲ್ಲೂ ಪರದೆಗಳ ಗೋಡೆಯು ಹದಿನೈದು ಮೊಳ ಉದ್ದವಾಗಿತ್ತು. ಆ ಕಡೆಯಲ್ಲಿ ಮೂರು ಕಂಬಗಳೂ ಮೂರು ಗದ್ದೀಗೆಕಲ್ಲುಗಳೂ ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ಅಂಗಳದ ಸುತ್ತಲಿದ್ದ ಪರದೆಗಳೆಲ್ಲಾ ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯಿಂದ ಮಾಡಲ್ಪಟ್ಟಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ಕಂಬಗಳ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ತಾಮ್ರದಿಂದ ಮಾಡಲಾಗಿತ್ತು. ಕೊಂಡಿಗಳನ್ನು ಮತ್ತು ಪರದೆಯ ಕೋಲುಗಳನ್ನು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಲಾಗಿತ್ತು. ಕಂಬಗಳ ತುದಿಗಳನ್ನೂ ಬೆಳ್ಳಿಯಿಂದ ಹೊದಿಸಲಾಗಿತ್ತು. ಅಂಗಳದಲ್ಲಿದ್ದ ಕಂಬಗಳಿಗೆಲ್ಲಾ ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಿದ ಪರದೆಯ ಕೋಲುಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ಅಂಗಳದ ಬಾಗಿಲಿನ ಪರದೆಯು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯಿಂದಲೂ, ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳಿಂದಲೂ ಮಾಡಲಾಗಿತ್ತು. ಪರದೆಯಲ್ಲಿ ನಕಾಸಿ ಕೆಲಸ ಮಾಡಲಾಗಿತ್ತು. ಪರದೆಯು ಇಪ್ಪತ್ತು ಮೊಳ ಉದ್ದ ಮತ್ತು ಐದು ಮೊಳ ಅಗಲವಾಗಿತ್ತು. ಅಂಗಳದ ಸುತ್ತಲಿದ್ದ ಎಲ್ಲಾ ಪರದೆಗಳ ಎತ್ತರ ಒಂದೇ ಆಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ಪರದೆಗಳಿಗೆ ನಾಲ್ಕು ಕಂಬಗಳು ಮತ್ತು ನಾಲ್ಕು ತಾಮ್ರದ ಗದ್ದಿಗೇಕಲ್ಲುಗಳು ಇದ್ದವು. ಕಂಬಗಳ ಕೊಂಡಿಗಳನ್ನು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಲಾಗಿತ್ತು. ಕಂಬಗಳ ತುದಿಗಳು ಬೆಳ್ಳಿಯಿಂದ ಮಾಡಲ್ಪಟ್ಟಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ಪವಿತ್ರಗುಡಾರದ ಎಲ್ಲಾ ಗೂಟಗಳು ಮತ್ತು ಅಂಗಳದ ಸುತ್ತಲಿದ್ದ ಪರದೆಗಳ ಗೂಟಗಳು ತಾಮ್ರದಿಂದ ಮಾಡಲ್ಪಟ್ಟಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ಒಡಂಬಡಿಕೆಯ ಗುಡಾರವಾದ ಪವಿತ್ರಗುಡಾರವನ್ನು ಮಾಡಲು ಉಪಯೋಗಿಸಿದ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ಬರೆದಿಡಬೇಕೆಂದು ಮೋಶೆಯು ಲೇವಿಯರಿಗೆ ಆಜ್ಞಾಪಿಸಿದನು. ಈ ಪಟ್ಟಿಯು ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನ ವಶದಲ್ಲಿ ಇತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರತಿಯೊಂದನ್ನೂ ಯೆಹೂದಕುಲದ ಹೂರನ ಮೊಮ್ಮಗನೂ ಊರಿಯ ಮಗನೂ ಆದ ಬೆಚಲೇಲನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ದಾನ್‌ಕುಲದ ಅಹೀಸಾಮಾಕನ ಮಗನಾದ ಒಹೊಲೀಯಾಬನು ಅವನಿಗೆ ಸಹಾಯ ಮಾಡಿದನು. ಒಹೊಲೀಯಾಬನು ನಿಪುಣನಾದ ಕೆಲಸಗಾರನೂ ನಕಾಸಿ ಕೆಲಸ ಮಾಡುವವನೂ ಆಗಿದ್ದನು. ಅವನು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯಲ್ಲಿ ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳಿಂದ ಬುಟೇದಾರೀ ಕೆಲಸ ಮಾಡಲು ನಿಪುಣನಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ಪವಿತ್ರಸ್ಥಳಕ್ಕಾಗಿ ಎರಡು ಟನ್‌ಗಿಂತ ಹೆಚ್ಚು ಬಂಗಾರವು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಕೊಡಲ್ಪಟ್ಟಿತು. (ಅಧಿಕೃತ ಅಳತೆಯನ್ನು ಉಪಯೋಗಿಸಿ ಇದನ್ನು ತೂಕ ಮಾಡಲಾಯಿತು.) ");
INSERT INTO kan2010_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಒಟ್ಟು ಗಂಡಸರು ಮೂರುಮುಕ್ಕಾಲು ಟನ್‌ಗಿಂತ ಹೆಚ್ಚು ಬೆಳ್ಳಿಯನ್ನು ಕೊಟ್ಟರು. (ಅಧಿಕೃತ ಅಳತೆಯನ್ನು ಉಪಯೋಗಿಸಿ ಇದನ್ನು ತೂಕ ಮಾಡಲಾಯಿತು.) ");
INSERT INTO kan2010_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕೆ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಗಂಡಸರನ್ನು ಲೆಕ್ಕಿಸಲಾಯಿತು. ಅಲ್ಲಿ ಆರು ಲಕ್ಷದ ಮೂರು ಸಾವಿರದ ಐನೂರೈವತ್ತು ಮಂದಿ ಗಂಡಸರಿದ್ದರು ಮತ್ತು ಪ್ರತಿಯೊಬ್ಬನು ತಲಾ ಒಂದು ಬೆಕಾ ಬೆಳ್ಳಿಯನ್ನು ತೆರಿಗೆಯಾಗಿ ಕೊಡಬೇಕಾಯಿತು. (ಅಧಿಕೃತ ಅಳತೆಯ ಪ್ರಕಾರ ಒಂದು ಬೆಕಾ ಅಂದರೆ ಅರ್ಧ ಶೆಕೆಲ್.) ");
INSERT INTO kan2010_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ಯೆಹೋವನ ಪವಿತ್ರಸ್ಥಳ ಮತ್ತು ಪರದೆಗಳಿಗೆ ಬೇಕಾದ ನೂರು ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಲು ಅವರು ಮೂರುಮುಕ್ಕಾಲು ಟನ್ ಬೆಳ್ಳಿಯನ್ನು ಉಪಯೋಗಿಸಿದರು. ಅವರು ಪ್ರತಿ ಗದ್ದಿಗೇಕಲ್ಲಿಗೆ ಎಪ್ಪತ್ತೈದು ಪೌಂಡು ಬೆಳ್ಳಿಯನ್ನು ಉಪಯೋಗಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ಉಳಿದ ಐವತ್ತು ಪೌಂಡು ಬೆಳ್ಳಿಯನ್ನು, ಕೊಂಡಿಗಳನ್ನೂ ಪರದೆಯ ಕೋಲುಗಳನ್ನೂ ಮಾಡುವುದಕ್ಕೂ ಕಂಬಗಳಿಗೆ ಹೊದಿಸುವುದಕ್ಕೂ ಉಪಯೋಗಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ಇಪ್ಪತ್ತಾರುವರೆ ಟನ್‌ಗಿಂತ ಹೆಚ್ಚು ತಾಮ್ರವನ್ನು ಯೆಹೋವನಿಗಾಗಿ ಕೊಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ಆ ತಾಮ್ರವನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿನ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಮಾಡಲು ಉಪಯೋಗಿಸಲಾಯಿತು. ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಮತ್ತು ತಾಮ್ರದ ಜಾಳಿಗೆಯನ್ನು ಮಾಡಲು ಅವರು ತಾಮ್ರವನ್ನು ಉಪಯೋಗಿಸಿದರು. ಯಜ್ಞವೇದಿಕೆಯ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು ಮತ್ತು ಬಟ್ಟಲುಗಳನ್ನು ಮಾಡಲು ತಾಮ್ರವನ್ನು ಉಪಯೋಗಿಸಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ಅದನ್ನು ಅಂಗಳದ ಸುತ್ತಲಿರುವ ಪರದೆಗಳ ಮತ್ತು ಬಾಗಿಲಿನ ಪರದೆಗಳ ಗದ್ದಿಗೇಕಲ್ಲುಗಳಿಗೂ ಉಪಯೋಗಿಸಲಾಯಿತು. ತಾಮ್ರವನ್ನು ಪವಿತ್ರಗುಡಾರದ ಮತ್ತು ಅಂಗಳದ ಸುತ್ತಲಿರುವ ಪರದೆಗಳ ಗೂಟಗಳನ್ನು ಮಾಡಲು ಉಪಯೋಗಿಸಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ಯಾಜಕರು ಯೆಹೋವನ ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಸೇವೆ ಮಾಡುವಾಗ ಧರಿಸಿಕೊಳ್ಳತಕ್ಕ ವಿಶೇಷ ಬಟ್ಟೆಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ಕೆಲಸಗಾರರು ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳನ್ನು ಉಪಯೋಗಿಸಿದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವರು ಆರೋನನಿಗೆ ವಿಶೇಷ ಬಟ್ಟೆಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ಅವರು ಏಫೋದನ್ನು ಚಿನ್ನದ ದಾರದಿಂದಲೂ ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯಿಂದಲೂ ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳಿಂದಲೂ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","(ಅವರು ಚಿನ್ನವನ್ನು ಸುತ್ತಿಗೆಯಿಂದ ಹೊಡೆದು ತೆಳುವಾದ ತಗಡುಗಳನ್ನು ಮಾಡಿದರು. ಬಳಿಕ ಅವರು ಅದನ್ನು ಕತ್ತರಿಸಿ ಉದ್ದವಾದ ದಾರಗಳನ್ನಾಗಿ ಮಾಡಿದರು. ಅವರು ಚಿನ್ನವನ್ನು ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳಿಗೂ ಮತ್ತು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಗೂ ಹೆಣೆದರು. ಇದು ಬಹಳ ನಿಪುಣನಾದ ಕೆಲಸಗಾರನು ಮಾಡಿದ ಕೆಲಸವಾಗಿತ್ತು.) ");
INSERT INTO kan2010_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ಅವರು ಏಫೋದಿನ ಭುಜದ ಪಟ್ಟಿಗಳನ್ನು ಮಾಡಿದರು. ಅವರು ಈ ಭುಜದ ಪಟ್ಟಿಗಳನ್ನು ಏಫೋದಿನ ಎರಡು ಮೂಲೆಗಳಿಗೆ ಕಟ್ಟಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ಅವರು ನಡುಕಟ್ಟನ್ನು ಹೆಣೆದು ಏಫೋದಿಗೆ ಬಿಗಿಯಾಗಿ ಕಟ್ಟಿದರು. ಏಫೋದನ್ನು ಮಾಡಿದಂತೆಯೇ ಇದನ್ನು ಮಾಡಲಾಯಿತು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವರು ಇದನ್ನು ಮಾಡುವುದಕ್ಕೆ ಚಿನ್ನದ ದಾರ, ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯನ್ನು ಮತ್ತು ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳನ್ನು ಉಪಯೋಗಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ಕೆಲಸಗಾರರು ಗೋಮೇಧಕ ರತ್ನಗಳನ್ನು ಏಫೋದಿನೊಳಗೆ ಚಿನ್ನದ ಕುಂದಣದಲ್ಲಿ ಇಟ್ಟರು. ಈ ರತ್ನಗಳಲ್ಲಿ ಇಸ್ರೇಲರ ಹನ್ನೆರಡು ಕುಲಗಳ ಹೆಸರುಗಳನ್ನು ಬರೆದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ಬಳಿಕ ಅವರು ಈ ರತ್ನಗಳನ್ನು ಏಫೋದಿನ ಭುಜದ ಪಟ್ಟಿಯಲ್ಲಿ ಇಟ್ಟರು. ಇಸ್ರೇಲರನ್ನು ದೇವರ ಜ್ಞಾಪಕಕ್ಕೆ ತರುವಂತೆ ಈ ರತ್ನಗಳು ಇಡಲ್ಪಟ್ಟವು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇದನ್ನು ಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ಬಳಿಕ ಅವರು ದೈವನಿರ್ಣಯ ಪದಕವನ್ನು ಮಾಡಿದರು. ಏಫೋದಿನಂತೆಯೇ ಇದು ಸಹ ಬುಟೇದಾರೀ ಕೆಲಸವಾಗಿತ್ತು. ಅದನ್ನು ಚಿನ್ನದ ದಾರಗಳಿಂದಲೂ ಶ್ರೇಷ್ಠವಾದ ನಾರುಬಟ್ಟೆಯಿಂದಲೂ ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳಿಂದಲೂ ಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ದೈವನಿರ್ಣಯದ ಪದಕವನ್ನು ಅರ್ಧ ಮಡಚಿ ಚಚ್ಚೌಕವಾದ ಚೀಲವನ್ನಾಗಿ ಮಾಡಲಾಗಿತ್ತು. ಅದು ಒಂಭತ್ತು ಇಂಚು ಉದ್ದ ಮತ್ತು ಒಂಭತ್ತು ಇಂಚು ಅಗಲ ಇತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ಬಳಿಕ ಕೆಲಸಗಾರರು ಅಂದವಾದ ರತ್ನಗಳನ್ನು ನಾಲ್ಕು ಸಾಲುಗಳಾಗಿ ದೈವನಿರ್ಣಯದ ಪದಕದಲ್ಲಿ ಇಟ್ಟರು. ಮೊದಲನೆಯ ಸಾಲಿನಲ್ಲಿ ಮಾಣಿಕ್ಯ, ಪುಷ್ಯರಾಗ, ಸ್ಫಟಿಕಗಳು ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ಎರಡನೆಯ ಸಾಲಿನಲ್ಲಿ ಕೆಂಪರಲು, ನೀಲಪಚ್ಚೆಗಳು ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ಮೂರನೆಯ ಸಾಲಿನಲ್ಲಿ ಸುವರ್ಣರತ್ನ, ಗೋಮೇಧಕ, ಧೂಮ್ರಮಣಿಗಳು ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ನಾಲ್ಕನೆಯ ಸಾಲಿನಲ್ಲಿ ಪೀತರತ್ನ, ಬೆರುಲ್ಲ, ವೈಡೂರ್ಯಗಳು ಇದ್ದವು. ಈ ಎಲ್ಲಾ ರತ್ನಗಳನ್ನು ಚಿನ್ನದ ಜವೆಯ ಕಲ್ಲುಗಳಲ್ಲಿ ಇಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ಇಸ್ರೇಲನ ಗಂಡುಮಕ್ಕಳಲ್ಲಿ ಒಬ್ಬೊಬ್ಬರಿಗೆ ಒಂದೊಂದು ರತ್ನದಂತೆ ದೈವನಿರ್ಣಯ ಪದಕದಲ್ಲಿ ಹನ್ನೆರಡು ರತ್ನಗಳಿದ್ದವು. ಪ್ರತಿ ರತ್ನದಲ್ಲಿಯೂ ಇಸ್ರೇಲನ ಗಂಡುಮಕ್ಕಳಲ್ಲಿ ಒಬ್ಬೊಬ್ಬನ ಹೆಸರು ಬರೆಯಲ್ಪಟ್ಟಿತ್ತು. ಮುದ್ರಾರತ್ನವನ್ನು ಕೆತ್ತುವಂತೆ ಕಲ್ಲಿನಲ್ಲಿ ಹೆಸರುಗಳನ್ನು ಕೆತ್ತಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ಅವರು ದೈವನಿರ್ಣಯಪದಕಕ್ಕೆ ಅಪ್ಪಟ ಬಂಗಾರದ ಸರಪಣಿಗಳನ್ನು ಹುರಿಗಳಂತಿರುವ ಹಗ್ಗದಂತೆ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ಕೆಲಸಗಾರರು ಎರಡು ಚಿನ್ನದ ಕುಂದಣಗಳನ್ನೂ ಎರಡು ಚಿನ್ನದ ಉಂಗುರಗಳನ್ನೂ ಮಾಡಿದರು. ಅವರು ಎರಡು ಚಿನ್ನದ ಉಂಗುರಗಳನ್ನು ದೈವನಿರ್ಣಯಪದಕದ ಎರಡು ಕೊನೆಗಳಲ್ಲಿ ಇರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ಬಳಿಕ ಅವರು ದೈವನಿರ್ಣಯಪದಕದ ಕೊನೆಗಳಲ್ಲಿರುವ ಉಂಗುರಗಳಿಗೆ ಎರಡು ಚಿನ್ನದ ಸರಪಣಿಗಳನ್ನು ಸಿಕ್ಕಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ಅವರು ಚಿನ್ನದ ಸರಪಣಿಗಳ ಇನ್ನೆರಡು ಕೊನೆಗಳನ್ನು ಎರಡು ಕುಂದಣಗಳಿಗೆ ಕಟ್ಟಿದರು. ಇದು ಅವುಗಳನ್ನು ಏಫೋದಿನ ಎರಡು ಭುಜದ ಪಟ್ಟಿಗಳಿಗೆ ಮುಂಭಾಗದಲ್ಲಿ ಬಿಗಿಯಾಗಿ ಹಿಡಿದುಕೊಂಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ಬಳಿಕ ಅವರು ಇನ್ನೆರಡು ಚಿನ್ನದ ಉಂಗುರಗಳನ್ನು ಮಾಡಿ, ದೈವನಿರ್ಣಯ ಪದಕದ ಇನ್ನೆರಡು ಕೊನೆಗಳಿಗೆ ಸಿಕ್ಕಿಸಿದರು. ಅವರು ಉಂಗುರಗಳನ್ನು ಏಫೋದಿನ ಹತ್ತಿರವಿರುವ ದೈವನಿರ್ಣಯ ಪದಕದ ಒಳಗಿನ ಅಂಚಿನಲ್ಲಿ ಇರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ಅವರು ಎರಡು ಚಿನ್ನದ ಉಂಗುರಗಳನ್ನು ಏಫೋದಿನ ಮುಂಭಾಗದಲ್ಲಿ ಭುಜದ ಪಟ್ಟಿಗಳ ಕೆಳಭಾಗದಲ್ಲಿ ಇರಿಸಿದರು. ಈ ಉಂಗುರಗಳು ನಡುಕಟ್ಟಿನ ಮೇಲ್ಗಡೆಯಲ್ಲಿರುವ ಕಟ್ಟಿನ ಹತ್ತಿರ ಇದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ಬಳಿಕ ಅವರು ನೀಲಿದಾರದಿಂದ ದೈವನಿರ್ಣಯ ಪದಕದ ಉಂಗುರಗಳನ್ನು ಏಫೋದಿನ ಉಂಗುರಗಳಿಗೆ ಕಟ್ಟಿದರು. ಈ ರೀತಿಯಾಗಿ ದೈವನಿರ್ಣಯ ಪದಕವು ನಡುಕಟ್ಟಿಗೆ ಹತ್ತಿರವಾಗಿದ್ದು ಏಫೋದಿಗೆ ಬಿಗಿಯಾಗಿ ಅಂಟಿಕೊಂಡಿತ್ತು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವರು ಎಲ್ಲವನ್ನೂ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ಬಳಿಕ ಅವರು ಏಫೋದಿನೊಂದಿಗೆ ತೊಟ್ಟುಕೊಳ್ಳಬೇಕಾದ ನಿಲುವಂಗಿಯನ್ನು ಮಾಡಿದರು. ಅದು ನಿಪುಣನಾದ ಕೆಲಸಗಾರನಿಂದ ಹೆಣೆಯಲ್ಪಟ್ಟಿತ್ತು. ಅವರು ಅದನ್ನು ನೀಲಿ ಬಟ್ಟೆಯಿಂದ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ಅವರು ನಿಲುವಂಗಿಯ ಮಧ್ಯದಲ್ಲಿ ಒಂದು ಸಂದನ್ನು ಮಾಡಿ ಆ ಸಂದಿನ ಅಂಚಿನ ಸುತ್ತಲೂ ಬಟ್ಟೆಯನ್ನಿಟ್ಟು ಹೊಲಿದರು. ಈ ಬಟ್ಟೆಯು ಸಂದು ಹರಿದು ಹೋಗದಂತೆ ಮಾಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ತರುವಾಯ ಅವರು ಬಟ್ಟೆಗೆ ದಾಳಿಂಬೆ ಹಣ್ಣಿನ ಚೆಂಡುಗಳನ್ನು ಮಾಡಲು ಶ್ರೇಷ್ಠ ನಾರುಬಟ್ಟೆಯನ್ನು, ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳನ್ನು ಉಪಯೋಗಿಸಿದರು. ಅವರು ಈ ದಾಳಿಂಬೆ ಹಣ್ಣಿನಂತಿರುವ ಚೆಂಡುಗಳನ್ನು ನಿಲುವಂಗಿಯ ಕೆಳಅಂಚಿನಲ್ಲಿ ತೂಗುಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ಬಳಿಕ ಅವರು ಅಪ್ಪಟ ಬಂಗಾರದ ಗೆಜ್ಜೆಗಳನ್ನು ಮಾಡಿದರು. ಅವರು ಈ ಗೆಜ್ಜೆಗಳನ್ನು ನಿಲುವಂಗಿಯ ಕೆಳಅಂಚಿನ ಸುತ್ತಲೂ ದಾಳಿಂಬೆ ಹಣ್ಣುಗಳ ನಡುವೆ ತೂಗು ಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ಹೀಗೆ ನಿಲುವಂಗಿಯ ಕೆಳಅಂಚಿನ ಸುತ್ತಲೆಲ್ಲ ದಾಳಿಂಬೆ ಹಣ್ಣುಗಳೂ ಗೆಜ್ಜೆಗಳೂ ಇದ್ದವು. ಪ್ರತಿ ದಾಳಿಂಬೆ ಹಣ್ಣಿನ ನಡುವೆ ಒಂದೊಂದು ಗೆಜ್ಜೆ ಇತ್ತು. ಯಾಜಕರು ಯೆಹೋವನ ಸೇವೆ ಮಾಡುವಾಗ ಧರಿಸಿಕೊಳ್ಳತಕ್ಕ ನಿಲುವಂಗಿ ಇದಾಗಿತ್ತು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇದನ್ನು ಮಾಡಲಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ನಿಪುಣರಾದ ಕೆಲಸಗಾರರು ಆರೋನನಿಗೂ ಅವನ ಮಕ್ಕಳಿಗೂ ಅಂಗಿಗಳನ್ನು ಹೊಲಿದರು. ಈ ಅಂಗಿಗಳು ಶ್ರೇಷ್ಠವಾದ ನಾರುಬಟ್ಟೆಯಿಂದ ಮಾಡಲ್ಪಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ಶ್ರೇಷ್ಠವಾದ ನಾರುಬಟ್ಟೆಯಿಂದ ಕೆಲಸಗಾರರು ಒಂದು ಮುಂಡಾಸನ್ನು ಮಾಡಿದರು. ಅವರು ತಲೆಪಟ್ಟಿಗಳನ್ನು ಮತ್ತು ಒಳಅಂಗಿಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ಶ್ರೇಷ್ಠವಾದ ನಾರುಬಟ್ಟೆಯನ್ನು ಉಪಯೋಗಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ಬಳಿಕ ಅವರು ಶ್ರೇಷ್ಠವಾದ ನಾರುಬಟ್ಟೆಯಿಂದಲೂ ಮತ್ತು ನೀಲಿ, ನೇರಳೆ, ಕೆಂಪುದಾರಗಳಿಂದಲೂ ನಡುಕಟ್ಟನ್ನು ಮಾಡಿದರು. ಈ ಬಟ್ಟೆಗೆ ಕಸೂತಿ ಹಾಕಲಾಯಿತು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಈ ವಸ್ತುಗಳನ್ನು ಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ತರುವಾಯ ಅವರು ಪವಿತ್ರಕಿರೀಟವನ್ನೂ ಅಪ್ಪಟ ಬಂಗಾರದಿಂದ ಮಾಡಿದರು. ಅವರು ಬಂಗಾರದಲ್ಲಿ ಅಕ್ಷರಗಳನ್ನು ಕೆತ್ತಿದರು. ಅವರು, “ಯೆಹೋವನಿಗೆ ಪವಿತ್ರವಾದದ್ದು” ಎಂಬ ಮಾತುಗಳನ್ನು ಬರೆದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ಅವರು ಚಿನ್ನದ ಪಟ್ಟಿಯನ್ನು ದಾರಕ್ಕೆ ಬಿಗಿದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವರು ಈ ನೀಲಿ ದಾರವನ್ನು ಮುಂಡಾಸಕ್ಕೆ ಕಟ್ಟಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ಹೀಗೆ ಪವಿತ್ರಗುಡಾರವಾದ ದೇವದರ್ಶನ ಗುಡಾರದ ಕೆಲಸವೆಲ್ಲವೂ ಮುಗಿಯಿತು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರೇಲರು ಪ್ರತಿಯೊಂದನ್ನೂ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ಬಳಿಕ ಅವರು ಪವಿತ್ರಗುಡಾರವನ್ನು ಮೋಶೆಗೆ ತೋರಿಸಿದರು. ಅವರು ಗುಡಾರವನ್ನೂ ಅದರಲ್ಲಿರುವ ವಸ್ತುಗಳನ್ನೆಲ್ಲಾ ಅವನಿಗೆ ತೋರಿಸಿದರು. ಬಳೆಗಳು, ಚೌಕಟ್ಟುಗಳು, ಅಗುಳಿಗಳು, ಕಂಬಗಳು, ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನೆಲ್ಲಾ ಅವನಿಗೆ ತೋರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ಅವರು ಕೆಂಪುಬಣ್ಣದ ಕುರಿತೊಗಲಿನಿಂದ ಮಾಡಿದ ಗುಡಾರದ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಅವನಿಗೆ ತೋರಿಸಿದರು; ಶ್ರೇಷ್ಠವಾದ ತೊಗಲಿನಿಂದ ಮಾಡಿದ ಹೊದಿಕೆಯನ್ನೂ ಅವನಿಗೆ ತೋರಿಸಿದರು. ಮಹಾಪವಿತ್ರಸ್ಥಳವನ್ನು ಮುಚ್ಚುವ ಪರದೆಯನ್ನೂ ಅವನಿಗೆ ತೋರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ಅವರು ಮೋಶೆಗೆ ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯನ್ನೂ ಆ ಪೆಟ್ಟಿಗೆಯನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಉಪಯೋಗಿಸುವ ಕೋಲುಗಳನ್ನೂ ಪೆಟ್ಟಿಗೆಯ ಕೃಪಾಸನವನ್ನೂ ಮೋಶೆಗೆ ತೋರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ಅವರು ಮೇಜನ್ನೂ ಅದರಲ್ಲಿರುವ ಪ್ರತಿಯೊಂದನ್ನೂ ನೈವೇದ್ಯದ ರೊಟ್ಟಿಯನ್ನೂ ಅವನಿಗೆ ತೋರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ಅವರು ಅಪ್ಪಟ ಬಂಗಾರದ ದೀಪಸ್ತಂಭವನ್ನೂ ಅದರಲ್ಲಿರುವ ಹಣತೆಗಳನ್ನೂ ಎಣ್ಣೆಯನ್ನೂ ಹಣತೆಗಳೊಂದಿಗೆ ಉಪಯೋಗಿಸುವ ಇತರ ವಸ್ತುಗಳನ್ನೂ ತೋರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ಅವರು ಚಿನ್ನದ ವೇದಿಕೆಯನ್ನೂ ಅಭಿಷೇಕತೈಲವನ್ನೂ ಪರಿಮಳಧೂಪವನ್ನೂ ಗುಡಾರದ ಪ್ರವೇಶದಲ್ಲಿರುವ ಪರದೆಯನ್ನೂ ಮೋಶೆಗೆ ತೋರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ಅವರು ಅವನಿಗೆ ತಾಮ್ರದ ವೇದಿಕೆಯನ್ನೂ ತಾಮ್ರದ ಜಾಳಿಗೆಯನ್ನೂ ವೇದಿಕೆಯನ್ನು ಹೊರುವುದಕ್ಕೆ ಉಪಯೋಗಿಸುವ ಕೋಲುಗಳನ್ನೂ ವೇದಿಕೆಯ ಎಲ್ಲಾ ಉಪರಕಣಗಳನ್ನೂ ಗಂಗಾಳವನ್ನೂ ಮತ್ತು ಅದರ ಕೆಳಗಿರುವ ಗದ್ದಿಗೇಕಲ್ಲನ್ನೂ ಮೋಶೆಗೆ ತೋರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ಅವರು ಅಂಗಳದ ಸುತ್ತಲಿರುವ ಪರದೆಗಳ ಗೋಡೆಯನ್ನೂ ಅದರ ಕಂಬಗಳನ್ನೂ ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನೂ ಅಂಗಳದ ಪ್ರವೇಶವನ್ನು ಮುಚ್ಚುವ ಪರದೆಯನ್ನೂ ಹಗ್ಗಗಳನ್ನೂ ಗುಡಾರದ ಗೂಟಗಳನ್ನೂ ದೇವದರ್ಶನದ ಪವಿತ್ರಗುಡಾರದ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನೂ ಮೋಶೆಗೆ ತೋರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ತರುವಾಯ ಮೋಶೆಗೆ ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಸೇವೆ ಮಾಡುವುದಕ್ಕೆ ಯಾಜಕರಿಗಾಗಿ ಮಾಡಿದ ಬಟ್ಟೆಗಳನ್ನು ಅಂದರೆ ಯಾಜಕನಾದ ಆರೋನನಿಗೆ ಮತ್ತು ಅವನ ಮಕ್ಕಳಿಗಾಗಿ ಮಾಡಿದ ವಿಶೇಷ ಬಟ್ಟೆಗಳನ್ನು ಅವರು ತೋರಿಸಿದರು. ಅವರು ಯಾಜಕರಾಗಿ ಸೇವೆ ಮಾಡುವಾಗ ಧರಿಸಿಕೊಳ್ಳತಕ್ಕ ಬಟ್ಟೆಗಳು ಇವುಗಳೇ. ");
INSERT INTO kan2010_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರೇಲರು ಇವುಗಳನ್ನೆಲ್ಲಾ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ಮೋಶೆಯು ಎಲ್ಲಾ ಕೆಲಸವನ್ನು ಸೂಕ್ಷ್ಮವಾಗಿ ಪರೀಕ್ಷಿಸಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಎಲ್ಲವೂ ಮಾಡಲ್ಪಟ್ಟಿದ್ದರಿಂದ ಮೋಶೆ ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ದೇವದರ್ಶನಗುಡಾರವಾದ ಪವಿತ್ರಗುಡಾರವನ್ನು ಎತ್ತಿನಿಲ್ಲಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ಪವಿತ್ರ ಗುಡಾರದಲ್ಲಿ ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯನ್ನು ಇಡು. ಪೆಟ್ಟಿಗೆಯನ್ನು ಪರದೆಯಿಂದ ಮುಚ್ಚಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ಬಳಿಕ ಮೇಜನ್ನು ಒಳಗೆ ತರಿಸಿ ಮೇಜಿನ ಮೇಲಿರಬೇಕಾದ ವಸ್ತುಗಳನ್ನು ಅದರ ಮೇಲಿರಿಸು. ದೀಪಸ್ತಂಭವನ್ನು ಗುಡಾರದಲ್ಲಿ ಇರಿಸು. ದೀಪಸ್ತಂಭದಲ್ಲಿ ಸರಿಯಾದ ಜಾಗಗಳಲ್ಲಿ ಹಣತೆಗಳನ್ನು ಇರಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ಗುಡಾರದೊಳಗೆ ಧೂಪವನ್ನು ಅರ್ಪಿಸಲು ಬಂಗಾರದ ವೇದಿಕೆಯನ್ನು ಇಡು. ವೇದಿಕೆಯನ್ನು ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯ ಮುಂದಿರಿಸು. ಬಳಿಕ ಪವಿತ್ರಗುಡಾರದ ಪ್ರವೇಶದಲ್ಲಿ ಪರದೆಯನ್ನು ಇರಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“ದೇವದರ್ಶನಗುಡಾರವಾದ ಪವಿತ್ರಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದ ಮುಂದೆ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಇರಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ಗಂಗಾಳವನ್ನು ದೇವದರ್ಶನಗುಡಾರ ಮತ್ತು ವೇದಿಕೆಯ ನಡುವೆ ಇರಿಸು. ಗಂಗಾಳದಲ್ಲಿ ನೀರನ್ನು ಹಾಕಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ಅಂಗಳದ ಸುತ್ತಲೂ ಪರದೆಗಳ ಗೋಡೆಯನ್ನು ನಿಲ್ಲಿಸು. ಬಳಿಕ ಅಂಗಳದ ಬಾಗಿಲಿಗೆ ಪರದೆಯನ್ನು ಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ಅಭಿಷೇಕತೈಲವನ್ನು ಉಪಯೋಗಿಸಿ ಪವಿತ್ರಗುಡಾರವನ್ನೂ ಅದರಲ್ಲಿರುವ ಪ್ರತಿಯೊಂದನ್ನೂ ಅಭಿಷೇಕಿಸು. ನೀನು ತೈಲವನ್ನು ಈ ವಸ್ತುಗಳ ಮೇಲೆ ಹಾಕುವಾಗ, ಅವುಗಳನ್ನು ಪವಿತ್ರಗೊಳಿಸುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಅಭಿಷೇಕಿಸು. ವೇದಿಕೆಯ ಮೇಲಿರುವ ಪ್ರತಿಯೊಂದನ್ನು ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸು. ಆಗ ಅದು ಬಹು ಪವಿತ್ರವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ಬಳಿಕ ಗಂಗಾಳವನ್ನೂ ಅದರ ಕೆಳಗಿರುವ ಪೀಠವನ್ನೂ ಅಭಿಷೇಕಿಸಿ ಪವಿತ್ರಗೊಳಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಕರೆಸು. ಅವರಿಗೆ ನೀರಿನಿಂದ ಸ್ನಾನ ಮಾಡಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ಬಳಿಕ ಆರೋನನಿಗೆ ವಿಶೇಷ ಬಟ್ಟೆಯನ್ನು ತೊಡಿಸು. ತೈಲದಿಂದ ಅವನನ್ನು ಅಭಿಷೇಕಿಸಿ ಪವಿತ್ರಗೊಳಿಸು. ಆಗ ಅವನು ಯಾಜಕನಾಗಿ ನನ್ನ ಸೇವೆ ಮಾಡಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ಬಳಿಕ ಅವನ ಪುತ್ರರಿಗೆ ಬಟ್ಟೆಗಳನ್ನು ತೊಡಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ಅವರ ತಂದೆಯನ್ನು ಅಭಿಷೇಕಿಸಿದಂತೆ ಪುತ್ರರನ್ನೂ ಅಭಿಷೇಕಿಸು. ಆಗ ಅವರು ಯಾಜಕರಾಗಿ ತಲೆತಲೆಮಾರುಗಳವರೆಗೆ ನನ್ನ ಸೇವೆ ಮಾಡಬಹುದು. ನೀನು ಅವರನ್ನು ಅಭಿಷೇಕಿಸಿದಾಗ, ಅವರು ಯಾಜಕರಾಗುವರು. ಇನ್ನು ಮುಂದೆ ಆ ಕುಟುಂಬವು ಯಾಜಕರಾಗಿ ಮುಂದುವರಿಯುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಪ್ರತಿಯೊಂದನ್ನೂ ಮೋಶೆಯು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ಆದ್ದರಿಂದ ಪವಿತ್ರಗುಡಾರವು, ಅವರು ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟಕಾಲದಿಂದ ಎರಡನೆಯ ವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಸ್ಥಾಪಿಸಲ್ಪಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಮೋಶೆಯು ಪವಿತ್ರಗುಡಾರವನ್ನು ನಿಲ್ಲಿಸಿದನು. ಅವನು ಮೊದಲು ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು ಕೆಳಗೆ ಇರಿಸಿದನು. ಬಳಿಕ ಅವನು ಗದ್ದಿಗೇಕಲ್ಲುಗಳ ಮೇಲೆ ಚೌಕಟ್ಟುಗಳನ್ನು ಇರಿಸಿದನು. ಬಳಿಕ ಅವನು ಅಗುಳಿಗಳನ್ನಿರಿಸಿ ಕಂಬಗಳನ್ನು ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ನಂತರ, ಮೋಶೆಯು ಪವಿತ್ರಗುಡಾರದ ಮೇಲೆ ಹೊರಗಣ ಡೇರೆಯನ್ನು ಹಾಕಿಸಿದನು. ಬಳಿಕ ಅವನು ಹೊರಗಿನ ಡೇರೆಗೆ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ಹಾಕಿಸಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವನು ಈ ಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ಮೋಶೆಯು ಒಡಂಬಡಿಕೆಯ ಆಜ್ಞಾಶಾಸನಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಯಲ್ಲಿಟ್ಟನು. ಮೋಶೆಯು ಪೆಟ್ಟಿಗೆಯ ಎರಡು ಕಡೆಗಳಲ್ಲಿ ಕೋಲುಗಳನ್ನು ಇರಿಸಿದನು. ಬಳಿಕ ಅವನು ಪೆಟ್ಟಿಗೆಯ ಮೇಲೆ ಕೃಪಾಸನವನ್ನು ಇಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ಬಳಿಕ ಮೋಶೆಯು ಪವಿತ್ರಪೆಟ್ಟಿಗೆಯನ್ನು ಪವಿತ್ರಗುಡಾರದೊಳಗೆ ತಂದನು. ಅದನ್ನು ಸಂರಕ್ಷಿಸುವುದಕ್ಕಾಗಿ ಸರಿಯಾದ ಸ್ಥಳದಲ್ಲಿ ಪರದೆಯನ್ನು ಹಾಕಿದನು. ಹೀಗೆ ಒಡಂಬಡಿಕೆ ಪೆಟ್ಟಿಗೆಯನ್ನು ಪರದೆಯ ಹಿಂಭಾಗದಲ್ಲಿರಿಸಿ ಸಂರಕ್ಷಿಸಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇದನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ತರುವಾಯ ಮೋಶೆಯು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಮೇಜನ್ನು ಇರಿಸಿದನು. ಪವಿತ್ರಗುಡಾರದ ಉತ್ತರಭಾಗದಲ್ಲಿ ಅದನ್ನು ಇರಿಸಿದನು. ಅವನು ಅದನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಪರದೆಯ ಮುಂಭಾಗದಲ್ಲಿ ಇರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ಬಳಿಕ ಅವನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಮೇಜಿನ ಮೇಲೆ ನೈವೇದ್ಯದ ರೊಟ್ಟಿಯನ್ನಿರಿಸಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವನು ಇದನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ಬಳಿಕ ಮೋಶೆಯು ದೀಪಸ್ತಂಭವನ್ನು ಪವಿತ್ರಗುಡಾರದೊಳಗೆ ಇರಿಸಿದನು. ಮೇಜಿಗೆ ಎದುರಾಗಿ ಗುಡಾರದ ದಕ್ಷಿಣ ಭಾಗದಲ್ಲಿ ದೀಪಸ್ತಂಭವನ್ನಿರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ತರುವಾಯ ಮೋಶೆಯು ಯೆಹೋವನ ಮುಂದಿರುವ ದೀಪಸ್ತಂಭದಲ್ಲಿ ಹಣತೆಗಳನ್ನು ಇರಿಸಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವನು ಇದನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ಬಳಿಕ ಮೋಶೆಯು ಚಿನ್ನದ ವೇದಿಕೆಯನ್ನು ದೇವದರ್ಶನಗುಡಾರದೊಳಗೆ ಇರಿಸಿದನು. ಅವನು ವೇದಿಕೆಯನ್ನು ಪರದೆಯ ಮುಂಭಾಗದಲ್ಲಿ ಇರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ಬಳಿಕ ಅವನು ವೇದಿಕೆಯ ಮೇಲೆ ಸುಗಂಧವಾಸನೆಯುಳ್ಳ ಧೂಪವನ್ನು ಉರಿಸಿದನು. ಯೆಹೋವನು ಅವನಿಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇದನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ಬಳಿಕ ಮೋಶೆಯು ಪವಿತ್ರಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಪರದೆಯನ್ನು ಹಾಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ಪವಿತ್ರಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದ ಬಳಿಯಲ್ಲಿ ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಇರಿಸಿದನು. ಅವನು ಯೆಹೋವನಿಗಾಗಿ ಆ ವೇದಿಕೆಯ ಮೇಲೆ ಸರ್ವಾಂಗಹೋಮವನ್ನೂ ಧಾನ್ಯಸಮರ್ಪಣೆಯನ್ನೂ ಮಾಡಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವನು ಇದನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ತರುವಾಯ ಮೋಶೆಯು ಗಂಗಾಳವನ್ನು ದೇವದರ್ಶನಗುಡಾರ ಮತ್ತು ವೇದಿಕೆಯ ನಡುವೆ ಇಟ್ಟನು. ತೊಳೆದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ನೀರನ್ನು ಗಂಗಾಳದಲ್ಲಿ ಹಾಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ಮೋಶೆ, ಆರೋನ ಮತ್ತು ಆರೋನನ ಪುತ್ರರು ತಮ್ಮ ಕೈಕಾಲುಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಈ ಗಂಗಾಳವನ್ನು ಉಪಯೋಗಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ಅವರು ದೇವದರ್ಶನಗುಡಾರವನ್ನು ಪ್ರವೇಶಿಸುವಾಗಲೆಲ್ಲಾ ಮತ್ತು ಯಜ್ಞವೇದಿಕೆಯ ಸಮೀಪ ಹೋಗುವಾಗಲೆಲ್ಲಾ ತಮ್ಮನ್ನು ತೊಳೆದುಕೊಳ್ಳುತ್ತಿದ್ದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವರು ಇದನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ತರುವಾಯ ಮೋಶೆಯು ಪವಿತ್ರಗುಡಾರದ ಅಂಗಳದ ಸುತ್ತಲೂ ಪರದೆಗಳನ್ನು ನಿಲ್ಲಿಸಿದನು. ಮೋಶೆಯು ವೇದಿಕೆಯನ್ನು ಅಂಗಳದಲ್ಲಿರಿಸಿದನು. ಬಳಿಕ ಅವನು ಅಂಗಳದ ಬಾಗಿಲಿಗೆ ಪರದೆಯನ್ನು ಹಾಕಿಸಿದನು. ಹೀಗೆ ಮೋಶೆ ಯೆಹೋವನು ತನಗೆ ಕೊಟ್ಟ ಎಲ್ಲಾ ಕೆಲಸವನ್ನು ಮಾಡಿ ಮುಗಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ತರುವಾಯ ಮೋಡವು ದೇವದರ್ಶನಗುಡಾರವನ್ನು ಕವಿಯಿತು. ಯೆಹೋವನ ಮಹಿಮೆಯು ಪವಿತ್ರಗುಡಾರವನ್ನು ತುಂಬಿಕೊಂಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ಮೋಡವು ದೇವದರ್ಶನಗುಡಾರದ ಮೇಲೆ ನಿಂತಿತು. ಯೆಹೋವನ ಮಹಿಮೆಯು ಪವಿತ್ರಗುಡಾರವನ್ನು ತುಂಬಿಕೊಂಡಿದ್ದರಿಂದ ಮೋಶೆಯು ಒಳಗೆ ಪ್ರವೇಶಿಸಲಾಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ಜನರು ಯಾವಾಗ ಚಲಿಸಬೇಕೆಂದು ಮೋಡವು ತೋರಿಸುತ್ತಿತ್ತು. ಮೋಡವು ಪವಿತ್ರಗುಡಾರವನ್ನು ಬಿಟ್ಟು ಮೇಲೆದ್ದಾಗ, ಜನರು ಪ್ರಯಾಣ ಮಾಡತೊಡಗುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ಆದರೆ ಮೋಡವು ಪವಿತ್ರಗುಡಾರದ ಮೇಲಿದ್ದಾಗ ಜನರು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿರಲಿಲ್ಲ. ಮೋಡವು ಮೇಲೇಳುವವರೆಗೆ ಅವರು ಅಲ್ಲೇ ಇರುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ಹೀಗೆ ಯೆಹೋವನ ಮೋಡವು ಹಗಲಿನಲ್ಲಿ ಪವಿತ್ರಗುಡಾರದ ಮೇಲೆ ನಿಂತಿತು. ರಾತ್ರಿಯಲ್ಲಿ ಮೋಡದಲ್ಲಿ ಅಗ್ನಿಯು ಪ್ರಕಾಶಿಸುತ್ತಿತ್ತು. ಆದ್ದರಿಂದ ಇಸ್ರೇಲ್ ಜನರೆಲ್ಲರೂ ತಾವು ಪ್ರಯಾಣ ಮಾಡುವಾಗ, ಮೋಡವನ್ನು ನೋಡಬಹುದಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ಯೆಹೋವನು ಮೋಶೆಯನ್ನು ಕರೆದು ದೇವದರ್ಶನಗುಡಾರದೊಳಗಿಂದ ಅವನ ಸಂಗಡ ಮಾತಾಡಿದನು. ಯೆಹೋವನು ಹೀಗೆ ಹೇಳಿದನು: ");
INSERT INTO kan2010_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ಇಸ್ರೇಲರಿಗೆ ನೀನು ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ನೀವು ಯೆಹೋವನಿಗೆ ಯಜ್ಞವನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಅರ್ಪಿಸುವುದಾದರೆ ನೀವು ಸಾಕಿದ ಪಶುಗಳನ್ನೇ ಅರ್ಪಿಸಬೇಕು. ಅದು ದನವಾಗಲಿ ಕುರಿಯಾಗಲಿ ಆಡಾಗಲಿ ಆಗಿರಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ಒಬ್ಬನು ತನ್ನ ದನಗಳಲ್ಲಿ ಒಂದನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಅರ್ಪಿಸಬಯಸಿದರೆ ಆ ಪಶುವು ಯಾವ ದೋಷವಿಲ್ಲದ ಹೋರಿಯಾಗಿರಬೇಕು. ಅವನು ಆ ಪಶುವನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತರಬೇಕು. ಆಗ ಯೆಹೋವನು ಆ ಸಮರ್ಪಣೆಯನ್ನು ಮೆಚ್ಚಿಕೊಳ್ಳುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ಅವನು ತನ್ನ ಕೈಯನ್ನು ಪ್ರಾಣಿಯ ತಲೆಯ ಮೇಲಿಡಬೇಕು. ಆ ವ್ಯಕ್ತಿಯ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಯೆಹೋವನು ಆ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಸ್ವೀಕರಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“ಅವನು ಹೋರಿಯನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ವಧಿಸಬೇಕು. ಬಳಿಕ ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರು ರಕ್ತವನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರವಿರುವ ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಗೆ ತರಬೇಕು; ರಕ್ತವನ್ನು ಸುತ್ತಲೂ ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ಯಾಜಕನು ಆ ಪಶುವಿನ ಚರ್ಮವನ್ನು ಸುಲಿದು, ಪಶುವನ್ನು ತುಂಡುತುಂಡುಗಳಾಗಿ ಕಡಿಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರು ವೇದಿಕೆಯ ಮೇಲೆ ಬೆಂಕಿಯನ್ನಿಟ್ಟು ಅದರ ಮೇಲೆ ಕಟ್ಟಿಗೆಯನ್ನು ಇಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ಆರೋನನ ವಂಶದವರಾದ ಯಾಜಕರು ವೇದಿಕೆಯ ಮೇಲೆ ಬೆಂಕಿಯಲ್ಲಿರುವ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ಪಶುವಿನ ತುಂಡುಗಳನ್ನೂ ತಲೆ ಮತ್ತು ಕೊಬ್ಬನ್ನೂ ಇಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ಯಾಜಕನು ಪಶುವಿನ ಕಾಲುಗಳನ್ನು ಮತ್ತು ಒಳಗಿನ ಭಾಗಗಳನ್ನು ನೀರಿನಿಂದ ತೊಳೆದು ಈ ಎಲ್ಲಾ ಭಾಗಗಳನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಈ ಸರ್ವಾಂಗಹೋಮದ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಿಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ಒಬ್ಬನು ಕುರಿಯನ್ನಾಗಲಿ ಆಡನ್ನಾಗಲಿ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಅರ್ಪಿಸುವಾಗ, ಆ ಪ್ರಾಣಿಯು ಯಾವ ದೋಷವಿಲ್ಲದ ಗಂಡಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ಅವನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅಂದರೆ ವೇದಿಕೆಯ ಉತ್ತರ ಭಾಗದಲ್ಲಿ ಪಶುವನ್ನು ವಧಿಸಬೇಕು. ಬಳಿಕ ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರು ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಸುತ್ತಲೂ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ಬಳಿಕ ಯಾಜಕನು ಆ ಪಶುವನ್ನು ತುಂಡುತುಂಡುಗಳಾಗಿ ಕತ್ತರಿಸಬೇಕು. ಯಾಜಕನು ವೇದಿಕೆಯ ಮೇಲೆ ಬೆಂಕಿಯಲ್ಲಿರುವ ಕಟ್ಟಿಗೆಯ ಮೇಲೆ ತುಂಡುಗಳನ್ನೂ ತಲೆ ಮತ್ತು ಕೊಬ್ಬನ್ನೂ ಇಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ಯಾಜಕನು ಪಶುವಿನ ಕಾಲುಗಳನ್ನೂ ಒಳಗಿನ ಭಾಗಗಳನ್ನೂ ನೀರಿನಿಂದ ತೊಳೆಯಬೇಕು. ಬಳಿಕ ಯಾಜಕನು ಪಶುವಿನ ಈ ಎಲ್ಲಾ ಭಾಗಗಳನ್ನೂ ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಸಮರ್ಪಿಸಲ್ಪಟ್ಟ ಸರ್ವಾಂಗಹೋಮವಾಗಿರುತ್ತದೆ. ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಿಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ಒಬ್ಬನು ಪಕ್ಷಿಯನ್ನು ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಅರ್ಪಿಸುವಾಗ ಆ ಪಕ್ಷಿಯು ಬೆಳೆವಕ್ಕಿಯಾಗಲಿ ಪಾರಿವಾಳದ ಮರಿಯಾಗಲಿ ಆಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ಯಾಜಕನು ಕಾಣಿಕೆಯನ್ನು ವೇದಿಕೆಯ ಬಳಿಗೆ ತರಬೇಕು. ಯಾಜಕನು ಪಕ್ಷಿಯ ಕುತ್ತಿಗೆಯನ್ನು ಮುರಿದು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಪಕ್ಷಿಯ ರಕ್ತವು ವೇದಿಕೆಯ ಪಾರ್ಶ್ವದಲ್ಲಿ ಹಿಂಡಲ್ಪಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ಯಾಜಕನು ಪಕ್ಷಿಯ ಕರುಳುಗಳನ್ನು ಮತ್ತು ಗರಿಗಳನ್ನು ತೆಗೆದು ಅವುಗಳನ್ನು ವೇದಿಕೆಯ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಬಿಸಾಡಬೇಕು. ಈ ಸ್ಥಳವು ವೇದಿಕೆಯಿಂದ ತೆಗೆದ ಬೂದಿಯನ್ನು ಹಾಕುವ ಸ್ಥಳವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ತರುವಾಯ ಯಾಜಕನು ಪಕ್ಷಿಯ ರೆಕ್ಕೆಗಳನ್ನು ಕಿತ್ತುಹಾಕಬೇಕು. ಆದರೆ ಅವನು ಪಕ್ಷಿಯನ್ನು ಎರಡು ಭಾಗಗಳಾಗಿ ವಿಭಾಗಿಸಬಾರದು. ಯಾಜಕನು ಪಕ್ಷಿಯನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಬೆಂಕಿಯಲ್ಲಿರುವ ಕಟ್ಟಿಗೆಗಳ ಮೇಲಿಟ್ಟು ಹೋಮಮಾಡಬೇಕು. ಇದು ಅಗ್ನಿಯ ಮೂಲಕ ಸಮರ್ಪಣೆಯಾದ ಸರ್ವಾಂಗಹೋಮವಾಗಿದೆ. ಅದರ ಸುವಾಸನೆ ಯೆಹೋವನಿಗೆ ಪ್ರಿಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ಒಬ್ಬನು ದೇವರಾದ ಯೆಹೋವನಿಗೆ ಧಾನ್ಯಸಮರ್ಪಣೆ ಮಾಡಬೇಕೆಂದಿದ್ದರೆ, ಅದು ಗೋಧಿಹಿಟ್ಟಾಗಿರಬೇಕು. ಅವನು ಈ ಹಿಟ್ಟಿನ ಮೇಲೆ ಎಣ್ಣೆಯನ್ನು ಹೊಯಿದು, ಧೂಪವನ್ನಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ಬಳಿಕ ಅವನು ಅದನ್ನು ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರ ಬಳಿಗೆ ತರಬೇಕು. ಯಾಜಕನು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹಿಟ್ಟಿನಲ್ಲಿ ಒಂದು ಹಿಡಿ ಹಿಟ್ಟನ್ನೂ ಧೂಪವೆಲ್ಲವನ್ನೂ ತೆಗೆದುಕೊಂಡು ನೈವೇದ್ಯವಾದದ್ದನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ವೇದಿಕೆಯ ಮೇಲೆ ಅದನ್ನು ಹೋಮಮಾಡಬೇಕು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಮಾಡಿದ ಸಮರ್ಪಣೆಯಾಗಿದೆ. ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಿಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ಧಾನ್ಯಸಮರ್ಪಣೆಯಲ್ಲಿ ಉಳಿದ ಭಾಗವು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಸೇರಿದ್ದಾಗಿವೆ. ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಮಾಡಿದ ಈ ಸಮರ್ಪಣೆಯು ಮಹಾಪರಿಶುದ್ಧವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ಒಬ್ಬನು ಒಲೆಯಲ್ಲಿ ಬೇಯಿಸಿದ ಧಾನ್ಯನೈವೇದ್ಯವನ್ನು ಅರ್ಪಿಸಿದರೆ, ಆಗ ಅದು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯಾಗಲಿ ಅಥವಾ ಎಣ್ಣೆ ಹೊಯಿದು ಮಾಡಿದ ಕಡುಬುಗಳಾಗಲಿ ಆಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ನಿಮ್ಮ ಧಾನ್ಯನೈವೇದ್ಯವು ಕಬ್ಬಿಣದ ಹಂಚಿನಲ್ಲಿ ಬೇಯಿಸಲ್ಪಟ್ಟಿದ್ದರೆ, ಅದು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹುಳಿಯಿಲ್ಲದ ಶ್ರೇಷ್ಠ ಹಿಟ್ಟಿನಿಂದ ಮಾಡಿದ್ದಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ನೀವು ಅದನ್ನು ಚೂರುಚೂರುಗಳಾಗಿ ಮುರಿದು ಅದರ ಮೇಲೆ ಎಣ್ಣೆ ಹೊಯ್ಯಬೇಕು. ಅದು ಧಾನ್ಯನೈವೇದ್ಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ನೀವು ಬಾಂಡ್ಲಿಯಲ್ಲಿ ಪಕ್ವಮಾಡಿದ ಪದಾರ್ಥವನ್ನು ಅರ್ಪಿಸಿದರೆ, ಅದು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಶ್ರೇಷ್ಠ ಗೋಧಿಹಿಟ್ಟಿನಿಂದ ಮಾಡಿದ್ದಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“ನೀವು ಈ ವಸ್ತುಗಳಿಂದ ಮಾಡಿದ ಧಾನ್ಯನೈವೇದ್ಯಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸುವುದಾದರೆ ನೀವು ಆ ವಸ್ತುಗಳನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. ಅವನು ಅದನ್ನು ವೇದಿಕೆಯ ಮೇಲಿಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ಬಳಿಕ ಯಾಜಕನು ಧಾನ್ಯನೈವೇದ್ಯದ ಸ್ವಲ್ಪ ಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು ನೈವೇದ್ಯವಾದದ್ದನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡುವನು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಮಾಡಿದ ಸಮರ್ಪಣೆಯಾಗಿದೆ. ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಿಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ಧಾನ್ಯನೈವೇದ್ಯದಲ್ಲಿ ಉಳಿದದ್ದು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಸೇರುವುದು. ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಮಾಡಿದ ಈ ನೈವೇದ್ಯವು ಮಹಾಪರಿಶುದ್ಧವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ನೀವು ಹುಳಿಹಿಟ್ಟಿನಿಂದ ಮಾಡಿದ ಯಾವದನ್ನೂ ಯೆಹೋವನಿಗೆ ಧಾನ್ಯಸಮರ್ಪಣೆಯಾಗಿ ಕೊಡಬಾರದು. ನೀವು ಹುಳಿಯನ್ನಾಗಲಿ ಜೇನುತುಪ್ಪವನ್ನಾಗಲಿ ಯೆಹೋವನಿಗೆ ಅಗ್ನಿಯ ಮೂಲಕ ಹೋಮಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ನೀವು ಹುಳಿಯನ್ನು ಮತ್ತು ಜೇನುತುಪ್ಪವನ್ನು ಪ್ರಥಮಫಲವಾಗಿ ಅರ್ಪಿಸಬಹುದು. ಆದರೆ ಹುಳಿಯನ್ನು ಮತ್ತು ಜೇನುತುಪ್ಪವನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ನೀವು ಅರ್ಪಿಸುವ ಪ್ರತಿ ಧಾನ್ಯಸಮರ್ಪಣೆಯಲ್ಲೂ ಉಪ್ಪನ್ನು ಹಾಕಬೇಕು. ನಿಮ್ಮ ಧಾನ್ಯಸಮರ್ಪಣೆಯಲ್ಲಿ ದೇವರ ಒಡಂಬಡಿಕೆಯೆಂಬ ಉಪ್ಪು ಇರಲೇಬೇಕು. ನೀವು ಅರ್ಪಿಸುವ ನಿಮ್ಮ ಎಲ್ಲಾ ಕಾಣಿಕೆಗಳಲ್ಲಿ ಉಪ್ಪನ್ನು ಸೇರಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ನೀವು ಪ್ರಥಮಫಲವನ್ನು ಯೆಹೋವನಿಗೆ ನೈವೇದ್ಯವಾಗಿ ಅರ್ಪಿಸುವಾಗ ಬೆಂಕಿಯಲ್ಲಿ ಸುಟ್ಟ ಗೋಧಿತೆನೆಗಳನ್ನು ತರಬೇಕು. ಅವುಗಳು ಜಜ್ಜಲ್ಪಟ್ಟ ಹಸಿ ತೆನೆಗಳಾಗಿರಬೇಕು. ಇದು ನಿಮ್ಮ ಪ್ರಥಮಫಲ ನೈವೇದ್ಯವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ನೀವು ಅದಕ್ಕೆ ಎಣ್ಣೆಯನ್ನು ಹಾಕಿ ಅದರ ಮೇಲೆ ಧೂಪವನ್ನಿಡಬೇಕು. ಅದು ಧಾನ್ಯಸಮರ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ಯಾಜಕನು ಜಜ್ಜಿದ ಧಾನ್ಯದಲ್ಲಿ ಒಂದು ಭಾಗವನ್ನೂ ಎಣ್ಣೆಯನ್ನೂ ಎಲ್ಲಾ ಧೂಪವನ್ನೂ ತೆಗೆದುಕೊಂಡು ನೈವೇದ್ಯವಾದದ್ದನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಹೋಮಮಾಡಬೇಕು. ಇದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಿದ ಸಮರ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ಯಾವನಾದರೂ ಸಮಾಧಾನಯಜ್ಞ ಮಾಡಬೇಕಾದರೆ ಅವನು ತನ್ನ ಪಶುಮಂದೆಯಿಂದ ಗಂಡುಪಶುವನ್ನಾಗಲಿ ಹೆಣ್ಣುಪಶುವನ್ನಾಗಲಿ ಅರ್ಪಿಸಬಹುದು. ಯೆಹೋವನ ಎದುರಿನಲ್ಲಿ ಅರ್ಪಿಸಲ್ಪಡುವ ಅದು ಅಂಗದೋಷವಿಲ್ಲದ್ದಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ಆ ವ್ಯಕ್ತಿಯು ತನ್ನ ಕೈಯನ್ನು ಪಶುವಿನ ತಲೆಯ ಮೇಲಿಟ್ಟು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಅದನ್ನು ವಧಿಸಬೇಕು. ಬಳಿಕ ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರು ಆ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಸುತ್ತಲೂ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","ಆ ಯಜ್ಞಪಶುವಿನ ವಪೆಯನ್ನೂ ಕರುಳುಗಳ ಮೇಲಿನ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನೂ ಇವುಗಳ ಮೇಲೆ ಸೊಂಟದಲ್ಲಿರುವ ಕೊಬ್ಬನ್ನೂ ತೆಗೆದು ಪಿತ್ತಕೋಶದ ಹತ್ತಿರ ಮೂತ್ರಪಿಂಡಗಳವರೆಗೆ ಇರುವ ಕೊಬ್ಬನ್ನೂ ತೆಗೆದು ಯೆಹೋವನಿಗೆ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ಬಳಿಕ ಆರೋನನ ಪುತ್ರರು ಕೊಬ್ಬನ್ನು ವೇದಿಕೆಗೆ ತಂದು ಅದನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಕಟ್ಟಿಗೆಯ ಮೇಲಿರುವ ಸರ್ವಾಂಗಹೋಮದ ಮೇಲಿಡಬೇಕು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಅರ್ಪಿಸುವ ಹೋಮವಾಗಿರುತ್ತದೆ. ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಿಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ಒಬ್ಬನು ಕುರಿಯನ್ನಾಗಲಿ ಆಡನ್ನಾಗಲಿ ಯೆಹೋವನಿಗೆ ಸಮಾಧಾನಯಜ್ಞವಾಗಿ ಕೊಡುವಾಗ, ಆ ಪಶುವಿನಲ್ಲಿ ಯಾವ ದೋಷವೂ ಇರಬಾರದು. ಅದು ಗಂಡು ಅಥವಾ ಹೆಣ್ಣಾಗಿರಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ಅವನು ಕುರಿಮರಿಯನ್ನು ಅರ್ಪಿಸುವುದಾದರೆ, ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ಅವನು ತನ್ನ ಕೈಯನ್ನು ಪಶುವಿನ ಮೇಲಿಟ್ಟು ದೇವದರ್ಶನಗುಡಾರದ ಮುಂದೆ ಅದನ್ನು ವಧಿಸಬೇಕು. ತರುವಾಯ ಆರೋನನ ಪುತ್ರರು ಅದರ ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಸುತ್ತಲೂ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ಅವನು ಸಮಾಧಾನಯಜ್ಞ ಪಶುವಿನ ಕೊಬ್ಬನ್ನು ಅಂದರೆ ಬಾಲದ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನು ಕರುಳುಗಳ ಮೇಲಿರುವ ಮತ್ತು ಅವುಗಳ ಸುತ್ತಲಿರುವ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ಅವನು ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನೂ ಇವುಗಳ ಮೇಲೆ ಸೊಂಟದಲ್ಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಪಿತ್ತಕೋಶದ ಮೇಲೆ ಮೂತ್ರಪಿಂಡಗಳವರೆಗೆ ಇರುವ ಕೊಬ್ಬನ್ನೂ ಯಾಜಕನು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಸಮಾಧಾನಯಜ್ಞವನ್ನು ಅರ್ಪಿಸುವ ಕ್ರಮ. ");
INSERT INTO kan2010_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ಅದು ಯೆಹೋವನಿಗೆ ಬೆಂಕಿಯ ಮೂಲಕ ಅರ್ಪಿಸಿದ ಆಹಾರವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ಸಮರ್ಪಿಸಲ್ಪಡುವ ಪಶು ಆಡಾಗಿದ್ದರೆ, ಸಮರ್ಪಿಸುವವನು ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ಅವನು ತನ್ನ ಕೈಯನ್ನು ಆಡಿನ ತಲೆಯ ಮೇಲಿಟ್ಟು ದೇವದರ್ಶನಗುಡಾರದ ಮುಂದೆ ಅದನ್ನು ವಧಿಸಬೇಕು. ಬಳಿಕ ಆರೋನನ ಗಂಡುಮಕ್ಕಳು ಆಡಿನ ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಅದರ ಸುತ್ತಲೂ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ಅವನು ಸಮಾಧಾನಯಜ್ಞದ ಪಶುವಿನ ವಪೆಯನ್ನೂ ಕರುಳುಗಳ ಮೇಲಿರುವ ಎಲ್ಲಾ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನೂ ಇವುಗಳ ಮೇಲೆ ಸೊಂಟದಲ್ಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಪಿತ್ತಾಶಯದ ಹತ್ತಿರ ಮೂತ್ರಪಿಂಡಗಳ ತನಕ ಇರುವ ಕೊಬ್ಬನ್ನೂ ಯೆಹೋವನಿಗೋಸ್ಕರ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ಅವನು ಅದರ ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನು ಮತ್ತು ಸೊಂಟದವರೆಗೆ ಅವುಗಳನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಅವನು ಪಿತ್ತಾಶಯವನ್ನು ಮತ್ತು ಅದನ್ನು ಅವರಿಸಿರುವ ಕೊಬ್ಬನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಅವನು ಮೂತ್ರಪಿಂಡಗಳೊಂದಿಗೆ ಪಿತ್ತಾಶಯವನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ಬಳಿಕ ಯಾಜಕನು ಅವುಗಳನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಇದು ಆಹಾರದ ರೂಪದಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಿದ ಸುವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವ ಸಮಾಧಾನಯಜ್ಞವಾಗಿರುತ್ತದೆ. ಆದರೆ ಅದರ ಕೊಬ್ಬು ಯೆಹೋವನಿಗೆ ಸೇರಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ನಿಮ್ಮ ಎಲ್ಲಾ ಸಂತತಿಗಳವರಿಗೆ ಈ ನಿಯಮವು ಶಾಶ್ವತವಾದದ್ದು. ನೀವೆಲ್ಲೇ ವಾಸಿಸಿದರೂ ಕೊಬ್ಬನ್ನಾಗಲಿ ರಕ್ತವನ್ನಾಗಲಿ ಎಂದಿಗೂ ತಿನ್ನಬಾರದು.” ");
INSERT INTO kan2010_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಮಾತನಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ಯಾವನಾದರೂ ತಿಳಿಯದೆ ಪಾಪಮಾಡಿದರೆ ಮತ್ತು ಮಾಡಬಾರದೆಂದು ಹೇಳಿದವುಗಳನ್ನು ಮಾಡಿದರೆ, ಅವನು ಮಾಡಬೇಕಾದದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ಅಭಿಷಿಕ್ತನಾದ ಯಾಜಕನು ತಪ್ಪುಮಾಡಿ ಜನರೆಲ್ಲರನ್ನು ಅಪರಾಧಕ್ಕೆ ಒಳಪಡಿಸಿದರೆ ತನ್ನ ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಅವನು ಪೂರ್ಣಾಂಗವಾದ ಹೋರಿಯನ್ನು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ಅಭಿಷಿಕ್ತನಾದ ಯಾಜಕನು ಹೋರಿಯನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತಂದು ತನ್ನ ಕೈಯನ್ನು ಅದರ ತಲೆಯ ಮೇಲಿಟ್ಟು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅದನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ಬಳಿಕ ಅವನು ಹೋರಿಯ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನಗುಡಾರದೊಳಗೆ ಹೋಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ಯಾಜಕನು ತನ್ನ ಬೆರಳನ್ನು ರಕ್ತದಲ್ಲಿ ಅದ್ದಿ ಮಹಾಪವಿತ್ರಸ್ಥಳದ ಪರದೆಯ ಮುಂಭಾಗದಲ್ಲಿರುವ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಏಳು ಸಾರಿ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ಯಾಜಕನು ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ಧೂಪವೇದಿಕೆಯ ಮೂಲೆಗಳಿಗೆ ಹಚ್ಚಬೇಕು. (ಈ ವೇದಿಕೆಯು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿದೆ.) ಯಾಜಕನು ಹೋರಿಯ ರಕ್ತವನ್ನೆಲ್ಲಾ ಸರ್ವಾಂಗಹೋಮ ಮಾಡುವ ವೇದಿಕೆಯ ಬುಡದಲ್ಲಿ ಸುರಿಯಬೇಕು. (ಈ ವೇದಿಕೆಯು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಇರುತ್ತದೆ.) ");
INSERT INTO kan2010_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ಅವನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ತಂದಿರುವ ಹೋರಿಯ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ತೆಗೆಯಬೇಕು. ಅವನು ಅದರ ಒಳಗಿನ ಭಾಗಗಳ ಮೇಲೆ ಮತ್ತು ಅವುಗಳ ಸುತ್ತಲೂ ಇರುವ ಕೊಬ್ಬನ್ನೂ ");
INSERT INTO kan2010_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ಅದರ ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನೂ ಅವುಗಳ ಸೊಂಟದವರೆಗೆ ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೂ ಪಿತ್ತಾಶಯವನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೂ ತೆಗೆಯಬೇಕು. ಅವನು ಮೂತ್ರಪಿಂಡಗಳೊಡನೆ ಪಿತ್ತಾಶಯವನ್ನೂ ತೆಗೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ಯಾಜಕನು ಈ ಭಾಗಗಳನ್ನು ಸಮಾಧಾನಯಜ್ಞ ಸಮರ್ಪಣೆಯಲ್ಲಿ ಹೋರಿಯ ಭಾಗಗಳನ್ನು ಅರ್ಪಿಸುವ ರೀತಿಯಲ್ಲಿಯೇ ಅರ್ಪಿಸಬೇಕು. ಯಾಜಕನು ಪಶುವಿನ ಭಾಗಗಳನ್ನು ಸರ್ವಾಂಗಹೋಮಮಾಡುವ ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","ಆದರೆ ಯಾಜಕನು ಹೋರಿಯ ಚರ್ಮವನ್ನು, ಒಳಗಿನ ಭಾಗಗಳನ್ನು, ದೇಹದ ಕಲ್ಮಶವನ್ನು, ಎಲ್ಲಾ ಮಾಂಸವನ್ನು ಮತ್ತು ತಲೆಕಾಲುಗಳನ್ನು ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಪಾಳೆಯದ ಹೊರಗೆ ಬೂದಿಯನ್ನು ಸುರಿಯುವ ವಿಶೇಷ ಸ್ಥಳಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಕಟ್ಟಿಗೆಯ ಮೇಲಿಟ್ಟು ಬೆಂಕಿಯಲ್ಲಿ ಸುಟ್ಟುಹಾಕಬೇಕು. ಬೂದಿಯನ್ನು ಸುರಿಯುವ ಸ್ಥಳದಲ್ಲಿಯೇ ಅದನ್ನು ಸುಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ಇಸ್ರೇಲರ ಇಡೀ ಜನಾಂಗವೆಲ್ಲಾ ತಿಳಿಯದೆ ಪಾಪಮಾಡುವ ಸ್ಥಿತಿ ಸಂಭವಿಸಬಹುದು. ಯೆಹೋವನು ಮಾಡಬಾರದೆಂದು ಆಜ್ಞಾಪಿಸಿದವುಗಳಲ್ಲಿ ಯಾವುದಾದರೊಂದನ್ನು ಅವರು ಮಾಡಿದರೆ ಅವರು ದೋಷಿಗಳಾಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ಆ ಪಾಪದ ಕುರಿತು ಅವರಿಗೆ ತಿಳಿದುಬಂದರೆ ಆಗ ಅವರು ಒಂದು ಹೋರಿಯನ್ನು ಇಡೀ ಜನಾಂಗದ ಪಾಪಪರಿಹಾರ ಮಾಡುವ ಸಮರ್ಪಣೆಯಾಗಿ ಅರ್ಪಿಸಬೇಕು. ಅವರು ಹೋರಿಯನ್ನು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ಜನರ ಹಿರಿಯರು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ತಮ್ಮ ಕೈಗಳನ್ನು ಹೋರಿಯ ತಲೆಯ ಮೇಲಿಡಬೇಕು. ತರುವಾಯ ಒಬ್ಬನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಹೋರಿಯನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ಬಳಿಕ ಅಭಿಷಿಕ್ತನಾದ ಯಾಜಕನು ಹೋರಿಯ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನಗುಡಾರದೊಳಗೆ ಹೋಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ಯಾಜಕನು ತನ್ನ ಬೆರಳನ್ನು ರಕ್ತದಲ್ಲಿ ಅದ್ದಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ತೆರೆಯ ಮುಂದೆ ಏಳು ಸಾರಿ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ಬಳಿಕ ಯಾಜಕನು ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ವೇದಿಕೆಯ ಮೂಲೆಗಳಲ್ಲಿ ಹಾಕಬೇಕು. (ಈ ವೇದಿಕೆಯು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಇರುತ್ತದೆ.) ಯಾಜಕನು ರಕ್ತವನ್ನೆಲ್ಲಾ ಸರ್ವಾಂಗಹೋಮ ಮಾಡುವ ವೇದಿಕೆಯ ಬುಡದಲ್ಲಿ ಸುರಿದುಬಿಡಬೇಕು. (ಈ ವೇದಿಕೆಯು ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಇರುತ್ತದೆ.) ");
INSERT INTO kan2010_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ತರುವಾಯ ಯಾಜಕನು ಪಶುವಿನಿಂದ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ತೆಗೆದು ಅದನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ಯಾಜಕನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದ ಹೋರಿಯ ಭಾಗಗಳನ್ನು ಸಮರ್ಪಿಸಿದಂತೆಯೇ ಈ ಭಾಗಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಈ ರೀತಿಯಾಗಿ, ಯಾಜಕನು ಜನರಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ಆಗ ದೇವರು ಅವರನ್ನು ಕ್ಷಮಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ಯಾಜಕನು ಈ ಹೋರಿಯನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ, ಆ ಮೊದಲನೆಯ ಹೋರಿಯನ್ನು ಸುಟ್ಟುಹಾಕಿದ ಸ್ಥಳದಲ್ಲಿಯೇ ಅದನ್ನು ಸುಡಬೇಕು. ಇದು ಇಡೀ ಸಮೂಹದ ಪಾಪವನ್ನು ಪರಿಹಾರ ಮಾಡುವ ಸಮರ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ಒಬ್ಬ ಅಧಿಪತಿಯು ತನ್ನ ದೇವರಾಗಿರುವ ಯೆಹೋವನು ನಿಷೇಧಿಸಿದವುಗಳಲ್ಲಿ ಯಾವುದಾದರೊಂದನ್ನು ತಿಳಿಯದೆ ಮಾಡಿದರೆ ಅವನು ದೋಷಿಯಾಗುತ್ತಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ಅಧಿಪತಿಯು ತನ್ನ ಪಾಪದ ಕುರಿತು ತಿಳಿದುಕೊಂಡರೆ, ಅಂಗದೋಷವಿಲ್ಲದ ಹೋತವನ್ನು ತರಬೇಕು. ಅದು ಅವನ ಕಾಣಿಕೆಯಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ಅಧಿಪತಿಯು ತನ್ನ ಕೈಯನ್ನು ಹೋತದ ತಲೆಯ ಮೇಲಿಟ್ಟು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸರ್ವಾಂಗಹೋಮ ಪಶುಗಳನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಅದನ್ನು ವಧಿಸಬೇಕು. ಅದು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ಯಾಜಕನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತನ್ನ ಬೆರಳಿನಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಸರ್ವಾಂಗಹೋಮಮಾಡುವ ವೇದಿಕೆಯ ಮೂಲೆಗಳಿಗೆ ಹಚ್ಚಬೇಕು. ಯಾಜಕನು ಉಳಿದ ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಬುಡದಲ್ಲಿ ಸುರಿದು, ");
INSERT INTO kan2010_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ಹೋತದ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಅದು ಸಮಾಧಾನಯಜ್ಞವಾಗಿದೆ. ಕೊಬ್ಬನ್ನು ಹೋಮಮಾಡುವಂತೆ ಅದನ್ನು ಹೋಮಮಾಡಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಅಧಿಪತಿಯನ್ನು ಶುದ್ಧಗೊಳಿಸುವನು. ಆಗ ದೇವರು ಆ ಅಧಿಪತಿಯನ್ನು ಕ್ಷಮಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ಸಾಮಾನ್ಯ ಜನರಲ್ಲಿ ಒಬ್ಬನು ಯೆಹೋವನು ನಿಷೇಧಿಸಿದವುಗಳಲ್ಲಿ ಯಾವುದಾದರೊಂದನ್ನು ತಿಳಿಯದೆ ಮಾಡಿದರೆ ಅವನು ದೋಷಿಯಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ಆ ವ್ಯಕ್ತಿ ತನ್ನ ಪಾಪದ ಕುರಿತು ತಿಳಿದುಕೊಂಡರೆ, ಆಗ ಅವನು ಅಂಗದೋಷವಿಲ್ಲದ ಒಂದು ಆಡನ್ನು ತರಬೇಕು. ಅದು ಅವನ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿದೆ. ಅವನು ತಾನು ಮಾಡಿದ ಪಾಪಕ್ಕಾಗಿ ಆಡನ್ನು ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ಅವನು ತನ್ನ ಕೈಯನ್ನು ಅದರ ತಲೆಯ ಮೇಲಿಟ್ಟು ಸರ್ವಾಂಗಹೋಮಮಾಡುವ ಸ್ಥಳದಲ್ಲಿ ಅದನ್ನು ವಧಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ಬಳಿಕ ಯಾಜಕನು ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತನ್ನ ಬೆರಳಿನಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಸರ್ವಾಂಗಹೋಮ ಮಾಡುವ ವೇದಿಕೆಯ ಮೂಲೆಗಳಿಗೆ ಹಚ್ಚಬೇಕು. ಬಳಿಕ ಯಾಜಕನು ಆಡಿನ ಉಳಿದ ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಬುಡದಲ್ಲಿ ಸುರಿಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ಯಾಜಕನು ಸಮಾಧಾನಯಜ್ಞಗಳಲ್ಲಿ ಕೊಬ್ಬನ್ನು ಪ್ರತ್ಯೇಕಿಸಿದಂತೆಯೇ ಆಡಿನ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಪ್ರತ್ಯೇಕಿಸಿ ಅದನ್ನು ಯೆಹೋವನಿಗೆ ಸುಗಂಧವಾಸನೆಯ ಹೋಮವಾಗಿ ವೇದಿಕೆಯ ಮೇಲೆ ಅರ್ಪಿಸಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಶುದ್ಧಿಗೊಳಿಸುವನು. ಆಗ ದೇವರು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಕ್ಷಮಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ಆ ವ್ಯಕ್ತಿಯು ಕುರಿಮರಿಯನ್ನು ತನ್ನ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ತರುವುದಾದರೆ ಅದು ದೋಷವಿಲ್ಲದ ಹೆಣ್ಣು ಕುರಿಮರಿಯಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ಅವನು ತನ್ನ ಕೈಯನ್ನು ಅದರ ತಲೆಯ ಮೇಲಿಟ್ಟು ಅದನ್ನು ಸರ್ವಾಂಗಹೋಮದ ಯಜ್ಞಪಶುಗಳನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲಿ ಪಾಪಪರಿಹಾರಕಯಜ್ಞವಾಗಿ ವಧಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ಯಾಜಕನು ಪಾಪಪರಿಹಾರಕಯಜ್ಞದ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತನ್ನ ಬೆರಳಿನಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಸರ್ವಾಂಗಹೋಮ ಮಾಡುವ ವೇದಿಕೆಯ ಮೂಲೆಗಳಿಗೆ ಹಚ್ಚಬೇಕು. ಬಳಿಕ ಯಾಜಕನು ಕುರಿಮರಿಯ ರಕ್ತವನ್ನೆಲ್ಲಾ ವೇದಿಕೆಯ ಬುಡದಲ್ಲಿ ಸುರಿಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ಯಾಜಕನು ಸಮಾಧಾನಯಜ್ಞಗಳಲ್ಲಿ ಕುರಿಮರಿಯ ಕೊಬ್ಬನ್ನು ಪ್ರತ್ಯೇಕಿಸಿದಂತೆಯೇ ಈ ಕುರಿಮರಿಯ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಪ್ರತ್ಯೇಕಿಸಿ ಅದನ್ನು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸುವ ಸಮರ್ಪಣೆಯಂತೆ ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅವನು ಮಾಡಿದ ಪಾಪದಿಂದ ಶುದ್ಧಿಗೊಳಿಸುವನು. ಆಗ ದೇವರು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಕ್ಷಮಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ನ್ಯಾಯಾಧಿಕಾರಿಯು ತಿಳಿಸಬೇಕೆಂದು ಕೇಳಿದರೂ ಒಬ್ಬನು ತಾನು ಕಂಡದ್ದನ್ನಾಗಲಿ ಕೇಳಿದ್ದನ್ನಾಗಲಿ ತಿಳಿಸದೆ ಹೋದರೆ ಅವನು ಪಾಪಕ್ಕೆ ಗುರಿಯಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ಯಾವನಾದರೂ ಅಶುದ್ಧವಾದ ಕಾಡುಮೃಗ, ಪಶು, ಜಂತು ಇವುಗಳ ಹೆಣವನ್ನಾಗಲಿ ಅಥವಾ ಬೇರೆ ಯಾವ ಅಶುದ್ಧ ವಸ್ತುವನ್ನಾಗಲಿ ಮುಟ್ಟಿದರೆ ತಾನು ಮುಟ್ಟಿದ್ದು ತಿಳಿಯದಿದ್ದರೂ ಅವನು ಅಶುದ್ಧನೂ ದೋಷಿಯೂ ಆಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ಒಬ್ಬನು ಮತ್ತೊಬ್ಬನ ದೇಹದೊಳಗಿಂದ ಬರುವ ಯಾವುದಾದರೂ ಅಶುದ್ಧ ವಸ್ತುವನ್ನು ತಿಳಿಯದೆ ಮುಟ್ಟಿದರೂ, ತಿಳಿದುಬಂದಾಗ ಅವನು ದೋಷಿಯಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ಒಬ್ಬನು ಆಲೋಚಿಸದೆ ಒಳ್ಳೆಯದಕ್ಕಾಗಲಿ ಕೆಟ್ಟದಕ್ಕಾಗಲಿ ಮಾತುಕೊಟ್ಟು ಮರೆತುಬಿಟ್ಟರೆ, ಅದು ಅವನ ನೆನಪಿಗೆ ಬಂದಾಗ ಅವನು ದೋಷಿಯಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ಈ ವಿಷಯಗಳಲ್ಲಿ ಯಾವುದಾದರೊಂದರಲ್ಲಿ ದೋಷಿಯಾದರೆ, ಅವನು ತನ್ನ ತಪ್ಪನ್ನು ಒಪ್ಪಿಕೊಂಡು ಅರಿಕೆ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ಅವನು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಹೆಣ್ಣು ಕುರಿಮರಿಯನ್ನಾಗಲಿ ಹೆಣ್ಣು ಮೇಕೆಯನ್ನಾಗಲಿ ಯಜ್ಞವಾಗಿ ಸಮರ್ಪಿಸಬೇಕು. ಯಾಜಕನು ಅವನಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ಅವನು ಕುರಿಮರಿಯನ್ನು ಕೊಡುವುದಕ್ಕೆ ಶಕ್ತನಾಗಿಲ್ಲದಿದ್ದರೆ, ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತಂದು ಅವುಗಳಲ್ಲಿ ಒಂದನ್ನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನಾಗಿಯೂ ಇನ್ನೊಂದನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿಯೂ ಸಮರ್ಪಿಸಬೇಕು. ತಿಳಿಯದೆ ಮಾಡುವ ಪಾಪಗಳು ");
INSERT INTO kan2010_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ಅವನು ಅವುಗಳನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ಯಾಜಕನು ಮೊದಲು ಒಂದು ಪಕ್ಷಿಯನ್ನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನಾಗಿ ಅರ್ಪಿಸುವನು. ಯಾಜಕನು ಪಕ್ಷಿಯ ಕುತ್ತಿಗೆಯನ್ನು ಮುರಿಯುವನು. ಆದರೆ ಯಾಜಕನು ಪಕ್ಷಿಯನ್ನು ಎರಡು ಭಾಗಗಳನ್ನಾಗಿ ವಿಭಾಗಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ಯಾಜಕನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದಿಂದ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಕೆಯ ಬದಿಯಲ್ಲಿ ಚಿಮಿಕಿಸಬೇಕು. ಬಳಿಕ ಯಾಜಕನು ಉಳಿದ ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಬುಡದಲ್ಲಿ ಸುರಿಯಬೇಕು. ಅದು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ತರುವಾಯ ಯಾಜಕನು ಎರಡನೆಯ ಪಕ್ಷಿಯನ್ನು ಸರ್ವಾಂಗಹೋಮದ ವಿಧಿಗಳಿಗನುಸಾರವಾಗಿ ಅರ್ಪಿಸಬೇಕು. ಈ ರೀತಿಯಾಗಿ, ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅವನು ಮಾಡಿದ ಪಾಪದಿಂದ ಶುದ್ಧಿಗೊಳಿಸುವನು. ಆಗ ದೇವರು ಅವನನ್ನು ಕ್ಷಮಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತರುವುದಕ್ಕೆ ಅವನು ಶಕ್ತನಾಗಿಲ್ಲದಿದ್ದರೆ, ಆಗ ಅವನು ಎಂಟು ಬಟ್ಟಲು ಶ್ರೇಷ್ಠ ಗೋಧಿಹಿಟ್ಟನ್ನು ತರಬೇಕು. ಇದು ಅವನ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿರುವುದು. ಅವನು ಹಿಟ್ಟಿಗೆ ಎಣ್ಣೆಯನ್ನು ಹಾಕಬಾರದು. ಅವನು ಅದರ ಮೇಲೆ ಸುಗಂಧ ಧೂಪವನ್ನು ಇಡಬಾರದು, ಯಾಕೆಂದರೆ ಅದು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ಅವನು ಹಿಟ್ಟನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ಯಾಜಕನು ಒಂದು ಹಿಡಿಹಿಟ್ಟನ್ನು ಅದರಿಂದ ತೆಗೆದು ದೇವಾರ್ಪಿತವಾಯಿತೆಂದು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡುವನು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಿದ ಸಮರ್ಪಣೆಯಾಗಿರುವುದು. ಅದು ಪಾಪಪರಿಹಾರಕ ಸಮರ್ಪಣೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ಹೀಗೆ ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅವನ ದೋಷಗಳಿಂದ ಶುದ್ಧೀಕರಿಸುವನು. ಆಗ ದೇವರು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಕ್ಷಮಿಸುವನು. ಧಾನ್ಯನೈವೇದ್ಯದಲ್ಲಿರುವಂತೆಯೇ ಯಜ್ಞದಲ್ಲಿ ಉಳಿದ ಭಾಗವು ಯಾಜಕನಿಗೆ ಸೇರಿದೆ. ಧಾನ್ಯಸಮರ್ಪಣೆಯಲ್ಲಿಯೂ ಉಳಿದ ಭಾಗವು ಯಾಜಕನಿಗೆ ಸೇರಿದೆ.” ");
INSERT INTO kan2010_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ಒಬ್ಬನು ಯೆಹೋವನ ಪರಿಶುದ್ಧ ವಸ್ತುಗಳ ವಿಷಯದಲ್ಲಿ ಮೀರಿ ನಡೆದು ತಿಳಿಯದೆ ತಪ್ಪು ಮಾಡಿದರೆ ಅವನು ಅಂಗದೋಷವಿಲ್ಲದ ಟಗರನ್ನು ತರಬೇಕು. ಇದು ಅವನಿಗಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಣೆಯಾಗುವ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞ. ನೀವು ಅಧಿಕೃತ ಅಳತೆಯನ್ನು ಉಪಯೋಗಿಸಿ ಟಗರಿನ ಬೆಲೆಯನ್ನು ಗೊತ್ತುಮಾಡಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ಆ ವ್ಯಕ್ತಿಯೂ ಪರಿಶುದ್ಧ ವಸ್ತುಗಳ ವಿಷಯದಲ್ಲಿ ಮಾಡಿದ ಪಾಪಕ್ಕಾಗಿ ಈ ಬೆಲೆಯನ್ನು ತೆರಬೇಕು. ಇದಲ್ಲದೆ ಆ ಬೆಲೆಯ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಸೇರಿಸಿ ಆ ಹಣವನ್ನು ಯಾಜಕನಿಗೆ ಕೊಡಬೇಕು. ಈ ರೀತಿಯಾಗಿ ಯಾಜಕನು ಟಗರನ್ನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸುವುದರ ಮೂಲಕ ಅವನನ್ನು ಶುದ್ಧಿಮಾಡುವನು. ಆಗ ದೇವರು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಕ್ಷಮಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ಯಾವನಾದರೂ ಯೆಹೋವನು ನಿಷೇಧಿಸಿದ ಕಾರ್ಯಗಳಲ್ಲಿ ಯಾವುದಾದರೊಂದನ್ನು ಮಾಡಿ ದೋಷಕ್ಕೆ ಗುರಿಯಾಗಿದ್ದರೆ, ಅದು ಅವನಿಗೆ ತಿಳಿದಿಲ್ಲದಿದ್ದರೂ ಅವನು ಆ ಪಾಪಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ಅವನು ಅಂಗದೋಷವಿಲ್ಲದ ಮತ್ತು ಸರಿಯಾದ ಬೆಲೆಬಾಳುವ ಟಗರನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ಟಗರು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿರುವುದು. ಹೀಗೆ ಯಾಜಕನು ತಿಳಿಯದೆ ಮಾಡಿದ ಪಾಪದಿಂದ ಅವನನ್ನು ಶುದ್ಧಮಾಡುವನು. ಆಗ ದೇವರು ಅವನನ್ನು ಕ್ಷಮಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ಅವನು ದೋಷಿಯಾದ್ದರಿಂದ ಯೆಹೋವನಿಗೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಸಮರ್ಪಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ಯಾವನಾದರೂ ಮತ್ತೊಬ್ಬನಿಂದ ತನ್ನ ವಶಕ್ಕೆ ಕೊಡಲ್ಪಟ್ಟ ವಸ್ತುವಿನ ವಿಷಯದಲ್ಲಾಗಲಿ ತನ್ನ ಬಳಿಯಲ್ಲಿ ಅಡವು ಇಟ್ಟ ವಸ್ತುವಿನ ವಿಷಯದಲ್ಲಾಗಲಿ ತಾನು ಮಾಡಿದ ಕಳುವಿನ ವಿಷಯದಲ್ಲಾಗಲಿ ಸುಳ್ಳಾಡುವುದರಿಂದಾಗಲಿ ಮತ್ತೊಬ್ಬನನ್ನು ಮೋಸಗೊಳಿಸುವುದರಿಂದಾಗಲಿ ");
INSERT INTO kan2010_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ಮತ್ತೊಬ್ಬನು ಕಳೆದುಕೊಂಡದ್ದನ್ನು ಕಂಡುಕೊಂಡು ಅದರ ಬಗ್ಗೆ ಸುಳ್ಳು ಹೇಳುವುದರಿಂದಾಗಲಿ ಮಾಡಿದ ಪ್ರಮಾಣವನ್ನು ಉಲ್ಲಂಘಿಸುವುದರಿಂದಾಗಲಿ ಪಾಪಮಾಡಿ ಯೆಹೋವನಿಗೆ ದ್ರೋಹಮಾಡಿದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ಅವನು ತಾನು ಕದ್ದದ್ದನ್ನಾಗಲಿ ಮೋಸದಿಂದ ತೆಗೆದುಕೊಂಡದ್ದನ್ನಾಗಲಿ ಅಡವು ಇಟ್ಟುಕೊಂಡದ್ದನ್ನಾಗಲಿ ಕಂಡುಕೊಂಡ ಅಥವಾ ಕಳೆದುಹೋದ ವಸ್ತುವನ್ನಾಗಲಿ ");
INSERT INTO kan2010_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ಸುಳ್ಳಾಣೆ ಇಟ್ಟುಕೊಂಡ ವಸ್ತುವನ್ನಾಗಲಿ ಸಂಪೂರ್ಣವಾಗಿ ತಂದುಕೊಡಬೇಕು. ಅದರೊಂದಿಗೆ ಅದರ ಐದನೆಯ ಒಂದಂಶವನ್ನು ಹೆಚ್ಚಾಗಿ ತಂದುಕೊಡಬೇಕು. ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸುವ ದಿನದಲ್ಲಿಯೇ ನಿಜವಾದ ಯಜಮಾನನಿಗೆ ಇದನ್ನು ತಂದುಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ಆ ವ್ಯಕ್ತಿ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ಅದು ಮಂದೆಯಿಂದ ತಂದ ಟಗರಾಗಿರಬೇಕು. ಟಗರಿನಲ್ಲಿ ಯಾವ ದೋಷವೂ ಇರಬಾರದು. ಅದು ಯಾಜಕನು ಹೇಳುವ ಬೆಲೆಯುಳ್ಳದ್ದಾಗಿರಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ಬಳಿಕ ಯಾಜಕನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಹೋಗಿ ಅವನನ್ನು ಶುದ್ಧಿಮಾಡುವನು. ಆಗ ದೇವರು ಅವನನ್ನು ಕ್ಷಮಿಸುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಈ ಅಪ್ಪಣೆಯನ್ನು ಕೊಡು: ಸರ್ವಾಂಗಹೋಮದ ನಿಯಮ ಇದಾಗಿದೆ. ಸರ್ವಾಂಗಹೋಮವು ವೇದಿಕೆಯ ಒಲೆಯಲ್ಲಿ ರಾತ್ರಿಯೆಲ್ಲಾ ಮರುದಿನ ಮುಂಜಾನೆಯವರೆಗೆ ಉರಿಯುತ್ತಿರಬೇಕು. ವೇದಿಕೆಯಲ್ಲಿ ಬೆಂಕಿಯು ಉರಿಯುತ್ತಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ಯಾಜಕನು ತನ್ನ ನಾರಿನ ನಿಲುವಂಗಿಯನ್ನೂ ನಾರಿನ ಚಡ್ಡಿಯನ್ನೂ ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ಯಾಜಕನು ಸರ್ವಾಂಗಹೋಮ ಮಾಡಿದಾಗ ಬೆಂಕಿಯಿಂದ ಉಂಟಾದ ಬೂದಿಯನ್ನು ತೆಗೆದು ವೇದಿಕೆಯ ಬಳಿಯಲ್ಲಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ಬಳಿಕ ಯಾಜಕನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೆಗೆದುಹಾಕಿ ಬೇರೆ ಬಟ್ಟೆಗಳನ್ನು ಧರಿಸಿಕೊಂಡು ಬೂದಿಯನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಒಂದು ವಿಶೇಷ ಸ್ಥಳಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ಆದರೆ ವೇದಿಕೆಯ ಮೇಲೆ ಬೆಂಕಿ ಉರಿಯುತ್ತಲೇ ಇರಬೇಕು. ಅದನ್ನು ಆರಿ ಹೋಗುವುದಕ್ಕೆ ಬಿಡಬಾರದು, ಯಾಜಕನು ಪ್ರತಿ ಮುಂಜಾನೆ ವೇದಿಕೆಯ ಮೇಲೆ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಸಿದ್ಧಪಡಿಸಿ, ಸಮಾಧಾನಯಜ್ಞದ ಕೊಬ್ಬನ್ನು ಸುಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ಬೆಂಕಿಯು ವೇದಿಕೆಯ ಮೇಲೆ ಉರಿಯುತ್ತಲೇ ಇರಬೇಕು; ಆರಿಹೋಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ಇದು ಧಾನ್ಯಸಮರ್ಪಣೆಯ ನಿಯಮವಾಗಿದೆ: ಆರೋನನ ಪುತ್ರರು ಅದನ್ನು ಸಮರ್ಪಿಸಲು ಯಜ್ಞವೇದಿಕೆಯ ಮುಂಭಾಗದಲ್ಲಿ ಯೆಹೋವನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ಯಾಜಕನು ಧಾನ್ಯನೈವೇದ್ಯದಿಂದ ಒಂದು ಹಿಡಿ ಶ್ರೇಷ್ಠ ಹಿಟ್ಟನ್ನು ಮತ್ತು ಎಣ್ಣೆಯನ್ನು ಮತ್ತು ಎಲ್ಲಾ ಧೂಪವನ್ನು ತೆಗೆದುಕೊಂಡು ನೈವೇದ್ಯವಾದದ್ದನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಅದನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಸುಡಬೇಕು. ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಿಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರು ಧಾನ್ಯನೈವೇದ್ಯದಲ್ಲಿ ಉಳಿದದ್ದನ್ನು ತಿನ್ನಬೇಕು. ಅವರು ಆ ಹಿಟ್ಟಿನಿಂದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಿಸಿಕೊಂಡು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಅಂದರೆ ದೇವದರ್ಶನಗುಡಾರದ ಸುತ್ತಲಿರುವ ಅಂಗಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ಹುಳಿ ಕಲಸಿ ರೊಟ್ಟಿ ಸುಡಬಾರದು. ನನಗೆ ಅಗ್ನಿಯ ಮೂಲಕ ಹೋಮವಾಗಿ ಅರ್ಪಿಸಿದ ಸಮರ್ಪಣೆಗಳಲ್ಲಿ ನಾನು ಅದನ್ನು ಯಾಜಕರ ಪಾಲನ್ನಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ಅದು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದಂತೆಯೂ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದಂತೆಯೂ ಮಹಾ ಪವಿತ್ರವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ಆರೋನನ ವಂಶದವರಾದ ಗಂಡಸರೆಲ್ಲರೂ ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಿದ ಸಮರ್ಪಣೆಗಳನ್ನು ತಿನ್ನಬಹುದು. ಇದು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಶಾಶ್ವತವಾದ ನಿಯಮವಾಗಿದೆ. ಈ ಕಾಣಿಕೆಗಳಿಗೆ ತಗಲಿದ್ದೆಲ್ಲಾ ಪವಿತ್ರವಾಗುತ್ತವೆ.” ");
INSERT INTO kan2010_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ಆರೋನನ ನಂತರ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತರಬೇಕಾದ ಧಾನ್ಯಸಮರ್ಪಣೆ ಇದಾಗಿದೆ. ಅವರು ಮಹಾಯಾಜಕರಾಗಿ ಅಭಿಷೇಕಿಸಲ್ಪಡುವ ದಿನದಲ್ಲಿ ಇದನ್ನು ಮಾಡಬೇಕು. ಅವರು ಎಂಟು ಬಟ್ಟಲು ಶ್ರೇಷ್ಠ ಗೋಧಿಹಿಟ್ಟನ್ನು ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ತರಬೇಕು. (ದಿನನಿತ್ಯದ ನೈವೇದ್ಯಗಳ ಸಮಯಗಳಲ್ಲಿ ಇದನ್ನು ಅರ್ಪಿಸಬೇಕು.) ಅವರು ಇದರಲ್ಲಿ ಅರ್ಧದಷ್ಟನ್ನು ಮುಂಜಾನೆಯಲ್ಲಿ ಮತ್ತು ಉಳಿದರ್ಧವನ್ನು ಸಾಯಂಕಾಲದಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ಶ್ರೇಷ್ಠವಾದ ಗೋಧಿಹಿಟ್ಟಿಗೆ ಎಣ್ಣೆಯನ್ನು ಬೆರೆಸಿ ಕಬ್ಬಿಣದ ಹಂಚಿನ ಮೇಲೆ ರೊಟ್ಟಿ ಸುಡಬೇಕು. ಅದನ್ನು ಬೇಯಿಸಿದ ಮೇಲೆ ನೀವು ಅದನ್ನು ಒಳಗೆ ತರಬೇಕು. ನೀವು ಈ ಸಮರ್ಪಣೆಯನ್ನು ತುಂಡುತುಂಡಾಗಿ ಮುರಿದು ಸಮರ್ಪಿಸಬೇಕು. ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಿಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","“ಆರೋನನ ಸ್ಥಾನವನ್ನು ಹೊಂದುವುದಕ್ಕಾಗಿ ಆರೋನನ ಸಂತತಿಯವರಲ್ಲಿ ಆರಿಸಲ್ಪಟ್ಟು ಅಭಿಷೇಕಿಸಲ್ಪಟ್ಟ ಯಾಜಕನು ಯೆಹೋವನಿಗೆ ಈ ಧಾನ್ಯಸಮರ್ಪಣೆಯನ್ನು ಮಾಡಬೇಕು. ಈ ನಿಯಮ ಶಾಶ್ವತವಾದದ್ದು. ಧಾನ್ಯಸಮರ್ಪಣೆಯು ಸಂಪೂರ್ಣವಾಗಿ ಹೋಮವಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ಯಾಜಕನ ಪ್ರತಿಯೊಂದು ಧಾನ್ಯಸಮರ್ಪಣೆಯು ಸಂಪೂರ್ಣವಾಗಿ ಹೋಮವಾಗಬೇಕು. ಅದನ್ನು ತಿನ್ನಲೇಬಾರದು.” ");
INSERT INTO kan2010_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“ಆರೋನನಿಗೆ ಮತ್ತು ಅವನ ಪುತ್ರರಿಗೆ ಹೀಗೆ ಹೇಳು: ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದ ಕಟ್ಟಳೆ ಇದಾಗಿದೆ. ಸರ್ವಾಂಗಹೋಮ ಪಶುವು ವಧಿಸಲ್ಪಡುವ ಸ್ಥಳದಲ್ಲಿಯೇ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಪಶುವು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ವಧಿಸಲ್ಪಡಬೇಕು. ಅದು ಮಹಾ ಪವಿತ್ರವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸುವ ಯಾಜಕನು ಅದನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಅಂದರೆ ದೇವದರ್ಶನಗುಡಾರದ ಸುತ್ತಲಿರುವ ಅಂಗಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದ ಮಾಂಸವು ತಗಲಿದ ವಸ್ತುವೂ ಪವಿತ್ರವಾಗುತ್ತದೆ; ಮುಟ್ಟುವ ವ್ಯಕ್ತಿಯೂ ಪವಿತ್ರವಾಗುವನು. “ಚಿಮಿಕಿಸಲ್ಪಟ್ಟ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪ ರಕ್ತವು ಯಾರ ಬಟ್ಟೆಯ ಮೇಲಾದರೂ ಬಿದ್ದರೆ, ನೀವು ಆ ಬಟ್ಟೆಗಳನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಮಣ್ಣಿನ ಮಡಕೆಯಲ್ಲಿ ಬೇಯಿಸಿದರೆ, ಆ ಮಡಕೆಯನ್ನು ಒಡೆದುಹಾಕಬೇಕು. ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ತಾಮ್ರದ ಪಾತ್ರೆಯಲ್ಲಿ ಬೇಯಿಸಿದರೆ, ಆ ಪಾತ್ರೆಯನ್ನು ಉಜ್ಜಿ ನೀರಿನಲ್ಲಿ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“ಯಾಜಕನ ಕುಟುಂಬದಲ್ಲಿರುವ ಯಾವ ಪುರುಷನಾದರೂ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದ ಮಾಂಸವನ್ನು ತಿನ್ನಬಹುದು. ಅದು ಬಹಳ ಪವಿತ್ರವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ಆದರೆ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದ ರಕ್ತವನ್ನು ದೇವದರ್ಶನಗುಡಾರದೊಳಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ, ಜನರನ್ನು ಶುದ್ಧಿಗೊಳಿಸಲು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಉಪಯೋಗಿಸಿದರೆ, ಆ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಅಗ್ನಿಯಲ್ಲಿ ಸುಟ್ಟುಬಿಡಬೇಕು. ಯಾಜಕರು ಅದರ ಮಾಂಸವನ್ನು ತಿನ್ನಲೇಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ನಿಯಮಗಳು: ಅದು ಪವಿತ್ರವಾದದ್ದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ಯಾಜಕನು ಸರ್ವಾಂಗಹೋಮ ಸಮರ್ಪಣೆಗಳ ಪಶುವನ್ನು ವಧಿಸುವ ಸ್ಥಳದಲ್ಲಿಯೇ ದೋಷಪರಿಹಾರಕ ಪಶುವನ್ನು ವಧಿಸಬೇಕು. ಬಳಿಕ ಯಾಜಕನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಸುತ್ತಲೂ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","“ಯಾಜಕನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಪಶುವಿನ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಅರ್ಪಿಸಬೇಕು. ಅವನು ಬಾಲದ ಕೊಬ್ಬನ್ನು ಮತ್ತು ಒಳಗಿನ ಭಾಗಗಳನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೆಲ್ಲಾ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ಯಾಜಕನು ಅದರ ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನೂ ಮತ್ತು ಅವುಗಳನ್ನು ಸೊಂಟದವರೆಗೆ ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೂ ಪಿತ್ತಾಶಯವನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ಅವನು ಮೂತ್ರಪಿಂಡಗಳೊಡನೆ ಪಿತ್ತಾಶಯವನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ಯಾಜಕನು ಅವುಗಳನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮ ಮಾಡಬೇಕು. ಇದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಅರ್ಪಿತವಾದ ಹೋಮವಾಗಿರುವುದು. ಅದು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","“ಯಾಜಕನಾಗಿರುವ ಪ್ರತಿಯೊಬ್ಬನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಮಾಂಸವನ್ನು ತಿನ್ನಬಹುದು. ಅದು ಬಹು ಪವಿತ್ರವಾಗಿರುವುದರಿಂದ ಅದನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","ಷಪರಿಹಾರಕ ಯಜ್ಞವು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದಂತಿದೆ. ಒಂದೇ ರೀತಿಯ ನಿಯಮಗಳು ಈ ಎರಡು ಸಮರ್ಪಣೆಗಳಿಗೆ ಅನ್ವಯಿಸುತ್ತವೆ. ಯಜ್ಞ ಸಮರ್ಪಿಸುವ ಯಾಜಕನು ಆಹಾರಕ್ಕಾಗಿ ಅದರ ಮಾಂಸವನ್ನು ಪಡೆಯುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ಯಜ್ಞಮಾಡುವ ಯಾಜಕನು ಸರ್ವಾಂಗಹೋಮ ಪಶುವಿನ ಚರ್ಮವನ್ನು ಪಡೆಯಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ಪ್ರತಿ ಧಾನ್ಯಸಮರ್ಪಣೆಯು ಅದನ್ನು ಅರ್ಪಿಸುವ ಯಾಜಕನಿಗೆ ಸೇರುತ್ತದೆ. ಒಲೆಯಲ್ಲಾಗಲಿ ಕಬ್ಬಿಣದ ಹಂಚಿನಲ್ಲಾಗಲಿ ಬಾಂಡ್ಲೆಯಲ್ಲಾಗಲಿ ಬೇಯಿಸಿದ ಧಾನ್ಯಸಮರ್ಪಣೆಗಳನ್ನು ಯಾಜಕನು ಪಡೆಯುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ಧಾನ್ಯಸಮರ್ಪಣೆಗಳು ಆರೋನನ ಪುತ್ರರಿಗೆ ಸೇರುವವು. ಅದು ಒಣಗಿದ್ದರೂ ಎಣ್ಣೆಯಿಂದ ಬೆರೆತಿದ್ದರೂ ಅವರಿಗೆ ಸೇರುವವು. ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರೆಲ್ಲರೂ ಈ ಆಹಾರವನ್ನು ಹಂಚಿಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ಸಮಾಧಾನಯಜ್ಞದ ಕಟ್ಟಳೆಗಳು ಇಂತಿವೆ: ಯಾರಾದರೂ ಯೆಹೋವನಿಗೆ ಕೃತಜ್ಞತೆಯಿಂದ ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಬೇಕೆಂದಿದ್ದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ಅವನು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನೂ ಎಣ್ಣೆ ಹೊಯಿದು ಮಾಡಿದ ಕಡುಬುಗಳನ್ನೂ ಎಣ್ಣೆಬೆರೆಸಿದ ಹೋಳಿಗೆಗಳನ್ನೂ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ಅವನು ದೇವರಿಗೆ ತನ್ನ ಕೃತಜ್ಞತೆಯನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಅರ್ಪಿಸುವ ಯಜ್ಞವೇ ಸಮಾಧಾನಯಜ್ಞವಾಗಿದೆ. ಈ ಯಜ್ಞದೊಡನೆ ಅವನು ಹುಳಿಯಿರುವ ರೊಟ್ಟಿಗಳ ನೈವೇದ್ಯವನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ಸಮರ್ಪಿಸಲ್ಪಟ್ಟ ಪ್ರತಿಯೊಂದು ಪದಾರ್ಥಗಳಲ್ಲೂ ಒಂದೊಂದನ್ನು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಕೊಡಬೇಕು. ಸಮಾಧಾನಯಜ್ಞದ ರಕ್ತವನ್ನು ಚಿಮಿಕಿಸುವ ಯಾಜಕನಿಗೆ ಇದು ಸಲ್ಲತಕ್ಕದ್ದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ಸಮಾಧಾನಯಜ್ಞದ ಮಾಂಸವನ್ನು ಅದು ಸಮರ್ಪಣೆಯಾದ ದಿನದಲ್ಲಿಯೇ ತಿನ್ನಬೇಕು. ಒಬ್ಬನು ದೇವರಿಗೆ ತನ್ನ ಕೃತಜ್ಞತೆಯನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಈ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸುತ್ತಾನೆ. ಅದರ ಮಾಂಸದಲ್ಲಿ ಮರುದಿನದ ಮುಂಜಾನೆಯವರೆಗೆ ಏನೂ ಉಳಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ಯಾವನಾದರೂ ಸ್ವಇಚ್ಛೆಯ ಕಾಣಿಕೆಗಾಗಲಿ ಹರಕೆಯನ್ನು ಸಲ್ಲಿಸುವುದಕ್ಕಾಗಲಿ ಸಮಾಧಾನಯಜ್ಞ ಅರ್ಪಿಸಬಹುದು ಅಥವಾ ಆ ವ್ಯಕ್ತಿ ದೇವರಿಗೆ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸಿದರೆ, ಅವನು ಅದರ ಯಜ್ಞಮಾಂಸವನ್ನು ಸಮರ್ಪಿಸಿದ ದಿನದಲ್ಲಿಯೇ ತಿನ್ನಬೇಕು. ಉಳಿದದ್ದನ್ನು ಮರುದಿನ ತಿನ್ನಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ಆದರೆ ಈ ಯಜ್ಞಪಶುವು ಮೂರನೆಯ ದಿನದವರೆಗೆ ಉಳಿದರೆ, ಅದನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಸುಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ಒಬ್ಬನು ತನ್ನ ಸಮಾಧಾನಯಜ್ಞದಲ್ಲಿ ಉಳಿದದ್ದನ್ನು ಮೂರನೆಯ ದಿನದಲ್ಲಿ ತಿಂದರೆ, ಯೆಹೋವನು ಅವನ ವಿಷಯದಲ್ಲಿ ಸಂತೋಷಗೊಳ್ಳುವುದಿಲ್ಲ. ಯೆಹೋವನು ಆ ಯಜ್ಞವನ್ನು ಅವನ ಲೆಕ್ಕಕ್ಕೆ ತೆಗೆದುಕೊಳ್ಳುವುದಿಲ್ಲ. ಆ ಯಜ್ಞವು ಅಸಹ್ಯವಸ್ತುವಾಗುವುದು. ಆ ಮಾಂಸವನ್ನು ತಿಂದವನು ಆ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ಮಾತ್ರವಲ್ಲದೆ ಜನರು ಅಶುದ್ಧವಾದ ವಸ್ತುವಿಗೆ ಸೋಂಕಿದ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು. ಅವರು ಈ ಮಾಂಸವನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಸುಟ್ಟುಹಾಕಬೇಕು. ಶುದ್ಧನಾಗಿರುವ ಪ್ರತಿಯೊಬ್ಬನು ಸಮಾಧಾನ ಸಮರ್ಪಣೆಯ ಮಾಂಸವನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ಆದರೆ ಒಬ್ಬನು ಅಶುದ್ಧನಾಗಿದ್ದು ಯೆಹೋವನಿಗೆ ಸೇರಿದ ಸಮಾಧಾನ ಸಮರ್ಪಣೆಗಳ ಮಾಂಸವನ್ನು ತಿಂದರೆ, ಅವನನ್ನು ಅವನ ಕುಲದಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“ಒಬ್ಬನಿಗೆ ಮನುಷ್ಯದೇಹದಿಂದ ಆಗಿರುವ ಅಶುದ್ಧ ವಸ್ತು, ಅಶುದ್ಧ ಮೃಗ, ನಿಷಿದ್ಧ ವಸ್ತು ಇವುಗಳಲ್ಲಿ ಯಾವುದಾದರೂ ಸ್ಪರ್ಶವಾಗಿದ್ದರೆ ಅವನು ಅಶುದ್ಧನಾಗಿದ್ದಾನೆ. ಅವನು ಯೆಹೋವನಿಗೆ ಸೇರಿದ ಸಮಾಧಾನಯಜ್ಞಗಳ ಮಾಂಸವನ್ನು ತಿಂದರೆ, ಅವನನ್ನು ಕುಲದಿಂದ ತೆಗೆದುಹಾಕಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ನೀವು ದನಗಳ, ಕುರಿಗಳ ಅಥವಾ ಹೋತಗಳ ಕೊಬ್ಬನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ನೀವು ತನ್ನಷ್ಟಕ್ಕೆ ತಾನೇ ಸತ್ತ ಪ್ರಾಣಿಯ ಅಥವಾ ಬೇರೆ ಪ್ರಾಣಿಗಳಿಂದ ಕೊಲ್ಲಲ್ಪಟ್ಟ ಪ್ರಾಣಿಯ ಕೊಬ್ಬನ್ನು ಬೇರೆ ಕೆಲಸಕ್ಕೆ ಉಪಯೋಗಿಸಬಹುದು. ಆದರೆ ನೀವು ಅದನ್ನು ಎಂದಿಗೂ ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ಯಾವನಾದರೂ ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಣೆಯಾದ ಪಶುವಿನ ಕೊಬ್ಬನ್ನು ತಿಂದರೆ, ಅವನನ್ನು ಅವನ ಜನರಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“ನೀವು ಎಲ್ಲಿಯೇ ವಾಸಿಸಿದರೂ, ಯಾವುದೇ ಪಕ್ಷಿಯ ಅಥವಾ ಯಾವುದೇ ಪ್ರಾಣಿಯ ರಕ್ತವನ್ನು ನೀವು ಎಂದಿಗೂ ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ಯಾವನಾದರೂ ರಕ್ತವನ್ನು ತಿಂದರೆ, ಅವನನ್ನು ಅವನ ಜನರಿಂದ ತೆಗೆದುಹಾಕಲ್ಪಡಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ಇಸ್ರೇಲರಿಗೆ ಹೇಳು. ಒಬ್ಬನು ಯೆಹೋವನಿಗೆ ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಪಶುವನ್ನು ತಂದರೆ, ಯೆಹೋವನಿಗೆ ಸಲ್ಲತಕ್ಕ ಭಾಗವನ್ನು ಆತನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ಕಾಣಿಕೆಯ ಆ ಭಾಗವು ಅಗ್ನಿಯಲ್ಲಿ ಹೋಮಮಾಡಬೇಕು. ಅವನು ಕಾಣಿಕೆಯನ್ನು ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಹೋಗಬೇಕು. ಅವನು ಆ ಪಶುವಿನ ಕೊಬ್ಬನ್ನೂ ಎದೆಯ ಭಾಗವನ್ನೂ ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಎದೆಯ ಭಾಗವು ನಿವಾಳಿಸಲ್ಪಡಬೇಕು. ಇದು ನೈವೇದ್ಯ ಸಮರ್ಪಣೆಯಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ಬಳಿಕ ಯಾಜಕನು ವೇದಿಕೆಯ ಮೇಲೆ ಕೊಬ್ಬನ್ನು ಹೋಮಮಾಡಬೇಕು. ಆದರೆ ಪಶುವಿನ ಎದೆಯ ಭಾಗವು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಸೇರುವವು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ನೀವು ಸಮಾಧಾನಯಜ್ಞದ ಪಶುವಿನ ಬಲತೊಡೆಯನ್ನು ಸಹ ಯಾಜಕನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ಪಶುವಿನ ಬಲ ತೊಡೆಯ ಭಾಗವು ಸಮಾಧಾನಯಜ್ಞದಲ್ಲಿ ರಕ್ತವನ್ನು ಮತ್ತು ಕೊಬ್ಬನ್ನು ಸಮರ್ಪಿಸುವ ಯಾಜಕನಿಗೆ ಸೇರುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ನೈವೇದ್ಯರೂಪವಾಗಿ ನಿವಾಳಿಸುವ ಸಮರ್ಪಣೆಯಲ್ಲಿ ಪಶುವಿನ ಎದೆಯ ಭಾಗವನ್ನು ಮತ್ತು ಸಮಾಧಾನಯಜ್ಞಗಳಲ್ಲಿ ಪಶುವಿನ ಬಲ ತೊಡೆಯನ್ನು ಯೆಹೋವನಾದ ನಾನು ಇಸ್ರೇಲರಿಂದ ತೆಗೆದುಕೊಂಡು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಕೊಡುತ್ತಿದ್ದೇನೆ. ಇಸ್ರೇಲರು ಈ ನಿಯಮಕ್ಕೆ ಎಂದೆಂದಿಗೂ ವಿಧೇಯರಾಗಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಿದ ಸಮರ್ಪಣೆಗಳಲ್ಲಿ ಇವೇ ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಕೊಡಲ್ಪಟ್ಟ ಭಾಗಗಳಾಗಿವೆ. ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಯೆಹೋವನ ಯಾಜಕರಾಗಿ ಸೇವೆ ಮಾಡುವಾಗಲೆಲ್ಲಾ ಯಜ್ಞಗಳಲ್ಲಿ ಆ ಪಾಲನ್ನು ಪಡೆಯುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ಯೆಹೋವನು ಯಾಜಕರನ್ನು ಅಭಿಷೇಕಿಸಿದ ಸಮಯದಲ್ಲಿ ಆತನು ಯಾಜಕರಿಗೆ ಆ ಭಾಗಗಳನ್ನು ಕೊಡಬೇಕೆಂಬುದಾಗಿ ಇಸ್ರೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸಿದನು. ಜನರು ಯಾಜಕರಿಗೆ ಆ ಭಾಗಗಳನ್ನು ಎಂದೆಂದಿಗೂ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ಅವುಗಳೇ ಸರ್ವಾಂಗಹೋಮಗಳ, ಧಾನ್ಯಸಮರ್ಪಣೆಗಳ, ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಗಳ, ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಗಳ, ಸಮಾಧಾನಯಜ್ಞಗಳ ಮತ್ತು ಯಾಜಕರನ್ನು ಪ್ರತಿಷ್ಠಿಸುವ ನಿಯಮಗಳಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆ ನಿಯಮಗಳನ್ನು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಕೊಟ್ಟನು. ಇಸ್ರೇಲರು ಯೆಹೋವನಿಗೆ ತಮ್ಮ ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಬೇಕೆಂದು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಆಜ್ಞಾಪಿಸಿದ ದಿನದಲ್ಲಿ ಯೆಹೋವನು ಆ ನಿಯಮಗಳನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಕರೆದುಕೊಂಡು ಅವರೊಂದಿಗೆ ಯಾಜಕ ವಸ್ತ್ರಗಳನ್ನೂ ಅಭಿಷೇಕ ತೈಲವನ್ನೂ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ ಎರಡು ಟಗರುಗಳನ್ನೂ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯಿಂದ ತುಂಬಿರುವ ಪುಟ್ಟಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬಾ. ");
INSERT INTO kan2010_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ಮತ್ತು ಜನರನ್ನು ಒಟ್ಟಾಗಿ ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಎದುರಿನಲ್ಲಿ ಸೇರಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನು ಮೋಶೆಯು ಮಾಡಿದನು. ಜನರು ಒಟ್ಟಾಗಿ ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಸೇರಿ ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ಆಗ ಮೋಶೆಯು ಜನರಿಗೆ, “ನಾನು ಈಗ ಮಾಡುವ ಕಾರ್ಯವನ್ನು ಯೆಹೋವನೇ ಆಜ್ಞಾಪಿಸಿದನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ತರುವಾಯ ಮೋಶೆಯು ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಕರೆದನು. ಅವನು ಅವರಿಗೆ ನೀರಿನಿಂದ ಸ್ನಾನ ಮಾಡಿಸಿದನು; ");
INSERT INTO kan2010_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ನಿಲುವಂಗಿಯನ್ನು ಆರೋನನಿಗೆ ತೊಡಿಸಿದನು; ನಡುಕಟ್ಟನ್ನು ಕಟ್ಟಿದನು; ಮೇಲಂಗಿಯನ್ನು ತೊಡಿಸಿದನು. ಏಫೋದನ್ನು ಹಾಕಿಸಿ ಕವಚದ ಮೇಲಿನ ವಿಶೇಷವಾದ ನಡುಕಟ್ಟನ್ನು ಕಟ್ಟಿದನು; ಎದೆಕವಚವನ್ನು ಬಿಗಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ಅದರೊಳಗೆ ಊರೀಮ್ ಮತ್ತು ತುಮ್ಮೀಮ್ ಎಂಬ ವಸ್ತುಗಳನ್ನು ಹಾಕಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ಅವನ ತಲೆಗೆ ಮುಂಡಾಸವನ್ನು ಇಟ್ಟನು; ಮುಂಡಾಸದ ಮುಂಭಾಗದಲ್ಲಿ ಚಿನ್ನದ ಪಟ್ಟಿಯನ್ನು ಕಟ್ಟಿದನು. ಈ ಚಿನ್ನದ ಪಟ್ಟಿಯು ಪವಿತ್ರಕಿರೀಟವಾಗಿದೆ. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ತರುವಾಯ ಮೋಶೆಯು ಅಭಿಷೇಕತೈಲವನ್ನು ತೆಗೆದುಕೊಂಡು ಪವಿತ್ರಗುಡಾರದ ಮೇಲೆ ಮತ್ತು ಅದರಲ್ಲಿರುವ ಎಲ್ಲಾ ವಸ್ತುಗಳ ಮೇಲೆ ಚಿಮಿಕಿಸಿದನು. ಈ ರೀತಿಯಾಗಿ ಮೋಶೆಯು ಅವುಗಳನ್ನು ಪವಿತ್ರಗೊಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ಮೋಶೆಯು ಅಭಿಷೇಕತೈಲದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ವೇದಿಕೆಯ ಮೇಲೆ ಏಳು ಸಲ ಚಿಮಿಕಿಸಿದನು. ಮೋಶೆಯು ತೈಲವನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ, ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳ ಮೇಲೆ ಚಿಮಿಕಿಸಿದನು. ಮೋಶೆಯು ತೈಲವನ್ನು ಗಂಗಾಳ ಮತ್ತು ಅದರ ಪೀಠದ ಮೇಲೂ ಚಿಮಿಕಿಸಿದನು. ಈ ರೀತಿಯಾಗಿ ಮೋಶೆಯು ಅವುಗಳನ್ನು ಪವಿತ್ರಗೊಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ಬಳಿಕ ಮೋಶೆಯು ಸ್ವಲ್ಪ ಅಭಿಷೇಕತೈಲವನ್ನು ಆರೋನನ ತಲೆಗೆ ಹೊಯಿದು ಅವನನ್ನು ಪವಿತ್ರಗೊಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ಬಳಿಕ ಮೋಶೆಯು ಆರೋನನ ಪುತ್ರರನ್ನು ಕರೆದುಕೊಂಡು ಬಂದು ಅವರಿಗೆ ನಿಲುವಂಗಿಗಳನ್ನು ತೊಡಿಸಿ ನಡುಕಟ್ಟನ್ನು ಕಟ್ಟಿದನು. ಬಳಿಕ ಅವರ ತಲೆಗಳಿಗೆ ಮುಂಡಾಸಗಳನ್ನು ಇಟ್ಟನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ತರುವಾಯ ಮೋಶೆಯು ಪಾಪಪರಿಹಾರಕ್ಕಾಗಿ ಯಜ್ಞದ ಹೋರಿಯನ್ನು ತಂದನು. ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ಆ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದ ಹೋರಿಯ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ಬಳಿಕ ಮೋಶೆಯು ಹೋರಿಯನ್ನು ವಧಿಸಿ ಅದರ ರಕ್ತವನ್ನು ತೆಗೆದುಕೊಂಡು ಆ ರಕ್ತದಲ್ಲಿ ತನ್ನ ಬೆರಳನ್ನು ಅದ್ದಿ ವೇದಿಕೆಯ ಎಲ್ಲಾ ಮೂಲೆಗಳಿಗೆ ರಕ್ತವನ್ನು ಹಚ್ಚಿದನು. ಹೀಗೆ ಮೋಶೆಯು ವೇದಿಕೆಯನ್ನು ಯಜ್ಞಗಳಿಗಾಗಿ ಶುದ್ಧಗೊಳಿಸಿ ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಬುಡದಲ್ಲಿ ಸುರಿದನು; ಜನರನ್ನು ಶುದ್ಧಿಮಾಡುವ ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕಾಗಿ ವೇದಿಕೆಯನ್ನು ಪ್ರತಿಷ್ಠೆಗೊಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ಮೋಶೆಯು ಹೋರಿಯ ಒಳಗಿನ ಭಾಗಗಳ ಕೊಬ್ಬನ್ನೂ ಪಿತ್ತಾಶಯವನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನೂ ಮತ್ತು ಅವುಗಳನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೂ ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ಹೋರಿಯ ಚರ್ಮ, ಅದರ ಮಾಂಸ ಮತ್ತು ಅದರ ಶರೀರದ ಕಲ್ಮಶವನ್ನು ಅವನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಹಾಕಿದನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ಬಳಿಕ ಮೋಶೆಯು ಸರ್ವಾಂಗಹೋಮದ ಟಗರನ್ನು ತಂದನು. ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ತಮ್ಮ ಕೈಗಳನ್ನು ಟಗರಿನ ತಲೆಯ ಮೇಲೆ ಇಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ಆಗ ಮೋಶೆಯು ಟಗರನ್ನು ವಧಿಸಿ ಅದರ ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಸುತ್ತಲೂ ಚಿಮಿಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","ಮೋಶೆಯು ಟಗರನ್ನು ತುಂಡುತುಂಡಾಗಿ ಕಡಿದು ಅದರ ಒಳಗಿನ ಭಾಗಗಳನ್ನು ಮತ್ತು ಕಾಲುಗಳನ್ನು ನೀರಿನಿಂದ ತೊಳೆದನು; ಇಡೀ ಟಗರನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ಮೋಶೆಯು ಅದರ ತಲೆ, ತುಂಡುಗಳು ಮತ್ತು ಕೊಬ್ಬನ್ನು ಹೋಮಮಾಡಿದನು. ಅದು ಯೆಹೋವನಿಗೆ ಅಗ್ನಿಯ ಮೂಲಕ ಅರ್ಪಿಸಲ್ಪಟ್ಟ ಸುಗಂಧಕರವಾದ ಸರ್ವಾಂಗಹೋಮವಾಗಿದೆ. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ಬಳಿಕ ಮೋಶೆಯು ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಯಾಜಕರನ್ನಾಗಿ ನೇಮಿಸುವುದಕ್ಕೆ ವಧಿಸಬೇಕಾದ ಎರಡನೆಯ ಟಗರನ್ನು ತಂದನು. ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ತಮ್ಮ ಕೈಗಳನ್ನು ಟಗರಿನ ತಲೆಯ ಮೇಲೆ ಇಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ಆಗ ಮೋಶೆ ಟಗರನ್ನು ವಧಿಸಿ ಅದರ ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ಆರೋನನ ಬಲಗಿವಿಯ ತುದಿಗೂ ಅವನ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಅವನ ಬಲಗಾಲಿನ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಹಚ್ಚಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ಬಳಿಕ ಮೋಶೆಯು ಆರೋನನ ಪುತ್ರರನ್ನು ವೇದಿಕೆಯ ಸಮೀಪಕ್ಕೆ ಕರೆಸಿ ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ಅವರ ಬಲಗಿವಿಗಳ ತುದಿಗೂ ಅವರ ಬಲಗೈಗಳ ಹೆಬ್ಬೆರಳಿಗೂ ಮತ್ತು ಅವರ ಬಲಗಾಲುಗಳ ಹೆಬ್ಬೆಟ್ಟಿಗೂ ಹಚ್ಚಿದನು; ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಸುತ್ತಲೂ ಚಿಮಿಕಿಸಿದನು; ");
INSERT INTO kan2010_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ಕೊಬ್ಬನ್ನು ಅಂದರೆ ಬಾಲದ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಒಳಗಿನ ಭಾಗಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬೆಲ್ಲವನ್ನೂ ಪಿತ್ತಾಶಯವನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೂ ಎರಡು ಮೂತ್ರಪಿಂಡಗಳನ್ನೂ ಅವುಗಳ ಮೇಲಿರುವ ಕೊಬ್ಬನ್ನೂ ಮತ್ತು ಬಲತೊಡೆಯನ್ನೂ ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ಪ್ರತಿದಿನ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಪುಟ್ಟಿಯು ಇಡಲ್ಪಡುತ್ತಿತ್ತು. ಮೋಶೆಯು ರೊಟ್ಟಿಯಲ್ಲಿ ಒಂದು ತುಂಡನ್ನೂ ಎಣ್ಣೆ ಬೆರಸಿದ ರೊಟ್ಟಿಯಲ್ಲಿ ಒಂದು ತುಂಡನ್ನೂ ಹುಳಿಯಿಲ್ಲದ ಒಂದು ಕಡುಬನ್ನೂ ತೆಗೆದುಕೊಂಡನು. ಮೋಶೆಯು ಆ ರೊಟ್ಟಿಯ ತುಂಡುಗಳನ್ನು ಕೊಬ್ಬಿನ ಮತ್ತು ಟಗರಿನ ಬಲತೊಡೆಯ ಮೇಲೆ ಇಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ಬಳಿಕ ಮೋಶೆಯು ಅವೆಲ್ಲವುಗಳನ್ನು ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರ ಕೈಗಳಲ್ಲಿ ಇಟ್ಟನು. ಮೋಶೆಯು ತುಂಡುಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ಬಳಿಕ ಮೋಶೆಯು ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರ ಕೈಗಳಲ್ಲಿರುವ ಈ ವಸ್ತುಗಳನ್ನು ತೆಗೆದುಕೊಂಡನು. ಮೋಶೆಯು ಅವುಗಳನ್ನು ವೇದಿಕೆಯಲ್ಲಿ ಸರ್ವಾಂಗಹೋಮದ ಮೇಲಿಟ್ಟು ಅವುಗಳನ್ನು ಹೋಮಮಾಡಿದನು. ಅದು ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಯಾಜಕರನ್ನಾಗಿ ನೇಮಿಸುವ ಸಮರ್ಪಣೆಯಾಗಿತ್ತು. ಹೋಮವಾಗಿ ಅರ್ಪಿಸಲ್ಪಟ್ಟ ಈ ಯಜ್ಞವು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಕರವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ಮೋಶೆಯು ಎದೆಯ ಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನ ಮುಂದೆ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿದನು. ಅದು ಯಾಜಕರನ್ನು ನೇಮಿಸುವುದಕ್ಕಾಗಿ ಅರ್ಪಿಸಲ್ಪಟ್ಟ ಟಗರಿನಲ್ಲಿ ಮೋಶೆಯ ಪಾಲಾಗಿತ್ತು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ಮೋಶೆಯು ಸ್ವಲ್ಪ ಅಭಿಷೇಕತೈಲವನ್ನು ಮತ್ತು ವೇದಿಕೆಯ ಮೇಲಿದ್ದ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಆರೋನನ ಮೇಲೆ ಮತ್ತು ಅವನ ಯಾಜಕವಸ್ತ್ರದ ಮೇಲೆ ಚಿಮಿಕಿಸಿದನು; ಆರೋನನ ಜೊತೆ ಇದ್ದ ಅವನ ಪುತ್ರರ ಮೇಲೆ ಮತ್ತು ಅವರ ಬಟ್ಟೆಗಳ ಮೇಲೆ ಚಿಮಿಕಿಸಿದನು. ಹೀಗೆ ಮೋಶೆಯು ಆರೋನನನ್ನೂ ಅವನ ಯಾಜಕವಸ್ತ್ರವನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಅವರ ಯಾಜಕ ವಸ್ತ್ರಗಳನ್ನೂ ಪವಿತ್ರಗೊಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ತರುವಾಯ ಮೋಶೆಯು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಹೀಗೆ ಹೇಳಿದನು: “ನೀವು ಮಾಂಸವನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಬೇಯಿಸಿ ತಿನ್ನಬೇಕು. ಪ್ರತಿಷ್ಠೆಕಾಣಿಕೆಯ ಬುಟ್ಟಿಯಲ್ಲಿರುವ ರೊಟ್ಟಿಯೊಡನೆ ಅದನ್ನು ಅಲ್ಲಿ ತಿನ್ನಿರಿ. ಮಾಂಸವನ್ನೂ ರೊಟ್ಟಿಯನ್ನೂ ಆ ಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಿರಿ. ನಾನು ಹೇಳುವ ಹಾಗೆ ಇದನ್ನು ಮಾಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ಮಾಂಸವಾಗಲಿ ರೊಟ್ಟಿಯಾಗಲಿ ಉಳಿದರೆ ಅದನ್ನು ಸುಟ್ಟುಹಾಕಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ಯಾಜಕರಾಗಿ ಪ್ರತಿಷ್ಠಿಸುವ ಆಚಾರವಿಧಿಯು ಏಳು ದಿನಗಳವರೆಗೆ ಇರುವುದು. ಆ ಸಮಯ ಮುಗಿಯುವವರೆಗೆ ನೀವು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲನ್ನು ಬಿಟ್ಟು ಹೋಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ಈ ದಿನದಲ್ಲಿ ಮಾಡಿದ ಸಕಲಕಾರ್ಯಗಳನ್ನು ಏಳು ದಿನವೂ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ನೀವು ಏಳು ದಿನಗಳು ಹಗಲುರಾತ್ರಿ ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿನಲ್ಲಿ ಇರಬೇಕು. ನೀವು ಯೆಹೋವನ ಆಜ್ಞೆಗಳಿಗೆ ವಿಧೇಯರಾಗದಿದ್ದರೆ ಸಾಯುವಿರಿ! ಯೆಹೋವನು ಆ ಆಜ್ಞೆಗಳನ್ನು ನನಗೆ ಕೊಟ್ಟನು.” ");
INSERT INTO kan2010_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ಆದ್ದರಿಂದ ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಆಜ್ಞಾಪಿಸಿದ ಎಲ್ಲಾ ಕಾರ್ಯಗಳನ್ನು ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಮೋಶೆಯು ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಇಸ್ರೇಲರ ಹಿರಿಯರನ್ನೂ ಕರೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ಮೋಶೆಯು ಆರೋನನಿಗೆ ಹೀಗೆಂದನು; “ಒಂದು ಎಳೆಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ತೆಗೆದುಕೊ. ಆ ಪಶುಗಳಲ್ಲಿ ಏನೂ ದೋಷವಿರಬಾರದು. ಹೋರಿಯನ್ನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿಯೂ ಟಗರನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿಯೂ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ‘ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಹೋತವನ್ನು ತೆಗೆದುಕೊಳ್ಳಿರಿ; ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಕರುವನ್ನೂ ಕುರಿಮರಿಯನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಿರಿ. ಕರುವೂ ಕುರಿಮರಿಯೂ ಒಂದು ವರ್ಷದ್ದಾಗಿರಬೇಕು. ಆ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಯಾವ ದೋಷವಿರಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ತೆಗೆದುಕೊಂಡು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಧಾನ್ಯಸಮರ್ಪಣೆಗಳೊಡನೆ ಅವುಗಳನ್ನು ಯೆಹೋವನ ಮುಂದೆ ಅರ್ಪಿಸಿರಿ. ಯಾಕೆಂದರೆ ಈ ದಿನ ಯೆಹೋವನು ನಿಮಗೆ ಪ್ರತ್ಯಕ್ಷವಾಗುವನು.’” ");
INSERT INTO kan2010_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ಆದ್ದರಿಂದ ಜನರೆಲ್ಲರೂ ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಬಂದರು. ಮೋಶೆಯು ಆಜ್ಞಾಪಿಸಿದ ವಸ್ತುಗಳನ್ನು ಅವರು ತಂದರು. ಎಲ್ಲಾ ಜನರು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿಂತರು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ಮೋಶೆಯು, “ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದವುಗಳನ್ನು ನೀವು ಮಾಡಿದರೆ ಯೆಹೋವನ ಮಹಿಮೆಯು ನಿಮಗೆ ಪ್ರತ್ಯಕ್ಷವಾಗುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದವುಗಳನ್ನು ಮಾಡು. ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಗೆ ಹೋಗಿ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನೂ ಸರ್ವಾಂಗಹೋಮವನ್ನೂ ಅರ್ಪಿಸು. ನಿನ್ನನ್ನೂ ಜನರನ್ನೂ ಶುದ್ಧಿಮಾಡುವ ಆ ಕಾರ್ಯಗಳನ್ನು ಮಾಡು. ಜನರು ತಂದದ್ದನ್ನು ತೆಗೆದುಕೊಂಡು ಅವರಿಗಾಗಿ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸಿ ಅವರನ್ನು ಶುದ್ಧಿಮಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ಆದ್ದರಿಂದ ಆರೋನನು ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಗೆ ಹೋದನು. ಅವನು ತನಗೋಸ್ಕರ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಎಳೆ ಹೋರಿಯನ್ನು ವಧಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ಆರೋನನ ಪುತ್ರರು ರಕ್ತವನ್ನು ಆರೋನನ ಬಳಿಗೆ ತಂದರು. ಆರೋನನ ತನ್ನ ಬೆರಳನ್ನು ರಕ್ತದಲ್ಲಿ ಅದ್ದಿ ಯಜ್ಞವೇದಿಕೆಯ ಮೂಲೆಗಳಿಗೆ ಹಚ್ಚಿದನು. ಬಳಿಕ ಆರೋನನು ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ಬುಡದಲ್ಲಿ ಸುರಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ಆರೋನನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಪಶುವಿನ ಕೊಬ್ಬನ್ನು, ಮೂತ್ರಪಿಂಡಗಳನ್ನು ಮತ್ತು ಪಿತ್ತಾಶಯವನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನು ತೆಗೆದುಕೊಂಡನು. ಅವನು ಆ ವಸ್ತುಗಳನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ಬಳಿಕ ಆರೋನನು ಮಾಂಸವನ್ನು ಮತ್ತು ಚರ್ಮವನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಬೆಂಕಿಯಲ್ಲಿ ಸುಟ್ಟುಹಾಕಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ನಂತರ ಆರೋನನು ಸರ್ವಾಂಗಹೋಮದ ಪಶುವನ್ನು ವಧಿಸಿದನು. ಆರೋನನ ಪುತ್ರರು ರಕ್ತವನ್ನು ಆರೋನನ ಬಳಿಗೆ ತಂದರು. ಆರೋನನು ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಸುತ್ತಲೂ ಚಿಮಿಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ಆರೋನನ ಪುತ್ರರು ಸರ್ವಾಂಗಹೋಮದ ಪಶುವಿನ ಮಾಂಸದ ತುಂಡುಗಳನ್ನು ಮತ್ತು ತಲೆಯನ್ನು ಆರೋನನಿಗೆ ಕೊಟ್ಟರು. ಬಳಿಕ ಆರೋನನು ಅವುಗಳನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ಆರೋನನು ಸರ್ವಾಂಗಹೋಮದ ಪಶುವಿನ ಒಳಗಿನ ಭಾಗಗಳನ್ನೂ ಕಾಲುಗಳನ್ನೂ ತೊಳೆದು ಅವುಗಳನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ತರುವಾಯ ಆರೋನನು ಜನರು ಅರ್ಪಿಸುವ ಪಶುಗಳನ್ನು ತರಿಸಿದನು. ಅವನು ಜನರಿಗಾಗಿ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಹೋತವನ್ನು ವಧಿಸಿದನು. ಅವನು ಮೊದಲಿನ ಪಶುವನ್ನು ಸಮರ್ಪಿಸಿದ ರೀತಿಯಲ್ಲಿ ಪಾಪಪರಿಹಾರಕ್ಕಾಗಿ ಹೋತವನ್ನು ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ಆರೋನನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಪಶುವನ್ನು ತರಿಸಿ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ಆರೋನನು ಧಾನ್ಯನೈವೇದ್ಯವನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಗೆ ತಂದನು. ಅವನು ಒಂದು ಹಿಡಿ ಧಾನ್ಯವನ್ನು ತೆಗೆದುಕೊಂಡು ದಿನಂಪ್ರತಿ ಹೊತ್ತಾರೆಯ ವೇಳೆಯಲ್ಲಿ ಅರ್ಪಿಸುವ ಯಜ್ಞವಲ್ಲದೆ ಇದನ್ನೂ ಕೂಡ ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ಆರೋನನು ಜನರಿಗಾಗಿ ಸಮಾಧಾನಯಜ್ಞವಾದ ಹೋರಿಯನ್ನೂ ಟಗರನ್ನೂ ವಧಿಸಿದನು. ಆರೋನನ ಪುತ್ರರು ರಕ್ತವನ್ನು ಆರೋನನ ಬಳಿಗೆ ತಂದರು. ಆರೋನನು ಈ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ಸುತ್ತಲೂ ಚಿಮಿಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ಆರೋನನ ಪುತ್ರರು ಹೋರಿಯ ಮತ್ತು ಟಗರಿನ ಕೊಬ್ಬನ್ನೂ ಆರೋನನ ಬಳಿಗೆ ತಂದರು. ಇವರು ಬಾಲದ ಕೊಬ್ಬನ್ನೂ ಒಳಗಿನ ಭಾಗಗಳನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೂ ಮೂತ್ರಪಿಂಡಗಳನ್ನೂ ಪಿತ್ತಾಶಯವನ್ನು ಆವರಿಸಿರುವ ಕೊಬ್ಬನ್ನೂ ತಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ಅವರು ಈ ಕೊಬ್ಬಿನ ಭಾಗಗಳನ್ನು ಹೋರಿಯ ಮತ್ತು ಟಗರಿನ ಎದೆಯ ಭಾಗಗಳ ಮೇಲೆ ಇಟ್ಟರು. ಆರೋನನು ಅವೆಲ್ಲವನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ಮೋಶೆಯು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಎದೆಯ ಭಾಗಗಳನ್ನು ಮತ್ತು ಬಲತೊಡೆಯನ್ನು ಆರೋನನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ತರುವಾಯ ಆರೋನನು ತನ್ನ ಕೈಗಳನ್ನು ಜನರ ಕಡೆಗೆ ಎತ್ತಿ ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿದನು. ಆರೋನನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನೂ ಸರ್ವಾಂಗಹೋಮವನ್ನೂ ಮತ್ತು ಸಮಾಧಾನಯಜ್ಞವನ್ನೂ ಅರ್ಪಿಸಿ ಮುಗಿಸಿದ ನಂತರ ಯಜ್ಞವೇದಿಕೆಯಿಂದ ಕೆಳಗಿಳಿದು ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ಮೋಶೆಯು ಮತ್ತು ಆರೋನನು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಹೋದರು. ಅವರು ಹೊರಗೆ ಬಂದು ಜನರನ್ನು ಆಶೀರ್ವದಿಸಿದರು. ಆಗ ಯೆಹೋವನ ಮಹಿಮೆಯು ಜನರೆಲ್ಲರಿಗೆ ಪ್ರತ್ಯಕ್ಷವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ಯೆಹೋವನ ಬಳಿಯಿಂದ ಬೆಂಕಿಯು ಬಂದು ವೇದಿಕೆಯ ಮೇಲಿದ್ದ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಮತ್ತು ಕೊಬ್ಬನ್ನು ದಹಿಸಿಬಿಟ್ಟಿತು. ಜನರೆಲ್ಲರೂ ಇದನ್ನು ನೋಡಿದಾಗ, ಅವರು ಆನಂದದಿಂದ ಆರ್ಭಟಿಸಿ ಅಡ್ಡಬಿದ್ದು ನಮಸ್ಕರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ತರುವಾಯ ಆರೋನನ ಪುತ್ರರಲ್ಲಿ ನಾದ್ವಾ್ ಮತ್ತು ಅಬೀಹು ಎಂಬಿಬ್ಬರು ಧೂಪ ಹಾಕಲು ಒಂದೊಂದು ಬಟ್ಟಲನ್ನು ತೆಗೆದುಕೊಂಡು ಅದರಲ್ಲಿ ಬೇರೆ ಬೆಂಕಿಯನ್ನಿಟ್ಟು ಯೆಹೋವನ ಮುಂದೆ ಧೂಪಹಾಕಿದರು. ಯೆಹೋವನ ಆಜ್ಞೆಗನುಸಾರವಾದ ಬೆಂಕಿಯನ್ನು ಅವರು ಉಪಯೋಗಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ಆದ್ದರಿಂದ ಯೆಹೋವನಿಂದ ಬೆಂಕಿ ಹೊರಟುಬಂದು ಅವರಿಬ್ಬರನ್ನು ನಾಶಮಾಡಿತು. ಅವರು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸತ್ತರು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ಆಗ ಮೋಶೆ ಆರೋನನಿಗೆ, “ಯೆಹೋವನು ಹೇಳುವುದೇನೆಂದರೆ, ‘ನನ್ನ ಬಳಿಗೆ ಬರುವ ಯಾಜಕರು ನನ್ನನ್ನು ಗೌರವಿಸಬೇಕು. ಯಾಕೆಂದರೆ ನಾನು ಅವರ ಮೂಲಕ ಜನರಿಗೆ ಪ್ರಕಟಿಸಿಕೊಳ್ಳುವೆನು. ನಾನು ಪರಿಶುದ್ಧನೆಂದು ಅವರು ಮತ್ತು ಎಲ್ಲಾ ಜನರು ತಿಳಿದುಕೊಂಡು ನನ್ನನ್ನು ಘನಪಡಿಸಬೇಕು’” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಆರೋನನು ತನ್ನ ಪುತ್ರರು ಸತ್ತಿದ್ದರ ಬಗ್ಗೆ ಏನೂ ಹೇಳದೆ ಸುಮ್ಮನಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ಆರೋನನ ಚಿಕ್ಕಪ್ಪನಾದ ಉಜ್ಜಿಯೇಲನಿಗೆ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ಅವರ ಹೆಸರು ಮೀಶಾಯೇಲ್ ಮತ್ತು ಎಲ್ಸಾಫಾನ್. ಮೋಶೆಯು ಆ ಪುತ್ರರಿಗೆ, “ಪವಿತ್ರಸ್ಥಳದ ಮುಂದೆ ಬಿದ್ದಿರುವ ನಿಮ್ಮ ಸಹೋದರರ ಮೃತಶರೀರಗಳನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ಮಿಶಾಯೇಲ ಮತ್ತು ಎಲ್ಸಾಫಾನ ಮೋಶೆಯ ಮಾತಿಗೆ ವಿಧೇಯರಾದರು. ಅವರು ನಾದ್ವಾ್ ಮತ್ತು ಅಬೀಹು ಎಂಬವರ ಮೃತಶರೀರಗಳನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋದರು. ನಾದ್ವಾ್ ಮತ್ತು ಅಬೀಹು ತೊಟ್ಟುಕೊಂಡಿದ್ದ ವಿಶೇಷವಾದ ಹೆಣೆದ ಅಂಗಿಗಳು ಇನ್ನೂ ಅವರ ಮೃತಶರೀರಗಳ ಮೇಲಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ಬಳಿಕ ಮೋಶೆ ಆರೋನನೊಡನೆ ಮತ್ತು ಅವನ ಪುತ್ರರಾದ ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಇವರೊಡನೆ ಮಾತಾಡಿದನು. ಮೋಶೆಯು ಅವರಿಗೆ, “ನೀವು ದುಃಖದಿಂದ ನಿಮ್ಮ ತಲೆಕೂದಲನ್ನು ಕೆದರಿಕೊಳ್ಳಬೇಡಿರಿ; ನಿಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಳ್ಳಬೇಡಿರಿ. ಇಲ್ಲವಾದರೆ ನೀವೂ ಕೊಲ್ಲಲ್ಪಡುವಿರಿ. ಅಲ್ಲದೆ ಯೆಹೋವನು ಜನರೆಲ್ಲರ ಮೇಲೆ ಕೋಪಗೊಳ್ಳುವನು. ಇಸ್ರೇಲರೆಲ್ಲರೂ ನಿಮ್ಮ ಬಂಧುಗಳು. ಯೆಹೋವನು ನಾದ್ವಾ್ ಮತ್ತು ಅಬೀಹು ಅವರನ್ನು ಸುಟ್ಟುಹಾಕಿದ್ದರ ಬಗ್ಗೆ ಅವರು ದುಃಖಿಸಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ಆದರೆ ನೀವು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲನ್ನು ಸಹ ಬಿಟ್ಟುಹೋಗಬಾರದು. ಇಲ್ಲವಾದರೆ ನೀವು ಸಾಯುವಿರಿ! ಯಾಕೆಂದರೆ, ಯೆಹೋವನ ಅಭಿಷೇಕತೈಲವು ನಿಮ್ಮ ಮೇಲಿದೆ” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಆರೋನ, ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಮೋಶೆಯ ಮಾತಿಗೆ ವಿಧೇಯರಾದರು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ಬಳಿಕ ಯೆಹೋವನು ಆರೋನನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ನೀನು ಮತ್ತು ನಿನ್ನ ಪುತ್ರರು ದೇವದರ್ಶನದ ಗುಡಾರದೊಳಗೆ ಬರುವಾಗ ದ್ರಾಕ್ಷಾರಸವನ್ನಾಗಲಿ ಮದ್ಯವನ್ನಾಗಲಿ ಕುಡಿಯಬಾರದು. ನೀವು ಅವುಗಳನ್ನು ಕುಡಿದರೆ ಸಾಯುವಿರಿ. ಈ ಕಟ್ಟಳೆಯು ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೆ ಶಾಶ್ವತವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ನೀವು ಪವಿತ್ರವಾದವುಗಳ ಮತ್ತು ಪವಿತ್ರವಲ್ಲದ ವಸ್ತುಗಳ ಕುರಿತಾಗಿಯೂ ಶುದ್ಧವಾದವುಗಳ ಮತ್ತು ಅಶುದ್ಧವಾದವುಗಳ ಕುರಿತಾಗಿಯೂ ಸ್ಪಷ್ಟವಾಗಿ ವಿವೇಚನೆಯುಳ್ಳವರಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಇಸ್ರೇಲ್ ಜನರಿಗೆ ಕೊಟ್ಟ ಎಲ್ಲಾ ಕಟ್ಟಳೆಗಳನ್ನು ಅವರಿಗೆ ಬೋಧಿಸುವುದು ನಿನ್ನ ಜವಾಬ್ದಾರಿಯಾಗಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ಆರೋನನಿಗೆ ಇನ್ನೂ ಜೀವಂತವಾಗಿದ್ದ ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್ ಎಂಬ ಇಬ್ಬರು ಪುತ್ರರು ಇದ್ದರು. ಮೋಶೆಯು ಆರೋನನಿಗೆ ಮತ್ತು ಅವನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಿಗೆ, “ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಅರ್ಪಿಸಿದ ಯಜ್ಞಗಳಲ್ಲಿಯೂ ಧಾನ್ಯನೈವೇದ್ಯದಲ್ಲಿಯೂ ಉಳಿದ ಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು ನೀವು ತಿನ್ನಬೇಕು. ಆದರೆ ನೀವು ಅದಕ್ಕೆ ಹುಳಿಯನ್ನು ಸೇರಿಸದೆ ಯಜ್ಞವೇದಿಕೆಯ ಸಮೀಪದಲ್ಲಿಯೇ ತಿನ್ನಬೇಕು. ಯಾಕೆಂದರೆ ಆ ಸಮರ್ಪಣೆಯು ಬಹಳ ಪವಿತ್ರವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ಅದನ್ನು ಪವಿತ್ರವಾದ ಸ್ಥಳದಲ್ಲಿ ಮಾತ್ರ ತಿನ್ನಬೇಕು. ಅದು ಯೆಹೋವನಿಗಾಗಿ ಅಗ್ನಿಯಲ್ಲಿ ಹೋಮವಾದ ಸಮರ್ಪಣೆಗಳಲ್ಲಿ ಒಂದು ಭಾಗವಾಗಿದೆ. ಯೆಹೋವನಿಗಾಗಿ ಬೆಂಕಿಯ ಮೂಲಕ ಸಮರ್ಪಿಸಿದವುಗಳಲ್ಲಿ ನಿನಗೂ ನಿನ್ನ ಗಂಡುಮಕ್ಕಳಿಗೂ ಇದು ಸೇರತಕ್ಕ ಪಾಲಾಗಿದೆ. ನಿಮಗೆ ಈ ಕಟ್ಟಳೆಯನ್ನು ಕೊಡಲು ನನಗೆ ಆಜ್ಞಾಪಿಸಲಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“ಮಾತ್ರವಲ್ಲದೆ ನೀನು, ನಿನ್ನ ಪುತ್ರರು ಮತ್ತು ನಿನ್ನ ಹೆಣ್ಣುಮಕ್ಕಳು ಯೆಹೋವನಿಗೆ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಿದ ಎದೆಯ ಭಾಗವನ್ನು ಮತ್ತು ಅರ್ಪಿಸಲ್ಪಟ್ಟ ತೊಡೆಯನ್ನು ತಿನ್ನಬೇಕು. ನೀವು ಅವುಗಳನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕಾಗಿಲ್ಲ. ಆದರೆ ನೀವು ಅವುಗಳನ್ನು ಶುದ್ಧವಾದ ಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕು. ಯಾಕೆಂದರೆ ಅವುಗಳು ಸಮಾಧಾನಯಜ್ಞಗಳಿಂದ ಬಂದವುಗಳಾಗಿವೆ. ಇಸ್ರೇಲರು ಆ ಕಾಣಿಕೆಗಳನ್ನು ದೇವರಿಗಾಗಿ ಕೊಡುತ್ತಾರೆ. ಜನರು ಆ ಪಶುಗಳಲ್ಲಿ ಕೆಲವು ಭಾಗಗಳನ್ನು ತಿನ್ನುತ್ತಾರೆ. ಆದರೆ ಎದೆಯ ಭಾಗವು ನಿಮ್ಮ ಪಾಲಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ಜನರು ಪ್ರಾಣಿಗಳ ಕೊಬ್ಬನ್ನು ಅಗ್ನಿಯ ಮೂಲಕ ಹೋಮಮಾಡುವಾಗ, ಯಾಜಕರಿಗಾಗಿ ತೆಗೆದಿಟ್ಟ ತೊಡೆಯ ಭಾಗವನ್ನು ಮತ್ತು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕಾದ ಎದೆಯ ಭಾಗವನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತರಬೇಕು. ಅದು ನಿಮ್ಮ ಪಾಲಾಗಿರುವುದು. ಅದು ನಿನಗೂ ನಿನ್ನ ಮಕ್ಕಳಿಗೂ ಸೇರಿದ್ದು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಯಜ್ಞಗಳ ಆ ಭಾಗವು ಎಂದೆಂದೂ ನಿಮ್ಮ ಪಾಲಾಗಿರುತ್ತದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ಮೋಶೆಯು ಪಾಪಪರಿಹಾರಕ್ಕಾಗಿ ಸಮರ್ಪಿತವಾದ ಹೋತದ ಕುರಿತು ವಿಚಾರಿಸಿದಾಗ, ಅದನ್ನು ಸುಟ್ಟುಬಿಟ್ಟರೆಂದು ಕೇಳಿ ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರಾದ ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್‌ರವರ ಮೇಲೆ ಬಹುಕೋಪಗೊಂಡನು. ಮೋಶೆಯು, ");
INSERT INTO kan2010_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ನೀವು ಹೋತದ ಮಾಂಸವನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕಾಗಿತ್ತು. ಅದು ಬಹಳ ಪವಿತ್ರವಾದದ್ದಲ್ಲವೇ? ನೀವು ಯಾಕೆ ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ತಿನ್ನಲಿಲ್ಲ? ನೀವು ಜನರ ಪಾಪಪರಿಹಾರ ಮಾಡುವಂತೆಯೂ ಜನರ ದೋಷವನ್ನು ಪರಿಹಾರಮಾಡುವಂತೆಯೂ ಯೆಹೋವನು ಅದನ್ನು ನಿಮಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ಆ ಹೋತದ ರಕ್ತವನ್ನು ಪವಿತ್ರಸ್ಥಳದ ಒಳಗಡೆ ತರಲಿಲ್ಲ. ನಾನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ನೀವು ಅದರ ಮಾಂಸವನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ತಿನ್ನಬೇಕಾಗಿತ್ತು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ಆದರೆ ಆರೋನನು ಮೋಶೆಗೆ, “ನೋಡು ಈ ದಿನ ಇವರು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಪಾಪಪರಿಹಾರಕ ಮತ್ತು ಸರ್ವಾಂಗಹೋಮಗಳನ್ನು ತಂದಿದ್ದರೂ ನನಗೆ ಈ ಆಪತ್ತು ಸಂಭವಿಸಿತು. ಹೀಗಿರುವಾಗ ನಾನು ಪಾಪಪರಿಹಾರಕ ಸಮರ್ಪಣೆಯ ಪಶುವಿನ ಮಾಂಸವನ್ನು ಈ ದಿನದಲ್ಲಿ ತಿಂದಿದ್ದರೆ ಯೆಹೋವನಿಗೆ ಒಳ್ಳೆಯದಾಗಿ ತೋರುತ್ತಿತ್ತೋ? ಇಲ್ಲ!” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ಮೋಶೆಯು ಆ ಮಾತನ್ನು ಕೇಳಿ ಒಪ್ಪಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ ಹೀಗೆಂದನು: ");
INSERT INTO kan2010_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ, ನೀವು ಈ ಪಶುಗಳನ್ನು ತಿನ್ನಬಹುದು: ");
INSERT INTO kan2010_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ಕಾಲ್ಗೊರಸು ಸೀಳಿರುವ ಮತ್ತು ಮೆಲಕು ಹಾಕುವ ಮಾಂಸವನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","“ಕೆಲವು ಪಶುಗಳು ಮೆಲಕು ಹಾಕುತ್ತವೆ, ಆದರೆ ಅವುಗಳ ಕಾಲ್ಗೊರಸು ಸೀಳಿರುವುದಿಲ್ಲ; ಅವುಗಳ ಮಾಂಸವನ್ನು ತಿನ್ನಕೂಡದು. ಒಂಟೆಗಳು, ಬೆಟ್ಟದ ಮೊಲಗಳು ಮತ್ತು ಮೊಲಗಳು ಮೆಲಕುಹಾಕುತ್ತವೆ. ಆದರೆ ಅವುಗಳ ಗೊರಸು ಸೀಳಿರುವುದಿಲ್ಲ. ಆದ್ದರಿಂದ ಅವು ನಿಮಗೆ ಅಶುದ್ಧ. ");
INSERT INTO kan2010_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ಇನ್ನು ಕೆಲವು ಪಶುಗಳ ಕಾಲ್ಗೊರಸುಗಳು ಸೀಳಿರುತ್ತವೆ. ಆದರೆ ಅವು ಮೆಲಕು ಹಾಕುವುದಿಲ್ಲ; ಅವುಗಳ ಮಾಂಸವನ್ನು ತಿನ್ನಕೂಡದು. ಹಂದಿಗಳ ಗೊರಸುಗಳು ಸೀಳಿರುತ್ತವೆ. ಆದರೆ ಮೆಲಕು ಹಾಕುವುದಿಲ್ಲ. ಆದ್ದರಿಂದ ಅವು ನಿಮಗೆ ಅಶುದ್ಧ. ");
INSERT INTO kan2010_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ಅವುಗಳ ಮಾಂಸವನ್ನು ತಿನ್ನಕೂಡದು. ಅವುಗಳ ಮೃತಶರೀರಗಳನ್ನು ಸಹ ಮುಟ್ಟಬಾರದು. ಅವು ನಿಮಗೆ ಅಶುದ್ಧ! ");
INSERT INTO kan2010_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ನೀರಿನಲ್ಲಿಯಾಗಲಿ ನದಿಯಲ್ಲಾಗಲಿ ಜೀವಿಸುವ ಜಲಪ್ರಾಣಿಗೆ ರೆಕ್ಕೆಯಿದ್ದು ಮೈಯೆಲ್ಲಾ ಪರೆಪರೆಯಿದ್ದರೆ ನೀವು ಅದನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","11","ಆದರೆ ನೀರಿನಲ್ಲಿಯಾಗಲಿ ನದಿಯಲ್ಲಾಗಲಿ ಜೀವಿಸುತ್ತಿರುವ ಜಲಪ್ರಾಣಿಗೆ ರೆಕ್ಕೆಗಳು ಮತ್ತು ಪರೆಗಳು ಇಲ್ಲದಿದ್ದರೆ, ನೀವು ಆ ಪ್ರಾಣಿಯನ್ನು ತಿನ್ನಕೂಡದು. ತಿನ್ನುವುದಕ್ಕೆ ಅಯೋಗ್ಯವಾದದ್ದೆಂದು ಯೆಹೋವನು ಹೇಳುವ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಅದು ಒಂದಾಗಿದೆ. ಆ ಪ್ರಾಣಿಯ ಮಾಂಸವನ್ನು ತಿನ್ನಕೂಡದು. ಅದರ ಮೃತಶರೀರವನ್ನೂ ಮುಟ್ಟಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ನೀರಿನಲ್ಲಿರುವ ಜಲಪ್ರಾಣಿಗೆ ರೆಕ್ಕೆಗಳು ಮತ್ತು ಪರೆಗಳು ಇಲ್ಲದಿದ್ದರೆ ಅದು ತಿನ್ನುವುದಕ್ಕೆ ಅಯೋಗ್ಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ನಿಷಿದ್ಧವಾದ ಈ ಪಕ್ಷಿಗಳ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಬಾರದು: ಗರುಡ, ಬೆಟ್ಟದ ಹದ್ದು, ಕ್ರೌಂಚ, ");
INSERT INTO kan2010_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ಹದ್ದು, ಎಲ್ಲಾ ವಿಧವಾದ ಗಿಡುಗ, ");
INSERT INTO kan2010_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ಎಲ್ಲಾ ವಿಧವಾದ ಕಾಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ಉಷ್ಟ್ರಪಕ್ಷಿ, ಉಲೂಕ, ಕಡಲ್ಹಕ್ಕಿ ಎಲ್ಲಾ ವಿಧವಾದ ಡೇಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ಗೂಬೆ, ಹೆಗ್ಗೂಬೆ, ಸಮುದ್ರಪಕ್ಷಿ, ");
INSERT INTO kan2010_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ನೀರುಕೋಳಿ, ರಣಹದ್ದು, ನೀರುಕಾಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ಕೊಕ್ಕರೆ, ಸಕಲ ವಿಧವಾದ ಬಕ, ಹೆಡೆಹಕ್ಕಿ ಮತ್ತು ಬಾವಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ಕ್ರಿಮಿಕೀಟಗಳು ರೆಕ್ಕೆಗಳುಳ್ಳದ್ದಾಗಿ ನಾಲ್ಕು ಕಾಲುಗಳಲ್ಲಿ ಹರಿದಾಡುವುದಾಗಿದ್ದರೆ ಅವು ನಿಮಗೆ ನಿಷಿದ್ಧವಾಗಿವೆ. ಆ ಕ್ರಿಮಿಕೀಟಗಳನ್ನು ತಿನ್ನಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ಆದರೆ ಕೀಟಗಳು ನೆಲದ ಮೇಲೆ ಕುಪ್ಪಳಿಸುವುದಕ್ಕೋಸ್ಕರ ಕೀಲುಗಳುಳ್ಳ ಕಾಲುಗಳನ್ನು ಹೊಂದಿದ್ದರೆ ಅವುಗಳನ್ನು ನೀವು ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ಡತೆಗಳನ್ನು, ರೆಕ್ಕೆಗಳುಳ್ಳ ಎಲ್ಲಾ ವಿಧದ ಮಿಡತೆಗಳನ್ನು, ಎಲ್ಲಾ ವಿಧವಾದ ಚಿಟ್ಟೆಮಿಡತೆಗಳನ್ನು, ಎಲ್ಲಾ ವಿಧವಾದ ಸಣ್ಣ ಮಿಡತೆಗಳನ್ನು ಸಹ ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","“ಆದರೆ ರೆಕ್ಕೆಗಳಿದ್ದು ನಾಲ್ಕು ಕಾಲುಗಳಿರುವ ಬೇರೆ ಎಲ್ಲಾ ಕ್ರಿಮಿಕೀಟಗಳನ್ನು ನೀವು ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","ಆ ಕ್ರಿಮಿಕೀಟಗಳು ನಿಮ್ಮನ್ನು ಅಶುದ್ಧ ಮಾಡುತ್ತವೆ. ಅವುಗಳ ಹೆಣಗಳನ್ನು ಮುಟ್ಟಿದವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ಯಾವನಾದರೂ ಆ ಸತ್ತ ಕ್ರಿಮಿಕೀಟಗಳಲ್ಲಿ ಒಂದನ್ನು ಎತ್ತಿದರೆ, ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದ ತನಕ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","27","“ಕೆಲವು ಪ್ರಾಣಿಗಳಿಗೆ ಸೀಳಿದ ಕಾಲ್ಗೊರಸುಗಳು ಇವೆ. ಆದರೆ ಕಾಲ್ಗೊರಸುಗಳು ಸರಿಯಾಗಿ ಎರಡು ಭಾಗಗಳಾಗಿರುವುದಿಲ್ಲ. ಕೆಲವು ಪ್ರಾಣಿಗಳು ಮೆಲಕು ಹಾಕುವುದಿಲ್ಲ. ಕೆಲವು ಪ್ರಾಣಿಗಳಿಗೆ ಕಾಲ್ಗೊರಸುಗಳು ಇರುವುದಿಲ್ಲ. ಅವು ಅಂಗಾಲುಗಳಿಂದ ನಡೆಯುತ್ತವೆ. ಆ ಎಲ್ಲಾ ಪ್ರಾಣಿಗಳು ನಿಮಗೆ ಅಶುದ್ಧ. ಅವುಗಳ ಸತ್ತದೇಹಗಳನ್ನು ಮುಟ್ಟಿದವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ಯಾವನಾದರೂ ಅವುಗಳ ಹೆಣಗಳನ್ನು ಎತ್ತಿದರೆ ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ಆ ಪ್ರಾಣಿಗಳು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಈ ಪ್ರಾಣಿಗಳು ನಿಮಗೆ ಅಶುದ್ಧ; ಮುಂಗುಸಿ, ಇಲಿ, ಎಲ್ಲಾ ವಿಧವಾದ ದೊಡ್ಡಹಲ್ಲಿ, ");
INSERT INTO kan2010_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ಹಾವರಾಣಿ, ಮೊಸಳೆ, ಹಲ್ಲಿ, ಬಸವನಹುಳ, ಚಿಟ್ಟಿಲಿ, ");
INSERT INTO kan2010_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಈ ಪ್ರಾಣಿಗಳು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿವೆ. ಅವುಗಳ ಹೆಣಗಳನ್ನು ಮುಟ್ಟಿದವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“ಅಶುದ್ಧವಾದ ಆ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಯಾವುದಾದರೂ ಸತ್ತು, ಯಾವುದೇ ವಸ್ತುವಿನ ಮೇಲೆ ಬಿದ್ದರೆ, ಆಗ ಆ ವಸ್ತುವು ಅಶುದ್ಧವಾಗುವುದು. ಅದು ಮರದ ವಸ್ತುವಾಗಲಿ ಬಟ್ಟೆಯಾಗಲಿ ಚರ್ಮವಾಗಲಿ ಶೋಕಬಟ್ಟೆಯಾಗಲಿ ಅದು ಎಂಥದ್ದಾಗಿದ್ದರೂ ಕೆಲಸಕ್ಕೆ ಉಪಯುಕ್ತವಾಗಿದ್ದರೂ ಅದನ್ನು ನೀರಿನಲ್ಲಿ ಹಾಕಬೇಕು. ಅದು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ನಂತರ ಅದು ಶುದ್ಧವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ಅಶುದ್ಧವಾದ ಆ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಯಾವುದಾದರೊಂದು ಸತ್ತು ಮಣ್ಣಿನ ಬೋಗುಣಿಗೆ ಬಿದ್ದರೆ, ಆಗ ಆ ಬೋಗುಣಿಯಲ್ಲಿ ಇರುವುದೆಲ್ಲಾ ಅಶುದ್ಧವಾಗುವುದು. ಆ ಬೋಗುಣಿಯನ್ನು ನೀವು ಒಡೆದುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ಅಶುದ್ಧವಾದ ಮಣ್ಣಿನ ಬೋಗುಣಿಯಿಂದ ನೀರು ಯಾವುದೇ ಆಹಾರಕ್ಕೆ ತಾಗಿದರೆ, ಆ ಆಹಾರವು ಅಶುದ್ಧವಾಗುವುದು. ಅಶುದ್ಧವಾದ ಬೋಗುಣಿಯಲ್ಲಿ ಯಾವುದೇ ಪಾನದ್ರವ್ಯವಿದ್ದರೂ ಅದು ಅಶುದ್ಧವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ಸತ್ತ ಪ್ರಾಣಿಯ ಯಾವುದೇ ಭಾಗ ಯಾವುದೇ ವಸ್ತುವಿನ ಮೇಲೆ ಬಿದ್ದರೂ ಆ ವಸ್ತು ಅಶುದ್ಧವಾಗಿದೆ. ಅದು ಮಣ್ಣಿನ ಒಲೆಯಾಗಿದ್ದರೂ ಮಡಿಕೆಯಾಗಿದ್ದರೂ ಅದನ್ನು ಒಡೆದುಹಾಕಬೇಕು. ಆ ವಸ್ತುಗಳು ಇನ್ನೆಂದಿಗೂ ಶುದ್ಧವಾಗಿರುವುದಿಲ್ಲ. ಅವು ನಿಮಗೆ ಯಾವಾಗಲೂ ಅಶುದ್ಧವಾಗಿರುವವು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“ಒರತೆಯಾಗಲಿ ನೀರನ್ನು ಪಡೆಯುವ ಬಾವಿಯಾಗಲಿ ಶುದ್ಧವಾಗಿರುವುದು. ಆದರೆ ಯಾವನಾದರೂ ಅಶುದ್ಧ ಪ್ರಾಣಿಗಳ ಹೆಣವನ್ನು ಮುಟ್ಟಿದರೆ, ಅವನು ಅಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ಸತ್ತ ಅಶುದ್ಧ ಪ್ರಾಣಿಗಳ ಯಾವುದೇ ಭಾಗವು ನೆಡುವುದಕ್ಕೆ ಇಟ್ಟಿರುವ ಬೀಜದ ಮೇಲೆ ಬಿದ್ದರೂ ಆ ಬೀಜ ಶುದ್ಧವಾಗಿಯೇ ಇರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ಆದರೆ ನೀರು ಹಾಕಿ ನೆನಸಿದ ಬೀಜಗಳ ಮೇಲೆ ಸತ್ತ ಅಶುದ್ಧ ಪ್ರಾಣಿಗಳ ಯಾವುದೇ ಭಾಗ ಬಿದ್ದರೆ, ಆ ಬೀಜಗಳು ನಿಮಗೆ ಅಶುದ್ಧವಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ಅಲ್ಲದೆ ನೀವು ಮಾಂಸಾಹಾರಕ್ಕಾಗಿ ಉಪಯೋಗಿಸುವ ಯಾವುದೇ ಪ್ರಾಣಿ ಸತ್ತರೆ, ಅದನ್ನು ಮುಟ್ಟುವ ವ್ಯಕ್ತಿ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ಈ ಪ್ರಾಣಿಯ ಮಾಂಸವನ್ನು ತಿನ್ನುವ ವ್ಯಕ್ತಿ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಈ ವ್ಯಕ್ತಿ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ಸತ್ತ ಪ್ರಾಣಿಯನ್ನು ಎತ್ತುವವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಈ ವ್ಯಕ್ತಿ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಕ್ರಿಮಿಕೀಟಗಳನ್ನೆಲ್ಲ ಯೆಹೋವನು ನಿಮಗೆ ನಿಷಿದ್ಧಗೊಳಿಸಿದ್ದಾನೆ. ನೀವು ಅವುಗಳ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ಹೊಟ್ಟೆಯ ಮೇಲೆ ತೆವಳಿಕೊಂಡು ಹೋಗುವ ಜಂತುವನ್ನು ಅಥವಾ ತನ್ನ ನಾಲ್ಕು ಕಾಲುಗಳಲ್ಲಿ ನಡೆಯುವ ಜಂತುವನ್ನು ಅಥವಾ ಅನೇಕ ಕಾಲುಗಳುಳ್ಳ ಜಂತುಗಳನ್ನು ನೀವು ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ಆ ಜಂತುಗಳು ನಿಮ್ಮನ್ನು ಹೊಲೆ ಮಾಡದಿರಲಿ. ನೀವು ಅಶುದ್ಧರಾಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ಯಾಕೆಂದರೆ, ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ನಾನು ಪರಿಶುದ್ಧನಾಗಿದ್ದೇನೆ, ಆದ್ದರಿಂದ ನೀವೂ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ಹರಿದಾಡುವ ಆ ಜಂತುಗಳಿಂದ ನಿಮ್ಮನ್ನು ಅಶುದ್ಧರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದ ಯೆಹೋವನೇ ನಾನು. ನೀವು ನನ್ನ ವಿಶೇಷ ಜನರಾಗಿರಬೇಕೆಂದು ಮತ್ತು ನಾನು ನಿಮ್ಮ ದೇವರಾಗಿರಬೇಕೆಂದು ನಿಮ್ಮನ್ನು ಕರೆದುಕೊಂಡು ಬಂದೆನು. ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವಂತೆಯೇ ನೀವೂ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","ಎಲ್ಲಾ ಸಾಕುಪ್ರಾಣಿಗಳು, ಪಕ್ಷಿಗಳು ಮತ್ತು ಭೂಮಿಯ ಮೇಲಿರುವ ಇತರ ಪ್ರಾಣಿಗಳ ಬಗ್ಗೆ ಇರುವ ನಿಯಮಗಳು ಇವುಗಳೇ. ಸಮುದ್ರದಲ್ಲಿರುವ ಮತ್ತು ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಎಲ್ಲಾ ಪ್ರಾಣಿಗಳ ಬಗ್ಗೆ ಇರುವ ನಿಯಮಗಳು ಇವುಗಳೇ. ");
INSERT INTO kan2010_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ಅಶುದ್ಧವಾದ ಮತ್ತು ಶುದ್ಧವಾದ ಪ್ರಾಣಿಗಳ ಕುರಿತು ತಿಳಿದುಕೊಳ್ಳಲು ನಿಮಗೆ ಈ ನಿಯಮಗಳು ಸಹಾಯಕವಾಗಿವೆ. ಜನರು ಯಾವ ಪ್ರಾಣಿಗಳ ಮಾಂಸವನ್ನು ತಿನ್ನಬಹುದು ಮತ್ತು ಯಾವುದನ್ನು ತಿನ್ನಬಾರದೆಂದು ಈ ನಿಯಮಗಳು ತಿಳಿಸುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: “ಒಬ್ಬ ಸ್ತ್ರೀಯು ಬಸುರಾಗಿ ಗಂಡುಮಗುವನ್ನು ಹೆತ್ತರೆ, ಅವಳು ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧಳಾಗಿರುವಳು. ಅವಳ ತಿಂಗಳ ಮುಟ್ಟಿನಿಂದ ಅಶುದ್ಧಳಾಗುವಂತೆಯೇ ಅಶುದ್ಧಳಾಗಿರುವಳು. ");
INSERT INTO kan2010_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಗಂಡುಮಗುವಿಗೆ ಸುನ್ನತಿ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ಆಮೇಲೆ ಅವಳು ತನ್ನ ರಕ್ತಸ್ರಾವದಿಂದ ಶುದ್ಧಳಾಗಲು ಮೂವತ್ತುಮೂರು ದಿನಗಳು ಹಿಡಿಯುವುದು. ಆಕೆ ಪರಿಶುದ್ಧವಾದ ಯಾವುದನ್ನೂ ಮುಟ್ಟಬಾರದು. ಆಕೆಯ ಶುದ್ಧೀಕರಣ ಪೂರ್ತಿಯಾಗುವವರೆಗೆ ಆಕೆ ಪವಿತ್ರಸ್ಥಳವನ್ನು ಪ್ರವೇಶಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ಆದರೆ ಸ್ತ್ರೀಯು ಹೆಣ್ಣುಮಗುವಿಗೆ ಜನ್ಮವಿತ್ತರೆ, ಅವಳು ಆಕೆಯ ತಿಂಗಳ ಮುಟ್ಟಿನಿಂದ ಅಶುದ್ಧಳಾಗುವಂತೆ ಎರಡು ವಾರಗಳವರೆಗೆ ಅಶುದ್ಧಳಾಗಿರುವಳು. ಆಕೆಯು ರಕ್ತಸ್ರಾವದಿಂದ ಶುದ್ಧಳಾಗಲು ಅರವತ್ತಾರು ದಿನಗಳು ಹಿಡಿಯುವವು. ");
INSERT INTO kan2010_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ಶುದ್ಧೀಕರಣ ಸಮಯ ಪೂರ್ತಿಯಾದ ನಂತರ ಹೆಣ್ಣುಮಗುವಿನ ಅಥವಾ ಗಂಡುಮಗುವಿನ ತಾಯಿಯು ವಿಶೇಷ ಯಜ್ಞಗಳನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲ ಬಳಿಗೆ ತಂದು ಅವುಗಳನ್ನು ಯಾಜಕನಿಗೆ ಕೊಡಬೇಕು. ಆಕೆಯು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಯನ್ನೂ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಬೆಳವಕ್ಕಿಯನ್ನಾಗಲಿ ಅಥವಾ ಪಾರಿವಾಳದ ಮರಿಯನ್ನಾಗಲಿ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","8","ಆಕೆಯು ಕುರಿಮರಿಯನ್ನು ತರಲು ಶಕ್ತಳಾಗಿಲ್ಲದಿದ್ದರೆ, ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತರಬಹುದು. ಅವುಗಳಲ್ಲಿ ಒಂದನ್ನು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿಯೂ ಇನ್ನೊಂದನ್ನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿಯೂ ತರಬೇಕು. ಯಾಜಕನು ಅವುಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಆಕೆಯನ್ನು ಶುದ್ಧಿಗೊಳಿಸುವನು. ಆಗ ಆಕೆಯು ರಕ್ತಸ್ರಾವದ ಅಶುದ್ಧತೆಯಿಂದ ಶುದ್ಧಳಾಗುವಳು. ಗಂಡುಮಗುವಿಗೆ ಅಥವಾ ಹೆಣ್ಣುಮಗುವಿಗೆ ಜನ್ಮವಿತ್ತ ಸ್ತ್ರೀಯು ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮಗಳು ಇವುಗಳೇ.” ");
INSERT INTO kan2010_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ಒಬ್ಬ ಮನುಷ್ಯನ ಮೇಲೆ ಊತವಾಗಲಿ ಗುಳ್ಳೆಯಾಗಲಿ ಹೊಳೆಯುವ ಮಚ್ಚೆಯಾಗಲಿ ಉಂಟಾಗಿ ಮಚ್ಚೆಯು ಕುಷ್ಠರೋಗದಂತೆ ಕಂಡುಬಂದರೆ, ಅವನನ್ನು ಯಾಜಕನಾದ ಆರೋನನ ಬಳಿಗೆ ಅಥವಾ ಯಾಜಕರಾದ ಅವನ ಪುತ್ರರಲ್ಲಿ ಒಬ್ಬನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ಯಾಜಕನು ಅವನ ಚರ್ಮದಲ್ಲಿರುವ ಮಚ್ಚೆಯನ್ನು ನೋಡಬೇಕು. ಮಚ್ಚೆಯಲ್ಲಿರುವ ರೋಮವು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ ಮತ್ತು ಮಚ್ಚೆಯು ಅವನ ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿದ್ದರೆ ಅದು ಕುಷ್ಠರೋಗವಾಗಿದೆ. ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸಿದ ನಂತರ ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“ಕೆಲವು ಬಾರಿ ಒಬ್ಬ ವ್ಯಕ್ತಿಯ ಚರ್ಮದ ಮೇಲೆ ಬಿಳಿ ಮಚ್ಚೆ ಇರುತ್ತದೆ. ಆದರೆ ಮಚ್ಚೆಯು ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿರದಿದ್ದರೆ ಮತ್ತು ಅದರ ರೋಮ ಬೆಳ್ಳಗಾಗಿಲ್ಲದಿದ್ದರೆ ಯಾಜಕನು ಅವನನ್ನು ಬೇರೆ ಜನರಿಂದ ಏಳು ದಿನಗಳವರೆಗೆ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಮಚ್ಚೆಯು ಬದಲಾಗದೆ ಚರ್ಮದ ಮೇಲೆ ಹರಡಲಿಲ್ಲವೆಂದು ಯಾಜಕನು ಕಂಡರೆ, ಯಾಜಕನು ಅವನನ್ನು ಇನ್ನೂ ಏಳು ದಿನಗಳವರೆಗೆ ಇತರ ಜನರಿಂದ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ಏಳು ದಿನಗಳ ನಂತರ ಯಾಜಕನು ಮತ್ತೆ ಅವನನ್ನು ನೋಡಬೇಕು. ಮಚ್ಚೆಯು ಮೊಬ್ಬಾಗಿ ಚರ್ಮದಲ್ಲಿ ಹರಡದೆ ಇದ್ದರೆ, ಆಗ ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಯಾಕೆಂದರೆ ಮಚ್ಚೆಯು ಕೇವಲ ಗುಳ್ಳೆಯಾಗಿದೆ. ಆ ವ್ಯಕ್ತಿ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ತಿರುಗಿ ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","“ಆದರೆ ಆ ವ್ಯಕ್ತಿಯ ಗುಳ್ಳೆಯು ಚರ್ಮದ ಮೇಲೆ ಹೆಚ್ಚಾಗಿ ಹರಡಿದರೆ, ಆ ವ್ಯಕ್ತಿಯು ಯಾಜಕನ ಬಳಿಗೆ ಮತ್ತೆ ಬರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ಯಾಜಕನು ಪರೀಕ್ಷಿಸಿದಾಗ ಗುಳ್ಳೆಯು ಚರ್ಮದ ಮೇಲೆ ಹರಡಿದ್ದರೆ, ಯಾಜಕನು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಅದು ಕುಷ್ಠರೋಗವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ಒಬ್ಬನಿಗೆ ಕುಷ್ಠವಿದ್ದರೆ, ಅವನನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ನೋಡಬೇಕು. ಚರ್ಮದ ಮೇಲೆ ಬೆಳ್ಳಗಾದ ಊತವಿದ್ದರೆ, ರೋಮವು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ ಮತ್ತು ಚರ್ಮವು ಊತದಿಂದ ಹಸಿಯಾಗಿ ಕಂಡರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ಅದು ಬಹಳ ಕಾಲದಿಂದ ಅವನ ಚರ್ಮದಲ್ಲಿರುವ ಕುಷ್ಠರೋಗವಾಗಿದೆ. ಯಾಜಕನು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸುವುದಕ್ಕಾಗಿ ಸ್ವಲ್ಪ ಸಮಯದವರೆಗೆ ಜನರಿಂದ ಪ್ರತ್ಯೇಕಿಸುವುದಿಲ್ಲ. ಯಾಕೆಂದರೆ ಆ ವ್ಯಕ್ತಿಯು ಈಗಾಗಲೇ ಅಶುದ್ಧನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“ಕೆಲವು ಬಾರಿ ಚರ್ಮರೋಗವು ಒಬ್ಬನ ಮೈಯೆಲ್ಲಾ ಹರಡಿಕೊಳ್ಳುವುದು. ಚರ್ಮರೋಗವು ಅವನನ್ನು ತಲೆಯಿಂದ ಅಂಗಾಲಿನವರೆಗೂ ಮುಚ್ಚಿಕೊಳ್ಳುವುದು. ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯ ಇಡೀ ದೇಹವನ್ನು ನೋಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ಚರ್ಮರೋಗವು ಇಡೀ ದೇಹವನ್ನು ವ್ಯಾಪಿಸಿ ಆ ವ್ಯಕ್ತಿಯ ಚರ್ಮವು ಬಿಳಿ ಬಣ್ಣಕ್ಕೆ ತಿರುಗಿರುವುದನ್ನು ಯಾಜಕನು ಕಂಡರೆ, ಆ ವ್ಯಕ್ತಿಯು ಶುದ್ಧನೆಂದು ಯಾಜಕನು ಪ್ರಕಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ಆದರೆ ಆ ವ್ಯಕ್ತಿಯ ಚರ್ಮವು ಹಸಿಯಾಗಿದ್ದರೆ, ಆ ವ್ಯಕ್ತಿಯು ಶುದ್ಧನಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ಯಾಜಕನು ಹಸಿಯಾದ ಚರ್ಮವನ್ನು ನೋಡಿದಾಗ, ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಹಸಿಯಾದ ಚರ್ಮವು ಶುದ್ಧವಲ್ಲ. ಅದು ಕುಷ್ಠರೋಗವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“ಹಸಿಯಾದ ಚರ್ಮವು ಬದಲಾಗಿ ಬಿಳಿಯಾದರೆ, ಆಗ ಆ ವ್ಯಕ್ತಿ ಯಾಜಕನ ಬಳಿಗೆ ಬರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ಯಾಜಕನು ಅವನನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಮಚ್ಚೆಯು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ, ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಆ ವ್ಯಕ್ತಿಯು ಶುದ್ಧನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ಒಬ್ಬನ ಚರ್ಮದ ಮೇಲೆ ಹುಣ್ಣು ಎದ್ದಿದ್ದು ವಾಸಿಯಾಗಿದ್ದಿರಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ಆದರೆ ಹುಣ್ಣಿದ್ದ ಜಾಗದಲ್ಲಿ ಬೆಳ್ಳಗಾದ ಊತವಿದ್ದರೆ ಅಥವಾ ಕೆಂಪುಬಿಳುಪು ಮಿಶ್ರವಾದ ಹೊಳೆಯುವ ಮಚ್ಚೆಯಿದ್ದರೆ, ಚರ್ಮದ ಈ ಭಾಗವನ್ನು ಯಾಜಕನಿಗೆ ತೋರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಅದು ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿದ್ದರೆ ಮತ್ತು ಅದರ ಮೇಲಿರುವ ರೋಮವು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ, ಯಾಜಕನು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಆ ಕಲೆಯು ಕುಷ್ಠದ ಸೋಂಕಾಗಿದೆ. ಹುಣ್ಣಿನಿಂದ ಕುಷ್ಠ ಬಂದಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ಆದರೆ ಯಾಜಕನು ಮಚ್ಚೆಯನ್ನು ನೋಡಿದಾಗ ಅದರಲ್ಲಿ ಬಿಳಿರೋಮಗಳು ಇಲ್ಲದಿದ್ದರೆ, ಮಚ್ಚೆಯು ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿಲ್ಲದೆ ಮೊಬ್ಬಾಗಿ ಹೋಗಿದ್ದರೆ, ಆಗ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಏಳು ದಿನಗಳವರೆಗೆ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ಮಚ್ಚೆಯು ಚರ್ಮದಲ್ಲಿ ಹರಡಿದರೆ, ಯಾಜಕನು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಅದು ಸೋಂಕುರೋಗವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ಆದರೆ ಹೊಳೆಯುವ ಮಚ್ಚೆಯು ತನ್ನ ಸ್ಥಳದಲ್ಲಿಯೇ ಇದ್ದು ಹರಡದಿದ್ದರೆ, ಆಗ ಅದು ಕೇವಲ ಹುಣ್ಣಿನ ಮಚ್ಚೆಯಾಗಿದೆ. ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","25","“ಒಬ್ಬನ ದೇಹದ ಚರ್ಮದಲ್ಲಿ ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟಗಾಯ ಉಂಟಾಗಬಹುದು. ಹಸಿಯಾದ ಚರ್ಮವು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ, ಕೆಂಪುಬಿಳುಪು ಮಿಶ್ರವಾದ ಮಚ್ಚೆಯುಳ್ಳದ್ದಾಗಿದ್ದರೆ, ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಆ ಬಿಳಿ ಕಲೆ ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿದ್ದರೆ ಮತ್ತು ಆ ಕಲೆಯಲ್ಲಿನ ರೋಮವು ಬೆಳ್ಳಗಾಗಿದ್ದರೆ, ಅದು ಕುಷ್ಠರೋಗವಾಗಿದೆ. ಆ ಕುಷ್ಠವು ಸುಟ್ಟಗಾಯದಲ್ಲಿ ಹುಟ್ಟಿದ್ದಾಗಿದೆ. ಆಗ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಅದು ಕುಷ್ಠರೋಗವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ಆದರೆ ಯಾಜಕನು ಮಚ್ಚೆಯನ್ನು ನೋಡಲಾಗಿ ಹೊಳೆಯುವ ಮಚ್ಚೆಯಲ್ಲಿ ಬಿಳಿರೋಮವಿಲ್ಲದೆ ಮತ್ತು ಮಚ್ಚೆಯು ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿಲ್ಲದೆ ಮೊಬ್ಬಾಗಿ ಹೋಗುತ್ತಿದ್ದರೆ, ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಏಳು ದಿನಗಳವರೆಗೆ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಮತ್ತೆ ಆ ವ್ಯಕ್ತಿಯನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಮಚ್ಚೆಯು ಚರ್ಮದ ಮೇಲೆ ಹರಡಿದ್ದರೆ, ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಅದು ಕುಷ್ಠರೋಗವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ಆದರೆ ಹೊಳೆಯುವ ಮಚ್ಚೆಯು ಚರ್ಮದ ಮೇಲೆ ಉಂಟಾದ ಊತವಾಗಿದೆ. ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಅದು ಕೇವಲ ಸುಟ್ಟಗಾಯದಿಂದ ಉಂಟಾದ ಮಚ್ಚೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ಒಬ್ಬ ಗಂಡಸಿನ ಅಥವಾ ಹೆಂಗಸಿನ ತಲೆಯ ನೆತ್ತಿಯಲ್ಲಿ ಅಥವಾ ಗಡ್ಡದಲ್ಲಿ ಸೋಂಕು ತಗಲಿ ಕಲೆ ಉಂಟಾಗಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ಯಾಜಕನು ಆ ಕಲೆಯನ್ನು ನೋಡಬೇಕು. ಸೋಂಕಿನ ಕಲೆಯು ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿದ್ದರೆ ಮತ್ತು ಅದರಲ್ಲಿರುವ ರೋಮವು ತೆಳ್ಳಗಾಗಿಯೂ ಹಳದಿಯಾಗಿಯೂ ಇದ್ದರೆ, ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಅದು ತಲೆಯ ಅಥವಾ ಗಡ್ಡದ ಕೆಟ್ಟ ಚರ್ಮರೋಗವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ರೋಗವು ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿಲ್ಲವೆಂದು ಕಂಡುಬಂದರೂ ಅದರಲ್ಲಿ ಕಪ್ಪಾದ ಕೂದಲು ಇಲ್ಲದ್ದಿದ್ದರೆ, ಆಗ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಏಳು ದಿನಗಳವರೆಗೆ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಸೋಂಕು ತಗಲಿದ ಜಾಗವನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ರೋಗವು ಹರಡಿಕೊಳ್ಳದೆ ಇದ್ದರೆ ಮತ್ತು ಅದು ಇರುವ ಕಡೆ ಹಳದಿಬಣ್ಣದ ಕೂದಲು ಬೆಳೆಯುತ್ತಿಲ್ಲವಾಗಿದ್ದರೆ ಮತ್ತು ರೋಗವು ಉಳಿದ ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿ ತೋರದಿದ್ದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ಆಗ ಆ ವ್ಯಕ್ತಿಯು ಕ್ಷೌರ ಮಾಡಿಸಿಕೊಳ್ಳಬೇಕು. ಆದರೆ ಅವನು ರೋಗ ಇರುವ ಜಾಗದಲ್ಲಿ ಕ್ಷೌರ ಮಾಡಿಸಿಕೊಳ್ಳಬಾರದು. ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಇನ್ನೂ ಏಳು ದಿನಗಳವರೆಗೆ ಪ್ರತ್ಯೇಕವಾಗಿ ಇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ರೋಗವನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ರೋಗವು ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಳ್ಳದಿದ್ದರೆ ಮತ್ತು ಅದು ಚರ್ಮಕ್ಕಿಂತ ತಗ್ಗಾಗಿ ತೋರದಿದ್ದರೆ ಆಗ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ಆದರೆ ಅವನು ಶುದ್ಧನಾದ ನಂತರ, ರೋಗವು ಚರ್ಮದ ಮೇಲೆ ಹರಡಿದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಮತ್ತೆ ಪರೀಕ್ಷಿಸಬೇಕು. ರೋಗವು ಚರ್ಮದಲ್ಲಿ ಹರಡಿಕೊಂಡಿದ್ದರೆ, ಯಾಜಕನು ಹಳದಿ ಬಣ್ಣದ ಕೂದಲು ಇದೆಯೋ ಇಲ್ಲವೋ ಎಂದು ನೋಡಬೇಕಾದ ಅಗತ್ಯವಿಲ್ಲ. ಅವನು ಅಶುದ್ಧನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ಆದರೆ ರೋಗವು ನಿಂತುಹೋಗಿ, ಕಪ್ಪಾದ ಕೂದಲು ಆ ಜಾಗದಲ್ಲಿ ಬೆಳೆಯುತ್ತಿದ್ದರೆ, ರೋಗವು ವಾಸಿಯಾಗಿದೆ ಎಂದರ್ಥ. ಆ ವ್ಯಕ್ತಿಯು ಶುದ್ಧನಾಗಿದ್ದಾನೆ. ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ಒಬ್ಬ ಗಂಡಸಿನ ಅಥವಾ ಹೆಂಗಸಿನ ಚರ್ಮದ ಮೇಲೆ ಬಿಳಿ ಕಲೆಗಳು ಇದ್ದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ಯಾಜಕನು ಆ ಕಲೆಗಳನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಆ ವ್ಯಕ್ತಿಯ ಚರ್ಮದ ಮೇಲಿರುವ ಕಲೆಗಳು ಬರೀ ಮೊಬ್ಬಾದ ಬಿಳೀ ಬಣ್ಣದವುಗಳಾಗಿದ್ದರೆ, ಆಗ ರೋಗವು ಕೇವಲ ಚರ್ಮದಲ್ಲಿ ಹುಟ್ಟಿದ ಚಿಬ್ಬಾಗಿದೆ. ಆ ವ್ಯಕ್ತಿಯು ಶುದ್ಧನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ಒಬ್ಬ ಮನುಷ್ಯನ ತಲೆಕೂದಲು ಉದುರಿಹೋಗುತ್ತಿದ್ದರೆ ಅವನು ಶುದ್ಧನಾಗಿದ್ದಾನೆ. ಅವನು ಬೋಳುತಲೆಯವನಷ್ಟೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ಒಬ್ಬನ ತಲೆಯ ಪಾರ್ಶ್ವಗಳಿಂದ ಕೂದಲು ಉದುರಿಹೋಗುತ್ತಿದ್ದರೆ, ಅದು ಇನ್ನೊಂದು ರೀತಿಯ ಬೋಳುತಲೆಯಷ್ಟೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ಆದರೆ ಅವನ ನೆತ್ತಿಯ ಮೇಲೆ ಕೆಂಪು ಬಿಳುಪು ಮಿಶ್ರಿತವಾದ ಸೋಂಕಿನ ಚಿಹ್ನೆ ಇದ್ದರೆ, ಅದು ಚರ್ಮರೋಗವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಸೋಂಕಿನಿಂದ ಉಂಟಾದ ಊತ ಕೆಂಪು ಬಿಳುಪು ಮಿಶ್ರವಾಗಿ ಚರ್ಮದಲ್ಲಿ ಕುಷ್ಠದಂತೆ ತೋರಿದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ಆಗ ಆ ವ್ಯಕ್ತಿಯ ತಲೆಯಲ್ಲಿ ಕುಷ್ಠರೋಗವಿದೆ. ಅವನು ಅಶುದ್ಧನಾಗಿದ್ದಾನೆ. ಯಾಜಕನು ಅವನನ್ನು ಅಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ಒಬ್ಬನಿಗೆ ಕುಷ್ಠರೋಗವಿದ್ದರೆ, ಅವನು ಬೇರೆ ಜನರಿಗೆ ಎಚ್ಚರಿಕೆ ಕೊಡಬೇಕು. ‘ನಾನು ಅಶುದ್ಧನು, ಅಶುದ್ಧನು’ ಎಂದು ಅವನು ಕೂಗಿಕೊಳ್ಳಬೇಕು. ಆ ವ್ಯಕ್ತಿಯು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡಿರಬೇಕು; ತನ್ನ ಕೂದಲನ್ನು ಕೆದರಿಕೊಂಡಿರಬೇಕು; ತನ್ನ ಬಾಯಿಯನ್ನು ಬಟ್ಟೆಯಿಂದ ಮುಚ್ಚಿಕೊಂಡಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ಆ ವ್ಯಕ್ತಿಯು ತನಗೆ ರೋಗವಿರುವ ಕಾಲವೆಲ್ಲಾ ಅಶುದ್ಧನಾಗಿರುವನು. ಆ ವ್ಯಕ್ತಿಯು ಅಶುದ್ಧನಾಗಿದ್ದಾನೆ. ಅವನು ಒಂಟಿಯಾಗಿ ವಾಸಿಸಬೇಕು. ಅವನ ನಿವಾಸವು ಪಾಳೆಯದ ಹೊರಗೆ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","“ಕೆಲವು ಬಟ್ಟೆಗಳಲ್ಲಿ ಬೂಷ್ಟು ಇರಬಹುದು. ಅದು ನಾರಿನ ಬಟ್ಟೆಯಾಗಲಿ ಉಣ್ಣೆ ಬಟ್ಟೆಯಾಗಲಿ ಆಗಿರಬಹುದು. ಅದು ಹೆಣೆದ ಅಥವಾ ಹೊಲಿದ ಬಟ್ಟೆಯಾಗಿರಬಹುದು. ಚರ್ಮದಿಂದ ಮಾಡಿದ ವಸ್ತುವಿನ ಮೇಲೂ ಬೂಷ್ಟು ಇರಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ಹಸಿರು ಅಥವಾ ಕೆಂಪು ಬಣ್ಣದ ಬೂಷ್ಟು ಬಟ್ಟೆಯ, ಚರ್ಮದ, ನೇಯ್ದ ಮತ್ತು ಹೆಣೆದ ಸಾಮಗ್ರಿಗಳ ಮೇಲೆ ಇದ್ದರೆ, ಆಗ ಅದನ್ನು ಯಾಜಕನಿಗೆ ತೋರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ಯಾಜಕನು ಬೂಷ್ಟನ್ನು ನೋಡಬೇಕು. ಅವನು ಆ ವಸ್ತುವನ್ನು ಏಳು ದಿನಗಳವರೆಗೆ ಪ್ರತ್ಯೇಕವಾದ ಸ್ಥಳದಲ್ಲಿರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","52","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಬೂಷ್ಟನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಅದು ಚರ್ಮದ ಮೇಲಾಗಲಿ ಬಟ್ಟೆಯ ಮೇಲಾಗಲಿ ನೇಯ್ದ ಅಥವಾ ಹೆಣೆದ ಬಟ್ಟೆಯ ಮೇಲಾಗಲಿ ಇದ್ದರೆ ಅದನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಬೂಷ್ಟು ಹರಡಿದ್ದರೆ, ಆ ಬಟ್ಟೆ ಅಥವಾ ತೊಗಲು ಅಶುದ್ಧವಾಗಿದೆ. ಯಾಜಕನು ಅದನ್ನು ಸುಟ್ಟುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ಬೂಷ್ಟು ಬಟ್ಟೆಯ ಮೇಲಾಗಲಿ ಚರ್ಮದ ಮೇಲಾಗಲಿ ನೇಯ್ದ ಅಥವಾ ಹೆಣೆದ ಬಟ್ಟೆಯ ಮೇಲಾಗಲಿ ಹರಡಿಲ್ಲವೆಂದು ಯಾಜಕನು ಕಂಡರೆ, ಅದನ್ನು ತೊಳೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ಯಾಜಕನು ಆ ತೊಗಲನ್ನು ಅಥವಾ ಬಟ್ಟೆಯನ್ನು ತೊಳೆಯಲು ಜನರಿಗೆ ಅಪ್ಪಣೆಕೊಡಬೇಕು. ಬಳಿಕ ಯಾಜಕನು ಆ ಬಟ್ಟೆಯನ್ನು ಇನ್ನೂ ಏಳು ದಿನಗಳವರೆಗೆ ಪ್ರತ್ಯೇಕವಾಗಿರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ಆ ಸಮಯದನಂತರ ಯಾಜಕನು ಅದನ್ನು ತಿರುಗಿ ಪರೀಕ್ಷಿಸಬೇಕು. ಬೂಷ್ಟು ಇನ್ನೂ ಹಾಗೆಯೇ ಇರುವಂತೆ ಕಂಡರೆ, ಆಗ ಆ ವಸ್ತು ಅಶುದ್ಧವಾಗಿದೆ. ಅದು ಹರಡಲಿಲ್ಲವಾದರೂ ನೀವು ಬಟ್ಟೆಯನ್ನು ಅಥವಾ ತೊಗಲನ್ನು ಸುಟ್ಟುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“ಆದರೆ ಯಾಜಕನು ತೊಗಲನ್ನಾಗಲಿ ಬಟ್ಟೆಯನ್ನಾಗಲಿ ನೋಡಿದಾಗ, ತೊಳೆದನಂತರ ಬೂಷ್ಟು ಮೊಬ್ಬಾಗಿರುವುದನ್ನು ಕಂಡರೆ, ಆಗ ಯಾಜಕನು ಕಲೆ ಇರುವ ಆ ಬಟ್ಟೆಯ ಅಥವಾ ತೊಗಲಿನ ಭಾಗವನ್ನು ಕತ್ತರಿಸಿಹಾಕಬೇಕು. (ಅದು ನೇಯ್ದ ಬಟ್ಟೆಯಾಗಿದ್ದರೂ ಸರಿ, ಹೆಣೆದ ಬಟ್ಟೆಯಾಗಿದ್ದರೂ ಸರಿ.) ");
INSERT INTO kan2010_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ಆದರೆ ಬೂಷ್ಟು ಆ ತೊಗಲಿನ ಮೇಲೆ ಅಥವಾ ಬಟ್ಟೆಯ ಮೇಲೆ ಮರಳಿ ಬಂದರೆ, ಆಗ ಆ ಬೂಷ್ಟು ಹರಡುತ್ತಿದೆ ಎಂದರ್ಥ. ಆ ತೊಗಲನ್ನು ಅಥವಾ ಆ ಬಟ್ಟೆಯನ್ನು ಸುಟ್ಟುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ಆದರೆ, ತೊಳೆದ ನಂತರ ಬೂಷ್ಟು ತಿರುಗಿ ಬಾರದಿದ್ದರೆ, ಆ ತೊಗಲು ಅಥವಾ ಬಟ್ಟೆ ಶುದ್ಧವಾಗಿದೆ. ಅದು ಹೆಣೆದ ಅಥವಾ ಹೊಲಿದ ಬಟ್ಟೆಯಾಗಿದ್ದರೂ ಶುದ್ಧವಾಗಿದೆ.” ");
INSERT INTO kan2010_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ಚರ್ಮದ ವಸ್ತುಗಳ ಮೇಲಾಗಲಿ ಬಟ್ಟೆಯ ಮೇಲಾಗಲಿ (ಅದು ಉಣ್ಣೆಯದ್ದಾಗಿರಲಿ ನಾರಿನದ್ದಾಗಿರಲಿ ನೇಯ್ದದ್ದಾಗಿರಲಿ ಅಥವಾ ಹೆಣೆದದ್ದಾಗಿರಲಿ) ಕಂಡು ಬರುವ ಬೂಷ್ಟಿನ ವಿಷಯದಲ್ಲಿ ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮಗಳು ಇವೇ. ಶುದ್ಧವಾದವುಗಳೋ ಅಶುದ್ಧವಾದವುಗಳೋ ಎಂದು ನಿರ್ಧಾರ ಮಾಡಲು ಇದೇ ನಿಯಮಗಳನ್ನು ಅನುಸರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“ಚರ್ಮರೋಗವಿದ್ದು ವಾಸಿಯಾದ ಜನರು ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮಗಳು ಇಂತಿವೆ. ಇವರನ್ನು ಶುದ್ಧೀಕರಣಕ್ಕಾಗಿ ಯಾಜಕನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದಾಗ ಅನುಸರಿಸತಕ್ಕ ನಿಯಮಗಳು ಯಾವುವೆಂದರೆ: “ಚರ್ಮರೋಗವಿದ್ದ ವ್ಯಕ್ತಿಯನ್ನು ಯಾಜಕನು ಪರೀಕ್ಷಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ಯಾಜಕನು ಪಾಳೆಯದ ಹೊರಗೆ ಹೋಗಿ ಆ ವ್ಯಕ್ತಿಯ ಚರ್ಮರೋಗ ವಾಸಿಯಾಗಿದೆಯೋ ಇಲ್ಲವೋ ಎಂದು ನೋಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ಆ ವ್ಯಕ್ತಿಯು ಆರೋಗ್ಯವಂತನಾಗಿದ್ದರೆ, ಆಗ ಯಾಜಕನು ಈ ಸಂಗತಿಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ಅವನಿಗೆ ಹೇಳುವನು. ಆ ವ್ಯಕ್ತಿಯು ಎರಡು ಜೀವಂತವಾದ ಶುದ್ಧ ಪಕ್ಷಿಗಳನ್ನು ತರಬೇಕು. ಅಲ್ಲದೆ, ಅವನು ದೇವದಾರುಮರದ ತುಂಡನ್ನು, ಕೆಂಪು ಬಣ್ಣದ ಬಟ್ಟೆಯ ತುಂಡನ್ನು ಮತ್ತು ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಬರಲನ್ನು ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ಬಳಿಕ ಒಂದು ಪಕ್ಷಿಯನ್ನು ಸೆಲೇ ನೀರಿನ ಮೇಲೆ ಮಣ್ಣಿನ ಪಾತ್ರೆಯಲ್ಲಿ ವಧಿಸಬೇಕೆಂದು ಯಾಜಕನು ಅಪ್ಪಣೆ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ಯಾಜಕನು ಸಜೀವವಾದ ಎರಡನೆಯ ಪಕ್ಷಿಯನ್ನು, ದೇವದಾರುಮರದ ತುಂಡನ್ನು, ಕೆಂಪುಬಣ್ಣದ ಬಟ್ಟೆಯ ತುಂಡನ್ನು ಮತ್ತು ಹಿಸ್ಸೋಪ್ ಗಿಡವನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಸೆಲೇ ನೀರಿನ ಮೇಲೆ ವಧಿಸಲ್ಪಟ್ಟ ಪಕ್ಷಿಯ ರಕ್ತದಲ್ಲಿ ಜೀವಂತವಾಗಿರುವ ಪಕ್ಷಿಯನ್ನು ಮತ್ತು ಇತರ ವಸ್ತುಗಳನ್ನು ಅದ್ದಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ಯಾಜಕನು ಚರ್ಮರೋಗವಿದ್ದ ವ್ಯಕ್ತಿಯ ಮೇಲೆ ರಕ್ತವನ್ನು ಏಳುಸಲ ಚಿಮಿಕಿಸಬೇಕು. ಆ ವ್ಯಕ್ತಿಯನ್ನು ಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸಬೇಕು. ಬಳಿಕ ಯಾಜಕನು ಬಯಲಿಗೆ ಹೋಗಿ ಜೀವಂತವಾಗಿರುವ ಪಕ್ಷಿಯನ್ನು ಬಿಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“ಬಳಿಕ ಆ ವ್ಯಕ್ತಿ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಅವನು ಸರ್ವಾಂಗಕ್ಷೌರ ಮಾಡಿಕೊಂಡು ಸ್ನಾನ ಮಾಡಬೇಕು. ಆಗ ಅವನು ಶುದ್ಧನಾಗುವನು. ಬಳಿಕ ಆ ವ್ಯಕ್ತಿ ಪಾಳೆಯದೊಳಗೆ ಹೋಗಬಹುದು. ಆದರೆ ಅವನು ತನ್ನ ಡೇರೆಯಿಂದ ಏಳು ದಿನಗಳವರೆಗೆ ಹೊರಗೆ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ಏಳನೆಯ ದಿನದಲ್ಲಿ ಅವನು ತನ್ನ ಎಲ್ಲಾ ಕೂದಲನ್ನು ಕ್ಷೌರ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ಅವನು ತನ್ನ ತಲೆಯ, ಗಡ್ಡದ ಮತ್ತು ಹುಬ್ಬಿನ ಕೂದಲನ್ನು, ಹೌದು, ಎಲ್ಲಾ ಕೂದಲನ್ನು ಕ್ಷೌರ ಮಾಡಿಸಿಕೊಳ್ಳಬೇಕು. ಬಳಿಕ ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಅಂದಿನಿಂದ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಅವನು ಯಾವ ದೋಷವಿಲ್ಲದ ಎರಡು ಟಗರುಗಳನ್ನೂ ಒಂದು ವರ್ಷದ ಹೆಣ್ಣು ಕುರಿಮರಿಯನ್ನೂ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಇಪ್ಪತ್ತನಾಲ್ಕು ಬಟ್ಟಲು ಶ್ರೇಷ್ಠ ಗೋಧಿಹಿಟ್ಟನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ಈ ಶ್ರೇಷ್ಠ ಗೋಧಿಹಿಟ್ಟು ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿರುತ್ತದೆ. ಅವನು ಒಂದು ಸೇರು ಆಲಿವ್ ಎಣ್ಣೆಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ಯಾಜಕನು ಅವನನ್ನೂ ಅವನ ಸಮರ್ಪಣೆಗಳನ್ನೂ ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿನಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. (ಈ ಯಾಜಕನೇ ಅವನನ್ನು ಶುದ್ಧನೆಂದು ಪ್ರಕಟಿಸುವವನಾಗಿರುತ್ತಾನೆ.) ");
INSERT INTO kan2010_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ಯಾಜಕನು ಟಗರುಗಳಲ್ಲಿ ಒಂದನ್ನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸುವನು. ಅವನು ಆ ಟಗರನ್ನೂ ಎಣ್ಣೆಯನ್ನೂ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯ ಸಮರ್ಪಣೆಯಾಗಿ ನಿವಾಳಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ಬಳಿಕ ಯಾಜಕನು ಪಾಪಪರಿಹಾರಕ ಮತ್ತು ಸರ್ವಾಂಗಹೋಮ ಯಜ್ಞಪಶುಗಳನ್ನು ವಧಿಸುವ ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಟಗರನ್ನು ವಧಿಸುವನು. ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದಂತಿದೆ. ಅದು ಯಾಜಕನಿಗೆ ಸೇರುತ್ತದೆ. ಅದು ಬಹಳ ಪವಿತ್ರವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“ಯಾಜಕನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಪಶುವಿನ ರಕ್ತದಿಂದ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಶುದ್ಧನಾಗಿ ಮಾಡಲ್ಪಡುವ ವ್ಯಕ್ತಿಯ ಬಲಗಿವಿಯ ತುದಿಗೂ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಬಲಗಾಲಿನ ಹೆಬ್ಬೆರಳಿಗೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ಅಲ್ಲದೆ ಯಾಜಕನು ಸ್ವಲ್ಪ ಎಣ್ಣೆಯನ್ನು ತೆಗೆದುಕೊಂಡು ತನ್ನ ಎಡಗೈಗೆ ಹೊಯ್ದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ಬಳಿಕ ಯಾಜಕನು ತನ್ನ ಬಲಗೈಯ ಬೆರಳನ್ನು ತನ್ನ ಎಡಗೈಯಲ್ಲಿರುವ ಎಣ್ಣೆಯಲ್ಲಿ ಅದ್ದಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಎಣ್ಣೆಯನ್ನು ಏಳುಸಲ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ಯಾಜಕನು ತನ್ನ ಅಂಗೈಯಲ್ಲಿರುವ ಎಣ್ಣೆಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಶುದ್ಧನಾಗಲಿರುವ ವ್ಯಕ್ತಿಯ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಪಶುವಿನ ರಕ್ತವನ್ನು ಹಚ್ಚಿದ ಸ್ಥಳದಲ್ಲಿಯೇ ಅಂದರೆ ಬಲಗಿವಿಯ ತುದಿಗೆ, ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೆ, ಬಲಗಾಲಿನ ಹೆಬ್ಬೆರಳಿಗೆ ಹಚ್ಚುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ಯಾಜಕನು ತನ್ನ ಅಂಗೈಯಲ್ಲಿ ಉಳಿದ ಎಣ್ಣೆಯನ್ನು ಶುದ್ಧನಾಗಿ ಮಾಡಲ್ಪಡುವ ವ್ಯಕ್ತಿಯ ತಲೆಗೆ ಹಚ್ಚುವನು. ಹೀಗೆ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಶುದ್ಧನನ್ನಾಗಿ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“ತರುವಾಯ ಯಾಜಕನು ಶುದ್ಧನಾಗಿ ಮಾಡಲ್ಪಡುವ ವ್ಯಕ್ತಿಗಾಗಿ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸಬೇಕು. ಯಾಜಕನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಮಾಡುವುದರ ಮೂಲಕ ಆ ವ್ಯಕ್ತಿಯ ಅಶುದ್ಧತ್ವಕ್ಕಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ಅದರ ನಂತರ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಯಾಜಕನು ಎರಡನೆಯ ಟಗರನ್ನು ವಧಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ಬಳಿಕ ಯಾಜಕನು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಮತ್ತು ಧಾನ್ಯಸಮರ್ಪಣೆಯನ್ನು ಅರ್ಪಿಸುವನು. ಈ ರೀತಿಯಾಗಿ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ಆಗ ಅವನು ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“ಆದರೆ ಅವನು ಬಡವನಾಗಿದ್ದು ಆ ಸಮರ್ಪಣೆಗಳನ್ನು ಕೊಡುವುದಕ್ಕೆ ಅಶಕ್ತನಾಗಿದ್ದರೆ, ಆಗ ಅವನು ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಒಂದು ಟಗರನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಲ್ಪಡುವ ಅರ್ಪಣೆಯಾಗಿರುವುದು. ಹೀಗೆ ಯಾಜಕನು ಆ ವ್ಯಕಿಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಬಹುದು. ಅವನು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಮೂರು ಸೇರು ಶ್ರೇಷ್ಠ ಗೋಧಿಹಿಟ್ಟನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಗೋಧಿಹಿಟ್ಟು ಧಾನ್ಯಸಮರ್ಪಣೆಯಾಗಿ ಉಪಯೋಗಿಸಲ್ಪಡುವುದು. ಅವನು ಒಂದು ಸೇರು ಆಲಿವ್ ಎಣ್ಣೆಯನ್ನು, ");
INSERT INTO kan2010_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನು ಮತ್ತು ಎರಡು ಪಾರಿವಾಳ ಮರಿಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಬಡವರು ಸಹ ಅವುಗಳನ್ನು ಕೊಡಲು ಶಕ್ತರಾಗಿರುವರು. ಒಂದು ಪಕ್ಷಿಯು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿಯೂ ಇನ್ನೊಂದು ಪಕ್ಷಿಯು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿಯೂ ಇರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“ಎಂಟನೆಯ ದಿನದಲ್ಲಿ, ಅವನು ಅವುಗಳನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ಅವನು ಶುದ್ಧನಾಗುವಂತೆ ಅವುಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ತಂದ ಕುರಿಮರಿಯನ್ನು ಮತ್ತು ಎಣ್ಣೆಯನ್ನು ಯಾಜಕನು ತೆಗೆದುಕೊಂಡು, ಅವುಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ಬಳಿಕ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾದ ಕುರಿಮರಿಯನ್ನು ಯಾಜಕನು ವಧಿಸುವನು. ಯಾಜಕನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಶುದ್ಧೀಕರಿಸಲ್ಪಡುವ ವ್ಯಕ್ತಿಯ ಬಲಗಿವಿಯ ತುದಿಗೂ ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಬಲಗಾಲಿನ ಹೆಬ್ಬೆರಳಿಗೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ಅಲ್ಲದೆ ಯಾಜಕನು ಈ ಎಣ್ಣೆಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಅವನ ಎಡಗೈಗೆ ಹೊಯ್ಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ತನ್ನ ಎಡಗೈಯಲ್ಲಿರುವ ಎಣ್ಣೆಯನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಏಳುಸಲ ತನ್ನ ಬಲಗೈಯ ಬೆರಳಿನಿಂದ ಚಿಮಿಕಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ಬಳಿಕ ತನ್ನ ಅಂಗೈಯಲ್ಲಿರುವ ಎಣ್ಣೆಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞದ ರಕ್ತವನ್ನು ಹಚ್ಚಿದ ಸ್ಥಳದಲ್ಲಿಯೇ ಹಚ್ಚುವನು; ಸ್ವಲ್ಪ ಎಣ್ಣೆಯನ್ನು ಶುದ್ಧೀಕರಿಸಲ್ಪಡುವ ವ್ಯಕ್ತಿಯ ಬಲಗಿವಿಯ ತುದಿಗೆ ಹಚ್ಚಬೇಕು; ಸ್ವಲ್ಪ ಎಣ್ಣೆಯನ್ನು ಬಲಗೈಯ ಹೆಬ್ಬೆರಳಿಗೂ ಸ್ವಲ್ಪ ಎಣ್ಣೆಯನ್ನು ಬಲಗಾಲಿನ ಹೆಬ್ಬೆರಳಿಗೂ ಹಚ್ಚಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ಯಾಜಕನು ತನ್ನ ಅಂಗೈಯಲ್ಲಿ ಉಳಿದ ಎಣ್ಣೆಯನ್ನು ಶುದ್ಧೀಕರಿಸಲ್ಪಡುವ ವ್ಯಕ್ತಿಯ ತಲೆಗೆ ಹಚ್ಚಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಶುದ್ಧೀಕರಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“ಬಳಿಕ ಯಾಜಕನು ಬೆಳವಕ್ಕಿಗಳಲ್ಲಿ ಅಥವಾ ಪಾರಿವಾಳ ಮರಿಗಳಲ್ಲಿ ಒಂದನ್ನು ಸಮರ್ಪಿಸಬೇಕು (ಆ ವ್ಯಕ್ತಿಯು ಯಾವುದನ್ನು ಕೊಡಲು ಶಕ್ತನಾಗಿದ್ದಾನೊ ಅದನ್ನು ಅವನು ಸಮರ್ಪಿಸಬೇಕು.) ");
INSERT INTO kan2010_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ಅವನು ಈ ಪಕ್ಷಿಗಳಲ್ಲಿ ಒಂದನ್ನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿಯೂ ಇನ್ನೊಂದನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿಯೂ ಅರ್ಪಿಸಬೇಕು. ಅವನು ಪಕ್ಷಿಗಳನ್ನು ಧಾನ್ಯಸಮರ್ಪಣೆಯೊಂದಿಗೆ ಅರ್ಪಿಸಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಆ ವ್ಯಕ್ತಿಯ ಶುದ್ಧೀಕರಣಕ್ಕಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು; ಆಗ ಆ ವ್ಯಕ್ತಿ ಶುದ್ಧನಾಗುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ಚರ್ಮರೋಗದಿಂದ ವಾಸಿಯಾದವನನ್ನು ಶುದ್ಧೀಕರಿಸುವ ನಿಯಮಗಳು ಇವೇ. ಶುದ್ಧರಾಗಲು ವಿಧಿಬದ್ಧವಾದ ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸುವುದಕ್ಕೆ ಶಕ್ತರಲ್ಲದ ಜನರಿಗೋಸ್ಕರವಿರುವ ನಿಯಮಗಳು ಇವೇ. ");
INSERT INTO kan2010_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ; ");
INSERT INTO kan2010_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ನಾನು ನಿಮ್ಮ ಜನರಿಗೆ ಕಾನಾನ್ ದೇಶವನ್ನು ಕೊಡುತ್ತಿದ್ದೇನೆ. ನಿಮ್ಮ ಜನರು ಆ ದೇಶದಲ್ಲಿ ಪ್ರವೇಶಿಸಿ ನೆಲೆಸುವರು. ಆಗ ಯಾರ ಮನೆಯಲ್ಲಾದರೂ ಬೂಷ್ಟು ಉಂಟಾದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ಆ ಮನೆಯ ಯಾಜಮಾನನು ಬಂದು, ‘ನನ್ನ ಮನೆಯಲ್ಲಿ ಬೂಷ್ಟು ಬಂದಿದೆ’ ಎಂದು ಯಾಜಕನಿಗೆ ಹೇಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“ಆಗ ಯಾಜಕನು ಬೂಷ್ಟನ್ನು ನೋಡಲು ಮನೆಯ ಒಳಗೆ ಹೋಗುವುದಕ್ಕಿಂತ ಮೊದಲು ಆ ಮನೆಯಿಂದ ಪ್ರತಿಯೊಂದು ವಸ್ತುವನ್ನು ಹೊರತೆಗೆಯಲು ಜನರಿಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು. ಆಗ ಯಾಜಕನು ಮನೆಯಲ್ಲಿರುವ ಪ್ರತಿಯೊಂದು ವಸ್ತುವನ್ನು ಅಶುದ್ಧವೆಂದು ಹೇಳಬೇಕಾಗಿರುವುದಿಲ್ಲ. ಜನರು ಮನೆಯಿಂದ ಪ್ರತಿಯೊಂದು ವಸ್ತುವನ್ನು ಹೊರಗೆ ತೆಗೆದ ನಂತರ ಯಾಜಕನು ಮನೆಯೊಳಗೆ ಹೋಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ಯಾಜಕನು ಬೂಷ್ಟನ್ನು ನೋಡುವನು. ಗೋಡೆಗಳಲ್ಲಿರುವ ಬೂಷ್ಟಿನಲ್ಲಿ ರಂಧ್ರಗಳಿದ್ದು ಅದು ಹಸಿರು ಅಥವಾ ಕೆಂಪು ಬಣ್ಣದ್ದಾಗಿದ್ದರೆ ಮತ್ತು ಬೂಷ್ಟು ಗೋಡೆಗಿಂತ ತಗ್ಗಾಗಿದ್ದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ಆಗ ಯಾಜಕನು ಹೊರಗೆ ಹೋಗಿ ಮನೆಗೆ ಏಳು ದಿನಗಳವರೆಗೆ ಬೀಗ ಹಾಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","“ಏಳನೆಯ ದಿನದಲ್ಲಿ ಯಾಜಕನು ಹಿಂತಿರುಗಿ ಬಂದು ಮನೆಯನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಬೂಷ್ಟು ಮನೆಯ ಗೋಡೆಗಳಲ್ಲಿ ಹರಡಿದ್ದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ಆಗ ಯಾಜಕನು ಬೂಷ್ಟು ಇರುವ ಕಲ್ಲುಗಳನ್ನು ಒಡೆದುಹಾಕಿ ಬಿಸಾಡಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸಬೇಕು. ಅವರು ಆ ಕಲ್ಲುಗಳನ್ನು ಪಟ್ಟಣದ ಹೊರಗಿರುವ ಪ್ರತ್ಯೇಕವಾದ ಅಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ತರುವಾಯ ಯಾಜಕನು ಮನೆಯ ಒಳಗಿನ ಗೋಡೆಯನ್ನೆಲ್ಲಾ ಕೆರೆಯಿಸಬೇಕು. ಜನರು ಕೆರೆದುಹಾಕುವ ಮಣ್ಣನ್ನು ಪಟ್ಟಣದ ಹೊರಗೆ ಎಸೆದುಬಿಡಬೇಕು. ಅವರು ಅದನ್ನು ಪಟ್ಟಣದ ಹೊರಗಿರುವ ಪ್ರತ್ಯೇಕವಾದ ಅಶುದ್ಧ ಸ್ಥಳದಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ಬಳಿಕ ಆ ವ್ಯಕ್ತಿಯು ಗೋಡೆಗಳಲ್ಲಿ ಹೊಸ ಕಲ್ಲುಗಳನ್ನು ಇಡಿಸಿ ಹೊಸ ಮಡ್ಡಿ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ಒಂದುವೇಳೆ ಒಬ್ಬನು ಹಳೆಯ ಕಲ್ಲುಗಳನ್ನು ಮತ್ತು ಮಣ್ಣನ್ನು ತೆಗೆಸಿ ಹೊಸ ಕಲ್ಲುಗಳನ್ನು, ಮಣ್ಣನ್ನು ಮತ್ತು ಹೊಸ ಮಡ್ಡಿಯನ್ನು ಹಾಕಿಸಿದ್ದರೂ ಬೂಷ್ಟು ಮತ್ತೆ ಆ ಮನೆಯಲ್ಲಿ ಕಾಣಿಸಿಕೊಂಡರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ಯಾಜಕನು ಬಂದು ಆ ಮನೆಯನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ರೋಗದ ಗುರುತು ಮನೆಯಲ್ಲಿ ಹರಡಿದ್ದರೆ, ಆಗ ಅದು ಬಹುಬೇಗನೆ ಇತರ ಸ್ಥಳಗಳಿಗೆ ಹರಡುವ ರೋಗವಾಗಿದೆ. ಆದ್ದರಿಂದ ಆ ಮನೆಯು ಅಶುದ್ಧವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ಆ ವ್ಯಕ್ತಿಯು ಆ ಮನೆಯನ್ನು ಕೆಡವಿಹಾಕಿಸಬೇಕು. ಅವರು ಅದರ ಎಲ್ಲಾ ಕಲ್ಲುಗಳನ್ನು, ಮಣ್ಣನ್ನು ಮತ್ತು ಮರದ ತುಂಡುಗಳನ್ನು ಪಟ್ಟಣದ ಹೊರಗಿರುವ ಪ್ರತ್ಯೇಕವಾದ ಅಶುದ್ಧ ಸ್ಥಳಕ್ಕೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ಮುಚ್ಚಲ್ಪಟ್ಟಿರುವ ಆ ಮನೆಯೊಳಗೆ ಯಾವನಾದರೂ ಹೋದರೆ, ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ಯಾವನಾದರೂ ಆ ಮನೆಯಲ್ಲಿ ಆಹಾರ ತಿಂದರೆ ಅಥವಾ ಅಲ್ಲಿ ಮಲಗಿಕೊಂಡರೆ ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“ಒಂದು ಮನೆಯಲ್ಲಿ ಹೊಸ ಕಲ್ಲುಗಳನ್ನು ಮತ್ತು ಮಣ್ಣನ್ನು ಹಾಕಿಸಿದ ನಂತರ ಯಾಜಕನು ಅದನ್ನು ಪರೀಕ್ಷಿಸಬೇಕು. ಬೂಷ್ಟು ಮನೆಯಲ್ಲಿ ಹರಡದಿದ್ದರೆ, ಯಾಜಕನು ಮನೆಯನ್ನು ಶುದ್ಧವೆಂದು ಪ್ರಕಟಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","“ಬಳಿಕ ಮನೆಯನ್ನು ಶುದ್ಧೀಕರಿಸುವುದಕ್ಕೆ ಅವನು ಎರಡು ಪಕ್ಷಿಗಳನ್ನು ದೇವದಾರುಮರದ ಒಂದು ತುಂಡನ್ನು, ಕೆಂಪು ಬಟ್ಟೆಯನ್ನು ಮತ್ತು ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಬರಲನ್ನು ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ಯಾಜಕನು ಒಂದು ಪಕ್ಷಿಯನ್ನು ಹರಿಯುವ ನೀರಿನ ಮೇಲೆ ಮಣ್ಣಿನ ಬಟ್ಟಲಲ್ಲಿ ವಧಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ಬಳಿಕ ಯಾಜಕನು ದೇವದಾರಿನ ಕಟ್ಟಿಗೆಯನ್ನು, ಹಿಸ್ಸೋಪನ್ನು, ಕೆಂಪು ಬಟ್ಟೆಯನ್ನು ಮತ್ತು ಸಜೀವವಾದ ಪಕ್ಷಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳುವನು. ಯಾಜಕನು ಹರಿಯುವ ನೀರಿನ ಮೇಲೆ ವಧಿಸಲ್ಪಟ್ಟ ಪಕ್ಷಿಯ ರಕ್ತದಲ್ಲಿ ಅವುಗಳನ್ನು ಅದ್ದುವನು. ಬಳಿಕ ಯಾಜಕನು ರಕ್ತವನ್ನು ಆ ಮನೆಯ ಮೇಲೆ ಏಳು ಸಲ ಚಿಮಿಕಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ಮನೆಯನ್ನು ಶುದ್ಧೀಕರಿಸುವುದಕ್ಕೆ ಯಾಜಕನು ಅವುಗಳನ್ನು ಆ ರೀತಿಯಲ್ಲಿ ಉಪಯೋಗಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ಯಾಜಕನು ಪಟ್ಟಣದ ಹೊರಗಿರುವ ಬಯಲಿಗೆ ಹೋಗಿ, ಸಜೀವವಾದ ಪಕ್ಷಿಯನ್ನು ಸ್ವತಂತ್ರವಾಗಿ ಬಿಟ್ಟುಬಿಡಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಆ ಮನೆಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ಆಗ ಆ ಮನೆಯು ಶುದ್ಧವಾಗುವುದು.” ");
INSERT INTO kan2010_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ನಾನಾ ವಿಧವಾದ ಕುಷ್ಠರೋಗದ ಗುರುತುಗಳು ಅಂದರೆ ಕೂದಲು ಬೆಳೆಯದದ್ದು, ");
INSERT INTO kan2010_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ಬಟ್ಟೆಯಲ್ಲಿ ಅಥವಾ ಮನೆಯಲ್ಲಿ ಕಾಣಿಸಿಕೊಳ್ಳುವ ಬೂಷ್ಟಿನ ಕುರಿತು ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮಗಳು ಇವೇ. ");
INSERT INTO kan2010_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ಬಾವು, ಗಂಧೆ ಅಥವಾ ಚರ್ಮದ ಮೇಲೆ ಕಂಡುಬರುವ ಹೊಳೆಯುವ ಕಲೆ ಇವುಗಳ ಶುದ್ಧಾಚಾರದ ನಿಯಮಗಳು ಇವೇ. ");
INSERT INTO kan2010_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ಅವು ಶುದ್ಧಾಶುದ್ಧ ಬೇಧವನ್ನು ತಿಳಿಸುವ ನಿಯಮಗಳಾಗಿವೆ. ಅವು ಆ ರೀತಿಯ ರೋಗಗಳ ಶುದ್ಧಾಚಾರದ ನಿಯಮಗಳಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳಿರಿ: ಒಬ್ಬನ ದೇಹದಿಂದ ಸ್ರಾವವಾದಾಗ ಆ ವ್ಯಕ್ತಿ ಅಶುದ್ಧನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ಆ ಸ್ರಾವವು ಹರಿಯುತ್ತಿದ್ದರೂ ನಿಂತುಹೋಗಿದ್ದರೂ ಅವನು ಅಶುದ್ಧನೇ. ");
INSERT INTO kan2010_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ಸ್ರಾವವಾಗುತ್ತಿರುವ ವ್ಯಕ್ತಿ ಯಾವ ಹಾಸಿಗೆಯ ಮೇಲೆ ಮಲಗಿದರೂ ಆ ಹಾಸಿಗೆ ಅಶುದ್ಧವಾಗುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ಯಾವನಾದರೂ ಆ ವ್ಯಕ್ತಿಯ ಹಾಸಿಗೆಯನ್ನು ಮುಟ್ಟಿದರೆ, ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ಸ್ರಾವವುಳ್ಳವನು ಕುಳಿತುಕೊಳ್ಳುವ ವಸ್ತುವಿನ ಮೇಲೆ ಯಾವನಾದರೂ ಕುಳಿತುಕೊಂಡರೆ, ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಸ್ನಾನ ಮಾಡಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","ಅಲ್ಲದೆ ಸ್ರಾವವುಳ್ಳ ವ್ಯಕ್ತಿಯನ್ನು ಯಾವನಾದರೂ ಮುಟ್ಟಿದರೆ, ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ಸ್ರಾವವುಳ್ಳ ವ್ಯಕ್ತಿ ಶುದ್ಧವ್ಯಕ್ತಿಯ ಮೇಲೆ ಉಗುಳಿದರೆ, ಶುದ್ಧವ್ಯಕ್ತಿ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ನೀರಿನಿಂದ ಸ್ನಾನಮಾಡಬೇಕು. ಈ ವ್ಯಕ್ತಿ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ಸ್ರಾವವುಳ್ಳ ವ್ಯಕ್ತಿ ಯಾವ ತಡಿಯ ಮೇಲೆ ಕುಳಿತರೂ ಅದು ಅಶುದ್ಧವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ಆದ್ದರಿಂದ ಯಾವನಾದರೂ ಸ್ರಾವವುಳ್ಳ ವ್ಯಕ್ತಿಯ ಕೆಳಗಿರುವ ಯಾವದೇ ವಸ್ತುಗಳನ್ನು ಮುಟ್ಟಿದರೂ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ಸ್ರಾವವುಳ್ಳ ವ್ಯಕ್ತಿಯ ಕೆಳಗಿರುವ ವಸ್ತುಗಳನ್ನು ತೆಗೆದುಕೊಂಡುಹೋಗುವ ಯಾವನಾದರೂ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ಒಂದುವೇಳೆ ಸ್ರಾವವುಳ್ಳ ಒಬ್ಬನು ತನ್ನ ಕೈಗಳನ್ನು ನೀರಿನಲ್ಲಿ ತೊಳೆಯದೆ ಇನ್ನೊಬ್ಬ ವ್ಯಕ್ತಿಯನ್ನು ಮುಟ್ಟಿದರೆ, ಆಗ ಆ ಇನ್ನೊಬ್ಬ ವ್ಯಕ್ತಿ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ಸ್ರಾವವುಳ್ಳ ವ್ಯಕ್ತಿ ಮಣ್ಣಿನ ಮಡಿಕೆಯನ್ನು ಮುಟ್ಟಿದರೆ, ಆ ಮಡಿಕೆಯನ್ನು ಒಡೆದುಹಾಕಬೇಕು. ಸ್ರಾವವುಳ್ಳ ವ್ಯಕ್ತಿ ಮರದ ಬಟ್ಟಲನ್ನು ಮುಟ್ಟಿದರೆ, ಆ ವಸ್ತುವನ್ನು ನೀರಿನಲ್ಲಿ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ಸ್ರಾವವುಳ್ಳವನ ಸ್ರಾವವು ನಿಂತು ವಾಸಿಯಾದಾಗ, ಅವನು ಶುದ್ಧಮಾಡಿಕೊಳ್ಳುವುದಕ್ಕೆ ಏಳು ದಿನಗಳವರೆಗೆ ಕಾಯಬೇಕು. ಬಳಿಕ ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಹರಿಯುವ ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಆಗ ಅವನು ಶುದ್ಧನಾಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಆ ವ್ಯಕ್ತಿ ತನಗೋಸ್ಕರ ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನು ಅಥವಾ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅವನು ದೇವದರ್ಶನ ಗುಡಾರದ ಬಾಗಿಲಿನ ಬಳಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಬರಬೇಕು. ಆ ವ್ಯಕ್ತಿ ಎರಡು ಪಕ್ಷಿಗಳನ್ನು ಯಾಜಕನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ಯಾಜಕನು ಈ ಪಕ್ಷಿಗಳಲ್ಲಿ ಒಂದನ್ನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿಯೂ ಇನ್ನೊಂದನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿಯೂ ಅರ್ಪಿಸುವನು. ಹೀಗೆ ಯಾಜಕನು ಅವನ ಅಶುದ್ಧವಾದ ಸ್ರಾವಕ್ಕಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ಒಬ್ಬನಿಗೆ ವೀರ್ಯಸ್ಖಲನವಾದರೆ, ಅವನು ನೀರಿನಲ್ಲಿ ಸರ್ವಾಂಗಸ್ನಾನಮಾಡಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ಯಾವ ಬಟ್ಟೆಯ ಮೇಲಾಗಲಿ ತೊಗಲಿನ ವೇಲಾಗಲಿ ವೀರ್ಯವು ಬಿದ್ದರೆ, ಆ ಬಟ್ಟೆ ಅಥವಾ ತೊಗಲನ್ನು ನೀರಿನಿಂದ ತೊಳೆಯಬೇಕು. ಅದು ಸಾಯಂಕಾಲವರೆಗೆ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ಪುರುಷನಿಗೆ ಸ್ತ್ರೀಸಂಗದಿಂದ ವೀರ್ಯಸ್ಖಲನವಾದರೆ, ಆಗ ಅವರಿಬ್ಬರೂ ಸ್ನಾನಮಾಡಬೇಕು. ಅವರು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ಸ್ತ್ರೀಗೆ ಅವಳ ತಿಂಗಳ ಮುಟ್ಟಿನಿಂದ ಸ್ರಾವವಿದ್ದರೆ, ಅವಳು ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧಳಾಗಿರುವಳು. ಯಾವನಾದರೂ ಆಕೆಯನ್ನು ಮುಟ್ಟಿದರೆ, ಆ ವ್ಯಕ್ತಿಯೂ ಸಾಯಂಕಾಲದವರೆಗೆ ಆಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ಅಲ್ಲದೆ, ಸ್ತ್ರೀಯು ತನ್ನ ಮುಟ್ಟಿನ ದಿನಗಳಲ್ಲಿ ಯಾವುದರ ಮೇಲೆ ಮಲಗಿದರೂ ಅದು ಅಶುದ್ಧವಾಗಿರುವುದು ಮತ್ತು ಆ ಸಮಯದಲ್ಲಿ ಆಕೆಯು ಯಾವುದರ ಮೇಲೆ ಕುಳಿತುಕೊಂಡರೂ ಅದು ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ಯಾವನಾದರೂ ಅವಳ ಹಾಸಿಗೆಯನ್ನು ಮುಟ್ಟಿದರೆ, ಆ ವ್ಯಕ್ತಿ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ಯಾವನಾದರೂ ಅವಳು ಕುಳಿತುಕೊಂಡಿದ್ದ ಯಾವ ವಸ್ತುವನ್ನಾದರೂ ಮುಟ್ಟಿದರೆ, ಆ ವ್ಯಕ್ತಿ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಸ್ನಾನಮಾಡಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ಅವನು ಅವಳ ಹಾಸಿಗೆಯನ್ನಾಗಲಿ ಅಥವಾ ಅವಳು ಕುಳಿತ್ತಿದ್ದ ಸ್ಥಳದಲ್ಲಿ ಇದ್ದ ಯಾವದನ್ನಾದರೂ ಮುಟ್ಟಿದರೆ ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ಪುರುಷನು ಸ್ತ್ರೀಯ ಮುಟ್ಟಿನ ಸಮಯದಲ್ಲಿ ಆಕೆಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಪರ್ಕ ಹೊಂದಿದರೆ, ಆಗ ಅವನು ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ಅವನು ಮಲಗಿಕೊಳ್ಳುವ ಪ್ರತಿಯೊಂದು ಹಾಸಿಗೆಯು ಅಶುದ್ಧವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ಸ್ತ್ರೀಗೆ ತನ್ನ ಮುಟ್ಟಿನ ದಿನಗಳ ಹೊರತಾಗಿ ಅನೇಕ ದಿನಗಳವರೆಗೆ ರಕ್ತಸ್ರಾವವಾದರೆ ಅಥವಾ ಮುಟ್ಟಿನ ದಿನಗಳ ನಂತರ ಅವಳಿಗೆ ಸ್ರಾವವಾದರೆ, ಆಕೆಯು ತನ್ನ ಮುಟ್ಟಿನ ದಿನಗಳಲ್ಲಿ ಅಶುದ್ಧಳಾಗಿರುವಂತೆ, ಅಶುದ್ಧಳಾಗಿರುವಳು. ಅವಳಿಗೆ ಸ್ರಾವವಾಗುವ ದಿನಗಳೆಲ್ಲಾ ಅವಳು ಅಶುದ್ಧಳಾಗಿರುವಳು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ಆ ಸ್ರಾವವಿರುವ ತನಕ ಅವಳು ಯಾವ ಹಾಸಿಗೆಯ ಮೇಲೆ ಮಲಗಿದರೂ, ಅದು ತಿಂಗಳ ಮುಟ್ಟಿನ ಕಾಲದಲ್ಲಿ ಅವಳು ಮಲಗಿರುವ ಹಾಸಿಗೆಯಂತೆಯೇ ಅಶುದ್ಧವಾಗಿರುವುದು. ಅವಳು ಯಾವುದರ ಮೇಲೆ ಕುಳಿತರೂ ಅದು ತಿಂಗಳ ಮುಟ್ಟಿನ ಕಾಲದಲ್ಲಿ ಅವಳು ಕುಳಿತಿದ್ದ ವಸ್ತುವಿನಂತೆಯೇ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ಯಾವನಾದರೂ ಆ ವಸ್ತುಗಳನ್ನು ಮುಟ್ಟಿದರೆ, ಆ ವ್ಯಕ್ತಿ ಅಶುದ್ಧನಾಗಿರುವನು. ಆ ವ್ಯಕ್ತಿಯು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ಸ್ತ್ರೀಗೆ ಸ್ರಾವವು ನಿಂತ ನಂತರ, ಅವಳು ಏಳು ದಿನಗಳವರೆಗೆ ಕಾಯಬೇಕು. ಅದರ ನಂತರ ಅವಳು ಶುದ್ಧಳಾಗಿರುವಳು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ಬಳಿಕ ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಸ್ತ್ರೀಯು ಎರಡು ಬೆಳವಕ್ಕಿಗಳನ್ನಾಗಲಿ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅವಳು ಅವುಗಳನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ತರುವಾಯ ಯಾಜಕನು ಒಂದು ಪಕ್ಷಿಯನ್ನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿಯೂ ಇನ್ನೊಂದು ಪಕ್ಷಿಯನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿಯೂ ಅರ್ಪಿಸಬೇಕು. ಹೀಗೆ ಯಾಜಕನು ಅವಳಿಗಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ಆದ್ದರಿಂದ ಅಶುದ್ಧತ್ವದ ಕುರಿತು ನೀವು ಇಸ್ರೇಲರನ್ನು ಎಚ್ಚರಿಸಬೇಕು. ನೀವು ಜನರನ್ನು ಎಚ್ಚರಿಸದಿದ್ದರೆ ಅವರು ನನ್ನ ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಅಶುದ್ಧಮಾಡಿ ಸಾವಿಗೀಡಾಗುವರು” ");
INSERT INTO kan2010_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ಸ್ರಾವವುಳ್ಳ ಜನರು ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮಗಳು ಇವುಗಳೇ. ವೀರ್ಯಸ್ಖಲನದಿಂದ ಅಶುದ್ಧರಾದ ಪುರುಷರು ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮಗಳು ಇವುಗಳೇ. ");
INSERT INTO kan2010_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ತಮ್ಮ ತಿಂಗಳ ಮುಟ್ಟಿನಿಂದ ಅಶುದ್ಧರಾಗುವ ಸ್ತ್ರೀಯರು, ಸ್ರಾವವಾಗುವ ಗಂಡಸರು ಮತ್ತು ಸ್ತ್ರೀಯರು ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮಗಳು ಇವುಗಳೇ. ಅಶುದ್ಧಳಾದ ಸ್ತ್ರೀಯೊಡನೆ ಮಲಗುವುದರಿಂದ ಅಶುದ್ಧನಾಗುವ ಯಾವನಾದರೂ ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮಗಳು ಇವುಗಳೇ. ");
INSERT INTO kan2010_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ಆರೋನನ ಇಬ್ಬರು ಪುತ್ರರು ಯೆಹೋವನಿಗೆ ಆತನು ಆಜ್ಞಾಪಿಸದೇ ಇದ್ದ ಧೂಪವನ್ನು ಅರ್ಪಿಸುತ್ತಿದ್ದಾಗ ಸತ್ತರು. ಅದಾದ ನಂತರ ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ಆತನು ಹೇಳಿದ್ದೇನೆಂದರೆ: “ನಿನ್ನ ಸಹೋದರನಾದ ಆರೋನನೊಡನೆ ಮಾತಾಡು. ಅವನು ತನಗೆ ಇಷ್ಟಬಂದಾಗಲೆಲ್ಲಾ ತೆರೆಯ ಹಿಂದಿರುವ ಮಹಾ ಪವಿತ್ರಸ್ಥಳದೊಳಕ್ಕೆ ಹೋಗಬಾರದೆಂದು ಅವನಿಗೆ ಹೇಳು. ಆ ತೆರೆಯ ಹಿಂದೆ ಇರುವ ಕೋಣೆಯೊಳಗೆ ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಯು ಇರುತ್ತದೆ. ಕೃಪಾಸನವು ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಯ ಮೇಲ್ಭಾಗದಲ್ಲಿರುತ್ತದೆ. ಕೃಪಾಸನದ ಮೇಲೆ ಮೇಘದಲ್ಲಿ ನಾನು ಕಾಣಿಸಿಕೊಳ್ಳುತ್ತೇನೆ. ಆರೋನನು ಆ ಕೋಣೆಯೊಳಗೆ ಹೋದರೆ ಸಾಯುವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“ದೋಷಪರಿಹಾರಕ ದಿನದಲ್ಲಿ ಆರೋನನು ಮಹಾ ಪವಿತ್ರಸ್ಥಳದೊಳಗೆ ಪ್ರವೇಶಿಸುವ ಮೊದಲು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಹೋರಿಯನ್ನೂ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಟಗರನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ಆರೋನನು ತನ್ನ ಪೂರ್ಣಶರೀರವನ್ನು ನೀರಿನಿಂದ ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಬಳಿಕ ಅವನು ಈ ಬಟ್ಟೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಆರೋನನು ಪವಿತ್ರ ನಾರಿನ ನಿಲುವಂಗಿಯನ್ನೂ ನಾರಿನ ಚಡ್ಡಿಯನ್ನೂ ಧರಿಸಿಕೊಂಡಿರಬೇಕು. ಅವನು ನಾರಿನ ನಡುಕಟ್ಟನ್ನು ಕಟ್ಟಿಕೊಳ್ಳಬೇಕು; ನಾರಿನ ಮುಂಡಾಸವನ್ನು ಇಟ್ಟುಕೊಳ್ಳಬೇಕು. ಇವುಗಳು ಪವಿತ್ರವಾದವುಗಳಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“ಆರೋನನು ಇಸ್ರೇಲರಿಂದ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಹೋತಗಳನ್ನು ಮತ್ತು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಟಗರನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ಬಳಿಕ ಆರೋನನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕೋಸ್ಕರ ಹೋರಿಯನ್ನು ಅರ್ಪಿಸಬೇಕು. ಈ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವು ಅವನಿಗಾಗಿ ಇರುತ್ತದೆ. ಆರೋನನು ತನಗೂ ತನ್ನ ಕುಟುಂಬದವರಿಗೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಲು ಇದನ್ನು ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“ತರುವಾಯ ಆರೋನನು ಆ ಎರಡು ಹೋತಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿನಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ಆರೋನನು ಚೀಟುಹಾಕಿ ಒಂದು ಹೋತವನ್ನು ಯೆಹೋವನಿಗಾಗಿಯೂ ಇನ್ನೊಂದನ್ನು ಅಜಾಜೇಲನಿಗಾಗಿಯೂ ಎಂದು ನಿರ್ಧರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","“ಬಳಿಕ ಆರೋನನು ಚೀಟು ಹಾಕುವುದರ ಮೂಲಕ ಯೆಹೋವನಿಗೋಸ್ಕರ ಆರಿಸಲ್ಪಟ್ಟ ಹೋತವನ್ನು ಅರ್ಪಿಸುವನು. ಆರೋನನು ಈ ಹೋತವನ್ನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ಆದರೆ ಚೀಟು ಹಾಕುವುದರ ಮೂಲಕ ಅಜಾಜೇಲನಿಗಾಗಿ ಆರಿಸಲ್ಪಟ್ಟ ಹೋತವನ್ನು ಜೀವಂತವಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತರಬೇಕು ಮತ್ತು ಈ ಹೋತವನ್ನು ಮರುಭೂಮಿಯಲ್ಲಿರುವ ಅಜಾಜೇಲನಿಗೆ ಕಳುಹಿಸಬೇಕು. ಜನರಿಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಲು ಹೀಗೆ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“ಬಳಿಕ ಆರೋನನು ಹೋರಿಯನ್ನು ತನ್ನ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸುವನು. ಆರೋನನು ತನಗಾಗಿಯೂ ತನ್ನ ಕುಟುಂಬದವರಿಗಾಗಿಯೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ಆರೋನನು ಹೋರಿಯನ್ನು ತನ್ನ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ವಧಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ಬಳಿಕ ಅವನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ವೇದಿಕೆಯಿಂದ ಕೆಂಡಗಳನ್ನು ಧೂಪಾರತಿಯಲ್ಲಿ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಆರೋನನು ಪರಿಮಳ ಧೂಪ ದ್ರವ್ಯದ ಪುಡಿಯಲ್ಲಿ ಎರಡು ಹಿಡಿ ತೆಗೆದುಕೊಳ್ಳುವನು. ಆರೋನನು ಆ ಧೂಪವನ್ನು ತೆರೆಯ ಹಿಂದೆ ಇರುವ ಕೋಣೆಗೆ ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ಆರೋನನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಬೆಂಕಿಯ ಮೇಲೆ ಧೂಪವನ್ನು ಹಾಕಬೇಕು. ಆಗ ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆ ಮೇಲಿರುವ ಕೃಪಾಸವನ್ನು ಧೂಪದ ಹೊಗೆಯು ಮುಚ್ಚಿಕೊಳ್ಳುವುದು. ಹೀಗೆ ಮಾಡುವುದರಿಂದ ಆರೋನನು ಸಾಯುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ಅಲ್ಲದೆ ಆರೋನನು ಹೋರಿಯ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಕೃಪಾಸನದ ಪೂರ್ವಭಾಗದಲ್ಲಿ ತನ್ನ ಬೆರಳಿನಿಂದ ಚಿಮಿಕಿಸಬೇಕು. ಕೃಪಾಸನದ ಮುಂಭಾಗದಲ್ಲಿ ಅವನು ತನ್ನ ಬೆರಳಿನಿಂದ ರಕ್ತವನ್ನು ಏಳು ಬಾರಿ ಚಿಮಿಕಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ಬಳಿಕ ಆರೋನನು ಜನರಿಗೋಸ್ಕರವಾಗಿರುವ ಪಾಪಪರಿಹಾರಕ ಪಶುವಾದ ಹೋತವನ್ನು ವಧಿಸಬೇಕು. ಆರೋನನು ಈ ಹೋತದ ರಕ್ತವನ್ನು ತೆರೆಯ ಹಿಂಭಾಗದಲ್ಲಿರುವ ಕೋಣೆಗೆ ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು. ಆರೋನನು ಹೋರಿಯ ರಕ್ತದಿಂದ ಮಾಡಿದಂತೆ ಹೋತದ ರಕ್ತದಿಂದಲೂ ಮಾಡಬೇಕು. ಆರೋನನು ಹೋತದ ರಕ್ತವನ್ನು ಕೃಪಾಸನದ ಮೇಲೂ ಮತ್ತು ಕೃಪಾಸನದ ಮುಂಭಾಗದಲ್ಲಿಯೂ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ಆರೋನನು ಮಹಾ ಪವಿತ್ರಸ್ಥಳವನ್ನು ಪರಿಶುದ್ಧ ಮಾಡಲು ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮಗಳು: ಇಸ್ರೇಲರ ಅಶುದ್ಧತ್ವ, ದಂಗೆಕೋರತನ ಮತ್ತು ಅವರ ಯಾವುದೇ ಪಾಪಗಳ ಪರಿಹಾರಕ್ಕಾಗಿ ಆರೋನನು ಇದನ್ನು ಮಾಡಬೇಕು. ಅವರ ಅಶುದ್ಧತ್ವದ ನಡುವೆ ಇರುವ ದೇವದರ್ಶನಗುಡಾರಕ್ಕೂ ಅವನು ಇದನ್ನೇ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“ಆರೋನನು ಮಹಾ ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಲು ದೇವದರ್ಶನಗುಡಾರದೊಳಗೆ ಹೋದ ಸಮಯದಿಂದ ಅವನು ಬರುವ ತನಕ ಗುಡಾರದೊಳಗೆ ಯಾರೂ ಇರಕೂಡದು. ಆರೋನನು ಬರುವ ತನಕ ಯಾರೂ ಒಳಗೆ ಹೋಗಕೂಡದು. ಹೀಗೆ ಆರೋನನು ತನಗಾಗಿಯೂ ತನ್ನ ಕುಟುಂಬಕ್ಕಾಗಿಯೂ ಇಡೀ ಇಸ್ರೇಲ್ ಸಮೂಹಕ್ಕಾಗಿಯೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ತರುವಾಯ ಆರೋನನು ಹೊರಗೆ ಬಂದು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಗೆ ಹೋಗುವನು. ಆರೋನನು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಶುದ್ಧೀಕರಿಸುವನು. ಆರೋನನು ಹೋರಿಯ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಮತ್ತು ಹೋತದ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಕೆಯ ಎಲ್ಲಾ ಮೂಲೆಗಳಿಗೆ ಹಚ್ಚುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ಬಳಿಕ ಆರೋನನು ತನ್ನ ಬೆರಳಿನಿಂದ ಸ್ವಲ್ಪ ರಕ್ತವನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಏಳು ಸಲ ಚಿಮಿಕಿಸುವನು. ಹೀಗೆ ಆರೋನನು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಇಸ್ರೇಲರಿಂದ ಅದಕ್ಕುಂಟಾದ ಅಶುದ್ಧತ್ವದಿಂದ ದೂರಮಾಡಿ ಪರಿಶುದ್ಧಗೊಳಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“ಹೀಗೆ ಆರೋನನು ಮಹಾ ಪವಿತ್ರಸ್ಥಳವನ್ನೂ ದೇವದರ್ಶನಗುಡಾರವನ್ನೂ ಯಜ್ಞವೇದಿಕೆಯನ್ನೂ ಶುದ್ಧೀಕರಿಸುವನು. ಬಳಿಕ ಆರೋನನು ಜೀವಂತವಾಗಿರುವ ಹೋತವನ್ನು ಯೆಹೋವನ ಬಳಿಗೆ ತರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ಆರೋನನು ಸಜೀವವಾದ ಹೋತದ ತಲೆಯ ಮೇಲೆ ತನ್ನ ಎರಡು ಕೈಗಳನ್ನಿಟ್ಟು ಇಸ್ರೇಲರು ಮಾಡಿದ ಪಾಪಗಳನ್ನು ಮತ್ತು ದ್ರೋಹಗಳನ್ನು ಅರಿಕೆಮಾಡುವನು. ಹೀಗೆ ಆರೋನನು ಜನರ ಪಾಪಗಳನ್ನು ಹೋತದ ತಲೆಯ ಮೇಲೆ ಹೊರಿಸುವನು. ಬಳಿಕ ಅವನು ಹೋತವನ್ನು ಮರುಭೂಮಿಗೆ ಕಳುಹಿಸಿಬಿಡುವನು. ಒಬ್ಬ ಮನುಷ್ಯನು ಹೋತವನ್ನು ನಡಿಸಿಕೊಂಡು ಹೋಗಲು ಸಿದ್ಧನಾಗಿ ನಿಂತಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ಹೀಗೆ ಹೋತವು ಜನರ ಪಾಪಗಳನ್ನು ಹೊತ್ತುಕೊಂಡು ಬರಿದಾದ ಮರುಭೂಮಿಗೆ ಹೋಗುವುದು. ಹೋತವನ್ನು ನಡಿಸಿಕೊಂಡು ಹೋಗುವ ಮನುಷ್ಯನು ಮರುಭೂಮಿಯಲ್ಲಿ ಅದನ್ನು ಬಿಟ್ಟುಬಿಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“ಬಳಿಕ ಆರೋನನು ದೇವದರ್ಶನಗುಡಾರವನ್ನು ಪ್ರವೇಶಿಸುವನು. ಅವನು ಪವಿತ್ರಸ್ಥಳದೊಳಗೆ ಹೋಗಿದ್ದಾಗ ಧರಿಸಿಕೊಂಡಿದ್ದ ನಾರುಬಟ್ಟೆಯನ್ನು ತೆಗೆದುಹಾಕುವನು. ಅವನು ಈ ಬಟ್ಟೆಗಳನ್ನು ಅಲ್ಲಿಯೇ ಬಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ಅವನು ತನ್ನ ಶರೀರವನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ನೀರಿನಿಂದ ತೊಳೆದುಕೊಳ್ಳುವನು. ಬಳಿಕ ಅವನು ತನ್ನ ಇತರ ವಿಶೇಷ ಬಟ್ಟೆಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳುವನು. ಅವನು ಹೊರಗೆ ಬಂದು, ತನ್ನ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಮತ್ತು ಜನರ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಅರ್ಪಿಸುವನು. ಅವನು ತನಗಾಗಿಯೂ ಜನರಿಗಾಗಿಯೂ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ಬಳಿಕ ಅವನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞದ ಕೊಬ್ಬನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“ಅಜಾಜೇಲನಿಗೆ ಹೋತವನ್ನು ನಡೆಸಿಕೊಂಡು ಹೋದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಿಂದ ತನ್ನ ಪೂರ್ಣಶರೀರವನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಬಳಿಕ ಅವನು ಪಾಳೆಯದೊಳಗೆ ಬರಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಇರುವ ಹೋರಿಯನ್ನು ಮತ್ತು ಹೋತವನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. (ಆ ಪಶುಗಳ ರಕ್ತವನ್ನು, ಪವಿತ್ರವಸ್ತುಗಳನ್ನು ಶುದ್ಧೀಕರಿಸುವುದಕ್ಕೆ ಪವಿತ್ರಸ್ಥಳಕ್ಕೆ ತರಲಾಯಿತು.) ಯಾಜಕರು ಆ ಪಶುಗಳ ಚರ್ಮ, ಮಾಂಸ ಮತ್ತು ದೇಹದ ಕಲ್ಮಶವನ್ನೆಲ್ಲಾ ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಹಾಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ಬಳಿಕ ಅವುಗಳನ್ನು ಸುಡುವ ವ್ಯಕ್ತಿ ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ತನ್ನ ಪೂರ್ಣದೇಹವನ್ನು ನೀರಿನಿಂದ ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಬಳಿಕ ಅವನು ಪಾಳೆಯದೊಳಗೆ ಬರಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ಇದು ನಿಮಗೆ ಶಾಶ್ವತವಾದ ಕಟ್ಟಳೆ: ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಆಹಾರವನ್ನು ತೆಗೆದುಕೊಳ್ಳದೆ ಉಪವಾಸ ಮಾಡಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸಿಸುವ ಪ್ರವಾಸಿಗರಾಗಲಿ ಪರದೇಶಸ್ಥರಾಗಲಿ ಯಾವ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ಯಾಕೆಂದರೆ ಈ ದಿನದಲ್ಲಿ ಯಾಜಕನು ನಿಮ್ಮನ್ನು ಶುದ್ಧೀಕರಿಸಲು ನಿಮಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ಆಗ ನೀವು ಯೆಹೋವನಿಗಾಗಿ ನಿಮ್ಮ ಎಲ್ಲಾ ಪಾಪಗಳಿಂದ ಬಿಡುಗಡೆಯಾಗಿ ಪರಿಶುದ್ಧರಾಗುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ಈ ದಿನವು ನಿಮಗೆ ಬಹಳ ಪ್ರಾಮುಖ್ಯವಾದ ವಿಶ್ರಾಂತಿ ದಿನವಾಗಿದೆ. ನೀವು ಉಪವಾಸ ಮಾಡಬೇಕು. ಈ ನಿಯಮ ಶಾಶ್ವತವಾದದ್ದು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“ಆದ್ದರಿಂದ ಪ್ರಧಾನಯಾಜಕನಾಗಿ ಆರಿಸಲ್ಪಟ್ಟವನು ವಸ್ತುಗಳನ್ನು ಶುದ್ಧೀಕರಿಸಲು ಈ ಆಚರಣೆಯನ್ನು ಮಾಡಬೇಕು. ಈತನು ತನ್ನ ತಂದೆಯ ನಂತರ ಪ್ರಧಾನಯಾಜಕನಾಗಿ ಸೇವೆಮಾಡುವುದಕ್ಕೆ ನೇಮಿಸಲ್ಪಟ್ಟವನಾಗಿದ್ದಾನೆ. ಆ ಯಾಜಕನು ಪವಿತ್ರವೂ ಶ್ರೇಷ್ಠವೂ ಆಗಿರುವ ನಾರುಬಟ್ಟೆಯನ್ನು ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ಅವನು ಮಹಾ ಪವಿತ್ರಸ್ಥಳ, ದೇವದರ್ಶನಗುಡಾರ ಮತ್ತು ವೇದಿಕೆಯನ್ನು ಶುದ್ಧೀಕರಿಸಬೇಕು; ಅವನು ಯಾಜಕರನ್ನು ಇಸ್ರೇಲರನ್ನು ಶುದ್ಧೀಕರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ಇಸ್ರೇಲರನ್ನು ಶುದ್ಧೀಕರಿಸುವ ಕಟ್ಟಳೆ ಶಾಶ್ವತವಾದದ್ದು. ನೀವು ಆ ಕಾರ್ಯಗಳನ್ನು ವರ್ಷಕ್ಕೊಮ್ಮೆ ಇಸ್ರೇಲರ ಪಾಪಗಳ ದೆಸೆಯಿಂದ ಮಾಡಬೇಕು.” ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವರು ಆ ಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","ಆರೋನನೊಡನೆಯೂ ಅವನ ಪುತ್ರರೊಡನೆಯೂ ಇಸ್ರೇಲರೆಲ್ಲರೊಡನೆಯೂ ಮಾತಾಡು. ಯೆಹೋವನು ಹೀಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಾನೆಂದು ಹೇಳು. ಅದೇನೆಂದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ಇಸ್ರೇಲರಲ್ಲಿ ಯಾವನಾದರೂ ಹೋರಿಯನ್ನಾಗಲಿ ಕುರಿಮರಿಯನ್ನಾಗಲಿ ಹೋತವನ್ನಾಗಲಿ ಪಾಳೆಯದೊಳಗೆ ಅಥವಾ ಪಾಳೆಯದ ಹೊರಗೆ ವಧಿಸಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ಅವನು ಆ ಪ್ರಾಣಿಯನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತರಬೇಕು. ಅವನು ಆ ಪಶುವಿನ ಒಂದು ಭಾಗವನ್ನು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಕೊಡಬೇಕು. ಅವನು ರಕ್ತವನ್ನು ಸುರಿಸಿದ್ದರಿಂದ ತನ್ನ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವನ ಪವಿತ್ರ ಗುಡಾರದೊಳಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬೇಕು. ಅವನು ಪ್ರಾಣಿಯ ಒಂದು ಭಾಗವನ್ನು ಯೆಹೋವನಿಗೆ ಉಡುಗೊರೆಯಾಗಿ ತೆಗೆದುಕೊಂಡು ಹೋಗದಿದ್ದರೆ, ಅವನನ್ನು ಅವನ ಜನರಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ಸಮಾಧಾನಯಜ್ಞರೂಪವಾಗಿ ಇದನ್ನು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸುವ ಯಜ್ಞಕ್ಕೆ ಇದೇ ನಿಯಮ. ಇಸ್ರೇಲರು ಹೊಲಗಳಲ್ಲಿ ಕೊಲ್ಲುವ ತಮ್ಮ ಪ್ರಾಣಿಗಳನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಅಂದರೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಯಾಜಕರ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ಬಳಿಕ ಯಾಜಕನು ಆ ಪಶುಗಳ ರಕ್ತವನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿನ ಹತ್ತಿರವಿರುವ ಯೆಹೋವನ ಯಜ್ಞವೇದಿಕೆಗೆ ಚೆಲ್ಲುವನು ಮತ್ತು ಅವುಗಳ ಕೊಬ್ಬನ್ನು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡುವನು. ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಪ್ರಿಯವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ಅವರು “ಅಜದೇವತೆಗಳಿಗೆ” ಇನ್ನು ಮುಂದೆ ಬಲಿಕೊಡಬಾರದು. ಅವರು ಅನ್ಯದೇವತೆಗಳ ಹಿಂದೆ ಹೋಗಿದ್ದಾರೆ. ಆ ರೀತಿಯಲ್ಲಿ ಅವರು ಸೂಳೆಯರ ಹಾಗೆ ವರ್ತಿಸಿದ್ದಾರೆ. ಈ ನಿಯಮಗಳು ಶಾಶ್ವತವಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ಜನರಿಗೆ ಹೇಳಬೇಕಾದದ್ದೇನೆಂದರೆ: ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುತ್ತಿರುವ ಯಾವ ಇಸ್ರೇಲನಾಗಲಿ ಅನ್ಯನಾಗಲಿ ಸರ್ವಾಂಗಹೋಮವನ್ನಾಗಲಿ ಯಜ್ಞವನ್ನಾಗಲಿ ಅರ್ಪಿಸಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ಅವನು ತನ್ನ ಬಲಿಯನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತೆಗೆದುಕೊಂಡು ಬಂದು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಬೇಕು. ಇಲ್ಲವಾದರೆ ಅವನನ್ನು ಅವನ ಕುಲದಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ರಕ್ತವನ್ನು ತಿನ್ನುವ ಪ್ರತಿಯೊಬ್ಬನಿಗೂ ನಾನು ವಿರುದ್ಧವಾಗಿರುವೆನು. ಅವನು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ವಾಸವಾಗಿರುವ ಇಸ್ರೇಲನಾಗಲಿ ಪರದೇಶಸ್ಥನಾಗಲಿ ಆಗಿರಬಹುದು. ನಾನು ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅವನ ಜನರಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ಯಾಕೆಂದರೆ ದೇಹದ ಜೀವ ರಕ್ತದಲ್ಲಿದೆ. ನೀವು ನಿಮಗೋಸ್ಕರವಾಗಿ ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಲಿ ಎಂದು ನಾನು ಅದನ್ನು ನಿಮಗೆ ಕೊಟ್ಟಿದ್ದೇನೆ. ನೀವು ನಿಮಗೋಸ್ಕರವಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಲು ಈ ನಿಯಮಗಳನ್ನು ಉಪಯೋಗಿಸಬೇಕು. ಒಬ್ಬನ ಜೀವಕ್ಕೆ ರಕ್ತವೇ ಪ್ರಾಯಶ್ಚಿತ್ತವಾಗಿದೆ. ಜೀವಿಯೊಂದನ್ನು ಕೊಂದಿದ್ದರ ಬೆಲೆಯಾಗಿ ನೀವು ನನಗೆ ಆ ರಕ್ತವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ಆದ್ದರಿಂದ ನಾನು ಇಸ್ರೇಲರಿಗೆ ಹೇಳುವುದೇನೆಂದರೆ: ನಿಮ್ಮಲ್ಲಿ ಯಾವನೂ ರಕ್ತಭೋಜನ ಮಾಡಬಾರದು ಮತ್ತು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುವ ಯಾವ ಪರದೇಶಸ್ಥನೂ ರಕ್ತಭೋಜನ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ಯಾವನಾದರೂ ಒಂದು ಪ್ರಾಣಿಯನ್ನು ಬೇಟೆಯಾಡಿದರೆ ಅಥವಾ ಪಕ್ಷಿಯನ್ನು ಹಿಡಿದರೆ, ಅವನು ಅದರ ರಕ್ತವನ್ನು ನೆಲದ ಮೇಲೆ ಸುರಿದು ಅದನ್ನು ಮಣ್ಣಿನಿಂದ ಮುಚ್ಚಿಬಿಡಬೇಕು. ಅವನು ಇಸ್ರೇಲನಾದರೂ ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುವ ಪರದೇಶಸ್ಥನಾದರೂ ಹಾಗೆಯೇ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ನೀವು ಇದನ್ನು ಯಾಕೆ ಮಾಡಬೇಕೆಂದರೆ, ಮಾಂಸದಲ್ಲಿ ರಕ್ತವು ಇನ್ನೂ ಇದ್ದರೆ, ಅದರ ಪ್ರಾಣವು ಇನ್ನೂ ಮಾಂಸದಲ್ಲಿ ಇದೆ. ಆದ್ದರಿಂದ ನಾನು ಇಸ್ರೇಲರಿಗೆ ಈ ಅಪ್ಪಣೆಯನ್ನು ಕೊಡುತ್ತೇನೆ. ರಕ್ತದಿಂದ ಕೂಡಿರುವ ಮಾಂಸವನ್ನು ತಿನ್ನಬಾರದು. ಯಾವನಾದರೂ ರಕ್ತ ಭೋಜನ ಮಾಡಿದರೆ, ಅವನು ತನ್ನ ಜನರಿಂದ ತೆಗೆದುಹಾಕಲ್ಪಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ಅಲ್ಲದೆ ಯಾವನಾದರೂ ತನ್ನಷ್ಟಕ್ಕೆ ಸತ್ತ ಪ್ರಾಣಿಯನ್ನು ತಿಂದರೆ ಅಥವಾ ಬೇರೆ ಪ್ರಾಣಿಯಿಂದ ಕೊಲ್ಲಲ್ಪಟ್ಟ ಪ್ರಾಣಿಯನ್ನು ತಿಂದರೆ, ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡು ನೀರಿನಲ್ಲಿ ಸ್ನಾನಮಾಡಿಕೊಳ್ಳಬೇಕು. ಅವನು ಇಸ್ರೇಲನಾಗಿದ್ದರೂ ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುವ ಪರದೇಶಸ್ಥನಾಗಿದ್ದರೂ ಹಾಗೆಯೇ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳದೆಯೂ ಸ್ನಾನ ಮಾಡಿಕೊಳ್ಳದೆಯೂ ಹೋದರೆ ಆಗ ಅವನು ಪಾಪಮಾಡಿದ ದೋಷಿಯಾಗಿರುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ನಾನು ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ಹಿಂದೆ ನೀವು ಈಜಿಪ್ಟಿನಲ್ಲಿ ವಾಸಿಸಿದಿರಿ. ಈಜಿಪ್ಟಿನ ಜನರು ಆಚರಿಸುವ ಆಚಾರಗಳನ್ನು ನೀವು ಅನುಸರಿಸಬಾರದು. ಆ ದೇಶದಲ್ಲಿ ಮಾಡುತ್ತಿದ್ದ ಕಾರ್ಯಗಳನ್ನು ನೀವು ಮಾಡಬಾರದು. ನಾನು ನಿಮ್ಮನ್ನು ಕಾನಾನಿಗೆ ನಡೆಸುತ್ತಿದ್ದೇನೆ. ಆ ದೇಶದಲ್ಲಿ ಮಾಡುವ ಕಾರ್ಯಗಳನ್ನು ನೀವು ಮಾಡಕೂಡದು. ಅವರ ಸಂಪ್ರದಾಯಗಳನ್ನು ಅನುಸರಿಸಬೇಡಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ನೀವು ನನ್ನ ನಿಯಮಗಳಿಗೆ ವಿಧೇಯರಾಗಿ ನನ್ನ ಕಟ್ಟಳೆಗಳನ್ನು ಅನುಸರಿಸಬೇಕು. ಆ ನಿಯಮಗಳನ್ನು ತಪ್ಪದೆ ಪಾಲಿಸಿರಿ. ಯಾಕೆಂದರೆ ನಾನು ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ಆದ್ದರಿಂದ ನೀವು ನನ್ನ ಕಟ್ಟಳೆಗಳಿಗೆ ಮತ್ತು ನಿಯಮಗಳಿಗೆ ವಿಧೇಯರಾಗಬೇಕು. ಒಬ್ಬನು ನನ್ನ ಕಟ್ಟಳೆಗಳಿಗೆ ಮತ್ತು ನಿಯಮಗಳಿಗೆ ವಿಧೇಯನಾದರೆ, ಅವನು ಜೀವಿಸುವನು! ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ನೀವು ಎಂದಿಗೂ ನಿಮ್ಮ ಹತ್ತಿರದ ಸಂಬಂಧಿಗಳೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ತಾಯಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಿ ನಿಮ್ಮ ತಂದೆಗೆ ಎಂದಿಗೂ ಅವಮಾನ ತರಬಾರದು. ಆಕೆ ನಿಮ್ಮ ತಾಯಿಯಾಗಿದ್ದಾಳೆ. ನೀವು ಆಕೆಯೊಂದಿಗೆ ಎಂದಿಗೂ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ಮಲತಾಯಿಯೊಂದಿಗೂ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಅದು ನಿಮ್ಮ ತಂದೆಗೆ ಅವಮಾನ ತರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ಸಹೋದರಿಯೊಂದಿಗೆ, ಅಂದರೆ ನಿಮ್ಮ ತಂದೆ ಅಥವಾ ತಾಯಿಯ ಮಗಳೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ನಿಮ್ಮ ಸಹೋದರಿಯು ನಿಮ್ಮ ಮನೆಯಲ್ಲಾಗಲಿ ಅಥವಾ ಇನ್ನೊಂದು ಸ್ಥಳದಲ್ಲಾಗಲಿ ಹುಟ್ಟಿದರೂ ಆಕೆಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ನೀವು ನಿಮ್ಮ ಮೊಮ್ಮಗಳೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಅದು ನಿಮಗೆ ಅವಮಾನ ತರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ತಂದೆಗೆ ಮತ್ತು ಅವನ ಹೆಂಡತಿಗೆ ಒಬ್ಬ ಮಗಳಿದ್ದರೆ, ಆಕೆ ನಿಮ್ಮ ಸಹೋದರಿಯಾಗಿದ್ದಾಳೆ. ನೀವು ಆಕೆಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ತಂದೆಯ ಸಹೋದರಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಆಕೆಯು ನಿಮ್ಮ ತಂದೆಯ ಹತ್ತಿರದ ಸಂಬಂಧಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ತಾಯಿಯ ಸಹೋದರಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಆಕೆಯು ನಿಮ್ಮ ತಾಯಿಯ ಹತ್ತಿರದ ಸಂಬಂಧಿಯಾಗಿದ್ದಾಳೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ನೀವು ನಿಮ್ಮ ತಂದೆಯ ಸಹೋದರನ ಹೆಂಡತಿಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧವಿಟ್ಟುಕೊಂಡರೆ ಅವನನ್ನು ಅವಮಾನಪಡಿಸಿದಂತಾಗುವುದು. ಯಾಕೆಂದರೆ ಆಕೆಯು ನಿಮ್ಮ ದೊಡ್ಡಮ್ಮ ಅಥವಾ ಚಿಕ್ಕಮ್ಮ. ");
INSERT INTO kan2010_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ಸೊಸೆಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಆಕೆಯು ನಿಮ್ಮ ಮಗನ ಹೆಂಡತಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ಸಹೋದರನ ಹೆಂಡತಿಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಅಂಥ ಸಂಬಂಧವು ನಿಮ್ಮ ಸಹೋದರನಿಗೆ ಅವಮಾನವನ್ನು ಉಂಟುಮಾಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ಒಬ್ಬ ಸ್ತ್ರೀಯೊಡನೆಯೂ ಆಕೆಯ ಮಗಳೊಡನೆಯೂ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಆ ಸ್ತ್ರೀಯ ಮೊಮ್ಮಗಳೊಡನೆಯೂ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಈ ಮೊಮ್ಮಗಳು ಈ ಸ್ತ್ರೀಯ ಮಗನ ಅಥವಾ ಮಗಳ ಮಗಳಾಗಿರಬಹುದು. ಆಕೆಯ ಮೊಮ್ಮಕ್ಕಳಾದ ಹೆಣ್ಣುಮಕ್ಕಳು ಆಕೆಯ ಹತ್ತಿರದ ಸಂಬಂಧಿಕರಾಗಿದ್ದಾರೆ. ಆಕೆಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡುವುದು ತಪ್ಪು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ಹೆಂಡತಿ ಇನ್ನೂ ಜೀವದಿಂದಿರುವಾಗ, ಆಕೆಯ ಸಹೋದರಿಯನ್ನು ಹೆಂಡತಿಯನ್ನಾಗಿ ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ಇಲ್ಲವಾದರೆ ಆ ಇಬ್ಬರು ಸಹೋದರಿಯರು ಒಬ್ಬರಿಗೊಬ್ಬರು ವೈರಿಗಳಾಗುವರು. ಹೆಂಡತಿಯ ಸಹೋದರಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ಅಲ್ಲದೆ ಸ್ತ್ರೀಯು ಮುಟ್ಟಿನಿಂದ ಅಶುದ್ಧಳಾಗಿರುವಾಗ ಲೈಂಗಿಕ ಸಂಬಂಧಕ್ಕಾಗಿ ಆಕೆಯ ಹತ್ತಿರ ಹೋಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ನೆರೆಯವನ ಹೆಂಡತಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಇಂಥ ಸಂಬಂಧವು ನಿಮ್ಮನ್ನು ಅಶುದ್ಧರನ್ನಾಗಿ ಮಾಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ನೀವು ನಿಮ್ಮ ಯಾವ ಮಕ್ಕಳನ್ನೂ ಅಗ್ನಿಯ ಮೂಲಕ ಮೊಲೆಕನಿಗೆ ಕೊಡಬಾರದು. ಇಲ್ಲವಾದರೆ ನೀವು ನಿಮ್ಮ ದೇವರ ಹೆಸರನ್ನು ಅಪಕೀರ್ತಿಗೆ ಗುರಿಮಾಡುವಿರಿ. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ಸ್ತ್ರೀಯನ್ನು ಸಂಗಮಿಸುವಂತೆ ಪುರುಷನನ್ನು ಸಂಗಮಿಸಬಾರದು. ಅದು ಭಯಂಕರ ಪಾಪ! ");
INSERT INTO kan2010_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ಪಶುವಿನೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಇಂಥ ಸಂಬಂಧವು ನಿಮ್ಮನ್ನು ಅಪವಿತ್ರರನ್ನಾಗಿ ಮಾಡುವುದು. ಅಲ್ಲದೆ ಸ್ತ್ರೀಯು ಪಶುವಿನೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಪಡೆಯಬಾರದು. ಇಂಥ ಸಂಬಂಧ ಸ್ವಭಾವಕ್ಕೆ ವಿರುದ್ದವಾದದ್ದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ಆ ದುರಾಚಾರಗಳಲ್ಲಿ ಯಾವುದರಿಂದಲೂ ನಿಮ್ಮನ್ನು ಅಶುದ್ಧರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ನಾನು ಜನಾಂಗಗಳನ್ನು ಅವರ ದೇಶಗಳಿಂದ ಹೊರಡಿಸಿ ಅವರ ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಡುತ್ತಿದ್ದೇನೆ. ಯಾಕೆಂದರೆ ಅವರು ಅಂಥ ಭಯಂಕರ ಪಾಪಗಳನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ಆದ್ದರಿಂದ ದೇಶವು ಸಹ ಅಶುದ್ಧವಾಯಿತು. ಆದ್ದರಿಂದ ನಾನು ಅದನ್ನು ಅದರ ಪಾಪಗಳಿಗಾಗಿ ದಂಡಿಸಿದೆನು. ಆ ದೇಶವು ತನ್ನಲ್ಲಿ ವಾಸಿಸಿದ ಜನರನ್ನು ಕಾರಿಬಿಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","“ಆದ್ದರಿಂದ ನೀವು ನನ್ನ ಕಟ್ಟಳೆಗಳಿಗೂ ನಿಯಮಗಳಿಗೂ ಆಜ್ಞಾವಿಧಿಗಳಿಗೂ ವಿಧೇಯರಾಗಬೇಕು. ನೀವು ಆ ಭಯಂಕರ ಪಾಪಗಳಲ್ಲಿ ಯಾವುದನ್ನೂ ಮಾಡಬಾರದು. ಆ ವಿಧಿಗಳು ಇಸ್ರೇಲರಿಗಾಗಿ ಮತ್ತು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುವ ಜನರಿಗಾಗಿ ಇರುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ನಿಮಗಿಂತ ಮುಂಚೆ ಈ ದೇಶದಲ್ಲಿ ವಾಸಿಸಿದ ಜನರು ಆ ಭಯಂಕರ ಕೃತ್ಯಗಳನ್ನು ಮಾಡಿದರು. ಆದ್ದರಿಂದ ದೇಶವು ಹೊಲೆಯಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ನೀವು ಈ ಕಾರ್ಯಗಳನ್ನು ಮಾಡಿದರೆ, ನೀವು ಆ ದೇಶವನ್ನು ಹೊಲೆಮಾಡುವಿರಿ. ಅದು ಮೊದಲು ವಾಸಿಸಿದ ಜನಾಂಗಗಳನ್ನು ಕಾರಿಬಿಟ್ಟಂತೆ ನಿಮ್ಮನ್ನೂ ಕಾರಿಬಿಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ಯಾವನಾದರೂ ಆ ಭಯಂಕರ ಪಾಪಗಳಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ಮಾಡಿದರೆ, ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅವನ ಜನರಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ಅನ್ಯಜನರು ಆ ಭಯಂಕರ ಪಾಪಗಳನ್ನು ಮಾಡಿದ್ದಾರೆ. ಆದರೆ ನೀವು ನನ್ನ ಕಟ್ಟಳೆಗಳಿಗೆ ವಿಧೇಯರಾಗಬೇಕು. ನೀವು ಆ ಭಯಂಕರ ಪಾಪಗಳಲ್ಲಿ ಯಾವುದನ್ನೂ ಮಾಡಬಾರದು. ಆ ಭಯಂಕರ ಪಾಪಗಳಿಂದ ನಿಮ್ಮನ್ನು ಹೊಲೆ ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು.” ");
INSERT INTO kan2010_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಾನು ಪರಿಶುದ್ಧನಾಗಿರುವಂತೆಯೇ ನೀವೂ ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನ ತಂದೆತಾಯಿಗಳನ್ನು ಸನ್ಮಾನಿಸಬೇಕು; ನನ್ನ ವಿಶ್ರಾಂತಿಯ ವಿಶೇಷ ದಿನಗಳನ್ನು ಆಚರಿಸಬೇಕು. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ವಿಗ್ರಹಾರಾಧನೆ ಮಾಡಬೇಡಿರಿ! ಎರಕದ ವಿಗ್ರಹಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ನೀವು ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವಾಗ, ನೀವು ಅಂಗೀಕೃತರಾಗುವಂತೆ ಅವುಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ನೀವು ಅರ್ಪಿಸಿದ ದಿನದಲ್ಲಿ ಅಥವಾ ಮರುದಿನದಲ್ಲಿ ಅದನ್ನು ತಿನ್ನಬಹುದು. ಆದರೆ ಆ ಯಜ್ಞದಲ್ಲಿ ಏನಾದರೂ ಮೂರನೆಯ ದಿನದವರೆಗೆ ಉಳಿದರೆ, ನೀವು ಅದನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಬಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ಅದರಲ್ಲಿ ಯಾವುದನ್ನಾದರೂ ಮೂರನೆಯ ದಿನದಲ್ಲಿ ತಿಂದರೆ, ಅದು ಅಪವಿತ್ರವಾಗುವುದು. ಅದು ಅಂಗೀಕೃತವಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ಒಬ್ಬನು ಅದನ್ನು ಮೂರನೆಯ ದಿನದಲ್ಲಿ ತಿಂದರೆ ಅವನು ಪಾಪಮಾಡಿದ ದೋಷಿಯಾಗಿರುವನು. ಯಾಕೆಂದರೆ ಯೆಹೋವನಿಗೆ ಮೀಸಲಾದ ಪವಿತ್ರ ವಸ್ತುಗಳ ವಿಷಯದಲ್ಲಿ ಅವನಿಗೆ ಗೌರವವಿಲ್ಲ; ಆ ವ್ಯಕ್ತಿಯನ್ನು ಅವನ ಜನರಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ಸುಗ್ಗಿಕಾಲದಲ್ಲಿ ನಿಮ್ಮ ಬೆಳೆಯನ್ನು ಕೊಯ್ಯುವಾಗ, ಹೊಲಗಳ ಮೂಲೆಗಳಲ್ಲಿರುವುದನ್ನೆಲ್ಲಾ ಕೊಯ್ಯಬೇಡಿರಿ; ಧಾನ್ಯವೇನಾದರೂ ನೆಲದ ಮೇಲೆ ಬಿದ್ದರೆ ಅದನ್ನು ಕೂಡಿಸಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ನಿಮ್ಮ ದ್ರಾಕ್ಷಿತೋಟಗಳಲ್ಲಿರುವ ದ್ರಾಕ್ಷಿಗಳನ್ನೆಲ್ಲಾ ತೆಗೆದುಕೊಳ್ಳಬೇಡಿರಿ: ನೆಲದ ಮೇಲೆ ಬೀಳುವ ದ್ರಾಕ್ಷಿಹಣ್ಣುಗಳನ್ನು ಹೆಕ್ಕಿಕೊಳ್ಳಬಾರದು. ಯಾಕೆಂದರೆ ನೀವು ಅವುಗಳನ್ನು ಬಡವರಿಗಾಗಿಯೂ ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸಿಸಲು ಬಂದ ಪರದೇಶಸ್ಥರಿಗಾಗಿಯೂ ಬಿಡಬೇಕು. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ನೀವು ಕದಿಯಬಾರದು; ಮೋಸಮಾಡಬಾರದು; ಒಬ್ಬರಿಗೊಬ್ಬರು ಸುಳ್ಳಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","ನೀವು ನನ್ನ ಹೆಸರನ್ನು ಉಪಯೋಗಿಸಿ ಸುಳ್ಳಾಣೆ ಇಟ್ಟುಕೊಳ್ಳಬಾರದು; ಇಲ್ಲವಾದರೆ ನೀವು ದೇವರ ಹೆಸರನ್ನು ಅಪಕೀರ್ತಿಗೆ ಗುರಿಪಡಿಸುವಿರಿ; ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ನಿಮ್ಮ ನೆರೆಯವನಿಗೆ ಕೆಡುಕುಗಳನ್ನು ಮಾಡಬಾರದು. ನೀವು ಅವನನ್ನು ಸುಲಿಗೆ ಮಾಡಬಾರದು. ನಿಮ್ಮ ಕೂಲಿಯವರ ಕೂಲಿಯನ್ನು ಮರುದಿನದ ಮುಂಜಾನೆಯವರೆಗೆ ಹಿಡಿದಿಟ್ಟುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ನೀವು ಕಿವುಡನನ್ನು ಶಪಿಸಬಾರದು. ಕುರುಡನು ಬೀಳುವಂತೆ ನೀವು ಅವನ ಮುಂದೆ ಅಡ್ಡವಾಗಿ ಏನನ್ನೂ ಇಡಬಾರದು. ಆದರೆ ನೀವು ನಿಮ್ಮ ದೇವರನ್ನು ಸನ್ಮಾನಿಸಬೇಕು. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ನೀವು ಕೊಡುವ ತೀರ್ಪು ನ್ಯಾಯವಾಗಿರಬೇಕು. ಬಡವರ ಬಡತನವನ್ನಾಗಲಿ ಪ್ರಾಮುಖ್ಯರ ದೊಡ್ಡಸ್ತಿಕೆಯನ್ನಾಗಲಿ ಗಮನಿಸದೆ ಪಕ್ಷಪಾತವಿಲ್ಲದೆ ತೀರ್ಪುಕೊಡಬೇಕು. ನೀವು ನಿಮ್ಮ ನೆರೆಯವನಿಗೆ ತೀರ್ಪುಮಾಡುವಾಗ ನ್ಯಾಯದ ತೀರ್ಪುಕೊಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","ಬೇರೆ ಜನರ ವಿರುದ್ಧ ಚಾಡಿ ಹೇಳಬಾರದು. ನಿಮ್ಮ ನೆರೆಯವನ ಪ್ರಾಣವನ್ನು ಅಪಾಯಕ್ಕೆ ಈಡುಮಾಡುವ ಯಾವ ಕಾರ್ಯವನ್ನೂ ನೀವು ಮಾಡಬಾರದು. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ನೀವು ನಿಮ್ಮ ಸಹೋದರನನ್ನು ಮನಸ್ಸಿನಲ್ಲಿ ದ್ವೇಷಿಸಬಾರದು. ನಿಮ್ಮ ಸಹೋದರನು ಏನಾದರೂ ತಪ್ಪುಮಾಡಿದರೆ, ಅವನೊಡನೆ ಅದರ ಕುರಿತು ಮಾತಾಡು. ಅವನ ಅಪರಾಧದಲ್ಲಿ ನೀವು ಪಾಲುಹೊಂದದಂತೆ ನೇರವಾಗಿ ಗದರಿಸಿ. ಆಗ ನೀವು ಅವನನ್ನು ಕ್ಷಮಿಸಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","ಜನರು ನಿಮಗೆ ಮಾಡುವ ಕೆಟ್ಟಕಾರ್ಯಗಳನ್ನು ಮರೆತುಬಿಡಿರಿ. ನಿಮ್ಮ ಜನರಲ್ಲಿ ಒಬ್ಬನಾಗಿರುವವನ ಮೇಲೆ ಸೇಡನ್ನು ತೀರಿಸಿಕೊಳ್ಳಲು ಪ್ರಯತ್ನಿಸಬೇಡಿರಿ; ದ್ವೇಷವನ್ನೂ ಇಟ್ಟುಕೊಳ್ಳಬೇಡಿ. ನಿಮ್ಮ ನೆರೆಯವನನ್ನು ನಿಮ್ಮಂತೆಯೇ ಪ್ರೀತಿಸಿರಿ. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ನೀವು ನನ್ನ ಕಟ್ಟಳೆಗಳಿಗೆ ವಿಧೇಯರಾಗಿರಬೇಕು. ಎರಡು ಬೇರೆ ಜಾತಿಯ ಪಶುಗಳನ್ನು ಒಟ್ಟಿಗೆ ಸೇರಿಸಿ ಈಯಿಸಬಾರದು. ನಿಮ್ಮ ಹೊಲಗಳಲ್ಲಿ ಎರಡು ವಿಧದ ಬೀಜಗಳನ್ನು ಬಿತ್ತಬಾರದು. ಎರಡು ವಿಧದ ದಾರಗಳನ್ನು ಸೇರಿಸಿ ಮಾಡಿದ ಬಟ್ಟೆಯನ್ನು ಧರಿಸಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ಇನ್ನೊಬ್ಬನ ದಾಸಿಯಾಗಿರುವ ಸ್ತ್ರೀಯೊಡನೆ ಒಬ್ಬನು ಲೈಂಗಿಕ ಸಂಬಂಧವಿಟ್ಟುಕೊಂಡಿದ್ದರೆ, ಈ ದಾಸಿಯು ಹಣದಿಂದಾಗಲಿ ಉಚಿತವಾಗಿಯಾಗಲಿ ಬಿಡುಗಡೆಯಾಗಲು ಸಾಧ್ಯವಿಲ್ಲದಿದ್ದರೆ ಅವರಿಬ್ಬರಿಗೆ ಶಿಕ್ಷೆ ವಿಧಿಸಬೇಕು. ಆದರೆ ಅವರಿಗೆ ಮರಣ ಶಿಕ್ಷೆಯಾಗಬಾರದು. ಯಾಕೆಂದರೆ ಸ್ತ್ರೀಯು ಸ್ವತಂತ್ರಳಾಗಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ಪುರುಷನು ತನ್ನ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಟಗರನ್ನು ಯೆಹೋವನ ಬಳಿಗೆ ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿಗೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ಯಾಜಕನು ಅವನನ್ನು ಶುದ್ಧಿಮಾಡುವ ಕಾರ್ಯಗಳನ್ನು ಮಾಡುವನು. ಯಾಜಕನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಟಗರನ್ನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸುವನು. ಅದು ಆ ಪುರುಷನು ಮಾಡಿದ ಪಾಪಗಳ ಪರಿಹಾರಕ್ಕಾಗಿರುವುದು. ಆಗ ಅವನಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ಮುಂದೆ ನೀವು ನಿಮ್ಮ ದೇಶವನ್ನು ಪ್ರವೇಶಿಸುವಿರಿ. ಆ ಸಮಯದ ಆಹಾರಕ್ಕಾಗಿ ಅನೇಕ ವಿಧಗಳ ಮರಗಳನ್ನು ನೆಡುವಿರಿ. ಸಸಿಯನ್ನು ನೆಟ್ಟನಂತರ, ನೀವು ಆ ಮರದಿಂದ ಹಣ್ಣನ್ನು ಉಪಯೋಗಿಸುವುದಕ್ಕೆ ಮೂರು ವರ್ಷಗಳು ಕಾಯಬೇಕು. ನೀವು ಆ ಹಣ್ಣನ್ನು ಉಪಯೋಗಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ನಾಲ್ಕನೆಯ ವರ್ಷದಲ್ಲಿ ಆ ಮರದ ಹಣ್ಣು ಯೆಹೋವನದಾಗುವುದು. ಅದು ಯೆಹೋವನ ಸ್ತುತಿಗೆ ಅರ್ಪಿತವಾಗುವ ಪವಿತ್ರ ಕಾಣಿಕೆಯಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ಬಳಿಕ ಐದನೆಯ ವರ್ಷದಲ್ಲಿ, ನೀವು ಆ ಮರದ ಹಣ್ಣನ್ನು ತಿನ್ನಬಹುದು ಮತ್ತು ಮರವು ನಿಮಗೆ ಹೆಚ್ಚೆಚ್ಚಾಗಿ ಹಣ್ಣನ್ನು ನೀಡುವುದು. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ರಕ್ತಸಹಿತವಾದ ಮಾಂಸವನ್ನು ನೀವು ತಿನ್ನಬಾರದು. “ನೀವು ಕಣಿ ಹೇಳಬಾರದು; ಮಂತ್ರತಂತ್ರಗಳನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ನಿಮ್ಮ ಮುಖದ ಪಾರ್ಶ್ವದಲ್ಲಿ ಬೆಳೆಯುವ ಕೂದಲನ್ನು ನೀವು ಕತ್ತರಿಸಬಾರದು. ನಿಮ್ಮ ಮುಖದ ಪಾರ್ಶ್ವದಲ್ಲಿರುವ ಗಡ್ಡವನ್ನು ಕತ್ತರಿಸಿಕೊಳ್ಳುವುದರ ಮೂಲಕ ನೀವು ನಿಮ್ಮ ಗಡ್ಡವನ್ನು ವಿಕಾರ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","ಸತ್ತವರನ್ನು ಜ್ಞಾಪಕ ಮಾಡಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ನಿಮ್ಮ ದೇಹವನ್ನು ಗಾಯ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ಶರೀರದ ಮೇಲೆ ಹಚ್ಚೇ ಚುಚ್ಚಿಸಿಕೊಳ್ಳಬಾರದು. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ಮಗಳನ್ನು ಸೂಳೆಯನ್ನಾಗಿ ಮಾಡಬಾರದು. ಇದರಿಂದ ಸೂಳೆಗಾರಿಕೆ ಹೆಚ್ಚಾಗುತ್ತದೆ. ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಸೂಳೆಗಾರಿಕೆ ಇರದಂತೆ ನೋಡಿಕೊಳ್ಳಿರಿ. ಇಂಥ ಪಾಪದಿಂದ ನಿಮ್ಮ ದೇಶವು ತುಂಬಿಹೋಗಲು ಬಿಡಬೇಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ನೀವು ನನ್ನ ಸಬ್ಬತ್ ದಿನಗಳನ್ನು ಅನುಸರಿಸಬೇಕು. ನನ್ನ ವಿಶ್ರಾಂತಿಯ ವಿಶೇಷ ದಿನಗಳಲ್ಲಿ ನೀವು ಕೆಲಸ ಮಾಡಬಾರದು. ನೀವು ನನ್ನ ಪವಿತ್ರಸ್ಥಳವನ್ನು ಗೌರವಿಸಬೇಕು. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ಸಲಹೆಗಾಗಿ, ಸತ್ತವರಲ್ಲಿ ವಿಚಾರಿಸುವವರ ಮತ್ತು ಬೇತಾಳಿಕರ ಬಳಿಗೆ ಹೋಗಬೇಡಿರಿ. ಅವರು ನಿಮ್ಮನ್ನು ಕೇವಲ ಅಶುದ್ಧರನ್ನಾಗಿ ಮಾಡುವರು. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ವೃದ್ಧರ ಮುಂದೆ ಎದ್ದು ನಿಂತುಕೊಳ್ಳಿರಿ. ಹಿರಿಯರಿಗೆ ಗೌರವಕೊಡಿರಿ. ನಿಮ್ಮ ದೇವರನ್ನು ಸನ್ಮಾನಿಸಿರಿ. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸಿಸುವ ಪರದೇಶಸ್ಥರಿಗೆ ಕೆಟ್ಟದ್ದನ್ನು ಮಾಡಬೇಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ನಿಮ್ಮ ಸ್ವಂತ ದೇಶದವರೊಡನೆ ವರ್ತಿಸುವ ಪ್ರಕಾರ ಪರದೇಶಸ್ಥರೊಡನೆ ವರ್ತಿಸಿರಿ. ನಿಮ್ಮನ್ನು ಪ್ರೀತಿಸುವಂತೆ ಪರದೇಶಸ್ಥರನ್ನು ಪ್ರೀತಿಸಿರಿ. ಯಾಕೆಂದರೆ ನೀವು ಸಹ ಒಂದು ಕಾಲದಲ್ಲಿ ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದಾಗ ಪರದೇಶಸ್ಥರಾಗಿದ್ದಿರಿ. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ನೀವು ಜನರಿಗೆ ತೀರ್ಪುಮಾಡುವಾಗ ನ್ಯಾಯವಾಗಿ ತೀರ್ಪುಮಾಡಬೇಕು. ನೀವು ಅಳೆಯುವಾಗ ಮತ್ತು ತೂಕಮಾಡುವಾಗ ನ್ಯಾಯವಾಗಿ ನಡೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ನಿಮ್ಮ ಪುಟ್ಟಿಗಳು ಸರಿಯಾದ ಪ್ರಮಾಣದ್ದಾಗಿರಬೇಕು. ನಿಮ್ಮ ಕೊಳಗಗಳು ದ್ರವಪದಾರ್ಥಗಳನ್ನು ಸರಿಯಾದ ಪ್ರಮಾಣದಲ್ಲಿ ಹಿಡಿಸಿಕೊಳ್ಳುವಂತವುಗಳಾಗಿರಬೇಕು. ನಿಮ್ಮ ತೂಕದ ಕಲ್ಲುಗಳು ಮತ್ತು ತಕ್ಕಡಿಗಳು ವಸ್ತುಗಳನ್ನು ಸರಿಯಾಗಿ ತೂಕ ಮಾಡುವಂಥವುಗಳಾಗಿರಬೇಕು. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ನಾನು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರತಂದೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ನೀವು ನನ್ನ ಕಟ್ಟಳೆಗಳನ್ನು ಮತ್ತು ನಿಯಮಗಳನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಬೇಕು; ಅವುಗಳಿಗೆ ವಿಧೇಯರಾಗಬೇಕು. ನಾನೇ ಯೆಹೋವನು.” ");
INSERT INTO kan2010_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ನೀನು ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು. ನಿಮ್ಮ ದೇಶದಲ್ಲಿರುವ ಒಬ್ಬನು ತನ್ನ ಮಕ್ಕಳಲ್ಲಿ ಒಬ್ಬನನ್ನು ಸುಳ್ಳು ದೇವರಾದ ಮೊಲೆಕನಿಗೆ ಅರ್ಪಿಸಿದರೆ ಅವನನ್ನು ಕೊಲ್ಲಬೇಕು. ಅವನು ಸ್ವದೇಶಸ್ಥನಾದರೂ ಇಸ್ರೇಲರಲ್ಲಿ ವಾಸಿಸುವ ಪರದೇಶಸ್ಥನಾದರೂ ಅವನನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ನಾನು ಅವನಿಗೆ ವಿರುದ್ಧವಾಗಿರುವೆನು. ನಾನು ಅವನನ್ನು ಅವನ ಕುಟುಂಬದಿಂದ ಬೇರ್ಪಡಿಸುವೆನು. ಯಾಕೆಂದರೆ ಅವನು ತನ್ನ ಮಕ್ಕಳನ್ನು ಮೊಲೆಕನಿಗೆ ಅರ್ಪಿಸುವುದರ ಮೂಲಕ ನನ್ನ ಪವಿತ್ರಾಲಯವನ್ನು ಅಪವಿತ್ರಗೊಳಿಸಿದನು; ನನ್ನ ನಾಮಕ್ಕೆ ಅವಮಾನ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ಒಂದುವೇಳೆ ದೇಶದ ಜನರು ಅವನು ಮಾಡಿದ ಕಾರ್ಯವನ್ನು ನಿರ್ಲಕ್ಷಿಸಿ ಅವನನ್ನು ಕೊಲ್ಲದಿದ್ದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ನಾನು ಅವನಿಗೂ ಅವನ ಕುಟುಂಬಕ್ಕೂ ವಿರುದ್ಧನಾಗಿರುವೆನು; ನಾನು ಅವನನ್ನು ಅವನ ಜನರಿಂದ ಬೇರ್ಪಡಿಸುವೆನು. ಮೊಲೆಕನೊಡನೆ ಸೂಳೆತನ ಮಾಡುವ ಅವನನ್ನೂ ಅವನ ಹಿಂಬಾಲಕರನ್ನೂ ಅವರ ಜನರಿಂದ ಬೇರ್ಪಡಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ಸತ್ತವರಲ್ಲಿ ವಿಚಾರಿಸುವವರ ಮತ್ತು ಬೇತಾಳಿಕರ ಬಳಿಗೆ ಹೋಗುವ ಯಾವುದೇ ವ್ಯಕ್ತಿಯಾದರೂ ಸರಿಯೇ ಅವನಿಗೆ ನಾನು ವಿರುದ್ಧವಾಗಿರುವೆನು. ಆ ವ್ಯಕ್ತಿ ನನಗೆ ಅಪನಂಬಿಗಸ್ತನಾಗಿದ್ದಾನೆ. ಆದ್ದರಿಂದ ನಾನು ಅವನನ್ನು ಅವನ ಕುಲದಿಂದ ತೆಗೆದುಹಾಕುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ನೀವು ನನಗೆ ವಿಶೇಷ ಜನರಾಗಿದ್ದೀರಿ. ನಿಮ್ಮನ್ನು ಪವಿತ್ರರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಿರಿ. ಯಾಕೆಂದರೆ ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು. ನಾನು ಪರಿಶುದ್ಧನಾಗಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ನನ್ನ ನಿಯಮಗಳನ್ನು ಜ್ಞಾಪಕಮಾಡಿ ಅವುಗಳಿಗೆ ವಿಧೇಯರಾಗಿರಿ. ನಿಮ್ಮನ್ನು ಪವಿತ್ರರನ್ನಾಗಿ ಮಾಡುವ ಯೆಹೋವನೇ ನಾನು. ನಿಮ್ಮನ್ನು ನನ್ನ ವಿಶೇಷ ಜನರನ್ನಾಗಿ ಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ಯಾವನಾದರೂ ತನ್ನ ತಂದೆಯನ್ನಾಗಲಿ ತಾಯಿಯನ್ನಾಗಲಿ ಶಪಿಸಿದರೆ, ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ಅವನು ತನ್ನ ತಂದೆತಾಯಿಗಳನ್ನು ಶಪಿಸಿದನು. ಅವನ ಮರಣಕ್ಕೆ ಅವನೇ ಜವಾಬ್ದಾರನಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ಒಬ್ಬನು ನೆರೆಯವನ ಹೆಂಡತಿಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಹೊಂದಿದರೆ, ಆಗ ಅವರಿಬ್ಬರೂ ವ್ಯಭಿಚಾರ ಮಾಡಿದ ದೋಷಿಗಳಾಗಿದ್ದಾರೆ. ಆದ್ದರಿಂದ ಅವರಿಬ್ಬರಿಗೂ ಅಂದರೆ ಗಂಡಸಿಗೂ ಹೆಂಗಸಿಗೂ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು! ");
INSERT INTO kan2010_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ಒಬ್ಬನು ತನ್ನ ತಂದೆಯ ಹೆಂಡತಿಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಬೆಳೆಸಿದರೆ, ಅವನಿಗೂ ಆಕೆಗೂ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ಅವನು ತನ್ನ ತಂದೆಗೆ ಅವಮಾನ ಮಾಡಿದ್ದಾನೆ. ಅವರು ತಮ್ಮ ಮರಣಕ್ಕೆ ತಾವೇ ಜವಾಬ್ದಾರರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ಒಬ್ಬನು ತನ್ನ ಸೊಸೆಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಬೆಳೆಸಿದರೆ, ಅವರಿಬ್ಬರೂ ಕೊಲ್ಲಲ್ಪಡಬೇಕು. ಅವರ ಮರಣಕ್ಕೆ ಅವರೇ ಜವಾಬ್ದಾರರಾಗಿದ್ದಾರೆ. ಅವರು ಬಹಳ ಕೆಟ್ಟದಾದ ಲೈಂಗಿಕ ಪಾಪವನ್ನು ಮಾಡಿದವರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ಒಬ್ಬನು ಸ್ತ್ರೀಯೊಂದಿಗೆ ಸಂಗಮಿಸುವಂತೆ ಪುರುಷನೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಿದರೆ, ಆಗ ಈ ಇಬ್ಬರೂ ಭಯಂಕರವಾದ ಪಾಪ ಮಾಡಿದವರಾಗಿದ್ದಾರೆ. ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ಅವರು ಕೊಲ್ಲಲ್ಪಡಬೇಕು. ಅವರ ಮರಣಕ್ಕೆ ಅವರೇ ಜವಾಬ್ದಾರರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ಒಬ್ಬನು ಒಬ್ಬ ಸ್ತ್ರೀಯೊಂದಿಗೂ ಅವಳ ತಾಯಿಯೊಂದಿಗೂ ಲೈಂಗಿಕ ಸಂಬಂಧಗಳನ್ನು ಬೆಳೆಸಿದರೆ, ಆಗ ಇದು ಲೈಂಗಿಕ ಪಾಪವಾಗಿದೆ. ಜನರು ಆ ಮನುಷ್ಯನನ್ನು ಇಬ್ಬರು ಸ್ತ್ರೀಯರನ್ನು ಬೆಂಕಿಯಿಂದ ಸುಟ್ಟುಹಾಕಬೇಕು. ನಿಮ್ಮ ಜನರ ಮಧ್ಯದಲ್ಲಿ ಈ ಲೈಂಗಿಕ ಪಾಪ ನಡೆಯಲು ಬಿಡಬೇಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ಒಬ್ಬನು ಪಶುವಿನೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಿದರೆ, ಆ ಮನುಷ್ಯನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು ಮತ್ತು ನೀವು ಪಶುವನ್ನು ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ಸ್ತ್ರೀಯು ಪಶುವಿನೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಿದರೆ, ಆಗ ನೀವು ಸ್ತ್ರೀಯನ್ನೂ ಪಶುವನ್ನೂ ಕೊಲ್ಲಬೇಕು. ಅವಳಿಗೆ ಮತ್ತು ಅದಕ್ಕೆ ಮರಣ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ಅವರ ಮರಣಕ್ಕೆ ಅವರೇ ಜವಾಬ್ದಾರರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ಒಬ್ಬನು ತನ್ನ ಸಹೋದರಿಯನ್ನಾಗಲಿ ತನ್ನ ತಂದೆಯ ಅಥವಾ ತಾಯಿಯ ಮಗಳನ್ನಾಗಲಿ ಮದುವೆಯಾಗಿ ಲೈಂಗಿಕ ಸಂಬಂಧ ಬೆಳೆಸಿದರೆ, ಅದು ಅವಮಾನಕರವಾದ ಕಾರ್ಯವಾಗಿದೆ! ಅವರಿಗೆ ಬಹಿರಂಗವಾಗಿ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ಅವರನ್ನು ಅವರ ಕುಲದಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ತನ್ನ ಸಹೋದರಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಿದ ಪುರುಷನಿಗೆ ಅವನು ಮಾಡಿದ ಪಾಪಕ್ಕಾಗಿ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ಒಬ್ಬನು ಸ್ತ್ರೀಯನ್ನು ಅವಳ ತಿಂಗಳ ಮುಟ್ಟಿನ ಸಮಯದಲ್ಲಿ ಸಂಭೋಗ ಮಾಡಿದರೆ, ಅವರಿಬ್ಬರನ್ನೂ ಕುಲದಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ಯಾಕೆಂದರೆ ಅವನು ಅವಳ ಶೋಣಿತಸ್ಥಾನವನ್ನು ಬಯಲುಪಡಿಸಿದನು; ಅವಳು ಬಯಲುಪಡಿಸಿಕೊಂಡಳು. ");
INSERT INTO kan2010_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ತಾಯಿಯ ಸಹೋದರಿ ಅಥವಾ ತಂದೆಯ ಸಹೋದರಿಯೊಂದಿಗೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಬಾರದು. ಅದು ರಕ್ತ ಸಂಬಂಧಿಯೊಡನೆ ಸಂಭೋಗ ಮಾಡಿದ ಪಾಪವಾಗಿದೆ. ನಿಮ್ಮ ಪಾಪಗಳಿಗಾಗಿ ನಿಮಗೆ ಶಿಕ್ಷೆಯಾಗಬೇಕು. (ಅದಕ್ಕೆ ನೀವಿಬ್ಬರೂ ಜವಾಬ್ದಾರರಾಗಿದ್ದೀರಿ.) ");
INSERT INTO kan2010_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ಒಬ್ಬನು ತನ್ನ ದೊಡ್ಡಪ್ಪ ಅಥವಾ ಚಿಕ್ಕಪ್ಪನ ಹೆಂಡತಿಯೊಡನೆ ಮಲಗಿಕೊಳ್ಳಬಾರದು. ಅವರ ಪಾಪಗಳಿಗಾಗಿ ಅವರಿಬ್ಬರಿಗೂ ಶಿಕ್ಷೆಯಾಗುವುದು. ಅವರು ಮಕ್ಕಳಿಲ್ಲದೆ ಸಾಯುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ತನ್ನ ಸಹೋದರನ ಹೆಂಡತಿಯೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಬೆಳೆಸುವುದು ತಪ್ಪಾಗಿದೆ. ಅವನು ತನ್ನ ಸಹೋದರನಿಗೆ ಅವಮಾನ ಮಾಡಿದವನಾಗಿದ್ದಾನೆ. ಅವರಿಗೆ ಮಕ್ಕಳಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ನೀವು ನನ್ನ ಕಟ್ಟಳೆ ಮತ್ತು ನಿಯಮಗಳನ್ನೆಲ್ಲಾ ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಬೇಕು. ನೀವು ಅವುಗಳಿಗೆ ವಿಧೇಯರಾಗಬೇಕು. ನಾನು ನಿಮ್ಮನ್ನು ನಿಮ್ಮ ದೇಶಕ್ಕೆ ನಡಿಸುತ್ತಿದ್ದೇನೆ. ನೀವು ಆ ದೇಶದಲ್ಲಿ ವಾಸಿಸುವಿರಿ. ನೀವು ನನ್ನ ಕಟ್ಟಳೆಗಳಿಗೆ ಮತ್ತು ನಿಯಮಗಳಿಗೆ ವಿಧೇಯರಾದರೆ, ಆಗ ಆ ದೇಶವು ನಿಮ್ಮನ್ನು ಕಾರಿಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ಆ ದೇಶವನ್ನು ಬಿಟ್ಟುಹೋಗುವಂತೆ ಅಲ್ಲಿಯ ಜನರನ್ನು ನಾನು ಹೊರಡಿಸಿಬಿಡುತ್ತಿದ್ದೇನೆ. ಯಾಕೆಂದರೆ ಅವರು ಆ ಪಾಪಗಳನ್ನೆಲ್ಲಾ ಮಾಡಿದರು. ನಾನು ಆ ಪಾಪಗಳನ್ನು ದ್ವೇಷಿಸುತ್ತೇನೆ. ಆದ್ದರಿಂದ ಅವರು ಜೀವಿಸಿದಂತೆ ನೀವು ಜೀವಿಸಬೇಡಿರಿ! ");
INSERT INTO kan2010_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ನೀವು ಅವರ ದೇಶವನ್ನು ಪಡೆಯುವಿರಿ ಎಂದು ನಾನು ನಿಮಗೆ ಹೇಳಿದ್ದೇನೆ. ನಾನು ಅವರ ದೇಶವನ್ನು ನಿಮಗೆ ಕೊಡುವೆನು. ಅದು ನಿಮ್ಮ ದೇಶವಾಗಿರುವದು. ಅದು ಅನೇಕ ಒಳ್ಳೆ ಸಂಗತಿಗಳಿಂದ ತುಂಬಿದ ದೇಶವಾಗಿದೆ. ನಾನು ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವನು! “ನಾನು ನಿಮ್ಮನ್ನು ನನ್ನ ವಿಶೇಷ ಜನರನ್ನಾಗಿ ಮಾಡಿಕೊಂಡಿದ್ದೇನೆ. ನಾನು ನಿಮ್ಮನ್ನು ಇತರ ಜನರಿಂದ ಆರಿಸಿಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ಆದ್ದರಿಂದ ಶುದ್ಧವಾದ ಪ್ರಾಣಿಗಳನ್ನು ಅಶುದ್ಧವಾದ ಪ್ರಾಣಿಗಳಿಗಿಂತ ಭಿನ್ನವಾಗಿ ಕಾಣಬೇಕು. ನೀವು ಶುದ್ಧವಾದ ಪಕ್ಷಿಗಳನ್ನು ಅಶುದ್ಧವಾದ ಪಕ್ಷಿಗಳಿಗಿಂತ ಭಿನ್ನವಾಗಿ ಕಾಣಬೇಕು. ಆ ಅಶುದ್ಧವಾದ ಪಕ್ಷಿಗಳಲ್ಲಿ, ಪ್ರಾಣಿಗಳಲ್ಲಿ ಮತ್ತು ನೆಲದ ಮೇಲೆ ಹರಿದಾಡುವ ಪ್ರಾಣಿಗಳಲ್ಲಿ ಯಾವುದನ್ನೂ ತಿನ್ನಬೇಡಿರಿ. ನಾನು ಅವುಗಳನ್ನು ಅಶುದ್ಧವಾಗಿ ಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ನಾನು ನಿಮ್ಮನ್ನು ಇತರ ಜನಾಂಗಗಳಿಂದ ಪ್ರತ್ಯೇಕಿಸಿ, ನನ್ನ ವಿಶೇಷ ಜನರನ್ನಾಗಿ ಮಾಡಿದ್ದೇನೆ. ಆದ್ದರಿಂದ ನೀವು ಪರಿಶುದ್ಧರಾಗಿರಬೇಕು. ಯಾಕೆಂದರೆ ನಾನು ಯೆಹೋವನು ಮತ್ತು ನಾನು ಪರಿಶುದ್ಧನಾಗಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ಸತ್ತವರಲ್ಲಿ ವಿಚಾರಿಸುವವರು ಅಥವಾ ಬೇತಾಳಿಕರು, ಪುರುಷರಾಗಲಿ ಸ್ತ್ರೀಯರಾಗಲಿ ಆಗಿದ್ದರೂ, ಅವರಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ಜನರು ಅವರನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ಅವರ ಮರಣಕ್ಕೆ ಅವರೇ ಜವಾಬ್ದಾರರಾಗಿದ್ದಾರೆ.” ");
INSERT INTO kan2010_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಯಾಜಕರಾದ ಆರೋನನ ಮಕ್ಕಳಿಗೆ ಈ ಸಂಗತಿಗಳನ್ನು ಹೇಳು: ಯಾಜಕನು ಸತ್ತ ವ್ಯಕ್ತಿಯನ್ನು ಮುಟ್ಟಿ ತನ್ನನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ಆದರೆ ಸತ್ತವನು ಅವನ ಹತ್ತಿರದ ಸಂಬಂಧಿಕರಲ್ಲಿ ಒಬ್ಬನಾಗಿದ್ದರೆ, ಆಗ ಅವನು ಆ ಹೆಣವನ್ನು ಮುಟ್ಟಬಹುದು. ಸತ್ತ ವ್ಯಕ್ತಿ ಅವನ ತಾಯಿ, ತಂದೆ, ಮಗ, ಮಗಳು, ಸಹೋದರ ಅಥವಾ ");
INSERT INTO kan2010_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ಮದುವೆಯಾಗದ ಸಹೋದರಿಯಾಗಿದ್ದರೆ ಯಾಜಕನು ತನ್ನನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳಬಹುದು. (ಈ ಸಹೋದರಿಗೆ ಗಂಡನಿಲ್ಲದಿರುವುದರಿಂದ ಅವಳು ಅವನಿಗೆ ಹತ್ತಿರದ ಸಂಬಂಧಿಯಾಗಿದ್ದಾಳೆ. ಆದ್ದರಿಂದ ಯಾಜಕನು ತನ್ನನ್ನು ಅಶುದ್ಧಮಾಡಿಕೊಳ್ಳಬಹುದು.) ");
INSERT INTO kan2010_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ಆದರೆ ಸತ್ತವನು ಕೇವಲ ಅವನ ಗುಲಾಮರಲ್ಲಿ ಒಬ್ಬನಾಗಿದ್ದರೆ ಯಾಜಕನು ತನ್ನನ್ನು ಅಶುದ್ಧ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ಯಾಜಕರು ತಮ್ಮ ತಲೆಗಳನ್ನು ಬೋಳಿಸಿಕೊಳ್ಳಬಾರದು; ತಮ್ಮ ಗಡ್ಡದ ಪಾರ್ಶ್ವಗಳನ್ನು ಕತ್ತರಿಸಿ ವಿಕಾರಗೊಳಿಸಬಾರದು; ತಮ್ಮ ದೇಹಗಳಲ್ಲಿ ಯಾವ ಗಾಯ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ಅವರು ತಮ್ಮ ದೇವರಿಗೆ ಪ್ರತಿಷ್ಠಿತರಾಗಿರಬೇಕು. ಅವರು ದೇವರ ಹೆಸರಿಗೆ ಗೌರವ ತೋರಿಸಬೇಕು. ಯಾಕೆಂದರೆ ಅವರು ಅಗ್ನಿಯ ಮೂಲಕ ಅರ್ಪಿಸಿದ ರೊಟ್ಟಿಯನ್ನು ಮತ್ತು ಕಾಣಿಕೆಗಳನ್ನು ಯೆಹೋವನಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗುತ್ತಾರೆ. ಆದ್ದರಿಂದ ಅವರು ಪವಿತ್ರರಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ಯಾಜಕನು ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ದೇವರ ಸೇವೆ ಮಾಡುತ್ತಾನೆ. ಆದ್ದರಿಂದ ಯಾಜಕನು ಬೇರೆಯವರೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧಮಾಡಿದ ಸ್ತ್ರೀಯನ್ನು ಮದುವೆಯಾಗಬಾರದು. ಯಾಜಕನು ವೇಶ್ಯೆಯನ್ನಾಗಲಿ ಗಂಡ ಬಿಟ್ಟವಳನ್ನಾಗಲಿ ಮದುವೆಯಾಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ಯಾಜಕನು ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ದೇವರ ಸೇವೆ ಮಾಡುತ್ತಾನೆ. ಆದ್ದರಿಂದ ನೀವು ಅವನನ್ನು ವಿಶೇಷವಾದ ರೀತಿಯಲ್ಲಿ ನೋಡಿಕೊಳ್ಳಬೇಕು. ಯಾಕೆಂದರೆ ಅವನು ಪವಿತ್ರ ವಸ್ತುಗಳನ್ನು ಸಮರ್ಪಿಸುತ್ತಾನಲ್ಲ! ಅವನು ದೇವರ ಬಳಿಗೆ ಪವಿತ್ರ ರೊಟ್ಟಿಯನ್ನು ತರುತ್ತಾನೆ. ನಾನೇ ಪರಿಶುದ್ಧನು! ನಾನೇ ಯೆಹೋವನು! ಮತ್ತು ನಾನು ನಿಮ್ಮನ್ನು ಪರಿಶುದ್ಧಗೊಳಿಸುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ಯಾಜಕನ ಮಗಳು ವೇಶ್ಯೆಯಾಗಿದ್ದರೆ, ಅವಳು ತನ್ನ ಗೌರವವನ್ನು ಹಾಳುಮಾಡಿಕೊಂಡವಳೂ ತನ್ನ ತಂದೆಗೆ ಅವಮಾನವನ್ನು ಉಂಟುಮಾಡಿದವಳೂ ಆಗಿದ್ದಾಳೆ. ಅವಳನ್ನು ಸುಟ್ಟುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ಪ್ರಧಾನಯಾಜಕನು ಅವನ ಸಹೋದರರೊಳಗಿಂದ ಆರಿಸಲ್ಪಟ್ಟವನಾಗಿದ್ದಾನೆ. ಅಭಿಷೇಕತೈಲವು ಅವನ ತಲೆಯ ಮೇಲೆ ಹೊಯ್ಯಲ್ಪಟ್ಟಿದೆ. ಈ ರೀತಿಯಾಗಿ ಅವನು ಪ್ರಧಾನಯಾಜಕನ ವಿಶೇಷ ಕೆಲಸಕ್ಕೆ ಆರಿಸಲ್ಪಟ್ಟಿದ್ದಾನೆ. ಅವನು ವಿಶೇಷ ಬಟ್ಟೆಗಳನ್ನು ಧರಿಸಿಕೊಳ್ಳಲು ಆರಿಸಲ್ಪಟ್ಟಿದ್ದಾನೆ. ಆದ್ದರಿಂದ ಅವನು ಬಹಿರಂಗವಾಗಿ ದುಃಖ ಸೂಚಿಸುವ ಕಾರ್ಯಗಳನ್ನು ಮಾಡಬಾರದು. ಅವನು ತನ್ನ ಕೂದಲನ್ನು ಕೆದರಿಕೊಳ್ಳಬಾರದು. ಅವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಳ್ಳಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ಅವನು ಹೆಣವನ್ನು ಮುಟ್ಟಿ ತನ್ನನ್ನು ಅಶುದ್ಧನನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಬಾರದು. ಅದು ಅವನ ತಂದೆಯ ಶವವಾಗಿದ್ದರೂ ಸರಿ, ಅಥವಾ ತಾಯಿಯ ಶವವಾಗಿದ್ದರೂ ಸರಿ, ಅವನು ಅದರ ಬಳಿಗೆ ಹೋಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ಪ್ರಧಾನಯಾಜಕನು ದೇವರ ಪರಿಶುದ್ಧ ಸ್ಥಳವನ್ನು ಬಿಟ್ಟು ಹೊರಗೆ ಹೋದರೆ ಅಶುದ್ಧನಾಗುವನು. ಅಲ್ಲದೆ ಅವನಿಂದ ದೇವರ ಪರಿಶುದ್ಧಸ್ಥಳವು ಅಶುದ್ಧವಾಗುವುದು. ಅಭಿಷೇಕತೈಲವು ಪ್ರಧಾನಯಾಜಕನ ತಲೆಯ ಮೇಲೆ ಹೊಯ್ಯಲ್ಪಟ್ಟಿದೆ. ಇದು ಅವನನ್ನು ಇತರ ಜನರಿಂದ ಪ್ರತ್ಯೇಕಗೊಳಿಸಿದೆ. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ಪ್ರಧಾನಯಾಜಕನು ಕನ್ಯೆಯಾಗಿರುವವಳನ್ನು ಮದುವೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ಪ್ರಧಾನಯಾಜಕನು ಬೇರೆ ಪುರುಷನೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಿದ ಸ್ತ್ರೀಯನ್ನು ಮದುವೆಯಾಗಬಾರದು. ಪ್ರಧಾನಯಾಜಕನು ವೇಶ್ಯಾ ಸ್ತ್ರೀಯನ್ನಾಗಲಿ ಗಂಡ ಬಿಟ್ಟವಳನ್ನಾಗಲಿ ಅಥವಾ ವಿಧವೆಯನ್ನಾಗಲಿ ಮದುವೆಯಾಗಬಾರದು. ಪ್ರಧಾನಯಾಜಕನು ತನ್ನ ಸ್ವಂತ ಜನರಲ್ಲಿ ಒಬ್ಬ ಕನ್ಯೆಯನ್ನು ಮದುವೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ಹೀಗಾಗಿ ಜನರು ಅವನ ಮಕ್ಕಳಿಗೆ ಗೌರವ ತೋರಿಸುವರು. ಯೆಹೋವನಾಗಿರುವ ನಾನು ಪ್ರಧಾನಯಾಜಕನನ್ನು ಅವನ ವಿಶೇಷ ಕೆಲಸಕ್ಕಾಗಿ ಪ್ರತ್ಯೇಕಿಸಿದ್ದೇನೆ.” ");
INSERT INTO kan2010_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ಆರೋನನಿಗೆ ಹೀಗೆ ಹೇಳು: ನಿನ್ನ ಸಂತತಿಯವರ ಮಕ್ಕಳಲ್ಲಿ ಯಾರಾದರೂ ಅಂಗವಿಕಲರಾಗಿದ್ದರೆ, ಅವರು ವಿಶೇಷ ರೊಟ್ಟಿಯನ್ನು ದೇವರ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ಯಾವ ಅಂಗವಿಕಲನೂ ಯಾಜಕನಾಗಿ ಸೇವೆಮಾಡಬಾರದು; ನನಗೆ ಯಜ್ಞಗಳನ್ನು ಅರ್ಪಿಸಬಾರದು. ಯಾಜಕರಾಗಿ ಸೇವೆ ಮಾಡಬಾರದವರು ಯಾರೆಂದರೆ: ಕುರುಡರು, ಕುಂಟರು, ತಮ್ಮ ಮುಖಗಳಲ್ಲಿ ಕೆಟ್ಟದಾದ ಗಾಯದ ಗುರುತುಗಳುಳ್ಳವರು, ಬಹಳ ಉದ್ದವಾದ ಕೈಕಾಲುಗಳುಳ್ಳವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ಮುರಿದ ಕೈಕಾಲುಗಳುಳ್ಳವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ಗೂನು ಬೆನ್ನುಳ್ಳವರು, ದೇಹ ಬೆಳವಣಿಗೆ ನಿಂತುಹೋಗಿರುವವರು, ಕಣ್ಣು ದೋಷವುಳ್ಳವರು, ಕಜ್ಜಿತುರಿಗಳುಳ್ಳವರು ಅಥವಾ ಚರ್ಮರೋಗವುಳ್ಳವರು, ಬೀಜದೋಷವುಳ್ಳವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“ಆರೋನನ ಸಂತತಿಯವರಲ್ಲಿ ಅಂಗವಿಕಲರಾದ ಯಾರೂ ಯೆಹೋವನಿಗೆ ಹೋಮದ್ರವ್ಯಗಳನ್ನು ಸಮರ್ಪಿಸಬಾರದು; ಅಂಥವನು ವಿಶೇಷ ರೊಟ್ಟಿಯನ್ನು ದೇವರ ಬಳಿಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ಅವನು ಯಾಜಕರ ಕುಟುಂಬದವನಾಗಿರುವುದರಿಂದ ಪರಿಶುದ್ಧ ರೊಟ್ಟಿಯನ್ನೂ ಮಹಾಪರಿಶುದ್ಧ ರೊಟ್ಟಿಯನ್ನೂ ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ಆದರೆ ಅವನು ತೆರೆಯ ಬಳಿಗೆ ಹೋಗಬಾರದು; ಅವನು ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಗೆ ಹೋಗಬಾರದು. ಯಾಕೆಂದರೆ ಅವನು ಅಂಗವಿಕಲನಾಗಿದ್ದಾನೆ. ಅವನು ನನ್ನ ಪರಿಶುದ್ಧ ಸ್ಥಳಗಳನ್ನು ಅಶುದ್ಧಗೊಳಿಸಬಾರದು. ಯೆಹೋವನಾದ ನಾನೇ ಆ ಸ್ಥಳಗಳನ್ನು ಪರಿಶುದ್ಧಗೊಳಿಸಿದ್ದೇನೆ.” ");
INSERT INTO kan2010_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ಹೀಗೆ ಮೋಶೆಯು ಈ ಸಂಗತಿಗಳನ್ನು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಮತ್ತು ಇಸ್ರೇಲರೆಲ್ಲರಿಗೂ ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ದೇವರಾದ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಹೀಗೆ ಹೇಳು: ಇಸ್ರೇಲರು ನನಗೆ ಕಾಣಿಕೆಗಳನ್ನು ಸಮರ್ಪಿಸುವರು. ಅವು ಪರಿಶುದ್ಧವಾದವುಗಳು. ಅವು ನನ್ನವು, ಆದ್ದರಿಂದ ಯಾಜಕರಾದ ನೀವು ಅವುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ನೀವು ಆ ಪರಿಶುದ್ಧ ವಸ್ತುಗಳನ್ನು ಉಪಯೋಗಿಸಿದರೆ, ನನ್ನ ಪರಿಶುದ್ಧ ಹೆಸರಿಗೆ ಅವಮಾನವಾಗುವುದು. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ನಿಮ್ಮ ಸಂತತಿಯವರೆಲ್ಲರಲ್ಲಿ ಯಾವನಾದರೂ ಅಪವಿತ್ರನಾಗಿರುವಾಗ ಅವುಗಳನ್ನು ಮುಟ್ಟಿದರೆ, ಅವನನ್ನು ನನ್ನ ಸನ್ನಿಧಿ ಸೇವೆಯಿಂದ ತೆಗೆದುಹಾಕಬೇಕು! ಇಸ್ರೇಲರು ಅವುಗಳನ್ನು ನನಗೆ ಕೊಟ್ಟಿದ್ದಾರೆ. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ಆರೋನನ ಸಂತತಿಯವರಲ್ಲಿ ಯಾವನಿಗಾದರೂ ಕೆಟ್ಟದಾದ ಚರ್ಮರೋಗವಾಗಲಿ ಸ್ರಾವವಾಗಲಿ ಇದ್ದರೆ, ಅವನು ಶುದ್ಧನಾಗುವವರೆಗೆ ದೇವರಿಗೆ ನೈವೇದ್ಯವಾದ ಪದಾರ್ಥಗಳನ್ನು ತಿನ್ನಬಾರದು. ಅಶುದ್ಧನಾಗುವ ಪ್ರತಿ ಯಾಜಕನಿಗೂ ಈ ನಿಯಮ ಅನ್ವಯಿಸುತ್ತದೆ. ಆ ಯಾಜಕನು ಹೆಣವನ್ನು ಮುಟ್ಟಿದರೆ, ವೀರ್ಯಸ್ಖಲನ ಮಾಡಿಕೊಂಡರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ಯಾವುದೇ ಅಶುದ್ಧವಾದ ಹರಿದಾಡುವ ಜಂತುಗಳನ್ನು ಮುಟ್ಟಿದರೆ, ಅಶುದ್ಧನಾದ ವ್ಯಕ್ತಿಯನ್ನು ಮುಟ್ಟಿದರೆ ಅಶುದ್ಧನಾಗುವನು. ಯಾವುದು ಅವನನ್ನು ಅಶುದ್ಧಪಡಿಸಿತು ಎಂಬುದು ಪ್ರಾಮುಖ್ಯವಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ಒಬ್ಬನು ಅವುಗಳಲ್ಲಿ ಯಾವುದನ್ನು ಮುಟ್ಟಿದರೂ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗುವನು. ಅವನು ನೈವೇದ್ಯ ಪದಾರ್ಥಗಳಲ್ಲಿ ಯಾವುದನ್ನೂ ತಿನ್ನಬಾರದು. ಅವನು ತನ್ನನ್ನು ನೀರಿನಿಂದ ತೊಳೆದುಕೊಂಡರೂ ಪವಿತ್ರ ಪದಾರ್ಥವನ್ನು ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ಸೂರ್ಯನು ಮುಳುಗಿದ ನಂತರವೇ ಅವನು ಶುದ್ಧನಾಗುವನು. ಬಳಿಕ ಅವನು ನೈವೇದ್ಯ ಪದಾರ್ಥವನ್ನು ತಿನ್ನಬಹುದು. ಯಾಕೆಂದರೆ ಆ ಪದಾರ್ಥವು ಅವನ ಪಾಲಾಗುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","“ಯಾಜಕನು ಸತ್ತ ಪ್ರಾಣಿಯನ್ನಾಗಲಿ ಕ್ರೂರ ಪ್ರಾಣಿಗಳಿಂದ ಕೊಲ್ಲಲ್ಪಟ್ಟ ಪ್ರಾಣಿಯನ್ನಾಗಲಿ ತಿನ್ನಬಾರದು. ಅವನು ಅದನ್ನು ತಿಂದರೆ ಅಶುದ್ಧನಾಗುವನು. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ಯಾಜಕರು ನನ್ನ ಅಗತ್ಯತೆಗಳನ್ನು ಎಚ್ಚರಿಕೆಯಿಂದ ಪೂರೈಸಿದರೆ ಅಪರಾಧಕ್ಕೆ ಒಳಗಾಗುವುದಿಲ್ಲ. ಅವರು ಪವಿತ್ರವಾದವುಗಳನ್ನು ಅಪವಿತ್ರಗೊಳಿಸಿದರೆ ಸಾಯುವರು. ಯೆಹೋವನಾದ ನಾನೇ ಅವರನ್ನು ಪರಿಶುದ್ಧರನ್ನಾಗಿ ಮಾಡಿದ್ದೇನೆ ಮತ್ತು ಈ ವಿಶೇಷ ಸೇವೆಗಾಗಿ ಪ್ರತ್ಯೇಕಿಸಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","ಯಾಜಕರ ಕುಟುಂಬದ ಜನರು ಮಾತ್ರವೇ ನೈವೇದ್ಯ ಪದಾರ್ಥಗಳನ್ನು ತಿನ್ನಬಹುದು. ಯಾಜಕನೊಂದಿಗೆ ಇಳಿದುಕೊಂಡವನಾಗಲಿ ಕೂಲಿಯಾಳಾಗಲಿ ನೈವೇದ್ಯ ಪದಾರ್ಥಗಳಲ್ಲಿ ಯಾವುದನ್ನೂ ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ಆದರೆ ಯಾಜಕನು ತನ್ನ ಸ್ವಂತ ಹಣದಿಂದ ಒಬ್ಬನನ್ನು ಗುಲಾಮನನ್ನಾಗಿ ಕೊಂಡುಕೊಂಡರೆ, ಆ ಗುಲಾಮನು ನೈವೇದ್ಯ ಪದಾರ್ಥಗಳಲ್ಲಿ ಕೆಲವನ್ನು ತಿನ್ನಬಹುದು. ಯಾಜಕನ ಮನೆಯಲ್ಲಿ ಹುಟ್ಟಿದ ಗುಲಾಮರು ಸಹ ಯಾಜಕನ ಆಹಾರದಲ್ಲಿ ಕೆಲವನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ಯಾಜಕನ ಮಗಳು ಯಾಜಕನಲ್ಲದವನನ್ನು ಮದುವೆಯಾದರೆ ಅವಳು ನೈವೇದ್ಯ ಸಮರ್ಪಣೆಗಳಲ್ಲಿ ಯಾವುದನ್ನೂ ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ಯಾಜಕನ ಮಗಳು ವಿಧವೆಯಾಗಿದ್ದರೆ ಅಥವಾ ಗಂಡ ಬಿಟ್ಟವಳಾಗಿದ್ದರೆ ಅಲ್ಲದೆ ಅವಳಿಗೆ ಆಧಾರ ನೀಡುವಂಥ ಮಕ್ಕಳೂ ಇಲ್ಲದಿದ್ದರೆ ಮತ್ತು ಅವಳು ತನ್ನ ತಂದೆಯ ಮನೆಗೆ ಹಿಂತಿರುಗಿ ಹೋದರೆ, ಆಗ ಅವಳು ತಂದೆಯ ಆಹಾರದಲ್ಲಿ ಸ್ವಲ್ಪ ತಿನ್ನಬಹುದು. ಆದರೆ ಯಾಜಕನ ಕುಟುಂಬದವರು ಮಾತ್ರವೇ ಈ ಆಹಾರವನ್ನು ತಿನ್ನಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ಒಬ್ಬನು ತಿಳಿಯದೆ ನೈವೇದ್ಯ ಪದಾರ್ಥವನ್ನು ತಿಂದರೆ ಅವನು ಆ ಪದಾರ್ಥವನ್ನೂ ಪದಾರ್ಥದ ಬೆಲೆಯ ಐದನೆಯ ಒಂದಂಶವನ್ನೂ ಅದಕ್ಕೆ ಸೇರಿಸಿ ಯಾಜಕನಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“ಇಸ್ರೇಲರು ಯೆಹೋವನಿಗೆ ಕೊಡುವ ಕಾಣಿಕೆಗಳು ಪರಿಶುದ್ಧವಾಗಿವೆ. ಆದ್ದರಿಂದ ಯಾಜಕರು ಆ ಪರಿಶುದ್ಧ ವಸ್ತುಗಳನ್ನು ಅಶುದ್ಧಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ಯಾಜಕರು ಅವುಗಳನ್ನು ಪರಿಶುದ್ಧವಾದವುಗಳೆಂದು ಪರಿಗಣಿಸದೆ ನೈವೇದ್ಯ ಪದಾರ್ಥಗಳನ್ನು ತಿಂದರೆ ಪಾಪಕ್ಕೆ ಒಳಗಾಗುವರು. ಯೆಹೋವನಾದ ನಾನೇ ಅವುಗಳನ್ನು ಪವಿತ್ರಗೊಳಿಸಿದ್ದೇನೆ.” ");
INSERT INTO kan2010_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೀಗೆಂದನು: ");
INSERT INTO kan2010_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“ಆರೋನನಿಗೆ, ಅವನ ಪುತ್ರರಿಗೆ ಮತ್ತು ಇಸ್ರೇಲರೆಲ್ಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ಒಂದುವೇಳೆ ಇಸ್ರೇಲನಾಗಲಿ ಅಥವಾ ಪರದೇಶಸ್ಥನಾಗಲಿ ಹರಕೆಯಾಗಿ ಅಥವಾ ಕಾಣಿಕೆಯಾಗಿ ಸರ್ವಾಂಗಹೋಮ ಮಾಡುವಾಗ, ");
INSERT INTO kan2010_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","20","ಅದು ಸ್ವೀಕೃತವಾಗುವಂತೆ ಪೂರ್ಣಾಂಗವಾದ ಹೋರಿಯನ್ನಾಗಲಿ ಟಗರನ್ನಾಗಲಿ ಹೋತವನ್ನಾಗಲಿ ಅರ್ಪಿಸಬೇಕು. ಅಂಗದೋಷವುಳ್ಳ ಯಾವುದನ್ನೂ ನೀವು ಸಮರ್ಪಿಸಬಾರದು. ಅಂಗದೋಷವುಳ್ಳವುಗಳನ್ನು ನಾನು ಸ್ವೀಕರಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“ಒಬ್ಬನು ಸಮಾಧಾನಯಜ್ಞವನ್ನು ಹರಕೆಯಾಗಿ ಅಥವಾ ಕಾಣಿಕೆಯಾಗಿ ಅರ್ಪಿಸುವಾಗ ಹೋರಿಯನ್ನಾಗಲಿ ಟಗರನ್ನಾಗಲಿ ಅರ್ಪಿಸಬೇಕು; ಅದು ಅಂಗದೋಷವಿಲ್ಲದ್ದಾಗಿರಬೇಕು; ಆರೋಗ್ಯವುಳ್ಳದ್ದಾಗಿರಬೇಕು. ಆಗ ಅದು ಸ್ವೀಕೃತವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ಕುರುಡಾದದ್ದನ್ನಾಗಲಿ ಮೂಳೆ ಮುರಿದುಕೊಂಡದ್ದನ್ನಾಗಲಿ ಕುಂಟಾದದ್ದನ್ನಾಗಲಿ ಸ್ರಾವವುಳ್ಳದ್ದನ್ನಾಗಲಿ ಕೆಟ್ಟದಾದ ಚರ್ಮರೋಗವುಳ್ಳದ್ದನ್ನಾಗಲಿ ನೀವು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಬಾರದು. ಯೆಹೋವನ ಯಜ್ಞವೇದಿಕೆಯ ಬೆಂಕಿಯಲ್ಲಿ ಅನಾರೋಗ್ಯವಾದ ಪ್ರಾಣಿಗಳನ್ನು ಅರ್ಪಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“ಕಾಲು ಉದ್ದವಾಗಿರುವ ಅಥವಾ ಮೊಂಡಾಗಿರುವ ಹೋರಿಯನ್ನಾಗಲಿ ಕುರಿಯನ್ನಾಗಲಿ ಒಬ್ಬನು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಕೊಡಲು ಬಯಸಿದರೆ, ಆಗ ಅದು ಸ್ವೀಕೃತವಾಗುವುದು. ಆದರೆ, ಅವನು ಮಾಡಿದ ವಿಶೇಷ ಹರಕೆಯಾಗಿ ಅದು ಸ್ವೀಕೃತವಾಗುವುದಿಲ್ಲ. ಅದು ಸ್ವಇಚ್ಛೆಯಿಂದ ಅರ್ಪಿಸಿದ ಕಾಣಿಕೆಯಾಗಿ ಸ್ವೀಕರಿಸಲ್ಪಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","“ಗಾಯಗೊಂಡ, ಜಜ್ಜಿದ ಅಥವಾ ಒಡೆದ ಬೀಜವುಳ್ಳ ಪಶುವನ್ನು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಬಾರದು. ಇದನ್ನು ನಿಮ್ಮ ಸ್ವಂತ ನಾಡಿನಲ್ಲಿ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“ಪರದೇಶಸ್ಥರಿಂದ ಯೆಹೋವನಿಗೆ ಬಲಿಪಶುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬಾರದು. ಯಾಕೆಂದರೆ ಆ ಪಶುಗಳಿಗೆ ಒಂದುವೇಳೆ ಪೆಟ್ಟಾಗಿರಬಹುದು. ಅವುಗಳಲ್ಲಿ ಏನಾದರೂ ದೋಷವಿರಬಹುದು. ಅವುಗಳು ಸಮರ್ಪಕವಾಗುವುದಿಲ್ಲ.” ");
INSERT INTO kan2010_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ಕರುವಾಗಲಿ ಕುರಿಮರಿಯಾಗಲಿ ಅಥವಾ ಆಡಾಗಲಿ ಹುಟ್ಟಿದ ಬಳಿಕ ತನ್ನ ತಾಯಿಯೊಂದಿಗೆ ಏಳು ದಿನಗಳವರೆಗೆ ಇರಲೇಬೇಕು. ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಮತ್ತು ಅದರ ನಂತರ, ಆ ಪಶುವು ಸರ್ವಾಂಗಹೋಮಕ್ಕೆ ಯೋಗ್ಯವಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ಆದರೆ ನೀವು ಆ ಪಶುವನ್ನೂ ಅದರ ತಾಯಿಯನ್ನೂ ಒಂದೇ ದಿನದಲ್ಲಿ ವಧಿಸಬಾರದು. ಇದೇ ನಿಯಮ ದನಗಳಿಗೂ ಕುರಿಗಳಿಗೂ ಅನ್ವಯಿಸುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“ಯೆಹೋವನಿಗೆ ವಿಶೇಷ ಕೃತಜ್ಞತಾ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸಲು ಬಯಸಿದರೆ, ಆ ಕಾಣಿಕೆಯನ್ನು ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚಿಕೆಯಾದ ರೀತಿಯಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ನೀವು ಇಡೀ ಪಶುವನ್ನು ಅದೇ ದಿನದಲ್ಲಿ ತಿನ್ನಬೇಕು. ಮರುದಿನ ಮುಂಜಾನೆಯವರೆಗೆ ಮಾಂಸದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನೂ ಉಳಿಸಬಾರದು. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“ನನ್ನ ಆಜ್ಞೆಗಳನ್ನು ಜ್ಞಾಪಕ ಮಾಡಿಕೊಂಡು ಅವುಗಳಿಗೆ ವಿಧೇಯರಾಗಿರಿ. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ನನ್ನ ಪವಿತ್ರ ನಾಮವನ್ನು ಗೌರವಿಸಬೇಕು. ನಾನು ಇಸ್ರೇಲರಿಗೆ ಬಹಳ ವಿಶೇಷವಾದವನಾಗಿರಬೇಕು. ಯೆಹೋವನಾದ ನಾನು ನಿಮ್ಮನ್ನು ನನ್ನ ವಿಶೇಷ ಜನರನ್ನಾಗಿ ಮಾಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ನಿಮ್ಮ ದೇವರಾಗಿರುವುದಕ್ಕಾಗಿ ನಾನು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದೆನು. ನಾನೇ ಯೆಹೋವನು!” ");
INSERT INTO kan2010_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು: ಯೆಹೋವನಿಂದ ಆರಿಸಲ್ಪಟ್ಟ ಹಬ್ಬದದಿನಗಳಲ್ಲಿ ಪವಿತ್ರಸಭೆ ಕೂಡಬೇಕೆಂಬುದಾಗಿ ಪ್ರಕಟಿಸಬೇಕು. ಇವು ನನ್ನ ವಿಶೇಷ ಹಬ್ಬದ ದಿನಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ಆರು ದಿನಗಳಲ್ಲಿ ನೀವು ಕೆಲಸಮಾಡಿರಿ. ಆದರೆ ಏಳನೆಯ ದಿನವು ವಿಶೇಷವಾದ ವಿಶ್ರಾಂತಿ ದಿನವಾದ ಸಬ್ಬತ್ತಾಗಿದೆ. ಆ ದಿನದಲ್ಲಿ ಪವಿತ್ರಸಭೆ ಕೂಡಬೇಕು. ನೀವು ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ನಿಮ್ಮ ಎಲ್ಲಾ ಮನೆಗಳಲ್ಲಿ ಅದು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾದ ಸಬ್ಬತ್ತಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ಇವುಗಳು ಯೆಹೋವನಿಂದ ಆರಿಸಲ್ಪಟ್ಟ ಹಬ್ಬದ ದಿನಗಳು. ಆ ಕಾಲಗಳಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆಕೂಟಗಳು ನಡೆಸಲ್ಪಡಬೇಕು. ನೇಮಕವಾದ ದಿನಗಳಲ್ಲಿ ಇವುಗಳನ್ನು ಪ್ರಕಟಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ಯೆಹೋವನ ಪಸ್ಕಹಬ್ಬವು ಮೊದಲನೆ ತಿಂಗಳ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ಸಾಯಂಕಾಲ ಅಂದರೆ ಸೂರ್ಯಸ್ತಮಾನವಾದ ಸಮಯದಲ್ಲಿ ನಡೆಯುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“ಅದೇ ತಿಂಗಳ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವನ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಹಬ್ಬವಿರುತ್ತದೆ. ನೀವು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನು ಏಳು ದಿನಗಳವರೆಗೆ ತಿನ್ನುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ಈ ಹಬ್ಬದ ದಿನದ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ನೀವು ವಿಶೇಷ ಸಭೆಯಾಗಿ ಸೇರಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ಏಳು ದಿನಗಳವರೆಗೆ ನೀವು ಯೆಹೋವನಿಗೆ ಹೋಮವನ್ನು ಅರ್ಪಿಸಬೇಕು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಇನ್ನೊಂದು ಬಾರಿ ವಿಶೇಷ ಸಭೆಯಾಗಿ ಸೇರಬೇಕು. ನೀವು ಆ ದಿನದಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು.” ");
INSERT INTO kan2010_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ನಾನು ನಿಮಗೆ ಕೊಡುವ ದೇಶದಲ್ಲಿ ನೀವು ನೆಲೆಸಿದ ನಂತರ ಅಲ್ಲಿ ಬೆಳೆಯನ್ನು ಕೊಯ್ಯುವಿರಿ. ಆ ಸಮಯದಲ್ಲಿ ನಿಮ್ಮ ಬೆಳೆಯ ಪ್ರಥಮ ಸಿವುಡನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ಯಾಜಕನು ಸಿವುಡನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿವಾಳಿಸುವನು. ಆಗ ನೀವು ಸ್ವೀಕೃತರಾಗಲು ಯೋಗ್ಯರಾಗುವಿರಿ. ಸಬ್ಬತ್ತಾದ ನಂತರ ಯಾಜಕನು ಸಿವುಡನ್ನು ಯೆಹೋವನಿಗೆ ನಿವಾಳಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","“ನೀವು ಸಿವುಡನ್ನು ನಿವಾಳಿಸುವ ದಿನದಲ್ಲಿ ಒಂದು ವರ್ಷದ ಗಂಡು ಕುರಿಮರಿಯನ್ನು ಅರ್ಪಿಸಬೇಕು. ಆ ಕುರಿಮರಿಯಲ್ಲಿ ಯಾವ ದೋಷವೂ ಇರಬಾರದು. ಅದು ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಅರ್ಪಿತವಾಗುವುದಕ್ಕಾಗಿ ನೇಮಿತವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ನೀವು ಎಣ್ಣೆ ಬೆರೆಸಿದ ಹದಿನಾರು ಬಟ್ಟಲು ಶ್ರೇಷ್ಠ ಗೋಧಿಹಿಟ್ಟನ್ನು ಧಾನ್ಯಸಮರ್ಪಣೆಗಾಗಿ ಅರ್ಪಿಸಬೇಕು. ನೀವು ಕಾಲುಭಾಗ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಅರ್ಪಿಸಬೇಕು. ಆ ಯಜ್ಞದ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚಿಕೆಯಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ನೀವು ಯಾವ ಹೊಸ ಧಾನ್ಯವನ್ನಾಗಲಿ ಹಣ್ಣನ್ನಾಗಲಿ ಹೊಸ ಧಾನ್ಯದಿಂದ ಮಾಡಿದ ರೊಟ್ಟಿಯನ್ನಾಗಲಿ ದೇವರಿಗೆ ಅರ್ಪಿಸುವ ಮೊದಲು ತಿನ್ನಬಾರದು. ಈ ನಿಯಮವು ನಿಮ್ಮ ಎಲ್ಲಾ ಸಂತತಿಯವರಿಗೂ ನಿಮ್ಮ ಎಲ್ಲಾ ನಿವಾಸ ಸ್ಥಾನಗಳಲ್ಲಿಯೂ ಶಾಶ್ವತವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ಆ ಭಾನುವಾರ ಬೆಳಿಗ್ಗೆ ಮೊದಲುಗೊಂಡು ಅಂದರೆ ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸುವುದಕ್ಕಾಗಿ ಸಿವುಡನ್ನು ತಂದ ದಿನದಿಂದ ಹಿಡಿದು ಏಳು ವಾರಗಳನ್ನು ಲೆಕ್ಕಿಸಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ಏಳು ವಾರಗಳು ಮುಗಿದ ಭಾನುವಾರ ಅಂದರೆ ಐವತ್ತು ದಿನಗಳ ನಂತರ ನೀವು ಯೆಹೋವನಿಗೆ ಹೊಸಬೆಳೆಯನ್ನು ಸಮರ್ಪಿಸುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ಆ ದಿನದಲ್ಲಿ ನಿಮ್ಮ ಮನೆಗಳಿಂದ ಎರಡು ರೊಟ್ಟಿಗಳನ್ನು ತನ್ನಿರಿ. ಆ ರೊಟ್ಟಿಗಳು ನೈವೇದ್ಯವಾಗಿ ನಿವಾಳಿಸಲ್ಪಡುವುದಕ್ಕಾಗಿದೆಯಷ್ಟೆ. ಹುಳಿಯನ್ನು ಉಪಯೋಗಿಸಿ ಹದಿನಾರು ಬಟ್ಟಲು ಗೋಧಿಹಿಟ್ಟಿನಿಂದ ಎರಡು ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಿರಿ. ಅದು ನಿಮ್ಮ ಪ್ರಥಮ ಬೆಳೆಯಿಂದ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವ ಕಾಣಿಕೆಯಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","“ಜನರು ಸಮರ್ಪಿಸುವ ರೊಟ್ಟಿ, ಧಾನ್ಯ ಮತ್ತು ದ್ರಾಕ್ಷಾರಸಗಳೊಂದಿಗೆ ಒಂದು ಹೋರಿ, ಎರಡು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳನ್ನು ಅರ್ಪಿಸಲಾಗುವುದು. ಆ ಪಶುಗಳಲ್ಲಿ ಯಾವ ದೋಷವು ಇರಬಾರದು. ಅವುಗಳು ಯೆಹೋವನಿಗೆ ಅಗ್ನಿಯ ಮೂಲಕ ಅರ್ಪಿತವಾಗಲಿರುವ ಸಮರ್ಪಣೆಗಳಾಗಿವೆ. ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚಿಕೆಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ನೀವು ಪಾಪಪರಿಹಾರಕ ಸಮರ್ಪಣೆಯಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಸಮಾಧಾನಯಜ್ಞವಾಗಿ ಒಂದು ವರ್ಷದ ಎರಡು ಮರಿಟಗರುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“ಯಾಜಕನು ಅವುಗಳನ್ನು ಪ್ರಥಮ ಬೆಳೆಯಿಂದ ಮಾಡಿದ ರೊಟ್ಟಿಯೊಂದಿಗೆ ನೈವೇದ್ಯವಾಗಿ ಎರಡು ಕುರಿಮರಿಗಳೊಂದಿಗೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿವಾಳಿಸುವನು. ಅವು ಯೆಹೋವನಿಗೆ ಪವಿತ್ರವಾಗಿರುತ್ತವೆ. ಅವು ಯಾಜಕರಿಗೆ ಸಲ್ಲುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ಅದೇ ದಿನದಲ್ಲಿ ನೀವು ಪವಿತ್ರಸಭೆಯಾಗಿ ಕೂಡಬೇಕು. ನೀವು ಯಾವ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ನಿಮ್ಮ ಎಲ್ಲಾ ಮನೆಗಳಲ್ಲಿ ಈ ನಿಯಮವು ಶಾಶ್ವತವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ಅಲ್ಲದೆ ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಪೈರುಗಳನ್ನು ಕೊಯ್ಯುವಾಗ ಹೊಲದ ಮೂಲೆಗಳವರೆಗೆ ಇರುವುದನ್ನೆಲ್ಲಾ ಕೊಯ್ಯಬೇಡಿರಿ. ನೆಲದ ಮೇಲೆ ಬೀಳುವ ಧಾನ್ಯಗಳನ್ನು ಹಕ್ಕಲಾಯಬಾರದು. ಬಡವರಿಗಾಗಿಯೂ ನಿಮ್ಮ ದೇಶದ ಮೂಲಕ ಪ್ರಯಣಮಾಡುವ ಪರದೇಶಸ್ಥರಿಗಾಗಿಯೂ ಅವುಗಳನ್ನು ಬಿಡಿರಿ. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು!” ");
INSERT INTO kan2010_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ಯೆಹೋವನು ತಿರುಗಿ ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ಏಳನೆಯ ತಿಂಗಳಿನ ಮೊದಲಿನ ದಿನವು ನಿಮಗೆ ವಿಶ್ರಾಂತಿಯ ವಿಶೇಷ ದಿನವಾಗಿರಬೇಕು. ಆಗ ನೀವು ಪವಿತ್ರಸಭೆಯಾಗಿ ಸೇರಬೇಕು. ಜ್ಞಾಪಕಮಾಡುವ ವಿಶೇಷ ಸಮಯಕ್ಕಾಗಿ ನೀವು ತುತ್ತೂರಿಯನ್ನು ಊದಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ನೀವು ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ನೀವು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಣೆಯನ್ನು ಸಲ್ಲಿಸುವಿರಿ.” ");
INSERT INTO kan2010_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನವು ದೋಷಪರಿಹಾರಕ ದಿನವಾಗಿರುವುದು. ಆಗ ಪವಿತ್ರ ಸಭೆಯಾಗಿ ಸೇರಬೇಕು. ನೀವು ಆಹಾರವನ್ನು ತಿನ್ನಬಾರದು. ನೀವು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯನ್ನು ಸಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ನೀವು ಆ ದಿನದಲ್ಲಿ ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ಯಾಕೆಂದರೆ ಅದು ದೋಷಪರಿಹಾರಕ ದಿನವಾಗಿರುತ್ತದೆ. ಆ ದಿನದಲ್ಲಿ ಯಾಜಕರು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಹೋಗಿ ಆಚಾರವಿಧಿಗಳ ಪ್ರಕಾರ ನಿಮಗಾಗಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","“ಈ ದಿನದಲ್ಲಿ ಯಾವನಾದರೂ ಉಪವಾಸ ಮಾಡದಿದ್ದರೆ ಅವನನ್ನು ಅವನ ಕುಲದಿಂದ ತೆಗೆದುಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ಈ ದಿನದಲ್ಲಿ ಕೆಲಸಮಾಡುವವನನ್ನು ಇಸ್ರೇಲರೊಂದಿಗೆ ಇರದಂತೆ ನಾಶಮಾಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ನೀವು ಅಂದು ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ನೀವು ಎಲ್ಲೇ ವಾಸವಾಗಿದ್ದರೂ ಈ ಕಟ್ಟಳೆ ನಿಮಗೆ ಶಾಶ್ವತವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ಅದು ನಿಮಗಾಗಿ ವಿಶ್ರಾಂತಿಯ ವಿಶೇಷ ದಿನವಾಗಿರುವುದು. ನೀವು ಆಹಾರವನ್ನು ತಿನ್ನಬಾರದು. ತಿಂಗಳಿನ ಒಂಭತ್ತನೆಯ ದಿನದ ನಂತರ ಸಾಯಂಕಾಲದಲ್ಲಿ ಈ ವಿಶ್ರಾಂತಿಯ ವಿಶೇಷ ದಿನವನ್ನು ಪ್ರಾರಂಭಿಸುವಿರಿ. ಈ ವಿಶ್ರಾಂತಿಯ ವಿಶೇಷ ದಿನವು ಆ ಸಾಯಂಕಾಲದಿಂದ ಹಿಡಿದು ಮರುದಿನ ಸಾಯಂಕಾಲದವರೆಗೆ ಮುಂದುವರಿಯುವುದು.” ");
INSERT INTO kan2010_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನವು ಪರ್ಣಶಾಲೆಗಳ ಹಬ್ಬವಾಗಿರುತ್ತದೆ. ಯೆಹೋವನ ಈ ಹಬ್ಬದ ಕಾಲವು ಏಳು ದಿನಗಳವರೆಗೆ ಮುಂದುವರಿಯುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಪವಿತ್ರಸಭೆಯಾಗಿ ಸೇರಬೇಕು. ಅಂದು ನೀವು ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ನೀವು ಏಳು ದಿನಗಳವರೆಗೆ ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸಬೇಕು. ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಇನ್ನೊಂದು ಬಾರಿ ಸಭೆಯಾಗಿ ಸೇರಬೇಕು. ನೀವು ಅಗ್ನಿಯ ಮೂಲಕ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸಬೇಕು. ಇದು ಪವಿತ್ರಸಭೆಯಾಗಿರುವುದು. ಅಂದು ನೀವು ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ಯೆಹೋವನಿಗೆ ವಿಶೇಷ ಹಬ್ಬದ ದಿನಗಳು ಇವುಗಳೇ. ಈ ವಿಶೇಷ ದಿನಗಳಲ್ಲಿ ನೀವು ಪವಿತ್ರಸಭೆಯಾಗಿ ಸೇರಬೇಕು. ನೀವು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಣೆಯಾಗುವ ಸರ್ವಾಂಗಹೋಮ, ಧಾನ್ಯಸಮರ್ಪಣೆ, ಯಜ್ಞಗಳು ಮತ್ತು ಪಾನದ್ರವ್ಯಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ನೀವು ಆ ಕಾಣಿಕೆಗಳನ್ನು ಸರಿಯಾದ ಸಮಯದಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ಯೆಹೋವನನ್ನು ಜ್ಞಾಪಕಮಾಡುವ ಸಬ್ಬತ್ ದಿನಗಳ ಜೊತೆಗೆ ನೀವು ಆ ಹಬ್ಬದ ದಿನಗಳನ್ನು ಆಚರಿಸಬೇಕು. ನೀವು ಆ ಕಾಣಿಕೆಗಳನ್ನು ನಿಮ್ಮ ಇತರ ಕಾಣಿಕೆಗಳ ಜೊತೆಗೆ ಅರ್ಪಿಸಬೇಕು. ನೀವು ಮಾಡಿದ ಹರಕೆಗಳನ್ನು ನೆರವೇರಿಸುವುದಕ್ಕಾಗಿ ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸುವ ಕಾಣಿಕೆಗಳ ಜೊತೆಗೆ ಅವುಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ನೀವು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸುವ ಯಾವುದೇ ವಿಶೇಷ ಸಮರ್ಪಣೆಗಳೊಂದಿಗೆ ಅವುಗಳನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ನೀವು ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಪೈರುಗಳನ್ನು ಸಂಗ್ರಹಿಸಿದ ನಂತರ, ಏಳು ದಿನಗಳವರೆಗೆ ನೀವು ಯೆಹೋವನ ಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ನೀವು ಮೊದಲನೆಯ ಮತ್ತು ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ವಿಶ್ರಮಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ಪ್ರಥಮ ದಿನದಲ್ಲಿ ನೀವು ಮರಗಳಿಂದ ಉತ್ತಮ ಹಣ್ಣನ್ನೂ ಖರ್ಜೂರಮರದ ಗರಿಗಳನ್ನೂ ಎಲೆತುಂಬಿದ ಕೊಂಬೆಗಳನ್ನೂ ವಿಲೋಸಸ್ಯಗಳನ್ನೂ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಈ ಹಬ್ಬದ ದಿನವನ್ನು ಏಳು ದಿನಗಳವರೆಗೆ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ನೀವು ಪ್ರತಿ ವರ್ಷ ಏಳು ದಿನಗಳವರೆಗೆ ಈ ಹಬ್ಬದ ದಿನವನ್ನು ಆಚರಿಸಬೇಕು. ಈ ನಿಯಮ ಶಾಶ್ವತವಾಗಿದೆ. ಏಳನೆಯ ತಿಂಗಳಲ್ಲಿ ಈ ಹಬ್ಬದ ದಿನವನ್ನು ನೀವು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ನೀವು ಏಳು ದಿನಗಳವರೆಗೆ ಪರ್ಣಶಾಲೆಗಳಲ್ಲಿ ವಾಸಿಸಬೇಕು. ಇಸ್ರೇಲರಲ್ಲಿ ಹುಟ್ಟಿದವರೆಲ್ಲರೂ ಆ ಪರ್ಣಶಾಲೆಗಳಲ್ಲಿ ವಾಸಿಸುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ನಾನು ಇಸ್ರೇಲರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಕರೆದು ತಂದಾಗ, ಈ ಪರ್ಣಶಾಲೆಗಳಲ್ಲಿ ವಾಸಿಸುವಂತೆ ಮಾಡಿದವನು ನಾನೇ ಎಂದು ನಿಮ್ಮ ಸಂತತಿಯವರು ತಿಳಿದುಕೊಳ್ಳುವರು. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು!” ");
INSERT INTO kan2010_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ಆದ್ದರಿಂದ ಮೋಶೆಯು ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸುವುದಕ್ಕಾಗಿ ಸೇರಿಬರುವ ವಿಶೇಷ ಸಭೆಗಳ ಕುರಿತು ಜನರಿಗೆ ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ಎಣ್ಣೆ ಮರದ ಕಾಯಿಗಳನ್ನು ಕುಟ್ಟಿ ತೆಗೆದ ಶುದ್ಧವಾದ ಎಣ್ಣೆಯನ್ನು ಇಸ್ರೇಲರು ನಿನ್ನ ಬಳಿಗೆ ತರಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸು. ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿರುವ ದೀಪಗಳನ್ನು ಉರಿಸಲು ಆ ಎಣ್ಣೆ ಬೇಕಾಗಿರುತ್ತದೆ. ಆ ದೀಪಗಳು ಆರಿಹೋಗದೆ ಉರಿಯುತ್ತಲೇ ಇರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸಾಯಂಕಾಲದಿಂದ ಉದಯದವರೆಗೆ ದೀಪಗಳು ಉರಿಯುತ್ತಿರುವಂತೆ ಆರೋನನು ಅವುಗಳನ್ನು ಸರಿಪಡಿಸುವನು. ಇದು ತೆರೆಯ ಹೊರಗೆ ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯ ಮುಂದೆ ಇರುವುದು. ಈ ನಿಯಮ ಶಾಶ್ವತವಾದದ್ದು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ಶುದ್ಧಚಿನ್ನದಿಂದ ಮಾಡಿದ ದೀಪಸ್ತಂಭದಲ್ಲಿ ದೀಪಗಳು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಯಾವಾಗಲೂ ಉರಿಯುತ್ತಿರುವಂತೆ ಆರೋನನು ನೋಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“ಶ್ರೇಷ್ಠ ಗೋಧಿಹಿಟ್ಟನ್ನು ತೆಗೆದುಕೊಂಡು ಹನ್ನೆರಡು ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಬೇಕು. ಪ್ರತಿ ರೊಟ್ಟಿಯನ್ನು ಮಾಡಲು ಆರು ಸೇರು ಹಿಟ್ಟನ್ನು ಉಪಯೋಗಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ವುಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿರುವ ಚಿನ್ನದ ಮೇಜಿನ ಮೇಲೆ ಎರಡು ಸಾಲಾಗಿ ಇಡಬೇಕು. ಒಂದೊಂದು ಸಾಲಿನಲ್ಲಿ ಆರಾರು ರೊಟ್ಟಿಗಳಿರುವವು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ಪ್ರತಿ ಸಾಲಿನಲ್ಲಿ ಶುದ್ಧವಾದ ಧೂಪದ್ರವ್ಯವನ್ನಿಡಬೇಕು. ಇದು ಅಗ್ನಿಯ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ಅರ್ಪಿತವಾದ ಸಮರ್ಪಣೆಯನ್ನು ಯೆಹೋವನ ಜ್ಞಾಪಕಕ್ಕೆ ತರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ರತಿ ಸಬ್ಬತ್‌ದಿನದಲ್ಲಿ ಆರೋನನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ರೊಟ್ಟಿಯನ್ನು ಕ್ರಮವಾಗಿ ಯಾವಾಗಲೂ ಇಡಬೇಕು. ಇಸ್ರೇಲರೊಂದಿಗೆ ಮಾಡಲ್ಪಟ್ಟ ಒಡಂಬಡಿಕೆಯು ಶಾಶ್ವತವಾದದ್ದು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ಆ ರೊಟ್ಟಿಯು ಆರೋನನಿಗೆ ಮತ್ತು ಅವನ ಪುತ್ರರಿಗೆ ಸಲ್ಲತಕ್ಕದ್ದು. ಅವರು ರೊಟ್ಟಿಯನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ತಿನ್ನುವರು. ಯಾಕೆಂದರೆ ಅದು ಮಹಾ ಪವಿತ್ರವಾದದ್ದು. ಅದು ಅಗ್ನಿಯ ಮೂಲಕ ಅರ್ಪಿಸಿದ ಯಜ್ಞಗಳಲ್ಲಿ ಒಂದಾಗಿದೆ. ಆ ರೊಟ್ಟಿಯು ಶಾಶ್ವತವಾಗಿ ಆರೋನನಿಗೆ ಸಲ್ಲತಕ್ಕದ್ದು.” ");
INSERT INTO kan2010_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ಇಸ್ರೇಲಿನ ಒಬ್ಬ ಸ್ತ್ರೀಗೆ ಒಬ್ಬ ಮಗನಿದ್ದನು. ಅವನ ತಂದೆ ಈಜಿಪ್ಟಿನವನು. ಪಾಳೆಯದಲ್ಲಿದ್ದ ಇಸ್ರೇಲರ ಮಧ್ಯದಿಂದ ಅವನು ಹೊರಬಂದನು. ಅವನು ಒಬ್ಬ ಇಸ್ರೇಲನೊಡನೆ ಜಗಳವಾಡತೊಡಗಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ಅವನು ದೂಷಿಸಲು ಪ್ರಾರಂಭಿಸಿ ಯೆಹೋವನ ನಾಮದ ಬಗ್ಗೆ ಕೆಟ್ಟಮಾತುಗಳನ್ನು ಹೇಳತೊಡಗಿದನು. ಆದ್ದರಿಂದ ಜನರು ಅವನನ್ನು ಮೋಶೆಯ ಬಳಿಗೆ ಹಿಡಿದು ತಂದರು. (ಆ ಮನುಷ್ಯನ ತಾಯಿಯ ಹೆಸರು ಶೆಲೋಮೀತ್. ಅವಳು ದಾನ್ ಕುಲದವನಾದ ದಿಬ್ರೀಯನ ಮಗಳು.) ");
INSERT INTO kan2010_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ಜನರು ಅವನನ್ನು ಸೆರೆಹಿಡಿದು, ಯೆಹೋವನ ಸ್ಪಷ್ಟವಾದ ಆಜ್ಞೆಗಾಗಿ ಕಾದುಕೊಂಡಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ದೂಷಣೆ ಮಾಡಿದ ಮನುಷ್ಯನನ್ನು ಪಾಳೆಯದ ಹೊರಗಿರುವ ಸ್ಥಳಕ್ಕೆ ತನ್ನಿರಿ. ಬಳಿಕ ಅವನ ದೂಷಣೆ ಮಾತುಗಳನ್ನು ಕೇಳಿದ ಎಲ್ಲಾ ಜನರನ್ನು ಒಟ್ಟಾಗಿ ಕರೆಸಿರಿ. ಆ ಜನರು ತಮ್ಮ ಕೈಗಳನ್ನು ಅವನ ತಲೆಯ ಮೇಲೆ ಇಡುವರು. ಆ ಬಳಿಕ ಎಲ್ಲಾ ಜನರು ಅವನಿಗೆ ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ನೀನು ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು: ದೇವದೂಷಣೆ ಮಾಡಿದವನಿಗೆ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ಯಾವನಾದರೂ ಯೆಹೋವನ ನಾಮದ ವಿರುದ್ಧ ಮಾತಾಡಿದರೆ, ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ಜನರೆಲ್ಲರೂ ಅವನಿಗೆ ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು. ಯೆಹೋವನ ನಾಮವನ್ನು ನಿಂದಿಸುವ ಪರದೇಶಸ್ಥರಿಗೂ ಅದೇ ರೀತಿಯ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ಯೆಹೋವನ ನಾಮವನ್ನು ನಿಂದಿಸುವವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ಒಬ್ಬನು ಇನ್ನೊಬ್ಬನನ್ನು ಕೊಂದರೆ, ಕೊಂದವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ಇನ್ನೊಬ್ಬನಿಗೆ ಸೇರಿದ ಪಶುವನ್ನು ಕೊಲ್ಲುವವನು ಅದಕ್ಕೆ ಪ್ರತಿಯಾಗಿ ಇನ್ನೊಂದು ಪಶುವನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“ಒಬ್ಬನು ತನ್ನ ನೆರೆಯವನನ್ನು ಅಂಗವಿಕಲನನ್ನಾಗಿ ಮಾಡಿದರೆ, ಅವನಿಗೂ ಅದೇ ರೀತಿ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ಮುರಿದ ಮೂಳೆಗೆ ಬದಲಾಗಿ ಅವನ ಮೂಳೆಯನ್ನು ಮುರಿಯಬೇಕು. ಕಣ್ಣಿಗೆ ಪ್ರತಿಯಾಗಿ ಕಣ್ಣನ್ನೂ ಹಲ್ಲಿಗೆ ಪ್ರತಿಯಾಗಿ ಹಲ್ಲನ್ನೂ ತೆಗೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ಒಬ್ಬನು ಪಶುವೊಂದನ್ನು ಕೊಂದರೆ, ಅವನು ಅದಕ್ಕೆ ಬದಲಾಗಿ ಈಡು ಕೊಡಬೇಕು. ಆದರೆ ಒಬ್ಬನು ಇನ್ನೊಬ್ಬನನ್ನು ಕೊಂದರೆ, ಕೊಂದವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“ಈ ಕಟ್ಟಳೆ ನ್ಯಾಯವಾದದ್ದು. ಅದು ನಿಮ್ಮ ಸ್ವದೇಶದವರಿಗೆ ಅನ್ವಯಿಸುವಂತೆ ಪರದೇಶಸ್ಥರಿಗೂ ಅನ್ವಯಿಸುವುದು. ಯಾಕೆಂದರೆ ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು!” ");
INSERT INTO kan2010_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ಬಳಿಕ ಮೋಶೆಯು ಇಸ್ರೇಲರೊಂದಿಗೆ ಮಾತಾಡಿದನು. ಆಗ ಅವರು ದೂಷಣೆ ಮಾಡಿದ ಮನುಷ್ಯನನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಅವನಿಗೆ ಕಲ್ಲೆಸೆದು ಕೊಂದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವರು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮಾತಾಡಿದನು. ಯೆಹೋವನು ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ನಾನು ನಿಮಗೆ ಕೊಡುತ್ತಿರುವ ದೇಶಕ್ಕೆ ನೀವು ಪ್ರವೇಶಿಸುವಿರಿ. ಆ ಸಮಯದಲ್ಲಿ ನೀವು ಭೂಮಿಗೆ ವಿಶ್ರಾಂತಿಯ ಸಮಯವಿರುವುದಕ್ಕೆ ಬಿಡಬೇಕು. ಇದು ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸುವುದಕ್ಕಾಗಿರುವ ವಿಶೇಷವಾದ ವಿಶ್ರಾಂತಿಯ ಸಮಯವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ನೀವು ಆರು ವರ್ಷಗಳು ನಿಮ್ಮ ಹೊಲದಲ್ಲಿ ಬೀಜಬಿತ್ತುವಿರಿ. ಆರು ವರ್ಷಗಳು ನಿಮ್ಮ ದ್ರಾಕ್ಷಿತೋಟಗಳಲ್ಲಿ ಕೆಲಸಮಾಡುವಿರಿ. ಅದರ ಫಲಗಳನ್ನು ಒಟ್ಟುಗೂಡಿಸುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ಆದರೆ ಏಳನೆಯ ವರ್ಷದಲ್ಲಿ ನೀವು ಭೂಮಿಗೆ ವಿಶ್ರಾಂತಿ ಕೊಡುವಿರಿ. ಇದು ಯೆಹೋವನನ್ನು ಸನ್ಮಾನಿಸಲು ನೇಮಕವಾದ ವಿಶ್ರಾಂತಿಯ ವಿಶೇಷ ಸಮಯವಾಗಿರುವುದು. ನೀವು ನಿಮ್ಮ ಹೊಲಗಳಲ್ಲಿ ಬೀಜವನ್ನು ಬಿತ್ತಬಾರದು, ದ್ರಾಕ್ಷಿತೋಟದ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ಕೊಯ್ಲಿನ ನಂತರ ತನ್ನಷ್ಟಕ್ಕೆ ತಾನೇ ಬೆಳೆದ ಪೈರನ್ನೂ ಕೊಯ್ಯಬಾರದು. ನೀವು ನೋಡಿಕೊಳ್ಳದೆ ಬಿಟ್ಟ ದ್ರಾಕ್ಷಾಲತೆಗಳಲ್ಲಿ ಬಂದ ದ್ರಾಕ್ಷಿಯನ್ನು ಸಂಗ್ರಹಿಸಬಾರದು. ಭೂಮಿಗೆ ಒಂದು ವರ್ಷದ ವಿಶ್ರಾಂತಿಯಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","“ಸಬ್ಬತ್ ವರ್ಷದಲ್ಲಿ ಭೂಮಿಯು ತಾನಾಗಿ ಫಲಿಸುವ ಬೆಳೆಯಿಂದ ನಿಮಗೆ ಸಾಕಷ್ಟು ಆಹಾರವಿರುವುದು. ನಿಮ್ಮ ದಾಸದಾಸಿಯರಿಗೂ ಸಾಕಷ್ಟು ಆಹಾರವಿರುವುದು. ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸವಾಗಿರುವ ಕೂಲಿಯಾಳುಗಳಿಗೂ ಪರದೇಶಸ್ಥರಿಗೂ ಸಾಕಷ್ಟು ಆಹಾರವಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ನಿಮ್ಮ ದನಗಳಿಗೂ ಇತರ ಪ್ರಾಣಿಗಳಿಗೂ ತಿನ್ನುವುದಕ್ಕೆ ಸಾಕಷ್ಟು ಆಹಾರವಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ಅದಲ್ಲದೆ, ಏಳು ವರ್ಷಗಳ ಏಳು ಗುಂಪುಗಳನ್ನು ಲೆಕ್ಕಿಸಬೇಕು. ಈ ಏಳು ಗುಂಪುಗಳು ಸೇರಿ ನಲವತ್ತೊಂಭತ್ತು ವರ್ಷಗಳಾಗಿರುವವು. ಆ ಸಮಯದಲ್ಲಿ ಭೂಮಿಗೆ ಏಳು ವರ್ಷಗಳ ವಿಶ್ರಾಂತಿಯಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ದೋಷಪರಿಹಾರಕ ದಿನದಲ್ಲಿ ಅಂದರೆ ಐವತ್ತನೆಯ ವರ್ಷದ ಏಳನೆಯ ತಿಂಗಳ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ದೇಶದಲ್ಲೆಲ್ಲಾ ಕೊಂಬನ್ನೂದಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ಐವತ್ತನೆಯ ವರ್ಷವನ್ನು ನೀವು ವಿಶೇಷ ವರ್ಷವನ್ನಾಗಿ ಮಾಡಬೇಕು. ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸಿಸುವ ಜನರೆಲ್ಲರಿಗೆ ನೀವು ಸ್ವಾತಂತ್ರ್ಯವನ್ನು ಘೋಷಿಸಬೇಕು. ಈ ಸಮಯವು ‘ಜ್ಯೂಬಿಲಿ’ ಎಂಬುದಾಗಿ ಕರೆಯಲ್ಪಡುವುದು. ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ಸ್ವಂತ ಸ್ವಾಸ್ತ್ಯಕ್ಕೆ ಹಿಂತಿರುಗಿ ಹೋಗುವನು; ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ಸ್ವಂತ ಕುಟುಂಬಕ್ಕೆ ಹಿಂತಿರುಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ಐವತ್ತನೆಯ ವರ್ಷವು ನಿಮಗೆ ವಿಶೇಷವಾದ ಆಚರಣೆಯಾಗಿರುವುದು. ಬೀಜವನ್ನು ಬಿತ್ತಬೇಡಿರಿ. ತನ್ನಷ್ಟಕ್ಕೆ ತಾನೇ ಬೆಳೆದ ಪೈರುಗಳನ್ನು ಕೊಯ್ಯಬೇಡಿರಿ. ನೋಡಿಕೊಳ್ಳದೆ ಬಿಟ್ಟ ದ್ರಾಕ್ಷಾಲತೆಗಳಿಂದ ದ್ರಾಕ್ಷಿಯನ್ನು ಸಂಗ್ರಹಿಸಬೇಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ಆ ವರ್ಷ ಜ್ಯೂಬಿಲಿಯಾಗಿದೆ. ಅದು ನಿಮಗೆ ಪವಿತ್ರ ಸಮಯವಾಗಿರುವುದು. ಹೊಲದಿಂದ ದೊರಕುವ ಪೈರುಗಳು ನಿಮಗೆ ಆಹಾರವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ಜ್ಯೂಬಿಲಿ ವರ್ಷದಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ಸ್ವಂತ ಸ್ವಾಸ್ತ್ಯಕ್ಕೆ ಹೋಗುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ಭೂಮಿಯನ್ನು ನೆರೆಯವನಿಗೆ ಮಾರುವಾಗ ಅಥವಾ ಅವನಿಂದ ಭೂಮಿಯನ್ನು ಕೊಂಡುಕೊಳ್ಳುವಾಗ ಮೋಸ ಮಾಡಬೇಡಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ನಿಮ್ಮ ನೆರೆಯವನ ಭೂಮಿಯನ್ನು ಕೊಂಡುಕೊಳ್ಳಲು ನೀವು ಬಯಸುವುದಾದರೆ, ಆಗ ಕಳೆದ ಜ್ಯೂಬಿಲಿ ವರ್ಷದಿಂದ ಈಗ ಎಷ್ಟು ವರ್ಷವಾಯಿತೆಂದು ಲೆಕ್ಕಿಸಿ ಸರಿಯಾದ ಬೆಲೆಯನ್ನು ನಿರ್ಣಯಿಸಿರಿ. ನೀವು ಭೂಮಿಯನ್ನು ಮಾರುವುದಾದರೆ, ಪೈರುಗಳನ್ನು ಕೊಯ್ಯುವುದಕ್ಕಿರುವ ವರ್ಷಗಳನ್ನು ಲೆಕ್ಕಿಸಿ ಸರಿಯಾದ ಬೆಲೆಯನ್ನು ನಿರ್ಣಯಿಸಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ಇನ್ನೂ ಅನೇಕ ವರ್ಷಗಳು ಇದ್ದರೆ, ಬೆಲೆ ಹೆಚ್ಚಾಗಿರುವುದು. ವರ್ಷಗಳು ಕಡಿಮೆಯಾಗಿದ್ದರೆ, ಬೆಲೆ ಕಡಿಮೆಯಾಗಿರುವುದು. ಯಾಕೆಂದರೆ ನಿಮ್ಮ ನೆರೆಯವನು ನಿಜವಾಗಿ ಕೇವಲ ಕೆಲವೇ ಪೈರುಗಳನ್ನು ನಿಮಗೆ ಮಾರುತ್ತಿದ್ದಾನೆ. ಮುಂದಿನ ಜ್ಯೂಬಿಲಿ ವರ್ಷದಲ್ಲಿ ಭೂಮಿಯು ತಿರುಗಿ ಅವನ ಕುಟುಂಬಕ್ಕೆ ಸೇರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ನೀವು ಒಬ್ಬರಿಗೊಬ್ಬರು ಮೋಸ ಮಾಡಬಾರದು. ನೀವು ದೇವರಿಗೆ ಭಯಪಡಬೇಕು! ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ನನ್ನ ಕಟ್ಟಳೆಗಳನ್ನು ಮತ್ತು ನಿಯಮಗಳನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಿರಿ. ಅವುಗಳಿಗೆ ವಿಧೇಯರಾಗಿರಿ. ಆಗ ನೀವು ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಸುರಕ್ಷಿತವಾಗಿ ವಾಸಿಸುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ಮತ್ತು ಭೂಮಿಯು ಒಳ್ಳೆಯ ಪೈರುಗಳನ್ನು ಕೊಡುವುದು. ಆಗ ನಿಮಗೆ ಬೇಕಾದಷ್ಟು ಆಹಾರವಿರುವುದು ಮತ್ತು ನೀವು ದೇಶದಲ್ಲಿ ಸುರಕ್ಷಿತವಾಗಿ ಜೀವಿಸುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“ಒಂದುವೇಳೆ ನೀವು, ‘ನಾವು ಬೀಜಗಳನ್ನು ಬಿತ್ತದಿದ್ದರೆ ಅಥವಾ ಪೈರುಗಳನ್ನು ಸಂಗ್ರಹಿಸದಿದ್ದರೆ ಏಳನೆಯ ವರ್ಷದಲ್ಲಿ ನಮಗೆ ತಿನ್ನಲು ಏನೂ ಇರುವುದಿಲ್ಲ’ ಎಂದು ಹೇಳಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ಚಿಂತೆ ಮಾಡಬೇಡಿರಿ! ಆರನೆಯ ವರ್ಷದಲ್ಲಿ ನನ್ನ ಆಶೀರ್ವಾದವು ನಿಮ್ಮ ಮೇಲಿರುವುದು. ಆ ವರ್ಷ ಭೂಮಿಯಲ್ಲಿ ಬೆಳೆದ ಪೈರುಗಳು ಮೂರು ವರ್ಷಗಳವರೆಗೆ ಬೆಳೆಯುತ್ತಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ನೀವು ಎಂಟನೆಯ ವರ್ಷದಲ್ಲಿ ಬೀಜ ಬಿತ್ತಿದಾಗ, ನೀವು ಇನ್ನೂ ಹಳೆಯ ಬೆಳೆಯನ್ನು ತಿನ್ನುತ್ತಿರುವಿರಿ. ಒಂಭತ್ತನೆಯ ವರ್ಷದವರೆಗೆ ಅಂದರೆ ಎಂಟನೆಯ ವರ್ಷದಲ್ಲಿ ಬೀಜ ಫಸಲು ಕೊಡುವವರೆಗೆ ನೀವು ಹಳೆಯ ಬೆಳೆಯನ್ನು ತಿನ್ನುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ಭೂಮಿಯು ನನಗೆ ಸೇರಿದ್ದು. ಆದ್ದರಿಂದ ನೀವು ನಿಜವಾಗಿಯೂ ಅದನ್ನು ಶಾಶ್ವತವಾಗಿ ಮಾರುವುದಕ್ಕಾಗುವುದಿಲ್ಲ. ನೀವು ಕೇವಲ ನನ್ನ ಆಶ್ರಯದಲ್ಲಿ ವಾಸಿಸುತ್ತಿರುವ ಪರದೇಶಸ್ಥರೂ ಪ್ರವಾಸಿಗಳೂ ಆಗಿದ್ದೀರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ಜನರು ತಮ್ಮ ಭೂಮಿಯನ್ನು ಮಾರಿದರೆ ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳುವ ಹಕ್ಕು ಅವರ ಕುಟುಂಬಕ್ಕಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಒಬ್ಬನು ತನ್ನ ಆಸ್ತಿಯನ್ನು ಮಾರುವಷ್ಟು ಬಡವನಾದರೆ ಅವನ ಹತ್ತಿರದ ಸಂಬಂಧಿಯು ತನ್ನ ಸಂಬಂಧಿಯ ಆಸ್ತಿಯನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ತನ್ನ ಭೂಮಿಯನ್ನು ಮರಳಿ ಪಡೆಯಲು ಒಬ್ಬನಿಗೆ ಹತ್ತಿರದ ಸಂಬಂಧಿ ಇಲ್ಲದಿರಬಹುದು. ಆದರೆ ತನ್ನ ಭೂಮಿಯನ್ನು ತನಗಾಗಿ ಮರಳಿ ಪಡೆಯುಲು ಅವನು ಸಾಕಷ್ಟು ಹಣವನ್ನು ಪಡೆಯಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ಆಗ ಅವನು ಭೂಮಿಯನ್ನು ಮಾರಿ ಎಷ್ಟು ವರ್ಷವಾಯಿತೆಂದು ಲೆಕ್ಕ ಮಾಡಬೇಕು. ಅವನು ಆ ಸಂಖ್ಯೆಯನ್ನು ಉಪಯೋಗಿಸಿ ಭೂಮಿಗೆ ಕೊಡತಕ್ಕ ಹಣವನ್ನು ನಿರ್ಧರಿಸಬೇಕು. ಬಳಿಕ ಅವನು ಭೂಮಿಯನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಬೇಕು. ಆಗ ಭೂಮಿಯು ಮತ್ತೆ ಅವನ ಸ್ವತ್ತಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ಆದರೆ ಭೂಮಿಯನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಲು ಬೇಕಾದಷ್ಟು ಹಣ ಅವನಿಗೆ ದೊರಕದಿದ್ದರೆ, ಅವನು ಆ ಭೂಮಿಯನ್ನು ಯಾರಿಗೆ ಮಾರಿದ್ದಾನೋ ಅವನ ವಶದಲ್ಲಿ ಜ್ಯೂಬಿಲಿ ವರ್ಷದವರೆಗೆ ಇಡಬೇಕು. ಬಳಿಕ ಆ ವಿಶೇಷ ಬಿಡುಗಡೆಯ ಕಾಲದಲ್ಲಿ ಭೂಮಿಯು ಮೊದಲಿನ ಯಜಮಾನನ ಕುಟುಂಬಕ್ಕೆ ಮರಳಿ ಹೋಗುವುದು. ಹೀಗಾಗಿ ಆಸ್ತಿಯು ತಿರುಗಿ ಅದರ ಸರಿಯಾದ ಕುಟುಂಬಕ್ಕೆ ಸೇರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ಯಾವನಾದರೂ ಪೌಳಿಗೋಡೆಯುಳ್ಳ ಪಟ್ಟಣದಲ್ಲಿರುವ ಮನೆಯನ್ನು ಮಾರಿದರೆ, ಅದನ್ನು ಮಾರಿದ ದಿನ ಮೊದಲುಗೊಂಡು ಒಂದು ವರ್ಷ ಪೂರ್ಣಗೊಳ್ಳುವವರೆಗೆ ಹಿಂದಕ್ಕೆ ಪಡೆಯುವ ಹಕ್ಕು ಅವನಿಗೆ ಇನ್ನೂ ಇರುತ್ತದೆ. ಮನೆಯನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳುವ (ಮರಳಿ ಪಡೆಯುವ) ಹಕ್ಕು ಒಂದು ವರ್ಷದವರೆಗೆ ಇರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ಆದರೆ ಮಾಲಿಕನು ಒಂದು ವರ್ಷ ಪೂರ್ಣಗೊಳ್ಳುವ ಮೊದಲು ಮನೆಯನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳದಿದ್ದರೆ, ಆಗ ಪೌಳಿಗೋಡೆಯುಳ್ಳ ಪಟ್ಟಣದಲ್ಲಿರುವ ಮನೆಯು ಅದನ್ನು ಕೊಂಡುಕೊಂಡವನಿಗೂ ಅವನ ಸಂತತಿಯವರಿಗೂ ಸೇರುವುದು. ಮನೆಯು ಜ್ಯೂಬಿಲಿ ವರ್ಷದಲ್ಲಿ ಅದರ ಮೊದಲಿನ ಯಜಮಾನನಿಗೆ ಸೇರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ಗೋಡೆಗಳಿಲ್ಲದ ಪಟ್ಟಣಗಳನ್ನು ಬಯಲಿನ ಹೊಲಗಳಂತೆ ಪರಿಗಣಿಸಬೇಕು. ಆದ್ದರಿಂದ ಆ ಸಣ್ಣ ಪಟ್ಟಣಗಳಲ್ಲಿ ಕಟ್ಟಿದ ಮನೆಗಳು ಜ್ಯೂಬಿಲಿ ವರ್ಷದಲ್ಲಿ ಅವುಗಳ ಮೊದಲಿನ ಯಜಮಾನನಿಗೆ ಮರುಳಿ ಹೋಗುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ಆದರೆ ಲೇವಿಯರ ಪಟ್ಟಣಗಳ ಕುರಿತು ಹೇಳುವುದಾದರೆ, ಲೇವಿಯರು ತಮಗೆ ಸೇರಿದ ಪಟ್ಟಣಗಳಲ್ಲಿರುವ ತಮ್ಮ ಮನೆಗಳನ್ನು ಯಾವಾಗ ಬೇಕಾದರೂ ಹಿಂದಕ್ಕೆ ಕೊಂಡುಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ಒಬ್ಬನು ಲೇವಿಯಿಂದ ಮನೆಯನ್ನು ಕೊಂಡುಕೊಂಡರೆ, ಲೇವಿಯರ ಪಟ್ಟಣದಲ್ಲಿರುವ ಆ ಮನೆಯು ಜ್ಯೂಬಿಲಿ ಸಮಯದಲ್ಲಿ ತಿರುಗಿ ಲೇವಿಯರಿಗೆ ಸೇರುವುದು. ಯಾಕೆಂದರೆ ಲೇವಿಯರ ಪಟ್ಟಣಗಳಲ್ಲಿರುವ ಮನೆಗಳು ಲೇವಿ ಕುಟುಂಬಕ್ಕೆ ಸೇರಿದ್ದಾಗಿವೆ. ಇಸ್ರೇಲ್ ಜನರು ಆ ಪಟ್ಟಣಗಳನ್ನು ಲೇವಿಯರಿಗೆ ಕೊಟ್ಟಿದ್ದಾರೆ. ಅವು ಇಸ್ರೇಲರ ಮಧ್ಯದಲ್ಲಿರುವ ಲೇವಿಯರ ಆಸ್ತಿಯಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ಅಲ್ಲದೆ ಲೇವಿಯರ ಪಟ್ಟಣಗಳ ಸುತ್ತಲಿರುವ ಹೊಲಗಳನ್ನು ಮತ್ತು ಹುಲ್ಲುಗಾವಲುಗಳನ್ನು ಮಾರಬಾರದು. ಆ ಹೊಲಗಳು ಎಂದೆಂದಿಗೂ ಲೇವಿಯರಿಗೆ ಸೇರಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ಒಂದುವೇಳೆ ನಿಮ್ಮ ಸ್ವದೇಶದ ವ್ಯಕ್ತಿಯೊಬ್ಬನು ಬಹಳ ಬಡವನಾಗಿ ಗತಿಹೀನನಾಗಬಹುದು. ಅವನು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಪ್ರವಾಸಿಯಂತೆ ವಾಸಿಸಲು ನೀವು ಅವಕಾಶ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ಅವನಿಗೆ ನೀವು ಸಾಲ ಕೊಡುವ ಹಣದ ಮೇಲೆ ಬಡ್ಡಿಯನ್ನು ಹೊರಿಸಬಾರದು. ದೇವರನ್ನು ಗೌರವಿಸಿರಿ. ನಿಮ್ಮ ಸ್ವಂತ ದೇಶದವನು ನಿಮ್ಮ ಸಂಗಡ ವಾಸಿಸಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ನೀವು ಅವನಿಗೆ ಸಾಲಕೊಡುವ ಹಣದ ಮೇಲೆ ಬಡ್ಡಿಯನ್ನು ಹೊರಿಸಬಾರದು. ನೀವು ಅವನಿಗೆ ಮಾರುವ ಆಹಾರಪದಾರ್ಥಗಳಿಂದ ಲಾಭವನ್ನು ಗಳಿಸಲು ಪ್ರಯತ್ನಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ನಾನು ನಿಮಗೆ ಕಾನಾನ್ ದೇಶವನ್ನು ಕೊಟ್ಟು ನಿಮ್ಮ ದೇವರಾಗಿರಲು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ಒಂದುವೇಳೆ ನಿಮ್ಮ ಸ್ವದೇಶಸ್ಥನು ಬಹಳ ಬಡವನಾಗಿ ತನ್ನನ್ನು ಗುಲಾಮನನ್ನಾಗಿ ನಿಮಗೆ ಮಾರಿಕೊಂಡರೆ ನೀವು ಅವನನ್ನು ಗುಲಾಮನನ್ನಾಗಿ ದುಡಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ಅವನು ಕೂಲಿಯಾಳಿನಂತೆಯೂ ಜ್ಯೂಬಿಲಿ ವರ್ಷದವರೆಗೆ ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ಪ್ರವಾಸಿಯಂತೆಯೂ ಇರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ಬಳಿಕ ನಿಮ್ಮನ್ನು ಬಿಟ್ಟುಹೋಗಲು ಅವನಿಗೆ ಹಕ್ಕಿದೆ. ಅವನು ತನ್ನ ಮಕ್ಕಳನ್ನು ಕರೆದುಕೊಂಡು ತನ್ನ ಕುಟುಂಬಕ್ಕೆ ಮರಳಿ ಹೋಗಬಹುದು. ಅವನು ತನ್ನ ಪೂರ್ವಿಕರ ಸ್ವತ್ತನ್ನು ಹಿಂದಕ್ಕೆ ಪಡೆಯಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ಯಾಕೆಂದರೆ ಅವರು ನನ್ನ ಸೇವಕರಾಗಿದ್ದಾರೆ. ನಾನು ಅವರನ್ನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಗುಲಾಮತನದಿಂದ ಹೊರಗೆ ಬರಮಾಡಿದೆನು; ಅವರು ಮತ್ತೆ ಗುಲಾಮರಾಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ನೀವು ಈ ವ್ಯಕ್ತಿಗೆ ಕ್ರೂರ ಯಾಜಮಾನರಾಗಿರಬಾರದು. ನೀವು ನಿಮ್ಮ ದೇವರನ್ನು ಗೌರವಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ನಿಮ್ಮ ಸುತ್ತಲಿರುವ ಬೇರೆ ಜನಾಂಗಗಳಿಂದ ನೀವು ಸೇವಕಸೇವಕಿಯರನ್ನು ಖರೀದಿ ಮಾಡಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ಅಲ್ಲದೆ ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ವಾಸಿಸುವ ಪರದೇಶಸ್ಥರಿಂದ ಮಕ್ಕಳನ್ನು ಗುಲಾಮರನ್ನಾಗಿ ಕೊಂಡುಕೊಳ್ಳಬಹುದು. ಗುಲಾಮರಾದ ಮಕ್ಕಳು ನಿಮಗೆ ಸೇರಿದವರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ಗುಲಾಮರಾದ ಈ ಪರದೇಶಸ್ಥರನ್ನು ನೀವು ಸತ್ತನಂತರ ನಿಮ್ಮ ಮಕ್ಕಳಿಗೆ ಕೊಡಬೇಕು. ಹೀಗೆ ಅವರು ನಿಮ್ಮ ಮಕ್ಕಳಿಗೆ ಸೇರಿದವರಾಗುವರು. ಅವರು ಎಂದೆಂದೂ ನಿಮ್ಮ ಗುಲಾಮರಾಗಿರುವರು. ನಿಮ್ಮ ಈ ಪರದೇಶಸ್ಥರನ್ನು ಗುಲಾಮರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಬಹುದು. ಆದರೆ ನೀವು ಇಸ್ರೇಲ್ ಜನರಾದ ನಿಮ್ಮ ಸ್ವಂತ ಸಹೋದರರ ಮೇಲೆ ಕ್ರೂರವಾದ ಒಡೆಯರಾಗಿರಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ಒಂದುವೇಳೆ ನಿಮ್ಮ ಸ್ವದೇಶದವನು ಬಡವನಾಗಿದ್ದು, ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸಲು ಬಂದ ಐಶ್ವರ್ಯವಂತನಾದ ಪರದೇಶಸ್ಥನಿಗಾಗಲಿ ಅಥವಾ ಅವನ ಕುಟುಂಬದ ಸದಸ್ಯನಿಗಾಗಲಿ ತನ್ನನ್ನು ಮಾರಿಕೊಂಡಿದ್ದರೂ ಅವನಿಗೆ ತನ್ನನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳುವ ಹಕ್ಕಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ಅವನ ಸಂಬಂಧಿಕರಲ್ಲಿ ಯಾರಾದರೂ ಅವನನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ಅವನ ದೊಡ್ಡಪ್ಪನಾಗಲಿ ಚಿಕ್ಕಪ್ಪನಾಗಲಿ ಅವರ ಮಕ್ಕಳಾಗಲಿ ಅವನನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಬಹುದು. ಅವನ ಹತ್ತಿರದ ಸಂಬಂಧಿಯು ಅವನನ್ನು ಕೊಂಡುಕೊಳ್ಳಬಹುದು. ಅವನಿಗೆ ಸಾಕಷ್ಟು ಹಣ ದೊರಕಿದರೆ, ಅವನು ತಾನೇ ಹಣ ಕೊಟ್ಟು ಮತ್ತೆ ಸ್ವತಂತ್ರನಾಗಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“ನೀವು ಬೆಲೆಯನ್ನು ತೀರ್ಮಾನಿಸುವುದು ಹೇಗೆಂದರೆ: ಅವನು ತನ್ನನ್ನು ಪರದೇಶಸ್ಥನಿಗೆ ಮಾರಿಕೊಂಡ ದಿನದಿಂದ ಹಿಡಿದು ಮುಂದಿನ ಜ್ಯೂಬಿಲಿ ವರ್ಷದವರೆಗೆ ವರ್ಷಗಳನ್ನು ಲೆಕ್ಕಿಸಿ ಬೆಲೆಯನ್ನು ತೀರ್ಮಾನಿಸಿರಿ. ಯಾಕೆಂದರೆ ಅವನು ತನ್ನನ್ನು ಕೇವಲ ಕೆಲವು ವರ್ಷಗಳವರೆಗೆ ಕೂಲಿಗೆ ಒಪ್ಪಿಸಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ಜ್ಯೂಬಿಲಿ ವರ್ಷಕ್ಕೆ ಇನ್ನೂ ಹೆಚ್ಚು ವರ್ಷಗಳು ಇರುವುದಾದರೆ, ಅವನು ಬಹಳ ಹೆಚ್ಚು ಹಣವನ್ನು ಕೊಡಬೇಕಾಗುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ಜ್ಯೂಬಿಲಿ ವರ್ಷಕ್ಕೆ ಕೇವಲ ಸ್ವಲ್ಪ ವರ್ಷಗಳು ಉಳಿದಿದ್ದರೆ, ಸ್ವಲ್ಪ ಹಣವನ್ನು ಕೊಡಬೇಕಾಗುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ಆದರೆ ಅವನು ಪರದೇಶಸ್ಥನೊಡನೆ ಪ್ರತಿ ವರ್ಷ ಕೂಲಿಯಾಳಾಗಿ ವಾಸಿಸುವನು. ಪರದೇಶಸ್ಥನು ಆ ವ್ಯಕ್ತಿಯ ಮೇಲೆ ಕ್ರೂರ ಯಜಮಾನನಾಗಿ ಇರುವುದಕ್ಕೆ ಬಿಡಬೇಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ಯಾರೂ ಅವನನ್ನು ಬಿಡಿಸದಿದ್ದರೂ ಜ್ಯೂಬಿಲಿ ವರ್ಷದಲ್ಲಿ ಅವನು ಮತ್ತು ಅವನ ಮಕ್ಕಳು ಬಿಡುಗಡೆ ಹೊಂದುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ಯಾಕೆಂದರೆ, ಇಸ್ರೇಲರು ನನ್ನ ಸೇವಕರಾಗಿದ್ದಾರೆ. ನಾನು ಅವರನ್ನು ಈಜಿಪ್ಟಿನಲ್ಲಿ ದಾಸತ್ವದಿಂದ ಬಿಡಿಸಿದ್ದರಿಂದ ಅವರು ನನ್ನ ದಾಸರಾಗಿದ್ದಾರೆ. ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ವಿಗ್ರಹಗಳನ್ನು ಮಾಡಿಕೊಳ್ಳಬೇಡಿರಿ. ಆರಾಧಿಸಲು ಕೆತ್ತಿದ ವಿಗ್ರಹಗಳನ್ನಾಗಲಿ ಕಲ್ಲುಕಂಬಗಳನ್ನಾಗಲಿ ನಿಮ್ಮ ದೇಶದಲ್ಲಿ ಸ್ಥಾಪಿಸಬೇಡಿರಿ. ಯಾಕೆಂದರೆ ನಾನೇ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ನನ್ನ ವಿಶ್ರಾಂತಿಯ ವಿಶೇಷ ದಿನಗಳನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಂಡು ನನ್ನ ಪವಿತ್ರಸ್ಥಳವನ್ನು ಸನ್ಮಾನಿಸಿರಿ. ನಾನೇ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ನನ್ನ ಕಟ್ಟಳೆಗಳನ್ನೂ ಆಜ್ಞೆಗಳನ್ನೂ ಜ್ಞಾಪಕಮಾಡಿಕೊಂಡು ಅವುಗಳಿಗೆ ವಿಧೇಯರಾಗಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ನೀವು ಅವುಗಳನ್ನು ಅನುಸರಿಸಿದರೆ, ನಾನು ಸರಿಯಾದ ಸಮಯದಲ್ಲಿ ಮಳೆಯನ್ನು ಅನುಗ್ರಹಿಸುವೆನು. ಭೂಮಿಯು ಒಳ್ಳೆಯ ಬೆಳೆಯನ್ನು ಕೊಡುವುದು ಮತ್ತು ತೋಟದ ಮರಗಳು ತಮ್ಮ ಫಲಗಳನ್ನು ಕೊಡುವವು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ಕಣ ತುಳಿಸುವ ಕೆಲಸವು ದ್ರಾಕ್ಷಿಯನ್ನು ಸಂಗ್ರಹಿಸುವ ಸಮಯದವರೆಗೂ ಮುಂದುವರಿಯುವುದು; ದ್ರಾಕ್ಷಿಯನ್ನು ಸಂಗ್ರಹಿಸುವ ಕೆಲಸವು ಬಿತ್ತನೆಯ ಕಾಲದವರೆಗೂ ಮುಂದುವರಿಯುವುದು. ಆಗ ನಿಮಗೆ ಆಹಾರವು ಸಮೃದ್ಧಿಯಾಗಿರುವುದು; ನೀವು ದೇಶದಲ್ಲಿ ಸುರಕ್ಷಿತವಾಗಿ ವಾಸಿಸುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ನಾನು ನಿಮ್ಮ ದೇಶಕ್ಕೆ ಸಮಾಧಾನವನ್ನು ಅನುಗ್ರಹಿಸುವೆನು. ನೀವು ನಿರ್ಭಯವಾಗಿ ಮಲಗಿಕೊಳ್ಳುವಿರಿ. ನಿಮ್ಮನ್ನು ಭಯಪಡಿಸಲು ಯಾರೂ ಬರುವುದಿಲ್ಲ. ದುಷ್ಟಮೃಗಗಳು ನಿಮ್ಮ ದೇಶದಲ್ಲಿರದಂತೆ ಮಾಡುವೆನು. ಸೈನ್ಯಗಳು ನಿಮ್ಮ ದೇಶದೊಳಕ್ಕೆ ಬರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","“ನೀವು ನಿಮ್ಮ ವೈರಿಗಳನ್ನು ಸೋಲಿಸಿ ಓಡಿಸಿಬಿಡುವಿರಿ. ನಿಮ್ಮ ಕತ್ತಿಗಳಿಂದ ಅವರನ್ನು ಕೊಲ್ಲುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ನಿಮ್ಮಲ್ಲಿ ಐದು ಮಂದಿ ನೂರು ಮಂದಿಯನ್ನು ಓಡಿಸುವರು; ನಿಮ್ಮಲ್ಲಿ ನೂರು ಮಂದಿ ಹತ್ತು ಸಾವಿರ ಮಂದಿಯನ್ನು ಓಡಿಸುವರು; ನೀವು ನಿಮ್ಮ ವೈರಿಗಳನ್ನು ಸೋಲಿಸಿ ಕತ್ತಿಯಿಂದ ಕೊಲ್ಲುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ಬಳಿಕ ನಾನು ನಿಮ್ಮ ಮೇಲೆ ಕಟಾಕ್ಷವಿಟ್ಟು ನಿಮಗೆ ಅನೇಕ ಮಕ್ಕಳನ್ನು ಅನುಗ್ರಹಿಸುವೆನು. ನಾನು ನಿಮ್ಮೊಡನೆ ಮಾಡಿಕೊಂಡ ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ನೆರವೇರಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ಒಂದು ವರ್ಷಕ್ಕಿಂತಲೂ ಹೆಚ್ಚು ಸಮಯದವರೆಗೆ ಉಳಿಯುವಂತೆ ನಿಮಗೆ ಬೇಕಾದಷ್ಟು ದವಸಧಾನ್ಯಗಳಿರುತ್ತದೆ. ನೀವು ಹೊಸ ಬೆಳೆಯನ್ನು ಕೊಯ್ಯುವಿರಿ. ಆದರೆ ಹೊಸ ಬೆಳೆಯನ್ನು ಸಂಗ್ರಹಿಸಬೇಕಾದರೆ ಹಳೆ ಬೆಳೆಯನ್ನು ಬಿಸಾಡಬೇಕಾಗುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ಅಲ್ಲದೆ ನಾನು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ನನ್ನ ಪವಿತ್ರಗುಡಾರವನ್ನು ಇಡುವೆನು. ನಾನು ನಿಮ್ಮಿಂದ ದೂರ ಹೋಗುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ನಾನು ನಿಮ್ಮೊಂದಿಗೆ ನಡೆಯುತ್ತಾ ನಿಮ್ಮ ದೇವರಾಗಿರುವೆನು ಮತ್ತು ನೀವು ನನ್ನ ಜನರಾಗಿರುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ನಿಮ್ಮ ದೇವರಾಗಿರುವ ಯೆಹೋವನು ನಾನೇ! ನೀವು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಗುಲಾಮರಾಗಿದ್ದಿರಿ. ಆದರೆ ನಾನು ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದೆನು. ನೀವು ಗುಲಾಮರಾಗಿ ಭಾರವಾದ ಹೊರೆಗಳನ್ನು ಹೊರುತ್ತಾ ಗೂನಾಗಿದ್ದಿರಿ. ಆದರೆ ನಿಮ್ಮ ಭುಜದ ಮೇಲಿದ್ದ್ದ ನೊಗವನ್ನು ನಾನು ಮುರಿದುಹಾಕಿ ನೀವು ಮತ್ತೆ ನೆಟ್ಟಗೆ ನಡೆಯುವಂತೆ ಮಾಡಿದೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ಆದರೆ ನೀವು ನನಗೆ ಮತ್ತು ನನ್ನ ಆಜ್ಞೆಗಳಿಗೆಲ್ಲಾ ವಿಧೇಯರಾಗದಿದ್ದರೆ, ಕೆಟ್ಟ ಸಂಗತಿಗಳು ನಿಮಗೆ ಸಂಭವಿಸುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ನೀವು ನನ್ನ ಕಟ್ಟಳೆಗಳಿಗೆ ಮತ್ತು ಆಜ್ಞೆಗಳಿಗೆ ವಿಧೇಯರಾಗದಿದ್ದರೆ, ಆಗ ನೀವು ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಮುರಿದವರಾಗುತ್ತೀರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ಆಗ ನಾನು ನಿಮ್ಮ ಮಧ್ಯೆ ಭಯಂಕರ ಸಂಗತಿಗಳು ನಡೆಯುವಂತೆ ಮಾಡುವೆನು. ನೀವು ವ್ಯಾಧಿಯಿಂದಲೂ ಜ್ವರದಿಂದಲೂ ನರಳುವಂತೆ ಮಾಡುವೆನು. ಅವು ನಿಮ್ಮ ಕಣ್ಣುಗಳನ್ನು ನಾಶಮಾಡಿ ನಿಮ್ಮ ಪ್ರಾಣವನ್ನು ತೆಗೆದುಬಿಡುತ್ತವೆ; ನೀವು ಬೀಜ ಬಿತ್ತಿದರೂ ಅದರ ಫಲವು ದೊರೆಯುವುದಿಲ್ಲ: ನಿಮ್ಮ ವೈರಿಗಳು ನಿಮ್ಮ ಬೆಳೆಗಳನ್ನು ತಿಂದುಬಿಡುವರು! ");
INSERT INTO kan2010_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ನಾನು ನಿಮಗೆ ವಿಮುಖನಾಗಿರುವುದರಿಂದ ಆ ವೈರಿಗಳು ನಿಮ್ಮನ್ನು ಸೋಲಿಸುವರು. ಆ ವೈರಿಗಳು ನಿಮ್ಮನ್ನು ದ್ವೇಷಿಸುವರು ಮತ್ತು ನಿಮ್ಮನ್ನು ಆಳುವರು. ಯಾರೂ ನಿಮ್ಮನ್ನು ಬೆನ್ನಟ್ಟದಿದ್ದರೂ ಹೆದರಿಕೊಂಡು ಓಡುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ಇಷ್ಟಾದರೂ ನೀವು ನನಗೆ ವಿಧೇಯರಾಗದಿದ್ದರೆ ನಿಮ್ಮ ಪಾಪಗಳಿಗಾಗಿ ಇನ್ನೂ ಏಳರಷ್ಟು ನಿಮ್ಮನ್ನು ಶಿಕ್ಷಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ನಿಮ್ಮ ಗರ್ವಕ್ಕೆ ಕಾರಣವಾದ ಬಲಿಷ್ಟವಾದ ಪಟ್ಟಣಗಳನ್ನು ನಾಶಮಾಡುವೆನು. ಆಕಾಶವು ಮಳೆಗರೆಯುವುದಿಲ್ಲ. ಭೂಮಿಯು ಬೆಳೆಯನ್ನು ಫಲಿಸುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ನೀವು ಕಷ್ಟಪಟ್ಟು ದುಡಿದರೂ ನಿಮಗೆ ಪ್ರಯೋಜನವಿರುವುದಿಲ್ಲ. ನಿಮ್ಮ ಭೂಮಿ ಯಾವ ಬೆಳೆಗಳನ್ನೂ ಫಲಿಸುವುದಿಲ್ಲ; ನಿಮ್ಮ ಮರಗಳೂ ಫಲಗಳನ್ನು ಬಿಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ನೀವು ಇನ್ನೂ ನನಗೆ ವಿರುದ್ಧವಾಗಿ ತಿರುಗಿ ಅವಿಧೇಯರಾದರೆ, ನಾನು ಇನ್ನೂ ಏಳರಷ್ಟು ಕಠಿಣವಾಗಿ ನಿಮ್ಮನ್ನು ಬಾಧಿಸುವೆನು. ನೀವು ಹೆಚ್ಚು ಪಾಪಮಾಡಿದಂತೆಲ್ಲಾ ಹೆಚ್ಚೆಚ್ಚಾಗಿ ಶಿಕ್ಷಿಸಲ್ಪಡುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ನಿಮಗೆ ವಿರುದ್ಧವಾಗಿ ನಾನು ಕ್ರೂರ ಮೃಗಗಳನ್ನು ಕಳುಹಿಸುವೆನು. ಅವುಗಳು ನಿಮ್ಮ ಮಕ್ಕಳನ್ನು ತಿಂದು ಬಿಡುವವು; ನಿಮ್ಮ ಪಶುಗಳನ್ನು ನಾಶಮಾಡುವವು. ಅವು ನಿಮ್ಮಲ್ಲಿ ಅನೇಕ ಜನರನ್ನು ಕೊಲ್ಲುವವು. ದಾರಿಗಳು ಜನಸಂಚಾರವಿಲ್ಲದೆ ಬರಿದಾಗಿರುವವು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ಇಷ್ಚಾದರೂ ನೀವು ತಿದ್ದಿಕೊಳ್ಳದೆ ನನಗೆ ವಿರೋಧವಾಗಿ ನಡೆದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ಆಗ ನಾನು ಸಹ ನಿಮಗೆ ವಿರೋಧವಾಗಿ ನಡೆಯುವೆನು. ಹೌದು, ನಾನೇ ನಿಮ್ಮನ್ನು ನಿಮ್ಮ ಪಾಪಗಳಿಗಾಗಿ ಏಳರಷ್ಟಾಗಿ ದಂಡಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ನೀವು ನನ್ನ ಒಡಂಬಡಿಕೆಯನ್ನು ಮೀರಿದ್ದರಿಂದ ನಾನು ನಿಮ್ಮನ್ನು ದಂಡಿಸುವೆನು. ನಿಮಗೆ ವಿರೋಧವಾಗಿ ಸೈನ್ಯಗಳನ್ನು ಬರಮಾಡುವೆನು. ನೀವು ಭದ್ರತೆಗಾಗಿ ನಿಮ್ಮ ಪಟ್ಟಣಗಳೊಳಗೆ ಹೋಗುವಿರಿ. ಆದರೆ ವ್ಯಾಧಿಯು ನಿಮ್ಮಲ್ಲಿ ಹಬ್ಬುವಂತೆ ಮಾಡುವೆನು. ನಿಮ್ಮ ವೈರಿಗಳು ನಿಮ್ಮನ್ನು ಸೋಲಿಸುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ನಿಮಗೆ ರೊಟ್ಟಿ ದಯಪಾಲಿಸುವುದನ್ನು ನಾನು ನಿಲ್ಲಿಸಿದಾಗ, ಹತ್ತು ಮಂದಿ ಸ್ತ್ರೀಯರು ತಮ್ಮಲ್ಲಿರುವ ಎಲ್ಲಾ ರೊಟ್ಟಿಗಳನ್ನು ಒಂದೇ ಒಲೆಯಲ್ಲಿ ಸುಡುವರು. ಅವರು ಪ್ರತಿ ರೊಟ್ಟಿಯ ತುಂಡನ್ನು ತೂಕ ಮಾಡಿ ಹಂಚಿಕೊಳ್ಳುವರು. ನೀವು ತಿಂದರೂ ಹಸಿದವರಾಗಿಯೇ ಇರುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ನೀವು ನನ್ನ ಮಾತನ್ನು ಇನ್ನೂ ಕೇಳದೆ ನನಗೆ ವಿರೋಧವಾಗಿ ನಡೆದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ನಾನು ನಿಜವಾಗಿ ನನ್ನ ಕೋಪವನ್ನು ತೋರಿಸುವೆನು. ಹೌದು, ನಾನೇ ನಿಮ್ಮ ಪಾಪಗಳಿಗಾಗಿ ನಿಮ್ಮನ್ನು ಏಳರಷ್ಟಾಗಿ ದಂಡಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ನೀವು ಬಹಳವಾಗಿ ಹಸಿದು ನಿಮ್ಮ ಮಕ್ಕಳ ಮಾಂಸವನ್ನೇ ತಿನ್ನುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ನಾನು ನಿಮ್ಮ ಉನ್ನತವಾದ ಪೂಜಾಸ್ಥಳಗಳನ್ನು ನಾಶಮಾಡುವೆನು. ನಾನು ನಿಮ್ಮ ಧೂಪವೇದಿಕೆಗಳನ್ನು ಕಡಿದುಹಾಕುವೆನು. ನಿಮ್ಮ ವಿಗ್ರಹಗಳ ಮೇಲೆ ನಿಮ್ಮ ಹೆಣಗಳನ್ನು ಹಾಕುವೆನು. ನೀವು ನನಗೆ ಬಹಳ ಅಸಹ್ಯರಾಗಿರುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ನಾನು ನಿಮ್ಮ ಪಟ್ಟಣಗಳನ್ನು ನಾಶಮಾಡುವೆನು. ನಿಮ್ಮ ಪವಿತ್ರಸ್ಥಳಗಳನ್ನು ಬರಿದುಮಾಡುವೆನು. ನಿಮ್ಮ ಯಜ್ಞಗಳ ಸುವಾಸನೆಯನ್ನು ನಾನು ಮೂಸಿ ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ನಿಮ್ಮ ಭೂಮಿಯನ್ನು ಬರಿದುಮಾಡುವೆನು. ಅದರಲ್ಲಿ ವಾಸಿಸಲು ಬರುವ ನಿಮ್ಮ ವೈರಿಗಳೂ ಅದನ್ನು ನೋಡಿ ಆಶ್ಚರ್ಯಪಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ನಾನು ನಿಮ್ಮನ್ನು ಜನಾಂಗಗಳ ಮಧ್ಯದಲ್ಲಿ ಚದರಿಸಿಬಿಡುವೆನು. ಕತ್ತಿಯನ್ನು ಇರಿದು ನಿಮ್ಮನ್ನು ನಾಶಮಾಡುವೆನು. ನಿಮ್ಮ ಭೂಮಿ ಬರಿದಾಗುವುದು ಮತ್ತು ನಿಮ್ಮ ಪಟ್ಟಣಗಳು ನಾಶವಾಗುವವು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“ನೀವು ನಿಮ್ಮ ವೈರಿಗಳ ದೇಶಕ್ಕೆ ಒಯ್ಯಲ್ಪಟ್ಟಾಗ, ನಿಮ್ಮ ದೇಶ ಬರಿದಾಗುವುದಲ್ಲದೆ ಭೂಮಿಯು ಹಾಳುಬಿದ್ದು ವಿಶ್ರಾಂತಿಯನ್ನು ಅನುಭವಿಸುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ಪ್ರತಿ ಏಳು ವರ್ಷದ ನಂತರ ಭೂಮಿಗೆ ವಿಶ್ರಾಂತಿ ಕೊಡಬೇಕೆಂದು ಧರ್ಮಶಾಸ್ತ್ರ ಹೇಳಿದಂತೆ, ನೀವು ವೈರಿಗಳ ದೇಶದಲ್ಲಿ ವಾಸಿಸಿದ ಕಾಲವೆಲ್ಲಾ ನೀವು ಭೂಮಿಗೆ ಕೊಡದೆ ಇದ್ದ ವಿಶ್ರಾಂತಿಯನ್ನು ಆ ಸಮಯದಲ್ಲಿ ಭೂಮಿಯು ಪಡೆದುಕೊಳ್ಳುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ಜೀವಂತವಾಗಿ ಉಳಿದವರು ತಮ್ಮ ವೈರಿಗಳ ದೇಶದಲ್ಲಿ ಅಧೈರ್ಯಗೊಳ್ಳುವರು. ಅವರು ಪ್ರತಿಯೊಂದಕ್ಕೂ ದಿಗಿಲುಪಡುವರು. ಗಾಳಿಯಿಂದ ತೂರಿಹೋಗುವ ಎಲೆಯ ಶಬ್ದಕ್ಕೆ ಅವರು ಓಡಿಹೋಗುವರು. ಕತ್ತಿಯನ್ನು ಹಿಡಿದುಕೊಂಡು ಬೆನ್ನಟ್ಟುತ್ತಿದ್ದಾರೋ ಎಂಬಂತೆ ಅವರು ಓಡಿಹೋಗುವರು. ಯಾರೂ ಬೆನ್ನಟ್ಟದಿದ್ದಾಗಲೂ ಅವರು ಎಡವಿ ಬೀಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ಒಬ್ಬನು ಕತ್ತಿಯನ್ನು ಹಿಡಿದುಕೊಂಡು ಬೆನ್ನಟ್ಟುವಾಗ ಓಡಿಹೋಗುವಂತೆ ಅವರು ಓಡಿಹೋಗುವರು. ಯಾರೂ ಅವರನ್ನು ಬೆನ್ನಟ್ಟದಿದ್ದಾಗಲೂ ಅವರು ಒಬ್ಬರ ಮೇಲೊಬ್ಬರು ಬೀಳುವರು. “ನೀವು ನಿಮ್ಮ ವೈರಿಗಳ ವಿರುದ್ಧವಾಗಿ ನಿಲ್ಲುವಷ್ಟು ಶಕ್ತಿಯುಳ್ಳವರಾಗಿರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ನೀವು ಬೇರೆ ಜನಾಂಗಗಳಲ್ಲಿ ಬೆರೆತು ಇಲ್ಲದಂತಾಗುವಿರಿ. ನಿಮ್ಮ ವೈರಿಗಳ ದೇಶದಲ್ಲಿ ನೀವು ಮಾಯವಾಗಿ ಹೋಗುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ಆದ್ದರಿಂದ ನಿಮ್ಮಲ್ಲಿ ಜೀವಂತವಾಗಿ ಉಳಿದವರು ತಮ್ಮ ಪಾಪದ ದೆಸೆಯಿಂದಲೂ ತಮ್ಮ ಪೂರ್ವಿಕರ ಪಾಪದ ದೆಸೆಯಿಂದಲೂ ಅವರಂತೆಯೇ ಶತ್ರುಗಳ ದೇಶಗಳಲ್ಲಿ ಕ್ಷಯಿಸಿಹೋಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ಒಂದುವೇಳೆ ಜನರು ತಮ್ಮ ಪಾಪಗಳನ್ನೂ ತಮ್ಮ ಪೂರ್ವಿಕರ ಪಾಪಗಳನ್ನೂ ಅರಿಕೆ ಮಾಡಬಹುದು; ನನಗೆ ವಿರುದ್ಧವಾಗಿ ಪಾಪಮಾಡಿರುವುದಾಗಿಯೂ ನನಗೆ ವಿರೋಧವಾಗಿ ತಿರುಗಿರುವುದಾಗಿಯೂ ಅವರು ಒಪ್ಪಿಕೊಂಡು ");
INSERT INTO kan2010_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ನಾನು ಅವರಿಗೆ ವಿಮುಖನಾಗಿ ಅವರನ್ನು ಶತ್ರುಗಳ ದೇಶಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಂದೆನೆಂದು ಅವರು ಅರಿತುಕೊಂಡು ತಮ್ಮನ್ನು ತಗ್ಗಿಸಿಕೊಂಡು ತಮ್ಮ ಪಾಪಕ್ಕೆ ಬರತಕ್ಕ ಶಿಕ್ಷೆಯನ್ನು ಸ್ವೀಕರಿಸಲು ಯೋಗ್ಯರೆಂದು ಹೇಳಿಕೊಂಡರೆ ");
INSERT INTO kan2010_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ಆಗ ನಾನು ಯಾಕೋಬನೊಂದಿಗೆ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಯನ್ನೂ ಇಸಾಕನೊಂದಿಗೆ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಯನ್ನೂ ಅಬ್ರಹಾಮನೊಂದಿಗೆ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಯನ್ನೂ ದೇಶವನ್ನೂ ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“ದೇಶವು ಬರಿದಾಗಿದ್ದು ವಿಶ್ರಾಂತಿಯನ್ನು ಅನುಭವಿಸುವುದು. ಆಗ ಜೀವಂತವಾಗಿ ಉಳಿದವರು ತಮ್ಮ ಪಾಪಗಳಿಗೆ ಬರತಕ್ಕ ಶಿಕ್ಷೆಯನ್ನು ಅನುಭವಿಸುವರು. ನನ್ನ ನಿಯಮಗಳನ್ನು ದ್ವೇಷಿಸಿ ನನ್ನ ವಿಧಿಗಳಿಗೆ ಅವಿಧೇಯರಾದ್ದರಿಂದ ತಮಗೆ ಶಿಕ್ಷೆಯಾಯಿತೆಂದು ಅವರು ಅರಿತುಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ಅವರು ನಿಜವಾಗಿ ಪಾಪಮಾಡಿದ್ದರೂ ಸಹಾಯಕ್ಕಾಗಿ ಅವರು ನನ್ನ ಬಳಿಗೆ ಬಂದರೆ ನಾನು ಅವರಿಗೆ ವಿಮುಖನಾಗುವುದಿಲ್ಲ. ಅವರು ತಮ್ಮ ಶತ್ರುಗಳ ದೇಶದಲ್ಲಿದ್ದರೂ ನಾನು ಅವರಿಗೆ ಕಿವಿಗೊಡುವೆನು. ಅವರನ್ನು ಸಂಪೂರ್ಣವಾಗಿ ನಾಶಮಾಡುವುದಿಲ್ಲ. ಅವರೊಂದಿಗೆ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಯನ್ನು ಮರೆಯುವುದಿಲ್ಲ. ಯಾಕೆಂದರೆ ನಾನೇ ಅವರ ದೇವರಾದ ಯೆಹೋವನು! ");
INSERT INTO kan2010_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ಅವರಿಗೋಸ್ಕರ ಅವರ ಪೂರ್ವಿಕರ ಸಂಗಡ ಮಾಡಿಕೊಂಡ ಒಡಂಬಡಿಕೆಯನ್ನು ನೆನಪಿಗೆ ತಂದುಕೊಂಡು ಅವರಿಗೆ ಹಿತವನ್ನು ಮಾಡುವೆನು. ನಾನು ಅವರ ದೇವರಾಗಿರಬೇಕೆಂದು ಅವರ ಪೂರ್ವಿಕರನ್ನು ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಬಂದೆನು. ಬೇರೆ ಜನಾಂಗಗಳವರು ಆ ಸಂಗತಿಗಳನ್ನು ನೋಡಿದರು. ನಾನೇ ಯೆಹೋವನು!” ");
INSERT INTO kan2010_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ಯೆಹೋವನು ಇಸ್ರೇಲರಿಗೆ ಕೊಟ್ಟ ಕಟ್ಟಳೆಗಳು, ನಿಯಮಗಳು ಮತ್ತು ಉಪದೇಶಗಳು ಇವೇ. ಇದು ಯೆಹೋವನ ಮತ್ತು ಇಸ್ರೇಲರ ನಡುವೆ ಆದ ಒಡಂಬಡಿಕೆಯ ನಿಯಮಗಳಾಗಿವೆ. ಯೆಹೋವನು ಆ ನಿಯಮಗಳನ್ನು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಗೆ ಕೊಟ್ಟನು. ಮೋಶೆಯು ಅವುಗಳನ್ನು ಜನರಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ಯಾವನಾದರೂ ಯೆಹೋವನಿಗೆ ಒಬ್ಬ ವ್ಯಕ್ತಿಯನ್ನು ಪ್ರತಿಷ್ಠಿಸುವುದಕ್ಕಾಗಿ ಹರಕೆ ಮಾಡಿಕೊಂಡರೆ ಅವನಿಗೆ ಒಂದು ಬೆಲೆಯನ್ನು ನಿಗದಿಮಾಡಬೇಕು. ಅವನನ್ನು ಯೆಹೋವನಿಂದ ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳ ಬಯಸುವವರು ಆ ಬೆಲೆಯನ್ನು ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ಇಪ್ಪತ್ತರಿಂದ ಅರವತ್ತು ವರ್ಷದ ಒಳಗಿರುವ ಮನುಷ್ಯನ ಬೆಲೆ ಐವತ್ತು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯಾಗಿದೆ. (ಬೆಳ್ಳಿಯನ್ನು ಅಳೆಯಲು ಅಧಿಕೃತ ಅಳತೆಯನ್ನು ಉಪಯೋಗಿಸಬೇಕು.) ");
INSERT INTO kan2010_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ಇಪ್ಪತ್ತರಿಂದ ಅರವತ್ತು ವರ್ಷದೊಳಗಿರುವ ಸ್ತ್ರೀಯ ಬೆಲೆ ಮೂವತ್ತು ಶೆಕೆಲ್‌ಗಳಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ಐದರಿಂದ ಇಪ್ಪತ್ತು ವರ್ಷದೊಳಗಿರುವ ಗಂಡಸಿನ ಬೆಲೆ ಇಪ್ಪತ್ತು ಶೆಕೆಲ್‌ಗಳಾಗಿದೆ. ಐದರಿಂದ ಇಪ್ಪತ್ತು ವರ್ಷದೊಳಗಿರುವ ಸ್ತ್ರೀಯ ಬೆಲೆ ಹತ್ತು ಶೆಕೆಲ್‌ಗಳಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ಒಂದು ತಿಂಗಳಿಂದ ಐದು ವರ್ಷದೊಳಗಿನ ಗಂಡು ಮಗುವಿನ ಬೆಲೆ ಐದು ಶೆಕೆಲ್‌ಗಳಾಗಿದೆ. ಹೆಣ್ಣುಮಗುವಿನ ಬೆಲೆ ಮೂರು ಶೆಕೆಲ್‌ಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ಅರವತ್ತು ಮತ್ತು ಅದಕ್ಕಿಂತ ಹೆಚ್ಚಿನ ವಯಸ್ಸಾದ ಪುರುಷನ ಬೆಲೆ ಹದಿನೈದು ಶೆಕೆಲ್‌ಗಳು. ಸ್ತ್ರೀಯ ಬೆಲೆ ಹತ್ತು ಶೆಕೆಲ್‌ಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“ಒಬ್ಬನು ಬೆಲೆಯನ್ನು ಕೊಡಲಾಗದಷ್ಟು ಬಡವನಾಗಿದ್ದರೆ, ಅವನನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತನ್ನಿರಿ. ಅವನು ಎಷ್ಟು ಹಣ ಕೊಡಲು ಶಕ್ತನಾಗಿದ್ದಾನೆಂದು ಯಾಜಕನು ತೀರ್ಮಾನಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ಒಬ್ಬನು ಪಶುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಯಜ್ಞಕ್ಕಾಗಿ ಪ್ರತಿಷ್ಠಿಸಬಹುದು. ಯಾವನಾದರೂ ಅಂಥ ಪಶುವನ್ನು ತಂದರೆ, ಅದು ಪವಿತ್ರವಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ಯಾಕೆಂದರೆ ಅದನ್ನು ಪ್ರತಿಷ್ಠಿಸಿದ ವ್ಯಕ್ತಿ ಅದನ್ನು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸುತ್ತೇನೆಂದು ಹರಕೆ ಮಾಡಿರುತ್ತಾನೆ. ಆದ್ದರಿಂದ ಅವನು ಅದರ ಬದಲು ಇನ್ನೊಂದು ಪಶುವನ್ನು ಕೊಡಲು ಪ್ರಯತ್ನಿಸಬಾರದು; ಅದನ್ನು ಬದಲಾಯಿಸಲು ಪ್ರಯತ್ನಿಸಬಾರದು. ಅವನು ಒಳ್ಳೆಯ ಪಶವಿನ ಬದಲಾಗಿ ಕೆಟ್ಟ ಪಶುವನ್ನು ಕೊಡಲು ಪ್ರಯತ್ನಿಸಬಾರದು. ಅವನು ಪಶುಗಳನ್ನು ಬದಲಾಯಿಸಲು ಪ್ರಯತ್ನಿಸಿದರೆ, ಆ ಎರಡು ಪಶುಗಳೂ ಪವಿತ್ರವಾಗುತ್ತವೆ. ಅವೆರಡೂ ಯೆಹೋವನದಾಗಿರುತ್ತವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಕೂಡದ ಕೆಲವು ಪ್ರಾಣಿಗಳಿರುವವು. ಒಬ್ಬನು ಅಂಥ ಅಶುದ್ಧ ಪಶುಗಳಲ್ಲೊಂದನ್ನು ಯೆಹೋವನಿಗಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ಅದನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ತರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ಯಾಜಕನು ಆ ಪಶುವಿಗೆ ಬೆಲೆಯನ್ನು ಗೊತ್ತುಮಾಡುವನು. ಪಶುವು ಒಳ್ಳೆಯದ್ದಾಗಿದ್ದರೂ ಕೆಟ್ಟದ್ದಾಗಿದ್ದರೂ ಯಾಜಕನು ನಿರ್ಣಯಿಸಿದ ಬೆಲೆಯೇ ಅದರ ಬೆಲೆಯಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ಹರಕೆ ಮಾಡಿದವನು ಪಶುವನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಬೇಕೆಂದಿದ್ದರೆ, ಅದರ ಬೆಲೆಯೊಡನೆ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ಒಬ್ಬನು ತನ್ನ ಮನೆಯನ್ನು ಯೆಹೋವನಿಗೆ ಮೀಸಲಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ಯಾಜಕನು ಅದಕ್ಕೆ ಬೆಲೆಯನ್ನು ನಿರ್ಣಯಿಸುವನು. ಮನೆಯು ಒಳ್ಳೆಯದ್ದಾಗಿದ್ದರೂ ಕೆಟ್ಟದ್ದಾಗಿದ್ದರೂ ಯಾಜಕನು ನಿರ್ಣಯಿಸಿದ ಬೆಲೆಯೇ ಅದರ ಬೆಲೆಯಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ಆದರೆ ಹರಕೆ ಮಾಡಿದವನು ಮನೆಯನ್ನು ಹಿಂದಕ್ಕೆ ಪಡೆಯಲು ಬಯಸಿದರೆ, ಆಗ ಅವನು ಅದರ ಬೆಲೆಯೊಡನೆ ಐದನೆಯ ಒಂದು ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಡಬೇಕು. ಆಗ ಅದು ಅವನದಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ಒಬ್ಬನು ತನ್ನ ಹೊಲಗಳಲ್ಲಿ ಒಂದು ಭಾಗವನ್ನು ಯೆಹೋವನಿಗಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ಅದರಲ್ಲಿ ಬಿತ್ತುವುದಕ್ಕೆ ಬೇಕಾಗಿರುವ ಬೀಜಗಳನ್ನು ಆಧಾರ ಮಾಡಿಕೊಂಡು ಬೆಲೆಯನ್ನು ನಿಗದಿ ಮಾಡಬೇಕು. ಪ್ರತಿಯೊಂದು ಹೋಮೆರ್ (ಎರಡು ಖಂಡುಗ) ಜವೆಗೋಧಿಯನ್ನು ಉತ್ಪಾದಿಸುವ ಹೊಲವು ಐವತ್ತು ಶೆಕೆಲ್ ಬೆಲೆಬಾಳುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ಒಬ್ಬನು ಜ್ಯೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ತನ್ನ ಹೊಲವನ್ನು ಕೊಟ್ಟರೆ, ಆಗ ಅದರ ಬೆಲೆಯು ಯಾಜಕನು ತೀರ್ಮಾನಿಸಿದಷ್ಟು ಇರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ಆದರೆ ಒಬ್ಬನು ಜ್ಯೂಬಿಲಿಯ ನಂತರ ತನ್ನ ಹೊಲವನ್ನು ಕೊಟ್ಟರೆ, ಯಾಜಕನು ಅದರ ಸರಿಯಾದ ಬೆಲೆಯನ್ನು ಲೆಕ್ಕಹಾಕಬೇಕು. ಅವನು ಮುಂದಿನ ಜ್ಯೂಬಿಲಿ ಸಂವತ್ಸರಕ್ಕೆ ಇರುವ ವರ್ಷಗಳನ್ನು ಲೆಕ್ಕಹಾಕಿ ಅದರಿಂದ ಬೆಲೆಯನ್ನು ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ಹೊಲವನ್ನು ಕೊಟ್ಟವನು ಅದನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಬೇಕೆಂದು ಬಯಸುವುದಾದರೆ, ಅವನು ಅದರ ಬೆಲೆಗೆ ಐದನೆಯ ಒಂದಂಶವನ್ನು ಸೇರಿಸಿ ಕೊಡಬೇಕು. ಆಗ ಹೊಲವು ತಿರುಗಿ ಅವನದಾಗುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ಅವನು ಹೊಲವನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳದಿದ್ದರೆ ಅದು ಯಾವಾಗಲೂ ಯಾಜಕರುಗಳಿಗೆ ಸೇರಿದ್ದಾಗಿರುತ್ತದೆ. ಭೂಮಿಯು ಮತ್ತೊಬ್ಬನಿಗೆ ಮಾರಲ್ಪಟ್ಟಿದ್ದರೆ, ಮೊದಲನೆಯ ವ್ಯಕ್ತಿಯು ಅದನ್ನು ಮತ್ತೆ ಕೊಂಡುಕೊಳ್ಳಲು ಸಾಧ್ಯವಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ಅವನು ಭೂಮಿಯನ್ನು ಹಿಂದಕ್ಕೆ ಕೊಂಡುಕೊಳ್ಳದಿದ್ದರೆ, ಅದು ಜ್ಯೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಮೀಸಲಾದದ್ದಾಗಿರುವುದು. ಅದು ಎಂದೆಂದಿಗೂ ಯಾಜಕನದ್ದಾಗಿರುವುದು. ಅದು ಪೂರ್ಣವಾಗಿ ಯೆಹೋವನಿಗೆ ಪ್ರತಿಷ್ಠಿಸಿದ ಭೂಮಿಯಂತೆ ಇರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ಒಬ್ಬನು ತಾನು ಕೊಂಡುಕೊಂಡ ಹೊಲವನ್ನು ಅಂದರೆ ಪಿತ್ರಾರ್ಜಿತ ಭೂಮಿಗೆ ಸೇರದಿರುವ ಹೊಲವನ್ನು ಯೆಹೋವನಿಗೆ ಪ್ರತಿಷ್ಠಿಸಿದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ಯಾಜಕನು ಮುಂದಿನ ಜ್ಯೂಬಿಲಿ ಸಂವತ್ಸರದವರೆಗೆ ಇರುವ ವರ್ಷಗಳನ್ನು ಲೆಕ್ಕ ಹಾಕಿ ಅದರ ಬೆಲೆಯನ್ನು ನಿಗದಿ ಮಾಡಬೇಕು. ಆಗ ಭೂಮಿಯು ಯೆಹೋವನದಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ಜ್ಯೂಬಿಲಿ ಸಂವತ್ಸರದಲ್ಲಿ, ಆ ಭೂಮಿಯು ಅದರ ಮೊದಲ ಯಜಮಾನನಿಗೆ ಅಂದರೆ ಯಾವ ಕುಟುಂಬವು ಆ ಭೂಮಿಯನ್ನು ಮೊದಲು ಹೊಂದಿತ್ತೋ ಆ ಕುಟುಂಬಕ್ಕೆ ಸೇರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“ನೀವು ಅಧಿಕೃತ ಅಳತೆಯನ್ನು ಉಪಯೋಗಿಸಿ ಆ ಬೆಲೆಗಳನ್ನು ಕೊಡಬೇಕು. ಒಂದು ಶೆಕೆಲ್‌ನ ಬೆಲೆಯನ್ನು ಇಪ್ಪತ್ತು ಗೇರಾ ತೂಕದ ಪ್ರಕಾರ ನೀವು ಯಾವಾಗಲೂ ನಿರ್ಣಯಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ಜನರು ಯೆಹೋವನಿಗೆ ವಿಶೇಷ ಕಾಣಿಕೆಯಾಗಿ ದನಗಳನ್ನು ಮತ್ತು ಕುರಿಗಳನ್ನು ಕೊಡಬಹುದು. ಆದರೆ ಪಶುವು ಚೊಚ್ಚಲಾದದ್ದಾಗಿದ್ದರೆ, ಅದು ಈಗಾಗಲೇ ಯೆಹೋವನದ್ದಾಗಿರುತ್ತದೆ. ಆದ್ದರಿಂದ ಜನರು ಅಂಥ ಪಶುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ವಿಶೇಷ ಕಾಣಿಕೆಯಾಗಿ ಕೊಡಲಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ಜನರು ಚೊಚ್ಚಲಾದ ಪಶುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಡಬೇಕು. ಆದರೆ ಚೊಚ್ಚಲಾದ ಪಶುವು ಅಶುದ್ಧವಾದ ಪಶುವಾಗಿದ್ದರೆ, ಆಗ ಹರಕೆ ಮಾಡಿದವನು ಅದನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಬೇಕು. ಯಾಜಕನು ಅದರ ಬೆಲೆಯನ್ನು ನಿರ್ಣಯಿಸುವನು ಮತ್ತು ಹರಕೆ ಮಾಡಿದವನು ಆ ಬೆಲೆಗೆ ಐದನೆಯ ಒಂದಂಶವನ್ನು ಸೇರಿಸಬೇಕು. ಅವನು ಅದನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳದಿದ್ದರೆ, ಆಗ ಯಾಜಕನು ತಾನು ನಿರ್ಣಯಿಸಿದ ಬೆಲೆಗೆ ಆ ಪಶುವನ್ನು ಮಾರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ಜನರು ಯೆಹೋವನಿಗೆ ಸಲ್ಲಿಸುವ ವಿಶೇಷ ಬಗೆಯ ಕಾಣಿಕೆಯು ಯೆಹೋವನಿಗೆ ಮಾತ್ರ ಸೇರಿದ್ದಾಗಿರುತ್ತದೆ. ಅದನ್ನು ಬಿಡಿಸಿಕೊಳ್ಳುವುದಕ್ಕಾಗಲಿ ಮಾರುವುದಕ್ಕಾಗಲಿ ಆಗುವುದಿಲ್ಲ. ಅದು ಯೆಹೋವನದ್ದಾಗಿರುತ್ತದೆ. ಈ ಕಾಣಿಕೆಗಳು ಜನರನ್ನು, ಪಶುಗಳನ್ನು ಮತ್ತು ಪಿತ್ರಾರ್ಜಿತ ಸ್ವತ್ತುಗಳನ್ನು ಒಳಗೊಂಡಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ಆ ವಿಶೇಷ ಬಗೆಯ ಕಾಣಿಕೆಯು ಒಬ್ಬ ವ್ಯಕ್ತಿಯಾಗಿದ್ದರೆ ಅವನನ್ನು ಮತ್ತೆ ಕೊಂಡುಕೊಳ್ಳಲು ಸಾಧ್ಯವಿಲ್ಲ. ಆ ವ್ಯಕ್ತಿಯು ಕೊಲ್ಲಲ್ಪಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ಎಲ್ಲಾ ಬೆಳೆಗಳಲ್ಲಿ ಹತ್ತರಲ್ಲಿ ಒಂದಂಶವು ಯೆಹೋವನದ್ದಾಗಿರುತ್ತದೆ. ಹೊಲಗಳ ಬೆಳೆಗಳಾಗಲಿ ಮರಗಳ ಫಲಗಳಾಗಲಿ ಅದರಲ್ಲಿ ಹತ್ತರಲ್ಲಿ ಒಂದಂಶ ಯೆಹೋವನದ್ದಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ಆದ್ದರಿಂದ ಒಬ್ಬನು ತಾನು ಕೊಡಬೇಕಾದ ಹತ್ತನೆಯ ಪಾಲಿನಲ್ಲಿ ಏನಾದರೂ ಮರಳಿ ಪಡೆದುಕೊಳ್ಳಬೇಕೆಂದಿದ್ದರೆ, ಅವನು ಅದರ ಬೆಲೆಗೆ ಐದನೆಯ ಒಂದಂಶವನ್ನು ಸೇರಿಸಿಕೊಟ್ಟು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“ದನಗಳಲ್ಲಾಗಲಿ ಕುರಿಗಳಲ್ಲಾಗಲಿ ಪ್ರತಿ ಹತ್ತನೆಯ ಪಾಲನ್ನು ಯಾಜಕರು ತೆಗೆದುಕೊಳ್ಳುವರು. ಪ್ರತಿ ಹತ್ತನೆ ಪಶು ಯೆಹೋವನದಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ಆರಿಸಲ್ಪಟ್ಟ ಪಶುವು ಒಳ್ಳೆಯದೋ ಕೆಟ್ಟದ್ದೋ ಎಂದು ಅದರ ಮಾಲಿಕನು ಚಿಂತೆ ಮಾಡಬಾರದು. ಅವನು ಅದನ್ನು ಬದಲಾಯಿಸಬಾರದು. ಅವನು ಅದನ್ನು ಬದಲಾಯಿಸಲು ತೀರ್ಮಾನಿಸಿದರೆ, ಆಗ ಎರಡೂ ಪಶುಗಳು ಯೆಹೋವನದಾಗುತ್ತವೆ. ಆ ಪಶುವನ್ನು ಮರಳಿ ಕೊಂಡುಕೊಳ್ಳಲಾಗದು.” ");
INSERT INTO kan2010_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ಯೆಹೋವನು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯ ಮೂಲಕ ಇಸ್ರೇಲರಿಗೆ ಕೊಟ್ಟ ಆಜ್ಞೆಗಳು ಇವೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ಯೆಹೋವನು ದೇವದರ್ಶನಗುಡಾರದೊಳಗೆ ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿದನು. ಆಗ ದೇವದರ್ಶನಗುಡಾರವು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿತ್ತು. ಇಸ್ರೇಲರು ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟ ಎರಡನೆಯ ವರ್ಷದ ಎರಡನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಇದು ನಡೆಯಿತು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ಇಸ್ರೇಲ್ ಜನರೆಲ್ಲರನ್ನು ಅವರವರ ಗೋತ್ರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಿ ಪ್ರತಿಯೊಬ್ಬನ ಹೆಸರನ್ನೂ ಪಟ್ಟಿಮಾಡಿ, ");
INSERT INTO kan2010_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ನೀನೂ ಆರೋನನೂ ಇಸ್ರೇಲರಲ್ಲಿ ಎಲ್ಲಾ ಪುರುಷರನ್ನು ಲೆಕ್ಕಿಸಬೇಕು. ಇಸ್ರೇಲ್ ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ವಯಸ್ಸುಳ್ಳ ಪುರುಷರನ್ನು ಲೆಕ್ಕಿಸು. ಅವರನ್ನು ಅವರವರ ವಿಭಾಗಗಳಿಗೆ ಅನುಸಾರವಾಗಿ ಪಟ್ಟಿಮಾಡು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ಪ್ರತಿಯೊಂದು ಕುಲದ ಕುಟುಂಬದ ನಾಯಕನು ನಿಮಗೆ ಸಹಾಯಮಾಡಬೇಕು ");
INSERT INTO kan2010_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ನಿಮ್ಮೊಡನಿದ್ದು ನಿಮಗೆ ಸಹಾಯಮಾಡುವ ಪುರುಷರು ಯಾರೆಂದರೆ: ರೂಬೇನ್ ಕುಲದಿಂದ ಶೆದೇಯೂರನ ಮಗನಾದ ಎಲೀಚೂರ್. ");
INSERT INTO kan2010_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ಸಿಮೆಯೋನ್ ಕುಲದಿಂದ ಚೂರೀಷದ್ದೈಯ ಮಗನಾದ ಶೆಲುಮೀಯೇಲ್; ");
INSERT INTO kan2010_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ಯೆಹೂದ ಕುಲದಿಂದ ಅಮ್ಮೀನಾದ್ವಾನ ಮಗನಾದ ನಹಶೋನ್; ");
INSERT INTO kan2010_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ಇಸ್ಸಾಕಾರ್ ಕುಲದಿಂದ ಚೂವಾರನ ಮಗನಾದ ನೆತನೇಲ್; ");
INSERT INTO kan2010_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ಜೆಬುಲೂನ್ ಕುಲದಿಂದ ಹೇಲೋನನ ಮಗನಾದ ಎಲೀಯಾಬ್; ");
INSERT INTO kan2010_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ಯೋಸೇಫನ ಸಂತಾನದಿಂದ: ಎಫ್ರಾಯೀಮ್ ಕುಲದಿಂದ ಅಮ್ಮೀಹೂದನ ಮಗನಾದ ಎಲೀಷಾಮಾ; ಮನಸ್ಸೆ ಕುಲದಿಂದ ಪೆದಾಚೂರನ ಮಗನಾದ ಗಮ್ಲೀಯೇಲ್; ");
INSERT INTO kan2010_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ಬೆನ್ಯಾಮೀನ್ ಕುಲದಿಂದ ಗಿದ್ಯೋನಿಯ ಮಗನಾದ ಅಬೀದಾನ್; ");
INSERT INTO kan2010_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ದಾನ್ ಕುಲದಿಂದ ಅಮ್ಮಾಷದ್ದೈಯ ಮಗನಾದ ಅಹೀಗೆಜೆರ್; ");
INSERT INTO kan2010_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ಆಶೇರ್ ಕುಲದಿಂದ ಒಕ್ರಾನನ ಮಗನಾದ ಪಗೀಯೇಲ್; ");
INSERT INTO kan2010_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ಗಾದ್ ಕುಲದಿಂದ ರೆಗೂವೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫ್; ");
INSERT INTO kan2010_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ನಫ್ತಾಲಿ ಕುಲದಿಂದ ಏನಾನನ ಮಗನಾದ ಅಹೀರ.” ");
INSERT INTO kan2010_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ಸರ್ವಸಮೂಹದವರೊಳಗಿಂದ ಆರಿಸಲ್ಪಟ್ಟಿದ್ದ ಇವರು ತಮ್ಮ ಪೂರ್ವಿಕರ ಕುಲಗಳಿಗೆ ನಾಯಕರು ಮತ್ತು ಇಸ್ರೇಲರಿಗೆ ಸಹಸ್ರಾಧಿಪತಿಗಳಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ಹೆಸರೆಸರಾಗಿ ಆರಿಸಲ್ಪಟ್ಟ ಈ ಜನರನ್ನು ಮೋಶೆ ಆರೋನರು ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ಎರಡನೆ ತಿಂಗಳಿನ ಮೊದಲನೆ ದಿನದಲ್ಲಿ ಎಲ್ಲಾ ಜನರು ಒಟ್ಟಾಗಿ ಸೇರಿಬಂದರು. ಜನರು ತಮ್ಮತಮ್ಮ ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ, ಗೋತ್ರಗಳಿಗನುಸಾರವಾಗಿ ಪಟ್ಟಿ ಮಾಡಿಸಿದರು. ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಹೆಚ್ಚು ವಯಸ್ಸಾದ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರವೇ ಮೋಶೆಯು ಮಾಡಿದನು. ಜನರು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿದ್ದಾಗ ಮೋಶೆಯು ಅವರನ್ನು ಲೆಕ್ಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ಅವರು ಇಸ್ರೇಲನ ಚೊಚ್ಚಲ ಮಗನಾದ ರೂಬೇನ್ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಹೆಚ್ಚು ವಯಸ್ಸಾದ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿ ಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ ಮತ್ತು ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ರೂಬೇನ್ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 46,500. ");
INSERT INTO kan2010_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ಅವರು ಸಿಮೆಯೋನ್ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ ಮತ್ತು ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ಸಿಮೆಯೋನ್ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 59,300. ");
INSERT INTO kan2010_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ಗಾದ್ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ ಮತ್ತು ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ಗಾದ್ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 45,650. ");
INSERT INTO kan2010_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ಯೆಹೂದನ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿಯೂ ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿಯೂ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ಯೆಹೂದನ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 74,600. ");
INSERT INTO kan2010_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ಇಸ್ಸಾಕಾರ್ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ, ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ಇಸ್ಸಾಕಾರ್ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 54,400. ");
INSERT INTO kan2010_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ಜೆಬುಲೂನ್ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ, ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ಜೆಬುಲೂನ್ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 57,400. ");
INSERT INTO kan2010_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ಯೋಸೇಫನ ಮಗನಾದ ಎಫ್ರಾಯೀಮ್ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ, ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ಎಫ್ರಾಯೀಮ್ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 40,500. ");
INSERT INTO kan2010_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","ಯೋಸೇಫನ ಮಗನಾದ ಮನಸ್ಸೆಯ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ, ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ಮನಸ್ಸೆ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 32,200. ");
INSERT INTO kan2010_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ಬೆನ್ಯಾಮೀನ್ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ, ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ಬೆನ್ಯಾಮೀನನ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 35,400. ");
INSERT INTO kan2010_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ದಾನ್ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ, ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ದಾನನ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 62,700. ");
INSERT INTO kan2010_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ಆಶೇರ್ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ, ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ಆಶೇರ್ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 41,500. ");
INSERT INTO kan2010_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ನಫ್ತಾಲಿ ಕುಲದವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಎಲ್ಲಾ ಪುರುಷರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ಅವರವರ ಕುಲಗಳಿಗನುಸಾರವಾಗಿ, ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಅವರ ಹೆಸರುಗಳನ್ನು ಪಟ್ಟಿಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ನಫ್ತಾಲಿಯ ಕುಲದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 53,400. ");
INSERT INTO kan2010_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ಮೋಶೆ, ಆರೋನ ಮತ್ತು ಇಸ್ರೇಲರ ಹನ್ನೆರಡು ಮಂದಿ ನಾಯಕರು ಈ ಜನರನ್ನು ಲೆಕ್ಕಿಸಿದರು. (ಪ್ರತಿಯೊಬ್ಬ ನಾಯಕನು ತನ್ನ ಕುಲದ ಪ್ರತಿನಿಧಿಯಾಗಿದ್ದನು.) ");
INSERT INTO kan2010_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ಅವರು ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾದ ಇಪ್ಪತ್ತು ವರ್ಷ ಮತ್ತು ಅದಕ್ಕಿಂತ ಮೇಲ್ಪಟ್ಟ ಪ್ರತಿ ಪುರುಷನನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಪ್ರತಿಯೊಬ್ಬನೂ ಅವನ ಕುಟುಂಬದೊಡನೆ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 6,03,550. ");
INSERT INTO kan2010_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ಆದರೆ ಲೇವಿ ಕುಲದ ಕುಟುಂಬಗಳು ಇತರ ಇಸ್ರೇಲರೊಡನೆ ಲೆಕ್ಕಿಸಲ್ಪಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ಯಾಕೆಂದರೆ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ಲೇವಿ ಕುಲದ ಪುರುಷರನ್ನು ಲೆಕ್ಕಿಸಬೇಡ. ಅವರನ್ನು ಉಳಿದ ಇಸ್ರೇಲರ ಜನಗಣತಿಯೊಡನೆ ಸೇರಿಸಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ಒಡಂಬಡಿಕೆಯ ಪವಿತ್ರ ಗುಡಾರವನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಜವಾಬ್ದಾರಿಯು ಲೇವಿಯರಿಗೆ ಸೇರಿರುವುದರಿಂದ ಅವರಿಗೆ ಅದನ್ನು ತಿಳಿಸು. ಅವರು ಅದನ್ನೂ ಅದರ ಉಪಕರಣಗಳನ್ನೂ ಮತ್ತು ಅದಕ್ಕೆ ಸಂಬಂಧಿಸಿದ ಪ್ರತಿಯೊಂದನ್ನೂ ನೋಡಿಕೊಳ್ಳಬೇಕು. ಅವರು ಪವಿತ್ರ ಗುಡಾರವನ್ನೂ ಅದರಲ್ಲಿರುವ ಪ್ರತಿಯೊಂದನ್ನೂ ಹೊತ್ತುಕೊಂಡು ಹೋಗಬೇಕು. ಅವರು ಅದರ ಸುತ್ತಲೂ ಪಾಳೆಯಮಾಡಿಕೊಂಡು ಅದನ್ನು ನೋಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ಪವಿತ್ರ ಗುಡಾರವನ್ನು ತೆಗೆದುಕೊಂಡು ಹೋಗುವಾಗಲೆಲ್ಲಾ ಲೇವಿಯರೇ ಅದನ್ನು ಬಿಚ್ಚಬೇಕು, ಇಳಿಸುವಾಗಲೆಲ್ಲಾ ಲೇವಿಯರೇ ಅದನ್ನು ಹಾಕಬೇಕು. ಪವಿತ್ರ ಗುಡಾರವನ್ನು ನೋಡಿಕೊಳ್ಳುವವರು ಅವರೇ. ಲೇವಿ ಕುಲಕ್ಕೆ ಸೇರದ ಯಾವನಾದರೂ ಅದರ ಸಮೀಪಕ್ಕೆ ಬಂದರೆ, ಅವನಿಗೆ ಮರಣಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ಇಸ್ರೇಲರ ಆಯಾ ದಂಡುಗಳು ತಮ್ಮತಮ್ಮ ಕುಲದ ಧ್ವಜ ಇರುವಲ್ಲಿಯೇ ಪಾಳೆಯ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ಆದರೆ ಲೇವಿಯರು ಮಾತ್ರ ಪವಿತ್ರ ಗುಡಾರದ ಸುತ್ತಲೂ ತಮ್ಮ ಪಾಳೆಯ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ಹೀಗೆ ಲೇವಿಯರು ಒಡಂಬಡಿಕೆಯ ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಕಾಯುವರು; ಇಸ್ರೇಲರಿಗೆ ಯಾವ ಕೇಡೂ ಸಂಭವಿಸದಂತೆ ಅವರು ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಸಂರಕ್ಷಿಸುವರು.” ");
INSERT INTO kan2010_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ಹೀಗೆ ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದ ಪ್ರತಿಯೊಂದನ್ನು ಇಸ್ರೇಲರು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ಇಸ್ರೇಲರು ದೇವದರ್ಶನಗುಡಾರದ ಸುತ್ತಲೂ ಸ್ವಲ್ಪ ದೂರದಲ್ಲಿ ತಮ್ಮ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಳ್ಳಬೇಕು. ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನತನ್ನ ಗೋತ್ರಧ್ವಜದ ಹತ್ತಿರ ತನ್ನತನ್ನ ದಂಡಿನಲ್ಲೇ ಇಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“ವಿಭಾಗಗಳಿಗನುಸಾರವಾಗಿ ತಮ್ಮತಮ್ಮ ಸ್ವಂತ ಧ್ವಜಗಳೊಡನೆ ಮುನ್ನಡೆಯುವ ಯೆಹೂದ ಮತ್ತು ಅದರ ಗೋತ್ರಗಳವರು ದೇವದರ್ಶನಗುಡಾರದ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ಯೆಹೂದ ಕುಲದವರ ನಾಯಕನು ಅಮ್ಮೀನಾದ್ವಾನ ಮಗನಾದ ನಹಶೋನ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ಅವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 74,600 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“ಇಸ್ಸಾಕಾರ್ ಕುಲದವರು ಯೆಹೂದ ಕುಲದವರ ನಂತರ ಪಾಳೆಯ ಹಾಕುವರು. ಇಸ್ಸಾಕಾರನ ಕುಲದವರ ನಾಯಕನು ಚೂವಾರನ ಮಗನಾದ ನೆತನೇಲ್. ");
INSERT INTO kan2010_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ಅವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 54,400 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“ಜೆಬುಲೂನ್ ಕುಲದವರು ಸಹ ಯೆಹೂದ ಕುಲದವರ ನಂತರ ಪಾಳೆಯ ಹಾಕುವರು. ಜೆಬುಲೂನ್ ಕುಲದ ನಾಯಕನು ಹೇಲೋನನ ಮಗನಾದ ಎಲೀಯಾಬ್. ");
INSERT INTO kan2010_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ಅವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 57,400 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“ಯೆಹೂದ ಪಾಳೆಯದಲ್ಲಿ ಮತ್ತು ಅದರೊಡನೆ ಮುನ್ನಡೆಯುವ ಗೋತ್ರಗಳವರ ಒಟ್ಟು ಸೈನಿಕರು 1,86,400 ಮಂದಿ. ಇವರೆಲ್ಲರು ವಿಭಾಗಗಳಿಗನುಸಾರವಾಗಿ ತಮ್ಮ ಹೆಸರುಗಳನ್ನು ನೊಂದಾಯಿಸಿಕೊಂಡವರು. ಇಸ್ರೇಲರು ಒಂದು ಸ್ಥಳದಿಂದ ಇನ್ನೊಂದು ಸ್ಥಳಕ್ಕೆ ಪ್ರಯಾಣ ಮಾಡುವಾಗ, ಯೆಹೂದ ಕುಲವು ಮತ್ತು ಅದರೊಂದಿಗಿರುವ ಎರಡು ಕುಲಗಳವರು ಮೊದಲು ಹೊರಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“ರೂಬೇನ್ ಕುಲ ಮತ್ತು ಅದರೊಡನೆ ಮುನ್ನಡೆಯುವ ಕುಲಗಳು ದೇವದರ್ಶನಗುಡಾರದ ದಕ್ಷಿಣದಿಕ್ಕಿನಲ್ಲಿ ತಮ್ಮ ಧ್ವಜಗಳೊಡನೆ ವಿಭಾಗಗಳಿನುಸಾರವಾಗಿ ಪಾಳೆಯಮಾಡಿಕೊಳ್ಳಬೇಕು. ರೂಬೇನ್ ಕುಲದವರ ನಾಯಕನು ಶೆದೇಯೂರನ ಮಗನಾದ ಎಲೀಚೂರನು; ");
INSERT INTO kan2010_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 46,500 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“ರೂಬೇನ್ ಕುಲದವರ ಪಕ್ಕದಲ್ಲಿ ಸಿಮೆಯೋನ್ ಕುಲದವರು ಪಾಳೆಯ ಹಾಕುವರು. ಸಿಮೆಯೋನ್ ಕುಲದವರ ನಾಯಕನು ಚೂರೀಷದ್ದೈನ ಮಗನಾದ ಶೆಲುಮೀಯೇಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 59,300 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“ಗಾದ್ ಕುಲವು ಸಹ ರೂಬೇನ್ ಕುಲದ ಪಕ್ಕದಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಳ್ಳಬೇಕು. ಗಾದನ ಕುಲದವರ ನಾಯಕನು ರೆಗೂವೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫ್. ");
INSERT INTO kan2010_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 45,650 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“ರೂಬೇನ್ ಪಾಳೆಯದಲ್ಲಿರುವ ಎಲ್ಲಾ ತಂಡಗಳಲ್ಲಿರುವ ಒಟ್ಟು ಸೈನಿಕರು 1,51,450 ಮಂದಿ. ಇವರೆಲ್ಲರೂ ವಿಭಾಗಗಳಿಗನುಸಾರವಾಗಿ ಹೆಸರನ್ನು ನೊಂದಾಯಿಸಿಕೊಂಡವರು. ಇಸ್ರೇಲರು ಒಂದು ಸ್ಥಳದಿಂದ ಇನ್ನೊಂದು ಸ್ಥಳಕ್ಕೆ ಪ್ರಯಾಣ ಮಾಡುವಾಗ ರೂಬೇನ್ ಕುಲವು ಮತ್ತು ಅದರ ನಂತರದಲ್ಲಿರುವ ಎರಡು ಕುಲಗಳವರು ಎರಡನೆಯದಾಗಿ ಹೊರಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“ಇಸ್ರೇಲರು ಪ್ರಯಾಣಮಾಡುವಾಗ ಅವರ ನಂತರ ಹೊರಡುವ ತಂಡದವರೇ ಲೇವಿ ಕುಲದವರು. ಇತರ ಪಾಳೆಯಗಳ ಮಧ್ಯೆ ದೇವದರ್ಶನಗುಡಾರವು ಅವರೊಡನೆ ಇರುವುದು. ಅವರು ತಾವು ಪಾಳೆಯ ಮಾಡಿಕೊಂಡ ಕ್ರಮಾನುಸಾರವಾಗಿ ತಮ್ಮ ಧ್ವಜಗಳೊಡನೆ ಮುನ್ನಡೆಯುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“ಎಫ್ರಾಯೀಮ್ ಕುಲದವರು ಮತ್ತು ಅವರೊಡನೆ ಮುನ್ನಡೆಯುವ ಕುಲಗಳವರು ದೇವದರ್ಶನಗುಡಾರದ ಪಶ್ಚಿಮ ದಿಕ್ಕಿನಲ್ಲಿ ತಮ್ಮ ಧ್ವಜಗಳೊಡನೆ ವಿಭಾಗಗಳಿಗನುಸಾರವಾಗಿ ಪಾಳೆಯ ಮಾಡಬೇಕು. ಎಫ್ರಾಯೀಮ್ ಕುಲದವರ ನಾಯಕನು ಅಮ್ಮೀಹೂದನ ಮಗನಾದ ಎಲೀಷಾಮ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 40,500 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“ಮನಸ್ಸೆ ಕುಲದವರು ಎಫ್ರಾಯೀಮ್ ಕುಲದವರ ಪಕ್ಕದಲ್ಲಿ ಪಾಳೆಯ ಹಾಕುವರು. ಮನಸ್ಸೆ ಕುಲದವರ ನಾಯಕನು ಪೆದಾಚೂರನ ಮಗನಾದ ಗಮ್ಲೀಯೇಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 32,200 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“ಬೆನ್ಯಾಮೀನ್ ಕುಲವು ಸಹ ಎಫ್ರಾಯೀಮ್ ಕುಲದ ಪಕ್ಕದಲ್ಲಿ ಪಾಳೆಯ ಹಾಕುವರು. ಬೆನ್ಯಾಮೀನ್ ಕುಲದವರ ನಾಯಕನು ಗಿದ್ಯೋನನ ಮಗನಾದ ಅಬೀದಾನನು. ");
INSERT INTO kan2010_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 35,400 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“ಎಫ್ರಾಯೀಮ್ ಪಾಳೆಯದಲ್ಲಿರುವ ಸೈನಿಕರು 1,08,100 ಮಂದಿ. ಇವರೆಲ್ಲರು ತಮ್ಮ ವಿಭಾಗಗಳಿಗನುಸಾರವಾಗಿ ಹೆಸರನ್ನು ನೊಂದಾಯಿಸಿಕೊಂಡವರು. ಜನರು ಒಂದು ಸ್ಥಳದಿಂದ ಇನ್ನೊಂದು ಸ್ಥಳಕ್ಕೆ ಪ್ರಯಾಣ ಮಾಡುವಾಗ ಎಫ್ರಾಯೀಮರ ಕುಲದವರು ಮತ್ತು ಅವರ ನಂತರದಲ್ಲಿರುವ ಎರಡು ಕುಲಗಳವರು ಮೂರನೆಯ ಗುಂಪಾಗಿ ಹೊರಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“ದಾನ್ ಕುಲದವರು ಮತ್ತು ಅವರೊಡನೆ ಮುನ್ನಡೆಯುವ ಕುಲಗಳು ದೇವದರ್ಶನಗುಡಾರದ ಉತ್ತರ ದಿಕ್ಕಿನಲ್ಲಿ ತಮ್ಮ ಧ್ವಜದೊಡನೆ ವಿಭಾಗಗಳಿಗನುಸಾರವಾಗಿ ಪಾಳೆಯ ಮಾಡಬೇಕು. ದಾನ್ ಕುಲದ ನಾಯಕನು ಅಮ್ಮೀಷದ್ದೈಯನ ಮಗನಾದ ಅಹೀಗೆಜೆರ್. ");
INSERT INTO kan2010_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 62,700 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“ಆಶೇರ್ ಕುಲದವರು ದಾನ್ ಕುಲದ ಪಕ್ಕದಲ್ಲಿ ಪಾಳೆಯ ಹಾಕಬೇಕು. ಆಶೇರ್ ಕುಲದವರ ನಾಯಕನು ಒಕ್ರಾನನ ಮಗನಾದ ಪಗೀಯೇಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 41,500 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“ನಫ್ತಾಲಿ ಕುಲದವರು ಸಹ ದಾನ್ ಕುಲದ ಪಕ್ಕದಲ್ಲಿ ಪಾಳೆಯ ಹಾಕಬೇಕು. ನಫ್ತಾಲಿ ಕುಲದವರ ನಾಯಕನು ಏನಾನನ ಮಗನಾದ ಅಹೀರ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ಇವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 53,400 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“ದಾನ್ ಕುಲದ ಪಾಳೆಯದಲ್ಲಿರುವ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಸೈನಿಕರು 1,57,600 ಮಂದಿ. ಇಸ್ರೇಲರು ಸ್ಥಳದಿಂದ ಸ್ಥಳಕ್ಕೆ ಪ್ರಯಾಣಮಾಡುವಾಗ ದಾನ್ ಕುಲದವರು ಮತ್ತು ಅವರೊಂದಿಗಿರುವ ಎರಡು ಕುಲಗಳವರು ಕೊನೆಯಲ್ಲಿ ತಮ್ಮ ಧ್ವಜಗಳೊಡನೆ ಮುನ್ನಡೆಯುವರು.” ");
INSERT INTO kan2010_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ತಮ್ಮ ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಹೆಸರನ್ನು ನೊಂದಾಯಿಸಿಕೊಂಡ ಇಸ್ರೇಲರು ಇವರೇ. ಅವರ ವಿಭಾಗಗಳಿಗನುಸಾರವಾಗಿ ಪಾಳೆಯದಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಇಸ್ರೇಲರ ಸೈನಿಕರ ಸಂಖ್ಯೆ 6,03,550 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ಯೆಹೋವನ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಮೋಶೆಯು ಲೇವಿಯರನ್ನು ಇತರ ಇಸ್ರೇಲರೊಂದಿಗೆ ಲೆಕ್ಕಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ಹೀಗೆ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ ಪ್ರತಿಯೊಂದನ್ನು ಇಸ್ರೇಲರು ಮಾಡಿದರು. ತಮ್ಮ ಕ್ರಮಕ್ಕನುಸಾರವಾಗಿ ಅವರು ಪಾಳೆಯ ಮಾಡಿಕೊಂಡರು. ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದರು; ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನ ಸ್ವಂತ ಕುಲದೊಡನೆಯೂ ಕುಟುಂಬದೊಡನೆಯೂ ಇದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ಯೆಹೋವನು ಸೀನಾಯಿ ಬೆಟ್ಟದಲ್ಲಿ ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿದ ಸಮಯದಲ್ಲಿದ್ದ ಆರೋನ ಮತ್ತು ಮೋಶೆಯ ವಂಶದವರು ಇವರೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ಆರೋನನಿಗೆ ನಾಲ್ಕು ಮಂದಿ ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ನಾದ್ವಾನು ಚೊಚ್ಚಲ ಮಗ. ಅನಂತರ ಹುಟ್ಟಿದವರು ಅಬೀಹೂ, ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಈತಾಮಾರ್. ");
INSERT INTO kan2010_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ಈ ಗಂಡುಮಕ್ಕಳು ಯಾಜಕರಾಗಿ ಸೇವೆಮಾಡಲು ಅಭಿಷೇಕಿಸಲ್ಪಟ್ಟವರಾಗಿದ್ದರು ಮತ್ತು ಪ್ರತಿಷ್ಠೀತರಾದವರಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ಆದರೆ ನಾದ್ವಾ್ ಮತ್ತು ಅಬೀಹೂ ಎಂಬಿಬ್ಬರು ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಧೂಪವನ್ನು ಸಮರ್ಪಿಸುವಾಗ ಯೆಹೋವನು ಅಪ್ಪಣೆ ಕೊಡದೆ ಇದ್ದ ಬೆಂಕಿಯನ್ನು ಉಪಯೋಗಿಸಿದರು. ಆದ್ದರಿಂದ ನಾದ್ವಾ್ ಮತ್ತು ಅಬೀಹೂ ಅಲ್ಲಿ ಸತ್ತರು. ಅವರಿಗೆ ಗಂಡುಮಕ್ಕಳಿಲ್ಲದ್ದರಿಂದ ಎಲ್ಲಾಜಾರನು ಮತ್ತು ಈತಾಮಾರನು ಅವರ ತಂದೆಯಾದ ಆರೋನನ ಕೈಕೆಳಗೆ ಯೆಹೋವನ ಸೇವೆ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ಲೇವಿ ಕುಲದವರನ್ನು ಯಾಜಕನಾದ ಆರೋನನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಾ. ಅವರು ಆರೋನನಿಗೆ ಸಹಾಯಕರಾಗಿರುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ಲೇವಿಯರು ಅವನಿಗಾಗಿ ಮತ್ತು ಇಡೀ ಸಮೂಹಕ್ಕಾಗಿ ದೇವದರ್ಶನಗುಡಾರದ ಮುಂದೆ ಕಾವಲುಗಾರರಾಗಿರುವರು ಮತ್ತು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಸಂಬಂಧಿಸಿದ ಭಾರವಾದ ಕೆಲಸಗಳನ್ನು ಮಾಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ದೇವದರ್ಶನಗುಡಾರವು ಚಲಿಸುತ್ತಿರುವಾಗ ಲೇವಿಯರು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಸಂಬಂಧಿಸಿದ ಭಾರವಾದ ಕೆಲಸಗಳನ್ನು ಮಾಡುವುದಲ್ಲದೆ, ದೇವದರ್ಶನ ಗುಡಾರದ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು ಇಸ್ರೇಲರಿಗೋಸ್ಕರ ಕಾಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“ಲೇವಿಯರನ್ನು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಒಪ್ಪಿಸಿಕೊಡು. ಅವರು ಇಸ್ರೇಲರ ಮಧ್ಯದಿಂದ ಆರೋನನಿಗೋಸ್ಕರವಾಗಿ ಪ್ರತಿಷ್ಠಿತರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“ಆರೋನನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಯಾಜಕರನ್ನಾಗಿ ನೇಮಿಸು. ಅವರು ತಮ್ಮತಮ್ಮ ಯಾಜಕ ಉದ್ಯೋಗವನ್ನು ಕಾಪಾಡಿಕೊಳ್ಳಬೇಕು. ಯಾಜಕರ ಕರ್ತವ್ಯಗಳನ್ನು ಮಾಡಲು ಪವಿತ್ರ ವಸ್ತುಗಳ ಬಳಿಗೆ ಬರಲು ಬೇರೆ ಯಾವನಾದರೂ ಪ್ರಯತ್ನಿಸಿದರೆ ಅವನು ಕೊಲ್ಲಲ್ಪಡಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ಇಸ್ರೇಲಿನ ಪ್ರತಿ ಕುಟುಂಬವು ತನ್ನ ಚೊಚ್ಚಲ ಮಗನನ್ನು ನನಗೆ ಕೊಡಬೇಕೆಂದು ನಿನಗೆ ಹೇಳಿದ್ದೆ. ಆದರೆ ನನ್ನ ಸೇವೆಮಾಡುವುದಕ್ಕೆ ಈಗ ನಾನು ಲೇವಿಯರನ್ನು ಆರಿಸಿಕೊಂಡಿದ್ದೇನೆ. ಅವರು ನನ್ನವರಾಗಿರುವರು. ಆದ್ದರಿಂದ ಬೇರೆ ಎಲ್ಲಾ ಇಸ್ರೇಲರು ತಮ್ಮ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನು ನನಗೆ ಕೊಡಬೇಕಾಗಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ನೀವು ಈಜಿಪ್ಟಿನಲ್ಲಿದ್ದಾಗ ನಾನು ಈಜಿಪ್ಟಿನವರ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಮಕ್ಕಳನ್ನು ಕೊಂದೆನು. ಆ ಕಾಲದಲ್ಲಿ ನಾನು ಇಸ್ರೇಲರ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಮಕ್ಕಳನ್ನು ನನ್ನವರನ್ನಾಗಿ ತೆಗೆದುಕೊಂಡೆನು. ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳು ಮತ್ತು ಚೊಚ್ಚಲು ಪಶುಗಳು ನನ್ನದಾಗಿದ್ದವು. ಆದರೆ ಈಗ ನಿಮ್ಮ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳನ್ನು ನಿಮಗೇ ಹಿಂದಕ್ಕೆ ಕೊಡುತ್ತಿದ್ದೇನೆ ಮತ್ತು ಲೇವಿಯರನ್ನು ನನ್ನವರನ್ನಾಗಿ ಮಾಡುತ್ತಿದ್ದೇನೆ. ನಾನೇ ಯೆಹೋವನು!” ");
INSERT INTO kan2010_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ಯೆಹೋವನು ತಿರುಗಿ ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿದನು. ಯೆಹೋವನು ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ಲೇವಿಯರನ್ನು ಅವರ ಕುಟುಂಬಗಳಿಗನುಗುಣವಾಗಿಯೂ ಗೋತ್ರಗಳಿಗನುಸಾರವಾಗಿಯೂ ಲೆಕ್ಕಿಸು. ಪ್ರತಿಯೊಬ್ಬ ಗಂಡಸನ್ನೂ ಒಂದು ತಿಂಗಳು ಮೇಲ್ಪಟ್ಟ ಪ್ರತಿಯೊಬ್ಬ ಗಂಡುಮಗುವನ್ನೂ ಲೆಕ್ಕಿಸು.” ");
INSERT INTO kan2010_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ಮೋಶೆ ಯೆಹೋವನಿಗೆ ವಿಧೇಯನಾಗಿ ಅವರೆಲ್ಲರನ್ನೂ ಲೆಕ್ಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ಲೇವಿಗೆ ಮೂರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ಅವರ ಹೆಸರುಗಳು: ಗೇರ್ಷೋನ್, ಕೆಹಾತ್ ಮತ್ತು ಮೆರಾರೀ. ");
INSERT INTO kan2010_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ಪ್ರತಿಯೊಬ್ಬ ಮಗನು ಅನೇಕ ಗೋತ್ರಗಳ ನಾಯಕನಾಗಿದ್ದನು. ಗೇರ್ಷೋನನ ಗೋತ್ರಗಳು: ಲಿಬ್ನೀ ಮತ್ತು ಶಿಮ್ಮೀ. ");
INSERT INTO kan2010_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ಕೆಹಾತನ ಗೋತ್ರಗಳು: ಅಮ್ರಾಮ್, ಇಚ್ಹಾರ್, ಹೆಬ್ರೋನ್ ಮತ್ತು ಉಜ್ಜೀಯೇಲ್. ");
INSERT INTO kan2010_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ಮೆರಾರೀಯ ಗೋತ್ರಗಳು: ಮಹ್ಲೀ ಮತ್ತು ಮೂಷೀ. ಅವು ಲೇವಿ ಕುಲದ ಗೋತ್ರಗಳಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ಲಿಬ್ನೀ ಮತ್ತು ಶಿಮ್ಮೀಯ ಕುಟುಂಬಗಳು ಗೇರ್ಷೋನನ ಕುಟುಂಬಕ್ಕೆ ಸೇರಿದವುಗಳಾಗಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ಈ ಎರಡು ಕುಲಗಳಲ್ಲಿ ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕಿಂತ ಹೆಚ್ಚು ವಯಸ್ಸಾದ 7,500 ಮಂದಿ ಗಂಡಸರು ಮತ್ತು ಗಂಡುಮಕ್ಕಳು ಇದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ಗೇರ್ಷೋನನ ಕುಲದವರು ಪಶ್ಚಿಮ ದಿಕ್ಕಿನಲ್ಲಿ ದೇವದರ್ಶನಗುಡಾರದ ಹಿಂಭಾಗದಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ಗೇರ್ಷೋನನ ಗೋತ್ರಗಳ ನಾಯಕನು ಲಾಯೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫ್. ");
INSERT INTO kan2010_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಪವಿತ್ರ ಗುಡಾರವನ್ನು, ಹೊರಡೇರೆಯನ್ನು ಮತ್ತು ಅದರ ಮೇಲ್ಹೊದಿಕೆಯನ್ನು ನೋಡಿಕೊಳ್ಳವುದು ಗೇರ್ಷೋನ ವಂಶದವರ ಕೆಲಸವಾಗಿತ್ತು. ಇದಲ್ಲದೆ ಅವರು ಅಂಗಳದ ಪರದೆಯನ್ನೂ ನೋಡಿಕೊಳ್ಳುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ಅವರು ಅಂಗಳದ ಪರದೆಗಳನ್ನೂ ಅಂಗಳದ ಪ್ರವೇಶದ್ವಾರದ ಪರದೆಯನ್ನೂ ನೋಡಿಕೊಳ್ಳಬೇಕು. ಈ ಅಂಗಳವು ಪವಿತ್ರ ಗುಡಾರದ ಮತ್ತು ವೇದಿಕೆಯ ಸುತ್ತಲೂ ಇತ್ತು. ಅವರು ಹಗ್ಗಗಳನ್ನೂ ಪರದೆಗಳೊಂದಿಗೆ ಉಪಯೋಗಿಸುವ ಪ್ರತಿಯೊಂದನ್ನೂ ನೋಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ಅಮ್ರಾಮ್, ಇಚ್ಹಾರ್, ಹೆಬ್ರೋನ್ ಮತ್ತು ಉಜ್ಜೀಯೇಲ್ ಗೋತ್ರಗಳವರು ಕೆಹಾತನ ಕುಲದವರಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ಈ ಕುಲದಲ್ಲಿ ಒಂದು ತಿಂಗಳು ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳ 8,300 ಗಂಡಸರು ಮತ್ತು ಗಂಡುಮಕ್ಕಳು ಇದ್ದರು. ಕೆಹಾತ್ಯರಿಗೆ ಪವಿತ್ರಸ್ಥಳದ ವಸ್ತುಗಳನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಕೆಲಸ ಕೊಡಲ್ಪಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ಕೆಹಾತ್ಯರ ಗೋತ್ರಗಳವರು ಪವಿತ್ರ ಗುಡಾರದ ದಕ್ಷಿಣ ದಿಕ್ಕಿನ ಉದ್ದಕ್ಕೂ ಪಾಳೆಯ ಹಾಕಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ಕೆಹಾತ್ಯರ ನಾಯಕ ಉಜ್ಜೀಯೇಲನ ಮಗನಾದ ಎಲೀಚಾಫಾನ್. ");
INSERT INTO kan2010_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ಅವರು ಪವಿತ್ರಪೆಟ್ಟಿಗೆ, ಮೇಜು, ದೀಪಸ್ತಂಭ, ವೇದಿಕೆಗಳನ್ನು ಮತ್ತು ಪವಿತ್ರಸ್ಥಳದ ಸಾಮಗ್ರಿಗಳನ್ನು, ಪರದೆಯನ್ನು ಮತ್ತು ಅವುಗಳಿಗೆ ಸಂಬಂಧಪಟ್ಟ ಎಲ್ಲಾ ಕಷ್ಟಕರವಾದ ಕೆಲಸಗಳನ್ನು ನೋಡಿಕೊಳ್ಳಬೇಕಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ಮಹಾಯಾಜಕ ಆರೋನನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನು ಲೇವಿಯರಿಗೆ ನಾಯಕನಾಗಿದ್ದನು. ಪವಿತ್ರವಸ್ತುಗಳನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಜನರಿಗೆಲ್ಲಾ ಎಲ್ಲಾಜಾರನು ಮೇಲ್ವಿಚಾರಕನಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","34","ಮಹ್ಲೀ ಮತ್ತು ಮೂಷೀಯ ಗೋತ್ರಗಳವರು ಮೆರಾರೀಯ ಕುಲದವರಾಗಿದ್ದರು. ಮಹ್ಲೀಯ ಗೋತ್ರದಲ್ಲಿ ಒಂದು ತಿಂಗಳು ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳ 6,200 ಮಂದಿ ಗಂಡಸರು ಮತ್ತು ಗಂಡುಮಕ್ಕಳು ಇದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ಮೆರಾರೀ ಗೋತ್ರಗಳ ನಾಯಕನು ಅಬೀಹೈಲನ ಮಗನಾದ ಚೂರೀಯೇಲ್. ಮೆರಾರೀ ಗೋತ್ರಗಳವರು ಪವಿತ್ರ ಗುಡಾರದ ಉತ್ತರ ದಿಕ್ಕಿನಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ಮೆರಾರೀ ಕುಲದವರಿಗೆ ಪವಿತ್ರ ಗುಡಾರದ ಚೌಕಟ್ಟುಗಳನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಕೆಲಸ ಕೊಡಲ್ಪಟ್ಟಿತು. ಅವರು ಎಲ್ಲಾ ಅಗುಳಿಗಳನ್ನು, ಕಂಬಗಳನ್ನು, ಗದ್ದಿಗೇಕಲ್ಲುಗಳನ್ನು, ಅದರ ಎಲ್ಲ ಉಪಕರಣಗಳನ್ನು ಮತ್ತು ಅವುಗಳಿಗೆ ಸಂಬಂಧಪಟ್ಟ ಕಷ್ಟಕರವಾದ ಎಲ್ಲಾ ಕೆಲಸವನ್ನು ನೋಡಿಕೊಳ್ಳಬೇಕಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ಅವರು ಪವಿತ್ರ ಗುಡಾರದ ಸುತ್ತಲಿನ ಅಂಗಳದ ಎಲ್ಲಾ ಕಂಬಗಳನ್ನು ನೋಡಿಕೊಳ್ಳಬೇಕಾಗಿತ್ತು. ಇದರಲ್ಲಿ ಎಲ್ಲಾ ಗದ್ದಿಗೇಕಲ್ಲುಗಳೂ ಗುಡಾರದ ಗೂಟಗಳೂ ಹಗ್ಗಗಳೂ ಸೇರಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ಮೋಶೆ, ಆರೋನ ಮತ್ತು ಆರೋನನ ಪುತ್ರರು ದೇವದರ್ಶನಗುಡಾರದ ಮುಂದೆ ಪವಿತ್ರ ಗುಡಾರದ ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿ ಪಾಳೆಯಮಾಡಿಕೊಂಡರು. ಪವಿತ್ರಸ್ಥಳವನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಕೆಲಸ ಅವರಿಗೆ ಕೊಡಲ್ಪಟ್ಟಿತು. ಅವರು ಇಸ್ರೇಲರೆಲ್ಲರಿಗೋಸ್ಕರ ಇದನ್ನು ಮಾಡಿದರು. ಇವರ ಕರ್ತವ್ಯಗಳನ್ನು ಬೇರೆ ಯಾವನಾದರೂ ಮಾಡಲು ಪ್ರಯತ್ನಿಸಿದರೆ ಅವನು ಕೊಲ್ಲಲ್ಪಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ಆ ಲೇವಿಯರಲ್ಲಿದ್ದ ಒಂದು ತಿಂಗಳು ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚು ವಯಸ್ಸುಳ್ಳ ಎಲ್ಲಾ ಗಂಡಸರನ್ನು ಮತ್ತು ಗಂಡುಮಕ್ಕಳನ್ನು ಅವರ ಗೋತ್ರಗಳಿಗನುಸಾರವಾಗಿ ಲೆಕ್ಕಿಸಬೇಕೆಂದು ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ ಆಜ್ಞಾಪಿಸಿದನು. ಅವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 22,000. ");
INSERT INTO kan2010_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಇಸ್ರೇಲರ ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕಿಂತ ಹೆಚ್ಚು ವಯಸ್ಸಾದ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಗಂಡಸರನ್ನು ಲೆಕ್ಕಿಸು. ಅವರ ಹೆಸರುಗಳ ಪಟ್ಟಿಮಾಡು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ನಾನು ಈಗ ಇಸ್ರೇಲಿನ ಚೊಚ್ಚಲು ಗಂಡಸರನ್ನು ತೆಗೆದುಕೊಳ್ಳುವುದಿಲ್ಲ. ಯೆಹೋವನಾದ ನಾನು ಲೇವಿಯರನ್ನು ತೆಗೆದುಕೊಳ್ಳುವೆನು. ಮಾತ್ರವಲ್ಲದೆ ಇಸ್ರೇಲಿನಲ್ಲಿ ಇತರ ಜನರ ಚೊಚ್ಚಲು ಪ್ರಾಣಿಗಳ ಬದಲು, ಲೇವಿಯರ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಪ್ರಾಣಿಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ಮೋಶೆಯು ಇಸ್ರೇಲರ ಚೊಚ್ಚಲು ಗಂಡಸರನ್ನೆಲ್ಲ್ಲ ಲೆಕ್ಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ಒಂದು ತಿಂಗಳು ಮತ್ತು ಅದಕ್ಕಿಂತ ಹೆಚ್ಚು ವಯಸ್ಸಾದ ಎಲ್ಲಾ ಚೊಚ್ಚಲು ಗಂಡಸರ ಹೆಸರುಗಳನ್ನು ಮೋಶೆ ಪಟ್ಟಿ ಮಾಡಿದನು. ಆ ಪಟ್ಟಿಯಲ್ಲಿ 22,273 ಹೆಸರುಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ಯೆಹೋವನು ಮೋಶೆಗೆ ಮತ್ತೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ದೇವರಾದ ನಾನು ಈ ಆಜ್ಞೆಯನ್ನು ಕೊಡುತ್ತೇನೆ: ‘ಇಸ್ರೇಲಿನ ಇತರ ಕುಟುಂಬಗಳಿಂದ ಚೊಚ್ಚಲು ಗಂಡಸರನ್ನು ತೆಗೆದುಕೊಳ್ಳುವ ಬದಲು ಲೇವಿಯರನ್ನೇ ತೆಗೆದುಕೊ. ಇಸ್ರೇಲರ ಚೊಚ್ಚಲು ಪಶುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳುವ ಬದಲು ಲೇವಿಯರ ಪಶುಗಳನ್ನೇ ತೆಗೆದುಕೊ. ಲೇವಿಯರು ನನ್ನ ಸ್ವತ್ತಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ಲೇವಿಯರ ಸಂಖ್ಯೆ 22,000. ಆದರೆ ಬೇರೆ ಕುಟುಂಬಗಳ ಚೊಚ್ಚಲು ಪುತ್ರರ ಸಂಖ್ಯೆ 22,273. ಹೀಗೆ ಲೇವಿಯರಿಗಿಂತ 273 ಮಂದಿ ಹೆಚ್ಚು ಚೊಚ್ಚಲು ಪುತ್ರರಿರುತ್ತಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ಅಧಿಕೃತ ಅಳತೆಯನ್ನು ಉಪಯೋಗಿಸಿ ಪ್ರತಿಯೊಬ್ಬನಿಗೆ ಅಂದರೆ 273 ಮಂದಿಗೆ ಐದೈದು ಶೆಕೆಲ್ ಬೆಳ್ಳಿಯನ್ನು ಸಂಗ್ರಹಿಸು. (ಅಧಿಕೃತ ಅಳತೆಯಲ್ಲಿ ಒಂದು ಶೆಕೆಲ್ ಅಂದರೆ ಇಪ್ಪತ್ತು ಗೆರಾ.) ಇಸ್ರೇಲರಿಂದ ಈ ಬೆಳ್ಳಿಯನ್ನು ಸಂಗ್ರಹಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ಆ ಬೆಳ್ಳಿಯನ್ನು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಕೊಡು. ಈ ಹಣವು ಇಸ್ರೇಲರ 273 ಮಂದಿಗೆ ಈಡಾಗಿದೆ.’” ");
INSERT INTO kan2010_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ಲೇವಿಯರಿಗಿಂತ ಇಸ್ರೇಲರಲ್ಲಿ 273 ಮಂದಿ ಚೊಚ್ಚಲು ಗಂಡಸರು ಹೆಚ್ಚಾಗಿದ್ದುದರಿಂದ ಮೋಶೆಯು ಆ 273 ಮಂದಿಗೆ ಈಡು ಕೊಡುವುದಕ್ಕಾಗಿ ಹಣವನ್ನು ಸಂಗ್ರಹಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ಮೋಶೆಯು ಇಸ್ರೇಲರಲ್ಲಿ ಚೊಚ್ಚಲಾದ ಗಂಡಸರಿಂದ ಬೆಳ್ಳಿಯನ್ನು ಸಂಗ್ರಹಿಸಿದನು. ಅವನು ಅಧಿಕೃತ ಅಳತೆಯನ್ನು ಉಪಯೋಗಿಸಿ 1,365 ಶೆಕಲ್ ಬೆಳ್ಳಿಯನ್ನು ಸಂಗ್ರಹಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ ವಿಧೇಯನಾಗಿ ಆತನ ಆಜ್ಞೆಯಂತೆ ಬೆಳ್ಳಿಯನ್ನು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ಕೆಹಾತ್ ಗೋತ್ರದ ಪುರುಷರನ್ನು ಲೆಕ್ಕಿಸು. (ಕೆಹಾತ್ಯರು ಲೇವಿ ವಂಶದವರಾಗಿದ್ದಾರೆ.) ");
INSERT INTO kan2010_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಸಂಬಂಧಿಸಿದ ಕೆಲಸವನ್ನು ಮಾಡಲು ಯೋಗ್ಯರಾದ ಮೂವತ್ತರಿಂದ ಐವತ್ತರೊಳಗಿನ ಎಲ್ಲಾ ಪುರುಷರನ್ನು ಲೆಕ್ಕಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ಅವರು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿರುವ ಮಹಾ ಪರಿಶುದ್ಧವಸ್ತುಗಳನ್ನು ನೋಡಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“ಇಸ್ರೇಲರು ಹೊಸ ಸ್ಥಳಕ್ಕೆ ಪ್ರಯಾಣ ಮಾಡುವಾಗ ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ದೇವದರ್ಶನಗುಡಾರದೊಳಕ್ಕೆ ಹೋಗಿ, ಮಹಾ ಪವಿತ್ರ ಸ್ಥಳವನ್ನು ಮರೆಮಾಡುವ ತೆರೆಯನ್ನು ಇಳಿಸಿ, ಅದನ್ನು ಒಡಂಬಡಿಕೆಯ ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಗೆ ಹೊದಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ಬಳಿಕ ಅವರು ಇವುಗಳಿಗೆಲ್ಲ ಶ್ರೇಷ್ಠವಾದ ತೊಗಲಿನಿಂದ ಮಾಡಿದ ಹೊದಿಕೆಯನ್ನು ಹೊದಿಸಬೇಕು. ಆಮೇಲೆ ಅವರು ನೀಲಿಬಟ್ಟೆಯನ್ನು ತೊಗಲಿನ ಮೇಲೆ ಹಾಸಿ ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಯ ಬಳೆಗಳಲ್ಲಿ ಹೊರುವ ಕೋಲುಗಳನ್ನು ಸೇರಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“ಬಳಿಕ ಅವರು ಪವಿತ್ರ ಮೇಜಿನ ಮೇಲೆ ನೀಲಿಬಟ್ಟೆಯನ್ನು ಹಾಸಬೇಕು. ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಿಗಾಗಿ ತಟ್ಟೆಗಳನ್ನೂ ಚಮಚಗಳನ್ನೂ ಬಟ್ಟಲುಗಳನ್ನೂ ಹೂಜೆಗಳನ್ನೂ ವಿಶೇಷ ರೊಟ್ಟಿಯನ್ನೂ ಮೇಜಿನ ಮೇಲೆ ಇಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ಬಳಿಕ ಅವುಗಳ ಮೇಲೆ ಕೆಂಪುಬಟ್ಟೆಯನ್ನು ಹಾಸಿ, ಶ್ರೇಷ್ಠವಾದ ತೊಗಲಿನಿಂದ ಮಾಡಿದ ಹೊದಿಕೆಯನ್ನು ಅದಕ್ಕೆ ಹೊದಿಸಬೇಕು. ಬಳಿಕ ಹೊರುವ ಕೋಲುಗಳನ್ನು ಮೇಜಿನ ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“ಆಮೇಲೆ ದೀಪಸ್ತಂಭಕ್ಕೂ ಅದರ ದೀಪಗಳಿಗೂ ದೀಪಗಳ ಉಪಕರಣಗಳಿಗೂ ಬೂದಿ ತೆಗೆಯುವ ಅಗ್ಗಿಷ್ಠಿಕೆಗೂ ಮತ್ತು ಅದಕ್ಕಾಗಿ ಉಪಯೋಗಿಸುವ ಎಲ್ಲಾ ಎಣ್ಣೆಯ ಪಾತ್ರೆಗಳಿಗೂ ನೀಲಿಬಟ್ಟೆಯನ್ನು ಹೊದಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ಬಳಿಕ ದೀಪಸ್ತಂಭಕ್ಕೂ ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳಿಗೂ ಶ್ರೇಷ್ಠವಾದ ತೊಗಲಿನಿಂದ ಮಾಡಿದ ಹೊದಿಕೆಯನ್ನು ಹೊದಿಸಬೇಕು. ಆಮೇಲೆ ಅವರು ಈ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ಹೊರುವ ಕೋಲುಗಳಿಗೆ ಕಟ್ಟಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“ಅವರು ವರ್ನು ಹೊರುವ ಕಂಬಗಳಿಗೆ ಕಟ್ಟಬರುವ ಕಂಬಗಳಿಗೆ ಕ್‌ಮಾಡಿದ ಹೊದಿಕೆಯನ್ನು ಹೊದಿಸಬೇಕು. ಆಮೇಲೆ ಠ ಐವತ್ತರೊಳಗಿನ ಎಲ್ಲಾ ಪುರು,್ನು ವೇದಿಕೆಯ ಬಳೆಗಳಿಗೆ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“ಬಳಿಕ ಆರಾಧನೆಗಾಗಿ ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಉಪಯೋಗಿಸಲ್ಪಡುವ ಎಲ್ಲಾ ವಿಶೇಷ ವಸ್ತುಗಳನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಬೇಕು. ಅವುಗಳನ್ನು ನೀಲಿಬಟ್ಟೆಯಿಂದ ಮುಚ್ಚಬೇಕು. ಬಳಿಕ ಅವುಗಳಿಗೆ ಶ್ರೇಷ್ಠವಾದ ತೊಗಲನ್ನು ಹೊದಿಸಬೇಕು. ಅವರು ಈ ವಸ್ತುಗಳನ್ನು ಹೊರುವುದಕ್ಕಾಗಿ ಚೌಕಟ್ಟಿಗೆ ಕಟ್ಟಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“ಅವರು ತಾಮ್ರದ ವೇದಿಕೆಯಿಂದ ಬೂದಿಯನ್ನು ತೆಗೆದು, ನೇರಳೆಬಟ್ಟೆಯನ್ನು ಅದರ ಮೇಲೆ ಹಾಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ಬಳಿಕ ಅವರು ವೇದಿಕೆಯಲ್ಲಿ ಆರಾಧನೆಗಾಗಿ ಉಪಯೋಗಿಸಲ್ಪಡುವ ಎಲ್ಲಾ ವಸ್ತುಗಳನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಬೇಕು. ಅವುಗಳು ಯಾವುವೆಂದರೆ, ಅಗ್ಗಿಷ್ಟಿಗೆಗಳು, ಮುಳ್ಳುಚಮಚಗಳು, ಸಲಿಕೆಗಳು ಮತ್ತು ಬೋಗುಣಿಗಳು. ಅವರು ಇವುಗಳನ್ನು ತಾಮ್ರದ ವೇದಿಕೆಯ ಮೇಲೆ ಇಡಬೇಕು. ಬಳಿಕ ಅವರು ಶ್ರೇಷ್ಠವಾದ ತೊಗಲಿನ ಹೊದಿಕೆಯನ್ನು ಇವುಗಳಿಗೆಲ್ಲ ಹೊದಿಸಿ, ಹೊರುವ ಕೋಲುಗಳನ್ನು ವೇದಿಕೆಯ ಬಳೆಗಳಲ್ಲಿ ಸೇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“ಇಸ್ರೇಲರು ಪ್ರಯಾಣಮಾಡುವ ಸಮಯದಲ್ಲಿ ಆರೋನನು ಮತ್ತು ಅವನ ಪುತ್ರರು ಪವಿತ್ರವಸ್ತುಗಳಿಗೂ ಪವಿತ್ರ ಉಪಕರಣಗಳಿಗೂ ಹೊದಿಸಿದ ನಂತರ, ಕೆಹಾತ್ಯರು ಅವುಗಳನ್ನು ಹೊರುವುದಕ್ಕೆ ಹೋಗಬಹುದು. ಈ ರೀತಿ ಅವರು ಪವಿತ್ರವಸ್ತುಗಳನ್ನು ಮುಟ್ಟಬಾರದು; ಅವರು ಮುಟ್ಟಿದರೆ ಸಾಯುತ್ತಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“ಮಹಾಯಾಜಕನಾದ ಆರೋನನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನು ಇಡೀ ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಮತ್ತು ಎಲ್ಲಾ ಪವಿತ್ರಸ್ಥಳವನ್ನು ಮತ್ತು ಅದರೊಳಗಿರುವ ಎಲ್ಲಾ ಪಾತ್ರೆಗಳನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಜವಾಬ್ದಾರಿ ಹೊಂದಿದ್ದಾನೆ. ದೀಪದ ಎಣ್ಣೆಗೂ ಪರಿಮಳಧೂಪಕ್ಕೂ ದೈನಂದಿನ ಧಾನ್ಯಸಮರ್ಪಣೆಗೂ ಅಭಿಷೇಕತೈಲಕ್ಕೂ ಅವನು ಜವಾಬ್ದಾರನಾಗಿದ್ದಾನೆ.” ");
INSERT INTO kan2010_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ಕೆಹಾತ್ಯರು ಲೇವಿಯರ ಮಧ್ಯದಿಂದ ಇಲ್ಲವಾಗದಂತೆ ಎಚ್ಚರಿಕೆಯಾಗಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ಅವರು ಮಹಾ ಪರಿಶುದ್ಧ ವಸ್ತುಗಳ ಹತ್ತಿರ ಬಂದಾಗ ಸಾಯದಂತೆ ನೀವು ಅವರ ವಿಷಯದಲ್ಲಿ ಮಾಡಬೇಕಾದದ್ದೇನೆಂದರೆ, ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಒಳಗೆ ಬಂದು, ಪ್ರತಿಯೊಬ್ಬ ಕೆಹಾತ್ಯನು ಮಾಡಬೇಕಾದ ಕೆಲಸವನ್ನು ಮತ್ತು ಹೊತ್ತುಕೊಂಡು ಹೋಗಬೇಕಾದದ್ದನ್ನು ತೋರಿಸಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ಇಲ್ಲವಾದರೆ, ಕೆಹಾತ್ಯರು ಒಳಗೆ ಬಂದು ಪರಿಶುದ್ಧವಸ್ತುಗಳನ್ನು ಮುಟ್ಟುವರು. ಆ ಮಹಾ ಪರಿಶುದ್ಧವಸ್ತುಗಳನ್ನು ಅವರು ಒಂದು ಕ್ಷಣ ಮುಟ್ಟಿದರೂ ಸಾಯುತ್ತಾರೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","23","“ನೀನು ಗೇರ್ಷೋನ್ಯರನ್ನು ಕುಟುಂಬಗಳಿಗನುಸಾರವಾಗಿ ಮತ್ತು ಕುಲಗಳಿಗನುಸಾರವಾಗಿ ಲೆಕ್ಕಿಸು. ಅಲ್ಲದೆ ದೇವದರ್ಶನಗುಡಾರದ ಸೇವೆಯನ್ನು ಮಾಡಲು ಯೋಗ್ಯರಾದ ಗಂಡಸರನ್ನು ಪಟ್ಟಿಮಾಡು. ಅವರ ವಯಸ್ಸು ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದೊಳಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“ವರ್ಗಾವಣೆಗಾಗಿ ಸಾಮಾನುಗಳನ್ನು ಕಟ್ಟುವುದರಲ್ಲಿಯೂ ವರ್ಗಾವಣೆಯಲ್ಲಿಯೂ ಗೇರ್ಷೋನ್ಯರು ಮಾಡತಕ್ಕ ಕೆಲಸ ಯಾವುದೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ಅವರು ಪವಿತ್ರ ಗುಡಾರದ ಬಟ್ಟೆಗಳನ್ನು, ದೇವದರ್ಶನಗುಡಾರ ಮತ್ತು ಅದರ ಹೊದಿಕೆ, ಅದರ ಮೇಲಿರುವ ಶ್ರೇಷ್ಠವಾದ ತೊಗಲಿನ ಹೊದಿಕೆ ಮತ್ತು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿರುವ ಪ್ರವೇಶದ್ವಾರದ ಪರದೆಯನ್ನು ವರ್ಗಾಯಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ಅಂಗಳದ ಪರದೆಗಳನ್ನು, ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಮತ್ತು ವೇದಿಕೆಯ ಸುತ್ತಲೂ ಇರುವ ಅಂಗಳ ಪ್ರವೇಶದ್ವಾರದ ಪರದೆಯನ್ನು, ಅವುಗಳ ಹಗ್ಗಗಳನ್ನು ಮತ್ತು ಇವುಗಳ ಎಲ್ಲಾ ಉಪಕರಣಗಳನ್ನು ವರ್ಗಾಯಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ಗೇರ್ಷೋನ್ಯರು ಮಾಡುವ ಎಲ್ಲಾ ಕೆಲಸಗಳನ್ನು ಅಂದರೆ ವರ್ಗಾವಣೆಗಾಗಿ ಸಾಮಾನುಗಳನ್ನು ಕಟ್ಟುವುದರಲ್ಲಿಯೂ ವರ್ಗಾವಣೆ ಮಾಡುವುದರಲ್ಲಿಯೂ ಆರೋನ ಮತ್ತು ಅವನ ಪುತ್ರರು ಮಾರ್ಗದರ್ಶನ ನೀಡುವರು. ಗೇರ್ಷೋನ್ಯರು ವರ್ಗಾಯಿಸುವ ಎಲ್ಲವನ್ನು ಅವರೇ ಕಾಯಬೇಕೆಂಬ ಜವಾಬ್ದಾರಿಕೆಯನ್ನು ನೀನು ಅವರಿಗೆ ಕೊಡು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ದೇವದರ್ಶನಗುಡಾರಕ್ಕೋಸ್ಕರ ಮತ್ತು ತಮ್ಮ ಕಾವಲಿನ ಕರ್ತವ್ಯದಲ್ಲಿ ಗೇರ್ಷೋನ್ಯರು ಮಾಡಬೇಕಾದ ಕೆಲಸ ಇದೇ. ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನು ಅವರ ಮೇಲ್ವಿಚಾರಕನಾಗಿರಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“ನೀನು ಮೆರಾರೀಯರನ್ನೂ ಅವರ ಕುಲಗಳಿಗನುಗುಣವಾಗಿ ಮತ್ತು ಕುಟುಂಬಗಳಿಗನುಗುಣವಾಗಿ ಲೆಕ್ಕಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ದೇವದರ್ಶನಗುಡಾರದ ಸೇವೆಯ ದಳದಲ್ಲಿ ಕೆಲಸಮಾಡಲು ಯೋಗ್ಯರಾದ ಗಂಡಸರನ್ನು ಲೆಕ್ಕಿಸು. ಅವರ ವಯಸ್ಸು ಮೂವತ್ತರಿಂದ ಮೊದಲುಗೊಂಡು ಐವತ್ತರೊಳಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ಈ ಕೆಳಕಂಡ ವಸ್ತುಗಳನ್ನು ಮೆರಾರೀಯರು ವರ್ಗಾವಣೆಗಾಗಿ ಕಟ್ಟುವರು, ವರ್ಗಾಯಿಸುವರು ಮತ್ತು ಕಾವಲುಕಾಯುವರು: ಪವಿತ್ರ ಡೇರೆಯ ಚೌಕಟ್ಟುಗಳು, ಅದರ ಅಡ್ಡಪಟ್ಟಿಗಳು, ಅದರ ಸ್ತಂಭಗಳು, ಅದರ ಗದ್ದಿಗೇಕಲ್ಲುಗಳು, ");
INSERT INTO kan2010_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ಅಂಗಳದ ಸ್ತಂಭಗಳು ಮತ್ತು ಅವುಗಳ ಗದ್ದಿಗೇಕಲ್ಲುಗಳು, ಅಗುಳಿಗಳು, ಹಗ್ಗಗಳು ಮತ್ತು ಅವರ ಕೆಲಸಕ್ಕೆ ಬೇಕಾದ ಎಲ್ಲಾ ಉಪಕರಣಗಳು. ಅವರು ವರ್ಗಾಯಿಸಬೇಕಾದ ಮತ್ತು ಕಾವಲುಕಾಯಬೇಕಾದ ವಸ್ತುಗಳನ್ನು ನೀನು ಹೆಸರೆಸರಾಗಿ ಅವರಿಗೆ ವಹಿಸಿಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ದೇವದರ್ಶನಗುಡಾರಕ್ಕೋಸ್ಕರ ಮೆರಾರೀಯರು ಮಾಡತಕ್ಕ ಕೆಲಸ ಇದೇ. ಅವರ ಕೆಲಸವನ್ನು ಮೇಲ್ವಿಚಾರಣೆ ಮಾಡುವುದು ಮಹಾಯಾಜಕ ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನ ಜವಾಬ್ದಾರಿಯಾಗಿದೆ.” ");
INSERT INTO kan2010_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","35","ಮೋಶೆ ಆರೋನರೂ, ಸಮುದಾಯದ ಪ್ರಧಾನರೂ ಕುಲ ಮತ್ತು ಕುಟುಂಬಗಳಿಗನುಗುಣವಾಗಿ ಕೆಹಾತ್ಯರಲ್ಲಿ ಮೂವತ್ತು ವರ್ಷದಿಂದ ಮೊದಲುಗೊಂಡು ಐವತ್ತು ವರ್ಷದೊಳಗಿರುವ ಗಂಡಸರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ದೇವದರ್ಶನಗುಡಾರಕ್ಕೋಸ್ಕರ ಸೇವೆಯ ದಳದಲ್ಲಿ ಕೆಲಸ ಮಾಡಲು ಯೋಗ್ಯರಾದ ಗಂಡಸರನ್ನೇ ಅವರು ಲೆಕ್ಕಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ಅವರಲ್ಲಿ ಈ ಕೆಲಸವನ್ನು ಮಾಡಲು ಅರ್ಹರಾಗಿ ಗೋತ್ರ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರು 2,750 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಪ್ರಕಾರ ಮೋಶೆ ಆರೋನರು ಕೆಹಾತ್ಯರನ್ನು ಲೆಕ್ಕಿಸಲಾಗಿ ಅವರಲ್ಲಿ ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಸಂಬಂಧಪಟ್ಟ ಕೆಲಸವನ್ನು ಮಾಡತಕ್ಕವರು ಇವರೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","39","ಗೇರ್ಷೋನ್ಯರಲ್ಲಿಯೂ ಮೂವತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಐವತ್ತು ವರ್ಷದೊಳಗಿರುವ ಮತ್ತು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೋಸ್ಕರ ಸೇವೆಯ ದಳದಲ್ಲಿ ಕೆಲಸ ಮಾಡಲು ಯೋಗ್ಯರಾದ ಗಂಡಸರನ್ನು ಕುಲ ಮತ್ತು ಕುಟುಂಬಗಳಿಗನುಗುಣವಾಗಿ ಲೆಕ್ಕಿಸಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ಅವರ ಸಂಖ್ಯೆ 2,630. ");
INSERT INTO kan2010_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆ ಆರೋನರು ಗೇರ್ಷೋನ್ಯರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಅವರಲ್ಲಿ ದೇವದರ್ಶನಗುಡಾರದ ವಿಶೇಷ ಕೆಲಸವನ್ನು ಮಾಡತಕ್ಕವರು ಇವರೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","43","ಮೆರಾರೀಯರಲ್ಲಿಯೂ ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದ ಒಳಗಿರುವ ಮತ್ತು ದೇವದರ್ಶನ ಗುಡಾರಕ್ಕೋಸ್ಕರ ಸೇವೆಯ ದಳದಲ್ಲಿ ಕೆಲಸಮಾಡಲು ಯೋಗ್ಯರಾದ ಗಂಡಸರನ್ನು ಕುಲ ಮತ್ತು ಕುಟುಂಬಗಳಿಗೆ ಅನುಗುಣವಾಗಿ ಲೆಕ್ಕಿಸಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ಅವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 3,200. ");
INSERT INTO kan2010_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಮೋಶೆ ಆರೋನರು ಅವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ಮೆರಾರೀಯರ ಕುಲಗಳಿಂದ ಈ ಗಂಡಸರನ್ನು ದಾಖಲಾತಿ ಮಾಡಿಕೊಳ್ಳಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ಹೀಗೆ ಮೋಶೆ ಆರೋನರು ಇಸ್ರೇಲರ ಪ್ರಧಾನರನ್ನೂ ಎಲ್ಲಾ ಲೇವಿಯರನ್ನೂ ಕುಲ ಮತ್ತು ಕುಟುಂಬಗಳಿಗೆ ಅನುಗುಣವಾಗಿ ಲೆಕ್ಕಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ಮೂವತ್ತರಿಂದ ಐವತ್ತು ವರ್ಷದೊಳಗಿರುವ ಮತ್ತು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಸಂಬಂಧಿಸಿದ ವಸ್ತುಗಳನ್ನು ವರ್ಗಾವಣೆಗಾಗಿ ಕಟ್ಟುವುದಕ್ಕೂ ವರ್ಗಾವಣೆಯ ಕೆಲಸಕ್ಕೂ ಯೋಗ್ಯರಾದ ಎಲ್ಲಾ ಗಂಡಸರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ಅವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 8,580. ");
INSERT INTO kan2010_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ಹೀಗೆ ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಮೇರೆಗೆ ಅವನಿಂದ ಪ್ರತಿಯೊಬ್ಬನೂ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟನು. ಪ್ರತಿಯೊಬ್ಬನಿಗೂ ವರ್ಗಾವಣೆಗಾಗಿ ವಸ್ತುಗಳನ್ನು ಕಟ್ಟುವ ಮತ್ತು ವರ್ಗಾವಣೆ ಕೆಲಸದ ಕರ್ತವ್ಯಗಳನ್ನು ಗೊತ್ತುಪಡಿಸಲಾಯಿತು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ಮೇರೆಗೆ ಇದು ಮಾಡಲ್ಪಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ಭಯಂಕರವಾದ ಚರ್ಮರೋಗವುಳ್ಳವರನ್ನೂ ದೈಹಿಕಸ್ರಾವವುಳ್ಳವರನ್ನೂ ಹೆಣದ ಸೋಂಕಿನಿಂದ ಅಶುದ್ಧರಾದವರನ್ನೂ ಪಾಳೆಯದಿಂದ ಹೊರಗಿಡಬೇಕೆಂದು ಇಸ್ರೇಲರಿಗೆ ಆಜ್ಞಾಪಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ಅಂಥವರು ಗಂಡಸರೇ ಆಗಲಿ ಹೆಂಗಸರೇ ಆಗಲಿ ಅವರೆಲ್ಲರನ್ನೂ ಪಾಳೆಯದಿಂದ ಹೊರಡಿಸಬೇಕು. ನಾನೇ ಅವರ ಪಾಳೆಯದಲ್ಲಿ ವಾಸಮಾಡುವುದರಿಂದ ಅವರು ಅದನ್ನು ಅಪವಿತ್ರ ಮಾಡಬಾರದು.” ");
INSERT INTO kan2010_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಇಸ್ರೇಲರು ತಮ್ಮಲ್ಲಿರುವ ಅಂಥವರೆಲ್ಲರನ್ನೂ ಪಾಳೆಯದ ಹೊರಗಿರಿಸಿದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಅವರು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ಇದನ್ನು ಇಸ್ರೇಲರಿಗೆ ತಿಳಿಸು: ಯಾವ ಪುರುಷನಾಗಲಿ ಸ್ತ್ರೀಯಾಗಲಿ ಮತ್ತೊಬ್ಬನನ್ನು ಆಸ್ತಿಯ ವಿಷಯದಲ್ಲಿ ಮೋಸಗೊಳಿಸಿದರೆ ಅವನು ಸುಳ್ಳುಪ್ರಮಾಣ ಮಾಡುವುದರ ಮೂಲಕ ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ಹೊಲಸಾದ ಕಾರ್ಯವನ್ನು ಮಾಡಿದಂತಾಯಿತು. ಆದ್ದರಿಂದ ಅವನು ದೋಷಿಯಾಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ಆದ್ದರಿಂದ ಅಂಥವನು ತನ್ನ ಪಾಪವನ್ನು ಅರಿಕೆಮಾಡಬೇಕು. ಅದಲ್ಲದೆ, ಅಪರಾಧ ಮಾಡಿದವನು ನಷ್ಟಪಟ್ಟವನಿಗೆ ಮೂಲದ್ರವ್ಯದ ಬೆಲೆಯೊಡನೆ ಐದನೆಯ ಭಾಗವನ್ನು ಹೆಚ್ಚಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ದಂಡವನ್ನು ತೆಗೆದುಕೊಳ್ಳತಕ್ಕವನು ತೀರಿಹೋಗಿ, ಹತ್ತಿರ ಸಂಬಂಧಿಯೂ ಇಲ್ಲದ ಪಕ್ಷಕ್ಕೆ, ಆ ದ್ರವ್ಯವನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಡಬೇಕು. ಅವನು ಯಾಜಕನಿಗೆ ಪೂರ್ಣ ಬೆಲೆಯನ್ನು ಕೊಡಬೇಕು. ತಪ್ಪು ಮಾಡಿದವನು ಯಾಜಕನಿಗೆ ಒಂದು ಟಗರನ್ನೂ ತಂದುಕೊಡಬೇಕು. ಈ ಟಗರನ್ನು ತಪ್ಪುಮಾಡಿದವನ ಪ್ರಾಯಶ್ಚಿತ್ತಕ್ಕಾಗಿ ಯಜ್ಞಮಾಡಬೇಕು. ಆದರೆ ಉಳಿದದ್ದನ್ನು ಯಾಜಕನು ಇಟ್ಟುಕೊಳ್ಳಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","10","“ಒಬ್ಬನು ದೇವರಿಗೆ ವಿಶೇಷ ಕಾಣಿಕೆಯನ್ನು ಅರ್ಪಿಸಿದರೆ, ಅದನ್ನು ಸ್ವೀಕರಿಸುವ ಯಾಜಕನು ತನಗಾಗಿ ಅದನ್ನು ಇಟ್ಟುಕೊಳ್ಳಬಹುದು. ಅದು ಅವನದಾಗಿರುತ್ತದೆ. ಒಬ್ಬನು ಈ ವಿಶೇಷ ಕಾಣಿಕೆಗಳನ್ನು ಕೊಡಬೇಕಾಗಿಲ್ಲ. ಆದರೆ ಅವನು ಅವುಗಳನ್ನು ಕೊಟ್ಟರೆ ಅವು ಯಾಜಕನಿಗೆ ಸೇರುತ್ತವೆ.” ");
INSERT INTO kan2010_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ಈ ವಿಷಯಗಳನ್ನು ಇಸ್ರೇಲರಿಗೆ ಹೇಳು: ಒಬ್ಬನ ಹೆಂಡತಿ ಸನ್ಮಾರ್ಗವನ್ನು ಬಿಟ್ಟು ತನ್ನ ಗಂಡನಿಗೆ ಅಪನಂಬಿಗಸ್ತಳಾಗಿದ್ದು, ");
INSERT INTO kan2010_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ಇನ್ನೊಬ್ಬನೊಡನೆ ಲೈಂಗಿಕ ಸಂಬಂಧ ಮಾಡಿರಬಹುದು. ಅವಳ ಈ ಕಾರ್ಯವು ಗಂಡನಿಗೆ ಗೊತ್ತಿಲ್ಲದಿರಬಹುದು; ಯಾವ ಸಾಕ್ಷಿಯೂ ಇಲ್ಲದಿರುವುದರಿಂದ ಮತ್ತು ಅವಳು ಈ ಕಾರ್ಯ ಮಾಡುತ್ತಿರುವಾಗಲೇ ಸಿಕ್ಕಿಕೊಂಡಿಲ್ಲದಿರುವುದರಿಂದ ತಾನು ತನ್ನನ್ನು ಅಶುದ್ಧಳನ್ನಾಗಿ ಮಾಡಿಕೊಂಡ ಸತ್ಯಾಂಶವನ್ನು ಆಕೆ ಗುಪ್ತವಾಗಿಡಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ಆದರೆ ಗಂಡನು ಈರ್ಷೆ ಉಳ್ಳವನಾಗಿ ತನ್ನ ಹೆಂಡತಿ ತನ್ನನ್ನು ಅಶುದ್ಧಳನ್ನಾಗಿ ಮಾಡಿಕೊಂಡಿದ್ದಾಳೆ ಎಂದು ಸಂಶಯಪಡುವುದಾಗಿದ್ದರೆ ಅವಳು ಮಾಡಿಕೊಂಡಿರಲಿ ಮಾಡಿಕೊಂಡಿಲ್ಲದಿರಲಿ ");
INSERT INTO kan2010_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ಅವನು ಅವಳನ್ನು ಯಾಜಕನ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಹೋಗಬೇಕು. ಅಲ್ಲದೆ ಅವನು ಮೂರು ಸೇರು ಗೋಧಿಹಿಟ್ಟನ್ನು ಕಾಣಿಕೆಯಾಗಿ ಯಾಜಕನಿಗೆ ತಂದು ಕೊಡಬೇಕು. ಅವನು ಅದರ ಮೇಲೆ ಎಣ್ಣೆ ಹಾಕಬಾರದು; ಅವನು ಅದರ ಮೇಲೆ ಧೂಪಹಾಕಬಾರದು; ಯಾಕೆಂದರೆ ಇದು ಈರ್ಷೆಯುಳ್ಳ ಗಂಡನ ಧಾನ್ಯಸಮರ್ಪಣೆಯಾಗಿದೆ. ಆಕೆಯ ದೋಷವನ್ನು ಹೊರಪಡಿಸಲು ಕೊಟ್ಟಂಥ ಧಾನ್ಯಸಮರ್ಪಣೆ ಇದಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ಯಾಜಕನು ಅವಳನ್ನು ತಂದು ಯೆಹೋವನ ಎದುರಿನಲ್ಲಿ ನಿಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ಬಳಿಕ ಅವನು ಮಣ್ಣಿನ ಪಾತ್ರೆಯಲ್ಲಿ ಸ್ವಲ್ಪ ಪವಿತ್ರ ಜಲವನ್ನು ತೆಗೆದುಕೊಂಡು ಪವಿತ್ರ ಗುಡಾರದ ನೆಲದಿಂದ ಸ್ವಲ್ಪ ಧೂಳನ್ನು ಆ ನೀರಿನಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ಯಾಜಕನು ಅವಳನ್ನು ಯೆಹೋವನ ಮುಂದೆ ನಿಲ್ಲಿಸಿ ಅವಳ ತಲೆಯ ಕೂದಲನ್ನು ಕೆದರಿಸಿ ಆಕೆಯ ದೋಷವನ್ನು ಹೊರಪಡಿಸುವ ಧಾನ್ಯಸಮರ್ಪಣೆಯನ್ನು ಅವಳ ಕೈಯಲ್ಲಿ ಇಡಬೇಕು. ಅದು ಈರ್ಷೆಯುಳ್ಳ ಗಂಡನ ಧಾನ್ಯಸಮರ್ಪಣೆ. ಅದೇ ಸಮಯದಲ್ಲಿ ಶಾಪವನ್ನು ಉಂಟುಮಾಡುವ ನೀರಿನ ವಿಶೇಷ ಪಾತ್ರೆಯನ್ನು ಯಾಜಕನು ತನ್ನ ಕೈಯಲ್ಲಿ ಹಿಡಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“ಬಳಿಕ ಯಾಜಕನು ಸ್ತ್ರೀಗೆ ಸುಳ್ಳಾಡದೆ ಸತ್ಯವನ್ನೇ ಹೇಳಬೇಕೆಂದು ಪ್ರಮಾಣ ಮಾಡಿಸುವನು. ಯಾಜಕನು ಅವಳಿಗೆ ಹೀಗೆನ್ನಬೇಕು: ‘ನೀನು ಪರಪುರುಷನ ಸಂಗ ಮಾಡದೆ ಗಂಡನ ಅಧೀನದಲ್ಲಿದ್ದು ಪಾತಿವ್ರತ್ಯವನ್ನು ಬಿಡದೆ ದುಷ್ಕೃತ್ಯವನ್ನು ಮಾಡದೆ ಇರುವವಳಾದರೆ, ಶಾಪವನ್ನು ಉಂಟುಮಾಡುವ ಕಹಿನೀರಿನಿಂದ ನಿನಗೆ ಹಾನಿಯಾಗಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ಆದರೆ ನೀನು ನಿನ್ನ ಗಂಡನಲ್ಲದ ಪರಪುರುಷನೊಡನೆ ಸಂಗಮಾಡಿ ನಿನ್ನ ಗಂಡನಿಗೆ ವಿರುದ್ಧವಾಗಿ ಪಾಪಮಾಡಿದ್ದರೆ, ನೀನು ಶುದ್ಧಳಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ಆದ್ದರಿಂದ ನೀನು ಈ ವಿಶೇಷ ಜಲವನ್ನು ಕುಡಿಯುವಾಗ, ನಿನಗೆ ಹಾನಿಯುಂಟಾಗುವುದು. ನಿನಗೆ ಮಕ್ಕಳಾಗುವುದಿಲ್ಲ. ನೀನು ಬಸುರಾಗಿದ್ದರೆ, ನಿನ್ನ ಮಗು ಸಾಯುವುದು. ಆಗ ನಿನ್ನ ಜನರು ನಿನ್ನನ್ನು ದೂರಮಾಡಿ ನಿನ್ನ ವಿರುದ್ಧವಾಗಿ ಕೆಟ್ಟ ಸಂಗತಿಗಳನ್ನು ಹೇಳುವರು.’ “ಬಳಿಕ ಯಾಜಕನು ಆ ಸ್ತ್ರೀಗೆ ಪ್ರಮಾಣ ಮಾಡಲು ಹೇಳಬೇಕು. ಅವಳು, ‘ನಾನು ಸುಳ್ಳಾಡಿದ್ದರೆ, ಈ ಕೆಟ್ಟ ಸಂಗತಿಗಳು ನನಗೆ ಸಂಭವಿಸಲಿ’ ಎಂದು ಹೇಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ಯಾಜಕನು, ‘ಹಾನಿಯನ್ನು ಉಂಟುಮಾಡುವ ಈ ನೀರನ್ನು ನೀನು ಕುಡಿಯಬೇಕು. ನೀನು ಪಾಪ ಮಾಡಿದ್ದರೆ ನಿನಗೆ ಮಕ್ಕಳಾಗುವುದಿಲ್ಲ ಮತ್ತು ನೀನು ಪಡೆಯುವ ಮಗು ಹುಟ್ಟುವ ಮೊದಲೇ ಸಾಯುವುದು’ ಎಂದು ಹೇಳಬೇಕು. ಅದಕ್ಕೆ ಸ್ತ್ರೀಯು, ‘ಹಾಗೆಯೇ ಆಗಲಿ’ ಎಂದು ಹೇಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ಯಾಜಕನು ಈ ಶಾಪಗಳನ್ನು ಒಂದು ಸುರುಳಿಯಲ್ಲಿ ಬರೆಯಬೇಕು. ಬಳಿಕ ಆ ಕಹಿ ನೀರಿನಿಂದ ಆ ಸುರುಳಿಯ ವಾಕ್ಯವನ್ನು ತೊಳೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ಆಮೇಲೆ ಶಾಪವನ್ನು ಬರಮಾಡುವ ಆ ನೀರನ್ನು ಆ ಸ್ತ್ರೀಗೆ ಕುಡಿಸಬೇಕು. ಈ ನೀರು ಅವಳೊಳಗೆ ಸೇರುವುದು. ಅವಳು ದೋಷಿಯಾಗಿದ್ದರೆ ಅವಳಿಗೆ ಮಹಾಸಂಕಟವನ್ನು ಉಂಟುಮಾಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“ಯಾಜಕನು ಈರ್ಷೆಯುಳ್ಳ ಗಂಡನ ಧಾನ್ಯಸಮರ್ಪಣೆಯನ್ನು ಆಕೆಯ ಕೈಗಳಿಂದ ತೆಗೆದುಕೊಂಡು ಅದನ್ನು ಯೆಹೋವನ ಮುಂದೆ ಪ್ರತಿಷ್ಠಿಸಿ, ಬಳಿಕ ಅದನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ಯಾಜಕನು ನೈವೇದ್ಯವಾದದ್ದನ್ನು ಸೂಚಿಸುವುದಕ್ಕಾಗಿ ಆ ಹಿಟ್ಟಿನಲ್ಲಿ ಒಂದು ಹಿಡಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಹೋಮಮಾಡಬೇಕು. ತರುವಾಯ ಅವನು ಆ ನೀರನ್ನು ಕುಡಿಯಲು ಸ್ತ್ರೀಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ಅವಳು ಅಶುದ್ಧಳಾಗಿದ್ದರೆ ಮತ್ತು ತನ್ನ ಗಂಡನಿಗೆ ವಿರುದ್ಧವಾಗಿ ಪಾಪಮಾಡಿದ್ದರೆ, ನೀರು ಅವಳಿಗೆ ಹಾನಿಯನ್ನು ಉಂಟುಮಾಡುವುದು, ನೀರು ಅವಳೊಳಗೆ ಹೋಗಿ ಅವಳಿಗೆ ಮಹಾಸಂಕಟವನ್ನು ಉಂಟುಮಾಡುವುದು. ನೀರು ಅವಳನ್ನು ಆ ಕೂಡಲೇ ಬಂಜೆಯನ್ನಾಗಿ ಮಾಡುವುದು. ಅವಳು ತನ್ನ ಜನರ ಮಧ್ಯದಲ್ಲಿ ಶಾಪಗ್ರಸ್ತಳಾಗಿರುವಳು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ಆದರೆ ಅವಳು ತನ್ನ ಗಂಡನಿಗೆ ವಿರುದ್ಧವಾಗಿ ಪಾಪ ಮಾಡದೆ ಶುದ್ಧಳಾಗಿದ್ದರೆ, ಯಾಜಕನು ಅವಳನ್ನು ದೋಷಿಯಲ್ಲವೆಂದು ಹೇಳುವನು. ಆಗ ಅವಳಿಗೆ ಯಾವ ಹಾನಿಯಾಗದೆ, ಇನ್ನೂ ಮಕ್ಕಳನ್ನು ಹೆರಲು ಶಕ್ತಳಾಗಿರುವಳು. ");
INSERT INTO kan2010_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ಇದೇ ವ್ಯಭಿಚಾರ ಸಂಶಯವನ್ನು ಪರಿಹರಿಸುವ ವಿಧಿ. ಗಂಡನ ಸ್ವಾಧೀನದಲ್ಲಿರುವ ಹೆಂಡತಿಯು ");
INSERT INTO kan2010_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ಪಾತಿವ್ರತ್ಯವನ್ನು ಬಿಟ್ಟು ಜಾರತ್ವ ಮಾಡಿರುವಾಗಲೂ ಗಂಡನು ಹೆಂಡತಿಯ ವಿಷಯದಲ್ಲಿ ಸಂಶಯಪಡುವಾಗಲೂ ಅವನು ಮಾಡಬೇಕಾದದ್ದು ಇದೇ. ಯಾಜಕನು ಸ್ತ್ರೀಗೆ ಯೆಹೋವನ ಮುಂದೆ ನಿಲ್ಲಲು ಹೇಳಬೇಕು. ಆಗ ಯಾಜಕನು ಈ ಎಲ್ಲಾ ಸಂಗತಿಗಳನ್ನು ಮಾಡುವನು. ಇದು ನಿಯಮವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ಗಂಡನು ನಿರಪರಾಧಿಯಾಗಿರುವನು. ಆದರೆ ಸ್ತ್ರೀಯು ಪಾಪಮಾಡಿದ್ದರೆ, ಆಕೆ ಅದರ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ಈ ಸಂಗತಿಗಳನ್ನು ಇಸ್ರೇಲರಿಗೆ ಹೇಳು: ಯಾವ ಪುರುಷನಾಗಲಿ ಸ್ತ್ರೀಯಾಗಲಿ ನಾಜೀರವ್ರತವನ್ನು ಮಾಡುವುದರ ಮೂಲಕ ತನ್ನನ್ನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡರೆ, ಯೆಹೋವನಿಗೋಸ್ಕರ ಹರಕೆ ಮಾಡಿಕೊಂಡರೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ಆ ಸಮಯದಲ್ಲಿ ಅವನು ದ್ರಾಕ್ಷಾರಸವನ್ನಾಗಲಿ ಮದ್ಯವನ್ನಾಗಲಿ ಕುಡಿಯಬಾರದು; ದ್ರಾಕ್ಷಾರಸದ ಹುಳಿಯನ್ನಾಗಲಿ ಬೇರೆ ಮದ್ಯದ ಹುಳಿಯನ್ನಾಗಲಿ ಕುಡಿಯಬಾರದು; ದ್ರಾಕ್ಷಿಯ ಹಣ್ಣಿನಿಂದ ಮಾಡಿದ ಯಾವ ಪಾನವನ್ನೂ ಕುಡಿಯಬಾರದು; ಹಸಿ ಅಥವಾ ಒಣ ದ್ರಾಕ್ಷಿಯನ್ನು ಸಹ ತಿನ್ನಬಾರದು; ");
INSERT INTO kan2010_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ಅವನು ಹರಕೆ ಮಾಡಿಕೊಂಡಿರುವ ದಿನಗಳಲ್ಲಿ ದ್ರಾಕ್ಷಾಲತೆಯಿಂದ ಉತ್ಪನ್ನವಾಗುವ ಯಾವದನ್ನೂ ತಿನ್ನಬಾರದು. ಅವನು ದ್ರಾಕ್ಷಿಯ ಬೀಜವನ್ನಾಗಲಿ ಸಿಪ್ಪೆಯನ್ನಾಗಲಿ ತಿನ್ನಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ಅವನ ವ್ರತದ ಕಾಲದಲ್ಲಿ ಕ್ಷೌರದ ಕತ್ತಿಯು ಅವನ ತಲೆಯನ್ನು ಸೋಂಕಬಾರದು. ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತಿಷ್ಠಿತವಾದ ತನ್ನ ಕಾಲವನ್ನು ಪೂರ್ಣಗೊಳಿಸುವ ತನಕ ಅವನು ಪರಿಶುದ್ಧನಾಗಿರಬೇಕು. ತನ್ನ ವ್ರತದ ದಿನಗಳು ಮುಗಿಯುವ ತನಕ ಅವನು ಕೂದಲನ್ನು ಬೆಳೆಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ಅವನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಹರಕೆ ಮಾಡಿಕೊಂಡ ಕಾಲವೆಲ್ಲಾ, ಯಾವ ಶವದ ಬಳಿಗೆ ಹೋಗಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ಅವನ ತಂದೆ, ತಾಯಿ, ಸಹೋದರ, ಸಹೋದರಿ ಸತ್ತರೂ ಅವನು ಅವರ ಹೆಣವನ್ನು ಮುಟ್ಟಬಾರದು. ಮುಟ್ಟಿದರೆ ಅವನು ಅಶುದ್ಧನಾಗುವನು. ದೇವರಿಗೋಸ್ಕರ ಮೀಸಲಾಗಿರುವ ಅವನ ಕೂದಲು ಅವನ ತಲೆಯನ್ನು ಮುಚ್ಚಿಕೊಂಡಿರುತ್ತದೆ; ಆದ್ದರಿಂದ ಅವನು ಪರಿಶುದ್ಧನಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ಅವನು ತನ್ನನ್ನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ದಿನಗಳಲ್ಲೆಲ್ಲಾ ಅವನು ಯೆಹೋವನಿಗೆ ಪವಿತ್ರನಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","ಯಾವನಾದರೂ ಇದ್ದಕ್ಕಿದ್ದಂತೆ ಅವನ ಬಳಿಯಲ್ಲೇ ಸತ್ತದ್ದರಿಂದ ತಾನು ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡ ತಲೆಕೂದಲು ಅಪವಿತ್ರವಾದರೆ ಏಳನೆಯ ದಿನದಲ್ಲಿ ತಲೆಯನ್ನು ಕ್ಷೌರ ಮಾಡಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ಬಳಿಕ ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಅವನು ಎರಡು ಕಾಡು ಪಾರಿವಾಳವನ್ನಾಗಲಿ ಎರಡು ಪಾರಿವಾಳದ ಮರಿಗಳನ್ನಾಗಲಿ ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದ ಬಳಿಯಿರುವ ಯಾಜಕನಿಗೆ ತಂದುಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ಆಗ ಯಾಜಕನು ಒಂದನ್ನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿಯೂ ಇನ್ನೊಂದನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿಯೂ ಅರ್ಪಿಸುವನು. ಅವನಿಗೆ ಹೆಣವು ಸೋಂಕಿ ಅವನು ಅಶುದ್ಧನಾದದ್ದರಿಂದ ಈ ಸರ್ವಾಂಗಹೋಮವು ಅವನಿಗೆ ಪ್ರಾಯಶ್ಚಿತ್ತ ಯಜ್ಞವಾಗಿದೆ. ಆ ಸಮಯದಲ್ಲಿ, ಅವನು ತನ್ನ ತಲೆಯ ಕೂದಲನ್ನು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಮತ್ತೆ ಹರಕೆ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ಅವನು ಮತ್ತೊಮ್ಮೆ ನಿರ್ದಿಷ್ಟ ಕಾಲದವರೆಗೆ ತನ್ನನ್ನು ಯೆಹೋವನಿಗೆ ಪ್ರತಿಷ್ಠಿಸಿಕೊಳ್ಳಬೇಕೆಂಬುದೇ ಇದರರ್ಥ. ಅವನು ಒಂದು ವರ್ಷದ ಕುರಿಮರಿಯನ್ನು ತಂದು ಅದನ್ನು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಕೊಡಬೇಕು. ಶವವು ಅವನನ್ನು ಅಶುದ್ಧನನ್ನಾಗಿ ಮಾಡಿದ್ದರಿಂದ ಮೊದಲಿನ ದಿನಗಳು ಲೆಕ್ಕಿಸಲ್ಪಡುವುದಿಲ್ಲ. ಅವನು ಮತ್ತೊಮ್ಮೆ ಪ್ರತಿಷ್ಠೆಯನ್ನು ಹೊಸದಾಗಿ ಆರಂಭಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ನಾಜೀರನು ತನ್ನ ವ್ರತದ ದಿನಗಳು ಮುಗಿದ ನಂತರ, ಮಾಡಬೇಕಾದ ಕ್ರಮ: ಅವನು ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದ ಬಳಿಗೆ ಬಂದು ");
INSERT INTO kan2010_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ಯೆಹೋವನಿಗೆ ತನ್ನ ಸಮರ್ಪಣೆಯನ್ನು ಮಾಡಬೇಕು. ಅವನು ಸಮರ್ಪಿಸಬೇಕಾದದು ಯಾವುವೆಂದರೆ, ಸರ್ವಾಂಗಹೋಮಕ್ಕೆ ದೋಷವಿಲ್ಲದ ಒಂದು ವರ್ಷದ ಗಂಡು ಕುರಿಮರಿ, ದೋಷಪರಿಹಾರ ಯಜ್ಞಕ್ಕಾಗಿ ಯಾವ ದೋಷವಿಲ್ಲದ ಒಂದು ವರ್ಷದ ಹೆಣ್ಣು ಕುರಿಮರಿ, ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಯಾವ ದೋಷವಿಲ್ಲದ ಒಂದು ಟಗರು ಇವೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ಶುದ್ಧವಾದ ಹಿಟ್ಟಿನಿಂದ ಮತ್ತು ಎಣ್ಣೆಯಿಂದ ಮಾಡಿದ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳನ್ನೂ ಎಣ್ಣೆಹಾಕಿ ಮಾಡಿದ ಹುಳಿಯಿಲ್ಲದ ತೆಳುವಾದ ರೊಟ್ಟಿಗಳನ್ನೂ ಒಂದು ಪುಟ್ಟಿತುಂಬಾ ಸಮರ್ಪಿಸಬೇಕು; ಅಲ್ಲದೆ ಮೇಲೆ ವಿವರಿಸಿದ ಯಜ್ಞಗಳೊಡನೆ ಕೊಡಬೇಕಾದ ಧಾನ್ಯದ್ರವ್ಯಗಳನ್ನೂ ಪಾನದ್ರವ್ಯಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ಬಳಿಕ ಯಾಜಕನು ಇವುಗಳನ್ನು ಯೆಹೋವನ ಬಳಿಗೆ ತಂದು ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವನ್ನೂ ಸರ್ವಾಂಗಹೋಮವನ್ನೂ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ಯಾಜಕನು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯಿರುವ ಪುಟ್ಟಿಯನ್ನು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವನು. ಬಳಿಕ ಅವನು ಟಗರನ್ನು ವಧಿಸಿ ಸಮಾಧಾನಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸುವನು. ಅವನು ಅದನ್ನು ಧಾನ್ಯಸಮರ್ಪಣೆ ಮತ್ತು ಪಾನದ್ರವ್ಯ ಸಮರ್ಪಣೆಯೊಂದಿಗೆ ಅರ್ಪಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ನಾಜೀರವ್ರತವನ್ನು ಆಚರಿಸುತ್ತಿರುವವನು ಯೆಹೋವನಿಗಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿದ್ದ ತಲೆಯ ಕೂದಲನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದ ಬಳಿ ಕ್ಷೌರಮಾಡಿಸಿಕೊಳ್ಳಬೇಕು. ಆ ಕೂದಲನ್ನು ಸಮಾಧಾನಯಜ್ಞದ್ರವ್ಯಗಳ ಕೆಳಗಿರುವ ಬೆಂಕಿಯಲ್ಲಿ ಹಾಕಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ನಾಜೀರನು ತನ್ನ ತಲೆಕೂದಲನ್ನು ಕ್ಷೌರಮಾಡಿಸಿಕೊಂಡ ನಂತರ, ಯಾಜಕನು ಅವನಿಗೆ ಆ ಟಗರಿನ ಬೆಂದ ಮುಂದೊಡೆಯನ್ನೂ ಪುಟ್ಟಿಯಲ್ಲಿನ ಒಂದು ಹುಳಿಯಿಲ್ಲದ ಸಿಹಿರೊಟ್ಟಿಯನ್ನೂ ಒಂದು ಹುಳಿಯಿಲ್ಲದ ತೆಳುವಾದ ರೊಟ್ಟಿಯನ್ನೂ ಅವನ ಕೈಯಲ್ಲಿ ಇಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ನೈವೇದ್ಯವಾಗಿ ಅದನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ವಿಶೇಷ ಕಾಣಿಕೆಯಾಗಿ ನಿವಾಳಿಸಬೇಕು. ಇವುಗಳು ಪವಿತ್ರವಾಗಿದ್ದು ಯಾಜಕರ ಪಾಲಾಗುತ್ತವೆ. ಅಲ್ಲದೆ ಮೀಸಲಾಗಿಟ್ಟಿರುವ ನಿವಾಳಿಸಲ್ಪಟ್ಟ ಕಾಣಿಕೆಯ ಎದೆಯ ಭಾಗ ಮತ್ತು ತೊಡೆಯ ಭಾಗ ಸಹ ಯಾಜಕನ ಭಾಗವಾಗಿರುತ್ತದೆ. ಇದರ ನಂತರ ನಾಜೀರನು ದ್ರಾಕ್ಷಾರಸವನ್ನು ಕುಡಿಯಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ಇದೇ ನಾಜೀರರ ವ್ರತವಿಧಿ. ಅವರು ತಮ್ಮ ವ್ರತ ಪೂರ್ತಿಗಾಗಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಕಾಣಿಕೆ ಇದೇ. ಅವರು ತಮ್ಮ ಶಕ್ತಿಮೀರಿ ಕೊಡಬಹುದು. ಆದರೆ ತಾವು ಕೊಡುತ್ತೇವೆಂದು ಹರಕೆ ಮಾಡಿದಷ್ಟನ್ನು ವ್ರತವಿಧಿಗನುಸಾರವಾಗಿ ಕೊಡಲೇಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“ನೀನು ಆರೋನನಿಗೂ ಅವನ ಪುತ್ರರಿಗೂ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು: ನೀವು ಇಸ್ರೇಲರನ್ನು ಆಶೀರ್ವದಿಸುವಾಗ ಈ ಪ್ರಕಾರ ಹೇಳಬೇಕು: ");
INSERT INTO kan2010_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸಿ ಕಾಪಾಡಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ಕನಿಕರದಿಂದ ನೋಡಿ ನಿಮ್ಮ ಮೇಲೆ ದಯವಿಡಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ಯೆಹೋವನು ನಿಮ್ಮ ಮೇಲೆ ಕೃಪಾಕಟಾಕ್ಷವಿಟ್ಟು ಶಾಂತಿಯನ್ನು ಅನುಗ್ರಹಿಸಲಿ.’ ");
INSERT INTO kan2010_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ಬಳಿಕ ಯೆಹೋವನು, “ಹೀಗೆ ಆರೋನನೂ ಅವನ ಪುತ್ರರೂ ಇಸ್ರೇಲರನ್ನು ನನ್ನ ಹೆಸರಿನಿಂದ ಆಶೀರ್ವದಿಸುವುದರಿಂದ ನಾನು ಅವರನ್ನು ಆಶೀರ್ವದಿಸುವೆನು” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ಮೋಶೆ ಪವಿತ್ರಗುಡಾರದ ನಿರ್ಮಾಣ ಕಾರ್ಯವನ್ನು ಪೂರ್ಣಗೊಳಿದ ಮೇಲೆ ಅದನ್ನು ಅದರ ವಸ್ತುಗಳೊಡನೆ, ಯಜ್ಞವೇದಿಕೆಯೊಡನೆ ಮತ್ತು ಅದರ ಎಲ್ಲಾ ಉಪಕರಣಗಳೊಡನೆ ಯೆಹೋವನಿಗಾಗಿ ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಿದನು. ಇವು ಯೆಹೋವನ ಆರಾಧನೆಗಾಗಿ ಮಾತ್ರ ಉಪಯೋಗಿಸಲ್ಪಡುತ್ತವೆಂದು ಹೀಗೆ ಪ್ರತ್ಯೇಕಿಸಲ್ಪಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ಬಳಿಕ ಇಸ್ರೇಲಿನ ಪ್ರಧಾನ ಪುರುಷರು, ಅವರ ಕುಟುಂಬಗಳ ನಾಯಕರು ಅಂದರೆ ಜನಗಣತಿಯ ಮೇಲ್ವಿಚಾರಣೆಯನ್ನು ಸಹ ವಹಿಸಿಕೊಂಡಿದ್ದ ");
INSERT INTO kan2010_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ಗೋತ್ರಪ್ರಧಾನರು ಮುಂದೆ ಬಂದು, ತಮ್ಮ ಕಾಣಿಕೆಗಳನ್ನು ಸಮರ್ಪಿಸಿದರು. ಇಬ್ಬಿಬ್ಬರು ಆರು ಕಮಾನು ಬಂಡಿಗಳನ್ನೂ ಅವುಗಳನ್ನು ಎಳೆಯುವುದಕ್ಕೆ ಆರು ಜೊತೆ ಎತ್ತುಗಳನ್ನೂ ಕೊಟ್ಟರು. ಪ್ರಧಾನರು ಇವುಗಳನ್ನು ಪವಿತ್ರಗುಡಾರದಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಒಪ್ಪಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ಪ್ರಧಾನರಿಂದ ಈ ಕಾಣಿಕೆಗಳನ್ನು ಸ್ವೀಕರಿಸು. ಇವು ದೇವದರ್ಶನಗುಡಾರದ ವರ್ಗಾವಣೆಗೆ ಉಪಯೋಗಿಸಲ್ಪಡಲಿ. ಇವುಗಳನ್ನು ಲೇವಿಯರಿಗೆ ಕೊಡು. ಅವರು ತಮ್ಮ ಕೆಲಸಗಳನ್ನು ಮಾಡಲು ಇದು ಸಹಾಯ ಮಾಡುವುದು.” ");
INSERT INTO kan2010_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ಆದ್ದರಿಂದ ಮೋಶೆಯು ಆ ಬಂಡಿಗಳನ್ನೂ ಎತ್ತುಗಳನ್ನೂ ಸ್ವೀಕರಿಸಿ ಅವುಗಳನ್ನು ಲೇವಿಯರಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ಅವನು ಗೇರ್ಷೋನ್ ಗೋತ್ರಪುರುಷರಿಗೆ ಅವರ ಕೆಲಸಕ್ಕೆ ಅಗತ್ಯವಾಗಿದ್ದ ಎರಡು ಬಂಡಿಗಳನ್ನು ಮತ್ತು ಎರಡು ಜೊತೆ ಎತ್ತುಗಳನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ಬಳಿಕ ಮೆರಾರೀಯರ ಕೆಲಸಕ್ಕೆ ಬೇಕಾಗಿದ್ದ ನಾಲ್ಕು ಬಂಡಿಗಳನ್ನೂ ನಾಲ್ಕು ಜೊತೆ ಎತ್ತುಗಳನ್ನೂ ಅವರಿಗೆ ಕೊಟ್ಟನು. ಇವರೆಲ್ಲರು ಮಾಡುವ ಕೆಲಸಕ್ಕೆ ಯಾಜಕನಾದ ಆರೋನನ ಮಗನಾದ ಈತಾಮಾರನು ಮೇಲ್ವಿಚಾರಕನಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ಮೋಶೆಯು ಕೆಹಾತ್ಯರಿಗೆ ಎತ್ತುಗಳನ್ನಾಗಲಿ ಬಂಡಿಗಳನ್ನಾಗಲಿ ಕೊಡಲಿಲ್ಲ. ಯಾಕೆಂದರೆ ಅವರು ಪವಿತ್ರವಸ್ತುಗಳನ್ನು ತಮ್ಮ ಭುಜದ ಮೇಲೆ ಹೊರಬೇಕು. ಅವರಿಗೆ ಈ ಕೆಲಸವು ಕೊಡಲ್ಪಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ವೇದಿಕೆಯು ಅಭಿಷೇಕಿಸಲ್ಪಟ್ಟಾಗ, ಯಜ್ಞವೇದಿಕೆಯ ಆರಂಭಕ್ಕಾಗಿ ಪ್ರಧಾನರು ಸಹ ತಮ್ಮ ಕಾಣಿಕೆಗಳನ್ನು ವೇದಿಕೆಯ ಮುಂದೆ ತಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಪ್ರತಿದಿನ ಒಬ್ಬ ಪ್ರಧಾನನು ವೇದಿಕೆಯ ಪ್ರತಿಷ್ಠೆಗಾಗಿ ತನ್ನ ಕಾಣಿಕೆಯನ್ನು ತರಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","ಹನ್ನೆರಡು ಪ್ರಧಾನರಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ತನ್ನ ಕಾಣಿಕೆಯನ್ನು ತಂದನು. ಅವರು ಕೊಟ್ಟ ಕಾಣಿಕೆಗಳು ಹೀಗಿವೆ: ಪ್ರತಿಯೊಬ್ಬ ಪ್ರಧಾನನು ಮೂರುಕಾಲು ಪೌಂಡು ತೂಕವುಳ್ಳ ಬೆಳ್ಳಿಯ ತಟ್ಟೆಯನ್ನೂ ಒಂದು ಮುಕ್ಕಾಲು ಪೌಂಡು ತೂಕವುಳ್ಳ ಬೆಳ್ಳಿಯ ಬಟ್ಟಲನ್ನೂ ತಂದನು. ಇವೆರಡನ್ನೂ ಅಧಿಕೃತ ಅಳತೆಯಿಂದ ತೂಕ ಮಾಡಲಾಯಿತು. ಧಾನ್ಯಸಮರ್ಪಣೆಗಾಗಿ ಉಪಯೋಗವಾಗುವ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಶ್ರೇಷ್ಠ ಗೋಧಿಹಿಟ್ಟನ್ನು ಬಟ್ಟಲಲ್ಲಿ ಮತ್ತು ತಟ್ಟೆಯಲ್ಲಿ ತುಂಬಿಡಲಾಗಿತ್ತು. ಧೂಪದ್ರವ್ಯ ತುಂಬಿದ್ದ ನಾಲ್ಕು ತೊಲೆ ತೂಕವುಳ್ಳ ಚಿನ್ನದ ಧೂಪಾರತಿಯನ್ನೂ ಒಂದು ಎಳೆಯ ಹೋರಿಯನ್ನೂ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಒಂದು ವರ್ಷದ ಗಂಡು ಕುರಿಮರಿಯನ್ನೂ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿ ಎರಡು ಎತ್ತುಗಳನ್ನೂ ಐದು ಟಗರುಗಳನ್ನೂ ಐದು ಹೋತಗಳನ್ನೂ ಒಂದು ವರ್ಷದ ಐದು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನೂ ಪ್ರತಿಯೊಬ್ಬ ಯಾಜಕನೂ ತಂದನು. ಇವೆಲ್ಲವೂ ಯಜ್ಞವಾಗಿ ಸಮರ್ಪಿಸಲ್ಪಟ್ಟವು. ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೂದ ಕುಲಾಧಿಪತಿ ಅಮ್ಮೀನಾದ್ವಾನ ಮಗನಾದ ನಹಶೋನನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಎರಡನೆಯ ದಿನದಲ್ಲಿ ಇಸ್ಸಾಕಾರ್ ಕುಲಾಧಿಪತಿ ಚೂವಾರನ ಮಗನಾದ ನೆತನೇಲನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಜೆಬುಲೂನ್ ಕುಲಾಧಿಪತಿ ಹೇಲೋನನ ಮಗನಾದ ಎಲೀಯಾಬನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ನಾಲ್ಕನೆಯ ದಿನದಲ್ಲಿ ರೂಬೇನ್ ಕುಲಾಧಿಪತಿ ಶೆದೇಯೂರನ ಮಗನಾದ ಎಲೀಚೂರನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಐದನೆಯ ದಿನದಲ್ಲಿ ಸಿಮೆಯೋನ್ ಕುಲಾಧಿಪತಿ ಚೂರೀಷದ್ದೈಯ ಮಗನಾದ ಶೆಲುಮೀಯೇಲನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಆರನೆಯ ದಿನದಲ್ಲಿ ಗಾದ್ ಕುಲಾಧಿಪತಿ ದೆಗೂವೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಏಳನೆಯ ದಿನದಲ್ಲಿ ಎಫ್ರಾಯೀಮ್ ಕುಲಾಧಿಪತಿ ಅಮ್ಮೀಹೂದನ ಮಗನಾದ ಎಲೀಷಾಮನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಮನಸ್ಸೆ ಕುಲಾಧಿಪತಿ ಪೆದಾಚೂರನ ಮಗನಾದ ಗಮ್ಲೀಯೇಲನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಒಂಭತ್ತನೆಯ ದಿನದಲ್ಲಿ ಬೆನ್ಯಾಮೀನ್ ಕುಲಾಧಿಪತಿ ಗಿದ್ಯೋನಿಯ ಮಗನಾದ ಅಬೀದಾನನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ದಾನ್ ಕುಲಾಧಿಪತಿ ಅಮ್ಮೀಷದ್ದೈನ ಮಗನಾದ ಅಹೀಗೆಜರನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಹನ್ನೊಂದನೆಯ ದಿನದಲ್ಲಿ ಆಶೇರ್ ಕುಲಾಧಿಪತಿ ಒಕ್ರಾನನ ಮಗನಾದ ಪಗೀಯೇಲನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ಹನ್ನೆರಡನೆಯ ದಿನದಲ್ಲಿ ನಫ್ತಾಲಿ ಕುಲಾಧಿಪತಿ ಏನಾನನ ಮಗನಾದ ಅಹೀರನು ತನ್ನ ಕಾಣಿಕೆಗಳನ್ನು ತಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ಇವೆಲ್ಲವೂ ಇಸ್ರೇಲರ ಪ್ರಧಾನರು ತಂದ ಕಾಣಿಕೆಗಳು. ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಿದಾಗ ಯಜ್ಞವೇದಿಕೆಗೋಸ್ಕರ ಅವರು ಕೊಟ್ಟ ಕಾಣಿಕೆಗಳು ಇವುಗಳೇ. ಅವರು ಹನ್ನೆರಡು ಬೆಳ್ಳಿಯ ತಟ್ಟೆಗಳನ್ನೂ ಹನ್ನೆರಡು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲುಗಳನ್ನೂ ಹನ್ನೆರಡು ಚಿನ್ನದ ಧೂಪಾರತಿಗಳನ್ನೂ ತಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ಪ್ರತಿಯೊಂದು ಬೆಳ್ಳಿಯ ತಟ್ಟೆಯ ತೂಕ ಸುಮಾರು ಮೂರುಕಾಲು ಪೌಂಡುಗಳು, ಪ್ರತಿ ಬಟ್ಟಲು ಸುಮಾರು ಮೂರುಮುಕ್ಕಾಲು ಪೌಂಡು ತೂಕವುಳ್ಳದ್ದಾಗಿದ್ದವು. ಬೆಳ್ಳಿಯ ತಟ್ಟೆಗಳು ಮತ್ತು ಬೆಳ್ಳಿಯ ಬಟ್ಟಲುಗಳು ಒಟ್ಟಿಗೆ ಅಧಿಕೃತ ಅಳತೆಯ ಪ್ರಕಾರ ಅರವತ್ತು ಪೌಂಡುಗಳಷ್ಟು ತೂಕವಾಗಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ಧೂಪವುಳ್ಳ ಹನ್ನೆರಡು ಚಿನ್ನದ ಧೂಪಾರತಿಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದು ಧೂಪಾರತಿ ಅಧಿಕೃತ ಅಳತೆಯ ಪ್ರಕಾರ ಹತ್ತು ತೊಲೆ ತೂಕವುಳ್ಳದ್ದಾಗಿತ್ತು. ಹನ್ನೆರಡು ಚಿನ್ನದ ಧೂಪಾರತಿಗಳು ಒಟ್ಟಿಗೆ ನೂರಿಪ್ಪತ್ತು ತೊಲೆಗಳಷ್ಟು ತೂಕವುಳ್ಳದ್ದಾಗಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಉಪಯೋಗಿಸಲ್ಪಟ್ಟ ಒಟ್ಟು ಪಶುಗಳು: ಹನ್ನೆರಡು ಹೋರಿಗಳು, ಹನ್ನೆರಡು ಟಗರುಗಳು, ಒಂದು ವರ್ಷದ ಎರಡು ಗಂಡು ಕುರಿಮರಿಗಳು. ಆ ಸಮರ್ಪಣೆಗಳೊಂದಿಗೆ ಧಾನ್ಯಸಮರ್ಪಣೆಗಳೂ ಅರ್ಪಿಸಲ್ಪಟ್ಟವು. ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಹನ್ನೆರಡು ಹೋತಗಳು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸಲ್ಪಟ್ಟವು. ");
INSERT INTO kan2010_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ಸಮಾಧಾನಯಜ್ಞಕ್ಕಾಗಿಯೂ ಪ್ರಧಾನರು ಪಶುಗಳನ್ನು ಕೊಟ್ಟರು. ಅವುಗಳ ಒಟ್ಟು ಸಂಖ್ಯೆ ಇಪ್ಪತ್ನಾಲ್ಕು ಹೋರಿಗಳು, ಅರವತ್ತು ಟಗರುಗಳು, ಅರವತ್ತು ಹೋತಗಳು, ಒಂದು ವರ್ಷದ ಅರವತ್ತು ಗಂಡು ಕುರಿಮರಿಗಳು. ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಅಭಿಷೇಕಿಸಿ ಪ್ರತಿಷ್ಠಿಸಿದಾಗ ಅದಕೋಸ್ಕರ ಅವರು ಕೊಟ್ಟ ಕಾಣಿಕೆಗಳು ಇವೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ಮೋಶೆ ಯೆಹೋವನ ಸಂಗಡ ಮಾತಾಡಲು ದೇವದರ್ಶನಗುಡಾರದೊಳಗೆ ಹೋದಾಗ, ಒಡಂಬಡಿಕೆಯ ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಯ ಹೊದಿಕೆಯ ಮೇಲಿದ್ದ ಎರಡು ಕೆರೂಬಿಗಳ ಮಧ್ಯದಿಂದ ಯೆಹೋವನ ಸ್ವರವು ಮೋಶೆಗೆ ಕೇಳಿಸಿತು. ಹೀಗೆ ಆತನು ಅವನ ಸಂಗಡ ಮಾತಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“ಆರೋನನು ಪವಿತ್ರಗುಡಾರದಲ್ಲಿ ದೀಪಸ್ತಂಭದ ಮೇಲಿನ ದೀಪಗಳನ್ನು ಕ್ರಮಪಡಿಸಲು ಹೇಳು. ಆಗ ದೀಪಸ್ತಂಭದ ಮುಂದಿನ ಸ್ಥಳದಲ್ಲಿ ಬೆಳಕು ಪ್ರಕಾಶಿಸುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ಅಂತೆಯೇ ಆರೋನನು ಮಾಡಿದನು. ಆರೋನನು ದೀಪಗಳನ್ನು ಸರಿಯಾದ ಸ್ಥಳದಲ್ಲಿಟ್ಟು ಅವುಗಳು ದೀಪಸ್ತಂಭದ ಎದುರಿನಲ್ಲಿ ಪ್ರಕಾಶಿಸುವಂತೆ ಮಾಡಿದನು. ಹೀಗೆ ಯೆಹೋವನು ಹೇಳಿದಂತೆಯೇ ಮೋಶೆಯು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ಆ ದೀಪಸ್ತಂಭವನ್ನು ಅದರ ಬುಡದಿಂದ ಪುಷ್ಪಾಲಂಕಾರಗಳವರೆಗೂ ಸಂಪೂರ್ಣವಾಗಿ ಚಿನ್ನದ ತಗಡಿನಿಂದ ಮಾಡಲಾಗಿತ್ತು. ಯೆಹೋವನು ಮೋಶೆಗೆ ತೋರಿಸಿದ ಮಾದರಿಯಂತೆ ಅದು ಮಾಡಲ್ಪಟ್ಟಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ಇಸ್ರೇಲರಿಂದ ಲೇವಿಯರನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ ಶುದ್ಧೀಕರಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ಅವರನ್ನು ಶುದ್ಧೀಕರಿಸುವ ಕ್ರಮ ಹೇಗೆಂದರೆ, ನೀನು ಅವರ ಮೇಲೆ ದೋಷಪರಿಹಾರಕ ಜಲವನ್ನು ಚಿಮಿಕಿಸಬೇಕು. ಬಳಿಕ ಅವರು ಸರ್ವಾಂಗಕ್ಷೌರ ಮಾಡಿಸಿಕೊಂಡು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಹೀಗೆ ತಮ್ಮನ್ನು ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","“ತರುವಾಯ ಲೇವಿಯರು ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಎಳೆಹೋರಿಯನ್ನು ಮತ್ತು ಅದರೊಡನೆ ಸಮರ್ಪಿಸಬೇಕಾದ ಧಾನ್ಯಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಗೋಧಿಯಹಿಟ್ಟನ್ನು ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು; ನೀನು ಅವರಿಂದ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಮತ್ತೊಂದು ಎಳೆಹೋರಿಯನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ಲೇವಿಯರನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಮುಂಭಾಗಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬಂದು ಇಸ್ರೇಲರನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ನೀನು ಲೇವಿಯರನ್ನು ಯೆಹೋವನ ಮುಂದೆ ಕರೆದುಕೊಂಡು ಬಂದಾಗ ಇಸ್ರೇಲರು ತಮ್ಮ ಕೈಗಳನ್ನು ಅವರ ತಲೆಯ ಮೇಲಿಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ಆಗ ಆರೋನನು ಲೇವಿಯರನ್ನು ಯೆಹೋವನಿಗೆ ಇಸ್ರೇಲರ ಕಾಣಿಕೆಯಾಗಿ ಕೊಡುವನು. ಈ ರೀತಿಯಾಗಿ ಲೇವಿಯರು ಯೆಹೋವನ ಪರಿಚರ್ಯ ಕೆಲಸಕ್ಕಾಗಿ ಸಿದ್ಧರಾಗುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“ಲೇವಿಯರು ಆ ಹೋರಿಗಳ ತಲೆಯ ಮೇಲೆ ತಮ್ಮ ಕೈಗಳನ್ನಿಟ್ಟ ನಂತರ, ನೀನು ಯೆಹೋವನಿಗೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಇನ್ನೊಂದು ಹೋರಿಯನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ಇವು ಲೇವಿಯರಿಗೆ ನೈವೇದ್ಯದ ಸಮರ್ಪಣೆಗಳಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ಈ ರೀತಿಯಲ್ಲಿ ನೀನು ಲೇವಿಯರನ್ನು ಆರೋನ ಮತ್ತು ಅವನ ಪುತ್ರರ ಅಧೀನದಲ್ಲಿ ಸೇವೆ ಮಾಡುವಂತೆ ಮಾಡುವೆ ಮತ್ತು ಲೇವಿಯರನ್ನು ಯೆಹೋವನಿಗೆ ವಿಶೇಷ ಕೊಡುಗೆಯಾಗಿ ಸಲ್ಲಿಸುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ನೀನು ಲೇವಿಯರನ್ನು ಇತರ ಇಸ್ರೇಲರಿಂದ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ಲೇವಿಯರು ನನ್ನ ಆಸ್ತಿಯಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“ನೀನು ಲೇವಿಯರನ್ನು ಶುದ್ಧೀಕರಿಸಿ ಅವರನ್ನು ವಿಶೇಷ ಕೊಡುಗೆಯಾಗಿ ನನಗೆ ಕೊಟ್ಟ ಮೇಲೆ, ಅವರು ಬಂದು ದೇವದರ್ಶನಗುಡಾರದ ಕೆಲಸವನ್ನು ಮಾಡಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ಯಾಕೆಂದರೆ ಲೇವಿಯರು ಇಸ್ರೇಲರ ಮಧ್ಯದಿಂದ ನನಗಾಗಿ ಸಂಪೂರ್ಣವಾಗಿ ಪ್ರತಿಷ್ಠಿತರಾಗಿದ್ದಾರೆ. ಇಸ್ರೇಲರ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳಿಗೆ ಬದಲಾಗಿ ನಾನು ಇವರನ್ನೇ ನನ್ನ ಸ್ವಂತಕ್ಕಾಗಿ ತೆಗೆದುಕೊಂಡಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ಇಸ್ರೇಲರಲ್ಲಿ ಚೊಚ್ಚಲಾದ ಮನುಷ್ಯರೂ ಪಶುಗಳೂ ನನ್ನ ಸ್ವತ್ತಾಗಿರುವರು. ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿದ್ದ ಚೊಚ್ಚಲಾದದ್ದನ್ನೆಲ್ಲ ನಾನು ಸಂಹರಿಸಿದಾಗ ಇಸ್ರೇಲರ ಚೊಚ್ಚಲಾದದ್ದನ್ನು ನನ್ನ ಸ್ವಂತಕ್ಕಾಗಿ ಪ್ರತಿಷ್ಠಿಸಿಕೊಂಡೆನಲ್ಲಾ. ");
INSERT INTO kan2010_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ಆದರೆ ಈಗ ನಾನು ಇಸ್ರೇಲರ ಚೊಚ್ಚಲು ಗಂಡುಮಕ್ಕಳಿಗೆ ಬದಲಾಗಿ ಲೇವಿಯರನ್ನು ತೆಗೆದುಕೊಳ್ಳುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ಇಸ್ರೇಲರ ಮಧ್ಯದಿಂದ ನಾನು ಲೇವಿಯರನ್ನು ಆರಿಸಿಕೊಂಡಿದ್ದೇನೆ ಮತ್ತು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಇಸ್ರೇಲರ ಪರವಾಗಿ ಕೆಲಸ ಮಾಡಲೂ ಮತ್ತು ಇಸ್ರೇಲರಿಗೆ ದೋಷಪರಿಹಾರ ಮಾಡುವುದಕ್ಕೂ ನಾನು ಅವರನ್ನು ಆರೋನ ಮತ್ತು ಅವನ ಪುತ್ರರಿಗೆ ಒಪ್ಪಿಸಿಕೊಟ್ಟಿದ್ದೇನೆ. ಇಸ್ರೇಲರನ್ನು ಶುದ್ಧಿಗೊಳಿಸುವ ಯಜ್ಞಗಳನ್ನು ಸಮರ್ಪಿಸುವುದಕ್ಕೆ ಅವರು ಸಹಾಯ ಮಾಡುವರು. ಹೀಗಿರುವುದರಿಂದ ಇಸ್ರೇಲರು ಪವಿತ್ರವಸ್ತುಗಳ ಅತೀ ಸಮೀಪಕ್ಕೆ ಬಂದರೂ ಅವರಿಗೆ ಅಪಾಯವು ಸಂಭವಿಸುವುದಿಲ್ಲ.” ");
INSERT INTO kan2010_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ಯೆಹೋವನು ಲೇವಿಯರ ವಿಷಯದಲ್ಲಿ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಮೋಶೆ ಆರೋನರೂ ಇಸ್ರೇಲರ ಸಮೂಹದವರೆಲ್ಲರೂ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ಲೇವಿಯರು ತಮ್ಮನ್ನು ಶುದ್ಧಮಾಡಿಕೊಂಡು ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡರು. ಬಳಿಕ ಆರೋನನು ಅವರನ್ನು ಯೆಹೋವನಿಗೆ ವಿಶೇಷ ಕೊಡುಗೆಯಾಗಿ ಕೊಟ್ಟನು. ಆರೋನನು ಅವರನ್ನು ಶುದ್ಧೀಕರಿಸುವುದಕ್ಕಾಗಿ ದೋಷಪರಿಹಾರ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ಆಗ ಲೇವಿಯರು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಆರೋನನ ಮತ್ತು ಅವನ ಪುತ್ರರ ಮೇಲ್ವಿಚಾರಣೆಯಲ್ಲಿ ಕೆಲಸ ಮಾಡಲು ಅರ್ಹರಾದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಲೇವಿಯರ ಬಗ್ಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಂತೆಯೇ ಅವರಿಗೆ ಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ಲೇವಿಯರು ಅನುಸರಿಸಬೇಕಾದ ಪದ್ಧತಿ ಏನೆಂದರೆ: ಲೇವಿಯರಲ್ಲಿ ಇಪ್ಪತ್ತೈದು ವರ್ಷಕ್ಕಿಂತ ಹೆಚ್ಚು ವಯಸ್ಸಾಗಿರುವ ಗಂಡಸರು ದೇವದರ್ಶನಗುಡಾರದ ಸೇವೆಯ ದಳದಲ್ಲಿ ಕೆಲಸಮಾಡಲು ಯೋಗ್ಯರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ಅವರ ವಯಸ್ಸು ಐವತ್ತು ವರ್ಷವಾದ ನಂತರ ಸೇವೆಯಿಂದ ನಿವೃತ್ತರಾಗಬೇಕು; ಪವಿತ್ರ ಗುಡಾರವನ್ನು ವರ್ಗಾವಣೆ ಮಾಡುವ ಭಾರವಾದ ಕೆಲಸವನ್ನು ಅವರೆಂದಿಗೂ ಮಾಡಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ಅವರು ಕಾವಲುಗಾರರಾಗಿ ದೇವದರ್ಶನಗುಡಾರದ ಬಳಿ ಇತರ ಲೇವಿಯರಿಗೆ ಸಹಾಯ ಮಾಡಬಹುದೇ ಹೊರತು ಭಾರವಾದ ಕೆಲಸವನ್ನು ಮಾಡಲೇಕೂಡದು. ನೀನು ಈ ರೀತಿಯಲ್ಲಿ ಲೇವಿಯರಿಗೆ ಕೆಲಸವನ್ನು ಹಂಚಿಕೊಡಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ಇಸ್ರೇಲರು ಈಜಿಪ್ಟ್ ದೇಶವನ್ನು ಬಿಟ್ಟುಬಂದ ನಂತರ ಎರಡನೆ ವರ್ಷದ ಮೊದಲನೆಯ ತಿಂಗಳಲ್ಲಿ ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿದನು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ಇಸ್ರೇಲರು ನೇಮಕವಾದ ಕಾಲದಲ್ಲಿ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ಅವರು ಈ ತಿಂಗಳ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ನಸುಸಂಜೆಯ ವೇಳೆ ಪಸ್ಕದ ಊಟವನ್ನು ಮಾಡಬೇಕು. ಅವರು ಇದನ್ನು ಪಸ್ಕಹಬ್ಬದ ಎಲ್ಲಾ ನಿಯಮಗಳ ಪ್ರಕಾರ ನೇಮಕವಾದ ಕಾಲದಲ್ಲಿ ಮಾಡಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ಆದ್ದರಿಂದ ಮೋಶೆ ಇಸ್ರೇಲರಿಗೆ, ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕೆಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ಜನರು ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ನಸುಸಂಜೆಯ ವೇಳೆಯಲ್ಲಿ ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಇದನ್ನು ಆಚರಿಸಿದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಪ್ರತಿಯೊಂದನ್ನೂ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ಆದರೆ ಕೆಲವು ಜನರು ಶವವನ್ನು ಮುಟ್ಟಿದ್ದರಿಂದ ಅಶುದ್ಧರಾಗಿ ಆ ದಿನದಲ್ಲಿ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಲಾಗಲಿಲ್ಲ. ಆದ್ದರಿಂದ ಅವರು ಆ ದಿನ ಮೋಶೆ ಆರೋನರ ಬಳಿಗೆ ಬಂದು, ");
INSERT INTO kan2010_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“ನಾವು ಮನುಷ್ಯ ಶವವನ್ನು ಮುಟ್ಟಿದ್ದರಿಂದ ಅಶುದ್ಧರಾಗಿದ್ದೇವೆ. ಆದರೆ ನೇಮಕವಾದ ಕಾಲದಲ್ಲಿ ಯೆಹೋವನ ಪಸ್ಕಹಬ್ಬದ ಯಜ್ಞವನ್ನು ಇತರ ಇಸ್ರೇಲರೊಡನೆ ಅರ್ಪಿಸುವುದಕ್ಕೆ ಸಾಧ್ಯವಿಲ್ಲವೇ?” ಎಂದು ಕೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ಮೋಶೆಯು ಅವರಿಗೆ, “ಇಲ್ಲೇ ಇರಿ. ಇದರ ವಿಷಯದಲ್ಲಿ ಯೆಹೋವನು ಏನು ಹೇಳುತ್ತಾನೆಂದು ನಾನು ಆತನನ್ನು ವಿಚಾರಿಸುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ನೀನು ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸು: ನಿಮ್ಮಲ್ಲಿಯಾಗಲಿ ನಿಮ್ಮ ಸಂತತಿಯವರಲ್ಲಿಯಾಗಲಿ ಮನುಷ್ಯಶವ ಸೋಂಕಿದ್ದರಿಂದ ಅಶುದ್ಧರಾದವರೂ ದೂರಪ್ರಯಾಣದಲ್ಲಿರುವವರೂ ಸಹ ಯೆಹೋವನ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಲೇಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ಅಂಥವರು ಎರಡನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದ ನಸುಸಂಜೆ ವೇಳೆಯಲ್ಲಿ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕು. ಆ ಸಮಯದಲ್ಲಿ ಅವರು ಪಸ್ಕದ ಕುರಿಮರಿಯ ಮಾಂಸವನ್ನು ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಗಳೊಡನೆ ಮತ್ತು ಕಹಿಯಾದ ಸೊಪ್ಪುಗಳೊಡನೆ ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ಅದರಲ್ಲಿ ಯಾವುದನ್ನೂ ಮರುದಿನದವರೆಗೆ ಇಡಬಾರದು. ಅವರು ಅದೆಲ್ಲವನ್ನು ತಿಂದುಬಿಡಬೇಕು. ಆ ಕುರಿಮರಿಯ ಎಲುಬುಗಳನ್ನು ಮುರಿಯಬಾರದು. ಅವರು ಪಸ್ಕಹಬ್ಬದ ವಿಷಯವಾಗಿ ನೇಮಕವಾಗಿರುವ ನಿಯಮಗಳ ಪ್ರಕಾರವೇ ಅದನ್ನು ಆಚರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ಆದರೆ ಯಾವನಾದರೂ ಶುದ್ಧನಾಗಿದ್ದರೂ ಪ್ರಯಾಣದಲ್ಲಿಲ್ಲದಿದ್ದರೂ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸದಿದ್ದರೆ, ಅವನನ್ನು ಅವನ ಜನರಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ಅವನು ಯೆಹೋವನಿಂದ ನೇಮಕವಾದ ಯಜ್ಞವನ್ನು ಸರಿಯಾದ ಕಾಲದಲ್ಲಿ ಸಮರ್ಪಿಸದೆ ಹೋದದ್ದರಿಂದ ಅವನು ದೋಷಿಯಾಗಿದ್ದಾನೆ ಮತ್ತು ಅವನಿಗೆ ಶಿಕ್ಷೆಯಾಗಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ನಿಮ್ಮಲ್ಲಿ ಪ್ರವಾಸಿಯಾಗಿರುವ ಅನ್ಯದೇಶಸ್ಥನು ಯೆಹೋವನಿಗೆ ಪಸ್ಕಹಬ್ಬವನ್ನು ಆಚರಿಸಬೇಕೆಂದು ಅಪೇಕ್ಷಿಸಿದರೆ, ಅದರ ವಿಷಯವಾದ ನಿಯಮಗಳ ಪ್ರಕಾರವೇ ಅದನ್ನು ಆಚರಿಸಬೇಕು. ಪರದೇಶದವನಿಗೂ ಸ್ವದೇಶದವನಿಗೂ ಒಂದೇ ವಿಧಿಯಿರಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ಇಸ್ರೇಲರು ಒಡಂಬಡಿಕೆಯ ಗುಡಾರವಾದ ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಎತ್ತಿ ನಿಲ್ಲಿಸಿದ ದಿನದಲ್ಲಿ ಮೇಘವು ಅದರ ಮೇಲೆ ಮುಚ್ಚಿಕೊಂಡಿತು ಮತ್ತು ಅದು ರಾತ್ರಿಯಲ್ಲಿ ಬೆಂಕಿಯಂತೆ ಕಾಣಿಸುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ಹೀಗೆ ಮೇಘವು ಯಾವಾಗಲೂ ದೇವದರ್ಶನಗುಡಾರವನ್ನು ಮುಚ್ಚಿಕೊಂಡಿರುವುದು. ರಾತ್ರಿವೇಳೆಯಲ್ಲಿ ಆ ಮೇಘವು ಬೆಂಕಿಯಂತೆ ಕಾಣಿಸುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ಆ ಮೇಘವು ಪವಿತ್ರ ಗುಡಾರದಿಂದ ಮೇಲಕ್ಕೆ ಎದ್ದಾಗಲೆಲ್ಲಾ ಇಸ್ರೇಲರು ಮುಂದಕ್ಕೆ ಪ್ರಯಾಣಮಾಡುವರು. ಆ ಮೇಘವು ನಿಂತಲ್ಲೆಲ್ಲಾ ಇಸ್ರೇಲರು ಪಾಳೆಯ ಮಾಡಿಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ಇಸ್ರೇಲರು ಯೆಹೋವನ ಸೂಚನೆಯನ್ನು ಹೊಂದಿದ ಮೇಲೆ ಪ್ರಯಾಣಮಾಡುವರು. ಆ ಮೋಡವು ಪವಿತ್ರಗುಡಾರದ ಮೇಲಿರುವ ತನಕ ಅವರು ತಾವಿರುವಲ್ಲಿಯೇ ಇರುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ಕೆಲವು ಬಾರಿ ಆ ಮೇಘವು ಬಹುದಿನಗಳವರೆಗೂ ಪವಿತ್ರಗುಡಾರದ ಮೇಲೆ ಇರುವ ಸಂದರ್ಭದಲ್ಲಿ ಇಸ್ರೇಲರು ಯೆಹೋವನಿಗೆ ವಿಧೇಯರಾಗಿ ಮುಂದಕ್ಕೆ ಪ್ರಯಾಣಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ಒಂದೊಂದು ವೇಳೆಯಲ್ಲಿ ಮೇಘವು ಕೆಲವು ದಿವಸ ಮಾತ್ರ ಪವಿತ್ರ ಗುಡಾರದ ಮೇಲೆ ನಿಂತಿರುವುದು. ಯೆಹೋವನ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಅವರು ಇಳಿದುಕೊಳ್ಳುತ್ತಿದ್ದರು ಮತ್ತು ಯೆಹೋವನ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಹೊರಡುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ಕೆಲವು ಸಮಯಗಳಲ್ಲಿ ಮೇಘವು ಸಾಯಂಕಾಲದಿಂದ ಹೊತ್ತಾರೆಯವರೆಗೂ ಇರುತ್ತಿತ್ತು; ಬೆಳಿಗ್ಗೆ ಅದು ಮೇಲಕ್ಕೆ ಎದ್ದಾಗ ಜನರು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದರು. ಮೋಡವು ಚಲಿಸಿದಾಗ ಅದು ಹಗಲಾಗಿರಲಿ ರಾತ್ರಿಯಾಗಿರಲಿ ಜನರು ಅದನ್ನು ಹಿಂಬಾಲಿಸುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ಆ ಮೇಘವು ಪವಿತ್ರಗುಡಾರದ ಮೇಲೆ ಎರಡು ದಿನವಾಗಲಿ ಒಂದು ತಿಂಗಳಾಗಲಿ ಒಂದು ವರ್ಷವಾಗಲಿ ನಿಂತರೆ ಅದು ನಿಂತಿರುವ ತನಕ ಇಸ್ರೇಲರು ಪ್ರಯಾಣ ಮಾಡದೆ ಇಳಿದುಕೊಂಡೇ ಇರುವರು. ಅದು ಮೇಲಕ್ಕೆ ಎದ್ದಾಗ ಅವರು ಹೊರಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ಹೀಗೆ ಯೆಹೋವನ ಸೂಚನೆಯಂತೆ ಜನರು ಪಾಳೆಯ ಮಾಡಿಕೊಳ್ಳುವರು; ಪ್ರಯಾಣ ಮುಂದುವರಿಸುವರು. ಮೋಶೆಯ ಮೂಲಕವಾಗಿ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಜನರು ಯೆಹೋವನ ಸೂಚನೆಗಳನ್ನು ಲಕ್ಷ್ಯವಿಟ್ಟು ಅನುಸರಿಸಿ ನಡೆಯುತ್ತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“ನೀನು ಬೆಳ್ಳಿಯ ತಗಡುಗಳಿಂದ ಎರಡು ತುತ್ತೂರಿಗಳನ್ನು ಮಾಡಿಸಬೇಕು. ಜನಸಮೂಹದವರನ್ನು ಒಟ್ಟಾಗಿ ಕರೆಸುವುದಕ್ಕೂ ಅವರು ಯಾವಾಗ ಹೊರಡಬೇಕೆಂದು ಹೇಳುವುದಕ್ಕೂ ಇವುಗಳನ್ನು ಉಪಯೋಗಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ನೀನು ಎರಡು ತುತ್ತೂರಿಗಳನ್ನು ಲಬುಸ್ವರದಿಂದ ಊದಿಸುವಾಗ ಜನಸಮೂಹದವರೆಲ್ಲರೂ ನಿನ್ನ ಹತ್ತಿರ ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದ ಬಳಿಯಲ್ಲಿ ಕೂಡಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ಆದರೆ ನೀನು ಒಂದು ತುತ್ತೂರಿಯನ್ನು ಮಾತ್ರ ಊದಿಸಿದರೆ ಇಸ್ರೇಲಿನ ಕುಲಪ್ರಧಾನರಾದ ಮುಖ್ಯಸ್ಥರು ಮಾತ್ರ ನಿನ್ನನ್ನು ಸಂಧಿಸಲು ಬರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“ಜನರ ಕುಲಗಳು ಪಾಳೆಯದಿಂದ ಪ್ರಯಾಣ ಮಾಡಬೇಕೆಂಬುದಕ್ಕೆ ಸೂಚನೆಗಾಗಿ ತುತ್ತೂರಿಯನ್ನು ಆರ್ಭಟದಿಂದ ಊದಿಸಬೇಕು. ನೀವು ಮೊದಲನೆ ಸಲ ತುತ್ತೂರಿಯನ್ನು ಆರ್ಭಟದಿಂದ ಊದಿಸುವಾಗ ದೇವದರ್ಶನಗುಡಾರದ ಪೂರ್ವ ದಿಕ್ಕಿನಲ್ಲಿ ಪಾಳೆಯ ಹಾಕಿಕೊಂಡಿರುವ ಕುಲಗಳು ಹೊರಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ನೀವು ಎರಡನೆಯ ಸಲ ತುತ್ತೂರಿಗಳನ್ನು ಆರ್ಭಟ ಸ್ವರದಲ್ಲಿ ಊದಿಸುವಾಗ ದೇವದರ್ಶನಗುಡಾರದ ದಕ್ಷಿಣ ದಿಕ್ಕಿನಲ್ಲಿ ಪಾಳೆಯ ಹಾಕಿಕೊಂಡಿರುವ ಕುಲಗಳು ಹೊರಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ಆದರೆ ಜನಸಮುದಾಯವು ಕೂಡಿಬರಬೇಕಾದಾಗ ತುತ್ತೂರಿಗಳನ್ನು ಲಬುಸ್ವರದಲ್ಲಿ ಊದಿಸಬೇಕೇ ಹೊರತು ಆರ್ಭಟ ಸ್ವರದಲ್ಲಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ಯಾಜಕರಾದ ಆರೋನನ ಪುತ್ರರು ಮಾತ್ರವೇ ಆ ತುತ್ತೂರಿಗಳನ್ನು ಊದಬೇಕು. ಇದು ನಿಮಗೂ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತ ನಿಯಮ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“ನೀವು ಸ್ವದೇಶವನ್ನು ಸೇರಿದ ಮೇಲೆ ನಿಮ್ಮ ಶತ್ರುಗಳನ್ನು ಎದುರಿಸುವುದಕ್ಕಾಗಿ ಯುದ್ಧಕ್ಕೆ ಹೊರಡುವಾಗ ತುತ್ತೂರಿಗಳನ್ನು ಆರ್ಭಟ ಸ್ವರದಲ್ಲಿ ಊದಿಸಬೇಕು. ಆಗ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ಜ್ಞಾಪಕಮಾಡಿಕೊಂಡು ಶತ್ರುಗಳಿಂದ ನಿಮ್ಮನ್ನು ರಕ್ಷಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ಇದಲ್ಲದೆ, ನೀವು ಉತ್ಸವಕಾಲಗಳಲ್ಲಿಯೂ ಹಬ್ಬಗಳಲ್ಲಿಯೂ ಅಮಾವಾಸ್ಯೆಯಲ್ಲಿಯೂ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನೂ ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನೂ ಸಮರ್ಪಿಸುವಾಗ ಆ ತುತ್ತೂರಿಗಳನ್ನು ಊದಿಸಬೇಕು. ನಿಮ್ಮನ್ನು ಗಮನಿಸಬೇಕೆಂದು ಆ ತುತ್ತೂರಿ ಧ್ವನಿಗಳು ನಿಮ್ಮ ದೇವರಿಗೆ ನೆನಪನ್ನುಂಟುಮಾಡುತ್ತವೆ. ನೀವು ಇದನ್ನು ಮಾಡಬೇಕೆಂದು ನಾನು ಆಜ್ಞಾಪಿಸುತ್ತೇನೆ. ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಾನೇ.” ");
INSERT INTO kan2010_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ಇಸ್ರೇಲರು ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟ ನಂತರದ ಎರಡನೆಯ ವರ್ಷದ ಎರಡನೆಯ ತಿಂಗಳಿನ ಇಪ್ಪತ್ತನೆಯ ದಿನದಲ್ಲಿ ಮೇಘವು ಒಡಂಬಡಿಕೆಯ ಗುಡಾರದಿಂದ ಮೇಲೆ ಎದ್ದಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ಆದ್ದರಿಂದ, ಇಸ್ರೇಲರು ತಮ್ಮ ಪ್ರಯಾಣವನ್ನು ಪ್ರಾರಂಭಿಸಿದರು. ಅವರು ಸೀನಾಯಿ ಮರುಭೂಮಿಯನ್ನು ಬಿಟ್ಟು ಮೇಘವು ಪಾರಾನ್ ಮರುಭೂಮಿಯಲ್ಲಿ ನಿಲ್ಲುವವರೆಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಕೊಟ್ಟ ಸೂಚನೆಯ ಪ್ರಕಾರ ಅವರು ಮೊಟ್ಟಮೊದಲನೆಯ ಸಲ ಪ್ರಯಾಣವನ್ನು ಆರಂಭಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ಮೊದಲು ಯೆಹೂದ ಪಾಳೆಯದ ಮೂರು ದಂಡುಗಳು ಹೊರಟವು. ಅವರು ತಮ್ಮ ಧ್ವಜದೊಂದಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಅಮ್ಮೀನಾದ್ವಾನ ಮಗನಾದ ನಹಶೋನನು ಯೆಹೂದ ಕುಲದ ಸೇನಾಧಿಪತಿಯಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ಚೂವಾರನ ಮಗನಾದ ನೆತನೇಲನು ಇಸ್ಸಾಕಾರನ ಕುಲದ ಸೇನಾಧಿಪತಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ಹೇಲೋನನ ಮಗನಾದ ಎಲೀಯಾಬನು ಜೆಬುಲೂನ್ ಕುಲದ ಸೇನಾಧಿಪತಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ಬಳಿಕ ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಕೆಳಗಿಳಿಸಲಾಯಿತು. ಗೇರ್ಷೋನ್ ಮತ್ತು ಮೆರಾರೀ ಕುಲಗಳ ಗಂಡಸರು ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಹೊತ್ತುಕೊಂಡು ಅವರ ಹಿಂದೆ ಹೊರಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ಅವರ ತರುವಾಯ ರೂಬೇನ್ ಕುಲದಿಂದ ಮುನ್ನಡೆಸಲ್ಪಟ್ಟ ಮೂರು ಗುಂಪುಗಳು ಹೊರಟವು. ಅವರು ತಮ್ಮ ಧ್ವಜದೊಂದಿಗೆ ಹೊರಟರು. ಶೆದೇಯೂರನ ಮಗನಾದ ಎಲೀಚೂರನು ರೂಬೇನ್ ಕುಲದ ಸೇನಾಧಿಪತಿಯಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ಚೂರೀಷದ್ದೈನ ಮಗನಾದ ಶೆಲುಮೀಯೇಲನು ಸಿಮೆಯೋನ್ ಕುಲದ ಸೇನಾಧಿಪತಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ದೆಗೂವೇಲನ ಮಗನಾದ ಎಲ್ಯಾಸಾಫನು ಗಾದ್ ಕುಲದ ಸೇನಾಧಿಪತಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ಬಳಿಕ ಕೆಹಾತನ ಕುಲದವರು ಹೊರಟರು. ಅವರು ದೇವಸ್ಥಾನದ ಪವಿತ್ರವಸ್ತುಗಳನ್ನು ಹೊತ್ತುಕೊಂಡಿದ್ದರು. ಕೆಹಾತ್ಯರು ಪವಿತ್ರವಸ್ತುಗಳೊಡನೆ ಬರುವಷ್ಟರೊಳಗೆ ಇತರ ಲೇವಿಯರು ದೇವದರ್ಶನಗುಡಾರವನ್ನು ಎತ್ತಿ ನಿಲ್ಲಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ಬಳಿಕ ಎಫ್ರಾಯೀಮ್ ಪಾಳೆಯದಿಂದ ಮೂರು ಗುಂಪುಗಳು ಹೊರಟವು. ಅವರು ತಮ್ಮ ಧ್ವಜದೊಂದಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಅಮ್ಮೀಹೂದನ ಮಗನಾದ ಎಲೀಷಾಮನು ಎಫ್ರಾಯೀಮ್ ಕುಲದ ಸೇನಾಧಿಪತಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ಪೆದಾಚೂರನ ಮಗನಾದ ಗಮ್ಲೀಯೇಲನು ಮನಸ್ಸೆ ಕುಲದ ಸೇನಾಧಿಪತಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ಗಿದ್ಯೋನಿಯ ಮಗನಾದ ಅಬೀದಾನನು ಬೆನ್ಯಾಮೀನ್ ಕುಲದ ಸೇನಾಧಿಪತಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ಆಮೇಲೆ ಎಲ್ಲಾ ಕುಲಗಳ ಹಿಂಭಾಗದಲ್ಲಿ ದಾನ್ ಕುಲದಿಂದ ಮುನ್ನಡೆಸಲ್ಪಟ್ಟ ಗುಂಪುಗಳು ಹೊರಟವು. ಅವರು ತಮ್ಮ ಧ್ವಜದೊಂದಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಅಮ್ಮೀಷದ್ದೈನ ಮಗನಾದ ಅಹೀಗೆಜೆರನು ದಾನ್ ಕುಲದ ಸೇನಾಧಿಪತಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ಆಶೇರನ ಕುಲಕ್ಕೆ ಒಕ್ರಾನನ ಮಗನಾದ ಪಗೀಯೇಲನು ಸೇನಾಧಿಪತಿಯಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ನಫ್ತಾಲಿ ಕುಲಕ್ಕೆ ಏನಾನನ ಮಗನಾದ ಅಹೀರನು ಸೇನಾಧಿಪತಿಯಾಗಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ಈ ರೀತಿಯಾಗಿ ಇಸ್ರೇಲರು ತಮ್ಮ ಗುಂಪುಗಳಲ್ಲಿ ಒಂದು ಸ್ಥಳದಿಂದ ಇನ್ನೊಂದು ಸ್ಥಳಕ್ಕೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ಹೋಬಾಬನು ಮಿದ್ಯಾನ್ಯನಾದ ರೆಗೂವೇಲನ ಮಗನು. ರೆಗೂವೇಲನು ಮೋಶೆಯ ಮಾವ. ಮೋಶೆಯು ಹೋಬಾಬನಿಗೆ, “ದೇವರು ನಮಗೆ ಕೊಡುತ್ತೇನೆಂದು ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶಕ್ಕೆ ನಾವು ಪ್ರಯಾಣ ಮಾಡುತ್ತಿದ್ದೇವೆ. ನಮ್ಮೊಂದಿಗೆ ಬಾ. ನೀನು ನಮ್ಮೊಂದಿಗೆ ಉದ್ದಾರವಾಗುವೆ; ಯಾಕೆಂದರೆ ಯೆಹೋವನು ಇಸ್ರೇಲರಿಗೆ ಒಳ್ಳೆಯವುಗಳನ್ನು ವಾಗ್ದಾನ ಮಾಡಿದ್ದಾನೆ.” ");
INSERT INTO kan2010_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ಆದರೆ ಹೋಬಾಬನು, “ಇಲ್ಲ. ನಾನು ನಿಮ್ಮೊಂದಿಗೆ ಬರುವುದಿಲ್ಲ. ನಾನು ನನ್ನ ದೇಶಕ್ಕೂ ನನ್ನ ಜನರ ಬಳಿಗೂ ಹೋಗುವೆನು” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ಆಗ ಮೋಶೆ, “ದಯಮಾಡಿ ನಮ್ಮನ್ನು ಬಿಟ್ಟು ಹೋಗಬೇಡ. ನಾವು ಮರುಭೂಮಿಯಲ್ಲಿ ಎಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಳ್ಳಬಹುದೆಂಬುದು ನಿನಗೆ ಗೊತ್ತಿದೆ. ನೀನು ನಮ್ಮ ಮಾರ್ಗದರ್ಶಕನಾಗಿರಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ನೀನು ನಮ್ಮೊಂದಿಗೆ ಬಂದರೆ, ಯೆಹೋವನು ನಮಗೆ ಕೊಡುವ ಎಲ್ಲಾ ಒಳ್ಳೆಯ ವಸ್ತುಗಳಲ್ಲಿ ನಿನಗೆ ಪಾಲು ಕೊಡುವೆವು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ಅವರು ಯೆಹೋವನ ಬೆಟ್ಟದಿಂದ ಹೊರಟು ಮೂರು ದಿನ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಲೇವಿಯರು ಹೊತ್ತುಕೊಂಡಿದ್ದ ಯೆಹೋವನ ಒಡಂಬಡಿಕೆ ಪೆಟ್ಟಿಗೆಯು ಮತ್ತೆ ಪಾಳೆಯ ಹಾಕಲು ಯೋಗ್ಯವಾದ ಸ್ಥಳವನ್ನು ಎದುರು ನೋಡುತ್ತಾ ಜನರ ಮುಂದೆ ಮೂರು ದಿನಗಳವರೆಗೆ ಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ಅವರು ಪಾಳೆಯದೊಡನೆ ಹೊರಟಾಗ ಪ್ರತಿದಿನವೂ ಯೆಹೋವನ ಮೋಡವು ಅವರ ಮೇಲಿರುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ಜನರು ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಯನ್ನು ಎತ್ತಿಕೊಂಡು ಹೊರಡುವಾಗ, ಮೋಶೆಯು, “ಯೆಹೋವನೇ, ಎದ್ದೇಳು! ನಿನ್ನ ವೈರಿಗಳು ಚದರಿಹೋಗಲಿ, ನಿನ್ನ ಶತ್ರುಗಳು ಬೆನ್ನುಕೊಟ್ಟು ಓಡಿಹೋಗಲಿ” ಎಂದು ಹೇಳುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ಪವಿತ್ರ ಪೆಟ್ಟಿಗೆಯು ಕೆಳಗಿಳಿಸಲ್ಪಟ್ಟಾಗ, ಮೋಶೆಯು, “ಯೆಹೋವನೇ ಇಸ್ರೇಲರ ಲಕ್ಷಾಂತರ ಕುಟುಂಬಗಳ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ ಬಾ” ಎಂದು ಹೇಳುತ್ತಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ಜನರು ತಮಗೆ ತೊಂದರೆ ಉಂಟಾಯಿತೆಂದು ಗಟ್ಟಿಯಾಗಿ ಗುಣುಗುಟ್ಟಿದರು. ಅದನ್ನು ಯೆಹೋವನು ಕೇಳಿ ಕೋಪಗೊಂಡನು. ಯೆಹೋವನಿಂದ ಬಂದ ಬೆಂಕಿ ಅವರ ವಿರುದ್ಧವಾಗಿ ಹೊತ್ತಿಕೊಂಡದ್ದರಿಂದ ಪಾಳೆಯದ ಹೊರಭಾಗದಲ್ಲಿದ್ದವರು ಸುಟ್ಟುಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ಆಗ ಜನರು ಸಹಾಯಕ್ಕಾಗಿ ಮೋಶೆಗೆ ಮೊರೆಯಿಟ್ಟರು. ಮೋಶೆಯು ಅವರಿಗೋಸ್ಕರ ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಲಾಗಿ ಬೆಂಕಿ ಆರಿಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ಯೆಹೋವನು ಅವರಿಗೆ ವಿರುದ್ಧವಾಗಿ ಬೆಂಕಿ ಉರಿಯುವಂತೆ ಮಾಡಿದ್ದರಿಂದ ಜನರು ಆ ಸ್ಥಳಕ್ಕೆ “ತಬೇರ” ಎಂದು ಹೆಸರಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ಅವರ ಮಧ್ಯದಲ್ಲಿದ್ದ ಕಿರುಕುಳಕೊಡುವ ಪರದೇಶಸ್ಥರು ಬೇರೆ ರೀತಿಯ ಆಹಾರಕ್ಕಾಗಿ ಬಹಳವಾಗಿ ಆಶಿಸಿದರು. ಇಸ್ರೇಲರು ಸಹ ಮತ್ತೆ ಅಳಲು ಆರಂಭಿಸಿ, “ನಮಗೆ ಯಾರು ಮಾಂಸವನ್ನು ಕೊಡುತ್ತಾರೆ? ");
INSERT INTO kan2010_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ನಾವು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಬಿಟ್ಟಿಯಾಗಿ ತಿನ್ನುತ್ತಿದ್ದ ಮೀನು, ಸೌತೆಕಾಯಿ, ಕರ್ಬೂಜು, ಈರುಳ್ಳಿಸೊಪ್ಪು, ಈರುಳ್ಳಿ, ಬೆಳ್ಳುಳ್ಳಿ ಇವುಗಳನ್ನು ನಾವು ಜ್ಞಾಪಿಸಿಕೊಳ್ಳುತ್ತೇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ಆದರೆ ನಾವು ಈಗ ನಮ್ಮ ಬಲವನ್ನು ಕಳೆದುಕೊಂಡಿದ್ದೇವೆ. ಈ ಮನ್ನವನ್ನು ಬಿಟ್ಟು ನಮ್ಮಲ್ಲಿ ತಿನ್ನಲು ಬೇರೇನೂ ಇಲ್ಲ” ಎಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ಈ ಮನ್ನವು ಕೊತ್ತುಂಬರಿ ಕಾಳಿನಂತಿತ್ತು ಮತ್ತು ಅಂಟು ಪದಾರ್ಥದಂತೆ ಕಾಣಿಸಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ಜನರು ಮನ್ನವನ್ನು ಕೂಡಿಸಿಕೊಂಡು ಬೀಸುವ ಕಲ್ಲುಗಳಿಂದ ಬೀಸಿ ಅಥವಾ ಒರಳಲ್ಲಿ ಕುಟ್ಟಿ, ಮಡಕೆಗಳಲ್ಲಿ ಬೇಯಿಸಿ ತೆಳುವಾದ ರೊಟ್ಟಿಗಳನ್ನು ಮಾಡಿಕೊಂಡರು. ಅದರ ರುಚಿ ಆಲಿವ್ ಎಣ್ಣೆಯಿಂದ ಮಾಡಿದ ಭಕ್ಷ್ಯಗಳಂತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ರಾತ್ರಿ ಕಾಲದಲ್ಲಿ ಮಂಜು ಪಾಳೆಯದಲ್ಲಿ ಬೀಳುತ್ತಿದ್ದಾಗ ಅದರೊಂದಿಗೆ ಮನ್ನವೂ ಬೀಳುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ಎಲ್ಲಾ ಕುಟುಂಬದವರೂ ತಮ್ಮತಮ್ಮ ಗುಡಾರದ ಬಾಗಿಲುಗಳಲ್ಲಿ ನಿಂತು ಗುಣಗುಟ್ಟುತ್ತಿರುವ ಶಬ್ದವು ಮೋಶೆಗೆ ಕೇಳಿಸಿತು. ಆಗ ಯೆಹೋವನು ಬಹು ಕೋಪಗೊಂಡನು. ಇದರಿಂದಾಗಿ ಮೋಶೆಗೆ ಬಹಳ ಬೇಸರವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ಆಗ ಮೋಶೆ ಯೆಹೋವನಿಗೆ, “ನಿನ್ನ ಸೇವಕನಾದ ನನಗೆ ಯಾಕೆ ತೊಂದರೆಯನ್ನು ಉಂಟುಮಾಡಿದೆ? ನಾನು ನಿನಗೆ ಬೇಸರವನ್ನು ಉಂಟುಮಾಡಿದೆನೇ? ಈ ಜನರೆಲ್ಲರನ್ನು ಮುನ್ನಡೆಸಿಕೊಂಡು ಹೋಗುವ ಭಾರವನ್ನು ನೀನು ನನ್ನ ಮೇಲೆ ಯಾಕೆ ಹಾಕಿದೆ? ");
INSERT INTO kan2010_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ನಾನು ಇವರಿಗೆ ಹೆತ್ತ ತಾಯಿಯೋ? ನಾನು ಅವರಿಗೆ ಜನ್ಮ ಕೊಡಲಿಲ್ಲವೆಂದು ನಿನಗೆ ಗೊತ್ತಿದೆ. ದಾದಿಯು ಮಗುವನ್ನು ಎತ್ತಿಕೊಂಡು ಹೋಗುವಂತೆ, ಈ ಜನರನ್ನು ನಾನು ನನ್ನ ಮಡಿಲಲ್ಲಿ ಇಟ್ಟು, ನೀನು ಅವರ ಪೂರ್ವಿಕರಿಗೆ ವಾಗ್ದಾನಮಾಡಿರುವ ದೇಶಕ್ಕೆ ಎತ್ತಿಕೊಂಡು ಹೋಗುವಂತೆ ನೀನು ನನಗೇಕೆ ಹೇಳುವೆ? ");
INSERT INTO kan2010_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ಇವರು ನನ್ನ ಬಳಿಗೆ ಬಂದು, ‘ಮಾಂಸವನ್ನು ನಮಗೆ ತಿನ್ನಲಿಕ್ಕೆ ಕೊಡು’ ಎಂದು ಕೇಳಿಕೊಳ್ಳುತ್ತಾರಲ್ಲಾ! ಇಷ್ಟು ಜನಕ್ಕೆ ಬೇಕಾದ ಮಾಂಸವು ನನಗೆ ಎಲ್ಲಿಂದ ದೊರಕೀತು? ");
INSERT INTO kan2010_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ಇಷ್ಟು ಜನರ ಭಾರವನ್ನು ನಾನೊಬ್ಬನೇ ಹೊರುವುದು ನನಗೆ ಅಸಾಧ್ಯ. ಅದು ನನ್ನ ಶಕ್ತಿಗೆ ಮೀರಿದ ಕೆಲಸ. ");
INSERT INTO kan2010_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ನೀನು ಹೀಗೆಯೇ ನನಗೆ ಮಾಡುವುದಾಗಿದ್ದರೆ ಅದಕ್ಕೆ ಬದಲಾಗಿ ನನ್ನನ್ನು ಕೊಂದುಬಿಡು ಎಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ. ಆಗ ನಾನು ಈ ದುರವಸ್ಥೆಗಳಿಂದ ವಿಮುಕ್ತನಾಗುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಇಸ್ರೇಲರಲ್ಲಿ ಹಿರಿಯರೆಂದೂ ಅಧಿಕಾರಿಗಳೆಂದೂ ನೀನು ತಿಳಿದುಕೊಂಡಿರುವ ಎಪ್ಪತ್ತು ಮಂದಿಯನ್ನು ಕೂಡಿಸಿ ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಿಗೆ ಕರೆದುತಂದು ಅಲ್ಲೇ ನಿನ್ನೊಡನೆ ನಿಲ್ಲಿಸಿಕೊ. ");
INSERT INTO kan2010_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ನಾನು ಅಲ್ಲಿಗೆ ಇಳಿದುಬಂದು ನಿನ್ನ ಸಂಗಡ ಮಾತಾಡುವೆನು. ಅದಲ್ಲದೆ ನಾನು ನಿನಗೆ ಅನುಗ್ರಹಿಸಿದ ಆತ್ಮವನ್ನೇ ಅವರ ಮೇಲೆ ಸುರಿಸುವೆನು. ಆಗ ಸ್ವತಃ ನೀನೇ ಈ ಜನರ ಭಾರವನ್ನು ವಹಿಸಬೇಕಾಗಿರುವುದಿಲ್ಲ. ಈ ಎಪ್ಪತ್ತು ಮಂದಿ ಹಿರಿಯರು ಆ ಭಾರವನ್ನು ಹೊರಲು ನಿನಗೆ ಸಹಾಯ ಮಾಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಹೇಳು: ನಾಳೆಗಾಗಿ ನಿಮ್ಮನ್ನು ಪವಿತ್ರರನ್ನಾಗಿ ಮಾಡಿಕೊಳ್ಳಿರಿ. ನಾಳೆ ನೀವು ಮಾಂಸವನ್ನು ತಿನ್ನುವಿರಿ. ‘ನಮಗೆ ಮಾಂಸವನ್ನು ಕೊಡುವವರು ಯಾರು? ನಾವು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಇದಕ್ಕಿಂತಲೂ ಚೆನ್ನಾಗಿದ್ದೆವಲ್ಲಾ’ ಎಂಬ ನಿಮ್ಮ ದೂರನ್ನು ಯೆಹೋವನು ಕೇಳಿದ್ದಾನೆ. ಆದ್ದರಿಂದ ಯೆಹೋವನು ನಿಮಗೆ ಮಾಂಸವನ್ನು ಕೊಡುವನು ಮತ್ತು ನೀವು ತಿನ್ನುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ನೀವು ಒಂದು ದಿನವಲ್ಲ, ಎರಡು ದಿನವಲ್ಲ, ಐದು ದಿನವಲ್ಲ, ಹತ್ತು ದಿನವಲ್ಲ, ಇಪ್ಪತ್ತು ದಿನವಲ್ಲ, ");
INSERT INTO kan2010_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ಒಂದು ತಿಂಗಳು ಪೂರ್ತಿ ಮಾಂಸವನ್ನು ತಿನ್ನುವಿರಿ. ಅದು ನಿಮ್ಮ ಮೂಗಿನಲ್ಲಿ ಓಕರಿಕೆಯಾಗಿ ಹೊರಬರುವ ತನಕ ಮತ್ತು ನಿಮಗೆ ಅಸಹ್ಯವಾಗುವವರೆಗೆ ಅದನ್ನು ತಿನ್ನುವಿರಿ. ನೀವು ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿರುವ ಯೆಹೋವನನ್ನು ತಿರಸ್ಕರಿಸಿದ್ದರಿಂದ ಮತ್ತು ‘ನಾವೇಕೆ ಈಜಿಪ್ಟನ್ನು ಬಿಟ್ಟು ಬಂದೆವು?’ ಎಂದು ಆತನ ಮುಂದೆ ದೂರು ಹೇಳಿದ್ದರಿಂದ ಇದು ನಿಮಗೆ ಸಂಭವಿಸುವುದು.” ");
INSERT INTO kan2010_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ಅದಕ್ಕೆ ಮೋಶೆ, “ಯೆಹೋವನೇ, ಇಲ್ಲಿ ಆರು ಲಕ್ಷ ಗಂಡಸರು ನನ್ನೊಂದಿಗೆ ಇದ್ದಾರೆ. ಆದಾಗ್ಯೂ ನೀನು ಇವರಿಗೆ ಮಾಂಸ ಕೊಡುವುದಾಗಿಯೂ ಇವರು ಒಂದು ತಿಂಗಳೆಲ್ಲಾ ಅದನ್ನು ತಿನ್ನುವುದಾಗಿಯೂ ನೀನು ಹೇಳುತ್ತಿರುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ನಾವು ಎಲ್ಲಾ ಕುರಿಗಳನ್ನು, ದನಕರುಗಳನ್ನು ಕೊಂದರೂ ಇಷ್ಟು ಜನರು ಒಂದು ತಿಂಗಳು ತಿನ್ನುವುದಕ್ಕೆ ಸಾಕಾಗದು. ಸಮುದ್ರದಲ್ಲಿರುವ ಮೀನುಗಳೆಲ್ಲವನ್ನು ಹಿಡಿದರೂ ಅದು ಇಷ್ಟು ಜನರಿಗೆ ಸಾಕಾಗದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ಆದರೆ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಯೆಹೋವನ ಶಕ್ತಿಗೆ ಮಿತಿಯಿಲ್ಲ. ನಾನು ಹೇಳುತ್ತಿರುವ ಸಂಗತಿಗಳು ನಡೆಯುವುದನ್ನು ನೀನು ನೋಡುವೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ಮೋಶೆಯು ಹೊರಟುಹೋಗಿ, ಯೆಹೋವನು ಹೇಳಿದ್ದನ್ನು ಜನರಿಗೆ ತಿಳಿಸಿ, ಇಸ್ರೇಲರ ಹಿರಿಯರಲ್ಲಿ ಎಪ್ಪತ್ತು ಮಂದಿಯನ್ನು ಒಟ್ಟಾಗಿ ಸೇರಿಸಿದನು. ಅವರು ಗುಡಾರದ ಸುತ್ತಲೂ ನಿಲ್ಲುವಂತೆ ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ಆಗ ಯೆಹೋವನು ಮೇಘದಲ್ಲಿ ಇಳಿದುಬಂದು ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿ ಅವನಲ್ಲಿದ್ದ ಆತ್ಮವನ್ನೇ ಆ ಎಪ್ಪತ್ತು ಮಂದಿ ಹಿರಿಯರಿಗೆ ಕೊಟ್ಟನು. ಆತ್ಮಿಕ ವರಗಳು ಅವರಿಗೆ ಕೊಡಲ್ಪಟ್ಟಾಗ ಅವರು ಪ್ರವಾದಿಗಳಂತೆ ಪ್ರವಾದಿಸಿದರು. ಆದರೆ ಮತ್ತೆ ಅವರು ಹಾಗೆ ಪ್ರವಾದಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ಎಲ್ದಾದ್ ಮತ್ತು ಮೇದಾದ್ ಎಂಬ ಹಿರಿಯರಿಬ್ಬರು ಗುಡಾರದ ಬಳಿಗೆ ಹೋಗಲಿಲ್ಲ. ಹಿರಿಯರ ಹೆಸರುಗಳಿದ್ದ ಪಟ್ಟಿಯಲ್ಲಿ ಅವರ ಹೆಸರುಗಳಿದ್ದವು. ಆದರೆ ಅವರು ಗುಡಾರದಲ್ಲೇ ಉಳಿದುಕೊಂಡರು. ಆದರೆ ಅವರಿಗೆ ಆತ್ಮಿಕ ವರಗಳು ಕೊಡಲ್ಪಟ್ಟಿದ್ದರಿಂದ ಅವರು ಪಾಳೆಯದಲ್ಲಿ ಪ್ರವಾದಿಗಳಂತೆ ಪ್ರವಾದಿಸತೊಡಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ಒಬ್ಬ ಯೌವನಸ್ಥನು ಮೋಶೆಯ ಬಳಿಗೆ ಓಡಿಹೋಗಿ, “ಎಲ್ದಾದ್ ಮತ್ತು ಮೇದಾದ್ ಎಂಬಿಬ್ಬರು ಪಾಳೆಯದಲ್ಲಿ ಪ್ರವಾದಿಗಳಂತೆ ಪ್ರವಾದಿಸುತ್ತಿದ್ದಾರೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನು ಮೋಶೆಗೆ, “ಸ್ವಾಮೀ, ನೀನು ಅವರನ್ನು ತಡೆಯಬೇಕು” ಎಂದನು. (ಯೆಹೋಶುವನು ಯೌವನಸ್ಥನಾಗಿದ್ದಾಗಿನಿಂದಲೂ ಮೋಶೆಯ ಸಹಾಯಕನಾಗಿದ್ದನು.) ");
INSERT INTO kan2010_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ಆದರೆ ಮೋಶೆಯು, “ನೀನು ನನ್ನ ವಿಷಯದಲ್ಲಿ ಚಿಂತೆಪಡುತ್ತಿರುವುದೇಕೆ? ಯೆಹೋವನ ಜನರೆಲ್ಲರೂ ಪ್ರವಾದಿಗಳಾಗಿರಬೇಕೆಂದು ನಾನು ಬಯಸುತ್ತೇನೆ. ಅವರೆಲ್ಲರ ಮೇಲೆ ಯೆಹೋವನು ತನ್ನ ಆತ್ಮನನ್ನು ಇರಿಸಬೇಕೆಂದು ನಾನು ಬಯಸುತ್ತೇನೆ” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ಬಳಿಕ ಮೋಶೆಯು ಮತ್ತು ಇಸ್ರೇಲರ ನಾಯಕರು ಪಾಳೆಯಕ್ಕೆ ಹಿಂತಿರುಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ಆಗ ಯೆಹೋವನು ಸಮುದ್ರದ ಕಡೆಯಿಂದ ಬಲವಾದ ಗಾಳಿಯು ಬೀಸುವಂತೆ ಮಾಡಿದನು. ಗಾಳಿಯು ಲಾವಕ್ಕಿಗಳನ್ನು ಹೊತ್ತುಕೊಂಡು ಬಂತು. ಲಾವಕ್ಕಿಗಳು ಪಾಳೆಯದ ಸುತ್ತಲೂ ಹಾರಿಬಂದವು. ಒಬ್ಬನು ಪ್ರತಿಯೊಂದು ದಿಕ್ಕಿನಲ್ಲಿ ಒಂದು ದಿನ ನಡೆಯಬಹುದಾದಷ್ಟು ದೂರದವರೆಗೂ ಲಾವಕ್ಕಿಗಳು ಭೂಮಿಯಿಂದ ಮೂರು ಅಡಿ ಎತ್ತರದಲ್ಲಿ ಹಾರಾಡುತ್ತಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ಜನರು ಎದ್ದು ಆ ದಿನವೆಲ್ಲಾ ಮತ್ತು ರಾತ್ರಿಯೆಲ್ಲಾ ಮತ್ತು ಮರುದಿನವೆಲ್ಲಾ ಲಾವಕ್ಕಿಗಳನ್ನು ಕೂಡಿಸಿಕೊಂಡರು. ಸ್ವಲ್ಪ ಕೂಡಿಸಿಕೊಂಡವನು ಅರವತ್ತು ಕಿಲೋಗ್ರಾಂ ಕೂಡಿಸಿಕೊಂಡನು. ಬಳಿಕ ಜನರು ಲಾವಕ್ಕಿಗಳ ಮಾಂಸವನ್ನು ಪಾಳೆಯದ ಸುತ್ತಲೂ ಹರಡಿ ಬಿಸಿಲಿನಲ್ಲಿ ಒಣಗಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ಜನರು ಮಾಂಸವನ್ನು ಇನ್ನೂ ತಿನ್ನುತ್ತಿರುವಾಗಲೇ ಮತ್ತು ಲಾವಕ್ಕಿಗಳ ಸರಬರಾಜು ನಿಂತುಹೋಗುವುದಕ್ಕಿಂತ ಮೊದಲೇ ಯೆಹೋವನು ಬಹಳವಾಗಿ ಕೋಪಗೊಂಡು ಜನರ ಮಧ್ಯದಲ್ಲಿ ಭಯಂಕರವಾದ ಕಾಯಿಲೆಯನ್ನು ಉಂಟುಮಾಡಿದನು. ಜನರಲ್ಲಿ ಅನೇಕರು ಸತ್ತದ್ದರಿಂದ ಅವರನ್ನು ಅಲ್ಲೇ ಹೂಳಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ಈ ಕಾರಣದಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ, “ಕಿಬ್ರೋತ್ ಹತಾವಾ” ಎಂದು ಹೆಸರಿಟ್ಟರು. ಮಾಂಸಕ್ಕಾಗಿ ಅತ್ಯಾಶೆಪಟ್ಟವರನ್ನು ಅಲ್ಲಿ ಹೂಳಿಟ್ಟಿದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಈ ಹೆಸರನ್ನು ಇಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ಜನರು ಕಿಬ್ರೋತ್ ಹತಾವಾದಿಂದ ಪ್ರಯಾಣಮಾಡಿ ಹಚೇರೋತಿಗೆ ಹೋಗಿ ಅಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ಮೋಶೆಯು ಇಥಿಯೋಪ್ಯದ ಸ್ತ್ರೀಯನ್ನು ಮದುವೆ ಮಾಡಿಕೊಂಡ ಕಾರಣ ಮಿರ್ಯಾಮಳೂ ಆರೋನನೂ ಮೋಶೆಗೆ ವಿರೋಧವಾಗಿ ಮಾತಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ಅವರು, “ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಮಾತ್ರ ಮಾತಾಡಿದ್ದಾನೋ? ಆತನು ನಮ್ಮೊಡನೆಯೂ ಮಾತಾಡಿದನಲ್ಲವೇ?” ಅಂದರು. ಯೆಹೋವನು ಅವರ ಮಾತುಗಳನ್ನು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(ಮೋಶೆಯು ಬಹಳ ದೀನನಾದ ವ್ಯಕ್ತಿ. ಅವನು ಭೂಮಿಯ ಮೇಲಿರುವ ಎಲ್ಲಾ ಮನುಷ್ಯರಿಗಿಂತಲೂ ದೀನನಾಗಿದ್ದನು.) ");
INSERT INTO kan2010_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ಆದ್ದರಿಂದ ಕೂಡಲೇ ಯೆಹೋವನು, ಮೋಶೆ, ಆರೋನರ ಮತ್ತು ಮಿರ್ಯಾಮಳ ಸಂಗಡ ಮಾತಾಡಿ, “ನೀವು ಮೂವರು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಬನ್ನಿ” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಮೋಶೆ, ಆರೋನರು ಮತ್ತು ಮಿರ್ಯಾಮಳು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ಯೆಹೋವನು ಎತ್ತರವಾದ ಮೇಘದಲ್ಲಿ ಇಳಿದು ಬಂದು ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದ ಬಳಿ ನಿಂತನು. ಯೆಹೋವನು ಆರೋನನನ್ನೂ ಮಿರ್ಯಾಮಳನ್ನೂ ಕರೆದನು. ಆರೋನನೂ ಮಿರ್ಯಾಮಳೂ ಹತ್ತಿರಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ದೇವರು, “ನನ್ನ ಮಾತನ್ನು ಕೇಳಿರಿ. ನಿಮ್ಮಲ್ಲಿ ಪ್ರವಾದಿಯಿದ್ದರೆ, ನಾನು ಅವನಿಗೆ ನನ್ನನ್ನು ದರ್ಶನದಲ್ಲಿ ಗೊತ್ತುಪಡಿಸಿಕೊಳ್ಳುವೆನು ಅಥವಾ ಸ್ವಪ್ನದಲ್ಲಿ ಅವನ ಸಂಗಡ ಮಾತಾಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ಆದರೆ ಮೋಶೆಯೊಡನೆ ನಾನು ಆ ರೀತಿ ಮಾಡುವುದಿಲ್ಲ. ಮೋಶೆಯು ನನ್ನ ನಂಬಿಗಸ್ತನಾದ ಸೇವಕನು. ಅವನ ಮೇಲೆ ನನಗೆ ಭರವಸೆಯಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ನಾನು ಅವನೊಂದಿಗೆ ಗೂಡಾರ್ಥದಿಂದ ಮಾತಾಡದೆ ನೇರವಾಗಿಯೂ ಸ್ಪಷ್ಟವಾಗಿಯೂ ಮಾತಾಡುತ್ತೇನೆ. ಅವನು ನನ್ನ ಸ್ವರೂಪವನ್ನೇ ನೋಡಬಲ್ಲನು. ನನ್ನ ಸೇವಕನಾದ ಮೋಶೆಗೆ ವಿರೋಧವಾಗಿ ಮಾತಾಡಲು ನೀವು ಯಾಕೆ ಭಯಪಡಲಿಲ್ಲ?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ಯೆಹೋವನು ಅವರ ಮೇಲೆ ಬಹಳವಾಗಿ ಕೋಪಗೊಂಡು ಹೊರಟುಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ಮೇಘವು ಗುಡಾರದಿಂದ ಮೇಲಕ್ಕೆ ಎದ್ದಿತು. ಆರೋನನು ಹಿಂತಿರುಗಿ ಮಿರ್ಯಾಮಳನ್ನು ನೋಡಿದನು. ಆಕೆಯ ಚರ್ಮವು ಹಿಮದಂತೆ ಬೆಳ್ಳಗಾಗಿತ್ತು. ಆಕೆಗೆ ಭಯಂಕರವಾದ ಚರ್ಮರೋಗ ಹಿಡಿದಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ಆಗ ಆರೋನನು ಮೋಶೆಗೆ, “ಸ್ವಾಮೀ, ನಾವು ಮೂರ್ಖತನದಿಂದ ಮಾಡಿದ ಪಾಪಕ್ಕೆ ದಯವಿಟ್ಟು ನಮ್ಮನ್ನು ದಂಡಿಸಬೇಡ. ");
INSERT INTO kan2010_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ಗರ್ಭದಲ್ಲೇ ಅರ್ಧ ಮಾಂಸ ಕೊಳೆತುಹೋಗಿ, ಹುಟ್ಟುವಾಗಲೇ ಸತ್ತ ಮಗುವಿನಂತೆ ಈಕೆಗೆ ಆಗದಂತೆ ದಯವಿಟ್ಟು ಕಾಪಾಡು” ಎಂದು ಬೇಡಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ಆದ್ದರಿಂದ ಮೋಶೆ ಯೆಹೋವನಿಗೆ ಪ್ರಾರ್ಥಿಸಿ, “ದೇವರೇ, ದಯಮಾಡಿ ಈಕೆಯನ್ನು ವಾಸಿಮಾಡು” ಎಂದು ಮೊರೆಯಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ಅದಕ್ಕೆ ಯೆಹೋವನು, “ಆಕೆಯ ತಂದೆ ಮುಖದ ಮೇಲೆ ಉಗುಳಿದ್ದರೆ ಆಕೆ ಏಳು ದಿವಸ ನಾಚಿಕೆಯಿಂದ ಇರುತ್ತಿರಲಿಲ್ಲವೇ? ಹಾಗಾದರೆ ಆಕೆ ಏಳು ದಿವಸ ಪಾಳೆಯದ ಹೊರಗೆ ಇರಬೇಕು. ತರುವಾಯ ಆಕೆ ಪಾಳೆಯದೊಳಗೆ ಬರಬಹುದು” ಎಂದು ಉತ್ತರಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ಆದಕಾರಣ ಅವರು ಮಿರ್ಯಾಮಳನ್ನು ಏಳು ದಿವಸಗಳವರೆಗೆ ಪಾಳೆಯದ ಹೊರಗೆ ಇಟ್ಟರು. ಆಕೆ ತಿರುಗಿ ಸೇರಿಕೊಳ್ಳುವ ತನಕ ಇಸ್ರೇಲರು ಪ್ರಯಾಣ ಮಾಡಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ಇದಾದನಂತರ, ಜನರು ಹಚೇರೋತಿನಿಂದ ಹೊರಟು ಪಾರಾನ್ ಮರುಭೂಮಿಯಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ಕಾನಾನ್ ದೇಶದ ಬಗ್ಗೆ ವಿಷಯವನ್ನು ಸಂಗ್ರಹಿಸಿಕೊಂಡು ಬರಲು ಗೂಢಚಾರರನ್ನು ಕಳುಹಿಸು. ನಾನು ಇಸ್ರೇಲರಿಗೆ ಕೊಡುವ ದೇಶ ಇದಾಗಿದೆ. ಹನ್ನೆರಡು ಕುಲಗಳಿಂದ ಒಬ್ಬೊಬ್ಬ ನಾಯಕನನ್ನು ಕಳುಹಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ಜನರು ಪಾರಾನ್ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಳಿದುಕೊಂಡಿದ್ದಾಗ ಯೆಹೋವನ ಆಜ್ಞೆಗನುಸಾರವಾಗಿ ಮೋಶೆಯು ಈ ನಾಯಕರನ್ನು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ಆ ನಾಯಕರು ಯಾರೆಂದರೆ: ರೂಬೇನ್ ಕುಲದಿಂದ ಜಕ್ಕೂರನ ಮಗನಾದ ಶಮ್ಮೂವ, ");
INSERT INTO kan2010_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ಸಿಮೆಯೋನ್ ಕುಲದಿಂದ ಹೋರಿಯ ಮಗನಾದ ಶಾಫಾಟ್, ");
INSERT INTO kan2010_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ಯೆಹೂದ ಕುಲದಿಂದ ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬ್, ");
INSERT INTO kan2010_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ಇಸ್ಸಾಕಾರ್ ಕುಲದಿಂದ ಯೋಸೇಫನ ಮಗನಾದ ಇಗಾಲ್, ");
INSERT INTO kan2010_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ಎಫ್ರಾಯೀಮ್ ಕುಲದಿಂದ ನೂನನ ಮಗನಾದ ಹೋಶೇಯ, ");
INSERT INTO kan2010_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ಬೆನ್ಯಾಮೀನ್ ಕುಲದಿಂದ ರಾಫೂವನ ಮಗನಾದ ಪಲ್ಟೀ, ");
INSERT INTO kan2010_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ಜೆಬುಲೂನ್ ಕುಲದಿಂದ ಸೋದೀಯ ಮಗನಾದ ಗದ್ದೀಯೇಲ್, ");
INSERT INTO kan2010_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ಯೋಸೇಫನ ಮಗನಾದ ಮನಸ್ಸೆ ಕುಲದಿಂದ ಸೂಸೀಯ ಮಗನಾದ ಗದ್ದೀ. ");
INSERT INTO kan2010_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ದಾನ್ ಕುಲದಿಂದ ಗೆಮಲ್ಲೀಯ ಮಗನಾದ ಅಮ್ಮೀಯೇಲ್. ");
INSERT INTO kan2010_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ಆಶೇರ್ ಕುಲದಿಂದ ಮೀಕಾಯೇಲನ ಮಗನಾದ ಸೆತೂರ್, ");
INSERT INTO kan2010_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ನಫ್ತಾಲಿ ಕುಲದಿಂದ ವಾಪೆಸೀಯನ ಮಗನಾದ ನಹಬೀ, ");
INSERT INTO kan2010_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ಗಾದ್ ಕುಲದಿಂದ ಮಾಕೀಯನ ಮಗನಾದ ಗೆಯೂವೇಲ್. ");
INSERT INTO kan2010_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ದೇಶದ ವಿಷಯವನ್ನು ಸಂಗ್ರಹಿಸಿಕೊಂಡು ಬರಲು ಮೋಶೆ ಕಳುಹಿಸಿದ ಗೂಢಚಾರರ ಹೆಸರುಗಳು ಇವೇ. (ಮೋಶೆಯು ನೂನನ ಮಗನಾದ ಹೋಶೇಯನಿಗೆ ಯೆಹೋಶುವನೆಂದು ಹೆಸರಿಟ್ಟನು.) ");
INSERT INTO kan2010_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ಕಾನಾನ್ ದೇಶದ ವಿಷಯವನ್ನು ಸಂಗ್ರಹಿಸಿಕೊಂಡು ಬರಲು ಮೋಶೆ ಅವರನ್ನು ಕಳುಹಿಸುವಾಗ ಅವರಿಗೆ, “ನೀವು ಬೆಟ್ಟದ ಸೀಮೆಗೆ ನೆಗೆವ್ ಮೂಲಕ ಹತ್ತಿ ಹೋಗಿ ");
INSERT INTO kan2010_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ಆ ದೇಶದ ಸಂಗತಿಯನ್ನೆಲ್ಲಾ ತಿಳಿದುಕೊಳ್ಳಿರಿ. ಅಲ್ಲಿನ ನಿವಾಸಿಗಳು ಬಲಿಷ್ಠರೋ ಅಥವಾ ಬಲಹೀನರೋ, ಬಹಳ ಮಂದಿಯೋ ಅಥವಾ ಸ್ವಲ್ಪ ಮಂದಿಯೋ, ");
INSERT INTO kan2010_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ಅವರ ದೇಶ ಒಳ್ಳೆಯದೋ ಅಥವಾ ಕೆಟ್ಟದ್ದೋ, ಅವರ ಪಟ್ಟಣಗಳು ಗೋಡೆಗಳನ್ನು ಹೊಂದಿವೆಯೋ ಅಥವಾ ಇಲ್ಲವೋ, ");
INSERT INTO kan2010_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ಭೂಮಿಯು ಸಾರವಾದದ್ದೋ ಅಥವಾ ನಿಸ್ಸಾರವಾದದ್ದೋ, ಮರಗಳನ್ನು ಹೊಂದಿದೆಯೋ ಅಥವಾ ಇಲ್ಲವೋ ಎಂಬುದನ್ನು ತಿಳಿದುಕೊಳ್ಳಿ. ಅದಲ್ಲದೆ ಆ ದೇಶದ ಉತ್ಪನ್ನಗಳಲ್ಲಿ ಕೆಲವನ್ನು ತರಲು ಪ್ರಯತ್ನ ಮಾಡಿ” ಎಂದು ಹೇಳಿದನು. (ಆಗ ದ್ರಾಕ್ಷಾಲತೆಗಳ ಪ್ರಥಮ ಫಲದ ಕಾಲವಾಗಿತ್ತು.) ");
INSERT INTO kan2010_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ಅವರು ಬೆಟ್ಟದ ಸೀಮೆಗೆ ಹತ್ತಿಹೋಗಿ, ಚಿನ್ ಮರುಭೂಮಿಯಿಂದಿಡಿದು ಲೆಬೊಹಮಾತಿನ ಬಳಿಯಲ್ಲಿರುವ ರೆಹೋಬಿನವರೆಗೂ ದೇಶದ ವಿಷಯಗಳನ್ನು ಸಂಗ್ರಹಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ಅವರು ನೆಗೆವ್ ಮೂಲಕ ದೇಶವನ್ನು ಪ್ರವೇಶಿಸಿ ಹೆಬ್ರೋನಿಗೆ ಹೋದರು. ಹೆಬ್ರೋನ್ ಪಟ್ಟಣವು ಈಜಿಪ್ಟ್ ದೇಶದಲ್ಲಿರುವ ಚೋವನ್ ಪಟ್ಟಣಕ್ಕಿಂತ ಏಳು ವರ್ಷಗಳ ಮುಂಚೆ ಕಟ್ಟಲ್ಪಟ್ಟಿತ್ತು. ಅಲ್ಲಿ ಅಹೀಮನ್, ಶೇಫೈ ಮತ್ತು ತಲ್ಮೈ ಎಂಬವರು ವಾಸಿಸುತ್ತಿದ್ದರು. ಇವರು ಅನಾಕನ ಸಂತತಿಯವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ಬಳಿಕ ಅವರು ಎಷ್ಕೋಲ್ ಕಣಿವೆಗೆ ಹೋದರು. ಅಲ್ಲಿ ಅವರು ದ್ರಾಕ್ಷಾಲತೆಯಿಂದ ಒಂದು ಕೊಂಬೆಯನ್ನು ಕಡಿದರು. ಆ ಕೊಂಬೆಯಲ್ಲಿ ದ್ರಾಕ್ಷೆಯ ಗೊಂಚಲಿತ್ತು. ಅವರು ಅದನ್ನು ಒಂದು ಕೋಲಿಗೆ ಕಟ್ಟಿ ಇಬ್ಬರು ಅದನ್ನು ಹೊತ್ತುಕೊಂಡು ಬಂದರು. ಕೆಲವು ದಾಳಿಂಬೆ ಹಣ್ಣುಗಳನ್ನು ಮತ್ತು ಅಂಜೂರದ ಹಣ್ಣುಗಳನ್ನು ಹೊತ್ತು ತಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ಇಸ್ರೇಲರು ಅಲ್ಲಿ ದ್ರಾಕ್ಷೆಯ ಗೊಂಚಲನ್ನು ಕತ್ತರಿಸಿದ್ದರಿಂದ ಆ ಸ್ಥಳಕ್ಕೆ ಎಷ್ಕೋಲ್ ಕಣಿವೆ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ಜನರು ನಲವತ್ತು ದಿನಗಳವರೆಗೆ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿ, ತಮ್ಮ ಪಾಳೆಯಕ್ಕೆ ಹಿಂತಿರುಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ಇಸ್ರೇಲರು ಪಾರಾನ್ ಮರುಭೂಮಿಯ ಕಾದೇಶಿನಲ್ಲಿ ತಂಗಿದ್ದರು. ಅವರು ನೋಡಿದ್ದರ ಬಗ್ಗೆ ಎಲ್ಲವನ್ನು ಮೋಶೆಗೂ ಆರೋನನಿಗೂ ಎಲ್ಲಾ ಇಸ್ರೇಲರಿಗೂ ತಿಳಿಸಿದರು. ಅವರು ಕಾನಾನ್ ದೇಶದಿಂದ ತಂದ ಹಣ್ಣುಗಳನ್ನು ತೋರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ಜನರು ಮೋಶೆಗೆ, “ನೀನು ಕಳುಹಿಸಿದ ದೇಶಕ್ಕೆ ನಾವು ಹೋಗಿ ಸಂಚರಿಸಿ ನೋಡಿದೆವು. ಅದು ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶವಾಗಿದೆ. ಇಗೋ, ಹಣ್ಣುಗಳಲ್ಲಿ ಕೆಲವು ಇಲ್ಲಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ಅಲ್ಲಿನ ಜನರು ಬಲಿಷ್ಠರು. ಪಟ್ಟಣಗಳೂ ಬಹಳ ದೊಡ್ಡದಾಗಿವೆ. ಪಟ್ಟಣಗಳು ಕೋಟೆಕೊತ್ತಲುಗಳುಳ್ಳದಾಗಿವೆ. ನಾವು ಕೆಲವು ಅನಾಕ್ಯರನ್ನು ಸಹ ನೋಡಿದೆವು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ಅಮಾಲೇಕ್ಯರು ನೆಗೆವ್‌ನಲ್ಲಿ ವಾಸಿಸುತ್ತಾರೆ. ಹಿತ್ತಿಯರು, ಯೆಬೂಸಿಯರು ಮತ್ತು ಅಮೋರಿಯರು ಪರ್ವತ ಪ್ರದೇಶದಲ್ಲಿ ವಾಸಿಸುತ್ತಾರೆ. ಕಾನಾನ್ಯರು ಸಮುದ್ರ ತೀರದಲ್ಲಿಯೂ ಮತ್ತು ಯೋರ್ದನ್ ನದಿಯ ಉದ್ದಕ್ಕೂ ವಾಸಿಸುತ್ತಾರೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ಕಾಲೇಬನು ಮೋಶೆಯ ಬಳಿಯಲ್ಲಿದ್ದ ಗುಣುಗುಟ್ಟುವ ಜನರನ್ನು ಸುಮ್ಮನಿರಿಸಿ, “ನಾವು ಹೋಗಿ ದೇಶವನ್ನು ವಶಪಡಿಸಿಕೊಳ್ಳಬೇಕು. ನಾವು ಸುಲಭವಾಗಿ ದೇಶವನ್ನು ವಶಪಡಿಸಿಕೊಳ್ಳಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ಆದರೆ ಅವನೊಡನೆ ಹೋದ ಜನರು, “ನಾವು ಆ ಜನರೊಡನೆ ಹೋರಾಡಲಾರೆವು, ಅವರು ನಮಗಿಂತಲೂ ಬಲಿಷ್ಠರು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","“ನಾವು ಸಂಚರಿಸಿ ವಿಷಯ ಸಂಗ್ರಹಿಸಿಕೊಂಡು ಬಂದ ದೇಶವು ಅಲ್ಲಿ ವಾಸಿಸುವವರನ್ನು ನಾಶಪಡಿಸುವ ದೇಶವಾಗಿದೆ. ನಾವು ಅಲ್ಲಿ ನೋಡಿದ ಎಲ್ಲಾ ಜನರು ರಾಕ್ಷಸರಂತಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ಷಸರಾದ ನೆಫೀಲಿಯರು ಅಲ್ಲಿ ವಾಸವಾಗಿರುವುದನ್ನು ನಾವು ನೋಡಿದೆವು. (ಅನಾಕ್ಯರು ನೆಫೀಲಿಯ ಜನರ ಸಂತತಿಯವರಾಗಿದ್ದಾರೆ.) ಅವರ ಮುಂದೆ ನಾವು ಮಿಡತೆಗಳೊ ಎಂದೆನಿಸಿತು. ಅವರಿಗೂ ಸಹ ನಾವು ಮಿಡತೆಗಳಂತೆ ಕಂಡುಬಂದೆವು” ಎಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ಆ ರಾತ್ರಿಯಲ್ಲಿ ಜನರೆಲ್ಲರೂ ಗಟ್ಟಿಯಾಗಿ ಕೂಗಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ಇಸ್ರೇಲರು ಮೋಶೆ ಆರೋನರ ವಿರುದ್ಧ ಗುಣುಗುಟ್ಟಿದರು. ಜನರೆಲ್ಲರೂ ಒಟ್ಟಾಗಿ ಮೋಶೆ ಆರೋನರ ಬಳಿಗೆ ಬಂದು, “ನಾವು ಈಜಿಪ್ಟಿನಲ್ಲಿಯಾಗಲೀ ಅಥವಾ ಈ ಮರುಭೂಮಿಯಲ್ಲಾಗಲಿ ಸತ್ತಿದ್ದರೆ ಒಳ್ಳೆಯದಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ಯುದ್ಧದಲ್ಲಿ ನಾವು ಸತ್ತುಹೋಗುವಂತೆ ಯೆಹೋವನು ನಮ್ಮನ್ನು ಈ ಹೊಸ ದೇಶಕ್ಕೆ ತರುತ್ತಿರುವುದೇಕೆ? ವೈರಿಗಳು ನಮ್ಮನ್ನು ಕೊಂದು ನಮ್ಮ ಹೆಂಡತಿಯರನ್ನೂ ಮಕ್ಕಳನ್ನೂ ತೆಗೆದುಕೊಳ್ಳುವರು. ನಾವು ಈಜಿಪ್ಟಿಗೆ ಮರಳಿಹೋಗುವುದೇ ಉತ್ತಮ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ಬಳಿಕ ಜನರು, “ನಾವು ಇನ್ನೊಬ್ಬ ನಾಯಕನನ್ನು ಆರಿಸಿಕೊಂಡು ಈಜಿಪ್ಟಿಗೆ ಮರಳಿಹೋಗೋಣ” ಎಂದು ಮಾತಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ಆಗ ಮೋಶೆ ಆರೋನರು ಇಸ್ರೇಲರ ಸರ್ವ ಸಮೂಹದವರ ಮುಂದೆ ಬೋರಲಬಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನೂ ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬನೂ ದೇಶದ ವಿಷಯವನ್ನು ಸಂಗ್ರಹಿಸಿಕೊಂಡು ಬಂದವರಲ್ಲಿ ಇಬ್ಬರಾಗಿದ್ದರು. ಅವರು ಬೇಸರಗೊಂಡು ತಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಹರಿದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ಇವರಿಬ್ಬರು ಇಸ್ರೇಲರೆಲ್ಲರಿಗೆ, “ನಾವು ಸಂಚರಿಸಿ ನೋಡಿದ ದೇಶವು ಅತ್ಯುತ್ತಮವಾದದ್ದು, ");
INSERT INTO kan2010_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ಅದು ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶ. ಯೆಹೋವನು ನಮ್ಮನ್ನು ಮೆಚ್ಚಿಕೊಂಡರೆ ಆ ದೇಶದೊಳಗೆ ನಮ್ಮನ್ನು ಕರೆದೊಯ್ದು ಅದನ್ನು ನಮ್ಮ ಸ್ವಾಧೀನಕ್ಕೆ ಕೊಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ಹೀಗಿರುವುದರಿಂದ ಯೆಹೋವನಿಗೆ ವಿರುದ್ಧವಾಗಿ ಏಳಬೇಡಿರಿ. ಆ ದೇಶದ ಜನರಿಗೆ ಭಯಪಡಬೇಡಿರಿ. ನಾವು ಅವರನ್ನು ಸೋಲಿಸಬಹುದು. ಅವರಿಗೆ ಯಾವ ಸಂರಕ್ಷಣೆ ಇರುವುದಿಲ್ಲ. ಆದರೆ ನಮ್ಮ ಕಡೆ ಯೆಹೋವನು ಇದ್ದಾನೆ. ಆದ್ದರಿಂದ ಭಯಪಡಬೇಡಿರಿ” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ಎಲ್ಲಾ ಜನರು ಯೆಹೋಶುವನನ್ನು ಮತ್ತು ಕಾಲೇಬನನ್ನು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕೆಂದು ಮಾತಾಡತೊಡಗಿದರು. ಆದರೆ ಯೆಹೋವನ ಮಹಿಮೆ ದೇವದರ್ಶನಗುಡಾರ ಮೇಲೆ ಪ್ರತ್ಯಕ್ಷವಾದದ್ದು ಇಸ್ರೇಲರೆಲ್ಲರಿಗೆ ಕಾಣಿಸಿತು. ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿ, ");
INSERT INTO kan2010_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","“ಈ ಜನರು ಇನ್ನೆಷ್ಟು ಕಾಲದವರೆಗೆ ನನ್ನನ್ನು ತಿರಸ್ಕರಿಸುವರು? ನಾನು ಮಾಡಿದ ಎಲ್ಲಾ ಮಹತ್ಕಾರ್ಯಗಳನ್ನು ಇವರು ಪ್ರತ್ಯಕ್ಷವಾಗಿ ನೋಡಿದಾಗ್ಯೂ ಇನ್ನೆಷ್ಟು ಕಾಲದವರೆಗೆ ನನ್ನನ್ನು ನಂಬದೆ ಇರುವರು? ");
INSERT INTO kan2010_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ಸರಿ, ನಾನು ಇವರಿಗೆ ವ್ಯಾಧಿಯನ್ನು ಉಂಟುಮಾಡಿ ಇವರನ್ನು ನಿರ್ಮೂಲಮಾಡಿ ಈ ಜನಕ್ಕಿಂತ ಹೆಚ್ಚಾಗಿಯೂ ಬಲಿಷ್ಠವಾಗಿಯೂ ಇರುವ ಜನಾಂಗವನ್ನು ನಿನ್ನ ಮೂಲಕವೇ ಹುಟ್ಟಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ಅದಕ್ಕೆ ಮೋಶೆ ಯೆಹೋವನಿಗೆ, “ನೀನು ನಿನ್ನ ಜನರಾದ ಇಸ್ರೇಲರನ್ನು ನಿನ್ನ ಶಕ್ತಿಯ ಮೂಲಕ ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದೆ. ನೀನು ನಿನ್ನ ಜನರನ್ನು ನಾಶಮಾಡಿದರೆ, ಈಜಿಪ್ಟಿನವರು ಈ ಸುದ್ದಿಯನ್ನು ಕೇಳಿ ಕಾನಾನಿನ ನಿವಾಸಿಗಳಿಗೆ ಅದರ ಬಗ್ಗೆ ತಿಳಿಸುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ಅದಲ್ಲದೆ, ಈ ದೇಶದವರು ನೀನು ಇಸ್ರೇಲರ ಮಧ್ಯದಲ್ಲಿರುವ ಸಂಗತಿಯನ್ನು ಕೇಳಿದ್ದಾರೆ. ನೀನು ಇಸ್ರೇಲರಿಗೆ ಪ್ರತ್ಯಕ್ಷನಾಗಿ ಕಾಣಿಸಿಕೊಂಡದ್ದು ಅವರಿಗೆ ತಿಳಿದಿದೆ. ನಿನ್ನ ಮೇಘವು ಇಸ್ರೇಲರ ಮೇಲಿರುವುದು ಅವರಿಗೆ ಗೊತ್ತಿದೆ. ನೀನು ಇಸ್ರೇಲರನ್ನು ಹಗಲಲ್ಲಿ ಮೇಘಸ್ತಂಭದ ಮೂಲಕವಾಗಿಯೂ ರಾತ್ರಿಯಲ್ಲಿ ಅಗ್ನಿಸ್ತಂಭದ ಮೂಲಕವಾಗಿಯೂ ಮುನ್ನಡೆಸುತ್ತಿರುವುದು ಅವರಿಗೆ ತಿಳಿದಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ಹೀಗಿರಲಾಗಿ, ನೀನು ಒಂದೇ ಪೆಟ್ಟಿನಿಂದ ಈ ಜನರನ್ನು ಸಾಯಿಸಿದರೆ, ನಿನ್ನ ಪ್ರಖ್ಯಾತಿಯನ್ನು ಕೇಳಿದ ಜನಾಂಗಗಳವರು ನಿನ್ನ ವಿಷಯದಲ್ಲಿ, ");
INSERT INTO kan2010_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘ಯೆಹೋವನು ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನಮಾಡಿದ ದೇಶದಲ್ಲಿ ಇಸ್ರೇಲರನ್ನು ಸೇರಿಸುವುದಕ್ಕೆ ಶಕ್ತಿಸಾಲದೆ ಅವರನ್ನು ಮರುಭೂಮಿಯಲ್ಲಿ ನಾಶಮಾಡಿದನು’ ಎಂದು ಮಾತಾಡಿಕೊಳ್ಳುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“ಆದ್ದರಿಂದ ಒಡೆಯನೇ, ನೀನು ಹೇಳಿದಂತೆಯೇ ನಿನ್ನ ತಾಳ್ಮೆಯು ದೀರ್ಘವಾಗಿರಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","ನೀನು ನಿನ್ನ ವಿಷಯದಲ್ಲಿ ‘ಯೆಹೋವನು ದೀರ್ಘಶಾಂತನು, ಬಹುಪ್ರೀತಿಯುಳ್ಳವನು, ಅಪರಾಧ, ಪಾಪಗಳನ್ನು ಕ್ಷಮಿಸುವವನಾಗಿದ್ದರೂ ಎಲ್ಲಾ ದಂಡನೆಯನ್ನು ರದ್ದುಪಡಿಸದವನು, ತಂದೆಗಳ ಪಾಪಫಲವನ್ನು ಮಕ್ಕಳ ಮೇಲೆ ಮೂರು ನಾಲ್ಕು ತಲೆಗಳವರೆಗೆ ಬರಮಾಡುವವನು’ ಎಂದು ನೀನೇ ಹೇಳಿರುವಿಯಲ್ಲಾ! ");
INSERT INTO kan2010_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ನಾವು ಈಜಿಪ್ಟಿನಿಂದ ಬಂದದ್ದು ಮೊದಲುಗೊಂಡು ಇದುವರೆಗೆ ನೀನು ಈ ಜನರ ಪಾಪಗಳನ್ನು ಕ್ಷಮಿಸಿದ ಪ್ರಕಾರವೇ ಈಗಲೂ ಮಹಾಕೃಪೆಯಿಂದ ಇವರ ಪಾಪವನ್ನು ಕ್ಷಮಿಸಬೇಕೆಂದು ನಿನ್ನನ್ನು ಬೇಡಿಕೊಳ್ಳುತ್ತೇನೆ” ಎಂದು ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ಅದಕ್ಕೆ ಯೆಹೋವನು, “ನೀನು ಕೇಳಿಕೊಂಡಂತೆ ನಾನು ಜನರನ್ನು ಕ್ಷಮಿಸುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ಆದಾಗ್ಯೂ ನನ್ನ ಜೀವದಾಣೆ ಮತ್ತು ಯೆಹೋವನ ಮಹಿಮೆಯು ಭೂಲೋಕದಲ್ಲೆಲ್ಲಾ ತುಂಬಿರಬೇಕೆಂಬುವ ನಿಶ್ಚಯ ವಾಕ್ಯದ ಆಣೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ಈಜಿಪ್ಟಿನಲ್ಲಿಯೂ ಮರುಭೂಮಿಯಲ್ಲಿಯೂ ನಾನು ನಡಿಸಿರುವ ಮಹಾತ್ಕಾರ್ಯಗಳನ್ನೂ ನನ್ನ ಮಹಿಮೆಯನ್ನೂ ನೋಡಿದ ಈ ಜನರೆಲ್ಲರೂ ಪದೇಪದೇ ನನ್ನನ್ನು ಪರೀಕ್ಷಿಸಿದ್ದರಿಂದ ಮತ್ತು ನನಗೆ ವಿಧೇಯರಾಗದಿದ್ದ ಕಾರಣ, ");
INSERT INTO kan2010_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ನಾನು ಅವರ ಪೂರ್ವಿಕರಿಗೆ ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶವನ್ನು ಇವರಲ್ಲಿ ಯಾರೂ ನೋಡುವುದಿಲ್ಲ. ನನ್ನನ್ನು ತಿರಸ್ಕರಿಸಿದ ಇವರಲ್ಲಿ ಯಾರೂ ಅದನ್ನು ನೋಡುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ಆದರೆ ನನ್ನ ಸೇವಕನಾದ ಕಾಲೇಬನು ಅವರ ಹಾಗಲ್ಲ, ಅವನು ನನ್ನನ್ನು ಮನಃಪೂರ್ವಕವಾಗಿ ಹಿಂಬಾಲಿಸಿದ್ದಾನೆ. ಆದ್ದರಿಂದ ಅವನು ಸಂಚರಿಸಿ ನೋಡಿದ ದೇಶಕ್ಕೆ ಅವನನ್ನು ಬರಮಾಡುವೆನು ಮತ್ತು ಅವನ ಸಂತತಿಯವರು ಆ ದೇಶವನ್ನು ಹೊಂದುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ಅಮಾಲೇಕ್ಯರೂ ಕಾನಾನ್ಯರೂ ಆ ಕಣಿವೆಯಲ್ಲಿ ವಾಸವಾಗಿದ್ದಾರೆ. ಆದ್ದರಿಂದ ಕೆಂಪುಸಮುದ್ರಕ್ಕೆ ಹೋಗುವ ದಾರಿಯ ಮೂಲಕ ಮರುಭೂಮಿಗೆ ಮರಳಿ ಪ್ರಯಾಣ ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","27","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ, “ಈ ದುಷ್ಟ ಸಮೂಹದವರು ನನಗೆ ವಿರುದ್ಧವಾಗಿ ಇನ್ನೆಷ್ಟರವರೆಗೆ ಗುಣುಗುಟ್ಟುತ್ತಲೇ ಇರುತ್ತಾರೆ. ಇಸ್ರೇಲರು ನನಗೆ ವಿರೋಧವಾಗಿ ಗುಣುಗುಟ್ಟುವುದು ನನಗೆ ಕೇಳಿಸಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ಆದ್ದರಿಂದ ನೀನು ಅವರಿಗೆ ಹೀಗೆ ಹೇಳಬೇಕು: ‘ಯೆಹೋವನು ಹೇಳುವುದೇನೆಂದರೆ: ನನ್ನ ಜೀವದಾಣೆ. ನೀವು ಏನನ್ನು ಹೇಳಿದಿರೋ ಅದನ್ನೇ ನಿಮಗೆ ಮಾಡುತ್ತೇನೆ; ");
INSERT INTO kan2010_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ನಿಮ್ಮ ಶವಗಳು ಈ ಮರುಭೂಮಿಯಲ್ಲಿಯೇ ಬೀಳುವವು. ನೀವು ನನಗೆ ವಿರೋಧವಾಗಿ ಗುಣುಗುಟ್ಟಿದ್ದರಿಂದ ನಿಮ್ಮಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರೆಲ್ಲರೂ ಅಂದರೆ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸ್ಸುಳ್ಳವರೆಲ್ಲರೂ ಮರುಭೂಮಿಯಲ್ಲೇ ಸಾಯುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬ್ ಮತ್ತು ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವ ಇವರಿಬ್ಬರೇ ಹೊರತು ನಿಮ್ಮಲ್ಲಿ ಬೇರೆ ಯಾರೂ ನಾನು ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶವನ್ನು ಸೇರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ಪರರ ಪಾಲಾಗುವರೆಂದು ನೀವು ಹೇಳಿದ ನಿಮ್ಮ ಚಿಕ್ಕ ಮಕ್ಕಳನ್ನು ಅಲ್ಲಿಗೆ ಪ್ರವೇಶಿಸುವಂತೆ ಮಾಡುವೆನು. ನೀವು ತಿರಸ್ಕರಿಸಿದ ದೇಶವನ್ನು ಅವರು ಅನುಭೋಗಿಸುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ನೀವಂತೂ ಈ ಮರುಭೂಮಿಯಲ್ಲಿ ಸಾಯುವಿರಿ. ನಿಮ್ಮೆಲ್ಲರ ಶವಗಳು ಈ ಮರುಭೂಮಿಯಲ್ಲ್ಲಿ ಪರ್ಯಂತರ ಬೀಳುವವು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","“‘ನಿಮ್ಮ ಅಪನಂಬಿಗಸ್ತಿಕೆಯ ಫಲವನ್ನು ನಿಮ್ಮ ಮಕ್ಕಳು ಅನುಭವಿಸುವವರಾಗಿ ನೀವು ಸಾಯುವತನಕ ನಲವತ್ತು ವರ್ಷ ಮರುಭೂಮಿಯಲ್ಲಿ ಅಲೆದಾಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ನೀವು ಆ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡಿದ ನಲವತ್ತು ದಿನಗಳಿಗೆ ಸಮನಾಗಿ, ದಿನ ಒಂದಕ್ಕೆ ಒಂದು ಸಂವತ್ಸರದ ಮೇರೆಗೆ ನಲವತ್ತು ವರ್ಷ ನಿಮ್ಮ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸುವಿರಿ. ನನ್ನನ್ನು ತಿರಸ್ಕರಿಸುವುದೆಂದರೆ ಏನೆಂಬುದು ನಿಮಗೆ ಗೊತ್ತಾಗುತ್ತದೆ.’ ");
INSERT INTO kan2010_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“ಇದು ಯೆಹೋವನೆಂಬ ನಾನು ಹೇಳಿದ ಮಾತು. ನನಗೆ ವಿರೋಧವಾಗಿ ಕೂಡಿಕೊಂಡಿರುವ ಈ ದುಷ್ಟ ಸಮೂಹದವರೆಲ್ಲರಿಗೆ ಈ ಮಾತಿನ ಮೇರೆಗೆ ಖಂಡಿತವಾಗಿ ಮಾಡುತ್ತೇನೆ. ಈ ಮರುಭೂಮಿಯಲ್ಲಿಯೇ ಇವರೆಲ್ಲರೂ ಸಾಯಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","ಆ ದೇಶವನ್ನು ಸಂಚರಿಸಿ ನೋಡುವುದಕ್ಕೆ ಮೋಶೆಯಿಂದ ಕಳುಹಿಸಲ್ಪಟ್ಟು ಹಿಂದಿರುಗಿಬಂದು ಆ ದೇಶದ ವಿಷಯದಲ್ಲಿ ಅಶುಭಸಮಾಚಾರವನ್ನು ಹೇಳಿ ಸರ್ವಸಮೂಹದರವರನ್ನು ಅವರಿಗೆ ವಿರೋಧವಾಗಿ ಗುಣುಗುಟ್ಟುವಂತೆ ಮಾಡಿದ ಹತ್ತು ಜನರು ಯೆಹೋವನಿಂದ ವ್ಯಾಧಿಗೊಳಗಾಗಿ ಸತ್ತರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನು ಮತ್ತು ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬನ ಹೊರತು ಉಳಿದ ಹತ್ತು ಮಂದಿ ಸತ್ತರು. ಯೆಹೋವನು ಅವರಿಬ್ಬರನ್ನು ಉಳಿಸಿದನು. ಅವರಿಗೆ ವ್ಯಾಧಿಯು ತಗಲಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ಮೋಶೆಯು ಈ ಎಲ್ಲಾ ಸಂಗತಿಗಳನ್ನು ಇಸ್ರೇಲರಿಗೆಲ್ಲಾ ಹೇಳಲಾಗಿ ಅವರು ಬಹಳ ದುಃಖಪಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ಮರುದಿನ ಬೆಳಿಗ್ಗೆ ಜನರು ಎದ್ದು, “ನಾವು ಪಾಪ ಮಾಡಿರುವುದು ನಿಜ. ಯೆಹೋವನು ವಾಗ್ದಾನ ಮಾಡಿರುವ ದೇಶಕ್ಕೆ ಹೋಗಲು ನಾವು ಈಗ ಸಿದ್ಧರಾಗಿದ್ದೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ಆದರೆ ಮೋಶೆ ಅವರಿಗೆ, “ನೀವು ಯಾಕೆ ಹೀಗೆ ಮಾಡಿ ಯೆಹೋವನ ಆಜ್ಞೆಯನ್ನು ಮೀರುತ್ತೀರಿ? ನೀವು ಯಶಸ್ವಿಯಾಗುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ಯೆಹೋವನು ನಿಮ್ಮ ಸಂಗಡ ಇರುವುದಿಲ್ಲ. ನೀವು ಆ ದೇಶಕ್ಕೆ ಹೋಗಬೇಡಿರಿ. ಇಲ್ಲವಾದರೆ, ನಿಮ್ಮ ಶತ್ರುಗಳಿಂದ ಸೋಲಿಸಲ್ಪಡುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ಅಮಾಲೇಕ್ಯರೂ ಕಾನಾನ್ಯರೂ ನಿಮ್ಮನ್ನು ಎದುರಿಸಲು ಅಲ್ಲಿರುವುದರಿಂದ ನೀವು ಅವರ ಖಡ್ಗದಿಂದ ಸಾಯುವಿರಿ. ನೀವು ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ದಂಗೆಯೆದ್ದ ಕಾರಣ ಆತನು ನಿಮ್ಮೊಂದಿಗೆ ಇರುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ಆದರೆ ಜನರು ಮೋಶೆಯ ಮಾತನ್ನು ನಂಬಲಿಲ್ಲ. ಅವರು ಪರ್ವತಪ್ರದೇಶದ ಕಡೆಗೆ ಹೊರಟರು. ಆದರೆ ಮೋಶೆಯೂ ಯೆಹೋವನ ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯೂ ಜನರೊಂದಿಗೆ ಹೋಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ಆಗ ಬೆಟ್ಟದ ಸೀಮೆಯಲ್ಲಿ ವಾಸವಾಗಿದ್ದ ಅಮಾಲೇಕ್ಯರೂ ಕಾನಾನ್ಯರೂ ಇಳಿದುಬಂದು ಅವರನ್ನು ಸೋಲಿಸಿ ಹೊರ್ಮಾ ಪಟ್ಟಣದವರೆಗೂ ಅಟ್ಟಿಸಿಕೊಂಡುಬಂದು ಸಂಹರಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಆಜ್ಞಾಪಿಸಬೇಕು: ನಾನು ನಿಮ್ಮ ನಿವಾಸಕ್ಕಾಗಿ ಒಂದು ದೇಶವನ್ನು ಕೊಡುತ್ತಿದ್ದೇನೆ. ನೀವು ಆ ದೇಶಕ್ಕೆ ಸೇರಿದ ನಂತರ ");
INSERT INTO kan2010_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ನೀವು ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕಾಗಿ ನಿಮ್ಮ ಮಂದೆಯಿಂದಾಗಲಿ ಹಿಂಡಿನಿಂದಾಗಲಿ ಅಗ್ನಿಯ ಮೂಲಕ ಯಜ್ಞವನ್ನರ್ಪಿಸುವವನು ಸರ್ವಾಂಗಹೋಮ ಮಾಡಿದರೂ ಅಥವಾ ಸಮಾಧಾನಯಜ್ಞಮಾಡಿದರೂ ಹರಕೆಯ ಯಜ್ಞಮಾಡಿದರೂ ಅಥವಾ ಸ್ವಇಚ್ಛೆಯಿಂದ ಯಜ್ಞಮಾಡಿದರೂ ನಿಯಮಿತ ಹಬ್ಬಗಳಲ್ಲಿ ಯಜ್ಞಮಾಡಿದರೂ ");
INSERT INTO kan2010_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ಅದರೊಂದಿಗೆ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಒಂದೂವರೆ ಸೇರು ಎಣ್ಣೆ ಬೆರಸಿದ ಮೂರು ಸೇರು ಗೋಧಿಯ ಹಿಟ್ಟನ್ನೂ ");
INSERT INTO kan2010_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ಪಾನದ್ರವ್ಯಕ್ಕಾಗಿ ಒಂದೂವರೆ ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ತರಬೇಕು. ನೀವು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಇಲ್ಲವೆ ಸಮಾಧಾನಯಜ್ಞವಾಗಿ ಸಮರ್ಪಿಸುವ ಒಂದೊಂದು ಕುರಿಯೊಂದಿಗೆ ಇದನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ನೀವು ಟಗರನ್ನು ಸಮರ್ಪಿಸುವುದಾದರೆ, ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎರಡು ಸೇರು ಎಣ್ಣೆ ಬೆರಸಿದ ಆರು ಸೇರು ಒಳ್ಳೆಯ ಗೋಧಿಯ ಹಿಟ್ಟನ್ನೂ ");
INSERT INTO kan2010_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ಪಾನದ್ರವ್ಯಕ್ಕಾಗಿ ಎರಡು ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ಅದು ಯೆಹೋವನಿಗೆ ಸುವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವ ಯಜ್ಞವಾಗಿರುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ನಿಮ್ಮಲ್ಲಿ ಎಳೆಹೋರಿಯನ್ನು ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮವನ್ನಾಗಲಿ ಹರಕೆಯ ಯಜ್ಞವನ್ನಾಗಲಿ ಸಮಾಧಾನಯಜ್ಞವನ್ನಾಗಲಿ ಅರ್ಪಿಸುವವನು ");
INSERT INTO kan2010_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ಅದರೊಂದಿಗೆ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಮೂರು ಸೇರು ಎಣ್ಣೆ ಬೆರಸಿದ ಒಂಭತ್ತು ಸೇರು ಗೋಧಿಯ ಹಿಟ್ಟನ್ನೂ ");
INSERT INTO kan2010_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ಪಾನದ್ರವ್ಯಕ್ಕಾಗಿ ಮೂರು ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ತಂದು ಸಮರ್ಪಿಸಬೇಕು. ಇದು ಅಗ್ನಿಯ ಮೂಲಕ ಸಮರ್ಪಿಸುವ ಯಜ್ಞವಾಗಿದೆ. ಇದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚಿಕೆಯನ್ನು ಉಂಟುಮಾಡುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ಕುರಿ, ಆಡು, ಟಗರು, ಹೋರಿ ಇವುಗಳಲ್ಲಿ ಯಾವುದನ್ನು ಅರ್ಪಿಸಿದರೂ ಇದನ್ನು ಮಾಡಲೇಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ನೀವು ಸಮರ್ಪಿಸುವ ಪಶುಗಳ ಲೆಕ್ಕದ ಪ್ರಕಾರವೇ ಒಂದೊಂದು ಪಶುವಿನ ಸಂಗಡ ಈ ರೀತಿಯಾಗಿ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ಇಸ್ರೇಲಿನ ಪ್ರತಿಯೊಬ್ಬ ಸ್ವದೇಶಿಯೂ ಯೆಹೋವನಿಗೆ ಸುಗಂಧಹೋಮವನ್ನು ಸಮರ್ಪಿಸುವಾಗ ಈ ರೀತಿಯಾಗಿ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ನಿಮ್ಮ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುವ ವಿದೇಶಿಯರಲ್ಲಿ ಯಾವನೇ ಆಗಲಿ, ಯೆಹೋವನಿಗೆ ಸುಗಂಧಹೋಮ ಮಾಡಬೇಕಾದರೆ ನಿಮ್ಮಂತೆಯೇ ಅವನು ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ನಿಮಗೂ ನಿಮ್ಮಲ್ಲಿರುವ ಪರದೇಶದವರಿಗೂ ಒಂದೇ ವಿಧಿಯಿರಬೇಕು. ಇದು ನಿಮಗೂ ನಿಮ್ಮ ಸಂತತಿಯವರಿಗೂ ಶಾಶ್ವತ ನಿಯಮ. ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನೀವೂ ಪರದೇಶಿಯರೂ ಒಂದೇ ಆಗಿದ್ದೀರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ನಿಮಗೂ ನಿಮ್ಮ ಬಳಿಯಲ್ಲಿ ವಾಸಿಸುವ ಪರದೇಶದವನಿಗೂ ಒಂದೇ ವಿಧವಾದ ಪ್ರಮಾಣ ವಿಧಿಗಳಿರಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ಇಸ್ರೇಲರಿಗೆ ಈ ಸಂಗತಿಗಳನ್ನು ತಿಳಿಸು: ನಾನು ನಿಮ್ಮನ್ನು ಇನ್ನೊಂದು ದೇಶಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋಗುತ್ತಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ನೀವು ಆ ದೇಶದ ಭೂಮಿಯ ಬೆಳೆಯನ್ನು ಅನುಭೋಗಿಸುವಾಗ, ಸ್ವಲ್ಪವನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ನೀವು ಕಣದಲ್ಲಿರುವ ಗೋಧಿಯಲ್ಲಿ ಪ್ರಥಮಫಲವನ್ನು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಕೊಡುವಂತೆಯೇ ನೀವು ಪ್ರಥಮವಾಗಿ ನಾದಿದ ಹಿಟ್ಟಿನಿಂದ ಒಂದು ರೊಟ್ಟಿಯನ್ನು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ನೀವೂ ನಿಮ್ಮ ಸಂತತಿಯವರೂ ಕಣಕದಿಂದ ಮಾಡುವ ಮೊದಲನೆಯ ರೊಟ್ಟಿಯನ್ನು ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","“ಯೆಹೋವನು ಮೋಶೆಯ ಮೂಲಕ ಪ್ರಕಟಿಸಿದ ಆಜ್ಞೆಗಳನ್ನು ಅಂದರೆ ಯೆಹೋವನು ಆಜ್ಞೆಯನ್ನು ಕೊಟ್ಟ ದಿನದಿಂದಿಡಿದು ಮುಂದಿನ ಎಲ್ಲಾ ಕಾಲದಲ್ಲಿ ನೀವು ತಿಳಿಯದೆ ಯೆಹೋವನ ಆಜ್ಞೆಗಳನ್ನು ಉಲ್ಲಂಘಿಸಿದರೆ ಹೀಗೆ ಮಾಡಬೇಕು: ");
INSERT INTO kan2010_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ನಿರುದ್ದೇಶದಿಂದ ಮತ್ತು ಸಮುದಾಯಕ್ಕೆ ತಿಳಿಯದಂತೆ ಇದನ್ನು ಮಾಡಿದ್ದಾಗಿದ್ದರೆ, ಯೆಹೋವನಿಗೆ ಸುಗಂಧ ವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವುದಕ್ಕಾಗಿ ಒಂದು ಎಳೆಹೋರಿಯನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಅರ್ಪಿಸಬೇಕು ಮತ್ತು ಅದರೊಡನೆ ಧಾನ್ಯಾರ್ಪಣೆಯನ್ನೂ ಪಾನಾರ್ಪಣೆಯನ್ನೂ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಒಂದು ಹೋತವನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“ಈ ರೀತಿಯಲ್ಲಿ ಇಸ್ರೇಲರ ಇಡೀ ಸಮುದಾಯದವರ ಕ್ಷಮೆಗಾಗಿ ಯಾಜಕನು ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ಯಾಕೆಂದರೆ ಅದು ತಿಳಿಯದೆ ಮಾಡಿದ ತಪ್ಪಾಗಿತ್ತು ಮತ್ತು ಆ ತಪ್ಪಿಗಾಗಿ ಅವರು ತಮ್ಮ ಅರ್ಪಣೆಯನ್ನು ಯೆಹೋವನಿಗೆ ಕಾಣಿಕೆಯಾಗಿ ತಂದರು ಮತ್ತು ಯೆಹೋವನ ಎದುರಿನಲ್ಲಿ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ಆದ್ದರಿಂದ ಇಡೀ ಇಸ್ರೇಲ್ ಸಮುದಾಯದವರಿಗೆ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು ಮತ್ತು ಅವರ ಮಧ್ಯದಲ್ಲಿ ವಾಸಿಸುವ ಪರದೇಶಸ್ಥರಿಗೂ ಕ್ಷಮಾಪಣೆಯಾಗುವುದು; ಯಾಕೆಂದರೆ ಜನರೆಲ್ಲರೂ ನಿರುದ್ದೇಶದಿಂದ ಮಾಡಿದ ಆ ತಪ್ಪಿನಲ್ಲಿ ಸಿಕ್ಕಿಕೊಂಡಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ಆದರೆ ಒಬ್ಬನು ತಿಳಿಯದೆ ಪಾಪಮಾಡಿದರೆ, ಅವನು ಒಂದು ವರ್ಷದ ಹೆಣ್ಣು ಆಡನ್ನು ದೋಷ ಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ಆಗ ಯಾಜಕನು ನಿರುದ್ದೇಶದಿಂದ ತಪ್ಪುಮಾಡಿದವನ ಕ್ಷಮಾಪಣೆಗಾಗಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ನಿರುದ್ದೇಶದಿಂದ ತಪ್ಪುಮಾಡಿದ ಪ್ರತಿಯೊಬ್ಬರಿಗೂ ಈ ನಿಯಮ ಅನ್ವಯಿಸುತ್ತದೆ. ಈ ವಿಷಯದಲ್ಲಿ ಇಸ್ರೇಲರಲ್ಲಿರುವ ಸ್ವದೇಶದವರಿಗೂ ಪರದೇಶದವರಿಗೂ ಒಂದೇ ವಿಧಿಯಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ಆದರೆ ಉದ್ದೇಶಪೂರ್ವಕವಾಗಿ ಪಾಪಮಾಡುವವನು ಯೆಹೋವನಿಗೆ ಅವಮಾನ ಮಾಡುವವನಾಗಿದ್ದಾನೆ. ಅವನನ್ನು ಕುಲದಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ಈ ನಿಯಮವು ಇಸ್ರೇಲರಲ್ಲಿ ಹುಟ್ಟಿದ ಪ್ರತಿಯೊಬ್ಬನಿಗೂ ಹಾಗೂ ಪರದೇಶಸ್ಥರಿಗೂ ಅನ್ವಯಿಸುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ಆ ಮನುಷ್ಯನು ಯೆಹೋವನ ಮಾತನ್ನು ತಾತ್ಸಾರಮಾಡಿ ಆತನ ಆಜ್ಞೆಯನ್ನು ಮೀರಿದ್ದರಿಂದ ಕುಲದಿಂದ ತೆಗೆದುಹಾಕಲ್ಪಡಲೇಬೇಕು. ಅವನು ತನ್ನ ಪಾಪದ ಫಲವನ್ನು ಅನುಭವಿಸಲಿ.” ");
INSERT INTO kan2010_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ಇಸ್ರೇಲರು ಮರುಭೂಮಿಯಲ್ಲಿ ಇನ್ನೂ ಇದ್ದಾಗ ಒಬ್ಬನು ಸಬ್ಬತ್‌ದಿನದಲ್ಲಿ ಕಟ್ಟಿಗೆ ಕೂಡಿಸುವುದನ್ನು ಜನರು ಕಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ಕಂಡವರು ಅವನನ್ನು ಮೋಶೆ ಆರೋನರ ಮತ್ತು ಸರ್ವಸಮೂಹದವರ ಬಳಿಗೆ ಹಿಡಿದುಕೊಂಡು ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ಅವನನ್ನು ಶಿಕ್ಷಿಸಬೇಕಾದ ವಿಧಿಯನ್ನು ಅವರು ತಿಳಿಯದೆ ಇದ್ದುದರಿಂದ ಅವನನ್ನು ಕಾವಲಲ್ಲಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಆ ಮನುಷ್ಯನು ಸಾಯಬೇಕು. ಅವನನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಹೋಗಿ ಎಲ್ಲಾ ಜನರು ಕಲ್ಲೆಸೆದು ಕೊಲ್ಲಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ಆಗ ಜನರು ಅವನನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಕರೆದುಕೊಂಡು ಹೋಗಿ ಕಲ್ಲೆಸೆದು ಕೊಂದರು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವರು ಇದನ್ನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ಇಸ್ರೇಲರಿಗೆ ಈ ಸಂಗತಿಗಳನ್ನು ತಿಳಿಸು: ನನ್ನ ಅಪ್ಪಣೆಗಳನ್ನು ಜ್ಞಾಪಕಮಾಡುವುದಕ್ಕೆ ನಿಮಗೆ ಒಂದು ಗುರುತನ್ನು ಕೊಡುತ್ತೇನೆ. ನಿಮ್ಮ ಬಟ್ಟೆಗಳ ಮೂಲೆಯಲ್ಲಿ ಗೊಂಡೆಗಳನ್ನು ಕಟ್ಟಿಕೊಳ್ಳಬೇಕು. ಪ್ರತಿಯೊಂದು ಗೊಂಡೆಯೂ ಒಂದೊಂದು ನೀಲಿದಾರದಿಂದ ಕೂಡಿರಬೇಕು. ನೀವು ಇವುಗಳನ್ನು ಇಂದಿನಿಂದ ಯಾವಾಗಲೂ ಧರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ಈ ಗೊಂಡೆಗಳನ್ನು ನೀವು ನೋಡುವಾಗ, ಯೆಹೋವನು ನಿಮಗೆ ಕೊಟ್ಟ ಅಪ್ಪಣೆಗಳನ್ನೆಲ್ಲ ಜ್ಞಾಪಕಮಾಡಿಕೊಳ್ಳಬೇಕು ಮತ್ತು ಅವುಗಳಿಗೆ ವಿಧೇಯರಾಗಬೇಕು. ನೀವು ನಿಮ್ಮ ಮನಸ್ಸಿಗೆ ಮತ್ತು ಕಣ್ಣಿಗೆ ತೋರಿದ ಪ್ರಕಾರ ನಡೆಯದೆ ನಂಬಿಗಸ್ತರಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ನೀವು ನನ್ನ ಎಲ್ಲಾ ಆಜ್ಞೆಗಳನ್ನು ಜ್ಞಾಪಿಸಿಕೊಂಡು ವಿಧೇಯರಾಗಿರಬೇಕು. ಆಗ ನೀವು ನಿಮ್ಮ ದೇವರ ವಿಶೇಷವಾದ ಜನರಾಗಿರುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ನಿಮ್ಮ ದೇವರಾಗಿರುವುದಕ್ಕೆ ನಿಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಗೆ ಕರೆತಂದ ನಿಮ್ಮ ದೇವರಾದ ಯೆಹೋವನು ನಾನೇ.” ");
INSERT INTO kan2010_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ಕೋರಹ, ದಾತಾನ್, ಅಬೀರಾಮ್ ಮತ್ತು ಓನ್ ಎಂಬವರು ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ಎದ್ದರು. (ಕೋರಹನು ಇಚ್ಹಾರನ ಮಗನು, ಇಚ್ಹಾರನು ಕೆಹಾತನ ಮಗನು. ಕೆಹಾತನು ಲೇವಿಯ ಮಗನು. ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮ್ ಇವರು ಎಲೀಯಾಬನ ಗಂಡುಮಕ್ಕಳು ಮತ್ತು ಓನನು ಪೆಲೆತನ ಮಗನು. ದಾತಾನ್, ಅಬೀರಾಮ್ ಮತ್ತು ಓನ್ ಇವರು ರೂಬೇನನ ಸಂತತಿಯವರು.) ");
INSERT INTO kan2010_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ಈ ನಾಲ್ಕು ಮಂದಿ ಇಸ್ರೇಲರು ಇನ್ನಿತರ ಇನ್ನೂರೈವತ್ತು ಗಂಡಸರೊಂದಿಗೆ ಮೋಶೆಗೆ ವಿರುದ್ಧವಾಗಿ ಎದ್ದರು. ಅವರು ಜನರಿಂದ ಆರಿಸಲ್ಪಟ್ಟ ನಾಯಕರಾಗಿದ್ದುದರಿಂದ ಜನರೆಲ್ಲರೂ ಅವರನ್ನು ಬಲ್ಲವರಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ಅವರು ಮೋಶೆ ಮತ್ತು ಆರೋನರ ವಿರುದ್ಧ ಒಟ್ಟಾಗಿ ಸೇರಿಬಂದು, ಅವರಿಗೆ, “ನೀವು ಅಧಿಕಾರವನ್ನು ಮತ್ತು ಘನತೆಯನ್ನು ಅತಿಯಾಗಿ ಅಪೇಕ್ಷಿಸುತ್ತಿರುವಿರಿ. ಈ ಸಮೂಹದವರಲ್ಲಿರುವ ಪ್ರತಿಯೊಬ್ಬನೂ ದೇವರಿಗೆ ಪ್ರತಿಷ್ಠಿತನೇ. ಯೆಹೋವನು ಇವರೆಲ್ಲರ ಮಧ್ಯದಲ್ಲಿ ಇದ್ದಾನೆ. ಹೀಗಿರಲಾಗಿ ಯೆಹೋವನ ಜನರಿಗಿಂತಲೂ ನಿಮ್ಮನ್ನು ನೀವೇ ಹೆಚ್ಚಿಸಿಕೊಳ್ಳುವುದೇನು?” ಎಂದು ಕೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ಮೋಶೆ ಇದನ್ನು ಕೇಳಿ ನೆಲದವರೆಗೆ ಬಾಗಿ ");
INSERT INTO kan2010_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ಕೋರಹ ಮತ್ತು ಅವನ ಹಿಂಬಾಲಕರೆಲ್ಲರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ನಾಳೆ ಮುಂಜಾನೆ ಯಾವನು ಯೆಹೋವನವನೆಂದು ಯೆಹೋವನು ತೋರಿಸುವನು. ಯಾವನು ಪ್ರತಿಷ್ಠಿತನೆಂದು ಯೆಹೋವನು ತೋರಿಸುವನು ಮತ್ತು ಯೆಹೋವನು ಅವನನ್ನು ತನ್ನ ಹತ್ತಿರ ಕರೆದುಕೊಳ್ಳುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ಆದ್ದರಿಂದ ಕೋರಹನೇ, ನೀನೂ ನಿನ್ನ ಹಿಂಬಾಲಕರೆಲ್ಲರೂ ಈ ಕಾರ್ಯವನ್ನು ಮಾಡಬೇಕು: ");
INSERT INTO kan2010_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ನಾಳೆ ಅಗ್ಗಿಷ್ಠಿಕೆಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಅವುಗಳ ಮೇಲೆ ಉರಿಯುವ ಕೆಂಡಗಳನ್ನು ಹಾಕಿರಿ ಮತ್ತು ಯೆಹೋವನ ಮುಂದೆ ಅವುಗಳ ಮೇಲೆ ಧೂಪವನ್ನು ಹಾಕಿರಿ. ಆಗ ಯೆಹೋವನು ಯಾರನ್ನು ಆರಿಸಿಕೊಳ್ಳುವನೊ ಅವನೇ ನಿಜವಾಗಿಯೂ ಪವಿತ್ರನಾದವನು. ಲೇವಿಯರಾದ ನೀವು ಅಧಿಕಾರವನ್ನು ಮತ್ತು ಘನತೆಯನ್ನು ಅತಿಯಾಗಿ ಅಪೇಕ್ಷಿಸುತ್ತೀರಿ.” ಎಂದು ಹೇಳಿದನು ");
INSERT INTO kan2010_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ಮೋಶೆಯು ಕೋರಹನಿಗೆ, “ಲೇವಿಯರೇ, ಕೇಳಿರಿ! ");
INSERT INTO kan2010_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ಇಸ್ರೇಲರ ದೇವರು ನಿಮ್ಮನ್ನು ಸರ್ವಸಮೂಹದಿಂದ ಆರಿಸಿಕೊಂಡದ್ದಕ್ಕಾಗಿ ನೀವು ಸಂತೋಷಪಡಬೇಕು. ದೇವರ ಪವಿತ್ರ ಗುಡಾರಕ್ಕೆ ಸಂಬಂಧಿಸಿದ ಕೆಲಸವನ್ನು ಮಾಡುವುದಕ್ಕೂ ಇಸ್ರೇಲರ ಸೇವೆಯನ್ನು ಮಾಡುವುದಕ್ಕೂ ಮತ್ತು ಯಜ್ಞಗಳನ್ನು ಸಿದ್ಧಪಡಿಸುವುದರಲ್ಲಿ ಅವರಿಗೆ ಸಹಾಯಮಾಡುವುದಕ್ಕೂ ಯೆಹೋವನು ನಿಮ್ಮನ್ನು ತನ್ನ ಸಮೀಪಕ್ಕೆ ಬರಗೊಡಿಸಿದ್ದಾನೆ. ಅದು ನಿಮಗೆ ಸಾಕಾಗಲಿಲ್ಲವೇ? ");
INSERT INTO kan2010_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ಈ ರೀತಿ ಆತನ ಬಳಿಯಲ್ಲಿ ಸೇವೆಮಾಡಲು ನಿನಗೂ ನಿನ್ನ ಸಹೋದ್ಯೋಗಿಗಳಾದ ಎಲ್ಲಾ ಲೇವಿಯರಿಗೂ ಯೆಹೋವನು ಅವಕಾಶ ಕೊಟ್ಟಿದ್ದಾನೆ. ಆದರೆ ಈಗ ನೀವು ಯಾಜಕರಾಗಬೇಕೆಂದು ಸಹ ಪ್ರಯತ್ನಿಸುತ್ತಿದ್ದೀರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ನೀವೂ ನಿಮ್ಮ ಹಿಂಬಾಲಕರೂ ಒಟ್ಟಾಗಿ ಸೇರಿಕೊಂಡು ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ದಂಗೆ ಎದ್ದಿದ್ದೀರಿ. ಆರೋನನು ತನ್ನನ್ನು ತಾನೇ ಮಹಾಯಾಜಕನನ್ನಾಗಿ ಆರಿಸಿಕೊಂಡನೋ? ಇಲ್ಲ! ಹೀಗಿರಲು ಆರೋನನಿಗೆ ವಿರೋಧವಾಗಿ ಗುಣುಗುಟ್ಟುವುದೇಕೆ?” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ಬಳಿಕ ಮೋಶೆ ಎಲೀಯಾಬನ ಗಂಡುಮಕ್ಕಳಾದ ದಾತಾನನನ್ನೂ ಅಬೀರಾಮನನ್ನೂ ಕರೇಕಳುಹಿಸಲಾಗಿ, ಅವರು ಅವನಿಗೆ, “ನಾವು ಬರುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ನೀನು ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶದಿಂದ ನಮ್ಮನ್ನು ಕರೆದುಕೊಂಡು ಬಂದು ಮರಳುಗಾಡಿನಲ್ಲಿ ಸಾಯಿಸುವುದು ಸಾಕಾಗಲಿಲ್ಲವೆಂದು ಭಾವಿಸಿ ನಮ್ಮ ಮೇಲೆ ದೊರೆತನ ಮಾಡಲು ಅಪೇಕ್ಷಿಸುತ್ತಿರುವೆಯೋ? ");
INSERT INTO kan2010_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ನಾವು ನಿನ್ನನ್ನು ಯಾಕೆ ಹಿಂಬಾಲಿಸಬೇಕು? ನೀನು ನಮ್ಮನ್ನು ಹಾಲೂ ಜೇನೂ ಹರಿಯುವ ದೇಶಕ್ಕೆ ಕರೆದುಕೊಂಡು ಬರಲಿಲ್ಲ. ನೀನು ನಮ್ಮ ಸ್ವಂತಕ್ಕೆ ಹೊಲಗಳನ್ನಾಗಲಿ ದ್ರಾಕ್ಷೇತೋಟಗಳನ್ನಾಗಲಿ ಕೊಡಲಿಲ್ಲ! ನೀನು ಈ ಜನರಿಗೆ ಇದೇ ರೀತಿ ಮೋಸಮಾಡಬೇಕೆಂದಿರುವೆಯೋ? ನಾವು ಬರುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ಇದರಿಂದ ಮೋಶೆ ಬಹಳ ಕೋಪಗೊಂಡನು. ಅವನು ಯೆಹೋವನಿಗೆ, “ನಾನು ಈ ಜನರಿಗೆ ಎಂದೂ ತೊಂದರೆ ಮಾಡಲಿಲ್ಲ. ಅವರಿಂದ ನಾನು ಒಂದು ಕತ್ತೆಯನ್ನಾದರೂ ತೆಗೆದುಕೊಂಡವನಲ್ಲ. ಯೆಹೋವನೇ, ಅವರ ಕಾಣಿಕೆಯನ್ನು ಸ್ವೀಕರಿಸಬೇಡ” ಎಂದು ಮನವಿ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ಆಗ ಮೋಶೆಯು ಕೋರಹನಿಗೆ, “ನೀನು ಮತ್ತು ನಿನ್ನ ಹಿಂಬಾಲಕರೆಲ್ಲರು ನಾಳೆ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಆರೋನನೊಡನೆ ನಿಲ್ಲಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು ತನ್ನತನ್ನ ಧೂಪಾರತಿಯನ್ನು ಅಂದರೆ ಒಟ್ಟಾಗಿ ಇನ್ನೂರೈವತ್ತು ಧೂಪಾರತಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಧೂಪಹಾಕಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ಬರಬೇಕು. ಹಾಗೆಯೇ ನೀನೂ ಆರೋನನೂ ನಿಮ್ಮನಿಮ್ಮ ಧೂಪಾರತಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ಬರಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ಅದಕ್ಕನುಸಾರವಾಗಿ ಅವರೆಲ್ಲರೂ ತಮ್ಮತಮ್ಮ ಧೂಪಾರತಿಗಳನ್ನು ಕೈಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಅವುಗಳಲ್ಲಿ ಕೆಂಡಗಳನ್ನಿಟ್ಟು ಧೂಪದ್ರವ್ಯಗಳನ್ನು ಹಾಕಿ ಮೋಶೆ ಆರೋನರ ಜೊತೆಯಲ್ಲಿ ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದಲ್ಲಿ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ಕೋರಹನು ತಮಗೆ ಎದುರಾಗಿ ಸರ್ವಸಮೂಹದವರನ್ನು ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದ ಹತ್ತಿರಕ್ಕೆ ಕೂಡಿಸಿದನು. ಆಗ ಯೆಹೋವನ ಮಹಿಮೆ ಸಮೂಹದವರೆಲ್ಲರಿಗೆ ಪ್ರತ್ಯಕ್ಷವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ಈ ಜನರನ್ನು ಬಿಟ್ಟು ಪ್ರತ್ಯೇಕವಾಗಿ ನಿಲ್ಲಿರಿ. ನಾನು ಅವರನ್ನು ಈಗ ನಾಶ ಮಾಡಬಯಸುತ್ತೇನೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ಆದರೆ ಮೋಶೆ ಆರೋನರು ನೆಲದವರೆಗೆ ಬಾಗಿ, “ದೇವರೇ, ಎಲ್ಲಾ ಜನರ ಆಲೋಚನೆ ನಿನಗೆ ಗೊತ್ತಿದೆ. ದಯಮಾಡಿ ಎಲ್ಲಾ ಜನರ ಮೇಲೆ ಕೋಪಗೊಳ್ಳಬೇಡ. ನಿಜವಾಗಿ ಪಾಪಮಾಡಿದವನು ಕೇವಲ ಒಬ್ಬನಲ್ಲವೇ?” ಎಂದು ಮೊರೆಯಿಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ಜನರಿಗೆ ಕೋರಹ, ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮರ ಗುಡಾರದ ಸುತ್ತಮುತ್ತಲಿಂದ ದೂರಹೋಗಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ಮೋಶೆಯು ಎದ್ದು ಕೋರಹ, ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮರ ಬಳಿಗೆ ಹೋದನು. ಇಸ್ರೇಲರ ಹಿರಿಯರೆಲ್ಲರೂ ಅವನನ್ನು ಹಿಂಬಾಲಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ಮೋಶೆಯು ಜನರನ್ನು ಎಚ್ಚರಿಸಿ, “ಈ ಕೆಟ್ಟ ಜನರ ಗುಡಾರಗಳಿಂದ ಹೊರಟುಹೋಗಿರಿ. ಇವರ ಸ್ವತ್ತಿನಲ್ಲಿ ಯಾವುದನ್ನೂ ಮುಟ್ಟಬಾರದು. ಇಲ್ಲವಾದರೆ ಅವರ ಪಾಪಗಳ ದೆಸೆಯಿಂದ ನೀವೂ ನಾಶವಾಗುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ಆದ್ದರಿಂದ ಜನರು ಕೋರಹ, ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮರ ಗುಡಾರಗಳನ್ನು ಬಿಟ್ಟು ದೂರಹೋದರು. ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮ್ ಹೊರಗೆ ಬಂದು ತಮ್ಮ ಡೇರೆಗಳ ಪ್ರವೇಶದ್ವಾರದ ಬಳಿ ತಮ್ಮ ಹೆಂಡತಿಯರೊಡನೆ, ಮಕ್ಕಳೊಡನೆ ಮತ್ತು ಕೂಸುಗಳೊಡನೆ ನಿಂತುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ಆಗ ಮೋಶೆ ಜನರಿಗೆ, “ಈ ಕಾರ್ಯಗಳೆಲ್ಲಾ ನನ್ನ ಆಲೋಚನೆಯಿಂದ ಆಗಲಿಲ್ಲವೆಂದೂ ಯೆಹೋವನೇ ಈ ಕಾರ್ಯಗಳನ್ನು ಮಾಡುವುದಕ್ಕೆ ನನ್ನನ್ನು ಕಳುಹಿಸಿದನೆಂದು ನೀವು ತಿಳಿದುಕೊಳ್ಳುವಂತೆ ನಾನು ಸಾಕ್ಷಿಯನ್ನು ಕೊಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ಇಲ್ಲಿರುವ ಜನರು ಸಾಯುವರು. ಆದರೆ ಇವರ ಅಂತ್ಯವು ಎಲ್ಲರಿಗೂ ಸಂಭವಿಸುವ ಅಂತ್ಯವಾಗಿದ್ದರೆ, ಯೆಹೋವನು ನನ್ನನ್ನು ಕಳುಹಿಸಲಿಲ್ಲವೆಂದು ತಿಳಿದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ಆದರೆ ಯೆಹೋವನು ಇವರಿಗೋಸ್ಕರ ಅಪೂರ್ವ ಶಿಕ್ಷೆಯನ್ನು ಕಲ್ಪಿಸಿದರೆ ಅಂದರೆ ಭೂಮಿಯು ಬಾಯ್ದೆರೆದು ಇವರನ್ನೂ ಇವರ ಸರ್ವಸ್ವವನ್ನೂ ನುಂಗುವುದರಿಂದ ಇವರೆಲ್ಲರೂ ಸಜೀವಿಗಳಾಗಿ ಸಮಾಧಿಯಾದರೆ, ಇವರು ನಿಜವಾಗಿಯೂ ಯೆಹೋವನನ್ನು ತಿರಸ್ಕರಿಸಿದವರೆಂದು ನೀವು ತಿಳಿದುಕೊಳ್ಳಬೇಕು” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ಕೂಡಲೇ, ಆ ಜನರು ನಿಂತಿದ್ದ ನೆಲವು ಸೀಳಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ಭೂಮಿಯೇ ಬಾಯಿತೆರೆದು ಅವರನ್ನು ನುಂಗಿಬಿಟ್ಟಿತೊ ಎಂಬಂತೆ, ಅವರ ಕುಟುಂಬಗಳವರನ್ನು ಕೋರಹನ ಎಲ್ಲಾ ಹಿಂಬಾಲಕರನ್ನು ಮತ್ತು ಅವರ ಆಸ್ತಿಯೆಲ್ಲವನ್ನು ನುಂಗಿಬಿಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ಆ ಜನರೆಲ್ಲಾ ಸಜೀವ ಸಮಾಧಿಯಾದರು. ಅವರ ಆಸ್ತಿಪಾಸ್ತಿಯೆಲ್ಲಾ ಅವರೊಡನೆ ಭೂಸಮಾಧಿಯಾಯಿತು. ಆ ಬಳಿಕ ಭೂಮಿ ಅವರ ಸಮೇತವಾಗಿ ಮುಚ್ಚಿಕೊಂಡಿತು. ಅದೇ ಅವರ ಅಂತ್ಯವಾಯಿತು. ಅವರು ಸಮುದಾಯದಿಂದ ಶಾಶ್ವತವಾಗಿ ಇಲ್ಲವಾದರು! ");
INSERT INTO kan2010_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ನಾಶವಾಗುತ್ತಿರುವ ಜನರ ಗೋಳಾಟವನ್ನು ಕೇಳಿದ ಇಸ್ರೇಲ್ ಜನರು, “ಭೂಮಿಯು ನಮ್ಮನ್ನೂ ನುಂಗಿಬಿಡುತ್ತದೆ!” ಎಂದುಕೊಂಡು ನಾನಾ ದಿಕ್ಕುಗಳಿಗೆ ಓಡಿಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ಅಲ್ಲದೆ ಯೆಹೋವನಿಂದ ಬೆಂಕಿಯು ಹೊರಟುಬಂದು ಧೂಪವನ್ನು ಅರ್ಪಿಸುತ್ತಿದ್ದ ಇನ್ನೂರೈವತ್ತು ಮಂದಿಯನ್ನು ದಹಿಸಿಬಿಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“ಯಾಜಕನಾದ ಆರೋನನ ಮಗ ಎಲ್ಲಾಜಾರನು ಸುಟ್ಟುಹೋದವರ ನಡುವೆಯಿಂದ ಧೂಪಾರತಿಗಳನ್ನು ಎತ್ತಬೇಕೆಂದು ಆಜ್ಞಾಪಿಸು ಮತ್ತು ನೀನು ಅವುಗಳಲ್ಲಿರುವ ಕೆಂಡಗಳನ್ನು ದೂರಕ್ಕೆ ಚೆಲ್ಲು. ಯಾಕೆಂದರೆ ಆ ಧೂಪಾರತಿಗಳು ಪವಿತ್ರವಾದವುಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ಪ್ರಾಣವನ್ನು ಕಳೆದುಕೊಂಡ ಆ ದೋಷಿಗಳ ಧೂಪಾರತಿಗಳು ಯೆಹೋವನ ಸನ್ನಿಧಿಗೆ ತರಲ್ಪಟ್ಟ ಕಾರಣ ಪರಿಶುದ್ಧವಾಗಿವೆ. ಆದ್ದರಿಂದ ಅವುಗಳನ್ನು ತೆಗೆದು ತಗಡುಗಳಾಗಿ ಹೊಡೆದು ಯಜ್ಞವೇದಿಕೆಗೆ ಮುಚ್ಚಳವನ್ನು ಮಾಡಿಸಬೇಕು. ಇದು ಇಸ್ರೇಲರೆಲ್ಲರಿಗೆ ಎಚ್ಚರಿಕೆಯಾಗಿರುವುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ಯೆಹೋವನು ಮೋಶೆಗೆ ಕೊಟ್ಟ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ಸುಟ್ಟುಹೋದವರಿಂದ ತರಲ್ಪಟ್ಟಿದ್ದ ಆ ತಾಮ್ರದ ಧೂಪಾರತಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡು ತಗಡುಗಳಾಗಿ ಹೊಡಿಸಿ ಯಜ್ಞವೇದಿಕೆಗೆ ಮುಚ್ಚಳವನ್ನು ಮಾಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ಆರೋನನ ಕುಟುಂಬದವನು ಮಾತ್ರ ಯೆಹೋವನ ಎದುರಿನಲ್ಲಿ ಧೂಪವನ್ನು ಹಾಕತಕ್ಕದ್ದು ಮತ್ತು ಬೇರೆ ಯಾರಾದರೂ ಹಾಕಿದರೆ ಅವರು ಕೋರಹ ಮತ್ತು ಅವನ ಹಿಂಬಾಲಕರಂತೆ ಸಾಯುವರು ಎಂಬುದನ್ನು ಇಸ್ರೇಲರಿಗೆ ಆ ಮುಚ್ಚಳವು ನೆನಪು ಮಾಡುವ ಗುರುತಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ಮರುದಿನ ಇಸ್ರೇಲರೆಲ್ಲರೂ ಮೋಶೆ ಆರೋನರ ವಿರುದ್ಧ ಗುಣುಗುಟ್ಟುತ್ತಾ, “ನೀವೇ ಯೆಹೋವನ ಜನರನ್ನು ಸಾಯಿಸಿದಿರಿ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ಮೋಶೆ ಆರೋನರನ್ನು ಎದುರಿಸಲು ಜನರು ಒಟ್ಟಾಗಿ ಸೇರಿಬಂದಿದ್ದಾಗ, ದೇವದರ್ಶನಗುಡಾರದ ಕಡೆಗೆ ತಿರುಗಿ ನೋಡಲಾಗಿ, ದೇವದರ್ಶನಗುಡಾರವನ್ನು ಮೋಡ ಮುಚ್ಚಿಕೊಂಡಿರುವುದನ್ನೂ ಯೆಹೋವನ ಮಹಿಮೆಯು ಪ್ರತ್ಯಕ್ಷವಾಗಿರುವುದನ್ನೂ ಅವರು ಕಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ಆಗ ಮೋಶೆ ಆರೋನರು ದೇವದರ್ಶನಗುಡಾರದ ಮುಂದಕ್ಕೆ ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ಆ ಜನರಿಂದ ನೀವಿಬ್ಬರೂ ದೂರಹೋಗಿರಿ. ನಾನು ಈಗ ಅವರನ್ನು ನಾಶಮಾಡುತ್ತೇನೆ” ಎಂದು ಹೇಳಿದನು. ಆಗ ಮೋಶೆ ಆರೋನರು ಅಡ್ಡಬಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ಮೋಶೆಯು ಆರೋನನಿಗೆ, “ಯೆಹೋವನಿಗೆ ಕೋಪವುಂಟಾಗಿ ಈ ಜನರೊಳಗೆ ಘೋರವ್ಯಾಧಿ ಪ್ರಾರಂಭವಾಗಿದೆ. ನೀನು ಧೂಪಾರತಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಅದರಲ್ಲಿ ಯಜ್ಞವೇದಿಕೆಯಿಂದ ತೆಗೆದ ಕೆಂಡಗಳನ್ನು ಇಟ್ಟು ಧೂಪಹಾಕಿ ಸಮೂಹದವರ ಬಳಿಗೆ ಬೇಗ ಹೋಗಿ ಅವರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ಮೋಶೆ ಹೇಳಿದಂತೆ ಆರೋನನು ಧೂಪಾರತಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ಸಮೂಹದವರ ಮಧ್ಯಕ್ಕೆ ಓಡಿಹೋದಾಗ, ಘೋರವ್ಯಾಧಿ ಆ ಜನರಲ್ಲಿ ಹರಡಿಕೊಳ್ಳುತ್ತಾ ಇತ್ತು. ಅವನು ಧೂಪಹಾಕಿ ಜನರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ಅವನು ಸತ್ತವರಿಗೂ ಬದುಕಿರುವವರಿಗೂ ನಡುವೆ ನಿಂತುಕೊಂಡನು. ಆಗ ಕಾಯಿಲೆ ನಿಂತುಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ಕೋರಹನೂ ಸೇರಿದಂತೆ ಆ ಕಾಯಿಲೆಯಿಂದ ಸತ್ತವರು ಹದಿನಾಲ್ಕು ಸಾವಿರದ ಏಳುನೂರು ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ಕಾಯಿಲೆಯು ನಿಂತುಹೋದಾಗ, ಆರೋನನು ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದಲ್ಲಿದ್ದ ಮೋಶೆಯ ಬಳಿಗೆ ತಿರುಗಿ ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ಇಸ್ರೇಲರ ಸಂಗಡ ಮಾತಾಡಿ ಹೀಗೆ ಮಾಡಬೇಕು: ಅವರ ಕುಲಗಳ ಪ್ರತಿಯೊಬ್ಬ ಪ್ರಧಾನನಿಂದ ಒಂದೊಂದು ಕೋಲಿನ ಮೇರೆಗೆ ಹನ್ನೆರಡು ಕೋಲುಗಳನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅವನವನ ಕೋಲಿನ ಮೇಲೆ ಆಯಾ ಕುಲಪ್ರಧಾನನ ಹೆಸರನ್ನು ಬರೆಯಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ಲೇವಿ ಕುಲದ ಕೋಲಿನ ಮೇಲೆ ಆರೋನನ ಹೆಸರನ್ನು ಬರೆಯಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ನೀನು ಆ ಕುಲಗಳನ್ನು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಅಂದರೆ ನಾನು ನಿನ್ನನ್ನು ಸಂಧಿಸುವ ಒಡಂಬಡಿಕೆ ಪೆಟ್ಟಿಗೆಯ ಮುಂದೆ ಇಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ನಾನು ಒಬ್ಬನನ್ನು ನನ್ನ ಯಾಜಕನನ್ನಾಗಿ ಆರಿಸಿಕೊಳ್ಳುವೆನು; ಅವನ ಕೋಲು ಚಿಗುರುವುದು, ಇಸ್ರೇಲ್ ಜನರು ನಿಮ್ಮ ವಿರುದ್ಧವಾಗಿ ಹೇಳುತ್ತಿರುವ ದೂರುಗಳನ್ನು ನಾನು ಹೀಗೆ ನಿಲ್ಲಿಸುವೆನು.” ");
INSERT INTO kan2010_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ಅದಕ್ಕನುಸಾರವಾಗಿ ಮೋಶೆಯು ಇಸ್ರೇಲರ ಸಂಗಡ ಮಾತಾಡಲಾಗಿ ಅವರ ಕುಲಪ್ರಧಾನರೆಲ್ಲ ಅವನಿಗೆ, ಒಬ್ಬ ಕುಲಪ್ರಧಾನನಿಗೆ ಒಂದು ಕೋಲಿನಂತೆ, ಹನ್ನೆರಡು ಕೋಲುಗಳನ್ನು ಕೊಟ್ಟರು. ಅವುಗಳೊಡನೆ ಆರೋನನ ಕೋಲೂ ಇತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ಮೋಶೆ ಆ ಕೋಲುಗಳನ್ನು ಒಡಂಬಡಿಕೆಯ ಗುಡಾರದಲ್ಲಿ ಯೆಹೋವನ ಮುಂದೆ ಇಟ್ಟನು. ಆರೋನನು ಪ್ರಧಾನಯಾಜಕನಾಗಿದ್ದಾನೆಂದು ದೇವರು ಸಾಕ್ಷೀಕರಿಸಿದ್ದು ");
INSERT INTO kan2010_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ಮರುದಿನ ಮೋಶೆ ಗುಡಾರದೊಳಗೆ ಹೋಗಿ ನೋಡಲಾಗಿ ಲೇವಿಕುಲದ ಆರೋನನ ಕೋಲು ಚಿಗುರಿ ಮೊಗ್ಗುಬಿಟ್ಟು ಹೂವರಳಿ ಬಾದಾಮಿ ಹಣ್ಣುಗಳನ್ನು ಫಲಿಸಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ಮೋಶೆ ಎಲ್ಲಾ ಕೋಲುಗಳನ್ನು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಿಂದ ಹೊರಗೆ ತೆಗೆದುಕೊಂಡು ಬಂದು ಅವುಗಳನ್ನೆಲ್ಲಾ ಇಸ್ರೇಲರಿಗೆ ತೋರಿಸಿದನು. ಪ್ರಧಾನರು ಆ ಕೋಲುಗಳನ್ನು ನೋಡಿ, ತಮ್ಮತಮ್ಮ ಕೋಲುಗಳನ್ನು ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಆರೋನನ ಕೋಲನ್ನು ಮತ್ತೆ ಒಡಂಬಡಿಕೆಯ ಪೆಟ್ಟಿಗೆಯ ಮುಂದಿಡು. ದಂಗೆಕೋರರಿಗೆ ಅದು ಎಚ್ಚರಿಕೆಯಾಗಿ ಅಲ್ಲೇ ಇರಬೇಕು, ಇವರು ಇನ್ನು ಮುಂದೆ ನನಗೆ ವಿರೋಧವಾಗಿ ಗುಣುಗುಟ್ಟಿ, ಮರಣಕ್ಕೆ ಗುರಿಯಾಗದಂತೆ ನೀನು ಹೀಗೆ ಮಾಡಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ಆದ್ದರಿಂದ ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಪ್ರಕಾರವೇ ಮೋಶೆ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ಇಸ್ರೇಲರು ಮೋಶೆಗೆ, “ನಾವೆಲ್ಲರು ಪ್ರಾಣ ಕಳೆದುಕೊಂಡು ನಾಶವಾಗುತ್ತೇವಲ್ಲಾ, ನಮ್ಮಲ್ಲಿ ಯಾರೂ ಉಳಿಯುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ಯೆಹೋವನ ಗುಡಾರದ ಹತ್ತಿರಕ್ಕೆ ಬಂದವರೆಲ್ಲರೂ ಸಾಯುತ್ತಾರಲ್ಲಾ, ನಾವೆಲ್ಲರೂ ಹಾಗೆಯೇ ಸಾಯುತ್ತೇವೋ?” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ಆಗ ಯೆಹೋವನು ಆರೋನನಿಗೆ, “ಪವಿತ್ರ ವಸ್ತುಗಳ ವಿಷಯದಲ್ಲಿ ಏನಾದರೂ ಹೊಲಸುತನ ನಡೆದರೆ, ನೀನೂ ನಿನ್ನ ಗಂಡುಮಕ್ಕಳೂ ನಿನ್ನ ತಂದೆಯ ಕುಟುಂಬದವರೂ ಅದರ ಅಪರಾಧದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ಯಾಜಕತ್ವದ ವಿಷಯದಲ್ಲಿ ಏನಾದರೂ ಹೊಲಸುತನ ನಡೆದರೆ, ನೀನು ಮತ್ತು ನಿನ್ನ ಗಂಡುಮಕ್ಕಳು ಮಾತ್ರ ಅದರ ಅಪರಾಧದ ಫಲವನ್ನು ಅನುಭವಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ನಿನ್ನ ತಂದೆಯ ಕುಲದವರೂ ನಿನ್ನ ರಕ್ತಸಂಬಂಧಿಗಳೂ ಆಗಿರುವ ಲೇವಿಕುಲದವರನ್ನು ನಿನ್ನೊಡನೆ ಸೇರಿಸಿಕೊ; ನೀನು ಮತ್ತು ನಿನ್ನ ಗಂಡುಮಕ್ಕಳು ಒಡಂಬಡಿಕೆಯ ಮುಂದೆ ಇರುವಾಗ ಅವರು ನಿನ್ನೊಂದಿಗಿದ್ದು ನಿನಗೆ ಸಹಾಯ ಮಾಡುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ಆ ಲೇವಿಯರು ನಿನಗೆ ಕಾವಲುಗಾರರಾಗಿರಬೇಕು ಅಂದರೆ ಇಡೀ ಗುಡಾರವನ್ನು ಕಾಯಬೇಕು. ಆದರೆ ಅವರು ಪವಿತ್ರವಾದ ಪಾತ್ರೆಯನ್ನಾಗಲಿ ಯಜ್ಞವೇದಿಕೆಯನ್ನಾಗಲಿ ಮುಟ್ಟಬಾರದು; ಮುಟ್ಟಿದರೆ ಅವರೂ ಸಾಯುವರು ಮತ್ತು ನೀವೂ ಸಾಯುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ಅವರು ದೇವದರ್ಶನಗುಡಾರವನ್ನು ಕಾಯಬೇಕು ಮತ್ತು ಗುಡಾರಕ್ಕೆ ಸಂಬಂಧಿಸಿದ ಭಾರವಾದ ಕೆಲಸವನ್ನು ಮಾಡಬೇಕು. ಬೇರೆ ಯಾರೂ ನಿನ್ನೊಂದಿಗೆ ಭಾಗಿಗಳಾಗಿರಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“ನಾನು ಮತ್ತೆ ಕೋಪಗೊಂಡು ಇಸ್ರೇಲರನ್ನು ದಂಡಿಸದಂತೆ ನೀವು ಪವಿತ್ರಸ್ಥಳವನ್ನು ಮತ್ತು ಯಜ್ಞವೇದಿಕೆಯನ್ನು ಕಾಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ಎಲ್ಲಾ ಇಸ್ರೇಲರಿಂದ ನಾನೇ ಲೇವಿಯರನ್ನು ಆರಿಸಿಕೊಂಡಿದ್ದೇನೆ. ಅವರು ನಿನಗೆ ಕೊಡಲ್ಪಟ್ಟ ಬಹುಮಾನವಾಗಿದ್ದಾರೆ. ದೇವದರ್ಶನಗುಡಾರಕ್ಕೆ ಸಂಬಂಧಿಸಿದ ಭಾರವಾದ ಕೆಲಸವನ್ನು ಮಾಡಲು ಅವರು ಯೆಹೋವನಿಗೆ ಪ್ರತಿಷ್ಠಿತರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ದರೆ ಆರೋನನೇ, ನೀನೂ ನಿನ್ನ ಪುತ್ರರೂ ನಿಮ್ಮ ಯಾಜಕತ್ವವನ್ನು ಕಾಪಾಡಿಕೊಳ್ಳಬೇಕು. ಅಯೋಗ್ಯನಾದ ಯಾವನೂ ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿ ಕೆಲಸ ಮಾಡುವುದಕ್ಕಾಗಲೀ ತೆರೆಯ ಆಚೆಯಿರುವ ಮಹಾ ಪವಿತ್ರಸ್ಥಳಕ್ಕೆ ಪ್ರವೇಶಿಸುವುದಕ್ಕಾಗಲಿ ನೀವು ಬಿಡಕೂಡದು. ನಾನು ನಿಮಗೆ ಅಮೂಲ್ಯವಾದ ಯಾಜಕತ್ವವನ್ನು ಕೊಟ್ಟಿದ್ದೇನೆ. ಆದರೆ ಅಯೋಗ್ಯನಾದ ಯಾವನಾದರೂ ಯಾಜಕತ್ವದ ಈ ಕರ್ತವ್ಯಗಳನ್ನು ಮಾಡಲು ಪ್ರಯತ್ನಿಸಿದರೆ ಅವನು ಕೊಲ್ಲಲ್ಪಡುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ಆಗ ಯೆಹೋವನು ಆರೋನನಿಗೆ ಹೀಗೆ ಹೇಳಿದನು: “ನನಗೆ ಬರಬೇಕಾಗಿರುವ ಕೊಡುಗೆಗಳನ್ನು ಮತ್ತು ಇಸ್ರೇಲರ ಪವಿತ್ರವಾದ ಎಲ್ಲಾ ಕಾಣಿಕೆಗಳನ್ನು ಕಾಯುವ ಜವಾಬ್ದಾರಿಕೆಯನ್ನು ನಾನೇ ನಿನಗೆ ವಹಿಸಿದ್ದೇನೆ. ಅವುಗಳನ್ನು ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಯವರಿಗೂ ಪಾಲಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ಅವು ಯಾವಾಗಲೂ ನಿಮ್ಮವೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ಯಜ್ಞವೇದಿಕೆಯ ಬೆಂಕಿಯಲ್ಲಿ ಹೋಮಮಾಡದೆ ಉಳಿಸಿರುವ ಮಹಾಪರಿಶುದ್ಧ ಪದಾರ್ಥಗಳಲ್ಲಿ ನಿಮಗೆ ದೊರೆಯಬೇಕಾದವುಗಳು ಯಾವುವೆಂದರೆ: ಅವರು ನನಗೆ ಕೊಡಲಿರುವ ಯಜ್ಞಗಳು, ಧಾನ್ಯಾರ್ಪಣೆಗಳು, ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಗಳು, ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಗಳು ಮತ್ತು ಅಂತಹ ಪ್ರತಿಯೊಂದು ಅರ್ಪಣೆಗಳು ನಿನಗೂ ನಿನ್ನ ಗಂಡುಮಕ್ಕಳಿಗೂ ಮಹಾಪವಿತ್ರವಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ನೀವು ಮಹಾ ಪವಿತ್ರವಾದ ಸ್ಥಳದಲ್ಲಿ ಅದನ್ನು ಊಟಮಾಡಬೇಕು. ನಿಮ್ಮಲ್ಲಿರುವ ಪುರುಷರೆಲ್ಲರೂ ಅವುಗಳನ್ನು ತಿನ್ನಬಹುದು; ಅವು ಮಹಾ ಪವಿತ್ರವಾದವುಗಳೆಂದು ನೀವು ಪರಿಗಣಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ಅದಲ್ಲದೆ, ಅವರ ಪ್ರತಿಷ್ಠಿತಾ ಕಾಣಿಕೆಗಳು ಮತ್ತು ಇಸ್ರೇಲರ ನಿವಾಳಿಸಲ್ಪಟ್ಟ ಕಾಣಿಕೆಗಳು ನಿಮಗೆ ಸೇರಿವೆ. ಅವುಗಳನ್ನು ನಾನು ನಿನಗೂ ನಿನ್ನ ಗಂಡುಮಕ್ಕಳಿಗೂ ಹೆಣ್ಣುಮಕ್ಕಳಿಗೂ ಶಾಶ್ವತವಾದ ಪಾಲಾಗಿ ಕೊಡುವೆನು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“ಇದಲ್ಲದೆ, ಇಸ್ರೇಲರು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವ ಪ್ರಥಮಫಲದ ಪದಾರ್ಥಗಳಲ್ಲಿ ಅಂದರೆ ಉತ್ತಮವಾದ ಎಣ್ಣೆ, ಹೊಸ ದ್ರಾಕ್ಷಾರಸ, ಧಾನ್ಯ ಇವುಗಳನ್ನೆಲ್ಲ ನಾನು ನಿಮಗೆ ಕೊಡುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ಅವರು ತಮ್ಮ ದೇಶದ ಎಲ್ಲಾ ಬೆಳೆಗಳಲ್ಲಿ ಯೆಹೋವನಿಗೋಸ್ಕರ ತರುವ ಪ್ರಥಮಫಲವು ನಿಮಗೆ ಸಲ್ಲಬೇಕು. ನಿಮ್ಮ ಕುಟುಂಬಗಳಲ್ಲಿ ಶುದ್ಧರಾಗಿರುವವರೆಲ್ಲರೂ ಅವುಗಳನ್ನು ಊಟಮಾಡಬಹುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ಇಸ್ರೇಲರು ಯೆಹೋವನಿಗೆ ಹರಕೆ ಹೊತ್ತುಕೊಂಡು ಕೊಡುವ ಪ್ರತಿಯೊಂದೂ ನಿಮ್ಮದಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“ಮನುಷ್ಯರಲ್ಲಾಗಲಿ ಪ್ರಾಣಿಗಳಲ್ಲಾಗಲಿ ಅವರು ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವ ಚೊಚ್ಚಲಾದದ್ದು ನಿನಗೆ ಸಲ್ಲಬೇಕು. ಆದರೆ ಮನುಷ್ಯರ ಚೊಚ್ಚಲು ಮಕ್ಕಳಿಗೂ ಅಪವಿತ್ರವಾದ ಪಶುಗಳ ಮರಿಗಳಿಗೂ ಬದಲಾಗಿ ನೀನು ಈಡನ್ನು ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ಒಂದು ತಿಂಗಳಿನ ಪ್ರಾಯಕ್ಕೆ ಬಂದಿರುವ ಎಲ್ಲರಿಂದಲೂ ನಿಗದಿಪಡಿಸಿದ ಐದು ಶೆಕೆಲ್‌ಗಳನ್ನು ಈಡಾಗಿ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“ಆದರೆ ಚೊಚ್ಚಲು ಆಕಳಿಗಾಗಲಿ ಕುರಿಗಾಗಲಿ ಆಡಿಗಾಗಲಿ ಈಡನ್ನು ಕೊಡಕೂಡದು. ಆ ಪಶುಗಳು ಪವಿತ್ರವಾಗಿವೆ. ಅವುಗಳ ರಕ್ತವನ್ನು ವೇದಿಕೆಯ ಮೇಲೆ ಚೆಲ್ಲಿ ಅವುಗಳ ಕೊಬ್ಬನ್ನು ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚಿಗೆಕರವಾದ ಸುಗಂಧ ವಾಸನೆಯ ತ್ಯಾಗಮಯವಾದ ಕಾಣಿಕೆಯನ್ನಾಗಿ ಹೋಮಮಾಡಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ಆದರೆ ಅವುಗಳ ಮಾಂಸದಲ್ಲಿ ನಿವಾಳಿಸಲ್ಪಡುವ ಕಾಣಿಕೆಯಂತೆ ಎದೆಯ ಭಾಗ ಮತ್ತು ಬಲತೊಡೆ ನಿಮ್ಮದಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ಇಸ್ರೇಲರು ಯೆಹೋವನಿಗೋಸ್ಕರ ಪ್ರತ್ಯೇಕಿಸಿ ಸಮರ್ಪಿಸುವ ಪವಿತ್ರ ವಸ್ತುಗಳೆಲ್ಲವನ್ನು ನಿನಗೂ ನಿನ್ನ ಸಂತತಿಯವರಾದ ಸ್ತ್ರೀಪುರುಷರೆಲ್ಲರಿಗೂ ಶಾಶ್ವತವಾದ ಪಾಲಾಗಿ ಅನುಗ್ರಹಿಸಿದ್ದೇನೆ. ಇದು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ನಿನ್ನೊಡನೆಯೂ ನಿನ್ನ ನಂತರದ ಸಂತತಿಯವರೊಡನೆಯೂ ಮಾಡಿಕೊಂಡ ಶಾಶ್ವತವಾದ ಉಪ್ಪಿನ ಒಡಂಬಡಿಕೆ.” ");
INSERT INTO kan2010_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ಇದಲ್ಲದೆ ಯೆಹೋವನು ಆರೋನನಿಗೆ, “ಅವರ ಭೂಮಿಯಲ್ಲಿ ನಿನಗೆ ಯಾವ ಪಾಲೂ ದೊರೆಯುವುದಿಲ್ಲ. ಅವರ ಮಧ್ಯದಲ್ಲಿ ನೀನು ಭೂಮಿಯ ಯಾವ ಭಾಗವನ್ನೂ ಹೊಂದಿರುವುದಿಲ್ಲ. ಇಸ್ರೇಲರ ಮಧ್ಯದಲ್ಲಿ ಯೆಹೋವನಾದ ನಾನೇ ನಿನ್ನ ಪಾಲೂ ಭಾಗವೂ ಆಗಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“ಲೇವಿಯರು ದೇವದರ್ಶನಗುಡಾರಕ್ಕೋಸ್ಕರ ಮಾಡುವ ಭಾರವಾದ ಕೆಲಸಕ್ಕೆ ಪ್ರತಿಫಲವಾಗಿ ಪ್ರತಿಯೊಬ್ಬ ಇಸ್ರೇಲನ ದಶಾಂಶವನ್ನು ನಾನು ಲೇವಿಯರಿಗೆ ಅವರ ಪಾಲಾಗಿ ಕೊಡುತ್ತಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ಈಗಿನಿಂದ ಇಸ್ರೇಲರು ದೇವದರ್ಶನಗುಡಾರದೊಳಗೆ ಅತಿಕ್ರಮಿಸಿ ಬರಕೂಡದು; ಬಂದರೆ ತಮ್ಮ ಮೇಲೆ ದಂಡನೆಯನ್ನು ಬರಮಾಡಿಕೊಂಡು ಸಾಯುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ದೇವದರ್ಶನಗುಡಾರಕ್ಕೋಸ್ಕರ ಲೇವಿಯರು ಮಾತ್ರ ಕೆಲಸ ಮಾಡಬೇಕು. ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಏನಾದರೂ ಅತಿಕ್ರಮಣ ನಡೆದರೆ ಇಸ್ರೇಲರ ದಂಡನೆಯನ್ನು ಅವರೇ ಪಡೆಯುವರು. ಈಗಿನಿಂದ ಇದೇ ಶಾಶ್ವತ ಕಟ್ಟಳೆ. ಇತರ ಇಸ್ರೇಲರಿಗೆ ನಾನು ವಾಗ್ದಾನ ಮಾಡಿದ ಭೂಮಿಯಲ್ಲಿ ಲೇವಿಯರಿಗೆ ಯಾವ ಪಾಲೂ ದೊರೆಯುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ಇಸ್ರೇಲರು ಪ್ರತ್ಯೇಕಿಸಿ ಯೆಹೋವನಿಗೆ ಸಮರ್ಪಿಸುವ ಹತ್ತನೆಯ ಪಾಲನ್ನು ಲೇವಿಯರಿಗೆ ಸ್ವಾಸ್ತ್ಯವಾಗಿ ಕೊಟ್ಟಿದ್ದೇನೆ. ಇವರಿಗೆ ಇಸ್ರೇಲರೊಂದಿಗೆ ಪಾಲು ದೊರೆಯುವುದಿಲ್ಲವೆಂದು ನಾನು ಲೇವಿಯರ ಕುರಿತು ಹೇಳಿದ ಮಾತಿಗೆ ಇದೇ ಕಾರಣ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ನೀನು ಲೇವಿಯರಿಗೆ ಇದನ್ನು ತಿಳಿಸಬೇಕು: ಇಸ್ರೇಲರು ತಮ್ಮ ಆದಾಯದಲ್ಲಿ ಕೊಡುವ ದಶಾಂಶವನ್ನು ನಿಮ್ಮ ಪಾಲೆಂದು ನಾನು ನಿಗದಿಪಡಿಸಿದ್ದೇನೆ. ಇಸ್ರೇಲರು ದಶಾಂಶ ಕೊಟ್ಟಾಗ ನೀವು ಆ ದಶಾಂಶದಲ್ಲಿ ಹತ್ತನೆಯ ಒಂದು ಭಾಗವನ್ನು ಯೆಹೋವನಿಗೆ ಸಲ್ಲಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ನೀವು ಹೀಗೆ ಸಮರ್ಪಿಸಿದ ಹತ್ತನೆಯ ಪಾಲು ಕಣದಲ್ಲಿನ ದವಸವನ್ನು, ದ್ರಾಕ್ಷಿಆಲೆಯಿಂದ ರಸವನ್ನು ಕೊಟ್ಟಂತೆ ನಿಮ್ಮ ಲೆಕ್ಕದಲ್ಲಿ ಎಣಿಸಲ್ಪಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ಇಸ್ರೇಲರಿಂದ ನಿಮಗೆ ಸಲ್ಲುವ ಹತ್ತನೆಯ ಪಾಲಿನಲ್ಲಿ ನೀವು ಯೆಹೋವನಿಗೋಸ್ಕರ ಹತ್ತನೆಯ ಭಾಗವನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ ಯಾಜಕನಾದ ಆರೋನನಿಗೆ ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ಇಸ್ರೇಲರು ನಿಮಗೆ ಕೊಡುವ ಸಕಲ ಪದಾರ್ಥಗಳಿಂದ ನೀವು ಯೆಹೋವನಿಗೆ ಕೊಡಬೇಕಾಗಿರುವ ಪಾಲನ್ನು ಮತ್ತು ಪ್ರತಿಷ್ಠಿಸಲ್ಪಟ್ಟಿರುವ ಉತ್ತಮ ಭಾಗವನ್ನು ನೀವು ಪ್ರತ್ಯೇಕವಾಗಿಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“ಮೋಶೆಯೇ, ಲೇವಿಯರಿಗೆ ಹೀಗೆ ಹೇಳು: ಆ ಕಾಣಿಕೆಗಳಲ್ಲಿ ಉತ್ತಮವಾದ ಭಾಗವನ್ನು ನೀವು ಯೆಹೋವನಿಗೆ ಕೊಡುವಾಗ, ಲೇವಿಯರಾದ ನಿಮಗೆ ಅದು ಕಣದ ಉತ್ಪಾದನೆಯಂತೆಯೂ ದ್ರಾಕ್ಷಿಆಲೆಯ ಉತ್ಪಾದನೆಯಂತೆಯೂ ಪರಿಗಣಿಸಲ್ಪಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ಉಳಿದದ್ದನ್ನು ನೀವು ಮತ್ತು ನಿಮ್ಮ ಕುಟುಂಬದವರು ಎಲ್ಲಿ ಬೇಕಾದರೂ ತಿನ್ನಬಹುದು. ನೀವು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಮಾಡುವ ಕೆಲಸಕ್ಕೆ ಇದು ನಿಮಗೆ ಪ್ರತಿಫಲವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ನೀವು ಯಾವಾಗಲೂ ಉತ್ತಮ ಭಾಗವನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಟ್ಟರೆ, ಸಂಕಟದ ದಂಡನೆಯಿಂದ ತಪ್ಪಿಸಿಕೊಳ್ಳುವಿರಿ. ಇಸ್ರೇಲರು ಕೊಟ್ಟ ಪವಿತ್ರವಾದ ಕಾಣಿಕೆಗಳಿಗೆ ನೀವು ಅಪಮಾನ ಮಾಡುವುದಿಲ್ಲ ಮತ್ತು ನೀವು ಸಾಯುವುದಿಲ್ಲ.” ");
INSERT INTO kan2010_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ಯೆಹೋವನು ಮೋಶೆ ಮತ್ತು ಆರೋನರೊಡನೆ ಮಾತಾಡಿ ಹೀಗೆಂದನು: ");
INSERT INTO kan2010_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ ಸಂಪ್ರದಾಯದ ನಿಯಮವಿದು. ಯಾವ ದೋಷವಿಲ್ಲದ ಕೆಂಪು ಹಸುವನ್ನು ನಿನಗೆ ತಂದುಕೊಡುವಂತೆ ಇಸ್ರೇಲರಿಗೆ ಹೇಳು. ಆ ಹಸುವಿನಲ್ಲಿ ಯಾವ ಗಾಯಗಳಿರಬಾರದು ಮತ್ತು ಆ ಹಸುವು ಎಂದಿಗೂ ನೊಗವನ್ನು ಹೊತ್ತಿರಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ಅದನ್ನು ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನಿಗೆ ಒಪ್ಪಿಸಿರಿ. ಅವನು ಅದನ್ನು ಪಾಳೆಯದ ಹೊರಗೆ ಹೊಡಿಸಿಕೊಂಡು ಹೋಗಿ ತನಗೆದುರಾಗಿಯೇ ಒಬ್ಬನ ಕೈಯಿಂದ ವಧೆ ಮಾಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ಬಳಿಕ ಅವನು ಅದರ ರಕ್ತದಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಬೆರಳಿನಿಂದ ದೇವದರ್ಶನಗುಡಾರದ ಮುಂಭಾಗದ ಕಡೆಗೆ ಏಳು ಸಾರಿ ಚಿಮಿಕಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ಬಳಿಕ ಅವನು ಆ ಹಸುವನ್ನು ಚರ್ಮ, ಮಾಂಸ, ರಕ್ತ ಮತ್ತು ಕಲ್ಮಶಗಳ ಸಹಿತವಾಗಿ ತನ್ನ ಎದುರಿನಲ್ಲಿಯೇ ಸುಡಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ಯಾಜಕನು ದೇವದಾರು ಮರದ ಕಟ್ಟಿಗೆಯನ್ನೂ ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಎಳೆಕೊಂಬೆಯನ್ನೂ ಕೆಂಪು ದಾರವನ್ನೂ ತೆಗೆದುಕೊಂಡು, ಉರಿಯುತ್ತಿರುವ ಆ ಹಸುವಿನ ಮೇಲೆ ಎಸೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ಆ ಯಾಜಕನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಸ್ನಾನ ಮಾಡಿದ ನಂತರ ಪಾಳೆಯದೊಳಗೆ ಬರಬಹುದು. ಆದರೆ ಆ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ಆ ಹಸುವನ್ನು ಸುಟ್ಟು ಹಾಕಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಂಡು ಸ್ನಾನ ಮಾಡಿಕೊಳ್ಳಬೇಕು; ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ಆಗ ಶುದ್ಧನಾದವನೊಬ್ಬನು ಹಸುವಿನ ಬೂದಿಯನ್ನು ಕೂಡಿಸಿ ಪಾಳೆಯದ ಹೊರಗೆ ಶುದ್ಧವಾದ ಸ್ಥಳದಲ್ಲಿ ಇಡಬೇಕು. ಇಸ್ರೇಲರ ಶುದ್ಧೀಕರಣದ ನೀರನ್ನು ಸಿದ್ಧಪಡಿಸುವುದಕ್ಕಾಗಿ ಆ ಬೂದಿಯನ್ನು ಉಪಯೋಗಿಸಬೇಕು. ಅದು ದೋಷಪರಿಹಾರಕವಾದದ್ದು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","“ಆ ಬೂದಿಯನ್ನು ಕೂಡಿಸಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ಅವನು ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. “ಇದು ಇಸ್ರೇಲರಿಗೂ ಅವರ ಮಧ್ಯದಲ್ಲಿ ಇಳಿದುಕೊಂಡಿರುವ ಪರದೇಶಸ್ಥರಿಗೂ ಶಾಶ್ವತ ನಿಯಮ. ");
INSERT INTO kan2010_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","ಯಾವನಾದರೂ ಮನುಷ್ಯ ಶವವನ್ನು ಮುಟ್ಟಿದರೆ, ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ಅವನು ಶುದ್ಧೀಕರಣದ ನೀರಿನಿಂದ ಮೂರನೆಯ ದಿನದಲ್ಲಿ ಮತ್ತು ತಿರುಗಿ ಏಳನೆಯ ದಿನದಲ್ಲಿ ತನ್ನನ್ನು ಶುದ್ಧೀಕರಿಸಿಕೊಳ್ಳಬೇಕು. ಆಗ ಅವನು ಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ಒಬ್ಬನು ಮನುಷ್ಯ ಶವವನ್ನು ಮುಟ್ಟಿ ತನ್ನನ್ನು ಶುದ್ಧೀಕರಿಸಿಕೊಳ್ಳದೆ ಹೋದರೆ ಅವನು ಯೆಹೋವನ ಪವಿತ್ರ ಗುಡಾರವನ್ನು ಅಶುದ್ಧಮಾಡುತ್ತಾನೆ. ಆದ್ದರಿಂದ ಆ ವ್ಯಕ್ತಿಯನ್ನು ಇಸ್ರೇಲರಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ಶುದ್ಧೀಕರಣದ ವಿಶೇಷ ನೀರು ಅವನ ಮೇಲೆ ಚಿಮಿಕಿಸಲ್ಪಡದ ಕಾರಣ ಅವನು ಅಶುದ್ಧನಾಗಿಯೇ ಇರುವನು. ಅವನ ಅಶುದ್ಧತ್ವ ಅವನಲ್ಲಿ ನೆಲೆಸುವುದು. ಅವನು ಅಶುದ್ಧನಾಗಿಯೇ ಇರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ಯಾವನಾದರೂ ಗುಡಾರದಲ್ಲಿ ಸತ್ತರೆ ಅನುಸರಿಸಬೇಕಾದ ನಿಯಮವಿದು: ಒಬ್ಬನು ಗುಡಾರದಲ್ಲಿ ಸತ್ತರೆ, ಆ ಗುಡಾರವನ್ನು ಪ್ರವೇಶಿಸುವ ಪ್ರತಿಯೊಬ್ಬನು ಮತ್ತು ಆ ಗುಡಾರದಲ್ಲಿರುವ ಪ್ರತಿಯೊಬ್ಬನು ಅಶುದ್ಧನಾಗುವನು. ಅವರು ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧರಾಗಿರುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ಮತ್ತು ಮುಚ್ಚಳವಿಲ್ಲದಿರುವ ಪ್ರತಿಯೊಂದು ಪಾತ್ರೆಯೂ ಅಶುದ್ಧವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ಹೊರಗೆ ಹೋಗಿರುವವನು ಯುದ್ಧದಲ್ಲಿ ಸತ್ತವನ ಶವವನ್ನಾಗಲಿ ಸಹಜವಾಗಿ ಸತ್ತವನ ಶವವನ್ನಾಗಲಿ ಮನುಷ್ಯನ ಮೂಳೆಯನ್ನಾಗಲಿ ಅಥವಾ ಸಮಾಧಿಯನ್ನಾಗಲಿ ಮುಟ್ಟಿದರೆ ಅವನು ಏಳು ದಿನಗಳವರೆಗೆ ಅಶುದ್ಧನಾಗಿರವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ಆದ್ದರಿಂದ ಅಶುದ್ಧ ವ್ಯಕ್ತಿಯನ್ನು ಶುದ್ಧೀಕರಿಸುವುದಕ್ಕಾಗಿ ಶುದ್ಧೀಕರಣ ಯಜ್ಞದ ಬೂದಿಯಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಪಾತ್ರೆಯಲ್ಲಿ ತೆಗೆದುಕೊಂಡು ಹರಿಯುವ ನೀರನ್ನು ಅದರ ಮೇಲೆ ಸುರಿಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ಆಗ ಶುದ್ಧನಾಗಿರುವ ಒಬ್ಬನು ಹಿಸ್ಸೋಪ್ ಗಿಡದ ಎಳೆಕೊಂಬೆಯನ್ನು ಆ ನೀರಿನಲ್ಲಿ ಅದ್ದಿ ಗುಡಾರದ ಮೇಲೆಯೂ ಪಾತ್ರೆಗಳ ಮೇಲೆಯೂ ಮತ್ತು ಅದರೊಳಗಿದ್ದ ವ್ಯಕ್ತಿಗಳ ಮೇಲೆಯೂ ಚಿಮಿಕಿಸಬೇಕು. ಸತ್ತವನ ದೇಹವನ್ನು ಮುಟ್ಟಿದವನಿಗೂ ಯುದ್ಧದಲ್ಲಿ ಕೊಲ್ಲಲ್ಪಟ್ಟವನ ದೇಹವನ್ನು ಮುಟ್ಟಿದವನಿಗೂ ಸತ್ತವನ ಮೂಳೆಗಳನ್ನು ಮುಟ್ಟಿದವನಿಗೂ ನೀವು ಹೀಗೆ ಮಾಡಲೇಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","“ಶುದ್ಧನಾಗಿರುವವನು ಮೂರನೆಯ ದಿನದಲ್ಲಿಯೂ ಏಳನೆಯ ದಿನದಲ್ಲಿಯೂ ಅಶುದ್ಧನಾದವನ ಮೇಲೆ ಚಿಮಿಕಿಸಬೇಕು. ಹೀಗೆ ಅವನು ಏಳನೆಯ ದಿನದಲ್ಲಿ ಶುದ್ಧನಾಗುವನು. ಬಳಿಕ ಅಶುದ್ಧನಾದವನು ತನ್ನ ಬಟ್ಟೆಯನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“ಅಶುದ್ಧನಾಗಿದ್ದರೂ ತನ್ನನ್ನು ಶುದ್ಧಮಾಡಿಕೊಳ್ಳದವನು ಯೆಹೋವನ ಗುಡಾರವನ್ನು ಅಶುದ್ಧಮಾಡಿದವನಾಗಿರುತ್ತಾನೆ. ಆದ್ದರಿಂದ ಅವನನ್ನು ಇಸ್ರೇಲರಿಂದ ಬಹಿಷ್ಕರಿಸಬೇಕು. ಶುದ್ಧಪಡಿಸಿಕೊಳ್ಳುವ ನೀರನ್ನು ಚಿಮಿಕಿಸಿಕೊಳ್ಳದೆ ಹೋದದರಿಂದ ಅವನು ಅಶುದ್ಧನೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ಇದು ನಿಮಗೆ ಶಾಶ್ವತನಿಯಮ. ಶುದ್ಧಪಡಿಸುವ ಆ ನೀರನ್ನು ಚಿಮಿಕಿಸಿದವನು ತನ್ನ ಬಟ್ಟೆಗಳನ್ನು ತೊಳೆದುಕೊಳ್ಳಬೇಕು; ಮತ್ತು ಆ ನೀರನ್ನು ಯಾವನಾದರೂ ಮುಟ್ಟಿದರೆ, ಅವನು ಆ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ಅಶುದ್ಧನಾದವನು ಮುಟ್ಟುವುದೆಲ್ಲಾ ಅಶುದ್ಧವಾಗುತ್ತದೆ. ಅಲ್ಲದೆ ಅವನನ್ನು ಮಟ್ಟುವವನು ಆ ದಿನದ ಸಾಯಂಕಾಲದವರೆಗೆ ಅಶುದ್ಧನಾಗಿರುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ಮೊದಲನೆಯ ತಿಂಗಳಲ್ಲಿ ಇಡೀ ಇಸ್ರೇಲ್ ಸಮುದಾಯವು ಚಿನ್ ಮರುಭೂಮಿಗೆ ಬಂದಿತು. ಅವರು ಕಾದೇಶಿನಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ಅಲ್ಲಿ ಮಿರ್ಯಾಮಳು ಸತ್ತಳು. ಆಕೆಯ ಶವವನ್ನು ಅಲ್ಲಿ ಸಮಾಧಿ ಮಾಡಲಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ಅಲ್ಲಿ ನೀರಿಲ್ಲದಿದ್ದ ಕಾರಣ ಅವರು ಮೋಶೆ ಆರೋನರ ವಿರುದ್ಧವಾಗಿ ಸೇರಿಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ಜನರು ಮೋಶೆಯ ಸಂಗಡ ವಾದಮಾಡಿ, “ನಮ್ಮ ಸಹೋದರರು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಸತ್ತಾಗ ನಾವೂ ಸತ್ತುಹೋಗಿದ್ದರೆ ಎಷ್ಟೋ ಮೇಲಾಗಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ಯೆಹೋವನ ಜನರನ್ನು ಈ ಮರುಭೂಮಿಗೆ ಯಾಕೆ ಕರೆದುಕೊಂಡು ಬಂದೆ? ನಾವು ಮತ್ತು ನಮ್ಮ ಪ್ರಾಣಿಗಳು ಇಲ್ಲಿ ಸಾಯಬೇಕೆಂದು ನೀನು ಇಚ್ಛಿಸುತ್ತೀಯೋ? ");
INSERT INTO kan2010_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ಈಜಿಪ್ಟಿನಿಂದ ನಮ್ಮನ್ನು ಇಲ್ಲಿಗೆ ಯಾಕೆ ಕರೆತಂದೆ? ಈ ಕೆಟ್ಟ ಸ್ಥಳಕ್ಕೆ ನಮ್ಮನ್ನು ಯಾಕೆ ಕರೆದುಕೊಂಡು ಬಂದೆ? ಇಲ್ಲಿ ಧಾನ್ಯವಾಗಲಿ ಅಂಜೂರವಾಗಲಿ ದ್ರಾಕ್ಷಿಯಾಗಲಿ ದಾಳಿಂಬೆಯಾಗಲಿ ಇಲ್ಲ, ಕುಡಿಯುವುದಕ್ಕೆ ನೀರೂ ಇಲ್ಲ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ಮೋಶೆ ಆರೋನರು ಜನಸಮೂಹದ ಎದುರಿನಿಂದ ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರಕ್ಕೆ ಹೋಗಿ ಅಡ್ಡಬಿದ್ದರು. ಆಗ ಯೆಹೋವನ ಮಹಿಮೆಯು ಅವರಿಗೆ ಪ್ರತ್ಯಕ್ಷವಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿ, ");
INSERT INTO kan2010_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ಬಳಿಕ ನೀನು ಮತ್ತು ನಿನ್ನ ಸಹೋದರನಾದ ಆರೋನನು ಜನರನ್ನು ಬಂಡೆಯ ಮುಂದೆ ಸಭೆಸೇರಿಸಿ, ಜನರ ಮುಂದೆ ಆ ಬಂಡೆಗೆ ಮಾತಾಡು. ಆಗ ನೀರು ಬಂಡೆಯಿಂದ ಹರಿಯುವುದು ಮತ್ತು ನೀರನ್ನು ಜನರಿಗೂ ಅವರ ಪಶುಗಳಿಗೂ ಕೊಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ಕೋಲು ಪವಿತ್ರಗುಡಾರದಲ್ಲಿ ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿತ್ತು. ಯೆಹೋವನು ಹೇಳಿದಂತೆ ಮೋಶೆ ಕೋಲನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ಜನರು ಬಂಡೆಯ ಮುಂದೆ ಒಟ್ಟಾಗಿ ಸೇರಿಬರಬೇಕೆಂದು ಮೋಶೆ ಆರೋನರು ಹೇಳಿದರು. ಆಗ ಮೋಶೆ, “ದ್ರೋಹಿಗಳೇ, ಈಗ ನನಗೆ ಕಿವಿಗೊಡಿರಿ. ನಿಮಗೋಸ್ಕರವಾಗಿ ಈ ಬಂಡೆಯಿಂದ ನೀರು ಹರಿಯುವಂತೆ ನಾವು ಮಾಡಬೇಕೋ?” ಎಂದು ಹೇಳಿ, ");
INSERT INTO kan2010_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ತನ್ನ ಕೈಯಲ್ಲಿದ್ದ ಕೋಲನ್ನು ಎತ್ತಿ ಎರಡು ಸಾರಿ ಬಂಡೆಯನ್ನು ಹೊಡೆದನು. ಬಂಡೆಯಿಂದ ನೀರು ಹರಿಯತೊಡಗಿತು. ಜನರಿಗೆ ಮತ್ತು ಪಶುಗಳಿಗೆ ಕುಡಿಯಲು ನೀರು ದೊರೆಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ಆದರೆ ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ, “ನೀವು ನನ್ನನ್ನು ನಂಬದವರಾಗಿ ಇಸ್ರೇಲರ ಎದುರಿನಲ್ಲಿ ನನ್ನ ಪವಿತ್ರತೆಯನ್ನು ತೋರಿಸದೆ ಹೋದದ್ದರಿಂದ ಈ ಸಮುದಾಯದವರಿಗೆ ಕೊಡಲಿರುವ ದೇಶಕ್ಕೆ ನೀವು ಅವರನ್ನು ಕರೆದುಕೊಂಡು ಹೋಗುವುದಿಲ್ಲ.” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ಇಸ್ರೇಲರು ಅಲ್ಲಿ ಯೆಹೋವನೊಡನೆ ವಾದ ಮಾಡಿದ್ದರಿಂದ ಆ ಸ್ಥಳವು “ಮೆರೀಬಾ ಬುಗ್ಗೆ” ಎಂದು ಕರೆಯಲ್ಪಟ್ಟಿತು. ಅದಲ್ಲದೆ ಯೆಹೋವನು ತಾನು ಪರಿಶುದ್ಧನು ಎಂಬುದನ್ನು ಅವರಿಗೆ ತೋರಿಸಿದ ಸ್ಥಳವು ಇದೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ಮೋಶೆಯು ಕಾದೇಶಿನಲ್ಲಿದ್ದಾಗ ಎದೋಮಿನ ಅರಸನ ಬಳಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ, “ನಿಮ್ಮ ಸಂಬಂಧಿಕರವಾದ ಇಸ್ರೇಲರು ಕೇಳಿಕೊಳ್ಳುವುದೇನೆಂದರೆ: ನಮಗೆ ಸಂಭವಿಸಿದ ಎಲ್ಲಾ ಕಷ್ಟಗಳು ನಿಮಗೆ ಗೊತ್ತಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ನಮ್ಮ ಪೂರ್ವಿಕರು ಈಜಿಪ್ಟ್ ದೇಶಕ್ಕೆ ಇಳಿದುಹೋದದ್ದೂ ನಾವು ಅಲ್ಲಿ ಬಹುಕಾಲ ವಾಸವಾಗಿದ್ದದ್ದೂ ಈಜಿಪ್ಟಿನವರು ನಮಗೂ ನಮ್ಮ ಪೂರ್ವಿಕರಿಗೂ ಕ್ರೂರರಾಗಿದ್ದದ್ದೂ ನಿಮಗೆ ತಿಳಿದದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ನಾವು ಯೆಹೋವನಿಗೆ ಮೊರೆಯಿಡಲಾಗಿ ಆತನು ನಮ್ಮ ಪ್ರಾರ್ಥನೆಯನ್ನು ಕೇಳಿ ದೂತನನ್ನು ಕಳುಹಿಸಿ ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಬಿಡಿಸಿದ್ದನ್ನು ನೀವು ಬಲ್ಲಿರಿ. “ಈಗ ನಾವು ನಿಮ್ಮ ಪ್ರದೇಶದ ಗಡಿಯಲ್ಲಿರುವ ಕಾದೇಶೆಂಬ ಊರಲ್ಲಿದ್ದೇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ನಿಮ್ಮ ದೇಶವನ್ನು ದಾಟಿಹೋಗುವುದಕ್ಕೆ ನಮಗೆ ಅಪ್ಪಣೆಯಾಗಬೇಕೆಂದು ಬೇಡಿಕೊಳ್ಳುತ್ತೇವೆ. ನಾವು ಹೊಲಗಳಲ್ಲಿಯಾಗಲಿ ದ್ರಾಕ್ಷಿತೋಟಗಳಲ್ಲಿಯಾಗಲಿ ಹಾದುಹೋಗುವುದಿಲ್ಲ. ಬಾವಿಗಳ ನೀರನ್ನು ಕುಡಿಯುವುದಿಲ್ಲ. ರಾಜಮಾರ್ಗದಲ್ಲಿಯೇ ನಡೆದು ತಮ್ಮ ದೇಶದ ಮೇರೆಗಳನ್ನು ದಾಟುವ ತನಕ ಎಡಕ್ಕಾಗಲಿ ಬಲಕ್ಕಾಗಲಿ ತಿರುಗುವುದಿಲ್ಲ” ಎಂದು ಹೇಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ಆದರೆ ಎದೋಮಿನ ಅರಸನು, “ನಮ್ಮ ದೇಶವನ್ನು ನೀವು ದಾಟಿಹೋಗಕೂಡದು. ದಾಟುವುದಾದರೆ, ನಾವು ನಿಮ್ಮ ಮೇಲೆ ಯುದ್ಧಕ್ಕೆ ಬರುತ್ತೇವೆ” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ಅದಕ್ಕೆ ಇಸ್ರೇಲರು, “ನಾವು ರಾಜಮಾರ್ಗದಲ್ಲಿಯೇ ಹೋಗುವೆವು. ನಾವೂ ನಮ್ಮ ಪಶುಗಳೂ ನಿಮ್ಮ ನೀರನ್ನು ಕುಡಿದರೆ ಅದಕ್ಕೆ ಬೆಲೆ ಕೊಡುವೆವು. ನಮಗೆ ಕೇವಲ ನಡೆದುಕೊಂಡು ಹೋಗಲು ಅನುಮತಿ ಕೊಡಿ. ಇದೊಂದೇ ನಮ್ಮ ಚಿಕ್ಕ ಬೇಡಿಕೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ಆದರೆ ಮತ್ತೆ ಎದೋಮ್ಯರು, “ನೀವು ನಮ್ಮ ದೇಶವನ್ನು ದಾಟಿಹೋಗುವುದಕ್ಕೆ ನಾವು ಬಿಡುವುದಿಲ್ಲ” ಎಂದು ಉತ್ತರಿಸಿದರು. ಬಳಿಕ ಎದೋಮ್ಯರ ಅರಸನು ಬಲಿಷ್ಠವಾದ ದೊಡ್ಡ ಸೈನ್ಯವನ್ನು ಕೂಡಿಸಿಕೊಂಡು ಇಸ್ರೇಲರ ವಿರುದ್ಧ ಯುದ್ಧಮಾಡಲು ಹೊರಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ಇಸ್ರೇಲರು ಅವನ ದೇಶವನ್ನು ಹಾದು ಹೋಗಲು ಎದೋಮ್ಯರ ಅರಸನು ಬಿಡಲಿಲ್ಲ. ಆಗ ಇಸ್ರೇಲರು ಬೇರೊಂದು ದಿಕ್ಕಿನಲ್ಲಿ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ಇಸ್ರೇಲರೆಲ್ಲರೂ ಕಾದೇಶಿನಿಂದ ಹೊರಟು ಹೋರ್ ಬೆಟ್ಟಕ್ಕೆ ಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ಹೋರ್ ಬೆಟ್ಟವು ಎದೋಮ್ಯರ ಗಡಿಯ ಬಳಿಯಲ್ಲಿ ಇತ್ತು. ಯೆಹೋವನು ಮೋಶೆ ಆರೋನರಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“ಆರೋನನು ಸತ್ತು ಪೂರ್ವಿಕರ ಬಳಿ ಸೇರುವ ಸಮಯ ಬಂದಿದೆ. ಇಸ್ರೇಲರಿಗೆ ನಾನು ವಾಗ್ದಾನ ಮಾಡಿದ ದೇಶದೊಳಗೆ ಆರೋನನು ಪ್ರವೇಶಿಸುವುದಿಲ್ಲ. ಯಾಕೆಂದರೆ ನೀವಿಬ್ಬರೂ ಮೆರೀಬಾ ಬುಗ್ಗೆಯ ಕುರಿತಾಗಿ ನಾನು ಕೊಟ್ಟ ಆಜ್ಞೆಗೆ ವಿಧೇಯರಾಗದಿದ್ದುದರಿಂದ ನಾನು ನಿಮಗೆ ಇದನ್ನು ಹೇಳುತ್ತಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","“ಈಗ ನೀನು ಆರೋನನನ್ನೂ ಅವನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನನ್ನೂ ಕರೆದುಕೊಂಡು ಹೋರ್ ಬೆಟ್ಟಕ್ಕೆ ಬಾ. ");
INSERT INTO kan2010_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ಆರೋನನ ಪ್ರತಿಷ್ಠಿತ ವಸ್ತ್ರಗಳನ್ನು ಅವನಿಂದ ತೆಗೆದು ಅವನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನ ಮೇಲೆ ಹಾಕು. ಆರೋನನು ಅಲ್ಲಿ ಬೆಟ್ಟದ ಮೇಲೆ ಸತ್ತು ಪೂರ್ವಿಕರ ಬಳಿ ಸೇರುವನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ಮೋಶೆಯು ಯೆಹೋವನ ಅಪ್ಪಣೆಗೆ ವಿಧೇಯನಾದನು. ಮೋಶೆ, ಆರೋನ ಮತ್ತು ಎಲ್ಲಾಜಾರ ಇವರು ಹೋರ್ ಬೆಟ್ಟವನ್ನು ಹತ್ತಿದರು. ಅವರು ಹೋಗುತ್ತಿರುವುದನ್ನು ಇಸ್ರೇಲರೆಲ್ಲರೂ ನೋಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ಮೋಶೆಯು ಆರೋನನ ಪ್ರತಿಷ್ಠಿತಾ ವಸ್ತ್ರಗಳನ್ನು ಅವನಿಂದ ತೆಗೆದು ಅವನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನ ಮೇಲೆ ಹಾಕಿದನು. ಬಳಿಕ ಆರೋನನು ಬೆಟ್ಟದ ಮೇಲೆ ಸತ್ತನು. ಮೋಶೆ ಮತ್ತು ಎಲ್ಲಾಜಾರನು ಬೆಟ್ಟದಿಂದ ಇಳಿದುಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ಆರೋನನು ಸತ್ತನೆಂದು ಇಸ್ರೇಲರೆಲ್ಲರಿಗೆ ತಿಳಿಯಿತು. ಆದ್ದರಿಂದ ಇಸ್ರೇಲಿನಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನೂ ಆರೋನನಿಗಾಗಿ ಮೂವತ್ತು ದಿನಗಳವರೆಗೆ ಶೋಕಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ಕಾನಾನ್ಯನಾಗಿದ್ದ ಅರಾದಿನ ರಾಜನು ನೆಗೆವ್‌ನಲ್ಲಿದ್ದುಕೊಂಡು ರಾಜ್ಯಭಾರ ಮಾಡುತ್ತಿದ್ದನು. ಇಸ್ರೇಲರು ಅತಾರೀಮಿನ ಮಾರ್ಗವಾಗಿ ಬರುತ್ತಾರೆಂಬ ಸುದ್ದಿಯು ಅವನಿಗೆ ಮುಟ್ಟಿತು. ಆದ್ದರಿಂದ ಅವನು ಹೋಗಿ ಇಸ್ರೇಲರೊಡನೆ ಯುದ್ಧಮಾಡಿ ಅವರಲ್ಲಿ ಕೆಲವರನ್ನು ಸೆರೆಹಿಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ಇಸ್ರೇಲರು ಯೆಹೋವನಿಗೆ ಹರಕೆಯನ್ನು ಮಾಡಿಕೊಂಡು, “ನಾವು ಈ ಜನರನ್ನು ಜಯಿಸುವಂತೆ ನೀನು ಅನುಗ್ರಹಿಸಿದರೆ ನಾವು ಅವರ ಗ್ರಾಮಗಳನ್ನು ಪೂರ್ಣವಾಗಿ ಹಾಳುಮಾಡಿ ಯೆಹೋವನಿಗಾಗಿಯೇ ಬಿಟ್ಟುಬಿಡುತ್ತೇವೆ” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ಯೆಹೋವನು ಅವರ ಪ್ರಾರ್ಥನೆಯನ್ನು ಕೇಳಿ ಕಾನಾನ್ಯರನ್ನು ಜಯಿಸಲು ಸಹಾಯಮಾಡಿದ್ದರಿಂದ ಅವರು ಕಾನಾನ್ಯರನ್ನೂ ಅವರ ಗ್ರಾಮಗಳನ್ನೂ ಸಂಪೂರ್ಣವಾಗಿ ನಾಶಮಾಡಿಬಿಟ್ಟರು. ಆದ್ದರಿಂದ ಆ ಪ್ರದೇಶಕ್ಕೆ ಹೊರ್ಮಾ ಎಂದು ಹೆಸರಾಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ಇಸ್ರೇಲರು ಹೋರ್ ಬೆಟ್ಟದಿಂದ ಹೊರಟು ಕೆಂಪು ಸಮುದ್ರದ ಮಾರ್ಗವಾಗಿ ಪ್ರಯಾಣಮಾಡಿದರು. ಅವರು ಎದೋಮ್ ದೇಶವನ್ನು ಸುತ್ತಿಕೊಂಡು ಹೋಗುವುದಕ್ಕೆ ಹೀಗೆ ಮಾಡಿದರು. ಜನರು ಮಾರ್ಗದಲ್ಲಿ ತಾಳ್ಮೆ ತಪ್ಪಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ಆಗ ಅವರು ದೇವರಿಗೂ ಮೋಶೆಗೂ ವಿರೋಧವಾಗಿ ಮಾತಾಡುತ್ತಾ “ಈ ಮರುಭೂಮಿಯಲ್ಲಿ ಸಾಯಲೆಂದು ನಮ್ಮನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಯಾಕೆ ಬರಮಾಡಿದೆ? ಇಲ್ಲಿ ಆಹಾರವೂ ಇಲ್ಲ, ನೀರೂ ಇಲ್ಲ. ಈ ನಿಸ್ಸಾರವಾದ ಆಹಾರವನ್ನು ತಿಂದು ನಮಗೆ ಬೇಸರವಾಯಿತು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ಆದ್ದರಿಂದ ಯೆಹೋವನು ಅವರ ಮಧ್ಯದಲ್ಲಿ ವಿಷಕರವಾದ ಹಾವುಗಳನ್ನು ಕಳುಹಿಸಿದನು. ಅವುಗಳು ಅವರನ್ನು ಕಚ್ಚಿದ್ದರಿಂದ ಅನೇಕ ಇಸ್ರೇಲರು ಸತ್ತರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ಆಗ ಜನರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು, “ನಾವು ನಿನಗೂ ಯೆಹೋವನಿಗೂ ವಿರೋಧವಾಗಿ ಮಾತಾಡಿ ಪಾಪ ಮಾಡಿದ್ದೇವೆ. ಈ ಸರ್ಪಗಳನ್ನು ನಮ್ಮಿಂದ ತೊಲಗಿ ಹೋಗುವಂತೆ ಪ್ರಾರ್ಥನೆ ಮಾಡು” ಎಂದು ಬೇಡಿಕೊಂಡರು. ಮೋಶೆ ಜನರಿಗೋಸ್ಕರ ಪ್ರಾರ್ಥಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ತಾಮ್ರದಿಂದ ವಿಷಸರ್ಪದ ಆಕಾರವನ್ನು ಮಾಡಿಸಿ ಧ್ವಜಸ್ತಂಭದ ಮೇಲೆ ಎತ್ತಿ ನಿಲ್ಲಿಸಬೇಕು, ಸರ್ಪಗಳಿಂದ ಕಚ್ಚಿಸಿಕೊಂಡವನು ಅದನ್ನು ನೋಡಿದರೆ ಬದುಕಿಕೊಳ್ಳುವನು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ಆದ್ದರಿಂದ ಮೋಶೆ ತಾಮ್ರದಿಂದ ಸರ್ಪದ ಆಕಾರವನ್ನು ಮಾಡಿಸಿ ಧ್ವಜಸ್ತಂಭದ ಮೇಲೆ ಇಡಿಸಿದನು. ಸರ್ಪಗಳಿಂದ ಕಚ್ಚಿಸಿಕೊಂಡಿದ್ದವನು ಆ ತಾಮ್ರದ ಸರ್ಪವನ್ನು ನೋಡಿ ಬದುಕಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ಇಸ್ರೇಲರು ಪ್ರಯಾಣವನ್ನು ಮುಂದುವರಿಸಿ ಓಬೋತ್ ಎಂಬ ಸ್ಥಳದಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ಬಳಿಕ ಅವರು ಓಬೋತಿನಿಂದ ಇಯ್ಯೇ ಅಬಾರೀಮಿಗೆ ಹೋದರು. ಇದು ಮೋವಾಬಿನ ಪೂರ್ವದಲ್ಲಿರುವ ಮರುಭೂಮಿಯ ಪ್ರದೇಶದಲ್ಲಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ಬಳಿಕ ಜನರು ಅಲ್ಲಿಂದ ಹೊರಟು ಜೆರೆದ್ ಕಣಿವೆಗೆ ಪ್ರಯಾಣ ಮಾಡಿ ಅಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ಅವರು ಅಲ್ಲಿಂದ ಹೊರಟು ಅರ್ನೋನ್ ಹೊಳೆಯ ಆಚೆ ಕಡೆಯಲ್ಲಿ ಅಂದರೆ ಅಮೋರಿಯರ ಪ್ರದೇಶದೊಳಗೆ ವಿಸ್ತರಿಸಿರುವ ಮರುಭೂಮಿಯಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಂಡರು. ಅರ್ನೋನ್ ನದಿಯು ಮೋವಾಬ್ಯರಿಗೂ ಅಮೋರಿಯರಿಗೂ ಗಡಿಯಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ಅದಕ್ಕನುಸಾರವಾಗಿ “ಯೆಹೋವನ ಯುದ್ಧಗಳು” ಎಂಬ ಗ್ರಂಥದಲ್ಲಿ, “ಸೂಫದಲ್ಲಿರುವ ವಾಹೇಬನ್ನು, ಅರ್ನೋನ್ ಹೊಳೆಗೆ ಕೂಡುವ ಕಣಿವೆಗಳನ್ನು ಮತ್ತು ");
INSERT INTO kan2010_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ಆರ್ ವಸತಿ ಪ್ರದೇಶಕ್ಕೆ ನಡೆಸುವ ಮೋವಾಬಿನ ಗಡಿಯ ಉದ್ದಕ್ಕೂ ಇರುವ ಕಣಿವೆಗಳನ್ನು ದಾಟಿದ್ದಾಯಿತು” ಎಂದು ಬರೆದಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ಅಲ್ಲಿಂದ ಅವರು ಬೇರ್ ಎಂಬ ಸ್ಥಳಕ್ಕೆ ಬಂದರು. “ಜನರನ್ನು ಕೂಡಿಸಿಕೊ, ನಾನು ಅವರಿಗೆ ನೀರನ್ನು ಕೊಡುವೆನು” ಎಂದು ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದು ಈ ಬಾವಿಯ ಸ್ಥಳದಲ್ಲೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ಆಗ ಇಸ್ರೇಲರು ಈ ಹಾಡನ್ನು ಹಾಡಿದರು: “ಬಾವಿಯೇ, ಉಕ್ಕುತ್ತಾ ಬಾ! ಜನರೇ, ಅದರ ಕುರಿತು ಹಾಡಿ! ");
INSERT INTO kan2010_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ಪ್ರಧಾನರು ಈ ಬಾವಿಯನ್ನು ತೋಡಿದರು. ಪ್ರಮುಖ ನಾಯಕರು ಈ ಬಾವಿಯನ್ನು ತೋಡಿದರು. ಅವರು ತಮ್ಮ ದೊಣ್ಣೆಗಳಿಂದ ಮತ್ತು ಕೋಲುಗಳಿಂದ ಈ ಬಾವಿಯನ್ನು ಅಗೆದರು.” ಆಮೇಲೆ ಜನರು “ಮತ್ತಾನ” ಎಂಬ ಮರುಭೂಮಿಯಿಂದ ಹೊರಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ಬಳಿಕ ಅವರು ಮತ್ತಾನದಿಂದ ನಹಲೀಯೇಲಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಬಳಿಕ ಅವರು ನಹಲೀಯೇಲಿನಿಂದ ಬಾಮೋತಿಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ಜನರು ಬಾಮೋತಿನಿಂದ ಮೋವಾಬ್ಯರ ಪ್ರದೇಶದ ಕಣಿವೆಗೆ ಪ್ರಯಾಣ ಮಾಡಿದರು. ಪಿಸ್ಗಾ ಬೆಟ್ಟದ ತುದಿಯ ಸಮೀಪದಲ್ಲಿ ನಿಂತುಕೊಂಡರೆ ಮರುಭೂಮಿಯು ಕಾಣುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ಇಸ್ರೇಲರು ಸಂದೇಶಕರನ್ನು ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನ ಬಳಿಗೆ ಕಳುಹಿಸಿದರು. ಅವರು ಅರಸನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ನಿಮ್ಮ ದೇಶವನ್ನು ಹಾದುಹೋಗುವುದಕ್ಕೆ ನಮಗೆ ಅಪ್ಪಣೆಕೊಡು. ನಿಮ್ಮ ಹೊಲಗಳಿಗಾಗಲಿ ದ್ರಾಕ್ಷಿತೋಟಗಳಿಗಾಗಲಿ ನಾವು ತಿರುಗಿಕೊಳ್ಳುವುದಿಲ್ಲ. ನಿನ್ನ ಯಾವ ಬಾವಿಗಳಿಂದಲೂ ನಾವು ನೀರು ಕುಡಿಯುವುದಿಲ್ಲ. ನಾವು ನಿಮ್ಮ ದೇಶವನ್ನು ದಾಟಿಹೋಗುವ ತನಕ ರಾಜ ಮಾರ್ಗದಲ್ಲಿಯೇ ಪ್ರಯಾಣ ಮಾಡುತ್ತೇವೆ” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ಆದರೆ ಅರಸನಾದ ಸೀಹೋನನು ಇಸ್ರೇಲರಿಗೆ ತನ್ನ ದೇಶದ ಮೂಲಕ ಹಾದುಹೋಗಲು ಬಿಡಲಿಲ್ಲ. ಅರಸನು ತನ್ನ ಇಡೀ ಸೈನ್ಯವನ್ನು ಕೂಡಿಸಿಕೊಂಡು ಇಸ್ರೇಲರ ವಿರುದ್ಧ ಯುದ್ಧಮಾಡಲು ಮರುಭೂಮಿಯ ಕಡೆಗೆ ಹೊರಟನು. ಅವನು ಯಹಜ್ ಎಂಬಲ್ಲಿಗೆ ಬಂದನು; ಅಲ್ಲಿ ರಾಜನ ಸೈನ್ಯವು ಇಸ್ರೇಲರಿಗೆ ವಿರೋಧವಾಗಿ ಯುದ್ಧಮಾಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ಆದರೆ ಇಸ್ರೇಲರು ಅರಸನನ್ನು ಕೊಂದುಹಾಕಿದರು. ಬಳಿಕ ಅವರು ಅರ್ನೋನ್ ನದಿಯಿಂದ ಹಿಡಿದು ಯಬ್ಬೋಕ್ ನದಿಯವರೆಗಿರುವ ಅವನ ಭೂಮಿಯನ್ನು ವಶಪಡಿಸಿಕೊಂಡರು. ಅವರು ಅಮ್ಮೋನಿಯರ ಮೇರೆಯವರೆಗಿರುವ ಪ್ರದೇಶವನ್ನೆಲ್ಲಾ ವಶಪಡಿಸಿಕೊಂಡರು. ಅಮ್ಮೋನಿಯರು ತಮ್ಮ ಗಡಿಯನ್ನು ಭದ್ರವಾಗಿ ರಕ್ಷಿಸಿಕೊಂಡದ್ದರಿಂದ ಇಸ್ರೇಲರು ಮುಂದಕ್ಕೆ ಹೋಗಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ಇಸ್ರೇಲರು ಅಮೋರಿಯರ ಪಟ್ಟಣಗಳನ್ನೆಲ್ಲಾ ವಶಪಡಿಸಿಕೊಂಡು ಅವುಗಳಲ್ಲಿ ವಾಸಿಸಿದರು. ಅವರು ಹೆಷ್ಬೋನನ್ನು ಮತ್ತು ಅದರ ಸುತ್ತಲಿರುವ ಎಲ್ಲಾ ಚಿಕ್ಕ ಪಟ್ಟಣಗಳನ್ನು ಸಹ ವಶಪಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ಹೆಷ್ಬೋನಿನಲ್ಲಿ ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನು ವಾಸಿಸುತ್ತಿದ್ದನು. ಸೀಹೋನನು ಮೊದಲಿನ ಮೋವಾಬ್ಯರ ಅರಸನೊಡನೆ ಯುದ್ಧ ಮಾಡಿದ್ದನು. ಸೀಹೋನನು ಅರ್ನೋನ್ ನದಿಯವರೆಗಿರುವ ಆ ರಾಜನ ಪ್ರದೇಶವನ್ನೆಲ್ಲ ವಶಪಡಿಸಿಕೊಂಡಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ಆದಕಾರಣ ಹಾಡುವವರು ಈ ಗೀತೆಯನ್ನು ಹಾಡುತ್ತಾರೆ: “ಹೆಷ್ಬೋನಿಗೆ, ಬಾ! ಮತ್ತೆ ಅದನ್ನು ನಿರ್ಮಿಸು! ಸೀಹೋನನ ಪಟ್ಟಣವನ್ನು ಮತ್ತೆ ಸ್ಥಾಪಿಸಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ಹೆಷ್ಬೋನಿನಲ್ಲಿ ಬೆಂಕಿಯುಂಟಾಯಿತು. ಆ ಬೆಂಕಿ ಸೀಹೋನನ ಪಟ್ಟಣದಲ್ಲಿ ಉಂಟಾಯಿತು. ಆ ಬೆಂಕಿಯು ಮೋವಾಬಿನಲ್ಲಿರುವ ‘ಆರ್’ ಪಟ್ಟಣವನ್ನು ನಾಶಮಾಡಿತು. ಅದು ಅರ್ನೋನ್ ನದಿಯ ಬಳಿಯಲ್ಲಿರುವ ಬೆಟ್ಟಗಳನ್ನು ಸುಟ್ಟುಹಾಕಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ಮೋವಾಬೇ, ಇದು ನಿನಗೆ ಕೆಟ್ಟದ್ದಾಗಿದೆ. ಕೆಮೋಷಿನ ಜನರೇ, ನೀವು ನಾಶವಾದಿರಿ. ಅವನ ಪುತ್ರರು ಓಡಿಹೋದರು. ಅಮೋರಿಯ ರಾಜನಾದ ಸೀಹೋನನು ಅವನ ಪುತ್ರಿಯರನ್ನು ಸೆರೆ ಒಯ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ಆದರೆ ನಾವು ಆ ಅಮೋರಿಯರನ್ನು ಸೋಲಿಸಿದೆವು. ಹೆಷ್ಬೋನಿನಿಂದ ದೀಬೋನಿನವರೆಗಿರುವ ಅವರ ಪಟ್ಟಣಗಳನ್ನೂ ನಾಶೀಮಿನಿಂದ ನೋಫಹದ (ಮೇದೆಬಾದ ಹತ್ತಿರ) ವರೆಗಿರುವ ಪಟ್ಟಣಗಳನ್ನೂ ನಾವು ನಾಶಮಾಡಿದೆವು.” ");
INSERT INTO kan2010_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ಹೀಗೆ ಇಸ್ರೇಲರು ಅಮೋರಿಯರ ದೇಶದಲ್ಲಿ ತಮ್ಮ ಪಾಳೆಯ ಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ಮೋಶೆಯು ಯಗ್ಜೇರ್ ಪಟ್ಟಣದ ಗುಟ್ಟನ್ನು ತಿಳಿದುಕೊಂಡು ಬರುವುದಕ್ಕೆ ಕೆಲವು ಜನರನ್ನು ಕಳುಹಿಸಿದ ನಂತರ, ಇಸ್ರೇಲರು ಆ ಪಟ್ಟಣವನ್ನು ವಶಪಡಿಸಿಕೊಂಡರು. ಅದರ ಸುತ್ತಲಿರುವ ಚಿಕ್ಕ ಪಟ್ಟಣಗಳನ್ನು ಅವರು ವಶಪಡಿಸಿಕೊಂಡರು. ಇಸ್ರೇಲರು ಅಲ್ಲಿದ್ದ ಅಮೋರಿಯರನ್ನು ಓಡಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ಬಳಿಕ ಇಸ್ರೇಲರು ಬೇರೆ ದಿಕ್ಕಿಗೆ ತಿರುಗಿ ಬಾಷಾನಿನ ಮಾರ್ಗವಾಗಿ ಪ್ರಯಾಣಮಾಡಿದರು. ಆಗ ಬಾಷಾನಿನ ಅರಸನಾದ ಓಗನು ಎದ್ರೈ ಎಂಬಲ್ಲಿ ಇಸ್ರೇಲರೊಂದಿಗೆ ಯುದ್ಧಮಾಡಲು ತನ್ನ ಸೈನ್ಯ ಸಮೇತವಾಗಿ ಬಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ಆದರೆ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ಆ ಅರಸನಿಗೆ ಹೆದರಬೇಡ. ನೀನು ಅವನನ್ನು ಸೋಲಿಸುವಂತೆ ಮಾಡುವೆನು. ನೀನು ಅವನ ಸೈನ್ಯವನ್ನು ಮತ್ತು ಅವನ ದೇಶವನ್ನು ಪೂರ್ಣವಾಗಿ ವಶಪಡಿಸಿಕೊಳ್ಳುವೆ. ಹೆಷ್ಬೋನಿನಲ್ಲಿ ವಾಸಿಸಿದ್ದ ಅಮೋರಿಯರ ಅರಸನಾದ ಸೀಹೋನನಿಗೆ ಮಾಡಿದಂತೆ ಇವನಿಗೂ ಸಹ ಮಾಡುವಿರಿ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ಇಸ್ರೇಲರು ಓಗನನ್ನೂ ಅವನ ಸೈನ್ಯವನ್ನೂ ಸೋಲಿಸಿದರು. ಅವರು ಅವನನ್ನೂ ಅವನ ಪುತ್ರರನ್ನೂ ಕೊಂದುಹಾಕಿ ಅವನ ಸೈನ್ಯವನ್ನೆಲ್ಲಾ ನಾಶಮಾಡಿದರು. ಯಾರನ್ನೂ ಜೀವಂತವಾಗಿ ಉಳಿಸಲಿಲ್ಲ. ಇಸ್ರೇಲರು ಅವನ ದೇಶವನ್ನು ವಶಪಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ಬಳಿಕ ಇಸ್ರೇಲರು ಹೊರಟು ಜೆರಿಕೊ ಪಟ್ಟಣದ ಎದುರಾಗಿದ್ದ ಯೊರ್ದನ್ ನದಿಯ ಆಚೆ ಕಡೆಯಲ್ಲಿರುವ ಮೋವಾಬ್ಯರ ಬಯಲುಗಳಲ್ಲಿ ಪಾಳೆಯ ಮಾಡಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ಚಿಪ್ಪೋರನ ಮಗನಾದ ಬಾಲಾಕನು ಮೋವಾಬ್ಯರ ಅರಸನಾಗಿದ್ದನು. ಇಸ್ರೇಲರು ಅಮೋರಿಯರಿಗೆ ಮಾಡಿದ್ದೆಲ್ಲವನ್ನು ಅವನು ಕಂಡಿದ್ದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ಮೋವಾಬ್ಯರು ನಿಜವಾಗಿಯೂ ಬಹಳ ಭಯಗೊಂಡಿದ್ದರು. ಯಾಕೆಂದರೆ ಇಸ್ರೇಲರು ಬಹುಸಂಖ್ಯಾತರಾಗಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ಮೋವಾಬ್ಯರು ಮಿದ್ಯಾನ್ಯರ ಹಿರಿಯರಿಗೆ, “ಈ ಜನಸಮೂಹವು ನಮ್ಮನ್ನೂ ನಮ್ಮ ಸುತ್ತಲಿರುವ ಎಲ್ಲವನ್ನೂ ಹೋರಿಯಂತೆ ನಾಶಮಾಡುವುದು” ಎಂದು ಹೇಳಿದನು. ಮೋವಾಬ್ಯರ ಅರಸನೂ ಚಿಪ್ಪೋರನ ಮಗನೂ ಆದ ಬಾಲಾಕನು, ");
INSERT INTO kan2010_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ಬೆಯೋರನ ಮಗನಾದ ಬಿಳಾಮನನ್ನು ಕರೆಸುವುದಕ್ಕೆ ಕೆಲವು ಸಂದೇಶಕರನ್ನು ಕಳುಹಿಸಿದನು. ಬಿಳಾಮನು ಯೂಫ್ರೆಟೀಸ್ ನದಿಯ ಬಳಿ “ಪೆತೋರ್” ಎಂಬ ಸ್ಥಳದಲ್ಲಿದ್ದನು. ಬಿಳಾಮನ ಜನರು ಇಲ್ಲಿ ವಾಸಿಸುತ್ತಿದ್ದರು. ಬಾಲಾಕನು ತನ್ನ ಸಂದೇಶಕರನ್ನು ಕಳುಹಿಸಿ ಬಿಳಾಮನಿಗೆ, “ಒಂದು ಜನಾಂಗವು ಈಜಿಪ್ಟಿನಿಂದ ಬಂದಿದೆ. ಅವರು ದೇಶವನ್ನೆಲ್ಲಾ ಮುಚ್ಚಿಕೊಂಡು ನನ್ನ ಪಕ್ಕದಲ್ಲಿ ನೆಲೆಸಿದ್ದಾರೆ. ಅವರು ನಮಗಿಂತ ಬಲಿಷ್ಠರು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ಆದ್ದರಿಂದ ನೀನು ದಯಮಾಡಿ ಬಂದು ನನಗೋಸ್ಕರ ಈ ಜನಕ್ಕೆ ಶಾಪಕೊಡಬೇಕು, ಯಾಕೆಂದರೆ ಅವರು ನನಗಿಂತ ಬಲಿಷ್ಠರಾಗಿದ್ದಾರೆ. ನೀನು ಶಪಿಸಿದರೆ ಆಗ ನಾನು ಅವರನ್ನು ಸೋಲಿಸಿ ಈ ದೇಶದಿಂದ ಓಡಿಸಲು ನನಗೆ ಸಾಧ್ಯವಾಗುವುದು. ನೀನು ಯಾವನನ್ನು ಆಶೀರ್ವದಿಸುವಿಯೋ ಅವನು ಯಶಸ್ವಿಯಾಗುವನೆಂದೂ ನೀನು ಯಾವನನ್ನು ಶಪಿಸುವೆಯೋ ಅವನಿಗೆ ಸೋಲಾಗುವುದೆಂದೂ ನನಗೆ ಗೊತ್ತಿದೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ಮೋವಾಬ್ಯರ ಹಿರಿಯರು ಮತ್ತು ಮಿದ್ಯಾನ್ಯರ ಹಿರಿಯರು ಬಿಳಾಮನ ಸೇವೆಗೋಸ್ಕರ ಹಣ ಕೊಡಲು ಹಣವನ್ನು ತೆಗೆದುಕೊಂಡು ಹೊರಟು ಅವನ ಬಳಿಗೆ ಬಂದು ಬಾಲಾಕನ ಮಾತುಗಳನ್ನು ತಿಳಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ಬಿಳಾಮನು, “ಈ ರಾತ್ರಿ ನೀವು ಇಲ್ಲೇ ಇಳಿದುಕೊಳ್ಳಿರಿ. ಯೆಹೋವನು ನನಗೆ ಹೇಳುವ ಮಾತನ್ನು ಬೆಳಿಗ್ಗೆ ನಿಮಗೆ ತಿಳಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಮೋವಾಬ್ಯರ ಹಿರಿಯರು ಆ ರಾತ್ರಿ ಬಿಳಾಮನ ಮನೆಯಲ್ಲಿ ಇಳಿದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ದೇವರು ಬಿಳಾಮನ ಬಳಿಗೆ ಬಂದು, “ನಿನ್ನ ಬಳಿಯಲ್ಲಿರುವ ಈ ಮನುಷ್ಯರು ಯಾರು?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ಬಿಳಾಮನು ದೇವರಿಗೆ, “ಮೋವಾಬ್ಯರ ಅರಸನು ಅಂದರೆ ಚಿಪ್ಪೋರನ ಮಗನಾದ ಬಾಲಾಕನು ನನ್ನ ಬಳಿಗೆ ದೂತರನ್ನು ಕಳುಹಿಸಿ, ");
INSERT INTO kan2010_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ಒಂದು ಜನಾಂಗವು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಟು ಬಂದಿದೆ ಮತ್ತು ಅವರು ದೇಶವನ್ನೆಲ್ಲಾ ಮುಚ್ಚಿಕೊಂಡಿದ್ದಾರೆ. ಈಗ ನೀನು ಬಂದು ನನಗೋಸ್ಕರ ಅವರನ್ನು ಶಪಿಸು. ನೀನು ಶಪಿಸಿದರೆ, ನಾನು ಅವರನ್ನು ಸೋಲಿಸಲು ಮತ್ತು ಓಡಿಸಲು ಸಾಧ್ಯವಾಗುತ್ತದೆ ಎಂಬುದಾಗಿ ಹೇಳಿ ಕಳುಹಿಸಿದ್ದಾನೆ” ಎಂದು ಉತ್ತರಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ಅದಕ್ಕೆ ದೇವರು ಬಿಳಾಮನಿಗೆ, “ನೀನು ಅವರ ಜೊತೆಯಲ್ಲಿ ಹೋಗಬಾರದು, ಆ ಜನರಿಗೆ ಶಾಪಕೊಡಬಾರದು. ನಾನು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ಮರುದಿನ ಬೆಳಿಗ್ಗೆ ಬಿಳಾಮನು ಎದ್ದು ಬಾಲಾಕನ ಹಿರಿಯರಿಗೆ, “ನಿಮ್ಮ ಸ್ವಂತ ದೇಶಕ್ಕೆ ಹಿಂದಕ್ಕೆ ಹೋಗಿರಿ. ನಿಮ್ಮ ಸಂಗಡ ಬರಲು ಯೆಹೋವನು ನನಗೆ ಅಪ್ಪಣೆ ಕೊಡುತ್ತಿಲ್ಲ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ಮೋವಾಬ್ಯರ ನಾಯಕರು ಬಾಲಾಕನ ಬಳಿಗೆ ಹಿಂತಿರುಗಿ, “ಬಿಳಾಮನು ನಮ್ಮೊಡನೆ ಬರಲು ಒಪ್ಪುತ್ತಿಲ್ಲ” ಎಂದು ತಿಳಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ಆದ್ದರಿಂದ ಬಾಲಾಕನು ಅವರಿಗಿಂತಲೂ ಶ್ರೇಷ್ಠರಾದ ಅನೇಕ ನಾಯಕರನ್ನು ಕಳುಹಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ಇವರು ಬಿಳಾಮನ ಬಳಿಗೆ ಬಂದು ಅವನಿಗೆ, “ಚಿಪ್ಪೋರನ ಮಗನಾದ ಬಾಲಾಕನು ಹೀಗೆನ್ನುತ್ತಾನೆ: ನೀನು ನನ್ನ ಬಳಿಗೆ ಬರಲು ಅಡ್ಡಿಮಾಡುವ ಯಾವುದಕ್ಕೂ ಅವಕಾಶ ಕೊಡಬೇಡ. ");
INSERT INTO kan2010_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ನಾನು ಹೇಳುವುದನ್ನು ನೀನು ಮಾಡಿದರೆ, ನಾನು ನಿನಗೆ ಹಣವನ್ನು ಮತ್ತು ಗೌರವವನ್ನು ಬಹಳವಾಗಿ ಕೊಡುವೆನು ಮತ್ತು ನೀನು ಹೇಳಿದ್ದೆಲ್ಲವನ್ನು ಮಾಡುವೆನು. ಬಂದು, ನನಗಾಗಿ ಈ ಜನರನ್ನು ಶಪಿಸು” ಎಂದು ಹೇಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ಬಿಳಾಮನು ಬಾಲಾಕನ ಅಧಿಕಾರಿಗಳಿಗೆ, “ಬಾಲಾಕನು ನನಗೆ ಬೆಳ್ಳಿಬಂಗಾರಗಳಿಂದ ತುಂಬಿದ ತನ್ನ ಅರಮನೆಯನ್ನು ಕೊಟ್ಟರೂ ನನ್ನ ದೇವರಾದ ಯೆಹೋವನ ಆಜ್ಞೆಗೆ ವಿರೋಧವಾಗಿ ನಾನೇನೂ ಮಾಡಲು ಸಾಧ್ಯವಿಲ್ಲ. ಯೆಹೋವನು ಅಪ್ಪಣೆ ಕೊಡದ ಹೊರತು ನಾನು ಚಿಕ್ಕಕಾರ್ಯವನ್ನಾಗಲಿ ದೊಡ್ಡಕಾರ್ಯವನ್ನಾಗಲಿ ಮಾಡಲಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ಆದ್ದರಿಂದ ನೀವೂ ಸಹ ಇತರ ಹಿರಿಯರಂತೆ ಈ ರಾತ್ರಿ ಇಲ್ಲೇ ಇರಬೇಕು. ಯೆಹೋವನು ನನಗೆ ಇನ್ನೂ ಹೇಳಬೇಕಾದದ್ದನ್ನು ಈ ರಾತ್ರಿ ತಿಳಿದುಕೊಳ್ಳುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ಆ ರಾತ್ರಿ ದೇವರು ಬಿಳಾಮನ ಬಳಿಗೆ ಬಂದು, “ಈ ಜನರು ನಿನ್ನನ್ನು ತಮ್ಮೊಡನೆ ಬರಬೇಕೆಂದು ಆಹ್ವಾನಿಸಲು ಬಂದಿದ್ದಾರೆ. ಆದ್ದರಿಂದ ನೀನು ಅವರೊಂದಿಗೆ ಹೋಗಬಹುದು. ಆದರೆ ನಾನು ಹೇಳುವುದನ್ನು ಮಾತ್ರ ಮಾಡು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ಮರುದಿನ ಬೆಳಿಗ್ಗೆ ಬಿಳಾಮನು ತನ್ನ ಕತ್ತೆಗೆ ತಡಿಹಾಕಿಸಿ ಮೋವಾಬ್ಯರ ಪ್ರಧಾನರ ಜೊತೆಯಲ್ಲಿ ಹೊರಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ಬಿಳಾಮನು ಕತ್ತೆಯ ಮೇಲೆ ಸವಾರಿ ಮಾಡುತ್ತಿದ್ದನು. ಅವನ ಜೊತೆ ಇಬ್ಬರು ಆಳುಗಳಿದ್ದರು. ಬಿಳಾಮನು ಪ್ರಯಾಣ ಮಾಡತೊಡಗಿದ್ದರಿಂದ ದೇವರು ಕೋಪಗೊಂಡನು. ಆದ್ದರಿಂದ ಯೆಹೋವನ ದೂತನು ಬಿಳಾಮನನ್ನು ತಡೆಯಲು ದಾರಿಯಲ್ಲಿ ನಿಂತುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ಯೆಹೋವನ ದೂತನು ಬಿಚ್ಚುಕತ್ತಿಯನ್ನು ಹಿಡಿದುಕೊಂಡು ದಾರಿಯಲ್ಲೇ ನಿಂತಿರುವುದನ್ನು ಆ ಕತ್ತೆ ನೋಡಿ ದಾರಿಯನ್ನು ಬಿಟ್ಟು ಬಯಲಿನ ಕಡೆ ಹೋಯಿತು. ಕತ್ತೆಯನ್ನು ದಾರಿಗೆ ತಿರುಗಿಸುವದಕ್ಕೆ ಬಿಳಾಮನು ಅದನ್ನು ಹೊಡೆದನು. ಅವನಿಗೆ ದೂತನು ಕಾಣಿಸಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ಆಮೇಲೆ ಯೆಹೋವನ ದೂತನು ಎರಡು ದ್ರಾಕ್ಷಿತೋಟಗಳ ನಡುವಿನ ಕಿರಿದಾದ ದಾರಿಯಲ್ಲಿ ನಿಂತುಕೊಂಡನು. ಎರಡು ಕಡೆಯಲ್ಲಿಯೂ ಗೋಡೆಗಳಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ತಿರುಗಿ ಕತ್ತೆಯು ಯೆಹೋವನ ದೂತನನ್ನು ನೋಡಿ ಗೋಡೆಗೆ ತನ್ನನ್ನು ಒತ್ತರಿಸಿಕೊಂಡಿತು. ಆಗ ಬಿಳಾಮನ ಪಾದವು ಗೋಡೆಗೆ ಒತ್ತರಿಸಿತು. ಆದ್ದರಿಂದ ಬಿಳಾಮನು ತಿರುಗಿ ಕತ್ತೆಯನ್ನು ಹೊಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ಬಳಿಕ ಯೆಹೋವನ ದೂತನು ಮತ್ತೆ ಮುಂದೆ ಹೋಗಿ ಕತ್ತೆಯು ಎಡಕ್ಕಾಗಲಿ ಬಲಕ್ಕಾಗಲಿ ಹೊರಳಲು ಸಾಧ್ಯವಿಲ್ಲದಷ್ಟು ಇನ್ನೂ ಕಿರಿದಾದ ಸ್ಥಳದಲ್ಲಿ ನಿಂತುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ಕತ್ತೆಯು ಯೆಹೋವನ ದೂತನನ್ನು ನೋಡಿ ಬಿಳಾಮನ ಕೆಳಗೆ ಅಡಗಿ ಮಲಗಿಕೊಂಡಿತು. ಆಗ ಬಿಳಾಮನು ಸಿಟ್ಟುಗೊಂಡು ತನ್ನ ಕೋಲಿನಿಂದ ಕತ್ತೆಯನ್ನು ಹೊಡೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ಆಗ ಯೆಹೋವನು ಆ ಕತ್ತೆಗೆ ಮಾತಾಡುವ ಶಕ್ತಿಯನ್ನು ಕೊಟ್ಟನು. ಅದು ಬಿಳಾಮನಿಗೆ, “ನೀನು ಮೂರು ಸಾರಿ ನನ್ನನ್ನು ಹೊಡೆದದ್ದೇಕೆ? ನಾನು ನಿನಗೇನು ಮಾಡಿದ್ದೇನೆ?” ಎಂದು ಕೇಳಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ಬಿಳಾಮನು, “ನೀನು ನನ್ನನ್ನು ಮೂರ್ಖನನ್ನಾಗಿ ಮಾಡಿರುವೆ. ನನ್ನ ಕೈಯಲ್ಲಿ ಕತ್ತಿಯಿದ್ದರೆ ನಿನ್ನನ್ನು ಈಗಲೇ ಕೊಂದುಹಾಕಿಬಿಡುತ್ತಿದ್ದೆ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ಅದಕ್ಕೆ ಕತ್ತೆಯು ಬಿಳಾಮನಿಗೆ, “ನೋಡು, ನಾನು ನಿನ್ನ ಸ್ವಂತ ಕತ್ತೆ. ಅನೇಕಾನೇಕ ವರ್ಷಗಳಿಂದ ನೀನು ನನ್ನ ಮೇಲೆ ಸವಾರಿ ಮಾಡುತ್ತಿರುವೆ. ನಾನು ಹಿಂದೆಂದೂ ಹೀಗೆ ಮಾಡಲಿಲ್ಲವೆಂದು ನಿನಗೆ ತಿಳಿದದೆ” ಎಂದು ಹೇಳಿತು. ಅದಕ್ಕೆ ಬಿಳಾಮನು, “ಅದು ನಿಜ” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ಆಗ ಯೆಹೋವನು ಬಿಳಾಮನ ಕಣ್ಣುಗಳನ್ನು ತೆರೆದು ಬಿಚ್ಚುಕತ್ತಿಯನ್ನು ಹಿಡಿದುಕೊಂಡು ದಾರಿಯಲ್ಲಿ ನಿಂತಿರುವ ಯೆಹೋವನ ದೂತನನ್ನು ನೋಡುವಂತೆ ಮಾಡಿದನು. ಅವನನ್ನು ಕಂಡಾಗ ಬಿಳಾಮನು ಮೊಣಕಾಲೂರಿ ತನ್ನ ಮುಖವನ್ನು ನೆಲದವರೆಗೂ ಬಾಗಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ಯೆಹೋವನ ದೂತನು ಬಿಳಾಮನಿಗೆ, “ನೀನು ಮೂರು ಸಲವೂ ಕತ್ತೆಯನ್ನು ಹೊಡೆದದ್ದೇಕೆ? ನಿನ್ನ ಪ್ರಯಾಣವು ನನ್ನ ಚಿತ್ತಕ್ಕೆ ವಿರುದ್ಧವಾದದ್ದರಿಂದ ನಿನ್ನನ್ನು ತಡೆಯುವುದಕ್ಕೆ ನಾನೇ ಬಂದಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ಆ ಕತ್ತೆ ನನ್ನನ್ನು ನೋಡಿ ಮೂರು ಸಲ ನನ್ನೆದುರಿನಿಂದ ಇನ್ನೊಂದು ಕಡೆಗೆ ತಿರುಗಿಕೊಂಡಿತು. ಹಾಗೆ ತಿರುಗಿಕೊಳ್ಳದಿದ್ದಲ್ಲಿ ನಾನು ಕತ್ತೆಯನ್ನು ಉಳಿಸಿ ನಿನ್ನನ್ನು ಆಗಲೇ ಕೊಂದುಹಾಕಿಬಿಡುತ್ತಿದ್ದೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ಆಗ ಬಿಳಾಮನು ಯೆಹೋವನ ದೂತನಿಗೆ, “ನಾನು ಪಾಪ ಮಾಡಿದ್ದೇನೆ. ನೀನು ದಾರಿಯಲ್ಲಿ ನಿಂತುಕೊಂಡಿರುವುದು ನನಗೆ ಗೊತ್ತಾಗಲಿಲ್ಲ. ನನ್ನ ಪ್ರಯಾಣವು ನಿನಗೆ ಮೆಚ್ಚಿಕೆಯಾಗಿಲ್ಲದಿದ್ದರೆ, ನಾನು ಮನೆಗೆ ಹಿಂತಿರುಗುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ಆಗ ಯೆಹೋವನ ದೂತನು ಬಿಳಾಮನಿಗೆ, “ಆ ಮನುಷ್ಯರ ಜೊತೆಯಲ್ಲಿ ಹೋಗು. ಆದರೆ ನಾನು ನಿನಗೆ ಹೇಳುವ ಮಾತನ್ನೇ ಹೊರತು ಬೇರೆ ಯಾವುದನ್ನೂ ಹೇಳಬಾರದು” ಎಂದು ಹೇಳಿದನು. ಆದ್ದರಿಂದ ಬಿಳಾಮನು ಬಾಲಾಕನ ನಾಯಕರೊಡನೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ಬಿಳಾಮನು ಬರುತ್ತಿರುವ ಸುದ್ದಿಯನ್ನು ಬಾಲಾಕನು ಕೇಳಿ ಅವನನ್ನು ಎದುರುಗೊಳ್ಳುವುದಕ್ಕಾಗಿ ತನ್ನ ದೇಶದ ಸರಹದ್ದಿನಲ್ಲಿ ಅರ್ನೋನ್ ನದಿಯ ಬಳಿಯಲ್ಲಿರುವ ಮೋವ್ಯಾಬರ ಊರಿನಲ್ಲಿ ಅವನನ್ನು ಭೇಟಿಯಾಗಲು ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು ಕಂಡಾಗ, “ನಿನ್ನನ್ನು ಅವಸರದಿಂದ ಕರೆಸುವುದಕ್ಕೆ ದೂತರನ್ನು ಕಳುಹಿಸಿದೆನಲ್ಲಾ. ನೀನು ಆಗಲೇ ಯಾಕೆ ಬರಲಿಲ್ಲ? ನಿನ್ನನ್ನು ಘನಪಡಿಸುವುದಕ್ಕೆ ನಾನು ಸಮರ್ಥನಲ್ಲವೆಂದು ನೀನು ಭಾವಿಸಿಕೊಂಡಿರುವಿಯಾ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ಬಿಳಾಮನು, “ನಾನು ಈಗ ಬಂದಿದ್ದೇನೆ. ಆದರೆ, ನಿನಗೆ ಇಷ್ಟವಾಗುವಂಥದ್ದನ್ನು ಹೇಳಲು ನನಗೆ ಸಾಧ್ಯವಿಲ್ಲ. ದೇವರು ನನಗೆ ತಿಳಿಸುವುದನ್ನೇ ನಾನು ಹೇಳಬೇಕು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ಆಗ ಬಿಳಾಮನು ಬಾಲಾಕನೊಡನೆ ಕಿರ್ಯತ್‌ಹುಚೋತಿಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ಬಾಲಾಕನು ಹೋರಿಗಳನ್ನು ಮತ್ತು ಕುರಿಗಳನ್ನು ವಧಿಸಿ ಯಜ್ಞಮಾಡಿ ಅದರಲ್ಲಿ ಸ್ವಲ್ಪ ಭಾಗವನ್ನು ಬಿಳಾಮನಿಗೂ ಅವನ ಸಂಗಡವಿದ್ದ ಪ್ರಧಾನರಿಗೂ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ಮರದಿನ ಬೆಳಿಗ್ಗೆ ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು ಬಾಮೋತ್‌ಬಾಳ್ ಎಂಬ ಸ್ಥಳದವರೆಗೂ ಕರೆದುಕೊಂಡು ಹೋದನು. ಅಲ್ಲಿಂದ ಇಸ್ರೇಲರ ಪಾಳೆಯ ಸ್ವಲ್ಪಸ್ವಲ್ಪ ಕಾಣುತ್ತಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ಇಲ್ಲಿ ನೀನು ಏಳು ಯಜ್ಞವೇದಿಕೆಗಳನ್ನು ನನಗೆ ಕಟ್ಟಿಸಿ ಏಳು ಹೋರಿಗಳನ್ನೂ ಏಳು ಟಗರುಗಳನ್ನೂ ನನಗೆ ಸಿದ್ಧಪಡಿಸು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ಬಾಲಾಕನು ಹಾಗೆಯೇ ಮಾಡಿದನು. ಬಾಲಾಕನೂ ಬಿಳಾಮನೂ ಪ್ರತಿಯೊಂದು ಯಜ್ಞವೇದಿಕೆಯ ಮೇಲೆ ಒಂದು ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಿದಾಗ, ");
INSERT INTO kan2010_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ನೀನು ಸರ್ವಾಂಗಹೋಮ ಮಾಡಿದ ಸ್ಥಳದಲ್ಲೇ ಇರು. ನಾನು ಸ್ವಲ್ಪದೂರ ಹೋಗಿ ಬರುತ್ತೇನೆ. ಒಂದುವೇಳೆ ಯೆಹೋವನು ನನ್ನನ್ನು ಸಂಧಿಸಲು ಬರಬಹುದು. ಆತನು ನನಗೆ ಪ್ರಕಟಿಸುವುದನ್ನು ನಿನಗೆ ತಿಳಿಸುವೆನು” ಎಂದು ಹೇಳಿ ಮರವಿಲ್ಲದ ಒಂದು ದಿಣ್ಣೆಗೆ ಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ದೇವರು ಬಿಳಾಮನಿಗೆ ಎದುರಾಗಿ ಬಂದಾಗ ಬಿಳಾಮನು ಆತನಿಗೆ, “ನಾನು ಏಳು ಯಜ್ಞವೇದಿಕೆಗಳನ್ನು ಕಟ್ಟಿಸಿ ಒಂದೊಂದು ಪೀಠದಲ್ಲಿ ಒಂದು ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ಆಗ ಯೆಹೋವನು ಬಿಳಾಮನಿಗೆ ಅವನು ಹೇಳಬೇಕಾದ ಮಾತನ್ನು ಕಲಿಸಿಕೊಟ್ಟು, “ನೀನು ಬಾಲಾಕನ ಬಳಿಗೆ ತಿರುಗಿಹೋಗಿ ಹೀಗೆ ಹೇಳಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ಬಿಳಾಮನು ಬಾಲಾಕನ ಬಳಿಗೆ ತಿರುಗಿಬಂದಾಗ ಬಾಲಾಕನು ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಯಲ್ಲಿ ನಿಂತಿದ್ದನು. ಮೋವಾಬ್ಯರ ಪ್ರಧಾನರೆಲ್ಲರೂ ಅವನೊಡನೆ ನಿಂತಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ಆಗ ಬಿಳಾಮನು ಹೀಗೆ ಹೇಳಿದನು: “ಮೋವಾಬ್ಯರ ಅರಸನಾದ ಬಾಲಾಕನು ನನ್ನನ್ನು ಅರಾಮಿನ ಪೂರ್ವ ದಿಕ್ಕಿನ ಬೆಟ್ಟಗಳಿಂದ ನನ್ನನ್ನು ಕರೆಸಿದನು. ‘ನೀನು ಬಂದು ನನಗೋಸ್ಕರ ಯಾಕೋಬ್ಯರನ್ನು ಶಪಿಸು; ಇಸ್ರೇಲರ ವಿರುದ್ಧ ಮಾತನಾಡು’ ಎಂದು ಬಾಲಾಕನು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ಆದರೆ ದೇವರು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿರುವಾಗ ನಾನು ಅವರನ್ನು ಶಪಿಸಲು ಆಗುವುದಿಲ್ಲ. ಯೆಹೋವನು ಅವರ ಮೇಲೆ ನಾಶನವನ್ನು ಬರಮಾಡಲಿಲ್ಲ. ಆದ್ದರಿಂದ ನಾಶನವು ಅವರ ಮೇಲೆ ಇಳಿದುಬರುವಂತೆ ಮಾಡಲು ನನಗೆ ಸಾಧ್ಯವಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ಬೆಟ್ಟದ ಶಿಖರದಿಂದ ಅವರನ್ನು ನಾನು ನೋಡಿದೆನು; ಗುಡ್ಡದಿಂದ ಅವರನ್ನು ಕಂಡೆನು. ಅವರು ತಮ್ಮನ್ನು ಇತರ ಜನಾಂಗಗಳಿಗಿಂತ ಬೇರೆಯಾದವರು ಎಂದು ಪರಿಗಣಿಸಿಕೊಂಡಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ಧೂಳಿನಷ್ಟು ಅಸಂಖ್ಯವಾದ ಯಾಕೋಬ್ಯರನ್ನು ಲೆಕ್ಕಿಸುವುದಕ್ಕೆ ಯಾರಿಂದಾದೀತು; ಇಸ್ರೇಲರ ಕಾಲು ಭಾಗವನ್ನಾದರೂ ಯಾರೂ ಲೆಕ್ಕಿಸಲಾರರು. ಸಜ್ಜನರಾದ ಅವರು ಸಾಯುವ ರೀತಿಯಲ್ಲೇ ನಾನೂ ಸಾಯಲು ಬಯಸುವೆ. ಅವರಿಗುಂಟಾಗುವ ಅಂತ್ಯ ನನಗೂ ಉಂಟಾಗಲಿ.” ");
INSERT INTO kan2010_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ಇದೇನು ನೀನು ನನಗೆ ಮಾಡಿದ್ದು! ನನ್ನ ಶತ್ರುಗಳನ್ನು ಶಪಿಸುವುದಕ್ಕೆ ನಿನ್ನನ್ನು ಕರೆಸಿದೆನು. ನೀನು ಅವರನ್ನು ಶಪಿಸದೆ ಆಶೀರ್ವಾದವನ್ನೇ ಮಾಡಿಬಿಟ್ಟೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ಅದಕ್ಕೆ ಬಿಳಾಮನು, “ಯೆಹೋವನು ನನಗೆ ತಿಳಿಸುವುದನ್ನು ನಾನು ಹೇಳಬಾರದೇ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ಆಗ ಬಾಲಾಕನು, “ದಯಮಾಡಿ ನನ್ನೊಂದಿಗೆ ಇನ್ನೊಂದು ಸ್ಥಳಕ್ಕೆ ಬಾ; ಅಲ್ಲಿಂದ ಅವರನ್ನು ನೋಡಬಹುದು. ಆದರೆ ಅವರೆಲ್ಲರೂ ಕಾಣಿಸದೆ ಕಡೇ ಭಾಗವು ಮಾತ್ರ ಕಾಣಿಸುವುದು. ಅಲ್ಲಿಂದ ನನಗೋಸ್ಕರ ಅವರನ್ನೇ ಶಪಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ಹೀಗೆ ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು “ಕಾವಲುಗಾರರ ಬೆಟ್ಟಗಳು” ಎಂಬ ಸ್ಥಳಕ್ಕೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ಇದು ಪಿಸ್ಗಾ ಪರ್ವತಶ್ರೇಣಿಯ ತುದಿಯಲ್ಲಿತ್ತು. ಅಲ್ಲಿಯೂ ಏಳು ಯಜ್ಞವೇದಿಕೆಗಳನ್ನು ಕಟ್ಟಿಸಿ ಪ್ರತಿಯೊಂದು ವೇದಿಕೆಯಲ್ಲಿ ಒಂದು ಹೋರಿಯನ್ನು ಮತ್ತು ಒಂದು ಟಗರನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಸಮರ್ಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ನೀನು ನಿನ್ನ ಯಜ್ಞವೇದಿಕೆಯ ಬಳಿಯಲ್ಲಿರು. ನಾನು ಆ ಕಡೆ ಹೋಗಿ ಯೆಹೋವನನ್ನು ಸಂಧಿಸುವೆನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ಯೆಹೋವನು ಬಿಳಾಮನಿಗೆ ಎದುರಾಗಿ ಬಂದು ಅವನು ಹೇಳಬೇಕಾದ ಮಾತನ್ನು ಕಲಿಸಿಕೊಟ್ಟು, “ನೀನು ಬಾಲಾಕನ ಬಳಿಗೆ ಹೋಗಿ ಹೀಗೆ ಹೇಳಬೇಕು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ಬಿಳಾಮನು ಬಾಲಾಕನ ಬಳಿಗೆ ಬಂದಾಗ ಅವನು ಇನ್ನೂ ಯಜ್ಞಪೀಠದ ಬಳಿಯಲ್ಲಿ ನಿಂತಿದ್ದನು. ಮೋವಾಬ್ಯರ ಪ್ರಧಾನರು ಅವನ ಸಂಗಡ ಇದ್ದರು. ಬಾಲಾಕನು, “ಯೆಹೋವನು ಏನು ಹೇಳಿದ್ದಾನೆ?” ಎಂದು ಕೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ಆಗ ಬಿಳಾಮನು ಈ ಸಂಗತಿಗಳನ್ನು ಹೇಳಿದನು, “ಬಾಲಾಕನೇ, ಎದ್ದುನಿಂತು ನಾನು ಹೇಳುವುದನ್ನು ಕೇಳು. ಚಿಪ್ಪೋರನ ಮಗನಾದ ಬಾಲಾಕನೇ, ಕೇಳು: ");
INSERT INTO kan2010_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ದೇವರು ಮನುಷ್ಯನಲ್ಲ; ಆತನು ಸುಳ್ಳಾಡುವುದಿಲ್ಲ. ದೇವರು ಮಾನವನಲ್ಲ; ಆತನ ಉದ್ದೇಶಗಳು ಬದಲಾಗುವುದಿಲ್ಲ. ಯೆಹೋವನು ತಾನು ಮಾಡುತ್ತೇನೆಂದು ಹೇಳಿದರೆ, ಅದನ್ನು ಮಾಡಿಯೇ ಮಾಡುತ್ತಾನೆ. ಯೆಹೋವನು ವಾಗ್ದಾನ ಮಾಡಿದರೆ, ಅದನ್ನು ನೆರವೇರಿಸುತ್ತಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ಆ ಜನರನ್ನು ಆಶೀರ್ವದಿಸಬೇಕೆಂದು ಯೆಹೋವನು ನನಗೆ ಆಜ್ಞಾಪಿಸಿದನು; ಯೆಹೋವನು ಅವರನ್ನು ಆಶೀರ್ವದಿಸಿದ್ದಾನೆ. ಅದನ್ನು ಬದಲಾಯಿಸಲು ನನಗೆ ಸಾಧ್ಯವಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ಯಾಕೋಬನ ಜನರಲ್ಲಿ ಯಾವ ದೋಷವೂ ಇಲ್ಲ. ಇಸ್ರೇಲಿನ ಜನರಲ್ಲಿ ಯಾವ ಆಪತ್ತು ಕಾಣುತ್ತಿಲ್ಲ. ಯೆಹೋವನೇ ಅವರ ದೇವರು. ಆತನು ಅವರೊಂದಿಗಿದ್ದಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ದೇವರು ಅವರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದನು. ಅವರು ಕಾಡು ಕೋಣದಂತೆ ಬಲಿಷ್ಠರಾಗಿದ್ದಾರೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ನಿಜವಾಗಿಯೂ ಯಾಕೋಬನ ಜನರ ಮಧ್ಯದಲ್ಲಿ ಶಕುನ ನೋಡುವವರು ಇಲ್ಲ. ಇಸ್ರೇಲಿನಲ್ಲಿ ಕಣಿ ಹೇಳುವವರು ಇಲ್ಲ. ಜನರು, ಯಾಕೋಬನ ಮತ್ತು ಇಸ್ರೇಲರ ಬಗ್ಗೆ ಹೀಗೆ ಹೇಳುವರು: ‘ದೇವರು ಮಾಡಿದ ಮಹಾಕಾರ್ಯಗಳನ್ನು ನೋಡಿರಿ!’ ");
INSERT INTO kan2010_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ಆ ಜನರು ಪ್ರಾಯಸಿಂಹದಂತೆ ಬಲಿಷ್ಠರು. ಅವರು ಸಿಂಹದಂತೆ ಹೋರಾಡುತ್ತಾರೆ. ಆ ಸಿಂಹ ತನ್ನ ವೈರಿಯನ್ನು ತಿಂದುಬಿಡುವತನಕ ವಿಶ್ರಮಿಸುವುದಿಲ್ಲ. ಆ ಸಿಂಹವು ತನಗೆ ಬಲಿಯಾದವರ ರಕ್ತವನ್ನು ಹೀರುವವರೆಗೆ ಎಂದಿಗೂ ವಿಶ್ರಮಿಸುವುದಿಲ್ಲ.” ");
INSERT INTO kan2010_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ಆಗ ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ನೀನು ಅವರನ್ನು ಶಪಿಸಲೂ ಬೇಡ, ಆಶೀರ್ವದಿಸಲೂ ಬೇಡ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ಅದಕ್ಕೆ ಬಿಳಾಮನು, “ಯೆಹೋವನು ಹೇಳುವುದನ್ನೇ ನಾನು ಮಾಡುತ್ತೇನೆ ಎಂದು ನಾನು ನಿನಗೆ ಮೊದಲೇ ಹೇಳಲಿಲ್ಲವೆ?” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ಆಮೇಲೆ ಬಾಲಾಕನು ಬಿಳಾಮನಿಗೆ, “ಸರಿ, ಇನ್ನೊಂದು ಸ್ಥಳಕ್ಕೆ ಬಾ. ಒಂದುವೇಳೆ ನೀನು ಅವರನ್ನು ಶಪಿಸಬೇಕೆಂದು ದೇವರು ಅಪೇಕ್ಷೆಪಡಬಹುದು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ಬಾಲಾಕನು ಬಿಳಾಮನನ್ನು “ಪೆಗೋರ್” ಬೆಟ್ಟದ ತುದಿಗೆ ಕರೆದುಕೊಂಡು ಹೋದನು. ಆ ಬೆಟ್ಟದ ಮೇಲಿಂದ ಕೆಳಗಿರುವ ಮರುಭೂಮಿಯು ಕಾಣಿಸುತ್ತದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ಆಗ ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ಇಲ್ಲಿಯೂ ಏಳು ಯಜ್ಞವೇದಿಕೆಗಳನ್ನು ಕಟ್ಟಿಸಿ ಏಳು ಹೋರಿಗಳನ್ನು ಮತ್ತು ಏಳು ಟಗರುಗಳನ್ನು ಸಿದ್ಧಪಡಿಸು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ಬಾಲಾಕನು ಅವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಪ್ರತಿಯೊಂದನ್ನು ಮಾಡಿ ಪ್ರತಿಯೊಂದು ಪೀಠದಲ್ಲಿ ಒಂದು ಹೋರಿಯನ್ನು ಮತ್ತು ಒಂದು ಟಗರನ್ನು ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಅರ್ಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ಇಸ್ರೇಲರನ್ನು ಆಶೀರ್ವದಿಸುವುದೇ ಯೆಹೋವನ ಆಸೆಯೆಂದು ಬಿಳಾಮನು ತಿಳಿದುಕೊಂಡನು. ಆದ್ದರಿಂದ ಬಿಳಾಮನು ಮೊದಲಿನಂತೆ ಶಕುನ ನೋಡುವುದಕ್ಕೆ ಹೋಗದೆ ಮರುಭೂಮಿಯ ಕಡೆಗೆ ಮುಖವನ್ನು ತಿರುಗಿಸಿಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ಬಿಳಾಮನು ಕಣ್ಣೆತ್ತಿ ನೋಡಿದಾಗ ಇಸ್ರೇಲರೆಲ್ಲರನ್ನು ಕಂಡನು. ಅವರು ತಮ್ಮ ಕುಲಗಳ ಪ್ರಕಾರ ಡೇರೆಗಳನ್ನು ಹಾಕಿಕೊಂಡಿದ್ದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ಆಗ ಅವನು ದೇವರಾತ್ಮ ಪ್ರೇರಿತನಾಗಿ ಹೀಗೆಂದನು: “ಬೆಯೋರನ ಮಗನಾದ ಬಿಳಾಮನ ಸಂದೇಶವಿದು. ನನ್ನ ಕಣ್ಣುಗಳು ತೆರೆಯಲ್ಪಟ್ಟಿವೆ. ನಾನು ನೋಡುವುದನ್ನೇ ಹೇಳುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ನಾನು ಈ ಸಂದೇಶವನ್ನು ದೇವರಿಂದ ಕೇಳಿದೆನು. ಸರ್ವಶಕ್ತನಾದ ದೇವರು ತೋರಿಸಿದವುಗಳನ್ನು ನೋಡಿದೆನು. ನಾನು ಸ್ಪಷ್ಟವಾಗಿ ನೋಡುವುದನ್ನು ದೀನತೆಯಿಂದ ತಿಳಿಸುತ್ತೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“ಯಾಕೋಬ್ಯರೇ, ನಿಮ್ಮ ಡೇರೆಗಳು ಬಹಳ ಸುಂದರವಾಗಿವೆ! ಇಸ್ರೇಲರೇ, ನೀವು ವಾಸಿಸುವ ಸ್ಥಳಗಳು ಬಹಳ ರಮ್ಯವಾಗಿವೆ! ");
INSERT INTO kan2010_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ನಿಮ್ಮ ಗುಡಾರಗಳು ಕಣಿವೆಗಳಂತೆ ಹರಡಿಕೊಂಡಿವೆ. ನಿಮ್ಮ ಗುಡಾರಗಳು ನದಿಯ ಬಳಿಯಿರುವ ತೋಟಗಳಂತಿವೆ. ನಿಮ್ಮ ಗುಡಾರಗಳು ಯೆಹೋವನು ನೆಟ್ಟ ಸುವಾಸನೆಯ ಪೊದೆಗಳಂತೆಯೂ ನೀರಿನ ಬಳಿಯಿರುವ ದೇವದಾರಿನ ಮರಗಳಂತೆಯೂ ಇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ನಿಮಗೆ ಯಾವಾಗಲೂ ಬೇಕಾದಷ್ಟು ನೀರು ಇರುವುದು; ನೀವು ಬಿತ್ತಿದ ಬೀಜಗಳು ಬೆಳೆಯಲು ಸಾಕಷ್ಟು ನೀರು ಇರುವುದು. ನಿಮ್ಮ ಅರಸನು ಆಗಾಗ್ ಎಂಬವನಿಗಿಂತಲೂ ದೊಡ್ಡವನಾಗಿದ್ದಾನೆ. ನಿಮ್ಮ ರಾಜ್ಯವು ಬಹಳ ಬಲಿಷ್ಠವಾಗಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“ದೇವರು ಆ ಜನರನ್ನು ಈಜಿಪ್ಟಿನಿಂದ ಕರೆದುಕೊಂಡು ಬಂದನು. ಅವರು ಕಾಡುಕೋಣದಂತೆ ಬಲಿಷ್ಠರಾಗಿದ್ದಾರೆ. ಅವರು ತಮ್ಮೆಲ್ಲಾ ಶತ್ರುಗಳನ್ನು ಸೋಲಿಸುವರು. ಅವರು ತಮ್ಮ ವೈರಿಗಳ ಮೂಳೆಗಳನ್ನು ಮುರಿದುಹಾಕುವರು. ಅವರ ಬಾಣಗಳು ಅವರ ವೈರಿಗಳನ್ನು ಕೊಲ್ಲುವವು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ಅವರು ಅಡಗಿಕೊಂಡಿರುವರು; ಇಸ್ರೇಲರು ಸಿಂಹದಂತೆಯೂ ಹೆಣ್ಣು ಸಿಂಹದಂತೆಯೂ ವಿಶ್ರಮಿಸುವರು. ಅದನ್ನು ಎಬ್ಬಿಸಲು ಯಾರಿಗೆ ಧೈರ್ಯವಿದೆ? ನಿಮ್ಮನ್ನು ಆಶೀರ್ವದಿಸುವವನು ಆಶೀರ್ವದಿಸಲ್ಪಡುವನು. ನಿಮ್ಮನ್ನು ಶಪಿಸುವವನು ಶಪಿಸಲ್ಪಡುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ಬಾಲಾಕನು ಬಿಳಾಮನ ಮೇಲೆ ಕೋಪಗೊಂಡು, ಚಪ್ಪಾಳೆ ಹೊಡೆದು, “ನನ್ನ ಶತ್ರುಗಳನ್ನು ಶಪಿಸುವುದಕ್ಕೆ ನಿನ್ನನ್ನು ಕರೆಸಿದೆನು. ಆದರೆ ನೀನು ಅವರನ್ನು ಮೂರು ಸಾರಿಯೂ ಆಶೀರ್ವದಿಸಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ಆದ್ದರಿಂದ ನೀನೀಗ ನೇರವಾಗಿ ಮನೆಗೆ ಹೋಗಿಬಿಡು. ನಿನಗೆ ಹೆಚ್ಚು ಹಣ ಕೊಡುವುದಾಗಿ ಆಲೋಚಿಸಿದ್ದೆನು. ಆದರೆ ನೀನು ನಿನ್ನ ಬಹುಮಾನವನ್ನು ಕಳೆದುಕೊಳ್ಳುವಂತೆ ಯೆಹೋವನು ಮಾಡಿದನು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","13","ಅದಕ್ಕೆ ಬಿಳಾಮನು ಬಾಲಾಕನಿಗೆ, “ಬಾಲಾಕನು, ಬೆಳ್ಳಿಬಂಗಾರಗಳಿಂದ ತುಂಬಿದ ತನ್ನ ಅರಮನೆಯನ್ನು ಕೊಟ್ಟರೂ ನಾನು ಯೆಹೋವನ ಆಜ್ಞೆಯನ್ನು ಮೀರಿ ನನಗೆ ಇಷ್ಟಬಂದಂತೆ ಕೆಟ್ಟದ್ದನ್ನಾಗಲಿ ಒಳ್ಳೆಯದನ್ನಾಗಲಿ ನಾನು ಮಾಡಲಾರೆನು; ಆದರೆ ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸುವುದನ್ನೇ ಮಾತಾಡುವೆನೆಂದು ನೀನು ನನ್ನ ಬಳಿಗೆ ಕಳುಹಿಸಿದ ದೂತರಿಗೆ ಹೇಳಲಿಲ್ಲವೇ? ");
INSERT INTO kan2010_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ಆಗಲಿ, ನಾನು ನನ್ನ ಸ್ವಜನರ ಬಳಿಗೆ ಹೋಗುತ್ತೇನೆ. ಆದರೆ ಮುಂದೆ ಆ ಜನರು ನಿನ್ನ ಜನರಿಗೆ ಏನು ಮಾಡುವರೋ ಅದನ್ನು ನಿನಗೆ ತಿಳಿಸುತ್ತೇನೆ, ಕೇಳು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ಆಗ ಬಿಳಾಮನು ಹೀಗೆಂದನು: “ಬೆಯೋರನ ಮಗನಾದ ಬಿಳಾಮನ ಸಂದೇಶವಿದು: ನಾನು ಸ್ಪಷ್ಟವಾಗಿ ನೋಡುತ್ತಿರುವ ಸಂಗತಿಗಳ ಬಗ್ಗೆ ಮಾತಾಡುತ್ತಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ನಾನು ದೇವರ ಮುಂದೆ ಅಡ್ಡಬೀಳುತ್ತೇನೆ, ಆದರೆ ನನ್ನ ಕಣ್ಣುಗಳು ಮುಚ್ಚಲ್ಪಟ್ಟಿಲ್ಲ. ನಾನು ದೇವರ ವಾಕ್ಯಗಳನ್ನು ಕೇಳುತ್ತಿದ್ದೇನೆ. ನಾನು ಮಹೋನ್ನತನಾದ ದೇವರಿಂದ ಜ್ಞಾನವನ್ನು ಹೊಂದಿಕೊಳ್ಳುತ್ತಿದ್ದೇನೆ. ಸರ್ವಶಕ್ತನಾದ ದೇವರು ತೋರಿಸುವ ಸಂಗತಿಗಳನ್ನು ನಾನು ನೋಡುತ್ತಿದ್ದೇನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“ಬರುತ್ತಿರುವ ಒಬ್ಬನನ್ನು ನೋಡುತ್ತಿದ್ದೇನೆ. ಆದರೆ ಈಗಲ್ಲ. ಬರುತ್ತಿರುವ ಒಬ್ಬನನ್ನು ನೋಡುತ್ತಿದ್ದೇನೆ, ಆದರೆ ಬೇಗನೆ ಅಲ್ಲ. ಯಾಕೋಬನ ವಂಶದಿಂದ ನಕ್ಷತ್ರವೊಂದು ಬರುವುದು. ಇಸ್ರೇಲರಿಂದ ಅರಸನೊಬ್ಬನು ಬರುವನು. ಅವನು ಮೋವಾಬ್ಯರ ತಲೆಯನ್ನು ಜಜ್ಜುವನು. ಆ ಅರಸನು ಶೇತನ ಪುತ್ರರೆಲ್ಲರ ತಲೆಗಳನ್ನು ಜಜ್ಜುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ಇಸ್ರೇಲರು ಬಲಿಷ್ಠರಾಗುವರು. ಅವರು ಎದೋಮ್ ದೇಶವನ್ನು ಪಡೆಯುವರು. ಅವರು ತಮ್ಮ ವೈರಿಯಾದ ಸೇಯೀರನ ದೇಶವನ್ನು ಪಡೆಯುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","“ಯಾಕೋಬನ ವಂಶದಿಂದ ಹೊಸ ಅರಸನೊಬ್ಬನು ಬರುವನು. ಆ ಅರಸನು ಆ ಪಟ್ಟಣದಲ್ಲಿ ಉಳಿದವರನ್ನು ನಾಶಮಾಡುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","“ತರುವಾಯ ಬಿಳಾಮನು ಅಮಾಲೇಕ್ಯರನ್ನು ನೋಡಿ ಹೀಗೆಂದನು: “ಅಮಾಲೇಕ್ಯರು ಎಲ್ಲಾ ಜನಾಂಗಗಳಲ್ಲಿ ಬಲಿಷ್ಠರು; ಅಮಾಲೇಕ್ಯರು ಎಲ್ಲಾ ಜನಾಂಗಗಳಲ್ಲಿ ಮೊದಲನೆಯವರು; ಆದರೆ ಕೊನೆಯಲ್ಲಿ ಅವರು ನಾಶವಾಗುವರು.” ");
INSERT INTO kan2010_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ಆಗ ಬಿಳಾಮನು ಕೇನ್ಯರನ್ನು ನೋಡಿ ಹೀಗೆಂದನು: “ನಿಮ್ಮ ಮನೆಯು ಬೆಟ್ಟದ ತುದಿಯಲ್ಲಿರುವ ಪಕ್ಷಿಯ ಗೂಡಿನಂತೆ ಸುರಕ್ಷಿತವಾಗಿದೆಯೆಂದು ನೀವು ನಂಬುತ್ತೀರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ಆದರೆ ಕೇನ್ಯರೇ, ಅಶ್ಶೂರ್ಯವು ನಿಮ್ಮನ್ನು ಸೆರೆ ಒಯ್ಯುವಾಗ ಅದು ನಾಶವಾಗುವುದು.” ");
INSERT INTO kan2010_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ಆಗ ಬಿಳಾಮನು ಹೀಗೆಂದನು: “ದೇವರು ಇದನ್ನು ಮಾಡುವಾಗ ಯಾರೂ ಉಳಿಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ಸೈಪ್ರಸ್‌ನ ತೀರಗಳಿಂದ ಹಡಗುಗಳು ಬರುವವು. ಅವರು ಅಶ್ಶೂರ್ಯವನ್ನೂ ಏಬೆರವನ್ನೂ ಸೋಲಿಸುವರು; ಆದರೆ ಅವರು ಸಹ ನಾಶವಾಗುವರು.” ");
INSERT INTO kan2010_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ಆಗ ಬಿಳಾಮನು ಎದ್ದು ತನ್ನ ಸ್ಥಳಕ್ಕೆ ಹಿಂತಿರುಗಿ ಹೋದನು. ಬಾಲಾಕನೂ ಸಹ ಹೊರಟುಹೋದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ಇಸ್ರೇಲರು ಅಖಾಸಿಯದ ಸಮೀಪದಲ್ಲಿ ಇಳಿದುಕೊಂಡಿದ್ದರು. ಅವರು ಅಲ್ಲಿದ್ದಾಗ ಮೋವಾಬ್ ಸ್ತ್ರೀಯರೊಡನೆ ಲೈಂಗಿಕ ಪಾಪಗಳನ್ನು ಮಾಡತೊಡಗಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","3","ಮೋವಾಬ್ ಸ್ತ್ರೀಯರು ತಮ್ಮ ಸುಳ್ಳುದೇವರಿಗೆ ಮಾಡಿದ ಔತಣಯಜ್ಞಗಳಿಗೆ ಅವರನ್ನು ಆಮಂತ್ರಿಸಿದರು. ಆದ್ದರಿಂದ ಇಸ್ರೇಲರು ಅವರ ಯಜ್ಞಗಳ ಆಹಾರವನ್ನು ತಿಂದರು ಮತ್ತು ಅವರ ದೇವರನ್ನು ಪೂಜಿಸಿದರು. ಈ ರೀತಿ ಇಸ್ರೇಲರು ಸುಳ್ಳುದೇವರಾದ ಪೆಗೋರ್ ಬಾಳನ ಭಕ್ತರಾದರು. ಹೀಗಾಗಿ ಯೆಹೋವನು ಅವರ ಮೇಲೆ ಬಹಳವಾಗಿ ಕೋಪಗೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನೀನು ಜನರ ನಾಯಕರನ್ನೆಲ್ಲ ಬಂಧಿಸಿ ಯೆಹೋವನ ಮುಂದೆ ಬಹಿರಂಗವಾಗಿ ಅವರನ್ನು ನೇಣುಗಂಬಕ್ಕೆ ಏರಿಸು. ಹೀಗೆ ಯೆಹೋವನ ಕೋಪಾಗ್ನಿಯನ್ನು ಇಸ್ರೇಲರಿಂದ ತೊಲಗಿಸಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ಆದಕಾರಣ ಮೋಶೆ ಇಸ್ರೇಲರ ನ್ಯಾಯಾಧಿಪತಿಗಳಿಗೆ, “ನಿಮ್ಮಲ್ಲಿ ಪ್ರತಿಯೊಬ್ಬನು, ಸುಳ್ಳುದೇವರಾದ ಪೆಗೋರದ ಬಾಳನನ್ನು ಆರಾಧಿಸುವಂತೆ ಜನರನ್ನೂ ಪ್ರೋತ್ಸಾಹಿಸಿದವರನ್ನು ಕಂಡುಹಿಡಿದು ನೀವು ಅವರನ್ನು ಕೊಲ್ಲಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ಆಗ ಮೋಶೆ ಮತ್ತು ಇಡೀ ಇಸ್ರೇಲ್ ಸಮುದಾಯವು ಒಟ್ಟಾಗಿ ಸೇರಿಬಂದು ದೇವದರ್ಶನಗುಡಾರದ ಬಾಗಿಲಲ್ಲಿ ಅಳುತ್ತಿದ್ದರು. ಅಷ್ಟರಲ್ಲಿ ಇಸ್ರೇಲ್ ಮನುಷ್ಯನೊಬ್ಬನು ಮಿದ್ಯಾನ್ ಸ್ತ್ರೀಯೊಬ್ಬಳನ್ನು ತನ್ನ ಸಂಬಂಧಿಕರ ಬಳಿಗೆ ಕರೆದುಕೊಂಡು ಬಂದನು. ಮೋಶೆಯ ಮತ್ತು ಎಲ್ಲಾ ಜನರ ಕಣ್ಣೆದುರಿನಲ್ಲೇ ಅವನು ಹೀಗೆ ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ಕೂಡಲೇ ಯಾಜಕನಾಗಿದ್ದ ಆರೋನನ ಮೊಮ್ಮಗನೂ ಎಲ್ಲಾಜಾರನ ಮಗನೂ ಆದ ಫೀನೆಹಾಸನು ಸಭೆಯ ನಡುವೆಯಿಂದೆದ್ದು ಈಟಿಯನ್ನು ತೆಗೆದುಕೊಂಡು ");
INSERT INTO kan2010_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ಆ ಇಸ್ರೇಲನನ್ನು ಹಿಂಬಾಲಿಸಿ ಮಲಗುವ ಕೋಣೆಯೊಳಗೆ ಹೋಗಿ ಅವನನ್ನೂ ಆ ಮಿದ್ಯಾನ್ ಸ್ತ್ರೀಯನ್ನೂ ಒಂದೇ ಏಟಿನಿಂದ ಹೊಟ್ಟೆಯಲ್ಲಿ ತಿವಿದು ಕೊಂದನು. ಆಗ ಇಸ್ರೇಲರಿಗುಂಟಾದ ವ್ಯಾಧಿ ನಿಂತುಹೋಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ಆ ವ್ಯಾಧಿಯಿಂದ ಒಟ್ಟು 24,000 ಜನರು ಸತ್ತುಹೋದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","11","ಆಗ ಯೆಹೋವನು ಮೋಶೆಗೆ, “ನಾನೇ ನನ್ನ ಗೌರವವನ್ನು ಕಾಪಾಡಿಕೊಳ್ಳುವ ಮೇರೆಗೆ ಯಾಜಕನಾಗಿದ್ದ ಆರೋನನ ಮೊಮ್ಮಗನೂ ಎಲ್ಲಾಜಾರನ ಮಗನೂ ಆಗಿರುವ ಫೀನೆಹಾಸನು ನನ್ನ ಗೌರವವನ್ನು ಕಾಪಾಡಿ ಇಸ್ರೇಲರ ಮೇಲಿದ್ದ ನನ್ನ ಕೋಪವನ್ನು ತೊಲಗಿಸಿದ್ದಾನೆ. ಹೀಗಿರುವುದರಿಂದ ನಾನು ನನ್ನ ಗೌರವವನ್ನು ಕಾಪಾಡಿಕೊಳ್ಳುವುದಕ್ಕಾಗಿ ಇಸ್ರೇಲರನ್ನು ನಿರ್ಮೂಲ ಮಾಡುವ ಅಗತ್ಯವಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ಆದಕಾರಣ ನಾನು ಅವನ ಸಂಗಡ ಸಮಾಧಾನದ ಒಡಂಬಡಿಕೆಯನ್ನು ಮಾಡಿಕೊಳ್ಳುತ್ತೇನೆಂದು ಎಲ್ಲರಿಗೂ ತಿಳಿಸು; ");
INSERT INTO kan2010_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ಆ ಒಡಂಬಡಿಕೆಯ ಪ್ರಕಾರವಾಗಿ ಅವನಿಗೂ ಅವನ ತರುವಾಯ ಅವನ ಸಂತತಿಯವರಿಗೂ ಯಾಜಕತ್ವವು ಶಾಶ್ವತವಾಗಿಯೇ ಇರುವುದೆಂದು ಮಾತುಕೊಡುತ್ತೇನೆ. ಅವನು ತನ್ನ ದೇವರ ಗೌರವವನ್ನು ಕಾಪಾಡಿ ಇಸ್ರೇಲರಿಗೋಸ್ಕರ ದೋಷಪರಿಹಾರವನ್ನು ಮಾಡಿದ್ದರಿಂದ ನಾನು ಅವನಿಗೆ ಈ ಮಾತನ್ನು ಕೊಟ್ಟಿದ್ದೇನೆ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ಆ ಮಿದ್ಯಾನ್ ಸ್ತ್ರೀಯೊಡನೆ ಕೊಲ್ಲಲ್ಪಟ್ಟವನು ಸಿಮೆಯೋನ್ ಕುಲದವರಲ್ಲಿ ಗೋತ್ರಪ್ರಧಾನನಾಗಿದ್ದ ಜಿಮ್ರೀ. ಇವನು ಸಾಲೂ ಎಂಬವನ ಮಗ. ");
INSERT INTO kan2010_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ಹತಳಾದ ಮಿದ್ಯಾನ್ ಸ್ತ್ರೀಯ ಹೆಸರು ಕೊಜ್ಬೀ. ಅವಳು ಮಿದ್ಯಾನ್ಯರಲ್ಲಿ ಗೋತ್ರ ಪ್ರಧಾನನಾದ ಜೂರ್ ಎಂಬವನ ಮಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ನೀನು ಮಿದ್ಯಾನ್ಯರನ್ನು ವೈರಿಗಳೆಂದು ಪರಿಗಣಿಸಿರುವುದರಿಂದ ಅವರನ್ನು ಸಂಹರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ಯಾಕೆಂದರೆ ಅವರು ನಿಮ್ಮನ್ನು ವೈರಿಗಳೆಂದು ಪರಿಗಣಿಸಿ ಪೆಗೋರನ ಘಟನೆಯಲ್ಲಿ ನಿಮ್ಮನ್ನು ಮೋಸಗೊಳಿಸಿದರು. ಮಿದ್ಯಾನಿನ ನಾಯಕನೊಬ್ಬನ ಮಗಳೂ ತಮ್ಮ ರಕ್ತಸಂಬಂಧಿಯೂ ಆಗಿದ್ದ ಕೊಜ್ಬೀಯ ವಿಷಯದಲ್ಲಿಯೂ ಅವರು ನಿಮ್ಮನ್ನು ಮೋಸಗೊಳಿಸಿದರು. ಪೆಗೋರಿನ ಘಟನೆಯಿಂದ ಇಸ್ರೇಲರಿಗೆ ಕಾಯಿಲೆ ಉಂಟಾದಾಗ ಆ ಸ್ತ್ರೀಯೂ ಸತ್ತಳು.” ");
INSERT INTO kan2010_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ಆ ಘೋರ ವ್ಯಾಧಿ ನಿಂತಮೇಲೆ ಯೆಹೋವನು ಮೋಶೆಗೂ ಯಾಜಕ ಆರೋನನ ಮಗನಾದ ಎಲ್ಲಾಜಾರನಿಗೂ, ");
INSERT INTO kan2010_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ನೀವು ಇಸ್ರೇಲರ ಸರ್ವಸಮೂಹದವರಲ್ಲಿ ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚಾದ ವಯಸುಳ್ಳವರನ್ನು ಮತ್ತು ಇಸ್ರೇಲ್ ಸೈನ್ಯದಲ್ಲಿ ಸೇವೆಮಾಡಲು ಶಕ್ತರಾಗಿರುವ ಗಂಡಸರನ್ನು ಕುಟುಂಬ ಕುಟುಂಬಗಳ ಪ್ರಕಾರ ಲೆಕ್ಕಿಸಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ಈ ಸಮಯದಲ್ಲಿ ಜನರು ಮೋವಾಬಿನ ಬಯಲುಗಳಲ್ಲಿ ತಂಗಿದ್ದರು. ಇದು ಜೆರಿಕೊ ಪಟ್ಟಣದ ಆಚೆಕಡೆಯಲ್ಲಿರುವ ಜೋರ್ಡನ್ ನದಿಯ ಸಮೀಪದಲ್ಲಿತ್ತು. ಮೋಶೆ ಮತ್ತು ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ಜನರೊಡನೆ ಮಾತಾಡಿ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“ಮೋಶೆ ಮತ್ತು ಇಸ್ರೇಲರು ಈಜಿಪ್ಟಿನಿಂದ ಹೊರಬಂದಾಗ ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಂತೆಯೇ ನೀವು ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚು ವಯಸ್ಸಾದ ಗಂಡಸರನ್ನು ಲೆಕ್ಕಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ರೂಬೇನ್ ಕುಲದ ಜನರು: (ರೂಬೇನನು ಇಸ್ರೇಲನ ಚೊಚ್ಚಲ ಮಗನು.) ಹನೋಕನ ಕುಟುಂಬದವರಾದ ಹನೋಕ್ಯರು; ಪಲ್ಲೂವಿನ ಕುಟುಂಬದವರಾದ ಪಲ್ಲೂವಿನವರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ಹೆಚ್ರೋನನ ಕುಟುಂಬದವರಾದ ಹೆಚ್ರೋನ್ಯರು; ಕರ್ಮೀಯ ಕುಟುಂಬದವರಾದ ಕರ್ಮೀಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ರೂಬೇನ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ 43,730. ");
INSERT INTO kan2010_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ಪಲ್ಲೂವಿನ ಮಗನು ಎಲೀಯಾಬ್. ");
INSERT INTO kan2010_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ಎಲೀಯಾಬನ ಗಂಡುಮಕ್ಕಳು: ನೆಮೂವೇಲ್, ದಾತಾನ್, ಅಬೀರಾಮ್ ಎಂಬವರೆ. ಕೋರಹನ ಗುಂಪಿನವರು ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ದಂಗೆಯೆದ್ದ ಕಾಲದಲ್ಲಿ ಅವರೊಳಗೆ ಸೇರಿಕೊಂಡು ಮೋಶೆ ಆರೋನರಿಗೆ ವಿರೋಧವಾಗಿ ದಂಗೆ ಎದ್ದವರೇ ದಾತಾನ್ ಮತ್ತು ಅಬೀರಾಮ್. ");
INSERT INTO kan2010_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ಭೂಮಿಯು ಬಾಯ್ದೆರೆದು ಅವರನ್ನೂ ಕೋರಹನನ್ನೂ ನುಂಗಿಬಿಟ್ಟಿತು ಮತ್ತು ಬೆಂಕಿಯು ಆ ಗುಂಪಿನವರಲ್ಲಿ ಇತರ ಇನ್ನೂರೈವತ್ತು ಮಂದಿಯನ್ನು ದಹಿಸಿ ಇಸ್ರೇಲರಿಗೆ ಎಚ್ಚರಿಕೆಯುಂಟಾಗುವ ಹಾಗೆ ಮಾಡಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ಆ ಗುಂಪಿನವರೆಲ್ಲರು ಸತ್ತರೂ ಕೋರಹನ ಮಕ್ಕಳು ಆ ಕಾಲದಲ್ಲಿ ಸಾಯಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ಸಿಮೆಯೋನ್ ಕುಲದ ಕುಟುಂಬಗಳು: ನೆಮೂವೇಲನ ಕುಟುಂಬದವರಾದ ನೆಮೂವೇಲ್ಯರು; ಯಾಮೀನನ ಕುಟುಂಬದವರಾದ ಯಾಮೀನ್ಯರು; ಯಾಕೀನನ ಕುಟುಂಬದವರಾದ ಯಾಕೀನ್ಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ಜೆರಹನ ಕುಟುಂಬದವರಾದ ಜೆರಹಿಯರು; ಸೌಲನ ಕುಟುಂಬದವರಾದ ಸೌಲ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ಸಿಮೆಯೋನ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ 22,200. ");
INSERT INTO kan2010_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ಗಾದ್ ಕುಲದ ಕುಟುಂಬಗಳು: ಚೆಫೋನನ ಕುಟುಂಬದವರಾದ ಚೆಫೋನ್ಯರು; ಹಗ್ಗೀಯನ ಕುಟುಂಬದವರಾದ ಹಗ್ಗೀಯರು; ಶೂನೀಯ ಕುಟುಂಬದವರಾದ ಶೂನೀಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ಒಜ್ನೀಯ ಕುಟುಂಬದವರಾದ ಒಜ್ನೀಯರು; ಏರೀಯ ಕುಟುಂಬದವರಾದ ಏರೀಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ಅರೋದನ ಕುಟುಂಬದವರಾದ ಆರೋದ್ಯರು; ಅರೇಲೀಯ ಕುಟುಂಬದವರಾದ ಅರೇಲೀಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ಗಾದ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ 40,500. ");
INSERT INTO kan2010_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","20","ಯೆಹೂದ ಕುಲದ ಕುಟುಂಬಗಳು: ಶೇಲಹನ ಕುಟುಂಬದವರಾದ ಶೇಲಾನ್ಯರು; ಪೆರೆಚನ ಕುಟುಂಬದವರಾದ ಪೆರೆಚ್ಯರು; ಜೆರಹನ ಕುಟುಂಬದವರಾದ ಜೆರಹಿಯರು. (ಯೆಹೂದನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಾದ ಏರ್ ಮತ್ತು ಓನಾನನು ಕಾನಾನ್‌ನಲ್ಲಿ ಸತ್ತರು.) ");
INSERT INTO kan2010_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ಪೆರೆಚನ ಕುಟುಂಬಗಳು: ಹೆಚ್ರೋನನ ಕುಟುಂಬದವರಾದ ಹೆಚ್ರೋನ್ಯರು, ಹಾಮೂಲನ ಕುಟುಂಬದವರಾದ ಹಾಮೂಲ್ಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ಯೆಹೂದ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ 76,500. ");
INSERT INTO kan2010_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ಇಸ್ಸಾಕಾರನ ಕುಟುಂಬಗಳು: ತೋಲನ ಕುಟುಂಬದವರಾದ ತೋಲಾಯರು; ಪುವ್ವನ ಕುಟುಂಬದವರಾದ ಪೂನ್ಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ಯಾಶೂಬನ ಕುಟುಂಬದವರಾದ ಯಾಶೂಬ್ಯರು; ಶಿಮ್ರೋನನ ಕುಟುಂಬದವರಾದ ಶಿಮ್ರೋನ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ಇಸ್ಸಾಕಾರ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ 64,300 ಮಂದಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ಜೆಬುಲೂನ್ ಕುಲದ ಕುಟುಂಬಗಳು: ಸೆರೆದನ ಕುಟುಂಬದವರಾದ ಸೆರೆದ್ಯರು; ಏಲೋನನ ಕುಟುಂಬದವರಾದ ಏಲೋನ್ಯರು; ಯಹಲೇಲನ ಕುಟುಂಬದವರಾದ ಯಹಲೇಲ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ಜೆಬುಲೂನ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ 60,500 ");
INSERT INTO kan2010_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ಯೋಸೇಫನ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳು: ಮನಸ್ಸೆ ಮತ್ತು ಎಫ್ರಾಯೀಮ್. ");
INSERT INTO kan2010_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ಮನಸ್ಸೆ ಕುಲದ ಕುಟುಂಬಗಳು: ಮಾಕೀರನ ಕುಟುಂಬದವರಾದ ಮಾಕೀರ್ಯರು; ಮಾಕೀರನ ಮಗನಾದ ಗಿಲ್ಯಾದನ ಕುಟುಂಬದವರಾದ ಗಿಲ್ಯಾದ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ಗಿಲ್ಯಾದನ ಕುಟುಂಬದವರು: ಈಯೆಜೆರನ ಕುಟುಂಬದವರಾದ ಈಯೆಜೆರ್ಯರು; ಹೇಲೆಕನ ಕುಟುಂಬದವರಾದ ಹೇಲೆಕ್ಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ಅಸ್ರೀಯೇಲನ ಕುಟುಂಬದವರಾದ ಅಸ್ರೀಯೇಲ್ಯರು; ಶೆಕೆಮನ ಕುಟುಂಬದವರಾದ ಶೆಕೆಮ್ಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ಶೆಮೀದಾಯನ ಕುಟುಂಬದವರಾದ ಶೆಮೀದಾಯರು; ಹೇಫೆರನ ಕುಟುಂಬದವರಾದ ಹೇಫೆರ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ಹೇಫೆರನ ಮಗನಾದ ಚಲ್ಫಹಾದನಿಗೆ ಹೆಣ್ಣುಮಕ್ಕಳು ಮಾತ್ರ ಹುಟ್ಟಿದರು. ಗಂಡುಮಕ್ಕಳು ಹುಟ್ಟಲಿಲ್ಲ. ಅವನ ಹೆಣ್ಣುಮಕ್ಕಳ ಹೆಸರು: ಮಹ್ಲಾ, ನೋವಾ, ಹೊಗ್ಲಾ, ಮಿಲ್ಕಾ, ತಿರ್ಚಾ. ");
INSERT INTO kan2010_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ಮನಸ್ಸೆ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ 52,700. ");
INSERT INTO kan2010_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ಎಫ್ರಾಯೀಮ್ ಕುಲದ ಕುಟುಂಬಗಳು: ಶೂತೆಲಹನ ಕುಟುಂಬದವರಾದ ಶೂತೆಲಹ್ಯರು; ಬೆಕೆರನ ಕುಟುಂಬದವರಾದ ಬೆಕೆರ್ಯರು; ತಹನನ ಕುಟುಂಬದವರಾದ ತಹನಿಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ಏರಾನನು ಶೂತೆಲಹನ ಕುಟುಂಬದವನು; ಏರಾನನ ಕುಟುಂಬದವರಾದ ಏರಾನ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ಎಫ್ರಾಯೀಮ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟ ಗಂಡಸರ ಒಟ್ಟು ಸಂಖ್ಯೆ 32,500. ಇದೇ ಯೋಸೇಫನ ಕುಲದ ಕುಟುಂಬಗಳ ವಿವರ. ");
INSERT INTO kan2010_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ಬೆನ್ಯಾಮೀನ್ ಕುಲದ ಕುಟುಂಬಗಳು: ಬೆಲಗನ ಕುಟುಂಬದವರಾದ ಬೆಲಗ್ಯರು; ಅಷ್ಬೇಲನ ಕುಟುಂಬದವರಾದ ಅಷ್ಬೇಲ್ಯರು; ಅಹೀರಾಮನ ಕುಟುಂಬದವರಾದ ಅಹೀರಾಮ್ಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ಶೂಫಾಮನ ಕುಟುಂಬದವರಾದ ಶೂಫಾಮ್ಯರು; ಹೂಫಾಮನ ಕುಟುಂಬದವರಾದ ಹೂಫಾಮ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ಬೆಲಗನಿಗೆ ಅರ್ದ್ ಮತ್ತು ನಾಮಾನ್ ಎಂಬ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳಿದ್ದರು. ಬೆಲಗನ ಕುಟುಂಬಗಳು: ಅರ್ದನ ಕುಟುಂಬದವರಾದ ಅರ್ದ್ಯರು; ನಾಮಾನನ ಕುಟುಂಬದವರಾದ ನಾಮಾನ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ಬೆನ್ಯಾಮೀನ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 45,600. ");
INSERT INTO kan2010_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ದಾನ್ ಕುಲದ ಕುಟುಂಬಗಳು: ಶೂಹಾಮನ ಕುಟುಂಬದವರಾದ ಶೂಹಾಮ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ದಾನ್ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 64,400. ");
INSERT INTO kan2010_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ಆಶೇರ್ ಕುಲದ ಕುಟುಂಬಗಳು: ಇಮ್ನಾಹನ ಕುಟುಂಬದವರಾದ ಇಮ್ನಾಹ್ಯರು; ಇಷ್ವೀಯ ಕುಟುಂಬದವರಾದ ಇಷ್ವೀಯರು; ಬೆರೀಯನ ಕುಟುಂಬದವರಾದ ಬೆರೀಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ಬೆರೀಯನ ಮಕ್ಕಳ ಕುಟುಂಬಗಳು: ಹೇಬೆರನ ಕುಟುಂಬದವರಾದ ಹೇಬೆರ್ಯರು; ಮಲ್ಕೀಯೇಲನ ಕುಟುಂಬದವರಾದ ಮಲ್ಕೀಯೇಲ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(ಆಶೇರನಿಗೆ ಸೆರಹ ಎಂಬ ಮಗಳೂ ಇದ್ದಳು.) ");
INSERT INTO kan2010_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ಆಶೇರನ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 53,400. ");
INSERT INTO kan2010_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ನಫ್ತಾಲಿಯ ಕುಲದ ಕುಟುಂಬಗಳು: ಯಹಚೇಲನ ಕುಟುಂಬದವರಾದ ಯಹಚೇಲ್ಯರು; ಗೂನೀಯ ಕುಟುಂಬದವರಾದ ಗೂನೀಯರು; ");
INSERT INTO kan2010_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ಯೇಚೆರನ ಕುಟುಂಬದವರಾದ ಯೇಚೆರ್ಯರು; ಶಿಲ್ಲೇಮನ ಕುಟುಂಬದವರಾದ ಶಿಲ್ಲೇಮ್ಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ನಫ್ತಾಲಿಯ ಕುಲದವರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 45,400. ");
INSERT INTO kan2010_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ಹೀಗೆ ಇಸ್ರೇಲರಲ್ಲಿ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರ ಒಟ್ಟು ಸಂಖ್ಯೆ 6,01,730. ");
INSERT INTO kan2010_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ನೀವು ಈ ಕುಲಗಳಿಗೆ ಅವರವರ ಸಂಖ್ಯೆಯ ಪ್ರಕಾರ ಆ ದೇಶವನ್ನು ಹಂಚಿಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ಹೆಚ್ಚು ಮಂದಿಯುಳ್ಳ ಕುಲಕ್ಕೆ ಹೆಚ್ಚಾಗಿಯೂ ಕಡಿಮೆಯಾದ ಕುಲಕ್ಕೆ ಕಡಿಮೆಯಾಗಿಯೂ ಕೊಡಬೇಕು. ಲೆಕ್ಕಿಸಿದ ಸಂಖ್ಯೆಯ ಪ್ರಕಾರವೇ ಪ್ರತಿಯೊಂದು ಕುಲಕ್ಕೆ ಭೂಮಿಯನ್ನು ಸ್ವಾಸ್ತ್ಯಕ್ಕಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ಪ್ರತಿಯೊಂದು ಕುಲದ ಪಿತೃವಿನ ಹೆಸರನ್ನು ಬರೆದು ಚೀಟುಹಾಕಿ ಆಯಾ ಕುಲಕ್ಕೆ ಸ್ವಾಸ್ತ್ಯವನ್ನು ಗೊತ್ತುಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ಕುಲವು ದೊಡ್ಡದಾಗಿರಲಿ ಚಿಕ್ಕದಾಗಿರಲಿ ಚೀಟುಬಂದ ಪ್ರಕಾರವೇ ಸ್ವಾಸ್ತ್ಯವನ್ನು ಗೊತ್ತುಪಡಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ಲೇವಿಯರೊಳಗಿನ ಕುಲಗಳನ್ನು ಲೆಕ್ಕಿಸಲಾಗಿ, ಅವರಲ್ಲಿನ ಕುಟುಂಬಗಳು: ಗೇರ್ಷೋನನ ಕುಟುಂಬದವರಾದ ಗೇರ್ಷೋನ್ಯರು; ಕೆಹಾತನ ಕುಟುಂಬದವರಾದ ಕೆಹಾತ್ಯರು; ಮೆರಾರೀಯ ಕುಟುಂಬದವರಾದ ಮೆರಾರೀಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ಲೇವಿ ಕುಲದವರ ಕುಟುಂಬಗಳು: ಲಿಬ್ನೀಯರ ಕುಟುಂಬ, ಹೆಬ್ರೋನ್ಯರ ಕುಟುಂಬ, ಮಹ್ಲೀಯರ ಕುಟುಂಬ, ಮೂಷೀಯರ ಕುಟುಂಬ, ಕೋರಹಿಯರ ಕುಟುಂಬ. ");
INSERT INTO kan2010_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ಅಮ್ರಾಮನು ಕೆಹಾತನ ಕುಲಕ್ಕೆ ಸೇರಿದವನು. ಅಮ್ರಾಮನ ಹೆಂಡತಿಯ ಹೆಸರು ಯೋಕೆಬೆದಳು. ಅವಳು ಲೇವಿ ಕುಟುಂಬದವಳು. ಅವಳು ಈಜಿಪ್ಟಿನಲ್ಲಿ ಹುಟ್ಟಿದಳು. ಅಮ್ರಾಮ್ ಮತ್ತು ಯೋಕೆಬೆದಳಿಗೆ ಇಬ್ಬರು ಗಂಡುಮಕ್ಕಳು ಹುಟ್ಟಿದರು. ಅವರು ಯಾರೆಂದರೆ ಆರೋನ ಮತ್ತು ಮೋಶೆ. ಅವರಿಗೆ ಒಬ್ಬ ಮಗಳೂ ಇದ್ದಳು. ಅವಳ ಹೆಸರು ಮಿರ್ಯಾಮಳು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ಆರೋನನು ನಾದ್ವಾ್, ಅಬೀಹೂ, ಎಲ್ಲಾಜಾರ್, ಈತಾಮಾರ್ ಇವರ ತಂದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ಆದರೆ ನಾದ್ವಾ್ ಮತ್ತು ಅಬೀಹೂ ಸತ್ತರು. ಯೆಹೋವನು ತಿಳಿಸದ ಹೊಸ ಬೆಂಕಿಯಿಂದ ಧೂಪವನ್ನು ಯೆಹೋವನ ಮುಂದೆ ಅರ್ಪಿಸಿದ್ದರಿಂದ ಅವರು ಸತ್ತರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ಲೇವಿ ಕುಟುಂಬಗಳಲ್ಲಿ ಒಂದು ತಿಂಗಳು ಮೊದಲುಗೊಂಡು ಹೆಚ್ಚು ವಯಸ್ಸಾದ ಪುರುಷರ ಒಟ್ಟು ಸಂಖ್ಯೆ 23,000. ಆದರೆ ಈ ಜನರು ಇತರ ಇಸ್ರೇಲರೊಡನೆ ಲೆಕ್ಕಿಸಲ್ಪಡಲಿಲ್ಲ. ಯೆಹೋವನು ಬೇರೆ ಇಸ್ರೇಲರಿಗೆ ಕೊಟ್ಟ ಸ್ವಾಸ್ತ್ಯದಲ್ಲಿ ಅವರಿಗೆ ಪಾಲು ಸಿಕ್ಕಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ಮೋಶೆ ಮತ್ತು ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ಈ ಜನರನ್ನೆಲ್ಲಾ ಲೆಕ್ಕಿಸಿದರು. ಇಸ್ರೇಲರು ಜೋರ್ಡನ್ ಹೊಳೆಯ ತೀರದಲ್ಲಿ ಜೆರಿಕೊ ಪಟ್ಟಣದ ಆಚೆಯಲ್ಲಿ ಮೋವಾಬ್ಯರ ಬಯಲುಗಳಲ್ಲಿದ್ದಾಗ ಇವರನ್ನು ಲೆಕ್ಕಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ಮೋಶೆಯೂ ಯಾಜಕನಾದ ಆರೋನನೂ ಸೀನಾಯಿ ಮರುಭೂಮಿಯಲ್ಲಿ ಇಸ್ರೇಲರ ಸಂಖ್ಯೆಯನ್ನು ನೋಡಿದಾಗ ಲೆಕ್ಕಿಸಲ್ಪಟ್ಟವರೊಳಗೆ ಒಬ್ಬರಾದರೂ ಇವರಲ್ಲಿ ಇರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ಯೆಹೋವನು ಅವರೆಲ್ಲರೂ ಮರುಭೂಮಿಯಲ್ಲಿಯೇ ಸಾಯುವರೆಂದು ಹೇಳಿದ್ದನು. ಆದ್ದರಿಂದ ಯೆಫುನ್ನೆಯ ಮಗನಾದ ಕಾಲೇಬ್ ಮತ್ತು ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವ ಇವರಿಬ್ಬರ ಹೊರತಾಗಿ ಅವರಲ್ಲಿ ಯಾರೂ ಉಳಿಯಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ಚಲ್ಪಹಾದನು ಹೇಫೆರನ ಮಗನು. ಹೇಫೆರನು ಗಿಲ್ಯಾದನ ಮಗನು. ಗಿಲ್ಯಾದನು ಮಾಕೀರನ ಮಗನು. ಮಾಕೀರನು ಮನಸ್ಸೆಯ ಮಗನು. ಮನಸ್ಸೆಯು ಯೋಸೇಫನ ಮಗನು. ಚಲ್ಪಹಾದನಿಗೆ ಐದುಮಂದಿ ಹೆಣ್ಣುಮಕ್ಕಳಿದ್ದರು. ಅವರು ಯಾರೆಂದರೆ: ಮಹ್ಲಾ, ನೋವಾ, ಹೊಗ್ಲಾ, ಮಿಲ್ಕಾ ಮತ್ತು ತಿರ್ಚಾ. ");
INSERT INTO kan2010_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ಈ ಐದುಮಂದಿ ಸ್ತ್ರೀಯರು ದೇವದರ್ಶನಗುಡಾರದ ಪ್ರವೇಶದ್ವಾರದ ಬಳಿಗೆ ಹೋಗಿ ಮೋಶೆಯ, ಮಹಾಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ, ನಾಯಕರ ಮತ್ತು ಎಲ್ಲಾ ಇಸ್ರೇಲರ ಮುಂದೆ ನಿಂತರು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","ಈ ಐದು ಹೆಣ್ಣುಮಕ್ಕಳು, “ನಮ್ಮ ತಂದೆ ಮರುಭೂಮಿಯಲ್ಲಿ ಸತ್ತುಹೋದನು. ಅವನು ಕೋರಹನ ಜೊತೆಯಲ್ಲಿ ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ತಿರುಗಿ ಬಿದ್ದವರಲ್ಲಿ ಸೇರಿದವನಲ್ಲ. ನಮ್ಮ ತಂದೆಯು ತನ್ನ ಪಾಪದ ಫಲವಾಗಿ ಸತ್ತನು. ಅವನಿಗೆ ಗಂಡುಮಕ್ಕಳಿರಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ನಮ್ಮ ತಂದೆಗೆ ಗಂಡುಮಗನಿಲ್ಲದ ಮಾತ್ರದಿಂದ ಅವನ ಹೆಸರನ್ನು ಅವನ ಕುಲದವರ ಮಧ್ಯದಿಂದ ತೆಗೆಯುವುದು ನ್ಯಾಯವೋ? ನಮ್ಮ ತಂದೆಯ ಸಂಬಂಧಿಕರೊಡನೆ ನಮಗೂ ಸ್ವಾಸ್ತ್ಯವನ್ನು ಕೊಡು” ಎಂದು ಹೇಳಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ಮೋಶೆಯು ಇದರ ವಿಷಯದಲ್ಲಿ ತಾನು ಏನು ಮಾಡಬೇಕೆಂದು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ವಿಚಾರಿಸಲಾಗಿ, ");
INSERT INTO kan2010_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ಯೆಹೋವನು ಅವನಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ಚಲ್ಪಹಾದನ ಹೆಣ್ಣುಮಕ್ಕಳು ಹೇಳುವುದು ನ್ಯಾಯವಾಗಿದೆ. ಅವರ ತಂದೆಯ ಸಂಬಂಧಿಕರೊಡನೆ ಅವರಿಗೂ ನೀನು ಸ್ವಾಸ್ತ್ಯವನ್ನು ಕೊಡಬೇಕು. ಅವರ ತಂದೆಯ ಸ್ವಾಸ್ತ್ಯವನ್ನು ನೀನು ಅವರಿಗೆ ವರ್ಗಾವಣೆ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“ಮತ್ತು ನೀನು ಇಸ್ರೇಲರಿಗೆ ಹೀಗೆ ಅಪ್ಪಣೆ ಕೊಡಬೇಕು: ‘ಒಬ್ಬ ಮನುಷ್ಯನು ಮಗನಿಲ್ಲದೆ ಸತ್ತರೆ, ನೀವು ಅವನ ಸ್ವಾಸ್ತ್ಯವನ್ನು ಅವನ ಮಗಳಿಗೆ ವರ್ಗಾವಣೆ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","10","ಮಗಳು ಇಲ್ಲದ ಪಕ್ಷಕ್ಕೆ ಅವನ ಸ್ವಾಸ್ತ್ಯವನ್ನು ಅವನ ಅಣ್ಣತಮ್ಮಂದಿರಿಗೆ ಕೊಡಬೇಕು. ಅಣ್ಣತಮ್ಮಂದಿರು ಇಲ್ಲದ ಪಕ್ಷಕ್ಕೆ ಅವನ ಸ್ವಾಸ್ತ್ಯವನ್ನು ಅವನ ತಂದೆಯ ಸಹೋದರರಿಗೆ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ಅವನ ತಂದೆಗೆ ಸಹೋದರರಿಲ್ಲದಿದ್ದರೆ, ಅವನ ಸ್ವಂತ ಕುಲದ ಅತಿ ಸಮೀಪದ ಸಂಬಂಧಿಕನಿಗೆ ಅದನ್ನು ವಹಿಸಿಕೊಡಬೇಕು. ಆಗ ಅವನು ಅದನ್ನು ಸ್ವಾಧೀನಪಡಿಸಿಕೊಳ್ಳುವನು. ಯೆಹೋವನು ಮೋಶೆಗೆ ಆಜ್ಞಾಪಿಸಿದ ಈ ನಿರ್ಧಾರವು ಇಸ್ರೇಲರಿಗೆ ಕಾನೂನು ಬದ್ಧವಾದ ವಿಧಿಯಾಗಿದೆ.’” ");
INSERT INTO kan2010_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ಬಳಿಕ ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: “ಅಬಾರೀಮ್ ಪರ್ವತ ಶ್ರೇಣಿಯಲ್ಲಿರುವ ಈ ಬೆಟ್ಟವನ್ನು ಹತ್ತು. ನಾನು ಇಸ್ರೇಲರಿಗೆ ಕೊಡಲಿಕ್ಕಿರುವ ದೇಶವನ್ನು ನೀನು ಅಲ್ಲಿಂದ ನೋಡು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ಆ ದೇಶವನ್ನು ನೋಡಿದ ನಂತರ ನಿನ್ನ ಅಣ್ಣನಾದ ಆರೋನನಂತೆ ನೀನೂ ಸಾಯುವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ಇಸ್ರೇಲರ ಸಮೂಹದವರು ಚಿನ್ ಮರುಭೂಮಿಯಲ್ಲಿ ನನ್ನೊಡನೆ ವಿವಾದಿಸಿದಾಗ ನೀವಿಬ್ಬರೂ ನನ್ನ ಪವಿತ್ರತೆಯನ್ನು ಜನರ ಮುಂದೆ ತೋರಿಸದೆ ನನ್ನ ಆಜ್ಞೆಗೆ ಅವಿಧೇಯರಾದ ಕಾರಣ ಆ ದೇಶವನ್ನು ನೀನು ಸೇರಬಾರದು.” ಚಿನ್ ಮರುಭೂಮಿಯಲ್ಲಿ ಕಾದೇಶಿನ ಬಳಿ ಮೆರೀಬಾ ಬುಗ್ಗೆಯ ಕುರಿತಾಗಿ ಯೆಹೋವನು ಇದನ್ನು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ಆಗ ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ಎಲ್ಲಾ ಮನುಷ್ಯರ ಯೋಚನೆಗಳನ್ನು ತಿಳಿದಿರುವ ದೇವರಾದ ಯೆಹೋವನು ಈ ಸಮೂಹಕ್ಕೆ ಒಬ್ಬ ನಾಯಕನನ್ನು ನೇಮಿಸಲಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ಅವನು ಅವರನ್ನು ಯುದ್ಧದಲ್ಲಿ ಮುನ್ನಡೆಸುವವನೂ ಸೈನ್ಯದ ಯೋಜನೆಗಳನ್ನು ರೂಪಿಸುವವನೂ ಆಗಿರಲಿ. ಆಗ ಯೆಹೋವನ ಸಮೂಹವು ಕುರುಬನಿಲ್ಲದ ಕುರಿಯಂತಾಗುವುದಿಲ್ಲ.” ");
INSERT INTO kan2010_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ಅದಕ್ಕೆ ಯೆಹೋವನು, “ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನು ಹೊಸ ನಾಯಕನಾಗಿರುವನು. ಅವನು ಧೈರ್ಯವಂತನು. ಅವನನ್ನು ಹೊಸ ನಾಯಕನನ್ನಾಗಿ ಮಾಡಲು ಅವನ ಮೇಲೆ ನಿನ್ನ ಕೈಯನ್ನು ಇಡು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ ಮುಂದೆಯೂ ಸಮಸ್ತ ಇಸ್ರೇಲರ ಮುಂದೆಯೂ ಅವನನ್ನು ನಿಲ್ಲಿಸು. ಅವರ ಎದುರಿನಲ್ಲಿಯೇ ಅವನಿಗೆ ಆದೇಶಗಳನ್ನು ಕೊಡು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","“ಇಸ್ರೇಲರ ಇಡೀ ಸಮುದಾಯವು ವಿಧೇಯರಾಗುವಂತೆ ನಿನ್ನ ಅಧಿಕಾರಗಳಲ್ಲಿ ಸ್ವಲ್ಪವನ್ನು ಅವನಿಗೆ ಕೊಡು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ಯೆಹೋಶುವನು ತೀರ್ಮಾನವೇನಾದರೂ ಮಾಡಬೇಕಾದರೆ ಅವನು ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ ಬಳಿಗೆ ಹೋಗಲಿ, ಎಲ್ಲಾಜಾರನು ಊರೀಮಿನಿಂದ ಯೆಹೋವನ ಉತ್ತರವನ್ನು ಪಡೆಯುವನು. ಆಗ ಯೆಹೋಶುವನೂ ಇಸ್ರೇಲರೆಲ್ಲರೂ ದೇವರು ಹೇಳುವ ಕಾರ್ಯಗಳನ್ನು ಮಾಡುವರು. ಆತನು, ‘ಯುದ್ಧಕ್ಕೆ ಹೋಗಿರಿ’ ಎಂದು ಹೇಳಿದರೆ ಅವರು ಯುದ್ಧಕ್ಕೆ ಹೋಗುವರು. ಆತನು, ‘ಮನೆಗೆ ಹೋಗಿರಿ’ ಎಂದು ಹೇಳಿದರೆ ಅವರು ಮನೆಗೆ ಹೋಗುವರು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ಮೋಶೆಯು ಯೆಹೋವನಿಗೆ ವಿಧೇಯನಾಗಿ ಯೆಹೋಶುವನನ್ನು ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ ಮಂದೆಯೂ ಸಮಸ್ತ ಇಸ್ರೇಲರ ಮುಂದೆಯೂ ನಿಲ್ಲಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ಬಳಿಕ ಮೋಶೆಯು ತನ್ನ ಕೈಯನ್ನು ಅವನ ಮೇಲಿಟ್ಟು ಹೊಸ ನಾಯಕನಿಗೆ ಕೊಡತಕ್ಕ ಆದೇಶಗಳನ್ನು ಕೊಟ್ಟನು. ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆ ಅವನು ಇದನ್ನು ಮಾಡಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ಯೆಹೋವನು ಮೋಶೆಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ನೀನು ಇಸ್ರೇಲರಿಗೆ ಈ ಆಜ್ಞೆಯನ್ನು ಕೊಡು. ನೀವು ಎಚ್ಚರಿಕೆಯಾಗಿದ್ದು ನೇಮಿತ ಕಾಲಗಳಲ್ಲಿ ನನಗೆ ಅರ್ಪಿಸತಕ್ಕ ಧಾನ್ಯಸಮರ್ಪಣೆಗಳನ್ನು ನನಗೆ ಸುಗಂಧ ಹೋಮಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ಅವರಿಗೆ ಹೀಗೆ ಹೇಳು: ನೀವು ಯೆಹೋವನಿಗೆ ಕೊಡಬೇಕಾಗಿರುವ ತ್ಯಾಗಮಯವಾದ ಕಾಣಿಕೆಗಳು ಇವುಗಳೇ: ದಿನನಿತ್ಯದ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ವರ್ಷ ವಯಸ್ಸಿನ ಎರಡು ಗಂಡುಕುರಿಗಳು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ನೀವು ಒಂದು ಕುರಿಮರಿಯನ್ನು ಹೊತ್ತಾರೆಯಲ್ಲಿಯೂ ಇನ್ನೊಂದನ್ನು ನಸುಸಂಜೆಯಲ್ಲಿಯೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ಹೊತ್ತಾರೆಯ ಸಮರ್ಪಣೆಯೊಂದಿಗೆ ನೀವು ಧಾನ್ಯಸಮರ್ಪಣೆಗಾಗಿ ಒಂದೂವರೆ ಸೇರು ಶ್ರೇಷ್ಠವಾದ ಎಣ್ಣೆಯನ್ನೂ ಮೂರು ಸೇರು ಗೋಧಿಹಿಟ್ಟನ್ನೂ ಬೆರೆಸಿ ಸಮರ್ಪಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","(ಈ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಸೀನಾಯಿ ಬೆಟ್ಟದ ಮೇಲೆ ಯೆಹೋವನಿಗೆ ತ್ಯಾಗಮಯವಾದ ಕಾಣಿಕೆಯಾಗಿಯೂ ಸುಗಂಧ ವಾಸನೆಯಾಗಿಯೂ ಕ್ರಮವಾಗಿ ಅರ್ಪಿಸಲಾಯಿತು.) ");
INSERT INTO kan2010_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","“ಪ್ರತಿಯೊಂದು ಕುರಿಮರಿಯೊಂದಿಗೆ ಒಂದೂವರೆ ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನು ಪಾನದ್ರವ್ಯದ ಕಾಣಿಕೆಯಾಗಿ ಅರ್ಪಿಸಬೇಕು. ಯೆಹೋವನಿಗೆ ಪಾನದ್ರವ್ಯವಾಗಿ ಅರ್ಪಿಸತಕ್ಕ ದ್ರಾಕ್ಷಾರಸವನ್ನು ಪವಿತ್ರಸ್ಥಳದಲ್ಲಿ ಸುರಿಯಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ನೀವು ಎರಡನೆ ಕುರಿಮರಿಯನ್ನು ನಸುಸಂಜೆಯಲ್ಲಿ ಅರ್ಪಿಸುವಾಗ, ಮುಂಜಾನೆಯಲ್ಲಿ ಅರ್ಪಿಸಿದಂತೆಯೇ ಅದರೊಡನೆ ಸಮರ್ಪಕವಾದ ಧಾನ್ಯಾರ್ಪಣೆಯನ್ನು ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಯನ್ನು ಮಾಡಬೇಕು. ಇದು ಯೆಹೋವನಿಗೆ ತ್ಯಾಗಮಯವಾದ ಅರ್ಪಣೆಯಾಗಿದ್ದು ಸುಗಂಧ ವಾಸನೆಯನ್ನು ಉಂಟುಮಾಡುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","10","“ಸಬ್ಬತ್‌ದಿನದಲ್ಲಿ ಎರಡು ಪೂರ್ಣಾಂಗವಾದ ಒಂದು ವರ್ಷದ ಗಂಡುಕುರಿಗಳನ್ನೂ ಧಾನ್ಯದ್ರವ್ಯಾರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಆರು ಸೇರು ಗೋಧಿಹಿಟ್ಟನ್ನೂ ಅದಕ್ಕೆ ತಕ್ಕ ಪಾನದ್ರವ್ಯವನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ಕ್ರಮವಾಗಿ ಅರ್ಪಿಸತಕ್ಕ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರ ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ, ಪ್ರತಿಸಬ್ಬತ್ ದಿನ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ಪ್ರತಿ ತಿಂಗಳ ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ, ನೀವು ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮವನ್ನು ಅರ್ಪಿಸಬೇಕು: ಎರಡು ಹೋರಿಗಳು, ಒಂದು ಟಗರು ಮತ್ತು ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳು. ಇವುಗಳೆಲ್ಲಾ ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ಇವುಗಳೊಡನೆ ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ನೀವು ಪ್ರತಿಯೊಂದು ಹೋರಿಗೆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಉತ್ತಮವಾದ ಒಂಭತ್ತು ಸೇರು ಗೋಧಿಹಿಟ್ಟನ್ನು ಅರ್ಪಿಸಬೇಕು. ಪ್ರತಿಯೊಂದು ಟಗರಿಗೆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಉತ್ತಮವಾದ ಆರು ಸೇರು ಗೋಧಿಹಿಟ್ಟನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ಪ್ರತಿಯೊಂದು ಕುರಿಮರಿಗೆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಉತ್ತಮವಾದ ಮೂರು ಸೇರು ಗೋಧಿಹಿಟ್ಟನ್ನು ಅರ್ಪಿಸಬೇಕು. ಈ ಸರ್ವಾಂಗಹೋಮವು ಯೆಹೋವನಿಗೆ ಸುಗಂಧ ವಾಸನೆಯಾಗಿಯೂ ತ್ಯಾಗಮಯವಾದ ಕಾಣಿಕೆಯಾಗಿಯೂ ಇದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ಇವುಗಳಿಗೆ ತಕ್ಕ ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳನ್ನು ಮಾಡಬೇಕು. ಅವು ಯಾವುವೆಂದರೆ: ಒಂದು ಹೋರಿಯೊಡನೆ ಮೂರು ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಟಗರಿನೊಡನೆ ಎರಡು ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಕುರಿಮರಿಯೊಡನೆ ಒಂದೂವರೆ ಸೇರು ದ್ರಾಕ್ಷಾರಸವನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ವರ್ಷದ ಪ್ರತಿತಿಂಗಳು ಅಮಾವಾಸ್ಯೆಯಲ್ಲಿ ಅರ್ಪಿಸತಕ್ಕ ಮಾಸಿಕ ಸರ್ವಾಂಗಹೋಮಗಳು ಇವುಗಳೇ. ");
INSERT INTO kan2010_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ಕ್ರಮಾನುಸಾರವಾದ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರ ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ, ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಒಂದು ಹೋತವನ್ನು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ಮೊದಲನೆಯ ತಿಂಗಳಿನ ಹದಿನಾಲ್ಕನೆಯ ದಿನದಲ್ಲಿ ಯೆಹೋವನಿಗೆ ಪಸ್ಕಹಬ್ಬದ ಯಜ್ಞವನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯ ಹಬ್ಬವು ಅದೇ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಿಂದ ಪ್ರಾರಂಭವಾಗುವುದು. ಏಳು ದಿನಗಳವರೆಗೂ ಹುಳಿಯಿಲ್ಲದ ರೊಟ್ಟಿಯನ್ನೇ ಊಟಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ಮೊದಲನೆಯ ದಿನದಲ್ಲಿ ದೇವಾರಾಧನೆಗಾಗಿ ಸಭೆ ಸೇರಬೇಕು. ಆ ದಿನದಲ್ಲಿ ಯಾವ ಪ್ರಯಾಸದ ಕೆಲಸವನ್ನು ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಎರಡು ಹೋರಿಗಳನ್ನು, ಒಂದು ಟಗರನ್ನು ಮತ್ತು ಒಂದು ವರ್ಷದ ಏಳು ಗಂಡುಕುರಿಮರಿಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಈ ಪಶುಗಳೆಲ್ಲ ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ಇವುಗಳೊಂದಿಗೆ ಧಾನ್ಯಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಗೋಧಿಹಿಟ್ಟನ್ನು ತಂದುಕೊಡಬೇಕು; ಹೇಗೆಂದರೆ, ಒಂದು ಹೋರಿಗೆ ಒಂಭತ್ತು ಸೇರು ಗೋಧಿಹಿಟ್ಟು, ಒಂದು ಟಗರಿಗೆ ಆರು ಸೇರು ಗೋಧಿಹಿಟ್ಟು, ");
INSERT INTO kan2010_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ಏಳು ಕುರಿಮರಿಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದಕ್ಕೂ ಮೂರು ಸೇರು ಗೋಧಿಹಿಟ್ಟು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ಇದಲ್ಲದೆ ನಿಮಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಲು ಒಂದು ಹೋತವನ್ನು ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ಕ್ರಮವಾಗಿ ಮುಂಜಾನೆ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮವಲ್ಲದೆ ಇವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","“ಈ ಎಲ್ಲ ಅರ್ಪಣೆಗಳನ್ನು ಆ ಏಳು ದಿನಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದು ದಿನವೂ ಆಹಾರವಾಗಿಯೂ ತ್ಯಾಗಮಯವಾದ ಕಾಣಿಕೆಯಾಗಿಯೂ ಯೆಹೋವನಿಗೆ ಸುಗಂಧ ವಾಸನೆಯಾಗಿಯೂ ಅರ್ಪಿಸಬೇಕು. ಕ್ರಮಾನುಸಾರವಾದ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರ ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ಇವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","“ಇದಲ್ಲದೆ ಏಳನೆಯ ದಿನದಲ್ಲಿ ವಿಶೇಷ ಸಭೆ ಸೇರಬೇಕು. ಆ ದಿನದಲ್ಲಿ ನೀವು ಪ್ರಯಾಸದ ಕೆಲಸವನ್ನು ಮಾಡಕೂಡದು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ನಿಮ್ಮ ಪ್ರಥಮಫಲಗಳ ಹಬ್ಬದಲ್ಲಿ ಅಂದರೆ ವಾರಗಳ ಹಬ್ಬದಲ್ಲಿ ನೀವು ಹೊಸದಾಗಿ ಬೆಳೆದ ಗೋಧಿಯನ್ನು ಯೆಹೋವನಿಗೆ ಅರ್ಪಿಸುವಾಗ, ದೇವರನ್ನು ಆರಾಧಿಸಲು ನೀವು ಸಭೆ ಸೇರಬೇಕು. ನೀವು ಯಾವ ಪ್ರಯಾಸದ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ಆ ದಿನದಲ್ಲಿ ಎರಡು ಹೋರಿಗಳನ್ನು, ಒಂದು ಟಗರನ್ನು ಮತ್ತು ಒಂದು ವರ್ಷದ ಏಳು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಸುಗಂಧ ವಾಸನೆಯಾಗಿರುವ ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ಇವುಗಳೊಂದಿಗೆ ಧಾನ್ಯಸಮರ್ಪಣೆಗಾಗಿ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಗೋಧಿಹಿಟ್ಟನ್ನು ಪ್ರತಿಯೊಂದು ಹೋರಿಗೆ ಒಂಭತ್ತು ಸೇರು, ");
INSERT INTO kan2010_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ಟಗರಿಗೆ ಆರು ಸೇರು ಮತ್ತು ಪ್ರತಿಯೊಂದು ಕುರಿಗೆ ಮೂರು ಸೇರು ಈ ಮೇರೆಗೆ ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ನಿಮಗೋಸ್ಕರ ಪ್ರಾಯಶ್ಚಿತ್ತ ಮಾಡಲು ಒಂದು ಹೋತವನ್ನೂ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞವಾಗಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ಈ ಪಶುಗಳೆಲ್ಲಾ ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ಕ್ರಮಾನುಸಾರವಾದ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರ ಧಾನ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ಈ ಯಜ್ಞಗಳನ್ನು ಮತ್ತು ಅವುಗಳೊಡನೆ ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ನೀವು ಸಮರ್ಪಿಸುವ ಪಶುಗಳಲ್ಲಿಯೂ ಅಥವಾ ಪಾನದ್ರವ್ಯಸಮರ್ಪಣೆಗಳಲ್ಲಿಯೂ ಯಾವ ದೋಷವೂ ಇರಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ಏಳನೆಯ ತಿಂಗಳಿನ ಮೊದಲನೆ ದಿನದಲ್ಲಿ ವಿಶೇಷ ಸಭೆ ಸೇರಬೇಕು. ಆ ದಿನದಲ್ಲಿ ನೀವು ಯಾವ ಪ್ರಯಾಸದ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ಅದು ತುತ್ತೂರಿಗಳ ಧ್ವನಿಯಿಂದ ಪ್ರಕಟವಾಗುವ ದಿನವಾಗಿದೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ಅದರಲ್ಲಿ ನೀವು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಕರವಾದ ಸರ್ವಾಂಗಹೋಮಕ್ಕಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಒಂದು ವರ್ಷದ ಏಳು ಕುರಿಮರಿಗಳನ್ನೂ ಸಮರ್ಪಿಸಬೇಕು. ಇವುಗಳೆಲ್ಲ ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ಇವುಗಳೊಡನೆ ಧಾನ್ಯಸಮರ್ಪಣೆಗಾಗಿ ಹೋರಿಗೆ ಒಂಭತ್ತು ಸೇರು, ಟಗರಿಗೆ ಆರು ಸೇರು ಮತ್ತು ");
INSERT INTO kan2010_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ಪ್ರತಿಯೊಂದು ಕುರಿಮರಿಗೆ ಮೂರು ಸೇರು, ಈ ಮೇರೆಗೆ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಗೋಧಿಹಿಟ್ಟನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ಅಮಾವಾಸ್ಯೆಯಲ್ಲಿ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸುವ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಕ್ರಮವಾಗಿ ಪ್ರತಿನಿತ್ಯ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸುವ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆ ಇವುಗಳಲ್ಲದೆ ಈ ಅರ್ಪಣೆಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಇವುಗಳನ್ನು ನಿಯಮಗಳ ಪ್ರಕಾರವಾಗಿ ಮಾಡಬೇಕು. ಅವು ಯೆಹೋವನಿಗೆ ಸುಗಂಧ ವಾಸನೆಯಾಗಿಯೂ ತ್ಯಾಗಮಯವಾದ ಕಾಣಿಕೆಯಾಗಿಯೂ ಇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ಏಳನೆಯ ತಿಂಗಳಿನ ಹತ್ತನೆಯ ದಿನದಲ್ಲಿ ವಿಶೇಷ ಸಭೆ ಸೇರಬೇಕು. ಆ ದಿನದಲ್ಲಿ ನೀವು ಉಪವಾಸ ಮಾಡಬೇಕು; ಯಾವ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ನೀವು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಕರವಾಗಿರುವ ಸರ್ವಾಂಗಹೋಮವನ್ನಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಒಂದು ವರ್ಷದ ಏಳು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ಇವು ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ಇವುಗಳೊಡನೆ, ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಗೋಧಿಹಿಟ್ಟನ್ನು ಒಂದು ಹೋರಿಗೆ ಒಂಭತ್ತು ಸೇರು, ಟಗರಿಗೆ ಆರು ಸೇರು ");
INSERT INTO kan2010_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ಮತ್ತು ಒಂದು ಕುರಿಮರಿಗೆ ಮೂರು ಸೇರು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ದೋಷಪರಿಹಾರಕ ದಿನಕ್ಕೋಸ್ಕರ ಅರ್ಪಿಸುವ ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞ, ಕ್ರಮವಾಗಿ ಪ್ರತಿನಿತ್ಯ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಇವುಗಳೊಡನೆ ಅರ್ಪಿಸುವ ದ್ರವ್ಯಾರ್ಪಣೆ ಇವುಗಳಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ಇವು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಕರವಾಗಿವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ಏಳನೆಯ ತಿಂಗಳಿನ ಹದಿನೈದನೆಯ ದಿನದಲ್ಲಿ ವಿಶೇಷ ಸಭೆ ಸೇರಬೇಕು. ಇದು ಪರ್ಣಶಾಲೆಗಳ ಹಬ್ಬವಾಗಿದೆ. ಆ ದಿವಸ ನೀವು ಯಾವ ಪ್ರಯಾಸದ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ಯೆಹೋವನಿಗೆ ಗೌರವಾರ್ಥವಾಗಿ “ಪರ್ಣಶಾಲೆಗಳ ಹಬ್ಬ” ವನ್ನು ನೀವು ಏಳು ದಿನಗಳವರೆಗೆ ಆಚರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ನೀವು ಯೆಹೋವನಿಗೆ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಅದರ ಸುವಾಸನೆಯು ಯೆಹೋವನಿಗೆ ಮೆಚ್ಚಿಗೆಕರವಾಗಿದೆ. ಸರ್ವಾಂಗಹೋಮವಾಗಿ ಹದಿಮೂರು ಹೋರಿಗಳನ್ನು, ಎರಡು ಟಗರುಗಳನ್ನು ಮತ್ತು ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ಧಾನ್ಯನೈವೇದ್ಯಕ್ಕಾಗಿ ಎಣ್ಣೆ ಬೆರೆಸಿದ ಗೋಧಿಹಿಟ್ಟನ್ನು ಅರ್ಪಿಸಬೇಕು. ಅಂದರೆ ಪ್ರತಿಯೊಂದು ಹೋರಿಗೆ ಒಂಭತ್ತು ಸೇರು, ಟಗರಿಗೆ ಆರು ಸೇರು ");
INSERT INTO kan2010_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ಮತ್ತು ಒಂದು ಕುರಿಮರಿಗೆ ಮೂರು ಸೇರು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ಕ್ರಮವಾಗಿ ಪ್ರತಿನಿತ್ಯ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸುವ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ಆ ಉತ್ಸವದ ಎರಡನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಹನ್ನೆರಡು ಹೋರಿಗಳನ್ನು, ಎರಡು ಟಗರುಗಳನ್ನು ಮತ್ತು ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಇವುಗಳೆಲ್ಲ ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ಅಲ್ಲದೆ ಈ ಪಶುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದಕ್ಕೂ ನೇಮಕಗೊಂಡ ಧಾನ್ಯಾರ್ಪಣೆಯನ್ನು ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಯನ್ನು ಸರಿಯಾದ ಪ್ರಮಾಣದಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಕ್ರಮವಾಗಿ ಪ್ರತಿನಿತ್ಯ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸುವ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ಈ ಉತ್ಸವದ ಮೂರನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಹನ್ನೊಂದು ಹೋರಿಗಳನ್ನು, ಎರಡು ಟಗರುಗಳನ್ನು ಮತ್ತು ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಇವುಗಳು ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ಈ ಪಶುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದಕ್ಕೂ ನೇಮಕವಾಗಿರುವ ಧಾನ್ಯಾರ್ಪಣೆಯನ್ನು ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಯನ್ನು ಸರಿಯಾದ ಪ್ರಮಾಣದಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ದೋಷಪರಿಹಾರಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಕ್ರಮಾನುಸಾರವಾದ ದೈನಂದಿನ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸುವ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ಮೇಲ್ಕಂಡವುಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ಈ ಉತ್ಸವದ ನಾಲ್ಕನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಹತ್ತು ಹೋರಿಗಳನ್ನು, ಎರಡು ಟಗರುಗಳನ್ನು ಮತ್ತು ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಇವು ಪೂರ್ಣಾಂಗವುಳ್ಳವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ಈ ಪಶುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯಾರ್ಪಣೆಯನ್ನು ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಯನ್ನು ಸರಿಯಾದ ಪ್ರಮಾಣದಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ಪಾಪಪರಿಹಾರಕಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಕ್ರಮವಾಗಿ ಪ್ರತಿನಿತ್ಯ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸುವ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ಈ ಉತ್ಸವದ ಐದನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಒಂಭತ್ತು ಹೋರಿಗಳನ್ನು, ಎರಡು ಟಗರುಗಳನ್ನು ಮತ್ತು ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಇವುಗಳೆಲ್ಲಾ ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ಈ ಪಶುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದಕ್ಕೂ ನೇಮಕಗೊಂಡ ಧಾನ್ಯಾರ್ಪಣೆಯನ್ನು ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಯನ್ನು ಸರಿಯಾದ ಪ್ರಮಾಣದಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಕ್ರಮವಾದ ದೈನಂದಿನ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸಬೇಕಾದ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ಈ ಉತ್ಸವದ ಆರನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಎಂಟು ಹೋರಿಗಳನ್ನು, ಎರಡು ಟಗರುಗಳನ್ನು ಮತ್ತು ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಇವುಗಳೆಲ್ಲ ಪೂರ್ಣಾಂಗವುಳ್ಳವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ಈ ಪಶುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯಾರ್ಪಣೆಯನ್ನೂ ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಯನ್ನೂ ಸರಿಯಾದ ಪ್ರಮಾಣದಲ್ಲಿ ಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಕ್ರಮವಾಗಿ ಪ್ರತಿನಿತ್ಯ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸುವ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ಈ ಉತ್ಸವದ ಏಳನೆಯ ದಿನದಲ್ಲಿ ನೀವು ಏಳು ಹೋರಿಗಳನ್ನು, ಎರಡು ಟಗರುಗಳನ್ನು ಮತ್ತು ಒಂದು ವರ್ಷದ ಹದಿನಾಲ್ಕು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನು ಅರ್ಪಿಸಬೇಕು. ಅವುಗಳೆಲ್ಲ ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ಈ ಪಶುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯಾರ್ಪಣೆಗಳನ್ನು ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳನ್ನು ಸರಿಯಾದ ಪ್ರಮಾಣದಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ದೋಷಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಕ್ರಮವಾಗಿ ಪ್ರತಿನಿತ್ಯ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸುವ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ಎಂಟನೆಯ ದಿನದಲ್ಲಿ ಮುಕ್ತಾಯ ಸಭಾಕೂಟವಿರುವುದು. ಆ ದಿನದಲ್ಲಿ ಯಾವ ಪ್ರಯಾಸದ ಕೆಲಸವನ್ನೂ ಮಾಡಬಾರದು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ನೀವು ಈ ಕೆಳಕಂಡವುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಸುಗಂಧಕರವಾದ ತ್ಯಾಗಮಯವಾದ ಸರ್ವಾಂಗಹೋಮವನ್ನಾಗಿ ಒಂದು ಹೋರಿಯನ್ನೂ ಒಂದು ಟಗರನ್ನೂ ಒಂದು ವರ್ಷದ ಏಳು ಗಂಡು ಕುರಿಮರಿಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ಇವುಗಳೆಲ್ಲ ಪೂರ್ಣಾಂಗವಾದವುಗಳಾಗಿರಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ಈ ಪಶುಗಳಲ್ಲಿ ಪ್ರತಿಯೊಂದಕ್ಕೆ ನೇಮಕವಾದ ಪ್ರಕಾರವೇ ಧಾನ್ಯಾರ್ಪಣೆಗಳನ್ನು ಮತ್ತು ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳನ್ನು ಸರಿಯಾದ ಪ್ರಮಾಣದಲ್ಲಿ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ಪಾಪಪರಿಹಾರಕ ಯಜ್ಞಕ್ಕಾಗಿ ಒಂದು ಹೋತವನ್ನು ಸಮರ್ಪಿಸಬೇಕು. ಕ್ರಮವಾಗಿ ಪ್ರತಿನಿತ್ಯ ಅರ್ಪಿಸುವ ಸರ್ವಾಂಗಹೋಮ ಮತ್ತು ಅದರೊಡನೆ ಅರ್ಪಿಸುವ ಧಾನ್ಯಾರ್ಪಣೆ ಮತ್ತು ಅದರ ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ಮೇಲೆ ತಿಳಿಸಿರುವ ಸಾರ್ವಜನಿಕ ಯಜ್ಞಗಳನ್ನು ಇಡೀ ಸಮುದಾಯಕ್ಕೋಸ್ಕರ ಹಬ್ಬದ ದಿನಗಳಲ್ಲಿ ನಿಮ್ಮ ಸರ್ವಾಂಗಹೋಮಗಳನ್ನಾಗಿಯೂ ಧಾನ್ಯಾರ್ಪಣೆಗಳನ್ನಾಗಿಯೂ ಪಾನದ್ರವ್ಯಾರ್ಪಣೆಗಳನ್ನಾಗಿಯೂ ಮತ್ತು ಸಮಾಧಾನಯಜ್ಞಗಳನ್ನಾಗಿಯೂ ಅರ್ಪಿಸಬೇಕು. ನಿಮ್ಮ ವೈಯಕ್ತಿಕ ಹರಕೆಯ ಅರ್ಪಣೆ ಮತ್ತು ಸ್ವಯಿಚ್ಛಾರ್ಪಣೆಗಳಲ್ಲದೆ ಮೇಲೆ ಹೇಳಿದವುಗಳನ್ನೂ ಅರ್ಪಿಸಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದನ್ನೆಲ್ಲಾ ಮೋಶೆಯು ಇಸ್ರೇಲರಿಗೆ ತಿಳಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ಮೋಶೆಯು ಇಸ್ರೇಲರ ಕುಲಪ್ರಧಾನರಿಗೆ ಹೇಳಿದ್ದೇನೆಂದರೆ: ಯೆಹೋವನು ಹೀಗೆ ಆಜ್ಞಾಪಿಸಿದ್ದಾನೆ: ");
INSERT INTO kan2010_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“ಯಾವನಾದರೂ ಯೆಹೋವನಿಗೆ ಇಂಥದ್ದನ್ನು ಕೊಡುತ್ತೇನೆಂದು ಹರಕೆ ಮಾಡಿದರೆ ಅಥವಾ ತಾನು ಇಂಥದ್ದನ್ನು ಮಾಡುವುದಿಲ್ಲ ಎಂದು ಆಣೆಯಿಟ್ಟುಕೊಂಡರೆ, ಅವನು ತನ್ನ ಮಾತನ್ನು ಮೀರದೆ ತಾನು ಹೇಳಿದಂತೆಯೇ ನೆರವೇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“ಇನ್ನೂ ತನ್ನ ತಂದೆಯ ಮನೆಯಲ್ಲಿರುವ ಯುವತಿಯು ಯೆಹೋವನಿಗೆ ಇಂಥದ್ದನ್ನು ಕೊಡುತ್ತೇನೆಂದು ಹರಕೆ ಮಾಡಿಕೊಂಡರೆ ಅಥವಾ ಇಂಥದ್ದನ್ನು ಮಾಡುವುದಿಲ್ಲ ಎಂದು ಆಣೆಯಿಟ್ಟುಕೊಂಡರೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ಅವಳ ತಂದೆಯು ಅವಳ ಹರಕೆಯನ್ನಾಗಲಿ ಆಣೆಯನ್ನಾಗಲಿ ಕೇಳಿಯೂ ಅದರ ಬಗ್ಗೆ ಅವಳಿಗೆ ಏನೂ ಹೇಳದಿದ್ದರೆ, ಆಕೆಯು ಅಂಥಾ ಹರಕೆಯನ್ನೂ ಆಣೆಯನ್ನೂ ನೆರವೇರಿಸಲೇಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ಆದರೆ ತಂದೆಯು ಆ ಸಂಗತಿಯನ್ನು ತಿಳಿದ ದಿನವೇ ಅದನ್ನು ಆಕ್ಷೇಪಿಸಿದರೆ, ಆಕೆಯು ಮಾಡಿದ ಹರಕೆಯನ್ನಾಗಲಿ ಇಟ್ಟುಕೊಂಡ ಆಣೆಯನ್ನಾಗಲಿ ನೆರವೇರಿಸಬೇಕಿಲ್ಲ. ತಂದೆಯು ಆಕ್ಷೇಪಿಸಿದ್ದರಿಂದ ಯೆಹೋವನು ಅವಳನ್ನು ಕ್ಷಮಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ಆದರೆ ಅವಳು ತನ್ನ ಹರಕೆಯನ್ನಾಗಲಿ ಆಣೆಯನ್ನಾಗಲಿ ನೆರವೇರಿಸಿಲ್ಲದಿರುವಾಗಲೇ ಮದುವೆಯಾದರೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ಗಂಡನು ಅದರ ಬಗ್ಗೆ ತಿಳಿದ ದಿನದಂದು ಆಕೆಗೆ ಅದರ ಬಗ್ಗೆ ಏನೂ ಹೇಳದಿದ್ದರೆ, ಆಕೆ ತಾನು ಮಾಡಿದ ಹರಕೆಯನ್ನಾಗಲಿ ಆಣೆಯನ್ನಾಗಲಿ ನೆರವೇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ಆದರೆ ಗಂಡನು ಅದನ್ನು ಕೇಳಿದ ದಿನವೇ ಆಕ್ಷೇಪಿಸಿದರೆ, ಆಕೆಯು ಮಾಡಿದ ಹರಕೆಯನ್ನಾಗಲಿ ಆಣೆಯನ್ನಾಗಲಿ ನೆರವೇರಿಸಬೇಕಿಲ್ಲ. ಯೆಹೋವನು ಅವಳನ್ನು ಕ್ಷಮಿಸುವನು. ");
INSERT INTO kan2010_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“ವಿಧವೆಯಾಗಲಿ ವಿವಾಹವಿಚ್ಛೇಧನ ಹೊಂದಿದ ಸ್ತ್ರೀಯಾಗಲಿ ತಾನು ಮಾಡಿದ ಪ್ರತಿಯೊಂದು ಹರಕೆಯನ್ನೂ ಆಣೆಯನ್ನೂ ನೆರವೇರಿಸಲೇಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ವಿವಾಹಿತ ಸ್ತ್ರೀಯು ಅಂಥಾ ಹರಕೆಯನ್ನಾಗಲಿ ಪ್ರಮಾಣವನ್ನಾಗಲಿ ಮಾಡಿದಾಗ, ");
INSERT INTO kan2010_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ಅವಳ ಗಂಡನು ತಿಳಿದು ಅಡ್ಡಿಮಾಡದೆ ಏನೂ ಹೇಳದಿದ್ದರೆ ಆಕೆಯು ಆ ಹರಕೆಗಳನ್ನೂ ಆಣೆಗಳನ್ನೂ ನೆರವೇರಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ಆದರೆ ಗಂಡನು ಅವುಗಳನ್ನು ತಿಳಿದಾಗಲೇ ರದ್ದುಗೊಳಿಸಿದರೆ, ಅವಳ ಎಲ್ಲ ಹರಕೆಗಳಿಗೆ ಮತ್ತು ಆಣೆಗಳಿಗೆ ಬೆಲೆಯಿರುವುದಿಲ್ಲ. ಯಾಕೆಂದರೆ ಗಂಡನು ಅವುಗಳನ್ನು ರದ್ದುಪಡಿಸಿದನು. ಆದ್ದರಿಂದ ಯೆಹೋವನು ಆಕೆಯನ್ನು ಕ್ಷಮಿಸುತ್ತಾನೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ಹೆಂಡತಿ ಮಾಡಿದ ಹರಕೆಯನ್ನೂ ಆಣೆಯನ್ನೂ ಸ್ಥಿರಪಡಿಸುವುದಕ್ಕಾಗಲಿ ರದ್ದುಪಡಿಸುವುದಕ್ಕಾಗಲಿ ಗಂಡನಿಗೆ ಅಧಿಕಾರವಿರುವುದು. ");
INSERT INTO kan2010_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ಆದರೆ ಅವಳ ಗಂಡನು ಅದನ್ನು ಕೇಳಿದ ದಿನದಿಂದ ಅದರ ಬಗ್ಗೆ ಆಕ್ಷೇಪಿಸದಿದ್ದರೆ, ಅವನು ಅವಳ ಎಲ್ಲಾ ಹರಕೆಗಳನ್ನು ಮತ್ತು ಆಣೆಗಳನ್ನು ಸ್ಥಿರಪಡಿಸಿದ್ದಾನೆ. ಯಾಕೆಂದರೆ ಅವನು ಅದರ ಬಗ್ಗೆ ಕೇಳಿದ ದಿನದಂದು ಅವಳಿಗೆ ಏನೂ ಹೇಳಲಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ಆದರೆ ಅವನು ಅವುಗಳ ಬಗ್ಗೆ ಕೇಳಿ ಸ್ವಲ್ಪ ದಿನಗಳಾದ ಮೇಲೆ ಆಕೆಯ ಹರಕೆಗಳನ್ನಾಗಲಿ ವಾಗ್ದಾನಗಳನ್ನಾಗಲಿ ರದ್ದುಪಡಿಸಿದರೆ, ಆಕೆಯ ಹರಕೆಯನ್ನು ಮುರಿದದ್ದಕ್ಕಾಗಿ ಅವನು ಶಿಕ್ಷೆಯನ್ನು ಅನುಭವಿಸುವನು.” ");
INSERT INTO kan2010_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ಗಂಡಹೆಂಡತಿಯರ ಬಗ್ಗೆ ಮತ್ತು ತಂದೆಯೊಡನೆ ಇನ್ನೂ ಮನೆಯಲ್ಲಿರುವ ಮಗಳ ವಿಷಯದಲ್ಲಿ ಯೆಹೋವನು ಮೋಶೆಗೆ ಈ ಆಜ್ಞೆಗಳನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ಯೆಹೋವನು ಮೋಶೆಯೊಡನೆ ಮಾತಾಡಿ ಹೀಗೆಂದನು: ");
INSERT INTO kan2010_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ನೀನು ಇಸ್ರೇಲರಿಗೋಸ್ಕರ ಮಿದ್ಯಾನ್ಯರ ಮೇಲೆ ಆಕ್ರಮಣಮಾಡಿ ಸೇಡು ತೀರಿಸಿಕೊ. ಇದಾದ ನಂತರ ನೀನು ಸಾಯುವಿ.” ");
INSERT INTO kan2010_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ಆಗ ಮೋಶೆ ಇಸ್ರೇಲರಿಗೆ, “ಮಿದ್ಯಾನ್ಯರು ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ಮಾಡಿದ ಕೃತ್ಯಗಳಿಗಾಗಿ ಅವರ ಮೇಲೆ ಆಕ್ರಮಣ ಮಾಡಿ ದಂಡಿಸಲು ನಿಮ್ಮಲ್ಲಿರುವ ಗಂಡಸರಲ್ಲಿ ಕೆಲವರನ್ನು ದಂಡೆಯಾತ್ರೆಗೆ ಆರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ಇಸ್ರೇಲಿನ ಕುಲಗಳವರಲ್ಲಿ ಪ್ರತಿಯೊಂದು ಕುಲದಿಂದ ಒಂದು ಸಾವಿರ ಗಂಡಸರನ್ನು ದಂಡೆಯಾತ್ರೆಗೆ ಕಳುಹಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ಆದ್ದರಿಂದ ಇಸ್ರೇಲರ ಕುಲಗಳಿಂದ ಪ್ರತಿಯೊಂದು ಕುಲಕ್ಕೆ ಒಂದು ಸಾವಿರ ಗಂಡಸರ ಪ್ರಕಾರ ಹನ್ನೆರಡು ಸಾವಿರ ಗಂಡಸರನ್ನು ಯುದ್ಧಕ್ಕೆ ಆರಿಸಿಕೊಳ್ಳಬೇಕು” ಅಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ಮೋಶೆಯು ಅವರನ್ನು ಯುದ್ಧಕ್ಕೆ ಕಳುಹಿಸಿದನು. ಅವರ ಸಂಗಡ ಎಲ್ಲಾಜಾರನ ಮಗನಾದ ಫೀನೆಹಾಸನನ್ನೂ ಕಳುಹಿಸಿದನು. ಫೀನೆಹಾಸನು ಪವಿತ್ರವಸ್ತುಗಳನ್ನು ತೆಗೆದುಕೊಂಡನು ಮತ್ತು ಸೂಚನೆ ಕೊಡುವುದಕ್ಕಾಗಿ ತುತ್ತೂರಿಗಳನ್ನು ತೆಗೆದುಕೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ಇಸ್ರೇಲರು ಮಿದ್ಯಾನ್ಯರೊಡನೆ ಯುದ್ಧಮಾಡಿದರು. ಅವರು ಮಿದ್ಯಾನ್ಯರ ಗಂಡಸರೆಲ್ಲರನ್ನು ಕೊಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ಅವರು ಕೊಂದವರಲ್ಲಿ ಎವೀ, ರೆಕೆಮ್, ಜೂರ್, ಹೂರ್ ಮತ್ತು ರೆಬಾ ಎಂಬ ಮಿದ್ಯಾನ್ಯರ ಐದು ಮಂದಿ ರಾಜರು ಸೇರಿದ್ದರು. ಅವರು ಕತ್ತಿಯಿಂದ ಬೆಯೋರನ ಮಗನಾದ ಬಿಳಾಮನನ್ನೂ ಕೊಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ಇಸ್ರೇಲರು ಮಿದ್ಯಾನ್ಯರ ಹೆಂಗಸರನ್ನು ಮತ್ತು ಮಕ್ಕಳನ್ನು ಸೆರೆಹಿಡಿದರು. ಅವರು ಮಿದ್ಯಾನ್ಯರ ಎಲ್ಲಾ ಪಶುಗಳನ್ನು ಮತ್ತು ಇತರ ಅಮೂಲ್ಯವಾದ ವಸ್ತುಗಳನ್ನು ತೆಗೆದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ಅವರು ನೆಲೆಸಿದ್ದ ಊರುಗಳನ್ನೂ ಪಾಳೆಯಗಳನ್ನೂ ಸುಟ್ಟುಹಾಕಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ಎಲ್ಲಾ ಜನರನ್ನೂ ಪಶುಗಳನ್ನೂ ಹಿಡಿದು, ");
INSERT INTO kan2010_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ತಾವು ಸೆರೆಹಿಡಿದವರನ್ನೂ ಪಶುಗಳನ್ನೂ ಆಸ್ತಿಯನ್ನೂ ತೆಗೆದುಕೊಂಡು ಜೆರಿಕೊ ಪಟ್ಟಣದ ಆಚೆ ಜೋರ್ಡನ್ ಹೊಳೆಯ ತೀರದಲ್ಲಿ ಮೋವಾಬ್ಯರ ಬಯಲಿನಲ್ಲಿದ್ದ ಪಾಳೆಯಕ್ಕೆ ಅಂದರೆ ಮೋಶೆ, ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರ್ ಮತ್ತು ಇಸ್ರೇಲರ ಸರ್ವಸಮೂಹದವರು ಇದ್ದಲ್ಲಿಗೆ ಬಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ಮೋಶೆಯೂ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನೂ ಸಮೂಹದ ಪ್ರಧಾನರೂ ಪಾಳೆಯದ ಹೊರಗೆ ಬಂದು ಸೈನಿಕರನ್ನು ಎದುರುಗೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ಮೋಶೆಯು ಯುದ್ಧದಿಂದ ಹಿಂತಿರುಗಿ ಬರುತ್ತಿದ್ದ ಸೈನ್ಯಾಧಿಕಾರಿಗಳ ಮೇಲೆ ಅಂದರೆ ಸಹಸ್ರಾಧಿಪತಿಗಳ ಮತ್ತು ಶತಾಧಿಪತಿಗಳ ಮೇಲೆ ಕೋಪಗೊಂಡನು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ಅವನು ಅವರಿಗೆ, “ನೀವು ಎಲ್ಲಾ ಹೆಂಗಸರನ್ನು ಉಳಿಸಿದ್ದೇಕೆ? ");
INSERT INTO kan2010_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ಬಿಳಾಮನ ಸಲಹೆಯನ್ನು ಅನುಸರಿಸಿ, ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ಇಸ್ರೇಲರು ಪಾಪಮಾಡುವಂತೆ ಮಾಡಿ ಪೆಗೋರದ ಬಾಳನ ಸಂಗತಿಗೆ ಕಾರಣರಾದವರು ಇವರೇ ಅಲ್ಲವೇ? ಅದರ ಫಲವಾಗಿ ಭಯಂಕರವಾದ ಕಾಯಿಲೆಯು ಜನರಿಗೆ ಬಂದಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ಆದ್ದರಿಂದ ಈ ಗುಂಪಿನಲ್ಲಿರುವ ಎಲ್ಲಾ ಗಂಡುಮಕ್ಕಳನ್ನೂ ಪುರುಷಸಂಗಮ ಮಾಡಿದ ಎಲ್ಲಾ ಮಿದ್ಯಾನ್ ಹೆಂಗಸರನ್ನೂ ಕೊಲ್ಲಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ಪುರುಷಸಂಗಮ ಮಾಡದಿರುವ ಕನ್ಯೆಯರನ್ನು ನಿಮಗಾಗಿ ಉಳಿಸಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","ನೀವಾದರೋ ಏಳು ದಿನಗಳವರೆಗೂ ಪಾಳೆಯದ ಹೊರಗೆ ಇರಬೇಕು. ಮನುಷ್ಯರನ್ನು ಕೊಂದವರೂ ಶವಸೋಂಕಿದವರೂ ನಿಮ್ಮವರಾಗಿರಲಿ ಸೆರೆಯವರಾಗಿರಲಿ ಮೂರನೆಯ ಮತ್ತು ಏಳನೆಯ ದಿನದಲ್ಲಿ ನಿಮ್ಮನ್ನು ಶುದ್ಧೀಕರಿಸಿಕೊಳ್ಳಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ಅದಲ್ಲದೆ ಎಲ್ಲಾ ಬಟ್ಟೆಗಳನ್ನೂ ತೊಗಲಿನ ಸಾಮಾನುಗಳನ್ನೂ ಮೇಕೆ ಕೂದಲಿನ ವಸ್ತುಗಳನ್ನೂ ಮರದ ಸಾಮಾನನ್ನೂ ಶುದ್ಧ ಮಾಡಬೇಕು.” ");
INSERT INTO kan2010_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ಆಗ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ಸೈನಿಕರೊಡನೆ ಮಾತಾಡಿ ಇಂತೆಂದೆನು: “ಯೆಹೋವನು ಮೋಶೆಗೆ ಯುದ್ಧದಿಂದ ಮರಳಿಬರುವ ಸೈನಿಕರ ಬಗ್ಗೆ ಆ ನಿಯಮಗಳನ್ನು ಕೊಟ್ಟನು: ");
INSERT INTO kan2010_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","ಬೆಂಕಿಯನ್ನು ಸಹಿಸಬಲ್ಲ ಚಿನ್ನ, ಬೆಳ್ಳಿ, ತಾಮ್ರ, ಕಬ್ಬಿಣ, ತವರ, ಸೀಸ ಮೊದಲಾದವುಗಳನ್ನು ಬೆಂಕಿಯಲ್ಲಿ ಹಾಯಿಸಿ ಶುದ್ಧಮಾಡಬೇಕು. ಬಳಿಕ ಶುದ್ಧೀಕರಣದ ನೀರಿನಿಂದ ಅವುಗಳನ್ನು ಶುದ್ಧೀಕರಿಸಬೇಕು. ಬೆಂಕಿಯನ್ನು ಸಹಿಸಲಾರದ ವಸ್ತುಗಳನ್ನು ನೀರಿನಿಂದ ಮಾತ್ರ ತೊಳೆಯಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ಏಳನೆಯ ದಿನದಲ್ಲಿ ನಿಮ್ಮ ಬಟ್ಟೆಗಳನ್ನು ಒಗೆದುಕೊಂಡ ನಂತರ ನೀವು ಶುದ್ಧರಾಗುವಿರಿ. ಆಮೇಲೆ ನೀವು ಪಾಳೆಯದೊಳಗೆ ಬರಬಹುದು.” ");
INSERT INTO kan2010_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ತರುವಾಯ ಯೆಹೋವನು ಮೋಶೆಗೆ, ");
INSERT INTO kan2010_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“ನೀನೂ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನೂ ಸಮುದಾಯದ ಎಲ್ಲಾ ಕುಲಪ್ರಧಾನರೂ ಸೆರೆಸಿಕ್ಕಿದ ಮನುಷ್ಯರನ್ನು ಮತ್ತು ಪಶುಗಳನ್ನು ಲೆಕ್ಕಿಸಿ ಪಟ್ಟಿಮಾಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ಅವುಗಳನ್ನು ಎರಡು ಭಾಗಮಾಡಿ ಯುದ್ಧಕ್ಕೆ ಹೋದ ಸೈನಿಕರಿಗೆ ಅರ್ಧವನ್ನು ಮಿಕ್ಕ ಸಮೂಹದವರಿಗೆ ಅರ್ಧವನ್ನು ಹಂಚಿಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ಯುದ್ಧಕ್ಕೆ ಹೋದ ಸೈನಿಕರಿಗೆ ಬರುವ ಭಾಗದಿಂದ ಮನುಷ್ಯರನ್ನು, ದನಕರುಗಳನ್ನು, ಕತ್ತೆಗಳನ್ನು ಮತ್ತು ಕುರಿಗಳನ್ನು ");
INSERT INTO kan2010_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ನೀನು ಐನೂರರಲ್ಲಿ ಒಂದರ ಮೇರೆಗೆ ಯೆಹೋವನಿಗೋಸ್ಕರ ಕಪ್ಪಕಾಣಿಕೆಯನ್ನು ತೆಗೆದುಕೊಂಡು, ಅದನ್ನು ಪ್ರತ್ಯೇಕಿಸಿ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನಿಗೆ ಒಪ್ಪಿಸಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ಮಿಕ್ಕ ಇಸ್ರೇಲರಿಗೆ ಬರುವ ಭಾಗದಿಂದ ಮನುಷ್ಯರನ್ನು, ದನಕರುಗಳನ್ನು, ಕತ್ತೆಗಳನ್ನು, ಕುರಿಗಳನ್ನು ಐವತ್ತರಲ್ಲಿ ಒಂದರ ಮೇರೆಗೆ ತೆಗೆದುಕೊಳ್ಳಬೇಕು. ಅದನ್ನು ಯೆಹೋವನ ಪವಿತ್ರ ಗುಡಾರವನ್ನು ನೋಡಿಕೊಳ್ಳುವ ಲೇವಿಯರಿಗೆ ಕೊಡಬೇಕು” ಎಂದು ಆಜ್ಞಾಪಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ಯೆಹೋವನು ಆಜ್ಞಾಪಿಸಿದ್ದಂತೆಯೇ ಮೋಶೆ ಮತ್ತು ಎಲ್ಲಾಜಾರನು ಮಾಡಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ಸೈನಿಕರು ಆರು ಲಕ್ಷದ ಎಪ್ಪತ್ತೈದು ಸಾವಿರ ಕುರಿಗಳನ್ನು, ");
INSERT INTO kan2010_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ಎಪ್ಪತ್ತೆರಡು ಸಾವಿರ ದನಕರುಗಳನ್ನು, ");
INSERT INTO kan2010_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ಅರವತ್ತೊಂದು ಸಾವಿರ ಕತ್ತೆಗಳನ್ನು, ");
INSERT INTO kan2010_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ಮೂವತ್ತೆರಡು ಸಾವಿರ ಕನ್ನಿಕೆಯರನ್ನು ಪಡೆದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ಯುದ್ಧಕ್ಕೆ ಹೋದ ಸೈನಿಕರು ಅರ್ಧಭಾಗವನ್ನು ಅಂದರೆ ಮೂರು ಲಕ್ಷದ ಮೂವತ್ತೇಳು ಸಾವಿರದ ಐನೂರು ಕುರಿಗಳನ್ನು ಪಡೆದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ಅವರು ಆರುನೂರ ಐವತ್ತೇಳು ಕುರಿಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ಸೈನಿಕರು ಮೂವತ್ತಾರು ಸಾವಿರ ದನಕರುಗಳನ್ನು ಪಡೆದುಕೊಂಡರು. ಅವುಗಳಲ್ಲಿ ಎಪ್ಪತ್ತೆರಡು ದನಕರುಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ಸೈನಿಕರು ಮೂವತ್ತು ಸಾವಿರದ ಐನೂರು ಕತ್ತೆಗಳನ್ನು ಪಡೆದುಕೊಂಡರು. ಅವರು ಅರವತ್ತೊಂದು ಕತ್ತೆಗಳನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ಸೈನಿಕರು ಹದಿನಾರು ಸಾವಿರ ಮಂದಿ ಕನ್ನಿಕೆಯರನ್ನು ಪಡೆದುಕೊಂಡರು. ಅವರು ಮೂವತ್ತೆರಡು ಮಂದಿ ಕನ್ನಿಕೆಯರನ್ನು ಯೆಹೋವನಿಗೆ ಕೊಟ್ಟರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ಮೋಶೆಯು ಯೆಹೋವನ ಅಪ್ಪಣೆಯ ಮೇರೆಗೆ ಆ ಕಪ್ಪವನ್ನೆಲ್ಲ ಯೆಹೋವನಿಗೆ ಕೊಡುಗೆಯಾಗಿ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","43","ಮೋಶೆಯು ಜನರಿಗೆ ಸೇರಿದ ಅರ್ಧಭಾಗವನ್ನು ಎಣಿಸಿದನು. ಯುದ್ಧಕ್ಕೆ ಹೋಗಿದ್ದ ಸೈನಿಕರಿಂದ ಮೋಶೆಯು ತೆಗೆದುಕೊಂಡ ಅರ್ಧಭಾಗ: ಮೂರು ಲಕ್ಷದ ಮೂವತ್ತೇಳು ಸಾವಿರದ ಐನೂರು ಕುರಿಗಳು, ");
INSERT INTO kan2010_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ಮೂವತ್ತಾರು ಸಾವಿರ ದನಕರುಗಳು, ");
INSERT INTO kan2010_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ಮೂವತ್ತು ಸಾವಿರದ ಐನೂರು ಕತ್ತೆಗಳು ");
INSERT INTO kan2010_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ಮತ್ತು ಹದಿನಾರು ಸಾವಿರ ಸ್ತ್ರೀಯರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ಇಸ್ರೇಲ್ ಜನರಿಗೆ ದೊರಕಿದ ಅರ್ಧ ಭಾಗದಿಂದ ಮನುಷ್ಯರಲ್ಲಿಯೂ ಪಶುಗಳಲ್ಲಿಯೂ ಮೋಶೆ ಐವತ್ತನೆ ಒಂದು ಭಾಗವನ್ನು ತೆಗೆದುಕೊಂಡು ಯೆಹೋವನ ಪವಿತ್ರಗುಡಾರವನ್ನು ನೋಡಿಕೊಳ್ಳುತ್ತಿದ್ದ ಲೇವಿಯರಿಗೆ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ಆಗ ದಂಡಿನ ಸಹಸ್ರಾಧಿಪತಿಗಳೂ ಶತಾಧಿಪತಿಗಳೂ ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು, ");
INSERT INTO kan2010_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","“ನಿನ್ನ ದಾಸರಾದ ನಾವು ನಮ್ಮ ಅಧಿಕಾರದೊಳಗೆ ಇದ್ದ ಸೈನಿಕರನ್ನು ಲೆಕ್ಕಿಸಲಾಗಿ ಒಬ್ಬನಾದರೂ ಕಡಿಮೆಯಾಗಿಲ್ಲವೆಂದು ತಿಳಿಯಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ಆದಕಾರಣ ಯೆಹೋವನು ಕಾಪಾಡಿದ ನಮ್ಮ ಪ್ರಾಣಗಳಿಗೆ ಈಡಾಗಿ ಆತನಿಗೋಸ್ಕರ ಕಾಣಿಕೆಯಾಗಿ ನಮ್ಮಲ್ಲಿ ಒಬ್ಬೊಬ್ಬನು ತನಗೆ ಸಿಕ್ಕಿದ ಚಿನ್ನದ ಒಡವೆಗಳನ್ನು ಅಂದರೆ ತೋಳ್ಬಳೆ, ಕಡಗ, ಮುದ್ರೆಯುಂಗುರ, ಮುರುವು, ಕಂಠಮಾಲೆ ಮುಂತಾದವುಗಳನ್ನು ನಮ್ಮ ಶುದ್ಧೀಕರಣಕ್ಕಾಗಿ ಯೆಹೋವನಿಗೆ ತಂದಿದ್ದೇವೆ” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ಅವರು ಕೊಟ್ಟ ಎಲ್ಲಾ ಚಿನ್ನದ ಒಡವೆಗಳನ್ನು ಮೋಶೆಯು ಮತ್ತು ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನು ತೆಗೆದುಕೊಂಡರು. ಅವುಗಳನ್ನು ಕುಶಲತೆಯಿಂದ ತಯಾರಿಸಿದ ಒಡವೆಗಳಾಗಿದ್ದವು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ಸಹಸ್ರಾಧಿಪತಿಗಳು ಮತ್ತು ಶತಾಧಿಪತಿಗಳು ಯೆಹೋವನಿಗೆ ಕೊಟ್ಟ ಚಿನ್ನವು ನಾನೂರಿಪ್ಪತ್ತು ಪೌಂಡು ತೂಕವಿತ್ತು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ಉಳಿದದ್ದನ್ನು ಸೈನಿಕರು ತಮಗಾಗಿ ಇಟ್ಟುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ಸಹಸ್ರಾಧಿಪತಿಗಳೂ ಶತಾಧಿಪತಿಗಳೂ ಕೊಟ್ಟ ಚಿನ್ನವನ್ನು ಮೋಶೆಯೂ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನೂ ತೆಗೆದುಕೊಂಡು ದೇವದರ್ಶನಗುಡಾರದಲ್ಲಿ ಇಟ್ಟರು. ಇಸ್ರೇಲರ ವಿಷಯದಲ್ಲಿ ಜ್ಞಾಪಕಾರ್ಥವಾಗಿ ಇದು ಯೆಹೋವನ ಸನ್ನಿಧಿಯಲ್ಲಿ ಇಡಲ್ಪಟ್ಟಿತು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ರೂಬೇನ್ ಕುಲದವರಿಗೂ ಗಾದ್ ಕುಲದವರಿಗೂ ಬಹಳ ದನಗಳಿದ್ದವು. ಅವರು ಯಗ್ಜೇರ್ ಮತ್ತು ಗಿಲ್ಯಾದ್ ಪ್ರದೇಶಗಳನ್ನು ನೋಡಿದಾಗ ಅವು ಅವರ ಪಶುಗಳ ಮೇವಿಗೆ ಒಳ್ಳೆಯ ಸ್ಥಳವೆಂದು ತಿಳಿದುಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ಆದ್ದರಿಂದ ರೂಬೇನ್ ಮತ್ತು ಗಾದ್ ಕುಲದವರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದರು. ಅವರು ಮೋಶೆಯ ಸಂಗಡದಲ್ಲೂ ಯಾಜಕನಾದ ಎಲ್ಲಾಜಾರನ ಸಂಗಡದಲ್ಲೂ ಜನರ ನಾಯಕರ ಸಂಗಡದಲ್ಲೂ ಮಾತಾಡಿ ಹೀಗೆ ಹೇಳಿದರು: ");
INSERT INTO kan2010_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“ಯೆಹೋವನು ಇಸ್ರೇಲರಿಗೆ ಅಧೀನಪಡಿಸಿದ ಈ ಪ್ರದೇಶವು ಅಂದರೆ, ಅಟಾರೋತ್, ದೀಬೋನ್, ಯಗ್ಜೇರ್, ನಿಮ್ರಾ, ಹೆಷ್ಬೋನ್, ಎಲೆಯಾಲೆ, ಸೆಬಾಮ್, ನೆಬೋ, ಬೆಯೋನ್ ಎಂಬ ಪಟ್ಟಣಗಳ ಪ್ರದೇಶವು ಪಶುಗಳ ಮೇವಿಗೆ ಒಳ್ಳೆಯ ಸ್ಥಳವಾಗಿದೆ. ನಿಮ್ಮ ದಾಸರಾದ ನಮಗೆ ಬಹಳ ಪಶುಗಳು ಇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ಆದ್ದರಿಂದ ಈ ಪ್ರದೇಶವನ್ನೇ ನಮಗೆ ಸ್ವಾಸ್ತ್ಯವನ್ನಾಗಿ ಕೊಟ್ಟರೆ ನಮಗೆ ಉಪಕಾರ ಮಾಡಿದಂತಾಗುವುದು. ನಾವು ಜೋರ್ಡನ್ ನದಿಯನ್ನು ದಾಟಿ ಹೋಗುವಂತೆ ಮಾಡಬೇಡ.” ");
INSERT INTO kan2010_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ಮೋಶೆಯು ರೂಬೇನ್ ಮತ್ತು ಗಾದ್ ಕುಲಗಳವರಿಗೆ, “ನಿಮ್ಮ ಸಹೋದರರು ಯುದ್ಧಕ್ಕೆ ಹೋಗುವಾಗ ನೀವು ಇಲ್ಲೇ ಕುಳಿತಿರಬೇಕೇ? ");
INSERT INTO kan2010_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ಯೆಹೋವನು ಇಸ್ರೇಲರಿಗೆ ಕೊಟ್ಟ ದೇಶಕ್ಕೆ ಅವರು ಹೋಗದಂತೆ ನೀವು ಯಾಕೆ ಅವರಿಗೆ ಅಧೈರ್ಯವನ್ನು ಹುಟ್ಟಿಸುತ್ತೀರಿ? ");
INSERT INTO kan2010_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ಆ ದೇಶವನ್ನು ನೋಡಿಕೊಂಡು ಬರುವುದಕ್ಕೆ ನಾನು ಕಾದೇಶ್ ಬರ್ನೇಯದಿಂದ ನಿಮ್ಮ ಪೂರ್ವಿಕರನ್ನು ಗೂಢಚಾರರನ್ನಾಗಿ ಕಳುಹಿಸಿದಾಗ ಅವರೂ ಹಾಗೆಯೇ ಮಾಡಿದರಲ್ಲಾ. ");
INSERT INTO kan2010_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ಅವರು ಎಷ್ಕೋಲ್ ತಗ್ಗಿಗೆ ಬಂದು ಆ ದೇಶವನ್ನು ನೋಡಿ ಇಸ್ರೇಲರಿಗೆ ಅಧೈರ್ಯವನ್ನು ಹುಟ್ಟಿಸಿದ್ದರಿಂದ ಇಸ್ರೇಲರು ತಮಗೆ ಯೆಹೋವನು ವಾಗ್ದಾನ ಮಾಡಿದ್ದ ದೇಶಕ್ಕೆ ಹೋಗಲೇ ಇಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ಆಗ ಯೆಹೋವನು ಕೋಪಗೊಂಡು, ");
INSERT INTO kan2010_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","12","‘ಈಜಿಪ್ಟಿನಿಂದ ಬಂದ ಈ ಜನರಲ್ಲಿ ಮತ್ತು ಇಪ್ಪತ್ತು ವರ್ಷ ಮೊದಲುಗೊಂಡು ಅದಕ್ಕಿಂತ ಹೆಚ್ಚು ವಯಸ್ಸಾದ ನಿಮ್ಮವರೆಲ್ಲಾ ಕೆನಿಜ್ಜೀಯನಾದ ಯೆಫುನ್ನೆಯ ಮಗ ಕಾಲೇಬನ ಮತ್ತು ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನ ಹೊರತು ಯಾರೂ ನನ್ನನ್ನು ನಿಜವಾಗಿಯೂ ಅನುಸರಿಸದೆ ಹೋದದ್ದರಿಂದ, ನಾನು ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೋಬರಿಗೆ ಪ್ರಮಾಣಪೂರ್ವಕವಾಗಿ ಕೊಟ್ಟ ದೇಶವನ್ನು ಅವರಿಬ್ಬರೇ ಹೊರತು ಬೇರೆ ಯಾರೂ ನೋಡುವುದೇ ಇಲ್ಲ’ ಎಂದು ಖಂಡಿತವಾಗಿ ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","“ಆದ್ದರಿಂದ ಯೆಹೋವನು ಇಸ್ರೇಲರ ಮೇಲೆ ಕೋಪಗೊಂಡು, ತನ್ನನ್ನು ಬೇಸರಗೊಳಿಸಿದ್ದ ಇಡೀ ತಲೆಮಾರು ಸಾಯುವತನಕ ಇಸ್ರೇಲರನ್ನು ಮರುಭೂಮಿಯಲ್ಲಿ ನಲವತ್ತು ವರ್ಷಗಳ ಕಾಲ ಅಲೆದಾಡಿಸಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ದುಷ್ಟ ಸಂತತಿಯವರೇ, ಈಗ ನೀವು ಯೆಹೋವನ ಭಯಂಕರವಾದ ಕೋಪವನ್ನು ಇನ್ನೂ ಹೆಚ್ಚಾಗಿ ಮಾಡಲು ನಿಮ್ಮ ಪೂರ್ವಿಕರ ಸ್ಥಾನವನ್ನು ತೆಗೆದುಕೊಂಡಿದ್ದೀರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ನೀವು ಆತನನ್ನು ಹಿಂಬಾಲಿಸದೆ ಹೋದರೆ, ಆತನು ಇಸ್ರೇಲರನ್ನು ಮರುಭೂಮಿಯಲ್ಲಿ ಇನ್ನೂ ಹೆಚ್ಚು ಕಾಲ ಬಿಟ್ಟುಬಿಡುವನು. ಈ ಜನರೆಲ್ಲರ ನಾಶನಕ್ಕೆ ನೀವೇ ಕಾರಣರಾಗುವಿರಿ” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ಆಗ ಅವರು ಮೋಶೆಯ ಬಳಿಗೆ ಬಂದು, “ನಮ್ಮ ಪಶುಗಳಿಗಾಗಿ ನಾವು ಬೇಲಿಯನ್ನು ಹಾಕೋಣ ಮತ್ತು ಸ್ತ್ರೀಯರಿಗಾಗಿ ಮತ್ತು ಮಕ್ಕಳಿಗಾಗಿ ಊರುಗಳನ್ನು ಕಟ್ಟುವೆವು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ಬಳಿಕ ಇಸ್ರೇಲರನ್ನು ಅವರವರ ಸ್ಥಳಗಳಿಗೆ ಸೇರಿಸುವವರೆಗೆ ನಾವು ಅವರ ಮುಂದೆ ಹೋಗುವ ಸೈನಿಕರಾಗಿ ಹೊರಡುವೆವು ಅಲ್ಲದೆ ನಮ್ಮ ಸ್ತ್ರೀಯರು ಮತ್ತು ಮಕ್ಕಳು ಈ ದೇಶದ ಇತರ ನಿವಾಸಿಗಳಿಂದ ತೊಂದರೆಗೊಳಗಾಗದೆ ಕೋಟೆಗಳುಳ್ಳ ಊರುಗಳಲ್ಲಿ ಸುರಕ್ಷಿತವಾಗಿರುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ಪ್ರತಿಯೊಬ್ಬ ಇಸ್ರೇಲನು ದೇಶದಲ್ಲಿ ತನಗೆ ಬರಬೇಕಾದ ಸ್ವಾಸ್ತ್ಯವನ್ನು ತೆಗೆದುಕೊಳ್ಳುವ ತನಕ ನಾವು ನಮ್ಮ ಮನೆಗಳಿಗೆ ಹೋಗುವುದಿಲ್ಲ. ");
INSERT INTO kan2010_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ನಮಗೆ ಜೋರ್ಡನ್ ಹೊಳೆಯ ಈಚೆ ಪೂರ್ವದಿಕ್ಕಿನಲ್ಲಿ ಸ್ವಾಸ್ತ್ಯವು ದೊರಕಿದ್ದರಿಂದ ನಾವು ಹೊಳೆಯ ಆಚೆ ಎಲ್ಲಿಯೂ ಅವರೊಂದಿಗೆ ಸ್ವಾಸ್ತ್ಯವನ್ನು ಅಪೇಕ್ಷಿಸುವುದಿಲ್ಲ” ಅಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","22","ಅದಕ್ಕೆ ಮೋಶೆ, “ನೀವು ನಿಮ್ಮ ಮಾತಿನಂತೆ ಯೆಹೋವನ ಮುಂದೆ ಸನ್ನದ್ಧರಾದ ಸೈನಿಕರಾಗಿ ಯುದ್ಧಕ್ಕೆ ಹೋಗುವುದಾದರೆ, ಯೆಹೋವನು ತನ್ನ ವೈರಿಗಳನ್ನು ಓಡಿಸುವ ತನಕ ಮತ್ತು ಆ ದೇಶವನ್ನು ಗೆದ್ದುಕೊಳ್ಳುವ ತನಕ ಪ್ರತಿಯೊಬ್ಬ ಪ್ರವೀಣ ಸೈನಿಕನು ಯೆಹೋವನ ಮುಂದೆ ಜೋರ್ಡನ್ ನದಿಯನ್ನು ದಾಟುವುದಾದರೆ, ಆ ಬಳಿಕ ನೀವು ನಿಮ್ಮ ಮನೆಗಳಿಗೆ ಹಿಂತಿರುಗಬಹುದು ಮತ್ತು ನೀವು ಯೆಹೋವನ ದೃಷ್ಟಿಯಲ್ಲಿಯೂ ಇಸ್ರೇಲರ ದೃಷ್ಟಿಯಲ್ಲಿಯೂ ನಿಮ್ಮ ಕರ್ತವ್ಯವನ್ನು ಮಾಡಿದವರಾಗಿರುವಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ಆದರೆ ನೀವು ಈ ಸಂಗತಿಗಳನ್ನು ಮಾಡದಿದ್ದರೆ, ಯೆಹೋವನಿಗೆ ವಿರೋಧವಾಗಿ ಪಾಪ ಮಾಡಿದವರಾಗಿರುವಿರಿ. ಮತ್ತು ನಿಮ್ಮ ಪಾಪವು ನಿಮ್ಮನ್ನು ಹಿಡಿಯುವ ತನಕ ಹುಡುಕಿಕೊಂಡೇ ಬರುವುದು ಎಂದು ಖಚಿತವಾಗಿ ತಿಳಿದುಕೊಳ್ಳಿರಿ. ");
INSERT INTO kan2010_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ನಿಮ್ಮ ಸ್ತ್ರೀಯರಿಗಾಗಿಯೂ ಮಕ್ಕಳಿಗಾಗಿಯೂ ಊರುಗಳನ್ನು ಕಟ್ಟಿರಿ ಮತ್ತು ಪಶುಗಳಿಗಾಗಿ ದೊಡ್ಡಿಯನ್ನು ಕಟ್ಟಿರಿ. ಬಳಿಕ ನೀವು ವಾಗ್ದಾನ ಮಾಡಿದಂತೆಯೇ ಮಾಡಿರಿ” ಎಂದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ಆಗ ಗಾದ್ಯರು ಮತ್ತು ರೂಬೇನ್ಯರು ಮೋಶೆಗೆ, “ಸ್ವಾಮೀ, ನಾವು ನಿನ್ನ ಸೇವಕರಾಗಿದ್ದೇವೆ. ಆದ್ದರಿಂದ ನೀನು ಆಜ್ಞಾಪಿಸಿದಂತೆಯೇ ನಾವು ಮಾಡುತ್ತೇವೆ. ");
INSERT INTO kan2010_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ನಮ್ಮ ಹೆಂಡತಿಯರು, ಮಕ್ಕಳು, ಪಶುಗಳು ಮತ್ತು ಇತರ ಪ್ರಾಣಿಗಳು ಗಿಲ್ಯಾದಿನ ಊರುಗಳಲ್ಲಿ ವಾಸಿಸುವರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ಆದರೆ ನಿನ್ನ ಸೇವಕರಾದ ನಾವು ಮತ್ತು ದಂಡೆಯಾತ್ರೆಗಾಗಿ ಆರಿಸಲ್ಪಟ್ಟವರು ನಿನ್ನ ಆಜ್ಞೆಯ ಪ್ರಕಾರ ಜೋರ್ಡನ್ ನದಿಯನ್ನು ಯೆಹೋವನ ಮುಂದೆ ದಾಟಿಹೋಗಿ ಹೋರಾಡುತ್ತೇವೆ” ಎಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ಆದ್ದರಿಂದ ಮೋಶೆಯು, ಅವರ ಬಗ್ಗೆ ಯಾಜಕ ಎಲ್ಲಾಜಾರನಿಗೂ ನೂನನ ಮಗನಾದ ಯೆಹೋಶುವನಿಗೂ ಇಸ್ರೇಲ್ ಕುಲಗಳ ಗೋತ್ರಪ್ರಧಾನರಿಗೂ ಆದೇಶಗಳನ್ನು ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ಮೋಶೆ ಅವರಿಗೆ, “ಗಾದ್ ಮತ್ತು ರೂಬೇನ್ ಕುಲಗಳಿಂದ ಯುದ್ಧಕ್ಕಾಗಿ ಆರಿಸಲ್ಪಟ್ಟವರು ಜೋರ್ಡನ್ ನದಿಯನ್ನು ಯೆಹೋವನ ಮುಂದೆ ದಾಟಿ ಆ ದೇಶವನ್ನು ಗೆದ್ದುಕೊಂಡರೆ, ನೀವು ಅವರಿಗೆ ಗಿಲ್ಯಾದ್ ಪ್ರಾಂತ್ಯವನ್ನು ಸ್ವಾಸ್ತ್ಯವಾಗಿ ಕೊಡಬೇಕು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ಆದರೆ ಆರಿಸಲ್ಪಟ್ಟವರು ನಿಮ್ಮೊಂದಿಗೆ ನದಿಯನ್ನು ದಾಟದಿದ್ದರೆ, ಅವರು ನಿಮ್ಮೊಂದಿಗೆ ಕಾನಾನ್ ದೇಶದಲ್ಲಿ ಭೂಮಿಯನ್ನು ಪಡೆದುಕೊಳ್ಳಬೇಕು” ಎಂದು ಹೇಳಿದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ಅದಕ್ಕೆ ಗಾದ್ ಮತ್ತು ರೂಬೇನ್ ಕುಲಗಳವರು ಒಪ್ಪಿ, “ನಿನ್ನ ಸೇವಕರಾದ ನಾವು ಯೆಹೋವನ ಆಜ್ಞೆಯಂತೆಯೇ ಮಾಡುವೆವು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ನಾವೇ ಯುದ್ಧ ಮಾಡುವ ಸೈನಿಕರಾಗಿ ನದಿಯನ್ನು ದಾಟಿ ಯೆಹೋವನ ಮುಂದೆ ಕಾನಾನ್ ದೇಶದೊಳಗೆ ಹೋಗುವೆವು. ಆದರೆ ನಮ್ಮ ಸ್ವಾಸ್ತ್ಯವಾದ ಭೂಮಿಯು ಜೋರ್ಡನ್ ನದಿಯ ಈಚೆಕಡೆಯಲ್ಲಿರುವುದು” ಎಂದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ಆಗ ಮೋಶೆಯು ಗಾದ್ ಮತ್ತು ರೂಬೇನ್ ಕುಲಗಳವರಿಗೆ ಮತ್ತು ಯೋಸೇಫನ ಮಗನಾದ ಮನಸ್ಸೆಯ ಅರ್ಧಕುಲದವರಿಗೆ ಅಮೋರಿಯರ ರಾಜನಾದ ಸೀಹೋನನ ರಾಜ್ಯವನ್ನೂ ಬಾಷಾನಿನ ರಾಜನಾದ ಓಗನ ರಾಜ್ಯವನ್ನೂ ಅವುಗಳ ಎಲ್ಲಾ ಊರುಗಳನ್ನೂ ಆ ಊರುಗಳಿಗೆ ಸೇರಿದ ಭೂಮಿಗಳನ್ನೂ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ಗಾದ್ ಕುಲದವರು ದೀಬೋನ್, ಅಟಾರೋತ್, ಅರೋಯೇರ್, ");
INSERT INTO kan2010_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ಅಟ್ರೋತ್ಷೋಫಾನ್, ಯಗ್ಜೇರ್, ಯೊಗ್ಬೆಹಾ, ಬೇತ್ನಿಮ್ರಾ, ");
INSERT INTO kan2010_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ಬೇತ್‌ಹಾರಾನ್ ಎಂಬ ಕೋಟೆಗಳುಳ್ಳ ಊರುಗಳನ್ನು ಹೊಸದಾಗಿ ಕಟ್ಟಿಕೊಂಡರು ಮತ್ತು ತಮ್ಮ ಪಶುಗಳಿಗಾಗಿ ದೊಡ್ಡಿಗಳನ್ನು ಕಟ್ಟಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","38","ರೂಬೇನ್ ಕುಲದವರು ಹೆಷ್ಬೋನ್, ಎಲೆಯಾಲೆ, ಕಿರ್ಯಾತಯಿಮ್, ನೆಬೋ, ಬಾಳ್ಮೆಯೋನ್ ಮತ್ತು ಸಿಬ್ಮಾ ಎಂಬ ಊರುಗಳನ್ನು ಕೋಟೆ ಸಮೇತವಾಗಿ ಕಟ್ಟಿದರು; ಅಲ್ಲದೆ ತಮ್ಮ ಪಶುಗಳಿಗಾಗಿ ದೊಡ್ಡಿಯನ್ನು ಕಟ್ಟಿದರು. ಅವರು ತಾವು ಮತ್ತೆ ಕಟ್ಟಿದ ಊರುಗಳಿಗೆ ಅವುಗಳ ಮೊದಲಿನ ಹೆಸರುಗಳನ್ನು ಕೊಟ್ಟರು; ಆದರೆ ನೆಬೋ ಮತ್ತು ಬಾಳ್ಮೆಯೋನ್‌ಗಳ ಹೆಸರುಗಳನ್ನು ಬದಲಾಯಿಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ಮಾಕೀರನ ವಂಶದವರು ಗಿಲ್ಯಾದಿಗೆ ಹೋದರು. (ಮಾಕೀರನು ಮನಸ್ಸೆಯ ಮಗ.) ಅವರು ಆ ಪಟ್ಟಣದಲ್ಲಿ ವಾಸಿಸುತ್ತಿದ್ದ ಅಮೋರಿಯರನ್ನು ಓಡಿಸಿ ಅದನ್ನು ವಶಪಡಿಸಿಕೊಂಡರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ಆದ್ದರಿಂದ ಮೋಶೆಯು ಗಿಲ್ಯಾದನ್ನು ಮನಸ್ಸೆಯ ಮಗನಾದ ಮಾಕೀರನ ತಿಯವರಿಗೆ ಕೊಟ್ಟನು. ಮಾಕೀರನ ವಂಶದವರು ಅಲ್ಲಿ ನೆಲೆಸಿದರು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ಮನಸ್ಸೆಯ ಕುಲದವನಾದ ಯಾಯೀರನು ಅಮೋರಿಯರ ಕೋಟೆಗಳುಳ್ಳ ಹಳ್ಳಿಗಳನ್ನು ವಶಪಡಿಸಿಕೊಂಡು ಅವುಗಳಿಗೆ, “ಯಾಯೀರನ ಹಳ್ಳಿಗಳು” ಎಂದು ಹೆಸರಿಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ನೋಬಹ ಎಂಬವನು ಕೆನಾತ್ ಮತ್ತು ಅದರ ಹತ್ತಿರವಿದ್ದ ಚಿಕ್ಕ ಊರುಗಳನ್ನು ವಶಪಡಿಸಿಕೊಂಡು ಅವುಗಳಿಗೆ “ನೋಬಹ” ಎಂಬ ತನ್ನ ಹೆಸರನ್ನೇ ಕೊಟ್ಟನು. ");
INSERT INTO kan2010_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ಮೋಶೆ ಮತ್ತು ಆರೋನರ ನೇತೃತ್ವದಲ್ಲಿ ಈಜಿಪ್ಟ್ ದೇಶದಿಂದ ಹೊರಬಂದ ಇಸ್ರೇಲರ ಪ್ರಯಾಣಗಳ ವಿವರ: ");
INSERT INTO kan2010_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ಮೋಶೆ ಯೆಹೋವನ ಅಪ್ಪಣೆಯನ್ನು ಹೊಂದಿ ಇಸ್ರೇಲರು ಪ್ರಯಾಣಗಳಲ್ಲಿ ಇಳಿದುಕೊಂಡ ಸ್ಥಳಗಳ ಹೆಸರುಗಳನ್ನು ಬರೆದನು. ");
INSERT INTO kan2010_vpl VALUES ("NU33_3","005_33_3","NUM",