﻿USE sofia;
DROP TABLE IF EXISTS sofia.jvnNT_vpl;
CREATE TABLE jvnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jvnNT_vpl WRITE;
INSERT INTO jvnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iki layang turunané mbah-mbahané Gusti Yésus Kristus. Gusti Yésus Kristus kuwi turunané ratu Daved lan ratu Daved turunané Bapa Abraham. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Bapa Abraham kuwi bapaké Isak, Isak bapaké Yakub, Yakub bapaké Yudah sak seduluré. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudah bapaké Pèrès lan Sérak, Tamar ibuné. Pèrès bapaké Kèsrom lan Kèsrom bapaké Aram. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram bapaké Aminadab, Aminadab bapaké Nakson lan Nakson bapaké Salmon. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","6","Salmon bapaké Boas, Rahab ibuné. Boas bapaké Obèd, Rut ibuné. Obèd bapaké Isai lan Isai bapaké ratu Daved. Daved bapaké Soléman, ibuné tilasané Uriah. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soléman bapaké Rekobéam, Rekobéam bapaké Abia, Abia bapaké Asa. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa bapaké Yosafat, Yosafat bapaké Yoram, Yoram bapaké Usia. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia bapaké Yotam, Yotam bapaké Akas lan Akas bapaké Hiskia. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskia bapaké Manasé, Manasé bapaké Amon, Amon bapaké Yosia. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia bapaké Yekonya sak seduluré. Ing waktu kuwi bangsa Israèl diboyong nang tanah Babilon. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nang tanah Babilon kono layang turunan kuwi terusané ngéné: Yekonya bapaké Séaltièl, Séaltièl bapaké Sérubabil. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sérubabil bapaké Abihud lan Abihud bapaké Eliakim. Eliakim bapaké Asur. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asur bapaké Sadok, Sadok bapaké Akim lan Akim bapaké Eliud. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud bapaké Eliasar, Eliasar bapaké Matan, Matan bapaké Yakub. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakub bapaké Yosèf lan Yosèf kuwi bojoné Maria. Maria kuwi sing nglairké Gusti Yésus, sing diarani Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dadi ènèng turunan patbelas ping telu, yakuwi: Patbelas wiwit Abraham tekané Daved, patbelas wiwit Daved tekané beboyongan nang tanah Babilon lan patbelas wiwit beboyongan nang tanah Babilon tekané Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lairé Gusti Yésus Kristus kuwi lakuné ngéné: Maria, ibuné, wis patyangan karo Yosèf. Nanging sakdurungé kawin Maria wis meteng sangka Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Lah jalaran Yosèf kuwi sakwijiné wong sing nglakoni kekarepané Gusti Allah, mulané dèkné ya ora gelem nggawé wirangé Maria nang tengahé wong okèh. Yosèf jawané arep meneng-menengan waé medot pepatyangané karo Maria. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nanging sak barengé nggagas-nggagas bab kuwi, dèkné éntuk impèn. Ing sakjeroné impèn kuwi mulékaté Gusti ngétok marang dèkné ngomong ngéné: “Yosèf, turunané ratu Daved, kowé aja wedi ngepèk Maria dadi bojomu, awit bayi sing digémbol kuwi tekané sangka Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria bakal nglairké anak lanang sing kudu mbok jenengké Yésus, awit Dèkné bakal nylametké bangsané sangka dosané.” ");
INSERT INTO jvnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Kuwi mau kabèh marakké klakon sing wis diomong karo Gusti dèk mbiyèn liwat nabi Yésaya, sing uniné ngéné: “Enèng prawan bakal meteng lan nglairké anak lanang, sing bakal dijenengké Imanuèl, tegesé: Gusti Allah karo awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kadung tangi, Yosèf terus nuruti sing diomong karo mulékaté Gusti mau. Dèkné terus kawin karo Maria. ");
INSERT INTO jvnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nanging Yosèf ora turu tyampur karo Maria nganti lairé anaké lanang. Kadung wis lair botyahé dijenengké Yésus karo Yosèf. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Gusti Yésus lairé nang kuta Bètlehèm, nang distrik Yudéa. Ing waktu kuwi Hérodès sing dadi ratuné kono. Ora let suwi ènèng wong pinter siji-loro sangka bawah wétanan teka nang kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wong-wong iku terus pada takon: “Nang endi awaké déwé bisa nemu ratuné bangsa Ju sing entas lair? Awaké déwé weruh lintangé nang wétan lan awaké déwé teka mbréné arep nyembah marang Dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kadung ratu Hérodès krungu bab iki, dèkné terus kagèt banget, semono uga wong sak kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ratu Hérodès terus kongkonan nyeluk para pengarepé imam lan para guru Kitab kabèh terus ditakoni, nang endi bakalé lairé Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Wong-wong kuwi terus pada semaur: “Nang kuta Bètlehèm nang distrik Yudéa, awit wis ditulis karo nabi Mika ngéné: ‘Kowé Bètlehèm nang tanah Yudah, kowé ora pisan-pisan kuta sing tyilik déwé nang tanah Yudah, awit sangka kowé bakal metu pangon sing bakal nuntun umatku Israèl.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sakwisé éntuk katerangan kuwi, ratu Hérodès terus kongkonan nyeluk wong-wong pinter sangka wétanan mau, nanging tanpa wong okèh ngerti. Wong-wong pinter kuwi terus ditakoni okèh-okèh, kapan lintangé molai kétok. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sakwisé kuwi wong-wong pinter mau terus dikongkon budal nang kuta Bètlehèm. Ratu Hérodès ngomong ngéné marang wong-wong kuwi: “Kana pada budal lan pada nggolèk sak ènèngé kabar bab Bayi kuwi. Nèk wis ketemu, aku diomongi, supaya aku uga bisa nyembah marang Dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wong-wong pinter mau terus pada budal, sakwisé nampa tembungé ratuné. Sak barengé pada mlaku, lintang sing kétok nang wétan ngétok nang ngarepé lan mlaku tekan nduwuré panggonané Botyah Bayiné. Tekan kono lintangé terus mandek. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Weruh lintangé mau, wong-wong pinter kuwi terus pada bungah banget. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Terus pada mlebu omahé lan weruh Bayiné lan Maria, ibuné. Wong-wong pinter mau terus pada sujut lan nyembah marang Bayiné. Sakwisé kuwi terus pada mbukak palisé wadah kasugihané terus ngekèki kado marang Bayiné, yakuwi emas, menyan lan emur. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wong-wong pinter mau mulihé ora mlaku dalan sing diliwati mauné. Awit ing impèn Gusti Allah ngomongi wong-wong kuwi, dipenging balik nang nggoné ratu Hérodès. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sakwisé wong-wong pinter mau pada mulih, terus ènèng mulékaté Gusti Allah ngétok marang Yosèf ing sakjeroné impèn. Mulékaté mau ngomong ngéné: “Yosèf, tangi! Bayiné lan ibuné gawanen lunga nang negara Egipte. Pada manggona nang kana tekané aku ngomongi kowé menèh. Awit ratu Hérodès bakal nggolèki Bayiné arep dipatèni.” ");
INSERT INTO jvnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ing tengah wengi Yosèf tangi, terus Bayiné lan ibuné digawa lunga nang negara Egipte. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yosèf terus manggon nang kono tekan patiné ratu Hérodès. Dadiné klakon tenan tembungé Gusti Allah dèk mbiyèn liwat nabi Hoséa sing uniné ngéné: “Aku nyeluk Anakku sangka Egipte.” ");
INSERT INTO jvnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ratu Hérodès ngerti nèk diapusi karo wong-wong pinter sangka wétanan, mulané terus nesu banget. Dèkné terus mréntah kongkon matèni botyah kabèh nang kuta Bètlehèm lan sak kiwa-tengené, sing umuré rong taun medun. Umur kuwi tyotyok karo waktuné dongé ratu Hérodès takon marang wong-wong pinter. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Dadiné klakon tenan tembungé Gusti Allah liwat nabi Yéremia, sing uniné ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Wong-wong pada krungu swara sesambat lan tangisan seru nang kuta Ramah; awit Rakèl nangisi anak-anaké; ora gelem dilipur, awit anak-anaké wis pada mati.” ");
INSERT INTO jvnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sakwisé ratu Hérodès mati, Yosèf, sing ijik manggon nang negara Egipte, terus éntuk impèn menèh. Mulékaté Gusti ngétok ing impèn kuwi, ngomong ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Yosèf, kana kowé balik menèh nang Israèl karo Bayiné lan ibuné, awit wong-wong sing arep matèni Bayiné wis pada mati.” ");
INSERT INTO jvnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yosèf terus tangi, terus Bayiné lan ibuné digawa balik menèh nang negara Israèl. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nanging kadung Yosèf krungu nèk Arkélaus sing ngganti Hérodès, bapaké, dadi ratuné distrik Yudéa, dèkné terus ora gelem manggon nang kana. Ing impèn liyané Yosèf nampa tembungé Gusti, kongkon lunga nang bawah Galiléa. ");
INSERT INTO jvnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mulané dèkné terus rana lan manggon nang sakwijiné kuta sing jenengé Nasarèt. Dadiné klakon tembungé Gusti Allah liwat para nabi, sing ngomongké nèk Gusti Yésus bakal diarani “Wong Nasarèt.” ");
INSERT INTO jvnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ing waktu kuwi Yohanes Pembaptis molai nggelarké pituturé Gusti Allah nang wustèn nang bawah Yudéa. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Dèkné ngomong ngéné: “Pada ninggala urip sing dosa, awit ora suwi menèh Gusti Allah bakal ngedekké kratoné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ya bab Yohanes iki nabi Yésaya dèk mbiyèn ngomong ngéné: “Nang wustèn ènèng wong bengok-bengok ngomong: ‘Gusti pada digawèkké dalan, pada dilempengké dalan sing arep diambahi.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes nganggo salin gawéan wulu unta lan sabuké lulang. Pangané walang lan maduné tawon alasan. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wong pirang-pirang sangka kuta Yérusalèm, sangka bawah Yudéa lan sak kiwa-tengené laut Yordan pada mara nang nggoné Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wong-wong pada ngakoni dosa-dosané lan pada dibaptis nang laut Yordan. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Uga wong Farisi lan wong Saduki okèh pada mara nang nggoné Yohanes njaluk dibaptis. Yohanes weruh wong-wong mau terus ngomong: “Anakan ula! Sapa ta sing ngomongi kowé nèk bisa nyimpangi setrapané Gusti Allah sing bakal teka? ");
INSERT INTO jvnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kétokna nganggo tindakmu nèk tenan kowé wis ninggal klakuanmu sing dosa kuwi! ");
INSERT INTO jvnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aja mikir dumèh kowé anak turunané Bapa Abraham waé, kuwi wis tyukup. Ngandela omongku iki: Gusti Allah nduwèni kwasa ngekèki anak-turunan marang Bapa Abraham sangka watu-watu iki. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Delokké, kampaké wis dityepakké kanggo negor wité nang poké oyoté. Saben wit sing ora ngetokké woh sing apik bakal ditegor lan dibuwang nang geni. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aku mbaptis kowé karo banyu kanggo tanda nèk kowé wis ninggal urip dosa, nanging ènèng wong liyané bakal teka. Dèkné kwasané ngungkul-ungkuli aku. Kanggo ngutyuli sepatuné waé aku durung pantes. Dèkné sing bakal mbaptis kowé karo Roh Sutyi lan geni. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Dèkné bakal napèni pariné sing wis diiles. Gabahé bakal dilebokké nang lumbung, nanging kapahé bakal diobong nang geni sing ora bisa mati.” ");
INSERT INTO jvnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gusti Yésus lunga sangka bawah Galiléa, budal nang laut Yordan, supaya dibaptis karo Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nanging Yohanes arep menggak Dèkné ngomong: “Aku sing kudu mbok baptis, lah kok malah Kowé sing njaluk tak baptis?” ");
INSERT INTO jvnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nanging Gusti Yésus semaur: “Wis bèn ta, awit awaké déwé kudu nglakoni apa waé sing dikarepké Gusti Allah.” Yohanes terus nuruti apa karepé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sakwisé dibaptis Gusti Yésus terus mentas sangka banyu. Langité terus menga lan Dèkné weruh Roh Sutyi medun kaya manuk dara, méntyloki Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sangka langit terus ènèng swara ngomong: “Iki Anakku sing tak trésnani lan sing ndadèkké legané atiku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sakwisé kuwi Gusti Yésus terus digawa karo Roh Sutyi nang wustèn, supaya digoda karo Sétan. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nang kono Dèkné pasa patang puluh dina patang puluh wengi. Gusti Yésus terus krasa ngelih. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sétan terus marani Dèkné ngomong: “Jaréné Kowé Anaké Gusti Allah? Jajal watu iki dipréntah kongkon dadi roti!” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nanging Gusti Yésus semaur: “Nang Kitab ketulis ngéné: ‘Manungsa uripé ora namung sangka roti waé, nanging uga sangka sak ènèngé tembung sing metu sangka Gusti Allah.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sakwisé kuwi Sétan terus nggawa Gusti Yésus nang kuta sutyi Yérusalèm, diejèk ngadek nang putyuké payoné Gréja Gedé. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Sétan terus ngomong: “Nèk Kowé Anaké Gusti Allah, kana anjlok medun! Nang Kitab lak ketulis ta: ‘Gusti Allah ngongkon para mulékaté mageri kowé. Kowé bakal ditampani nganggo tangané, supaya sikilmu ora kenèng watu!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nanging Gusti Yésus semaur: “Nang Kitab uga ketulis ngéné: ‘Kowé aja nyoba Gusti Allahmu.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sétan terus nggawa Gusti Yésus munggah nang gunung sing duwur banget. Nang kono Gusti Yésus terus kongkon ndelok sakkèhé kraton ing donya sak apik-apikané kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sétan terus ngomong: “Kabèh kuwi bakal tak kèkké Kowé, nèk Kowé gelem sujut nyembah marang Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Gusti Yésus terus ngomong: “Kana lunga Sétan! Nang Kitab ketulis: ‘Nyembaha marang Gusti, Dèkné Allahmu. Namung Dèkné sing kudu mbok ladèni.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sakwisé kuwi Sétan terus lunga. Para mulékat terus teka lan ngladèni Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kadung Gusti Yésus krungu nèk Yohanes dilebokké nang setrapan, Dèkné terus lunga nang bawah Galiléa. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Sangka Nasarèt Dèkné manggon nang Kapèrnakum, sakwijiné kuta nang pinggiré mér Galiléa, nang bawah Sébulon lan Naftali. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Dadiné klakon tembungé Gusti Allah liwat nabi Yésaya, sing uniné ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tanah Sébulon lan tanah Naftali, tanah sing nang sak uruté dalan nang mér, nang sabrangé laut Yordan, tanah Galiléa panggonané bangsa-bangsa liya. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bangsa sing manggon ing pepeteng wis weruh pepadang gedé. Srengéngé wis njedul kanggo wong-wong sing manggon nang tanah sing dikwasani pati.” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ing waktu kuwi Gusti Yésus terus molai mulang, tembungé: “Pada ninggala urip dosa, awit ora suwi menèh Kratoné Gusti Allah bakal diwiwiti.” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Dongé Gusti Yésus mlaku nang pinggiré mér Galiléa kono, Dèkné weruh wong loro kakang-adi, yakuwi Simon sing uga dityeluk Pétrus lan Andréas. Wong loro iki ijik nguntyalké jalané, awit kerjanané nggolèk iwak. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Gusti Yésus nyeluk: “Hayuk pada mèlu Aku. Kowé bakal tak blajari dadi tukang nggolèk wong.” ");
INSERT INTO jvnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Simon lan Andréas terus ninggal jalané lan mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kadung mlaku sedilut menèh terus nemu wong loro menèh, yakuwi Yakobus lan Yohanes, kabèh loro anaké Sébédéus. Wong loro iki karo bapaké ijik pada ndandani jalané nang prauné, terus dityeluk karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sakwat terus pada medun sangka prauné, terus mèlu Gusti Yésus, ninggal bapaké. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Gusti Yésus terus ndlajahi bawah Galiléa. Dèkné memulang nang sinaguk-sinaguk lan nggelarké kabar kabungahan bab Kratoné Gusti Allah. Sing lara pada ditambani sangka pernyakité lan memalané. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kabar bab Gusti Yésus terus sumebar nang seluru bawah Siria. Wong-wong sing lara lan sing nduwé werna-werna pernyakit, sing kesurupan demit, sing lara ayanen lan sing lumpuh pada digawa nang nggoné Gusti Yésus lan kabèh ditambani. ");
INSERT INTO jvnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wong pirang-pirang pada mèlu Gusti Yésus. Enèng sing sangka Galiléa, sangka Dékapolis, sangka Yérusalèm, Yudéa lan sabrangé laut Yordan. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kadung Gusti Yésus weruh wong pirang-pirang kuwi, Dèkné terus munggah nang gunung. Sakwisé Dèkné njagong, murid-muridé terus njagong ngubengi Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Gusti Yésus terus molai mulangi murid-muridé ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Beja wong mlarat sing pada njagakké marang Gusti Allah, awit wong sing kaya ngono kuwi sing nduwèni Kratoné Swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Beja wong sing sedi, awit bakal dilipur karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Beja wong sing andap-asor, awit wong sing kaya ngono kuwi sing bakal nampa prejanjiané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Beja wong sing kepéngin banget nglakoni kekarepané Gusti Allah, awit Gusti Allah bakal nggawé maremé atiné. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Beja wong sing seneng melasi wong liya, awit Gusti Allah uga bakal melasi wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Beja wong sing resik atiné, awit bakal weruh Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Beja wong sing seneng ngrukunké, awit bakal diarani anaké Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Beja wong sing disiya-siya jalaran nglakoni kekarepané Gusti Allah, awit wong sing kaya ngono kuwi sing nduwèni Kratoné Swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Beja kowé, nèk kowé diolok-olok, disiya-siya lan disalah-salahké sing ora-ora, jalaran kowé dadi muridku. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kowé kudu bungah lan sukak-sukak, awit kowé bakal nampa upah gedé nang swarga. Para nabi jaman mbiyèn uga pada disiya-siya kaya kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Gusti Yésus neruské tembungé ngéné: “Kowé kuwi uyahé jagat. Nèk uyah ilang asiné, wis ora ènèng apa-apa menèh sing kenèng kanggo ngasinké. Uyah kuwi ora kanggo gawé apa-apa menèh, kejaba namung dibuwang nang dalan lan diidek-idek wong. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kowé kuwi pepadangé jagat. Kuta sing nang nduwur gunung ora bisa dialing-alingi. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kowé mesti ora nyumet dian terus ditutupi ténggok ta? Ora, mesti diané terus didèkèk sing duwur, supaya bisa madangi kabèh wong sing nang omah kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mulané, kowé uga kudu nylorotké padangmu marang wong-wong, supaya pada weruh penggawému sing betyik. Dadiné wong-wong kuwi pada ngluhurké Bapakmu sing nang swarga.” ");
INSERT INTO jvnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Gusti Yésus ngomong ngéné: “Kowé aja pada mikir nèk Aku iki teka arep ngrombak wèt-wèté nabi Moses. Tekaku iki ora arep ngrombak, ora, nanging Aku malah netepké. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mulané, pada ngertia, suwéné langit lan bumi ijik ènèng, ora bakal ènèng aksara sangka wèté nabi Moses dityorèk, siji waé ora, nganti tekan rampungé. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mulané, sapa sing nerak salah-sakwijiné wèt mau, senajan sing tyilik déwé lan mulangi wong liya nglakoni sing kaya ngono, wong iku bakal éntuk panggonan sing endèk déwé ing Kratoné Swarga. Nanging sapa sing nglakoni wèté nabi Moses sak kabèhé lan mulangi liyané nglakoni kuwi kabèh, wong iku sing bakal éntuk panggonan sing duwur ing Kratoné Swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mulané rungokké tembungku iki: ‘Nèk enggonmu nglakoni wèt-wèté nabi Moses ora ngungkul-ungkuli sing ditindakké karo para guru Kitab lan para Farisi, kowé ora bakal bisa mlebu ing Kratoné Swarga.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Gusti Yésus neruské piwulangé ngéné: “Kowé pada ngerti nèk mbah-mbahané awaké déwé diwulangi ngéné: ‘Aja matèni wong; sapa sing matèni wong kudu dikrutu.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nanging Aku mulangi kowé: sapa sing nesoni liyané kudu dikrutu. Lan sapa sing ngelokké liyané kudu dikrutu karo krutoné Agama. Sapa sing ngelokké liyané ngomong ‘gemblung,’ wong kuwi kudu dityemplungké nang geniné neraka. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Mulané, nèk kowé arep nggawa pawèhmu marang Gusti Allah, nanging kowé kélingan nèk ènèng sakwijiné wong nduwèni prekara karo kowé, pawèhmu disèlèhké nang ngarepé altar ndisik, terus wongé diparani. Nggawéa rukun karo wongé ndisik, terus balik menèh masrahké pawèhmu marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nèk ènèng wong nggawa kowé nang kruton, sakjeroné mlaku rana, kowé kudu nglumui, supaya bisa apik karo wongé. Nèk ora diapiki ndisik, mengko kowé bakal digawa nang nggoné rèkteré. Rèkteré terus masrahké kowé marang sekaut, terus kowé dilebokké nang setrapan. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Lan ngertia, kowé ora bakal bisa metu sangka setrapan kuwi, nèk utangmu durung mbok bayar sak kabèhé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Gusti Yésus ngomong menèh: “Kowé wis pada ngerti piwulang sing uniné ngéné: ‘Kowé aja laku bédang!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nanging aku ngomong iki marang kowé: sapa sing nyawang wong wédok karo rasa seneng ing atiné, wong kuwi wis laku bédang karo wong wédok kuwi ing atiné. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nèk mripatmu tengen marakké kowé nggawé dosa, dityukil waé lan dibuwang. Luwung kowé kélangan mripat siji, tenimbang awakmu sak kujur dityemplungké nang neraka. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nèk tanganmu tengen marakké kowé nggawé dosa, diketok waé terus dibuwang. Luwung kowé kélangan tanganmu sebelah, tenimbang karo awak sak kujur mlebu nang neraka.” ");
INSERT INTO jvnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Gusti Yésus neruské tembungé ngéné: “Uga ènèng piwulang sing uniné ngéné: ‘Sapa sing megat bojoné kudu ngekèki layang pegat.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nanging saiki kowé tak omongi: sapa sing megat bojoné, nanging bojo kuwi ora laku bédang, lah wong kuwi marakké bojoné mau terus laku bédang, nèk sing dipegat mau terus kawin menèh. Lah wong lanang sing kawin karo wong sing dipegat mau ya katut mèlu laku bédang.” ");
INSERT INTO jvnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Gusti Yésus ngomong: “Kowé pada ngerti nèk mbah-mbahané awaké déwé diwulangi ngéné: ‘Kowé aja mblénjani janji. Nèk kowé wis janji karo wong nganggo sumpah karo jenengé Gusti Allah, janji kuwi kudu mbok tetepi.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nanging saiki kowé tak omongi: kowé aja pisan-pisan sumpah. Aja sumpah nyeluk langit, awit langit kuwi jagongané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Lan aja sumpah nyeluk bumi, awit bumi kuwi antyik-antyiké sikilé Gusti Allah. Lan aja sumpah nyeluk jenengé Yérusalèm, awit kuwi kuta panggonané ratuné. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Uga aja sumpah nyeluk sirahmu, awit kowé déwé ora bisa nggawé uwan, sakeler waé ora bisa. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nèk ya, ngomonga ya, nèk ora, ya ngomong ora. Kliwat sangka kuwi metuné sangka Sétan.” ");
INSERT INTO jvnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tembungé Gusti Yésus: “Kowé pada ngerti nèk wèté nabi Moses ngomong ngéné: ‘Sapa sing ngrusak mripat kudu gentèn dirusak mripaté lan sapa sing ngrusak untu kudu gentèn dirusak untuné.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nanging saiki Aku ngomongi kowé: aja mbales marang wong sing nggawé ala marang kowé. Malah nèk ènèng wong ngeplak pipimu tengen, bèn ngeplak pipimu sing kiwa pisan. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Lah nèk ènèng wong arep nggawa kowé nang kruton awit arep njaluk klambimu, malah jasmu dikèkké pisan. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Lah nèk kowé dipeksa wong kongkon nggawakké barangé sak kilomèter, digawa rong kilomèter pisan. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nèk ènèng wong njaluk apa-apa marang kowé, dikèki lan sing arep utang marang kowé ya diutangi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Gusti Yésus neruské tembungé ngéné: “Kowé pada ngerti piwulang iki: ‘Kowé pada trésnaa marang kantya-kantyamu lan pada sengita marang mungsuhmu.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nanging saiki kowé tak omongi: pada trésnaa marang mungsuhmu lan wong sing nggawé ala marang kowé didongakké. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dadiné ketara nèk kowé kuwi pantyèn anaké Gusti Allah Bapakmu sing nang swarga. Awit Gusti Allah Bapakmu nylorotké padangé srengéngé marang wong sing betyik lan sing ala. Gusti Allah Bapakmu uga ngekèki udan marang wong sing nglakoni betyik lan sing nglakoni ala. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lah nèk kowé namung nrésnani wong sing trésna marang kowé, aja njagakké nèk Gusti Allah bakal ngupahi kowé, awit wong sing mata-duwiten waé nglakoni kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Lah nèk kowé namung mbagèkké kantya-kantyamu, lah kowé apa ènèng bédané karo liyané? Wong sing ora kenal marang Gusti Allah ya pada waé kaya ngono. ");
INSERT INTO jvnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mulané, kowé kudu sampurna, kaya enggoné Gusti Allah Bapakmu nang swarga ya sampurna.” ");
INSERT INTO jvnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tembungé Gusti Yésus: “Enggonmu pada nglakoni panyembah kuwi aja kanggo pamèran wong. Mengko ndak Bapakmu nang swarga ora mberkahi kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nèk kowé pawèh duwit, aja diomong-omongké, kaya wong lamis kaé. Wong lamis kuwi lumrahé ngomong-omongké bab betyiké, dikabar-kabarké nang sinaguk-sinaguk lan nang dalan-dalan, supaya dielem wong. Ngertia, wong sing kaya ngono kuwi wis nampa pembalesané penggawéané. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nanging kanggo kowé, nèk kowé pawèh, aja sampèk wong liya ngerti. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Dadiné pawèhmu ora kétok wong, nanging Bapakmu nang swarga ngerti barang sing ora kétok, Dèkné sing bakal ngupahi kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Gusti Yésus ngomong: “Nèk kowé ndedonga, aja kaya wong lamis. Wong lamis kuwi lumrahé pada ndedonga nang sinaguk-sinaguk apa nang dalan-dalan, supaya kétok wong. Ngertia, wong sing kaya ngono kuwi wis nampa upahé. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nanging nèk kowé ndedonga, mlebua nang kamar lan lawangé dikantying, terus ndedongaa marang Bapakmu sing ora kétok. Dèkné ngerti apa sing mbok tindakké, senajan wong liya ora weruh. Gusti Allah Bapakmu bakal ngupahi kowé karo berkah. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nèk kowé ndedonga, aja dawa-dawa, kaya lumrahé wong sing ora kenal marang Gusti Allah. Wong-wong kuwi mikiré Gusti Allah ngrungokké pandongané, jalaran dawa. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aja pada niru wong-wong kuwi, awit Gusti Allah Bapakmu ngerti apa sing mbok butuhké, sakdurungé mbok tembung ing pandonga. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mulané ndedongaa ngéné: ‘Duh Bapaké awaké déwé nang swarga muga Jenengmu kasutyèkna. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Muga kratonmu tumekaa lan kekarepanmu klakonana ing donya kayadéné nang swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nyuwun sandang-pangan saben dina ");
INSERT INTO jvnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","lan pangapura sangka ing dosa awit awaké déwé ya ngapura dosané wong liya. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nyuwun aja sampèk kenèng goda nanging luwarana sangka ala.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nèk kowé ngapura marang wong sing nduwé salah marang kowé, Bapakmu nang swarga ya bakal ngapura salahmu. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nanging nèk kowé ora ngapura salahé liyané, Bapakmu nang swarga ya ora bakal ngapura salahmu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tembungé Gusti Yésus: “Nèk kowé pasa, aja kétok sedi kaya lumrahé wong lamis. Wong-wong kuwi rupané digawé-gawé, supaya kétok sedi, dadiné wong kabèh ngerti nèk ijik pasa. Ngertia, wong sing kaya ngono kuwi wis nampa upahé kaya sak mestiné. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nanging kowé, nèk kowé pasa, kowé raupa lan rambutmu dijungkati. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Dadiné ora ènèng wong ngerti nèk kowé pasa. Namung Bapakmu nang swarga sing ora kétok sing ngerti apa sing mbok lakoni. Dèkné sing bakal ngupahi kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Gusti Yésus neruské piwulangé ngéné: “Aja pada nglumpukké banda ing donya, awit bisa rusak dipangan rayap lan renget lan bisa dityolong maling. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Luwung nglumpukké banda nang swarga waé, awit nang swarga ora ènèng rayap lan renget sing bisa ngrusak lan maling ya ora bisa nyolong. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Awit nang endi bandamu, ya nang kono uga atimu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tembungé Gusti Yésus: “Mripat kuwi diané awak. Nèk mripaté padang, awakmu sak kujur ya padang. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nanging nèk mripatmu peteng, awakmu sak kujur ya peteng uga. Dadiné, nèk dian sing nang awakmu kuwi malih peteng, lah kaya ngapa petengé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tembungé Gusti Yésus: “Ora ènèng wong sing bisa ngrangkep ngladèni gusti loro. Awit wongé bakal sengit karo sing siji lan nrésnani liyané, apa ngelem sing siji lan nyepèlèkké sing liyané. Semono uga kowé, kowé ora bisa ngladèni Gusti Allah lan uga ngladèni duwit.” ");
INSERT INTO jvnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tembungé Gusti Yésus: “Mulané Aku ngomong: aja pada sumelang bab uripmu, bab apa sing mbok pangan lan apa sing mbok ombé lan apa sing mbok enggo. Apa urip kuwi ajiné ora ngungkuli pangan lan awak kuwi ajiné apa ora ngungkuli sandangan? ");
INSERT INTO jvnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mbok disawang manuk-manuk sing mabur nang langit kaé. Lak ya ora pada nyebar lan ya ora pada ngunduh lan ya ora pada nyimpen panènané nang lumbung. Nanging Bapakmu nang swarga ngopèni manuk-manuk kuwi. Apa ajiné uripmu ora ngungkul-ungkuli manuk-manuk kuwi? ");
INSERT INTO jvnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Apa nang tengahmu ènèng sing bisa nyambung uripé nganggo sumelang? ");
INSERT INTO jvnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Lah kenèng apa kok pada sumelang bab sandangan? Mbok disawang kembang-kembang sing tukul nang kebon kaé. Kembang-kembang kuwi lak ya ora pada nyambutgawé apa nggawé salin ta? ");
INSERT INTO jvnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nanging sawangen déwé, gèk ratu Soléman waé sing sugihé kaya ngono ora nduwé salin sing apiké kaya kembang-kembang kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Semono uga suket-suket nang kebon, sing dina iki tukul lan sésuk diobong. Kuwi waé diapik-apik tenan karo Gusti Allah. Lah kowé menèh! Gusti Allah mesti bakal nyandangi kowé ngungkul-ungkuli suket-suket kuwi. Nanging kowé pada tyilik pengandelé. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mulané, aja pada sumelang lan aja pada bingung bab apa sing mbok pangan lan mbok ombé lan mbok enggo. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Awit kuwi prekara-prekara sing dipikir karo wong-wong sing ora kenal marang Gusti. Bapakmu nang swarga lak wis ngerti nèk barang-barang kuwi kabèh mbok butuhké. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mulané, sing kudu mbok pikir sing ndisik déwé kuduné Kratoné Gusti Allah lan kepriyé enggonmu bisa nuruti kekarepané. Mengko Gusti Allah bakal ngekèki kowé barang-barang liyané sing mbok butuhké. ");
INSERT INTO jvnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mulané, aja pada sumelang bab dina sésuk, awit dinané sésuk ènèng karépotané déwé. Ngrasakké karépotané dina iki waé wis abot, aja ditambahi karo karépotané dina sésuk.” ");
INSERT INTO jvnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Gusti Yésus neruské piwulangé ngéné: “Aja pada maido liyané, supaya Gusti Allah ora maido kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Awit Gusti Allah bakal maido kowé manut tyarané enggonmu maido liyané. Lan Dèkné bakal ngukur kowé nganggo ukuran sing mbok kanggokké kanggo ngukur liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kenèng apa kowé kok ndelokké klilip nang mripaté liyané, nanging balok nang mripatmu déwé kowé ora weruh. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Lah kepriyé kowé kok wani ngomong karo liyané: ‘Kéné klilip sing nang mripatmu tak buwangé,’ nanging mripatmu déwé ènèng baloké. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kowé kuwi wong lamis. Balok sing nang mripatmu kuwi dibuwang ndisik, dadiné kowé bisa weruh mat lan bisa mbuwang klilip sing nang mripaté liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Barang sing sutyi aja dikèkké asu, mengko ndak asuné balik nyatèk kowé. Lan parel aja dikèkké babi, mengko ndak diidek-idek nganggur.” ");
INSERT INTO jvnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tembungé Gusti Yésus: “Nèk kowé njaluk, kowé mesti bakal dikèki; nèk kowé nggolèk, kowé mesti bakal nemu; nèk kowé totok-totok lawang, mesti kowé bakal dibukakké. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Awit sapa sing njaluk bakal nampa lan sapa sing nggolèk bakal nemu lan sapa sing totok lawang bakal dibukakké. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Para bapak sing nang kéné iki, mosok nèk anakmu njaluk roti mbok kèki watu? Mesti ora ta! ");
INSERT INTO jvnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Apa nèk anakmu njaluk iwak terus mbok kèki ula? Mesti ora ta! ");
INSERT INTO jvnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Lah nèk kowé waé, wong sing ala, bisa ngekèki barang sing apik marang anak-anakmu, lah Bapakmu sing nang swarga menèh? Mosok Dèkné ora bakal ngekèki barang sing apik marang sapa waé sing pada njaluk marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mulané apa sing mbok karepké supaya ditindakké karo wong liya marang kowé, kuwi kudu mbok tindakké marang liyané. Awit kuwi isiné angger-angger sing diwulangké karo nabi Moses lan nabi liya-liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Gusti Yésus mulangi ngéné: “Pada mlebua liwat lawang sing tyiyut, awit lawang sing amba lan dalan sing jembar kuwi nggawa kowé nang karusakan lan wong okèh sing pada milih dalan iku. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nanging lawang sing tyiyut lan dalan sing tyiyut kuwi nggawa kowé nang kauripan lan namung wong setitik pada milih dalan kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Gusti Yésus neruské piwulangé ngéné: “Pada sing ati-ati karo nabi-nabi sing palsu. Wong-wong kuwi tekané nang nggonmu kaya wedus manut, nanging wujuté beburon sing galak. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wong-wong kuwi ketarané sangka penggawéné. Mosok tukulan eri ngetokké woh dreif lan rerungkutan ngetokké woh jambu? Mesti ora ta! ");
INSERT INTO jvnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Wit sing apik mesti ya ngetokké woh sing apik lan wit sing èlèk mesti ya ngetokké woh sing èlèk. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Wit sing apik ora bisa ngetokké woh sing èlèk lan wit sing èlèk ora bisa ngetokké woh sing apik. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Saben wit sing ora ngetokké woh sing apik bakal ditegor lan diobong. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mengkono kuwi kowé bisa nitèni nabi sing palsu, sangka penggawéné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Gusti Yésus ngomong: “Sing mlebu ing Kratoné Swarga kuwi ora wong sing ngomong ‘Gusti, Gusti’ marang Aku, ora, nanging saben wong sing nglakoni kekarepané Bapakku nang swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ing dina kruton okèh wong bakal ngomong marang Aku: ‘Gusti, Gusti, awaké déwé lak ngabarké pituturé Gusti Allah ing jenengmu ta? Lan awaké déwé lak nundungi demit ing jenengmu ta lan awaké déwé ya nindakké mujijat ing jenengmu uga?’ ");
INSERT INTO jvnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nanging Aku bakal semaur: ‘Aku blas ora kenal marang kowé. Pada lungaa sangka ngarepku, kowé wong sing seneng nggawé ala!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Gusti Yésus neruské piwulangé ngéné: “Wong sing ngrungokké lan nglakoni piwulangku kuwi kenèng tak padakké karo wong pinter sing ngedekké omahé nang panggonan sing atos. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kadung udané deres lan banyuné laut munggah ngelepké panggonané kabèh lan angin gedé ngantemi omahé, omahé ora rubuh, awit ngadek nang panggonan sing atos. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Lah wong sing ngrungokké piwulangku, nanging ora dilakoni, kuwi kenèng dipadakké karo wong bodo sing ngedekké omahé nang lemah santi. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kadung ènèng udan deres lan banyuné laut munggah ngelepké panggonané lan angin gedé ngantemi omahé, omahé terus ambruk, rusak sak kabèhé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sakwisé Gusti Yésus rampung sing memulang, wong kabèh pada nggumun banget marang piwulangé. ");
INSERT INTO jvnNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Awit Dèkné sing mulang nganggo pangwasa, séjé karo guru Kitab. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Dongé Gusti Yésus medun sangka gunung, wong pirang-pirang pada ngetutké Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nang kono ènèng wong lara lépra mara nang nggoné Gusti Yésus, terus sujut nang ngarepé. Wongé ngomong: “Duh Gusti, nèk kowé gelem, mesti kowé bisa nambani aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Gusti Yésus terus ngelungké tangané lan ndemèk wongé karo ngomong: “Aku gelem, dadia waras!” Sakwat wongé terus mari tenan. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Wongé terus dipenging karo Gusti Yésus, ora éntuk ngomong-omongké bab lelakon kuwi marang wong liyané, nanging dikongkon nang nggoné imamé, supaya weruh nèk dèkné wis mari tenan. Wongé uga dikongkon ngekèki kurbané miturut pernatané nabi Moses kanggo tanda nèk wongé wis mari tenan. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dongé Gusti Yésus mlebu kuta Kapèrnakum ènèng ofisir Rum marani Dèkné, njaluk tulung ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Gusti, peladènku lara nang omah. Dèkné wis ora bisa apa-apa, namung ngrasakké lara tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Gusti Yésus semaur: “Ya, Aku arep teka nambani dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nanging ofisiré semaur: “Duh Gusti, aku iki ora pantes didayohi Gusti nang omahku. Mbok Gusti ngetokké tembung sak ketyap waé, mengko peladènku mesti bakal mari. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Awit aku déwé ya ing sak ngisoré penggedéku, nanging aku déwé ya nduwé soldat-soldat ing sak ngisorku, sing kudu manut marang aku. Nèk aku mréntah sing siji ngomong: ‘Kana lunga,’ wongé ya lunga lan nèk liyané tak tyeluk: ‘Réné,’ wongé mesti ya teka. Nèk aku ngomong karo peladènku: ‘Iki ditandangi,’ mesti ya ditandangi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Gusti Yésus nggumun krungu tembungé ofisir kuwi. Dèkné terus ngomong marang wong-wong sing pada mèlu: “Tenan, Aku durung tau tumon wong sing nduwé pengandel semono gedéné nang tengahé wong Israèl. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Titènana ta, wong pirang-pirang bakal teka sangka wétan lan kulon lan pada pésta bebarengan karo Bapa Abraham, Isak lan Yakub ing Kratoné Swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nanging wong-wong sing sak mestiné kudu manggon ing Kratoné Gusti Allah malah bakal diusir metu, dilebokké nang panggonan sing peteng-ndedet. Nang kono wong-wong kuwi bakal nangis lan kerot untu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Gusti Yésus terus ngomong marang ofisiré: “Kana mulih, bakal klakon manut pengandelmu.” Lan ing waktu kuwi uga peladèné mari. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Dongé Gusti Yésus teka nang omahé Pétrus, Dèkné weruh nèk ibu-maratuwané Pétrus lara panas nang ambèn. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gusti Yésus terus ndemèk tangané wongé, wongé terus mari. Wongé terus tangi lan ngladèni Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kadung wis surup wong-wong sing kesurupan demit terus pada digawa nang nggoné Gusti Yésus. Demit-demité pada ditundungi karo tembung sak ketyap lan sing lara pada diwaraské kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Gusti Yésus nindakké kuwi mau kabèh, supaya klakon sing diomong karo nabi Yésaya dèk mbiyèn, sing uniné ngéné: “Dèkné wis nyangga kasangsarané awaké déwé lan lelarané awaké déwé Dèkné wis nambani.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gusti Yésus weruh nèk wong pirang-pirang pada ngrubung Dèkné, mulané Dèkné terus ngongkon murid-muridé ngabrah mér. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ing waktu kuwi ènèng sakwijiné guru Kitab mara nang nggoné Gusti Yésus ngomong: “Guru, aku arep mèlu Kowé, nang endi waé aku arep mèlu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Gusti Yésus nyauri wongé ngéné: “Asu alasan nduwé rong lan manuk nduwé susuk, nanging Anaké Manungsa ora nduwé panggonan kanggo ngglétak lan lèrèn.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Terus ènèng murid liyané ngomong ngéné marang Gusti Yésus: “Gusti, aku dililani ngubur bapakku ndisik.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Gusti Yésus nyauri ngéné: “Kowé mèlua Aku, sing mati bèn ngubur tunggalé sing pada mati.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Gusti Yésus terus mlebu nang prau lan murid-muridé pada mèlu. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ora let suwi terus ènèng ombak gedé nang mér kono lan ombaké ngontang-antingké prauné. Ing waktu kuwi Gusti Yésus ijik turu. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Murid-muridé terus marani lan nggugah Dèkné: “Gusti, awaké déwé ditulungi. Prauné kelep.” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Gusti Yésus terus ngomong: “Kenèng apa kowé kok pada wedi? Kok tyilik pengandelé!” Gusti Yésus terus tangi lan mréntah angin lan ombak kongkon mandek. Anginé lan banyuné terus anteng. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wong-wong sing nang kono pada nggumun lan ngomong: “Wong iki sapa ta? Angin lan ombak kok pada manut marang tembungé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kadung Gusti Yésus wis tekan abrahan, nang bawah Gadarah, terus ènèng wong loro metuki Dèkné. Wong loro iki kesurupan demit lan tekané sangka guwa-guwa kuburan. Wong-wong iki medèni tenan, mulané ora ènèng wong sing wani liwat dalan kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wong-wong kuwi terus pada bengok-bengok marang Gusti Yésus, ngomong: “Duh Anaké Gusti Allah, awaké déwé arep mbok kapakké? Apa awaké déwé arep mbok setrap? Saiki lak durung waktuné ta?” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ora adoh sangka kono ènèng babi pirang-pirang ijik pada nggolèk pangan. Demit-demité mau terus pada nyuwun marang Gusti Yésus, ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","“Nèk awaké déwé niyat arep mbok kongkon metu, awaké déwé dililani mlebu nang babi-babi kaé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Gusti Yésus ngomong: “Kana pada metua!” Demit-demit mau terus pada metu sangka wong loro kuwi, terus pada mlebu nang babi-babiné. Babi-babi mau terus pada mblayu sangka pinggir gunung kono, njegur nang mér terus pada mati kelep kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wong-wong sing angon babi-babi mau terus pada mblayu nang kuta, ngomongké bab lelakon kuwi lan uga bab wong loro sing mauné kesurupan demit. ");
INSERT INTO jvnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wong sak kuta kabèh terus pada teka marani Gusti Yésus. Kadung ketemu terus pada nyuwun tenanan marang Dèkné, supaya lunga sangka panggonan kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Gusti Yésus terus munggah nang prau lan ngabrah balik menèh nang kuta panggonané, yakuwi Kapèrnakum. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nang kono terus ènèng wong pada teka nggotong wong lumpuh nganggo peturoné. Kadung Gusti Yésus weruh gedéné pengandelé wong-wong kuwi, Dèkné terus ngomong marang wongé sing lumpuh: “Aja wedi, dosa-dosamu wis dingapura.” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nang kono ènèng guru-guru Kitab sing pada mbatin: “Wong iki nyepèlèkké Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nanging Gusti Yésus ngerti batinané para guru Kitab kuwi, mulané terus ngomong: “Kenèng apa kowé kok pada nduwèni gagasan sing ala? ");
INSERT INTO jvnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gampang sing endi, ngomong: ‘Dosamu wis dingapura,’ apa: ‘Ngadek lan mlakua?’ ");
INSERT INTO jvnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","7","Nanging Aku arep nduduhké marang kowé, nèk Anaké Manungsa nduwèni kwasa ngapura dosa nang jagat kéné.” Gusti Yésus ngomong marang wong sing lumpuh: “Ngadeka! Peturonmu diangkat lan kana mulih.” Wongé terus ngadek lan mlaku mulih. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wong-wong sing weruh lelakon kuwi mau pada nggumun kabèh lan pada memuji marang Gusti Allah, awit Gusti Allah gelem ngekèki pangwasa semono gedéné marang manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Gusti Yésus terus lunga sangka panggonan kono. Dèkné weruh wong belasting ijik njagong nang kantoré. Wong belasting iki jenengé Matéus. Gusti Yésus ngomong marang Matéus: “Hayuk mèlu Aku!” Matéus terus ngadek, terus mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Dongé Gusti Yésus ijik mangan nang omahé Matéus, wong belasting pirang-pirang lan wong-wong liyané sing dianggep wong ala, uga pada teka lan mangan bebarengan karo Gusti Yésus lan murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wong Farisi siji-loro sing weruh kuwi terus pada takon marang murid-muridé Gusti Yésus: “Kenèng apa gurumu kok mangan bebarengan karo wong belasting lan wong ala?” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Gusti Yésus krungu kuwi terus ngomong: “Wong sing waras ora mbutuhké dokter, nanging sing lara. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dipikir apa tegesé ayat nang Kitab sing uniné: ‘Sing tak karepké ora kurban, nanging tumindak katrésnan!’ Awit tekaku iki ora nggolèki wong sing ngakuné wis apik uripé, ora, nanging Aku nggolèki wong sing ala.” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sakwisé kuwi murid-muridé Yohanes Pembaptis pada teka nang nggoné Gusti Yésus, terus takon: “Awaké déwé lan para Farisi pada nglakoni pasa, nanging murid-muridmu kok ora?” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Gusti Yésus semaur ngéné: “Dipikir! Mosok dayoh nang kawinan kaé pada sedi nèk mantèné lanang ijik nang kono? Mesti ora ta? Nanging ènèng waktuné mantèné lanang digawa lunga sangka kono. Ing waktu kuwi dayohé bakal pada pasa. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ora ènèng wong nambal salin lawas nganggo bakal sing anyar. Awit tambalané kuwi bakal mengkeret lan nyuwèkké saliné luwih amba. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Semono uga ora ènèng wong nyimpen anggur sing anyar nang kantongan lulang sing lawas, awit mengko kantongané mesti bakal bedah. Angguré bakal wutah lan kantongané bakal ora kanggo gawé menèh. Apiké, anggur sing anyar ya kudu disimpen nang kantongan sing anyar, supaya angguré lan kantongané bisa tetep apik.” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dongé Gusti Yésus ijik omong-omongan karo murid-muridé Yohanes Pembaptis mau, terus ènèng penggedéné sinaguk teka lan niba nang ngarepé, nyuwun: “Duh Gusti, anakku wédok entas waé ninggal, nanging nèk Gusti gelem teka lan ndemèk dèkné, mesti dèkné bisa urip menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Gusti Yésus terus ngadek lan mèlu wongé, bareng karo murid-muridé uga. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nanging nang kono uga ènèng wong wédok sing lara ngetokké getih, wis rolas taun suwéné. Wongé nyedeki Gusti Yésus sangka mburi terus ndemèk gombyoké saliné. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Awit wongé mikir: “Nèk aku bisa ndemèk saliné waé, mesti aku bisa mari.” Mulané wongé terus ndemèk saliné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nanging Gusti Yésus terus minger. Kadung weruh wong wédoké, Dèkné terus ngomong: “Aja wedi, pengandelmu sing nambani kowé.” Sakwat wongé terus mari. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kadung Gusti Yésus wis tekan omahé penggedéné sinaguk, Dèkné weruh wong-wong sing ngunèkké suling lan wong okèh liyané sing pada tangisan. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Gusti Yésus terus ngomong: “Kana pada metu! Botyahé ora mati, namung turu.” Wong-wong pada ngguyu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kadung wong-wong wis pada metu, Gusti Yésus terus mlebu nang kamaré botyahé. Tangané botyahé terus dityekel, botyahé terus sakwat tangi. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kabar bab lelakon kuwi terus sumebar nang sak bawah kono kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dongé Gusti Yésus lunga sangka kono, terus ènèng wong lamur loro nututi Dèkné. Wong-wong kuwi bengok-bengok: “Turunané ratu Daved, mbok melas karo awaké déwé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kadung Gusti Yésus wis tekan omahé déwé, wong lamur loro mau terus mara nang nggoné Dèkné. Gusti Yésus terus takon marang wong loro mau: “Apa kowé pretyaya nèk Aku bisa nambani mripatmu?” Wong loro mau semaur: “Ya Gusti, awaké déwé pretyaya!” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Gusti Yésus terus ndemèk mripaté wongé karo ngomong: “Apa pengandelmu bakal klakon!” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wong-wong kuwi terus bisa weruh menèh. Pada dipenging tenanan karo Gusti Yésus, ora éntuk ngomong-omongké bab kuwi marang sapa-sapa. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nanging kadung wis lunga sangka kono, wong loro mau meksa ngomong-omongké bab Gusti Yésus marang saben wong nang bawah kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kadung wong loro mau wis lunga, terus ènèng wong bisu digawa nang nggoné Gusti Yésus. Wongé dikwasani demit. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kadung demité wis dietokké karo Gusti Yésus, wongé terus bisa ngomong menèh. Wong-wong sing weruh pada nggumun kabèh lan ngomong: “Awaké déwé durung tau weruh kaya ngono kuwi nang negara Israèl kéné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nanging para Farisi ngomong: “Wongé bisa ngetokké demit kuwi jalaran éntuk pangwasa sangka penggedéné demit.” ");
INSERT INTO jvnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Gusti Yésus terus lunga ndlajahi kuta-kuta lan désa-désa. Dèkné memulang nang sinaguk-sinaguk lan nggelarké kabar kabungahan bab Kratoné Gusti Allah. Gusti Yésus uga nambani wong-wong sing nduwé werna-werna lara lan memala. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Saben-saben nèk Gusti Yésus weruh wong pirang-pirang kuwi, Dèkné sedi atiné, jalaran melas banget. Awit wong-wong kuwi kétoké kesel lan ora kopèn, kaya wedus sing ora nduwé pangon. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Gusti Yésus terus ngomong marang murid-muridé: “Sing kudu dienèni okèh, nanging bauné setitik. ");
INSERT INTO jvnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mulané pada nyuwuna marang sing nduwé panènané, supaya nambahi wongé sing panèn.” ");
INSERT INTO jvnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ing sakwijiné dina Gusti Yésus nglumpukké muridé rolas. Murid-muridé iki pada dikèki pangwasa ngetokké demit lan nambani sak wernané lara lan memala. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jenengé rasul rolas iki: Simon, sing uga dityeluk Pétrus, Andréas, seduluré; Yakobus lan Yohanes, kabèh loro anaké Sébédéus. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Uga Filipus lan Bartoloméus, Tomas lan Matéus, wong belasting; Yakobus anaké Alféus, uga Tadéus. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Uga Simon, sing diparapi Patriot lan Yudas Iskariot. Yudas iki sing ngelungké Gusti Yésus marang mungsuhé. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Gusti Yésus terus ngongkon rasul rolas budal nganggo tembung ngéné: “Aja pada nekani panggonané bangsa sing dudu Ju lan aja mlebu kutané bangsa Samaria. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sing mbok parani ndisik kuduné wong Israèl sing ketriwal. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pada dikabari nèk saiki Kratoné Swarga wis diwiwiti. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wong lara pada diwarasna lan wong mati pada ditangèkna. Wong lara lépra pada dimarèkna lan demit-demit pada tundungana. Kowé pada nampa pangwasa tanpa mbayar apa-apa, mulané pangwasa kuwi dikanggokna tanpa njaluk bayaran. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aja pada sangu duwit, ora duwit emas, ora duwit selaka apa duwit kopro. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Aja nggawa kantongan apa sèrep salin lan sepatu lan aja nggawa teken. Awit wong nyambutgawé kuwi wis sak mestiné dityukupi butuhé. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nèk kowé teka nang sakwijiné kuta apa désa, nggolèka wong sing gelem mbok inepi lan nginepa nang omah kuwi nganti lungamu sangka kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nèk kowé mlebu nang omahé wong, wongé dibagèkké ngéné: ‘Muga Gusti Allah mberkahi kowé kabèh!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nèk wongé gelem nampani kowé, pamujimu berkah kuwi bakal nekani brayat kuwi. Nanging nèk wongé ora gelem nampani kowé, pamujimu berkah bakal balik menèh marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nèk ènèng omah apa kuta sing ora gelem nampani kowé apa ora gelem ngrungokké piwulangmu, lungaa sangka panggonan kono lan lemahé diketok-ketokké sangka sikilmu. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Pretyayaa, mbésuk ing dina kruton setrapané wong sing manggon nang kuta-kuta kuwi aboté bakalé ngungkul-ungkuli setrapané kuta Sodom lan Gomorah!” ");
INSERT INTO jvnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Gusti Yésus neruské tembungé marang rasul rolas mau: “Dirungokké sing apik! Kowé tak kongkon budal kaya wedus sing dietyulké nang tengahé asu alasan. Mulané kowé kudu sing ati-ati kaya ula lan atimu sing resik kaya manuk dara. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sing ati-ati ing apa waé, awit kowé bakal dityekel lan digawa nang ngarepé Kruton Agama. Kowé bakal dipetyuti nang sinaguké wong-wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kowé bakal digawa nang ngarepé para pangwasa lan para ratu, jalaran kowé nglabuhi Aku. Kuwi kelunggaranmu kanggo ngekèki paseksi bab Aku marang para penggedé lan marang wong-wong sing ora kenal marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nanging nèk kowé dikongkon maju nang ngarepké kruton, aja pada wedi bab kepriyé sing ngomong lan apa sing kudu mbok omong. Awit ing waktu kuwi Gusti Allah bakal ngekèki tembungé marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Awit dudu kowé sing bakal ngomong, nanging Rohé Gusti Allah Bapakmu sing bakal ngomong lantaran kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Bakal klakon ènèng wong masrahké seduluré déwé supaya dipatèni. Semono uga bapak bakal masrahké anaké supaya dipatèni. Anak-anak bakal nglawan marang bapa lan ibuné lan bakal masrahké wong tuwané supaya dipatèni. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wong kabèh bakal sengit marang kowé, jalaran kowé mèlu Aku. Nanging sapa sing mantep tekan entèk-entèkané, kuwi sing bakal slamet. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nèk kowé dikuya-kuya nang sakwijiné kuta, pada lungaa nang kuta liyané. Pretyayaa, Anaké Manungsa bakal teka, sakdurungé kowé kemput enggonmu nglakoni kongkonanmu nang kuta-kuta sak Israèl kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Murid mesti ora ngungkuli guruné lan slaf mesti ora ngungkuli sing nduwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kanggo murid mesti ya wis tyukup nèk bisa kaya guruné, semono uga slaf, ya wis tyukup nèk bisa kaya sing nduwé. Lah nèk sing nduwé omah waé diarani Bèlsebul, lah brayaté sak omah menèh ora diarani kepriyé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Gusti Yésus neruské tembungé ngéné: “Aja pada wedi marang wong-wong kuwi. Apa sing ditutupi bakal kétok lan apa sing didelikké bakal kebukak. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Apa sing tak omongké marang kowé ing petengan kudu mbok kabarké ing padangan. Apa sing dibisik-bisikké nang kupingmu, kuwi diomong-omongké nang endi-endi. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aja pada wedi marang manungsa, awit manungsa namung bisa matèni badané. Pada wedia marang Gusti Allah sing bisa matèni badan lan nyawamu pisan nang neraka. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Manuk tyilik loro lak ora ènèng ajiné ta regané? Nanging ora ènèng sijia tiba nang lemah tanpa Bapakmu nglilani. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lah kowé menèh, gèk rambut nang sirahmu waé wis diitung kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mulané aja pada wedi. Kanggo Gusti Allah kowé kuwi ajiné ngungkuli sak ènèngé manuk tyilik kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tembungé Gusti Yésus: “Sapa sing ngakoni nèk dadi muridku nang ngarepé wong, Aku ya bakal ngakoni nang ngarepé Gusti Allah Bapakku, nèk wong kuwi pantyèn muridku. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nanging sapa sing wedi ngakoni nèk dadi muridku nang ngarepé wong, Aku ya bakal nyélaki dèkné nang ngarepé Bapakku nang swarga.” ");
INSERT INTO jvnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Gusti Yésus terus ngomong: “Kowé aja mikir nèk tekaku nggawa rukun nang jagat. Ora, tekaku ora nggawa rukun, nanging malah misah. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tekaku malah misah anak lanang sangka bapaké lan anak wédok sangka ibuné, uga anak wédok mantu sangka ibu maratuwané. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Malah wong sak omah bakal dadi mungsuh marang sakpada-pada.” ");
INSERT INTO jvnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Gusti Yésus neruské tembungé ngéné: “Sapa sing nrésnani bapa apa biyungé ngungkuli enggoné nrésnani Aku, wong kuwi ora pantes dadi muridku. Uga wong sing nrésnani anaké lanang apa anaké wédok ngungkuli enggoné nrésnani Aku, wong kuwi uga ora pantes dadi muridku. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sapa sing ora gelem manggul pentèngané lan nurut Aku, kuwi ora pantes dadi muridku. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sapa sing ngéman uripé, kuwi malah bakal kélangan uripé. Nanging sapa sing ora wedi kélangan uripé kanggo Aku, iku sing bakal nemu uripé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Gusti Yésus ngrampungké piwulangé marang rasul rolas ngéné: “Sapa sing nampani kowé, kuwi uga nampani Aku. Lan sapa sing nampani Aku, kuwi ya nampani Bapakku nang swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sapa sing nampani wong kongkonané Gusti Allah, jalaran wongé kongkonané Gusti Allah, wong kuwi bakal nampa upah sing bakal dikèkké marang wong kongkonané Gusti Allah mau. Sapa sing nampani wong betyik, jalaran wong betyik, wong kuwi ya bakal nampa upahé wong betyik kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sapa sing ngekèki ngombé marang salah-sakwijiné muridku sing tyilik iki, jalaran muridku, senajan namung banyu anyes sak gelas, pretyayaa, wong kuwi bakal nampa upah.” ");
INSERT INTO jvnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sakwisé rampung enggoné ngekèki pitutur marang muridé rolas, Gusti Yésus terus lunga sangka panggonan kono, arep memulang lan nggelarké kabar kabungahan nang kuta-kutané bangsa Ju kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohanes, sing ing waktu kuwi ijik nang setrapan, krungu kabar bab penggawéné Kristus. Dèkné terus kongkonan murid-muridé siji-loro nang nggoné Gusti Yésus, kongkon takon ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Apa Kowé kuwi wong sing kudu teka, apa awaké déwé kudu ngarep-arep wong liyané?” ");
INSERT INTO jvnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Gusti Yésus semaur ngéné: “Kana pada balika lan Yohanes diomongi bab apa sing kowé krungu lan apa sing kowé weruh. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kowé pada weruh nèk wong lamur bisa weruh menèh, wong lumpuh bisa mlaku menèh, sing lara lépra awaké bisa resik menèh, sing budek bisa krungu, wong mati pada diuripké menèh lan kabar kabungahané Gusti Allah digelarké marang wong mlarat. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Beja wong sing ora mangu-mangu bab Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sakwisé murid-murid mau pada balik, Gusti Yésus terus ngomong ngéné bab Yohanes marang wong-wong: “Dongé kowé pada marani Yohanes nang wustèn kaé, sakjané kowé mikir bakal weruh apa? Apa ndarani kowé bakal weruh damèn sing keterak angin rana-réné? Lak ya ora ta? ");
INSERT INTO jvnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Lah weruh apa? Apa wong sing nganggo salin sing larang? Wong sing nganggo salin apik-apik kuwi manggoné nang palès. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lah kowé pada nang wustèn kuwi kepéngin weruh apa? Apa kepéngin weruh nabi? Ya bener, kowé malah weruh wong sing ngungkuli nabi. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Awit ya bab Yohanes iki sing wis ketulis nang Kitab ngéné: ‘Iki kongkonanku, sing tak kongkon budal ndisik nggawèkké dalan kowé!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Pada dititèni ta! Nang sak jagat iki ora ènèng wong sing ngungkuli Yohanes Pembaptis. Nanging senajan ngono, wong sing tyilik déwé ing Kratoné Gusti Allah ijik ngungkuli Dèkné gedéné. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Wiwit Yohanes Pembaptis memulang tekan sepréné, Kratoné Swarga dilawan karo wong-wong sing pada karep ngwasani nganggo peksa. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Piwulangé wèté nabi Moses lan para nabi liyané nganti sak tekané Yohanes Pembaptis, kabèh pada ngomongké bab Kratoné Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nèk kowé gelem pretyaya marang piwulang mau, ngertia, nèk Yohanes Pembaptis kuwi nabi Elia, sing wis diomongké nèk bakal teka. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sapa sing nduwé kuping, pada rungokké. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Wong-wong jaman saiki kenèng tak padakké karo apa ya? Eling-éling kaya botyah-botyah sing pada dolanan nang lataré pasar kaé; sing sak krompol tyeluk-tyeluk marang krompolan liyané ngomong ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Awaké déwé main lagu bungah-bungah, nanging kowé ora gelem njogèt. Awaké déwé singi lagu susah, kowé ora nangis.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Dongé Yohanes teka, dèkné ora mangan lan ngombé, kabèh wong ngomong nèk dèkné dikwasani demit. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lah dongé Anaké Manungsa teka, Dèkné mangan lan ngombé, kabèh wong ngomong: ‘Delokké kaé, wong murka lan tukang ngombé, kantyané wong belasting lan wong ala.’ Nanging Gusti Allah gedé kaweruhé lan kaweruhé diwujutké nganggo penggawéné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gusti Yésus terus maido kuta-kuta sing ora pada gelem ninggal dosané lan nganyarké uripé, senajan Dèkné nindakké mujijat-mujijat sing okèh déwé nang kuta-kuta kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Tembungé Gusti Yésus ngéné: “Tyilaka kowé, Korasim! Tyilaka kowé uga, Bètsaida! Awit semunggoné nang kuta Sidon lan Tirus ènèng mujijat kaya sing ènèng nang tengahmu, wong-wong nang kono mesti wis mbiyèn-mbiyèn pada ngakoni salahé lan pada nganggo salin sakah lan usapan awu sirahé kanggo ngétokké kasusahané. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pada titènana! Mbésuk ing dina kruton kuta Tirus lan Sidon setrapané bakalé luwih èntèng nèk dipadakké karo setrapanmu. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Uga kowé sing manggon nang kuta Kapèrnakum. Apa kowé bakal dijunjung munggah swarga? Ora bakal! Kowé malah bakal dityemplungké nang neraka. Awit semunggoné nang kuta Sodom ènèng mujijat-mujijat kaya sing ènèng nang tengahmu, kuta Sodom mesti saiki ijik ènèng. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nanging Aku ngomong marang kowé, mbésuk ing dina kruton wong-wong nang kuta Sodom malah bakal nampa kawelasan sing luwih gedé tenimbang kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ing waktu kuwi Gusti Yésus maturkesuwun marang Gusti Allah, tembungé: “Duh Allah Bapakku, Gustiné langit lan bumi, Aku maturkesuwun marang Kowé, awit Kowé nyimpen prekara-prekara iki kanggo wong sing pinter lan sing nduwé kaweruh, nanging mbok udarké kanggo wong sing tyilik. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pantyèn ya ngono Bapakku, iki pantyèn wis dadi karep lan senengmu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Gusti Yésus neruské tembungé ngéné: “Bapakku wis masrahké sembarang marang Aku. Ora ènèng wong sing ngerti Anaké, kejaba Bapaké lan ora ènèng sing ngerti Bapaké, kejaba Anaké lan wong-wong sing dikenalké karo Anaké marang Bapaké. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kabèh wong sing kangèlan lan kabotan, pada mbrénéa nang nggonku. Aku bakal ngekèki ayem lan tentrem marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Piwulangku dilakoni lan pituturku digatèkké. Atimu mesti bakal ayem, awit Aku iki alus lan andap-asor. ");
INSERT INTO jvnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Piwulangku ora angèl lan momotanku kuwi èntèng.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ing sakwijiné dina sabat Gusti Yésus mlaku liwat kebon gandum. Murid-muridé krasa ngelih, mulané pada ngepèki wohé gandum terus dipangan. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kadung wong Farisi weruh kuwi, terus pada ngomong marang Gusti Yésus: “Delokké kuwi, murid-muridmu pada nerak angger-angger, awit pada nglakoni prekara sing dilarang ing dina sabat.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Gusti Yésus semaur ngéné: “Apa kowé ora pada matya nang Kitab bab sing ditindakké karo Daved, dongé dèkné lan kantya-kantyané pada ngelih? ");
INSERT INTO jvnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dèkné mlebu nang omahé Gusti Allah terus mangan roti sing dipasrahké marang Gusti Allah, uga kantya-kantyané sing mèlu dèkné. Mangka miturut pernatané agama Ju namung para imam sing kelilan mangan roti kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Apa kowé ora matya nang wèté nabi Moses nèk para imam sing saben dina sabat ladèn nang omahé Gusti Allah sakjané pada nerak pernatané dina sabat, nanging ora pada dianggep salah. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kowé pada tak omongi: nang kéné iki ènèng sing ngungkuli omahé Gusti Allah kwasané. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nang Kitab lak ènèng tulisan ngéné ta: ‘Sing tak karepké kuwi kawelasan, ora kurban.’ Nèk kowé dunung tegesé tulisan kuwi, kowé mesti ora bakal nyalahké wong-wong sing bener. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Awit Anaké Manungsa sing kwasa ngarani apa sing kelilan lan sing ora kelilan ing dina sabat.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Gusti Yésus terus lunga sangka kono arep nang sinaguké wong-wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nang sinaguk kono ènèng wong sing tangané lumpuh. Enèng wong siji-loro sing pantyèn nuju arep nggolèki salahé Gusti Yésus. Wong-wong iki takon marang Dèkné: “Apa éntuk nambani wong ing dina sabat?” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Gusti Yésus terus semaur: “Semunggoné nang tengahmu ènèng wong sing nduwé wedus siji, terus wedus kuwi ketyemplung nang luwangan ing dina sabat. Mosok wongé ora ndang nyandak wedusé ditarik sangka luwangané? ");
INSERT INTO jvnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lah manungsa ajiné apa ora ngungkul-ungkuli wedus? Mulané ya éntuk nulungi wong ing dina sabat.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Gusti Yésus terus ngomong marang wong sing lara tangané: “Tanganmu dietungké!” Wongé terus ngetungké tangané lan saiki tangan kuwi wis waras kaya tangan sing liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nanging para Farisi terus pada metu lan pada rembukan kepriyé enggoné arep matèni Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kadung Gusti Yésus krungu bab kekarepané para Farisi mau, Dèkné terus lunga sangka kono. Wong okèh pada mèlu Dèkné. Kabèh wong sing lara pada diwaraské. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nanging kabèh pada diwanti-wanti, dipenging ngomong-omongké bab Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kuwi marakké klakon tembungé Gusti Allah dèk mbiyèn liwat nabi Yésaya, sing uniné ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iki Peladènku, Dèkné sing tak pilih. Dèkné sing tak trésnani, sing ndadèkké senengé atiku. Dèkné bakal tak kèki Rohku. Dèkné bakal ngabarké marang kabèh bangsa bab kabeneranku. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Peladènku ora bakal tukar-padu apa gembar-gembor. Ora ènèng wong sing bakal krungu swarané nang dalan-dalan. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Damèn sing pepes ora bakal dityoklèk lan sentir sing murupé ketip-ketip ora bakal dipatèni. Peladènku bakal temen terus ngudi nganti kabeneran nduwèni kamenangan. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ya Peladènku iki sing bakal dadi pengarep-arepé kabèh bangsa.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Terus ènèng wong nggawa wong lamur sing uga bisu nang nggoné Gusti Yésus. Wongé dikwasani demit. Gusti Yésus nambani wongé terus bisa ngomong lan weruh menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wong kabèh pada nggumun tenan lan pada ngomong: “Apa iki dudu turunané ratu Daved ya, sing wis diomongké nèk bakal teka?” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kadung para Farisi krungu wong-wong ngomong ngono, terus pada semaur: “Wong kuwi bisa ngetokké demit, awit dikèki pangwasa karo Bèlsebul, ratuné demit-demit.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Gusti Yésus ngerti pikirané para Farisi mau, mulané terus ngomong: “Negara sing rayaté pada tyongkrèh mesti bakal ambruk. Semono uga kuta apa brayat, nèk pada memungsuhan marang sakpada-pada, mesti bakal bubrah. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Lah nèk demit nundung demit, tibaké kratoné Sétan ya tyongkrèh lan ya ora bisa ngadek? ");
INSERT INTO jvnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kowé ngomong nèk Aku nundung demit, awit Bèlsebul sing ngekèki pangwasa marang Aku. Nèk ngono, lah murid-muridmu kuwi sing nundungi demit éntuk pangwasa sangka endi? Murid-muridmu déwé tandané nèk pikiranmu kuwi klèru. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aku nundungi demit kuwi sangka Rohé Gusti Allah, sing ngekèki pangwasa marang Aku. Kuwi tandané nèk Kratoné Gusti Allah wis nekani kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Apa ènèng wong bisa ngleboni omahé wong sing rosa awaké terus nyolong sembarangé? Mesti ora bisa! Malingé kudu bisa mbanda sing nduwé omah ndisik, sakdurungé ngusungi sembarangé. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Wong sing ora ngrujuki Aku, kuwi tegesé nglawan Aku. Lan sapa sing ora mèlu Aku ngumpulké wong-wong, kuwi tegesé malah mbuyarké. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mulané kowé tak omongi: sakkèhé dosa lan pengolok-olok marang Gusti Allah bakal dingapura. Nanging sapa sing ngolok-olok marang Roh Sutyi ora bakal dingapura. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nèk ènèng wong ngolok-olok Anaké Manungsa, wong kuwi bakal dingapura. Nanging wong sing ngolok-olok marang Roh Sutyi, wong kuwi ora pisan-pisan bakal dingapura, ora bakal dingapura ing jaman saiki lan uga ora dingapura ing jaman sing bakal teka.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Gusti Yésus neruské tembungé: “Wit sing apik mesti ya ngetokké wong sing apik. Nèk wité ala, wohé ya ala. Awit wohé kuwi ngétokké apik-èlèké wité. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kowé kuwi anakan ula! Kepriyé kowé bisané ngomongké sing betyik, nèk atimu déwé ala? Awit apa sing metu sangka lambé, kuwi metuné sangka ati. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wong betyik kuwi atiné ya mesti betyik lan bakal bisa ngetokké barang sing betyik sangka simpenané. Nanging wong ala, atiné ya ala lan ya ngetokké barang sing ala sangka simpenané. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mulané pada ngertia: ing dina kruton kabèh wong bakal kudu asok penjawab bab saben tembung sing ngawur waé. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Awit tembung-tembungmu déwé sing bakal ngarani kowé bener apa salah.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ing waktu kuwi ènèng guru Kitab lan wong Farisi siji-loro sing ngomong marang Gusti Yésus: “Guru, awaké déwé kepéngin weruh tandané sangka Kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nanging Gusti Yésus semaur: “Pantyèn ala tenan lan gedé tenan dosané wong jaman saiki. Pada njaluk tanda pangwasa, nanging ora bakal nampa tanda, kejaba tandané nabi Yonah. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kaya enggoné nabi Yonah nang wetengé iwak telung dina telung wengi, mengkono uga Anaké Manungsa bakal nang kubur telung dina telung wengi. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mbésuk ing dina kruton wong-wong kuta Ninewé bakal pada ditangèkké bareng karo wong-wong iki lan bakal nyalahké wong-wong iki. Awit dongé wong Ninewé krungu tembungé Gusti Allah sing digelarké karo nabi Yonah, wong-wong kuwi terus pada njaluk ngapura marang Gusti Allah lan ninggal laku sing ala. Lah mangka sing ngadek nang kéné iki gedéné ngungkuli nabi Yonah. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mbésuk ing dina kruton ratu wédok sangka bawah kidul bakal maju lan bakal nyalahké wong-wong iki. Awit ratu kuwi teka sangka pojoké bumi, kepéngin ngrungokké kaweruhé ratu Soléman. Lah mangka sing ngadek nang kéné iki ngungkuli ratu Soléman.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Gusti Yésus neruské tembungé ngéné: “Nèk ènèng demit metu sangka sakwijiné wong, demit mau terus mlaku-mlaku nang panggonan sing ora kanggonan wong, nggolèk panggonan kanggo lèrèn, nanging ora nemu. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Demité terus mikir: ‘Enaké tak balik waé nang omah sing wis tak tinggal.’ Demité terus balik nang omahé lan weruh nèk saiki wis resik lan ditata apik. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Demit mau terus lunga nggolèki kantyané, terus balik nggawa demit pitu, sing alané ngungkul-ungkuli dèkné déwé. Demit-demit kuwi terus manggon ing wong mau. Entèk-entèké wong kuwi kasusahané malah ngungkul-ungkuli mauné, dongé namung kanggonan demit siji.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Dongé Gusti Yésus ijik omong-omongan karo wong-wong kuwi, ibuné lan sedulur-seduluré pada ngentèni nang njaba, kepéngin ketemu karo Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Terus ènèng wong sing ngomongi Dèkné: “Guru, ibumu lan sedulur-sedulurmu pada nang njaba, kepéngin metuki Kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Gusti Yésus semaur: “Ibuku lan sedulur-sedulurku kuwi sapa ta?” ");
INSERT INTO jvnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Gusti Yésus terus nduding murid-muridé karo ngomong: “Iku ibuku lan sedulur-sedulurku! ");
INSERT INTO jvnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Awit sapa sing nglakoni kekarepané Bapakku sing nang swarga, ya iku sedulurku lanang lan sedulurku wédok lan ibuku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ing dina kuwi uga Gusti Yésus lunga sangka omahé, budal nang pinggir mér terus njagong nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wong pirang-pirang pada teka ngrubung Dèkné, mulané Dèkné terus munggah nang prau lan njagong nang kono. Wong okèh mau pada ngadek nang pinggir mér. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Gusti Yésus terus mulangi wong-wong bab werna-werna prekara nganggo gambar. Gusti Yésus ngomong ngéné: “Enèng wong budal nang keboné arep nyebar. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Dongé nyebar wijiné ènèng sing tiba nang pinggir dalan. Manuké pada teka terus mangani wiji-wiji mau. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wijiné uga ènèng sing tiba nang panggonan sing atos, sing lemahé tipis. Wijiné ya gelis tukulé, awit lemahé ora jeru. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nanging kadung panasé banter, wini mau alum terus garing, awit durung bisa ngoyot. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Enèng wiji liyané tiba nang tengahé tukulan eri. Kadung tukulan eri mau mundak gedé, winihé terus kalah karo tukulané eri, terus mati. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nanging uga ènèng wiji sing tiba nang lemah sing subur, terus ngetokké woh okèh. Enèng sing wiji siji dadi satus, ènèng sing dadi swidak lan ènèng sing dadi telung puluh.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gusti Yésus terus nutup piwulangé ngomong ngéné: “Sapa sing nduwé kuping, rungokké sing apik tembungku kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Murid-muridé Gusti Yésus terus mara nang nggoné Dèkné, takon: “Apa jalarané nèk Gusti mulangi wong-wong kok nganggo gambar?” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Gusti Yésus semaur: “Karepé Gusti Allah, supaya namung kowé sing bisa dunung wewadiné Kratoné Gusti Allah, ora wong kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Awit wong sing wis nduwé kuwi bakal dikèki nganti lubèr. Nanging wong sing ora nduwé, apa nduwéné malah bakal karebut. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kuwi jalarané Aku nèk mulang wong okèh nganggo gambar. Awit senajan mripaté pada ndeleng, nanging ora weruh lan senajana kupingé krungu, nanging pada ora dunung. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Dadiné bisa klakon apa sing wis diomong karo nabi Yésaya dèk mbiyèn, sing uniné ngéné: ‘Kowé bakal bolak-balik krungu, nanging ora dunung. Kowé bakal bolak-balik ndeleng, nanging ora weruh. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Awit bangsa iki ndablek, kupingé budek lan mripaté merem rapet. Awit semunggoné ora ngono, mesti mripaté weruh lan kupingé krungu, pikirané bisa dunung terus pada teka marani Aku lan ninggal uripé sing dosa, mesti terus tak waraské. Kuwi tembungé Gusti Allah.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nanging beja kowé, awit mripatmu weruh lan kupingmu krungu. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngertia, okèh nabi lan wong betyik sing pada kepéngin ndeleng apa sing mbok deleng, nanging ora klakon ndeleng. Uga pada kepéngin krungu apa sing kowé krungu, nanging ora klakon.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Gusti Yésus terus ndunungké ngéné: “Pada dirungokké tegesé gambar wong nyebar wiji mau. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wong sing krungu piwulang bab Kratoné Gusti Allah, nanging ora dunung, kuwi kaya wiji sing tiba nang pinggir dalan. Sétan teka terus ngrebut piwulang sing disebar ing atiné. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lah wiji sing tiba nang lemah atos, kuwi nggambarké wong sing ngrungokké piwulangé terus pretyaya karo bungah. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nanging piwulang mau durung mrasuk jeru ing atiné. Kadung katekan kasusahan lan kangèlan jalaran sangka enggoné pretyaya, wongé semplak pengandelé. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lah wiji sing tiba nang tengahé tukulan eri, kuwi nggambarké wong sing ngrungokké piwulangé terus pretyaya, nanging terus sumelang banget. Piwulang mau ora bisa ngetokké woh, jalaran kalah karo pikiran bab kabutuhané urip lan banda donya. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nanging wiji sing tiba nang lemah sing subur, kuwi nggambarké wong sing ngrungokké piwulangé terus mantep pengandelé. Wong kuwi terus ngetokké woh okèh, ping satus, ping swidak lan ping telung puluh.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Gusti Yésus terus ngekèki gambar liyané kanggo mulangi wong-wong. Tembungé ngéné: “Kratoné Swarga kuwi kenèng dipadakké karo tukang tandur. Wongé nyebar wiji sing apik nang keboné. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nanging ing wayah wengi, nèk wong-wong pada turu, mungsuhé wong tandur mau teka terus nyebar wiji suket nang tengahé tanduran gandum mau, terus lunga. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kadung wiji gandumé tukul lan ngetokké woh, suketé terus kétok. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Wong-wong sing kerja terus mara nang nggoné sing tukang tandur terus ngomong: ‘Lah Bapak nandur wiji sing apik nang keboné, lah tukulan suket kuwi sangka endi?’ ");
INSERT INTO jvnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sing tukang tandur terus semaur: ‘Kuwi penggawéné mungsuh.’ Sing kerja mau terus pada ngomong: ‘Apa karepé Bapak suketé dijabuti waé?’ ");
INSERT INTO jvnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nanging wongé semaur: ‘Aja, awit nèk suketé mbok jabuti, mengko tandurané gandum uga katut kejabut.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bèn suketé tukul bareng karo gandumé tekan wayahé panèn. Mengko nèk wayahé panèn aku bakal ngomongi sing kerja, supaya pada nglumpukké suketé ndisik terus ditalèni lan diobong. Sakwisé kuwi terus gandumé sing dienèni lan disimpen nang lumbungku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Gusti Yésus terus mulangi wong-wong menèh nganggo gambar liyané. Dèkné ngomong ngéné: “Kratoné Swarga kuwi kenèng dipadakké karo wiji sing tyilik banget, sing ditandur karo wong nang keboné. Wiji kuwi tyilik banget, nanging nèk wis tukul gedéné ngungkuli tanduran liya-liyané. Malah dadi wit lan manuk-manuk terus pada nggawé susuk nang pangé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sakwisé kuwi Gusti Yésus terus ngekèki gambar liyané, uniné ngéné: “Kratoné Swarga kenèng dipadakké karo ragi. Enèng wong wédok njikuk ragi mau terus dityampurké glepung telung takeran, sampèk raginé mrasuk nang glepungé kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gusti Yésus mulangi wong-wong bab kuwi mau kabèh nganggo gambar. Dèkné nèk mulangi mesti nganggokké gambar kanggo ndunungké. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Dadiné keturutan tembungé sakwijiné nabi dèk mbiyèn sing ngomong: “Nèk aku mulang, aku nganggokké gambar. Aku bakal ndunungké prekara-prekara sing kasimpen wiwit jagat digawé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sakwisé Gusti Yésus ngongkon wong-wong lunga, Dèkné terus mulih. Murid-muridé terus pada mara lan takon: “Gusti, mbok awaké déwé didunungké tegesé gambar tukulan suket.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Gusti Yésus terus ngomong ngéné: “Wong sing nyebar wiji sing apik kuwi Anaké Manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Keboné kuwi ya jagat iki. Wiji sing apik kuwi wong-wong umaté Kratoné Allah. Lah tukulan suket kuwi wong-wong balané Sétan. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mungsuh sing nyebar wiji suket kuwi Sétan déwé. Wayah panèn kuwi entèk-entèkané jaman lan sing kerja panèn kuwi para mulékat. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Lah kaya enggoné tukulan suket kuwi dilumpukké terus diobong nang geni, ya ngono kuwi mbésuk ing entèk-entèkané jaman. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Anaké Manungsa bakal ngongkon mulékat-mulékaté nglumpukké sembarang sing marakké nggawé ala lan kabèh wong sing pada nglakoni dosa, dipisah sangka Kratoné Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wong-wong kuwi bakal dityemplungké nang pawon sing murup. Nang kono bakal pada tangisan lan kerot untu. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nanging wong sing pada nglakoni kekarepané Gusti Allah bakal semlorot kaya srengéngé ing kratoné Bapaké. Wong sing nduwé kuping, pada dirungokké!” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Gusti Yésus neruské piwulangé ngéné: “Kratoné Swarga kuwi kenèng dipadakké karo kasugihan sing dipendem nang lemah. Terus ènèng wong sing nemu, nanging terus dihuruki menèh. Sangking bungahé, wongé terus ngedol kabèh apa nduwéné, terus balik nuku keboné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Piwulangé Gusti Yésus sing liyané uniné ngéné: “Kratoné Swarga kuwi kenèng dipadakké karo sakwijiné tukang dagang sing nggolèk parel sing larang regané. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ing sakwijiné dina dèkné weruh parel kuwi. Wongé terus ngedol sembarang nduwéné kanggo nuku parel sing larang regané kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Gusti Yésus neruské piwulangé ngéné: “Kratoné Swarga kuwi kenèng dipadakké karo jala sing diuntyalké nang mér lan éntuk iwak werna-werna. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nèk jalané wis kebek terus ditarik nang daratan karo sing nggolèk iwak. Wong-wong kuwi terus njagong milihi iwak-iwaké. Sing apik diwadahi, lah sing èlèk dibuwang. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ya ngono kuwi bakalé ing entèk-entèkané jaman. Mulékat-mulékat bakal budal lan misahké wong ala sangka tengahé wong betyik. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Wong-wong sing ala mau terus dityemplungké nang pawon sing murup. Nang kono wong-wong kuwi bakal tangisan lan kerot untu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Gusti Yésus terus takon marang murid-muridé: “Apa kowé pada dunung kuwi mau kabèh?” Semauré murid-muridé: “Ya Gusti, awaké déwé dunung.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gusti Yésus terus ngomong ngéné: “Mulané saben guru Kitab sing dadi umaté Kratoné Swarga kenèng dipadakké karo pemimpiné omah sing ngetokké barang sing anyar lan sing lawas sangka godangé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Sakwisé Gusti Yésus rampung enggoné mulangi nganggo gambar-gambar mau, Dèkné terus lunga sangka panggonan kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Gusti Yésus terus teka nang kuta Nasarèt, panggonané sedulur-seduluré. Nang kono Dèkné mulangi wong-wong nang sinaguk. Wong-wong sing ngrungokké pada nggumun banget lan rasan-rasan marang sakpada-pada: “Wong iki éntuk kaweruh sing kaya ngono kuwi sangka ngendi ya? Lan sangka ngendi Dèkné éntuk pangwasa kanggo nindakké mujijat-mujijat kuwi? ");
INSERT INTO jvnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Apa Dèkné dudu anaké sing tukang nggawé krosi-méja kaé? Apa dudu anaké Maria, tunggalé Yakobus, Yosèf, Simon lan Yudas? ");
INSERT INTO jvnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sedulur-seduluré wédok lak kabèh manggon nang kuta kéné ta? Lah sangka ngendi kapinterané kuwi kabèh?” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wong-wong pada nampik Gusti Yésus. Gusti Yésus terus ngomong ngéné marang wong-wong kuwi: “Pantyèn, nabi kuwi nang endi waé diajèni, kejaba nang panggonané lan omahé déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mulané nang kuta Nasarèt kono Gusti Yésus ora nindakké mujijat okèh, awit wong-wong nang kono ora pretyaya marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ing waktu kuwi Hérodès dadi ratuné distrik Galiléa. Dèkné uga krungu kabar-kabar bab Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Hérodès terus ngomong marang para peladèné: “Yésus kuwi ora liya, mesti Yohanes Pembaptis, sing urip menèh. Mulané dèkné bisa nindakké mujijat-mujijat kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ya ratu Hérodès iki sing mbiyèn ngongkon nyekel Yohanes Pembaptis, terus diketyèk lan dilebokké nang setrapan. Ratu Hérodès nindakké kuwi nuruti karepé Hérodias. Awit Yohanes kerep ngomong marang ratu Hérodès, nèk dèkné ora kenèng ngepèk Hérodias dadi bojoné, awit Hérodias kuwi bojoné Filipus, seduluré ratu Hérodès déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mulané ratu Hérodès kepéngin matèni Yohanes, nanging dèkné wedi karo wong-wong, awit wong-wong nganggep Yohanes kuwi nabi sangka Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nanging dongé Hérodès ngurmat tutup tauné, anaké Hérodias njogèt kanggo para dayohé. Ratu Hérodès seneng banget karo jogètané botyah wédok mau. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Dèkné sampèk ngetokké janji ngéné marang botyahé: “Apa waé sing mbok jaluk bakal tak turuti.” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jalaran ibuné botyah wédok mau sing ngajani, botyahé terus ngomong: “Aku njaluk endasé Yohanes Pembaptis nang piring.” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hérodès sedi banget krungu penjaluké botyahé, nanging jalaran dèkné wis kadung janji nang ngarepé wong okèh, mulané dèkné ya terus ngongkon nuruti apa penjaluké botyah wédok mau. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yohanes terus diketok guluné nang setrapan kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Endasé terus dikèkké botyahé nang piring, terus dipasrahké marang ibuné karo botyahé. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Murid-muridé Yohanes terus teka nang setrapan njikuk layoné arep dikubur. Sakwisé kuwi terus pada ngabari Gusti Yésus bab lelakon kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Sakwisé krungu kabar bab ninggalé Yohanes, Gusti Yésus terus lunga déwékan sangka kono, numpak prau nang panggonan sing sepi. Nanging wong-wong ngerti parané Gusti Yésus, mulané terus pada mlaku nusul Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kadung Gusti Yésus medun sangka prauné, Dèkné weruh wong okèh mau, terus krasa melas banget. Wong-wong sing lara terus pada diwaraské. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kadung wis soré murid-muridé terus mara nang nggoné Gusti Yésus ngomong: “Saiki wis soré lan nang panggonan kéné ora ènèng apa-apa. Mbok wong-wong pada dikongkon lunga, bèn nggolèk mangan déwé nang désa-désa.” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nanging Gusti Yésus semaur: “Wong-wong ora usah lunga, kowé sing kudu ngekèki mangan wong-wong!” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Murid-muridé terus ngomong: “Awaké déwé namung nduwé roti lima lan iwak loro!” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Gusti Yésus semaur: “Gawanen mbréné!” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wong-wong terus dikongkon njagong nang suketan karo Gusti Yésus. Dèkné terus njikuk roti lima lan iwak loro mau, terus nyawang nduwur lan maturkesuwun marang Gusti Allah. Rotiné terus dityuwil-tyuwil, terus dikèkké marang murid-muridé. Murid-muridé terus ngedum rotiné marang wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wong kabèh pada mangan sampèk warek. Sakwisé mangan, turahané roti lan iwak mau dilumpukké karo para murid, ènèng rolas ténggok kebek. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Sing mangan ènèng wong limang èwu, namung wong lanangé, wong wédok lan botyah-botyah durung diitung. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sakwisé kuwi Gusti Yésus terus ngongkon murid-muridé budal ndisik karo prauné nang abrahan. Wong okèh mau terus dikongkon mulih. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kadung wong-wong wis lunga, Gusti Yésus terus munggah gunung arep ndonga, déwékan. Mbengi kuwi Gusti Yésus nang kono déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ing waktu kuwi murid-muridé wis nang tengah-tengah mér. Prauné diontang-antingké karo ombak, awit anginé nampek. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kira-kira jam telu mbengi Gusti Yésus nusul murid-muridé, Dèkné mlaku nang banyu. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kadung murid-muridé weruh Gusti Yésus mlaku nang banyu, terus pada wedi banget. Sangking wediné terus pada njerit: “Enèng mokmedi!” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nanging Gusti Yésus terus ngomong: “Aja pada kagèt. Iki Aku. Wis aja pada wedi!” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Rasul Pétrus terus ngomong: “Gusti, nèk pantyèn Kowé tenan, mbok aku dityeluk supaya marani Kowé mlaku nang banyu!” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Gusti Yésus terus ngomong: “Ya, mbrénéa Pétrus!” Rasul Pétrus terus metu sangka prauné lan mlaku nang banyu, marani Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nanging kadung rasul Pétrus weruh banteré anginé nang mér kono, dèkné terus wedi lan molai mendelep karo bengok-bengok: “Gusti, aku ditulungi!” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gusti Yésus terus gelis-gelis ngelungké tangané lan nyekel rasul Pétrus, terus ngomong: “Kok tyilik temen pengandelmu? Kenèng apa kok terus mangu-mangu?” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kadung Gusti Yésus lan rasul Pétrus wis nang prauné, anginé terus mandek. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Murid-murid sing nang prau mau terus pada sujut lan nyembah marang Gusti Yésus tembungé: “Gusti, Kowé pantyèn Anaké Gusti Allah tenan!” ");
INSERT INTO jvnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kadung wis pada ngabrah, Gusti Yésus lan murid-muridé terus pada tekan bawah Genésarèt. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wong-wong kono pada nitèni nèk sing teka kuwi Gusti Yésus, terus pada ngabari wong-wong sak kiwa-tengené panggonan kono kabèh. Wong-wong sing lara terus pada digawa nang nggoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wong-wong kuwi pada nyuwun, supaya pada kelilan ndemèk gombyoké saliné Gusti Yésus. Kabèh sing ndemèk malih waras. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Ing sakwijiné dina ènèng wong Farisi lan guru Kitab sangka kuta Yérusalèm mara nang nggoné Gusti Yésus terus takon ngéné: “Kenèng apa murid-muridmu kok nerak pernatané mbah-mbahané awaké déwé? Nèk mangan kok ora pada wisuh tangan ndisik?” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Gusti Yésus semaur ngéné: “Lah kowé kok pada nerak angger-anggeré Gusti Allah, awit namung kepéngin netepi adat-pernatané mbah-mbahanmu? ");
INSERT INTO jvnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Awit Gusti Allah ngomong: ‘Ngajènana marang bapa lan biyungmu,’ lan ‘Sapa sing mujèkké ala marang bapa lan biyungé kudu dipatèni.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nanging kowé mulangi: ‘Urunan kanggo ngopèni wong tuwamu kenèng mbok kèkké marang Gusti Allah. Dadiné kowé wis ora usah ngekèki urunan marang wong tuwamu menèh.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tegesé, angger-anggeré Gusti Allah mbok undurké kanggo ngejokké pernatan-pernatanmu déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kowé kuwi wong lamis. Tyotyok tenan tembungé nabi Yésaya bab kowé sing uniné ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bangsa iki enggoné ngelem Aku namung karo lambéné, nanging atiné adoh sangka Aku. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tanpa guna enggoné pada ngabekti marang Aku, awit pernatan-pernatan sing diwulangké kuwi namung gawéané manungsa.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Gusti Yésus terus nyeluk wong-wong kongkon pada maju, terus diomongi ngéné: “Iki pada dirungokké lan dilebokké ing atimu! ");
INSERT INTO jvnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sing marakké wong ala kuwi ora barang sing mlebu tyangkem, ora, nanging apa sing metu tyangkem.” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Murid-muridé terus mara nang nggoné Gusti Yésus ngomong: “Gusti, apa Kowé ngerti nèk para Farisi pada panas atiné dongé krungu tembungmu?” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Gusti Yésus semaur: “Saben tanduran sing ora ditandur karo Bapakku nang swarga bakal dibedol. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wong Farisi kuwi ora usah dirèwès. Kuwi penuntun sing lamur. Lah nèk wong lamur nuntun wong lamur liyané, kabèh loro bakal ketyemplung nang luwangan.” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Rasul Pétrus terus ngomong: “Mbok awaké déwé didunungké tembungmu kuwi Gusti!” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tembungé Gusti: “Mosok kowé uga durung dunung? ");
INSERT INTO jvnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mosok kowé ora dunung nèk sembarang sing mlebu tyangkem kuwi parané ya nang weteng terus dietokké menèh sangka awak? ");
INSERT INTO jvnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nanging apa sing metu sangka tyangkemé wong kuwi metuné sangka atiné, kuwi sing marakké wong ala. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Awit sangka ing ati kuwi tekané pikiran-pikiran sing ala, sing marakké wong matèni, laku bédang, memédok, nyenyolong, ngapusi lan nyenyatur. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Prekara-prekara kuwi sing marakké manungsa ala. Nanging mangan tanpa wisuh ndisik, kuwi ora marakké wong ala.” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sangka kono Gusti Yésus terus lunga nang bawahé kuta Sidon lan kuta Tirus. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nang kono ènèng wong wédok bangsa Kanaan mara nang nggoné Gusti Yésus tyeluk-tyeluk: “Gusti, Turunané ratu Daved, mbok aku dimelasi! Anakku wédok kesurupan demit lan melaské tenan!” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nanging Gusti Yésus ora semaur blas. Murid-muridé terus pada nyuwun marang Gusti Yésus: “Gusti, wong kuwi mbok dikongkon lunga waé, awit wongé terus bengak-bengok ngetutké awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Gusti Yésus terus ngomong: “Aku iki dikongkon marani bangsa Israèl sing ketriwal.” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nanging wong wédok mau malah sujut nang ngarepé Gusti Yésus karo nyuwun: “Gusti, mbok aku ditulungi ta!” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nanging Gusti Yésus ngomong: “Ora apik nèk wong njikuk pangané anaké terus dikèkké asu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wong wédoké semaur: “Pantyèn bener, Gusti, nanging asuné lak ya mangan turahané pangané sing nduwé omah ta!” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Gusti Yésus terus ngomong marang wongé: “Ibu, pantyèn gedé tenan pengandelmu. Kekarepanmu bakal keturutan.” Lan wiwit waktu kuwi anaké wongé malih waras. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Gusti Yésus terus lunga sangka panggonan kono liwat pinggiré mér Galiléa, terus munggah gunung. Gusti Yésus njagong nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wong pirang-pirang terus pada teka nggawa wong lumpuh, wong pintyang, wong lamur, wong bisu lan wong lara liya-liyané, dieterké nang nggoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wong-wong pada nggumun weruh sing bisu bisa ngomong, sing pintyang bisa mari sikilé, sing lumpuh bisa mlaku lan sing lamur bisa weruh. Wong-wong kuwi terus pada ngluhurké Gusti Allahé Israèl. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Gusti Yésus terus nyeluk murid-muridé diomongi ngéné: “Aku melaské marang wong-wong. Wis telung dina enggoné ngetutké Aku lan saiki wis ora ènèng sing dipangan. Aku ora bisa ngongkon wong-wong kuwi mulih karo weteng ngelih, mengko ndak ambruk nang dalan.” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Murid-muridé terus ngomong: “Lah nang panggonan sing sepi iki awaké déwé kongkon nggolèk roti nang endi kanggo ngekèki mangan wong semono okèhé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Gusti Yésus terus takon: “Lah kowé nduwé roti pira?” Murid-muridé semaur: “Enèng roti pitu lan iwak tyilik-tyilik siji-loro.” ");
INSERT INTO jvnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Gusti Yésus terus ngongkon wong-wong supaya pada njagong nang lemah. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sakwisé kuwi Dèkné terus njikuk roti pitu karo iwaké mau terus ndonga marang Gusti Allah. Rotiné lan iwaké terus dityuwil-tyuwil terus dikèkké marang murid-muridé. Murid-muridé terus ngedum roti lan iwaké marang wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wong kabèh pada mangan sampèk warek. Sakwisé kuwi murid-muridé terus nglumpukké turahané, éntuk pitung ténggok kebek. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wongé lanang sing mèlu mangan ènèng patang èwu okèhé, wong wédok-wédok lan botyah-botyah durung diitung. ");
INSERT INTO jvnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sakwisé kuwi Gusti Yésus terus ngongkon wong-wong mulih. Dèkné terus numpak prau arep nang bawah Makadan. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wong Farisi lan wong Saduki pada mara nang nggoné Gusti Yésus, tujuané arep ngenèng Dèkné. Mulané pada kepéngin weruh tandané nèk Gusti Yésus kuwi kongkonané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Gusti Yésus semaur ngéné: (“Nèk soré langité kétok abang murup, kowé ngomong nèk arep terang. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nèk ésuk langité kétok abang peteng, kowé ngomong nèk arep udan. Kowé pada bisa nitèni tanda-tandané nèk arep terang apa udan, nanging tanda-tandané jaman kowé ora dunung.) ");
INSERT INTO jvnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kowé wong ala lan wong sing ora kenèng dipretyaya, kowé pada njaluk tanda. Nanging kowé ora bakal éntuk tanda kuwi, kejaba namung tandané nabi Yonah.” Sakwisé ngomong ngono Gusti Yésus terus lunga sangka kono, ninggal wong-wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dongé pada ngabrah mér, murid-muridé Gusti Yésus pada lali nggawa roti. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Gusti Yésus ngomong marang murid-murid mau: “Kowé pada sing ati-ati tenan karo raginé wong Farisi lan wong Saduki.” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Murid-murid mau terus pada rasan-rasan: “Gusti Yésus ngomong ngono kuwi jalaran awaké déwé ora nggawa roti.” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gusti Yésus ngerti apa sing dirembuk karo murid-muridé, mulané terus ngomong: “Kenèng apa kowé kok pada ngomongké bab ora nggawa roti? Kowé kok tyilik tenan pengandelé? ");
INSERT INTO jvnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mosok kowé durung nitèni lan durung dunung? Apa kowé wis pada lali roti lima sing kanggo ngekèki mangan wong limang èwu kaé. Pirang ténggok turahané sing mbok lumpukké? ");
INSERT INTO jvnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Lan roti pitu sing kanggo ngekèki mangan wong patang èwu kaé? Apa wis pada lali? Pirang ténggok turahané sing mbok lumpukké? ");
INSERT INTO jvnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kenèng apa kowé kok ora pada ngerti nèk sing tak omong kuwi ora bab roti? Aku ngomongi kowé supaya pada ati-ati tenan karo raginé wong Farisi lan wong Saduki.” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Entèk-entèké murid-murid pada dunung apa sing diomong karo Gusti Yésus. Dèkné ora ngomongké bab ragi sing dienggo nggawé roti, nanging murid-murid kudu sing ati-ati karo piwulangé wong Farisi lan wong Saduki. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kadung wis tekan sak tyedeké kuta Sésaréa Filipi, Gusti Yésus terus takon marang murid-muridé: “Miturut omongané wong-wong, Anaké Manungsa kuwi sapa?” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Murid-muridé semaur: “Enèng sing ngomong nèk Kowé kuwi Yohanes Pembaptis, liyané ngomong jaréné Kowé nabi Elia lan liyané menèh ngarani Kowé nabi Yéremia apa nabi liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Gusti Yésus terus takon: “Lah nèk miturut kowé déwé, Aku iki sapa?” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Rasul Simon Pétrus semaur: “Kowé kuwi Kristus, Anaké Gusti Allah sing urip!” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Gusti Yésus terus ngomong: “Beja tenan kowé Simon, anaké Yonah, awit dudu manungsa sing ndunungké kuwi marang kowé, nanging Bapakku nang swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Lan Aku ngomong iki marang kowé: kowé kuwi Pétrus, watu lan ing watu kuwi Aku bakal ngedekké pasamuanku lan pangwasané pati ora bakal bisa ngalahké. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kowé bakal tak pasrahi kuntyiné Kratoné Swarga. Apa sing mbok talèni nang bumi kéné, bakal ditalèni uga nang swarga. Apa sing mbok utyuli nang bumi kéné, kuwi uga bakal diutyuli nang swarga.” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sakwisé kuwi Gusti Yésus ngomongi murid-muridé, dipenging ngomongké marang sapa-sapa nèk Dèkné kuwi Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wiwit waktu kuwi Gusti Yésus ndunung-ndunungké marang murid-muridé nèk Dèkné kudu budal nang kuta Yérusalèm. Nang kana Dèkné bakal nglakoni sangsara, jalaran sangka para penuntuné rayat, para pengarepé imam lan para guru Kitab. Dèkné bakal dipatèni, nanging ing telung dinané bakal tangi sangka kuburan. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Rasul Pétrus terus narik Gusti Yésus rada adoh sangka murid-murid liyané terus ngomong: “Muga-muga Gusti Allah ngalang-alangi, supaya prekara-prekara kuwi kabèh ora nganti klakon.” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nanging Gusti Yésus minger terus ngomong marang rasul Pétrus: “Lungaa sangka ngarepku, Sétan! Kowé ngalang-alangi Aku, awit kowé manut karepé manungsa, ora manut karepé Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Gusti Yésus terus ngomong marang murid-muridé: “Sapa sing kepéngin mèlu Aku kudu nglalèkké uripé déwé, manggul pentèngané lan ngetutké Aku. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Awit sapa sing ngudi nylametké uripé, malah bakal kélangan. Nanging sapa sing kélangan uripé jalaran nglabuhi Aku, kuwi sing bakal nemu uripé. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Awit apa gunané manungsa nduwèni donya iki sak kabèhé, nanging kélangan nyawané? Apa urip kuwi ènèng ijolé? ");
INSERT INTO jvnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Anaké Manungsa bakal teka bareng karo mulékat-mulékaté nganggo kwasané Gusti Allah Bapaké lan Dèkné bakal ngupahi kabèh manut penggawéné déwé-déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Dititèni omongku iki: nang tengahé wong sing nang kéné iki bakal ènèng sing ora bakal mati sakdurungé weruh Anaké Manungsa teka ing kratoné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nem dina sakwisé kuwi Gusti Yésus ngejèk rasul Pétrus, Yohanes lan Yakobus, seduluré Yohanes, munggah nang gunung sing duwur. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gusti Yésus terus malih rupa lan murid-murid sing mèlu pada weruh kabèh. Rainé Gusti Yésus semlorot kaya srengéngé lan saliné malih putih kaya pepadang. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Murid telu mau terus weruh nabi Moses lan nabi Elia omong-omongan karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Rasul Pétrus terus ngomong: “Gusti, kok ndilalah temen awaké déwé nang kéné. Nèk Gusti gelem, aku ngedekké gubuk telu, siji kanggo Gusti, siji kanggo nabi Moses lan siji menèh kanggo nabi Elia.” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dongé rasul Pétrus ijik ngomong ngono, terus ènèng méga padang ngemuli murid-murid mau, terus ènèng swara sangka méga mau ngomong: “Iki Anakku sing tak trésnani; pada nggugua tembungé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kadung krungu swara kuwi murid-murid mau pada kagèt lan wedi, sampèk pada niba nang lemah. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Gusti Yésus terus nyedeki lan ndemèk murid-muridé karo ngomong: “Pada ngadeka! Aja pada wedi!” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kadung wis ngadek terus namung weruh Gusti Yésus déwé, ora ènèng liyané menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dongé medun sangka gunung kono Gusti Yésus ngomong ngéné marang murid-muridé: “Aja ngomong karo sapa-sapa bab apa sing kowé pada weruh mau, sakdurungé Anaké Manungsa tangi sangka pati.” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Murid-murid mau terus takon: “Lah kenèng apa para guru Kitab kok ngomong nèk nabi Elia kudu teka ndisik?” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Gusti Yésus semaur: “Pantyèn, nabi Elia teka ndisik lan dèkné bakal nyawiské sembarang kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kowé tak omongi: nabi Elia wis teka, nanging wong-wong ora pada nitèni dèkné. Dèkné malah digawé sak karepé. Mengkono uga wong-wong kuwi bakal nindakké sak karepé marang Anaké Manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Murid-muridé mau terus pada dunung nèk Gusti Yésus kuwi ngomongké bab Yohanes Pembaptis. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kadung Gusti Yésus lan murid-muridé wis tyampur karo wong pirang-pirang menèh, terus ènèng wong mara lan niba nang ngarepé karo nyuwun: ");
INSERT INTO jvnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Duh Gusti, mbok melas marang anakku lanang. Dèkné lara ayanen lan ya wis nemen. Botyahé ajek tiba nang geni lan nang banyu. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aku wis nggawa botyahé nang nggoné murid-muridmu, nanging ora bisa nulungi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Gusti Yésus terus ngomong: “Kok kebatyut tenan enggonmu ora pretyaya marang Gusti Allah. Sepira menèh suwéné enggonku kudu tyampur lan nyabari kowé? Botyahé gawanen mbréné!” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Gusti Yésus terus nundung demité sing ngwasani botyahé. Demité terus lunga lan botyahé sakwat terus mari. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sakwisé kuwi murid-muridé Gusti Yésus terus pada marani Dèkné. Kadung déwé karo Gusti Yésus terus pada takon: “Gusti, kenèng apa awaké déwé kok ora bisa ngetokké demité?” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Gusti Yésus semaur: “Awit pengandelmu tyilik! Ngertia, nèk kowé nduwé pengandel sing gedéné namung sak wiji sing tyilik déwé waé, kowé bisa ngomong marang gunung kuwi: ‘Ngaliha mbrana,’ mesti gunungé manut. Ora bakal ènèng barang sing mokal kanggo kowé. ( ");
INSERT INTO jvnNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nanging demit sing kaya ngono kuwi lungané namung nganggo pandonga lan pasa.)” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dongé murid-muridé ijik pada ngumpul nang bawah Galiléa, Gusti Yésus ngomong ngéné: “Anaké Manungsa bakal dielungké marang wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Dèkné bakal dipatèni, nanging ing telung dinané Dèkné bakal ditangèkké menèh karo Gusti Allah.” Murid-muridé terus pada sedi banget. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kadung pada teka nang kuta Kapèrnakum, wong-wong sing njaluki belasting kanggo Gréja Gedé pada marani rasul Pétrus lan takon: “Apa gurumu ya mèlu mbayar belastingé Gréja Gedé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Rasul Pétrus semaur: “Lah kok ora?” Kadung rasul Pétrus tekan omah, Gusti Yésus nakoni dèkné, sakdurungé rasul Pétrus déwé ngomong apa-apa. Gusti Yésus takon: “Simon, kepriyé pinemumu? Sapa sing kudu mbayar belasting marang ratu ing donya kéné: wargané negara apa wong liya?” ");
INSERT INTO jvnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Rasul Pétrus semaur: “Ya wong-wong liya!” Gusti Yésus terus ngomong: “Dadiné anak-anakané negara ora usah mbayar. ");
INSERT INTO jvnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nanging awaké déwé aja pada ndadèkké larané atiné wong-wong kuwi. Kana budal nang mér lan diuntyalké pantyingmu. Iwak sing mbok pantying sing ndisik déwé kuwi dityekel. Nang njero tyangkemé kowé bakal nemu duwit. Dijikuk duwit kuwi kanggo mbayar belasting marang wong-wong kuwi, mbayar kanggo Aku lan kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ing waktu kuwi para murid pada mara nang nggoné Gusti Yésus terus takon: “Guru, sapa ta sing gedé déwé ing Kratoné Swarga?” ");
INSERT INTO jvnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Gusti Yésus terus nyeluk botyah tyilik siji dikongkon ngadek nang tengahé para murid mau. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Dèkné terus ngomong: “Pada ngertia! Nèk kowé ora malih atimu lan dadi kaya botyah tyilik iki, kowé ora bisa mlebu Kratoné Swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sing gedé déwé ing Kratoné Swarga kuwi wong sing ngasorké awaké lan dadi kaya botyah tyilik iki. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Lan sapa sing nampani botyah tyilik sing kaya ngéné iki jalaran sangka Aku, kuwi sakjané nampani Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Gusti Yésus neruské piwulangé ngéné: “Sapa sing marakké salah-sakwijiné botyah tyilik sing pretyaya marang Aku sampèk ninggal dalanku, apiké nèk wong kuwi guluné dibanduli watu gilingan terus dijegurké nang segara sing jeru. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tyilaka tenan jagat iki, nèk ènèng panggoda okèh sing marakké wong nglakoni dosa. Prekara-prekara sing kaya ngono kuwi pantyèn slawasé ya bakal ènèng, nanging tyilaka tenan, wong sing dadi jalarané. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Mulané, nèk tanganmu apa sikilmu marakké kowé nggawé dosa, diketok waé lan dibuwang. Awit luwih apik kanggo kowé urip manut Gusti Allah namung karo tangan sebelah apa namung karo sikil sebelah, tenimbang karo tangan lan sikil genep loro, nanging awakmu sak kujur dityemplungké nang geniné neraka. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nèk mripatmu marakké kowé nggawé dosa, dityukil lan dibuwang. Luwung kowé urip dadi siji karo Gusti Allah nganggo mripat siji, tenimbang mripaté genep loro, nanging dibuwang nang geniné neraka. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Aja pada nyepèlèkké botyah-botyah tyilik iki. Pada ngertia, botyah-botyah tyilik iki pada nduwé mulékat nang swarga sing tansah nyedeki Bapakku nang swarga. ( ");
INSERT INTO jvnNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Awit Anaké Manungsa kuwi tekané nylametké wong sing kesasar.)” ");
INSERT INTO jvnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Gusti Yésus terus takon: “Kepriyé pinemumu? Semunggoné ènèng wong nduwé wedus satus terus ènèng siji sing ilang. Wongé terus ngapa? Apa wongé ora terus ninggal wedusé sing sangang puluh sanga nang pangonan lan budal nggolèki wedus siji sing ilang mau? ");
INSERT INTO jvnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nèk wongé wis nemu wedusé sing ilang mau, mesti dèkné bungahé karo wedus sing siji kuwi ngungkul-ungkuli bungahé karo sing sangang puluh sanga sing ora ilang. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mengkono uga Bapakmu nang swarga, Dèkné ora gelem nèk botyah-botyah tyilik kuwi ènèng siji sing ketriwal.” ");
INSERT INTO jvnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Gusti Yésus neruské piwulangé ngéné: “Nèk kowé weruh sedulurmu nglakoni sing klèru, diparani lan diduduhké klèruné, nanging ijènan, tanpa wong liyané ngerti. Nèk sedulur kuwi nggugu marang tembungmu, kowé ora kélangan sedulur. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lah nanging nèk sedulur kuwi ora gelem ngrungokké omongmu, kowé kudu ngejèk sedulur liyané siji apa loro. Awit nang Kitab ketulis nèk salahé wong kudu ditetepké karo seksi loro apa telu. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nèk sedulur sing klèru kuwi meksa durung gelem manut marang sedulur-sedulur liyané kuwi, prekara iki kudu mbok gawa nang ngarepé pasamuan. Nèk sakwisé kuwi wongé meksa ora gelem manut marang pituturé pasamuan, wongé kudu dianggep kaya wong sing ora pretyaya lan wong ala waé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tembungé Gusti Yésus ngéné: “Pada ngertia! Apa sing mbok talèni ing donya kéné uga bakal ditalèni nang swarga. Lan apa sing mbok utyuli ing donya kéné uga bakal diutyuli nang swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Pada ngertia uga! Nèk ènèng wong loro ing donya menunggal ing pandonga njaluk apa waé, pandonga kuwi bakal dibales karo Bapakmu nang swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Awit nèk ènèng wong loro apa telu pada ngumpul bebarengan lan pada nyebut Jenengku, Aku uga nang kono.” ");
INSERT INTO jvnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sakwisé kuwi rasul Pétrus terus mara nang nggoné Gusti Yésus takon: “Gusti, nèk sedulurku bolak-balik nggawé salah marang aku, sampèk ping pira aku kudu ngapura sedulur kuwi? Apa ora tekan ping pitu?” ");
INSERT INTO jvnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Gusti Yésus semaur: “Ora namung ping pitu, nanging pitung puluh ping pitu. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Mulané, Kratoné Swarga kuwi kenèng dipadakké karo sakwijiné ratu sing nagih utang marang peladèn-peladèné. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kadung ratuné molai, terus ènèng sakwijiné peladèn digawa maju. Peladèn iki utangé pirang-pirang mliyun. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nanging wongé ora bisa nyaur, mulané ratuné mau mréntah kongkon ngedol peladèn mau dadi peladèn, sak anak-bojoné lan sembarang sak nduwéné, kanggo mbayar utangé. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Peladèn mau terus niba lan sujut nang ngarepé ratuné ngomong: ‘Gusti, mbok aku disabari sedilut menèh. Kabèh utangku bakal tak bayar.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ratuné melas karo peladèn mau lan wongé dikongkon mulih, malah utangé kabèh ora usah dibayar menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nanging sak lungané sangka kono, peladèn mau kepetuk karo kantyané tunggal peladèn, sing nduwé utang setitik marang dèkné. Kantyané mau terus dityekel lan ditekek guluné karo ngomong: ‘Bayaren utangmu!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kantyané mau terus niba njaluk kawelasan ngomong: ‘Mbok sabar ta! Utangku bakal tak bayar kabèh!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nanging peladèn mau ora gelem ngrungokké sambaté kantyané. Malah kantyané dilebokké setrapan nganti utangé disaur kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kadung peladèn-peladèn liyané weruh lelakon kuwi, kabèh pada kagèt lan sedi banget, mulané terus pada ngomongi ratuné bab kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ratuné terus kongkonan nyeluk peladèn sing ala mau terus disenèni: ‘Kowé kuwi pantyèn peladèn sing ala tenan. Utangmu semono okèhé kowé wis ora usah mbayar, jalaran kowé nyuwun tenan marang aku. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Apa ya wis ora sak mestiné kowé melasi kantyamu tunggal peladèn, kaya enggonku wis melasi kowé.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ratuné terus nesu banget lan peladèn sing ala mau dilebokké nang setrapan supaya diajar, nganti utangé dibayar kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Bapakku nang swarga uga bakal nindakké mengkono kuwi marang kowé, nèk kowé ora ngapura marang sedulurmu sak atimu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sakwisé ngrampungké piwulangé kuwi Gusti Yésus terus ninggal bawah Galiléa budal nang bawah Yudéa, ngabrah laut Yordan. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wong pirang-pirang pada ngetutké Dèkné lan kabèh pada ditambani larané. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Terus ènèng wong Farisi pada teka, jawané arep ngenèng Dèkné nganggo pitakonan. Mulané terus pada takon ngéné marang Gusti Yésus: “Apa wong lanang éntuk megat bojoné manut sak karepé déwé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Saurané Gusti Yésus: “Apa kowé ora matya nang Kitab Sutyi nèk Gusti Allah enggoné nggawé manungsa kawit wiwitané rupa wong lanang lan wong wédok? ");
INSERT INTO jvnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Gusti Allah uga ngomong: ‘Mulané wong lanang kudu ninggal bapa lan biyungé lan dadi siji karo bojoné, dadiné wong loro dadi daging siji.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wong loro kuwi wis ora loro menèh, nanging namung siji. Lan apa sing wis didadèkké siji karo Gusti Allah, manungsa ora kenèng misah.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Para Farisi terus pada takon: “Lah nèk ngono, lah kenèng apa nabi Moses kok ngomong nèk wong lanang kudu ngekèki layang pegat marang bojoné nèk dipegat? Apa kuwi tegesé ora nglilani pegatan?” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Gusti Yésus terus ngomong: “Nabi Moses enggoné nglilani kowé megat bojomu kuwi jalaran kowé ora kenèng dikandani, nanging ing wiwitané ora kaya ngono! ");
INSERT INTO jvnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kowé pada tak kandani: Sapa megat bojoné terus kawin karo wong liyané, wong kuwi laku bédang, kejaba nèk bojoné laku bédang.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Murid-muridé Gusti Yésus terus ngomong: “Lah nèk wong omah-omah kaya ngono lakuné, apa ora luwih apik nèk ora omah-omah waé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Gusti Yésus semaur: “Ora saben wong bisa nglakoni kuwi, namung wong sing dipiji karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Awit ènèng wong sing ora bisa omah-omah, jalaran kawit lair wis ngono. Enèng uga sing ora bisa omah-omah, jalaran didadèkké ngono karo wong liyané. Lan ènèng liyané menèh sing milih ora omah-omah sangka karepé déwé, jalaran namung kepéngin ngurusi Kratoné Gusti Allah. Sapa sing bisa nglakoni, ya bèn nglakoni.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ing sakwijiné dina wong-wong pada nggawa anak-anaké nang nggoné Gusti Yésus, nyuwun supaya pada didongakké lan diberkahi. Nanging wong-wong kuwi pada disenèni karo murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Gusti Yésus malah ngomong marang murid-muridé: “Mbok bèn botyah-botyah kuwi pada mbréné, aja dialang-alangi, awit Kratoné Swarga kanggo wong sing kaya botyah-botyah kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Gusti Yésus terus numpangi tangan marang botyah-botyah, terus lunga sangka panggonan kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ing sakwijiné dina ènèng wong enom mara nang nggoné Gusti Yésus, takon ngéné: “Guru, supayané bisa nampa urip langgeng, aku kudu nglakoni penggawé betyik apa?” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Gusti Yésus semaur: “Kenèng apa kowé kok takon marang Aku bab apa sing betyik? Namung siji sing betyik, yakuwi Gusti Allah. Nèk kowé kepéngin nampa urip langgeng, kowé kudu nglakoni angger-anggeré Gusti Allah kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tembungé wong enom mau: “Angger-angger sing endi?” Gusti Yésus terus semaur: “Kowé aja mematèni, aja laku bédang, aja nyolong, aja ngapusi. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ngajènana marang bapa-biyungmu lan trésnaa marang wong liya kaya enggonmu trésna marang awakmu déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wongé terus ngomong ngéné: “Angger-angger kabèh kuwi wis tak lakoni. Lah ijik kurang apa menèh?” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tembungé Gusti Yésus ngéné: “Nèk kowé kepéngin sampurna, barang-barang nduwému diedol kabèh. Sepira payuné dikèkké marang wong sing ora nduwé, supaya kowé nduwé banda nang swarga. Sakwisé kuwi terus mbrénéa mèlu Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kadung krungu tembung kuwi, wong enom mau terus lunga karo sedi, awit dèkné sugih banget. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Gusti Yésus terus ngomong marang murid-muridé: “Kowé pada tak omongi: pantyèn angèl tenan kanggo wong sugih mlebu ing Kratoné Swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tak balèni menèh tembungku: malah luwih gampang unta mlebu bolongané dom, tenimbang wong sugih mlebu Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Krungu tembung kuwi mau para murid kagèt banget, terus takon: “Lah nèk ngono, sapa sing bisa slamet?” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Gusti Yésus nyawang murid-muridé terus ngomong: “Kanggo manungsa prekara kuwi pantyèn mokal, nanging kanggo Gusti Allah ora ènèng barang sing mokal.” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Rasul Pétrus terus ngomong marang Gusti Yésus: “Gusti, awaké déwé wis ninggal sembarangé awaké déwé lan saiki mèlu Kowé! Awaké déwé bakal éntuk apa?” ");
INSERT INTO jvnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Saurané Gusti Yésus: “Kowé pada tak omongi, mbésuk ing entèk-entèkané jaman Anaké Manungsa bakal njagong nang dampar pangwasa. Ing waktu iku kowé sing pada mèlu Aku uga bakal mèlu njagong nang dampar lan ngrutu taleré Israèl rolas. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Lan saben wong sing ninggal omahé, seduluré lanang apa wédok, bapa-ibuné, anak-anaké lan keboné, jalaran nglabuhi Aku, wong kuwi bakal nampa ijolé ping satus lan uga bakal éntuk urip langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nanging okèh wong sing tekané ndisik bakal dadi kèri déwé lan okèh wong sing tekané kèri bakal dadi ndisik déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Gusti Yésus mulangi ngéné: “Kratoné Swarga kuwi kenèng dipadakké karo wong sing nduwé kebon dreif. Esuk mruput wongé wis budal nggolèk wong sing kudu ngerjani keboné. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kadung wis pada setuju bab bayarané saben wong sedina, wong-wong terus dikongkon budal nyambutgawé nang keboné. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kira-kira jam sanga ésuk sing nduwé kebon lunga menèh terus weruh wong siji-loro nganggur nang lataré pasar. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sing nduwé kebon mau terus ngomong marang wong-wong sing nganggur kuwi: ‘Hayuk pada nyambutgawé nang kebonku, kowé bakal tak bayar sak mestiné!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wong-wong terus pada budal. Kira-kira jam rolas lan jam telu awan wong sing nduwé kebon lunga menèh nggolèk wong. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kira-kira jam lima soré wongé uga budal menèh, terus weruh wong-wong pada nganggur, terus ditakoni: ‘Kenèng apa kowé kok pada nganggur nang kéné sedina muput?’ ");
INSERT INTO jvnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wong-wong semaur: ‘Lah ora ènèng sing ngekèki kerjanan kok!’ Sing nduwé kebon terus ngomong: ‘Nèk ngono, hayuk nyambutgawé nang kebonku waé.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kadung wis surup, sing nduwé kebon terus ngomong marang mandoré: ‘Kana sing kerja pada dityeluk lan dikèki bayarané. Molai karo sing teka kèri déwé nganti tekan sing teka ndisik déwé.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wong-wong sing nyambutgawé molai kira-kira jam lima terus pada teka lan nampa bayarané wong kerja sedina. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sakwisé kuwi wong-wong sing molai kerja kawit ésuk terus pada mara, mikiré bakal nampa bayaran luwih okèh. Nanging wong-wong kuwi uga nampa bayarané wong kerja sedina. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wong-wong nampani bayarané karo nggresah marang sing nduwé kebon. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Tembungé: ‘Lah sing teka kèri kerjané namung sak jam, lah kok dibayar tunggalé karo awaké déwé sing kerja kepanasen sedina muput.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Sing nduwé kebon terus semaur: ‘Lo, aku ora ngapusi kowé! Kowé lak wis setuju ta nampa bayarané wong kerja sedina? ");
INSERT INTO jvnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ditampa bayaranmu kuwi lan kana lunga! Pantyèn aku karep ngekèki wong sing teka kèri bayaran sing tunggalé karo bayaranmu. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Apa aku ora éntuk nganggokké duwitku manut karepku déwé? Kenèng apa kowé kok mèri nèk aku nggawé betyik marang liyané?’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Gusti Yésus terus ngomong: “Pantyèn kaya ngono, wong-wong sing teka kèri bakal dadi ndisik déwé lan wong-wong sing ndisik déwé bakal dadi sing kèri.” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dongé pada mlaku budal nang kuta Yérusalèm, Gusti Yésus nyeluk murid-muridé rolas didèwèkké, terus ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kowé pada ngerti nèk awaké déwé saiki budal nang kuta Yérusalèm. Nang kana Anaké Manungsa bakal dipasrahké marang para pengarepé imam lan guru Kitab. Wong-wong kuwi bakal netepké setrapan pati marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sakwisé kuwi wong-wong bakal masrahké Dèkné marang bangsa Rum, supaya dipoyoki, dipetyuti terus dipentèng. Nanging ing telung dinané Dèkné bakal ditangèkké sangka pati karo Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Bojoné Sébédéus mara nang nggoné Gusti Yésus karo anaké lanang loro. Wongé terus sujut arep nduwèni tembung. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gusti Yésus terus takon: “Apa sing mbok karepké?” Bojoné Sébédéus terus ngomong: “Gusti, mbok janji ta, nèk Gusti mbésuk dadi ratu, anakku kabèh loro kelilan njagong nang sebelahé Gusti, sing siji tengen lan liyané kiwa?” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Gusti Yésus semaur: “Kowé kuwi ora ngerti apa sing mbok jaluk. Apa kowé wani nglakoni kasangsaran sing bakal tak lakoni?” Saurané: “Ya Gusti, awaké déwé wani!” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Gusti Yésus terus ngomong: “Pantyèn, kasangsaran sing bakal tak lakoni kowé uga bakal nglakoni. Nanging bab njagong nang sebelah tengen apa kiwaku, kuwi Aku ora nduwé kwasa ngarani. Jagongan kuwi wis dityawiské kanggo wong-wong sing wis dipilih karo Bapakku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kadung murid sepuluh liyané krungu bab kuwi, terus pada nesu marang sedulur loro mau. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mulané Gusti Yésus terus nyeluk murid-muridé kabèh terus diomongi ngéné: “Kowé pada ngerti déwé nèk para penuntun malah pada ngerèh bangsané lan semono uga para penggedé, kuwi malah pada nindes bangsané. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nanging kowé aja kaya ngono. Sapa sing kepéngin dadi pengarep, kuwi kudu ngladèni kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Lan sapa sing kepéngin dianggep gedé déwé, kuwi sing kudu dadi peladèné liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Didelokké ta Anaké Manungsa, Dèkné tekané ora supaya diladèni, nanging malah ngladèni lan masrahké nyawané kanggo nylametké wong okèh.” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Dongé Gusti Yésus lan murid-muridé pada ninggal kuta Yériko, wong pirang-pirang pada ngetutké. ");
INSERT INTO jvnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nang pinggir dalan ènèng wong lamur loro pada njagong. Kadung krungu nèk Gusti Yésus liwat, wong lamur loro mau pada bengok-bengok: “Gusti, Turunané ratu Daved, mbok melas karo awaké déwé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wong okèh sing nang kono pada nyenèni wong loro kuwi kongkon meneng. Nanging malah tambah banter sing mbengok: “Gusti, Turunané ratu Daved, mbok melas karo awaké déwé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Gusti Yésus terus mandek, terus wong loro mau dityeluk. Dèkné takon: “Kowé njaluk apa?” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Semauré: “Awaké déwé nyuwun bisa weruh menèh, Gusti!” ");
INSERT INTO jvnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Gusti Yésus melas marang wong loro kuwi, terus didemèk mripaté. Sakwat terus pada bisa weruh menèh, terus mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kadung wis mèh tekan kuta Yérusalèm, Gusti Yésus lan murid-muridé mampir nang désa Bètfaké, tyedek karo gunung Olèf. Nang kono Gusti Yésus terus ngongkon murid loro kongkon budal ndisik. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Gusti Yésus ngomong ngéné: “Kana budal nang désa nang ngarep kuwi. Nang kono kowé bakal weruh kimar wédok karo anakané dikentyang. Kimaré diutyuli terus digawa mbréné. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nèk ènèng wong takon apa-apa, ngomong ngéné waé: ‘Gusti mbutuhké. Nèk wis rampung, bakal dibalèkké.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dadiné bisa keturutan sing wis diomong karo sakwijiné nabi, sing uniné ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Dikabarké marang wong-wong nang Sion: Ratumu nekani kowé, Dèkné andap-asor lan tekané numpak anakan kimar.” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Murid loro mau terus budal lan nuruti apa sing diomong karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kimar lan anakané terus digawa. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Murid-murid pirang-pirang sing nang kono terus pada njèrèng klambiné nang dalan sing arep diliwati Gusti Yésus. Wong-wong liyané pada ngepèk pangé wit-witan terus disèlèhké nang dalan. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Wong pirang-pirang pada mlaku nang ngarepé lan nang mburiné Gusti Yésus, terus pada surak-surak: “Hosana, hayuk dipuji Turunané ratu Daved. Muga kaberkahan sing teka ing jenengé Gusti. Hosana, hayuk dipuji Gusti Allah sing nang swarga!” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kadung Gusti Yésus wis mlebu nang kuta Yérusalèm, wong sak kuta pada gègèr lan pada takon: “Sing teka kuwi sapa ta?” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wong-wong sing pada mèlu Gusti Yésus semaur: “Kuwi nabi Yésus, sangka kuta Nasarèt nang distrik Galiléa!” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Gusti Yésus terus mlebu nang lataré Gréja Gedé. Wong-wong sing dodolan lan tetuku nang lataré Gréja Gedé kono pada diusir kongkon lunga kabèh. Méja-méjané sing tukang ngijoli duwit lan dingklik-dingkliké sing dodol manuk dara diglémpangké kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Gusti Yésus ngomong marang wong-wong sing dodolan: “Nang Kitab wis ditulis nèk Gusti Allah ngomong: ‘Omahku bakal diarani panggonan kanggo pamuji,’ nanging saiki mbok dadèkké rongé maling.” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nang Gréja Gedé kono ènèng wong lamur lan wong lumpuh pada nang nggoné Gusti Yésus. Kabèh pada diwaraské. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nanging kadung para pengarepé imam lan para guru Kitab pada weruh enggoné Gusti Yésus nindakké mujijat-mujijat lan botyah-botyah pada surak-surak: “Dipuji Turunané ratu Daved,” terus pada nesu. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Para pengarepé imam lan para guru Kitab terus ngomong marang Gusti Yésus: “Apa Kowé ora krungu tembungé botyah-botyah kuwi?” Gusti Yésus semaur: “Ya, Aku krungu. Nanging apa Kowé durung tau matya nang Kitab Sutyi, sing uniné ngéné: ‘Botyah-botyah lan bayi-bayi wis mbok blajari memuji Jenengmu.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Gusti Yésus terus ninggal wong-wong kuwi, lunga sangka kuta Yérusalèm, terus budal nang désa Bétani lan nginep nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Esuké, dongé balik nang kuta Yérusalèm, Gusti Yésus krasa ngelih nang dalan. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Dèkné weruh wit anjir nang pinggir dalan, terus diparani. Nanging ora ènèng wohé siji-sijia, namung godong. Mulané Gusti Yésus terus ngomong marang wité: “Slawas-lawasé kowé ora bakal ngetokké woh menèh!” Sakwat wité terus garing. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kadung murid-muridé weruh lelakon kuwi mau, terus pada nggumun banget, mulané pada takon: “Lah wité anjir kok dadi garing ngono, Gusti?” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Gusti Yésus semaur: “Pada ngertia, nèk kowé pretyaya lan ora mangu-mangu, kowé ya bisa nindakké sing tak tindakké marang wit anjir kuwi. Malah ora namung kuwi waé, kowé bisa ngongkon gunung kaé ngomong: ‘Mumbula, njegura nang segara,’ lan kuwi ya bakal klakon. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sembarang sing mbok jaluk ing pandonga bakal klakon, janji kowé pretyaya.” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Gusti Yésus terus mlebu nang Gréja Gedé lan mulangi nang kono. Ing tengah-tengahé memulang ènèng pengarepé imam lan para guru Kitab mara nang nggoné Gusti Yésus takon: “Guru, enggonmu nindakké prekara kuwi kabèh éntuk pangwasa sangka ngendi? Sapa ta sing ngekèki pangwasa marang Kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Gusti Yésus semaur ngéné: “Aku arep takon marang kowé ndisik. Nèk kowé wis mangsuli pitakonanku, Aku ya bakal mangsuli pitakonanmu. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sapa sing ngekèki pangwasa marang nabi Yohanes kanggo mbaptis? Gusti Allah apa manungsa?” Para pengarepé imam lan para guru Kitab terus pada rembukan déwé: “Nèk awaké déwé ngomong: ‘Sangka Gusti Allah,’ lah mengko Dèkné semaur: ‘Lah kenèng apa kowé kok ora pretyaya marang nabi Yohanes?’ ");
INSERT INTO jvnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Lah nèk awaké déwé semaur: ‘Sangka manungsa,’ awaké déwé wedi karo wong okèh iki, awit wong-wong kuwi kabèh nganggep Yohanes kuwi nabi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dadiné para pengarepé imam lan para guru Kitab pada semaur: “Awaké déwé ora ngerti!” Gusti Yésus terus semaur: “Nèk ngono, kowé ya ora bakal tak omongi sapa sing ngekèki pangwasa marang Aku kanggo nindakké prekara kuwi mau kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Gusti Yésus terus ngomong: “Kepriyé pinemumu bab iki? Enèng wong nduwé anak loro. Wongé marani anaké mbarep terus ngomong: ‘Lik, dina iki kana kowé nyambutgawé nang kebon dreif.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Anaké semaur: ‘Ya Pak,’ nanging ora budal. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bapaké terus marani anaké sing enom, terus dikongkon nyambutgawé nang keboné. Anaké enom semaur: ‘Aku emoh Pak,’ nanging terus gela, mulané terus budal. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Anak loro mau sing endi sing nindakké karepé bapaké?” Wong-wong terus semaur: “Ya sing enom.” Gusti Yésus terus ngomong: “Pada titènana, wong-wong belasting lan wong-wong lonté malah bakal mlebu ndisik ing Kratoné Gusti Allah tenimbang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Awit nabi Yohanes teka lan nduduhké dalané Gusti Allah marang kowé, nanging kowé ora pada pretyaya marang dèkné. Wong-wong belasting lan wong-wong lonté malah pada pretyaya marang dèkné. Kowé pada weruh kuwi, nanging kowé ora terus malih pikirané lan pretyaya marang dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Gusti Yésus ngomong: “Pada dirungokké piwulang iki. Enèng wong sugih nduwé kebon dreif. Keboné dipageri mubeng lan digawèkké panggonan kanggo meres dreifé. Wongé uga ngedekké gubuk duwur kanggo njaga. Sakwisé kuwi keboné terus diséwakké marang wong-wong liyané. Wongé déwé terus lunga nang liya negara. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kadung wis wayahé panèn sing nduwé kebon teka terus kongkonan sing kerja supaya nang nggoné wong-wong sing nyéwa keboné. Kongkon njaluk bagèané dèkné sangka pametuné keboné. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nanging wong-wong sing dikongkon mau malah dityekel karo wong-wong sing nyéwa kebon. Enèng sing digebuki, ènèng sing dipatèni lan ènèng sing dibandemi watu. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sing nduwé kebon terus ngongkon wong liyané menèh, okèhé ngungkuli sing ndisik. Nanging kongkonan sing iki kabèh pada waé ngalami kaya sing ndisik. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Entèk-entèké sing nduwé kebon ngongkon anaké déwé, mikiré wong-wong sing nyéwa kebon ngajèni marang anaké dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nanging kadung wong-wong sing nyéwa kebon weruh anaké sing nduwé kebon teka, terus pada rembukan ngéné: ‘Lah iki anaké sing nduwé kebon teka. Hayuk dipatèni waé, supaya awaké déwé éntuk warisané.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Anaké sing nduwé kebon mau terus dityekel, disèrèt metu sangka keboné terus dipatèni.” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Gusti Yésus terus takon: “Nèk sing nduwé kebon teka, wong-wong sing nyéwa keboné bakal dikapakké?” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wong-wong sing ditakoni pada semaur: “Ya wis sak mestiné nèk wong-wong ala kuwi bakal dipatèni kabèh. Lah keboné dreif mesti bakal diséwakké marang wong liya-liyané, sing pada gelem ngekèkké bagèané sing nduwé kebon pendak panèn.” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Gusti Yésus terus takon: “Apa kowé pada durung tau matya tulisan iki nang Kitab: ‘Watu sing ora dikanggokké karo sing nggawé omah, kuwi dadi watu sing penting déwé. Iki penggawéné Gusti, mulané ya nggumunké tenan.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mulané Aku ngomong marang kowé: Kratoné Gusti Allah bakal direbut sangka kowé lan dikèkké marang bangsa liya, sing nggugu marang tembungé. ( ");
INSERT INTO jvnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sapa sing tiba ing watu kuwi bakal ajur lan sing ketiban watu kuwi bakal remuk.)” ");
INSERT INTO jvnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kadung para pengarepé imam lan para Farisi pada krungu tembungé Gusti Yésus kuwi, terus pada rumangsa nèk wong-wong kuwi déwé sing disemoni. ");
INSERT INTO jvnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wong-wong terus pada kepéngin nyekel Dèkné, nanging pada wedi karo rayaté, sing nganggep Gusti Yésus kuwi nabi. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Gusti Yésus memulang menèh marang wong-wong nganggo sakwijiné gambar. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Tembungé Gusti Yésus ngéné: “Kratoné Swarga kenèng dipadakké karo sakwijiné ratu sing arep nduwé gawé gedèn, jalaran arep ngawinké anaké lanang. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ratu mau ngongkon para peladèné ngundangi wong-wong sing diulemi. Nanging wong-wong ora gelem teka. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ratuné terus ngongkon peladèn-peladèn liyané, diomongi ngéné: ‘Kana wong-wong sing diulemi diomongi nèk péstané wis ditata. Sapi lanang lan pedèt-pedèt pilihan wis dibelèh. Sembarang wis rampung. Kongkon ndang pada nekani péstané!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nanging wong-wong sing diulemi ora teka. Malah pada lunga ngurusi penggawéané déwé-déwé. Enèng sing nang kebon, liyané ngurusi dagangané. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Malah ènèng sing pada nyekel peladèné ratuné, dipilara lan dipatèni. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mulané ratuné terus nesu banget. Dèkné terus ngongkon soldat-soldaté, kongkon matèni wong-wong sing matèni peladèn-peladèné lan kongkon ngobong kutané. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ratuné terus ngomong marang para peladèné: ‘Péstané mantènan wis ditata, nanging wong-wong sing diulemi pada ora pantes. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mulané kana saiki pada nang prapatan-prapatan lan sapa waé sing ketemu diundang kongkon teka nang péstané mantènan.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Para peladèn mau terus budal nang prapatan-prapatan. Kabèh wong sing ketemu, sing ala lan sing betyik, terus pada dikumpulké. Panggonan pésta saiki kebek karo dayoh. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kadung ratuné mlebu kepéngin weruh dayoh-dayohé, dèkné terus weruh ènèng sakwijiné dayoh ora nganggo salin pésta. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dayoh kuwi terus ditakoni: ‘Sedulur, lah kowé kok mlebu tanpa nganggo salin pésta?’ Nanging dayohé ora bisa semaur apa? ");
INSERT INTO jvnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ratuné terus ngomong marang para peladèné: ‘Wong iki dibanda lan dietokké sangka kéné, dibuwang nang panggonan sing peteng. Nang kono dèkné bakal tangisan lan kerot untu.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Gusti Yésus terus nutup piwulangé ngéné: “Pantyèn okèh wong sing dipanggil, nanging namung setitik sing pantes dipilih.” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Para Farisi terus lunga lan pada rembukan kepriyé bisané ngenèng Gusti Yésus nganggo pitakonan. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Terus pada kongkonan murid-muridé kono bareng karo wong-wong golongané ratu Hérodès marani Gusti Yésus. Wong-wong iki terus takon: “Guru, awaké déwé ngerti nèk kowé wong jujur lan blaka enggoné mulangké bab kekarepané Gusti Allah kanggo manungsa. Kowé ora wedi lan ora perduli karo sapa-sapa. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mulané awaké déwé kepéngin ngerti sangka Kowé bab iki: mbayar belasting marang ratuné Rum kuwi éntuk apa ora?” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nanging Gusti Yésus ngerti nèk wong-wong kuwi tujuané ala, mulané terus ngomong: “Kowé kuwi lamis. Kenèng apa kowé kok arep ngenèng Aku? ");
INSERT INTO jvnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ndelok kéné duwit sing dienggo mbayar belasting.” Terus ènèng sing nggawa duwit pérak siji. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Gusti Yésus terus takon: “Nang duwit iki ènèng gambaré lan jenengé sapa?” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wong-wong semaur: “Gambaré lan jenengé ratuné Rum!” Gusti terus ngomong: “Nèk ngono, apa sing wèké ratuné ya dikèkké marang ratuné lan apa sing wèké Gusti Allah ya kudu dikèkké marang Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wong-wong pada nggumun banget krungu Gusti Yésus ngomong ngono kuwi. Wong-wong terus ora ngrusui Dèkné menèh, terus pada lunga. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ing dina kuwi uga ènèng wong golongan Saduki siji-loro nang nggoné Gusti Yésus. Wong Saduki nganggepé wong mati ora bakal tangi menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mulané pada takon marang Gusti Yésus: “Guru, nabi Moses mulangi ngéné: ‘Nèk ènèng wong lanang mati tanpa ninggal turunan, seduluré lanang kudu ngepèk bojoné sing ditinggal mati kuwi, supaya bisa nggawé turunan.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lah saiki ènèng sedulur pitu. Sing mbarep kawin, nanging terus mati tanpa ninggal anak. Bojoné terus diepèk karo adiké sing mati. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Uga adiké mati tanpa ninggal anak. Mengkono lelakoné karo sedulur sing nomer telu tumekané sedulur sing nomer pitu, kabèh mati tanpa ninggal anak. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Entèk-entèké wong wédoké mati pisan. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Saiki awaké déwé arep takon: Lah mbésuk nèk wong mati pada tangi, wong wédok kuwi dadi bojoné sedulur sing endi? Awit sedulur pitu kuwi kabèh wis tau dadi bojoné wong wédok mau?” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Gusti Yésus semaur: “Kowé kuwi klèru kabèh. Kowé kuwi ora dunung isiné Kitab lan kowé blas ora ngerti kwasané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Awit mbésuk nèk wong-wong tangi sangka pati uripé bakalé kaya mulékat nang swarga, ora ènèng tyarané bebojoan. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Lan bab tangi menèh sangka pati, apa kowé ora tau matya tembungé Gusti Allah marang kowé, sing uniné ngéné: ‘Aku iki Gusti Allahé Abraham, Gusti Allahé Isak lan Gusti Allahé Yakub!’ Gusti Allah kuwi dudu Gusti Allahé wong mati, nanging Gusti Allahé wong urip.” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sakwisé wong-wong krungu katerangan sing ngono kuwi, kabèh pada nggumun karo piwulangé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kadung para Farisi krungu nèk Gusti Yésus wis nylakepké wong Saduki, terus pada nglumpuk. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Enèng siji, sakwijiné guru Kitab, arep ngenèng Gusti Yésus nganggo pitakonan ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Guru, wèt sing endi nang Kitab sing gedé déwé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Gusti Yésus semaur: “Wèt sing gedé déwé ya iki: Kowé kudu trésna marang Gusti Allahmu sak atimu, sak nyawamu lan nganggo sak ènèngé pikiranmu. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iku wèt sing gedé déwé lan sing penting déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wèt liyané sing uga penting kaya sing ndisik kuwi ya iki: ‘Trésnaa marang pepadamu kaya enggonmu nrésnani awakmu déwé.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kabèh wèt-wèté nabi Moses lan sing diwulangké karo para nabi liyané tibané ya nang wèt loro kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dongé para Farisi ijik nglumpuk nang kono, Gusti Yésus terus takon marang wong-wong kuwi: “Kepriyé pinemumu bab Kristus? Dèkné kuwi turunané sapa ta?” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Wong-wong semaur: “Turunané ratu Daved.” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Gusti Yésus terus ngomong: “Lah nèk ngono, lah ratu Daved kok nyeluk Kristus kuwi Gusti? Awit katuntun Rohé Gusti Allah ratu Daved lak ngomong ngéné ta: ");
INSERT INTO jvnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Gusti Allah wis ngomong marang Gustiku: Kéné njagong nang tengenku, nganti mungsuhmu sak kabèhé wis tak telukké marang kowé.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Lah nèk ratu Daved nyeluk Kristus kuwi Gusti, lah mosok Kristus turunané ratu Daved?” ");
INSERT INTO jvnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ora ènèng wong siji waé sing bisa ngomong apa-apa. Wiwit dina kuwi ora ènèng wong sing wani takon-takon menèh marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Gusti Yésus terus ngomong ngéné marang wong-wong lan marang murid-muridé: ");
INSERT INTO jvnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Para guru Kitab lan para Farisi kuwi sing nduwèni kwasa ndunung-ndunungké wèt-wèté nabi Moses. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mulané kudu dilakoni lan kabèh piwulangé kudu dituruti sing sak mestiné. Nanging aja pada niru klakuané, awit wong-wong kuwi déwé ora pada nglakoni apa sing diwulangké. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pada nggawé pernatan-pernatan sing abot kanggo wong liyané, nanging wong-wong kuwi déwé ora pada nindakké. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Sembarang sing ditindakké namung supaya kétok wong. Kayadéné: nganggo tali sembayang amba nang batuké lan lengené, gombyoké saliné digawé dawa. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nèk nang kumpulan pésta seneng njagong nang jagongané wong gedé lan nèk nang sinaguk njaluké njagong nang ngarep déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nèk nang pasar-pasar seneng digatèkké lan njaluké dityeluk ‘Guru’. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nanging kowé aja seneng dityeluk ‘Guru’, awit gurumu namung siji lan kowé kabèh pada tunggal sedulur. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kowé uga aja nyeluk wong ing donya kéné ‘Bapak’, awit bapakmu namung siji, yakuwi sing nang swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kowé uga aja gelem dityeluk ‘Penuntun’, awit penuntunmu namung siji, yakuwi Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sing gedé déwé nang tengahmu kudu ngladèni liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sapa sing ngluhurké awaké déwé, iku bakal diasorké, malah sapa sing ngasorké awaké déwé, iku bakal diluhurké.” ");
INSERT INTO jvnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Gusti Yésus ngomong ngéné marang para guru Kitab lan para Farisi: “Tyilaka kowé, para guru Kitab lan para Farisi! Kowé kuwi wong lamis! Kowé pada ngalang-alangi wong-wong sing arep mlebu Kratoné Gusti Allah. Kowé déwé pada ora gelem, nanging wong liya sing gelem malah mbok alang-alangi. ( ");
INSERT INTO jvnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Tyilaka kowé, para guru Kitab lan para Farisi! Kowé wong lamis. Kowé pada nggolèk akal werna-werna kanggo meres randa-randa lan ngrampok omahé. Terus étok-étoké ndonga sing dawa. Mulané kowé bakal nampa setrapan sing luwih abot.) ");
INSERT INTO jvnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Tyilaka kowé, para guru Kitab lan para Farisi! Kowé kuwi wong lamis! Kowé pada lunga adoh, nganti nyabrang segara lan ndlajahi daratan kepéngin éntuk wong siji sing mèlu agamamu. Nanging nèk wongé wis mèlu agamamu, wongé mbok matengké kanggo neraka, malah alané wongé ping pindoné kowé déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Tyilaka kowé, penuntun-penuntun sing pityek. Kowé ngomong: ‘Sapa sumpah nyebut Gréja Gedé, wong kuwi ora ketyentyang sumpahé. Nanging sapa sumpah nyebut emasé Gréja Gedé, sumpah kuwi nyentyang.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kowé kuwi pantyèn wong bodo lan pityek. Awit, apa sing luwih gedé ajiné: emasé apa Gréja Gedé, sing nyutyèkké emasé? ");
INSERT INTO jvnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kowé uga mulang ngéné: ‘Sapa sumpah nyebut altaré Gusti Allah, wong kuwi ora ketyentyang sumpahé. Nanging sapa sumpah nyebut kurban sing nang altar, wong kuwi ketyentyang marang sumpahé.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kowé pantyèn wong pityek tenan! Apa sing luwih gedé ajiné: kurbané apa altaré, sing nyutyèkké kurban kuwi? ");
INSERT INTO jvnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sapa sing sumpah nyebut altaré Gusti Allah, kuwi sumpahé nyebut altaré lan sembarang sing temumpang nang altar kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Lan sapa sing sumpah nyebut Gréja Gedé kuwi sumpah nyebut Gréja Gedé lan Gusti Allah sing manggon nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sapa sing sumpah nyebut swarga, kuwi tegesé sumpah nyebut damparé Gusti Allah lan Gusti Allah déwé sing njagong nang dampar kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tyilaka kowé, para guru Kitab lan para Farisi. Kowé kuwi wong lamis. Awit kowé mbayar prasepuluhan sangka bumbu kayadéné telasih, adas lan jinten, nanging pernatan-pernatan sing luwih penting ora mbok lakoni, kayadéné kabeneran, kawelasan lan katemenan. Bener, sing siji kudu mbok tindakké, nanging liyané aja dilirwakké. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kowé pantyèn penuntun-penuntun sing pityek. Lemut mbok saring sangka ombèn-ombènmu, nanging unta mbok elek. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tyilaka kowé, para guru Kitab lan para Farisi! Kowé kuwi wong lamis. Awit tyangkir lan piring mbok resiki njabané, nanging njeroné kebek karo rereget sangka enggonmu ngrampas, jalaran sangka srakahmu. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kowé pantyèn wong Farisi sing pityek. Tyangkir lan piring kuwi kudu mbok resiki njeroné ndisik, mengko njabané uga dadi resik. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Tyilaka kowé, para guru Kitab lan para Farisi! Kowé kuwi wong lamis. Awit kowé kuwi kaya kuburan sing dietyèt putih. Sangka njaba pantyèn kétoké apik, nanging njeroné kebek karo balungé wong mati sing wis bosok kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kowé pantyèn kaya ngono kuwi: sangka njaba kowé kétok apik, nanging njeroné batinmu kebek lelamis lan ala. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Tyilaka kowé, para guru Kitab lan para Farisi. Kowé kuwi pantyèn wong lamis. Kowé pada nggawèkké kuburan kanggo para nabi lan ngapik-apikké watu pengéling-élingé wong-wong sing apik uripé. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kowé pada ngomong: ‘Semunggoné aku urip ing jamané para mbah-mbahanku, aku mesti ora matèni para nabi.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dadiné kowé déwé pada ngakoni nèk kowé kuwi turunané wong-wong sing pada matèni para nabi. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kono diteruské lan ditutukké pisan dosa-dosané mbah-mbahanmu kuwi! ");
INSERT INTO jvnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kowé kuwi ula lan anakan ula. Kepriyé enggonmu arep nyimpangi setrapanmu nang neraka? ");
INSERT INTO jvnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mulané dirungokké sing apik. Aku bakal ngongkon nabi-nabi, wong-wong sing nduwé kaweruh lan guru-guru teka nang nggonmu. Saloké bakal mbok patèni lan mbok pentèng, liyané menèh bakal mbok petyuti nang sinagukmu apa mbok oyak-oyak sangka kuta sijiné lunga nang kuta liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Entèk-entèké kowé bakal disetrap, jalaran kowé pada matèni wong-wong sing ora salah, wiwit Abel tekané Sakaria, anaké Bérékia, sing mbok patèni nang tengahé panggonan sutyi lan altar. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pada ngertia: kabèh dosa kuwi bakal ditibakké nang tangané wong-wong ing jaman saiki.” ");
INSERT INTO jvnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Gusti Yésus terus ngomong ngéné bab kuta Yérusalèm: “Yérusalèm, Yérusalèm! Kowé wis matèni nabi-nabi lan mbandemi watu marang wong-wong kongkonané Gusti Allah. Wis ping pira enggonku kepéngin nglumpukké anak-anakmu kaya pitik babon sing nglumpukké anak-anakané nang ngisoré swiwiné. Nanging kowé ora gelem. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Titènana, omahmu bakal ditinggal suwung lan dadi sepi. ");
INSERT INTO jvnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Dirungokké omongku iki: wiwit saiki kowé ora bakal weruh Aku, nganti kowé bakal ngomong: ‘Nampaa berkah sing teka ing jenengé Gusti.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sakwisé kuwi Gusti Yésus terus lunga sangka Gréja Gedé kono. Murid-muridé terus pada mara lan nduduhké gedong-gedongé Gréja Gedé marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Gusti Yésus terus ngomong: “Kowé pada ngematké gedong-gedong kuwi, nanging pada ngertia, mbésuk bakal ora ènèng watu siji waé temumpang liyané. Kabèh ambruk dadi rata karo lemahé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Gusti Yésus terus munggah nang gunung Olèf lan njagong nang kono. Murid-muridé terus pada mara. Kejaba murid-muridé ora ènèng wong liyané. Murid-muridé terus takon marang Dèkné: “Gusti, awaké déwé kepéngin ngerti kapan kuwi bakalé klakon. Awaké déwé uga kepéngin ngerti apa tanda-tandané tekané Gusti lan apa tanda-tandané entèk-entèkané jaman?” ");
INSERT INTO jvnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Gusti Yésus terus ngomong: “Kowé pada sing ati-ati, aja sampèk kenèng diapusi wong. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Awit okèh wong bakal teka nganggo jenengku lan ngomong: ‘Aku iki Kristus!’ Lan mengkono kuwi wong pirang-pirang bakal disasarké. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kowé bakal krungu kabar-kabar bab peperangan lan bab peperangan sing bakal teka. Nanging aja pada bingung, awit kuwi kabèh kudu klakon. Nanging kuwi durung entèk-entèkané. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Awit bangsa sing siji bakal perang nglawan bangsa liyané lan negara sijiné bakal perang nglawan negara liyané. Nang endi-endi bakal ènèng kurang pangan lan lindu. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nanging kuwi mau kabèh namung wiwitané kasangsaran sakdurungé jaman anyar teka, kaya wong sing nglarani kaé, sakdurungé mbayi. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ing waktu kuwi kowé bakal dityekel lan dipasrahké, supaya dipilara lan dipatèni. Sakkèhé bangsa bakal pada sengit karo kowé, jalaran kowé muridku. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mulané okèh wong uga sing ora bakal temen mèlu Aku, nanging pada semplak pengandelé. Sing siji bakal masrahké liyané supaya dipilara lan sing siji bakal nyengiti liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Okèh nabi palsu bakal njedul lan nyasarké wong okèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tumindak ala bakal tambah okèh, mulané katrésnan bakal suda. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nanging sapa sing mantep terus tekan entèk-entèkané, kuwi sing bakal slamet. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kabar kabungahan bab Kratoné Gusti Allah bakal digelar nang sak jagat, supaya kabèh bangsa pada ngerti. Sakwisé kuwi klakon, entèk-entèkané jaman bakal teka.” ");
INSERT INTO jvnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Gusti Yésus neruské tembungé ngéné: “Kowé bakal weruh Nggegilané Karusakan ngadek nang panggonan sutyi. Nabi Danièl wis ngomongké bab iku. Sapa sing matya iku mikira sing apik, supaya bisa dunung tegesé. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nèk kuwi klakon, wong-wong sing nang bawah Yudéa pada mblayua nang gunung-gunungan. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wong-wong sing ijik nang nduwur omah, aja pada medun njikuk barang-barangé omahé. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wong-wong sing ijik nang kebon, aja pada mulih njikuk saliné. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Melaské banget wong wédok sing ing waktu kuwi pada meteng lan sing pada nyusoni. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ndedongaa marang Gusti Allah, supaya enggonmu lunga ora tiba wayah adem apa dina sabat. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Awit ing waktu kuwi bakal ènèng kasusahan gedé banget, sing durung tau klakon wiwit jagat digawé tekan sepréné. Lan kasusahan gedé sing kaya ngono kuwi ora bakal klakon menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Semunggoné waktuné kasusahan kuwi ora dityekakké karo Gusti Allah, mesti ora ènèng wong siji waé bisa urip. Nanging jalaran sangka wong-wong sing wis dipilih karo Gusti Allah, waktu kuwi dityekakké. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ing waktu kuwi, nèk ènèng wong ngomong marang kowé: ‘Lah iki Kristus nang kéné,’ apa ‘Lah kaé Kristus nang kana,’ aja pada ngandel. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Awit kristus-kristus palsu lan nabi-nabi palsu bakal pada njedul lan bakal pada nindakké mujijat-mujijat lan tanda-tanda sing nggumunké kanggo nyasarké wong. Malah semunggoné bisa ngono arep nyasarké para pilihané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mulané pada diéling-éling! Aku wis ngomongi kowé sakdurungé kuwi mau klakon. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nèk ènèng wong ngomongi kowé: ‘Lah kaé Kristus nang wustèn,’ kowé aja mbrana. Apa nèk wong-wong ngomong: ‘Lah kaé Dèkné ndelik nang kana,’ kowé aja ngandel. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Awit kaya enggoné klélapé bledèk ngebyar sangka wétan lan padangé semlorot tekan kulon, mengkono mbésuk tekané Anaké Manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Nang endi sing ènèng batang, mesti manuk gagak pada nglumpuk.” ");
INSERT INTO jvnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Gusti Yésus terus ngomong menèh: “Sakwisé wayah kasangsaran kuwi, srengéngé bakal dadi peteng lan mbulané ora bakal semlorot menèh. Lintang-lintang bakal pada tiba sangka langit lan pangwasa-pangwasa nang langit bakal hoyak kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sakwisé kuwi tandané Anaké Manungsa bakal kétok nang langit. Sakkèhé bangsa nang bumi bakal pada nangis lan sambat lan bakal pada weruh Anaké Manungsa teka nang mégané langit, nganggo pangwasa lan kamulyan sing gedé. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Trompèt sing swarané banter banget bakal diunèkké lan para mulékat bakal dikongkon lunga nglumpukké umat pilihané Gusti Allah sangka wétan, kulon, lor lan kidul, sangka pojoké bumi sing sijiné tekan pojok sing liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Gusti Yésus terus ngekèki piwulang ngéné: “Mbok dititèni wit anjir kaé. Nèk pangé wis ijo lan memes lan molai metu godongé, kowé ngerti nèk wayah panas wis tyedek. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mengkono uga, nèk kowé weruh sembarang sing tak omong mau klakon, kuwi tandané nèk tekané Anaké Manungsa wis tyedek banget. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pada élinga! Wong-wong sing urip ing jaman iki bakal pada menangi prekara-prekara kuwi mau kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Langit lan bumi bakal ilang, nanging tembungku bakal ènèng terus slawas-lawasé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Gusti Yésus neruské tembungé ngéné: “Bab dinané lan jamé tekané Anaké Manungsa ora ènèng wong siji waé sing ngerti. Para mulékat nang swarga ora ngerti lan Anaké Gusti Allah ya ora ngerti. Sing ngerti namung Gusti Allah Bapaké. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kaya jamané nabi Noah, mengkono uga mbésuk jamané tekané Anaké Manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Awit ing dina-dina sakdurungé udan gedé teka, wong-wong pada mangan-ngombé lan kawin, nganti dinané enggoné nabi Noah munggah nang kapalé. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wong-wong ora pada dunung apa sing klakon, nganti tekané udan gedé, terus pada ngerti. Mengkono uga bakalé lelakoné nèk Anaké Manungsa teka. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ing waktu kuwi bakal ènèng wong lanang loro pada nyambutgawé nang kebon, sing siji digawa, sing liyané ditinggal. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Enèng wong wédok loro ijik nggiling gandum, sing siji digawa, sing liyané ditinggal. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Mulané, pada sing awas lan ati-ati, awit kowé ora ngerti kapan tekané Gustimu. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Elinga iki, semunggoné sing nduwé omah ngerti waktuné tekané malingé, dèkné mesti ora bakal turu lan ora bakal nglilani omahé dibobol. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mulané pada jaga-jaga, awit Anaké Manungsa tekané ing waktu sing ora mbok jagakké.” ");
INSERT INTO jvnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Gusti Yésus terus ngomong: “Slaf sing endi sing temen lan sing pinter, sing didadèkké pengarepé slaf-slaf liyané lan ngekèki pangané marang slaf-slaf kuwi nèk wis pener waktuné? ");
INSERT INTO jvnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Beja tenan slaf sing ketemu ijik ngerjani penggawéané nèk sing nduwé omah teka. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ngandela, slaf kuwi bakal dipasrahi ngurusi kabèh bandané sing nduwé omah. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nanging nèk slaf mau ala atiné lan nduwé gagasan ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Ah, gustiku bakalé ora ndang teka kok,’ terus dèkné molai nyiya-nyiya slaf-slaf liyané lan malah mangan lan ngombé bebarengan karo wong-wong sing seneng mabuk. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Lah sing nduwé omah terus teka ing dina sing ora dijagakké lan ing jam sing ora dingertèni sakdurungé. ");
INSERT INTO jvnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Slaf kuwi bakal disetrap karo sing nduwé omah, tunggalé waé karo setrapané wong lamis. Nang kono slaf mau bakal tangisan lan ngerot untu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Saiki Gusti Yésus mulangi ngéné: “Nèk Anaké Manungsa teka lan ngwasani Kratoné Gusti Allah, kuwi kenèng digambarké karo prawan sepuluh sing arep ngiring mantèn lan pada nggawa ontyor kaé, metuk mantèn lanang. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Prawan sepuluh kuwi sing lima goblok lan sing lima pinter. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Prawan lima sing goblok pada nggawa ontyor, nanging ora nggawa lenga sèrep. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lah prawan lima sing pinter nggawa ontyor lan nggawa lenga sèrep. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kadung mantèné lanang ora teka-teka, prawan-prawan mau pada ngantuk, sampèk keturon. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nang tengahé wengi ènèng wong tyeluk-tyeluk: ‘Mantèné teka, hayuk pada metuk!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Prawan sepuluh mau terus pada tangi lan njikuk ontyoré déwé-déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Prawan lima sing goblok terus nembung marang prawan-prawan sing pinter: ‘Mbok aku dikèki lengamu setitik, awit ontyorku arep mati.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Prawan-prawan sing pinter semaur: ‘Ora, mengko awaké déwé kabèh ndak kekurangan lenga. Kana nggolèk déwé nang setur nèk butuh.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kadung prawan-prawan sing goblok mau pada budal tuku lenga, mantèné lanang teka. Prawan-prawan sing wis tata-tata mau terus pada ngiring mantèné mlebu nang omahé sing nduwé gawé. Lawangé terus dikantying. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ora let suwi prawan-prawan sing tuku lenga mau pada teka terus tyeluk-tyeluk: ‘Bapak, bapak, mbok dibukak lawangé!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nanging mantèn lanang mau semaur: ‘Kowé sapa, aku ora kenal kowé!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Gusti Yésus terus nutup piwulangé ngéné: “Mulané pada melèka, awit kowé ora ngerti dinané apa jamé tekané Anaké Manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Gusti Yésus terus ngekèki gambar liyané: “Nèk Anaké Manungsa teka ngwasani Kratoné Gusti Allah, kuwi kenèng digambarké karo sakwijiné wong sing arep lunga nang negara adoh. Wongé nyeluk slaf-slafé, terus dipasrahi bandané. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sing siji dikèki duwit emas limang èwu, sing liyané rong èwu lan sing nomer telu dikèki sèwu. Siji-sijiné dikèki duwit manut kapinterané déwé-déwé. Sakwisé kuwi wongé terus budal. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Slaf sing nampa duwit emas limang èwu terus budal nglakokké duwité lan éntuk bati limang èwu duwit emas. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Semono uga slaf sing nomer loro, dèkné éntuk bati rong èwu. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nanging slaf sing nampa duwit emas sèwu malah ngeduk luwangan lan duwité sing nduwé omah dipendem nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Let suwi sing nduwé omah mulih, terus slafé dikongkon teka ngekèki laporan. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Slaf sing nampa duwit emas limang èwu maju terus masrahké batiné limang èwu karo ngomong: ‘Gusti, aku mbok pasrahi duwit emas limang èwu, lah iki delokké, aku éntuk bati limang èwu.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sing nduwé omah semaur: ‘Apik banget, kowé slaf sing apik lan sing temen. Jalaran duwit setitik mbok lakokké apik, kowé saiki tak pasrahi duwit sing okèh. Réné mlebua lan mèlua ngrasakké kabungahanku.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Uga slaf sing nampa duwit emas rong èwu maju. Dèkné ngomong: ‘Gusti, kowé ngekèki duwit emas rong èwu marang aku, lah iki delokké, tak tambahi rong èwu batiné.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sing nduwé omah semaur: ‘Apik banget. Kowé pantyèn slaf sing apik lan sing temen. Duwit setitik mbok lakokké apik, mulané kowé saiki tak pasrahi duwit sing okèh. Réné mlebua lan mèlua ngrasakké kabungahanku.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Sakwisé kuwi terus slaf sing nampa duwit emas sèwu maju. Tembungé dèkné ngéné: ‘Gusti, aku ngerti nèk kowé kuwi wong kereng. Awit kowé ngunduh nang panggonan sing kowé déwé ora nyebar lan kowé narik tanpa masang déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mulané aku wedi lan duwitmu tak pendem nang lemah. Lah iki duwitmu tampanen.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Sing nduwé omah terus ngomong: ‘Kowé kuwi slaf sing ala lan males. Kowé ngerti nèk aku ngunduh nang panggonan sing aku déwé ora nyebar lan aku narik barang sing aku déwé ora masang. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ajuré duwitku mbok dèkèk nang bank, dadiné aku bisa éntuk duwitku karo rèntené. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Duwit emas sèwu kuwi dijaluk lan dikèkké marang slaf sing wis nduwé sepuluh èwu. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Awit sapa sing wis nduwé, kuwi bakal dikèki luwih okèh menèh sampèk lubèr. Nanging sapa sing ora nduwé, barang setitik sing diduwèni kuwi malah bakal dijaluk kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Saiki, slaf sing ora ènèng gunané kuwi dityekel lan dietokké nang pepeteng. Nang kono bakal tangisan lan ngerot untu.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Gusti Yésus terus ngomong ngéné: “Mbésuk nèk Anaké Manungsa teka nganggo pangwasané lan diarak-arak karo sakkèhé mulékaté, Dèkné bakal njagong nang damparé kaswargan. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Para mulékaté bakal nglumpukké kabèh bangsa nang ngarepé damparé. Dèkné bakal misah wong-wong mau dadi loro, kaya enggoné tukang angon kaé misah wedusé gèmbèl sangka wedus bandot. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wedusé gèmbèl disingkirké nang tengené lan wedusé bandot nang kiwané. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ratuné terus bakal ngomong marang wong-wong sing nang tengené: ‘Bapakku wis mberkahi kowé. Pada mbrénéa. Kowé bakal ngrasakké berkahé Kratoné Gusti Allah sing wis dityawiské kanggo kowé wiwit lairé jagat. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Awit dongé Aku ngelih, Aku mbok kèki mangan. Aku ngelak, Aku mbok kèki ngombé. Dongé Aku sangka panggonan adoh, Aku mbok kèki inepan. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Dongé Aku ora nduwé salin, Aku mbok kèki salin. Dongé Aku lara, Aku mbok rumati. Dongé Aku nang setrapan, Aku mbok tiliki.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Nang kono wong-wong sing resik atiné bakal pada ngomong: ‘Gusti, kapan awaké déwé weruh Kowé ngelih terus ngekèki mangan apa weruh Kowé ngelak terus ngekèki ngombé Kowé? ");
INSERT INTO jvnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Awaké déwé ora tau weruh Kowé kaya wong sangka panggonan adoh apa ora nduwé salin. Lah kapan awaké déwé ngekèki inepan apa ngekèki salin Kowé? ");
INSERT INTO jvnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Awaké déwé ora tau weruh Kowé lara apa nang setrapan. Lah kapan awaké déwé niliki Kowé?’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ratuné bakal semaur marang wong-wong sing nang tengené: ‘Pada élinga, apa waé sing mbok tindakké marang salah-sakwijiné sedulurku iki, senajana marang sing tyilik déwé, kuwi pada waé karo nèk mbok tindakké marang Aku.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ratuné uga bakal ngomong marang wong-wong sing nang sebelah kiwané: ‘Pada lunga sangka ngarepku! Gusti Allah wis nampik kowé. Lungaa nang geni sing langgeng, sing wis dityawiské kanggo Sétan lan para mulékaté. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Awit dongé Aku ngelih, kowé ora ngekèki mangan Aku. Aku ngelak, Aku ora mbok kèki ngombé. ");
INSERT INTO jvnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aku sangka panggonan adoh, Aku ora mbok kèki inepan. Aku ora nduwé salin, aku ora mbok kèki salin. Dongé Aku lara lan dongé Aku nang setrapan, kowé ora niliki Aku.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Wong-wong kuwi terus bakal takon: ‘Gusti, kapan awaké déwé weruh kowé ngelih apa ngelak? Lan kapan awaké déwé weruh Kowé kaya wong sing sangka panggonan adoh? Lan kapan awaké déwé weruh Kowé lara apa nang setrapan? Ora tau! Mulané awaké déwé ya ora nulungi!’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ratuné bakal semaur: ‘Rungokké sing apik! Apa waé sing ora mbok tindakké marang salah-sakwijiné wong sing tyilik déwé iki, kuwi ya ora mbok tindakké marang Aku.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wong-wong kuwi bakal nampa setrapan langgeng, nanging wong sing resik atiné bakal nampa urip langgeng.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sakwisé Gusti Yésus rampung enggoné mulangké bab kuwi mau kabèh, Dèkné terus ngomong marang murid-muridé: ");
INSERT INTO jvnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kowé wis pada ngerti nèk riyaya Paskah wis kurang rong dina menèh lan Anaké Manungsa bakal dityekel lan dipentèng.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ing waktu kuwi para pengarepé imam lan para pinituwané bangsa Ju pada nglumpuk nang omahé Imam Gedé Kayafas. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Para pengarepé imam lan para pinituwa mau pada rembukan bab kepriyé akalé enggoné arep nyekel lan matèni Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nanging pada ngomong: “Sing nyekel aja tiba dina riyaya Paskah lo, mengko ndak marakké ramé lan gègèran.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Gusti Yésus saiki nang désa Bétani. Dèkné merdayoh nang omahé Simon sing mauné lara lépra. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Dongé Gusti Yésus ijik jagongan mangan, terus ènèng wong wédok teka, nggawa botol isiné lenga wangi sing larang banget. Wongé terus nglengani sirahé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Para murid weruh kuwi mau terus pada nesu lan pada ngomong marang sakpada-pada: “Apa kuwi ora ngetyèh-etyèh duwit? ");
INSERT INTO jvnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Lenga wangi kuwi nèk diedol apa ora payu okèh lan duwité apa ora kenèng dikèkké wong sing ora nduwé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Gusti Yésus ngerti rembukané para muridé terus ngomong: “Kenèng apa kowé kok pada ngrasani ala marang wong wédok iki. Wong iki lak nglakoni barang sing betyik marang Aku ta? ");
INSERT INTO jvnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wong ora nduwé kuwi slawasé ya bakal ènèng terus nang tengahmu, nanging Aku ora slawasé bakal tyampur karo kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wong iki enggoné ngesokké lenga nang awakku iki kanggo tyetyawis penguburanku. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pada titènana! Nang endi waé sing digelari kabar kabungahané Gusti Allah, apa sing ditindakké karo wong wédok iki ya bakal diomongké, kanggo pengéling-éling marang dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sangka murid-muridé Gusti Yésus rolas ènèng siji, yakuwi Yudas Iskariot, sing lunga nang nggoné para pengarepé imam. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yudas terus takon: “Pira upahé nèk aku masrahké Yésus marang kowé?” Yudas terus dikèki duwit selaka telung puluh. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wiwit waktu kuwi dèkné terus nggolèk kelunggaran kanggo masrahké Gusti Yésus marang para pengarepé imam. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Saiki wis dina wiwitané Riyaya Pésta Roti Tanpa Ragi. Para murid pada mara nang nggoné Gusti Yésus terus takon: “Gusti, Kowé njaluk mangan Pésta Paskah nang endi? Dadiné awaké déwé bisa tyetyawis.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Gusti Yésus terus nyeluk jenengé sakwijiné wong nang kuta: “Kana nang omahé wong kuwi lan ngomong: ‘Guruné ngomong: waktuku wis teka, Aku kepéngin mangan Pésta Paskah karo murid-muridku nang omahmu.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Murid-murid mau terus budal lan nindakké apa sing diomong karo Gusti Yésus, terus pada nyawiské Pésta Paskah. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Mbenginé Gusti Yésus mangan bebarengan karo murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dongé ijik pada mangan, Gusti Yésus ngomong: “Aku ngomongi kowé nèk siji sangka tengahmu bakal ngelungké Aku marang wong-wong sing arep matèni Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Murid-muridé pada sedi banget krungu Gusti Yésus ngomong kuwi mau, terus gentènan takon: “Lak dudu aku ta Gusti?” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Gusti Yésus semaur: “Wong sing ngetylupké rotiné nang mangkok bareng karo Aku, yakuwi sing bakal ngelungké Aku. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Anaké Manungsa pantyèn kudu mati, awit nang Kitab wis ketulis bab enggoné Dèkné bakal mati. Nanging tyilaka tenan wong sing ngelungké Anaké Manungsa. Luwih apik semunggoné wong kuwi ora lair waé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas, sing bakal ngelungké Gusti Yésus, terus takon: “Apa Kowé ngomongké aku Guru?” Gusti Yésus semaur: “Kowé déwé sing ngomong.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dongé pada mangan, Gusti Yésus njikuk roti terus ndonga, maturkesuwun marang Gusti Allah. Rotiné terus dityuwil-tyuwil terus dikèkké marang murid-muridé, tembungé: “Pada ditampani lan dipangan, iki awakku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sakwisé kuwi Gusti Yésus terus njikuk ombèné. Sakwisé didongakké lan maturkesuwun marang Gusti Allah, Dèkné terus ngelungké ombèné marang murid-muridé karo ngomong: “Pada ngombéa kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Awit iki getihku kanggo netepké prejanjiané Gusti Allah. Getihku iki mili kanggo wong okèh, supaya bisa nampa pangapura sangka dosané. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pada ngertia, Aku bakal ora ngombé anggur iki menèh nganti waktuné Aku bakal ngombé anggur anyar karo kowé kabèh ing Kratoné Gusti Allah Bapakku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sakwisé kuwi Gusti Yésus lan para muridé terus pada menyanyi lan memuji, terus budal nang gunung Olèf. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Gusti Yésus terus ngomong ngéné marang murid-muridé: “Ing wengi iki waé kowé bakal pada mblayu ninggal Aku ijèn. Awit nang Kitab ya wis ketulis ngéné: ‘Gusti Allah bakal matèni pangoné lan wedus-wedusé bakal buyar.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nanging nèk Aku wis tangi sangka pati, Aku bakal budal nang bawah Galiléa, ndisiki kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Rasul Pétrus terus ngomong ngéné marang Gusti Yésus: “Gusti, senajan murid-murid liyané ninggal Kowé, aku ora pisan-pisan bakal ninggal Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Gusti Yésus semaur ngéné: “Rungokké Pétrus, ing wengi iki waé, sakdurungé jago kluruk, kowé bakal nyélaki Aku sampèk ping telu.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nanging rasul Pétrus ngomong: “Gusti, Aku ora pisan-pisan bakal ninggal Kowé, senajan aku kudu mati bareng karo Kowé.” Lan murid-murid liyané uga kabèh pada ngomong ngono. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sakwisé kuwi Gusti Yésus terus budal karo murid-muridé nang panggonan sing jenengé Gètsémané. Nang kono Gusti Yésus terus ngomong marang murid-muridé: “Kowé pada njagong nang kéné waé. Aku arep mbrana ndonga.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Gusti Yésus terus ngejèk rasul Pétrus lan anaké Sébédéus kabèh loro. Nang kono Gusti Yésus terus kétok sedi lan wedi banget. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dèkné terus ngomong marang murid-murid kuwi: “Atiku jan sedi banget, rasané kaya wong arep mati. Pada ngentèni nang kéné lan Aku diréwangi melèk.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gusti Yésus terus mlaku rada adoh, terus niba lan ndonga: “Duh Gusti Allah Bapakku, nèk Kowé gelem, mbok kasangsaran iki disimpangké sangka Aku. Nanging ora kekarepanku, mung kekarepanmu sing kudu klakon.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Gusti Yésus terus balik menèh lan nemu murid sing telu mau pada turu. Gusti Yésus terus ngomong marang rasul Pétrus: “Mosok kowé kabèh telu ora ènèng sing bisa ngréwangi Aku melèk namung sak jam waé? ");
INSERT INTO jvnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pada melèka lan pada ndedongaa, supaya ora tiba ing panggoda. Pantyèn, atiné kepéngin nglakoni sing betyik, nanging awaké ora kuwat.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Gusti Yésus terus lunga menèh ping pindoné ndedonga ngéné: “Gusti Allah Bapakku, nèk kasangsaran iki pantyèn ora kenèng disimpangké, ya mosok bodo, apa karepmu kudu klakon.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Gusti Yésus terus balik menèh, nanging nemu muridé telu mau ijik pada turu menèh, awit mripaté ora kuwat melèk. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Murid-muridé kuwi terus ditinggal menèh lan Gusti Yésus terus ndonga ping teluné, ya kaya sing ndisik. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sakwisé kuwi Dèkné terus marani murid-muridé. Dèkné ngomong: “Ijik pada turu lan lèrèn? Saiki wis waktuné, Anaké Manungsa bakal dipasrahké marang wong dosa. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hayuk pada tangi lan hayuk pada lunga. Delokké, wong sing ngelungké Aku wis teka.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Gusti Yésus durung sampèk rampung sing ngomong, kok Yudas, salah-sakwijiné murid sing rolas, teka. Dèkné teka bareng karo wong okèh sing nggawa pedang lan pentung. Wong-wong kuwi dikongkon karo para pengarepé imam lan para pinituwané bangsa Ju. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas wis nggawé tengeran karo wong-wong kuwi ngéné: “Wong sing tak ambung, yakuwi wongé. Wong kuwi sing kudu mbok tyekel.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yudas terusan marani Gusti Yésus terus ngomong: “Slamet Guru,” terus ngambung Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Gusti Yésus terus semaur: “Ndang ditindakké apa sing mbok karepké!” Wong-wong terus pada maju nyekel Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Salah-sakwijiné muridé Gusti Yésus terus narik pedangé dienggo nyabet kupingé slafé Imam Gedé. Kupingé tyepol. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Gusti Yésus terus ngomong: “Pedangmu lebokké menèh! Awit sapa waé sing nganggokké pedangé, bakal mati karo pedang. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Apa kowé mikir nèk Aku ora bisa nyuwun marang Bapakku. Nèk Aku gelem, Dèkné bisa ngongkon mulékat-mulékaté teka sakwat, ngungkuli rolas golongan. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lah nanging semunggoné ngono, lah kepriyé sing ketulis nang Kitab bisané keturutan? Awit nang Kitab wis ketulis nèk kabèh iki kudu keturutan.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Gusti Yésus saiki ngomong marang wong-wong: “Apa rumangsamu Aku iki wong tukang ngrampok, kok kowé arep nyekel Aku nganggo pedang lan pentung? Saben dina Aku lak mulangi nang Gréja Gedé ta? Lah kok ora mbok tyekel Aku? ");
INSERT INTO jvnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nanging kabèh iki kudu klakon ngéné, supaya apa sing wis ditulis karo para nabi nang Kitab bisa keturutan.” Sakwisé kuwi para muridé Gusti Yésus terus ninggal Dèkné lan pada mblayu lunga. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Gusti Yésus terus digawa nang omahé Imam Gedé Kayafas. Nang kono para guru Kitab lan para pinituwané bangsa Ju wis pada nglumpuk. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Rasul Pétrus ngetutké Gusti Yésus sangka kadohan, sampèk tekan lataré omahé Imam Gedé. Rasul Pétrus terus mlebu, terus njagong kono karo wong-wong sing jaga. Dèkné kepéngin weruh kepriyé bakalé entèk-entèkané. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Imamé Gedé lan para wargané Kruton Agama kabèh pada nggolèk akal arep nyalahké Gusti Yésus nganggo seksi-seksi palsu, supaya Dèkné éntuk setrapan pati. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nanging senajan okèh wong sing pada maju lan gelem dadi seksi, paseksiné ora ènèng buktiné. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Terus ènèng wong loro maju ngomong: “Wong kuwi tau ngomong: ‘Aku bisa mbubrah Gréja Gedé lan bisa ngedekké menèh ing sakjeroné telung dina.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Imam Gedé terus ngadek lan takon: “Apa Kowé ora arep semaur apa-apa enggoné wong-wong kuwi nyalahké Kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nanging Gusti Yésus meneng waé. Imam Gedé terus ngomong menèh: “Ing jenengé Gusti Allah sing urip, apa Kowé ngaku nèk Kowé Kristus, Anaké Gusti Allah?” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Gusti Yésus semaur: “Pantyèn bener. Nanging ngertia, wiwit saiki kowé bakal weruh Anaké Manungsa njagong nang tengené Gusti Allah sing kwasa déwé. Kowé bakal weruh Dèkné teka nang méga nang langit.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Krungu tembungé Gusti Yésus kuwi mau, Imam Gedé terus nyuwèk-nyuwèk saliné karo ngomong: “Wong iki ngolok-olok Gusti Allah! Wis ora mbutuhké seksi menèh! Kowé kabèh pada krungu déwé enggoné wong kuwi ngolok-olok Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Saiki kepriyé pinemumu?” Kabèh terus semaur: “Wong kuwi salah, kudu dipatèni!” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wong-wong terus ngidoni lan ngantemi Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Enèng liyané sing ngeplak Dèkné karo ngomong: “Jajal bedèken, Kristus, sapa sing ngeplak Kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Rasul Pétrus ijik njagong nang njaba, nang latar. Terus ènèng wong wédok slafé Imam Gedé marani dèkné karo ngomong: “Lo, kowé lak mèlu Yésus ta, wong sangka Galiléa kaé?” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nanging rasul Pétrus ora ngaku. Nang ngarepé wong okèh kono dèkné ngomong: “Aku ora ngerti apa sing mbok omong kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Rasul Pétrus terus lunga sangka lataré kono terus mlaku lawang ngarep. Nang kono ènèng slaf wédok liyané sing weruh dèkné. Wongé ngomong karo wong-wong liyané sing nang kono: “Wong iki uga mèlu Yésus sangka Nasarèt kaé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nanging sepisan menèh rasul Pétrus ora ngaku, malah wani sumpah ngomong: “Aku blas ora kenal marang wong kuwi!” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ora let suwi wong-wong sing nang kono pada marani rasul Pétrus terus ngomong: “Pantyèn, kowé uga mèlu Yésus, awit ketara omonganmu!” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Rasul Pétrus terus sumpah menèh: “Aku wani mati, aku jan ora kenal tenan karo wong kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ing waktu kuwi terus ènèng jago kluruk. Rasul Pétrus sakwat kélingan tembungé Gusti Yésus, dongé Dèkné ngomong: “Sakdurungé jago kluruk, kowé bakal sélak nganti ping telu, nèk kowé ora kenal Aku.” Rasul Pétrus terus metu sangka panggonan kono lan nangis kelara-lara. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Esuké kabèh pengarepé imam lan para pinituwané bangsa Ju pada nggawé putusan arep matèni Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dèkné terus dibanda lan digawa lunga, arep dipasrahké marang Pilatus, gramangé bawah kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kadung Yudas ngerti nèk Gusti Yésus bakal dipatèni, dèkné terus gela tenan. Yudas iki sing ngelungké Gusti Yésus marang mungsuhé. Dèkné terus mbalèkké duwité telung puluh sèkel selaka marang para pengarepé imam lan para pinituwané bangsa Ju. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yudas ngomong ngéné: “Aku nggawé dosa, awit aku ngelungké wong sing ora salah, marakké Dèkné éntuk setrapan pati.” Nanging para pengarepé imam lan para pinituwa mau semaur: “Awaké déwé ora ngerti jawané, iku urusanmu déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudas terus nguntyalké duwité nang Gréja Gedé, mlaku lunga terus nggantung. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Para pengarepé imam terus njikuki duwité karo ngomong: “Iki duwit sing gupak getih, ora kenèng dilebokké nang wadah duwit kurban.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Terus pada setuju nèk duwité dienggo tuku keboné wong sing tukang nggawé kendi. Kebon kuwi arep dienggo kuburané wong sangka liya negara sing mati nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mulané tekan sepréné kebon kuwi dijenengké Akeldama, tegesé: kebon gupak getih. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kuwi mau kabèh marakké klakon apa sing wis diomong karo nabi Yéremia dèk mbiyèn, uniné: “Pada nampa duwit telung puluh sèkel selaka, yakuwi regané wong siji miturut timbangané wong Israèl. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Duwit mau dienggo nuku keboné tukang nggawé kendi. Kuwi tembungé Gusti marang aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gusti Yésus terus ditakon-takoni karo gramang Pilatus. Pitakonané ngéné: “Apa Kowé ratuné wong Ju?” Gusti Yésus semaur: “Ya, kuwi bener.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Para pengarepé imam lan para pinituwané bangsa Ju terus pada nyalah-nyalahké Gusti Yésus, nanging Dèkné meneng waé. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Gramang Pilatus terus takon: “Apa Kowé ora krungu enggoné wong-wong pada nyalahké Kowé bab werna-werna prekara?” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nanging Gusti Yésus ora semaur apa-apa blas, marakké Pilatus nggumun banget. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lumrahé, saben taun nèk wayah dina Paskah, Pilatus ngetokké setrapan siji, sing dipilih karo wong okèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ing waktu kuwi ènèng setrapan sing jenengé Barabas. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kadung wong sing pada nglumpuk wis okèh, Pilatus terus takon marang wong-wong kuwi: “Sapa sing mbok jaluk metu: Barabas apa Yésus sing diarani Kristus?” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus ngomong ngono kuwi, awit dèkné ngerti nèk wong Ju sengit marang Gusti Yésus, mulané Dèkné dipasrahké marang Pilatus. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dongé Pilatus njagong nang krosi kruton, bojoné dèkné terus kongkonan ngomongi dèkné ngéné: “Aja mèlu-mèlu ngurusi prekarané wong sing ora salah kuwi. Awit mau mbengi aku ngimpi lan krasa sedi tenan nyawang wong kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nanging para pengarepé imam lan para pinituwané wong Ju pada ngojok-ojoki wong-wong sing nang kono, pada njaluk supaya Barabas dietokké lan Gusti Yésus dipatèni. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatus terus takon marang wong-wong: “Karepmu wong loro kuwi, sing endi sing kudu tak etokké?” Wong-wong semaur: “Barabas!” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus terus ngomong: “Lah nèk Barabas sing metu, lah Yésus, sing dityeluk Kristus, kudu tak kapakké?” Wong-wong semaur bareng: “Dipentèng waé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatus terus takon: “Lah apa salahé wong iki?” Nanging wong-wong malah tambah banter sing mbengok: “Wong kuwi dipentèng waé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus weruh nèk ngono kuwi dèkné ora bisa nentremké wong-wong, malah tambah gedé rétyokké. Mulané dèkné terus ngongkon njikukké banyu lan nang ngarepé wong-wong kuwi dèkné misuhi tangané karo ngomong: “Aku ora nduwé salah apa-apa nèk wong iki mati. Kuwi urusanmu déwé!” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wong-wong semaur bareng: “Ora dadi apa, awaké déwé lan anak-anaké awaké déwé sing tanggung jawab patiné wong kuwi!” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatus terus nuruti karepé wong-wong. Barabas dietokké, nanging Gusti Yésus dipetyuti. Sakwisé kuwi Gusti Yésus terus dipasrahké marang para soldat supaya dipentèng. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Para soldat terus nggawa Gusti Yésus nang palèsé Pilatus, terus pada nyeluk soldat kabèh sing nang kono, kongkon pada nglumpuk ngubengi Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Saliné Gusti Yésus terus dityepot, diganti salin abang mbranang kaya ratu. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Soldat-soldat mau terus pada nggawé makuta karo pangé eri-eri, terus dipasang nang sirahé Gusti Yésus. Tangané tengen dityekeli teken. Sakwisé kuwi terus étok-étoké pada sujut nang ngarepé, ngomong: “Dipuji ratuné wong Ju!” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Para soldat mau terus ngidoni Gusti Yésus. Tekené terus dijikuk sangka tangané terus dienggo ngantemi sirahé. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sakwisé moyoki kuwi, para soldat terus nyepot saliné sing abang, terus dienggoni saliné déwé menèh. Gusti Yésus terus digawa metu arep dipentèng. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nang sak njabané kuta terus pada metuki sakwijiné wong sangka kuta Siréné. Wongé jenengé Simon. Simon dipeksa kongkon nggawa kayuné sing arep dienggo mentèng Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sing mlaku terus tekan panggonan sing jenengé Golgota. Golgota kuwi tegesé: endasé wong mati. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nang kono Gusti Yésus dikèki ngombé anggur dityampuri rasa pait. Kadung ngityipi, Dèkné terus ora gelem ngombé. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Gusti Yésus terus dipentèng lan saliné diedum nganggo lotré. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Para soldat terus pada njagong nang kono karo njaga. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nang nduwuré sirahé Gusti Yésus dipasang tulisan sing ngomongké apa jalarané Dèkné dipentèng. Tulisané ngéné: “Iki Yésus, wong Nasarèt, ratuné wong Ju.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bareng karo Gusti Yésus uga ènèng wong nakal loro dipentèng, siji nang sebelah tengen, liyané nang sebelah kiwa. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wong-wong sing liwat kono pada gèdèk-gèdèk lan moyoki Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tembungé ngéné: “Kowé jaréné arep mbubrah Gréja Gedé lan arep ngedekké menèh sakjeroné telung dina. Nèk Kowé pantyèn Anaké Gusti Allah tenan, jajal utyuli awakmu déwé lan meduna sangka pentèngan!” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Para pengarepé imam lan para guru Kitab lan uga para pinituwané bangsa Ju pada mèlu moyoki Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Pada ngomong ngéné: “Wong liyané ditulungi, lah awaké dèkné déwé ora bisa nulungi! Nèk wong iki pantyèn ratuné Israèl tenan, jajal medun sangka pentèngan, dadiné awaké déwé bisa pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dèkné njagakké Gusti Allah lan ngakuné Anaké Gusti Allah. Nèk Gusti Allah trésna marang Dèkné, ditulungi kono!” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wong nakal sing dipentèng bareng, uga pada mèlu moyoki Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Molai jam rolas awan sak negara malih peteng, kira-kira telung jam suwéné. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kira-kira jam telu soré Gusti Yésus terus mbengok banter: “Eloi, Eloi, lamah sabaktani!” Kuwi tegesé: “Gustiku, Gustiku, kenèng apa Aku kok mbok tinggal?” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wong-wong sing liwat kono sing pada krungu kuwi pada ngomong: “Wong kuwi nyeluk nabi Elia.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Terus ènèng siji njikuk spons dietylupké nang anggur ketyut. Sponsé terus dipasang nang putyuké garan kayu terus dikèkké Gusti Yésus kongkon nyesep. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nanging wong-wong liyané ngomong: “Mengko ndisik, jajal dientèni, nabi Elia arep nulungi Dèkné apa ora!” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Gusti Yésus terus mbengok banter sepisan menèh, terus ninggal. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ing waktu kuwi kordèné Gréja Gedé suwèk dadi loro, sangka nduwur mengisor. Terus ènèng lindu lan gunung-gunung pada mbengkak. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kuburan-kuburan pada menga lan okèh wong mati sing mauné temen nurut Gusti, pada urip menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wong-wong iki pada metu sangka kuburané lan sakwisé Gusti Yésus tangi sangka pati, wong-wong iki mlebu nang Kuta Sutyi Yérusalèm. Nang kono wong okèh pada weruh wong-wong iki. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kumendan-kumendan lan para soldaté sing njaga Gusti Yésus pada krasa linduné lan uga pada weruh sembarang sing klakon mau. Kabèh pada wedi tenan lan pada ngomong: “Wong iki pantyèn Anaké Gusti Allah tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nang kono okèh wong wédok sing nyawang sangka kadohan. Wong-wong iki mauné pada mèlu Gusti Yésus wiwit sangka bawah Galiléa, tujuané ngladèni Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wong wédok-wédok iki kayadéné: Maria Makdaléna, Maria ibuné Yakobus lan Yosèf lan bojoné Sébédéus. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ing wayah soré ènèng wong sugih sangka kuta Arimatéa teka. Wongé jenengé Yosèf lan dèkné uga muridé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yosèf iki mara nang nggoné Pilatus nembung layoné Gusti Yésus. Pilatus terus mréntah supaya layoné Gusti Yésus dikèkké marang Yosèf. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosèf terus ngedunké layoné sangka pentèngan, terus dibuntel mori anyar. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Layoné terus disèlèhké nang kuburané Yosèf déwé sing ijik anyar. Kuburan iki sakwijiné guwa sing digrowong nang watu. Sakwisé nutup lawangé kuburané karo watu gedé, Yosèf terus lunga. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdaléna lan Maria sing liyané pada kèri nang kono, njagong nang ngarepé kuburan. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Esuké, ing dina sabat, para pengarepé imam lan para Farisi pada mara nang nggoné Pilatus. ");
INSERT INTO jvnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tembungé ngéné: “Bapak gramang, awaké déwé kélingan nèk wong tukang ngapusi kuwi tau ngomong ngéné dongé ijik urip: ‘Sakwisé telung dina Aku bakal urip menèh.’ ");
INSERT INTO jvnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mulané apik nèk bapak gramang mréntah kongkon njaga kuburané tekan telung dinané. Awit nèk ora ngono, mengko murid-muridé bisa nyolong layoné, terus ngomong-omong marang wong-wong: ‘Gusti Yésus urip menèh.’ Lah apusan sing anyar iki mengko nyamariné ngungkuli apusan sing ndisik.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus terus ngomong: “Kana nggawa soldat lan kuburané dijaga sing apik.” ");
INSERT INTO jvnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wong-wong terus pada budal nang kuburané Gusti Yésus. Lawangé kuburané terus diségel lan soldat-soldaté dikongkon njaga nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kadung dina sabat wis kliwat, ing dina minggu ésuk mruput, Maria Makdaléna lan Maria liyané pada lunga niliki kuburané Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Dadakan waé ènèng lindu sing gedé banget, awit ènèng mulékat medun sangka swarga. Mulékaté terus ngglundungké watu tutupé kuburan, terus njagong nang watu mau. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mulékaté kétoké kaya klélapé bledèk lan saliné putih sumeblak. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldat-soldat sing jaga kono pada kagèt tenan lan sangking wediné sampèk pada kaya wong mati. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mulékaté terus ngomong marang wong wédok-wédok mau: “Aja pada wedi! Aku ngerti nèk kowé pada nggolèki Yésus sing wis dipentèng. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dèkné ora nang kéné, Dèkné wis tangi, tyotyok karo sing diomongké dèk mbiyèn. Mbok jajal didelok panggonan tilasé. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mulané kana pada ndang balika ngomongi murid-muridé nèk Dèkné wis tangi lan budal ndisiki nang Galiléa. Murid-muridé diomongi nèk bakal metuki Dèkné nang kana. Yakuwi sing kudu tak omongké marang kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wong wédok-wédok mau terus gelis-gelis lunga sangka kuburan kono karo rasa wedi tyampur bungah. Mlakuné gelis, awit ndang kepéngin ngomongi murid-muridé Gusti Yésus bab lelakon kuwi mau. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Gusti Yésus terus metuki wong wédok-wédok mau, ngomong: “Pada slameta!” Wong wédok-wédok mau terus pada nyedeki lan sujut nang ngarepé, terus pada nyekeli sikilé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Gusti Yésus ngomong: “Aja pada wedi! Kana balika lan sedulur-sedulurku pada diomongi kongkon pada budal nang Galiléa. Nang kana mengko bakal weruh Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dongé wong wédok-wédok ijik pada mlaku, soldat-soldat sing jaga kuburan terus pada lunga nang kuta Yérusalèm, arep ngomongi marang para pengarepé imam bab apa sing klakon kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Para pengarepé imam terus pada rembukan karo para pinituwané bangsa Ju. Wong-wong terus nggawé putusan ngekèki duwit okèh marang soldat-soldat sing jaga kuburan. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Para soldat sing jaga dikongkon ngomong-omongké nèk murid-muridé Gusti Yésus teka ing wayah wengi terus nyolong layoné, dongé sing jaga ijik turu. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Para soldat sing jaga kuburan dipenging wedi, senajan gramangé krungu, awit para pengarepé imam bakal omong-omongan karo dèkné, supaya sing jaga kuburan ora bakal disetrap. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Para soldat mau terus nampa duwité lan nuruti apa karepé para pengarepé imam lan pinituwané bangsa Ju. Tembungé para soldat mau terus kesebar nang tengahé bangsa Ju, tekan sepréné. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Murid-muridé Gusti Yésus sewelas pada budal nang Galiléa, nang gunung sing wis diomong karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kadung pada weruh Gusti Yésus, murid-murid mau terus pada sujut nang ngarepé. Nanging ènèng murid siji-loro sing durung pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Gusti Yésus terus nyedeki murid-muridé, terus ngomong: “Sak ènèngé pangwasa nang swarga lan nang bumi wis dipasrahké marang Aku karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mulané, kana pada budala, bangsa-bangsa nang sak lumahé bumi diparani kabèh lan didadèkké muridku. Pada dibaptis ing jenengé Gusti Allah Bapaké, Anaké lan Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pada diblajari nuruti sakkèhé piwulang sing wis tak wulangké marang kowé. Lan pada titènana, Aku bakal ngantyani kowé terus tekan entèk-entèkané jaman.”");
INSERT INTO jvnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iki kabar kabungahan bab Gusti Yésus Kristus, Anaké Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kabar kabungahan iki wiwitané kaya sing wis ditulis karo nabi Yésaya ing jaman mbiyèn. Ketulis nèk Gusti Allah ngomong ngéné marang Anaké: “Ya wong iki sing tak kongkon teka ndisik, kongkon nata atiné wong-wong, supaya pada gelem nggugu marang Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Terus ènèng tulisan menèh ngomong ngéné: “Nang wustèn ènèng wong bengok-bengok, ngomongi wong-wong kongkon pada nata uripé, awit Gusti arep teka.” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Kuwi mau kabèh ngomongké Yohanes sing manggon nang wustèn. Saliné Yohanes wulu unta lan sabuké lulang. Pangané namung walang lan maduné tawon alasan. Yohanes ngomongi wong-wong kongkon pada ninggal klakuan ala lan pada dibaptis, supaya Gusti Allah ngapura salahé kabèh. Sangka bawah Yudéa lan sangka kuta Yérusalèm wong pirang-pirang pada teka ngrungokké piwulangé Yohanes. Kabèh pada ngakoni salahé marang Gusti Allah lan pada dibaptis nang laut Yordan. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohanes ngomongi wong-wong ngéné: “Bakal ènèng wong liyané teka. Wong kuwi kwasané ngungkul-ungkuli aku. Aku jan blas ora kenèng dipadakké karo Dèkné! ");
INSERT INTO jvnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aku mbaptis kowé namung karo banyu, nanging Dèkné bakal mbaptis kowé karo Roh Sutyi.” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ing wayah kuwi Gusti Yésus lunga sangka kuta Nasarèt, sangka distrik Galiléa. Dèkné terus dibaptis karo Yohanes nang laut Yordan. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kadung Gusti Yésus wis mentas sangka banyu, Dèkné terus weruh langité menga. Sakwisé kuwi terus Roh Sutyi medun kétoké kaya manuk dara, méntyloki Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Terus ènèng swara sangka langit ngomong: “Kowé Anakku sing tak trésnani. Aku jan lega banget karo Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sakwisé kuwi Roh Sutyi terus nuntun Gusti Yésus digawa nang wustèn. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nang wustèn kono Gusti Yésus patang puluh dina suwéné. Dèkné dijajal karo Sétan, manut marang Gusti Allah apa ora. Panggonan kono kuwi okèh kéwané galak, nanging Gusti Yésus dijaga lan diladèni karo mulékat-mulékaté Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sakwisé Yohanes dityekel lan dilebokké nang setrapan karo ratu Hérodès, Gusti Yésus terus teka nang Galiléa. Nang bawah kono Gusti Yésus nggelar kabar kabungahané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Dèkné ngomong ngéné: “Saiki wantyiné wis teka enggoné Gusti Allah arep ngedekké kratoné. Mulané pada pretyayaa marang kabar kabungahané Gusti Allah lan pada ninggala klakuan ala!” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dongé Gusti Yésus mlaku nang pinggiré mér Galiléa kono, Dèkné weruh Simon lan Andréas ijik pada nguntyalké jalané. Wong loro kakang-adi iki kerjanané nggolèk iwak. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Gusti Yésus terus ngomong: “Pada mèlua Aku! Kowé bakal tak blajari dadi tukang nggolèk wong.” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Simon lan Andréas terus pada ninggal jalané lan ngetutké Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kadung Gusti Yésus mlaku rada adoh menèh terus weruh Yakobus lan Yohanes, kabèh loro anaké Sébédéus. Wong loro iki ijik pada ndandani jalané nang prauné. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nanging kadung dityeluk karo Gusti Yésus terus pada mèlu Dèkné. Bapaké lan wong-wong sing ngréwangi nggolèk iwak pada ditinggal nang prauné. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Gusti Yésus lan murid-muridé pada teka nang kuta Kapèrnakum. Ing dina sabat Gusti Yésus mlebu nang sinaguk lan mulangi wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wong-wong kagèt lan nggumun bab enggoné Gusti Yésus mulangi, awit Dèkné mulangi nganggo kwasané Gusti Allah, ora kaya guru-guru Kitab. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Dongé Gusti Yésus ijik mulangi, terus dadakan waé ènèng wong sing nang kono bengok-bengok. Wong iki dikwasani demit. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Wongé bengok-bengok ngomong: “Yésus wong Nasarèt, aku arep mbok kapakké? Apa tekamu iki arep matèni awaké déwé? Aku ngerti Kowé kuwi sapa. Kowé kuwi wong sutyi, wong kongkonané Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Demité mau terus digentak karo Gusti Yésus, Dèkné ngomong: “Meneng! Metua sangka wong kuwi!” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Demité terus ngontang-antingké wongé, terus metu karo njerit-njerit. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wong-wong nggumun kabèh lan pada takon marang sakpada-pada: “Apa iku ya? Iki wulangan anyar nganggo kwasané Gusti Allah. Dèkné wani mréntah demit kongkon metu lan demité ya manut tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sakwat jenengé Gusti Yésus kesuwur nang sak bawah Galiléa kono. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sakwisé kuwi Gusti Yésus terus metu. Dèkné terus bareng karo Yakobus lan Yohanes budal nang omahé Simon. Andréas mbarang ya manggon nang omah kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ibu maratuwané Simon ijik ngglétak nang ambèn, awit lara panas. Gusti Yésus ya terus diomongi nèk wongé lara. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Gusti Yésus terus niliki sing lara. Wongé dityekel tangané lan ditangèkké. Wongé terus mari lan ngladèni dayohé. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ing wayah wengi, sakwisé srengéngé wis medun, wong sing lara lan sing dikwasani demit pada digawa nang nggoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wong sak kuta terus pada nglumpuk nang latar nang ngarepé omah. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wong lara werna-werna ditambani kabèh karo Gusti Yésus. Uga demit-demit sing ngwasani uripé wong okèh pada dietokké kabèh. Lan demit-demit mau pada dipenging ngomong apa-apa bab Gusti Yésus, senajana demité pada ngerti Dèkné kuwi sapa. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ing wayah ésuk mruput, dongé ijik peteng ndedet, Gusti Yésus tangi terus lunga nang panggonan sing sepi. Nang kono Dèkné ndonga. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon lan murid-murid liyané terus pada nggolèki Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kadung wis ketemu, murid-murid mau terus ngomong: “Gusti, wong-wong pada nggolèki Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Gusti Yésus malah semaur: “Hayuk awaké déwé budal nang désa-désa liyané nang sak kiwa-tengené kéné. Kana mbarang kudu tak gawani kabar kabungahan, awit enggonku teka mbréné iki perluné ya namung kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Gusti Yésus terus mlaku-mlaku marani désa-désa nang bawah Galiléa karo nggelarké kabar kabungahan nang sinaguk-sinaguk. Lan demit-demit sing ngwasani wong pada dietokké kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Enèng wong lara lépra mara nang nggoné Gusti Yésus, terus niba nang ngarepé njaluk tulung ngomong: “Nèk Kowé gelem, Kowé bisa nambani aku!” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Gusti Yésus melas banget, mulané terus ndemèk wongé lan ngomong: “Aku gelem! Kowé wis mari saiki!” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sakwat wongé ya terus mari tenan. ");
INSERT INTO jvnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Gusti Yésus terus ngongkon wongé lunga, nanging dipenging ngomong-omong karo wong-wong. Gusti Yésus ngongkon wongé ngéné: “Kana kowé maraa nang nggoné imamé, supaya dèkné weruh awakmu lan kowé ngekèkana kurban marang Gusti Allah miturut wèté nabi Moses. Dadiné wong-wong ngerti nèk kowé wis mari tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nanging kadung wongé lunga sangka kono, dèkné terus molai ngomong-omongi wong-wong nèk dèkné wis ditambani karo Gusti Yésus. Saiki Gusti Yésus ora bisa ngleboni kuta apa désa, tanpa dititèni karo wong-wong. Mulané Dèkné terus nang sak njabané kuta waé, nang panggonan sing ora ènèng wongé. Nanging wong-wong sangka endi-endi ijik meksa teka marani Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Let kira-kira rong dina Gusti Yésus balik menèh nang Kapèrnakum. Wong-wong krungu nèk Dèkné nang omah. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wong pirang-pirang terus pada ngumpul, sampèk nang omahé ora ènèng nggoné menèh. Nang ngarep lawang mbarang ya kebek karo wong. Gusti Yésus terus mulangi wong-wong bab pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Terus ènèng wong teka arep nang nggoné Gusti Yésus nggawa wong lumpuh. Wong lumpuh iki digotong wong papat. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nanging sangking okèhé wong, sing nggotong wong lumpuh mau ora bisa tekan nggoné Gusti Yésus. Mulané terus pada njebol payoné omahé. Kadung wis nggawé bolongan nang payoné, wongé sing lumpuh terus diedunké sak klasané. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Gusti Yésus weruh pengandelé wong-wong iki, mulané terus ngomong marang sing lumpuh: “Anakku, Aku ngapura dosamu!” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nang omah kono uga ènèng guru-guru Kitab mèlu ngrungokké. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Guru-guru iki pada mbatin: “Lah wong kuwi kok wani-wani ngomong ngono? Kuwi lak ngèlèk-èlèkké Gusti Allah, awit namung Gusti Allah déwé sing bisa ngapura dosané manungsa!” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nanging Gusti Yésus weruh pikirané guru-guru mau, mulané Dèkné terus ngomong: “Kenèng apa kowé kok pada nduwé pikiran kaya ngono? ");
INSERT INTO jvnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gampang sing endi, ngomong marang wong lumpuh iki: ‘Dosamu wis dingapura’ apa ngomong: ‘Ngadeka, klasamu diangkat lan mlakua!’ ");
INSERT INTO jvnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aku namung kepéngin nduduhké marang kowé, nèk Anaké Manungsa nduwèni kwasa ngapura dosa nang jagat kéné!” Gusti Yésus terus ngomong marang wong lumpuh mau: ");
INSERT INTO jvnNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Aku ngongkon kowé, ngadeka, klasamu diangkat lan kana mulih!” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wongé terus ngadek nang ngarepé wong okèh kono, njikuk klasané terus lunga. Wong kabèh pada nggumun lan pada ngluhurké Gusti Allah karo ngomong: “Barang kaya ngéné iki awaké déwé durung tau weruh!” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Gusti Yésus terus lunga menèh sangka Kapèrnakum. Saiki Dèkné mlaku nang pinggir mér. Wong okèh terus pada teka marani Dèkné. Kabèh terus pada diwulangi. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dongé liwat, Gusti Yésus weruh wong belasting, sing jenengé Lévi, ijik njagong nang kantoré. Lévi kuwi anaké Alféus. Gusti Yésus terus nyeluk Lévi ngomong: “Hayuk mèlu Aku!” Lévi terus ngadek lan mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ing sakwijiné dina Gusti Yésus lan murid-muridé pada jagongan nang omahé Lévi, tunggal sak méja karo wong-wong belasting lan wong-wong liyané sing dianggep dosa. Wong kaya ngono kuwi okèh sing pada mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Enèng guru-guru Kitab sangka golongané wong Farisi pada weruh nèk Gusti Yésus mangan tyampur karo wong belasting lan wong dosa. Mulané guru-guru Kitab mau terus takon marang murid-muridé Gusti Yésus: “Lah Yésus kok jagongan lan mangan tyampur karo wong kaya ngono?” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Gusti Yésus krungu pitakonané guru-guru Kitab mau, mulané Dèkné terus semaur: “Sing mbutuhké dokter kuwi mesti ya sing lara ta, mosok sing waras? Mulané, tekaku nang jagat kéné ora nggolèki wong sing nganggep nèk uripé wis bener, nanging nggolèki wong sing dosa.” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ing sakwijiné dina murid-muridé Yohanes Pembaptis lan para Farisi pada pasa. Ing dina kuwi ènèng wong pada mara nang nggoné Gusti Yésus takon: “Kenèng apa murid-muridé Yohanes lan murid-muridé para Farisi pada pasa, nanging murid-muridmu kok ora?” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Gusti Yésus terus semaur: “Apa dayoh nang mantènan kaé ora pada mangan énak lan pada mèlu bungah. Suwéné ijik tyampur karo mantèné mesti ya ora ènèng sing sedi. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nanging bakal ènèng wayahé mantèné lanang kuwi bakal digawa lunga. Ing wayah kuwi kantya-kantyané bakal pada sedi lan ora mangan.” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mosok salin lawas kenèng ditambal karo gombal anyar sing durung tau diumbah? Ya ora ta. Awit nèk diumbah tambalané bisa mengkeret terus suwèk menèh, ambané ngungkuli mauné. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Lan menèh, mosok anggur anyar diwadahi kantongan lulang lawas? Mesti ora ta! Mengko ndak kantongané bedah lan angguré wutah nganggur. Anggur anyar kuduné diwadahi kantongan anyar. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ing sakwijiné dina sabat Gusti Yésus mlaku turut kebon gandum karo murid-muridé. Sak barengé mlaku murid-muridé pada ngepèki wohé gandum dipangan. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Wong Farisi sing pada weruh kuwi terus ngomong marang Gusti Yésus: “Lah kepriyé kuwi? Ing dina sabat lak ora éntuk nyambutgawé apa-apa ta? Lah murid-muridmu kok ngepèki gandum?” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Gusti Yésus semaur: “Apa kowé ora tau matya bab ratu Daved, dongé dèkné lan kantya-kantyané pada ngelih banget, nanging ora nduwé panganan apa-apa? ");
INSERT INTO jvnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Apa dèkné ora terus mlebu nang omahé Gusti Allah lan mangan rotiné. Dèkné lak wis ngerti ta nèk namung para imam sing éntuk mangan roti sing wis dipasrahké marang Gusti Allah kuwi. Ing waktu kuwi sing dadi Imam Gedé Abiatar. Malah kantyané mbarang diedumi lan pada mèlu mangan karo Daved. Lan ora ènèng wong sing ngomong nèk dèkné klèru.” ");
INSERT INTO jvnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Gusti Yésus terus ngomong menèh: “Gusti Allah enggoné nganakké dina sabat kuwi ora kanggo ngangèlké, nanging kanggo ngepénakké uripé manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mulané, Anaké Manungsa sing bisa ngarani bab sing éntuk lan sing ora éntuk ditandangi ing dina sabat.” ");
INSERT INTO jvnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ing dina sabat liyané Gusti Yésus mlebu nang sinaguk menèh. Nang kono ènèng wong sing tangané lumpuh sebelah. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nang kono uga ènèng wong-wong sing pada nggolèk jalaran kanggo ngelahké Gusti Yésus. Wong-wong iki pada ndelokké, awit kepéngin ngerti Gusti Yésus nambani wongé apa ora ing dina sabat iki. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Gusti Yésus terus nyeluk wong sing lumpuh tangané kongkon maju, supaya wong-wong bisa weruh dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Gusti Yésus terus takon marang wong-wong: “Aku kepéngin krungu: ing dina sabat apik nggawé betyik apa apik nggawé ala? Apik nulungi wong apa apik matèni?” Wong-wong amleng kabèh, ora ènèng sing wani semaur apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Gusti Yésus nyawang wong-wong karo ya jèngkèl ya sedi, awit wong-wong ora gelem nitèni barang sing bener. Mulané Dèkné terus ngomong marang wong sing lumpuh tangané: “Tanganmu dietungké!” Wongé terus ngetungké tangané, awit wis ora lumpuh menèh. Saiki wis mari kaya mauné. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wong Farisi sing nang kono terus pada lunga. Terus pada rembukan karo wong-wong golongané Hérodès. Bebarengan wong-wong kuwi pada nggawé akal kepriyé enggoné arep matèni Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Gusti Yésus lan murid-muridé pada lunga nang pinggir mér Galiléa. Wong okèh banget pada ngetutké Dèkné. Enèng sing sangka bawah Galiléa lan Yudéa lan sangka kuta Yérusalèm. Uga ènèng sing sangka bawah Iduméa, sangka abrahané laut Yordan lan sangka sak kiwa-tengené kuta Tirus lan Sidon. Wong-wong iki pada gemruduk marani Gusti Yésus, awit kabèh krungu nèk Dèkné nindakké barang sing nggumun-nggumunké. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mulané Gusti Yésus ngomongi murid-muridé kongkon pada nyawiské prau siji. Dadiné senajan wong okèh pada esuk-esukan kepéngin maju, Gusti Yésus ora usah diesuk-esuk wong, awit Dèkné bisa njagong nang prauné. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Gusti Yésus wis nambani wong pirang-pirang, mulané wong-wong sing nduwé lara pada ngesuk-esuk, kepéngin ndemèk Dèkné supaya bisa mari. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wong-wong sing dikwasani demit nèk weruh Gusti Yésus terus pada niba nang ngarepé. Demité terus pada bengok-bengok ngomong: “Kowé kuwi Anaké Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nanging demit-demit mau disenèni karo Gusti Yésus, dipenging ngomong-omongké Dèkné kuwi sapa. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gusti Yésus saiki terus munggah nang gunung. Dèkné milih wong-wong sing kongkon mèlu. Wong-wong ya terus pada teka. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Sangka tengahé wong-wong sing pada teka kuwi Gusti Yésus terus milih wong rolas sing kudu mèlu Dèkné nang endi waé. Awit wong rolas iki sing bakal nggelar kabar kabungahané Gusti Allah lan bakal nduwèni kwasa nundungi demit. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Sing dipilih ya wong rolas iki: Simon sing dikèki jeneng liyané, yakuwi Pétrus, Yakobus karo Yohanes sing kakang-adi. Kabèh loro iki anaké Sébédéus lan pada diarani Boanèrges karo Gusti Yésus, tegesé: anak gluduk. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Sing liya-liyané jenengé Andréas, Filipus, Bartoloméus, Matéus, Tomas, Yakobus anaké Alféus, Tadéus, Simon sing diarani Patriot lan Yudas sangka Iskariot, sing ing tembé bakal ngelungké Gusti Yésus marang mungsuhé. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Gusti Yésus terus balik nang omah. Nanging wong okèh banget pada teka menèh marani Dèkné, sampèk ora kober mangan. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sedulur-seduluré Gusti Yésus pada krungu bab kuwi. Lan menèh ènèng sing ngomong nèk Dèkné kuwi ora waras. Mulané sedulur-seduluré mau terus budal arep marani Gusti Yésus diejèk mulih. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Guru-guru Kitab sing teka sangka Yérusalèm pada ngomong: “Wong kuwi dikwasani Bèlsebul, penggedéné demit. Mulané Dèkné bisa ngetokké demit.” ");
INSERT INTO jvnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wong-wong mau terus dityeluk karo Gusti Yésus lan diwulangi nganggo tembung gambar. Gusti Yésus ngomong: “Mosok Sétan arep nglawan balané déwé? Mesti ora ta! ");
INSERT INTO jvnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Semunggoné ing sakjeroné negara wongé pada memungsuhan marang sakpada-pada, negara kuwi mesti bakal rusak. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Uga ing sakjeroné omah-omah, nèk wongé pada neng-nengan lan memungsuhan, brayat kuwi mesti ndang bubrah. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Lah saiki dipikir déwé sing apik: nèk Sétan nglawan balané déwé, lah gèk kepriyé? Mesti Sétan ya wis ora nduwé bala menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Apa ènèng wong bisa ngleboni omahé wong sing gedé lan rosa pawakané, terus nyolongi sembarang sak ènèngé? Mesti ya ora bisa! Malingé kudu bisa mbanda sing nduwé omah ndisik, sakdurungé bisa ngusungi sembarangé. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Iki dirungokké sing apik. Gusti Allah gelem ngapura manungsa, senajan salahé gedéné lan okèhé kaya ngapa, uga nèk ngèlèk-èlèkké wong liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nanging sapa sing ngèlèk-èlèkké Roh Sutyi ora bakal dingapura slawas-lawasé, nanging bakal nyangga salah iku sak terusé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Gusti Yésus ngomong ngono kuwi, awit wong-wong pada ngarani nèk Dèkné dikwasani demit. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sakwisé kuwi ibuné lan adik-adiké Gusti Yésus pada teka. Wong-wong iki pada ngentèni nang njaba lan kongkonan nyelukké Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wong okèh pada jagongan ngubengi Gusti Yésus. Wong-wong terus ngomong: “Gusti, ibu lan adikmu pada nang njaba nékokké Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Gusti Yésus semaur: “Ibuku lan adikku kuwi sakjané sapa ta?” ");
INSERT INTO jvnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Dèkné terus nyawang wong-wong sing pada njagong ngubengi Dèkné lan ngomong: “Ya iki ibuku lan sedulurku. Sapa waé sing manut marang Gusti Allah, yakuwi sedulurku lanang lan sedulurku wédok lan ibuku tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gusti Yésus mulangi wong-wong menèh nang pinggiré mér Galiléa. Nanging sangking okèhé wongé sing pada ngrungokké, Dèkné terus munggah nang prau sing nang kono terus mulangi sangka kono. Wong-wong sing ngrungokké pada ngadek nang pinggir. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pirang-pirang prekara sing dirembuk karo Gusti Yésus. Dèkné nèk mulangi nganggo gambar. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Gusti Yésus ngomong ngéné: “Dirungokké sing apik. Enèng wong budal nang kebon arep nyebar. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dongé nyebar, wijiné ènèng sing tiba nang pinggir dalan terus dipangan manuk. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Saloké tiba nang panggonan sing atos, sing tipis lemahé. Ya gelis tukul, nanging kadung panas banter terus garing, awit ora ènèng oyoté. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Liyané tiba nang panggonan sing okèh eriné. Wijiné tukul, nanging kalah karo eri-eriné, mulané ya ora bisa metu wohé. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nanging uga ènèng wiji sing tiba nang lemah apik. Wiji iki tukul sampèk gedé terus ngetokké woh dadi telung puluh, liyané malih swidak lan ènèng liyané sing dadi satus.” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Gusti Yésus terus nutup piwulangé ngomong: “Sapa sing nduwé kuping, dirungokké sing apik!” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Dongé Gusti Yésus njagong déwé, terus ènèng wong sing mèlu ngrungokké piwulangé mau pada teka bareng karo murid sing rolas. Wong-wong nyuwun marang Gusti Yésus ndunungké gambar mau. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Gusti Yésus terus ngomong ngéné: “Ing jaman mbiyèn Gusti Allah ora ndunung-ndunungké bab iki, nanging saiki kowé wis pada ngerti wewadiné Kratoné Gusti Allah. Nanging kanggo wong-wong sing ora gelem pretyaya, Aku sing mulangi nganggo tembung-tembung gambar. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dadiné, ‘Senajana pada weruh, nanging ora bisa nitèni lan senajana pada ngrungokké ora bisa dunung. Awit nèk pada nitèni lan pada dunung, wong-wong kuwi mesti terus pada manut marang Gusti Allah lan salahé uga bisa dingapura. Nanging ora pada gelem.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Gusti Yésus terus ngomong marang wong-wong: “Mosok kowé ora pada dunung piwulangé sangka tembung gambar iki? Lah kepriyé kowé bisané dunung sing liya-liyané? ");
INSERT INTO jvnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wong sing nyebar kuwi wong sing ngabarké pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wiji-wiji sing tiba nang pinggir dalan kuwi nggambarké wong-wong sing krungu pituturé Gusti Allah, nanging terus pada lali. Sétan mbuwang pitutur mau sangka atiné. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wiji-wiji sing tiba nang panggonan sing atos, kuwi nggambarké wong-wong sing krungu lan gelem nampa pituturé Gusti Allah. Wong-wong iki terus pada seneng lan nduwèni kabungahan. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nanging pituturé Gusti Allah ora ngoyot ing atiné. Mung demen anyar waé. Nèk katekan kangèlan lan disengiti karo liyané, jalaran nurut pituturé Gusti Allah, wong-wong iki terus semplak pengandelé. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wiji-wiji sing tiba nang tengahé eri-eri kuwi nggambarké wong-wong sing krungu lan nampa pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Nanging terus pada bingung bab kauripan ing donya lan mung mikirké barang sing ora-ora, awit pada kepéngin sugih. Mulané terus pada lali marang pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nanging wiji sing tiba nang lemah sing apik kuwi nggambarké wong-wong sing krungu pituturé Gusti Allah terus pada pretyaya sak atiné. Dadiné pituturé Gusti Allah ngetokké woh ing uripé wong kuwi, ping telung puluh, liyané swidak lan liyané menèh ping satus.” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Gusti Yésus terus mulangi menèh: “Pituturé Gusti Allah kuwi kenèng dipadakké karo dian. Apa ènèng wong nyumet dian terus ditutupi ténggok apa didèkèk nang ngisor kolong? Ya ora ta! Diané mesti didèkèk nang méja apa dityantèlké nang tyagaké. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Awit apa sing didelikké kuwi mesti kapan-kapan bakal dietokké lan apa waé sing disimpen kuwi mesti ya supaya kapan-kapan dikétokké. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sing nduwé kuping, dirungokké sing apik.” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Gusti Yésus terus ngomong: “Aja namung ngrungokké karo kupingmu waé, nanging sembarang kudu mbok pikir sing apik. Nèk kowé ngrungokké sing tenanan, mesti kowé ya bakal dunung okèh lan pangertimu bakal mundak terus. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Awit sapa sing nggatèkké marang pituturku bakal mundak okèh kaweruhé, nanging sing ora gelem nggugu, senajana ngerti namung setitik, kuwi waé bakal lali.” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Gusti Yésus neruské tembungé: “Kratoné Gusti Allah kuwi kenèng dipadakké karo sakwijiné wong sing nyebar wiji nang keboné. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sakwisé nyebar terus ditinggal, mbengi turu, ésuk tangi, suwi-suwi wijiné tukul déwé sampèk gedé, wongé déwé ora ngerti kepriyé tukulé! ");
INSERT INTO jvnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lemahé sing nukulké, sampèk metu wohé, ndisiké gagangé, terus ngembang lan metu wulèné. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nèk pariné wis tuwa terus dierit, awit wis wayahé panèn.” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Gusti Yésus terus ngomong: “Kratoné Gusti Allah kenèng dipadakké karo apa menèh? ");
INSERT INTO jvnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kenèng dipadakké karo wiji sing tyilik déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nanging nèk disebar terus tukul, gedéné ngungkuli tanduran liyané. Pangé gedé-gedé, mulané manuk-manuk seneng ngiyup lan nggawé susuk nang kono.” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Gusti Yésus enggoné mulangi wong-wong bab pituturé Gusti Allah ya nganggo tembung-tembung gambar ngono kuwi, sak kuwaté wong-wong sing ngrungokké. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dèkné ora tau mulangi tanpa nganggokké tembung gambar. Nanging nèk Dèkné déwé karo murid-muridé, sembarang didunung-dunungké. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dongé wis surup ing dina kuwi, Gusti Yésus ngejèk murid-muridé, ngomong: “Hayuk pada ngabrah!” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Gusti Yésus wis nang njeroné prau. Murid-muridé terus budal numpak prauné, wong-wong liyané ditinggal nang daratan. Enèng prau-prau liyané mbarang sing mèlu. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ora let suwi terus ènèng angin banter. Ombaké ngantemi prauné sampèk kebek banyu lan mèh kelep. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Gusti Yésus malah ijik turu nang mburi, bantalan. Murid-muridé terus pada nggugah Dèkné ngomong: “Gusti, apa awaké déwé arep mbok ejarké bèn kelep?” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Gusti Yésus terus tangi. Angin lan ombak dipréntah: “Mandeka!” Anginé sakwat mandek lan banyuné malih anteng. ");
INSERT INTO jvnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Gusti Yésus terus nyenèni murid-muridé: “Kenèng apa kowé kok pada wedi? Apa kowé durung pretyaya marang Aku?” ");
INSERT INTO jvnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Murid-muridé pada wedi banget lan takon marang sakpada-pada: “Wong iki sapa ta? Angin lan banyu kok manut marang Dèkné?” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Gusti Yésus lan murid-muridé wis ngabrah lan saiki pada tekan panggonané bangsa Gérasa. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kadung medun sangka prau Dèkné terus kepetuk wong sing dikwasani demit. Wong iki tekané sangka guwa-guwa kuburané wong kono. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Pantyèn wong iki manggoné ya nang guwa-guwa kuburan kono. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wis bolak-balik dèkné tangan-sikilé diranté, nanging ajek dipedot. Mulané saiki ora ènèng wong sing wani mbanda dèkné menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Awan-wengi wong iki kluyuran nang kuburan lan gunung-gunung kono, karo bengak-bengok lan ngantemi awaké karo watu. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ing dina kuwi, dongé wongé weruh Gusti Yésus sangka kadohan, dèkné terus mblayu marani terus niba nang ngarepé. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Gusti Yésus terus mréntah demité: “Demit, metua sangka wong iki!” Demité terus mbengok banter ngomong: “Duh Gusti Yésus, Anaké Gusti Allah sing kwasa déwé, Kowé kok ngurusi aku. Aku nyuwun, Gusti Allah dadi seksi, aku mbok aja disetrap.” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Gusti Yésus terus takon: “Sapa jenengmu?” Demité semaur: “Awaké déwé jenengé Légiun, awaké déwé nang kéné okèh banget.” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Demité terus nyuwun banget marang Gusti Yésus, supaya ora dikongkon lunga sangka panggonan kono. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Saiki nang gunungané panggonan kono ènèng babi pirang-pirang ijik pada nggolèk pangan. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Demit-demité mau terus pada nyuwun marang Gusti Yésus: “Mbok awaké déwé dililani mlebu nang babi-babi kaé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Gusti Yésus nglilani. Demité terus pada metu sangka wongé lan mlebu nang babi-babi mau. Kira-kira ènèng babi rong èwu okèhé, kabèh pada pating gruduk medun sangka gunungan kono, terus mblandang nang mér. Kabèh kelep. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sing tukang angon babiné terus pada mblayu lunga, ngomongi wong-wong sing nang kuta bab lelakon kuwi. Wong-wong terus pada teka, awit kepéngin weruh déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kadung tekan nggoné Gusti Yésus, terus pada weruh wong sing mauné dikwasani demit njagong nang kono. Wongé saiki nganggo salin lan angen-angené wis waras. Nanging wong-wong ijik pada wedi. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Wong-wong sing weruh lelakoné wong sing mauné dikwasani demit lan babi-babi mau terus pada ngomongi wong-wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mulané kabèh terus pada nyuwun marang Gusti Yésus supaya lunga sangka panggonan kono. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kadung Gusti Yésus arep munggah nang prauné, wong sing mauné dikwasani demit terus marani Dèkné, nembung arep mèlu. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","20","Nanging ora éntuk. Gusti Yésus ngomong: “Kana kowé mulih waé. Diomongké marang sedulur-sedulurmu apa sing ditindakké karo Gusti Allah lan sepira gedéné kabetyikané Dèkné marang kowé.” Wongé terus lunga lan ngabar-ngabarké nang sak bawah Dékapolis bab enggoné Gusti Yésus nulungi dèkné. Wong-wong sing krungu pada nggumun kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Gusti Yésus ngabrah menèh karo prauné. Wong pirang-pirang terus pada nglumpuk marani Dèkné. Mulané Dèkné terus nang pinggir mér kono waé. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ora let suwi terus ènèng wong mara nang nggoné Gusti Yésus. Wong iki pengarepé sinaguk, jenengé Jairus. Tekan nggoné Gusti Yésus Jairus terus niba nang ngarepé. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Dèkné nyuwun: “Duh Gusti, anakku wédok lara nemen tenan. Mbok hayuk nang nggonku ta! Anakku mbok ditumpangi tangan supaya bisa waras lan urip terus.” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Gusti Yésus terus mèlu Jairus. Wong pirang-pirang pada mèlu, sampèk pada ngesuk-esuk Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nang tengahé wong-wong kuwi ènèng wong wédok siji sing lara ngetokké getih. Wis rolas taun suwéné wongé nduwé lara kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Pirang-pirang dokter wis diparani, sampèk duwité lan bandané entèk kabèh, nanging ora bisa mari, malah mundak nemen. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Saiki wongé krungu nèk Gusti Yésus bisa nambani wong lara, mulané dèkné terus nékat mèlu nrombol nang mburiné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Wongé pretyaya ngéné: “Nèk aku bisa ndemèk saliné waé, aku mesti mari.” Mulané wongé ya terus ndemèk saliné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sakwat getihé wongé mampet lan wongé krasa nèk larané wis ilang kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Gusti Yésus uga krasa nèk ènèng kekuwatan metu sangka awaké. Dèkné terus minger ndelokké wong-wong nang mburiné lan takon: “Sapa sing ndemèk salinku?” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Murid-muridé semaur: “Gusti, lah sapa sing ngerti! Wong pirang-pirang kaya ngono pada ngesuk-esuk Kowé, lah kok Kowé takon: ‘Sapa sing ndemèk salinku?’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nanging Gusti Yésus nyawang wong-wong, nggolèki wongé sing ndemèk saliné. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wong wédok mau rumangsa sing ndemèk lan dèkné saiki wis krasa waras awaké, mulané terus maju. Karo ndredek sangking wediné, dèkné niba nang ngarepé Gusti Yésus terus ngaku. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Gusti Yésus ngomong: “Yu, kowé saiki wis mari, awit kowé pretyaya. Kana mulih. Mlaku sing apik-apik. Kowé wis mari tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Gusti Yésus durung rampung sing ngomong, kok terus ènèng kongkonan sangka omahé Jairus ngomong nèk anaké wis mati. Wongé ngomong ngéné marang Jairus: “Anakmu wis ninggal. Guruné wis aja dirusuhi!” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Gusti Yésus krungu, nanging ora ngrèwès omongané wong kuwi mau, malah ngomong: “Aja wedi Jairus, pretyaya waé!” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wong-wong dipenging mèlu nang omahé Jairus. Sing diejèk namung rasul Pétrus, Yakobus lan Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kadung wis tekan omahé, Gusti Yésus krungu wong tangisan pating jlerit. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dèkné mlebu terus ngomong marang wong-wong: “Kenèng apa kok pada nangis pating jlerit? Botyahé ora mati, namung turu!” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nanging Gusti Yésus malah diguyu. Wong-wong terus dikongkon metu kabèh. Namung wong tuwané botyahé lan murid telu mau diejèk mlebu nang kamaré. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gusti Yésus terus nyekel tangané botyahé karo ngomong: “Talita kum!” Nèk tyara Jawa: “Tangi wuk!” ");
INSERT INTO jvnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sakwat botyahé tangi terus mlaku. (Botyahé umuré rolas taun.) Wong tuwané botyahé lan murid-muridé mau pada nggumun banget. ");
INSERT INTO jvnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Gusti Yésus terus ngomong: “Aja sampèk wong liya-liyané krungu bab iki.” Wong tuwané terus dikongkon ngekèki mangan botyahé. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sangka nggoné Jairus Gusti Yésus terus mulih nang kuta panggonané. Iku kuta Nasarèt. Murid-muridé mbarang pada mèlu. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ing dina sabat Gusti Yésus terus molai mulangi nang sinaguk kono. Wong-wong sing ngrungokké pada nggumun kabèh. Pada ngomong: “Wong iki éntuk piwulangan sangka ngendi ya? Kok pinter temen? Kok bisa nindakké mujijat-mujijat mbarang? ");
INSERT INTO jvnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iki lak sing tukang nggawé krosi-méja kaé ta? Anaké Maria, tunggalé Yakobus, Yoses, Yudas lan Simon. Adik-adiké sing wédok mbarang lak manggon nang kéné ta?” Wong-wong pada nampik Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mulané Gusti Yésus ngomong marang wong-wong: “Nabi kuwi nang endi-endi diajèni, kejaba nang panggonané déwé. Seduluré déwé waé ora ngajèni.” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mulané Dèkné ora bisa nindakké mujijat-mujijat nang kono. Namung wong lara siji-loro ditumpangi tangan karo Gusti Yésus, terus pada mari. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Gusti Yésus déwé ya nggumun, wong-wong kok ora gelem pretyaya. Gusti Yésus terus budal nang désa-désa nang kiwa-tengené kuta Nasarèt kono, mulangi wong-wong bab pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dèkné uga manggil murid sing rolas dikongkon budal loro-loro nggelar kabar kabungahan lan dikèki pangwasa nundungi demit. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nanging dipenging nggawa apa-apa, kejaba tekené. Pangan ora, duwit ya ora. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kenèng nganggo tèklèk, nanging ora éntuk nggawa salin dobel. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gusti Yésus terus ngomong: “Nèk kowé merdayoh nang omahé sakwijiné wong, nginepa nang kono waé nganti kowé lunga menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nèk nang sakwijiné panggonan wongé ora gelem nampa lan ora gelem ngrungokké kowé, lungaa waé sangka kono. Nanging lemahé diketokké sangka sikilmu, supaya pada ngerti nèk pada nampik kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Murid rolas mau terus pada budal mituturi wong-wong, kongkon pada ninggal urip ala lan manut marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Demit pirang-pirang pada ditundungi lan okèh wong lara pada ditambani nganggo usapan lenga. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Gusti Yésus selot suwi selot kesuwur lan nang endi-endi wong-wong pada krungu bab Dèkné, uga ratu Hérodès. Enèng sing ngomong: “Yésus iki ya Yohanes Pembaptis sing urip menèh, mulané Dèkné bisa nindakké mujijat.” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Liyané ngomong: “Yésus iki mesti nabi Elia sing urip menèh.” Enèng liyané menèh sing ngomong: “Yésus kuwi nabi tunggalé liya-liyané ing jaman mbiyèn.” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kadung ratu Hérodès krungu, dèkné ngomong: “Yésus iki Yohanes sing wis tak ketok guluné, nanging urip menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Awit mauné Yohanes wis dilebokké nang setrapan karo ratu Hérodès, nuruti jalukané Hérodias. Jalaran Yohanes ajek ngomongi ratuné nèk klakuané kebatyut. Hérodès ngepèk Hérodias, bojoné Filipus, kakangé déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohanes ngomong: “Kowé ora kenèng ngepèk ipému déwé nèk bojoné ijik urip!” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mulané Hérodias ngintyim-intyim Yohanes arep dipatèni, nanging durung bisa, awit ijik dialang-alangi karo ratu Hérodès. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hérodès déwé wedi karo Yohanes, awit ngerti nèk Yohanes kuwi wong bener lan wong sutyi, mulané dèkné ya dijaga. Hérodès seneng ngrungokké Yohanes, senajan tembungé marakké dèkné wedi lan bingung. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nanging ing sakwijiné dina Hérodias nemu kelunggaran kanggo matèni Yohanes, yakuwi, dongé ratu Hérodès tutup taun lan nganakké pésta gedé; wong gedé-gedé, uga para penggedéné militèr lan para penggedéné distrik Galiléa pada teka kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kadung anaké Hérodias molai njogèt, ratuné lan dayoh-dayohé terus pada seneng tenan karo botyah wédok kuwi. Mulané ratu Hérodès terus ngomong marang botyahé: “Kowé kepéngin apa Wuk, sak njalukmu tak kèki. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tenan, aku janji marang kowé, senajana kowé njaluk separoné negaraku, bakal tak kèkké!” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Botyahé terus lunga takon ibuné: “Bu, aku énaké njaluk apa ya?” Ibuné semaur: “Kana kowé njaluk endasé Yohanes Pembaptis!” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Botyahé terus balik menèh nang nggoné ratuné ngomong: “Aku njaluk endasé Yohanes Pembaptis nang piring!” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ratu Hérodès sedi banget krungu penjalukan kuwi. Nanging dèkné ora bisa apa-apa, awit wis kadung janji. Karomenèh dayohé pada mèlu nyeksèni janjiné. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mulané dèkné terus ngongkon sing tukang jaga kono ngetok guluné Yohanes lan kongkon nggawakké mbrono. Wongé terus budal lan nang setrapan kono dèkné ngetok guluné Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Endasé terus digawa nang piring dikèkké botyahé. Botyahé terus masrahké endasé marang ibuné. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Murid-muridé Yohanes krungu nèk dèkné wis ninggal, mulané terus pada njikuk layoné dikubur. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Para rasul wis pada balik menèh nang nggoné Gusti Yésus. Nang kono pada nyritakké bab sembarang sing ditindakké lan diwulangké. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Gusti Yésus terus ngomong: “Hayuk pada nggolèk panggonan sing sepi kanggo lèrèn sedilut.” Awit wong okèh pada teka-lunga sampèk Gusti Yésus lan murid-muridé ora kober mangan. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mulané terus ninggal wong-wong lunga karo prauné nggolèk panggonan sepi. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nanging wong okèh weruh lungané lan nitèni parané Gusti Yésus. Sangka kuta-kuta wong-wong pada budal mlaku ndisiki. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kadung Gusti Yésus medun sangka prauné, Dèkné weruh wong okèh wis nang kono. Dèkné terus melas banget, awit wong-wong kuwi kaya wedus sing ora ènèng sing ngengon. Mulané Gusti Yésus terus mulangi wong-wong bab werna-werna prekara. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Dongé wis soré murid-muridé ngomong marang Gusti Yésus: “Saiki wis soré lan nang panggonan kéné ora ènèng apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mbok wong-wong dikongkon lunga bèn pada nggolèk mangan déwé-déwé nang désa-désa.” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nanging Gusti Yésus semaur: “Kowé sing kudu ngekèki mangan wong-wong.” Murid-muridé ngomong: “Lah kuwi pirang duwit waé?” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Gusti Yésus terus takon: “Kana didelok ènèng roti pira!” Kadung wis niliki terus ngomong: “Enèng roti lima lan iwak loro!” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Gusti Yésus terus ngongkon murid-muridé nata wong-wong, bèn pada njagong nang suketan, sakkrompol-sakkrompol. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wong-wong terus pada njagong; ènèng krompolan sing wongé satus, ènèng sing sèket. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Gusti Yésus terus njikuk roti lima lan iwak loro mau. Dèkné nyawang nduwur karo ndonga. Sakwisé kuwi rotiné terus dityuwil-tyuwil lan dikèkké marang murid-muridé kongkon ngedum marang wong-wong. Iwak loro mau uga dityuwil-tyuwil terus diedum-edumké. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wong kabèh pada mangan sampèk warek. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Turahané roti lan iwak sing ora kepangan dilumpukké ènèng rolas ténggok. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sing mangan ènèng wong limang èwu, kuwi namung wong lanangé. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sakwisé iku Gusti Yésus terus ngongkon murid-muridé numpak prauné ndisik nang désa Bètsaida, nang abrahan. Wong-wong liyané terus disuwun kongkon mulih. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kadung wis pisah karo murid-muridé, Gusti Yésus terus munggah gunung arep ndonga. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dongé surup prauné wis nang tengah-tengah, nanging Gusti Yésus ijik nang daratan déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Gusti Yésus weruh nèk murid-muridé kangèlan tenan sing ndayung, awit tatapan angin. Kira-kira jam telu tekané jam nenem ésuk Gusti Yésus terus nusul, mlaku nang mér. Kétoké Dèkné mlaku terus, kaya arep ngliwati prauné. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kadung murid-muridé weruh Gusti Yésus mlaku nang banyu terus pada njerit. Ndarani weruh mokmedi. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kabèh weruh Dèkné terus pada wedi. Mulané Gusti Yésus ngomong: “Aja pada kagèt! Iki Aku! Wis aja pada wedi menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Gusti Yésus terus mèlu numpak prauné lan anginé terus mandek. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Murid-muridé durung pada nitèni kwasané Gusti Yésus, senajana weruh Dèkné ngekèki mangan wong limang èwu. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gusti Yésus lan murid-muridé terus ngabrah mér tekan bawah Genésarèt. Nang kono terus medun sangka prauné. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wong-wong pada nitèni nèk kuwi Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Sakwat liya-liyané sak désa terus diomongi kabèh. Sing lara terus digotongi sak lèmèké. ");
INSERT INTO jvnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Endi waé sing ditekani Gusti Yésus, kebonan, désa apa kuta, wong-wong mesti pada teka nggawa sing lara, terus diglétakké nang lataré pasar. Wong-wong pada nyuwun marang Gusti Yésus nglilani sing lara ndemèk saliné Dèkné, senajan namung gombyoké. Sing ndemèk terus pada mari. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ing sakwijiné dina ènèng wong Farisi lan guru Kitab sak krompol sangka Yérusalèm teka nang nggoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wong-wong iki weruh nèk murid-muridé Gusti Yésus ènèng sing mangan tanpa wisuh tangané ndisik. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Para Farisi lan sasaté wong Ju kabèh lumrahé wisuh ndisik nèk arep mangan, manut pernatané mbah-mbahané mbiyèn. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kaya nèk tekan pasar mbarang, mesti wisuh ndisik sakdurungé mangan apa-apa. Lan ijik ènèng pernatan pirang-pirang menèh sing kudu dilakoni, kaya ngumbah mangkok, tyangkir lan kendil. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mulané para Farisi lan guru-guru Kitab mau pada maido Gusti Yésus ngéné: “Kenèng apa kok murid-muridmu ora pada nurut pernatan tinggalané mbah-mbahané awaké déwé? Kok pada mangan tanpa wisuh ndisik?” ");
INSERT INTO jvnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Gusti Yésus semaur: “Kowé kuwi namung kétok apik njabané. Pantyèn tyotyok banget sing diomong karo nabi Yésaya mbiyèn bab kowé kuwi, sing uniné ngéné: ‘Tembungé Gusti Allah: Bangsa iki enggoné memuji Aku namung karo lambéné, nanging atiné adoh sangka Aku!’ ");
INSERT INTO jvnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","‘Enggoné nyembah marang Aku ora ènèng gunané, awit pada mulangi wong-wong kongkon nglakoni pernatan-pernatan gawéané manungsa.’ ");
INSERT INTO jvnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Kowé namung nurut pernatané manungsa, wèté Gusti Allah malah pada mbok singkirké. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Pantyèn pinter nggonmu pada nyingkiri wèté Gusti Allah, supaya bisa neruské karepmu déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nabi Moses lak wis tau ngomong ngéné ta: ‘Ngajènana marang wong tuwamu. Sapa ngolok-olok bapa-biyungé kudu dipatèni.’ ");
INSERT INTO jvnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Nanging kowé malah pada mulangi ngéné: Urunan sing arep mbok kèkké marang wong tuwamu kenèng dikèkké marang Gusti Allah. Dadiné kowé ora usah ngekèki marang wong tuwamu menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dadiné wèté Gusti Allah mbok singkirké, kowé malah pada nganggokké pernatanmu déwé. Lan ijik ènèng liya-liyané menèh bab kaya ngono kuwi sing mbok lakoni!” ");
INSERT INTO jvnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","15","Gusti Yésus terus nyeluk wong-wong kabèh dipituturi ngéné: “Tembungku iki dirungokké, supaya kabèh bisa dunung sing apik. Barang sing mlebu nang wetengé manungsa kuwi ora bisa marakké ala, nanging barang sing metu sangka pikirané, iku sing marakké manungsa nglakoni ala. ( ");
INSERT INTO jvnNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mulané, dirungokké sing apik, kowé sing nduwé kuping.”) ");
INSERT INTO jvnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wong-wong terus ditinggal, Dèkné terus mlebu omah. Nang njero omah kono murid-muridé takon marang Gusti Yésus bab sing diwulangké mau, awit ora pada dunung. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Gusti Yésus semaur: “Mosok kowé mbarang ora dunung. Apa kowé ora ngerti nèk barang sing dipangan kuwi ora mlebu atiné, nanging mlebu wetengé manungsa terus metu menèh. Mulané panganan kuwi ora bisa marakké manungsa ala.” (Nang kéné Dèkné ndunungké nèk panganan apa waé kenèng dipangan.) ");
INSERT INTO jvnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Gusti Yésus terus ngomong menèh: “Sing marakké manungsa nglakoni ala kuwi barang sing metu sangka atiné, yakuwi pikirané. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Kayadéné laku bédang, nyenyolong, mematèni, ngrusui bojoné liyané, murka, srakah, sak wernané penggawé ala, memèrèn, memisuh, sombong lan sembrana.” ");
INSERT INTO jvnNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kuwi kabèh metuné sangka pikirané manungsa. Kuwi sing marakké manungsa ala. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sangka panggonan kono Gusti Yésus terus lunga nang bawah Sidon lan Tirus. Nang kono Dèkné terus mlebu nang sakwijiné omah, supaya ora ènèng wong ngerti nèk Dèkné teka. Nanging wong-wong meksa ngerti. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ora let suwi terus ènèng wong wédok teka. Wongé krungu bab Gusti Yésus. Wong iki nduwé anak wédok sing kelebon demit. Wongé niba nang ngarepé Gusti Yésus lan nyuwun supaya ngetokké demit sing ngwasani anaké. Nanging wong wédok iki dudu wong Ju, dèkné wong lairan Fenisia nang negara Siro. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mulané Gusti Yésus ngomong ngéné: “Ah, mbok bèn anak-anaké déwé pada warek ndisik. Ora lumrah nèk pangané anak-anak dikèkké asu!” ");
INSERT INTO jvnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nanging wong wédoké semaur: “Bener Gusti, nanging asuné lak éntuk rèbèlané anak-anak ta?” ");
INSERT INTO jvnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Gusti Yésus terus ngomong: “Wis, kana mulih. Anakmu wis mari. Sangka tembungmu kuwi Aku ngerti nèk kowé pretyaya marang Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wongé terus mulih. Tekan omah nemu anaké ngglétak anteng nang ambèn. Demité wis lunga. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Gusti Yésus lunga sangka bawah Tirus budal nang bawah mér Galiléa. Nanging mlakuné ngliwati kuta Sidon lan bawah Dékapolis. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nang Galiléa kono ènèng wong sing budek lan bisu digawa nang nggoné Dèkné. Wong-wong nyuwun marang Gusti Yésus supaya numpangi tangan marang wong lara iki. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wong budek-bisu iki terus didèwèkké karo Gusti Yésus, adoh karo wong-wong liyané. Kupingé wongé kabèh loro terus didulek. Sakwisé ngono Gusti Yésus terus idu lan ndemèk ilaté wongé. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dèkné terus nyawang nduwur karo ngetyulké ambekan, terus ngomong marang wongé: “Efata!” Tegesé: “Mengaa!” ");
INSERT INTO jvnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kupingé wongé terus bisa krungu lan ilaté malih lemes, terus bisa omong-omongan kaya sak lumrahé. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Gusti Yésus menging wong-wong ngabar-ngabarké lelakon mau, nanging wong-wong malah pada ndadi sing ngomong-omongi liya-liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kabèh pada nggumun banget lan ngomong: “Wah, jan nyata tenan. Dèkné bisa sembarang. Sing budek bisa krungu lan sing bisu bisa ngomong.” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ora let suwi wong-wong pada ngumpul menèh ngrungokké piwulangé Gusti Yésus. Nanging nang kono ora ènèng panganan apa-apa. Mulané Gusti Yésus terus nyeluk murid-muridé ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Aku melas marang wong-wong! Wis telung dina suwéné wong-wong pada mèlu Aku lan saiki sing dipangan wis entèk. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mengko nèk sakdurungé mangan wis tak kongkon mulih, menawa bisa ambruk nang dalan. Lah katik ènèng sing omahé adoh pisan.” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Murid-muridé terus semaur: “Lah awaké déwé sing arep ngekèki mangan wong semono okèhé gèk kepriyé? Nang panggonan kéné ora ènèng panganan apa-apa!” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Gusti Yésus takon: “Kowé nduwé roti pira?” Muridé semaur: “Enèng pitu!” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wong-wong terus dikongkon njagong kabèh. Gusti Yésus terus njikuk roti pitu mau. Sakwisé didongakké terus dityuwil-tyuwil dikèkké murid-muridé kongkon ngedum marang wong-wong. Wong-wong terus pada diedumi. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Enèng sing nduwé iwak mbarang. Iwaké terus didongakké terus kongkon ngedum uga. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wong kabèh mangan sampèk warek. Turahané dilumpukké ènèng pitung ténggok. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Sing mèlu mangan kira-kira ènèng wong patang èwu. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Gusti Yésus lan murid-muridé terus numpak prau budal nang bawah Dalmanutah. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Enèng wong Farisi pada marani Gusti Yésus terus bantah-bantahan karo Dèkné. Wong Farisi mau arep ngenèng Gusti Yésus lan pada njaluk tandané nèk Gusti Allah sing ngekèki pangwasa marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Gusti Yésus terus sambat ing ati lan ngomong: “Kenèng apa wong-wong iki kok pada kepéngin weruh tanda? Ora, ora bakal tak kèki tanda!” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wong-wong mau terus ditinggal. Dèkné terus ngabrah karo prauné. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nang prauné namung ènèng roti siji, awit murid-muridé lali nggawa liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kadung prauné wis mlaku, Gusti Yésus mulangi murid-muridé ngomong: “Kowé kudu sing ati-ati tenan karo raginé wong Farisi lan raginé Hérodès.” (Gusti Yésus sakjané ngomong: “Sing ati-ati karo piwulangé para Farisi lan piwulangé Hérodès.”) ");
INSERT INTO jvnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Murid-muridé ora dunung apa tegesé sing diomong karo Gusti Yésus, mulané pada takon marang sakpada-pada: “Gusti kuwi sakjané ngomongké bab apa ya? Mestiné waé ya sangking awaké déwé ora sangu roti, mulané Gusti ngomong ngono!” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Gusti Yésus ngerti sing dirembuk murid-muridé. Dèkné terus ngomong: “Kowé kok pada ramé ngomongké bab roti. Mosok kowé durung pada nitèni lan durung dunung? Kowé kok angèl banget! ");
INSERT INTO jvnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mosok kowé nduwé mripat, nanging ora bisa weruh. Lan kupingmu kuwi kanggo ngapa kok ora pada krungu? Apa ora ènèng sing kélingan? ");
INSERT INTO jvnNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Dongé Aku nyuwil-nyuwil roti lima kanggo ngekèki mangan wong limang èwu kaé, pirang ténggok sing turah? Wis lali?” Muridé pada semaur: “Rolas ténggok!” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Lan liyané dina menèh, dongé Aku ngekèki mangan wong patang èwu karo roti pitu, pirang ténggok sing turah?” Muridé semaur: “Pitung ténggok!” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Gusti Yésus terus ngomong: “Lah kowé kok durung dunung nèk kekurangan roti kuwi ora kenèng ndadèkké bingung lan répot. Mulané, sing tak omong mau prekara liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Saiki pada tekan désa Bètsaida. Nang kono ènèng wong lamur digawa nang nggoné Gusti Yésus. Sing nggawa pada nyuwun marang Dèkné ndemèk wong sing lamur. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Gusti Yésus terus nyekel tangané wongé sing lamur terus digawa metu nang njabané désa. Nang kono mripaté terus diidoni. Wongé ditumpangi tangan lan ditakoni: “Kowé weruh apa?” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wongé terus ndengongok lan semaur: “Aku weruh wong-wong, nanging kétoké kaya wit-witan mlaku.” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mripaté terus didemèk sepisan menèh. Saiki terus mari lan wongé bisa weruh mat. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Wongé terus dikongkon mulih lan dipenging balik menèh nang désané. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Gusti Yésus lan murid-muridé budal nang désa-désa nang sak kiwa-tengené kuta Sésaréa Filipi. Dongé pada mlaku Dèkné takon marang murid-muridé: “Wong-wong ngarani Aku iki sapa?” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Muridé pada semaur: “Wah, wis werna-werna! Enèng sing ngomong nèk Kowé kuwi Yohanes Pembaptis. Liyané ngarani Kowé kuwi nabi Elia. Enèng menèh sing ngomong nèk Kowé kuwi sakwijiné nabi jaman mbiyèn sing saiki teka menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Gusti Yésus terus takon: “Lah kowé kepriyé? Aku iki sapa?” Rasul Pétrus semaur: “Kowé kuwi Kristus!” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sakwisé krungu kuwi Gusti Yésus menging murid-muridé ngabar-ngabarké nèk Dèkné kuwi Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Gusti Yésus terus molai ndunung-ndunungké marang murid-muridé nèk Dèkné kuwi Anaké Manungsa sing bakal nglakoni sangsara okèh. Dèkné bakal disepèlèkké karo para pinituwa, para pengarepé imam lan guru-guru Kitab. Dèkné bakal dipatèni, nanging bakal tangi menèh ing telung dinané. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Gusti Yésus sing ngomongké bab kuwi ya blaka waé. Krungu kuwi mau rasul Pétrus terus ngomong marang Gusti Yésus, nanging tanpa liyané krungu: “Gusti, mbok aja ngomong kaya ngono!” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nanging Gusti Yésus malah minger ndelokké murid-murid liyané terus nyenèni rasul Pétrus: “Lungaa sangka ngarepku Sétan, awit kowé ora manut kekarepané Gusti Allah, nanging manut pikirané manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Gusti Yésus terus nyeluk wong-wong sing nang kono lan murid-muridé mbarang diomongi ngéné: “Sapa sing kepéngin dadi muridku kudu saguh ninggal kekarepané déwé, manggul pentèngané lan mèlu Aku. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Awit sapa sing éman uripé, yakuwi sing bakal kélangan. Nanging sapa sing nglabuhi Aku lan kabar kabungahan tekan pati, wong kuwi nyawané bakal slamet slawas-lawasé. ");
INSERT INTO jvnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lan menèh, senajana sembarang sing mbok golèki lan mbok senengi bisa keturutan kabèh, apa gunané, nèk kowé kélangan nyawamu? ");
INSERT INTO jvnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Apa ing donya kéné sing kenèng dadi ijolé nyawamu? Lak ora ènèng ta? ");
INSERT INTO jvnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mulané, sapa sing isin ngakoni Aku lan piwulangku ing jaman sing kebek ala iki, mbésuk nèk Anaké Manungsa teka, bareng karo mulékat-mulékat sing sutyi nganggo kamulyané Bapaké, Dèkné ya ora bakal ngaku nèk kenal wong kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Gusti Yésus terus ngomong menèh: “Mbok dititèni ta! Nang tengahé wong-wong sing nang kéné iki ènèng sing bakal ora mati, sakdurungé weruh Kratoné Gusti Allah teka nganggo pangwasa.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nem dina sakwisé kuwi Gusti Yésus ngejèk rasul Pétrus, Yohanes lan Yakobus munggah nang gunung duwur. Kejaba wong papat iki ora ènèng wong liyané menèh. Nang kono Gusti Yésus terus malih. Murid-muridé pada weruh kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Saliné Gusti Yésus malih putih sumeblak, jan puti tenan. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Rasul Pétrus, Yohanes lan Yakobus terus weruh nabi Moses lan nabi Elia omong-omongan karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Rasul Pétrus terus ngomong marang Gusti Yésus: “Gusti, kok ndilalah temen awaké déwé nang kéné. Apiké awaké déwé nggawé gubuk telu waé, siji kanggo Kowé, siji kanggo nabi Moses lan siji menèh kanggo nabi Elia.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Rasul Pétrus ngomong ngono kuwi, awit ora ngerti kudu ngomong apa, sangking kagèté. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Terus ènèng méga teka, ayang-ayangé nutupi wong-wong. Sangka méga mau terus ènèng swara ngomong: “Iki Anakku sing tak trésnani. Dèkné kudu mbok gugu.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kadung para rasul nolèh kiwa-tengen wis ora weruh sapa-sapa menèh, namung Gusti Yésus déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dongé pada mlaku medun gunung, Gusti Yésus ngomong marang murid-muridé: “Sembarang sing kowé weruh mau aja diomongké sapa-sapa ndisik. Mbésuk nèk Anaké Manungsa wis tangi sangka pati kowé kenèng ngomongké.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pantyèn murid telu kuwi ya ora ngomong karo sapa-sapa, nanging bab “tangi sangka pati” sing dirembuk karo Gusti Yésus kuwi wong telu mau ora pada dunung. Pada kepéngin ngerti apa tegesé. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mulané terus takon marang Gusti Yésus: “Lah kenèng apa guru-guru Kitab kok ngomong nèk nabi Elia kudu teka ndisik?” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Gusti Yésus semaur: “Pantyèn, guru-guru Kitab kuwi bener. Nabi Elia kudu teka ngélingké wong-wong menèh bab dalané Gusti Allah. Nanging bab Anaké Manungsa ketulis nèk Dèkné bakal nglakoni sangsara okèh lan bakal disepèlèkké. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mulané Aku ngomong nèk ènèng nabi kaya nabi Elia wis teka, kaya sing ketulis nang Kitab. Nanging dèkné digawé sak gelemé, tyotyok karo sing wis ketulis nang Kitab Sutyi.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Dongé Gusti Yésus karo murid telu mau wis balik menèh, terus pada weruh murid-murid liyané ijik èngkèl-èngkèlan karo guru-guru Kitab, sampèk dirubung wong okèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kadung weruh Gusti Yésus terus sakwat pada bungah kabèh, terus marani lan mbagèkké Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Gusti Yésus terus takon marang murid-muridé: “Apa sing mbok rembuk karo guru-guru kuwi?” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Terus ènèng wong sing semaur: “Gusti, aku arep nggawa anakku nang nggonmu. Botyah iki kelebon demit malih bisu. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nèk kumat botyah iki niba-niba nang lemah. Tyangkemé metu umpluké lan botyahé terus kerot-kerot untu lan awaké terus kaku. Mulané aku njaluk tulung marang murid-muridmu kuwi kongkon ngetokké demité, nanging ora bisa.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Gusti Yésus terus ngomong: “Kenèng apa kowé kok ora nduwé pengandel? Sepira menèh suwéné Aku ijik kudu nang tengahmu lan sepira menèh suwéné Aku ijik kongkon nyabari kowé? Digawa mbréné botyahé!” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Botyahé terus digawa nang nggoné Gusti Yésus. Kadung demité weruh Gusti Yésus, botyahé terus metyityil-metyityil niba nang lemah terus nggulung-nggulung tyangkemé metu umpluké. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Gusti Yésus terus takon marang bapaké: “Botyah iki wiwit kapan lara?” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bapaké semaur: “Wis wiwit tyilik! Lan wis ping okèh demité njongkrokké botyahé nang geni apa nang mbanyu bèn mati. Mulané aku nyuwun, nèk Kowé bisa, mbok melas, aku ditulungi!” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Gusti Yésus ngomong: “Nèk Aku bisa? Sembarang bisa nèk kowé pretyaya!” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bapaké botyahé terus ngomong: “Aku pretyaya, Gusti! Nanging pengandelku kurang. Aku mbok diréwangi pretyaya!” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Gusti Yésus weruh nèk wong-wong sing ngrubung mau tambah okèh, mulané demité terus ditundung. Gusti Yésus ngomong: “Demit sing marakké botyah iki budek lan bisu, metua lan aja pisan-pisan balik menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Demité terus metu karo njerit-njerit lan botyahé ngetyetyeng-ngetyetyeng terus niba kaya wong mati. Wong-wong mikiré botyahé mati tenan. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Gusti Yésus terus nyekel tangané botyahé ditangèkké. Botyahé terus ngadek. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kadung Gusti Yésus wis mlebu nang omah murid-muridé terus takon: “Gusti, kenèng apa awaké déwé kok ora bisa ngetokké demité?” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Gusti Yésus semaur: “Demit kaya ngono kuwi lungané namung karo pandonga!” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Gusti Yésus lan murid-muridé lunga sangka panggonan kono terus pada mlaku terus ngliwati Galiléa. Gusti Yésus ora gelem nèk wong-wong sampèk ngerti nèk Dèkné liwat kono, awit Dèkné ijik mulangi murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Gusti Yésus ngomong ngéné: “Anaké Manungsa bakal dielungké marang wong-wong sing bakal matèni Dèkné. Nanging ing telung dinané Dèkné bakal tangi menèh sangka pati.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Murid-muridé sakjané ora dunung sing diomong karo Gusti Yésus, nanging ora ènèng sing wani takon apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Gusti Yésus lan murid-muridé teka nang kuta Kapèrnakum. Kadung wis nang omah Gusti Yésus takon: “Nang dalan mau kowé pada ngomongké apa ta?” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Murid-muridé ora ènèng sing wani semaur apa-apa, awit nang dalan mau pada èngkèl-èngkèlan ngomongké bab sapa sing gedé déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Gusti Yésus terus njagong, murid rolas mau dityeluk kabèh terus diwulangi ngéné: “Wong sing kepéngin diajèni lan dianggep gedé kuwi wong sing gelem ngalah lan gelem ngladèni liyané!” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Gusti Yésus terus nyekel botyah tyilik didèkèk nang tengahé murid-muridé. Dèkné ngrangkul botyahé karo ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Wong sing nampani botyah kaya ngéné iki ing jenengku, wong kuwi nampani Aku. Lan menèh, wong sing nampani Aku kuwi ora namung nampani Aku déwé, ora, nanging uga nampani sing ngongkon Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Rasul Yohanes ngomong marang Gusti Yésus: “Gusti, awaké déwé weruh ènèng wong ngetokké demit nganggo jenengmu. Nanging wong iku dudu tunggalé awaké déwé, mulané awaké déwé ya menging wongé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nanging Gusti Yésus semaur: “Aja, wongé aja mbok penging. Awit ora ènèng wong sing saiki nganggokké jenengku kanggo nindakké mujijat terus sésuké wongé ngèlèk-èlèkké Aku. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Awit sapa sing ora nglawan awaké déwé mesti ya ngrujuki awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tenan, ngandela ta! Sapa sing ngekèki ngombé marang kowé jalaran wongé ngerti nèk kowé kuwi muridé Kristus, wong kuwi mesti bakal éntuk upahé sangka Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Gusti Yésus terus ngomong ngéné: “Sapa sing marakké wong sing enom ing pengandel ninggal dalanku, wong kuwi luwung dibanduli watu gilingan waé guluné, terus dityemplungké nang segara. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nèk tanganmu marakké kowé nglakoni ala, diketok waé. Luwung kowé mlebu urip langgeng karo tangan siji, tenimbang tanganmu genep loro, nanging kowé mlebu nang neraka, nang geni sing ora bisa mati. ( ");
INSERT INTO jvnNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nang neraka uleré ora mati lan geniné murup terus.) ");
INSERT INTO jvnNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nèk sikilmu marakké kowé mlaku nang dalan ala, diketok waé. Luwung kowé mlebu urip langgeng karo sikil siji, tenimbang sikilé genep loro, nanging dibuwang nang neraka. ( ");
INSERT INTO jvnNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nang neraka uleré ora mati lan geniné murup terus.) ");
INSERT INTO jvnNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nèk mripatmu marakké kowé nglakoni ala, dityepol waé. Luwung mlebu Kratoné Gusti Allah karo mripat siji, tenimbang mripatmu genep loro, nanging dityemplungké nang neraka. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nang neraka kuwi kowé bakal ngalami sangsara gedé slawasé. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Saben wong kudu dijajal pengandelé supaya ora luntur. Kuwi kenèng dipadakké karo nèk nguyahi kaé, supaya awèt. ");
INSERT INTO jvnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Uyah kuwi kanggo gawé tenan. Nanging nèk uyahé ilang asiné, ora ènèng apa-apa menèh sing kenèng dienggo ngasinké? “Mulané, kowé kuwi kudu kaya wong sing wis diuyahi. Pada urip bebarengan sing rukun.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Gusti Yésus lunga sangka panggonan kono terus budal nang Yudéa, terus ngabrah laut Yordan. Wong pirang-pirang pada nglumpuk ngrubung Dèkné, mulané kaya lumrahé, wong-wong terus diwulangi bab Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Terus ènèng wong Farisi pada teka arep ngenèng Gusti Yésus nganggo pitakonan. Wong Farisi mau takon ngéné: “Apa wong lanang éntuk megat bojoné?” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Gusti Yésus semaur: “Lah wèté nabi Moses mulangi kepriyé?” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Entuk, janji wong lanangé gelem nulis layang pegat terus dikèkké sing wédok.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Gusti Yésus terus ngomong: “Nabi Moses nggawé pernatan ngono kuwi jalaran sangka wangkoté atimu. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nanging kawit mbiyèné Gusti Allah nggawé wong lanang lan wong wédok. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mulané wong lanang kuwi bakal ninggal bapa-biyungé lan dadi siji karo bojoné. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ora wong loro menèh, nanging wong loro kuwi wis dadi siji. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dadiné, apa sing wis digatukké karo Gusti Allah, manungsa ora kenèng misah.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Dongé wis nang omah menèh, murid-muridé terus takon marang Gusti Yésus bab pegatan mau. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Gusti Yésus mulangi ngéné: “Nèk wong lanang megat sing wédok terus ngepèk wong wédok liyané, wong lanang kuwi laku bédang. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Uga nèk wong wédok megat sing lanang terus ngepèk wong lanang liyané, wong wédok kuwi ya pada waé laku bédang.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wong-wong pada nggawa anaké nang nggoné Gusti Yésus supaya didongakké lan diberkahi. Nanging murid-muridé pada nyenèni wong-wong kuwi dipenging ngrusui Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kadung Gusti Yésus weruh, dèkné terus jèngkèl. Mulané Dèkné nyenèni murid-muridé ngéné: “Mbok bèn! Botyah-botyah aja dialang-alangi. Bèn pada mbréné nang nggonku. Awit Kratoné Gusti Allah namung kanggo wong sing atiné kaya botyah-botyah iki. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pantyèn tenan, sapa sing ora nampa Kratoné Gusti Allah kaya botyah-botyah iki ora bakal bisa ngleboni kraton iki.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Botyah-botyah terus dirangkuli, terus ditumpangi tangan lan diberkahi siji-siji. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dongé Gusti Yésus arep budal menèh terus ènèng wong mblayu marani Dèkné. Wongé sujut nang ngarepé Gusti Yésus terus takon: “Guru, pantyèn Kowé betyik tenan. Bisané éntuk urip langgeng aku kudu nglakoni apa?” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Gusti Yésus semaur: “Kowé kok ngarani Aku betyik? Gusti Allah déwé sing betyik, ora ènèng liyané! ");
INSERT INTO jvnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kowé wis ngerti wèt-wèté ta? Aja matèni wong, aja ngrusui bojoné liyané, aja nyolong, aja goroh, aja ngapusi wong lan ngajènana marang bapa-biyungmu.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Wongé semaur: “Guru, kawit tyilik aku wis nurut wèt-wèt kabèh kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Gusti Yésus nyawang wongé terus krasa trésna marang dèkné, mulané terus ngomong: “Barang siji sing durung mbok lakoni: kana mulih, apa nduwému diedol kabèh. Sepira payuné dikèkké marang wong sing ora nduwé supaya kowé bisa nduwé banda nang swarga. Nèk kuwi wis mbok lakoni kowé terus mbrénéa mèlu Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wongé krungu Gusti Yésus ngomong ngono kuwi terus amleng. Dèkné lunga karo sedi, awit dèkné sugih tenan. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Gusti Yésus terus nyawang murid-muridé ngomong: “Pantyèn angèl tenan kanggo wong sugih mlebu Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Murid-muridé kagèt krungu tembung kuwi. Mulané Gusti Yésus terus ngomong: “Anak-anak, pantyèn angèl banget mlebu Kratoné Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Luwih gampang unta mlebu bolongan dom, tenimbang wong sugih mlebu Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Murid-muridé saiki ora dunung blas, mulané takon: “Gusti, lah sapa sing bisa slamet?” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Gusti Yésus ndelokké murid-muridé terus semaur: “Pantyèn, angèl banget kanggo manungsa, nanging ora angèl kanggo Gusti Allah. Kanggo Gusti Allah sembarang bisa klakon.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Rasul Pétrus terus ngomong: “Gusti, awaké déwé wis ninggal sembarang terus mèlu Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Gusti Yésus semaur: “Dirungokké sing apik omongku iki. Sapa sing ninggal omah lan keboné, ninggal wong tuwa, sedulur lan anaké jalaran nglabuhi Aku lan nglabuhi kabar kabungahané Gusti Allah, wong kuwi saiki mesti nampa sembarang ngungkul-ungkuli mauné. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Bakal nampa ping satus, ya omah, sedulur, wong tuwa, anak lan kebon, senajana karo ngalami kasangsaran. Lan ing tembé bakal nampa urip langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nanging okèh sing nang ngarep bakalé kèri, malah sing teka kèri bakalé nang ngarep.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Saiki Gusti Yésus karo murid-muridé pada mlaku budal nang Yérusalèm. Gusti Yésus mlaku nang ngarep déwé. Murid-muridé durung mari kagèté lan wong-wong liyané sing mèlu uga pada wedi. Murid rolas mau terus dityeluk didèwèkké karo Gusti Yésus terus diomongi bab sing bakal dialami karo Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Gusti Yésus ngomong ngéné: “Dititèni déwé! Saiki awaké déwé arep nang Yérusalèm. Nang kono para pengarepé imam lan para guru Kitab bakal nyekel Anaké Manungsa. Bakal pada nyalahké Dèkné lan masrahké Dèkné marang bangsa liya sing ora kenal marang Gusti Allah kongkon matèni. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wong-wong kuwi bakal pada moyoki, ngidoni lan metyuti Dèkné lan entèk-entèké bakal pada matèni Dèkné. Nanging ing telung dinané Dèkné bakal tangi sangka pati.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Rasul Yakobus lan Yohanes, kabèh loro anaké Sébédéus, terus maju lan ngomong marang Gusti Yésus: “Guru, awaké déwé nduwé pitakonan.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Arep takon apa?” Gusti Yésus semaur. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Gusti, nèk Kowé wis dadi ratu, awaké déwé kepéngin mèlu njagong kaya ratu nang sebelahmu, siji nang tengen lan siji nang kiwa.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Gusti Yésus ngomong: “Kowé ora ngerti apa sing mbok jaluk! Apa kowé gelem nglakoni kasangsaran sing bakal tak alami?” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Gelem Gusti!” Gusti Yésus terus ngomong: “Pantyèn, kasangsaran sing bakal tak alami kowé uga bakal mèlu ngalami. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nanging bab njagong nang tengen apa kiwaku aku ora nduwèni kwasa ngarani. Iku wis dityawiské karo Gusti Allah kanggo sing dipilih karo Dèkné déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Krungu kuwi murid sing sepuluh terus jèngkèl karo rasul Yakobus lan Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mulané kabèh terus dityeluk karo Gusti Yésus, diomongi ngéné: “Kowé ngerti déwé tyarané wong sing ora pretyaya marang Gusti Allah. Para penggedé sing kudu nata bangsané malah pada ngwasani lan ngerèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Nanging kowé ora kenèng kaya ngono. Sapa sing kepéngin dadi pengarep kudu ngladèni liyané lan sapa sing kepéngin dianggep gedé déwé kudu dadi peladèné liya-liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Awit Anaké Manungsa tekané ya ora njaluk diladèni, nanging supaya ngladèni lan masrahké uripé kanggo nebus uripé wong okèh.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Gusti Yésus lan murid-muridé teka nang kuta Yériko. Kadung bareng karo wong pirang-pirang lunga menèh sangka Yériko, ènèng wong lamur ngemis nang pinggir dalan. Wong iki jenengé Bartiméus, anaké Timéus. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bartiméus krungu nèk sing liwat nang dalan kono kuwi Gusti Yésus sangka kuta Nasarèt, mulané dèkné terus tyeluk-tyeluk: “Yésus, Turunané ratu Daved, mbok melas marang aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wong-wong terus nyenèni Bartiméus kongkon meneng. Nanging wongé malah tambah seru sing tyeluk-tyeluk: “Turunané Daved, mbok melas marang aku!” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Gusti Yésus terus mandek lan ngomong: “Wong kuwi dikongkon mbréné!” Wong lamur mau terus dityeluk karo wong-wong: “Wis aja wedi, ndang ngadeka. Gusti nyeluk kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartiméus terus mbuwang saliné njaba sing nyrimpet-nyrimpeti terus gelis-gelis marani Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Gusti Yésus terus takon: “Aku mbok kongkon ngapa?” “Aku kepéngin weruh, Gusti!” ");
INSERT INTO jvnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Gusti Yésus semaur: “Ya wis, kana! Pengandelmu sing nylametké kowé.” Sakwat Bartiméus bisa weruh terus mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wong-wong saiki wis tyedek karo Yérusalèm, wis tekan désa Bètfaké lan désa Bétani, tyedek karo gunung Olèf. Gusti Yésus terus ngongkon murid loro ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Kana mlebu nang désa sing nang ngarep kaé. Nang kono kowé mengko bakal nemu kimar enom sing dikentyang. Kimar kuwi durung tau ditumpaki wong. Diutyuli terus digawa mbréné. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nèk ènèng wong takon apa-apa, ngomong: ‘Gusti sing ngongkon lan Gusti sing mbutuhké lan bakal ndang dibalèkké menèh.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Murid loro mau terus budal lan pada nemu kimar enom sing dikentyang nang lawang nang pinggir dalan. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Wong-wong sing ngadek nang kono terus takon: “Lah kok mbok utyuli kimaré, bèn ngapa?” ");
INSERT INTO jvnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Murid loro mau ngomong nèk Gusti sing mbutuhké lan bakal dibalèkké menèh. Wong-wong terus ora ngomong apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kimaré terus digawa nang nggoné Gusti Yésus terus gegeré dilèmèki klambiné. Gusti Yésus terus numpak kimaré. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wong-wong terus pada nggelar klambiné nang dalan lan liyané pada nggawa godongan-godongan sangka kebon terus disebar nang dalan. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wong-wong sing mlaku nang ngarepé lan mburiné Gusti Yésus terus pada surak-surak ngomong: “Hosana! Nampaa berkah sing teka ing jenengé Gusti! ");
INSERT INTO jvnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Langgenga kratoné ratu Daved, leluhuré awaké déwé. Hosana kanggo Gusti Allah nang swarga.” ");
INSERT INTO jvnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tekan Yérusalèm Gusti Yésus terus mlebu nang Gréja Gedé, nyawang sembarang-mbarang nang kono. Dèkné terus budal karo murid rolas nang désa Bétani, awit wis rada surup. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Esuké, dongé lunga sangka Bétani, Gusti Yésus krasa ngelih. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sangka kadohan Dèkné weruh wit anjir sing gembel godongé terus diparani arep ditiliki ènèng wohé apa ora. Kadung tekan wité Gusti Yésus ora nemu apa-apa blas. Namung ènèng godongé, awit durung ungsumé woh. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Murid-muridé terus krungu Gusti Yésus ngomong marang wité: “Wiwit saiki tekan slawasé ora bakal ènèng wong sing mangan wohmu menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Gusti Yésus lan murid-muridé wis tekan Yérusalèm. Nang kono Dèkné arep mlebu nang Gréja Gedé. Nanging nang lataré kono okèh wong sing dodolan lan liyané sing pada tuku. Mulané wong-wong iki terus disenèni lan dikongkon lunga kabèh karo Gusti Yésus. Méja-méjané sing tukang ngijoli duwit lan dingklik-dingkliké sing tukang adol manuk dara diglémpang-glémpangké kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wong-wong sing pada teka nggawa dagangané diendek, ora éntuk liwat lataré gréja menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Gusti Yésus ngomong: “Nang Kitab lak wis ketulis ta! Gusti Allah déwé ngomong ngéné: ‘Omahku iki papan pandonga kanggo kabèh bangsa.’ Nanging kéné saiki mbok dadèkké delikané maling.” ");
INSERT INTO jvnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Para pengarepé imam lan guru Kitab krungu sing diomong karo Gusti Yésus terus pada wedi, awit wong-wong liyané kabèh seneng ngrungokké piwulangé Gusti Yésus. Mulané para imam lan guru Kitab mau pada mikir lan nggolèk akal arep matèni Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kadung wis surup Gusti Yésus lan murid-muridé terus lunga sangka Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Esuké, dongé liwat menèh, terus pada weruh nèk wité malih garing kabèh sak oyot-oyoté. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Rasul Pétrus kélingan nèk Gusti Yésus misuh wité, mulané terus ngomong: “Gusti, delokké iku, wité sing mbok pisuh wingi malih garing.” ");
INSERT INTO jvnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Gusti Yésus terus semaur: “Pada ngandela marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tenan, ngandela ta! Nèk kowé mréntah gunungan iki ngomong: ‘Mumbula lan nibaa nang segara,’ mesti ya bakal klakon tenan, anggeré kowé blas ora mangu-mangu, nanging pretyaya nèk apa sing mbok omong bakal klakon tenan. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mulané Aku ngomong: apa sing mbok jaluk ing pandonga, ngandela nèk kowé wis nampa kuwi, tenan, mesti bakal keturutan. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Lan menèh, nèk kowé ndonga, sapa waé sing nduwé salah karo kowé dingapura. Dadiné Gusti Allah nang swarga ya bakal ngapura salahmu. ( ");
INSERT INTO jvnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nanging nèk kowé ora gelem ngapura liyané, Gusti Allah nang swarga ya ora bakal ngapura kowé.”) ");
INSERT INTO jvnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Gusti Yésus lan murid-muridé pada teka nang Yérusalèm menèh. Dongé Dèkné ijik mlaku-mlaku nang lataré Gréja Gedé terus para pengarepé imam, para guru Kitab lan para penuntuné wong Ju marani Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wong-wong iki takon marang Gusti Yésus: “Sapa sing ngekèki pangwasa marang Kowé kok wani nindakké kaya ngono?” ");
INSERT INTO jvnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Gusti Yésus semaur: “Alon ndisik, sakdurungé Aku semaur, Aku nduwèni pitakonan ndisik marang kowé. Nèk kowé bisa nyauri Aku, kowé ya bakal tak omongi sapa sing ngekèki pangwasa marang Aku! ");
INSERT INTO jvnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sapa sing ngekèki pangwasa Yohanes kanggo mbaptis? Gusti Allah apa manungsa?” ");
INSERT INTO jvnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wong-wong terus pada guneman kepriyé enggoné arep semaur. Awit nèk ngomong: “Gusti Allah,” wong-wong pada wedi nèk Gusti Yésus takon: “Lah kenèng apa dèkné kok ora mbok gugu?” ");
INSERT INTO jvnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nèk pada semaur: “Manungsa,” lah kepriyé, mengko wong-wong pada nesu, awit kabèh pretyaya nèk Yohanes kuwi nabi sangka Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mulané terus pada ngomong: “Embuh ya, awaké déwé ora ngerti!” Gusti Yésus semaur: “Kowé ya ora bakal tak omongi sapa sing ngekèki pangwasa marang Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Gusti Yésus terus mulangi wong-wong mau nganggo tembung gambar ngéné: “Enèng sakwijiné wong nduwé kebon ditanduri dreif. Keboné dipageri mubeng terus wongé nggawé luwangan kanggo meres dreifé. Uga digawèkké omah-omahan sing rada duwur kanggo njaga keboné. Keboné terus diséwakké marang wong-wong liyané. Wongé déwé lunga nang negara liya. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kadung wis wayah panèn sing nduwé kebon ngongkon slafé nang nggoné wong-wong sing nyéwa keboné, njaluk bagèané. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nanging slaf sing dikongkon mau malah dityekel karo sing nyéwa kebon terus digebuki. Sakwisé kuwi slafé terus dikongkon lunga nganggur, ora nggawa apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Sing nduwé kebon terus ngongkon slaf liyané, nanging sing iki uga dipentungi sirahé lan dielok-elokké sak gelemé. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Liyané menèh dikongkon, iki malah dipatèni. Kabèh sing dikongkoni menèh nèk ora dipatèni ya dipentungi. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sing nduwé kebon saiki namung nduwé wong siji sing kenèng dikongkon, yakuwi anaké déwé, sing ditrésnani. Wongé terus ngongkon anaké ngomong ngéné: ‘Menawa waé wong-wong wedi marang kowé, awit kowé anakku déwé!’ ");
INSERT INTO jvnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nanging wong-wong sing nyéwa keboné malah ngomong marang sakpada-pada: ‘Iki anaké sing nduwé kebon. Hayuk dipatèni waé, dadiné keboné wèké awaké déwé.’ ");
INSERT INTO jvnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Anaké mau terus dityekel; kadung wis dipatèni terus diuntyalké nang njabané kebon. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Dipikir déwé jajal. Sing nduwé kebon kudu ngapa saiki? Dèkné mesti bakal budal déwé. Sing nyéwa keboné mesti bakal dipatèni kabèh lan keboné mesti bakal diséwakké wong liya-liyané? ");
INSERT INTO jvnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Apa kowé ora tau matya nang Kitab, ayat sing uniné ngéné: ‘Watu sing dibuwang karo sing tukang nggawé omah, malah watu kuwi sing dadi watu wiwitan. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iki penggawéné Gusti Allah, sing nggumunké banget.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Para penuntuné wong Ju pada rumangsa disemoni karo Gusti Yésus lan wis kudu nyekel Dèkné, nanging pada wedi karo wong okèh liyané. Mulané Gusti Yésus terus diejarké waé, terus pada lunga. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wong-wong terus ènèng sing ngongkon wong Farisi siji-loro lan wong sangka golongané ratu Hérodès nang nggoné Gusti Yésus, supaya ngenèng Dèkné nganggo pitakonan-pitakonan. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kadung wis tekan nggoné Gusti Yésus wong-wong mau ngomong: “Guru, awaké déwé ngerti nèk piwulangmu kuwi bener tenan. Karomenèh Kowé ora wedi sapa-sapa. Kowé nèk mulangi bab dalané Gusti Allah bener lan ènèng wujuté, awit Kowé ora perduli karo sapa-sapa. Mulané awaké déwé kepéngin takon marang Kowé. Nèk miturut agamané awaké déwé kepriyé? Kudu mbayar belasting marang ratuné apa ora?” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nanging Gusti Yésus wis ngerti nèk wong-wong sing takon kuwi namung étok-étok. Mulané Dèkné ngomong: “Kenèng apa kowé kok kepéngin ngenèng Aku? Jajal nggawa duwit rètyèh siji mbréné tak deloké.” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Terus ènèng sing nggawa duwit rètyèh siji. Gusti Yésus terus takon marang wong-wong mau: “Didelok ta! Nang duwit iki ènèng gambaré sapa lan jenengé sapa?” Wong-wong semaur: “Gambaré lan jenengé ratuné Rum!” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Gusti Yésus terus ngomong: “Lah ya wis ta! Apa sing kudu mbok kèkké marang ratuné ya kèkké marang ratuné lan apa sing kudu mbok kèkké marang Gusti Allah ya kèkké marang Gusti Allah.” Wong-wong nggumun krungu saurané Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Enèng wong Saduki siji-loro mara nang nggoné Gusti Yésus. Wong Saduki kuwi ora ngandel nèk wong mati bakal tangi menèh. Wong-wong iki takon marang Gusti Yésus: ");
INSERT INTO jvnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Guru, nabi Moses wis nggawèkké pernatan kanggo awaké déwé ngéné: ‘Nèk ènèng wong lanang mati ninggal randa tanpa anak, seduluré wong lanang sing mati kuwi kudu ngepèk randa mau dadi bojoné lan nggawèkké turunan kanggo seduluré sing mati.’ ");
INSERT INTO jvnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Lah saiki ènèng sedulur lanang-lanang pitu. Sing mbarep ngepèk bojo, nanging kadung mati ora ninggal anak. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sing nomer loro terus ngepèk randané dadi bojoné, nanging sing iki uga mati tanpa nduwé anak. Karo sing nomer telu ya pada waé ngono. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Entèk-entèké sedulur pitu mau kabèh mati, tanpa ninggal turunan siji-sijia. Mbok randané ya terus mati pisan. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Saiki awaké déwé arep takon: lah mbésuk nèk wantyiné wong mati pada tangi menèh, wong wédok mau bakal dadi bojoné sing endi? Awaké déwé takon, awit wong wédok iki wis dadi bojoné sedulur kabèh pitu mau?” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Gusti Yésus semaur: “Kowé kuwi jan klèru banget. Kowé ora dunung isiné Kitab lan kowé blas ora ngerti kwasané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Awit mbésuk nèk wong-wong tangi sangka pati uripé bakalé kaya mulékat swarga, ora ènèng tyarané bebojoan. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lan bab tangi menèh sangka pati, apa kowé ora matya nang kitabé nabi Moses bab grumbulan eri sing murup? Nang kono Gusti Allah lak ngomong ta marang nabi Moses: ‘Aku iki Gusti Allahé Abraham, Gusti Allahé Isak lan Gusti Allahé Yakub.’ ");
INSERT INTO jvnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tegesé Bapa Abraham, Isak lan Yakub kuwi saiki ngabekti marang Gusti Allah. Lah wong sing ngabekti marang Gusti Allah kuwi lak wong urip ta, mosok wong mati? Dadiné Bapa Abraham, Isak lan Yakub kuwi saiki urip menèh. Nèk kowé ora pretyaya kuwi, kowé jan klèru tenan!” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Enèng guru Kitab krungu enggoné wong-wong pada bantah-bantahan lan wong iki nitèni nèk Gusti Yésus sing nyauri wong-wong ya bener tenan. Guru Kitab iki mara nang nggoné Gusti Yésus takon ngéné: “Wèt sing endi sing penting déwé?” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Gusti Yésus semaur: “Wèt sing penting déwé ya iki: ‘Rungokké bangsa Israèl, Gusti Allahé awaké déwé kuwi siji. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Trésnaa marang Gusti Allah sak atimu lan nyawa-ragamu, kapinteranmu lan kekuwatanmu dikanggokna kanggo ngladèni Gusti Allah.’ ");
INSERT INTO jvnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wèt liyané sing penting ya iki: ‘Trésnaa marang tunggal manungsa kaya enggonmu nrésnani awakmu déwé.’ Ora ènèng wèt liyané sing gedéné ngungkuli wèt loro iki.” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Guru Kitab mau semaur: “Kowé bener, Guru. Pantyèn Gusti Allah mung siji, ora ènèng liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pantyèn awaké déwé kudu nrésnani Gusti Allah sak atiné, ing lair lan batin lan karo sakkèhé kekuwatané. Uga kudu trésna marang liyané kaya enggoné nrésnani awaké déwé. Iku pantyèn luwih apik tenimbang mbelèh kéwan lan pawèh liya-liyané marang Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Gusti Yésus weruh nèk guru Kitab iki sing semaur nggenah lan bener, mulané Dèkné terus ngomong marang wongé: “Kowé wis tyedek karo Kratoné Gusti Allah.” Sakwisé kuwi terus ora ènèng sing wani takon apa-apa menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Gusti Yésus dongé mulangi nang Gréja Gedé gentènan takon: “Lah guru-guru Kitab kok ngomong nèk Kristus namung manungsa turunané ratu Daved, dudu Gusti Allah? ");
INSERT INTO jvnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ratu Daved déwé lak wis ngomong ngéné ta, dongé dèkné dikwasani karo Rohé Allah: ‘Gusti Allah wis ngomong ngéné marang Gustiku: Mbrénéa njagong nang tengenku, nganti mungsuhmu wis tak telukké kabèh.’ ");
INSERT INTO jvnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Lah ratu Daved déwé ngarani Kristus kuwi Gusti. Mosok Kristus turunané ratu Daved?” Wong okèh seneng ngrungokké piwulangé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Dèkné uga mulangi wong-wong ngéné: “Pada sing ati-ati karo para guru Kitab. Wong-wong kuwi namung seneng mlaku-mlaku nganggo salin kaya wong sing gedé pangkaté. Nèk nang pasar njaluk digatèkké lan diajèni karo wong liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nèk nang sinaguk apa nang kumpulan pésta njagongé nang ngarep déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pada seneng lan pinter ngrampasi omahé randa-randa terus étok-étoké ndonga suwi kanggo nutupi klakuané. Wong kaya ngono kuwi bakal éntuk setrapan sing luwih abot.” ");
INSERT INTO jvnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Gusti Yésus terus njagong nang ngarepé wadah duwit nang Gréja Gedé kono. Dèkné ndelokké wong-wong sing pada nglebokké pawèhé. Okèh wong sugih pada nglebokké duwité. Wong-wong iki pawèhé ya ora setitik. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Terus ènèng randa mlarat nglebokké rètyèh loro sing tyilik banget ajiné. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Gusti Yésus terus nyeluk murid-muridé diomongi ngéné: “Pada ngertia, kanggo Gusti Allah randa mlarat iku pawèh sing okèh déwé tenimbang liya-liyané. ");
INSERT INTO jvnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Awit wong sing sugih ngekèki sangka kasugihané, nanging randa iku ngekèki sangka kemlaratané.” ");
INSERT INTO jvnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dongé Gusti Yésus metu sangka Gréja Gedé terus ènèng murid sing ngomong marang Dèkné: “Guru, delokké ta, gréjané kuwi jan nggumunké tenan apiké. Delokké watu-watuné gedéné!” ");
INSERT INTO jvnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Gusti Yésus semaur: “Kowé weruh Gréja Gedé iki ta? Bakalé ora ènèng watu siji waé temumpang liyané. Kabèh bakal ambruk rata lemah.” ");
INSERT INTO jvnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Gusti Yésus terus njagong nang gunung Olèf, adep-adepan karo Gréja Gedé. Nang kono rasul Pétrus, Yakobus, Yohanes lan Andréas terus mara lan takon: ");
INSERT INTO jvnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gusti, kapan sembarang-mbarang kuwi bakal klakon lan kepriyé awaké déwé bisané ngerti nèk wis tekan wantyiné? Apa tandané?” ");
INSERT INTO jvnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Gusti Yésus terus ngomong ngéné: “Pada sing ati-ati. Aja sampèk kowé diapusi lan disasarké wong. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Okèh wong bakal teka nganggo jenengku ngomong: ‘Ya aku iki Kristus!’ Okèh wong sing bakal diapusi. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nèk kowé krungu ènèng perangan lan kabar-kabar nèk bakal ènèng perangan, aja pada kagèt. Kuwi kabèh kudu klakon, nanging iku durung entèk-entèkané. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Awit bangsa sing siji bakal nglawan bangsa liyané lan negara sing siji bakal perang nglawan negara liyané. Uga bakal ènèng lindu lan kekurangan pangan nang pirang-pirang panggonan. Nanging kuwi ijik wiwitané waé, kaya wong wédok nèk nglarani kaé nèk arep mbayi. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Pada sing ati-ati. Awit kowé bakal disèrèt nang ngarep kruton lan bakal dipentungi nang sinaguk. Kowé bakal digawa nang ngarepé gramang lan ratu kongkon ngekèki paseksi kanggo Aku. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pantyèn, kabar kabungahané Gusti Allah kudu digelarké ndisik marang saben bangsa. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nèk kowé dityekel lan digawa nang ngarep kruton, aja pada bingung bab sing kudu mbok omong; Roh Sutyi déwé sing bakal ngekèki tembung ing atimu ing wantyi kuwi. Kuwi sing kudu mbok omongké. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sedulur bakal ngandakké seduluré déwé lan bapak bakal ngandakké anaké déwé supaya dipatèni. Anak-anak bakal nglawan lan ngandakké wong tuwané supaya dipatèni. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wong kabèh bakal nyengiti kowé jalaran kowé nurut aku. Nanging sapa sing mantep terus tekan entèk-entèkané, kuwi sing bakal slamet.” ");
INSERT INTO jvnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Gusti Yésus neruské tembungé: “Kowé bakal weruh nggegilané karusakan nang panggonan sing dudu panggonané. (Sing pada matya iki mikira sing apik supaya bisa dunung.) Wong-wong sing nang Yudéa mblayua nang gunung-gunung, supaya kowé aja sampèk dipatèni. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wong-wong sing nang nduwur omah aja pada medun. Aja pada mlebu njikuk apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sing ijik nang kebon, aja mulih njikuk salin. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Melaské banget bakalé wayah kuwi kanggo wong sing meteng lan sing nduwé bayi. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ndongaa supaya sembarang iki aja sampèk tiba wayahé adem gedé. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Awit bakal ènèng kasusahan gedé banget. Kawit Gusti Allah nggawé jagat iki tekané saiki durung tau ènèng kasangsaran kaya ngono gedéné lan sakwisé kuwi ya ora bakal ènèng liyané sing ngungkuli kuwi gedéné. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Semunggoné kasusahan kuwi ora dityekakké karo Gusti Allah, mesti ya ora bakal ènèng wong siji waé sing slamet. Nanging jalaran melas marang wong-wong sing wis dipilih, Gusti Allah nyekakké wayah kasangsaran kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Lan nèk ènèng wong ngomong: ‘Ya iki Kristus,’ apa ‘ya kaé Kristus,’ aja pada ngandel. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Awit okèh wong bakal teka ngomong: ‘Aku iki Kristus,’ apa ‘Aku iki kongkonané Gusti Allah,’ nanging wujuté dudu lan namung ngapusi. Wong-wong kuwi bakal nggawé tanda-tanda lan mujijat-mujijat. Tujuané namung kanggo nyasarké kowé. Semunggoné bisa ngono ya arep nyasarké wong-wong sing wis dipilih karo Gusti Allah mbarang. Nanging ora bisa. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mulané pada sing awas lan ati-ati, awit kowé wis tak omongi sakdurungé bab sembarang-mbarang kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Gusti Yésus ngomong: “Sakwisé waktu kasusahan gedé kuwi, srengéngé bakal malih peteng lan mbulané ora bakal semlorot menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Lintang-lintang bakal tiba sangka langit lan pangwasa-pangwasa nang langit bakal hoyak kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Sakwisé kuwi kabèh Anaké Manungsa bakal ngétok nang méga. Kabèh bakal weruh gedéné kwasané sing semlorot nganggo pepadangé swarga. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dèkné bakal ngongkon mulékat-mulékaté nglumpukké wong-wong sing wis dipilih, sangka wétan, kulon, lor lan kidul, sangka entèk-entèkané bumi lan entèk-entèkané langit.” ");
INSERT INTO jvnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Gusti Yésus nutup tembungé ngéné: “Mbok dititèni wit anjir kaé. Nèk pangé molai ijo lan memes lan metu godongé, kowé ngerti nèk wayah panas wis tyedek. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kaya ngono uga, nèk kowé weruh kabèh sing tak omong mau molai klakon, ngertia nèk wis tyedek banget wantyiné enggonku bakal teka. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pada dititèni! Kowé bakal menangi kabèh iki klakon. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Langit lan bumi iki bakal ilang, nanging tembungku bakal ènèng terus, slawas-lawasé. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nanging yakuwi, bab kapan bakalé klakon, ora ènèng wong ngerti. Mulékat-mulékat nang swarga ya ora ngerti lan Anaké Gusti Allah ya ora ngerti. Sing ngerti namung Gusti Allah Bapaké. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mulané, pada sing awas lan sing ati-ati, awit kowé ora ngerti kapan bakalé klakon. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kenèng tak padakké karo wong nèk arep lunga adoh kaé. Dèkné lunga lan sembarangé dipasrahké marang para peladèné. Kabèh dipréntah lan dikèki bagèan déwé-déwé. Uga sing jaga lawang dipréntah kongkon melèk aja sampèk ngantuk. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mulané, pada melèka lan sing awas, awit kowé ora ngerti kapan sing nduwé omah mau bakalé teka, wayah soré, tengah wengi, wayah jago kluruk, apa wayah ésuk. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aja sampèk, nèk dèkné teka dadakan, terus nemu kowé ijik turu. ");
INSERT INTO jvnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mulané saiki Aku ngomong marang kowé kabèh: ‘Pada melèka lan sing jaga-jaga.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rong dina menèh wis wayahé Paskah. Ing dina Paskah kuwi wong Ju pada mangan roti sing ora ènèng raginé. Para pengarepé imam lan para guru Kitab pada nggolèk akal enggoné arep nyekel lan matèni Gusti Yésus, tanpa wong-wong ngerti. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mulané pada ngomong: “Aja wayahé Paskah, mengko ndak marakké ramé lan gègèran.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Gusti Yésus saiki nang désa Bétani, merdayoh nang omahé Simon sing mauné lara lépra. Dongé Gusti Yésus ijik jagongan ènèng wong wédok teka nggawa botol isiné lenga wangi tus sing larang banget regané. Lenga wangi iki sing digawé oyot-oyoté tanduran nardus. Botolé terus dipetyah guluné lan isiné diesokké nang sirahé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wong-wong terus ènèng sing rasan-rasan: “Lah apa jawané lenga wangi larang-larang kok diebrèh-ebrèh ngono? ");
INSERT INTO jvnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Semunggoné diedol lak payu okèh ta? Duwité lak ya kenèng dikèkké wong ora nduwé ta?” Wong-wong iki terus nyenèni wong wédoké. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nanging Gusti Yésus ngomong: “Bèn, mbok diejarké! Kenèng apa kok mbok penging? Wong wédok iki nindakké barang sing apik banget marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wong mlarat slawasé ènèng waé lan sak wantyi-wantyi nèk kowé kepéngin nulungi kowé bisa. Nanging Aku iki ora slawasé tyampur kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wong wédok iki nindakké sak bisané kanggo nduduhké katrésnané marang Aku. Dèkné interé namung nglengani awakku karo lenga wangi, sakdurungé Aku dikubur. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Dititèni ta, nang endi waé ing donya kéné sing bakal digelari kabar kabungahané Gusti Allah bakal krungu uga bab sing ditindakké karo wong wédok iki, kanggo pengéling-éling marang dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sangka muridé Gusti Yésus sing rolas terus ènèng siji sing budal nang nggoné para pengarepé imam arep ngelungké Dèkné marang wong-wong kuwi, yakuwi Yudas Iskariot. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wong-wong kadung krungu kuwi terus pada bungah banget lan saguh ngekèki duwit. Saiki Yudas molai nggolèk kelunggaran enggoné arep ngelungké Gusti Yésus marang para pengarepé imam mau. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Saiki wis wayahé Riyaya Roti Tanpa Ragi. Ing dina sing ndisik déwé wong-wong lumrahé mbelèh tyempé. Ing dina iku murid-muridé takon marang Gusti Yésus: “Gusti, Kowé arep mangan Paskah nang endi? Dadiné awaké déwé bisa tata-tata!” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Gusti Yésus terus ngongkon murid loro. Dèkné ngomong: “Kana mlebu nang Yérusalèm. Nang dalan kowé bakal kepetuk wong lanang nggawa kendi isiné banyu. Kowé pada mèlua wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nèk kowé wis tekan omahé, ngomong karo sing nduwé omah ngéné: ‘Guruné nakokké kamar sing arep dienggo mangan Paskah karo murid-muridé.’ ");
INSERT INTO jvnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wongé mengko terus nggawa kowé nang kamar gedé nang nduwur sing wis ditata. Kana sing arep dipangan dityawis-tyawiské nang kono.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Muridé mau terus pada budal nang Yérusalèm, terus kepetuk wongé, kaya sing diomong karo Gusti Yésus mau. Nang kono terus pada nyawiské panganan Paskah. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mbenginé kuwi Gusti Yésus teka karo murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dongé pada jejagongan mangan Gusti Yésus terus ngomong: “Aku ngomong, ènèng siji bakal ngelungké Aku marang mungsuhé. Siji sing mangan tyampur karo Aku iki.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Murid-muridé terus kagèt lan sedi. Terus pada gentèn takon marang Gusti Yésus: “Mosok aku ta, Gusti?” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Gusti Yésus semaur: “Ya siji tunggalé kowé wong rolas kuwi waé, sing mèlu nyelupké rotiné nang mangkok. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pantyèn, Anaké Manungsa kudu mati. Kuwi wis ketulis kawit jaman mbiyèn. Nanging tyilaka tenan wong sing ngelungké Anaké Manungsa marang mungsuhé. Wong kuwi luwung ora lair waé mauné.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Dongé pada jejagongan mangan Gusti Yésus terus njikuk roti lan sakwisé didongakké terus dityuwil-tyuwil dikèkké marang murid-muridé. Dèkné ngomong: “Pada dipangan. Roti iki badanku.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Gusti Yésus terus njikuk ombèné. Sakwisé maturkesuwun marang Gusti Allah ombèné terus dielungké marang murid-muridé. Kabèh mèlu ngombé. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Gusti Yésus ngomong marang murid-muridé: “Iki getihku sing mili kanggo wong okèh. Getih iki tandané nèk Gusti Allah nggawé prejanjian anyar karo kowé. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tenan, Aku ngomong, Aku ora bakal ngombé anggur iki menèh tekané Aku ngombé anggur sing anyar mbésuk nang swarga.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sakwisé kuwi terus pada singi-singi maturkesuwun lan ngluhurké Gusti Allah, terus pada budal nang gunung Olèf. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Gusti Yésus ngomong marang murid-muridé: “Kowé bakal pada semplak pengandelmu lan bakal ninggal Aku, kaya sing wis ketulis nang kitabé nabi Sakarias, nèk Gusti Allah bakal matèni sing tukang angon lan wedusé bakal pada buyar kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nanging nèk Aku wis ditangèkké sangka pati, Aku bakal budal nang Galiléa, ndisiki kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Rasul Pétrus semaur: “Ora Gusti, senajan liyané ninggal Kowé, aku ora bakal ninggal Kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Gusti Yésus terus ngomong marang rasul Pétrus: “Titènana déwé, wengi iki waé, sakdurungé jago kluruk ping pindo, kowé bakal ngengkeng sampèk ping telu nèk ora kenal Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Rasul Pétrus terus semaur menèh: “Ora Gusti, tenan, ora pisan-pisan aku bakal nglakoni kaya ngono. Senajan aku kudu mati bareng karo Kowé, tak lakoni, nanging aku ora bakal nyélaki Kowé.” Murid-murid liyané uga ngomong ngono. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gusti Yésus lan murid-muridé terus budal nang panggonan sing jenengé Gètsémané. Dèkné ngomong marang murid-muridé: “Kowé ngentèni nang kéné waé. Aku arep ndonga.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Rasul Pétrus, Yakobus lan Yohanes diejèk karo Gusti Yésus. Nang kono Gusti Yésus molai krasa wedi lan susah banget. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dèkné ngomong: “Atiku jan sedi banget. Rasané kaya arep mati. Kowé nang kéné waé lan aja turu.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Gusti Yésus terus rada ngedohi murid-muridé kuwi, terus niba nang lemah lan ndonga marang Gusti Allah. Dèkné nyuwun, nèk bisa, Dèkné ora usah ngalami wantyi kasangsaran kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tembungé: “Duh Bapakku, Kowé bisa sembarang. Mbok kasangsaran iki disingkirké sangka Aku! Nanging senajan abot, Aku kepéngin nglakoni karepmu, ora karepku déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Gusti Yésus terus balik menèh lan nemu muridé sing telu mau ijik turu. Dèkné terus ngomong marang rasul Pétrus: “Simon, lah kowé kok turu. Mosok ora bisa melèk sak jam? ");
INSERT INTO jvnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pada melèka lan pada ndedongaa supaya ora pada kalah nèk Sétan nyoba. Pantyèn, atiné karep, nanging awaké ora kuwat.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Gusti Yésus terus ninggal murid-muridé terus budal ndonga menèh. Sing disuwun ya tunggalé, kaya sing ndisik. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kadung balik menèh murid-muridé ijik turu, awit pada ngantuk tenan. Murid-muridé kadung tangi ora wani ngomong apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ping teluné, dongé Gusti Yésus balik menèh sangka ndedonga, Dèkné ngomong marang murid-muridé: “Ijik pada énak-énak turu waé? Wis, saiki wis tekan wantyiné enggoné Anaké Manungsa bakal dielungké marang wong ala. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pada tangi, hayuk budal. Delokké, sing arep ngelungké Aku marang mungsuhé wis teka!” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Gusti Yésus durung sampèk rampung sing ngomong kuwi terus Yudas teka karo wong okèh, pada nggawa pedang lan pentung. Yudas muridé Gusti Yésus déwé, tunggalé murid sing rolas. Yudas lan wong-wong mau dikongkon karo para pengarepé imam, guru Kitab lan pengarepé wong Ju. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas wis nggawé tanda karo wong-wong kuwi ngomong: “Wong sing tak ambung, yakuwi wongé. Dityekel terus digawa lunga lan dijaga sing apik!” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kadung wis tekan kono Yudas terusan marani Gusti Yésus, terus ngomong: “Guru!” Sakwisé ngomong ngono dèkné terus ngambung Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Gusti Yésus terus dityekel karo wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nanging ènèng murid siji narik pedangé lan ngantem kupingé slafé Imam Gedé sampèk tyepol. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Gusti Yésus ngomong marang wong-wong mau: “Apa Aku iki wong nakal kok kowé marani Aku nggawa pedang lan pentung. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Saben dina Aku tyampur karo kowé nang Gréja Gedé nèk Aku mulangi. Lah kok ora pada nyekel Aku? Nanging pantyèn ya wis kudu klakon ngéné, kaya sing wis ketulis nang Kitab.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Murid-muridé terus pada mblayu lunga, Gusti Yésus ditinggal déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Enèng botyah enom mèlu Gusti Yésus. Botyah enom iki namung nganggo salin mori. Botyah iki dityekel karo wong-wong, nanging namung kenèng saliné, botyahé mblayu ora nganggo apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Gusti Yésus terus digawa nang ngarepé Imam Gedé. Para pengarepé imam, para guru Kitab lan para pengarepé bangsa Ju terus ngumpul kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Rasul Pétrus ngetutké Gusti Yésus sangka kadohan sampèk mlebu tekan lataré omahé Imam Gedé. Nang kono rasul Pétrus terus njagong nang bediyangan nggolèk anget tyampur karo wong-wong sing njaga panggonan kono. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Para pengarepé imam lan wong-wong sing tukang ngrutu pada nggolèk seksi, supaya bisa nemu jalaran kanggo nyalahké lan matèni Gusti Yésus, nanging ora nemu siji-sijia. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pantyèn okèh sing dadi seksi nyalahké Gusti Yésus, nanging tembungé ora tyotyok. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Enèng sing nyalahké Gusti Yésus ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Awaké déwé krungu Dèkné ngomong nèk bakal mbubrah Gréja Gedé gawéané manungsa iki lan omongé dèkné bisa ngedekké liyané sakjeroné telung dina, sing dudu gawéané manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nanging seksi iki ya pada waé ora tyotyok karo liya-liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Imam Gedé terus ngadek lan maju nang tengahé wong-wong terus nakoni Gusti Yésus: “Lah kowé saiki arep ngomong apa? Tembungé wong-wong kuwi bener apa ora?” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nanging Gusti Yésus meneng waé, ora semaur apa-apa. Imamé terus takon menèh: “Apa kowé kuwi Kristus? Apa kowé Anaké Gusti Allah sing Sutyi Déwé?” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Gusti Yésus semaur: “Pantyèn, ya Aku iki. Kowé bakal weruh Anaké Manungsa njagong nang tengené Gusti Allah sing Kwasa Déwé. Kowé bakal weruh Dèkné teka nang mégané langit.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Imam Gedé krungu Gusti Yésus ngomong ngono terus nesu lan nyuwèk saliné ngomong: “Awaké déwé wis ora mbutuhké seksi menèh. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kowé kabèh wis krungu déwé Dèkné ngèlèk-èlèkké Gusti Allah. Kepriyé pinemumu kabèh?” Kabèh pada nyalahké Gusti Yésus lan pada setuju nèk Dèkné kudu dipatèni. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Enèng sing pada ngidoni lan nutupi rainé Gusti Yésus terus diantemi karo ngomong: “Mbedèk jajal, sapa sing ngantemi Kowé!” Sing jaga mbarang mèlu ngantemi Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dongé rasul Pétrus ijik nang lataré kono, nang ngisor, terus ènèng slaf wédok teka, slafé Imam Gedé. ");
INSERT INTO jvnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Dèkné weruh rasul Pétrus njagong nang bediyangan terus ngematké lan ngomong: “Kowé mbarang tau mèlu Yésus, wong Nasarèt kaé.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nanging rasul Pétrus ora ngaku, malah ngèngkèl ngomong: “Kowé kuwi ngomongké apa ta? Aku ora ngerti apa sing mbok omong kuwi.” Rasul Pétrus terus mlaku metu tekan lawang njaba. (Terus ènèng jago kluruk.) ");
INSERT INTO jvnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nang kono slaf wédok mau weruh dèkné menèh terus ngomong karo wong liya-liyané: “Wong iki tunggalé sing mèlu Yésus.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nanging sepisan menèh rasul Pétrus ora ngaku. Ora let suwi wong-wong sing nang kono ngomong marang rasul Pétrus: “Pantyèn tenan, kowé tunggalé muridé Yésus, awit ketara nèk kowé wong sangka Galiléa.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Rasul Pétrus terus sumpah: “Aku jan ora kenal blas karo wong sing mbok omongké kuwi. Nèk Aku goroh aku gelem mati.” ");
INSERT INTO jvnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sakwisé rasul Pétrus ngomong ngono kuwi, terus ènèng jago kluruk ping pindoné. Rasul Pétrus sakwat kélingan nèk Gusti Yésus ngomong: “Sakdurungé jagoné kluruk ping pindo kowé bakal ngomong ping telu nèk ora kenal Aku.” Rasul Pétrus terus nangis kelara-lara. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Esuké mruput para warga Kruton Agama pada ngumpul nggawé putusan; kuwi para pengarepé imam, para pengarepé bangsa Ju lan para guru Kitab. Gusti Yésus terus dibanda digawa nang nggoné gramang Pilatus. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus takon marang Gusti Yésus: “Apa kowé ratuné bangsa Ju?” Gusti Yésus semaur: “Pantyèn bener sing mbok omong kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Para pengarepé imam terus pada nyalahké Gusti Yésus bab pirang-pirang prekara. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatus terus takon menèh: “Mosok Kowé ora semaur apa-apa? Delokké, wong-wong pada nyalahké Kowé. Lah Kowé ngaku apa ora?” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nanging Gusti Yésus blas ora semaur apa-apa, marakké Pilatus nggumun tenan. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lumrahé saben taun, nèk wayahé riyaya Paskah, gramang Pilatus ngetokké wong setrapan siji. Wong-wong dililani milih déwé sapa. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Saiki nang setrapan kono ènèng wong pembruntakan sing pada disetrap. Enèng siji sing jenengé Barabas, sing matèni wong dongé ènèng rerusuh. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wong okèh teka nang nggoné gramang Pilatus njaluk setrapan siji dietokké. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatus semaur marang wong-wong: “Semunggoné Yésus, ratuné bangsa Ju, tak etokké, kowé gelem apa ora?” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatus takon iki, awit dèkné wis nitèni nèk para pengarepé imam kuwi ora seneng marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nanging para pengarepé imam pada ngojok-ojoki wong-wong supaya pada njaluk Barabas sing dietokké. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus terus semaur menèh: “Lah aku kongkon ngapakké karo Yésus, sing mbok arani ratuné bangsa Ju!” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wong-wong terus pada mbengok: “Dipentèng, Yésus kudu dipentèng!” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatus takon: “Lah apa salahé Dèkné?” Nanging wong-wong malah pada mbengok luwih banter: “Dipentèng!” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Supaya wong-wong pada lega, Barabas terus dietokké. Pilatus terus mréntah kongkon metyuti lan mentèng Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Para soldat terus nggawa Gusti Yésus mlebu nang lataré kruton terus nyeluk liya-liyané kongkon pada nglumpuk. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Gusti Yésus terus dienggoni salin abang lan sirahé dipasang makuta gawéan eri. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sakwisé kuwi terus pada mbagèkké Dèkné ngomong: “Slamet ratuné bangsa Ju!” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Gusti Yésus terus dipentungi sirahé lan diidoni. Soldat-soldat mau terus sedeku, étok-étoké nyembah Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kadung wis marem enggoné nggawé sembrana marang Gusti Yésus, saliné abang mau terus dityepot menèh lan saliné déwé dienggokké, terus digawa lunga arep dipentèng. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ing wantyi kuwi ènèng wong mulih sangka kebon liwat kono. Wong iki jenengé Simon, bapaké Alèksander lan Rufus, mbiyèn manggoné nang kuta Siréné. Simon dipeksa kongkon manggul kayu sing arep dienggo mentèng Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gusti Yésus terus digawa nang panggonan sing jenengé Golgota. Golgota kuwi tegesé: endasé wong mati. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nang kono Gusti Yésus dikèki anggur dityampur mur kongkon ngombé, nanging Dèkné ora gelem. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Gusti Yésus terus dipentèng lan saliné diedum nganggo lotré, dadiné ngerti bagèané déwé-déwé. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Gusti Yésus dipentèng jam sanga ésuk. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kayu sing dienggo mentèng dikèki tulisan ngéné: “Ratuné bangsa Ju.” Ya tembung iki sing dienggo nyalahké Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bareng karo Gusti Yésus uga ènèng wong ala loro dipentèng. Siji nang sebelah tengen lan liyané nang sebelah kiwa. ( ");
INSERT INTO jvnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dadiné keturutan tenan sing ketulis nang Kitab: “Dèkné didadèkké siji karo wong ala!”) ");
INSERT INTO jvnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wong-wong sing liwat kono pada moyoki Dèkné. Pada gèdèk-gèdèk lan muni: “Rasakna saiki! Jaréné Kowé arep mbubrah Gréja Gedé lan arep mbok dekné menèh sakjeroné telung dina. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jajal tulungana awakmu déwé? Meduna sangka pentèngan kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Para pengarepé imam lan para guru Kitab uga pada moyoki lan ngomong marang sakpada-pada: “Jaréné bisa nulungi wong liyané, lah awaké Dèkné déwé kok ora bisa nulungi? ");
INSERT INTO jvnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jaréné Dèkné Kristus, ratuné Israèl. Jajal medun sangka pentèngan kono, dadiné awaké déwé bisa weruh lan pretyaya.” Wong-wong sing disalib bareng karo Gusti Yésus uga mèlu moyoki. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wiwit jam rolas awan sak negara malih peteng, telung jam suwéné. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ing wayah jam telu Gusti Yésus mbengok banter: “Eloi, Eloi, lamah sabaktani?” Nèk tyara Jawa: “Duh Allahku, kenèng apa Aku kok mbok tinggal?” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wong liwat sing krungu kuwi ngomong: “Rungokké ta, Dèkné nyeluk nabi Elia.” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Enèng siji njikuk spons dietylupké nang anggur terus disundukké putyuké kayu dawa terus dikèkké Gusti Yésus kongkon nyutyup. Wongé ngomong: “Hayuk dientèni. Awaké déwé kepéngin ngerti nabi Elia nulungi Dèkné apa ora.” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nanging Gusti Yésus malah mbengok banter terus ninggal. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kordèn tutupé kamar sing sutyi déwé nang Gréja Gedé terus suwèk dadi loro, sangka nduwur mengisor. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Penggedéné soldat sing jaga nang ngarepé kayu pentèngan kono weruh ninggalé Gusti Yésus. Dèkné ngomong: “Wong iki pantyèn Anaké Gusti Allah tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nang kono uga ènèng wong wédok-wédok sing nyawang lelakon mau sangka kadohan. Kayadéné Maria Makdaléna, Salum lan Maria, ibuné Yakobus Tyilik lan Yoses. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wong wédok-wédok iki pada mèlu lan ngladèni Gusti Yésus dongé Dèkné ijik nang Galiléa. Nanging uga ènèng wong wédok-wédok liyané sing teka nang Yérusalèm bareng karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ing dina kuwi, dina jemuah, wong Ju pada tata-tata kanggo dina sabat. Soréné kuwi ènèng wong nang nggoné gramang Pilatus nembung layoné Gusti Yésus. Wong iki jenengé Yosèf, mbiyèné sangka kuta Arimatéa. Dèkné wargané Kruton Agama, mulané ya diajèni banget karo wong liyané. Yosèf uga ngarep-arep tekané Kratoné Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus déwé nggumun krungu nèk Gusti Yésus wis ninggal, mulané dèkné nyeluk penggedéné soldat sing jaga ditakoni apa ninggalé Gusti Yésus wis suwi. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sakwisé Pilatus krungu déwé sangka soldat mau nèk Gusti Yésus wis ninggal tenan, layoné terus dipasrahké marang Yosèf. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosèf terus tuku mori. Gusti Yésus diedunké sangka kayuné, terus dibuntel mori didèkèk nang kuburané. Kuburané kuwi guwa gawéan nang gunungan watu. Yosèf terus ngglundungké watu kanggo nutup lawangé guwa kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdaléna lan Maria ibuné Yoses uga weruh panggonané sing dienggo ngglétakké layoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kadung dina sabat wis kliwat, Maria Makdaléna, Maria ibuné Yakobus lan Salum pada tuku lenga wangi kanggo nglengani layoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dina mingguné, ésuk mruput, wayahé srengéngé njedul, wong wédok-wédok iki terus budal nang kuburan. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nang dalan pada rasan-rasan: “Mengko sapa ya sing ngréwangi ngglundungké watu tutup kuburané?” Awit watuné gedé banget. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nanging kadung wis tekan kuburané, wong-wong weruh nèk watuné wis diglundungké. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wong-wong terus mlebu, nanging pada kagèt, awit weruh wong enom njagong nang sebelah tengené. Saliné wongé putih. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wongé ngomong: “Aja pada kagèt. Aku ngerti nèk kowé nggolèki Yésus, wong Nasarèt sing dipentèng. Dèkné wis ora nang kéné, awit wis tangi. Delokké déwé, mauné wongé didèlèh nang kéné ta? ");
INSERT INTO jvnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kana saiki pada balik waé. Murid-muridé diomongi lan aja lali ngomongi rasul Pétrus. Diomongi nèk Gusti Yésus wis budal ndisik nang Galiléa. Nang kana bakal pada kepetuk Dèkné, kaya sing wis diomong sakdurungé Dèkné ninggal.” ");
INSERT INTO jvnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wong wédok-wédok mau terus mblayu metu karo ndredek lan bingung. Sangking wediné terus ora ngomongi liya-liyané. ( ");
INSERT INTO jvnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sakwisé Gusti Yésus tangi sangka pati ing dina minggu ésuk, dèkné ndisik déwé ngétok marang Maria Makdaléna, wong wédok sing mauné diluwari sangka demit pitu. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria Makdaléna terus ngabari murid-muridé sing ijik pada sedi lan pada nangis. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nanging kadung diomongi nèk Gusti Yésus urip menèh lan ngétok marang dèkné, murid-muridé malah ora pada ngandel. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Gusti Yésus terus ngétok marang murid loro, dongé ijik pada mlaku arep nang sakwijiné désa. Gusti Yésus ngétok nganggo rupa liya. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Murid loro mau terus balik ngomongi liya-liyané, nanging ora pada ngandel. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ora let suwi Gusti Yésus terus ngétok marang murid sing sewelas, dongé ijik pada mangan. Dèkné nyenèni murid-murid mau, awit ora pada gelem ngandel marang omongané wong-wong sing wis pada weruh Dèkné, sakwisé tangi menèh sangka pati. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Gusti Yésus mréntah murid-muridé ngéné: “Kana pada lunga nggelarké kabar kabungahané Gusti Allah marang saben wong nang sak lumahé jagat. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sapa sing pretyaya lan dibaptis bakal slamet, nanging sing ora gelem pretyaya bakal disetrap. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sing pada pretyaya bakal tak kèki tanda, yakuwi, bakal bisa ngetokké demit nganggo jenengku lan bakal ngetokké basa anyar. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Senajan nyekel ula lan senajan ngombé ratyun ora bakal masah. Bakal numpangi tangan marang wong lara lan sing lara bakal mari.” ");
INSERT INTO jvnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sakwisé Gusti Yésus ngomong kuwi kabèh marang murid-muridé, Dèkné terus mumbul munggah nang swarga. Nang kana Dèkné njagong nang tengené Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Murid-muridé terus budal nggelar kabar kabungahané Gusti Allah nang endi-endi. Gusti déwé ya ngréwangi lan ngétokké kwasané nganggo mujijat-mujijat. Dadiné wong-wong nitèni déwé nèk tembungé murid-muridé pantyèn pituturé Gusti Allah tenan.)");
INSERT INTO jvnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Sedulurku Téofilus sing tak ajèni, iki layang sangka nggonku, Lukas. Pantyèn ya wis ènèng wong pirang-pirang sing nulis bab lelakon-lelakon sing kedadéan nang tengahé awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kuwi mau kabèh miturut omongané wong-wong sing pada weruh déwé kawit wiwitané, terus pada nggelarké kabar kabungahan kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mulané aku déwé ya terus mikir nulis bab prekara iki kanggo kowé. Sakdurungé tak tulis, lelakon-lelakon mau kabèh tak titipriksa ndisik, terus tak tata. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Dadiné kenèng dititèni déwé nèk pitutur sing diwulangké marang sedulur Téofilus kuwi kenèng dipretyaya kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dongé Hérodès ijik dadi ratu nang distrik Yudéa, ènèng sakwijiné imam sing jenengé Sakarias, sangka golongané imam Abia. Bojoné imam Sakarias jenengé Elisabèt. Ibu Elisabèt iki turunané imam Aron. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wong loro iki temen enggoné nuruti kekarepané Gusti Allah, awit pada temen nglakoni angger-angger lan pernatané Gusti Allah sak kabèhé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Imam Sakarias lan ibu Elisabèt ora nduwé anak, awit ibu Elisabèt ora bisa nduwé anak. Karomenèh wong loro iki ya wis tuwa banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ing sakwijiné dina imam Sakarias nglakoni kerjanané nang Gréja Gedé kono, awit wis tiba wantyiné golongané dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lah saiki imam Sakarias sing kudu mlebu nang Panggonan Sutyi, kudu ngobong menyan. Kuwi sing ngarani nganggo lotré. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ing wantyi kuwi, dongé menyané diobong, nang njaba ènèng wong pirang-pirang pada ndedonga. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Lah dadakan waé kok terus ènèng mulékat ngétok marang imam Sakarias. Mulékaté ngadek nang sebelah tengené altar sing dienggo ngobong menyan. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Imam Sakarias weruh mulékaté terus kagèt lan wedi banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nanging mulékaté ngomong: “Aja wedi, Sakarias! Pandongamu wis ketampa lan Elisabèt, bojomu, bakal mbayi anak lanang. Botyahé kudu mbok jenengké Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kowé bakal bungah banget lan wong okèh bakal bungah nèk botyah iki lair. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Botyah iki bakal dadi wong sing gedé ajiné kanggo Gusti Allah, mulané dèkné ora kenèng ngombé anggur apa ombèn liyané sing marakké mendem. Wiwit sangka wetengé ibuné botyah iki bakal kebek karo Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mbésuk dèkné bakal nuntun wong Israèl, supaya pada manut menèh marang Gusti Allahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anakmu iku bakal dadi kongkonané Gusti Allah lan ing roh lan pangwasa dèkné tunggalé waé karo nabi Elia. Dèkné bakal ngrukunké bapak karo anaké lan wong sing ora manut marang Gusti Allah bakal katuntun malih manut. Dadiné dèkné bisa nyawiské umat sing pantes kanggo Gusti.” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Imam Sakarias terus semaur: “Kepriyé aku bisané ngerti nèk tembungé Gusti kuwi bakal klakon tenan, awit aku déwé wis tuwa, semono uga bojoku?” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mulékaté terus ngomong: “Aku iki Gabrièl sing ngladèni Gusti Allah nang ngarepé. Aku dikongkon nggawa kabar kabungahan iki marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Apa sing tak omong iki mesti bakal klakon ing waktu sing wis ditengeri karo Gusti Allah. Nanging kowé bakal dadi bisu tekan waktu kuwi, awit kowé ora ngandel marang tembungku.” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wong-wong sing ngentèni nang njaba pada nggumun imam Sakarias kok suwi temen nang njero Panggonan Sutyi kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kadung metu, imam Sakarias ora bisa ngomong apa-apa, namung njajal ndunung-ndunungké nganggo tangané. Wong-wong terus ngerti nèk imam Sakarias entas dikétoki ing njero Panggonan Sutyi kono. Dèkné ya bisu terus. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakwisé rampung enggoné nglakoni kerjanané nang Gréja Gedé ing minggu kuwi, imam Sakarias terus mulih. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ora let suwi ibu Elisabèt, bojoné, terus meteng. Limang sasi suwéné ibu Elisabèt ora metu sangka omahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Dèkné ngomong: “Saiki Gusti Allah nulung aku tenan. Saiki Dèkné wis ngilangké isinku, aku wis ora usah isin menèh marang wong-wong.” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kadung ibu Elisabèt wis meteng nem sasi, Gusti Allah terus ngongkon mulékat Gabrièl teka nang kuta Nasarèt nang distrik Galiléa. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mulékat Gabrièl dikongkon metuki sakwijiné prawan sing jenengé Maria. Maria iki patyangané Yosèf, turunané ratu Daved. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kadung Gabrièl wis nemu Maria, dèkné ngomong ngéné: “Maria, kowé pantyèn diberkahi tenan karo Gusti, awit Dèkné miji kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Krungu tembungé mulékat kuwi mau Maria kagèt banget, terus mikir ing ati: “Apa ta tegesé tembung kuwi?” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mulékaté terus ngomong: “Maria, aja wedi! Gusti Allah ngétokké kabetyikané marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kowé bakal meteng lan nglairké anak lanang. Botyahé kudu mbok jenengké Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dèkné bakal dadi wong sing pinunjul lan bakal dityeluk Anaké Sing Luhur Déwé. Gusti Allah bakal ndadèkké Dèkné dadi ratu, nurut bapak-bapakané mbiyèn, yakuwi ratu Daved. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dèkné bakal dadi ratuné turun-turunané Bapa Yakub slawas-lawasé lan enggoné Dèkné bakal dadi ratu ora bakal ènèng lèrèné.” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria terus takon marang mulékaté: “Kepriyé kuwi mau kabèh bakalé klakon, awit aku durung nduwé bojo?” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mulékaté semaur: “Roh Sutyi bakal nyedeki kowé lan kwasané Gusti Allah bakal nutupi kowé. Mulané anak sing lair kuwi sutyi lan bakal dityeluk Anaké Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lan ngertia nèk uga ibu Elisabèt, sedulurmu sing wis tuwa lan sing jaréné ora bisa nduwé anak, saiki wis meteng nem sasi. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Awit kanggo Gusti Allah ora ènèng prekara sing mokal.” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria terus ngomong: “Aku iki peladèné Gusti. Sembarang kuwi mau kabèh bakal klakon karo aku kaya sing mbok omong kuwi.” Sakwisé kuwi mulékaté terus lunga. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ora let suwi Maria terus budal nang kuta nang gunungané bawah Yudéa. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maria njujuk nang omahé imam Sakarias, terus mlebu mbagèkké ibu Elisabèt. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Dongé ibu Elisabèt krungu swarané Maria, bayi sing nang wetengé terus nggronjal. Ibu Elisabèt terus dikwasani karo Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mulané dèkné terus ngomong karo swara banter: “Maria, kowé pantyèn wong wédok sing nampa berkah sing gedé déwé ing sak tengahé wong wédok kabèh. Semono uga bayi sing nang wetengmu, kuwi bayi sing gedé déwé berkahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sapa ta aku iki, kok sampèk ditekani karo ibuné Gustiku? ");
INSERT INTO jvnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Awit dongé kowé mbagèkké aku, bayi sing nang wetengku nggronjal sangking bungahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gedé tenan berkahé Gusti Allah marang kowé, awit kowé pretyaya nèk sembarang sing diomong karo Gusti Allah marang kowé bakal klakon.” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria terus ngomong: “Nyawaku ngluhurké Gusti! ");
INSERT INTO jvnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Gusti Allah, Juru Slametku, marakké atiku bungah. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dèkné nggatèkké marang aku iki, peladèn sing tyilik déwé. Wiwit saiki kabèh wong bakal ngomong nèk aku iki wong sing gedé berkahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Awit Gusti Allah, sing gedé déwé kwasané, wis nindakké barang sing gedé banget ing uripku. Pantyèn sutyi tenan jenengé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Gusti ngétokké kawelasané marang wong sing ngajèni marang Dèkné, Gusti melasi turun-turunané. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Gusti Allah ngétokké pangwasané lan wong-wong sing gemunggung ing atiné dibuyarké kabèh. Rantyamané diorat-arit. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gusti Allah nglorotké para pangwasa sangka jagongané, malah sing tyilik diunggahké. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Gusti Allah ngekèki mangan marang wong sing ngelih, malah diudani karo sembarang sing betyik, nanging wong sing sugih dikongkon lunga, ora dikèki apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gusti Allah nulungi Israèl, peladèné, awit Dèkné arep netepi prejanjiané marang para mbah-mbahané. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Awit Gusti Allah wis janji nèk bakal mberkahi Bapa Abraham lan turun-turunané kabèh, slawas-lawasé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria terus telung sasi suwéné nang nggoné ibu Elisabèt. Sakwisé telung sasi kuwi dèkné terus mulih. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kadung wis tekan wayahé, ibu Elisabèt mbayi anak lanang. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tangga-teparo lan sanak-seduluré pada krungu bab gedéné kabetyikané Gusti marang ibu Elisabèt. Wong-wong iki kabèh pada mèlu bungah banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kadung bayiné wis nduwé umur wolung dina, tangga-teparo lan sanak-seduluré mau kabèh pada teka, awit bayiné arep disunati. Karepé wong-wong botyahé arep dijenengké Sakarias, kaya bapaké. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nanging ibuné ngomong: “Ora, botyah iki kudu dijenengké Yohanes!” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wong-wong terus takon: “Lo, nang tengahé sanak-sedulurmu apa ènèng sing jenengé Yohanes?” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wong-wong terus takon marang imam Sakarias nganggo tangané, botyahé kudu dijenengké sapa. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Imam Sakarias terus njaluk lèi dienggo nulis. Kadung wis éntuk dèkné terus nulis: “Jenengé Yohanes!” Wong-wong nggumun kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sakwat imam Sakarias terus bisa ngomong menèh lan dèkné terus ngluhurké Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tangga-teparoné kabèh pada wedi lan kabar mau terus mrèmèn-mrèmèn nang bawah pegunungan nang Yudéa kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wong kabèh sing krungu bab lelakon kuwi terus pada nggatèkké tenan ing atiné lan pada mikir: “Botyah iki mbésuk bakal dadi apa ya?” Awit ketara tenan nèk pangwasané Gusti Allah ana ing botyah iki. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Imam Sakarias, bapaké bayi mau, terus dikwasani karo Roh Sutyi lan ngetokké tembung ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Hayuk pada memuji marang Gusti, Gusti Allahé bangsa Israèl! Awit Dèkné wis nggatèkké marang umaté lan pada diluwari. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Gusti Allah ngekèki Juru Slamet sing kwasa marang awaké déwé, yakuwi turunané ratu Daved, peladèné. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gusti Allah dèk mbiyèn wis janji liwat para nabiné sing sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Dèkné bakal ngluwari awaké déwé sangka pangwasané mungsuh-mungsuh lan wong-wong sing sengit marang awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mengkono kuwi Gusti Allah ngétokké kabetyikané marang mbah-mbahané awaké déwé lan netepi prejanjiané sing sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gusti Allah wis sumpah marang Bapa Abraham, mbah-mbahané awaké déwé ");
INSERT INTO jvnNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","lan Dèkné wis janji nèk bakal ngluwari awaké déwé sangka mungsuhé awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Supaya awaké déwé bisa ngabekti marang Dèkné tanpa rasa wedi, nganggo ati sing sutyi lan jujur nang ngarepé Gusti, slawasé urip. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lah kowé anakku, kowé bakal diarani nabiné Gusti Allah sing gedé déwé kwasané. Kowé dikongkon teka ndisik, supaya nggawèkké dalan kanggo Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kowé kudu ndunungké marang umaté, nèk bakal dislametké, awit bakal dingapura dosa-dosané. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gusti Allah iku gedé kawelasané. Dèkné bakal teka ngluwari awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kaya srengéngé mletèk ing wayah ésuk, mengkono Gusti bakal madangi kabèh wong sing ana ing pepeteng lan sing tansah krasa wedi. Gusti Allah nuntun awaké déwé marang dalan katentreman.” ");
INSERT INTO jvnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Botyah mau terus mundak gedé lan tambah ing kekuwatané Roh Sutyi. Dèkné manggoné nang panggonan-panggonan sing ora kanggonan wong, nganti tekan wayahé dèkné ngétok marang bangsa Israèl. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ing waktu kuwi ratu Agustus ngetokké tembung nèk kabèh wong sing manggon nang negara-negara sing ana ing pangwasané kraton Rum kudu nyatetké jenengé lan kaitung kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Itung-itungan wong sing sepisanan kuwi dianakké dongé Kirénius dadi gramang nang bawah Siria. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wong kabèh terus pada budal nyatetké jenengé nang kutané mbah-mbahané mbiyèn. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Lan jalaran Yosèf kuwi turunané ratu Daved, mulané dèkné ya terus budal sangka kuta Nasarèt nang distrik Galiléa, lunga nang kuta Bètlehèm nang distrik Yudéa. Bètlehèm kuwi kuta lairané ratu Daved. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yosèf lunga nggawa Maria, patyangané sing meteng. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dongé wong loro mau teka nang kuta Bètlehèm wis wayahé Maria kudu mbayi. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maria ya terus mbayi anak lanang sing mbarep. Bayiné terus digedong lan disèlèhké nang wadah pakan kéwan, awit Yosèf lan Maria wis ora bisa nemu panggonan menèh nang omah inepan. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nang bawah kono ing wengi kuwi ènèng pangon-pangon sing ijik njaga wedusé nang kebon. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dadakan waé terus mulékaté Gusti ngadek nang ngarepé lan pangwasané Gusti Allah madangi para pangon mau. Wong-wong pada wedi banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nanging mulékaté terus ngomong: “Aja pada wedi, awit aku teka nggawa kabar betyik kanggo kowé, kabar sing mbungahké atiné wong kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ing dina iki Juru Slametmu wis lair nang kutané ratu Daved. Dèkné kuwi Kristus, Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iki tengeré: kowé bakal nemu bayi digedong lan disèlèhké nang wadah pakan kéwan!” ");
INSERT INTO jvnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Terus dadakan waé ènèng mulékat pirang-pirang pada ngantyani mulékat mau lan bebarengan terus pada memuji Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Tembungé ngéné: “Pujia Gusti Allah sing nang nduwur lan tentrem ayem nang bumi, awit Gusti Allah ngétokké kabetyikané marang manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kadung para mulékat mau wis lunga nang swarga, para pangon terus ngomong marang sakpada-pada: “Hayuk pada budal nang kuta Bètlehèm. Gusti Allah wis ngomongi awaké déwé bab sing klakon nang kana. Hayuk pada ndelok!” ");
INSERT INTO jvnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Para pangon mau terus gelis-gelis budal, terus nemu Maria lan Yosèf lan Bayiné sing disèlèhké nang wadah pakan kéwan. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kadung wis weruh Bayiné, para pangon terus ngabar-ngabarké bab apa sing diomong karo mulékaté bab Bayiné. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kabèh wong sing krungu kabaré para pangon mau pada nggumun banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nanging Maria nyimpen lelakon-lelakon kuwi mau kabèh ing atiné lan digagas apa tegesé. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Para pangon terus balik menèh nang kebon karo memuji lan ngluhurké Gusti Allah, awit kabèh sing dirungu lan sing diseksèni pantyèn tyotyok karo sing diomong karo mulékaté. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kadung umuré wis wolung dina, Bayiné terus disunati lan dikèki jeneng. Jenengé Yésus, awit mulékaté ngekèki jeneng kuwi marang Maria, sakdurungé dèkné meteng. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Miturut wèté nabi Moses Maria dianggep resik menèh nèk wis kliwat patang puluh dina sakwisé mbayi. Kadung wis tekan wayahé, Maria lan Yosèf terus budal nang kuta Yérusalèm arep masrahké Bayiné marang Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Awit nang Kitab ketulis ngéné: “Saben anak mbarep sing lanang kudu dipasrahké marang Gusti.” ");
INSERT INTO jvnNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Maria lan Yosèf budal nang kuta Yérusalèm kuwi uga arep nggawa kurban miturut wèté Gusti Allah sing ketulis nang Kitab. Kurbané yakuwi: manuk dara sak jodo apa manuk dara tyilik loro. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ing waktu kuwi nang kuta Yérusalèm kono ènèng wong sing jenengé Siméon. Siméon iki sakwijiné wong sing nuruti kekarepané Gusti Allah lan ngabekti marang Gusti Allah. Dèkné ngarep-arep kapan Gusti Allah bakal nekakké keslametan marang bangsa Israèl. Siméon iki kebek karo Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Roh Sutyi déwé sing ngomong marang dèkné nèk dèkné ora bakal mati sakdurungé weruh Juru Slameté manungsa, sing wis dijanji karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Katuntun Roh Sutyi Siméon terus mlebu nang Gréja Gedé. Maria lan Yosèf uga mlebu nang Gréja Gedé nggawa Bayiné arep dipasrahké marang Gusti Allah, miturut pernatané agama. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Siméon terus nyekel Bayiné, terus dibopong karo memuji Gusti Allah ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Duh Gusti, Kowé netepi janjimu marang peladènmu. Saiki aku wis bisa ninggal karo ayem. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Awit mripatku wis weruh Juru Slamet Kongkonanmu. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Dèkné sing mbok tyawiské kanggo nylametké kabèh bangsa, ");
INSERT INTO jvnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","kaya pepadang sing madangi dalané wong sing ora pretyaya, supaya pada mara nang nggonmu. Dadiné umatmu, bangsa Israèl, nampa pengaleman sangka liya-liya bangsa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yosèf lan Maria pada nggumun krungu tembungé Siméon sing ngomongké bab anaké mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Siméon terus mberkahi Yosèf, Maria lan Bayiné, terus ngomong marang Maria: “Botyah iki wis dikarepké karo Gusti Allah dadi jalarané tiba lan tanginé wong okèh nang Israèl. Dèkné bakal dadi tanda sangka Gusti Allah, sing bakal dibantah karo wong okèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mengkono kuwi angen-angen sing kasimpen ing atiné wong okèh bakal kebukak. Kowé déwé Maria, bakal ngrasakké sedi, atimu rasané kaya disuwèk karo pedang sing landep kaé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nang kono uga ènèng nabi wédok sing wis tuwa banget, jenengé Hanah, anaké Fanuèl sangka turunané Aser. Nabi Hanah sakwisé kawin pitung taun suwéné terus ditinggal mati bojoné. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Dadiné dèkné saiki randa, umuré wis wolung puluh papat taun. Nabi Hanah kuwi sasaté awan-wengi nang Gréja Gedé ngabekti marang Gusti Allah nganggo pandonga lan pasa. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ing waktu kuwi ya dongé nabi Hanah uga teka nang Gréja Gedé. Dèkné terus memuji Gusti Allah lan ngomongké bab Botyah Bayi mau marang wong kabèh sing pada ngarep-arep kapan Gusti Allah enggoné ngluwari kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Sakwisé rampung enggoné pada netepi pernatané Gusti Allah kabèh, Yosèf lan Maria terus pada mulih nang kuta Nasarèt nang distrik Galiléa. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Botyah Bayi mau terus mundak gedé lan rosa, dadi botyah sing jembar kaweruhé lan Gusti Allah ya mberkahi Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Saben taun wong tuwané Gusti Yésus budal nang kuta Yérusalèm mèlu ngurmat riyaya Paskah. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kadung Gusti Yésus wis nduwé umur rolas taun, Dèkné uga diejèk nang Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sakwisé rampung karo riyaya Paskah Yosèf lan Maria terus pada mulih, nanging Gusti Yésus ijik kèri nang Yérusalèm. Wong tuwané malah ora ngerti ");
INSERT INTO jvnNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ndarani Gusti Yésus wis ndisiki mulih, bareng karo wong-wong. Kadung wis mlaku sedina muput, Yosèf lan Maria terus nggolèki Gusti Yésus nang nggoné sedulur-seduluré lan kenal-kenalané. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nanging ora bisa ketemu, mulané terus pada balik menèh nang kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sakwisé nggolèki telung dina suwéné, Yosèf lan Maria bisa nemu Anaké nang Gréja Gedé. Dèkné ijik njagong ing sak tengahé para guru. Gusti Yésus ngrungokké piwulangé para guru mau lan Dèkné uga ngetokké werna-werna pitakonan. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kabèh wong sing krungu tembungé Gusti Yésus pada nggumun bab kapinterané enggoné mangsuli para guru mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bapaké lan ibuné uga nggumun banget. Maria ngomong: “Lik, kenèng apa kowé kok nggawé bingungé bapak lan ibumu? Awaké déwé nggolèki kowé sampèk susah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Gusti Yésus semaur ngéné: “Kenèng apa kowé kok pada nggolèki Aku? Apa kowé ora pada ngerti nèk Aku kudu nang omahé Bapakku?” ");
INSERT INTO jvnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yosèf lan Maria ora dunung marang tembungé Gusti Yésus kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sakwisé kuwi Gusti Yésus terus mèlu mulih karo wong tuwané nang kuta Nasarèt. Dèkné tansah manut marang tembungé wong tuwané. Maria mikirké prekara-prekara iki kabèh ing atiné. ");
INSERT INTO jvnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Gusti Yésus terus mundak gedé lan mundak kaweruhé. Dèkné uga mundak ditrésnani karo Gusti Allah lan manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ing wantyi kuwi ratu Tibérius wis nyekel pangwasa limalas taun suwéné. Sing dadi gramang nang distrik Yudéa ing waktu kuwi Pontius Pilatus. Ratu Hérodès ngwasani distrik Galiléa lan seduluré, sing jenengé Filipus, dadi ratu nang distrik Ituréa lan Trankonitis. Lisanias dadi ratuné distrik Abiléne. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Sing dadi Imam Gedé ing waktu kuwi Anas lan Kayafas. Yohanes kuwi anaké imam Sakarias lan ing waktu kuwi, dongé dèkné ijik manggon nang wustèn, Yohanes nampa tembung sangka Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohanes terus ndlajahi kiwa-tengené laut Yordan kabèh. Dèkné mulangi wong-wong ngomong ngéné: “Pada ninggala urip sing dosa lan pada njaluka dibaptis, supaya kowé bisa nampa pangapura sangka Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Lelakon iki pantyèn tyotyok karo sing ketulis nang kitabé nabi Yésaya, sing uniné ngéné: “Rungokké! Enèng wong bengok-bengok nang wustèn ngomong ngéné: ‘Gusti pada digawèkké dalan. Pada dilempengké dalan sing arep diambahi. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jeglongan-jeglongan kudu dihuruki, gunung-gunung lan puntuk-puntuk kudu dirata. Dalan sing ménggak-ménggok kudu dilempengké lan sing endèk-duwur kudu dirata. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kabèh bangsa bakal pada weruh enggoné Gusti Allah bakal nylametké manungsa.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wong pirang-pirang terus pada teka nang nggoné Yohanes njaluk dibaptis. Yohanes ngomong ngéné marang wong-wong kuwi: “Kowé kuwi anakan ula. Sapa ta sing ngomongi kowé nèk bisa nyimpangi setrapané Gusti Allah sing bakal teka? ");
INSERT INTO jvnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kétokna nganggo klakuanmu nèk kowé wis ninggal tenan uripmu sing dosa kuwi. Aja mikir dumèh kowé anak turunané Bapa Abraham waé kuwi wis tyukup. Ngandela omongku iki: Gusti Allah nduwèni kwasa ngekèki anak-turunan marang Bapa Abraham sangka watu-watu iki. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Delokké, kampaké wis dityepakké kanggo negor wité nang poké oyoté. Saben wit sing ora ngetokké woh sing apik bakal ditegor lan dibuwang nang geni.” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Wong okèh mau terus pada takon marang Yohanes: “Nèk ngono, lah saiki awaké déwé kudu ngapa?” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohanes semaur: “Sapa sing nduwé klambi loro, sing siji kudu dikèkké marang sing ora nduwé blas. Sapa sing nduwé pangan kudu ngekèki marang sing ora nduwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wong-wong sing tukang njaluki belasting uga pada teka nang nggoné Yohanes njaluk dibaptis. Wong-wong iki pada takon marang Yohanes ngéné: “Guru, awaké déwé kudu ngapa?” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yohanes semaur: “Aja pada njaluk belasting ngliwati sak perluné.” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Uga para soldat pada takon: “Lah awaké déwé iki kepriyé? Awaké déwé kudu nglakoni apa?” Yohanes sing semaur: “Aja pada meres apa ngrampas lan ngarani wong sing ora salah. Nanging sampé ora sampé pada mangana gajihanmu déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ing jaman kuwi wong okèh pada ngarep-arep tekané Kristusé. Mulané ya okèh wong sing pada mikir nèk Yohanes kuwi Kristusé. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mulané Yohanes terus ngomong ngéné marang wong-wong kuwi: “Aku mbaptis kowé nganggo banyu, nanging bakal ènèng wong liyané teka; Dèkné bakal mbaptis kowé nganggo Roh Sutyi lan geni. Wong kuwi kwasané ngungkul-ungkuli aku. Kanggo ngutyuli sepatuné wongé waé durung pantes aku. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dèkné bakal napèni pariné sing wis diiles. Gabahé bakal dilebokké nang lumbung, nanging kapahé bakal diobong nang geni sing ora bisa mati.” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ya ngono kuwi lan uga nganggo tembung liya-liyané menèh Yohanes nggelarké kabar kabungahané Gusti Allah marang wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohanes uga blaka enggoné melèkké marang Hérodès, ratuné Galiléa. Awit Hérodès mlaku karo Hérodias, bojoné seduluré Hérodès déwé. Yohanes uga ngomongké bab dosa-dosa liyané sing dilakoni karo ratu Hérodès. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nanging Hérodès malah ndadra enggoné nglakoni ala, malah nglebokké Yohanes nang setrapan. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bareng karo wong pirang-pirang Gusti Yésus mbarang dibaptis. Dongé Dèkné ijik ndonga, langité menga. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Roh Sutyi terus medun nekani Gusti Yésus, kétoké kaya manuk dara. Terus sangka swarga swarané Gusti Allah ngomong ngéné: “Kowé kuwi Anakku sing tak trésnani lan sing ndadèkké legané atiku!” ");
INSERT INTO jvnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","24","Dongé Gusti Yésus molai nyambutgawé umuré kira-kira telung puluh taun. Miturut pikirané wong-wong Gusti Yésus kuwi anaké Yosèf. Lah Yosèf kuwi anaké Eli lan Eli anaké Matat. Matat anaké Lévi lan Lévi anaké Mèlki. Mèlki anaké Yanai lan Yanai anaké Yosèf. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosèf anaké Matatias lan Matatias anaké Amos. Amos anaké Nahum lan Nahum anaké Hèsli. Hèsli anaké Nagai. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai anaké Mahat lan Mahat anaké Matatias. Matatias anaké Simèin lan Simèin anaké Yosèk. Yosèk anaké Yoda. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda anaké Yohanan lan Yohanan anaké Résa. Résa anaké Sérubabil lan Sérubabil anaké Séaltièl. Séaltièl anaké Néri. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Néri anaké Mèlki lan Mèlki anaké Adi. Adi anaké Kosam lan Kosam anaké Elmadam. Elmadam anaké Er. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er anaké Yosua lan Yosua anaké Elièser. Elièser anaké Yorim lan Yorim anaké Matat. Matat anaké Lévi. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lévi anaké Siméon lan Siméon anaké Yudah. Yudah anaké Yosèf lan Yosèf anaké Yonam. Yonam anaké Eliakim. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim anaké Meléa lan Meléa anaké Minah. Minah anaké Matata lan Matata anaké Natan. Natan anaké Daved. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daved anaké Isai lan Isai anaké Obèd. Obèd anaké Boas lan Boas anaké Salmon. Salmon anaké Nakson. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nakson anaké Aminadab lan Aminadab anaké Admin. Admin anaké Arni lan Arni anaké Hèsron. Hèsron anaké Pèrès lan Pèrès anaké Yudah. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudah anaké Yakub lan Yakub anaké Isak. Isak anaké Abraham lan Abraham anaké Térah. Térah anaké Nakor. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor anaké Seruk lan Seruk anaké Réhu. Réhu anaké Pèlèk lan Pèlèk anaké Eber. Eber anaké Sélak. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sélak anaké Kenan lan Kenan anaké Arpaksad. Arpaksad anaké Sèm lan Sèm anaké Noah. Noah anaké Lamèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamèh anaké Métusalah lan Métusalah anaké Hénok. Hénok anaké Yarèd lan Yarèd anaké Mahalalèl. Mahalalèl anaké Kenan. ");
INSERT INTO jvnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan anaké Enos lan Enos anaké Sèt. Sèt anaké Adam lan Adam anaké Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Gusti Yésus saiki kebek karo Roh Sutyi terus lunga sangka laut Yordan. Dèkné terus digawa nang wustèn karo Roh Sutyi, patang puluh dina suwéné. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nang kono Gusti Yésus digoda karo Sétan. Suwéné nang wustèn kono Gusti Yésus ora mangan apa-apa. Kadung wis rampung waktuné Dèkné krasa ngelih. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sétan terus ngomong: “Jaréné Kowé Anaké Gusti Allah, ya watu iki dipréntah kongkon dadi roti!” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Gusti Yésus semaur: “Nang Kitab ketulis ngéné: ‘Manungsa uripé ora namung sangka roti waé.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sétan terus nggawa Gusti Yésus munggah nang panggonan sing duwur banget. Ing sak kedèpan Sétan terus ngétokké kraton-kraton kabèh sak jagat marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sétan terus ngomong: “Sak ènèngé pangwasa lan kamulyan bakal tak kèkké marang Kowé. Kabèh kuwi wèkku lan aku bisa ngekèkké marang sapa waé sak karepku. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mulané, nèk Kowé gelem nyembah marang aku, kabèh kuwi bakal tak kèkké marang Kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Gusti Yésus semaur: “Nang Kitab ènèng tulisan ngéné: ‘Nyembaha marang Gusti, Dèkné Allahmu. Namung Dèkné sing kudu mbok ladèni.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sakwisé kuwi Sétan terus nggawa Gusti Yésus nang kuta Yérusalèm, didekné nang putyuké payoné Gréja Gedé. Sétan terus ngomong: “Jaréné Kowé Anaké Gusti Allah, kana anjlok medun. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nang Kitab lak ketulis ta: ‘Gusti Allah bakal ngongkon mulékaté mageri kowé.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Uga ènèng tulisan liyané uniné ngéné: ‘Kowé bakal ditampani nganggo tangané, supaya sikilmu ora kenèng watu.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Gusti Yésus semaur: “Nang Kitab uga ènèng tulisan sing uniné ngéné: ‘Kowé aja nyoba Gusti Allahmu!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sakwisé rampung sing nggoda nganggo sak ènèngé akal, Sétan terus ninggal Gusti Yésus sak untara. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ing kekuwatané Roh Sutyi Gusti Yésus terus balik menèh nang bawah Galiléa. Nang kono lan sak kiwa-tengené wong kabèh pada krungu bab Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Gusti Yésus terus mulang nang sinaguk-sinaguk lan wong-wong pada ngelem Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Gusti Yésus terus teka nang kuta Nasarèt, kuta panggonané Dèkné. Kaya sak lumrahé, ing dina sabat Gusti Yésus budal nang sinaguk. Nang kono Dèkné terus maju arep matya. Dèkné terus dielungi kitabé nabi Yésaya. Kadung dibukak terus nemu ayat sing uniné ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Rohé Gusti ana ing Aku, awit Gusti wis milih Aku. Aku dikongkon nggelarké kabar kabungahan marang wong mlarat. Wong setrapan kudu tak kabari nèk bakal dietokké lan wong lamur bakal weruh. Aku kudu ngluwari sing ngalami kasangsaran. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Lan menèh, aku kudu ngabarké nèk saiki wis wantyiné enggoné Gusti Allah ngétokké kabetyikané marang manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sakwisé matya, Gusti Yésus terus nutup kitabé terus dibalèkké marang peladèné Kitab. Dèkné terus njagong. Wong kabèh sing nang sinaguk kono pada nyawang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Gusti Yésus terus ngomong ngéné: “Ing dina iki, sak barengé kowé ngrungokké sing tak watya mau, isiné ayat-ayat mau wis keturutan.” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wong-wong pada ngrungokké tenan marang tembungé Gusti Yésus lan pada nggumun apiké piwulangé. Mulané pada rasan-rasan: “Apa kuwi dudu anaké Yosèf kaé?” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Gusti Yésus terus ngomong ngéné marang wong-wong: “Kowé mesti bakal nyotyokké paribasan iki marang aku: ‘Dokter, tambanana awakmu déwé! Awaké déwé krungu bab prekara-prekara sing mbok tindakké nang kuta Kapèrnakum, kuwi tindakna nang kéné, nang kuta panggonanmu déwé.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Gusti Yésus terus ngomong menèh: “Ngandela ta, ora ènèng nabi sing kajèn nang panggonané déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kowé pada ngerti nèk ing jamané nabi Elia nang negara Israèl ènèng wong randa pirang-pirang. Telung taun setengah suwéné ora ènèng udan, sampèk nang sak negara ènèng kurang pangan gedé. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nanging Gusti Allah ora ngongkon nabi Elia nulungi randa nang Israèl, ora. Nanging nabi Elia malah dikongkon marani randa nang kuta Saréfat nang bawah Sidon. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Uga ing jamané nabi Elisa, nang Israèl okèh wong sing lara lépra. Nanging ora ènèng siji waé sing ditambani, kejaba namung Naaman, wong sangka negara Siria.” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sakwisé krungu tembungé Gusti Yésus kuwi mau wong sak sinaguk pada nesu kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wong-wong pada ngadek, Gusti Yésus terus disèrèt nang njabané kuta, terus digawa nang pinggiré gunung sing nyangga kutané kono. Jawané Gusti Yésus arep dijongkrokké medun. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nanging Dèkné nrobos nang tengahé wong-wong mau terus lunga sangka kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Gusti Yésus terus medun nang kuta Kapèrnakum nang bawah Galiléa. Ing dina sabat Dèkné mulang nang sinaguk. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wong-wong pada nggumun bab tyarané enggoné Gusti Yésus memulang, awit tembung-tembungé ènèng kwasané. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nang sinaguk kono ènèng wong sing dikwasani demit. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Wongé bengok-bengok ngomong: “Yésus sangka Nasarèt, awaké déwé arep mbok kapakké? Apa Kowé arep ngrusak awaké déwé? Awaké déwé ngerti Kowé kuwi sapa! Kowé kuwi Wong Sutyi, kongkonané Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Demité terus digentak karo Gusti Yésus: “Meneng! Metua sangka wong kuwi!” Demité terus mbanting wongé, terus wongé tiba nang tengahé wong pirang-pirang kono. Demité terus metu tanpa nggawé larané wongé. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wong-wong pada nggumun kabèh lan ngomong marang sakpada-pada: “Wah, jan antep banget tembungé. Dèkné nundung demit-demité nganggo pangwasa lan wujuté ya pada metu tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kabar bab Gusti Yésus iki terus mrèmèn-mrèmèn terus nang panggonan-panggonan sak kiwa-tengené kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Gusti Yésus terus metu sangka sinaguk kono, terus merdayoh nang omahé Simon. Ibu-maratuwané Simon ing waktu iku dongé lara panas lan ènèng sing ngomongi Gusti Yésus bab kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Gusti Yésus terus nyedeki sing lara nang sebelah sirahé, terus nundung larané. Wongé terus waras menèh lan terusan waé ngladèni dayoh-dayohé. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kadung wis surup, wong kabèh sing nduwé sedulur sing lara pada digawani nang nggoné Gusti Yésus, larané werna-werna. Wong-wong sing lara terus ditumpangi tangan siji-siji karo Gusti Yésus, terus pada mari kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Demit pirang-pirang pada metu pating jlerit, ngomong: “Aku ngerti nèk Kowé kuwi Anaké Gusti Allah.” Demit-demit kuwi digentaki karo Gusti Yésus, dipenging ngomong apa-apa, awit demit-demit kuwi pada ngerti nèk Gusti Yésus kuwi Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ing ésuké mruput Gusti Yésus lunga sangka omah nggolèk panggonan sing sepi. Wong-wong terus pada nggolèki Dèkné. Kadung wis ketemu terus pada nyuwun marang Dèkné supaya ora lunga. ");
INSERT INTO jvnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nanging Gusti Yésus ngomong marang wong-wong mau: “Kabar kabungahan bab Kratoné Gusti Allah iki uga kudu tak gelarké nang liya-liya panggonan, awit iku kongkonané Gusti Allah marang Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gusti Yésus ya terus mulangi nang sinaguk-sinaguk nang bawah Yudéa. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ing sakwijiné dina Gusti Yésus ngadek nang pinggiré mér Genésarèt. Wong pirang-pirang pada esuk-esukan, awit pada kepéngin ngrungokké pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Gusti Yésus weruh ènèng prau loro nang pinggir kono. Sing nduwé prauné wis pada medun, ijik ngresiki jalané. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gusti Yésus terus munggah nang prauné Simon. Simon terus dityeluk kongkon nyurung prauné sangka daratan. Gusti Yésus terus njagong lan mulangi wong-wong sangka prauné kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kadung wis rampung sing mulangi, Gusti Yésus terus ngomong marang Simon: “Simon, praumu kana digawa nang tengah lan jalamu diuntyalké kono supaya éntuk iwak okèh.” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Semauré Simon: “Guru, wis sewengi muput awaké déwé nggolèk iwak sak kuwaté, nanging ora éntuk apa-apa. Nanging jalaran Kowé sing ngongkon, jalané tak untyalké menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kadung jalané wis diuntyalké terus éntuk iwak okèh banget, sampèk jalané arep bedah. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mulané terus pada tyeluk-tyeluk njaluk tulung kantya-kantyané sing nang prau liyané. Kantya-kantyané terus gelis-gelis teka. Prauné kabèh loro terus diisèni iwak sampèk kebek, sampèk prauné mèh kelep. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kadung weruh kuwi mau kabèh, Simon terus niba nang ngarepé Gusti Yésus karo ngomong: “Aja nyedeki aku Gusti, awit aku wong dosa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon ngomong ngono kuwi, awit dèkné lan kantya-kantyané pada nggumun tenan weruh iwak semono okèhé. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Uga Yakobus lan Yohanes, kantya-kantyané Simon, mèlu nggumun tenan. Gusti Yésus terus ngomong ngéné marang Simon: “Aja wedi Simon, wiwit saiki kowé bakal tak dadèkké wong sing tukang nggolèk wong.” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Simon lan kantya-kantyané terus minggirké prauné, terus mèlu Gusti Yésus, ninggal sembarang-mbarangé. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ing sakwijiné dina Gusti Yésus nang sakwijiné kuta. Nang kono ènèng wong lanang sing lara lépra sak awaké. Kadung weruh Gusti Yésus, wongé terus niba nang ngarepé terus nyuwun: “Duh Gusti, nèk Kowé gelem Kowé bisa nambani aku!” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Gusti Yésus ngelungké tangané terus ndemèk wongé karo ngomong: “Aku gelem, dadia waras!” Sakwat wongé terus mari tenan. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Gusti Yésus terus menging wongé ngomong-omongké bab lelakon kuwi. Wongé dikongkon nang nggoné imamé, kongkon nduduhké awaké sing wis waras. Gusti Yésus ngomong ngéné: “Kana nang nggoné imamé nduduhké awakmu. Kana ngekèki kurbané miturut pernatané nabi Moses. Dadiné wong kabèh bisa ngerti nèk kowé wis mari tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nanging kabar bab Gusti Yésus kuwi malah mrèmèn-mrèmèn terus tekan endi-endi. Wong pirang-pirang terus pada teka kepéngin ngrungokké piwulangé lan uga supaya ditambani larané. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sakwisé kuwi Gusti Yésus terus mundur nggolèk panggonan sing sepi, arep ndonga. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ing sakwijiné dina, dongé Gusti Yésus ijik memulang, uga ènèng wong Farisi lan guru-guru Kitab mèlu njagong ngrungokké. Wong-wong kuwi tekané sangka kuta-kuta nang bawah Galiléa, Yudéa lan Yérusalèm. Gusti Yésus nampa pangwasané Gusti Allah kanggo nambani sing pada lara. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Terus nang kono ènèng wong pada teka nggotong wong lumpuh nganggo peturoné. Jawané arep digawa nang nggoné Gusti Yésus. Wong-wong kuwi nggolèk akal kepriyé bisané nglebokké wong lumpuh mau nang njero omah sing dienggo mulangi karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nanging sangking okèhé wong, wong lumpuh mau ora bisa mlebu. Mulané terus digawa munggah, dijebolké payoné, terus sing lumpuh diedunké sak peturoné nang tengahé wong pirang-pirang sing nang kono, pener nang ngarepé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Gusti Yésus weruh gedéné pengandelé wong lumpuh lan wong-wong sing nggotong kuwi, mulané Dèkné terus ngomong marang wong sing lumpuh: “Kang, dosamu wis dingapura!” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Para guru Kitab lan para Farisi terus pada rerasan: “Sapa ta wong iki kok wani nyepèlèkké Gusti Allah? Wong urip ora bisa ngapura dosa, namung Gusti Allah déwé?” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nanging Gusti Yésus ngerti pikirané wong-wong kuwi, mulané terus ngomong: “Kenèng apa kowé kok pada mikir ngono? ");
INSERT INTO jvnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Pikiren déwé, gampang sing endi: ngomong ‘dosamu wis dingapura’ apa ngomong ‘ngadek lan mlakua?’ ");
INSERT INTO jvnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aku namung arep nduduhké marang kowé nèk Anaké Manungsa kuwi nduwèni kwasa ngapura dosa nang bumi.” Gusti Yésus terus ngomong ngéné marang wong sing lumpuh mau: “Aku ngomong marang kowé: ‘Ngadek, peturonmu dipanggul lan kana mulih!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wongé ya terus sakwat ngadek nang ngarepé wong pirang-pirang kono, terus manggul peturoné, terus mulih karo memuji lan ngluhurké Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wong-wong kabèh mau nggumuné éram-éram lan pada ngluhurké Gusti Allah. Atiné pada krasa wedi, mulané rerasan: “Lelakon iki jan ngidap-idapi tenan!” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sakwisé kuwi Gusti Yésus terus lunga sangka kono. Dèkné terus weruh sakwijiné wong belasting sing jenengé Lévi. Lévi ijik njagong nang kantoré. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Gusti Yésus ngomong ngéné marang dèkné: “Hayuk mèlua Aku.” Lévi terus menyat, sembarangé ditinggal kabèh, terus mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lévi terus nganakké pésta nang omahé kanggo Gusti Yésus. Wong belasting pirang-pirang lan uga wong liya-liyané pada bebarengan mangan nang pésta kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Para Farisi lan para guru Kitab sing mèlu golongané para Farisi sing pada weruh kuwi mau ora setuju karo lelakon kuwi. Mulané terus pada ngomong marang murid-muridé Gusti Yésus: “Kenèng apa kowé kok pada mangan tyampur karo wong belasting lan wong dosa?” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Gusti Yésus nyauri: “Wong sing waras ora mbutuhké dokter. Sing mbutuhké dokter kuwi sing lara. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aku iki ora teka nggolèki wong sing ngakuné wis apik uripé, ora. Nanging aku teka iki nggolèki wong dosa, supaya pada ngakoni salahé lan pada nurut Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Enèng wong sing pada takon ngéné marang Gusti Yésus: “Murid-muridé nabi Yohanes ajek pasa lan ndedonga, semono uga murid-muridé para Farisi. Kenèng apa murid-muridmu kok ora nglakoni kuwi?” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Saurané Gusti Yésus: “Apa tau ènèng dayoh nang kawinan dikongkon pasa, nèk mantèné lanang ijik tyampur karo dayohé mau? Mesti ora ta! ");
INSERT INTO jvnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nanging ènèng wantyiné nèk mantèné lanang bakal digawa lunga. Ing waktu kuwi wong-wong bakal pada pasa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Gusti Yésus terus mulangi nganggo gambar. Dèkné ngomong ngéné: “Apa tau ènèng wong nggunting klambi anyar kanggo nambal klambi sing lawas? Mesti ora! Awit klambiné anyar mengko mesti rusak. Karomenèh gombalé anyar ya ora pantes karo klambiné lawas. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Semono uga ora ènèng wong madahi anggur anyar nang kantongan lulang sing lawas. Awit nèk ngono mengko anggur sing anyar bakal mbedahké kantongané sing lawas. Angguré mesti bakal wutah lan kantongané bakal ora kanggo gawé. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Anggur anyar kuwi kudu disimpen nang kantongan lulang sing anyar uga. ");
INSERT INTO jvnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Semono uga, wong sing ngombéné anggur lawas ora bakal gelem ngombé anggur anyar. Dèkné bakal ngomong: ‘Anggur sing lawas énak tenan.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ing sakwijiné dina sabat Gusti Yésus mlaku turut kebon pari gandum. Para murid pada ngepèk pariné. Pariné mau terus diremeti, terus gandumé dipangan. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mulané terus ènèng wong Farisi siji-loro pada ngluruhi ngéné: “Kowé kuwi pada ngapa iku. Kowé ngerti ta nèk ora kenèng nindakké kuwi ing dina sabat!” ");
INSERT INTO jvnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Gusti Yésus semaur: “Apa kowé ora tau matya bab sing ditindakké karo Daved, dongé dèkné sak balané pada ngelih. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daved ngleboni omahé Gusti Allah, terus njikuk roti sutyi terus dipangan lan liya-liyané sing mèlu dikèki mbarang. Lah sakjané lak namung para imam ta sing éntuk mangan roti sutyi kuwi? Wong liya ora éntuk!” ");
INSERT INTO jvnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Gusti Yésus terus ngomong ngéné: “Anaké Manungsa nduwèni kwasa ngarani apa sing kenèng lan apa sing ora kenèng ditindakké ing dina sabat.” ");
INSERT INTO jvnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ing dina sabat liyané Gusti Yésus mulangi nang sinaguk. Nang kono ènèng wong sing lumpuh tangané tengen. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Para guru Kitab lan para Farisi kepéngin ngerti Gusti Yésus nambani wongé apa ora ing dina sabat kuwi. Wong-wong kuwi nggolèk jalaran kanggo ngelahké Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nanging Gusti Yésus ngerti kekarepané wong-wong kuwi, mulané Dèkné ngomong marang wong sing lumpuh mau: “Réné ngadek nang tengah kéné.” Wongé ya manut. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Gusti Yésus terus takon marang para guru Kitab lan para Farisi mau: “Aku arep takon marang kowé saiki: ing dina sabat awaké déwé kudu nggawé betyik apa nggawé ala. Kudu nulungi uripé wong apa kudu ngejarké bèn mati?” ");
INSERT INTO jvnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sakwisé nyawang wong-wong mau Gusti Yésus terus ngomong marang wong sing lumpuh: “Tanganmu dietungké!” Wongé ya manut apa omongé, tangané terus mari kaya mauné menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nanging para guru Kitab lan para Farisi malah pada nesu, terus pada ngrembuk Gusti Yésus arep dikapakké. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ora let suwi Gusti Yésus munggah gunung arep ndonga. Sewengi muput Dèkné ndonga marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Esuké Dèkné terus nyeluk murid-muridé kongkon pada mara. Gusti Yésus terus milih murid rolas sing diarani rasul. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Rasul rolas iki yakuwi: Simon, sing uga dityeluk Pétrus karo Gusti Yésus. Liyané Andréas, seduluré Pétrus. Uga Yakobus, Yohanes, Filipus, Bartoloméus, Matéus, Tomas, Yakobus anaké Alféus, Simon wong Patriot, Yudas anaké Yakobus lan Yudas Iskariot. Yudas iki sing ngelungké Gusti Yésus marang mungsuhé. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Gusti Yésus terus medun sangka gunung. Rasul rolas mau mèlu. Nang panggonan sing rata Dèkné terus mandek. Nang kono wong pirang-pirang pada nglumpuk. Kejaba para murid uga wong liya-liyané pada teka sangka bawah Yudéa, sangka kuta Yérusalèm lan uga sangka kuta-kuta uruté pinggir laut, kayadéné kuta Sidon lan Tirus. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wong-wong pada teka, jalaran pada kepéngin ngrungokké piwulangé Gusti Yésus lan uga supaya ditambani lelarané. Uga wong-wong sing dikwasani demit pada nampa waras. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wong kabèh mau pada kepéngin ndemèk Gusti Yésus, awit ènèng kekuwatan metu sangka awaké lan kekuwatan kuwi nambani wong sing lara. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gusti Yésus nyawang murid-muridé terus ngomong: “Beja kowé kabèh sing mlarat, awit kowé kuwi nduwèni Kratoné Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Beja kowé kabèh sing ngelih, awit kowé bakal warek. Beja kowé kabèh sing saiki tangisan, awit kowé bakal ngguyu. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Beja kowé kabèh sing disengiti wong, sing ora diitung, sing dityatur ala lan diolok-olok jalaran nurut Anaké Manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ing waktu kuwi kowé malah kudu bungah lan jingklak-jingklak, awit kowé bakal nampa upah sing gedé nang swarga. Mbah-mbahané wong-wong kuwi dèk mbiyèn wujuté ya wis nindakké sing ala kuwi marang para nabi. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nanging awas, kowé sing saiki sugih, awit saiki kowé wis ngrasakké kepénaké donya. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Awas, kowé sing saiki warek, awit kowé bakal kekurangan pangan. Awas kowé sing saiki ngguyu, awit kowé bakal sedi lan nangis. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Awas, kowé sing dielem karo kabèh wong, awit ya ngono kuwi enggoné mbah-mbahané wong-wong kuwi pada ngelem nabi-nabi sing palsu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Gusti Yésus neruské tembungé: “Kowé sing nampa tembungku, rungokké iki: pada trésnaa marang mungsuhmu, nggawéa betyik marang wong sing sengit marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wong sing mujèkké ala marang kowé malah kudu mbok suwunké berkah lan wong sing nggawé ala marang kowé kudu mbok dongaké slamet. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wong sing ngeplak pipimu sing siji, kèkna pisan pipimu sing liyané. Wong sing ngrebut jasmu, kèkna pisan klambimu. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nèk ènèng wong njaluk apa-apa marang kowé, kèkna. Nèk ènèng wong ngrebut barangmu, aja dijaluk menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nèk kowé kepéngin wong liya nggawé betyik marang kowé, kowé kudu nggawé betyik marang liyané. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Lah nèk kowé namung nrésnani wong sing trésna marang kowé, aja njagakké upahé Gusti Allah, awit kowé ora ènèng bédané karo wong dosa. Wong-wong kuwi namung nrésnani wong sing trésna marang wong-wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Uga nèk kowé nggawé betyik marang wong sing nggawé betyik marang kowé, kowé aja njagakké upahé Gusti Allah, awit wong dosa ya nindakké ngono. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Lah nèk kowé namung ngutangi wong sing bisa nyaur, aja njagakké upahé Gusti Allah. Awit wong dosa ya ngutangi wong dosa, ngerti nèk bakal nampa menèh apa sing diutangké. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nanging kowé aja kaya ngono! Pada trésnaa marang mungsuhmu lan nggawéa betyik marang dèkné. Nèk ngutangi wong, aja mikir bakal disaur apa ora. Nèk kowé nindakké ngono, kowé bakal nampa upah sing gedé lan kowé bakal dadi anaké Gusti Allah sing luhur déwé. Awit Gusti Allah nggawé betyik marang wong sing ora ngerti dibetyiki lan marang wong sing ala. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mulané kowé kudu nduwé ati welas kaya enggoné Gusti Allah Bapakmu nduwé welas. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Aja maido liyané, supaya Gusti Allah ora maido kowé. Aja nyalahké liyané, supaya Gusti Allah ora nyalahké kowé. Ngapuraa liyané, supaya Gusti Allah ngapura kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pada pawèha marang liyané lan Gusti Allah ya bakal pawèh marang kowé. Kowé bakal nampa pawèhé Gusti Allah kanti lubèr, kanti tetel-tetel. Awit takeran sing mbok kanggokké kanggo liyané, ya takeran kuwi sing dikanggokké Gusti Allah kanggo kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Gusti Yésus uga ngekèki gambar ngéné: “Wong lamur apa bisa nuntun wong lamur liyané? Mesti ora! Mengko kabèh loro ketyemplung luwangan. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ora ènèng murid sing ngungkuli guruné. Nèk muridé wis tutuk sing sinau, dèkné bisa pada karo guruné. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kenèng apa kowé weruh klilip nang mripaté sedulurmu, nanging balok ing mripatmu déwé kowé ora weruh. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Lah kowé bisa ngomong karo kantyané: ‘Kéné klilip nang mripatmu tak buwangé,’ nanging balok nang mripatmu déwé kowé ora weruh. Kowé kuwi wong lamis. Balok sing nang mripatmu kuwi buwangen ndisik, supaya kowé bisa weruh mat lan bisa mbuwang klilip sangka mripaté wong liya.” ");
INSERT INTO jvnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Gusti Yésus neruské piwulangé ngéné: “Ora ènèng wit apik ngetokké woh sing ala. Semono uga ora ènèng wit ala ngetokké woh sing apik. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Saben wit kuwi ketarané sangka wohé. Kowé ora bisa ngepèk jambu sangka rerungkutan lan tukulan eri ora bakal ngetokké dreif. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wong betyik kuwi atiné ya mesti betyik lan bakal bisa ngetokké barang sing betyik sangka simpenané. Nanging wong ala kuwi atiné ya ala lan ya ngetokké barang sing ala sangka simpenané. Awit apa sing diomong kuwi metuné sangka mbludakké atiné.” ");
INSERT INTO jvnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Gusti Yésus terus ngomong ngéné: “Kenèng apa kowé kok nyeluk Aku: ‘Gusti, Gusti,’ nanging kowé ora nglakoni omongku? ");
INSERT INTO jvnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sapa waé sing teka nang nggonku, gelem ngrungokké tembungku lan nindakké piwulangku, wong iku kenèng tak padakké karo apa? Saiki arep tak omongi. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wong kuwi kenèng tak padakké karo wong nggawé omah. Wongé ngeduk luwangan jeru terus masang pondasiné nang watu. Nèk udané gedé lan banyuné laut ngantemi omahé, omah kuwi ora bisa rubuh, awit ngadek kentyeng nang watu. ");
INSERT INTO jvnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nanging wong sing ngrungokké piwulangku, mung ora dilakoni, kuwi kaya wong sing ngedekké omah tanpa pondasi. Kadung banyuné laut ngantem omahé, omahé rubuh, ambruk sak kabèhé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sakwisé rampung enggoné memulang marang wong-wong, Gusti Yésus terus mlebu nang kuta Kapèrnakum. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nang kono ènèng sakwijiné ofisir Rum sing nduwé slaf sing ditrésnani tenan. Slaf iki lara nemen, wis arep mati. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kadung ofisir mau krungu bab Gusti Yésus, dèkné terus kongkonan pengarepé wong Ju siji-loro nyuwun marang Gusti Yésus supaya teka nang omahé lan nambani slafé. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wong-wong sing dikongkon mau terus budal nang nggoné Gusti Yésus. Kadung wis tekan terus pada nyuwun banget marang Dèkné ngomong: “Mbok ofisir iki ditulungi ta, awit ora ènèng ilangé. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wongé trésna marang bangsané awaké déwé, wujuté dèkné nggawèkké sinaguk awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Gusti Yésus terus mèlu wong-wong mau. Kadung wis tyedek omahé, ofisiré terus kongkonan kantya-kantyané metuki Gusti Yésus, kongkon ngomong: “Guru, ora usah nglumui teka nang omahku. Aku ora pantes mbok dayohi. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aku déwé ya rumangsa ora pantes mara nang nggonmu. Mbok ngetokké tembung sak ketyap waé, mesti slafé bisa mari. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Awit aku déwé ya ing sak ngisoré penggedéku lan aku déwé uga nduwé soldat-soldat ing sak ngisorku sing kudu manut marang aku. Nèk aku mréntah sing siji ngomong: Kana lunga, wongé ya lunga lan liyané tak tyeluk: réné, wongé mesti teka. Nèk aku ngomong karo slafku: iki ditandangi, mesti ya ditandangi.” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Gusti Yésus nggumun krungu tembungé ofisir mau. Dèkné terus ndelokké wong-wong sing pada mèlu, terus ngomong: “Tenan, Aku durung tau tumon wong sing nduwé pengandel semono gedéné. Ing sak tengahé wong Israèl waé ora ènèng!” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kadung wis balik menèh, wong-wong sing dikongkon metuki Gusti Yésus mau terus pada weruh nèk slaf sing lara wis mari. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ora let suwi Gusti Yésus terus budal nang kuta Nain. Murid-muridé ya mèlu lan wong pirang-pirang pada ngetutké. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kadung Gusti Yésus wis mèh tekan lawangé kuta kono, kok ènèng wong mati dipanggul metu. Sing mati kuwi botyah enom, anak sing ora ènèng tunggalé. Ibuné wis randa. Wong pirang-pirang sangka kuta kono pada mèlu layat. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Gusti Yésus terus melas marang mbok randa mau, Dèkné krasa sedi uga. Mulané terus ngomong: “Aja nangis Bu!” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Gusti Yésus nyedeki bandosané terus didemèk. Wong-wong sing manggul bandosané pada mandek. Gusti Yésus terus ngomong: “Lik, Aku ngomong marang kowé, tangi!” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Botyah sing mati mau terus jenggèlèk njagong, terus molai ngomong. Gusti Yésus terus masrahké botyahé marang ibuné. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wong kabèh pada wedi terus ngluhurké Gusti Allah ngomong: “Enèng nabi gedé tangi nang tengahé awaké déwé. Gusti Allah wis teka arep nylametké umaté!” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kabar bab Gusti Yésus iki terus mrèmèn-mrèmèn nang bawah Yudéa sak kabèhé lan uga nang sak kiwa-tengené. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohanes krungu kabar bab Gusti Yésus sangka murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Dèkné terus nyeluk murid loro dikongkon nang nggoné Gusti Yésus kongkon takon ngéné: “Apa Kowé kuwi Kristus sing wis ketulis nèk bakal teka, apa awaké déwé kudu ngentèni wong liyané?” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kadung murid loro mau wis tekan nggoné Gusti Yésus, terus ngomong: “Yohanes Pembaptis sing ngongkon awaké déwé teka nang nggonmu kongkon takon apa Kowé kuwi Kristus sing kudu teka, apa awaké déwé kudu ngentèni wong liyané?” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ing waktu kuwi peneré Gusti Yésus ijik nambani wong pirang-pirang sing lara; demit-demit ditundungi lan wong sing lamur ditambani bisa weruh menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Gusti Yésus terus semaur ngéné marang wong loro mau: “Kana balik nang nggoné Yohanes. Kana diomongi bab apa sing kowé weruh lan krungu. Kana Yohanes diomongi nèk wong lamur bisa weruh menèh, wong lumpuh bisa mlaku menèh, wong lara lépra bisa resik menèh awaké, wong budek bisa krungu menèh, wong mati urip menèh lan kabar kabungahané Gusti Allah digelarké marang wong sing ora nduwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Beja wong sing ora mangu-mangu bab Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Sakwisé murid-muridé Yohanes lunga, Gusti Yésus terus ngomong ngéné bab Yohanes marang wong-wong: “Dongé kowé marani Yohanes nang wustèn kaé, sakjané kowé pada mikir bakal weruh apa? Apa ndarani bakal weruh damèn sing keterak angin rana-réné? Lak ya ora ta? ");
INSERT INTO jvnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Lah ndarani arep weruh apa? Apa wong sing nganggo salin sing larang. Wong-wong sing saliné apik-apik lan uripé adus banda kuwi manggoné nang palès. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lah kowé nang wustèn nggolèki apa? Apa pada kepéngin weruh nabi? Ya bener! Kowé malah weruh wong sing ngungkuli nabi. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Awit Yohanes kuwi kongkonané Gusti Allah sing tekané wis ketulis nang Kitab ngéné: ‘Gusti Allah ngomong: iki kongkonanku, sing tak kongkon budal ndisik nggawèkké dalan Kowé!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Gusti Yésus terus ngomong: “Tembungku iki dirungokké: ing sak tengahé wong kabèh ing donya kéné ora ènèng wong sing ngungkuli Yohanes Pembaptis. Nanging senajan ngono, wong sing tyilik déwé ing Kratoné Gusti Allah gedéné ijik ngungkuli Yohanes.” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wong kabèh sing krungu tembungé, uga wong-wong belasting, pada ngakoni nèk Gusti Allah bener lan pada njaluk dibaptis karo Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nanging para Farisi lan para guru Kitab pada nampik apa sing dikarepké Gusti Allah ing uripé. Mulané ora pada mèlu njaluk dibaptis karo Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Gusti Yésus terus ngomong menèh: “Wong-wong jaman saiki kenèng tak padakké karo apa ya? ");
INSERT INTO jvnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Eling-éling kaya botyah-botyah sing dolanan nang lataré pasar; sing sak krompol ngomong karo liyané: ‘Kowé tak mainké lagu kabungahan, nanging ora gelem njogèt; wis tak kidungké lagu kasusahan, kowé ora nangis!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Dongé Yohanes teka, dèkné pasa lan ora ngombé anggur, lah kowé ngomong jaréné Yohanes kelebon demit. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Lah nanging dongé Anaké Manungsa teka, Dèkné mangan lan ngombé, kowé ngomong: ‘Delokké kaé, wong murka lan tukang ngombé, kantyané wong belasting lan wong ala!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nanging Gusti Allah gedé kaweruhé lan kuwi diwujutké karo wong-wong sing pada nampa kaweruhé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sakwijiné wong Farisi, jenengé Simon, nyuwun marang Gusti Yésus teka lan mangan nang omahé. Gusti Yésus ya terus teka nang omahé Simon terus njagong. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nang kuta kono ènèng sakwijiné wong wédok sing nglakoni urip dosa. Kadung wong wédok iki krungu nèk Gusti Yésus merdayoh nang omahé Simon, wong Farisi, dèkné terus teka nggawa botol isiné lenga wangi. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wong wédoké terus ngadek nang mburiné Gusti Yésus, nang sebelah sikilé, terus nangis. Eluhé tumètès nelesi sikilé Gusti Yésus, terus dilapi karo rambuté. Wong wédok mau terus ngambungi sikilé Gusti Yésus, terus diusapi karo lenga wangi. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon, sing ngampirké Gusti Yésus, weruh sing ditindakké karo wong wédok kuwi terus nggagas: “Nèk Yésus kuwi nabi tenan, mesti Dèkné ya ngerti nèk wong wédok sing ndemèk sikilé kuwi wong dosa?” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mulané Gusti Yésus terus ngomong marang Simon: “Simon, aku arep nduwé omong setitik marang kowé!” Simon semaur: “Mangga Guru, mangga!” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tembungé Gusti Yésus marang Simon ngéné: “Enèng wong loro nduwé utang karo wong sing tukang ngutangi duwit. Sing siji utangé 500.000 pérak, sing liyané 50.000 pérak. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kabèh loro ora bisa mbayar utangé, mulané wong sing ngutangi duwité ngomong marang wong loro kuwi nèk wis ora usah mbayar utangé. Saiki Aku takon marang kowé Simon: Wong sing endi sing luwih gedé katrésnané marang wong sing ngutangi duwité?” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon semaur: “Tak kira ya wong sing luwih okèh utangé!” Gusti Yésus ngomong: “Kowé bener.” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Gusti Yésus terus ndelokké wong wédoké karo ngomong marang Simon: “Kowé weruh wong wédok iki! Dongé Aku mlebu nang omahmu, kowé ora nyawisi banyu kanggo wisuh sikil, nanging wong wédok iki nelesi sikilku nganggo eluhé terus diusapi karo rambuté. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dongé Aku mlebu omahmu Aku ora mbok ambung, nanging wong wédok iki ora lèrèn enggoné ngambungi sikilku, wiwit Aku teka nang omahmu. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kowé ora nglengani sirahku, nanging wong wédok iki nglengani sikilku karo lenga wangi. ");
INSERT INTO jvnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ngertia, katrésnané wong iki sing semono gedéné, ngétokké sepira gedéné dosané wongé sing wis dingapura karo Gusti Allah. Wong sing nampa pangapura mung setitik, katrésnané ya setitik.” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Gusti Yésus terus ngomong marang wong wédoké: “Dosamu kabèh wis dingapura.” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wong-wong sing bebarengan mangan karo Gusti Yésus terus pada rasan-rasan: “Wong kuwi sapa ta kok wani ngapura dosané manungsa?” ");
INSERT INTO jvnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nanging Gusti Yésus ngomong marang wong wédok mau: “Pengandelmu sing nylametké kowé. Wis, kana mlaku sing apik-apik.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ora let suwi Gusti Yésus mlaku turut kuta-kuta lan désa-désa, tujuané nggelarké kabar kabungahan bab Kratoné Gusti Allah. Rasul rolas uga mèlu. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kejaba para rasul uga ènèng wong wédok siji-loro sing mèlu, wong wédok-wédok sing wis ditambani karo Gusti Yésus sangka lelara lan pangwasané demit kayadéné: Maria, sing tyelukané Makdaléna, sing demité pitu wis dietokké. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Uga Yohanah, bojoné Kusah. Kusah kuwi ministeré ratu Hérodès. Semono uga Susanah lan wong wédok-wédok liyané pada mèlu Gusti Yésus. Wong wédok-wédok iki enggoné ngladèni Gusti Yésus lan para rasul disangga sangka sak nduwéné déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wong pirang-pirang sangka kuta-kuta kabèh pada teka terus. Kadung kabèh wis ngumpul, Gusti Yésus terus mulangi nganggo gambar ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Enèng sakwijiné wong budal nyebar. Sak barengé nyebar ènèng wiji sing tiba nang dalan, terus kepidek-pidek wong liwat lan uga ènèng sing dipangan manuk. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Enèng wiji uga sing tiba nang lemah atos. Kadung molai tukul terus garing, awit lemahé garing. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Enèng wiji liyané menèh tiba nang tengahé eri-eri. Kadung tukul terus ketyepit karo eri-eri mau, terus mati. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nanging uga ènèng wiji sing tiba nang lemah apik. Wiji iki terus tukul lan ngetokké woh okèh, atusan.” Gusti Yésus terus nutup tembungé kuwi ngomong ngéné: “Sapa sing nduwé kuping, rungokké sing apik tembungku mau.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Para rasul terus takon marang Gusti Yésus apa tegesé gambar wong nyebar kuwi mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Saurané Gusti Yésus: “Pituturé Kratoné Gusti Allah sing kasimpen wis diudarké marang kowé. Nanging wong-wong liya mung diwulangi nganggo tembung gambar, supaya, senajana nyawang, nanging ora weruh lan senajana krungu, nanging ora dunung.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Gusti Yésus terus ndunungké gambar wong nyebar mau ngéné: “Wiji kuwi pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wiji sing tiba nang dalan kuwi nggambarké wong sing krungu pituturé Gusti Allah. Nanging Sétan terus teka nyaut pitutur mau sangka atiné wongé. Dadiné wongé terus ora bisa pretyaya lan ora bisa nemu keslametan. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lah wiji sing tiba nang lemah atos kuwi nggambarké wong sing krungu pituturé Gusti Allah lan nampa karo bungah. Nanging pituturé ora ngoyot tenan, wongé sing pretyaya namung sedilut. Nèk kangèlan teka, wongé terus semplak pengandelé. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wiji sing tiba nang tengahé tukulan eri kuwi nggambarké wong sing ngrungokké pituturé Gusti Allah, nanging pitutur mau kalah karo rasa sumelang, kasugihan lan kesenengané donya. Dadiné pitutur mau ora bisa mrasuk ing ati lan ora bisa ngetokké pretyaya sing mantep. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lah wiji sing tiba nang lemah apik kuwi nggambarké wong sing ngrungokké pituturé Gusti Allah, terus mikir pitutur kuwi nganggo ati sing resik, terus dilakoni. Dadiné pitutur kuwi nukulké pretyaya sing mantep ing atiné wong kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Gusti Yésus neruské piwulangé ngéné: “Mosok ènèng wong nyumet dian terus dikrukupi ténggok apa didèkèk nang ngisor ambèn? Mesti ora. Diané mesti didèkèk nang méja, supaya sapa waé sing mlebu bisa weruh padangé. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Awit barang sing kasimpen mesti bakal metu lan prekara sing didelikké mesti bakal kétok lan dikabar-kabarké. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mulané, dipikir sing apik kepriyé enggonmu ngrungokké pitutur iki. Awit sapa sing wis nduwé bakal ditambahi, nanging sapa sing ora nduwé apa-apa malah bakal karebut apa sing dikira diduwèni.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gusti Yésus diparani karo ibuné lan sedulur-seduluré, nanging sangking okèhé wong, wong-wong kuwi ora bisa nyedeki Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Terus ènèng wong ngomongi Dèkné ngéné: “Guru, ibumu lan sedulur-sedulurmu nang njaba, kepéngin metuki Kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nanging Gusti Yésus semaur: “Ibuku lan sedulur-sedulurku kuwi kabèh wong sing ngrungokké lan nindakké pituturé Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ing sakwijiné dina Gusti Yésus lan murid-muridé pada numpak prau. Gusti Yésus ngomong marang murid-murid mau: “Hayuk pada ngabrah.” Terus budal. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nanging sak barengé ngabrah Gusti Yésus keturon. Lah terus dadakan waé nang mér kono ènèng ombak gedé teka. Prauné kelebon banyu sampèk medèni. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Murid-murid mau terus nggugah Gusti Yésus ngomong: “Guru, Guru, awaké déwé kelep!” Gusti Yésus terus tangi lan angin lan ombaké terus dipréntah kongkon mandek. Angin lan ombaké ya terus anteng. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Gusti Yésus terus ngomong marang murid-muridé: “Lah endi pengandelmu?” Murid-murid mau pada wedi lan nggumun banget, terus pada ngomong marang sakpada-pada: “Wong iki sapa ta, kok angin lan ombak manut marang tembungé?” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gusti Yésus lan murid-muridé pada numpak prau terus tekan bawah Gérasa, nang wétané bawah Galiléa. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kadung Gusti Yésus wis medun nang daratan terus ènèng wong lanang sing dikwasani demit marani Dèkné. Wong mau tekané sangka kuta lan ya wis suwi wongé ora nganggo salin lan ora manggon nang omah. Manggoné nang guwa-guwa sing dienggo ngubur wong mati. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kadung weruh Gusti Yésus wongé terus mbengok lan niba nang ngarepé, terus ngomong karo swara banter: “Yésus, Anaké Gusti Allah sing kwasa déwé, aku arep mbok kapakké? Aku nyuwun tenan, aku aja dipilara.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wongé ngomong ngono kuwi, awit demité wis dipréntah karo Gusti Yésus kongkon metu. Awit demité ajek ngèrèt-èrèt wongé. Wongé wis dilebokké nang setrapan lan diranté tangan lan sikilé karo wong-wong, nanging meksa bisa medot terus digawa karo demité nang wustèn. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Gusti Yésus terus nakoni wongé: “Sapa jenengmu?” Semauré: “Jenengku Légiun,” awit demit pirang-pirang manggon nang awaké wongé. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Demit-demit mau terus nyuwun marang Gusti Yésus, supaya ora ditundung mlebu nang jurangé wong mati. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tyedek karo panggonan kono ènèng babi pirang-pirang pada nggolèk pangan nang gunungan. Demit-demité pada nyuwun marang Gusti Yésus, supaya kelilan mlebu nang babi-babi kuwi. Gusti Yésus nglilani. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Demit-demité terus pada metu sangka wongé, terus pada mlebu nang babi-babiné. Babi-babi mau terus pada njegur nang mér sangka gunungan kono, terus pada mati. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wong-wong sing angon babi-babi mau weruh lelakon kuwi, terus pada mblayu nang kuta ngomong-omongké bab lelakon mau nang kuta kono lan désa-désa nang sak kiwa-tengené. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wong-wong sing krungu terus pada budal ndelok lelakon mau. Kadung marani Gusti Yésus terus pada weruh wongé sing mauné dikwasani demit. Wongé njagong nang sandingé sikilé Gusti Yésus, saiki wis nganggo salin lan sirahé wis waras. Wong-wong sing sangka kuta mau malah terus pada wedi. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Wong-wong liyané sing pada weruh déwé terus pada ngomongké bab enggoné Gusti Yésus nundung demit-demit sing ngwasani wong mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wong kabèh nang bawah Gérasa kono terus pada nyuwun banget marang Gusti Yésus, supaya lunga sangka panggonan kono, awit wong-wong pada wedi banget. Mulané Gusti Yésus ya terus numpak prau lunga sangka kono, arep balik nang panggonan sing ndisik. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wong sing mauné dikwasani demit terus nyuwun banget marang Gusti Yésus arep mèlu Dèkné. Nanging Gusti Yésus ora nglilani. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Gusti Yésus ngomong: “Kana kowé balik nang désamu waé lan wong-wong diomongi bab sing ditindakké karo Gusti Allah ing uripmu.” Wongé ya terus balik lan wong sak kuta kabèh diomongi apa sing ditindakké karo Gusti Yésus ing uripé dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kadung Gusti Yésus balik lan tekan nggoné, Dèkné dipetuk wong pirang-pirang sing pada bungah, awit wong-wong pantyèn wis ngarep-arep Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nang kono ènèng wong marani Gusti Yésus. Wongé jenengé Jairus, pengarepé sinaguk kono. Jairus niba nang ngarepé Gusti Yésus lan nyuwun banget marang Dèkné kongkon teka nang omahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jairus nduwé anak namung siji, anak wédok sing umuré rolas taun. Botyahé lara nemen, wis arep mati. Gusti Yésus terus budal nang omahé Jairus. Nang dalan wong-wong pada desek-desekan arep mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nang kono ènèng wong wédok sing wis rolas taun suwéné lara ngetokké getih. Bandané wis entèk kanggo mbayar dokter, nanging durung bisa mari. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wong wédok mau bisa nyedeki Gusti Yésus sangka mburi, terus ndemèk gombyoké saliné. Sakwat getihé mampet. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Gusti Yésus terus ngomong: “Sapa sing ndemèk Aku?” Jalaran ora ènèng sing ngaku, mulané rasul Pétrus terus semaur: “Gusti, wong sing ngesuk-esuk Kowé okèhé kaya ngéné iki, lah kok Kowé takon sapa sing ndemèk Kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nanging Gusti Yésus ngomong: “Enèng wong sing ndemèk Aku. Aku krasa, awit ènèng kekuwatan metu sangka awakku.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kadung wong wédok mau ngerti nèk konangan, wongé terus niba nang ngarepé Gusti Yésus. Nang ngarepé wong okèh kono wong wédok mau terus ngomong kenèng apa dèkné kok ndemèk saliné Gusti Yésus lan kepriyé enggoné dèkné bisa mari sakwat. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Gusti Yésus terus ngomong: “Bener kowé Wuk, pantyèn pengandelmu sing marakké kowé mari. Kana mlaku sing apik-apik.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Dongé Gusti Yésus ijik ngomong iku, kok ènèng wong teka sangka omahé Jairus terus ngomong: “Bapak Jairus ora usah ngrusui Guruné menèh, awit anaké wis ninggal!” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Gusti Yésus krungu kabaré wong mau, terus ngomong marang Jairus: “Jairus, aja bingung, ngandela waé, anakmu bakal mari.” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tekan omahé Jairus Gusti Yésus ora nglilani wong liyané mèlu Dèkné. Namung rasul Pétrus, Yohanes lan Yakobus lan wong tuwané botyahé éntuk mèlu mlebu. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wong-wong pada sedi lan pada nangisi botyahé. Gusti Yésus ngomong marang wong-wong kuwi: “Aja pada nangis. Botyahé ora mati, namung turu!” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wong-wong pada ngguyu, awit ngerti nèk botyahé wis mati tenan. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gusti Yésus terus nyekel tangané botyahé, terus dityeluk: “Wuk, tangia!” ");
INSERT INTO jvnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Botyahé terus urip menèh, terus sakwat ngadek. Gusti Yésus terus ngongkon ngekèki mangan botyahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wong tuwané botyahé nggumun banget. Nanging Gusti Yésus menging ngabar-ngabarké bab lelakon kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Gusti Yésus ngumpulké rasul rolas terus dikèki kekuwatan lan pangwasa, supaya bisa nundungi demit lan nambani wong lara. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Para rasul mau terus dikongkon budal ngabarké bab Kratoné Gusti Allah lan nambani wong sing lara. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Gusti Yésus ngomong ngéné: “Aja pada sangu apa-apa. Aja nggawa teken apa kantongan, pangan apa duwit apa salin sèrep. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nèk ènèng wong nampa kowé nang omahé, manggona nang omah kuwi tekané kowé lunga sangka kuta kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nèk kowé teka nang kuta sing ora gelem nampa kowé, lungaa waé sangka kuta kuwi. Lemahé diketok-ketokké sangka sikilmu, supaya wong-wong nang kuta kono ngerti déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Para rasul terus pada budal turut désa-désa, nggelarké kabar kabungahané Gusti Allah lan nambani wong lara. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hérodès, ratuné distrik Galiléa, krungu sakkèhé lelakon kuwi, terus bingung. Awit ènèng sing ngomong nèk Yohanes Pembaptis urip menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Liyané menèh ngomong jaréné nabi Elia teka menèh. Uga ènèng liyané menèh ngomong nèk sakwijiné nabi jaman mbiyèn urip menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hérodès ngomong: “Lah Yohanes wis tak ketok guluné. Lah wong iki sapa, kok aku krungu jaréné nindakké prekara-prekara kabèh kuwi.” Mulané Hérodès ya kepéngin weruh Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Para rasul saiki wis balik menèh lan pada ngabarké marang Gusti Yésus bab sembarang sing dilakoni. Gusti Yésus terus ngejèk para rasul lèrèn nang panggonan sing sepi nang kuta Bètsaida, supaya bisa karo para rasul déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nanging kadung wong-wong krungu, kabèh terus pada nututi. Gusti Yésus nampa wong-wong mau lan pada dipituturi bab Kratoné Gusti Allah. Sing lara pada diwaraské. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kadung wis soré para rasul terus mara nang nggoné Gusti Yésus ngomong: “Gusti, apa ora apik nèk wong-wong mbok kongkon lunga waé, supaya bisa nggolèk pangan lan inepan déwé-déwé nang désa-désa nang sak kiwa-tengené kéné, awit nang panggonan kéné ora ènèng apa-apa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Gusti Yésus semaur: “Ora, kowé sing kudu ngekèki mangan wong-wong!” Para rasul terus ngomong: “Lah kepriyé Gusti, awaké déwé namung nduwé roti lima lan iwak loro. Apa awaké déwé kudu nukokké pangan kanggo wong-wong kuwi kabèh?” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nang kono wong lanangé waé kira-kira ènèng limang èwu okèhé. Gusti Yésus terus ngomong marang para rasul: “Kana wong-wong dikongkon njagong, sak krompol wong sèket!” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Para rasul nuruti tembungé Gusti Yésus lan wong kabèh pada dikongkon njagong. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Gusti Yésus terus njikuk roti lima lan iwak loro mau. Sakwisé nyawang nduwur, roti lan iwaké terus diberkahi, terus dityuwil-tyuwil dikèkké marang para rasul, kongkon ngedum marang wong kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kabèh terus pada mangan sampèk warek. Turahané terus dilumpukké karo para rasul, ènèng rolas ténggok kebek. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ing sakwijiné dina Gusti Yésus ijik ndedonga déwé. Kadung murid-muridé teka, Gusti Yésus terus takon ngéné: “Wong-wong ngarani Aku iki sapa?” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Para murid terus pada semaur: “Enèng sing ngomong nèk Gusti kuwi Yohanes Pembaptis, liyané ngomong jaréné Gusti kuwi nabi Elia. Lah liyané menèh ngarani Gusti kuwi sakwijiné nabi jaman mbiyèn sing saiki urip menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Gusti Yésus terus takon menèh: “Lah miturut pinemumu déwé, Aku iki sapa?” Rasul Pétrus terus semaur: “Gusti, Kowé Kristus, sing dikongkon teka nang jagat karo Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Murid-murid mau terus pada diwanti-wanti, dipenging ngomongké bab kuwi mau marang wong liya. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Gusti Yésus ngomong: “Anaké Manungsa bakal nglakoni kasangsaran lan bakal ditampik karo para pinituwa, para pengarepé imam lan para guru Kitab. Dèkné bakal dipatèni, nanging ing telung dinané Dèkné bakal ditangèkké sangka pati.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Saiki Gusti Yésus terus ngomong marang wong kabèh: “Saben wong sing kepéngin dadi muridku kudu nyingkirké awaké déwé, saben dina kudu manggul pentèngané lan ngetutké Aku. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Awit sapa sing namung ngudi nggolèk kepénaké uripé, kuwi bakal kélangan urip sing sejati. Nanging sapa sing ngurbanké uripé kanggo Aku, kuwi sing nemu urip sing sejati. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Awit apa gunané wong bisa nduwèni donya iki kabèh, nanging rusak uripé lan kélangan nyawané? ");
INSERT INTO jvnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sapa sing isin ngaku nèk dadi muridku lan isin ngakoni nèk nurut piwulangku, Anaké Manungsa uga bakal isin ngakoni wong kuwi, mbésuk nèk Dèkné teka ing sloroté kwasané, kwasané Gusti Allah Bapaké lan para mulékat sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pada rungokna tembungku iki: ing sak tengahé wong sing nang kéné iki bakal ènèng sing ora mati sakdurungé weruh Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kira-kira seminggu sakwisé Gusti Yésus ngomongké bab prekara-prekara kuwi mau, Dèkné terus ngejèk rasul Pétrus, Yohanes lan Yakobus digawa munggah nang gunung arep ndedonga. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dongé ijik ndedonga, rupané Gusti Yésus malih lan saliné malih putih sumeblak. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ujuk-ujuk terus ènèng wong loro omong-omongan karo Dèkné, yakuwi nabi Moses lan nabi Elia. Kabèh loroné teka nganggo sloroté swarga. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sing dirembuk bab enggoné Gusti Yésus bakal nglakoni kasangsaran lan pati nang kuta Yérusalèm, ora suwi menèh, supaya apa sing wis dirantyam karo Gusti Allah bisa klakon kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Rasul Pétrus lan kantya-kantyané pada keturon. Kadung tangi terus pada weruh Gusti Yésus ing sloroté kwasané lan uga weruh wong loro liyané ngadek karo Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Rasul Pétrus weruh nèk nabi Moses lan nabi Elia arep lunga, mulané dèkné terus ngomong marang Gusti Yésus: “Gusti, kok ndilalah temen awaké déwé nang kéné. Apik nèk awaké déwé ngedekké gubuk telu: siji kanggo Gusti, siji kanggo nabi Moses lan siji kanggo nabi Elia.” Rasul Pétrus ngomong ngono kuwi, jalaran dèkné ora ngerti apa sing diomong. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Dongé rasul Pétrus ijik ngomong kuwi, terus ènèng méga teka nutupi wong-wong kuwi. Rasul Pétrus, Yohanes lan Yakobus pada wedi banget, awit wong-wong kuwi ilang nang mégané. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Terus ènèng swara sangka méga mau ngomong ngéné: “Iki Anakku sing wis tak pilih. Pada digugu tembungé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kadung swara mau wis meneng, sing kétok nang kono namung Gusti Yésus déwé, nabi Moses lan nabi Elia wis ora ènèng. Murid-murid mau ora tau ngomongké bab lelakon iki marang sapa waé. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ing ésuké Gusti Yésus lan para muridé medun sangka gunung. Wong pirang-pirang pada marani Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nang sak tengahé wong okèh kono ènèng wong lanang sing mbengok: “Guru, aku mbok ditulungi! Mbok anakku didelok iki, aku namung nduwé anak siji iki. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Botyahé nèk dikwasani demit terus ujuk-ujuk njerit-njerit, awaké terus kaku lan ngetyetyeng-ngetyetyeng lan tyangkemé metu umpluké. Demité jan milara botyahé tenan, tanpa lèrèn lan ora gelem ngetyulké. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aku wis njaluk tulung marang murid-muridmu, nanging ora bisa ngetokké demité.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Gusti Yésus terus ngomong: “Kok kebatyut tenan enggonmu ora pretyaya marang Gusti Allah. Sepira menèh suwéné enggonku kudu tyampur lan nyabari kowé? Botyahé gawanen mbréné!” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dongé ijik mlaku marani Gusti Yésus botyahé terus dibanting karo demité lan awaké terus ngetyetyeng-ngetyetyeng. Nanging Gusti Yésus terus nyentak demité. Botyahé terus diwaraské, terus dipasrahké marang bapaké. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wong kabèh pada nggumun weruh kwasané Gusti Allah sing semono gedéné. Wong-wong durung mari nggumuné bab lelakon-lelakon mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Gusti Yésus terus ngomong marang para muridé: “Pada rungokké sing apik tembungku iki. Anaké Manungsa bakal dielungké marang pangwasané manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nanging para murid ora pada dunung apa tegesé tembungé Gusti Yésus mau. Prekara kuwi pantyèn peteng kanggo para murid, dadiné ora ngerti apa tegesé. Nanging ora pada wani takon apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ing sak tengahé para muridé Gusti Yésus ènèng èngkèl-èngkèlan bab sapa sing penting déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Gusti Yésus ngerti pikirané murid-muridé, mulané terus nyeluk botyah tyilik siji, dikongkon ngadek nang jèjèré. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Gusti Yésus terus ngomong marang para murid ngéné: “Sapa sing nampa botyah tyilik iki ing Jenengku, wong kuwi nampa Aku. Lah wong sing nampa Aku kuwi uga nampa Gusti Allah sing ngongkon Aku. Awit sing tyilik déwé nang tengahmu kabèh, yakuwi sing gedé déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Rasul Yohanes ngomong ngéné marang Gusti Yésus: “Guru, awaké déwé weruh ènèng wong nundung demit nganggo Jenengmu. Awaké déwé menging wongé, awit wongé ora mèlu awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Gusti Yésus semaur: “Wongé aja dialang-alangi. Awit wong sing ora nglawan kowé, kuwi ngrujuki kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dinané enggoné Gusti Allah bakal njikuk Gusti Yésus mlebu swarga wis tyedek. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Saiki Gusti Yésus pantyèn wis nggawé putusan arep budal nang kuta Yérusalèm, mulané terus kongkonan wong budal ndisik. Wong-wong mau terus mlebu nang sakwijiné désa nang bawah Samaria, arep nggolèk inepan. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nanging wong-wong nang désa kono ora gelem nampa Gusti Yésus, awit wong-wong ngerti nèk sing dituju karo Gusti Yésus kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kadung murid loro, yakuwi rasul Yakobus lan Yohanes, weruh sing kaya ngono kuwi, terus pada ngomong marang Gusti Yésus: “Gusti, apa awaké déwé kelilan mujèkké wong-wong disamber bledèk waé, supaya mati kabèh!” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nanging Gusti Yésus minger mandeng murid-murid mau terus pada disenèni. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Gusti Yésus lan murid-muridé terus budal nang désa liyané. ");
INSERT INTO jvnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sak barengé mlaku arep nang désa liyané mau, ènèng wong ngomong ngéné marang Gusti Yésus: “Guru, aku arep mèlu Kowé nang endi waé!” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Saurané Gusti Yésus: “Asu alasan nduwé rong lan manuk nduwé susuk, nanging Anaké Manungsa ora nduwé panggonan kanggo nyèlèhké sirahé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Gusti Yésus terus ngomong marang wong liyané: “Hayuk mèlua Aku!” Nanging wongé semaur: “Gusti, aku dililani ngubur bapakku ndisik!” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tembungé Gusti Yésus: “Bèn wong mati ngubur sing mati, nanging kowé kana budal ngabarké bab Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Enèng wong liyané menèh ngomong marang Gusti Yésus: “Gusti, aku gelem mèlu Kowé, nanging aku tak pamitan marang brayatku ndisik!” ");
INSERT INTO jvnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nanging Gusti Yésus semaur: “Wong sing ngepluk sawahé, nanging nolèh mburi, wong kuwi ora pantes nyambutgawé ing Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Sakwisé kuwi Gusti Yésus terus miji murid menèh, pitung puluh loro okèhé. Murid-murid iki terus dikongkon budal bareng loro-loro, ndisiki Gusti Yésus, ngleboni saben kuta lan panggonan sing arep ditekani. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gusti Yésus ngomong marang murid-murid iki: “Sing kudu dienèni pantyèn okèh, nanging bauné setitik. Mulané, pada nyuwuna marang sing nduwé kebon, supaya ngongkon wong okèh kanggo nglumpukké panènané. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kana pada budala lan pada ngertia: Aku ngongkon kowé budal kaya tyempé nang tengahé matyan-matyan. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aja pada sangu duwit apa nggawa kantongan apa sepatu. Nèk nang dalan aja mandek mbagèkké wong. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nèk kowé mlebu nang sakwijiné omah, mbagèkké ngéné: ‘Tentrem-slamet marang omah iki.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nèk wong sing manggon nang omah kono seneng marang katentreman, pamujimu marakké wong-wong mau nampa katentreman. Nanging nèk wong-wong ora seneng marang katentreman, pamujimu bakal balik menèh marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nèk kowé ditampa nang sakwijiné omah, manggona terus nang omah kono. Pada mangana lan ngombéa apa sing disuguhké marang kowé, awit wong sing nyambutgawé wis sak mestiné nèk nampa upahé. Nanging aja ngolah-ngalih enggonmu nginep. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nèk kowé mlebu nang sakwijiné kuta lan wong-wong nang kono nampa kowé apik, mangana apa sing disuguhké marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wong lara sing nang kono pada diwarasna lan wong-wong pada diomongi ngéné: ‘Kratoné Gusti Allah wis nang tengahmu.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Nèk kowé mlebu nang sakwijiné kuta, nanging wong-wong nang kuta kono ora gelem nampa kowé, mlakua nang dalan-dalan lan ngomong: ‘Lemahé kuta iki, sing nèmpèl nang sikilku, tak ketok-ketokké nang ngarepmu, supaya kowé pada ngerti déwé. Aja lali nèk Kratoné Gusti Allah wis tyedek karo kowé.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pada ngertia, mbésuk ing dina kruton setrapané kuta Sodom ijik èntèng nèk dipadakké karo setrapané kuta sing nampik kowé kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Gusti Yésus terus ngomong ngéné: “Tyilaka kowé, kuta Korasim! Tyilaka uga kowé, kuta Bètsaida! Awit semunggoné nang kuta Sidon lan Tirus ènèng mujijat-mujijat kaya sing nang tengahmu, wong-wong nang kono mesti wis mbiyèn-mbiyèn pada ngakoni salahé lan pada nganggo salin sakah lan usapan awu sirahé kanggo tanda kasusahané. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mbésuk ing dina kruton kuta Tirus lan Sidon setrapané luwih èntèng nèk dipadakké karo setrapanmu. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Uga kowé sing manggon nang kuta Kapèrnakum! Apa kowé bakal dijunjung munggah swarga? Ora bakal! Kowé malah bakal dityemplungké nang panggonané wong mati.” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Gusti Yésus terus ngomong marang murid-muridé: “Sapa sing manut marang piwulangmu, kuwi uga manut marang Aku. Sapa sing nampik kowé, kuwi ya nampik Aku. Lan sapa sing nampik Aku, kuwi nampik Gusti Allah sing ngongkon Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Murid pitung puluh loro mau pada balik karo bungah. Pada ngomong ngéné: “Gusti, gèk demit-demit waé pada manut marang awaké déwé nèk awaké déwé nyeluk Jenengmu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Gusti Yésus semaur: “Aku weruh Sétan tiba sangka langit kaya klélapé bledèk. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pada diéling! Kowé wis tak kèki pangwasa ngidek-idek ula lan kalajengking lan uga ngalahké kekuwatané mungsuh. Ora ènèng apa waé sing bakal nggawé tyilakamu. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nanging, kowé aja pada bungah jalaran demit-demit manut marang kowé, luwung pada bungaha nèk jenengmu wis ketulis nang swarga.” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ing waktu kuwi Gusti Yésus bungah tenan ing atiné, jalaran kebek karo Roh Sutyi. Dèkné terus maturkesuwun marang Gusti Allah ngomong: “Bapakku, Gusti Allahé langit lan bumi, Aku maturkesuwun marang Kowé, awit Kowé nyimpen prekara-prekara iki kanggo wong pinter lan sing nduwé kaweruh, nanging mbok udarké kanggo wong sing tyilik. Pantyèn, kabèh iki mbok tindakké manut kekarepanmu lan senengmu déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Sembarang kabèh wis dipasrahké marang Aku karo Bapakku. Ora ènèng wong sing ngerti Anaké Gusti Allah kuwi sapa, namung Anaké Gusti Allah déwé sing ngerti lan ora ènèng wong ngerti Gusti Allah Bapaké, kejaba Anaké lan wong-wong sing wis dipilih karo Anaké supaya kenal marang Bapaké.” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Gusti Yésus terus ngomong, nanging namung marang murid-murid: “Kowé pantyèn wong sing beja banget, awit kowé weruh prekara-prekara kuwi karo mripatmu déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Awit pada ngertia: okèh nabi lan ratu pada kepéngin weruh prekara-prekara sing kowé weruh, nanging ora bisa. Uga pada kepéngin krungu sing mbok rungokké, nanging ora bisa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ing sakwijiné dina ènèng guru Kitab teka nang nggoné Gusti Yésus arep ngenèng Dèkné. Wongé ngomong ngéné: “Guru, aku kudu nglakoni apa bisané nampa urip langgeng?” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Gusti Yésus semaur: “Lah nang wèté Kitab ketulis kepriyé? Apa sing mbok watya nang kono?” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Guru Kitab mau terus semaur ngéné: “Pada trésnaa marang Gusti Allahmu sak atimu, sak nyawamu, nganggo sak ènèngé kekuwatanmu lan sak ènèngé pikiranmu. Uga, trésnaa marang pepadamu kaya enggonmu nrésnani awakmu déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Gusti Yésus ngomong: “Sauranmu kuwi pantyèn bener. Kuwi kudu mbok lakoni lan kowé bakal nampa urip langgeng.” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nanging guru Kitab mau arep mbenerké dèkné déwé, mulané terus takon marang Gusti Yésus: “Lah sing diarani pepadamu kuwi sakjané sapa ta?” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Gusti Yésus nyauri pitakonan kuwi ngéné: “Enèng sakwijiné wong medun sangka kuta Yérusalèm arep nang kuta Yériko. Nang dalan wongé dirampok maling terus digebuki pisan sampèk setengah mati terus ditinggal nang dalan. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ndilalahé ènèng imam liwat dalan kono. Nanging kadung dèkné weruh wong sing dirampok mau, malah terus mlipir nyimpangi wongé. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Uga ènèng wong Lévi liwat kono, nanging uga dèkné nyimpangé wongé. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Terus ènèng wong Samaritan sing lelungan, liwat dalan kono. Dèkné weruh wong sing dirampok mau terus melas banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wongé terus diparani, tatuné terus diusapi anggur lan dilengani, terus diperban. Sakwisé kuwi wongé terus ditumpakké kimaré dèkné, terus digawa nang omah penginepan lan dirumati nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ing ésuké wong Samaritan mau ngekèki duwit marang sing nduwé omah, tyukup kanggo ngrumati wongé sedina-rongdina, karo ngomong: ‘Wong iki dirumatké sing apik. Nèk aku balik ongkos-ongkos liyané bakal tak bayar kabèh.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gusti Yésus terus nutup tembungé nganggo pitakonan ngéné marang guru Kitab mau: “Miturut pinemumu, wong telu mau, sing endi sing dadi pepadané wong sing dirampok mau?” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Guru Kitab mau semauré: “Ya wong sing melas marang wongé!” Gusti Yésus terus ngomong: “Bener kowé, kana dilakoni ngono uga!” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ing sakwijiné dina Gusti Yésus lan murid-muridé teka nang sakwijiné désa. Nang kono ènèng wong wédok jenengé Marta. Marta ngampirké Gusti Yésus nang omahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta nduwé adik sing jenengé Maria. Maria njagong nyedeki Gusti Yésus, ngrungokké piwulangé. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nanging Marta ribut banget ngladèni dayoh-dayohé. Marta terus mara nang nggoné Gusti Yésus ngomong: “Gusti, mbok disawang ta! Adikku ora weruh nèk aku nyambutgawé ijèn. Mbok diomongi kongkon ngréwangi aku!” ");
INSERT INTO jvnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Gusti Yésus semaur: “Marta, Marta! Kowé kuwi répot mikirké barang pirang-pirang. ");
INSERT INTO jvnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nanging sing perlu kuwi namung siji. Malah Maria wis milih prekara sing apik déwé, sing ora bakal karebut sangka dèkné!” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ing sakwijiné dina Gusti Yésus ndedonga nang sakwijiné panggonan. Kadung wis rampung terus ènèng murid takon marang Dèkné: “Gusti, mbok awaké déwé diblajari ndonga ta, kaya enggoné Yohanes mulangi murid-muridé?” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","4","Gusti Yésus semaur ngéné: “Nèk kowé ndedonga, ngomong ngéné: ‘Bapaké awaké déwé nang swarga muga Jenengmu kasutyèkna. Muga kratonmu tumekaa lan kekarepanmu klakonana ing donya kayadéné nang swarga. Nyuwun rejeki saiki lan saben dina lan pangapura sangka ing dosa awit awaké déwé ya ngapura dosané wong liya. Nyuwun aja tyedekna panggoda nanging luwarana sangka ala.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Gusti Yésus terus ngomong ngéné marang murid-muridé: “Semunggoné nang tengahmu ènèng wong sing mbengi-mbengi nang nggoné kantyané nembung: ‘Mbok aku diselangi rotiné telu, awit ènèng kantya dolan terus mampir nang nggonku, nanging aku ora nduwé suguhan apa-apa.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Semunggoné kantya sing dijaluki tulung mau semaur: ‘Aja ngrusui aku, lawangé wis tak kantying lan aku lan anak-anakku wis turu. Aku ora arep tangi lan ngekèki apa-apa marang kowé.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Lah kuwi terus kepriyé? Ngandela, ora jalaran wongé kuwi kantyané terus sing dijaluki tulung mau bakal tangi lan ngekèki roti, ora. Nanging wongé bakal tangi, jalaran kantyané ora nduwé isin lan ngetyek sing njaluk tulung, mulané bakal dikèki penjaluké. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Mulané kowé pada élinga iki: nèk kowé njaluk, kowé bakal dikèki; nèk kowé nggolèk, kowé bakal nemu; nèk kowé totok-totok lawang, kowé bakal dibukakké. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Awit sapa waé sing njaluk bakal dikèki; wong sing nggolèk bakal nemu lan wong sing totok lawang bakal dibukakké. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Para bapak sing nang kéné, mosok nèk anakmu njaluk iwak arep mbok kèki ula? Mesti ora! ");
INSERT INTO jvnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mosok mbok kèki kalajengking nèk anakmu njaluk endok. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Lah nèk kowé waé, wong sing ala, bisa ngekèki barang sing apik marang anak-anakmu, lah Bapakmu sing nang swarga menèh. Dèkné mesti bakal ngekèki Roh Sutyi marang sapa waé sing nembung.” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ing sakwijiné dina Gusti Yésus nundung demit sing marakké wong bisu. Kadung demité wis metu, wongé terus bisa ngomong. Wong kabèh pada nggumun. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nanging ènèng siji-loro sing ngomong ngéné: “Yésus kuwi enggoné bisa nundung demit jalaran dikèki pangwasa karo Bèlsebul, ratuné demit.” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Uga ènèng liya-liyané sing arep njajal Gusti Yésus. Wong-wong kuwi nyuwun Gusti Yésus nggawé tanda pangwasa sangka swarga. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nanging Gusti Yésus ngerti pikirané wong-wong kuwi, mulané ngomong ngéné: “Nèk nang sakjeroné negara wongé pada tukaran, negara kuwi bakal bubrah. Semono uga brayat, nèk wongé tukaran karo sakpada-pada, brayat kuwi bakal bubrah. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nèk ing kratoné Sétan demité pada nglawan sakpada-pada, apa kraton kuwi bisa ngadek terus? Mesti ora. Aku ngomong ngono kuwi, jalaran kowé ngarani Aku jaréné enggonku nundungi demit nganggo pangwasané Bèlsebul. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Semunggoné enggonku nundungi demit nganggo pangwasané Bèlsebul, lah murid-muridmu kuwi enggoné nundungi demit nganggo pangwasané sapa? Dadiné murid-muridmu déwé nduduhké nèk pikiranmu kuwi klèru. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Enggonku nundungi demit kuwi sangka pangwasané Gusti Allah lan kuwi tandané nèk Gusti Allah wis molai ngétokké pangwasané nang tengahmu. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nèk ènèng wong rosa njaga omahé nganggo gaman sing pepak, barang-barangé wongé mesti ora bakal ilang. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nanging nèk wongé ditekani wong liyané sing luwih rosa, dèkné bakal dikalahké lan gaman-gamané sing dijagakké mau bakal dirampas lan barang nduwéné wongé bakal diedum-edum. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Sapa sing ora ngrujuki Aku, kuwi tegesé nglawan Aku lan sapa sing ora mèlu nglumpukké wedusé karo Aku, kuwi sing mbuyarké.” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Gusti Yésus neruské tembungé ngéné: “Nèk ènèng demit metu sangka sakwijiné wong, demit mau terus mlaku-mlaku turut panggonan sing ora kanggonan wong, nggolèk panggonan kanggo lèrèn. Nèk demit mau ora nemu panggonan kuwi, terus mikir: ‘Enaké tak balik nang omah sing wis tak tinggal kaé.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Demité terus balik nang omahé lan weruh nèk saiki wis resik lan ditata apik. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Demit mau terus lunga nggolèki kantyané, terus balik nggawa demit pitu sing alané ngungkul-ungkuli dèkné déwé. Demit-demit kuwi terus manggon ing wong mau. Entèk-entèké wong kuwi kasusahané malah ngungkul-ungkuli mauné, dongé namung kanggonan demit siji.” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sakwisé Gusti Yésus ngomong kuwi mau, terus ènèng wong wédok nang tengahé wong pirang-pirang kono ngomong banter: “Beja tenan wong wédok sing nglairké lan nyusoni Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nanging Gusti Yésus semaur: “Bener, nanging sing luwih beja kuwi wong sing ngrungokké lan nglakoni tembungé Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dongé ijik dirubung wong pirang-pirang Gusti Yésus ngomong ngéné: “Pantyèn ala tenan wong jaman iki. Pada njaluk tanda pangwasa sing nggumunké, nanging ora bakal éntuk. Namung bakal éntuk tandané nabi Yonah. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kaya enggoné nabi Yonah dadi tanda kanggo wong-wong nang kuta Ninewé, mengkono uga Anaké Manungsa ya bakal dadi tanda kanggo wong-wong iki. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mbésuk nèk Gusti Allah ngrutu manungsa, ratu wédok sangka bawah kidul bakal maju lan nyalahké wong-wong iki. Awit ratu kuwi wis teka sangka pojoké bumi, kepéngin ngrungokké kaweruhé ratu Soléman. Nanging ngertia, sing nang kéné iki gedéné ngungkuli ratu Soléman. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mbésuk, ing dinané nèk Gusti Allah ngrutu manungsa, wong kuta Ninewé bakal pada maju mbarang karo wong-wong iki lan bakal nyalahké wong-wong iki. Awit dongé wong Ninewé krungu tembungé Gusti Allah sing digelarké karo nabi Yonah, terus pada njaluk ngapura marang Gusti Allah lan pada ninggal laku ala. Pada ngertia, sing ngadek nang kéné gedéné ngungkuli nabi Yonah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Gusti Yésus neruské tembungé: “Mosok ya ènèng wong nyumet dian terus didelikké nang ngisor ambèn, apa ditutupi ténggok? Mesti ora ta! Diané mesti dipasang sing duwur, supaya kabèh wong sing mlebu bisa weruh padangé. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mripat kuwi diané awak. Nèk mripaté waras, awaké sak kujur ya padang njingglang. Nanging nèk mripaté buret, awaké sak kujur ya peteng ndedet. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mulané pada sing ati-ati, supaya pepadang sing ana ing kowé ora dadi peteng. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nèk awakmu padang sak kabèhé lan ora ènèng petengé blas, awakmu sak kujur ya bakal padang njingglang, pada waé kaya nèk kowé keslorotan padangé dian kaé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kadung wis rampung sing memulang, Gusti Yésus terus disuwun mangan nang omahé wong Farisi. Mulané Dèkné ya terus budal lan mangan nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nanging wong Farisi mau nggumun banget, awit weruh Gusti Yésus mangan, tanpa wisuh tangané ndisik. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mulané Gusti Yésus terus ngomong: “Bener wong Farisi, kowé pada misuhi njabané awakmu kaya nèk ngisahi njabané mangkok lan piring, nanging njeroné atimu kebek gagasan murka lan ala. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kowé wong bodo, Gusti Allah sing nggawé njaba, apa ya ora nggawé sing njero uga? ");
INSERT INTO jvnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Isiné mangkok lan piringmu kuwi kudu mbok kèkné wong sing ora nduwé, supaya kowé bisa resik sak kabèhé. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tyilaka kowé wong Farisi! Awit sangka tanduranmu bumbu-bumbu lan janganan-janganan waé kowé ngekèki prasepuluhané, nanging sing bener kanggo wong liya lan katrésnan marang Gusti Allah ora mbok perlokké. Sakjané kuwi sing kudu mbok perlokké ndisik lan liyané uga kudu mbok tindakké. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tyilaka kowé wong Farisi! Awit nèk nang sinaguk kowé njalukké njagong nang ngarep déwé, nang jagongané wong gedé, uga nèk nang pasar-pasar kowé njaluk diajèni. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tyilaka kowé! Awit kowé kuwi kaya kuburan sing ora ènèng tengerané, kuburan sing diidek-idek wong, awit ora ngerti nèk kuwi kuburan.” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Terus ènèng guru Kitab semaur: “Guru, ngono kuwi kowé ngèlèk-èlèkké awaké déwé mbarang!” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Gusti Yésus terus ngomong: “Kowé guru-guru Kitab, kowé uga wong tyilaka! Kowé numpangké momotan sing abot nang pundaké wong, lah nanging kowé déwé emoh ndemèk momotan kuwi karo drijimu. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tyilaka kowé! Awit kowé pada nggawèkké kuburan pengéling-éling kanggo para nabi, lah nanging mbah-mbahanmu déwé sing matèni para nabi kuwi dèk mbiyèn. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dadiné ngono kuwi kowé ngétokké nèk kowé setuju karo sing ditindakké karo mbah-mbahanmu dèk mbiyèn. Wujuté, wong-wong kuwi sing matèni para nabi lan kowé sing nggawèkké kuburan kanggo para nabi. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jalaran sangka kuwi, Gusti Allah ing kaweruhé ngetokké tembung ngéné: ‘Aku bakal ngongkon nabi-nabi lan rasul-rasul teka; ènèng sing bakal dipatèni lan ènèng sing bakal disiya-siya.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ngandela ta! Getihé para nabi sing mili wiwit jamané bumi digawé, tegesé wiwit getihé Abel, nganti tekan getihé nabi Sakarias, sing dipatèni nang sak tengahé altar lan Omahé Gusti Allah, kuwi kabèh bakal ditibakké marang para Farisi lan para guru Kitab iki. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tyilaka kowé, para guru Kitab! Awit kowé nyekel kuntyiné kaweruh bab wèt-wèté nabi Moses, nanging kowé déwé ora ngleboni, malah wong sing kepéngin ngerti isiné wèt-wèt kuwi mbok alang-alangi!” ");
INSERT INTO jvnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kadung Gusti Yésus wis lunga sangka kono, para Farisi lan para guru Kitab terus pada nesu banget marang Dèkné. Wong-wong mau pada ngetokké pitakonan pirang-pirang lan bab werna-werna prekara marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nanging sing dituju supaya Gusti Yésus ngetokké tembung sing klèru, sing kenèng dienggo jalaran kanggo nyekel Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ing waktu kuwi wong èwon-èwon pada nglumpuk sampèk esuk-esukan. Gusti Yésus terus memulang, nomer siji kanggo murid-muridé déwé. Tembungé Gusti Yésus ngéné: “Kowé kudu sing ati-ati tenan karo para Farisi sing étok-étokan, aja sampèk mrasuk marang kowé kaya ragi. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Awit sembarang sing ditutup-tutupi bakal kétok lan sembarang sing digawé simpenan bakal kebukak. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Apa sing mbok omong ing wayah mbengi bakal dirungokké ing wayah awan lan apa sing mbok omong alon-alon nang kamar kantyingan bakal dikabar-kabarké marang wong kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Gusti Yésus neruské piwulangé ngéné: “Kowé kuwi kantya-kantyaku! Aku ngomong marang kowé: aja wedi marang wong-wong sing bisa matèni awak, nanging sakwisé kuwi ora bisa ngapa-apakké kowé menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kowé tak omongi sapa sing kudu mbok wedèni. Pada wedia marang Gusti Allah, awit Dèkné nduwèni kwasa mbuwang kowé nang neraka, sakwisé matèni awakmu. Mulané pada élinga, Gusti Allah sing kudu mbok wedèni. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Manuk tyilik kaé nèk diedol pira regané? Nanging ora ènèng manuk tyilik siji waé sing Gusti Allah lali. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Malah rambut nang sirahmu waé Gusti Allah ngerti ènèng pira. Mulané aja wedi, ajimu kuwi ngungkuli manuk tyilik pirang-pirang.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Gusti Yésus neruské tembungé ngéné: “Pada ngandela marang sing tak omong iki! Sapa sing ngaku nang tengahé wong nèk dadi muridku, Anaké Manungsa uga bakal ngakoni dèkné nang ngarepé para mulékaté Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nanging sapa sing ngaku nang tengahé wong nèk ora kenal marang Aku, wong kuwi ya bakal tak sélaki nang ngarepé para mulékaté Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Sapa sing ngetokké tembung ala bab Anaké Manungsa, kuwi bakal dingapura. Nanging sapa sing ngetokké tembung ala bab Roh Sutyi ora bakal dingapura. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nèk kowé digawa nang sinaguk arep dikrutu karo penggedéné pasamuan lan para pangwasa, aja pada wedi kepriyé sing arep ngomong kanggo mbélani prekaramu. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Aja wedi, awit ing waktu kuwi Roh Sutyi bakal ngekèki tembung marang kowé, sing kudu mbok omongké.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nang tengahé wong okèh sing pada ngrungokké piwulangé Gusti Yésus kono ènèng siji sing ngomong ngéné marang Dèkné: “Guru, mbok sedulurku diomongi kongkon ngedum karo aku warisan tinggalané bapak.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Gusti Yésus semaur: “Kang, lah Aku kok mbok dadèkké tukang mratung warisan? Apa iku kerjananku?” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gusti Yésus terus mituturi wong kabèh sing nang kono: “Pada sing ati-ati, aja sampèk pada nduwé watek murka, awit senajan wong nduwé banda okèh, ora ngomong nèk wong kuwi nduwèni nyawané uga.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gusti Yésus terus ngekèki gambar ngéné: “Enèng sakwijiné wong sugih nduwé kebon okèh lan lemahé ya jan apik tenan. Mulané pametuné lemahé ya okèh banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Wong sugih mau terus rasan-rasan ing atiné: ‘Aku saiki kudu ngapa menèh ya? Aku wis ora nduwé panggonan menèh kanggo nyimpen pametuné kebonku. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Saiki apiké ngéné waé: magesèn-magesènku arep tak bubrahi kabèh, tak nggawé sing luwih gedé kanggo nyimpen pametuné kebonku lan uga barang-barangku liyané kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sakwisé kuwi aku terus bisa ngomong marang atiku: Aku wis ayem saiki. Simpenanku wis okèh, sampé dipangan pirang-pirang taun. Aku wis ora usah mikir apa-apa menèh. Garèk mangan, ngombé lan nuruti seneng.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nanging Gusti Allah ngomong ngéné marang wong mau: ‘Kowé kuwi wong bodo. Mbengi iki nyawamu bakal dijaluk. Lah sembarang sing wis mbok tyawis-tyawiské kanggo awakmu kuwi mengko sapa sing nduwèni?’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Gusti Yésus terus nutup pitutur mau karo tembung iki: “Ya kaya ngono kuwi lelakoné wong sing nglumpukké banda kadonyaan kanggo awaké déwé sampèk sugih banget, nanging kanggo Gusti Allah wong kuwi ora sugih blas.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Gusti Yésus terus ngomong ngéné marang murid-muridé: “Pada dirungokké sing apik pituturku iki: Aja pada sumelang bab uripmu, bab apa sing mbok pangan lan apa sing mbok enggo. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Uripmu kuwi ajiné ngungkuli pangan lan badanmu kuwi ajiné ngungkuli sandang. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mbok disawang manuk-manuk ireng kaé, lak ya ora nyebar apa panèn lan ora nduwé godang apa lumbung kanggo nyimpen pangan, nanging pada dikèki mangan karo Gusti Allah. Lah kowé kuwi apa ajiné ora ngungkul-ungkuli manuk-manuk kuwi? ");
INSERT INTO jvnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sapa nang tengahmu bisa nambahi umuré jalaran sangka enggonmu sumelang? Mesti ora ènèng. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Lah nèk prekara sing tyilik waé kowé ora bisa nindakké, kenèng apa kowé kok bingung bab prekara-prekara liyané? ");
INSERT INTO jvnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Disawang kembang-kembang sing tukul nang kebon kaé. Apa ya kerja apa nggawé salin? Lak ora ta. Nanging sawangen déwé, gèk ratu Soléman waé sing sugihé kaya ngono, ora nduwé salin sing apiké kaya kembang-kembang kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Semono uga suket sing nang kebon, sing dina iki tukul lan sésuk diobong. Kuwi waé diapik-apik tenan karo Gusti Allah. Lah kowé menèh. Gusti Allah mesti bakal nyandangi kowé ngungkul-ungkuli suket-suket kuwi. Nanging kowé pada tyilik pengandelé. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Mulané, aja pada sumelang lan aja pada bingung bab apa sing bakal mbok pangan lan mbok ombé. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Wong sing nggolèki barang-barang kuwi lak wong sing ora kenal marang Gusti Allah. Bapakmu nang swarga lak wis ngerti nèk barang-barang kuwi mbok butuhké. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sing kudu mbok perlokké ndisik yakuwi, Kratoné Gusti Allah lan kekarepané, mengko Dèkné bakal ngekèki kowé barang liya-liyané uga.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Gusti Yésus neruské piwulangé ngéné: “Kowé wedus sak krompol tyilik, aja pada wedi. Wis dadi kekarepané Bapakmu nang swarga ngekèkké kratoné marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Barang-barang nduwému pada edolana lan apa payuné kèkna marang wong sing ora nduwé. Pada nggawéa wadah duwit sing ora bisa rusak lan bandamu pada simpenen nang swarga. Nang kono kasugihanmu ora bakal kalong, awit ora bakal dityolong maling apa dipangan renget. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Awit nang endi bandamu, ya nang kono uga atimu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Gusti Yésus terus ngomong ngéné: “Kowé kudu sing jaga-jaga ngadepi prekara apa waé. Klambimu dienggo lan dianmu panjeren. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ora béda slaf sing ngentèni mulihé sing nduwé omah sangka nggoné wong nduwé gawé kawinan. Nèk sing nduwé omah teka lan totok-totok lawang, slafé gelis-gelis mbukakké. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Beja tenan slaf sing ketemu ijik melèk nèk sing nduwé omah teka. Ngandela, nèk sing nduwé omah mau wis salin, slafé bakal diejèk mangan bareng lan diladèni. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Malah-malah nèk sing nduwé omah mau tekané sampèk tengah wengi apa ésuk mruput lan slafé ijik pada melèk. Slaf sing kaya ngono kuwi jan beja tenan. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pada élinga, semunggoné wong sing nduwé omah ngerti jam pira tekané malingé, wongé mesti ora turu, supaya malingé ora mlebu omahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mulané kowé uga kudu pada tata-tata, awit Anaké Manungsa bakal teka ing waktu sing kowé ora mikir.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Rasul Pétrus terus semaur: “Gusti, enggonmu ngekèki pitutur nganggo gambar kuwi mau namung kanggo awaké déwé iki waé apa kanggo wong kabèh?” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Gusti Yésus terus ngomong: “Slaf sing kaya ngapa sing kenèng diarani slaf sing temen lan dunung? Ya slaf sing dipasrahi penjawab nata kantya-kantyané tunggal slaf, supaya ngekèki bagèané pangan marang slaf-slaf liyané nèk wis wayahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Beja tenan slaf sing ketemu ngerjani penggawéané kaya sak mestiné, wayahé sing nduwé omah teka. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pada ngandela, slaf kuwi bakal dipretyaya karo sing nduwé omah kongkon ngurusi bandané sak kabèhé. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nanging semunggoné slaf mau terus nduwé gagasan ing atiné: ‘Ah, sing nduwé omah ijik lunga suwi kok’ lan slaf mau terus ngeplaki slaf-slaf liyané sing lanang lan sing wédok, nanging dèkné déwé malah énak-énak mangan-ngombé sampèk mabuk, slaf mau bakal tyilaka. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Awit ing dina sing ora dijagakké sing nduwé omah bakal teka. Slaf mau bakal dipatèni lan didadèkké siji karo wong sing ora pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Slaf sing ngerti apa karepé sing nduwé omah, nanging ora tata-tata lan tyawis-tyawis, slaf kuwi bakal digebuki sak kuwaté. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nanging slaf sing ora ngerti kekarepané sing nduwé omah lan uga nindakké sing ora bener, slaf kuwi ya bakal disetrap, nanging setrapané bakal èntèng. Awit wong sing dikèki okèh bakal ditagih okèh. Semono uga wong sing dipasrahi prekara okèh, wong kuwi bakal dijaluki luwih okèh.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Gusti Yésus terus neruské tembungé: “Tekaku ngurupké geni nang bumi lan kaya ngapa ta kepénginku geni kuwi wis bisa murup. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nanging sakdurungé kuwi, Aku kudu kebaptis ndisik, Aku durung ayem nèk baptisan kuwi durung klakon. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Apa kowé pada mikir nèk tekaku ing donya kuwi nggawa katentreman? Blas ora! Malah tekaku ndadèkké tyongkrèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wiwit saiki nèk sak brayat ènèng wong lima, wong lima kuwi bakal tyongkrèh, sing telu tukaran karo sing loro lan sing loro tukaran karo sing telu. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kabèh bakal pada tukaran: bapak karo anaké lanang lan anak lanang karo bapaké, ibu karo anaké wédok lan anaké wédok karo ibuné, ibu maratuwa tukaran karo mantuné wédok lan mantuné wédok karo ibuné maratuwa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Gusti Yésus saiki terus ngomong marang wong kabèh: “Nèk kowé weruh mendung nang kulon, kowé mesti ngomong nèk arep udan lan ya terus udan tenan. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Lah nèk anginé teka kidul, kowé terus ngomong nèk bakal panas lan wujuté ya terus panas tenan. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kowé kuwi pantyèn wong lamis. Awit kowé bisa nitèni tanda nang langit lan tanda nang bumi, lah kenèng apa kowé kok ora bisa nitèni tanda-tandané jaman iki? ");
INSERT INTO jvnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kenèng apa kowé kok ora bisa ngarani déwé apa sing bener? ");
INSERT INTO jvnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nèk kowé digawa nang kruton karo sakwijiné wong, sakdurungé tekan kruton kowé mesti nglumui nggolèk dalan kepriyé bisané ngrampungké prekara karo wong liyané kuwi. Nèk ora ngono, wongé bakal masrahké kowé marang rèkter lan rèkteré bakal masrahké kowé marang sekaut sing bakal nglebokké kowé nang setrapan. ");
INSERT INTO jvnNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pada ngandela, kowé ora bakal metu sangka setrapan, nèk utangmu durung mbok bayar sak kabèhé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ing waktu kuwi ènèng wong sing pada ngomongké marang Gusti Yésus bab wong Galiléa sing pada dipatèni karo gramang Pilatus, dongé wong-wong kuwi ijik pada pasrah kurban marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Saurané Gusti Yésus: “Apa kowé mikir nèk wong Galiléa sing pada dipatèni kuwi dosané luwih gedé ngungkuli dosané wong Galiléa liya-liyané? ");
INSERT INTO jvnNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ora ngono! Pada ngertia iki, nèk kowé ora pada ninggal dosa-dosamu lan ora pada manut marang Gusti Allah, kowé uga bakal mati kaya wong-wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Lan menèh, wong wolulas sing pada mati kerubuhan putyuké Siloam kaé, apa kowé mikir nèk dosané wong-wong kuwi gedéné ngungkuli dosané wong-wong nang kuta Yérusalèm kabèh? ");
INSERT INTO jvnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ora ngono! Nanging nèk kowé ora nglakoni kauripan anyar, kowé uga bakal mati kaya wong-wong kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sakwisé kuwi, Gusti Yésus terus ngekèki piwulang nganggo gambar sing uniné ngéné: “Enèng wong nduwé wit anjir nang keboné. Wongé nggolèk wohé, nanging ora nemu siji-sijia. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mulané wongé terus ngomong ngéné marang tukang keboné: ‘Wis telung taun suwéné enggonku ngarep-arep wohé wit anjir iki, nanging ora tau metu siji-sijia. Wit iki ditegor waé, awit ora ènèng gunané urip, kejaba namung ngentèkké isiné lemah!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nanging tukang keboné semaur: ‘Gusti, mbok wité dililani urip setaun menèh. Lemahé mengko tak patyuli mubeng, terus tak kèki mès. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Menawa taun ngarep wit iki bisa metu wohé. Nèk ora, ya apiké suk ditegor waé.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ing sakwijiné dina sabat Gusti Yésus memulang nang sinaguk. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nang kono ènèng wong wédok wis wolulas taun suwéné dikwasani demit, marakké wongé gegeré ora bisa lempeng, dadiné bungkuk. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kadung Gusti Yésus weruh wong wédok mau, wongé terus dityeluk ngéné: “Bu, kowé saiki wis waras!” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Gusti Yésus terus numpangi tangan marang wong mau, terus sakwat gegeré bisa lempeng, mulané wongé memuji Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nanging pengarepé sinaguk kono malah nesu banget, terus muni-muni marang wong-wong sing nang kono, ngomong: “Enèng nem dina kanggo nyambutgawé. Nèk nggolèk waras, mbok teka ing dina-dina kuwi. Aja ing dina sabat.” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Gusti Yésus terus ngomong ngéné marang pengarepé sinaguk mau: “Kowé kuwi pantyèn wong lamis. Ing dina sabat kowé apa ora ngetokké sapi apa kimarmu digawa ngombé? ");
INSERT INTO jvnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lah iki ènèng wong wédok anak turunané Bapa Abraham. Wong iki wis wolulas taun suwéné dibanda karo Sétan. Mosok wongé ora éntuk diutyuli sangka ranténé Sétan ing dina sabat?” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sakwisé krungu tembungé Gusti Yésus, wong-wong sing pada nglawan mau abang kabèh sangking kisinan. Nanging wong-wong liyané pada bungah weruh lelakon sing nggumunké kuwi sing ditindakké karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Gusti Yésus terus ngomong: “Kepriyé enggonku nggambarké Kratoné Gusti Allah? Kenèng tak padakké karo apa? ");
INSERT INTO jvnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kratoné Gusti Allah kuwi kaya wiji sing tyilik banget. Wiji kuwi ditandur terus tukul dadi wit lan manuk-manuk pada nggawé susuk nang pangé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Gusti Yésus mulangi ngéné: “Kratoné Gusti Allah kenèng tak padakké karo apa? ");
INSERT INTO jvnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kratoné Gusti Allah kuwi kaya ragi. Enèng wong wédok njikuk ragi mau terus dityampurké glepung telung takeran, sampèk raginé mrasuk nang glepungé kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Gusti Yésus saiki budal nang kuta Yérusalèm, ngliwati kuta-kuta lan désa-désa. Nang panggonan-panggonan sing diliwati Gusti Yésus mulangi wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Terus ènèng wong takon marang Dèkné: “Guru, apa namung wong setitik sing nampa keslametan?” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Gusti Yésus semaur ngéné: “Pada ngudia mlebu liwat lawang sing tyiyut. Awit pada ngertia nèk wong okèh pada ngudi mlebu liwat lawang tyiyut mau, nanging ora bisa. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nèk wis tekan waktuné, sing nduwé omah bakal tangi nutup lawangé. Kowé bakal ngadek nang njaba totok-totok, ngomong: ‘Gusti, mbok dibukakké lawangé ta!’ Nanging sing nduwé omah bakal semaur: ‘Aku ora kenal kowé!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kowé bakal semaur: ‘Gusti, awaké déwé wis mangan lan ngombé bebarengan karo Kowé lan Kowé ya wis mulangi nang dalan-dalané awaké déwé!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nanging sing nduwé omah bakal semaur menèh, ngomong: ‘Aku ora kenal kowé! Pada lungaa sangka kéné, kowé sing pada nglakoni ala!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kowé bakal nangis nèk kowé weruh Bapa Abraham lan Isak lan Yakub lan para nabi kabèh ing Kratoné Gusti Allah, nanging kowé déwé bakal diusir metu sangka kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bakal ènèng wong pada teka sangka wétan lan kulon, sangka lor lan kidul lan pada mèlu pésta ing Kratoné Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pada élinga, ènèng wong sing tekané kèri, nanging mlebuné ndisik, lah sing tekané ndisik, nanging mlebuné kèri.” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ing waktu kuwi ènèng wong Farisi siji-loro mara nang nggoné Gusti Yésus lan ngomong: “Kana lunga sangka kéné, awit Hérodès arep matèni kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Gusti Yésus semaur: “Kana ngomong marang kantyil kuwi: ‘Dina iki lan sésuk Aku nundungi demit lan nambani wong lara, nanging ing telung dinané Aku bakal rampung penggawéanku.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Dadiné saiki, sésuk lan sésuké menèh Aku bakal neruské enggonku mlaku. Awit ora lumrah nèk nabi dipatèni nang panggonan liyané, kuduné nang Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yérusalèm, Yérusalèm! Kowé sing matèni nabi-nabi lan wong-wong sing dikongkon Gusti Allah nekani kowé pada mbok bandemi watu. Kaya ngapa enggonku saben-saben arep nglumpukké anak-anakmu, kaya pitik babon enggoné nglumpukké anak-anaké nang ngisoré swiwiné. Nanging kowé ora gelem. ");
INSERT INTO jvnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Saiki omahmu bakal ditinggal suwung. Kowé bakal ora weruh Aku menèh, nganti tekan waktuné kowé pada ngomong: ‘Kaberkahan sing teka ing jenengé Gusti!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ing sakwijiné dina sabat Gusti Yésus merdayoh nang omahé sakwijiné pengarepé wong Farisi arep pésta. Wong-wong sing nang kono kabèh pada nyawang marang tindak-tanduké Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Terus ènèng wong, sing tangan lan sikilé abuh, mara nang nggoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Gusti Yésus terus takon marang para guru Kitab lan para Farisi: “Kitab Sutyi nglilani wong lara ditambani ing dina sabat apa ora?” ");
INSERT INTO jvnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wong-wong ora semaur apa-apa. Gusti Yésus terus nyekel wong sing lara mau, terus diwaraské lan dikongkon lunga. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Gusti Yésus terus ngomong marang para guru Kitab lan para Farisi: “Nèk nang tengahmu ènèng wong sing nduwé anak apa nduwé sapi sing ketyemplung sumur ing dina sabat, mosok ora ndang ditarik munggah anaké apa sapiné ing dina sabat kuwi?” ");
INSERT INTO jvnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Para guru Kitab lan para Farisi ora bisa semaur apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Gusti Yésus nitèni nèk dayohé pada milih njagong nang ngarep déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Mulané Dèkné terus ngomong ngéné: “Nèk kowé diulemi nang kawinan, kowé aja njagong nang jagongan sing nang ngarep déwé. Awit menawa waé sing nduwé gawé wis ngulemi wong liyané sing luwih diajèni tenimbang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mengko wong sing ngulemi kowé kudu nyuwun kowé kongkon nggolèk jagongan liyané, awit jagongan kuwi wis dityawiské kanggo wong liya. Dadiné kowé bakal kisinan lan kepeksa njagong nang mburi déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mulané, nèk kowé diulemi, njagonga nang mburi déwé, supaya sing nduwé omah marani kowé lan nyuwun kowé: ‘Tak suwun njagong nang ngarep.’ Dadiné kétok nang ngarepé dayoh liya-liyané nèk kowé diajèni. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Awit sapa sing ngunggahké awaké déwé, kuwi bakal diedunké. Lah sapa sing asor, kuwi bakal diunggahké.” ");
INSERT INTO jvnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gusti Yésus terus ngomong marang wong sing ngulemi Dèkné: “Nèk kowé ngulemi wong diejèk pésta, senajana awan apa mbengi, aja namung ngulemi kantya-kantyamu apa sedulur-sedulurmu, apa krandah lan tangga-teparomu sing sugih. Awit wong-wong kuwi bakal mbales ngulemi kowé. Dadiné kowé nampa balesané penggawému. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nanging nèk kowé nganakké pésta, ngulemana wong sing mlarat, wong sing ora bisa mlaku, sing lumpuh lan sing lamur. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kowé mesti bakal nampa berkah, awit wong-wong kuwi ora bakal bisa mbales apa-apa marang kowé. Kowé bakal nampa upahmu sangka Gusti Allah, mbésuk nèk wong sing wis resik atiné bakal ditangèkké sangka pati.” ");
INSERT INTO jvnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Krungu tembungé Gusti Yésus kuwi mau, terus ènèng sakwijiné dayoh ngomong: “Beja tenan wong sing kelilan mèlu pésta ing Kratoné Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Gusti Yésus terus ngekèki gambar ngéné: “Enèng wong nganakké pésta gedé lan ngulemi wong okèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sakdurungé pésta mau diwiwiti, wongé kongkonan wong pada marani wong-wong sing diulemi, tembungé: ‘Hayuk pada teka, awit sembarang wis ditata.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nanging wong kabèh sing diulemi siji-siji pada nyuwun dingapura waé, awit ora bisa nekani. Wong sing ndisik déwé ngomong: ‘Aku entas tuku kebon. Saiki aku arep lunga ndelok keboné. Nyuwun ngapura waé, aku ora bisa teka.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wong sing liyané ngomong: ‘Aku entas tuku sapi limang jodo. Saiki aku arep mbrana njajal sapi-sapi mau kanggo nyambutgawé. Aku dingapura waé, ora bisa teka.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wong liyané sing diulemi ngomong: ‘Aku entas kawin, aku ora bisa teka.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Wong sing undang-undang mau terus balik lan ngomongi sing nduwé omah bab kuwi mau kabèh. Krungu tembungé sing undang-undang mau sing nduwé omah terus nesu banget, terus ngomong: ‘Saiki kana ndang pada lungaa nang dalan-dalan gedé lan tyilik nang kuta. Kana wong sing ora nduwé, sing ora bisa mlaku, sing lamur lan sing lumpuh pada digawa mbréné kabèh.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ora let suwi kongkonan mau balik lan ngomong marang sing nduwé omah: ‘Kongkonanmu wis tak lakoni, nanging jagongané ijik ènèng okèh.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Sing nduwé omah terus ngomong: ‘Kana lunga nang dalan-dalan nang sak njabané kuta lan saben wong diulemi, awit omahku kudu kebek. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngandela, wong sing pada tak ulemi sing ndisik mau, siji waé ora ènèng sing bakal mèlu ngrasakké suguhanku.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wong pirang-pirang pada gemruduk ngetutké Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Dèkné terus minger lan ngomong: “Sapa sing arep dadi muridku kudu gelem kélangan bapa-ibuné, bojo-anaké, seduluré lanang lan wédok, malah uga kudu saguh kélangan awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sapa ora manggul pentèngané déwé lan ngetutké Aku, ora bisa dadi muridku. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nèk nang tengahmu ènèng wong nduwé rantyaman ngedekké omah duwur, wong kuwi kudu ngitung ndisik pira kostuné. Dadiné ngerti, duwité tyukup apa ora kanggo ngostoni sak rampungé. ");
INSERT INTO jvnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Nèk ora ngono, wong mau sakwisé masang pondasi, terus ora bisa ngrampungké omahé duwur. Saben wong sing weruh mesti bakal ngguyu wongé lan ngomong: ‘Wong kuwi bisa molai ngedekké, nanging ora bisa ngrampungké.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Lan menèh, nèk ènèng ratu sing nduwé soldat 10.000 arep perang, jalaran diluruk ratu liyané sing nduwé soldat 20.000, apa ratu sing ndisik ora arep mikir-mikir balané tyukup apa ora kanggo nglawan mungsuhé? ");
INSERT INTO jvnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nèk kétok nèk ora bakal kuwat, ratu mau kudu kongkonan metuki ratu sing ngluruk. Pumpung mungsuhé ijik adoh, takon apa penjalukané, supaya ora usah perang.” ");
INSERT INTO jvnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Gusti Yésus terus nutup tembungé: “Semono uga wong bisa dadi muridku, namung nèk gelem kélangan sembarang nduwéné.” ");
INSERT INTO jvnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Gusti Yésus terus ngomong menèh: “Uyah kuwi pantyèn apik, nanging nèk ilang rasané, apa sing kenèng kanggo ngasinké? ");
INSERT INTO jvnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Uyah kuwi wis ora ènèng gunané, ora kanggo lemah, ora kanggo ngemès. Apiké namung dibuwang. Sapa sing nduwé kuping, pada dirungokké!” ");
INSERT INTO jvnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ing sakwijiné dina okèh wong belasting lan wong sing dianggep ala karo rayat, pada teka ngrungokké piwulangé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Wong Farisi lan para guru Kitab pada pating kedumel ngomong: “Yésus kok gelem nampani wong ala, malah mangan bareng karo wong-wong kuwi?” ");
INSERT INTO jvnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mulané Gusti Yésus terus ngekèki gambar ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Semunggoné nang tengahmu ènèng wong sing nduwé wedus gèmbèl satus, sing siji ilang. Apa wongé ora terus ninggal wedusé sing sangang puluh sanga nang pangonan lan lunga nggolèki wedus siji sing ilang, nganti ketemuné? ");
INSERT INTO jvnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nèk wis ketemu, wong mau bungahé ora ènèng entèké. Wedusé mesti terus dipanggul, digawa mulih. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tekan omah kantya lan tanggané bakal diundangi lan ngomong: ‘Hayuk pada bungah karo aku, awit wedusku sing ilang saiki wis ketemu.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngandela, kaya ngono uga kahanané nang swarga. Para mulékat bakal pada bungah banget, awit ènèng wong dosa siji sing ninggal dosané lan nglakoni urip anyar, ketimbang karo wong sangang puluh sanga sing ora usah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Gusti Yésus ngekèki gambar liyané sing uniné ngéné: “Enèng wong wédok nduwé duwit sepuluh pérak terus ilang siji. Wongé mesti terus nyumet dian lan nyaponi omahé, terus nggolèki njlimet, nganti duwit sing ilang mau ketemu. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nèk wis ketemu, wong wédok mau bakal ngundang kantya lan tanggané lan diomongi: ‘Hayuk pada bungah-bungah karo aku, awit duwit sing ilang wis ketemu.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ngandela, kaya ngono uga para mulékaté Allah bakal pada bungah-bungah, nèk ènèng wong dosa siji waé sing ninggal dosané lan nglakoni urip anyar.” ");
INSERT INTO jvnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Gusti Yésus neruské tembungé karo gambar liyané: “Enèng wong nduwé anak lanang loro. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Anak ragil ngomong karo bapaké: ‘Pak, aku njaluk bagèanku sangka sembarang sing arep mbok tinggalké aku.’ Bapaké terus ngedum apa nduwéné marang anaké loro. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ora let suwi anak sing ragil terus ngedol bagèané. Dèkné terus lunga nang liya negara, duwité digawa kabèh. Nang kana duwité diebrèh-ebrèh dienggo nuruti kesenengané, sampèk entèk kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nang negara kono ndilalahé ènèng kekurangan pangan sing gedé. Lah botyah mau wis ora nduwé apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Mulané dèkné terus mondok nang omahé wong kono, terus dikongkon kerja ngrumati babi. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Botyah mau kaliren lan kaya ngapa kepénginé mareki wetengé karo ampas pakané babi, nanging ora ènèng sing ngekèki. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Botyah mau terus éling lan mikir: ‘Bapakku nduwé wong kerja pirang-pirang lan kabèh bisa mangan sak wareké. Lah aku kok nang kéné kaliren. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Apiké aku tak balik nang nggoné bapakku, tak ngomong: Pak, aku nggawé dosa marang Gusti Allah lan marang Bapak. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aku wis ora pantes diarani anaké Bapak. Aku dianggep wong kerja waé.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Botyah mau terus ngadek lan budal nang nggoné bapaké. “Dongé ijik adoh, bapaké wis weruh dèkné. Bapaké terus melas banget, mulané terus dipapak, dirangkul lan diambungi. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Botyahé terus ngomong: ‘Pak, aku nggawé dosa marang Gusti Allah lan marang Bapak. Aku wis ora pantes diarani anaké Bapak.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nanging bapaké nyeluk peladèné terus dipréntah ngéné: ‘Ndang gelis dijikukké salin sing apik déwé lan dienggokké. Drijiné dienggoni ali-ali lan sikilé dienggoni sepatu. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Terus dijikukké pedèt sing lemu dibelèh. Hayuk awaké déwé pada nganakké pésta. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Awit anakku iki wis mati, saiki urip menèh; wis ilang, saiki ketemu!’ Wong sak omah terus pada bungah-bungah. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ing waktu kuwi anak sing mbarep ijik nang kebon. Kadung mulih lan wis tyedek karo omahé, dèkné krungu tabuan lan jogètan. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Botyah mau terus nyeluk sakwijiné peladèn ditakoni: ‘Nang omah ènèng apa?’ ");
INSERT INTO jvnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Peladèné semaur: ‘Adikmu wis mulih lan Bapak ngongkon mbelèhké sapi sing lemu déwé, awit anaké wis mulih kanti slamet.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Anak mbarep mau nesu banget sakwisé krungu tembungé peladèné. Dèkné ora gelem mlebu omah. Bapaké terus metu marani lan ngomongi anaké sing ijik nesu. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nanging anaké malah ngomong: ‘Pirang-pirang taun aku nyambutgawé setengah mati kanggo Bapak lan aku ora tau wani marang tembungé Bapak. Nanging Bapak apa tau ngekèki apa-apa marang aku. Wedus siji waé kanggo bungah-bungah karo kantya-kantyaku ora tau. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nanging anak ragil iki wis ngentèkké bandané Bapak kabèh kanggo médok, saiki ijik entas teka waé wis dibelèhké pedèt lemu karo Bapak.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Bapaké terus nyauri: ‘Enggèr anakku, kowé kuwi slawasé lak nang kéné karo aku. Apa nduwéku kuwi lak ya wis wèkmu. ");
INSERT INTO jvnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ing waktu iki awaké déwé kabèh kudu bungah-bungah, awit adikmu wis mati, urip menèh, wis ilang, ketemu!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Gusti Yésus ngomong marang murid-muridé: “Enèng wong sugih nduwé wong sing dadi penjawab banda. Wong sugih mau éntuk wadulan, nèk penjawab banda mau ngebrèh-ebrèh barangé wongé. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mulané penjawab banda kuwi terus dityeluk lan diomongi ngéné: ‘Aku krungu bab lakumu sing ora bener. Saiki kowé nggawé laporan bab mlebu-metuné banda sing tak pasrahké marang penjawabmu. Wiwit saiki kowé tak lèrèni enggonmu dadi penjawabé bandaku.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wong mau terus mikir: ‘Nèk aku dietokké, lah aku arep kerja apa? Matyul aku ora kuwat, ngemis aku ya isin. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Apiké ngéné waé. Nèk aku dietokké, aku kudu nduwé kantya sing gelem tak pondoki!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Wongé terus nyeluki saben wong sing nduwé utang karo wong sugih mau. Wong sing nomer siji ditakoni: ‘Utangmu pira?’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Saurané wongé: ‘Lenga olèf satus blèk!’ Penjawab banda mau terus ngomong marang wongé: ‘Iki layangmu utang. Kana njagong lan nggawéa layang liyané, ditulis 50 blèk!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wong sing nomer loro ditakoni: ‘Lah utangmu pira?’ Wongé semaur: ‘Gandum satus sakah!’ Penjawab banda mau terus ngomong: ‘Nya iki layang utangmu. Nggawéa layang liyané, ditulis 80 sakah.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Penjawab banda mau dielem karo sing nduwé banda enggoné nduwé akal ngono, awit wong kadonyaan nèk ngurus apa-apa akalé ngungkuli wong sing nurut Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Gusti Yésus terus ngomong: “Rungokké tembung-tembungku iki. Banda kadonyaan kuwi enggonen kanggo nggolèk kantya, dadiné nèk banda kuwi entèk, kowé bakal ditampani nang omah sing langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Sapa sing temen karo prekara sing tyilik, wong kuwi uga kenèng dipretyaya karo prekara sing gedé. Nanging sapa sing ora temen karo prekara sing tyilik, wong kuwi ya ora temen karo prekara sing gedé. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Dadiné, nèk kowé ora temen karo banda kadonyaan iki, sapa sing bakal pretyaya marang kowé karo banda kaswargan. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Lah nèk kowé ora temen karo barangé wong liya, sapa sing arep ngekèkké barangmu marang kowé? ");
INSERT INTO jvnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ora ènèng wong sing bisa ngrangkep ngladèni gusti loro. Awit wongé bakal sengit marang sing siji lan nrésnani liyané apa ngelem sing siji lan nyepèlèkké liyané. Kowé ora bisa ngawula marang Gusti Allah lan uga ngawula marang duwit.” ");
INSERT INTO jvnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Wong Farisi pada krungu apa sing diomong karo Gusti Yésus mau kabèh, mulané pada nyembranani Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nanging Gusti Yésus ngomong ngéné marang wong-wong kuwi: “Nang ngarepé manungsa kowé bisa ngomong nèk kowé kuwi bener, nanging Gusti Allah ngerti apa sing ana ing njeroné atimu. Awit apa sing dianggep pinunjul karo manungsa, kuwi dianggep asor karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Wèt-wèté nabi Moses lan kitab-kitabé para nabi kuwi kanggoné namung nganti jamané Yohanes Pembaptis. Wiwit waktu kuwi kabar kabungahan bab Kratoné Gusti Allah digelarké nang endi-endi. Wong pada ngudi sak kuwaté kepéngin mlebu ing Kratoné Allah mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Langit lan bumi kuwi malah gampang ilang, tenimbang ilangé tyetyek siji waé sangka wèté nabi Moses. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Sapa sing megat bojoné terus kawin karo liyané, wong kuwi laku bédang. Wong lanang sing kawin karo wong sing dipegat mau, kuwi ya laku bédang.” ");
INSERT INTO jvnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Gusti Yésus ngomong: “Enèng wong sugih sing nganggo salin sing apik banget lan dina-dina namung pésta-ramé. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Lan uga ènèng wong ngemis jenengé Lasarus. Lasarus awaké sak kujur gudiken, nglésot nang ngarep lawangé wong sugih mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lasarus kepéngin mangan turahané péstané wong sugih mau. Dèkné malah diparani asu-asu sing ndilati boroké. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ora let suwi Lasarus mati, terus nyawané digawa mulékat nang swarga, tyedek karo Bapa Abraham. Wong sugih mau uga mati terus dikubur. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nang kono wong sugih mau nandang sangsara sing gedé banget. Kadung ndelok menduwur, wong sugih mau weruh Bapa Abraham sangka kadohan lan Lasarus nang sebelahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wong sugih mau terus mbengok: ‘Duh Bapa Abraham! Mbok aku dimelasi. Mbok Lasarus dikongkon ngetylupké drijiné nang banyu lan nètèské banyu mau nang ilatku, awit aku ngrasakké lara nang geni murup iki!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nanging Bapa Abraham semaur: ‘Elinga Nggèr anakku, dongé kowé urip ing donya kowé wis nampa sembarang sing apik, nanging Lasarus namung nampa sing ora kepénak. Saiki gentèn Lasarus nang kéné kepénak, lah kowé nandang sing ora kepénak. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kejaba sangka kuwi, nang tengahé aku lan kowé ènèng jurang sing ora kenèng dilumpati. Wong sangka kéné ora bisa mbrono lan wong sangka kono ya ora bisa mbréné.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Wong sugih mau terus ngomong: ‘Nèk ngono, mbok aku nyuwun tenan, supaya Lasarus dikongkon marani omahé bapakku. ");
INSERT INTO jvnNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Awit aku ijik nduwé sedulur lima. Muga-muga sedulurku aja sampèk pada mlebu nang panggonan kasangsaran iki.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nanging Bapa Abraham semaur: ‘Sedulur-sedulurmu lak pada nduwé kitab-kitabé nabi Moses lan para nabi liyané ta? Ya kuwi sing kudu diturut!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wong sugih mau ijik meksa nyuwun: ‘Mbok ya ta Bapa Abraham, kuwi durung tyukup. Nanging nèk ènèng wong mati terus urip menèh lan marani sedulur-sedulurku, menawa terus pada ninggal urip dosa.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nanging Bapa Abraham semaur menèh: ‘Nèk sedulur-sedulurmu ora gelem ngrungokké piwulangé nabi Moses lan para nabi liyané, mesti ya ora bakal pada pretyaya, senajan ènèng wong mati tangi sangka kuburané lan ngomongi wong-wong kuwi!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Gusti Yésus ngomong marang para muridé: “Enèng prekara-prekara sing marakké wong tiba ing dosa, nanging tyilaka banget wong sing dadi jalarané. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Apiké wong sing kaya ngono kuwi dikalungi watu gilingan, terus dityemplungké nang segara. Apik ngono tenimbang wong kuwi marakké wong pretyaya sing ijik ringkih nggawé dosa. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mulané pada sing ati-ati! “Nèk sedulurmu nggawé dosa, diwelèhké. Nèk dèkné rumangsa getun enggoné nggawé dosa, dingapura. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Semunggoné sedulur kuwi nggawé dosa marang kowé sampèk ping pitu sedina lan ping pitu dèkné nang nggonmu njaluk ngapura, sedulur kuwi kudu mbok ngapura.” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Para rasul terus ngomong marang Gusti Yésus: “Gusti, awaké déwé nyuwun ditambahi pengandelé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Gusti Yésus semaur: “Nèk kowé nduwé pengandel sing gedéné sak wiji sing tyilik déwé, kowé bisa ngomong marang wit anjir iki: ‘Mbedola lan mantyepa nang segara,’ mesti wit mau bakal manut tembungmu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Gusti Yésus ngomong: “Semunggoné nang tengahmu ènèng sing nduwé slaf sing mbok kongkon ngepluk apa angon wedus, mosok nèk slaf mau mulih sangka penggawéané terus mbok omongi: ‘Kéné ndang mangan!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mesti ora ta! Kowé malah bakal ngomong: ‘Manganku ndang ditata! Nganggoa salin resik lan tunggoni enggonku mangan tekan rampungé. Sakwisé kuwi kowé kana mangan.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Slaf kuwi lak ora usah dielem enggoné manut préntahé sing nduwé omah? ");
INSERT INTO jvnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mengkono uga kowé. Nèk kowé wis nglakoni kabèh sing dipréntah, kowé nyebuta: ‘Aku iki namung slaf sing lumrah, namung nglakoni kuwajibanku.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dongé Gusti Yésus neruské lakuné nang kuta Yérusalèm, Dèkné ngliwati bawah kompasé distrik Samaria lan distrik Galiléa. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dongé Gusti Yésus mlebu nang sakwijiné désa ènèng wong lara lépra sepuluh marani Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Wong-wong mau ngadek lan bengok-bengok sangka kadohan ngomong: “Yésus, Guru, mbok awaké déwé dimelasi!” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Gusti Yésus weruh wong-wong mau terus ngomong: “Pada lungaa, awakmu diduduhké marang para imam.” Sak barengé mlaku wong-wong mau malih waras. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Enèng siji weruh nèk wis waras, terus balik karo memuji Gusti Allah nganggo swara banter. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wong mau terus sujut nang ngarepé Gusti Yésus lan maturkesuwun. Kuwi wong Samaritan. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Gusti Yésus ngomong: “Apa ora wong sepuluh sing diwaraské? Lah sing sanga nang endi? ");
INSERT INTO jvnNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Apa ora bisa teka maturkesuwun marang Gusti Allah? Kenèng apa kok malah namung wong sing dudu Ju iki sing balik?” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Gusti Yésus terus ngomong marang wong Samaritan mau: “Ngadeka, kana mulih, pengandelmu wis maraské kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Enèng wong Farisi siji-loro takon marang Gusti Yésus kapan enggoné Gusti Allah miwiti Kratoné. Gusti Yésus ngomong: “Kratoné Gusti Allah kuwi ora diwiwiti nganggo tanda-tanda sing kétok. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wong ora bisa ngomong: ‘Hé, delokké, iki Kratoné Allah!’ Apa: ‘Lah kaé nang kana!’ Awit Kratoné Allah kuwi nang tengahmu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sakwisé kuwi Gusti Yésus terus ngomong marang murid-muridé: “Bakal ènèng waktuné kowé pada kepéngin weruh dinané Anaké Manungsa, senajana namung sedina, nanging ora bisa. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mbésuk bakal ènèng wong sing ngomong marang kowé: ‘Lah kaé nang kana,’ apa, ‘Lah iki nang kéné!’ Kowé aja nggugu terus metu nggolèki. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Awit kaya klélapé bledèk sing semlorot nang langit sangka sebelah kéné tekan sebelah kana, mengkono uga tekané Anaké Manungsa ing dina gedé kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nanging Dèkné kudu nandang sangsara ndisik lan ditampik karo wong-wong jaman saiki. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mbésuk kahanané ing jaman tekané Anaké Manungsa pada waé karo kahanané ing jamané nabi Noah. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wong-wong pada mangan-ngombé, omah-omah, nganti tekan dinané nabi Noah mlebu nang kapalé lan udané gedé teka lan matèni wong kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Uga kaya dèk jamané Lot. Wong-wong pada mangan-ngombé, adol-tuku, nenandur lan nggawé omah. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nanging dongé Lot metu sangka kuta Sodom, ing dina kuwi uga geni lan lirang medun sangka langit ngobong wong kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kaya mengkono uga mbésuk bakalé kahanané dina tekané Anaké Manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Wong sing nang payoné omah ing dina kuwi aja medun mlebu nang omah njikuk barang-barangé. Semono uga wong sing ijik nang kebon, aja pada balik nang omahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pada élinga marang apa sing klakon karo bojoné Lot. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sapa sing ngudi nylametké uripé malah bakal kélangan urip sing sejati. Nanging sapa sing kélangan uripé malah bakal nampa urip sejati. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngandela Aku, ing wengi kuwi wong loro pada turu nang peturon, sing siji bakal kajupuk, sing liyané ditinggal. ");
INSERT INTO jvnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wong wédok loro ijik pada nggiling gandum, sing siji bakal dijikuk, sing liyané ditinggal. ( ");
INSERT INTO jvnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wong lanang loro ijik pada nang kebon, sing siji bakal dijikuk, sing liyané ditinggal.)” ");
INSERT INTO jvnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Para murid terus takon: “Nang endi Gusti?” Gusti Yésus semaur: “Ngendi ènèng batang, nang kono manuk gagak pada ngrompol.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sakwisé kuwi Gusti Yésus terus ngekèki gambar marang para muridé, supaya pada mantep ndedonga tanpa semplak. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Gusti Yésus ngomong ngéné: “Nang sakwijiné kuta ènèng rèkter sing ora wedi marang Gusti Allah lan ora perduli marang wong. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nang kuta kono uga ènèng randa sing bolak-balik teka nang nggoné rèkter kuwi njaluk apa beneré, enggoné nduwé karépotan karo wong liya. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Wis suwi rèkter mau ora gelem ngréwangi. Nanging entèk-entèké rèkter mau nggagas ngéné: ‘Senajan aku ora wedi marang Gusti Allah lan ora perduli marang wong, nanging jalaran randa kuwi teka waé ngrusui aku, apiké prekara iki tak urusané. Dadiné wongé ora bolak-balik teka waé lan mengko entèk-entèké ngamuk aku!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Gusti Yésus neruské tembungé: “Pada dirungokké tembungé rèkter sing sak karepé kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nèk umaté Gusti awan-wengi pada njaluk tulung, apa Gusti Allah ora terus bakal ngekèki apa beneré marang umaté? Mosok Dèkné ijik arep ngentèni suwi menèh enggoné nulungi? Mesti ora! ");
INSERT INTO jvnNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngandela, Dèkné bakal ndang ngekèki apa beneré. Nanging nèk Anaké Manungsa mbésuk teka, apa nang bumi kéné ijik ènèng wong sing nduwé pengandel?” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gusti Yésus terus ngekèki gambar liyané kanggo wong-wong sing nganggep awaké déwé wis apik lan ngepal marang liyané. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tembungé ngéné: “Enèng wong loro mlebu nang Gréja Gedé arep ndonga. Sing siji wong Farisi, sing liyané wong belasting. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Wong Farisi mau ngadek nang panggonan sing gampang kétok wong lan ndonga ngéné: ‘Duh Allah, aku maturkesuwun marang Kowé, awit aku ora kaya wong liya-liyané sing srakah, ngapusi, laku bédang lan ora kaya wong belasting kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Saben minggu aku pasa ping pindo lan aku pawèh prasepuluhé pametuku.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nanging wong belasting mau ngadek adoh, malah ndangak waé ora wani, namung ngantemi dadané karo sambat: ‘Duh Allah, aku wong dosa, mbok aku dimelasi!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ngandela, sak lungané sangka panggonan kono, pandongané wong belasting sing ditampa karo Gusti Allah, ora pandongané wong Farisi. Awit saben wong sing ngunggahké awaké déwé bakal diedunké, nanging wong sing ngedunké awaké déwé bakal diunggahké.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wong-wong pada nggawa anak-anaké sing ijik tyilik nang nggoné Gusti Yésus, supaya ditumpangi tangan lan diberkahi. Kadung para murid weruh kuwi terus pada nyenèni wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nanging Gusti Yésus nyeluk anak-anak ngomong: “Botyah-botyah kuwi mbok bèn mara nang nggonku. Aja dipenggak, awit Kratoné Gusti Allah kanggo wong sing kaya botyah-botyah iki. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Elinga, wong sing ora manut kaya botyah-botyah tyilik iki ora bisa mlebu ing Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Enèng sakwijiné pinuntuné wong Ju takon marang Gusti Yésus: “Guru sing apik déwé, apa sing kudu tak lakoni supaya bisa nampa urip langgeng?” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Saurané Gusti Yésus: “Kenèng apa kowé kok ngarani Aku apik? Ora ènèng wong siji waé sing apik, awit sing apik déwé namung Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kowé mesti wis ngerti angger-anggeré kabèh: aja laku bédang, aja matèni, aja nyolong, aja goroh lan ngajènana marang bapa lan ibumu!” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wongé semaur: “Angger-angger kuwi kabèh wis tak lakoni kawit tyilik.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sakwisé krungu tembung kuwi Gusti Yésus terus ngomong: “Ijik ènèng sak prekara sing kudu mbok lakoni, yakuwi, kabèh sak nduwému diedol lan duwité diedum-edumké marang wong sing ora nduwé lan kowé mesti bakal éntuk banda nang swarga. Sakwisé kuwi terus réné mèlua Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kadung krungu tembung kuwi wongé terus sedi, awit dèkné sugih banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gusti Yésus weruh nèk wongé susah banget, mulané terus ngomong: “Pantyèn angèl tenan kanggo wong sugih mlebu Kratoné Gusti Allah! ");
INSERT INTO jvnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Luwih gampang unta mlebu bolongané dom tenimbang wong sugih mlebu Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wong-wong sing ngrungokké tembungé Gusti Yésus mau terus takon: “Nèk ngono, lah sapa sing bisa slamet?” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Saurané Gusti Yésus: “Apa sing mokal kanggo manungsa ora mokal kanggo Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Rasul Pétrus terus ngomong: “Awaké déwé wis ninggal sembarangé awaké déwé lan mèlu Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Tembungé Gusti Yésus: “Bener! Lan ngandela, saben wong sing ninggal omahé, bojoné, seduluré lan bapa-ibuné, jalaran nglabuhi kratoné Allah, wong kuwi mesti bakal nampa balesan ping pirang-pirang ing jaman saiki lan nampani urip langgeng ing jaman tembé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gusti Yésus terus nyeluk murid sing rolas didèwèkké terus ngomong: “Pada titènana! Awaké déwé saiki lunga nang Yérusalèm lan kabèh sing wis ditulis karo para nabi bab Anaké Manungsa bakal klakon. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dèkné bakal dielungké marang wong sing dudu bangsa Ju lan bakal diolok-olok, disiya-siya lan diidoni. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Dèkné bakal dipetyuti lan dipatèni, nanging ing telung dinané dèkné bakal tangi menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nanging para murid ora dunung blas tegesé tembung kuwi mau kabèh, ora ngerti bab apa sing diomong karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dongé Gusti Yésus lakuné wis tyedek karo kuta Yériko ènèng wong lamur ngemis nang pinggir dalan. ");
INSERT INTO jvnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kadung wong lamur kuwi krungu swarané wong okèh liwat kono, dèkné terus takon: “Enèng apa ta?” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Enèng wong semaur: “Yésus sangka Nasarèt liwat kéné!” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wong lamur mau terus tyeluk-tyeluk: “Yésus, Anaké ratu Daved, aku mbok dimelasi!” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wong-wong sing nang ngarep kono pada nyenèni kongkon meneng, nanging wong lamur mau malah mundak banter sing tyeluk-tyeluk: “Anaké ratu Daved, aku mbok dimelasi!” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Gusti Yésus terus mandek lan ngongkon nggawa wongé nang nggoné Dèkné. Kadung wongé wis nang ngarepé, Gusti Yésus terus takon: ");
INSERT INTO jvnNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Aku arep mbok kongkon ngapa?” Wongé semaur: “Gusti, aku kepéngin weruh!” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Gusti Yésus terus ngomong marang wongé: “Ya, weruha! Pengandelmu sing maraské kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sakwat wongé bisa weruh. Wongé terus memuji Gusti Allah lan mèlu Gusti Yésus. Kabèh wong sing weruh lelakon kuwi mau uga pada memuji Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Gusti Yésus terus mlebu nang kuta Yériko lan mlaku-mlaku nang sak kuta kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nang kuta kono ènèng wong sugih jenengé Sakéus, penggedéné wong belasting. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakéus kepéngin banget weruh Gusti Yésus. Nanging dèkné tyendèk awaké lan jalaran kaling-alingan wong okèh, dèkné ora bisa weruh Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mulané Sakéus mblayu ndisiki terus mènèk nang wit anjir, supaya bisa weruh nèk Gusti Yésus liwat kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kadung Gusti Yésus mlaku tekan kono, Dèkné ndelok nduwur nang wité anjir terus ngomong marang Sakéus: “Sakéus, ndang medun! Awit ing dina iki aku arep mampir nang omahmu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakéus terus gelis-gelis medun lan nampa Gusti Yésus karo bungah. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wong kabèh sing weruh lelakon kuwi mau pada pating kedumel ngomong: “Lo, lah Dèkné kok gelem merdayoh nang omahé wong ala?” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakéus terus ngadek lan ngomong marang Gusti Yésus: “Gusti, bandaku sing separo arep tak kèkké kanggo wong sing ora nduwé lan sapa waé sing tau tak apusi bandané bakal tak balèkké ping papat.” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Gusti Yésus ngomong marang Sakéus: “Ing dina iki Gusti Allah nylametké kowé lan brayatmu kabèh. Kowé kuwi uga anak-turunané Bapa Abraham. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Awit Anaké Manungsa kuwi tekané nggolèki lan nylametké wong-wong sing ketriwal.” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Saiki Gusti Yésus wis mèh tekan kuta Yérusalèm, mulané okèh wong pada ngira nèk Kratoné Gusti Allah ora suwi menèh bakal kebabar ing donya. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Mulané Gusti Yésus terus ngekèki gambar marang wong-wong sing pada ngrungokké piwulangé. Tembungé: “Enèng wong gedé lunga nang negara adoh arep ditetepké dadi ratu nang kana. Sakwisé kuwi dèkné arep balik menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Sakdurungé budal wong gedé mau nyeluk slafé sepuluh. Saben slaf dipasrahi duwit emas siji. Tembungé: ‘Duwit iki kana dienggo dedagang nganti aku teka menèh.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jalaran rayaté negara kono sengit marang wongé, mulané pada kongkonan nusul, kongkon ngomong: ‘Awaké déwé ora gelem dikwasani wong iku.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Sakwisé wong gedé mau wis didadèkké ratu, dèkné terus balik nang negarané. Dèkné kepéngin ngerti kepriyé enggoné slafé pada dedagang, mulané pada dityeluk. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Slaf sing nomer siji mara ngomong: ‘Ratu, aku wis éntuk bati duwit emas sepuluh.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ratuné ngomong: ‘Apik banget, kowé slaf sing apik. Jalaran kowé kenèng dipretyaya karo prekara sing tyilik, saiki kowé tak angkat ngwasani kuta sepuluh.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Slaf sing nomer loro mara ngomong: ‘Ratu, karo duwit emas siji sing mbok pasrahké aku, aku éntuk bati duwit emas lima.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ratuné terus ngomong: ‘Apik banget, saiki kowé bakal tak pasrahi ngwasani kuta lima.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Slaf sing nomer telu mara ngomong: ‘Ratu, lah iki duwitmu, tak bundel nang katyu lan tak simpen. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aku wedi karo kowé, awit aku ngerti nèk kowé wong kereng. Kowé njikuk barang sing dudu wèkmu lan ngunduh sangka tanduran sing kowé ora nandur.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ratu mau terus ngomong marang slaf kuwi: ‘Kowé kuwi slaf sing ala, kowé bakal tak setrap miturut tembungmu déwé. Kowé wis ngerti nèk aku iku wong kereng, sing njikuk apa sing dudu wèkku lan ngunduh tanduran sing aku ora nandur. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nèk ngono tenan, kenèng apa duwit kuwi kok ora mbok dèkèk nang bank, supaya nèk aku balik aku bisa nampa duwitku sak rèntené?’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ratuné terus ngomong marang wong sing nang kono: ‘Duwité sing nang nggoné slaf kuwi dijikuk lan dikèkké marang slaf sing wis nduwé duwit emas sepuluh mau.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Wong-wong mau pada semaur: ‘Ratu, slaf kuwi lak wis nduwé duwit emas sepuluh, ta?’ ");
INSERT INTO jvnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Saurané ratuné: ‘Pada élinga, sapa sing nduwé bakal ditambahi, nanging sing ora nduwé, barang setitik nduwéné bakal dijikuk. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Saiki, digawa mbréné kabèh mungsuhku sing ora seneng nèk aku dadi ratuné. Wong kuwi pada patènana nang ngarepku!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sakwisé Gusti Yésus ngomongké kuwi mau kabèh, Dèkné terus budal nang Yérusalèm ndisiki wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kadung wis tyedek karo désa Bètfaké lan désa Bétani sing nang gunung Olèf, Gusti Yésus terus ngongkon murid loro kongkon mlaku ndisik. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Dèkné ngomong: “Kana mlebu nang désa nang ngarep kuwi. Kowé bakal weruh kimar enom dikentyang. Kimar kuwi durung tau ditumpaki wong. Diutyuli lan digawa mbréné. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nèk ènèng wong takon: ‘Kenèng apa kok mbok utyuli?’ Semaura: ‘Gusti mbutuhké.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Murid loro sing dikongkon mlaku ndisik mau terus budal. Lan sing diomong karo Gusti Yésus mau tyotyok kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dongé murid loro mau ijik ngutyuli kimaré, sing nduwé kimar ngluruh: “Lah kenèng apa kok mbok utyuli?” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Murid-muridé terus semaur: “Gusti sing mbutuhké.” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kimaré terus digawa nang nggoné Gusti Yésus. Murid-murid mau terus ngutyuli saliné, terus dilèmèkké nang gegeré kimaré. Gusti Yésus terus diangkat lan dijagongké nang kimaré. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sakwisé mlaku, murid-muridé terus pada njèrèng saliné nang dalan sing diliwati. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kadung wis tyedek karo kuta Yérusalèm, nang dalan sing medun sangka gunung Olèf, murid-muridé Gusti Yésus kabèh terus pada surak-surak karo bungah, memuji jenengé Gusti Allah, jalaran sangka sakkèhé mujijat sing pada weruh. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wong-wong mau surak-surak ngomong: “Nampaa berkah Ratu sing teka ing Jenengé Gusti! Katentreman nang swarga lan Gusti Allah nang nduwur sing kudu dipuji!” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wong Farisi siji-loro sing nang tengahé wong okèh kono terus ngomong marang Gusti Yésus: “Guru, mbok murid-murid kuwi dikongkon meneng!” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nanging Gusti Yésus semaur: “Nèk wong-wong kuwi meneng, watu-watu iki sing bakal surak-surak.” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kadung Gusti Yésus wis tyedek karo Yérusalèm lan weruh kutané, Dèkné mripaté metu eluhé. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tembungé: “Yérusalèm, kaya ngapa ta apiké semunggoné ing dina iki kowé ngerti apa sing mbok butuhké kanggo katentremanmu. Nanging tekan saiki kowé durung weruh. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bakal teka waktuné mungsuh-mungsuhmu bakal ngleboni kowé, nepung lan nyepit kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mungsuhmu kuwi bakal ngrusak kowé lan rayatmu kabèh nganti rata karo lemah. Watu siji waé ora bakal temumpang nang watu liyané, awit kowé ora nggatèkké marang tekané Gusti Allah sing arep nylametké kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Gusti Yésus terus mlebu nang Gréja Gedé lan nggurak wong-wong sing dodolan nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tembungé: “Nang Kitab Sutyi ènèng tulisan: ‘Omahku kuwi kanggo pamuji,’ nanging panggonan sutyi iki mbok dadèkké rongé maling.” ");
INSERT INTO jvnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","48","Gusti Yésus saben dina mulang nang Gréja Gedé. Para pengarepé imam, para guru Kitab lan para penuntuné bangsa Ju pada nggolèk akal arep matèni Dèkné, nanging ora bisa apa-apa, awit rayaté seneng ngrungokké piwulangé lan pada ketarik tenan karo Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ing sakwijiné dina Gusti Yésus mulang lan nggelarké kabar kabungahané Gusti Allah marang wong okèh nang Gréja Gedé. Para pengarepé imam, para guru Kitab lan penuntuné bangsa Ju pada mara. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Wong-wong kuwi takon marang Gusti Yésus: “Guru, apa Kowé bisa nduduhké sangka ngendi pangwasamu kanggo nindakké kabèh prekara kuwi? Sapa sing ngekèki pangwasa marang Kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Gusti Yésus terus ngomong: “Aku uga kepéngin takon marang kowé. Jajal ngomong! ");
INSERT INTO jvnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sapa sing ngekèki pangwasa marang Yohanes kanggo mbaptis wong? Gusti Allah apa manungsa?” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wong-wong terus pada rembukan. Sing siji ngomong marang liyané: “Kepriyé awaké déwé sing nyauri? Nèk awaké déwé ngomong: ‘Sangka Gusti Allah,’ mengko Dèkné bakal ngomong: ‘Lah kenèng apa kowé kok ora pada pretyaya marang Yohanes?’ ");
INSERT INTO jvnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nanging nèk awaké déwé ngomong: ‘Sangka manungsa,’ awaké déwé mengko dibandemi watu karo wong okèh iki, awit wong-wong kuwi kabèh nganggep Yohanes nabi.” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Dadiné wong-wong mau terus semaur ngéné marang Gusti Yésus: “Awaké déwé ora ngerti.” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Gusti Yésus terus ngomong: “Nèk ngono kowé ya ora tak omongi sapa sing ngekèki pangwasa marang Aku kanggo nindakké kuwi mau kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Gusti Yésus ngekèki gambar marang wong-wong mau, uniné: “Enèng wong nduwé kebon dreif. Keboné diséwakké marang wong tani. Sing nduwé kebon terus lunga adoh lan manggon nang kana sampèk suwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kadung wis wayahé ngunduh, sing nduwé kebon ngongkon slafé marani wong-wong sing pada nggarap keboné, kongkon njaluk bagèané sangka pametuné. Nanging wong sing dikongkon mau dipentungi karo wong sing nggarap keboné, terus dikongkon balik tanpa nggawa apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wong sing nduwé kebon terus ngongkon slaf liyané, nanging slaf iki uga dipentungi lan diolok-olok karo sing nggarap kebon, terus dikongkon balik tanpa nggawa apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sing nduwé kebon terus ngongkon slaf menèh, kaping teluné. Nanging kongkonan kuwi uga dipentungi terus dibuwang nang sak njabané kebon. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Entèk-entèké sing nduwé kebon mikir: ‘Saiki apiké kepriyé? Aku tak ngongkon anakku déwé waé, anak sing tak trésnani. Menawa wong-wong kuwi ngajèni marang anakku.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nanging kadung para penggarap kebon mau weruh anaké sing nduwé kebon teka, terus pada rembukan ngéné: ‘Anaké sing nduwé kebon iki énaké dipatèni waé supaya awaké déwé éntuk warisané.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wong-wong kuwi terus nyèrèt anaké sing nduwé kebon nang sak njabané kebon terus dipatèni.” Gusti Yésus terus takon marang wong-wong sing pada ngrungokké: “Saiki para penggarap kebon mau bakal dikapakké karo sing nduwé kebon? ");
INSERT INTO jvnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wis mesti nèk wong sing nduwé kebon dreif bakal teka lan matèni para penggarap lan keboné bakal diséwakké marang wong liya.” Kadung krungu tembungé Gusti Yésus mau, wong sing ngrungokké terus ngomong: “Iku ora bakal klakon!” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Gusti Yésus nyawang wong-wong mau terus ngomong: “Nèk ngono, apa ta tegesé ayat iki: ‘Watu sing ditampik karo wong sing tukang nggawé omah, awit dianggep ora ènèng gunané, yakuwi jebul watu sing apik déwé.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sapa sing tiba nang watu kuwi bakal ajur-mumur lan sapa sing ketiban watu kuwi bakal remuk.” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Para guru Kitab lan para pengarepé imam ngerti nèk gambar kuwi kanggo dèkné kabèh, mulané pada kepéngin nyekel Gusti Yésus ing waktu kuwi, nanging pada wedi karo wong okèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kekarepané mau terus diundurké ndisik, ngentèni waktu sing pener. Wong-wong kuwi terus pada kongkonan wong siji-loro sing dibayar, kongkon étok-étoké wong apik sing ngetokké pitakonan-pitakonan marang Gusti Yésus, tujuané namung kanggo ngenèng Dèkné. Dadiné nèk Gusti Yésus ngetokké tembung sing klèru, wong-wong nduwé jalaran kanggo nyekel Dèkné lan masrahké Dèkné marang gramangé. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wong-wong kongkonan mau terus ngomong ngéné marang Gusti Yésus: “Guru, awaké déwé ngerti nèk sembarang sing mbok wulangké lan mbok gelarké kuwi bener kabèh. Awaké déwé uga ngerti nèk Kowé ora wedi marang sapa-sapa, nanging namung nggelarké apa kekarepané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Saiki awaké déwé kepéngin ngerti bab iki: manut agamané awaké déwé iki mbayar belasting marang ratuné éntuk apa ora?” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Gusti Yésus ngerti nèk wong-wong kuwi nduwé tujuan sing ora apik, mulané Dèkné ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ndelok, Aku kepéngin weruh duwit pérak kéné. Kuwi ènèng gambaré sapa lan ènèng tulisané apa?” Wong-wong terus semaur: “Gambaré lan tulisané ratuné!” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Gusti Yésus terus ngomong: “Nèk ngono, kèkna marang ratuné apa sing wèké ratuné lan kèkna marang Gusti Allah apa sing wèké Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mengkono kuwi kétok nèk wong-wong kongkonan kuwi ora bisa ngenèng Gusti Yésus nang ngarepé wong okèh. Wong-wong pada nggumun lan ora wani ngomong apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Enèng wong Saduki siji-loro mara nang nggoné Gusti Yésus. Wong Saduki kuwi ora pretyaya nèk wong mati bakal tangi menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wong-wong iki takon marang Gusti Yésus: “Guru, nabi Moses wis ngekèki wèt marang awaké déwé kabèh ngéné: ‘Nèk ènèng wong lanang mati ninggal bojo tanpa nduwé anak, seduluré lanang kudu ngepèk randa sing ditinggal mati kuwi. Tujuané supaya nukulké turunan kanggo seduluré sing mati.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Saiki ènèng sedulur pitu. Sing mbarep kawin, nanging terus mati tanpa ninggal anak. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Randané terus diepèk karo adiké sing nomer loro. Dèkné uga mati. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Terus diepèk karo sing nomer telu. Mengkono kuwi mbok randané sampèk wis diepèk karo sedulur pitu kabèh, nanging pada mati tanpa ninggal anak. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Entèk-entèké randané ya mati pisan. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lah mbésuk nèk wong mati pada tangi, wong wédok kuwi dadi bojoné sing endi? Awit wong lanang pitu kuwi kabèh wis tau dadi bojoné wong wédok kuwi?” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Gusti Yésus terus semaur: “Ing donya kéné wong lanang lan wédok pada kawin. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nanging wong lanang lan wédok sing kaanggep pantes ditangèkké sangka pati lan urip ing jaman kelanggengan kuwi ora pada kawinan. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bakalé kaya mulékat, awit ora pada mati menèh. Wong-wong kuwi pada dadi anaké Gusti Allah, awit wis pada ditangèkké sangka pati. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nabi Moses déwé ngomongké kanti tyeta nèk wong mati bakal ditangèkké menèh. Nang tulisan sing ngomongké bab grumbul eri sing murup dèkné ngarani Gusti Allah: Gusti Allahé Abraham, Isak lan Yakub. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gusti Allah kuwi dudu Gusti Allahé wong mati, nanging Gusti Allahé wong urip. Awit kanggo Gusti Allah wong-wong kuwi kabèh urip.” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Enèng guru Kitab siji-loro sing ngomong: “Tembungmu kuwi pantyèn bener tenan, Guru.” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wong-wong mau wis ora wani takon apa-apa menèh marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Gusti Yésus terus takon marang wong-wong mau: “Lah kepriyé kok wong bisa ngarani Kristus kuwi turunané ratu Daved? ");
INSERT INTO jvnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Lah mangka ratu Daved déwé nang kitab Masmur ngomong ngéné: ‘Gusti Allah ngomong marang Gustiku: Kowé njagonga nang tengenku, nganti tekan waktuné mungsuhmu pada tak telukké marang kowé.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nèk ratu Daved nyebut Dèkné nganggo tembung Gusti, lah kepriyé Kristus kok uga dadi turunané?” ");
INSERT INTO jvnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dongé wong kabèh ijik ngrungokké marang Dèkné, Gusti Yésus ngomong marang murid-muridé: ");
INSERT INTO jvnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pada sing ati-ati karo para guru Kitab. Wong-wong kuwi pada seneng nganggo salin dawa, seneng dibagèkké karo wong-wong nang pasar. Nèk nang sinaguk apa nang pésta senengé milih jagongan sing kajèn. ");
INSERT INTO jvnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nanging wong-wong iki pada ngrampas omahé randa-randa lan kanggo mamèrké apiké pada ndedonga sampèk suwi banget. Wong-wong kuwi mesti bakal disetrap sing abot tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nang Gréja Gedé kono Gusti Yésus weruh wong sugih-sugih pada nglebokké duwit nang wadah duwit pawèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dèkné uga weruh ènèng mbok randa miskin nglebokké pawèhé duwit rètyèh loro sing tyilik banget ajiné. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Gusti Yésus terus ngomong: “Dititèni! Mbok randa miskin kuwi pawèhé luwih okèh tenimbang wong-wong liyané. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Awit wong liya-liyané kuwi enggoné pawèh njikuk sangka kalubèrané kasugihané. Nanging mbok randa miskin pawèh duwit kabèh sak nduwéné, sing dibutuhké kanggo ngrumat uripé déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Enèng wong siji-loro pada omong-omongan bab apiké Gréja Gedé, enggoné diapik-apikké nganggo watu-watu sing apik banget lan uga barang werna-werna sing disumbangké marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nanging Gusti Yésus ngomong: “Mbésuk bakal klakon, kabèh sing mbok sawang kuwi bakal ambruk, ora ènèng watu sing bakal temumpang nang watu liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wong-wong mau takon marang Gusti Yésus: “Guru, kapan prekara sing mbok omong kuwi klakon? Lah apa tandané sing nduduhké nèk prekara kuwi bakal teka?” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Gusti Yésus semaur: “Kowé pada sing awas, aja sampèk kenèng disasarké wong. Awit okèh wong sing bakal teka nganggo Jenengku. Wong-wong mau bakal ngomong: ‘Aku iki Kristus!’ lan ‘Saiki wis tekan wantyiné!’ Aja pada nggugu! ");
INSERT INTO jvnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kowé aja pada kagèt nèk krungu kabar bab peperangan lan pembruntakan. Awit kuwi kabèh wis pantyèn kudu klakon ndisik. Nanging kuwi durung entèk-entèkané jaman.” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Gusti Yésus terus neruské tembungé: “Bangsa-bangsa bakal pada peperangan, negara sing siji bakal nglawan negara sing liyané. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nang endi-endi bakal ènèng lindu sing nggegirisi, kurang pangan lan lelara, saiki nang kéné, sésuk nang kana. Uga bakal ènèng prekara-prekara sing nggegirisi lan sangka langit bakal ènèng tanda-tanda sing nggumunké. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nanging sakdurungé kabèh kuwi klakon, kowé bakal dityekel lan dipilara. Kowé bakal dikrutu nang sinaguk lan dilebokké nang setrapan. Kowé bakal digawa nang ngarepé para ratu lan para pangwasa, jalaran kowé nglabuhi Aku. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kuwi kelunggaran kanggo kowé ngetokké paseksimu bab Aku. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aja pada bingung sakdurungé bab kepriyé enggonmu kudu nanduki kanggo mbélani awakmu déwé. Pada élinga tenan bab kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Awit Aku déwé sing bakal ngekèki tembung lan kapinteran marang kowé, marakké mungsuhmu ora bakal bisa ngendek apa mbantah marang apa sing mbok omong. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kowé bakal dielungké karo bapa-ibumu, karo sedulur-sedulurmu lan kantya-kantyamu. Kowé bakal ènèng sing dipatèni uga. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kowé bakal disengiti karo wong kabèh, jalaran kowé nglabuhi Aku. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nanging rambutmu sakeler waé ora bakal ènèng sing kalong. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nèk kowé mantep pretyaya terus, kowé bakal slamet.” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Gusti Yésus neruské tembungé: “Nèk kowé weruh kuta Yérusalèm dikupeng karo soldat, pada ngertia, ora suwi menèh kuta kuwi bakal dirusak. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ing waktu kuwi wong-wong nang bawah Yudéa pada lungaa nang pegunungan. Wong-wong sing nang kuta pada metua sangka kuta lan wong-wong sing nang njabané kuta aja pada mlebu nang kuta. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Awit ing dina-dina kuwi Gusti Allah bakal netepké setrapané lan sembarang sing wis ketulis nang Kitab Sutyi bakal klakon. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Melaské tenan wong wédok sing meteng lan sing nduwé bayi. Awit negara iki bakal ngalami kasusahan gedé, jalaran Gusti Allah bakal nyetrap bangsa iki. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Enèng wong sing bakal dipatèni karo pedang lan ènèng uga sing dadi setrapan diboyong nang negara-negara liya. Wong-wong sing ora kenal marang Gusti Allah bakal ngidek-idek kuta Yérusalèm, nganti tekané waktuné sing wis ditetepké karo Gusti Allah kanggo bangsa kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Gusti Yésus neruské tembungé ngéné: “Mbésuk bakal ènèng tanda-tanda sing kétok nang srengéngé, mbulan lan lintang-lintang. Nang bumi bangsa-bangsa bakal pada bingung, jalaran sangka gemlegeré segara lan ombaké sing medèni. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Okèh wong bakal setengah mati wediné nèk pada mikir prekara-prekara sing bakal klakon nang jagat. Awit kekuwatan-kekuwatan sing nata lakuné jagat bakal utyul. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ing waktu kuwi wong-wong bakal weruh Anaké Manungsa teka nang méga nganggo kamulyan lan pangwasa gedé. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nèk kabèh kuwi molai klakon, pada ngadeka lan nyawanga nduwur, awit ora suwi menèh kowé bakal pada keluwaran.” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Gusti Yésus terus ngekèki gambar ngéné: “Pada titènana wit anjir lan wit apa waé. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nèk wité wis semi, kowé ngerti nèk wis nyedeki wayah panas. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mengkono uga, nèk kowé weruh prekara-prekara sing tak omong mau klakon, pada ngertia nèk Kratoné Gusti Allah wis tyedek. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Pada ngandela! Wong-wong sing urip ing jaman iki bakal pada menangi prekara-prekara kuwi mau kabèh klakon. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langit lan bumi bakal ilang, nanging tembungku bakal tetep terus slawas-lawasé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Gusti Yésus ngomong: “Jaganen awakmu déwé! Aja sampèk kowé namung mikirké bab sukak-sukak, mangan énak lan ombèn-ombèn waé. Lan aja kokèhan mikirké bab kabutuhané urip, mengko kadung dinané Gusti teka dadakan, kowé durung tata-tata. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Awit tekané dina kuwi kaya kala kanggo njiret wong sak jagat kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pada sing melèk lan pada tetep ndedongaa, supaya kowé dikèki kekuwatan bisa ngliwati kabèh sing bakal klakon kanti slamet lan bisa mara nang ngarepé Anaké Manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Gusti Yésus saben awan mulang nang Gréja Gedé, mbenginé munggah nang gunung Olèf nang sak njabané kuta. ");
INSERT INTO jvnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Saben ésuk wong kabèh pada teka nang Gréja Gedé, pada ngrungokké piwulangé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Saiki wis tyedek karo wayahé riyaya Pésta Roti Tanpa Ragi, sing diarani Paskah. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Para pengarepé imam lan para guru Kitab pada nggolèk akal arep matèni Gusti Yésus, awit wong-wong kuwi pada wedi karo rayaté. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sétan ngleboni Yudas Iskariot, sakwijiné rasul sangka rasul rolas. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudas terus marani para pengarepé imam lan para kumendané sekaut sing jaga Gréja Gedé, arep ngrembuk kepriyé enggoné dèkné nyekelké Gusti Yésus kanggo wong-wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Para pengarepé imam lan para kumendané sekaut mau pada bungah banget lan janji arep ngekèki duwit marang Yudas. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas setuju lan wiwit waktu kuwi dèkné nggolèk akal enggoné arep nyekel Gusti Yésus kanggo wong-wong kuwi, tanpa wong okèh weruh. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Saiki wis tekan dinané riyaya Pésta Roti Tanpa Ragi, yakuwi dinané wong-wong pada mbelèh tyempé kanggo riyaya Paskah. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Gusti Yésus ngongkon rasul Pétrus lan Yohanes, tembungé ngéné: “Kana pada tata-tata nyawiské kaperluané Paskah sing bakal dipangan awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Saurané rasul Pétrus lan Yohanes: “Lah karepé Gusti arep mangan Paskah nang endi?” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Gusti Yésus terus ngomong ngéné: “Rungokké! Nèk kowé mlebu nang kuta Yérusalèm, kowé bakal kepetuk karo wong sing nggawa kendi isi banyu. Wong kuwi dietutké tekan omah sing dileboni. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kowé terus ngomong marang sing nduwé omah: ‘Guru takon, Dèkné lan para muridé kudu mangan Paskah nang endi?’ ");
INSERT INTO jvnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sing nduwé omah bakal nduduhké kamar gedé nang nduwur sing wis pepak ènèng sembarangé. Pada tyawisna kaperluané Paskah kabèh nang kono.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Murid loro mau budal lan sembarang keturutan kaya sing diomong karo Gusti Yésus, terus pada nyawiské kaperluané Paskah nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kadung wis tekan wayahé mangan Paskah, Gusti Yésus terus njagong bebarengan karo para rasulé. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dèkné terus ngomong ngéné marang para rasul mau: “Aku kepéngin tenan mangan Paskah iki bebarengan karo kowé, sakdurungé Aku nandang sangsara. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Awit pada ngertia! Aku bakal ora mangan Paskah menèh, nganti tegesé Paskah iki keturutan ing Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sakwisé kuwi Gusti Yésus terus ngangkat mangkoké ombèn terus maturkesuwun marang Gusti Allah. Gusti Yésus terus ngomong marang para rasul: “Mangkok iki tampanana lan pada ngombéa. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Awit kowé tak omongi, wiwit saiki iki Aku bakal ora ngombé anggur menèh, nganti tekané Kratoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sakwisé ngono Gusti Yésus terus njikuk roti terus maturkesuwun marang Gusti Allah. Rotiné terus dityuwil-tyuwil terus dikèkké marang para rasul karo ngomong: “Roti iki badanku sing dikèkké kanggo kowé. Iki tindakké kanggo pengéling-éling marang Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Semono uga, sakwisé mangan, Dèkné terus ngekèkké mangkoké ombèn marang para rasul karo ngomong: “Mangkok iki prejanjiané Gusti Allah sing anyar, sing ditetepké nganggo getihku, yakuwi getih sing tumètès kanggo kowé. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nanging pada dirungokké! Wong sing arep nyekel Aku saiki nang kéné, njagong sak méja karo Aku! ");
INSERT INTO jvnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Anaké Manungsa pantyèn kudu mati, kaya sing wis dikarepké karo Gusti Allah, nanging tyilaka tenan wong sing nyekel Dèkné kanggo mungsuhé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Para rasul terus pada takon marang sakpada-pada, sapa sing arep nyekel Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Para murid pada èngkèl-èngkèlan bab sapa sing dianggep gedé déwé. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Gusti Yésus terus ngomong marang para murid mau: “Ratu-ratu ing donya kéné pada ngerèh rayaté lan para pangwasa mau diarani ‘Pembélané rayat.’ ");
INSERT INTO jvnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nanging kowé aja kaya ngono. Malah walikané: wong sing gedé déwé nang tengahmu kudu dadi sing tyilik déwé lan sing dadi pengarep kuwi kudu dadi kaya peladèn. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sapa sing luwih kajèn: sing njagong mangan apa sing ngladèni dèkné? Mesti sing njagong mangan ta? Nanging nang tengahmu Aku iki kaya peladèn. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Sakjeroné Aku nandang susah kowé slawasé tyampur karo Aku. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kaya enggoné Bapakku wis ngekèki pangwasa marang Aku nindakké kratoné, mengkono uga kowé bakal tak kèki pangwasa nindakké kratonku. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kowé bakal mèlu mangan lan ngombé karo Aku ing kratonku lan kowé bakal pada njagong nang damparé kraton mau, ngrutu bangsa Israèl turunan rolas.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Gusti Yésus terus ngomong marang Simon: “Simon, Simon! Sétan dililani karo Gusti Allah njajal pretyayamu sak kabèhé, kaya wong tani ngayaki gandumé, dipisah sangka rambuté. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nanging kowé wis tak dongaké, supaya pretyayamu ora nganti semplak. Lah nèk kowé wis ngakoni salahmu lan balik menèh, kowé kudu gentèn nguwatké pengandelé sedulur-sedulurmu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Saurané rasul Pétrus: “Gusti, aku saguh disetrap lan mati bareng karo Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Gusti Yésus terus ngomong: “Pétrus, ngandela! Ing dina iki, sakdurungé jago kluruk, kowé bakal ngomong ping telu, nèk kowé ora kenal marang Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Gusti Yésus terus ngomong marang para muridé: “Dèk mbiyèn dongé kowé tak kongkon budal kaé, kowé ora tak lilani nggawa dompèt isi duwit, kantongan lan sepatu. Apa kowé pada kekurangan apa-apa? Lak ora ta?” Saurané para murid: “Ora Gusti, awaké déwé ora kekurangan apa-apa!” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Gusti Yésus terus ngomong: “Nanging saiki, sing nduwé dompèt lan kantongan kudu digawa; sing ora nduwé pedang kudu ngedol jasé kanggo tuku pedang. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Awit, pretyayaa! Tulisan nang Kitab sing uniné: ‘Dèkné bakal dianggep wong ala,’ bakal klakon karo awakku. Lan apa sing ketulis kuwi saiki klakon tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Para murid terus semaur: “Gusti, lah iki ènèng pedang loro.” Gusti Yésus ngomong: “Wis tyukup!” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Gusti Yésus terus metu sangka kuta Yérusalèm lan kaya lumrahé Dèkné munggah nang gunung Olèf. Para murid pada mèlu. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kadung wis tekan nggoné, Gusti Yésus ngomong: “Pada ndedongaa supaya ora kenèng panggoda.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Gusti Yésus terus mlaku rada adoh sangka kono, kira-kira adohé sak balangan watu. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Dèkné terus sedeku ndonga ngomong: “Duh Bapakku, nèk Kowé gelem, mbok kasangsaran iki disingkirké sangka Aku! Nanging, aja sampèk kekarepanku, nanging kekarepanmu sing kudu keturutan.” ( ");
INSERT INTO jvnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Terus ènèng mulékat sangka swarga ngétok marang Gusti Yésus lan nguwatké Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gusti Yésus jan wedi banget, mulané terus tambah tenanan sing ndedonga. Kringeté sampèk kaya getih tumètès nang lemah.) ");
INSERT INTO jvnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kadung wis rampung enggoné ndedonga, Gusti Yésus terus marani murid-muridé. Murid-murid mau ketemu ijik pada turu, sangking sediné. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Gusti Yésus terus ngomong: “Kenèng apa kowé kok pada turu? Pada tangia lan ndedongaa, supaya ora kenèng panggoda.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Dongé Gusti Yésus ijik ngomong karo murid-muridé, terus ènèng wong sak rombongan teka. Wong-wong kuwi digawa karo Yudas. Yudas terus marani Gusti Yésus arep ngambung Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nanging Gusti Yésus ngomong: “Yudas, apa enggonmu nyekel Anaké Manungsa nganggo ambung iki?” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kadung murid-muridé Gusti Yésus weruh lelakon kuwi terus ngomong: “Gusti, apa éntuk diantem karo pedang waé?” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sakwijiné murid terus nyabet slafé Imam Gedé karo pedang, sampèk kupingé sing tengen tyepol. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nanging Gusti Yésus ngomong: “Wis, seméné waé!” Kupingé wongé terus didemèk, terus bisa waras menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Gusti Yésus terus ngomong marang para pengarepé imam lan para kumendané sekauté Gréja Gedé lan para penuntuné bangsa Ju sing pada teka nang kono arep nyekel Dèkné: “Apa Aku iki mbok kira wong nakal, kok arep nyekel Aku nganggo pedang lan pentung? ");
INSERT INTO jvnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Apa Aku saben dina ora nang Gréja Gedé karo kowé. Kenèng apa Aku kok ora mbok tyekel nang kono? Nanging pantyèn wis tekan waktumu lan waktuné pangwasané pepeteng tumandang.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sakwisé Gusti Yésus dityekel, Dèkné terus digawa nang omahé Imam Gedé. Rasul Pétrus ngetutké sangka kadohan. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wong-wong pada nggawé bediyang nang tengahé latar kono terus pada njagong ngubengi bediyangé. Rasul Pétrus terus mèlu njagong nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sakwijiné slaf wédok weruh rasul Pétrus nang padangé geni, terus ngematké dèkné karo ngomong: “Wong kuwi uga mèlu Yésus!” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nanging rasul Pétrus sélak ngomong: “Aku ora kenal blas karo wong kuwi!” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ora let suwi ènèng wong liyané weruh rasul Pétrus terus ngomong: “Kowé uga muridé Yésus!” Nanging rasul Pétrus semaur: “Ora, dudu aku!” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kira-kira let sak jam ènèng wong liyané menèh sing ngomong banter: “Pantyèn wong kuwi muridé Yésus, awit dèkné ya wong Galiléa!” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nanging rasul Pétrus semaur: “Kowé ngomong apa kuwi? Aku ora ngerti apa sing mbok omong kuwi!” Rasul Pétrus durung sampèk rampung sing ngomong kuwi, kok terus ènèng jago kluruk. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Gusti Yésus terus nolèh lan ndelokké rasul Pétrus. Rasul Pétrus terus kélingan marang tembungé Gusti: “Ing dina iki, sakdurungé jago kluruk, kowé bakal nyélaki Aku ping telu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Rasul Pétrus terus metu sangka kono karo nangis kelara-lara. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wong-wong sing nyekel Gusti Yésus terus pada moyoki lan nggebuki Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mripaté ditutupi terus dikeplaki lan ditakoni: “Jaréné kowé nabi, bedèken sapa sing ngeplaki Kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wong-wong sing njaga kuwi pada moyoki Gusti Yésus nganggo tembung liya-liyané menèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ing ésuké para pengarepé wong Ju, para pengarepé imam lan para guru Kitab pada nglumpuk. Gusti Yésus terus digawa nang ngarepé Kruton Agama. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Wong-wong terus takon marang Gusti Yésus ngomong: “Apa kowé kuwi Kristus tenan!” Gusti Yésus semaur: “Senajan Aku ngomong, kowé ya ora bakal ngandel. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Senajan Aku takona apa-apa, kowé ya ora bakal pada mangsuli. ");
INSERT INTO jvnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nanging saiki Anaké Manungsa bakal njagong nang tengené Gusti Allah sing kwasa déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wong-wong terus takon: “Dadiné Kowé Anaké Gusti Allah?” Gusti Yésus semaur: “Kowé déwé sing ngomong ngono!” ");
INSERT INTO jvnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wong-wong terus ngomong: “Awaké déwé wis ora mbutuhké seksi menèh. Awaké déwé wis krungu sangka tembungé Dèkné déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wong kabèh mau terus pada ngadek lan nggawa Gusti Yésus nang ngarepé gramang Pilatus. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nang kono wong-wong pada nyalahké Dèkné, ngomong: “Awaké déwé wis ngerti nèk wong iki nyasarké rayat. Dèkné ngojok-ojoki wong supaya ora mbayar belasting marang ratuné, awit Dèkné déwé ngakuné Kristus, ratu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Gramang Pilatus terus takon marang Gusti Yésus: “Apa kowé kuwi ratuné bangsa Ju?” Gusti Yésus semaur: “Bener, pantyèn mengkono!” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Gramang Pilatus terus ngomong marang para pengarepé imam lan wong okèh sing nang kono: “Nèk manut pinemuku wong iki ora salah apa-apa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nanging wong-wong ngetyek waé ngomong: “Wong iki mulangi wong-wong kongkon pada mbruntak, molai nang bawah Galiléa terus nang sak Yudéa lan saiki sampèk tekan kéné.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kadung gramang Pilatus krungu omongé wong-wong mau, dèkné terus takon: “Apa wong iki tekané sangka Galiléa?” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bareng krungu nèk Gusti Yésus kuwi sangka panggonan pengurusané ratu Hérodès, dèkné terus ngongkon nggawa Gusti Yésus nang nggoné ratu Hérodès, sing ing waktu kuwi ndilalahé nang kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kadung ratu Hérodès weruh Gusti Yésus, dèkné bungah banget, awit wis suwi krungu bab Dèkné, mulané kepéngin weruh déwé. Malah dèkné ngarep-arep bisaa weruh Gusti Yésus nindakké mujijat. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mulané ratu Hérodès ngetokké pitakonan pirang-pirang marang Gusti Yésus, nanging Dèkné ora gelem semaur apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Para pengarepé imam lan para guru Kitab uga nang kono lan pada nyalahké Gusti Yésus nganggo prekara-prekara sing abot. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Gusti Yésus digawé sembrana karo ratu Hérodès lan para soldat. Dèkné terus dienggoni penganggoné ratu terus digawa balik menèh nang ngarepé gramang Pilatus. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wiwit dina iku ratu Hérodès lan gramang Pilatus pada kekantyan menèh, mauné memungsuhan. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Gramang Pilatus terus ngumpulké para pengarepé imam, para penuntun lan uga rayaté. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Dèkné terus ngomong marang wong-wong: “Kowé nggawa wong iki nang nggonku lan kowé ngomong nèk wong iki nyasarké rayat. Wongé wis tak takoni nang ngarepmu, nanging aku ora nemu salah blas sing mbok omongké. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Uga ratu Hérodès ora nemu salah apa-apa, awit dèkné ngongkon nggawa Yésus balik nang nggonku menèh. Wong iki ora nglakoni salah apa-apa sing marakké Dèkné kudu dikèki setrapan pati. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mulané wongé arep tak kongkon metyuti waé terus tak etyulké.” ( ");
INSERT INTO jvnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Wis dadi adat, saben riyaya Paskah gramang Pilatus ngetokké setrapan siji, manut penjaluké rayat.) ");
INSERT INTO jvnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wong okèh sing nang kono pada bengok-bengok: “Wong iku dipatèni! Barabas dietokké.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas kuwi disetrap, jalaran dèkné mbruntak nang kuta lan matèni wong. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jalaran gramang Pilatus kepéngin ngetokké Gusti Yésus, mulané dèkné ngomong sepisan menèh marang wong okèh mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nanging wong-wong pada bengok-bengok ngomong: “Dipentèng waé! Dipentèng!” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Gramang Pilatus sampèk ngomong ping teluné marang wong okèh mau, tembungé: “Nanging wong iki salahé apa? Aku ora nemu salahé wong iki sing marakké kudu dipatèni. Wong iki arep tak kongkon metyuti waé terus tak etyulké.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nanging wong-wong malah tambah bengok-bengok sak kuwaté, ngomong nèk Gusti Yésus kudu dipentèng. Entèk-entèké wong okèh mau menang. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Gramang Pilatus terus nggawé putusan ngekèki setrapan pati marang Gusti Yésus, manut karepé wong okèh mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barabas, sing disetrap jalaran nglakoni pembruntakan lan matèni wong, dietokké, manut karepé wong-wong. Gramang Pilatus terus masrahké Gusti Yésus marang wong okèh mau, supaya pada nglakoni apa karepé. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Gusti Yésus terus digawa metu sangka kuta Yérusalèm. Nang dalan kepetuk wong sing jenengé Simon, sangka kuta Siréné, arep mlebu kuta. Simon dityeluk lan dipeksa kongkon manggul kayu pentèngané nang mburiné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Okèh wong pada ngetutké lakuné Gusti Yésus. Nang tengahé wong okèh kuwi uga ènèng wong wédok siji-loro. Wong wédok-wédok mau pada ngantemi dadané nangisi Gusti Yésus lan pada sambat. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Gusti Yésus terus nolèh lan ngomong marang wong wédok-wédok mau: “Kowé, wong wédok Yérusalèm, kowé aja pada nangisi Aku; tangisana awakmu déwé lan anak-anakmu. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Awit bakal ènèng waktuné wong ngomong: ‘Beja tenan wong wédok sing gabuk, sing ora tau nglairké anak lan ora tau nyusoni bayi!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bakal ènèng waktuné wong pada ngomong marang gunung-gunung: ‘Aku tibanana,’ lan uga ngomong marang puntuk-puntuk: ‘Aku hurukana!’ ");
INSERT INTO jvnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Awit nèk kaya ngéné penggawéné marang kayu sing urip, lah kayu sing garing menèh bakal dikapakké?” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Enèng wong nakal loro sing digiring bareng karo Gusti Yésus, sing uga arep dipatèni. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kadung wis tekan panggonan sing jenengé “Endas wong,” Gusti Yésus terus dipentèng bareng karo wong nakal loro mau, siji nang tengené lan siji nang kiwané. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Gusti Yésus terus ndonga: “Duh Bapakku, salahé wong-wong iki mbok dingapura, awit ora pada ngerti apa sing dilakoni.” Saliné Gusti Yésus terus dipratung nganggo lotré karo para soldat sing njaga. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wong okèh pada nyawang lelakon nang kono kuwi. Para pengarepé bangsa Ju pada moyoki Gusti Yésus, tembungé: “Dèkné wis nulungi wong liya. Nèk pantyèn wong kuwi Kristus, kongkonané Gusti Allah tenan, jajal kono apa bisa nulungi awaké dèkné déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldat-soldat ya pada moyoki terus marani Gusti Yésus lan ngekèki anggur ketyut. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Terus ngomong: “Nèk Kowé ratuné wong Ju, tulungana awakmu déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nang sak nduwuré sirahé Gusti Yésus ènèng tulisan: “Yésus, ratuné wong Ju.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Salah sijiné wong nakal sing dipentèng ngolok-olok Gusti Yésus, ngomong: “Nèk Kowé kuwi Kristus tenan, tulungana awakmu déwé lan awaké déwé wong loro pisan.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nanging wong nakal sing liyané nyenèni kantyané ngomong: “Apa kowé ora wedi blas karo Gusti Allah, awaké déwé iki éntuk setrapan pati. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kanggo awaké déwé setrapan iki wis sak mestiné. Nanging wong iki ora salah apa-apa.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wongé terus ngomong marang Gusti Yésus: “Gusti, mbok éling marang aku nèk Kowé wis ing kratonmu.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Gusti Yésus semaur: “Pretyayaa, dina iki waé kowé bakal bareng karo Aku mlebu ing Pirdus.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kira-kira jam rolas awan sak negara kono kabèh malih peteng ndedet, sampèk jam telu, awit srengéngéné ketutupan. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kordèn nang Gréja Gedé suwèk tengahé. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Gusti Yésus terus mbengok banter: “Duh Bapakku, Aku masrahké nyawaku nang tanganmu!” Sakwisé ngomong kuwi Dèkné terus ninggal. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kadung kumendané para soldat sing jaga nang kono weruh lelakon kuwi mau kabèh, dèkné terus ngluhurké Gusti Allah ngomong: “Nyata tenan nèk wong iki ora salah.” ");
INSERT INTO jvnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wong-wong sing pada teka mbrono kepéngin weruh lelakon nang kono uga pada weruh kuwi mau kabèh. Pada rumangsa salah kabèh lan ngantemi dadané terus pada mulih. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wong kabèh sing pada kenal karo Gusti Yésus lan uga wong wédok-wédok sing mèlu Gusti Yésus sangka Galiléa pada ngadek lan ndelokké lelakon kuwi kabèh sangka kadohan. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Enèng wong sing jenengé Yosèf, sangka Arimatéa, kutané wong Ju. Yosèf iki wong apik lan kajèn, wong pretyaya sing ngarep-arep tekané Kratoné Allah. Yosèf iki wargané Kruton Agama, nanging dèkné ora nyetujoni putusané liya-liyané mau bab Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yosèf terus mara nang nggoné gramang Pilatus nyuwun layoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yosèf terus ngedunké layoné sangka kayu pentèngan terus dibuntel mori alus. Sakwisé kuwi layoné terus dikubur nang kuburan sing ditatah sangka watu. Kuburan iki durung tau kanggo. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Saiki wis dinané kanggo tata-tata, awit sedilut menèh wis tiba dina sabat. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wong wédok-wédok sing mèlu Gusti Yésus sangka Galiléa ya pada ngetutké Yosèf, mèlu ngeterké layoné nang kuburan. Wong-wong kuwi pada weruh déwé sing nyèlèhké layoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wong wédok-wédok mau terus pada mulih lan nyawiské bumbu-bumbu lan lenga-wangi sing arep dienggo ngusapi awaké Gusti Yésus. Esuké, dina sabat, wong-wong mau pada lèrèn enggoné nyambutgawé, manut wèté dina sabat. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ing dinané minggu, ésuk mruput, wong wédok-wédok mau pada budal nang kuburan nggawa barang-barangé sing wis dityawiské kanggo ngrumati layoné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kadung tekan nggoné, wong-wong weruh nèk watu sing nutupi kuburané wis diglundungké. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wong wédok-wédok mau terus mlebu, nanging layoné wis ora ènèng. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dongé ijik pada ngadek nang kono lan bingung mikirké prekara kuwi, lah kok dadakan ènèng wong lanang loro nganggo salin putih sumeblak ngadek nang ngarepé. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wong wédok-wédok mau kagèt banget terus pada ndingkluk. Wong lanang loro mau terus ngomong: “Kenèng apa kowé kok pada nggolèki wong sing urip nang tengahé wong mati? ");
INSERT INTO jvnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Dèkné ora ènèng nang kéné, Dèkné wis tangi. Apa ora pada kélingan marang tembungé, dongé Dèkné ijik nang Galiléa. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Dèkné lak ngomong ngéné ta: ‘Anaké Manungsa wis pinesti dielungké marang tangané wong dosa terus dipentèng. Sakwisé kuwi, ing telung dinané, Dèkné bakal tangi menèh.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wong wédok-wédok mau terus kélingan marang tembungé Gusti Yésus kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sakwisé balik sangka kuburan, wong wédok-wédok mau terus pada ngomongké bab lelakon kuwi kabèh marang murid sewelas lan marang liya-liyané. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wong wédok-wédok sing ngomongké bab lelakon mau yakuwi: Maria Makdaléna, Yohanah lan Maria, ibuné Yakobus lan wong wédok-wédok liyané sing uga bebarengan karo wong-wong mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nanging para rasul ora pada ngandel marang omongé wong-wong kuwi, jaréné namung ngobrol. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nanging rasul Pétrus terus gelis-gelis lunga nang kuburan. Kadung nginguk njeruh dèkné namung weruh moriné nang kono. Dèkné nggumuné éram-éram, terus mulih karo mikir-mikir apa sing entas klakon nang kuburan kono. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ing dina kuwi ènèng muridé Gusti Yésus loro sing pada mlaku arep nang désa Emaus. Désa Emaus kuwi adohé kira-kira rolas kilomèter sangka kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Karo mlaku wong loro kuwi pada ngomongké bab sing entas klakon mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dongé ijik omong-omongan ngono kuwi Gusti Yésus déwé terus teka mbarengi mlaku. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wong loro mau ora nitèni nèk kuwi Gusti Yésus, embuh kenèng apa kok pada pangling karo Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Gusti Yésus terus ngomong: “Kowé kuwi pada ngomongké apa ta?” Wong loro mau terus mandek lan kétok sedi. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sing siji, sing jenengé Kléopas, semaur: “Tak kira namung Kowé déwé sing manggon nang Yérusalèm sing ora ngerti bab lelakon-lelakon ing dina-dina sing kepungkur kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Gusti Yésus terus takon: “Enèng lelakon apa ta?” Saurané: “Lelakon bab Gusti Yésus sangka kuta Nasarèt. Dèkné nabi sing kwasa banget ing penggawéné lan ing piwulangé, sing kajèn tenan nang ngarepé Gusti Allah lan nang tengahé manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Para pengarepé imam lan para pengarepé bangsané awaké déwé wis pada netepké setrapan pati marang Dèkné, mulané terus dipentèng. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Awaké déwé kabèh malah wis njagak-njagakké nèk Dèkné sing bakal ngluwari bangsa Israèl. Saiki lelakon kuwi malah wis kliwat telung dina. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Malah saiki sedulur-sedulur wédok sangka golongané awaké déwé pada marakké awaké déwé kagèt banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jaréné mau ésuk mruput pada budal nang kuburan, nanging ora nemu layoné Gusti Yésus. Terus pada mulih lan ngomong nèk weruh mulékat loro. Mulékaté mau jaréné ngomong nèk Gusti Yésus wis tangi sangka pati. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kantyané awaké déwé terus pada budal nang kuburan lan pada nyeksèni déwé nèk sembarang sing diomong karo sedulur-sedulur wédok bener kabèh. Nanging kantya-kantya mau ora weruh Dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Gusti Yésus terus ngomong marang wong loro mau: “Kowé kok bodo temen lan angèl temen pretyaya marang sembarang sing wis diomongké karo para nabi. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kristus kuwi lak kudu nglakoni kasangsaran, supaya sakwisé kuwi kaangkat ing kaluhuran.” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Gusti Yésus terus ndunung-ndunungké marang wong loro mau bab apa sing wis diomong nang Kitab Sutyi bab Kristus, wiwit sangka kitab-kitabé nabi Moses nganti tekan kitab-kitabé para nabi liyané. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kadung wis tyedek karo désa sing arep diparani, Gusti Yésus étok-étoké arep mlaku terus. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nanging wong loro mau pada ngalang-alangi Dèkné ngomong: “Mbok hayuk mampir nang omahé awaké déwé waé, awit wis surup, sedilut menèh wis peteng.” Gusti Yésus terus mlebu nang omahé wong loro mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kadung njagong bebarengan arep mangan, Gusti Yésus terus njikuk roti lan ndonga, maturkesuwun marang Gusti Allah. Sakwisé kuwi terus nyuwil roti, terus dielungké marang wong loro mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sakwat mripaté wong loro mau kebukak terus bisa nitèni Gusti Yésus, nanging Dèkné wis ngilang sangka mripaté wong-wong mau. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wong loro mau terus ngomong: “Wah, mau atiku jan krasa tenan, dongé Dèkné ndunung-ndunungké isiné kitab-kitabé nabi Moses lan para nabi liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wong loro mau terus terusan ngadek lan balik menèh nang kuta Yérusalèm. Nang kono pada ketemu karo rasulé Gusti Yésus sing sewelas, sing wis pada ngumpul karo murid-murid liyané. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Sing pada ngumpul mau ngomong: “Gusti wis ngétok marang Simon! Dèkné pantyèn wis tangi menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wong loro sangka désa Emaus mau uga ngomongké marang para murid sing pada nglumpuk bab apa sing wis dialami déwé dongé nang dalan. Uga pada ngomongké nèk ora pangling karo Gusti Yésus, dongé Dèkné nyuwil roti. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dongé murid-murid mau ijik pada ngomongké bab kuwi terus dadakan waé Gusti Yésus ngadek nang tengahé lan mbagèkké: “Tentrem anaa ing kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Murid-murid kabèh pada kagèt lan wedi, mikiré weruh memedi. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","39","Nanging Gusti Yésus ngomong: “Kenèng apa kowé kok pada wedi lan kenèng apa kok pada mangu-mangu? Delokké tangan lan sikilku. Iki pantyèn Aku tenan. Demèken déwé kéné awakku. Apa memedi nduwé daging lan balung kaya Aku iki. Kowé weruh déwé ta?” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sak barengé ngomong ngono kuwi Gusti Yésus nduduhké tangané lan sikilé. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jalaran murid-muridé durung ngandel sangking bungah lan nggumuné, Gusti Yésus terus takon: “Apa nang kéné ènèng apa-apa sing kenèng dipangan?” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Murid-muridé terus nggawa iwak gorèngan sak iris. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Iwak sak iris mau terus dipangan nang ngarepé murid-muridé karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sakwisé kuwi Gusti Yésus terus ngomong ngéné marang murid-muridé: “Prekara-prekara iki wis tak omongké marang kowé dongé Aku ijik bebarengan karo kowé. Aku wis ngomong nèk kabèh sing wis ditulis bab Aku nang kitabé nabi Moses lan kitabé para nabi liyané lan uga nang kitab Masmur kudu klakon.” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sakwisé kuwi Gusti Yésus terus mbukak pikirané murid-muridé, supaya pada dunung marang Kitab Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Gusti Yésus ngomong: “Nang Kitab Sutyi wis ketulis nèk Kristus kudu nglakoni sangsara lan tangi menèh sangka pati ing telung dinané. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Uga wis ketulis nèk Jenengé Kristus bakal dikabarké marang kabèh bangsa, nèk Gusti Allah ngekèki pangapura marang wong sing pada ngakoni dosa-dosané lan pada nglakoni urip sing anyar. Kabar iki bakal digelarké molai nang kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Lah kowé kabèh wis nyeksèni bab prekara kuwi mau kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Lan Aku déwé bakal ngekèki marang kowé apa sing wis dijanji karo Bapakku. Mulané kowé aja pada lunga sangka kuta Yérusalèm ndisik, nanging pada ngentènana tekané kekuwatan sangka swarga kanggo kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sakwisé kuwi Gusti Yésus terus nggawa murid-muridé metu sangka kuta Yérusalèm nang panggonan tyedek karo désa Bétani. Nang kono Gusti Yésus terus ngunggahké tangané lan mberkahi murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sak barengé mberkahi mau, Gusti Yésus kaangkat munggah nang swarga, pisah sangka para muridé. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Murid-muridé terus pada sujut nyembah marang Dèkné, terus balik nang kuta Yérusalèm karo ati sing bungah banget. ");
INSERT INTO jvnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Murid-murid mau terus ora lunga sangka Gréja Gedé lan pada memuji lan maturkesuwun marang Gusti Allah.");
INSERT INTO jvnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sakdurungé jagat digawé, Tembung wis ènèng. Tembung iki mauné nang nggoné Gusti Allah lan Tembung iki ya pantyèn Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sakdurungé jagat ènèng, Tembung wis dadi siji karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sembarang ènèngé sangka Tembung lan tanpa Tembung ya ora ènèng apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tembung kuwi sumberé urip lan urip kuwi dadi pepadangé manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pepadang semlorot ing pepeteng lan pepeteng ora bisa matèni. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Enèng sakwijiné wong sing jenengé Yohanes. Yohanes iki sing dikongkon karo Gusti Allah dadi seksiné Pepadang. Tekané Yohanes namung kanggo ndunungké marang wong-wong, supaya pada pretyaya marang Pepadang iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanes déwé dudu Pepadang. Dèkné namung ngabarké Pepadang kuwi sapa. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pepadang sing sejati iki arep teka lan madangi kabèh manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tembung wis teka nang jagat. Nanging senajana jagat iki ènèngé sangka Dèkné, jagat ora nitèni Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tembung nekani bangsané déwé, nanging bangsané déwé ora gelem nampa Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nanging kabèh wong sing nampa Dèkné lan pretyaya marang Dèkné pada diaku anak karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bisané dadi anaké Gusti Allah kuwi ora jalaran manungsa sing nglairké ora, nanging jalaran lair sangka Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tembung dadi manungsa wujut daging lan kulit. Dèkné manggon tyampur karo awaké déwé. Awaké déwé pada nyeksèni gedéné kwasané, sing namung Anaké sing ora ènèng tunggalé lan sing kebek kawelasan lan kabeneran, bisa nampa sangka Bapaké. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ya iki sing diomong karo Yohanes, dongé dèkné ngabar-ngabarké, ngomong: “Ya wong iki sing tak omong, dongé aku ngomong: ‘Sak mburiku bakal ènèng wong teka, nanging Dèkné luwih ndisik tenimbang aku, awit Dèkné wis ènèng sakdurungé aku lair.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kabetyikané Anaké Gusti Allah gedé banget. Sangka lubèré kabetyikan kuwi awaké déwé kabèh saben dina nampa berkah tanpa mandek. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bener, wèt-wèté Gusti Allah tekané karo nabi Moses, nanging Gusti Yésus Kristus sing nggawa kabetyikané lan kawujutané Gusti Allah marang awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ora ènèng wong siji waé sing tau weruh Gusti Allah, nanging Anaké, sing ora ènèng tunggalé, sing wujut Gusti Allah lan dadi siji karo Bapaké, Dèkné sing ngétokké Gusti Allah marang awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Para penggedéné wong Ju nang kuta Yérusalèm pada kongkonan para imam lan para peladèné Gréja Gedé nang nggoné Yohanes. Kongkon takon, dèkné kuwi sakjané sapa. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohanes saurané ya blaka waé: dèkné ngakoni nèk dudu Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Lah kowé kuwi sapa? Apa kowé kuwi menawa nabi Elia?” “Dudu!” “Apa kowé kuwi nabi sing kudu teka?” “Ya dudu!” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Lah sapa? Mbok ngomong ta? Lah mengko awaké déwé kongkon ngomong apa karo wong-wong sing ngongkon awaké déwé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanes semaur nganggo tembungé nabi Yésaya: “Aku iki swara sing tyeluk-tyeluk nang wustèn: dalané dirata kanggo Gusti!” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wong-wong sing pitakonan marang Yohanes kuwi uga wong Farisi. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Wong Farisi iki terus pada takon menèh marang Yohanes: “Lah nèk kowé dudu Kristus lan dudu nabi Elia lan dudu nabi sing kudu teka, lah kowé kok mbaptisi wong-wong?” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanes semaur: “Kowé pada ngerti nèk aku mbaptis karo banyu, nanging nang tengahmu ènèng sakwijiné wong sing kowé durung kenal. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ora suwi menèh kowé bakal weruh penggawéné Dèkné. Nanging aku aja dipadakké karo Dèkné, awit nalèni sepatuné Dèkné waé aku durung pantes.” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wong-wong sing pitakonan kuwi mau nang désa Bétani, nang wétané laut Yordan. Yohanes mbaptisi wong-wong nang laut iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ing ésuké Yohanes weruh Gusti Yésus marani dèkné. Yohanes terus ngomong: “Delokké kaé! Ya iku Tyempéné Gusti Allah sing nebus dosané manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ya wong iki sing tak omong kaé, nèk Dèkné bakal teka sak mburiku, nanging ènèngé wis kawit mbiyèn, sakdurungé aku lair. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aku déwé mauné ya durung nitèni Dèkné. Nanging enggonku mbaptis karo banyu kuwi supaya bangsa Israèl bisa nitèni Dèkné kuwi sapa.” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohanes terus ngomong menèh: “Aku weruh Roh Sutyi kaya manuk dara medun sangka langit terus méntyloki Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mauné aku ora nitèni Dèkné. Nanging Gusti Allah sing ngongkon aku mbaptis karo banyu, Gusti Allah déwé ngomong marang aku: ‘Nèk kowé weruh Roh Sutyi medun terus méntyloki wong, ya wong kuwi sing bakal mbaptis karo Roh Sutyi!’ ");
INSERT INTO jvnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Saiki aku wis weruh déwé karo mripatku, mulané aku ngerti tenan nèk Dèkné kuwi Anaké Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ing ésuké Yohanes ya nang kono menèh karo murid loro. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kadung Gusti Yésus liwat, Yohanes terus nyawang Dèkné karo ngomong: “Yakuwi Tyempéné Gusti Allah sing bakal dadi kurbané manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Murid loro mau krungu Yohanes ngomong ngono, mulané terus pada mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Gusti Yésus nolèh mburi weruh wong loro mau mèlu Dèkné terus takon: “Kowé pada arep nang endi?” Wongé pada semaur: “Guru, omahmu nang endi?” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Gusti Yésus semaur: “Hayuk mèlu Aku, mengko kowé lak weruh déwé!” Mulané terus pada mèlu lan pada weruh omahé sing dienggoni Gusti Yésus. Mbenginé pada nginep nang kono, awit tekané wis soré, kira-kira jam papat. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Murid loro mau sing krungu sangka Yohanes terus mèlu Gusti Yésus, sing siji jenengé Andréas, seduluré Simon Pétrus. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Esuké Andréas terus gelis-gelis nggolèki Simon, diomongi: “Awaké déwé wis kepetuk karo Kristus, Juru Slamet sing wis dijanji karo Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andréas terus ngeterké Simon nang nggoné Gusti Yésus. Gusti Yésus nyawang Simon terus ngomong: “Kowé kuwi lak Simon anaké Yohanes ta? Saiki kowé tak jenengké Kéfas!” (Tembung Kéfas kuwi tunggalé waé karo Pétrus, tegesé: watu.) ");
INSERT INTO jvnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Esuké Gusti Yésus kepéngin budal nang Galiléa. Nang kana Dèkné kepetuk karo Filipus. Gusti Yésus terus ngomong: “Filipus, hayuk mèlua Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipus kuwi manggoné nang Bètsaida, tunggalé waé karo Andréas lan Pétrus. ");
INSERT INTO jvnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipus kadung ketemu karo Natanaèl terus ngomong: “Awaké déwé wis kepetuk karo Yésus, anaké Yosèf, wong Nasarèt. Wong iki sing diomong nang Kitab karo nabi Moses lan nabi liya-liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaèl semaur: “Wong Nasarèt? Ah, sapa sing ngandel nèk Nasarèt kuwi ngetokké barang betyik!” Filipus semaur: “Mbok hayuk dititèni déwé ta.” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Gusti Yésus weruh Natanaèl teka terus ngomong: “Wah, ya iki sing jenengé wong jujur, wong sing kenèng dipretyaya. Ya iki turunané wong Israèl tenan!” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaèl terus semaur: “Lo, lah Kowé kok ngerti aku iki sapa Gusti?” Gusti Yésus semaur: “Sakdurungé Filipus ngejèk kowé, Aku wis weruh kowé, dongé kowé njagong nang ngisoré wit anjir.” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaèl terus ngomong: “Gusti, ya Kowé kuwi Anaké Gusti Allah tenan. Kowé ratuné bangsa Israèl!” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Gusti Yésus semaur: “Apa kowé ngomong ngono kuwi jalaran Aku ngomong nèk Aku weruh kowé njagong nang ngisor wit anjir? Dititèni ta! Kowé bakal weruh lelakon-lelakon liyané sing nggumun-nggumunké ngungkul-ungkuli iki.” ");
INSERT INTO jvnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gusti Yésus terus ngomong menèh: “Titènana déwé ta! Kowé bakal weruh langit menga lan weruh mulékat-mulékaté Gusti Allah pada munggah-medun ngladèni Anaké Manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Let rong dina nang Kana, sakwijiné kuta nang bawah Galiléa, ènèng kawinan. Ibuné Gusti Yésus nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Gusti Yésus lan murid-muridé uga éntuk undangan, mulané ya pada nang kono mbarang. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kadung ombèné wis entèk ibuné Gusti Yésus terus ngomong marang Dèkné: “Yésus, wong-wong kentèkan anggur.” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Gusti Yésus semaur: “Bu, iki urusanmu apa urusanku. Waktuku durung teka kanggo tumandang.” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ibuné Gusti Yésus terus ngomong marang para peladèn: “Apa tembungé Yésus marang kowé pada ditandangi.” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nang kono ènèng kendi watu gedé-gedé nenem. Kendi siji bisa ngemot kira-kira satus liter. Kendi-kendi kuwi wadah banyu wisuhan sutyi, manut pernatané agamané wong Ju. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Gusti Yésus terus ngongkon para peladèn ngisèni kendi-kendiné karo banyu. Kendiné terus diisèni kabèh sampèk kebek. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Gusti Yésus terus ngomong: “Njikuka setitik dikèkké pengarepé pésta kongkon ngityipi!” Peladèné ya manut waé. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pengarepé pésta ora ngerti blas bab sembarang iki. Sing ngerti ya namung para peladèn sing ngisèni kendiné. Kadung pengarepé pésta ngityipi banyuné sing wis dadi anggur, dèkné terus ngomong marang mantèné lanang: ");
INSERT INTO jvnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Lumrahé ombèn sing énak déwé disuguhké ndisik, lah nèk wong-wong wis warek terus sing ora patèka énak dietokké. Lah iki sing énak déwé mandak mbok suguhké kèri!” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tanda nang kuta Kana nang bawah Galiléa iki tanda sing ndisik déwé, kanggo ngétokké sepira gedéné kwasané Gusti Yésus. Murid-muridé terus pada pretyaya marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sakwisé kuwi Gusti Yésus terus budal nang kuta Kapèrnakum, bareng karo ibuné, sedulur-seduluré lan murid-muridé. Nanging ora nginep suwi nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Saiki wis nyedeki riyaya Paskahé wong Ju. Mulané Yésus budal nang Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nang lataré Gréja Gedé kono Gusti Yésus weruh wong-wong dodolan. Enèng sing dodol sapi, liyané dodol wedus lan uga ènèng sing dodol manuk dara. Sing tukang ngijoli duwit mbarang ya ènèng. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Gusti Yésus terus nggawé petyut nganggo tali. Wong-wong sing dodolan wedus-sapi terus dikongkon lunga sangka kono, sak kéwan-kéwané mbarang. Duwité sing tukang ngijoli duwit disebar nang lemah lan méja-méjané diglémpang-glémpangké kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sing dodol manuk dara disenèni ngéné: “Digawa lunga kabèh daganganmu kuwi! Omahé Bapakku aja digawé pasar!” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kadung murid-muridé weruh lelakon iki, terus pada kélingan tulisan nang Kitab sing ngomong ngéné: “Gusti, katrésnanku marang omahmu kaya geni murup.” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Para pengarepé wong Ju terus ngomong: “Kowé kuwi sapa kok wani ngongkon wong-wong lunga? Awaké déwé kepéngin weruh tandané.” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Gusti Yésus semaur: “Mbok Gréja Gedé iki dibubrah ta, sakjeroné telung dina bakal tak dekné menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Telung dina?” wong-wong mau semaur. “Patang puluh nem taun suwéné wong-wong nggawé Gréja iki, lah Kowé kok wani ngomong nèk bisa ngedekké ing telung dina?” ");
INSERT INTO jvnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sakjané Gusti Yésus ora ngomongké bab Gréja Gedé iki, nanging bab badané Dèkné déwé. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Let suwi, dongé Gusti Yésus wis tangi menèh sangka pati, murid-muridé terus pada kélingan sing diomong karo Gusti Yésus iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Dongé riyaya Paskah Gusti Yésus nindakké tanda-tanda sing nggumun-nggumunké nang Yérusalèm kono. Mulané wong okèh terus pada pretyaya marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Nanging Gusti Yésus déwé ora ngandel marang wong-wong kuwi, awit Dèkné ngerti atiné siji-sijiné. Ora usah ènèng sing ngomongi Dèkné apa-apa, Gusti Yésus déwé ngerti njeroné atiné manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Enèng wong Farisi sing jenengé Nikodémes, pengarepé agama Ju. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ing sakwijiné wengi Nikodémes mara nang nggoné Gusti Yésus ngomong: “Gusti, awaké déwé ngerti nèk enggonmu mulangi awaké déwé kuwi sangka kongkonané Gusti Allah déwé. Awit nèk dudu Gusti Allah déwé sing ngongkon Kowé, Kowé ora bisa ngekèki tanda-tanda sing nggumunké.” ");
INSERT INTO jvnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Gusti Yésus terus semaur: “Dirungokké sing apik: ora ènèng wong bisa ngrasakké Kratoné Gusti Allah, nèk wong kuwi ora lair sepisan menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodémes takon: “Mosok wong wis tuwa bisa lair menèh? Lah kepriyé kuwi? Mosok mlebu nang wetengé ibuné terus dilairké menèh?” ");
INSERT INTO jvnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Gusti Yésus semaur: “Iki dirungokké sing apik tenan! Sapa sing ora lair sangka banyu lan sangka Roh Sutyi ora bakal bisa mlebu Kratoné Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Manungsa kuwi ya namung bisa nglairké urip kamanungsan, nanging sing lairé sangka Roh Sutyi kuwi urip ing roh. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mulané kowé aja nggumun Aku mau ngomong: ‘Kowé kudu dilairké sepisan menèh!’ ");
INSERT INTO jvnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Angin kaé mlakuné sak karepé. Awaké déwé krungu swarané, nanging ora weruh sangka ngendi tekané lan nang endi parané. Wong sing dilairké menèh karo Roh Sutyi ya kaya ngono kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodémes terus ngomong: “Lah kaya ngono kuwi bisané kepriyé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Gusti Yésus semaur: “Kowé kuwi lak sakwijiné guru sing kesuwur banget ta nang Israèl? Lah bab kaya ngono waé kok ora dunung. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ngandela ta, Aku ngerti apa sing tak omong lan Aku ngomongké bab sing Aku weruh déwé. Nanging kowé pada ora pretyaya marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bab sing dialami manungsa ing saben dinané waé kowé ora pada pretyaya, lah nèk Aku ngomongké bab sing sangka swarga menèh kowé ngandela! ");
INSERT INTO jvnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Durung tau ènèng wong siji waé munggah nang swarga, kejaba namung Anaké Manungsa sing tekané sangka swarga medun nang jagat kéné. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Kowé ngerti déwé ta, nabi Moses mbiyèn nang wustèn nggawé ula-ulaan terus diunggahké duwur nang kayu, supaya wong-wong sing dityokot ula nèk nyawang ula-ulaan kuwi ora bisa mati; Anaké Manungsa uga bakal diunggahké nang kayu, kaya ulané nabi Moses kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Dadiné sapa sing pretyaya marang Dèkné bakal nduwèni urip langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Awit katrésnané Gusti Allah marang manungsa gedé banget, nganti Dèkné masrahké Anaké sing ora ènèng tunggalé, supaya saben wong sing pretyaya marang Dèkné ora tiba ing karusakan, nanging nduwèni urip langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gusti Allah enggoné ngongkon Anaké medun nang jagat kéné ora kongkon nyalahké manungsa, nanging kongkon dadi Juru Slameté manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Sapa sing pretyaya marang Dèkné ora bakal disalahké, nanging sapa sing ora gelem pretyaya kuwi wis disalahké, awit ora pretyaya marang jenengé Anaké Gusti Allah sing ora ènèng tunggalé. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Salahé manungsa kuwi ngéné: Pepadang teka nang jagat kéné, nanging manungsa malah pada seneng marang pepeteng tenimbang marang pepadang, awit klakuané ala. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pantyèn, lumrahé, wong sing nglakoni ala kuwi ora seneng marang pepadang lan sak inter-interé nglungani pepadang, awit wedi nèk salahé konangan. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nanging wong sing nglakoni sing bener kuwi malah nggolèki pepadang, supaya bisa kétok nèk sing dilakoni dèkné kuwi manut kekarepané Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sakwisé kuwi Gusti Yésus lan murid-muridé pada budal nang bawah Yudéa. Suwéné nang kono Gusti Yésus mbaptisi wong-wong sing pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Yohanes uga mbaptisi wong-wong, awit dèkné durung dilebokké nang setrapan. Yohanes mbaptis nang désa Enon, tyedek karo kuta Salim, awit nang kono okèh banyuné. Wong-wong pada teka mbrono lan pada dibaptis. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Saiki murid-muridé Yohanes Pembaptis pada bantah-bantahan karo wong Ju liyané bab wisuh sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mulané murid-muridé mau terus mara nang nggoné Yohanes ngomong: “Guru, wong sing mbok omongké kaé, sing kepetuk karo kowé nang abrahané laut Yordan kaé lo, Dèkné mbaptis wong-wong mbarang lan wong okèh sing mara mbrono.” ");
INSERT INTO jvnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanes semaur: “Ya malah apik ta? Manungsa kuwi bisané nduwé apa-apa namung jalaran Gusti Allah ngekèki. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kowé wis pada krungu déwé nèk aku iki dudu Kristus. Aku namung dikongkon teka ndisik nggawèkké dalan Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mantèn wédok kuwi sing nduwèni ya namung mantèné lanang. Kantyané mantèné lanang bungah banget nèk weruh mantèné lega. Kaya ngono uga aku iki. Saiki aku bungah tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aku suwi-suwi kudu mundur, malah Dèkné sing kudu maju. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Aku iki mung wong jagat kéné, mulané sing tak omong ya manut tyarané jagat. Dèkné tekané sangka swarga, mulané Dèkné ngungkuli sak kabèhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Sing dirembuk Dèkné kuwi barang sing Dèkné weruh lan krungu déwé, nanging ora ènèng sing pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wong sing pretyaya marang Dèkné kuwi pada ngakoni nèk Gusti Allah bener sak kabèhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pantyèn, sing dikongkon karo Gusti Allah kuwi mesti ya namung ngetokké tembungé Gusti Allah. Gusti Allah sing ngekèki Rohé tanpa wates marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Gusti Allah Bapaké nrésnani Anaké lan sembarang wis dipasrahké marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wong sing pretyaya marang Anaké Gusti Allah kuwi nduwèni urip langgeng, sing ora gelem pretyaya ora bakal ngrasakké urip iki, nanging bakal nyangga setrapané Gusti Allah sak terusé.” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Wong Farisi pada krungu nèk sing mèlu lan sing dibaptis karo Gusti Yésus okèhé ngungkuli sing mèlu Yohanes. (Sakjané sing mbaptis dudu Gusti Yésus déwé, nanging murid-muridé.) Kadung Gusti Yésus krungu bab iki, Dèkné terus lunga sangka bawah Yudéa lan balik menèh nang bawah Galiléa. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Dèkné kudu liwat bawah Samaria. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Kira-kira jam rolas awan Dèkné tekan sakwijiné kuta nang Samaria sing jenengé Sikar, ora adoh karo keboné Yosèf mbiyèn sing dikèki karo Yakub, bapaké. Nang kebon kono ènèng sumuré, yakuwi sumuré Bapa Yakub. Sangking keselé, Gusti Yésus terus lèrèn nang kono. Dèkné njagong nang pinggiré sumur mau. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ora let suwi ènèng wong wédok Samaritan teka arep nimba banyu. Iku dongé Gusti Yésus njagong déwé nang sumur kono, awit murid-muridé pada lunga nang kuta tuku pangan. Gusti Yésus terus njaluk ngombé marang wongé. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wong wédoké semaur: “Kowé kuwi wong Ju, lah kok wani njaluk ngombé marang aku, wong Samaritan?” (Lumrahé wong Ju ora omong-omongan karo wong Samaritan.) ");
INSERT INTO jvnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Gusti Yésus terus ngomong: “Nèk kowé ngerti pawèhé Gusti Allah lan nèk kowé ngerti sapa sing njaluk ngombé marang kowé iki, mesti malah kowé déwé sing bakal njaluk ngombé marang Aku lan Aku bakal ngekèki kowé banyu sing marakké urip.” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Wong wédok mau terus semaur: “Lah kowé ora nggawa timba, katik sumuré jeru pisan. Kepriyé enggonmu arep njikuk banyu sing marakké urip iki? ");
INSERT INTO jvnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sumur iki tinggalané Bapa Yakub. Dèkné déwé mbiyèn ngombé banyuné sumur iki, uga anak-anaké lan ingon-ingoné. Lah apa kowé ngungkuli Bapa Yakub, kok arep ngekèki banyu sing ngungkuli banyuné Bapa Yakub?” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","Gusti Yésus terus ngomong: “Kabèh wong sing ngombé banyu iki bakal ngelak menèh, nanging sapa sing ngombé banyu sing sangka nggonku ora bakal ngelak menèh slawasé. Banyu sing sangka nggonku ndadèkké sumur sing mili terus ngetokké banyu sing marakké urip slawasé.” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wong wédoké terus ngomong: “Gusti, mbok aku dikèki banyu sing mbok omong kuwi ta! Dadiné aku ora bakal ngelak menèh lan ora usah mbréné menèh nimba banyu.” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Gusti Yésus ngomong: “Kana bojomu dityeluk terus balik mbréné menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wongé semaur: “Aku ora nduwé bojo Gusti.” Gusti Yésus terus ngomong: “Pantyèn kowé ora goroh nèk kowé ngomong ora nduwé bojo. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Awit kowé wis kawin ping lima lan wong sing saiki manggon karo kowé kuwi dudu bojomu déwé. Pantyèn kowé ora goroh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wong wédoké ngomong: “Gusti, aku saiki ngerti nèk Kowé kuwi nabi. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mbah-mbahané awaké déwé mbiyèn-mbiyèné pada nyembah Gusti Allah nang gunung iki. Nanging wong Ju mulangi nèk nyembah Gusti Allah kuwi kuduné namung nang kuta Yérusalèm. Kuwi sakjané kepriyé ta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Gusti Yésus ngomong: “Yu, ngandela ta, bakal ènèng wantyiné kowé ora bisa nyembah Gusti Allah nang gunung kéné lan uga ora bisa nang Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kowé kuwi wong Samaritan ora ngerti sapa sing mbok sembah, nanging awaké déwé ngerti, awit wong sing bakal nylametké jagat kuwi tekané sangka bangsa Ju. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ora dadi sebab nang panggonan endi awaké déwé sing nyembah Gusti Allah, nanging sing dadi sebab kuwi kepriyé awaké déwé sing nyembah. Panyembah sing sak mestiné kuwi panyembah sing sangka Roh Sutyi lan sangka ati sing resik. Gusti Allah kepéngin disembah mengkono kuwi. Pantyèn, wiwit saiki manungsa bisa nyembah Gusti Allah sing sak beneré. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gusti Allah iku wujut Roh. Pasembahan sing temenan kuwi ya pasembahan sing ing roh lan sangka ati sing resik.” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wong wédok mau terus ngomong marang Gusti Yésus: “Aku ngerti nèk Kristus, Juru Slamet sing dijanji karo Gusti Allah, bakal teka. Mbésuk nèk Dèkné teka, Dèkné sing bakal ndunung-ndunungké awaké déwé bab prekara iki kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Gusti Yésus semaur: “Kristus kuwi ya Aku, sing ngomong karo kowé iki!” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Dongé Gusti Yésus ijik omong-omongan karo wong wédoké, murid-muridé terus pada teka. Kabèh kagèt weruh Gusti Yésus omong-omongan karo wong wédok, nanging ora ènèng sing wani takon apa perluné lan apa sing diomong. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Wong wédoké malah terus mblayu mulih nang kuta, kendiné ditinggal nang kono. Tekan nggoné terus nyeluki wong-wong ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Hayuk mèlu aku ta! Aku kepetuk wong sing ngomongi aku bab kabèh lelakoné uripku, senajan aku ora kenal wongé. Menawa waé Dèkné Kristus!” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wong-wong terus pada lunga sangka kuta marani Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Murid-muridé terus ngomong marang Gusti Yésus: “Gusti, mbok mangan ndisik ta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","“Ora,” Gusti semaur, “Aku nduwé pangan liyané, nanging kowé ora ngerti apa!” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Murid-muridé terus pada takon marang sakpada-pada: “Apa wis ènèng sing ngekèki mangan Dèkné ya?” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Gusti Yésus semaur: “Panganku kuwi nglakoni kekarepané Gusti Allah sing ngongkon Aku lan Aku kudu ngrampungké penggawéanku! ");
INSERT INTO jvnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kowé lak ngomong ta: ‘Patang sasi menèh terus panèn.’ Nanging pada disawang déwé, sawah-sawahé wis kuning kudu dienèni. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","Sing tukang panèn wis nampa upahé. Wis nglebokké panènané penggawéané, yakuwi wong-wong sing pada nampa urip langgeng. Saiki sing nyebar lan sing panèn pada bungah kabèh loro. Bener sing ngomong: ‘Sing siji nyebar, liyané panèn.’ ");
INSERT INTO jvnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kowé kuwi pada tak kongkon ngenèni sebarané liyané. Liyané sing kemringet, nanging kowé sing panèn.” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wong Samaritan pirang-pirang sangka kuta terus pada pretyaya nèk Gusti Yésus kuwi Kristus. Bisané ngerti ya sangka paseksiné wong wédok mau, sing ngomong nèk Gusti Yésus ngerti lelakoné uripé dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mulané wong-wong terus pada nyuwun marang Gusti Yésus kongkon nginep nang kutané. Gusti Yésus ya terus nginep rong dina nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wong-wong pada ngrungokké piwulangé Gusti Yésus, mulané sing pada pretyaya terus tambah okèh banget. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wong-wong iki pada ngomong karo wong wédoké: “Awaké déwé saiki pretyaya tenan, nanging ora namung jalaran kowé ngomongi awaké déwé, ora, nanging awaké déwé saiki wis krungu déwé. Mulané awaké déwé ngerti tenan nèk pantyèn Dèkné Kristus, sing nylametké jagat.” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sakwisé rong dina kuwi Gusti Yésus terus mlaku terus nang bawah Galiléa. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","Nang Galiléa kono wong-wong pada bungah banget ditekani Gusti Yésus, senajan Dèkné déwé ngomong nèk nabi kuwi nang negarané déwé ora diajèni. Nanging saiki pada ngerti kwasané Gusti Yésus, awit dongé pada mèlu nang Yérusalèm wayah Paskah wong-wong pada weruh Dèkné nindakké barang sing nggumun-nggumunké. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Gusti Yésus terus teka nang kuta Kana menèh. Ya nang kuta iki Gusti Yésus ndadèkké banyu dadi anggur, dongé Dèkné teka sepisanan nang kéné. Enèng wong sangka Kapèrnakum sing anaké lanang lara. Wong iki amtenar gedé nang palèsé ratuné. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wongé krungu nèk Gusti Yésus wis balik nang Galiléa, wis ora nang Yudéa menèh. Anaké wongé lara nemen, wis arep mati, mulané wongé terus mara nang nggoné Gusti Yésus lan nyuwun Dèkné supaya mèlu mulih nambani botyahé. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Gusti Yésus mandak ngomong: “Kowé nèk ora pada weruh tanda karo mripatmu déwé ora gelem pretyaya!” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nanging wongé ngetyek waé nyuwun Gusti Yésus: “Mbok melas ta Gusti, hayuk mèlu ta. Mengko anakku ndak mati!” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Gusti Yésus semaur: “Wis, kana mulih waé. Anakmu wis mari.” Wongé pretyaya tembungé Gusti Yésus, mulané terus mulih. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nang dalan dèkné dipapak karo para peladèné. Para peladèn mau ngomong nèk botyahé wis mari. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wongé terus takon jam pira botyahé mari. Wong-wong semaur: “Wingi jam siji!” ");
INSERT INTO jvnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","“Jam siji!” Wongé terus kélingan nèk iki wantyiné dongé Gusti Yésus ngomong marang Dèkné: “Kana mulih! Anakmu wis mari!” Mulané dèkné lan wong sak omah kabèh pada pretyaya marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nang Galiléa kéné iki tanda kwasané Gusti Yésus sing nomer loro. Lelakon iki ora let suwi sakwisé Dèkné teka sangka Yudéa. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ora let suwi Gusti Yésus budal nang Yérusalèm, arep mèlu ngguyupi riyayané wong Ju. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nang Yérusalèm kono, ora adoh karo Lawang Wedus, ènèng blumbangé, sing ing basa Ibrani jenengé Betèsda. Blumbang iki diubengi karo gadri lima. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Gadri-gadriné kuwi kebek karo wong lara sing pating glétak nang kono. Enèng sing lamur, liyané lumpuh lan uga ènèng sing pintyang mbarang. Wong-wong iki pada ngentèni obahé banyuné blumbang kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Awit ènèng wantyiné mulékat medun ngobahké banyuné. Nèk banyuné obah, sapa sing nyemplung ndisik ya bakal mari, ora perduli apa larané. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nang kono ènèng wong sing wis lara telung puluh wolu taun suwéné. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Gusti Yésus weruh wongé lan ngerti nèk wong kuwi wis lara suwi banget, mulané ditakoni: “Apa kowé kepéngin mari tenan?” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Wongé semaur: “Lah kepriyé, aku ora nduwé sapa-sapa sing ngedunké aku nèk banyuné obah! Nèk aku arep nyemplung, aku wis kedisikan liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Gusti Yésus terus ngomong marang wongé: “Kowé ngadeka! Klasamu digulung lan mlakua!” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Wongé terus sakwat mari, nggulung klasané terus mlaku. Kuwi tiba dina sabat. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mulané para penggedéné bangsa Ju terus nyenèni wong sing ditambani karo Gusti Yésus kuwi, ngomong: “Saiki lak dina sabat ta? Kowé ora kenèng manggul klasamu.” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nanging wongé semaur: “Lah aku dikongkon karo wong sing nambani aku kongkon manggul klasaku lan mlaku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“Sapa sing ngongkon kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nanging wongé ora ngerti sapa sing nambani dèkné, awit Gusti Yésus wis lunga, jalaran nang kono wongé malih okèh banget. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ora let suwi Gusti Yésus kepetuk wongé nang Gréja Gedé. Gusti Yésus terus ngomong marang dèkné: “Saiki kowé wis mari ta! Aja nglakoni barang sing ora apik menèh, mengko kowé ndak tiba ing kasangsaran sing ngungkul-ungkuli mauné.” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wongé terus lunga nang nggoné para penggedéné bangsa Ju, ngomongi nèk sing nambani dèkné kuwi Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mulané para penggedé mau arep nyekel Gusti Yésus, awit Dèkné nambani wong ing dina sabat. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nanging Gusti Yésus ngomong marang wong-wong kuwi: “Bapakku ora lèrèn enggoné tandang betyik, uga ora lèrèn ing dina sabat, mulané Aku uga ya nulungi wong terus, ora perduli ing dina apa.” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tembungé Gusti Yésus kuwi marakké para penggedé tambah jèngkèlé lan pada kepéngin matèni Dèkné. Wong-wong kepéngin matèni Gusti Yésus kuwi ora namung jalaran Dèkné nerak wèté dina sabat, nanging uga jalaran Dèkné ngarani nèk Gusti Allah kuwi Bapaké, tegesé Dèkné madakké Dèkné déwé karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Gusti Yésus ngomong ngéné marang wong-wong mau: “Aku arep ngomong sak beneré. Aku ora bisa nindakké apa-apa sangka karepku déwé, nanging Aku nuruti karepé Bapakku. Apa sing ditindakké karo Gusti Allah Bapakku, yakuwi tak tindakké uga. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bapakku nrésnani Aku. Dèkné nduduhké sembarang marang Aku, sembarang sing ditindakké karo Dèkné. Nambani wong kuwi durung apa-apa. Dèkné bakal nduduhké lelakon sing ngungkul-ungkuli kuwi, supaya kowé pada nggumun kabèh! ");
INSERT INTO jvnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kaya enggoné Gusti Allah Bapakku nangèké wong mati bisa urip menèh, Aku uga ngekèki urip marang sapa waé sak karepku. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Gusti Allah déwé ora ngrutu sapa-sapa. Kwasa kanggo ngrutu kuwi wis dipasrahké marang Anaké. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Dadiné wong kabèh kudu ngajèni marang Anaké, kaya enggoné ngajèni marang Gusti Allah Bapaké. Sapa sing ora ngajèni marang Anaké ya ora ngajèni marang Gusti Allah Bapaké sing ngongkon Anaké.” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Gusti Yésus terus ngomong menèh: “Kowé tak omongi sak beneré! Sapa sing ngrungokké tembungku lan pretyaya marang sing ngongkon Aku, wong kuwi nduwèni urip langgeng. Dèkné ora bakal disetrap, awit wis utyul sangka pati lan mlebu ing urip. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ngandela Aku ta! Ora suwi menèh sing pada mati bakal krungu swarané Anaké Gusti Allah. Sapa sing krungu swarané bakal urip. Sing tak omong iki saiki wis molai klakon. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gusti Allah Bapaké, sing ngekèki urip marang sembarang ing donya kéné, Dèkné wis ngekèkké kwasané marang Anaké, mulané Anaké uga bisa ngekèki urip marang sembarang ing donya. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Gusti Allah Bapaké uga wis ngekèki kwasa marang Anaké kanggo ngrutu manungsa, awit Dèkné kuwi Anaké Manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Aja kagèt lan aja nggumun! Mbésuk wong-wong sing wis dikubur bakal krungu swarané. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Sing mauné pada nindakké betyik bakal tangi nampa kauripan. Sing pada nindakké ala bakal tangi nampa setrapané. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aku ora bisa nindakké apa-apa sangka karepku déwé. Aku manut karepé Gusti Allah. Uga nèk Aku ngrutu manungsa, Aku manut karepé Gusti Allah, mulané ya sak beneré. Aku ora nuruti karepku déwé, nanging karepé Gusti Allah, sing ngongkon Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Gusti Yésus terus ngomong menèh: “Nèk Aku déwé sing ngomongké bab Aku, bener kowé nèk ora gelem pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nanging Gusti Allah sing ngomongké bab Aku. Aku ngerti nèk Dèkné ora goroh. Apa sing diomong karo Dèkné bab Aku kuwi tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kowé pada kongkonan takon marang Yohanes bab Aku. Apa dèkné goroh bab Aku? Lak ora ta? ");
INSERT INTO jvnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aku ngomong ngono kuwi ora jalaran Aku mbutuhké paseksiné manungsa, nanging jalaran Aku kepéngin nèk kowé nampa keslametan. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanes kuwi kaya dian sing murup lan madangi lan namung sak untara kowé gelem kepadangan dian kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nanging Aku nduwèni seksi sing ngungkul-ungkuli paseksiné Yohanes. Awit penggawé-penggawé kongkonané Gusti Allah Bapakku sing tak tindakké saiki ngujutké nèk Gusti Allah déwé sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Gusti Allah sing ngongkon Aku, Dèkné déwé wis ngomongké bab Aku, senajana kowé durung tau krungu swarané lan weruh rupané. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mulané pituturé Gusti Allah ora bisa manggon ing atimu, awit kowé ora pretyaya marang Aku, kongkonané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kowé pada nyinau Kitab Sutyi, awit kowé mikir nèk kuwi bisa ngekèki urip langgeng. Lah Kitab Sutyi kuwi ngomongké bab sapa? Apa ora ngomongké bab Aku? ");
INSERT INTO jvnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nanging kowé ora gelem mara nang nggonku supaya bisa nampa urip langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Aku ora kepéngin mbok elem. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lan Aku wis ngerti nèk kowé ora trésna marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aku teka jalaran Gusti Allah Bapakku ngongkon Aku, nanging Aku mbok tampik. Nèk ènèng wong liyané sing tekané sangka karepé déwé malah mbok tampa. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kowé ora pada nggolèk lem-lemané Gusti Allah sing siji. Kowé namung kepéngin dielem manungsa, mulané kowé ora bisa pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aja mikir nèk Aku bakal nyalahké kowé nang nggoné Gusti Allah Bapakku. Nanging nabi Moses déwé, sing mbok jagakké, dèkné sing nyalahké kowé. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kowé kuwi ora pretyaya marang nabi Moses. Awit nèk kowé pretyaya marang nabi Moses, kowé mesti ya pretyaya marang Aku, awit sing ditulis karo nabi Moses kuwi ya ngomongké bab Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nanging nèk kowé ora pretyaya marang sing ditulis karo nabi Moses, mosok kowé ya bakal pretyaya tembungku?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sakwisé kuwi Gusti Yésus terus ngabrah mér Galiléa. Mér iki uga jenengé mér Tibérias. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wong okèh banget pada ngetutké Dèkné, awit wis pada weruh penggawé sing nggumun-nggumunké, dongé Dèkné nambani sing lara. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Gusti Yésus terus munggah gunung lan njagong nang kono karo murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Saiki riyaya Paskah wis tyedek. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kadung Gusti Yésus nyawang kiwa-tengen Dèkné weruh wong okèh gemruduk pada teka. Mulané Dèkné terus takon marang rasul Filipus: “Ngendi sing dodol roti kanggo ngekèki mangan wong-wong kabèh iki ya?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Sakjané Gusti Yésus wis ngerti kepriyé enggoné arep ngekèki mangan wong-wong iki, nanging Dèkné namung kepéngin ngerti sepira gedéné pengandelé rasul Filipus. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Rasul Filipus semaur: “Gusti, duwit sak tumpuk waé ijik kurang kanggo nukokké mangan wong seméné okèhé iki, senajana namung dikèki saktyuwil-saktyuwil!” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Rasul Andréas, adiké rasul Pétrus, terus ngomong: “Lah iki ènèng botyah nduwé roti lima lan iwak loro. Nanging apa ya sampé kanggo wong seméné okèhé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Gusti Yésus terus ngomong marang murid-muridé: “Wong-wong pada kongkon njagong kabèh!” Wong-wong terus pada njagong nang suketan. Namung wong lanangé kira-kira ènèng limang èwu okèhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Gusti Yésus terus njikuk rotiné. Sakwisé Dèkné maturkesuwun marang Gusti Allah rotiné terus diedum. Iwaké mbarang, sakwisé didongakké terus diedum-edumké. Kabèh mangan sak wareké. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kadung wis warek kabèh Gusti Yésus terus ngongkon murid-muridé nglumpukké turahané, supaya ora ènèng sing dietyèh-etyèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Turuhané roti lima mau dilumpukké kabèh éntuk rolas ténggok. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wong-wong pada nggumun weruh lelakon kaya ngono kuwi, mulané ngomong: “Pantyèn tenan, wong iki nabi sing kudu teka, nabi sing diarep-arep karo awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Saiki Gusti Yésus ngerti nèk wong-wong arep meksa Dèkné kongkon dadi ratuné, mulané Dèkné terus lunga menèh munggah gunung, déwékan. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Kadung wis surup murid-muridé terus pada numpak prauné arep ngabrah nang kuta Kapèrnakum. Saiki wis molai peteng, nanging Gusti Yésus durung nututi. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Anginé selot banter lan ombaké ya selot gedé. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kadung wis ndayung kira-kira limang kilomèter murid-murid mau weruh Gusti Yésus mlaku nang nduwuré banyu nyedeki prauné. Kabèh pada wedi. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nanging Gusti Yésus ngomong: “Aja pada wedi! Iki Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Murid-muridé terus nembung Gusti Yésus supaya mèlu numpak prauné. Nanging ora suwi, awit prauné wis tekan nggoné. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Ing ésuké wong pirang-pirang pada teka menèh nang panggonan sing ing winginé Gusti Yésus ngedum roti. Wong-wong iki mikiré Gusti Yésus ijik nang kono, awit wingi namung ènèng prau siji lan prau iki digawa ngabrah karo murid-muridé. Wong-wong weruh nèk Gusti Yésus ora mèlu ngabrah. Nanging kadung Gusti Yésus ora ketemu nang kono, wong-wong terus pada ngabrah nang Kapèrnakum karo prau-prau sing teka sangka kuta Tibérias. Wong-wong arep nggolèki Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nang abrahan kono wong-wong terus nemu Gusti Yésus, terus pada takon: “Guru, lah kapan Kowé mbréné?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Gusti Yésus semaur: “Aku ngerti apa jalarané kowé pada nggolèki Aku. Kowé nggolèki Aku jalaran kowé wis pada mangan roti sampèk warek. Ora jalaran kowé dunung tegesé tanda-tanda sing tak tindakké! ");
INSERT INTO jvnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aja nggolèk pangan sing bakal entèk, nanging pada nglumui nggolèk pangan sing ora ènèng entèké, pangan sing bisa ngekèki urip langgeng. Anaké Manungsa sing bisa ngekèki pangan iki. Gusti Allah Bapakku wis ngekèki kwasa marang Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wong-wong terus takon: “Kekarepané Gusti Allah kuwi kepriyé ta? Awaké déwé kudu nglakoni apa waé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Gusti Yésus semaur: “Kekarepané Gusti Allah kuwi namung iki: kowé kudu pretyaya marang Aku, awit Aku kongkonané Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wong-wong terus ngomong: “Nèk ngono, apa tandané nèk Kowé kongkonané Gusti Allah? Awaké déwé kepéngin weruh supaya bisa pretyaya marang Kowé. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mbah-mbahané awaké déwé mbiyèn ya ora tau kekurangan pangan nang wustèn, awit dirangsumi roti sangka swarga karo nabi Moses, kaya sing ketulis nang Kitab: ‘Dèkné ngekèki mangan roti sangka swarga marang wong-wong.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Gusti Yésus terus ngomong: “Tak omong sak beneré, dudu nabi Moses sing ngekèki roti sangka swarga, nanging Gusti Allah Bapakku. Dèkné sing ngekèki roti sangka swarga, yakuwi roti sing sejati. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Roti sing sangka nggoné Gusti Allah kuwi ya roti sing medun sangka swarga lan ngekèki urip langgeng marang manungsa.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wong-wong terus nembung: “Guru, awaké déwé mbok dikèki roti iku sak terusé ta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Gusti Yésus semaur: “Ya Aku iki roti sing ngekèki urip. Sapa sing mara nang nggonku ora bakal ngelih menèh lan sapa sing pretyaya marang Aku ora bakal ngelak menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aku pantyèn wis ngomong! Senajan kowé weruh Aku lan penggawéku, kowé ora pada pretyaya marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nanging ènèng sing pada teka marani Aku, yakuwi wong sing dipilih lan sing dipasrahké marang Aku karo Gusti Allah Bapakku. Wong sing pada teka marani Aku kuwi ora bakal tak tampik. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aku medun sangka swarga kuwi ora arep nglakoni kekarepanku déwé, nanging Aku nglakoni kekarepané Gusti Allah sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Lah kekarepané Gusti Allah kuwi apa? Ya iki: wong sing wis dipasrahké marang Aku kuwi aja sampèk ènèng sing ilang siji-sijia. Malah mbésuk, ing dina sing kèri déwé, dina sing wis dityawiské karo Gusti Allah, wong-wong iki bakal tak tangèkké sangka pati. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kekarepané Gusti Allah Bapakku kuwi ngéné: sapa sing nitèni nèk Aku Anaké lan pretyaya ing Aku bakal nduwèni urip langgeng lan bakal tak tangèkké ing dina kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Wong-wong terus pada nggremeng. Ora pada ngandel apa sing diomong karo Gusti Yésus, ora ngandel nèk Dèkné roti sangka swarga. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Mosok? Dèkné lak anaké Yosèf lan Maria ta? Lah kok wani ngomong nèk Dèkné medun sangka swarga?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","“Aja pada pating gremeng,” Gusti Yésus semaur. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","“Ora ènèng wong sing bisa dadi muridku, nèk dudu Bapakku, sing ngongkon Aku, narik wong kuwi. Mulané wong sing dadi muridku kuwi bakal tak tangèkké sangka pati, mbésuk ing dina sing kèri déwé. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sapa waé sing wis diwulangi lan didunung-dunungké karo Gusti Allah Bapakku bakal pretyaya marang Aku. Lak wis ketulis ta nang kitabé para nabi nèk Gusti Allah bakal mulangi wong-wong! ");
INSERT INTO jvnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ora ngomong nèk ènèng wong sing wis tau weruh Gusti Allah, ora. Sing wis tau weruh ya namung Aku iki, awit Aku tekané sangka nggoné Gusti Allah Bapakku. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Pantyèn tenan. Sapa sing pretyaya marang Aku nduwèni urip langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aku iki roti sing ngekèki urip. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mbah-mbahanmu mbiyèn pada mati kabèh nang wustèn, senajan pada mangan manah. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Séjé banget karo roti sing sangka swarga. Wong sing mangan roti kuwi ora bakal mati. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aku iki roti sing nguripké, roti sing sangka swarga. Sapa sing mangan roti iki bakal urip slawasé. Roti sing tak kèkké ya awakku déwé iki. Awakku tak kèkké supaya jagat iki nduwèni urip.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sakwisé krungu Gusti Yésus ngomong ngono wong-wong terus pada bantah-bantahan karo kantya-kantyané déwé ngomong: “Lah gèk kepriyé wong iki enggoné arep ngekèkké dagingé marang awaké déwé kongkon mangan?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Gusti Yésus semaur: “Pada élinga! Nèk kowé ora mangan dagingé lan ngombé getihé Anaké Manungsa, kowé ora bakal nduwèni urip blas! ");
INSERT INTO jvnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sapa sing mangan dagingku lan ngombé getihku nduwèni urip langgeng. Mbésuk, ing dina sing kèri déwé, wong kuwi bakal tak tangèkké sangka pati. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Awit daging lan getihku kuwi pangan lan ombèn sing sejati. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wong sing mangan dagingku lan ngombé getihku bakal dadi siji karo Aku lan Aku uga dadi siji karo wongé. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Gusti Allah Bapakku sing ngongkon Aku, Dèkné ngekèki urip sing sejati. Aku urip, jalaran Dèkné ngekèki urip iki marang Aku. Mengkono uga sapa sing mangan dagingku bakal urip, jalaran Aku ngekèki urip iki marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ya iku roti sing sangka swarga. Sapa sing mangan roti iki bakal urip slawasé. Ora tunggalé manah sing dipangan wong-wong mbiyèn nang wustèn. Awit kabèh pada mati.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ya iku mau kabèh sing diomong karo Gusti Yésus, dongé Dèkné mulangi nang sinaguk nang kuta Kapèrnakum. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Okèh wong sing pada mèlu Gusti Yésus. Kadung krungu piwulang mau terus pada sambat: “Piwulang iki abot! Sapa sing kuwat?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Senajan ora ènèng sing ngomongi Dèkné, nanging Gusti Yésus ngerti nèk wong-wong mau ora setuju karo piwulangé, mulané pada nggremeng. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Gusti Yésus terus ngomong: “Lah kok pada kagèt? Mbésuk kowé bakal pada weruh déwé Anaké Manungsa balik menèh munggah nang swarga. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sing ngekèki urip kuwi namung Rohé Gusti Allah. Kekuwatané manungsa ora bisa nambahi apa-apa. Tembung-tembung sing tak omongké marang kowé kuwi ngrembuk bab kasukman. Tembung-tembung kuwi sing nguripké. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nanging nang tengahmu ènèng sing ora pretyaya.” Kawit mauné Gusti Yésus wis ngerti sapa waé sing ora gelem pretyaya lan sapa sing bakal ngelungké Dèkné marang mungsuhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Gusti Yésus terus ngomong menèh: “Mulané Aku wis ngomong marang kowé nèk ora ènèng wong gelem dadi muridku, nèk ora Gusti Allah Bapakku sing narik.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sakwisé kuwi okèh wong sing pada mundur, ora gelem mèlu Gusti Yésus menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Gusti Yésus terus ngomong marang murid sing rolas: “Apa kowé mbarang arep ninggal Aku?” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Rasul Simon Pétrus semaur: “Gusti, lah awaké déwé kongkon mèlu sapa? Namung Kowé sing bisa mulangi awaké déwé bab urip langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Awaké déwé saiki wis pretyaya lan wis ngerti tenan nèk Kowé kuwi Kristus, Anaké Gusti Allah sing urip.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Gusti Yésus ngomong: “Sing milih kowé kabèh wong rolas lak Aku déwé ta? Nanging nang tengahmu sing siji Sétan.” ");
INSERT INTO jvnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Gusti Yésus nyemoni Yudas, anaké Simon sangka Iskariot. Awit, senajan Yudas tunggalé murid rolas, nanging dèkné sing bakal ngelungké Gusti Yésus marang mungsuhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sakwisé kuwi Gusti Yésus mlaku turut bawah Galiléa. Dèkné ora gelem nang bawah Yudéa, awit para penggedéné wong Ju nang kono pada nggolèk jalaran arep matèni Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Saiki dongé arep ènèng riyaya gedé, yakuwi riyaya Ngedekké Tarup. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mulané adik-adiké Gusti Yésus pada ngomong marang Dèkné: “Mbok kéné ditinggal. Kana budal nang Yudéa waé, dadiné murid-muridmu bisa weruh kwasamu. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sapa kepéngin kesuwur ora kenèng ndelikké pangwasané. Nèk niyat nduduhké kwasamu, ya dikétokké marang wong kabèh pisan.” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Adik-adiké ngomong ngono kuwi, jalaran ora pada pretyaya marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nanging Gusti Yésus semaur: “Kanggo Aku saiki durung wantyiné. Séjé karo kowé, kowé sak wantyi-wantyi bisa budal. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wong-wong ora bisa sengit marang kowé, awit kowé tunggalé karo wong-wong. Nanging Aku disengiti banget, awit Aku nyalahké wong-wong nèk klakuané ala. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kana kowé pada budal. Aku ora budal ndisik, awit kanggo Aku iki durung wantyiné.” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mulané Gusti Yésus ya terus kèri nang Galiléa kaya sing diomong mau. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kadung adik-adiké wis pada budal, Gusti Yésus terus budal mbarang, nanging ijèn, tanpa ènèng wong sing ngerti. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nang riyaya kono para penggedéné wong Ju pada nggolèki Gusti Yésus. Pada takon marang sakpada-pada: “Wongé nang endi?” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pinemuné wong-wong bab Gusti Yésus séjé-séjé. Enèng sing ngomong: “Yésus kuwi wong apik!” Nanging ènèng liyané sing ngomong: “Ora, Dèkné arep nyasarké wong-wong!” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nanging ora ènèng sing wani ngomong blaka, awit pada wedi karo para penggedé. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nang tengahé minggu riyaya kuwi Gusti Yésus terus mlebu nang Gréja Gedé lan mulangi nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Para penggedéné wong Ju pada nggumun banget, mulané ngomong: “Wong iki lak ora tau mèlu sekolahané awaké déwé ta? Lah kok nduwèni kaweruh semono okèhé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Gusti Yésus semaur: “Sing tak wulangké iki ora pikiranku déwé, nanging piwulangé Gusti Allah sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sapa sing gelem nuruti karepé Gusti Allah mesti bakal nitèni déwé nèk sing tak omong kuwi piwulang sangka Gusti Allah, ora pikiranku déwé. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wong sing mulang manut pikirané déwé kuwi namung nggolèk lem-lemané wong kanggo dèkné déwé. Nanging sapa sing nuju supaya Gusti Allah sing dielem, wong kuwi mesti kenèng diendelké lan dèkné ora bakal nyasarké. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kowé lak wis ditinggali wèté Gusti Allah ta karo nabi Moses? Ya apa ora? Nanging siji waé ora ènèng sing nglakoni. Lah kenèng apa kowé kok arep matèni Aku?” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wong-wong semaur: “Kowé kuwi édan! Sapa sing arep matèni Kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Gusti Yésus ngomong: “Namung barang siji sing tak lakoni ing dina sabat, namung nambani wong lara, lah kowé kok wis pada ramé kaya ngono! ");
INSERT INTO jvnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Wis ping pira waé kowé pada nyunati bayi lanang ing dina sabat nèk wolung dinané tiba ing dina kuwi. Awit nabi Moses wis mulangi kowé, kudu nyunati botyah bayi nèk umuré wis wolung dina. Nanging sakjané dudu nabi Moses sing molai karo sunatan. Sakdurungé nabi Moses ènèng, sunatan wis dilakokké. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nèk kowé nyunati botyah ing dina sabat jalaran kowé manut pernatané nabi Moses, lah kowé kok pada nesu karo Aku nèk Aku nambani wong ing dina sabat? ");
INSERT INTO jvnNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mulané, nèk ngomong kuwi aja namung manut sak weruhmu ing njabané waé, nanging sembarang kudu mbok timbang sing apik ndisik.” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sakwisé kuwi terus ènèng wong siji-loro sangka Yérusalèm kono sing ngomong: “Iki lak wong sing digolèki arep dipatèni kaé ta! ");
INSERT INTO jvnNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lah Dèkné kok malah mulangi nang ngarepé wong-wong. Lah kok ora ènèng sing nyekel? Apa penggedé-penggedéné wong Ju saiki pada pretyaya nèk Dèkné Kristus? ");
INSERT INTO jvnNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mosok ah? Jaréné nèk Kristus teka ora ènèng wong ngerti Dèkné kuwi sangka ngendi! Nanging panggonané wong iki awaké déwé ngerti!” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mulané dongé Gusti Yésus mulangi nang Gréja Gedé Dèkné terus ngomong karo swara sing banter: “Bener, menawa waé kowé pada ngerti Aku iki sapa lan Aku iki sangka ngendi. Nanging tekaku iki ora sangka karepku déwé! Aku iki ènèng sing ngongkon lan sing ngongkon Aku kuwi kenèng mbok pretyaya. Mung waé kowé ora kenal marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nanging Aku ngerti Dèkné, awit Aku tekané sangka nggoné Dèkné lan Dèkné sing ngongkon Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Krungu kuwi wong-wong terus kudu nyekel Gusti Yésus, nanging ora ènèng sing wani, awit durung wantyiné. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Saiki malah wong okèh terus pada pretyaya marang Gusti Yésus. Wong-wong iki pada ngomong: “Ya iki Kristus. Apa bakal ènèng liyané sing bisa nindakké penggawé sing gedéné ngungkuli sing ditindakké wong iki. Aku ora ngandel!” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Para Farisi krungu omongané wong-wong bab Gusti Yésus, mulané terus pada pertimbangan karo para pengarepé imam. Sakwisé kuwi para Farisi lan para pengarepé imam pada ngongkon sekaut-sekauté Gréja Gedé kongkon nyekel Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gusti Yésus ngomong: “Enggonku tyampur karo kowé iki namung garèk sedilut. Ora suwi menèh Aku bakal balik menèh nang nggoné sing ngongkon Aku mbréné iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kowé bakal nggolèki Aku, nanging ora bakal bisa nemu Aku, awit panggonan sing bakal tak enggoni iki kowé ora bisa nekani.” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Para penggedéné wong Ju mau terus pada takon marang sakpada-pada: “Wong iki arep lunga nang endi ta kok ngomong nèk awaké déwé ora bakal bisa nemu Dèkné. Apa Dèkné arep lunga mèlu wong-wong sing saiki pada buyar tyampur wong Grik? Menawa arep mulangi wong-wong sing ora ngerti Gusti Allah? ");
INSERT INTO jvnNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Aku kok ora dunung. Dèkné ngomong nèk awaké déwé bakal nggolèki Dèkné, nanging ora bakal nemu. Dèkné ngomong menèh nèk awaké déwé ora bakal bisa nekani panggonané Dèkné. Dèkné sakjané ngomongké apa ta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dina penutupé riyaya kuwi dina sing penting déwé. Gusti Yésus ngadek terus ngomong banter: “Sapa ngelak, mbrénéa nang nggonku, bakal tak kèki ngombé. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nang Kitab wis ketulis nèk banyu sing nguripké bakal mbludak sangka atiné wong sing pretyaya marang Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nang kéné Gusti Yésus ngomongké bab Roh Sutyi, tegesé, sapa sing pretyaya marang Dèkné bakal nampa Roh Sutyi. Nanging Roh Sutyi durung teka, awit Gusti Yésus durung munggah nang swarga. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Okèh wong sing pada ngrungokké piwulangé Gusti Yésus mau. Enèng sing ngomong: “Wong iki pantyèn nabi sing kudu teka!” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nanging ènèng liyané sing ngomong: “Ya, wong iki Kristus!” Terus ènèng sing liyané menèh semaur: “Mosok? Apa Kristus tekané sangka Galiléa! Ora ngandel Aku? ");
INSERT INTO jvnNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Lak wis ketulis nang Kitab ta nèk Kristus kuwi turunané ratu Daved lan lairé kuwi nang Bètlehèm, kuta lairané ratu Daved.” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Dadiné pikirané wong-wong mau bab Gusti Yésus ora tunggalé, ènèng sing ngomong ngéné, ènèng sing ngomong ngono. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Enèng sing arep nyekel Dèkné, nanging ora pada wani. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sekaut-sekaut sing njaga Gréja Gedé terus pada balik menèh nang nggoné para pengarepé imam lan para Farisi, terus pada ditakoni: “Lah endi wongé? Kok ora mbok gawa mbréné?” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sekaut-sekaut mau semaur: “Piwulangé wongé jan nggumunké tenan. Awaké déwé durung tau krungu wong liyané ngomong kaya wong iki!” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Para Farisi terus ngomong: “Lah apa kowé mbarang wis dikenèng karo wongé? ");
INSERT INTO jvnNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Apa ènèng wong siji waé sangka para penggedéné wong Ju lan sangka para Farisi sing pretyaya marang Dèkné? Lak ora ènèng ta? ");
INSERT INTO jvnNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wong-wong kuwi pada keblinger, awit ora pada dunung isiné Kitab!” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ing tengahé para Farisi iki ènèng wong siji sing wis tau mara nang nggoné Gusti Yésus. Dèkné jenengé Nikodémes. ");
INSERT INTO jvnNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Nikodémes ngomong: “Miturut wèté agamané awaké déwé, awaké déwé ora kenèng nyalahké wong, sakdurungé wongé ditakoni lan digolèki apa salahé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Liyané pada semaur: “E, é, omongmu kok kaya-kaya kowé arep mbélani wong Galiléa kuwi. Mbok digolèki déwé nang Kitab ta, mengko lak kowé weruh déwé nèk Galiléa kuwi ora tau ngetokké nabi.” ");
INSERT INTO jvnNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Sakwisé iki wong-wong terus pada mulih nang omahé déwé-déwé. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Gusti Yésus ora mulih, nanging terus budal nang gunung Olèf. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Esuké Dèkné mruput budal menèh nang Gréja Gedé. Wong okèh teka. Gusti Yésus terus njagong lan mulangi wong-wong iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nang tengahé wulangan terus ènèng guru-guru Kitab lan wong Farisi pada teka nggawa wong wédok kongkon ngadek nang tengahé wong-wong. Wong wédok iki konangan laku bédang. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Guru-guru Kitab lan para Farisi terus ngomong marang Gusti Yésus: “Guru, wong wédok iki konangan laku bédang. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Miturut wèté nabi Moses wong sing nglakoni dosa kaya ngono kuwi kudu dipatèni, dibandemi watu. Lah pinemumu kepriyé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wong-wong takon iki tujuané namung arep ngenèng Gusti Yésus, nggolèk jalaran kanggo nyalahké Dèkné. Nanging Gusti Yésus malah ndingkluk terus nulis nang lemah karo drijiné. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wong-wong mau pada ngetyek terus kepéngin krungu Gusti Yésus semaur, mulané Gusti Yésus terus ngadek lan ngomong: “Sapa sing rumangsa blas ora nduwé salah kenèng molai mbandem watu marang wong wédok iki.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Gusti Yésus terus ndingkluk lan nulis nang lemah menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kadung krungu Gusti Yésus semaur ngono guru-guru Kitab lan para Farisi terus pada lunga siji-siji, molai karo para pinituwa. Dadiné namung garèk Gusti Yésus déwé karo wong wédoké sing ijik nang ngarepé wong-wong kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Gusti Yésus terus ngadek lan takon marang wong wédoké: “Lah wong-wong sing nggawa kowé mbréné pada nang endi saiki? Apa ora ènèng sing nyalahké kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wongé semaur: “Ora Gusti, ora ènèng siji-sijia!” Gusti Yésus terus ngomong: “Aku uga ora nyalahké kowé, kana mulih, nanging aja nglakoni dosa menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ing liya waktu Gusti Yésus ngomong marang wong-wong: “Aku iki pepadangé jagat. Wong sing mèlu Aku ora bakal mlaku ing pepeteng menèh, nanging bakal nduwèni pepadangé urip.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Para Farisi terus semaur: “Kowé kuwi ngomongké awakmu déwé, ora ènèng seksi liyané, tembungmu ora kanggo!” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Gusti Yésus terus ngomong: “Tembungku iki nyata, senajana namung Aku déwé sing ngomongké. Aku ngerti tekaku iki sangka ngendi lan paranku iki nang endi. Nanging kowé ora ngerti apa-apa bab Aku! ");
INSERT INTO jvnNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kowé kuwi nèk ngomong namung manut apa weruhmu waé. Aku ora nyalahké sapa-sapa. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nanging semunggoné Aku kudu nyalahké, putusanku mesti bener, awit dudu Aku déwé sing nggawé putusan, nanging Aku karo Bapakku sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nang wètmu déwé ketulis nèk paseksi bisané kanggo namung nèk ènèng wong loro sing nyeksèni. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Sing dadi seksiku kuwi wong loro, yakuwi Aku déwé lan Bapakku, sing ngongkon Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wong-wong terus takon: “Lah endi Bapakmu.” Gusti Yésus semaur: “Kowé kuwi ora ngerti Aku iki sapa, mulané kowé ya ora pada ngerti Bapakku. Semunggoné kowé ngerti Aku iki sapa, kowé ya mesti ngerti Bapakku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Gusti Yésus ngomong iki dongé Dèkné mulangi nang Gréja Gedé. Dèkné ngadek tyedek karo kotakan-kotakan wadah duwit pawèh marang Gusti Allah. Ora ènèng wong sing nyekel Dèkné, awit durung wantyiné. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ora let suwi Gusti Yésus terus ngomong menèh marang wong-wong: “Aku iki bakal lunga lan kowé bakal pada nggolèki Aku lan bakal mati nggémbol salahmu. Kowé ora bisa teka nang panggonan sing bakal tak parani.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Para pengarepé wong Ju terus ngomong: “Lah wong kuwi kok ngomong nèk awaké déwé ora bisa teka nang panggonan sing arep diparani Dèkné. Wong kuwi arep nggantung apa kepriyé ta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Gusti Yésus terus ngomong: “Kowé kuwi sangka ngisor, nanging Aku sangka nduwur. Kowé wong donya kéné, nanging Aku ora. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mulané, Aku wis ngomong nèk kowé bakal mati nggawa salahmu. Awit nèk kowé ora pada pretyaya nèk Aku iki pantyèn wujut kaya sing tak omong, tenan, nèk mati kowé bakal nggawa salahmu.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wong-wong terus takon: “Kowé kuwi sakjané sapa ta?” Gusti Yésus semaur: “Iku wis ora usah tak omong menèh, awit enggonku ngomong wis ora kurang-kurang. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Okèh prekara sing kudu tak omong kanggo nduduhké salahmu, nanging Aku emoh ngomongké kuwi. Aku namung kepéngin nggelarké marang saben wong apa tembungé sing ngongkon Aku. Dèkné kuwi bener lan kenèng dipretyaya.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wong-wong ora ngerti nèk Gusti Yésus ngomongké bab Gusti Allah, Bapaké. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mulané Gusti Yésus terus ngomong: “Mbésuk nèk kowé wis pada ngunggahké Anaké Manungsa nang kayu pentèngan, kowé bakal ngerti Aku iki sapa. Kowé uga bakal ngerti nèk Aku ora nglakoni apa-apa sangka karepku déwé, nanging sing tak omong namung manut piwulangé Gusti Allah Bapakku marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sing ngongkon Aku kuwi slawasé karo Aku. Dèkné ora tau ninggal Aku déwé, awit Aku slawasé namung nglakoni sembarang sing ndadèkké legané atiné Dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sakwisé Gusti Yésus ngomongké kuwi mau kabèh terus okèh wong sing pada pretyaya marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Gusti Yésus terus ngomong marang wong Ju sing pada pretyaya: “Nèk kowé pada nglakoni piwulangku, kowé kuwi nyata dadi muridku. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kowé bakal nglakoni kekarepané Gusti Allah lan jalaran sangka kuwi kowé bakal merdéka.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wong-wong terus semaur: “Kowé kuwi ngomong apa ta? Awaké déwé bakal merdéka? Kapan awaké déwé tau dadi slafé wong? Awaké déwé lak turunané Bapa Abraham ta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Gusti Yésus semaur: “Pada ngertia! Sapa waé sing nglakoni ala kuwi dadi slafé ala. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Slaf kuwi ora nduwèni kwasa apa-apa lan ora bakal slawasé nang omahé sing nduwé. Nanging anaké wongé nduwèni kwasa nang omah kono slawasé. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mulané, nèk Anaké Gusti Allah wis ngluwari kowé, kowé bakal merdéka tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Aku ngerti nèk kowé kuwi kabèh turunané Bapa Abraham, nanging senajan ngono kowé pada arep matèni Aku, awit piwulangku blas ora mbok tampa ing atimu. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Sing tak omong iki apa sing diduduhké marang Aku karo Bapakku, nanging kowé kuwi nglakoni kekarepané bapakmu, yakuwi Sétan.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wong-wong semaur: “Bapaké awaké déwé kuwi Bapa Abraham!” Gusti Yésus ngomong: “Nèk kowé kuwi turunané Bapa Abraham tenan, klakuanmu ya mesti kaya Bapa Abraham! ");
INSERT INTO jvnNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Aku ngomongi kowé bab sing bener lan sing nyata, awit iki Aku krungu sangka nggoné Gusti Allah déwé, malah Aku arep mbok patèni. Apa Bapa Abraham mbiyèn ya ngono? Lak ora ta! ");
INSERT INTO jvnNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kowé kuwi niru bapakmu!” Wong-wong terus semaur: “Bapakmu? Gusti Allah déwé bapaké awaké déwé lan awaké déwé ora tau ninggal Dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Gusti Yésus ngomong: “Semunggoné Gusti Allah kuwi bapakmu tenan, kowé mesti ya trésna marang Aku. Aku iki tekané sangka nggoné Gusti Allah terus mara nang tengahmu. Aku mbréné iki ora sangka karepku déwé, nanging Gusti Allah sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kowé kuwi ora pada dunung tembungku, awit kowé ora sabar ngrungokké piwulangku! ");
INSERT INTO jvnNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kowé kuwi anaké Sétan lan kowé namung seneng nuruti karepé bapakmu. Sétan kuwi kawit mbiyèné tukang matèni. Klakuané blas ora tau ènèng beneré, awit dèkné setitik waé ora ènèng beneré. Nèk dèkné goroh kuwi pantyèn wis lumrah, awit dèkné tukang goroh lan goroh kuwi tukulé sangka Sétan. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mulané ora nggumunké nèk kowé ora pada pretyaya marang piwulangku, awit piwulangku kuwi bener. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Jajal, sapa sing bisa nduduhké dosaku? Kenèng apa kowé kok ora pada pretyaya marang Aku, senajana Aku ngomong sak beneré. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pantyèn! Wong nèk anaké Gusti Allah tenan mesti ya nggugu tembungé Gusti Allah. Nanging kowé dudu anaké Gusti Allah, mulané ya ora pada nggatèkké marang piwulangé!” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wong-wong terus ngomong: “Awaké déwé lak wis ngomong ta, kowé dudu wong Ju tenan, nanging wong Samaritan. Kowé kelebon sétan!” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Gusti Yésus semaur: “Ora, Aku ora kelebon sétan. Aku nggunggung Gusti Allah Bapakku, nanging kowé malah ngèlèk-èlèkké Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aku ora kepéngin dielem, ora. Enèng siji sing ngelem Aku lan Dèkné bakal nduduhké sapa sing bener lan sapa sing klèru. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Elinga! Wong sing nglakoni piwulangku kuwi slawasé ora bakal ngalami pati.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wong-wong Ju mau terus pada ngomong: “Saiki awaké déwé ngerti tenan nèk kowé gemblung. Bapa Abraham lak mati ta? Lan para nabi mbarang! Lah kowé kok ngomong: ‘Sapa sing nglakoni piwulangku ora bakal mati?’ ");
INSERT INTO jvnNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Lah nèk Bapa Abraham waé mati, para nabi uga kabèh mati, lah kowé kuwi sapa? Apa kowé ngungkuli Bapa Abraham?” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Gusti Yésus semaur: “Apa Aku ngungkuli Bapa Abraham? Semunggoné Aku ngelem awakku déwé, tembungku ora ènèng ajiné. Nanging Gusti Allah déwé, Bapakku, sing ngelem Aku. Dèkné sing mbok arani Gusti Allahmu. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nanging kowé ora kenal marang Dèkné. Aku iki sing kenal marang Dèkné. Aku goroh nèk Aku ngomong Aku ora kenal marang Dèkné, kaya enggonmu pada goroh kuwi. Aku kenal marang Dèkné lan Aku manut marang tembungé. ");
INSERT INTO jvnNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bapa Abraham ngarep-arep tekaku karo bungah. Saiki kuwi wis klakon, mulané Dèkné ya bungah tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wong-wong mau terus ngomong marang Gusti Yésus: “Lah umurmu waé durung ènèng sèket taun kok ngomong nèk wis weruh Bapa Abraham?” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Gusti Yésus semaur: “Pada ngertia! Sakdurungé Bapa Abraham ènèng Aku wis ènèng.” ");
INSERT INTO jvnNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Wong-wong terus pada njikuk watu kanggo mbandemi Gusti Yésus, nanging Dèkné terus ndelik lan lunga sangka Gréja Gedé kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Dongé Gusti Yésus mlaku Dèkné terus weruh wong sing lamur kawit lairé. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Murid-muridé terus takon: “Guru, apa sing marakké wong iki lair lamur: salahé dèkné déwé apa salahé wong tuwané?” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Gusti Yésus semaur: “Ora salahé sapa-sapa! Wongé déwé ora salah lan wong tuwané ya ora salah. Wong kuwi lamur supaya kwasané Gusti Allah bisa kétok sangka uripé. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Saiki pumpung ijik awan awaké déwé kudu nyambutgawé nuruti kekarepané Gusti Allah sing ngongkon Aku. Ora suwi menèh wengi bakal teka lan awaké déwé ora bisa nyambutgawé apa-apa menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Suwéné Aku nang jagat kéné Aku pepadangé jagat.” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sakwisé ngomong ngono Gusti Yésus terus idu nang lemah. Lemahé terus diulet-ulet karo iduné terus diusapké mripaté wongé sing lamur. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Gusti Yésus ngomong marang wongé: “Kana saiki raup nang blumbang Siloam!” (Siloam kuwi tegesé: sing dikongkon.) Wongé terus budal. Sakwisé raup dèkné terus mulih, nanging saiki mripaté wis weruh. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tangga-tanggané lan wong-wong liyané sing saben dinané weruh wongé ngemis pada rasan-rasan: “Wong iki apa dudu sing tukang ngemis kaé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Enèng sing semaur: “Ya, pantyèn dèkné!” Liyané ngomong: “Dudu, namung rupané sing kaya dèkné.” Nanging wong sing mauné lamur semaur: “Pantyèn aku iki sing tukang ngemis!” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wong-wong terus takon: “Lah saiki kowé kok bisa weruh?” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Wong sing jenengé Yésus sing nambani aku. Dèkné ngulet-ulet lemah karo iduné terus diusapké mripatku. Sakwisé kuwi aku terus dikongkon raup nang blumbang Siloam. Kadung aku wis raup aku terus bisa weruh.” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wong-wong takon: “Lah wongé nang endi?” “Embuh ya,” wongé semaur. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Gusti Yésus enggoné ngulet-ulet lemah karo iduné kanggo nambani wong lamur mau ing dina sabat. Ing dina sabat kuwi wong Ju ora éntuk nyambutgawé apa-apa, mulané wongé terus digawa nang nggoné para Farisi arep dikelahké. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Wongé ditakoni: “Kepriyé mripatmu bisané mari?” Wongé semaur: “Mripatku diusapi lemah teles, aku terus raup terus bisa weruh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Enèng para Farisi sing terus ngomong: “Aku ora ngandel nèk wong iki kongkonané Gusti Allah. Nèk wongé ngerti Gusti Allah mosok nerak wèté dina sabat?” Nanging liyané ngomong: “Nèk wong ala mosok bisa nambani wong lamur?” Pinemuné wong-wong séjé-séjé. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wongé terus ditakoni menèh: “Kowé sing ditambani karo wongé, lah kowé ngarani wongé kuwi sapa?” “Dèkné kuwi nabi,” wongé semaur. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nanging para penggedéné wong Ju ora ngandel nèk wongé kuwi mauné lamur terus saiki bisa weruh. Mulané terus nyeluk wong tuwané. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Wong tuwané ditakoni: “Apa iki anakmu sing jaréné lamur kawit lairé. Lah saiki kok bisa weruh?” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wong tuwané semaur: “Ya, iki anakku sing lamur kawit lairé! ");
INSERT INTO jvnNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nanging awaké déwé ora ngerti kepriyé dèkné bisané weruh saiki lan sapa sing nambani. Mbok dèkné ditakoni déwé ta. Dèkné wis gedé, mesti ya bisa ngomong déwé!” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wong tuwané ngomong ngono kuwi, jalaran pada wedi karo para Farisi. Awit para Farisi wis pada setuju nèk sapa waé sing ngakoni nèk Gusti Yésus kuwi Kristus, wong kuwi bakal dietokké sangka sinaguk. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kuwi jalarané wong tuwané ngomong marang wong-wong kongkon takon déwé. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wongé terus dityeluk sepisan menèh lan diomongi: “Janjia nang ngarepé Gusti Allah nèk kowé ora goroh. Awaké déwé weruh nèk Yésus kuwi wong salah.” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wongé semaur: “Embuh wongé wong salah embuh ora, kuwi aku ora ngerti. Aku namung ngerti nèk aku mauné lamur, nanging saiki aku bisa weruh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Lah kowé diapakké kok saiki bisa weruh?” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Aku mau lak wis ngomong ta, nanging kowé ora gelem ngrungokké. Apa kowé mbarang kepéngin dadi muridé Dèkné!” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wong-wong terus pada nesu ngomong: “Kowé sing dadi muridé Dèkné. Awaké déwé iki muridé nabi Moses. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Awaké déwé ngerti nèk Gusti Allah wis omong-omongan karo nabi Moses, nanging Yésus kuwi embuh sangka ngendi, awaké déwé ora ngerti.” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wongé terus semaur: “Saiki aku jan nggumun tenan. Lah wongé sing nambani mripatku marakké aku bisa weruh kok kowé durung ngerti Dèkné kuwi sapa? ");
INSERT INTO jvnNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Awaké déwé ngerti nèk Gusti Allah ora nampa pandongané wong salah. Gusti Allah namung ngrungokké marang wong sing ngajèni lan manut marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kawit mbiyèn awaké déwé ora tau krungu nèk ènèng wong tau nambani mripaté wong lamur kawit lairé, terus bisa weruh. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nèk wong iki dudu Gusti Allah sing ngongkon Dèkné mesti ya ora bisa nambani aku?” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Para Farisi terus semaur: “Kowé kuwi apa? Kawit lairmu tekan saiki kowé kebek salah. Lah kowé kok arep mulangi awaké déwé!” Wongé terus dietokké sangka sinaguk. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Gusti Yésus krungu nèk wongé dietokké sangka sinaguk. Kadung kepetuk karo wongé Dèkné terus ngomong: “Apa kowé pretyaya marang Anaké Manungsa?” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wongé semaur: “Lah Anaké Manungsa kuwi sapa ta? Aku kepéngin ngerti, dadiné aku bisa pretyaya marang Dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Gusti Yésus ngomong: “Kowé wis weruh wongé, ya sing omong-omongan karo kowé iki!” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Aku pretyaya, Gusti!” Wongé terus niba nyembah Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Gusti Yésus ngomong: “Tekaku nang jagat kéné ngétokké sapa sing gelem manut marang Gusti Allah lan sapa sing ora! Dadiné, sing lamur bisa weruh lan sing weruh dadi lamur.” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Enèng wong Farisi sing krungu kuwi terus pada ngomong: “Apa awaké déwé iki lamur?” ");
INSERT INTO jvnNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Gusti Yésus semaur: “Semunggoné kowé lamur, kowé ora nduwé salah. Lah saiki kowé déwé ngomong nèk kowé weruh, mulané kowé salah sak terusé!” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Gusti Yésus terus mulangi wong-wong mau nganggo gambar ngéné: “Iki dirungokké sing apik. Nèk ènèng wong mlebu kandang wedus, nanging ora liwat lawangé, wong kuwi mesti maling apa tukang ngrampok. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","3","Pangoné mlebu kandang liwat lawangé lan sing jaga kandang mesti bakal mbukakké lawangé. Wedusé kabèh nitèni swarané pangoné. Wongé nyeluki jenengé wedusé siji-siji terus digiring metu arep diengon. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nèk wedusé kabèh wis dietokké, pangoné terus mlaku nang ngarep déwé. Wedusé terus ngetutké dèkné, awit kabèh nitèni swarané. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wedus-wedus iki ora bakal ngetutké wong liyané. Nèk ènèng wong liyané teka, wedusé malah pada mblayu lunga, awit ngerti nèk kuwi dudu pangoné.” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Gusti Yésus nganggokké gambar iki, nanging wong-wong ora dunung. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","8","Mulané Dèkné terus ndunung-ndunungké ngéné: “Omongku iki dirungokké sing apik tenan! Ya Aku iki lawangé kandang wedus. Kabèh sing tekané sakdurungé Aku, kuwi maling lan tukang ngrampok. Mulané wedus-wedus ora ngrungokké swarané. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aku iki lawangé. Wong sing mlebu liwat Aku bakal slamet. Wong kuwi mlebu-metu bakal nemu pangan. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kowé pada ngerti, maling kuwi tekané namung arep nyolong, matèni lan ngrusak. Nanging Aku teka ngekèki urip kalubèran. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aku iki pangon sing sejati. Pangon sing sejati saguh mati nglabuhi wedus-wedusé. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Wong sing namung kerja angon kuwi dudu pangoné lan dudu sing nduwé wedusé. Wong kaya ngono kuwi malah mblayu lunga nèk ènèng kéwan galak teka arep mangan wedusé. Wedus-wedusé mesti ditinggal, awit dèkné namung kerja. Wedus-wedusé ditubruk karo kéwané galak terus pada buyar. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Aku iki pangon sing sejati. Kaya enggoné Gusti Allah Bapakku mangertèni Aku lan Aku mangertèni Dèkné, kaya ngono uga Aku ngerti wedusku siji-sijiné lan wedusku siji-sijiné ya ngerti Aku. Aku ora éman uripku kanggo nglabuhi wedus-wedusku. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aku uga nduwé wedus-wedus liyané sing ora nang kandang kéné. Wedus-wedus kuwi uga kudu tak engon lan bakal pada ngrungokké swaraku. Bakal tak giring dadi siji karo wedus-wedus sing wis nang kéné. Dadiné wedus-wedusku kabèh bakal tunggal kandang lan tunggal pangon. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Gusti Allah Bapakku nrésnani Aku, awit Aku masrahké uripku, supaya Aku bisa nampa uripku menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aku masrahké uripku sangka karepku déwé. Ora ènèng sing bisa ngrebut sangka Aku. Mati ya karepku déwé lan urip ya karepku déwé. Kuwi kekarepané Gusti Allah Bapakku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tembung-tembungé Gusti Yésus kuwi marakké para penggedéné wong Ju sing nang kono pada èngkèl-èngkèlan. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Okèh sing ngomong: “Yésus kuwi wong édan, wong kelebon sétan. Aja dirungokké.” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Saloké ngomong: “Nèk wong kelebon sétan mosok bisa mulangi kaya ngono. Mosok sétan bisa nambani wong lamur? Lak ora ta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Saiki nang kuta Yérusalèm ènèng riyaya gedé. Saben taun ènèng riyaya iki kanggo ngélingké bukakané Gréja Gedé. Riyaya iki tiba wayahé adem. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Gusti Yésus mlaku-mlaku nang Gréja Gedé kono nang panggonan sing jenengé Gadriné Soléman. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Para penggedéné wong Ju terus pada ngubengi Dèkné takon: “Mbok awaké déwé ndang diomongi ta! Nèk kowé kuwi pantyèn Kristus tenan, mbok ngomong blaka ta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Gusti Yésus terus semaur: “Aku lak wis ngomong ta! Nanging kowé ora gelem pretyaya. Aku nindakké penggawé sing nggumun-nggumunké kanggo tanda nèk Gusti Allah Bapakku sing ngongkon Aku lan sing ngekèki kwasa Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nanging kowé meksa ora pretyaya. Kowé ngerti kenèng apa kowé kok ora pada pretyaya? Jalaran kowé kuwi dudu wedusku. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wedusku nitèni swaraku lan mèlu Aku. Aku ngerti wedusku siji-sijiné. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kabèh tak kèki urip langgeng lan ora bakal tiba ing karusakan. Ora ènèng sing bisa ngrebut wedusku sangka tanganku. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Gusti Allah Bapakku sing ngekèki wedus-wedus kuwi marang Aku lan kwasané Gusti Allah Bapakku kuwi ngungkuli kwasa sak kabèhé. Ora ènèng sing bisa ngrebut wedus-wedusku sangka kwasané Gusti Allah Bapakku. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aku karo Gusti Allah Bapakku kuwi tunggalé.” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Para penggedéné wong Ju terus njikuki watu menèh arep dienggo mbandemi Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Gusti Yésus terus ngomong: “Kowé lak wis pada weruh déwé ta? Wis ping pira Aku nindakké penggawé betyik? Kuwi mau kabèh sangka karepé Gusti Allah Bapakku. Lah sing endi sing marakké kowé arep mbandemi watu Aku?” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wong-wong mau terus semaur: “Dudu kuwi sing marakké awaké déwé arep mbandemi kowé! Kowé kuwi namung manungsa ta? Lah kok ngomong nèk Kowé karo Gusti Allah tunggalé. Kowé kuwi ngèlèk-èlèkké Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Gusti Yésus terus ngomong: “Nang kitabmu déwé Gusti Allah lak tau ngomong ngéné ta marang wong-wong sing dikongkon nuntun bangsané: ‘Kowé kuwi pada tak arani allah!’ Lan kowé ngerti ta nèk sing ketulis nang Kitab kuwi nyata. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Lah nèk wong-wong sing dipilih dikongkon nuntun bangsané diarani allah karo Gusti Allah, lah kowé kok pada nyalahké Aku. Kok pada ngomong nèk Aku ngèlèk-èlèkké Gusti Allah? Lak Gusti Allah déwé ta sing miji Aku lan ngongkon Aku teka nang jagat kéné? Lah Aku kok ora éntuk ngomong nèk Aku iki Anaké Gusti Allah? ");
INSERT INTO jvnNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nèk Aku ora ngétokké kwasané Gusti Allah Bapakku, kowé ora usah pretyaya marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kowé kabèh wis pada weruh déwé, nanging meksa kowé ora pada pretyaya marang Aku. Senajana kowé ora pretyaya marang Aku, mbok pada pretyayaa tanda-tanda sing tak tindakké kuwi. Dadiné kowé bisa nitèni lan dunung nèk Gusti Allah Bapakku karo Aku siji lan Aku karo Gusti Allah Bapakku ya siji.” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wong-wong krungu Gusti Yésus ngomong ngono kuwi terus arep nyekel Dèkné, nanging Gusti Yésus terus nglungani. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Dèkné terus ngabrah laut Yordan tekan sakwijiné panggonan. Mbiyèn Yohanes molai mbaptis nang panggonan kuwi. Gusti Yésus terus nang kono rada suwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Okèh wong pada teka nang nggoné Gusti Yésus lan pada ngomong: “Yohanes déwé ora tau nindakké penggawé sing nggumunké, nanging sembarang sing diomong karo dèkné bab Gusti Yésus kuwi nyata.” ");
INSERT INTO jvnNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mulané wong okèh terus pada pretyaya marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Saiki nang désa Bétani ènèng wong lara. Wong iki jenengé Lasarus, kakangé Marta lan Maria. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ya Maria iki sing ora let suwi menèh ngusapi sikilé Gusti Yésus karo lenga wangi sing larang terus dilapi karo rambuté. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Marta lan Maria terus kongkonan ngomongi Gusti Yésus nèk Lasarus lara. Lasarus kuwi ditrésnani karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kadung Gusti Yésus krungu kabaré, Dèkné terus ngomong ngéné: “Pernyakit iki ora bakal marakké Lasarus ninggal, malah bakal kanggo ngluhurké Gusti Allah lan jalaran sangka kuwi uga ngluhurké Anaké Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Bener Gusti Yésus trésna tenan marang Lasarus, Marta lan Maria, nanging Dèkné meksa ora ndang budal, malah ijik ngentèni rong dina menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sakwisé rong dina kuwi Gusti Yésus terus ngejèk murid-muridé ngomong ngéné: “Hayuk budal nang Yudéa menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Murid-muridé semaur: “Guru, apa Kowé wis lali nèk para penggedéné wong Ju pada arep matèni kowé nang kana. Lak durung suwi waé ta? Lah Kowé kok arep balik nang Yudéa menèh?” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Gusti Yésus ngomong ngéné: “Sedina kuwi lak rolas jam ta. Nèk kowé mlaku ing wayah awan kowé ora bakal kesandung, awit padang. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nanging nèk kowé mlaku ing wayah wengi, kowé bakal kesandung, awit peteng.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gusti Yésus terus ngomong menèh: “Lasarus, kantyané awaké déwé, wis turu saiki, nanging dèkné arep tak gugah.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Murid-muridé mikir nèk Lasarus wis bisa turu kepénak, mulané terus pada ngomong: “Gusti, nèk Lasarus wis bisa turu kepénak, dèkné ya mesti ndang mari.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sakjané Gusti Yésus ngomongké nèk Lasarus wis ninggal, mulané terus ngomong blaka waé: “Lasarus wis ninggal! ");
INSERT INTO jvnNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Aku bungah nèk Aku durung nang kana, dadiné kowé bisa weruh menèh lan bisa pretyaya. Mulané hayuk saiki pada budal nang nggoné Lasarus.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Rasul Tomas, anak kembar, terus ngomong marang murid-murid liyané: “Hayuk awaké déwé pada mèlu waé, dadiné bisa mati bareng karo Gusti Yésus.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kabèh terus budal nang désa Bétani. Kadung wis tekan nggoné, Gusti Yésus krungu nèk Lasarus wis dikubur patang dina. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bétani kuwi ora adoh karo Yérusalèm, namung kira-kira telung kilomèter. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mulané para penggedéné wong Ju okèh sing pada teka niliki Maria lan Marta sing kepatèn. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kadung krungu nèk Gusti Yésus teka, Marta terus metu arep mapak, nanging Maria ora mèlu. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta terus ngomong marang Gusti Yésus: “O Gusti, nèk Kowé wis teka kawit wingi-wingi kakangku mesti ora sida ninggal. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nanging uga saiki, senajan dèkné wis ninggal, aku ngerti nèk Gusti Allah bakal ngekèki Kowé apa penjalukmu.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Gusti Yésus semaur: “Marta, kakangmu bakal urip menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tembungé Marta: “Bener Gusti, aku ngerti nèk dèkné bakal urip menèh, mbésuk ing dina sing kèri déwé, nèk kabèh wong mati bakal tangi menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Gusti Yésus terus ngomong: “Ya Aku iki sing nangèké wong mati lan ngekèki urip langgeng. Sapa sing pretyaya marang Aku bakal urip menèh, senajan wis mati. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wong kuwi wis nampa urip langgeng lan ora bakal mati slawasé, jalaran pretyaya marang Aku. Apa kowé pretyaya kuwi, Marta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta semaur: “Ya Gusti, aku pretyaya tenan nèk Kowé kuwi Kristus, Anaké Gusti Allah sing kudu teka nang jagat kéné.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta terus balik nang nggoné Maria lan ngomong alon-alon marang dèkné: “Maria, Guruné wis teka. Dèkné nékokké kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Sakwisé krungu kuwi Maria terus sakwat ngadek arep metuki Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Gusti Yésus durung mlebu nang désané, nanging ijik nang panggonan dongé kepetuk karo Marta. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Para penggedéné wong Ju sing pada teka nglipur Maria weruh dèkné menyat lunga, ndarani Maria arep nangis nang kuburan, terus pada ngetutké. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kadung Maria wis tekan nggoné Gusti Yésus, dèkné terus niba nang ngarepé ngomong: “O Gusti, nèk Kowé wis nang kéné kawit wingi-wingi, kakangku mesti ora sida ninggal.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Gusti Yésus weruh Maria lan wong-wong sing pada mèlu mbrono mau pada nangis, Dèkné terus krasa melas lan sedi banget. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Dèkné terus takon: “Lasarus mbok kubur nang endi?” “Hayuk tak gawa nang kuburané, Gusti,” wong-wong semaur. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mripaté Gusti Yésus terus metu eluhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Para penggedéné wong Ju sing pada weruh kuwi terus ngomong: “Dèkné jan trésna tenan marang Lasarus!” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nanging saloké ènèng sing ngomong ngéné: “Dèkné lak bisa nambani wong sing lamur ta! Ajuré ya bisa ngalang-alangi supaya Lasarus ora mati.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Saiki Gusti Yésus wis tekan kuburané, atiné terus krasa susah lan jèngkèl menèh. Kuburané kuwi guwa sing ditutupi watu gedé. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Gusti Yésus terus ngomong: “Kuburané dibukak!” Marta semaur: “Gusti, kakangku wis dikubur patang dina suwéné. Saiki wis mambu!” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Gusti Yésus ngomong marang Marta: “Aku lak wis ngomong marang kowé ta! Nèk kowé pretyaya tenan marang Aku, kowé bakal weruh sepira gedéné kwasané Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Watuné sing dienggo nutupi kuburané terus disurung. Gusti Yésus terus nyawang nduwur lan ndonga: “Bapakku, Aku kesuwun nèk Kowé nampa pandongaku. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aku déwé ngerti nèk saben-saben Aku ndonga marang Kowé, apa penjalukku keturutan. Nanging Aku ngomong kuwi mau, supaya wong-wong sing nang kéné iki pada krungu lan pada pretyaya nèk Kowé sing ngongkon Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sakwisé ndonga, Gusti Yésus terus mbengok: “Lasarus, metua mbréné!” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasarus, sing mauné mati, terus metu, nanging tangané lan sikilé ijik dibuntel mori. Rainé mbarang ijik ditutupi katyu mori. Gusti Yésus terus ngomong: “Moriné diutyuli supaya wongé bisa mlaku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Para penggedéné wong Ju sing mèlu Maria pada weruh lelakon kuwi mau, mulané terus ènèng okèh sing pada pretyaya marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nanging ènèng sing pada budal nang nggoné para Farisi mbarang ngomongké nèk Gusti Yésus nguripké Lasarus menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mulané para pengarepé imam lan para Farisi terus pada nglumpukké para penuntuné agama lan nang begandringan kono terus pada takon: “Lah awaké déwé saiki kepriyé? Yésus iki nindakké penggawé sing nggumun-nggumunké. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nèk diejarké ngono suwi-suwi wong kabèh pada mèlu Dèkné. Mengko bangsa Rum wedi nèk bangsané awaké déwé ora bakal manut lan entèk-entèké bangsa Rum bakal ngrusak Gréja Gedé lan bangsané awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Nanging Kayafas, Imam Gedé, semaur ngéné: “Mosok kowé durung pada dunung? Luwung Dèkné sing mati tenimbang awaké déwé kabèh sak bangsa.” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafas ngomong ngono kuwi ora sangka pikirané dèkné déwé, nanging Gusti Allah sing ngekèki tembung dèkné, awit dèkné kuwi Imam Gedé ing taun kuwi. Kuwi jalarané dèkné ngomongké nèk Gusti Yésus kudu mati nglabuhi bangsané. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Lan menèh, Gusti Yésus enggoné mati ora namung nglabuhi bangsané waé, nanging uga supaya kabèh wong sing pretyaya marang Dèkné bisa dadi siji, senajana pada pentyar sakparan-paran. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sakploké dina kuwi para penggedéné wong Ju pada nggolèk akal arep matèni Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mulané Gusti Yésus ora ngétok menèh nang tengahé wong-wong, nanging Dèkné terus lunga sangka kono budal nang kuta Efraim, tyedek karo wustèn. Gusti Yésus terus nang kono karo murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Saiki wayahé Paskah wis tyedek, mulané wong okèh pada teka nang Yérusalèm arep pada nindakké sesutyèn. ");
INSERT INTO jvnNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wong-wong pada lingak-linguk nggolèki Gusti Yésus. Nèk pada ngumpul nang Gréja Gedé kono terus pada takon marang sakpada-pada: “Dèkné bakal teka apa ora ya?” ");
INSERT INTO jvnNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Para pengarepé imam lan para Farisi wis ngongkon ngabar-ngabarké, nèk ènèng wong ngerti Gusti Yésus kuwi nang endi, kudu diomongké, supaya Dèkné dityekel. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nem dina sakdurungé riyaya Paskah molai Gusti Yésus teka nang désa Bétani. Bétani kuwi panggonané Lasarus, sing mauné wis mati, nanging terus ditangèkké menèh karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mulané saiki wong-wong pada mangan énak karo Gusti Yésus. Sing ladèn Marta, lah Lasarus jejagongan karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria kok terus njikuk lenga-wangi sak botol diesokké nang sikilé Gusti Yésus terus diusapi karo rambuté. Sak omah terus malih mambu lenga-wanginé. Kuwi lenga-wangi nardus sing tus, sing regané larang banget. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Nanging muridé Gusti Yésus sing jenengé Yudas Iskariot, nyenèni Maria ngéné: “Lenga-wangi kuwi semunggoné diedol payu pirang duwit waé, lak kenèng dienggo nulungi wong sing ora nduwé ta?” Ya Yudas iki sing mbésuké ngelungké Gusti Yésus marang mungsuhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Dèkné ngomong ngono kuwi sakjané ora jalaran dèkné mikirké wong sing ora nduwé, ora, nanging jalaran dèkné kuwi maling. Dèkné sing nyekel duwit lan dèkné ajek njikuki dienggo dèkné déwé. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Gusti Yésus terus ngomong ngéné: “Mbok bèn! Maria ngusapi Aku karo lenga-wangi iki ènèng tujuané. Dèkné molai tata-tata kanggo mbésuk nèk Aku bakal dikubur. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wong mlarat kuwi slawasé ènèng waé, nanging enggonku tyampur karo kowé iki ora suwi.” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Saiki wong okèh pada krungu nèk Gusti Yésus nang Bétani kono, mulané terus pada mbrono mbarang. Nanging ora namung kepéngin weruh Gusti Yésus waé, wong-wong uga kepéngin weruh Lasarus sing urip menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Lelakoné Lasarus kuwi marakké wong Ju pirang-pirang pada pretyaya marang Gusti Yésus. Mulané para pengarepé imam saiki arep matèni Lasarus mbarang. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Liyané dina wong pirang-pirang pada teka nang Yérusalèm arep ngurmat riyaya Paskah. Wong-wong iki krungu nèk Gusti Yésus arep teka mbrono mbarang. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mulané terus pada metu sangka kutané arep mapak Gusti Yésus. Wong-wong nggawa godong palem terus pada nyuraki Gusti Yésus ngomong: “Hosana, muga slameta kongkonané Gusti Allah sing teka iki, sing bakal dadi ratuné bangsa Israèl.” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Gusti Yésus nemu kimar enom terus ditumpaki. Kuwi tyotyok karo sing wis ketulis nang Kitab. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ayat kuwi uniné ngéné: “Aja wedi, anak Sion! Delokké, ratumu teka numpak kimar enom.” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ing waktu kuwi murid-muridé durung dunung apa sing klakon iki, nanging sakwisé Gusti Yésus mati lan tangi menèh sangka pati terus pada kélingan apa sing ketulis nang Kitab lan pada ngerti nèk kuwi saiki wis klakon kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Wong-wong sing pada weruh Gusti Yésus nangèké Lasarus sangka pati terus pada ngomong-omongké bab kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mulané wong pirang-pirang terus budal metuki Gusti Yésus, jalaran pada krungu Dèkné nindakké penggawé sing nggumunké tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Para Farisi saiki terus ngomong marang sakpada-pada: “Kowé weruh déwé ta! Awaké déwé wis ora bisa apa-apa! Delokké kuwi! Sasaté wong kabèh pada ngetutké Yésus!” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bareng karo wong-wong sing pada nang riyaya kono uga ènèng wong Grik siji-loro teka arep nyembah Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Lah terus ènèng sing mara nang nggoné rasul Filipus mbarang. Rasul Filipus kuwi muridé Gusti Yésus sing sangka kuta Bètsaida nang bawah Galiléa. Wong-wong Grik kuwi takon marang rasul Filipus ngéné: “Kangé, awaké déwé kepéngin omong-omongan karo Yésus!” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Rasul Filipus terus ngomongi Andréas lan kabèh loro terus mara nang nggoné Gusti Yésus ngomongké bab karepé wong-wong Grik mau. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Gusti Yésus semaur ngéné: “Pantyèn, saiki wis wantyiné. Gusti Allah bakal ngluhurké Anaké Manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Dirungokké sing apik omongku iki: gabah sak elas kaé nèk ora dipendem nang lemah terus mati ya ora bakal dadi okèh. Slawasé ya sak elas waé. Nanging nèk dipendem nang lemah terus mati, malah bisa ngetokké woh okèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mulané, sapa sing éman uripé malah bakal kélangan. Nanging sapa sing ora éman uripé ing donya iki, malah bakal nemu urip sing langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Lan menèh, sapa sing kepéngin ngladèni Aku kudu ngetutké Aku, supaya bisa mèlu Aku ngendi paranku. Sapa sing ngladèni Aku bakal diajèni karo Gusti Allah Bapakku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Gusti Yésus terus ngomong menèh: “Atiku saiki sedi lan bingung. Lah Aku kudu ngomong apa? Mosok Aku nembung marang Gusti Allah Bapakku supaya Aku ora usah nglakoni kasangsaran iki? Ora, awit Aku teka nang jagat kéné tujuané nglakoni kuwi!” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Gusti Yésus terus ndonga: “Gusti Allah Bapakku, mbok diluhurké Jenengmu!” Sakwisé Gusti Yésus ndonga ngono kuwi terus ènèng swara sangka langit ngomong ngéné: “Wis tak kétokké kwasaku, nanging bakal tak wujutké sepisan menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wong-wong sing nang kono uga krungu swarané, ndarani ènèng gluduk. Liya-liyané ngomong nèk ènèng mulékat omong-omongan karo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nanging Gusti Yésus ngomong ngéné: “Swara kuwi mau ora kanggo Aku, nanging kanggo kowé. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Saiki wis wantyiné enggoné Gusti Allah bakal nduduhké salahé manungsa nang jagat kéné. Saiki wis wantyiné enggoné Sétan, sing ngwasani jagat iki, bakal diedunké. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nanging Aku bakal diunggahké sangka bumi iki. Nèk Aku diunggahké sangka bumi iki, Aku bakal narik wong kabèh marang Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kuwi Gusti Yésus ngomongké nèk Dèkné bakal mati nang kayu pentèngan. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mulané wong-wong terus pada semaur: “Lo, awaké déwé ngerti sangka Kitab nèk Kristus bakal urip slawasé. Lah jaréné Kowé Anaké Manungsa, lah Kowé kok ngomong nèk Kowé bakal mati. Lah Anaké Manungsa kuwi sapa?” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Gusti Yésus terus ngomong ngéné marang wong-wong: “Aja pada bingung. Pepadang iki nang tengahmu mung garèk sak gebyaran waé. Mulané, pumpung ijik ènèng, mlakua nang pepadang. Mengko nèk wis peteng kowé ora weruh dalan. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pretyayaa marang pepadang, pumpung ijik ènèng nang tengahmu, supaya kowé dadi anaké pepadang.” Sakwisé ngomong ngono kuwi Gusti Yésus terus lunga, ora ngétok marang wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nanging senajana Gusti Yésus nindakké penggawé sing nggumun-nggumunké lan wong-wong pada weruh déwé, meksa wong-wong ora pretyaya marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pantyèn tyotyok tenan karo sing diomong karo nabi Yésaya, sing uniné ngéné: “Gusti, sapa sing gelem pretyaya tembungé awaké déwé? Sapa sing gelem nggatèkké marang kwasamu? Ora ènèng!” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mulané, kangèlan tenan wong-wong enggoné arep pretyaya. Nabi Yésaya mbiyèn ya wis tau ngomong ngéné mbarang: ");
INSERT INTO jvnNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gusti Allah sing marakké wong-wong ora weruh lan Gusti Allah sing marakké wong-wong atiné kaku. Nèk ora ngono, mengko ndak pada dunung lan pada balik menèh nang nggoné Gusti Allah lan diwaraské.” ");
INSERT INTO jvnNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kuwi mau nabi Yésaya ngomongké bab Gusti Yésus, awit nabi Yésaya wis weruh kwasané Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nanging senajan kepriyé waé ènèng wong gedé-gedé pirang-pirang, yakuwi penggedé-penggedéné wong Ju, sing pada pretyaya nèk Gusti Yésus kuwi kongkonané Gusti Allah. Nanging wong-wong iki pada wedi karo para Farisi, mulané ora gelem blaka nèk pretyaya, mengko ndak dietokké sangka sinaguk. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Karomenèh wong-wong luwih seneng dielem manungsa tenimbang dielem Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ing liya dina Gusti Yésus terus ngomong ngéné marang wong-wong: “Wong sing pretyaya marang Aku kuwi sakjané ora namung pretyaya marang Aku waé, nanging wong kuwi pretyaya marang Gusti Allah, awit Gusti Allah sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Dadiné wong sing weruh Aku kuwi uga weruh Gusti Allah sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tekaku nang jagat kéné dadi pepadang, supaya wong sing pretyaya marang Aku ora nang pepeteng menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nèk ènèng wong ngrungokké pituturku nanging ora dilakoni, Aku ora bakal nyetrap wong kuwi. Aku teka nang jagat kéné ora arep nyalahké manungsa, ora. Aku mbréné iki arep nulungi manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aku ora bakal nyalahké wong sing nyepèlèkké Aku lan sing ora manut pituturku, ora! Nanging pitutur sing tak gelarké, kuwi sing bakal nyalahké manungsa, mbésuk nèk kabèh wong bakal dikrutu. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Enggonku memulang ora metu sangka karepku déwé, ora. Gusti Allah Bapakku sing ngongkon Aku, Dèkné sing ngomongi Aku apa sing kudu tak omong. ");
INSERT INTO jvnNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Lan Aku ngerti nèk sing dikarepké karo Gusti Allah kuwi nggawa urip langgeng kanggo manungsa. Mulané, sing tak omong ya namung apa omongé Gusti Allah Bapakku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Riyaya Paskah wis kurang sedina. Gusti Yésus wis ngerti nèk saiki Dèkné kudu ninggal jagat kéné lan kudu budal nang nggoné Gusti Allah Bapaké. Gusti Yésus pantyèn nrésnani murid-muridé sing nang jagat kéné lan saiki Dèkné kepéngin nduduhké nèk katrésnané Dèkné langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Saiki Gusti Yésus lan murid-muridé ijik jejagongan mangan. Yudas, anaké Simon Iskariot, wis dikenèng karo Sétan lan arep ngelungké Gusti Yésus marang mungsuhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Gusti Yésus wis ngerti kuwi lan Dèkné uga ngerti nèk sembarang wis dipasrahké marang Dèkné karo Gusti Allah. Gusti Yésus uga ngerti nèk Dèkné tekané sangka nggoné Gusti Allah lan kudu balik menèh nang nggoné Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mulané Dèkné terus ngadek, saliné njaba disèlèhké, terus ngubetké gombal nang bangkèkané. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sakwisé kuwi sikilé murid-muridé terus disirami lan diwisuhi terus dilapi karo gombal sing diubetké nang bangkèkané mau. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kadung tiba rasul Simon Pétrus sing kudu disiram sikilé, dèkné menging Gusti Yésus ngomong ngéné: “Gusti, mosok Kowé arep misuhi sikilku?” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Gusti Yésus semaur: “Enggonku misuhi sikilmu iki saiki kowé durung ngerti apa tegesé, nanging mbésuk kowé bakal dunung.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Rasul Pétrus terus ngomong: “Aja Gusti, Kowé aja pisan-pisan misuhi sikilku!” Gusti Yésus semaur: “Nèk kowé ora tak wisuhi, kowé ora bisa nyambutgawé karo Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saiki rasul Simon Pétrus terus ngomong: “Nèk ngono ya aja namung sikilku sing diwisuhi, nanging tanganku lan sirahku mbarang!” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nanging Gusti Yésus semaur: “Wong sing wis adus kuwi wis resik kabèh awaké. Namung sikilé sing kudu diwisuhi. Kowé wis resik, awit salahmu wis dingapura, nanging ora kowé kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Gusti Yésus ngerti sapa sing arep ngelungké Dèkné marang mungsuhé, mulané Dèkné ngomong nèk ora kabèh resik. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sakwisé Gusti Yésus misuhi sikilé murid-muridé, Dèkné terus nganggo saliné njaba menèh terus njagong. Dèkné terus ngomong: “Apa kowé pada dunung kenèng apa kok Aku misuhi sikilmu? ");
INSERT INTO jvnNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kowé lak ngarani Aku iki Gurumu lan Gustimu ta? Kuwi bener, Aku pantyèn Gurumu lan Gustimu tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Lah nèk Aku iki, sing dadi Gurumu lan Gustimu, misuhi sikilmu, kowé uga kudu misuhi sikilé liyané. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aku wis ngekèki tulada marang kowé, kuwi kudu mbok lakoni uga. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mulané pada élinga sing tak omong iki: slaf kuwi ora ngungkuli sing nduwé lan wong sing dikongkon ora ngungkuli sing ngongkon. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Saiki kowé wis pada ngerti iki, beja kowé, nèk kuwi mbok lakoni.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nanging Aku ora ngomong nèk kowé kabèh bakal slamet. Aku ngerti sapa sing tak pilih. Nang Kitab wis ketulis ngéné: ‘Wong sing mangan bareng karo Aku bakal mungsuh Aku.’ Tulisan kuwi kudu klakon. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kuwi durung klakon, nanging kowé saiki molai tak omongi. Dadiné mbésuk nèk wis klakon, kowé kabèh pada pretyaya nèk Aku iki sing dikongkon karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Elinga iki: sapa sing nampa kongkonanku ya nampa Aku. Lan sapa nampa Aku ya nampa Gusti Allah sing ngongkon Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sakwisé ngomong ngono kuwi Gusti Yésus terus sedi atiné. Dèkné ngomong: “Aku ora goroh. Enèng siji nang tengahmu sing bakal ngelungké Aku marang mungsuhé.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Murid-muridé ora patèka pretyaya terus pada ndelokké sakpada-pada, ora ngerti Gusti Yésus kuwi ngomongké sapa. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Rasul Yohanes, murid sing disenengi karo Gusti Yésus, njagong nang jèjèré. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mulané rasul Simon Pétrus terus ngongkon takon marang Gusti Yésus, sapa sing arep ngelungké Dèkné marang mungsuhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Rasul Yohanes terus lèndèn nyedeki Gusti Yésus karo takon: “Sapa ta Gusti?” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Gusti Yésus semaur: “Aku arep ngetylupké roti sak tyuwil nang mangkok. Sing tak elungi tyuwilan roti, yakuwi wongé!” Gusti Yésus terus ngetylupké roti sak tyuwil nang mangkoké terus dikèkké marang Yudas, anaké Simon Iskariot. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kadung Yudas nampani roti kuwi mau, Sétan terus ngleboni dèkné. Gusti Yésus ngomong marang Yudas: “Apa sing mbok karepké ndang dilakoni.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nanging murid-muridé ora dunung sing diomong Gusti Yésus marang Yudas. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ndarani Gusti Yésus ngongkon Yudas ndang tuku kaperluané riyaya minggu Paskah kuwi, apa ngekèki duwit marang wong sing ora nduwé, awit Yudas sing nyekel duwit. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Sakwisé Yudas nampa rotiné dèkné terus lunga. Saiki wis wayah wengi. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kadung Yudas wis lunga Gusti Yésus terus ngomong: “Saiki Anaké Manungsa bakal diluhurké lan lantaran Dèkné Gusti Allah bakal diluhurké. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nèk Gusti Allah diluhurké lantaran Anaké, Gusti Allah uga bakal ngluhurké Anaké lantaran Dèkné déwé. Lan ora suwi menèh Gusti Allah bakal ngétokké iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kantyaku sing tak trésnani, enggonku kumpul karo kowé garèk sedilut. Kowé bakal nggolèki Aku. Aku wis tau ngomong marang para penggedéné wong Ju lan saiki Aku ngomong marang kowé: panggonan sing tak parani kowé ora bisa nekani. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Saiki kowé tak kèki pepakon anyar sing kudu mbok lakoni tenan: pada trésnaa marang sakpada-pada. Kaya enggonku nrésnani kowé, kowé uga kudu nrésnani sakpada-pada. ");
INSERT INTO jvnNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nèk kowé pada trésna tenan marang sakpada-pada, wong-wong liyané bakal nitèni nèk kowé kuwi murid-muridku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Rasul Simon Pétrus takon marang Gusti Yésus: “Lah Kowé arep lunga nang endi Gusti?” Gusti Yésus semaur: “Kowé saiki durung bisa mèlu nang panggonan sing arep tak parani iki, nanging mbésuk kowé bakal nututi Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“Lah kenèng apa aku saiki kok ora bisa ngetutké Kowé Gusti? Aku kepéngin mèlu Kowé, senajan tak labuhi mati!” ");
INSERT INTO jvnNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Gusti Yésus terus semaur: “Kowé gelem tenan? Ora Pétrus, titènana ta, sakdurungé jago kluruk kowé bakal ngomong sampèk ping telu nèk kowé ora kenal karo Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Gusti Yésus terus ngomong marang murid-muridé: “Kowé aja pada sedi lan bingung, nanging pada pretyaya terus marang Gusti Allah lan marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nang omahé Gusti Allah Bapakku okèh panggonané. Semunggoné ora ngono mesti kowé ya tak omongi. Saiki Aku arep budal nggawèkké panggonan kowé. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nèk Aku wis rampung Aku bakal balik menèh marani kowé, supaya kowé bisa manggon dadi siji karo Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Panggonan sing bakal tak parani kuwi kowé wis pada ngerti dalané!” ");
INSERT INTO jvnNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Rasul Tomas terus semaur: “Gusti, panggonan sing arep mbok parani waé awaké déwé ora ngerti, lah dalané menèh awaké déwé ngertia.” ");
INSERT INTO jvnNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Gusti Yésus terus ngomong: “Aku iki dalané marang Gusti Allah lan Aku sing nduduhké Gusti Allah kuwi sapa lan Aku sing ngekèki urip marang manungsa. Ora ènèng wong bisa mara nang nggoné Gusti Allah Bapakku nèk ora liwat Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nèk kowé ngerti Aku kowé ya ngerti Gusti Allah Bapakku. Saiki kowé wis ngerti Dèkné, awit kowé wis weruh Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Rasul Filipus terus takon marang Gusti Yésus: Gusti, awaké déwé wis lega nèk mbok duduhi Gusti Allah Bapaké awaké déwé!” ");
INSERT INTO jvnNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Gusti Yésus semaur: “Filipus, Aku lak wis suwi bebarengan karo kowé ta? Lah kok kowé ora nitèni Aku? Sapa sing weruh Aku ya weruh Gusti Allah Bapakku. Lah kowé kok ijik takon kepéngin weruh Gusti Allah Bapakku? ");
INSERT INTO jvnNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kowé lak ngerti ta nèk Gusti Allah Bapakku karo Aku kuwi tunggalé. Pitutur sing tak wulangké marang kowé kuwi ora sangka karepku déwé, nanging sangka karepé Gusti Allah Bapakku. Dèkné manggon ing Aku lan Dèkné sing tumandang sangka Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngandela ta nèk Aku karo Gusti Allah Bapakku kuwi tunggalé. Penggawéku sing nggumun-nggumunké kuwi lak wis ngujutké kuwi ta! ");
INSERT INTO jvnNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iki dirungokké sing apik: sapa sing pretyaya marang Aku bisa kaya Aku nindakké penggawé sing nggumun-nggumunké. Ora namung kuwi waé, nanging malah bisa nindakké ngungkul-ungkuli kuwi, awit Aku arep budal nang nggoné Gusti Allah Bapakku. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Lan jalaran Aku nang kana, apa penjalukmu bakal keturutan, janji kowé nembung nganggo Jenengku. Mesti Aku bakal nuruti penjalukmu, dadiné Aku bisa ngluhurké Gusti Allah Bapakku. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nèk kowé njaluk apa waé nganggo Jenengku, bakal tak turuti.” ");
INSERT INTO jvnNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Gusti Yésus terus ngomong menèh: “Nèk kowé trésna tenan marang Aku kowé uga mesti nglakoni omongku. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Semono uga, Aku bakal nembung marang Gusti Allah Bapakku, supaya Dèkné ngongkon liyané sing bakal nulungi kowé slawasé. Kuwi Roh Sutyi, sing bakal mulangi kowé bab Gusti Allah kaya sak beneré. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wong sing ora pretyaya marang Gusti Allah ora bisa nampa Roh Sutyi, awit ora nitèni lan ora dunung. Nanging kowé bakal ngerti Roh Sutyi, awit Dèkné bakal karo kowé lan bakal manggon ing uripmu. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ora, kowé ora bakal tak tinggal déwé, Aku bakal balik marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ora suwi menèh wong jagat bakal ora weruh Aku menèh, nanging Aku bebarengan karo kowé terus. Lan kowé bakal urip, awit Aku urip. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ing wantyi kuwi kowé bakal dunung nèk Aku karo Gusti Allah Bapakku kuwi dadi siji. Semono uga kowé bakal dunung nèk kowé karo Aku iki uga dadi siji. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Wong sing ngerti pituturku lan nglakoni apa omongku, ya wong kaya ngono kuwi sing trésna marang Aku tenan. Wong kuwi bakal ditrésnani tenan karo Gusti Allah Bapakku lan Aku mbarang bakal nrésnani wong kuwi. Lan menèh, Aku bakal nduduhké marang Dèkné Aku iki sapa.” ");
INSERT INTO jvnNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Enèng murid sing jenengé Yudas, nanging dudu Yudas Iskariot. Yudas iki ngomong marang Gusti Yésus: “Gusti, lah Kowé kok ngétokké kwasamu namung marang awaké déwé, ora marang wong-wong liyané sing ora pretyaya marang Kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Gusti Yésus semaur: “Wong sing trésna marang Aku kuwi uga bakal nurut pituturku lan Gusti Allah Bapakku bakal nrésnani wong sing kaya ngono kuwi. Aku lan Gusti Allah Bapakku bakal urip bebarengan karo wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nanging wong sing ora trésna marang Aku uga ora bakal nurut pituturku, senajana pituturku kuwi dudu tembungku déwé, nanging tembungé Gusti Allah sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Suwéné Aku ijik tyampur karo kowé Aku mulangi kowé sembarang-mbarang kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nanging Gusti Allah Bapakku bakal ngongkon Roh Sutyi, Penulungmu, teka dadi wakilku. Dèkné sing bakal ngréwangi kowé lan ndunung-ndunungké marang kowé bab sembarang. Dèkné uga bakal ngéling-élingké marang kowé bab sembarang sing wis tak wulangké. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Saiki kowé tak tinggali katentreman. Ora katentremané donya kéné, ora, nanging katentreman sing namung Aku déwé bisa ngekèki. Mulané, kowé aja pada sedi lan aja pada wedi. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Pantyèn Aku wis ngomong nèk Aku arep lunga, nanging Aku bakal balik menèh. Mulané, nèk kowé pada trésna tenan marang Aku, kowé malah kudu bungah nèk Aku bakal lunga nang nggoné Gusti Allah Bapakku, awit Gusti Allah Bapakku kuwi gedéné ngungkuli Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Sakdurungé sembarang iki klakon kowé wis tak omongi, dadiné mbésuk nèk wis klakon tenan, kowé bisa nitèni nèk sembarang sing tak omong kuwi tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aku wis ora bisa ngomong okèh-okèh menèh marang kowé, awit Sétan, ratuné donya, wis ngétok. Aku ora ngomong nèk dèkné kuwi bisa menangké Aku, ora. ");
INSERT INTO jvnNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nanging Aku namung manut apa kongkonané Gusti Allah Bapakku. Dadiné wong kabèh bisa nitèni nèk Aku trésna tenan marang Gusti Allah Bapakku. “Wis, hayuk saiki pada lunga!” ");
INSERT INTO jvnNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Gusti Yésus terus ngomong ngéné marang murid-muridé: “Aku iki kenèng dipadakké karo wité, lah kowé pangé. Gusti Allah Bapakku kenèng dipadakké karo sing tukang kebon. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Pang sing ora ngetokké woh kuwi mesti diketok karo sing tukang kebon lan pang sing metu wohé dikeprasi lan diresiki supaya ngetokké woh sing luwih okèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kowé wis pada resik atiné. Pitutur sing tak wulangké marang kowé kuwi wis ngresiki atimu. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Rumaketa marang Aku, dadiné Aku uga bisa rumaket marang kowé. Pangé kuwi ora bisa ngetokké woh nèk ora rumaket marang wité, kaya ngono uga kowé, nèk ora rumaket marang Aku kowé ora bisa ngetokké woh. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Aku iki wité lan kowé kuwi pangé. Nèk kowé rumaket marang Aku lan Aku rumaket marang kowé, kowé bakal ngetokké woh okèh. Pedot sangka Aku kowé ora bisa apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wong sing ora rumaket marang Aku kuwi kaya pang sing diketok dadi garing, terus dilumpukké lan dibuwang nang geni bèn kobong. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nèk kowé rumaket marang Aku lan nglakoni pituturku, mbok njaluka apa waé ta, mesti bakal keturutan. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Gusti Allah Bapakku bakal diluhurké nèk kowé ngetokké woh okèh. Kuwi ngétokké nèk kowé dadi muridku tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Gusti Allah nrésnani Aku, mengkono uga katrésnanku marang kowé. Pada mantepa ing katrésnan iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kaya enggonku manut marang karepé Gusti Allah Bapakku lan ngalami katrésnané, semono uga kowé. Nèk kowé manut marang pituturku, kowé uga bakal ngalami katrésnanku sak terusé. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Aku ngomong kuwi mau kabèh marang kowé, supaya kowé bisa nduwèni kabungahanku lan supaya kabungahan iki bisa mundak terus. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Pituturku marang kowé ya iki: pada trésnaa terus marang sakpada-pada kaya enggonku trésna marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wong sing trésna lan saguh mati nglabuhi kantyané, kuwi wong sing nduwèni katrésnan tenan. Ora ènèng katrésnan sing gedéné ngungkuli kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kowé dadi kantyaku nèk kowé pada manut marang pituturku. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kowé saiki wis ora tak arani slaf menèh, awit slaf kuwi ora tau diejèki atungan karo sing nduwé omah. Nanging apa omongé Gusti Allah Bapakku marang Aku, kabèh tak dunung-dunungké marang kowé, supaya kowé uga pada ngerti. Mulané kowé kuwi ora tak arani slaf menèh, nanging kowé kantyaku. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aku sing milih kowé, dudu kowé sing milih Aku. Kowé tak pilih lan tak kongkon budal ngetokké woh terus, aja sampèk ilang wohé. Apa penjalukmu marang Gusti Allah Bapakku mesti bakal keturutan nèk kowé nembung nganggo Jenengku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sepisan menèh tembungku marang kowé: “Pada trésnaa marang sakpada-pada.” ");
INSERT INTO jvnNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Gusti Yésus terus ngomong menèh: “Wong-wong sing ora pretyaya marang Aku pada sengit marang kowé. Nanging aja pada kagèt, malah pada ngertia nèk wong-wong kuwi pantyèn sengit marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Semunggoné kowé tunggalé karo wong-wong kuwi, wong-wong mesti pada seneng karo kowé, awit kowé diaku tunggalé waé. Nanging kowé wis tak pilih lan tak singkirké sangka tengahé wong-wong kuwi, dadiné kowé wis ora tunggalé karo wong-wong kuwi, mulané kowé ya disengiti. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aku lak wis ngomong ta nèk slaf kuwi ora ngungkuli sing nduwé. Mulané, nèk wong-wong wis nyiya-nyiya Aku, wong-wong uga bakal nyiya-nyiya kowé. Semunggoné wong-wong gelem nampa pituturku, wong-wong mesti uga bakal nampa tembungmu. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nanging aja nggumun, wong-wong pada ngono karo kowé kuwi, jalaran kowé muridku. Wong-wong kuwi ora pretyaya marang Gusti Allah sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Semunggoné Aku ora teka lan mituturi wong-wong bab Gusti Allah, wong-wong kuwi pantyèn ora kenèng disalahké nèk ora gelem nampa Aku. Nanging Aku wis mituturi wong-wong kuwi, mulané pada salah tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sapa sing sengit marang Aku ya pada waé sengit marang Gusti Allah Bapakku. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Semunggoné Aku ora ngujutké tembungku nganggo tanda sing nggumun-nggumunké, sing durung tau ditindakké karo wong liyané, wong-wong kuwi blas ora kenèng disalahké. Nanging wong-wong pada weruh sembarang-mbarang kuwi karo mripaté déwé, senajan ngono meksa ijik sengit marang Aku lan sengit marang Gusti Allah Bapakku. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pantyèn, nang kitabé kono déwé wis ketulis ngéné: ‘Wong-wong pada sengit marang Aku tanpa jalaran.’ Tulisan iki pantyèn klakon. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nanging aja pada wedi, Aku arep budal nang nggoné Gusti Allah Bapakku lan Aku bakal ngongkon Roh Sutyi, Penulungmu, ndang teka nang nggonmu. Dèkné kuwi tekané sangka nggoné Gusti Allah Bapakku lan Dèkné bakal nduduhké bab Gusti Allah kaya sak beneré lan uga bab Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nanging kowé uga dadi seksiku, awit kawit Aku molai nyambutgawé kowé mèlu Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Gusti Yésus terus ngomong: “Kuwi mau kabèh tak dunung-dunungké marang kowé, supaya mbésuk nèk wis klakon tenan, kowé aja sampèk kagèt lan ilang pengandelé. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pantyèn bakal klakon tenan. Kowé ora namung bakal dietokké sangka sinaguk, nanging wong-wong bakal matèni kowé mbarang. Malah mikiré pada nggawé betyik marang Gusti Allah Bapakku nèk nglakoni ngono kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wong-wong pada nglakoni kaya ngono kuwi, jalaran ora pada ngerti tenan marang Gusti Allah lan marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nanging kowé tak omongi sakdurungé, supaya mbésuk nèk kabèh iki klakon tenan kowé pada éling marang tembungku lan ora pada kagèt. “Mauné kowé ora tak omongi bab iki, awit Aku ijik tyampur karo kowé. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nanging saiki Aku arep balik menèh nang nggoné Gusti Allah sing ngongkon Aku teka nang jagat kéné. Pantyèn Aku arep lunga, lah kok ora ènèng sing takon marang Aku kenèng apa Aku kok arep lunga. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Malah terus pada sedi ngono bab sembarang sing tak omongké kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nanging tenan, luwih apik kanggo kowé nèk Aku lunga, supaya Aku bisa ngongkon Roh Sutyi, Penulungmu, teka. Nèk Aku ora lunga, Dèkné ora bakal teka. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Malah mbésuk nèk Roh Sutyi teka, Dèkné bakal nduduhké marang manungsa nèk pikirané bab dosa, bab sing bener lan bab kruton klèru kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Roh Sutyi nduduhké apa bab dosa? Manungsa dosa, jalaran ora pretyaya marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bab sing bener, Roh Sutyi bakal nduduhké nèk Gusti Allah nganggep Aku bener. Nèk ora ngono mosok Aku arep ninggal kowé lan balik menèh nang nggoné Gusti Allah Bapakku. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bab kruton, Roh Sutyi bakal nduduhké nèk Gusti Allah wis nggawé putusan nyetrap ratuné jagat, yakuwi Sétan, slawasé. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Enèng okèh sing ijik kudu tak omong marang kowé, nanging saiki kowé durung bisa dunung kuwi kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mbésuk nèk Roh Sutyi teka, Dèkné sing bakal ndunung-ndunungké sembarang. Dèkné sing bakal mulangi bab Gusti Allah kaya sak beneré; ora nurut pikirané Dèkné déwé, ora, nanging Dèkné namung mulangké apa omongé Gusti Allah. Lan menèh, Roh Sutyi uga bakal ndunung-ndunungké bab sembarang-mbarang sing bakal klakon. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Sembarang sing diomong karo Dèkné kuwi sangka nggonku, mulané Dèkné bakal ngluhurké Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sembarang sing sangka nggoné Gusti Allah Bapakku kuwi ya sangka nggonku uga. Mulané Aku mau ngomong nèk sembarang sing diwulangké karo Roh Sutyi kuwi sangka nggonku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Gusti Yésus terus ngomong menèh: “Ora suwi menèh Aku bakal lunga lan kowé ora bakal weruh Aku menèh, nanging ora let suwi sakwisé kuwi Aku bakal teka menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Murid-muridé terus pada takon marang sakpada-pada: “Lah Gusti Yésus kuwi sakjané ngomongké bab apa ta, kok ngomong nèk ora suwi menèh bakal lunga lan ora let suwi sakwisé lunga bakal teka menèh. Lan menèh, Dèkné ngomong nèk arep nang nggoné Gusti Allah Bapaké. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kok ngomong ora let suwi menèh? Kuwi ngomongké apa ta? Awaké déwé kok ora dunung!” ");
INSERT INTO jvnNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Gusti Yésus weruh nèk murid-muridé pada kepéngin takon marang Dèkné, mulané Dèkné terus ngomong: “Kowé ora pada dunung enggonku ngomong nèk ora suwi menèh Aku bakal lunga terus ora let suwi menèh Aku bakal teka menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Saiki arep tak dunungké, mulané dirungokké sing apik. Kowé bakal pada sambat lan tangisan, nanging wong-wong sing ora pretyaya marang Gusti Allah bakal pada bungah. Kowé bakal pada sedi, nanging sedimu bakal dadi kabungahan. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kaya wong wédok sing arep mbayi kaé: suwéné mbayi ngrasakké lara, nanging nèk bayiné wis lair wongé bungah tenan, lali larané. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kaya ngono uga kowé. Saiki kowé pada sedi, jalaran Aku arep lunga. Nanging nèk Aku balik menèh kowé bakal pada bungah ora ènèng entèké. Ora ènèng wong sing bakal bisa ngrebut kabungahan iki sangka atimu. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ing wayah kuwi kowé ora usah takon Aku apa-apa menèh. Diéling tenan omongku iki: nembunga apa waé marang Gusti Allah Bapakku, Dèkné mesti bakal nuruti, jalaran sangka Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tumekané saiki kowé durung tau nembung apa-apa nganggo jenengku. Pada nembunga, Gusti Allah mesti bakal ngekèki. Kuwi kekarepané Dèkné, supaya kowé bisa bungah tenan.” ");
INSERT INTO jvnNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Gusti Yésus terus ngomong menèh: “Tekané saiki enggonku mulangi kowé namung nganggo tembung-tembung gambar, nanging ora let suwi menèh Aku ora usah mulangi ngono menèh. Sembarang bab Gusti Allah Bapakku bakal tak omongké blaka waé. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ing wayah kuwi Aku ora usah nembungké kowé, nanging kowé déwé sing bakal nembung nganggo jenengku marang Gusti Allah Bapakku. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Gusti Allah déwé trésna marang kowé, jalaran kowé pada trésna marang Aku lan pada pretyaya nèk Gusti Allah sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Pantyèn tenan, Aku iki tekané sangka nggoné Gusti Allah Bapakku medun nang jagat kéné. Saiki Aku arep ninggal jagat iki balik nang nggoné Gusti Allah Bapakku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Murid-muridé terus ngomong: “Lah mbok ngono ta Gusti! Saiki Kowé sing mulangi ora angèl. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Saiki awaké déwé ngerti nèk Kowé ngerti sembarang. Awaké déwé ora usah takon marang Kowé menèh. Mulané saiki awaké déwé pretyaya nèk Kowé kuwi tekané sangka nggoné Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Gusti Yésus ngomong: “Apa kowé pada pretyaya tenan saiki? Aku ora ngandel nèk kowé nduwé pretyaya sing mantep tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Dititèni ta! Bakal ènèng wantyiné, ora suwi menèh, kowé kabèh bakal buyar déwé-déwé parané. Aku bakal mbok tinggal déwé. Sakjané ya ora déwé, awit Gusti Allah Bapakku ngantyani Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kowé tak omongi kuwi mau kabèh supaya kowé bisa rumaket marang Aku lan nduwèni ayem. Nang jagat kéné kowé bakal kangèlan tenan, awit kowé nurut Aku, nanging dikuwatké terus, Aku wis menangké sembarang kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sakwisé ngomong kuwi mau kabèh Gusti Yésus terus nyawang nduwur lan ndonga: “Duh Bapakku, saiki wis tekan wantyiné. Mbok diluhurké Anakmu, supaya Anakmu bisa ngluhurké Kowé. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kowé wis ngekèki kwasa marang Dèkné, supaya Dèkné bisa ngwasani saben wong lan bisa ngekèki urip langgeng marang saben wong sing wis mbok pasrahké marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Urip langgeng iku yakuwi: nèk wong-wong pada ngakoni nèk Kowé déwé Gusti Allah sing nyata lan ora ènèng tunggalé lan Yésus Kristus, sing mbok kongkon nulungi manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Duh Bapakku, Aku wis ngluhurké Kowé ing jagat kéné, awit Aku wis ngrampungké penggawéan kongkonanmu marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mulané, mbok saiki Aku dijikuk menèh, supaya Aku bisa nampa kaluhuran nang ngarepmu, kaya mbiyèn sakdurungé jagat ènèng. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Wong-wong sing wis mbok pilih sangka donya lan mbok pasrahké marang Aku kuwi saiki wis pada ngerti Kowé kuwi sapa, awit Aku wis ngétokké Kowé marang wong-wong kuwi. Wong-wong iki mauné wèkmu, nanging saiki wis mbok pasrahké marang Aku. Pantyèn wong-wong iki pada nampa pituturmu. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mulané saiki pada nitèni nèk sembarang sing tak wulangké lan tak tindakké kuwi mau kabèh tekané sangka nggonmu. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pantyèn, Aku namung mulangké marang wong-wong apa omongmu marang Aku. Kuwi kabèh pada ditampa, mulané saiki kabèh pada dunung tenan nèk Aku tekané sangka nggonmu lan pada pretyaya nèk kowé sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Aku saiki ora ndongakké wong-wong sing ora pretyaya, ora, Aku ndongakké murid-murid iki, sing wis mbok pasrahké marang Aku. Murid-murid iki pada waé wèkmu. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Apa sing wèkku kuwi ya wèkmu lan apa sing wèkmu ya pada waé wèkku. Pantyèn, murid-murid iki ngétokké sepira gedéné katrésnanku lan kwasaku. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Aku saiki arep lunga sangka jagat iki, Aku arep balik nang nggonmu menèh, nanging murid-murid iki tak tinggal nang kéné. Duh Bapakku sing sutyi, Aku nyuwun, murid-murid iki sing wis mbok pasrahké marang Aku, mbok dipageri karo kwasané jenengmu. Aku nyuwun supaya pada bisa bebarengan dadi siji ing sembarang, kaya Awaké Déwé iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Suwéné Aku nang jagat kéné Aku déwé sing nuntun nganggo kwasané jenengmu lan ora ènèng sing mbalik dalan karusakan, kejaba mung siji. Pantyèn sing siji kuwi wis nduwé karep ala, supaya apa sing wis ketulis nang Kitab klakon tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nanging Aku saiki arep balik nang nggonmu. Mulané, pumpung Aku ijik nang jagat kéné Aku ngomong sembarang iki, supaya murid-murid iki bisa nduwèni kabungahan tenan, kabungahan sing namung Aku déwé bisa ngekèki. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Pada tak wulangi pituturmu lan saiki uripé pada waé kaya Aku, malih séjé karo wong sing ora pretyaya marang Kowé. Mulané ya pada disengiti tenan karo wong sing ora pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Duh Bapakku, Aku ora nyuwun supaya murid-murid iki mbok jikuk sangka jagat kéné, nanging Aku nyuwun supaya mbok pageri sangka kwasané Sétan. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Murid-murid iki uripé wis ora tunggalé karo wong-wong sing ora pretyaya marang kowé, awit Aku ya ora tunggalé uga. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mulané Aku nyuwun, supaya pada nurut pituturmu, dadiné bisa temen nurut Kowé. Pituturmu sing ngétokké Kowé sak nyatané. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kaya enggonmu ngongkon Aku teka nang jagat kéné ngabarké pituturmu marang manungsa, Aku semono uga ngongkon murid-murid iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Aku masrahké uripku marang Kowé kanggo nglabuhi murid-muridku iki, supaya kabèh uga pada masrahké uripé marang Kowé ing lair lan batin. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Duh Bapakku, Aku ora namung ndongakké murid-murid iki waé, nanging Aku uga ndongakké wong sing nampa pituturé murid-murid iki terus pada pretyaya marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aku nyuwun bisaa kabèh pada rukun bebarengan lan bisaa rumaket marang Awaké Déwé, kaya enggonku rumaket marang Kowé lan Kowé marang Aku. Dadiné wong sing ora pretyaya bisa nitèni nèk Kowé sing ngongkon Aku teka nang jagat kéné. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kaya enggonmu ngétokké ing uripku Kowé kuwi kaya ngapa, Aku uga ngétokké ing uripé sing pada pretyaya, Aku iki kaya ngapa. Nèk kabèh bisa kaya Aku, kabèh uga bakal bisa rukun dadi siji kaya enggoné Kowé karo Aku iki dadi siji. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Dadiné Kowé urip ing Aku lan Aku urip ing atiné wong-wong kuwi lan kabèh bisa dadi siji, kaya sing mbok karepké. Nèk bisa ngono jagat bakal pretyaya nèk Kowé sing ngongkon Aku lan uga bisa pretyaya nèk Kowé trésna tenan marang manungsa, kaya enggonmu trésna marang Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Duh Bapakku, murid-murid iki mbok pasrahké marang Aku. Karepku murid-murid iki bisa nang nggonku, supaya bisa weruh kamulyanku. Ya Kowé sing ngekèki kamulyan iki marang Aku, awit Kowé trésna marang Aku kawit jagat iki durung ènèng. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Duh Bapakku sing bener slawasé, senajan wong jagat kéné ora ngerti Kowé, Aku ngerti Kowé lan murid-muridku iki saiki wis ngerti nèk Kowé sing ngongkon Aku. ");
INSERT INTO jvnNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aku wis nduduhké marang murid-muridku Kowé kuwi sapa lan bakal tak duduhké terus. Karepku, supaya pada nduwèni katrésnan kaya enggonmu nrésnani Aku lan supaya Aku bisa dadi siji karo murid-muridku kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Sakwisé Gusti Yésus ndonga kuwi Dèkné terus ngabrah kriki Kidron karo murid-muridé. Kadung wis ngabrah terus pada mlebu nang kebon olèf. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Gusti Yésus ajek mbréné karo murid-muridé, mulané Yudas mbarang ya ngerti panggonan iki. Ya Yudas iki sing ora let suwi ngelungké Gusti Yésus marang mungsuhé. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudas mbarang mbrono nggawa soldat-soldat lan sekaut-sekaut sing njaga Gréja Gedé. Soldat-soldat lan sekaut-sekaut iki kongkonané para pengarepé imam lan para Farisi lan pada teka nggawa obor lan sentir lan uga gaman-gaman. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Gusti Yésus wis ngerti bakal ènèng apa, mulané Dèkné terus metu mapak wong-wong. Dèkné takon: “Kowé kuwi pada nggolèki sapa?” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wong-wong semaur: “Awaké déwé nggolèki Yésus, wong sangka Nasarèt!” Gusti Yésus terus ngomong: “Yésus kuwi ya Aku iki!” Yudas mbarang ya nang kono karo soldat-soldat lan sekaut-sekaut sing pada teka mau. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Wong-wong krungu Gusti Yésus ngomong ngono terus pada mundur sampèk nggeblak. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Gusti Yésus takon sepisan menèh: “Sapa ta sing mbok golèki kuwi?” Terus pada semaur: “Yésus, wong sangka Nasarèt!” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Aku lak wis ngomong ta nèk Yésus kuwi ya Aku iki. Nèk namung nggolèki Aku, kantya-kantyaku iki ya diejarké waé.” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ya pantyèn bener, awit Gusti Yésus wis tau ngomong ngéné marang Gusti Allah Bapaké: “Sing wis mbok pasrahké marang Aku ora ènèng siji-sijia sing tak ilangké!” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Rasul Simon Pétrus, sing nggawa pedang, narik pedangé dienggo nyabet kupingé slafé Imam Gedé sampèk tyepol. Slaf iki jenengé Malkus. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nanging Gusti Yésus malah nyenèni rasul Pétrus: “Pedangmu kuwi dilebokké menèh! Mosok Aku ora gelem nglakoni kasangsaran sing wis dikarepké karo Gusti Allah Bapakku?” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Soldat-soldat lan kumendané lan sekaut-sekauté Gréja Gedé terus pada nyekel Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tangané ditalèni terus digawa nang nggoné Anas. Anas iki bapak maratuwané Kayafas, sing dadi Imam Gedé ing wayah kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ya Kayafas iki sing ngomong marang para penggedéné wong Ju nèk luwih apik wong siji mati tenimbang sak bangsa kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Rasul Simon Pétrus lan murid liyané, yakuwi rasul Yohanes, pada ngetutké Gusti Yésus. Rasul Yohanes kuwi kenal karo Imamé Gedé, mulané dèkné terus mèlu mlebu nang omahé Imamé Gedé. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nanging rasul Pétrus ngentèni nang njabané lawang. Murid liyané sing kenal karo Imamé Gedé terus metu lan ngomong marang wong wédoké sing tukang mbukak lawang. Rasul Pétrus mbarang terus diejèk mlebu. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wong wédok sing jaga lawang terus ngomong marang rasul Pétrus: “Apa kowé dudu tunggalé muridé wongé?” Rasul Pétrus semaur: “Ora!” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iki dongé wayah adem, mulané slaf-slaf lan sekaut-sekauté Gréja Gedé sing nang kono pada nggawé bediyang karo areng supaya anget. Wong-wong pada ngadek ngubengi bediyangé. Rasul Pétrus mbarang mèlu ngadek nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Saiki Gusti Yésus ditakoni karo Imamé Gedé bab murid-muridé lan piwulangé. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Gusti Yésus semaur: “Aku nèk mulangi nang ngarepé wong okèh, nang sinaguk apa nang Gréja Gedé, nang panggonan sing dienggo ngumpul wong Ju. Aku ora tau ndelik-ndelik. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nèk kepéngin ngerti apa sing tak wulangké ya takon marang wong-wong sing pada ngrungokké. Wong-wong kuwi mesti ngerti apa sing tak wulangké.” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sakwisé Gusti Yésus ngomong ngono terus sekauté Gréja Gedé sing ngadek nang kono napuk Dèkné karo ngomong: “Karo Imam Gedé aja wani ngomong ngono ya!” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Gusti Yésus semaur: “Nèk omongku kuwi mau ora bener, apa klèruné? Lah nèk omongku bener, Aku kok mbok tapuk?” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anas terus mréntah kongkon nggawa Gusti Yésus nang nggoné Kayafas, Imamé Gedé. Tangané Gusti Yésus ijik dibanda. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saiki rasul Pétrus ijik ngadek nang bediyangan kono. Wong-wong sing nang kono takon marang dèkné: “Kowé lak muridé wong kuwi ta?” Rasul Pétrus semaur: “Ora ah!” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Terus ènèng slafé Imam Gedé, seduluré slaf sing dibatyok kupingé karo rasul Pétrus, ngomong: “Kaya-kaya aku weruh kowé mbarang karo Dèkné nang kebon olèf!” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Rasul Pétrus terus semaur menèh: “Ora ah!” Sakwat terus ènèng jago kluruk. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Sakwisé kuwi Gusti Yésus terus digawa lunga sangka omahé Kayafas. Saiki digawa nang omahé gramangé. Kuwi ijik ésuk banget. Wong-wong Ju malah ora pada mlebu nang omahé gramangé, awit gramangé kuwi dudu wong Ju. Lan miturut agamané wong Ju ora éntuk mlebu omahé sing dudu bangsané, mengko ndak reget awaké. Nèk ora resik ora éntuk mèlu mangan pangan Paskah. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Mulané gramang Pilatus terus nglumui metu lan takon marang wong-wong: “Apa salahé wong iki?” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wong-wong semaur: “Nèk ora wong nakal mosok digawa mbréné karo awaké déwé!” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus terus ngomong: “Kana dikrutu kowé déwé miturut wèté agamamu déwé!” Wong-wong semaur: “Nanging awaké déwé ora dililani ngongkon matèni wong!” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Pantyèn kudu klakon sing wis diomong karo Gusti Yésus bab kepriyé Dèkné enggoné bakal mati. ");
INSERT INTO jvnNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Gramang Pilatus terus mlebu menèh nang omahé. Gusti Yésus terus dityeluk lan ditakoni: “Apa Kowé kuwi ratuné bangsa Ju tenan?” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Gusti Yésus semaur: “Kuwi pitakonanmu déwé apa wong liyané sing ngongkon kowé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus terus ngomong: “Anggitanmu kuwi aku wong Ju? Bangsamu déwé lan pengarep-pengarepé imam sing nggawa kowé mbréné nang nggonku! Salahmu apa kok kowé dityekel!” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Gusti Yésus semaur: “Dudu wong jagat kéné sing ndadèkké Aku dadi ratu. Semunggoné wong jagat kéné sing ndadèkké Aku dadi ratu, balaku mesti pada nglawan mbélani Aku supaya Aku ora dityekel karo wong Ju. Nanging yakuwi, dudu wong jagat kéné sing ndadèkké Aku dadi ratu.” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatus terus ngomong marang Gusti Yésus: “Nèk ngono Kowé ratu tenan?” Gusti Yésus semaur: “Pantyèn, bener sing mbok omong kuwi. Aku lair lan Aku teka nang jagat kéné kanggo nduduhké bab sing bener. Sapa sing seneng marang pitutur sing bener mesti nggugu tembungku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus terus semaur: “Pitutur sing bener? Ah, kuwi apa!” Sakwisé ngomong kuwi Pilatus terus mara menèh nang nggoné wong-wong Ju sing nang njaba. Dèkné terus ngomong: “Aku ora nemu salah ing wong iki! ");
INSERT INTO jvnNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nanging wis lumrahé aku ngetokké wong setrapan siji nèk wayah Paskah. Lah karepmu kepriyé? Apa kowé njaluk ratuné bangsa Ju sing tak etokké?” ");
INSERT INTO jvnNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wong-wong terus pada mbengok: “Ora, ora Dèkné! Awaké déwé njaluk Barabas!” Barabas kuwi wong nakal. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Gramang Pilatus mréntah ngongkon metyuti Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldat-soldat sing nang kono terus pada ngubet-ubetké pangé eri digawé kaya makuta terus dipasang nang sirahé Gusti Yésus, terus dienggoni salin abang mbarang, supaya kétok kaya ratu. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Soldat-soldat mau terus étok-étoké mbagèkké ngomong: “Slameta ratuné bangsa Ju!” Sakwisé ngono Gusti Yésus terus dikeplaki. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus terus metu sepisan menèh nang ngarepé wong-wong Ju mau! Dèkné ngomong: “Lah iki wongé tak gawa nang nggonmu menèh. Sak ngertiku wong iki ora nduwé salah apa-apa!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Gusti Yésus terus digawa metu, ijik nganggo makuta eri lan salin abang mau. Pilatus terus ngomong menèh marang wong-wong: “Ya iki wongé!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kadung para pengarepé imam lan sekaut-sekauté Gréja Gedé weruh Gusti Yésus, sakwat terus pada mbengok: “Dipentèng! Dipentèng!” Pilatus terus semaur: “Ya kono nèk arep mbok pentèng. Kanggo aku wong iki ora salah apa-apa!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wong-wong terus pada semaur: “Miturut wèté agamané awaké déwé wong kuwi kudu dipatèni, awit Dèkné ngomong nèk Dèkné kuwi Anaké Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatus krungu wong-wong ngomong ngono kuwi mau terus tambah wedi. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dèkné terus mlebu menèh lan takon marang Gusti Yésus: “Kowé kuwi sakjané sapa ta?” Nanging Gusti Yésus ora semaur apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mulané Pilatus terus ngomong: “Kowé mesti ngerti ta sapa sing nakoni Kowé iki? Lah kok ora gelem semaur? Apa kowé ora ngerti nèk Aku nduwèni kwasa ngongkon ngutyuli lan ngongkon mentèng Kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Gusti Yésus terus semaur: “Nèk Gusti Allah ora ngekèki kwasa kowé, kowé blas ora bisa ngapa-apakké Aku. Mulané, sing salah gedé déwé kuwi ya wong sing ngelungké Aku marang kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus krungu Gusti Yésus ngomong ngono kuwi terus nggolèk akal supaya Gusti Yésus ora usah disetrap menèh, nanging wong-wong pada mbengok: “Nèk wong kuwi ora mbok setrap, kowé ya dudu kantyané ratuné, awit sapa sing ngaku nèk dèkné kuwi ratu ya nglawan ratuné.” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kadung Pilatus krungu wong-wong ngomong ngono dèkné terus nggawa Gusti Yésus metu, terus njagong nang krosi sing dienggo ngrutu. Krosi iki ngadek nang jogan watu, nèk tyara Ibrani jenengé Gabata. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iki tiba dinané wong Ju pada tyetyawisan kanggo dina sabat minggu Paskah kuwi, kira-kira jam rolas awan. Pilatus terus ngomong marang wong-wong: “Lah iki ratumu!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wong-wong malah terus pada bengok-bengok: “Digawa lunga, digawa lunga wong kuwi, kana dipentèng!” Pilatus terus ngomong: “Mosok aku mbok kongkon mentèng ratumu?” Para pengarepé imam terus semaur: “Namung Sésar ratuné awaké déwé, awaké déwé ora nduwé ratu liyané.” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gusti Yésus terus dipasrahké marang para penggedéné wong Ju supaya dipentèng. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Para soldat terus nggawa Gusti Yésus metu sangka kutané kono digawa nang panggonan sing jenengé “Endasé Wong Mati,” nèk tyara Ibrani jenengé Golgota. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Gusti Yésus déwé sing manggul kayuné sing arep dienggo mentèng Dèkné. Gusti Yésus terus dipentèng bareng karo wong loro liyané, sing siji nang tengené lan liyané nang sebelah kiwa, dadiné Gusti Yésus nang tengah-tengah. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nang kayuné pentèngan terus dikongkon ngekèki tulisan ngéné karo Pilatus: “Yésus sangka Nasarèt, ratuné wong Ju!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Panggonan sing dienggo mentèng kuwi ora adoh karo kutané kono, mulané wong Ju okèh pada weruh lan matya tulisan kuwi. Karomenèh kuwi ketulis ing tembung Ibrani, Latin lan Grik. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Para pengarepé imamé bangsa Ju terus pada nembung marang Pilatus ngganti tulisan kuwi. Dadiné tulisané ora: “Ratuné wong Ju,” nanging: “Wong iki ngomong nèk Dèkné ratuné wong Ju!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nanging Pilatus semaur: “Apa sing wis tak tulis wis bèn ngono!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sakwisé soldat-soldat pada mentèng Gusti Yésus, saliné Dèkné terus diutyuli kabèh lan diedum dadi papat, dadiné kabèh papat éntuk bagèan. Namung garèk saliné njero, sing ora ènèng dondomané. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mulané soldat-soldat mau terus ngomong: “Aja disuwèk ah, hayuk dilotré waé, sing menang sing éntuk!” Iki tyotyok karo sing wis ketulis nang Kitab, uniné ngéné: “Sandanganku diedum-edumké lan salinku dilotré!” Apa sing diomong ya terus dilakoni tenan karo para soldat. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ibuné lan bibiké Gusti Yésus, uga Maria Klopas lan Maria Makdaléna pada ngadek nang ngarepé kayu pentèngan kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Gusti Yésus weruh ibuné karo rasul Yohanes. Rasul Yohanes kuwi murid sing disenengi tenan karo Gusti Yésus. Gusti Yésus terus ngomong marang ibuné: “Bu, kuwi anakmu!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sakwisé ngono terus ngomong marang murid sing disenengi kuwi ngéné: “Kuwi ibumu!” Mulané sakploké kuwi ibuné Gusti Yésus terus dirumati karo rasul Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Gusti Yésus ngerti nèk saiki sembarang wis klakon, mulané, supaya apa sing wis ketulis nang Kitab uga bisa klakon, Dèkné ngomong: “Aku ngelak!” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nang kono ènèng kendi isiné anggur ketyut. Terus ènèng soldat ngetylupké spons nang angguré kuwi terus dipasang nang putyuké kayu hisop, terus didèkèkké nang lambéné Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Sakwisé Gusti Yésus nyesep angguré, Dèkné terus ngomong: “Wis rampung!” Dèkné terus ndingkluk terus ninggal. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lah kuwi tiba dina jemuah, dina wayahé wong Ju pada tyetyawisan kanggo dina sabat. Wong-wong ora gelem nèk ing dina sabat kuwi layoné Gusti Yésus ijik nang kayu pentèngan, awit iki dina sabat sing gedé. Mulané para penggedéné wong Ju pada nembung marang Pilatus, supaya wong-wong sing dipentèng pada diremuki sikilé lan diedunké sangka kayu pentèngan kono. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Para soldat terus nang nggoné sing liyané ndisik sing dipentèng bareng karo Gusti Yésus. Kabèh loro sikilé terus diremuk. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nanging kadung para soldat mau nang nggoné Gusti Yésus pada weruh nèk Dèkné wis mati. Mulané sikilé Dèkné ora sida diremuk. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nanging terus ènèng soldat njojoh bangkèkané Gusti Yésus karo tumbak, terus sakwat metu getihé lan banyuné. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Aku, Yohanes, weruh sembarang iki lan aku dadi seksi, aku ora goroh. Aku ngerti tenan lan sing tak omong iki apa wujuté. Aku ngomong iki supaya kowé pretyaya marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ngertia nèk sembarang iki klakon, awit nang Kitab wis ketulis ngéné: “Balungé Dèkné blas ora ènèng sing bakal diremuk.” Dadiné tulisan iki wis klakon. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Lan ènèng tulisan liyané menèh nang Kitab sing uniné ngéné: “Wong-wong bakal nyawang marang wong sing wis dijojoh.” ");
INSERT INTO jvnNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Sakwisé kuwi mau kabèh terus Yosèf, murid sing sangka kuta Arimatéa, nembung marang Pilatus, apa éntuk njikuk layoné Gusti Yésus. Yosèf iki muridé Gusti Yésus, nanging mauné ndelik-ndelik, awit wedi karo para penggedéné wong Ju. Pilatus ya nglilani penjaluké Yosèf, mulané layoné Gusti Yésus ya terus arep dijikuk karo Yosèf. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodémes mbarang mèlu teka karo nggawa wangi-wangi tyampurané mur lan alué. Okèhé kira-kira ènèng telung puluh kilo. Ya Nikodémes iki sing teka nang nggoné Gusti Yésus ing wayah wengi, dongé teka sepisanan. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yosèf lan Nikodémes terus njikuk layoné sangka kayu pentèngan kono, terus dibuntel mori bareng karo wangi-wanginé mbarang. Kuwi pantyèn wis dadi lumrahé wong Ju nèk arep ngubur wong mati. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tyedek karo panggonan sing dienggo mentèng Gusti Yésus kono ènèng kebon. Nang kebon kuwi ènèng kuburané anyar sing durung tau dienggo ngubur wong. ");
INSERT INTO jvnNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Layoné Gusti Yésus terus dikubur nang kono, awit kuburan kuwi tyedek, katik wis lat pisan, dina sabat wis arep molai. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ing dina mingguné, ésuk-ésuk ijik peteng, Maria Makdaléna teka nang kuburan. Nang kono dèkné weruh nèk watuné sing dienggo nutupi kuburané wis ora ènèng. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Maria terus sakwat lunga nggolèki rasul Simon Pétrus lan murid liyané sing disenengi karo Gusti Yésus. Dèkné terus ngomong marang murid loro kuwi: “Layoné Gusti Yésus dijikuk karo wong-wong, nanging awaké déwé ora ngerti embuh didèkèk nang endi.” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Rasul Pétrus lan murid liyané mau terus gelis-gelis budal nang kuburan. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kabèh loro mblayu, nanging rasul Yohanes mblayuné luwih banter, mulané dèkné sing teka ndisik nang kuburané. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Rasul Yohanes nginguk njeruh terus weruh moriné nang kono, nanging dèkné ora mlebu. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ora let suwi rasul Pétrus teka terus mlebu. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Rasul Pétrus weruh moriné lan uga gombal mori sing dienggo mbuntel sirahé. Nanging gombal iki ora tyampur karo mori liyané, malah wis dilempit. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Rasul Yohanes, sing teka ndisik nang kuburané, terus mèlu mlebu mbarang. Dèkné weruh kuwi mau kabèh terus pretyaya nèk Gusti Yésus wis tangi menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Awit, senajan wis ketulis nang Kitab nèk Gusti Yésus bakal mati terus urip menèh, murid-muridé mauné durung pada dunung tulisan kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Rasul Pétrus lan Yohanes terus pada mulih menèh. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria, sing uga mèlu rono menèh, saiki nang kono déwé nang njabané kuburané. Dèkné terus nginguk njeruh karo nangis. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Maria terus weruh mulékat loro nganggo salin putih njagong nang panggonan sing mauné dienggo ngglétakké layoné Gusti Yésus. Sing siji njagong nang sebelah sikil lan liyané sebelah sirah. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mulékaté mau terus pada takon marang Maria: “Yu, kenèng apa kowé kok nangis?” Maria semaur: “Gustiku digawa lunga karo wong-wong, nanging aku ora ngerti Dèkné embuh didèkèk nang endi!” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sakwisé semaur ngono dèkné terus minger lan weruh Gusti Yésus, nanging Maria ora nitèni nèk kuwi Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Gusti Yésus terus ngomong: “Yu, kenèng apa kowé kok nangis? Kowé kuwi nggolèki sapa?” Ndarani Maria sing takon kuwi wong sing tukang resik-resik kebon kono, mulané dèkné semaur: “Kang, nèk kowé sing nggawa lunga layoné, mbok aku diduduhi nggoné ta, arep tak jikuk!” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Gusti Yésus terus ngomong: “Maria!” Maria terus sakwat minger lan semaur: “Rabuni!” (Rabuni iku tembung Ibrani tegesé: “Guruku.”) ");
INSERT INTO jvnNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Gusti Yésus terus ngomong: “Aku aja didemèk ndisik, awit Aku durung budal nang nggoné Gusti Allah Bapakku. Kana saiki sedulur-sedulurku diomongi nèk Aku budal nang nggoné Gusti Allah Bapakku sing uga Bapakmu, Gusti Allahku lan uga Gusti Allahmu.” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria terus nang nggoné murid-muridé ngomong: “Aku weruh Gusti!” Apa sing diomong karo Gusti Yésus terus diomongké marang murid-muridé. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mbenginé kuwi murid-muridé Gusti Yésus pada ngumpul. Lawang-lawangé dikantyingi kabèh, awit pada wedi karo para penggedéné wong Ju. Gusti Yésus terus dadakan teka ngadek nang ngarepé murid-muridé terus ngomong: “Pada slameta!” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Sakwisé ngomong kuwi Gusti Yésus terus nduduhké tangané lan bangkèkané. Murid-muridé pada bungah tenan weruh Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Gusti Yésus terus ngomong sepisan menèh: “Pada slameta! Kaya enggoné Gusti Allah Bapakku ngongkon Aku, semono uga Aku ngongkon kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","23","Sakwisé ngomong ngono kuwi Gusti Yésus terus ndamu murid-muridé karo ngomong: “Nampaa Roh Sutyi! Sapa sing mbok ngapura salahé ya nampa pangapura, sing ora mbok ngapura ya uga ora nampa pangapura.” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Rasul Tomas, muridé Gusti Yésus sing diarani Anak Kembar, ora nang kono dongé Gusti Yésus teka nang tengahé murid-muridé mau. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nanging kadung dèkné diomongi karo murid-murid liyané nèk pada weruh Gusti Yésus, dèkné ora ngandel. Malah ngomong: “Aku ngandel nèk aku weruh tipaké bolongané pakuné nang tangané lan aku bisa nglebokké drijiku nang bolongané kuwi lan aku bisa ndemèk bangkèkané sing dijojoh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Let seminggu murid-muridé Gusti Yésus pada ngumpul menèh. Saiki rasul Tomas mbarang ènèng. Lawang-lawangé dikantyingi kabèh, nanging Gusti Yésus teka menèh, ngerti-ngerti wis ngadek nang tengahé terus mbagèkké: “Pada slameta kabèh!” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Gusti Yésus terus ngomong marang rasul Tomas: “Tomas, delokké tanganku iki, réné demèken. Bangkèkanku mbarang iki didemèk jajal! Mbok aja kaya wong sing ora pretyaya, nanging ngandela!” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Rasul Tomas terus semaur: “Duh Gusti, pantyèn Kowé Gusti Allahku.” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Gusti Yésus terus ngomong: “Kowé saiki pretyaya, awit kowé wis weruh Aku. Nanging beja tenan wong sing pretyaya tanpa weruh Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ijik ènèng prekara liyané pirang-pirang menèh sing nggumunké, sing ditindakké karo Gusti Yésus nang ngarepé murid-muridé, sing ora ketulis nang buku iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nanging sing ketulis iki nduduhké nèk Gusti Yésus kuwi Kristus Anaké Gusti Allah. Nèk kowé pretyaya marang Dèkné, kowé nduwèni urip langgeng. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ora let suwi Gusti Yésus ngétok marang murid-muridé sepisan menèh. Saiki nang mér Tibérias. Kuwi ngéné. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Murid-muridé dongé pada ngumpul, yakuwi Simon Pétrus, Tomas Kembar, Natanaèl sing sangka kuta Kana nang bawah Galiléa, anaké Sébédéus loro lan murid loro liyané. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Lah rasul Simon Pétrus terus ngomong karo liya-liyané: “Aku arep nggolèk iwak!” Liya-liyané semaur: “Awaké déwé arep mèlu!” Kabèh terus budal karo prauné, nanging mbengi kuwi ora éntuk apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Esuké Gusti Yésus teka nang pinggir mér kono, nanging murid-muridé ora nitèni nèk kuwi Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Gusti Yésus terus takon: “Ora éntuk apa-apa?” Murid-muridé semaur: “Ora!” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Gusti Yésus terus ngomong: “Jalané diuntyalké nang tengené prauné ta, mengko lak éntuk!” Murid-muridé terus nguntyalké jalané, nanging sangking okèhé iwaké ora kuwat narik. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Rasul Yohanes terus ngomong marang rasul Pétrus: “Kuwi Gusti!” Kadung rasul Pétrus krungu nèk kuwi Gusti Yésus, dèkné sakwat nganggo saliné terus njegur, awit mauné namung nganggo salin njero. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Murid-murid liyané terus nggawa prauné nang daratan karo narik jalané sing kebek iwak. Daratané ora adoh, kira-kira satus mèter. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kadung wis tekan daratan terus pada weruh geni areng lan iwak dipanggang nang nduwuré. Enèng rotiné mbarang. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Gusti Yésus terus ngomong: “Kana njikuk iwak setitik éntukmu njala kuwi!” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Rasul Pétrus terus narik jalané nang daratan. Jalané kebek karo iwak gedé-gedé, ènèng satus sèket telu, nanging senajana iwaké okèhé semono, jalané ora bedah. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Gusti Yésus terus nyeluk murid-muridé: “Réné pada sarapan!” Ora ènèng sing wani takon kuwi Gusti Yésus apa dudu, awit wis pada ngerti nèk kuwi Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Gusti Yésus terus njikuk rotiné dikèkké murid-muridé, iwaké mbarang. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sakwisé Gusti Yésus tangi sangka pati Dèkné wis ngétok marang murid-muridé ping telu iki. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Gusti Yésus terus takon marang rasul Pétrus: “Simon, anaké Yohanes, apa kowé trésna tenan marang Aku, ngungkuli liya-liyané?” Rasul Pétrus semaur: “Kowé wis ngerti déwé Gusti, Aku trésna marang Kowé!” Gusti Yésus terus ngomong: “Tyempé-tyempéku pada diengon!” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Gusti Yésus takon sepisan menèh: “Simon, anaké Yohanes, apa kowé trésna tenan marang Aku?” Rasul Pétrus semaur: “Ya Gusti, Kowé wis ngerti déwé ta!” Gusti Yésus terus ngomong: “Wedus-wedusku pada diengon!” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Saiki Gusti Yésus takon ping teluné: “Simon, anaké Yohanes, apa kowé trésna tenan marang Aku?” Rasul Pétrus terus sedi banget krungu Gusti Yésus takon kaya ngono kuwi sampèk ping telu. Dèkné semaur: “Gusti, Kowé ngerti sembarang. Kowé ngerti nèk Aku trésna marang Kowé!” Gusti Yésus terus ngomong: “Wedus-wedusku pada diengon!” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Gusti Yésus saiki ngomong: “Mbiyèn dongé kowé ijik enom, kowé sabukan déwé lan kowé rana-réné sak karepmu déwé. Nanging mbésuk nèk kowé wis tuwa, kowé bakal ngunggahké tanganmu lan wong liyané bakal nyabuki kowé lan nggawa kowé nang panggonan sing kowé ora seneng.” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Gusti Yésus ngomong ngono kuwi kanggo mlambangi rasul Pétrus kepriyé dèkné enggoné bakal mati kanggo ngluhurké Gusti Allah. Sakwisé kuwi Gusti Yésus terus ngomong: “Hayuk mèlu Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kadung rasul Pétrus nolèh mburi dèkné weruh nèk rasul Yohanes mbarang mèlu. Ya rasul Yohanes iki sing njagong jèjèré Gusti Yésus dongé pada mangan bareng lan dèkné sing takon: “Sapa sing arep ngelungké Kowé marang mungsuhé, Gusti?” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Rasul Pétrus weruh rasul Yohanes kuwi terus takon marang Gusti Yésus: “Gusti, lah Yohanes kepriyé?” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Gusti Yésus semaur: “Semunggoné Aku karep nèk dèkné urip terus tekané mbésuk nèk Aku teka menèh, lah kuwi lak dudu prekaramu ta! Nanging kowé kudu mèlu Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nang tengahé wong-wong sing pada pretyaya marang Gusti Yésus terus ènèng omongan mrèmèn-mrèmèn, jaréné rasul Yohanes ora bakal mati. Nanging Gusti Yésus ora ngomong nèk rasul Yohanes ora bakal mati, Dèkné ngomong: “Semunggoné Aku karep nèk Dèkné urip terus tekané mbésuk nèk Aku teka menèh, lah kuwi lak dudu prekaramu ta?” ");
INSERT INTO jvnNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ya aku iki, Yohanes, sing nyeksèni lan nulis sembarang iki. Awaké déwé ngerti nèk sembarang sing tak omong kuwi wujut tenan. ");
INSERT INTO jvnNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nanging Gusti Yésus ijik nindakké barang liya-liyané okèh banget. Semunggoné kabèh ditulis siji-siji, aku mikir jagat iki ora kamot kanggo madahi buku-bukuné sing ditulis.");
INSERT INTO jvnNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Sedulurku Téofilus, iki layangku sing nomer loro. Nang layang sing ndisik aku wis nulis okèh bab penggawéané lan piwulangé Gusti Yésus, wiwit Dèkné molai nyambutgawé tekané Dèkné munggah menèh nang swarga. Sakdurungé munggah menèh nganggo kwasané Roh Sutyi, Gusti Yésus ngomongi lan ndunung-ndunungké ndisik marang rasul-rasulé sing wis dipilih, bab sembarang-mbarang sing kudu dilakoni. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sakwisé tangi menèh sangka pati, Gusti Yésus ngétok ping okèh marang para rasul, patang puluh dina suwéné. Kuwi kanggo tanda sing nyata tenan nèk Dèkné urip. Gusti Yésus uga mulangi marang para rasul bab Kratoné Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dongé Gusti Yésus ijik tyampur karo para rasul, Dèkné menging wong-wong kuwi ora éntuk lunga nang endi-endi ndisik. Gusti Yésus ngomong ngéné marang murid-muridé: “Kowé aja pada lunga sangka kuta Yérusalèm ndisik, nanging pada entènana enggoné Gusti Allah Bapakku nuruti prejanjiané ndisik, kaya sing wis tak omongké marang kowé kaé. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Pantyèn Yohanes mbaptis kowé, nanging namung karo banyu. Ora suwi menèh kowé bakal kebaptis karo Roh Sutyi.” ");
INSERT INTO jvnNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ing sakwijiné dina, dongé ngumpul karo Gusti Yésus, para rasul terus pada takon ngéné: “Gusti, apa Kowé bakal dadi ratuné bangsa Israèl, supaya bangsa Israèl bisa ngwasani bangsa liya-liyané menèh kaya mbiyèn!” ");
INSERT INTO jvnNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Gusti Yésus semaur: “Gusti Allah Bapakku ora nglilani kowé ngerti bab iku. Dèkné déwé sing ngarani kapan kuwi klakon. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nanging kowé bakal nampa kekuwatan nèk Roh Sutyi medun lan ngwasani kowé. Lan nèk kuwi wis klakon, kowé bakal dadi seksiku nang kuta Yérusalèm, nang bawah Yudéa kabèh lan nang bawah Samaria lan nang sak lumahé bumi.” ");
INSERT INTO jvnNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sakwisé ngomong ngono kuwi Gusti Yésus terus munggah nang swarga. Para rasul pada weruh munggahé nganti ora kétok, awit terus ketutupan méga. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dongé para rasul ijik pada nyawang nduwur terus dadakan ènèng wong loro nganggo salin putih ngadek nang jèjèré. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Wong loro mau terus ngomong: “Hé wong Galiléa, lah kowé kok pada ngadek lan pada ndelokké nang langit ngono? Kaya enggonmu pada weruh Gusti Yésus munggah nang swarga, ya ngono kuwi Dèkné bakal balik menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sangka gunung Olèf kono para rasul terus balik nang kuta Yérusalèm. Kuwi kira-kira ènèng sak kilomèter. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tekan Yérusalèm terus pada munggah nang kamar nduwur nang omah sing dienggoni kono. Para rasulé Gusti Yésus kabèh yakuwi: Pétrus, Yohanes, Yakobus, Andréas, Filipus, Tomas, Bartoloméus, Matéus, Yakobus anaké Alféus, Simon wong Patriot lan Yudas anaké Yakobus. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Para rasul mau arep nganakké kumpulan pandonga bebarengan karo wong wédok-wédok, uga Maria, ibuné Gusti Yésus lan sedulur-seduluré. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ora let suwi, dongé para rasul ijik ngumpul, kabèhé kira-kira ènèng wong satus rong puluh, rasul Pétrus terus maju ngomong ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Para sedulur, sing wis ketulis nang Kitab, sing wis diomong karo Roh Sutyi lantaran ratu Daved, kudu klakon. Nang Kitab kuwi ngomongké bab Yudas, sing ngréwangi wong-wong sing nyekel Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas kuwi tunggalé karo awaké déwé, awit dèkné wis dipilih karo Gusti Yésus mèlu ngerjani penggawéané awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Karo duwit upahé ala sing dilakoni mau Yudas terus tuku kebon. Nang kono dèkné mati, tiba mengkurep, wetengé njebrot sampèk mbrodol ususé. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wong-wong nang Yérusalèm pada ngerti kabèh bab iki, mulané keboné kuwi dijenengké ‘Akeldama’ tegesé: ‘Kebon Getih.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Rasul Pétrus terus ngomong menèh: “Nang kitab Masmur ènèng tulisan ngéné: ‘Omahé dadia suwung, aja sampèk ènèng sing ngenggoni.’ Uga ènèng tulisan liyané ngéné: ‘Bèn wong liyané nggentèni penggawéané.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Mulané para sedulur, saiki kudu ènèng wong siji sing kudu nggenepi dadi rasul sing dipilih karo Gusti, wong sing uga mèlu nyeksèni enggoné Gusti Yésus tangi sangka pati. Wong iki kudu dipilih sangka tengahé sedulur-sedulur sing kawit wiwitané bebarengan karo awaké déwé, suwéné awaké déwé mèlu Gusti Yésus, wiwit Dèkné dibaptis karo Yohanes nganti tekan budalé nang swarga.” ");
INSERT INTO jvnNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Wong-wong sing kumpulan mau terus pada milih wong loro, yakuwi Yosèf, sing uga jenengé Barsabas (uga katyeluk Yustus) lan wong sing liyané jenengé Matias. ");
INSERT INTO jvnNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Wong-wong terus pada ndedonga marang Gusti ngomong ngéné: “Duh Gusti, Kowé sing mangertèni atiné kabèh manungsa. Mulané Gusti, mbok dipilih sangka wong loro iki, sapa sing kudu ngganti Yudas. Awit Yudas ninggal penggawéané lan lunga nang panggonan sing wis dityawiské kanggo dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Saiki sing milih terus nganggo lotré lan Matias sing kepilih dadi rasulé Gusti Yésus, kanggo nggenepi rasul sing rolas. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Saiki dongé dina Pantékosta. Wong-wong sing pretyaya marang Gusti Yésus ijik pada ngumpul bebarengan, pada ndedonga. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Lah kok terus dadakan waé ènèng swara sangka langit, gemrubuk kaya angin gedé. Swarané ngebeki omah sing dienggo kumpulan kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Wong-wong terus weruh kaya ilat geni. Ilat geni iki nang nduwuré saben wong sing nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wong-wong kuwi kabèh terus dikwasani karo Roh Sutyi, terus ngetokké tembung sangka basa liya, tembung-tembung sing metu sangka karepé Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ing wayah kuwi kuta Yérusalèm katekan wong Ju pirang-pirang sangka negara ngendi waé, wong sing pretyaya marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kadung wong-wong kuwi krungu swara mau terus pada gemruduk marani panggonané. Wong-wong iki pada nggumun kabèh, awit saben wong krungu murid-muridé Gusti Yésus ngetokké tembung ing basané wong-wong Ju sing pada teka mau. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Sangking nggumuné wong-wong mau terus pada ngomong: “Wong-wong kuwi lak sangka Galiléa ta? ");
INSERT INTO jvnNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Lah awaké déwé kok krungu wong-wong kuwi ngomong basané awaké déwé kabèh? ");
INSERT INTO jvnNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Awaké déwé iki lak teka sangka werna-werna negara ta, kayadéné negara Parti, Medi, Elam lan Mésopotami, Yudéa lan Kapadosia, Pontus lan Asia, Frigia lan Pamfili, negara Egipte lan bawah Kiréné nang negara Libia. Uga nang kéné ènèng wong Ju lan wong liya bangsa sing pada ngleboni agama Ju sing sangka kuta Rum, sangka pula Kréta lan bawah Arab. Lah awaké déwé kok bisa krungu wong-wong kuwi ngomongké penggawéné Gusti Allah sing nggumun-nggumunké ing basa-basané awaké déwé?” ");
INSERT INTO jvnNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wong-wong sing pada nyawang kuwi pada nggumun tenan, mulané pada takon marang sakpada-pada: “Iki apa ta sakjané?” ");
INSERT INTO jvnNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Malah terus ènèng sing pada sembrana lan semaur: “Wong-wong kuwi mabuk!” ");
INSERT INTO jvnNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Rasulé Gusti Yésus sing rolas terus pada maju lan rasul Pétrus terus ngomong karo swara banter: “Para sedulurku kabèh bangsa Ju lan para sedulurku kabèh sing manggon nang kuta Yérusalèm, omongku iki dirungokké sing apik, supaya kowé kabèh bisa dunung lelakon sing nang kéné iki. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aja mikir nèk wong-wong iki mabuk, ora, awit saiki ijik jam sanga ésuk. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nanging lelakon iki wis diomong karo nabi Joèl ing jamané mbiyèn. Dèkné ngomong ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ing entèk-entèkané jaman Gusti Allah bakal ngedunké Rohé marang kabèh manungsa. Anak-anakmu lanang lan wédok bakal ngetokké tembung-tembung sangka Gusti Allah. Sing enom-enom bakal nampa kaweruh lan sing tuwa-tuwa bakal éntuk impèn. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ing wayah kuwi Gusti Allah bakal ngedunké Roh Sutyi marang peladèn-peladèn lanang lan wédok lan peladèn-peladèn iki bakal pada ngetokké tembung-tembung sangka Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gusti Allah bakal ngekèki mujijat-mujijat nang langit nduwur lan nang bumi ngisor bakal ènèng tandané uga, yakuwi getih, geni lan kebul. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sakdurungé dinané Gusti teka, dina sing gedé lan nggumunké, srengéngé bakal malih peteng lan mbulané bakal malih abang kaya getih. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ing wayah kuwi saben wong sing nyebut jenengé Gusti bakal kapitulungan.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Rasul Pétrus terus ngomong menèh: “Para sedulurku bangsa Israèl! Pada pretyayaa marang sing tak omong iki. Gusti Yésus sangka kuta Nasarèt, pantyèn Dèkné sing dikongkon teka nang jagat kéné karo Gusti Allah. Bab kuwi kowé kabèh wis pada nitèni déwé sangka prekara-prekara sing nggumun-nggumunké, sing ditindakké karo Gusti Allah lantaran Gusti Yésus. Kowé kabèh wis pada ngerti bab kuwi, awit kabèh kuwi klakon nang tengahmu kéné. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Manut pikirané lan kekarepané Gusti Allah déwé Gusti Yésus wis dipasrahké marang kowé kabèh. Gusti Yésus mbok patèni lantaran wong dosa sing maku Dèkné nang kayu pentèngan. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nanging kesuwun marang Gusti Allah sing nangèké Gusti Yésus sangka pati lan ngutyuli Dèkné sangka sangsarané pati, awit pangwasané pati ora bisa nggondèli Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ratu Daved mbiyèn ngomongké bab Gusti Yésus ngéné: ‘Aku slawasé karo Gusti Allah, Dèkné nang jèjèrku, mulané Aku ora wedi. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Atiku lan tembungku kebek karo kabungahan. Senajana Aku kudu mati, Aku ora wedi, nanging Aku nduwèni pengarep-arep. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Awit Gusti Allah ora bakal ngelungké Aku nang panggonané wong mati lan ora bakal nglilani badanku dadi rusak nang kuburan, awit Aku temen marang Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Gusti Allah wis nduduhké dalan sing nekakké kauripan marang Aku. Nang jèjèré Gusti Allah Aku nduwèni bungah ing ati.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Para sedulur kabèh, ratu Daved, mbah-mbahané awaké déwé, wis mati lan kakubur. Wujuté kuburané dèkné kawit saiki ijik ènèng nang nggoné awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ratu Daved kuwi pantyèn nabi lan dèkné ngerti nèk Gusti Allah wis ngetokké prejanjian marang dèkné nganggo sumpah, yakuwi, Gusti Allah bakal ngedekké ratu sangka turunané ratu Daved déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ratu Daved mau sakjané wis weruh apa sing bakal ditindakké karo Gusti Allah ing tembé. Dèkné ngomongké bab tanginé Kristus sangka pati, dongé dèkné ngomong: ‘Gusti Allah ora bakal ngelungké aku nang panggonané wong mati lan Gusti Allah ora bakal nglilani badanku dadi rusak nang kuburan.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Ya Gusti Yésus iki sing ditangèkké sangka pati karo Gusti Allah. Awaké déwé iki kabèh dadi seksiné kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Para sedulur, Gusti Yésus saiki wis munggah nang swarga lan Dèkné njagong nang tengené Gusti Allah lan wis nampa Roh Sutyi sangka Gusti Allah Bapaké, kaya sing wis dijanji. Ya Roh Sutyi iki sing wis diedunké marang awaké déwé kabèh. Ya penggawéané Roh Sutyi iki sing saiki mbok sawang lan mbok rungokké. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Awit para sedulur, ratu Daved déwé ora munggah nang swarga, dèkné namung ngomong ngéné: ‘Gusti Allah wis ngomong marang Gustiku: Réné njagong nang tengenku. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Nganti mungsuh-mungsuhmu wis tak dadèkké antyik-antyiké sikilmu.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Para sedulur, dadiné bangsa Israèl kabèh saiki kudu ngerti, nèk Gusti Yésus sing mbok patèni nang kayu pentèngan, sing didadèkké Gusti lan Kristus karo Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kadung wong-wong pada krungu tembungé rasul Pétrus kuwi mau, atiné terus krasa susah banget. Terus pada takon marang rasul Pétrus lan rasul liya-liyané: “Lah saiki awaké déwé kudu nglakoni apa?” ");
INSERT INTO jvnNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Rasul Pétrus semaur: “Kowé kabèh kudu ninggal urip sing ala lan kudu nurut Gusti. Kowé kudu njaluk dibaptis nganggo jenengé Gusti Yésus Kristus, supaya kowé bisa nampa pangapura sangka dosamu lan kowé mesti bakal nampa pawèhé Gusti Allah, yakuwi Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Awit prejanjian iki pantyèn kanggo kowé lan turunanmu kabèh lan kabèh bangsa liyané sing dipanggil karo Gusti Allahé awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ya ngono kuwi enggoné rasul Pétrus ndunung-ndunungké marang wong-wong lan ngundang wong-wong supaya pada nylametké uripé sangka karusakan sing bakal nekani kabèh wong sing nglakoni ala. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Okèh wong sing pada pretyaya marang tembungé rasul Pétrus, terus pada dibaptis. Ing dina kuwi sing pretyaya tambah telung èwu wong. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wong-wong sing pretyaya pada temen enggoné nggatèkké marang piwulangé para rasul lan pada bebarengan ing sembarang, pada mangan bebarengan lan pada ndedonga bebarengan. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Para rasul nindakké prekara pirang-pirang sing nggumun-nggumunké, mulané kabèh wong pada wedi lan ngajèni tenan. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wong-wong sing pretyaya pada tambah kentyeng enggoné bebarengan. Apa nduwéné dianggep wèké wong kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Enèng sing ngedoli apa nduwéné lan sepira payuné diedum-edumké marang liya-liyané, manut butuhé déwé-déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Saben dina wong-wong mau pada ngumpul nang Gréja Gedé lan pada mangan bebarengan nang omahé, gentèn-gentènan. Apa ènèngé dipangan karo ati bungah lan trima. ");
INSERT INTO jvnNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Wong-wong iki pada memuji marang Gusti Allah lan pada diajèni lan disenengi karo wong kabèh. Saben dina Gusti nambahi wong sing pada nampa keslametan. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ing sakwijiné dina, kira-kira jam telu awan, wayahé kumpul pandonga, rasul Pétrus lan rasul Yohanes budal nang Gréja Gedé. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nang jèjèré lawangé gréjané, sing jenengé Lawang Apik, ènèng wong sing lumpuh kawit lairé. Wong iki saben dina digéndong disèlèhké nang jèjèré lawang kono, supaya ngemis marang wong sing pada mlebu nang Gréja Gedé kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kadung wongé weruh rasul Pétrus lan rasul Yohanes liwat kono, wongé terus njaluk duwit. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Rasul loro mau mandeng wongé terus rasul Pétrus ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","“Delokké aku iki!” Wongé terus ndelokké rasul Pétrus lan rasul Yohanes, ndarani arep dikèki apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nanging rasul Pétrus malah ngomong: “Duwit aku ora nduwé, nanging apa nduwéku tak kèkké marang kowé: ing Jenengé Gusti Yésus Kristus sangka Nasarèt, mlakua!” ");
INSERT INTO jvnNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Rasul Pétrus terus nyekel tangané wongé sing tengen terus diréwangi ngadek. Sikilé lan poloké wongé terus sakwat krasa kuwat. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wongé terus ngadek jejek lan molai mlaku rana-réné, terus mèlu rasul Pétrus lan rasul Yohanes mlebu Gréja Gedé karo mentyolot-mentyolot lan memuji Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wong pirang-pirang sing nang kono pada weruh wongé mlaku lan memuji Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Wong-wong nitèni nèk wongé kuwi sing tukang ngemis nang jèjèré Lawang Apik. Mulané wong-wong nggumuné ora ènèng entèké bab sing klakon ing uripé wong kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wong sing mauné lumpuh nanging saiki bisa mlaku kuwi terus ngetutké rasul Pétrus lan rasul Yohanes waé, mulané wong-wong sing nggumun mau pada ngrubung rasul Pétrus lan rasul Yohanes nang kono, nang panggonan sing jenengé Gadriné Soléman. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kadung rasul Pétrus weruh wong pirang-pirang mau, dèkné terus ngomong: “Para sedulur bangsa Israèl, kenèng apa kowé kok pada nggumun. Lah kok pada nyawang kaya awaké déwé waé sing marakké wongé bisa mlaku. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Gusti Allahé Bapa Abraham, Isak lan Yakub, Gusti Allahé mbah-mbahané awaké déwé, wis ngunggulké peladèné, yakuwi Gusti Yésus. Kowé wis masrahké Dèkné marang para pangwasa, nang ngarepé gramang Pilatus. Dèkné mbok tampik, senajan Pilatus déwé wis nggawé putusan arep ngetyulké Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dèkné wong sing nglakoni kekarepané Gusti Allah lan Dèkné ora ènèng salahé, nanging malah mbok tampik. Kowé malah nembung marang Pilatus kongkon ngutyuli wong sing tukang matèni wong. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tibaké kowé matèni wong sing dadi dalané kauripan. Nanging Gusti Allah wis nangèké Gusti Yésus sangka pati lan aku lan kantya-kantyaku wis nyeksèni kuwi déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ya pangwasané Jenengé Gusti Yésus sing ngekèki kekuwatan marang wong iki. Kowé pada nitèni déwé, jalaran sangka pretyaya ing jenengé Gusti Yésus Kristus wong lumpuh iki bisa waras sak kabèhé. Kowé pada weruh déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Para sedulur, aku saiki pantyèn wis ngerti nèk kowé mauné pada kurang pangertiné. Mulané kowé lan penuntun-penuntunmu pada nindakké ngono. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nanging pantyèn wis kudu klakon ngono, supaya apa sing diomong karo Gusti Allah lantaran para nabi ing jaman mbiyèn saiki bisa keturutan, yakuwi: Kristus kudu nglakoni sangsara. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mulané para sedulur, pada ninggala urip sing ala lan pada balika marang Gusti Allah, supaya kowé bisa nampa pangapura sangka dosamu. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Gusti Allah mengko mesti terus ngepénakké atimu lan ngongkon Gusti Yésus, sing wis dadi Juru Slametmu, teka. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Gusti Yésus saiki kudu ngentèni nang swarga nganti tekan waktuné sembarang dadi anyar, kaya sing wis diomong karo Gusti Allah lantaran para nabi ing jaman mbiyèn. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Wujuté nabi Moses wis ngomong ngéné: ‘Gusti Allahmu bakal ngongkon nabi teka marang kowé, kaya enggoné ngongkon aku, nabi sangka tengahmu déwé. Kowé kudu nggatèkké marang sembarang sing diomong karo dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nanging sapa sing ora nggugu marang nabi mau, bakal dipisah lan diusir sangka brayaté Gusti Allah.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Para nabi kabèh sing pada ngetokké tembungé Gusti Allah, molai karo nabi Samuèl lan liya-liyané sak mburiné dèkné, kabèh wis pada ngomongké bab jaman iku. ");
INSERT INTO jvnNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Prejanji-prejanjiané Gusti Allah sing diomong karo para nabi kuwi kabèh kanggo kowé. Mulané kowé katut ing prejanjiané Gusti Allah marang para simbah ing jaman mbiyèn, yakuwi prejanjiané Gusti Allah marang Bapa Abraham sing uniné ngéné: ‘Kabèh bangsa nang sak lumahé bumi bakal mèlu nampa berkah, jalaran sangka turunanmu.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yakuwi mau jalarané enggoné Gusti Allah wis milih lan ngongkon Peladèné nekani kowé ndisik, mberkahi lan nuntun kowé kabèh, supaya kowé pada ninggal dalan sing ala.” ");
INSERT INTO jvnNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Dongé rasul Pétrus lan rasul Yohanes ijik pada mituturi wong pirang-pirang mau, dadakan waé terus diparani para imam, uga kumendané sing jaga Gréja Gedé lan wong-wong sangka golongané para Saduki. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wong-wong kuwi pada nesu, jalaran para rasul mau mulangi wong-wong nèk Gusti Yésus wis tangi sangka pati. Kuwi kanggo tanda nèk wong mati bakal tangi menèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rasul loro mau terus dityekel lan dilebokké nang setrapan sampèk ésuké, awit wis soré. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nanging wong-wong sing pada ngrungokké piwulangé para rasul mau okèh sing pretyaya marang Gusti Yésus lan saiki sing pretyaya okèhé malih kira-kira limang èwu, namung wong lanangé. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ing ésuké para pengarepé wong Ju, para pinituwa lan para guru Kitab pada ngumpul nang kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Wong-wong kuwi arep pada rembukan karo Imam Gedé Anas, uga Kayafas, Yohanes lan Alèksander lan wong kabèh sing dadi brayaté Imam Gedé. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Para rasul mau terus dikongkon maju lan ditakoni: “Sapa sing ngekèki pangwasa marang kowé bisa nambani wong? Kowé nganggokké jenengé sapa?” ");
INSERT INTO jvnNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Rasul Pétrus terus semaur ing pangwasané Roh Sutyi: “Para pengarep lan para pinituwa! ");
INSERT INTO jvnNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Awaké déwé saiki dikrutu jalaran awaké déwé nggawé betyik marang wong sing lumpuh kaé. Lan kowé kepéngin ngerti kepriyé wongé bisané mari! ");
INSERT INTO jvnNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mulané, saiki kowé kabèh lan bangsa Israèl pada ngertia iki: wong iki bisa waras ngadek nang ngarepmu sangka pangwasané Jenengé Gusti Yésus Kristus sangka kuta Nasarèt. Dèkné sing mbok patèni nang kayu pentèngan, nanging ditangèkké sangka pati karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ya bab Gusti Yésus iki sing ketulis ngéné nang Kitab: ‘Watu sing ora dikanggokké karo sing tukang nggawé omah malah dadi watu sing penting déwé.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Keslametan kuwi tekané namung sangka Gusti Yésus, ora sangka wong liya. Awit nang sak ngisoré langit iki ora ènèng jeneng liyané pawèhé Gusti Allah marang manungsa, sing bisa nylametké awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Para warga Kruton Agama pada nggumun kabèh weruh kekendelané rasul Pétrus lan rasul Yohanes, malah-malah pada krungu nèk rasul loro iki namung wong tyilik waé, ora wong sing duwur sekolahané. Wong-wong mau terus kélingan nèk para rasul iki tau mèlu Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nanging para warga Kruton Agama mau ora bisa ngomong apa-apa, jalaran weruh wong sing ditambani kuwi ngadek karo para rasul. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mulané wong-wong sing ngrutu mau terus ngongkon para rasul metu sangka kamar kono. Para warga Kruton Agama terus pada rembukan déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wong-wong iki terus takon marang sakpada-pada: “Wong-wong kuwi kudu dikapakké ya? Kabèh wong sing manggon nang Yérusalèm wis ngerti nèk wong-wong kuwi nindakké tanda sing nggumunké tenan. Bab kuwi awaké déwé kudu ngakoni. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nanging supaya prekara iki ora mrèmèn-mrèmèn, apiké wong-wong kuwi dipenging ngomong karo wong liyané menèh bab Yésus.” ");
INSERT INTO jvnNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Rasul Pétrus lan rasul Yohanes terus dityeluk kongkon mlebu menèh terus dipenging aja pisan-pisan ngomongké apa mulang bab Jenengé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nanging rasul loro mau semaur: “Mbok pada dipikir déwé ta? Sing endi sing bener nang ngarepé Gusti Allah: manut omongmu apa manut tembungé Gusti Allah? ");
INSERT INTO jvnNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Awaké déwé ora bisa nyimpen apa sing awaké déwé wis weruh lan krungu déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Para warga Kruton Agama mau ora nemu jalaran blas kanggo nyetrap para rasul mau, mulané ya namung dipenging sing tenanan. Rasul Pétrus lan rasul Yohanes terus dietokké, awit wong kabèh pada memuji Gusti Allah, sakwisé weruh lelakon karo wong sing lumpuh mau. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wujuté wong sing bisa mlaku jalaran sangka mujijat kuwi umuré ya wis patang puluh taun. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sakwisé dietokké, rasul Pétrus lan rasul Yohanes terus pada balik marani kantya-kantyané lan pada nyritakké apa sing diomong karo para imam lan para pinituwa. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Krungu tembungé rasul Pétrus lan rasul Yohanes mau, wong-wong terus pada ndonga marang Gusti Allah: “Duh Gusti sing nggawé langit, bumi, segara, lan sak isiné kabèh! ");
INSERT INTO jvnNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Lantaran Roh Sutyi Gusti wis ngomong ngéné liwat peladèné Gusti, yakuwi ratu Daved, mbah-mbahané awaké déwé mbiyèn: ‘Kenèng apa wong sing ora kenal marang Gusti Allah kok pada nesu lan pada nggawé rantyaman sing ora ènèng gunané? ");
INSERT INTO jvnNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ratu-ratuné pada tata-tata lan para pangwasa pada nglumpuk arep nglawan marang Gusti Allah lan Kristus.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Wujuté ratu Hérodès lan gramang Pontius Pilatus ya wis pada setuju karo wong sing ora kenal marang Gusti Allah lan karo bangsa Israèl, supaya pada nglawan marang Gusti Yésus, Peladèné Gusti sing temen, sing wis dipilih karo Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Enggoné wong-wong kabèh kuwi pada nglumpuk, tujuané arep nindakké sembarang sing wis dikarepké karo Gusti déwé kawit wiwitané. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mulané saiki Gusti, rungokké enggoné wong-wong kuwi pada medèn-medèni marang awaké déwé kabèh lan muga-muga Gusti ngekèki kekendelan marang peladèn-peladèné, supaya awaké déwé bisa nggelarké pituturé Gusti terus. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Muga Gusti ngelungké tangané kanggo nambani sing lara lan nindakké mujijat nganggo jenengé Peladèné Gusti sing sutyi, yakuwi Gusti Yésus.” ");
INSERT INTO jvnNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kadung wong-wong rampung enggoné ndedonga, panggonan sing dienggo ngumpul mau terus hoyak. Kabèh terus dikwasani karo Roh Sutyi terus pada ngabarké pituturé Gusti Allah karo kendel. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wong-wong sing pretyaya mau pada rukun dadi siji ing ati lan kekarepan. Ora ènèng wong sing ngarani apa nduwéné kuwi namung wèké dèkné déwé, nanging sembarang dikanggokké bebarengan. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Para rasul pada ngekèki paseksi bab tanginé Gusti Yésus sangka pati nganggo pangwasa sing gedé lan Gusti Allah ngedunké berkahé kanti lubèr marang wong-wong mau kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nang pasamuan ora ènèng wong siji-sijia sing kekurangan, awit wong-wong sing nduwé kebon lan omah pada diedoli. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Sepira payuné terus dipasrahké marang para rasul. Duwité terus diedum-edum marang wong-wong sing mbutuhké, miturut butuhé déwé-déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Semono uga Yosèf, wong Lévi sangka pula Siprus, sing dityeluk Barnabas karo para rasul. Tembung Barnabas kuwi tegesé panglipur. Yosèf iki ngedol keboné. Duwité terus dipasrahké marang para rasul. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Nang pasamuan kono uga ènèng sakwijiné wong sing jenengé Ananias lan bojoné jenengé Safira. Ananias ngedol keboné, nanging sakdurungé masrahké duwité marang para rasul, dèkné njikuk kanggo dèkné déwé. Safira uga setuju. Duwité liyané terus dikèkké marang para rasul. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nanging rasul Pétrus ngomong: “Ananias, kenèng apa kowé kok nglilani Sétan ngwasani atimu, nganti kowé wani ngapusi Roh Sutyi lan nyolong duwité kebonmu? ");
INSERT INTO jvnNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sakdurungé mbok edol kebon kuwi lak wèkmu déwé ta? Sakwisé mbok edol duwité lak ya wèkmu déwé ta? Apa jalarané kowé kok nindakké sing kaya ngono? Dudu manungsa sing mbok apusi, nanging Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kadung krungu tembung kuwi, Ananias terus tiba mati. Wong kabèh sing krungu bab kuwi terus pada wedi banget. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sedulur enom-enoman sing nang kono terus pada mlebu, mbuntel layoné terus dikubur. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kira-kira telung jam sakwisé kuwi Safira terus teka, nanging ora ngerti nèk bojoné wis mati. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Rasul Pétrus takon marang Safira: “Apa duwit iki éntuk-éntuké kabèh sing dodol kebon?” Safira semaur: “Ya, namung semono!” ");
INSERT INTO jvnNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Rasul Pétrus terus nyenèni: “Kenèng apa kowé kok nyetujoni bojomu lan pada njajal Rohé Gusti? Wong-wong sing entas ngubur layoné bojomu wis teka arep nggotong kowé!” ");
INSERT INTO jvnNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Safira sakwat tiba mati nang ngarepé rasul Pétrus. Sedulur enom-enoman mau terus pada mlebu lan weruh wong wédok mau wis mati. Layoné terus digotong metu, dikubur nang jèjèré sing lanang. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wong sak pasamuan lan wong-wong liyané kabèh sing pada krungu bab kuwi pada wedi banget. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Para rasul pada nindakké mujijat lan tanda pangwasa pirang-pirang nang tengahé wong okèh. Wong-wong sing pretyaya pada ngumpul nang Gréja Gedé, nang panggonan sing jenengé Gadriné Soléman. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Wong sak njabané pasamuan ora ènèng sing wani mèlu kumpulan, senajan kabèh pada ngajèni tenan marang wong pasamuan mau. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nanging sing pretyaya marang Gusti Yésus selot suwi selot tambah okèh, lanang lan wédok. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mujijat-mujijat sing ditindakké karo para rasul mau marakké wong sing lara pada digotongi nang dalan-dalan lan disèlèhké nang ambèn apa klasa. Wong-wong kuwi ngentèni rasul Pétrus liwat, supaya sak ora-oraé ayang-ayangé nibani salah-sijiné. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wong pirang-pirang sangka kuta-kuta nang sak ubengé kuta Yérusalèm pada gemruduk teka, nggawa sing lara lan sing kelebon demit lan kabèh nampa kwarasan. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lelakon-lelakon kuwi kabèh marakké Imam Gedé lan kantya-kantyané sangka golongan Saduki pada mèri marang para rasul. Mulané terus pada tumandang. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Para rasul terus dityekel lan dilebokké nang setrapan. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nanging mbengi kuwi mulékaté Gusti mbukak lawang-lawangé setrapané lan nuntun para rasul metu sangka kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Mulékat mau ngomong ngéné: “Kana pada nang Gréja Gedé lan wong-wong diwulangi sembarang bab urip anyar iki.” ");
INSERT INTO jvnNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Para rasul pada manut marang tembung kuwi lan ésuk-ésuk mruput pada mlebu nang Gréja Gedé terus molai mulangi wong-wong. Ing wayah kuwi Imam Gedé lan kantya-kantyané pada nglumpukké pinituwané bangsa Ju kabèh, pada nganakké Kruton Agama. Wong-wong terus kongkonan ngetokké para rasul arep ditakoni. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nanging kadung tekan setrapané, para rasul wis ora ènèng. Wong-wong terus balik ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Dongé awaké déwé tekan setrapan, lawangé ijik dikantying kabèh lan sing tukang jaga ya ijik pada njaga nang ngarepé lawangé. Nanging kadung lawangé dibukak, nang njero ora ènèng wongé siji-sijia.” ");
INSERT INTO jvnNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kumendané sekaut sing jaga Gréja Gedé lan para pengarepé imam krungu kabar kuwi mau, terus pada gèdèk-gèdèk kabèh, nggumun mikirké lelakon karo para rasul kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nanging ora let suwi ènèng wong mlebu kono ngomong: “Wong-wong sing mbok lebokké nang setrapan saiki pada nang Gréja Gedé mulangi wong okèh.” ");
INSERT INTO jvnNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kumendané sekaut sing jaga Gréja Gedé terus budal karo sekaut-sekauté arep nyekel para rasul, nanging ora nganggo patrap sing kasar, awit wedi nèk dibandemi watu karo wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Para rasul terus digawa mlebu nang ngarepé Kruton Agama kono. Imamé Gedé ngomong: ");
INSERT INTO jvnNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Kowé lak wis tak penging mulang bab Yésus ta. Lah malah kepriyé? Kowé malah pada nyebar piwulang sampèk mrèmèn-mrèmèn nang sak kuta Yérusalèm kabèh lan awaké déwé arep mbok salahké matèni Yésus.” ");
INSERT INTO jvnNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Rasul Pétrus lan para rasul liyané terus semaur: “Awaké déwé kudu manut marang Gusti Allah ngungkuli kekarepané manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gusti Allahé mbah-mbahané awaké déwé wis nangèké Gusti Yésus, sakwisé Dèkné mbok patèni nang kayu pentèngan. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ya Gusti Yésus iki sing wis dikèki pangwasa sing duwur déwé karo Gusti Allah. Dèkné didadèkké Penuntun lan Juru Slamet, supaya bangsa Israèl bisa éntuk kelunggaran ninggal laku ala lan bisa nampa pangapurané dosa. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Prekara iki kabèh awaké déwé wis nyeksèni. Semono uga Roh Sutyi dadi seksi, ya Roh Sutyi iki sing dikèkké marang saben wong sing manut marang Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Para wargané Kruton Agama mau pada nesu banget krungu sauran kuwi, lan nggawé putusan arep matèni para rasul. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nanging ènèng sakwijiné wong Farisi sing jenengé Gamalièl, guru wèté Kitab, sing diajèni banget karo wong kabèh. Dèkné ngadek terus ngongkon nggawa para rasul metu sedélok. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gamalièl terus ngomong: “Para sedulur bangsa Israèl! Kowé kudu sing ati-ati tenan karo sing arep mbok tindakké karo wong-wong iki. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Awit mbiyèn ya wis tau ènèng wong sing jenengé Téodas njedul; dèkné ngakuné nduwé kwasa gedé lan sing mèlu dèkné kira-kira ènèng wong patang atus okèhé. Téodas terus dipatèni lan sing mèlu dèkné saiki pada buyar kabèh lan golongan kuwi wis mati. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sakwisé kuwi terus ènèng liyané menèh njedul: Yudas sangka Galiléa. Kuwi wayahé ènèng itung-itungan bangsa. Wong pirang-pirang pada mèlu golongan sing ora apik kuwi. Yudas uga dipatèni lan wargané buyar kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Semono uga saiki, mulané kowé kudu sing ati-ati tenan, aja sampèk wong-wong iki mbok apak-apakké. Aja dialang-alangi, awit nèk penggawéné wong-wong iki metuné sangka karepé manungsa, mesti suwi-suwi bakal mandek déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nanging nèk penggawéné wong-wong iki metuné sangka Gusti Allah, kowé ora bakal bisa ngrusak. Aja sampèk mengko kowé entèk-entèké jebulé malah nglawan Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wong-wong nang Kruton Agama kono pada manut marang tembungé Gamalièl lan para rasul terus dityeluk kongkon mlebu menèh. Sakwisé dipetyuti, para rasul terus dipenging mulang bab Gusti Yésus menèh terus dietokké. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Para rasul terus lunga sangka Kruton Agama karo bungah, awit keanggep pantes nandang sangsara kanggo Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Para rasul mau saben dina terus pada neruské enggoné mulang lan nggelarké kabar kabungahané Gusti Yésus nang Gréja Gedé lan nang omah-omah lan ndunung-ndunungké nèk Gusti Yésus kuwi Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ora let suwi, kadung wong-wong sing nurut Gusti Yésus mundak okèh, terus ènèng karépotan nang tengahé wong Ju sing ngomong Grik karo wong Ju sing ngomong Ibrani. Sing dadi jalaran edum-edumané duwit kanggo nulungi para mbok randa ing saben dinané. Wong-wong Ju sing ngomong Grik pada kelah nèk para randané pada kekurangan, awit ora nampa bagèan sing sak mestiné. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mulané para rasul rolas terus nglumpukké wong sing pretyaya kabèh diomongi ngéné: “Para sedulur, ora apik nèk awaké déwé iki kudu ninggal penggawéan mulang pituturé Gusti, jalaran kudu ngurusi duwit. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mulané, pada nggolèka wong pitu sangka tengahmu, wong sing betyik lan sing kebek karo Roh Sutyi lan kaweruh. Wong-wong kuwi bakal dibagèhi penggawéan ngedum duwit. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Lah awaké déwé iki rasul namung merlokké pandonga lan pituturé Gusti waé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Wong sak pasamuan pada setuju kabèh karo tembungé para rasul mau, mulané terus pada milih Stéfanus, sakwijiné sedulur sing gedé pengandelé lan kebek karo Roh Sutyi. Liyané sing uga dipilih yakuwi: Filipus, Prokorus, Nikanor, Timon, Parménas lan Nikolaus. Nikolaus kuwi wong sangka kuta Antioki sing mlebu agama Ju. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sedulur pitu mau terus dipasrahké marang para rasul, sing ndongakké lan numpangi tangan marang sedulur-sedulur kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pituturé Gusti Allah terus mrèmèn-mrèmèn terus lan wong sing pada pretyaya marang Gusti Yésus terus mundak okèh nang Yérusalèm, malah imam-imam mbarang okèh sing pada pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stéfanus kuwi wong sing kebek karo pengandel lan kekuwatané Gusti lan nindakké mujijat-mujijat lan tanda-tanda sing nggumunké nang ngarepé wong-wong kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nanging sangka tengahé bangsa Ju ènèng sing pada nglawan marang Stéfanus. Kuwi para wargané sinaguk, golongan sing diarani Libèrtini, sangka kuta Siréné lan kuta Alèksandria. Wong-wong Libèrtini iki bebarengan karo wong Ju sangka bawah Silisia lan Asia pada molai bantah-bantahan karo Stéfanus. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nanging Stéfanus nampa kaweruh sangka Roh Sutyi, mulané wong-wong mau ora bisa mbantahi tembungé Stéfanus. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wong-wong terus ngejokké wong siji-loro kongkon ngomong ngéné: “Awaké déwé krungu wong iki ngèlèk-èlèkké nabi Moses lan Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mengkono kuwi wong-wong mau marakké gègèran nang tengahé wong-wong kono lan uga nang tengahé para pinituwa lan para guru Kitab. Stéfanus terus dikroyok lan dityekel, terus digawa nang ngarepé Kruton Agama. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Enèng wong siji-loro sing dijokké kongkon dadi seksi sing goroh. Wong-wong iki ngomong ngéné: “Awaké déwé krungu wong iki bolak-balik ngèlèk-èlèkké Gréja Gedé iki lan wèt-wèté nabi Moses. ");
INSERT INTO jvnNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Awaké déwé krungu wong iki ngomong nèk Yésus sangka Nasarèt iki arep mbubrah Gréja Gedé iki lan arep ngganti adat-tata-tyara sing diwulangké nabi Moses kanggo awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wong kabèh sing dadi wargané Kruton Agama pada ndelokké Stéfanus lan weruh nèk rupané dèkné kétok kaya rupané mulékat. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Imam Gedé terus takon marang Stéfanus: “Apa sing diomong karo wong-wong kuwi bener?” ");
INSERT INTO jvnNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stéfanus semaur: “Para sedulur lan para bapak kabèh. Omongku iki dirungokké sing apik. Gusti Allah, sing gedé déwé kwasané, wis ngétok marang mbah-mbahané awaké déwé Abraham, dongé dèkné ijik manggon nang tanah Mésopotami. Kuwi sakdurungé Bapa Abraham boyongan nang kuta Haran. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Gusti Allah ngomong marang dèkné: ‘Abraham, kana lungaa, sedulurmu lan panggonanmu tinggalen lan lungaa nang panggonan sing bakal tak duduhké!’ ");
INSERT INTO jvnNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Bapa Abraham terus ninggal tanah Kaldéa terus manggon nang kuta Haran. Sakwisé bapaké mati Gusti Allah terus ngongkon Bapa Abraham boyongan nang panggonan iki, sing mbok enggoni saiki. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ing wayah kuwi Gusti Allah ora ngekèki kebon marang Bapa Abraham, sak mèter waé ora. Nanging Gusti Allah ngekèki janji marang Bapa Abraham nèk panggonan iki bakal dikèkké marang dèkné lan turunané, senajan ing waktu kuwi Bapa Abraham durung nduwé anak. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gusti Allah ngomong ngéné marang Bapa Abraham: ‘Turunanmu bakal manggon nang negara liya lan bakal dadi slaf sing disiya-siya patang atus taun suwéné. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nanging sak rampungé kuwi Aku bakal nyetrap bangsa sing ngwasani kowé lan turunanmu bakal pada metu sangka negara kuwi lan bakal ngabekti marang Aku nang panggonan kéné iki.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Gusti Allah terus ngekèki pernatan sunat marang Bapa Abraham, kanggo nengeri prejanjian iki. Mulané Bapa Abraham ya terus nyunati anaké sing jenengé Isak, wolung dina sakwisé lair. Bapa Isak semono uga terus nyunati Yakub, anaké lan Bapa Yakub uga terus nyunati turunané, yakuwi mbah-mbahané awaké déwé sing rolas. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Mbah-mbahané awaké déwé terus ngedol Yosèf dadi slaf nang negara Egipte, jalaran pada mèri marang dèkné. Nanging Gusti Allah nuntun Yosèf. Gusti Allah ngluwari Yosèf sangka sak wernané piala. Dongé Yosèf kudu mara nang ngarepé ratuné Egipte, Gusti Allah ngekèki kaweruh gedé marang dèkné, mulané ratuné ngunggahké Yosèf dadi gramangé negara Egipte lan pengurusé palèsé ratuné. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ing wayah kuwi negara Egipte lan Kanaan katekan kasusahan gedé, awit ènèng kekurangan pangan. Para mbah-mbahané awaké déwé ora bisa nemu pangan. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Bapa Yakub krungu nèk nang negara Egipte ènèng, mulané dèkné terus ngongkon anak-anaké, kuwi mbah-mbahané awaké déwé, niliki nang kana. Kuwi teka-tekané mbah-mbahané awaké déwé sing sepisanan nang negara Egipte. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kadung mbah-mbahané awaké déwé teka ping pindoné nang Egipte, Yosèf terus blaka marang sedulur-seduluré lan ratuné terus uga bisa kenal marang seduluré Yosèf. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosèf terus mboyong bapaké lan sedulur-seduluré kabèh nang negara Egipte. Kabèhé ènèng wong pitung puluh lima. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Bapa Yakub lan mbah-mbahané awaké déwé matiné ya nang negara Egipte. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Layoné Bapa Yakub lan anak-anaké mau terus digawa nang kuta Sikem lan dikubur nang kono. Bapa Abraham sakdurungé wis tuku kuburan iki sangka bangsa Hamor. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kadung mèh wis tekan wayahé enggoné Gusti Allah arep nuruti prejanjiané marang Bapa Abraham, bangsa Israèl sing manggon nang Egipte wis mundak dadi okèh banget. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Negara Egipte terus dikwasani karo ratu sing ora kenal marang Yosèf. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ratu iki nindakké sing ora apik lan nyiya-nyiya mbah-mbahané awaké déwé. Mbah-mbahané awaké déwé dipeksa mbuwang bayi-bayi sing entas lair bèn mati. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ing waktu kuwi nabi Moses lair. Rupané jan ngganteng tenan. Telung sasi suwéné nabi Moses dirumati nang omahé wong tuwané. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nanging sakwisé kuwi dèkné uga dibuwang. Ndilalahé ditemu karo anaké ratuné sing wédok. Dèkné sing ngrumati nabi Moses, malah kaya anaké déwé waé. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nabi Moses terus diblajari sak ènèngé kapinterané wong Egipte, mulané ya terus dadi wong sing gedé banget kwasané, ing tembungé lan ing tumindaké. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kadung wis nduwé umur patang puluh taun dèkné terus kepéngin niliki sedulur-seduluré, kuwi bangsa Israèl. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nang kono nabi Moses weruh wong Egipte ngantemi wong Israèl. Dèkné terus mbélani bangsané lan mbales wong Egipte mau, sampèk wongé mati. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Dèkné mikir nèk bangsané dèkné dunung nèk Gusti Allah bakal nganggokké dèkné ngluwari bangsané. Nanging wujuté bangsa Israèl ora dunung. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ing liyané dina nabi Moses weruh wong Israèl loro pada gelut. Dèkné jawané arep misah sing gelut mau, mulané ngomong: ‘Kowé lak tunggal sedulur ta? Lah kok pada gelut ngono?’ ");
INSERT INTO jvnNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","28","Nanging wong sing ngantem liyané mau malah maido nabi Moses ngomong: ‘Sapa sing ndadèkké kowé dadi rèkteré awaké déwé? Apa kowé uga arep matèni awaké déwé kaya enggonmu matèni wong Egipte dèk wingi kaé?’ ");
INSERT INTO jvnNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Krungu wongé ngomong ngono kuwi nabi Moses terus lunga sangka Egipte, budal nang tanah Midian lan manggon nang kono. Nang kono nabi Moses ngepèk bojo terus nduwé anak lanang loro. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Sakwisé patang puluh taun nang tanah Midian terus ènèng mulékat ngétok marang nabi Moses nang grumbulan sing metu geniné, nang wustèn nang gunung Sinai. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Dèkné nggumun weruh kaya ngono kuwi, mulané terus nyedeki. Nanging terus krungu swarané Gusti Allah ngomong ngéné: ‘Aku iki Gusti Allahé mbah-mbahanmu, Gusti Allahé Abraham, Isak lan Yakub.’ Sangking kagèté nabi Moses ora wani ndelokké. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nanging Gusti terus ngomong marang dèkné: ‘Sepatumu dityepot, awit kowé ngadek nang lemah sing sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aku wis weruh kasangsarané umatku sing nang Egipte lan Aku wis krungu sambaté. Aku teka arep ngluwari umatku, mulané Aku arep ngongkon kowé budal nang Egipte.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ya nabi Moses iki sing ditampik karo bangsané déwé nganggo tembung: ‘Sapa sing ndadèkké kowé dadi rèkteré awaké déwé?’ Ya nabi Moses iki sing dikongkon karo Gusti Allah dadi penuntuné bangsané lan sing kudu ngluwari bangsané nganggo pitulungané mulékat, sing ngétok marang dèkné nang grumbulan sing metu geniné. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nabi Moses iki sing nuntun bangsa Israèl metu sangka negara Egipte nganggo mujijat-mujijat lan tanda-tanda sing nggumunké, nang Egipte lan nang segara Abang lan uga nang wustèn, patang puluh taun suwéné. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ya nabi Moses iki sing ngomong marang bangsané: ‘Gusti Allah bakal ngongkon nabi kaya aku iki sangka tengahé sedulurmu kanggo kowé kabèh!’ ");
INSERT INTO jvnNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ya nabi Moses iki sing nglumpuk karo bangsa Israèl nang wustèn. Dèkné nang kono bebarengan karo mulékat sing ngetokké tembung marang dèkné nang gunung Sinai lan karo mbah-mbahané awaké déwé. Nabi Moses iki sing nampa tembung sangka Gusti Allah, tembung sing nekakké urip lan sing kudu dikabarké marang awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nanging para mbah-mbahané awaké déwé ora gelem manut marang nabi Moses, malah pada nampik dèkné lan njaluk balik nang negara Egipte. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wong-wong mau ngomong marang Aron: ‘Awaké déwé mbok digawèkké gusti allah sing bisa nuntun awaké déwé terus. Awit awaké déwé ora ngerti embuh kepriyé saiki karo nabi Moses, sing mboyong awaké déwé sangka Egipte.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wong-wong mau terus pada nggawé retya rupa sapi pedèt terus disajèni. Terus pada mangan énak kanggo ngurmat gawéané déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nanging Gusti Allah terus nyingkuri wong-wong mau, mulané diejarké enggoné pada nyembah marang lintang-lintang nang langit. Pantyèn wis ketulis nang kitabé para nabi, uniné ngéné: ‘Hé wong Israèl! Enggonmu nyembelèh lan kurban kéwan-kéwan suwéné kowé nang wustèn patang puluh taun kuwi apa kanggo Aku? ");
INSERT INTO jvnNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ora! Nanging tarupé Molok lan lintangé déwa Réfan sing mbok arak-arak. Kuwi retya-retya sing mbok gawé lan mbok sembah. Jalaran sangka kuwi kowé bakal tak usir adohé ngliwati negara Babilon.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Para mbah-mbahané awaké déwé pada nduwèni tarupé prejanjian nang wustèn. (Kuwi kanggo tanda nèk Gusti Allah manggon nang tengahé umaté). Tarup prejanjian iki gawéané miturut tembungé Gusti Allah marang nabi Moses, manut gambar sing wis diduduhké karo Gusti Allah marang nabi Moses. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Para mbah-mbahané awaké déwé sing nampa tarup prejanjian iki sangka wong tuwané. Tarup mau digawa sak suwéné para mbah-mbahané awaké déwé dituntun karo Yosua mlebu negara iki. Negara iki karebut sangka bangsa-bangsa sing diusir karo Gusti Allah nang sak ngarepé para mbah-mbahané awaké déwé. Tarup mau kasimpen nganti tekan jamané ratu Daved. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ratu Daved nampa kawelasané Gusti Allah lan nyuwun marang Dèkné, supaya dililani nggawèkké omah kanggo Gusti Allah, sesembahané Yakub. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nanging wujuté sing ngedekké omahé Gusti Allah mau tiba Soléman. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Nanging Gusti Allah sing gedé déwé kwasané ora manggon nang omah gawéané manungsa, kaya sing wis ketulis nang kitabé para nabi sing uniné ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Langit kuwi jagonganku lan bumi kuwi antyik-antyiké sikilku. Omah sing kaya ngapa arep mbok gawé kanggo aku lan nang endi panggonanku kanggo lèrèn. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Apa ora Aku déwé sing nggawé sembarang iki kabèh? Yakuwi tembungé Gusti Allah!’ ");
INSERT INTO jvnNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Kok wangkot temen atimu! Kok kaya wong sing ora ngerti Gusti Allah waé! Kowé ora séjé karo mbah-mbahanmu sing tansah nglawan marang Roh Sutyi! ");
INSERT INTO jvnNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Apa ènèng nabi sing ora disiya-siya karo mbah-mbahanmu? Wong-wong sing ngabarké tekané Peladèné Gusti pada mbok patèni lan Peladèné Gusti déwé mbok pasrahké marang mungsuhé kongkon matèni. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ya kowé kuwi sing wis nampa wèté Gusti Allah sangka para mulékat, nanging wèt-wèt kuwi ora mbok lakoni.” ");
INSERT INTO jvnNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Krungu tembung-tembungé Stéfanus kuwi para wargané Kruton Agama terus pada panas banget atiné lan pada nggeget untu sangking gregeten tenan. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nanging Stéfanus kebek karo Roh Sutyi. Dèkné nyawang nang langit weruh kamulyané Gusti Allah lan uga weruh Gusti Yésus ngadek nang tengené. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stéfanus ngomong: “Delokké, aku weruh swarga menga lan Anaké Manungsa ngadek nang tengené Gusti Allah.” ");
INSERT INTO jvnNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kadung krungu tembung kuwi para wargané Kruton Agama terus pada bengok-bengok karo nutupi kupingé. Wong-wong terus ngroyok Stéfanus. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Stéfanus disèrèt nang sak njabané kuta, terus dibandemi watu. Wong-wong sing nyeksèni mau terus pada utyul-utyul lan saliné njaba terus disèlèhké nang ngarepé sakwijiné wong enom sing jenengé Saulus. ");
INSERT INTO jvnNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sak barengé dibandemi watu mau Stéfanus ndonga marang Gusti ngomong: “Duh Gusti Yésus, tampanen nyawaku.” ");
INSERT INTO jvnNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dèkné terus sedeku lan ngomong banter: “Duh Gusti, mbok salahé wong-wong iki dingapura!” Sakwisé ngomong kuwi Stéfanus terus ninggal. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus uga setuju nèk Stéfanus dipatèni. Wiwit dina kuwi pasamuan nang kuta Yérusalèm dikuya-kuya tanpa welas. Kejaba para rasul, kabèh wong sing pretyaya pada buyar, pentyar nang bawah Yudéa lan Samaria. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Stéfanus terus dikubur karo wong-wong sing nurut Gusti; wong-wong mau tenanan enggoné nangisi Stéfanus. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nanging Saulus mempeng tenan enggoné arep mbubrah pasamuan, mulané saben omah dileboni. Endi waé sing ènèng wong pretyaya, ora perduli lanang apa wédok, kabèh disèrèti metu lan dilebokké nang setrapan. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Wong pretyaya sing pada pentyar nang endi waé malah pada nyebar kabar kabungahané Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Semono uga Filipus; dèkné teka nang kuta Samaria lan nggelarké nèk Gusti Yésus kuwi Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Wong okèh pada nggatèkké tenan marang piwulangé Filipus, awit pada weruh mujijat-mujijat sing ditindakké. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Demit-demit sing ditundungi sangka wong-wong sing kesurupan pada metu pating njlerit. Okèh wong lumpuh lan pintyang uga pada nampa waras. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mulané nang kuta Samaria kono wong-wong pada bungah banget. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nang kuta kono ènèng wong jenengé Simon. Wis suwi Simon kuwi nggawé nggumuné wong pirang-pirang nang kuta Samaria kono nganggo pangwasa peteng. Dèkné ngakuné wong pinter tenan. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mulané nang kuta kono gedé-tyilik kabèh dikenèng karo Simon. Wong-wong ngomong ngéné: “Ya Simon iki sing diarani pangwasané Gusti Allah sing gedé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wong okèh pada manut marang tembungé Simon, awit wis suwi Simon mau nggawé nggumuné wong pirang-pirang nganggo pangwasa peteng. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nanging kadung Filipus nggelarké kabar kabungahan bab Kratoné Gusti Allah lan bab Gusti Yésus, wong pirang-pirang terus pada pretyaya. Kabèh, lanang-wédok, terus pada dibaptis. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon mbarang pretyaya marang Gusti Yésus. Sakwisé dibaptis dèkné terus ngetutké Filipus. Simon nggumun banget weruh mujijat-mujijat sing ditindakké karo Filipus. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Para rasul nang kuta Yérusalèm krungu nèk wong-wong nang Samaria pada gelem nampa pituturé Gusti Allah. Mulané para rasul mau terus ngongkon rasul Pétrus lan Yohanes budal nang kuta Samaria. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kadung rasul Pétrus lan Yohanes teka nang kono terus pada ndongakké wong-wong sing wis dibaptis, supaya pada nampa Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Wong-wong iki durung ènèng siji waé sing dikwasani karo Roh Sutyi, awit namung dibaptis ing jenengé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Rasul Pétrus lan Yohanes terus numpangi tangan marang wong-wong mau terus didongakké. Kabèh terus dikwasani karo Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon weruh wong-wong dikwasani Roh Sutyi sak barengé ditumpangi tangan karo para rasul mau. Mulané dèkné terus nawani duwit marang rasul Pétrus lan Yohanes. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Simon ngomong: “Mbok aku dikèki pangwasa kuwi ta, supaya saben wong sing tak tumpangi tangan bisa nampa Roh Sutyi.” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nanging rasul Pétrus semaur: “Muga-muga rusaka kowé lan duwitmu, awit kowé mikir nèk pawèhé Gusti Allah kenèng mbok tuku karo duwit! ");
INSERT INTO jvnNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kowé ora mèlu apa-apa blas ing penggawéan iki, awit atimu ora resik nang ngarepé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mulané, mbalika sangka klakuanmu sing ala kuwi lan njaluka ngapura marang Gusti Allah enggonmu nduwèni pikiran sing kesasar kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Aku ngerti nèk atimu ijik kebek ala lan kowé ijik dikwasani karo dosa!” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon terus nyuwun marang rasul Pétrus lan Yohanes: “Mbok aku didongakké marang Gusti Allah, supaya aja nganti klakon sing mbok omong kuwi!” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Sakwisé ngekèki paseksi bab Gusti Yésus lan nggelarké kabar kabungahan nang kono, rasul Pétrus lan Yohanes terus balik menèh nang kuta Yérusalèm. Mulihé rasul Pétrus lan Yohanes mampir nang désa-désa nang bawah Samaria kono karo nggelarké kabar kabungahané Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ing sakwijiné dina mulékaté Gusti Allah ngomong marang Filipus: “Filipus, kowé kana tata-tata lan mengko soré budala nang dalan sing medun sangka Yérusalèm nang Gaza.” Kuwi dalané wustèn. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipus tata-tata terus budal. Ndilalahé terus kepetuk wong Etiopi, sing jaga palès lan ngurus bandané ratu Kandaké nang negara Etiopi. Wong iki entas sangka nyembah Gusti Allah nang Yérusalèm lan saiki balik mulih. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ing waktu kuwi wongé ijik numpak kréta karo matya sangka kitabé nabi Yésaya. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Filipus terus diomongi karo Roh Sutyi: “Kana nyedeki krétané.” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipus terus gelis-gelis nyedeki krétané lan krungu wongé matya kitabé nabi Yésaya. Filipus terus takon marang wongé: “Sedulur, apa kowé dunung sing mbok watya kuwi?” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wongé semaur: “Lah kepriyé aku bisané dunung nèk ora ènèng sing ndunung-ndunungké marang aku?” Wong mau terus nyuwun marang Filipus mlebu nang krétané lan njagong nang jèjèré. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ayat sing diwatya karo wongé mau uniné ngéné: “Dèkné kaya wedus sing arep dibelèh kaé lan kaya tyempé sing ora nyuwara nang ngarepé wong sing motongi wuluné. Mengkono Dèkné ora ngetokké swara blas. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dèkné diasorké lan ora dikèki bener blas. Sapa sing bisa ngomongké bab turunané, awit nyawané dijikuk sangka bumi.” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wong Etiopi mau terus takon marang Filipus: “Aku kepéngin ngerti, sing diomong karo nabi Yésaya iki sapa ta? Apa nabi Yésaya ngomongké bab dèkné déwé apa ngomongké bab wong liyané?” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Sangka ayat kuwi Filipus terus nggelarké kabar kabungahan bab Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Sak barengé neruské lakuné terus tekan panggonan sing ènèng banyuné. Wong Etiopi mau terus takon: “Lah iku ènèng banyu! Lah aku éntuk dibaptis apa ora?” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipus semaur: “Entuk, janji kowé pretyaya sak atimu!” Wongé semaur: “Aku pretyaya nèk Gusti Yésus kuwi Anaké Gusti Allah!” ");
INSERT INTO jvnNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Krétané terus kongkon mandek. Filipus lan wongé terus medun nang banyu. Filipus terus mbaptis wongé. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sakwisé mentas Filipus terus dijikuk karo Roh Sutyi lan wong Etiopi mau wis ora weruh dèkné menèh. Wongé neruské lakuné karo bungah. ");
INSERT INTO jvnNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ngerti-ngerti Filipus wis nang kuta Asdod. Dèkné ndlajahi kuta-kuta nang bawah kono nggelarké kabar kabungahané Gusti Yésus nganti tekan kuta Sésaréa. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulus ijik kaya wong sétanen nggolèki murid-muridé Gusti Yésus arep dipatèni. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Mulané dèkné terus nang nggoné Imam Gedé njaluk layang pangwasa sing arep diduduhké marang pengarepé sinaguk-sinaguk nang kuta Damaskus. Dadiné nèk nang kuta kuwi ènèng wong sing mèlu “Golongan Anyar,” yakuwi dalané Gusti Yésus, Saulus bisa nyekel wong-wong mau digawa nang Yérusalèm, ora perduli lanang apa wédok. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulus terus budal nang kuta Damaskus. Lah nang dalan, wis tyedek karo kutané, kok dadakan ènèng padang semlorot sangka langit nyloroti Saulus. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulus tiba terus krungu swara ngomong: “Saulus, Saulus! Kenèng apa kowé kok nyiya-nyiya Aku!” ");
INSERT INTO jvnNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","6","Saulus terus takon: “Kowé kuwi sapa Gusti?” Swara mau semaur: “Aku iki Yésus sing mbok siya-siya. Saiki ngadeka! Kana mlebu nang kutané lan nang kana kowé bakal diomongi apa sing kudu mbok lakoni.” ");
INSERT INTO jvnNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kantya-kantyané Saulus pada mandek, kabèh kagèt ora bisa ngomong apa-apa. Wong-wong iki mèlu krungu swarané, nanging ora weruh apa-apa. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulus terus ngadek, nanging kadung melèk dèkné ora bisa weruh apa-apa. Dèkné terus dituntun mlebu nang kuta Damaskus. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Telung dina suwéné Saulus ora bisa weruh, dèkné ora mangan lan ora ngombé. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nang Damaskus kono ènèng muridé Gusti Yésus sing jenengé Ananias. Gusti Yésus ngomong marang Ananias: “Ananias!” Dèkné semaur: “Kula Gusti!” ");
INSERT INTO jvnNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Gusti Yésus terus ngomong: “Kana tata-tata lan budal nang dalan sing jenengé ‘Lempeng’. Mlebua nang omahé Yudas. Nang kono ènèng wong sangka kuta Tarsus sing jenengé Saulus. Wongé ijik ndonga. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nang njeroné impèn Saulus weruh kowé teka numpangi tangan lan ndongakké dèkné supaya bisa weruh menèh!” ");
INSERT INTO jvnNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nanging Ananias semaur: “Gusti, aku krungu sangka wong pirang-pirang nèk Saulus iki nyiya-nyiya wong-wong sing nurut Gusti nang Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Dèkné teka nang Damaskus kéné malah nggawa layang pangwasa sangka penggedéné imam-imam, arep nyekeli kabèh wong sing nyebut jenengé Gusti!” ");
INSERT INTO jvnNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Gusti Yésus ngomong marang Ananias: “Kana budala, awit Aku wis milih Saulus iki dadi gamanku kanggo ngabarké jenengku marang bangsa-bangsa sing dudu Ju lan marang para ratu lan uga bangsa Israèl. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aku déwé bakal nduduhké marang Saulus, nèk dèkné bakal nglakoni kasangsaran okèh jalaran nglabuhi Aku.” ");
INSERT INTO jvnNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananias terus budal lan mlebu omah sing diinepi Saulus. Ananias terus numpangi tangan Saulus karo ngomong: “Saulus sedulurku, Gusti Yésus sing wis ngétok marang kowé nang dalan dongé kowé mlaku réné, Dèkné sing ngongkon aku marani kowé, supaya kowé bisa weruh menèh lan dikwasani karo Roh Sutyi.” ");
INSERT INTO jvnNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sakwat terus kaya ènèng sisik iwak tiba sangka mripaté Saulus lan dèkné bisa weruh menèh. Saulus terus ngadek lan dibaptis. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sakwisé mangan dèkné awaké terus kuwat menèh. Sakwisé kuwi Saulus terus nginep nang nggoné murid-muridé Gusti Yésus sedina-rongdina menèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dèkné terus ngabarké bab Gusti Yésus nang sinaguk-sinaguk, ngomongké nèk Gusti Yésus kuwi Anaké Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wong-wong sing krungu Saulus ngomong ngono kuwi pada nggumun kabèh. Wong-wong pada takon marang sakpada-pada: “Apa iki dudu Saulus kaé sing matèni saben wong nang kuta Yérusalèm sing nyebut jenengé Gusti Yésus? Dèkné tekané réné lak arep nyekel murid-muridé Gusti Yésus ta, arep digawa nang nggoné penggedéné para imam?” ");
INSERT INTO jvnNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nanging Saulus enggoné ngabarké malah selot keras. Dèkné njlèntrèk-njlèntrèkké tandané nèk Gusti Yésus kuwi pantyèn nyata tenan sing ngluwari manungsa sangka pangwasané pepeteng. Lan Saulus sing ndunung-ndunungké kuwi jan tyeta banget, sampèk wong Ju sing nang kono ora bisa mbantah blas. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ora let suwi wong Ju nang Damaskus terus pada ngumpul arep ngrembuk kepriyé enggoné arep matèni Saulus. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nanging Saulus ngerti kekarepané wong-wong mau. Awan-wengi wong-wong pada njaga lawang-lawangé kuta arep matèni Saulus. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nanging ing sakwijiné wengi murid-muridé Gusti Yésus ngetokké Saulus nganggo kranjang, diedunké sangka témboké kuta. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulus terus lunga nang kuta Yérusalèm arep ngumpul karo murid-muridé Gusti Yésus sing nang kono. Nanging murid-murid mau ora pada ngandel nèk Saulus kuwi wis dadi muridé Gusti Yésus tenan. Wong-wong pada wedi. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nanging Barnabas gelem nampa dèkné, mulané Saulus terus dieterké nang nggoné para rasul. Para rasul diomongi nèk Gusti Yésus ngétok marang Saulus nang dalan lan Gusti Yésus wis ngetokké tembung marang dèkné. Barnabas uga ngomong nèk Saulus wis nggelarké kabar kabungahan karo kendel nganggo jenengé Gusti Yésus nang kuta Damaskus. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saulus terus manggon bebarengan karo para rasul nang Yérusalèm. Mlebu-metu dèkné ora ènèng sing ngalang-alangi lan dèkné nggelarké kabar kabungahané Gusti Yésus karo kendel. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saulus uga rembukan lan bantah-bantahan karo wong Ju sing ngomong Grik. Nanging wong-wong iki pada ngarah arep matèni dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nanging kadung sedulur-sedulur ing pretyaya krungu bab iki, Saulus terus dieterké nang kuta Sésaréa lan sangka kono Saulus dikongkon nang kuta Tarsus. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pasamuan-pasamuan nang Yudéa lan Galiléa lan uga nang Samaria saiki pada ngalami katentreman kabèh. Pasamuan-pasamuan mau pada mundak kuwat ing pengandel lan wong-wong sing nurut Gusti ya tambah okèh, jalaran sangka pitulungané Roh Sutyi lan jalaran wong-wong pada manut marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ing wayah kuwi rasul Pétrus ndlajahi werna-werna panggonan. Ing sakwijiné dina dèkné niliki sedulur-sedulur sing nurut Gusti nang kuta Lida. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nang kuta Lida kono rasul Pétrus ketemu karo wong sing jenengé Enéas. Enéas kuwi lumpuh lan wis wolung taun nang ambèn. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Rasul Pétrus terus ngomong marang Enéas: “Enéas, Gusti Yésus Kristus nambani kowé! Tangia lan ambènmu tatanen déwé!” Sakwat Enéas tangi. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kabèh wong nang kuta Lida lan nang bawah Saron pada pretyaya marang Gusti Yésus, awit weruh Enéas. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nang kuta Yopé ènèng sakwijiné wong pretyaya, wong wédok sing jenengé Tabita. Nèk tyara Grik jenengé Dorkas, tegesé Kidang. Dorkas iki okèh banget penggawéné betyik lan seneng pawèh marang liyané. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nanging ing wayah kuwi Dorkas lara terus ninggal. Sakwisé layoné diadusi terus disèlèhké nang kamar nduwur. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kuta Yopé kuwi ora adoh sangka kuta Lida. Kadung murid-muridé Gusti Yésus krungu nèk rasul Pétrus nang kuta Lida, terus pada kongkonan wong loro marani Pétrus, disuwun ndang gelis teka nang kuta Yopé. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Sakwisé rasul Pétrus krungu kabaré, dèkné terus tata-tata lan budal bareng karo wong loro mau. Tekan omahé Dorkas rasul Pétrus terus digawa munggah nang kamar nduwur. Randa-randa kabèh sing nang kono pada ngrubung layoné karo nangis lan nduduhké marang rasul Pétrus sandangan lan salin gawéané Dorkas kanggo randa-randa mau dongé dèkné ijik urip. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Wong-wong mau terus dikongkon metu kabèh karo rasul Pétrus, dèkné terus sedeku lan ndonga. Sakwisé kuwi rasul Pétrus terus nyedeki layoné Dorkas ngomong: “Tabita, tangia!” Dorkas terus melèk. Kadung weruh rasul Pétrus dèkné terus tangi. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Rasul Pétrus nyekel tangané Dorkas diréwangi ngadek. Sakwisé kuwi sedulur-sedulur sing pretyaya lan randa-randa mau terus dityeluk karo rasul Pétrus. Dorkas, sing saiki wis urip, terus dipasrahké marang wong-wong mau. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kabar bab Dorkas kuwi terus mrèmèn-mrèmèn nang sak kuta Yopé lan okèh wong terus pada pretyaya marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Rasul Pétrus terus nginep sedina-rongdina menèh nang Yopé kono nang omahé sakwijiné Simon, tukang lulang. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nang kuta Sésaréa ènèng wong jenengé Kornélius. Kornélius kuwi kumendané bagèan militèr sing diarani “Bagèan Itali.” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornélius kuwi sakwijiné wong sing pretyaya marang Gusti Allah. Dèkné déwé lan brayaté kabèh pada ngabekti marang Gusti Allah. Dèkné ya ora tau éman ngulungi wong Ju sing ora nduwé lan ing pandonga marang Gusti Allah dèkné ya temen tenan. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ing sakwijiné dina, kira-kira jam telu soré, dongé ijik ndedonga, dèkné nampa weweruh sangka Gusti Allah. Ing weweruh kuwi Kornélius weruh mulékaté Gusti Allah mlebu terus nyeluk dèkné: “Kornélius!” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornélius nyawang mulékaté karo wedi terus semaur: “Kula Gusti!” Mulékaté mau terus ngomong: “Pandongamu wis ketampa lan pawèhmu marang wong sing ora nduwé uga wis nggatèkké karo Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kana saiki ngongkon wong siji-loro budal nang kuta Yopé dikongkon nggolèki sakwijiné wong sing jenengé Simon Pétrus. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simon Pétrus iki nginep nang omahé wong tukang lulang sing jenengé uga Simon. Dèkné manggon nang pinggir laut.” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kadung mulékaté wis lunga Kornélius terus nyeluk peladèné loro lan uga soldat siji sing pretyaya marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornélius terus ngomongké bab lelakon kuwi mau terus ngongkon wong-wong kuwi budal nang kuta Yopé. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ing liyané dina rasul Pétrus munggah nang nduwur omah arep ndonga. Ing waktu kuwi wong-wong kongkonané Kornélius wis arep tekan kuta Yopé. Kuwi kira-kira wis jam rolas awan. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Rasul Pétrus wis krasa ngelih lan kepéngin mangan. Lah dongé méjané ijik ditata, dèkné terus éntuk weweruh sangka Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ing sakjeroné weweruh kuwi rasul Pétrus weruh langité menga terus ènèng kaya lèmèk amba medun. Lèmèk iki pojokané kabèh papat ditalèni terus dilorot medun nang bumi. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ing njeroné lèmèk kuwi ènèng sak wernané kéwan, kayadéné kéwan sing sikilé papat, kéwan sing mbrangkang lan manuk. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Terus ènèng swara ngomong: “Pétrus, kana kuwi dibelèh lan dipangan!” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nanging rasul Pétrus semaur: “Ora Gusti, ora pisan-pisan! Aku durung tau mangan pangan sing ora apik lan ora éntuk dipangan.” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nanging swara mau terus ngomong menèh marang rasul Pétrus: “Barang sing dianggep apik lan kenèng dipangan karo Gusti Allah aja mbok tampik!” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lelakon iki dibalèni sampèk ping telu. Lèmèké terus diunggahké menèh nang langit. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Rasul Pétrus mikir apa tegesé weweruh mau. Lah ing waktu kuwi wong-wong kongkonané kumendan Kornélius wis pada teka nang ngarep lawang, sakwisé takon-takon omahé rasul Pétrus. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wong-wong terus takon: “Apa nang omah iki ènèng wong sing jenengé Simon Pétrus?” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Rasul Pétrus ijik mikirké tegesé weweruh mau, mulané Roh Sutyi terus ngomong marang dèkné: “Pétrus, ènèng wong telu nggolèki kowé. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ndang medun lan aja wedi mèlu wong-wong kuwi, awit Aku sing ngongkon wong-wong kuwi mbréné.” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Rasul Pétrus terus medun lan ngomong marang wong-wong mau: “Ya aku iki wong sing mbok golèki. Enggonmu pada mbréné ènèng perluné apa?” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wong-wong semaur: “Awaké déwé teka mbréné iki dikongkon karo kumendan Kornélius. Dèkné kuwi wong apik sing ngabekti marang Gusti Allah lan dèkné ya diajèni tenan karo bangsa Ju. Kumendan Kornélius dikétoki karo mulékaté Gusti Allah lan diomongi kongkon nyuwun kowé teka nang omahé, supaya bisa krungu apa sing arep mbok omong.” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Wong-wong mau terus dikongkon nginep nang kono karo rasul Pétrus. Esuké rasul Pétrus terus budal mèlu wong-wong sing dikongkon marani dèkné. Enèng sedulur siji-loro sangka kuta Yopé kono uga mèlu. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Liyané dina rasul Pétrus wis tekan kuta Sésaréa. Kornélius wis ngentèni lan anak-seduluré lan kantya-kantyané wis dilumpukké kabèh nang omahé. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kadung rasul Pétrus mlebu Kornélius terus metuk dèkné, terus sedeku nang ngarepé lan ngurmat dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nanging Kornélius dikongkon ngadek karo rasul Pétrus: “Kornélius, ngadeka, awit aku iki ya namung manungsa kaya kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Sakwisé kuwi rasul Pétrus terus mèlu mlebu omah karo omong-omongan. Nang kono wong pirang-pirang wis pada ngumpul. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Rasul Pétrus terus ngomong: “Para sedulur, kowé pada ngerti déwé nèk wong Ju kuwi ora éntuk tyampur karo wong sing dudu Ju apa mlebu omahé. Nanging Gusti Allah wis ndunungké marang aku nèk aku ora kenèng ngarani wong ala apa ora apik. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mulané, sakwisé aku dityeluk kongkon mbréné, aku ya ora kepriyé-priyé, nanging terus teka. Lah saiki aku arep takon marang kowé, kenèng apa aku kok mbok kongkon teka mbréné?” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","32","Kornélius terus semaur: “Telung dina kepungkur, dongé aku ijik ndedonga, kira-kira jam telu soré, kok dadakan ènèng wong ngadek nang ngarepku nganggo salin putih sumeblak. Wongé ngomong: ‘Kornélius, Gusti Allah wis nampa pandongamu lan pawèhmu marang wong ora nduwé Dèkné ya nggatèkké. Kana ngongkon wong budal nang kuta Yopé nggolèki wong sing jenengé Simon Pétrus, sing nginep nang nggoné Simon tukang lulang, sing omahé nang pinggir laut.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mulané aku ya terus kongkonan marani kowé lan maturkesuwun banget kowé saiki wis teka. Saiki awaké déwé wis ngumpul nang kéné nang ngarepé Gusti Allah, awaké déwé kepéngin ngrungokké tembungé Gusti marang kowé kanggo awaké déwé kabèh.” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Rasul Pétrus terus ngomong ngéné: “Saiki aku ngerti tenan nèk Gusti Allah ora mbédak-mbédakké manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dèkné nampa saben wong sing pretyaya marang Dèkné lan sing nuruti kekarepané Dèkné, ora perduli bangsa apa. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gusti Allah wis ngedunké pitutur marang bangsa Israèl, sing ngabarké bab katentreman lantaran Gusti Yésus Kristus, Gustiné kabèh manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kowé kabèh wis ngerti bab sing wis klakon kabèh nang Yudéa, molai nang Galiléa, sakwisé Yohanes Pembaptis ngundangi wong-wong supaya dibaptis. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kowé kabèh wis ngerti nèk Gusti Yésus sangka Nasarèt sing dikèki Roh Sutyi lan pangwasa karo Gusti Allah. Dèkné terus budal nang endi-endi nulungi kabèh wong lan nambani sing dikwasani sétan, awit Gusti Allah mberkahi Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Aku déwé lan kantya-kantyaku kabèh weruh sembarang sing ditindakké karo Gusti Yésus nang negarané wong Ju lan nang kuta Yérusalèm. Senajan ngono, wong Ju malah matèni Gusti Yésus nang kayu pentèngan. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nanging Gusti Allah nangèké Dèkné sangka pati ing telung dinané lan Gusti Allah ngétokké Dèkné marang wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ya ora dikétokké marang kabèh wong, nanging namung marang awaké déwé sing wis dipilih karo Gusti Allah, supaya weruh déwé lan dadi seksiné. Ya awaké déwé iki sing mangan lan ngombé bebarengan karo Gusti Yésus, sakwisé Dèkné tangi sangka pati. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Gusti Yésus ngongkon awaké déwé sing dadi seksi, supaya ngabarké marang manungsa nèk Dèkné sing dipilih karo Gusti Allah dadi rèkteré manungsa sing ijik urip lan sing wis mati. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nabi-nabi kabèh wis ngomongké nèk saben wong sing pretyaya marang Gusti Yésus nampa pangapura sangka dosa-dosané, awit Dèkné nduwèni kwasa!” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Dongé rasul Pétrus ijik ngomongké kuwi mau kabèh, dadakan waé Roh Sutyi medun terus ngwasani wong-wong sing pada ngrungokké tembungé. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wong-wong Ju sing pretyaya sing teka karo rasul Pétrus pada nggumun kabèh. Nggumuné kuwi, Gusti Allah kok uga ngedunké Roh Sutyi marang wong-wong sing dudu Ju. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Wong-wong Ju kuwi krungu wong-wong sing dikwasani karo Roh Sutyi pada ngetokké basa anèh lan pada memuji kwasané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Rasul Pétrus terus ngomong: “Delokké déwé, wong-wong kuwi pada nampa Roh Sutyi, pada waé karo awaké déwé. Apa ènèng wong sing bisa ngalang-alangi wong-wong iki dibaptis karo banyu?” ");
INSERT INTO jvnNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Rasul Pétrus terus ngongkon wong-wong sing dikwasani karo Roh Sutyi kuwi supaya dibaptis ing jenengé Gusti Yésus Kristus. Sakwisé kuwi wong-wong pada nyuwun marang rasul Pétrus supaya nginep sedina-rongdina menèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Para rasul lan para sedulur sing nang Yudéa pada krungu nèk wong sing dudu Ju uga pada nampa pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kadung rasul Pétrus teka nang kuta Yérusalèm, dèkné dipaiduh karo wong-wong Ju sing pretyaya. Pinemuné wong-wong iki, wong sing dudu Ju sing mlebu dadi wargané pasamuané Gusti Yésus kudu nglakoni sunat. Wong-wong iki ngomong ngéné marang rasul Pétrus: ");
INSERT INTO jvnNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Kenèng apa kowé kok nginep nang omahé wong sing ora sunat, malah mangan bebarengan karo wong-wong kuwi mbarang? Kuwi lak ora apik ta?” ");
INSERT INTO jvnNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mulané rasul Pétrus terus ngekèki laporan bab prekara-prekara sing wis klakon kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","7","Dèkné molai ngéné: “Dongé aku nang kuta Yopé, wayahé aku ijik ndedonga, kok aku nampa weweruh. Aku weruh kaya ènèng lèmèk amba sing pojokané papat ditalèni. Lèmèk mau diedunké sangka langit terus mandek nang ngarepku. Kadung tak ematké aku weruh nang njeroné lèmèk kuwi ènèng kéwan-kéwan sing sikilé papat, kéwan-kéwan galak lan kéwan-kéwan sing mbrangkang lan uga ènèng manuk-manuk. Aku terus krungu swara ngomong marang aku ngéné: ‘Pétrus, ngadeka, belèhana lan panganen!’ ");
INSERT INTO jvnNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nanging aku terus semaur: ‘Ora Gusti, ora! Aku durung tau mangan pangan sing ora apik lan ora éntuk dipangan!’ ");
INSERT INTO jvnNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Swara sangka langit mau terus ngomong: ‘Barang sing dianggep apik lan kenèng dipangan karo Gusti Allah aja mbok tampik!’ ");
INSERT INTO jvnNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Prekara iki sampèk klakon ping telu. Sakwisé kuwi lèmèké lan sak isiné diangkat munggah menèh nang langit. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ing waktu kuwi ènèng wong lanang telu teka nang omah sing tak inepi. Wong telu kuwi kongkonan sangka kuta Sésaréa, kongkon nggolèki aku. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Roh Sutyi ngomong marang aku penging wedi, aku kenèng mèlu wong-wong kuwi budal nang kuta Sésaréa. Sangka kuta Yopé kono ènèng sedulur nenem sing mèlu aku nang kuta Sésaréa. Awaké déwé terus nang nggoné kumendan Kornélius. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","14","Sak tekané awaké déwé Kornélius ya terus ngomong marang awaké déwé nèk dèkné ditekani mulékat nang omahé. Mulékaté ngomong ngéné marang dèkné: ‘Kornélius, kana ngongkon wong budal nang kuta Yopé nggolèki wong sing jenengé Simon Pétrus. Pétrus bakal ngomongi kowé kepriyé kowé sak brayatmu bisané slamet.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","16","Nang omahé Kornélius kono aku entas molai ngomong, kok terus dadakan waé Roh Sutyi medun marang wong-wong, tunggalé kaya sing dialami awaké déwé kaé ndisik-ndisiké. Aku terus kélingan marang tembungé Gusti Yésus, dongé Dèkné ngomong ngéné: ‘Yohanes mbaptis karo banyu, nanging kowé bakal dibaptis nganggo Roh Sutyi!’ ");
INSERT INTO jvnNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dadiné saiki tyeta tenan nèk Gusti Allah déwé wis ngekèki pawèh marang wong-wong sing dudu Ju, tunggalé waé karo pawèh sing ditampa karo awaké déwé, dongé awaké déwé pretyaya marang Gusti Yésus Kristus. Lah aku iki sapa ta, kok wani ngalang-alangi Gusti Allah?” ");
INSERT INTO jvnNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Sakwisé krungu tembungé rasul Pétrus kuwi mau, wong-wong terus ora pada maido dèkné menèh, malah terus pada memuji marang Gusti Allah ngomong: “Nèk ngono Gusti Allah uga ngekèki kelunggaran marang wong-wong liya bangsa, supaya pada ninggal laku sing ala lan molai urip sing anyar.” ");
INSERT INTO jvnNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Wong-wong sing pretyaya terus pada buyar, jalaran pada diusir lan dipilara, sakwisé Stéfanus dipatèni. Wong-wong pada buyar sampèk tekan bawah Fenisia, tekan pula Siprus lan uga tekan kuta Antioki. Wong-wong sing pretyaya sing pada buyar kuwi pada nggelarké kabar kabungahané Gusti Yésus Kristus nang panggonan-panggonan sing anyar, nanging namung marang wong Ju. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nanging uga ènèng wong pretyaya sing pada teka nang pula Siprus lan kuta Siréné, terus sangka kono lunga nang kuta Antioki. Nang Antioki kono wong-wong terus nggelarké kabar kabungahan marang wong-wong bangsa liya, kabar kabungahan bab Gusti Yésus Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Pangwasané Gusti Yésus ngréwangi wong-wong pretyaya kuwi, mulané wong pirang-pirang terus pada pretyaya lan masrahké uripé marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kadung sedulur-sedulur nang pasamuan nang Yérusalèm krungu kabar bab lelakon nang pasamuan nang Antioki, terus pada ngongkon sedulur Barnabas rana. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Sak tekané nang kono Barnabas weruh wong-wong pretyaya sing nang kono pada diberkahi karo Gusti Allah. Barnabas bungah banget lan nyuwun marang sedulur-sedulur mau, supaya pada mantep lan temen terus nurut Gusti sak atiné. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas kuwi wong apik sing kebek karo Roh Sutyi lan pengandel. Okèh wong pada pretyaya marang Gusti Yésus, jalaran sangka piwulangé Barnabas. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Sakwisé kuwi Barnabas terus lunga nang kuta Tarsus, nggolèki sedulur Saulus. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kadung wis ketemu, Saulus terus diejèk nang kuta Antioki. Barnabas lan Saulus mulangi wong okèh nang pasamuan nang Antioki kono, nganti setaun suwéné. Ya nang Antioki kono wong-wong sing nurut Gusti Yésus Kristus molai dityeluk wong Kristen. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ing waktu kuwi terus ènèng nabi siji-loro sangka Yérusalèm teka nang Antioki. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Enèng siji, jenengé Akabus, nampa kaweruh sangka Roh Sutyi terus ngomong nèk bakal ènèng kekurangan pangan gedé nekani sak bumi. (Lan iki ya pantyèn klakon tenan dongé Klaudius dadi ratu.) ");
INSERT INTO jvnNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mulané para sedulur Kristen nang kuta Antioki terus molai nglumpukké urunan kanggo sedulur-sedulur Kristen sing nang Yudéa. Saben wong kudu nguruni sak bisané. ");
INSERT INTO jvnNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kadung wis rampung enggoné nglumpukké urunané, sedulur-sedulur terus ngongkon Barnabas lan Saulus ngeterké duwité marang para penuntuné pasamuan nang Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ing waktu kuwi ratu Hérodès molai ngongkon nyekeli wong pasamuan. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Dèkné ngongkon nyekel rasul Yakobus, kakangé rasul Yohanes. Yakobus terus diketok guluné. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kadung ratu Hérodès weruh nèk kuwi ndadèkké senengé wong Ju, dèkné terus ngongkon nyekel rasul Pétrus mbarang. Kuwi tiba wayahé riyaya Roti tanpa Ragi. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Rasul Pétrus dityekel terus dilebokké nang setrapan. Sing dikongkon njaga rasul Pétrus soldat patang syif, sak syif soldaté papat. Karepé ratu Hérodès rasul Pétrus arep dikrutu nang ngarepé wong pirang-pirang, sakwisé riyaya Paskah. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Suwéné rasul Pétrus nang setrapan sedulur-sedulur sak pasamuan pada ndonga tanpa mandek marang Gusti Allah kanggo dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ing wengi sakdurungé digawa nang ngarepé ratu Hérodès, rasul Pétrus turu, tangané diranté gandèng karo soldat loro nang kiwa lan tengené. Lawangé setrapané mbarang dijaga soldat. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Terus dadakan waé mulékaté Gusti ngadek nang sèl kono, semlorot madangi sèlé. Mulékaté terus nggugah rasul Pétrus: “Ndang tangi!” Sakwat ranténé utyul sangka tangané. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mulékaté terus ngomong: “Sabukmu lan sepatumu ndang dienggo!” Rasul Pétrus ya manut apa omongé mulékaté. “Salinmu njaba dienggo lan hayuk mèlu aku.” ");
INSERT INTO jvnNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Rasul Pétrus terus ngetutké mulékaté metu sangka setrapan, nanging dèkné ora ngerti mulékaté kuwi ènèng tenan apa ora. Mikiré dèkné kuwi ngimpi. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Sampèk ngliwati tukang jaga sing sepisan, terus ngliwati tukang jaga sing nomer loro, terus tekan lawang wesi, dalané metu nang dalan gedé sing njujuk nang kuta. Lawang wesi mau menga déwé, mulékaté lan rasul Pétrus terus metu. Kadung wis tekan njaba, mulékaté terus mlaku sak dalan karo rasul Pétrus, terus ngilang. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Rasul Pétrus terus dunung tenan, mulané ngomong: “Saiki aku ngerti nèk Gusti wis ngongkon mulékaté ngluwari aku sangka pangwasané ratu Hérodès lan sangka kekarepané wong Ju.” ");
INSERT INTO jvnNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sakwisé dunung lelakon mau, rasul Pétrus terus budal nang omahé Maria, ibuné Yohanes, sing uga ketyeluk Markus. Nang omah kono ènèng wong okèh sing ijik pada ngumpul lan ndedonga. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Rasul Pétrus terus totok-totok nang lawang njaba. Botyah wédok, peladèné, sing jenengé Rodé terus niliki sapa sing totok-totok lawang. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Rodé ora pangling karo swarané rasul Pétrus, nanging sangking bungahé ora mbukakké lawangé, malah balik mlebu menèh ngomongi sedulur-sedulur liyané nèk rasul Pétrus nang ngarep lawang. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wong-wong mau semaur: “Kowé kuwi gendeng apa kepriyé?” Nanging Rodé ngetyek terus: “Pantyèn rasul Pétrus tenan, aku ora goroh! Dèkné tenan!” Liyané terus semaur: “O, menawa kuwi mulékat sing ngantyani rasul Pétrus!” ");
INSERT INTO jvnNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nanging rasul Pétrus totok-totok lawangé terus. Wong-wong terus mbukak lawangé. Kadung weruh rasul Pétrus, terus pada kagèt tenan. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Rasul Pétrus terus karo tangané ngongkon wong-wong kongkon pada meneng. Dèkné terus nyritakké enggoné Gusti ngetokké dèkné sangka setrapan. Rasul Pétrus terus ngomong: “Kana sedulur Yakobus lan sedulur-sedulur liyané pada diomongi!” Dèkné terus lunga sangka kono budal nang liya panggonan. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ing ésuké para soldat sing jaga setrapan pada gègèran, pada bingung jalaran ora ngerti rasul Pétrus nang endi. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ratu Hérodès terus mréntah kongkon nggolèki, nanging rasul Pétrus ora ketemu. Sing jaga setrapan terus dityeluk lan ditakoni lan sakwisé kuwi dipatèni. Ratu Hérodès terus lunga sangka Yudéa budal nang kuta Sésaréa lan manggon nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Dongé ratu Hérodès nang kuta Sésaréa kono, wong-wong sangka kuta Tirus lan kuta Sidon bebarengan pada kongkonan délegasi nang nggoné ratuné. Awit, ya embuh apa jalarané, wong-wong sing manggon nang kuta Tirus lan Sidon pada marakké ratu Hérodès nesu banget. Nanging, jalaran kuta Tirus lan Sidon kuwi pangané tekané sangka nggoné ratu Hérodès, mulané terus délegasiné ngglenik Blastus, sèkrètarisé Hérodès, kongkon nembungké ratuné nyuwun kawelasan lan bisa rukun menèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ing sakwijiné dina sing wis dirantyam sakdurungé, Hérodès nganggo penganggoné ratu terus njagong nang damparé karo ngetokké tembung marang wong-wong. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ing sak tengahé ngetokké tembung kuwi wong-wong pada surak-surak ngomong: “Kuwi dudu manungsa sing ngomong, nanging sakwijiné gusti allah!” ");
INSERT INTO jvnNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Sakwat mulékaté Gusti Allah ngantem ratu Hérodès, awit dèkné nampa pengalemané manungsa. Kuduné pengaleman kuwi dipasrahké marang Gusti Allah. Ratu Hérodès terus ngglétak dipangan tyatying terus mati. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pituturé Gusti terus mrèmèn-mrèmèn terus lan wong pirang-pirang pada pretyaya marang Gusti Yésus Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Sakwisé Barnabas lan Saulus masrahké duwit urunan marang para penuntun nang pasamuan nang Yérusalèm, terus pada balik menèh nang kuta Antioki, nanging ngejèk Yohanes Markus mbarang. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nang pasamuan nang kuta Antioki kono ènèng nabi-nabi lan guru-guru kayadéné Barnabas, Siméon, sing uga katyeluk Niger, Lusius sangka Kiréné, Manain lan Saulus. Manain kuwi tyilikané diemong bareng karo ratu Hérodès. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ing sakwijiné dina, dongé wong-wong iki pada ngumpul memuji Gusti lan pasa, Roh Sutyi ngomong: “Aku mbutuhké Barnabas lan Saulus kanggo penggawéan sing gedé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Wong-wong terus pasa lan ndonga terus lan sakwisé kuwi terus numpangi tangan ndongakké Barnabas lan Saulus, terus dikongkon budal. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas lan Saulus terus manut kongkonané Roh Sutyi budal nang kuta Selukia. Sangka kono terus numpak prau ngabrah nang pula Siprus. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kadung wis tekan kuta Salamis wong loro iki terus pada ngabarké pituturé Gusti Allah nang sinaguk-sinaguké wong Ju. Yohanes mbarang ya mèlu ngréwangi nang kono. Iki Yohanes sing uga katyeluk Markus. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wong-wong mau terus pada ndlajahi pula Siprus sampèk rata nganti tekan kuta Pafos. Nang kuta Pafos kono Barnabas lan Saulus kepetuk karo wong Ju sing jenengé Bar-Yésus. Bar-Yésus iki ngakuné nabi, nanging dèkné nganggokké pangwasa pepeteng. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bar-Yésus iki kantyané Sèrgius Paulus, gramangé pula kono, wong sing jeru kaweruhé. Gramang Sèrgius Paulus kongkonan nyeluk Barnabas lan Saulus, awit kepéngin krungu bab pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nanging Elimas, kuwi jenengé Bar-Yésus ing tembung Grik, ngalang-alangi supaya gramangé ora pretyaya marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulus, sing uga ketyeluk Paulus, mandeng wongé. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ing kwasané Roh Sutyi rasul Paulus terus ngomong: “Elimas, kowé kuwi pantyèn anaké Sétan. Atimu kebek karo pikiran sing ala, mulané kowé nglawan sembarang sing betyik. Senengmu namung malik piwulang-piwulangé Gusti sing bener. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Saiki tangané Gusti bakal nggebuk kowé lan kowé bakal lamur lan ora bakal weruh padangé srengéngé sak untara.” Sakwat Elimas mripaté lamur lan ora weruh apa-apa, terus tyemumak-tyemumuk nggolèk dalan lan njaluk dituntun. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gramangé weruh lelakon kuwi terus pretyaya marang Gusti Yésus. Dèkné nggumuné éram-éram bab piwulangé Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Rasul Paulus lan sak kantyané terus numpak prau lunga sangka kuta Pafos, budal nang kuta Pèrgi nang bawah Pamfili. Nanging Yohanes Markus ora gelem mèlu terus, malah balik nang Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Sangka kuta Pèrgi Barnabas lan rasul Paulus terus budal terus nang kuta Antioki nang bawah Pisidi. Ing dina sabat wong loro iki terus mèlu ngumpul nang sinaguk. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Sakwisé matya sangka wèt-wèté nabi Moses lan kitabé para nabi, para pinituwané sinaguk terus kongkonan takon marang rasul Paulus lan Barnabas, menawa nduwèni tembung kanggo mbangun wong-wong sing nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Rasul Paulus terus ngadek lan ngumbulké tangané, ngekèki ngerti nèk dèkné kepéngin ngetokké tembung. Rasul Paulus ngomong ngéné: “Para sedulur bangsa Israèl lan sedulur-sedulur liyané sing nyembah marang Gusti Allah nang panggonan kéné! Aku nyuwun pada ngrungokké sing arep tak omong iki. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Gusti Allah, ya Gusti Allahé bangsa Israèl, wis milih mbah-mbahané awaké déwé lan bangsa iki didadèkké bangsa sing gedé, dongé ijik manggon nang negara Egipte. Nganggo kwasa sing nggumunké Gusti Allah terus ngluwari bangsa iki sangka pangwasané negara Egipte. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Sakwisé kuwi terus patang puluh taun suwéné Gusti Allah nyabari wangkalé bangsa iki suwéné nang wustèn. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Gusti Allah wis nelukké bangsa pitu nang negara Kanaan lan negarané dikèkké marang bangsa Israèl kongkon ngenggoni, patang atus sèket taun suwéné. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Sakwisé kuwi terus dikèki penuntun-penuntun nganti jamané nabi Samuèl. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bangsa Israèl terus njaluk ratu. Gusti Allah terus ngekèki Saul, anaké Kis, dadi ratuné. Saul iki sangka turunané Bènyamin lan dèkné dadi ratu patang puluh taun suwéné. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nanging Saul terus diedunké karo Gusti Allah lan Daved sing didadèkké ratu. Bab Daved Gusti Allah ngomong ngéné: ‘Daved iki, anaké Isai, pantyèn wong sing tak senengi tenan. Dèkné bakal nuruti apa karepku.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Lan kaya sing wis dijanji karo Gusti Allah, turunané Daved, yakuwi Gusti Yésus, dadi Juru Slameté bangsa Israèl. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sakdurungé Gusti Yésus teka, Yohanes Pembaptis wis ngundangi wong Israèl kongkon pada ninggal klakuan ala lan molai urip anyar lan dibaptis. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Sakdurungé rampung kerjanané, Yohanes Pembaptis mau ngomong marang wong-wong: ‘Aku iki dudu Kristus sing mbok arep-arep, dudu. Nanging Dèkné bakal teka sak mburiku. Ngutyuli sepatuné Dèkné waé durung pantes aku.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Para sedulur turunané Bapa Abraham lan sedulur-sedulur kabèh sing nyembah marang Gusti Allah, kabar kabungahan iki wis digelarké marang awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Wong-wong nang kuta Yérusalèm lan para pinituwané ora pada ngerti nèk Gusti Yésus kuwi Juru Slameté. Wong-wong kuwi ora dunung tembungé para nabi, senajan tembungé para nabi mau saben kumpulan ing dina sabat diwatya. Wong-wong mau malah pada nyalahké Gusti Yésus lan mengkono kuwi malah pada nuruti tembungé para nabi. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Senajan ora nduwé jalaran blas kanggo nyetrap pati marang Gusti Yésus, nanging wong-wong kuwi meksa pada nyuwun marang gramang Pilatus supaya Gusti Yésus dipatèni. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sakwisé wong-wong mau nglakoni sembarang sing wis ketulis nang Kitab, layoné Gusti Yésus terus diedunké sangka kayu pentèngan lan disèlèhké nang kuburan. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nanging Gusti Allah nangèké Gusti Yésus sangka pati. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Gusti Yésus terus ngétok marang murid-muridé sing mauné mèlu Dèkné ndlajahi bawah Galiléa nganti tekan kuta Yérusalèm. Ya wong-wong iki sing saiki dadi seksiné Gusti Yésus marang bangsa Israèl. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Mulané para sedulur, awaké déwé teka mbréné iki nggawa kabar kabungahan iki marang kowé kabèh, yakuwi, apa sing wis dijanji karo Gusti Allah marang mbah-mbahané awaké déwé saiki wis keturutan, awit Gusti Yésus wis ditangèkké sangka pati. Nang kitab Masmur bab loro lak ketulis ngéné ta: ‘Kowé kuwi Anakku, ing dina iki Aku dadi Bapakmu!’ ");
INSERT INTO jvnNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Lan bab enggoné Gusti Allah nangèké Gusti Yésus sangka pati, supaya badané ora rusak, ketulis ngéné: ‘Aku bakal ngekèki berkah marang kowé sing wis tak janji marang Daved!’ ");
INSERT INTO jvnNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mulané nang kitab Masmur liyané ya ènèng tulisan sing uniné ngéné: ‘Gusti, Kowé ora bakal nglilani nèk badané peladènmu, sing manut marang Kowé, sampèk rusak.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Para sedulur, tembung-tembung sangka Kitab kuwi ora ngomongké bab ratu Daved, ora. Awit ratu Daved mati, sakwisé dèkné nuntun bangsané miturut kekarepané Gusti Allah. Dèkné terus kakubur tyampur karo mbah-mbahané lan badané wujuté ya rusak. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nanging badané Gusti Yésus, sing ditangèkké sangka pati karo Gusti Allah, ora rusak. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mulané kowé kudu ngerti para sedulur, ya Gusti Yésus iki sing marakké kowé bisa ngerti nèk dosa-dosamu bisa dingapura. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Sapa sing pretyaya marang Dèkné wis dingapura dosa-salahé kabèh lan bakal ketampa Gusti Allah. Nglakoni wèt-wèté nabi Moses ora bisa marakké dosa-salahé kabèh dingapura. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mulané pada sing ati-ati, supaya kowé aja sampèk ngalami kaya sing diomong karo para nabi, sing uniné ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Awas kowé, sing pada seneng nyepèlèkké marang Gusti Allah. Kowé bakal kagèt. Lungaa sangka ngarepku. Awit kowé ora bakal pretyaya marang penggawéan sing bakal tak tindakké saiki, senajana ènèng wong sing ndunungké marang kowé!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sakwisé metu sangka sinaguk mau wong-wong terus pada nyuwun marang rasul Paulus lan Barnabas teka menèh, supaya ing dina sabat mingguné ngarep neruské piwulangé mau. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sak rampungé kumpulan okèh wong Ju lan wong liyané sing mèlu agama Ju pada pretyaya marang piwulangé rasul Paulus lan Barnabas. Rasul Paulus lan Barnabas ngomongi wong-wong iki kanti tenanan, supaya pada temen terus enggoné urip njagakké marang kabetyikané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ing dina sabat minggu liyané mèh wong sak kuta kabèh pada teka nang sinaguk, kepéngin ngrungokké pituturé Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nanging para pengarepé agama Ju terus pada panas atiné weruh nèk wong okèh pada nggatèkké marang piwulangé rasul Paulus lan Barnabas. Wong-wong kuwi terus pada ngèlèk-èlèkké rasul Paulus nganggo tembung-tembung sing ora pantes blas. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Rasul Paulus lan Barnabas enggoné mulang malah mundak kendel lan ngomong ngéné: “Pantyèn awaké déwé kudu nggawa pituturé Gusti Allah marang kowé ndisik. Nanging malah mbok tampik lan kowé pada ngétokké nèk ora pantes nampa urip langgeng, mulané awaké déwé arep marani bangsa liyané, sing durung kenal marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Awit Gusti wis ngongkon awaké déwé, Dèkné ngomong ngéné: ‘Kowé wis tak dadèkké pepadang kanggo bangsa-bangsa sing ora kenal marang Gusti Allah, supaya kowé nggawa dalan keslametan marang kabèh manungsa nang sak jembaré jagat.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wong-wong sing dudu Ju pada bungah krungu tembungé rasul Paulus kuwi lan pada ngelem pituturé Gusti. Sing wis tata-tata kepéngin nampa urip langgeng terus pada masrahké uripé marang Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pituturé Gusti terus sumebar nang endi-endi, rata nang sak bawah kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nanging para pengarepé agama Ju ora seneng karo lelakon kuwi, mulané terus ngojok-ojoki para penggedéné kuta kono, uga wong wédok-wédok sing pada mèlu agama Ju lan sing diajèni karo wong-wong nang kono. Wong-wong iki terus pada nyiya-nyiya rasul Paulus lan Barnabas terus pada diusir kongkon pada lunga sangka panggonan kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Rasul Paulus lan Barnabas terus ngetok-etokké lemahé sangka sikilé nang ngarepé wong okèh kuwi, kanggo tanda nèk wis ora ngerti jawané, terus lunga nang kuta Ikonium. ");
INSERT INTO jvnNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nanging murid-muridé Gusti sing nang kuta Antioki kono pada bungah tenan lan pada kebek karo Roh Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Lelakoné rasul Paulus lan Barnabas nang kuta Ikonium ya tunggalé waé karo nang kuta Antioki. Nang kuta Ikonium rasul Paulus lan Barnabas uga mlebu nang sinaguk lan nggelarké pituturé Gusti Allah lan okèh wong Ju lan sing dudu Ju terus pada pretyaya marang Gusti Yésus Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nanging wong-wong Ju sing ora gelem pretyaya terus ngojok-ojoki wong-wong sing dudu Ju, marakké wong-wong kuwi terus pada nglawan marang para rasul. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Rasul Paulus lan Barnabas ora ngrèwès marang wong-wong kuwi, malah suwi nang kuta kono. Para rasul mau pada ngabarké bab Gusti Yésus karo kendel lan Gusti Allah déwé ngantepké kabar bab katrésnané Gusti kuwi nganggo mujijat-mujijat sing ditindakké karo para rasul. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Para wargané kuta kono terus petyah dadi loro: sing sebelah nurut wong-wong Ju lan sing liyané nurut rasul Paulus lan Barnabas. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Wong-wong Ju lan para pinituwané lan uga wong-wong dudu Ju terus pada ngumpul arep milara lan mbandemi watu marang para rasul. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kadung para rasul krungu bab kuwi terus pada lunga nang kuta Listra lan Dèrbé, kuwi kuta-kuta nang bawah Likonia lan uga nang panggonan-panggonan nang sak kiwa-tengené kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nang kono para rasul nggelarké kabar kabungahan bab Gusti Yésus Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nang kuta Listra kono ènèng sakwijiné wong sing kawit lairé lumpuh sikilé lan durung tau mlaku. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Wongé ngrungokké piwulangé rasul Paulus. Rasul Paulus ngematké wongé tenan lan ngerti nèk wongé bisa waras, awit wongé nduwé pretyaya. Mulané rasul Paulus terus ngomong marang wongé nganggo swara banter: “Ngadeka!” Wongé terus ngadek jegénggak lan mlaku-mlaku. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kadung wong-wong kono weruh sing ditindakké karo rasul Paulus kuwi, kabèh terus pada ramé ngomong ing basa Likonia: “Déwa-déwa pada medun rupa wong urip marani awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabas diarani Séus lan rasul Paulus diarani Hèrmès, awit dèkné sing ngomong. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Imamé déwa Séus, sing tèmpelé nang sak njabané kuta, terus teka nggawa sapi-sapi lan kembang digawa nang lawangé kuta. Imam lan wong pirang-pirang kuwi arep ngekèki kurban marang para rasul. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Kadung Barnabas lan rasul Paulus krungu apa sing arep ditindakké karo wong-wong mau, wong-wong terus dipenging nglakoni sing kaya ngono. Rasul Paulus lan Barnabas nyuwèk-nyuwèk saliné, terus pada mblayu marani wong-wong kuwi karo ngomong banter: “Para sedulur, kenèng apa kowé kok pada nindakké sing kaya ngono. Awaké déwé iki lak tunggalé manungsa kaya kowé kabèh. Awaké déwé iki mbréné arep nggawa kabar kabungahan bab Gusti Yésus Kristus, supaya kowé kabèh ninggal brahala-brahala sing ora nyata lan pada manut marang Gusti Allah sing urip, sing nggawé langit, bumi, segara lan sak isiné. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ing jaman sing wis kliwat Gusti Allah ngejarké marang para bangsa pada mlaku nurut dalané déwé-déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nanging Gusti Allah tansah ngétokké kabetyikané, awit Dèkné ngekèki udan lan panènan marang kowé, supaya kowé bisa ketyukupan ing pangan lan pada bungah.” ");
INSERT INTO jvnNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Senajan wis diomongi ngono, nanging meksa kangèlan menggak wong-wong sing pada ngekèki kurban marang para rasul. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Sangka kuta Antioki lan kuta Ikonium ènèng wong Ju pada teka ngojok-ojoki wong-wong nang kono. Paulus terus dibandemi watu, terus disèrèt metu sangka kuta, ndarani dèkné wis mati. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nanging kadung wong-wong sing pretyaya pada ngrubung dèkné, rasul Paulus terus ngadek lan balik mlebu nang kuta menèh. Esuké rasul Paulus lan Barnabas terus budal nang kuta Dèrbé. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nang kuta Dèrbé kono rasul Paulus lan Barnabas uga nggelarké kabar kabungahan bab Gusti Yésus Kristus lan wong okèh pada dadi muridé. Sakwisé kuwi para rasul terus balik nang kuta Listra, Ikonium lan Antioki nang bawah Pisidi. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nang kuta-kuta kuwi para rasul pada ngantepké pengandelé sedulur-sedulur sing pretyaya, supaya pada kendel. Sedulur-sedulur pada diélingké kongkon pada mantep terus ing pretyaya. Tembungé para rasul ngéné: “Nèk awaké déwé kepéngin mlebu Kratoné Gusti Allah, awaké déwé bakal nglakoni kasangsaran okèh.” ");
INSERT INTO jvnNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nang saben pasamuan nang kono para rasul terus miji pinituwa-pinituwané pasamuan. Nganggo pandonga lan pasa para pinituwa kuwi terus dipasrahké marang Gusti Allah, sing dadi andel-andelé. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Sakwisé rasul Paulus lan Barnabas ndlajahi bawah Pisidi, terus pada balik menèh nang bawah Pamfili. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nang kono para rasul nggelarké kabar kabungahan nang kuta Pèrgi, terus pada budal nang kuta Atalia. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Sangka kono para rasul terus ngabrah, balik nang kuta Antioki. Ya nang kuta Antioki kono dèk mbiyèn Paulus lan Barnabas ditetepké dadi rasul lan Gusti Allah ngétokké kabetyikané, awit miji rasul loro iki kanggo ngerjani penggawéané Gusti sing saiki wis rampung. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kadung wis pada teka nang kuta Antioki rasul Paulus lan Barnabas terus nglumpukké sedulur-sedulur nang pasamuan kono, dikèki laporan bab sembarang sing wis ditindakké karo Gusti Allah lantaran rasul loro iki. Rasul Paulus lan Barnabas uga ngomongké enggoné Gusti Allah wis ngekèki dalan marang wong-wong sing dudu Ju bisa dadi wong Kristen. ");
INSERT INTO jvnNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Para rasul terus rada suwi bebarengan karo sedulur-sedulur nang pasamuan kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Terus ènèng wong Ju siji-loro sangka Yudéa teka nang kuta Antioki. Wong-wong iki mulang marang sedulur-sedulur Kristen nang Antioki kono, nèk ora bisa slamet nèk ora disunati miturut wèt-wèté nabi Moses. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Piwulang kuwi marakké wong-wong sing sangka Yudéa mau èngkèl-èngkèlan karo rasul Paulus lan Barnabas. Entèk-entèkané para penuntuné pasamuan terus nggawé putusan ngongkon rasul Paulus lan Barnabas lan uga sedulur siji-loro sangka pasamuan Antioki kono pada budal nang kuta Yérusalèm, supaya ngrembuk prekara iki karo para rasul lan para pinituwa nang kana. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wong-wong sing dikongkon budal terus dieterké karo sedulur-sedulur sangka pasamuan. Wong-wong sing budal nang Yérusalèm kuwi mlakuné liwat bawah Fenisi lan Samaria. Kuwi ndadèkké bungahé sedulur-sedulur kono, awit pada dikabari nèk wong-wong sing dudu Ju pada pretyaya marang Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Sak tekané nang kuta Yérusalèm sedulur-sedulur sangka Antioki mau ditampa karo bungah karo sedulur-sedulur sangka pasamuan kono lan uga para rasul lan para pinituwa. Sedulur-sedulur kongkonan sangka Antioki mau terus pada ngomongké sembarang sing ditindakké karo Gusti Allah lantaran rasul Paulus lan Barnabas. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nanging ènèng sedulur Kristen siji-loro sangka golongané para Farisi ngadek lan ngomong: “Wong sing dudu Ju sing dadi wong Kristen kuwi kudu nglakoni sunat lan netepi wèt-wèté nabi Moses!” ");
INSERT INTO jvnNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Para rasul lan para pinituwa terus pada ngrembuk prekara iki. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sakwisé suwi enggoné bebantahan, rasul Pétrus terus ngadek lan ngomong ngéné: “Para sedulur! Kowé kabèh wis pada ngerti kepriyé enggoné Gusti Allah kawit mbiyèn wis milih aku sangka tengahmu kabèh, kongkon nggelarké kabar kabungahan bab Gusti Yésus Kristus marang wong-wong sing dudu Ju, supaya wong-wong kuwi uga pada krungu kabar iki lan pada pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Gusti Allah sing mangertèni pikirané manungsa wis nduduhké nèk Dèkné gelem nampa wong-wong sing dudu Ju, awit Dèkné ngekèki Roh Sutyi marang wong-wong kuwi, pada waé kaya enggoné Dèkné ngekèki marang awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Gusti Allah blas ora mbédak-mbédakké wong-wong sing dudu Ju karo awaké déwé. Gusti Allah ngresiki atiné wong-wong mau, jalaran wong-wong pada pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Lah nèk ngono, kenèng apa kowé kok pada nglawan marang Gusti Allah lan arep ngebot-eboti sedulur-sedulur kuwi? Lah gèk mbah-mbahané awaké déwé lan awaké déwé waé ora kuwat nyangga momotan kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mbok aja kaya ngono! Awit awaké déwé pada pretyaya lan dislametké jalaran sangka kawelasané Gusti Yésus, semono uga wong-wong sing dudu Ju kuwi!” ");
INSERT INTO jvnNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Wong sing pada ngumpul nang kono meneng kabèh sak barengé ngrungokké kabar-kabar sing digawa karo Barnabas lan rasul Paulus bab mujijat-mujijat sing ditindakké karo Gusti Allah nang tengahé wong-wong sing dudu Ju lantaran rasul loro kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sakwisé kuwi Yakobus terus ngomong ngéné: “Para sedulur, dirungokké omongku iki. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sedulur Simon Pétrus wis ngomongké nèk Gusti Allah enggoné nglumpukké bangsa kanggo Dèkné déwé, kawit wiwitané wis ngétokké kabetyikané lan kawelasané marang wong-wong sing dudu Ju. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tembungé para nabi dèk mbiyèn pantyèn tyotyok karo prekara iki. Awit wis ketulis ngéné: ");
INSERT INTO jvnNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Sakwisé kuwi aku bakal balik lan omahé Daved sing wis rubuh arep tak dekné menèh supaya bisa kaya mbiyèn. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Dadiné wong liyané sing dudu Ju kabèh bakal nggolèki Aku, kabèh wong sing ora kenal marang Aku, sing wis tak panggil dadi wèkku. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kuwi tembungé Gusti, sing wis nindakké kuwi mau kabèh kawit wiwitané!’ ” ");
INSERT INTO jvnNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobus neruské tembungé: “Para sedulur, miturut pinemuku, ora bener nèk awaké déwé nggawé angèlé sedulur-sedulur sing dudu Ju sing wis pada pretyaya marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Apiké awaké déwé nulis layang waé, diomongi supaya ora mangan pangan sing wis dipasrahké marang brahala; uga dipenging supaya ora mangan dagingé kéwan tekekan; dipenging mangan getih; uga kudu dipenging nindakké laku bédang. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Awit pendak dina sabat wèt-wèté nabi Moses kawit mbiyèn diwatyakké nang sinaguk-sinaguk nang endi waé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Para rasul, para pinituwa lan para wargané pasamuan terus nggawé putusan milih wong siji-loro sangka tengahé wong sing mèlu rerembukan mau, dikongkon budal nang kuta Antioki, bareng karo rasul Paulus lan Barnabas. Sing dipilih kuwi Yudas, sing uga jenengé Barsabas lan Silas. Wong loro iki diajèni tenan karo para sedulur nang pasamuan kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wong loro iki digawani layang sing isiné ngéné: Kabar slamet sangka sedulurmu para rasul lan para pinituwa nang Yérusalèm marang sedulur-sedulur kabèh sing dudu Ju, sing manggon nang kuta Antioki lan uga nang bawah Siria lan Silisia. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Awaké déwé krungu nèk ènèng wong siji-loro sangka Yérusalèm kéné nggawé susah lan bingungmu, awit mulangi sing ora bener. Kuwi ora sangka kekarepané awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mulané awaké déwé terus nganakké rembukan lan miji sedulur loro dikongkon teka nang nggonmu, yakuwi sedulur Yudas lan Silas. Sedulur loro iki budal bareng karo Barnabas lan rasul Paulus. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Sedulur loro iki ora éman nyawané kanggo nglabuhi Gustiné awaké déwé Yésus Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ya sedulur loro iki sing bakal ndunungké isiné layang iki marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Roh Sutyi lan awaké déwé kabèh wis dadi siji ing pinemu lan awaké déwé wis nggawé putusan nèk ora bakal nggawé susahmu lan ora ngebot-eboti kowé ngliwati sing perlu. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tegesé, kowé aja pada mangan pangan sing wis disajènké marang brahala, aja mangan getih lan aja mangan dagingé kéwan tekekan lan uga aja pada laku bédang. Nèk kowé nyingkiri prekara-prekara kuwi, kuwi wis tyukup. Ya mung semono tembungé awaké déwé, muga-muga Gusti mberkahi kowé kabèh! ");
INSERT INTO jvnNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Sedulur-sedulur sing arep lunga pada pamitan terus budal nang kuta Antioki. Nang kono sedulur-sedulur sak pasamuan terus dikumpulké kabèh lan layangé terus dipasrahké. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Sakwisé krungu isiné layangé, sedulur-sedulur pada bungah banget, awit pada kebangun. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sedulur Yudas lan Silas, kabèh loroné nabi, terus pada mbangun sedulur-sedulur sampèk suwi, ngantepké pengandelé wong-wong, supaya pada mundak kendel. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sakwisé nang kono rada suwi, Yudas lan Silas terus dililani mulih lan digawani kabar slamet kanggo sedulur-sedulur sing kongkonan sedulur loro iki. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nanging Silas malah nang kono terus, dèkné ora mèlu balik. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Rasul Paulus lan Barnabas terus rada suwi nang kuta Antioki kono. Bebarengan karo sedulur-sedulur okèh para rasul iki pada nggelarké pituturé Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ora let suwi rasul Paulus ngomong marang Barnabas: “Hayuk awaké déwé pada niliki sedulur-sedulur nang saben kuta sing wis dikabari pituturé Gusti karo awaké déwé, supaya ngerti kepriyé kabaré karo sedulur-sedulur kuwi.” ");
INSERT INTO jvnNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Lah Barnabas karepé ngejèk Yohanes Markus. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nanging rasul Paulus ora gelem nèk Markus mèlu, awit dèkné tau ninggal wong loro mau nang bawah Pamfili lan Markus kuwi ora temen lan ora ngréwangi tekan sak rampungé penggawéan. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Prekara kuwi marakké padu, sampèk entèk-entèkané rasul Paulus karo Barnabas pisah. Saiki Barnabas ngejèk Markus, terus numpak kapal budal nang pula Siprus. ");
INSERT INTO jvnNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","41","Lah rasul Paulus terus ngejèk Silas. Sakwisé sedulur loro iki dipasrahké marang kabetyikané Gusti Allah terus pada budal arep ndlajahi bawah Siria lan Silisia, ngantepké pengandelé sedulur-sedulur nang pasamuan-pasamuan nang bawah kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Rasul Paulus uga teka nang kuta Dèrbé lan Listra. Nang kono ènèng sedulur Kristen sing jenengé Timotius. Ibuné Timotius kuwi wong Kristen sangka bangsa Ju, nanging bapaké wong Grik. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Kabèh sedulur Kristen nang kuta Listra lan Ikonium pada ngerti nèk Timotius kuwi wong apik. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Rasul Paulus kepéngin ngejèk Timotius mèlu dèkné. Lan jalaran kabèh wong Ju ngerti nèk bapaké Timotius kuwi wong Grik lan Timotius ora sunat, mulané dèkné terus nglakoni sunat. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nang saben kuta sing ditekani, rasul Paulus ngomongké bab putusan-putusan sing wis ditetepké karo para rasul lan para pinituwa nang Yérusalèm lan nyuwun marang sedulur-sedulur, supaya pada netepi putusan-putusan kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mengkono kuwi rasul Paulus ngantepké pengandelé sedulur-sedulur nang pasamuan-pasamuan lan wargané saben dina mundak terus. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Jalaran Roh Sutyi ora nglilani rasul Paulus sak kantyané nggelarké kabar kabungahan bab Gusti Yésus Kristus nang bawah Asia Tyilik, wong telu mau terus ndlajahi bawah Frigia lan Galasia. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kadung tekan bawah Misia, wong-wong terus njajal arep mlebu nang bawah Bitinia, nanging Rohé Gusti Yésus ora nglilani kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mulané wong-wong terus budal nang kuta Troas liwat bawah Misia. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nang kuta Troas kono mbenginé kuwi rasul Paulus éntuk weweruh, ènèng wong sangka Masedonia ngadek tyeluk-tyeluk: “Aku nyuwun kowé pada teka nang bawah Masedonia lan nulungi awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Sakwisé éntuk weweruh kuwi awaké déwé dunung nèk Gusti Allah nyeluk awaké déwé kongkon budal nang bawah Masedonia nggelarké kabar kabungahan marang wong-wong nang kono. Awaké déwé terus tata-tata lan budal nang bawah Masedonia. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Awaké déwé terus numpak prau lunga sangka kuta Troas arep ngabrah nang pula Samotraké. Esuké awaké déwé terus budal nang kuta Néopolis. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Sangka kono awaké déwé terus nuju arep nang Filipi, kuta sing ndisik déwé nang bawah Masedonia. Kuta Filipi kuwi panggonané wong Rum. Awaké déwé nginep sedilut nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ing dina sabat awaké déwé metu sangka kutané arep nang pinggir laut, awit awaké déwé mikir nèk nang kono ènèng panggonan kanggo ndedonga marang Gusti Allah. Awaké déwé njagong lan omong-omongan karo wong wédok-wédok sing nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nang tengahé wong wédok-wédok kuwi ènèng siji sing jenengé Lidia, bakul purper sangka kuta Tiatira. Lidia kuwi wong sing ngabekti marang Gusti Allah, mulané Gusti Allah mbukak atiné supaya dèkné gelem nampa lan pretyaya marang piwulangé rasul Paulus. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lidia sak brayaté terus dibaptis. Lidia terus nyuwun marang awaké déwé ngéné: “Nèk kowé ngandel tenan nèk aku iki wis pretyaya marang Gusti, mbok hayuk pada nginep nang omahku ta.” Lan jalaran Lidia meksa marang awaké déwé, awaké déwé ya terus budal nang nggoné dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ing sakwijiné dina, dongé awaké déwé budal nang sinaguk, awaké déwé kepetuk wong wédok, wong slaf, sing dikwasani karo demit. Wong wédok iki marakké wong-wong sing nduwé dèkné kuwi dadi sugih, jalaran dèkné bisa ngomongké prekara-prekara sing bakal klakon ing uripé wong. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Wong wédok kuwi ngetutké rasul Paulus lan awaké déwé karo bengok-bengok: “Wong-wong iki peladèné Gusti Allah sing gedé déwé kwasané. Tekané mbréné arep ngomongi kowé kepriyé bisané kowé nampa keslametan!” ");
INSERT INTO jvnNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pirang-pirang dina suwéné wong wédok mau bengok-bengok terus, marakké rasul Paulus nesu banget. Dèkné terus minger lan nundung demité ngomong: “Ing jenengé Gusti Yésus, kowé tak tundung metu sangka wong wédok iki!” Sakwat demité metu sangka wong wédok mau. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kadung wong-wong sing nduwé wong wédoké weruh nèk wis ora bakal éntuk bati menèh sangka wong wédok kuwi, terus pada nyekel rasul Paulus lan Silas. Wong loro iki disèrèt digawa nang lataré pasar arep dipasrahké marang penggedéné kuta kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kadung wis digawa nang ngarepé para penggedéné kuta kono, sing nduwé slaf mau terus ngomong: “Wong loro iki wong Ju sing nggawé gègèr nang kuta kéné. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wong loro iki mulangi adat-tata-tyara sing séjé karo pernatané awaké déwé. Awaké déwé wargané negara Rum lan ora gelem mèlu adat-adat iki!” ");
INSERT INTO jvnNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Uga wong pirang-pirang pada mèlu nyalahké rasul Paulus lan Silas. Para penggedéné kuta terus nyuwèk-nyuwèk saliné rasul Paulus lan Silas terus ngongkon metyuti. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sakwisé kuwi wong loro mau terus dilebokké nang setrapan lan sing jaga setrapan dipréntah, supaya wong loro kuwi dijaga sing apik. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Jalaran dipréntah ngono, mulané sing jaga mau nglebokké rasul Paulus lan Silas nang sèl sing jeru déwé lan sikilé dipasang nang blok kayu. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kadung kira-kira wis tengah wengi, Paulus lan Silas terus pada ndonga lan singi-singi memuji Gusti Allah. Wong setrapan liya-liyané pada ngrungokké. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Terus dadakan ènèng lindu gedé sampèk pondasiné setrapan kono hoyak lan lawang-lawangé pada menga. Ranté-ranté sing dienggo ngranté wong-wong nang kono pada utyul. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Sing jaga setrapan terus tangi lan weruh lawang-lawangé setrapan pada menga. Mikiré wong-wong sing disetrap wis pada lunga kabèh. Wongé terus njikuk pedangé arep matèni dèkné déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nanging rasul Paulus terus mbengok: “Aja matèni awakmu déwé! Awaké déwé kabèh ijik nang kéné!” ");
INSERT INTO jvnNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Sing jaga mau terus njaluk dian lan mlebu nang njero. Karo ndredek dèkné terus niba nang ngarepé rasul Paulus lan Silas. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Sing jaga terus nggawa rasul Paulus lan Silas metu terus takon: “Bapak-bapak, apa sing kudu tak lakoni supaya bisa nampa keslametan?” ");
INSERT INTO jvnNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Rasul Paulus lan Silas semaur: “Pretyayaa marang Gusti Yésus lan kowé sak brayatmu bakal nampa keslametan!” ");
INSERT INTO jvnNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Rasul Paulus lan Silas terus ndunung-ndunungké bab pituturé Gusti Allah marang sing jaga setrapan mau sak brayaté. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ing wengi kuwi waé rasul Paulus lan Silas diejèk nang omahé lan tatu-tatuné rasul Paulus lan Silas terus diresiki lan dirumati. Sakwisé kuwi sing jaga setrapan sak brayaté terus dibaptis. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Rasul Paulus lan Silas terus disuguhi mangan. Tukang jaga setrapan mau sak brayaté jan bungah tenan saiki bisa pretyaya marang Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ing ésuké para penggedéné negara Rum ngongkon sekaut budal nang setrapan, kongkon ngomongi nèk rasul Paulus lan Silas kudu dietokké. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Sing jaga setrapan mau terus ngomongi rasul Paulus: “Para penggedéné Rum ngomong nèk kowé kudu dietokké. Ya kana mlaku sing apik-apik!” ");
INSERT INTO jvnNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nanging rasul Paulus ngomong karo sekaut-sekaut sing nggawa kabar mau: “Tanpa dikrutu awaké déwé dipetyuti nang ngarepé wong okèh, lah mangka awaké déwé iki wargané negara Rum. Awaké déwé dilebokké setrapan lan saiki dikongkon lunga meneng-menengan waé. Ora ngono! Bèn para penggedéné Rum déwé teka ngetokké awaké déwé iki!” ");
INSERT INTO jvnNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Sekaut-sekaut mau terus ngomongké kuwi marang para penggedéné Rum. Kadung krungu nèk rasul Paulus lan Silas kuwi wargané negara Rum, para penggedé mau terus wedi banget. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Wong-wong iki terus gelis-gelis teka nang setrapan lan njaluk ngapura. Sakwisé kuwi para penggedé terus nuntun rasul Paulus lan Silas metu sangka setrapan lan nyuwun marang wong loro mau supaya lunga sangka kuta kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Rasul Paulus lan Silas terus marani omahé Lidia. Nang kono pada ketemu karo sedulur-sedulur liyané. Sakwisé mulangi lan ngantepké pengandelé sedulur-sedulur nang kono, rasul Paulus lan Silas terus lunga sangka kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Rasul Paulus lan Silas terus liwat kuta Amfipolis lan kuta Apolonia tekan kuta Tèsalonika. Nang kono ènèng sinaguk. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kaya sak lumrahé rasul Paulus terus mlebu mbrono mèlu kumpulan. Sampèk telung sabat terus-terusan rasul Paulus tukar pikiran karo wargané sinaguk kono bab ayat-ayaté Kitab Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Rasul Paulus ndunung-ndunungké ayat-ayat mau lan mbuktèkké nèk Kristus kudu nandang sangsara lan ditangèkké sangka pati. Dèkné ngomong ngéné: “Gusti Yésus iki sing tak kabarké marang kowé, Dèkné sing dadi Kristus.” ");
INSERT INTO jvnNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Enèng wong siji-loro sing pretyaya, terus pada mèlu karo rasul Paulus lan Silas; semono uga okèh wong Grik sing mauné mèlu agama Ju, malah okèh wong wédok, wong gedé-gedé, sing uga pada pretyaya. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Weruh wong okèh dadi wong Kristen wong-wong Ju terus pada panas atiné. Terus nglumpukké wong-wong nakal kongkon nggawé gègèran, marakké sak kuta kabèh ramé gègèran. Wong-wong terus mlebu omahé Jason nggolèki rasul Paulus lan Silas, arep digawa nang ngarepé kumpulané warga kuta. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Kadung rasul Paulus lan Silas ora ketemu, wong-wong terus nyèrèt Jason lan wong pretyaya siji-loro, digawa nang ngarepé penggedéné kuta kono karo ngomong: “Wong-wong kuwi nang endi waé nggawé rétyok lan saiki nang kéné ditampa karo Jason. Wong-wong kuwi nerak wèt-wèté ratuné Rum, awit ngomong nèk ènèng ratu liyané sing jenengé Yésus.” ");
INSERT INTO jvnNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tembung kuwi nggawé gègèré wong okèh lan uga para penggedéné kuta. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Para penggedé mau terus njaluk bayaran duwit marang Jason lan kantya-kantyané. Sakwisé dibayar, Jason lan liyané terus dietyulké. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ing mbenginé kuwi sedulur-sedulur pada ngongkon rasul Paulus lan Silas lunga nang kuta Béréa. Sak tekané nang Béréa rasul Paulus lan Silas terus nggolèki sinaguk. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Wong-wong Ju nang kuta kono luwih gemati tenimbang wong Tèsalonika. Wong-wong Ju nang kuta Béréa kono pada seneng ngrungokké piwulang sing digelarké karo rasul Paulus lan Silas. Saben dina wong-wong iki pada matya Kitab Sutyi, kepéngin ngerti piwulangé rasul Paulus kuwi bener apa ora. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ing sak tengahé wong-wong kono okèh sing pada pretyaya lan okèh wong gedé sangka bangsa Grik, lanang lan wédok, dadi wong Kristen. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nanging wong Ju nang kuta Tèsalonika pada krungu nèk rasul Paulus lan Silas nggelarké pituturé Gusti Allah nang kuta Béréa, terus pada mbrono, ngojok-ojoki lan ngobong-obongi atiné wong okèh sing ngumpul nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mulané sedulur-sedulur terus gelis-gelis ngongkon rasul Paulus nang pinggir laut, arep digawa nang kuta Aténe, nanging Timotius lan Silas ditinggal nang Béréa. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Kadung wis tekan kuta Aténe, sedulur-sedulur sing ngeterké rasul Paulus terus balik menèh nang Béréa. Rasul Paulus nyuwun sedulur-sedulur iki kongkon ngomongi Silas lan Timotius, supaya ndang nusul dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Rasul Paulus saiki ngentèni tekané Silas lan Timotius. Nang kuta Aténe kono dèkné sedi tenan weruh retya-retya brahala pirang-pirang, sasaté ngebeki panggonan kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nang sinaguk rasul Paulus omong-omongan karo wong Ju lan wong-wong sing dudu Ju, nanging mèlu agama Ju. Saben dina dèkné ya ngono kuwi nang lataré pasar, karo sapa waé sing liwat kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Enèng filosof sangka golongan Epikuri lan Stoiki sing pada bantah-bantahan karo rasul Paulus. Enèng sing ngomong: “Apa ta sing diomongké karo tukang ngobrol kuwi?” Enèng menèh sing ngomong: “Wong kuwi mesti mulangké bab déwa-déwa sing anyar!” Wong-wong ngomong ngono kuwi, jalaran rasul Paulus nggelarké bab Gusti Yésus lan tanginé sangka pati. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Rasul Paulus terus diejèk nang panggonan kumpulané para filosof, panggonan sing jenengé Eropakus. Wong-wong ngomong ngéné: “Awaké déwé kepéngin ngerti bab piwulang sing anyar sing mbok wulangké iki. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Awit ènèng prekara-prekara sing anyar kanggo awaké déwé, mulané awaké déwé kepéngin ngerti.” ");
INSERT INTO jvnNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Wong Aténe lan bangsa liyané sing manggon nang kuta kono kuwi dina-dinané namung seneng ngrungokké lan ngrembuk bab prekara-prekara sing anyar. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Rasul Paulus terus ngadek nang ngarepé Eropakus kono terus ngomong: “Para sedulur nang Aténe! Aku nitèni sangka werna-werna prekara nèk kowé kuwi wong agama. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Awit dongé aku mlaku-mlaku nang kuta, aku weruh nang sak tengahé panggonan sembayang ènèng altar sing tulisané ngéné: ‘Kanggo gusti allah sing awaké déwé ora kenal’. Ya bab Gusti Allah sing mbok sembahi tanpa kowé kenal iki aku ngabarké marang kowé. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ya Gusti Allah iki sing nggawé jagat sak isiné. Lan ya Gusti Allah iki Gusti Allahé langit lan bumi. Gusti Allah iki ora manggon nang omah gawéané manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Gusti Allah iki ya ora mbutuhké sesajèn apa waé sangka manungsa, kaya Dèkné kekurangan apa-apa waé. Malah Dèkné sing ngekèki ambekan lan urip; Dèkné sing ngekèki sembarang marang manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Sangka wong siji Gusti Allah wis ndadèkké bangsa-bangsa, supaya pada manggon nang sak jembaré bumi kéné. Ya Gusti Allah iki sing wis kawit wiwitané ngarani waktuné lan watesé panggonan-panggonan kanggo manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Gusti Allah enggoné nindakké kuwi kabèh, supaya manungsa pada nggolèki Dèkné lan beja tenan nèk bisa ketemu karo Dèkné. Awit sakjané Gusti Allah kuwi ora adoh karo awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Enèng sing tau ngomong: ‘Jalaran sangka pangwasané Gusti Allah awaké déwé urip lan awaké déwé manggon ing donya iki.’ Kaya sing wis diomongké karo para tukang tulis sangka tengahmu: ‘Awaké déwé uga turunan sangka Gusti Allah.’ ");
INSERT INTO jvnNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Lan jalaran awaké déwé iki anaké Gusti Allah, mulané ya ora bener nèk awaké déwé nganggep nèk Gusti Allah kuwi kétoké kaya retya gawéan emas, selaka apa watu, manut pikirané lan kapinterané manungsa. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Gusti Allah ora mikirké jamané mauné, dongé manungsa ora kenal marang Dèkné, ora, nanging saiki Gusti Allah ngabarké nèk kabèh manungsa kudu ninggal klakuan sing ala lan nurut Dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Awit Gusti Allah wis netepké dina enggoné Dèkné arep ngrutu jagat; Dèkné wis miji wong siji sing bakal nindakké kuwi. Mulané, kanggo mbuktèkké iki Gusti Allah wis nangèké wong iki sangka pati.” ");
INSERT INTO jvnNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sakwisé wong-wong mau krungu rasul Paulus ngomongké bab tanginé wong mati, terus ènèng sing pada ngguyu tembungé rasul Paulus mau, ènèng sing ngomong ngéné: “Suk-suk waé aku arep ngrungokké menèh.” ");
INSERT INTO jvnNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Rasul Paulus terus lunga sangka Eropakus kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nanging ènèng wong siji-loro sing pretyaya lan mèlu rasul Paulus, kayadéné Dionisius, tukang pikir nang Eropakus kono, uga ènèng wong wédok sing jenengé Damaris lan liya-liyané menèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Sakwisé kuwi rasul Paulus terus lunga sangka kuta Aténe budal nang kuta Korinta. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nang Korinta kono rasul Paulus kepetuk karo wong Ju sing jenengé Akwila, wong sangka kuta Pontus. Akwila durung suwi teka sangka negara Itali karo bojoné sing jenengé Priskila. Tekané nang kuta Korinta kono, jalaran ratuné Rum sing jenengé Klaudius, ngusir wong Ju kabèh kongkon lunga sangka kuta Rum. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Rasul Paulus terus nggolèki omahé Akwila lan Priskila terus manggon karo brayat kuwi lan nyambutgawé bebarengan karo wong-wong kuwi, awit kerjanané tunggalé, yakuwi nggawèni omah lulang. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Saben dina sabat rasul Paulus nggelarké pituturé Gusti nang sinaguk, tujuané ndunung-ndunungké marang wong-wong Ju lan Grik, supaya pada pretyaya marang Gusti Yésus Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sakwisé Silas lan Timotius teka sangka Masedonia, rasul Paulus terus namung merlokké nggelarké kabar kabungahané Gusti Yésus Kristus, ndunungké marang wong Ju, nèk Gusti Yésus kuwi Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nanging wong-wong malah pada nampik lan ngolok-olok, mulané rasul Paulus terus ngebutké lemahé sangka saliné karo ngomong: “Nèk kowé kenèng sangsara, kuwi ya salahmu déwé. Aku ora nduwé salah apa-apa marang kowé. Wiwit saiki aku arep marani wong liya-liya bangsa.” ");
INSERT INTO jvnNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wong-wong mau terus ditinggal lunga karo rasul Paulus. Dèkné terus mondok nang omahé wong sing dudu Ju sing jenengé Titius Yustus. Wong iki mèlu agama Ju lan omahé nang jèjèré sinaguk. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Penggedéné sinaguk sing jenengé Krispus sak brayaté uga pada pretyaya marang Gusti Yésus. Uga wong liya-liyané menèh nang Korinta kono pada ngrungokké kabar kabungahan sing digelarké karo rasul Paulus lan wong-wong kuwi pada pretyaya marang Gusti Yésus. Wong-wong sing pretyaya mau terus pada dibaptis. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ing sakwijiné wengi Gusti Allah ngomong marang rasul Paulus ing njeroné weweruh. Tembungé ngéné: “Paulus, aja wedi! Diteruské enggonmu nggelarké kabar kabungahan lan aja mandek, awit Aku ngréwangi kowé. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nang kuta kéné okèh wong sing bakal dadi umatku, mulané aja wedi, awit ora ènèng wong sing bakal nggawé ala marang kowé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mulané rasul Paulus enggoné manggon nang kuta kono ya sampèk setaun setengah suwéné, karo mulangi wong-wong bab pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nanging kadung Galio dadi gramang nang distrik Akaya, wong Ju terus ngroyok rasul Paulus. Rasul Paulus dityekel terus digawa nang ngarepé kantor kruton. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Wong-wong ngelahké rasul Paulus ngomong ngéné: “Wong iki ngejèk wong okèh nyembah marang Gusti Allah nganggo patrap sing séjé karo pernatané agamané awaké déwé.” ");
INSERT INTO jvnNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kadung rasul Paulus ijik arep nyauri kelahan mau, gramang Galio terus ngomong ngéné marang wong-wong Ju kuwi: “Kowé wong Ju, nèk wong iki nerak pernatané negara apa nglakoni salah sing gedé, pantyèn bener aku nampa kelahanmu. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nanging prekara sing marakké padu iku lak bab tembung lan jeneng lan prekara-prekara bab pernatan-pernatan agamamu déwé. Prekara kaya ngono kuwi kudu mbok urusi déwé. Aku emoh ngetokké tembung bab kuwi!” ");
INSERT INTO jvnNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Wong-wong Ju mau terus dikongkon metu kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Sakwisé kuwi wong-wong terus nyekel Sostenès, penggedéné sinaguk kono. Wongé digebuki nang ngarepé kruton kono. Nanging gramang Galio ora ngrèwès blas. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Rasul Paulus ijik rada suwi menèh nang Korinta kono. Sakwisé kuwi dèkné terus lunga sangka kono, numpak kapal karo Priskila lan Akwila, budal nang bawah Siria. Sakdurungé budal rasul Paulus nyukur rambuté nang kuta Kèngkréa, kanggo netepi janjiné. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kadung tekan kuta Efése, rasul Paulus terus ninggal Priskila lan Akwila, terus mlebu nang sinaguk lan ngomongké bab pituturé Gusti marang wong-wong Ju. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wong-wong kuwi nyuwun marang rasul Paulus, supaya rada suwi nang kono, nanging dèkné ora bisa. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mulané rasul Paulus ngomong: “Nèk Gusti Allah nglilani, suk menèh aku balik mbréné.” Rasul Paulus terus lunga sangka kuta Efése. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tekan kuta Sésaréa rasul Paulus mlaku terus, budal nang kuta Yérusalèm, arep niliki pasamuan nang kono. Sakwisé kuwi dèkné terus budal nang kuta Antioki. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Rasul Paulus ora suwi nang kuta Antioki kono, nanging dèkné terus lunga turut bawah Galasia lan Frigia, tujuané ngantepké pengandelé sedulur-sedulur tunggal pretyaya nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nang kuta Efése ènèng wong Ju teka sing jenengé Apolos, lairan sangka kuta Alèksandria. Apolos kuwi wong sing bisa nggelarké pituturé Gusti lan dèkné ya jeru pangertiné bab Kitab Sutyi. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolos wis nampa piwulang bab dalané Gusti, mulané dèkné bisa mulangké bab Gusti Yésus karo ati sing semanget, senajan dèkné namung ngerti bab baptisané Yohanes Pembaptis. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Uga nang sinaguk Apolos mulangi karo kendel. Kadung Priskila lan Akwila krungu piwulangé, Apolos terus diampirké nang omahé, supaya bisa didunung-dunungké sing tyeta bab piwulang Kristen sak kabèhé. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Sakwisé kuwi Apolos kepéngin budal nang bawah Akaya. Sedulur-sedulur Kristen nang Efése kono pada bungah karo pikiran kuwi, mulané terus nggawani layang, supaya sedulur-sedulur nang bawah Akaya kono pada nampa Apolos sing apik. Kadung teka nang Akaya, Apolos bisa ngantepké pengandelé sedulur-sedulur nang kono, jalaran sangka kabetyikané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nang sak tengahé wong pirang-pirang Apolos bantah-bantahan karo wong-wong Ju lan ndunung-ndunungké sangka Kitab Sutyi, nèk Gusti Yésus kuwi Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Suwéné Apolos ijik nang kuta Korinta, rasul Paulus ndlajahi panggonan-panggonan sing adoh kuta, sampèk terus tekan kuta Efése. Nang kono rasul Paulus kepetuk karo wong Kristen siji-loro. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Wong-wong Kristen mau ditakoni: “Apa kowé wis nampa Roh Sutyi dongé kowé dibaptis?” Saurané wong-wong mau: “Apa kuwi? Awaké déwé durung tau krungu bab Roh Sutyi!” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Lah rasul Paulus terus takon: “Lo, lah nèk ngono kowé dibaptis karo baptisan apa?” Wong-wong semaur: “Karo baptisané Yohanes.” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Rasul Paulus terus ndunungké: “Baptisané Yohanes kuwi baptisané wong-wong sing pada ninggal urip dosa. Yohanes mulangi wong-wong, supaya pada pretyaya marang Gusti Yésus, sing tekané sak mburiné dèkné.” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Sakwisé krungu kuwi, wong-wong mau terus pada njaluk dibaptis ing jenengé Gusti Yésus. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Rasul Paulus terus numpangi tangan ndongakké wong-wong mau, terus sakwat wong-wong dikwasani karo Roh Sutyi, terus pada ngetokké basa kasukman lan uga ngetokké tembungé Gusti Allah nganggo basa sing lumrah. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wong-wong mau kabèhé ènèng wong rolas. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Telung sasi suwéné rasul Paulus mulangi karo kendel nang sinaguk, tukar-pikiran karo wong-wong Ju lan ndunung-ndunungké wong-wong bab Kratoné Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nanging ènèng wong siji-loro sing wangkal ora gelem pretyaya. Wong-wong kuwi malah ngolok-olok piwulang Kristen nang ngarepé wong okèh. Mulané wong-wong kuwi terus ditinggal lunga karo rasul Paulus. Wong sing pada pretyaya terus dikumpulké lan saben dina rasul Paulus mulang nang panggonan sing lumrahé dienggo mulang karo Tiranus. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Rong taun suwéné rasul Paulus mulang ngono. Dadiné wong-wong sing manggon nang bawah Asia, ya wong Ju lan wong bangsa liyané, pada krungu pituturé Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Gusti Allah nindakké mujijat-mujijat sing nggumunké banget lantaran rasul Paulus. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Sampèk katyu apa suwèkané sandangan lungsuran sing dienggo, nèk ditumpangké wong lara wongé bisa mari lan demit-demit mbarang ya pada metu sangka wong lara mau. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Lah nang kono ènèng wong Ju siji-loro sing mlaku-mlaku nambani wong-wong sing kelebon demit. Wong-wong kuwi pada njajal ngetokké demit nganggo jenengé Gusti Yésus, ngomong ngéné: “Aku nundung kowé ing jenengé Yésus sing dikabarké karo Paulus!” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sing nindakké kaya ngono wong pitu, kabèh anaké Imam Gedé sing jenengé Sekéfa. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nanging demit-demit mau malah pada semaur: “Yésus aku kenal, Paulus aku ya kenal, nanging kowé kuwi sapa?” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wong sing kelebon demit terus nubruk wong pitu mau sak kuwaté, sampèk pada kalah kabèh lan kudu mblayu sangka omah kono, awaké wuda lan dèdèl-duwèl. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Wong-wong Ju nang kuta Efése kono lan uga wong-wong bangsa liya sing mèlu agama Ju pada krungu lelakon mau terus pada wedi banget. Lantaran kuwi jenengé Gusti Yésus mundak kesuwur lan diajèni. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Okèh wong sing wis pretyaya pada teka lan ngakoni nang ngarepé wong okèh bab barang sing ala sing dilakoni. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Okèh wong pretyaya sing mbiyèné nindakké penggawé pepeteng pada nglumpukké buku-bukuné dadi siji, terus diobong nang ngarepé wong okèh. Ajiné buku-buku mau diitung sampèk ènèng pirang-pirang atus èwu duwit. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Lelakon-lelakon kuwi mau marakké pituturé Gusti Allah tambah sumebar lan kétok kwasané. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Sakwisé lelakon kuwi mau kabèh, rasul Paulus terus nggawé putusan arep nang Yérusalèm, liwat Masedonia lan Akaya. Dèkné ngomong: “Nèk aku wis rana, aku terus arep nang kuta Rum.” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Rasul Paulus terus ngongkon kantyané loro budal ndisik nang Masedonia, yakuwi Timotius lan Erastus. Rasul Paulus déwé kèri nang bawah Asia sak untara. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ya ing wayah kuwi ènèng gègèran gedé nang kuta Efése, jalaran sangka mundaké piwulang bab dalané Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Awit ènèng sakwijiné kemasan sing jenengé Demitrius, sing kerjanané nggawèni tèmpel-tèmpelan tyilik, niru tèmpelé déwi Diana. Dagangané Demitrius mau nekakké rejeki okèh kanggo wong-wong sing kerjanané uga nggawé tèmpel-tèmpelan kuwi. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Mulané Demitrius mau terus nglumpukké wong-wong kabèh sing tunggal kerjanan kuwi, terus ngomong ngéné: “Para kantya kabèh, kowé ngerti déwé nèk rejekiné awaké déwé metuné sangka kerjanané awaké déwé iki. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Lah saiki, dipikir déwé apa sing ditindakké karo Paulus. Dèkné ngomong nèk déwa-déwa sing digawé karo tangané manungsa ora tenan. Paulus malah bisa narik wong pirang-pirang, ora namung nang kuta Efése waé, nanging uga mèh sak bawah Asia kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mengkono kuwi ora namung kerjanané awaké déwé mundur, nanging uga wong-wong ora bakal nggatèkké menèh marang tèmpelé Déwi Gedé Diana. Karomenèh, Déwi Gedé Diana, sing disembah wong kabèh sak bawah Asia lan sak jagat kabèh, ora bakal disembah menèh, jalaran ilang apiké.” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Sakwisé krungu tembung kuwi mau, wong-wong terus pada nesu kabèh, terus bengok-bengok: “Gedé banget Déwi Diana, sembahané wong Efése!” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Sak kuta terus gègèr. Wong-wong terus nyekel Gayus lan Aristarkus, kantya-kantyané rasul Paulus sangka Masedonia. Wong loro mau terus disèrèt nang alun-alun. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Rasul Paulus mbarang arep mbrono, nanging dipenggak karo para sedulur Kristen nang kono. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Para penggedéné kuta kono, sing wis dadi kantyané rasul Paulus, uga ngomongi, supaya rasul Paulus dipenging mbrono. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nang kumpulané wong okèh kuwi terus rusu banget, ènèng sing ngomong ngéné, ènèng sing ngomong ngono, ramé banget, awit okèh wong sing ora ngerti apa jalarané pada mèlu teka mbrono. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Saiki ènèng wong sing jenengé Alèksander, dèkné dikongkon maju nang ngarepé wong-wong mau kongkon ngomong. Alèksander terus ngunggahké tangané ngongkon wong-wong pada meneng, awit dèkné arep ngekèki katerangan marang wong-wong mau. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nanging kadung weruh nèk Alèksander kuwi wong Ju, wong-wong mau bengok-bengok terus sampèk rong jam suwéné: “Gedé banget Déwi Diana, sembahané Efése!” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Entèk-entèké sèkrètarisé kuta kono bisa nentremké wong-wong mau. Dèkné ngomong ngéné: “Para sedulur, warga kuta Efése! Kabèh wong wis ngerti nèk kuta Efése kuwi wis dipasrahi ngurusi tèmpelé Déwi Gedé Diana lan uga ngurusi retya sutyi sing tiba sangka langit. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tak kira ora ènèng wong sing bisa ngomong nèk ora ngono. Mulané aku nyuwun marang kowé kabèh, supaya pada meneng lan aja grusa-grusu nindakké sing ora-ora. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Lah kowé pada nggawa wong-wong iki mbréné, lah mangka wong-wong iki ora nyolong apa-apa sangka tèmpel lan uga ora ngolok-olok marang Déwi Gedé, sesembahané awaké déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nèk Demitrius lan kantya-kantyané pada nduwé kelahan apa arep nyalahké sapa waé, iku apik, nanging kelahané kudu digawa nang kruton. Kanggo prekara-prekara kaya ngono kuwi wis ènèng dinané déwé-déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nanging nèk ènèng prekara liyané sing kudu dirembuk, iku kudu diurus karo kumpulané wakil rayat miturut wèté negara. ");
INSERT INTO jvnNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Awit, apa sing mbok lakoni ing dina iki kenèng diarani gègèran sing ora apik. Lah sakjané ora ènèng jalarané blas kanggo gègèran kaya ngéné iki.” ");
INSERT INTO jvnNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Sakwisé ngomong ngono kuwi kumpulané wong okèh mau terus ditutup. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kadung nang kuta Efése wis tentrem menèh, rasul Paulus terus ngumpulké sedulur-sedulur sangka pasamuan kono. Rasul Paulus ngekèki pitutur okèh kanggo ngantepké pengandelé sedulur-sedulur terus pamitan arep budal nang Masedonia. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Rasul Paulus terus ndlajahi panggonan-panggonan turut Masedonia kabèh karo mituturi sedulur-sedulur sing nang kono. Sangka Masedonia rasul Paulus terus budal nang negara Grik. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Sakwisé nang kono telung sasi rasul Paulus terus tata-tata arep nang Siria. Lah kok terus dadakan krungu nèk wong Ju pada nggawé rantyaman arep matèni dèkné. Mulané rasul Paulus arep balik metu Masedonia waé. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Rasul Paulus lungané dikantyani karo Sopatèr, anaké Pirus, wong sangka kuta Béréa. Sing mèlu uga Aristarkus lan Sekundus sangka kuta Tèsalonika, Gayus sangka kuta Dèrbé, Timotius lan wong loro liyané sangka bawah Asia, yakuwi Tikikus lan Trofimus. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Wong-wong mau pada budal ndisik lan arep ngentèni awaké déwé nang kuta Troas. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sak rampungé riyaya Roti tanpa Ragi awaké déwé numpak prau sangka kuta Filipi. Let nem dina awaké déwé ketemu karo para sedulur mau nang kuta Troas. Awaké déwé terus nang kono seminggu suwéné. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ing dina minggu awaké déwé ngumpul mangan bebarengan. Jalaran rasul Paulus ésuké arep lunga, mulané dèkné mituturi sampèk tengah wengi. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nang kamar nduwur sing dienggo kumpulan awaké déwé ijik ènèng lampuné siji-loro murup. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Lah ènèng sakwijiné botyah enom, jenengé Etikus, njagong nang jendéla. Jalaran rasul Paulus sing nggawa pitutur suwi banget tanpa lèrèn, botyah enom mau ora kuwat melèk terus keturon nang jendéla sampèk tiba, telung anda duwuré. Kadung dijunjung botyahé wis mati. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Rasul Paulus terus medun, ngrungkepi botyahé terus dirangkul karo ngomong: “Aja pada wedi, botyahé ijik urip!” ");
INSERT INTO jvnNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Sakwisé kuwi rasul Paulus terus balik menèh munggah lan mangan bebarengan. Kadung wis rampung mangan, rasul Paulus neruské enggoné nggawa pitutur, sampèk srengéngé njedul. Dèkné terus budal. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wong-wong pada bungah nèk Etikus ora sida mati. Botyahé terus dieterké mulih. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Awaké déwé terus ndisiki numpak prau budal nang kuta Asus. Nang Asus rasul Paulus arep mèlu numpak prauné. Rasul Paulus ngongkon awaké déwé budal ndisik, jalaran dèkné sing budal nang Asus arep mlaku waé. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Kadung wis tekan Asus rasul Paulus terus numpak kapalé. Awaké déwé terus karo kapalé budal nang kuta Mitiléné. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Sangka kana awaké déwé terus numpak prau menèh lan ésuké tekan ngarepé pula Kios. Liyané dina awaké déwé terus ngabrah nang pula Samos lan let sedina menèh awaké déwé tekan kuta Milétus. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Rasul Paulus ya wis mikir nèk ora arep mampir nang kuta Efése, supaya ora kesuwèn nang Asia lan ndang bisa tekan Yérusalèm, nèk bisa sakdurungé riyaya Pantékosta. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mulané sangka Milétus kono rasul Paulus kongkonan wong ngabari sedulur-sedulur nang kuta Efése, supaya pada ngumpulké para pinituwané pasamuan nang Milétus. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Sakwisé para pinituwa mau teka, rasul Paulus terus ngekèki pitutur ngéné: “Para sedulur, kowé weruh déwé enggonku bebarengan karo kowé suwéné aku nang tengahmu, wiwit aku teka nang bawah Asia. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Enggonku ngladèni Gusti ya tak lakoni karo andap-asor lan tak réwangi nangis-nangis lan ngalami kasangsaran, jalaran sangka panganiaya sing metu sangka para wong Ju. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Senajan ngono aku ora tau mangkir nindakké apa waé sing betyik kanggo kowé. Kabèh wis tak omongké lan tak wulangké marang kowé, ya nang ngarepé wong okèh, ya nang kumpulan nang omah-omahmu. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ya wong Ju, ya wong sing dudu Ju tansah tak élingké, supaya pada ninggal klakuan ala lan pada pretyaya lan masrahké uripé marang Gusti Yésus Kristus. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Lah saiki, manut karepé Roh Sutyi, aku kudu lunga nang Yérusalèm. Aku ora ngerti apa sing bakal tak alami nang kana. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Aku namung ngerti nèk Roh Sutyi wis ngélingké marang aku, nèk nang saben kuta aku bakal nandang werna-werna sangsara lan aku bakal disetrap. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Senajan ngono aku ora perduli bab uripku, janji aku bisa neruské penggawéanku lan ngrampungké kuwajiban sing wis dipasrahké marang aku karo Gusti Yésus, yakuwi, nggelarké kabar kabungahan bab kabetyikané Gusti Allah. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nang tengahmu aku ya wis ngabarké bab Kratoné Gusti Allah. Saiki aku krasa nèk aku ora bakal kepetuk menèh karo kowé kabèh. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mulané saiki aku ngomong sak beneré marang kowé: nèk nang tengahmu ènèng wong kesasar, kuwi dudu salahku. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Awit enggonku mulangi kowé bab kekarepané Gusti Allah ya wis sak genepé. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mulané, pada ngati-ati marang awakmu déwé lan marang wong-wong sing dipasrahké marang kowé karo Roh Sutyi. Sedulur-sedulur nang pasamuané Gusti Allah pada dituntun, awit wis dilabuhi mati karo Gusti Yésus déwé. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Aku ngerti nèk sakwisé aku lunga bakal ènèng asu galak okèh sing teka nang tengahmu lan ora bakal ngéman marang wedus-wedus mau. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Malah bakal ènèng wantyiné nang tengahmu déwé bakal ènèng wong siji-loro sing bakal nyimpang sangka piwulang sing bener lan nyasarké pasamuan. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Mulané para sedulur, pada sing ati-ati tenan lan pada élinga nèk sampèk telung taun suwéné aku wis mulangi kowé siji-siji, awan-wengi ora lèrèn karo ngetokké eluh. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Lah saiki kowé tak pasrahké marang kabetyikané Gusti Allah. Dèkné nduwé kwasa bisa ngantepké pengandelmu lan ngekèki berkah sing wis dityawiské kanggo para umaté. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Aku ora tau kepéngin nampa banda apa sandangan sangka sapa waé. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kowé pada weruh déwé enggonku nggolèk pangan nganggo tanganku déwé, kanggo nyukupi kabutuhanku lan kabutuhané kantya-kantyaku. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Aku wis nduduhké marang kowé nganggo patrap werna-werna, nèk enggoné awaké déwé mulang marang wong sing ora nduwé lan wong sing kesusahan kuwi kudu karo nyambutgawé sing abot. Pada éling marang tembungé Gusti Yésus: ‘Pawèh luwih apik tenimbang nampa.’ ” ");
INSERT INTO jvnNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Sakwisé rampung mituturi wong-wong mau, rasul Paulus terus sedeku bebarengan karo sedulur-sedulur kabèh terus pada ndonga. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Sedulur-sedulur pada nangis kabèh, terus pada ngrangkuli rasul Paulus lan diambungi bolak-balik. ");
INSERT INTO jvnNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kabèh pada susah, malah-malah jalaran rasul Paulus ngomong nèk ora bakal kepetuk menèh. Wong-wong terus ngeterké rasul Paulus tekan prauné. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Sakwisé awaké déwé pamitan karo para pinituwané pasamuan nang kuta Efése, awaké déwé terus ngabrah nang pula Kos. Esuké awaké déwé terus tekan pula Rodos. Sangka kono awaké déwé terus nang kuta Patara. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nang kuta Patara kono ènèng kapal sing arep budal nang bawah Fenisia. Awaké déwé mlebu kapal kuwi terus budal. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Sakwisé awaké déwé weruh pula Siprus, awaké déwé terus mlaku ngidul nganti tekan bawah Siria. Nang kuta Tirus awaké déwé terus medun, awit nang kono kapalé kudu ngedunké momotané. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nang kuta Tirus kono awaké déwé kepetuk karo sedulur Kristen siji-loro. Awaké déwé terus nginep nang omahé sedulur-sedulur kuwi nganti seminggu suwéné. Nang kono Roh Sutyi ngekèki kaweruh marang sedulur-sedulur, terus pada menging rasul Paulus, supaya ora budal nang kuta Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nanging kadung wis tekan wayahé awaké déwé ya terus budal. Para sedulur mau kabèh, sak anak-bojoné, ngeterké awaké déwé nganti tekan njabané kuta. Nang pinggir laut kono awaké déwé terus sedeku lan ndedonga. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Sakwisé pamitan awaké déwé terus mlebu kapalé lan sedulur-sedulur mau terus pada mulih. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Awaké déwé terus budal nang kuta Pétolémais. Nang kono awaké déwé niliki sedulur-sedulur Kristen sing nang kono lan nginep sewengi. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Esuké awaké déwé budal menèh terus tekan kuta Sésaréa. Nang kono awaké déwé nginep nang omahé Filipus sing tukang nggelarké pituturé Gusti. Filipus kuwi tunggalé karo sedulur pitu sing mbiyèn dipilih dadi peladèné pasamuan nang Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipus kuwi nduwé anak prawan papat sing nduwèni kapinteran bisa ngetokké tembung-tembung sangka Gusti. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sakwisé awaké déwé nang kono ènèng seminggu, terus ènèng nabi teka sangka Yudéa, jenengé Akabus. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Akabus mau marani awaké déwé terus njikuk sabuké rasul Paulus. Sabuk mau dienggo nalèni sikil lan tangané dèkné déwé terus ngomong: “Iki tembungé Roh Sutyi: wong sing nduwé sabuk iki bakal dibanda ngéné iki karo wong-wong Ju nang Yérusalèm lan wong kuwi bakal dipasrahké marang bangsa liya.” ");
INSERT INTO jvnNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kadung krungu kuwi, awaké déwé lan uga sedulur-sedulur kabèh terus ngomongi rasul Paulus, supaya ora budal nang Yérusalèm waé. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nanging rasul Paulus semaur ngéné: “Kenèng apa kowé kok pada nangis lan ngalang-alangi aku. Aku ora namung saguh dibanda nang Yérusalèm, nanging senajana kudu mati aku saguh nglakoni kanggo Gusti Yésus.” ");
INSERT INTO jvnNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Awaké déwé wis ora bisa ngendek rasul Paulus, mulané awaké déwé ya mung négakké waé karo ngomong: “Muga karepé Gusti Allah keturutan.” ");
INSERT INTO jvnNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kadung wis tekan wantyiné, awaké déwé terus tata-tata, terus budal nang Yérusalèm. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sedulur Kristen siji-loro sangka kuta Sésaréa mèlu ngeterké awaké déwé nang omahé Manason, awit awaké déwé arep nginep nang kono. Manason kuwi sedulur sangka pula Siprus, dadi wong Kristen kawit wiwitané pasamuan. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Dongé awaké déwé teka nang Yérusalèm, awaké déwé ditampa karo sedulur-sedulur Kristen kono karo bungah. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Esuké rasul Paulus karo awaké déwé kabèh terus niliki Yakobus. Para pinituwané pasamuan kabèh uga pada teka. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Sakwisé mbagèkké sedulur-sedulur, rasul Paulus terus ngomongké bab sembarang sing ditindakké karo Gusti Allah nang tengahé wong sing dudu Ju lantaran dèkné. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Krungu kabar sangka rasul Paulus bab kuwi mau kabèh, wong kabèh terus pada memuji Gusti Allah. Sakwisé kuwi wong-wong terus ngomong ngéné marang rasul Paulus: “Sedulur Paulus, iki dirungokké. Nang kéné ènèng wong Ju pirang-pirang èwu sing pretyaya marang Gusti Yésus, nanging uga ya pada netepi wèt-wèté nabi Moses. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nanging sedulur-sedulur Kristen kuwi pada krungu kabar, nèk kowé nang negara liya mulangi wong Ju kabèh, nèk ora usah nurut wèt-wèté nabi Moses lan ora usah nyunati anak-anaké apa nurut adat-tata-tyarané wong Ju. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Lah sedulur-sedulur kuwi wis pada krungu nèk kowé teka. Lah saiki kuduné kepriyé? ");
INSERT INTO jvnNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","24","“Apiké ngéné waé, awaké déwé nyuwun marang kowé: lah iki ènèng sedulur papat sing wis ngetokké janji miturut agama Ju. Kana bareng karo sedulur papat kuwi nindakké tata-tyara sesutyi lan mbayar ragaté, supaya sedulur-sedulur mau bisa nyukur rambuté. Dadiné tyeta kanggo wong kabèh, nèk apa sing wong-wong krungu mauné ora bener, malah wong-wong pada nitèni déwé, nèk kowé wujuté netepi wèt-wèté nabi Moses. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Bab kanggo wong-wong Kristen sing dudu Ju awaké déwé ya wis ngirimi layang ngomongi bab putusané awaké déwé, yakuwi, nèk sedulur-sedulur kuwi dipenging mangan pangan sing wis dienggo sajèn marang brahala, mangan getih apa kéwan sing matiné tekekan; uga dipenging laku bédang.” ");
INSERT INTO jvnNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Esuké rasul Paulus terus ngejèk wong papat mau lan sakwisé nindakké sesutyi bebarengan miturut tata-tyarané wong Ju, terus pada mlebu Gréja Gedé. Nang kono terus ngomongké sepira suwéné waktuné sesutyèn lan kurban sing kudu dipasrahké kanggo wong siji-sijiné. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Mèh wis genep pitung dina, tegesé entèk-entèké wayah sesutyi, terus ènèng wong Ju siji-loro sangka bawah Asia weruh rasul Paulus nang Gréja Gedé. Wong-wong iki terus ngojok-ojoki wong okèh, supaya nyekel rasul Paulus. ");
INSERT INTO jvnNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Wong-wong Ju sangka Asia mau pada bengok-bengok ngéné: “Sedulur-sedulur wong Israèl, nyuwun tulung! Lah iki wongé sing nang endi-endi mulangi, supaya wong-wong kabèh pada nglawan bangsa Israèl lan wèt-wèté nabi Moses lan uga Gréja Gedé iki. Lah saiki wong iki malah ngejèk wong sing dudu Ju digawa mlebu nang Gréja Ged