﻿USE sofia;
DROP TABLE IF EXISTS sofia.juy_vpl;
CREATE TABLE juy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES juy_vpl WRITE;
INSERT INTO juy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","କେନ୍‌ଆତେ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆ ପୁର୍ବା ଜୋଜୋଜି ଆ କେଜ୍ଜା ଆଞୁମ୍‌ଜି ଆଇଡିଡ୍‌ । ଜିସୁନ୍‌ ଦାଉଦନ୍‌ ଆ କନୋକ୍କୋଡ୍‌ ଆରି ଦାଉଦନ୍‌ ଅବ୍ରାମନ୍‌ ଆ କନୋକ୍କୋଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଅବ୍ରାମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଇସାକ, ଇସାକନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜାକୁବ, ଜାକୁବନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିଉଦା, ଆରି ଆ ବୋଞାଙଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ଜିଉଦାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ପେରସନ୍‌ ଡ ସେରଅନ୍‌, କେନ୍‌ ଆୟୋଙଞ୍ଜି ଆଞୁମ୍‌ ତାମର, ପେରସନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଇସ୍ରୋଣ, ଇସ୍ରୋଣନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଅରାମ, ");
INSERT INTO juy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ଅରାମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଅମିନାଦବ, ଅମିନାଦବନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ନଅସୋନ, ନଅସୋନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ସଲମୋନ, ");
INSERT INTO juy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ସଲମୋନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ବୋୟାଜନ୍‌, କେନ୍‌ ଆ ନନନ୍‌ ଆଞୁମ୍‌ ରାଆବ, ବୋୟାଜନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଓବେଦ, କେନ୍‌ ଆ ନନନ୍‌ ଆଞୁମ୍‌ ରୁତ, ଓବେଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିସୟ, ");
INSERT INTO juy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ଜିସୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଦାଉଦ ରାଜା । ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ସୋଲମନ୍‍, ସୋଲମନନ୍‌ ଆୟୋଙ୍‌ ଆମ୍ମୁଙ୍‌ ଉରିୟନ୍‌ ଆ ଡୁକ୍ରି ଡକୋଏନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ସୋଲମନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ରିଅବିଆମ, ରିଅବିଆମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଅବିଅ, ଅବିଅନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଆସା, ");
INSERT INTO juy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ଆସାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିଓସାପଟ, ଜିଓସାପଟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜୋରାମ, ଜୋରାମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଉଜିଅ, ");
INSERT INTO juy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ଉଜିଅନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜୋତମ, ଜୋତମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଆଅସ, ଆଅସନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଇଜକିୟ, ");
INSERT INTO juy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ଇଜକିୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ମନସି, ମନସିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଆମୋନ, ଆମୋନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜୋସିଅ, ");
INSERT INTO juy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ଜୋସିଅନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ଜିକନିୟନ୍‌ ଡ ଆ ବୋଞାଙଞ୍ଜି, ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ବଣ୍ଡିଲେ ବାବିଲୋନନ୍‌ ଆପ୍ରାଙେଞ୍ଜି ଆଡିଡ୍‌ ଜିକନିୟନ୍‌ କୋଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ଜିକନିୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ସଲ୍‌ଟିୟେଲ, ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ବଣ୍ଡିଲେ ବାବିଲୋନନ୍‌ ଆପ୍ରାଙେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସଲ୍‌ଟିୟେଲନ୍‌ କୋଡେଞ୍ଜି, ସଲ୍‌ଟିୟେଲନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିରୁବାବିଲ, ");
INSERT INTO juy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ଜିରୁବାବେଲନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଅବିଉଦ, ଅବିଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଏଲିଆକିମ, ଏଲିଆକିମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଆସୋର, ");
INSERT INTO juy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଆସୋରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ସାଦୋକ, ସାଦୋକନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଆକିମ, ଆକିମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଏଲିଉଦ, ");
INSERT INTO juy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ଏଲିଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଏଲିଆଜର, ଏଲିଆଜରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ମତ୍ତାନ, ମତ୍ତାନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜାକୁବ, ");
INSERT INTO juy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ଜାକୁବନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜୋସେପ, ଜୋସେପନ୍‌ ମରିଅମନ୍‌ ଆ ଅୟ୍‌ତବ୍‌, କେନ୍‌ ଆ ମରିଅମ ଆ କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଜିସୁନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେଏନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ କ୍ରିସ୍ଟ ଗନାମନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ଏନ୍ନେଲେ ଅବ୍ରାମନ୍‌ ସିଲଡ୍‌ ଦାଉଦନ୍‌ ଜାୟ୍‌ ଚଉଦ କନୋକ୍କୋଡ୍‌, ଆରି ଦାଉଦନ୍‌ ସିଲଡ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ବଣ୍ଡିଲେ ବାବିଲୋନନ୍‌ ଆପ୍ରାଙେଞ୍ଜି ଜାୟ୍‌ ଚଉଦ କନୋକ୍କୋଡ୍‌, ଆରି ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ବଣ୍ଡିଲେ ବାବିଲୋନନ୍‌ ଆପ୍ରାଙେଞ୍ଜି ସିଲଡ୍‌ କ୍ରିସ୍ଟନ୍‌ ଜାୟ୍‌ ଚଉଦ କନୋକ୍କୋଡ୍‌ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆ କୋରୋକ୍କୋଡ୍‌ ଏନ୍ନେଲେ ଡେଲୋ । ଜିସୁନ୍‌ ଆୟୋଙ୍‌ ମରିଅମନ୍‌, ଜୋସେପନ୍‌ ବୟନ୍‌ ବିବାନେନ୍‌ ଆସନ୍‌ ଆବେଡ୍‌ବେଡନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ବାଗୁଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ମାୟ୍‌ନେଞ୍ଜି ଆମ୍ମୁଙ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ମରିଅମନ୍‌ ପାଙ୍ଗୁରନ୍‌ଲନ୍‌ ଗାମ୍‌ଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ତିଆସନ୍‌ ଜୋସେପନ୍‌ ମରିଅମନ୍‌ ବୟନ୍‌ ବିବାନେନ୍‌ ଆସନ୍‌ ଅସାଏନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜୋସେପନ୍‌ ଅବୟ୍‌ ଡରମ୍ମମର୍‌ ଡକୋଏନ୍‌ ଆରି ମରିଅମନ୍‌ଆଡଙ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆତେମଡ୍‌ ଅନବ୍‌ନିଣ୍ଡୟନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଅଃଲ୍ଲଡୟ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ବନ୍‌ଡ ଜୋସେପନ୍‌ ଏନ୍ନେଲେ ଆରିଃୟମେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଗିୟ୍‌ବା, ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ଗନୁମ୍‌ତେଲୋଙନ୍‌ ଜୋସେପନ୍‌ ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡମ୍‌ଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଏ ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜୋସେପ, ମରିଅମନ୍‌ ବୟନ୍‌ ବିବାନେନ୍‌ ଆସନ୍‌ ବତଙ୍‌ଡଙମ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ପାଙ୍ଗୁରନ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ଆନିନ୍‌ ଅବୟ୍‌ ଓବ୍ବାସିଜନ୍‌ କୋଡ୍‌ତେ, ଆରି ଆମନ୍‌ ଆଞୁମନ୍‌ ଜିସୁ ଅବ୍‌ଞୁମା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆ ଇର୍ସେଞ୍ଜି ସିଲଡ୍‌ ଉର୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆ ତଅଡ୍‌ ଗଡ୍‌ ପ୍ରବୁନ୍‌ ଅଙ୍ଗା ପୁର୍ବାଃତେବର୍‌ ବର୍ରନେ, ତିଆତେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡେଡମ୍‌ତେ ତିଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଏନ୍ନେଲେ ଡେଏନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ଗିୟ୍‌ବା, ଅବୟ୍‌ ପୟ୍‌ଲଙ୍‌ ଡାଙ୍ଗଡ଼ିସିଜନ୍‌ ପାଙ୍ଗୁରନ୍‌ଡାଲନ୍‌ ଅବୟ୍‌ ଓବ୍ବାସିଜନ୍‌ କୋଡ୍‌ତେ, ଆରି ଆଞୁମନ୍‌ ଇମ୍ମାନୁୟେଲ୍‌ ଅନବ୍‌ଞୁମନ୍‌ ଡେତେ ।” କେନ୍‌ ଆଞୁମ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ “ଇନ୍‌ଲେଞ୍ଜି ସରିନ୍‌ ଇସ୍ୱରନ୍‌ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ସିଲତ୍ତେ ଜୋସେପନ୍‌ ମଡ଼େଡାଲେ ଡୋଲନ୍‌ କି ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏଙ୍ଗାଲେ ବରେନ୍‌, ତିଅନ୍ତମ୍‌ ଆନିନ୍‌ ଲୁମେନ୍‌ ଆରି ଆନିନ୍‌ ମରିଅମନ୍‌ ବୟନ୍‌ ବିବାଲନେ । ");
INSERT INTO juy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ବନ୍‌ଡ ମରିଅମନ୍‌ ଅବୟ୍‌ ଓବ୍ବାସିଜନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ କୋଡେନ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ ବୟନ୍‌ ଅଃଡ୍ଡକୋଲନେ, ଆରି ଜୋସେପନ୍‌ ତି ଓବ୍ବାସିଜନ୍‌ ଆଞୁମ୍‌ ଜିସୁ ଅବ୍‌ଞୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ଏରୋଦ ରାଜାନ୍‌ ଆଡିଡ୍‌ ଜିଉଦା ଡେସାନ୍‌ ବେତଲିମ ଗଡ଼ାଲୋଙନ୍‌ ଜିସୁନ୍‌ କରୋକ୍କୋଡନ୍‌ ଆଡ୍ରେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଗିୟ୍‌ବା, ଡରୁଙ୍‌ୟୋଙ୍‌ ଡେସାନ୍‌ ସିଲଡ୍‌ ପଣ୍ଡିତଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଇୟ୍‌ଲାଜି, ");
INSERT INTO juy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ଆନିଞ୍ଜି ଇୟ୍‌ଲାୟ୍‌ ଗାମେଜି, “ଜିଉଦିଞ୍ଜି ଆ ରାଜାନେନ୍‌ ଆସନ୍‌ କରୋକ୍କୋଡନ୍‌ ଆଡ୍ରେଏନ୍‌ ଆ ପସିୟ୍‌ ଅଡ଼େଙ୍ଗା ? ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଡରୁଙ୍‌ୟୋଙ୍‌ ଡେସାଲୋଙନ୍‌ ଆ ତୁତୁଜନ୍‌ ଗିୟ୍‌ଲେ, ଆନିନ୍‌ଆଡଙ୍‌ ପୁର୍‌ପୁରନ୍‌ ଆସନ୍‌ ଏଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଏରୋଦ ରାଜାନ୍‌ ଡ ଆନିନ୍‌ ସରିନ୍‌ ସମ୍ପରା ଜିରୁସାଲମବାଜି ବାଉଲ୍ଲି ଡେଏଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ଆରି, ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ସୋଡ଼ା ରାଓଡ଼ାଜି ଅଡ଼୍‌କୋଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ରୁକ୍କୁଡାଲେ ବରେଞ୍ଜି, “କ୍ରିସ୍ଟନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେତେ ?” ");
INSERT INTO juy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ଆନିଞ୍ଜି ଏରୋଦନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଜିଉଦା ଡେସାନ୍‌ ବେତଲିମ ଗଡ଼ାଲୋଙନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଏନ୍ନେଲେ ଇଡେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘ଆରି, ଏ ଜିଉଦା ଡେସାଲୋଙନ୍‌ ବେତଲିମ ଗଡ଼ାନ୍‌, ଆମନ୍‌ ଜିଉଦାଲୋଙନ୍‌ ସୋଡ଼ାରା ଗଡ଼ାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଏଙ୍ଗାଲେ ଜନଙ୍‌ ସନ୍ନା ତଡ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ରାଏଲ୍‌ ମନ୍‌ରାଲେଞ୍ଜିଆଡଙ୍‌ ତୁର୍‌ତୁରନ୍‌ ଆସନ୍‌, ଅମଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ରାଜାନ୍‌ ଡୁଙ୍‌ତନାୟ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଏରୋଦନ୍‌, ତି ତୁତୁଜନ୍‌ ଅଙ୍ଗା ବେଡ଼ା ଗିୟ୍‌ତାଏନ୍‌, ତିଆତେ ଜନନାନ୍‌ ଆସନ୍‌ ପଣ୍ଡିତଞ୍ଜିଆଡଙ୍‌ ଅଜନା ଓଡ୍ଡେଡାଲେ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ଆରି, ଏରୋଦନ୍‌ ପଣ୍ଡିତଞ୍ଜିଆଡଙ୍‌ ବେତଲିମନ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଜିର୍ରେ ତି ପସିଜନ୍‌ ଆ ବର୍ନେ ମନଙ୍‌ ଇୟ୍‌ ସେକ୍କୁବା, ଆରି ଇୟ୍‌ଲେ ଏରବାଙେ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଡେନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆୟ୍‌ ବରିଁୟ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ନିୟ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ତେ ପୁର୍‌ନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ସିଲତ୍ତେ ଆନିଞ୍ଜି ରାଜାନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଜିରେଞ୍ଜି; ଆରି ଗିୟ୍‌ବା, ଆନିଞ୍ଜି ଡରୁଙ୍‌ୟୋଙ୍‌ଗଡ୍‌ ଆଗ୍ରିଜେଞ୍ଜି ଆ ତୁତୁୟ୍‌, ଆ ମୁକ୍କାଗଡଞ୍ଜି ଆମ୍ମୁଙ୍‌ଡାଲନ୍‌ ଜିର୍ରେ ପାଙେନ୍‌, ଆରି ତି ପସିଜନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋଏନ୍‌, ତି ଆ ତୋଣ୍ଡୋ ଇୟ୍‌ଲେ ତନଙେ । ");
INSERT INTO juy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ଆନିଞ୍ଜି ତୁତୁଜନ୍‌ ଗିୟ୍‌ଲେ ମାଡ୍ଡ ସର୍ଡାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ଆରି ଅମ୍ମସିଙନ୍‌ ଜିର୍ରେ ତି ପସିଜନ୍‌ଆଡଙ୍‌ ଆୟୋଙନ୍‌ ମରିଅମନ୍‌ ସରିନ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତୁଡ଼ୁମ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଲୋମେଞ୍ଜି, ଆରି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ପିଡ଼ି ରୋଲେ ସୁନାନ୍‌, କୁନ୍ଦୁରୁନ୍‌ ଡ ଲଙିଡ୍‌ମେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତନିୟ୍‌ତିୟନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ଆରି ଏରୋଦନ୍‌ ଆମଙ୍‌ ଏର୍‌ଜନିରନ୍‌ ଆସନ୍‌ ଗନୁମ୍‌ତେଲୋଙନ୍‌ ବର୍ନେନ୍‌ ଆରମ୍‌ଡଙେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଆନ୍ନା ତଙର୍‌ ଗଡ୍‌ ଆ ଡେସାଡମଞ୍ଜି ୟର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ପଣ୍ଡିତଞ୍ଜି ଆଜିର୍ରେଞ୍ଜି ଆ ତିକ୍କି, ଗିୟ୍‌ବା ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ଜୋସେପନ୍‌ ଆ ଗନୁମ୍‌ତେଲୋଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡାଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଡୋନା, ଆୟୋଙନ୍‌ ଡ ପସିଜନ୍‌ ଞମ୍‌ଲେ ମିସର୍‌ ଡେସାନ୍‌ ଜିର୍ବା, ଆରି ଞେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ବର୍ବେନ୍‌ ଜାୟ୍‌ ତେତ୍ତେ ଇୟ୍‌ ଡକୋନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପସିଜନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏରୋଦନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସାୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ସିଲତ୍ତେ ଜୋସେପନ୍‌ ଡୋଲନ୍‌ ଆୟୋଙନ୍‌ ଡ ପସିଜନ୍‌ ଞମ୍‌ଲେ ତଗଲ୍‌ମଡ ତଗଲ୍‌ ମିସର୍‌ ଡେସାନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ଆରି ଏରୋଦନ୍‌ ଆ ରନବୁ ଜାୟ୍‌ ଆନିଞ୍ଜି ତେତ୍ତେ ଇୟ୍‌ଲେ ଡକୋନେଜି, ତିଆସନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆ ତଅଡ୍‌ ଗଡ୍‌ ପ୍ରବୁନ୍‌ ଆବର୍ରନେନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, “ଞେନ୍‌ ମିସର୍‌ ଡେସାନ୍‌ ସିଲଡ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ତି ଆ ବନେଡ଼ା ପଣ୍ଡିତଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ କଣ୍ଡାୟ୍‌ଡାଲେ ଜିରେଞ୍ଜି ଗାମ୍‌ଲେ ଆଜ୍ରନାଏନ୍‌ ଏରୋଦନ୍‌ ବରାବେନ୍‌, ଆରି ତୁତୁଜନ୍‌ ଅଙ୍ଗା ବେଡ଼ା ଗିୟ୍‌ତାଏନ୍‌ ଗାମ୍‌ଲେ ପଣ୍ଡିତଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ବରେଞ୍ଜି, ତିଅନ୍ତମ୍‌ ବେତଲିମ ଗଡ଼ାନ୍‌ ଡ ଆ ତନ୍ନଡ୍‌ଲୋଙନ୍‌ ବାଗୁ ବର୍ସେଙ୍‌ ଆରି ତି ସିଲଡ୍‌ ସନ୍ନା ଡିଅଙ୍ଗା ଓବ୍ବାସିଜଞ୍ଜି ଡକୋଏଞ୍ଜି, ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ତି ଅଡ଼୍‌କୋନ୍‌ ଆ ପସିୟ୍‌ଜି ଅବ୍‌ରବ୍ବୁଆଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ତିଆଡିଡ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିରିମିଅନ୍‌ ଆ ତଅଡ୍‌ ଗଡ୍‌ ପ୍ରବୁନ୍‌ ଆବର୍ରନେନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ରାମା ଗଡ଼ାଲୋଙନ୍‌ ସର୍ରଙନ୍‌ ସଡ୍ଡାଏନ୍‌, ତିଆତେ ୟନେନ୍‌, ଗୁନେନ୍‌ ଆ ସର୍ରଙ୍‌, ରାଏଲନ୍‌ ଆ ପସିଜଞ୍ଜି ଆସନ୍‌ ୟେୟେଡାଲନ୍‌; ଆନିନ୍‌ ବନବ୍‌ୟୋନ୍‌ ଅଃଲ୍ଲଡୟ୍‌ଲୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆ ପସିଜଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ରବୁଆଜେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ଏରୋଦ ରାଜାନ୍‌ ଆର୍ରବୁଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଗିୟ୍‌ବା, ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ମିସର୍‌ ଡେସାଲୋଙନ୍‌ ଜୋସେପନ୍‌ ଆ ଗନୁମ୍‌ତେଲୋଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡାଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ଡୋନା, ଆୟୋଙନ୍‌ ଡ ପସିଜନ୍‌ ଞମ୍‌ଲେ ଇସ୍ରାଏଲ୍‌ ଡେସାନ୍‌ ଜିରା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନାଜି ପସିଜନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ଆନିଞ୍ଜି ରବୁଏଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ସିଲତ୍ତେ ଜୋସେପନ୍‌ ଡୋଲନ୍‌ ଆୟୋଙନ୍‌ ଡ ପସିଜନ୍‌ ଞମ୍‌ଲେ ଇସ୍ରାଏଲ୍‌ ଡେସାନ୍‌ ଜିର୍ରାଜି । ");
INSERT INTO juy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ବନ୍‌ଡ ଆପେୟନ୍‌ ଏରୋଦନ୍‌ ଆ ପାଲ୍‌ତେଙ୍‌ ଆର୍କିଲାୟନ୍‌ ଜିଉଦା ଡେସାନ୍‌ ଆ ରାଜା ଡେଏନ୍‌ ଗାମ୍‌ଲେ ଜୋସେପନ୍‌ ଆରମ୍‌ଡଙେନ୍‌, ତେତ୍ତେ ଜିର୍‌ଜିରନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ବତଙେନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ଗନୁମ୍‌ତେଲୋଙନ୍‌ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଗାଲିଲିରେଙନ୍‌ ଜିରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","କି ନାଜରିତ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ଇୟ୍‌ଲେ ଡକୋନେଜି, ତିଆସନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆବର୍ରନେନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, “ଆନିନ୍‌ଆଡଙ୍‌ ନାଜରିତବାୟ୍‌ ଗାମ୍‌ଲେ ଓଡ୍ଡେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ତିଆଡିଡ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଜିଉଦା ଡେସାନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ଅପ୍ପୁଙ୍‌ବରେ । ");
INSERT INTO juy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ଆନିନ୍‌ ଗାମେନ୍‌, “ଇର୍ସେନ୍‌ ସିଲଡ୍‌ ୟର୍ନାୟ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ତୁୟାଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଆ ବର୍ନେ କେନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ ବର୍ରନେ, ତି ଆ ମନ୍‌ରା କେନ୍‌ଆନିନ୍‌; “ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଆକ୍ରାନ୍‌ ଆବ୍ରାବ୍ବାବ୍‌ତେନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ ସର୍ରଙ୍‌ ସଡ୍ଡାତେ, ପ୍ରବୁନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ଅବ୍‌ଜାଡାବା, ଆନିନ୍‌ ଆସନ୍‌ ରୋତ୍ତନ୍‌ ବିଙୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ଜନନ୍‌ ଓଟପୁରନ୍‌ ବାତ୍ତେ ଆତୁବ୍‌ତୁବନ୍‌ ଆ ଅଙ୍ଗି ରଲନେ ଆରି ଆ କୁଣ୍ଡୁବ୍‌ଲୋଙନ୍‌ ଉସାଲ୍‌ ଜନିଡୁବନ୍‌ ରେଡ୍ଡୁବ୍‌ଲନେ, ଆରି ଆନିନ୍‌ ପପ୍ପରନ୍‌ ଡ କିନ୍‌ରେଙ୍‌ ଇଁଙ୍‌ରଡନ୍‌ ଜୋମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ତିଆଡିଡ୍‌ ଜିରୁସାଲମନ୍‌ ଡ ସମ୍ପରା ଜିଉଦା ଡେସାନ୍‌ ସିଲଡ୍‌, ଆରି ଜର୍ଦନ ଅଲନ୍‌ ଆ ତୁୟାୟ୍‌ରେଙ୍‌ ସମ୍ପରାନ୍‌ ଆ ମନ୍‌ରାଜି ଜନନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ଆରି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଇର୍ସେ ବର୍ରନ୍‌ ଜନନ୍‌ ଆସିଲୋଙ୍‌ ସିଲଡ୍‌ ଜର୍ଦନ ଅଲଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତବ୍ବୁବ୍‌ଡାନେଜି । ");
INSERT INTO juy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ଆରି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ପାରୁସିଞ୍ଜି ଡ ସାଦୁକିଞ୍ଜି ତବ୍ବୁବ୍‌ଡାନେନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାଜି, ତିଆସନ୍‌ କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ଜନନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ବିସଜଡନ୍‌ ଆ କେଜ୍ଜାଜି, ବିଅଜି ଆଜିର୍ତାଞନ୍‌ ଆ ବନ୍‌ଡ୍ରାବ୍‌ ସିଲଡ୍‌ ଅବ୍ବଡ଼ୁର୍‌ନେନ୍‌ ଆସନ୍‌ ଆନା ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ସେତ୍ତାଲବେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ତିଆସନ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଜନ୍‌ ଅବ୍‌ଜଅନାବା । ");
INSERT INTO juy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ଆରି ଅବ୍ରାମନ୍‌ ତ ପୁର୍ବା ଜୋଜୋଲେନ୍‌ ତିଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ସିଲଡ୍‌ ଅଡ଼ୁର୍‌ତଲେନ୍‌ ଗାମ୍‌ଲେ ଏବ୍‌ଡିସୟ୍‌ଡଙ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ୱରନ୍‌ କେନ୍‌ ଅରେଙଞ୍ଜି ସିଲଡ୍‌ ଅବ୍ରାମନ୍‌ ଆସନ୍‌ ପସିଜଞ୍ଜି ଅମ୍‌ଡୁଙ୍‌ଲେ ରପ୍ତିତେ । ");
INSERT INTO juy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ଆରି ନମି ନିୟ୍‌ ଅରାନୁବଞ୍ଜି ଆଜଡ୍‌ଲୋଙ୍‌ ଏଞ୍ଜୁମନ୍‌ ଆଡକ୍କୋ; ତିଆସନ୍‌ ଅଙ୍ଗା ଆରାନୁବ୍‌ ମନଙ୍‌ ଅଃନ୍ନଜଏ, ତିଆତେ ଅଡ୍‌ଲେ ତଗୋଲୋଙନ୍‌ ପନିଡନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ଞେନ୍‌ ସିନା ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନେନ୍‌ ଆସନ୍‌ ଡାଆଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତବେନ୍‌, ବନ୍‌ଡ ଞେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନା ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ ଜବ୍ର ବୋର୍ସା, ଆ ପାଣ୍ଡୋୟନ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌; ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡ ତଗୋଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ଗରୁମ୍‌ଗୁମନ୍‌ ଆସନ୍‌ ଆସିଲୋଙନ୍‌ ଅୟ୍ୟେରନ୍‌ ଡକୋ, ଆନିନ୍‌ ଆ ତନିଲନ୍‌ ଆ ଜନ୍‌ରୋମ୍‌ ଗୁମ୍‌ଗୁମ୍‌ଲେ ମବ୍‌ନଙ୍‌ଲେ ମରଁୟ୍‌ଲୋଙନ୍‌ ତର୍ତୁମ୍‌ଲେ ଡକ୍କୋତେ, ଆରି ଆ ପୋନ୍‌ଲ୍ଲାଞ୍ଜିଆତେ ଅଃପ୍ପଞିଡେନ୍‌ ଆ ତଗୋଲୋଙ୍‌ ସୟ୍‌ଲେ ସେତ୍ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆସିଲୋଙ୍‌ ସିଲଡ୍‌ ତବ୍ବୁବ୍‌ଡାନେନ୍‌ ଆସନ୍‌ ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଜର୍ଦନ ଅଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ବନ୍‌ଡ ଜନନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଅସାଡାଲେ ବର୍ରନେ, “ଆମନ୍‌ ସିନା ଞେନ୍‌ଆଡଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତିଁୟ୍‌, ଆମନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ତବ୍ବୁବ୍‌ଡାନେନ୍‌ ଇୟ୍‌ତାୟ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ବନ୍‌ଡ ଜିସୁନ୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ନମିଞେନ୍‌, ବର୍ନେଲୋଙ୍‌ଞେନ୍‌ ଅଡ଼େଆ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆତେ ବାତ୍ତେ ଇନ୍‌ଲେନ୍‌ ଅଡ଼୍‌କୋ ଡରମ୍ମ କାବ୍ବାଡ଼ାଞ୍ଜି ଲୁମ୍‌ଲେ ରପ୍ତିତବୋ ।” ସିଲତ୍ତେ ଜନନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଅଡ଼େଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ଜିସୁନ୍‌ ଆତ୍ରବ୍ବୁବ୍‌ଡାଲନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଡାଆଲୋଙନ୍‌ ସିଲଡ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଡୋଲନ୍‌ ଜିର୍ରାୟ୍‌, ଆରି ଗିୟ୍‌ବା ! ରୁଆଙନ୍‌ ରୋଲନେ, ଆରି ଇସ୍ୱରନ୍‌ ଆ ପୁରାଡ଼ା କୁକ୍କୁରନ୍‌ ଅନ୍ତମ୍‌ ପଡ୍‌ଲନ୍‌ ଜିସୁନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଆଜିର୍ରାଞନ୍‌ ଆନିନ୍‌ ଗିଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ଆରି ଗିୟ୍‌ବା ! ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ବର୍ନେନ୍‌ ଆ ସର୍ରଙ୍‌ ସଡ୍ଡାଏନ୍‌, “କେନ୍‌ଆନିନ୍‌ ଡନୁଙ୍‌ୟମ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ ଆମଙନ୍‌ ଞେନ୍‌ ମାଡ୍ଡ ମଅଁୟ୍‌ଡାତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ତିଆଡିଡ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଓରୋଙେନ୍‌ । ତେତ୍ତେ ସନୁମନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତୋରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ଆରି ଜିସୁନ୍‌ ବାକୁଡ଼ି ତମ୍‌ବା, ବାକୁଡ଼ି ତଗଲ୍‌ ଆନମନ୍‌ ଡକୋଲନ୍‌, ତିଆସନ୍‌ ଆନିନ୍‌ ତିକ୍କି ଡୋଲେୟ୍‌ଡାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ଆରି, ସନୁମନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଅରେଙଞ୍ଜି ରୁଟିନ୍‌ ଗଡେଲେତୋ ଗାମ୍‌ଲେ ବର୍ନା ।” ");
INSERT INTO juy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ବନ୍‌ଡ ଜିସୁନ୍‌ ସନୁମନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅନିଡଲନ୍‌ ଡକୋ, ‘ମନ୍‌ରାନ୍‌ ସତ୍ତର୍‌ ରୁଟିନ୍‌ ଜୋମ୍‌ଲେ ଅଃନ୍ନମେଙେ, ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆ ତଅଡ୍‌ ସିଲଡ୍‌ ଆଡ୍ରୁଙ୍‌ତନାଞନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ବାତ୍ତେ ଅମେଙ୍‌ତେ ।’” ");
INSERT INTO juy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସନୁମନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ମଡ଼ିର୍‌ ଗଡ଼ାନ୍‌ ଓରୋଙ୍‌ଡାଲେ, ସରେବାସିଙନ୍‌ ଆ ବିଲେଙ୍‌ଲୋଙ୍‌ ତବ୍‌ନଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଜାୟ୍‌ତାନ୍‌ ଅନ୍‌ତିଡ୍‌ନା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅନିଡଲନ୍‌ ଡକୋ, ‘ଆମନ୍‌ଆଡଙ୍‌ ସନାକ୍କେନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ବାଁୟ୍‌ତଜି; ଆରି ଅସମୟ୍‌ ତାଲ୍‌ଜଙ୍‌ନମ୍‌ ଅରେଙ୍‌ଲୋଙନ୍‌ ଗତର୍‌ତେ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ଆସିଲୋଙଞ୍ଜି ତାଣ୍ଡାମ୍‌ଲେ ଞମ୍‌ତମ୍‌ଜି ।’” ");
INSERT INTO juy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ଜିସୁନ୍‌ ସନୁମନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଏନ୍ନେଲେ ନିୟ୍‌ ଅନିଡଲନ୍‌ ଡକୋ, ‘ଆମନ୍‌ ପ୍ରବୁ ଇସ୍ୱରନମ୍‌ଆଡଙ୍‌ ମାଲ୍‌ଡଙେ ।’” ");
INSERT INTO juy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ସନୁମନ୍‌ ଆରି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ଡେଙ୍ଗାଡମ୍‌ ଆ ବରୁଲୋଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଓରୋଙ୍‌ଡାଲେ ପୁର୍ତିନ୍‌ ଆ ରାଜ୍ୟଜି ଡ ତି ଅଡ଼୍‌କୋନ୍‌ ଆରିସୁମ୍‌ଜି ଅବ୍‌ତୁୟ୍‌ଡାଲେ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ତୁଡ଼ୁମ୍‌ଡାଲେ ଲୋମ୍‌ଲିଁୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆମନ୍‌ ତିୟ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ସିଲତ୍ତେ ଜିସୁନ୍‌ ସନୁମନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ସବ୍‌ଙାୟ୍‌ନା ସନୁମ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ‘ଆମନ୍‌ ପ୍ରବୁ ଇସ୍ୱରନମ୍‌ଆଡଙ୍‌ ପୁର୍‌ତେ, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ତୁମ୍‌ ସେଙ୍କେଆ ।’” ");
INSERT INTO juy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ସିଲତ୍ତେ ସନୁମନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିରେନ୍‌, ଆରି ଗିୟ୍‌ବା ! ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଜିର୍ରେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ସେବାଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ବଣ୍ଡିଏଞ୍ଜି ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଆରମ୍‌ଡଙେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଗାଲିଲିନ୍‌ ଜିରେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ଆରି, ଆନିନ୍‌ ନାଜରିତଲୋଙନ୍‌ ଏର୍‌ଡକୋନେନ୍‌ କପର୍ନାଉମ୍‌ ଗଡ଼ାନ୍‌ ଜିର୍ରେ ତେତ୍ତେ ଇୟ୍‌ଲେ ଡକୋନେ, ତି ଆ ଗଡ଼ା ସବୁଲୁନ୍‌ ଡ ନପ୍ତାଲିରେଙନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଗାଲିଲି ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ତିଆସନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ଆବର୍ରନେନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ଜର୍ଦନ ଅଲନ୍‌ ଆ ଅଡିଗଡ୍‌, ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ତୁୟାୟ୍‌ ସବୁଲୁନ୍‌ ଡେସାନ୍‌ ଡ ନପ୍ତାଲି ଡେସାନ୍‌, ଆରି ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆ ଡେସା ଗାଲିଲିନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ଆଲୋଙଡନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ସୋଡ଼ା ସାଆରନ୍‌ ଗିଜେଞ୍ଜି, ଆରି ରନବୁନ୍‌ ଆ ଲୁମ୍ମୁରେଙ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆସନ୍‌ ସନାଆରନ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ତିଆଡିଡ୍‌ ସିଲଡ୍‌ ଜିସୁନ୍‌ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଆସନ୍‌ ଉଲନେ, ଆନିନ୍‌ ଗାମେନ୍‌, “ଇର୍ସେନ୍‌ ସିଲଡ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ତୁୟାଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ଜିସୁନ୍‌ ଗାଲିଲି ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଗଡ୍‌ ତଙିୟ୍‌ଲନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ସିମନନ୍‌ ଡ ଆ ବୋଞାଙନ୍‌ ଆନ୍ଦ୍ରିଅନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି, ଆନିଞ୍ଜି ବାଗୁ ବନୋଞାଙଞ୍ଜି ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଜାଲନ୍‌ ସେଡେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଞମ୍‌ୟମର୍‌ଜି ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ବା, ମନ୍‌ରାଞ୍ଜି ଏଙ୍ଗାଲେ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଅନୋରୋଙନ୍‌ ଡେତେ ତିଆତେ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞଙ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଅବ୍‌ତାଡ଼ନ୍‌ ଜାଲନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ଆରି, ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଡାଅଡିଃ ଜିର୍ରେ ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ଜାକୁବନ୍‌ ଡ ଜନନ୍‌, ବାଗୁ ବନୋଞାଙଞ୍ଜି ଆପେୟଞ୍ଜି ସରିନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଜାଲନ୍‌ ଆବ୍ରୟ୍‌ବଜେଞ୍ଜି ଆଡିଡ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଜି, ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଓଡ୍ଡେଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ଆରି ଆନିଞ୍ଜି ଅବ୍‌ତାଡ଼ନ୍‌ ଡୋଙ୍ଗାନ୍‌ ଡ ଆପେୟଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ଆରି ଜିସୁନ୍‌ ସମ୍ପରା ଗାଲିଲିନ୍‌ ବୁଲ୍ଲେଲେ ରନୁକ୍କୁସିଂରେଙଞ୍ଜି ଞନଙନ୍‌ ତିୟେନ୍‌; ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ମନଙ୍‌ବର୍‌ ଅପ୍ପୁଙ୍‌ବରେନ୍‌, ଆରି ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ରୋଗମର୍‌ଜି, ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ବମ୍ୱମ୍‌ନେମର୍‌ଜିଆଡଙ୍‌ ମବ୍‌ନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ଆରି ଜିସୁନ୍‌ ଆ ବର୍ନେ ସମ୍ପରା ସୁରିଆ ଡେସାନ୍‌ ବୁର୍ବୁରାୟ୍‌ଲନେ, ଆରି ମନ୍‌ରାଞ୍ଜି ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରା, କୁଣ୍ଡୁଲିଆମରନ୍‌, କାନ୍ନିମରନ୍‌, ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ରୋଗଲୋଙ୍‌ ବମ୍ବମ୍‌ନେମରନ୍‌ ଆରି ବତ୍ତାନ୍‌ବଇନ୍‌ ଆଡ୍ରେଏଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି, ଆରି ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ଆରି ଗାଲିଲିନ୍‌, ଦେକାପଲିନ୍‌, ଜିରୁସାଲମନ୍‌, ଜିଉଦା ଡେସାନ୍‌ ଡ ଜର୍ଦନ ଅଲନ୍‌ ଆ ଅଡିଗଡ୍‌ ଆ ମନ୍‌ରାଜି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ଜିସୁନ୍‌ ଆକୁଡ଼ାୟ୍‌ମରଞ୍ଜି ଆଗ୍ରିଜେନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ ବରୁଲୋଙନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲେ ତଙ୍କୁମେ, ଆରି ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙନ୍‌ ଜିର୍ରାଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ, ");
INSERT INTO juy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ପୁରାଡ଼ାଲୋଙନ୍‌ ଡୋଲେୟ୍‌ମରଞ୍ଜି ସନେନ୍‌ସେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଆନିଞ୍ଜିଆତେ । ");
INSERT INTO juy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ୟେୟେଡାମରଞ୍ଜି ସନେନ୍‌ସେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ବନବ୍‌ୟୋନ୍‌ ଞାଙ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ଲଗଡ୍‌ ବୁଡ୍ଡିମରଞ୍ଜି ସନେନ୍‌ସେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଅଙ୍ଗାତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ବାସାଏଞ୍ଜି ତିଆତେ ଆନିଞ୍ଜି ଞାଙ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ଇସ୍ୱରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ କାବ୍ବାଡ଼ାନେନ୍‌ ଆସନ୍‌ ଆର୍‌ଲଡୟ୍‌ତେଞ୍ଜି ଆ ମନ୍‌ରାଜି ସନେନ୍‌ସେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ବୋଓତଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ସନାୟୁମ୍‌ମରଞ୍ଜି ସନେନ୍‌ସେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ସନାୟୁମନ୍‌ ଞାଙ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ମଡ଼ିର୍‌ ଉଗର୍‌ମରଞ୍ଜି ସନେନ୍‌ସେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ଅନବ୍‌ମାୟ୍‌ମାୟ୍‌ମରଞ୍ଜି ସନେନ୍‌ସେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ଅନ୍‌ଜି ଗାମ୍‌ଲେ ଅନୋଡ୍ଡେନ୍‌ ଡେତଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ଇସ୍ୱରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ କାବ୍ବାଡ଼ାଡାଲନ୍‌ ଡନଣ୍ଡାୟନ୍‌ ଆଞ୍ରାଙ୍‌ତେଞ୍ଜି ଆ ମନ୍‌ରାଜି ସନେନ୍‌ସେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଆନିଞ୍ଜିଆତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ଆଙ୍ଗାଆଡିଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଲତ୍ତେଙ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଗବ୍‌ରୟ୍‌ତବେଞ୍ଜି, ଡଣ୍ଡାୟ୍‌ତବେଞ୍ଜି ଆରି କାଜ୍ଜାନ୍‌ ପରାନ୍‌ସାତ୍ତିନ୍‌ ଆ ବର୍ନେଜି ବିରୁଦଲୋଙ୍‌ବେନ୍‌ ବର୍ତଞ୍ଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ସନେନ୍‌ସେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ସର୍ଡାନାବା ଆରି ମଅଁୟ୍‌ନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେନ୍‌ ଆସନ୍‌ ବର୍ତନ୍ନାନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ଆଡକ୍କୋ; ଆମ୍ୱେଞ୍ଜି ସିଲଡ୍‌ ଆମ୍ମୁଙ୍‌ ଆ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ଜିଆଡଙ୍‌ ଆନିଞ୍ଜି ଏତ୍ତେଲେମା ଡଣ୍ଡାୟେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ଆମ୍ୱେଞ୍ଜି ପୁର୍ତିନ୍‌ ଆ ମନ୍‌ରାଜି ଆସନ୍‌ ବସିଡନ୍‌ ଅନ୍ତମ୍‌, ବନ୍‌ଡ ବସିଡନ୍‌ ମରେଡ୍‌ ତଡ୍‌ ଡେନ୍‌, ତିଆତେ ଆରି ଏଙ୍ଗାଲେ ମବ୍‌ରେଡ୍‌ତବୋ ? ତିଆତେ ଆରି ଇନ୍ନିଙ୍‌ ବରାଁୟ୍‌ବାଁୟ୍‌ ତଡ୍‌, ତିଆତେ ଡୁଆରାନ୍‌ ସେଡ୍‌ତବୋ ଆରି ମନ୍‌ରାଞ୍ଜି ତିଆତେ ଞାଡାତଜି ଞାସଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“ଆମ୍ୱେଞ୍ଜି ପୁର୍ତିନ୍‌ ଆ ସନାଆର୍‌ । ତୋଣ୍ଡୋ ବରୁଲୋଙନ୍‌ ଆ ଗଡ଼ା ସଲନ୍‌ ଡକୋଲନ୍‌ ଅଃର୍ରପ୍ତିଏ; ");
INSERT INTO juy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ଆରି, ମନ୍‌ରାଞ୍ଜି ପିଙ୍କନ୍‌ ତର୍ରେ ମାଡ଼ିଞନ୍‌ ଆ ଜାୟ୍‌ତା ଅଃଡ୍ଡକ୍କୋଏଜି, ତିଆତେ ପିଙ୍କପିଲନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଡକ୍କୋତଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଅସିଙନ୍‌ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ଅବ୍‌ସାଆର୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ତିଅନ୍ତମ୍‌ ସନାଆର୍‌ବେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଗିୟ୍‌ତାଏତୋ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ମନଙ୍‌ କାବ୍ବାଡ଼ାବେନ୍‌ ଗିୟ୍‌ଲେ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍ଆଡଙ୍‌ ଆନିଞ୍ଜି ସେଙ୍କେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ଞେନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ କି ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ଞନଙ୍‌ ମନାବ୍‌ୟାନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏବ୍‌ଡିସୟ୍‌ଡଙ୍‌; ମନାବ୍‌ୟାନ୍‌ ଆସନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌ ଆର୍ପାୟ୍‌ ଅନବ୍‌ଡେଡମ୍‌ନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ଜାୟ୍‌ ରୁଆଙନ୍‌ ଡ ପୁର୍ତିନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ମାୟାଏ, ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଡେଡମେନ୍‌ ଜାୟ୍‌ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ସିଲଡ୍‌ ବତନିଙ୍କାୟ୍‌ କି ବଜନବ୍‌ତଡ୍‌ ନିୟ୍‌ ଅଃମ୍ମାୟାଏ । ");
INSERT INTO juy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ତିଆସନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା କେନ୍‌ ଅଡ଼୍‌କୋ ବନାଞଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅନ୍ନିଙ୍‌ଆତେ ଅବୟ୍‌ ସନ୍ନା ବନାଞନ୍‌ ଆଲ୍ଲେତେ ଆରି ଏତ୍ତେଲେମା ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଆସନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ତେ, ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ଆନିନ୍‌ ସନ୍ନାଡମ୍‌ ଗାମ୍‌ଲେ ଓଡ୍ଡେତଜି; ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ତି ଅଡ଼୍‌କୋ ବନାଞନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ତନେ ଆରି ଏତ୍ତେଲେମା ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଆସନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ତେ, ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ଆନିନ୍‌ ସୋଡ଼ାଡମ୍‌ ଗାମ୍‌ଲେ ଓଡ୍ଡେତଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ଏଙ୍ଗାଲେ ଡରମ୍ମ କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ତଜି, ଆନିଞ୍ଜି ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଆରି ଗୋଗୋୟ୍‌ ଡରମ୍ମ କାବ୍ବାଡ଼ାନ୍‌ ଏଃଲ୍ଲୁମ୍‌ଲୋ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲେ ଜନଙ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ଗନ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ଆମ୍ୱେଞ୍ଜି ଏଅମ୍‌ଡଙେନ୍‌, ପୁର୍ବାନ୍‌ ଆ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବନରନ୍‌ ଡେଲୋ, ‘ମନ୍‌ରାନ୍‌ ଏରବ୍ବୁଡଙ୍‌, ଆରି ଆନା ମନ୍‌ରାନ୍‌ ରବ୍ବୁତେ, ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ପନ୍‌ସୁଆତିନ୍‌ ଡେତେ ।’ ");
INSERT INTO juy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ମନ୍‌ରା ଆ ବୋଞାଙନ୍‌ଆଡଙ୍‌ କାଜ୍ଜାନ୍‌ ବବ୍‌ରାବ୍‌ତେ, ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଅବ୍‌ପନ୍‌ସୁଆତିତନେ । ଆରି ଅଙ୍ଗା ମନ୍‌ରା ଆ ବୋଞାଙନ୍‌ଆଡଙ୍‌ ‘ଉଲ୍ଲୁ’ ଗାମ୍‌ତେ, ଆନିନ୍‌ଆଡଙ୍‌ ସୋଡ଼ା ପନ୍‌ସୁଆତିସିଂଲୋଙନ୍‌ ଅବ୍‌ପନ୍‌ସୁଆତିତନେ; ଆରି ଅଙ୍ଗା ମନ୍‌ରା ‘ବୁଡ୍ଡି ତଡ୍‌’ ଗାମ୍‌ତେ, ଆନିନ୍‌ ତଗୋନ୍‌ ଆବରିଜନ୍‌ ଆ ନରକଲୋଙ୍‌ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ତିଆସନ୍‌, ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆସନ୍‌ ତନମ୍ପିଲ୍‌ବାନ୍‌ ଅନମଙନ୍‌ ଏପାଙ୍‌ଲାୟ୍‌ ଆଡିଡ୍‌ ବୋଞାଙ୍‌ବେନ୍‌ ବୟନ୍‌ ଅନ୍ନିଙ୍‌ ଅବୟ୍‌ ବର୍ନେଲୋଙନ୍‌ ଅଲ୍‌ସଙ୍ଗତ୍ତାନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ଏମନ୍ନେଏନ୍‌ ଡେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତନମ୍ପିଲନ୍‌ ଆ ମୁକ୍କାଗଡ୍‌ ତେତ୍ତେନ୍‌ ଅନମଙ୍‌ବେନ୍‌ ଡକ୍କୋଡାଲେ ଜିର୍ବା, ଆମ୍ମୁଙ୍‌ ବୋଞାଙ୍‌ବେନ୍‌ ବୟନ୍‌ ଇୟ୍‌ ମାୟ୍‌ମାୟ୍‌ନାବା ରୟ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତିକ୍କି ଅନମଙ୍‌ବେନ୍‌ ଆୟ୍‌ ତିୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ଅଲ୍‌ବାଡ୍ଡିମର୍‌ବେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ସଦରନ୍‌ ଓରୋଙ୍‌ଲବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସଦରନ୍‌ ଏଜିର୍ତେନ୍‌ ଆଡିଡ୍‌ ତଙର୍‌ଲୋଙନ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ଲମାୟ୍‌ମାୟ୍‌ନାବା, ଅସମୟ୍‌ ଅଲ୍‌ବାଡ୍ଡିମର୍‌ବେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ପନ୍‌ସୁଆତିମରନ୍‌ ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତବେନ୍‌, ଆରି ପନ୍‌ସୁଆତିମରନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ସିପ୍ପାୟଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତବେନ୍‌, ସିପ୍ପାୟଞ୍ଜି ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକ୍କୋତବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଅନଞିଡ୍‌ ତନଣ୍ଡେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏସୁଜ୍ଜାୟ୍‌ନେନ୍‌ ଜାୟ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଏଙ୍ଗାଲେ ଜନଙ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଏଃର୍ରପ୍ତିଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ଆମ୍ୱେଞ୍ଜି ‘ଏଡାରିଡଙ୍‌ନେ,’ ଗାମ୍‌ଲେ ଏଅମ୍‌ଡଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ମନ୍‌ରା ପରାନ୍‌ସାତ୍ତିନ୍‌ ଇୟମ୍‌ଡାଲେ ଅନ୍ନିଙ୍‌ ଆଇବୟ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ମଡ୍‌ତେ, ଆନିନ୍‌ ତି ଆଇମରନ୍‌ ବୟନ୍‌ ଆ ମନ୍ନଲୋଙନ୍‌ ଡାରିଲନେ । ");
INSERT INTO juy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ଆରି, ଅର୍ଜଡ଼ୋମ୍‌ମଡ୍‌ବେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଗବ୍‌ଲୋଲବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ତବ୍‌ଲେ ସେଡ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସମ୍ପରା ଡଅଙ୍‌ବେନ୍‌ ନରକଲୋଙନ୍‌ ଆରସେଡ୍‌ତବେନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ମିୟ୍‌ମଡ୍‌ ମୋସ୍ସାଏତୋ । ");
INSERT INTO juy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଆରି, ଅର୍ଜଡ଼ୋମ୍‌ସିବେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଗବ୍‌ଲୋଲବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଡେୟ୍‌ଲେ ସେଡ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସମ୍ପରା ଡଅଙ୍‌ବେନ୍‌ ନରକଲୋଙନ୍‌ ଆରସେଡ୍‌ତବେନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ମିୟ୍‌ସି ମୋସ୍ସାଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ଆରି ବର୍ନେନ୍‌ ଡକୋ, ‘ଅଙ୍ଗା ମନ୍‌ରା ଆ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ଡୁଙ୍‌ତେ, ତି ଆ ମନ୍‌ରା ଆ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙଲନ୍‌ ତିୟେତୋ ।’ ");
INSERT INTO juy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ମନ୍‌ରା ଆ ଡୁକ୍ରିନ୍‌ ଅଃଡ୍ଡାରିଲନ୍‌ ଜନଙ୍‌ଡେନ୍‌ ଆନ୍ନା ଡୋସା ଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ଡୁଙ୍‌ତେ, ତି ଆ ମନ୍‌ରା ଆ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଡାରିନେତେ, ଆରି ଆନା ଆଡୁଙ୍‌ନେବଜନ୍‌ ବିବାତନେ, ଆନିନ୍‌ ଡାରିତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ଆରି ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜି ଅମ୍‌ଡଙ୍‌ଲେ ଏଜିର୍ରାୟ୍‌, ପୁର୍ବାନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଏନ୍ନେଲେ ବନରନ୍‌ ଡେଲୋ, ‘ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ଅଙ୍ଗାତେ ଏପର୍ମାଡ଼ାଲନ୍‌ ତିଆତେ ଲୁମ୍‌ବା, ପର୍ମାଡ଼ାବେନ୍‌ ଏଆଲ୍ଲେଡଙେ ।’ ");
INSERT INTO juy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆଙ୍ଗିୟ୍‌ ଏପର୍ମାଡ଼ାଡଙ୍‌ନେ, ରୁଆଙନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଏପର୍ମାଡ଼ାଡଙ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆତେ ଇସ୍ୱରନ୍‌ ଆ ତରଙ୍କୁମ୍‌; ");
INSERT INTO juy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ପୁର୍ତିନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଏପର୍ମାଡ଼ାଡଙ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆତେ ଇସ୍ୱରନ୍‌ ଆ ଡରକ୍କୋଜଙ୍‌; ଜିରୁସାଲମନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଏପର୍ମାଡ଼ାଡଙ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆତେ ସୋଡ଼ା ରାଜାନ୍‌ ଆ ଗଡ଼ା; ");
INSERT INTO juy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ଆରି ଅବବ୍‌ଲୋଙ୍‌ବେନ୍‌ ଏପର୍ମାଡ଼ାଡଙ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତେତ୍ତେ ଆ ଉଉ ଅବୟ୍‌ ଓୟ୍‌ଲେ ଅବ୍‌ୟଗାଲେ କି ଅବ୍‌ଜେଏଲେ ଏଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ବନ୍‌ଡ ‘ଓଓ’ କଡାଡ଼ିବେନ୍‌ ‘ଓଓ’ ଡେଏତୋ, ‘ଇଜ୍ଜା’ କଡାଡ଼ିନ୍‌ ‘ଇଜ୍ଜା’ ଡେଏତୋ; ଡିୟ୍‌ନେ ସିଲଡ୍‌ ଅଙ୍ଗାତେ ଆରି ଗୋଗୋୟ୍‌ତେ, ତିଆତେ ପରାନ୍‌ସାତ୍ତିନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ଏନ୍ନେଲେ ବର୍ନେନ୍‌ ଡକୋ, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଆଅମ୍‌ଡଙ୍‌ଜି, ‘ଅମଡନ୍‌ ଆସନ୍‌ ଅମଡନ୍‌ ଆରି ଅଜିନ୍‌ ଆସନ୍‌ ଅଜିନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ପେଲ୍ଲାମରନ୍‌ଆଡଙ୍‌ ଏଡଙ୍‌ଡଙେ, ଆର୍ପାୟ୍‌ ଆନା ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ କୋତାୟ୍‌ତମ୍‌ଲୋଙ୍‌ବେନ୍‌ ତିଡ୍‌ତବେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଆରି ମିୟ୍‌ତାଲ୍‌ଗଡ୍‌ ଆ କୋତାୟ୍‌ତମ୍‌ ନିୟ୍‌ ଅବ୍‌ତୁୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ଆରି ଆନ୍ନିଙ୍‌ ଅବୟ୍‌ନେ ସିନ୍‌ରିବେନ୍‌ ପାଙ୍‌ପାଙନ୍‌ ଆସନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ କେସୁଡାଲେ ପନ୍‌ସୁଆତିଲୋଙନ୍‌ କାୟ୍‌କାୟେନ୍‌ ଡେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ମାଟବେନ୍‌ ନିୟ୍‌ ତିୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ଆରି ଅନ୍ନିଙ୍‌ ଅବୟ୍‌ ସିପ୍ପାୟନ୍‌ ଆ ଜନିରାନ୍‌ ବୋୟ୍‌ଲେ ଆମ୍ବେନ୍‌ଆଡଙ୍‌ ବଡଗାଁୟ୍‌ ବକୋସ ଆ ତଙର୍‌ ପାଙା ଗାମେନ୍‌ ଡେନ୍‌, ଆନିନ୍‌ ସରିନ୍‌ ବାଗୁ କୋସ ଜିର୍ବା । ");
INSERT INTO juy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ଆନା ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ବେଡ୍‌ତବେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ବା, ଆରି ଆନା ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ରେୟାନ୍‌ ବେଡ୍‌ତବେନ୍‌, ଆନିନ୍‌ ଏଅସାଡଙ୍‌, ଆନିନ୍‌ ତିୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ଗଡ଼ିବେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ବା, ଆରି ବନେରାବେନ୍‌ଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ବା, ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଆଅମ୍‌ଡଙ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ବନେରାବେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ବା, ଆରି ଆନାଜି ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଡଣ୍ଡାୟ୍‌ତବେଞ୍ଜି, ଆନିଞ୍ଜି ଆସନ୍‌ ପାର୍ତନାନାବା, ");
INSERT INTO juy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ଆଅନ୍‌ଜି ଡେତବେନ୍‌; ଆନିନ୍‌ ପେଲ୍ଲାମରଞ୍ଜି ଡ ମନଙ୍‌ମରଞ୍ଜି ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଆ ଓୟୋଙନ୍‌ ଅବ୍‌ଡୁଙ୍‌ନେତେ, ଆରି ଆନିନ୍‌ ଡରମ୍ମମରଞ୍ଜି ଡ ଏର୍‌ଡରମ୍ମମରଞ୍ଜି ଆସନ୍‌ ତରୁବନ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ଆରି, ଆନାଜି ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତବେଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ତୁମ୍‌ ଏଡୁଙ୍‌ୟମେଞ୍ଜି ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଇନି ଆ ପୁରସ୍କାର ଏଞାଙ୍‌ତେ ? ପାନୁବେଡ୍‌ମରଞ୍ଜି ନିୟ୍‌ ତିଆତେ ଅଃଲ୍ଲୁମେଜି ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ଆରି, ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ବୋଞାଙ୍‌ବେଞ୍ଜିଆଡଙ୍‌ ତୁମ୍‌ ଏଲୋମେଞ୍ଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନି ଆରି ଗୋଗୋୟ୍‌ ଏଲୁମ୍‌ତେ ? ଏର୍‌ଡର୍ନେମରଞ୍ଜି ନିୟ୍‌ ତିଆତେ ଅଃଲ୍ଲୁମେଜି ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ତିଆସନ୍‌, ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ଏଙ୍ଗାଲେ ସତଙ୍‌, ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେ ସବ୍‌ତଙ୍‌ନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ଗିୟ୍‌ଡମ୍‌ନାବା, ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡମ୍‌ନେନ୍‌ ଆସନ୍‌ ଆତେମଡଞ୍ଜି ଡରମ୍ମ କାବ୍ବାଡ଼ାନ୍‌ ଏଲୁମ୍‌ଡଙ୍‌, ଆମ୍ୱେଞ୍ଜି ଏତ୍ତେଲେ ଏଲୁମେନ୍‌ ଡେନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ପୁରସ୍କାରନ୍‌ ଏଃଞାଙେ ।” ");
INSERT INTO juy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ତିଆସନ୍‌ ତନିୟ୍‌ତିୟନ୍‌ ଏତିୟେନ୍‌ ଆଡିଡ୍‌, ଇସ୍କତ୍ତାମରଞ୍ଜି ଅନ୍ତମ୍‌ ବର୍ରେଙ୍‌ଲେ ଏପାଙ୍‌ଡଙ୍‌, ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ଡ ଡାଣ୍ଡରେଙନ୍‌ ଏତ୍ତେତଞ୍ଜି । ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆନିଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ବଡି ଞାଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ତନିୟ୍‌ତିୟନ୍‌ ଏତିୟେନ୍‌ ଆଡିଡ୍‌ ଅର୍ଜଡ଼ୋମ୍‌ସିବେନ୍‌ ଇନି ଲୁମ୍‌ତେ, ତିଆତେ ଅର୍କାବଡ଼ିସିବେନ୍‌ ଜନାଡଙେ ତଡ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତନିୟ୍‌ତିୟ୍‌ବେନ୍‌ ଏରବ୍‌ଜନାନ୍‌ ଏତିୟେନ୍‌ ଜନଙ୍‌ଡେନ୍‌, ଆପେୟ୍‌ବେନ୍‌ ତିଆତେ ଅଜନା ଗିୟ୍‌ଲେ, ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ପୁରସ୍କାରନ୍‌ ତିୟ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ପାର୍ତନାନେନ୍‌ ଆଡିଡ୍‌ ଇସ୍କତ୍ତାମରଞ୍ଜି ଅନ୍ତମ୍‌ ଡେଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡମ୍‌ନେନ୍‌ ଆସନ୍‌ ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ଡ ସାଇନ୍‌ ଆ କୁନେରେଙ୍‌ ତନଙ୍‌ଡାଲେ ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ତଜି; ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆନିଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ କାବ୍ବାଡ଼ା ଆ ବଡି ଞାଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ଆସସସିଂଲୋଙନ୍‌ ଗନ୍ନାବା, ଆରି ସନଙନ୍‌ ଇଙଡ୍‌ଲେ ଏର୍‌ନବ୍‌ଗିୟ୍‌ତାନେନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ଆମଙ୍‌ ପାର୍ତନାନାବା; ଆରି ଆପେୟ୍‌ବେନ୍‌ ଅଜନା ଗିୟ୍‌ଲେ, ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ପୁରସ୍କାରନ୍‌ ତିୟ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ଆରି, ପାର୍ତନାନେନ୍‌ ଆଡିଡ୍‌ ଏର୍‌ଡର୍ନେମରଞ୍ଜି ଅନ୍ତମ୍‌ ଏର୍‌ଗନଲ୍ଲୁଡନ୍‌ ଆ ବର୍ନେଜି ଏବର୍‌ଡଙ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗୋଗୋୟ୍‌ ପାର୍ତନାଲଞ୍ଜି ଡେନ୍‌ ଆ ଇସ୍ୱରଞ୍ଜି ଆ ପାର୍ତନାଞ୍ଜି ଅମ୍‌ଡଙ୍‌ତେ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଅବ୍‌ଡିସୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ଆମ୍ୱେଞ୍ଜି ଆନିଞ୍ଜି ଅନ୍ତମ୍‌ ଡେଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଇନି ସନାୟ୍‌ସାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ଏବେଡେନ୍‌ ଆମ୍ମୁଙ୍‌ ଆପେୟ୍‌ବେନ୍‌ ତିଆତେ ଜନା । ");
INSERT INTO juy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ତିଆସନ୍‌, ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଅନ୍ତମ୍‌ ପାର୍ତନାନାବା, ‘ଏ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ଲେନ୍‌, ଅଞୁମ୍‌ନମ୍‌ ମଡ଼ିର୍‌ ଗାମ୍‌ଲେ ମନାନ୍ନେନ୍‌ ଡେଏତୋ । ");
INSERT INTO juy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ରାଜ୍ୟନମ୍‌ ଜିରାୟ୍‌ତୋ । ଏଙ୍ଗାଲେ ରୁଆଙ୍‌ଲୋଙନ୍‌, ତିଅନ୍ତମ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଇସ୍ସୁମ୍‌ନମ୍‌ ଡେଏତୋ । ");
INSERT INTO juy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ଲଙେ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ସନାୟ୍‌ସାୟ୍‌ ଜନୋମ୍‌ଜୋମ୍‌ଲେନ୍‌ ତିୟ୍‌ଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ଇନ୍‌ଲେଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଡୋସାମର୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଏକେମାତାଜି, ଏତ୍ତେଲେ ଆମନ୍‌ ଡୋସାଲେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ କେମାଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ମନାଲ୍‌ମାଲ୍‌ବାନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଓରୋଙ୍‌ଡଙ୍‌ଲେନ୍‌, ଆର୍ପାୟ୍‌ ଏର୍‌ମନଙନ୍‌ ସିଲଡ୍‌ ଡୋବ୍‌ଲେନ୍‌ । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରାଜ୍ୟନ୍‌, ବୋର୍ସାନ୍‌ ଡ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆଏଡ଼ର୍‌ ଆମନ୍‌ଆତେ ଆମେନ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ଆମ୍ୱେଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆ ଡୋସା ଏକେମାଏନ୍‌ ଡେନ୍‌, ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ କେମାତବେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଏଃକ୍କେମାଲଜି ଡେନ୍‌, ଆପେୟ୍‌ବେନ୍‌ ନିୟ୍‌ ଡୋସାବେଞ୍ଜି ଅଃକ୍କେମାବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ଏଆନମ୍‌ଲନ୍‌ ଆଡିଡ୍‌ ଇସ୍କତ୍ତାମରଞ୍ଜି ଅନ୍ତମ୍‌ ଅବ୍‌ସର୍‌ମୁକ୍କାଲନ୍‌ ଏଡକୋଡଙ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆନମ୍‌ତଞ୍ଜି ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡମ୍‌ନେନ୍‌ ଆସନ୍‌ ଆ ମୁକ୍କାଞ୍ଜି ବପରାନ୍‌ସାତ୍ତିନ୍‌ ଏମ୍ମେତଞ୍ଜି; ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆନିଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ବଡି ଞାଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଆନମ୍‌ଲନ୍‌ ଆଡିଡ୍‌ ଅବବ୍‌ଲୋଙ୍‌ବେନ୍‌ ମିଞଲନ୍‌ ଜଡ୍‌ନାବା, ଆରି ଆମଡ୍‌ନାବା, ");
INSERT INTO juy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଆନମ୍‌ତନ୍‌ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଅଃଜ୍ଜନାଏଜି ଆର୍ପାୟ୍‌ ଏର୍‌ନବ୍‌ଗିୟ୍‌ତାନେନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ତିଆତେ ଗିୟ୍‌ତବେନ୍‌; ଆରି ଆପେୟ୍‌ବେନ୍‌ ଅଜନା ଗିୟ୍‌ଲେ, ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ପୁରସ୍କାରନ୍‌ ତିୟ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ଆମ୍ୱେଞ୍ଜି ପୁର୍ତିଲୋଙନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ରନ୍ନାନ୍‌ ଏତର୍ତୁମ୍‌ଡଙ୍‌, ତେତ୍ତେ ତିଆତେ ବୋବ୍ବୋଡନ୍‌ ଜୋମ୍‌ତେ, ଜୋମ୍‌ତଡ୍‌ତେ, ଆରି ରାଉମରଞ୍ଜି ପିଡ଼ିନ୍‌ ପାଲ୍ଲେ ତିଆତେ ରାଉଲନ୍‌ ପାଙ୍‌ତଜି; ");
INSERT INTO juy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ଆର୍ପାୟ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ରନ୍ନାନ୍‌ ତର୍ତୁମ୍‌ବା, ତେତ୍ତେ ତିଆତେ ବୋବ୍ବୋଡନ୍‌ ଅଃଜ୍ଜୋମେ କି ଅଃଜ୍ଜୋମ୍‌ତଡେ ଆରି ରାଉମରଞ୍ଜି ପିଡ଼ିନ୍‌ ପାଲ୍ଲେ ତିଆତେ ରାଉଲନ୍‌ ଅଃପ୍ପାଙେଜି । ");
INSERT INTO juy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ରନ୍ନାବେନ୍‌ ଡକୋତେ, ମନ୍ନବେନ୍‌ ନିୟ୍‌ ତେତ୍ତେ ଡକୋତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ଅମଡନ୍‌ ଡଅଙନ୍‌ ଆ ପିଙ୍କ ଅନ୍ତମ୍‌ । ତିଆସନ୍‌ ଅମଡ୍‌ବେନ୍‌ ମନଙ୍‌ ଡକୋଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସମ୍ପରା ଡଅଙ୍‌ବେନ୍‌ ସାଆର୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ବନ୍‌ଡ ଅମଡ୍‌ବେନ୍‌ ମନଙ୍‌ ତଡ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସମ୍ପରା ଡଅଙ୍‌ବେନ୍‌ ଲୋଙଡ୍‌ତେ । ତିଆସନ୍‌ ଅମ୍ମଲୋଙ୍‌ବେନ୍‌ ଆ ପିଙ୍କ ଲୋଙଡେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତି ଆ ଲୋଙଡ୍‌ ଡିଅଙ୍ଗା ଆ ବରନ୍ତଙ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ଅନ୍ନିଙ୍‌ ଆ ମନ୍‌ରା ବାଗୁ ସାଉକାରନ୍‌ ଆ କମ୍ୱାରିମର୍‌ ଡେଲେ ଅଃର୍ରପ୍ତିଏ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତେ ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ, ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ଅବୟ୍‌ନେ ଆ ବର୍ନେ ମାନ୍ନେତେ ଆରି ଅବୟ୍‌ନେ ଆ ବର୍ନେ ଆଲ୍ଲେତେ । ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଡ ତଙ୍କାନ୍‌ ବାଗୁଞ୍ଜି ଆ କମ୍ୱାରିମର୍‌ ଡେଲେ ଏଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇନି ଏଜୋମାୟ୍‌ ଅଡ଼େ ଇନି ଏଗାଆୟ୍‌, ଏନ୍ନେଲେ ଇୟମ୍‌ଡାଲେ ଅନମେଙ୍‌ବେନ୍‌ ଆସନ୍‌, ଅଡ଼େ ଇନି ଏଜିିଜିନାୟ୍‌, ଏନ୍ନେଲେ ଇୟମ୍‌ଡାଲେ ଡଅଙ୍‌ବେନ୍‌ ଆସନ୍‌ ନିୟ୍‌ ଏଇଃୟମ୍‌ଡଙ୍‌ । ଜନୋମ୍‌ଜୋମନ୍‌ ସିଲଡ୍‌ ପରାନ୍ନାନ୍‌ ସୋଡ଼ା ତଡ୍‌ ପଙ୍‌ ? ଆରି ସିନ୍‌ରିନ୍‌ ସିଲଡ୍‌ ଡଅଙନ୍‌ ସୋଡ଼ା ତଡ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ରୁଆଙନ୍‌ ଆ ଅନ୍ତିଡ୍‌ଜି ଗିୟ୍‌ବା, ଆନିଞ୍ଜି ଅଃବ୍ବୁଡେଜି କି ଅଃଗଡେଜି, ମରଁୟ୍‌ଲୋଙନ୍‌ ତର୍ତୁମ୍‌ଲେ ଅଃଡ୍ଡକ୍କୋଏଜି, ବନ୍‌ଡ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜନୋମ୍‌ଜୋମନ୍‌ ତିୟ୍‌ତଜି । ତି ଆ ଅନ୍ତିଡ୍‌ଜି ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ସୋଡ଼ା ତଡ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ଆରି, ଆମ୍ୱେଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଆନା ଇୟମ୍‌ଡାଲନ୍‌ ଆନମେଙନ୍‌ ଅଜିଡ୍‌ ଓୟ୍‌ଲେ ଅବ୍‌ଗୋଗୋୟ୍‌ଲେ ରପ୍ତିଏ ?” ");
INSERT INTO juy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ଆରି, ସିନ୍‌ରିନ୍‌ ଆସନ୍‌ ଇନିବା ଏଇଃୟମ୍‌ତେ ? ପଡ଼ିଆନ୍‌ ଆ ତାର୍ବାଜି ଗିୟ୍‌ଲେ ଞଙ୍‌ନାବା, ତିଆତେଜି ଏଙ୍ଗାଲେ ସୋଡ଼ାତଜି; ଆନିଞ୍ଜି ଅଃକ୍କାବାଡ଼ାନେଜି କି ତାଡ଼େରନ୍‌ ଅଃତ୍ତବେଜି, ");
INSERT INTO juy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ସୋଲମନ୍‍ ରାଜାନ୍‌ ଆମଙ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅରିଃସୁମଞ୍ଜି ଡକୋଏନ୍‌ ଜନଙ୍‌ଡେନ୍‌, କେନ୍‌ ଅବୟ୍‌ ତାର୍ବାନ୍‌ ଅନ୍ତମ୍‌ ଆ ମନଙ୍‌ ଆ ସିନ୍‌ରି ଆଙ୍ଗିୟ୍‌ ଆନିନ୍‌ ଅଃର୍ରଲନେ । ");
INSERT INTO juy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ଲଙେ ପଡ଼ିଆଲୋଙନ୍‌ ଡକୋନ୍‌ ଆଜିଙ୍‌ ଅସମୟ୍‌ ବିଅଡ଼େଃ ତିଆତେ ଗଡ୍‌ଲେ କୋଡ଼ାତୁଡ୍‌ଲୋଙନ୍‌ ପନିଡନ୍‌ ଡେତେ, ଇସ୍ୱରନ୍‌ ତିଆତେଜି ଡିୟ୍‌ତେ ଆ ମନଙ୍‌ ତୁବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଏ ଅସୋୟ୍‌ ଡର୍ନେମର୍‌ଜି ଇସ୍ୱରନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡିଅଙ୍ଗା ଆ ଗୋଗୋୟ୍‌ ସିନ୍‌ରିନ୍‌ ଅରଃ ତିୟ୍‌ବେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“ଇନି ଏଜୋମାୟ୍‌ ? ଅଡ଼େ ଇନି ଏଗାଆୟ୍‌ ? ଅଡ଼େ ଇନି ଏଜିଜିନାୟ୍‌ ? ଏନ୍ନେଲେ ବର୍ରନ୍‌ ଏଇଃୟମ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏର୍‌ଡର୍ନେମରଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ସାୟ୍‌ଲେ ବୁଲ୍ଲେତଜି । ଆରି, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ଗାମ୍‌ଲେ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ଜନା । ");
INSERT INTO juy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ପର୍ତମ୍ମୁ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆରି ଆନିନ୍‌ ଅମଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଇନି ଲଡୟ୍‌ତେ ତିଆତେ ସାୟ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ତିଆସନ୍‌, ବିଅଡ଼େଃ ଆସନ୍‌ ଏବାଉଲ୍ଲିଡଙ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ବିଅଡ଼େଃ, ଆମ୍ୱେନ୍‌ ଆସନ୍‌ ଆମ୍ୱେନ୍‌ଡମ୍‌ ଏବାଉଲ୍ଲିତନେ । ଲଙେ ଆ ଡଣ୍ଡ ଲଙେ ଆସନ୍‌ ସରି ।” ");
INSERT INTO juy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ଆନ୍ନାମରନ୍‌ଆଡଙ୍‌ ଏବ୍‌ଡୋସାଡଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ଡୋସାବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ଡୋସାଲୋଙ୍‌ ଆନ୍ନାମରନ୍‌ଆଡଙ୍‌ ଏବ୍‌ପନ୍‌ସୁଆତିତେ, ତି ଆ ଡୋସାଲୋଙ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ପନ୍‌ସୁଆତିନ୍‌ ଡେତେ; ଆରି ଅଙ୍ଗା ଆ ତନରେଡ୍‌ଲୋଙ୍‌ ଏତରେଡ୍‌ତେ, ତି ଆ ତନରେଡ୍‌ଲୋଙ୍‌ ତରେଡ୍‌ଲେ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ଆରି, ବୋଞାଙ୍‌ବେନ୍‌ ଆମଡ୍‌ଲୋଙ୍‌ ଆଗ୍ରସେମଡେନ୍‌ ଆ ଉମ୍ରି ଇନିବା ଏଗିୟ୍‌ତେ, ବନ୍‌ଡ ଅମଡ୍‌ଲୋଙ୍‌ବେନ୍‌ ଅଙ୍ଗା ଆଙ୍‌ସନିବ୍‌ ଡକୋ, ତିଆତେ ଗିୟ୍‌ଲେ ଇନିବା ଏଃନ୍ନିୟମେ ? ");
INSERT INTO juy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ଆରି, ଅମଡ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆଙ୍‌ସନିବନ୍‌ ଡକୋ, ଏଙ୍ଗାଲେ ଆମ୍ୱେନ୍‌ ବୋଞାଙ୍‌ବେନ୍‌ଆଡଙ୍‌, ‘ୟାଆ, ଅମଡ୍‌ଲୋଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ଉମ୍ରିନ୍‌ ତବ୍‌ତାୟ୍‌,’ ଗାମ୍‌ଲେ ଏବର୍ତେ ? ");
INSERT INTO juy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ଏ ଇସ୍କତ୍ତାମର୍‌, ଅମଡ୍‌ଲୋଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ରୟ୍‌ ଆମ୍ମୁଙ୍‌ ଆଙ୍‌ସନିବନ୍‌ ତବ୍‌ଲେ ସେଡା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ବୋଞାଙ୍‌ନମ୍‌ ଆମଡ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଉମ୍ରିନ୍‌ ତବ୍‌ତବନ୍‌ ଆସନ୍‌ ମନଙ୍‌ ଗିୟ୍‌ଲେ ରପ୍ତିତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ମଡ଼ିର୍‌ ଜନବନ୍‌ କିନ୍‌ସଡଞ୍ଜି ଏତିୟ୍‌ଡଙ୍‌, ଅସମୟ୍‌ ଆନିଞ୍ଜି ୟର୍ରନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ରମ୍‌ବେଞ୍ଜି, ଆରି ମୁକ୍ତାବେନ୍‌ କିମ୍ୱୋନଞ୍ଜି ଆ ମୁକ୍କାବା ଏସେଡ୍‌ଡଙ୍‌ ଆନିଞ୍ଜି ତିଆତେ ଞାଡାତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ବେଡ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ; ସାୟ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏରବାଙ୍‌ତେ; ଡେବ୍‌ସଙ୍‌ବା ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ସନଙନ୍‌ ରନୋନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ବେଡ୍‌ତେ, ଆନିନ୍‌ ଞାଙ୍‌ତେ; ଆରି, ଆନା ସାୟ୍‌ଡଙ୍‌ତେ, ଆନିନ୍‌ ରବାଙ୍‌ତେ; ଆରି, ଆନା ଡେବ୍‌ସଙ୍‌ତେ, ଆନିନ୍‌ ଆସନ୍‌ ସନଙନ୍‌ ରନୋନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ମନ୍‌ରା ଆନା ଡକୋ, ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ରୁଟିନ୍‌ ବେଡେନ୍‌ ଡେନ୍‌, ଆନିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଅରେଙନ୍‌ ତିୟ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ଅଡ଼େ ଅୟନ୍‌ ବେଡେନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଜାଆଡନ୍‌ ତିୟ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ପେଲ୍ଲାଜି ଜନଙ୍‌ଡେନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ପସିୟ୍‌ଜିଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ମନଙ୍‌ ମନଙ୍‌ ଜନବଞ୍ଜି ତିୟ୍‌ଲେ ଏଗୟ୍‌ତେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରାଜି ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍ଆଡଙ୍‌ ବେଡ୍‌ତଜି, ଆନିନ୍‌ ତି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଡିଅଙ୍ଗା ଆ ଗୋଗୋୟ୍‌ ମନଙ୍‌ ମନଙ୍‌ ଜନବଞ୍ଜି ଅରଃ ତିୟେଞ୍ଜି !” ");
INSERT INTO juy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“ତିଆସନ୍‌, ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଇନିଜି ଲୁମେତଜି ଗାମ୍‌ଲେ ଲଡୟ୍‌ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ଏତ୍ତେଲେ ଲୁମ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆତେ ମା ବନାଁୟ୍‌ବରନ୍‌ ଡ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ସାସ୍ତ୍ରଲୋଙ୍‌ ଆଇଡିଡନ୍‌ ଆ ଞନଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ରକୋଡ୍‌ ଗରନ୍ନେଗଡ୍‌ ଗନ୍ନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଲାଆଙନ୍‌ ଆରି ସୋଡ଼ାନ୍‌ ଆ ତଙର୍‌ ଅନସେଡ୍‌ବାନ୍‌ ଓରୋଙ୍‌ଲଙ୍‌ତନେ, ଆରି ତି ଆ ତଙର୍‌ ଗଡ୍‌ ଜବ୍ର ମନ୍‌ରା ଗନ୍‌ତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ବନ୍‌ଡ ରକୋଡ୍‌ ସନଙନ୍‌ ଡ ସଙ୍କଡ଼ାନ୍‌ ଆ ତଙର୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ବାନ୍‌ ଓରୋଙ୍‌ଲଙ୍‌ତନେ, ଆରି ତିଆତେ ଅସୋୟ୍‌ ମନ୍‌ରା ତୁମ୍‌ ଞାଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“କଣ୍ଡାୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଆବ୍ବୟ୍‌ଲନ୍‌ ଡକୋନାବା; ଆନିଞ୍ଜି ମେଣ୍ଡାଞ୍ଜି ଅନ୍ତମ୍‌ ଅମଙ୍‌ବେନ୍‌ ଇୟ୍‌ତାଜି, ବନ୍‌ଡ ଉଗର୍‌ଲୋଙନ୍‌ ଆନିଞ୍ଜି ବଲିଆନ୍‌ ଅନ୍ତମ୍‌ ! ");
INSERT INTO juy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ଆନଜଞ୍ଜି ବାତ୍ତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆମ୍ୱେନ୍‌ ଏଅମ୍ମଡ୍‌ତଜି । ମନ୍‌ରାଞ୍ଜି ଅବ୍ବାନୁବନ୍‌ ସିଲଡ୍‌ ଅଙ୍ଗୁରଜନ୍‌ ଅଡ଼େ କିନ୍‌ରେଙ୍‌ଅବ୍ବାନ୍‌ ସିଲଡ୍‌ ଲୁଆଜନ୍ ରୋଡ୍‌ତଜି ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ତିଅନ୍ତମ୍‌ ଅଡ଼୍‌କୋ ମନଙ୍‌ ଅନୁବନ୍‌ ମନଙ୍‌ ଜଅନ୍‌ ଅଜତେ, ବନ୍‌ଡ ମନଙ୍‌ତଡନ୍‌ ଆରାନୁବ୍‌ ମନଙ୍‌ତଡନ୍‌ ଆଜ ଅଜତେ । ");
INSERT INTO juy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ମନଙ୍‌ ଅନୁବନ୍‌, ମନଙ୍‌ତଡନ୍‌ ଆଜ ଅଜଲେ ଅଃର୍ରପ୍ତିଏ, ଆରି, ମନଙ୍‌ତଡନ୍‌ ଆରାନୁବ୍‌ ମନଙ୍‌ ଅଜନ୍‌ ଅଜଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ଅଙ୍ଗା ଆରାନୁବ୍‌ ମନଙ୍‌ ଅଃନ୍ନଜଏ, ତିଆତେ ଅଡ୍‌ଲେ ତଗୋଲୋଙନ୍‌ ପନିଡନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ତିଆସନ୍‌ କଣ୍ଡାୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ କାବ୍ବାଡ଼ା ବାତ୍ତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆମ୍ୱେନ୍‌ ଏଅମ୍ମଡ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ଞେନ୍‌ଆଡଙ୍‌ ‘ପ୍ରବୁ, ପ୍ରବୁ’ ଗାମ୍‌ଲେ ଆରୋଡ୍ଡେତିଞଞ୍ଜି ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ଅଃଗନେଜି, ବନ୍‌ଡ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ ଆନାଜି ଞଣ୍ଡ୍ରମ୍‌ତଞ୍ଜି, ଆନିଞ୍ଜି ତୁମ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ଗନ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ପନ୍‌ସୁଆତି ଡିନ୍ନାଇଙନ୍‌ ଜବ୍ର ମନ୍‌ରା ଞେନ୍‌ଆଡଙ୍‌ ବର୍ତିଁୟ୍‌ଜି, ‘ଏ ପ୍ରବୁ, ଏ ପ୍ରବୁ, ଇନ୍‌ଲେଞ୍ଜି ଅଞୁମ୍‌ଲୋଙ୍‌ନମ୍‌ ପୁର୍ବାଃତେବରନ୍‌ ଏଃବ୍ବର୍ରନାୟ୍‌ ପଙ୍‌, ଆରି, ଅଞୁମ୍‌ଲୋଙ୍‌ନମ୍‌ ବୁତଞ୍ଜି ଏଃଗଙ୍‌ଲାୟ୍‌ ପଙ୍‌, ଆରି ଅଞୁମ୍‌ଲୋଙ୍‌ନମ୍‌ ଗୋଗୋୟ୍‌ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଏଃଲ୍ଲୁମ୍‌ଲାୟ୍‌ ପଙ୍‌ ?’ ");
INSERT INTO juy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ତିଆଡିଡ୍‌ ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ରେୟ୍‌ଲଙ୍‌ ବର୍ତାଜି, ‘ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଙ୍ଗିୟ୍‌ ଜା ଅଣ୍ଡ୍ରଙ୍‌ ଜନାବେନ୍‌ । ଏ ପରାନ୍‌ସାତ୍ତିନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଏର୍‌ଲୁମ୍‌ତେନ୍‌ ଆ ମନ୍‌ରାଜି ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ସବ୍‌ଙାୟ୍‌ନାବା ।’” ");
INSERT INTO juy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ତିଆସନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା କେନ୍‌ ବର୍ନେଞେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଞଣ୍ଡ୍ରମ୍‌ତନେ, ଆନିନ୍‌ ତୋଣ୍ଡୋ ଜଲେଙ୍‌ଲୋଙନ୍‌ ଆଗ୍ରୁସିଂତନେନ୍‌ ଅବୟ୍‌ ବୁଡ୍ଡିମରନ୍‌ ଅନ୍ତମ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ତରୁବନ୍‌ ଅଡ଼ୋଲାୟ୍‌, ଗଗଡାନ୍‌ ଜିର୍ରାୟ୍‌, ରିଙ୍ଗେନ୍‌ ଇଡ୍‌ଲାୟ୍‌ ଆରି ତି ଆସିଂ ଇୟ୍‌ଲାୟ୍‌ ତଙ୍‌ଞାଏ, ବନ୍‌ଡ ତିଆତେ ଅଃଗୋଙ୍‌ଲୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆସିଂ ଆ ଡିଆତାଲ୍‌ ତୋଣ୍ଡୋ ଜଲେଙ୍‌ଲୋଙନ୍‌ ଡକୋଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ଆରି, ଅଙ୍ଗା ମନ୍‌ରା କେନ୍‌ ବର୍ନେଞେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଅଃଞଣ୍ଡ୍ରମ୍‌ନେ, ଆନିନ୍‌ ତୋଣ୍ଡୋ ଲକିୟ୍‌ଲୋଙନ୍‌ ଅସିଙନ୍‌ ଆଗ୍ରୁତେନ୍‌ ଅବୟ୍‌ ଉଲ୍ଲୁମରନ୍‌ ଅନ୍ତମ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ତରୁବନ୍‌ ଅଡ଼ୋଲାୟ୍‌, ଗଗଡାନ୍‌ ଜିର୍ରାୟ୍‌, ରିଙ୍ଗେନ୍‌ ଇଡ୍‌ଲାୟ୍‌ ଆରି ତି ଆସିଂ ଇୟ୍‌ଲାୟ୍‌ ତଙ୍‌ଞାଏ, ସିଲତ୍ତେ ତି ଆସିଂ ଗୋଙେନ୍‌, ସିଲତ୍ତେ ତିଆତେ ବରନ୍ତଙ୍‌ଡାନ୍‌ ଅସେଡେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ଜିସୁନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆରବ୍‌ସୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ ଆ ଞନଙ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ସାନ୍ନି ଡେଏଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଅନ୍ତମ୍‌ ଞନଙନ୍‌ ଏର୍‌ତନିୟନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ଆଞ୍ରାଙେନ୍‌ ଆ ମନ୍‌ରା ଅନ୍ତମ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ଜିସୁନ୍‌ ବରୁନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଆଜିର୍ରାଞନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଜବ୍ର ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ଆରି ଗିୟ୍‌ବା, ଅବୟ୍‌ ମୋଡ୍ଡୋମରନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଲୋମ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଏ ପ୍ରବୁ, ଆମନ୍‌ ଲଡୟ୍‌ଲମ୍‌ ଡେନ୍‌, ଞେନ୍‌ଆଡଙ୍‌ ରପ୍ତି ମବ୍‌ଡ଼ିର୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ସିଲତ୍ତେ ଜିସୁନ୍‌ ମୋଡ୍ଡୋମରନ୍‌ଆଡଙ୍‌ ସୁଙେଡାଲେ ବର୍ରନେ, “ଞେନ୍‌ ଲଡୟ୍‌ତିଁୟ୍‌ ମଡ଼ିରମ୍‌ତୋ,” ଅବ୍‌ତାଡ଼ନ୍‌ ତି ମୋଡ୍ଡୋମରନ୍‌ ମଡ଼ିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ଆରି ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅମ୍‌ଡଙା, ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ବର୍‌ଡଙ୍‌ନେ, ଆର୍ପାୟ୍‌ ଜିରା, ରାଓଡ଼ାନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ନବ୍‌ତୁୟ୍‌ଡମ୍‌ନା, ଆନିନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅଲ୍ଲେ ଗିଜମ୍‌ତୋ । ଆରି ଆମନ୍‌ ମନଙ୍‌ଲମ୍‌ ଗାମ୍‌ଲେ ଆମଙଞ୍ଜି ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌, ମନଡ଼ିର୍‌ବେନ୍‌ ଆସନ୍‌ ମୋସାନ୍‌ ଏଙ୍ଗାଲେ ଅନମଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ବାଁୟ୍‌ଲବେନ୍‌ ଏତ୍ତେଲେ ଅନମଙନ୍‌ ଇୟ୍‌ ତିୟା ।” ");
INSERT INTO juy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ଜିସୁନ୍‌ କପର୍ନାଉମ୍‌ ଗଡ଼ାନ୍‌ ଆଗ୍ରନେନ୍‌, ଅବୟ୍‌ ରୋମିଅ ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ କାକୁର୍ତିଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେ, ");
INSERT INTO juy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ଏ ପ୍ରବୁ, କମ୍ୱାରିମର୍‌ଞେନ୍‌ କାନ୍ନିଏନ୍‌, ଆନିନ୍‌ ଅସିଙନ୍‌ ଆଲୁଡ୍‌ଲୁଡ୍‌, ଆରି ଆନିନ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ଜିସୁନ୍‌ ବର୍ରନେ, “ଞେନ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ମବ୍‌ନଙ୍‌ନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ବନ୍‌ଡ ରୋମିଅ ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ପ୍ରବୁ, ଆମନ୍‌ ଅସିଂଞେନ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌, ଞେନ୍‌ ଏତ୍ତେଲେ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌; ତିଆସନ୍‌ ଆମନ୍‌ ଅଜିଡ୍‌ ବାଁୟ୍‌ଲେ ବରା, କମ୍ୱାରିମର୍‌ଞେନ୍‌ ମନଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଅବୟ୍‌ନେନ୍‌ ଆ ଜାୟ୍‌ତା ଡକୋଲନାୟ୍‌ ଜନଙ୍‌ଡେନ୍‌, ଜାୟ୍‌ତାଞେନ୍‌ ସିପ୍ପାୟଞ୍ଜି ଡକୋଜି; ଞେନ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ‘ଜିରା’ ଗାମ୍‌ଲାୟ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଜିର୍ତେ, ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ‘ଜିରାୟ୍‌’ ଗାମ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଆନିନ୍‌ ଜିର୍ତାୟ୍‌; ଆରି କମ୍ୱାରିମର୍‌ଞେନ୍‌ ‘କେନ୍‌ଆତେ ଲୁମା’ ଗାମ୍‌ଲାୟ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ତିଆତେ ଲୁମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ଜିସୁନ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ସାନ୍ନି ଡେଏନ୍‌ କି ଆନିନ୍‌ଆଡଙ୍‌ ଆସ୍ରଣ୍ଡୋଙେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ଡିୟ୍‌ନେ ସୋଡ଼ା ଆ ଡର୍ନେ ଅଣ୍ଡ୍ରଙ୍‌ ଞାଙାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ଆରି ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଡରୁଙ୍‌ୟୋଙ୍‌ଗଡ୍‌ ଡ ବରୁବ୍‌ୟୋଙ୍‌ଗଡ୍‌ ସିଲଡ୍‌ ଜିର୍ରେ ଅବ୍ରାମନ୍‌, ଇସାକନ୍‌ ଡ ଜାକୁବଞ୍ଜି ସରିନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ବୁଜିଜୋମନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତଙ୍କୁମେଜି, ");
INSERT INTO juy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରାଜି ବନ୍‌ କେନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଡକୋତଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ଆ ଲୋଙଡ୍‌ଲୋଙନ୍‌ ସନେଡନ୍‌ ଡେତଜି, ତେତ୍ତେ ଆନିଞ୍ଜି ୟନେନ୍‌ ଡ ରମ୍‌ରମ୍‌ଜିନ୍‌ ଡେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ଆରି ଜିସୁନ୍‌ ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜିରା, ଆମନ୍‌ ଏଙ୍ଗାଲେ ଡର୍ତନେ ଏତ୍ତେଲେ ଡେଏତୋ ।” ତି ଆ ବନେଡ଼ା ମା କମ୍ୱାରିମରନ୍‌ ମନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ଜିସୁନ୍‌ ପିତ୍ରନ୍‌ ଆସିଂ ଆରିୟେନ୍‌ ତେତ୍ତେ ପିତ୍ରନ୍‌ ଆ କିନାର୍‌ ଆରସୁଏନ୍‌ ଲୁଡ୍‌ଲେ ଆଡ୍ରକୋଲନ୍‌ ଇୟ୍‌ଲେ ଗିଜେ । ");
INSERT INTO juy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ସିଲତ୍ତେ ଜିସୁନ୍‌ ପିତ୍ରନ୍‌ ଆ କିନାର୍‌ ଆସି ଆସ୍ରୁଙେଏନ୍‌ ତୁମ୍‌ ଆସୁନ୍‌ ତଡେନ୍‌, ଆରି ଆନିନ୍‌ ଡୋଲନ୍‌ କି ଆନିନ୍‌ଆଡଙ୍‌ ରୋଜୋମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ଅରୁବ୍‌ଲେ ଆପ୍ରାଙେନ୍‌ ମନ୍‌ରାଞ୍ଜି ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରାଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି । ସିଲତ୍ତେ ଆନିନ୍‌ ଆ ବବର୍ନେନ୍‌ ବାତ୍ତେ ବୁତଞ୍ଜି ଗଙେନ୍‌, ଆରି ଅଡ଼୍‌କୋ ବମ୍ୱମ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ତିଆସନ୍‌ ଜିସାୟ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆବର୍ରନେନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, “ଆନିନ୍‌ଡମ୍‌ ଅଡ଼୍‌କୋନ୍‌ ବମ୍ୱମ୍‌ନେଲେଞ୍ଜି ପାଙେନ୍‌, ଆରି ଅଡ଼୍‌କୋନ୍‌ ରୋଗଲେଞ୍ଜି ବୋୟେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ଜିସୁନ୍‌ ଆମଙ୍‌ ଏର୍ରେ ମନ୍‌ରାଞ୍ଜି ଡକୋଲଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଜିର୍ବା ଗାମ୍‌ଲେ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ଆରି, ଅବୟ୍‌ ସାସ୍ତ୍ରିନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଆମନ୍‌ ଅଡ଼େଙ୍ଗା ଜିର୍ରେ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ବୋଡ଼ାନ୍‌ ଆସନ୍‌ ଡଲ୍ଲିନ୍‌ ଡକୋ, ରୁଆଙନ୍‌ ଆ ଅନ୍ତିଡ୍‌ଜି ଆସନ୍‌ ବରସାସିଙନ୍‌ ଡକୋ, ବନ୍‌ଡ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆବବନ୍‌ ଡନକ୍କୋନ୍‌ ଆସନ୍‌ ଜାଗା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଆରି ଅବୟ୍‌ ଆନ୍ନା ଞଙ୍‌ନେମର୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ପ୍ରବୁ, ଆପେୟ୍‌ଞେନ୍‌ ରବୁଏନ୍‌, ଆନିନ୍‌ ରୟ୍‌ ଇୟ୍‌ତେ ତିଲ୍‌ନାୟ୍‌, ତିଆସନ୍‌ ଞେନ୍‌ ରୟଙନ୍‌ ତିୟିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌, ଆରବୁମରଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆରବୁମରଞ୍ଜିଆଡଙ୍‌ ତିଲ୍‌ତିଲନ୍‌ ଆସନ୍‌ ଅମ୍‌ରେଙ୍‌ବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ଜିସୁନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଆଡ୍ରାଜେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ଆରି ଗିୟ୍‌ବା, ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆକ୍ରାନ୍‌ ରିଙ୍ଗେତିରନ୍‌ ଅଡ଼ୋଲାୟ୍‌, ଅଡ୍ଡୋୟ୍‌ଡାନ୍‌ ବାତ୍ତେ ଡୋଙ୍ଗାନ୍‌ ଆତ୍ରବୁବ୍‌ତେନ୍‌ ଅନ୍ତମ୍‌ ଡେଏନ୍‌, ବନ୍‌ଡ ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆଲୁଡ୍‌ଲୁଡ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ, ଆନିନ୍‌ଆଡଙ୍‌ ତର୍ତର୍ରେ ଇୟ୍‌ଲେ ବରେଜି, “ଏ ପ୍ରବୁ, ଇନ୍‌ଲେଞ୍ଜି ଡୋବ୍‌ଲେନ୍‌, ଇନ୍‌ଲେଞ୍ଜି ରବୁରୟ୍‌ତଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନିବା ବତଙ୍‌ତବେନ୍‌ ? ଡର୍ନେବେନ୍‌ ଡିୟ୍‌ନେ ପଙ୍‌ ଆସୋୟ୍‌ ?” ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଡୋଲନ୍‌ ରିଙ୍ଗେନ୍‌ ଡ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ବବ୍‌ତଙେନ୍‌, ଆରି ଅଡ଼୍‌କୋନ୍‌ ରିଙ୍‌ରିଙାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ସିଲତ୍ତେ ଆନିଞ୍ଜି ସାନ୍ନିଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଏଙ୍ଗାଗୋମର୍‌ ଡ ରିଙ୍ଗେନ୍‌ ଡ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ନିୟ୍‌ କେନ୍‌ ଆ ବର୍ନେନ୍‌ ମାନ୍ନେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ତିକ୍କି ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଗାଦରିଅଞ୍ଜି ଆମଙ୍‌ରେଙ୍‌ ଜିସୁନ୍‌ ଆତ୍ରୁଙେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ବାଗୁ ମନ୍‌ରା ମସାନ୍ନିନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରବାଙେଜି । ଆନିଞ୍ଜି ଏତ୍ତେଲେ ବବରନ୍ତଙନ୍‌ ଡକୋଲଞ୍ଜି ଡ, ତି ଆ ତଙର୍‌ଗଡ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ଆନ୍ନିଙ୍‌ ଅଃନ୍ନୋମଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ଆରି ସିଲତ୍ତେ ଆନିଞ୍ଜି ସଜିର୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “ଏ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଆମନ୍‌ ସରିନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଇନି ଡକୋ ? ଡିନ୍ନାନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଅଡ଼ୋଆଞନ୍‌ ଆମନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଡନଣ୍ଡାୟନ୍‌ ଆସନ୍‌ ପଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ଆରି, ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଅସୋୟ୍‌ ସଙାୟ୍‌ଲୋଙ୍‌ ଅବୟ୍‌ ସୋଡ଼ାଡମ୍‌ ଆ ଗୋସ୍ସାବୋନ୍‌ ଜୋମ୍‌ଜୋମ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ସିଲତ୍ତେ ତି ଆ ମନ୍‌ରାଜି ଆ ଅମ୍ମ ଆଡ୍ରକୋଏଞ୍ଜି ଆ ବୁତଜି କାକୁର୍ତିଡାଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଗଙ୍‌ଲଲେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଗୋସ୍ସାବୋନନ୍‌ ଆ ଅମ୍ମ ଆପ୍ପାୟ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଜିର୍ବା ।” ସିଲତ୍ତେ ଆନିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ କିମ୍ୱୋନଞ୍ଜି ଆ ଅମ୍ମ ଇୟ୍‌ଲେ ଗନେଜି, ଆରି ଗିୟ୍‌ବା, ଗୋସ୍ସାବୋନନ୍‌ ଆକ୍ରାନ୍‌ ଇର୍ରେ ଆଗନେଡ଼େଙ୍‌ବୁରନ୍‌ ସିଲଡ୍‌ ଜାୟ୍‌ତାନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ପତୁଲ୍‌ଡାଲେ ଇୟ୍‌ଲେ ରବୁଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ଆରି ତୁର୍‌ବୋନ୍‌ମରଞ୍ଜି ଜିରେଞ୍ଜି କି ଗଡ଼ାନ୍‌ ଜିର୍ରେ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଡ ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରାଜି ଏଙ୍ଗାଗୋ ଡେଏଞ୍ଜି, ତି ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ଅବ୍‌ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଗଡ଼ାନ୍‌ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବାଙନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରାଜି, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଜି କି ଆ ସଣ୍ଡିଞ୍ଜି ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ କାକୁର୍ତିନେଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ପଡ୍‌ଲେ ବାନ୍ନେଗଡ୍‌ ଆ ଗଡ଼ାଡମନ୍‌ ଜିର୍ରାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ଆରି ଗିୟ୍‌ବା, ମନ୍‌ରାଞ୍ଜି ଅବୟ୍‌ କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ କଟଲୋଙନ୍‌ ବୋୟ୍‌ଲେ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି, ଜିସୁନ୍‌ ଆ ଡର୍ନେଞ୍ଜି ଗିୟ୍‌ଲେ ତି କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅଅନ୍‌, ଅବ୍ବୋମଙ୍‌ନା, ଆମନ୍‌ ଇର୍ସେନମ୍‌ଜି ସିଲଡ୍‌ କେମାନ୍‌ ଞାଙେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ସିଲତ୍ତେ “କେନ୍‌ ଆ ମନ୍‌ରା ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ତେ,” ଗାମ୍‌ଲେ ଲାଙ୍‌ଲେଡ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ଆନିଞ୍ଜି ଆରିଃୟମେଞ୍ଜିଆତେ ଜିସୁନ୍‌ ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ମନ୍ନଲୋଙ୍‌ ଇନିବା ଏର୍‌ମନଙନ୍‌ ଆ ବର୍ନେଜି ଏଇଃୟମ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ଅଙ୍ଗାତେ ବର୍ନେନ୍‌ ଆସନ୍‌ ଲିଆର୍‌ ? ‘ଇର୍ସେନମ୍‌ଜି ସିଲଡ୍‌ କେମାନ୍‌ ଞାଙେନ୍‌’ ଗାମ୍‌ଲେ ବନରନ୍‌, ଅଡ଼େ ‘ଡୋନା ତଙିୟ୍‌ନା’ ଗାମ୍‌ଲେ ବନରନ୍‌ ଲିଆର୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ବନ୍‌ଡ ପୁର୍ତିଲୋଙନ୍‌ ଇର୍ସେନ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମଙ୍‌ ସନୋଡ଼ାନେନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ରପ୍ତି ଏଜନାତେ, ତିଆସନ୍‌ ଆନିନ୍‌ କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ଡୋନା, କଟନମ୍‌ ପାଙ୍‌ଲେ ଅସିଂନମ୍‌ ଜିରା ।” ");
INSERT INTO juy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ସିଲତ୍ତେ କାନ୍ନିମରନ୍‌ ଡୋଲନ୍‌ ଆସିଙନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ତିଆତେ ଗିୟ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ବତଙେଞ୍ଜି, ଆରି ଅଙ୍ଗା ଇସ୍ୱର ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ସନୋଡ଼ାନେ ତିୟେନ୍‌ ତି ଆ ଇସ୍ୱରଆଡଙ୍‌ ଆନିଞ୍ଜି ଅବ୍‌ଗୁଗୁଏଞ୍ଜି ଅବ୍‌ପେମେଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ମାତିଉ ଗାମ୍‌ଲେ ଅବୟ୍‌ ପାନୁବେଡ୍‌ମରନ୍‌ ପାନୁସିଂଲୋଙନ୍‌ ଆତଙ୍କୁମନ୍‌ ଗିୟ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ ।” ସିଲତ୍ତେ ଆନିନ୍‌ ଡୋଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ଆରି, ଜିସୁନ୍‌ ମାତିଉନ୍‌ ଆସିଂ ଗାଗାନେବାନ୍‌ ଆରିୟେନ୍‌ ଆଡିଡ୍‌, ଗିୟ୍‌ବା, ଗୋଗୋୟ୍‌ନେଡମ୍‌ ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଇର୍ସେମରଞ୍ଜି ଜିର୍ରେ ଆନିନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗାଗାନେଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ପାରୁସିଞ୍ଜି ତିଆତେ ଗିୟ୍‌ଲେ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞନଙ୍‌ତିୟ୍‌ମର୍‌ବେନ୍‌ ଇନିବା ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଇର୍ସେମରଞ୍ଜି ସରିନ୍‌ ଗାଗାତନେ ?” ");
INSERT INTO juy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ବନ୍‌ଡ ଜିସୁନ୍‌ ତିଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ବର୍ରନେ, “ସୁକ୍କଡଅଙ୍‌ମରଞ୍ଜି ଆସନ୍‌ ବୌଡମରନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌, ବନ୍‌ଡ ଅସୁମରଞ୍ଜି ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ‘ଞେନ୍‌ ଅନମଙନ୍‌ ଅଃସାଜାୟ୍‌, ଆର୍ପାୟ୍‌ ସନାୟୁମନ୍‌ ସାୟ୍‌ତାୟ୍‌,’ କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ଗନନ୍‌ଲୁଡନ୍‌ ଆସନ୍‌ ସାସ୍ତ୍ରନ୍‌ ଇୟ୍‌ ପଡ଼େନାବା । ଞେନ୍‌ ଡରମ୍ମମରଞ୍ଜିଆଡଙ୍‌ ଓନୋଡ୍ଡେବାନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌, ଆର୍ପାୟ୍‌ ଇର୍ସେମରଞ୍ଜିଆଡଙ୍‌ ଅନୋଡ୍ଡେବାନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ତିଆଡିଡ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଇନ୍‌ଲେଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ଏଆନମ୍‌ତନାୟ୍‌, ବନ୍‌ଡ ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ଇନିବା ଅଃନ୍ନାନମ୍‌ନେଜି ?” ");
INSERT INTO juy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବରନ୍‌ ଅଙ୍ଗା ଜାୟ୍‌ କନୁଆମରଞ୍ଜି ସରିନ୍‌ ଡକୋତେ, ତି ଜାୟ୍‌ ଆନିଞ୍ଜି ଇୟମେଜି ପଙ୍‌ ? ବନ୍‌ଡ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ଅଙ୍ଗା ଆଡିଡ୍‌ ବରନ୍‌ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ତବ୍‌ଲେ ଅନୋରୋଙନ୍‌ ଡେତେ, ତିଆଡିଡ୍‌ ଆନିଞ୍ଜି ଆନମ୍‌ତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ଆନ୍ନିଙ୍‌ଜା ରଙ୍‌ ସିନ୍‌ରିନ୍‌ ଆଲୁଡ୍‌କାବ୍‌ ପାପୁର୍‌ ସିନ୍‌ରିଲୋଙନ୍‌ ଅଃବ୍ବଜେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ରଙ୍‌ ସିନ୍‌ରିନ୍‌ ତରୋଡ୍‌ତେ ଆରି ତି ପାପୁର୍‌ ସିନ୍‌ରିନ୍‌ ଆରି ଗୋଗୋୟ୍‌ ପତେତେ । ");
INSERT INTO juy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ଆରି, ମନ୍‌ରାଞ୍ଜି ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ପାପୁର୍‌ ଉସାଲ୍‌ ମୁନାଲୋଙନ୍‌ ଅଃଡ୍ଡକ୍କୋଏଜି, ଡକ୍କୋଏଞ୍ଜି ଡେନ୍‌ ଉସାଲ୍‌ ମୁନାନ୍‌ ପତଡ୍‌ତେ, ଉସାଲ୍‌ ମୁନାନ୍‌ ମୋସ୍ସାତେ, ଆରି ଦ୍ରାକ୍ୟାଡାନ୍‌ ଅଲାତେ; ଆର୍ପାୟ୍‌ ମନ୍‌ରାଞ୍ଜି ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ରଙ୍‌ ଉସାଲ୍‌ ମୁନାଲୋଙନ୍‌ ଡକ୍କୋତଜି, ଆରି ବାଗୁନ୍‌ ମନଙ୍‌ ଡକୋତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଆବର୍ରେଞ୍ଜି ଆଡିଡ୍‌, ଗିୟ୍‌ବା, ଅବୟ୍‌ ଜିଉଦି ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଲୋମ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଡାଙ୍ଗଡ଼ିଅନ୍‌ଞେନ୍‌ ନମିଞେନ୍‌ ରବୁଏନ୍‌, ବନ୍‌ଡ ଆମନ୍‌ ଜିର୍ରେ ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ଅସିନମ୍‌ ଆୟ୍‌ ଡକ୍କୋଆ, ଆନିନ୍‌ ଅମେଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଡୋଲନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସନେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ଆରି ଗିୟ୍‌ବା, ବାର ବର୍ସେଙ୍‌ ଜାୟ୍‌ ଅବୟ୍‌ ପ୍ରଦରରୋଗ ବମ୍ୱମ୍‌ନେବଜନ୍‌ ଜିସୁନ୍‌ ଆ କିଣ୍ଡୋଙ୍‌ଗଡ୍‌ ଜିର୍ରେ ଆ ସିନ୍‌ରିନ୍‌ ଆଲୁଡ୍‌କାବ୍‌ ଇୟ୍‌ଲାୟ୍‌ ସୁଙେଏ । ");
INSERT INTO juy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆଇବଜନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଆ ସିନ୍‌ରିନ୍‌ ତୁମ୍‌ ସୁଙେଲାୟ୍‌ ଡେନ୍‌ ମନଙ୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ଆରି ଜିସୁନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିଜେନ୍‌ କି ବରେନ୍‌, “ଅଅନ୍‌ ଅବ୍ବୋମଙ୍‌ନା, ଡର୍ନେନମ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲମ୍‌ ।” ସିଲତ୍ତେ ଅବ୍‌ତାଡ଼ନ୍‌ ତି ଆଇବଜନ୍‌ ମନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ତି ଜିଉଦି ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରନ୍‌ ଆସିଂ ଜିର୍ରେ ଇୟ୍‌ଲେ ଗିଜେନ୍‌, ତେତ୍ତେ ପେଡ୍‌ସଙ୍‌ମରଞ୍ଜି ଆରି ମନ୍‌ରାଞ୍ଜି ୟୋଙ୍‌ୟାଙ୍‌ଲେ ଏମ୍ମେଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ତିଆସନ୍‌ ଆନିନ୍‌ ଗାମେନ୍‌, “ତେନ୍ନେ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ବା, ଆଇସିଜନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ରବୁଏ, ଆର୍ପାୟ୍‌ ଆଲୁଡ୍‌ଲୁଡ୍‌ ।” ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗବ୍‌ରଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ମନ୍‌ରାଞ୍ଜି ଡାଣ୍ଡନ୍‌ ଆଡ୍ରୁଙ୍‌ଲଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଜିସୁନ୍‌ ଅମ୍ମନ୍‌ ଜିର୍ରେ ଆଇସିଜନ୍‌ ଆସି ଇୟ୍‌ଲେ ଞମେନ୍‌ ଆଇସିଜନ୍‌ ଡୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ଆରି କେନ୍‌ ଆ ବର୍ନେ ତି ଆ ଡେସାଲୋଙ୍‌ ସମ୍ପରାନ୍‌ ବୁର୍ବୁରାୟ୍‌ଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ବାଗୁ କାଡ଼ୁମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙ୍‌ଲେ ବାବ୍ବାବ୍‌ଲେ ବର୍‌ଗଡ୍‌ଲଞ୍ଜି, “ଏ ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ସାୟୁମ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ଆରି, ଜିସୁନ୍‌ ଅସିଙନ୍‌ ଆଗ୍ରନ୍‌ଲନ୍‌, ତି କାଡ଼ୁମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାଜି । ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ କେନ୍‌ଆତେ ଲୁମ୍‌ଲେ ରପ୍ତିତାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେନ୍‌ ଏଡର୍ତନ୍‌ ପଙ୍‌ ?” ଆନିଞ୍ଜି ଜାଲଙ୍‌ଲଞ୍ଜି, “ଓଓ ପ୍ରବୁ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆମଡଞ୍ଜି ସୁଙେଡାଲେ ବର୍ରନେ, “ଡର୍ନେବେନ୍‌ ଅନ୍ତମ୍‌ ଡେଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ଆରି ଆମଡଞ୍ଜି ରୋଲନେ । ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ବରେଞ୍ଜି, “ଗିୟ୍‌ବା, କେନ୍‌ ଆ ବର୍ନେ ଆନ୍ନିଙ୍‌ ଜନାଡଙେ ତଡ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ବନ୍‌ଡ ଆନିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ତି ଆ ବର୍ନେ ସମ୍ପରା ଡେସାନ୍‌ ବର୍ବର୍ରେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ଆନିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌, ଗିୟ୍‌ବା, ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ଜିସୁନ୍‌ ବୁତନ୍‌ ଆଗ୍ରଙେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ତି ଆ ଜାଡ୍ଡାମରନ୍‌ କଡାଡ଼ିଲନ୍‌ । ସିଲତ୍ତେ ମନ୍‌ରାଞ୍ଜି ସାନ୍ନିଡାଲେ ବର୍ରଞ୍ଜି, “ଇସ୍ରାଏଲଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ କାବ୍ବାଡ଼ା ଆଙ୍ଗିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗିୟ୍‌ତାଏ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ବନ୍‌ଡ ପାରୁସିଞ୍ଜି ଗାମେଞ୍ଜି, “ଆନିନ୍‌ ବୁତଞ୍ଜି ଆ ସୋଡ଼ା ବାତ୍ତେ ବୁତନ୍‌ ଗଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ସାଇରେଙନ୍‌ ଡ ଗଡ଼ାରେଙନ୍‌ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ରନୁକ୍କୁସିଂରେଙଞ୍ଜି ଞନଙନ୍‌ ତିୟ୍‌ଲେ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଆ ମନଙ୍‌ବର୍‌ ଅପ୍ପୁଙ୍‌ବରେନ୍‌, ଆରି ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ବମ୍ୱମ୍‌ନେମର୍‌ଜି ଡ ଅସୁମରଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ଆରି ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଆନିଞ୍ଜି ଆସନ୍‌ ଆର୍ଗୁଡ଼ିଡାଏନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତୁର୍‌ମେଡ୍‌ମର୍‌ତଡନ୍‌ ଆ ମେଣ୍ଡାଜି ଅନ୍ତମ୍‌ ଆନିଞ୍ଜି କୋନ୍‌ରାଏଞ୍ଜି ଆରି ପିରିଙ୍‌ପାଡାନ୍‌ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ଆରି ଆନିନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଗଡ୍‌ଗଡ୍‌ନେନ୍‌ ଡକୋଡମ୍‌, ବନ୍‌ଡ କାବ୍ବାଡ଼ାମରନ୍‌ ଅସୋୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ତିଆସନ୍‌ ଆ ଜନ୍‌ରୋମ୍‌ଆଲନ୍‌ କାବ୍ବାଡ଼ାମରଞ୍ଜିଆଡଙ୍‌ ଅନାପ୍ପାୟନ୍‌ ଆସନ୍‌ ଜନ୍‌ରୋମ୍‌ଆଲନ୍‌ ଆ ମୁଡ଼ମର୍‌ ଆମଙ୍‌ ପାର୍ତନାନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ଜିସୁନ୍‌ ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜିଆଡଙ୍‌ ଗଙ୍ଗଙନ୍‌ ଆସନ୍‌ ଆରି ଅଡ଼୍‌କୋ ବନମ୍ୱମଞ୍ଜି ଡ ଅଡ଼୍‌କୋନ୍‌ ଆ ରୋଗଜି ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ସନୋଡ଼ାନେନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ତି ବାରଜଣ ଅନାପ୍ପାୟଞ୍ଜି ଆଞୁମ୍‌ ଏନ୍ନେଲେ, ପର୍ତମ୍ମୁ ସିମନନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ପିତ୍ର ଗାମ୍‌ତଜି, ଆରି ଆ ବୋଞାଙନ୍‌ ଆନ୍ଦ୍ରିଅନ୍‌, ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ଜାକୁବନ୍‌ ଡ ଆ ବୋଞାଙନ୍‌ ଜନନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ପିଲିପନ୍‌ ଡ ବାର୍ତଲମିନ୍‌, ତୋମାନ୍‌ ଡ ପାନୁବେଡ୍‌ମର୍‌ ମାତିଉନ୍‌, ଆଲପିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜାକୁବନ୍‌ ଡ ତଦ୍ଦିୟନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ସିମନନ୍‌, ଇସ୍ରାଏଲନ୍‌ ଆ ତନାଣ୍ଡେନ୍‌ ଆସନ୍‌ ଆର୍‌ଲଡଜେଞ୍ଜି ଆ ଜିଉଦିଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ଆନିନ୍‌ ଅବୟ୍‌ନେ, ଆରି ଇସ୍କାରିତ ଜିଉଦାନ୍‌, କେନ୍‌ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ଜିସୁନ୍‌ କେନ୍‌ ବାରଜଣଞ୍ଜିଆଡଙ୍‌ ଏନ୍ନେଲେ ବାଁୟ୍‌ଲେ ଆପ୍ପାୟେଞ୍ଜି; “ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ ଏଇୟ୍‌ଡଙ୍‌, ସମିରୋଣମରଞ୍ଜି ଅନ୍ନିଙ୍‌ ଆ ଗଡ଼ାଲୋଙ୍‌ ଏଗନ୍‌ଡଙ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ଆର୍ପାୟ୍‌ ଆରାଡ଼ଏଞ୍ଜି ଆ ମେଣ୍ଡାଜି ଅନ୍ତମ୍‌ ଇସ୍ରାଏଲ୍‌ କେଜ୍ଜାଲୋଙନ୍‌ ଆରାଡ଼ଏଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ଇୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ଆରି ଜିରା ଜିରା ‘ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ତୁୟାଲାୟ୍‌,’ ଗାମ୍‌ଲେ ଇୟ୍‌ନବ୍‌ପ୍ପୁଙ୍‌ବାଜି । ");
INSERT INTO juy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ବମ୍ୱମ୍‌ନେମରଞ୍ଜି ମବ୍‌ନଙ୍‌ବାଜି, ଆରବୁମରଞ୍ଜି ଅବ୍‌ମେଙ୍‌ବାଜି, ମୋଡ୍ଡୋମରଞ୍ଜି ମବ୍‌ଡ଼ିର୍‌ବାଜି, ବୁତଞ୍ଜି ଗଙ୍‌ବାଜି । ଅଙ୍ଗାତେ ଆମ୍ୱେନ୍‌ କାଣ୍ଡାରେଙ୍‌ ଏଞାଙେନ୍‌, ତିଆତେ ଆମ୍ୱେନ୍‌ ଆନ୍ନାମରଞ୍ଜିଆଡଙ୍‌ କାଣ୍ଡାରେଙ୍‌ ତିୟ୍‌ବାଜି । ");
INSERT INTO juy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ଗାଞ୍ଜିଆଲୋଙ୍‌ବେନ୍‌ ସୁନା କି ତଙ୍କା କି ତମ୍ୱା ଏପାଙ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ଆରି ଜିର୍‌ଜିରନ୍‌ ଆସନ୍‌ ମୁନା କି ବାଗୁ ଅଙ୍ଗିନ୍‌, ପାଣ୍ଡୋୟନ୍‌, ତୁଡ଼େଡାଙ୍‌ ଏବ୍‌ଜାଡାଡଙ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କାବ୍ବାଡ଼ାମରନ୍‌ ବର୍ତନ୍ନାନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଜିଞ୍ଜିନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ଆମ୍ୱେଞ୍ଜି ଅନ୍ନିଙ୍‌ ଆ ଗଡ଼ା କି ଅନ୍ନିଙ୍‌ ଆ ସାଇ ଇୟ୍‌ଲେ ଏଗନେ ଡେନ୍‌, ତେତ୍ତେ ଅଙ୍ଗା ମନ୍‌ରା ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ସାକ୍କେକୁଲନ୍‌ ଆସନ୍‌ ସାୟ୍‌ତେ, ତିଆତେ ସୁମ୍‌ସୁମ୍‌ଲେ ଇୟ୍‌ ଗିୟ୍‌ବା, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତି ତେତ୍ତେ ସିଲଡ୍‌ ଆନ୍ନାରେଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏଜିରେନ୍‌ ଜାୟ୍‌ ତି ଆସିଂ ଇୟ୍‌ ଡକୋନାବା । ");
INSERT INTO juy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ଆରି ଆମ୍ୱେନ୍‌ ଅସିଙନ୍‌ ଇୟ୍‌ଲେ ଏଗନେ ଆଡିଡ୍‌, ‘ଆମ୍ୱେନ୍‌ ସରିନ୍‌ ସନୟୁନ୍‌ ଡକୋନେତୋ,’ ଗାମ୍‌ଲେ ତି ଆସିଂମର୍‌ଜିଆଡଙ୍‌ ଇୟ୍‌ ବର୍ବାଜି । ");
INSERT INTO juy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ତି ଆସିଂମର୍‌ଜି ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଜାଲବେଞ୍ଜି ଡେନ୍‌, ଆମଙଞ୍ଜି ସନୟୁନ୍‌ ଜିରାୟ୍‌ତୋ, ବନ୍‌ଡ ଆନିଞ୍ଜି ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାଲବେଞ୍ଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମଙଞ୍ଜି ସନୟୁନ୍‌ ଜିର୍‌ଡଙାୟ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ଆରି, ଆନା ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାବେନ୍‌, କି ବର୍ନେବେନ୍‌ ଅଃନ୍ନମ୍‌ଡଙେ, ତି ଆସିଂ ସିଲଡ୍‌ କି ତି ଆ ଗଡ଼ା ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଏଜିରେନ୍‌ ଆଡିଡ୍‌ ତାଲ୍‌ଜଙ୍‌ବେନ୍‌ ଆ ଉମ୍ରିଲ ତୁୟ୍‌ତୁୟ୍‌ଜଙ୍‌ନାବା । ");
INSERT INTO juy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ପନ୍‌ସୁଆତି ଡିନ୍ନାଇଙନ୍‌ ତି ଆ ଗଡ଼ା ଆ ପନବ୍‌ରଡ୍‌ ସିଲଡ୍‌ ସଦୋମନ୍‌ ଡ ଗମୋରା ଡେସାନ୍‌ ଆ ପନବ୍‌ରଡ୍‌ ରପ୍ତି ସଏତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ଗିୟ୍‌ବା, ବଲିଆଞ୍ଜି ଆମଙ୍‌ରେଙ୍‌ ମେଣ୍ଡାଞ୍ଜି ଅନ୍ତମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତବେନ୍‌, ତିଆସନ୍‌ ଜାଆଡନ୍‌ ଅନ୍ତମ୍‌ ବୁଡ୍ଡିବେନ୍‌ତୋ ଆରି କୁକ୍କୁରନ୍‌ ଅନ୍ତମ୍‌ ଲବଡ୍ଡିବେନ୍‌ତୋ । ");
INSERT INTO juy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ବନ୍‌ଡ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଆବ୍ବୟ୍‌ଲନ୍‌ ଡକୋନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଜିଲେ ପନ୍‌ସୁଆତିସିଂଲୋଙନ୍‌ ସୋରୋପ୍ପାୟ୍‌ତବେଞ୍ଜି ଆରି ଆ ରନୁକ୍କୁସିଂରେଙଞ୍ଜି ସାମକାନ୍‌ ବାତ୍ତେ ତିଡ୍‌ତବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ଆରି ଞେନ୍‌ ଆସନ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ସୋଡ଼ାମରଞ୍ଜି ଡ ରାଜାଞ୍ଜି ଆମଙ୍‌ ଓରୋଙ୍‌ତବେଞ୍ଜି, ତିଆଡିଡ୍‌ ଆମଙଞ୍ଜି ଡ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ରୟଙନ୍‌ ଏଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ବନ୍‌ଡ ଅଙ୍ଗା ଆଡିଡ୍‌ ଆନିଞ୍ଜି ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଜିଲେ ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ସୋରୋପ୍ପାୟ୍‌ତବେଞ୍ଜି, ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲେ ଇନି ଆ ବର୍ନେ ଏବର୍ତନେ, ତିଆସନ୍‌ ଏଇଃୟମ୍‌ଡଙେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନି ଏଙ୍ଗାଲେ ଏବର୍ତନେ, ତିଆତେ ତି ଆ ବନେଡ଼ା ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ତିଆତେ ଏଃବ୍ବର୍ନେ, ବନ୍‌ଡ ଆପେୟ୍‌ବେନ୍‌ ଆ ମଡ଼ିର୍‌ ପୁରାଡ଼ା ଅମ୍ମଲୋଙ୍‌ବେନ୍‌ ଡକୋଡାଲନ୍‌ ତଅଡ୍‌ଗଡ୍‌ବେନ୍‌ ବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ବୋଞାଙନ୍‌ ବୋଞାଙନ୍‌ଆଡଙ୍‌ ଆରି ଆପେୟନ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ରନବୁନ୍‌ ଆସନ୍‌ ସୋରୋପ୍ପାୟ୍‌ତଜି, ଅଅନଞ୍ଜି ଆପେୟନ୍‌ ଅୟୋଙନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡୋଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ଅଞୁମ୍‌ଞେନ୍‌ ଆସନ୍‌ ଗାମ୍‌ଲେ ଅଡ଼୍‌କୋଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତବେଞ୍ଜି, ବନ୍‌ଡ ଆନା ଆତନିକ୍କି ଜାୟ୍‌ ଡର୍ନେଲୋଙନ୍‌ ଗବ୍‌ରିଲନ୍‌ ଡକୋତନ୍‌, ଆନିନ୍‌ ଅନୁରନ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ଆନିଞ୍ଜି ଅବୟ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡଣ୍ଡାୟ୍‌ଲବେଞ୍ଜି ଡେନ୍‌, ତିଆଡିଡ୍‌ ଆନ୍ନା ଗଡ଼ାନ୍‌ ଜିର୍ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ରାଏଲ୍‌ ଗଡ଼ାରେଙନ୍‌ ଆମ୍ୱେଞ୍ଜି କାବ୍ବାଡ଼ାବେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏବ୍‌ସୁଜ୍ଜେଏନ୍‌ ଆମ୍ମୁଙ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଜିର୍ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ଞଙ୍‌ନେମରନ୍‌ ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ ସିଲଡ୍‌, ଅଡ଼େ କମ୍ୱାରିମରନ୍‌ ସାଉକାରନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ଞଙ୍‌ନେମରନ୍‌ ଆ ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ ଡ କମ୍ୱାରିମରନ୍‌ ଆ ସାଉକାରନ୍‌ ଅନ୍ତମ୍‌ ଡେଏନ୍‌ ଡେନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ସରି । ଆନିଞ୍ଜି ଅସିଙନ୍‌ ଆ ମୁଡ଼ମର୍‌ଆଡଙ୍‌ ବାଲ୍‌ଜିବୁଲ୍‌ ଗାମେଞ୍ଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅସିଂମରଞ୍ଜିଆଡଙ୍‌ ଆରି ଡିଅଙ୍ଗା ଆ ଗୋଗୋୟ୍‌ ଅରଃ ବର୍ନେଞ୍ଜି !” ");
INSERT INTO juy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବତଙ୍‌ଡଙ୍‌ବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାତେ ଅଃଗିୟ୍‌ତାଏ, ତିଅନ୍ତମ୍‌ ଆୟୁମ୍‌ୟୁମନ୍‌ଆତେ ଇନ୍ନିଙ୍‌ ତଡ୍‌, ଆରି ଅଙ୍ଗାତେ ଅଃଜ୍ଜନାଲଙ୍‌ନେ, ତିଅନ୍ତମ୍‌ ଆସସନ୍‌ଆତେ ଇନ୍ନିଙ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଙ୍ଗାତେ ଆ ଲୋଙଡ୍‌ଲୋଙନ୍‌ ବର୍ତବେନ୍‌, ତିଆତେ ଆ ସାଆର୍‌ଲୋଙନ୍‌ ବର୍ନାବା, ଆରି ଅଙ୍ଗାତେ ଆମ୍ୱେଞ୍ଜି ଆସସଲୋଙନ୍‌ ଏଅମ୍‌ଡଙ୍‌ତେ, ତିଆତେ ଅସିଙନ୍‌ ଆ ତୋଣ୍ଡୋ ବିଲେଙ୍‌ଲୋଙନ୍‌ ବର୍ନାବା । ");
INSERT INTO juy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ଆରି, ଆନାଜି ଡଅଙନ୍‌ ରବ୍ବୁତଜି, ବନ୍‌ଡ ପୁରାଡ଼ାନ୍‌ ରବ୍ବୁଲେ ଅଃର୍ରପ୍ତିଏଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ବତଙ୍‌ଡଙ୍‌ବେନ୍‌, ଆର୍ପାୟ୍‌ ଅଙ୍ଗା ଇସ୍ୱର ଡଅଙନ୍‌ ଡ ପୁରାଡ଼ାନ୍‌ ବାଗୁନ୍‌ ନରକଲୋଙନ୍‌ ଅବ୍‌ମୋସ୍ସାଲେ ରପ୍ତିତେ ଆନିନ୍‌ଆଡଙ୍‌ ତୁମ୍‌ ବତଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ବାଗୁ ସୟ୍‌ସିଂତିଡନ୍‌ ଇନି ବପୋୟ୍‌ସା ବାତ୍ତେ ଅଃତ୍ତମ୍‌ନେ ପଙ୍‌ ? ଆରି ଆପେୟ୍‌ବେନ୍‌ ତିଆତେ ଗଲୋଏତୋ ଏଃଗାମ୍‌ଲୋ ଡେନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଅବୟ୍‌ ଜନଙ୍‌ ଲବଲୋଙନ୍‌ ଜାୟ୍‌ତାନ୍‌ ଅଃଗଲୋଏ । ");
INSERT INTO juy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ବନ୍‌ଡ ଅବବ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆ ଉଉ ଜନଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଡିଡିଆୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ତିଆସନ୍‌ ବତଙ୍‌ଡଙ୍‌ବେନ୍‌, ସୟ୍‌ସିଂତିଡଞ୍ଜି ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଗୋଗୋୟ୍‌ ମଡ଼ଗା ।” ");
INSERT INTO juy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ଆରି, ଆନା ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମୁର୍ସେଇଁୟ୍‌, ଞେନ୍‌ ନିୟ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମୁର୍ସେଆୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ବନ୍‌ଡ ଆନା ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ମୁର୍ସେତିଁୟ୍‌, ଞେନ୍‌ ନିୟ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ମୁର୍ସେତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ଞେନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ସନୟୁନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗାମ୍‌ଲେ ଏବ୍‌ଡିସୟ୍‌ଡଙ୍‌, ସନୟୁନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌ ଆର୍ପାୟ୍‌ କଡ଼ିବନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆପେୟନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌, ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଆପେୟନ୍‌, ଅୟୋଙନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡାଙ୍ଗଡ଼ିଅନନ୍‌, ଡାଙ୍ଗଡ଼ିଅନନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଅୟୋଙନ୍‌, କିନାରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ କଉନନ୍‌, କଉନନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ କିନାରନ୍‌ ଅନବ୍‌ବିରୁଦନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ଆରି ଆସିଂଡମନ୍‌ ଆ ମନ୍‌ରା ମା ମନ୍‌ରାନ୍‌ ଆ ବନେରା ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ଆନା ଆପେୟନ୍‌ ଡ ଆୟୋଙନ୍‌ଆଡଙ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ, ଆନିନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌, ଆରି ଆନା ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଡ ଆ ଡାଙ୍ଗଡ଼ିଅନନ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ, ଆନିନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ଆରି, ଅଙ୍ଗା ମନ୍‌ରା ଆଅକ୍କାଡଙନ୍‌ ବୋୟ୍‌ଲେ ଞେନ୍‌ଆଡଙ୍‌ ଅଃସଣ୍ଡୋଙିଁୟ୍‌, ଆନିନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ଅଙ୍ଗା ମନ୍‌ରା ଆନମେଙନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଏର୍‌ତେ ଗୋୟ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଅବ୍ବଡ଼ୟ୍‌ତେ, ଆରି ଆନା ଞେନ୍‌ ଆସନ୍‌ ଆନମେଙନ୍‌ ଅବ୍ବଡ଼ୟ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ଆନା ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଜାତବେନ୍‌, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଜାତିଁୟ୍‌, ଆରି ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଜାତିଁୟ୍‌, ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆନିନ୍‌ ଜାତେ । ");
INSERT INTO juy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ଆନା ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ଆଡଙ୍‌ ଇସ୍ୱରନ୍‌ ଆ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଗାମ୍‌ଲେ ଜାତେ, ଆନିନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆ ବର୍ତନ୍ନା ଞାଙ୍‌ତେ । ଆରି, ଆନା ଡରମ୍ମମରନ୍‌ଆଡଙ୍‌ ଡରମ୍ମମର୍‌ ଗାମ୍‌ଲେ ଜାତେ, ଆନିନ୍‌ ଡରମ୍ମମରନ୍‌ ଆ ବର୍ତନ୍ନା ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ଆରି, ଆନା କେନ୍‌ ସନ୍ନାମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ଗାଡାନେନ୍‌ ଆସନ୍‌ ବଗିନା ଆ ଜଏଙ୍‌ଡାନ୍‌ ତିୟ୍‌ତେ, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆନିନ୍‌ ଏଙ୍ଗାଲେ ଜନଙ୍‌ ଆ ବର୍ତନ୍ନାନ୍‌ ଅଃନ୍ନବ୍‌ଅଡ଼ଜେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଞଙ୍‌ନେମର୍‌ଞେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ଜିସୁନ୍‌ ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ବର୍ରେ ଆରବ୍‌ସୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ଗଡ଼ାରେଙ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଡ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଆସନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ତିଆଡିଡ୍‌ ଜନନ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକୋଡାଲନ୍‌ କ୍ରିସ୍ଟନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଆ ବର୍ନେ ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ କ୍ରିସ୍ଟନ୍‌ ଆମଙ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଅଙ୍ଗା ମନ୍‌ରା ଜିର୍ତାୟ୍‌ ଗାମ୍‌ଲେ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ବର୍ରନେ, ତି ଆ ମନ୍‌ରା ଆମନ୍‌ ପଙ୍‌, ଅଡ଼େ ଇନ୍‌ଲେନ୍‌ ଆନ୍ନାମର୍‌ଆଡଙ୍‌ ଏଜଗେଆୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଜିର୍ରେ, ଇନିଜି ଇନିଜି ଏଅମ୍‌ଡଙ୍‌ତେ ଆରି ଏଗିୟ୍‌ତେ, ତିଆତେଜି ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ନବ୍‌ଜନାବା; ");
INSERT INTO juy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","କାଡ଼ୁମରଞ୍ଜି ଗିୟ୍‌ଲେ ରପ୍ତିତଜି, ସୋତ୍ତାମରଞ୍ଜି ତଙିୟ୍‌ତଞ୍ଜି, ମୋଡ୍ଡୋମରଞ୍ଜି ମଡ଼ିର୍‌ତଜି, କାଲାମରଞ୍ଜି ଅମ୍‌ଡଙ୍‌ତଜି, ଆରବୁମରଞ୍ଜି ୟର୍ମେଙ୍‌ତଜି, ଆରି ଡୋଲେୟ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ଆରି ଆନାଜି ବର୍ନେଞେନ୍‌ ଅଃଡ୍ଡାଲ୍‌ଗଡେଜି ଆନିଞ୍ଜି ସନେନ୍‌ସେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌, ଜନନ୍‌ ଆ ବର୍ନେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବନରନ୍‌ ଆସନ୍‌ ଉଲନେ, “ଆମ୍ୱେଞ୍ଜି ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଏଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ଇନି ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଏଇୟେନ୍‌ ? ଇନି ରିଙ୍ଗେନ୍‌ ବାତ୍ତେ ଆମ୍ରୋମୋଲତନ୍‌ ଅବୟ୍‌ ଡାଆଜିଙନ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ତିଆତେ ତଡ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନି ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଏଜିରେନ୍‌ ? ଇନି ମଡ଼ଗାକାବନ୍‌ ଆରନେନ୍‌ ଆ ମନ୍‌ରା ପଙ୍‌ ? ଗିୟ୍‌ବା, ଆନାଜି ମଡ଼ଗାକାବନ୍‌ ରତଞ୍ଜି, ଆନିଞ୍ଜି ରାଜାସିଂଲୋଙନ୍‌ ଡକୋତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ତିଆତେ ତଡ୍‌ ଡେନ୍‌ ଇନି ଆସନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଏଜିରେନ୍‌ ? ଇନି ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ପଙ୍‌ ? ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ସିଲଡ୍‌ ଆରି ଗୋଗୋୟ୍‌ ସତଙ୍‌ମରନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ଜନନ୍‌ ଆ ବର୍ନେ ଏନ୍ନେଲେ ଆଇଡିଡ୍‌, ଇସ୍ୱରନ୍‌ ବର୍ରନେ ‘ଞେନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ଞେନ୍‌ ଅବ୍ବାମ୍ମୁଙ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ନମ୍‌ ଆପ୍ପାୟାୟ୍‌, ଆନିନ୍‌ ମୁକ୍କାଗଡ୍‌ନମ୍‌ ଆମନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ଅବ୍‌ଜାଡାତେ,’ ତି ଆ ମନ୍‌ରା କେନ୍‌ଆନିନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆଇମରଞ୍ଜି ଆ କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ କରୋକ୍କୋଡନ୍‌ ଆଡ୍ରେଏଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ାମର୍‌ ଆନ୍ନିଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗିୟ୍‌ତାଏ; ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ଆନା ସନ୍ନାଡମ୍‌, ଆନିନ୍‌ ଜନନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା । ");
INSERT INTO juy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ମନଙ୍‌ବରନ୍‌ ଆରପ୍ପୁଙେନ୍‌ ଆ ଡିନ୍ନା ସିଲଡ୍‌ ନମିନ୍ତାନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଜୁରୁତଜି, ଗର୍ବମରଞ୍ଜି ତିଆତେ ଅବାଲ୍ଲିନ୍‌ ମନେଡ୍ଡେନ୍‌ ଆସନ୍‌ ଏର୍‌ତଜି ଗୋୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜନନ୍‌ ଆଜିର୍ରାଞନ୍‌ ଆ ଡିନ୍ନା ଜାୟ୍‌ ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଡ ଅଡ଼୍‌କୋ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ତି ଆ ରାଜ୍ୟ ଆ ବର୍ନେ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଆରି ଆମ୍ୱେଞ୍ଜି ଜନାଜାନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ଲବେନ୍‌ ଡେନ୍‌, ଜନନ୍‌ ମା ଏଲିଅନ୍‌, କେନ୍‌ଆନିନ୍‌ ବନ୍‌ ଇୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ଆନା ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଅଲୁଡନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅମ୍‌ଡଙେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ଞେନ୍‌ ଆନା ବୟନ୍‌ ନମି ଆ ମନ୍‌ରାଜି ଜଙାଜି ? ଆନିଞ୍ଜି ସରେଁୟ୍‌ତାଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ଆଡ୍ରକୋତଞ୍ଜି ଆ ପସିୟ୍‌ଜି ଅନ୍ତମ୍‌ । ଆନିଞ୍ଜି ଆନ୍ନାସିଜଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଲେ ବର୍ତଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘ଇନ୍‌ଲେଞ୍ଜି ଅମଙ୍‌ବେନ୍‌ ପିରୋଡ଼ୋଜନ୍‌ ଏପେଡ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଃତ୍ତଙ୍‌ଲୋ, ଇନ୍‌ଲେଞ୍ଜି ରନବୁକନନ୍‌ ଏକନ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଃୟେଲୋ ।’ ");
INSERT INTO juy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଜିର୍ରାୟ୍‌ କି ଇୟ୍‌ଲାୟ୍‌ ଆନମ୍‌ନେ ଆରି ଦ୍ରାକ୍ୟାଡାନ୍‌ ଅଃଗାଲୋ, ଆରି ମନ୍‌ରାଞ୍ଜି ଗାମ୍‌ତଜି, ‘ଆନିନ୍‌ ବୁତନ୍‌ ସୁମେନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଜିର୍ରାୟ୍‌ କି ଇୟ୍‌ତାୟ୍‌ ଜୋମେ ଗାଏ, ଆରି ମନ୍‌ରାଞ୍ଜି ଗାମ୍‌ତଜି, ‘ଗିୟ୍‌ବା, କେନ୍‌ଆନିନ୍‌ ଅବୟ୍‌ ଲୋବଜୋମ୍‌ମର୍‌, ଗାସାଲ୍‌ମର୍‌, ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଇର୍ସେମରଞ୍ଜି ଆ ଗଡ଼ି !’ ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆ ଗିଆନ, ଆ କାବ୍ବାଡ଼ାନ୍‌ ବାତ୍ତେ ଆଜାଡ଼ିନ୍‌ ଗାମ୍‌ଲେ ଗିୟ୍‌ତାଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ତିଆଡିଡ୍‌ ଅଙ୍ଗା ଅଙ୍ଗା ଆ ଗଡ଼ାରେଙ୍‌ ଜିସୁନ୍‌ ଗୋଗୋୟ୍‌ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଲୁମେନ୍‌, ବନ୍‌ଡ ଆନିଞ୍ଜି ଅଃନ୍ନାବ୍‌ୟର୍‌ବୁଡ୍ଡିଲଞ୍ଜି, ଆନିନ୍‌ ତି ଆ ଗଡ଼ା ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ କଁୟ୍‌ଲେ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ୟୋଙ୍‌ କୋରାଜିନ୍‌ ଆମନ୍‌ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ, ୟୋଙ୍‌ ବେତ୍‌ସାଇଦା ଆମନ୍‌ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଅଙ୍ଗା ଅଙ୍ଗା ଆ ସାନ୍ନି କାବ୍ବାଡ଼ାଜି ଲନୁମନ୍‌ ଡେଏନ୍‌, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ସୋରନ୍‌ ଡ ସିଦୋନ ଗଡ଼ାଲୋଙନ୍‌ ଲୁମ୍‌ଲନ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଆଙ୍ଗାନ୍‌ ପୁର୍ବାନ୍‌ ସିଲଡ୍‌ ଅକ୍କାନ୍‌ ରଲନ୍‌ କୋମାବ୍‌ଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିତଞ୍ଜି ବନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ଡେଲୋଜନଙ୍‌ଡେନ୍‌, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ପନ୍‌ସୁଆତି ଡିନ୍ନାଇଙନ୍‌ ପନବ୍‌ରଡ୍‌ବେନ୍‌ ସିଲଡ୍‌ ସୋରନ୍‌ ଡ ସିଦୋନନ୍‌ ଆ ପନବ୍‌ରଡ୍‌ ରପ୍ତି ସଏତନେ । ");
INSERT INTO juy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ଆରି ଏ କପର୍ନାଉମ, ଆମନ୍‌ ଇନି ରୁଆଙନ୍‌ ଜାୟ୍‌ ତେକ୍କେତନ୍‌ ପଙ୍‌ ? ରନବୁ ଡରକୋନେନ୍‌ ଜାୟ୍‌ ଆମନ୍‌ ଅସେଡ୍‌ତମ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ନମ୍‌ ଅଙ୍ଗା ଅଙ୍ଗା ଆ ସାନ୍ନି କାବ୍ବାଡ଼ାଜି ଲନୁମନ୍‌ ଡେଏନ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ସଦୋମଲୋଙନ୍‌ ଲନୁମନ୍‌ ଡେଏନ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ନମିନ୍ତାନ୍‌ ଡକୋତେ ବନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ଜନଙ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ପନ୍‌ସୁଆତି ଡିନ୍ନାଇଙନ୍‌ ପନବ୍‌ରଡ୍‌ନମ୍‌ ସିଲଡ୍‌ ସଦୋମନ୍‌ ଆ ପନବ୍‌ରଡ୍‌ ରପ୍ତି ସଏତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଏନ୍ନେଲେ ବର୍ରନେ, “ଏ ଆପେୟ୍‌, ରୁଆଙନ୍‌ ଡ ପୁର୍ତିନ୍‌ ଆ ପ୍ରବୁ, ଆମନ୍‌ ଜନନାମରଞ୍ଜି ଡ ବୁଡ୍ଡିମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅବ୍‌ସସଲେ ଡକ୍କୋଡାଲେ, ଏର୍‌ପଡ଼େନେମରଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ଗିୟ୍‌ତାଏନ୍‌, ତିଆସନ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସେଙ୍କେତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ଓଓ, ଆପେୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆତେ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ନମ୍‌ ଅରିଃସୁମ୍‌ଡମ୍‌ ଡେଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ଆପେୟ୍‌ଞେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ତନିୟନ୍‌ ଡେଲୋ, ଆରି ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଆନ୍ନିଙ୍‌ ଜନା ତଡ୍‌, ଆପେୟନ୍‌ ତୁମ୍‌ ଜନା, ଆରି ଆପେୟନ୍‌ଆଡଙ୍‌ ଆନ୍ନିଙ୍‌ ଜନା ତଡ୍‌, ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ତୁମ୍‌ ଜନା, ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନା ଆମଙ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ତର୍ନେନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ତେ, ଆନିନ୍‌ ଜନାତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ଏ ମନଙ୍ଗାନ୍‌ ଡ ଲନଗିନନ୍‌ ଆ ମନ୍‌ରାଜି, ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଇଆୟ୍‌ବା, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଲୋଲୋନେନ୍‌ ତିୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ରାଙଙ୍‌ଞେନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ତାରଙ୍‌ଲୋଙ୍‌ ବୋୟ୍‌ବା, ଆରି ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ଞଙ୍‌ନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଲବଡ୍ଡିଡମ୍‌ ଆରି ଲଗଡ୍‌ ଉଗର୍‌, ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଉଗର୍‌ଲୋଙ୍‌ ଲୋଲୋନେନ୍‌ ଏଞାଙ୍‌ତେ; ");
INSERT INTO juy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରାଙଙ୍‌ଞେନ୍‌ ଲଗଡ଼ ଆରି ବିଡ଼ାର୍‌ଞେନ୍‌ ଲିଆର୍‌ଡମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ତିଆଡିନ୍ନା ଜିସୁନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଜନ୍‌ରୋମ୍‌ଆଲ୍‌ଗଡ୍‌ ଜିରେନ୍‌, ଆରି ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆଡ୍ରୋଲଜେଞ୍ଜି ଜନ୍‌ରୋମନ୍‌ ଆ ସିସା ତତ୍ତଡ୍‌ଲେ ଜୋମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ବନ୍‌ଡ ପାରୁସିଞ୍ଜି ତିଆତେ ଗିୟ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଗିଜା, ଅଙ୍ଗାତେ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଅଃଲ୍ଲୁମ୍‌ବୋ ଗାମ୍‌ଲେ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ତିଆତେ ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ଲୁମ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଦାଉଦନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ଆଡ୍ରୋଲଜେଞ୍ଜି ଆଡିଡ୍‌, ଆନିନ୍‌ ଇନି ଏଙ୍ଗାଲନ୍‌, ତିଆତେ ଆମ୍ୱେନ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏପଡ଼େନେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ଅଙ୍ଗା ଅନମଙ୍‌ ରୁଟିନ୍‌ ରାଓଡ଼ାଞ୍ଜି ତୁମ୍‌ ଜୋମ୍‌ତଜି ଆରି ଆନ୍ନିଙ୍‌ ଅଃଜ୍ଜୋମେଜି ଗାମ୍‌ଲେ ବନାଁୟ୍‌ବର୍‌ଲୋଙ୍‌ ଆଇଡିଡ୍‌, ଏଙ୍ଗାଲେ ଦାଉଦନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ସରେବାସିଂ ଗନ୍‌ଲେ ତି ଆ ରୁଟି ଜୋମେଞ୍ଜି ? ");
INSERT INTO juy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ରାଓଡ଼ାଞ୍ଜି ସରେବାସିଂଲୋଙନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାନ୍‌ ଅଲାତ ଏମ୍ମେଏଞ୍ଜି ଜନଙ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ଡୋସା ତଡ୍‌, ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ କେନ୍‌ଆତେ ଆମ୍ୱେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏପଡ଼େନେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ସରେବାସିଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ସୋଡ଼ା ବର୍ନେନ୍‌ କେନ୍‌ତେନ୍ନେ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ‘ଞେନ୍‌ ଅନମଙନ୍‌ ଅଃଲ୍ଲଡଜିଁୟ୍‌, ଆର୍ପାୟ୍‌ ସନାୟୁମନ୍‌ ଲଡୟ୍‌ତିଁୟ୍‌,’ କେନ୍‌ ଆ ବର୍ନେ ଆ ଗରାମ୍‌ଗାମ୍‌ ଆମ୍ୱେଞ୍ଜି ଜନାଲବେନ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଏର୍‌ଡୋସାମରଞ୍ଜିଆଡଙ୍‌ ଏଃନ୍ନବ୍‌ଡୋସାଏଜି ବନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଆ ପ୍ରବୁ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଜିର୍ରେ ଆ ରନୁକ୍କୁସିଙଞ୍ଜି ଇୟ୍‌ଲେ ଗନେ । ");
INSERT INTO juy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ଆରି ତେତ୍ତେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆସିନ୍‌ ଅବୟ୍‌ ଆସର୍‌ । ଆରି, ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଡୋସାଲେ କନାୟ୍‌କାୟ୍‌ବରନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ସାୟ୍‌ଲେ ଡକୋଲଞ୍ଜି, ତି ଆ ମନ୍‌ରାଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଅଡ଼େତେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନ୍ନିଙ୍‌ଆତେ ଅବୟ୍‌ ମେଣ୍ଡାନ୍‌ ଡକୋତେ, ଆରି ତିଆତେ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଲୋଓଙ୍‌ଲୋଙନ୍‌ ଗଲୋଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ତିଆତେ ଞମ୍‌ଲେ ଅଃତ୍ତବେ, ତିଅନ୍ତମ୍‌ ଆ ମନ୍‌ରା ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଆନା ଡକୋ ? ");
INSERT INTO juy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ମେଣ୍ଡାନ୍‌ ସିଲଡ୍‌ ମନ୍‌ରାନ୍‌ ଆରି ଗୋଗୋୟ୍‌ ମଡ଼ଗା । ତିଆସନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ବନାଁୟ୍‌ବର୍‌ଲେନ୍‌ ଅଡ଼େତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅସିନମ୍‌ ତେକ୍କେଆ ।” ସିଲତ୍ତେ ତି ମନ୍‌ରାନ୍‌ ଆସିନ୍‌ ତେକ୍କେଏନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତିଆତେ ଆରି ଅବୟ୍‌ ଆସି ଅନ୍ତମ୍‌ ମନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ବନ୍‌ଡ ପାରୁସିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ଜିସୁନ୍‌ ତିଆତେ ଜନାଡାଲେ, ତେତ୍ତେ ସିଲଡ୍‌ ଆନ୍ନାଡାଲନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌, ଆରି ଜବ୍ର ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ଆରି ସିଲତ୍ତେ ଜିସୁନ୍‌, ଆନିନ୍‌ ଆନା ତିଆତେ ଏବର୍‌ଡଙ୍‌ନେ ଗାମ୍‌ଲେ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜିଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ତିଆସନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ଆବର୍ରନେନ୍‌ ଆ ବର୍ନେ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ଗିୟ୍‌ବା, କେନ୍‌ଆନିନ୍‌ କମ୍ୱାରିମର୍‌ଞେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଞେନ୍‌ ସେଡାଲାୟ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଞେନ୍‌ ଡୁଙ୍‌ୟମ୍‌ତାୟ୍‌, ଆମଙନ୍‌ ଞେନ୍‌ ଜବ୍ର ମଅଁୟ୍‌ଡାତିଁୟ୍‌ । ପୁରାଡ଼ାଞେନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ତାୟ୍‌ ପନ୍ନେ, ଆରି ଆନିନ୍‌ ଏର୍‌ଡର୍ନେମରଞ୍ଜି ଆମଙ୍‌ ଆଜାଡ଼ି ପନ୍‌ସୁଆତିନ୍‌ ଅପ୍ପୁଙ୍‌ବର୍ତେ । ");
INSERT INTO juy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ଆନିନ୍‌ ଗୋଡ଼େନ୍‌ ଅଃନ୍ନମ୍‌ଡୁଙେ, କି ଆକ୍ରାନ୍‌ ଅଃବ୍ବାବ୍‌ବାବେ, ଆରି ଆନିନ୍‌ ମଡ୍ଡି ସାଇନ୍‌ ତନଙ୍‌ଡାଲେ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ନିୟ୍‌ ଅଃବ୍ବର୍ନେ । ");
INSERT INTO juy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ଆଜାଡ଼ି ପନ୍‌ସୁଆତିନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜିନୟେନ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ ଡାଆଜିଙନ୍‌ ଅଃଲ୍ଲବ୍‌ଗଡେ, ଆରି ଓମୋଡ୍‌ପିଙ୍କନ୍‌ ଅଃପ୍ପପ୍‌ଞିଡେ । ");
INSERT INTO juy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ଆରି ଆଞୁମ୍‌ଲୋଙନ୍‌ ଏର୍‌ଡର୍ନେମରଞ୍ଜି ଆସାତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ତିଆଡିଡ୍‌ ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି, ତି ଆ ମନ୍‌ରା ଆକାଡ଼ୁ ଆରି ଆଜାଡ୍ଡା, ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙେନ୍‌, ସିଲତ୍ତେ ତି ଆଜାଡ୍ଡାମରନ୍‌ ରପ୍ତି କଡାଡ଼ିଲନ୍‌ ଆରି ଗିୟ୍‌ଲେ ରପ୍ତିଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ଆରି, କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ସାନ୍ନିଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ତି ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ତଡ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ବନ୍‌ଡ ପାରୁସିଞ୍ଜି ତିଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆ ମନ୍‌ରା ବୁତଞ୍ଜି ଆ ସୋଡ଼ା ବାଲ୍‌ଜିବୁଲନ୍‌ ତଡ୍‌ ଡେନ୍‌ ବୁତନ୍‌ ଗଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ବନ୍‌ଡ ଆନିଞ୍ଜି ଆରିଃୟମେଞ୍ଜିଆତେ ଜିସୁନ୍‌ ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅନ୍ନିଙ୍‌ ଆ ରାଜ୍ୟ ତରଙ୍‌ଆନ୍ନା ଡେଲୋଙ୍‌ ଡେଲେ ଆ ବିରୁଦଲୋଙନ୍‌ ଡୋଲନ୍‌ ଡେନ୍‌, ତିଆତେ ନିଅଂସ ଡେତେ, ଆରି ଅନ୍ନିଙ୍‌ ଆ ଗଡ଼ା କି ଅନ୍ନିଙ୍‌ ଆସିଂ ତରଙ୍‌ଆନ୍ନା ଡେଲୋଙ୍‌ ଡେଲେ ଆ ବିରୁଦଲୋଙନ୍‌ ଡୋଲନ୍‌ ଡେନ୍‌, ତିଆତେ ରିଙ୍‌ ଗାମ୍‌ଲେ ଡକୋଲନ୍‌ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ଆରି ସନୁମନ୍‌ ସନୁମନ୍‌ଆଡଙ୍‌ ଗଙେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ ଡୋଲନ୍ନି, ଆରି ତି ଆ ରାଜ୍ୟ ଏଙ୍ଗାଡାଲେ ରିଙ୍‌ ଗାମ୍‌ଲେ ଅଲ୍‌ଡକୋନେ ? ");
INSERT INTO juy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ଞେନ୍‌ ବାଲ୍‌ଜିବୁଲନ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ ବୁତନ୍‌ ଗଙ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞଙ୍‌ନେମର୍‌ବେଞ୍ଜି ଆନା ଆ ବୋର୍ସା ବାତ୍ତେ ବୁତଞ୍ଜି ଗଙ୍‌ତଜି ? ତିଆସନ୍‌ ଆନିଞ୍ଜି ମା ପନ୍‌ସୁଆତିମର୍‌ବେଞ୍ଜି ଡେତଜି । ");
INSERT INTO juy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ବନ୍‌ଡ ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ପୁରାଡ଼ା ଆ ବୋର୍ସା ବାତ୍ତେ ବୁତଞ୍ଜି ଗଙ୍‌ତାୟ୍‌, ତିଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅମଙ୍‌ବେନ୍‌ ଅଡ଼ୋଲାୟ୍‌ନି ।” ");
INSERT INTO juy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ଅଡ଼େ ଆନ୍ନିଙ୍‌ ଆ ବପ୍ପୁମରନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଅଃଜ୍ଜିଲୋ ଡେନ୍‌, ଏଙ୍ଗାଡାଲେ ଆସିଙନ୍‌ ଗନ୍‌ଲେ ଆ ଜନବଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ରାଉଲନ୍‌ ପାଙ୍‌ଲେ ଅଲ୍‌ରପ୍ତିଏ ? ଆନିନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଜିଏନ୍‌ ଡେନ୍‌ ସିନା ଆସିଙନ୍‌ ଅଲ୍‌ରାଉନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ଆନା ଡନେମର୍‌ଞେନ୍‌ ତଡ୍‌, ଆନିନ୍‌ ବନେରାମର୍‌ଞେନ୍‌, ଆରି ଆନା ଞେନ୍‌ ସରିନ୍‌ ଅଃତ୍ତର୍ତୁମେ, ଆନିନ୍‌ ବୁର୍ବୁରାୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ମନ୍‌ରାଞ୍ଜି ଆ ଇର୍ସେ ଅଡ଼୍‌କୋନ୍‌ ଆରି ପରାନ୍‌ସାତ୍ତିବରନ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଡେତେ, ବନ୍‌ଡ ପୁରାଡ଼ାନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ନିଣ୍ଡୟ୍‌ବରନ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଅଃଡ୍ଡେଏ । ");
INSERT INTO juy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ଆରି, ଆନା ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ବର୍ତନେ, ଆନିନ୍‌ କେମାନ୍‌ ଞାଙ୍‌ତେ, ବନ୍‌ଡ ଆନା ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ବର୍ତନେ, ଆନିନ୍‌ ନମି ଆ ଜୁଗଲୋଙ୍‌ ଡେଏତୋ କି ତିକ୍କି ଆ ଜୁଗଲୋଙ୍‌ ଜନଙ୍‌ କେମାନ୍‌ ଅଃଞାଙେ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ମନଙ୍‌ ଅରାନୁବନ୍‌ ମନଙ୍‌ ଜଅନ୍‌ ଅଜତେ, ଆରି ମନଙ୍‌ତଡନ୍‌ ଆରାନୁବ୍‌ ମନଙ୍‌ତଡନ୍‌ ଆ ଜଅ ଅଜତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆଜନ୍‌ ଗିୟ୍‌ଲେ ଅନୁବନ୍‌ ଅମ୍ମଡ୍‌ତବୋ । ");
INSERT INTO juy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ଏ ବିସଜଡନ୍‌ ଆଅନ୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ତ ପେଲ୍ଲାଜି, ଏଙ୍ଗାଡାଲେ ଆମ୍ୱେଞ୍ଜି ମନଙ୍‌ ବର୍ନେନ୍‌ ବର୍ରନ୍‌ ଏରପ୍ତିତେ ? ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଉଗରନ୍‌ ଆ ବନରିୟ୍‌ଲୋଙ୍‌ ତଅଡନ୍‌ ବର୍ନେନ୍‌ ବର୍ତନେ । ");
INSERT INTO juy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ମନଙ୍‌ମରନ୍‌ ମନଙ୍‌ ଡରକ୍କୋସିଙନ୍‌ ସିଲଡ୍‌ ମନଙଞ୍ଜିଆତେ ଅମ୍‌ଡୁଙ୍‌ତାୟ୍‌, ଆରି ଏର୍‌ମନଙ୍‌ମରନ୍‌ ଏର୍‌ମନଙ୍‌ ଡରକ୍କୋସିଙନ୍‌ ସିଲଡ୍‌ ଏର୍‌ମନଙନ୍‌ଆତେ ଅମ୍‌ଡୁଙ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ମନ୍‌ରାଞ୍ଜି ଡିଅଙ୍ଗା ଏର୍‌ମନଙ୍‌ବରନ୍‌ ବର୍ତଞ୍ଜି, ତି ଅଡ଼୍‌କୋନ୍‌ ଆସନ୍‌ ପନ୍‌ସୁଆତି ଡିନ୍ନାଇଙନ୍‌ ଆନିଞ୍ଜି ଇସାବନ୍‌ ତିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ବର୍ନେବେନ୍‌ ବାତ୍ତେ ଆମ୍ୱେଞ୍ଜି ଏର୍‌ଡୋସା ଡେତବେନ୍‌, ଆରି ବର୍ନେବେନ୍‌ ବାତ୍ତେ ଆମ୍ୱେଞ୍ଜି ଡୋସାମର୍‌ ଡେତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ତିଆଡିଡ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ, ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ଅମଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ଅରମ୍ମଡନ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଏସାୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ପେଲ୍ଲାମରଞ୍ଜି ଡ ଏର୍‌ଡର୍ନେ କେଜ୍ଜାମରଞ୍ଜି ଅରମ୍ମଡନ୍‌ ସାୟ୍‌ତଜି, ବନ୍‌ଡ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜୁନସନ୍‌ ଆରମ୍ମଡ୍‌ ତୁମ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ, ଆରି ଅନ୍ନିଙ୍‌ ଆରମ୍ମଡ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଅଃଡ୍ଡେଏ । ");
INSERT INTO juy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜୁନସନ୍‌ ଏଙ୍ଗାଲେ ୟାଗି ତମ୍‌ବା ଆରି ୟାଗି ତଗଲ୍‌ ସୋଡ଼ା ଅୟନ୍‌ ଆ କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ ଡକୋଲନ୍‌, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ତିଅନ୍ତମ୍‌ ୟାଗି ତମ୍‌ବା ଆରି ୟାଗି ତଗଲ୍‌ ଅମ୍ମ ଲବନ୍‌ ଡକୋତନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ନିନିବିନ୍‌ ଆ ମନ୍‌ରାଜି ପନ୍‌ସୁଆତି ଡିନ୍ନାଇଙନ୍‌ କେନ୍‌ ନମି ଆ ମନ୍‌ରାଜି ସରିନ୍‌ ଡୋଲନ୍‌ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଡୋସାତଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଜୁନସନ୍‌ ଆନପ୍ପୁଙ୍‌ବର୍‌ ଅମ୍ମେଲେ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲଞ୍ଜି, ଆରି ଗିୟ୍‌ବା, ଜୁନସନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ବର୍ନେନ୍‌ କେନ୍‌ତେନ୍ନେ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ଆରି, ଅର୍ଜଡ଼ୋମ୍‌ ଡେସାନ୍‌ ଆ ରାଣି ପନ୍‌ସୁଆତି ଡିନ୍ନାଇଙନ୍‌ କେନ୍‌ ନମି ଆ ମନ୍‌ରାଜି ସରିନ୍‌ ଡୋଲନ୍‌ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଡୋସାତଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ସୋଲମନନ୍‌ ଆ ଜନନାବର୍‌ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ପୁର୍ତିନ୍‌ ଆନେଙ୍‌ ସିଲଡ୍‌ ଇୟ୍‌ଲାୟ୍‌, ଆରି ଗିୟ୍‌ବା, ସୋଲମନନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ବର୍ନେନ୍‌ କେନ୍‌ତେନ୍ନେ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନିନ୍‌ ଡାଆ ତଡ୍‌ ରେଙନ୍‌ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ଲୋଲୋନେନ୍‌ ଆସନ୍‌ ଡରକୋନେନ୍‌ ଇୟ୍‌ତେ ସାଜେ, ଆନିନ୍‌ ତିଆତେ ଅଃନ୍ନିୟ୍‌ଞାଙେ । ");
INSERT INTO juy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ସିଲତ୍ତେ ଆନିନ୍‌ ଗାମ୍‌ତେ, ‘ଞେନ୍‌ ଅଙ୍ଗାସିଂ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରାୟ୍‌, ତି ଅସିଂଞେନ୍‌ ୟର୍ତନେ,’ ଆନିନ୍‌ ୟର୍ରନ୍‌ ତିଆତେ ଆରିକ୍କା, ଆଜଜ, ମନଙ୍‌ଡମ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗିଜେ । ");
INSERT INTO juy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଜିର୍ରେ ଆନିନ୍‌ ସିଲଡ୍‌ ମାଡ୍ଡ ପେଲ୍ଲା ଆରି ସାତଟା ପୁରାଡ଼ାଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ଇୟ୍‌ତେ ଓରୋଙେଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତେତ୍ତେ ଗନ୍‌ଲନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଡକୋନେଜି, ଆରି ତି ଆ ମନ୍‌ରା ଆମ୍ମୁଙ୍‌ ଆ ଡଣ୍ଡ ସିଲଡ୍‌ ତିକ୍କି ଆ ଡଣ୍ଡ ଆରି ଗୋଗୋୟ୍‌ ପରାନ୍‌ସାତ୍ତିନ୍‌ ଡେତେ । କେନ୍‌ ପେଲ୍ଲାମରଞ୍ଜି ନିୟ୍‌ ତି ଅନ୍ତମ୍‌ ଡେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆବର୍ରେଞ୍ଜି ଆଡିଡ୍‌, ଆୟୋଙନ୍‌ ଡ ଆ ବୋଞାଙଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ କଡାଡ଼ିନେନ୍‌ ଆସନ୍‌ ଡୁଆରାନ୍‌ ତନଙ୍‌ଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ସିଲତ୍ତେ ଅବୟ୍‌ନେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଗିଜା, ଅୟୋଙ୍‌ନମ୍‌ ଡ ବୋଞାଙ୍‌ନମ୍‌ଜି ଆମନ୍‌ ସରିନ୍‌ କଡାଡ଼ିନେନ୍‌ ଆସନ୍‌ ଡୁଆରାନ୍‌ ଆତନଙ୍‌ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ବନ୍‌ଡ ଆନା କେନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ, ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆନା ଅୟୋଙ୍‌ଞେନ୍‌ ? ଆରି ଆନାଜି ବୋଞାଙ୍‌ଞେଞ୍ଜି ?” ");
INSERT INTO juy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ଆରି, ଆନିନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ରେଙ୍‌ ରସିଡାଲେ ବର୍ରନେ, “ଗିଜା, ଅୟୋଙ୍‌ଞେନ୍‌ ଡ ବୋଞାଙ୍‌ଞେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ ଆନା କାବ୍ବାଡ଼ାତନେ, ଆନିନ୍‌ ବୋଞାଙ୍‌ଞେନ୍‌, ତନାନ୍‌ଞେନ୍‌ ଆରି ଅୟୋଙ୍‌ଞେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ତିଆଡିନ୍ନା ଜିସୁନ୍‌ ଅସିଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଇୟ୍‌ଲେ ତଙ୍କୁମେ । ");
INSERT INTO juy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ସିଲତ୍ତେ ଜବ୍ର ମନ୍‌ରା ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ କୁଡ଼ାୟ୍‌ନେଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଇୟ୍‌ଲେ ତଙ୍କୁମେ, ଆରି ମନ୍‌ରାଞ୍ଜି ଆସର୍‌ଲଲୋଙନ୍‌ ତନଙ୍‌ଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ଆରି ଆନିନ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ଜବ୍ର ବର୍ନେଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅବୟ୍‌ ବୁବ୍ବୁଡ୍‌ନେମରନ୍‌ ବୁବ୍ବୁଡ୍‌ନେନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ଆନିନ୍‌ ବୁଡା ବୁଡା ଲାଙ୍‌ଲେଡ୍‌ ଜମ୍ମଲନ୍‌ ଅନେଙ୍‌ ତଙର୍‌ଲୋଙନ୍‌ ଗଲୋଏନ୍‌, ଆରି ଅନ୍ତିଡଞ୍ଜି ଜିର୍ରେ ତିଆତେଜି ଇୟ୍‌ଲାୟ୍‌ ଜୋମେଜି । ");
INSERT INTO juy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଅସୋୟ୍‌ ଲବନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଅରେଙ୍‌ଲଲୋଙନ୍‌ ଗଲୋଏନ୍‌, ତିଆତେ ଗୋଗୋୟ୍‌ ଲବତଡନ୍‌ ଲପଡାବ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ବନ୍‌ଡ ଓୟୋଙନ୍‌ ଆଡ୍ରୁଙ୍‌ଲନାଞନ୍‌ ଡାଗାନ୍‌ ବାତ୍ତେ ତିଆତେଜି ଜୋମ୍‌ତୋଡାଜେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆଜଡନ୍‌ ଗୋଗୋୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଲାମେନ୍‌ ତିଆତେଜି ଅସରାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଅବ୍ବାଙ୍‌ନୁବ୍‌ରେଙନ୍‌ ଗଲୋଏନ୍‌, ଆରି ଅବ୍ବାଙଞ୍ଜି ଡୋଲନ୍‌ ସୋଡ଼ାଡାଲେ ତିଆତେଜି ଲଲ୍ଲଡାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଜମ୍ମଲନ୍‌ ମନଙ୍‌ ଲବଲୋଙନ୍‌ ଗଲୋଏନ୍‌, ତିଆତେଜି ଲାଙ୍‌ଲେଡ୍‌ ବସଅ ଗୁନା, ୟାକୁଡ଼ି ଗୁନା, ଆରି ଲାଙ୍‌ଲେଡ୍‌ ତିରିସି ଗୁନା ଅଜଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଆନା ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଅଲୁଡନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅମ୍‌ଡଙେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଆମନ୍‌ ଇନିବା ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ତଜି ?” ");
INSERT INTO juy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଆ ଜରୁ ଗରାମ୍‌ଗାମଞ୍ଜି ଗନନ୍‌ଲୁଡନ୍‌ ଆସନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଜନନାନ୍‌ ଆତିୟ୍‌ତିୟ୍‌ଜି, ବନ୍‌ଡ ଆନିଞ୍ଜିଆଡଙ୍‌ ଏର୍‌ତନିୟ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ଆମଙ୍‌ ରନ୍ନାନ୍‌ ଡକୋ, ଆନିନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ, ଆମଙନ୍‌ ଆରି ଗୋଗୋୟ୍‌ତେ, ବନ୍‌ଡ ଆନା ଆମଙ୍‌ ରନ୍ନାନ୍‌ ଅବୟ୍‌ ତଡ୍‌, ଆମଙନ୍‌ ଅଙ୍ଗାତେ ଡକୋ, ତିଆତେ ନିୟ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ପନାଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ଆନିଞ୍ଜି ଗିଜାନ୍‌ ଗିଜାନ୍‌ ଅଃଗିଜେଜି ଆରି ଅମ୍‌ଡଙାନ୍‌ ଅମ୍‌ଡଙାନ୍‌ ଅଃନ୍ନମ୍‌ଡଙେଜି କି ଅଃଗନ୍‌ଲୁଡେଜି, ତିଆସନ୍‌ ଞେନ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ଆରି ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ଡେଡମ୍‌ତେ, ‘କେନ୍‌ ଆ ମନ୍‌ରାଜି ଅମ୍‌ଡଙାନ୍‌ ଅମ୍‌ଡଙାନ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି, ବନ୍‌ଡ ଇନ୍ନିଙ୍‌ ଅଃଗନ୍‌ଲୁଡେଜି, ଆରି ଗିଜାନ୍‌ ଗିଜାନ୍‌ ଗିୟ୍‌ତଜି, ବନ୍‌ଡ ଇନ୍ନିଙ୍‌ ଅଃଜ୍ଜନାଏଜି; ");
INSERT INTO juy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆ ଉଗରଞ୍ଜି କବୁଙେନ୍‌, ଆନିଞ୍ଜି ଅଲୁଡ୍‌ଲୋଙନ୍‌ କାକୁର୍ତିଃ ଅମ୍‌ଡଙ୍‌ତଜି, ଆରି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆମଡଞ୍ଜି ପିମ୍ମଡ୍‌ତଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଆମଡ୍‌ଲୋଙନ୍‌ ଅଃଗିଜେଜି, ଅଲୁଡ୍‌ଲୋଙନ୍‌ ଅଃନ୍ନମ୍‌ଡଙେଜି, ଉଗର୍‌ଲୋଙନ୍‌ ଅଃଗନ୍‌ଲୁଡେଜି, ଅମଙ୍‌ଞେନ୍‌ ଅଃୟର୍ନାଜି, ଆରି ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ମବ୍‌ନଙାଜି ।’” ");
INSERT INTO juy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ବନ୍‌ଡ ଅମଡ୍‌ବେନ୍‌ ତିଆତେ ଆଗ୍ରିୟ୍‌ତେନ୍‌, ଅଲୁଡ୍‌ବେନ୍‌ ତିଆତେ ଆରମ୍‌ଡଙ୍‌ତେନ୍‌ ଆସନ୍‌ ସନେନ୍‌ସେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଇନିଜି ଇନିଜି ଏଗିୟ୍‌ତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଜବ୍ର ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଡ ଡରମ୍ମମରଞ୍ଜି ଗିୟ୍‌ଗିଜନ୍‌ ସାଜେଞ୍ଜି, ବନ୍‌ଡ ଅଃଗିୟ୍‌ଲଜି; ଆରି ଆମ୍ୱେଞ୍ଜି ଇନିଜି ଇନିଜି ଏଅମ୍‌ଡଙ୍‌ତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଆନିଞ୍ଜି ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ସାଜେଞ୍ଜି, ବନ୍‌ଡ ଅଃନ୍ନମ୍‌ଡଙ୍‌ଲଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ବୁବ୍ବୁଡ୍‌ନେମରନ୍‌ ଆନବ୍‌ଜଙ୍‌ବର୍‌ ଆ ଗରାମ୍‌ଗାମ୍‌ ଅମ୍‌ଡଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ଆନା ରାଜ୍ୟନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଅଃଗନ୍‌ଲୁଡେ ତିଆତେ ଅନେଙ୍‌ ତଙରନ୍‌ ଆଗ୍ରଲୋଏନ୍‌ ଆ ଜମ୍ମଲ୍‌ ଅନ୍ତମ୍‌, ତି ଆ ମନ୍‌ରା ଆ ଉଗର୍‌ଲୋଙ୍‌ ଅଙ୍ଗାତେ ବନୁଡନ୍‌ ଡେଲୋ ଇର୍ସେ ପୁରାଡ଼ାନ୍‌ ଜିର୍ରେ ତିଆତେ ରାଉଲନ୍‌ ଇୟ୍‌ତାୟ୍‌ ପାଙେ । ");
INSERT INTO juy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ଆନା ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଲେ ଅବ୍‌ତାଡ଼ନ୍‌ ତିଆତେ ସର୍ଡାନ୍‌ ବାତ୍ତେ ଜାତେ ତିଆତେ ଅରେଙ୍‌ଲଲୋଙନ୍‌ ଆଗ୍ରଲୋଏନ୍‌ ଆ ଜମ୍ମଲ୍‌ ଅନ୍ତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ଆମଙନ୍‌ ଆଜଡନ୍‌ ଗୋଗୋୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଲାମେନ୍‌ ଆନିନ୍‌ ଗଡ୍ଡେଃ ମତ୍ରମ୍‌ ଗବ୍‌ରିଲନ୍‌ ଡକୋତନ୍‌, ତିକ୍କି ବର୍ନେନ୍‌ ଆସନ୍‌ ଗାମ୍‌ଲେ ଡଣ୍ଡନ୍‌, ଡନଣ୍ଡାୟନ୍‌ ଅଡ଼ୋଲାୟ୍‌ ଡେନ୍‌, ସିଲତ୍ତେ ଆନିନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ତିଆତେ ଅମ୍‌ରେଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ଆରି ଆନା ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ତେ, ବନ୍‌ଡ ଅନମେଙନ୍‌ ଆନିଃୟମ୍‌ ଡ ରନ୍ନାନ୍‌ ଆ ଗନିୟ୍‌ମଡ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଲଲ୍ଲଡାୟ୍‌ତେ, ଆନିନ୍‌ ଆରି ଅଃନ୍ନଜଏ, ତିଆତେ ଅବ୍ବାଙ୍‌ନୁବ୍‌ରେଙନ୍‌ ଆଗ୍ରଲୋଏନ୍‌ ଆ ଜମ୍ମଲ୍‌ ଅନ୍ତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ବନ୍‌ଡ ଆନା ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଗନ୍‌ଲୁଡ୍‌ତେ, ତିଆତେ ମନଙ୍‌ ଲବଲୋଙନ୍‌ ଆଗ୍ରଲୋଏନ୍‌ ଆ ଜମ୍ମଲ୍‌ ଅନ୍ତମ୍‌, ତିଆତେ ମନଙ୍‌ ଅଜତେ, ତିଆତେ ଲାଙ୍‌ଲେଡ୍‌ ବସଅ ଗୁନା, ଲାଙ୍‌ଲେଡ୍‌ ୟାକୁଡ଼ି ଗୁନା, ଲାଙ୍‌ଲେଡ୍‌ ତିରିସି ଗୁନା ଅଜତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରି ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବରେଞ୍ଜି, “ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ ବସେଙ୍‌ଲୋଙନ୍‌ ମନଙ୍‌ ଜମ୍ମଲନ୍‌ ବୁଡେନ୍ । ");
INSERT INTO juy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ବନ୍‌ଡ ମନ୍‌ରାଞ୍ଜି ଆଡ୍ରିମଡେଞ୍ଜି ଆଡିଡ୍‌ ଆ ବନେରାନ୍‌ ଜିର୍ରେ ତି ଆ ଜନ୍‌ରୋମ୍‌ଲୋଙ୍‌ ତୋଲ୍ଲୋଣିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବିଡେ କି ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ଅଙ୍ଗା ଆଡିଡ୍‌ ଜମ୍ମଲନ୍‌ ପଡାବ୍‌ଲାୟ୍‌ କି ଅଲାଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଗଲେଲାୟ୍‌, ତିଆଡିଡ୍‌ ତୋଲ୍ଲୋଣିନ୍‌ ନିୟ୍‌ ଗିୟ୍‌ତାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ସିଲତ୍ତେ କମ୍ୱାରିମରଞ୍ଜି ସାଉକାରନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, ‘ଆଜ୍ଞା, ଆମନ୍‌ ଇନି ବସେଙ୍‌ଲୋଙ୍‌ନମ୍‌ ମନଙ୍‌ ଜମ୍ମଲନ୍‌ ଅଃବ୍ବୁଡ୍‌ଲୋ ପଙ୍‌ ? ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତୋଲ୍ଲୋଣିଞ୍ଜି ଅଡ଼େଙ୍ଗା ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌ ?’ ");
INSERT INTO juy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ‘ଅବୟ୍‌ ବନେରାନ୍‌ କେନ୍‌ଆତେ ଏନ୍ନେଏନ୍‌ ।’ ଆରି, କମ୍ୱାରିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, ‘ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ତି ତୋଲ୍ଲୋଣିଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ପୁୟ୍‌ଲେ ଇୟ୍‌ ଏରୁକ୍କୁନାୟ୍‌ ପଙ୍‌ ? ଆମନ୍‌ ଅଙ୍‌ ପଙ୍‌ ଗାମ୍‌ତେ ?’ ");
INSERT INTO juy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ବନ୍‌ଡ ଆନିନ୍‌ ଗାମେନ୍‌, ‘ଇଜ୍ଜା, ଅସମୟ୍‌ ଆମ୍ୱେଞ୍ଜି ତୋଲ୍ଲୋଣିନ୍‌ ପୁୟା ପୁୟା ତି ବୟନ୍‌ ଜନ୍‌ରୋମନ୍‌ ନିୟ୍‌ ଏପୁୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ଜନ୍‌ରୋମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗଡ୍‌ନେନ୍‌ ଜାୟ୍‌ ବାଗୁନ୍‌ ଏକ୍କାନ୍‌ ସୋଡ଼ାଏତଜି, ଆରି ଜନ୍‌ରୋମନ୍‌ ଆଗ୍ରଡ୍‌ତନେନ୍‌ ଆଡିଡ୍‌ ଞେନ୍‌ ଗଡ୍‌ଗଡ୍‌ନେମରଞ୍ଜି ବର୍ତାଜି, ସୟ୍‌ସୟନ୍‌ ଆସନ୍‌ ତୋଲ୍ଲୋଣିଞ୍ଜି ଆମ୍ମୁଙ୍‌ ବିଡ୍ଡାବା, ଆରି ଜନ୍‌ରୋମନ୍‌ ମରଁୟ୍‌ଲୋଙ୍‌ଞେନ୍‌ ତର୍ତୁମ୍‌ଲେ ଡକ୍କୋବା ।’” ");
INSERT INTO juy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରି ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବରେଞ୍ଜି, “ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଅବୟ୍‌ ସୋର୍ସୋବାୟନ୍‌ ପାଙ୍‌ଲେ ଆ ବସେଙ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ଲେ ବିଡେ । ");
INSERT INTO juy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ତିଆତେ ଅଡ଼୍‌କୋ ଅବାୟନ୍‌ ସିଲଡ୍‌ ସନ୍ନା, ବନ୍‌ଡ ତିଆତେ ସୋଡ଼ାଏନ୍‌ ଡେନ୍‌ ଅଡ଼୍‌କୋ ଓଆବ୍‌ନୁବଞ୍ଜି ସିଲଡ୍‌ ସୋଡ଼ାଡାଲେ ଅବୟ୍‌ ଅରାନୁବନ୍‌ ଗଡେଲ୍‌ତେ, ଆରି ରୁଆଙନ୍‌ ଆ ଅନ୍ତିଡ୍‌ଜି ଜିର୍ରେ ଆ କେଣ୍ଡାର୍‌ଲୋଙନ୍‌ ଇୟ୍‌ତାୟ୍‌ ବସାନେଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରି ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବରେଞ୍ଜି, “ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କମିରନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ଆଇମରନ୍‌ ତିଆତେ ପାଙ୍‌ଲେ, ବାକୁଡ଼ି ଆଡ୍ଡା ଆ ଗମ୍ମଲୋଙ୍‌ ମାୟ୍‌ଲେ ରୁବ୍‌ଲେ ଡକ୍କୋଏନ୍‌, ତିକ୍କି ଅଡ଼୍‌କୋନ୍‌ କମିରନ୍‌ ମାୟ୍‌ମାୟ୍‌ଲନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ଜିସୁନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବୟନ୍‌ ତୁମ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେଞ୍ଜି, ଆରି ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଆ ବର୍ନେ ଅଃବ୍ବର୍ରଜି । ");
INSERT INTO juy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ତିଆସନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, “ଞେନ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବୟନ୍‌ ବର୍ନେନ୍‌ ବର୍ତନାୟ୍‌, ପୁର୍ତିନ୍‌ ଆରୁଲନେନ୍‌ ସିଲଡ୍‌ ଡିଅଙ୍ଗା ସନସବରଞ୍ଜି ଡକୋ, ତି ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ ବର୍ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ଆନିନ୍‌ ଅସିଙନ୍‌ ଗନ୍‌ଲନେ, ଆରି ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ବସେଙ୍‌ଲୋଙନ୍‌ ତୋଲ୍ଲୋଣିନ୍‌ ଆନବ୍‌ଜଙ୍‌ବର୍‌ ଆ ଗରାମ୍‌ଗାମ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ରେୟ୍‌ଲଙ୍‌ ବର୍ରେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆନା ମନଙ୍‌ ଜମ୍ମଲନ୍‌ ବିଡ୍‌ତେ, ଆନିନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌; ");
INSERT INTO juy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ବସେଙନ୍‌ ପୁର୍ତିନ୍‌; ମନଙ୍‌ ଜମ୍ମଲନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଆ ପସିୟ୍‌ଜି; ତୋଲ୍ଲୋଣିନ୍‌ ଇର୍ସେ ପୁରାଡ଼ାନ୍‌ ଆ ପସିୟ୍‌ଜି; ");
INSERT INTO juy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ଅଙ୍ଗା ବନେରା ତୋଲ୍ଲୋଣିନ୍‌ ବୁଡେନ୍ ଆନିନ୍‌ ସନୁମନ୍‌; ଗଡ୍‌ଗଡ୍‌ନେ ବେଡ଼ାନ୍‌ ଅନଞିଡ୍‌ ଡିନ୍ନାନ୍‌, ଆରି ଗଡ୍‌ଗଡ୍‌ନେମରଞ୍ଜି ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ତିଆସନ୍‌, ତୋଲ୍ଲୋଣିନ୍‌ ଏଙ୍ଗାଲେ ରୁକ୍କୁଡାଲେ ତଗୋଲୋଙନ୍‌ ସନୟନ୍‌ ଡେତେ, ଅନଞିଡ୍‌ ଡିନ୍ନାଇଙନ୍‌ ତିଅନ୍ତମ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତାଜି, ଆରି ଆନିଞ୍ଜି ଆ ରାଜ୍ୟନ୍‌ ସିଲଡ୍‌, ଏର୍‌ଡରମ୍ମମରଞ୍ଜି ଡ ଆନାଜି ଆନ୍ନାମରଞ୍ଜିଆଡଙ୍‌ ଇର୍ସେନ୍‌ ଅବ୍‌ଲୁମ୍‌ଲୁମେଞ୍ଜି ତି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଅବ୍‌ରୁକ୍କୁତଜି, ");
INSERT INTO juy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତଗୋସିଂଲୋଙନ୍‌ ସେଡ୍‌ତଜି, ଆନିଞ୍ଜି ତେତ୍ତେ ୟେୟେଡାନ୍‌ ଡ ରମ୍‌ରମ୍‌ଜିନ୍‌ ଡେତଜି । ");
INSERT INTO juy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ତିଆଡିଡ୍‌ ଡରମ୍ମମରଞ୍ଜି ଆପେୟନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଓୟୋଙନ୍‌ ଅନ୍ତମ୍‌ ସାଆର୍‌ ଗିୟ୍‌ତାତଜି । ଆନା ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଅଲୁଡନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅମ୍‌ଡଙେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ବସେଙ୍‌ଲୋଙନ୍‌ ଆତିଲ୍‌ତିଲନ୍‌ ଆ ରନ୍ନା ଅନ୍ତମ୍‌, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ତିଆତେ ଆଗ୍ରିଜେନ୍‌ ସଲେ ଡକ୍କୋଏନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ଜିର୍ରେ ଆନର୍ଜେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ତମ୍‌ଲୋଙ୍‌ ତମ୍‌ଲେ ତି ଆ ବସେଙ୍‌ ଇୟ୍‌ଲେ ଞିଏ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ଆରି ନିୟ୍‌, ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ବେପାରମରନ୍‌ ମନଙ୍‌ ମନଙ୍‌ ମୁକ୍ତାନ୍‌ ସାୟ୍‌ତେ; ");
INSERT INTO juy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ଆନିନ୍‌ ଅବୟ୍‌ ମଡ଼ଗାଡମ୍‌ ଆ ମୁକ୍ତା ଆଗ୍ରିଜେନ୍‌, ଆନିନ୍‌ ଜିର୍ରେ ଅଡ଼୍‌କୋନ୍‌ ଆନର୍ଜେଞ୍ଜି ତମ୍‌ଲୋଙ୍‌ ତମ୍‌ଲେ ତି ଆ ମୁକ୍ତା ଇୟ୍‌ଲେ ଞିଏ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ଆରି ନିୟ୍‌, ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଅବୟ୍‌ ଞରମ୍‌ୟ ଜାଲାନ୍‌ ଅନ୍ତମ୍‌ । ଞମ୍‌ୟମରଞ୍ଜି ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଜାଲାନ୍‌ ସେଡ୍‌ଲେ ଏର୍ଜାଡ଼ିକାନ୍‌ ଆୟଜି ଞମ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ଜାଲାନ୍‌ ଆବର୍ରିଜେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ମନ୍‌ରାଞ୍ଜି ତିଆତେ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଡିଙ୍‌ଲେ ପାଙ୍‌ଲାଜି । ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ମନଙଞ୍ଜିଆତେ ତର୍ତୁମ୍‌ଲେ ଗୁରୁଲ୍ଲିଲୋଙନ୍‌ ଡକ୍କୋଏଞ୍ଜି, ବନ୍‌ଡ ମନଙ୍‌ତଡନ୍‌ଆତେ ସେଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ଅନଞିଡ୍‌ ଡିନ୍ନାଇଙନ୍‌ ତିଅନ୍ତମ୍‌ ଡେତେ; ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଡରମ୍ମମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ପେଲ୍ଲାମରଞ୍ଜିଆଡଙ୍‌ ଆନ୍ନାତଜି, ");
INSERT INTO juy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତଗୋସିଂଲୋଙନ୍‌ ସେଡ୍‌ତଜି; ତେତ୍ତେ ଆନିଞ୍ଜି ୟେୟେଡାନ୍‌ ଡ ରମ୍‌ରମ୍‌ଜିନ୍‌ ଡେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଗନ୍‌ଲୁଡ୍‌ତବେନ୍‌ ପଙ୍‌ ?” ଆନିଞ୍ଜି ଜାଲଙେଞ୍ଜି, “ଓଓ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅବୟ୍‌ ସାଉକାରନ୍‌ ଏଙ୍ଗାଲେ ଆ ଡରକ୍କୋସିଙନ୍‌ ସିଲଡ୍‌ ଆ ସନାୟ୍‌ସାଜନ୍‌ ଅନ୍ତମ୍‌ ରଙ୍‌ ଜନବନ୍‌ ଡ ପାପୁର୍‌ ଜନବନ୍‌ ଅମ୍‌ଡୁଙ୍‌ତେ, ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଆସନ୍‌ ଞନଙନ୍‌ ଆଞ୍ରାଙେନ୍‌ ଆ ସାସ୍ତ୍ରି ତିଅନ୍ତମ୍‌ ଲୁମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ଜିସୁନ୍‌ କେନ୍‌ ଆନବ୍‌ଜଙ୍‌ବର୍‌ଜି ଆରବ୍‌ସୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଆନିନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ଆରି, ଆନିନ୍‌ ଆସାଇଡମନ୍‌ ଜିର୍ରେ ତେତ୍ତେ ଆ ରନୁକ୍କୁସିଂଲୋଙଞ୍ଜି ଞନଙନ୍‌ ଇୟ୍‌ଲେ ତିୟେ, ଆରି ମନ୍‌ରାଞ୍ଜି ସାନ୍ନିଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆ ମନ୍‌ରା ଏନ୍ନେଲେ ବର୍ନେନ୍‌ ଆସନ୍‌ ଅଡ଼େଙ୍ଗା ସିଲଡ୍‌ କେନ୍‌ ଆ ଗିଆନ ଞାଙେନ୍‌ ? ଆରି କେନ୍‌ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ଅଡ଼େଙ୍ଗା ସିଲଡ୍‌ ବୋର୍ସାନ୍‌ ଞାଙେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","କେନ୍‌ ଆନିନ୍‌ ତି ବାଡ୍ଡୋଁୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ତଡ୍‌ ପଙ୍‌ ? କେନ୍‌ ଆୟୋଙନ୍‌ ଆଞୁମ୍‌ ମରିଅମ ତଡ୍‌ ପଙ୍‌ ? ଆରି, କେନ୍‌ ଆ ବୋଞାଙଞ୍ଜି ଆଞୁମ୍‌ ଜାକୁବ, ଜୋସେପ, ସିମନ୍‌ ଆରି ଜିଉଦା ତଡ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","କେନ୍‌ ଆ ତନାନଞ୍ଜି ଇନ୍‌ଲେଞ୍ଜି ସରିନ୍‌ ତେନ୍ନେ ମନ୍‌ରାଜି ତଡ୍‌ ପଙ୍‌ ? ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆନିନ୍‌ ଅଡ଼େଙ୍ଗା ସିଲଡ୍‌ ଞାଙେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ଏନ୍ନେଲେ ବର୍ରନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗବ୍‌ରଜେଞ୍ଜି । ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆ ସାଇଡମନ୍‌ ଡ ଆସିଂଡମନ୍‌ ତୁମ୍‌ ଗନବ୍‌ରଜନ୍‌ ଞାଙ୍‌ତେ, ଆନ୍ନାରେଙ୍‌ ଆନିନ୍‌ ଗନବ୍‌ରଜନ୍‌ ଅଃଞାଙେ ।” ");
INSERT INTO juy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ଆରି, ଆନିନ୍‌ ଆ ଏର୍‌ଡର୍ନେଞ୍ଜି ଗିୟ୍‌ଲେ ତେତ୍ତେ ଗୋଗୋୟ୍‌ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଅଃଲ୍ଲୁମ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ତିଆଡିଡ୍‌ ଏରୋଦ ରାଜାନ୍‌ ଜିସୁନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ତିଆସନ୍‌ ଆନିନ୍‌ ଆ ଗୁମୁସ୍ତାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌, ଆନିନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋଲନେ, ତିଆସନ୍‌ ଆନିନ୍‌ କେନ୍‌ ଆ ବୋର୍ସା କାବ୍ବାଡ଼ାଜି ଲୁମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ଏରୋଦନ୍‌, ଆ ଓବ୍ବାନ୍‌ ପିଲିପନ୍‌ ଆ ଡୁକ୍ରି ଏରୋଦିଆନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ, ଜିଲେ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକ୍କୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଏରୋଦନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଏରୋଦିଆନ୍‌ଆଡଙ୍‌ ଡରକ୍କୋଏନ୍‌ କେନ୍‌ଆତେ ଆମନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଆଲ୍ଲେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ଆରି, ଏରୋଦନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ସାଜେନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବତଙେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜି ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଗାମ୍‌ଲେ ମାନ୍ନେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ଏରୋଦନ୍‌ ଆ କରୋକ୍କୋଡ୍‌ ଡିନ୍ନାନ୍‌ ଆରଡ଼ୋଲାଞନ୍‌, ଏରୋଦିଆନ୍‌ ଆ ଡାଙ୍ଗଡ଼ିଅନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ ତଙ୍‌ସେଙ୍‌ଡାଲନ୍‌ ଏରୋଦନ୍‌ଆଡଙ୍‌ ଅବ୍‌ମଅଁଞେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ସିଲତ୍ତେ ଏରୋଦନ୍‌ ପର୍ମାଡ଼ାଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ବାସାତମ୍‌, ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଇନି ବେଡ୍‌ତିଁୟ୍‌, ଞେନ୍‌ ତିଆତେ ତିୟ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ଆନିନ୍‌ ଆୟୋଙନ୍‌ ଆ ଞନଙ୍‌ଞଙ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ବର୍ରନେ, “ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆବବ୍‌ ତେନ୍ନେ ଅବୟ୍‌ ସଡ଼ୁଆଲୋଙନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ତିୟିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ରାଜାନ୍‌ କେନ୍‌ଆତେ ଆରମ୍‌ଡଙେନ୍‌ ଡୁକ୍କଡାଏନ୍‌ । ବନ୍‌ଡ ଆନିନ୍‌ ସରିନ୍‌ ଗାଗାନେନ୍‌ ଆତ୍ରଙ୍କୁମେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଆମ୍ମୁଙ୍‌ ଆନିନ୍‌ ପର୍ମାଡ଼ାଲନ୍‌, ତିଆସନ୍‌ ଆନିନ୍‌ ତିଆତେ ତନିୟନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ଆରି ମନ୍‌ରାନ୍‌ ଆପ୍ପାୟ୍‌ଲେ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆବବ୍‌ ଅବ୍‌ଗଗଡେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆବବନ୍‌ ଅବୟ୍‌ ସଡ଼ୁଆଲୋଙନ୍‌ ପାଙ୍‌ଲେ ତି ଆଇସିଜନ୍‌ଆଡଙ୍‌ ତିୟେଞ୍ଜି, ଆରି ଆଇସିଜନ୍‌ ତିଆତେ ଆୟୋଙନ୍‌ ଆମଙ୍‌ ପାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ସିଲତ୍ତେ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଜିର୍ରେ ମରାନ୍‌ ପାଙ୍‌ଲେ ଇୟ୍‌ଲେ ତିଲେଜି, ଆରି ଜିସୁନ୍‌ଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଇୟ୍‌ଲେ ଅବ୍‌ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆଗ୍ରବ୍ବାଏଞ୍ଜି ଆ ବର୍ନେ ଜିସୁନ୍‌ ଆରମ୍‌ଡଙେନ୍‌ ଆନିନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ତେତ୍ତେ ସିଲଡ୍‌ ସବ୍‌ଙାୟ୍‌ଲନ୍‌ ଅବୟ୍‌ ଆରିଙ୍‌ରିଙ୍‌ ଡରକୋନେଲୋଙନ୍‌ ଜିରେନ୍‌ । ମନ୍‌ରାଞ୍ଜି ତିଆତେ ଆରମ୍‌ଡଙେଞ୍ଜି ଗଡ଼ାରେଙନ୍‌ ସିଲଡ୍‌ ଜିର୍ରେ ତଙିୟ୍‌ଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସନ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ଆରି, ଜିସୁନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆଗ୍ରିଜେନ୍‌ ଇର୍ସୋୟମ୍‌ଡାଏନ୍‌, ଆରି ଆନିନ୍‌ ବମ୍ୱମ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ଅରୁବ୍‌ଲେ ଆପ୍ରାଙେନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “କେନ୍‌ତେନ୍ନେ ତ ଆରିଙ୍‌ରିଙ୍‌ଡମ୍‌, ଆରି ସାଲ୍ଲୁମେନ୍ନି, ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ସାଇରେଙନ୍‌ ଜିର୍ରେ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ଜନୋମନ୍‌ ଇୟ୍‌ ଞିଏତଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟାଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନିଞ୍ଜି ଜିର୍‌ଡଙେଜି ତଡ୍‌, ଇନ୍ନିଙ୍‌ଡେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାଗାନେନ୍‌ ତିୟ୍‌ବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଅମଙ୍‌ଲେନ୍‌ ମନ୍‌ଲୟ୍‌ ରୁଟିନ୍‌ ଡ ବାଗୁ ଅୟନ୍‌ ତୁମ୍‌ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ତିଆତେ କେନ୍‌ତେନ୍ନେ ଅମଙ୍‌ଞେନ୍‌ ପାଙାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ଆରି, ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜି ତୋଣ୍ଡୋ ଅଗାବ୍‌ଲୋଙନ୍‌ ତନଙ୍କୁମନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ତି ମନ୍‌ଲୟ୍‌ ରୁଟିନ୍‌ ଡ ବାଗୁ ଅୟନ୍‌ ଞମ୍‌ଲେ ରୁଆଙ୍‌ଗଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆଙାଙ୍‌ଡାଲନ୍‌ ଆସିର୍ବାଦଏନ୍‌ କି ରୁଟିଞ୍ଜି ରେବ୍‌ଲେ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ତିୟେଞ୍ଜି, ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ତିଆତେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବନ୍ତାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ରୁଟିନ୍‌ ଜୋମ୍‌ଲେ ବୋଓଏଞ୍ଜି, ଆରି ଆର୍‌ଲାଗାଏନ୍‌ ଆ ରୁଟିଜି ଞଙ୍‌ନେମରଞ୍ଜି ବାର ଗୁରୁଲ୍ଲି ବବ୍‌ରିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ରୁଟିନ୍‌ ଆଜ୍ରୋମେଞ୍ଜି ଆ ମନ୍‌ରାଜି, ଆଇମରଞ୍ଜି ଡ ପସିଜଞ୍ଜି ଅଃଡ୍ଡିଡିଲନେ, ଓବ୍ବାମରଞ୍ଜି ତୁମ୍‌ ମନ୍‌ଲୟ୍‌ ଅଜାର ଡେତେ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ଆମୁକ୍କାଗଡଞ୍ଜି ଅଡିଗଡ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି, ଆରି ତିଆଡିଡ୍‌ ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆରାପ୍ପାୟେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ପାର୍ତନାନେବାନ୍‌ ତୋଣ୍ଡୋ ବରୁନ୍‌ ଜିରେନ୍‌, ଆରି ଆସ୍ରାଲ୍ଲୁମେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ତେତ୍ତେ ଆତିନ୍‌ସଜନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ତିଆଡିଡ୍‌ ଡୋଙ୍ଗାନ୍‌ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ସିଲଡ୍‌ ସଙାୟ୍‌ଲୋଙ୍‌ ଡକୋଏନ୍‌, ଆରି ଆକ୍ରାନ୍‌ ଆର୍ରିଙ୍ଗେଏନ୍‌ ଅଡ୍ଡୋୟ୍‌ଡାନ୍‌ ବାତ୍ତେ ଡୋଙ୍ଗାନ୍‌ ୟୁଲନ୍‌ତଡ୍‌ଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ବନ୍‌ଡ ତଗଲନ୍‌ କମ୍‌ସିମୋଲ୍‌ ବେଡ଼ାନ୍‌ ଜିସୁନ୍‌ ତୋଣ୍ଡୋ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ତଙିୟ୍‌ଲନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ତୋଣ୍ଡୋ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆତ୍ରଙିୟ୍‌ଲନ୍‌ଆତେ ଗିୟ୍‌ଲେ ବତଙ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “କେରେ ବୁତନ୍‌” ଆରି ଆନିଞ୍ଜି ବନ୍ତଙନ୍‌ ବାତ୍ତେ ସଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ବନ୍‌ଡ ଜିସୁନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ କଡାଡ଼ିଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅବ୍ବୋମଙ୍‌ନାବା, କେନ୍‌ଆତେ ଞେନ୍‌, ବତଙ୍‌ଡଙ୍‌ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ଏ ପ୍ରବୁ, ଆଜାଡ଼ିଡମ୍‌ ଆମନ୍‌ ଡେନ୍‌, ଞେନ୍‌ ନିୟ୍‌ ତୋଣ୍ଡୋ ଡାଆଲୋଙନ୍‌ ତଙିୟ୍‌ନେନ୍‌ ଆସନ୍‌ ବରିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଜିରାୟ୍‌ ।” ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ତୋଣ୍ଡୋ ଡାଆଲୋଙନ୍‌ ତଙିୟ୍‌ଲନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ବନ୍‌ଡ ଆନିନ୍‌ ବରନ୍ତଙ୍‌ଡାନ୍‌ ଆ ରିଙ୍ଗେ ଗିୟ୍‌ଲେ ବତଙେନ୍‌, ଆରି ଆନିନ୍‌ ଡାଆଲୋଙନ୍‌ ତବୁବ୍‌ଲେ ପାଙେନ୍‌, ତିଆସନ୍‌ ଆନିନ୍‌ ବାବ୍ବାବ୍‌ଲେ ବର୍ରନେ, “ପ୍ରବୁ ଞେନ୍‌ ଡୋବିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ଜିସୁନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଆସିନ୍‌ ପାଙ୍‌ଲେ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ବରେନ୍‌, “ଏ ଅସୋୟ୍‌ ଡର୍ନେମର୍‌, ଇନିବା ଡାଲ୍‌ଗଡେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ଆରି ଆନିଞ୍ଜି ଡୋଙ୍ଗାଲୋଙନ୍‌ ଆଡ୍ରାଜେଞ୍ଜି, ରିଙ୍ଗେନ୍‌ ତଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ସିଲତ୍ତେ ଆନାଜି ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡକୋଏଞ୍ଜି, ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଲୋମ୍‌ଲେ ବରେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ଜିସୁନ୍‌ ଡ ଞଙ୍‌ନେମରଞ୍ଜି ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ପଡ୍‌ଲେ ଗିନ୍ନେସରତରେଙନ୍‌ ତୁଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ଆରି, ତେତ୍ତେ ଆ ମନ୍‌ରାଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍ମଡ୍‌ଲେ ତି ଆ ତୁୟାୟ୍‌ରେଙ୍‌ ସମ୍ପରାରେଙନ୍‌ କବରନ୍‌ ଆପ୍ପାୟେଞ୍ଜି, ଆରି ମନ୍‌ରାଞ୍ଜି ଅଡ଼୍‌କୋ ରୋଗମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ସିନ୍‌ରି ଆଲୁଡ୍‌କାବ୍‌ ତୁମ୍‌ ସନୁଙେନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ କାକୁର୍ତିଲଞ୍ଜି, ଆରି ଡିଅଙ୍ଗା ମନ୍‌ରା ସୁଙେଏଞ୍ଜି, ଅଡ଼୍‌କୋଞ୍ଜି ମନଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ତିଆଡିଡ୍‌ ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ପାରୁସିଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ଇନିବା ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆନୋକ୍କା ଆଲ୍ଲେତଜି ? ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଏର୍‌ନାସିନେନ୍‌ ଗାଗାତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଅନୋକ୍କାବେନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଆସନ୍‌ ଇନିବା ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଏଆଲ୍ଲେତେ ? ");
INSERT INTO juy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ଇସ୍ୱରନ୍‌ ବର୍ରନେ, ‘ଆପେୟ୍‌ବେନ୍‌ ଅୟୋଙ୍‌ବେନ୍‌ଆଡଙ୍‌ ମାନ୍ନେବା,’ ଆରି ‘ଆନା ଆପେୟନ୍‌ କି ଅୟୋଙନ୍‌ଆଡଙ୍‌ ସୟ୍‌ପତେ, ଆନିନ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ ।’ ");
INSERT INTO juy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଗାମ୍‌ତେ, ‘ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଅଙ୍ଗାତେ ବୟନ୍‌ ଆପେୟନ୍‌ କି ଆୟୋଙନ୍‌ଆଡଙ୍‌ ସାକ୍କେତେ ବନ୍‌, ତିଆତେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେଏନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ଆନିନ୍‌ ଆରି ଆପେୟନ୍‌ କି ଆୟୋଙନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମାନ୍ନେଏ । ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଏନ୍ନେଲେ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଆଲ୍ଲେଡାଲେ ଅନୋକ୍କାବେଞ୍ଜି ତୁମ୍‌ ଏଲୁମ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ଏ ଇସ୍କତ୍ତାମର୍‌ଜି, ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ବର୍ନେଲୋଙ୍‌ବେନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘କେନ୍‌ ଆ ମନ୍‌ରାଜି ତଅଡନ୍‌ ବାତ୍ତେ ଞେନ୍‌ଆଡଙ୍‌ ମାନ୍ନେତିଁୟ୍‌ଜି, ବନ୍‌ଡ ଆ ଉଗରଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ସଙାୟ୍‌ଡମ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ଆନିଞ୍ଜି କାଜ୍ଜାନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସେନ୍‌ପୁର୍‌ତିଁୟ୍‌ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆ ଞନଙ୍‌ଜି ବନାଁୟ୍‌ବର୍‌ଞେନ୍‌ ଗାମ୍‌ଲେ ଞନଙନ୍‌ ତିୟ୍‌ତଜି ।’” ");
INSERT INTO juy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅମ୍‌ଡଙ୍‌ବା ଆରି ଗନ୍‌ଲୁଡ୍‌ବେନ୍‌ତୋ । ");
INSERT INTO juy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ଅଙ୍ଗାତେ ମନ୍‌ରାନ୍‌ ଆ ତଅଡ୍‌ଗଡ୍‌ ଗନ୍‌ତେ, ତିଆତେ ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଅଃନ୍ନେମେଏ, ବନ୍‌ଡ ତଅଡନ୍‌ ସିଲଡ୍‌ ଅଙ୍ଗାତେ ଡୁଙ୍‌ତନାୟ୍‌, ତିଆତେ ମା ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଏମ୍ମେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ତିଆଡିଡ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ପାରୁସିଞ୍ଜି କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଗରୟ୍‌ମଡେଞ୍ଜି, କେନ୍‌ଆତେ ଆମନ୍‌ ଜନା ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଅଙ୍ଗା ଅରାନୁବ୍‌ଜି ଅଃଗୁଲୋ, ତି ଅଡ଼୍‌କୋନ୍‌ ପୁୟାୟ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ବାଜି, ଆନିଞ୍ଜି ଆକାଡ଼ୁଜି, ଆନିଞ୍ଜି କାଡ଼ୁମରଞ୍ଜିଆଡଙ୍‌ ତୁରିୟ୍‌ତଜି; ଅବୟ୍‌ କାଡ଼ୁମରନ୍‌ ଆରି ଅବୟ୍‌ କାଡ଼ୁମରନ୍‌ଆଡଙ୍‌ ତୁରିୟେନ୍‌ ଡେନ୍‌, ବାଗୁଞ୍ଜି ଲୋଓଙ୍‌ଲୋଙନ୍‌ ଗଲୋତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଆ ଗରାମ୍‌ଗାମ୍‌ ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ବର୍ରେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ପଙ୍‌ ନମିନ୍ତାନ୍‌ ଅଃଗନ୍‌ଲୁଡ୍‌ବେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ଅଙ୍ଗାତେ ତଅଡ୍‌ଗଡ୍‌ ଗନ୍‌ତେ, ତିଆତେ କିମ୍ପୋଙ୍‌ଲୋଙନ୍‌ ଜିର୍ରେ, ତିଆତେ ଆରି ଡଅଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ତେ, ତିଆତେ ଆମ୍ୱେନ୍‌ ଅଃଜ୍ଜନାବେନ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ବନ୍‌ଡ ଅଙ୍ଗାତେ ତଅଡ୍‌ଗଡ୍‌ ଡୁଙ୍‌ତନାୟ୍‌, ତିଆତେ ଉଗରନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ତନାୟ୍‌, ଆରି ତିଆତେ ମା ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଏମ୍ମେତେ । ");
INSERT INTO juy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଉଗରନ୍‌ ସିଲଡ୍‌ ପରାନ୍‌ସାତ୍ତିନ୍‌ ଆନିଃୟମ୍‌, ସମ୍ୱବ୍‌ମରନ୍‌, ଡାରିନେନ୍‌, ଜୋଣ୍ଡଡ଼ାନେନ୍‌, ରାଉନେନ୍‌, କଣ୍ଡାୟ୍‌ସାକିନ୍‌ ଆରି ନିଣ୍ଡୟ୍‌ବରନ୍‌ ଡୁଙ୍‌ତନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ମା ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଏମ୍ମେତେ, ବନ୍‌ଡ ମନ୍‌ରାନ୍‌ ଏର୍‌ନାସିନେନ୍‌ ଗାଗାଲନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଅଃଡ୍ଡେଏ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ସୋରନ୍‌ ଡ ସିଦୋନ ଡେସାରେଙନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ଆରି ଗିୟ୍‌ବା, ତି ଆ ସଣ୍ଡି ସିଲଡ୍‌ ଅବୟ୍‌ କିନାନିଅବଜନ୍‌ ଜିର୍ରେ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ, “ଏ ପ୍ରବୁ, ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମିଁୟ୍‌, ଡାଙ୍ଗଡ଼ିଅନ୍‌ଞେନ୍‌ ବୁତନ୍‌ ସୁମେନ୍‌ ଆରି ଆନିନ୍‌ ବବରନ୍ତଙନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବପଦ ଓୟ୍‌ଲେ ଅଃଜ୍ଜାଲଙ୍‌ଲୋ । ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ କାକୁର୍ତିଡାଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “କେନ୍‌ଆନିନ୍‌ ଲଆପ୍ପାୟା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ବାବ୍ବାବ୍‌ଲେକାଁୟ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙ୍‌ପାଙ୍‌ଲଙ୍‌ତନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆରାଡ଼ଏଞ୍ଜି ଆ ମେଣ୍ଡାଜି ଅନ୍ତମ୍‌ ଇସ୍ରାଏଲ୍‌ କେଜ୍ଜାଲୋଙନ୍‌ ଆରାଡ଼ଏଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ଞେନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ବନ୍‌ଡ ତି ଆଇମରନ୍‌ ତୁଡ଼ୁମ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଲୋମ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଏ ପ୍ରବୁ, ଞେନ୍‌ଆଡଙ୍‌ ସାଜଇଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ପସିଜଞ୍ଜି ଆ ଜନୋମ୍‌ ପାଙ୍‌ଲେ କିନ୍‌ସଡଞ୍ଜି ଆମଙ୍‌ ଅଃସେଡ୍‌ବୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ବନ୍‌ଡ ତି ଆଇମରନ୍‌ ଗାମେନ୍‌, “ଓଓ, ପ୍ରବୁ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କିନ୍‌ସଡଞ୍ଜି ନିୟ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ସାଉକାର ଆ ମେଜଲୋଙ୍‌ ସିଲଡ୍‌ ଆରସେଡ୍‌ତେନ୍ ଆ ସଙ୍କୁରାଜି ଜୋମ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଆଇମର୍‌, ଡର୍ନେନମ୍‌ ସୋଡ଼ାଡମ୍‌, ଇସ୍ସୁମ୍‌ନମ୍‌ ଅନ୍ତମ୍‌ ଆମନ୍‌ ଆସନ୍‌ ଡେଏତୋ ।” ତି ଆ ବନେଡ଼ା ମା ଆ ଡାଙ୍ଗଡ଼ିଅନନ୍‌ ମନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଜିର୍ରେ ଗାଲିଲି ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ତୁୟାୟ୍‌ ଜିରେନ୍‌, ଆରି ତୋଣ୍ଡୋ ବରୁନ୍‌ ଜିର୍ରେ ତେତ୍ତେ ଇୟ୍‌ଲେ ତଙ୍କୁମେ । ");
INSERT INTO juy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ଆରି, ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ସୋତ୍ତାମରନ୍‌, ଗଡ଼ୁଡ୍‌ମରନ୍‌, କାଡ଼ୁମରନ୍‌, ଜାଡ୍ଡାମରନ୍‌ ଡ ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ରୋଗମର୍‌ଜିଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଜିସୁନ୍‌ ଆଜଙ୍‌ବା ଇୟ୍‌ଲାୟ୍‌ ତମ୍ମିଜେଜି, ଆରି ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ଜାଡ୍ଡାମରଞ୍ଜି କଡାଡ଼ିଲଞ୍ଜି, ଗଡ଼ୁଡ୍‌ମରଞ୍ଜି ମନଙେଞ୍ଜି, ସୋତ୍ତାମରଞ୍ଜି ତଙିୟ୍‌ଲଞ୍ଜି ଆରି କାଡ଼ୁମରଞ୍ଜି ରପ୍ତି ଗିଜେଞ୍ଜି, ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ସାନ୍ନି ଡେଏଞ୍ଜି କି ଇସ୍ରାଏଲନ୍‌ ଆ ଇସ୍ୱରଆଡଙ୍‌ ଅବ୍‌ଗୁଗୁଏଞ୍ଜି ଅବ୍‌ପେମେଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ଆରି, ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ବରେଞ୍ଜି, “କେନ୍‌ ଆ ମନ୍‌ରାଜି ଆସନ୍‌ ଞେନ୍‌ ଇର୍ସୋୟମ୍‌ଡାତିଁୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆନିଞ୍ଜି ୟାଗି ଡିନ୍ନା ଡେଏନ୍ନି ଞେନ୍‌ ସରିନ୍‌ ଡକୋଜି ଆରି କେନ୍‌ ଆମଙଞ୍ଜି ଇନ୍ନିଙ୍‌ ଜନୋମ୍‌ଜୋମ୍‌ ତଡ୍‌; କେନ୍‌ଆନିଞ୍ଜି ଜିରେଞ୍ଜି ଆଡିଡ୍‌ ତଙର୍‌ଲୋଙନ୍‌ ଅସମୟ୍‌ ଇୟ୍‌ତେ ରାଇଡେଞ୍ଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆଡୋଲେଜନ୍‌ ଅନାପ୍ପାୟନ୍‌ ଞେନ୍‌ ଅଃଲ୍ଲଡଜିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଡିୟ୍‌ନେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ବୋଓନ୍‌ ଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଅଡ଼େଙ୍ଗା ସିଲଡ୍‌ ଡିୟ୍‌ତେ ରୁଟିନ୍‌ ଞାଙ୍‌ବୋ ?” ");
INSERT INTO juy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅମଙ୍‌ବେନ୍‌ ଡିଅଙ୍ଗା ରୁଟିନ୍‌ ଡକୋ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ସାତଟା ରୁଟିନ୍‌, ଆରି ଅସୋୟ୍‌ ସନ୍ନାରାଡମ୍‌ ଆ ଆୟ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ତିଆସନ୍‌ ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଲବଲୋଙନ୍‌ ତନଙ୍କୁମନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ଆରି ଆନିନ୍‌ ତି ସାତଟା ରୁଟିନ୍‌ ଡ ଅୟନ୍‌ ଞମ୍‌ଲେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସନେନ୍‌ସେନନ୍‌ ତିୟ୍‌ଲେ ତିଆତେଜି ରେବ୍‌ଲେ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ତିୟେଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ତିଆତେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ଆନିଞ୍ଜି ଜୋମ୍‌ଲୋଙ୍‌ ଜୋମ୍‌ଲେ ବୋଓଏଞ୍ଜି କି ଡିଅଙ୍ଗା ରୁଟିନ୍‌ ଲାଗାଏନ୍‌, ତିଆତେ ଆନିଞ୍ଜି ସାତ ଗୁରୁଲ୍ଲି ବବ୍‌ରିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ରୁଟିନ୍‌ ଆଜ୍ରୋମେଞ୍ଜି ଆ ମନ୍‌ରାଜି, ଆଇମରଞ୍ଜି ଡ ପସିଜଞ୍ଜି ଅଃଡ୍ଡିଡିଲନେ, ଓବ୍ବାମରଞ୍ଜି ଉଞ୍ଜି ଅଜାର ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ମଗଦାନନ୍‌ ଆ ସଣ୍ଡି ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ପାରୁସିଞ୍ଜି ଡ ସାଦୁକିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ମନାଲ୍‌ମାଲନ୍‌ ଆସନ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ଅରମ୍ମଡନ୍‌ ଅନବ୍‌ତୁଜନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ସାଲ୍ଲୁମ୍‌ ବେଡ଼ାନ୍‌ ଏଗାମ୍‌ତେ, ‘ସାଡ୍‌ତିର୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙନ୍‌ ଲୁଲୁଡମ୍‌ ଡେଏନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ଆରି, ଡୋତାନ୍‌ ଏଗାମ୍‌ତେ, ‘ଲଙେ ରିଙ୍ଗେତିରନ୍‌ ଅଡ଼ୋତାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙନ୍‌ ଲୁଲୁଡମ୍‌ ଡେଏନ୍‌ ଆରି ମେଗନ୍‌ ଡୋଲନେ ।’ ଆମ୍ୱେଞ୍ଜି ରୁଆଙନ୍‌ ଗିୟ୍‌ଲେ ତରୁବନ୍‌ ଆ ବର୍ନେ ଏଜନାତେ, ବନ୍‌ଡ ଡିନ୍ନାନ୍‌ ଆରମ୍ମଡ୍‌ ଜନାଲେ ଏଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ପେଲ୍ଲାମରଞ୍ଜି ଡ ଏର୍‌ଡର୍ନେମରଞ୍ଜି ଅରମ୍ମଡନ୍‌ ସାୟ୍‌ତଜି, ବନ୍‌ଡ ଜୁନସନ୍‌ ଆରମ୍ମଡ୍‌ ତୁମ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ, ଆରି ଅନ୍ନିଙ୍‌ ଆରମ୍ମଡ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଅଃଡ୍ଡେଏ” ଆରି ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆନ୍ନାରେଙ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ଞଙ୍‌ନେମରଞ୍ଜି ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ରୁଟିନ୍‌ ଆପନାଙ୍‌ ଆସନ୍‌ କରୋଡାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଗିୟ୍‌ଡମ୍‌ନାବା, ପାରୁସିଞ୍ଜି ଡ ସାଦୁକିଞ୍ଜି ଆ କମିର ସିଲଡ୍‌ ଆବ୍ବୟ୍‌ଲନ୍‌ ଡକୋନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ଞଙ୍‌ନେମରଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ରୁଟିନ୍‌ ଅଃପ୍ପାଙ୍‌ଲାୟ୍‌ବୋ ତିଆସନ୍‌ ଆନିନ୍‌ ଏନ୍ନେଲେ ବର୍ରନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ଜିସୁନ୍‌ ତିଆତେ ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଅସୋୟ୍‌ ଡର୍ନେମର୍‌ଜି, ଅମଙ୍‌ବେନ୍‌ ରୁଟି ତଡ୍‌ ଗାମ୍‌ଲେ ଇନିବା ତର୍ଡମ୍‌ ଏକଡାଡ଼ିତନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ଆମ୍ୱେଞ୍ଜି ଇନି ନମିନ୍ତାନ୍‌ ଅଃଗନ୍‌ଲୁଡ୍‌ବେନ୍‌ ପଙ୍‌ ? ମନ୍‌ଲୟ୍‌ ରୁଟିନ୍‌ ମନ୍‌ଲୟ୍‌ ଅଜାର ମନ୍‌ରାଞ୍ଜି ବରାନ୍ତେଲାଞନ୍‌ ଆଡିଡ୍‌, ଆମ୍ୱେଞ୍ଜି ଡିଅଙ୍ଗା ଗୁରୁଲ୍ଲି ରୁଟିନ୍‌ ଏବବ୍‌ରିଜେନ୍‌ ? ତିଆତେ ମନ୍ନେବା । ");
INSERT INTO juy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ଆରି ସାତଟା ରୁଟିନ୍‌ ଉଞ୍ଜି ଅଜାର ମନ୍‌ରାଞ୍ଜି ବରାନ୍ତେଲାଞନ୍‌ ଆଡିଡ୍‌, ଆମ୍ୱେଞ୍ଜି ଡିଅଙ୍ଗା ଗୁରୁଲ୍ଲି ରୁଟିନ୍‌ ଏବବ୍‌ରିଜେନ୍‌ ? ତିଆତେଜି ମନ୍ନେଜି ତଡ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","କେନ୍‌ଆତେ ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲେ ଅଃଗନ୍‌ଲୁଡ୍‌ବେନ୍‌ ? ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ରୁଟିନ୍‌ ଆ ବର୍ନେ ଅଃବ୍ବର୍ରବେନ୍‌, ବନ୍‌ଡ ପାରୁସିଞ୍ଜି ଡ ସାଦୁକିଞ୍ଜି ଆ କମିର ସିଲଡ୍‌ ଆବ୍ବୟ୍‌ଲନ୍‌ ଡକୋନାବା ଗାମ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ଜିସୁନ୍‌ ରୁଟିନ୍‌ ଆ କମିର ସିଲଡ୍‌ ଆବ୍ବୟ୍‌ଲନ୍‌ ଡକୋନେନ୍‌ ଆସନ୍‌ ଏର୍‌ବନରନ୍‌ ପାରୁସିଞ୍ଜି ଡ ସାଦୁକିଞ୍ଜି ଆ ଞନଙ୍‌ ସିଲଡ୍‌ ଆବ୍ବୟ୍‌ଲନ୍‌ ଡକୋନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି ଗାମ୍‌ଲେ ତିଆଡିଡ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଗନ୍‌ଲୁଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ କାଇସରିଆ ପିଲିପିରେଙନ୍‌ ଜିର୍ରେ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, “ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନା, ଆରି ମନ୍‌ରାଞ୍ଜି ଇନି ଗାମ୍‌ତଜି ?” ");
INSERT INTO juy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଲାଙ୍‌ଲେନ୍ନେ ଗାମ୍‌ତଜି, ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌, ଲାଙ୍‌ଲେନ୍ନେ ଗାମ୍‌ତଜି, ଏଲିଅନ୍‌, ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଗାମ୍‌ତଜି, ଜିରିମିଅନ୍‌, ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବନ୍‌ଡ ଞେନ୍‌ ଆନା, ଆରି ଆମ୍ୱେଞ୍ଜି ଇନି ଏଗାମ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ସିମନ୍‌ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆମନ୍‌ କ୍ରିସ୍ଟନ୍‌, ଆମେଙ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ସିଲତ୍ତେ ଜିସୁନ୍‌ ସିମନନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଜୁନସନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ପିତ୍ର, ଆମନ୍‌ କରମ୍ମାଡମ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରାନ୍‌ କେନ୍‌ଆତେ ଆମନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ଜନାଲମ୍‌, ଆର୍ପାୟ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ କେନ୍‌ଆତେ ଆମନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଜନାଲମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ଆରି, ଞେନ୍‌ ନିୟ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, ଆମନ୍‌ ପିତ୍ର ଆ ଗରାମ୍‌ଗାମନ୍‌ ଜଲେଙ୍‌, ଆରି କେନ୍‌ ଆ ଜଲେଙ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଞେନ୍‌ ମଣ୍ଡଡ଼ିଞେନ୍‌ ତବ୍‌ନଙ୍‌ତାୟ୍‌, ଆରି ରନବୁ ଡରକୋନେସିଙନ୍‌ ଆ ବପ୍ପୁ ନିୟ୍‌ ତିଆତେ ଅବ୍ବାରେଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଆ କଡ୍ଡା ତିୟ୍‌ତମ୍‌, ଆରି ଆମନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଅଙ୍ଗାତେ ଜିତେ, ରୁଆଙ୍‌ଲୋଙନ୍‌ ତିଆତେ ଜିତନେ, ଆରି ପୁର୍ତିଲୋଙନ୍‌ ଅଙ୍ଗାତେ ଉୟ୍‌ତେ, ରୁଆଙ୍‌ଲୋଙନ୍‌ ତିଆତେ ଉୟ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ତିଆଡିଡ୍‌ ଆନିନ୍‌ କ୍ରିସ୍ଟ ଗାମ୍‌ଲେ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ଏବର୍‌ଡଙ୍‌ନେ ଗାମ୍‌ଲେ ଆନିନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଜିରୁସାଲମନ୍‌ ଅନିୟନ୍‌ ଡେତେ, ଆରି ପାପୁର୍‌ମରଞ୍ଜି, ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଏମ୍ମେତିଁୟ୍‌ଜି କି ରବ୍ବୁତିଁୟ୍‌ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ଞେନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବ ଅନେଙ୍‌ଗଡ୍‌ ଓରୋଙ୍‌ଡାଲେ ଇୟ୍‌ଲେ କଞେ, “ପ୍ରବୁନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସାୟୁମମ୍‌ତୋ, ଆମନ୍‌ ଆସନ୍‌ ଆଙ୍ଗିୟ୍‌ ଏନ୍ନେଲେ ଡେଡଙ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ସନୁମ୍‌, ମୁକ୍କାବାଞେନ୍‌ ସିଲଡ୍‌ ସବ୍‌ଙାୟ୍‌ନା ! ଆମନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ଡନଙ୍‌ଡଙନ୍‌ ଅନ୍ତମ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଏର୍‌ନିଃୟମନ୍‌, ମନ୍‌ରାନ୍‌ ଆ ବର୍ନେ ଇୟମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନ୍ନିଙ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସନଣ୍ଡୋଙନ୍‌ ଆସନ୍‌ ଲଡଜେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ଡମ୍‌ ମୁର୍ସେଡମ୍‌ନେତୋ, ଆରି ଆଅକ୍କାଡଙନ୍‌ ବୋୟ୍‌ଲେ ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ତୋ । ");
INSERT INTO juy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ଆନମେଙନ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଅବ୍ବଡ଼ୟ୍‌ତେ, ଆରି ଆନା ଞେନ୍‌ ଆସନ୍‌ ଆନମେଙନ୍‌ ଅବ୍ବଡ଼ୟ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ଆରି, ମନ୍‌ରାନ୍‌ ସମ୍ପରା ପୁର୍ତିନ୍‌ ଞାଙ୍‌ଲୋଙ୍‌ ଞାଙ୍‌ଲେ ଆନମେଙନ୍‌ ଅବ୍ବଡ଼ଜେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇନି ଆ ଲାବ ଡେଏ ? ଅଡ଼େ ମନ୍‌ରାନ୍‌ ଆନମେଙନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଆ ପାଲ୍‌ତେଙନ୍‌ ଇନି ତିୟ୍‌ଲେ ରପ୍ତିତେ ? ");
INSERT INTO juy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆପେୟନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ସରିନ୍‌ ଜିର୍ତାୟ୍‌ ଆରି ତିଆଡିଡ୍‌ ଆନିନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ କାବ୍ବାଡ଼ାଞ୍ଜି ଗିୟ୍‌ଲେ ବଡିନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତିୟେଜି । ");
INSERT INTO juy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ରାଜ୍ୟଲୋଙନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜିରାଞନ୍‌ ଜାୟ୍‌ କେନ୍‌ତେନ୍ନେ ଆତନଙନ୍‌ ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ଏଙ୍ଗାଲେ ଜନଙ୍‌ ରନବୁନ୍‌ ଏର୍‌ମନାୟ୍‌ମାଜନ୍‌ ଡକୋତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ତୁଡ୍ରୁ ଡିନ୍ନା ଆ ତିକ୍କି ଜିସୁନ୍‌ ପିତ୍ରନ୍‌, ଜାକୁବନ୍‌ ଡ ଆ ବୋଞାଙନ୍‌ ଜନନ୍‌ଆଡଙ୍‌ ସରିନ୍‌ ଓରୋଙ୍‌ଡାଲେ ଅବୟ୍‌ ଡେଙ୍ଗାଡମ୍‌ ଆ ବରୁଲୋଙ୍‌ ଜିରେଞ୍ଜି । ତେତ୍ତେ ଆରି ଆନ୍ନିଙ୍‌ ଅଃଡ୍ଡକୋଲଜି, ଆନିଞ୍ଜି ତୁମ୍‌ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ଆରି, ଆତେମଡଞ୍ଜି ଜିସୁନ୍‌ ବାଙ୍‌ସାୟ୍‌ଲନେ, ଆ ମୁକ୍କାନ୍‌ ଓୟୋଙନ୍‌ ଅନ୍ତମ୍‌ ସାଆର୍‌ଡମ୍‌ ଡେଏନ୍‌, ଆରି ଆ ଅଙ୍ଗିନ୍‌ ଆତ୍ରରାଃତେନ୍‌ ଅନ୍ତମ୍‌ ଜେଏଡମ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ଆରି ମୋସାନ୍‌ ଡ ଏଲିଅନ୍‌ ଜିସୁନ୍‌ ସରିନ୍‌ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ତି ୟାଗି ଞଙ୍‌ନେମରଞ୍ଜି ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ପ୍ରବୁ ବୟ୍‌ଲେଙ୍‌ ଇନ୍‌ଲେଞ୍ଜି କେନ୍‌ତେନ୍ନେ ଡକୋ, ଆମନ୍‌ ଲଡୟ୍‌ଲମ୍‌ ଡେନ୍‌ କେନ୍‌ତେନ୍ନେ ଞେନ୍‌ ୟାଗି ଅନ୍‌ସିଙନ୍‌ ଗୁତାୟ୍‌, ଆମନ୍‌ ଆସନ୍‌ ଅବୟ୍‌, ମୋସାନ୍‌ ଆସନ୍‌ ଅବୟ୍‌, ଆରି ଏଲିଅନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ପିତ୍ରନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆବର୍ରନେନ୍‌ ଆଡିଡ୍‌, ଗିୟ୍‌ବା, ଆତ୍ରରାଃତେନ୍‌ ଆ ମେଗ ଅବୟ୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁବେଜି, ଆରି ତି ଆ ମେଗ ସିଲଡ୍‌ କେନ୍‌ ଆ ସର୍ରଙ୍‌ ଅଡ଼ୋଲାୟ୍‌, “କେନ୍‌ଆନିନ୍‌ ଡନୁଙ୍‌ୟମ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌, କେନ୍‌ ଆମଙନ୍‌ ଞେନ୍‌ ମଅଁୟ୍‌ତିଁୟ୍‌, କେନ୍‌ ଆ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","କେନ୍‌ଆତେ ଞଙ୍‌ନେମରଞ୍ଜି ଆରମ୍‌ଡଙେଞ୍ଜି ତୁମ୍ମୁଡାଲେ ଅକୁଡେଞ୍ଜି, ଆରି ମାଡ୍ଡ ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଜିର୍ରାୟ୍‌ କି ଆନିଞ୍ଜିଆଡଙ୍‌ ସୁଙେଡାଲେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଡୋନାବା, ବତଙ୍‌ଡଙ୍‌ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ଆରି, ଆନିଞ୍ଜି ତୋଣ୍ଡୋନ୍‌ ଆରାଙାଙେଞ୍ଜି, ଜିସୁନ୍‌ଆଡଙ୍‌ ତୁମ୍‌ ଗିଜେଞ୍ଜି, ଆରି ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃଗିୟ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ଆନିଞ୍ଜି ବରୁନ୍‌ ସିଲଡ୍‌ ଆପ୍ରଡ୍‌ଲଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବାଁୟ୍‌ଲେ ବରେଞ୍ଜି, “ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ୟର୍ମେଙ୍‌ଲେ ଅଣ୍ଡ୍ରଙ୍‌ ଡୋନେନ୍‌ ଜାୟ୍‌ କେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଗ୍ରିଜେନ୍‌ଆତେ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ଏବର୍‌ଡଙ୍‌ନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ଆରି, ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଏଲିଅନ୍‌ ରୟ୍‌ ଆମ୍ମୁଙ୍‌ ଜିର୍ତାୟ୍‌ ଗାମ୍‌ଲେ ସାସ୍ତ୍ରିଞ୍ଜି ଏଙ୍ଗାଲେ ବର୍ତଞ୍ଜି ?” ");
INSERT INTO juy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ ଏଲିଅନ୍‌ ରୟ୍‌ବନ୍‌ ଆମ୍ମୁଙ୍‌ ଜିର୍ତାୟ୍‌ କି ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଇୟ୍‌ତାୟ୍‌ ବାର୍‌ତୁବେ; ");
INSERT INTO juy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଏଲିଅନ୍‌ ଇୟ୍‌ଲାୟ୍‌ନି, ବନ୍‌ଡ ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନମ୍ମଡ୍‌ଲଜି ଆରି ଅଙ୍ଗାତେ ଲଡଜେଞ୍ଜି ଏତ୍ତେଲେ ଆନିନ୍‌ ଆସନ୍‌ ଲୁମେଞ୍ଜି । ତିଅନ୍ତମ୍‌ ଆନିଞ୍ଜି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଏମ୍ମେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ଜିସୁନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ ଗାମ୍‌ଲେ ଞଙ୍‌ନେମରଞ୍ଜି ତିଆଡିଡ୍‌ ଗନ୍‌ଲୁଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ଆରି ଜିସୁନ୍‌ ଡ ଞଙ୍‌ନେମରଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଆଡିଡ୍‌, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରାୟ୍‌ କି ତୁଡ଼ୁମ୍‌ଡାଲେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ, ");
INSERT INTO juy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ଏ ପ୍ରବୁ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ କୁଣ୍ଡିଲିଆତେ ଆରି ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ, ଆନିନ୍‌ ବତରନ୍‌ କି ବତରନ୍‌ ତଗୋଲୋଙନ୍‌ ଡ ବତରନ୍‌ କି ବତରନ୍‌ ଡାଆଲୋଙନ୍‌ ଗଲୋତେ । ");
INSERT INTO juy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ଆମଙ୍‌ ଓରୋଙ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଏର୍‌ଡର୍ନେମର୍‌, ଆଡ଼ତଙର୍‌ମରଞ୍ଜି ଆ କେଜ୍ଜା, ଡିଅଙ୍ଗା ଡିନ୍ନା ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋନାୟ୍‌ ? ଡିଅଙ୍ଗା ଡିନ୍ନା ଞେନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ବେଞ୍ଜି ସଏଆୟ୍‌ ? ତି ଓବ୍ବାସିଜନ୍‌ କେନ୍‌ତେନ୍ନେ ଅମଙ୍‌ଞେନ୍‌ ଓରୋଙାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ଆରି, ଜିସୁନ୍‌ ବୁତନ୍‌ଆଡଙ୍‌ ଆବ୍ରବ୍‌ତଙେନ୍‌ ବୁତନ୍‌ ପସିଜନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ କି ପସିଜନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ମନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଅଜନା ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଇନିବା ଇନ୍‌ଲେନ୍‌ କେନ୍‌ଆତେ ଗଙ୍‌ଲେ ଏଃର୍ରପ୍ତିଲାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଡର୍ନେବେନ୍‌ ଅସୋୟ୍‌ଡମ୍‌ ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ବୁତନ୍‌ ଗଙ୍‌ଲେ ଏଃର୍ରପ୍ତିଲୋ, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଡର୍ନେବେନ୍‌ ଅବୟ୍‌ ସୋର୍ସୋବାୟନ୍‌ ଅନ୍ତମ୍‌ ଡକୋଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଆ ବରୁ ‘କେନ୍‌ତେନ୍ନେ ସିଲଡ୍‌ ଡେଡ୍‌ନା’ ଏଗାମେନ୍‌ ଡେନ୍‌ ତିଆତେ ଡେଡ୍‌ତନେ, ଆରି ଡର୍ନେବେନ୍‌ ବାତ୍ତେ ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ଲେ ଏରପ୍ତିତେ । ");
INSERT INTO juy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ବନ୍‌ଡ ପାର୍ତନାନ୍‌ ଡ ଆନମ୍‌ନେନ୍‌ ତୁମ୍‌ ବାତ୍ତେ କେନ୍‌ ଏନ୍ନେଗନ୍‌ ଆ ବୁତ ରପ୍ତି ଗଙ୍‌ତନେ, ଆରି ଅନ୍ନିଙ୍‌ ବାତ୍ତେ ଗଙ୍‌ଲେ ଅଃର୍ରପ୍ତିନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଗାଲିଲିଲୋଙନ୍‌ ଆର୍ରୁକ୍କୁଲଞ୍ଜି ଆଡିଡ୍‌, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ରୟ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ତି ଆ ମନ୍‌ରାଜି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ରବ୍ବୁତଜି ଆରି ଆନିନ୍‌ ଏର୍ତାଲୋଙ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋତନେ ।” ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଆକ୍ରାନ୍‌ ଅନିଃୟମ୍‌ଡାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ଜିସୁନ୍‌ ଡ ଞଙ୍‌ନେମରଞ୍ଜି କପର୍ନାଉମନ୍‌ ଆଜିର୍ରାଞଞ୍ଜି, ସରେବାସିଙନ୍‌ ଆ ପାନୁବେଡ୍‌ମର୍‌ଜି ପିତ୍ରନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଞନଙ୍‌ତିୟ୍‌ମର୍‌ବେନ୍‌ ସରେବାସିଙନ୍‌ ଆ ପାନୁ ଅଃତ୍ତିୟେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ପିତ୍ରନ୍‌ ଜାଲଙେନ୍‌, “ଓଓ, ତିୟ୍‌ତେ ।” ଆରି ପିତ୍ରନ୍‌ ଅସିଙନ୍‌ ଆଜିର୍ରାଞନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆମ୍ମୁଙ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ସିମନ୍‌ ଆମନ୍‌ ଇନି ଗାମ୍‌ତେ ? ପୁର୍ତିନ୍‌ ଆ ରାଜାଜି ଆନା ଆମଙ୍‌ ସିଲଡ୍‌ ପାନୁନ୍‌ ଡ ସିସ୍ତୁନ୍‌ ପାଙ୍‌ତଜି ? ଆ ଡେସାନ୍‌ ଆ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଅଡ଼େ ବଡେସାମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ବଡେସାମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ।” ସିଲତ୍ତେ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆ ଡେସାନ୍‌ ଆ ମନ୍‌ରାଜି ତ ଏଃତ୍ତିୟେଜି ! ");
INSERT INTO juy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ବନ୍‌ଡ ଇନ୍‌ଲେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ ଗବ୍‌ରୟ୍‌ମଡ୍‌ବୋଜି, ତିଆସନ୍‌ ଆମ୍ୱେନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଇୟ୍‌ଲେ ଅୟନ୍‌ ଇୟ୍‌ତୋର୍‌ବା, ଆରି ଆମ୍ମୁଙ୍‌ ଅଙ୍ଗା ଆୟ ଗତର୍‌ତେ, ତିଆତେ ଞମ୍‌ଲେ ଆ ତଅଡନ୍‌ ଏଉଜେନ୍‌ ଡେନ୍‌ ଅବୟ୍‌ ରୁପାଡାବନ୍‌ ଏଞାଙ୍‌ତେ, ତି ଆ ଡାବ୍ବୋ ପାଙ୍‌ଲେ ଞେନ୍‌ ଆସନ୍‌ ଡ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଆନିଞ୍ଜି ପାନୁନ୍‌ ଆୟ୍‌ ତିୟ୍‌ବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ତିଆଡିଡ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରାଜି କି ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ଆନା ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ?” ");
INSERT INTO juy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ଜିସୁନ୍‌ ଅବୟ୍‌ ସନ୍ନାସିଜନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଞଙ୍‌ନେମରଞ୍ଜି ଆ ମୁକ୍କାବା ତବ୍‌ନଙ୍‌ଡାଲେ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ କେନ୍‌ ସନ୍ନାସିଜନ୍‌ ଅନ୍ତମ୍‌ ଏଃଡ୍ଡେଲୋ ଡେନ୍‌, ଏଙ୍ଗାଲେଜନଙ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ଏଃଗନେ । ");
INSERT INTO juy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ତିଆସନ୍‌ ଆନା କେନ୍‌ ସନ୍ନାସିଜନ୍‌ ଅନ୍ତମ୍‌ ଲବ୍‌ଗଃଡମ୍‌ତନେ, ଆନିନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ସୋଡ଼ା । ");
INSERT INTO juy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ଆରି ଆନା ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଅବୟ୍‌ ସନ୍ନାସିଜନ୍‌ଆଡଙ୍‌ ଜାତେ, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଜାତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ଅଙ୍ଗା ମନ୍‌ରା କେନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଆଡର୍ତନେଞ୍ଜି ଆ ପସିୟ୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଗବ୍‌ଲୋତେ, ତି ଆ ମନ୍‌ରା ଆ ସଙ୍କାଲୋଙ୍‌ ଅବୟ୍‌ ସୋଡ଼ା ଗୋର୍ନାଅରନ୍‌ ୟୋଡ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଜରୁ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆସେଃସେଡ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ମନଙ୍‌ ଡେତେ ବନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","କେନ୍‌ ପୁର୍ତିନ୍‌ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଡର୍ନେଲୋଙନ୍‌ ଡନଙ୍‌ଡଙନ୍‌ ଆସନ୍‌ କେନ୍‌ତେନ୍ନେ ତନୋର୍‌ତୋରଞ୍ଜି ଡକୋ; ତନୋର୍‌ତୋରଞ୍ଜି ଅଡ଼ୋତାୟ୍‌ ମା, ବନ୍‌ଡ, ଅଙ୍ଗା ମନ୍‌ରା ଅମ୍ମେଲେ ତନୋର୍‌ତୋରନ୍‌ ଅଡ଼ୋତାୟ୍‌, ତି ଆ ମନ୍‌ରା ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ !” ");
INSERT INTO juy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ଅସିବେନ୍‌ କି ଅଜଙ୍‌ବେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଗବ୍‌ଲୋଲବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଗଡ୍‌ଲେ ସେଡ୍‌ବା; ବାର୍ସିନ୍‌ ଡ ବାର୍ଜଙନ୍‌ ବୟନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆ ତଗୋଲୋଙ୍‌ ସନେଡନ୍‌ ଆଡ୍ରେତବନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ଆଗଡ଼ୁଡନ୍‌ କି ଆସୋତ୍ତାନ୍‌ ଅନମେଙ୍‌ଲୋଙନ୍‌ ଗନ୍ନାବା । ");
INSERT INTO juy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ଆରି, ଅମଡ୍‌ବେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଗବ୍‌ଲୋଲବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ତବ୍‌ଲେ ସେଡ୍‌ବା; ବାର୍ମଡନ୍‌ ବୟନ୍‌ ତଗୋନ୍‌ ଆବ୍ରରିଜନ୍‌ ଆ ନରକଲୋଙ୍‌ ସନେଡନ୍‌ ଆଡ୍ରେତବନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ଆମିୟ୍‌ମଡନ୍‌ ଅନମେଙ୍‌ଲୋଙନ୍‌ ଗଙ୍ଗନନ୍‌ ଆମ୍ୱେନ୍‌ ଆସନ୍‌ ମନଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ଗିୟ୍‌ଡମ୍‌ନାବା, କେନ୍‌ ସନ୍ନାସିଜଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଏଏଡ଼ୁର୍‌ମଡ୍‌ଡଙେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ଆସ୍ରାକ୍କେତେଞ୍ଜି ଆ ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ଜି ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆ ମୁକ୍କା ଡିତାନ୍‌ ଗିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆଙ୍ଗାଆତେ ଆଡ଼ଏନ୍‌, ତିଆତେ ସାୟ୍‌ଲେ ଡୋବ୍‌ଡୋବନ୍‌ ଆସନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ଆମ୍ୱେନ୍‌ ଇନି ଏବ୍‌ଡିସୟ୍‌ତେ ? ଅନ୍ନିଙ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ଆତେ ବସଅ ମେଣ୍ଡାନ୍‌ ଡକୋତେ, ଆରି ତେତ୍ତେ ସିଲଡ୍‌ ଅବୟ୍‌ ଆଡ଼ଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଅନେସ୍ୱତ ମେଣ୍ଡାଞ୍ଜି ବରୁଲୋଙନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ତି ଆରାଡ଼ଏନ୍‌ ଆ ମେଣ୍ଡା ଅଃନ୍ନେସାଜେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ଆରି ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆନିନ୍‌ ତିଆତେ ଞାଙେନ୍‌ ଡେନ୍‌, ତି ଅନେସ୍ୱତଟା ଅଃନ୍ନାଡ଼ଲଞ୍ଜି ଆ ମେଣ୍ଡାଜି ଆସନ୍‌ ଆନିନ୍‌ ଡିଅଙ୍ଗା ସର୍ଡାତନେ, ତି ସିଲଡ୍‌ କେନ୍‌ ଅବୟ୍‌ ମେଣ୍ଡାନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଗୋଗୋୟ୍‌ ସର୍ଡାତନେ । ");
INSERT INTO juy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ତିଅନ୍ତମ୍‌ କେନ୍‌ ସନ୍ନାସିଜଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ଜାକିଁୟ୍‌ ମୋସ୍ସାଡଙେ ତଡ୍‌, କେନ୍‌ଆତେ ମା ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ଆରି ବୋଞାଙ୍‌ବେନ୍‌ ବିରୁଦଲୋଙ୍‌ବେନ୍‌ ଇର୍ସେନ୍‌ ଲୁମେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଡ ଆମ୍ୱେନ୍‌ ଆ ବାଗୁନ୍‌ବେନ୍‌ ଡକୋଲବେନ୍‌ ଆଡିଡ୍‌ ଆ ଡୋସାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ତୁୟ୍‌ବା; ଆରି ଆନିନ୍‌ ବର୍ନେବେନ୍‌ ଅମ୍‌ଡଙେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେନ୍‌ ବୋଞାଙ୍‌ବେନ୍‌ ଏଞାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ବନ୍‌ଡ ଆନିନ୍‌ ଅଃନ୍ନମ୍‌ଡଙ୍‌ଲୋ ଡେନ୍‌, ଅବୟ୍‌ନେ କି ବାଗୁନେ ସାକିମରନ୍‌ ତବ୍‌ନଙ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଅନ୍ତମ୍‌ ‘ବାଗୁ କି ୟାଗି ସାକିମରଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ କଡାଡ଼ି ଗରିତେ ।’ ");
INSERT INTO juy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ଆରି ଆନିନ୍‌ ଆ ବର୍ନେଞ୍ଜି ଅଃମ୍ମାନ୍ନେଲୋ ଡେନ୍‌, ମଣ୍ଡଡ଼ିନ୍‌ ଆ ମନ୍‌ରାଜି ବର୍ବାଜି, ଆରି ଆନିନ୍‌ ରନୁକ୍କୁମରଞ୍ଜି ଆ ବର୍ନେ ନିୟ୍‌ ଅଃମ୍ମାନ୍ନେଲୋ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ବେନ୍‌ ଏର୍‌ଡର୍ନେମରନ୍‌ ଡ ପାନୁବେଡ୍‌ମରନ୍‌ ଅନ୍ତମ୍‌ ଡେଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ପୁର୍ତିଲୋଙନ୍‌ ଅଙ୍ଗାତେ ଏଜିତେ, ରୁଆଙ୍‌ଲୋଙନ୍‌ ତିଆତେ ଆଜିଜି ଡକୋତନ୍‌, ଆରି ପୁର୍ତିଲୋଙନ୍‌ ଅଙ୍ଗାତେ ଏଉୟ୍‌ତେ, ରୁଆଙ୍‌ଲୋଙନ୍‌ ତିଆତେ ଆଉଜୁୟ୍‌ ଡକୋତନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“ଆରି ନିୟ୍‌, ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ପୁର୍ତିଲୋଙନ୍‌ ଆମ୍ୱେଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ବାଗୁ ମନ୍‌ରା ଆବମନ୍ନନ୍‌ ଏମ୍ମେଡାଲନ୍‌ ଅଙ୍ଗାତେଜନଙ୍‌ ବେଡ୍‌ତଜି, ତିଆତେ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ତିୟ୍‌ତାଜି । ");
INSERT INTO juy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ବାଗୁ କି ୟାଗି ମନ୍‌ରା ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ରୁକ୍କୁତଞ୍ଜି, ଞେନ୍‌ ତେତ୍ତେ ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ତିଆଡିଡ୍‌ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରାୟ୍‌ କି ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଏ ପ୍ରବୁ ବୋଞାଙ୍‌ଞେନ୍‌ ବିରୁଦଲୋଙ୍‌ଞେନ୍‌ ନମିନ୍‌ ନମିନ୍‌ ଇର୍ସେନ୍‌ ଲୁମେନ୍‌ ଡେନ୍‌, ଞେନ୍‌ ଡିଅଙ୍ଗା ବେଡ଼ା ଆନିନ୍‌ଆଡଙ୍‌ କେମାନ୍‌ ତିଆୟ୍‌ ? ଇନି ସାତତର ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ଜିସୁନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସାତତର ଅଃଗାମମ୍‌, ସାତ ଗୁନା ସତୁରି ବେଡ଼ା ଆନିନ୍‌ଆଡଙ୍‌ କେମାନ୍‌ ତିୟା । ");
INSERT INTO juy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ରାଜାନ୍‌ ଆ କମ୍ୱାରିମରଞ୍ଜି ସରିନ୍‌ ଇସାବଡିଞନ୍‌ ଆସନ୍‌ ସାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ଆନିନ୍‌ ଇସାବନ୍‌ ଆରୁଲନ୍‌ ଆଡିଡ୍‌, ୟାଗି କୁଟି ତଙ୍କା ସାଉନ୍‌ ଆପ୍ରାଙେନ୍‌ ଆ ମନ୍‌ରା ଅବୟ୍‌ ଆମଙନ୍‌ ଓରୋଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ବନ୍‌ଡ ସାଉନ୍‌ ସୁଜ୍ଜାୟ୍‌ନେନ୍‌ ଆସନ୍‌ ତି ଆ ମନ୍‌ରା ଆମଙ୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌, ତିଆସନ୍‌ ରାଜାନ୍‌ ଆନିନ୍‌, ଆ ଡୁକ୍ରିନ୍‌ ଡ ଆ ପସିଜଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ତମ୍‌ଲୋଙ୍‌ ତମ୍‌ଲେ ସୁଜ୍ଜାୟ୍‌ନେନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ସିଲତ୍ତେ ତି କମ୍ୱାରିମରନ୍‌ ରାଜାନ୍‌ ଆ ମୁକ୍କାବା ତୁଡ଼ୁମ୍‌ଡାଲେ ଲୋମ୍‌ଲେ ବର୍ରନେ, ‘ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଜିଡ୍‌ ଜଗେଇଂ, ଞେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ସୁଜ୍ଜାୟ୍‌ତନାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ତିଆସନ୍‌ ରାଜାନ୍‌ ଆର୍ଗୁଡ଼ିଡାଏନ୍‌ କି ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ବୁରେନ୍‌ ଆରି ଆ ସାଉନ୍‌ ଅମ୍‌ରେଙେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ତି କମ୍ୱାରିମରନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଆମଙନ୍‌ ସିଲଡ୍‌ ପଚାସ ତଙ୍କା ସାଉନ୍‌ ଆପ୍ରାଙେନ୍‌ ଅବୟ୍‌ ସର୍ସି କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ରବାଙେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ, ଲମ୍ମସଙ୍କାଡାଲେ ବରେନ୍‌, ‘ଆମନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ଡିଅଙ୍ଗା ସାଉନ୍‌ ପାଙେନ୍‌ ଲସୁଜ୍ଜାୟ୍‌ନା !’ ");
INSERT INTO juy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ସିଲତ୍ତେ ତି ସର୍ସି କମ୍ୱାରିମରନ୍‌ ତୁଡ଼ୁମ୍‌ଡାଲେ ଲୋମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଜିଡ୍‌ ଜଗେଇଂ, ଞେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ସୁଜ୍ଜାୟ୍‌ତନାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ବନ୍‌ଡ ଆନିନ୍‌ ଅଃଡ୍ଡର୍ରନେ, ଆରି ସାଉନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ସୁଜ୍ଜାୟ୍‌ନେନ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଇୟ୍‌ଲେ ଡକ୍କୋଏ । ");
INSERT INTO juy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ତିଆସନ୍‌ ଆ ସର୍ସି କମ୍ୱାରିମରଞ୍ଜି କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ଆକ୍ରାନ୍‌ ଡୁକ୍କଲଞ୍ଜି ଆରି ଜିରେଞ୍ଜି କି ରାଜାନ୍‌ଆଡଙ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଇୟ୍‌ଲେ ଅବ୍‌ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ସିଲତ୍ତେ ରାଜାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ବରେନ୍‌, ‘ଏ ପେଲ୍ଲା କମ୍ୱାରିମର୍‌, ଆମନ୍‌ ଅମଙ୍‌ଞେନ୍‌ କରାକୁର୍ତିଲନ୍ ଞେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ସାଉନମ୍‌ ଅମ୍‌ରେଙ୍‌ଲାୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ଞେନ୍‌ ଏଙ୍ଗାଲେ ଆମନ୍‌ଆଡଙ୍‌ ସାୟୁମ୍‌ଲମ୍‌, ତିଅନ୍ତମ୍‌ ଆମନ୍‌ ନିୟ୍‌ ସର୍ସି କମ୍ବାରିମର୍‌ନମ୍‌ଆଡଙ୍‌ ସାୟୁମ୍‌ତେବନ୍‌, ଅଡ଼େ ଇଜ୍ଜା ?’ ");
INSERT INTO juy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ଆରି ରାଜାନ୍‌ ବରାବ୍‌ଡାଲେ ଅଡ଼୍‌କୋନ୍‌ ଆ ସାଉନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ସୁଜ୍ଜାୟ୍‌ନେନ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପନବ୍‌ରଡନ୍‌ ଆସନ୍‌ ବଣ୍ଡିସିଂମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ଉଗର୍‌ଲୋଙନ୍‌ ସିଲଡ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ବୋଞାଙ୍‌ଆଡଙ୍‌ କେମାନ୍‌ ଏଃତ୍ତିୟ୍‌ଲୋ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏତ୍ତେତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ଜିସୁନ୍‌ କେନ୍‌ ଆ ଞନଙ୍‌ଜି ଆରବ୍‌ସୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଜିର୍ରେ ଜର୍ଦନ ଅଲନ୍‌ ଆ ଅଡିଗଡ୍‌ ଜିଉଦା ଡେସାନ୍‌ ଆ ସଣ୍ଡିଲୋଙ୍ ଅଡ଼ୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ଆରି ଜବ୍ର ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି, ଆରି ଆନିନ୍‌ ତେତ୍ତେ ବମ୍ୱମ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ପାରୁସିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରାଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ମାଲ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଇନିଜନଙ୍‌ ଆସନ୍‌ ଡେନ୍‌ ଅବୟ୍‌ ଅୟ୍‌ତବନ୍‌ ଆ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଆସନ୍‌, ବନାଁୟ୍‌ବର୍‌ଲେନ୍‌ ଅଡ଼େତେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଗନବ୍‌ଡେଲ୍‌ମରନ୍‌ ପୁର୍ବାନ୍‌ ମା ସିଲଡ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଓବ୍ବାମରନ୍‌ ଡ ଆଇମରନ୍‌ ଅମ୍ମେଲେ ଗବ୍‌ଡେଲେଞ୍ଜି, କେନ୍‌ଆତେ ଆମ୍ୱେଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ଏପଡ଼େନେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ଆରି ଇସ୍ୱରନ୍‌ ବର୍ରନେ, ‘କେନ୍‌ ଆସନ୍‌ ଓବ୍ବାମରନ୍‌ ଆପେୟନ୍‌ ଡ ଅୟୋଙନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆ ଡୁକ୍ରିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ତନେ, ଆରି ଆନିଞ୍ଜି ବାଗୁଞ୍ଜି ଆବୟନ୍‌ ଡେତଜି ।’ ");
INSERT INTO juy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ଆନିଞ୍ଜି ଆରି ବାଗୁ ମନ୍‌ରା ତଡ୍‌, ବନ୍‌ଡ ନମି ଆବଡଅଙନ୍‌ ଡେଏଞ୍ଜି । ତିଆସନ୍‌, ଇସ୍ୱରନ୍‌ ଅଙ୍ଗାତେ ଅବ୍‌ମାୟ୍‌ମାୟେନ୍‌, ମନ୍‌ରାନ୍‌ ତିଆତେ ତରଙ୍‌ଆନ୍ନା ଏମ୍ମେଡଙେ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ପାରୁସିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ମୋସାନ୍‌ ଇନିବା ଅମ୍‌ରେଙଲନ୍‌ ତିୟ୍‌ଲେ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଆସନ୍‌ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଇଡେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ମୋସାନ୍‌ ଉଗର୍‌ବେନ୍‌ ଆ ରଡୋ ଗିୟ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଆସନ୍‌ ଅନଡ଼େନ୍‌ ତିୟ୍‌ଲବେନ୍‌, ବନ୍‌ଡ ପୁର୍ତିନ୍‌ ଗନଡେଲନ୍‌ ଆରୁଲନେନ୍‌ ସିଲଡ୍‌ ଏତ୍ତେଲେ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଡାରିନେ ଡୋସାନ୍‌ ଏର୍‌ଲନୁମନ୍‌ ଆନ୍ନା ଡୋସା ଆସନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଆ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙଲନ୍‌ ତିୟ୍‌ଲେ ଅମ୍‌ଡୁଙ୍‌ତେ ଆରି ଆନ୍ନାବୟ୍‌ ବୟନ୍‌ ବିବାତନେ, ତି ଆ ମନ୍‌ରା ଡାରିତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଡୁକ୍ରିନ୍‌ ସରିନ୍‌ ଅୟ୍‌ତବନ୍‌ କେନ୍‌ ଏନ୍ନେଗନ୍‌ ଆ ମରାୟ୍‌ନେ ଡକୋଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆର୍ପାୟ୍‌ ଅଃବ୍ବିବାଲନ୍‌ବୋ ଡେନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ କେନ୍‌ଆତେ ଲୁମ୍‌ଲେ ଅଃର୍ରପ୍ତିଏଜି, ଇସ୍ୱରନ୍‌ ଆନାଜିଆଡଙ୍‌ କେନ୍‌ଆତେ ତିୟେଞ୍ଜି, ଆନିଞ୍ଜି ତୁମ୍‌ କେନ୍‌ଆତେ ଲୁମ୍‌ଲେ ରପ୍ତିତଜି । ");
INSERT INTO juy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ଅୟୋଙନ୍‌ ଆ କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆ ମାୟ୍‌ତଲିଆନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେତଜି, ଆରି ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ମନ୍‌ରାଞ୍ଜି ଏତ୍ତେତଞ୍ଜି, ଆରି ଲାଙ୍‌ଲେନ୍ନେ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଆସନ୍‌ ଏର୍‌ବନିବାନେନ୍‌ ଡକୋତଞ୍ଜି । ଅଙ୍ଗା ମନ୍‌ରା କେନ୍‌ଆତେ ଲୁମ୍‌ଲେ ରପ୍ତିତେ, ଆନିନ୍‌ ଲୁମେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ପସିଜଞ୍ଜି ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଆସିନ୍‌ ଡକ୍କୋଡାଲେ ଆନିଞ୍ଜି ଆସନ୍‌ ପାର୍ତନାନେତୋ ଗାମ୍‌ଲେ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ପସିଜଞ୍ଜିଆଡଙ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି । ବନ୍‌ଡ ଞଙ୍‌ନେମରଞ୍ଜି ତି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ କଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ପସିଜଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତଙରନ୍‌ ସାବ୍ବାଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଏରଙ୍‌ଡଙେଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ମନ୍‌ରାଜି ଆସନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ଆରି, ଆନିନ୍‌ ପସିଜଞ୍ଜି ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଆସିନ୍‌ ଡକ୍କୋଲେ ଆସିର୍ବାଦଏଞ୍ଜି କି ତେତ୍ତେ ସିଲଡ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ଆରି ଗିୟ୍‌ବା, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରାୟ୍‌ କି ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଅଙ୍ଗା ମନଙ୍‌ କାବ୍ବାଡ଼ା ଲୁମାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଆ ବର୍ନେ ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ବର୍ତିଁୟ୍‌ ? ଇସ୍ୱରନ୍‌ ତୁମ୍‌ ଅବୟ୍‌ନେ ମନଙ୍‌; ଆରି ଆମନ୍‌ ଅନମେଙ୍‌ଲୋଙନ୍‌ ଗଙ୍ଗନନ୍‌ ଆସନ୍‌ ସାୟ୍‌ଲମ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ବନାଁୟ୍‌ବରଞ୍ଜି ଞଣ୍ଡ୍ରମ୍‌ନା ।” ");
INSERT INTO juy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଇନି ଏଙ୍ଗାଗୋଜି ଆ ବନାଁୟ୍‌ବର୍‌ ?” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ମନ୍‌ରାନ୍‌ ଏରବ୍ବୁଡଙ୍‌, ଏଡାରିଡଙ୍‌ନେ, ଏରାଉଡଙ୍‌ନେ, କଣ୍ଡାୟ୍‌ ସାକିନ୍‌ ଏତିୟ୍‌ଡଙ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ଆପେୟ୍‌ବେନ୍‌ ଡ ଅୟୋଙ୍‌ବେନ୍‌ ମାନ୍ନେବାଜି, ଆରି ତୟ୍‌ଲିସିଂମର୍‌ବେନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେନ୍‌ଡମ୍‌ ଅନ୍ତମ୍‌ ଡୁଙ୍‌ୟମ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ତି ବେଣ୍ଡିଆମରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “କେନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ଜି ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ଲନାୟ୍‌, ଅଙ୍ଗାତେ ଆରି ଞେନ୍‌ ଲନୁମନ୍‌ ଡକୋ ?” ");
INSERT INTO juy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ସବ୍‌ତଙ୍‌ନେନ୍‌ ଆସନ୍‌ ସାଜେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଜିରା କି ଅନର୍ଜେନମ୍‌ଜି ଅଡ଼୍‌କୋନ୍‌ ତମ୍‌ଲୋଙ୍‌ ତମ୍‌ଲେ ତି ଆ ତଙ୍କା ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ ତିୟାଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆୟ୍‌ ସଣ୍ଡୋଙିୟ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ରନ୍ନାନ୍‌ ଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ବନ୍‌ଡ ତି ବେଣ୍ଡିଆମରନ୍‌ କେନ୍‌ଆତେ ଆରମ୍‌ଡଙେନ୍‌ ଅବ୍‌ସର୍‌ମୁକ୍କାଲନ୍‌ ଜିରେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନର୍ଜେନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଗମାଙ୍‌ମରନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟଲୋଙନ୍‌ ଗଙ୍ଗନନ୍‌ ଆସନ୍‌ ମାଡ୍ଡ ଡଣ୍ଡ । ");
INSERT INTO juy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ଆରି ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗମାଙ୍‌ମରନ୍‌ ଆଗ୍ରନ୍‌ତେନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ସୁର୍ଜାନ୍‌ ଆ ପତୁଡ୍‌ ଗଡ୍‌ ଓଟନ୍‌ ଆଗ୍ରଙ୍ଗନ୍‌ ସଜ ।” ");
INSERT INTO juy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ଞଙ୍‌ନେମରଞ୍ଜି କେନ୍‌ଆତେ ଆରମ୍‌ଡଙେଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି କି ବର୍ରଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନା ଅନୁରନ୍‌ ଞାଙ୍‌ଲେ ରପ୍ତିଏ ?” ");
INSERT INTO juy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙେଞ୍ଜି କି ବର୍ରନେ, “କେନ୍‌ଆତେ ମନ୍‌ରାନ୍‌ ଆସିଲୋଙ୍‌ ଅଃଡ୍ଡେଏ, ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆସିଲୋଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଡେଆୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଗିଜା, ଇନ୍‌ଲେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ରେଙାୟ୍‌ଲେ ଆମନ୍‌ଆଡଙ୍‌ ଏସଣ୍ଡୋଙ୍‌ତମ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଇନି ଏଞାଙ୍‌ତାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ରଙ୍‌ ଜୁଗଲୋଙନ୍‌ ଅଙ୍ଗା ଆଡିଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙ୍‌ ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ତେ, ଆମ୍ୱେଞ୍ଜି ନମି କେନ୍‌ ବାରଜଣବେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏସ୍ରଣ୍ଡୋଙ୍‌ତିଞନ୍‌, ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ବାରଟା ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ବାର କେଜ୍ଜା ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଏସାସନତେ । ");
INSERT INTO juy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ଆରି, ଅଙ୍ଗା ମନ୍‌ରା ଅଞୁମ୍‌ଞେନ୍‌ ଆସନ୍‌ ଗାମ୍‌ଲେ ଅସିଂ ପଙ୍‌, ବୋଞାଙ୍‌ ପଙ୍‌, ତନାନ୍‌ ପଙ୍‌, ଆପେୟ୍‌ ପଙ୍‌, ଅୟୋଙ୍‌ ପଙ୍‌, ପସିୟ୍‌ଜି ପଙ୍‌, ଲବସିମା ଅମ୍‌ରେଙ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ବସଅ ଗୁନା ଞାଙ୍‌ତେ, ଆରି ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ବନ୍‌ଡ ଆରାମ୍ମୁଙ୍‌ଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ଗୋଗୋୟ୍‌ନେ ତିକ୍କିତଜି, ଆରି ଆତ୍ରିକ୍କିଏଞ୍ଜି ଆ ମନ୍‌ରାଜି ଗୋଗୋୟ୍‌ନେ ଆମ୍ମୁଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ଅସିଙନ୍‌ ଆ ମୁଡ଼ମର୍‌ ଡୋତାନ୍‌ ବଡିମରଞ୍ଜି ସାୟ୍‌ଲେ ଆ ଦ୍ରାକ୍ୟାକୋତ୍ତାଲୋଙନ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଅନବ୍‌ଲୁମ୍‌ଲୁମନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ଆନିନ୍‌ ଡିଲେ ମନ୍‌ରାନ୍‌ ବମିୟ୍‌ତାନ୍‌ ଅବୟ୍‌ ଲେକାଁୟ୍‌ ରୁପାଡାବନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ବଡିମରଞ୍ଜି ସରିନ୍‌ ଅବ୍‌ସିଡ୍ଡାୟ୍‌ଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ଆରି ଆନିନ୍‌ ନଟାରେ ସରେଁୟ୍‌ତାନ୍‌ ଆରିୟେନ୍‌ ତେତ୍ତେ ଆନ୍ନାମରଞ୍ଜି ଏର୍‌କନାବ୍ବାଡ଼ାନେନ୍ ଆତନଙନ୍‌ ଆଡ୍ରୋକଲଞ୍ଜି ଇୟ୍‌ଲେ ଗିଜେଜି, ");
INSERT INTO juy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ତିଆସନ୍‌ ଆନିନ୍‌ ତି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, ‘ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ଜିର୍ରେ ଇୟ୍‌ କାବ୍ବାଡ଼ାନାବା, ଆରି ଏଙ୍ଗାଲେ ବଡିନ୍‌ ତନିୟନ୍‌ ଡେତେ ଏତ୍ତେଲେ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ବଡିନ୍‌ ତିୟ୍‌ତବେନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ସିଲତ୍ତେ ଆନିଞ୍ଜି କୋତ୍ତାନ୍‌ ଜିରେଞ୍ଜି କି ଇୟ୍‌ଲେ କାବ୍ବାଡ଼ାନେଜି । ଆରି ଆନିନ୍‌ ବାରଟା ଇଙନ୍‌ ଡ ୟାଗି ଗଣ୍ଟା ଇଙନ୍‌ ଡୁଆରାନ୍‌ ଆରିୟେନ୍‌ ଏତ୍ତେଲେମା ମନ୍‌ରାଞ୍ଜି ଏର୍‌କନାବ୍ବାଡ଼ାନେନ୍ ଆତନଙନ୍‌ ଆଡ୍ରୋକଲଞ୍ଜି ଇୟ୍‌ଲେ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ଆରି ଆନିନ୍‌ ମନ୍‌ଲୟ୍‌ ଗଣ୍ଟା ଇଙନ୍‌ ଡୁଆରାନ୍‌ ଆରିୟେନ୍‌ ଏତ୍ତେଲେମା ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଏର୍‌କନାବ୍ବାଡ଼ାନେନ୍ ଆତନଙନ୍‌ ଆଡ୍ରୋକଲଞ୍ଜି ଇୟ୍‌ଲେ ଗିଜେଜି । ତିଆସନ୍‌ ଆନିନ୍‌ ତି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, ‘ଆମ୍ୱେଞ୍ଜି ଇନିବା ଏର୍‌କନାବ୍ବାଡ଼ାନେନ୍ ତମ୍ପରୁବ୍‌ ତେନ୍ନେ ଆତନଙନ୍‌ ଏଡକୋତନେ ?’ ");
INSERT INTO juy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ତି ଆ ମନ୍‌ରାଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, ‘ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନ୍ନିଙ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ବଡିନ୍‌ ଅଃବ୍ବାଁୟ୍‌ଲଲେଞ୍ଜି ।’ ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ‘ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ଜିର୍ରେ ଇୟ୍‌ କାବ୍ବାଡ଼ାନାବା ।’” ");
INSERT INTO juy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ଆର୍ରୁବେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାମରନ୍‌ ଆ ଗୁମୁସ୍ତାନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ବଡିମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଆତନିକ୍କି ଇଙନ୍‌ ଞନାରନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଉନେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ରୟ୍‌ ଆମ୍ମୁଙ୍‌ ବଡିନ୍‌ ତିୟାଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନାଜି ଞନାରନ୍‌ ପର୍ତମ୍ମୁ ଇୟ୍‌ଲାୟ୍‌ ଉନେଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ବଡିନ୍‌ ତିୟାଜି ।’ ");
INSERT INTO juy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ସିଲତ୍ତେ ଆନାଜି ମନ୍‌ଲୟ୍‌ ଗଣ୍ଟା ଇଙନ୍‌ ଞନାରନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଉନେଜି, ଆନିଞ୍ଜି ତଙ୍‌ବୟ୍‌ ରୁପାଡାବନ୍‌ ବଡିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଜାଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ଆରି ଆନାଜି ଞନାରନ୍‌ ପର୍ତମ୍ମୁ ଇୟ୍‌ଲାୟ୍‌ ଉନେଜି ଆନିଞ୍ଜି ଗୋଗୋୟ୍‌ ଲେକାଁୟ୍‌ ବଡିନ୍‌ ଏଞାଙ୍‌ତାୟ୍‌ ଅବ୍‌ଡିସୟେଞ୍ଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ନିୟ୍‌ ଅବୟ୍‌ ଲେକାଁୟ୍‌ ରୁପାଡାବନ୍‌ ବଡିନ୍‌ ଞାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ବନ୍‌ଡ ଆନିଞ୍ଜି ତିଆତେ ଜାଏଞ୍ଜି କି ଅସିଙନ୍‌ ଆ ମୁଡ଼ମର୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡୋସେଡାଲେ ବର୍ରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘କେନ୍‌ ଆତନିକ୍କି ଇଙନ୍‌ ଞନାରନ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆ ବଗଣ୍ଟାନ୍‌ ତୁମ୍‌ ଇୟ୍‌ଲାୟ୍‌ କାବ୍ବାଡ଼ାନେଜି, ଇନ୍‌ଲେଞ୍ଜି ତମ୍ପରୁବ୍‌ ତମୋୟୋଙ୍‌ ଲନୁମ୍‌ଡାଲନ୍‌ ଡାଗାଲୋଙନ୍‌ ଉଙ୍‌ରୁଡନ୍‌ ଉଙ୍‌ବାଲନ୍‌ ଡେଲଲେନ୍‌ ଜନଙ୍‌ଡେନ୍‌ ଆମନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଅବ୍‌ସମାନଲଲେନ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“ସିଲତ୍ତେ ସାଉକାରନ୍‌ ବଡିମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ଜାଲଙେନ୍‌, ‘ଏ ଗଡ଼ି, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅଃବ୍ବୁର୍ଡଅମ୍‌, ଆମନ୍‌ ବମିୟ୍‌ତାନ୍‌ ବମନ୍‌ରାନ୍‌ ଅବୟ୍‌ ଲେକାଁୟ୍‌ ରୁପାଡାବନ୍‌ ପନାଙନ୍‌ ଆସନ୍‌ ବଡିନ୍‌ ଅଃନ୍ନବ୍‌ସିଡ୍ଡାୟ୍‌ଲୋ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ଅଙ୍ଗାତେ ଆମନ୍‌ଆତେ, ତିଆତେ ପାଙ୍‌ଲେ ଜିରା, ଞେନ୍‌ ଆମନ୍‌ ଡିଅଙ୍ଗା ବଡିନ୍‌ ତିୟ୍‌ଲମ୍‌, କେନ୍‌ ଆତନିକ୍କି ଇଙନ୍‌ ଞନାରନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଉନେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ନିୟ୍‌ ଡିୟ୍‌ତେ ମା ବଡିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଇସ୍ସୁମ୍‌ଞେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ଅନର୍ଜେଞେନ୍‌ ଇସ୍ସୁମ୍‌ଞେନ୍‌ ବାତ୍ତେ ଞେନ୍‌ ଅରଃ କର୍ସଆଞନ୍‌ ? ଅଡ଼େ ଞେନ୍‌ ମନ୍‌ରାଞ୍ଜି ତରିୟ୍‌ତିୟ୍‌ତାଞଞ୍ଜି ଆସନ୍‌ ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସାଣ୍ଡତିଁୟ୍‌ ?’” ");
INSERT INTO juy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“ତିଆସନ୍‌ ଆତ୍ରିକ୍କିଏଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମ୍ମୁଙ୍‌ତଜି, ଆରି ଆରାମ୍ମୁଙେଞ୍ଜି ଆ ମନ୍‌ରାଜି ତିକ୍କିତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ଜିସୁନ୍‌ ଜିରୁସାଲମନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ତଙର୍‌ଲୋଙନ୍‌ ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବ ଅନେଙ୍‌ଗଡ୍‌ ଓଡ୍ଡେଲେ ଓରୋଙ୍‌ଡାଲେ ଇୟ୍‌ଲେ ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ଗିୟ୍‌ବା, ଇନ୍‌ଲେଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଜିର୍ତବୋ, ଆରି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତନେ, ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଅବ୍‌ଡୋସାତଜି; ");
INSERT INTO juy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତଜି, ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସୟ୍‌ସୟ୍‌ମୁତଜି, ସାମକାନ୍‌ ବାତ୍ତେ ତିଡ୍‌ତଜି କି ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ତଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଏର୍ତାଲୋଙ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ତିଆଡିଡ୍‌ ଜେବଦିନ୍‌ ଆ ଡୁକ୍ରି, ବାଗୁ ଆ ଡାଙ୍ଗଡ଼ାଅନଞ୍ଜିଆଡଙ୍‌ ସରିନ୍‌ ଓରୋଙ୍‌ଡାଲେ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ଆରି ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତୁଡ଼ୁମ୍‌ଡାଲେ ଲୋମ୍‌ଲେ ସନାୟୁମନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବେଡେ । ");
INSERT INTO juy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଇନି ସାୟ୍‌ତେ ?” ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ରାଜ୍ୟଲୋଙ୍‌ନମ୍‌ କେନ୍‌ ବାଗୁ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେଞ୍ଜି ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ନମ୍‌ ଅବୟ୍‌ନେ, ଆରି ଅର୍କାବଡ଼ିଗଡ୍‌ନମ୍‌ ଅବୟ୍‌ନେ ତଙ୍କୁମେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ଜିସୁନ୍‌ ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନି ଏବେଡ୍‌ତିଁୟ୍‌, ତିଆତେ ଞେନ୍‌ ଅଃଜ୍ଜନାଇଁୟ୍‌ । ଞେନ୍‌ ଅଙ୍ଗା ଗିଲ୍ଲଲୋଙ୍‌ ଗାତାୟ୍‌, ତେତ୍ତେ ଆମ୍ୱେନ୍‌ ଗାଲେ ଏରପ୍ତିତେ ପଙ୍‌ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଗାଲେ ଏରପ୍ତିତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ ଆମ୍ୱେଞ୍ଜି ଗିଲ୍ଲଲୋଙ୍‌ଞେନ୍‌ ଗାଲେ ଏରପ୍ତିତେ, ବନ୍‌ଡ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ଞେନ୍‌ ଡ ଅର୍କାବଡ଼ିଗଡ୍‌ଞେନ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅନବ୍‌ତଙ୍କୁମନ୍‌ ଆସନ୍‌ ଅଦିକାରଞେନ୍‌ ତଡ୍‌, ଆର୍ପାୟ୍‌ ଆନାଜି ଆସନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ତି ଆ ତରଙ୍କୁମ୍‌ ଅବ୍‌ଜାଡାଏନ୍‌ ଆନିଞ୍ଜି ତୁମ୍‌ ତେତ୍ତେ ତଙ୍କୁମ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ଆରି ଦସଜଣ ଞଙ୍‌ନେମରଞ୍ଜି କେନ୍‌ ଆ ବର୍ନେ ଆରମ୍‌ଡଙେଞ୍ଜି, ତି ବାଗୁ ବନୋଞାଙଞ୍ଜି ଆ ଉପରେଙ୍‌ ବରାବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଲେ ବରେଞ୍ଜି, “କେନ୍‌ ପୁର୍ତିନ୍‌ ଆ ରାଜାଜି ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅଃପ୍ପୁର୍‌ପୁର୍‌ତଞ୍ଜି ଆରି ସୋଡ଼ାମରଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ସୋଡ଼ାସୋଡ଼ାତଞ୍ଜି, କେନ୍‌ଆତେ ଆମ୍ୱେଞ୍ଜି ଜନା । ");
INSERT INTO juy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଏତ୍ତେଡଙ୍‌ନେ, ଆରି ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆନା ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ ସନାକ୍କେମର୍‌ବେନ୍‌ ଡେଏତୋ, ");
INSERT INTO juy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ଆରି ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆନା ଆମ୍ମୁଙ୍‌ଗଡ୍‌ନେନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ କମ୍ୱାରିମର୍‌ବେନ୍‌ ଡେଏତୋ, ");
INSERT INTO juy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","କେନ୍‌ ଅନ୍ତମ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ଅନବ୍‌ସାକ୍କେନେନ୍‌ ଆସନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌, ଆର୍ପାୟ୍‌ ସନାକ୍କେବାନ୍‌ ଆସନ୍‌ ଆରି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ତନାଣ୍ଡେବାନ୍‌ ଆ ପରାନ୍ନାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ଜିସୁନ୍‌ ଡ ଞଙ୍‌ନେମରଞ୍ଜି ଜିରିଓ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ଜବ୍ର ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ସନ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ଆରି ଗିୟ୍‌ବା, ବାଗୁ କାଡ଼ୁମରଞ୍ଜି ଅନେଙ୍‌ ରୋତ୍ତନ୍‌ ଆତଙ୍କୁମ୍‌ ଡକୋଲଞ୍ଜି, ଜିସୁନ୍‌ ତି ଆ ରୋତ୍ତ ଗଡ୍‌ ଜିର୍ତେ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଆରମ୍‌ଡଙେଞ୍ଜି, ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “ଏ ପ୍ରବୁ, ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ସାୟୁମ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ମନ୍‌ରାଞ୍ଜି ଆନିଞ୍ଜିଆଡଙ୍‌ କଡ଼ିଙ୍‌ଲେ ଡକୋନେନ୍‌ ଆସନ୍‌ କଞେଞ୍ଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ଆରି ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “ଏ ପ୍ରବୁ, ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ସାୟୁମ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ସିଲତ୍ତେ ଜିସୁନ୍‌ ତନଙେନ୍‌ କି ଆନିଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଇନି ଲୁମାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଲଡୟ୍‌ତବେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ପ୍ରବୁ ଅମଡ୍‌ଲେନ୍‌ ରୋଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଇର୍ସୋୟମ୍‌ଡାଏନ୍‌ କି ଆମଡଞ୍ଜି ସୁଙେଏନ୍‌, ସିଲତ୍ତେ ଅବ୍‌ତାଡ଼ନ୍‌ ଆନିଞ୍ଜି ଗିୟ୍‌ଲେ ରପ୍ତିଏଞ୍ଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଆ ତୁୟାୟ୍‌ ତୋଣ୍ଡୋ ଜିତବୁରନ୍‌ ବେତ୍‌ପାଗି ସାଇନ୍‌ ଅଡ଼ୋଏଞ୍ଜି; ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ବାଗୁ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଏନ୍ନେଲେ ବର୍ରେ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ଆମ୍ୱେଞ୍ଜି ମୁକ୍କାବାବେନ୍‌ ତି ଆ ସାଇ ଇୟ୍‌ବା । ତେତ୍ତେ ତୁଙାତୁଙା ଅବୟ୍‌ ଆୟୋଙ୍‌ ଗୋଡୋଁୟନ୍‌ ଡ ଆଅନନ୍‌ ଆତବାଡନ୍‌ ଇୟ୍‌ତେ ଏଗିଜେ; ତିଆତେଜି ପଡ୍ଡଙ୍‌ଲେ ଅମଙ୍‌ଞେନ୍‌ ପାଙାୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ଆରି ଆନ୍ନିଙ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଗାମ୍‌ଲବେଞ୍ଜି ଡେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ ବର୍ବା, ‘କେନ୍‌ଆତେ ପ୍ରବୁନ୍‌ ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ।’ ଅବ୍‌ତାଡ଼ନ୍‌ ଆନିନ୍‌ ତିଆତେଜି ଆପ୍ପାୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ତିଆସନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆବର୍ରନେନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ସିଓନ ଗଡ଼ାନ୍‌ ଆଇସିୟ୍‌ଆଡଙ୍‌ ବର୍ବା, ଗିଜା, ରାଜାନମ୍‌ ଅମଙ୍‌ନମ୍‌ ଜିର୍ତାୟ୍‌ ! ଆନିନ୍‌ ଲଗଡ୍‌ ବୁଡ୍ଡିମର୍‌ ଆରି ଆନିନ୍‌ ଅବୟ୍‌ ଗୋଡୋଁୟ୍‌ଲୋଙନ୍‌ ଆତଙ୍କୁମ୍‌, ଗିଜା, ଆନିନ୍‌ ଗୋଡୋଁୟ୍‌ଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଲେ ଜିର୍ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଏଙ୍ଗାଲେ ବାଞେଞ୍ଜି ଏତ୍ତେଲେ ଞଙ୍‌ନେମରଞ୍ଜି ଇୟ୍‌ଲେ ଲୁମେଜି; ");
INSERT INTO juy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ଆରି ଆୟୋଙ୍‌ ଗୋଡୋଁୟନ୍‌ ଡ ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ପାଙ୍‌ଲେ ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ସିନ୍‌ରିନ୍‌ ବେଲେଞ୍ଜି ଆରି ଜିସୁନ୍‌ ତେତ୍ତେ ତଙ୍କୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ଜିସୁନ୍‌ ଆଜିର୍ରେନ୍‌ ଆ ତଙର୍‌ ଗଡ୍‌ ମନ୍‌ରାଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ସିନ୍‌ରି ବେଲେଞ୍ଜି, ଆରି ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଅରାନୁବନ୍‌ ଆ ଡାଲ୍ଲାଜି ଅଡ୍‌ଲେ ପାଙ୍‌ଲାଜି କି ତଙରନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବେଲେଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଜିସୁନ୍‌ ଆ ମୁକ୍କାଗଡ୍‌ ଆରି ଆ ତିକ୍କିଗଡ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆ ମନ୍‌ରାଜି ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “ଓସାନ୍ନା ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ! ପ୍ରବୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଆନା ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌ ଡେଏତୋ ! ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଓସାନ୍ନା ।” ");
INSERT INTO juy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ଜିସୁନ୍‌ ଜିରୁସାଲମନ୍‌ ଆଗ୍ରନ୍‌ଲନ୍‌ ଆଡିଡ୍‌, ସମ୍ପରା ଗଡ଼ାନ୍‌ ଆ ମନ୍‌ରାଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ଆରି “କେନ୍‌ଆନିନ୍‌ ଆନା ?” ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ସିଲତ୍ତେ ମନ୍‌ରାଞ୍ଜି ବର୍ରଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଜିସୁନ୍‌, ଗାଲିଲି ନାଜରିତନ୍‌ ଆ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ଜିସୁନ୍‌ ସରେବାସିଙନ୍‌ ଗନ୍‌ଲେ ତେତ୍ତେ ସିଲଡ୍‌ ଞିଞିନେନ୍‌ ଡ ତମ୍‌ତମ୍‌ନେମରଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ଡୁଙାଜେଞ୍ଜି । ବାର୍‌ବାର୍‌ଡାବ୍‌ମରଞ୍ଜି ଆ ମେଜ ଆରି କୁକ୍କୁର୍‌ ତମ୍‌ତମ୍‌ନେମରଞ୍ଜି ଆ ତରଙ୍କୁମ୍‌ ସବ୍‌ଡିଡାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ‘ସରେବାସିଂଞେନ୍‌ ପାର୍ତନାସିଂ ଗାମ୍‌ଲେ ବର୍ନେନ୍‌ ଡେତେ ।’ ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ତିଆତେ ରାଉମରଞ୍ଜି ଆ ଲୋଙର୍‌ ଏଏମ୍ମେନ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ସରେବାସିଂଲୋଙନ୍‌ କାଡ଼ୁମରଞ୍ଜି ଡ ଗାଡ଼େମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି, ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ଜିସୁନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ ସାନ୍ନି କାବ୍ବାଡ଼ାଜି ଗିୟ୍‌ଲେ ଆରି ସରେବାସିଂଲୋଙନ୍‌ ପସିଜଞ୍ଜି “ଓସାନ୍ନା ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌” ଗାମ୍‌ଲେ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ଆବର୍ରଞ୍ଜିଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ବରାବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ଆନିଞ୍ଜି ଇନି ଗାମ୍‌ତଜି ଆମନ୍‌ ତିଆତେ ଅମ୍‌ଡଙ୍‌ତେ ପଙ୍‌ ?” ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଓଓ ଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ତାୟ୍‌, ‘ସନେଙ୍କେନ୍‌ ଆସନ୍‌ ଆମନ୍‌ ପସିଜଞ୍ଜି ଡ ଆ ରେସାସିଜଞ୍ଜିଆଡଙ୍‌ ମନଙ୍‌ଡମ୍‌ ଏଞଙ୍‌ଞଙେଞ୍ଜି’ ଆମ୍ୱେଞ୍ଜି ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆଙ୍ଗିୟ୍‌ ପଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏପଡ଼େନେ ?” ");
INSERT INTO juy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ଆରି ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ବେତନିଆନ୍‌ ଜିର୍ରେ ତେତ୍ତେ ତଗଲନ୍‌ ଇୟ୍‌ଲେ ଡକୋନେ । ");
INSERT INTO juy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ଜିସୁନ୍‌ ଡୋତାନ୍‌ ଜିରୁସାଲମନ୍‌ ଆୟର୍ରନାଞନ୍‌ ଆଡିଡ୍‌ ଡୋଲେଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ଆନିନ୍‌ ତଙରନ୍‌ ଆ ତୁୟାୟ୍‌ ଅବୟ୍‌ ଲୁଆନୁବନ୍‌ ଆଗ୍ରିଜେନ୍‌ ତି ଲୁଆନୁବ୍‌ଡମନ୍‌ ଇୟେନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ତେତ୍ତେ ଜିର୍ରେ ଆ ଅଲାନ୍‌ ତୁମ୍‌ ଇୟ୍‌ଲେ ଞାଙେ, ଆରି ଇନ୍ନିଙ୍‌ ଅଃନ୍ନେଞାଙ୍‌ଲୋ, ତିଆସନ୍‌ ଆନିନ୍‌ ଲୁଆନୁବନ୍‌ ସୟ୍‌ପଲେ ବର୍ରନେ, “ଆରି ଆଙ୍ଗିୟ୍‌ ଆମନ୍‌ ଅଜଡଙମ୍‌ ତଡ୍‌ !” ସିଲତ୍ତେ ତି ଲୁଆନୁବନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଅସରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ଞଙ୍‌ନେମରଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏଙ୍ଗାଲେ ଲୁଆନୁବନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଅସରେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଏର୍‌ଡାଲ୍‌ଗଡ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଡର୍ନାବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଲୁଆନୁବନ୍‌ ଞେନ୍‌ ଏଙ୍ଗାଲାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେ ଲୁମ୍‌ଲେ ଏରପ୍ତିତେ; ଆଡିୟ୍‌ତେନ୍‌ ତୁମ୍‌ ତଡ୍‌, କେନ୍‌ ବରୁନ୍‌ ନିୟ୍‌, ‘ଡୋଲନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଇୟ୍‌ ଗଲୋଅମ୍‌ତୋ,’ ଗାମ୍‌ଲେ ଏବର୍ରନ୍‌ ଡେନ୍‌, ତିଆତେ ଗଡେଲ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ଆମ୍ୱେଞ୍ଜି ଡର୍ରନ୍‌ ଇନି ଏପାର୍ତନାତନେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେନ୍‌ ଏଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ଜିସୁନ୍‌ ସରେବାସିଙନ୍‌ ୟର୍ରନ୍‌ ତେତ୍ତେ ଞନଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତିୟେ, ଆରି ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ମନ୍‌ରାଞ୍ଜି ଆ ପାପୁର୍‌ମର୍‌ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଆମନ୍‌ ଅଙ୍ଗା ଆ ସନୋଡ଼ାନେ ବାତ୍ତେ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ତେ ? ଆନା ଆମନ୍‌ଆଡଙ୍‌ କେନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ତିୟ୍‌ଲମ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଅବୟ୍‌ ବର୍ନେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଞେନ୍‌ ଜାଲଙିଁୟ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଅଙ୍ଗା ଆ ସନୋଡ଼ାନେ ବାତ୍ତେ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ତାୟ୍‌, ତିଆତେ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ଜନନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ସନୋଡ଼ାନେନ୍‌ ଆନା ଆମଙ୍‌ ସିଲଡ୍‌ ଞାଙେନ୍‌, ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଞାଙେନ୍‌, ଅଡ଼େ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଞାଙେନ୍‌ ?” ସିଲତ୍ତେ ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଇନି ଗାମ୍‌ବୋ ? ‘ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌,’ ଗାମ୍‌ଲବୋ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଗାମ୍‌ଗାମ୍‌ଲଙ୍‌ତନ୍‌, ‘ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନିବା ଆମଙନ୍‌ ଏଃଡ୍ଡର୍ରନେ ?’ ");
INSERT INTO juy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ବନ୍‌ଡ ‘ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଗାମ୍‌ଲବୋ ଡେନ୍‌,’ ଏତ୍ତେଲ୍‌ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ବନ୍ତଙ୍‌ ଡକୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଜନନ୍‌ଆଡଙ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଗାମ୍‌ଲେ ମାନ୍ନେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଜନା ତଡ୍‌ ।” ଜିସୁନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଅଙ୍ଗା ଆ ସନୋଡ଼ାନେ ବାତ୍ତେ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ତାୟ୍‌, ତିଆତେ ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଅଃବ୍ବର୍ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ଆମ୍ୱେଞ୍ଜି ଇନି ଏଇଃୟମ୍‌ତେ ? ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ବାଗୁ ଡକୋଏଞ୍ଜି । ଆନିନ୍‌ ସୋଡ଼ା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେ, ‘ଅଅନ୍‌, ଲଙେ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ଜିର୍ରେ ଇୟ୍‌ କାବ୍ବାଡ଼ାନା ।’ ");
INSERT INTO juy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ଆନିନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, ‘ଆଜ୍ଞା, ଞେନ୍‌ ଇୟ୍‌ତେ ।’ ବନ୍‌ଡ ଆନିନ୍‌ କାବ୍ବାଡ଼ାବାନ୍‌ ଅଃନ୍ନିୟ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ଆରି ଆନିନ୍‌ ସନ୍ନା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଏତ୍ତେଲେମା ଇୟ୍‌ଲାୟ୍‌ ବରେ । ଆନିନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, ‘ଞେନ୍‌ ଅଃଲ୍ଲଡଜିଁୟ୍‌ ।’ ବନ୍‌ଡ ଆନିନ୍‌ ତିକ୍କି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ କି କାବ୍ବାଡ଼ାବାନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","କେନ୍‌ ବାଗୁଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଆନା ଆପେୟନ୍‌ ଆ ବର୍ନେ ମାନ୍ନେଏନ୍‌ ?” ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ସନ୍ନା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ।” ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆମ୍ୱେଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ଏଜିରେନ୍‌, ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଜୋଣ୍ଡଡ଼ାମରଞ୍ଜି ଆମ୍ମୁଙ୍‌ ଜିର୍ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆଜାଡ଼ି ତଙରନ୍‌ ଅନବ୍‌ତୁଜନ୍‌ ଆସନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଆମଙନ୍‌ ଏଃଡ୍ଡର୍ରନେ; ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଜୋଣ୍ଡଡ଼ାମରଞ୍ଜି ଜନନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି । କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆମଙ୍‌ ଏଃଡ୍ଡର୍ରନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“ଆରି ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଅମ୍‌ଡଙ୍‌ବା । ଅବୟ୍‌ ଅସିଙନ୍‌ ଆ ମୁଡ଼ମର୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ତୁବ୍‌ଲେ ଏର୍ରେ ତରେନ୍‌, ଆରି ଦ୍ରାକ୍ୟାଜନ୍‌ ଆ ଞନାଲ୍‌ ଆସନ୍‌ ତେତ୍ତେ କୁଣ୍ଡନ୍‌ ଗାୟ୍‌ଲେ କୋତ୍ତାନ୍‌ ଆଜରଗେ ଆସନ୍‌ ଅବୟ୍‌ ମଞ୍ଚାନ୍‌ ତୁବେନ୍‌ କି ତି ଆ କୋତ୍ତା ଅର୍ରମରଞ୍ଜି ଆସିଲୋଙ୍‌ ବାଗାନ୍‌ ତିୟ୍‌ଲୋଙ୍‌ ତିୟ୍‌ଲେ ବଡେସାନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ତିକ୍କି ଦ୍ରାକ୍ୟାଜନ୍‌ ଆ ରନୋଡ୍‌ରୋଡ୍‌ ବେଡ଼ାନ୍‌ ଆରଡ଼ୋଲାଞନ୍‌, ଆଜନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଅର୍ରମରଞ୍ଜି ଆମଙ୍‌ ଆ କମ୍ବାରିମରଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ବନ୍‌ଡ ବାଗାଅର୍‌ମରଞ୍ଜି କୋତ୍ତାମରନ୍‌ ଆ କମ୍ବାରିମର୍‌ଜିଆଡଙ୍‌ ଞମ୍‌ଲେ ତିଡେଞ୍ଜି, ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ସମ୍ୱବେଞ୍ଜି, ଅବୟ୍‌ନେଆଡଙ୍‌ ତିଡରେଞ୍ଜି କି ରବ୍ବୁଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ଆନିନ୍‌ ଆରି ବତର ଆମ୍ମୁଙ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ କମ୍ବାରିମରଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି, ଆରି ବାଗାଅର୍‌ମରଞ୍ଜି ଏତ୍ତେଲେମା କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ତିଡେଞ୍ଜି, ରବ୍ବୁଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ଆତନିକ୍କି କୋତ୍ତାମରନ୍‌ ଗାମେନ୍‌, ‘ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ଆଡଙ୍‌ ଆନିଞ୍ଜି ମାନ୍ନେତଜି,’ ଆରି ଆନିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ବାଗାଅର୍‌ମରଞ୍ଜି ଆମଙ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ବନ୍‌ଡ ବାଗାଅର୍‌ମରଞ୍ଜି କୋତ୍ତାମରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, ‘କେନ୍‌ ତ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌, ୟବା, ଆନିନ୍‌ଆଡଙ୍‌ ଏରବ୍ବୁବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କୋତ୍ତାନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆତେ ଡେତେ ।’ ");
INSERT INTO juy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ଆରି ବାଗାଅର୍‌ମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙେଞ୍ଜି କି ସମ୍ୱବେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଦ୍ରାକ୍ୟାକୋତ୍ତାମରନ୍‌ ଜିର୍ରାୟ୍‌ ଆଡିଡ୍‌, ଆନିନ୍‌ ତି ବାଗାଅର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଇନି ଇୟ୍‌ତାୟ୍‌ ଏଙ୍ଗାଏଜି ?” ");
INSERT INTO juy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆନିନ୍‌ ତି ପେଲ୍ଲାମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ରବ୍ବୁଆଜେଜି, ଆରି ଅଙ୍ଗା ବାଗାଅର୍‌ମର୍‌ଜି ଦ୍ରାକ୍ୟାଜନ୍‌ ଆ ରନୋଡ୍‌ରୋଡ୍‌ ବେଡ଼ାନ୍‌ ଦ୍ରାକ୍ୟାଜନ୍‌ ବାନ୍ତେଲେ କୋତ୍ତାମରନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ତଜି, ତି ଆ ମନ୍‌ରାଜି ଆସିଲୋଙ୍‌ ଆନିନ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ବାଗାନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତିୟେଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆଙ୍ଗିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏପଡ଼େନେ ପଙ୍‌ ?” “ଗୁସିଂମରଞ୍ଜି ଅଙ୍ଗା ଆରେଙ୍‌ ବାସ୍ସେଏଞ୍ଜି, ତିଆତେ କୁନେନ୍‌ ଆ ମୁଡ଼ ଅରେଙ୍‌ ଡେଏନ୍‌ । କେନ୍‌ ଆ କାବ୍ବାଡ଼ା ପ୍ରବୁନ୍‌ ଲୁମେନ୍‌, ଆରି ତିଆତେ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ଲେନ୍‌ ସରାନ୍ନିଡାନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅମଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ତବ୍‌ଲେ ପନାଙନ୍‌ ଡେତେ, ଆରି ଅଙ୍ଗା ମନ୍‌ରାଜି ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ଜଅ ଅଜତଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ତିଆତେ ତନିୟନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ଆରି ଆନା କେନ୍‌ ଅରେଙ୍‌ଲୋଙନ୍‌ ଅକୁଡ୍‌ତେ, ଆନିନ୍‌ ଡେୟ୍‌ଡେୟ୍‌ତନେ, ଆରି ଆନା ଆ ଡଅଙ୍‌ଲୋଙ୍‌ କେନ୍‌ ଅରେଙନ୍‌ ଗଲୋତେ, ଆନିନ୍‌ ରଡ଼ିରଡ଼ି ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ଜିସୁନ୍‌ ଆବର୍ରନ୍‌ ଆନବ୍‌ଜଙ୍‌ବର୍‌ଜି ଅମ୍‌ଡଙ୍‌ଡାଲେ, ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି କେନ୍‌ଆତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ସେଙ୍‌ଲେ ବର୍ତନେ ଗାମ୍‌ଲେ ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି । ବନ୍‌ଡ ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବତଙେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଗାମ୍‌ଲେ ମାନ୍ନେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ଜିସୁନ୍‌ ଆରି ବତର ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ରାଜାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆସନ୍‌ ବିବା ବୁଜିନ୍‌ ତୁବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ଆରି ତି ଆ ବୁଜିଜୋମ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ଆବର୍‌ବରଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଅନୋଡ୍ଡେବାନ୍‌ ଆନିନ୍‌ ଆ କମ୍ବାରିମରଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି, ବନ୍‌ଡ ତି ଆ ମନ୍‌ରାଜି ବୁଜିଜୋମନ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ଅଃଲ୍ଲଡୟ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ରାଜାନ୍‌ ଆରି ବତର ଆନ୍ନା କମ୍ବାରିମରଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ଆବର୍‌ବରଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଏନ୍ନେଲେ ଇୟ୍‌ ବର୍ବାଜି ଗାମେନ୍‌, ‘ଅମ୍‌ଡଙ୍‌ବା, ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ ଆ ବିବା ବୁଜି ଜାଡାଆଜେନ୍‌, ତାଙ୍‌ଲିୟ୍‌ଞେନ୍‌ ଡ ଜେଲ୍‌ଜେଲ୍‌ରାଡମନ୍‌ ଆ ଜନ୍ତୁଜି ରବ୍ବୁଲାୟ୍‌, ଅଡ଼୍‌କୋନ୍‌ ଜାଡାଆଜେନ୍‌ । ଆମ୍ୱେଞ୍ଜି ବୁଜିଜୋମନ୍‌ ଇୟାୟ୍‌ବା ।’ ");
INSERT INTO juy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ବନ୍‌ଡ ଆନିଞ୍ଜି ବୁଜିଜୋମନ୍‌ ଅବ୍‌ସନ୍ନାଡାଲେ ଲାଙ୍‌ଲେନ୍ନେ କୋତ୍ତାନ୍‌ ଜିରେଞ୍ଜି, ଆରି ଲାଙ୍‌ଲେନ୍ନେ ବେପାରବାନ୍‌ ଜିରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ଆରି ଲାଙ୍‌ଲେନ୍ନେ ରାଜାନ୍‌ ଆ କମ୍ୱାରିମର୍‌ଜିଆଡଙ୍‌ ଞମ୍‌ଲେ ତିଡେଞ୍ଜି କି ରବ୍ବୁଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ଆରି ରାଜାନ୍‌ ବରାବେନ୍‌ କି ଆ ସିପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି, ସିପ୍ପାୟଞ୍ଜି ଜିର୍ରେ ତି ସମ୍ବବ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ରବ୍ବୁଆଜେଜି ଆରି ଆ ଗଡ଼ାଞ୍ଜି ଇୟ୍‌ଲେ ସୟେଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ରାଜାନ୍‌ କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ‘ବିବା ବୁଜିନ୍‌ ଜାଡାଆଜେନ୍‌, ବନ୍‌ଡ ଆବର୍‌ବରଞ୍ଜି ଆ ମନ୍‌ରାଜି ଜିଞ୍ଜିନ୍‌ଜି ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ସୋଡ଼ା ସୋଡ଼ା ସାଇରେଙନ୍‌ ଇୟ୍‌ବା ଆରି ଡିଅଙ୍ଗା ମନ୍‌ରାଞ୍ଜି ଇୟ୍‌ତେ ଏରବାଙେଜି ତି ଅଡ଼୍‌କୋଞ୍ଜି ବୁଜିଜୋମନ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ଇୟ୍‌ ବର୍ବାଜି ।’ ");
INSERT INTO juy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ସିଲତ୍ତେ କମ୍ୱାରିମରଞ୍ଜି ସାଇ ସାଇ ବୁଲ୍ଲେଲେ ମନଙେତୋ ମନଙ୍‌ଡଙ୍‌ ଡିଅଙ୍ଗା ମନ୍‌ରାଞ୍ଜି ଇୟ୍‌ଲେ ରବାଙେଜି ତି ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଲେ ଇୟ୍‌ଲେ ଓରୋଙେଜି, ଆରି ବିବାସିଙନ୍‌ ମନ୍‌ରାଞ୍ଜି ବରିଜେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ରାଜାନ୍‌ କନୁଆମରଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ଆରି ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ବିବା ଅଙ୍ଗିନ୍‌ ଏର୍‌ରନେନ୍‌ ବୁଜିଜୋମନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ରାଜାନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଗିୟ୍‌ଲେ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘ଏ ଗଡ଼ି, ବିବା ଅଙ୍ଗିନ୍‌ ଏର୍‌ରନେନ୍‌ ଆମନ୍‌ ତେନ୍ନେ ଏଙ୍ଗାଲେ ଗନ୍‌ଲାୟ୍‌ ?’ ବନ୍‌ଡ ତି ଆ ମନ୍‌ରା ଅଃଜ୍ଜାଲଙ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ସିଲତ୍ତେ ରାଜାନ୍‌ ଆ କମ୍ବାରିମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ‘କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆସିନ୍‌ ଆଜଙନ୍‌ ଜିଲେ, ଡାଣ୍ଡନ୍‌ ଆଲୋଙଡ୍‌ରେଙନ୍‌ ସେଡ୍‌ବା । ତେତ୍ତେ ଆନିନ୍‌ ୟେୟେଡାନ୍‌ ଡ ରମ୍‌ରମ୍‌ଜିନ୍‌ ଡେଏତୋ ।’” ");
INSERT INTO juy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗୋଗୋୟ୍‌ ମନ୍‌ରା ଅନୋଡ୍ଡେନ୍‌ ଡେଲୋ, ବନ୍‌ଡ ଅସୋୟ୍‌ ମନ୍‌ରା ସନେଡାନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ତିଆଡିଡ୍‌ ପାରୁସିଞ୍ଜି ଜିରେଞ୍ଜି କି ଜିସୁନ୍‌ଆଡଙ୍‌ ସେକ୍କୁବରନ୍‌ ଅପ୍ପୁଙ୍‌ଡାଲେ ଆ ବର୍ନେଲୋଙନ୍‌ ସରିଡ୍‌ସିଡ୍‌ବରନ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ଇୟ୍‌ଲେ ସାଜେଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ଆରି ଆନିଞ୍ଜି ଆ ସନଣ୍ଡୋଙ୍‌ମରଞ୍ଜି ଡ ଏରୋଦନ୍‌ ଆ ମରାୟ୍‌ନେମର୍‌ଜିଆଡଙ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି । ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେନ୍‌ ଜନା ଆମନ୍‌ ଆଜାଡ଼ିନ୍‌ ଆ ବର୍ନେ ବର୍ତନେ, ଆରି ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ତଙର୍‌ ଆଜାଡ଼ିନ୍‌ ଗାମ୍‌ଲେ ଞନଙନ୍‌ ତିୟ୍‌ତେ, ଆମନ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃବ୍ବତଙମ୍, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃଡ୍ଡୁଲ୍‌ମଡେ । ");
INSERT INTO juy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ତିଆସନ୍‌ ଆମନ୍‌ ଇନି ଗାମ୍‌ତେ ? ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ବର୍ରେନ୍‌, କାଇସରନ୍‌ଆଡଙ୍‌ ପାନୁନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଅଡ଼େତେ ପଙ୍‌, ଅଡ଼େ ଇଜ୍ଜା ?” ");
INSERT INTO juy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ ପେଲ୍ଲାଞ୍ଜି ଜନାଡାଲେ ବର୍ରନେ, “ଏ ଇସ୍କତ୍ତାମର୍‌ଜି, ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ଏମାଲ୍‌ତିଁୟ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ପାନୁଡାବନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅବ୍‌ତୁଜିଁୟ୍‌ବା ।” ଆନିଞ୍ଜି ଅବୟ୍‌ ଆ ଗୁଣ୍ଡାଡାବନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ପାଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ ଆ ଗୁଣ୍ଡାଡାବ୍‌ଲୋଙନ୍‌ ଆନା ଆ ମୁକ୍କା ଆରି ଆନା ଆଞୁମ୍‌ ଡକୋ ?” ");
INSERT INTO juy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “କାଇସରନ୍‌ ଆ ମୁକ୍କା ଡକୋ ।” ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅଙ୍ଗାତେ କାଇସରନ୍‌ଆତେ ତିଆତେ କାଇସରନ୍‌ ତିୟ୍‌ବା, ଆରି ଅଙ୍ଗାତେ ଇସ୍ୱରନ୍‌ଆତେ ତିଆତେ ଇସ୍ୱରନ୍‌ ତିୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ଆନିଞ୍ଜି କେନ୍‌ଆତେ ଆରମ୍‌ଡଙେଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ୟନର୍ମେଙନ୍‌ ଇଜ୍ଜା ଆଗ୍ରାମ୍‌ତେଞ୍ଜି ଆ ସାଦୁକିଜି ତି ଆ ଡିନ୍ନା ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରାଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ମୋସାନ୍‌ ବର୍ରନେ, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ବିବାଡାଲନ୍‌ ଏର୍‌କନୋଡନନ୍‌ ରବୁଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆ ଓବ୍ବାନ୍‌ ତି ଜୁଆର୍‌ବଜନ୍‌ ବୟନ୍‌ ବିବାଡାଲନ୍‌ ଆରବୁମରନ୍‌ ଆସନ୍‌ ପସିଜନ୍‌ କୋଡେତୋ । ");
INSERT INTO juy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ଗିଜା, ତେନ୍ନେ ଅମଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ସାତ ବନୋଞାଙ୍‌ ଡକୋଏଞ୍ଜି; ଆପର୍ତମ୍ମୁମର୍‌ ବିବାଡାଲନ୍‌ ଏର୍‌କନୋଡନନ୍‌ ରବୁଏନ୍‌, ତିଆସନ୍‌ ଆ ଓବ୍ବାନ୍‌ ତି ଜୁଆର୍‌ବଜନ୍‌ ବୟନ୍‌ ବିବାଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ଏତ୍ତେଲେମା ଅନବ୍‌ବାଗୁ ବନୋଞାଙ୍‌, ଅନବ୍‌ୟାଗି ବନୋଞାଙ୍‌ ଆରି ଆତନିକ୍କି ଆ ସନ୍ନା ବନୋଞାଙ୍‌ ନିୟ୍‌ ତି ଜୁଆର୍‌ବଜନ୍‌ ବୟନ୍‌ ବିବାଡାଲନ୍‌ ଏର୍‌କନୋଡନନ୍‌ ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ଅଡ଼୍‌କୋଞ୍ଜି ଆ ତିକ୍କି ଆଇମରନ୍‌ ନିୟ୍‌ ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସାତ ବନୋଞାଙଞ୍ଜି ତ ତି ଆଇମରନ୍‌ ବୟନ୍‌ ବିବାଲଞ୍ଜି, ୟନର୍ମେଙ୍‌ ଡିନ୍ନାଇଙନ୍‌ ତି ଆଇମରନ୍‌ ସାତ ବନୋଞାଙଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନା ଆ ଡୁକ୍ରି ଡେତେ ?” ");
INSERT INTO juy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଡରମ୍ମ ସାସ୍ତ୍ରନ୍‌ ଡ ଇସ୍ୱରନ୍‌ ଆ ବୋର୍ସା ଅଃଗନ୍‌ଲୁଡ୍‌ବେନନ୍‌ ଆସନ୍‌ ଆଡ଼ଆୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜି ୟର୍ମେଙେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଅଃଞାଙ୍‌ବୟ୍‌ନେଜି କି ଅଃସୁଉଂନେଜି, ଆନିଞ୍ଜି ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଅନ୍ତମ୍‌ ଡକୋତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ଆରବୁମରଞ୍ଜି ଆ ୟନର୍ମେଙ୍‌ ଆ ବର୍ନେ ଇସ୍ୱରନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଇନି ଗାମ୍‌ଲବେନ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ଏପଡ଼େନେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ଇସ୍ୱରନ୍‌ ଗାମେନ୍‌, ‘ଞେନ୍‌ ଅବ୍ରାମନ୍‌ ଆ ଇସ୍ୱର, ଇସାକନ୍‌ ଆ ଇସ୍ୱର, ଆରି ଜାକୁବନ୍‌ ଆ ଇସ୍ୱର ।’ ଆନିନ୍‌ ଆରବୁମରଞ୍ଜି ଆ ଇସ୍ୱର ତଡ୍‌, ଆମେଙ୍‌ମରଞ୍ଜି ଆ ଇସ୍ୱର ।” ");
INSERT INTO juy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ଜିସୁନ୍‌ ଆ ଞନଙ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ଜିସୁନ୍‌ ସାଦୁକିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ରିଙ୍‌ରିଙେଞ୍ଜି ଗାମ୍‌ଲେ ପାରୁସିଞ୍ଜି ଆରମ୍‌ଡଙେଞ୍ଜି ଆନିଞ୍ଜି ରୁକ୍କୁଡାଲନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାଜି, ");
INSERT INTO juy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ଆରି ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଅବୟ୍‌ନେ ବନାଁୟ୍‌ବରନ୍‌ ଆପଡ଼େନେମରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ମାଲ୍‌ଲେ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଅଙ୍ଗା ବନାଁୟ୍‌ ସୋଡ଼ା ?” ");
INSERT INTO juy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “‘ଆମ୍ୱେନ୍‌ ସମ୍ପରା ଉଗର୍‌ବେନ୍‌, ସମ୍ପରା ପରାନ୍ନାବେନ୍‌ ଡ ସମ୍ପରା ମନ୍ନବେନ୍‌ ତିୟ୍‌ଲେ ପ୍ରବୁ ଇସ୍ୱରବେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ବା ।’ ");
INSERT INTO juy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","କେନ୍‌ଆତେ ମା ସୋଡ଼ା ଆରି ପର୍ତମ୍ମୁ ବନାଞନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ଅନବ୍‌ବାଗୁ ବନାଞନ୍‌ କେନ୍‌ଆତେ, ‘ଆମ୍ୱେନ୍‌ ତୟ୍‌ଲିସିଂମର୍‌ବେନ୍‌ଆଡଙ୍‌ ଆମ୍ବେନ୍‌ଡମ୍‌ ଅନ୍ତମ୍‌ ଡୁଙ୍‌ୟମ୍‌ବା ।’ ");
INSERT INTO juy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","କେନ୍‌ ବାଗୁ ବନାଁୟ୍‌ଲୋଙନ୍‌ ଅଡ଼୍‌କୋ ବନାଁୟ୍‌ବରନ୍‌ ଡ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ଞନଙ୍‌ ସିନ୍‌ସନୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ପାରୁସିଞ୍ଜି ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଞ୍ଜି ଆଡିଡ୍‌, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“କ୍ରିସ୍ଟନ୍‌ ଆ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନି ଏବ୍‌ଡିସୟ୍‌ତେ ? ଆନିନ୍‌ ଆନା ଆ କେଜ୍ଜା ?” ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆନିନ୍‌ ଦାଉଦନ୍‌ ଆ କେଜ୍ଜା ।” ");
INSERT INTO juy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଦାଉଦନ୍‌ ଏଙ୍ଗାଲେ କ୍ରିସ୍ଟନ୍‌ଆଡଙ୍‌ ‘ପ୍ରବୁ’ ଗାମ୍‌ତେ ? ଦାଉଦନ୍‌ ପୁରାଡ଼ାନ୍‌ ବୟନ୍‌ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘ପ୍ରବୁନ୍‌ ପ୍ରବୁଞେନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ଞେନ୍‌ ଅଙ୍ଗା ଜାୟ୍‌ ବନେରାନମ୍‌ଜିଆଡଙ୍‌ ତାଲ୍‌ଜଙ୍‌ନମ୍‌ ଆ ଜାୟ୍‌ତା ଅଣ୍ଡ୍ରଙ୍‌ ଡକ୍କୋଆଜି, ତି ଜାୟ୍‌ ଆମନ୍‌ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ଞେନ୍‌ ତଙ୍କୁମ୍‌ଲେ ଡକୋନା ।’ ");
INSERT INTO juy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ଦାଉଦନ୍‌ କ୍ରିସ୍ଟନ୍‌ଆଡଙ୍‌ ‘ପ୍ରବୁ’ ଗାମ୍‌ତେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କ୍ରିସ୍ଟନ୍‌ ଏଙ୍ଗାଲେ ଦାଉଦନ୍‌ ଆ କେଜ୍ଜା ଅଲ୍‌ଡେଏ ?” ");
INSERT INTO juy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ସିଲତ୍ତେ ଆନ୍ନିଙ୍‌ ବପଦ ଓୟ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାଲଙ୍‌ଲଜି, ଆରି ତି ଆ ଡିନ୍ନା ସିଲଡ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସନେକ୍କୁବରନ୍‌ ଆସନ୍‌ ଆନ୍ନିଙ୍‌ ଅଃନ୍ନୋମଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ତି ଆ ବନେଡ଼ା ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜି ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ମୋସାନ୍‌ ଆ ତରଙ୍କୁମେନ୍‌ ଆ କୁର୍ସିଲୋଙ୍‌ ଆତଙ୍କୁମ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଇନିଜି ଆ ବର୍ନେଜି ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେଞ୍ଜି, ତିଆତେ ଲୁମ୍‌ବା ଆରି ଞଣ୍ଡ୍ରମ୍‌ନାବା, ବନ୍‌ଡ ଆନିଞ୍ଜି ଆର୍‌ଲୁମ୍‌ତେଞ୍ଜି ଅନ୍ତମ୍‌ ଏଲୁମ୍‌ଡଙ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଞନଙନ୍‌ ତିୟ୍‌ତଜି, ବନ୍‌ଡ ଅଙ୍ଗାତେ ଞନଙନ୍‌ ତିୟ୍‌ତଜି ତିଅନ୍ତମ୍‌ ଅଃଞଣ୍ଡ୍ରମ୍‌ନେଜି । ");
INSERT INTO juy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ଆନିଞ୍ଜି ଲଗିନ୍‌ଡମନ୍‌ ଆ ବିଡ଼ାର୍‌ ଜିଲେ ମନ୍‌ରାଞ୍ଜି ଆ ତାରଙ୍‌ଲୋଙ୍‌ ଅବ୍ବୋୟ୍‌ତଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ତିଆତେ ଆ ଅଣ୍ଡେର୍‌ସିଞ୍ଜି ବାତ୍ତେ ନିୟ୍‌ ଅଃତ୍ତେକ୍କେଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡମ୍‌ନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ କାବ୍ବାଡ଼ା ଲୁମ୍‌ତଜି, ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆ ବର୍ନେ ଆଇଡିଡନ୍‌ ଆ ଡଙରା ଅବ୍‌ସୋଡ଼ାରାଲେ ଆନିଞ୍ଜି ଆଇଡାଡ଼ାଲୋଙଞ୍ଜି ଜିବବ୍‌ତଞ୍ଜି ଆରି ଆର୍କାବଡ଼ିସିଲୋଙଞ୍ଜି ଜିସିତଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆ ସିନ୍‌ରିଞ୍ଜି ଆ ତାଡ଼େର୍‌ ଅବ୍‌ଡେଙ୍ଗାତଜି । ");
INSERT INTO juy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ଆରି ଆନିଞ୍ଜି ବୁଜିରେଙନ୍‌ ମନଙ୍‌ ତରଙ୍କୁମନ୍‌ ଡ ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ସୋଡ଼ା ତରଙ୍କୁମନ୍‌ ଲଡୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ସରେଁୟ୍‌ତାରେଙନ୍‌ ଅବ୍‌ଲୋମ୍‌ଲୋମ୍‌ନେନ୍‌ ଆସନ୍‌ ଡ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ‘ଞନଙ୍‌ତିୟ୍‌ମର୍‌’ ଗାମ୍‌ଲେ ଅନବ୍‌ଓଡ୍ଡେନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଲଡୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ବନ୍‌ଡ ଆନ୍ନିଙ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ‘ଞନଙ୍‌ତିୟ୍‌ମର୍‌’ ଗାମ୍‌ଲେ ଓଡ୍ଡେଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ବନୋଞାଙ୍‌ ଡେତବେନ୍‌, ଆବୟ୍‌ନେନ୍‌ ତୁମ୍‌ ଞନଙ୍‌ତିୟ୍‌ମର୍‌ବେନ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ଆରି ପୁର୍ତିଲୋଙନ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ‘ଆପେୟ୍‌’ ଗାମ୍‌ଲେ ଏଓଡ୍ଡେଡଙ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆବୟ୍‌ନେନ୍‌ ତୁମ୍‌ ଆପେୟ୍‌ବେନ୍‌, ଆନିନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ଆରି ଆନ୍ନିଙ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ‘ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମର୍‌’ ଗାମ୍‌ଲେ ଓଡ୍ଡେଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କ୍ରିସ୍ଟନ୍‌ ତୁମ୍‌ ଆବୟ୍‌ନେନ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମର୍‌ବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ବନ୍‌ଡ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆନା ସୋଡ଼ାମର୍‌, ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ସାକ୍କେବେନ୍‌ତୋ । ");
INSERT INTO juy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ଆରି ଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଡମ୍‌ ଅବ୍‌ସୋଡ଼ାଡମ୍‌ତନେ, ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ସନ୍ନାନ୍‌ ଡେତେ, ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ଅବ୍‌ସନ୍ନାଡମ୍‌ତନେ, ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ସୋଡ଼ାନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ୟୋଙ୍‌, ଇସ୍କତ୍ତାମର୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ପନବ୍‌ରଡ୍‌ବେନ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆ ମୁକ୍କାଗଡ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ ଆ ସନଙ୍‌ ଏଇଙଡ୍‌ତେ ଆମ୍ବେନ୍‌ଡମ୍‌ ତେତ୍ତେ ଏଃଗନେ କି ଆନାଜି ତେତ୍ତେ ଗଙ୍ଗନନ୍‌ ସାୟ୍‌ତଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଏଃନ୍ନବ୍‌ଗଙ୍ଗନେଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“ୟୋଙ୍‌, ଇସ୍କତ୍ତାମର୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ପନବ୍‌ରଡ୍‌ବେନ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡମ୍‌ନେନ୍‌ ଆସନ୍‌ ଗୋଗୋୟ୍‌ ଏପାର୍ତନାତନେ, ଆରି ଜୁଆର୍‌ବଜଞ୍ଜିଆଡଙ୍‌ ଏବୁର୍ଡତଜି, ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ୟୋଙ୍‌, ଇସ୍କତ୍ତାମର୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ପନବ୍‌ରଡ୍‌ବେନ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ମରାୟ୍‌ନେଲୋଙ୍‌ବେନ୍‌ ଅନବ୍‌ମାୟ୍‌ମାୟନ୍‌ ଆସନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ପଡ୍‌ଲେ ଡେସା ଗୋସା ବୁଲ୍ଲେଲେ ଏପାଙ୍‌ତେ । ବନ୍‌ଡ ଏତ୍ତେଗନ୍‌ ଆ ମନ୍‌ରା ଅବୟ୍‌ ଏଞାଙେନ୍‌ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ସିଲଡ୍‌ ବାଗୁ ଗୁନା ଆନିନ୍‌ଆଡଙ୍‌ ନରକନ୍‌ ଏବ୍‌ଜିର୍ଜିର୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ଏ ଆକାଡ଼ୁ ତଙର୍‌ ଅନବ୍‌ତୁୟ୍‌ମର୍‌ଜି, ପନବ୍‌ରଡ୍‌ବେନ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ଆମ୍ୱେଞ୍ଜି ଏନ୍ନେଲେ ଞନଙନ୍‌ ଏତିୟ୍‌ତେ, ‘ଆନା ସରେବାସିଙନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌, ତିଆତେ ଆନିନ୍‌ ଆଲ୍ଲେଏନ୍‌ ଜନଙ୍‌ଡେନ୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌; ବନ୍‌ଡ ଆନା ସରେବାସିଙନ୍‌ ଆ ସୁନା ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌, ତିଆତେ ଆନିନ୍‌ ଜଗଃମଗଃ ଲୁମେତୋ ।’ ");
INSERT INTO juy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ଏ ଉଲ୍ଲୁ କାଡ଼ୁମର୍‌ଜି, ସୁନାନ୍‌ ସୋଡ଼ା ଅଡ଼େ ସୁନାନ୍‌ ଆରବ୍‌ମବ୍‌ଡ଼ିର୍‌ତେନ୍‌ ଆ ସରେବାସିଂ ସୋଡ଼ା, କେନ୍‌ ବାଗୁଲୋଙନ୍‌ ଅଙ୍ଗାତେ ସୋଡ଼ା ? ");
INSERT INTO juy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ଆମ୍ୱେଞ୍ଜି ଆରି ଏନ୍ନେଲେ ନିୟ୍‌ ଞନଙନ୍‌ ଏତିୟ୍‌ତେ, ‘ଆନା ତରୋମ୍ମୋଡ୍‌ ତନମ୍ପିଲନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌, ତିଆତେ ଆନିନ୍‌ ଆଲ୍ଲେଏନ୍‌ ଜନଙ୍‌ଡେନ୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌, ବନ୍‌ଡ ଆନା ତରୋମ୍ମୋଡ୍‌ ତନମ୍ପିଲ୍‌ଲୋଙନ୍‌ ଆନମଙ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌, ତିଆତେ ଆନିନ୍‌ ଜଗଃମଗଃ ଲୁମେତୋ ।’ ");
INSERT INTO juy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ଏ କାଡ଼ୁମର୍‌ଜି, ଅଙ୍ଗାତେ ସୋଡ଼ା, ଅନମଙନ୍‌ ସୋଡ଼ା ଅଡ଼େ ଅନମଙନ୍‌ ଆରବ୍‌ମବ୍‌ଡ଼ିର୍‌ତେନ୍‌ ଆ ତନମ୍ପିଲ୍‌ ସୋଡ଼ା ? ");
INSERT INTO juy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ତିଆସନ୍‌ ଆନା ତରୋମ୍ମୋଡ୍‌ ତନମ୍ପିଲନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌, ଆନିନ୍‌ ତରୋମ୍ମୋଡ୍‌ ତନମ୍ପିଲ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତେନ୍‌ ଆନମଙ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ଆରି ଆନା ସରେବାସିଙନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌, ଆନିନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଆପ୍ରଡ୍‌ତନାଞନ୍‌ ଆ ଇସ୍ୱର ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ଆରି ଆନା ରୁଆଙନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌, ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ କୁର୍ସି ଆରି ତେତ୍ତେ ଆତ୍ରଙ୍କୁମ୍‌ତେନ୍‌ ଆ ଇସ୍ୱର ଆଞୁମ୍‌ଲୋଙ୍‌ ପର୍ମାଡ଼ାତନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ଏ ଇସ୍କତ୍ତାମର୍‌ ସାସ୍ତ୍ରିଜି ଡ ପାରୁସିଜି ପନବ୍‌ରଡ୍‌ବେନ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପୋଦିନାନ୍‌, ପାନମଉରିନ୍‌ ଡ ଜିରାନ୍‌ ଆ ଦସମାଂସ ଏତିୟ୍‌ତେ, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଆଜାଡ଼ି ପନ୍‌ସୁଆତିନ୍‌, ସନାୟୁମନ୍‌, ଡର୍ନେନ୍‌ କେନ୍‌ଆତେଜି ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଆ ସୋଡ଼ା ସୋଡ଼ା ବନାଁୟ୍‌ଜି ଅମଙ୍ଗଡ଼ାୟ୍‌ ଏଏମ୍ମେତନ୍‌ । ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ କେନ୍‌ ଆ ବନାଁୟ୍‌ଜି ରୟ୍‌ ଆମ୍ମୁଙ୍‌ ଞଣ୍ଡ୍ରମ୍‌ନାବା । ");
INSERT INTO juy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ଏ ଆକାଡ଼ୁ ତଙର୍‌ ଅନବ୍‌ତୁୟ୍‌ମର୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ଅରୟନ୍‌ ଏସାଡ଼ାର୍‌ତେ, ବନ୍‌ଡ ଓଟନ୍‌ ଏମତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ଏ ଇସ୍କତ୍ତାମର୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି, ପନବ୍‌ରଡ୍‌ବେନ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଗିନାନ୍‌ ଡ ସଡ଼ୁଆନ୍‌ ଆ କିଣ୍ଡୋଙ୍‌ ତୁମ୍‌ ଏଗିୟ୍‌ଡାତେ, ବନ୍‌ଡ ଅମ୍ମନ୍‌ ରାଉନ୍‌ ଡ ଇସାଲଙନ୍‌ ଆବରିୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ଏ କାଡ଼ୁ ପାରୁସିଜି, ଆମ୍ମୁଙ୍‌ ଗିଲ୍ଲନ୍‌ ଆ ଅମ୍ମଗଡ୍‌ ରୟ୍‌ ଗିୟ୍‌ଡାବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆ କିଣ୍ଡୋଙନ୍‌ ନିୟ୍‌ ମନଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ଏ ଇସ୍କତ୍ତାମର୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ପନବ୍‌ରଡ୍‌ବେନ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଜେଏଡମନ୍‌ ଆ ମସାନ୍ନି ଅନ୍ତମ୍‌ । ତିଆତେ ଡୁଆରାନ୍‌ ମନଙ୍‌ ଗିୟ୍‌ତାତେ, ବନ୍‌ଡ ଅମ୍ମନ୍‌ ଆରବୁମରଞ୍ଜି ଆଜାଙ୍‌ ଡ ପରାନ୍‌ସାତ୍ତିନ୍‌ ଆବରିୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ତିଅନ୍ତମ୍‌, ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଡୁଆରାନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ ମନଙ୍‌ମର୍‌ ଗିୟ୍‌ତାତବେନ୍‌, ବନ୍‌ଡ ଅମ୍ମବେନ୍‌ ଇସ୍କତ୍ତାନ୍‌ ଡ ଇର୍ସେନ୍‌ ଆବରିୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ଏ ଇସ୍କତ୍ତାମର୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ପନବ୍‌ରଡ୍‌ବେନ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ମସାନ୍ନି ଏତୁବ୍‌ତେ, ଆରି ଡରମ୍ମମରଞ୍ଜି ଆ ସନ୍ଦନି ଏବ୍‌ସଜ୍ଜତେ । ");
INSERT INTO juy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ଆରି ଏବର୍ତନେ, ‘ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆ ବନେଡ଼ା ଇନ୍‌ଲେଞ୍ଜି ଡକୋଲଲେନ୍‌ ନଙ୍‌, ଇନ୍‌ଲେଞ୍ଜି ଆନିଞ୍ଜି ଅନ୍ତମ୍‌ ଏଃନ୍ନେମ୍ମେନାୟ୍‌ ବନ୍‌, ଆରି ଆନିଞ୍ଜି ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ଆସ୍ରମ୍‌ବବେଞ୍ଜି ଇନ୍‌ଲେନ୍‌ ତେତ୍ତେ ଏଃମ୍ମାୟ୍‌ନାୟ୍‌ ବନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜିଡମ୍‌ ଏବର୍ତନେ, ଆମ୍ୱେଞ୍ଜି ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ଆସ୍ରମ୍‌ବବେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆ କେଜ୍ଜାଜି । ");
INSERT INTO juy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ଆରି ପୁର୍ବା ଜୋଜୋବେଞ୍ଜି ଆରବ୍‌ତୁଙାରେଞ୍ଜି ଆ କାବ୍ବାଡ଼ା ଆମ୍ୱେଞ୍ଜି ଅମ୍‌ତୁଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ଏ ଜାଆଡ୍‌ଜି, ଜାଆଡନ୍‌ ଆ କେଜ୍ଜାଜି ! ଆମ୍ୱେଞ୍ଜି ନରକନ୍‌ ଆ ପନବ୍‌ରଡ୍‌ ସିଲଡ୍‌ ଏଙ୍ଗାଡାଲେ ଅଡ଼ୁର୍‌ବେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ତିଆସନ୍‌ ଅମ୍‌ଡଙ୍‌ବା, ଞେନ୍‌ ଅମଙ୍‌ବାବେନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି, ଆଜନନାମରଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତାଜି; ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏରବ୍ବୁତଜି, ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଏଅମ୍‌ଡାୟ୍‌ତଜି, ଆରି ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ସାମକାନ୍‌ ବାତ୍ତେ ଏତିଡ୍‌ତଜି କି ବ ଗଡ଼ା ସିଲଡ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ଆରି ବ ଗଡ଼ା ଏଗଙ୍‌ତିଡ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ଡରମ୍ମମର୍‌ ଏବଲନ୍‌ ସିଲଡ୍‌ ଉଲନ୍‌ ସରେବାସିଙନ୍‌ ଡ ତନମ୍ପିଲନ୍‌ ଆ ମଡ୍ଡିଲୋଙ୍‌ ବେରିକିଅନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିକରିୟନ୍‌ଆଡଙ୍‌ ଏସ୍ରମ୍ବବେନ୍‌ ଜାୟ୍‌, ଆରି କେନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଡିଅଙ୍ଗା ଡରମ୍ମମରଞ୍ଜିଆଡଙ୍‌ ସନମ୍ୱବନ୍‌ ଡେଏନ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ ନମି ଆ ଜୁଗ ଆ ମନ୍‌ରାଜି ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ଏ ଜିରୁସାଲମ, ଏ ଜିରୁସାଲମ, ଆମନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ସମ୍ୱବେନ୍‌, ଆରି ଅମଙ୍‌ନମ୍‌ ଆନାପ୍ପାୟ୍‌ଜିଆଡଙ୍‌ ଆମନ୍‌ ତିଡରେନ୍‌, ଆୟୋଙିମନ୍‌ ଏଙ୍ଗାଲେ ଆ କାପ୍ପାନ୍‌ ଆ ଜାୟ୍‌ତା ଆଅନ୍‌ସିଆବଞ୍ଜି ଅବ୍‌ରୁକ୍କୁତେ, ତିଅନ୍ତମ୍‌ ଡିଅଙ୍ଗା ବେଡ଼ା ଞେନ୍‌ ପସିୟ୍‌ନମ୍‌ଜିଆଡଙ୍‌ ଅନବ୍‌ରୁକ୍କୁନ୍‌ ଆସନ୍‌ ସାୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଅସାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ଗିୟ୍‌ବା ଅସିଂବେନ୍‌ ଅସିଲୋଙ୍‌ବେନ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଡେଲୋ, ଆରି ତିଆତେ ସିସିଂତେ । ");
INSERT INTO juy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ‘ପ୍ରବୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଆନା ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌ ଡେଏତୋ’ ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଆ ବର୍ନେ ଅଣ୍ଡ୍ରଙ୍‌ ଏବର୍ନେନ୍‌ ଜାୟ୍‌ ଲଙେ ସିଲଡ୍‌ ଞେନ୍‌ ଆରି ଏଃଗିଜିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ଜିସୁନ୍‌ ସରେବାସିଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ସରେବାସିଙନ୍‌ ଆ ମେଡ଼ସିଂଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ତୁଜନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ନମିଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଏଗିୟ୍‌ତେ । ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ତେନ୍ନେ ଅବୟ୍‌ ଅରେଙନ୍‌ ଆରି ଅବୟ୍‌ ଅରେଙନ୍‌ ଆ ତୋଣ୍ଡୋ ଅଃଡ୍ଡକୋଏ, ଅଡ଼୍‌କୋନ୍‌ ଲବଲୋଙନ୍‌ ମାୟାୟ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ଜିସୁନ୍‌ ତୋଣ୍ଡୋ ଜିତବୁରନ୍‌ ଆତଙ୍କୁମନ୍‌ ଆଡିଡ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙନ୍‌ ଜିର୍ରେ ଅଜନା ଇୟ୍‌ଲାୟ୍‌ ବରେଜି । “କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଙ୍ଗା ଗଡେଲ୍‌ତେ, ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ବର୍ରେନ୍‌ । ଇନିଜି ଡେଏନ୍‌ ଡେନ୍‌ ବାର୍‌ଜନିର୍‌ନମ୍‌ ତୁୟାଲାୟ୍‌ ଆରି କେନ୍‌ ଆ ଜୁଗ ଅଞିଡ୍‌ରୟ୍‌ତେ ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଏଜନାଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନ୍ନିଙ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ କଣ୍ଡାୟ୍‌ଡଙ୍‌ବେନ୍‌ ତଡ୍‌ ତିଆସନ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା । ");
INSERT INTO juy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜବ୍ର ମନ୍‌ରାଜି, ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଇୟ୍‌ଲେ, ‘ଞେନ୍‌ କ୍ରିସ୍ଟନ୍‌’ ଗାମ୍‌ଲେ ଜବ୍ର ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ କଣ୍ଡାୟେଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ଆରି ଆମ୍ୱେଞ୍ଜି ଅଲ୍‌ତିଡ୍‌ବରନ୍‌ ଏଅମ୍‌ଡଙ୍‌ତେ ଆରି ଅଲ୍‌ତିଡନ୍‌ ଆ କବର ଏଅମ୍‌ଡଙ୍‌ତେ; ବତଙ୍‌ଡଙ୍‌ବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଡେତେ ମା ବନ୍‌ଡ ତି ଆ ଡିନ୍ନା ଜୁଗନ୍‌ ଅଃନ୍ନଞିଡେ । ");
INSERT INTO juy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଡେସାନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡେସାନ୍‌, ଆରି ରାଜ୍ୟନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ରାଜ୍ୟନ୍‌ ଡୋତନେ । ଲାଙ୍‌ଲେନ୍ନେରେଙ୍‌ କାନ୍ତାରାନ୍‌, ତକର୍‌ଲନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ବନ୍‌ଡ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ କୋକ୍କୋଡନନ୍‌ ଆଡ୍ରେରୟ୍‌ତେନ୍‌ ଆ ବତ୍ତା ଅନ୍ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ତିଆଡିଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଡନଣ୍ଡାୟନ୍‌ ଆସନ୍‌ ସୋରୋପ୍ପାୟ୍‌ତବେଞ୍ଜି ଆରି ରବ୍ବୁତବେଞ୍ଜି । ଅଞୁମ୍‌ଞେନ୍‌ ଆସନ୍‌ ଗାମ୍‌ଲେ ଅଡ଼୍‌କୋ ଏର୍‌ଡର୍ନେମରଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ତିଆଡିଡ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଡର୍ନେନ୍‌ ଅମ୍‌ରେଙ୍‌ତଜି, ତର୍ଡମ୍‌ ଅଲ୍‌ବାୟ୍‌ସିତଜି, ତର୍ଡମ୍‌ ଅଲ୍‌ନେଡ଼ୁର୍‌ମଡ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ଆରି ଜବ୍ରଡମ୍‌ କଣ୍ଡାୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଡୁଙ୍‌ତନାଜି କି ଜବ୍ର ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ କଣ୍ଡାୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ଇର୍ସେନ୍‌ ଗୋଗୋୟ୍‌ଲେ ପାଙ୍‌ତେ, ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ଡନୁଙ୍‌ୟମ୍‌ ଜଏଙାୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ବନ୍‌ଡ ଆନା ଆତନିକ୍କି ଜାୟ୍‌ ଏର୍‌କିକ୍କିଡ୍‌ନେନ୍‌ ଡକୋତନ୍‌ ଆନିନ୍‌ ଅନୁରନ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ଆରି ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ମନଙ୍‌ବର୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ଅନ୍ତମ୍‌ ସମ୍ପରା ପୁର୍ତିଲୋଙନ୍‌ ଅନପ୍ପୁଙନ୍‌ ଡେତେ, ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜୁଗନ୍‌ ଅଞିଡ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ତିଆସନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଦାନିଏଲନ୍‌ ଆବର୍ରନ୍‌ ଅନ୍ତମ୍‌ ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ମଡ଼ିର୍‌ ଡରକୋନେଲୋଙନ୍‌ ଆରବ୍‌ସେଏଡ୍‌ତେନ୍‌ ଅରେଡ଼ୁର୍‌ମଡ୍‌ଡାନ୍‌ ଆ କୋଙ୍‌ଡାୟ୍‌ ଆତନଙନ୍‌ ଏଗିୟ୍‌ତେ, କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ ପଡ଼େନେମରନ୍‌ ଗନ୍‌ଲୁଡେତୋ । ");
INSERT INTO juy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ତିଆଡିଡ୍‌ ଆନାଜି ଜିଉଦା ଡେସାଲୋଙନ୍‌ ଡକୋତଜି ଆନିଞ୍ଜି ବରୁରେଙନ୍‌ ଜିରେତଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ଆନା ତୋଣ୍ଡୋ ବିଲେଙନ୍‌ ଡକୋତେ ଆନିନ୍‌ ଅସିଙନ୍‌ ସିଲଡ୍‌ ଇନ୍ନିଙ୍‌ଡେନ୍‌ ପନାଙନ୍‌ ଆସନ୍‌ ପଡ୍ଡଙ୍‌ନାୟ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ଆରି ଆନା କୋତ୍ତାଲୋଙନ୍‌ ଡକୋତେ ଆନିନ୍‌ ଆ ସିନ୍‌ରିନ୍‌ ଆପନାଙ୍‌ ଆସନ୍‌ ୟର୍‌ଡଙ୍‌ନାୟ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ତିଆଡିଡ୍‌ ଆନାଜି ଆତିଲ୍‌କୋଡ୍‌ଜି ଆରି ଆରେସାଅନ୍‌ଜି ଆନିଞ୍ଜି ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଜନିର୍‌ଜିର୍‌ବେନ୍‌ ରଙା ଇଙନ୍‌ କି ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଡେଡଙ୍‌ ତଡ୍‌, ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ପାର୍ତନାନାବା । ");
INSERT INTO juy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆଡିଡ୍‌ ଏତ୍ତେଲେ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ ଡ, ପୁର୍ତିନ୍‌ ଆଗ୍ରଡେଲେନ୍‌ ସିଲଡ୍‌ ନମିନ୍ତାନ୍‌ ତି ଅନ୍ତମ୍‌ ଆଙ୍ଗିୟ୍‌ ଏତ୍ତେଲେ ଅଣ୍ଡ୍ରଙ୍‌ ଡେଏ । ଆରି ପୁର୍ବାଃତେ ନିୟ୍‌ ଆଙ୍ଗିୟ୍‌ ଏତ୍ତେଗୋ ଅଃଡ୍ଡେଏ । ");
INSERT INTO juy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ଆରି ତି ଡଣ୍ଡନ୍‌ ଆରଡ଼ୋତାଞନ୍‌ ଆ ଡିନ୍ନା ଇସ୍ୱରନ୍‌ ଅବ୍‌ସୋଜେନ୍‌, ତିଆତେ ଆନିନ୍‌ ଅଃନ୍ନବ୍‌ସୋୟ୍‌ଲୋ ନଙ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଅନ୍ନିଙ୍‌ ଆ ମନ୍‌ରା ଅନୁରନ୍‌ ଅଃଞାଙେଜି ବନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ଆନାଜିଆଡଙ୍‌ ସେଡାଏନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ତି ଆ ଡିନ୍ନା ଆନିନ୍‌ ଅବ୍‌ସୋଜେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ତିଆଡିଡ୍‌ ଆନ୍ନିଙ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ‘ଗିୟ୍‌ବା, କ୍ରିସ୍ଟନ୍‌ ତେନ୍ନେ ଡକୋ’ କି ‘ତେତ୍ତେ ଡକୋ,’ ଗାମ୍‌ଲେ ବର୍ରବେଞ୍ଜି ଡେନ୍‌, ତିଆତେ ଏଡର୍‌ଡଙ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କଣ୍ଡାୟ୍‌ କ୍ରିସ୍ଟାନୁଞ୍ଜି ଡ କଣ୍ଡାୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଡୁଙ୍‌ତନାଜି; ଆନିଞ୍ଜି ସୋଡ଼ା ସୋଡ଼ା ଅରମ୍ମଡଞ୍ଜି ଆରି ସରାନ୍ନିଡାନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଅବ୍‌ତୁୟ୍‌ତଜି, ଡେଲନ୍‌ଡେନ୍‌ ଆସନେଡାମରଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜି କଣ୍ଡାୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ଗିୟ୍‌ବା କେନ୍‌ଆତେ ଅଣ୍ଡ୍ରଙ୍‌ ଡେଏନ୍‌ ଆମ୍ମୁଙ୍‌ ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାଲବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ତିଆସନ୍‌ ‘ଗିୟ୍‌ବା, ଆନିନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଡକୋ,’ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେଞ୍ଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତେତ୍ତେ ଏଇୟ୍‌ଡଙ୍‌; ଅଡ଼େ ‘ଗିୟ୍‌ବା ଆନିନ୍‌ ଅମ୍ମସିଙନ୍‌ ଡକୋ,’ ଗାମ୍‌ଲେ ବର୍ରବେଞ୍ଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଏଡର୍‌ଡଙ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତାବ୍‌ରେଡନ୍‌ ତିଡେନ୍‌ ଡେନ୍‌ ଏଙ୍ଗାଲେ ଡରୁଙ୍‌ୟୋଙ୍‌ଗଡ୍‌ ସିଲଡ୍‌ ବରୁବ୍‌ୟୋଙ୍‌ଗଡ୍‌ ଜାୟ୍‌ ସାଆର୍‌ତେ, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଆ ଡିନ୍ନା ତିଅନ୍ତମ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“ଅଙ୍ଗାଲୋଙ୍‌ ମରାନ୍‌ ଡକୋତେ, ତେତ୍ତେ ମରାଜୋମ୍‌ତିଡଞ୍ଜି ରୁକ୍କୁତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଓୟୋଙନ୍‌ ଲୋଙଡ୍‌ତେ, ଆଙ୍ଗାୟ୍‌ତାନ୍‌ ଅଃସାଆରେ, ତୁତୁଜଞ୍ଜି ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅସେଡାୟ୍‌ତାଜି, ଆରି ରୁଆଙନ୍‌ ଆ ବୋର୍ସାଜି ୟୁଆୟ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ତିଆଡିଡ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆରମ୍ମଡ୍‌ ଗିୟ୍‌ତାତେ; ଆରି ତି ଆ ଡିନ୍ନା ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ବୋର୍ସାନ୍‌ ଡ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ମେଗଲୋଙନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଗିୟ୍‌ଲେ ପୁର୍ତିଲୋଙନ୍‌ ଆଡ୍ରକୋତେଞ୍ଜି ଆ ମନ୍‌ରାଜି ୟେୟେଡାତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ଆରି ଆନିନ୍‌ ପନେଡନ୍‌ ଆ ସନଡ୍ଡା ବୟନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଉଞ୍ଜି କୁନେନ୍‌ ଆପ୍ପାୟ୍‌ତାଜି, ଆନିଞ୍ଜି ରୁଆଙନ୍‌ ଆ ବ ଅନେଙ୍‌ ସିଲଡ୍‌ ଆରି ବ ଅନେଙ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ ଆସ୍ରେଡାଏନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଅବ୍‌ରୁକ୍କୁତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ଲୁଆନୁବନ୍‌ ଆନବ୍‌ଜଙ୍‌ବର୍‌ ସିଲଡ୍‌ ଞଙ୍‌ନାବା, ଆଙ୍ଗାଆଡିଡ୍‌ ଲୁଆନୁବନ୍‌ ଆ କେଣ୍ଡାର୍‌ କୋଡ୍ଡେର୍‌ଲନ୍‌ ଆ ଅଲାନ୍‌ ଲେଡେଙ୍‌ତାୟ୍‌, ତିଆଡିଡ୍‌ ବୌସାକନ୍‌ ଆଙ୍ଗାୟ୍‌ ତୁୟାୟ୍‌ଲାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏଜନାତେ । ");
INSERT INTO juy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ତିଅନ୍ତମ୍‌ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅରମ୍ମଡଞ୍ଜି ଏଗିଜେନ୍‌ ଡେନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ସନଙ୍‌ଲୋଙନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ଜନାବା । ");
INSERT INTO juy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଡେଏନ୍‌ ଜାୟ୍‌ କେନ୍‌ ନମିଜି ଆ ମନ୍‌ରାଜି ଏଙ୍ଗାଲେ ଜନଙ୍‌ ଅଃନ୍ନାଡ଼ଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ରୁଆଙନ୍‌ ଡ ପୁର୍ତିନ୍‌ ଆଡ଼ତେ, ବନ୍‌ଡ ବର୍ନେଞେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଜା ଅଃନ୍ନାଡ଼ଏ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆଙ୍ଗା ଜିର୍ତାୟ୍‌ ତି ଆ ଡିନ୍ନା ଡ ତି ଆ ବେଡ଼ା ଆନ୍ନିଙ୍‌ ଜନାଜି ତଡ୍‌, ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଜନାଜି ତଡ୍‌ କି ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ଜନା ତଡ୍‌; ତିଆତେ ଆପେୟନ୍‌ ତୁମ୍‌ ଜନା । ");
INSERT INTO juy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ଆରି ନୋଅନ୍‌ ଆ ବନେଡ଼ା ଏଙ୍ଗାଗୋ ଡେଏନ୍‌, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଆଡିଡ୍‌ ଏତ୍ତେଗୋ ମା ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗଗଡାନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜିରାଞନ୍‌ ଆରି ନୋଅନ୍‌ ଡାଆ ଜାଜଲୋଙନ୍‌ ଆଗ୍ରନ୍‌ଲନ୍‌ ଆ ଡିନ୍ନା ଜାୟ୍‌ ମନ୍‌ରାଞ୍ଜି ଏଙ୍ଗାଲେ ଗାଏଞ୍ଜି ଜୋମେଞ୍ଜି, ବିବାନେଲୋଙନ୍‌ ଡ ଅନବ୍‌ବିବାଲୋଙନ୍‌ ମଗାଡେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ଆରି ଗଗଡାନ୍‌ ଜିର୍ରାୟ୍‌ କି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ମାବ୍‌ୟାଏନ୍‌ ଆ ଡିନ୍ନା ଜାୟ୍‌ ଇନି ଡେତେ ତିଆତେ ଆନିଞ୍ଜି ଅଃଜ୍ଜନାଲଜି । ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଆ ଡିନ୍ନା ଜନଙ୍‌ ଏତ୍ତେଗନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ତିଆଡିଡ୍‌ ବାଗୁ ମନ୍‌ରା ବସେଙ୍‌ଲୋଙନ୍‌ କାବ୍ବାଡ଼ାତଞ୍ଜି, ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନୋରୋଙନ୍‌ ଡେତେ, ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ବାଗୁ ଆଇମରଞ୍ଜି ରିଡ୍ଡିଁୟ୍‌ତଞ୍ଜି, ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନୋରୋଙନ୍‌ ଡେତେ, ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“ତିଆସନ୍‌ ଜାଗର୍ତ ଡକୋନାୟ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପ୍ରବୁବେନ୍‌ ଅଙ୍ଗା ଡିନ୍ନା ଜିର୍ତାୟ୍‌ ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଜନାଜି ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ବନ୍‌ଡ କେନ୍‌ଆତେ ଜନାବେନ୍‌ତୋ ରାଉମରନ୍‌ ଅଙ୍ଗାବେଡ଼ା ଜିର୍ତାୟ୍‌, ତିଆତେ ଅସିଂମରନ୍‌ ଜନାଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ମବ୍‌ଡ଼େଲନ୍‌ ଡକୋତନ୍‌, ଆରି ଆସିଙନ୍‌ ଅଃନ୍ନବ୍‌ଗଙ୍ଗନେ । ");
INSERT INTO juy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଅବ୍‌ଜାଡାଲନ୍‌ ଡକୋନାୟ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ଆଡିଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଜିର୍ତାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏଃନ୍ନବ୍‌ଡିସୟେ, ତିଆଡିଡ୍‌ ଆନିନ୍‌ ଜିର୍ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଗିୟ୍‌ଲେ ଓୟୋଙନ୍‌, ଆସିଙନ୍‌ ଆ କମ୍ୱାରିମର୍‌ଜିଆଡଙ୍‌ ମନଙ୍‌ଡମ୍‌ ଗାଗାନେନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ସାଉକାରନ୍‌ ଅଙ୍ଗା ମନ୍‌ରାଆଡଙ୍‌ ତବ୍‌ନଙେନ୍‌, ତିଅନ୍ତମ୍‌ ଡର୍ନେଡମ୍‌ ଆରି ବୁଡ୍ଡିଡମନ୍‌ ଆ ଗୁମୁସ୍ତା ଆନା ଡକୋ ? ");
INSERT INTO juy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ସାଉକାରନ୍‌ ଜିର୍ରାୟ୍‌ ଆଡିଡ୍‌ ଅଙ୍ଗା ଗୁମୁସ୍ତା ଏତ୍ତେଲେ ଆକ୍ରାବ୍ବାଡ଼ାତନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗିଜେ, ତି ଆ ଗୁମୁସ୍ତା କରମ୍ମାଡମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ସାଉକାରନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆନର୍ଜେଞ୍ଜି ତିୟ୍‌ଲେ ତି ଗୁମୁସ୍ତାନ୍‌ଆଡଙ୍‌ ତବ୍‌ନଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ବନ୍‌ଡ ତି ଏର୍‌ଡର୍ନେ ଗୁମୁସ୍ତାନ୍‌ ସାଉକାରଞେନ୍‌ ଅଃଲ୍ଲଜିରାୟ୍‌ ଆନିନ୍‌ ଡିଙ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟ୍‌ଡାଲେ, ");
INSERT INTO juy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ଆ ସର୍ସି କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ତିଡ୍‌ତଜି ଆରି ଗାସାଲ୍‌ମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଗାତେ ଜୋମ୍‌ତେ, ");
INSERT INTO juy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆଙ୍ଗାଆଡିଡ୍‌ ଆନିନ୍‌ ଜଗେଲେ ଅଃଡ୍ଡକୋନେ, ଆରି ଅଙ୍ଗା ବେଡ଼ା ଆନିନ୍‌ ଅଃଜ୍ଜନାଏ, ତି ଆ ଡିନ୍ନା, ତି ଆ ବନେଡ଼ା ଆ ସାଉକାରନ୍‌ ଜିର୍ତାୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ଆରି ସାଉକାରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବାଗୁ ଡେୟ୍‌ଡେୟ୍‌ ଏମ୍ମେଡାଲେ ଇସ୍କତ୍ତାମରଞ୍ଜି ସରିନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ମାୟ୍‌ମାୟ୍‌ତେ; ତେତ୍ତେ ଆନିନ୍‌ ୟେୟେଡାନ୍‌ ଡ ରମ୍‌ରମ୍‌ଜିନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ତିଆଡିଡ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଡେତେ । ଦସଜଣ ଡାଙ୍ଗଡ଼ିସିଜଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ପିଙ୍କ ଞମ୍‌ଲେ ବରନ୍‌ଆଡଙ୍‌ ରନବାଙନ୍‌ ଆସନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ମନ୍‌ଲୟ୍‌ନେ ବୁଡ୍ଡିଜି ଡକୋଏଞ୍ଜି, ଆରି ମନ୍‌ଲୟ୍‌ନେ ଏର୍‌ବୁଡ୍ଡିଜି ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ଏର୍‌ବୁଡ୍ଡିଞ୍ଜି ପିଙ୍କନ୍‌ ପାଙେଞ୍ଜି ସିନା ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ଜିତ ମିଞଲନ୍‌ ଅଃପ୍ପାଙ୍‌ତୁମ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ବନ୍‌ଡ ବୁଡ୍ଡିଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ପିଙ୍କ ବୟନ୍‌ ଡାବ୍ବାଲୋଙନ୍‌ ଜିତ ମିଞଲନ୍‌ ନିୟ୍‌ ପାଙ୍‌ତୁମ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ବରନ୍‌ ଆଜନିର୍‌ ଆଡ୍ରିଙ୍‌ଲାଞନ୍‌ ଡାଙ୍ଗଡ଼ିସିଜଞ୍ଜି ମବ୍‌ଲେ ମବ୍‌ଲେ ଅଡ଼୍‌କୋଞ୍ଜି ଡିମଡାଜେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ଆରି ତୁଙାର୍‌ ତଗଲ୍‌ ଇଙନ୍‌ ୟନୋଙ୍‌ୟାଙନ୍‌ ସଡ୍ଡାଏନ୍‌, ‘କେରେ ଗିୟ୍‌ବା ବରନ୍‌ ଜିର୍ରାୟ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ରନବାଙନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ନାୟ୍‌ବା ।’ ");
INSERT INTO juy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ତିଆଡିଡ୍‌ ତି ଆ ଡାଙ୍ଗଡ଼ିସିୟ୍‌ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଡୋଲନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ପିଙ୍କ ଅବ୍‌ଜାଡାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ଆରି ଏର୍‌ବୁଡ୍ଡିଞ୍ଜି ବୁଡ୍ଡିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ‘ଜିତ ମିଞଲ୍‌ବେନ୍‌ ଅଜିଡ୍‌ ଇନ୍‌ଲେଞ୍ଜି ତିୟ୍‌ଲେନ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପିଙ୍କଲେଞ୍ଜି ପଞିଡାୟ୍‌ତେ ।’ ");
INSERT INTO juy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ବନ୍‌ଡ ବୁଡ୍ଡିଞ୍ଜି ଏର୍‌ବୁଡ୍ଡିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, ‘ଇଜ୍ଜା, ଇଜ୍ଜା, ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ଡ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଅଃଡ୍ଡେଡେଲଙ୍‌ନେ, ଆର୍ପାୟ୍‌ ଦୋକାନମରଞ୍ଜି ଆମଙ୍‌ ଇୟ୍‌ଲେ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ମିଞଲନ୍‌ ଞିଲେ ଇୟ୍‌ ପାଙ୍‌ବା ।’ ");
INSERT INTO juy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ଏର୍‌ବୁଡ୍ଡିଞ୍ଜି ମିଞଲନ୍‌ ଞିଞିବାନ୍‌ ଆରିୟେଞ୍ଜି ଆଡିଡ୍‌ ବରନ୍‌ ଜିର୍ରାୟ୍‌, ଆରି ଆନାଜି ଅବ୍‌ଜାଡାଲନ୍‌ ଡକୋଲଞ୍ଜି, ଆନିଞ୍ଜି ବିବା ବୁଜିନ୍‌ ଆସନ୍‌ ବରନ୍‌ ସରିନ୍‌ ଅସିଙନ୍‌ ଗନ୍‌ଲଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସନଙନ୍‌ ଇଙଡ୍‌ଲନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ତିକ୍କି ଏର୍‌ବୁଡ୍ଡି ଡାଙ୍ଗଡ଼ିସିଜଞ୍ଜି ନିୟ୍‌ ଜିର୍ରାଜି କି, ‘ଏ ପ୍ରବୁ, ଏ ପ୍ରବୁ, ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ସନଙନ୍‌ ରୋଲେନ୍‌,’ ଇୟ୍‌ଲାୟ୍‌ ଗାମେଜି । ");
INSERT INTO juy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ବନ୍‌ଡ ବରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, ‘ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଜନା ତଡ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“ତିଆସନ୍‌ ଜଗେଲେ ଡକୋନାୟ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆ ଡିନ୍ନା କି ତି ଆ ବେଡ଼ା ଆମ୍ୱେଞ୍ଜି ଜନାଜି ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙ୍‌ ରାଜ୍ୟନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଆନର୍ଜେଡମନ୍‌ ଅଡ଼୍‌କୋନ୍‌ କମ୍ୱାରିମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ କି ବଡେସାନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ଆନିନ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ମନ୍‌ଲୟ୍‌ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ତିୟେନ୍‌, ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ବାଗୁ ମାଡ଼ିୟ୍‌ ତିୟେନ୍‌, ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ବମାଡ଼ିୟ୍‌ ତିୟେନ୍‌, କେନ୍‌ ଏନ୍ନେଲେ ଆରନପ୍ତିନ୍‌ ଅନ୍ତମ୍‌ ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ରୁପାଡାବନ୍‌ ତିୟ୍‌ଲେ ବଡେସାନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ଅଙ୍ଗା ମନ୍‌ରା ମନ୍‌ଲୟ୍‌ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଞାଙେନ୍‌, ଆନିନ୍‌ ତିଆତେ ପାଙ୍‌ଲେ ସିଲତ୍ତେମା ଇୟ୍‌ଲେ ବେପାରନେ କି ଆରି ମନ୍‌ଲୟ୍‌ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଇୟ୍‌ଲେ ଲାବନେ । ");
INSERT INTO juy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ତିଅନ୍ତମ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ବାଗୁ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଞାଙେନ୍‌, ଆନିନ୍‌ ଆରି ବାଗୁ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଇୟ୍‌ଲେ ଲାବନେ । ");
INSERT INTO juy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ବମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଞାଙେନ୍‌, ଆନିନ୍‌ ଜିରେନ୍‌ କି ଲବଲୋଙନ୍‌ ଅବୟ୍‌ ଲୋଓଙନ୍‌ ଗାୟ୍‌ଲେ ଆ ସାଉକାରନ୍‌ ଆ ଡାବ୍ବୋ ତିଲ୍ଲୋଙ୍‌ ତିଲ୍ଲେ ସଲେ ଇୟ୍‌ଲେ ଡକ୍କୋଏ ।” ");
INSERT INTO juy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ଜବ୍ର ବର୍ସେଙ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସାଉକାରନ୍‌ ୟର୍ରନାୟ୍‌ କି ଆ କମ୍ୱାରିମରଞ୍ଜି ସରିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଇସାବଡିଁୟ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ଅଙ୍ଗା ମନ୍‌ରା ମନ୍‌ଲୟ୍‌ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଞାଙେନ୍‌, ଆନିନ୍‌ ତି ବୟନ୍‌ ଆରି ମନ୍‌ଲୟ୍‌ ମାଡ଼ିୟ୍‌ ଗୋଗୋୟ୍‌ ରୁପାଡାବନ୍‌ ପାଙ୍‌ଲାୟ୍‌ କି ଆ ସାଉକାରନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେ, ‘ଏ ସାଉକାର, ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ମନ୍‌ଲୟ୍‌ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ଗିଜା, ଞେନ୍‌ ଆରି ମନ୍‌ଲୟ୍‌ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଲାବଲନାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ଆ ସାଉକାରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ମନଙ୍‌ଡମ୍‌, ଆମନ୍‌ ଗୁନଡମ୍‌ ଆରି ଡର୍ନେଡମ୍‌ ଆ କମ୍ବାରିମର୍‌, ଆମନ୍‌ ଅସୋୟ୍‌ଲୋଙନ୍‌ ଡର୍ନେଡମ୍‌ ଞଣ୍ଡ୍ରମ୍‌ଲନେ, ତିଆସନ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଗୋଗୋୟ୍‌ଲୋଙନ୍‌ ତବ୍‌ନଙ୍‌ତମ୍‌, ୟାଆ, ସାଉକାରନମ୍‌ ବୟନ୍‌ ସର୍ଡାନା ।’” ");
INSERT INTO juy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ଆରି ଅଙ୍ଗା ମନ୍‌ରା ବାଗୁ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଞାଙେନ୍‌, ଆନିନ୍‌ ନିୟ୍‌ ଜିର୍ରାୟ୍‌ କି ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ, ‘ଏ ସାଉକାର ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବାଗୁ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ଗିଜା, ଞେନ୍‌ ଆରି ବାଗୁ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଲାବଲନାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ଆ ସାଉକାରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ମନଙ୍‌ଡମ୍‌, ଆମନ୍‌ ଗୁନଡମ୍‌ ଆରି ଡର୍ନେଡମ୍‌ ଆ କମ୍ବାରିମର୍‌, ଆମନ୍‌ ଅସୋୟ୍‌ଲୋଙନ୍‌ ଡର୍ନେଡମ୍‌ ଞଣ୍ଡ୍ରମ୍‌ଲନେ, ତିଆସନ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଗୋଗୋୟ୍‌ଲୋଙନ୍‌ ତବ୍‌ନଙ୍‌ତମ୍‌, ୟାଆ, ସାଉକାରନମ୍‌ ବୟନ୍‌ ସର୍ଡାନା ।’” ");
INSERT INTO juy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“ଆରି ଅଙ୍ଗା ମନ୍‌ରା ବମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଞାଙେନ୍‌, ଆନିନ୍‌ ନିୟ୍‌ ଜିର୍ରାୟ୍‌ କି ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ, ‘ଏ ସାଉକାର, ଆମନ୍‌ ଅବୟ୍‌ ରଡୋମର୍‌, ଅଙ୍ଗାଲୋଙ୍‌ ଆମନ୍‌ ଅଃବ୍ବୁଡେ, ତେତ୍ତେଆତେ ଗଡ୍‌ତେ, ଆରି ଅଙ୍ଗାଲୋଙ୍‌ ଆମନ୍‌ ଜମ୍ମଲନ୍‌ ଅଃବ୍ବୁଡେ, ତେତ୍ତେଆତେ ତର୍ତୁମ୍‌ତେ, କେନ୍‌ଆତେ ଞେନ୍‌ ଜନା । ");
INSERT INTO juy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ତିଆସନ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବତଙ୍‌ଡାଲେ ରୁପାଡାବ୍‌ନମ୍‌ ଲବଲୋଙନ୍‌ ତିଲ୍ଲେ ସଲେ ଇୟ୍‌ଲେ ଡକ୍କୋନାୟ୍‌; କେରେ ଗିଜା ଡାବ୍ବୋନମ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“ଆ ସାଉକାରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, ‘ଏ ପେଲ୍ଲା ଆରି ଆଡ଼ସା କମ୍ବାରିମର୍‌, ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଅଃବ୍ବୁଡାୟ୍‌ ତେତ୍ତେଆତେ ଗଡ୍‌ତାୟ୍‌, ଆରି ଅଙ୍ଗାଲୋଙ୍‌ ଜମ୍ମଲନ୍‌ ଅଃବ୍ବୁଡାୟ୍‌, ତେତ୍ତେଆତେ ତର୍ତୁମ୍‌ତାୟ୍‌, ଗାମ୍‌ଲେ ଆମନ୍‌ ତ ଜନା, ");
INSERT INTO juy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଡାବ୍ବୋଞେନ୍‌ ପାଙ୍‌ଲେ ବାର୍‌ବାର୍‌ଡାବ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ଇନିବା ଅଃନ୍ନେଡକ୍କୋଲୋ, ଞେନ୍‌ ୟର୍ରନ୍‌ ଆଅନ୍‌ଡାବନ୍‌ ବୟନ୍‌ ଡାବ୍ବୋଞେନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଞାଙ୍‌ନାୟ୍‌ ବନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ତିଆସନ୍‌ କେନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଆ ଡାବ୍ବୋ ପାଙ୍‌ଲେ, ଅଙ୍ଗା ମନ୍‌ରା ଆମଙ୍‌ ଦସ ମାଡ଼ିୟ୍‌ ରୁପାଡାବନ୍‌ ଡକୋ, ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ ତିୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଆମଙ୍‌ ଡକୋ, ଆନିନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ, ଆନିନ୍‌ଆତେ ଆରି ଗୋଗୋୟ୍‌ତେ, ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ଆମଙ୍‌ ଅବୟ୍‌ ତଡ୍‌, ଆମଙନ୍‌ ଅଙ୍ଗାତେ ଡକୋ, ତିଆତେ ନିୟ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ପନାଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ଆରି ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଇନ୍ନିଙ୍‌ ବରାଁୟ୍‌ବାଁୟ୍‌ତଡନ୍‌ ଆ କମ୍ୱାରିମର୍‌ଆଡଙ୍‌ ଡୁଆରାନ୍‌ ଆଲୋଙଡ୍‌ରେଙନ୍‌ ଇୟ୍‌ ସେଡ୍‌ବା, ଆନିନ୍‌ ତେତ୍ତେ ୟେୟେଡାନ୍‌ ଡ ରମ୍‌ରମ୍‌ଜିନ୍‌ ଡେଏତୋ ।’” ");
INSERT INTO juy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ଅଙ୍ଗା ଆଡିଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଅଡ଼୍‌କୋ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ସରିନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ଜିର୍ତାୟ୍‌, ତିଆଡିଡ୍‌ ଆନିନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆ ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତଙ୍କୁମେ । ");
INSERT INTO juy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ଆରି ଆ ମୁକ୍କାଗଡନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାଜି ଇୟ୍‌ତାୟ୍‌ ରୁକ୍କୁନେଜି, ତୁର୍‌ମେଡ୍‌ମରନ୍‌ ଏଙ୍ଗାଲେ କିମ୍ମେଡଞ୍ଜି ସିଲଡ୍‌ ମେଣ୍ଡାଞ୍ଜି ବାଡ଼େତେ, ତିଅନ୍ତମ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବାଡ଼େତଜି । ");
INSERT INTO juy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ଆନିନ୍‌ ମେଣ୍ଡାଞ୍ଜି ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଆରି କିମ୍ମେଡଞ୍ଜି ଅର୍କାବଡ଼ିଗଡ୍‌ ଡକ୍କୋତଜି । ");
INSERT INTO juy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ତିଆଡିଡ୍‌ ରାଜାନ୍‌ ଅର୍ଜଡ଼ୋମ୍‌ଗଡନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ବର୍ତଜି, ‘ଜିରାୟ୍‌ବା, ଆପେୟ୍‌ଞେନ୍‌ ଆରାସିର୍ବାଦଲବେନ୍‌ ଆ ମନ୍‌ରାଜି, ପୁର୍ତିନ୍‌ ଆଗ୍ରଡେଲେନ୍‌ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଅଙ୍ଗା ରାଜ୍ୟ ଅନବ୍‌ଜାଡାନ୍‌ ଡେଲୋ, ତି ତେତ୍ତେ ଆୟ୍‌ ଡକୋନାବା । ");
INSERT INTO juy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆଡୋଲେୟ୍‌ ଡକୋଲିଁୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏରୋଜୋମ୍‌ଲିଁୟ୍‌; ଞେନ୍‌ ଇର୍ଗାଲ୍‌ଲିଁୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଗାଡାନେନ୍‌ ଏତିୟ୍‌ଲିଁୟ୍‌; ଞେନ୍‌ ବଡେସାବାୟ୍‌ ଡକୋଲିଁୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଅସିଂବେନ୍‌ ଏଓରୋଙ୍‌ଲିଁୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ଆଉର୍ଡିୟ୍‌ ଡକୋଲିଁୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗିନ୍‌ ଏବ୍‌ଜିଜିଲିଁୟ୍‌; ଅସୁଲିଁୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏସାକ୍କେଲିଁୟ୍‌; ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକୋଲିଁୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ଏଇୟ୍‌ଲାୟ୍‌ କି ଇୟ୍‌ଲାୟ୍‌ ଏସଙ୍କଡ଼େଇଁୟ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ତିଆଡିଡ୍‌ ଡରମ୍ମମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙ୍‌ତଜି, ‘ଏ ପ୍ରବୁ, ଆଙ୍ଗା ଇନ୍‌ଲେଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ଆଡୋଲେୟ୍‌ ଏଗିୟ୍‌ଲମ୍‌ କି ଏରୋଜୋମ୍‌ଲମ୍‌ ? ଅଡ଼େ ଆଙ୍ଗା ଆଇର୍ଗାଲ୍‌ ଏଗିୟ୍‌ଲମ୍‌ କି ଗାଡାନେନ୍‌ ଏତିୟ୍‌ଲମ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ଆରି, ଆଙ୍ଗା ଆମନ୍‌ ବଡେସାବାୟ୍‌ ଡକୋଲମ୍‌ ଡ ଆମନ୍‌ଆଡଙ୍‌ ଏଗିୟ୍‌ଲମ୍‌ କି ଅସିଂଲେନ୍‌ ଏଓରୋଙ୍‌ଲମ୍‌ ? ଅଡ଼େ ଆଙ୍ଗା ଆମନ୍‌ଆଡଙ୍‌ ଆଉର୍ଡିୟ୍‌ ଏଗିୟ୍‌ଲମ୍‌ କି ଅଙ୍ଗିନ୍‌ ଏଅବ୍‌ଜିଜିଲମ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ଆରି ଆଙ୍ଗା ଆମନ୍‌ଆଡଙ୍‌ ଆଅସୁ ଏଗିୟ୍‌ଲମ୍‌ ଅଡ଼େ ଆବଣ୍ଡି ଏଗିୟ୍‌ଲମ୍‌ କି ଅମଙ୍‌ନମ୍‌ ଇୟ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ଏସଙ୍କଡ଼େଅମ୍‌ ?’ ");
INSERT INTO juy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ଆରି ରାଜାନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙ୍‌ତଜି, ‘ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ ବୋଞାଙ୍‌ଞେଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ସନ୍ନାମରନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନିଜି ଏଲୁମେନ୍‌, ତିଆତେ ଞେନ୍‌ ଆସନ୍‌ ଏଲୁମେନ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଅର୍କାବଡ଼ିଗଡନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ନିୟ୍‌ ବର୍ତଜି, ‘ଏ ସନୟ୍‌ପଡାମରଞ୍ଜି, ମୁକ୍କାବାଞେନ୍‌ ସିଲଡ୍‌ ସବ୍‌ଙାୟ୍‌ଡାଲନ୍‌ ସନୁମନ୍‌ ଡ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଆସନ୍‌ ଆତୁବ୍‌ତୁବନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆ ତଗୋସିଂଲୋଙ୍‌ ଜିର୍ବା । ");
INSERT INTO juy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆଡୋଲେୟ୍‌ ଡକୋଲିଁୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଃର୍ରୋଜୋମ୍‌ଲିଁୟ୍‌; ଆଇର୍ଗାଲ୍‌ ଡକୋଲିଁୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଗାଡାନେନ୍‌ ଏଃତ୍ତିୟ୍‌ଲିଁୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ଡକୋଲନାୟ୍‌, ଞେନ୍‌ଆଡଙ୍‌ ଡରକୋନେନ୍‌ ଏଃତ୍ତିୟ୍‌ଲିଁୟ୍‌; ଆଉର୍ଡିୟ୍‌ ଡକୋଲିଁୟ୍‌, ଞେନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗିନ୍‌ ଏଃନ୍ନବ୍‌ରଲିଁୟ୍‌; ଅସୁଲିଁୟ୍‌ ଆରି ଆବଣ୍ଡି ଡକୋଲିଁୟ୍‌, ଞେନ୍‌ଆଡଙ୍‌ ଏଃସାକ୍କେଲିଁୟ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“ସିଲତ୍ତେ ଆନିଞ୍ଜି ରାଜାନ୍‌ଆଡଙ୍‌ ଜାଲଙ୍‌ତଜି, ‘ଏ ପ୍ରବୁ, ଆଙ୍ଗା ଇନ୍‌ଲେଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ଆଡୋଲେୟ୍‌ ଅଡ଼େ ଆଇର୍ଗାଲ୍‌, ବୁଲ୍ଲେ ବୁଲ୍ଲେଏନ୍‌ ଅଡ଼େ ଆଉର୍ଡିୟ୍‌, ଆଅସୁ ଅଡ଼େ ଆବଣ୍ଡି ଗିୟ୍‌ଲେ ଆମନ୍‌ଆଡଙ୍‌ ଏଃସାକ୍କେଲମ୍‌ ?’ ");
INSERT INTO juy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ସିଲତ୍ତେ ରାଜାନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙ୍‌ତଜି, ‘ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ ସନ୍ନାମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଆସନ୍‌ ଓୟ୍‌ଲେ କେନ୍‌ଆତେଜି ଆମ୍ୱେଞ୍ଜି ଏଃଲ୍ଲୁମ୍‌ଲୋ, ତିଆସନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ନିୟ୍‌ ତିଆତେ ଏଃଲ୍ଲୁମ୍‌ଲୋ ।’ ");
INSERT INTO juy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ଆରି, ଆନିଞ୍ଜି ଅଃନ୍ନଞିଡେନ୍‌ ଆ ପନବ୍‌ରଡ୍‌ ଞାଙ୍‌ତଜି, ବନ୍‌ଡ ଡରମ୍ମମରଞ୍ଜି ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞାଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ଜିସୁନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଅବ୍‌ସୁଜ୍ଜେଏନ୍‌ କି ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆସନ୍‌ ଆରି ବାଗୁ ଡିନ୍ନା ଡକୋ, କେନ୍‌ଆତେ ଆମ୍ୱେଞ୍ଜି ଜନା, ଆରି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ସୋରୋପ୍ପାୟ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ତିଆଡିଡ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ମନ୍‌ରାଞ୍ଜି ଆ ପାପୁର୍‌ମର୍‌ଜି କାୟାପା ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ ଡୁଆରାଲୋଙ୍‌ ଇୟ୍‌ଲେ ରୁକ୍କୁନେଜି, ");
INSERT INTO juy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ବାଁୟ୍‌ସିଡାଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ବନ୍‌ଡ ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ପୁର୍ପୁରିଙନ୍‌ ଇନ୍‌ଲେନ୍‌ କେନ୍‌ଆତେ ଅଃଲ୍ଲୁମ୍‌ବୋ, ଅସମୟ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଗୋଡ଼େନ୍‌ ଡୁଙ୍‌ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ଜିସୁନ୍‌ ବେତନିଆନ୍‌ ମୋଡ୍ଡୋ ସିମନନ୍‌ ଆସିଂ ଆଡ୍ରକୋଏନ୍‌ ଆଡିଡ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ଅବୟ୍‌ ଆଇମରନ୍‌ ଅବୟ୍‌ କୋମ୍ପାଲୋଙନ୍‌ ମଡ଼ଗାଡମ୍‌ଆତେ ଲଙିଡ୍‌ ମିଞଲନ୍‌ ପାଙ୍‌ଲେ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ କି, ଆନିନ୍‌ ଆଗ୍ରାଗାଲନ୍‌ ଆଡିଡ୍‌ ତି ଆ ମିଞଲ୍‌ ଆବବ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଲାଏ । ");
INSERT INTO juy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ଆରି ଞଙ୍‌ନେମରଞ୍ଜି କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ଅଃଲ୍ଲଡୟ୍‌ଲଜି କି ବର୍ରଞ୍ଜି, “ଇନିବା କେନ୍‌ ଆ ମିଞଲ୍‌ ଅବ୍‌ମୋସ୍ସାତେ ? ");
INSERT INTO juy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","କେନ୍‌ଆତେ ଗୋଗୋୟ୍‌ ତଙ୍କା ବାତ୍ତେ ତମ୍‌ଲୋଙ୍‌ ତମ୍‌ଲେ ତି ଆ ତଙ୍କା ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ତବୋ ବନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ଜିସୁନ୍‌ କେନ୍‌ଆତେ ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନିବା ତି ଆଇମରନ୍‌ଆଡଙ୍‌ ବାଉଲ୍ଲି ଏଏମ୍ମେତେ ? ଆନିନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ଡୋଲେୟ୍‌ମରଞ୍ଜି ଡିତାନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଡକୋତଞ୍ଜି, ବନ୍‌ଡ ଞେନ୍‌ ଡିତାନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଅଃଡ୍ଡକୋନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ତରିଲ୍‌ନେଞେନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ କେନ୍‌ ଲଙିଡ୍‌ ମିଞଲନ୍‌ ଡଅଙ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଲାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ସମ୍ପରା ପୁର୍ତିଲୋଙନ୍‌ ଅଙ୍ଗା ଅଙ୍ଗାଲୋଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙନ୍‌ ଡେତେ, କେନ୍‌ ଆଇମରନ୍‌ଆଡଙ୍‌ ମନନ୍ନେନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଆ ବର୍ନେ ନିୟ୍‌ ତେତ୍ତେ ବନରନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ତିଆଡିଡ୍‌ ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଆମଙ୍‌ ଇୟେନ୍‌, ଆଞୁମନ୍‌ ଇସ୍କାରିତ ଜିଉଦା । ");
INSERT INTO juy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ଆନିନ୍‌ ରାଓଡ଼ାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, “ଆମ୍ୱେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଇନି ଏତିୟ୍‌ତିଁୟ୍‌ ବର୍ନାବା, ଞେନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅସିଲୋଙ୍‌ବେନ୍‌ ସୋରୋପ୍ପାୟ୍‌ତବେନ୍‌ ।” ସିଲତ୍ତେ ରାଓଡ଼ାଞ୍ଜି ତିରିସିଟା ରୁପାଡାବନ୍‌ ତୁଡ଼େଡାଲେ ଜିଉଦାନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ଆରି ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିଉଦାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ରାଓଡ଼ାଞ୍ଜି ଆସିଲୋଙ୍‌ ସନୋରୋପ୍ପାୟନ୍‌ ଆସନ୍‌ ରୟଙନ୍‌ ସାୟ୍‌ଲେ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","କମିରନ୍‌ ଏର୍‌ମନାୟନ୍‌ ଆ ରୁଟି ଆଜ୍ରୋମ୍‌ତେଞ୍ଜି ଆ ପୁର୍ପୁରିଙ୍‌ ପର୍ତମ୍ମୁ ଡିନ୍ନା ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଇନ୍‌ଲେଞ୍ଜି ଅଙ୍ଗାଲୋଙ୍‌ ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆଗ୍ରାଗାନେ ଆମନ୍‌ ଆସନ୍‌ ଏଅବ୍‌ଜାଡାନାୟ୍‌ ଗାମ୍‌ଲେ ଆମନ୍‌ ଲଡୟ୍‌ତମ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଗଡ଼ାନ୍‌ ଜିର୍ରେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ ବର୍ବା, ‘ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ ଗାମ୍‌ତେ, ଡିନ୍ନାଞେନ୍‌ ତୁୟାଲାୟ୍‌, ଞେନ୍‌ ଞଙ୍‌ନେମର୍‌ଞେଞ୍ଜି ସରିନ୍‌ ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆଗ୍ରାଗାନେ ଅସିଂନମ୍‌ ପାଡ଼େତନାୟ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଏଙ୍ଗାଲେ ବାଞେଞ୍ଜି ଏତ୍ତେଲେ ଆନିଞ୍ଜି ଲୁମ୍‌ଲେ ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆଗ୍ରାଗାନେ ଆସନ୍‌ ଇୟ୍‌ଲେ ଅବ୍‌ଜାଡାଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ତିକ୍କି ଆର୍ରୁବେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ଗାଗାନେନ୍‌ ତଙ୍କୁମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ଆନିଞ୍ଜି ଆଗ୍ରାଗାଲଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଞେନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଞଙ୍‌ନେମରଞ୍ଜି ମାଡ୍ଡ ଡୁକ୍କଡାଲନ୍‌ ତଙ୍‌ବୟ୍‌ନେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ପ୍ରବୁ ତିଆତେ ଞେନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଅଙ୍ଗା ମନ୍‌ରା ଞେନ୍‌ ସରିନ୍‌ ଗିନାଲୋଙନ୍‌ ଜୋବ୍‌ଡାସିଲନ୍‌, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ସାସ୍ତ୍ରଲୋଙନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ବର୍ନେ ଏଙ୍ଗାଲେ ଆଇଡିଡ୍‌, ଏତ୍ତେଲେମା ଆନିନ୍‌ ରବୁତେ; ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତେ, ୟୋଙ୍‌, ତି ଆ ମନ୍‌ରା ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ; ତି ଆ ମନ୍‌ରା କରୋକ୍କୋଡନ୍‌ ଅଃଡ୍ଡେଲୋ ନଙ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ମନଙ୍‌ ଡେତେ ବନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ସିଲତ୍ତେ ଅଙ୍ଗା ଜିଉଦା ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌, ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ତିଆତେ ଞେନ୍‌ ପଙ୍‌ ?” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ତିଆତେ ଆମନ୍‌ ବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ଆନିଞ୍ଜି ଆଗ୍ରାଗାଲଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ରୁଟିନ୍‌ ଞମ୍‌ଲେ ଆସିର୍ବାଦଏନ୍‌ କି ତିଆତେ ରେବ୍‌ଲେ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ଲେ ବର୍ରନେ, “ନବା, ଜୋମ୍‌ବା, କେନ୍‌ଆତେ ଡଅଙ୍‌ଞେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନିନ୍‌ ଗିନାନ୍‌ ଞମ୍‌ଲେ ସନେନ୍‌ସେନନ୍‌ ତିୟେନ୍‌ କି ତିଆତେ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ଲେ ବର୍ରନେ, “ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ କେନ୍‌ତେନ୍ନେ ସିଲଡ୍‌ ଗାବା, ");
INSERT INTO juy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","କେନ୍‌ଆତେ ମିଞାମ୍‌ଞେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆତେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ଇର୍ସେ କେମାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆଜ୍ରତଡେନ୍‌ ରଙ୍‌ ଅନଗଡନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ଡିନ୍ନା ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ରଙ୍‌ ଦ୍ରାକ୍ୟାଜନ୍‌ ଆଡା ଗାତାୟ୍‌, ତି ଆ ଡିନ୍ନା ଜାୟ୍‌ ଲଙେ ସିଲଡ୍‌ ଆରି କେନ୍‌ଆତେ ଞେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଅଃଗାଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି କନନ୍‌ଲଞ୍ଜି କି ଜିତବୁରନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଲଙେ ଆ ତଗଲ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙାୟ୍‌ଲେ ଏଜିର୍‌ତିଁୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ‘ଞେନ୍‌ ତୁର୍‌ମେଡ୍‌ମରନ୍‌ଆଡଙ୍‌ ତିଡ୍‌ତାୟ୍‌, ଆରି ଗୋସ୍ସାମେଡନ୍‌ ତରଙ୍‌ଆନ୍ନା ଡେଆୟ୍‌ତଜି ।’ ");
INSERT INTO juy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ବନ୍‌ଡ ଞେନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋଲନାୟ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆମ୍ୱେଞ୍ଜି ସିଲଡ୍‌ ଆମ୍ମୁଙ୍‌ ଞେନ୍‌ ଗାଲିଲିନ୍‌ ଜିର୍ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅଡ଼୍‌କୋଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ଜିର୍ରମ୍‌ଜି ଜନଙ୍‌ଡେନ୍‌, ଞେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନମ୍‌ରେଙମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ଜିସୁନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତମ୍‌, ଲଙେ ଆ ତଗଲ୍‌ କମ୍‌ସିମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଓଲେନ୍‌ ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ୟାଗି ତର ମୁର୍ସେତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ଆମନ୍‌ ସରିନ୍‌ ରବୁଲିଁୟ୍‌ ଜନଙ୍‌ଡେନ୍‌, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମୁର୍ସେଅମ୍‌ ।” ଅଡ଼୍‌କୋ ଞଙ୍‌ନେମରଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେମା ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଗେସମନି ଗାମ୍‌ଲେ ଅବୟ୍‌ କୋତ୍ତାନ୍‌ ଜିରେଞ୍ଜି, ତେତ୍ତେ ଆନିନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, “ଞେନ୍‌ ତେତ୍ତେ ଜିର୍ରେ ଇୟ୍‌ତେ ପାର୍ତନାନାୟ୍‌, ଞେନ୍‌ ପାର୍ତନାନେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ସାଡାଞନ୍‌ ଜାୟ୍‌ ଆମ୍ୱେଞ୍ଜି ତେନ୍ନେ ତଙ୍କୁମ୍‌ଲେ ଡକୋନାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ଆରି, ଆନିନ୍‌ ପିତ୍ରନ୍‌ ଡ ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ବାଗୁଞ୍ଜିଆଡଙ୍‌ ସରିନ୍‌ ଓରୋଙେଞ୍ଜି, ଆରି ଆନିନ୍‌ ତେତ୍ତେ ଅନିଃୟମନ୍‌ ବାଉଲ୍ଲି ଇୟ୍‌ଲେ ଡେଏ । ");
INSERT INTO juy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଉଗର୍‌ଞେନ୍‌ ଆର୍ରବୁତେନ୍‌ ଅନ୍ତମ୍‌ ମାଡ୍ଡ ଡୁକ୍କତନେ, ଆମ୍ୱେଞ୍ଜି କେନ୍‌ତେନ୍ନେ ଡକୋଡାଲନ୍‌ ଞେନ୍‌ ସରିନ୍‌ ମବ୍‌ଡ଼େଲନ୍‌ ଡକୋନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ଆରି ଆନିନ୍‌ ଅଡି ଡାସଙାୟ୍‌ ଜିର୍ରେ ଜାୟ୍‌ତାନ୍‌ ବରୁମ୍‌ଡାଲେ ଇୟ୍‌ଲେ ପାର୍ତନାନେ, “ଏ ଆପେୟ୍‌ଞେନ୍‌, ଗଡେଲେନ୍‌ ଡେନ୍‌, କେନ୍‌ ଗିନାନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ସଙାଜେତୋ, ଜନଙ୍‌ଡେନ୍‌ ଇସ୍ସୁମ୍‌ଞେନ୍‌ ତଡ୍‌, ଇସ୍ସୁମ୍‌ନମ୍‌ ଅନ୍ତମ୍‌ ଡେଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ଆରି, ଆନିନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେନ୍‌, ଆନିଞ୍ଜି ଆଡିମଡାୟ୍‌ଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମ୍ୱେଞ୍ଜି ବଗଣ୍ଟା ନିୟ୍‌ ଞେନ୍‌ ସରିନ୍‌ ମବ୍‌ଡ଼େଲନ୍‌ ଡକୋଲନ୍‌ ଏଃର୍ରପ୍ତିଏ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ମନାଲ୍‌ମାଲ୍‌ବାନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଗଲୋଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ତିଆସନ୍‌ ମବ୍‌ଡ଼େଲନ୍‌ ଡକୋଡାଲନ୍‌ ପାର୍ତନାନାବା; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପୁରାଡ଼ାନ୍‌ ଲଡୟ୍‌, ବନ୍‌ଡ ଡଅଙନ୍‌ ବପ୍ପୁ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ଆନିନ୍‌ ଆରି ବାଗୁତର ଇଙନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲେ ପାର୍ତନାନେ, “ଏ ଆପେୟ୍‌ଞେନ୍‌, କେନ୍‌ ଗିନାଲୋଙନ୍‌ ଞେନ୍‌ ଅଃଗାଲାୟ୍‌ଡେନ୍‌, କେନ୍‌ ଗିନାନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ରପ୍ତି ଅଃସଙାଜେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇସ୍ସୁମ୍‌ନମ୍‌ ଅନ୍ତମ୍‌ ଡେଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ଆନିନ୍‌ ଆରି ୟର୍ରନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେନ୍‌, ଞଙ୍‌ନେମରଞ୍ଜି ଆଡିମଡାୟ୍‌ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ସାବ୍‌କୁଡ୍‌ମଡ୍‌ଲନ୍‌ ଡକୋଲନ୍‌ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ଜିରେଞ୍ଜି କି ଆରି ଏତ୍ତେଲେମା ବର୍ରନ୍‌ ୟାଗି ତର ଇଙନ୍‌ ଇୟ୍‌ଲେ ପାର୍ତନାନେ । ");
INSERT INTO juy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ତିକ୍କି ଆନିନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଆମ୍ୱେଞ୍ଜି ନମିନ୍ତାନ୍‌ ଲୁଡ୍‌ଲେ ଏଲୋଲୋତନ୍‌ ପଙ୍‌ ? ଗିୟ୍‌ବା ! ତି ଆ ବେଡ଼ା ଅଡ଼ୋଲାୟ୍‌ନି, ଆରି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଇର୍ସେମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ଡୋନାବା, ଏଜିର୍ବା, ଗିୟ୍‌ବା ! ଅଙ୍ଗା ମନ୍‌ରା ଞେନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତିଁୟ୍‌, ଆନିନ୍‌ ତୁୟାଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ଜିସୁନ୍‌ ଏନ୍ନେଲେ ଆବର୍ରନେନ୍‌ ଆଡିଡ୍‌, ଗିୟ୍‌ବା ! ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଜିଉଦା ଗାମ୍‌ଲେ ଅବୟ୍‌ ଞଙ୍‌ନେମରନ୍‌ ଆରି ଆନିନ୍‌ ସରିନ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି କଡ଼ିବନ୍‌ ଡ ତେଙ୍ଗାନ୍‌ ଞମ୍‌ଲେ ଇୟ୍‌ଲାଜି । କେନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ମନ୍‌ରାଞ୍ଜି ଆ ପାପୁର୍‌ମର୍‌ଜି ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସନୋରୋପ୍ପାୟ୍‌ମରନ୍‌, ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଅବୟ୍‌ ଅରମ୍ମଡନ୍‌ ତିୟ୍‌ଲେ ବରେଞ୍ଜି, “ଞେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଜୋର୍ଜୋର୍‌ତାୟ୍‌, ତିଆତେ ଆନିନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ଆରି ତେରଙ୍‌ ଜିଉଦାନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଲୋମ୍‌ତମ୍‌,” ଗାମେନ୍‌ କି ଇୟ୍‌ଲାୟ୍‌ ଜୋର୍ଜୋରେ । ");
INSERT INTO juy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ଆରି ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଗଡ଼ି ଆମନ୍‌ ଅଙ୍ଗାତେ ଲୁମ୍‌ଲୁମନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ତିଆତେ ଲୁମା ।” ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରାଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଞମେଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ଆରି ଗିୟ୍‌ବା ! ଜିସୁନ୍‌ ସରିନ୍‌ ତେତ୍ତେ ଆଡ୍ରକୋଏଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ, ଆ କଡ଼ିବନ୍‌ ତବେନ୍‌ କି ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ କମ୍ୱାରିମର୍‌ ଆଲୁଡ୍‌ ଗଡ୍‌ଲେ ସେଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କଡ଼ିବ୍‌ନମ୍‌ ଆଡ୍ରକ୍କୋଲୋଙନ୍‌ ଡକ୍କୋଆ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନାଜି କଡ଼ିବନ୍‌ ଅବିଡ୍‌ତଞ୍ଜି, ଆନିଞ୍ଜି କଡ଼ିବନ୍‌ ବାତ୍ତେ ସେଏଡ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ଅଡ଼େ ଆମନ୍‌ ଇନି ଅବ୍‌ଡିସୟ୍‌ତେ, ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ଆଡଙ୍‌ ବର୍ରେ ଅଃର୍ରପ୍ତିଆୟ୍‌ ପଙ୍‌ ? ଆରି ଆନିନ୍‌ ନମିଞେନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ବାର କନୁଡ଼ାୟ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନାପ୍ପାୟାଜି ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଡେଡମ୍‌ତେ ଗାମ୍‌ଲେ ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଆ ବର୍ନେଜି ଏଙ୍ଗାଲେ ଡେଡମେ ?” ");
INSERT INTO juy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଅବୟ୍‌ ରାଉମର୍‌ ପଙ୍‌ ଡ, ଆମ୍ୱେଞ୍ଜି କଡ଼ିବନ୍‌, ତେଙ୍ଗାନ୍‌ ପାଙ୍‌ଲେ ଞେନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଏଇୟ୍‌ଲାୟ୍‌ ? ଞେନ୍‌ ଡିତାନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଲେ ଞନଙନ୍‌ ତିୟ୍‌ତିୟ୍‌ଲଲାୟ୍‌, ବନ୍‌ଡ ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଃଞମ୍‌ଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଇନିଜି ଇନିଜି ଇଡେଞ୍ଜି, ତିଆତେଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡେଡମେ, ତିଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଏନ୍ନେଗୋ ଡେଏନ୍‌ ।” ତିଆଡିଡ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଇରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ଆରି ଅଙ୍ଗା ମନ୍‌ରାଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମେଞ୍ଜି, ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ କାୟାପା ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆମଙ୍‌ ଓରୋଙେଞ୍ଜି; ତେତ୍ତେ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାପୁର୍‌ମରଞ୍ଜି ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ପିତ୍ରନ୍‌ ଡାସଙାୟ୍‌ ଡକୋଡାଲନ୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ ଡୁଆରା ଜାୟ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଇନିଜି ଡେତେ, ତିଆତେଜି ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଅମ୍ମନ୍‌ ଜିର୍ରେ ତଙିୟ୍‌ସିପ୍ପାୟଞ୍ଜି ସରିନ୍‌ ଇୟ୍‌ଲେ ତଙ୍କୁମେ । ");
INSERT INTO juy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ତିଆଡିଡ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସୋବାଲୋଙନ୍‌ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ କଣ୍ଡାୟ୍‌ ସାକିନ୍‌ ସାଜେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ଆରି ଗୋଗୋୟ୍‌ଡମ୍‌ କଣ୍ଡାୟ୍‌ ସାକିନ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌ ଜନଙ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଇନ୍ନିଙ୍‌ ଡୋସାନ୍‌ ଅଃଞାଙ୍‌ଲଜି । ବନ୍‌ଡ ଆତନିକ୍କି ବାଗୁ ମନ୍‌ରା ଏନ୍ନେଲେ ସାକିନ୍‌ ତିୟେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“କେନ୍‌ ଆ ମନ୍‌ରା ଏନ୍ନେଲେ ବର୍ରନେ, ‘ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ସରେବାସିଂ ପୁଡ୍‌ଲେ, ତିଆତେ ଞେନ୍‌ ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ଗୁଲେ ରପ୍ତିତାୟ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ସିଲତ୍ତେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ତନଙେନ୍‌ କି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କେନ୍‌ ଏନ୍ନେଲେ ବିରୁଦଲୋଙ୍‌ନମ୍‌ ସାକିନ୍‌ ଆତ୍ରିୟ୍‌ତେଞ୍ଜି ଆମନ୍‌ ଇନ୍ନିଙ୍‌ ଜାଲଙ୍‌ତନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ବନ୍‌ଡ ଜିସୁନ୍‌ କଡ଼ିଙ୍‌ଲେ ସେଡେନ୍‌ । ସିଲତ୍ତେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଆମେଙ୍‌ ଇସ୍ୱରନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଅବ୍‌ପର୍ମାଡ଼ାଲେ ବର୍ତମ୍‌, ଆମନ୍‌ ପଙ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ କ୍ରିସ୍ଟନ୍‌ ? ଅମଙ୍‌ଲେନ୍‌ ବର୍ନା ।” ");
INSERT INTO juy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ଜିସୁନ୍‌ ରାଓଡ଼ାନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆମନ୍‌ ବର୍ରନେ, ଞେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଆରି ନିୟ୍‌ ବର୍ତବେନ୍‌, ନମିଞେନ୍‌ ସିଲଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ବୋର୍ସାନ୍‌ ଆର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଆତ୍ରଙ୍କୁମ୍‌ତେନ୍‌ ଆରି ରୁଆଙନ୍‌ ଆ ମେଗଲୋଙ୍‌ ଆଜିର୍ତାଞନ୍‌ଆତେ ଆମ୍ୱେଞ୍ଜି ଏଗିୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ସିଲତ୍ତେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ ଅଙ୍ଗିଡମନ୍‌ ପେଲେ ବର୍ରନେ, “କେନ୍‌ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟେନ୍‌, ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ଇନିବା ଆରି ସାକିନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ? ଗିୟ୍‌ବା ! ଆମ୍ୱେଞ୍ଜି ନମିଞେନ୍‌ ନିୟ୍‌ ଇସ୍ୱରନ୍‌ ଆ ନିଣ୍ଡୟ୍‌ବର୍‌ ଏଅମ୍‌ଡଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ଆମ୍ୱେଞ୍ଜି ଇନି ଏଗାମ୍‌ତେ ?” ଆନିଞ୍ଜି ଜାଲଙେଞ୍ଜି, “ଆନିନ୍‌ ଅବୟ୍‌ ଡୋସାମର୍‌, ଆନିନ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ତିଆଡିଡ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ମୁକ୍କାଲୋଙ୍‌ ବିଜଲେଞ୍ଜି କି କୁମ୍‌କୁମ୍‌ସିଲନ୍‌ ତିଡେଞ୍ଜି; ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଜିସୁନ୍‌ ଆ କୋତାୟ୍‌ତମ୍‌ଲୋଙ୍‌ ତାଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ଆରି ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, “ଏ କ୍ରିସ୍ଟ, ଆମନ୍‌ ଅଡ୍ଡେନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌, ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ବର୍ରେନ୍‌ ଲା, ଆନା ଆମନ୍‌ଆଡଙ୍‌ ତିଡ୍‌ଲମ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ତିଆଡିଡ୍‌ ପିତ୍ରନ୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ ଡୁଆରାଲୋଙ୍‌ ତଙ୍କୁମ୍‌ଲେ ଡକୋଲନ୍‌, ଆରି ଅବୟ୍‌ କମ୍ୱାରିବଜନ୍‌ ପିତ୍ରନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଗାଲିଲିବାୟ୍‌ ଜିସୁନ୍‌ ସରିନ୍‌ ଆମନ୍‌ ନିୟ୍‌ ଡକୋଲମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ମୁର୍ସେଡାଲେ ବର୍ରନେ, “ଆମନ୍‌ ଇନି ଗାମ୍‌ତେ, ତିଆତେ ଞେନ୍‌ ଅଃଗନ୍‌ଲୁଡିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ପିତ୍ରନ୍‌ ଗରନ୍ନେଲୋଙନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେନ୍‌, ଆରି ଅବୟ୍‌ କମ୍ୱାରିବଜନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ, ତେତ୍ତେ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ନାଜରିତବାୟ୍‌ ଜିସୁନ୍‌ ସରିନ୍‌ ଡକୋଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ମୋରାନ୍ନାଲନ୍‌ ଆରି ବତର ମୁର୍ସେଡାଲେ ବର୍ରନେ, “ଞେନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଜନା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ଗଡ୍ଡେଃ ଡକୋଡାଲନ୍‌ ତେତ୍ତେ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ପିତ୍ରନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଆଜାଡ଼ିଡମ୍‌ ଆମନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କଡାଡ଼ିନମ୍‌ ବାତ୍ତେ ତିଆତେ ଜନାଲଙ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ସୟ୍‌ପଡାଲେ ମୋରାନ୍ନାଲନ୍‌ ବର୍ରନେ, “ଞେନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଜନା ତଡ୍‌ ।” ସିଲତ୍ତେ ତେରଙ୍‌ କମ୍‌ସିମନ୍‌ ଓଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ଜିସୁନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଅବୟ୍‌ ବର୍ନେନ୍‌ ବରେନ୍‌, “କମ୍‌ସିମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଓଲେନ୍‌ ଆମନ୍‌ ୟାଗିତଙର୍‌ ଞେନ୍‌ଆଡଙ୍‌ ମୁର୍ସେତିଁୟ୍‌,” କେନ୍‌ ଆ ବର୍ନେ ପିତ୍ରନ୍‌ ମନ୍ନେଏନ୍‌, ତିଆସନ୍‌ ଆନିନ୍‌ ଡାଣ୍ଡନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ କି ଆକ୍ରାନ୍‌ ଇୟ୍‌ଲେ ୟେୟେଡାନେ । ");
INSERT INTO juy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ଅଡ଼୍‌କୋ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ମନ୍‌ରାଞ୍ଜି ଆ ପାପୁର୍‌ମର୍‌ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ ତନ୍ତ୍ରଏଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସିଙ୍କୁଡ଼ିନ୍‌ ବାତ୍ତେ ଜିଲେ ପିଲାତ ରାଜ୍ୟପାଡ଼ନ୍‌ ଆମଙ୍‌ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ଆଞ୍ରାଙେନ୍‌ଆତେ ଗିୟ୍‌ଲେ, ଆନିନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ଆସ୍ରୋରୋପ୍ପାୟେନ୍‌ ଆ ମନ୍‌ରା ଜିଉଦାନ୍‌ ଡୁକ୍କଡାଏନ୍‌ କି ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ପାପୁର୍‌ମରଞ୍ଜି ଆମଙ୍‌ ତି ତିରିସିଟା ରୁପାଡାବନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଆବ୍‌ଡିଡେ । ");
INSERT INTO juy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ଆନିନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଡୋସାତଡନ୍‌ ଆ ମନ୍‌ରା ସୋରୋପ୍ପାୟ୍‌ଡାଲେ ଇର୍ସେନ୍‌ ଲୁମ୍‌ଲାୟ୍‌ !” ବନ୍‌ଡ ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଇନ୍‌ଲେନ୍‌ ତେତ୍ତେ ଇନି ଅଡ଼ୋଲେନ୍‌ ? ତିଆତେ ଆମନ୍‌ ଗିଜା !” ");
INSERT INTO juy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ସିଲତ୍ତେ ଜିଉଦାନ୍‌ ରୁପାଡାବଞ୍ଜି ଅମ୍ମ ସରେବାସିଙନ୍‌ ସେଡ୍‌ଲେ ଜିରେନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଇୟ୍‌ଲେ ତୋଡ଼ୋନ୍ନେ । ");
INSERT INTO juy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ବନ୍‌ଡ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ତି ରୁପାଡାବଞ୍ଜି ଞିଡାଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ଆତେ ମିଞାମ୍‌ଡାବ୍‌, ତିଆସନ୍‌ କେନ୍‌ଆତେ ତନିୟ୍‌ତିୟ୍‌ ପିଡ଼ିଲୋଙନ୍‌ ଡକ୍କୋଲବୋ ଡେନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଅନାଲ୍ଲେଡାତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","କେନ୍‌ ଆ ଡାବ୍ବୋ ଏଙ୍ଗାଲେ କର୍ସବୋ ଗାମ୍‌ଲେ କଡାଡ଼ିଡାଲନ୍‌, ଆନିଞ୍ଜି ବଡେସାମରଞ୍ଜି ଆତ୍ରିଲ୍‌ନେ ଆସନ୍‌ ତି ଆ ଡାବ୍ବୋ ବାତ୍ତେ କୁମ୍ୱିୟ୍‌ମରନ୍‌ ଆ ବସେଙ୍‌ ଞିଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ତିଆସନ୍‌ ନମିନ୍ତାନ୍‌ ତି ଆ ବସେଙ୍‌ ମିଞାମ୍‌ ବସେଙ୍‌ ଗାମ୍‌ଲେ ବର୍ତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ତିଆସନ୍‌ ଜିରିମିଅ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆବର୍ରନେନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, “ଅଙ୍ଗାତେ ତିରିସି ତଙ୍କା ବାତ୍ତେ ତମ୍‌ତମନ୍‌ ଆସନ୍‌ ଇସ୍ରାଏଲ୍‌ଅନଞ୍ଜି ଅବ୍‌ସିଡ୍ଡାୟେଞ୍ଜି, ଡିୟ୍‌ତେ ମା ଡାବ୍ବୋନ୍‌ ପାଙେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ଆରି ପ୍ରବୁନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଙ୍ଗାଲେ ବାଁୟ୍‌ଲିଁୟ୍‌ ଏତ୍ତେଲେ ଆନିଞ୍ଜି କୁମ୍ୱିୟ୍‌ମରନ୍‌ ଆ ଲବ ଞିଏଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ରୋମିଅ ରାଜ୍ୟପାଡ଼ନ୍‌ ଆ ମୁକ୍କାବା ଇୟ୍‌ଲେ ତବ୍‌ନଙେଞ୍ଜି, ଆରି ରାଜ୍ୟପାଡ଼ନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ପଙ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ରାଜା ?” ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଆମନ୍‌ ବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ଆରି, ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ପାପୁର୍‌ମରଞ୍ଜି ଜିସୁନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଆକ୍ରାୟ୍‌କାୟେଞ୍ଜି, ଆନିନ୍‌ ଇନ୍ନିଙ୍‌ ଅଃଜ୍ଜାଲଙ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ସିଲତ୍ତେ ପିଲାତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆନିଞ୍ଜି ବିରୁଦଲୋଙ୍‌ନମ୍‌ କେନ୍‌ ଡିୟ୍‌ନେ ସାକିନ୍‌ ଆତ୍ରିୟ୍‌ତେଞ୍ଜି, ତିଆତେ ଆମନ୍‌ ଅଃନ୍ନମ୍‌ଡଙେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ବନ୍‌ଡ ଜିସୁନ୍‌ ବପଦ ଓୟ୍‌ଲେ ରାଜ୍ୟପାଡ଼ନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାଲଙ୍‌ଲୋ, ତିଆସନ୍‌ ରାଜ୍ୟପାଡ଼ନ୍‌ ଆକ୍ରାନ୍‌ ସାନ୍ନି ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ଅନେଲାୟ୍‌ପୁରିଙନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ ରାଜ୍ୟପାଡ଼ନ୍‌ ଅବୟ୍‌ ଆବଣ୍ଡିମରନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଆସନ୍‌ ଅନୋକ୍କାନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ତିଆଡିଡ୍‌ ବାରବ୍ବା ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଆବଣ୍ଡି ଡକୋଲନ୍‌ । ଆନିନ୍‌ ଅବୟ୍‌ ପେଲ୍ଲାମର୍‌ ଗାମ୍‌ଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆଜନାଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଞ୍ଜି ଆଡିଡ୍‌ ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଆନାଆଡଙ୍‌ ଅମ୍‌ବୁରାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଲଡୟ୍‌ତବେନ୍‌ ? ବାରବ୍ବାନ୍‌ଆଡଙ୍‌ ଅଡ଼େ, ଅଙ୍ଗା ମନ୍‌ରାଆଡଙ୍‌ କ୍ରିସ୍ଟ ଗାମ୍‌ଲେ ବର୍ତଞ୍ଜି, ତି ଆ ଜିସୁଆଡଙ୍‌ ଅମ୍‌ବୁରାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସାଣ୍ଡଡାଲେ ଆସିଲୋଙନ୍‌ ସୋରୋପ୍ପାୟେଞ୍ଜି ଗାମ୍‌ଲେ ପିଲାତନ୍‌ ଆଜନା । ");
INSERT INTO juy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ଆରି, ପିଲାତନ୍‌ ପନ୍‌ସୁଆତି କୁର୍ସିଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଲେ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌, “ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଏଙ୍ଗାଡଙ୍‌, ଆନିନ୍‌ ଇନ୍ନିଙ୍‌ ଡୋସା ତଡ୍‌, ଆ ବର୍ନେନ୍‌ ରୁବନ୍‌ ଆ ତଗଲ୍‌ ଞେନ୍‌ ଇୟ୍‌ଲେ ଗୁମ୍‌ତେନାୟ୍‌, ତିଆସନ୍‌ ଞେନ୍‌ ମାଡ୍ଡ ସନିନ୍ତାଡାତିଁୟ୍‌,” ଗାମ୍‌ଲେ ପିଲାତନ୍‌ ଆ ଡୁକ୍ରି ପିଲାତନ୍‌ ଆମଙ୍‌ କବରନ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ବନ୍‌ଡ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ପାପୁର୍‌ମରଞ୍ଜି ବାରବ୍ବାନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ବୁରନ୍‌ ଆସନ୍‌, ଆରି ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ବର୍ନାବା ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ସୁସ୍କାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ବନ୍‌ଡ ପିଲାତ ରାଜ୍ୟପାଡ଼ନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ ବାଗୁଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଞେନ୍‌ ଆନାଆଡଙ୍‌ ଅମ୍‌ବୁରାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଲଡୟ୍‌ତବେନ୍‌ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ବାରବ୍ବାନ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ କ୍ରିସ୍ଟ ଆଗ୍ରାମ୍‌ତେଞ୍ଜି ଆ ଜିସୁଆଡଙ୍‌ ଞେନ୍‌ ଇନି ଏଙ୍ଗାଆୟ୍‌ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଆନିନ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ନେତୋ !” ");
INSERT INTO juy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ସିଲତ୍ତେ ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନିବା, ଆନିନ୍‌ ଇନି ଆ ଡୋସା ଲୁମେନ୍‌ ?” ବନ୍‌ଡ ଆନିଞ୍ଜି ଆକ୍ରାନ୍‌ ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ନେତୋ !” ");
INSERT INTO juy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ତିଆଡିଡ୍‌ ପିଲାତନ୍‌ ଗିଜେନ୍‌, ଆନିଞ୍ଜି ଆରି ଇନ୍ନିଙ୍‌ ବର୍ନେନ୍‌ ଅଃତ୍ତିୟେଜି, ଆର୍ପାୟ୍‌ ଗୋଡ଼େନ୍‌ ଗୋଗୋୟ୍‌ଲେ ପାଙ୍‌ତେ, ତିଆସନ୍‌ ଆନିନ୍‌ ଡାଆନ୍‌ ପାଙ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଆସିଡାଲନ୍‌ ବର୍ରନେ, “କେନ୍‌ ଆ ମନ୍‌ରା ଆ ରନବୁ ଆସନ୍‌ ଞେନ୍‌ ଇନ୍ନିଙ୍‌ ଡୋସା ତଡ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଗିୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ସିଲତ୍ତେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଜାଲଙ୍‌ଲଞ୍ଜି, “ଆ ରନବୁନ୍‌ ଆସନ୍‌ ପନବ୍‌ରଡନ୍‌ ଡଅଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ଡ ପସିୟ୍‌ଲେଞ୍ଜି ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଗତର୍‌ଲେନ୍‌ତୋ !” ");
INSERT INTO juy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ସିଲତ୍ତେ ପିଲାତନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ବାରବ୍ବାନ୍‌ଆଡଙ୍‌ ଅମ୍‌ବୁରେନ୍‌, ବନ୍‌ଡ ଜିସୁନ୍‌ଆଡଙ୍‌ ସାମକାନ୍‌ ବାତ୍ତେ ଅବ୍‌ତିତ୍ତିଡ୍‌ଡାଲେ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅନମ୍‌ଡାଜନ୍‌ ଆସନ୍‌ ସିପ୍ପାୟଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ରାଜ୍ୟପାଡ଼ନ୍‌ ଆ ସିପ୍ପାୟ୍‌ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍ମ ରାଜାସିଙନ୍‌ ଓରୋଙ୍‌ଡାଲେ ଅଡ଼୍‌କୋ ସିପ୍ପାୟଞ୍ଜି ଅଲ୍‌ନୋଡ୍ଡେଲେ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ଆରି, ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ଅଙ୍ଗି ଉଜେଞ୍ଜି କି ଲୁଲୁ ଅଙ୍ଗିନ୍‌ ଅବ୍‌ରଏଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ଆରି ଆନିଞ୍ଜି ଅବ୍ବାଙନ୍‌ ବାତ୍ତେ ଅବୟ୍‌ ରନୁବ୍ବବନ୍‌ ତୁବ୍‌ଲେ ଜିସୁନ୍‌ ଆବବ୍‌ଲୋଙ୍‌ ଅବ୍‌ରୁବ୍ବବେଞ୍ଜି, ଆର୍ଜଡ଼ୋମ୍‌ସିଲୋଙନ୍‌ ଅବୟ୍‌ ଡାଙ୍ଗୋନ୍‌ ଅବ୍‌ଡଣ୍ଡନେଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆ ମୁକ୍କାଗଡନ୍‌ ତୁଡ଼ୁମ୍‌ଡାଲେ, “ଏ ଜିଉଦିମରଞ୍ଜି ଆ ରାଜା, ଲୋମ୍‌ତମ୍‌,” ଗାମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସୟ୍‌ସୟ୍‌ମୁଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ଆନିଞ୍ଜି ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ବିଜଲେଞ୍ଜି ଆରି ଆସିଲୋଙନ୍‌ ଆଡଣ୍ଡନନ୍‌ ଆ ଡାଙ୍ଗୋ ପାଙ୍‌ଲେ ଆବବ୍‌ଲୋଙନ୍‌ ତିଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ଆରି ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଆସ୍ରୟ୍‌ସୟ୍‌ମୁଏଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତି ଲୁଲୁ ଅଙ୍ଗିନ୍‌ ଉୟ୍‌ଲେ ଆ ଅଙ୍ଗିଡମନ୍‌ ଅବ୍‌ରଏଞ୍ଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅନମ୍‌ଡାଜନ୍‌ ଆସନ୍‌ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ଆନିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଆଡିଡ୍‌ ସିମନ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ତଙରନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରବାଙେଜି, ଆନିନ୍‌ କୁରିଣି ଗଡ଼ାବାୟ୍‌, ଆରି ସିପ୍ପାୟଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜିସୁନ୍‌ ଆଅକ୍କାଡଙ୍‌ ବଡଗାଁୟ୍‌ ଅବ୍ବୋୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ଆରି, ଆନିଞ୍ଜି ଗଲ୍‌ଗତା ଗାମ୍‌ଲେ ଅବୟ୍‌ ଜାଗାଲୋଙନ୍‌ ଅଡ଼ୋଏଞ୍ଜି, ତି ଆଗ୍ରାମ୍‌ଗାମନ୍‌ “ଆଇଡାଡ଼ାବୁର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ତେତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅସାଙନ୍‌ ଆମାୟ୍‌ମାୟନ୍‌ ଆ ଦ୍ରାକ୍ୟାଡା ତିୟେଞ୍ଜି, ବନ୍‌ଡ ଆନିନ୍‌ ତିଆତେ ମାୟ୍‌ମାଜେନ୍‌ କି ଗାଗାନ୍‌ ଅଃଲ୍ଲଡୟ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି କି ଅବ୍‌କଡ଼ିଡାଲେ ଆ ଅଙ୍ଗିଞ୍ଜି ତର୍ଡମ୍‌ ବନ୍ତାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ଆରି ଆନିଞ୍ଜି ତେତ୍ତେ ତଙ୍କୁମ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜଗେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆବବ୍‌ ଆ ତୋଣ୍ଡୋଗଡ୍‌ ଅବୟ୍‌ କନାୟ୍‌କାୟ୍‌ବରନ୍‌ ଅବୟ୍‌ ପଟାଲୋଙନ୍‌ ଇଡ୍‌ଲେ ୟୋଡେଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ରାଜା ଜିସୁ ।” ");
INSERT INTO juy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ସରିନ୍‌ ବାଗୁ ସକାମରଞ୍ଜି ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି, ଆର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଅବୟ୍‌ନେ ଆରି ଅର୍କାବଡ଼ିଗଡ୍‌ ଅବୟ୍‌ନେ, ଜିସୁନ୍‌ ମଡ୍ଡିନ୍‌ ଏମ୍ମେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ଆରି, ତି ଆ ତଙର୍‌ ଗଡ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆ ମନ୍‌ରାଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ମୋମୋବବ୍‌ଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ଆମନ୍‌ ଅଡ୍ଡେନ୍‌ ସରେବାସିଙନ୍‌ ପୁଡ୍‌ଲେ ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ଆତ୍ରୁବ୍‌ତେନ୍‌ ଆ ମନ୍‌ରା, ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଡେନ୍‌ ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ଡମ୍‌ ଡୋବ୍‌ଡମ୍‌ନା ଆରି ଆଅକ୍କାଡଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଜିରାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେମା ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାପୁର୍‌ମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସୟ୍‌ସୟ୍‌ମୁଲେ ବର୍ରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ଆନିନ୍‌ ଆନ୍ନାମରଞ୍ଜିଆଡଙ୍‌ ଡୋବେନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ଡମ୍‌ ଡୋବ୍‌ଲନ୍‌ ଅଃର୍ରପ୍ତିନେ । ଆନିନ୍‌ ଅଡ୍ଡେନ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆ ରାଜା, ଆନିନ୍‌ ନମିଞେନ୍‌ ଆଅକ୍କାଡଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଜିରାୟ୍‌ତୋ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଆମଙନ୍‌ ଏଡର୍ନେବା । ");
INSERT INTO juy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଗାମ୍‌ଲେ କେନ୍‌ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଆସାତନେ; ଇସ୍ୱରନ୍‌ କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମେନ୍‌ ଡେନ୍‌, ନମିଞେନ୍‌ମା ଇସ୍ୱରନ୍‌ କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଡୋବେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ଆରି, ଅଙ୍ଗା ସକାମର୍‌ଜି ଜିସୁନ୍‌ ବୟନ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି, ଆନିଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେମା ଜିସୁନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତିଆଡିଡ୍‌ ତଡ଼ିଙ୍‌ ତମ୍‌ବାନ୍‌ ସମ୍ପରା ପୁର୍ତିନ୍‌ ଲୋଙଡାଜେନ୍‌ କି ୟାଗି ଗଣ୍ଟା ଜାୟ୍‌ ଆଲୋଙଡନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ଆରି ୟାଗି ଗଣ୍ଟା ଇଙନ୍‌ ଡେତେ ଜିସୁନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବାବ୍ବାବ୍‌ଲେ ବର୍ରନେ, “ଏଲି, ଏଲି, ଲାମା ସବକ୍‌ତାନି ?” କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌, “ଏ ଇସ୍ୱରଞେନ୍‌, ଏ ଇସ୍ୱରଞେନ୍‌, ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଇନିବା ଅମ୍‌ରେଙ୍‌ଲିଁୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ତେତ୍ତେ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “କେନ୍‌ ଆ ମନ୍‌ରା ଏଲିଅନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ଆରି, ସିଲତ୍ତେମା ଅବ୍‌ତାଡ଼ନ୍‌ ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଇରେନ୍‌ କି ଅବୟ୍‌ କପାନ୍‌ ପାଙ୍‌ଲେ ତିଆତେ ସବୁର୍‌ଡାଲୋଙନ୍‌ ଜୋବ୍‌ଡାଡାଲେ ଅବୟ୍‌ ଡାଙ୍ଗୋଲୋଙନ୍‌ ରପଡେନ୍‌ କି ଗାଗାନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ବନ୍‌ଡ ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “କଡ଼ିଙ୍‌ବା, ଏଲିଅନ୍‌ କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ଆସନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଅଡ଼େ ଇଜ୍ଜା, ଏଗିୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆରି ବତର ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବାବ୍ବାବେନ୍‌ କି ଅତଡ୍‌ୟମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ଆରି ଗିୟ୍‌ବା, ଅମ୍ମ ସରେବାସିଙନ୍‌ ଆ ଡରଙ୍‌ନେକାବ୍‌ ତୋଣ୍ଡୋନ୍‌ ସିଲଡ୍‌ ଜାୟ୍‌ତାନ୍‌ ଜାୟ୍‌ ପତେଡାଲେ ବାଗୁ ଡେୟ୍‌ଡେୟ୍‌ ଡେଏନ୍‌, ତକର୍‌ଲନ୍‌ ଡେଏନ୍‌, ଅରେଙଞ୍ଜି ପତଡାଜେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ଆରି ମସାନ୍ନିଞ୍ଜି ରୋଲନେ, ଆର୍ରବୁଏଞ୍ଜି ବୟ୍‌ଲେମର୍‌ଜି ଆ ମରା ଗୋଗୋୟ୍‌ଡମ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋଲଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ଆରି ଜିସୁନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଆଡ୍ରୋଲନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ମସାନ୍ନିନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ମଡ଼ିର୍‌ ଗଡ଼ାନ୍‌ ଜିରୁସାଲମନ୍‌ ଗନେଞ୍ଜି, କେନ୍‌ଆତେ ଜବ୍ର ମନ୍‌ରା ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ ଡ ଆନିନ୍‌ ସରିନ୍‌ ଆନାଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜଗେଏଞ୍ଜି, ଆନିଞ୍ଜି ତକର୍‌ଲନ୍‌ ଆରି ଇନିଜି ଡେଏନ୍‌ ତିଆତେଜି ଗିୟ୍‌ଲେ ଆକ୍ରାନ୍‌ ବତଙେଞ୍ଜି କି ବର୍ରଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ କେନ୍‌ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଆରି, ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଆସ୍ରାଜଏଞ୍ଜି ଆଇମର୍‌ଜି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଡାସଙାୟ୍‌ଲୋଙ୍‌ ଡକୋଡାଲନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଗିୟ୍‌ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ଆନିଞ୍ଜିଲୋଙ୍‌ ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌, ଜାକୁବନ୍‌ ଡ ଜୋସେପନ୍‌ ଆୟୋଙ୍‌ ମରିଅମନ୍‌, ଆରି ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ଆୟୋଙ୍‌ ତେତ୍ତେ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ଅରୁବ୍‌ଲେ ଆପ୍ରାଙେନ୍‌ ଆଡିଡ୍‌ ଜୋସେପ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଗମାଙ୍‌ମରନ୍‌ ତେତ୍ତେ ଇୟ୍‌ଲାୟ୍‌, ଆନିନ୍‌ ଆରାମାତିୟାବାୟ୍‌, ଆନିନ୍‌ ନିୟ୍‌ ଅବୟ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ଆନିନ୍‌ ପିଲାତନ୍‌ ଆମଙ୍‌ ଇୟେନ୍‌ କି ଜିସୁନ୍‌ ଆ ମରା ଇୟ୍‌ଲେ ବେଡେ । ସିଲତ୍ତେ ପିଲାତନ୍‌ ତିଆତେ ଇୟ୍‌ ତିୟ୍‌ବା ଗାମ୍‌ଲେ ସିପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ବାଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ଆରି ଜୋସେପନ୍‌ ଜିସୁନ୍‌ ଆ ମରା ପାଙ୍‌ଲେ ମନଙ୍‌ଡମ୍‌ ଆ ଲମନ୍‌କାବ୍‌ ବାତ୍ତେ ବଲେଡେନ୍‌ କି, ");
INSERT INTO juy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ଆନିନ୍‌ଡମ୍‌ ଆସନ୍‌ ତାଲାଃଜଲେଙ୍‌ଲୋଙନ୍‌ ଆରବ୍‌ଗାୟ୍‌ଗାୟେନ୍‌ ଆ ରଙ୍‌ ମସାନ୍ନିଲୋଙ୍‌, ତିଆତେ ଇୟ୍‌ଲେ ଡକ୍କୋଏ, ଆରି ମସାନ୍ନିନ୍‌ ଆ ଗରନ୍ନେଲୋଙ୍‌ ଅବୟ୍‌ ସୋଡ଼ାଡମ୍‌ ଆରେଙ୍‌ ଡଙ୍‌ଲେ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌ ଡ ଆନ୍ନା ମରିଅମନ୍‌ ତି ତେତ୍ତେ ମସାନ୍ନିନ୍‌ ଆ ମୁକ୍କାବା ତଙ୍କୁମ୍‌ଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ତି ଆବାର୍ତାନ୍‌, ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ପିଲାତନ୍‌ ଆମଙ୍‌ ରୁକ୍କୁଲନ୍‌ ଇୟେଞ୍ଜି କି ଇୟ୍‌ଲେ ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ଏ ଆଜ୍ଞା, ଇନ୍‌ଲେଞ୍ଜି ନମି ଏମନ୍ନେତାୟ୍‌, ତି ପାତ୍ୟାମରନ୍‌ ଆମେଙ୍‌ ଇଙନ୍‌ ବର୍ରନେ, ‘ଞେନ୍‌ ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋତନାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ତିଆସନ୍‌, ୟାଗି ଡିନ୍ନା ଜାୟ୍‌ ମସାନ୍ନିନ୍‌ ସିପ୍ପାୟଞ୍ଜି ଅବ୍‌ଜଗେଆଜି, ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ତିଆତେ ରାଉଲନ୍‌ ଇୟ୍‌ତାୟ୍‌ ପାଙେଜି କି, ଆନିନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଡୋଲନ୍‌ ଗାମ୍‌ଲେ ବର୍ତଞ୍ଜି; ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ମୁଙ୍‌ ଆ ପାତ୍ୟା ସିଲଡ୍‌ ତିକ୍କି ଆ ପାତ୍ୟା ଆରି ସଙ୍କଡ଼ାଡମ୍‌ ଡେତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବଡଡ଼ ସିପ୍ପାୟଞ୍ଜି ଓରୋଙ୍‌ଡାଲେ ରନପ୍ତିନ୍‌ ଜାୟ୍‌ ମସାନ୍ନିନ୍‌ ଇୟ୍‌ନବ୍‌ଜଗେବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିରେଞ୍ଜି କି ମସାନ୍ନିନ୍‌ ଆରେଙ୍‌ଲୋଙ୍‌ ଇୟ୍‌ଲେ ଅବ୍‌ଜିଡେଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତେତ୍ତେ ସିପ୍ପାୟଞ୍ଜି ଇୟ୍‌ଲେ ଅବ୍‌ଜଗେଏଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ଲୋଲୋନେ ଡିନ୍ନାନ୍‌ ଆସ୍ରୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପାଲ୍ଲିନ୍‌ ଆ ପର୍ତମ୍ମୁ ଡିନ୍ନା ଡୋତାନ୍‌ ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌ ଡ ଆନ୍ନା ମରିଅମନ୍‌ ମସାନ୍ନିନ୍‌ ଗିୟ୍‌ଗିୟ୍‌ବାନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ଆରି ଅବୟ୍‌ ସୋଡ଼ା ତକର୍‌ଲନ୍‌ ଡେଏନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଜିର୍ରାୟ୍‌ କି ମସାନ୍ନିନ୍‌ ଆଡଙ୍‌ଡଙନ୍‌ ଆରେଙ୍‌ ଡେଡ୍‌ଲେ ତେତ୍ତେ ଇୟ୍‌ଲାୟ୍‌ ତଙ୍କୁମେ । ");
INSERT INTO juy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ଆନିନ୍‌ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙନ୍‌ ତାବ୍‌ରେଡନ୍‌ ଅନ୍ତମ୍‌ ଆରି ଆ ଅଙ୍ଗିନ୍‌ ଆଡ଼େରନ୍‌ ଅନ୍ତମ୍‌ ଜେଏଡମ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ମସାନ୍ନିନ୍‌ ଆଜ୍ରଗେଏଞ୍ଜି ଆ ମନ୍‌ରାଜି ବାବନ୍ତଙ୍‌ ତକରେଞ୍ଜି କି ଆରବୁନ୍‌ ଅନ୍ତମ୍‌ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ବନ୍‌ଡ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆଇମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେନ୍‌ ବତଙ୍‌ଡଙ୍‌ବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଆରମ୍‌ଡାଜେଞ୍ଜି ଆ ଜିସୁଆଡଙ୍‌ ଆମ୍ୱେନ୍‌ ଏସାୟ୍‌ତେ, ତିଆତେ ଞେନ୍‌ ଜନା । ");
INSERT INTO juy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ଆନିନ୍‌ ତେନ୍ନେ ମନ୍‌ରା ତଡ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଏଙ୍ଗାଲେ ବର୍ରନେ, ଏତ୍ତେଲେ ଆନିନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋଲନେ । ୟବା, ଆନିନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ବନ୍‌ ଡନକ୍କୋନ୍‌ ଡେଏନ୍‌, ତି ତେତ୍ତେ ଆୟ୍‌ ଗିୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ଆରି, ଆମ୍ୱେନ୍‌ ଲଜିର୍‌ଡାଲେ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ ବର୍ବାଜି, ‘ଆନିନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଡୋଲନେ, ଆରି ଆନିନ୍‌ ମୁକ୍କାଗଡ୍‌ବେନ୍‌ ଆମ୍ମୁଙ୍‌ଲନ୍‌ ଗାଲିଲିନ୍‌ ଜିର୍ତେ, ତେତ୍ତେ ଆନିନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଇୟ୍‌ତେ ଏଗିଜେ !’ ଗିୟ୍‌ବା କରୋଡାଡଙ୍‌ବେନ୍‌, ଞେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ସିଲତ୍ତେ ଆନିଞ୍ଜି ବନ୍ତଙନ୍‌ ଡ ସର୍ଡାନ୍‌ ବାତ୍ତେ ମସାନ୍ନିନ୍‌ ସିଲଡ୍‌ ଲଜିରେଞ୍ଜି କି ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବନରନ୍‌ ଆସନ୍‌ ଇରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ଆରି ଜିସୁନ୍‌ ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ଆନିଞ୍ଜିଆଡଙ୍‌ ରବାଙେଞ୍ଜି କି ବରେଞ୍ଜି, “ଆମ୍ୱେନ୍‌ ସରିନ୍‌ ସୟୁନ୍‌ ଡକୋନେତୋ ।” ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାଜି କି ଆ ତାଲ୍‌ଜଙନ୍‌ ଞମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଲୋମେଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ଆରି ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବତଙ୍‌ଡଙ୍‌ବେନ୍‌, ଆମ୍ୱେନ୍‌ ଜିର୍ରେ ବୋଞାଙ୍‌ଞେଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ ଅବ୍‌ଜନାବାଜି, ଆନିଞ୍ଜି ଗାଲିଲିନ୍‌ ଜିରେତଜି, ଆନିଞ୍ଜି ତେତ୍ତେ ଞେନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗିଜିଁୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ତି ଆଇମରଞ୍ଜି ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌, ମସାନ୍ନିନ୍‌ ଆଜ୍ରଗେଏଞ୍ଜି ଆ ସିପ୍ପାୟ୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ଗଡ଼ାନ୍‌ ଜିର୍ରେ ତି ଏତ୍ତେଗୋ ଆଡ୍ରେଏନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ପାପୁର୍‌ମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ କଡାଡ଼ିଲଞ୍ଜି କି ତି ଆ ସିପ୍ପାୟ୍‌ଜିଆଡଙ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ତଙ୍କାନ୍‌ ତିୟ୍‌ଲେ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ଇନ୍‌ଲେଞ୍ଜି ଆଲୁଡ୍‌ଲୁଡିଙନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ତଗଲନ୍‌ ଇୟ୍‌ଲାଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ରାଉଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ପାଙେଜି, ଗାମ୍‌ଲେ ବର୍ନାବା । ");
INSERT INTO juy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ଆରି କେନ୍‌ ଆ ବର୍ନେ ରାଜ୍ୟପାଡ଼ନ୍‌ ଅମ୍‌ଡଙେନ୍‌ ଡେନ୍‌, ଇନ୍‌ଲେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏବର୍ତାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଇନ୍ନିଙ୍‌ ଏବାଉଲ୍ଲିଡଙ୍‌ନେ ।” ");
INSERT INTO juy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ଆରି ସିପ୍ପାୟଞ୍ଜି ଡାବ୍ବୋନ୍‌ ଜାଏଞ୍ଜି କି ଏଙ୍ଗାଲେ ଞନଙ୍‌ଞଙନ୍‌ ଞାଙେଞ୍ଜି, ଏତ୍ତେଲେ ଇୟ୍‌ଲେ ଲୁମେଜି । ତିଆସନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ବୁର୍ବୁରାୟ୍‌ଲନ୍‌, ଆରି ନମିନ୍ତାନ୍‌ ଏତ୍ତେଲେ ମା ବର୍ତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ଏଗାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ଗାଲିଲିନ୍‌ ଜିରେଞ୍ଜି କି, ଜିସୁନ୍‌ ଅଙ୍ଗା ବରୁ ଅନିୟନ୍‌ ଆସନ୍‌ ଆମ୍ମୁଙ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ତି ଆ ବରୁ ଆନିଞ୍ଜି ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଲୋମେଞ୍ଜି, ବନ୍‌ଡ ଲାଙ୍‌ଲେନ୍ନେ ଡାଲ୍‌ଗଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଆରି, ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଜିର୍ରାୟ୍‌ କି କଡାଡ଼ିଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ, “ରୁଆଙନ୍‌ ଡ ପୁର୍ତିନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ସନୋଡ଼ାନେ ଞେନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେଲୋ । ");
INSERT INTO juy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଜିର୍ରେ ଅଡ଼୍‌କୋ ଜାତିନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଞଙ୍‌ନେମର୍‌ ଏମ୍ମେଡାଲେ ଆପେୟନ୍‌, ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଡ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ଇୟ୍‌ ତିୟ୍‌ବାଜି । ");
INSERT INTO juy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ଆରି ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଇନିଜି ଞନଙନ୍‌ ତିୟ୍‌ଲବେନ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ଇୟ୍‌ ତିୟ୍‌ବାଜି; ଆରି ଗିୟ୍‌ବା, କେନ୍‌ ଆ ଜୁଗ ଆରଞିଡ୍‌ତେନ୍‌ ଜାୟ୍‌ ଞେନ୍‌ ଆଏଡ଼ର୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋତନାୟ୍‌ ।”");
INSERT INTO juy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","କେନ୍‌ଆତେ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆ ମନଙ୍‌ବର୍‌ ଉଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ଆ ସାସ୍ତ୍ରଲୋଙ୍‌ ଏଙ୍ଗାଲେ ଆଇଡିଡ୍‌, “ଇସ୍ୱରନ୍‌ ବର୍ତନେ, ‘ଗିୟ୍‌ବା ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ଞେନ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ନମ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌, ଆନିନ୍‌ ତଙର୍‌ନମ୍‌ ଅବ୍‌ଜାଡାତେ ।’ ");
INSERT INTO juy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଆକ୍ରାନ୍‌ ଆବ୍ରାବ୍ବାବ୍‌ତେନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ ସର୍ରଙ୍‌, ‘ପ୍ରବୁନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ଅବ୍‌ଜାଡାବା; ଆନିନ୍‌ ଆସନ୍‌ ରୋତ୍ତନ୍‌ ବିଙୟ୍‌ବା ।’” ");
INSERT INTO juy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ତିଆସନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଜିର୍ରେ, “ଇର୍ସେନ୍‌ ସିଲଡ୍‌ ୟର୍ରନ୍‌ ଆୟ୍‌ ତବ୍ବୁବ୍‌ଡାନାବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଇର୍ସେବେନ୍‌ କେମାତବେନ୍‌” ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଅପ୍ପୁଙେଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ସିଲତ୍ତେ ସମ୍ପରା ଜିଉଦା ଡେସାନ୍‌ ଡ ସମ୍ପରା ଜିରୁସାଲମବାଜି ଜନନ୍‌ ଆମଙ୍‌ ଜିର୍ଜିର୍ରାଜି ଆରି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଇର୍ସେ ବର୍ରନ୍‌ ଜର୍ଦନ ଅଲଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତବ୍ବୁବ୍‌ଡାନେଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଓଟପୁରନ୍‌ ବାତ୍ତେ ଆତୁବ୍‌ତୁବନ୍‌ ଆ ସିନ୍‌ରି ରଲନେ ଆରି ଆ କୁଣ୍ଡୁବ୍‌ଲୋଙନ୍‌ ଉସାଲ୍‌ ଜନିଡୁବନ୍‌ ରେଡ୍ଡୁବ୍‌ଲନ୍‌, ଆରି ଆନିନ୍‌ ପପ୍ପରନ୍‌ ଡ କିନ୍‌ରେଙ୍‌ ଇଁଙ୍‌ରଡନ୍‌ ଜୋମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ବର୍ବରନ୍‌ ଆସନ୍‌ ଉଲନେ, “ଞେନ୍‌ ସିଲଡ୍‌ ଆନା ଗୋଗୋୟ୍‌ ବୋର୍ସାଡମ୍‌, ଆନିନ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତିକ୍କି ଜିର୍ତାୟ୍‌, ଞେନ୍‌ ଡୁଙ୍ଗୁଡାଲେ ଆ ତାଲ୍‌ଜଙନ୍‌ ଆ ପାଣ୍ଡୋୟ୍‌ ଆ ଜନିବାଡ୍‌ ଉଜୁଜନ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡାଆଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତବେନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ତି ଆ ବନେଡ଼ା ଜିସୁନ୍‌ ଗାଲିଲି ନାଜରିତ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଜର୍ଦନ ଅଲନ୍‌ ଜିର୍ରେ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତବ୍ବୁବ୍‌ଡାନେ । ");
INSERT INTO juy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ଆରି, ଜିସୁନ୍‌ ଡାଆଲୋଙନ୍‌ ସିଲଡ୍‌ ତେରଙ୍‌ ଡୋଲନ୍‌ ଆଜିର୍ରାଞନ୍‌ ଆଡିଡ୍‌ ରୁଆଙନ୍‌ ରୋଲନେ ଆରି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ କୁକ୍କୁରନ୍‌ ଅନ୍ତମ୍‌ ଜିସୁନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତାର୍ଡୋୟ୍‌ନେନ୍‌ ଆନିନ୍‌ ଗିଜେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ଆରି ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ସର୍ରଙନ୍‌ ସଡ୍ଡାଏନ୍‌, “ଆମନ୍‌ ଡନୁଙ୍‌ୟମ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌, ଅମଙ୍‌ନମ୍‌ ଞେନ୍‌ ଗୋଗୋୟ୍‌ ମଅଁୟ୍‌ଡାତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ସିଲତ୍ତେମା ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଓରୋଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ଆନିନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ବାକୁଡ଼ି ଡିନ୍ନା ଡକୋଲନ୍‌, ତେତ୍ତେ ସନୁମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତୋରେନ୍‌, ଆନିନ୍‌ ଆଡ୍ରକୋଲୋଙ୍‌ଲନ୍‌ କିନ୍‌ରେଙ୍‌ ଜନ୍ତୁଞ୍ଜି ନିୟ୍‌ ତେତ୍ତେ ଡକୋଲଞ୍ଜି, ଆରି ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ସାକ୍କେଏଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଆଡ୍ରକ୍କୋଏଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଗାଲିଲିନ୍‌ ଜିର୍ରେ ଇସ୍ୱରନ୍‌ ଆ ମନଙ୍‌ବର୍‌ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେ । ");
INSERT INTO juy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“ଡିନ୍ନାନ୍‌ ବରିଜେନ୍‌, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ତୁୟାଲାୟ୍‌, ଇର୍ସେନ୍‌ ସିଲଡ୍‌ ୟର୍ନାୟ୍‌ବା ଆରି ମନଙ୍‌ବରନ୍‌ ଡର୍ନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ଜିସୁନ୍‌ ଗାଲିଲି ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଗଡ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ସିମନନ୍‌ ଡ ଆ ବୋଞାଙନ୍‌ ଆନ୍ଦ୍ରିଅନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଅବୟ୍‌ ଜାଲନ୍‌ ଆସ୍ରେଡେଞ୍ଜି ଆଡିଡ୍‌, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଞମ୍‌ୟମର୍‌ଜି ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ବା, ମନ୍‌ରାଞ୍ଜି ଏଙ୍ଗାଲେ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଅନୋରୋଙନ୍‌ ଡେତେ ତିଆତେ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞଙ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଅବ୍‌ତାଡ଼ନ୍‌ ଜାଲନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ଆରି, ଜିସୁନ୍‌ ଡାସଙାୟ୍‌ ଅଡିଡ୍‌ ଜିର୍ରେ ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ଜାକୁବନ୍‌ ଡ ଆ ବୋଞାଙନ୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି, ଆନିଞ୍ଜି ଡୋଙ୍ଗାଲୋଙନ୍‌ ଜାଲନ୍‌ ବୟ୍‌ବଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ସିଲତ୍ତେମା ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଏଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ଆପେୟଞ୍ଜି ଜେବଦିନ୍‌ଆଡଙ୍‌ ଆ ବଡିମରଞ୍ଜି ସରିନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି କପର୍ନାଉମ୍‌ ଗଡ଼ାନ୍‌ ଜିରେଞ୍ଜି, ଆରି ସିଲତ୍ତେମା ଆନିନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ଗନ୍‌ଲନ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ଆ ଞନଙନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଅନ୍ତମ୍‌ ଞନଙନ୍‌ ଏର୍‌ତନିୟନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ଆଞ୍ରାଙେନ୍‌ ଆ ମନ୍‌ରା ଅନ୍ତମ୍‌ ଞନଙନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ତି ଆ ବନେଡ଼ା ଆ ରନୁକ୍କୁସିଂଲୋଙଞ୍ଜି ଆଡ୍ରକୋଏନ୍‌ ଅବୟ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରା ସଜିର୍‌ଡାଲେ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ଏ ନାଜରିତ ଜିସୁ, ଆମନ୍‌ ସରିନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଇନି ଡକୋ ? ଆମନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ସେଡନ୍‌ ଆସନ୍‌ ପଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ? ଆମନ୍‌ ଆନା, ତିଆତେ ଞେନ୍‌ ଜନା, ଆମନ୍‌ ତି ଇସ୍ୱରନ୍‌ ଆ ମଡ଼ିର୍‌ମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବବ୍‌ତଙ୍‌ଡାଲେ ବର୍ରନେ, “କଡ଼ିଙା, କେନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରା ।” ");
INSERT INTO juy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ସିଲତ୍ତେ ତି ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ପଡ୍ଡେଃଡାଲେ ଆକ୍ରାନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବାବ୍ବାବ୍‌ଡାଲେ ଆମଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","କେନ୍‌ ଆସନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଏତ୍ତେଲେ ସାନ୍ନି ଡେଏଞ୍ଜି ଡ, ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଡାଲନ୍‌ ବର୍ରଞ୍ଜି, “ଇନି କେନ୍‌ ? କେନ୍‌ ତ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ବୟନ୍‌ ରଙ୍‌ ଞନଙନ୍‌ ! ଆନିନ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ବାଁୟ୍‌ତଜି, ଆରି ଆନିଞ୍ଜି ଆ ବନାଞନ୍‌ ମାନ୍ନେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆ ବର୍ନେ ତେରଙ୍‌ ସମ୍ପରା ଗାଲିଲିରେଙନ୍‌ ବୁର୍ବୁରାୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ରନୁକ୍କୁସିଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜାକୁବନ୍‌ ଡ ଜନନ୍‌ ସରିନ୍‌ ସିମନନ୍‌ ଡ ଆନ୍ଦ୍ରିଅନ୍‌ ଆ ଅସିଂ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ସିମନନ୍‌ ଆ କିନାର୍‌ ଆରସୁଏନ୍‌ ଲୁଡ୍‌ଲେ ଡକୋଲନ୍‌, ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ସିଲତ୍ତେମା ଆ ବର୍ନେନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆମଙନ୍‌ ଜିର୍ରେ ଆସିନ୍‌ ଞମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ଅବ୍‌ଡୋଏ, ଆରି ଆନିନ୍‌ ଅସୁନ୍‌ ତଡେନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ରୋଜୋମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ସାଲ୍ଲୁମ୍‌ ବେଡ଼ାନ୍‌ ଆବ୍ରୁବ୍‌ୟୋଙେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ ଆ ମୁକ୍କାଗଡ୍‌ ଅସୁମରଞ୍ଜି ଡ ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରାଜି ଓରୋଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ଆରି ଗଡ଼ାନ୍‌ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ଅସିଙନ୍‌ ଆ ଗରନ୍ନେଲୋଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ରୋଗଲୋଙ୍‌ ବମ୍ୱମ୍‌ନେମରଞ୍ଜି, ଜବ୍ରଡମ୍‌ ରୋଗମରଞ୍ଜି ମବ୍‌ନଙେନ୍‌ ଆରି ଗୋଗୋୟ୍‌ଡମ୍‌ ବୁତଞ୍ଜି ଗଙେନ୍‌, ଆନିନ୍‌ ବୁତଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନବ୍‌କଡାଡ଼ିଲଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍ମଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ତି ଆବାର୍ତାନ୍‌ ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ଲୋଙଡ୍‌ ଲୋଙଡ୍‌ ବେଡ଼ାନ୍‌ ଜିସୁନ୍‌ ଡୋଲନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ ଆରି ଅବୟ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଜିର୍ରେ ତେତ୍ତେ ଇୟ୍‌ଲେ ପାର୍ତନାନେ । ");
INSERT INTO juy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ଆରି, ସିମନନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସାୟ୍‌ଡଙ୍‌ଡାଲେ, ");
INSERT INTO juy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ଆର୍ରବାଙେଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଅଡ଼୍‌କୋଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ସାୟ୍‌ଡଙ୍‌ତମ୍‌ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ୟବା, ଇନ୍‌ଲେଞ୍ଜି ଆନ୍ନାରେଙ୍‌, କେନ୍‌ ଆ ତୁୟାୟ୍‌ ଆ ସାଇରେଙ୍‌ ଏଇୟ୍‌ବା, ତେତ୍ତେ ନିୟ୍‌ ଞେନ୍‌ ଞନଙନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତିୟ୍‌ନାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆସନ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ଆରି, ଜିସୁନ୍‌ ସମ୍ପରା ଗାଲିଲିରେଙନ୍‌ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ଅଡ଼୍‌କୋନ୍‌ ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ଞନଙନ୍‌ ତିୟେନ୍‌ ଆରି ବୁତଞ୍ଜି ଗଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ତି ଆ ବନେଡ଼ା ଅବୟ୍‌ ମୋଡ୍ଡୋମରନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ତୁଡ଼ୁମ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ କାକୁର୍ତିଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଆମନ୍‌ ଲଡୟ୍‌ଲମ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ରପ୍ତି ମବ୍‌ଡ଼ିର୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଇର୍ସୋୟମ୍‌ଡାଲେ ଆସିନ୍‌ ତେକ୍କେଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସୁଙେଏନ୍‌ କି ବର୍ରନେ, “ଞେନ୍‌ ଲଡୟ୍‌ତିଁୟ୍‌, ମଡ଼ିରମ୍‌ତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ସିଲତ୍ତେମା ମୋଡ୍ଡୋନ୍‌ ତି ଆ ମନ୍‌ରା ଆମଙ୍‌ ସିଲଡ୍‌ ସଙାଜେନ୍‌ ଆରି ଆନିନ୍‌ ମଡ଼ିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ଆରି, ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ବର୍ରେ ଆପ୍ପାୟେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ଅମ୍‌ଡଙା, ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ବର୍‌ଡଙେ, ବନ୍‌ଡ ଜିରା, ରାଓଡ଼ାନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ନବ୍‌ତୁୟ୍‌ଡମ୍‌ନା, ଆରି ଆମନ୍‌ ମନଙ୍‌ଲମ୍‌ ଗାମ୍‌ଲେ ଆମଙଞ୍ଜି ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌, ମନଡ଼ିର୍‌ବେନ୍‌ ଆସନ୍‌ ମୋସାନ୍‌ ଅଙ୍ଗାତେ ବାଁୟ୍‌ଲବେନ୍‌, ଏତ୍ତେଲେ ଅନମଙନ୍‌ ଇୟ୍‌ ତିୟା ।” ");
INSERT INTO juy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ବନ୍‌ଡ ଆନିନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ କି ତି ଆ ବର୍ନେ ସମ୍ପରାନ୍‌ ଏତ୍ତେଲେ ବର୍ବର୍ରେ ପାଙେନ୍‌ ଡ, ଜିସୁନ୍‌ ଆରି ଅବ୍‌ଗିୟ୍‌ତାଲନ୍‌ ଅନ୍ନିଙ୍‌ ଆ ଗଡ଼ାଲୋଙ୍‌ ଅଃର୍ରପ୍ତି ଗନ୍‌ଲୋ, ବନ୍‌ଡ ଆନ୍ନାରେଙ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଡକୋଲନ୍‌, ଆରି ମନ୍‌ରାଞ୍ଜି ଆମଙନ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ଅସୋୟ୍‌ ଡିନ୍ନା ଡକୋଡାଲନ୍‌ ଜିସୁନ୍‌ ଆରି କପର୍ନାଉମ୍‌ ଗଡ଼ାନ୍‌ ୟର୍ରନେ, ଆନିନ୍‌ ଅସିଙନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ତିଆସନ୍‌ ଡିୟ୍‌ତେ ଆ ଗୋଗୋୟ୍‌ ମନ୍‌ରାଞ୍ଜି ତେତ୍ତେ ଇୟ୍‌ଲାୟ୍‌ କୁଡ଼ାୟ୍‌ନେଜି ଡ, ଗରନ୍ନେଲୋଙନ୍‌ ନିୟ୍‌ ଡରକୋନେନ୍‌ ଆସନ୍‌ ଜାଗା ତଡ୍‌, ଆରି ଆନିନ୍‌ ଆମଙଞ୍ଜି ମନଙ୍‌ବରନ୍‌ ଅପ୍ପୁଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ତି ଆ ବନେଡ଼ା ଉଞ୍ଜି ମନ୍‌ରା ଅବୟ୍‌ କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ ବୋୟ୍‌ଲେ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି, ");
INSERT INTO juy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ବନ୍‌ଡ ତେତ୍ତେ ମନ୍‌ରାଞ୍ଜି ଆୟରେଡନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଆନିଞ୍ଜି କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି, ତିଆସନ୍‌ ଜିସୁନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋଲନ୍‌, ତେତ୍ତେ ଆ ବିଲେଙ୍‌ ଗାୟ୍‌ଲେ ତବେଞ୍ଜି, ଆରି ତିଆତେ ରୁବ୍‌ଲେ, ଅଙ୍ଗା କଟଲୋଙ୍‌ କାନ୍ନିମରନ୍‌ ଲୁଡ୍‌ଲେ ଡକୋଲନ୍‌ ତି ଅମ୍ପରା କଟନ୍‌ କାନ୍ନିମରନ୍‌ ଜାୟ୍‌ତାନ୍‌ ଅପ୍ପଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ଜିସୁନ୍‌ ଆ ଡର୍ନେଞ୍ଜି ଗିୟ୍‌ଲେ ତି କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଅଅନ୍‌, ଅଡ଼୍‌କୋ ଇର୍ସେନମ୍‌ଜି ସିଲଡ୍‌ ଆମନ୍‌ କେମାନ୍‌ ଞାଙେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ବନ୍‌ଡ ଲାଙ୍‌ଲେଡ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ତେତ୍ତେ ତଙ୍କୁମ୍‌ଡାଲେ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ମନ୍ନଲୋଙ୍‌ ଏନ୍ନେଲେ ଇୟମେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“କେନ୍‌ ଆ ମନ୍‌ରା ଇନିବା ଏନ୍ନେଲେ ବର୍ତନେ ? ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ତେ, ଇସ୍ୱରନ୍‌ ତୁମ୍‌ ସିନା ଅବୟ୍‌ନେ, ଇର୍ସେନ୍‌ କେମାତେ, ଆନିନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆନା ଆରି ଇର୍ସେନ୍‌ କେମାଲେ ରପ୍ତିଏ ?” ");
INSERT INTO juy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ସାସ୍ତ୍ରିଞ୍ଜି ଆ ମନ୍ନଲୋଙଞ୍ଜି ଏନ୍ନେଲେ ଆରିଃୟମେଞ୍ଜି, ତିଆତେ ଜିସୁନ୍‌ ସିଲତ୍ତେମା ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ମନ୍ନଲୋଙ୍‌ ଇନିବା କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଏଇଃୟମ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ଅଙ୍ଗାତେ ଲିଆର୍‌ ? କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ ‘ଇର୍ସେନମ୍‌ ଅଡ଼୍‌କୋନ୍‌ କେମାନ୍‌ ଞାଙେନ୍‌’ ଗାମ୍‌ଲେ ବନରନ୍‌ ଲିଆର୍‌, ଅଡ଼େ, ‘ଡୋନା, କଟନମ୍‌ ପାଙ୍‌ଲେ ଜିରା’ ଗାମ୍‌ଲେ ବନରନ୍‌ ଲିଆର୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ବନ୍‌ଡ ପୁର୍ତିଲୋଙନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମଙ୍‌ ଇର୍ସେନ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ସନୋଡ଼ାନେନ୍‌ ଡକୋ, କେନ୍‌ଆତେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ରପ୍ତି ଏଜନାତେ, ତିଆସନ୍‌ ଆନିନ୍‌ କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, ଡୋନା, କଟନମ୍‌ ପାଙ୍‌ଲେ ଅସିଂନମ୍‌ ଜିରା ।” ");
INSERT INTO juy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ସିଲତ୍ତେ କାନ୍ନିମରନ୍‌ ତେରଙ୍‌ ଡୋଲନ୍‌ କଟନ୍‌ ପାଙ୍‌ଲେ ଅଡ଼୍‌କୋଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌, ତିଆସନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ସାନ୍ନିଡାଲେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେନ୍‌ଲେ ସେନ୍‌ଲେ ବର୍ରଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଆଙ୍ଗିୟ୍‌ ଏନ୍ନେଗୋ ଅଣ୍ଡ୍ରଙ୍‌ ଏଗିଜାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ଜିସୁନ୍‌ ଆରି ଗାଲିଲି ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙନ୍‌ ଆଜିର୍ରାଞଞ୍ଜି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ, ");
INSERT INTO juy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ଆନିନ୍‌ ଜିରା ଜିରା ଆଲପିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଲେବିନ୍‌, ଆ ପାନୁସିଂଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଲେ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌ ଇୟ୍‌ଲେ ଗିଜେ, ସିଲତ୍ତେ ଆନିନ୍‌ ଲେବିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ ।” ସିଲତ୍ତେ ଲେବିନ୍‌ ଡୋଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଲେବିନ୍‌ ଆସିଂ ଗାଗାନେନ୍‌ ଆସନ୍‌ ଆତ୍ରଙ୍କୁମେନ୍‌ ଆଡିଡ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଇର୍ସେମରଞ୍ଜି ଆରି ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ତଙ୍କୁମେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଡକୋଏଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ଆନିନ୍‌ ଇର୍ସେମରଞ୍ଜି ଡ ପାନୁବେଡ୍‌ମରଞ୍ଜି ସରିନ୍‌ ଆଗ୍ରାଗାଲନ୍‌ ଆଡିଡ୍‌ ଗିୟ୍‌ଲେ ପାରୁସିଞ୍ଜି ଆ ମରାୟ୍‌ନେ ସାସ୍ତ୍ରିଞ୍ଜି, ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ ଇନି ? ଆନିନ୍‌ ଇର୍ସେମରଞ୍ଜି ଡ ପାନୁବେଡ୍‌ମରଞ୍ଜି ସରିନ୍‌ ଗାଗାତନେ !” ");
INSERT INTO juy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ଜିସୁନ୍‌ ତିଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ବର୍ରନେ, “ସୁକ୍କଡଅଙ୍‌ମରଞ୍ଜି ଆସନ୍‌ ବୌଡମରନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌, ବନ୍‌ଡ ଅସୁମରଞ୍ଜି ଆସନ୍‌ ବୌଡମରନ୍‌ ସନାୟ୍‌ସାୟ୍‌, ଞେନ୍‌ ଡରମ୍ମମରଞ୍ଜିଆଡଙ୍‌ ଅନୋଡ୍ଡେବାନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଇର୍ସେମରଞ୍ଜିଆଡଙ୍‌ ଅନୋଡ୍ଡେବାନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଡ ପାରୁସିଞ୍ଜି ଆନମ୍‌ଲଞ୍ଜି । ତିଆସନ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିର୍ରେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ତବ୍ବୁଡାମର୍‌ ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଡ ପାରୁସିଞ୍ଜି ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆନମ୍‌ତଞ୍ଜି, ବନ୍‌ଡ ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ଇନିବା ଅଃନ୍ନାନମ୍‌ନେଜି ?” ");
INSERT INTO juy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, “କନୁଆମରଞ୍ଜି ସରିନ୍‌ ବରନ୍‌ ଡକୋଲନ୍‌ ଆଡିଡ୍‌ ଆନିଞ୍ଜି ଆନମନ୍‌ ଡକୋନେଜି ପଙ୍‌ ? ବରନ୍‌ ଅଙ୍ଗା ଜାୟ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋତନେ, ତି ଜାୟ୍‌, ଆନିଞ୍ଜି ରପ୍ତି ଅଃନ୍ନାନମ୍‌ନେଜି । ");
INSERT INTO juy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ବନ୍‌ଡ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ବରନ୍‌ ତବ୍‌ଲେ ଅନୋରୋଙନ୍‌ ଡେତେ, ତି ଆ ବନେଡ଼ା ତି ଆ ଡିନ୍ନା ଆନିଞ୍ଜି ଆନମ୍‌ତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ଆନ୍ନିଙ୍‌ଜା ରଙ୍‌ ସିନ୍‌ରିନ୍‌ ଆଲୁଡ୍‌କାବ୍‌ ପାଙ୍‌ଲେ ପାପୁର୍‌ ସିନ୍‌ରିଲୋଙନ୍‌ ଅଃବ୍ବଜେ, ବଜେନ୍‌ ଡେନ୍‌ ତିଆତେ ପାପୁରନ୍‌ଆତେ ପବ୍‌ତେତେ, ଆରି ଗୋଗୋୟ୍‌ ପତେତେ । ");
INSERT INTO juy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ଆରି, ଆନ୍ନିଙ୍‌ଜା ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ପାପୁର୍‌ ଉସାଲ୍‌ ମୁନାଲୋଙନ୍‌ ଅଃଡ୍ଡକ୍କୋଏ, ଡକ୍କୋଏନ୍‌ ଡେନ୍‌ ତିଆତେ ଉସାଲ୍‌ ମୁନାନ୍‌ ପବ୍‌ତଡ୍‌ତେ, ଆରି ଦ୍ରାକ୍ୟାଡାନ୍‌ ଡ ଉସାଲ୍‌ ମୁନାନ୍‌ ବାଗୁନ୍‌ ମୋସ୍ସାତେ । ବନ୍‌ଡ ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ରଙ୍‌ ଉସାଲ୍‌ ମୁନାଲୋଙନ୍‌ ଡନକ୍କୋନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଜନ୍‌ରୋମ୍‌ଆଲ୍‌ ଗଡ୍‌ ଜିରେନ୍‌, ଆରି ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଜିରା ଜିରା ଜନ୍‌ରୋମନ୍‌ ଆ ସିସା ତତ୍ତଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ତିଆସନ୍‌ ପାରୁସିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଗିଜା, ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଅଙ୍ଗାତେ ଲନୁମନ୍‌ ଆସନ୍‌ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଆଇଡିଡ୍‌ ତଡ୍‌, ତିଆତେ ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ଇନିବା ଲୁମ୍‌ତଜି ?” ");
INSERT INTO juy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଦାଉଦନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ଆଡ୍ରୋଲଜେଞ୍ଜି ଆଡିଡ୍‌ ଆନିନ୍‌ ଇନି ଏଙ୍ଗାଲନ୍‌, ତିଆତେ ନିୟ୍‌ ପଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଆଙ୍ଗିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏପଡ଼େନେ ? ");
INSERT INTO juy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ଅବିଆତର୍‌ ସୋଡ଼ା ରାଓଡ଼ାନ୍‌ ଆ ବନେଡ଼ାଇଂ ଦାଉଦନ୍‌ ଏଙ୍ଗାଲେ ଇସ୍ୱରନ୍‌ ଆସିଂ ଗନ୍‌ଲେ, ଅଙ୍ଗା ରୁଟି ରାଓଡ଼ାଞ୍ଜି ତୁମ୍‌ ଜୋମ୍‌ତଜି, ଆରି ଆନ୍ନିଙ୍‌ ଅଃଜ୍ଜୋମେଜି ଗାମ୍‌ଲେ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଡକୋ, ତିଆତେ ଆନିନ୍‌ ଜୋମେନ୍‌, ଆରି ଆ ଗଡ଼ିଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ତିୟେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଲୋଲୋନେ ଡିନ୍ନାନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆସନ୍‌ ଡେଏନ୍‌, ମନ୍‌ରାନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାନ୍‌ ଆସନ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ତିଆସନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଆ ପ୍ରବୁ ।” ");
INSERT INTO juy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ତିକ୍କି ଜିସୁନ୍‌ ଆରି ରନୁକ୍କୁସିଙନ୍‌ ୟର୍ରନେ । ତେତ୍ତେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆସିନ୍‌ ଅବୟ୍‌ ଆସର୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ଆରି, ଜିସୁନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ତେ ଜାଆରୋ ଗାମ୍‌ଲେ, ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଡଲ୍‌ଡଲେଞ୍ଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ କାୟ୍‌କାୟ୍‌ଲେ ରପ୍ତିତଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ସିଲତ୍ତେ ଅଙ୍ଗା ମନ୍‌ରା ଆସି ଆସର୍‌ ଡକୋଏନ୍‌, ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜିରାୟ୍‌, ମଡ୍ଡିନ୍‌ ଆୟ୍‌ ତନଙା ।” ");
INSERT INTO juy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ଆରି, ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଇନି ଲନୁମନ୍‌ ଆସନ୍‌ ଅନଗଡନ୍‌ ଡକୋ ? ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଅଡ଼େ ଏର୍‌ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ? ପରାନ୍ନାନ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ଅଡ଼େ ଅନବ୍‌ସେଡନ୍‌ ?” ବନ୍‌ଡ ଆନିଞ୍ଜି କଡ଼ିଙ୍‌ଲେ ସେଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ସିଲତ୍ତେ ଆ ଉଗରଞ୍ଜି ଆ ରଡୋନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ ଇର୍ସୋୟମ୍‌ଡାଏନ୍‌ କି ଏର୍ରେ ଆମଙ୍‌ରେଙଞ୍ଜି ଆଙାଙ୍‌ଡାଲେ ବରାବନ୍‌ ବାତ୍ତେ ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅସିନମ୍‌ ତେକ୍କେଆ ।” ଆନିନ୍‌ ଆସିନ୍‌ ତେକ୍କେଏନ୍‌, ଆରି ତିଆତେ ମନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ତିଆସନ୍‌ ପାରୁସିଞ୍ଜି ରନୁକ୍କୁସିଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ ସିଲତ୍ତେମା ଏରୋଦିଅଞ୍ଜି ସରିନ୍‌ ଇୟ୍‌ଲେ କଡାଡ଼ିନେଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ଆନ୍ନାଡାଲନ୍‌ ଗାଲିଲି ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆରି ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଜବ୍ର ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି; ଜିଉଦାନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ଜିରୁସାଲମନ୍‌, ଇଦୋମନ୍‌, ଜର୍ଦନ ଅଲନ୍‌ ଆ ଅଡିଗଡ୍‌, ସୋରନ୍‌ ଡ ସିଦୋନନ୍‌ ଆ ସମ୍ପରାରେଙ୍‌ ସିଲଡ୍‌ ଜବ୍ର ମନ୍‌ରା ଜିସୁନ୍‌ ଆ କାବ୍ବାଡ଼ା ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆମଙନ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ତି ଆ ବନେଡ଼ା ମନ୍‌ରାଞ୍ଜି ତେତ୍ତେ ଇୟ୍‌ଲାୟ୍‌ କୁଡ଼ାୟ୍‌ନେଞ୍ଜି, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ମନ୍‌ରାଞ୍ଜି ଇୟ୍‌ଡଙାୟ୍‌ ରାବେଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ସନ୍ନା ଡୋଙ୍ଗାନ୍‌ ତେତ୍ତେ ଅବ୍‌ଜାଡାଲେ ଡନକ୍କୋନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଜବ୍ର ମନ୍‌ରାଜିଆଡଙ୍‌ ଆମ୍ରବ୍‌ନଙେନ୍‌, ରୋଗମରଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସନୁଙେନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରାବେଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ଆରି, ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରାଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ, ଆନିଞ୍ଜି ଆ ମୁକ୍କାଗଡନ୍‌ ଜାୟ୍‌ତାନ୍‌ ଅସେଡ୍‌ଡାଲେ ସଜିର୍ରେ ବର୍ରଞ୍ଜି, “ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ସିଲତ୍ତେ ଜିସୁନ୍‌, ଆନିନ୍‌ ଆନା ତିଆତେ ଏବର୍‌ଡଙ୍‌ନେ ଗାମ୍‌ଲେ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜିଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ଜିସୁନ୍‌ ତୋଣ୍ଡୋ ବରୁନ୍‌ ଜିର୍ରେ, ଆନାଜିଆଡଙ୍‌ ଆନିନ୍‌ ଲଡଜେନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଆନିନ୍‌ ଓଡ୍ଡେଏନ୍‌ ଆରି ଆନିଞ୍ଜି ଆମଙନ୍‌ ଜିର୍ରାଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ଆରି, ଆନିନ୍‌ ବାରଜଣ ଅନାପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ସେଡାଏଞ୍ଜି, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋତଞ୍ଜି ଆରି ଆନିନ୍‌ ଅନପ୍ପୁଙ୍‌ବର୍‌ବାନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତଜି, ");
INSERT INTO juy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ଆରି ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବୁତନ୍‌ ଗଙ୍ଗଙନ୍‌ ଆସନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ଜିସୁନ୍‌ କେନ୍‌ ବାରଜଣଞ୍ଜିଆଡଙ୍‌ ସେଡାଏଞ୍ଜି, ଆଞୁମଞ୍ଜି ସିମନ୍‌, ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପିତ୍ର ଗାମ୍‌ଲେ ଅବ୍‌ଞୁମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜାକୁବନ୍‌ ଡ ଆ ବୋଞାଙନ୍‌ ଜନନ୍‌, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବିନେରିଗୋସ୍‌, କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ ମେଗନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ଞୁମେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ଆନ୍ଦ୍ରିଅନ୍‌, ପିଲିପନ୍‌, ବାର୍ତଲମିନ୍‌, ମାତିଉନ୍‌, ତୋମାନ୍‌, ଆଲପିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜାକୁବନ୍‌, ତଦ୍ଦିୟନ୍‌, କିନାନିଅ ସିମନନ୍‌, ଇସ୍ରାଏଲନ୍‌ ଆ ତନାଣ୍ଡେନ୍‌ ଆସନ୍‌ ଆର୍‌ଲଡଜେଞ୍ଜି ଆ ଜିଉଦିଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ଆନିନ୍‌ ଅବୟ୍‌ନେ, ");
INSERT INTO juy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ଆରି ଇସ୍କାରିତ ଜିଉଦାନ୍‌, କେନ୍‌ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଅସିଙନ୍‌ ଜିର୍ରାୟ୍‌, ମନ୍‌ରାଞ୍ଜି ଆରି ଏତ୍ତେଲେ ଇୟ୍‌ଲାୟ୍‌ କୁଡ଼ାୟ୍‌ନେଜି ଡ, ଆନିଞ୍ଜି ଗାଗାନେନ୍‌ ନିୟ୍‌ ଅଃର୍ରୟଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ଆସିଂମରଞ୍ଜି କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରାଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ କିତିଡେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ଆରି, ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଆ ସାସ୍ତ୍ରିଜି ଗାମେଞ୍ଜି, “କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବାଲ୍‌ଜିବୁଲନ୍‌ ଞମେନ୍‌, ଆରି ବୁତଞ୍ଜି ଆ ସୋଡ଼ା ବାତ୍ତେ ଆନିନ୍‌ ବୁତନ୍‌ ଗଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ସନୁମନ୍‌ ଏଙ୍ଗାଲେ ସନୁମନ୍‌ଆଡଙ୍‌ ଗଙ୍‌ଲେ ରପ୍ତିଏ ? ");
INSERT INTO juy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ଅନ୍ନିଙ୍‌ ଆ ରାଜ୍ୟ ତରଙ୍‌ଆନ୍ନା ଡେଲୋଙ୍‌ ଡେଲେ ଆ ବିରୁଦଲୋଙନ୍‌ ଡୋଲନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତି ଆ ରାଜ୍ୟ ରିଙ୍‌ ଗାମ୍‌ଲେ ଅଃର୍ରପ୍ତି ଡକୋନେ । ");
INSERT INTO juy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ଆରି, ଅନ୍ନିଙ୍‌ ଆସିଂ ଆ ମନ୍‌ରା ଆନ୍ନାଡାଲନ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ ଡୋଲନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତି ଆସିଂ ରିଙ୍‌ ଗାମ୍‌ଲେ ଅଃର୍ରପ୍ତି ଡକୋନେ । ");
INSERT INTO juy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ତିଅନ୍ତମ୍‌, ସନୁମନ୍‌ ଆ ରାଜ୍ୟ ତରଙ୍‌ଆନ୍ନା ଡେଲୋଙ୍‌ ଡେଲେ ଆ ବିରୁଦଲୋଙନ୍‌ ଡୋଲନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ରିଙ୍‌ ଗାମ୍‌ଲେ ଅଃର୍ରପ୍ତି ଡକୋନେ, ତିଆତେ ଅସେଡେନ୍‌ନି ।” ");
INSERT INTO juy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ବନ୍‌ଡ ଆନ୍ନିଙ୍‌ ଡେନ୍‌ ଆ ବପ୍ପୁମରନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଅଃଜ୍ଜିଲୋ ଡେନ୍‌ ଆସିଙନ୍‌ ଗନ୍‌ଲେ ଆ ଅତିଆରଞ୍ଜି ରାଉଲନ୍‌ ଅଃର୍ରପ୍ତି ପାଙେ, ବପ୍ପୁମରନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଜିଏନ୍‌ ଡେନ୍‌ ସିନା ଆନିନ୍‌ ଆସିଙନ୍‌ ଅଲ୍‌ରାଉନେ !” ");
INSERT INTO juy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ମନ୍‌ରାଅନଞ୍ଜି ଆ ଇର୍ସେ ଅଡ଼୍‌କୋନ୍‌ ଆରି ଆନିଞ୍ଜି ଡିଅଙ୍ଗା ନିଣ୍ଡୟ୍‌ବରନ୍‌ ବର୍ରନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ତଜି, ତି ଅଡ଼୍‌କୋନ୍‌ କେମାନ୍‌ ଞାଙ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ବନ୍‌ଡ ଆନା ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ନିଣ୍ଡୟ୍‌ବରନ୍‌ ବର୍ତନେ, ଆନିନ୍‌ ଆଙ୍ଗା ଜାକିଁୟ୍‌ କେମାନ୍‌ ଅଃଞାଙେ, ଆନିନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆ ଇର୍ସେଲୋଙ୍‌ ଡନୋସାନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆସୁମ୍‌ସୁମ୍‌” ଗାମ୍‌ଲେ ସାସ୍ତ୍ରିଞ୍ଜି ଆବର୍ରଞ୍ଜି, ଜିସୁନ୍‌ ଏନ୍ନେଲେ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ତି ଆ ବନେଡ଼ା ଜିସୁନ୍‌ ଆୟୋଙ୍‌ ଡ ଆ ବୋଞାଙଞ୍ଜି ଜିର୍ରେ ଡାଣ୍ଡନ୍‌ ତନଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଅନୋଡ୍ଡେନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ତିଆସନ୍‌ ଆନିନ୍‌ ଏର୍ରେ ଆତ୍ରଙ୍କୁମେଞ୍ଜି ଆ ମନ୍‌ରାଜି, ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଗିଜା, ଅୟୋଙ୍‌ନମ୍‌, ଡ ବୋଞାଙ୍‌ ତନାନ୍‌ନମ୍‌ଜି ଡାଣ୍ଡନ୍‌ ଡକୋଡାଲନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଜଗେତମ୍‌ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଅୟୋଙ୍‌ଞେନ୍‌ ଡ ବୋଞାଙ୍‌ଞେଞ୍ଜି ଆନା ?” ");
INSERT INTO juy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ଆନିନ୍‌ ଏର୍ରେ ଆତ୍ରଙ୍କୁମେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଆଙାଙ୍‌ଡାଲେ ବର୍ରନେ, “ଗିୟ୍‌ବା, କେନ୍‌ଆନିଞ୍ଜି ଅୟୋଙ୍‌ଞେନ୍‌ ଡ ବୋଞାଙ୍‌ଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ଆନା ଇସ୍ୱରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ଅନ୍ତମ୍‌ ଞଣ୍ଡ୍ରମ୍‌ତନେ, ଆନିନ୍‌ ବୋଞାଙ୍‌ଞେନ୍‌, ତନାନ୍‌ଞେନ୍‌ ଆରି ଅୟୋଙ୍‌ଞେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ଜିସୁନ୍‌ ଆରି ଗାଲିଲି ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ, ଆରି ଆମଙନ୍‌ ଏତ୍ତେଲେ ଆ ଗୋଗୋୟ୍‌ ମନ୍‌ରାଞ୍ଜି ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି ଡ, ଆନିନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଅବୟ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଇୟ୍‌ଲେ ତଙ୍କୁମେ, ଆରି ମନ୍‌ରାଞ୍ଜି ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ତୁୟାୟ୍‌ରେଙ୍‌ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ତି ଆ ବନେଡ଼ା ଆନିନ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେଞ୍ଜି, ଆନିନ୍‌ ଞନଙନ୍‌ ଆତ୍ରିୟେନ୍‌ ଆଡିଡ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ଅମ୍‌ଡଙ୍‌ବା, ଅବୟ୍‌ ବୁବ୍ବୁଡ୍‌ନେମରନ୍‌ ଜମ୍ମଲନ୍‌ ବୁବ୍ବୁଡନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ଆନିନ୍‌ ବୁଡା ବୁଡା ଲାଙ୍‌ଲେଡ୍‌ ଜମ୍ମଲନ୍‌ ଅନେଙ୍‌ ତଙରନ୍‌ ଗଲୋଏନ୍‌, ଆରି ଅନ୍ତିଡଞ୍ଜି ଜିର୍ରେ ତିଆତେ ଇୟ୍‌ଲାୟ୍‌ ଜୋମେଜି । ");
INSERT INTO juy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଅସୋୟ୍‌ ଲବନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଅରେଙ୍‌ଲଲୋଙନ୍‌ ଗଲୋଏନ୍‌, ଆରି ଗୋଗୋୟ୍‌ ଲବତଡନ୍‌ ଆସନ୍‌ ଲପଡାବ୍‌ଲାୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ବନ୍‌ଡ ଓୟୋଙନ୍‌ ଆଡ୍ରୁଙ୍‌ଲନାଞନ୍‌ ତିଆତେ ଜୋମ୍‌ତୋଡାଜେନ୍‌ ଆରି ମନଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଆଜଡ୍‌ନେନ୍‌ ଆସନ୍‌ ଅସରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଅବ୍ବାଙ୍‌ନୁବ୍‌ରେଙନ୍‌ ଗଲୋଏନ୍‌, ଆରି ଅବ୍ବାଙ୍‌ନୁବନ୍‌ ଡୋଲନ୍‌ ସୋଡ଼ାଲେ ତିଆତେଜି ଲଲ୍ଲଡାଜେନ୍‌ ଆରି ଇନ୍ନିଙ୍‌ ଅଃନ୍ନଜଲୋ । ");
INSERT INTO juy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ଆରି, ଲାଙ୍‌ଲେଡ୍‌ ଜମ୍ମଲନ୍‌ ମନଙ୍‌ ଲବଲୋଙନ୍‌ ଗଲୋଏନ୍‌, ତିଆତେ ପଡାବ୍‌ଲେ ସୋଡ଼ାଏନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତିରିସି ଗୁନା ସାଟିଏ ଗୁନା ଆରି ସଏ ଗୁନା ଜାୟ୍‌ ଅଜଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ଆରି ଜିସୁନ୍‌ ବର୍ରନେ, “ଆନା ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଆଲୁଡନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅମ୍‌ଡଙେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ଜିସୁନ୍‌ ଆତିନ୍‌ସଜନ୍‌ ଆଡ୍ରକୋଲନେନ୍‌ ଆଡିଡ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଆରମ୍‌ଡଙେଞ୍ଜି ଆ ମନ୍‌ରାଞ୍ଜି ଲାଙ୍‌ଲେନ୍ନେ, ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ “ଆମନ୍‌ ଇନିବା ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ଞନଙନ୍‌ ତିୟ୍‌ତେ ଆରି କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ ଇନି” ଗାମ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ସନସବର୍‌ଜି ଗନନ୍‌ଲୁଡନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବୋର୍ସାନ୍‌ ଆତିୟ୍‌ତିୟ୍‌, ବନ୍‌ଡ ତି ଆନ୍ନାମରଞ୍ଜିଆଡଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ବନରନ୍‌ ଡେତେ, ");
INSERT INTO juy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ‘ଆନିଞ୍ଜି ଗିଜାନ୍‌ ଗିଜାନ୍‌ ଅଃଜ୍ଜନାଏଜି, ଆରି ଅମ୍‌ଡଙାନ୍‌ ଅମ୍‌ଡଙାନ୍‌ ଅଃଗନ୍‌ଲୁଡେଜି, ଅସମୟ୍‌ ଆନିଞ୍ଜି ତିଆତେ ଜନାଡାଲେ, ଗନ୍‌ଲୁଡ୍‌ଲେ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ୟର୍ତନାଜି ଆରି କେମାନ୍‌ ଞାଙ୍‌ତଜି ।’” ");
INSERT INTO juy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, “ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଅଃଗନ୍‌ଲୁଡ୍‌ବେନ୍‌ ପଙ୍‌ ? ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନ୍ନା ଅନବ୍‌ଜଙ୍‌ବରଞ୍ଜି ଏଙ୍ଗାଲେ ଏଗନ୍‌ଲୁଡ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ବୁବ୍ବୁଡ୍‌ନେମରନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ବିଡ୍‌ତେ, ");
INSERT INTO juy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି କେନ୍‌ ଅନ୍ତମ୍‌ ଡକୋଜି, ଆନାଜି ଅମ୍‌ଡଙ୍‌ତଜି, ଆରି ଅମ୍‌ଡଙାନ୍‌ ଅମ୍‌ଡଙାନ୍‌ ସିଲତ୍ତେମା ଆମଙଞ୍ଜି ଆବ୍ରୁଡ୍‌ଲ୍ଲନେନ୍‌ ଆ ବର୍ନେଜି ସନୁମନ୍‌ ରାଉଡାଲନ୍‌ ଇୟ୍‌ତାୟ୍‌ ପାଙେ, ଆନିଞ୍ଜି ଜମ୍ମଲନ୍‌ ଆବ୍ରୁଡ୍‌ଲ୍ଲନେନ୍‌ ଅନେଙ୍‌ ତଙରନ୍‌ ଆ ଲବ ଅନ୍ତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ତିଅନ୍ତମ୍‌, ଆନାଜି ବର୍ନେନ୍‌ ଅମ୍‌ଡଙାନ୍‌ ଅମ୍‌ଡଙାନ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ତିଆତେ ଜାତଜି, ");
INSERT INTO juy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ବନ୍‌ଡ ଆମଙଞ୍ଜି ଆଜଡନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଲାମେନ୍‌ ଆସନ୍‌ ଗଡ୍ଡେଃ ମତ୍ରମ୍‌ ଡକୋତଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ବର୍ନେନ୍‌ ଆ ଲତ୍ତେଙ୍‌ଲୋଙ୍‌ ଡଣ୍ଡନ୍‌, ଡନଣ୍ଡାୟନ୍‌ ଞାଙେଞ୍ଜି ଡେନ୍‌, ଆନିଞ୍ଜି ସିଲତ୍ତେମା ଡର୍ନେନ୍‌ ଅମ୍‌ରେଙ୍‌ତଜି, ଆନିଞ୍ଜି ଜମ୍ମଲନ୍‌ ଆବ୍ରୁଡ୍‌ଲ୍ଲନେନ୍‌ ଅରେଙ୍‌ଲନ୍‌ ଅନ୍ତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ଆରି ଆନାଜି ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି, ଆରି ଅନମେଙନ୍‌ ଆନିଃୟମ୍‌, ଅନର୍ଜେନ୍‌ ଡ ଆନ୍ନା ଅନିଃୟମ୍‌ଜି ଗନ୍‌ଲେ ବର୍ନେନ୍‌ ଲାତ୍ତିନ୍‌ତେ, ଆରି ତିଆତେ ଅଃନ୍ନଜଏ, ");
INSERT INTO juy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ତି ଆ ମନ୍‌ରାଜି ଜମ୍ମଲନ୍‌ ଆବ୍ରୁଡ୍‌ଲ୍ଲନେନ୍‌ ଅବ୍ବାଙ୍‌ନୁବ୍‌ରେଙନ୍‌ ଆ ଲବ ଅନ୍ତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ଆରି, ଆନାଜି ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଲେ ତିଆତେ ଜାତଜି ଆରି ତିରିସି ଗୁନା, ସାଟିଏ ଗୁନା, ସଏ ଗୁନା ଅଜତଜି, ଆନିଞ୍ଜି ଜମ୍ମଲନ୍‌ ଆବ୍ରୁଡ୍‌ଲ୍ଲନେନ୍‌ ମନଙ୍‌ ଲବନ୍‌ ଅନ୍ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରି ବରେଞ୍ଜି, “ପିଙ୍କନ୍‌ ଇନି ମାଡ଼ିଞନ୍‌ ଆ ଜାୟ୍‌ତା ଅଡ଼େ କଟନ୍‌ ଆ ଜାୟ୍‌ତା ଡନକ୍କୋନ୍‌ ଆସନ୍‌ ପଙ୍‌ ତନରନ୍‌ ଡେତେ ? ପିଙ୍କପିଲନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଡନକ୍କୋନ୍‌ ଆସନ୍‌ ପଙ୍‌ ତିଆତେ ତନରନ୍‌ ଅଃଡ୍ଡେଏ ? ");
INSERT INTO juy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏର୍‌ନବ୍‌ଗିୟ୍‌ତାନ୍‌ ଆସନ୍‌ ଇନ୍ନିଙ୍‌ ଆସସ ତଡ୍‌, ଆରି ଅଙ୍ଗାତେ ଆସସ ଡକୋ, ତିଆତେ ଅନବ୍‌ଗିୟ୍‌ତାନ୍‌ ଆସନ୍‌ ଆସସ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ଆନା ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଆଲୁଡନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅମ୍‌ଡଙେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ଜିସୁନ୍‌ ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନି ଏଅମ୍‌ଡଙ୍‌ତେ, ତିଆତେ ଆସନ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା । ଅଙ୍ଗା ଆ ତନରେଡ୍‌ଲୋଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏତରେଡ୍‌ତେ, ତି ଆ ତନରେଡ୍‌ଲୋଙ୍‌ ଇସ୍ୱରନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ତରେଡ୍‌ଲେ ତିୟ୍‌ତବେନ୍‌, ଆରି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଗୋଗୋୟ୍‌ ତନିୟନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ଆମଙ୍‌ ଡକୋ, ଆନିନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ, ଆରି ଆନା ଆମଙ୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌, ଆମଙନ୍‌ ଇନି ଡକୋ, ତିଆତେ ନିୟ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ପନାଙନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଜିସୁନ୍‌ ଆରି ବର୍ରନେ, “ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ କେନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ ବସେଙ୍‌ଲୋଙନ୍‌ ଜମ୍ମଲନ୍‌ ବିଡ୍‌ତେ, ");
INSERT INTO juy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ଆନିନ୍‌, ତଗଲନ୍‌ ଡିମଡ୍‌ତନେ ତମ୍‌ବାନ୍‌ ଡୋତନେ, ଆରି ଜମ୍ମଲନ୍‌ ଏଙ୍ଗାଲେ ପଡାବ୍‌ଲେ ସୋଡ଼ାତେ, ତିଆତେ ଆନିନ୍‌ ଅଃଜ୍ଜନାଏ । ");
INSERT INTO juy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ଲବନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଜଅନ୍‌ ଅବ୍‌ଜତେ, ପର୍ତମ୍ମୁ ଆ ଅଲାନ୍‌, ତିକ୍କି ସିସାନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସିସାଲୋଙନ୍‌ ବରିୟ୍‌ ଜନ୍‌ରୋମନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ବନ୍‌ଡ ଜନ୍‌ରୋମନ୍‌ ଅଗୁରେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଗଡ୍‌ଗଡ୍‌ନେ ବେଡ଼ାନ୍‌ ଅଡ଼ୋଲାୟ୍‌ ଡେନ୍‌ ଆନିନ୍‌ କଡ଼ତ୍ତିନ୍‌ ବାତ୍ତେ ଗଡ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“ଜିସୁନ୍‌ ଆରି ବର୍ରନେ, ଇନ୍‌ଲେଞ୍ଜି ଆନା ସରିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଜଙ୍‌ବୋ ? ଅଙ୍ଗା ଆନବ୍‌ଜଙ୍‌ବର୍‌ ବାତ୍ତେ ତିଆତେ ବର୍ନେବୋ ? ");
INSERT INTO juy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ତିଆତେ ଅବୟ୍‌ ସୋର୍ସୋବାୟନ୍‌ ଅନ୍ତମ୍‌, ଲବଲୋଙନ୍‌ ଆବ୍ରୁଡ୍‌ଲ୍ଲନେନ୍‌ ଆଡିଡ୍‌ ତିଆତେ ପୁର୍ତିଲୋଙନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆବାୟ୍‌ ସିଲଡ୍‌ ସନ୍ନା, ");
INSERT INTO juy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ବନ୍‌ଡ ବୁଡ୍‌ଲନ୍‌ ଡେନ୍‌ ତିଆତେ ସୋଡ଼ାଡାଲେ ଡୋତନେ ଆରି କୋତ୍ତାଲୋଙନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ଓଆବ୍‌ଜି ସିଲଡ୍‌ ତିଆତେ ସୋଡ଼ାତେ, ଆରି ଆ କେଣ୍ଡାରଞ୍ଜି ଏତ୍ତେଲେ ସୋଡ଼ାରାତେ ଡ, ତି ଆରାନୁବ୍‌ ଆ ଲୁମ୍ମୁଲୋଙନ୍‌ ଅନ୍ତିଡଞ୍ଜି ଇୟ୍‌ତାୟ୍‌ ବସାନେଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ଆନିନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଗୋଗୋୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ରପ୍ତି ଆଗ୍ରନ୍‌ଲୁଡ୍‌ତେଞ୍ଜି ଅନ୍ତମ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ଆରି ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆନିନ୍‌ ଆମଙଞ୍ଜି ଅନ୍ନିଙ୍‌ ଆ ବର୍ନେ ଅଃବ୍ବର୍ରନେ । ବନ୍‌ଡ ଆନିନ୍‌ ଆତିନ୍‌ସଜନ୍‌ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ତି ଆ ଡିନ୍ନା ଆସ୍ରାଲ୍ଲୁମେନ୍‌ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ୟବା, ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଏଜିର୍ବା ।” ");
INSERT INTO juy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ, ଜିସୁନ୍‌ ଅଙ୍ଗା ଡୋଙ୍ଗାଲୋଙ୍‌ ତଙ୍କୁମ୍‌ଲେ ଡକୋଲନେ ତି ଆ ଡୋଙ୍ଗାଲୋଙ୍‌ ଡାଜେଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଓରୋଙେଞ୍ଜି, ଆରି ଆନ୍ନା ଡୋଙ୍ଗାଞ୍ଜି ନିୟ୍‌ ଆମଙଞ୍ଜି ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ତିକ୍କି, ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ଆକ୍ରାନ୍‌ ରିଙ୍ଗେତିରନ୍‌ ଅଡ଼ୋଲାୟ୍‌, ଆରି ଅଡ୍ଡୋୟ୍‌ଡାନ୍‌ ଆତ୍ରଙ୍‌ଞାଲାଞନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାଆନ୍‌ ବରିୟ୍‌ଲେ ପାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଡୋଙ୍ଗାନ୍‌ ଆ ତିକ୍କିଗଡ୍‌ ଅନିବବ୍‌ଲୋଙନ୍‌ ଆବବନ୍‌ ଡକ୍କୋଡାଲେ ଲୁଡ୍‌ଲେ ଡକୋଲନ୍‌, ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ତର୍ତର୍ରେ ବରେଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ରବୁଲଲେନ୍‌, ଆମନ୍‌ ଇନ୍ନିଙ୍‌ ପଙ୍‌ ଅଃନ୍ନିୟମେ ?” ");
INSERT INTO juy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଡୋଲନ୍‌ ରିଙ୍ଗେନ୍‌ ବବ୍‌ତଙ୍‌ଡାଲେ ଅଡ୍ଡୋୟ୍‌ଡାନ୍‌ ବରେନ୍‌, “କଡ଼ିଙା, ରିଙ୍‌ ଗାମ୍‌ଲେ ଡକୋନା ।” ସିଲତ୍ତେ ରିଙ୍ଗେନ୍‌ ତଡେନ୍‌ ଆରି ଅଡ଼୍‌କୋନ୍‌ ରିଙ୍‌ରିଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନିବା ଡିୟ୍‌ନେ ଆ ବନ୍ତଙିୟ୍‌ଜି ? ନମିନ୍ତାନ୍‌ ପଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଃଡ୍ଡର୍ନେ ?” ");
INSERT INTO juy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆକ୍ରାନ୍‌ ବତଙ୍‌ଡାଲେ ତର୍ଡମ୍‌ ଅଲ୍‌ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ଆନିନ୍‌ ଆନା, ରିଙ୍ଗେନ୍‌ ଡ ଅଡ୍ଡୋୟ୍‌ଡାନ୍‌ ନିୟ୍‌ କେନ୍‌ ଆ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି ?” ");
INSERT INTO juy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଗାଲିଲି ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଗରାସିଅଞ୍ଜି ଆମଙ୍‌ରେଙ୍‌ ଅଡ଼ୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ଆନିନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ସିଲଡ୍‌ ପନ୍ନାନ୍‌ ପନ୍ନାନ୍‌ ତେରଙ୍‌ ଅବୟ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରା ମସାନ୍ନିନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରବାଙେ । ");
INSERT INTO juy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ତି ଆ ମନ୍‌ରା ମସାନ୍ନିଲୋଙନ୍‌ ଡକୋଲନେ, ଆରି ଆନ୍ନିଙ୍‌ଜା ଆନିନ୍‌ଆଡଙ୍‌ ସିଙ୍କୁଡ଼ିନ୍‌ ବାତ୍ତେ ନିୟ୍‌ ଜିଲେ ଅଃର୍ରପ୍ତିଲଜି, ");
INSERT INTO juy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜବ୍ର ତର କାଡୁନ୍‌ ଡ ସିଙ୍କୁଡ଼ିନ୍‌ ବାତ୍ତେ ଜିଏଞ୍ଜି, ବନ୍‌ଡ ଆନିନ୍‌ ସିଙ୍କୁଡ଼ିନ୍‌ ଅବ୍‌ତଃଡାଲେ କାଡୁଞ୍ଜି ଲବ୍‌ଗଡାଜେନ୍‌ ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ମବ୍‌ଲଁୟ୍‌ଲେ ଡନକ୍କୋନ୍‌ ଆସନ୍‌ ଆନ୍ନିଙ୍‌ ବପ୍ପୁ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ଆନିନ୍‌ ତଗଲ୍‌ ତମ୍‌ବା ଡିତାନ୍‌ ମସାନ୍ନିରେଙନ୍‌ ଡ ବରୁରେଙନ୍‌ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ସଜିର୍ରେ ଡକୋଲନ୍‌, ଆରି ଆନିନ୍‌ ଅରେଙନ୍‌ ବାତ୍ତେ ତିଡ୍‌ଲନ୍‌ ପାବ୍‌ରାଡମ୍‌ଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ଆନିନ୍‌ ସଙାୟ୍‌ ସିଲଡ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଇର୍ରେ ଆ ମୁକ୍କାଗଡନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତୁଡ଼ୁମେ, ");
INSERT INTO juy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ଆରି ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ସଜିର୍ରେ ବର୍ରନେ, “ଏ ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆ ଇସ୍ୱର ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିସୁ, ଆମନ୍‌ ସରିନ୍‌ ଞେନ୍‌ ଇନି ଡକୋ ? ଇସ୍ୱରନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଅମଙ୍‌ନମ୍‌ କାକୁର୍ତିତନାୟ୍‌, ଞେନ୍‌ଆଡଙ୍‌ ଆରି ଡଣ୍ଡାୟ୍‌ଡଙିଂ ।” ");
INSERT INTO juy_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ା, କେନ୍‌ ଆ ମନ୍‌ରା ଆମଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରା ।” ");
INSERT INTO juy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ଆରି, ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅଞୁମ୍‌ନମ୍‌ ଇନି ?” ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଅଞୁମ୍‌ଞେନ୍‌ ଆକୁଡ଼ାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ଆରି, ଜିସୁନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତିସେଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆନ୍ନାରେଙ୍‌ ଆପ୍ପାୟ୍‌ଡଙେଜି ତଡ୍‌ ତିଆସନ୍‌ ଆନିନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ କାକୁର୍ତିଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ତେତ୍ତେ ବରୁନ୍‌ ଆ ତୟ୍‌ତୟ୍‌ ଅବୟ୍‌ ଗୋସ୍ସାବୋନନ୍‌ ଜୋମ୍‌ଜୋମ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ଆରି, ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ କାକୁର୍ତିଡାଲନ୍‌ ବର୍ରଞ୍ଜି, “ତି କିମ୍ୱୋନଞ୍ଜି ଆ ଅମ୍ମ ଗଙ୍ଗନନ୍‌ ଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ “ଜିର୍ବା” ଆଗ୍ରାମେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ କିମ୍ୱୋନଞ୍ଜି ଆ ଅମ୍ମ ଇୟ୍‌ଲେ ଗନେଜି, ସିଲତ୍ତେ ତି ଗୋସ୍ସାବୋନନ୍‌ ଆ ତୟ୍‌ତୟ୍‌ବୁରନ୍‌ ସିଲଡ୍‌ ଆକ୍ରାନ୍‌ ଇର୍ରେ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ତବୁବ୍‌ଡାଲେ ଇୟ୍‌ଲେ ରବୁଏଜି । କିମ୍ୱୋନଞ୍ଜି ବାଗୁ ଅଜାର ଡେତେ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ତୁର୍‌ବୋନ୍‌ମରଞ୍ଜି ଜିର୍ରେ ଗଡ଼ାରେଙନ୍‌ ଡ ସାଇରେଙନ୍‌ ତି ଆ ବର୍ନେ ଇୟ୍‌ଲେ ଅବ୍‌ଜନାଏଜି, ସିଲତ୍ତେ ଇନି ଡେଏନ୍‌ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଗିୟ୍‌ଗିୟ୍‌ବାନ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ଆରି, ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ, ଅଙ୍ଗା ମନ୍‌ରାଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଆକୁଡ଼ାୟ୍‌ ବୁତନ୍‌ ଆସୁମ୍‌ସୁମ୍‌ ଡକୋଏନ୍‌, ତି ଆ ମନ୍‌ରା ସିନ୍‌ରିନ୍‌ ରଲନ୍‌ ମନଙ୍‌ ବୁଡ୍ଡିନ୍‌ ବାତ୍ତେ ଆତଙ୍କୁମନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ଆରି, ଅଙ୍ଗା ମନ୍‌ରାଜି ଗିଜେଞ୍ଜି, ଆନିଞ୍ଜି ତି ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରା ଇନି ଏଙ୍ଗାଗୋ ଡେଏନ୍‌ ତି ଆ ବର୍ନେ, ଆରି କିମ୍ୱୋନଞ୍ଜି ଆ ବର୍ନେ ନିୟ୍‌ ଆମଙଞ୍ଜି ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ସିଲତ୍ତେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆ ସଣ୍ଡିଞ୍ଜି ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି କାକୁର୍ତିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଆଡ୍ରାଜେନ୍‌ ଆଡିଡ୍‌, ଅଙ୍ଗା ମନ୍‌ରାଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ବୁତନ୍‌ ଆସୁମ୍‌ସୁମ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ଜିସୁନ୍‌ ସରିନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ନମିନ୍‌ କି ନମିନ୍‌ କାକୁର୍ତିଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ବନ୍‌ଡ ଜିସୁନ୍‌ ଅସାଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କୁଲମ୍‌ନମ୍‌ଜି ଆମଙ୍‌ ଅସିଂନମ୍‌ ଜିରା, ଆରି ପ୍ରବୁନ୍‌ ଆମନ୍‌ ଆସନ୍‌ ଇନିଜି ଇନିଜି ଲୁମେନ୍‌ ଆରି ଆମନ୍‌ଆଡଙ୍‌ ଆରବ୍‌ତୁୟ୍‌ଲମନ୍‌ ଆ ସନାୟୁମ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଇୟ୍‌ନବ୍‌ଜନାଆଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ତିଆସନ୍‌ ଆନିନ୍‌ ଜିର୍ରେ, ଜିସୁନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇନିଜି ଇନିଜି ଆ କାବ୍ବାଡ଼ା ଲୁମେନ୍‌, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଦେକାପାଲିଲୋଙନ୍‌ କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ ଦସଟା ଗଡ଼ାଲୋଙନ୍‌ ବର୍ବର୍ରେ ପାଙେନ୍‌, ସିଲତ୍ତେ ଅଡ଼୍‌କୋଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ଜିସୁନ୍‌ ଆରି ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ବାନ୍ନେଗଡ୍‌ ପଡ୍‌ଲେ ଆୟର୍ରନାଞନ୍‌, ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି, ଆରି ଆନିନ୍‌ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ତି ଆ ବନେଡ଼ା ରନୁକ୍କୁସିଙନ୍‌ ଆ ସୋଡ଼ାମର୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଜାଇରସ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଆଜଙ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଅବ୍‌ସେଡ୍‌ନେ, ");
INSERT INTO juy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ଆରି ମାଡ୍ଡ କାକୁର୍ତିଲନ୍‌ ବର୍ରନେ, “ଡାଙ୍ଗଡ଼ିଅନ୍‌ଞେନ୍‌ ଆରବୁଗୋ ଡେଏନ୍‌, ଆନିନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅମେଙେ, ତିଆସନ୍‌ ଆମନ୍‌ ଜିର୍ରେ ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ଅସିନମ୍‌ ଆୟ୍‌ ଡକ୍କୋଆ ।” ");
INSERT INTO juy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆରି ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ କଣ୍ଡୋଙ୍‌ଗଡନ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି, ଆରି ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ରାବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ତି ଆ ବନେଡ଼ା ବାର ବର୍ସେଙ୍‌ ଜାୟ୍‌ ପ୍ରଦରରୋଗନ୍‌ ଆଞାଙ୍‌ଞାଙ୍‌ ଅବୟ୍‌ ଆଇମରନ୍‌ ଡକୋଏନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ଆନିନ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେଲେ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ବୈଡମରଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ସାକ୍କେଡାଲନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ତଙ୍କାନ୍‌ କର୍ସଆଜେନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ଇନ୍ନିଙ୍‌ ଅଃମ୍ମନଙ୍‌ଲୋ ଆର୍ପାୟ୍‌ ଗୋଗୋୟ୍‌ଲେ ପାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ଆନିନ୍‌ ଜିସୁନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆ ରୁକ୍କୁମର୍‌ରେଙନ୍‌ ଆ କଣ୍ଡୋଙ୍‌ଗଡ୍‌ ଜିର୍ରେ ଆ ସିନ୍‌ରିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ସୁଙେଏ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଗାମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“ଆ ସିନ୍‌ରିନ୍‌ ତୁମ୍‌ ସୁଙେଲାୟ୍‌ ଡେନ୍‌ ଞେନ୍‌ ମନଙ୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ସିଲତ୍ତେମା ଆ ମିଞାମନ୍‌ ଅଞଡେନ୍‌, ଆରି ଆନିନ୍‌ ଆ ରୋଗନ୍‌ ମନଙେନ୍‌ ଗାମ୍‌ଲେ ଆନିନ୍‌ଡମ୍‌ ରପ୍ତି ଅମ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ସିଲତ୍ତେମା ଜିସୁନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ବୋର୍ସାନ୍‌ ଜିରେନ୍‌ ଗାମ୍‌ଲେ ରପ୍ତି ଜନାଡାଲେ, ଆନିନ୍‌ ଆରୁକ୍କୁମର୍‌ରେଙନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ବର୍ରନେ, “ଆନା ସିନ୍‌ରିଞେନ୍‌ ସୁଙେଏନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମନ୍‌ ତ ଗିୟ୍‌ତେ, ମନ୍‌ରାଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ରାବ୍‌ତମ୍‌ଜି, ଆରି ଆମନ୍‌ ଗାମ୍‌ତେ, ‘ଆନା ଞେନ୍‌ଆଡଙ୍‌ ସୁଙେଲିଁୟ୍‌ ?’” ");
INSERT INTO juy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ବନ୍‌ଡ ଆନା କେନ୍‌ଆତେ ଲୁମେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ ଏର୍ରେ ଆଙାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ସିଲତ୍ତେ ତି ଆଇମରନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇନି ଡେଏନ୍‌, ତିଆତେ ଜନାଡାଲେ ବନ୍ତଙନ୍‌ ବାତ୍ତେ ତକର୍‌ ତକର୍ରେ ଜିର୍ରେ ଜିସୁନ୍‌ ଆଜଙ୍‌ଲୋଙ୍‌ ଅବ୍‌ସେଡ୍‌ଲନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆମଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ । ");
INSERT INTO juy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ନୁନ୍ନି, ଡର୍ନେନମ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲମ୍‌, ଲବିଡ୍ଡା ଜିରା ଆରି ରୋଗନମ୍‌ ମନଙମ୍‌ତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ଆନିନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆବର୍ରନେନ୍‌ ଆଡିଡ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ଆ ସୋଡ଼ାମର୍‌ ଜାଇରସନ୍‌ ଆସିଂ ସିଲଡ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିର୍ରେ, “ଡାଙ୍ଗଡ଼ିଅନ୍‌ନମ୍‌ ରବୁଏନ୍ନି, ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ଆଡଙ୍‌ ଇନିବା ଆରି ବାଉଲ୍ଲି ଏମ୍ମେତେ ?” ଇୟ୍‌ଲାୟ୍‌ ଗାମେଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ ବର୍ନେଞ୍ଜି ଅମ୍‌ଡଙ୍‌ଡାଲେ, ଅଃନ୍ନମ୍‌ଡଙ୍‌ଲନ୍‌ ଅନ୍ତମ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ଆ ସୋଡ଼ାମର୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ବତଙ୍‌ଡଙମ୍‌, ଡର୍ନା ତୁମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଜିସୁନ୍‌ ପିତ୍ରନ୍‌, ଜାକୁବନ୍‌ ଡ ଆ ବୋଞାଙନ୍‌ ଜନନ୍‌ ତୁମ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ଜିରେଞ୍ଜି, ଆରି ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ଅଃନ୍ନୋରୋଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ଆନିଞ୍ଜି ରନୁକ୍କୁସିଙନ୍‌ ଆ ସୋଡ଼ାମର୍‌ ଆସିଂ ଆଜିର୍ରାଞଞ୍ଜି, ତେତ୍ତେ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ୟୋଙ୍‌ୟାଙନ୍‌ ଡ ଆକ୍ରାନ୍‌ ୟନେନ୍‌ ଆରେମ୍ମେତନେଞ୍ଜି ଆନିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେ, ");
INSERT INTO juy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ଆରି ଜିସୁନ୍‌ ଅମ୍ମନ୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, “ଇନିବା ଏୟୋଙ୍‌ୟାଙ୍‌ତେ ଇନିବା ଏୟେତେ ? ପସିଜନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ରବୁଏ, ଆର୍ପାୟ୍‌ ଆଲୁଡ୍‌ଲୁଡ୍‌ ।” ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଗବ୍‌ରଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ବନ୍‌ଡ ଆନିନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ପସିଜନ୍‌ ଆ ବାପା, ଆୟୋଙନ୍‌ ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ଓରୋଙ୍‌ଡାଲେ, ପସିଜନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋଏନ୍‌, ତେତ୍ତେ ଇୟେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ପସିଜନ୍‌ ଆସି ଞମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଟଲିତାକୁମ୍‌,” କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ “ଏ ଆଇସିୟ୍‌, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, ଡୋନା ।” ");
INSERT INTO juy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ସିଲତ୍ତେମା ଆଇସିଜନ୍‌ ଡୋଲନ୍‌ ଅଡ଼େତ୍ତେ ଅଡ଼େନ୍ନେ ବୁଲ୍ଲେଏନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ବାର ବର୍ସେଙ୍‌ ଡେଏନ୍‌ । ତିଆସନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଆକ୍ରାନ୍‌ ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ଆରି, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନ୍ନିଙ୍‌ଜା କେନ୍‌ ଆ ବର୍ନେ ଜନାଡଙେଜି ତଡ୍‌, ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ବରେଞ୍ଜି, ଆରି ଆଇସିଜନ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଗାଗାନେନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଜିର୍ରେ ଆ ସାଇଡମନ୍‌ ନାଜରିତନ୍‌ ୟର୍ରନାୟ୍‌ ଆରି ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌, ଆନିନ୍‌ ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ, ଆରି, ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଲେ ସାନ୍ନିଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆ ମନ୍‌ରା କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅଡ଼େଙ୍ଗା ସିଲଡ୍‌ ଞାଙେନ୍‌ ? ଆରି, କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗା ଗିଆନ ତନିୟନ୍‌ ଡେଲୋ ? ଆରି କେନ୍‌ ଆସିଲୋଙନ୍‌ ଆଡ୍ରେତେନ୍‌ ଆ ବୋର୍ସା କାବ୍ବାଡ଼ାଜି ଅଡ଼୍‌କୋନ୍‌ ଇନି ? ");
INSERT INTO juy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","କେନ୍‌ ଆନିନ୍‌ ତି ବାଡ୍ଡୋଁୟ୍‌ମରନ୍‌ ତଡ୍‌ ପଙ୍‌ ? କେନ୍‌ ଆନିନ୍‌ ମରିଅମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ତଡ୍‌ ପଙ୍‌, ଆରି ଜାକୁବନ୍‌, ଜୋସିନ୍‌, ଜିଉଦାନ୍‌ ଡ ସିମନନ୍‌ ଆ ବୋଞାଙ୍‌ଜି ତଡ୍‌ ପଙ୍‌ ? ଆରି, କେନ୍‌ ଆ ତନାନଞ୍ଜି ଇନ୍‌ଲେଞ୍ଜି ସରିନ୍‌ ତେନ୍ନେଞ୍ଜି ତଡ୍‌ ପଙ୍‌ ?” ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାଲଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, “ଆନ୍ନାରେଙନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ଆଡଙ୍‌ ଜାତଜି, ବନ୍‌ଡ ଆ ସାଇଡମନ୍‌, ଆ କୁଲମଞ୍ଜି, ଆସିଂଡମନ୍‌ ଆ ମନ୍‌ରାଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାଏଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ଆରି, ତେତ୍ତେ ଇନ୍ନିଙ୍‌ ବୋର୍ସା କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ଲେ ଅଃର୍ରପ୍ତିଲୋ, ଅସୋୟ୍‌ ରୋଗମରଞ୍ଜି ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ତୁମ୍‌ ଆସିନ୍‌ ଡକ୍କୋଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ଆରି, ଆନିଞ୍ଜି ଅଃଡ୍ଡର୍ରନେଞ୍ଜି ଆସନ୍‌ ଜିସୁନ୍‌ ସାନ୍ନି ଡେଏନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ସମ୍ପରା ସାଇ ସାଇ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ଞନଙନ୍‌ ଇୟ୍‌ଲେ ତିଏ । ");
INSERT INTO juy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ବାରଜଣଞ୍ଜିଆଡଙ୍‌ ଆମଙନ୍‌ ଓଡ୍ଡେଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବାଗୁ ବାଗୁନେ ଅମ୍ମେଲେ ଅନାପ୍ପାୟନ୍‌ ଆସନ୍‌ ଉଲନେ, ଆରି ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜି ଆ ଉପରେଙ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ତିୟେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ଆରି, “ଜିର୍‌ଜିରନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ତୁଡ଼େଡାଙ୍‌ ତୁମ୍‌ ପାଙ୍‌ବା, ଆରି ରୁଟି, ମୁନା କି ଗାଞ୍ଜିଆଲୋଙନ୍‌ ଡାବ୍ବୋନ୍‌ ଏପାଙ୍‌ଡଙ୍‌” ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ବନ୍‌ଡ ଆନିଞ୍ଜିଆଡଙ୍‌ ପାଣ୍ଡୋୟନ୍‌ ରନେନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି, “ବାଗୁ ଅଙ୍ଗିନ୍‌ ଏପାଙ୍‌ଡଙ୍‌” ଗାମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅନ୍ନିଙ୍‌ ଆସିଂ ଆ ମନ୍‌ରାଜି ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଜାଲବେଞ୍ଜି ଡେନ୍‌, ତି ଆ ସାଇ ସିଲଡ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏଜିରେନ୍‌ ଜାୟ୍‌ ତି ଆସିଂ ଇୟ୍‌ ଡକୋନାବା । ");
INSERT INTO juy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ବନ୍‌ଡ ଅନ୍ନିଙ୍‌ ଆ ସାଇ ଆ ମନ୍‌ରାଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଃଜ୍ଜାଲବେଞ୍ଜି ଡେନ୍‌, ଅଡ଼େ ବର୍ନେବେଞ୍ଜି ଅଃନ୍ନମ୍‌ଡଙ୍‌ଲଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ବା, ଆରି ଏଜିରେନ୍‌ ଆଡିଡ୍‌ ଆମଙଞ୍ଜି ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ତାଲ୍‌ଜଙ୍‌ବେନ୍‌ ଆ ଉମ୍ରିଲ ତୁୟ୍‌ତୁୟ୍‌ନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଜିର୍ରେ, “ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନାବା,” ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ଜବ୍ର ମନ୍‌ରାଜି ଆମଙ୍‌ ସିଲଡ୍‌ ବୁତନ୍‌ ଗଙେଞ୍ଜି ଆରି ଜବ୍ରଡମ୍‌ ରୋଗମରଞ୍ଜିଆଡଙ୍‌ ମିଞଲନ୍‌ ଜଡ୍‌ଲେ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ଜିସୁନ୍‌ ଆଞୁମ୍‌ ସମ୍ପରାନ୍‌ ଆଜ୍ରନାଏଞ୍ଜି ଏରୋଦ ରାଜାନ୍‌ ନିୟ୍‌ ଜିସୁନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙେନ୍‌, ଆରି ମନ୍‌ରାଞ୍ଜି ବର୍ରଞ୍ଜି, “ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋଲନେ, ତିଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋ ବୋର୍ସା କାବ୍ବାଡ଼ାନ୍‌ ଆମଙନ୍‌ ଗଡେଲ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ବନ୍‌ଡ ଆନ୍ନାମରଞ୍ଜି ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆନିନ୍‌ ଏଲିଅନ୍‌,” ଆରି ଲାଙ୍‌ଲେନ୍ନେ ବର୍ରଞ୍ଜି, “ପୁର୍ବାନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଅବୟ୍‌ନେ ଅନ୍ତମ୍‌ କେନ୍‌ ଆନିନ୍‌ ନିୟ୍‌ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ବନ୍‌ଡ ଏରୋଦନ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ବର୍ରନେ, “ଅଙ୍ଗା ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଞେନ୍‌ ଗବ୍ବାଲାୟ୍‌, ଆନିନ୍‌ ଡୋଲନେ !” ");
INSERT INTO juy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏରୋଦନ୍‌, ଆ ବୋଞାଙନ୍‌ ପିଲିପନ୍‌ ଆ ଡୁକ୍ରି ଏରୋଦିଆନ୍‌ ଆଡ୍ରକ୍କୋଏନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ସର୍ଡାନ୍‌ ଆସନ୍‌ ଏରୋଦନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆପ୍ପାୟ୍‌ଡାଲେ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ, ଜିଲେ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକ୍କୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଏରୋଦନ୍‌ଆଡଙ୍‌ ବର୍ବର୍ରଏନ୍‌, “ବୋଞାଙ୍‌ନମ୍‌ ଆ ଡୁକ୍ରି ଆମନ୍‌ ଡରକ୍କୋଏନ୍‌ ଆମନ୍‌ ଆସନ୍‌ କେନ୍‌ଆତେ ଅନଗଡନ୍‌ ଇଜ୍ଜା ।” ");
INSERT INTO juy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ସିଲତ୍ତେ ଏରୋଦିଆନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡେନ୍‌ ଆରି ରନବ୍ବୁନ୍‌ ସାଜେନ୍‌, ବନ୍‌ଡ ଅଃର୍ରପ୍ତିଲୋ । ");
INSERT INTO juy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌, ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଅବୟ୍‌ ଡରମ୍ମମର୍‌ ଆରି ମଡ଼ିର୍‌ମର୍‌ ଗାମ୍‌ଲେ ଏରୋଦନ୍‌ ଜନାଡାଲେ ବତଙେନ୍‌, ଆରି ଏରୋଦନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ଆସନ୍‌ ଏରେନ୍‌ ଗୋଜେନ୍‌, ଆରି ଆ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆକ୍ରାନ୍‌ ବତଙେନ୍‌, ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ତିଆତେ ଅମ୍‌ଡଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ତିକ୍କି ଏରୋଦିଆନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ରୟଙ୍‌ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋଲାୟ୍‌ । ଏରୋଦନ୍‌ ଆ କରୋକ୍କୋଡ୍‌ ଡିନ୍ନାଇଙନ୍‌ ମନ୍ତ୍ରିଞ୍ଜି, ସୋଡ଼ା ସିପ୍ପାୟଞ୍ଜି, ଡ ଗାଲିଲିନ୍‌ ଆ ସୋଡ଼ା ସୋଡ଼ା ମନ୍‌ରାଞ୍ଜି ଆସନ୍‌ ତଗଲନ୍‌ ଅବୟ୍‌ ବୁଜିନ୍‌ ତୁବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ଆରି, ଏରୋଦିଆନ୍‌ ଆ ଡାଙ୍ଗଡ଼ିଅନ୍‌ ଅମ୍ମନ୍‌ ଜିର୍ରେ ତଙ୍‌ସେଙ୍‌ଡାଲନ୍‌ ଏରୋଦନ୍‌ ରାଜାନ୍‌ ଡ ଆନିନ୍‌ ମାୟଲନ୍‌ ଆଗ୍ରାଗାଲଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଅବ୍‌ମଅଁଞେଞ୍ଜି । ତିଆସନ୍‌ ରାଜାନ୍‌ ଆଇସିଜନ୍‌ଆଡଙ୍‌ ଗାମେନ୍‌, “ଇନି ଲଡୟ୍‌ତମ୍‌, ବେଡିଁୟ୍‌, ଞେନ୍‌ ତିଆତେ ଆମନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ଆରି, ଆନିନ୍‌ ଆମଙନ୍‌ ବାସାଡାଲନ୍‌ ବର୍ରନେ, “ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗାତେ ବେଡ୍‌ତିଁୟ୍‌, ବବନ୍ତା ରାଜ୍ୟନ୍‌ ନିୟ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ତିଆସନ୍‌ ଆନିନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଆୟୋଙନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେ, “ଞେନ୍‌ ଇନି ବେଡାୟ୍‌ ?” ସିଲତ୍ତେ ଆୟୋଙନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗାମେନ୍‌, “ଆମନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆବବ୍‌ ଇୟ୍‌ ବେଡା ।” ");
INSERT INTO juy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ସିଲତ୍ତେମା ଆନିନ୍‌ ରାଜାନ୍‌ ଆମଙ୍‌ ଲଜିର୍ରେ ଇୟ୍‌ଲେ ବର୍ନେ, “ଆମନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆବବ୍‌, ଅବୟ୍‌ ସଡ଼ୁଆଲୋଙନ୍‌ ନମିଞେନ୍‌ମା ତିୟିଁୟ୍‌, କେନ୍‌ଆତେ ଲଡୟ୍‌ଞେନ୍ ।” ");
INSERT INTO juy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","କେନ୍‌ ଆସନ୍‌ ରାଜାନ୍‌ ମାଡ୍ଡ ଡୁକ୍କଲନ୍‌, ଜନଙ୍‌ଡେନ୍‌ ଆନିନ୍‌ ବାସାଲନ୍‌ ଆରି ତେତ୍ତେ ଗାଗାନେନ୍‌ ଆତ୍ରଙ୍କୁମେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆସନ୍‌ ଇଜ୍ଜା ଅଃଗାମ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ତିଆସନ୍‌ ରାଜାନ୍‌ ସିଲତ୍ତେମା ଅବୟ୍‌ ସିପ୍ପାୟନ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆବବ୍‌ ପନାଙନ୍‌ ଆସନ୍‌ ବରେନ୍‌ । ସିଲତ୍ତେ ଆନିନ୍‌ ଜିର୍ରେ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ଗବ୍ବାଏ, ");
INSERT INTO juy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ଆରି ତିଆତେ ଅବୟ୍‌ ସଡ଼ୁଆଲୋଙନ୍‌ ପାଙ୍‌ଲେ ରାଜାନ୍‌ ଆଇସିଜନ୍‌ଆଡଙ୍‌ ତିୟେ, ଆରି ଆଇସିଜନ୍‌ ତିଆତେ ପାଙ୍‌ଲେ ଆୟୋଙନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ତିୟେ । ");
INSERT INTO juy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ତି ଆ କବର ଅମ୍‌ଡଙ୍‌ଡାଲେ ଜିର୍ରାଜି କି ଆ ମରାନ୍‌ ପାଙ୍‌ଲେ ମସାନ୍ନିଲୋଙନ୍‌ ଇୟ୍‌ଲେ ତିଲେଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ତିକ୍କି ଅନାପ୍ପାୟଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି, ଆରି ଆନିଞ୍ଜି ଇନିଜି ଇନିଜି ଇୟ୍‌ଲେ ଲୁମେଞ୍ଜି ଆରି ଇନିଜି ଇନିଜି ଞନଙନ୍‌ ଇୟ୍‌ଲେ ତିଏଜି, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଅବ୍‌ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ମବା, ଆନ୍ନାଡାଲନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଅବୟ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଜିର୍ରେ ବସନ୍ନେଃ ଏଲୋଲୋନାୟ୍‌ବା ।” ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିରେଞ୍ଜି ଜିର୍ରାଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଗାଗାନେନ୍‌ ଆସନ୍‌ ନିୟ୍‌ ଅଃର୍ରୟଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଡ ଞଙ୍‌ନେମରଞ୍ଜି ଆନ୍ନାଡାଲନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ଅବୟ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ବନ୍‌ଡ ଆନିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେଞ୍ଜି ଜବ୍ର ମନ୍‌ରାଜି ଗିଜେଞ୍ଜି ଆରି ଅମ୍ମଡେଞ୍ଜି, ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ଅଡ଼୍‌କୋ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ତଙିୟ୍‌ଡାଲନ୍‌ ଜିର୍ରେ ତେତ୍ତେ ଇରେଞ୍ଜି ଆରି ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ତେତ୍ତେ ଅଣ୍ଡ୍ରଙ୍‌ ତୁଙେଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆମ୍ମୁଙ୍‌ ତେତ୍ତେ ତୁଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ଜିସୁନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆଗ୍ରିଜେନ୍‌ ଆନିନ୍‌ ଇର୍ସୋୟମ୍‌ଡାଏନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ତୁର୍‌ମେଡ୍‌ମର୍‌ତଡନ୍‌ ଆ ମେଣ୍ଡାଜି ଅନ୍ତମ୍‌ ଡକୋଏଞ୍ଜି, ଆରି ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବର୍ନେଞ୍ଜି ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ଅରୁବ୍‌ଲେ ଆପ୍ରାଙେନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ, ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “କେନ୍‌ ତେନ୍ନେ ତ ଆରିଙ୍‌ରିଙ୍‌, ଆରି ଅରୁବ୍‌ଲେ ପାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ସମ୍ପରା ସାଇରେଙନ୍‌ ଡ ଗଡ଼ାରେଙନ୍‌ ଜିର୍ରେ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ଇନ୍ନିଙ୍‌ ଜନୋମ୍‌ଜୋମନ୍‌ ଇୟେତୋ ଞିଏଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟାଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, “ଆମ୍ୱେଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାଗାନେନ୍‌ ତିୟ୍‌ବାଜି,” ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଇନି ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ବଡିଡାଲନ୍‌ ଆଟ ଆଙ୍ଗାୟ୍‌ଲୋଙ୍‌ ଡିଅଙ୍ଗା ତଙ୍କା ଅର୍ଜେତେ ଡିୟ୍‌ତେ ଆ ତଙ୍କା ବାତ୍ତେ ରୁଟିନ୍‌ ଞିଲେ କେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାଗାନେନ୍‌ ତିୟ୍‌ବୋଜି ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅମଙ୍‌ବେନ୍‌ ଡିଅଙ୍ଗା ରୁଟିନ୍‌ ଡକୋ ? ଜିର୍ରେ ଇୟ୍‌ ଗିୟ୍‌ବା ।” ଆନିଞ୍ଜି ଜିର୍ରେ ଇୟ୍‌ଲେ ଗିଜେଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ମନ୍‌ଲୟ୍‌ ରୁଟିନ୍‌ ଆରି ବାଗୁ ଅୟନ୍‌ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ସିଲତ୍ତେ ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ଆ ଲେଡେଙ୍‌ଗାବ୍‌ଲୋଙନ୍‌ ଡାଡ଼ିଜଙ୍‌ ଅବ୍‌ତଙ୍କୁମ୍‌ବାଜି ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ବସଅ ଲେକାଁୟ୍‌ ଆରି ପଚାସ ଲେକାଁୟ୍‌ ଡାଡ଼ିଜଙ୍‌ ତଙ୍କୁମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ତି ମନ୍‌ଲୟ୍‌ ରୁଟିନ୍‌ ଡ ବାଗୁ ଅୟନ୍‌ ଞମ୍‌ଲେ ରୁଆଙ୍‌ଗଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆଙାଙ୍‌ଡାଲେ ଆସିର୍ବାଦଏନ୍‌ କି ରୁଟିଞ୍ଜି ରେବ୍‌ଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବନ୍ତାଲେ ତନିୟନ୍‌ ଆସନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ତିୟେଞ୍ଜି । ଆରି, ତି ବାଗୁ ଅୟନ୍‌ ନିୟ୍‌ ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ବନ୍ତାଲେ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ସିଲତ୍ତେ ଅଡ଼୍‌କୋଞ୍ଜି ଜୋମ୍‌ଲେ ଅବୋଏଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ଆରି ଆନିଞ୍ଜି ଆରେବ୍‌ରେବ୍‌ ରୁଟିନ୍‌ ଆର୍‌ଲାଗାଏନ୍‌ଆତେ ବାର ଗୁରୁଲ୍ଲି ବବ୍‌ରିଜେଞ୍ଜି ଆରି ଅୟନ୍‌ ନିୟ୍‌ ଡକ୍କୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ଡିଅଙ୍ଗା ମନ୍‌ରା ରୁଟିନ୍‌ ଜୋମେଞ୍ଜି, ଓବ୍ବାମରଞ୍ଜି ତୁମ୍‌ ତେତ୍ତେ ମନ୍‌ଲୟ୍‌ ଅଜାର ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ସିଲତ୍ତେମା ଜିସୁନ୍‌, ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ବେତ୍‌ସାଇଦାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି, ଆରି ତି ଆ ବନେଡ଼ା ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ମନ୍‌ରାଞ୍ଜି ଡ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଆଜିର୍ରେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ବରୁନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ସାଲ୍ଲୁମ୍‌ଲେ ଆପ୍ରାଙେନ୍‌ ଆଡିଡ୍‌ ଡୋଙ୍ଗାନ୍‌ ମଡ୍ଡି ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଡକୋଏନ୍‌ ଆରି ଜିସୁନ୍‌ ଆତିନ୍‌ସଜନ୍‌ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ସରବ୍‌ଡିଡ୍‌ଗଡ୍‌ ସିଲଡ୍‌ ରିଙ୍ଗେନ୍‌ ଆଜିର୍ରାଞନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଡୋଙ୍ଗାନ୍‌ ଆ ସନଲ୍ଲାୟ୍‌ ଡଣ୍ଡଡମ୍‌ ଡେଏଞ୍ଜି, ତିଆସନ୍‌ ଜିସୁନ୍‌ ତିଆତେ ଗିୟ୍‌ଲେ ତଗଲନ୍‌ ଉଞ୍ଜି ଗଣ୍ଟା ଇଙନ୍‌ ତୋଣ୍ଡୋ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ତଙିୟ୍‌ଡାଲନ୍‌ ଆମଙଞ୍ଜି ଜିର୍ରାୟ୍‌, ଆରି ଆମଙ୍‌ଗଡଞ୍ଜି ପଡ୍‌ଲେ ଅଡି ଜିର୍‌ଜିରନ୍‌ ଆସନ୍‌ ସାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ବନ୍‌ଡ ଆନିନ୍‌ ତୋଣ୍ଡୋ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆତ୍ରଙିୟ୍‌ଲନ୍‌, ଞଙ୍‌ନେମରଞ୍ଜି ଗିୟ୍‌ଲେ ବୁତ ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟେଞ୍ଜି କି ସଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ବତଙେଞ୍ଜି । ବନ୍‌ଡ ଆନିନ୍‌ ସିଲତ୍ତେମା ଆନିଞ୍ଜି ସରିନ୍‌ କଡାଡ଼ିଡାଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅବ୍ବୋମଙ୍‌ନାବା, କେନ୍‌ ତ ଞେନ୍‌, ବତଙ୍‌ଡଙ୍‌ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଆରି ଆନିନ୍‌ ଆମଙଞ୍ଜି ଜିର୍ରେ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାଜେନ୍‌, ଆରି ରିଙ୍ଗେନ୍‌ ତଡେନ୍‌ । ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆ ମନ୍ନଲୋଙଞ୍ଜି ଆକ୍ରାନ୍‌ ସାନ୍ନି ଡେଏଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ଲୟ୍‌ ଅଜାର ମନ୍‌ରାଞ୍ଜି ରୁଟିନ୍‌ ଆଜ୍ରୋମେଞ୍ଜି ଆଡିଡ୍‌ ଆ ଉଗରଞ୍ଜି ଆ ରଡୋ ଡକୋଏନ୍‌, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଅଃଗନ୍‌ଲୁଡ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ଆନିଞ୍ଜି ପଡ୍‌ଲୋଙ୍‌ ପଡ୍‌ଲେ ଗିନ୍ନେସରତରେଙନ୍‌ ତୁଙ୍‌ଲେ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଡୋଙ୍ଗାନ୍‌ ଜିଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ଆରି ଆନିଞ୍ଜି ଡୋଙ୍ଗାଲୋଙନ୍‌ ସିଲଡ୍‌ ଆପ୍ରଡ୍‌ଲଞ୍ଜି, ମନ୍‌ରାଞ୍ଜି ସିଲତ୍ତେମା ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍ମଡେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ତିଆସନ୍‌ ଗିନ୍ନେସରତନ୍‌ ଆ ତୁୟାୟ୍‌ ସମ୍ପରା ସାଇରେଙନ୍‌ ଇରେଞ୍ଜି, ଆରି ଆନିନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋ ଗାମ୍‌ଲେ ଅମ୍‌ଡଙେଞ୍ଜି, ତିସେଙ୍‌ ରୋଗମରଞ୍ଜିଆଡଙ୍‌ କଟଲୋଙନ୍‌ ବୋୟ୍‌ଲେ ଓରୋଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ଆରି, ଆନିନ୍‌ ଅଙ୍ଗା ଅଙ୍ଗା ଆ ସାଇ, ଆ ଗଡ଼ା ଆରି ସନ୍ନା ସାଇରେଙନ୍‌ ଇୟେନ୍‌, ମନ୍‌ରାଞ୍ଜି ତିସେଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ସୟ୍‌ତାରେଙ୍‌ ରୋଗମରଞ୍ଜିଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଇୟ୍‌ଲାୟ୍‌ ତମ୍ମିଜେଞ୍ଜି, ଆରି ଆ ସିନ୍‌ରିନ୍‌ ଆଲୁଡ୍‌କାବ୍‌ ସନୁଙେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଆମଙନ୍‌ କାକୁର୍ତିଲଞ୍ଜି, ଡିଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ସୁଙେଏଞ୍ଜି, ଅଡ଼୍‌କୋଞ୍ଜି ମନଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ତିକ୍କି ପାରୁସିଞ୍ଜି ଡ ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଲାଙ୍‌ଲେଡ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି । ");
INSERT INTO juy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଲାଙ୍‌ଲେନ୍ନେ ଏର୍‌ମଡ଼ିର୍‌, କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ ଏର୍‌ନାସିନେନ୍‌ ଆଗ୍ରାଗାଲଞ୍ଜି ଆନିଞ୍ଜି ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ପାରୁସିଞ୍ଜି ଡ ଅଡ଼୍‌କୋ ଜିଉଦିମରଞ୍ଜି ପାପୁର୍‌ମରଞ୍ଜି ଆ ଓକ୍କା ଅନଗଡ୍‌ ଅନ୍ତମ୍‌ ଞଣ୍ଡ୍ରମ୍‌ଡାଲନ୍‌ ମନଙ୍‌ ଏର୍‌ନାସିନେନ୍‌ ଅଃଗାଗାନେଜି । ");
INSERT INTO juy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ଆରି ସୟ୍‌ତାନ୍‌ ସିଲଡ୍‌ ୟର୍ରନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଡଅଙ୍‌ଲୋଙଞ୍ଜି ଅଃସିନ୍‌ସିଡାଲଞ୍ଜି ଡେନ୍‌ ଆନିଞ୍ଜି ଅଃଗାଗାନେଜି, ଆରି ଗିନାନ୍‌, ଲୋତ୍ତାନ୍‌, ଡ ପିତ୍ତଡ଼ ସିମ୍ମାଞ୍ଜି ଡାଆଲୋଙନ୍‌ ପିଡ୍‌ଲେ ଗନିୟ୍‌ଡାନ୍‌, କଟଲୋଙନ୍‌ ସିନ୍‌ସିଡାନ୍‌, କେନ୍‌ ଅନ୍ତମ୍‌ ଏର୍ଜାଡ଼ିକାନ୍‌ ଜବ୍ରଡମ୍‌ ଅନଗଡଞ୍ଜି ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆବାଁୟ୍‌ବାଁୟ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ତିଆସନ୍‌ ପାରୁସିଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ପାପୁର୍‌ମରଞ୍ଜି ଆ ଓକ୍କା ଅନଗଡ୍‌ ଅନ୍ତମ୍‌ ଏର୍‌ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଇନିବା ଏର୍‌ନାସିନେନ୍‌ ଗାଗାତଞ୍ଜି ?” ");
INSERT INTO juy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଏ ଇସ୍କତ୍ତାମର୍‌ଜି, ଜିସାୟନ୍‌ ବର୍ନେଲୋଙ୍‌ବେନ୍‌ ମନଙ୍‌ଡମ୍‌ ପୁର୍ବାଃତେବରନ୍‌ ବର୍ରନେ, ଅନିଡଲନ୍‌ ଡକୋ, ‘କେନ୍‌ ଆ ମନ୍‌ରାଜି ଆତଅଡଞ୍ଜି ବାତ୍ତେ ଞେନ୍‌ଆଡଙ୍‌ ମାନ୍ନେତିଁୟ୍‌ଜି, ବନ୍‌ଡ ଆ ଉଗରଞ୍ଜି ଞେନ୍‌ ସିଲଡ୍‌ ସଙାୟ୍‌ଡମ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆନଗଡ୍‌ଜି ଡରମ୍ମନ୍‌ ଆ ଞନଙ୍‌ ଗାମ୍‌ଲେ ଞନଙନ୍‌ ତିୟ୍‌ଲେ, କାଜ୍ଜାନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସେଙ୍କେତିଁୟ୍‌ଜି ।’” ");
INSERT INTO juy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ରେଙ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜି ଆ ଓକ୍କା ଅନଗଡନ୍‌ ଞମ୍‌ଲେ ଏଡକୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଓକ୍କା ଅନଗଡଞ୍ଜି ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଆସନ୍‌ ଇସ୍କତ୍ତାନ୍‌ ବୟନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବନାଁୟ୍‌ ଏଅମ୍‌ରେଙ୍‌ତେ ! ");
INSERT INTO juy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମୋସାନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ତିୟ୍‌ଲବେନ୍‌, ‘ଆପେୟ୍‌ବେନ୍‌ ଅୟୋଙ୍‌ବେନ୍‌ ମାନ୍ନେବାଜି, ଆରି ଅଙ୍ଗା ମନ୍‌ରା ଆପେୟନ୍‌ ଡେଏତୋ କି ଆୟୋଙନ୍‌ ଡେଏତୋ ସୟ୍‌ପତେ, ଆନିନ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ ।’ ");
INSERT INTO juy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଗାମ୍‌ତେ, ଆନ୍ନିଙ୍‌ ଡେନ୍‌ ଆପେୟନ୍‌ କି ଆୟୋଙନ୍‌ଆଡଙ୍‌ ଗାମ୍‌ତେ, ଞେନ୍‌ ସିଲଡ୍‌ ଅଙ୍ଗାତେ ବୟନ୍‌ ଆମ୍ୱେଞ୍ଜି ସନାକ୍କେନ୍‌ ଏଞାଙ୍‌ତେ ବନ୍‌, ତିଆତେ ‘କର୍ବାନ୍‌’ କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ ଇସ୍ୱରନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ତନିୟନ୍‌ ଡେଲୋ, ");
INSERT INTO juy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଆପେୟନ୍‌ ଆସନ୍‌ କି ଆୟୋଙନ୍‌ ଆସନ୍‌ ଇନ୍ନିଙ୍‌ ଆରି ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଏଃନ୍ନବ୍‌ଲୁମ୍‌ଲୁମେ, ");
INSERT INTO juy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","କେନ୍‌ ଏନ୍ନେଲେ ଆମ୍ୱେଞ୍ଜି, ଆ ଓକ୍କା ଅନଗଡ୍‌ବେଞ୍ଜି ଲୁମ୍‌ଲୁମନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଏପାଃଜଙ୍‌ତେ ଆରି ତିଅନ୍ତମ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ କାବ୍ବାଡ଼ାଞ୍ଜି ଏଲୁମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ବା ଆରି ଗନ୍‌ଲୁଡ୍‌ବେନ୍‌ତୋ । ");
INSERT INTO juy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ଅଙ୍ଗାତେ କି ମନ୍‌ରାନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଅମ୍ମନ୍‌ ଗନ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଏମ୍ମେତେ, ଡୁଆରାନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌ । ବନ୍‌ଡ ଅଙ୍ଗାତେ ମନ୍‌ରାନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ତନାୟ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଏମ୍ମେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଆନା ଅଲୁଡନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅମ୍‌ଡଙେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ଆରି, ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଅମ୍ମସିଙନ୍‌ ଆଜିର୍ରାଞନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଆ ଗରାମ୍‌ଗାମ୍‌ ଇନି ଗାମ୍‌ଲେ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଇନି ଆନିଞ୍ଜି ଅନ୍ତମ୍‌ ଆ ଉଲ୍ଲୁଜି ପଙ୍‌ ? ଅଙ୍ଗାତେ ଡୁଆରାନ୍‌ ସିଲଡ୍‌ ମନ୍‌ରାନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଗନ୍‌ତେ, ତିଆତେ ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଅଃନ୍ନମ୍ମେଏ । ");
INSERT INTO juy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆତେ ଆ ଉଗର୍‌ଲୋଙନ୍‌ ଅଃଗନେ, ବନ୍‌ଡ ଆ କିମ୍ପୋଙ୍‌ଲୋଙନ୍‌ ଗନ୍‌ଲେ ଡରୁଙ୍‌ନେଗଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ତେ ।” ଏନ୍ନେଲେ ବର୍ରନ୍‌, କେନ୍‌ ଏନ୍ନେଲେ, ଅଡ଼୍‌କୋ ଜନୋମ୍‌ଜୋମନ୍‌ ମଡ଼ିର୍‌ ଡେତେ ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ଜିସୁନ୍‌ ଆରି ବର୍ରନେ, “ଅଙ୍ଗାତେ ମନ୍‌ରାନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ତନାୟ୍‌, ତିଆତେ ମା ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଏମ୍ମେତେ । ");
INSERT INTO juy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅମ୍ମନ୍‌ ସିଲଡ୍‌, ମନ୍‌ରାନ୍‌ ଆ ଉଗର୍‌ଲୋଙ୍‌ ସିଲଡ୍‌, ପରାନ୍‌ସାତ୍ତିନ୍‌ ଆନିଃୟମ୍‌ ଡୁଙ୍‌ତନାୟ୍‌, ଜୋଣ୍ଡଡ଼ାନ୍‌, ରାଉନେନ୍‌, ସମ୍ବବ୍‌ମରନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ଡାରିନେନ୍‌, ଗନିୟ୍‌ମଡନ୍‌, ବୁର୍ଡଜୋମନ୍‌, କଣ୍ଡାୟ୍‌ବରନ୍‌, ଆଡ଼ସାନ୍‌, ଏଡ଼ୁର୍‌ମଡନ୍‌, ନିଣ୍ଡୟ୍‌ବରନ୍‌, କଙ୍କ୍ରିନ୍‌, ଉଲ୍ଲୁନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ପରାନ୍‌ସାତ୍ତିଞ୍ଜି ଅମ୍ମନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଏମ୍ମେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଡୋଲନ୍‌ ସୋର ଡେସାନ୍‌ ଆ ତୁୟାୟ୍‌ରେଙ୍‌ ଜିରେନ୍‌, ଆରି ଅବୟ୍‌ ଅସିଙନ୍‌ ଇୟ୍‌ଲେ ଗନେ, ଆନିନ୍‌ ତେତ୍ତେ ଡକୋ ଗାମ୍‌ଲେ ଆନ୍ନିଙ୍‌ ଜନାଡଙେଜି ତଡ୍‌ ଗାମେନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ସଲନ୍‌ ଡକୋଲନ୍‌ ଅଃର୍ରପ୍ତିଲୋ । ");
INSERT INTO juy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ସିଲତ୍ତେମା ଅବୟ୍‌ ଆଇମରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ିଅନ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆସୁମ୍‌ସୁମ୍‌ ଡକୋଏନ୍‌, ଆରି ତି ଆଇମରନ୍‌ ଜିସୁନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ, ଆମଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ କି ଆ ତାଲ୍‌ଜଙ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଅବ୍‌ସେଡ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ତି ଆଇମରନ୍‌ ସୁରିଆ ଡେସାନ୍‌ ପୈନିକିୟାନ୍‌ ଆ ନଗରିବୟ୍‌, ଆରି ଆନିନ୍‌ ଗ୍ରିକ୍‌ବୟ୍‌ ଡକୋଏନ୍‌ । ଆ ଡାଙ୍ଗଡ଼ିଅନନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ବୁତନ୍‌ ଗଙ୍ଗଙନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ କାକୁର୍ତିନେ । ");
INSERT INTO juy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମ୍ମୁଙ୍‌ ଅଅନଞ୍ଜି ରୟ୍‌ ରୋଜୋମ୍‌ବାଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଅନଞ୍ଜି ଆ ଜନୋମ୍‌ଜୋମ୍‌ ପାଙ୍‌ଲେ କିନ୍‌ସଡଞ୍ଜି ଆମଙ୍‌ ସନେଡନ୍‌ ଅଃଡ୍ଡେଏ ।” ");
INSERT INTO juy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ବନ୍‌ଡ ତି ଆଇମରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଓଓ, ପ୍ରବୁ, ପସିଜଞ୍ଜି ଆ ସଙ୍କୁରା ମେଜନ୍‌ ଆ ଜାୟ୍‌ତା ଆରସେଡ୍‌ତେନ୍‌ଆତେ କିନ୍‌ସଡଞ୍ଜି ଜୋମ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆଇମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଏନ୍ନେଲେ ଆବର୍ରନେନ୍‌, ଜିରା, ଡାଙ୍ଗଡ଼ିଅନ୍‌ନମ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ବୁତନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍ନି ।” ");
INSERT INTO juy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ଆରି, ଆନିନ୍‌ ଅସିଙନ୍‌ ୟର୍ରନ୍‌ ପସିଜନ୍‌ କଟଲୋଙନ୍‌ ଆଲୁଡ୍‌ଲୁଡନ୍‌ ଆରି ବୁତନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ଜିରନ୍‌ ଇୟ୍‌ଲେ ଗିଜେ । ");
INSERT INTO juy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ଜିସୁନ୍‌ ଆରି ସୋର ଡେସାନ୍‌ ଆ ତୁୟାୟ୍‌ରେଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରେ ସିଦୋନନ୍‌ ଡ ଦେକାପଲିନ୍‌ ଆ ସଣ୍ଡିଗଡ୍‌ ଗାଲିଲି ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ତୁୟାୟ୍‌ ଜିର୍ରାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଅବୟ୍‌ ଆ କାଲା ଆରି ଆ ଜାଡ୍ଡାମରନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ଆସିନ୍‌ ଡନକ୍କୋନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ କାକୁର୍ତିନେଜି । ");
INSERT INTO juy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ଜିସୁନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଆରୁକ୍କୁମରନ୍‌ ସିଲଡ୍‌ ଆନ୍ନାଲେ ଆତିନ୍‌ସଜନ୍‌ ଓରୋଙ୍‌ଡାଲେ ବାଗୁନ୍‌ ଆଲୁଡ୍‌ଲୋଙନ୍‌ ଆ ଅଣ୍ଡେର୍‌ସିନ୍‌ ଡକ୍କୋଏନ୍‌ କି ବିଜଲ୍‌ଡାଲେ ଆଲାଙନ୍‌ ସୁଙେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ରୁଆଙ୍‌ଗଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆଙାଙ୍‌ଡାଲେ ଆକ୍ରାନ୍‌ ଆରୁୟମ୍‌ଡାଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଇପ୍‌ପତଃ,” କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ “ରୋନା ।” ");
INSERT INTO juy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ସିଲତ୍ତେମା ଆଲୁଡନ୍‌ ରୋଲନେ ଆରି ଆଲାଙନ୍‌ ଆ ଜନିବାଡ୍‌ ଉୟ୍‌ଲନେ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତି ମନ୍‌ରାନ୍‌ ରେୟ୍‌ଲଙ୍‌ କଡାଡ଼ିଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ଆରି ଜିସୁନ୍‌, କେନ୍‌ ଆ ବର୍ନେ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ଏବର୍‌ଡଙ୍‌ନେ ଗାମ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ବରେଞ୍ଜି, ବନ୍‌ଡ ଆନିନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଡିଅଙ୍ଗା ଏବର୍‌ଡଙ୍‌ନେ ଗାମ୍‌ଲେ ବରେଞ୍ଜି, ଆନିଞ୍ଜି ଡିୟ୍‌ତେ ତିଆତେ ବର୍ବର୍ରେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ଆରି, ମନ୍‌ରାଞ୍ଜି ଆକ୍ରାନ୍‌ ସାନ୍ନିଡାଲେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ କାବ୍ବାଡ଼ାନ୍‌ ମନଙ୍‌ଡମ୍‌ ଲୁମେନ୍‌, ଆନିନ୍‌ ଆ କାଲାମରଞ୍ଜି ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଆରି ଆଜାଡ୍ଡାମରଞ୍ଜି ରପ୍ତି କଡାଡ଼ିନେନ୍‌ ଆସନ୍‌ ନିୟ୍‌ ବୋର୍ସାନ୍‌ ତିୟେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ତି ଆ ବନେଡ଼ା ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ରୁକ୍କୁଲଞ୍ଜି, ଆରି ଆମଙଞ୍ଜି ଜନୋମ୍‌ଜୋମନ୍‌ ଇନ୍ନିଙ୍‌ତଡନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଞେନ୍‌ ଇର୍ସୋୟମ୍‌ଡାତିଁୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆନିଞ୍ଜି ୟାଗି ଡିନ୍ନା ଡେଏନ୍ନି ଞେନ୍‌ ସରିନ୍‌ ଡକୋଜି ଆରି କେନ୍‌ ଆମଙଞ୍ଜି ଇନ୍ନିଙ୍‌ ଜନୋମ୍‌ଜୋମ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆଡୋଲେଜନ୍‌ ଆସିଙଞ୍ଜି ଆପ୍ପାୟ୍‌ଲାଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତଙରନ୍‌ ଆନିଞ୍ଜି ଇୟ୍‌ତେ ରାଇଡେଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ଲାଙ୍‌ଲେନ୍ନେ ସଙାୟ୍‌ ସିଲଡ୍‌ ଜିର୍ରାଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ତେନ୍ନେ କେନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଆନା ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ରୁଟିନ୍‌ ପାଙ୍‌ଲେ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍ବୋଓଲେ ରପ୍ତିଏଜି ?” ");
INSERT INTO juy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅମଙ୍‌ବେନ୍‌ ଡିଅଙ୍ଗା ରୁଟିନ୍‌ ଡକୋ ?” ଆନିଞ୍ଜି ଜାଲଙେଞ୍ଜି, “ସାତଟା ।” ");
INSERT INTO juy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ସିଲତ୍ତେ ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଲବଲୋଙନ୍‌ ତନଙ୍କୁମନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି, ଆରି, ଆନିନ୍‌ ତି ସାତଟା ରୁଟିନ୍‌ ପାଙ୍‌ଲେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସନେନ୍‌ସେନନ୍‌ ତିୟ୍‌ଲେ, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ରେବ୍‌ଲେ ବନନ୍ତାନ୍‌ ଆସନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ତିୟେଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ତିଆତେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବନ୍ତାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ଆରି, ଆମଙଞ୍ଜି ଅସୋୟ୍‌ ସନ୍ନାରା ଅୟନ୍‌ ଡକୋଏନ୍‌, ତିଆତେଜି ଆସନ୍‌ ନିୟ୍‌ ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସନେନ୍‌ସେନନ୍‌ ତିୟ୍‌ଲୋଙ୍‌ ତିୟ୍‌ଲେ ବନନ୍ତାନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ଆନିଞ୍ଜି ଜୋମେଞ୍ଜି କି ଅବୋଏଞ୍ଜି ଆରି ଆଲଗା ରୁଟିନ୍‌ ସାତ ଗୁରୁଲ୍ଲି ବବ୍‌ରିୟ୍‌ଲେ ଡକ୍କୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ତେତ୍ତେ ଉଞ୍ଜି ଅଜାର ଡେତେ ମନ୍‌ରାଞ୍ଜି ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ସିଲତ୍ତେମା ଆ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ଆନିନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ଦଲ୍‌ମନୁଆରେଙନ୍‌ ଜିର୍ରାଜି । ");
INSERT INTO juy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ତିକ୍କି ପାରୁସିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନିନ୍‌ ସରିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଅଲ୍‌ଡୁଲ୍‌ବାଞେଜି ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ମନାଲ୍‌ମାଲନ୍‌ ଆସନ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ଅରମ୍ମଡନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବେଡେଜି । ");
INSERT INTO juy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆକ୍ରାନ୍‌ ଆରୁୟମ୍‌ଡାଲନ୍‌ ବର୍ରନେ, “ନମିଜି ଆ ମନ୍‌ରାଜି ଇନିବା ଅରମ୍ମଡନ୍‌ ସାୟ୍‌ତଜି ? ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ନମିଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଅରମ୍ମଡନ୍‌ ତନିୟନ୍‌ ଅଃଡ୍ଡେଏ ।” ");
INSERT INTO juy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆରି ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ତି ଆ ବନେଡ଼ା ଞଙ୍‌ନେମରଞ୍ଜି ରୁଟିନ୍‌ ଆପନାଙ୍‌ ଆସନ୍‌ କରୋଡାଏଞ୍ଜି, ଡୋଙ୍ଗାଲୋଙନ୍‌ ଆମଙଞ୍ଜି ଆବୟନ୍‌ ତୁମ୍‌ ରୁଟିନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ବରେଞ୍ଜି, “ଆବ୍ବୟ୍‌ଡମ୍‌ନାବା, କମିରନ୍‌ ଅନ୍ତମ୍‌, ପାରୁସିଞ୍ଜି ଡ ଏରୋଦନ୍‌ ଆ କଣ୍ଡାୟ୍‌ ଞନଙ୍‌ ସିଲଡ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ଅମଙ୍‌ଲେନ୍‌ ରୁଟିନ୍‌ ଅବୟ୍‌ ତଡ୍‌, ତିଆସନ୍‌ ଆନିନ୍‌ ଏନ୍ନେଲେ ବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ଜିସୁନ୍‌ ତିଆତେ ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅମଙ୍‌ବେନ୍‌ ରୁଟି ଅବୟ୍‌ ତଡ୍‌ ଗାମ୍‌ଲେ ଇନିବା ତର୍ଡମ୍‌ ଏକଡାଡ଼ିତନ୍‌ ? ଆମ୍ୱେଞ୍ଜି ଇନି ନମିନ୍ତାନ୍‌ ଅଃଜ୍ଜନାବେନ୍‌ କି ଅଃଗନ୍‌ଲୁଡ୍‌ବେନ୍‌ ପଙ୍‌ ? ଉଗର୍‌ବେନ୍‌ ଇନି ଆ କବୁଙ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ଅମଡନ୍‌ ଡକୋନ୍‌ ଡକୋନ୍‌ ଏଃଗିଜେ ପଙ୍‌ ? ଆରି, ଅଲୁଡନ୍‌ ଡକୋନ୍‌ ଡକୋନ୍‌ ଏଃନ୍ନମ୍‌ଡଙେ ପଙ୍‌ ? ଆମ୍ୱେଞ୍ଜି ମନ୍ନେଲେ ଏଃର୍ରପ୍ତିଏ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","“ଞେନ୍‌ ଆଙ୍ଗା, ମନ୍‌ଲୟ୍‌ ରୁଟିନ୍‌ ରେବ୍‌ଲେ ମନ୍‌ଲୟ୍‌ ଅଜାର ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଗାଗାନେନ୍‌ ତିୟ୍‌ଲାଜି, ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଡିଅଙ୍ଗା ଗୁରୁଲ୍ଲିଲୋଙ୍‌ ଆରେବ୍‌ରେବ୍‌ ରୁଟିନ୍‌ ଏବବ୍‌ରିଜେନ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି କରୋଡାଲବେନ୍‌ ପଙ୍‌ ?” ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ବାର ଗୁରୁଲ୍ଲି ।” ");
INSERT INTO juy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ଆରି, ଞେନ୍‌ ଆଙ୍ଗା, ସାତଟା ରୁଟିନ୍‌ ରେବ୍‌ଲେ, ଉଞ୍ଜି ଅଜାର ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବନ୍ତାଲାୟ୍‌, ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଡିଅଙ୍ଗା ଗୁରୁଲ୍ଲିଲୋଙ୍‌ ଆରେବ୍‌ରେବ୍‌ ରୁଟିନ୍‌ ଏବବ୍‌ରିଜେନ୍‌ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି “ସାତ ଗୁରୁଲ୍ଲି ।” ");
INSERT INTO juy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନି ନମିନ୍ତାନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗନ୍‌ଲୁଡ୍‌ବେନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଡ ଞଙ୍‌ନେମରଞ୍ଜି ବେତ୍‌ସାଇଦାନ୍‌ ଜିର୍ରାଜି । ଆରି, ମନ୍‌ରାଞ୍ଜି ଅବୟ୍‌ କାଡ଼ୁମରନ୍‌ଆଡଙ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସୁଙେଡାଲେ ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ କାକୁର୍ତିନେଜି । ");
INSERT INTO juy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ତିଆସନ୍‌ ଆନିନ୍‌ କାଡ଼ୁମରନ୍‌ ଆସି ଞମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସାଇନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ଓରୋଙେନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆମଡ୍‌ଲୋଙନ୍‌ ବିଜଲେନ୍‌ କି ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ଆସିନ୍‌ ଡକ୍କୋଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଇନ୍ନିଙ୍‌ ଗିୟ୍‌ତେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ଆନିନ୍‌ ଆଙାଙ୍‌ଡାଲନ୍‌ ବର୍ରନେ, “ଞେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଗିୟ୍‌ତାଜି ବନ୍‌ଡ ଆନିଞ୍ଜି ଅରାନୁବଞ୍ଜି ଅନ୍ତମ୍‌ ଗିୟ୍‌ତାଡାଲେ ଆତ୍ରଙିୟ୍‌ତନେଞ୍ଜି ଞେନ୍‌ ଗିୟ୍‌ତାଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆରି ଆମଡ୍‌ଲୋଙନ୍‌ ଆସିନ୍‌ ଡକ୍କୋଏନ୍‌, ସିଲତ୍ତେ ଆନିନ୍‌ ରେୟ୍‌ଲଙ୍‌ ଗିଜେନ୍‌ ଆରି ମନଙ୍‌ଡାଲେ ଆବଗନିଜନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଗିଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ବରେନ୍‌, “କେନ୍‌ ଆ ସାଇ ଇୟ୍‌ଡଙ୍‌ଗନେ, ଅସିଂନମ୍‌ ଜିରା ।” ");
INSERT INTO juy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି କାଇସରିଆ ପିଲିପିରେଙନ୍‌ ଆ ସାଇରେଙ୍‌ ଜିରେଞ୍ଜି, ଆରି ତଙର୍‌ଲୋଙନ୍‌ ଆନିନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆନା ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଇନି ଗାମ୍‌ତଜି ?” ");
INSERT INTO juy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌,” ଆରି ଲାଙ୍‌ଲେନ୍ନେ “ଏଲିଅ, ବନ୍‌ଡ ଲାଙ୍‌ଲେନ୍ନେ ଗାମ୍‌ତଜି, ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି, ଞେନ୍‌ ଆନା ଏଗାମ୍‌ତିଁୟ୍‌ ?” ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆରାପ୍ପାୟ୍‌ଲମନ୍‌ ଆ କ୍ରିସ୍ଟ ।” ");
INSERT INTO juy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ବରେଞ୍ଜି, “ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ବର୍ନେଞେନ୍‌ ଇନ୍ନିଙ୍‌ ଏବର୍‌ଡଙ୍‌ନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ, “ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଗୋଗୋୟ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ ଆରି ପାପୁର୍‌ମରଞ୍ଜି, ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବାସ୍ସେତଜି ଆରି ରବ୍ବୁତଜି ବନ୍‌ଡ ୟାଗି ଡିନ୍ନା ଆ ତିକ୍କି ଆନିନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","କେନ୍‌ ଆ ବର୍ନେ ଆନିନ୍‌ ରେୟ୍‌ଲଙ୍‌ ବର୍ରନେ । ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବ ଅନେଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଇୟ୍‌ଲେ କଞେ । ");
INSERT INTO juy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ, ପିତ୍ରନ୍‌ଆଡଙ୍‌ କଁୟ୍‌ଲେ ବରେନ୍‌, “ସନୁମ୍‌, ମୁକ୍କାବାଞେନ୍‌ ସିଲଡ୍‌ ସବ୍‌ଙାୟ୍‌ନା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଏର୍‌ନିଃୟମନ୍‌ ମନ୍‌ରାନ୍‌ ଆ ବର୍ନେ ଇୟମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ବରେଞ୍ଜି, “ଆନା ଞେନ୍‌ଆଡଙ୍‌ ସନଣ୍ଡୋଙନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ତେ, ତି ଆ ମନ୍‌ରା, ଆନିନ୍‌ଡମ୍‌ ମୁର୍ସେଡମ୍‌ନେତୋ, ଆରି ଆଅକ୍କାଡଙନ୍‌ ବୋୟ୍‌ଲେ ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ତୋ । ");
INSERT INTO juy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଆ ପରାନ୍ନାନ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଅବ୍ବଡ଼ୟ୍‌ତେ, ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ଞେନ୍‌ ଆସନ୍‌ ଆରି ମନଙ୍‌ବରନ୍‌ ଆସନ୍‌ ଆ ପରାନ୍ନାନ୍‌ ଅବ୍ବଡ଼ୟ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଡୋବ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ଆରି ମନ୍‌ରାନ୍‌ ପୁର୍ତିନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଞାଙ୍‌ଲୋଙ୍‌ ଞାଙ୍‌ଲେ, ଆ ପରାନ୍ନାନ୍‌ ଅବ୍ବଡ଼ଜେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇନି ଆ ଲାବ ? ");
INSERT INTO juy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ଆରି ମନ୍‌ରାନ୍‌, ଆ ପରାନ୍ନାନ୍‌ ଞନାଙନ୍‌ ଆସନ୍‌ ଆ ପାଲ୍‌ତେଙନ୍‌ ଇନି ତିୟ୍‌ଲେ ରପ୍ତିଏ ? ");
INSERT INTO juy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ତିଆସନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା କେନ୍‌ ନମି ଆ ଜୋଗା ଡାରିନେମରଞ୍ଜି ଡ ଇର୍ସେମରଞ୍ଜି ଆମଙ୍‌, ଞେନ୍‌ ଆସନ୍‌ ଆରି ବର୍ନେଞେନ୍‌ ଆସନ୍‌ ଗବ୍‌ରୟ୍‌ତନେ, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଅଙ୍ଗା ଆଡିଡ୍‌ ମଡ଼ିର୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ସରିନ୍‌ ଆପେୟନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ଜିର୍ତାୟ୍‌, ତି ଆ ବନେଡ଼ା ଆନିନ୍‌ ନିୟ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗବ୍‌ରୟ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ଜିସୁନ୍‌ ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ବୋର୍ସାନ୍‌ ବାତ୍ତେ ଆଜିର୍ତାଞନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗିଜେଞ୍ଜି ଜାୟ୍‌ ତେନ୍ନେ ଆତନଙନ୍‌ ଆ ମନ୍‌ରାଜି ଲାଙ୍‌ଲେନ୍ନେ, ରନବୁନ୍‌ ଏର୍‌ମନାୟ୍‌ମାଜନ୍‌ ଡକୋତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ତୁଡ୍ରୁ ଡିନ୍ନା ଆ ତିକ୍କି ପିତ୍ରନ୍‌, ଜାକୁବନ୍‌ ଡ ଜନନ୍‌ ଆନ୍ନାଡାଲେ ଜିସୁନ୍‌ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ଡେଙ୍ଗା ବରୁନ୍‌ ଆ ତୋଣ୍ଡୋ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ଆରି, ଆନିନ୍‌ ଆତେମଡଞ୍ଜି ବାଙ୍‌ସାୟ୍‌ଲନେ, ଆ ସିନ୍‌ରିନ୍‌ ଏତ୍ତେଲେ ଆ ସାଆର୍‌ ଆରି ଏତ୍ତେଲେ ଆ ଜେଏ ଡେଏନ୍‌ ଡ, ପୁର୍ତିନ୍‌ ଅନ୍ନିଙ୍‌ ଆ ତୋବ୍‌କାବ୍‌ମର୍‌ ଏତ୍ତେଲେ, ଅବ୍‌ଜେଏଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ଆରି, ମୋସାନ୍‌ ଡ ଏଲିଅନ୍‌ ଜିସୁନ୍‌ ସରିନ୍‌ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ଞଙ୍‌ନେମରଞ୍ଜି ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି କେନ୍‌ତେନ୍ନେ ଡକୋ ତିଆସନ୍‌ ବୟ୍‌ଲେଙ୍‌, ଇନ୍‌ଲେଞ୍ଜି ୟାଗି ଅନ୍‌ସିଙନ୍‌ ଏଗୁତାୟ୍‌, ଆମନ୍‌ ଆସନ୍‌ ଅବୟ୍‌, ମୋସାନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ଆରି ଏଲିଅନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆକ୍ରାନ୍‌ ବତଙେଞ୍ଜି । ତିଆସନ୍‌ ପିତ୍ରନ୍‌ ଇନି ଗାମ୍‌ଲେ ଜାଲଙେ ତିଆତେ ଆନିନ୍‌ ଅଃଜ୍ଜନାଲୋ । ");
INSERT INTO juy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ଆରି, ବକୋପ୍ପା ମେଗନ୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁବେଜି, ଆରି ତି ଆ ମେଗଲୋଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଅଡ଼ୋଲାୟ୍‌, “କେନ୍‌ଆନିନ୍‌ ଡନୁଙ୍‌ୟମ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌, କେନ୍‌ ଆ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ଆରି, ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ଏର୍ରେ ଆମଙଞ୍ଜି ଆରାଙାଙେଞ୍ଜି, ଆନିଞ୍ଜି ସରିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତୁମ୍‌ ଗିଜେଞ୍ଜି, ଆରି ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃଗିୟ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ଆନିଞ୍ଜି ବରୁନ୍‌ ସିଲଡ୍‌ ଆପ୍ରଡ୍‌ଲନାଞଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନିଜି ଇନିଜି ଏଗିଜେନ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌, ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ୟର୍ମେଙେନ୍‌ ଜାୟ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଏବର୍‌ଡଙେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ସିଲତ୍ତେ ଆନିଞ୍ଜି ତି ଆ ବର୍ନେ ଞମ୍‌ଲେ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ୟନର୍ମେଙନ୍‌ ଇନି ? ତି ଆ ବର୍ନେଲୋଙ୍‌ ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ଆରି, ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ମୁଙ୍‌ ଏଲିଅନ୍‌ ରୟ୍‌ ଜିର୍ତାୟ୍‌ ଗାମ୍‌ଲେ, ସାସ୍ତ୍ରିଞ୍ଜି କେନ୍‌ ଆ ବର୍ନେ ଇନିବା ବର୍ତଞ୍ଜି ?” ");
INSERT INTO juy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏଲିଅନ୍‌ ଆମ୍ମୁଙ୍‌ ଜିର୍ରେ ଅଡ଼୍‌କୋନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଅନବ୍‌ଜାଡାନ୍‌ ଆ ବର୍ନେ ଆଜାଡ଼ିନ୍‌, ବନ୍‌ଡ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଜବ୍ର ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ବାସ୍ସେତଜି, କେନ୍‌ଆତେ ଏଙ୍ଗାଲେ ଆ ବର୍ନେନ୍‌ ଆଇଡିଡନ୍‌ ଡକୋ ? ");
INSERT INTO juy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଏଲିଅନ୍‌ ଜିର୍ରାୟ୍‌ନି, ଆରି ଆନିନ୍‌ ଆସନ୍‌ ଏଙ୍ଗାଲେ ଆଇଡିଡନ୍‌ ଡକୋ, ତିଅନ୍ତମ୍‌ ମା ଆନିଞ୍ଜି ଏଙ୍ଗାଲେ ଲଡଜେଞ୍ଜି, ତିଆତେ ଆନିନ୍‌ଆଡଙ୍‌ ଏତ୍ତେଏଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ତିକ୍କି ଆନିଞ୍ଜି ଆନ୍ନା ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲେ ଗିଜେଞ୍ଜି, ଏର୍ରେ ଆମଙଞ୍ଜି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆରି ସାସ୍ତ୍ରିଞ୍ଜି ଆନିଞ୍ଜି ବୟନ୍‌ ଅଲ୍‌ଡୁଲ୍‌ବାୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଆକ୍ରାନ୍‌ ସାନ୍ନି ଡେଏଞ୍ଜି ଆରି ଇର୍ରାଜି କି ଇୟ୍‌ଲାୟ୍‌ ଲୋମେଜି । ");
INSERT INTO juy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ସିଲତ୍ତେ ଆନିନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନିବା ଆନିଞ୍ଜି ବୟନ୍‌ ଏଲ୍‌ଡୁଲ୍‌ବାୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଞେନ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ ଓରୋଙ୍‌ଲାୟ୍‌ବନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ଆ ଜାଡ୍ଡା ବୁତନ୍‌ ସୁମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ତି ବୁତନ୍‌, ଅଙ୍ଗାଲୋଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ତେ, ତେତ୍ତେ ପସିଜନ୍‌ଆଡଙ୍‌ ଜାୟ୍‌ତାନ୍‌ ଅବ୍‌ସେଡ୍‌ତେ ଆରି ଆ ତଅଡ୍‌ଗଡନ୍‌ ପୋନ୍‌ସେରାନ୍‌ ଡୁଙ୍‌ତନାୟ୍‌, ରମ୍‌ରମ୍‌ଜିତନେ, ଆରି ଆନିନ୍‌ ଅସର୍‌ତେ, ତି ଆ ବୁତ ଗଙ୍ଗଙନ୍‌ ଆସନ୍‌ ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜିଆଡଙ୍‌ ବର୍ରାଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ଅଃର୍ରପ୍ତିଲଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଏର୍‌ଡର୍ନେ କେଜ୍ଜାଜି, ଡିଅଙ୍ଗା ଡିନ୍ନା ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋନାୟ୍‌ ? ଡିଅଙ୍ଗା ଡିନ୍ନା ଞଣ୍ଡ୍ରମ୍‌ବେଞ୍ଜି ଞେନ୍‌ ସଏଆୟ୍‌ ? ତି ଓବ୍ବାସିଜନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଓରୋଙାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଓବ୍ବାସିଜନ୍‌ ଜିସୁନ୍‌ ଆ ମୁକ୍କାବା ଓରୋଙ୍‌ଲାଜି । ଆରି, ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆଗ୍ରିଜେନ୍‌ ସିଲତ୍ତେମା ତି ବୁତନ୍‌ ଓବ୍ବାସିଜନ୍‌ଆଡଙ୍‌ ବବରନ୍ତଙନ୍‌ ପଡ୍ଡେଡେନ୍‌ ଆରି ଆନିନ୍‌ ଲବଲୋଙନ୍‌ ଅସେଡ୍‌ଡାଲେ ଆ ତଅଡ୍‌ଗଡନ୍‌ ପୋନ୍‌ସେରାନ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ଗଡ଼ାୟ୍‌ ଗଡ଼ାୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ପସିଜନ୍‌ ଆ ବାପାଆଡଙ୍‌ ବରେନ୍‌, “ଡିଅଙ୍ଗା ଡିନ୍ନା ଡେଏନ୍‌ କେନ୍‌ଆନିନ୍‌ ଏନ୍ନେଗୋ ଡେତେ ?” ଆନିନ୍‌ ଜାଲଙେନ୍‌, “ଆ ସନ୍ନା ଇଙନ୍‌ ସିଲଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ବୁତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ବବେଡ଼ାନ୍‌ କି ବବେଡ଼ାନ୍‌ ତଗୋଲୋଙନ୍‌ ଡ ଡାଆଲୋଙନ୍‌ ଗବ୍‌ଲୋତେ, ତିଆସନ୍‌ ଆମନ୍‌ ଇନ୍ନିଙ୍‌ ଲୁମ୍‌ଲେ ରପ୍ତିଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ସାୟୁମ୍‌ଡାଲେ ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲୁମା ।” ");
INSERT INTO juy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଇନି ଗାମେନ୍‌ ? ଲୁମ୍‌ଲେ ରପ୍ତିଏନ୍‌ ଡେନ୍‌ ! ଡର୍ନେମରନ୍‌ ଆ ଡନେଲୋଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଡେଆୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ସିଲତ୍ତେମା ପସିଜନ୍‌ ଆ ବାପା ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଞେନ୍‌ ଡର୍ତନାୟ୍‌, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଗୋଗୋୟ୍‌ ଡର୍ନାୟ୍‌ ତିଆସନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ତିକ୍କି ମନ୍‌ରାଞ୍ଜି ରୁକ୍କୁଲନ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଗିୟ୍‌ଲେ, ଜିସୁନ୍‌ ତି ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ଆଡଙ୍‌ ବବ୍‌ତଙ୍‌ଲେ ବର୍ରନେ, “ଏ ଆକାଲାନ୍‌ ଆରି ଆଜାଡ୍ଡାନ୍‌ ଆ ପୁରାଡ଼ା, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, କେନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରା, ଆରି ଆଙ୍ଗିୟ୍‌ଜା କେନ୍‌ ଆ ଅମ୍ମନ୍‌ ଗନ୍‌ଡଙେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ସିଲତ୍ତେ ଆନିନ୍‌ ସଜିର୍‌ଡାଲେ ଓବ୍ବାସିଜନ୍‌ଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ପଡ୍ଡେଃଡାଲେ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌, ଆରି ପସିଜନ୍‌ ଆରବୁଗୋ ଡେଏନ୍‌, ତିଆସନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ ରବୁଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆସିନ୍‌ ଞମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଡୋଏନ୍‌, ଆରି ଆନିନ୍‌ ତନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ଆରି, ଜିସୁନ୍‌ ଅସିଙନ୍‌ ଆଜିର୍ରାଞନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅଜନା ବରେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଇନିବା ତି ଆ ବୁତ ଗଙ୍‌ଲେ ଏଃର୍ରପ୍ତିଲାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ପାର୍ତନାନ୍‌ ତୁମ୍‌ ବାତ୍ତେ ଏନ୍ନେଗନ୍‌ ଆ ବୁତ ରପ୍ତି ଗଙ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ତେତ୍ତେ ସିଲଡ୍‌ ଜିର୍ରେ ଗାଲିଲିଗଡ୍‌ ଜିରେଞ୍ଜି । ଆରି ଆନିନ୍‌ ତିଆତେ ଆନ୍ନିଙ୍‌ ଜନାଡଙେଜି ତଡ୍‌ ଗାମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରନ୍‌ ଞନଙନ୍‌ ତିୟେଞ୍ଜି, “ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତନେ, ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ରବ୍ବୁତଜି, ଆରି ଆନିନ୍‌ ରବୁଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ୟାଗି ଡିନ୍ନା ଆ ତିକ୍କି ୟର୍ମେଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ବନ୍‌ଡ ଞଙ୍‌ନେମରଞ୍ଜି ତି ଆ ବର୍ନେ ଅଃଗନ୍‌ଲୁଡ୍‌ଲଜି ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ବନରନ୍‌ ଆସନ୍‌ ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ତିକ୍କି ଆନିଞ୍ଜି କପର୍ନାଉମନ୍‌ ଜିର୍ରାଜି । ଜିସୁନ୍‌ ଅସିଙନ୍‌ ତୁଙ୍‌ଲେ, ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଆମ୍ୱେଞ୍ଜି ତଙରନ୍‌ ଇନି ଏଲ୍‌ଡୁଲ୍‌ବାଞେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ବନ୍‌ଡ ଆନିଞ୍ଜି ରିଙ୍‌ଲନ୍‌ ଡକୋଲଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ସତଙ୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ତର୍ଡମ୍‌ ତଙର୍‌ଲୋଙନ୍‌ ଅଲ୍‌ଡୁଲ୍‌ବାଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ସିଲତ୍ତେ ଆନିନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ବାରଜଣଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ, ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନା ସବ୍‌ତଙ୍‌ନେନ୍‌ ଆସନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ସିଲଡ୍‌ ଅବ୍‌ସନ୍ନାନେତୋ ଆରି ଅଡ଼୍‌କୋଞ୍ଜି ଆ କମ୍ୱାରିମର୍‌ ଡେଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ଆରି ଜିସୁନ୍‌, ଅବୟ୍‌ ସନ୍ନାସିଜନ୍‌ଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆ ମୁକ୍କାବା ତବ୍‌ନଙେନ୍‌ କି ତି ପସିଜନ୍‌ କୋଣ୍ଡୋଡାଲେ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ଆନା ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ସନ୍ନାସିଜଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ଜାତେ, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଜାତେ, ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଜାତେ, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ତୁମ୍‌ ଅଃଜ୍ଜାଏ, ଆର୍ପାୟ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆରାପ୍ପାୟ୍‌ଲିଞନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ନିୟ୍‌ ଜାତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଜନନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଅଞୁମ୍‌ଲୋଙ୍‌ନମ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ବୁତନ୍‌ ଆଗ୍ରଙେନ୍‌ ଇନ୍‌ଲେନ୍‌ ଏଗିୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ଆଡଙ୍‌ ଇନ୍‌ଲେନ୍‌ ଏରଙ୍‌ଲାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ମରାୟ୍‌ନେଲେନ୍‌ ଆ ମନ୍‌ରା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ବନ୍‌ଡ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଆନିନ୍‌ଆଡଙ୍‌ ଏରଙ୍‌ଡଙ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ବୋର୍ସା କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ତେ, ଆନିନ୍‌ ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ଞେନ୍‌ଆଡଙ୍‌ ଅଃବ୍ବର୍ଡୋଙିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ବିରୁଦମର୍‌ଲେନ୍‌ ତଡ୍‌ ଆନିନ୍‌ ଡନେମର୍‌ଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ମନ୍‌ରାଞେଞ୍ଜି, ତିଆସନ୍‌ ଆନା ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବଗିନା ଡାଆନ୍‌ ଗାଡାନେନ୍‌ ଆସନ୍‌ ତିୟ୍‌ତବେନ୍‌, ଆନିନ୍‌ ଏଙ୍ଗାଲେଜନଙ୍‌ ଆ ବର୍ତନ୍ନାନ୍‌ ଅଃନ୍ନବ୍‌ଅଡ଼ଜେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ଜିସୁନ୍‌ ଆରି ବର୍ରନେ, “ଅମଙ୍‌ଞେନ୍‌ ଆଡର୍ତନେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ନେ, ଅଙ୍ଗା ମନ୍‌ରା ଇର୍ସେଲୋଙନ୍‌ ଗବ୍‌ଲୋତେ, ତି ଆ ମନ୍‌ରା ଆ ସଙ୍କାଲୋଙ୍‌ ଅବୟ୍‌ ସୋଡ଼ା ଗୋର୍ନାଅରନ୍‌ ୟୋଡ୍‌ଲୋଙ୍‌ ୟୋଡ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆ ସେଡ୍‌ସେଡେନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ମନଙ୍‌ ଡେତେ ବନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ଆରି, ଅସିବେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଗବ୍‌ଲୋଲବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଗଡ୍‌ଲେ ସେଡ୍‌ବା, ବାର୍ସିନ୍‌ ଅଃପ୍ପଞିଡେନ୍‌ ଆ ତଗୋସିଂଲୋଙ୍‌ ଜନିରନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ଆମୋଡ୍ଡେୟ୍‌ସିନ୍‌ ଅନମେଙ୍‌ଲୋଙନ୍‌ ଗଙ୍ଗନନ୍‌ ଆମ୍ୱେନ୍‌ ଆସନ୍‌ ମନଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତଗୋସିଙନ୍‌ ଆ ବୋବ୍ବୋଡ୍‌ଜି ଅଃର୍ରବୁଏଜି, ଆରି ତଗୋନ୍‌ ଅଃପ୍ପଞିଡେ । ");
INSERT INTO juy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ଆରି, ତାଲ୍‌ଜଙ୍‌ବେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଗବ୍‌ଲୋଲବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଗଡ୍‌ଲେ ସେଡ୍‌ବା, ବାର୍ଜଙନ୍‌ ତଗୋସିଂଲୋଙନ୍‌ ଆରସେଡ୍‌ତବେନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ଆସୋତ୍ତାନ୍‌ ଅନମେଙ୍‌ଲୋଙନ୍‌ ଗଙ୍ଗନନ୍‌ ଆମ୍ୱେନ୍‌ ଆସନ୍‌ ମନଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତଗୋସିଙନ୍‌ ଆ ବୋବ୍ବୋଡ୍‌ଜି ଅଃର୍ରବୁଏଜି, ଆରି ତଗୋନ୍‌ ଅଃପ୍ପଞିଡେ । ");
INSERT INTO juy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ଆରି, ଅମଡ୍‌ବେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଗବ୍‌ଲୋଲବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ତବ୍‌ଲେ ସେଡ୍‌ବା, ବାର୍ମଡନ୍‌ ତଗୋସିଂଲୋଙନ୍‌ ଏରସେଡ୍‌ତେନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ଆମିୟ୍‌ମଡନ୍‌ ବାତ୍ତେ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗଙ୍ଗନନ୍‌ ଆମ୍ୱେନ୍‌ ଆସନ୍‌ ମନଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତଗୋସିଙନ୍‌ ଆ ବୋବ୍ବୋଡ୍‌ଜି ଅଃର୍ରବୁଏଜି, ଆରି ତଗୋନ୍‌ ଅଃପ୍ପଞିଡେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ଅନମଙନ୍‌ ଏଙ୍ଗାଲେ ବସିଡନ୍‌ ବାତ୍ତେ ମନବ୍‌ନଙନ୍‌ ଡେତେ, ଏତ୍ତେଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ତଗୋନ୍‌ ବାତ୍ତେ ମନବ୍‌ନଙନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ବସିଡନ୍‌ ମନଙ୍‌, ବନ୍‌ଡ ତିଆତେ ମରେଡ୍‌ ତଡ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଏଙ୍ଗାଲେ ମବ୍‌ରେଡ୍‌ତବୋ ? ଆମ୍ୱେଞ୍ଜି ବସିଡନ୍‌ ଅନ୍ତମ୍‌ ଡେବା, ଆରି ତର୍ଡମ୍‌ ସୟୁ ଗାମ୍‌ଲେ ଡକୋନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଜିର୍ରେ ଜିଉଦା ଡେସାରେଙନ୍‌ ଡ ଜର୍ଦନ ଅଲନ୍‌ ଆ ବାନ୍ନେଗଡ୍‌ ଜିର୍ରାୟ୍‌, ମନ୍‌ରାଞ୍ଜି ଆରି ଆମଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ଡିତାନ୍‌ ଅନ୍ତମ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ତି ଆ ବନେଡ଼ା ଲାଙ୍‌ଲେଡ୍‌ ପାରୁସିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ମାଲ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଅବୟ୍‌ ମନ୍‌ରାନ୍‌, ଆ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଆସନ୍‌ ଅନଗଡ୍‌ଲେନ୍‌ ଡକୋ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ମୋସାନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଙ୍ଗା ବନାଁୟ୍‌ବର୍‌ ତିୟ୍‌ଲବେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଅମ୍‌ରେଙଲନ୍‌ ଇଡ୍‌ଲେ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଆସନ୍‌ ମୋସାନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅନଡ଼େନ୍‌ ତିୟ୍‌ଲଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଉଗର୍‌ବେନ୍‌ ଆ ରଡୋ ଗିୟ୍‌ଲେ ମୋସାନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ କେନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଇଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ବନ୍‌ଡ ସାସ୍ତ୍ରନ୍‌ ଏଙ୍ଗାଲେ ବର୍ତନେ ଏତ୍ତେଲେ, ଗନଡେଲନ୍‌ ଆରୁଲନେନ୍‌ ସିଲଡ୍‌ ମା ଇସ୍ୱରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଓବ୍ବାମରନ୍‌ ଡ ଆଇମରନ୍‌ ଅମ୍ମେଲେ ଗବ୍‌ଡେଲେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","କେନ୍‌ ଆସନ୍‌ ଓବ୍ବାମରନ୍‌ ଆପେୟନ୍‌ ଡ ଆୟୋଙନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ, ଆ ଡୁକ୍ରିନ୍‌ ବାତ୍ତେ ମାୟ୍‌ଲନ୍‌ ଆବୟନ୍‌ ଡେତଜି, ");
INSERT INTO juy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଆରି ବାଗୁନେ ତଡ୍‌, ବନ୍‌ଡ ଆବୟନ୍‌ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ତିଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଅଙ୍ଗାଆତେ ଅବ୍‌ମାୟ୍‌ମାୟେନ୍‌, ମନ୍‌ରାନ୍‌ ତିଆତେ ତରଙ୍‌ଆନ୍ନା ଏମ୍ମେଡଙେ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ତିକ୍କି ଆନିଞ୍ଜି ଅସିଙନ୍‌ ୟର୍ରନ୍‌, ଞଙ୍‌ନେମରଞ୍ଜି କେନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, “ଅଙ୍ଗା ମନ୍‌ରା ଆ ଡୁକ୍ରିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ଆନ୍ନାବୟ୍‌ ବିବାତନେ, ଆନିନ୍‌ ଆ ଡୁକ୍ରିନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡାରିତନେ, ");
INSERT INTO juy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ଆରି, ଅନ୍ନିଙ୍‌ ଆଇବୟ୍‌ ଆ ଅୟ୍‌ତବନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆନ୍ନାମର୍‌ ବୟନ୍‌ ବିବାତନେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଡାରିତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ଜିସୁନ୍‌ ପସିଜଞ୍ଜିଆଡଙ୍‌ ସୁଙେଡାଲେ ଆସିର୍ବାଦଏତଜି ଗାମ୍‌ଲେ, ମନ୍‌ରାଞ୍ଜି ପସିଜଞ୍ଜିଆଡଙ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି, ବନ୍‌ଡ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ବବ୍‌ତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ଜିସୁନ୍‌ ତିଆତେ ଗିୟ୍‌ଲେ ବରାବେନ୍‌ କି ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ପସିଜଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ସାଡ୍‌ବାଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଏଡଙ୍‌ଡଙେଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ, କେନ୍‌ ସନ୍ନାସିଜଞ୍ଜି ଅନ୍ତମ୍‌ ଆ ମନ୍‌ରାଜି ଆସନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ମନ୍‌ରା ପସିଜନ୍‌ ଅନ୍ତମ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅଃଜ୍ଜାଏ, ଆନିନ୍‌ ଏଙ୍ଗାଲେ ଜନଙ୍‌ଡେନ୍‌ ତେତ୍ତେ ଅଃଗନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ପସିଜଞ୍ଜିଆଡଙ୍‌ କୋଣ୍ଡୋଏନ୍‌ ଆରି ଆବବ୍‌ଲୋଙଞ୍ଜି ଆସିନ୍‌ ଡକ୍କୋଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆସିର୍ବାଦଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଜିସୁନ୍‌ ଆରି ଜିର୍‌ଜିରନ୍‌ ଆସ୍ରାଜେନ୍‌ ଆଡିଡ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଇର୍ରେ ଜିସୁନ୍‌ ଆ ମୁକ୍କାଗଡ୍‌ ତୁଡ଼ୁମ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ଏ ମନଙ୍‌ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞନାଙନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଇନି ଏଙ୍ଗାନାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ମନଙ୍‌ ଗାମ୍‌ଲେ ଇନିବା ବର୍ରିଁୟ୍‌ ? ଇସ୍ୱରନ୍‌ ତୁମ୍‌ ଅବୟ୍‌ନେ ମନଙ୍‌, ଆନିନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆନ୍ନିଙ୍‌ ଆରି ମନଙ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ବନାଁୟ୍‌ବରଞ୍ଜି ତ ଆମନ୍‌ ଜନା, ‘ମନ୍‌ରାନ୍‌ ଏରବ୍ବୁଡଙ୍‌, ଏଡାରିଡଙ୍‌ନେ, ଏରାଉଡଙ୍‌ନେ, କଣ୍ଡାୟ୍‌ସାକିନ୍‌ ଏତିୟ୍‌ଡଙେ, ଏବୁର୍ଡଡଙେ, ଆପେୟନ୍‌ ଆୟୋଙନ୍‌ଆଡଙ୍‌ ମାନ୍ନେବାଜି ।’” ");
INSERT INTO juy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ ବନେଣ୍ଡିଆଞେନ୍‌ ସିଲଡ୍‌ ଞଣ୍ଡ୍ରମ୍‌ଲନ୍‌ ଜିର୍ରାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଡନୁଙ୍‌ୟମନ୍‌ ବାତ୍ତେ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙ୍‌ଡାଲେ ବରେନ୍‌, “ଆମନ୍‌ ଅବୟ୍‌ ବର୍ନେଲୋଙନ୍‌ ଅସୋୟ୍‌ ଡକୋ, ଆମନ୍‌ ଜିର୍ରେ ଅଡ଼୍‌କୋନ୍‌ ଅନର୍ଜେନମ୍‌ ତମ୍‌ଲୋଙ୍‌ ତମ୍‌ଲେ ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ ତିୟାଜି, ଆମନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ରନ୍ନାନ୍‌ ଞାଙ୍‌ତେ, ଆରି ଜିର୍ରେ ଞେନ୍‌ଆଡଙ୍‌ ଆୟ୍‌ ସଣ୍ଡୋଙିୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ବନ୍‌ଡ କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆ ମୁକ୍କାନ୍‌ ଅସରେନ୍‌ ଆରି ଅମ୍ମୁସୁକାଲନ୍‌ ଜିରେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ ଗମାଙ୍‌ମର୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଏର୍ରେ ଆଙାଙ୍‌ଡାଲେ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଗମାଙ୍‌ମରଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗଙ୍ଗନନ୍‌ ଡିଅଙ୍ଗା ଆ ଡଣ୍ଡ !” ");
INSERT INTO juy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ଆ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଞଙ୍‌ନେମରଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରି ବରେଞ୍ଜି, “ପସିୟ୍‌ଜି, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗଙ୍ଗନନ୍‌ ଡିଅଙ୍ଗା ଆ ଡଣ୍ଡ ! ");
INSERT INTO juy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗମାଙ୍‌ମରନ୍‌ ଆଗ୍ରନ୍‌ତେନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ସୁର୍ଜାନ୍‌ ଆ ପତୁଡ୍‌ ଗଡ୍‌ ଓଟନ୍‌ ଆ ଜନିର୍‌ ଲଗଡ଼ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଆକ୍ରାନ୍‌ ସାନ୍ନିଡାଲେ ତର୍ଡମ୍‌ ଅଲ୍‌ବର୍ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନା ଅନୁରନ୍‌ ଞାଙେ ?” ");
INSERT INTO juy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ “ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙେଞ୍ଜି କି ବର୍ରନେ, କେନ୍‌ଆତେ ମନ୍‌ରାନ୍‌ ଆସନ୍‌ ଅଃଡ୍ଡେଏ, ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆସନ୍‌ ଇଜ୍ଜା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆସନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଡେଆୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଗିଜା, ଇନ୍‌ଲେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆମନ୍‌ଆଡଙ୍‌ ଏସଣ୍ଡୋଙ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ଜିସୁନ୍‌ ବର୍ରନେ, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ମନ୍‌ରା ଞେନ୍‌ ଆସନ୍‌ ଡ ମନଙ୍‌ବର୍‌ଞେନ୍‌ ଅନପ୍ପୁଙନ୍‌ ଆସନ୍‌ ଅସିଂ, ବୋଞାଙ୍‌, ତନାନ୍‌, ଅୟୋଙ୍‌, ଆପେୟ୍‌, ପସିୟ୍‌ବୁଲାଃ କି ଲବସିମା ଅମ୍‌ରେଙ୍‌ତେ, ");
INSERT INTO juy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ଆରି ନମି ଆ ଜୋଗାଇଂ ବସଅ ଗୁନା ଅସିଂ, ବୋଞାଙ୍‌, ତନାନ୍‌, ଅୟୋଙ୍‌, ପସିୟ୍‌ବୁଲାଃ ଆରି ଲବସିମା ଞାଙ୍‌ତେ, ଆରି ଡନଣ୍ଡାୟନ୍‌ ନିୟ୍‌ ଞାଙ୍‌ତେ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତିକ୍କି ଆ ଜୋଗାଲୋଙ୍‌ ଆନିନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ବନ୍‌ଡ ଆମ୍ମୁଙ୍‌ ଆଡ୍ରକୋଏଞ୍ଜି ଆ ମନ୍‌ରାଞ୍ଜି ଗୋଗୋୟ୍‌ନେ ତିକ୍କିତଜି ଆରି ତିକ୍କି ଆଡ୍ରକୋଏଞ୍ଜି ଆ ମନ୍‌ରାଞ୍ଜି ଗୋଗୋୟ୍‌ନେ ଆମ୍ମୁଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ଆନିଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ତଙରନ୍‌ ଜିସୁନ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ଲନେ, ଞଙ୍‌ନେମରଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି ଆରି ଆସ୍ରଣ୍ଡୋଙେଞ୍ଜି ଆ ମନ୍‌ରାଜି ବତଙେଞ୍ଜି । ତିଆସନ୍‌ ଆନିନ୍‌ ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଆରି ଆନ୍ନାଡାଲେ, ଆନିନ୍‌ଆଡଙ୍‌ ଇନି ଇନି ଡେରୟ୍‌ତେ ତି ଅଡ଼୍‌କୋନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅମ୍‌ଡଙ୍‌ବା, ଇନ୍‌ଲେଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଜିର୍ତବୋ, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତନେ, ଆରି ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ବାଁୟ୍‌ସିଡାଲନ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତଜି, ");
INSERT INTO juy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସୟ୍‌ସୟ୍‌ମୁତଜି, ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ବିଜଲ୍‌ତଜି, ଆନିନ୍‌ଆଡଙ୍‌ ସାମକାନ୍‌ ବାତ୍ତେ ତିଡ୍‌ତଜି କି ରବ୍ବୁତଜି ବନ୍‌ଡ ଆନିନ୍‌ ଏର୍ତାଲୋଙ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ତିକ୍କି ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ଜାକୁବନ୍‌ ଡ ଜନନ୍‌ ଜିସୁନ୍‌ ଆ ମୁକ୍କାବା ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗାତେ ଏବେଡ୍‌ତମ୍‌, ତିଆତେ ଆମନ୍‌ ଇନ୍‌ଲେନ୍‌ ତିୟ୍‌ଲେନ୍‌, କେନ୍‌ଆତେ ଲଡୟ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେନ୍‌ ଆସନ୍‌ ଇନି ଲୁମାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେନ୍‌ ଲଡୟ୍‌ତବେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ରାଜ୍ୟନମ୍‌ ଆ କୁର୍ସିଲୋଙ୍‌ ତଙ୍କୁମେନ୍‌ ଆଡିଡ୍‌ ଅବୟ୍‌ନେ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ନମ୍‌ ଆରି ଅବୟ୍‌ନେ ଅର୍କାବଡ଼ିଗଡ୍‌ନମ୍‌ ଅବ୍‌ତଙ୍କୁମ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେନ୍‌ ଇନି ଏଗାମ୍‌ତେ, ତିଆତେ ଆମ୍ୱେନ୍‌ ଏଃଜ୍ଜନାଏ । ଞେନ୍‌ ଗରାଲୋଙ୍‌ତାଞନ୍‌ ଅରସୁଡାନ୍‌ ଆ ଗିଲ୍ଲଲୋଙ୍‌, ତେତ୍ତେ ଆମ୍ୱେନ୍‌ ଗାଲେ ଏରପ୍ତିତେ ପଙ୍‌ ? ଅଡ଼େ ଞେନ୍‌ ଅଙ୍ଗା ରନବୁ ତବ୍ବୁବ୍‌ଡାଲୋଙ୍‌ ତବ୍ବୁବ୍‌ଡାତନାୟ୍‌, ଆମ୍ୱେନ୍‌ ତେତ୍ତେ ତବ୍ବୁବ୍‌ଡାଲନ୍‌ ଏରପ୍ତିତେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଏରପ୍ତିତାୟ୍‌ ।” ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଅଙ୍ଗା ଗିଲ୍ଲଲୋଙ୍‌ ଗାତାୟ୍‌, ତେତ୍ତେ ଆମ୍ୱେନ୍‌ ଏଗାତେ, ଆରି ଞେନ୍‌ ଅଙ୍ଗା ତବ୍ବୁବ୍‌ଡାଲୋଙ୍‌ ତବ୍ବୁବ୍‌ଡାତନାୟ୍‌, ତେତ୍ତେ ଆମ୍ୱେନ୍‌ ଏତବ୍ବୁବ୍‌ଡାତନେ, ");
INSERT INTO juy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ବନ୍‌ଡ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ଞେନ୍‌ ଡ ଅର୍କାବଡ଼ିଗଡ୍‌ଞେନ୍‌ ଅନବ୍‌ତଙ୍କୁମନ୍‌ ଆସନ୍‌ ଅଦିକାରଞେନ୍‌ ତଡ୍‌, ଆର୍ପାୟ୍‌ ଆନାଜି ଆସନ୍‌ ଆପେୟ୍‌ ଇସ୍ୱରନ୍‌ ତି ଆ କୁର୍ସି ଅବ୍‌ଜାଡାଏନ୍‌ ଆନିଞ୍ଜି ତଙ୍କୁମ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ଆରି ଦସଜଣ ଞଙ୍‌ନେମରଞ୍ଜି କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଜାକୁବନ୍‌ ଡ ଜନନ୍‌ ଆ ଉପରେଙ୍‌ ବରାବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଲେ ବରେଞ୍ଜି, “ଏର୍‌ଡର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ଆନାଜି ସାସନତଜି ଆନିଞ୍ଜି ଆମଙଞ୍ଜି ଅବ୍‌ପୁର୍‌ପୁର୍‌ତଞ୍ଜି ଆରି ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରଞ୍ଜି ଆମଙଞ୍ଜି ଅବ୍‌ସୋଡ଼ାସୋଡ଼ାତଞ୍ଜି, କେନ୍‌ଆତେ ଆମ୍ୱେଞ୍ଜି ଜନା । ");
INSERT INTO juy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ବନ୍‌ଡ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଏତ୍ତେଗୋ ତଡ୍‌, ବନ୍‌ଡ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆନା ସବ୍‌ତଙ୍‌ନେନ୍‌ ଆସନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ ସନାକ୍କେମର୍‌ବେନ୍‌ ଡେଏତୋ । ");
INSERT INTO juy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ଆରି ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆନା ଆମ୍ମୁଗଡ୍‌ମର୍‌ନେନ୍‌ ଆସନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଆ କମ୍ୱାରିମର୍‌ ଡେଏତୋ । ");
INSERT INTO juy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ଅନବ୍‌ସାକ୍କେନେବାନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌, ଆର୍ପାୟ୍‌ ସନାକ୍କେବାନ୍‌ ଆରି ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ତନାଣ୍ଡେବାନ୍‌ ଆ ପରାନ୍ନାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ତିକ୍କି ଆନିଞ୍ଜି ଜିରିଓ ଗଡ଼ାନ୍‌ ଅଡ଼ୋଏଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌, ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଡ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ସରିନ୍‌ ଜିରିଓନ୍‌ ସିଲଡ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ଅନେଙ୍‌ ତଙରନ୍‌ ଅବୟ୍‌ ଆ କାଡ଼ୁମରନ୍‌ ବେବ୍ବେଡ୍‌ଲନେ, ତି ମନ୍‌ରାନ୍‌ ଆଞୁମ୍‌ ବାର୍ଟିମୟ, ଆନିନ୍‌ ଟିମାୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ନାଜରିତ ଜିସୁନ୍‌, କେନ୍‌ଗଡ୍‌ ଜିର୍ତେ ଗାମ୍‌ଲେ କାଡ଼ୁମରନ୍‌ ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ ବାବ୍ବାବ୍‌ଲେ ବର୍ରନେ, “ଏ ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିସୁ, ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ସିଲତ୍ତେ କଡ଼ିଙା ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବବ୍‌ତଙେଞ୍ଜି, ବନ୍‌ଡ ଆନିନ୍‌ ଆରି ବାବ୍ବାବ୍‌ଲେ ବର୍ରନେ, “ଏ ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିସୁ, ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ସିଲତ୍ତେ ଜିସୁନ୍‌ ତନଙ୍‌ଡାଲେ ବର୍ରନେ, “ଆନିନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେବା ।” ଆନିଞ୍ଜି ତି କାଡ଼ୁମରନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଲେ ବରେଞ୍ଜି, “ଅବ୍ବୋମଙ୍‌ନା, ଡୋନା, ଆନିନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ତିଆସନ୍‌ ଆନିନ୍‌ ଆ ମାଟନ୍‌ ସେଡେନ୍‌ କି ଡୋଲନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ଆମନ୍‌ ଆସନ୍‌ ଇନି ଲୁମାୟ୍‌ ଗାମ୍‌ଲେ ଆମନ୍‌ ଲଡୟ୍‌ତମ୍‌ ?” ତି କାଡ଼ୁମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଞେନ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ସାୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜିରା, ଡର୍ନେନମ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲମ୍‌ ।” ସିଲତ୍ତେମା ଆନିନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଗିୟ୍‌ଲୋଙ୍‌ ଗିୟ୍‌ଲେ ତଙରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ଅଙ୍ଗା ଆଡିଡ୍‌ ଆନିଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଆ ତୁୟାୟ୍‌ ଜିତବୁରନ୍‌ ଆ ତୟ୍‌ତୟ୍‌ ବେତ୍‌ପାଗିନ୍‌ ଡ ବେତନିଆନ୍‌ ଅଡ଼ୋଏଞ୍ଜି, ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ବାଗୁନେ ଏନ୍ନେଲେ ବର୍ରେ ଆପ୍ପାୟେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ମୁକ୍କାଗଡ୍‌ବେନ୍‌ ତି ଆ ସାଇ ଇୟ୍‌ବା, ତେତ୍ତେ ଏଗନେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନା ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଆଙ୍ଗିୟ୍‌ ଆନ୍ନିଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ତଙ୍କୁମେ, ତିଅନ୍ତମ୍‌ ଅବୟ୍‌ ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ଆତବାଡନ୍‌ ଇୟ୍‌ତେ ଏଗିଜେ, ତିଆତେ ପଡ୍ଡଙ୍‌ଲେ ପାଙାୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ଆରି, ଆନ୍ନିଙ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଇନିବା ଏପଡ୍ଡଙ୍‌ତେ ଗାମ୍‌ଲେ ବର୍ରବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ଆତେ ପ୍ରବୁନ୍‌ ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ଗାମ୍‌ଲେ ଇୟ୍‌ ବର୍ନାବା, ଆନିନ୍‌ ଆରି ଅନ୍ନବ୍‌ଡିଙ୍‌ଲନ୍‌ ତିଆତେ ତେନ୍ନେ ଲଆପ୍ପାୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ଆନିଞ୍ଜି ଜିର୍ରେ ଗରନ୍ନେନ୍‌ ଆ ତୁୟାୟ୍‌ ଅବୟ୍‌ ଅସିଙନ୍‌ ଆ ଡାଣ୍ଡଲୋଙ୍‌ ଅବୟ୍‌ ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ଆତବାଡନ୍‌ ଗିୟ୍‌ଲେ ତିଆତେ ଇୟ୍‌ଲେ ପଡ୍ଡଙେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ସିଲତ୍ତେ ତେତ୍ତେ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ଲାଙ୍‌ଲେନ୍ନେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ପଡ୍ଡଙ୍‌ଲେ ଇନି ଏଏଙ୍ଗାତେ ?” ");
INSERT INTO juy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ଜିସୁନ୍‌ ଏଙ୍ଗାଲେ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବର୍ରେ ଆପ୍ପାୟେଞ୍ଜି, ତିଅନ୍ତମ୍‌ ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ପାଙ୍‌ବା ଗାମ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ଜିସୁନ୍‌ ଆମଙ୍‌ ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ପାଙ୍‌ଲେ ଆନିଞ୍ଜି ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ଆ ସିନ୍‌ରିଞ୍ଜି ବେଲେଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଗୋଡୋଁୟନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ତଙ୍କୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ଆରି ଜବ୍ର ମନ୍‌ରାଜି ରୋତ୍ତଲୋଙନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ସିନ୍‌ରି ବେଲେଞ୍ଜି ଆରି ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି କୋତ୍ତାନ୍‌ ସିଲଡ୍‌ ଅଲାନ୍‌ ଡେୟ୍‌ଲେ ପାଙ୍‌ଲେ ରୋତ୍ତଲୋଙନ୍‌ ବେଲେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ଆରି, ଆମ୍ମୁଙ୍‌ଗଡ୍‌ ତିକ୍କିଗଡ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆ ମନ୍‌ରାଜି ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରଞ୍ଜି, “ଓସାନ୍ନା ! ପ୍ରବୁନ୍‌ ଆ ଆଞୁମ୍‌ଲୋଙ୍‌ ଆନା ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଇସ୍ୱରନ୍‌ ଆସିର୍ବାଦଏତୋ ! ");
INSERT INTO juy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ଆପେୟ୍‌ଲେନ୍‌ ଦାଉଦନ୍‌ ଆ ରାଜ୍ୟ ଆଜିର୍ତାଞନ୍‌ଆତେ ପ୍ରବୁନ୍‌ ଆସିର୍ବାଦଏତୋ ! ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଓସାନ୍ନା !” ");
INSERT INTO juy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ତିକ୍କି ଜିସୁନ୍‌ ଜିରୁସାଲମନ୍‌ ଜିର୍ରେ ସରେବାସିଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗନେ, ଆରି ଏର୍ରେ ଅଡ଼୍‌କୋନ୍‌ ଆଙାଙ୍‌ଡାଲେ ଆସ୍ରାଲ୍ଲୁମେନ୍‌ ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ବେତନିଆନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ଆବାର୍ତାନ୍‌, ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ବେତନିଆନ୍‌ ସିଲଡ୍‌ ଜିରୁସାଲମନ୍‌ ଆୟର୍ରନାଞଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଡୋଲେଜେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ଆରି, ଜିସୁନ୍‌, ଅଲାନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଅବୟ୍‌ ଲୁଆନୁବନ୍‌ ସଙାୟ୍‌ ସିଲଡ୍‌ ଗିୟ୍‌ଲେ, ଅସମୟ୍‌ ତେତ୍ତେ ଆଜନ୍‌ ଇୟ୍‌ତେ ଞାଙ୍‌ନାୟ୍‌ ଜାଆରୋ ଗାମ୍‌ଲେ, ଆସାଡାଲନ୍‌ ଲୁଆନୁବନ୍‌ ଇୟେନ୍‌ । ବନ୍‌ଡ ଆନିନ୍‌ ତେତ୍ତେ ଜିର୍ରେ ଆ ଅଲାନ୍‌ ତୁମ୍‌ ଇୟ୍‌ଲେ ଞାଙେ, ଇନ୍ନିଙ୍‌ ଆରି ଅଃନ୍ନିୟ୍‌ଞାଙ୍‌ଲୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆ ବନେଡ଼ା ଲୁଆନୁବନ୍‌ ଆରଜତେନ୍‌ ଆ ଡିନ୍ନା ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଲୁଆନୁବନ୍‌ ସୟ୍‌ପଲେ ବର୍ରନେ, “ଆରି ଆଙ୍ଗିୟ୍‌ ଜା ଆନ୍ନିଙ୍‌ ଅମଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ଅଜନ୍‌ ଜୋମ୍‌ଡଙେ ତଡ୍‌ ।” ଆ ଞଙ୍‌ନେମରଞ୍ଜି କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଜିର୍ରାଜି, ଆରି ଆନିନ୍‌ ସରେବାସିଙନ୍‌ ଗନ୍‌ଲନ୍‌ ତେତ୍ତେ, ଜନ୍ତୁଞ୍ଜି ଅନମଙନ୍‌ ଆସନ୍‌ ତମ୍‌ତମ୍‌ନେମରଞ୍ଜି, ଞିଞିନେମରଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ଡୁଙେଞ୍ଜି, ଆରି ବାର୍‌ବାର୍‌ଡାବ୍‌ମରଞ୍ଜି ଆ ମେଜ ଡ କୁକ୍କୁର୍‌ ବେପାରମରଞ୍ଜି ଆ କୁର୍ସି ସବ୍‌ଡିଡାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ଆରି ଆନିନ୍‌, ସରେବାସିଙନ୍‌ ଆ ଡୁଆରାଗଡ୍‌ ଇନ୍ନିଙ୍‌ଜା ତରମ୍‌ତମଞ୍ଜି ପନାଙନ୍‌ ଆସନ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ଜିର୍‌ଜିର୍ରୋ, ");
INSERT INTO juy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ଆରି ଆନିନ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ଲେ ବର୍ରନେ, “ସାସ୍ତ୍ରଲୋଙନ୍‌ ଏନ୍ନେଲେ ଆଇଡିଡନ୍‌ ଡକୋ, ‘ଅସିଂଞେନ୍‌ ପୁର୍ତିନ୍‌ ଅଡ଼୍‌କୋ ଜାତିନ୍‌ ଆ ମନ୍‌ରାଜି ଆସନ୍‌ ପାର୍ତନାସିଂ ଗାମ୍‌ଲେ ବର୍ନେନ୍‌ ଡେତେ ।’ ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ତିଆତେ ରାଉମରଞ୍ଜି ଆ ଡଲ୍ଲି ଏଏମ୍ମେଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ରବ୍ବୁବୋ ଗାମ୍‌ଲେ ତଙରନ୍‌ ସାଜେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ଞନଙନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ସାନ୍ନି ଆଡ୍ରେଏଞ୍ଜି ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ଆରି, ଆସ୍ରାଲ୍ଲୁମେନ୍‌ ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ଡୋତାନ୍‌, ତି ଆ ତଙର୍‌ଗଡ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌, ଆନିଞ୍ଜି ଲୁଆନୁବନ୍‌ ଆଜଡନ୍‌ ସିଲଡ୍‌ ଆସର୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ତିଆସନ୍‌ ପିତ୍ରନ୍‌ ଆମ୍ମୁଙ୍‌ ଆ ବର୍ନେ ମନ୍ନେଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଗିଜା, ଆମନ୍‌ ଅଙ୍ଗା ଲୁଆନୁବ୍‌ ସୟ୍‌ପଏନ୍‌, ତିଆତେ ଅସରେନ୍‌ନି ।” ");
INSERT INTO juy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଡର୍ନାବା । ");
INSERT INTO juy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆନାଜନଙ୍‌ କେନ୍‌ ବରୁନ୍‌, ଆମନ୍‌ ଡୋଲନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଇୟ୍‌ ଗଲୋଅମ୍‌ତୋ ଗାମ୍‌ଲେ ବର୍ତେ, ଆରି ଆ ଉଗର୍‌ଲୋଙନ୍‌ ଏର୍‌ଡାଲ୍‌ଗଡ୍‌ଲେ, ଅଙ୍ଗାତେ ବର୍ତନାୟ୍‌, ତିଆତେ ଗଡେଲ୍‌ତେ ଗାମ୍‌ଲେ ଡର୍ତନେ, ଆନିନ୍‌ ଆସନ୍‌ ତିଆତେ ଗଡେଲ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ତିଆସନ୍‌, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଅଙ୍ଗାତେ ଏପାର୍ତନାତନ୍‌ ଆରି ଏବେଡ୍‌ତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଏଞାଙ୍‌ଲାୟ୍‌ ଗାମ୍‌ଲେ ଡର୍ନାବା, ସିଲତ୍ତେ ତି ଅଡ଼୍‌କୋନ୍‌ ଏଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ଆରି, ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଆଡିଡ୍‌ ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ଏଡୋତନ୍‌, ଆନ୍ନିଙ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଇନ୍ନିଙ୍‌ ଆ ବର୍ନେ ଡକୋଏନ୍‌ ଡେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ କେମାବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ନିୟ୍‌ ଅଡ଼୍‌କୋ ଇର୍ସେବେନ୍‌ କେମାତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଃକ୍କେମାଲୋ ଡେନ୍‌, ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଡ୍ରକୋତନେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ନିୟ୍‌ ଇର୍ସେବେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଅଃକ୍କେମାବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ଜିସୁନ୍‌ ଡ ଞଙ୍‌ନେମରଞ୍ଜି ଆରି ଜିରୁସାଲମନ୍‌ ଜିର୍ରାଜି; ଆରି, ଜିସୁନ୍‌ ସରେବାସିଙନ୍‌ ଆବ୍ରୁଲ୍ଲେଏନ୍‌ ଆଡିଡ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି, ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାପୁର୍‌ମରଞ୍ଜି ଆମଙନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ଆମନ୍‌ ଅଙ୍ଗା ଆ ସନୋଡ଼ାନେନ୍‌ ବାତ୍ତେ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ତେ ? ଆରି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ଆନା ଆମନ୍‌ଆଡଙ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ତିୟ୍‌ଲମ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଅବୟ୍‌ ବର୍ନେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଞେନ୍‌ ଜାଲଙିଁୟ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଅଙ୍ଗା ଆ ସନୋଡ଼ାନେ ବାତ୍ତେ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ତାୟ୍‌, ତିଆତେ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ଜନନ୍‌ ଆ ତବ୍ବୁବ୍‌ଡା ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅଡ଼େ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡେଏନ୍‌ ? ଞେନ୍‌ ଜାଲଙିଁୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ସିଲତ୍ତେ ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଡାଲନ୍‌ ବର୍ରଞ୍ଜି, “ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଏଗାମ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଗାମ୍‌ତେ, ‘ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଇନିଜି ବର୍ରନେ ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଇନିବା ଏଃଡ୍ଡର୍ରନେ ?’ ");
INSERT INTO juy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ଅଡ଼େ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଗାମ୍‌ଲେ ବର୍ନେବୋ ପଙ୍‌ ?” ବନ୍‌ଡ ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବତଙେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଅବୟ୍‌ ଆଜାଡ଼ିଡମ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଗାମ୍‌ଲେ ମାନ୍ନେଏଞ୍ଜି । ତିଆସନ୍‌ ଆନିଞ୍ଜି ଏନ୍ନେଲେ ବର୍ନେନ୍‌ ଆସନ୍‌ ଅଃନ୍ନୋମଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଜନା ତଡ୍‌ ।” ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଅଙ୍ଗା ଆ ସନୋଡ଼ାନେ ବାତ୍ତେ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ତାୟ୍‌, ତିଆତେ ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଃବ୍ବର୍ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ବରେଞ୍ଜି । “ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ତୁବ୍‌ଲେ କୋତ୍ତାନ୍‌ ଏର୍ରେ ତରେନ୍‌ ଆରି ଦ୍ରାକ୍ୟାଜନ୍‌ ଞାଲ୍‌ଞାଲନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ଦ୍ରାକ୍ୟାଡୋଙ୍କାନ୍‌ ଗାୟ୍‌ଲୋଙ୍‌ ଗାୟ୍‌ଲେ ଜରଗେସିଙନ୍‌ ତୁବେନ୍‌, ଆରି ଅର୍ରମରଞ୍ଜି ଆସିଲୋଙ୍‌ ତି ଆ କୋତ୍ତା ବାଗାନ୍‌ ତିୟ୍‌ଲୋଙ୍‌ ତିୟ୍‌ଲେ ବଡେସାନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ତିକ୍କି ଅର୍ରମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ଆଜଲୋଙ୍‌ ସିଲଡ୍‌ ଆ ବନନ୍ତାନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଆଡିନ୍ନାଇଙନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ କମ୍ୱାରିରନ୍‌ଆଡଙ୍‌ ଆମଙଞ୍ଜି ଆପ୍ପାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ବନ୍‌ଡ ଅର୍ରମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ତିଡେଞ୍ଜି କି ଆରିକ୍କାସିନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ଆନିନ୍‌ ଆରି, ଆମଙଞ୍ଜି ଆରି ଅବୟ୍‌ କମ୍ୱାରିମରନ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌; ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ପପ୍‌ତାବବେଞ୍ଜି ଆରି ଅଲ୍ଲଗନ୍‌ଡ୍ରୟ୍‌ ଏମ୍ମେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ଆନିନ୍‌ ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌; ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ସମ୍ୱବେଞ୍ଜି । ସିଲତ୍ତେ ଆନିନ୍‌ ଆରି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି; ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ଆନିଞ୍ଜି ତିଡେଞ୍ଜି ଆରି ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ସମ୍ୱବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ଆରି ଆମଙନ୍‌ ଆ ଡନୁଙ୍‌ୟମ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ତୁମ୍‌ ଡକୋଏନ୍‌ । ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ଆଡଙ୍‌ ଆନିଞ୍ଜି ମାନ୍ନେତଜି, ଅବ୍‌ଡିସୟ୍‌ଲେ ଆନିନ୍‌ ଆତନିକ୍କି ଆଡିଡ୍‌ ଆମଙଞ୍ଜି ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ବନ୍‌ଡ ତି ଅର୍ରମରଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, ‘କେନ୍‌ ତ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌, ୟବା କେନ୍‌ ଆନିନ୍‌ ଏରବ୍ବୁବା; ଏତ୍ତେଲ୍‌ଡେନ୍‌ କୋତ୍ତାନ୍‌ ଇନ୍‌ଲେନ୍‌ ଡେଡେଲଙ୍‌ତନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲୋଙ୍‌ ଞମ୍‌ଲେ ତିଡେଞ୍ଜି କି ରବ୍ବୁଏଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ଡୁଆରାନ୍‌ ସେଡେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ଏତ୍ତେଲ୍‌ଡେନ୍‌ କୋତ୍ତାମରନ୍‌ ଇନି ଏଙ୍ଗାନେ ? ଆନିନ୍‌ ଜିର୍ରେ ବାଗାଅର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ରବ୍ବୁଆଜେଜି ଆରି ଆନ୍ନାମର୍‌ଜି ଆସିଲୋଙ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ବାଗାନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତିୟେଜି । ");
INSERT INTO juy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ଆମ୍ୱେଞ୍ଜି ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ନିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏପଡ଼େନେ ପଙ୍‌ ? ‘ଗୁସିଂମରଞ୍ଜି ଅଙ୍ଗା ଅରେଙ୍‌ ବାସ୍ସେଏଞ୍ଜି, ତିଆତେ କୁନେନ୍‌ ଆ ମୁଡ଼ ଅରେଙ୍‌ ଡେଲୋ; ");
INSERT INTO juy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ଆତେ ଡେଏନ୍‌, ଆରି ତିଆତେ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ଲେନ୍‌ ସରାନ୍ନିଡାନ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ତିଆସନ୍‌ ଜିଉଦି ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବତଙେଞ୍ଜି; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ତି ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ସେଙ୍‌ଲେ ବର୍ରନେ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଜନାଏଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ଜିସୁନ୍‌ ଆ ସରିଡ୍‌ସିଡ୍‌ବର୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ପାରୁସିଞ୍ଜି ଡ ଏରୋଦ ରାଜାନ୍‌ ଆ ଡଡ଼ ଆ ମନ୍‌ରାଜି ଲାଙ୍‌ଲେନ୍ନେ ଜିସୁନ୍‌ ଆମଙ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ଆନିଞ୍ଜି ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ଜନା, ଆମନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଆରି ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃବ୍ବତଙେ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଅଃଡ୍ଡୁଲ୍‌ମଡେ, ଆରି ଆଜାଡ଼ିଡମ୍‌ ମନ୍‌ରାନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ତେ । ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ବର୍ରେନ୍‌, କାଇସରନ୍‌ଆଡଙ୍‌ ପାନୁନ୍‌ ଏତିୟାୟ୍‌ ଅଡ଼େ ଇଜ୍ଜା ?” ");
INSERT INTO juy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ ଇସ୍କତ୍ତାଞ୍ଜି ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ “ବରେଞ୍ଜି, ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ଏମାଲ୍‌ତିଁୟ୍‌ ? ଅବୟ୍‌ ଆ ଗୁଣ୍ଡାଡାବନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ପାଙାୟ୍‌ବା, ଞେନ୍‌ ତିଆତେ ଗିୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ତିଆତେ ପାଙ୍‌ଲାଜି । ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ ତେନ୍ନେ ଆନା ଆ ମୁକ୍କା ଆରି ଆନା ଆଞୁମ୍‌ ଡକୋ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି “କାଇସରନ୍‌ଆତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, “ଅଙ୍ଗାତେ କାଇସରନ୍‌ଆତେ ତିଆତେ କାଇସରନ୍‌ ତିୟ୍‌ବା; ଆରି ଅଙ୍ଗାତେ ଇସ୍ୱରନ୍‌ଆତେ ତିଆତେ ଇସ୍ୱରନ୍‌ ତିୟ୍‌ବା ।” ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ଆକ୍ରାନ୍‌ ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ୟନର୍ମେଙନ୍‌ ଇଜ୍ଜା ଆଗ୍ରାମ୍‌ତେଞ୍ଜି ଆ ସାଦୁକିଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି; ");
INSERT INTO juy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ମୋସାନ୍‌ ଇଡେନ୍‌, ଅନ୍ନିଙ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଏର୍‌କନୋଡନନ୍‌ ରବୁଏନ୍‌, ଆରି ଆ ଡୁକ୍ରିନ୍‌ ଆମେଙ୍‌ ଡକୋଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆ ଓବ୍ବାନ୍‌, ତି ଜୁଆର୍‌ବଜନ୍‌ ବୟନ୍‌ ବିବାଡାଲନ୍‌ ଆରବୁମର୍‌ ଆସନ୍‌ ପସିଜନ୍‌ କୋଡେତୋ । ");
INSERT INTO juy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ଗିଜା, ସାତ ବନୋଞାଙ୍‌ ଡକୋଏଞ୍ଜି; ଆପର୍ତମ୍ମୁମର୍‌ ଅବୟ୍‌ ଆଇମରନ୍‌ ବୟନ୍‌ ବିବାଲନେ, ବନ୍‌ଡ ଏର୍‌କନୋଡନନ୍‌ ଓବ୍ବାମରନ୍‌ ରବୁଏନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ତିକ୍କି ଆ ସନଣ୍ଡୋଙ୍‌ମର୍‌ ଆ ବୋଞାଙନ୍‌ ଆ ଡୁକ୍ରି ବୟନ୍‌ ବିବାଲନେ, ବନ୍‌ଡ ଆନିନ୍‌ ନିୟ୍‌ ଏର୍‌କନୋଡନନ୍‌ ରବୁଏନ୍‌, ଆରି ଆ ସନଣ୍ଡୋଙ୍‌ମର୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ମା ବିବାଲନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ଆରି ସାତଜଣଞ୍ଜି ତି ଆଇମରନ୍‌ ବୟନ୍‌ ଅବୟ୍‌ନେ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଅବୟ୍‌ନେ ବିବାଲଞ୍ଜି, ବନ୍‌ଡ ଅଡ଼୍‌କୋଞ୍ଜି ଏର୍‌କନୋଡନନ୍‌ ରବୁଏଞ୍ଜି; ଅଡ଼୍‌କୋଞ୍ଜି ଆତନିକ୍କି ତି ଆଇମରନ୍‌ ନିୟ୍‌ ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ତିଆସନ୍‌ ଅଙ୍ଗା ଡିନ୍ନା ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋତଞ୍ଜି, ତିଆଡିଡ୍‌ ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ତି ଆଇମରନ୍‌ ଆନା ଆ ଡୁକ୍ରି ଡେତେ ? ଆନିଞ୍ଜି ତ ସାତଜଣଞ୍ଜି ତି ଆଇମରନ୍‌ ବୟନ୍‌ ବିବାଲଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, “ଡରମ୍ମ ସାସ୍ତ୍ରନ୍‌ ଡ ଇସ୍ୱରନ୍‌ ଆ ବୋର୍ସା ଏଃଜ୍ଜନାଏନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆଡ଼ଆୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ତିଆସନ୍‌ ଆରବୁମରଞ୍ଜି ୟର୍ମେଙେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଆରି ଅଃଞାଙ୍‌ବୟ୍‌ନେଜି କି ଅଃସୁଉଂନେଜି, ଆର୍ପାୟ୍‌ ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଅନ୍ତମ୍‌ ଡକୋତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ବନ୍‌ଡ ଆରବୁମରଞ୍ଜି ୟର୍ମେଙ୍‌ତଜି, ତି ଆ ବର୍ନେ ମୋସାନ୍‌ ଆ ସାସ୍ତ୍ରଲୋଙ୍‌ ଆଡୁଡୁନ୍‌ ଆ ଜାଡ଼ିଆ ଆ ବର୍ନେ ଏର୍‌ପଡ଼େନେ ପଙ୍‌ ? ତେତ୍ତେ ଏନ୍ନେଲେ ଆଇଡିଡନ୍‌ ଡକୋ, ଇସ୍ୱରନ୍‌ ମୋସାନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଞେନ୍‌ ଅବ୍ରାମନ୍‌ ଆ ଇସ୍ୱର, ଇସାକନ୍‌ ଆ ଇସ୍ୱର ଆରି ଜାକୁବନ୍‌ ଆ ଇସ୍ୱର ।’ ");
INSERT INTO juy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ଇସ୍ୱରନ୍‌ ଆରବୁମରଞ୍ଜି ଆ ଇସ୍ୱର ତଡ୍‌, ଆର୍ପାୟ୍‌ ଆମେଙ୍‌ମରଞ୍ଜି ଆ ଇସ୍ୱର । ଆମ୍ୱେଞ୍ଜି ଆଡ଼ଡମ୍‌ଲବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ତିଆଡିଡ୍‌ ଆନିଞ୍ଜି ଆରଲ୍‌ଞାଙ୍‌ତମେଞ୍ଜି ଅବୟ୍‌ ସାସ୍ତ୍ରିନ୍‌ ଅମ୍‌ଡଙେନ୍‌, ଆରି ଜିସୁନ୍‌ ମନଙ୍‌ଡମ୍‌ ଆ ବର୍ନେ ବାତ୍ତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି ଗାମ୍‌ଲେ ଜନାଡାଲେ, ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବନାଁୟ୍‌ଜି ସିଲଡ୍‌ ଅଙ୍ଗା ଆ ବନାଁୟ୍‌ବର୍‌ ସୋଡ଼ା ?” ");
INSERT INTO juy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ଜିସୁନ୍‌ ଜାଲଙେନ୍‌, “ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ବନାଞନ୍‌ କେନ୍‌ଆତେ, ‘ଏ ଇସ୍ରାଏଲ୍‌ମର୍‌ଜି, ଅମ୍‌ଡଙ୍‌ବା, ପ୍ରବୁ ଇସ୍ୱରଲେନ୍‌ ତୁମ୍‌ ଆବୟ୍‌ନେନ୍‌ ପ୍ରବୁ । ");
INSERT INTO juy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ଆରି, ଆମ୍ୱେନ୍‌ ସମ୍ପରା ଉଗର୍‌ବେନ୍‌, ସମ୍ପରା ପରାନ୍ନାବେନ୍‌, ସମ୍ପରା ମନ୍ନବେନ୍‌ ଡ ସମ୍ପରା ବୋର୍ସାବେନ୍‌ ତିୟ୍‌ଲେ ପ୍ରବୁ ଇସ୍ୱରବେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ବା ।’ ");
INSERT INTO juy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ଆରି ଅବୟ୍‌ ବନାଞନ୍‌ କେନ୍‌ଆତେ, ‘ଆମ୍ୱେନ୍‌ ତୟ୍‌ଲିସିଂମର୍‌ବେନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେନ୍‌ଡମ୍‌ ଅନ୍ତମ୍‌ ଡୁଙ୍‌ୟମ୍‌ବା ।’ କେନ୍‌ ବାଗୁ ବନାଞଞ୍ଜି ସିଲଡ୍‌ ଆରି ଅନ୍ନିଙ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ସୋଡ଼ା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ସିଲତ୍ତେ ତି ସାସ୍ତ୍ରିନ୍‌ ଗାମେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌ ତିଆତେ ଆଜାଡ଼ିଡମ୍‌, ଇସ୍ୱରନ୍‌ ଆବୟନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ଆରି ଆନ୍ନିଙ୍‌ ତଡ୍‌, କେନ୍‌ଆତେ ଆମନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ଆରି ଅଡ଼୍‌କୋ ତନୋମ୍ମୋଡନ୍‌ ଡ ଅନମଙନ୍‌ ଆତ୍ରିୟ୍‌ତବନ୍‌ ସିଲଡ୍‌, ସମ୍ପରା ଉଗରନ୍‌, ସମ୍ପରା ବୁଡ୍ଡିନ୍‌, ସମ୍ପରା ବୋର୍ସାନ୍‌ ତିୟ୍‌ଲେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଡନୁଙ୍‌ୟମନ୍‌ ଡ ତୟ୍‌ଲିସିଂମରନ୍‌ଆଡଙ୍‌ ଇନ୍‌ଲେନ୍‌ଡମ୍‌ ଅନ୍ତମ୍‌ ଡନୁଙ୍‌ୟମନ୍‌ ସୋଡ଼ା ।” ");
INSERT INTO juy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ସାସ୍ତ୍ରିନ୍‌, ଆ ବୁଡ୍ଡିନ୍‌ ବାତ୍ତେ ଜାଲଙ୍‌ଲିଁୟ୍‌ ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଜନାଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଗାମେନ୍‌, “ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ସିଲଡ୍‌ ସଙାୟ୍‌ ତଡ୍‌ ।” ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆରି ଆନ୍ନିଙ୍‌ଜା ଜିସୁନ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଆ ବର୍ନେ ବର୍ବରନ୍‌ ଆସନ୍‌ ଅଃନ୍ନୋମଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ଜିସୁନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଞନଙନ୍‌ ଆତ୍ରିୟେନ୍‌ ଆଡିଡ୍‌, ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ବର୍ନେନ୍‌ ବରେଞ୍ଜି, “କ୍ରିସ୍ଟନ୍‌ ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଗାମ୍‌ଲେ ସାସ୍ତ୍ରିଞ୍ଜି ଏଙ୍ଗାଲେ ବର୍ତଞ୍ଜି ? ");
INSERT INTO juy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ଆନିନ୍‌ଡମ୍‌ ଦାଉଦନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ଅବ୍‌ନୁୟୁବ୍‌ଡାଲନ୍‌ ବର୍ରନେ, ‘ପ୍ରବୁନ୍‌ ପ୍ରବୁଞେନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ଞେନ୍‌ ଅଙ୍ଗା ଜାୟ୍‌ ବନେରାନମ୍‌ଜିଆଡଙ୍‌ ତାଲ୍‌ଜଙ୍‌ନମ୍‌ ଆ ଜାୟ୍‌ତା ଅଣ୍ଡ୍ରଙ୍‌ ଡକ୍କୋଆଜି, ତି ଜାୟ୍‌ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ଞେନ୍‌ ତଙ୍କୁମ୍‌ଲେ ଡକୋନା ।’ ");
INSERT INTO juy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ଦାଉଦନ୍‌ କ୍ରିସ୍ଟନ୍‌ଆଡଙ୍‌ ‘ପ୍ରବୁ’ ଗାମେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆସ୍ରେଡାଏନ୍‌ ଆ କ୍ରିସ୍ଟ ଏଙ୍ଗାଲେ ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଅଲ୍‌ଡେଏ ?” ");
INSERT INTO juy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ମନ୍‌ରାଞ୍ଜି ଉଗୁରିୟ୍‌ ଜିସୁନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଲେ ଡକୋଲଞ୍ଜି । ଆରି ଜିସୁନ୍‌ ଞନଙନ୍‌ ଆତ୍ରିୟେନ୍‌ ଆଡିଡ୍‌ ବର୍ରନେ, “ସାସ୍ତ୍ରିଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଆବ୍ବୟ୍‌ଲନ୍‌ ଡକୋନାବା । ଆନିଞ୍ଜି ଡେଙ୍ଗାରାଡମନ୍‌ ଆ ଅଙ୍ଗି ରଲନ୍‌ ଅଡ଼େତ୍ତେ ଅଡ଼େନ୍ନେ ବନୁଲ୍ଲେନ୍‌ ଆସନ୍‌ ଡ ସୟ୍‌ତାରେଙନ୍‌ ଅବ୍‌ଲୋମ୍‌ଲୋମ୍‌ନେନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ତଜି, ");
INSERT INTO juy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ଆନିଞ୍ଜି ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ସୋଡ଼ା ତରଙ୍କୁମନ୍‌ ଡ ବୁଜିରେଙନ୍‌ ମନଙ୍‌ କୁର୍ସିଲୋଙନ୍‌ ତନଙ୍କୁମନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ତଜି, ");
INSERT INTO juy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ଆନିଞ୍ଜି ଜୁଆର୍‌ବଜଞ୍ଜିଆଡଙ୍‌ ବୁର୍ଡଡାଲେ ଆନର୍ଜେଞ୍ଜି ପାଙ୍‌ତଜି ଆରି ଆନିଞ୍ଜି ଅବ୍‌ତୁୟ୍‌ଡାଲନ୍‌ ଗୋଗୋୟ୍‌ ପାର୍ତନାତଞ୍ଜି, ଆନିଞ୍ଜି ଗୋଗୋୟ୍‌ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ଜିସୁନ୍‌ ସରେବାସିଙନ୍‌ ଆ ତନିୟ୍‌ତିୟ୍‌ ପେଡ଼ିନ୍‌ ଆ ତୁୟାୟ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜି ଏଙ୍ଗାଲେ ତନିୟ୍‌ତିୟ୍‌ ପେଡ଼ିଲୋଙନ୍‌ ଡାବ୍ବୋନ୍‌ ପିଡ୍‌ତଜି, ତିଆତେ ଗିୟ୍‌ଗିଜେଞ୍ଜି । ତିଆଡିଡ୍‌ ଗମାଙ୍‌ମରଞ୍ଜି ଅର୍ଗୋୟ୍‌ ଅର୍ଗୋୟ୍‌ ଡାବ୍ବୋନ୍‌ ପିଡେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ଆରି, ଅବୟ୍‌ ଡୋଲେୟ୍‌ ଜୁଆର୍‌ବଜନ୍‌, ବାଗୁ ଆ ଗୁଣ୍ଡାଡାବନ୍‌ ତନିୟ୍‌ତିୟ୍‌ ପେଡ଼ିଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ପିଡେ । ତି ବାଗୁ ଗୁଣ୍ଡାଡାବନ୍‌ ଆ ମୁଲ୍ୟ ବତଙ୍କା ସିଲଡ୍‌ ନିୟ୍‌ ଅସୋୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେଲେ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ତନିୟ୍‌ତିୟ୍‌ ପେଡ଼ିଲୋଙନ୍‌ ଡାବ୍ବୋନ୍‌ ଆପ୍ରିଡେଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଡୋଲେୟ୍‌ ଜୁଆର୍‌ବଜନ୍‌ ଗୋଗୋୟ୍‌ ପିଡେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନ୍ନାମରଞ୍ଜି ଆନର୍ଜେଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଅସୋୟ୍‌ ଅସୋୟ୍‌ ପିଡେଞ୍ଜି, ବନ୍‌ଡ କେନ୍‌ ଜୁଆର୍‌ବଜନ୍‌ ଆ ଡୋଲେଜିଙନ୍‌ ଆ ପରାନ୍ନାନ୍‌ ଆନବ୍‌ମେଙ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ଡିଅଙ୍ଗା ଡକୋଏନ୍‌, ତିଆତେ ଅଡ଼୍‌କୋନ୍‌ ପିଡାଜେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଜିସୁନ୍‌ ସରେବାସିଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଗିଜା, ଡିଅଙ୍ଗା ଆ ସୋଡ଼ାରା ଆରେଙ୍‌ ଆରି ଡିଅଙ୍ଗା ଆ ମନଙ୍‌ ଆସିଂ !” ");
INSERT INTO juy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମ୍ୱେଞ୍ଜି ଇନି କେନ୍‌ ସୋଡ଼ାରା ଅସିଙଞ୍ଜି ଏଗିୟ୍‌ତେ ପଙ୍‌ ? ଅବୟ୍‌ ଆରେଙ୍‌ ଆରି ଅବୟ୍‌ ଅରେଙନ୍‌ ଆ ତୋଣ୍ଡୋ ଅଃଡ୍ଡକୋଏ, ଅଡ଼୍‌କୋନ୍‌ ଲବଲୋଙନ୍‌ ମାୟ୍‌ଆୟ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ଜିସୁନ୍‌ ସରେବାସିଙନ୍‌ ଆ ମୁକ୍କାବା ଆଡ୍ରକୋଏନ୍‌, ଜିତବୁରନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଆତ୍ରଙ୍କୁମେନ୍‌ ଆଡିଡ୍‌ ପିତ୍ରନ୍‌, ଜାକୁବନ୍‌, ଜନନ୍‌ ଆରି ଆନ୍ଦ୍ରିଅନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଲବିଡ୍ଡା ବରେଞ୍ଜି, “କେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆଙ୍ଗା ଗଡେଲ୍‌ତେ, ");
INSERT INTO juy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ଆରି ଅଙ୍ଗା ଆଡିଡ୍‌ କେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଗଡେଲ୍‌ରୟ୍‌ତେ ତିଆତେ ତୁୟାଲେ ପାଙ୍‌ଲାୟ୍‌ ଆଡିଡ୍‌, ଇନିଜି ଇନିଜି ଅରମ୍ମଡଞ୍ଜି ଗିୟ୍‌ତାତେ, ତିଆତେଜି ଇନ୍‌ଲେଞ୍ଜି ବର୍ରେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନ୍ନିଙ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ କଣ୍ଡାୟ୍‌ଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ତିଆସନ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା । ");
INSERT INTO juy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ଜବ୍ର ମନ୍‌ରାଜି ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଜିର୍ରେ, ‘ଞେନ୍‌ କ୍ରିସ୍ଟ’ ଗାମ୍‌ଲେ ଜବ୍ର ମନ୍‌ରାଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ କଣ୍ଡାୟେଜି । ");
INSERT INTO juy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଆଡିଡ୍‌ ଅଲ୍‌ତିଡ୍‌ବରନ୍‌ ଏଅମ୍‌ଡଙ୍‌ତେ ଆରି ଅଲ୍‌ତିଡନ୍‌ ଆ ସର୍ରଙ୍‌ ଏଅମ୍‌ଡଙ୍‌ତେ, ତିଆଡିଡ୍‌ ବତଙ୍‌ଡଙ୍‌ବେନ୍‌, କେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଡେତେମା, ବନ୍‌ଡ ତି ଆ ବନେଡ଼ା ନିୟ୍‌ ଜୁଗନ୍‌ ଅଃନ୍ନଞିଡେ । ");
INSERT INTO juy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଡେସାନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡେସାନ୍‌ ଆରି ରାଜ୍ୟନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ରାଜ୍ୟନ୍‌ ଡୋତନେ, ଆରି ଲାଙ୍‌ଲେନ୍ନେରେଙ୍‌ ତକର୍‌ଲନ୍‌ ଡେତେ ଆରି କାନ୍ତାରାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ବନ୍‌ଡ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ କୋକ୍କୋଡନନ୍‌ ଆଡ୍ରେରୟ୍‌ତେନ୍‌ ଆ ବତ୍ତା ଅନ୍ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା, ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ପନ୍‌ସୁଆତିସିଂରେଙନ୍‌ ସୋରୋପ୍ପାୟ୍‌ତବେଞ୍ଜି, ଆରି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ରନୁକ୍କୁସିଂରେଙନ୍‌ ତିଡ୍‌ତବେଞ୍ଜି ଆରି ଲତ୍ତେଙ୍‌ଲୋଙ୍‌ଞେନ୍‌ ସୋଡ଼ାମରଞ୍ଜି ଡ ରାଜାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଡନେଲୋଙ୍‌ଞେନ୍‌ ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତବ୍‌ନଙ୍‌ତବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ଆରି ଆମ୍ମୁଙ୍‌ରୟ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ତିଆସନ୍‌ ଅଙ୍ଗା ଆଡିଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଞମ୍‌ଲେ ପନ୍‌ସୁଆତିସିଙନ୍‌ ଓରୋଙ୍‌ଡାଲେ ସୋରୋପ୍ପାୟ୍‌ତବେଞ୍ଜି, ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନି ଏଗାମ୍‌ତେ, ତିଆସନ୍‌ ଆମ୍ମୁଙ୍‌ ମା ଏଇଃୟମ୍‌ଡଙେ, ବନ୍‌ଡ ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଇନି ତନିୟନ୍‌ ଡେତେ ତିଆତେ ବର୍ନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଃବ୍ବର୍ନେ, ବନ୍‌ଡ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବର୍ତନେ । ");
INSERT INTO juy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ବୋଞାଙନ୍‌ ବୋଞାଙନ୍‌ଆଡଙ୍‌ ଆରି ଆପେୟନ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ସୋରୋପ୍ପାୟ୍‌ତଜି, ଆରି, ଅଅନଞ୍ଜି ଆପେୟନ୍‌ ଆୟୋଙନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡୋଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ସମ୍ୱବ୍‌ତଜି; ");
INSERT INTO juy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ଆରି, ଲତ୍ତେଙ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତବେଞ୍ଜି; ବନ୍‌ଡ ଆନା ଆତନିକ୍କି ଜାୟ୍‌ ଏର୍‌କିକ୍କିଡ୍‌ନେନ୍‌ ଡକୋତନେ, ଆନିନ୍‌ ଅନୁରନ୍‌ ଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ବନ୍‌ଡ ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ତି ଅନବ୍‌ସେଡନ୍‌ ଆପ୍ରାଙ୍‌ତାଞନ୍‌ ଏଡ଼ୁର୍‌ମଡ୍ଡାନ୍‌ ଆ କୋଙ୍‌ଡାୟ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଆନିନ୍‌ ତନନଙନ୍‌ ଅଃଡ୍ଡେଏ ।” କେନ୍‌ଆତେ ପଡ଼େନେମରନ୍‌ ଗନ୍‌ଲୁଡେତୋ, “ବନ୍‌ଡ ତେତ୍ତେ ଆତନଙନ୍‌ ଏଗିୟ୍‌ତେ, ତିଆଡିଡ୍‌ ଆନାଜି ଜିଉଦା ଡେସାଲୋଙନ୍‌ ଡକୋତଜି ଆନିଞ୍ଜି ବରୁରେଙନ୍‌ ଜିରେତଜି; ");
INSERT INTO juy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ଆନା ତୋଣ୍ଡୋ ବିଲେଙନ୍‌ ଡକୋତେ, ଆନିନ୍‌ ଆସିଙନ୍‌ ସିଲଡ୍‌ ଇନ୍ନିଙ୍‌ ଆ ଜିନିସ ପନାଙନ୍‌ ଆସନ୍‌ ପଡ୍‌ଲନ୍‌ ଜିର୍‌ଡଙାୟ୍‌ ତଡ୍‌ କି ଅମ୍ମସିଙନ୍‌ ଇୟ୍‌ଡଙେ ତଡ୍‌; ");
INSERT INTO juy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ଆରି, ଆନା କୋତ୍ତାଲୋଙନ୍‌ ଡକୋତେ, ଆନିନ୍‌ ଆ ମାଟନ୍‌ ପାଙ୍‌ପାଙନ୍‌ ଆସନ୍‌ ୟର୍ଡଙ୍‌ନେ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ତି ଆ ଡିନ୍ନା ଆନାଜି ଆତିଲ୍‌କୋଡ୍‌ଜି ଆରି ମେମେଅନ୍‌ତଞ୍ଜି, ୟୋଙ୍‌ ଆନିଞ୍ଜି ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତଜି । ");
INSERT INTO juy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ବନ୍‌ଡ କେନ୍‌ଆତେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ରଙା ଇଙନ୍‌ ଡେଡଙ୍‌ ତଡ୍‌, ତିଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ପାର୍ତନାନାବା । ");
INSERT INTO juy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆ ଡିନ୍ନା ଏତ୍ତେଲେ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ ଡ, ଇସ୍ୱରନ୍‌ ଆ ଗନବ୍‌ଡେଲ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଆମ୍ମୁଙ୍‌ ସିଲଡ୍‌ ଲଙେ ଜାୟ୍‌ ତି ଅନ୍ତମ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଡେଏ, ଆରି ଆଙ୍ଗିୟ୍‌ ନିୟ୍‌ ଅଃଡ୍ଡେଏ । ");
INSERT INTO juy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ଆରି, ପ୍ରବୁନ୍‌ ତି ଆ ଡିନ୍ନା ଅଃନ୍ନବ୍‌ସୋୟ୍‌ଲୋ ନଙ୍‌ ଅନ୍ନିଙ୍‌ ଆ ମନ୍‌ରା ଅନୁରନ୍‌ ଅଃଞାଙେଜି ବନ୍‌; ବନ୍‌ଡ ଆନିନ୍‌ ଆନାଜିଆଡଙ୍‌ ସେଡାଏଞ୍ଜି, ତିଆନିଞ୍ଜି ଆସନ୍‌ ତି ଆ ଡିନ୍ନା ଅବ୍‌ସୋଜେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ତି ଆ ଡିନ୍ନା, ‘ଗିୟ୍‌ବା, କ୍ରିସ୍ଟନ୍‌ ତେନ୍ନେ ଡକୋ’ ଅଡ଼େ ‘ଗିୟ୍‌ବା, ତେତ୍ତେ ଡକୋ,’ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଅଙ୍ଗା ଆଡିଡ୍‌ ଏତ୍ତେଲେ ବର୍ତବେଞ୍ଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେନ୍‌ ତିଆତେ ଏଡର୍‌ଡଙ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","କଣ୍ଡାୟ୍‌ କ୍ରିସ୍ଟାନୁଞ୍ଜି, କଣ୍ଡାୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଡୋଲନ୍‌ ଏତ୍ତେଲେ ଅରମ୍ମଡଞ୍ଜି ଆରି ସରାନ୍ନିଡାନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଅବ୍‌ତୁୟ୍‌ତଜି ଡ, ଡେଲନ୍‌ଡେନ୍‌ ଆସନେଡାମରଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜି କଣ୍ଡାୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଆବ୍ବୟ୍‌ଲନ୍‌ ଡକୋନାବା, ଆମ୍ମୁଙ୍‌ ସିଲଡ୍‌ ମା ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଅବ୍‌ଜନାଲବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ଆରି ତି ଆ ଡିନ୍ନା ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେଏନ୍‌ ସିଲଡ୍‌ ଓୟୋଙନ୍‌ ଲୋଙଡ୍‌ତେ, ଆରି ଆଙ୍ଗାୟ୍‌ତାନ୍‌ ଅଃସାଆରେ, ");
INSERT INTO juy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ଆରି ତୁତୁଜଞ୍ଜି ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅସେଡାୟ୍‌ତଜି, ଆରି ରୁଆଙନ୍‌ ଆ ବୋର୍ସାଜି ଅଡ଼୍‌କୋନ୍‌ ୟୁୟୁଆୟ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ତିଆଡିଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ବୋର୍ସାନ୍‌ ଡ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ମେଗଲୋଙନ୍‌ ଆଜିର୍ତାଞନ୍‌ ମନ୍‌ରାଞ୍ଜି ଗିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ତିଆଡିଡ୍‌ ଆନିନ୍‌ ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ପୁର୍ତିନ୍‌ ଆନେଙ୍‌ ସଣ୍ଡିନ୍‌ ସିଲଡ୍‌, ରୁଆଙନ୍‌ ଆନେଙ୍‌ ସଣ୍ଡିନ୍‌ ଜାୟ୍‌ ସମ୍ପରାନ୍‌ ସିଲଡ୍‌ ଇସ୍ୱରନ୍‌ ଆସ୍ରେଡାଏନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଅବ୍‌ରୁକ୍କୁତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ଲୁଆନୁବନ୍‌ ଆନବ୍‌ଜଙ୍‌ବର୍‌ ସିଲଡ୍‌ ଞଙ୍‌ନାବା, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆ କେଣ୍ଡାରନ୍‌ କୋଡ୍ଡେର୍‌ତନେ, ଆରି ଆ ଅଲାନ୍‌ ଆଲେଡେଙ୍‌ ଗିୟ୍‌ତାତେ, ତିଆଡିଡ୍‌ ଡାଗାଡାଇଙନ୍‌ ତୁୟାଲାୟ୍‌ ଗାମ୍‌ଲେ ଜନାତବେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ତିଅନ୍ତମ୍‌ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ଗନଡେଲ୍‌ଜି ଏଗିଜେନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଜିର୍ରୟ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଜନାବା । ");
INSERT INTO juy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗଡେଲେନ୍‌ ଜାୟ୍‌ କେନ୍‌ ନମି ଆ ଜୁଗ ଆ ମନ୍‌ରାଜି ଏଙ୍ଗାଲେ ଜନଙ୍‌ଡେନ୍‌ ଅଃନ୍ନାଡ଼ଏଜି । ");
INSERT INTO juy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ରୁଆଙନ୍‌ ଡ ପୁର୍ତିନ୍‌ ଆଡ଼ତେ ବନ୍‌ଡ ବର୍ନେଞେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଅଃନ୍ନାଡ଼ଏ ।” ");
INSERT INTO juy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ବନ୍‌ଡ ତି ଆ ଡିନ୍ନା କି ତି ଆ ବେଡ଼ା ଆନ୍ନିଙ୍‌ ଜନାଜି ତଡ୍‌, ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଜନାଜି ତଡ୍‌ କି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ଜନା ତଡ୍‌, ଆପେୟ୍‌ ଇସ୍ୱରନ୍‌ ତୁମ୍‌ ଜନା, ");
INSERT INTO juy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ଆମ୍ୱେଞ୍ଜି ଗିୟ୍‌ଡମ୍‌ନାବା, ଆମଡ଼େ ଡକୋନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆ ବେଡ଼ା ଆଙ୍ଗା ଡେତେ, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଜନା ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ତିଆତେ କେନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆସିଙନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ବଡେସାନ୍‌ ଜିର୍ରେ ଇୟ୍‌ତେ ଡକୋନେ, ଆରି ଆନିନ୍‌ ଆ କମ୍ୱାରିମରଞ୍ଜି ଆସିଲୋଙ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ କାବ୍ବାଡ଼ା ତିୟ୍‌ଲେ ଜିରେନ୍‌ ଆରି ଡୁଆରିଆନ୍‌ ନିୟ୍‌ ଜଗେଲେ ଡକୋନେନ୍‌ ଆସନ୍‌ ବର୍ରେ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ଅସମୟ୍‌ ଅସିଂମରନ୍‌ ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ଜିର୍ରେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଡିମଡ୍‌ଜି ଇୟ୍‌ତାୟ୍‌ ଗିୟ୍‌ବେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ତିଆସନ୍‌ ଆମଡ଼େ ଡକୋନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ସାଲ୍ଲୁମ୍‌ ବେଡ଼ାନ୍‌ ପଙ୍‌, ଅଡ଼େ ତୁଙାର୍‌ ତଗଲ୍‌ ବେଡ଼ାନ୍‌, ଅଡ଼େ କମ୍‌ସିମୋଲ୍‌ ବେଡ଼ାନ୍‌, ଅଡ଼େ ଡୋତାନ୍‌, ଅଙ୍ଗାବେଡ଼ା ଆନିନ୍‌ ଜିର୍ତାୟ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଏଃଜ୍ଜନାଏ । ");
INSERT INTO juy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଇନିଜି ବର୍ତବେନ୍‌, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଗିୟ୍‌ଡମ୍‌ନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ଆରି ବାଗୁ ଡିନ୍ନା ଆ ତିକ୍କି ଅନେଲାୟ୍‌ପୁରନ୍‌ ଡ କମିରନ୍‌ ଏର୍‌ମନାୟନ୍‌ ଆ ରୁଟିଜୋମ୍‌ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ତି ଆ ବନେଡ଼ା ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅଜନା ଞମ୍‌ଲୋଙ୍‌ ଞମ୍‌ଲେ ରବ୍ବୁଏଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ତଙରନ୍‌ ସାୟ୍‌ଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ପୁର୍ପୁରିଙନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃଞମ୍‌ବୋ, ଅସମୟ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଗୋଡ଼େନ୍‌ ଡୁଙ୍‌ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ଜିସୁନ୍‌ ବେତନିଆଲୋଙନ୍‌ ମୋଡ୍ଡୋ ସିମନନ୍‌ ଆସିଂ ଆଗ୍ରାଗାଲନେନ୍‌ ଆଡିଡ୍‌ ଅବୟ୍‌ ଆଇବଜନ୍‌ ବକୋମ୍ପା ଲଙିଡ୍‌ ମିଞଲନ୍‌ ପାଙ୍‌ଲେ, ତି ଆ କୋମ୍ପା ପାଲ୍ଲେ, ଜିସୁନ୍‌ ଆବବ୍‌ଲୋଙ୍‌ ମିଞଲନ୍‌ ଲାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ବନ୍‌ଡ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ବରାବ୍‌ଡାଲେ ତର୍ଡମ୍‌ କଡାଡ଼ିଲନ୍‌ ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆଇବଜନ୍‌ ଇନିବା ଲଙିଡ୍‌ ମିଞଲନ୍‌ ଅବ୍‌ମୋସ୍ସାତେ ?” ");
INSERT INTO juy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ଆନିଞ୍ଜି ଆଇବଜନ୍‌ଆଡଙ୍‌ ଗବ୍‌ରୟ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆ ମିଞଲ୍‌ ତମ୍‌ଲୋଙ୍‌ ତମ୍‌ଲେ ତି ଆ ତଙ୍କା ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ ବନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ବନ୍‌ଡ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଆନିନ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଏଗାମ୍‌ଡଙ୍‌, ଇନିବା ଆନିନ୍‌ଆଡଙ୍‌ ବାଉଲ୍ଲି ଏଏମ୍ମେତେ ? ଆନିନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଡୋଲେୟ୍‌ମରଞ୍ଜି ତ ଡିତାନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋତଞ୍ଜି, ଆରି ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଆଡିଡ୍‌ ଲଡୟ୍‌ତବେନ୍‌ ତିଆଡିଡ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ଲେ ଏତିୟ୍‌ତଜି, ବନ୍‌ଡ ଞେନ୍‌ ଆଏଡ଼ର୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଅଃଡ୍ଡକୋନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ଆନିନ୍‌ ଇନି ଲୁମ୍‌ଲେ ରପ୍ତିତେ ତିଆତେ ଆନିନ୍‌ ଲୁମେନ୍‌, ଆନିନ୍‌ ମସାନ୍ନିନ୍‌ ଆସନ୍‌ ଆମ୍ମୁଙ୍‌ମା ମିଞଲନ୍‌ ବାତ୍ତେ ଡଅଙ୍‌ଞେନ୍‌ ଅବିସେକଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ସମ୍ପରା ପୁର୍ତିନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଜନଙ୍‌ଡେନ୍‌ ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙନ୍‌ ଡେଏନ୍‌ ଆଡିଡ୍‌, କେନ୍‌ ଆଇବଜନ୍‌ଆଡଙ୍‌ ମନନ୍ନେନ୍‌ ଆସନ୍‌ କେନ୍‌ ଆ କାବ୍ବାଡ଼ାନ୍‌ ନିୟ୍‌ ବର୍ନେନ୍‌ ଡେଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ସିଲତ୍ତେ ବାରଜଣଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଇସ୍କାରିତ ଜିଉଦା ଗାମ୍‌ଲେ ଅବୟ୍‌ ଞଙ୍‌ନେମରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌, ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଆସିଲୋଙ୍‌ ସନୋରୋପ୍ପାୟନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଆମଙଞ୍ଜି ଇୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ତିଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ସର୍ଡାଡାଏଞ୍ଜି ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଡାବ୍ବୋନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ବାସାଏଞ୍ଜି । ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିଉଦାନ୍‌ ଆ ରନୟଙନ୍‌ ଗିୟ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆସିଲୋଙଞ୍ଜି ସନୋରୋପ୍ପାୟନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ସାୟ୍‌ଲେ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","କମିରନ୍‌ ଏର୍‌ମନାୟନ୍‌ ରୁଟିଜୋମ୍‌ ଡିନ୍ନାଇଙନ୍‌, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆଅନ୍‌ ମେଣ୍ଡାନ୍‌ ଅନମଙନ୍‌ ତନିୟନ୍‌ ଡେତେ ତିଆଡିଡ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଆମନ୍‌ ଆସନ୍‌ ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆ ଗାଗାନେ ଅଙ୍ଗାଲୋଙ୍‌ ଇୟ୍‌ ଏବ୍‌ଜାଡାନାୟ୍‌ ଗାମ୍‌ଲେ ଆମନ୍‌ ଲଡୟ୍‌ତମ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ବାଗୁନେଆଡଙ୍‌ ଏନ୍ନେଲେ ବର୍ରେ ଆପ୍ପାୟେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଗଡ଼ାନ୍‌ ଇୟ୍‌ବା, ଆରି ଡାଆସୋଡନ୍‌ ପାଙ୍‌ଲେ ଆଜିର୍ତେନ୍‌ ଆଡିଡ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଇୟ୍‌ତେ ଏରବାଙେ, ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙ୍‌ବା, ");
INSERT INTO juy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ଆନିନ୍‌ ଅଙ୍ଗା ଆସିଂ ଇୟ୍‌ତେ ଗନେ, ତି ଆସିଂ ଆ ସୋଡ଼ାମର୍‌ଆଡଙ୍‌ ଇୟ୍‌ ବର୍ବା, ‘ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ ବର୍ରନେ, ଞେନ୍‌, ଞଙ୍‌ନେମର୍‌ଞେଞ୍ଜି ସରିନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆ ଗାଗାନେ ପାଡ଼େତନାୟ୍‌ ତି ଆ କନୁଆମର୍‌ସିଂ ଅଡ଼େଙ୍ଗା ?’ ");
INSERT INTO juy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ଆନିନ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆସିଂ ଅବୟ୍‌ ଆତୁବ୍‍ତୁବନ୍‍ଆତେ ଅବ୍‌ତୁୟ୍‌ତବେନ୍‌ । ଆମ୍ୱେନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅବ୍‌ଜାଡାଲେ ଇୟ୍‌ ଡକ୍କୋବା ।” ");
INSERT INTO juy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିର୍ରେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଏଙ୍ଗାଲେ ବର୍ରେ ଆପ୍ପାୟେଞ୍ଜି, ଏତ୍ତେଲେମା ଗିୟ୍‌ଲେ ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆ ଗାଗାନେ ଆସନ୍‌ ଇୟ୍‌ଲେ ଅବ୍‌ଜାଡାଏଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ଆସ୍ରାଲ୍ଲୁମେନ୍‌, ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ଜିର୍ରାଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ଆନିଞ୍ଜି ତଙ୍କୁମ୍‌ଲେ ଆଗ୍ରାଗାଲଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଅବୟ୍‌ନେ, ଅଙ୍ଗା ମନ୍‌ରା ଞେନ୍‌ ସରିନ୍‌ ଗାଗାତନେ, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଡୁକ୍କଡାଲନ୍‌ ଅବୟ୍‌ନେ ଅବୟ୍‌ନେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନିନ୍‌ ଞେନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ବାରଜଣଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ, ଆନା ଞେନ୍‌ ସରିନ୍‌ ଗିନାଲୋଙ୍‌ଞେନ୍‌ ଆ ରୁଟିନ୍‌ ଜୋବ୍‌ଡାତେ ଆନିନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ବର୍ନେ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଏଙ୍ଗାଲେ ଆଇଡିଡନ୍‌ ଡକୋ, ଏତ୍ତେଲେ ଆନିନ୍‌ ରବୁତେ, ବନ୍‌ଡ ଆନା ଆସିଲୋଙ୍‌ ସିଲଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ସନୋରୋପ୍ପାୟନ୍‌ ଡେତେ, ୟୋଙ୍‌, ତି ଆ ମନ୍‌ରା ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ, ଆର୍ପାୟ୍‌ ଆନିନ୍‌ କରୋଡ୍‌କ୍କୋଡନ୍‌ ଅଃଡ୍ଡେଲୋ ନଙ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ମନଙ୍‌ ଡେତେ ବନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ଆନିଞ୍ଜି ଆଗ୍ରାଗାଲଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ରୁଟିନ୍‌ ଞମ୍‌ଲେ ଆସିର୍ବାଦଏନ୍‌ ଆରି ତିଆତେ ରେବ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ଲେ ବର୍ରନେ, “ନବା କେନ୍‌ଆତେ ଡଅଙ୍‌ଞେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ଆରି, ଆନିନ୍‌ ଗିଲ୍ଲନ୍‌ ଞମ୍‌ଲେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସନେନ୍‌ସେନ୍‌ ତିୟ୍‌ଲେ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ତିୟେଞ୍ଜି ଆରି ଅଡ଼୍‌କୋଞ୍ଜି ତେତ୍ତେ ସିଲଡ୍‌ ଗାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ଆତେ ସନିବ୍‌ଡେୟ୍‌ବର୍‌ ମିଞାମ୍‌ଞେନ୍‌, କେନ୍‌ଆତେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆସନ୍‌ ଜନବ୍‌ତଡନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ଡିନ୍ନା ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ଗାତାୟ୍‌, ତି ଆ ଡିନ୍ନା ଅଣ୍ଡ୍ରଙ୍‌ ଅଡ଼ୋଆଞନ୍‌ ଜାୟ୍‌ କେନ୍‌ଆତେ ଆଙ୍ଗିୟ୍‌ ଆରି ଅଃଗାଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ଆରି, ଆନିଞ୍ଜି କନନନ୍‌ କନ୍‌ଲେ, ସେନ୍‌ଲେ ସେନ୍‌ଲେ ଜିତବୁରନ୍‌ ଆ ତୋଣ୍ଡୋ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ଏଜିର୍‌ତିଁୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅନିଡଲନ୍‌ ଡକୋ,” “ଞେନ୍‌ ତୁର୍‌ମେଡ୍‌ମରନ୍‌ଆଡଙ୍‌ ରବ୍ବୁତାୟ୍‌, ଆରି ମେଣ୍ଡାଞ୍ଜି ତରଙ୍‌ଆନ୍ନା ଡେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“ବନ୍‌ଡ ଞେନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋଲନାୟ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆମ୍ୱେଞ୍ଜି ସିଲଡ୍‌ ଞେନ୍‌ ଆମ୍ମୁଙ୍‌ ଗାଲିଲିନ୍‌ ଜିର୍ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅଡ଼୍‌କୋଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙାୟ୍‌ଲେ ଜିର୍ରମ୍‌ଜି ଜନଙ୍‌ଡେନ୍‌, ଞେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ଅଃଜ୍ଜିରମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତମ୍‌, ଲଙେ ଆ ତଗଲ୍‌ କମ୍‌ସିମନ୍‌ ବାଗୁତର ଆରୋଲ୍‌ତ୍ତେନ୍‌ ଆମ୍ମୁଙ୍‌, ଆମନ୍‌ ୟାଗି ତର, ଞେନ୍‌ଆଡଙ୍‌ ମୁର୍ସେତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଆକ୍ରାନ୍‌ ବର୍ରନେ, “ଆମନ୍‌ ସରିନ୍‌ ଞେନ୍‌ ରବୁଲିଁୟ୍‌ ଜନଙ୍‌ଡେନ୍‌, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମୁର୍ସେଅମ୍‌ ।” ଆରି ଅଡ଼୍‌କୋଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେମା ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଗେସମନି ଗାମ୍‌ଲେ ଅବୟ୍‌ କୋତ୍ତାନ୍‌ ଜିରେଞ୍ଜି, ଆରି ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଇୟ୍‌ତେ ପାର୍ତନାନାୟ୍‌ ଆମ୍ୱେଞ୍ଜି ତେନ୍ନେ ତଙ୍କୁମ୍‌ଲେ ଡକୋନାବା ।” ");
INSERT INTO juy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ଜିସୁନ୍‌ ପିତ୍ରନ୍‌, ଜାକୁବନ୍‌, ଜନନ୍‌ କେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ସରିନ୍‌ ଓରୋଙ୍‌ଡାଲେ ଆନିନ୍‌ ଆକ୍ରାନ୍‌ ଇୟମ୍‌ଲେ ଇୟ୍‌ଲେ ଡକୋନେ । ");
INSERT INTO juy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, “ପରାନ୍ନାଞେନ୍‌ ଆର୍ରବୁତିଞନ୍‌ ଅନ୍ତମ୍‌ ଡେତିଁୟ୍‌, ଆମ୍ୱେଞ୍ଜି ତେନ୍ନେ ଆମଡ଼େ ଡକୋନାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ଆରି, ଆନିନ୍‌ ଡାସଙାୟ୍‌ ଡାଅଡିଃ ଜିର୍ରେ ଲବଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ, ଗଡେଲେନ୍‌ ଡେନ୍‌, ତି ଆ ବେଡ଼ା ଆମଙନ୍‌ ସିଲଡ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ସଙାଜେ, ତିଆସନ୍‌ ଇୟ୍‌ଲେ ପାର୍ତନାନେ । ");
INSERT INTO juy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ଆରି, ଜିସୁନ୍‌ ଏନ୍ନେଲେ ପାର୍ତନାଲନ୍‌, “ଆବ୍ବା, ଆପେୟ୍‌, ଅଡ଼୍‌କୋନ୍‌ ଅସିଲୋଙ୍‌ନମ୍‌, ଆମନ୍‌ ଲଡୟ୍‌ଲମ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଗରାଗା ଗିଲ୍ଲନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ସବ୍‌ଙାଜା, ଜନଙ୍‌ଡେନ୍‌ ଇସ୍ସୁମ୍‌ଞେନ୍‌ ତଡ୍‌, ଇସ୍ସୁମ୍‌ଞେନ୍‌ ଅନ୍ତମ୍‌ ଡେଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ଆନିନ୍‌ ୟର୍ରନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆଡିମଡାୟ୍‌ଜି ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଞ୍ଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ସିମନ୍‌ ଆମନ୍‌ ଇନି ଲୁଡ୍‌ତେ ପଙ୍‌ ? ଆମନ୍‌ ଇନି ବଗଣ୍ଟା ଜାକିଁୟ୍‌ ଆମଡ଼େନ୍‌ ଡକୋଲନ୍‌ ଅଃର୍ରପ୍ତିଲୋ ? ");
INSERT INTO juy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ମନାଲ୍‌ମାଲ୍‌ରେଙନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଗଲୋଡଙ୍‌ବେନ୍‌ ତଡ୍‌ ତିଆସନ୍‌ ମବ୍‌ଡ଼େଲନ୍‌ ଡକୋଡାଲନ୍‌ ପାର୍ତନାନାବା, ପୁରାଡ଼ାନ୍‌ ଲଡୟ୍‌ ବନ୍‌ଡ ଡଅଙନ୍‌ ବପ୍ପୁ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ଆନିନ୍‌ ଆରି ଜିର୍ରେ ଆମ୍ମୁଙ୍‌ ଅନ୍ତମ୍‌ ବର୍ରନ୍‌ ଇୟ୍‌ଲେ ପାର୍ତନାନେ । ");
INSERT INTO juy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ଆନିନ୍‌ ଆରି ୟର୍ରନ୍‌, ଆନିଞ୍ଜି ଆଡିମଡାୟ୍‌ଜି ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆମଡଞ୍ଜି ସାବ୍‌କୁଡ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି, ଆରି ଆନିଞ୍ଜି ଇନି ଗାମ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଜି, ତିଆତେ ଅଣ୍ଡ୍ରଙ୍‌ ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ଆନିନ୍‌ ୟାଗି ତଙର୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଆମ୍ୱେଞ୍ଜି ନମିନ୍ତାନ୍‌ ଲୁଡ୍‌ଲେ ଏଲୋଲୋତନ୍‌ ପଙ୍‌ ? ଡେଲୋ ଡିୟ୍‌ତେ ସରି, ତି ବେଡ଼ା ଅଡ଼ୋଲାୟ୍‌, ଗିୟ୍‌ବା, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଇର୍ସେମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ଡୋନାବା ଇନ୍‌ଲେଞ୍ଜି ଏଜିର୍ବା, ଗିୟ୍‌ବା, ଅଙ୍ଗା ମନ୍‌ରା ଞେନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତିଁୟ୍‌, ଆନିନ୍‌ ତୁୟାଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ଆରି ତେରଙ୍‌, ଆନିନ୍‌ ଆକ୍ରଡାଡ଼ିଲନ୍‌ ଆଡିଡ୍‌, ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଜିଉଦା ଗାମ୍‌ଲେ ଅବୟ୍‌ନେ ଆରି ଆନିନ୍‌ ସରିନ୍‌ ମନ୍‌ରାଞ୍ଜି କଡ଼ିବନ୍‌ ଡ ତେଙ୍ଗାନ୍‌ ଞମ୍‌ଲେ ଜିର୍ରାଜି, କେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି, ସାସ୍ତ୍ରିଞ୍ଜି, ଆରି ପାପୁର୍‌ମରଞ୍ଜି ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ଆରବ୍‌ଞମ୍‌ଞମେନ୍‌ ଆ ମନ୍‌ରା ଆନିଞ୍ଜିଆଡଙ୍‌ ତାରିଆୟ୍‌ଡାଲେ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆନାଆଡଙ୍‌ ଜୋର୍ଜୋର୍‌ତାୟ୍‌, ଆନିନ୍‌ ଜିସୁନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ଆବ୍ବୟ୍‌ଡାଲନ୍‌ ପାଙ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ସିଲତ୍ତେ ଇସ୍କାରିତ ଜିଉଦାନ୍‌ ସିଲତ୍ତେମା ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌,” ଗାମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଜୋର୍ଜୋରେ । ");
INSERT INTO juy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ଜିଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ବନ୍‌ଡ ତେତ୍ତେ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ କଡ଼ିବନ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ କମ୍ୱାରିମର୍‌ ଅଡ୍‌ଲେ ଆଲୁଡନ୍‌ ଗଡ୍‌ଲେ ସେଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ରାଉମରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଏଡ୍ରୁଙ୍‌ତନାଞନ୍‌ ଅନ୍ତମ୍‌ କଡ଼ିବନ୍‌ ଡ ତେଙ୍ଗାନ୍‌ ପାଙ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଏଇୟ୍‌ଲାୟ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ଞେନ୍‌ ଡିତାନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ସରେବାସିଙନ୍‌ ଡକୋଡାଲନ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଃଞମ୍‌ଲିଁୟ୍‌, ବନ୍‌ଡ ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆ ବର୍ନେଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡେଡମ୍‌ତେ, ତିଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ତିଆଡିଡ୍‌ ଅଡ଼୍‌କୋ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିରାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ବନ୍‌ଡ ଅବୟ୍‌ ବେଣ୍ଡିଆମରନ୍‌ ଆକୋଡୋଙନ୍‌ ଅବୟ୍‌ ସନ୍ନାଡମ୍‌ ଆ ମାଟ ଗୁସାୟ୍‌ଡାଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେନ୍‌, ଆନିଞ୍ଜି ତି ବେଣ୍ଡିଆମରନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସ୍ରାଜେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ଆନିନ୍‌ ତି ସନ୍ନା ମାଟନ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ଆକୋଡୋଙନ୍‌ ଇରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ତିକ୍କି ଆନିଞ୍ଜି ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆମଙ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଓରୋଙେଞ୍ଜି, ଆରି ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି, ପାପୁର୍‌ମରଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପିତ୍ରନ୍‌ ଡାସଙାୟ୍‌ ଡକୋଡାଲନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଅବ୍‌ଲସ୍ସନ୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ ପନ୍‌ସୁଆତିସିଂ ଆ ଡୁଆରା ଜିରେନ୍‌ କି ତଙିୟ୍‌ସିପ୍ପାୟଞ୍ଜି ସରିନ୍‌ ଅମ୍ମନ୍‌ ତଙ୍କୁମ୍‌ଲେ ତଗୋଲୋଙନ୍‌ ଇୟ୍‌ଲେ ଞଡ୍‌ଞଡ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜି କଡାଡ଼ିଡାଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ ସାକିନ୍‌ ସାଜେଞ୍ଜି, ବନ୍‌ଡ ଅଃଞାଙ୍‌ଲଜି, ");
INSERT INTO juy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ କଣ୍ଡାୟ୍‌ ସାକିନ୍‌ ତିୟେଞ୍ଜି, ଜନଙ୍‌ଡେନ୍‌ ଆ ସାକିଞ୍ଜି ଅଃମ୍ମାୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ କଣ୍ଡାୟ୍‌ ସାକିନ୍‌ ତିୟ୍‌ଲେ ବର୍ରଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ଆନିନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆବର୍ରନେନ୍‌ ଆଡିଡ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌, ‘ଞେନ୍‌, କେନ୍‌ ମନ୍‌ରାନ୍‌ ଆଗ୍ରୁଏନ୍‌ ଆ ସରେବାସିଂ ପୁଡ୍‌ଲେ ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ଆରି ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଅଃଗୁଏନ୍‌ ଆ ସରେବାସିଂ ଗୁତାୟ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ବନ୍‌ଡ କେନ୍‌ ଆ ସାକିଞ୍ଜି ନିୟ୍‌ ଅଃମ୍ମାୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ଆରି ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ମଡ୍ଡିନ୍‌ ତନଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ବିରୁଦଲୋଙ୍‌ନମ୍‌ ଅଙ୍ଗା ସାକି କେନ୍‌ଆନିଞ୍ଜି ତିୟ୍‌ତଜି, ତିଆସନ୍‌ ଇନିବା ଆମନ୍‌ ଇନ୍ନିଙ୍‌ ଅଃଜ୍ଜାଲଙ୍‌ନେ ?” ");
INSERT INTO juy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ବନ୍‌ଡ ଆନିନ୍‌ କଡ଼ିଙ୍‌ଲେ ସେଡେନ୍‌, ଇନ୍ନିଙ୍‌ ଅଃଜ୍ଜାଲଙ୍‌ଲନେ । ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌, ସନେଙ୍କେନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ କ୍ରିସ୍ଟନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଆନିନ୍‌, ଆରି ଆମ୍ୱେଞ୍ଜି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ରନପ୍ତିନ୍‌ ଆର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଆତଙ୍କୁମନ୍‌ ଆରି ରୁଆଙନ୍‌ ଆ ମେଗଲୋଙ୍‌ ଆଜିର୍ତାଞନ୍‌ ଏଗିୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ସିଲତ୍ତେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ ଅଙ୍ଗିନ୍‌ ପେଲେ ବର୍ରନେ, “ଆରି ଗୋଗୋୟ୍‌ ସାକିନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ଆମ୍ୱେଞ୍ଜି ତ ଇସ୍ୱରନ୍‌ ଆ ନିଣ୍ଡୟ୍‌ବର୍‌ ଏଅମ୍‌ଡଙେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଇନି ଏଗାମ୍‌ତେ ?” ସିଲତ୍ତେ ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ଆରି, ଲାଙ୍‌ଲେନ୍ନେ ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ବିଜଲେଞ୍ଜି ଆରି ଆ ମୁକ୍କାଲୋଙନ୍‌ ସିନ୍‌ରିନ୍‌ ୟୁମ୍‌ଲେ ବିଡ୍ଡାବିଡ୍ଡାଲେ ତିଡେଞ୍ଜି କି, “ଆମନ୍‌ ଅଡ୍ଡେନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ! ଅବ୍‌ତୁୟ୍‌ଲେନ୍‌ ।” ଆରି, ତଙିୟ୍‌ସିପ୍ପାୟଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ତିଡ୍‌ଲେ ତିଡ୍‌ଲେ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ତି ଆ ବନେଡ଼ା ପିତ୍ରନ୍‌ ଜାୟ୍‌ତାନ୍‌ ପନ୍‌ସୁଆତିସିଙନ୍‌ ଆ ଡୁଆରାଲୋଙ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଆଡିଡ୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ କମ୍ୱାରିବୟ୍‌ ଅବୟ୍‌ନେ ଜିର୍ରେ ପିତ୍ରନ୍‌ ତଗୋଲୋଙନ୍‌ ଆଞ୍ରଃଞଲ୍ଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେ, ");
INSERT INTO juy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ଆରି ତି କମ୍ବାରିବଜନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙ୍‌ଡାଲେ ବର୍ରନେ, “ଆମନ୍‌ ନିୟ୍‌ ନାଜରିତ ଜିସୁନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ମୁର୍ସେଡାଲେ ବର୍ରନେ, “ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜନା ତଡ୍‌, ଆରି ଆମନ୍‌ ଇନି ଗାମ୍‌ତେ, ଞେନ୍‌ ଅଃଗନ୍‌ଲୁଡିଁୟ୍‌ ।” ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଡୁଆରାନ୍‌ ଆ ଗରନ୍ନେଲୋଙ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଆରି, ତି କମ୍ୱାରିବଜନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଆମଙନ୍‌ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଆରି ବତର ବରେଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଆରି ମୁର୍ସେଏନ୍‌ । ଆରି, ବସନ୍ନେଃ ସିଲଡ୍‌ ଆମଙନ୍‌ ଆତନଙନ୍‌ ଆ ମନ୍‌ରାଜି ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ତ ଗାଲିଲିମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଆନିନ୍‌ଡମ୍‌ ସୟ୍‌ପଡମ୍‌ଲନ୍‌, ପର୍ମାଡ଼ାଲନ୍‌ ବର୍ରନେ, “ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ମନ୍‌ରା ଆ ବର୍ନେ ଏବର୍ତନେ, ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜନା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ସିଲତ୍ତେମା କମ୍‌ସିମନ୍‌ ବାଗୁ ବେଡ଼ା ଓଲେନ୍‌ । ସିଲତ୍ତେ, “କମ୍‌ସିମନ୍‌ ବାଗୁ ବେଡ଼ା ଆରୋଲ୍‌ତ୍ତେନ୍‌ ଆମ୍ମୁଙ୍‌ ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ୟାଗି ତର ମୁର୍ସେତିଁୟ୍‌,” କେନ୍‌ ଅଙ୍ଗା ବର୍ନେ ଜିସୁନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ତିଆତେ ଆ ମନ୍ନଲୋଙନ୍‌ ଅଡ଼ୋଲାୟ୍‌, ଆରି ଆନିନ୍‌ ତି ଆ ବର୍ନେ ଇୟମ୍‌ଡାଲେ ୟେୟେଡାଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ପନ୍‌ସୁଆତିଲୋଙନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ମନ୍‌ରାଜି, ପାପୁର୍‌ମରଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ସରିନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି କଡାଡ଼ିଡାଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜିଲେ ପାଙ୍‌ଲେ ପିଲାତନ୍‌ ଆସିଲୋଙ୍‌ ଇୟ୍‌ଲେ ସୋରୋପ୍ପାୟେଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ପିଲାତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ପଙ୍‌ ଜିଉଦିଞ୍ଜି ଆ ରାଜା ?” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆମନ୍‌ ବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ଆରି, ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଜିସୁନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଜବ୍ର ଅବ୍‌ଡୋସାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ସିଲତ୍ତେ ପିଲାତନ୍‌ ଆରି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଇନ୍ନିଙ୍‌ ଅଃଜ୍ଜାଲଙ୍‌ନେ ପଙ୍‌ ? ଗିଜା, କେନ୍‌ଆନିଞ୍ଜି ବିରୁଦଲୋଙ୍‌ନମ୍‌ ଡିଅଙ୍ଗା ଅବ୍‌ଡୋସାତମ୍‌ଜି !” ");
INSERT INTO juy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ବନ୍‌ଡ ଜିସୁନ୍‌ ଇନ୍ନିଙ୍‌ ଅଃଜ୍ଜାଲଙ୍‌ଲନେ, ତିଆସନ୍‌ ପିଲାତନ୍‌ ସାନ୍ନି ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ବନ୍‌ଡ ଜିଉଦିଞ୍ଜି ଆନୋକ୍କା ଏନ୍ନେଲେ ଡକୋଏନ୍‌, ଅନେଲାୟ୍‌ପୁରିଙନ୍‌ ମନ୍‌ରାଞ୍ଜି ଅଙ୍ଗା ବଣ୍ଡିମର୍‌ଆଡଙ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଆସନ୍‌ ବର୍ତଞ୍ଜି, ପିଲାତନ୍‌ ତି ଆ ବଣ୍ଡିମର୍‌ଆଡଙ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ଅମ୍‌ଡୁଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ଅଙ୍ଗା ମନ୍‌ରାଜି କାଇସରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଗୋଡ଼େନ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ଗୋଡ଼େ ଇଙନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ରବ୍ବୁଏଞ୍ଜି, ତି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡନକ୍କୋନ୍‌ ଡେଲୋ, ଆନିଞ୍ଜି ସରିନ୍‌ ବାରବ୍ବା ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ନିୟ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ପିଲାତନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନୋକ୍କାନ୍‌ ଅନ୍ତମ୍‌ ବାରବ୍ବାନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଆସନ୍‌ ବର୍ନେନ୍‌ ଉଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ସିଲତ୍ତେ ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆମ୍ୱେଞ୍ଜି ଇନି ଏଗାମ୍‌ତେ ? ଞେନ୍‌ ଇନି ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଜିଉଦିଞ୍ଜି ଆ ରାଜା ଅମ୍‌ଡୁଙାୟ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅସାଙ୍‌ୟମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସୋରୋପ୍ପାୟେଞ୍ଜି ଗାମ୍‌ଲେ ପିଲାତନ୍‌ ଜନାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ ପାଲ୍‌ତେଙ୍‌ ବାରବ୍ବାନ୍‌ଆଡଙ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ଅମ୍‌ଡୁଙା ଗାମ୍‌ଲେ ପିଲାତନ୍‌ ଆମଙ୍‌ ବର୍ନେନ୍‌ ଆସନ୍‌, ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ସୁସ୍କାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ପିଲାତନ୍‌ ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରାଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଜିଉଦିଞ୍ଜି ଆ ରାଜା ଗାମ୍‌ଲେ ଏବର୍ତନେ, ଆନିନ୍‌ଆଡଙ୍‌ ଞେନ୍‌ ଇନି ଏଙ୍ଗାଆୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ଆନିଞ୍ଜି ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ସିଲତ୍ତେ ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନିବା, ଆନିନ୍‌ ଇନି ଆ ଡୋସା ଲୁମେନ୍‌ ଡ ?” ବନ୍‌ଡ ଆନିଞ୍ଜି ଆକ୍ରାନ୍‌ ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ତିଆସନ୍‌ ପିଲାତନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ସର୍ଡାନ୍‌ ଆସନ୍‌ ବାରବ୍ବାନ୍‌ଆଡଙ୍‌ ଅମ୍‌ଡୁଙେନ୍‌, ଆରି ଜିସୁନ୍‌ଆଡଙ୍‌ ସାମକାନ୍‌ ବାତ୍ତେ ଅବ୍‌ତିତ୍ତିଡେନ୍‌ କି ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅନମ୍‌ଡାଜନ୍‌ ଆସନ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ସିଲତ୍ତେ ସିପ୍ପାୟଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ରାଜାସିଙନ୍‌ ଆ ଡୁଆରାଲୋଙ୍‌ ଅମ୍ମନ୍‌ ଓରୋଙ୍‌ଡାଲେ, ଅଡ଼୍‌କୋ ସିପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ରୁକ୍କୁଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ତନିକ୍କଲାୟନ୍‌ ଆସନ୍‌ ଲୁଲୁ ଅଙ୍ଗିନ୍‌ ଅବ୍‌ରଏଞ୍ଜି ଆରି ଅବ୍ବାଙନ୍‌ ବାତ୍ତେ ରନୁବ୍ବବନ୍‌ ତୁବ୍‌ଲେ ଆବବ୍‌ଲୋଙନ୍‌ ଅବ୍‌ରୁବ୍ବବେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ଆରି, “ଏ ଜିଉଦିଞ୍ଜି ଆ ରାଜା, ଲୋମ୍‌ତମ୍‌,” ଗାମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ଆରି, ଆନିଞ୍ଜି ଅବୟ୍‌ ଡାଙ୍ଗୋନ୍‌ ପାଙ୍‌ଲେ ଆବବ୍‌ଲୋଙନ୍‌ ତିଡେଞ୍ଜି, ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ବିଜଲେଞ୍ଜି, ଆରି ତିକ୍କଲାୟ୍‌ଡାଲେ ତୁଡ଼ୁମ୍‌ଲେ ଲୋମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଆତ୍ରିକ୍କଲାୟେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌, ତି ଲୁଲୁ ଅଙ୍ଗିନ୍‌ ତବ୍‌ଲେ ଆ ଅଙ୍ଗିଡମନ୍‌ ଅବ୍‌ରଏଞ୍ଜି । ଆରି, ଆନିନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅନମ୍‌ଡାଜନ୍‌ ଆସନ୍‌ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ତିଆଡିଡ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ସନ୍ନା ସାଇରେଙନ୍‌ ସିଲଡ୍‌ ଗଡ଼ାନ୍‌ ଜିର୍ରାୟ୍‌, ଆଞୁମନ୍‌ ସିମନ୍‌, ଆନିନ୍‌ ଅବୟ୍‌ କୁରିଣିଅମର୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ସିପ୍ପାୟଞ୍ଜି ଜିସୁନ୍‌ ଆଅକ୍କାଡଙ୍‌ ବଡଗାଁୟ୍‌ ଅବ୍ବୋୟେଞ୍ଜି । ତି ଆ ସିମନ୍‌ଆଡଙ୍‌ ଆଲେକ୍‌ଜାଣ୍ଡାରନ୍‌ ଡ ରୁପନ୍‌ ବାପାତଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ଆରି, ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗଲ୍‌ଗତା, କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌, “ଆଇଡାଡ଼ାବୁର୍‌” ଗାମ୍‌ଲେ ଅବୟ୍‌ ବରୁନ୍‌ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ଆରି, ଆନିଞ୍ଜି ରେଗମନ୍‌ ଆମାୟ୍‌ମାୟ୍‌ ଆ ଦ୍ରାକ୍ୟାସାଲ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତିୟେଞ୍ଜି, ବନ୍‌ଡ ଆନିନ୍‌ ଅଃଗାଲୋ । ");
INSERT INTO juy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ୟୋଡେଞ୍ଜି, ଆରି ଆନା ଇନି ଞାଙ୍‌ତେ, ତିଆସନ୍‌ ଅବ୍‌କଡ଼ିଲେ ଜିସୁନ୍‌ ଆ ସିନ୍‌ରି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ବନ୍ତାଡାଲନ୍‌ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ଡୋତାନ୍‌ ନ ଗଣ୍ଟା ଇଙନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଆରି, ଜିସୁନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ଡୋସାନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ପଟାଲୋଙନ୍‌, “ଜିଉଦିଞ୍ଜି ଆ ରାଜା” ଗାମ୍‌ଲେ ଇଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ଆରି, ଜିସୁନ୍‌ ସରିନ୍‌ ବାଗୁ ରାଉମରଞ୍ଜି ନିୟ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି, ଅବୟ୍‌ନେ ଆର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଆରି ଅବୟ୍‌ନେ ଅର୍କାବଡ଼ିଗଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ତିଆସନ୍‌ ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଡେଡମେନ୍‌, “ଆନିନ୍‌ ଏର୍‌ଡରମ୍ମମରଞ୍ଜି ସରିନ୍‌ ଡନିଡିନ୍‌ ଡେଲୋ ।” ");
INSERT INTO juy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ତି ଆ ତଙର୍‌ଗଡ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆ ମନ୍‌ରାଜି ମୋମୋବବ୍‌ଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “ବାଃ, ଏ ସରେବାସିଙନ୍‌ ପୁଡ୍‌ଲେ ତିଆତେ ଏର୍ତାଲୋଙ୍‌ ଆଗ୍ରୁତେନ୍‌ ଆ ମନ୍‌ରା; ");
INSERT INTO juy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ନମିଞେନ୍‌ ଆଅକ୍କାଡଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଡୋବ୍‌ଡମ୍‌ନା ।” ");
INSERT INTO juy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ତିଅନ୍ତମ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ନିୟ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ସରିନ୍‌ ତର୍ଡମ୍‌ କଡାଡ଼ିନେରୟ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତିକ୍କଲାୟ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ ଆନ୍ନାମରଞ୍ଜିଆଡଙ୍‌ ଡୋବେନ୍‌, ଆନିନ୍‌ଡମ୍‌ ଡୋବ୍‌ଲନ୍‌ ଅଃର୍ରପ୍ତିଏ ! ");
INSERT INTO juy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ଆମନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆ ରାଜା କ୍ରିସ୍ଟନ୍‌ ଡେନ୍‌ ନମିଞେନ୍‌ ମା ଆଅକ୍କାଡଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଜିରାୟ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଗିୟ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଅମଙ୍‌ନମ୍‌ ଏଡର୍ତନାୟ୍‌ ।” ଆରି, ଅଙ୍ଗା ମନ୍‌ରାଜି ଜିସୁନ୍‌ ସରିନ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଆୟୋଡ୍‌ୟୋଡ୍‌ ଡକୋଲଞ୍ଜି, ଆନିଞ୍ଜି ନିୟ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ତମ୍‌ବାନ୍‌ ବାର ଗଣ୍ଟା ସିଲଡ୍‌ ୟାଗି ଗଣ୍ଟା ଜାୟ୍‌ ସମ୍ପରା ଡେସାନ୍‌ ଆଲୋଙଡନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ଆରି ଓୟୋଙନ୍‌ ୟାଗି ଗଣ୍ଟା ଆଡିଡ୍‌ ଜିସୁନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ଓଡ୍ଡେଡାଲେ ବର୍ରନେ, “ଏଲି, ଏଲି, ଲାମା ସବକ୍‌ତାନି ?” କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌, “ଏ ଇସ୍ୱରଞେନ୍‌, ଏ ଇସ୍ୱରଞେନ୍‌, ଆମନ୍‌ ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଲିଁୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ, ତେତ୍ତେ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “ଅମ୍‌ଡଙ୍‌ବା, ଆନିନ୍‌ ଏଲିଅନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ଆରି, ଅବୟ୍‌ନେ ଇରେନ୍‌ କି ଅଜିଡ୍‌ କପାଲୋଙନ୍‌ ସବୁର୍‌ଡାନ୍‌ ଜୋବ୍‌ଡାଏନ୍‌, ଆରି ତିଆତେ ଅବୟ୍‌ ଡାଙ୍ଗୋଲୋଙନ୍‌ ରପଡେନ୍‌ କି ଗାଗାନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ ତିୟେନ୍‌ କି ବର୍ରନେ, “କଡ଼ିଙ୍‌ବା, କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙନ୍‌ ସିଲଡ୍‌ ଅନପ୍ପଡନ୍‌ ଆସନ୍‌ ଏଲିଅନ୍‌ ଇୟ୍‌ତାୟ୍‌ ପଙ୍‌ ଅଡ଼େ ଇଜ୍ଜା ଏଗିୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ଜିସୁନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବାବ୍ବାବ୍‌ଡାଲେ ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ଆରି, ସରେବାସିଙନ୍‌ ମଡ଼ିର୍‌ ବକରାନ୍‌ ଆରାନ୍ନାତେନ୍‌ ଆ ଡରଙ୍‌ନେକାବ୍‌ ତୋଣ୍ଡୋନ୍‌ ସିଲଡ୍‌ ଜାୟ୍‌ତାନ୍‌ ପତେଡାଲେ ବାଗୁ ଡେୟ୍‌ଡେୟ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ଆଅକ୍କାଡଙନ୍‌ ଆ ମୁକ୍କାଗଡ୍‌ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲନେନ୍‌ ଆ ସୋଡ଼ା ସିପ୍ପାୟ୍‌, ଜିସୁନ୍‌ ଏଙ୍ଗାଲେ ରବୁଏନ୍‌, ତିଆତେ ଗିୟ୍‌ଲେ ଆନିନ୍‌ ବର୍ରନେ, “ଆଜାଡ଼ିଡମ୍‌ କେନ୍‌ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ଲାଙ୍‌ଲେଡ୍‌ ଆଇମରଞ୍ଜି ନିୟ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଡାସଙାୟ୍‌ ଡକୋଡାଲନ୍‌ ଗିୟ୍‌ଗିଜେଞ୍ଜି, ଆନିଞ୍ଜିଲୋଙ୍‌ ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌, ସନ୍ନା ଜାକୁବନ୍‌ ଡ ଜୋସିନ୍‌ ଆୟୋଙ୍‌ ମରିଅମନ୍‌, ଆରି ସୋଲମିନ୍‌ ତେତ୍ତେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ଜିସୁନ୍‌ ଗାଲିଲିନ୍‌ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସାଜଏଞ୍ଜି, ଆନିଞ୍ଜି ସରିନ୍‌ ଜିରୁସାଲମନ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଆଇମରଞ୍ଜି ନିୟ୍‌ ତେତ୍ତେ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ଆରି ଅରୁବ୍‌ଲେ ଆପ୍ରାଙେନ୍‌, ତି ଆ ଡିନ୍ନା ଅବ୍‌ଜାଡା ଡିନ୍ନାନ୍‌ ଡକୋଏନ୍‌, କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌, ଲୋଲୋନେ ଡିନ୍ନାନ୍‌ ଆମ୍ମୁଙ୍‌ ଡିନ୍ନା ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ଆରି ଆରାମାତିୟାବାୟ୍‌ ଅବୟ୍‌ନେ ଜିଉଦି ମରାୟ୍‌ନେଲୋଙନ୍‌ ଆ ମନାନ୍ନେମର୍‌ ଡକୋଏନ୍‌, ଆଞୁମନ୍‌ ଜୋସେପ, ଆନିନ୍‌ ନିୟ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଜଗେଲେ ଡକୋଲନେ, ଆନିନ୍‌ ଅବ୍ବୋମଙ୍‌ଡାଲନ୍‌ ପିଲାତନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଜିସୁନ୍‌ ଆ ମରା ଇୟ୍‌ଲେ ବେଡେ । ");
INSERT INTO juy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ବନ୍‌ଡ ଜିସୁନ୍‌ ରବୁଏନ୍‌ ଗାମ୍‌ଲେ ପିଲାତନ୍‌ ଆରମ୍‌ଡଙେନ୍‌ ଆନିନ୍‌ ସାନ୍ନି ଡେଏନ୍‌, ଆରି ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ଆଡଙ୍‌ ଅବ୍‌ନୋଡ୍ଡେଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆନିନ୍‌ ରବୁଏନ୍‌ କି ଅୟମ୍‌ଡମ୍‌ ଡେଏନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ, ଜିସୁନ୍‌ ଆ ମରା ପାଙା ଗାମ୍‌ଲେ ଜୋସେପନ୍‌ଆଡଙ୍‌ ବରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ଜୋସେପନ୍‌ ଅବୟ୍‌ ଲମନ୍‌କାବନ୍‌ ଞିଲୋଙ୍‌ ଞିଲେ ଜିସୁନ୍‌ ଆ ମରା ଆଅକ୍କାଡଙନ୍‌ ସିଲଡ୍‌ ଅପ୍ପଡ୍‌ଲେ ପାଙ୍‌ଲାୟ୍‌ କି ଲମନ୍‌କାବନ୍‌ ବାତ୍ତେ ଜିସୁନ୍‌ ଆ ମରା ବଲେଡେଞ୍ଜି ଆରି ବରୁନ୍‌ ଆରେଙ୍‌ଲୋଙ୍‌ ଆଗାୟ୍‌ଗାୟନ୍‌ ଅବୟ୍‌ ମସାନ୍ନିଲୋଙନ୍‌ ଜିସୁନ୍‌ ଆ ମରା ଡକ୍କୋଡାଲେ ମସାନ୍ନିନ୍‌ ଆ ଗରନ୍ନେଲୋଙ୍‌ ଅବୟ୍‌ ଅରେଙନ୍‌ ଡଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ଜିସୁନ୍‌ ଆ ମରା ଅଙ୍ଗାଲୋଙ୍‌ ଡନକ୍କୋନ୍‌ ଡେଏନ୍‌, ତିଆତେ ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌ ଡ ଜୋସିନ୍‌ ଆୟୋଙ୍‌ ମରିଅମନ୍‌ ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ଲୋଲୋନେ ଡିନ୍ନାନ୍‌ ଆପ୍ରଡେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌, ଜାକୁବନ୍‌ ଆୟୋଙ୍‌ ମରିଅମନ୍‌ ଡ ସୋଲମିନ୍‌ ଜିସୁନ୍‌ ଆ ମରାଲୋଙ୍‌ ଜଜ୍ଜଡନ୍‌ ଆସନ୍‌ ଲଙିଡ୍‌ ମିଞଲନ୍‌ ଞିଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ଆରି ପାଲ୍ଲିନ୍‌ ଆ ପର୍ତମ୍ମୁ ଡିନ୍ନା ରୟ୍‌ବାର ଡିନ୍ନା ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ଓୟୋଙନ୍‌ ଆଡ୍ରୁଙ୍‌ଲନାଞନ୍‌ ଆଡିଡ୍‌ ଆନିଞ୍ଜି ମସାନ୍ନିନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ଆରି ତଙରନ୍‌ ଆନିଞ୍ଜି ତର୍ଡମ୍‌ ଏନ୍ନେଲେ କଡାଡ଼ିଗଡ୍‌ଲଞ୍ଜି, “ଇନ୍‌ଲେନ୍‌ ଆସନ୍‌ ଆନା ମସାନ୍ନିନ୍‌ ଆ ଗରନ୍ନେଲୋଙ୍‌ ଆରେଙ୍‌ ଡେଡ୍‌ଲେ ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ନେ ? ତିଆତେ ତ ସୋଡ଼ାଡମ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ତି ଆ ବନେଡ଼ା ଆନିଞ୍ଜି ଆଗ୍ରିଜେଞ୍ଜି ଅରେଙନ୍‌ ଆଡେଡ୍‌ଡେଡ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ଆନିଞ୍ଜି ଅମ୍ମ ମସାନ୍ନିନ୍‌ ଗନ୍‌ଲେ ଇୟ୍‌ଲେ ଗିଜେଞ୍ଜି, ତେତ୍ତେ ଜେଏଡମ୍‌ ଆ ଅଙ୍ଗି ଆରନେନ୍‌ ଅବୟ୍‌ ବେଣ୍ଡିଆମରନ୍‌ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଆତଙ୍କୁମ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି, ତିଆତେ ଗିୟ୍‌ଲେ ଆନିଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ସିଲତ୍ତେ ବେଣ୍ଡିଆମରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ସାନ୍ନି ଡେଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ଞେନ୍‌ ଜନା, ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଆରମ୍‌ଡାଜେଞ୍ଜି ନାଜରିତ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏସାୟ୍‌ତେ, ଆନିନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋଲନେ, ଆନିନ୍‌ ତେନ୍ନେ ମନ୍‌ରା ତଡ୍‌, ଗିୟ୍‌ବା ଆନିନ୍‌ଆଡଙ୍‌ ତେନ୍ନେ ବନ୍‌ ଡନକ୍କୋନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ନମି ଆମ୍ୱେଞ୍ଜି ଜିର୍ରେ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଡ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ ବର୍ବା, ଆମ୍ୱେଞ୍ଜି ସିଲଡ୍‌ ଆମ୍ମୁଙ୍‌ ଆନିନ୍‌ ଗାଲିଲିନ୍‌ ଜିରେନ୍‌, ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଙ୍ଗାଲେ ବର୍ରବେନ୍‌, ଏତ୍ତେଲେମା ତେତ୍ତେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ତେ ଏରବାଙେ ।” ");
INSERT INTO juy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ତିଆସନ୍‌ ଆନିଞ୍ଜି ମସାନ୍ନିନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଇରେଞ୍ଜି, ଆରି ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ଇନ୍ନିଙ୍‌ ଅଃବ୍ବର୍ରଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ବନ୍ତଙନ୍‌ ବାତ୍ତେ ତକରେଞ୍ଜି, ଆରି ସାନ୍ନିଡାଲେ କିତିଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ଜିସୁନ୍‌ ପାଲ୍ଲିନ୍‌ ଆ ପର୍ତମ୍ମୁ ଡିନ୍ନା ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ରୟ୍‌ବାର ଡିନ୍ନା ୟର୍ମେଙ୍‌ଲେ ଡୋଲନେ, ଆନିନ୍‌ ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌ ଆମଙ୍‌ ପର୍ତମ୍ମୁ ଅବ୍‌ଗିୟ୍‌ତାଲନେ, କେନ୍‌ ଆ ମରିଅମ ଆମଙ୍‌ ସିଲଡ୍‌ ସାତଟା ବୁତଞ୍ଜି ଗନଙନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ମରିଅମନ୍‌ ଜିର୍ରେ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆମଙ୍‌ କବରନ୍‌ ପାଙେନ୍‌, ଆନିଞ୍ଜି ତିଆଡିଡ୍‌ ୟନେନ୍‌ ଡ ଅନିଃୟମନ୍‌ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ଜିସୁନ୍‌ ରନବୁନ୍‌ ସିଲଡ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋଲନେ, ଆନିନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଅବ୍‌ଗିୟ୍‌ତାଲନ୍‌ ଗାମ୍‌ଲେ ମରିଅମନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ଆ ବର୍ନେନ୍‌ ଅଃଡ୍ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଡ୍ରେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ବାଗୁନେ ଅବୟ୍‌ ସନ୍ନା ସାଇନ୍‌ ଆରିୟେଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ତି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ଅରାନ୍ନାଗୋ ଅବ୍‌ଗିୟ୍‌ତାଲନେ । ");
INSERT INTO juy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ଆରି ଆନିଞ୍ଜି ୟର୍ରନ୍‌ ତି ଆ ବର୍ନେ ଆନ୍ନା ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, ବନ୍‌ଡ ଆ ବର୍ନେଞ୍ଜି ନିୟ୍‌ ଆନିଞ୍ଜି ଅଃଡ୍ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଏଗାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ଆଗ୍ରାଗାଲଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆମଙଞ୍ଜି ଅବ୍‌ଗିୟ୍‌ତାଲନେ, ଆରି ଆନିଞ୍ଜି ଅଃଡ୍ଡର୍ରନେଞ୍ଜି ଆସନ୍‌, ଆରି ଆ ଉଗରଞ୍ଜି ଆ ରଡୋନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ କଞେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରାଜି ଆନିନ୍‌ଆଡଙ୍‌ ଆୟର୍ମେଙନ୍‌ ଗିଜେଞ୍ଜି, ତି ଆ ମନ୍‌ରାଜି ଆ ବର୍ନେ ଆନିଞ୍ଜି ଅଃଡ୍ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ସମ୍ପରା ପୁର୍ତିନ୍‌ ଇୟ୍‌ଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଇୟ୍‌ନପ୍ପୁଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ଆନା ଡର୍ତନେ ଆରି ତବ୍ବୁବ୍‌ଡାତନେ ଆନିନ୍‌ ଅନୁରନ୍‌ ଞାଙ୍‌ତେ, ବନ୍‌ଡ ଆନା ଅଃଡ୍ଡର୍ନେ, ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପବ୍‌ରଡ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ଆରି, ଡର୍ନେମରଞ୍ଜି କେନ୍‌ ଆ ସାନ୍ନି କାବ୍ବାଡ଼ାଜି ରପ୍ତି ଲନୁମନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବୋର୍ସାନ୍‌ ତନିୟନ୍‌ ଡେତେ, ଆନିଞ୍ଜି ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ବୁତନ୍‌ ଗଙ୍‌ତଜି, ରଙ୍‌ ଲଙ୍‌ଲଙନ୍‌ ବାତ୍ତେ କଡାଡ଼ିତଞ୍ଜି, ଆନିଞ୍ଜି ଆସନ୍‌ କେନ୍‌ଆତେ ଅବୟ୍‌ ଅରମ୍ମଡନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","“ଆସିଲୋଙଞ୍ଜି ଜାଆଡନ୍‌ ଞମ୍‌ତଜି ଆରି ଇନ୍ନିଙ୍‌ ଆ ବିସ ନିୟ୍‌ ଗାଏଞ୍ଜି ଡେନ୍‌ ଆନିଞ୍ଜି ଅଃର୍ରବୁଏଜି, ଆନିଞ୍ଜି ଅସୁମରଞ୍ଜି ଆବବ୍‌ଲୋଙ୍‌ ଆସିଞ୍ଜି ଡକ୍କୋଏଞ୍ଜି ଡେନ୍‌ ଅସୁମରଞ୍ଜି ମନଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ଏନ୍ନେଲେ ପ୍ରବୁ ଜିସୁନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ କଡାଡ଼ିଲଞ୍ଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ତୋଣ୍ଡୋ ରୁଆଙନ୍‌ ଅନୋରୋଙନ୍‌ ଡେଲୋ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଇୟ୍‌ଲେ ତଙ୍କୁମେ । ");
INSERT INTO juy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ଜିରେଞ୍ଜି କି ମନଙ୍‌ବରନ୍‌ ସମ୍ପରାନ୍‌ ଇୟ୍‌ଲେ ଅପ୍ପୁଙେଜି, ଆରି ଆନିଞ୍ଜି ଆରପ୍ପୁଙେଞ୍ଜି ଆ ମନଙ୍‌ବର୍‌ଜି ଆଜାଡ଼ିନ୍‌ ମା ଗାମ୍‌ଲେ ଅନବ୍‌ଜନାନ୍‌ ଆସନ୍‌, ପ୍ରବୁନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋଡାଲନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆଞ୍ରାଙେଞ୍ଜି ଆ ସାନ୍ନି କାବ୍ବାଡ଼ାଜି ଇୟ୍‌ଲେ ଅବ୍‌ତୁଜେଜି ।");
INSERT INTO juy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ଏ ବୋଞାଙ୍‌ ତିଅପିଲ୍‌, ଅମଙ୍‌ବାଲେନ୍‌ ଅଙ୍ଗା ବୋର୍ସା କାବ୍ବାଡ଼ାଜି ଇସ୍ୱରନ୍‌ ଲୁମେନ୍‌, ତିଆତେଜି ଜବ୍ର ମନ୍‌ରାଞ୍ଜି ଇଡିଡନ୍‌ ଆସନ୍‌ ଲଡଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ତିଆସନ୍‌, ଅଙ୍ଗା ମନ୍‌ରାଜି ଆମ୍ମୁଙ୍‌ମା ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଗିଜେଞ୍ଜି କି ଇଡେଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଅପ୍ପୁଙ୍‌ବରେଞ୍ଜି ଆରି ତିଆତେଜି ଜୁବାୟ୍‌ଲେ ଡକ୍କୋଡାଲେ ଅସିଲୋଙ୍‌ଲେନ୍‌ ତିୟ୍‌ଲଲେଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ତିଅନ୍ତମ୍‌, ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ମୁଙ୍‌ ମା ସିଲଡ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ମନଙ୍‌ଡମ୍‌ ପଡ଼େଡାଲନ୍‌ ତେତ୍ତେ ଆଇଡିଡନ୍‌ ଆ ବର୍ନେଜି ଅମଙ୍‌ନମ୍‌ ଇଡିଡନ୍‌ ଆସନ୍‌ ମାଡ୍ଡ ଲଡୟ୍‌ଲିଁୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","କେନ୍‌ଆତେଜି ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ ଇଡ୍‌ଲେ ଆପ୍ପାୟ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଆମନ୍‌ ଅଙ୍ଗାତେ ଞନଙନ୍‌ ଞାଙେନ୍‌ ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆଜାଡ଼ିନ୍‌ମା ଗାମ୍‌ଲେ ରପ୍ତି ଜନାତେ । ");
INSERT INTO juy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ଜିଉଦା ଡେସାନ୍‌ ଏରୋଦ ରାଜାନ୍‌ ଆସ୍ରାସନଏନ୍‌ ଆଡିଡ୍‌, ଅବିଅ ରାଓଡ଼ାନ୍‌ ଆ ଡଡ଼ଲୋଙ୍‌ ଅବୟ୍‌ ରାଓଡ଼ାନ୍‌ ଆଞୁମ୍‌ ଜିକରିୟ ଗାମ୍‌ଲେ ଡକୋଏନ୍‌; ଆ ଡୁକ୍ରିନ୍‌ ଆରୋଣଞ୍ଜି ଆ କେଜ୍ଜାବୟ୍‌, ଆଞୁମନ୍‌ ଏଲିସାବେତ । ");
INSERT INTO juy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ଆନିଞ୍ଜି ବାଗୁଞ୍ଜି ପ୍ରବୁନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଆରି ଅନଗଡନ୍‌ ଅନ୍ତମ୍‌ ଅଡ଼୍‌କୋନ୍‌ ମାନ୍ନେଡାଲେ ଏର୍‌ଡୋସାଡାଗୋ ଞଣ୍ଡ୍ରମ୍‌ଡାଲନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ ଡରମ୍ମମର୍‌ଜି ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ବନ୍‌ଡ ଆନିଞ୍ଜି ଅଃକ୍କୋଡନ୍‌ଲଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏଲିସାବେତନ୍‌ ଆଞ୍ଜେଲନେ, ଆରି ବାଗୁଞ୍ଜି ବୁଡାଏଞ୍ଜି ବୁଡିଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ଆନିନ୍‌, ଆ ଡଡ଼ଞ୍ଜି ଆ ପାଲ୍ଲି ଅନ୍ତମ୍‌ ସରେବାସିଙନ୍‌ ଜିର୍ରେ ଇସ୍ୱରନ୍‌ ଆ ମୁକ୍କାଲୋଙ୍‌ ପୁର୍ପୁର୍‌ଲୁମନ୍‌ ଇୟ୍‌ଲେ ଲୁମେନ୍‌ ଆଡିଡ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ଆଓକ୍କା ପୁର୍ପୁର୍‌ଲୁମନ୍‌ ଅନ୍ତମ୍‌ ଆରବ୍‌କଡ଼ିଏଞ୍ଜି ଜିକରିୟନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ କଡ଼ିନ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌, ତିଆସନ୍‌ ଆନିନ୍‌ ପ୍ରବୁନ୍‌ ଆ ସରେବାସିଂ ଗନ୍‌ଲେ ତନୋମ୍ମୋଡନ୍‌ ଇୟ୍‌ଲେ ତିଏ । ");
INSERT INTO juy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ଆରି ତନୋମ୍ମୋଡନ୍‌ ଆତ୍ରିୟେନ୍‌ ଆଡିଡ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଡୁଆରାନ୍‌ ପାର୍ତନାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ତିଆଡିଡ୍‌ ତରୋମ୍ମୋଡ୍‌ ତନମ୍ପିଲନ୍‌ ଆର୍ଜଡ଼ୋମ୍‌ ଗଡ୍‌ ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ତନଙ୍‌ଡାଲେ ଆମଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଅବ୍‌ତୁୟ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ଜିକରିୟନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଓଙ୍‌ଲେତିଏନ୍‌ ଆରି ବତଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ବନ୍‌ଡ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜିକରିୟ, ବତଙ୍‌ଡଙମ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପାର୍ତନାନମ୍‌ ଅନମ୍‌ଡଙନ୍‌ ଡେଲୋ, ଆରି ଡୁକ୍ରିନମ୍‌ ଏଲିସାବେତନ୍‌ ଆମନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ଓବ୍ବାସିଜନ୍‌ କୋଡ୍‌ତେ, ଆମନ୍‌ ଆଞୁମନ୍‌ ଜନନ୍‌ ଅବ୍‌ଞୁମା । ");
INSERT INTO juy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ଆନିନ୍‌ ଆସନ୍‌ ଗାମ୍‌ଲେ ଆମନ୍‌ ମନଅଁଞନ୍‌ ଡ ସର୍ଡାନ୍‌ ଡେତମ୍‌, ଆରି ଆନିନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେଲନ୍‌ଡେନ୍‌ ଜବ୍ର ମନ୍‌ରାଜି ସର୍ଡାତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ପ୍ରବୁନ୍‌ ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ ସୋଡ଼ାମର୍‌ ଡେତେ; ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ଜା ଦ୍ରାକ୍ୟାଡାନ୍‌, ଅଲିନ୍‌ ଅଃଗାଏ, ଆରି ଆୟୋଙନ୍‌ ଆ କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ନିୟ୍‌ ଆବରିୟ୍‌ ଡକୋତେ । ");
INSERT INTO juy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ଆରି ଆନିନ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଜବ୍ର ମନ୍‌ରାଜିଆଡଙ୍‌ ପ୍ରବୁ ଆ ଇସ୍ୱରଞ୍ଜି ଆମଙ୍‌ବା ଆବ୍‌ଡିଡ୍‌ଲେ ଓରୋଙ୍‌ତାଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ଆପେୟଞ୍ଜି ଆ ଉଗର୍‌ ପସିଜଞ୍ଜି ଆମଙ୍‌ବା ଆରି ଆଲ୍ଲେମରଞ୍ଜିଆଡଙ୍‌ ଡରମ୍ମମରଞ୍ଜି ଆ ଜନନାଲୋଙ୍‌ ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଆସନ୍‌ ଅନାବ୍‌ଡିଡନ୍‌ ଆସନ୍‌ ଆରି ପ୍ରବୁନ୍‌ ଆସନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ଜାଡାବାନ୍‌ ଆନିନ୍‌ ଏଲିଅନ୍‌ ଆ ପୁରାଡ଼ା ଡ ବୋର୍ସାନ୍‌ ବାତ୍ତେ ଇସ୍ୱରନ୍‌ ଆ ମୁକ୍କାଗଡ୍‌ ତଙିୟ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ଜିକରିୟନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କେନ୍‌ଆତେ ଡେତେ ଗାମ୍‌ଲେ ଏଙ୍ଗାଲେ ଞେନ୍‌ ଜାନାଆୟ୍‌ ? ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ବୁଡାଲିଁୟ୍‌, ଆରି ଡୁକ୍ରିଞେନ୍‌ ନିୟ୍‌ ବୁଡିଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ଗାବ୍ରିଏଲ୍‌, ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ମୁକ୍କାଗଡ୍‌ ତନଙ୍‌ତାୟ୍‌, ଆରି ଆମନ୍‌ଆଡଙ୍‌ ଅନପ୍ପୁଙନ୍‌ ଆସନ୍‌ ଆରି କେନ୍‌ ମନଙ୍‌ବରନ୍‌ ଅନବ୍‌ଜନାବାନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ଗିଜା, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗଡେଲେନ୍‌ ଆ ଡିନ୍ନା ଜାୟ୍‌ ଆମନ୍‌ ଅବ୍‌ଜାଡ୍ଡାଲନ୍‌ ଡକୋତନେ ଆରି କଡାଡ଼ିଲନ୍‌ ଅଃର୍ରପ୍ତିଏ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ବର୍ନେଞେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଅଙ୍ଗାତେ ଆ ଡିନ୍ନାଇଂଡମନ୍‌ ଗଡେଲ୍‌ତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଆମନ୍‌ ଅଃଡ୍ଡର୍ରନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ତି ଆ ବନେଡ଼ା ମନ୍‌ରାଞ୍ଜି ଜିକରିୟନ୍‌ଆଡଙ୍‌ ଜଗେଲେ ଡକୋଲଞ୍ଜି, ଆରି ସରେବାସିଂଲୋଙନ୍‌ ଆନିନ୍‌ ଆଡ୍ରିଙେନ୍‌ ଆନିଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ତିକ୍କି ଆନିନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରାୟ୍‌, ବନ୍‌ଡ ଆନିଞ୍ଜିଆଡଙ୍‌ ବର୍ରେ ଅଃର୍ରପ୍ତିଲଜି; ତିଆସନ୍‌ ଆନିନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ତନାଲ୍‌ମଡନ୍‌ ଗିଜେନ୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଜନାଏଞ୍ଜି, ଜିକରିୟନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତାରିଆୟ୍‌ଏଞ୍ଜି ଆରି ଅବ୍‌ଜାଡ୍ଡାଲନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଆ ସେବା କାବ୍ବାଡ଼ାନ୍‌ ଆ ପାଲ୍ଲି ଆସ୍ରୁଜ୍ଜେଏନ୍‌ ଆନିନ୍‌ ଆସିଂଡମନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","କେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆ ଡୁକ୍ରିନ୍‌ ଏଲିସାବେତନ୍‌ ପାଙ୍ଗୁରନ୍‌ଲନେ, ଆରି ଆନିନ୍‌ ମନ୍‌ଲୟ୍‌ ଆଙ୍ଗାୟ୍‌ ଜାୟ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃବ୍ବର୍ରୋ । ");
INSERT INTO juy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ତିକ୍କି ଆନିନ୍‌ ବର୍ରନେ, “ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଗନ୍‌ଡ୍ରୟ୍‌ଞେନ୍‌ ସନବ୍‌ଙାଜନ୍‌ ଆସନ୍‌ ପ୍ରବୁନ୍‌, ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମ୍‌ଡାଲେ ଏନ୍ନେଲେ ଲୁମେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ତିକ୍କି, ଏଲିସାବେତନ୍‌ ପାଙ୍ଗୁରନ୍‌ଡାଲନ୍‌ ତୁଡ୍ରୁ ଆଙ୍ଗାୟ୍‌ ଆଡ୍ରେଏନ୍‌ ଆଡିଡ୍‌ ଗାବ୍ରିଏଲ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଗାଲିଲିଲୋଙନ୍‌ ନାଜରିତ ଗଡ଼ାନ୍‌ ଅବୟ୍‌ ଡାଙ୍ଗଡ଼ିସିଜନ୍‌ ଆମଙ୍‌ ଅନାପ୍ପାୟନ୍‌ ଡେଲୋ; ");
INSERT INTO juy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ଦାଉଦନ୍‌ ଆ କେଜ୍ଜାଲୋଙ୍‌ ଜୋସେପ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଓବ୍ବାମରନ୍‌ ବୟନ୍‌ ତି ଆ ଡାଙ୍ଗଡ଼ିସିୟ୍‌ ବିବାନେନ୍‌ ଆସନ୍‌ ଆଜଙ୍‌ଜଙ୍‌ ଡକୋଏଞ୍ଜି । ତି ଆ ଡାଙ୍ଗଡ଼ିସିୟ୍‌ ଆଞୁମ୍‌ ମରିଅମ । ");
INSERT INTO juy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଅସିଙନ୍‌ ଗନ୍‌ଲନ୍‌ ମରିଅମନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେ, “ଏ ସନାୟୁମ୍‌ବୟ୍‌, ଅମଙ୍‌ନମ୍‌ ସନୟୁନ୍‌ ଜିରାୟ୍‌ତୋ, ପ୍ରବୁନ୍‌ ଆମନ୍‌ ସରିନ୍‌ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ବନ୍‌ଡ ତି ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ମରିଅମନ୍‌ ଆକ୍ରାନ୍‌ ସାନ୍ନି ଡେଏନ୍‌, ଆରି କେନ୍‌ଆତେ ଏଙ୍ଗାଗୋ ଆ ବର୍ନେ ଗାମ୍‌ଲେ ଆ ମନ୍ନଲୋଙନ୍‌ ଇୟମ୍‌ଲଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ସିଲତ୍ତେ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ମରିଅମ, ବତଙ୍‌ଡଙମ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ ସନାୟୁମ୍‌ବୟ୍‌ ଡେଲମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ଆରି ଗିଜା, ଆମନ୍‌ ପାଙ୍ଗୁରନ୍‌ଡାଲନ୍‌ ଅବୟ୍‌ ଓବ୍ବାସିଜନ୍‌ କୋଡ୍‌ତେ ଆରି ଆଞୁମନ୍‌ ଜିସୁ ଅବ୍‌ଞୁମା । ");
INSERT INTO juy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ଆନିନ୍‌ ସୋଡ଼ାମର୍‌ ଡେତେ ଆରି ଆନିନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଗାମ୍‌ଲେ ଅନୋଡ୍ଡେନ୍‌ ଡେତେ; ପ୍ରବୁ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆ ପୁର୍ବା ଜୋଜୋନ୍‌ ଦାଉଦନ୍‌ ଅନ୍ତମ୍‌ ଅବ୍‌ରାଜାତେ, ");
INSERT INTO juy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ଆନିନ୍‌ ଜାକୁବନ୍‌ ଆ ପୁଞ୍ଜାଲୋଙ୍‌ ଅଡ଼୍‌କୋ ଡିନ୍ନାନ୍‌ ସାସନତେ, ଆରି ଆ ରାଜ୍ୟନ୍‌ ଆଙ୍ଗାଜନଙ୍‌ ଅଃନ୍ନଞିଡେ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ବନ୍‌ଡ ମରିଅମନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କେନ୍‌ଆତେ ଏଙ୍ଗାଡାଲେ ଅଲ୍‌ଡେଏ ? ଞେନ୍‌ ତ ଓବ୍ବାମରନ୍‌ଆଡଙ୍‌ ଜନା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡଅଙ୍‌ଲୋଙ୍‌ନମ୍‌ ଇୟ୍‌ତାୟ୍‌ ପନ୍ନେ ଆରି ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆ ବୋର୍ସା ଆମନ୍‌ଆଡଙ୍‌ ଲୁବ୍‌ତମ୍‌, ତିଆସନ୍‌ ଆନା କରୋଡ୍‌କ୍କୋଡନ୍‌ ଡେତେ, ଆନିନ୍‌ ମଡ଼ିର୍‌ ଆରି ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଗାମ୍‌ଲେ ଅନୋଡ୍ଡେନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ଆରି ଗିଜା, କୁଲମ୍‌ବୟ୍‌ନମ୍‌ ଏଲିସାବେତନ୍‌ ନିୟ୍‌ ଆ ବନୁଡି ଇଙନ୍‌ ଆ କିମ୍ପୋଙ୍‌ଲୋଙନ୍‌ ଅବୟ୍‌ ଓବ୍ବାସିଜନ୍‌ ଆଞମ୍‌ଞମ୍‌ । ଅଙ୍ଗା ଆଇମର୍‌ଆଡଙ୍‌ ଆଞ୍ଜେବୟ୍‌ ଗାମ୍‌ଲେ ଅନୋଡ୍ଡେନ୍‌ ଡେଏନ୍‌, ତିଆନିନ୍‌ ନମି ତୁଡ୍ରୁ ଆଙ୍ଗାୟ୍‌ ଡେଏନ୍ନି; ");
INSERT INTO juy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଆଜିର୍ତାଞନ୍‌ ଅନ୍ନିଙ୍‌ ଆ ବର୍ନେ ବୋର୍ସା ତଡ୍‌ ଅଃଡ୍ଡେଏ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ସିଲତ୍ତେ ମରିଅମନ୍‌ ଗାମେନ୍‌, “ଗିଜା, ଞେନ୍‌ ପ୍ରବୁନ୍‌ ଆ କମ୍ବାରିବୟ୍‌; ବର୍ନେନମ୍‌ ଅନ୍ତମ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡେଏତୋ ।” ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ତି ଆ ବନେଡ଼ା ମରିଅମନ୍‌ ଡୋଲନ୍‌ ଜିଉଦା ଡେସାନ୍‌ ଆ ବରୁରେଙ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଅବୟ୍‌ ଗଡ଼ାନ୍‌ ଲଜିରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ଆରି ଜିକରିୟନ୍‌ ଆସିଂ ଗନ୍‌ଲେ ଏଲିସାବେତନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ଲୋମେ । ");
INSERT INTO juy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ଆରି, ଏଲିସାବେତନ୍‌, ମରିଅମନ୍‌ ଆ ଲୋମ୍‌ଲୋମ୍‌ ଆରମ୍‌ଡଙେନ୍‌, ସିଲତ୍ତେମା ଆ କିମ୍ପୋଙ୍‌ଲୋଙନ୍‌ ଆ ପସିୟ୍‌ ତଙେନ୍‌, ଆରି ଏଲିସାବେତନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ବରିୟ୍‌ଡାଲେ, ");
INSERT INTO juy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଆଇମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଆମନ୍‌ ସନେନ୍‌ସେନ୍‌, ଆରି କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ନମ୍‌ ଆ ପସିୟ୍‌ ନିୟ୍‌ ସନେନ୍‌ସେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ବନ୍‌ଡ, ପ୍ରବୁଞେନ୍‌ ଆୟୋଙ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଇୟ୍‌ତାୟ୍‌, କେନ୍‌ କରମ୍ମାଞେନ୍‌ ଅଡ଼େଙ୍ଗା ସିଲଡ୍‌ ଡେଏନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗିଜା, ବର୍ନେନମ୍‌ ଆ ସର୍ରଙ୍‌ ଅରମ୍‌ଡଙ୍‌ଲାଞନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ସିଲତ୍ତେମା କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଆ ପସିୟ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ତଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ଆନା ଡର୍ରନେ, ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଇନିଜି ଇନିଜି ବନରନ୍‌ ଡେଲୋ, ତି ଅଡ଼୍‌କୋନ୍‌ ଡେଡମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ସିଲତ୍ତେ ମରିଅମନ୍‌ ଗାମେନ୍‌, “ପରାନ୍ନାଞେନ୍‌ ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ସେଙ୍କେତେ, ");
INSERT INTO juy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ଆରି ପୁରାଡ଼ାଞେନ୍‌ ଅନୁର୍‌ମର୍‌ ଇସ୍ୱରଞେନ୍‌ ଆମଙ୍‌ ସର୍ଡାତନେ; ");
INSERT INTO juy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆ କମ୍ୱାରିବଜନ୍‌ ଆ ଇର୍ସୋୟମ୍‌ ଗିଜେନ୍‌ । ଆରି ଗିଜା, ନମି ସିଲଡ୍‌ ପୁର୍ବାଃତେଜି ନିୟ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସନେନ୍‌ସେନ୍‌ ଗାମ୍‌ଲେ ବର୍ତିଁୟ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ବୋର୍ସା ଇସ୍ୱରନ୍‌, ଞେନ୍‌ ଆସନ୍‌ ସୋଡ଼ା କାବ୍ବାଡ଼ାନ୍‌ ଲୁମେନ୍‌; ଆଞୁମନ୍‌ ମଡ଼ିର୍‌, ");
INSERT INTO juy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଆବ୍ରତଙ୍‌ତେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଆ ସନାୟୁମନ୍‌ ଆ ଅନଞ୍ଜି ସିଲଡ୍‌ ଆ ଅନଞ୍ଜି ଜାୟ୍‌ ଡକୋତେ । ");
INSERT INTO juy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ଆନିନ୍‌ ଆ ଡେନ୍ନାନ୍‌ ବାତ୍ତେ ବୋର୍ସା କାବ୍ବାଡ଼ାନ୍‌ ଅବ୍‌ଗିୟ୍‌ତାଏନ୍‌, କଙ୍କ୍ରିମରଞ୍ଜି ଆ ମନ୍ନଲୋଙନ୍‌ ଆ ଗନବ୍‌ଡେଲ୍‌ବର୍‌ ତରଙ୍‌ଆନ୍ନା ଏମ୍ମେଆଜେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ଆନିନ୍‌ ଗର୍ବ ରାଜାଞ୍ଜିଆଡଙ୍‌ ଆ ତରଙ୍କୁମ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଅପ୍ପଡାଜେଞ୍ଜି, ଲଗଡ୍‌ ବୁଡ୍ଡିମରଞ୍ଜିଆଡଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ଆନିନ୍‌ ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ମନଙ୍‌ ମନଙ୍‌ ଜନୋମ୍‌ଜୋମଞ୍ଜି ତିୟ୍‌ଲେ ଅବ୍ବୋଓଏଞ୍ଜି, ଗମାଙ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଆରିକ୍କାସିନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆମଙ୍‌ ଆନିନ୍‌ ଅଙ୍ଗାତେ ପର୍ମାଡ଼ାଲନେ ତିଆତେ ଆନିନ୍‌ ଲୁମେନ୍‌, ଆରି ଆ କମ୍ୱାରିମରନ୍‌ ଇସ୍ରାଏଲନ୍‌ଆଡଙ୍‌ ସାଜଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ଆନିନ୍‌ ଆଏଡ଼ର୍‌ ଅବ୍ରାମନ୍‌ ଡ ଆ କେଜ୍ଜାମରଞ୍ଜିଆଡଙ୍‌ ସନାୟୁମନ୍‌ ଆସନ୍‌ ଅଃକ୍କରୋଡାଲୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ଆରି, ମରିଅମନ୍‌ ୟାଗି ଆଙ୍ଗାୟ୍‌ ଏଲିସାବେତନ୍‌ ସରିନ୍‌ ଡକୋଡାଲନ୍‌ ଆସିଂଡମନ୍‌ ୟର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ଏଲିସାବେତନ୍‌ ଆ କୋକ୍କୋଡନ୍‌ ବେଡ଼ାନ୍‌ ଆତ୍ରୁଙ୍‌ଲାଞନ୍‌, ଆନିନ୍‌ ଅବୟ୍‌ ଓବ୍ବାସିଜନ୍‌ କୋଡେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ଆରି ପ୍ରବୁନ୍‌, ଏଲିସାବେତନ୍‌ ଆସନ୍‌ ସୋଡ଼ା ସନାୟୁମନ୍‌ ଅବ୍‌ତୁଜେନ୍‌, କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆ ତୟ୍‌ଲିସିଂମରଞ୍ଜି ଡ ଆ କୁଲମଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ସର୍ଡାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ଆତ ଡିନ୍ନା ଆଡ୍ରେଏନ୍‌ ଆନିଞ୍ଜି ରେସାସିଜନ୍‌ଆଡଙ୍‌ ଗନବ୍‌ରେଡନ୍‌ ଆସନ୍‌ ସରେବାସିଙନ୍‌ ଇୟ୍‌ଲାଜି ଆରି ଆପେୟନ୍‌ ଆଞୁମ୍‌ ଅନ୍ତମ୍‌ ପସିଜନ୍‌ ଆଞୁମ୍‌ ଜିକରିୟ ଅନବ୍‌ଞୁମନ୍‌ ଆସନ୍‌ ଲଡଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ବନ୍‌ଡ ଆୟୋଙନ୍‌ ଗାମେନ୍‌, “ଇଜ୍ଜା, ଆଞୁମନ୍‌ ଜନ ଏଅବ୍‌ଞୁମ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ଆନିଞ୍ଜି ଏଲିସାବେତନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “କୁଲମ୍‌ଲୋଙ୍‌ବେଞ୍ଜି ତ ଆନ୍ନିଙ୍‌ ଆଞୁମ୍‌ ଏନ୍ନେଗୋ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ସିଲତ୍ତେ ଆଞୁମନ୍‌ ଇନି ତନିୟନ୍‌ ଡେତେ ଗାମ୍‌ଲେ ଆପେୟନ୍‌ ଲଡୟ୍‌ତେ, ତିଆତେ ଜନନାନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଜିକରିୟନ୍‌ଆଡଙ୍‌ ତାରିଆୟ୍‌ଡାଲେ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ଆରି ଜିକରିୟନ୍‌ ଅବୟ୍‌ ଅରିଡଲ୍‌ ପଟାନ୍‌ ବେଡ୍‌ଲେ, “ଆଞୁମନ୍‌ ଜନ” ଇଡେନ୍‌ । ସିଲତ୍ତେ ଅଡ଼୍‌କୋଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ଆରି, ସିଲତ୍ତେମା ଆ ତଅଡନ୍‌ ଡ ଆଲାଙନ୍‌ ରୋଲନେ ଆରି ଆନିନ୍‌ କଡାଡ଼ିଡାଲନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେଙ୍କେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ସିଲତ୍ତେ ଆ ତୟ୍‌ଲିସିଂମରଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ବତଙାଜେଞ୍ଜି, ଆରି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ସମ୍ପରା ଜିଉଦା ଡେସାନ୍‌ ଆ ବରୁରେଙ୍‌ ଆ ମନ୍‌ରାଜି ଅଲ୍‌ବର୍ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ଆରି ଆରମ୍‌ଡଙେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ତି ଅଡ଼୍‌କୋନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଉଗର୍‌ଲୋଙ୍‌ ଡକ୍କୋଡାଲେ ବର୍ରଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ପସିଜନ୍‌ ଇନି ଡେତେ ?” ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପ୍ରବୁନ୍‌ ଆ ବୋର୍ସା ଆନିନ୍‌ ସରିନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ଆରି, ଜନନ୍‌ ଆ ବାପା ଜିକରିୟନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ବରିୟ୍‌ଡାଲେ ପୁର୍ବାଃତେବରନ୍‌ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ସନେନ୍‌ସେନ୍‌ ପ୍ରବୁ, ଇସ୍ରାଏଲନ୍‌ ଆ ଇସ୍ୱର, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇର୍ସୋୟମ୍‌ଡାଲେ ତାଣ୍ଡେଏଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ଆନିନ୍‌ ଆ କମ୍ବାରିମରନ୍‌ ଦାଉଦନ୍‌ ଆ କେଜ୍ଜାଲୋଙ୍‌ ସିଲଡ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ଅବୟ୍‌ ବୋର୍ସା ଅନୁର୍‌ମରନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ପୁର୍ବାନ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ ମଡ଼ିର୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ତଅଡ୍‌ ଗଡ୍‌ ଏଙ୍ଗାଆତେ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ତି ଅନ୍ତମ୍‌ ବନେରାଲେଞ୍ଜି ଆସିଲୋଙ୍‌ ସିଲଡ୍‌ ଆରି ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଆରେଡ଼ୁର୍‌ମଡ୍‌ଲଙ୍‌ତଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆସିଲୋଙ୍‌ ସିଲଡ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଆନିନ୍‌ ଅବ୍ବଡ଼ୁର୍‌ଲଙ୍‌ତନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ଆନିନ୍‌ ବର୍ରନେ, ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜିଆଡଙ୍‌ ସାୟୁମ୍‌ତଜି, ଆରି ଆ ମଡ଼ିର୍‌ ଅନଗଡନ୍‌ ଡିତାନ୍‌ ଆନିନ୍‌ ମନ୍ନେତେ । ");
INSERT INTO juy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ଆପେୟ୍‌ଲେନ୍‌ ଅବ୍ରାମନ୍‌ ଆମଙ୍‌ ଅଙ୍ଗାତେ ଆନିନ୍‌ ପର୍ମାଡ଼ାଲନେ, ");
INSERT INTO juy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ଆରି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ବନେରାଲେଞ୍ଜି ଆସିଲୋଙ୍‌ ସିଲଡ୍‌ ଅଡ଼ୁର୍‌ଡାଲେ ଏର୍‌ବନ୍ତଙନ୍‌, ପରାନ୍ନାଲେନ୍‌ ଆଡ୍ରକୋତେନ୍‌ ଜାୟ୍‌ ଆ ମୁକ୍କାଲୋଙନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ମଡ଼ିରନ୍‌ ଡ ଡରମ୍ମନ୍‌ ବାତ୍ତେ ଗନଙ୍କେଲନ୍‌ ଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ସାୟୁମ୍‌ଲଙ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“ଆରି ଏ ଅଅନ୍‌ଞେନ୍‌, ଆମନ୍‌ ନିୟ୍‌ ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଗାମ୍‌ଲେ ଓଡ୍ଡେତମ୍‌ଜି; ");
INSERT INTO juy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଲୋଙଡନ୍‌ ଡ ରନବୁ ଲୁମ୍ମୁଲୋଙନ୍‌ ଆତଙ୍କୁମନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ସାଆରନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ଆରି ତନାଲ୍‌ଜଙ୍‌ଲେନ୍‌ ସୟୁ ତଙର୍‌ଗଡନ୍‌ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ଇସ୍ୱରଲେନ୍‌ ଅଙ୍ଗା ଆ ସନାୟୁମ୍‌ ବାତ୍ତେ ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ତୋଣ୍ଡୋନ୍‌ ସିଲଡ୍‌ ଡରୁଙ୍‌ୟୋଙନ୍‌ ଡେତେ, ");
INSERT INTO juy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ତି ଆ ସନାୟୁମନ୍‌ ବାତ୍ତେ ମନ୍‌ରାଞ୍ଜି ଆ ଇର୍ସେ କେମାଡାଲେ, ପ୍ରବୁନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଅନୁରନ୍‌ ଆ ଗିଆନ ତନିୟନ୍‌ ଆସନ୍‌ ଆମନ୍‌ ଆ ତଙରନ୍‌ ଅନବ୍‌ଜାଡାବାନ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ଆରି, ପସିଜନ୍‌ ସୋଡ଼ାଡାଲେ ପୁରାଡ଼ାଲୋଙନ୍‌ ବୋର୍ସାଲେ ପାଙେନ୍‌ ଆରି ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ଏର୍‌ନବ୍‌ଗିୟ୍‌ତାନେନ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ତିଆଡିଡ୍‌ କାଇସର୍‌ ଅଗସ୍ଟନ୍‌ ରୋମିଅ ସାମ୍ରାଜ୍ୟନ୍‌ ଆ ମନ୍‌ରାଜି ଡନିଡିନ୍‌ ଆସନ୍‌ ଅବ୍ବର୍ବରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","କୁରିଣିଅନ୍‌ ସୁରିଆ ଡେସାନ୍‌ ଆସ୍ରାସନଏନ୍‌ ଆଡିଡ୍‌ ପର୍ତମ୍ମୁ ମନ୍‌ରାନ୍‌ ଡନିଡିନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ତିଆସନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆଞୁମଞ୍ଜି ଅନବ୍‌ଇଡିଡନ୍‌ ଆସନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଗଡ଼ା ଜିର୍ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ଆରି, ଜୋସେପନ୍‌ ନିୟ୍‌ ଆଞୁମନ୍‌ ଅନବ୍‌ଇଡିଡନ୍‌ ଆସନ୍‌ ମରିଅମନ୍‌ ସରିନ୍‌ ଗାଲିଲିନ୍‌ ନାଜରିତ ଗଡ଼ା ସିଲଡ୍‌ ଜିଉଦାନ୍‌ ଡେସାନ୍‌ ବେତଲିମ ଗାମ୍‌ଲେ, ଦାଉଦନ୍‌ ଆ ଗଡ଼ା ଜିରେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଦାଉଦନ୍‌ ଆ ପୁଞ୍ଜା ଆରି କେଜ୍ଜାମର୍‌ ଡକୋଏନ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ଆନିନ୍‌ ବୟନ୍‌ ମରିଅମନ୍‌ ବିବାନେନ୍‌ ଆସନ୍‌ ଆଜଙ୍‌ଜଙ୍‌ ଡକୋଏଞ୍ଜି ଆରି ମରିଅମନ୍‌ ଆତିଲ୍‌କୋଡ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ଆନିଞ୍ଜି ତେତ୍ତେ ଆଡ୍ରକୋଏଞ୍ଜି ଆଡିଡ୍‌ ମରିଅମନ୍‌ ଆ କୋକ୍କୋଡନ୍‌ ବେଡ଼ାନ୍‌ ଅଡ଼ୋଲାୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ଆନିନ୍‌ ଆ ପର୍ତମ୍ମୁ ଅନନ୍‌ କୋଡେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଅବୟ୍‌ ସିନ୍‌ରିନ୍‌ ଅବ୍‌ଗୁସାୟ୍‌ଲେ ଗୁଆଡ଼ାନ୍‌ ଆ ଡୋଙ୍କାଲୋଙ୍‌ ପସିଜନ୍‌ ଅବ୍‌ଲୁଡ୍‌ଲୁଡେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ତେତ୍ତେ ବରସାସିଙନ୍‌ ଅବୟ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ତିସେଙ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ତୁର୍‌ମେଡ୍‌ମରଞ୍ଜି ତଗଲନ୍‌ ବସେଙ୍‌ଲୋଙନ୍‌ ଗୋସ୍ସାମେଡନ୍‌ ଜଗେଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ଆରି ଗିୟ୍‌ବା, ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ତୁର୍‌ମେଡ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଅବ୍‌ତୁୟ୍‌ନେ, ଆରି ପ୍ରବୁନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆ ସନାଆର୍‌ ଆମଙ୍‌ରେଙଞ୍ଜି ଏର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ତରାଡେ, ଆରି ଆନିଞ୍ଜି ମାଡ୍ଡ ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ସିଲତ୍ତେ ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବତଙ୍‌ଡଙ୍‌ବେନ୍‌; ଗିୟ୍‌ବା, ଞେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆସନ୍‌ ସର୍ଡାଡମନ୍‌ ଆ କବର ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାତବେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଲଙେ ଦାଉଦନ୍‌ ଆ ଗଡ଼ାଲୋଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଅବୟ୍‌ ଅନୁର୍‌ମରନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେଏନ୍‌, ଆନିନ୍‌ କ୍ରିସ୍ଟ ପ୍ରବୁ । ");
INSERT INTO juy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ଆମ୍ୱେଞ୍ଜି ଅବୟ୍‌ ଆ ରେସାସିଜନ୍‌ ସିନ୍‌ରିନ୍‌ ଅବ୍‌ଗୁସାୟ୍‌ଲେ ଗୁଆଡ଼ାନ୍‌ ଆ ଡୋଙ୍କାଲୋଙ୍‌ ଆବ୍‌ଲୁଡ୍‌ଲୁଡନ୍‌ ଇୟ୍‌ତେ ଏଗିଜେ, ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ କେନ୍‌ଆତେ ଅବୟ୍‌ ଅରମ୍ମଡନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ଆରି, ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ତି ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ସରିନ୍‌ ବଡଡ଼ ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଅବ୍‌ତୁୟ୍‌ଡାଲନ୍‌, ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେନ୍‌ଲେ ସେନ୍‌ଲେ ବର୍ରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଇସ୍ୱରନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡେଏତୋ, ଆରି ପୁର୍ତିଲୋଙନ୍‌ ଆନାଜି ଆମଙ୍‌ ଇସ୍ୱରନ୍‌ ମଅଁୟ୍‌ତେ ତି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ସନୟୁନ୍‌ ଡେଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ତୁର୍‌ମେଡ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ରୁଆଙନ୍‌ ଆୟର୍ରଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌, ତୁର୍‌ମେଡ୍‌ମରଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ୟବା, ଇନ୍‌ଲେଞ୍ଜି ବେତଲିମନ୍‌ ଏଇୟ୍‌ବା, ଆରି ଇନିଜି ଇନିଜି ଡେଏନ୍‌ ଗାମ୍‌ଲେ ପ୍ରବୁନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାଲଙ୍‌ଲନ୍‌, ତିଆତେ ଏଗିୟ୍‌ନାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଲଜିର୍‌ଡାଲେ ଇୟ୍‌ଲେ ସାଜେଞ୍ଜି, ଜୋସେପନ୍‌ ଡ ମରିଅମନ୍‌, ଆରି ଗୁଆଡ଼ାନ୍‌ ଆ ଡୋଙ୍କାଲୋଙ୍‌ ଆ ରେସାସିଜନ୍‌ ଆଲୁଡ୍‌ଲୁଡନ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ତୁର୍‌ମେଡ୍‌ମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଆଗ୍ରିଜେଞ୍ଜି, ତି ରେସାସିଜନ୍‌ ଆ ବର୍ନେ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଙ୍ଗା ବର୍ନେଜି ବରେଞ୍ଜି, ତିଆତେ ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ଆରି ଡିଅଙ୍ଗା ମନ୍‌ରା ତୁର୍‌ମେଡ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଅମ୍‌ଡଙେଞ୍ଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ବନ୍‌ଡ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ମରିଅମନ୍‌ ଆ ଉଗର୍‌ଲୋଙନ୍‌ ଡକ୍କୋଡାଲେ ଇୟମ୍‌ଲଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ଆରି, ତୁର୍‌ମେଡ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଏଙ୍ଗାଲେ ବରେଞ୍ଜି, ତିଅନ୍ତମ୍‌ ଆନିଞ୍ଜି ଇନିଜି ଇନିଜି ଅମ୍‌ଡଙେଞ୍ଜି ଆରି ଗିଜେଞ୍ଜି, ତି ଅଡ଼୍‌କୋନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେଙ୍କେଲେ, କନନ୍‌ଲନ୍‌ ୟର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ଆନିନ୍‌ଆଡଙ୍‌ ଗନବ୍‌ରେଡନ୍‌ ଆସନ୍‌ ଆତ ଡିନ୍ନା ଆଡ୍ରେଏନ୍‌, ଆଞୁମନ୍‌ ଜିସୁ ଅବ୍‌ଞୁମେଞ୍ଜି; କେନ୍‌ ଆଞୁମ୍‌ ମରିଅମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ତିଲ୍‌କୋଡେନ୍‌ ମା ଆଡିଡ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଅବ୍‌ଞୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ତିକ୍କି ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଅନ୍ତମ୍‌ ଆନିଞ୍ଜି ମଡ଼ିର୍‌ ଡିନ୍ନାନ୍‌ ଆତ୍ରୁଙ୍‌ଲାଞନ୍‌, ଜୋସେପନ୍‌ ଡ ମରିଅମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପ୍ରବୁନ୍‌ ଆସନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଜିରୁସାଲମନ୍‌ ଓରୋଙ୍‌ଲାଜି, ");
INSERT INTO juy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ତିଆଡିଡ୍‌ ପ୍ରବୁନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ଲୋଙ୍‌ ଆଇଡିଡନ୍‌ ଅନ୍ତମ୍‌, “ଅଡ଼୍‌କୋ ପର୍ତମ୍ମୁ ଓବ୍ବାଅନନ୍‌ ପ୍ରବୁନ୍‌ ଆସନ୍‌ ମଡ଼ିର୍‌ ଗାମ୍‌ଲେ ଡନିଡିନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ଆରି ପ୍ରବୁନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଅନ୍ତମ୍‌ ଅନମଙନ୍‌ ଆସନ୍‌ ବାଗୁ ପାରାନ୍‌ ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ବାଗୁ କୁକ୍କୁର୍‌ଅନନ୍‌ ପାଙ୍‌ଲେ ଜିରୁସାଲମ ସରେବାସିଙନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ଆରି ଗିୟ୍‌ବା, ସିମନ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିରୁସାଲମନ୍‌ ଡକୋଲନେ, ଆନିନ୍‌ ଡରମ୍ମମର୍‌ ଆରି ବୟ୍‌ଲେମର୍‌ ଡକୋଏନ୍‌; ଆନିନ୍‌ ଇସ୍ରାଏଲନ୍‌ ଆସନ୍‌ ବନବ୍‌ୟୋନ୍‌ ଜଗେଲେ ଡକୋଲନେ, ଆରି ଆମଙନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","“ଆମନ୍‌ ପ୍ରବୁନ୍‌ ଆ କ୍ରିସ୍ଟ ଅଣ୍ଡ୍ରଙ୍‌ ଗିଜେନ୍‌ ଜାୟ୍‌ ଅଃର୍ରବୁଅମ୍‌” ଗାମ୍‌ଲେ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ଆନିନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଆବର୍‌ବର୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ଅଙ୍ଗା ଆଡିଡ୍‌ ରେସା ଜିସୁନ୍‌ ଆସନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଆନଗଡ୍‌ ଅନ୍ତମ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ଆପେୟନ୍‌ ଡ ଆୟୋଙନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସରେବାସିଙନ୍‌ ଓରୋଙ୍‌ଲାଜି, ତିଆଡିଡ୍‌ ସିମନନ୍‌ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ଆପ୍ପାୟ୍‌ଡମ୍‌ଲନ୍‌ ସରେବାସିଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ଆରି ସିମନନ୍‌ ରେସାସିଜନ୍‌ଆଡଙ୍‌ ଆସିଲୋଙନ୍‌ ଞମ୍‌ଲେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେଙ୍କେଲେ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ଏ ପ୍ରବୁ, ନମି ଆମନ୍‌ ବର୍ନେନମ୍‌ ଅନ୍ତମ୍‌, କମ୍ୱାରିମର୍‌ନମ୍‌ଆଡଙ୍‌ ଉଗୁରିୟ୍‌ ଜିର୍‌ଜିରନ୍‌ ଆସନ୍‌ ତିୟ୍‌ତେ; ");
INSERT INTO juy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅମଡ୍‌ଞେନ୍‌ ଅନୁର୍‌ନମ୍‌ ଗିଜେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ଆମନ୍‌ ତିଆତେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଅବ୍‌ଜାଡାଲେ, ");
INSERT INTO juy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ଏର୍‌ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିନ୍‌ ଆରବ୍‌ତୁୟ୍‌ତେନ୍‌ ଆ ସନାଆର୍‌, ଆରି ଇସ୍ରାଏଲ୍‌ ମନ୍‌ରାନମ୍‌ଜି ଆ ଗନୁଗୁ ପନେମେଙ୍‌ଡାଗୋ ଏମ୍ମେଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ରେସାସିଜନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆପେୟନ୍‌ ଡ ଆୟୋଙନ୍‌ ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ଆରି, ସିମନନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆସିର୍ବାଦଲେ ଆୟୋଙନ୍‌ ମରିଅମନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଗିଜା, ଇସ୍ରାଏଲଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଜବ୍ର ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ଡୋନ୍‌ ଆସନ୍‌ ଡ ଅନବ୍‌ସେଡନ୍‌ ଆସନ୍‌, କେନ୍‌ ଆ ପସିୟ୍‌ ସନେଡାନ୍‌ ଡେଏନ୍‌ । ଆରି ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ଅରମ୍ମଡନ୍‌ ଅନ୍ତମ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ଜବ୍ର ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସଙ୍ଗତ୍ତାଡାଲେ ଆ ଉଗର୍‌ଲୋଙଞ୍ଜି ଆନିଃୟମ୍‌ ଗିୟ୍‌ତାତେ । ଆରି ଆମନ୍‌ ନିୟ୍‌ ଅନିଃୟମ୍‌ଡାଗୋ ଆ କଡ଼ିବ୍‌ ବାତ୍ତେ ପରାନ୍ନାନମ୍‌ ପଡମ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ଆରି, ଆନ୍ନା ଗାମ୍‌ଲେ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେବଜନ୍‌ ଡକୋଏନ୍‌; ଆନିନ୍‌ ଆସେରନ୍‌ ଆ କେଜ୍ଜା ପିନୁଏଲନ୍‌ ଆ ଡାଙ୍ଗଡ଼ିଅନ୍‌ । ଆନିନ୍‌ ଆବୁଡିଡମ୍‌; ଆନିନ୍‌ ଆବ୍ରିବାଲନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆ ଅୟ୍‌ତବନ୍‌ ସରିନ୍‌ ସାତ ବର୍ସେଙ୍‌ ଡକୋଲନେ ଆରି ଉଞ୍ଜିକୁଡ଼ି ଉଞ୍ଜି ବର୍ସେଙ୍‌ ଜାୟ୍‌ ଆଜୁଆରନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ଆନିନ୍‌ ସରେବାସିଙନ୍‌ ଏର୍‌ନମ୍‌ରେଙ୍‌ଡାଲେ ଆନମ୍‌ନେନ୍‌ ଡ ପାର୍ତନାନ୍‌ ବାତ୍ତେ ତଗଲ୍‌ ତମ୍‌ବା ସେଙ୍କେଲେ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ତି ଆ ବନେଡ଼ା ଆନିନ୍‌ ଜିର୍ରେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେନ୍‌ଲେ, ଜିରୁସାଲମନ୍‌ ଆ ତନାଣ୍ଡେ ଜଗେଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ରେସାସିଜନ୍‌ ଆ ବର୍ନେ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ଜୋସେପନ୍‌ ଡ ମରିଅମନ୍‌ ପ୍ରବୁନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଅନ୍ତମ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ କାବ୍ବାଡ଼ା ସାଡେଞ୍ଜି କି ଗାଲିଲିନ୍‌, ଆ ଗଡ଼ାଞ୍ଜି ନାଜରିତନ୍‌ ୟର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ଆରି, ପସିଜନ୍‌ ସୋଡ଼ାଡାଲେ ପୁରାଡ଼ାଲୋଙନ୍‌ ବୋର୍ସାଲେ ପାଙେନ୍‌ ଆରି ଗିଆନନ୍‌ ଞାଙେନ୍‌, ଆରି ଇସ୍ୱରନ୍‌ ଆ ସନାୟୁମ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ଜିସୁନ୍‌ ଆ ବାପା ଡ ଆୟୋଙନ୍‌ ଡିଲେ ବର୍ସେଙ୍‌ ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆସନ୍‌ ଜିରୁସାଲମନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ଜିସୁନ୍‌ ବାର ବର୍ସେଙ୍‌ ଆଡ୍ରେଏନ୍‌ ଆଡିଡ୍‌ ଆଓକ୍କାଞ୍ଜି ଅନ୍ତମ୍‌ ପୁର୍‌ପୁରନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ପୁର୍‌ପୁରନ୍‌ ଅବ୍‌ସୁଜ୍ଜେଡାଲେ ଆନିଞ୍ଜି ୟର୍ରନାଜି, ବନ୍‌ଡ ପସିୟ୍‌ ଜିସୁନ୍‌ ଜିରୁସାଲମନ୍‌ ରଏଲାୟ୍‌, ଆରି ଜୋସେପନ୍‌ ଡ ମରିଅମନ୍‌ ତିଆତେ ଅଃଜ୍ଜନାଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ଆନିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଆଜିର୍ତାଞଞ୍ଜି ଆ ମନ୍‌ରାଜି ସରିନ୍‌ ଜିର୍ତାୟ୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟ୍‌ଲେ ଆପେୟନ୍‌ ଡ ଆୟୋଙନ୍‌ ବମିୟ୍‌ତା ଆ ତଙର୍‌ ଜିରେଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ଆ କୁଲମଞ୍ଜି ଡ ଆଅମ୍ମଡ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସାୟ୍‌ଡଙେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ବନ୍‌ଡ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅଃର୍ରବାଙ୍‌ଲଞ୍ଜି, ଆନିଞ୍ଜି ସାୟ୍‌ଲେ ସାୟ୍‌ଲେ ଜିରୁସାଲମନ୍‌ ୟର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ଏର୍ତାଲୋଙ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଇୟ୍‌ଲେ ରବାଙେଜି; ଆନିନ୍‌ ଞନଙ୍‌ତିୟ୍‌ମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ଆ ବର୍ନେଞ୍ଜି ଅମ୍‌ଡଙ୍‌ଲେ ଡକୋଲନ୍‌ ଆରି ଆନିନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ବର୍ନେଞ୍ଜି ଅପ୍ପୁଙେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ଆରି ଡିଅଙ୍ଗା ମନ୍‌ରା ତେତ୍ତେ ଡକୋଏଞ୍ଜି ଆ ବୁଡ୍ଡିନ୍‌ ଡ ଆ ଜନାଲଙନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନିଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ଜୋସେପନ୍‌ ଡ ମରିଅମନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ସାନ୍ନି ଡେଏଞ୍ଜି ଆରି ମରିଅମନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ନୁନ୍ନା, ଇନିବା ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ଏନ୍ନେଲଲେନ୍‌ ? ଗିଜା, ଆପେୟ୍‌ନମ୍‌ ଡ ଞେନ୍‌ ଡିୟ୍‌ନେ ବାଉଲ୍ଲିଲନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଏସାୟ୍‌ଡଙ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ଏସାୟ୍‌ଡଙ୍‌ତିଁୟ୍‌ ? ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆସିଂ ଡକୋତନାୟ୍‌, କେନ୍‌ଆତେ କାବ୍ବାଡ଼ାଞେନ୍‌, ଆମ୍ୱେନ୍‌ କେନ୍‌ଆତେ ଅଣ୍ଡ୍ରଙ୍‌ ପଙ୍‌ ଜନାବେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ବନ୍‌ଡ ଆନିନ୍‌ ଅଙ୍ଗାତେ ବର୍ରନେ ଆନିଞ୍ଜି ତିଆତେ ଅଃଗନ୍‌ଲୁଡ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ନାଜରିତନ୍‌ ୟର୍ରନେ ଆରି ଆନିନ୍‌ ଆପେୟନ୍‌ ଡ ଆୟୋଙନ୍‌ ଆ ବର୍ନେ ମାନ୍ନେଲେ ଡକୋଲନେ; ଆରି, ଆୟୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଆ ଉଗର୍‌ଲୋଙନ୍‌ ଜୁବାୟ୍‌ଲେ ଡକ୍କୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ଜିସୁନ୍‌ ଜନନାନ୍‌, ଡଅଙନ୍‌, ଆରି ଇସ୍ୱରନ୍‌ ଡ ମନ୍‌ରାଜି ଆ ସନାୟୁମ୍‌ ବାତ୍ତେ ମରଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ତିବିରିଆ କାଇସର୍‌ ସୋଡ଼ା ରାଜାନ୍‌ ସାସନଡାଲେ ପନ୍ଦର ବର୍ସେଙ୍‌ ଆଡ୍ରେଏନ୍‌ ଆଡିଡ୍‌, ପନ୍ତିଅ ପିଲାତନ୍‌ ଜିଉଦାନ୍‌ ଆ ରାଜ୍ୟପାଡ଼ ଆରି ଏରୋଦନ୍‌ ଗାଲିଲିନ୍‌ ଆ ରାଜ୍ୟପାଡ଼ ଡକୋଏନ୍‌, ଆରି ଆ ବୋଞାଙନ୍‌ ପିଲିପନ୍‌ ଇତୁରିଆନ୍‌ ଡ ତ୍ରାକୋନିତିନ୍‌ ଆ ରାଜ୍ୟପାଡ଼, ଆରି ଲୁସାନିଆନ୍‌ ଅବିଲିନି ଗଡ଼ାନ୍‌ ଆ ରାଜ୍ୟପାଡ଼ ଡକୋଏନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ଆରି ଆନାନନ୍‌ ଡ କାୟାପାନ୍‌ ମୁଡ଼ ରାଓଡ଼ା ଡକୋଏଞ୍ଜି, ତିଆଡିଡ୍‌ ଜିକରିୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆମଙ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅଡ଼ୋଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ତିଆସନ୍‌ ଆନିନ୍‌ ଜର୍ଦନ ଅଲନ୍‌ ଆ ତୁୟାୟ୍‌ରେଙ୍‌ ଜିର୍ରେ, “ଇର୍ସେବେନ୍‌ ସିଲଡ୍‌ ୟର୍ରନ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନାବା ଆରି ତବ୍ବୁବ୍‌ଡାନାବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ କେମାତବେନ୍‌ ।” ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ଆ ସାସ୍ତ୍ରଲୋଙ୍‌ ଏଙ୍ଗାଲେ ଆଇଡିଡନ୍‌ ଡକୋ, “ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଆକ୍ରାନ୍‌ ଆବ୍ରାବ୍ବାବ୍‌ତେନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ ସର୍ରଙ୍‌ ସଡ୍ଡାତେ, ‘ପ୍ରବୁନ୍‌ ଆସନ୍‌ ତଙର୍‌ ଅବ୍‌ଜାଡାବା, ଆନିନ୍‌ ଆସନ୍‌ ରୋତ୍ତନ୍‌ ବିଙୟ୍‌ବା; ");
INSERT INTO juy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ଅଡ଼୍‌କୋ ଗର୍ଡଞ୍ଜି ବବ୍‌ରିୟ୍‌ତନେ, ଆରି ଅଡ଼୍‌କୋ ବରୁଞ୍ଜି ଡ ତଡ଼କୁବଞ୍ଜି ଅବ୍‌ଜାୟ୍‌ତାତନେ, ଆବାଙ୍କଡ଼ୋନ୍‌ ଆ ତଙର୍‌ଜି ବିଙୟ୍‌ତେ, ଆରି ତୋଣ୍ଡୋ ଜାୟ୍‌ତାନ୍‌ ଆ ଲବଜି ଗରିଡମ୍‌ ଆ ତଙର୍‌ ଡେତେ; ");
INSERT INTO juy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ଆରି, ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଇସ୍ୱରନ୍‌ ଆନୁର୍‌ ଗିୟ୍‌ତଜି ।’” ");
INSERT INTO juy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ତିଆସନ୍‌, ଜନନ୍‌ ଆମଙ୍‌ ତବ୍ବୁବ୍‌ଡାନେନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଆନିନ୍‌ ବର୍ରନେ, “ଏ ବିସଜଡନ୍‌ ଆଅନ୍‌ଜି, ବିଅଜି ଆଜିର୍ତାଞନ୍‌ ଆ ବନ୍‌ଡ୍ରାବ୍‌ ସିଲଡ୍‌ ଅବ୍ବଡ଼ୁର୍‌ନେନ୍‌ ଆସନ୍‌ ଆନା ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ସେତ୍ତାଲବେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ତିଆସନ୍‌ ଇର୍ସେନ୍‌ ସିଲଡ୍‌ ୟର୍ରନ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଜନ୍‌ ଅବ୍‌ଜଅନାବା; ଆରି, ଅବ୍ରାମନ୍‌ ପୁର୍ବା ଜୋଜୋଲେନ୍‌ ଗାମ୍‌ଲେ ମନ୍ନଲୋଙ୍‌ବେନ୍‌ ନିୟ୍‌ ଏନ୍ନେଲେ ଏବର୍‌ଡଙ୍‌ନେ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ୱରନ୍‌ କେନ୍‌ ଅରେଙଞ୍ଜି ସିଲଡ୍‌ ନିୟ୍‌ ଅବ୍ରାମନ୍‌ ଆସନ୍‌ ପସିଜନ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ରପ୍ତିତେ । ");
INSERT INTO juy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ଆରି, ନମି ନିୟ୍‌ ଅରାନୁବଞ୍ଜି ଆଜଡ୍‌ଲୋଙ୍‌ ଏଞ୍ଜୁମନ୍‌ ଆଡକ୍କୋ; ତିଆସନ୍‌ ଅଙ୍ଗା ଅରାନୁବ୍‌ ମନଙ୍‌ ଅଃନ୍ନଜଏ, ତିଆତେ ଅଡ୍‌ଲେ ତଗୋଲୋଙନ୍‌ ପନିଡନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ସିଲତ୍ତେ ମନ୍‌ରାଞ୍ଜି ଜନନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଇନି ଏଏଙ୍ଗାନାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ଜନନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆନା ଆମଙ୍‌ ବାଗୁ ଅଙ୍ଗିନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଆମଙ୍‌ ଅଙ୍ଗି ତଡ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ତିଏତୋ; ଆରି, ଆନା ଆମଙ୍‌ ଜନୋମ୍‌ଜୋମନ୍‌ ଡକୋ, ଆନିନ୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ଲୁମେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ପାନୁବେଡ୍‌ମରଞ୍ଜି ନିୟ୍‌ ତବ୍ବୁବ୍‌ଡାନେବାନ୍‌ ଇୟ୍‌ଲେ ଜନନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ଇନି ଏଏଙ୍ଗାନାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ଆରି, ଜନନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ପାନୁନ୍‌ ଡିଅଙ୍ଗା ଆଗବ୍‌ରି, ଡିୟ୍‌ତେ ମା ବେଡ୍‌ବେଡ୍‌ବା, ଡିୟ୍‌ତେ ସିଲଡ୍‌ ଆରି ଗୋଗୋୟ୍‌ ଏବେଡ୍‌ବେଡ୍ଡଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ସିପ୍ପାୟଞ୍ଜି ନିୟ୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଇନ୍‌ଲେଞ୍ଜି ଇନି ଏଏଙ୍ଗାନାୟ୍‌ ?” ଜନନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବବ୍‌ତଙ୍‌ଡାଲେ ଆନ୍ନିଙ୍‌ ଆ ଡାବ୍ବୋ ଏପାଙ୍‌ଡଙାୟ୍‌ କି କଣ୍ଡାୟ୍‌ଡାଲେ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଏବ୍‌ଡୋସାଡଙ୍‌, ଆରି ବର୍ତନ୍ନାଲୋଙ୍‌ବେନ୍‌ ସରି ଗାମ୍‌ଲେ ଡକୋନାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ମନ୍‌ରାଞ୍ଜି ଜଗେଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଡ ଅସମୟ୍‌ କେନ୍‌ଆନିନ୍‌ ଜାଆରୋ କ୍ରିସ୍ଟନ୍‌ ଗାମ୍‌ଲେ, ଜନନ୍‌ ଆସନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମନ୍ନଲୋଙଞ୍ଜି ଏନ୍ନେଲେ ଇୟମେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ତିଆସନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ସିନା ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଡାଆଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତବେନ୍‌, ବନ୍‌ଡ ଞେନ୍‌ ସିଲଡ୍‌ ଆନା ଗୋଗୋୟ୍‌ ସୋଡ଼ା, ଆନିନ୍‌ ଜିର୍ତାୟ୍‌, ଆ ତାଲ୍‌ଜଙନ୍‌ ଆ ପାଣ୍ଡୋୟ୍‌ ଆ ଜନିବାଡ୍‌ ଉଜୁଜନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌; ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡ ତଗୋଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ଆସିଲୋଙନ୍‌ ଅୟ୍ୟେରନ୍‌ ଡକୋ, ତିଆସନ୍‌ ଆନିନ୍‌ ତନିଲ୍‌ଲୋଙନ୍ ଆ ଜନ୍‌ରୋମ୍‌ ଗୁମ୍‌ଗୁମ୍‌ଡାଲେ ଆ ମରଁୟ୍‌ଲୋଙନ୍‌ ତର୍ତୁମ୍‌ଲେ ଡକ୍କୋତେ, ଆରି ଆପୋନ୍‌ଲାଞ୍ଜିଆତେ ଆନିନ୍‌ ଅଃପ୍ପଞିଡେନ୍‌ ଆ ତଗୋଲୋଙ୍‌ ସୟ୍‌ଲେ ସେତ୍ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ଆନିନ୍‌ ଏନ୍ନେଲେ ଗୋଗୋୟ୍‌ଡମ୍‌ ମନଙ୍‌ବରଞ୍ଜି ବର୍ରନେ, ଆରି ଆନ୍ନା ଆନ୍ନା ଅନୁୟୁବ୍‌ ବର୍ନେଞ୍ଜି ବର୍ରନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଅପ୍ପୁଙ୍‌ବରେଞ୍ଜି; ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନେନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ଆରି ଜନନ୍‌ ଏରୋଦ ରାଜ୍ୟପାଡ଼ନ୍‌ଆଡଙ୍‌ ଆକ୍ରାନ୍‌ ଇୟ୍‌ଲେ କଞେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏରୋଦନ୍‌ ଆ ବୋଞାଙନ୍‌ ଆ ଡୁକ୍ରି ଏରୋଦିଆନ୍‌ଆଡଙ୍‌ ଡକ୍କୋଏନ୍‌ ଆରି ଜବ୍ର ପରାନ୍‌ସାତ୍ତିଲୁମଞ୍ଜି ଲୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ତିଆସନ୍‌ ଏରୋଦନ୍‌ ଜନନ୍‌ଆଡଙ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକ୍କୋଡାଲେ, ଅଡ଼୍‌କୋନ୍‌ ଆ ଡୋସାନ୍‌ ବୟନ୍‌ କେନ୍‌ଆତେ ନିୟ୍‌ ଅବ୍‌ମାୟ୍‌ମାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ତବ୍ବୁବ୍‌ଡାଲଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ନିୟ୍‌ ତବ୍ବୁବ୍‌ଡାଲନେ, ଆରି ଆନିନ୍‌ ଆ ପାର୍ତନାଲନେନ୍‌ ଆଡିଡ୍‌ ରୁଆଙନ୍‌ ରୋଲନେ, ");
INSERT INTO juy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ଆରି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡଅଙନ୍‌ ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ କୁକ୍କୁରନ୍‌ ଅନ୍ତମ୍‌ ଜିସୁନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତାର୍ଡୋୟ୍‌ନେ; ଆରି, ରୁଆଙନ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଅଡ଼ୋଲାୟ୍‌, “ଆମନ୍‌ ଡନୁଙ୍‌ୟମ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌, ଅମଙ୍‌ନମ୍‌ ଞେନ୍‌ ଗୋଗୋୟ୍‌ ମଅଁୟ୍‌ଡାତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ଜିସୁନ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଆରୁଲନେନ୍‌ ଆଡିଡ୍‌ ଆନିନ୍‌ ତିରିସି ବର୍ସେଙ୍‌ ଡେଏନ୍‌; ମନ୍‌ରାଞ୍ଜି ଆ ବର୍ନେ ଅନ୍ତମ୍‌ ଜିସୁନ୍‌ ଜୋସେପନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌; ଜୋସେପନ୍‌ ଏଲିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଏଲିନ୍‌ ମତାତନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମତାତନ୍‌ ଲେବିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଲେବିନ୍‌ ମଲ୍‌କିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମଲ୍‌କିନ୍‌ ଜନ୍ନୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜନ୍ନୟନ୍‌ ଜୋସେପନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଜୋସେପନ୍‌ ମତ୍ତିତ୍ୟାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମତ୍ତିତ୍ୟାନ୍‌ ଆମୋସନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଆମୋସନ୍‌ ନାଉମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ନାଉମନ୍‌ ଏସ୍ମିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଏସ୍ମିନ୍‌ ନଗୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନଗୟନ୍‌ ମଅତନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମଅତନ୍‌ ମତ୍ତିତ୍ୟାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମତ୍ତିତ୍ୟାନ୍‌ ସିମୟିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ସିମୟିନ୍‌ ଜୋସେକନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜୋସେକନ୍‌ ଜୋଦାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଜୋଦାନ୍‌ ଜନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜନନ୍‌ ରେସାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ରେସାନ୍‌ ଜିରୁବାବେଲନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜିରୁବାବେଲନ୍‌ ସଲ୍‌ଟିୟେଲନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ସଲ୍‌ଟିୟେଲନ୍‌ ନେରିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରିନ୍‌ ମଲ୍‌କିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମଲ୍‌କିନ୍‌ ଅଦ୍ଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଅଦ୍ଦିନ୍‌ କୋସାମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, କୋସାମନ୍‌ ଏଲ୍‌ମଦାନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଏଲ୍‌ମଦାନନ୍‌ ଏରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଏରନ୍‌ ଜିଓସୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜିଓସୟନ୍‌ ଏଲିଆଜରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଏଲିଆଜରନ୍‌ ଜୋରିମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜୋରିମନ୍‌ ମତାତନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମତାତନ୍‌ ଲେବିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେବିନ୍‌ ସିମନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ସିମନନ୍‌ ଜିଉଦାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜିଉଦାନ୍‌ ଜୋସେପନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜୋସେପନ୍‌ ଜୋନାମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜୋନାମନ୍‌ ଏଲିଆକିମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଏଲିଆକିମନ୍‌ ମଲାଅନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମଲାଅନ୍‌ ମନ୍ନାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମନ୍ନାନ୍‌ ମତ୍ତତାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମତ୍ତତାନ୍‌ ନାତନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ନାତନନ୍‌ ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାଉଦନ୍‌ ଜିସୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜିସୟନ୍‌ ଓବେଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଓବେଦନ୍‌ ବୋୟାଜନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ବୋୟାଜନ୍‌ ସେଲଅନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ସେଲଅନ୍‌ ନଅସୋନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନଅସୋନନ୍‌ ଅମିନାଦବନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଅମିନାଦବନ୍‌ ଅଦ୍‌ମିନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଅଦ୍‌ମିନନ୍‌ ଅର୍ନିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଅର୍ନିନ୍‌ ଏସ୍ରୋଣନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଏସ୍ରୋଣନ୍‌ ପେରସନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ପେରସନ୍‌ ଜିଉଦାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଜିଉଦାନ୍‌ ଜାକୁବନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜାକୁବନ୍‌ ଇସାକନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଇସାକନ୍‌ ଅବ୍ରାମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଅବ୍ରାମନ୍‌ ତେରଅନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ତେରଅନ୍‌ ନାଓରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନାଓରନ୍‌ ସରୁଗନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ସରୁଗନ୍‌ ରଗୁନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ରଗୁନ୍‌ ପେଲଗନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ପେଲଗନ୍‌ ଏବରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଏବରନ୍‌ ସେଲଅନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ସେଲଅନ୍‌ କେନାନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, କେନାନନ୍‌ ଅର୍ପକଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଅର୍ପକଦନ୍‌ ସେମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ସେମନ୍‌ ନୋଅନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ନୋଅନ୍‌ ଲେମକନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲେମକନ୍‌ ମତୁସେଲନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମତୁସେଲନ୍‌ ଅନୁକନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଅନୁକନ୍‌ ଜେରଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଜେରଦନ୍‌ ମଅଲେଲନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ମଅଲେଲନ୍‌ କେନାନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କେନାନନ୍‌ ଏନୋସନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଏନୋସନ୍‌ ସେତନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ସେତନ୍‌ ଆଦମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଆଦମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ଜିସୁନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ବରିୟ୍‌ଡାଲେ ଜର୍ଦନ ଅଲନ୍‌ ସିଲଡ୍‌ ୟର୍ରନାୟ୍‌, ଆରି ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ଆରିଙ୍‌ରିଙ୍‌ରେଙନ୍‌ ଆପ୍ପାୟ୍‌ଡାଲନ୍‌ ତେତ୍ତେ ବାକୁଡ଼ି ଡିନ୍ନା ଜାୟ୍‌ ସନୁମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତୋରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ତି ଆଡିନ୍ନାରେଙ୍‌ ଆନିନ୍‌ ଇନ୍ନିଙ୍‌ ଅଃଜ୍ଜୋମ୍‌ଲୋ, ଆରି ବାକୁଡ଼ି ଡିନ୍ନା ଆପ୍ରଡେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନିନ୍‌ ଡୋଲେଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ସିଲତ୍ତେ ସନୁମନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଅରେଙନ୍‌ ରୁଟିନ୍‌ ଡେଏତୋ ଗାମ୍‌ଲେ ବର୍ନା ।” ");
INSERT INTO juy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ଜିସୁନ୍‌ ସନୁମନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଡକୋ, ‘ମନ୍‌ରାନ୍‌ ସତ୍ତର୍‌ ରୁଟିନ୍‌ ଜୋମ୍‌ଲେ ଅଃନ୍ନମେଙେ ।’” ");
INSERT INTO juy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ଆରି, ସନୁମନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଓରୋଙ୍‌ଡାଲେ ବସନ୍ନେଃ ଆସନ୍‌ ପୁର୍ତିନ୍‌ ଆ ରାଜ୍ୟଜି ଅଡ଼୍‌କୋନ୍‌ ଅବ୍‌ତୁଜାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ଆରି, ସନୁମନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ଡ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅରିଃସୁମଞ୍ଜି ଆମନ୍‌ ତିୟ୍‌ତମ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ଆତିୟ୍‌ତିୟ୍‌, ଆରି ଞେନ୍‌ ଆନାଆଡଙ୍‌ ଲଡୟ୍‌ତିଁୟ୍‌, ଆନିନ୍‌ କେନ୍‌ଆତେ ତିୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ତିଆସନ୍‌, ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଲୋମ୍‌ଲିଁୟ୍‌ ଡେନ୍‌, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆମନ୍‌ଆତେ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ଜିସୁନ୍‌, ସନୁମନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଡକୋ, ‘ଆମନ୍‌ ପ୍ରବୁ ଇସ୍ୱରନମ୍‌ଆଡଙ୍‌ ଲୋମା, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ତୁମ୍‌ ସେଙ୍କେଆ ।’” ");
INSERT INTO juy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ଆରି, ସନୁମନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜିରୁସାଲମନ୍‌ ଓରୋଙ୍‌ଡାଲେ ସରେବାସିଙନ୍‌ ଆ ତୋଣ୍ଡୋ ବିଲେଙ୍‌ଲୋଙ୍‌ ତବ୍‌ନଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତେନ୍ନେ ସିଲଡ୍‌ ଜାୟ୍‌ତାନ୍‌ ଅନ୍‌ତ୍ତିଡ୍‌ନା; ");
INSERT INTO juy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ‘ଆମନ୍‌ଆଡଙ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ବାଁୟ୍‌ତଜି,’ ଗାମ୍‌ଲେ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଡକୋ; ");
INSERT INTO juy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ଆରି ନିୟ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଡକୋ, ‘ଅସମୟ୍‌ ତାଲ୍‌ଜଙ୍‌ନମ୍‌ ଅରେଙ୍‌ଲୋଙନ୍‌ ଗତର୍‌ତେ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ଆସିଲୋଙଞ୍ଜି ତାଣ୍ଡାମ୍‌ଲେ ଞମ୍‌ତମ୍‌ଜି ।’” ");
INSERT INTO juy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ଆରି, ଜିସୁନ୍‌ ସନୁମନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଡକୋ, ‘ଆମନ୍‌ ପ୍ରବୁ ଇସ୍ୱରନମ୍‌ଆଡଙ୍‌ ମାଲ୍‌ଡଙେ ।’” ");
INSERT INTO juy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ସନୁମନ୍‌ ଅଡ଼୍‌କୋ ତନୋର୍‌ତୋରଞ୍ଜି ଅବ୍‌ସୁଜ୍ଜେଡାଲେ ରୟଙନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଞାଙେନ୍‌ ଜାୟ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ ଗାଲିଲିନ୍‌ ୟର୍ରନାୟ୍‌, ଆରି ଆ ବର୍ନେନ୍‌ ସମ୍ପରାରେଙନ୍‌ ବୁର୍ବୁରାୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ଆରି, ଜିସୁନ୍‌ ରନୁକ୍କୁସିଂରେଙଞ୍ଜି ଞନଙନ୍‌ ଆତ୍ରିୟେନ୍‌, ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସେଙ୍କେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ନାଜରିତ ଗଡ଼ାନ୍‌ ଜିରେନ୍‌, ଆରି ଅନଗଡନ୍‌ ଅନ୍ତମ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ଗନ୍‌ଲନେ, ଆରି ସାସ୍ତ୍ରନ୍‌ ପଡ଼େନେନ୍‌ ଆସନ୍‌ ତନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ତିଆଡିଡ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ଆ ବଇ ଆନିନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେଏନ୍‌, ଆରି ଆନିନ୍‌ ତିଆତେ ଉୟ୍‌ଲେ, ଅଙ୍ଗାଲୋଙ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆଇଡିଡ୍‌, ତିଆତେ ଞାଙେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ପ୍ରବୁନ୍‌ ଆ ପୁରାଡ଼ା ଅମଙ୍‌ଞେନ୍‌ ଡକୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଡୋଲେୟ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସେଡାଲିଁୟ୍‌, ବଣ୍ଡିମରଞ୍ଜି ଆମଙ୍‌ ତନାଣ୍ଡେନ୍‌ ଆ ବର୍ନେ, କାଡ଼ୁମରଞ୍ଜି ଆମଙ୍‌ ରପ୍ତି ଗନିଜନ୍‌ ଆ ବର୍ନେ ବନର୍‌ବରନ୍‌ ଆସନ୍‌, ଆରି ବନବ୍‌ତଙନ୍‌ ଆଞ୍ରାଙ୍‌ତେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ତନାଣ୍ଡେବାନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ଆରି ପ୍ରବୁନ୍‌ ଆ ସନାୟୁମ୍‌ ବର୍ସେଙନ୍‌ ବନର୍‌ବରନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ବଇନ୍‌ ଏଡେଃଡାଲେ ବେରାନ୍‌ ଆସିଲୋଙ୍‌ ତିଆତେ ତିୟ୍‌ଲେ ତଙ୍କୁମେନ୍‌, ଆରି ରନୁକ୍କୁସିଙନ୍‌ ଆ ମନ୍‌ରାଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଆଙାଙ୍‌ଲେ ସେଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ, ଅଙ୍ଗାତେ ନମିଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଅମ୍‌ଡଙେନ୍‌ ତିଆତେ ଲଙେ ଡେଡମେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ଆରି, ଜିସୁନ୍‌ ଆ ତଅଡ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ସନାୟୁମ୍‌ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ସାନ୍ନିଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଜୋସେପନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ତଡ୍‌ ପଙ୍‌ ?” ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଆନିନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆଜାଡ଼ିନ୍‌ମା ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଆଓକ୍କାବର୍‌ ଏବର୍‌ତିଁୟ୍‌, ‘ଏ ବୌଡମର୍‌ ଆମନ୍‌ଡମ୍‌ ଆମ୍ମୁଙ୍‌ ମବ୍‌ନଙ୍‌ନା, କପର୍ନାଉମ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ଇନିଜି ଇନିଜି ଆମନ୍‌ ଲୁମେନ୍‌ ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌, ତିଆତେଜି ତେନ୍ନେ ନିୟ୍‌ ସାଇଲୋଙ୍‌ନମ୍‌ ଲୁମା,’ ଏଗାମ୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ଜିସୁନ୍‌ ବର୍ରନେ, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗାଜନଙ୍‌ ଆ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଆ ସାଇଡମନ୍‌ ଆ ମନ୍‌ରାଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଏଲିଅନ୍‌ ଆ ବନେଡ଼ାଇଂ ଅଙ୍ଗା ଆଡିଡ୍‌ ୟାଗି ବର୍ସେଙ୍‌ ତୁଡ୍ରୁ ଆଙ୍ଗାୟ୍‌ ଜାୟ୍‌ ତରୁବନ୍‌ ଅଃନ୍ନଡ଼ୋଲାଞନ୍‌, ସମ୍ପରା ଡେସାନ୍‌ କାନ୍ତାରାନ୍‌ ଡେଏନ୍‌, ତିଆଡିଡ୍‌ ଇସ୍ରାଏଲ୍‌ ଡେସାଲୋଙନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ଜୁଆର୍‌ବଜଞ୍ଜି ଡକୋଏଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ଜନଙ୍‌ଡେନ୍‌ ଏଲିଅନ୍‌, ଆନିଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ଏର୍‌ନାପ୍ପାୟନ୍‌, ସିଦୋନ୍‌ ଡେସାନ୍‌ ସାରିପତନ୍‌ ଅବୟ୍‌ ଜୁଆର୍‌ବଜନ୍‌ ଆମଙ୍‌ ତୁମ୍‌ ଅନାପ୍ପାୟନ୍‌ ଡେଲୋ । ");
INSERT INTO juy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ଆରି, ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଏଲିସାୟନ୍‌ ଆ ବନେଡ଼ାଇଂ ଇସ୍ରାଏଲ୍‌ ଡେସାଲୋଙନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ମୋଡ୍ଡୋମରଞ୍ଜି ଡକୋଏଞ୍ଜି; ଡେଲେ ଜନଙ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ମନବ୍‌ନଙନ୍‌ ଅଃଡ୍ଡେଲୋ, ସୁରିଆ ଡେସାବାୟ୍‌ ନାମାନନ୍‌ ତୁମ୍‌ ମନବ୍‌ନଙନ୍‌ ଡେଲୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ରନୁକ୍କୁସିଂଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅମ୍‌ଡଙ୍‌ଡାଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆକ୍ରାନ୍‌ ବରାବେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ମନ୍‌ରାଞ୍ଜି ଡୋଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙେଞ୍ଜି ଆରି ଆ ଗଡ଼ାଞ୍ଜି ଅଙ୍ଗା ବରୁଲୋଙ୍‌ ଡକୋଏନ୍‌, ତି ଆ ବରୁ ଆ ଗନେଡ଼େଙ୍‌ ସିଲଡ୍‌ ଜାୟ୍‌ତାନ୍‌ ରନୁମ୍ପେଲନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତୋଣ୍ଡୋ ବରୁନ୍‌ ଓରୋଙେଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆମଙ୍‌ଗଡଞ୍ଜି ତଙିୟ୍‌ଲନ୍‌ ଆନ୍ନାଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ଜିସୁନ୍‌ ଗାଲିଲିଲୋଙନ୍‌ କପର୍ନାଉମ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଗଡ଼ାନ୍‌ ଇୟେନ୍‌, ଆରି ତେତ୍ତେ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ, ");
INSERT INTO juy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ଆରି ଆନିଞ୍ଜି ଆ ଞନଙନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ସାନ୍ନି ଡେଏଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆ ବର୍ନେନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ବୟନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ଆରି ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ଅବୟ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରା ଡକୋଏନ୍‌; ଆନିନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ସଜିରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ଏ, ନାଜରିତବାୟ୍‌ ଜିସୁ, ଆମନ୍‌ ସରିନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଇନି ଡକୋ ? ଆମନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ସେଡନ୍‌ ଆସନ୍‌ ପଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ? ଆମନ୍‌ ଆନା, ତିଆତେ ଞେନ୍‌ ଜନା; ଆମନ୍‌ ତି ଇସ୍ୱରନ୍‌ ଆ ମଡ଼ିର୍‌ମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ଜିସୁନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ବବ୍‌ତଙ୍‌ଡାଲେ ବରେନ୍‌, “କଡ଼ିଙା, କେନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରା ।” ସିଲତ୍ତେ ତି ବୁତନ୍‌ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଅଃନ୍ନବ୍‌ପାରାଲେ ଆମୁକ୍କାଗଡଞ୍ଜି ଅମ୍‌ଗୋଙ୍‌ଡାଲେ ଆମଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ସିଲତ୍ତେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ସାନ୍ନିଡାଲେ ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ଇନି କେନ୍‌ ଆ ବର୍ନେ ? ଆନିନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ଡ ବୋର୍ସାନ୍‌ ବୟନ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜିଆଡଙ୍‌ ବାଁୟ୍‌ତଜି, ଆରି ଆନିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ତଜି !” ");
INSERT INTO juy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ସିଲତ୍ତେ ଆ ବର୍ନେନ୍‌ ସମ୍ପରାନ୍‌ ବୁର୍ବୁରାୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ଜିସୁନ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ସିଲଡ୍‌ ଡୋଲନ୍‌ ସିମନନ୍‌ ଆସିଂ ଇୟେନ୍‌ । ସିମନନ୍‌ ଆ କିନାର୍‌ ଆକ୍ରାନ୍‌ ଅସୁଏନ୍‌, ଆରି ଆନିଞ୍ଜି ଆନିନ୍‌ ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆମଙନ୍‌ ତନଙ୍‌ଡାଲେ ଅସୁନ୍‌ ବବ୍‌ତଙେନ୍‌, ଆରି ଆନିନ୍‌ ଆସୁନ୍‌ ତଡେନ୍‌, ସିଲତ୍ତେମା ଆନିନ୍‌ ଡୋଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ରୋଜୋମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ବରୁବ୍‌ୟୋଙ୍‌ ଇଙନ୍‌, ଆନାଜି ଆମଙ୍‌ ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ରୋଗମର୍‌ଜି ଡକୋଏଞ୍ଜି, ତି ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାଜି ଆରି ଆନିନ୍‌ ତଙ୍‌ବୟ୍‌ନେ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଆସିନ୍‌ ଡକ୍କୋଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ଆରି, ବୁତଞ୍ଜି ନିୟ୍‌ ସଜିର୍‌ଡାଲେ, “ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌” ଗାମ୍‌ଲେ ଜବ୍ର ମନ୍‌ରାଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି । ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବବ୍‌ତଙ୍‌ଡାଲେ ଅଃନ୍ନବ୍‌କଡାଡ଼ିଲଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆନିନ୍‌ କ୍ରିସ୍ଟ, ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଆଜନାଜି । ");
INSERT INTO juy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ଆସ୍ରାଆରେନ୍‌, ଜିସୁନ୍‌ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଅବୟ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଜିରେନ୍‌; ଆରି, ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସାୟ୍‌ଲେ ସାୟ୍‌ଲେ ଆମଙନ୍‌ ଇୟ୍‌ଲାଜି, ଆରି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଜିର୍‌ଡଙେ ତଡ୍‌, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ରଙ୍‌ରଙନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନ୍ନା ଆ ଗଡ଼ାରେଙ୍‌ ନିୟ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ମନଙ୍‌ବର୍‌ ଞେନ୍‌ ଇୟ୍‌ତେ ଅପ୍ପୁଙ୍‌ବର୍ନାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆସନ୍‌ ଗାମ୍‌ଲେ ଇସ୍ୱରନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ଆରି, ଜିସୁନ୍‌ ଜିଉଦା ଡେସାନ୍‌ ଆ ରନୁକ୍କୁସିଂରେଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେ । ");
INSERT INTO juy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଗିନ୍ନେସରତ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ତନଙ୍‌ଲେ ଡକୋଲନ୍‌, ତିଆଡିଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ମନଙ୍‌ବର୍‌ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ରୁମ୍ପେଲ୍‌ଲେ ତୁସେଲ ଆମଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ କୁଡ଼ାୟ୍‌ନେଜି; ");
INSERT INTO juy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ଆରି, ଆନିନ୍‌ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ବାଗୁ ଡୋଙ୍ଗାନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଗିଜେନ୍‌; ତି ଆ ଡୋଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଞମ୍‌ୟମରଞ୍ଜି ପଡ୍‌ଲନ୍‌ ଜାଲନ୍‌ ଗିୟ୍‌ଡାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ଜିସୁନ୍‌ ସିମନନ୍‌ ଆ ଡୋଙ୍ଗାଲୋଙ୍‌ ଡାୟ୍‌ଲେ ଆସର୍‌ଲଲୋଙନ୍‌ ସିଲଡ୍‌ ଡାସଙାୟ୍‌ ଅମ୍ମ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ସିମନନ୍‌ଆଡଙ୍‌ ବରେନ୍‌; ଆରି, ଜିସୁନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ଆରି ଜିସୁନ୍‌ ବର୍ନେନ୍‌ ଅବ୍‌ସୁଜ୍ଜେଏନ୍‌ କି ସିମନନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅୟନ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଜରୁଡମନ୍‌ ଆ ଡାଆରେଙ୍‌ ଜିର୍ରେ ଜାଲବେଞ୍ଜି ଇୟ୍‌ ସେଡ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ସିଲତ୍ତେ ସିମନନ୍‌ ଜାଲଙେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ତମ୍ପଗଲ୍‌ ଅୟନ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଏକାବ୍ବାଡ଼ାଲନାୟ୍‌, ଜନଙ୍‌ଡେନ୍‌ ଇନ୍ନିଙ୍‌ ଏଃଞାଙ୍‌ଲାୟ୍‌; ବନ୍‌ଡ ବର୍ନେନମ୍‌ ବାତ୍ତେ ଞେନ୍‌ ଜାଲନ୍‌ ସେଡ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ଆରି, ଆନିଞ୍ଜି ଜାଲନ୍‌ ଆସ୍ରେଡେଞ୍ଜି ଗୋଗୋୟ୍‌ଡମ୍‌ ଅୟନ୍‌ ଞାଙେଞ୍ଜି, ଆରି ଆ ଜାଲଞ୍ଜି ଅତଡ୍‌ରୟ୍‌ତେ ବନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଅୟନ୍‌ ଇସିଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌, ଆନ୍ନା ଡୋଙ୍ଗାଲୋଙନ୍‌ ଆଡ୍ରକୋଏଞ୍ଜି ଆ ଗଡ଼ିଞ୍ଜିଆଡଙ୍‌ ତାରିଆୟ୍‌ଲେ ଓଡ୍ଡେଏଞ୍ଜି । ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ବାଗୁନ୍‌ ଆ ଡୋଙ୍ଗାଲୋଙ୍‌ ଅୟନ୍‌ ଆବ୍ରବ୍‌ରିଜେଞ୍ଜି, ଡୋଙ୍ଗାଞ୍ଜି ଆତ୍ରବୁବ୍‌ତେନ୍‌ ଅନ୍ତମ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ବନ୍‌ଡ ସିମନ୍‌ ପିତ୍ରନ୍‌ କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ, ତୁଡ଼ୁମ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଲୋମ୍‌ଲେ ବର୍ରନେ, “ଏ ପ୍ରବୁ, ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ଜିରା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଅବୟ୍‌ ଇର୍ସେମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସିଲତ୍ତେ ଆନିଞ୍ଜି ଏତ୍ତେଲେ ଆ ଗୋଗୋୟ୍‌ ଅୟନ୍‌ ଞାଙେଞ୍ଜି ଡ, ତିଆତେ ଗିୟ୍‌ଲେ ସିମନନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ଆରି, ସିମନନ୍‌ ଆ ସାଙ୍ଗଜି, ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ବାଗୁନେ ଜାକୁବନ୍‌ ଡ ଜନନ୍‌ ଆନିଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେମା ସାନ୍ନି ଡେଏଞ୍ଜି । ଆରି, ଜିସୁନ୍‌ ସିମନନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ବତଙ୍‌ଡଙମ୍‌, ଲଙେ ସିଲଡ୍‌ ଆମନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ତାଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଡୋଙ୍ଗାଞ୍ଜି ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ପାଙ୍‌ଲେ ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଅବୟ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଆଡିଡ୍‌, ଗିୟ୍‌ବା, ଅବୟ୍‌ ମୋଡ୍ଡୋମରନ୍‌ ତେତ୍ତେ ଡକୋଏନ୍‌; ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ତୁଙ୍‌ରୁବ୍‌ବାଙ୍‌ଲନ୍‌ ଅବ୍‌ସେଃଡ୍ଡାଲନ୍‌ କାକୁର୍ତିଲନ୍‌ ବର୍ରନେ, “ଏ ପ୍ରବୁ, ଆମନ୍‌ ଲଡୟ୍‌ଲମ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ରପ୍ତି ମବ୍‌ଡ଼ିର୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ସିଲତ୍ତେ ଜିସୁନ୍‌ ତି ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ଆସିନ୍‌ ପାଙ୍‌ଲେ, ଆନିନ୍‌ଆଡଙ୍‌ ସୁଙେଡାଲେ ବର୍ରନେ, “ଞେନ୍‌ ଲଡୟ୍‌ତିଁୟ୍‌, ମଡ଼ିରମ୍‌ତୋ ।” ସିଲତ୍ତେମା ମୋଡ୍ଡୋନ୍‌ ତି ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ସଙାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ଆରି, ଜିସୁନ୍‌ ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ବାଁୟ୍‌ଲେ ବରେନ୍‌, “ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ବର୍‌ଡଙେ, ବନ୍‌ଡ ଜିରା ରାଓଡ଼ାନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ନବ୍‌ତୁୟ୍‌ଡମ୍‌ନା, ଆନିନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅଲ୍ଲେ ଗିଜମ୍‌ତୋ, ଆରି ଆମନ୍‌ ମନଙ୍‌ଲମ୍‌ ଗାମ୍‌ଲେ ଅଡ଼୍‌କୋଞ୍ଜି ଆମଙ୍‌ ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌, ମନଡ଼ିର୍‌ବେନ୍‌ ଆସନ୍‌ ମୋସାନ୍‌ ଅଙ୍ଗାତେ ବାଁୟ୍‌ଲବେନ୍‌ ଏତ୍ତେଲେ ଅନମଙନ୍‌ ଇୟ୍‌ ତିୟା ।” ");
INSERT INTO juy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ ବର୍ନେ ଆରି ଗୋଗୋୟ୍‌ ବୁର୍ବୁରାୟ୍‌ଲନେ, ଆରି ଜବ୍ର ମନ୍‌ରାଜି ଆ ବର୍ନେନ୍‌ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଡ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ରୋଗ ମନନଙନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି; ");
INSERT INTO juy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ବନ୍‌ଡ ଆନିନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଡକୋଡାଲନ୍‌ ପାର୍ତନାଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଞନଙନ୍‌ ତିୟେନ୍‌, ଆରି ଗାଲିଲି ଗଡ଼ାଲୋଙନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ସାଇଜି, ଆରି ଜିଉଦା ଡେସାନ୍‌ ଡ ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଆ ପାରୁସିଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ତେତ୍ତେ ଆତଙ୍କୁମ୍‌ଜି । ଆରି ରୋଗମରଞ୍ଜିଆଡଙ୍‌ ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ପ୍ରବୁନ୍‌ ଆ ବୋର୍ସା ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ଆରି ଗିୟ୍‌ବା, ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଅବୟ୍‌ କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ କଟଲୋଙନ୍‌ ବୋୟ୍‌ଲେ ପାଙ୍‌ଲାଜି କି ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍ମସିଙନ୍‌ ଓରୋଙ୍‌ଡାଲେ ଜିସୁନ୍‌ ଆ ମୁକ୍କାବା ତନମ୍ମିଜନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ବନ୍‌ଡ ମନ୍‌ରାଞ୍ଜି ତେତ୍ତେ ଆୟରେଡନ୍‌ ଡକୋଏଞ୍ଜି, ତିଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍ମନ୍‌ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ଅଃଞାଙ୍‌ଲଜି, ଆରି ଆନିଞ୍ଜି ତୋଣ୍ଡୋ ବିଲେଙନ୍‌ ଜିର୍ରେ, ବିଲେଙନ୍‌ ଗାୟ୍‌ଲେ ଅମ୍ପରା କଟନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜିସୁନ୍‌ ଆ ମୁକ୍କାବା ମଡ୍ଡିନ୍‌ ଅପ୍ପଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ଜିସୁନ୍‌, ତି ମନ୍‌ରାଞ୍ଜି ଆ ଡର୍ନେ ଗିୟ୍‌ଲେ ବର୍ରନେ, “ଏ ମନ୍‌ରା, ଅଡ଼୍‌କୋ ଇର୍ସେନମ୍‌ଜି ସିଲଡ୍‌ ଆମନ୍‌ କେମାନ୍‌ ଞାଙେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ତିଆସନ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ୟଗେବ୍ବର୍ରନ୍‌ ଏନ୍ନେଲେ ବର୍ନେନ୍‌ ଆସନ୍‌ ଉଲଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ତେ, କେନ୍‌ଆନିନ୍‌ ଆନା ? ଇସ୍ୱରନ୍‌ ତୁମ୍‌ ସିନା ଇର୍ସେନ୍‌ କେମାତେ ଆନା ଆରି ଇର୍ସେନ୍‌ କେମାଏ ?” ");
INSERT INTO juy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ ୟଗେବ୍ବରଞ୍ଜି ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ମନ୍ନଲୋଙ୍‌ ଇନିବା ଏୟଗେବ୍ବର୍ତନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘ଇର୍ସେନମ୍‌ ସିଲଡ୍‌ କେମାନ୍‌ ଞାଙେନ୍‌’ ଗାମ୍‌ଲେ ବନରନ୍‌ ଲିଆର୍‌, ଅଡ଼େ, ‘ଡୋନା, ତଙିୟ୍‌ନା’ ଗାମ୍‌ଲେ ବନରନ୍‌ ଲିଆର୍‌ ? ଅଙ୍ଗାତେ ଲିଆର୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ବନ୍‌ଡ ପୁର୍ତିଲୋଙନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଆମଙ୍‌ ଇର୍ସେନ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ସନୋଡ଼ାନେନ୍‌ ଡକୋ ଗାମ୍‌ଲେ, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି କେନ୍‌ଆତେ ରପ୍ତି ଏଜନାତେ, ତିଆସନ୍‌ ଆନିନ୍‌ କାନ୍ନିମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, ଡୋନା, କଟନମ୍‌ ପାଙ୍‌ଲେ ଅସିଂନମ୍‌ ଜିରା ।’” ");
INSERT INTO juy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ସିଲତ୍ତେ ଆନିନ୍‌ ତେରଙ୍‌ ଆତେମଡଞ୍ଜି ଡୋଲନ୍‌, ଅଙ୍ଗା କଟଲୋଙ୍‌ ଆନିନ୍‌ ଆଲୁଡ୍‌ଲୁଡ୍‌ ଡକୋଲନ୍‌, ତିଆତେ ପାଙ୍‌ଲେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେନ୍‌ଲେ ସେନ୍‌ଲେ ଆସିଙନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ସିଲତ୍ତେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ସାନ୍ନିଡାଲେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେନେଞ୍ଜି ଆରି ଆକ୍ରାନ୍‌ ବତଙ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “ଲଙେ ଇନ୍‌ଲେଞ୍ଜି ଅବୟ୍‌ ସରାନ୍ନିଡାନ୍‌ ଆ କାବ୍ବାଡ଼ା ଏଗିୟ୍‌ଲାୟ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଲେବି ଗାମ୍‌ଲେ ଅବୟ୍‌ ପାନୁବେଡ୍‌ମରନ୍‌ ପାନୁସିଂଲୋଙନ୍‌ ଆତଙ୍କୁମନ୍‌ ଇୟ୍‌ଲେ ଗିଜେ, ଆରି ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ସିଲତ୍ତେ ଲେବିନ୍‌ ଡୋଲନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ଆରି, ଲେବିନ୍‌, ଜିସୁନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ସୋଡ଼ା ବୁଜିନ୍‌ ଆସିଂଡମନ୍‌ ତୁବେନ୍‌, ଆରି ଗୋଗୋୟ୍‌ଡମ୍‌ ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଆନ୍ନାମରଞ୍ଜି ବୟନ୍‌ ମାୟ୍‌ଲନ୍‌ ବୁଜିନ୍‌ ଜୋମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ତିଆସନ୍‌ ପାରୁସିଞ୍ଜି ଡ ଆ ଡଡ଼ଞ୍ଜି ଆ ସାସ୍ତ୍ରିଜି ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜିଆଡଙ୍‌ ଡୋସେଡାଲେ ବର୍ରଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନିବା ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଇର୍ସେମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଏଗାଗାତନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ସୁକ୍କଡଅଙ୍‌ମରଞ୍ଜି ଆସନ୍‌ ବୌଡମରନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌, ବନ୍‌ଡ ଅସୁମରଞ୍ଜି ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ଞେନ୍‌ ଡରମ୍ମମରଞ୍ଜିଆଡଙ୍‌ ଅନୋଡ୍ଡେବାନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌, ଆର୍ପାୟ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନେନ୍‌ ଆସନ୍‌ ଇର୍ସେମରଞ୍ଜିଆଡଙ୍‌ ଅନୋଡ୍ଡେବାନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ବତରନ୍‌ କି ବତରନ୍‌ ଆନମ୍‌ତଞ୍ଜି ଆରି ପାର୍ତନାତଞ୍ଜି, ପାରୁସିଞ୍ଜି ଆ ଞଙ୍‌ନେମର୍‌ଜି ନିୟ୍‌ ଏତ୍ତେତଞ୍ଜି, ବନ୍‌ଡ ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ଜୋମ୍‌ତଜି ଗାତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “କନୁଆମରଞ୍ଜି ସରିନ୍‌ ବରନ୍‌ ଡକୋଏନ୍‌ ଆଡିଡ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଆନମନ୍‌ ଡକ୍କୋଲେ ଏରପ୍ତିତେ ପଙ୍‌ ? ଇଜ୍ଜା ଏତ୍ତେଗୋ ଅଃଡ୍ଡେଏ । ");
INSERT INTO juy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ବନ୍‌ଡ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ବରନ୍‌ଆଡଙ୍‌ ତବ୍‌ଲେ ଅନୋରୋଙନ୍‌ ଡେତେ, ତିଆଡିଡ୍‌ ଆନିଞ୍ଜି ଆନମ୍‌ତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ଜିସୁନ୍‌ ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ନିୟ୍‌ ବରେଞ୍ଜି, “ଆନ୍ନିଙ୍‌ଜା ରଙ୍‌ ସିନ୍‌ରିନ୍‌ ଆଲୁଡ୍‌କାବ୍‌ ତଡ୍‌ଲେ, ପାପୁର୍‌ ସିନ୍‌ରିଲୋଙନ୍‌ ଅଃବ୍ବଜେ; ବଜେନ୍‌ ଡେନ୍‌ ତି ରଙ୍‌ ସିନ୍‌ରିନ୍‌ ପାପୁର୍‌ ସିନ୍‌ରିନ୍‌ ପବ୍‌ତେତେ, ଆରି ରଙ୍‌ ସିନ୍‌ରିନ୍‌ ଆଲୁଡ୍‌କାବ୍‌ ନିୟ୍‌ ପାପୁରନ୍‌ ବୟନ୍‌ ଅଃମ୍ମାୟ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ଆରି, ଆନ୍ନିଙ୍‌ଜା ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ପାପୁର୍‌ ଉସାଲ୍‌ ମୁନାଲୋଙନ୍‌ ଅଃଡ୍ଡକ୍କୋଏ; ଡକ୍କୋଏନ୍‌ ଡେନ୍‌ ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ଉସାଲ୍‌ ମୁନାନ୍‌ ପବ୍‌ତଡ୍‌ଲେ ଅଲାତେ, ଆରି ଉସାଲ୍‌ ମୁନାନ୍‌ ମୋସ୍ସାତେ । ");
INSERT INTO juy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ଆର୍ପାୟ୍‌ ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ରଙ୍‌ ଉସାଲ୍‌ ମୁନାଲୋଙନ୍‌ ଡକ୍କୋତବୋ । ");
INSERT INTO juy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ଆରି, ଆନ୍ନିଙ୍‌ଜା ପାପୁର୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ଗାଲୋଙ୍‌ ଗାଲେ ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ଗାଗାନ୍‌ ଆସନ୍‌ ଅଃଲ୍ଲଡୟ୍‌ଡାଏ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଗାମ୍‌ତେ, ‘ପାପୁରନ୍‌ଆତେ ତ ମନଙ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ବମିୟ୍‌ତା ଜିସୁନ୍‌, ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଜନ୍‌ରୋମ୍‌ଆଲ୍‌ ଗଡ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌, ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଜନ୍‌ରୋମନ୍‌ ଆ ସିସା ତତ୍ତଡ୍‌ଲେ ଆସିଲୋଙଞ୍ଜି ଗସିଡ୍‌ଲେ ଜୋମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ବନ୍‌ଡ ଲାଙ୍‌ଲେଡ୍‌ ପାରୁସିଞ୍ଜି ବର୍ରଞ୍ଜି, “ଅଙ୍ଗାତେ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଏଲୁମ୍‌ଡଙ୍‌ ଗାମ୍‌ଲେ ମୋସାନ୍‌ ବନାଁୟ୍‌ବର୍‌ଲୋଙ୍‌ ଆଇଡିଡ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଇନିବା ଏଲୁମ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଦାଉଦନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ଆଡ୍ରୋଲଜେଞ୍ଜି ଆଡିଡ୍‌ ଆନିନ୍‌ ଇନି ଏଙ୍ଗାଲନ୍‌, ତିଆତେ ନିୟ୍‌ ପଙ୍‌ ଆମ୍ୱେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏପଡ଼େନେ ? ");
INSERT INTO juy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ଆରମଙ୍‌ତେଞ୍ଜି ଆ ରୁଟି ରାଓଡ଼ାଞ୍ଜି ତୁମ୍‌ ଜୋମ୍‌ତଜି, ଆନ୍ନିଙ୍‌ ଆରି ଅଃଜ୍ଜୋମେଜି ଗାମ୍‌ଲେ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ଏଙ୍ଗାଲେ ଦାଉଦନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ସରେବାସିଂ ଗନ୍‌ଲେ, ତି ଆ ରୁଟି ପାଙ୍‌ଲେ ଜୋମେନ୍‌ ଆରି ଆ ଗଡ଼ିଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ତିୟେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଆ ପ୍ରବୁ ।” ");
INSERT INTO juy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ଜିସୁନ୍‌ ଆରି ଅବୟ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ଗନ୍‌ଲେ ଞନଙନ୍‌ ତିୟେନ୍‌; ତେତ୍ତେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆର୍ଜଡ଼ୋମ୍‌ସିନ୍‌ ଆସର୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ଆରି, ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ଡୋସାନ୍‌ ଆସନ୍‌ ରୟଙନ୍‌ ଞାଙ୍‌ଲେ ରପ୍ତିଏଜି, ତିଆସନ୍‌ ଜିସୁନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ତେ ଜାଆରୋ, ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଡଲ୍‌ଡଲେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ବନ୍‌ଡ ଜିସୁନ୍‌, ଆମନ୍ନଲୋଙଞ୍ଜି ଆନିଃୟମ୍‌ ଜନଡାଲେ, ଅଙ୍ଗା ମନ୍‌ରା ଆସି ଆସର୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଡୋନା, ମଡ୍ଡିନ୍‌ ତନଙା ।” ଆରି, ଆନିନ୍‌ ଡୋଲନ୍‌ ତନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗାତେ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଆଇଡିଡ୍‌ ? ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ଅଡ଼େ ଏର୍‌ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ? ପରାନ୍ନାନ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ଆସନ୍‌ ଅଡ଼େ ପରାନ୍ନାନ୍‌ ଅନବ୍‌ସେଡନ୍‌ ଆସନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ଆରି, ଆନିନ୍‌ ଏର୍ରେ ଅଡ଼୍‌କୋଞ୍ଜି ଆମଙ୍‌ ଆଙାଙ୍‌ଡାଲେ ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ତେକ୍କେସିନା ।” ସିଲତ୍ତେ ତି ମନ୍‌ରାନ୍‌ ଆସିନ୍‌ ତେକ୍କେଏନ୍‌, ଆରି ଆସିନ୍‌ ମନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ବନ୍‌ଡ ଆନିଞ୍ଜି ବରାବନ୍‌ ବାତ୍ତେ ପସୋୟ୍‌ଲଗୋ ଡେଏଞ୍ଜି, ଆରି ଏଙ୍ଗାଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ରପ୍ତିବୋ ଗାମ୍‌ଲେ, ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ତି ଆ ଡିନ୍ନାରେଙ୍‌ ବମିୟ୍‌ତା ଜିସୁନ୍‌ ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ତୋଣ୍ଡୋ ବରୁନ୍‌ ଜିରେନ୍‌, ଆନିନ୍‌ ତେତ୍ତେ ତମ୍ପଗଲ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ପାର୍ତନାଲନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ଆସ୍ରାଆରେନ୍‌, ଆନିନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ, ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ବାରଜଣଞ୍ଜିଆଡଙ୍‌ ସେଡାଏନ୍‌; ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମର୍‌ଜି ଗାମ୍‌ଲେ ଅବ୍‌ଞୁମେଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ସିମନନ୍‌, ଆଞୁମନ୍‌ ପିତ୍ର ଗାମ୍‌ଲେ ଅବ୍‌ଞୁମେନ୍‌, ଆରି ଆ ବୋଞାଙନ୍‌ ଆନ୍ଦ୍ରିଅନ୍‌, ଜାକୁବନ୍‌, ଜନନ୍‌, ପିଲିପନ୍‌, ବାର୍ତଲମିନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମାତିଉନ୍‌, ତୋମାନ୍‌, ଆଲପିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜାକୁବନ୍‌, ସିମନନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଉୟୁବ୍‌ମର୍‌ ଗାମ୍‌ଲେ ଓଡ୍ଡେତଜି, ");
INSERT INTO juy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଜାକୁବନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିଉଦାନ୍‌ ଆରି ଇସ୍କାରିତ ଜିଉଦାନ୍‌, ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ଅବ୍‌ଞମ୍‌ଞମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ଆରି, ଜିସୁନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ବରୁନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଅବୟ୍‌ ମୋଡ଼ୋଁୟ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତନଙେଜି, ଆରି ଗୋଗୋୟ୍‌ଡମ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଡ ସମ୍ପରା ଜିଉଦା ରାଜ୍ୟନ୍‌, ଜିରୁସାଲମନ୍‌, ଆରି ଆନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ସୋରନ୍‌ ଡ ସିଦୋନନ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ବର୍ନେ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଡ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ରୋଗଜି ମନନଙନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାଜି, ଆରି ଆନାଜି ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜି ବାତ୍ତେ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେଏଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ଜିସୁନ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ଆରି, ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସନୁଙେନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ବୋର୍ସାନ୍‌ ଜିର୍ରେ ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ରେଙ୍‌ ଆଙାଙ୍‌ଡାଲେ ବର୍ରନେ, “ଆମ୍ୱେଞ୍ଜି ଡୋଲେୟ୍‌ମର୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ସନେନ୍‌ସେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆମ୍ୱେନ୍‌ଆତେ । ");
INSERT INTO juy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ନମି ଆମ୍ୱେଞ୍ଜି ଆଡୋଲେୟ୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ସନେନ୍‌ସେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ବୋଓତବେନ୍‌ । ନମି ଆମ୍ୱେଞ୍ଜି ଏୟେୟେଡାତନ୍‌, ଆମ୍ୱେଞ୍ଜି ସନେନ୍‌ସେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏକିୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“ମନ୍‌ରାଞ୍ଜି ଆଙ୍ଗା ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତବେଞ୍ଜି ଆରି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ଲତ୍ତେଙ୍‌ଲୋଙ୍‌ ଆନ୍ନାତବେଞ୍ଜି, ଆରି ନିଣ୍ଡୟ୍‌ଡାଲେ ଅଞୁମ୍‌ବେନ୍‌ ମନଙ୍‌ ତଡ୍‌ ଗାମ୍‌ଲେ ବାସ୍ସେତବେଞ୍ଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସନେନ୍‌ସେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ତିଆଡିନ୍ନା ସର୍ଡାଲନ୍‌ ତଙ୍‌ସେଙ୍‌ନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗିୟ୍‌ବା, ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆମ୍ୱେନ୍‌ ଆସନ୍‌ ବର୍ତନ୍ନାନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ଡକୋ; ଆରି, ଏତ୍ତେଲେମା ଆ ପୁର୍ବା ଜୋଜୋଞ୍ଜି ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଏମ୍ମେଏଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“ବନ୍‌ଡ ୟୋଙ୍‌, ଗମାଙ୍‌ମର୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ସୁକ୍କା ଏଞାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ନମି ଆମ୍ୱେଞ୍ଜି ଆବୋଓଜି, ୟୋଙ୍‌, ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଡୋଲେୟ୍‌ତବେନ୍‌ । ୟୋଙ୍‌, ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ନମି ଆମ୍ୱେଞ୍ଜି ଏକିୟ୍‌ତେ, ଆମ୍ୱେଞ୍ଜି ୟେୟେଡାନ୍‌ ଡ ଅନିଃୟମନ୍‌ ଡେତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“ଅଙ୍ଗା ଆଡିଡ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ମନଙ୍‌ ଗାମ୍‌ତବେଞ୍ଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ୟୋଙ୍‌, ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଏତ୍ତେଲେମା ଆ ପୁର୍ବା ଜୋଜୋଞ୍ଜି କଣ୍ଡାୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ବର୍ନେ ବର୍ରଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ବନ୍‌ଡ ଏରମ୍‌ଡଙ୍‌ତେନ୍‌ ଆ ମନ୍‌ରାଜି, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ବନେରାବେଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ବାଜି, ଆନାଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତବେଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ସୁକ୍କାବାଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ଆନାଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ସୟ୍‌ପତବେଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଆସିର୍ବାଦବାଜି; ଆନାଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଲ୍ଲଗନ୍‌ଡ୍ରୟ୍‌ ଏମ୍ମେତବେଞ୍ଜି, ଆନିଞ୍ଜି ଆସନ୍‌ ପାର୍ତନାନାବା । ");
INSERT INTO juy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ଆନ୍ନିଙ୍‌ ଅବୟ୍‌ନେ ଅବୟ୍‌ କୋତାୟ୍‌ତମ୍‌ଲୋଙ୍‌ବେନ୍‌ ତିଡ୍‌ଲବେନ୍‌ ଡେନ୍‌, ଆରି ଆନ୍ନା କୋତାୟ୍‌ତମ୍‌ ନିୟ୍‌ ଅବ୍‌ତୁୟ୍‌ବା; ଆରି, ଆନା ମାଟବେନ୍‌ ପାଙ୍‌ତେ, ଆନିନ୍‌ ଅଙ୍ଗିବେନ୍‌ ନିୟ୍‌ ପାଙେତୋ, ଆନିନ୍‌ ଏରଙ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ଆନା ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ବେଡ୍‌ତବେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ବା; ଆରି, ଆନା ଅନର୍ଜେବେନ୍‌ ପାଙ୍‌ତେ, ତିଆତେ ଆରି ଆନିନ୍‌ ଏବେଡ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଙ୍ଗାଲେ ଞଣ୍ଡ୍ରମ୍‌ଲେନ୍‌ତଜି ଗାମ୍‌ଲେ ଲଡୟ୍‌ତବେନ୍‌, ଏତ୍ତେଲେମା ଆନିଞ୍ଜିଆଡଙ୍‌ ଞଣ୍ଡ୍ରମ୍‌ବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ଆରି, ଆନାଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତବେଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ତୁମ୍‌ ଏଡୁଙ୍‌ୟମେଞ୍ଜି ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଇନି ଆ ସନାୟୁମ୍‌ ଏଞାଙ୍‌ତେ ? ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇର୍ସେମରଞ୍ଜି ନିୟ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆଡ୍ରୁଙ୍‌ୟମ୍‌ତେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତଜି ! ");
INSERT INTO juy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ଆରି, ଆନାଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ସୁକ୍କାତବେଞ୍ଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ତୁମ୍‌ ଆମ୍ୱେଞ୍ଜି ଏବ୍‌ସୁକ୍କାଏଞ୍ଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନି ଆ ସନାୟୁମ୍‌ ଏଞାଙ୍‌ତେ ? ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇର୍ସେମରଞ୍ଜି ନିୟ୍‌ ତିଆତେ ଲୁମ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ଆରି, ଆନାଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଏଞାଙ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏଆସାତନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ତୁମ୍‌ ରେୟାନ୍‌ ଏତିୟେଞ୍ଜି ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଇନି ଆ ସନାୟୁମ୍‌ ଏଞାଙ୍‌ତେ ? ଇର୍ସେମରଞ୍ଜି ନିୟ୍‌ ଡିୟ୍‌ତେ ମା ସୁଜ୍ଜାୟ୍‌ନେନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଇର୍ସେମରଞ୍ଜିଆଡଙ୍‌ ରେୟାନ୍‌ ତିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ବନ୍‌ଡ ବନେରାବେଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ବାଜି ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ସୁକ୍କାବାଜି, ଆରି ସୁଜ୍ଜାୟ୍‌ନେନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଏର୍‌ନାସାନେନ୍‌ ରେୟାନ୍‌ ତିୟ୍‌ବା; ଏତ୍ତେଲ୍‌ଡେନ୍‌ ବର୍ତନ୍ନାବେନ୍‌ ଗୋଗୋୟ୍‌ତେ ଆରି ଆମ୍ୱେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆ ପସିୟ୍‌ଜି ଡେତବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆଲ୍ଲେମରଞ୍ଜି ଡ ପେଲ୍ଲାମରଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ସାୟୁମ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ଆପେୟ୍‌ବେନ୍‌ ଏଙ୍ଗାଲେ ସନାୟୁମ୍‌ମର୍‌, ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଗୋ ସନାୟୁମ୍‌ମର୍‌ ଡେବା ।” ");
INSERT INTO juy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ଆରି, ଅବୟ୍‌ନେନ୍‌ଆଡଙ୍‌ ଏବ୍‌ପନ୍‌ସୁଆତିଡଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ପନ୍‌ସୁଆତିନ୍‌ ଅଃଡ୍ଡେଏ; ଏବ୍‌ଡୋସାଡଙେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ଡୋସାବେଞ୍ଜି । କେମାନ୍‌ ତିୟ୍‌ବାଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି କେମାନ୍‌ ଏଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ତିୟ୍‌ବାଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ; ଇସ୍ୱରନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ମାଡ଼ିଞନ୍‌ ବବ୍‌ରିୟ୍‌ଡାଲେ ତିଆତେ ଲଲ୍ଲଡ୍‌ଲେ, ଆଙ୍ଗସୋଲେ, ଡବ୍‌ଲାଲେ, ଜନିରାଲୋଙ୍‌ବେନ୍‌ ତିୟ୍‌ତବେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ଆ ତନରେଡ୍‌ଲୋଙ୍‌ ଏତରେଡ୍‌ତେ, ତି ଆ ତନରେଡ୍‌ଲୋଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଆରି ତରେଡ୍‌ଲେ ତନିୟନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ନିୟ୍‌ ବରେଞ୍ଜି, “କାଡ଼ୁମରନ୍‌ ଇନି କାଡ଼ୁମରନ୍‌ଆଡଙ୍‌ ତୁରିୟ୍‌ଲେ ରପ୍ତିଏ ପଙ୍‌ ? ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଇନି ବାଗୁଞ୍ଜି ଲୋଓଙ୍‌ଲୋଙନ୍‌ ଅଃଗଲୋଏଜି ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ ସିଲଡ୍‌ ଞଙ୍‌ନେମରନ୍‌ ତୋଣ୍ଡୋନ୍‌ ତଡ୍‌; ବନ୍‌ଡ ଅଡ଼୍‌କୋ ଞଙ୍‌ନେମରଞ୍ଜି ସତଙ୍‌ଡାଲେ, ଆ ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ ଅନ୍ତମ୍‌ ଡେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“ଆରି, ଇନିବା ବୋଞାଙ୍‌ନମ୍‌ ଆମଡ୍‌ଲୋଙ୍‌ ଆଗ୍ରସେମଡେନ୍‌ ଆ ଉମ୍ରି ଗିୟ୍‌ତେ, ବନ୍‌ଡ ଅଙ୍ଗା ଆଙ୍‌ସନିବ୍‌ ଅମଡ୍‌ଲୋଙ୍‌ନମ୍‌ ଡକୋ, ତିଆତେ ଗିୟ୍‌ଲେ ଅଃନ୍ନିୟମେ ? ");
INSERT INTO juy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ଆମନ୍‌ ଅମଡ୍‌ଲୋଙ୍‌ନମ୍‌ ଡକୋନ୍‌ ଆଙ୍‌ସନିବ୍‌ ଏର୍‌ଗନିଜନ୍‌, ‘ଏ ବୋଞାଙ୍‌, ୟାଆ, ଅମଡ୍‌ଲୋଙ୍‌ନମ୍‌ ଆ ଉମ୍ରି ତବ୍‌ତାୟ୍‌,’ ଗାମ୍‌ଲେ ଏଙ୍ଗାଡାଲେ ବୋଞାଙ୍‌ବେନ୍‌ଆଡଙ୍‌ ବର୍ରେ ରପ୍ତିତେ ? ଏ ଇସ୍କତ୍ତାମର୍‌, ଆମ୍ମୁଙ୍‌ ଅମଡ୍‌ଲୋଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ଆଙ୍‌ସନିବନ୍‌ ତବା, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ବୋଞାଙ୍‌ନମ୍‌ ଆମଡ୍‌ଲୋଙ୍‌ ଡକୋନ୍‌ ଆ ଉମ୍ରି ତବ୍‌ତବନ୍‌ ଆସନ୍‌ ମନଙ୍‌ ଗିୟ୍‌ଲେ ରପ୍ତିତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ମନଙ୍‌ ଅରାନୁବନ୍‌ ମନଙ୍‌ତଡନ୍‌ ଆଜ ଅଃନ୍ନଜଏ, ଆରି ମନଙ୍‌ତଡନ୍‌ ଆରାନୁବ୍‌ ମନଙ୍‌ ଜଅନ୍‌ ଅଃନ୍ନଜଏ । ");
INSERT INTO juy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଡ଼୍‌କୋ ଅରାନୁବନ୍‌ ଆଜନ୍‌ ଗିୟ୍‌ଲେ ଅମ୍ମଡ୍‌ତବୋ, ଅବ୍ବାନୁବନ୍‌ ସିଲଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଲୁଆଜନ୍‌ ଅଃର୍ରୋଡେଜି, ଆରି କିନ୍‌ରେଙ୍‌ଅବ୍ବାଙନ୍‌ ସିଲଡ୍‌ ଦ୍ରାକ୍ୟାଜନ୍‌ ଅଃର୍ରୋଡେଜି । ");
INSERT INTO juy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ମନଙ୍‌ମରନ୍‌ ମନଙ୍‌ ଡରକ୍କୋସିଂ ଆ ଉଗରନ୍‌ ସିଲଡ୍‌ ମନଙନ୍‌ଆତେଜି ଅମ୍‌ଡୁଙ୍‌ତାୟ୍‌, ଆରି ମନଙ୍‌ତଡନ୍‌ ଆ ମନ୍‌ରା ଏର୍‌ମନଙ୍‌ ଡରକ୍କୋସିଂ ଆ ଉଗରନ୍‌ ସିଲଡ୍‌ ଏର୍‌ମନଙନ୍‌ଆତେଜି ଅମ୍‌ଡୁଙ୍‌ତାୟ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଉଗରନ୍‌ ଆ ବରିୟ୍‌ଲୋଙ୍‌ ତଅଡନ୍‌ ବର୍ନେନ୍‌ ବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ଆରି, ଆମ୍ୱେଞ୍ଜି ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ‘ପ୍ରବୁ, ପ୍ରବୁ,’ ଗାମ୍‌ଲେ ଏଓଡ୍ଡେତିଁୟ୍‌, ବନ୍‌ଡ ବର୍ନେଞେନ୍‌ ଅନ୍ତମ୍‌ ଏଃଞଣ୍ଡ୍ରମ୍‌ନେ ? ");
INSERT INTO juy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ଆନା ଅମଙ୍‌ଞେନ୍‌ ଇୟ୍‌ଲେ ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ତିଆତେଜି ଞଣ୍ଡ୍ରମ୍‌ତନେ, ଆନିନ୍‌ ଆନା ଅନ୍ତମ୍‌, ତିଆତେ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ଆନିନ୍‌ ଏନ୍ନେଗୋ ଅବୟ୍‌ ଗୁସିଂମରନ୍‌ ଅନ୍ତମ୍‌, ଆନିନ୍‌ ଜରୁଡମ୍‌ ଅମ୍ମେଲେ ଗାୟ୍‌ଲେ, ତୋଣ୍ଡୋ ଅରେଙନ୍‌ ଜିମ୍ମିନ୍‌ ତମ୍ମିଜେନ୍‌; ଆରି, ରିଙ୍ଗେତିରନ୍‌ ଆରଡ଼ୋଲାଞନ୍‌, ସିନ୍‌ସାଡାନ୍‌ ତି ଆସିଂ ଆକ୍ରାନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତଙ୍‌ଞାଏ, ବନ୍‌ଡ ତିଆତେ ଅଃଗୋଙ୍‌ଲୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆତେ ମନଙ୍‌ଡମ୍‌ ଆଗୁଗୁ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ବନ୍‌ଡ ଆନା ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ତିଆତେ ଅଃଞଣ୍ଡ୍ରମ୍‌ନେ, ଆନିନ୍‌ ଜିମ୍ମିନ୍‌ ଏର୍‌ତନମ୍ମିଜନ୍‌ ତୋଣ୍ଡୋ ଲବନ୍‌ ଅସିଙନ୍‌ ଆଗ୍ରୁଏନ୍‌ ଆ ମନ୍‌ରା ଅନ୍ତମ୍‌ ଡେତେ, ତି ଆସିଂ ସିନ୍‌ସାଡାନ୍‌ ଆକ୍ରାନ୍‌ ଆତ୍ରଙ୍‌ଞାଏନ୍‌, ସିଲତ୍ତେମା ତିଆତେ ଗୋଙେନ୍‌ ଆରି ତି ଆନସେଡନ୍‌ ବରନ୍ତଙ୍‌ଡାନ୍‌ ଡେଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ଅବ୍‌ସୁଜ୍ଜେଡାଲେ କପର୍ନାଉମ୍‌ ଗଡ଼ାନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ତି ଆ ବନେଡ଼ା ଅବୟ୍‌ ରୋମିଅ ସୋଡ଼ା ସିପ୍ପାୟନ୍‌, ଆନିନ୍‌ ଅଙ୍ଗା କମ୍ୱାରିମର୍‌ଆଡଙ୍‌ ଗୋଗୋୟ୍‌ ଡୁଙ୍‌ୟମେନ୍‌, ତି ଆ କମ୍ୱାରିମର୍‌ ଆକ୍ରାନ୍‌ ଅସୁଡାଲେ ଆର୍ରବୁଏନ୍‌ ଅନ୍ତମ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ସୋଡ଼ା ସିପ୍ପାୟନ୍‌, ଜିସୁନ୍‌ ଆ ବର୍ନେ ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ ଆସିଂ ଇୟ୍‌ଲେ ଆ କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌, ଜିସୁନ୍‌ଆଡଙ୍‌ ଅନୋଡ୍ଡେବାନ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ଜିଉଦିଞ୍ଜି ଆ ପାପୁର୍‌ମର୍‌ଜିଆଡଙ୍‌ ବର୍ରେ ଜିସୁନ୍‌ ଆମଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ତୁଙ୍‌ଲାଜି କି ମାଡ୍ଡ କାକୁର୍ତିଡାଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଆମନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ କେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଲନୁମନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଜିଞ୍ଜିନ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଜାତିଲେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ ଆରି ଆନିନ୍‌ଡମ୍‌ ରନୁକ୍କୁସିଂଲେନ୍‌ ଗୁଲେ ତିୟ୍‌ଲଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଇୟେନ୍‌ । ଆନିନ୍‌ ଅସିଙନ୍‌ ଆ ଡାସଙାୟ୍‌ ଆତ୍ରୁଙେନ୍‌ ଆଡିଡ୍‌, ରୋମିଅ ସୋଡ଼ା ସିପ୍ପାୟନ୍‌, ଆ ଗଡ଼ିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ ଆମନ୍‌ ଆରି ବାଉଲ୍ଲିଡଙ୍‌ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ଅସିଂଞେନ୍‌ ଇୟ୍‌ତାୟ୍‌, ତିଆସନ୍‌ ଞେନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ତିଆସନ୍‌ ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ଅଃନ୍ନବ୍‌ଡିସୟ୍‌ଲାୟ୍‌; ବନ୍‌ଡ ଅଜିଡ୍‌ ବାଁୟ୍‌ଲେ ବର୍ନା, କମ୍ୱାରିମର୍‌ଞେନ୍‌ ମନଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଅବୟ୍‌ନେନ୍‌ ଆ ଜାୟ୍‌ତା ଡକୋଲନାୟ୍‌ ଜନଙ୍‌ଡେନ୍‌ ଜାୟ୍‌ତାଞେନ୍‌ ସିପ୍ପାୟଞ୍ଜି ଡକୋଜି; ଆରି ଞେନ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ‘ଜିରା’ ଗାମ୍‌ଲାୟ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଜିର୍ତେ; ଆନ୍ନାମର୍‌ଆଡଙ୍‌ ‘ଜିରାୟ୍‌’ ଗାମ୍‌ଲାୟ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଜିର୍ତାୟ୍‌; ଆରି, କମ୍ୱାରିମର୍‌ଞେନ୍‌ ‘କେନ୍‌ଆତେ ଲୁମା,’ ଗାମ୍‌ଲାୟ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ତିଆତେ ଲୁମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ଜିସୁନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ସାନ୍ନି ଡେଏନ୍‌, ଆରି ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଆନିନ୍‌ ଆସ୍ରଣ୍ଡୋଙେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ତି ମନ୍‌ରାନ୍‌ ଆ ବର୍ନେ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ରାଏଲଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଜନଙ୍‌ ଡିୟ୍‌ନେ ସୋଡ଼ା ଆ ଡର୍ନେ ଅଣ୍ଡ୍ରଙ୍‌ ଞାଙାୟ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ଆରି, ଆରାପ୍ପାୟ୍‌ଲନେନ୍‌ ଆ ମନ୍‌ରାଜି, ଅସିଙନ୍‌ ୟର୍ରନ୍‌ କମ୍ୱାରିମରନ୍‌ ଆମନଙ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ନାଇନ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଗଡ଼ାନ୍‌ ଇୟେନ୍‌, ଆରି ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଡ ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ଆନିନ୍‌ ଗଡ଼ାନ୍‌ ଆ ଗରନ୍ନେଲୋଙ୍‌ ଆତ୍ରୁଙେନ୍‌ ଆଡିଡ୍‌, ଗିୟ୍‌ବା, ମନ୍‌ରାଞ୍ଜି ଅବୟ୍‌ ଆରବୁମରନ୍‌ ବୋୟ୍‌ଲେ ଡୁଆରାନ୍‌ ପାଙ୍‌ଲାଜି, ତି ଆରବୁମରନ୍‌ ଆ ନନ ଆଜୁଆର୍‌, ଆରି ତି ଜୁଆର୍‌ବଜନ୍‌ ଆଅନ୍‌ ଆବୟନ୍‌ ବନ୍‌ ଡକୋଏନ୍‌; ଆରି, ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଗଡ଼ାନ୍‌ ଆ ମନ୍‌ରାଜି ଆନିନ୍‌ ସରିନ୍‌ ତେତ୍ତେ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ପ୍ରବୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ, ଆନିନ୍‌ ଆସନ୍‌ ଇର୍ସୋୟମ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ୟେଡଙେ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ଆରି, ଜିସୁନ୍‌ ତେତ୍ତେ ତୁୟାଜନ୍‌ ଜିର୍ରେ, ରାଣ୍ଡାଜାଙନ୍‌ ସୁଙେଏନ୍‌, ଆରି, ବଣ୍ଡ୍ରୋୟ୍‌ମରଞ୍ଜି ଆତ୍ରନଙେଞ୍ଜି, ଆନିନ୍‌ ବର୍ରନେ, “ଏ ବେଣ୍ଡିଆ ! ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, ଡୋନା ।” ");
INSERT INTO juy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ସିଲତ୍ତେ ଆରବୁମରନ୍‌ ଡୋଲନ୍‌ ତଙ୍କୁମେନ୍‌, ଆରି କଡାଡ଼ିଲନେ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆୟୋଙନ୍‌ ଆସିଲୋଙ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ସିଲତ୍ତେ ଅଡ଼୍‌କୋଞ୍ଜି ବତଙେଞ୍ଜି, ଆରି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେଙ୍କେଲେ ବର୍ରଞ୍ଜି, “ଅମଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ଅବୟ୍‌ ସୋଡ଼ା ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌ ଆରି ଇସ୍ୱରନ୍‌ ଆ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ଆରି, ଜିସୁନ୍‌ ଆ ବର୍ନେ ସମ୍ପରା ଜିଉଦା ଡେସାନ୍‌ ଡ ସମ୍ପରାରେଙନ୍‌ ବୁର୍ବୁରାୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ତିକ୍କି ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ସିଲତ୍ତେ ଜନନ୍‌, ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ବାଗୁନେ ଓଡ୍ଡେଡାଲେ, “ଅଙ୍ଗାମର୍‌ ଜିର୍ତାୟ୍‌, ତି ଆ ମନ୍‌ରା ଆମନ୍‌ ପଙ୍‌, ଅଡ଼େ ଇନ୍‌ଲେନ୍‌ ଆନ୍ନାମର୍‌ଆଡଙ୍‌ ଏଜଗେଆୟ୍‌ ?” ଗାମ୍‌ଲେ ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ବର୍ବରନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ତି ଆ ମନ୍‌ରାଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ତୁଙ୍‌ଲେ, ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେଜି, “ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ବର୍ରେ ଅମଙ୍‌ନମ୍‌ ଆପ୍ପାୟ୍‌ଲଲେନ୍‌, ଅଙ୍ଗାମର୍‌ ଜିର୍ତାୟ୍‌, ତି ଆ ମନ୍‌ରା ଆମନ୍‌ ପଙ୍‌, ଅଡ଼େ ଇନ୍‌ଲେନ୍‌ ଆନ୍ନାମର୍‌ଆଡଙ୍‌ ଏଜଗେଆୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ତି ଆ ବନେଡ଼ା ଜିସୁନ୍‌ ଜବ୍ର ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ରୋଗନ୍‌, ବମ୍ୱମ୍‌ନେନ୍‌, ଆରି ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ମବ୍‌ନଙେଞ୍ଜି, ଆରି ଜବ୍ର କାଡ଼ୁମରଞ୍ଜି ଗିୟ୍‌ଲେ ରପ୍ତିଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନିଜି ଇନିଜି ଏଗିଜେନ୍‌ ଆରି ଏଅମ୍‌ଡଙେନ୍‌, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ନବ୍‌ଜନାବା; କାଡ଼ୁମରଞ୍ଜି ଗିୟ୍‌ଲେ ରପ୍ତିତଜି, ସୋତ୍ତାମରଞ୍ଜି ତଙିୟ୍‌ଲନ୍‌ ରପ୍ତିତଜି, ମୋଡ୍ଡୋମରଞ୍ଜି ମଡ଼ିର୍‌ତଜି, କାଲାମରଞ୍ଜି ଅମ୍‌ଡଙ୍‌ଲେ ରପ୍ତିତଜି, ଆରବୁମରଞ୍ଜି ଡୋତଞ୍ଜି, ଡୋଲେୟ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙନ୍‌ ଡେତେ; ");
INSERT INTO juy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ଆରି, ଅଙ୍ଗା ମନ୍‌ରା ଞେନ୍‌ଆଡଙ୍‌ ଅଃଡ୍ଡାଲ୍‌ଗଡିଁୟ୍‌ ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆଜିର୍ରେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଜିସୁନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆ ବର୍ନେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବନରନ୍‌ ଆସନ୍‌ ଉଲନେ, “ଆମ୍ୱେଞ୍ଜି ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଇନି ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଏଜିରେନ୍‌ ? ଇନି ରିଙ୍ଗେନ୍‌ ବାତ୍ତେ ଆମ୍ରୋମୋଲତନେନ୍‌ ଅବୟ୍‌ ଡାଆଜିଙନ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ତିଆତେ ତଡ୍‌ ଡେନ୍‌ ଇନି ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଏଜିରେନ୍‌ ? ଇନି ମନଙ୍‌ଡମ୍‌ ଆ ସିନ୍‌ରି ଆରନେନ୍‌ ଆ ମନ୍‌ରା ପଙ୍‌ ? ଗିୟ୍‌ବା, ଆନାଜି ମଡ଼ଗାଡମନ୍‌ ଆ ସିନ୍‌ରି ରଲନ୍‌ ଏରାମ୍ମୁୟ୍‌ ଡକୋତଞ୍ଜି, ଆନିଞ୍ଜି ରାଜାସିଂଲୋଙନ୍‌ ଡକୋତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ଞେନ୍‌ ବରିଁୟ୍‌ବା, ତିଆତେ ତଡ୍‌ ଡେନ୍‌ ଇନି ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଏଜିରେନ୍‌ ? ଇନି ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ପଙ୍‌ ? ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ସିଲଡ୍‌ ଆରି ଗୋଗୋୟ୍‌ ସତଙ୍‌ମରନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ଆ ବର୍ନେନ୍‌ ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଏନ୍ନେଲେ ଆଇଡିଡ୍‌, ଇସ୍ୱରନ୍‌ ବର୍ରନେ, ‘ଗିୟ୍‌ବା, ଞେନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ଞେନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ନମ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌, ଆନିନ୍‌ ମୁକ୍କାଗଡ୍‌ନମ୍‌ ଆମନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ଅବ୍‌ଜାଡାତେ,’ ତି ଆ ମନ୍‌ରା କେନ୍‌ଆନିନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆଇମରଞ୍ଜି ଆ କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଜନମ୍ମୁ ଆଡ୍ରେଏଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାଲୋଙଞ୍ଜି, ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ସୋଡ଼ା ତଡ୍‌; ଜନଙ୍‌ଡେନ୍‌ ଆନା ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ସନ୍ନାଡମ୍‌, ଆନିନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ।” ");
INSERT INTO juy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆମଙ୍‌ ତବ୍ବୁବ୍‌ଡାଲଞ୍ଜି, ଏତ୍ତେଲେ ଡ ପାନୁବେଡ୍‌ମରଞ୍ଜି ନିୟ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ଆଞ୍ରାଙେଞ୍ଜି, ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଗାମ୍‌ଲେ ଜାଏଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ବନ୍‌ଡ ପାରୁସିଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଏର୍‌ତବ୍ବୁବ୍‌ଡାନେନ୍‌ ଆନିଞ୍ଜିଡମ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ସନେଙ୍‌ସେଙ୍‌ ବାସ୍ସେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ଜିସୁନ୍‌ ଆରି ବର୍ରନେ, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆନା ସରିନ୍‌ ନମିଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଜଙାଜି, ଆରି ଆନିଞ୍ଜି ଆନା ଅନ୍ତମ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ଅଙ୍ଗା ପସିୟ୍‌ଜି ସରେଁୟ୍‌ତାରେଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ତର୍ଡମ୍‌ ଅଲ୍‌ନୋଡ୍ଡେଲେ ବର୍ତଞ୍ଜି, ‘ଇନ୍‌ଲେଞ୍ଜି ଅମଙ୍‌ବେନ୍‌ ପିରୋଡ଼ୋଜନ୍‌ ଏପେଡ୍‌ଲାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଏଃତ୍ତଙ୍‌ଲୋ; ଇନ୍‌ଲେଞ୍ଜି ରନବୁ କନନ୍‌ ଏକନ୍‌ଲାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଏଃୟେଲୋ’ ଗାମ୍‌ତଜି, ଆନିଞ୍ଜି ତି ଆ ପସିୟ୍‌ଜି ଅନ୍ତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଇୟ୍‌ଲେ ରୁଟିନ୍‌ ଅଃଜ୍ଜୋମ୍‌ଲୋ କି ଦ୍ରାକ୍ୟାଡାନ୍‌ ଅଃଗାଲୋ, ଆରି ଆମ୍ୱେଞ୍ଜି ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ଆଡଙ୍‌ ‘ବୁତନ୍‌ ଆସୁମ୍‌ସୁମ୍‌’ ଏଗାମ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଜିର୍ରେ ଇୟ୍‌ତାୟ୍‌ ଗାଗାନେ, ଜୋମ୍‌ଜୋମ୍‌ନେ, ଆରି ଆମ୍ୱେଞ୍ଜି ଏବର୍ତନେ, ‘ଗିୟ୍‌ବା, କେନ୍‌ଆନିନ୍‌ ଅବୟ୍‌ ଲୋବଜୋମ୍‌ମର୍‌ ଆରି ଗାସାଲ୍‌ମର୍‌, ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଇର୍ସେମରଞ୍ଜି ଆ ଗଡ଼ି !’ ");
INSERT INTO juy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ବନ୍‌ଡ ଜନନାନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ପସିଜଞ୍ଜି ବାତ୍ତେ ଆଜାଡ଼ିନ୍‌ମା ଗାମ୍‌ଲେ ଗିୟ୍‌ତାଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ଆରି ପାରୁସିଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ, ଜିସୁନ୍‌ ସରିନ୍‌ ଗାଗାନେନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଲାୟ୍‌ । ସିଲତ୍ତେ ଆନିନ୍‌ ପାରୁସିନ୍‌ ଆସିଂ ଜିର୍ରେ ଇୟ୍‌ଲେ ଗାଗାନେ । ");
INSERT INTO juy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ଆରି ଗିୟ୍‌ବା, ତି ଆ ଗଡ଼ାଲୋଙ୍‌ ଅବୟ୍‌ ଇର୍ସେବଜନ୍‌ ଡକୋଏନ୍‌; ଜିସୁନ୍‌ ପାରୁସିନ୍‌ ଆସିଂ ଅତ୍ତେ ଗାଗାତନେ ଗାମ୍‌ଲେ, ଆଜ୍ରନାଏନ୍‌ ତି ଆଇମରନ୍‌ ଅବୟ୍‌ କୋମ୍ପାଲୋଙନ୍‌ ଲଙିଡ୍‌ ମିଞଲନ୍‌ ପାଙ୍‌ଲେ, ");
INSERT INTO juy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ଜିସୁନ୍‌ ଆ କଣ୍ଡୋଙ୍‌ଗଡ୍‌ ଜିର୍ରେ ଆ ତାଲ୍‌ଜଙନ୍‌ ଆ ତୁୟାୟ୍‌ ତନଙ୍‌ଡାଲେ ୟେଲେ ୟେଲେ ଆମଡ୍ଡାନ୍‌ ବାତ୍ତେ ଜିସୁନ୍‌ ଆ ତାଲ୍‌ଜଙ୍‌ ଅବ୍‌ନୋଡ୍ଡାଏନ୍‌ କି ଆବବ୍‌ଲୋଙନ୍‌ ଆ ଉଉ ବାତ୍ତେ ଗଗଡେନ୍‌, ଆରି ଆ ତାଲ୍‌ଜଙନ୍‌ ଜୋର୍ଜୋର୍‌ଡାଲେ ଲଙିଡ୍‌ ମିଞଲନ୍‌ ଜଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ, ଅଙ୍ଗା ପାରୁସି ଜିସୁନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଏନ୍‌, ଆନିନ୍‌ ବର୍‌ଡମ୍‌ଲନ୍‌, “କେନ୍‌ଆନିନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆନା ସୁଙେତେ, ଆନିନ୍‌ ଆନା ଆରି ଏଙ୍ଗାଗୋ ଆଇବୟ୍‌, କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମ୍‌, ଆନିନ୍‌ ଅବୟ୍‌ ଇର୍ସେବୟ୍‌, କେନ୍‌ଆତେ ଆନିନ୍‌ ରପ୍ତି ଜନାତେ ବନ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ସିମନ୍‌, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ବର୍ନେନ୍‌ ବର୍ତମ୍‌ ।” ଆନିନ୍‌ ଗାମେନ୍‌, “ଞନଙ୍‌ତିୟ୍‌ମର୍‌ ବରିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“ଅବୟ୍‌ ସାଉନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ମନ୍‌ରା ଆମଙ୍‌ ସିଲଡ୍‌ ବାଗୁ ମନ୍‌ରା ସାଉନ୍‌ ପାଙେଞ୍ଜି; ଅବୟ୍‌ନେ ମନ୍‌ଲୟ୍‌ସ ଆରି ଅବୟ୍‌ନେ ପଚାସ ଡିନାରି ରେୟାନ୍‌ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ସୁଜ୍ଜାୟ୍‌ନେନ୍‌ ଆସନ୍‌ ଆମଙଞ୍ଜି ଇନ୍ନିଙ୍‌ତଡନ୍‌ ଆସନ୍‌ ସାଉନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ମନ୍‌ରା ବାଗୁଞ୍ଜି ଆ ସାଉ ଅମ୍‌ରେଙେନ୍‌ । ତିଆସନ୍‌ ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଆନା ସାଉନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ଗୋଗୋୟ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ସିମନନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଅବ୍‌ଡିସୟ୍‌ତାୟ୍‌, ସାଉନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ମନ୍‌ରା ଆନା ଆ ସାଉ ଗୋଗୋୟ୍‌ ଅମ୍‌ରେଙେନ୍‌, ଆନିନ୍‌ ।” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ରନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ଆରି ଜିସୁନ୍‌, ତି ଆଇମରନ୍‌ ଆମଙ୍‌ବା ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ସିମନନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କେନ୍‌ ଆଇମରନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ତେ ପଙ୍‌ ? ଞେନ୍‌ ଅସିଂନମ୍‌ ଇୟ୍‌ଲାୟ୍‌, ଆମନ୍‌ ତାଲ୍‌ଜଙ୍‌ଞେନ୍‌ ଆସନ୍‌ ଡାଆନ୍‌ ଅଃତ୍ତିୟ୍‌ଲିଁୟ୍‌, ବନ୍‌ଡ କେନ୍‌ଆନିନ୍‌ ଆମଡ୍ଡାନ୍‌ ବାତ୍ତେ ତାଲ୍‌ଜଙ୍‌ଞେନ୍‌ ଅବ୍‌ନୋଡ୍ଡାଲେ ଆବବ୍‌ଲୋଙନ୍‌ ଆ ଉଉ ବାତ୍ତେ ଗଡ୍‌ଗଡ୍‌ଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଃଡ୍ଡୋଗଡ୍‌ଲିଁୟ୍‌, ଅଃଜ୍ଜୋର୍‌ଜୋରିଁୟ୍‌, ବନ୍‌ଡ ଞେନ୍‌ ଅମ୍ମନ୍‌ ଗରନ୍‌ଲନାଞନ୍‌ ସିଲଡ୍‌ କେନ୍‌ଆନିନ୍‌ ତାଲ୍‌ଜଙ୍‌ଞେନ୍‌ ଆ ଜନୋର୍ଜୋର୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଅମ୍‌ରେଙେ । ");
INSERT INTO juy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ଆମନ୍‌ ଅବବ୍‌ଲୋଙ୍‌ଞେନ୍‌ ମିଞଲନ୍‌ ଅଃଜ୍ଜଡ୍‌ଲିଁୟ୍‌, ବନ୍‌ଡ କେନ୍‌ଆନିନ୍‌ ତାଲ୍‌ଜଙ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଲଙିଡ୍‌ ମିଞଲନ୍‌ ଜଡ୍‌ଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ତିଆସନ୍‌ ଞେନ୍‌ ଗାମ୍‌ତାୟ୍‌, ଗୋଗୋୟ୍‌ଡମ୍‌ କେନ୍‌ ଆ ଇର୍ସେନ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଡେଏନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଗୋଗୋୟ୍‌ ଡୁଙ୍‌ୟମ୍‌ଲିଁୟ୍‌; ବନ୍‌ଡ ଆନାଆଡଙ୍‌ ଅସୋୟ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଡେତେ, ଆନିନ୍‌ ଅସୋୟ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ଆରି, ଜିସୁନ୍‌ ତି ଆଇମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଇର୍ସେନମ୍‌ଜି ଅଡ଼୍‌କୋନ୍‌ କେମାନ୍‌ ଞାଙେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ସିଲତ୍ତେ ଆନିନ୍‌ ସରିନ୍‌ ଆଗ୍ରାଗାଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଇର୍ସେ ଜନଙ୍‌ କେମାତେ, କେନ୍‌ଆନିନ୍‌ ଆନା ?” ");
INSERT INTO juy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ବନ୍‌ଡ ଜିସୁନ୍‌ ତି ଆଇମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଡର୍ନେନମ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଡୋବ୍‌ଲମ୍‌; ମା, ଲବିଡ୍ଡା ଜିରା ।” ");
INSERT INTO juy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଗଡ଼ାରେଙନ୍‌ ଡ ସାଇରେଙନ୍‌ ଜିର୍ରେ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ମନଙ୍‌ବର୍‌ ଅପ୍ପୁଙ୍‌ବର୍ରେ ପାଙେନ୍‌, ଆରି ବାରଜଣ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ଆରି ଅଙ୍ଗା ଆଇମର୍‌ଜି ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡ ରୋଗନ୍‌ ସିଲଡ୍‌ ମନଙେଞ୍ଜି, ଏତ୍ତେଗନ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ଆଇମରଞ୍ଜି ନିୟ୍‌ ଡକୋଏଞ୍ଜି, ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌, ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌, ଆମଙନ୍‌ ସିଲଡ୍‌ ସାତଟା ବୁତନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆନିନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ଏରୋଦନ୍‌ ଆ ଗୁମୁସ୍ତା ଆଡ୍ରକୋଲନେନ୍‌ କୁଜା ଆଞୁମ୍‌ମର୍‌ ଆ ଡୁକ୍ରି ଜୋଆନାନ୍‌, ସୋସନ୍ନାନ୍‌ ଆରି ଗୋଗୋୟ୍‌ଡମ୍‌ ଆଇମରଞ୍ଜି ଆନିଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆନର୍ଜେଜି ତିୟ୍‌ଲେ ଜିସୁନ୍‌ ଡ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ସାଜଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆକ୍ରୁଡ଼ାୟ୍‌ଲଞ୍ଜି ଡ ଗଡ଼ାରେଙଞ୍ଜି ସିଲଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଆଜିର୍ରାଞଞ୍ଜି, ଆନିନ୍‌ କେନ୍‌ ଆନବ୍‌ଜଙ୍‌ବର୍‌ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ଅବୟ୍‌ ବୁବ୍ବୁଡ୍‌ନେମରନ୍‌ ଜମ୍ମଲନ୍‌ ବୁବ୍ବୁଡନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନେ । ଆନିନ୍‌ ବୁଡାନ୍‌ ବୁଡାନ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ଜମ୍ମଲନ୍‌ ତଙର୍‌ରେଙନ୍‌ ଗଲୋଏନ୍‌ ଆରି ତିଆତେଜି ଞାଡାଆୟ୍‌ଲନେ, ଆରି ରୁଆଙନ୍‌ ଆ ଅନ୍ତିଡଞ୍ଜି ତିଆତେଜି ଜୋମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଜମ୍ମଲନ୍‌, ଅରେଙ୍‌ଲଲୋଙନ୍‌ ଗଲୋଏନ୍‌, ତିଆତେଜି ପଡାବେନ୍‌ ବନ୍‌ଡ ଡାଆନ୍‌ ଅଃଞାଙ୍‌ଲନ୍‌ ଅସରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଜମ୍ମଲନ୍‌ ଅବ୍ବାଙ୍‌ନୁବ୍‌ରେଙନ୍‌ ଗଲୋଏନ୍‌, ଆରି ଅବ୍ବାନୁବଞ୍ଜି ଜନ୍‌ରୋମନ୍‌ ବୟନ୍‌ ସୋଡ଼ାଡାଲେ ତି ଆ ତୋଣ୍ଡୋନ୍‌ ଲାମାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଜମ୍ମଲନ୍‌ ମନଙ୍‌ ଲବରେଙନ୍‌ ଗଲୋଏନ୍‌, ତିଆତେଜି ପଡାବ୍‌ଲେ ସୋଡ଼ାଡାଲେ ସଏ ଗୁନା ଅଜଏନ୍‌ ।” ଜିସୁନ୍‌ କେନ୍‌ଆତେ ବର୍ରନ୍‌ ବର୍ରନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଆନା ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଅଲୁଡନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅମ୍‌ଡଙେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି କେନ୍‌ ଅନବ୍‌ଜଙ୍‌ବର୍‌ ଆଗ୍ରାମ୍‌ଗାମ୍‌ ଇନି ଗାମ୍‌ଲେ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ସିଲତ୍ତେ ଜିସୁନ୍‌ ବର୍ରନେ, “ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ସନସବର୍‌ଜି ରପ୍ତି ଗନ୍‌ଲୁଡନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଜନନାନ୍‌ ଆତିୟ୍‌ତିୟ୍‌, ବନ୍‌ଡ ଆନ୍ନାମରଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ବନରନ୍‌ ଡେତେ, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଗିଜାନ୍‌ ଗିଜାନ୍‌ ଅଃଗିଜେଜି ଆରି ଅମ୍‌ଡଙାନ୍‌ ଅମ୍‌ଡଙାନ୍‌ ଅଃଗନ୍‌ଲୁଡେଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଆଗ୍ରାମ୍‌ଗାମ୍‌ କେନ୍‌ଆତେ, ଜମ୍ମଲନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ, ");
INSERT INTO juy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ଆରି ଅନେଙ୍‌ ତଙରନ୍‌ ଆ ଜମ୍ମଲ୍‌, କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ମନ୍‌ରାଜି, ଆନିଞ୍ଜି ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି; ଆରି ତିକ୍କି ସନୁମନ୍‌ ଜିର୍ରେ, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଡର୍ରନ୍‌ ଅନୁରନ୍‌ ଅଃଞାଙେଜି, ତିଆସନ୍‌ ଆ ଉଗର୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ବର୍ନେନ୍‌ ରାଉଡାଲନ୍‌ ପାଙ୍‌ଲେ ଜିର୍ତେ । ");
INSERT INTO juy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ଆରି ଅରେଙ୍‌ଲଲୋଙନ୍‌ ଆ ଜମ୍ମଲ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ମନ୍‌ରାଜି, ଆନିଞ୍ଜି ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ସର୍ଡାନ୍‌ ବାତ୍ତେ ଜାତଜି; ବନ୍‌ଡ ଆଜଡଞ୍ଜି ଗୋଗୋୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଆଜଡ୍‌ନେନ୍‌, ଆନିଞ୍ଜି ବସନ୍ନେଃ ମତ୍ରମ୍‌ ଡର୍ତଞ୍ଜି ଆରି ମନାଲ୍‌ମାଲନ୍‌ ଜିର୍ରାୟ୍‌ ଡେନ୍‌ ଆନିଞ୍ଜି ଅସେଡ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ଆରି, ଅବ୍ବାଙ୍‌ନୁବ୍‌ରେଙନ୍‌ ଆଗ୍ରଲୋଏନ୍‌ ଆ ଜମ୍ମଲ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ମନ୍‌ରାଜି, ଆନିଞ୍ଜି ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଅନମେଙନ୍‌ ଆନିଃୟମ୍‌, ରନ୍ନାନ୍‌ ଆରି ଗାଲେ ଜୋମ୍‌ଲେ ଏରାମ୍ମୁୟ୍‌ ଆ ଡକୋନେଲୋଙ୍‌ ଆନିଞ୍ଜି ଲଲ୍ଲଡାୟ୍‌ତଞ୍ଜି, ଆରି ସୋଡ଼ାଡାଲେ ଅଃନ୍ନଜଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ଆରି, ମନଙ୍‌ ଲବଲୋଙନ୍‌ ଆଗ୍ରଲୋଏନ୍‌ ଆ ଜମ୍ମଲ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ମନ୍‌ରାଜି, ଆନିଞ୍ଜି ମନଙ୍‌ ଆରି ଲଗଡ଼ ଉଗରନ୍‌ ବାତ୍ତେ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ତିଆତେ ଞମ୍‌ଲେ ଡକ୍କୋତଜି ଆରି ଏର୍‌କିକ୍କିଡ୍‌ନେନ୍‌ ଡକୋଡାଲନ୍‌ ଅଜତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ଆନ୍ନିଙ୍‌ଜା ପିଙ୍କନ୍‌ ତର୍ରେ ତିଆତେ ସିମ୍ମାନ୍‌ ବାତ୍ତେ ରୁବ୍‌ଲେ ଅଃଡ୍ଡକ୍କୋଏ, କି କଟନ୍‌ ଆ ଜାୟ୍‌ତା ଅଃଡ୍ଡକ୍କୋଏ, ବନ୍‌ଡ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅମ୍ମନ୍‌ ଆଗ୍ରନ୍‌ତାଞଞ୍ଜି ଆ ମନ୍‌ରାଜି ସାଆରନ୍‌ ଗିୟ୍‌ଲେ ରପ୍ତିତଜି, ତିଆସନ୍‌ ପିଙ୍କପିଲନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଡକ୍କୋତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାତେ ଅଃଗିୟ୍‌ତାଏ, ଏତ୍ତେଗୋ ଆ ସନସବର୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌, ଆରି ଅଙ୍ଗାତେ ଜନାଡାଲେ ଅଃଗିୟ୍‌ତାଏ, ଏତ୍ତେଗୋ ଆ ସନସବର୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“ତିଆସନ୍‌ ଏଙ୍ଗାଲେ ଏଅମ୍‌ଡଙ୍‌ତେ, ତି ଆ ବର୍ନେଲୋଙ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ଆମଙ୍‌ ଡକୋ ଆନିନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ, ଆରି ଆନା ଆମଙ୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌, ଆନିନ୍‌ ଅଙ୍ଗାତେ ଞେନ୍‌ଡମ୍‌ଆତେ ଡକୋ ଗାମ୍‌ତେ, ତିଆତେ ନିୟ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ପନାଙନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ଜିସୁନ୍‌ ଆ ବୋଞାଙ୍‌ଜି ଡ ଆୟୋଙନ୍‌ ଆମଙନ୍‌ ଇୟ୍‌ଲାଜି, ବନ୍‌ଡ ମନ୍‌ରାଞ୍ଜି ଆୟରେଡନ୍‌ ଡକୋଏଞ୍ଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","“ନନନମ୍‌ ଡ ବୋଞାଙ୍‌ନମ୍‌ଜି ଆମନ୍‌ ସରିନ୍‌ ମାୟ୍‌ନେନ୍‌ ଆସନ୍‌ ଡାଣ୍ଡନ୍‌ ଆତନଙ୍‌ଜି” ଗାମ୍‌ଲେ ଅବୟ୍‌ନେ, ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେ । ");
INSERT INTO juy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆନାଜି ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ତଜି ଆରି ତିଆତେ ଞଣ୍ଡ୍ରମ୍‌ତଞ୍ଜି, ଆନିଞ୍ଜି ଅୟୋଙ୍‌ଞେନ୍‌ ଡ ବୋଞାଙ୍‌ଞେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଅବୟ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାଜେଞ୍ଜି, ଆରି ଆନିନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ୟବା, ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଏଜିର୍ବା ।” ସିଲତ୍ତେ ଆନିଞ୍ଜି ଡୋଙ୍ଗାନ୍‌ ଉଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ବନ୍‌ଡ ଆନିଞ୍ଜି ଡୋଙ୍ଗାନ୍‌ ସଲ୍ଲାୟ୍‌ଲେ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଲୁଡେନ୍‌ । ତିଆଡିଡ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ରିଙ୍ଗେତିରନ୍‌ ଅଡ଼ୋଲାୟ୍‌, ଆରି ଆ ଡୋଙ୍ଗାଲୋଙଞ୍ଜି ଡାଆନ୍‌ ବରିୟ୍‌ଲେ ପାଙେନ୍‌, ଆରି ଆନିଞ୍ଜି ବରନ୍ତଙ୍‌ଲୋଙନ୍‌ ଗଲୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ତର୍ତର୍‌ଡାଲେ, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ପତୁଲ୍‌ଡାଲଲେନ୍‌,” ଗାମ୍‌ଲେ ଇୟ୍‌ଲେ ବରେଜି । ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଡୋଲନ୍‌ ରିଙ୍ଗେନ୍‌ ଡ ଅଡ୍ଡୋୟ୍‌ଡାନ୍‌ ବବ୍‌ତଙେନ୍‌, ଆରି ତି ଅଡ଼୍‌କୋନ୍‌ ଆରେଙ୍‌ଡାଲେ ରିଙ୍‌ରିଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଡର୍ନେବେନ୍‌ ଅଡ଼େଙ୍ଗା ?” ବନ୍‌ଡ ଆନିଞ୍ଜି ବତଙେଞ୍ଜି ଆରି ସାନ୍ନିଡାଲେ ତର୍ଡମ୍‌ ଅଲ୍‌ବର୍ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ଆନିନ୍‌ ଆନା ଡ, ଆନିନ୍‌ ରିଙ୍ଗେନ୍‌ ଡ ଡାଆନ୍‌ ଜନଙ୍‌ ବବ୍‌ତଙ୍‌ତେ ଆରି ଆନିଞ୍ଜି ଆ ବର୍ନେନ୍‌ ମାନ୍ନେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ତିକ୍କି ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଗାଲିଲିନ୍‌ ଆ ମୁକ୍କା ଆ ଅଡିଗଡ୍‌ ଗରାସିଅଞ୍ଜି ଆମଙ୍‌ରେଙ୍‌ ତୁଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ଜିସୁନ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆପ୍ରଡ୍‌ଲନେନ୍‌, ତି ଆ ଗଡ଼ାଲୋଙ୍‌ ଅବୟ୍‌ ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରା ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରବାଙେ; ତି ଆ ମନ୍‌ରା ଜବ୍ର ଡିନ୍ନା ଡେଏନ୍‌ ସିନ୍‌ରିନ୍‌ ଏର୍‌ଜନିଜିନେନ୍‌ ଡକୋଲନେ, ଆରି ଆନିନ୍‌ ଅସିଙନ୍‌ ଏର୍‌ଡକୋନେନ୍‌ ମସାନ୍ନିରେଙନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ସଜିର୍‌ଡାଲେ ଆ ତାଲ୍‌ଜଙ୍‌ଲୋଙନ୍‌ ଅବ୍‌ସେଡ୍‌ଲନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଏ ସୋଡ଼ା ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିସୁ, ଆମନ୍‌ ସରିନ୍‌ ଞେନ୍‌ ଇନି ଡକୋ ? ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ କାକୁର୍ତିତନାୟ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଡଣ୍ଡାୟ୍‌ଡଙିଂ ।” ");
INSERT INTO juy_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିସୁନ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ଆଡଙ୍‌ ତି ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ବରେନ୍‌ । ତି ଆ ପୁରାଡ଼ା ଜବ୍ର ତର ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ସୁମେନ୍‌, ଆରି ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସିଙ୍କୁଡ଼ିନ୍‌ ଡ କାଡୁନ୍‌ ବାତ୍ତେ ଜିଲେ ଡକ୍କୋଏଞ୍ଜି, ବନ୍‌ଡ ଆନିନ୍‌ ଜରିଜିଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଅବ୍‌ତଡେନ୍‌ କି ବୁତନ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଆପ୍ପାୟ୍‌ଡମ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅଞୁମ୍‌ନମ୍‌ ଇନି ?” ଆନିନ୍‌ ଗାମେନ୍‌, “ଆକୁଡ଼ାୟ୍‌,” ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମଙନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ବୁତଞ୍ଜି ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ଆରି ଆନିନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ତଗୋସିଙନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ବାଁୟ୍‌ଡଙେଜି ତଡ୍‌ ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ କାକୁର୍ତିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ତେତ୍ତେ ଅବୟ୍‌ ସୋଡ଼ାଡମ୍‌ ଆ ଗୋସ୍ସାବୋନ୍‌ ବରୁନ୍‌ ଆ ତୟ୍‌ତୟ୍‌ ଜୋମ୍‌ଜୋମ୍‌ଲଞ୍ଜି, ଆରି ଆନିନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ତି କିମ୍ୱୋନଞ୍ଜି ଆ ଅମ୍ମ ଗଙ୍ଗନନ୍‌ ଆସନ୍‌ ଅନଡ଼େନ୍‌ ତିୟେଜି ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ କାକୁର୍ତିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅନଡ଼େନ୍‌ ଆତ୍ରିଏଞ୍ଜି; ବୁତଞ୍ଜି ତି ଆ ମନ୍‌ରା ଆମଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌, କିମ୍ୱୋନଞ୍ଜି ଆ ଅମ୍ମ ଇୟ୍‌ଲେ ଗନେଜି; ସିଲତ୍ତେ ତି ଗୋସ୍ସାବୋନନ୍‌ ଆକ୍ରାନ୍‌ ଇର୍ରେ ଆ ନାସିବୁର୍‌ଗଡ୍‌ ଜିର୍ରେ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ପତୁଲ୍‌ଡାଲେ ରବୁଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ଏତ୍ତେଗୋ ଆଡ୍ରେଏନ୍‌ଆତେ ଗିୟ୍‌ଲେ ତୁର୍‌ବୋନ୍‌ମରଞ୍ଜି ଇରେଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଗଡ଼ାରେଙନ୍‌ ଡ ସାଇରେଙନ୍‌ ତିଆତେ ଇୟ୍‌ଲେ ଅବ୍‌ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ସିଲତ୍ତେ ଇନି ଡେଏନ୍‌ ତିଆତେ ଗିୟ୍‌ଗିୟ୍‌ବାନ୍‌ ମନ୍‌ରାଞ୍ଜି ଇୟ୍‌ଲାଜି; ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ, ଅଙ୍ଗା ମନ୍‌ରା ଆମଙ୍‌ ସିଲଡ୍‌ ବୁତଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆନିନ୍‌ ଅଙ୍ଗିନ୍‌ ରଲନ୍‌, ମନଙ୍‌ ବୁଡ୍ଡିନ୍‌ ବାତ୍ତେ ଜିସୁନ୍‌ ଆ ତାଲ୍‌ଜଙ୍‌ ଆ ତୟ୍‌ତୟ୍‌ ଆତଙ୍କୁମନ୍‌ ଗିୟ୍‌ଲେ ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ଆରି ଆନାଜି ତିଆତେ ଗିଜେଞ୍ଜି, ଆନିଞ୍ଜି ତି ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରା ଏଙ୍ଗାଡାଲେ ମନଙେନ୍‌ ତିଆତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ସିଲତ୍ତେ ଗରାସିଅଞ୍ଜି ଆମଙ୍‌ରେଙ୍‌ ସମ୍ପରାନ୍‌, ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜିରା ଗାମ୍‌ଲାଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆକ୍ରାନ୍‌ ବତଙେଞ୍ଜି; ଆରି ଜିସୁନ୍‌ ଅବୟ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ୟର୍ରନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ଆମଙ୍‌ ସିଲଡ୍‌ ବୁତଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ତି ଆ ମନ୍‌ରା କାକୁର୍ତିଲନ୍‌ ବର୍ରନେ, “ଞେନ୍‌ ନିୟ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସନ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆବ୍‌ୟର୍‌ଡାଲେ ବରେନ୍‌, “ଆମନ୍‌ ଅସିଂନମ୍‌ ଜିରା, ଇସ୍ୱରନ୍‌ ଆମନ୍‌ ଆସନ୍‌ ଇନିଜି ଇନିଜି ଆ କାବ୍ବାଡ଼ା ଲୁମେନ୍‌ ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଇୟ୍‌ ବର୍ନା ।” ସିଲତ୍ତେ ତି ଆ ମନ୍‌ରା ଜିରେନ୍‌ କି, ଜିସୁନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇନିଜି ଇନିଜି ଆ କାବ୍ବାଡ଼ା ଲୁମେନ୍‌, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ସମ୍ପରା ଗଡ଼ାନ୍‌ ବର୍ବର୍ରେ ପାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ଜିସୁନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ବାନ୍ନେଗଡ୍‌ ଆୟର୍ରନାଞନ୍‌, ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ଜାଏଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜଗେଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ଆରି ଗିୟ୍‌ବା, ଜାଇରସ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଇୟ୍‌ଲାୟ୍‌; ଆନିନ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ଆ ସୋଡ଼ାମର୍‌ ଡକୋଏନ୍‌ । ଆନିନ୍‌ ଜିସୁନ୍‌ ଆ ତାଲ୍‌ଜଙ୍‌ଲୋଙ୍‌ ଅବ୍‌ସେଡ୍‌ଲନ୍‌, ଅସିଂଞେନ୍‌ ଇୟାୟ୍‌ ଗାମ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ କାକୁର୍ତିନେ । ");
INSERT INTO juy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆବୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ିଅନନ୍‌ ଡକୋଏନ୍‌, ତି ଆଇସିୟ୍‌ ଅସୁନ୍‌ ବାତ୍ତେ ଆରବୁଗୋ ଡେଏନ୍‌, ଆନିନ୍‌ ବାର ବର୍ସେଙ୍‌ ଡେଲୋ । ବନ୍‌ଡ ଜିସୁନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ମନ୍‌ରାଞ୍ଜି ରାବ୍‌ଲେତୁଲେ ଆମଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ତିଆଡିଡ୍‌ ବାର ବର୍ସେଙ୍‌ ଡେଲୋ ଅବୟ୍‌ ପ୍ରଦରରୋଗ ବମ୍ୱମ୍‌ନେବଜନ୍‌ ମିଞାମନ୍‌ ଜରଡ୍‌ଲଏନ୍‌, ଆନିନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ଡାବ୍ବୋନ୍‌ କର୍ସଆଜେନ୍‌, ବନ୍‌ଡ ଆନ୍ନିଙ୍‌ ଆ ରେଗମ୍‌ ବାତ୍ତେ ଆନିନ୍‌ ଅଃମ୍ମନଙ୍‌ଲୋ, ");
INSERT INTO juy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ଆନିନ୍‌ ଆ କଣ୍ଡୋଙ୍‌ଗଡନ୍‌ ଜିର୍ରେ ଜିସୁନ୍‌ ଆ ସିନ୍‌ରିନ୍‌ ଆଲୁଡ୍‌କାବ୍‌ ଇୟ୍‌ଲାୟ୍‌ ସୁଙେଏ, ଆରି ସିଲତ୍ତେମା ଆ ମିଞାମନ୍‌ ଅଞଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଆନା ଞେନ୍‌ଆଡଙ୍‌ ସୁଙେଲିଁୟ୍‌ ?” ବନ୍‌ଡ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଇଜ୍ଜା ଆଗ୍ରାମେଞ୍ଜି ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ମନ୍‌ରାଞ୍ଜି ରାବ୍‌ଲେତୁଲେ ଅମଙ୍‌ବାନମ୍‌ ଇୟ୍‌ତାୟ୍‌ କୁଡ଼ାୟ୍‌ନେଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ବନ୍‌ଡ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଆନ୍ନିଙ୍‌ ଅବୟ୍‌ନେ ଞେନ୍‌ଆଡଙ୍‌ ସୁଙେଲିଁୟ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ବୋର୍ସାନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ଜନାଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ସିଲତ୍ତେ ଆଇମରନ୍‌ ଗିଜେନ୍‌, ଆନିନ୍‌ ଆରି ସଲନ୍‌ ଅଃର୍ରପ୍ତିଲୋ, ତିଆସନ୍‌ ଆନିନ୍‌ ତକର୍‌ ତକର୍ରେ ଜିର୍ରେ ଜିସୁନ୍‌ ଆ ତାଲ୍‌ଜଙ୍‌ଲୋଙ୍‌ ଅବ୍‌ସେଡ୍‌ଲନ୍‌ ଆନିନ୍‌ ଇନିଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସୁଙେଏନ୍‌, ଆରି ଏଙ୍ଗାଡାଲେ ସିଲତ୍ତେମା ମନଙେନ୍‌ ତିଆତେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅଅନ୍‌ ଡର୍ନେନମ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲମ୍‌, ମା ଲବିଡ୍ଡା ଜିରା ।” ");
INSERT INTO juy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ଜିସୁନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆବର୍ରନେନ୍‌ ଆଡିଡ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ଆ ସୋଡ଼ାମର୍‌ ଜାଇରସନ୍‌ ଆସିଂ ସିଲଡ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିର୍ରେ, “ଡାଙ୍ଗଡ଼ିଅନ୍‌ନମ୍‌ ରବୁଏନ୍‌, ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ଆଡଙ୍‌ ଆରି ବାଉଲ୍ଲି ଏମ୍ମେଡଙେ,” ଗାମ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ । ");
INSERT INTO juy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ବନ୍‌ଡ ଜିସୁନ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଜାଇରସନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ବତଙ୍‌ଡଙମ୍‌, ଡର୍ନା, ଆନିନ୍‌ ଆରି ଅମେଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ଆରି ଜିସୁନ୍‌ ଜାଇରସନ୍‌ ଆସିଂ ଜିର୍ରେ ପିତ୍ରନ୍‌, ଜନନ୍‌, ଜାକୁବନ୍‌ ଡ ଆଇସିଜନ୍‌ ଆ ନନ ଡ ଆପେୟ୍‌ ତୁମ୍‌ ଅସିଙନ୍‌ ଗନ୍‌ଲଞ୍ଜି, ଆରି ଅମ୍ମସିଙନ୍‌ ଆନ୍ନିଙ୍‌ ଅନ୍ନମ୍‌ଗନ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ବନ୍‌ଡ ଅଡ଼୍‌କୋଞ୍ଜି ଆନିନ୍‌ ଆସନ୍‌ ୟେଲେ ଆ ମାୟଙ୍‌ଲୋଙଞ୍ଜି ତିଡ୍ଡମ୍‌ଲଞ୍ଜି । ସିଲତ୍ତେ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଏୟେଡଙ୍‌, ଆନିନ୍‌ ଆଲୁଡ୍‌ଲୁଡ୍‌ ସିନା ଅଣ୍ଡ୍ରଙ୍‌ ରବୁଏ ।” ");
INSERT INTO juy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ବନ୍‌ଡ ଆଇସିଜନ୍‌ ଆରବୁ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଆଜନାଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗବ୍‌ରଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ଜିସୁନ୍‌ ଆଇସିଜନ୍‌ ଆସି ଞମ୍‌ଲେ ବର୍ରନେ, “ଏ ଅଅନ୍‌ ଡୋନା ।” ");
INSERT INTO juy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ସିଲତ୍ତେ ତି ଆଇସିଜନ୍‌ ଆ ପରାନ୍ନା ୟର୍ରନାୟ୍‌, ଆରି ଆନିନ୍‌ ସିଲତ୍ତେମା ଡୋଲନେ, ଆରି ଜିସୁନ୍‌ ଆଇସିଜନ୍‌ଆଡଙ୍‌ “ଇନ୍ନିଙ୍‌ଡେନ୍‌ ଗାଗାନେନ୍‌ ତିୟ୍‌ବା” ଗାମ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ପସିଜନ୍‌ ଆ ନନ ଡ ଆପେୟନ୍‌ ସାନ୍ନି ଡେଏଞ୍ଜି; ବନ୍‌ଡ ତି ଆ ବର୍ନେ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଏବର୍‌ଡଙ୍‌ ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ଜିସୁନ୍‌ ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଅବ୍‌ରୁକ୍କୁଏଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ବୁତନ୍‌ ଗଙ୍ଗଙନ୍‌ ଆସନ୍‌, ଆରି ରୋଗନ୍‌ ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବୋର୍ସାନ୍‌ ଡ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ଆରି, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅପ୍ପୁଙ୍‌ବରନ୍‌ ଆସନ୍‌ ଡ ରୋଗମରଞ୍ଜିଆଡଙ୍‌ ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ଆରି ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଜରିର୍ଜିର୍‌ବେନ୍‌ ଆସନ୍‌ ତୁଡ଼େଡାଙ୍‌ ଅଡ଼େ ମୁନା ଅଡ଼େ ରୁଟି ଅଡ଼େ ଇନ୍ନିଙ୍‌ଜା ଏପାଙ୍‌ଡଙ୍‌, ଆରି ଅଙ୍ଗିନ୍‌ ନିୟ୍‌ ବାଗୁ ଏପାଙ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ଆରି, ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଙ୍ଗା ଅସିଂ ଆ ମନ୍‌ରାଜି ଜାତବେଞ୍ଜି, ତି ଆ ଗଡ଼ା ସିଲଡ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏଜିରେନ୍‌ ଜାୟ୍‌ ତି ଆସିଂ ଇୟ୍‌ ଡକୋନାବା । ");
INSERT INTO juy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ଆରି, ଡିଅଙ୍ଗା ମନ୍‌ରା ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଃଜ୍ଜାବେଞ୍ଜି, ତି ଆ ଗଡ଼ା ଅମ୍‌ରେଙ୍‌ଲେ ଏଜିରେନ୍‌ ଆଡିଡ୍‌, ଆ ବିରୁଦଲୋଙଞ୍ଜି ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ତାଲ୍‌ଜଙ୍‌ବେନ୍‌ ଆ ଉମ୍ରିଲ ତୁୟ୍‌ତୁୟ୍‌ନାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଜିର୍ରେ ସାଇ ସାଇ ସମ୍ପରାନ୍‌ ବୁଲ୍ଲେଲେ, ମନଙ୍‌ବରନ୍‌ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେଜି ଆରି ରୋଗମରଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ତିଆଡିଡ୍‌ ଗାଲିଲିନ୍‌ ଆ ରାଜ୍ୟପାଡ଼ ଏରୋଦନ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆଙ୍କାଏନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି, ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ୟର୍ମେଙ୍‌ଡାଲେ ଡୋଲନ୍‌ ଜିର୍ରାୟ୍‌ ଗାମ୍‌ଲେ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ଆରି, ଲାଙ୍‌ଲେନ୍ନେ ଏଲିଅନ୍‌ ଅବ୍‌ଗିୟ୍‌ତାଲନେ ଗାମେଞ୍ଜି, ଆରି ଲାଙ୍‌ଲେନ୍ନେ ପୁର୍ବାନ୍‌ ଆ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ୟର୍ମେଙ୍‌ଡାଲେ ଡୋଲନେ ଗାମ୍‌ଲେ ବର୍ରଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ବନ୍‌ଡ ଏରୋଦନ୍‌ ଗାମେନ୍‌, “ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ତ ଞେନ୍‌ ଗବ୍ବାଲାୟ୍‌, ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ଆ ବର୍ନେ କେନ୍‌ ଅମ୍‌ଡଙ୍‌ତାୟ୍‌, ତିଆନିନ୍‌ ଆନା ?” ଆରି, ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଏରେନ୍‌ ଗୋଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ତିକ୍କି ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ୟର୍ରନ୍‌, ଇନିଜି ଇନିଜି ଇୟ୍‌ଲେ ଲୁମେଜି, ତି ଅଡ଼୍‌କୋନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେଜି । ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଆନ୍ନାଡାଲନ୍‌ ବେତ୍‌ସାଇଦା ଗାମ୍‌ଲେ ଅବୟ୍‌ ଗଡ଼ାନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ବନ୍‌ଡ ମନ୍‌ରାଞ୍ଜି ତିଆତେ ଜନାଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି; ଆରି, ଜିସୁନ୍‌ ଆର୍ଗୁଡ଼ିଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ବର୍ନେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ଆରି ଆନାଜି ମବ୍‌ନଙ୍‌ନେନ୍‌ ସାଜେଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ତିକ୍କି ସାଲ୍ଲୁମ୍‌ଲେ ଆପ୍ରାଙେନ୍‌; ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ, “ମନ୍‌ରାଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଗଡ଼ାରେଙନ୍‌ ଡ ସାଇରେଙନ୍‌ ଜିର୍ରେ ବରସାସିଙନ୍‌ ଡ ଜନୋମ୍‌ଜୋମନ୍‌ ଞାଙ୍‌ଲେ ରପ୍ତିଏଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟାଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ତେନ୍ନେ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଡକୋ,” ଗାମ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାଗାନେନ୍‌ ତିୟ୍‌ବାଜି ।” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଅମଙ୍‌ଲେନ୍‌ ମନ୍‌ଲୟ୍‌ ରୁଟିନ୍‌ ଡ ବାଗୁ ଅୟନ୍‌ ତୁମ୍‌ ଡକୋ ଆରି ଗୋଗୋୟ୍‌ ତଡ୍‌; ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଇନି କେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆସନ୍‌ ଜନୋମ୍‌ଜୋମନ୍‌ ଏଞିନାୟ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତେତ୍ତେ ଆନିଞ୍ଜି ମନ୍‌ଲୟ୍‌ ଅଜାର ଡେତେ ଓବ୍ବାମରଞ୍ଜି ଡକୋଏଞ୍ଜି । ଆରି, ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବଗନେଃଗେଡନ୍‌ ପଚାସ ଜଣ ଲେକାଁୟ୍‌ ଆନିଞ୍ଜି ଅବ୍‌ତଙ୍କୁମ୍‌ବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଏତ୍ତେଲେ ଅବ୍‌ତଙ୍କୁମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ଆରି, ଜିସୁନ୍‌ ତି ମନ୍‌ଲୟ୍‌ ରୁଟିନ୍‌ ଡ ବାଗୁ ଅୟନ୍‌ ପାଙ୍‌ଲେ ରୁଆଙ୍‌ଗଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆଙାଙ୍‌ଡାଲନ୍‌ ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆସିର୍ବାଦଏନ୍‌, ଆରି ରେବ୍‌ଲୋଙ୍‌ ରେବ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ବନନ୍ତାନ୍‌ ଆସନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ସିଲତ୍ତେ ଅଡ଼୍‌କୋଞ୍ଜି ରୁଟିନ୍‌ ଜୋମ୍‌ଲେ ବୋଓଏଞ୍ଜି, ଆରି ଆର୍‌ଲାଗାଏନ୍‌ ଆରେବ୍‌ରେବ୍‌ ରୁଟିଞ୍ଜି ଞଙ୍‌ନେମରଞ୍ଜି ବାର ଗୁରୁଲ୍ଲି ବବ୍‌ରିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଆତିନ୍‌ସଜନ୍‌ ଆ ପାର୍ତନାଲନେନ୍‌ ଆଡିଡ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ଡକୋଏଞ୍ଜି, ଆରି ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆନା ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ବର୍ତଞ୍ଜି ?” ");
INSERT INTO juy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ଆନିଞ୍ଜି ଜାଲଙେଞ୍ଜି, “ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନ, ବନ୍‌ଡ ଲାଙ୍‌ଲେନ୍ନେ ଗାମ୍‌ତଜି, ଏଲିଅନ୍‌, ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଗାମ୍‌ତଜି, ପୁର୍ବାନ୍‌ ଆ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ୟର୍ମେଙ୍‌ଡାଲେ ଡୋଲନେ ଗାମ୍‌ଲେ ବର୍ତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବନ୍‌ଡ ଞେନ୍‌ ଆନା ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଇନି ଏଗାମ୍‌ତେ ?” ପିତ୍ରନ୍‌ ଜାଲଙେନ୍‌, “ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ କ୍ରିସ୍ଟ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ସିଲତ୍ତେ ଜିସୁନ୍‌ କେନ୍‌ଆତେ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ଏବର୍‌ଡଙ୍‌ନେ ଗାମ୍‌ଲେ ଆକ୍ରାନ୍‌ ବାଁୟ୍‌ଲେ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ଆରି ଆନିନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଜବ୍ର ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ, ଆରି ପାପୁର୍‌ମରଞ୍ଜି, ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବାସ୍ସେତଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ରବୁତେ, ବନ୍‌ଡ ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ଆନିନ୍‌ ୟର୍ମେଙ୍‌ଡାଲେ ଡୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ତିଆଡିଡ୍‌ ଆନିନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନ୍ନିଙ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସନଣ୍ଡୋଙନ୍‌ ଆସନ୍‌ ଲଡଜେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ମୁର୍ସେଡମ୍‌ନେତୋ, ଆରି ଡିତାନ୍‌ ଆନିନ୍‌ ଆଅକ୍କାଡଙନ୍‌ ପାଙ୍‌ଲେ ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ତୋ । ");
INSERT INTO juy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଆ ପରାନ୍ନାନ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ସାୟ୍‌ତେ, ତିଆତେ ଆନିନ୍‌ ଅବ୍ବଡ଼ୟ୍‌ତେ; ବନ୍‌ଡ ଆନା ଞେନ୍‌ ଆସନ୍‌ ଆ ପରାନ୍ନାନ୍‌ ଅବ୍ବଡ଼ୟ୍‌ତେ, ତିଆତେ ଆନିନ୍‌ ଡୋବ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ଆରି, ମନ୍‌ରାନ୍‌ ଏଙ୍ଗାଲେ ସମ୍ପରାନ୍‌ ପୁର୍ତିନ୍‌ ଞାଙ୍‌ଲୋଙ୍‌ ଞାଙ୍‌ଲେ ଆନିନ୍‌ ଅବ୍‌ସେଃଡ୍ଡମ୍‌ତନେ ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ଅବ୍ବଡ଼ୟ୍‌ତନେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଇନି ଆ ଲାବ ? ");
INSERT INTO juy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ତିଆସନ୍‌ ଆନା ଞେନ୍‌ ଆସନ୍‌ ଆରି ବର୍ନେଞେନ୍‌ ଆସନ୍‌ ଗବ୍‌ରୟ୍‌ତନେ, ଅଙ୍ଗା ଆଡିଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଡ ଆପେୟନ୍‌ ଆରି ମଡ଼ିର୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଆ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ଜିର୍ତାୟ୍‌, ତିଆଡିଡ୍‌ ଆନିନ୍‌ ତି ଆ ମନ୍‌ରା ଆସନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗବ୍‌ରୟ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ତେତ୍ତେ ଆତନଙନ୍‌ ଆ ମନ୍‌ରାଜି ଲାଙ୍‌ଲେନ୍ନେ, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅଣ୍ଡ୍ରଙ୍‌ ଗିଜେଞ୍ଜି ଜାୟ୍‌, ରନବୁନ୍‌ ଏର୍‌ମାୟ୍‌ମାଜନ୍‌ ଡକୋତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","କେନ୍‌ ଆ ବର୍ନେଜି ଆତ ଡିନ୍ନା ଆ ତିକ୍କି ଜିସୁନ୍‌, ପିତ୍ରନ୍‌, ଜନନ୍‌ ଡ ଜାକୁବନ୍‌ ସରିନ୍‌ ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ତୋଣ୍ଡୋ ବରୁନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ଆରି, ଆନିନ୍‌ ଆ ପାର୍ତନାଲନେନ୍‌ ଆଡିଡ୍‌ ଆ ମୁକ୍କାନ୍‌ ବାଙ୍‌ସାୟ୍‌ଲନେ ଆରି ଆ ସିନ୍‌ରିନ୍‌ ଜେଏଡମ୍‌ ଡେଏନ୍‌ କି ସାଆର୍‌ଡାଲେ କଲାୟ୍‌କଲାୟ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ଆରି, ଗିୟ୍‌ବା, ମୋସାନ୍‌ ଡ ଏଲିଅନ୍‌, କେନ୍‌ ବାଗୁନେ ଆନିନ୍‌ ସରିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ କଡାଡ଼ିନେଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ଆନିଞ୍ଜି ରୁଆଙ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ଗିୟ୍‌ତାଏଞ୍ଜି, ଆରି ଜିସୁନ୍‌ ଜିରୁସାଲମନ୍‌ ଜିର୍ରୟ୍‌ତେ ତି ଆ ବର୍ନେ, ଆନିଞ୍ଜି କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ତିଆଡିଡ୍‌ ପିତ୍ରନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ବରା ଡିମଡେଞ୍ଜି; ବନ୍‌ଡ ଆଙ୍ଗା ଆନିଞ୍ଜି ମଡ଼େଲେ ଡୋଲଞ୍ଜି, ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡ ଆନିନ୍‌ ସରିନ୍‌ ଆତନଙଞ୍ଜି ତି ବାଗୁ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ଆରି, ମୋସାନ୍‌ ଡ ଏଲିଅନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ତେନ୍ନେ ଡକୋନ୍‌ ଆସନ୍‌ ବୟ୍‌ଲେଙ୍‌; ଇନ୍‌ଲେଞ୍ଜି ୟାଗି ଅନ୍‌ସିଙନ୍‌ ଏଗୁତାୟ୍‌, ଆମନ୍‌ ଆସନ୍‌ ଅବୟ୍‌, ମୋସାନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ଆରି ଏଲିଅନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ।” ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଇନି ଗାମେନ୍‌ ତିଆତେ ଆନିନ୍‌ଡମ୍‌ ଅଃଜ୍ଜନାଲୋ । ");
INSERT INTO juy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ପିତ୍ରନ୍‌ କେନ୍‌ଆତେ ଆବର୍ରନେନ୍‌ ଆଡିଡ୍‌ ଅବୟ୍‌ ମେଗନ୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁବେଜି, ଆରି ଆନିଞ୍ଜି ଅମ୍ମ ମେଗନ୍‌ ଆଗ୍ରନେଞ୍ଜି ଆଡିଡ୍‌ ଆନିଞ୍ଜି ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ଆରି, ତି ଆ ମେଗଲୋଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଅଡ଼ୋଲାୟ୍‌, “କେନ୍‌ଆନିନ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌, କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଞେନ୍‌ ସେଡାଲାୟ୍‌, କେନ୍‌ ଆ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ଆରି, ତି ଆ ବର୍ନେ ଆସ୍ରଡ୍ଡାଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆତିନ୍‌ସଜନ୍‌ ଗିୟ୍‌ତାଏନ୍‌ । ଆରି, ଆନିଞ୍ଜି ରିଙ୍‌ରିଙେଞ୍ଜି, ତିଆଡିଡ୍‌ ଇନିଜି ଇନିଜି ଗିଜେଞ୍ଜି, ତିଆତେଜି ଅନ୍ନିଙ୍‌ ଆ ବର୍ନେ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ଅଃବ୍ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ତି ଆବାର୍ତାନ୍‌ ଜିସୁନ୍‌ ଆରି ୟାଗି ଞଙ୍‌ନେମରଞ୍ଜି ବରୁନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଜିର୍ରାଜି, ଆରି ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରବାଙେଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ଆରି ଗିୟ୍‌ବା, ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ବାବ୍ବାବ୍‌ଡାଲେ ବର୍ରନେ, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ କାକୁର୍ତିତନାୟ୍‌, ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ଆଡଙ୍‌ କାନକାରମ୍‌ଗାମା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆବୟଡମ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ଗିଜା, ଆନିନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ବୁତନ୍‌ ସୁମ୍‌ତେ, ଆରି ଆନିନ୍‌ ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ସଜିର୍ରେ ଡୋତନେ, ଆରି ବୁତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏତ୍ତେଲେ ପଡ୍ଡେତ୍ତେ ଡ, ଆ ତଅଡନ୍‌ ସିଲଡ୍‌ ପୋନ୍‌ସେରାନ୍‌ ଡୁଙ୍‌ତନାୟ୍‌, ଆରି ବୁତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅପ୍ପାରାଡାଲେ ଆମଙନ୍‌ ସିଲଡ୍‌ କାକୁର୍ତିଃ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ତେ । ");
INSERT INTO juy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ତି ବୁତନ୍‌ ଗଙ୍ଗଙନ୍‌ ଆସନ୍‌ ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ଆମଙ୍‌ କାକୁର୍ତିଲନାୟ୍‌, ବନ୍‌ଡ ଆନିଞ୍ଜି ଅଃର୍ରପ୍ତିଲଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଏର୍‌ଡର୍ନେମର୍‌ ଆରି ଆଲ୍ଲେମରଞ୍ଜି ଆ କେଜ୍ଜା, ଡିଅଙ୍ଗା ଡିନ୍ନା ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋନାୟ୍‌, ଆରି ଞଣ୍ଡ୍ରମ୍‌ବେଞ୍ଜି ସଏଆୟ୍‌ ? ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ତେନ୍ନେ ଓରୋଙାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ସିଲତ୍ତେ ପସିଜନ୍‌ ଜିରା ଜିରା ବୁତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାୟ୍‌ତାନ୍‌ ଅବ୍‌ସେଡ୍‌ଲେ ବରନ୍ତଙ୍‌ଡାନ୍‌ ପଡ୍ଡେଡେନ୍‌, ବନ୍‌ଡ ଜିସୁନ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ଆଡଙ୍‌ ବବ୍‌ତଙେନ୍‌ ଆରି ପସିଜନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଆ ବାପାନ୍‌ ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ସିଲତ୍ତେ ଅଡ଼୍‌କୋଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ସୋଡ଼ା ବୋର୍ସାନ୍‌ ଗିୟ୍‌ଲେ ସାନ୍ନି ଡେଏଞ୍ଜି । ବନ୍‌ଡ ଜିସୁନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଗିୟ୍‌ଲେ ଅଡ଼୍‌କୋଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି, ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଅଲୁଡ୍‌ଲୋଙ୍‌ବେନ୍‌ ଅମ୍‌ଡଙ୍‌ବା; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ରୟ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ବନ୍‌ଡ ଞଙ୍‌ନେମରଞ୍ଜି ତି ଆ ବର୍ନେ ଅଃଗନ୍‌ଲୁଡ୍‌ଲଜି, ଆରି ତିଆତେ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଆସସ ଡକୋଲନେ, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଗନ୍‌ଲୁଡ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି, ଆରି ତି ଆ ବର୍ନେ ଆସନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବର୍ବରନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନା ସତଙ୍‌, ତି ଆ ବର୍ନେଲୋଙ୍‌ ଆନିଞ୍ଜି ଅଲ୍‌ଡୁଲ୍‌ବାଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ ମନ୍ନଲୋଙଞ୍ଜି ଆନିଃୟମ୍‌ ଜନାଡାଲେ ଆମଙନ୍‌ ଅବୟ୍‌ ସନ୍ନାସିଜନ୍‌ ତବ୍‌ନଙ୍‌ଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“ଆନା ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ କେନ୍‌ ସନ୍ନାସିଜନ୍‌ଆଡଙ୍‌ ଜାତେ, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଜାତିଁୟ୍‌, ଆରି ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଜାତିଁୟ୍‌, ଆନିନ୍‌ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ଆଡଙ୍‌ ଜାତେ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଡ଼୍‌କୋଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଆନା ସନ୍ନା ଆନିନ୍‌ ସତଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ସିଲତ୍ତେ ଜନନ୍‌ ବର୍ରନେ, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଅଞୁମ୍‌ନମ୍‌ ବାତ୍ତେ ବୁତନ୍‌ ଆଗ୍ରଙେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଏଗିୟ୍‌ଲାୟ୍‌, ଆରି ଆନିନ୍‌ ଡଡ଼ଲେନ୍‌ ଆ ମନ୍‌ରା ତଡ୍‌, ତିଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏରଙ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏରଙ୍‌ଡଙେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ବନେରାମର୍‌ବେନ୍‌ ତଡ୍‌ ଆନିନ୍‌ ଡନେମର୍‌ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ତିକ୍କି ଅଙ୍ଗା ଆଡିଡ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଅନୋରୋଙନ୍‌ ଆବନେଡ଼ା ତୁୟାଲେ ପାଙ୍‌ଲାୟ୍‌, ତିଆଡିଡ୍‌ ଆନିନ୍‌ ଜିରୁସାଲମନ୍‌ ଜିର୍‌ଜିରନ୍‌ ସାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ଆନିନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆସନ୍‌ ଅନବ୍‌ଜାଡାବାନ୍‌ ଅବୟ୍‌ ସମିରୋଣମରଞ୍ଜି ଆ ସାଇ ଇୟ୍‌ଲେ ଗନେଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ବନ୍‌ଡ ଆନିନ୍‌ ଜିରୁସାଲମନ୍‌ ଜିର୍‌ଜିରନ୍‌ ସାୟ୍‌ତେ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଜନାଏଞ୍ଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି, ଆନିନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ଜାକୁବନ୍‌ ଡ ଜନନ୍‌, କେନ୍‌ ବାଗୁ ଞଙ୍‌ନେମରଞ୍ଜି ବର୍ରଞ୍ଜି, “ଏଲିଅନ୍‌ ନିୟ୍‌ ଏଙ୍ଗାଲେ ଲୁମେନ୍‌, ତିଅନ୍ତମ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ତଗୋନ୍‌ ଗଲୋଡାଲେ ଆନିଞ୍ଜି ଜୋମ୍‌ତୋଡାଜେତଜି, ଏନ୍ନେଲେ ଇନ୍‌ଲେନ୍‌ ଏବର୍ନାୟ୍‌ ପଙ୍‌, ଆମନ୍‌ ଇନି ଗାମ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ କଁୟ୍‌ଲେ ବର୍ରନେ, “ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଗୋ ଆ ପୁରାଡ଼ାମର୍‌ଜି, ଞେନ୍‌ ଅଃର୍ରପ୍ତି ଜନାଆୟ୍‌ । ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ପରାନ୍ନା ଅନବ୍‌ସେଡନ୍‌ ଆସନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌ ଆର୍ପାୟ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଆରି ଅବୟ୍‌ ସାଇନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ଆନିଞ୍ଜି ତଙରନ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଅଡ଼େଙ୍ଗା ଜିର୍ତେ, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ବୋଡ଼ାନ୍‌ ଆସନ୍‌ ଡଲ୍ଲିନ୍‌ ଡକୋ, ରୁଆଙନ୍‌ ଆ ଅନ୍ତିଡ୍‌ଜି ଆସନ୍‌ ବରସାସିଙନ୍‌ ଡକୋ, ବନ୍‌ଡ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆବବନ୍‌ ଡନକ୍କୋନ୍‌ ଆସନ୍‌ ଜାଗା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ଜିସୁନ୍‌ ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ ।” ବନ୍‌ଡ ଆନିନ୍‌ ଗାମେନ୍‌, “ଆପେୟ୍‌ଞେନ୍‌ ରବୁଏନ୍‌, ଆନିନ୍‌ ରୟ୍‌ ଆମ୍ମୁଙ୍‌ ଇୟ୍‌ତେ ତିଲ୍‌ନାୟ୍‌, ତିଆସନ୍‌ ଞେନ୍‌ ରୟଙନ୍‌ ତିୟିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆରବୁମରଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆରବୁମରଞ୍ଜିଆଡଙ୍‌ ତିଲ୍‌ତିଲନ୍‌ ଆସନ୍‌ ଅମ୍‌ରେଙ୍‌ବାଜି, ବନ୍‌ଡ ଆମନ୍‌ ଜିର୍ରେ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଇୟ୍‌ନପ୍ପୁଙ୍‌ବରା ।” ");
INSERT INTO juy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ଆରି ଅବୟ୍‌ନେ ଜନଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ତମ୍‌, ବନ୍‌ଡ ଆମ୍ମୁଙ୍‌ ଅସିଂଞେନ୍‌ ଡକୋନ୍‌ ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଅନବ୍‌ଜୋଞ୍ଜୋନେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ରୟଙନ୍‌ ତିୟିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆନା ମୁଣ୍ଡାନ୍‌ ଆ କନ୍ତିଲୋଙ୍‌ ଆସିନ୍‌ ଡକ୍କୋଡାଲେ କିଣ୍ଡୋଙ୍‌ଗଡ୍‌ ଆଙାଙ୍‌ତନେ, ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପ୍ରବୁନ୍‌ ଆରି ସତୁରି ଜଣ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ସେଡାଏଞ୍ଜି ଆରି ଆନିନ୍‌ଡମ୍‌ ଅଙ୍ଗା ଅଙ୍ଗାଲୋଙ୍‌, ଆରି ଅଙ୍ଗା ଆ ଗଡ଼ା ଅନିୟନ୍‌ ସାଜେନ୍‌, ତି ଆ ଗଡ଼ାରେଙ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବାଗୁ ବାଗୁନେ ଅମ୍ମେଲେ ଆ ସାମ୍ମୁଙନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଜନ୍‌ରୋମନ୍‌ ସିନା ଗୋଗୋୟ୍‌, ବନ୍‌ଡ କାବ୍ବାଡ଼ାମରଞ୍ଜି ଅସୋୟ୍‌; ତିଆସନ୍‌ ଆ ଜନ୍‌ରୋମ୍‌ଆଲନ୍‌ କାବ୍ବାଡ଼ାମରଞ୍ଜିଆଡଙ୍‌ ଅନାପ୍ପାୟନ୍‌ ଆସନ୍‌ ଜନ୍‌ରୋମ୍‌ଆଲନ୍‌ ଆ ସାଉକାର ଆମଙ୍‌ ପାର୍ତନାନାବା । ");
INSERT INTO juy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ଆମ୍ୱେଞ୍ଜି ଇୟ୍‌ବା; ଗିୟ୍‌ବା, ବଲିଆଞ୍ଜି ଆମଙ୍‌ବା ମେଣ୍ତାଅନନ୍‍ ଅନ୍ତମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ଗାଞ୍ଜିଆନ୍‌, ମୁନାନ୍‌, ଆରି ପାଣ୍ଡୋୟନ୍‌ ଏପାଙ୍‌ଡଙ୍‌, ଆରି ତଙର୍‌ରେଙ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଏଲୋମ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ଆରି, ଅଙ୍ଗା ଆସିଂ ଆମ୍ୱେନ୍‌ ଇୟ୍‌ତେ ଏଗନେ, ‘କେନ୍‌ ଆସିଂ ସୟୁନ୍‌ ଡେଏତୋ’ ଗାମ୍‌ଲେ ଆମ୍ମୁଙ୍‌ ଇୟ୍‌ ବର୍ନାବା । ");
INSERT INTO juy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ଆରି, ତି ଆସିଂଲୋଙ୍‌ ଅବୟ୍‌ ସୟୁମରନ୍‌ ଡକୋଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସୟୁବେନ୍‌ ଆମଙନ୍‌ ପଡ୍‌ତେ; ବନ୍‌ଡ ସୟୁମରନ୍‌ ଅଃଡ୍ଡକୋଲୋ ଡେନ୍‌, ତିଆତେ ଅମଙ୍‌ବେନ୍‌ ୟର୍ତନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ଆରି, ଆନିଞ୍ଜି ଇନି ରୋଜୋମ୍‌ତବେଞ୍ଜି, ତିଆତେ ଜୋମ୍‌ଲେ ଗାଲେ ତି ଆସିଂ ଇୟ୍‌ ଡକୋନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କାବ୍ବାଡ଼ାମରନ୍‌ ଆ ବର୍ତନ୍ନାନ୍‌ ଞନାଙନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଜିଞ୍ଜିନ୍‌ । ଇୟ୍‌ଡଙ୍‌ ଏଗଙ୍ଗନ୍‌ସିଂନେ । ");
INSERT INTO juy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ଆରି, ଅନ୍ନିଙ୍‌ ଆ ଗଡ଼ାଲୋଙ୍‌ ଆମ୍ୱେନ୍‌ ଇୟ୍‌ଲେ ଏଗନେ ଡେନ୍‌, ଆରି ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଜାଲବେଞ୍ଜି ଡେନ୍‌, ତେତ୍ତେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଙ୍ଗାତେ ରୋଜୋମ୍‌ତବେଞ୍ଜି, ତିଆତେ ଇୟ୍‌ ଜୋମ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ତେତ୍ତେ ଡକୋନ୍‌ ଆସୁମର୍‌ଜିଆଡଙ୍‌ ଇୟ୍‌ ମବ୍‌ନଙ୍‌ବାଜି, ଆରି ‘ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅମଙ୍‌ବେନ୍‌ ତୁୟାଲାୟ୍‌’ ଗାମ୍‌ଲେ ଇୟ୍‌ ବର୍ବାଜି । ");
INSERT INTO juy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ବନ୍‌ଡ ଅନ୍ନିଙ୍‌ ଆ ଗଡ଼ାଲୋଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଇୟ୍‌ଲେ ଏଗନେ ଡେନ୍‌ ଆରି ତେତ୍ତେ ଆ ମନ୍‌ରାଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଃଜ୍ଜାଲବେଞ୍ଜି ଡେନ୍‌, ତି ଆ ଡାଣ୍ଡରେଙ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ବର୍ନାବା, ");
INSERT INTO juy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘ଗଡ଼ାବେନ୍‌ ଆ ଉମ୍ରିଲ ଅଙ୍ଗାତେ ତାଲ୍‌ଜଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ଜାବେନ୍‌, ତିଆତେ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଏତୁୟ୍‌ତୁୟ୍‌ଜଙ୍‌ତନାୟ୍‌; ଡେଲେ ଜନଙ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ତୁୟାଲାୟ୍‌ ଗାମ୍‌ଲେ ଜନାବେନ୍‌ତୋ ।’ ");
INSERT INTO juy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ତି ଆ ଡିନ୍ନା ତି ଆ ଗଡ଼ା ଆ ପନବ୍‌ରଡ୍‌ ସିଲଡ୍‌ ସଦୋମ ଗଡ଼ାନ୍‌ ଆ ପନବ୍‌ରଡ୍‌ ରପ୍ତି ସଏତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ୟୋଙ୍‌, କୋରାଜିନ୍‌ ପନବ୍‌ରଡ୍‌ନମ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ୟୋଙ୍‌, ବେତ୍‌ସାଇଦା ପନବ୍‌ରଡ୍‌ନମ୍‌ ନିୟ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଡିଅଙ୍ଗା ଅଡ଼୍‌କୋନ୍‌ ବୋର୍ସା କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଡେଏନ୍‌, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ସୋରନ୍‌ ଆରି ସିଦୋନ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ଲୁମ୍‌ଲନ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଆଙ୍ଗାନ୍‌ ପୁର୍ବାନ୍‌ ସିଲଡ୍‌ ମା ଅକ୍କାନ୍‌ ରଲନ୍‌ କୋମାବ୍‌ଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିତଞ୍ଜି ବନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ପନ୍‌ସୁଆତିଲୋଙନ୍‌ ପନବ୍‌ରଡ୍‌ବେନ୍‌ ସିଲଡ୍‌ ସୋରନ୍‌ ଡ ସିଦୋନନ୍‌ ଆ ପନବ୍‌ରଡ୍‌ ରପ୍ତି ସଏତନେ । ");
INSERT INTO juy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ଆରି, ଏ କପର୍ନାଉମ୍‌, ଆମନ୍‌ ଇନି ରୁଆଙନ୍‌ ଜାୟ୍‌ ତେକ୍କେତନ୍‌ ପଙ୍‌ ? ରନବୁ ଡରକୋନେନ୍‌ ଜାୟ୍‌ ଆମନ୍‌ ସନେଡନ୍‌ ଡେତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ଜିସୁନ୍‌ ଆରି, ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନା ବର୍ନେବେନ୍‌ ଅମ୍‌ଡଙ୍‌ତେ, ଆନିନ୍‌ ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ତେ, ଆରି ଆନା ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବାସ୍ସେତବେନ୍‌, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବାସ୍ସେତିଁୟ୍‌, ଆରି ଆନା ଞେନ୍‌ଆଡଙ୍‌ ବାସ୍ସେତିଁୟ୍‌, ଆନିନ୍‌ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ଆଡଙ୍‌ ବାସ୍ସେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସତୁରି ଜଣ ଞଙ୍‌ନେମରଞ୍ଜି ସର୍ଡାନ୍‌ ବାତ୍ତେ ୟର୍ରନ୍‌, “ପ୍ରବୁ, ବୁତଞ୍ଜି ନିୟ୍‌ ଅଞୁମ୍‌ଲୋଙ୍‌ନମ୍‌ ବର୍ନେଲେନ୍‌ ମାନ୍ନେତଜି” ଗାମ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେଜି । ");
INSERT INTO juy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ତାବ୍‌ରେଡନ୍‌ ଅନ୍ତମ୍‌ ସନୁମନ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଆରସେଡେନ୍‌ ଞେନ୍‌ ଗିୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ଗିୟ୍‌ବା, ଜାଆଡନ୍‌ ଡ ସନକାବ୍‌ରେଙନ୍‌ ଆ ତୋଣ୍ଡୋ ତଙିୟ୍‌ନେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବୋର୍ସାନ୍‌ ତିୟ୍‌ଲବେନ୍‌, ଆରି ବନେରାନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବୋର୍ସା ଆ ତୋଣ୍ଡୋ ନିୟ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ତିୟ୍‌ଲବେନ୍‌, ଆରି ଇନ୍ନିଙ୍‌ଜା ଏଙ୍ଗାଲେଜନଙ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅନ୍ନବ୍‌ପାରାବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ବନ୍‌ଡ, ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାଞ୍ଜି ବର୍ନେବେନ୍‌ ମାନ୍ନେତଜି, ତିଆସନ୍‌ ଏସର୍ଡାଡଙ୍‌ନେ, ଆର୍ପାୟ୍‌ ଅଞୁମ୍‌ବେନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ତିଆସନ୍‌ ସର୍ଡାନାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ତି ଆ ବନେଡ଼ା ଜିସୁନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ମଅଁୟ୍‌ଡାଲନ୍‌ ବର୍ରନେ, “ଏ ଆପେୟ୍‌, ରୁଆଙନ୍‌ ଡ ପୁର୍ତିନ୍‌ ଆ ପ୍ରବୁ, ଆମନ୍‌ ଜନନାମରଞ୍ଜି ଡ ବୁଡ୍ଡିମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଅବ୍‌ସସଲେ ଡକ୍କୋଡାଲେ ସନ୍ନାସିଜଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ଗିୟ୍‌ତାଏନ୍‌, ତିଆସନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସେଙ୍କେତମ୍‌; ଓଓ ଆପେୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆତେ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ନମ୍‌ ଅରିଃସୁମ୍‌ଡମ୍‌ ଡେଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ଆପେୟ୍‌ଞେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ତନିୟନ୍‌ ଡେଲୋ; ଆରି ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନା, କେନ୍‌ଆତେ ଆପେୟନ୍‌ ତୁମ୍‌ ଜନାତେ ଆରି ଆନ୍ନିଙ୍‌ ଅଃଜ୍ଜନାଏ, ଆରି, ଆପେୟନ୍‌ ଆନା, କେନ୍‌ଆତେ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ତୁମ୍‌ ଜନାତେ ଆରି ଆନ୍ନିଙ୍‌ ଅଃଜ୍ଜନାଏ, ଆରି ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନା ଆମଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଜନାନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ତେ, ଆନିନ୍‌ ଜନାତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ଆରି, ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତୁମ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଅଙ୍ଗାତେ ଏଗିୟ୍‌ତେ, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଅଙ୍ଗାମଡ୍‌ ଗିୟ୍‌ତେ, ତିଆତେ ସନେନ୍‌ସେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଅଙ୍ଗାତେ ଏଗିୟ୍‌ତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଗୋଗୋୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଡ ରାଜାଞ୍ଜି ଗିୟ୍‌ଗିଜନ୍‌ ସାଜେଞ୍ଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ଅଃଗିୟ୍‌ଲଜି; ଆରି ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଅଙ୍ଗାତେ ଏଅମ୍‌ଡଙ୍‌ତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଆନିଞ୍ଜି ଅନମ୍‌ଡଙନ୍‌ ସାଜେଞ୍ଜି, ବନ୍‌ଡ ଅଃନ୍ନମ୍‌ଡଙ୍‌ଲଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ଆରି ଗିୟ୍‌ବା, ଅବୟ୍‌ ସାସ୍ତ୍ରିନ୍‌ ଡୋଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ମାଲ୍‌ଲେ ବରେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଇନି ଏଙ୍ଗାନାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଇନି ଆଇଡିଡ୍‌ ? ଆମନ୍‌ ଏଙ୍ଗାଡାଲେ ପଡ଼େତନେ ?” ");
INSERT INTO juy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ଆନିନ୍‌ ଜାଲଙେନ୍‌, “‘ଆମ୍ୱେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍ନନ୍‌, ଅଡ଼୍‌କୋ ପରାନ୍ନାନ୍‌, ଅଡ଼୍‌କୋ ବୋର୍ସାନ୍‌ ଆରି ଅଡ଼୍‌କୋ ମନ୍ନନ୍‌ ତିୟ୍‌ଲେ ପ୍ରବୁ ଇସ୍ୱରବେନ୍‌ ଡୁଙ୍‌ୟମ୍‌ବା; ଆରି, ତୟ୍‌ଲିସିଂମର୍‌ବେନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେନ୍‌ଡମ୍‌ ଅନ୍ତମ୍‌ ଡୁଙ୍‌ୟମ୍‌ବା ।’” ");
INSERT INTO juy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଆଜାଡ଼ିଡମ୍‌, ଜାଲଙ୍‌ଲିଁୟ୍‌; କେନ୍‌ଆତେ ଲୁମା ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଅନମେଙନ୍‌ ଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ବନ୍‌ଡ ସାସ୍ତ୍ରିନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଡରମ୍ମମର୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ତୁୟ୍‌ନେନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତୟ୍‌ଲିସିଂମର୍‌ଞେନ୍‌ ଆନା ?” ");
INSERT INTO juy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ଜିସୁନ୍‌ ତି ଆ ବର୍ନେ ଞମ୍‌ଲେ ଜାଲଙେନ୍‌, “ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଜାୟ୍‌ତାନ୍‌ ଜିରିଓନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ରାଉମରଞ୍ଜି ଡଙେଞ୍ଜି । ଆନିଞ୍ଜି ଆ ସିନ୍‌ରିନ୍‌ ରୁୟ୍‌ଲେ ପାଙେଞ୍ଜି ଆରି ତିଡେଞ୍ଜି କି, ଆଡିଲ୍‌ମେଙନ୍‌ ଆଡିଡ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ତି ଆ ତିକ୍କି ଅବୟ୍‌ ରାଓଡ଼ାନ୍‌ ତି ଆ ତଙର୍‌ଗଡ୍‌ ଜିରେନ୍‌, ଆରି ରାଓଡ଼ାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ତଙରନ୍‌ ବମିୟ୍‌ତାଲ୍‌ଗଡ୍‌ ସାଡ୍‌ଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ତିଅନ୍ତମ୍‌ ଅବୟ୍‌ ଲେବିଅମରନ୍‌ ନିୟ୍‌ ତେତ୍ତେ ଜିର୍ରେ, ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ତଙରନ୍‌ ବମିୟ୍‌ତାଲ୍‌ଗଡ୍‌ ସାଡ୍‌ଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ବନ୍‌ଡ ଅବୟ୍‌ ସମିରୋଣ ତଙର୍‌ଗଡ୍‌ମର୍‌ ଆମଙନ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଆର୍ଗୁଡ଼ିଡାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ଆରି ଆମଙନ୍‌ ଜିର୍ରେ ଆପାରାଲୋଙନ୍‌ ମିଞଲନ୍‌ ଡ ଦ୍ରାକ୍ୟାଡାନ୍‌ ଲାଲେ ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଜିଏନ୍‌, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଆ ଗୋଡୋଁୟ୍‌ଲୋଙନ୍‌ ଅବ୍‌ତଙ୍କୁମ୍‌ଲେ ଅବୟ୍‌ ଲୋଲୋନେସିଙନ୍‌ ଓରୋଙ୍‌ଡାଲେ ଇୟ୍‌ଲେ ସାକ୍କେଏ । ");
INSERT INTO juy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ତି ଆବାର୍ତାନ୍‌ ସମିରୋଣମରନ୍‌ ବାଗୁ ରୁପାଡାବନ୍‌ ତବ୍‌ଲେ ଲୋଲୋନେସିଙନ୍‌ ଆ ମୁଡ଼ମର୍‌ ଆସିଲୋଙ୍‌ ତିୟ୍‌ଲେ, ‘କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସାକ୍କେଆୟ୍‌, ଆରି ଅଙ୍ଗାତେ ଗୋଗୋୟ୍‌ କର୍ସତେ, ତିଆତେ ଞେନ୍‌ ୟର୍ରନାୟ୍‌ ଆଡିଡ୍‌ ଅମଙ୍‌ନମ୍‌ ଇୟ୍‌ତାୟ୍‌ ସୁଜ୍ଜାୟ୍‌ନାୟ୍‌,’ ଗାମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","କେନ୍‌ ୟାଗିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌, ଆନା ରାଉମରଞ୍ଜି ଆସିଲୋଙ୍‌ ଆଗ୍ରଲୋଏନ୍‌ ଆ ମନ୍‌ରା ଆ ତୟ୍‌ଲିସିଂମର୍‌ ଗାମ୍‌ଲେ ଆମନ୍‌ ଅବ୍‌ଡିସୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ସାସ୍ତ୍ରିନ୍‌ ବର୍ରନେ, “ଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ସାୟୁମେନ୍‌ ଆନିନ୍‌ ।” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜିରା, ଆମନ୍‌ ନିୟ୍‌ ତିଅନ୍ତମ୍‌ ଇୟ୍‌ ଲୁମା ।” ");
INSERT INTO juy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ତଙରନ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ ସାଇନ୍‌ ଇୟ୍‌ଲେ ଗନେ, ତେତ୍ତେ ମାର୍ତା ଗାମ୍‌ଲେ ଅବୟ୍‌ ଆଇବଜନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆସିଙନ୍‌ ଓଡ୍ଡେଡାଲେ ଓରୋଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ମରିଅମ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଆ ବୋଲ୍‌ମାୟନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ପ୍ରବୁନ୍‌ ଆଜଙ୍‌ ଆ ତୟ୍‌ତୟ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ଆ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଲେ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ବନ୍‌ଡ ମାର୍ତାନ୍‌ ଡିଁୟ୍‌ଡିଁୟ୍‌ନେଲୋଙନ୍‌ ଜବ୍ର ବାଉଲ୍ଲି ଡେଏନ୍‌; ତିଆସନ୍‌ ଆନିନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ, “ଏ ପ୍ରବୁ, ତିନ୍‌ସୟ୍‌ଞେନ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଆ ବିଡ଼ାର୍‌ ଡଅଙ୍‌ଲୋଙ୍‌ଞେନ୍‌ ବୋଲ୍‌ମାୟ୍‌ଞେନ୍‌ ଆତ୍ରିୟ୍‌ଲିଞନ୍‌, ତିଆତେ ଆମନ୍‌ ଅଃଗିଜେ ପଙ୍‌ ? ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରା, କାବ୍ବାଡ଼ାନ୍‌ ଇସିଙ୍‌ ଆୟ୍‌ ମାୟିଁୟ୍‌ତୋ,” ଗାମ୍‌ଲେ ଇୟ୍‌ଲେ ବରେ । ");
INSERT INTO juy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ବନ୍‌ଡ ପ୍ରବୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ମାର୍ତା, ମାର୍ତା ଆମନ୍‌ ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ବର୍ନେ ଇୟମ୍‌ତେ ଆରି ବାଉଲ୍ଲିତନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ବନ୍‌ଡ ଅସୋୟ୍‌ଡମ୍‌, ଆର୍ପାୟ୍‌ ଆବୟନ୍‌ ତୁମ୍‌ ସନାୟ୍‌ସାୟ୍‌, ମରିଅମନ୍‌ ତ ମନଙ୍‌ ବନ୍ତାନ୍‌ ସେଡାଏନ୍‌, ଆରି ଆମଙନ୍‌ ସିଲଡ୍‌ ତିଆତେ ପନାଙନ୍‌ ଅଃଡ୍ଡେଏ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଅନ୍ନିଙ୍‌ ଅବୟ୍‌ ଜାଗାଲୋଙ୍‌ ପାର୍ତନାଲନେ; ଆନିନ୍‌ ପାର୍ତନାନେନ୍‌ ଆସ୍ରାଡେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ପ୍ରବୁ, ଜନନ୍‌ ଏଙ୍ଗାଲେ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ଞଙେଞ୍ଜି, ଆମନ୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଞଙ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଏପାର୍ତନାତନେ, ତିଆଡିଡ୍‌ ବର୍ନାବା, ‘ଆପେୟ୍‌, ଅଞୁମ୍‌ନମ୍‌ ମଡ଼ିର୍‌ ଗାମ୍‌ଲେ ମନାନ୍ନେନ୍‌ ଡେଏତୋ । ରାଜ୍ୟନମ୍‌ ଜିରାୟ୍‌ତୋ । ");
INSERT INTO juy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ଡିତାନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ସନାୟ୍‌ସାୟ୍‌ ଜନୋମ୍‌ଜୋମନ୍‌ ତିୟ୍‌ଲେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ଇର୍ସେଲେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ କେମାଲେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ନିୟ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଅଡ଼୍‌କୋ ଡୋସାମର୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଏକେମାତାୟ୍‌ । ମନାଲ୍‌ମାଲ୍‌ଲୋଙନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଓରୋଙ୍‌ଡଙ୍‌ଲେନ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ଆରି, ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଆ ଗଡ଼ି ଏନ୍ନେଗୋ ଡକୋ ପଙ୍‌, ଆରି ଆନିନ୍‌ ତି ଆ ଗଡ଼ି ଆମଙ୍‌ ତୁଙାର୍‌ ତଗଲନ୍‌ ଇୟ୍‌ଲେ, ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ତେ ବରେ, ‘ଏ ଗଡ଼ି, ଞେନ୍‌ଆଡଙ୍‌ ୟାଗି ରୁଟିନ୍‌ ରେୟାନ୍‌ ତିୟିଁୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅବୟ୍‌ ଗଡ଼ିଞେନ୍‌ ତଙରନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ଅମଙ୍‌ଞେନ୍‌ ତୁଙ୍‌ଲାୟ୍‌, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ରନୋଜୋମନ୍‌ ଆସନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ଆରି ଆନିନ୍‌ ଅମ୍ମନ୍‌ ସିଲଡ୍‌ ଜାଲଙ୍‌ତାୟ୍‌, ‘ଞେନ୍‌ଆଡଙ୍‌ ବାଉଲ୍ଲି ଏମ୍ମେଡଙିଁୟ୍‌, ସନଙନ୍‌ ଇଙଡ୍‌ଲାୟ୍‌ନି, ଆରି ପସିୟ୍‌ଞେଞ୍ଜି ଞେନ୍‌ ସରିନ୍‌ ଆଲୁଡ୍‌ଲୁଡ୍‌ଜି, ଞେନ୍‌ ଡୋଲନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଅମ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆ ଗଡ଼ିନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ବେଡେନ୍‌ ଆସନ୍‌, ଆନିନ୍‌ ଡୋଲନ୍‌ ଅଃତ୍ତିୟେ, ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଏର୍‌ଗନ୍‌ରଜନ୍‌ ନମିନ୍‌କି ନମିନ୍‌ ଆବ୍ରେଡେନ୍‌ ଆନିନ୍‌ ଡୋଲନ୍‌, ଆନିନ୍‌ ଆସନ୍‌ ଡିଅଙ୍ଗା ସନାୟ୍‌ସାୟ୍‌, ଡିୟ୍‌ତେ, ଆନିନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ବେଡ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ; ସାୟ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏରବାଙ୍‌ତେ; ସନଙ୍‌ଲୋଙନ୍‌ ଡେବ୍ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ସନଙନ୍‌ ରୋତନେ । ");
INSERT INTO juy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ବେଡ୍‌ତେ, ଆନିନ୍‌ ଞାଙ୍‌ତେ; ଆନା ସାୟ୍‌ଡଙ୍‌ତେ, ଆନିନ୍‌ ରବାଙ୍‌ତେ; ଆରି, ଆନା ଡେବ୍‌ସଙ୍‌ତେ, ଆନିନ୍‌ ଆସନ୍‌ ସନଙନ୍‌ ରନୋନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ଆରି, ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଏନ୍ନେଗୋ ଆ ବାପା ଆନ୍ନିଙ୍‌ ଡକୋ ପଙ୍‌, ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅୟନ୍‌ ବେଡେନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଅୟନ୍‌ ଆ ପାଲ୍‌ତେଙ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଜାଆଡନ୍‌ ତିୟ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ଅଡ଼େ ଆରେସିମନ୍‌ ବେଡେନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ସନକାବ୍‌ରେଙନ୍‌ ତିୟ୍‌ତେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ପେଲ୍ଲାଜି ଜନଙ୍‌ଡେନ୍‌, ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ପସିୟ୍‌ଜିଆଡଙ୍‌ ମନଙ୍‌ ମନଙ୍‌ ତନିୟ୍‌ତିୟଞ୍ଜି ତିୟ୍‌ଲେ ଏଗୟ୍‌ତେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅଙ୍ଗା ବାପା ରୁଆଙନ୍‌ ସିଲଡ୍‌ ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ତନ୍‌, ଆ ମୁକ୍କାଗଡନ୍‌ ଆବ୍ରେତେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଆନିନ୍‌ ଡିଅଙ୍ଗା ଆ ଗୋଗୋୟ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଅରଃ ତିୟେଞ୍ଜି !” ");
INSERT INTO juy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ବୁତନ୍‌ ଗଙେନ୍‌, ତି ଆ ବୁତ ଆଜାଡ୍ଡା । ବୁତନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆଜାଡ୍ଡାନ୍‌ ଆ ମନ୍‌ରା କଡାଡ଼ିଲନେ; ସିଲତ୍ତେ ମନ୍‌ରାଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ବନ୍‌ଡ ଆନିଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ ବୁତଞ୍ଜି ଆ ସୋଡ଼ା ବାଲ୍‌ଜିବୁଲନ୍‌ ବାତ୍ତେ ବୁତନ୍‌ ଗଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ଆନ୍ନାମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ମନାଲ୍‌ମାଲନ୍‌ ଆସନ୍‌, ଇସ୍ୱରନ୍‌ ଡନେମର୍‌ନମ୍‌ ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଏଜନାଆୟ୍‌, ତିଆସନ୍‌ ଆମନ୍‌ ଅବୟ୍‌ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଅବ୍‌ତୁୟ୍‌ଲେନ୍‌ ଗାମ୍‌ଲେ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଃୟମଞ୍ଜି ଆ ବର୍ନେ ଜନାଡାଲେ ବର୍ରନେ, “ଅନ୍ନିଙ୍‌ ଆ ରାଜ୍ୟ ତରଙ୍‌ଆନ୍ନା ଡେଲୋଙ୍‌ ଡେଲେ ଆ ବିରୁଦଲୋଙନ୍‌ ଡୋଲନ୍‌ଡେନ୍‌, ତିଆତେ ନିଅଂସ ଡେତେ, ଆରି ଆବସିଙନ୍‌ ଆ ମନ୍‌ରାଜି ତର୍ଡମ୍‌ ଅଲ୍‌ସଙ୍ଗାତାଏଞ୍ଜି ଡେନ୍‌ ତି ଆସିଂ ଅସେଡ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ଆରି, ସନୁମନ୍‌ ନିୟ୍‌ ତରଙ୍‌ଆନ୍ନା ଡେଲୋଙ୍‌ ଡେଲେ ଆନିନ୍‌ଡମ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ ଡୋଲନ୍ନି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆ ରାଜ୍ୟନ୍‌ ଏଙ୍ଗାଡାଲେ ରିଙ୍‌ ଗାମ୍‌ଲେ ଅଲ୍‌ଡକୋନେ ? ଞେନ୍‌ ବାଲ୍‌ଜିବୁଲନ୍‌ ବାତ୍ତେ ବୁତଞ୍ଜି ଗଙ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ତ ଏବର୍ତନେ । ");
INSERT INTO juy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ବନ୍‌ଡ ଞେନ୍‌ ବାଲ୍‌ଜିବୁଲନ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ ବୁତନ୍‌ ଗଙ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସନଣ୍ଡୋଙ୍‌ମର୍‌ବେଞ୍ଜି ଆନା ଆ ବୋର୍ସା ବାତ୍ତେ ବୁତଞ୍ଜିଆଡଙ୍‌ ଗଙ୍‌ତଜି ? ତିଆସନ୍‌ ଆନିଞ୍ଜି ମା ପନ୍‌ସୁଆତିମର୍‌ବେଞ୍ଜି ଡେତଜି । ");
INSERT INTO juy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ବନ୍‌ଡ ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଅଣ୍ଡେର୍‌ସି ବାତ୍ତେ ବୁତଞ୍ଜି ଗଙ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅମଙ୍‌ବେନ୍‌ ଅଡ଼ୋଲାୟ୍‌ନି ।” ");
INSERT INTO juy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ବୋର୍ସାମରନ୍‌ ଅଙ୍ଗା ଜାୟ୍‌ ଅତିଆରଞ୍ଜି ଞମ୍‌ଲେ ଅବ୍‌ଜାଡାଲନ୍‌ ଆସିଙନ୍‌ ଜଗେତେ, ତି ଜାୟ୍‌ ଆନର୍ଜେନ୍‌ ଏରାମ୍ମୁୟ୍‌ ଡକୋତେ । ");
INSERT INTO juy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ବନ୍‌ଡ ଅଙ୍ଗା ଆଡିଡ୍‌ ଆନିନ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ ବୋର୍ସାମରନ୍‌ ଇୟ୍‌ଲୋଙ୍‌ ଇୟ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଜୁରୁଡାଲେ ଜିନୟ୍‌ତେ, ତିଆଡିଡ୍‌ ଅଙ୍ଗା ଅତିଆରଲୋଙ୍‌ ଆନିନ୍‌ ଆସାଲନ୍‌ ଡକୋଲନେ, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆନିନ୍‌ ରାଉଡାଲନ୍‌ ପାଙ୍‌ଲେ ଜିର୍ତେ, ଆରି ରାଉଜନବଞ୍ଜି ପାଙ୍‌ଲେ ଇୟ୍‌ତେ ବନ୍ତାନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ଆନା ଡନେମର୍‌ଞେନ୍‌ ତଡ୍‌, ଆନିନ୍‌ ବନେରାମର୍‌ଞେନ୍‌; ଆରି ଆନା ଞେନ୍‌ ସରିନ୍‌ ଅଃତ୍ତର୍ତୁମେ, ଆନିନ୍‌ ବୁର୍ବୁରାୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌, ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ ସିଲଡ୍‌ଡେନ୍‌, ଆନିନ୍‌ ଡାଆ ତଡ୍‌ ରେଙନ୍‌ ବୁଲ୍ଲେଲେ ଲୋଲୋନେନ୍‌ ଆସନ୍‌ ଇୟ୍‌ତେ ସାଜେ, ଆନିନ୍‌ ତିଆତେ ଅଃନ୍ନିୟ୍‌ଞାଙେ, ତିଆସନ୍‌ ଆନିନ୍‌ ଗାମ୍‌ତେ, ‘ଞେନ୍‌ ଅଙ୍ଗା ଆସିଂ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରାୟ୍‌, ତି ଆସିଂ ଞେନ୍‌ ୟର୍ତନେ ।’ ");
INSERT INTO juy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ଆନିନ୍‌ ୟର୍ରନ୍‌ ତି ଆସିଂ ଆଜଜ ଆତର୍ଜ ଆରି ମନଙ୍‌ଡମ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗିଜେ । ");
INSERT INTO juy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଆରି ଜିର୍ରେ ଆନିନ୍‌ ସିଲଡ୍‌ ଜବ୍ର ପେଲ୍ଲା ଆରି ସାତଟା ପୁରାଡ଼ାଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଲେ ଇୟ୍‌ତେ ଓରୋଙେଜି, ଆରି ଆନିଞ୍ଜି ତେତ୍ତେ ଗନ୍‌ଲନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଡକୋନେଜି, ଆରି ତି ଆ ମନ୍‌ରା ଆମ୍ମୁଙ୍‌ ଆ ଡଣ୍ଡ ସିଲଡ୍‌ ତିକ୍କି ଆ ଡଣ୍ଡ ଆରି ଗୋଗୋୟ୍‌ ପରାନ୍‌ସାତ୍ତିନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ଜିସୁନ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଆବର୍ରନେନ୍‌ ଆଡିଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ଆଇମରନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଅଙ୍ଗା ଅୟୋଙ୍‌ ଆମନ୍‌ଆଡଙ୍‌ କୋଡ୍‌ଲମ୍‌, ଆରି ଆନା ଆମନ୍‌ଆଡଙ୍‌ ମେମେଲମ୍‌ ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ବନ୍‌ଡ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଇଜ୍ଜା, ଆର୍ପାୟ୍‌ ଆନାଜି ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ତଜି ଆରି ଞଣ୍ଡ୍ରମ୍‌ତଞ୍ଜି ଆନିଞ୍ଜି ସନେନ୍‌ସେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ମନ୍‌ରାଞ୍ଜି ରୁକ୍କୁ ରୁକ୍କୁଡାଲନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଆକ୍ରୁଡ଼ାୟ୍‌ଲଞ୍ଜି ଆଡିଡ୍‌ ଆନିନ୍‌ ବର୍ରନେ, “ନମିଜି ଆ ମନ୍‌ରାଜି ପେଲ୍ଲାଜି, କେନ୍‌ଆନିଞ୍ଜି ଅରମ୍ମଡନ୍‌ ସାୟ୍‌ତଜି, ବନ୍‌ଡ ଜୁନସନ୍‌ ଆରମ୍ମଡ୍‌ ତୁମ୍‌ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ, ଆରି ଅନ୍ନିଙ୍‌ ଆରମ୍ମଡ୍‌ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଅଃଡ୍ଡେଏ । ");
INSERT INTO juy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜୁନସନ୍‌ ଏଙ୍ଗାଲେ ନିନିବିବାଜି ଆସନ୍‌ ଅବୟ୍‌ ଅରମ୍ମଡନ୍‌ ଅନ୍ତମ୍‌ ଡେଏନ୍‌, ତିଅନ୍ତମ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ନମିଜି ଆ ମନ୍‌ରାଜି ଆସନ୍‌ ଅରମ୍ମଡନ୍‌ ଅନ୍ତମ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ଅର୍ଜଡ଼ୋମ୍‌ ଗଡ୍‌ ଡକୋନ୍‌, ସିବା ଡେସାନ୍‌ ଆ ରାଣି ପନ୍‌ସୁଆତିଲୋଙନ୍‌ କେନ୍‌ ନମିଜି ଆ ମନ୍‌ରାଜି ସରିନ୍‌ ଡୋଲନ୍‌ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଡୋସାତଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ସୋଲମନ୍‍ ରାଜାନ୍‌ ଆ ଜନନାବର୍‌ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ପୁର୍ତିନ୍‌ ଆନେଙ୍‌ ସିଲଡ୍‌ ଇୟ୍‌ଲାୟ୍‌; ଆରି ଗିୟ୍‌ବା, ସୋଲମନନ୍‌ ସିଲଡ୍‌ ଆରି ଗୋଗୋୟ୍‌ ସୋଡ଼ା ବର୍ନେନ୍‌ କେନ୍‌ତେନ୍ନେ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ନିନିବିନ୍‌ ଆ ମନ୍‌ରାଜି ପନ୍‌ସୁଆତିଲୋଙନ୍‌ କେନ୍‌ ନମିଜି ଆ ମନ୍‌ରାଜି ସରିନ୍‌ ଡୋଲନ୍‌ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଡୋସାତଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଜୁନସନ୍‌ ଆନପ୍ପୁଙ୍‌ବର୍‌ ବାତ୍ତେ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲଞ୍ଜି; ଆରି ଗିୟ୍‌ବା, ଜୁନସନ୍‌ ସିଲଡ୍‌ ଆରି ଗୋଗୋୟ୍‌ ସୋଡ଼ା ବର୍ନେନ୍‌ କେନ୍‌ତେନ୍ନେ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ଆନ୍ନିଙ୍‌ ପିଙ୍କନ୍‌ ତର୍ରେ ଆସସରେଙନ୍‌ ଅଡ଼େ ମାଡ଼ିଞନ୍‌ ଆ ଜାୟ୍‌ତା ଅଃଡ୍ଡକ୍କୋଏ, ବନ୍‌ଡ ପିଙ୍କପିଲନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଡକ୍କୋତେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅମ୍ମନ୍‌ ଆଗ୍ରନ୍‌ତେଞ୍ଜି ଆ ମନ୍‌ରାଜି ସାଆରନ୍‌ ଗିୟ୍‌ଲେ ରପ୍ତିତଜି । ");
INSERT INTO juy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ଅମଡ୍‌ବେନ୍‌ ଡଅଙନ୍‌ ଆ ପିଙ୍କ । ଅଙ୍ଗା ଆଡିଡ୍‌ ଅମଡ୍‌ବେନ୍‌ ମନଙ୍‌ ଡକୋତେ, ତିଆଡିଡ୍‌ ସମ୍ପରା ଡଅଙ୍‌ବେନ୍‌ ନିୟ୍‌ ସାଆର୍‌ତେ; ବନ୍‌ଡ ଅଙ୍ଗା ଆଡିଡ୍‌ ତିଆତେ ପରାନ୍‌ସାତ୍ତିନ୍‌ ଡକୋତେ, ତିଆଡିଡ୍‌ ଡଅଙ୍‌ବେନ୍‌ ନିୟ୍‌ ଲୋଙଡ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ତିଆସନ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଉଗର୍‌ବେନ୍‌ ଆ ସନାଆର୍‌ ଲୋଙଡ୍‌ ଡେଡଙ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ତିଆସନ୍‌ ସମ୍ପରା ଡଅଙ୍‌ବେନ୍‌ ସାଆର୍‌ଡାଲେ, ଆରି ତେତ୍ତେ ଅନ୍ନିଙ୍‌ଲୋଙ୍‌ ଲୋଙଡନ୍‌ ଅଃଡ୍ଡକୋଲୋ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ପିଙ୍କନ୍‌ ଏଙ୍ଗାଲେ ଆକ୍ରାନ୍‌ ତର୍ରେ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଅବ୍‌ସାଆର୍‌ତବେନ୍‌, ତିଅନ୍ତମ୍‌ ସମ୍ପରା ଡଅଙ୍‌ବେନ୍‌ ସାଆର୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ଜିସୁନ୍‌ ବର୍ନେନ୍‌ ଆରବ୍‌ସୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଅବୟ୍‌ ପାରୁସିନ୍‌, ଗାଗାନେବାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆସିଙନ୍‌ ଓଡ୍ଡେଲାୟ୍‌, ତିଆସନ୍‌ ଜିସୁନ୍‌ ପାରୁସିନ୍‌ ଆସିଂ ଜିର୍ରେ ଇୟ୍‌ଲେ ଗାଗାନେ । ");
INSERT INTO juy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ବନ୍‌ଡ ଜିସୁନ୍‌ ମନଙ୍‌ ଏର୍‌ଗନିୟ୍‌ଡାନେନ୍‌ ଆଗ୍ରାଗାଲନେନ୍‌ ଆସନ୍‌, କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ପାରୁସିନ୍‌ ସାନ୍ନି ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ସିଲତ୍ତେ ପ୍ରବୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମ୍ୱେନ୍‌ ପାରୁସିଞ୍ଜି ସିମ୍ମାନ୍‌ ଡ ସଡ଼ୁଆନ୍‌ ଆ କିଣ୍ଡୋଙ୍‌ ତୁମ୍‌ ଏଗିୟ୍‌ଡାତେ, ବନ୍‌ଡ ଅମ୍ମବେନ୍‌ ରାଉନ୍‌ ଡ ପେଲ୍ଲାଲୋଙନ୍‌ ଆବରିୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ଏ ଏର୍‌ବୁଡ୍ଡିଜି, ଆନା ବାୟରାନ୍‌ ଗବ୍‌ଡେଲେନ୍‌, ଆନିନ୍‌ ଅମ୍ମନ୍‌ ନିୟ୍‌ ପଙ୍‌ ଅଃଗବ୍‌ଡେଲ୍ଲୋ ? ");
INSERT INTO juy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ଆର୍ପାୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆତେ ଇନିଜି ଡକୋ, ତି ଅଡ଼୍‌କୋନ୍‌ ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ତିୟ୍‌ବା; ଆରି ଗିୟ୍‌ବା, ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ବେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ମନଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ବନ୍‌ଡ ୟୋଙ୍‌, ପାରୁସିଜି ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ପୋଦିନାନ୍‌, ଆରୁଦନ୍‌, ଆରି କୋତ୍ତାବେନ୍‌ ଆ ଜନବ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ଦସମାଂସ ଏତିୟ୍‌ତେ, ଆରି ମନଙ୍‌ ପନ୍‌ସୁଆତିନ୍‌ ଡ ଇସ୍ୱରନ୍‌ ଆ ଡନୁଙ୍‌ୟମ୍‌ ଅମଙ୍ଗଡ଼ାୟ୍‌ ଏଏମ୍ମେତନ୍‌; ବନ୍‌ଡ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ମୁଙ୍‌ ଲୁମ୍‌ବା, ଆରି ଆନ୍ନାଜିଆତେ ଅଡ଼୍‌କୋନ୍‌ ଅମଙ୍ଗଡ଼ାୟ୍‌ ଏଡକୋଡଙ୍‌ନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ୟୋଙ୍‌ ପାରୁସିଜି ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ସୋଡ଼ା ତରଙ୍କୁମନ୍‌ ଡ ସୟ୍‌ତାରେଙନ୍‌ ଅବ୍‌ଲୋମ୍‌ଲୋମ୍‌ନେନ୍‌ ଏଲଡୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ୟୋଙ୍‌, ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଃଗିୟ୍‌ତାଏନ୍‌ ଆ ମସାନ୍ନି ଅନ୍ତମ୍‌, ତି ଆ ତୋଣ୍ଡୋ ଆତ୍ରଙିୟ୍‌ତନେଞ୍ଜି ଆ ମନ୍‌ରାଜି କେନ୍‌ଆତେ ମସାନ୍ନି ଗାମ୍‌ଲେ ଅଃଜ୍ଜନାଏଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ସିଲତ୍ତେ ସାସ୍ତ୍ରିଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, କେନ୍‌ଆତେଜି ଆମନ୍‌ ବର୍ରନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ଅଲ୍ଲଗନ୍‌ଡ୍ରୟ୍‌ ଏମ୍ମେତଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ୟୋଙ୍‌, ବନାଁୟ୍‌ବର୍‌ ଆପଡ଼େନେମର୍‌ଜି ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଲଗିନ୍‌ଡମନ୍‌ ଆ ବିଡ଼ାର୍‌ ଏଲାତ୍ତିନ୍‌ତଜି ଆରି ଆମ୍ୱେନ୍‌ଡମ୍‌ ଅଜିଡ୍‌ ଜାକିଁୟ୍‌ ବ ଅଣ୍ଡେର୍‌ସି ବାତ୍ତେ ତିଆତେ ଇସିଙ୍‌ ଏଃତ୍ତେକ୍କେଏ । ");
INSERT INTO juy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ୟୋଙ୍‌, ଆମ୍ୱେଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ମସାନ୍ନି ଏତୁବ୍‌ତେ, ବନ୍‌ଡ ଆନିଞ୍ଜିଆଡଙ୍‌ ପୁର୍ବା ଜୋଜୋବେଞ୍ଜି ସମ୍ୱବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ତିଆସନ୍‌, ପୁର୍ବା ଜୋଜୋବେଞ୍ଜି ଆ କାବ୍ବାଡ଼ା ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ସାକି ଡକୋଜି ଆରି ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଏଅବ୍‌ତୁୟ୍‌ତନେ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ସିନା ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ସମ୍ୱବେଞ୍ଜି, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଆ ମସାନ୍ନିଞ୍ଜି ଏତୁବ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ତିଆସନ୍‌ ଇସ୍ୱରନ୍‌ ନିୟ୍‌ ଆ ଜନନାନ୍‌ ବାତ୍ତେ ବର୍ରନେ, ‘ଞେନ୍‌ ଆମଙଞ୍ଜି ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଡ ଅନାପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌; ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ଆନିଞ୍ଜି ସମ୍ୱବ୍‌ତଜି ଆରି ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ଡଣ୍ଡାୟ୍‌ତଜି ।’ ");
INSERT INTO juy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ପୁର୍ତିନ୍‌ ଆଗ୍ରଡେଲେନ୍‌ ସିଲଡ୍‌ ଉଲନ୍‌ ଡିଅଙ୍ଗା ଅଡ଼୍‌କୋନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ସମ୍ୱବେଞ୍ଜି ତି ଅଡ଼୍‌କୋନ୍‌ ଆ ସନୁଜ୍ଜାୟ୍‌ କେନ୍‌ ନମିଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ସିଲଡ୍‌ ପନାଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ଏବଲନ୍‌ଆଡଙ୍‌ ଆସ୍ରମ୍‌ବବେଞ୍ଜି ସିଲଡ୍‌ ଉଲନ୍‌, ଜିକରିୟନ୍‌ଆଡଙ୍‌ ମଡ଼ିର୍‌ ତନମ୍ପିଲନ୍‌ ଡ ସରେବାସିଙନ୍‌ ଆ ମଡ୍ଡିଲୋଙ୍‌ ଆସ୍ରମ୍‌ବବେଞ୍ଜି ଜାୟ୍‌, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ସନୁଜ୍ଜାୟ୍‌ କେନ୍‌ ନମିଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ସିଲଡ୍‌ ପନାଙନ୍‌ ଡେତେ । ଓଓ, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ ନମିଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ସିଲଡ୍‌ ପନାଙନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ୟୋଙ୍‌, ବନାଁୟ୍‌ବରନ୍‌ ଆପଡ଼େନେମରଞ୍ଜି ପନବ୍‌ରଡନ୍‌ ଏଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଜନନାନ୍‌ ଆ କଡ୍ଡା ଅମଙ୍‌ବେନ୍‌ ଏଡକ୍କୋଏନ୍‌; ଆମ୍ୱେନ୍‌ଡମ୍‌ ଏଃଗନ୍‌ଲୋ, ଆରି ଗଙ୍ଗନନ୍‌ ଆସନ୍‌ ଆସ୍ରାଜେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଏଡଙେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ଆରି, ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଆଜିର୍ରେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ଆକ୍ରାନ୍‌ ବରାବ୍‌ଡାଲେ, ");
INSERT INTO juy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ଆ ତଅଡ୍‌ଲୋଙନ୍‌ ଅନ୍ନିଙ୍‌ ଆ ବର୍ନେ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ବର୍ନେଜି ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ତିଆଡିଡ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ରୁକ୍କୁଡାଲନ୍‌ ତର୍ଡମ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଅଲ୍‌ରାବେଞ୍ଜି; ତିଆଡିଡ୍‌ ଜିସୁନ୍‌, ଆମ୍ମୁଙ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ପାରୁସିଞ୍ଜି ଆ କମିର ଅନ୍ତମ୍‌ ଆ ଇସ୍କତ୍ତାଞ୍ଜି ସିଲଡ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା । ");
INSERT INTO juy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ବନ୍‌ଡ ଅଙ୍ଗାତେ ଆୟୁମ୍‌ୟୁମ୍‌ ତିଆତେ ଗିୟ୍‌ତାଆୟ୍‌ତେ, ଆରି ଅଙ୍ଗାତେ ଆସସ ତିଆତେ ଜନାଲଙ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ତିଆସନ୍‌, ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଅଙ୍ଗାତେ ଆ ଲୋଙଡ୍‌ଲୋଙନ୍‌ ଏବର୍ରନେ, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆ ସାଆର୍‌ଲୋଙନ୍‌ ଅନମ୍‌ଡଙନ୍‌ ଡେତେ, ଆରି ଅଙ୍ଗାତେ ଆସସସିଂଲୋଙନ୍‌ ଏବର୍ରନେ, ତିଆତେଜି ଅସିଙନ୍‌ ଆ ତୋଣ୍ଡୋ ବିଲେଙ୍‌ଲୋଙନ୍‌ ବର୍ନେନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ଏ ଗଡ଼ିଞେଞ୍ଜି, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନାଜି ଡଅଙନ୍‌ ସମ୍ୱବ୍‌ତଜି, ବନ୍‌ଡ ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆରି ଇନ୍ନିଙ୍‌ ଅଃର୍ରପ୍ତିଲୁମେଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ବତଙ୍‌ଡଙ୍‌ବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ବନ୍‌ଡ ଆନାଆଡଙ୍‌ ଏବତଙ୍‌ତେ, ତିଆତେ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାତବେନ୍‌; ସନମ୍ୱବନ୍‌ ଆ ତିକ୍କି ତଗୋସିଂଲୋଙନ୍‌ ପନିଡନ୍‌ ଆସନ୍‌ ଅଙ୍ଗା ଇସ୍ୱର ଆସିଲୋଙ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ଡକୋ, ଆନିନ୍‌ଆଡଙ୍‌ ବତଙ୍‌ବା; ଓଓ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ବତଙ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ଇନି ମନ୍‌ଲୟ୍‌ ସୟ୍‌ସିଂତିଡନ୍‌ ବାଗୁ ତଙ୍କା ବାତ୍ତେ ଅଃତ୍ତମ୍‌ନେ ପଙ୍‌ ? ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ଜାକିଁୟ୍‌ ଇସ୍ୱରନ୍‌ ଅଃକ୍କରୋଡାଏ । ");
INSERT INTO juy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ବନ୍‌ଡ ଅବବ୍‌ଲୋଙ୍‌ବେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ଉଉ ଜାକିଁୟ୍‌ ଆଡିଡି, ବତଙ୍‌ଡଙ୍‌ବେନ୍‌; ସୟ୍‌ସିଂତିଡଞ୍ଜି ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଗୋଗୋୟ୍‌ ମଡ଼ଗା ।” ");
INSERT INTO juy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ଆରି, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନା ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମୁର୍ସେଇଁୟ୍‌, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ଇସ୍ୱରନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମୁର୍ସେଏ; ");
INSERT INTO juy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ବନ୍‌ଡ ଆନା, ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ମୁର୍ସେତିଁୟ୍‌, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ଇସ୍ୱରନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ମୁର୍ସେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“ଆରି ଆନା, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ବର୍ତନେ, ଆନିନ୍‌ଆଡଙ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଡେତେ; ବନ୍‌ଡ ଆନା, ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ନିଣ୍ଡୟ୍‌ବରନ୍‌ ବର୍ତନେ, ଆନିନ୍‌ଆଡଙ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଅଃଡ୍ଡେଏ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ଆରି, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ରନୁକ୍କୁସିଙନ୍‌, ରାଜ୍ୟପାଡ଼ନ୍‌ ଡ ସୋଡ଼ାମରଞ୍ଜି ଆମଙ୍‌ବା ଓରୋଙ୍‌ତବେଞ୍ଜି, ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଡନେଲୋଙ୍‌ବେନ୍‌ ଏଙ୍ଗାଡାଲେ ଇନି ଗାମ୍‌ଲେ ଏଜାଲଙ୍‌ତେ ଆରି ଇନି ଏଗାମ୍‌ତେ ତିଆସନ୍‌ ଏଇଃୟମ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନି ଗନାମନ୍‌ ଡେତେ, ତି ଆ ବନେଡ଼ା ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଞଙ୍‌ଞଙ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଆପେୟ୍‌ଞେନ୍‌ ଆନର୍ଜେଜି ଞେନ୍‌ ବୟନ୍‌ ବନ୍ତାନେନ୍‌ ଆସନ୍‌ ବୋଞାଙ୍‌ଞେନ୍‌ଆଡଙ୍‌ ବରା ।” ");
INSERT INTO juy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଗଡ଼ି, ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ଡ ବନ୍ତାଡିଞନ୍‌ ଆସନ୍‌ ଆନା ଞେନ୍‌ଆଡଙ୍‌ ତବ୍‌ନଙ୍‌ଲିଁୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଗିୟ୍‌ଡମ୍‌ନାବା, ଅଡ଼୍‌କୋନ୍‌ ଆ ଗନିୟ୍‌ମଡ୍‌ ସିଲଡ୍‌ ଆମ୍ୱେନ୍‌ଡମ୍‌ ସବ୍‌ଙାୟ୍‌ନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ଡିଅଙ୍ଗା ଜାକିଁୟ୍‌ ଅନର୍ଜେନ୍‌ ଡକୋଏନ୍‌ ଡେନ୍‌, ତି ବାତ୍ତେ ଆନିନ୍‌ ପରାନ୍ନାନ୍‌ ଅଃଞାଙେ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ଆରି, ଜିସୁନ୍‌, ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବରେଞ୍ଜି, “ଅବୟ୍‌ ଗମାଙ୍‌ମରନ୍‌ ଆ ବସେଙ୍‌ଲୋଙ୍‌ ଗୋଗୋୟ୍‌ ଜନ୍‌ରୋମନ୍‌ ଏଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ସିଲତ୍ତେ ତି ମନ୍‌ରାନ୍‌ ଇୟମେନ୍‌ ‘ଞେନ୍‌ ଇନି ଏଙ୍ଗାଆୟ୍‌ ? ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜନ୍‌ରୋମ୍‌ଞେନ୍‌ ତର୍ତୁମ୍‌ଲେ ଡନକ୍କୋନ୍‌ ଆସନ୍‌ ଜାଗା ତଡ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ଆରି, ଆନିନ୍‌ ଗାମେନ୍‌, ‘ଞେନ୍‌ ଏନ୍ନେଲେ ଲୁମ୍‌ତାୟ୍‌; ମରଁୟ୍‌ଞେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ପୁପ୍ପୁଃଡାଲେ ସୋଡ଼ାରାଡମ୍‌ ଅମ୍ମେଲେ ଗୁତାୟ୍‌, ଆରି ତେତ୍ତେ ଜନ୍‌ରୋମ୍‌ଞେଞ୍ଜି ଡ ଜନବ୍‌ଞେଞ୍ଜି ତର୍ତୁମ୍‌ଡାଲେ ଡକ୍କୋତାୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ଆରି ଞେନ୍‌ ପରାନ୍ନାଞେନ୍‌ଆଡଙ୍‌ ବର୍ତାୟ୍‌, ଏ ପରାନ୍ନା, ଗୋଗୋୟ୍‌ ବର୍ସେଙ୍‌ ଆସନ୍‌ ଜନ୍‌ରୋମଞ୍ଜି ଆତର୍ତୁମ୍‌, ତିଆସନ୍‌ ଲୋଲୋନା, ଗାଆ, ଜୋମା, ସର୍ଡାନା !’ ");
INSERT INTO juy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଏ ଏର୍‌ବୁଡ୍ଡି, ଲଙେ ଆ ତଗଲ୍‌ ଅମଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ପରାନ୍ନାନମ୍‌ ପନାଙନ୍‌ ଡେତେ; ସିଲତ୍ତେ ଆମନ୍‌ ଇନିଜି ଇନିଜି ଆମନ୍‌ଡମ୍‌ ଆସନ୍‌ ଡକ୍କୋଏନ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌ ଆନାଆତେ ଡେତେ ?’” ");
INSERT INTO juy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ଜିସୁନ୍‌ ଆରି ବର୍ରନେ, “ଆନା ଆନିନ୍‌ଡମ୍‌ ଆସନ୍‌ ରନ୍ନାନ୍‌ ଡକ୍କୋତେ, ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ ଆନିନ୍‌ ଗମାଙ୍‌ମର୍‌ ତଡ୍‌, ଆନିନ୍‌ ଆସନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇନି ଏଜୋମ୍‌ତେ, ଏନ୍ନେଲେ ଇୟମ୍‌ଡାଲେ, ପରାନ୍ନାବେନ୍‌ ଆସନ୍‌, ଅଡ଼େ ଇନି ଏଜିଜିତନେ, ଏନ୍ନେଲେ ଇୟମ୍‌ଡାଲେ ଡଅଙ୍‌ବେନ୍‌ ଆସନ୍‌ ନିୟ୍‌ ଏଇଃୟମ୍‌ଡଙେ । ");
INSERT INTO juy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜନୋମନ୍‌ ସିଲଡ୍‌ ପରାନ୍ନାନ୍‌ ଆରି ସିନ୍‌ରିନ୍‌ ସିଲଡ୍‌ ଡଅଙନ୍‌ ସୋଡ଼ା । ");
INSERT INTO juy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","କାକାଞ୍ଜି ଆ ବର୍ନେ ଇୟମ୍‌ଲେ ଗିୟ୍‌ବା, ଆନିଞ୍ଜି ଅଃବ୍ବୁଡେଜି କି ଅଃଗଡେଜି, ଆରି ଆନିଞ୍ଜି ଆସନ୍‌ ଜନ୍‌ରୋମ୍‌ସିଂ ତଡ୍‌ କି ତନିଲ୍‌ ତଡ୍‌, ଆରି ଇସ୍ୱରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜନୋମନ୍‌ ତିୟ୍‌ତଜି; ଆମ୍ୱେଞ୍ଜି ଅନ୍ତିଡଞ୍ଜି ସିଲଡ୍‌ ଡିଅଙ୍ଗା ଆ ଗୋଗୋୟ୍‌ ସତଙ୍‌ ! ");
INSERT INTO juy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ଆରି, ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଆନା ଇୟମ୍‌ଡାଲେ ଅନମେଙନ୍‌ ଆସନ୍‌ ବସନ୍ତି ଅବ୍‌ଗୋଗୋୟ୍‌ଲେ ରପ୍ତିଏ ? ");
INSERT INTO juy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ତିଆସନ୍‌, ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ସନ୍ନା କାବ୍ବାଡ଼ାନ୍‌ ନିୟ୍‌ ଲୁମ୍‌ଲେ ଏଃର୍ରପ୍ତିଲୋ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନ୍ନା କାବ୍ବାଡ଼ାନ୍‌ ଆସନ୍‌ ଇନିବା ଏଇଃୟମ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ତାର୍ବାଞ୍ଜି ଆ ବର୍ନେ ଇୟମ୍‌ଲେ ଗିୟ୍‌ବା, ତିଆତେଜି ଏଙ୍ଗାଲେ ତାଡ଼େରନ୍‌ ଅଃତ୍ତବେଜି କି ଅଃବ୍ବୁବୁଡ୍‌ନେଜି; ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ସୋଲମନ୍‍ ରାଜାନ୍‌ ଆମଙ୍‌ କେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଡକୋଏନ୍‌ ଜନଙ୍‌, ଆନିନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଅବୟ୍‌ ଜାକିଁୟ୍‌ ଅଃର୍ରଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ବନ୍‌ଡ ଅଙ୍ଗା ଅଜିଙ୍‌ ପଡ଼ିଆଲୋଙନ୍‌ ଲଙେ ଡକୋ, ଆରି ବିଅଡ଼େଃ କୋଡ଼ାତୁଡ୍‌ଲୋଙନ୍‌ ପନିଡନ୍‌ ଡେତେ, ତି ଆଜିଙ୍‌ ଇସ୍ୱରନ୍‌ ଡିୟ୍‌ତେ ଆ ମନଙ୍‌ ଗବ୍‌ଡେଲ୍‌ତେ, ଏ ଅସୋୟ୍‌ ଡର୍ନେମର୍‌ଜି, ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡିଅଙ୍ଗା ଆ ଗୋଗୋୟ୍‌ ସିନ୍‌ରିନ୍‌ ଅରଃ ତିୟ୍‌ବେନ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“ଆରି, ଇନି ଏଜୋମ୍‌ତେ ଆରି ଇନି ଏଗାତେ ତିଆତେ ଆମ୍ୱେଞ୍ଜି ସାୟ୍‌ଲେ ଏବୁଲ୍ଲେଡଙ୍‌ କି ଏଇଃୟମ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏର୍‌ଡର୍ନେମରଞ୍ଜି ପୁର୍ତିଲୋଙନ୍‌ କେନ୍‌ଆତେ ସାୟ୍‌ଲେ ବୁଲ୍ଲେତଜି; ବନ୍‌ଡ କେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ତିଆତେ ଆପେୟ୍‌ବେନ୍‌ ଜନା । ");
INSERT INTO juy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ଆର୍ପାୟ୍‌ ଆମ୍ୱେଞ୍ଜି ଆ ରାଜ୍ୟନ୍‌ ସାୟ୍‌ବା, ଆରି କେନ୍‌ଆତେଜି ନିୟ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ଏ ସନ୍ନା ଗୋସ୍ସା, ବତଙ୍‌ଡଙ୍‌ବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ତି ଆ ରାଜ୍ୟ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ଆମ୍ୱେନ୍‌ଆତେ ଇନି ଡକୋ ତିଆତେ ତମ୍‌ଲେ ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ବାଜି; ଅଙ୍ଗାତେ ଅଃନ୍ନଞିଡେ, ତିଅନ୍ତମ୍‌ ଆ ମୁନା ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ଅବ୍‌ଜାଡାବା; ଅଙ୍ଗାଲୋଙ୍‌ ରାଉମରନ୍‌ ଅଡମନ୍‌ ଇୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ ଆରି ବୋବ୍ବୋଡନ୍‌ ଅଃଜ୍ଜୋମେ, ତିଅନ୍ତମ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆ ରନ୍ନା ରୁଆଙ୍‌ଲୋଙନ୍‌ ତର୍ତୁମ୍‌ବା, ");
INSERT INTO juy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଜନ୍‌ରୋମ୍‌ବେନ୍‌ ଡକୋତେ, ମନ୍ନବେନ୍‌ ନିୟ୍‌ ତେତ୍ତେ ଡକୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“କୁଣ୍ଡୁବ୍‌ବେନ୍‌ ଆରେଡ୍ଡୁବ୍‌ ଡକୋନେତୋ ଆରି ପିଙ୍କନ୍‌ ଆତର୍‌ତର୍‌ ଡକୋନେତୋ । ");
INSERT INTO juy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ଆରି, ସାଉକାରନ୍‌ ବିବାନ୍‌ ସିଲଡ୍‌ ୟର୍ରନ୍‌ ସନଙନ୍‌ ଡେବାଡେବା ଅବ୍‌ତାଡ଼ନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ସନଙନ୍‌ ରୋରୋନ୍‌ ଆସନ୍‌ ଅଙ୍ଗା ମନ୍‌ରାଜି ଜଗେଲେ ଡକୋତଞ୍ଜି, ଆନିଞ୍ଜି ଅନ୍ତମ୍‌ ଆମ୍ୱେଞ୍ଜି ଡକୋନାବା । ");
INSERT INTO juy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ସାଉକାରନ୍‌ ଜିର୍ରେ ଅଙ୍ଗା ଆ କମ୍ୱାରିମର୍‌ଜି ଆଜଗେଜି ଇୟ୍‌ତାୟ୍‌ ଗିଜେଜି ଆନିଞ୍ଜି ସନେନ୍‌ସେନ୍‌, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆନିନ୍‌ ରେଡ୍ଡୁବ୍‌ଡାଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ତଙ୍କୁମ୍‌ଡାଲେ ଆମଙ୍‌ବାଞ୍ଜି ଜିର୍ରେ ଇୟ୍‌ତାୟ୍‌ ରୋଜୋମେଜି । ");
INSERT INTO juy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ଆରି, ଆନିନ୍‌ ତୁଙାର୍‌ ତଗଲ୍‌ଇଂ ଅଡ଼େ କମ୍‌ସିମୋଲ୍‌ ବେଡ଼ାନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଏତ୍ତେଲେ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତି ଆ କମ୍ୱାରିମର୍‌ଜି ସନେନ୍‌ସେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ବନ୍‌ଡ କେନ୍‌ଆତେ ଜନାବେନ୍‌ତୋ, ଅଙ୍ଗାବେଡ଼ା ରାଉମରନ୍‌ ଜିର୍ତାୟ୍‌, ତିଆତେ ଅସିଂମରନ୍‌ ଜନାଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଆସିଙନ୍‌ ଆ ପରୁଆ ଅନ୍ନବ୍‌ପାଲ୍‌ପାଲେ । ");
INSERT INTO juy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଅବ୍‌ଜାଡାଲନ୍‌ ଡକୋନାୟ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାବେଡ଼ା ଆନିନ୍‌ ଜିର୍ତାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେନ୍‌ ଏଃନ୍ନବ୍‌ଡିସୟେ, ତି ଆ ବନେଡ଼ା ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଜିର୍ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ବର୍ରନେ, “ଏ ପ୍ରବୁ, ଆମନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ତୁମ୍‌ ଅଡ଼େ ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବର୍ତଲେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ପ୍ରବୁନ୍‌ ଗାମେନ୍‌, “ତିଆସନ୍‌ ଗିୟ୍‌ଲେ ଓୟୋଙନ୍‌, ଆ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ମନଙ୍‌ଡମ୍‌ ଗାଗାନେନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ସାଉକାରନ୍‌ ଅଙ୍ଗା ମନ୍‌ରାଆଡଙ୍‌ ତବ୍‌ନଙ୍‌ତେ, ତିଅନ୍ତମ୍‌ ଡର୍ନେଡମ୍‌ ଆରି ବୁଡ୍ଡିଡମ୍‌ ଗୁମୁସ୍ତାନ୍‌ ଆନା ? ");
INSERT INTO juy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ସାଉକାରନ୍‌ ୟର୍ରନ୍‌ ଅଙ୍ଗା କମ୍ୱାରିମର୍‌ ତିଅନ୍ତମ୍‌ ଆର୍‌ଲୁମ୍‌ତେନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗିଜେ, ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ଞେନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନିନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆନର୍ଜେନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ତି କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ତବ୍‌ନଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ବନ୍‌ଡ ତି ଆ କମ୍ୱାରିମର୍‌ ସାଉକାରଞେନ୍‌ ଆ ଜନିର୍‌ ଡିଙ୍‌ତେ ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟ୍‌ଲେ, କମ୍ୱାରିମରଞ୍ଜି ଡ କମ୍ୱାରିବଜଞ୍ଜିଆଡଙ୍‌ ତନିଡନ୍‌ ଆସନ୍‌ ଉତନେ ଆରି ଗାଲେ ଜୋମ୍‌ଲେ ଆ ବନ୍ନୁଲନ୍‌ ଡକୋତନେ, ");
INSERT INTO juy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅଙ୍ଗା ଡିନ୍ନା ଆନିନ୍‌ ଜଗେଲେ ଅଃଡ୍ଡକୋନେ ଆରି ଅଙ୍ଗାବେଡ଼ା ଆନିନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜନାଏ, ତି ଆ ଡିନ୍ନା ଆରି ତି ଆ ବନେଡ଼ା ସାଉକାରନ୍‌ ଜିର୍ତାୟ୍‌, ଆରି ସାଉକାରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବାଗୁ ଡେୟ୍‌ଡେୟ୍‌ ଅମ୍ମେଲେ, ଏର୍‌ଡର୍ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ମାୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“ଆରି ଅଙ୍ଗା କମ୍ୱାରିମର୍‌ ଆ ସାଉକାରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ଜନାଡାଲେ ଅଃନ୍ନବ୍‌ଜାଡାନେ ଆରି ସାଉକାରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ଅନ୍ତମ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଅଃଲ୍ଲୁମେ, ଆନିନ୍‌ ଗୋଗୋୟ୍‌ ତନିଡନ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ବନ୍‌ଡ ଆନା ଏର୍‌ଜନନାନ୍‌ ତନିଡ୍‌ଜୋମନ୍‌ ଆ କାବ୍ବାଡ଼ା ଲୁମ୍‌ତେ, ଆନିନ୍‌ ଅସୋୟ୍‌ ତନିଡନ୍‌ ଞାଙ୍‌ତେ । ଆନାଆଡଙ୍‌ ଗୋଗୋୟ୍‌ ଆତିୟ୍‌ତିୟ୍‌, ଆମଙନ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ ବନେଡନ୍‌ ଡେତେ; ଆରି ମନ୍‌ରାଞ୍ଜି ଆନା ଆମଙ୍‌ ଗୋଗୋୟ୍‌ ସୋରୋପ୍ପାୟେଞ୍ଜି, ଆମଙନ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ ଡାବ୍ବିତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ଞେନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ତଗୋନ୍‌ ସନେଡନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ତିଆତେ ନମି ଡୁଡୁଏନ୍ନି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆରି ଇନି ଅଲ୍‌ସାଜିଁୟ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ବନ୍‌ଡ ଞେନ୍‌ ଅବୟ୍‌ ତବ୍ବୁବ୍‌ଡାଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାତନାୟ୍‌; ଆରି ତିଆତେ ଅଣ୍ଡ୍ରଙ୍‌ ସୁଜ୍ଜେଏନ୍‌ ଜାୟ୍‌ ଞେନ୍‌ ଏଙ୍ଗାଡାଲେ ଏର୍‌ବନ୍ତଙନ୍‌ ଡକୋନାୟ୍‌ ! ");
INSERT INTO juy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ଞେନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ସୟୁନ୍‌ ପଙ୍‌ ପାଙ୍‌ଲାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏବ୍‌ଡିସୟ୍‌ତେ ? ଇଜ୍ଜା ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇଜ୍ଜା, ଆର୍ପାୟ୍‌ ତରଙ୍‌ଆନ୍ନା ଅନମ୍ମେନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ନମିନ୍ତାନ୍‌ ମିୟ୍‌ଲିନ୍‌ ମନ୍‌ଲୟ୍‌ ମନ୍‌ରା ଡକୋଏଞ୍ଜି, ବାଗୁ ମନ୍‌ରା ୟାଗି ମନ୍‌ରା ଆ ବିରୁଦଲୋଙ୍‌, ଆରି ୟାଗି ମନ୍‌ରା ବାଗୁ ମନ୍‌ରା ଆ ବିରୁଦଲୋଙ୍‌ ତରଙ୍‌ଆନ୍ନା ଡେତଜି । ");
INSERT INTO juy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଆପେୟନ୍‌, ଆପେୟନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌, ଡାଙ୍ଗଡ଼ିଅନନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଅୟୋଙନ୍‌, ଅୟୋଙନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡାଙ୍ଗଡ଼ିଅନନ୍‌, କଉନନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ କିନାରନ୍‌, କିନାରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ କଉନନ୍‌ ତରଙ୍‌ଆନ୍ନା ଡେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ଜିସୁନ୍‌ ଆରି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବରୁବ୍‌ୟୋଙ୍‌ଗଡ୍‌ ମେଗନ୍‌ ଡୋଲନ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଗିୟ୍‌ଲୋଙ୍‌ ଗିୟ୍‌ଲେ ସିଲତ୍ତେମା ତରୁବନ୍‌ ଅଡ଼ୋତାୟ୍‌ ଏଗାମ୍‌ତେ, ଆରି ଏତ୍ତେଲେମା ଗଡେଲ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ଆରି ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ରିଙ୍ଗେନ୍‌ ଇଡେନ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଗିୟ୍‌ଲୋଙ୍‌ ଗିୟ୍‌ଲେ ଗୋଗୋୟ୍‌ ଡାଗାତେ ଏଗାମ୍‌ତେ ଆରି ଏତ୍ତେଲେମା ଗଡେଲ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ଏ ଇସ୍କତ୍ତାମର୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ରୁଆଙନ୍‌ ଡ ପୁର୍ତିନ୍‌ ଆରମ୍ମଡ୍‌ଜି ରପ୍ତି ଏଜନାତେ ବନ୍‌ଡ ନମିଜି ଆରମ୍ମଡ୍‌ଜି ଅଡ଼୍‌କୋନ୍‌ ଏଙ୍ଗାଡାଲେ ରପ୍ତି ଏଃଜ୍ଜନାଏ ?” ");
INSERT INTO juy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ଆରି ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଇନିବା ଆଜାଡ଼ି ପନ୍‌ସୁଆତିନ୍‌ ଏଃଲ୍ଲୁମେ ? ");
INSERT INTO juy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ବନେରାବେନ୍‌ ସରିନ୍‌ ପନ୍‌ସୁଆତିମରନ୍‌ ଆ ମୁକ୍କାବା ଏଜିରେନ୍‌ ଆଡିଡ୍‌ ତଙର୍‌ଲୋଙନ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ମାୟ୍‌ନାବା, ଅସମୟ୍‌ ଆନିନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ପନ୍‌ସୁଆତିମରନ୍‌ ଆମଙ୍‌ ଡିଙ୍‌ଲେ ଓରୋଙ୍‌ତବେନ୍‌, ଆରି ପନ୍‌ସୁଆତିମରନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ସିପ୍ପାୟଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତବେନ୍‌, ଆରି ସିପ୍ପାୟନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ପିଡ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆତନିକ୍କି ଡାବ୍ବୋନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏସୁଜ୍ଜାୟ୍‌ନେନ୍‌ ଜାୟ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଏଙ୍ଗାଲେଜନଙ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଏଃର୍ରପ୍ତିଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ତିଆଡିଡ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିର୍ରେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଗାଲିଲିବାଜି ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଅନମଙନ୍‌ ଆତ୍ରିୟେଞ୍ଜି ଆଡିଡ୍‌ ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ରବ୍ବୁଏଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “କେନ୍‌ ଗାଲିଲିମରଞ୍ଜି ଏନ୍ନେଗୋ ଆଡ୍ରେଏଞ୍ଜି, ଆନ୍ନା ଗାଲିଲିମରଞ୍ଜି ସିଲଡ୍‌ କେନ୍‌ଆନିଞ୍ଜି ଗୋଗୋୟ୍‌ ଇର୍ସେମର୍‌ଜି ଗାମ୍‌ଲେ ପଙ୍‌ ଏବ୍‌ଡିସୟ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ଇଜ୍ଜା, ଏତ୍ତେଲେ ତଡ୍‌, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇର୍ସେନ୍‌ ସିଲଡ୍‌ ଏନ୍ନାବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ତିଆନିଞ୍ଜି ଅନ୍ତମ୍‌ ସେଏଡାୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ଅଡ଼େ ସିଲୋଅଲୋଙନ୍‌ ଅଟର ଜଣ ମନ୍‌ରାଞ୍ଜି ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଜରଗେସିଙନ୍‌ ଲାତ୍ତିନ୍‌ଡାଲେ ଆର୍ରବୁଏଞ୍ଜି, ଆନିଞ୍ଜି ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନି ଏବ୍‌ଡିସୟ୍‌ତେ ? ଆନିଞ୍ଜି ଅଡ଼୍‌କୋ ଜିରୁସାଲମବାଜି ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ ଡୋସାମର୍‌ଜି ଗାମ୍‌ଲେ ପଙ୍‌ ଏବ୍‌ଡିସୟ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇଜ୍ଜା, ଇର୍ସେନ୍‌ ସିଲଡ୍‌ ଏନ୍ନାବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ତିଆନିଞ୍ଜି ଅନ୍ତମ୍‌ ସେଏଡାୟ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ଆରି ଜିସୁନ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବର୍ରନେ, “ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ ଦ୍ରାକ୍ୟାକୋତ୍ତାଲୋଙ୍‌ ଅବୟ୍‌ ଲୁଆନୁବନ୍‌ ଆଗୁଗୁ ଡକୋଏନ୍‌ । କୋତ୍ତାମରନ୍‌ ତେତ୍ତେ ଜିର୍ରେ ଆଜନ୍‌ ଇୟ୍‌ଲେ ସାଜେ; ବନ୍‌ଡ ଅଃଞାଙ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ତିଆସନ୍‌ ଆନିନ୍‌ ଜଗେକୋତ୍ତାମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘କେନ୍‌ଆତେ ୟାଗି ବର୍ସେଙ୍‌ ଡେଲୋ, କେନ୍‌ ଲୁଆନୁବ୍‌ଲୋଙନ୍‌ ଆଜନ୍‌ ଇୟ୍‌ତାୟ୍‌ ସାୟ୍‌ନାୟ୍‌, ବନ୍‌ଡ ଅଃଞାଙାୟ୍‌, କେନ୍‌ଆତେ ଅଡା, ଇନିବା କେନ୍‌ଆତେ ଲବନ୍‌ ଅଲ୍‌ନବ୍‌ମୋସ୍ସାଏ ?’ ");
INSERT INTO juy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ବନ୍‌ଡ ଜଗେକୋତ୍ତାମରନ୍‌ ଗାମେନ୍‌, ‘ପ୍ରବୁ, କେନ୍‌ଆତେ କେନ୍‌ ଆ ବର୍ସେଙ୍‌ ନିୟ୍‌ ଅମ୍‌ରେଙା, ତିଆଡିଡ୍‌ ଞେନ୍‌ ଏର୍ରେ ଗାୟ୍‌ଲୋଙ୍‌ ଗାୟ୍‌ଲେ ଅନ୍ତାଙିଜନ୍‌ ତିୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ଆରି ତିକ୍କି ଅଜଏନ୍‌ ଡେନ୍‌ ମନଙ୍‌, ଅଃନ୍ନଜଲୋ ଡେନ୍‌ କେନ୍‌ଆତେ ଅଡ୍‌ଲେସେଡା ।’” ");
INSERT INTO juy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌, ଅବୟ୍‌ ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ଞନଙନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ଆରି ଗିୟ୍‌ବା, ଅଟର ବର୍ସେଙ୍‌ ଜାୟ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଅବୟ୍‌ ଆଇମରନ୍‌ ତେତ୍ତେ ଡକୋଏନ୍‌ । ଆନିନ୍‌ ଆକୁଜ୍ଜି, ଏଙ୍ଗାଲନ୍‌ ଜନଙ୍‌ଡେନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଅଃର୍ରପ୍ତି ବିଙୟ୍‌ଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ, ଆମଙନ୍‌ ଓଡ୍ଡେଡାଲେ ବରେନ୍‌, “ଏ ଆଇମର୍‌ ଏର୍‌ବପ୍ପୁନମ୍‌ ସିଲଡ୍‌ ଆମନ୍‌ ଅଡ଼ୁର୍‌ଲମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ଆରି ଜିସୁନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ଆସିନ୍‌ ଡକ୍କୋଏନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତି ଆଇମରନ୍‌ ସିଲତ୍ତେମା ବୁଙଜେନ୍‌ କି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଗଙ୍କେଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ବନ୍‌ଡ ଜିସୁନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଆମ୍ରବ୍‌ନଙେନ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ଆ ସୋଡ଼ାମର୍‌ ବରାବ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଲନୁମ୍‌ନେନ୍‌ ଆସନ୍‌ ତୁଡ୍ରୁ ଡିନ୍ନା ଡକୋ, ତିଆସନ୍‌ ତିଆଡିନ୍ନା ଜିର୍ରେ ଆୟ୍‌ ମବ୍‌ନଙ୍‌ନାବା, ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଏଇୟ୍‌ଡଙାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ବନ୍‌ଡ ପ୍ରବୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଇସ୍କତ୍ତାମର୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଗୁଆଡ଼ାସିଙନ୍‌ ସିଲଡ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ତାଙ୍‌ଲିୟ୍‌ ଅଡ଼େ ଗୋଡୋଁୟନ୍‌ ପଡ୍ଡଙ୍‌ଡାଲେ ଏଃନ୍ନବ୍‌ଗାଡାଏ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଗିୟ୍‌ବା, ଅଟର ବର୍ସେଙ୍‌ ଜାୟ୍‌ ସନୁମନ୍‌ ବଣ୍ଡିଲେ ଆଡ୍ରକ୍କୋଏନ୍‌ ଅବ୍ରାମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ିଅନ୍‌ କେନ୍‌ ଆଇମର୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଆନିନ୍‌ ବଣ୍ଡିନ୍‌ ସିଲଡ୍‌ ଅଡ଼ୁରନ୍‌ ଆସନ୍‌ ଇନି ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ଆରି, ଜିସୁନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆବର୍ରନେନ୍‌, ଆ ବନେରାମରଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଗରଜେଞ୍ଜି, ବନ୍‌ଡ ଜିସୁନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ସୋଡ଼ା ସୋଡ଼ା ଆ କାବ୍ବାଡ଼ା ଗିୟ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ସର୍ଡାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ବର୍ରନେ, “ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆନା ଅନ୍ତମ୍‌ ? ଆରି, ଞେନ୍‌ ଆନା ବୟନ୍‌ ତିଆତେ ଜଙାୟ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ତିଆତେ ଅବୟ୍‌ ସୋର୍ସୋବାୟନ୍‌ ଅନ୍ତମ୍‌ । ତିଆତେ ପାଙ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ କୋତ୍ତାଲୋଙନ୍‌ ବୁଡେନ୍, ଆରି ତିଆତେ ସୋଡ଼ାଡାଲେ ଆନୁବେନ୍‌ ଆରି ରୁଆଙନ୍‌ ଆ ଅନ୍ତିଡ୍‌ଜି ଜିର୍ରେ ଆ କେଣ୍ଡାର୍‌ଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବସାନେଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ଜିସୁନ୍‌ ଆରି ବର୍ରନେ, “ଞେନ୍‌ ଆନା ବୟନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଜଙାୟ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ତିଆତେ କମିରନ୍‌ ଅନ୍ତମ୍‌, ଅବୟ୍‌ ଆଇମରନ୍‌ ତିଆତେ ପାଙ୍‌ଲେ ବକୁଡ଼ି ବାଗୁ ଆଡ୍ଡା ଆ ଗମ୍ମଲୋଙ୍‌ ମାୟ୍‌ଲେ ରୁବ୍‌ଲେ ଡକ୍କୋଏନ୍‌, ଆରି ତିକ୍କି କମିରନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ମାୟାୟ୍‌ଲନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଗଡ଼ାରେଙନ୍‌ ଡ ସାଇରେଙନ୍‌ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ଞନଙନ୍‌ ତିୟ୍‌ଗଡ୍‌ଲେ ଜିରୁସାଲମନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ଆରି ଅବୟ୍‌ନେ ଜିର୍ରେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେ, “ପ୍ରବୁ, ଅନୁରନ୍‌ ଆଞ୍ରାଙେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଅସୋୟ୍‌ ପଙ୍‌ ?” ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ରକୋଡ୍‌ ଡୁଆରାଗଡ୍‌ ଗଙ୍ଗନନ୍‌ ଆସନ୍‌ ରବୁକିଞଡ୍‌ ଲୁମ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଜବ୍ର ମନ୍‌ରାଜି ଗଙ୍ଗନନ୍‌ ଆସନ୍‌ ଏର୍‌ତଜି ଗୋୟ୍‌ତଜି, ବନ୍‌ଡ ଅଃର୍ରପ୍ତିଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ଅସିଂମରନ୍‌ ଡୋଲନ୍‌ ସନଙନ୍‌ ଇଙଡେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆମ୍ୱେଞ୍ଜି ଡୁଆରାଲୋଙନ୍‌ ତନଙ୍‌ଡାଲେ ଏଡକୋତନେ ଆରି ‘ଏ ପ୍ରବୁ, ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ସନଙନ୍‌ ରୋଲେନ୍‌’ ଗାମ୍‌ଲେ ସନଙନ୍‌ ଏତିଡ୍‌ତେ । ତିଆଡିଡ୍‌ ଆନିନ୍‌ ଜାଲଙ୍‌ତବେନ୍‌, ‘ଞେନ୍‌ ଜନା ତଡ୍‌, ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଏଜିର୍ରାୟ୍‌ !’ ");
INSERT INTO juy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଗାମ୍‌ତେ, ‘ଇନ୍‌ଲେଞ୍ଜି ତେମଡ୍‌ଲୋଙ୍‌ନମ୍‌ ଏଜୋମ୍‌ଲାୟ୍‌ ଏଗାଲାୟ୍‌, ଆରି ଆମନ୍‌ ଡାଣ୍ଡରେଙ୍‌ଲେନ୍‌ ଞନଙନ୍‌ ତିୟେନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ଆରି ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ‘ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଏଜିର୍ରାୟ୍‌, ତିଆତେ ଞେନ୍‌ ଜନା ତଡ୍‌, ଏ ଏର୍‌ଡରମ୍ମମର୍‌ଜି, ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ସବ୍‌ଙାୟ୍‌ନାବା ।’ ");
INSERT INTO juy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ଅଙ୍ଗା ଆଡିଡ୍‌ ଅବ୍ରାମନ୍‌, ଇସାକନ୍‌, ଜାକୁବନ୍‌ ଆରି ଅଡ଼୍‌କୋ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଗିୟ୍‌ତଜି, ଆରି ଆମ୍ୱେଞ୍ଜି ଡୁଆରାଲୋଙନ୍‌ ଆସେଃସେଡନ୍‌ ଏଗିୟ୍‌ଡମ୍‌ତନେ, ତିଆଡିଡ୍‌ ତେତ୍ତେ ଆମ୍ୱେଞ୍ଜି ୟେୟେଡାନ୍‌ ଡ ରମ୍‌ରମ୍‌ଜିନ୍‌ ଡେତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ଆରି, ଡରୁଙ୍‌ୟୋଙ୍‌ଗଡ୍‌ ଡ ବରୁବ୍‌ୟୋଙ୍‌ଗଡ୍‌, ଅର୍କାବଡ଼ିଗଡ୍‌ ଡ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ସିଲଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିର୍ରେ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ବୁଜିଜୋମନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତଙ୍କୁମେଜି । ");
INSERT INTO juy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ଆରି ଗିୟ୍‌ବା, ତିକ୍କିନ୍‌ ଆ ମନ୍‌ରାଜି ଲାଙ୍‌ଲେନ୍ନେ ଆମ୍ମୁଙ୍‌ତଜି ଆରି ଆମ୍ମୁଙ୍‌ମରଞ୍ଜି ଲାଙ୍‌ଲେନ୍ନେ ତିକ୍କିତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ତି ଆ ବନେଡ଼ା ଲାଙ୍‌ଲେଡ୍‌ ପାରୁସିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ତେନ୍ନେ ସିଲଡ୍‌ ଜିରା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏରୋଦନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ସାୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଜିର୍ରେ ତି ବୋଡ଼ାନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ ବର୍ବା, ‘ଗିୟ୍‌ବା, ଞେନ୍‌ ଲଙେ ଡ ବିଅଡ଼େଃ ବୁତନ୍‌ ଗଙ୍‌ତାୟ୍‌, ଆରି ମନ୍‌ରାଞ୍ଜି ମବ୍‌ନଙ୍‌ତାଜି ଆରି ଏର୍ତାଲୋଙ୍‌ କାବ୍ବାଡ଼ାଞେନ୍‌ ସାଡ୍‌ତାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ବୟ୍‌ଲେଙ୍‌, ଲଙେ, ବିଅଡ଼େଃ, ଆରି ଇଆର୍ମେ, ଞେନ୍‌ ଜିର୍ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିରୁସାଲମନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆନ୍ନାରେଙ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ଆଡଙ୍‌ ଅଃର୍ରବ୍ବୁଏଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ଏ ଜିରୁସାଲମ, ଏ ଜିରୁସାଲମ, ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ଆମନ୍‌ ସମ୍ୱବେନ୍‌, ଆରି ଅମଙ୍‌ନମ୍‌ ଆନାପ୍ପାୟ୍‌ଜିଆଡଙ୍‌ ତିଡରେନ୍‌, ଆୟୋଙିମନ୍‌ ଏଙ୍ଗାଲେ ଆ କାପ୍ପାନ୍‌ ଆ ଜାୟ୍‌ତା ଆ ଅନଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ରୁକ୍କୁତେ ତିଅନ୍ତମ୍‌ ଡିଅଙ୍ଗା ବେଡ଼ା ପସିୟ୍‌ନମ୍‌ଜିଆଡଙ୍‌ ଅନବ୍‌ରୁକ୍କୁନ୍‌ ଆସନ୍‌ ସାୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଃଲ୍ଲଡୟ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ଗିୟ୍‌ବା ସରେବାସିଂବେନ୍‌ ଅସିଲୋଙ୍‌ବେନ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଡେଏନ୍‌, ତିଆତେ ସିସିଂତେ, ଆରି ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ‘ପ୍ରବୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଆନା ଇୟ୍‌ଲାୟ୍‌ ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌,’ ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଆଡିଡ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଏବର୍ତନେ, ତିଆଡିନ୍ନା ଅଣ୍ଡ୍ରଙ୍‌ ଜିରାଞନ୍‌ ଜାୟ୍‌, ଞେନ୍‌ ଆରି ଏଃଗିଜିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଗାଗାନେନ୍‌ ଆସନ୍‌ ପାରୁସିଞ୍ଜି ସରିନ୍‌ ଅବୟ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରନ୍‌ ଆସିଂ ଇୟେଞ୍ଜି, ଆରି ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିୟ୍‌ଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ଆରି ଗିୟ୍‌ବା, ଆ ମୁକ୍କାଗଡଞ୍ଜି ଅବୟ୍‌ ଜଡ଼ୋଦର ରୋଗମରନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ସିଲତ୍ତେ ଜିସୁନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଆପଡ଼େନେମରଞ୍ଜି ଡ ପାରୁସିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି; “ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଅଡ଼େତେ ଅଡ଼େ ଇଜ୍ଜା ?” ବନ୍‌ଡ ଆନିଞ୍ଜି କଡ଼ିଙ୍‌ଲେ ସେଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ଆରି ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ମବ୍‌ନଙେନ୍‌ କି ଆପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଅଡ଼େ ତାଙ୍‌ଲିୟ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ କୁଆଲୋଙନ୍‌ ଅସେଡେନ୍‌ ଡେନ୍‌ ତି ଆ ଡିନ୍ନା ଅବ୍‌ତାଡ଼ନ୍‌ ତିଆତେ ଅଃତ୍ତବେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ଆରି, ଆନିଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ଇନ୍ନିଙ୍‌ ଜାଲଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ଆରି, କନୁଆମରଞ୍ଜି ଏଙ୍ଗାଡାଲେ ସୋଡ଼ା ସୋଡ଼ା ତରଙ୍କୁମନ୍‌ ସେଡାଏଞ୍ଜି, ତିଆତେ ଗିୟ୍‌ଲେ, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅନ୍ନିଙ୍‌ ଆ ମନ୍‌ରା ବିବା ଇଙନ୍‌ ବୁଜିଜୋମନ୍‌ ଓଡ୍ଡେତବେନ୍‌, ତିଆଡିଡ୍‌ ସୋଡ଼ା ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ଡଙ୍‌ ଏତଙ୍କୁମେ, ଅସମୟ୍‌ ଆମ୍ୱେନ୍‌ ସିଲଡ୍‌ ଆରି ଗୋଗୋୟ୍‌ ମନାନ୍ନେମର୍‌ଆଡଙ୍‌ ଆନିନ୍‌ ଅଲ୍‌ନୋଡ୍ଡେଏ, ");
INSERT INTO juy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ଆରି ଅଙ୍ଗାମର୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଲବେନ୍‌ ଆନିନ୍‌ ଜିର୍ରେ, ‘କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତରଙ୍କୁମନ୍‌ ତିୟା’ ଗାମ୍‌ଲେ ଇୟ୍‌ତାୟ୍‌ ଗାମେ, ତିଆଡିଡ୍‌ ଆମ୍ୱେନ୍‌ ଗରୟ୍‌ମଡ୍‌ଲେ ସନ୍ନା ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ତେ ଏତଙ୍କୁମେ । ");
INSERT INTO juy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ଆର୍ପାୟ୍‌ ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେତବେଞ୍ଜି, ତିଆଡିଡ୍‌ ସନ୍ନା ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ ତଙ୍କୁମ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଆରୋଡ୍ଡେଲବେନ୍‌ ଆ ମନ୍‌ରା ଜିର୍ରେ, ‘ଏ ଗଡ଼ି ସୋଡ଼ା ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ଆୟ୍‌ ତଙ୍କୁମା’ ଇୟ୍‌ତାୟ୍‌ ଗାମେ, ତିଆଡିଡ୍‌ ଆମ୍ୱେନ୍‌ ସରିନ୍‌ ଗାଗାନେନ୍‌ ଆତ୍ରଙ୍କୁମେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଆମ୍ୱେନ୍‌ ମନଙ୍‌ମର୍‌ ଗିୟ୍‌ତାତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ଅବ୍‌ସୋଡ଼ାଡମ୍‌ତନେ ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ସନ୍ନାନ୍‌ ଡେତେ, ଆରି ଆନା ଅବ୍‌ସନ୍ନାଡମ୍‌ତନେ ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ସୋଡ଼ାନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ଆରି ଜିସୁନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଗାଗାନେନ୍‌ ଆରୋଡ୍ଡେଲାଞନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ନିୟ୍‌ ବରେନ୍‌, “ତମ୍‌ବାଇଂ ଡେଏତୋ କି ତଗଲ୍‌ଇଂ ଡେଏତୋ ବୁଜିନ୍‌ ତିୟେନ୍‌ ଡେନ୍‌ ଗଡ଼ିନମ୍‌ ଅଡ଼େ କୁଲମ୍‌ନମ୍‌ ଅଡ଼େ ବୋଞାଙ୍‌ନମ୍‌ ଅଡ଼େ ଗମାଙ୍‌ ତୟ୍‌ଲିସିଂମର୍‌ନମ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଡଙ୍‌, ଅସମୟ୍‌ ଆନିଞ୍ଜି ନିୟ୍‌ ୟର୍ରେ ଆମନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେତମ୍‌ଜି ଆରି ଆମନ୍‌ ଆବ୍‌ଡିଡ୍‌ ତନିୟନ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ବନ୍‌ଡ ବୁଜିନ୍‌ ଏତିୟେନ୍‌ ଡେନ୍‌, ଡୋଲେୟ୍‌ମରଞ୍ଜି, କାନ୍ନିମରଞ୍ଜି, ସୋତ୍ତାମରଞ୍ଜି, ଡ କାଡ଼ୁମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେବାଜି; ");
INSERT INTO juy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଆସିର୍ବାଦନ୍‌ ଞାଙ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଆବ୍‌ଡିଡ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆମଙଞ୍ଜି ଇନ୍ନିଙ୍‌ ତଡ୍‌, ଆରି ଡରମ୍ମମରଞ୍ଜି ୟର୍ମେଙ୍‌ଲେ ଆଡ୍ରୋତନେଞ୍ଜି ଆଡିଡ୍‌ ଆମନ୍‌ ଆବ୍‌ଡିଡ୍‌ ତନିୟନ୍‌ ଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ତିଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଜିସୁନ୍‌ ସରିନ୍‌ ଗଗାନେନ୍‌ ଆତ୍ରଙ୍କୁମେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅଙ୍ଗା ମନ୍‌ରା ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗାଗାନେନ୍‌ ତଙ୍କୁମ୍‌ତେ ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ବମିୟ୍‌ତା ସୋଡ଼ା ବୁଜିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଅବ୍‌ଜାଡାଏନ୍‌ କି ଜବ୍ର ମନ୍‌ରାଜିଆଡଙ୍‌ ଓଡ୍ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ଆରି, ଗାଗାନେ ବେଡ଼ାନ୍‌ ଆଡ୍ରେଏନ୍‌ ଆନିନ୍‌ କନୁଆମରଞ୍ଜି ଆମଙ୍‌ବା ଆ କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ବରେଞ୍ଜି, ‘ଆମ୍ୱେଞ୍ଜି ଜିରାୟ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଜାଡାଆଜେନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ବନ୍‌ଡ ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆବସାଣ୍ଡନ୍‌ କେମାନ୍‌ ବେବ୍ବେଡନ୍‌ ଆସନ୍‌ ଉଲଞ୍ଜି । ଆମ୍ମୁଙ୍‌ ଅବୟ୍‌ନେ ବର୍ରନେ, ‘ଞେନ୍‌ ଅବୟ୍‌ କୋତ୍ତାନ୍‌ ଞିଲାୟ୍‌, ଞେନ୍‌ ତିଆତେ ଇୟ୍‌ତେ ଜଗେନାୟ୍‌; କେମାଇଂ ଞେନ୍‌ ଅଃନ୍ନିଆୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ଆରି ଅବୟ୍‌ନେ ଗାମେନ୍‌, ‘ଞେନ୍‌ ମନ୍‌ଲୟ୍‌ ରାଙଙ୍‌ ତାଙ୍‌ଲିୟନ୍‌ ଞିଲାୟ୍‌, ଆରି ଞେନ୍‌ ତିଆତେଜି ଅର୍ରେ ଗିୟ୍‌ନାୟ୍‌; କେମାଇଂ ଞେନ୍‌ ଇୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଆୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ଆରି ଅବୟ୍‌ନେ ଗାମେନ୍‌, ‘ଞେନ୍‌ ରଙ୍‌ ବିବାଲନାୟ୍‌, ତିଆସନ୍‌ ଞେନ୍‌ ଇୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଆୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ଆରି, ତି ଆ କମ୍ୱାରିମର୍‌ ୟର୍ରନ୍‌ ଆ ସାଉକାରନ୍‌ ଆମଙ୍‌ ତି ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଅବ୍‌ଜନାଏ । ସିଲତ୍ତେ ଅସିଂମରନ୍‌ ବରାବେନ୍‌ କି ଆ କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଲଜିର୍‌ଡାଲେ ଗଡ଼ାନ୍‌ ଆ ଡାଣ୍ଡରେଙ୍‌, ରକୋଡ୍‌ ତଙର୍‌ଗଡ୍‌ରେଙନ୍‌ ଡୋଲେୟ୍‌ମରଞ୍ଜି, କାନ୍ନିମରଞ୍ଜି, ସୋତ୍ତାମରଞ୍ଜି, କାଡ଼ୁମରଞ୍ଜିଆଡଙ୍‌ ତେନ୍ନେ ଓଡ୍ଡେଲେ ଇୟ୍‌ନୋରୋଙାଜି ।’ ");
INSERT INTO juy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ତିକ୍କି ତି କମ୍ୱାରିମରନ୍‌ ଗାମେନ୍‌, ‘ଏ ସାଉକାର ବର୍ନେନମ୍‌ ଅନ୍ତମ୍‌ ଲନୁମନ୍‌ ଡେଏନ୍‌, ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଆରି ତରଙ୍କୁମମନ୍‌ ଡକୋ ।’ ");
INSERT INTO juy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ସିଲତ୍ତେ ସାଉକାରନ୍‌ ତି କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଅସିଂଞେନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅଲ୍‌ବରିଜେ ତିଆସନ୍‌ ରୋତ୍ତରେଙନ୍‌ ଡ କୋତ୍ତାରେଙନ୍‌ ଜିର୍ରେ ବୁଜିଜୋମନ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ ବରାଜି ।’ ");
INSERT INTO juy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ତି ଅନୋଡ୍ଡେନ୍‌ ଆଡ୍ରେଏନ୍‌ ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଜାକିଁୟ୍‌ ବୁଜିଞେନ୍‌ ମାୟ୍‌ମାୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଏଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ବମିୟ୍‌ତା ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆରି ଜିସୁନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ଆନା ଜନଙ୍‌ଡେନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଜିର୍ରେ ଆପେୟନ୍‌, ଅୟୋଙନ୍‌, ଡୁକ୍ରିନ୍‌, ପସିଜନ୍‌, ବୋଞାଙନ୍‌ ଆରି ତନାନନ୍‌ ଏତ୍ତେଲେ ଡ ଆ ପରାନ୍ନାଡମନ୍‌ ଜାକିଁୟ୍‌ ଅଃମ୍ମୁର୍ସେଏ, ଆନିନ୍‌ ଞଙ୍‌ନେମର୍‌ଞେନ୍‌ ଡେଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ଆନା ଜନଙ୍‌ଡେନ୍‌ ଆଅକ୍କାଡଙନ୍‌ ବୋୟ୍‌ଲେ ଞେନ୍‌ଆଡଙ୍‌ ଅଃସଣ୍ଡୋଙ୍‌ଲିଁୟ୍‌ ଡେନ୍‌, ଆନିନ୍‌ ଞଙ୍‌ନେମର୍‌ଞେନ୍‌ ଡେଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଆନା ମେଡ଼ସିଙନ୍‌ ତୁବ୍‌ତୁବନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ଡାଲେ ତିଆତେ ଅନବ୍‌ସୁଜ୍ଜେନ୍‌ ଜାୟ୍‌ ଡିଅଙ୍ଗା ଡାବ୍ବୋନ୍ କର୍ସ ଡେତେ, ଆରି ଆମଙନ୍‌ ଡିୟ୍‌ତେ ଡାବ୍ବୋନ୍‌ ଡକୋ ଅଡ଼େ ଇଜ୍ଜା, ଆମ୍ମୁଙ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ତିଆତେ ଅଃଡ୍ଡିଡିଏ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ଅସମୟ୍‌ ଆନିନ୍‌ ଡିଆତାଲନ୍‌ ଗୁଲୁଙ୍‌ଗୁଲେ ତିଆତେ ଅବ୍‌ସୁଜ୍ଜେଲେ ଅଃର୍ରପ୍ତିଲୋ ଡେନ୍‌, ଡିଅଙ୍ଗା ମନ୍‌ରା ତିଆତେ ଗିୟ୍‌ତଜି, ଅଡ଼୍‌କୋଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସୟ୍‌ସୟ୍‌ମୁଲେ ବର୍ତଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘କେନ୍‌ ଆ ମନ୍‌ରା ଗୁସିଙନ୍‌ ଉଲନ୍‌ କି ଅବ୍‌ସୁଜ୍ଜେଲେ ଅଃର୍ରପ୍ତିଲୋ ।’ ");
INSERT INTO juy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ଅବୟ୍‌ ରାଜାନ୍‌ ଦସ ଅଜାର ସିପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଆ ବିରୁଦଲୋଙନ୍‌ ବକୁଡ଼ି ଅଜାର ସିପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଅଲ୍‌ତିଡ୍‌ବାନ୍‌ ଆରିୟ୍‌ତାଞନ୍‌ ଆ ରାଜା ବୟନ୍‌ ଅଲ୍‌ତିଡନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ବୋର୍ସାନ୍‌ ଡକୋ ଅଡ଼େ ଇଜ୍ଜା, ତଙ୍କୁମ୍‌ଡାଲେ ଆମ୍ମୁଙ୍‌ ତିଆତେ ଅଃନ୍ନିୟମେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ଅଃର୍ରପ୍ତିଲୋ ଡେନ୍‌, ଆନ୍ନା ଆ ରାଜା ସଙାୟ୍‌ଲୋଙ୍‌ ଡକୋନ୍‌ ଆଡିଡ୍‌ ମା ରାଜିନାମା ଏମ୍ମେନେନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଅାକାଲ୍‌ତିମରନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ତିଅନ୍ତମ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଆନା ଜନଙ୍‌ଡେନ୍‌ ଆନିନ୍‌ଡମ୍‌ଆତେ ଅଡ଼୍‌କୋନ୍‌ ଅଃନ୍ନମ୍‌ରେଙେ, ଆନିନ୍‌ ଞଙ୍‌ନେମର୍‌ଞେନ୍‌ ଡେଲେ ଅଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ବସିଡନ୍‌ ତ ଲଗଡ଼; ବନ୍‌ଡ ବସିଡନ୍‌ ନିୟ୍‌ ମରେଡ୍‌ ତଡ୍‌ ଡେନ୍‌, ତିଆତେ ଏଙ୍ଗାଲେ ମବ୍‌ରେଡ୍‌ତବୋ ? ");
INSERT INTO juy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ତିଆତେ ଲବନ୍‌ ଆସନ୍‌ ଅଡ଼େ ଲନାସଙ୍‌ତାଙନ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌; ମନ୍‌ରାଞ୍ଜି ତିଆତେ ଡୁଆରାନ୍‌ ସେଡ୍‌ତଜି । ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଆନା ଅଲୁଡନ୍‌ ଡକୋ, ଆନିନ୍‌ ଅମ୍‌ଡଙେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ବମିୟ୍‌ତା, ପାନୁବେଡ୍‌ମରଞ୍ଜି ଡ ଇର୍ସେମରଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଜିସୁନ୍‌ ଆ ବର୍ନେ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ସିଲତ୍ତେ ପାରୁସିଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଡୋସେଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆ ମନ୍‌ରା ଇର୍ସେମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ତନେ ଆରି ଆନିଞ୍ଜି ସରିନ୍‌ ଗାଗାତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ମନ୍‌ରା ଆନା ଡକୋ, ଆମଙନ୍‌ ବସଅ ମେଣ୍ଡାନ୍‌ ଡକୋତେ, ଆରି ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ଆଡ଼ଏନ୍‌ ଡେନ୍‌, ଆନିନ୍‌ ଅନେସ୍ୱତଆତେ ପଡ଼ିଆଲୋଙନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ତି ଆରାଡ଼ଏନ୍‌ ଆ ମେଣ୍ଡା ଅଣ୍ଡ୍ରଙ୍‌ ଞାଙେନ୍‌ ଜାୟ୍‌ ଅଃନ୍ନେସାଜେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ଆରି ଆନିନ୍‌ ତିଆତେ ଞାଙେନ୍‌ ଡେନ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ଆ ତାରଙ୍‌ଲୋଙନ୍‌ ବୋୟ୍‌ଲେ ଅସିଙନ୍‌ ପାଙ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ଆରି ଆ ଗଡ଼ିଞ୍ଜି ଡ ତୟ୍‌ଲିସିଂମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଲେ ଅବ୍‌ରୁକ୍କୁଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବର୍ତଜି, ‘ଞେନ୍‌ ସରିନ୍‌ ସର୍ଡାନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମେଣ୍ଡାଞେନ୍‌ ଆରାଡ଼ଏନ୍‌ଆତେ ଞେନ୍‌ ଞାଙ୍‌ଲାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ତିଅନ୍ତମ୍‌ ଆନାଜି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନେନ୍‌ ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌, କେନ୍‌ ଅନ୍ତମ୍‌ ଅନେସ୍ୱତ ଡରମ୍ମମରଞ୍ଜି ସିଲଡ୍‌, ଆର୍ପାୟ୍‌ ଆନା ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିତନେ, କେନ୍‌ ଅନ୍ତମ୍‌ ଅବୟ୍‌ ଇର୍ସେମରନ୍‌ ଆସନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଗୋଗୋୟ୍‌ ସର୍ଡାନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ଇଜ୍ଜାନ୍‌ଡେନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଅଙ୍ଗା ଆଇବୟ୍‌ ଡକୋ, ଆମଙନ୍‌ ଦସଟା ଗୁଣ୍ଡାଡାବନ୍‌ ଡକୋତେ, ଆରି ତେତ୍ତେ ସିଲଡ୍‌ ଅବୟ୍‌ ଆଡ଼ଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ପିଙ୍କନ୍‌ ତର୍ରେ ଅସିଙନ୍‌ ଜଜଡାଲେ ତିଆତେ ଅଣ୍ଡ୍ରଙ୍‌ ଞାଙେନ୍‌ ଜାୟ୍‌ ଜୁବାୟ୍‌ଡାଲେ ଅଃସାଜେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ଆରି, ଆନିନ୍‌ ତିଆତେ ଞାଙେନ୍‌ ଡେନ୍‌ ଆ ଗଡ଼ିଞ୍ଜି ଡ ତୟ୍‌ଲିସିଂମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଲେ ଅବ୍‌ରୁକ୍କୁଲନ୍‌ ବର୍ତନେ, ‘ଞେନ୍‌ ସରିନ୍‌ ସର୍ଡାନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗୁଣ୍ଡାଡାବ୍‌ଞେନ୍‌ ଆରାଡ଼ଏନ୍‌ଆତେ ଞେନ୍‌ ଞାଙ୍‌ଲାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ତିଅନ୍ତମ୍‌ ଆନା ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିତନେ, କେନ୍‌ ଅନ୍ତମ୍‌ ଅବୟ୍‌ ଇର୍ସେମରନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ଜି ସର୍ଡାତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଜିସୁନ୍‌ ଆରି ବର୍ରନେ, “ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ବାଗୁ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ଆ ସନ୍ନା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଗାମେନ୍‌, ‘ଆପେୟ୍‌, ଅଙ୍ଗା ଆନର୍ଜେଜି ବନ୍ତାଲୋଙ୍‌ଞେନ୍‌ ପଡ଼େତେ ତିଆତେ ଞେନ୍‌ଆଡଙ୍‌ ତିୟିଁୟ୍‌ ।’ ସିଲତ୍ତେ ଆପେୟନ୍‌ ଅନର୍ଜେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବନ୍ତାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ଅସୋୟ୍‌ ଡିନ୍ନା ଆ ତିକ୍କି ସନ୍ନା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅବ୍‌ରୁକ୍କୁଡାଲେ ତମେନ୍‌ କି ସଙାୟ୍‌ ଡେସାନ୍‌ ଜିରେନ୍‌, ଆରି ତେତ୍ତେ ପରାନ୍‌ସାତ୍ତିନ୍‌ ଆ କାବ୍ବାଡ଼ା ଲୁମ୍‌ଲେ ଆ ଡାବ୍ବୋନ୍‌ କର୍ସଆଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ବନ୍‌ଡ ଅଡ଼୍‌କୋନ୍‌ ଆକ୍ରର୍ସଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତି ଆ ଡେସାଲୋଙ୍‌ କାନ୍ତାରାନ୍‌ ଆରଡ଼ୋଲାଞନ୍‌ ଆନିନ୍‌ ସନାୟ୍‌ସାୟ୍‌ଡାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ତିଆସନ୍‌ ଆନିନ୍‌ ତି ଆ ଡେସାଲୋଙ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲେ ଡକୋନେ, ଆରି ତି ଆ ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ କିମ୍ୱୋନଞ୍ଜି ତୁର୍‌ତୁରନ୍‌ ଆସନ୍‌ ପଡ଼ିଆନ୍‌ ଆପ୍ପାୟେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ଆରି, କିମ୍ୱୋନଞ୍ଜି ଅଙ୍ଗା ଜାୟ୍‌ତକୋର୍‌ ଜୋମେଞ୍ଜି, ତିଆତେ ଜୋମ୍‌ଲେ ଆ କିମ୍ପୋଙନ୍‌ ଅନବ୍‌ବୋଓନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଲଡଜେନ୍‌, ବନ୍‌ଡ ଆନ୍ନିଙ୍‌ଜା ଆନିନ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଅଃତ୍ତିୟ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ବନ୍‌ଡ ଆନିନ୍‌ ଆୟ୍‌ତନଡମ୍‌ଲନ୍‌ ବର୍ରନେ, ‘ଆପେୟ୍‌ଞେନ୍‌ ଆ କମ୍ୱାରିମର୍‌ଜି ଆ ଜନୋମ୍‌ଜୋମ୍‌ ଡିଅଙ୍ଗାତି ଲାଗାତେ, ବନ୍‌ଡ ଞେନ୍‌ ତେନ୍ନେ ଡୋଲେଜନ୍‌ ବାତ୍ତେ ରବୁତିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ଞେନ୍‌ ଡୋଲନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆମଙ୍‌ ଜିର୍ତେ ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ବର୍ନାୟ୍‌, ଆପେୟ୍‌, ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ନମ୍‌ ଇର୍ସେନ୍‌ ଲୁମ୍‌ଲାୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ଗାମ୍‌ଲେ ଅନୋଡ୍ଡେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଆରି ଜିଞ୍ଜିନ୍‌ ତଡ୍‌; ଞେନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ କମ୍ୱାରିନମ୍‌ ଅନ୍ତମ୍‌ ଡକ୍କୋଇଂ ।’ ");
INSERT INTO juy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ସିଲତ୍ତେ ଆନିନ୍‌ ଡୋଲନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ଜିରେନ୍‌ ।” “ବନ୍‌ଡ ଆନିନ୍‌ ସଙାୟ୍‌ଲୋଙ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଆଡିଡ୍‌ ମା ଆପେୟନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଆର୍ଗୁଡ଼ିଡାଏନ୍‌ ଆରି ଇର୍ରେ ଇୟ୍‌ଲେ କୋଣ୍ଡୋଡାଲେ ଜୋର୍ଜୋରେ । ");
INSERT INTO juy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗାମେନ୍‌, ‘ଆପେୟ୍‌, ଇସ୍ୱରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ନମ୍‌ ଞେନ୍‌ ଇର୍ସେନ୍‌ ଲୁମ୍‌ଲାୟ୍‌, ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ଗାମ୍‌ଲେ ଅନୋଡ୍ଡେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଆରି ଜିଞ୍ଜିନ୍‌ ତଡ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ବନ୍‌ଡ ଆପେୟନ୍‌ ଆ କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ‘ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ମନଙ୍‌ ଅଙ୍ଗିନ୍‌ ଲପାଙ୍‌ଲେ କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ରବା, କେନ୍‌ ଆ ଅଣ୍ଡେର୍‌ସିଲୋଙନ୍‌ ଏନ୍‌ସିନ୍‌ ଡ ତାଲ୍‌ଜଙ୍‌ଲୋଙନ୍‌ ପାଣ୍ଡୋୟନ୍‌ ଅବ୍‌ରବା, ");
INSERT INTO juy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ଆରି ଅବୟ୍‌ ଜେଲ୍‌ଜେଲ୍‌ ଜନ୍ତୁନ୍‌ ପାଙ୍‌ଲେ ରବ୍ବୁବା, ୟବା, ଇନ୍‌ଲେଞ୍ଜି ଗାଲେ ଜୋମ୍‌ଲେ ଏସର୍ଡାନେବା । ");
INSERT INTO juy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ ରବୁଏନ୍‌, ବନ୍‌ଡ ଅମେଙେନ୍‌, ଆଡ଼ଏନ୍‌ ବନ୍‌ଡ ଆରି ଞାଙ୍‌ଲାୟ୍‌ ।’ ତିଆସନ୍‌ ଆନିଞ୍ଜି ସର୍ଡାଲଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ତିଆଡିଡ୍‌ ଆ ସୋଡ଼ା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ କୋତ୍ତାନ୍‌ ଡକୋଲାୟ୍‌ । ଆନିନ୍‌ ଅସିଙନ୍‌ ଆ ତୁୟାୟ୍‌ ଆତ୍ରୁଙ୍‌ଲାଞନ୍‌ ଆଡିଡ୍‌, ଡେବ୍‌ତୁଙନ୍‌ ଡ ତଙ୍‌ସେଙନ୍‌ ଆ ସନଡ୍ଡା ଅମ୍‌ଡଙ୍‌ଡାଲେ, ");
INSERT INTO juy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","କମ୍ୱାରିମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ଆମଙନ୍‌ ଓଡ୍ଡେଡାଲେ ବରେନ୍‌, ‘କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଇନି ?’ ");
INSERT INTO juy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","କମ୍ୱାରିମରନ୍‌ ଗାମେନ୍‌, ‘ବୋଞାଙ୍‌ନମ୍‌ ୟର୍ରନାୟ୍‌, ଆରି ଆପେୟ୍‌ନମ୍‌ ବୋଞାଙ୍‌ନମ୍‌ଆଡଙ୍‌ ଆସୁକ୍କା ଆଞ୍ରାଙେନ୍‌ ଅବୟ୍‌ ଜେଲ୍‌ଜେଲ୍‌ ଜନ୍ତୁନ୍‌ ରବ୍ବୁଏନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ସିଲତ୍ତେ ଆନିନ୍‌ ବରାବ୍‌ଡାଲନ୍‌ ଅମ୍ମସିଙନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ଅଃଲ୍ଲଡୟ୍‌ଲୋ; ବନ୍‌ଡ ଆପେୟନ୍‌ ଡୁଆରାନ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ମବ୍‌ଲଞେ । ");
INSERT INTO juy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ବନ୍‌ଡ ଆନିନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, ‘ଗିଜା, ଡିୟ୍‌ନେ ବର୍ସେଙ୍‌ ଡେଲୋ ଞେନ୍‌ କମ୍ୱାରିନମ୍‌ ଅନ୍ତମ୍‌ କାବ୍ବାଡ଼ାତନାୟ୍‌, ଆରି ଆଙ୍ଗିୟ୍‌ ଓୟ୍‌ଲେ ବର୍ନେନମ୍‌ ଅଃନ୍ନାଲ୍ଲେଲାୟ୍‌, ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଗଡ଼ିଞେଞ୍ଜି ସରିନ୍‌ ସର୍ଡାନେନ୍‌ ଆସନ୍‌ ଆଙ୍ଗିୟ୍‌ ଓୟ୍‌ଲେ ଆମନ୍‌ ବୋଡ୍ଡାମେଡ୍‌ ନିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ତିୟିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ବନ୍‌ଡ କେନ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ଅଙ୍ଗାତେ ଜୁଣ୍ଡଡ଼ିବଜଞ୍ଜି ସରିନ୍‌ ଅନର୍ଜେନମ୍‌ଜି ଅଡ଼୍‌କୋନ୍‌ କର୍ସଆଜେନ୍‌, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆନିନ୍‌ ୟର୍ରନାୟ୍‌, ତିଆଡିଡ୍‌ ଆମନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଜେଲ୍‌ଜେଲ୍‌ ଜନ୍ତୁନ୍‌ ରବ୍ବୁଏନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ସିଲତ୍ତେ ଆପେୟନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଏ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଆମନ୍‌ ଡିତାନ୍‌ ଞେନ୍‌ ସରିନ୍‌ ଡକୋତନେ, ଆରି ଅଙ୍ଗାତେ ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ଆତେ, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆମନ୍‌ଆତେ; ");
INSERT INTO juy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ବନ୍‌ଡ କେନ୍‌ ବୋଞାଙ୍‌ନମ୍‌ ରବୁଏନ୍‌ବନ୍‌ ଆରି ଅମେଙେନ୍‌, ଆଡ଼ଏନ୍‌ ବନ୍‌ ଆରି ଞାଙ୍‌ଲବୋ, ତିଆସନ୍‌ ମଅଁୟ୍‌ଡାଲନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଏସର୍ଡାନେବା ।’” ");
INSERT INTO juy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅବୟ୍‌ ଗମାଙ୍‌ମରନ୍‌ ଡକୋଏନ୍‌; ଆ ଗୁମୁସ୍ତାନ୍‌ ଅବୟ୍‌ ଡକୋଏନ୍‌, ଆରି ତି ଗମାଙ୍‌ମରନ୍‌ ଆନର୍ଜେଜି ଗୁମୁସ୍ତାନ୍‌ ଅବ୍‌ମୋସ୍ସାଆୟ୍‌ତେ ଗାମ୍‌ଲେ ଗମାଙ୍‌ମରନ୍‌ ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ ଗୁମୁସ୍ତାନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","‘ଞେନ୍‌ ଆମନ୍‌ ଆସନ୍‌ ଇନି ଆ ବର୍ନେ କେନ୍‌ ଅମ୍‌ଡଙ୍‌ତାୟ୍‌ ? ଗୁମୁସ୍ତା କାବ୍ବାଡ଼ାନ୍‌ ଆ ଇସାବ ତିୟିଁୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ଆରି ଗୁମୁସ୍ତାଲନ୍‌ ଡକୋଲନ୍‌ ଅଃର୍ରପ୍ତିଏ ।’ ");
INSERT INTO juy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ସିଲତ୍ତେ ତି ଗୁମୁସ୍ତାନ୍‌ ଇୟମେନ୍‌, ‘ଇନି ଏଙ୍ଗାନାୟ୍‌ ? ସାଉକାରଞେନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ଗୁମୁସ୍ତା କାବ୍ବାଡ଼ାନ୍‌ ରୁୟ୍‌ଲେ ପାଙ୍‌ତିଁୟ୍‌ । ଲବନ୍‌ ଗାୟ୍‌ଗାୟନ୍‌ ଆସନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ବପ୍ପୁ ତଡ୍‌, ବେଡ୍‌ବେଡ୍‌ନେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଗରୟ୍‌ଡାତିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ଞେନ୍‌ ଗୁମୁସ୍ତା କାବ୍ବାଡ଼ାନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ମନ୍‌ରାଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆସିଙଞ୍ଜି ଓଡ୍ଡେଇଁୟ୍‌ଜି, ତିଆସନ୍‌ ଞେନ୍‌ ଇନି ଏଙ୍ଗାନାୟ୍‌ ତିଆତେ ଜନାଲାୟ୍‌ନି ।’” ");
INSERT INTO juy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“ଆରି, ଆନିନ୍‌ ଆ ସାଉକାରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ସାଉନ୍‌ ଆପ୍ରାଙେଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆମଙନ୍‌ ଓଡ୍ଡେଡାଲେ ଆମ୍ମୁଙ୍‌ମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ସାଉକାରଞେନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଆମନ୍‌ ଡିଅଙ୍ଗା ସାଉନ୍‌ ପାଙେନ୍‌ ?’ ଆନିନ୍‌ ଗାମେନ୍‌ ‘ବସଅ ଆଡ୍ଡା ଅଲିବ୍‌ ମିଞଲ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ଗୁମୁସ୍ତାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ବାସାଅଲ୍‌ନମ୍‌ ପାଙ୍‌ଲେ ପଚାସ ଗାମ୍‌ଲେ ଇଡା ।’ ");
INSERT INTO juy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ବରେନ୍‌, ‘ଅମଙ୍‌ନମ୍‌ ଡିଅଙ୍ଗା ସାଉନ୍‌ ?’ ଆନିନ୍‌ ବର୍ରନେ, ‘ବସଅ ମାଡ଼ିୟ୍‌ ଗମ୍ମ ।’ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ବାସାଅଲ୍‌ନମ୍‌ ପାଙ୍‌ଲେ ଅସିଏ ଗାମ୍‌ଲେ ଇଡା ।’” ");
INSERT INTO juy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“ତି ଏର୍‌ଡର୍ନେ ଗୁମୁସ୍ତାନ୍‌ ବୁଡ୍ଡିନ୍‌ ବାତ୍ତେ କାବ୍ବାଡ଼ାନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆସନ୍‌ ଆ ସାଉକାରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସେଙ୍କେଏନ୍‌, ତିଆସନ୍‌ କେନ୍‌ ନମିଜି ଆ ମନ୍‌ରାଜି, ସାଆରନ୍‌ ଆ ମନ୍‌ରାଜି ସିଲଡ୍‌ ଆ ମନ୍‌ରାଞ୍ଜି ସରିନ୍‌ ଗୋଗୋୟ୍‌ ବୁଡ୍ଡିନ୍‌ ବାତ୍ତେ ଞଣ୍ଡ୍ରମ୍‌ତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ପୁର୍ତିନ୍‌ ଆ ରନ୍ନାଲୋଙ୍‌ ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ଗଡ଼ିନ୍‌ ଞାଙ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଅଞିଡେନ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆଡ୍ରକୋନେଲୋଙ୍‌ ଅନୋରୋଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ଆନା ସନ୍ନା କାବ୍ବାଡ଼ାଲୋଙନ୍‌ ଡର୍ନେଡମ୍‌, ଆନିନ୍‌ ସୋଡ଼ା କାବ୍ବାଡ଼ାଲୋଙନ୍‌ ନିୟ୍‌ ଡର୍ନେଡମ୍‌, ଆରି ଆନା ସନ୍ନା କାବ୍ବାଡ଼ାଲୋଙନ୍‌ ଏର୍‌ଡର୍ନେ, ଆନିନ୍‌ ସୋଡ଼ା କାବ୍ବାଡ଼ାଲୋଙନ୍‌ ନିୟ୍‌ ଏର୍‌ଡର୍ନେ । ");
INSERT INTO juy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ତିଆସନ୍‌, ପୁର୍ତିନ୍‌ ଆ ରନ୍ନାଲୋଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଡର୍ନେଡମ୍‌ ଏଃଡ୍ଡକୋଲନ୍‌ ଡେନ୍‌, ଆନା ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଡର୍ରନ୍‌ ଆଜାଡ଼ି ରନ୍ନାନ୍‌ ଅସିଲୋଙ୍‌ବେନ୍‌ ଅଲ୍‌ତିୟ୍‌ବେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ଆରି, ଆମ୍ୱେଞ୍ଜି ଆନ୍ନାମରନ୍‌ ଆ ରନ୍ନାଲୋଙ୍‌ ଡର୍ନେଡମ୍‌ ଏଃଡ୍ଡକୋଲନ୍‌ ଡେନ୍‌; ଆନା ଆମ୍ୱେନ୍‌ଆଡଙ୍‌ ଡର୍ରନ୍‌ ରନ୍ନାଡମ୍‌ବେନ୍‌ ଅସିଲୋଙ୍‌ବେନ୍‌ ଅଲ୍‌ତିୟ୍‌ବେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ଅନ୍ନିଙ୍‌ ଆ କମ୍ୱାରିମର୍‌ ବାଗୁ ସାଉକାରନ୍‌ ଆ କମ୍ୱାରିମର୍‌ ଅଃର୍ରପ୍ତି ଡେଏ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତେ, ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ଅବୟ୍‌ନେ ଆ ବର୍ନେ ମାନ୍ନେତେ ଆରି ଅବୟ୍‌ନେ ଆ ବର୍ନେ ଆଲ୍ଲେତେ । ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଡ ରନ୍ନାନ୍‌ ବାଗୁଞ୍ଜି ଆ କମ୍ୱାରିମର୍‌ ଅଃର୍ରପ୍ତି ଡେବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ରନ୍ନାମଡ୍‌ ପାରୁସିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗବ୍‌ରଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନାଜି ଆନିଞ୍ଜିଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ ଡରମ୍ମମର୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ତୁୟ୍‌ତଞ୍ଜି, ଆମ୍ୱେଞ୍ଜି ତିଅନ୍ତମ୍‌ ଆ ମନ୍‌ରାଜି, ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଉଗର୍‌ବେଞ୍ଜି ଜନାତେ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାତେ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସୋଡ଼ା, ତିଆତେ ଇସ୍ୱରନ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ବନାଁୟ୍‌ବରନ୍‌ ଡ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ଡରମ୍ମ ସାସ୍ତ୍ର ଜନନ୍‌ ଆ ଡିନ୍ନା ଜାୟ୍‌ ଞନଣ୍ଡ୍ରମନ୍‌ ଡେଏନ୍‌, ତି ଆ ବନେଡ଼ା ସିଲଡ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଡେତେ, ଆରି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ବପ୍ପୁଞ୍ଜି ବାତ୍ତେ ତେତ୍ତେ ଗନ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ବନ୍‌ଡ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ବ ତନିଙ୍କାୟ୍‌ ଆପ୍ରଞିଡ୍‌ତେନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ରୁଆଙନ୍‌ ଡ ପୁର୍ତିନ୍‌ ଆରଞିଡ୍‌ତେନ୍‌ ସଜ ।” ");
INSERT INTO juy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ଅଙ୍ଗା ମନ୍‌ରା ଆ ଡୁକ୍ରିନ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ଆନ୍ନାବୟ୍‌ ସରିନ୍‌ ବିବାତନେ, ଆନିନ୍‌ ଡାରିତନେ; ଆରି, ଆନା ଆଡୁଙ୍‌ନେବଜନ୍‌ ସରିନ୍‌ ବିବାତନେ, ଆନିନ୍‌ ଡାରିତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“ଅବୟ୍‌ ଗମାଙ୍‌ମରନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ମଡ଼ଗା ମଡ଼ଗା ଆ ଅଙ୍ଗି ରଲନ୍‌ ଡିତାନ୍‌ ଉଗୁରିୟ୍‌ ଗାଲେ ଜୋମ୍‌ଲେ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ଆରି ତି ଗମାଙ୍‌ମରନ୍‌ ଆ ଡୁଆରାଲୋଙ୍‌ ଲାଜାର୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ବେବ୍ବେଡ୍‌ନେମରନ୍‌ ଡକୋଏନ୍‌, ସମ୍ପରା ଆ ଡଅଙନ୍‌ ଆଅମ୍ପସୁ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ଆନିନ୍‌ ତି ଗମାଙ୍‌ମରନ୍‌ ଆ ମେଜଲୋଙ୍‌ ସିଲଡ୍‌ ଆରସେଡେନ୍ ଆ ସଙ୍କୁରାଜି ଜୋମ୍‌ଲେ ଆ କିମ୍ପୋଙନ୍‌ ଅନବ୍‌ବୋଓନ୍‌ ଆସନ୍‌ ଆସାଲନ୍‌ ଡକୋଲନ୍‌; ଆରି, କିନ୍‌ସଡଞ୍ଜି ନିୟ୍‌ ଆ ଡଅଙନ୍‌ ଆ ଅମ୍ପସୁଜି ଇୟ୍‌ଲାୟ୍‌ ଜାଲ୍‌ଜାଲ୍‌ଲେଜି । ");
INSERT INTO juy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ଡିଅଙ୍ଗା ଡିନ୍ନା ଜିରେନ୍‌ କି ତି ବେବ୍ବେଡ୍‌ନେମରନ୍‌ ରବୁଏନ୍‌ ଆରି ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍ରାମନ୍‌ ଆମଙ୍‌ ଓରୋଙେଞ୍ଜି; ତିକ୍କି ତି ଗମାଙ୍‌ମରନ୍‌ ନିୟ୍‌ ରବୁଏନ୍‌, ଆନିନ୍‌ ତିଲେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ଆରି, ଗମାଙ୍‌ମରନ୍‌ ତଗୋସିଂଲୋଙନ୍‌ ତପଡ୍‌ଲଗୋ ଆଡ୍ରେଏନ୍‌ ଆଡିଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆରାଙାଙେନ୍‌, ସଙାୟ୍‌ଲୋଙ୍‌ ଅବ୍ରାମନ୍‌ ଆରି ଆମଙନ୍‌ ଲାଜାରନ୍‌ଆଡଙ୍‌ ଗିଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ସିଲତ୍ତେ ଆନିନ୍‌ ଓଡ୍ଡେଲେ ବର୍ରନେ, ‘ଏ ଆପେୟ୍‌, ଅବ୍ରାମ, ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମ୍‌ଡାଲେ ଲାଜାରନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟାୟ୍‌, ଆରି ଆନିନ୍‌ ଜିର୍ରେ ଆ ଅଣ୍ଡେର୍‌ସିନ୍‌ ଡାଆଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାଲେ ବତନିଙ୍କାୟ୍‌ ଅଲାଙ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଜବ୍‌ତଡ୍‌ଲେ ଆୟ୍‌ ସବ୍‌ୟୁଇଁୟ୍‌ତୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ତେନ୍ନେ ତଗୋଲୋଙନ୍‌ ତପଡ୍‌ଲଗୋ ଡେତିଁୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ବନ୍‌ଡ ଅବ୍ରାମନ୍‌ ଗାମେନ୍‌, ‘ଏ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଅନମେଙନ୍‌ ଆଡିଡ୍‌ ଆମନ୍‌ ମନଙଞ୍ଜିଆତେ ଅଡ଼୍‌କୋନ୍‌ ଞାଙେନ୍‌, ଆରି ଲାଜାରନ୍‌ ତିଅନ୍ତମ୍‌ ପରାନ୍‌ସାତ୍ତିନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଞାଙେନ୍‌, କେନ୍‌ଆତେ ମନ୍ନେଆ; ବନ୍‌ଡ ଆନିନ୍‌ ନମି କେନ୍‌ତେନ୍ନେ ବନବ୍‌ୟୋନ୍‌ ଞାଙ୍‌ତେ, ଆରି ଆମନ୍‌ ତପଡ୍‌ଲଗୋ ଡେତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଡରକୋନେନମ୍‌ ଡ ଡରକୋନେଲେନ୍‌ ଆ ମଡ୍ଡିଲୋଙ୍‌ ଜରୁଡମ୍‌ ଆ ଲୋଓଙ୍‌ ଡକୋ, ତିଆସନ୍‌ ଆନାଜି ତେନ୍ନେ ସିଲଡ୍‌ ଅମଙ୍‌ବେନ୍‌ ଜିର୍‌ଜିରନ୍‌ ସାୟ୍‌ତଜି, ଆନିଞ୍ଜି ଜିର୍ରେ ଅଃର୍ରପ୍ତିଏଜି, ଆରି, ତେତ୍ତେ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଅମଙ୍‌ଲେନ୍‌ ପଡ୍‌ଲେ ଜିର୍ରେ ଅଃର୍ରପ୍ତିଆଜି ।’ ");
INSERT INTO juy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ସିଲତ୍ତେ ଗମାଙ୍‌ମରନ୍‌ ଗାମେନ୍‌, ‘ଏ ଆପେୟ୍‌ ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ କାକୁର୍ତିତନାୟ୍‌, ଲାଜାରନ୍‌ଆଡଙ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆସିଂ ଆପ୍ପାୟା, ");
INSERT INTO juy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ବୋଞାଙ୍‌ଞେଞ୍ଜି ମନ୍‌ଲୟ୍‌ନେ ଡକୋଜି, ଆନିଞ୍ଜି ନିୟ୍‌ କେନ୍‌ ଅରସୁଡାନ୍‌ ଆଡ୍ରକୋନେଲୋଙ୍‌ ଇୟ୍‌ଡଙାଜି ତଡ୍‌, ତିଆସନ୍‌ ଆମଙଞ୍ଜି ଆନିନ୍‌ ସାକିବରନ୍‌ ଇୟ୍‌ ତିଏତୋ ।’” ");
INSERT INTO juy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“ବନ୍‌ଡ ଅବ୍ରାମନ୍‌ ଗାମେନ୍‌, ‘ଆମଙଞ୍ଜି ମୋସାନ୍‌ ଡ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ଡରମ୍ମ ସାସ୍ତ୍ର ଡକୋ, ଆନିଞ୍ଜି ଆ ବର୍ନେଞ୍ଜି ଅମ୍‌ଡଙେତଜି ।’ ");
INSERT INTO juy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ସିଲତ୍ତେ ଗମାଙ୍‌ମରନ୍‌ ଗାମେନ୍‌, ‘ଏ ଆପେୟ୍‌, ଅବ୍ରାମ, ଡିୟ୍‌ତେ ବାତ୍ତେ ସରି ତଡ୍‌, ବନ୍‌ଡ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଆମଙଞ୍ଜି ଇୟେନ୍‌ ଡେନ୍‌ ଆନିଞ୍ଜି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିତଞ୍ଜି ।’ ");
INSERT INTO juy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ବନ୍‌ଡ ଅବ୍ରାମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଆନିଞ୍ଜି ମୋସାନ୍‌ ଡ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ବର୍ନେ ଅଃନ୍ନମ୍‌ଡଙ୍‌ଲଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ୟର୍ମେଙ୍‌ଡାଲେ ଇୟ୍‌ଲେ ବରେଜି ଡେନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜି ଅଃନ୍ନାବ୍‌ୟର୍‌ବୁଡ୍ଡିନେଜି ।’” ");
INSERT INTO juy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅଙ୍ଗାଆତେଜି ଆସନ୍‌ ମନ୍‌ରାନ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଗଲୋତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଅଡ଼ୋତାୟ୍‌ ମା, ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ଆ ଲତ୍ତେଙ୍‌ଲୋଙ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌ ଅଡ଼ୋତାୟ୍‌, ୟୋଙ୍‌, ତି ଆ ମନ୍‌ରା ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ତି ମନ୍‌ରା, କେନ୍‌ ସନ୍ନାମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେଆଡଙ୍‌ ଇର୍ସେଲୋଙନ୍‌ ଆଗ୍ରବ୍‌ଲୋତେନ୍‌ ସିଲଡ୍‌, ଆର୍ପାୟ୍‌ ଆ ସଙ୍କାଲୋଙ୍‌ ଅବୟ୍‌ ଗୋର୍ନାଅରନ୍‌ ୟୋଡ୍‌ଲେ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆସେଃସେଡ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ମନଙ୍‌ ବନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ତର୍ଡମ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା ।” “ବୋଞାଙ୍‌ବେନ୍‌ ଇର୍ସେନ୍‌ ଲୁମେନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ କଁୟ୍‌ବା, ଆରି ଆନିନ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ କେମାନ୍‌ ତିୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ଆରି, ଆନିନ୍‌ ବ ଡିନ୍ନାଲୋଙ୍‌ ସାତତର ବିରୁଦଲୋଙ୍‌ବେନ୍‌ ଇର୍ସେନ୍‌ ଲୁମ୍‌ତେ, ଆରି ସାତତର ଅମଙ୍‌ବେନ୍‌ ୟର୍ରନ୍‌ ‘ଞେନ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିତନାୟ୍‌’ ଗାମ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ କେମାନ୍‌ ତିୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ସିଲତ୍ତେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଡର୍ନେଲେଞ୍ଜି ଅବ୍‌ଗୋଗୋୟ୍‌ଲେ ତିୟ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ପ୍ରବୁନ୍‌ ଗାମେନ୍‌, “ଡର୍ନେବେନ୍‌ ଅବୟ୍‌ ସୋର୍ସୋବାୟ୍‌ଗୋ ଡକୋଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ମାଲବେରିନୁବନ୍‌ ‘ଅମ୍ପରା ଆଜଡନ୍‌ ବାତ୍ତେ ପୁୟ୍‌ଲନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଇୟ୍‌ଗୁନା’ ଏଗାମେନ୍‌ ଡେନ୍‌ ତିଆତେ ବର୍ନେବେନ୍‌ ଅମ୍‌ଡଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ବନ୍‌ଡ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ମନ୍‌ରା ଆନା ଡକୋ, ଆ କମ୍ୱାରିମରନ୍‌ ବସେଙନ୍‌ ଅର୍ରଡାଲନ୍‌, ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ତୁର୍‌ତାଙନ୍‌ ସିଲଡ୍‌ ୟର୍ରନାୟ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ସିଲତ୍ତେମା କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ‘ଆୟ୍‌ ଗାଗାନା’ ଗାମ୍‌ଲେ ବର୍ତେ ? ");
INSERT INTO juy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ଆର୍ପାୟ୍‌ ଆନିନ୍‌, ‘ଞେନ୍‌ ଆସନ୍‌ ଗାଗାନେନ୍‌ ଅବ୍‌ଜାଡାଆ, ଆରି ଞେନ୍‌ ଗାଗାନେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ସାଡାଞନ୍‌ ଜାୟ୍‌ ରେଡ୍ଡୁବ୍‌ଲନ୍‌ ଗର୍ଗରିଁୟ୍‌ ରୁରୁଇଂ, ତିକ୍କି ଆମନ୍‌ ଗାଗାନା,’ ଗାମ୍‌ଲେ ଆ କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ଅଃବ୍ବରେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","କମ୍ୱାରିମରନ୍‌ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ କାବ୍ବାଡ଼ାନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆନିନ୍‌ କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ସେଙ୍କେତେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ତିଅନ୍ତମ୍‌ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ବର୍ନେନ୍‌ ଅନ୍ତମ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ କାବ୍ବାଡ଼ା ଏସାଡେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ‘ଇନ୍‌ଲେଞ୍ଜି ଅକାମି କମ୍ୱାରି, ଆଙ୍ଗାଆତେ କାବ୍ବାଡ଼ାଲେନ୍‌, ତିଆତେ ତୁମ୍‌ ଏଲୁମ୍‌ଲାୟ୍‌’ ଗାମ୍‌ଲେ ବର୍ନାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ଜିସୁନ୍‌ ଜିରୁସାଲମନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ସମିରୋଣନ୍‌ ଡ ଗାଲିଲିନ୍‌ ଆ ସଣ୍ଡିଗଡ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ଆରି, ଆନିନ୍‌ ଅନ୍ନିଙ୍‌ ଅବୟ୍‌ ଆ ସାଇ ଆଗ୍ରନେନ୍‌ ଆଡିଡ୍‌, ଦସଜଣ ମୋଡ୍ଡୋମରଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ମାୟ୍‌ନେଜି; ");
INSERT INTO juy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ଆନିଞ୍ଜି ସଙାୟ୍‌ଲୋଙ୍‌ ତନଙ୍‌ଡାଲେ, “ଏ ଜିସୁ, ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ସାୟୁମ୍‌ଲେନ୍‌” ଗାମ୍‌ଲେ ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଜିର୍ରେ ରାଓଡ଼ାଞ୍ଜି ଆମଙ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ଆଡଙ୍‌ ଇୟ୍‌ ଅବ୍‌ତୁୟ୍‌ନାବା ।” ଆରି ଆନିଞ୍ଜି ଜିରା ଜିରା ମନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ବନ୍‌ଡ ଆନିଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଆଗ୍ରିୟ୍‌ଡମ୍‌ଲନେନ୍‌ ଆନିନ୍‌ ମନଙେନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେନ୍‌ଲେ ସେନ୍‌ଲେ ଆମଙ୍‌ବାଞ୍ଜି ୟର୍ରନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ଜିସୁନ୍‌ ଆଜଙ୍‌ଲୋଙ୍‌ ଲୋମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସେନେନ୍‌; ଆନିନ୍‌ ଅବୟ୍‌ ସମିରୋଣମର୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ସିଲତ୍ତେ ଜିସୁନ୍‌ ବର୍ରନେ, “ଇନି ଦସଜଣଞ୍ଜି ଅଃମ୍ମନଙ୍‌ଲଜି ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆରି ନଜଣ ଅଡ଼େଙ୍ଗା ? ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆସନ୍‌ କେନ୍‌ଆନିନ୍‌ ତୁମ୍‌ ପଙ୍‌ ବଡେସାବାୟ୍‌ ୟର୍ରନାୟ୍‌, ଆନ୍ନିଙ୍‌ ଆରି ଅଃୟର୍ରନାଜି ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ଆରି, ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଡୋନା, ଜିରା, ଡର୍ନେନମ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆଙ୍ଗା ଜିର୍ତାୟ୍‌ ଗାମ୍‌ଲେ, ପାରୁସିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଆରପ୍ପୁଙେଞ୍ଜି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅବ୍‌ଗିୟ୍‌ତାଲନ୍‌ ଅଃଜ୍ଜିରାୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ‘ଗିୟ୍‌ବା, ତେନ୍ନେ ଅଡ଼େ ତେତ୍ତେ’ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଅଃବ୍ବର୍ନେଜି; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗିୟ୍‌ବା ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅମ୍ମଲୋଙ୍‌ବେନ୍‌ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ବନ୍‌ଡ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ଡିନ୍ନାଜି ଲୋଙ୍‌ସିଲଡ୍‌ ବଡିନ୍ନା ଓୟ୍‌ଲେ ଏଗିୟ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଏବର୍ତନେ, ବନ୍‌ଡ ଗିୟ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ, ଏନ୍ନେଗୋ ଆ ବନେଡ଼ା ଅଡ଼ୋତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","‘ତେତ୍ତେ ଗିୟ୍‌ବା, ତେନ୍ନେ ଗିୟ୍‌ବା,’ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେଞ୍ଜି; ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଇୟ୍‌ଡଙ୍‌, କି ଆନିଞ୍ଜିଆଡଙ୍‌ ଏସଣ୍ଡୋଙ୍‌ଡଙ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତାବ୍‌ରେଡନ୍‌ ତିଡେନ୍‌ ଡେନ୍‌ ଏଙ୍ଗାଲେ କେନ୍‌ ଆ ରୁଆଙ୍‌ ସିଲଡ୍‌ ତି ଆ ରୁଆଙ୍‌ ଜାୟ୍‌ ସାଆର୍‌ତେ ତିଅନ୍ତମ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଆ ଡିନ୍ନା ଏତ୍ତେଲେ ଗିୟ୍‌ତାତେ । ");
INSERT INTO juy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ବନ୍‌ଡ ଆମ୍ମୁଙ୍‌ ଆନିନ୍‌ ଗୋଗୋୟ୍‌ ସତିଡ୍‌ଲେ ସବୟ୍‌ଲେ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ ଆରି କେନ୍‌ ନମି ଆ ମନ୍‌ରାଜି ଆନିନ୍‌ଆଡଙ୍‌ ବାସ୍ସେତଜି । ");
INSERT INTO juy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ଆରି, ନୋଅନ୍‌ ଆ ବନେଡ଼ାଇଂ ଏଙ୍ଗାଗୋ ଡେଏନ୍‌, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ବନେଡ଼ାଇଂ ନିୟ୍‌ ଏତ୍ତେଗୋ ମା ଡେତେ; ");
INSERT INTO juy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ନୋଅନ୍‌ ଡାଆ ଜାଜଲୋଙନ୍‌ ଆଗ୍ରନେନ୍‌ ଆ ଡିନ୍ନା ଜାୟ୍‌ ମନ୍‌ରାଞ୍ଜି ବିବାନେନ୍‌, ଅନବ୍‌ବିବାନ୍‌ ଆରି ଗାଲେ ଜୋମ୍‌ଲେ ମଗାଡେଞ୍ଜି, ଆରି ରିଙ୍ଗେତିରନ୍‌ ଜିର୍ରେ ଅଡ଼୍‌କୋଞ୍ଜି ଇୟ୍‌ଲାୟ୍‌ ଅମ୍ମାୟାଆଜେ । ");
INSERT INTO juy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ଲୋଟନ୍‌ ଆ ବନେଡ଼ାଇଂ ଜାକିଁୟ୍‌ ଏତ୍ତେଗୋମା ଡେଏନ୍‌, ମନ୍‌ରାଞ୍ଜି ଗାଗାନେନ୍‌, ଞିଞିନେନ୍‌ ତନ୍‌ଣ୍ଡ୍ରମନ୍‌, ଗୁଗୁନୁବନ୍‌ ଡ ଗୁସିଂଲୋଙନ୍‌ ମଗାଡେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ବନ୍‌ଡ ଲୋଟନ୍‌ ସଦୋମନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେନ୍‌ ଆ ଡିନ୍ନା ରୁଆଙନ୍‌ ସିଲଡ୍‌ ତଗୋନ୍‌ ଡ ଡାରୁନ୍‌ ତରୁବ୍‌ଡାଗୋ ଅଡ଼ୋଡାଲେ ଅଡ଼୍‌କୋଞ୍ଜି ଜୋମ୍‌ତୋଡାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆଗ୍ରିୟ୍‌ତାତେନ୍‌ ଆ ଡିନ୍ନା ଜାକିଁୟ୍‌ ତିଅନ୍ତମ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ତିଆଡିନ୍ନା ଆନା ତୋଣ୍ଡୋ ବିଲେଙ୍‌ଲୋଙନ୍‌ ଡକୋତେ, ଆନିନ୍‌ ଅମ୍ମସିଙନ୍‌ ଆ ଜନବ୍‌ଜି ପାଙ୍‌ପାଙନ୍‌ ଆସନ୍‌ ପଡ୍‌ଲନ୍‌ ଜିର୍‌ଡଙାୟ୍‌ ତଡ୍‌; ତିଅନ୍ତମ୍‌ ଆନା କୋତ୍ତାଲୋଙନ୍‌ ଡକୋତେ ଆନିନ୍‌ ୟର୍‌ଡଙ୍‌ନାୟ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲୋଟନ୍‌ ଆ ଡୁକ୍ରି ଆ ବର୍ନେ ଇୟମ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ଆନା ଆ ପରାନ୍ନାନ୍‌ ଅନବ୍‌ମେଙନ୍‌ ଆସନ୍‌ ଏର୍‌ତେ ଗୋୟ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଅବ୍ବଡ଼ୟ୍‌ତେ, ଆରି ଆନା ଆ ପରାନ୍ନାନ୍‌ ଅବ୍ବଡ଼ୟ୍‌ତେ ଆନିନ୍‌ ତିଆତେ ଅବ୍‌ମେଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ତି ଆ ତଗଲ୍‌ ବାଗୁନେ ଆବୟନ୍‌ ଆ କଟଲୋଙ୍‌ ଲୁଡ୍‌ତଜି, ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନୋରୋଙନ୍‌ ଡେତେ, ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ବାଗୁ ଆଇମରନ୍‌ ଏକ୍କାନ୍‌ ରିଡ୍ଡିଁୟ୍‌ତଞ୍ଜି, ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନୋରୋଙନ୍‌ ଡେତେ ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ବାଗୁ ମନ୍‌ରାନ୍‌ କୋତ୍ତାଲୋଙନ୍‌ ଡକୋତଜି, ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନୋରୋଙନ୍‌ ଡେତେ ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ପ୍ରବୁ ଅଙ୍ଗାଲୋଙ୍‌ ?” ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଅଙ୍ଗାଲୋଙ୍‌ ମରାନ୍‌ ଡକୋତେ, ତେତ୍ତେ ମରାଜୋମ୍‌ତିଡଞ୍ଜି ନିୟ୍‌ ରୁକ୍କୁତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ଏର୍‌ଲୋଲୋନେନ୍‌ ଆଏଡ଼ର୍‌ ପାର୍ତନାନେନ୍‌ କାବ୍ବାଡ଼ାଲେନ୍‌, ତିଆସନ୍‌ କେନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“ଅବୟ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ଅବୟ୍‌ ପନ୍‌ସୁଆତିମରନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଅଃବ୍ବତଙ୍‌ଲୋ କି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମାନ୍ନେଲୋ । ");
INSERT INTO juy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ତି ଆ ଗଡ଼ାଲୋଙ୍‌ ଅବୟ୍‌ ଜୁଆର୍‌ବଜନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ବବେଡ଼ାନ୍‌ କି ବବେଡ଼ାନ୍‌ ପନ୍‌ସୁଆତିମରନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲେ କାକୁର୍ତିଡାଲନ୍‌ ଇୟ୍‌ଲେ ବର୍ନେ, ‘ବନେରାଞେନ୍‌ ବୟନ୍‌ ବିସାରଇଁୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ଆରି, ପନ୍‌ସୁଆତିମରନ୍‌ ଜବ୍ର ଡିନ୍ନା ଜାୟ୍‌ ଅଃନ୍ନବ୍‌ପନ୍‌ସୁଆତିଲୋ, ବନ୍‌ଡ ଆନିନ୍‌ ତିକ୍କି ଇୟମେନ୍‌, ‘ଞେନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଅଃବ୍ବତଙାୟ୍‌ କି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମାନ୍ନେଲାୟ୍‌ ଜନଙ୍‌ଡେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","କେନ୍‌ ଜୁଆର୍‌ବଜନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବାଉଲ୍ଲି ଆରେମ୍ମେତିଞନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆରିନ୍ନତେଞ୍ଜି ଞେନ୍‌ ପନ୍‌ସୁଆତିତାୟ୍‌, ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଡିତାନ୍‌ ବାଉଲ୍ଲି ଇୟ୍‌ତାୟ୍‌ ଏମ୍ମେଇଁୟ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ସିଲତ୍ତେ ପ୍ରବୁନ୍‌ ବର୍ରନେ, “କେନ୍‌ ଏର୍‌ଡରମ୍ମମର୍‌ ପନ୍‌ସୁଆତିମରନ୍‌ ଇନି ଗାମ୍‌ତେ ତିଆତେ ଅମ୍‌ଡଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆସ୍ରେଡାଏନ୍‌ ଆ ମନ୍‌ରାଜି ତଗଲ୍‌ ତମ୍‌ବା ଆନିନ୍‌ଆଡଙ୍‌ ଆରୋଡ୍ଡେତେଞ୍ଜି, ଇସ୍ୱରନ୍‌ ତି ଆ ମନ୍‌ରାଜି ଆ ବନେରାଜିଆଡଙ୍‌ ଗୋଗୋୟ୍‌ ସନଏନ୍‌ ଡକୋଏନ୍‌ ଜନଙ୍‌ଡେନ୍‌, ଆନିନ୍‌ ପଙ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରିନ୍ନତେଞ୍ଜି ଅଃନ୍ନବ୍‌ପନ୍‌ସୁଆତିଏଜି ? ");
INSERT INTO juy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରିନ୍ନତେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆନିନ୍‌ ଲପନ୍‌ସୁଆତିତଜି । ବନ୍‌ଡ, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଇନି ଡର୍ନେନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗିଜେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ଲାଙ୍‌ଲେଡ୍‌ ଡର୍ଡମ୍‌ନେମରଞ୍ଜି ଆନିଞ୍ଜିଡମ୍‌ ଡରମ୍ମମର୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ତୁୟ୍‌ଡାଲନ୍‌ ଆନ୍ନାମରଞ୍ଜିଆଡଙ୍‌ ବାସ୍ସେଏଞ୍ଜି, ତି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଜିସୁନ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ବାଗୁ ମନ୍‌ରା ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ସରେବାସିଙନ୍‌ ଇୟେଞ୍ଜି, ଅବୟ୍‌ନେ ପାରୁସି ଆରି ଅବୟ୍‌ନେ ପାନୁବେଡ୍‌ମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“ପାରୁସିନ୍‌ ତନଙ୍‌ଡାଲେ ଆନିନ୍‌ଡମ୍‌ ଏନ୍ନେଲେ ପାର୍ତନାଲନେ, ‘ଏ ଇସ୍ୱର, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସେଙ୍କେତମ୍‌, ଞେନ୍‌ ଆନ୍ନାମରଞ୍ଜି ଅନ୍ତମ୍‌ ଅଃର୍ରାଉନାୟ୍‌, ଅଃଡ୍ଡାରିନାୟ୍‌, ଏର୍‌ଡରମ୍ମମର୍‌ ତଡ୍‌, ଆରି କେନ୍‌ ପାନୁବେଡ୍‌ମରନ୍‌ ଅନ୍ତମ୍‌ ନିୟ୍‌ ତଡ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ଞେନ୍‌ ବପାଲ୍ଲିନ୍‌ ବାଗୁତର ଆନମ୍‌ତନାୟ୍‌ ଆରି ଞେନ୍‌ ଅନର୍ଜେଲୋଙ୍‌ଞେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ଦସମାଂସ ତିୟ୍‌ତାୟ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“ବନ୍‌ଡ ପାନୁବେଡ୍‌ମରନ୍‌ ସଙାୟ୍‌ଲୋଙ୍‌ ତନଙ୍‌ଡାଲେ ରୁଆଙ୍‌ଗଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆଙାଙ୍‌ନେନ୍‌ ଆସନ୍‌ ନିୟ୍‌ ଅଃନ୍ନୋମଙ୍‌ଲୋ, ବନ୍‌ଡ ଆ ମାୟଙ୍‌ଲୋଙନ୍‌ ତିଡ୍ଡମ୍‌ଲନ୍‌ ବର୍ରନେ, ‘ଏ ଇସ୍ୱର, ଞେନ୍‌ ଇର୍ସେମର୍‌, ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମିଁୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ପାରୁସିନ୍‌ ତଡ୍‌ ଆର୍ପାୟ୍‌ ପାନୁବେଡ୍‌ମରନ୍‌ ଡରମ୍ମମର୍‌ ଗାମ୍‌ଲେ ଡନିଡିନ୍‌ ଡେଏନ୍‌ କି ଆନିନ୍‌ ଆସିଙନ୍‌ ଜିରେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଡମ୍‌ ଅବ୍‌ସୋଡ଼ାଲନ୍‌ ଅବ୍‌ତୁୟ୍‌ତନେ ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ସନ୍ନାନ୍‌ ଡେତେ, ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଡମ୍‌ ଅବ୍‌ସନ୍ନାତନେ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ସୋଡ଼ାନ୍ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଜିସୁନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ପସିଜଞ୍ଜିଆଡଙ୍‌ ସୁଙେତଜି, ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ପସିଜଞ୍ଜି ନିୟ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ବା ଓରୋଙ୍‌ଲାଜି; ବନ୍‌ଡ ଞଙ୍‌ନେମରଞ୍ଜି ତିଆତେ ଗିୟ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ କଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ବନ୍‌ଡ ଜିସୁନ୍‌ ପସିଜଞ୍ଜିଆଡଙ୍‌ ଆମଙନ୍‌ ଓଡ୍ଡେଲେ ବର୍ରନେ, “ପସିଜଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ସାବ୍ବାଜି, ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ଏରଙ୍‌ଡଙେଜି; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ପସିୟ୍‌ଜିଆତେ । ");
INSERT INTO juy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ମନ୍‌ରା ସନ୍ନାସିଜଞ୍ଜି ଅନ୍ତମ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅଃଜ୍ଜାଏ, ଆନିନ୍‌ ତେତ୍ତେ ଗନ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ଅବୟ୍‌ ଜିଉଦି ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଆଜାଡ଼ି ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଅଃନ୍ନଞିଡେନ୍‌ ଆ ପରାନ୍ନା ଆଞନାଙ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଇନି ଏଙ୍ଗାନାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ଆଜାଡ଼ି ଗାମ୍‌ଲେ ଇନିବା ବର୍ତନେ ? ଅବୟ୍‌ନେନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ, କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌, ଇସ୍ୱରନ୍‌ ଅମ୍‌ରେଡାଲେ ଆନ୍ନିଙ୍‌ ଆରି ଆଜାଡ଼ି ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ବନାଁୟ୍‌ବରଞ୍ଜି ତ ଆମନ୍‌ ଜନା, ଏଡାରିଡଙ୍‌ନେ, ମନ୍‌ରାନ୍‌ ଏରବ୍ବୁଡଙ୍‌, ଏରାଉଡଙ୍‌ନେ, କଣ୍ଡାୟ୍‌ ସାକିନ୍‌ ଏତିୟ୍‌ଡଙ୍‌, ଆପେୟ୍‌ବେନ୍‌ ଅୟୋଙ୍‌ବେନ୍‌ଆଡଙ୍‌ ମାନ୍ନେବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ତି ମନ୍‌ରାନ୍‌ ବର୍ରନେ, “କେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ ବନେଣ୍ଡିଆଞେନ୍‌ ସିଲଡ୍‌ ଲୁମ୍‌ଲେ ଜିର୍ରାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ଜିସୁନ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ବର୍ରନେ, “ଆମନ୍‌ ଆରି ଅବୟ୍‌ ବର୍ନେଲୋଙନ୍‌ ଉନା ଡକୋ; ଆମନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ତମ୍‌ଲୋଙ୍‌ ତମ୍‌ଲେ ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ବାନ୍ତେଆଜି, ଆରି ଞେନ୍‌ଆଡଙ୍‌ ଆୟ୍‌ ସଣ୍ଡୋଙିୟ୍‌; ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ରନ୍ନାନ୍‌ ଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ବନ୍‌ଡ ଆନିନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆକ୍ରାନ୍‌ ମୁସୁକ୍କା ଡେଏନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ ଗମାଙ୍‌ମର୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ଗମାଙ୍‌ମରନ୍‌ ମୁସୁକ୍କା ଆଡ୍ରେଏନ୍‌ଆତେ ଗିୟ୍‌ଲେ, ଜିସୁନ୍‌ ବର୍ରନେ, “ଆନାଜି ଆମଙ୍‌ ରନ୍ନାନ୍‌ ଡକୋ, ଆନିଞ୍ଜି କାକୁର୍ତିଃ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗନ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗମାଙ୍‌ମରନ୍‌ ଆଗ୍ରନ୍‌ତେନ୍‌ ସିଲଡ୍‌ ଆର୍ପାୟ୍‌ ସୁର୍ଜାନ୍‌ ଆ ପତୁଡ୍‌ ଗଡ୍‌ ଓଟନ୍‌ ଆଗ୍ରନ୍‌ତେନ୍‌ ସଜ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ଆନାଜି କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙେଞ୍ଜି, ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନା ଅନୁରନ୍‌ ଞାଙ୍‌ଲେ ରପ୍ତିଏ ?” ");
INSERT INTO juy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ବନ୍‌ଡ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଅଙ୍ଗାତେ ମନ୍‌ରାନ୍‌ ଲୁମ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ, ତିଆତେ ଇସ୍ୱରନ୍‌ ଲୁମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ବର୍ରନେ, “ଗିଜା ଇନ୍‌ଲେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ଆତେ ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆମନ୍‌ଆଡଙ୍‌ ଏସଣ୍ଡୋଙ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ମନ୍‌ରା ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆସନ୍‌ ଅସିଙନ୍‌, ଡୁକ୍ରିନ୍‌, ବୋଞାଙନ୍‌, ଆପେୟନ୍‌, ଅୟୋଙନ୍‌, ଆରି ଆ ପସିଜଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ, ");
INSERT INTO juy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ନମି ଆଡିନ୍ନାଲୋଙ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ଆରି ତିକ୍କି ଆଡିନ୍ନାଲୋଙ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆ ପରାନ୍ନା ଅଃଞାଙେ, ତିଅନ୍ତମ୍‌ ଆ ମନ୍‌ରା ଆନ୍ନିଙ୍‌ ତଡ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ତିକ୍କି ଜିସୁନ୍‌ ବାରଜଣ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଆନ୍ନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଗିୟ୍‌ବା, ଇନ୍‌ଲେଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଜିର୍ତବୋ, ଆରି ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆସନ୍‌ ଇନିଜି ଇଡେଞ୍ଜି, ତି ଅଡ଼୍‌କୋନ୍‌ ଡେଡମ୍‌ତେ; ");
INSERT INTO juy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତନେ, ଆରି ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଡୋସେତଜି, ସୟ୍‌ସୟ୍‌ମୁତଜି, ବିଜଲ୍‌ତଜି, ");
INSERT INTO juy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ସାମକାନ୍‌ ବାତ୍ତେ ତିଡ୍‌ତଜି, ରବ୍ବୁତଜି, ଆରି ଏର୍ତାଲୋଙ୍‌ ଆନିନ୍‌ ୟର୍ମେଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ବନ୍‌ଡ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଞଙ୍‌ନେମରଞ୍ଜି ଇନ୍ନିଙ୍‌ ଅଃଗନ୍‌ଲୁଡ୍‌ଲଜି; କେନ୍‌ ଆ ବର୍ନେ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ସଲନ୍‌ ଡକୋଲନ୍‌, ଆରି ଇନିଜି ଇନିଜି ବର୍ନେନ୍‌ ଡେଏନ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଆନିଞ୍ଜି ଅଃଗନ୍‌ଲୁଡ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ଜିସୁନ୍‌ ଜିରିଓନ୍‌ ଆତ୍ରୁୟାଜେନ୍‌ ଆଡିଡ୍‌ ଅବୟ୍‌ ଆ କାଡ଼ୁମରନ୍‌ ଅନେଙ୍‌ ରୋତ୍ତନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ବେବ୍ବେଡ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ମନ୍‌ରାଞ୍ଜି ଆତ୍ରଙିୟ୍‌ଲଞ୍ଜି ଆ ସନଡ୍ଡା ଅମ୍‌ଡଙ୍‌ଡାଲେ, କାଡ଼ୁମରନ୍‌ “କେନ୍‌ ଇନି” ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ଆନିଞ୍ଜି କାଡ଼ୁମରନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ନାଜରିତ ଜିସୁନ୍‌ କେନ୍‌ ଆ ତଙର୍‌ଗଡ୍‌ ଜିର୍ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ସିଲତ୍ତେ ଆନିନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଏ ଜିସୁ, ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ବନ୍‌ଡ ଆମ୍ମୁଙ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆନିନ୍‌ଆଡଙ୍‌ କଡ଼ିଙା ଗାମ୍‌ଲେ ବବ୍‌ତଙେଞ୍ଜି, ବନ୍‌ଡ ଆନିନ୍‌ ଆରି ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବାବ୍ବାବ୍‌ଲେ ବର୍ରନେ, “ଏ ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସାୟୁମିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ସିଲତ୍ତେ ଜିସୁନ୍‌ ତନଙ୍‌ଡାଲେ ତି କାଡ଼ୁମରନ୍‌ଆଡଙ୍‌ ଆମଙନ୍‌ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ଆରି, କାଡ଼ୁମରନ୍‌ ଆମଙନ୍‌ ଆତ୍ରୁଙ୍‌ଲାଞନ୍‌, ଜିସୁନ୍‌ କାଡ଼ୁମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ଞେନ୍‌ ଆମନ୍‌ ଆସନ୍‌ ଇନି ଲୁମାୟ୍‌ ଗାମ୍‌ଲେ ଆମନ୍‌ ଲଡୟ୍‌ତମ୍‌ ?” ଆନିନ୍‌ ଗାମେନ୍‌, “ଏ ପ୍ରବୁ, ଞେନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆରି ଗିୟ୍‌ଲେ ରପ୍ତିଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଗିଜା, ଡର୍ନେନମ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ସିଲତ୍ତେମା ଆନିନ୍‌ ଗିୟ୍‌ଲେ ରପ୍ତିଏନ୍‌, ଆରି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେନ୍‌ଲେ ସେନ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେନ୍‌ ଆରି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ତିଆତେ ଗିୟ୍‌ଲେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେଙ୍କେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ତିକ୍କି ଜିସୁନ୍‌ ଜିରିଓନ୍‌ ଗନ୍‌ଲେ ତିଗଡ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ଆରି ଗିୟ୍‌ବା, ଜକିଅ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ଅବୟ୍‌ ସୋଡ଼ା ପାନୁବେଡ୍‌ମର୍‌ ଆରି ଗମାଙ୍‌ମର୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଜିସୁନ୍‌ ଆନା, ତିଆତେ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଜକିଅନ୍‌ ଏରେନ୍‌ ଗୋଜେନ୍‌, ବନ୍‌ଡ ମନ୍‌ରାଞ୍ଜି ଆୟରେଡନ୍‌ ଡକୋଏଞ୍ଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଲୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଡୋୟ୍‌ନାମର୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ତିଆସନ୍‌ ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ ଇରେନ୍‌ କି ଅବୟ୍‌ ଲୁଆନୁବ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ଲେ ଡାଜେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିସୁନ୍‌ ତି ଆ ତଙର୍‌ଗଡ୍‌ ବନ୍‌ ଜିର୍ତେ । ");
INSERT INTO juy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ଜିସୁନ୍‌ ତେତ୍ତେ ଅଡ଼ୋଏନ୍‌ କି ତୋଣ୍ଡୋନ୍‌ ଆଙାଙ୍‌ଡାଲେ ଜକିଅନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜକିଅ, ଲପନ୍ନାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଲଙେ ଞେନ୍‌ ଅସିଂନମ୍‌ ଡକୋତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ସିଲତ୍ତେ ଜକିଅନ୍‌ ଲପଲ୍ଲନ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆସିଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଓରୋଙେ । ");
INSERT INTO juy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ତିଆତେ ଗିୟ୍‌ଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଡୋସେଡାଲେ ବର୍ରଞ୍ଜି, “ଗିୟ୍‌ବା ଆନିନ୍‌ ଅବୟ୍‌ ଇର୍ସେମରନ୍‌ ଆସିଂ ଡକୋନେବାନ୍‌ ଜିରେନ୍ନି ।” ");
INSERT INTO juy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ବନ୍‌ଡ ଜକିଅନ୍‌ ତନଙ୍‌ଡାଲେ ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ପ୍ରବୁ, ଗିଜା, ଅନର୍ଜେଲୋଙ୍‌ଞେନ୍‌ ବବନ୍ତା ଞେନ୍‌ ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ତାଜି, ଆରି କଣ୍ଡାୟ୍‌ଡାଲେ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଞେନ୍‌ ଇନ୍ନିଙ୍‌ ପାଙ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଉଞ୍ଜିଗୁନା ଆବ୍‌ଡିଡ୍‌ଲେ ତିୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଜକିଅନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ, “ଲଙେ କେନ୍‌ ଆସିଂଲୋଙ୍‌ ଅନୁରନ୍‌ ଅଡ଼ୋଲାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆନିନ୍‌ ନିୟ୍‌ ଅବୟ୍‌ ଅବ୍ରାମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାତେ ଆଡ଼ଏନ୍‌ ତିଆତେ ସାୟ୍‌ଲେ ଡୋବ୍‌ଡୋବନ୍‌ ଆସନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ମନ୍‌ରାଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆରମ୍‌ଡଙେଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆରି ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବର୍ରନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଜିରୁସାଲମନ୍‌ ଆ ତୁୟାୟ୍‌ ଅଡ଼ୋଏନ୍‌ ଆରି ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଲଗିୟ୍‌ତାରୟ୍‌ତେ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଅବ୍‌ଡିସୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ତିଆସନ୍‌ ଆନିନ୍‌ ବର୍ରନେ, “ଅବୟ୍‌ ମନାନ୍ନେମରନ୍‌ ରାଜା ତରଙ୍କୁମନ୍‌ ଞାଙ୍‌ଲେ ୟର୍ନେନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ ସଙାୟ୍‌ ଡେସାନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ଆନିନ୍‌ ଦସଜଣ ଆ କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଡିଲେ କମ୍ୱାରିମରଞ୍ଜି ଆସିଲୋଙ୍‌ ତଙ୍‌ବୟ୍‌ ତଙ୍‌ବୟ୍‌ ସୁନା ଗୁଣ୍ଡାଡାବନ୍‌ ତିୟ୍‌ଲେ ବରେଞ୍ଜି, ‘ଞେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ୟର୍ନାଞନ୍‌ ଜାୟ୍‌ ବେପାରନାୟ୍‌ବା ।’ ");
INSERT INTO juy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ବନ୍‌ଡ ଆ ଡେସାମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡେଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ଆ କଣ୍ଡୋଙ୍‌ଗଡନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ, ‘କେନ୍‌ ଆ ମନ୍‌ରା ଅମଙ୍‌ଲେନ୍‌ ଜିର୍ରେ ଇଆୟ୍‌ତୋ ରାଜାନେ କେନ୍‌ଆତେ ଇନ୍‌ଲେଞ୍ଜି ଅଃଲ୍ଲଡୟ୍‌ଲେନ୍‌’ ଗାମ୍‌ଲେ ବର୍ରଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“ତିକ୍କି ଆନିନ୍‌ ରାଜା ତରଙ୍କୁମନ୍‌ ଞାଙ୍‌ଲେ ୟର୍ରନ୍‌; ଅଙ୍ଗା କମ୍ୱାରିମର୍‌ଜିଆଡଙ୍‌ ଆନିନ୍‌ ଡାବ୍ବୋନ୍‌ ତିୟ୍‌ଲେ ଜିରେଞ୍ଜି, ଆନିଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ବେପାରଡାଲନ୍‍ ଆନା ଡିଅଙ୍ଗା ଅର୍ଜେଏନ୍‌ ତିଆତେ ଜନନାନ୍‌ ଆସନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଆମଙନ୍‌ ଓଡ୍ଡେଲେ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ମନ୍‌ରାନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ସିଲତ୍ତେ ଆମ୍ମୁଙ୍‌ ଅବୟ୍‌ନେ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ, ‘ପ୍ରବୁ, ସୁନା ଗୁଣ୍ଡାଡାବ୍‌ନମ୍‌ ବାତ୍ତେ ଆରି ଦସଟା ସୁନା ଗୁଣ୍ଡାଡାବନ୍‌ ଅର୍ଜେଲାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ଆନିନ୍‌ କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଡେଲୋ, ମନଙ୍‌, ଡର୍ନେ କମ୍ୱାରିମର୍‌, ଆମନ୍‌ ଅସୋୟ୍‌ଲୋଙନ୍‌ ଡର୍ନେଡମ୍‌, ତିଆସନ୍‌ ଆମନ୍‌ ଦସଟା ଗଡ଼ାନ୍‌ ପାଙା ।’ ");
INSERT INTO juy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ଆରି ଅବୟ୍‌ନେ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ, ‘ପ୍ରବୁ, ସୁନା ଗୁଣ୍ଡାଡାବ୍‌ନମ୍‌ ବାତ୍ତେ ଆରି ମନ୍‌ଲୟ୍‌ ସୁନା ଗୁଣ୍ଡାଡାବନ୍‌ ଅର୍ଜେଲାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ମନାନ୍ନେମରନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ବରେନ୍‌, ‘ଆମନ୍‌ ନିୟ୍‌ ମନ୍‌ଲୟ୍‌ ଗଡ଼ାନ୍‌ ପାଙା ।’” ");
INSERT INTO juy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“ଆରି ଅବୟ୍‌ନେ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ, ‘ପ୍ରବୁ, କେରେ ସୁନା ଗୁଣ୍ଡାଡାବ୍‌ନମ୍‌ ଗିଜା, ଞେନ୍‌ କେନ୍‌ଆତେ ସିନ୍‌ରିଲୋଙନ୍‌ ଜିରାଲେ ଡକ୍କୋଲାୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବତଙ୍‌ଲମ୍‌, ଆମନ୍‌ ଅବୟ୍‌ ରଡୋମର୍‌, ଅଙ୍ଗାତେ ଅଃଡ୍ଡକ୍କୋଏ, ତିଆତେ ପାଙ୍‌ଲେ ଜିର୍ତେ, ଆରି ଅଙ୍ଗାତେ ଅଃବ୍ବୁଡେ ତିଆତେ ଗଡ୍‌ତେ ।’ ");
INSERT INTO juy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ମନାନ୍ନେମରନ୍‌ ଗାମେନ୍‌, ‘ଏ ଆଲ୍ଲେ କମ୍ୱାରିମର୍‌, ତଅଡ୍‌ନମ୍‌ ଆ ବର୍ନେ ବାତ୍ତେ ଆମନ୍‌ଆଡଙ୍‌ ପନ୍‌ସୁଆତିତମ୍‌ । ଞେନ୍‌ ଅବୟ୍‌ ରଡୋମର୍‌, ଅଙ୍ଗାତେ ଅଃଡ୍ଡକ୍କୋଆୟ୍‌, ତିଆତେ ପାଙ୍‌ଲେ ଜିର୍ତେ, ଆରି ଅଙ୍ଗାତେ ଅଃବ୍ବୁଡାୟ୍‌, ତିଆତେ ଗଡ୍‌ତାୟ୍‌, କେନ୍‌ଆତେ ଆମନ୍‌ ଜନା ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସୁନାଡାବ୍‌ଞେନ୍‌ ଇନିବା ବେଙ୍କଲୋଙନ୍‌ ଅଃଡ୍ଡକ୍କୋଲୋ ? ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ୟର୍ରନାୟ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆଅନ୍‌ଡାବନ୍‌ ବୟନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତବ୍‌ନାୟ୍‌ ବନ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“ଆରି ତେତ୍ତେ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଆନିନ୍‌ ବରେନ୍‌, ‘କେନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ କେନ୍‌ ସୁନାଡାବନ୍‌ ପାଙ୍‌ଲେ, ଆନା ଆମଙ୍‌ ଦସଟା ସୁନାଡାବନ୍‌ ଡକୋ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ ତିୟ୍‌ବା ।’ ");
INSERT INTO juy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ସିଲତ୍ତେ ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, ‘ପ୍ରବୁ ଆମଙନ୍‌ ତ ଦସଟା ସୁନାଡାବନ୍‌ ଡକୋ !’ ");
INSERT INTO juy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ଆନିନ୍‌ ଜାଲଙେଞ୍ଜି, ‘ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଅଙ୍ଗା ମନ୍‌ରା ଆମଙ୍‌ ଡକୋ, ଆନିନ୍‌ଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ; ବନ୍‌ଡ ଆନା ଆମଙ୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌, ଆମଙନ୍‌ ଇନି ଡକୋ, ତିଆତେ ନିୟ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ପନାଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ବନ୍‌ଡ କେନ୍‌ ବନେରାଞେଞ୍ଜି, ଆନାଜି ଆମଙ୍‌ ଞେନ୍‌ ରାଜାନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଅଃଲ୍ଲଡୟ୍‌ଲଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ତେନ୍ନେ ଓରୋଙ୍‌ଡାଲେ ତେମଡ୍‌ଞେନ୍‌ ରବ୍ବୁବାଜି ।’ ” ");
INSERT INTO juy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ଆରି ଜିସୁନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ବର୍ରନ୍‌ ଆନିନ୍‌ ଆମ୍ମୁଙ୍‌ଡାଲନ୍‌ ଜିରୁସାଲମନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ଆରି, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆନିନ୍‌ ଜିତବୁରନ୍‌ ଆ ତୟ୍‌ତୟ୍‌ ବେତ୍‌ପାଗିନ୍‌ ଡ ବେତନିଆନ୍‌ ଆ ତୁୟାୟ୍‌ ଅଡ଼ୋଏନ୍‌, ତିଆଡିଡ୍‌ ଆନିନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ବାଗୁନେଆଡଙ୍‌ ବର୍ରେ ଆପ୍ପାୟେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ତି ମୁକ୍କାବାବେନ୍‌ ଆ ସାଇ ଇୟ୍‌ବା, ତେତ୍ତେ ଆଗ୍ରନ୍‌ତେନ୍‌ ଆଡିଡ୍‌, ଆନା ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଆଙ୍ଗିୟ୍‌ ଆନ୍ନିଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ତଙ୍କୁମେ, ତିଅନ୍ତମ୍‌ ଅବୟ୍‌ ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ଲୁଆଡନ୍‌ ବାତ୍ତେ ଆତବାଡନ୍‌ ଇୟ୍‌ତେ ଏଗିଜେ; ତିଆତେ ଉଜୁୟ୍‌ଡାଲେ ପାଙାୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ଆରି, ଆନ୍ନିଙ୍‌ ଇନିବା ଏଉଜୁୟ୍‌ତେ ଗାମ୍‌ଲେ ବର୍ରବେନ୍‌ ଡେନ୍‌, ପ୍ରବୁନ୍‌ ଆସନ୍‌ କେନ୍‌ଆତେ ସନାୟ୍‌ସାୟ୍‌, ଗାମ୍‌ଲେ ଇୟ୍‌ ବର୍ନାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ସିଲତ୍ତେ ଆରାପ୍ପାୟେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଜିର୍ରେ, ଆନିନ୍‌ ଏଙ୍ଗାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ଏତ୍ତେଲେ ଇୟ୍‌ଲେ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ଆରି, ଆନିଞ୍ଜି ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ଆରୁଜେଞ୍ଜି ଆଡିଡ୍‌, ଗୋଡୋଁୟନ୍‌ ଆ ସାଉକାର “ଇନିବା ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ଏଉଜୁୟ୍‌ତେ” ଗାମେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପ୍ରବୁନ୍‌ ଆସନ୍‌ କେନ୍‌ଆତେ ସନାୟ୍‌ସାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ଆରି ଆନିଞ୍ଜି ତିଆତେ ଜିସୁନ୍‌ ଆମଙ୍‌ ପାଙ୍‌ଲେ ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ସିନ୍‌ରି ବେଲ୍ଲେ ଜିସୁନ୍‌ ଅବ୍‌ତଙ୍କୁମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ଆରି, ଆନିନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ମନ୍‌ରାଞ୍ଜି ତଙର୍‌ଲୋଙନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ସିନ୍‌ରି ବେଲେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ଆରି ଆନିନ୍‌ ଆଙ୍ଗା ଜିତବୁରନ୍‌ ଆ ଡୁଙ୍‌ଡୁଙ୍‌ରେଙ୍‌ ଅଡ଼ୋଏନ୍‌, ତିଆଡିଡ୍‌ ଅଡ଼୍‌କୋ ଞଙ୍‌ନେମରଞ୍ଜି ଆଗ୍ରିଜେଞ୍ଜି ଅଡ଼୍‌କୋ ବୋର୍ସା କାବ୍ବାଡ଼ାନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ସର୍ଡାନ୍‌ ବାତ୍ତେ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଗଙ୍କେଲ୍ଲେ ବର୍ରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ପ୍ରବୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଅଙ୍ଗା ରାଜା ଜିର୍ତାୟ୍‌ ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌ । ରୁଆଙ୍‌ଲୋଙନ୍‌ ସୟୁ ଆରି ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଗନୁଗୁ ପନେମେଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ସିଲତ୍ତେ ପାରୁସିଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ବର୍ରଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଞଙ୍‌ନେମର୍‌ନମ୍‌ଜି ଅବ୍‌କଡ଼ିଙାଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ଆନିଞ୍ଜି କଡ଼ିଙେଞ୍ଜି ଡେନ୍‌, ଅରେଙଞ୍ଜି ବାବ୍ବାବ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ଆରି, ଜିସୁନ୍‌ ଆଙ୍ଗା ଜିରୁସାଲମନ୍‌ ଆ ତୁୟାୟ୍‌ ଜିର୍ରାୟ୍‌, ତିଆଡିଡ୍‌ ଗଡ଼ାନ୍‌ ଗିୟ୍‌ଲେ ତିଆତେ ଆସନ୍‌ ୟେଲେ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“ଆମନ୍‌, ଓଓ, ଆମନ୍‌ ଲଙେ ସୟୁବରଞ୍ଜି ଜନାଲମ୍‌ ନଙ୍‌ ! ବନ୍‌ଡ ନମି ତିଆତେଜି ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ନମ୍‌ ଆସସ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସନାୟୁମ୍‌ ଡିନ୍ନାନମ୍‌ ଆମନ୍‌ ଅଃଜ୍ଜନାଲମନ୍‌ ଆସନ୍‌, ଅଙ୍ଗା ଡିନ୍ନା ବନେରାନମ୍‌ଜି ଆମନ୍‌ଆଡଙ୍‌ ଏର୍ରେ ପାଡ଼ିଲେ, ଅବ୍‌ଗେଗେଲେ ଡଙ୍‌ତମ୍‌ଜି, ");
INSERT INTO juy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ଆରି, ଆମନ୍‌ ଡ ଅମଙ୍‌ଲୋଙ୍‌ନମ୍‌ ଡକୋନ୍‌, ପସିୟ୍‌ନମ୍‌ଜିଆଡଙ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଲବଲୋଙନ୍‌ ଅବ୍‌ମାୟ୍‌ମାୟ୍‌ତଜି, ଆରି ଅମଙ୍‌ଲୋଙ୍‌ନମ୍‌ ଅବୟ୍‌ ଅରେଙନ୍‌ ଆରି ଅବୟ୍‌ ଅରେଙନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଅଃନ୍ନବ୍‌ଡକ୍କୋଏଜି, କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ଡିନ୍ନା ଅମଙ୍‌ନମ୍‌ ଅଡ଼ୋତାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ଆଡିଡ୍‌ ଇସ୍ୱରନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଡୋବ୍‌ଡୋବନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତିଆଡିଡ୍‌ ଆମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନମ୍ମଡ୍‌ଲୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ଆରି ଜିସୁନ୍‌ ସରେବାସିଙନ୍‌ ଗନ୍‌ଲନ୍‌, ତମ୍‌ତମ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ଡୁଙେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଡକୋ ଇସ୍ୱରନ୍‌ ବର୍ତନେ, ‘ଅସିଂଞେନ୍‌ ପାର୍ତନାସିଙନ୍‌ ଡେତେ,’ ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ତିଆତେ ରାଉମରଞ୍ଜି ଆ ଡଲ୍ଲି ଏଏମ୍ମେଏନ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ଆରି ଆନିନ୍‌ ଡିତାନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଞନଙନ୍‌ ତିୟେନ୍‌, ବନ୍‌ଡ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି, ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରଞ୍ଜି, ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ବନ୍‌ଡ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ ଆ ଞନଙ୍‌ ଅମ୍‌ଡଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଇନ୍ନିଙ୍‌ ତଙର୍‌ଜା ଅଃଞାଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ବମିୟ୍‌ତା ଜିସୁନ୍‌ ଅଙ୍ଗା ଆଡିଡ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେନ୍‌ ଆରି ମନଙ୍‌ବରନ୍‌ ଅପ୍ପୁଙ୍‌ବରେଞ୍ଜି, ତିଆଡିଡ୍‌ ସୋଡ଼ା ରାଓଡ଼ାନ୍‌ ଡ ସାସ୍ତ୍ରିଞ୍ଜି, ପାପୁର୍‌ମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“ଆମନ୍‌ ଅଙ୍ଗା ଆ ସନୋଡ଼ାନେ ବାତ୍ତେ କେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଲୁମ୍‌ତେ, ଆରି, ଆନା କେନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ଲମ୍‌, ଆନିନ୍‌ ଆନା ? ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ବର୍ରେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ବର୍ନେନ୍‌ ବର୍ତବେନ୍‌, ଞେନ୍‌ ଜାଲଙିଁୟ୍‌ବା, ");
INSERT INTO juy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ଜନନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ସନୋଡ଼ାନେନ୍‌, ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଞାଙେନ୍‌ ଅଡ଼େ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଞାଙେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ସିଲତ୍ତେ ଆନିଞ୍ଜି କଡାଡ଼ିଡାଲନ୍‌ ବର୍ରଞ୍ଜି, “ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଗାମ୍‌ଲବୋ ଡେନ୍‌, ଆନିନ୍‌ ଗାମ୍‌ତେ, ‘ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନିବା ଆମଙନ୍‌ ଏଃଡ୍ଡର୍ରନେ ?’ ");
INSERT INTO juy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଗାମ୍‌ଲବୋ ଡେନ୍‌,’ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ତିଡର୍‌ଡାଲେ ରବ୍ବୁଲଙ୍‌ତଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜନନ୍‌ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଡର୍ତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜାଲଙେଞ୍ଜି, “ତିଆତେ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଡେଏନ୍‌, ତିଆତେ ଇନ୍‌ଲେଞ୍ଜି ଜନା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଅଙ୍ଗା ଆ ସନୋଡ଼ାନେ ବାତ୍ତେ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ତାୟ୍‌, ତିଆତେ ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଃବ୍ବର୍ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବରେଞ୍ଜି । “ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ କୋତ୍ତାଲୋଙନ୍‌ ଦ୍ରାକ୍ୟାନ୍‌ ଗୁଲୁଙ୍‌ଗୁଲେ ତିଆତେ ଅର୍ରମରଞ୍ଜି ଆସିଲୋଙ୍‌ ବାଗାନ୍‌ ତିୟ୍‌ଲେ ଜବ୍ର ଡିନ୍ନା ଆସନ୍‌ ବଡେସାନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ଆରି, ଅର୍ରମରଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଦ୍ରାକ୍ୟାଜନ୍‌ ସିଲଡ୍‌ ଆ ବନ୍ତାନ୍‌ ଅଲ୍‌ତିଏଜି ତିଆସନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ଦ୍ରାକ୍ୟାନ୍‌ ଆ ରନୋଡ୍‌ରୋଡ୍‌ ବେଡ଼ାନ୍‌ ଆମଙ୍‌ବାଞ୍ଜି ଆପ୍ପାୟେନ୍‌, ବନ୍‌ଡ ତି ଅର୍ରମରଞ୍ଜି କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ତିଡ୍‌ଲୋଙ୍‌ ତିଡ୍‌ଲେ ଆରିକ୍କାସିନ୍‌ ଅବ୍‌ୟର୍ନେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ଆନିନ୍‌ ଆରି ଅବୟ୍‌ କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟେନ୍‌; ଆନିଞ୍ଜି, ଆନିନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ତିଡ୍‌ଲୋଙ୍‌ ତିଡ୍‌ଲେ ଅଲ୍ଲଗନ୍‌ଡ୍ରୟ୍‌ ଏମ୍ମେଡାଲେ ଆରିକ୍କାସିନ୍‌ ଅବ୍‌ୟର୍ନେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ୟାଗି ବେଡ଼ାନ୍‌ ନିୟ୍‌ ଆରି ଅବୟ୍‌ କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟେନ୍‌; ବନ୍‌ଡ ଆନିଞ୍ଜି ତି ଆ କମ୍ୱାରିମର୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଅପ୍ପାରାଡାଲେ ଡୁଆରାନ୍‌ ସେଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ସିଲତ୍ତେ ଦ୍ରାକ୍ୟାକୋତ୍ତାମରନ୍‌ ବର୍ରନେ, ‘ଞେନ୍‌ ଇନି ଏଙ୍ଗାଆୟ୍‌ ? ଞେନ୍‌ ଡରୁଙ୍‌ୟମ୍‌ତାଞନ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌, ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଆରୋ ଡେନ୍‌ ମାନ୍ନେତଜି ।’ ");
INSERT INTO juy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ବନ୍‌ଡ ବାଗାଅର୍‌ମରଞ୍ଜି ଦ୍ରାକ୍ୟାକୋତ୍ତାମରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, ‘କେନ୍‌ଆନିନ୍‌ ତ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌, କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏରବ୍ବୁବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନର୍ଜେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଇନ୍‌ଲେନ୍‌ଆତେ ଡେତେ ।’ ");
INSERT INTO juy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ଆରି, ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଦ୍ରାକ୍ୟା କୋତ୍ତାନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ରବ୍ବୁଏଞ୍ଜି ।” “ତିଆସନ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାମରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇନି ଇୟ୍‌ତାୟ୍‌ ଏଙ୍ଗାଏଜି ? ");
INSERT INTO juy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ଆନିନ୍‌ ଜିର୍ରେ ତି ବାଗାଅର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ରବ୍ବୁଆଜେଜି କି ଆନ୍ନାମରଞ୍ଜି ଆସିଲୋଙ୍‌ ଦ୍ରାକ୍ୟାକୋତ୍ତାନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତିୟେଜି ।” କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, “ଏତ୍ତେଲେ ଡେଡଙ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ବର୍ରନେ, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅଙ୍ଗା ବର୍ନେ କେନ୍‌ ଆଇଡିଡନ୍‌ ଡକୋ, କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ ଇନି ?” “ଗୁସିଂମରଞ୍ଜି ଅଙ୍ଗା ଅରେଙ୍‌ ବାସ୍ସେଏଞ୍ଜି, ତିଆତେ କୁନେନ୍‌ ଆ ସୋଡ଼ା ଅରେଙ୍‌ ଡେଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“ତି ଅରେଙ୍‌ଲୋଙନ୍‌ ଆନା ଗଲୋତେ, ଆନିନ୍‌ ଡେୟ୍‌ଡେୟ୍‌ତନେ, ଆରି, ଆନା ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ତି ଅରେଙନ୍‌ ଗଲୋତେ, ତି ଅରେଙନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ରଡ଼ିରଡ଼ି ଏମ୍ମେତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ସିଲତ୍ତେ ସାସ୍ତ୍ରିଞ୍ଜି ଡ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ସିଲତ୍ତେମା ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ସେଙ୍‌ମଡ୍‌ଲେ ବର୍ରନେ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଜନାଏଞ୍ଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସୋଡ଼ାମରନ୍‌ ଡ ରାଜାନ୍‌ ଆସିଲୋଙ୍‌ ସନୋରୋପ୍ପାୟନ୍‌ ଆସନ୍‌ ରୟଙନ୍‌ ସାୟ୍‌ଲେ, ଜିସୁନ୍‌ ଆ ସରିଡ୍‌ସିଡ୍‌ବର୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଇସ୍କତ୍ତାନ୍‌ ବାତ୍ତେ ଆନିଞ୍ଜିଡମ୍‌ ଡରମ୍ମମର୍‌ ଗାମ୍‌ଲେ ଆରବ୍‌ତୁୟ୍‌ତନେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଇନ୍‌ଲେଞ୍ଜି ଏଜନାତାୟ୍‌, ଆମନ୍‌ ଆଜାଡ଼ିନ୍‌ ଆ ବର୍ନେ ବର୍ତନେ ଆରି ଞନଙନ୍‌ ତିୟ୍‌ତେ, ଆରି ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃଡ୍ଡୁଲ୍‌ମଡେ, ଆର୍ପାୟ୍‌ ମନ୍‌ରାଞ୍ଜି ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ଇନି ତିଆତେ ଆଜାଡ଼ିଡମ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ବର୍ରେନ୍‌, କାଇସରନ୍‌ଆଡଙ୍‌ ପାନୁନ୍‌ ତନିୟନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ଅନଗଡନ୍‌ ଡକୋ ଅଡ଼େ ଇଜ୍ଜା ?” ");
INSERT INTO juy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ ସାଡ଼ୁଆଞ୍ଜି ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ଗୁଣ୍ଡାଡାବନ୍‌ ଅବ୍‌ତୁଜିଁୟ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","କେନ୍‌ତେନ୍ନେ ଆନା ଆବବ୍‌ ଆରି ଆନା ଆଞୁମ୍‌ ଡକୋ ?” ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, “କାଇସରନ୍‌ଆତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ସିଲତ୍ତେ ଜିସୁନ୍‌ ବର୍ରନେ, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅଙ୍ଗାତେ କାଇସରନ୍‌ଆତେ ତିଆତେ କାଇସରନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ବା; ଆରି, ଅଙ୍ଗାତେ ଇସ୍ୱରନ୍‌ଆତେ ତିଆତେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ସିଲତ୍ତେ ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଜିସୁନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ସରିଡ୍‌ସିଡ୍‌ବରନ୍‌ ଞମ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି, ଆରି ଆନିଞ୍ଜି ଆ ବର୍ନେଲୋଙନ୍‌ ସାନ୍ନିଡାଲେ କଡ଼ିଙ୍‌ଲେ ସେଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ୟନର୍ମେଙନ୍‌ ଇଜ୍ଜା ଆଗ୍ରାମ୍‌ତେଞ୍ଜି ଆ ସାଦୁକିଜି, ଲାଙ୍‌ଲେନ୍ନେ ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ମୋସାନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ଇଡେନ୍‌, ‘ଅନ୍ନିଙ୍‌ ଆ ମନ୍‌ରା ଆ ବୋଞାଙ୍‌, ଡୁକ୍ରିନ୍‌ ଡକୋନ୍‌ ଡକୋନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ କୋଡନେନ୍‌ ରବୁଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆ ବୋଞାଙନ୍‌, ତି ଜୁଆର୍‌ବଜନ୍‌ ବୟନ୍‌ ବିବାଡାଲନ୍‌ ଆ ବୋଞାଙନ୍‌ ଆସନ୍‌ ପସିଜନ୍‌ କୋଡେତୋ ।’ ");
INSERT INTO juy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ସାତ ବନୋଞାଙ୍‌ ଡକୋଏଞ୍ଜି; ଆମ୍ମୁଙ୍‌ମର୍‌ ଅବୟ୍‌ ଆଇବଜନ୍‌ ବୟନ୍‌ ବିବାଲନ୍‌ ବନ୍‌ଡ ଅଣ୍ଡ୍ରଙ୍‌ କୋଡନେନ୍‌ ରବୁଏନ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ତିକ୍କି ଆ ସନଣ୍ଡୋଙ୍‌ମର୍‌ ତି ଆଇବଜନ୍‌ ବୟନ୍‌ ବିବାଲନେ ଆରି ଆନିନ୍‌ ନିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ କୋଡନେନ୍‌ ରବୁଏନ୍‌, ଆରି ତି ଆ ସନଣ୍ଡୋଙ୍‌ମର୍‌ ତି ଆଇବଜନ୍‌ ବୟନ୍‌ ବିବାଲନେ ଆରି ଆନିନ୍‌ ନିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ କୋଡନେନ୍‌ ରବୁଏନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ତିଅନ୍ତମ୍‌ ସାତ ବନୋଞାଙଞ୍ଜି ଅବୟ୍‌ନେ ଆର୍ରବୁଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆରି ଅବୟ୍‌ନେ ତି ଆବୟନ୍‌ ଆଇବୟ୍‌ ବୟନ୍‌ ବିବାଲଞ୍ଜି, ବନ୍‌ଡ ଆନ୍ନିଙ୍‌ଜା ଅଃକ୍କୋଡନ୍‌ଲଜି । ଅଡ଼୍‌କୋଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ କୋଡନେଞ୍ଜି ରବୁଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ତିକ୍କି ତି ଆଇବଜନ୍‌ ନିୟ୍‌ ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ଏତ୍ତେଲ୍‌ଡେନ୍‌, ସାତଜଣଞ୍ଜି ତ ତି ଆଇବଜନ୍‌ ବୟନ୍‌ ବିବାଲଞ୍ଜି, ୟନର୍ମେଙ୍‌ ଇଙନ୍‌ ଆନିଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ତି ଆଇବଜନ୍‌ ଆନା ଆ ଡୁକ୍ରି ଡେତେ ?” ");
INSERT INTO juy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “କେନ୍‌ ପୁର୍ତିନ୍‌ ଆ ମନ୍‌ରାଜି ଞାଙ୍‌ବୟ୍‌ତଞ୍ଜି ଆରି ସୁଉଂତଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରାଜି ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ୟନର୍ମେଙନ୍‌ ଆସନ୍‌, ଆରି ପୁର୍ବାଃତେ ଆଜିର୍ତାଞନ୍‌ ଆ ପୁର୍ତିଲୋଙ୍‌ ଡକୋନେନ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ଗାମ୍‌ଲେ ଡନିଡିନ୍‌ ଡେତଜି, ଆନିଞ୍ଜି ଅଃଞାଙ୍‌ବୟ୍‌ନେଜି କି ଅଃସୁଉଂନେଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ଆରି ଆନିଞ୍ଜି ଅଃର୍ରବୁଏଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଅନ୍ତମ୍‌ ଡକୋତଞ୍ଜି, ଆରି ୟନର୍ମେଙନ୍‌ ଆ ଅଅନ୍‌ ଆଡ୍ରେଏଞ୍ଜି ଆସନ୍‌ ଆନିଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ଅଅନ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ଆରି ଆରବୁମରଞ୍ଜି ଡୋତଞ୍ଜି, ମୋସାନ୍‌ ନିୟ୍‌ ଜାଡ଼ିଆନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ‘ଅବ୍ରାମନ୍‌ ଆ ଇସ୍ୱର, ଇସାକନ୍‌ ଆ ଇସ୍ୱର, ଜାକୁବନ୍‌ ଆ ଇସ୍ୱର’ ଗାମ୍‌ଲେ ବର୍ରନ୍‌ ଅବ୍‌ଜନାଲଙ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ଆନିନ୍‌ ତ ଆରବୁମରଞ୍ଜି ଆ ଇସ୍ୱର ତଡ୍‌, ଆର୍ପାୟ୍‌ ଆମେଙ୍‌ମରଞ୍ଜି ଆ ଇସ୍ୱର; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଆମେଙ୍‌ଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ସିଲତ୍ତେ ସାସ୍ତ୍ରିଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ବର୍ରଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଆମନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ରନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆରି ଅନ୍ନିଙ୍‌ ଆ ବର୍ନେ ଆନିନ୍‌ଆଡଙ୍‌ ବନରନ୍‌ ଆସନ୍‌ ଅଃନ୍ନୋମଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କ୍ରିସ୍ଟନ୍‌ ଦାଉଦନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, କେନ୍‌ଆତେ ମନ୍‌ରାଞ୍ଜି ଏଙ୍ଗାଡାଲେ ବର୍ତଞ୍ଜି ? ");
INSERT INTO juy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଦାଉଦନ୍‌ ଆନିନ୍‌ଡମ୍‌ କନନ୍‌ବଇଲୋଙନ୍‌ ବର୍ତନେ, ‘ପ୍ରବୁନ୍‌ ପ୍ରବୁଞେନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ଞେନ୍‌ ଅଙ୍ଗା ଜାୟ୍‌ ବନେରାନମ୍‌ଜିଆଡଙ୍‌ ଡରକ୍କୋଜଙ୍‌ନମ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏମ୍ମେଆଜି, ତି ଜାୟ୍‌ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ଞେନ୍‌ ତଙ୍କୁମ୍‌ଲେ ଡକୋନା ।’ ");
INSERT INTO juy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ଦାଉଦନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ‘ପ୍ରବୁ’ ଗାମ୍‌ଲେ ଓଡ୍ଡେତେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଏଙ୍ଗାଡାଲେ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଡେଏ ?” ");
INSERT INTO juy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ତିକ୍କି ମନ୍‌ରାଞ୍ଜି ଆରମ୍‌ଡଙେଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ସାସ୍ତ୍ରିଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଆବ୍ବୟ୍‌ଡମ୍‌ନାବା ! ଆନିଞ୍ଜି ଡେଙ୍ଗାରାଡମନ୍‌ ଆ ଅଙ୍ଗି ରଲନ୍‌ ବନୁଲ୍ଲେନ୍‌ ଆସନ୍‌, ଆରି ସୟ୍‌ତାରେଙନ୍‌ ଅବ୍‌ଲୋମ୍‌ଲୋମ୍‌ନେନ୍‌, ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ସୋଡ଼ା ତରଙ୍କୁମନ୍‌, ଆରି ବୁଜିଲୋଙନ୍‌ ମନଙ୍‌ ତରଙ୍କୁମନ୍‌ ଲଡୟ୍‌ତଜି; ");
INSERT INTO juy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ଆନିଞ୍ଜି ଜୁଆର୍‌ବଜଞ୍ଜି ଆସିଂ ଅଡ଼୍‌କୋନ୍‌ ମତଜି ଆରି ଅବ୍‌ତୁୟ୍‌ଡାଲନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ପାର୍ତନାତଞ୍ଜି, ଆନିଞ୍ଜି ଆକ୍ରାନ୍‌ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତଜି !” ");
INSERT INTO juy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଏର୍ରେ ଆଙାଙ୍‌ଡାଲନ୍‌, ଗମାଙ୍‌ମରଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ତନିୟ୍‌ତିୟଞ୍ଜି ସରେବାସିଙନ୍‌ ଆ ପିଡ଼ିଲୋଙ୍‌ ଆପ୍ରିଡେଞ୍ଜି ଗିଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ଆରି, ଅବୟ୍‌ ଡୋଲେୟ୍‌ ଜୁଆର୍‌ବଜନ୍‌ ବାଗୁ ସନ୍ନାରାଡମ୍‌ ଆ ଗୁଣ୍ଡାଡାବ୍‌, ତେତ୍ତେ ଆପ୍ରିଡେନ୍‌ ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଗିୟ୍‌ଲେ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ ଡୋଲେୟ୍‌ ଜୁଆର୍‌ବଜନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ ପିଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆନର୍ଜେଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଅସୋୟ୍‌ ଅସୋୟ୍‌ ସରେବାସିଙନ୍‌ ଆ ପିଡ଼ିଲୋଙ୍‌ ପିଡେଞ୍ଜି, ବନ୍‌ଡ କେନ୍‌ଆନିନ୍‌ ଡୋଲେଜିଙନ୍‌ ଆ ପରାନ୍ନାନ୍‌ ଅନବ୍‌ମେଙନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ଡିଅଙ୍ଗା ଡକୋଏନ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌ ପିଡାଜେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି, ସରେବାସିଙନ୍‌ ମନଙ୍‌ ମନଙ୍‌ ଅରେଙନ୍‌ ଡ ତନିୟ୍‌ତିୟ୍‌ ଜନବଞ୍ଜି ବାତ୍ତେ, ମନଙ୍‌ଡମ୍‌ ଆତୁବ୍‌ତୁବ୍‌ ଗାମ୍‌ଲେ ବର୍ରଞ୍ଜି, ବନ୍‌ଡ ଜିସୁନ୍‌ ଗାମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“ଅଙ୍ଗାତେ ନମି ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଏଗିୟ୍‌ତେ, ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ଅବୟ୍‌ ଅରେଙନ୍‌ ଆରି ଅବୟ୍‌ ଅରେଙନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଅଃଡ୍ଡକୋଏ, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲବଲୋଙନ୍‌ ମାୟ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌ ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଙ୍ଗା ଡେତେ ? ଆରି, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଡ୍ରେରୟ୍‌ତେନ୍‌ ଆଡିଡ୍‌, ତି ଆ ଡିନ୍ନା ଇନିଜି ଇନିଜି ଅରମ୍ମଡନ୍‌ ଗିୟ୍‌ତାତେ ?” ");
INSERT INTO juy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ସିଲତ୍ତେ ଜିସୁନ୍‌ ବର୍ରନେ, “ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି କନଣ୍ଡାୟ୍‌ଲୋଙନ୍‌ ଗଲୋଡଙ୍‌ବେନ୍‌ ତଡ୍‌ ତିଆସନ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଇୟ୍‌ଲେ, ‘ଞେନ୍‌ ଆନିନ୍‌,’ ଆରି ‘ଡିନ୍ନାନ୍‌ ତୁୟାୟ୍‌ଲାୟ୍‌’ ଗାମ୍‌ଲେ ଇୟ୍‌ତାୟ୍‌ ବର୍ନେଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଏସଣ୍ଡୋଙ୍‌ଡଙ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ବନ୍‌ଡ ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି, ଅଲ୍‌ତିଡନ୍‌ ଡ ଗୋଡ଼େନ୍‌ ଆ ବର୍ନେଜି ଏଅମ୍‌ଡଙ୍‌ତେ, ତିଆଡିଡ୍‌ ବତଙ୍‌ଡଙ୍‌ବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆତେଜି ଆମ୍ମୁଙ୍‌ ଡେତେମା, ବନ୍‌ଡ ସିଲତ୍ତେମା ଜୁଗନ୍‌ ଅଃନ୍ନଞିଡେ ।” ");
INSERT INTO juy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ସିଲତ୍ତେ ଜିସୁନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଡେସାନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡେସାନ୍‌, ଆରି ରାଜ୍ୟନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ରାଜ୍ୟନ୍‌ ଡୋତନେ, ");
INSERT INTO juy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ଆରି ସୋଡ଼ାରା ତକର୍‌ଲନ୍‌ ଡେତେ, ଲାଙ୍‌ଲେନ୍ନେରେଙ୍‌ କାନ୍ତାରାନ୍‌ ଡ ରୋଗାନ୍‌ ଡେତେ, ଆରି ରୁଆଙନ୍‌ ସିଲଡ୍‌ ବରନ୍ତଙ୍‌ଡାନ୍‌ ଆ ଗନଡେଲ୍‌ ଆରି ସୋଡ଼ା ସୋଡ଼ା ଅରମ୍ମଡଞ୍ଜି ଗିୟ୍‌ତାତେ । ");
INSERT INTO juy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ବନ୍‌ଡ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଡ୍ରେତେନ୍‌ ଆମ୍ମୁଙ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଞମ୍‌ତବେଞ୍ଜି ଆରି ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ଡ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ଡାଲେ ଡଣ୍ଡାୟ୍‌ତବେଞ୍ଜି, ଆରି ଅଞୁମ୍‌ଞେନ୍‌ ଆସନ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ରାଜାନ୍‌ ଡ ସୋଡ଼ାମରଞ୍ଜି ଆ ମୁକ୍କାବା ଓରୋଙ୍‌ତବେଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","କେନ୍‌ଆତେ ଡନେଲୋଙ୍‌ଞେନ୍‌ ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ରନୟଙ୍‌ବେନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ତିଆସନ୍‌, ଇନି ଏଜାଲଙାୟ୍‌ ଗାମ୍‌ଲେ ତି ଆ ବର୍ନେଲୋଙ୍‌ ଆମ୍ମୁଙ୍‌ମା ଏର୍‌ନିଃୟମ୍‌ନେନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ମନ୍ନଲୋଙ୍‌ ଗବ୍‌ରିବା । ");
INSERT INTO juy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏତ୍ତେଲେ ବର୍ନେନ୍‌ ଡ ଜନନାନ୍‌ ତିୟ୍‌ତବେନ୍‌ ଡ, ବନେରାମର୍‌ବେଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ତିଆତେ ଡଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଏଜି କି ଗଡ୍‌ଲେ ଅଃର୍ରପ୍ତିଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅୟୋଙ୍‌, ଆପେୟ୍‌, ବୋଞାଙ୍‌, କୁଲମ୍‌, ଗଡ଼ିବେଞ୍ଜି ନିୟ୍‌ ସୋରୋପ୍ପାୟ୍‌ତବେଞ୍ଜି, ଆରି ମନ୍‌ରାଞ୍ଜି ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ରବ୍ବୁତବେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ଆରି ଅଞୁମ୍‌ଞେନ୍‌ ଆସନ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଏଡ଼ୁର୍‌ମଡ୍‌ତବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ବନ୍‌ଡ ଅବବ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆ ଉଉ ଜାକିଁୟ୍‌ ଅଃମ୍ମୋସ୍ସାଏ । ");
INSERT INTO juy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ଏର୍‌କିକ୍କିଡ୍‌ନେନ୍‌ ଏଡକୋଲନ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ପରାନ୍ନା ଏଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ଅଙ୍ଗା ଆଡିଡ୍‌ ଜିରୁସାଲମନ୍‌ ସିପ୍ପାୟଞ୍ଜି ଗେରେତଜି, ତିଆତେ ଆମ୍ୱେନ୍‌ ଏଗିଜେନ୍‌ ଡେନ୍‌, ତିଆଡିଡ୍‌ ତିଆତେ ସିସିଂତେ ଗାମ୍‌ଲେ ଜନାବା । ");
INSERT INTO juy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ତିଆଡିଡ୍‌ ଆନାଜି ଜିଉଦା ଡେସାଲୋଙନ୍‌ ଡକୋତଜି, ଆନିଞ୍ଜି ବରୁରେଙନ୍‌ ଜିରେତଜି; ଆରି ଆନାଜି ଅମ୍ମ ଗଡ଼ାନ୍‌ ଡକୋତଜି, ଆନିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିରେତଜି; ଆରି ଆନାଜି ସାଇରେଙନ୍‌ ଡକୋତଜି, ଆନିଞ୍ଜି ଗଡ଼ାଲୋଙନ୍‌ ଗନ୍‌ଡଙାଜି ତଡ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆଇଡିଡନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡେଡମ୍‌ତେ, ତିଆସନ୍‌ ତିଆତେ ପନବ୍‌ରଡନ୍‌ ଆ ବନେଡ଼ା । ");
INSERT INTO juy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ତିଆଡିଡ୍‌ ଆନାଜି ଆତିଲ୍‌କୋଡ୍‌ଜି ଆରି ମେମେଅନ୍‌ତଞ୍ଜି, ୟୋଙ୍‌, ଆନିଞ୍ଜି ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତଜି । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଡେସାଲୋଙନ୍‌ ଆକ୍ରାନ୍‌ ବରନ୍ତଙନ୍‌ ଡେତେ ଆରି ଇସ୍ୱରନ୍‌ କେନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ପବ୍‌ରଡ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ଆନିଞ୍ଜି କଡ଼ିବନ୍‌ ବାତ୍ତେ ରବୁତଜି ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ଏର୍‌ଡର୍ନେମରଞ୍ଜି ଞମ୍‌ଲେ ବଣ୍ଡିଡାଲେ ପାଙ୍‌ତଜି, ଆରି ଆ ଡିନ୍ନାଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ବରିଜେନ୍‌ ଜାୟ୍‌ ଆନିଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଞାଡୁବ୍‌ଲେ ଡକ୍କୋତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ଆରି, ଓୟୋଙନ୍‌, ଆଙ୍ଗାୟ୍‌ତାନ୍‌ ଡ ତୁତୁୟ୍‌ଲୋଙନ୍‌ ଅରମ୍ମଡନ୍‌ ଗିୟ୍‌ତାତେ, ଆରି, ପୁର୍ତିଲୋଙନ୍‌ ଅଡ଼୍‌କୋ ଡେସାନ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତଜି; ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଡ ଇଡ୍ଡୋୟ୍‌ଡାନ୍‌ ଆ ସନଡ୍ଡାବାତ୍ତେ ଆନିଞ୍ଜି ଉଲ୍ଲୁତଜି । ");
INSERT INTO juy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ଆରି ପୁର୍ତିଲୋଙନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଆ ଗନଡେଲ୍‌ଜି ଜଗେଡାଲେ, ମନ୍‌ରାଞ୍ଜି ବନ୍ତଙନ୍‌ ବାତ୍ତେ ରାଇଡ୍‌ତଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙନ୍‌ ଆ ବୋର୍ସାଜି ଅଡ଼୍‌କୋନ୍‌ ୟୁଆୟ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ତିଆଡିଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡ ଆ ବୋର୍ସାନ୍‌ ବାତ୍ତେ ମେଗଲୋଙନ୍‌ ଜିର୍ତାୟ୍‌, ତିଆତେ ମନ୍‌ରାଞ୍ଜି ଗିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ଆରି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଗନଡେଲଞ୍ଜି ଉଲନ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ତୋଣ୍ଡୋନ୍‌ ଆଙାଙ୍‌ବା ଆରି ମାଙ୍ଗୋବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅନୁର୍‌ବେନ୍‌ ତୁୟାଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବୟ୍‌ ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବରେଞ୍ଜି, “ଲୁଆନୁବନ୍‌ ଡ ଅଡ଼୍‌କୋନ୍‌ ଅରାନୁବଞ୍ଜି ଗିୟ୍‌ବା; ");
INSERT INTO juy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ଅଙ୍ଗା ଆଡିଡ୍‌ ତିଆତେଜି ଲେଡେଙ୍‌ତେ, ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଗିୟ୍‌ଲେ, ବୌସାକନ୍‌ ଆଙ୍ଗାୟ୍‌ ତୁୟାଲାୟ୍‌ନି ଗାମ୍‌ଲେ ଏଜନାତେ । ");
INSERT INTO juy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ତିଅନ୍ତମ୍‌ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଗନଡେଲଞ୍ଜି ଏଗିଜେନ୍‌ ଡେନ୍‌, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ତୁୟାଲାୟ୍‌, କେନ୍‌ଆତେ ଜନାବେନ୍‌ତୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗଡେଲେନ୍‌ ଜାୟ୍‌ ନମି ଆ ମନ୍‌ରାଜି ଏଙ୍ଗାଲେଜନଙ୍‌ ଅଃନ୍ନାଡ଼ଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ରୁଆଙନ୍‌ ଡ ପୁର୍ତିନ୍‌ ଆଡ଼ତେ ବନ୍‌ଡ ବର୍ନେଞେଞ୍ଜି ଆଙ୍ଗିୟ୍‌ ଅଃନ୍ନାଡ଼ଏ ।” ");
INSERT INTO juy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା, ଅସମୟ୍‌ ଉଗର୍‌ବେନ୍‌ ଗାଗାନେ ଜୋମ୍‌ଜୋମ୍‌ନେଲୋଙନ୍‌ ମଗାଡ୍‌ତବେନ୍‌, ଗାସାଲ୍‌ଡାଲନ୍‌ ବନ୍ନୁଲାୟ୍‌ତବେନ୍‌, ଆରି ଅନମେଙନ୍‌ ଆସନ୍‌ ଅନିଃୟମ୍‌ଲୋଙନ୍‌ ଲଗିନ୍‌ଡମ୍‌ ଡେତେ, ତି ଆ ଡିନ୍ନା ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ଡଅଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗଲୋଏ । ");
INSERT INTO juy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆତେ ଜନ୍ତାନ୍‌ ଅନ୍ତମ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଆଡ୍ରକୋତଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଅଡ଼ୋତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଆ ଗଡେଲ୍‌ଜି ସିଲଡ୍‌ ଏଡୋବ୍‌ତନେ ଆରି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ମୁକ୍କାବା ତନଙ୍‌ଲେ ଏରପ୍ତିତେ ତିଆସନ୍‌ ଡିତାନ୍‌ ଜଗେଡାଲେ ପାର୍ତନାନାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ଜିସୁନ୍‌ ଡିତାନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଞନଙନ୍‌ ତିୟେନ୍‌, ଆରି ଡିଲେ ତଗଲନ୍‌ ଆନିନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଜିତବୁରନ୍‌ ଇୟ୍‌ଲେ ଡକୋନେ । ");
INSERT INTO juy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ଆରି, ଡୋତାନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ ଆ ଞନଙ୍‌ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ସରେବାସିଙନ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ଏଲାୟ୍‌ପୁର୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ କମିରନ୍‌ ଏର୍‌ମନାୟ୍‌ ରୁଟିନ୍‌ ଆ ଜୋମ୍‌ଜୋମ୍‌ ଡିନ୍ନାନ୍‌ ତୁୟାଲେ ପାଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ଆରି ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅଜନା ରବ୍ବୁଲେ ରପ୍ତିଏଜି, ତିଆସନ୍‌ ତଙରନ୍‌ ସାଜେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ତିଆଡିଡ୍‌ ବାରଜଣଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଇସ୍କାରିତ ଜିଉଦାନ୍‌ ଆ ଉଗର୍‌ଲୋଙ୍‌ ସନୁମନ୍‌ ଗନେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ଆରି ଆନିନ୍‌ ଜିର୍ରେ ଏଙ୍ଗାଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସୋଡ଼ା ସିପ୍ପାୟଞ୍ଜି ଆସିଲୋଙ୍‌ ଅବ୍‌ଞମ୍‌ଞମେଜି ତିଆସନ୍‌ ଆନିନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଇୟ୍‌ଲେ କଡାଡ଼ିନେ । ");
INSERT INTO juy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ସିଲତ୍ତେ ଆନିଞ୍ଜି ସର୍ଡାଏଞ୍ଜି କି ତଙ୍କାନ୍‌ ଏତିୟ୍‌ତମ୍‌ ଗାମ୍‌ଲେ ବାସାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ଆରି ଆନିନ୍‌ ଅଡ଼େଡାଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆସିଲୋଙଞ୍ଜି ଅନବ୍‌ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ରୟଙନ୍‌ ସାୟ୍‌ଲେ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ତିକ୍କି ଅଙ୍ଗା ଆଡିଡ୍‌ ଏଲାୟ୍‌ପୁର୍‌ ଇଙନ୍‌ ମେଣ୍ଡାଅନନ୍‌ ଅନମଙନ୍‌ ତନିୟନ୍‌ ଡେତେ, କମିରନ୍‌ ଏର୍‌ମନାୟ୍‌ ରୁଟିପୁର୍‌ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ଜିସୁନ୍‌ ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ଆଡଙ୍‌ ଏନ୍ନେଲେ ବର୍ରେ ଆପ୍ପାୟେଞ୍ଜି, “ଗାଗାନେଲେନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଜିର୍ରେ ଏଲାୟ୍‌ପୁର୍‌ ଜନୋମନ୍‌ ଇୟ୍‌ନବ୍‌ଜାଡାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗାମେଞ୍ଜି, “ଇନ୍‌ଲେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ କେନ୍‌ଆତେ ଏଅବ୍‌ଜାଡାନାୟ୍‌ ଗାମ୍‌ଲେ ଆମନ୍‌ ଲଡୟ୍‌ତମ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଗିୟ୍‌ବା, ଆମ୍ୱେନ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ଆଗ୍ରନ୍‌ତେନ୍‌ ଆଡିଡ୍‌, ସୁତ୍ତିଲୋଙନ୍‌ ଡାଆନ୍‌ ଆପ୍ରାଙ୍‌ତେନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେନ୍‌ ଇୟ୍‌ତେ ଏରବାଙେ; ଆନିନ୍‌ ଅଙ୍ଗା ଆସିଂ ଇୟ୍‌ତେ ଗନେ, ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଡାଲେ ତି ଆସିଂ ଇୟ୍‌ଲେ ଅସିଙନ୍‌ ଆ ମୁଡ଼ମର୍‌ଆଡଙ୍‌ ଇୟ୍‌ ବର୍ବା, ");
INSERT INTO juy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","‘ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, ଞେନ୍‌ ଞଙ୍‌ନେମର୍‌ଞେଞ୍ଜି ସରିନ୍‌ ଅଙ୍ଗାସିଂଲୋଙ୍‌ ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆ ଜନୋମ୍‌ ପାଡ଼େତନାୟ୍‌, ତି ଆ କନୁଆମର୍‌ସିଂ ଅଡ଼େଙ୍ଗା ?’ ");
INSERT INTO juy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ସିଲତ୍ତେ ଆନିନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଜାଡାଆୟ୍‌ ଅବୟ୍‌ ସୋଡ଼ାଡମ୍‌ ଆସିଂ ତୋଣ୍ଡୋ ମେଡ଼ନ୍‌ଆତେ ଅବ୍‌ତୁୟ୍‌ତବେନ୍‌; ତେତ୍ତେ ଇୟ୍‌ନବ୍‌ଜାଡାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ଆରି ଆନିଞ୍ଜି ଜିର୍ରେ, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଏଙ୍ଗାଲେ ବରେଞ୍ଜି, ଏତ୍ତେଲେମା ଇୟ୍‌ଲେ ଗିଜେଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆ ଜନୋମ୍‌ ଇୟ୍‌ଲେ ଅବ୍‌ଜାଡାଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ଆରି, ଡିନ୍ନାନ୍‌ ଆରଡ଼ୋଲାଞନ୍‌, ଜିସୁନ୍‌ ଅନାପ୍ପାୟଞ୍ଜି ସରିନ୍‌ ଗାଗାନେନ୍‌ ତଙ୍କୁମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଡଣ୍ଡନ୍‌ ଞରାଙ୍‌ତାଞନ୍‌ ଆମ୍ମୁଙ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ କେନ୍‌ ଅନେଲାୟ୍‌ପୁର୍‌ ଜନୋମନ୍‌ ଜୋମ୍‌ଜୋମନ୍‌ ଆସନ୍‌ ମାଡ୍ଡ ଲଡୟ୍‌ଲିଁୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ କେନ୍‌ ଆ ଗରାମ୍‌ଗାମନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗିୟ୍‌ତାଏନ୍‌ ଜାୟ୍‌ ଞେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଆରି କେନ୍‌ଆତେ ଅଃଜ୍ଜୋମାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ଆରି ଆନିନ୍‌ ଗିଲ୍ଲନ୍‌ ଞମ୍‌ଲେ, ସନେନ୍‌ସେନନ୍‌ ତିୟ୍‌ଲେ ବର୍ରନେ, “କେନ୍‌ଆତେ ପାଙ୍‌ଲେ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ବେନ୍‌ ବନ୍ତାନାବା । ");
INSERT INTO juy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଅଣ୍ଡ୍ରଙ୍‌ ଜିରାଞନ୍‌ ଜାୟ୍‌ ଞେନ୍‌ ଲଙେ ସିଲଡ୍‌ ଆଙ୍ଗିୟ୍‌ ଆରି ଦ୍ରାକ୍ୟାଡାନ୍‌ ଅଃଗାଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ଆରି, ରୁଟିନ୍‌ ଞମ୍‌ଲେ ସନେନ୍‌ସେନନ୍‌ ତିୟେନ୍‌, ଆରି ତିଆତେ ରେବ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ଲେ ବର୍ରନେ, “ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ତନିୟନ୍‌ ଆଡ୍ରେଏନ୍‌ କେନ୍‌ଆତେ ଡଅଙ୍‌ଞେନ୍‌; ଞେନ୍‌ଆଡଙ୍‌ ମନନ୍ନେନ୍‌ ଆସନ୍‌ କେନ୍‌ଆତେ ଲୁମ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ଆଜ୍ରୋମେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତିଅନ୍ତମ୍‌ ଆନିନ୍‌ ଗିଲ୍ଲନ୍‌ ଞମ୍‌ଲେ ବର୍ରନେ, “କେନ୍‌ ଗିଲ୍ଲନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଆଜ୍ରତଡେନ୍‌ ମିଞାମ୍‌ଞେନ୍‌ ବାତ୍ତେ ଗନବ୍‌ରିନ୍‌ ଆଡ୍ରେଏନ୍‌ କେନ୍‌ ରଙ୍‌ ଅନଗଡନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ବନ୍‌ଡ ଗିୟ୍‌ବା, ଆନା ଞେନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତିଁୟ୍‌, ଆସିନ୍‌ ଞେନ୍‌ ସରିନ୍‌ ତୋଣ୍ଡୋ ମେଜଲୋଙନ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏଙ୍ଗାଲେ ଆଇଡିଡନ୍‌ ଡକୋ, ଏତ୍ତେଲେମା ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ରବୁତେ, ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତେ, ୟୋଙ୍‌ ତି ଆ ମନ୍‌ରା ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ତିଆସନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନା କେନ୍‌ଆତେ ଲୁମ୍‌ରୟ୍‌ତେ, ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ଆରି, ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଆନା ସୋଡ଼ା ଗାମ୍‌ଲେ ଡନିଡିନ୍‌ ଡେତେ, ତିଆସନ୍‌ ଆନିଞ୍ଜି ତର୍ଡମ୍‌ ଅଲ୍‌ଡୁଲ୍‌ବାଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏର୍‌ଡର୍ନେମରଞ୍ଜି ଆ ରାଜାଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ସାସନତଜି, ଆରି ଆନାଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ସାସନତଜି ଆନିଞ୍ଜି ‘ସନାୟୁମ୍‌ମର୍‌’ ଗାମ୍‌ଲେ ବର୍ନେନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ତିଅନ୍ତମ୍‌ ଡେଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ସିନା ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଆନା ସୋଡ଼ା, ଆନିନ୍‌ ଆ ସନ୍ନାଗୋ ଡେଏତୋ, ଆରି ଆନା ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମର୍‌ ଆନିନ୍‌ କମ୍ୱାରିମର୍‌ଗୋ ଡେଏତୋ । ");
INSERT INTO juy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ସୋଡ଼ା ? ଅଙ୍ଗା ମନ୍‌ରା ତଙ୍କୁମ୍‌ଡାଲେ ଗାଗାତନେ, ଆନିନ୍‌ ସୋଡ଼ା ଅଡ଼େ, ଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ରୋଜୋମ୍‌ତେ, ଆନିନ୍‌ ସୋଡ଼ା ? ଅଙ୍ଗା ମନ୍‌ରା ତଙ୍କୁମ୍‌ଡାଲେ ଗାଗାତନେ ଆନିନ୍‌ ପଙ୍‌ ସୋଡ଼ା ତଡ୍‌ ? ବନ୍‌ଡ ଞେନ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଅବୟ୍‌ ସାନାକ୍କେମରନ୍‌ ଅନ୍ତମ୍‌ ଡକୋତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“ବନ୍‌ଡ ଅଡ଼୍‌କୋ ମନାଲ୍‌ମାଲ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ ସରିନ୍‌ ଡକୋଲନ୍‌ ଏଜିର୍ତାୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ତିଆସନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଏଙ୍ଗାଲେ ଞେନ୍‌ ଆସନ୍‌ ରାଜ୍ୟନ୍‌ ସେଡାଏନ୍‌, ତିଅନ୍ତମ୍‌ ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ସେଡାତାୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ଆରି ଆମ୍ୱେଞ୍ଜି ରାଜ୍ୟଲୋଙ୍‌ଞେନ୍‌ ମେଜଲୋଙ୍‌ଞେନ୍‌ ଏଗାଗାତନେ, ଆରି ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ବାର କେଜ୍ଜା ଇସ୍ରାଏଲନ୍‌ଆଡଙ୍‌ ଏସାସନତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ସିମନ୍‌, ସିମନ୍‌, ଗିଜା, ଗମ୍ମନ୍‌ ସାଲୁଣିଲୋଙନ୍‌ ଆସ୍ରଲାୟ୍‌ତବନ୍‌ ଅନ୍ତମ୍‌, ସନୁମନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ସନଲ୍ଲାୟନ୍‌ ଆସନ୍‌ ରୟଙନ୍‌ ଞାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ବନ୍‌ଡ ଡର୍ନେନମ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆଡ଼ଡଙେ ତଡ୍‌, ତିଆସନ୍‌ ଞେନ୍‌ ଆମନ୍‌ ଆସନ୍‌ ପାର୍ତନାଲନାୟ୍‌; ଆରି ଆମନ୍‌ ୟର୍ରନାୟ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ବୋଞାଙ୍‌ନମ୍‌ଜିଆଡଙ୍‌ ଆୟ୍‌ନବ୍‌ବୋର୍ସାଆଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ପ୍ରବୁ, ଆମନ୍‌ ସରିନ୍‌ ବଣ୍ଡିସିଙନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ଡ ରନବୁନ୍‌ ଆସନ୍‌ ନିୟ୍‌ ଞେନ୍‌ ଆଜାଡା ।” ");
INSERT INTO juy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ବନ୍‌ଡ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଏ ପିତ୍ର, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, ଲଙେ ଆ ତଗଲ୍‌ କମ୍‌ସିମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଓଲେନ୍‌ ଆମନ୍‌ ୟାଗି ତର ଞେନ୍‌ଆଡଙ୍‌ ମୁର୍ସେତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ଆରି, ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅଙ୍ଗା ଆଡିଡ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଗାଞ୍ଜିଆନ୍‌, ମୁନାନ୍‌, ପାଣ୍ଡୋୟନ୍‌ ଏର୍‌ପନାଙନ୍‌ ଆପ୍ପାୟ୍‌ଲବେନ୍‌, ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନ୍ନିଙ୍‌ ପଙ୍‌ ଅବାବ ଡେଲବେନ୍‌ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଇଜ୍ଜା ଇନ୍ନିଙ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ନମି ଆନା ଆମଙ୍‌ ଗାଞ୍ଜିଆନ୍‌ ଡକୋ, ଆନିନ୍‌ ତିଆତେ ପାଙେତୋ, ତିଅନ୍ତମ୍‌ ମୁନାନ୍‌ ନିୟ୍‌ ପାଙେତୋ, ଆରି ଆନା ଆମଙ୍‌ କଡ଼ିବନ୍‌ ଅବୟ୍‌ ତଡ୍‌, ଆନିନ୍‌ ଆ ମାଟନ୍‌ ଅବୟ୍‌ ତମ୍‌ଲେ କଡ଼ିବନ୍‌ ଞିଏତୋ । ");
INSERT INTO juy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଞେନ୍‌ ଆସନ୍‌ ଏନ୍ନେଲେ ଅନିଡଲନ୍‌ ଡକୋ, ‘ଆନିନ୍‌ ଏର୍‍ମଡ଼ିର୍‍ମରଞ୍ଜି ସରିନ୍‌ ଡନିଡିନ୍‌ ଡେଏନ୍‌,’ କେନ୍‌ ଆଇଡିଡନ୍‌ ଆ ବର୍ନେ ଅମଙ୍‌ଞେନ୍‌ ଡେଡମେତୋ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ଆଇଡିଡନ୍‌ ଆ ବର୍ନେଜି ଡେଡମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ସିଲତ୍ତେ ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, “ପ୍ରବୁ ଗିଜା କେନ୍‌ତେନ୍ନେ ବାଗୁ କଡ଼ିବନ୍‌ ଡକୋ ।” ଆରି, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଡିୟ୍‌ତେ ସରି ।” ");
INSERT INTO juy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ଡିତାନ୍‌ ଅନ୍ତମ୍‌ ଜିସୁନ୍‌ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିତବୁରନ୍‌ ଜିରେନ୍‌, ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ନିୟ୍‌ ଆ କଣ୍ଡୋଙ୍‌ଗଡନ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ତେତ୍ତେ ତୁଙେଞ୍ଜି କି ଆନିନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, “ମନାଲ୍‌ମାଲ୍‌ଲୋଙନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଗଲୋଡଙ୍‌ବେନ୍‌ ତଡ୍‌ ତିଆସନ୍‌ ପାର୍ତନାନାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ଆରି, ଆନିନ୍‌ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଡାସଙାୟ୍‌ ଜିର୍ରେ ତୁଡ଼ୁମ୍‌ଡାଲେ ଇୟ୍‌ଲେ ପାର୍ତନାନେ, ");
INSERT INTO juy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ଏ ଆପେୟ୍‌, ଇସ୍ସୁମ୍‌ନମ୍‌ ଡେଏନ୍‌ ଡେନ୍‌, କେନ୍‌ ଗିଲ୍ଲନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ସବ୍‌ଙାଜା; ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଇସ୍ସୁମ୍‌ଞେନ୍‌ ତଡ୍‌, ଆର୍ପାୟ୍‌ ଇସ୍ସୁମ୍‌ନମ୍‌ ଡେଏତୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ଆରି, ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡାଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବୋର୍ସାନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ଆରି ଆନିନ୍‌ ଜବ୍ର ଇୟମ୍‌ଡାଲେ ଆବଲୟନ୍‌ ପାର୍ତନାଲନ୍‌, ଆରି ଆ ଓଞୋଲନ୍‌ ଆ କଜି ମିଞାମନ୍‌ ଆଜ୍ରଡ୍ଡୋୟ୍‌ତେନ୍‌ ଅନ୍ତମ୍‌ ଲବଲୋଙନ୍‌ ଜାୟ୍‌ତାନ୍‌ ଜତଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ଆରି ଆନିନ୍‌ ପାର୍ତନାନେନ୍‌ ସିଲଡ୍‌ ଡୋଲନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଜିର୍ରାୟ୍‌, ସିଲତ୍ତେ ଆନିଞ୍ଜି ଅନିଃୟମନ୍‌ ବାତ୍ତେ ଆଡିମଡାୟ୍‌ଜି ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ଆରି, ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନିବା ଏଲୁଡ୍‌ତେ ? ମନାଲ୍‌ମାଲ୍‌ଲୋଙନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଗଲୋଡଙ୍‌ବେନ୍‌ ତଡ୍‌ ତିଆସନ୍‌ ଡୋଲନ୍‌ ପାର୍ତନାନାବା ।” ");
INSERT INTO juy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ଜିସୁନ୍‌ ଆକ୍ରଡାଡ଼ିଲନ୍‌ ଆଡିଡ୍‌, ଗିୟ୍‌ବା, ମନ୍‌ରାଞ୍ଜି ଅଡ଼ୋଲାଜି, ଆରି ବାରଜଣଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଇସ୍କାରିତ ଜିଉଦା ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଆମ୍ମୁଙ୍‌ଡାଲନ୍‌ ଜିର୍ରେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜନୋର୍ଜୋରନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଜିଉଦା, ଜନୋର୍ଜୋରନ୍‌ ବାତ୍ତେ ପଙ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ସିଲତ୍ତେ ଇନି ଡେତେ ତିଆତେ ଗିୟ୍‌ଲେ, ଜିସୁନ୍‌ ଆ ସନଣ୍ଡୋଙ୍‌ମର୍‌ଜି ବର୍ରଞ୍ଜି, “ପ୍ରବୁ, ଇନ୍‌ଲେନ୍‌ ଇନି କଡ଼ିବନ୍‌ ବାତ୍ତେ ଏଅଡାଜି ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ଆରି, ଆନିଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଅବୟ୍‌ନେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ କମ୍ୱାରିମର୍‌ଆଡଙ୍‌ ଅଡ୍‌ଲେ ଆର୍ଜଡ଼ୋମ୍‌ଲୁଡନ୍‌ ଗଡ୍‌ଲେ ସେଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ବନ୍‌ଡ ଜିସୁନ୍‌ ବର୍ରନେ, “ଡିୟ୍‌ତେ ସରି,” ଆନିନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ତି ମନ୍‌ରାନ୍‌ ଆଲୁଡ୍‌ ସୁଙେଲେ ଆନିନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ଆରି ଜିସୁନ୍‌, ଆ ବିରୁଦଲୋଙ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି ସୋଡ଼ା ରାଓଡ଼ାନ୍‌, ସରେବାସିଙନ୍‌ ଆ ସୋଡ଼ା ସିପ୍ପାୟ୍‌ ଡ ପାପୁର୍‌ମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ରାଉମରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଏଡ୍ରୁଙ୍‌ତନାଞନ୍‌ ଅନ୍ତମ୍‌ କଡ଼ିବନ୍‌ ଡ ତେଙ୍ଗାନ୍‌ ଞମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଇନିବା ଡୁଙ୍‌ଲନ୍‌ ଏଜିର୍ରାୟ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ଡିତାନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଡରକୋଲନାଞନ୍‌ ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ବିରୁଦଲୋଙ୍‌ଞେନ୍‌ ଅସିବେନ୍‌ ଏନ୍ନବ୍‌ଡୋଲୋ, ବନ୍‌ଡ ଅଙ୍ଗା ଆଡିଡ୍‌ ଲୋଙଡ୍‌ତେ ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ରୟଙନ୍‌ ଏଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ତିକ୍କି ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ପାଙ୍‌ଲେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆସିଂ ଓରୋଙେଞ୍ଜି; ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଡାସଙାୟ୍‌ ଡକୋଡାଲନ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ଆରି, ଆନିଞ୍ଜି ମଡ୍ଡି ଡାଣ୍ଡଲୋଙନ୍‌ ତଗୋନ୍‌ ସୟ୍‌ଲେ ଏକ୍କାନ୍‌ ଆତ୍ରଙ୍କୁମେଞ୍ଜି, ପିତ୍ରନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଇୟ୍‌ଲେ ତଙ୍କୁମେ । ");
INSERT INTO juy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ପିତ୍ରନ୍‌ ତଗୋନ୍‌ ଆ ତୁୟାୟ୍‌ ତଙ୍କୁମ୍‌ଲେ ଆଡ୍ରକୋଲନେନ୍‌ ଆଡିଡ୍‌, ଅବୟ୍‌ କମ୍ୱାରିବଜନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ, ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙ୍‌ଡାଲେ ବର୍ରନେ, “କେନ୍‌ ଆ ମନ୍‌ରା ନିୟ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ଏ ଆଇମର୍‌ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜନା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ଗଡ୍ଡେଃ ଡକୋଡାଲନ୍‌ ଆରି ଅବୟ୍‌ନେ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ବର୍ରନେ, “ଆମନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଅବୟ୍‌ନେ ।” ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ଇଜ୍ଜା ବୋଞାଙ୍‌, ଞେନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ଆରି, ବଗଣ୍ଟା ଆ ତିକ୍କି ଆରି ଅବୟ୍‌ନେ ଆକ୍ରାନ୍‌ ବର୍ରନେ, “କେନ୍‌ ଆ ମନ୍‌ରା ନିୟ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ ଗାଲିଲିମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ବୋଞାଙ୍‌ ଆମନ୍‌ ଅଙ୍ଗାତେ ବର୍ତନେ, ଞେନ୍‌ ତିଆତେ ଜନା ତଡ୍‌ ।” ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ବର୍ନା ବର୍ନା କମ୍‌ସିମନ୍‌ ଓଲେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ଆରି ପ୍ରବୁନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଆଙାଙେନ୍‌; ସିଲତ୍ତେ “କମ୍‌ସିମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଓଲେନ୍‌ ଆମନ୍‌ ୟାଗି ତର ଞେନ୍‌ଆଡଙ୍‌ ମୁର୍ସେତିଁୟ୍‌,” କେନ୍‌ ଅଙ୍ଗା ବର୍ନେ ପ୍ରବୁନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ତିଆତେ ଆନିନ୍‌ ମନ୍ନେଏନ୍‌, ଆରି ଆନିନ୍‌ ଡୁଆରାନ୍‌ ଜିର୍ରେ ଆକ୍ରାନ୍‌ ଇୟମ୍‌ଡାଲେ ଇୟ୍‌ଲେ ୟେୟେଡାନେ । ");
INSERT INTO juy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ଆରି, ଅଙ୍ଗା ମନ୍‌ରାଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ଡକ୍କୋଏଞ୍ଜି, ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ତିଡ୍‌ଲେ ତିଡ୍‌ଲେ ସୟ୍‌ସୟ୍‌ମୁଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ଆରି ଆ ମୁକ୍କାନ୍‌ ୟୁମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମନ୍‌ ଅଡ୍ଡେନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ! ବର୍ନା ଲା ଆନା ଆମନ୍‌ଆଡଙ୍‌ ତିଡ୍‌ଲମ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ଆରି, ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ବର୍ନେଞ୍ଜି ବର୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ଡୋତାନ୍‌ ମନ୍‌ରାଞ୍ଜି, ପାପୁର୍‌ମରଞ୍ଜି, ଆରି ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ରୁକ୍କୁଡାଲନ୍‌ ଆ ପନ୍‌ସୁଆତିଲୋଙଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ବରେଞ୍ଜି, “ଆମନ୍‌ କ୍ରିସ୍ଟ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ବର୍ରେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ତ ଏଃଡ୍ଡର୍ନେ; ");
INSERT INTO juy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ଆରି, ଞେନ୍‌ ଅପ୍ପୁଙ୍‌ଲବେନ୍‌ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଏଃଜ୍ଜାଲଙିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ବନ୍‌ଡ ନମିଞେନ୍‌ ସିଲଡ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ତଙ୍କୁମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ସିଲତ୍ତେ ଅଡ଼୍‌କୋଞ୍ଜି ବର୍ରଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଇନି ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ପଙ୍‌ ?” ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଆନିନ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ସାକିନ୍‌ ଇନିବା ଆରି ସନାୟ୍‌ସାୟ୍‌ ? ଇନ୍‌ଲେଞ୍ଜି ଆ ତଅଡ୍‌ଲୋଙନ୍‌ ସିଲଡ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଲବୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ତିକ୍କି ସୋବାନ୍‌ ସିଲଡ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଡୋଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ପିଲାତନ୍‌ ଆମଙ୍‌ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ଆରି, ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଡାବ୍ବୁଡାଲେ ବର୍ରଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଏଗିୟ୍‌ଲାୟ୍‌, କେନ୍‌ ଆ ମନ୍‌ରା ଜାତିଲେନ୍‌ ତରଙ୍‌ଆନ୍ନା ଏମ୍ମେଆୟ୍‌ତେ, ଆରି କାଇସରନ୍‌ଆଡଙ୍‌ ପାନୁନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ କେନ୍‌ଆନିନ୍‌ ରଙ୍‌ତେ, ଆରି ଆନିନ୍‌ଡମ୍‌ ଞେନ୍‌ ଅବିସେକ ଡେଲିଁୟ୍‌, ଞେନ୍‌ ଅବୟ୍‌ ରାଜା ଗାମ୍‌ଡମ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ସିଲତ୍ତେ ପିଲାତନ୍‌, ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ପଙ୍‌ ଜିଉଦିଞ୍ଜି ଆ ରାଜା ?” ଜିସୁନ୍‌ ଜାଲଙ୍‌ଲନେ, “ଆମନ୍‌ ବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ସିଲତ୍ତେ ପିଲାତନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାନ୍‌ ଡ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ କେନ୍‌ ଆ ମନ୍‌ରା ଆମଙ୍‌ ସିଲଡ୍‌ ଇନ୍ନିଙ୍‌ ଡୋସାନ୍‌ ଅଃଞାଙାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ବନ୍‌ଡ ଆନିଞ୍ଜି ଆରି ଆକ୍ରାନ୍‌ ବର୍ରଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ସମ୍ପରା ଜିଉଦା ଡେସାନ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ଲେ ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଉଲନ୍‌ କେନ୍‌ତେନ୍ନେ ନିୟ୍‌ ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ସୁସ୍କାୟ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ବନ୍‌ଡ ପିଲାତନ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆରି ବର୍ରନେ, “କେନ୍‌ ଆ ମନ୍‌ରା ଇନି ଗାଲିଲିବାୟ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ଆରି, ଆନିନ୍‌ ଏରୋଦନ୍‌ ଆ ରାଜ୍ୟ ଆ ମନ୍‌ରା ଗାମ୍‌ଲେ ଆନିନ୍‌ ଜନାଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଏରୋଦନ୍‌ ଆମଙ୍‌ ଆପ୍ପାୟେନ୍‌, ତିଆଡିଡ୍‌ ଏରୋଦନ୍‌ ନିୟ୍‌ ଜିରୁସାଲମଲୋଙନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ଏରୋଦନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ମାଡ୍ଡ ସର୍ଡାଲନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆ ବର୍ନେନ୍‌ ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଆମ୍ମୁଙ୍‌ ମା ସିଲଡ୍‌ ଲଡୟ୍‌ଡାଏନ୍‌, ଆରି ଆମଙନ୍‌ ସିଲଡ୍‌ ଇନ୍ନିଙ୍‌ଡେନ୍‌ ସରାନ୍ନିଡାନ୍‌ ଆ କାବ୍ବାଡ଼ା ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଏରୋଦନ୍‌ ଆସାଲନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ତିଆସନ୍‌ ପିଲାତନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ବର୍ନେଞ୍ଜି ଅପ୍ପୁଙେନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ଇନ୍ନିଙ୍‌ ଅଃଜ୍ଜାଲଙ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ଆରି, ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ତନଙ୍‌ଡାଲେ ଜିସୁନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ମାଡ୍ଡ କାୟ୍‌କାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ଆରି, ଏରୋଦନ୍‌ ଆ ସିପ୍ପାୟଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଡୋସେଲେ ସୟ୍‌ସୟ୍‌ମୁଡାଲେ ଅବୟ୍‌ ମନଙ୍‌ଡମ୍‌ ଆ ଅଙ୍ଗି ଅବ୍‌ରଡାଲେ ଆରି ପିଲାତନ୍‌ ଆମଙ୍‌ ଆପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ତିଆଡିନ୍ନା ସିଲଡ୍‌ ଏରୋଦନ୍‌ ଡ ପିଲାତନ୍‌ ତର୍ଡମ୍‌ ମାୟ୍‌ମାୟ୍‌ଲଞ୍ଜି; କେନ୍‌ ଆମ୍ମୁଙ୍‌ ଆନିଞ୍ଜି ବାଗୁଞ୍ଜି ବନେରା ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପିଲାତନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି, ସୋଡ଼ାମରଞ୍ଜି ଡ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଲେ ଅବ୍‌ରୁକ୍କୁଡାଲେ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“କେନ୍‌ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଗୋଡ଼େନ୍‌ ଅମ୍‌ଡୁଙ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଏଓରୋଙ୍‌ଲାୟ୍‌; ଆରି ଗିୟ୍‌ବା, ଞେନ୍‌ ତେମଡ୍‌ଲୋଙ୍‌ବେନ୍‌ କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବର୍ରାୟ୍‌ ବନ୍‌ଡ ଅଙ୍ଗା ଅଙ୍ଗା ଆ ବର୍ନେଜି କେନ୍‌ ଆ ବିରୁଦଲୋଙନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ଏବର୍ରନେ ତିଅନ୍ତମ୍‌ ଅନ୍ନିଙ୍‌ ଆ ଡୋସା କେନ୍‌ ଆମଙନ୍‌ ଅଃଞାଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ଏରୋଦନ୍‌ ନିୟ୍‌ ଅଃଞାଙ୍‌ଲୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆରି କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌; ଆରି ଗିୟ୍‌ବା, କେନ୍‌ଆନିନ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ଆଞ୍ରାଙ୍‌ତେନ୍‌ ଅନ୍ତମ୍‌ ଇନ୍ନିଙ୍‌ ଆ ଡୋସା ଅଃଲ୍ଲୁମ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ତିଆସନ୍‌ ଞେନ୍‌ କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପନବ୍‌ରଡନ୍‌ ତିୟ୍‌ଲେ ଅମ୍‌ରେଙ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ପୁର୍ପୁର୍‌ ଇଙନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ରାଜାନ୍‌ ଅବୟ୍‌ ଆବଣ୍ଡିମରନ୍‌ଆଡଙ୍‌ ଅମ୍‌ବୁର୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ବନ୍‌ଡ ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଏକ୍କାନ୍‌ ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ରବ୍ବୁବା, ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ବାରବ୍ବାନ୍‌ ଅମ୍‌ବୁର୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ତି ବାରବ୍ବାନ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ଗୋଡ଼େନ୍‌ ଆରମ୍‌ଡୁଙ୍‌ଲାଞନ୍‌ ଆସନ୍‌ ଡ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆର୍ରବ୍ବୁଏନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକ୍କୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ବନ୍‌ଡ ପିଲାତନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ବୁରନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ଡାଲେ ଆନିନ୍‌ ଆରି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ଲଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ବନ୍‌ଡ ଆନିଞ୍ଜି ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ବା, ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ଆରି, ଆନିନ୍‌ ୟାଗି ତର ବରେଞ୍ଜି, “ଇନିବା ଆନିନ୍‌ ଇନି ଆ ଡୋସା ଲୁମେନ୍‌ ? ଞେନ୍‌ ଆମଙନ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ଆଞ୍ରାଙ୍‌ତେନ୍‌ ଅନ୍ତମ୍‌ ଅନ୍ନିଙ୍‌ ଆ ଡୋସା ଅଃଞାଙ୍‌ଲାୟ୍‌; ତିଆସନ୍‌, ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପନବ୍‌ରଡନ୍‌ ତିୟ୍‌ଲେ ଅମ୍‌ରେଙ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ବନ୍‌ଡ ଆନିନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ନେତୋ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବାବ୍ବାବ୍‌ଲେ ଡାବ୍ବିଲେ ଡକୋଲଞ୍ଜି, ଆରି ଆ ବନାବ୍ବାବଞ୍ଜି ମା ଜିନୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ଆରି, ଆ ଡାବ୍ବିଞ୍ଜି ଅନ୍ତମ୍‌ ଲନୁମନ୍‌ ଡେଏତୋ ଗାମ୍‌ଲେ ପିଲାତନ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ଗୋଡ଼େନ୍‌ ଆରମ୍‌ଡୁଙ୍‌ଲାଞନ୍‌ ଆ ଡୋସା ଡ ସମ୍ବବ୍‌ମରନ୍‌ ଆ ଡୋସାଲୋଙ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକ୍କୋଏଞ୍ଜି, ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଅନମ୍‌ବୁରନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଡାବ୍ବିଏଞ୍ଜି, ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ପିଲାତନ୍‌ ଅମ୍‌ବୁରେନ୍‌, ଆରି ଆଇସ୍ସୁମଞ୍ଜି ବାତ୍ତେ ଆସିଲୋଙଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଆରୋରୋଙେଞ୍ଜି ଆଡିଡ୍‌ ମାଲ୍ଲେଙ୍‌ରେଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଗଡ଼ାନ୍‌ ଜିର୍ରାୟ୍‌, ଆଞୁମନ୍‌ ସିମନ୍‌ ଆନିନ୍‌ କୁରିଣିବାୟ୍‌, ଆନିନ୍‌ ଜିସୁନ୍‌ ଆଅକ୍କାଡଙ୍‌ ବୋୟ୍‌ଲେ ଜିସୁନ୍‌ ଆ କଣ୍ଡୋଙ୍‌ଗଡ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ଜନିରନ୍‌ ଆସନ୍‌ ଆ ତାରଙ୍‌ଲୋଙନ୍‌ ତିଆତେ ଜଗଃମଗଃ ଅବ୍ବୋୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ଆରି, ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ କଣ୍ଡୋଙ୍‌ଗଡନ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି, ଲାଙ୍‌ଲେଡ୍‌ ଆଇମରଞ୍ଜି ଆନିନ୍‌ ଆସନ୍‌ ଇୟମ୍‌ଡାଲେ ଆ ମାୟଙ୍‌ଲୋଙଞ୍ଜି ତିଡ୍ଡମ୍‌ଲନ୍‌ ୟେଗଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆମଙ୍‌ଗଡଞ୍ଜି ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ବର୍ରନେ, “ଏ ଜିରୁସାଲମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ିଅନ୍‌ଜି, ଞେନ୍‌ ଆସନ୍‌ ଏୟେଡଙ୍‌, ଆର୍ପାୟ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସନ୍‌ ଆରି ପସିୟ୍‌ବେଞ୍ଜି ଆସନ୍‌ ୟେବା; ");
INSERT INTO juy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଗିୟ୍‌ବା, ‘ଆନାଜି ଆଞ୍ଜେବୟ୍‌ଜି, ଆରି ଆନାଜି ଆଙ୍ଗିୟ୍‌ଜା ଅଣ୍ଡ୍ରଙ୍‌ ତିଲ୍‌କୋଡେଜି ଆରି ଅଣ୍ଡ୍ରଙ୍‌ ମେମେଅନ୍‌ନେଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ସନେନ୍‌ସେନ୍‌, ସନେନ୍‌ସେନ୍‌,’ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ବର୍ତଞ୍ଜି ତି ଆ ବନେଡ଼ା ଜିର୍ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ତିଆଡିଡ୍‌ ମନ୍‌ରାଞ୍ଜି ବରୁଞ୍ଜି ବର୍ତଜି, ‘ଡଅଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ଅବ୍‌ସେଡ୍‌ନାୟ୍‌,’ ଆରି ତଡ଼କୁବଞ୍ଜି ବର୍ତଜି, ‘ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ରୁବ୍‌ଲେନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମେଙ୍‌ନୁବନ୍‌ ମନ୍‌ରାଞ୍ଜି ଏନ୍ନେଏଞ୍ଜି ଡେନ୍‌, ଆସର୍‌ନୁବନ୍‌ ଆରି ଏଙ୍ଗାଗୋ ଅରଃ ଡେଏନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ବାଗୁ ଡୋସାମରଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ଜିସୁନ୍‌ ସରିନ୍‌ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ଆରି, ଆନିଞ୍ଜି “ଆଇଡାଡ଼ା” ଗାମ୍‌ଲେ ଅବୟ୍‌ ବରୁଲୋଙନ୍‌ ତୁଙେଞ୍ଜି କି ତେତ୍ତେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି, ଆରି ଡୋସାମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଜିସୁନ୍‌ ଆ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଆରି ଅବୟ୍‌ନେ ଅର୍କାବଡ଼ିଗଡ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ବର୍ରନେ, “ଏ ଆପେୟ୍‌, କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ କେମାନ୍‌ ତିୟାଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆନିଞ୍ଜି ଇନି ଲୁମ୍‌ତଜି, ତିଆତେ ଅଃଜ୍ଜନାଏଜି ।” ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ଅଙ୍ଗି ବନ୍ତାନେନ୍‌ ଆସନ୍‌ ଅବ୍‌କଡ଼ିଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ଆରି, ମନ୍‌ରାଞ୍ଜି ତନଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିଜେଞ୍ଜି । ଆରି, ସୋଡ଼ାମରଞ୍ଜି ନିୟ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସୟ୍‌ସୟ୍‌ମୁଡାଲେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ ଆନ୍ନାମରଞ୍ଜିଆଡଙ୍‌ ଡୋବେନ୍‌; ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆସ୍ରେଡାଏନ୍‌ ଆ କ୍ରିସ୍ଟ ଡେନ୍‌, ଆନିନ୍‌ଡମ୍‌ ଡୋବ୍‌ନେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ଆରି, ସିପ୍ପାୟଞ୍ଜି ନିୟ୍‌ ଆମଙନ୍‌ ଜିର୍ରେ ସବୁର୍‌ଡାନ୍‌ ତିୟ୍‌ଲେ, ଆନିନ୍‌ଆଡଙ୍‌ ସୟ୍‌ସୟ୍‌ମୁଲେ ବର୍ରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ଆମନ୍‌ ଜିଉଦିଞ୍ଜି ଆ ରାଜା ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ଡମ୍‌ ଡୋବ୍‌ନା ।” ");
INSERT INTO juy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ଆରି, ଆବବନ୍‌ ଆ ତୋଣ୍ଡୋ ଏନ୍ନେଲେ ନିୟ୍‌ ଆଇଡିଡନ୍‌ ଡକୋଏନ୍‌, “କେନ୍‌ଆତେ ଜିଉଦିଞ୍ଜି ଆ ରାଜା ।” ");
INSERT INTO juy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ଆରି, ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଆରମ୍‌ଡାଜେଞ୍ଜି ଡୋସାମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଜିସୁନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ଡାଲେ ବର୍ରନେ, “ଆମନ୍‌ ପଙ୍‌ କ୍ରିସ୍ଟନ୍‌ ତଡ୍‌ ? ଆମନ୍‌ଡମ୍‌ ଡୋବ୍‌ନା ଆରି ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଡୋବ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ବନ୍‌ଡ ଆରି ଅବୟ୍‌ନେ ଆନିନ୍‌ଆଡଙ୍‌ କଁୟ୍‌ଲେ ବରେନ୍‌, “ଆମନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଅଃବ୍ବତଙମ୍‌ ପଙ୍‌ ? ଆମନ୍‌ ତ ଏତ୍ତେଗୋମା ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ଆମନ୍‌ ଡ ଞେନ୍‌ ଡୋସାନ୍‌ ଲୁମ୍‌ଲବୋ, ତିଆସନ୍‌ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତବୋ, ବନ୍‌ଡ କେନ୍‌ଆନିନ୍‌ ଅନ୍ନିଙ୍‌ ଆ ଡୋସା ଅଃଲ୍ଲୁମ୍‌ଲୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ଆରି ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଜିସୁ, ଆମନ୍‌ ରାଜ୍ୟଲୋଙ୍‌ନମ୍‌ ଗନେନ୍‌ ଡେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଜିଡ୍‌ ଇୟମିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତମ୍‌, ଲଙେ ଆମନ୍‌ ଞେନ୍‌ ସରିନ୍‌ ପାରଡେସାନ୍‌ ଜିର୍ତେ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ତିଆଡିଡ୍‌ ଅୟମନ୍‌ ବାରଟା ଡେଏନ୍‌, ଆରି, ଓୟୋଙନ୍‌ ଅଃତ୍ତରାଲନ୍‌ ୟାଗି ଗଣ୍ଟା ଜାୟ୍‌ ସମ୍ପରା ଡେସାନ୍‌ ଆଲୋଙଡ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ଆରି ସରେବାସିଂଲୋଙନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଡରଙ୍‌ନେକାବନ୍‌ ବାଗୁ ପାଲ୍‌ପାଲ୍‌ ଡେଲେ ପତେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ଆରି, ଜିସୁନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ, ଓଡ୍ଡେଲେ ବର୍ରନେ, “ଏ ଆପେୟ୍‌, ଞେନ୍‌ ଅସିଲୋଙ୍‌ନମ୍‌ ପୁରାଡ଼ାଞେନ୍‌ ସୋରୋପ୍ପାୟ୍‌ତାୟ୍‌,” ଏନ୍ନେଲେ ବର୍ରନେ କି ଆନିନ୍‌ ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ତେତ୍ତେ ଇନି ଡେଏନ୍‌ ତିଆତେ ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ ଗିୟ୍‌ଲେ, ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ତିୟ୍‌ଲେ ବର୍ରନେ, “କେନ୍‌ଆନିନ୍‌ ଅବୟ୍‌ ଡରମ୍ମମର୍‌ ଡକୋଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ଆରି, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଡିଅଙ୍ଗା ମନ୍‌ରା ତେତ୍ତେ ଇୟ୍‌ଲେ କୁଡ଼ାୟ୍‌ନେଜି ଆନିଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଗନଡେଲଞ୍ଜି ଗିୟ୍‌ଲେ ଆ ମାୟଙ୍‌ଲୋଙଞ୍ଜି ତିଡ୍ଡମ୍‌ଲନ୍‌ ୟର୍ରନାଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ କୁଲମ୍‌ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆରି ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଏକ୍କାନ୍‌ ମାୟ୍‌ଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆସ୍ରଣ୍ଡୋଙେଞ୍ଜି ଆଇମର୍‌ଜି ଡାସଙାୟ୍‌ ଡକୋଡାଲନ୍‌ କେନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଗିୟ୍‌ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ଆରି ଗିୟ୍‌ବା, ଜିଉଦିଞ୍ଜି ଆ ଗଡ଼ାଲୋଙ୍‌ ଆରାମାତିୟାବାୟ୍‌ ଜୋସେପ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ମନଙ୍‌ମର୍‌ ଆରି ଡରମ୍ମମର୍‌, ଆରି ଆନିନ୍‌ ସୋଡ଼ା ସୋବାନ୍‌ ଆ ମରାୟ୍‌ନେମର୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ଆନ୍ନା ଜିଉଦିଞ୍ଜି, ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି ବନ୍‌ଡ ତିଆତେ ଆନିନ୍‌ ଅଃମ୍ମାୟ୍‌ଲନ୍‌, ଆରି ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଜଗେଲେ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ଆନିନ୍‌ ପିଲାତନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଜିସୁନ୍‌ ଆ ଡଅଙ୍‌ ଇୟ୍‌ଲେ ବେଡେ । ");
INSERT INTO juy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ଆରି ତିଆତେ ଅପ୍ପଃଡାଲେ ଲମନ୍‌କାବନ୍‌ ବାତ୍ତେ ବଲେଡ୍‌ଲେ, ବରୁଲୋଙନ୍‌ ଆଗାୟ୍‌ଗାୟନ୍‌ ଅବୟ୍‌ ମସାନ୍ନିଲୋଙନ୍‌ ଇୟ୍‌ଲେ ଡକ୍କୋଏଜି, ତି ଆମ୍ମୁଙ୍‌ ତି ଆ ମସାନ୍ନିଲୋଙ୍‌ ଆଙ୍ଗିୟ୍‌ ଆନ୍ନିଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଡକ୍କୋଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ତିଆଡିନ୍ନା ଅବ୍‌ଜାଡା ଡିନ୍ନା ଡକୋଏନ୍‌, ଆରି ଲୋଲୋନେ ଡିନ୍ନାନ୍‌ ତୁୟାଲେ ପାଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ଆରି, ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଆଇମର୍‌ଜି ସଣ୍ଡୋଙ୍‌ଲେ ପାଙ୍‌ଲେ ମସାନ୍ନିନ୍‌ ଡ ଜିସୁନ୍‌ ଆ ଡଅଙ୍‌ ଏଙ୍ଗାଲେ ଡନକ୍କୋନ୍‌ ଡେଏନ୍‌ ତିଆତେ ଇୟ୍‌ଲେ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ଆରି ଆନିଞ୍ଜି ୟର୍ରନ୍‌ ଲଙିଡ୍‌ ମିଞଲନ୍‌ ଡ ମିଞଲନ୍‌ ଇୟ୍‌ଲେ ତୁବେଜି, ଆରି ଆନିଞ୍ଜି ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଲୋଲୋଲଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆତେ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଏତ୍ତେଲେ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ଆରି, ପାଲ୍ଲିନ୍‌ ଆ ପର୍ତମ୍ମୁ ଡିନ୍ନା ତି ଆଇମରଞ୍ଜି ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ଡୋଲନ୍‌ ଆନିଞ୍ଜି ଆତ୍ରୁବେଞ୍ଜି ଆ ମିଞଲ୍‌ ଡ ଲଙିଡ୍‌ମେନ୍‌ ଞମ୍‌ଲେ ମସାନ୍ନିନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ଆରି ଆନିଞ୍ଜି ମସାନ୍ନିଲୋଙନ୍‌ ଆରେଙ୍‌ ଆଡେଡ୍‌ଡେଡ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି, ");
INSERT INTO juy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ବନ୍‌ଡ ଅମ୍ମନ୍‌ ଗନ୍‌ଲେ ଇୟ୍‌ଲେ ଗିଜେଞ୍ଜି, ପ୍ରବୁ ଜିସୁନ୍‌ ଆ ଡଅଙ୍‌ ଅଃନ୍ନିୟ୍‌ଞାଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ତିଆସନ୍‌ ଆନିଞ୍ଜି କାଲାୟ୍‌ ବିଲାୟ୍‌ ଡେଏଞ୍ଜି, ତି ଆ ବନେଡ଼ା ଗିୟ୍‌ବା, ସାଆର୍‌ଡମ୍‌ ଆ ଅଙ୍ଗି ଆରନେଜି ବାଗୁ ମନ୍‌ରା ଆମଙଞ୍ଜି ଇୟ୍‌ଲାୟ୍‌ ତନଙେଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ସିଲତ୍ତେ ଆଇମରଞ୍ଜି ମାଡ୍ଡ ବତଙେଞ୍ଜି କି ଜାୟ୍‌ତାନ୍‌ ବରୁମେଞ୍ଜି, ଆନିଞ୍ଜି ତି ଆଇମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆମେଙ୍‌ମରନ୍‌ଆଡଙ୍‌ ଇନିବା ଏସାୟ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ଆନିନ୍‌ ତେନ୍ନେ ତଡ୍‌, ଆନିନ୍‌ ଡୋଲନେ । ଆନିନ୍‌ ଗାଲିଲିନ୍‌ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌, ତିଆତେ ମନ୍ନେବା । ");
INSERT INTO juy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ଡାଲେ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ରବ୍ବୁତଜି ଆରି ଏର୍ତାଲୋଙ୍‌ ଆନିନ୍‌ ୟର୍ମେଙ୍‌ତେ ।’” ");
INSERT INTO juy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆ ବର୍ନେନ୍‌ ମନ୍ନେଏଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ଆରି ଆନିଞ୍ଜି ମସାନ୍ନିନ୍‌ ସିଲଡ୍‌ ୟର୍ରନ୍‌ ଏଗାରଜଣଞ୍ଜି ଆରି ଆନ୍ନାମରଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆମଙ୍‌ କେନ୍‌ ଆ କବର ଇୟ୍‌ଲାୟ୍‌ ଅବ୍‌ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","କେନ୍‌ଆନିଞ୍ଜି ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌, ଜୋଆନାନ୍‌, ଜାକୁବନ୍‌ ଆ ନନ ମରିଅମନ୍‌ ଆରି କେନ୍‌ଆନିଞ୍ଜି ସରିନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଆନ୍ନା ଆଇମର୍‌ଜି; କେନ୍‌ଆନିଞ୍ଜି ଅନାପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଇୟ୍‌ଲେ ଅବ୍‌ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ବନ୍‌ଡ ଅନାପ୍ପାୟଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆମଙଞ୍ଜି କନଣ୍ଡାୟ୍‌ବର୍‌ଗୋ ଅବ୍‌ଡିସୟେଞ୍ଜି, ଆରି ଅନାପ୍ପାୟଞ୍ଜି ଆ ବର୍ନେଞ୍ଜି ଅଃଡ୍ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଡୋଲନ୍‌ ମସାନ୍ନିନ୍‌ ଇରେନ୍‌, ଆରି ଡୁଙ୍ଗୁଡାଲେ ଅମ୍ମନ୍‌ ଇୟ୍‌ଲେ ଗିଜେନ୍‌, ତେତ୍ତେ ସତ୍ତର୍‌ ଲମନ୍‌କାବନ୍‌ ତୁମ୍‌ ଇୟ୍‌ଲେ ଗିଜେ, ତିଆସନ୍‌ ଆନିନ୍‌ ଇନି ଡେଏନ୍‌ ଗାମ୍‌ଲେ ସାନ୍ନିଡାଲେ ଆରି ଆସିଙନ୍‌ ୟର୍ରନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ଆରି ଗିୟ୍‌ବା, ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ବାଗୁନେ ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଉଞ୍ଜି କୋସ ଆ ସଙାୟ୍‌ ଇମ୍ମାୟୁ ସାଇନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ଆରି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଗ୍ରଡେଲେନ୍‌ ଆ ବର୍ନେଜି ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଗଡ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ଆନିଞ୍ଜି କଡାଡ଼ିନ୍‌ ଡ ଅଲ୍‌ଡୁଲ୍‌ବାଞନ୍‌ ଆଡ୍ରେଏଞ୍ଜି ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆମଙଞ୍ଜି ଜିର୍ରେ ଆନିଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ତଙିୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ବନ୍‌ଡ ତିଆଡିଡ୍‌ ଆନିଞ୍ଜି ପୁସ୍ପାଲ୍‌ମଡେଞ୍ଜି ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍ମଡ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେନ୍‌ ତଙିୟ୍‌ନେରୟ୍‌ ଅଙ୍ଗା ବର୍ନେଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଏକଡାଡ଼ିତନ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଇନି ?” ସିଲତ୍ତେ ଆନିଞ୍ଜି ଅବ୍‌ସର୍‌ମୁକ୍କାଲନ୍‌ ତନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ଆରି, ଆନିଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ କ୍ଲେୟପା ଗାମ୍‌ଲେ ଅବୟ୍‌ନେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜିରୁସାଲମନ୍‌ ଆଡ୍ରକୋତଞ୍ଜି ଆ ମନ୍‌ରାଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଆମନ୍‌ ତୁମ୍‌ ପଙ୍‌ ଅବୟ୍‌ନେ, କେନ୍‌ ଆଡିନ୍ନାରେଙ୍‌ ତେନ୍ନେ ଇନିଜି ଡେଏନ୍‌ ତିଆତେ ଅଣ୍ଡ୍ରଙ୍‌ ଜନାଅମ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏଙ୍ଗାଗୋ ଆ ଗନଡେଲ୍‌ ?” ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ନାଜରିତ ଜିସୁନ୍‌ ଆ କଡାଡ଼ି; ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଡ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ କାବ୍ବାଡ଼ାଲୋଙନ୍‌ ଡ ବର୍ନେଲୋଙନ୍‌ ଅବୟ୍‌ ବୋର୍ସାଡମ୍‌ ଆ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ଆରି ସୋଡ଼ା ରାଓଡ଼ାଲେଞ୍ଜି ଡ ସୋଡ଼ାମର୍‌ଲେଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ସୋରୋପ୍ପାୟ୍‌ଡାଲେ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି, ତି ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ବନ୍‌ଡ ଅଙ୍ଗାମର୍‌ ଇସ୍ରାଏଲନ୍‌ଆଡଙ୍‌ ଅନୁରନ୍‌ ତିୟ୍‌ତେ, ତି ଆ ମନ୍‌ରା କେନ୍‌ଆନିନ୍‌ ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଏଆସାଲନାୟ୍‌; ବନ୍‌ଡ କେନ୍‌ଆତେଜି ଅମ୍‌ରେଙ୍‌ଡାଲେ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଗ୍ରଡେଲେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଲଙେ ମାୟ୍‌ଲେ ୟାଗି ଡିନ୍ନା ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ଆରି ନିୟ୍‌, ଇନ୍‌ଲେଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ଆଇମରଞ୍ଜି ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ସାନ୍ନିଲଲେଞ୍ଜି; ଆନିଞ୍ଜି ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ମସାନ୍ନିନ୍‌ ଇୟେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ଆରି ଆ ଡଅଙନ୍‌ ଅଃନ୍ନିୟ୍‌ଞାଙ୍‌ଲଞ୍ଜି ଆନିଞ୍ଜି ୟର୍ରନ୍‌ ଏନ୍ନେଲେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେଜି, ଆନିଞ୍ଜି ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ନିୟ୍‌ ଅବ୍‌ତନାଲ୍‌ମଡେଞ୍ଜି ଆରି ତି ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ବର୍ରଞ୍ଜି, ଆନିନ୍‌ ଆମେଙ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ଆରି, ଗଡ଼ିଲେଞ୍ଜି ଲୋଙ୍‌ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ମସାନ୍ନିନ୍‌ ଆ ତୁୟାୟ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲେ ଗିଜେଞ୍ଜି, ଆଇମରଞ୍ଜି ଏଙ୍ଗାଲେ ବର୍ରଞ୍ଜି, ଏତ୍ତେଲେମା ଇୟ୍‌ଲେ ଗିଜେଜି, ବନ୍‌ଡ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନେଗିୟ୍‌ଲଜି ।” ");
INSERT INTO juy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଉଲ୍ଲୁଜି, ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆରପ୍ପୁଙ୍‌ବର୍‌ଲବେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଡର୍ନେନ୍‌ ଆସନ୍‌ ଉଗର୍‌ବେନ୍‌ ଡିୟ୍‌ନେ ପଙ୍‌ ଆଲବିଡ୍ଡାଜି ! ");
INSERT INTO juy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଞାଙେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ କ୍ରିସ୍ଟନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ଗଙ୍ଗନନ୍‌ ଆସନ୍‌ ଇନି ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ଆରି ଆନିନ୍‌, ମୋସାନ୍‌ ଡ ଅଡ଼୍‌କୋ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ସିଲଡ୍‌ ଉଲନ୍‌ ଅଡ଼୍‌କୋ ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆ ବର୍ନେନ୍‌ ଆଇଡିଡନ୍‌ ଆ ବର୍ନେଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଞଙ୍‌ଞଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ଆରି, ଆନିଞ୍ଜି ଅଙ୍ଗା ସାଇ ଇୟେଞ୍ଜି ତି ଆ ସାଇ ଆତ୍ରୁୟାୟ୍‌ବେଡେଞ୍ଜି ଆଡିଡ୍‌, ଜିସୁନ୍‌ ତି ଆ ସାଇ ପଡ୍‌ଲେ ଅଡି ଆଜିର୍ତେନ୍‌ ଅନ୍ତମ୍‌ ଏମ୍ମେଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ବନ୍‌ଡ ତି ଆ ମନ୍‌ରାଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ରଙେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ସରିନ୍‌ ଡକୋନା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସାଲ୍ଲୁମେନ୍‌ ଆରି ଲୋଙଡ୍‌ରୟ୍‌ତେ ।” ସିଲତ୍ତେ ଆନିନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ଆରି, ଆନିଞ୍ଜି ସରିନ୍‌ ଗାଗାନେନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ଆନିନ୍‌ ରୁଟିନ୍‌ ଞମ୍‌ଲେ ଆସିର୍ବାଦଏନ୍‌, ଆରି ତିଆତେ ରେବ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ସିଲତ୍ତେ ଆ ପୁସ୍ପାଲ୍‌ମଡଞ୍ଜି ଆତ୍ରଡେନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅମ୍ମଡେଞ୍ଜି; ଆରି ଆନିନ୍‌ ଆତେମଡଞ୍ଜି ସିଲଡ୍‌ ମାୟାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ସିଲତ୍ତେ ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ଅଙ୍ଗା ଆଡିଡ୍‌ ଆନିନ୍‌ ତଙର୍‌ଲୋଙନ୍‌ ଇନ୍‌ଲେନ୍‌ ସରିନ୍‌ କଡାଡ଼ିଲନ୍‌ ଆରି ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ଡରମ୍ମ ସାସ୍ତ୍ରନ୍‌ ଆ ବର୍ନେ ଞଙ୍‌ଞଙ୍‌ଲଙ୍‌ଲନ୍‌, ତିଆଡିଡ୍‌ ଇନି ଉଗର୍‌ଲେନ୍‌ ଅଃତ୍ତଗୋଲୋ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ଆରି, ଆନିଞ୍ଜି ସିଲତ୍ତେମା ଡୋଲନ୍‌ ଜିରୁସାଲମନ୍‌ ୟର୍ରଞ୍ଜି, ତେତ୍ତେ ରୁକ୍କୁଲନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଏଗାରଜଣଞ୍ଜି ଡ ଆ ଗଡ଼ିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, “ପ୍ରବୁନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଡୋଲନେ, ଆରି ସିମନନ୍‌ ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଲନେ ।” ");
INSERT INTO juy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ଆରି, ଆନିଞ୍ଜି ନିୟ୍‌ ତଙର୍‌ଲୋଙନ୍‌ ଆଗ୍ରଡେଲେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ଗନଡେଲ୍‌ ଆରି ଆନିନ୍‌ ରୁଟିନ୍‌ ଆର୍ରେବେନ୍‌ ଆଡିଡ୍‌ ଆନିଞ୍ଜି ଏଙ୍ଗାଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍ମଡେଞ୍ଜି, ତିଆତେ ଅଡ଼୍‌କୋନ୍‌ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ଆନିଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆବର୍ରଞ୍ଜି ଆଡିଡ୍‌, ଆନିନ୍‌ଡମ୍‌ ଜିସୁନ୍‌ ଆମଙଞ୍ଜି ଇୟ୍‌ଲାୟ୍‌ ତନଙେ, ଆରି ଆନିନ୍‌ ବର୍ରନେ “ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ସୟୁନ୍‌ ଡକୋନେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ବନ୍‌ଡ ଆନିଞ୍ଜି ଓଙ୍‌ଲେତିଏଞ୍ଜି ଆରି ବତଙ୍‌ଡାଲେ ଆନିଞ୍ଜି ଅବୟ୍‌ ବୁତନ୍‌ ଏଗିୟ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନିବା ଏବାଉଲ୍ଲିତନେ, ଆରି ମନ୍ନଲୋଙ୍‌ବେନ୍‌ ଇନିବା ଏଡାଲ୍‌ଗଡ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ଅସିଞେନ୍‌ ଡ ତାଲ୍‌ଜଙ୍‌ଞେନ୍‌ ଗିଜିଁୟ୍‌ବା, ଞେନ୍‌ଆଡଙ୍‌ ସୁଙେଲେ ଗିଜିଁୟ୍‌ବା, କେନ୍‌ଆତେ ଞେନ୍‌ଡମ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏଙ୍ଗାଲେ ଜେଲୁଞେନ୍‌ ଡ ଅଜାଙ୍‌ଞେନ୍‌ ଡକୋନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଗିୟ୍‌ତିଁୟ୍‌, ବୁତନ୍‌ଆତେ ଏତ୍ତେଗୋ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ଆରି, ଜିସୁନ୍‌ ଏନ୍ନେଲେ ବର୍ରନ୍‌ କି, ଆମଙଞ୍ଜି ଆସିନ୍‌ ଡ ଆ ତାଲ୍‌ଜଙନ୍‌ ଅବ୍‌ତୁଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ଆନିଞ୍ଜି ସର୍ଡାଏଞ୍ଜି, ଜନଙ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଅଃଡ୍ଡର୍ରଞ୍ଜି ଆରି ସାନ୍ନି ଡେଏଞ୍ଜି, ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ତେନ୍ନେ ଅମଙ୍‌ବେନ୍‌ ଇନ୍ନିଙ୍‌ ଜନୋମ୍‌ଜୋମନ୍‌ ଡକୋ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ସିଲତ୍ତେ ଆନିଞ୍ଜି ବଗଡ୍‌ଗଡ୍‌ ଆଗାୟ୍‌ଗାୟ୍‌ ଅୟନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ଆରି, ଆନିନ୍‌ ତିଆତେ ଜାଲେ, ଆତେମଡଞ୍ଜି ଜୋମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ଆରି, ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଡ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆରି କନନ୍‌ବଇଲୋଙନ୍‌ ବର୍ନେଞେନ୍‌ ଅଙ୍ଗା ଅଙ୍ଗାତେ ଆଇଡିଡନ୍‌ ଡକୋ, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଡେଡମେତୋ, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡରକୋଲନାଞନ୍‌ ଆଡିଡ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ତିଆଡିଡ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଡରମ୍ମ ସାସ୍ତ୍ରନ୍‌ ଗନ୍‌ଲୁଡ୍‌ଲେ ରପ୍ତିଏଜି ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆ ବୁଡ୍ଡି ସନଙଞ୍ଜି ରୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ଆରି, ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ ଅନ୍ତମ୍‌ ଅନିଡଲନ୍‌ ଡକୋ, କ୍ରିସ୍ଟନ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ ଆରି ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ୟର୍ମେଙ୍‌ତେ, ");
INSERT INTO juy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ଆରି ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଉଲନ୍‌ ଅଡ଼୍‌କୋ ଜାତିଞ୍ଜି ଆମଙ୍‌ ଆଞୁମ୍‌ଲୋଙନ୍‌ ଇର୍ସେନ୍‌ କେମାନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନାବା ଗାମ୍‌ଲେ ବର୍ନେନ୍‌ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆସନ୍‌ ସାକିମର୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ଆରି ଗିୟ୍‌ବା, ଆପେୟ୍‌ଞେନ୍‌ ଅଙ୍ଗାତେ ବାସାଲନ୍‌, ତିଆତେ ଞେନ୍‌ ଅମଙ୍‌ବାବେନ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌, ବନ୍‌ଡ ତୋଣ୍ଡୋନ୍‌ ସିଲଡ୍‌ ବୋର୍ସାନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏଞାଙେନ୍‌ ଜାୟ୍‌ କେନ୍‌ ଆ ଗଡ଼ାଲୋଙ୍‌ ଡକୋନାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ତିକ୍କି ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବେତନିଆନ୍‌ ଆଜିର୍ତବନ୍‌ ଆ ତଙର୍‌ ଜାୟ୍‌ ଓରୋଙେଞ୍ଜି ଆରି ଆସିନ୍‌ ତେକ୍କେଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆସିର୍ବାଦଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ଆରି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଆସିର୍ବାଦନ୍‌ ତିୟା ତିୟା ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଆନ୍ନାଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ରୁଆଙନ୍‌ ଅନୋରୋଙନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ଆରି ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଲୋମ୍‌ଲେ ଆକ୍ରାନ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ଜିରୁସାଲମନ୍‌ ୟର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ଆରି ଆନିଞ୍ଜି ଆଏଡ଼ର୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଡକୋଡାଲନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଗଙ୍କେଲେଞ୍ଜି ।");
INSERT INTO juy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ଗନଡେଲନ୍‌ ଆ ପୁର୍ବା ବର୍ନେନ୍‌ ଡକୋଏନ୍‌, ଆରି ବର୍ନେନ୍‌ ଡ ଇସ୍ୱରନ୍‌ ଆବୟନ୍‌ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ଗନଡେଲନ୍‌ ଆରୁଲନେନ୍‌ ଆଡିଡ୍‌ ତି ଆ ବର୍ନେ ମା ଇସ୍ୱରନ୍‌ ସରିନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ଇସ୍ୱରନ୍‌ ତି ଆ ବର୍ନେ ବାତ୍ତେ ଅଡ଼୍‌କୋନ୍‌ ଗବ୍‌ଡେଲେନ୍‌, ଆନିନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଇନ୍ନିଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗଡେଲେ । ");
INSERT INTO juy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ଆମଙନ୍‌ ଅନମେଙନ୍‌ ଡକୋଏନ୍‌ ଆରି ତି ଆନମେଙ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ସନାଆର୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ତି ସନାଆରନ୍‌ ଲୋଙଡ୍‌ଲୋଙନ୍‌ ତରାଡ୍‌ଲେ ଜିର୍ତାୟ୍‌ ଆରି ଲୋଙଡନ୍‌ ତିଆତେ ପମ୍‌ଞିଡ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଅନାପ୍ପାୟନ୍‌ ଡେଲୋ, ଆଞୁମନ୍‌ ଜନ । ");
INSERT INTO juy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ଆନିନ୍‌ ତି ସନାଆରନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ, ଆରି ତି ଆ ସାକି ଅମ୍‌ଡଙ୍‌ଡାଲେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଡର୍ନେଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ଆନିନ୍‌ଡମ୍‌ ତି ଆ ସନାଆର୍‌ ତଡ୍‌, ବନ୍‌ଡ ସନାଆରନ୍‌ ଆ ଆସନ୍‌ ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ଅଙ୍ଗା ସନାଆର୍‌ ପୁର୍ତିନ୍‌ ଇୟ୍‌ଲେ, ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ଅବ୍‌ସାଆରେଞ୍ଜି, ତିଆତେ ମା ଆଜାଡ଼ି ସନାଆରନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ଆନିନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ଅମ୍ମେଲେ ପୁର୍ତିନ୍‌ ଗଡେଲେନ୍‌, ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ପୁର୍ତିନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନମ୍ମଡ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ଆନିନ୍‌ ଆ ରାଜ୍ୟନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ଜନଙ୍‌ଡେନ୍‌ ଆ ମନ୍‌ରାଡମଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ବନ୍‌ଡ ଡିଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲେ ଆଞୁମ୍‌ଲୋଙନ୍‌ ଡର୍ରଞ୍ଜି ତି ଅଡ଼୍‌କୋଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆଅନ୍‌ ଆଡନେ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ଆନିଞ୍ଜି ମିଞାମ୍‌ଲୋଙନ୍‌ ସିଲଡ୍‌, ଡଅଙନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ସିଲଡ୍‌ ଅଡ଼େ ମନ୍‌ରାନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ସିଲଡ୍‌ ଆନିଞ୍ଜି କରୋକ୍କୋଡନ୍‌ ଅଃଡ୍ଡେଲଜି, ଆର୍ପାୟ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଆନିଞ୍ଜି କରୋକ୍କୋଡନ୍‌ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ଆରି ତି ଆ ବର୍ନେ ଡଅଙନ୍‌ ଗଡେଲେନ୍‌, ସନାୟୁମନ୍‌ ଡ ଆଜାଡ଼ିଲୋଙନ୍‌ ବରିୟ୍‌ଡାଲେ ଅମଙ୍‌ଲେନ୍‌ ଡକୋଲନେ, ଆନିନ୍‌ ଆବୟଡମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଅନ୍ତମ୍‌ ଅଙ୍ଗା ଗନୁଗୁ ପନେମେଙ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଞାଙେନ୍‌ ତିଆତେ ଇନ୍‌ଲେଞ୍ଜି ଗିୟ୍‌ଲବୋ । ");
INSERT INTO juy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ଆନିନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ଲେ ଜନନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “କେନ୍‌ ଆ ବର୍ନେ ଞେନ୍‌ ବର୍ରନାୟ୍‌, ‘ଆନିନ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିର୍ରାୟ୍‌ ଜନଙ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ କୋଡିଞଞ୍ଜି ଆମ୍ମୁଙ୍‌ ଆନିନ୍‌ ଡକୋଏନ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ତିଆସନ୍‌ ଆ ସନାୟୁମନ୍‌ ଆ ବନରିୟ୍‌ ବାତ୍ତେ ଇନ୍‌ଲେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ସନାୟୁମନ୍‌ ଞାଙ୍‌ଲବୋ, ଓଓ, ସନାୟୁମନ୍‌ ସିଲଡ୍‌ ସନାୟୁମନ୍‌ ଞାଙ୍‌ଲବୋ । ");
INSERT INTO juy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌, ବନାଁୟ୍‌ବରନ୍‌ ମୋସାନ୍‌ ଆମଙ୍‌ଗଡ୍‌ ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ଲନ୍‌, ବନ୍‌ଡ ସନାୟୁମନ୍‌ ଡ ଆଜାଡ଼ିନ୍‌ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆମଙ୍‌ଗଡ୍‌ ଜିର୍ରାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ଆଙ୍ଗିୟ୍‌ ଆନ୍ନିଙ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗିଜେ, ବନ୍‌ଡ ଆନିନ୍‌ ସରିନ୍‌ ଆଡ୍ରକୋଲନ୍‌ ଆବୟଡମ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଗିୟ୍‌ତାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ଜିରୁସାଲମନ୍‌ ଆ ଜିଉଦିମର୍‌ଜି ଜନନ୍‌ଆଡଙ୍‌ “ଆମନ୍‌ ଆନା ?” ଗାମ୍‌ଲେ ବନରନ୍‌ ଆସନ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ରାଓଡ଼ାଞ୍ଜି ଡ ଲେବିଅମରଞ୍ଜିଆଡଙ୍‌ ଆମଙନ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି । ତିଆଡିଡ୍‌ ଆନିନ୍‌ କେନ୍‌ ଆ ସାକି ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ଜନନ୍‌ ଅଃସସଲନ୍‌, ଆନିନ୍‌ ରେୟ୍‌ଲଙ୍‌ ବର୍ରନେ, “ଞେନ୍‌ କ୍ରିସ୍ଟନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜନନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନି ? ଆମନ୍‌ ପଙ୍‌ ଏଲିଅ ?” ଆନିନ୍‌ ଗାମେନ୍‌, “ଇଜ୍ଜା, ଞେନ୍‌ ତଡ୍‌ ।” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଆମନ୍‌ ଇନି ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ପଙ୍‌ ?” ଆନିନ୍‌ ଜାଲଙେଞ୍ଜି, “ଇଜ୍ଜା ।” ");
INSERT INTO juy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜନନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମନ୍‌ ଆନା, ଆମନ୍‌ଡମ୍‌ ବର୍ନା ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଆରାପ୍ପାୟ୍‌ଲଲେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ବର୍ନେନମ୍‌ ଇନ୍‌ଲେନ୍‌ ଇୟ୍‌ତେ ଏବର୍ନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ଏଙ୍ଗାଲେ ବର୍ରନେ, ଜନନ୍‌ ଏତ୍ତେଲେ ବର୍ରନେ, “ଞେନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବରର୍‌ତନାଞନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆ ସର୍ରଙ୍‌, ଞେନ୍‌ ଗାମ୍‌ତାୟ୍‌, ପ୍ରବୁନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ବୁଙୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ଆରି ପାରୁସିଞ୍ଜି ଆରାପ୍ପାୟ୍‌ଲାଞଞ୍ଜି ଆ ମନ୍‌ରାଜି ଲାଙ୍‌ଲେନ୍ନେ ଜନନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“ଆମନ୍‌ କ୍ରିସ୍ଟନ୍‌ ତଡ୍‌, ଏଲିଅନ୍‌ ତଡ୍‌, ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ତଡ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଇନିବା ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଡାଆଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତବେନ୍‌, ଆନାଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ଏଅମ୍ମଡେ ଆନିନ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆତନଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ଆନିନ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିର୍ତାୟ୍‌, ଆ ପାଣ୍ଡୋୟନ୍‌ ଆ ଜନିବାଡ୍‌ ଉଜୁଜନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ଜର୍ଦନ ଅଲନ୍‌ ଆ ଅଡିଗଡ୍‌ ବେତନିଆ ସାଇଲୋଙନ୍‌ ଜନନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟେଞ୍ଜି ତେତ୍ତେ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ତି ଆବାର୍ତାନ୍‌ ଜନନ୍‌ ଆମଙ୍‌ ଜିସୁନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ତିଆତେ ଗିୟ୍‌ଲେ ଜନନ୍‌ ବର୍ରନେ, “କେରେ ଗିୟ୍‌ବା ଇସ୍ୱରନ୍‌ ଆଅନ୍‌ ମେଣ୍ଡା, ଆନିନ୍‌ ପୁର୍ତିନ୍‌ ଆ ଇର୍ସେ ବୋୟ୍‌ଲେ ପାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ଅଙ୍ଗା ମନ୍‌ରା ଆ ବର୍ନେ ଞେନ୍‌ ଆମ୍ମୁଙ୍‌ ବର୍ରନାୟ୍‌ ତି ଆ ମନ୍‌ରା କେନ୍‌ଆନିନ୍‌, ‘ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଜନମ୍ମୁ ଅଣ୍ଡ୍ରଙ୍‌ ଡେଇଞନ୍‌ ଆ ଆମ୍ମୁଙ୍‌ ଆନିନ୍‌ ଡକୋଏନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ଞେନ୍‌ ନିୟ୍‌ ଆମ୍ମୁଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍‌ନମ୍ମଡ୍‌ । ବନ୍‌ଡ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ସରିନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ସେକୁଲନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ଆରି, ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ଲେ ବର୍ରନେ, “ପୁରାଡ଼ାନ୍‌ କୁକ୍କୁରନ୍‌ ଅନ୍ତମ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଜିସୁନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତାର୍ଡୋୟ୍‌ନେନ୍‌ ଞେନ୍‌ ଗିୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ତି ଆ ମନ୍‌ରା କେନ୍‌ଆନିନ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ଅଃଜ୍ଜନାଲାୟ୍‌, ବନ୍‌ଡ ଡାଆଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଅଙ୍ଗା ଇସ୍ୱର ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଜନାଲିଁୟ୍‌, ‘ଅଙ୍ଗା ମନ୍‌ରା ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ପୁରାଡ଼ାନ୍‌ ପଡ୍‌ଲନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତାର୍ଡୋୟ୍‌ନେନ୍‌ ଆମନ୍‌ ଗିୟ୍‌ତେ, ତିଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତଜି ।’ ");
INSERT INTO juy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ଞେନ୍‌ ତିଆତେ ଗିୟ୍‌ଲାୟ୍‌ ଆରି ‘ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌’ ଗାମ୍‌ଲେ ସାକିନ୍‌ ତିୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ତି ଆବାର୍ତାନ୍‌ ଜନନ୍‌, ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ବାଗୁ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ତନଙ୍‌ଲେ ଡକୋଲନ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ତି ଆ ତଙର୍‌ଗଡ୍‌ ଜିସୁନ୍‌ ତଙିୟ୍‌ଲନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ଜନନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙ୍‌ଡାଲେ ବର୍ରନେ, “କେରେ ଗିୟ୍‌ବା ଇସ୍ୱରନ୍‌ ଆଅନ୍‌ ମେଣ୍ଡା ।” ");
INSERT INTO juy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ତି ବାଗୁ ଞଙ୍‌ନେମରଞ୍ଜି ଜନନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ଜିସୁନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଆଗ୍ରିଜେନ୍‌ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ତଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନି ଏସାୟ୍‌ତେ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଆମନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋତନେ, ରାବ୍‌ବି ?” ");
INSERT INTO juy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାମେନ୍‌, “ୟବା ଆୟ୍‌ ଗିୟ୍‌ବା ।” ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିର୍ରେ ଆ ବରସାସିଙନ୍‌ ଇୟ୍‌ଲେ ଗିଜେଜି, ଆରି ତି ଆ ଡିନ୍ନା ଆନିଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ଡକୋଲଞ୍ଜି, ତିଆଡିଡ୍‌ ଅୟମନ୍‌ ଡୋତାନ୍‌ ଦସଟା ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ଅଙ୍ଗା ମନ୍‌ରାଜି ବାଗୁନେ ଜନନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି, ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଅବୟ୍‌ନେ ସିମନ୍‌ ପିତ୍ରନ୍‌ ଆ ବୋଞାଙ୍‌ ଆନ୍ଦ୍ରିଅନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ଆନିନ୍‌ ଆ ବୋଞାଙନ୍‌ ସିମନନ୍‌ଆଡଙ୍‌ ରବାଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଇନ୍‌ଲେନ୍‌ ମସିଅନ୍‌ଆଡଙ୍‌ ଏରବାଙ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ଆନିନ୍‌ ସିମନନ୍‌ଆଡଙ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଓରୋଙ୍‌ଲାୟ୍‌ । ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ସିମନ୍‌, ଜନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ । ଆମନ୍‌ ‘କେପା’ ଗାମ୍‌ଲେ ଓଡ୍ଡେତମ୍‌ଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ତି ଆବାର୍ତାନ୍‌ ଜିସୁନ୍‌ ଗାଲିଲି ଗଡ଼ାନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନେ, ଆରି ଆନିନ୍‌ ପିଲିପନ୍‌ଆଡଙ୍‌ ଆଗ୍ରିଜେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ପିଲିପନ୍‌ ବେତ୍‌ସାଇଦାବାୟ୍‌ ଡକୋଏନ୍‌, ଆନ୍ଦ୍ରିଅନ୍‌ ଡ ପିତ୍ରନ୍‌ ନିୟ୍‌ ତେତ୍ତେବାୟ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ପିଲିପନ୍‌ ନିତନ୍‌ଆଡଙ୍‌ ରବାଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅଙ୍ଗା ମନ୍‌ରା ଆ ବର୍ନେ ମୋସାନ୍‌ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଇଡେନ୍‌, ଆରି ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ନିୟ୍‌ ଇଡେଞ୍ଜି, ଇନ୍‌ଲେଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଏରବାଙ୍‌ଲାୟ୍‌ । ଆନିନ୍‌ ଜୋସେପନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ନାଜରିତବାୟ୍‌ ଜିସୁ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ନିତନ୍‍ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ନାଜରିତନ୍‌ ସିଲଡ୍‌ ଇନ୍ନିଙ୍‌ ଡେନ୍‌ ମନଙନ୍‌ଆତେ ଅଲ୍‌ଡୁଙ୍‌ନାୟ୍‌ ପଙ୍‌ ?” ପିଲିପନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଜିରାୟ୍‌ ଆୟ୍‌ ଗିଜା ।” ");
INSERT INTO juy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ନିତନ୍‍ ଜିସୁନ୍‌ ଆମଙ୍‌ ଆଜିର୍ରାଞନ୍‌ଆତେ ଗିୟ୍‌ଲେ, ଜିସୁନ୍‌ ନିତନ୍‍ ଆ ବର୍ନେ ବର୍ରନେ, “କେରେ ଗିୟ୍‌ବା, କେନ୍‌ଆନିନ୍‌ ଅବୟ୍‌ ଆଜାଡ଼ି ଇସ୍ରାଏଲ୍‌ମର୍‌, କେନ୍‌ ଆମଙନ୍‌ ପାତ୍ୟାନ୍‌ ଅବୟ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ନିତନ୍‍ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଏଙ୍ଗାଲେ ଞେନ୍‌ଆଡଙ୍‌ ଅମ୍ମଡ୍‌ଲିଁୟ୍‌ ?” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ପିଲିପ ଆମନ୍‌ଆଡଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଓଡ୍ଡେଅମନ୍‌ ଆମ୍ମୁଙ୍‌ ଆମନ୍‌ ଅଙ୍ଗା ଆଡିଡ୍‌ ଲୁଆନୁବନ୍‌ ଆ ଜାୟ୍‌ତା ଡକୋଲମ୍‌, ତିଆଡିଡ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ନିତନ୍‍ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଆମନ୍‌ ଇସ୍ରାଏଲନ୍‌ ଆ ରାଜା ।” ");
INSERT INTO juy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ଜିସୁନ୍‌ ବର୍ରନେ, “ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଲୁଆନୁବନ୍‌ ଆ ଜାୟ୍‌ତା ଗିୟ୍‌ଲମ୍‌ ଗରାମ୍‌ଲାଞନ୍‌ ପଙ୍‌ ଆମନ୍‌ ଡର୍ତନେ ? ଆମନ୍‌ କେନ୍‌ ସିଲଡ୍‌ ଆରି ସୋଡ଼ା ସୋଡ଼ା ବର୍ନେଞ୍ଜି ଗିୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ଆରି, ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ରୁଆଙନ୍‌ ରୋତନେ ଆରି ଇସ୍ୱରନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ଜି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଆଡ୍ରାୟ୍‌ତେଞ୍ଜି ଡ ଆପ୍ରଡ୍‌ତନାଞଞ୍ଜି ଆମ୍ୱେଞ୍ଜି ଏଗିୟ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ବାଗୁ ଡିନ୍ନା ଆ ତିକ୍କି ଗାଲିଲି କାନ୍ନା ଗଡ଼ାଲୋଙନ୍‌ ଅବୟ୍‌ ବିବାନ୍‌ ଡେଏନ୍‌, ଆରି ଜିସୁନ୍‌ ଆୟୋଙ୍‌ ତେତ୍ତେ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ତି ଆ ବିବା ବୁଜିଜୋମନ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ଓଡ୍ଡେଲାଜି । ");
INSERT INTO juy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ତିକ୍କି ଦ୍ରାକ୍ୟାଡାନ୍‌ ଆରଞିଡେନ୍‌ ଜିସୁନ୍‌ ଆୟୋଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆ ଦ୍ରାକ୍ୟାଡାଞ୍ଜି ଅଞିଡେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଡ ଞେନ୍‌ ଇନି ଆ କୁଲମ୍‌ ? ଡିନ୍ନାଞେନ୍‌ ନମିନ୍ତାନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଅଡ଼ୋଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ଆୟୋଙନ୍‌ କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଙ୍ଗାତେ ବର୍ତବେନ୍‌, ତିଆତେ ଲୁମ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ଜିଉଦିମରଞ୍ଜି ଆନଗଡ୍‌ ଅନ୍ତମ୍‌ ଗିୟ୍‌ଡାଡୋଙ୍‌ଲନ୍‌ ମବ୍‌ଡ଼ିର୍‌ନେନ୍‌ ଆସନ୍‌ ତେତ୍ତେ ଅରେଙନ୍‌ ବାତ୍ତେ ଆତୁବ୍‌ତୁବନ୍‌ ଡାଆନ୍‌ ଆଡ୍ରକ୍କୋ ସଙ୍କରାନ୍‌ ତୁଡ୍ରୁ ଡକୋଏନ୍‌ । ତଙ୍‌ବୟ୍‌ ସଙ୍କରାଲୋଙନ୍‌ ବସଅ ଆଡ୍ଡା ଡାଆନ୍‌ ଞମ୍‌ଲେ ରପ୍ତିତେ । ");
INSERT INTO juy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ଜିସୁନ୍‌ କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ସଙ୍କରାଲୋଙଞ୍ଜି ଡାଆନ୍‌ ବବ୍‌ରିୟ୍‌ବା ।” ଆନିଞ୍ଜି ସଙ୍କରାନ୍‌ ଆ ସଙ୍କା ଜାୟ୍‌ ଡାଆନ୍‌ ବବ୍‌ରିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ଆରି, ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ତେତ୍ତେ ସିଲଡ୍‌ ଅଜିଡ୍‌ ଗେନ୍‌ଲେ ପାଙ୍‌ଲେ ବୁଜିନ୍‌ ଆତ୍ରୁବେନ୍‌ ଆ ମନ୍‌ରା ଆମଙ୍‌ ପାଙ୍‌ବା ।” ସିଲତ୍ତେ ଆନିଞ୍ଜି ତେତ୍ତେ ସିଲଡ୍‌ ଗେନ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ବୁଜିନ୍‌ ଆତ୍ରୁବେନ୍‌ ଆ ମନ୍‌ରା ତିଆତେ ମାୟ୍‌ମାଜେନ୍‌, ବନ୍‌ଡ ତିଆତେ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ପନାଙନ୍‌ ଡେଲୋ ତିଆତେ ଆନିନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜନାଏ, କମ୍ୱାରିମରଞ୍ଜି ତିଆତେ ଆଜନାଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ବରନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମ୍ମୁଙ୍‌ ଜବୁଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ତିୟ୍‌ତଜି, ଆରି ମନ୍‌ରାଞ୍ଜି ତିଆତେ ଗାଲୋଙ୍‌ ଗାଲେ ବନ୍ନୁଲେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆଜବେଡନ୍‌ ଆ ଦ୍ରାକ୍ୟାଡା ତିୟ୍‌ତଜି । ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ନମିନ୍ତାନ୍‌ ମନଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ଏଡକ୍କୋଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ଜିସୁନ୍‌ କେନ୍‌ ଏନ୍ନେଲେ ପର୍ତମ୍ମୁ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଗାଲିଲି କାନ୍ନା ଗଡ଼ାଲୋଙନ୍‌ ଲୁମ୍‌ଲେ ଆ ଗନୁଗୁ ପନେମେଙନ୍‌ ଅବ୍‌ତୁଜେନ୍‌, ଆରି ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙନ୍‌ ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌, ଆୟୋଙନ୍‌, ଆ ବୋଞାଙଞ୍ଜି ଡ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ କପର୍ନାଉମ୍‌ ଗଡ଼ାନ୍‌ ଜିରେଞ୍ଜି । ଆରି, ଆନିଞ୍ଜି ତେତ୍ତେ ଗୋଗୋୟ୍‌ ଡିନ୍ନା ଅଃନ୍ନେଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ତିଆଡିଡ୍‌ ଜିଉଦିମରଞ୍ଜି ଆନେଲାୟ୍‌ପୁର୍‌ ତୁୟାଲେ ପାଙ୍‌ଲାୟ୍‌, ଆରି ଜିସୁନ୍‌ ଜିରୁସାଲମନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ଆରି, ସରେବାସିଂଲୋଙନ୍‌ ତାଙ୍‌ଲିୟନ୍‌, ମେଣ୍ଡାନ୍‌ ଆରି କୁକ୍କୁର୍‌ ବେପାରମରଞ୍ଜି ଆରି ବାର୍‌ବାର୍‌ଡାବ୍‌ମରଞ୍ଜି ତଙ୍କୁମ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆନିନ୍‌ ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ଆରି ଜିସୁନ୍‌ ଲୁଆଡନ୍‌ ବାତ୍ତେ ଅବୟ୍‌ ସାମକାନ୍‌ ତୁବ୍‌ଲେ ମେଣ୍ଡାଞ୍ଜି ଡ ତାଙ୍‌ଲିୟଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଅମ୍‌ଡୁଙାଜେଞ୍ଜି, ଆରି ବାର୍‌ବାର୍‌ଡାବ୍‌ମରଞ୍ଜି ଆ ଡାବ୍ବୋ ବୁର୍ବୁରାୟ୍‌ଡାଲେ ଆ ମେଜଞ୍ଜି ସବ୍‌ଡିଡାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ଆରି ଆନିନ୍‌ କୁକ୍କୁର୍‌ ତମ୍‌ତମ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ଆତେଜି ତେନ୍ନେ ସିଲଡ୍‌ ପାଙ୍‌ବା, ଆପେୟ୍‌ଞେନ୍‌ ଆସିଂ ବେପାରସିଂ ଏଏମ୍ମେଡଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","କେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ଅବୟ୍‌ ବର୍ନେନ୍‌ ମନ୍ନେଏଞ୍ଜି, “ଅସିଂନମ୍‌ ଆସନ୍‌ ଅନୋମଙ୍‌ଞେନ୍‌ ଅମ୍ମଲୋଙ୍‌ଞେନ୍‌ ତଗୋନ୍‌ ଅନ୍ତମ୍‌ ଡୁଡୁତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ସିଲତ୍ତେ ଜିଉଦିମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ବର୍ନେନ୍‌ ବରେଞ୍ଜି, “ଆମନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ସନୋଡ଼ାନେନ୍‌ ଞାଙେନ୍‌ ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଏଙ୍ଗାଲେ ଏଜନାଆୟ୍‌ ? ଆରି ଇନି ଆରମ୍ମଡ୍‌ ବାତ୍ତେ ତିଆତେ ଆମନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ତୁୟ୍‌ତଲେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ସରେବାସିଙନ୍‌ ପୁଡ୍‌ବା, ଞେନ୍‌ ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ତିଆତେ ଆରି ତୁବ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ସିଲତ୍ତେ ଜିଉଦିମରଞ୍ଜି ଗାମେଞ୍ଜି, “କେନ୍‌ ଆ ସରେବାସିଂ ତୁବ୍‌ତୁବନ୍‌ ଆସନ୍‌ ବାକୁଡ଼ି ତୁଡ୍ରୁ ବର୍ସେଙ୍‌ ଡେଏନ୍‌, ଆମନ୍‌ ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ତିଆତେ ତୁବ୍‌ଲେ ରପ୍ତିତେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆ ଡଅଙ୍‌ ସରେବାସିଙନ୍‌ ଆ ବର୍ନେ କେନ୍‌ଆତେ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ଜିସୁନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆଡ୍ରୋଲନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନିନ୍‌ କେନ୍‌ଆତେ ବର୍ରନେ ଗାମ୍‌ଲେ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ମନ୍ନେଏଞ୍ଜି । ତିଆସନ୍‌ ଆନିଞ୍ଜି ଡରମ୍ମ ସାସ୍ତ୍ରନ୍‌ ଡ ଜିସୁନ୍‌ ଆ ବର୍ନେଜି ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ଏଲାୟ୍‌ପୁର୍‌ ଇଙନ୍‌ ଜିସୁନ୍‌ ଜିରୁସାଲମଲୋଙନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଆଡିଡ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ ସାନ୍ନି କାବ୍ବାଡ଼ାଜି ଗିୟ୍‌ଲେ ଆଞୁମ୍‌ଲୋଙନ୍‌ ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆମଙଞ୍ଜି ଅଃନ୍ନିଙ୍‌ଡର୍ରନେ ଆରି ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଆନିନ୍‌ ଆନ୍ନାଲନ୍‌ ଡକୋଲନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ମନ୍‌ରାଞ୍ଜି ଆ ବର୍ନେ ଆନ୍ନିଙ୍‌ ଇନ୍ନିଙ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବନରନ୍‌ ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ଉଗର୍‌ଲୋଙ୍‌ ଇନି ଡକୋ ତିଆତେ ଜିସୁନ୍‌ ଜନାଆଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ପାରୁସିଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ନିକଦିମ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମର୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ଆନିନ୍‌ ତଗଲନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲେ, ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେ, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌ କେନ୍‌ଆତେ ଇନ୍‌ଲେନ୍‌ ଜନା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ସାନ୍ନି କାବ୍ବାଡ଼ାଜି ଆମନ୍‌ ଲୁମ୍‌ତେ, ଇସ୍ୱରନ୍‌ ସରିନ୍‌ ଅଃଡ୍ଡକୋଲନ୍‌ ଡେନ୍‌, ତିଆତେ ଆନ୍ନିଙ୍‌ ଲୁମ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆଜାଡ଼ିଡମ୍‌, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, ବାଗୁତର ଜନମ୍ମୁ ଅଃଡ୍ଡେଲୋ ଡେନ୍‌ ଆନ୍ନିଙ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଗିୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ନିକଦିମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ମନ୍‌ରାନ୍‌ ବୁଡାଏନ୍‌ ଡେନ୍‌ ଏଙ୍ଗାଡାଲେ ଆରି ବତର ଜନମ୍ମୁ ଡେଏ ? ଆନିନ୍‌ ଇନି ଆୟୋଙନ୍‌ ଆ କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ ଗନ୍‌ଲେ ବାଗୁ ତର କରୋକ୍କୋଡନ୍‌ ଅଲ୍‌ଡେଏ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆଜାଡ଼ିଡମ୍‌, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, ଡାଆଲୋଙନ୍‌ ଡ ପୁରାଡ଼ାଲୋଙନ୍‌ କରୋକ୍କୋଡନ୍‌ ଅଃଡ୍ଡେଲୋ ଡେନ୍‌, ଆନ୍ନିଙ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗନ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ଅଙ୍ଗାତେ ଡଅଙନ୍‌ ବାତ୍ତେ କରୋକ୍କୋଡନ୍‌ ଡେତେ, ତିଆତେ ଡଅଙନ୍‌, ବନ୍‌ଡ ଅଙ୍ଗାତେ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ କରୋକ୍କୋଡନ୍‌ ଡେତେ ତିଆତେ ପୁରାଡ଼ାନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ଆମ୍ୱେଞ୍ଜି ଆରି ବତର ଜନମ୍ମୁ ଡେବେନ୍‌ତୋ ଗାମ୍‌ଲେ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ରମ୍‌, ତିଆସନ୍‌ ଆମନ୍‌ ସାନ୍ନି ଡେଡଙମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ରିଙ୍ଗେନ୍‌ ଅଡ଼େଙ୍ଗା ଲଡୟ୍‌ତେ, ଅଡ଼େତ୍ତେ ଇଡ୍‌ତ୍ତେ, ଆମ୍ୱେଞ୍ଜି ଆ ସନଡ୍ଡାନ୍‌ ଏଅମ୍‌ଡଙ୍‌ତେ, ବନ୍‌ଡ ତିଆତେ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଜିର୍ତାୟ୍‌, ଆରି ଅଙ୍ଗାଲୋଙ୍‌ ଜିର୍ତେ ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଏଃଜ୍ଜନାଏ । ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ଜନମ୍ମୁ ଆଡ୍ରେଏଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ତି ଅନ୍ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ନିକଦିମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “କେନ୍‌ଆତେ ଏଙ୍ଗାଡାଲେ ଅଲ୍‌ଡେଏ ?” ");
INSERT INTO juy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆମନ୍‌ ଅବୟ୍‌ ଇସ୍ରାଏଲନ୍‌ ଆ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଜନଙ୍‌ଡେନ୍‌ ଆମନ୍‌ କେନ୍‌ଆତେ ଅଣ୍ଡ୍ରଙ୍‌ ଜନାଅମ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତମ୍‌, ଇନ୍‌ଲେନ୍‌ ଅଙ୍ଗାତେ ଆଜନା, ତିଆତେ ଏବର୍ତନାୟ୍‌, ଆରି ଇନିଜି ଏଗିୟ୍‌ଲାୟ୍‌, ତିଆତେଜି ଆସନ୍‌ ସାକିନ୍‌ ଏତିୟ୍‌ତାୟ୍‌, ଆରି ଆମ୍ୱେଞ୍ଜି ସାକିଲେଞ୍ଜି ଏଃଜ୍ଜାଏ । ");
INSERT INTO juy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ପୁର୍ତିନ୍‌ ଆ ବର୍ନେ ବର୍ରବେନ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଃଡ୍ଡର୍ନେ, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ରୁଆଙନ୍‌ ଆ ବର୍ନେ ବର୍ରବେନ୍‌ ଡେନ୍‌ ଏଙ୍ଗାଲେ ଏଡର୍ତନେ ? ");
INSERT INTO juy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ଆରି ରୁଆଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ଆଜିର୍ରାଞନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆନ୍ନିଙ୍‌ ଆରି ରୁଆଙନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଡାଜେ ।” ");
INSERT INTO juy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ମୋସାନ୍‌ ଏଙ୍ଗାଲେ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ତୋଣ୍ଡୋ ସୋଣ୍ଡାଙନ୍‌ ପିତ୍ତଡ଼ଜଡନ୍‌ ଅମ୍‌ଡାଜେନ୍‌, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଏତ୍ତେଲେମା ତୋଣ୍ଡୋନ୍‌ ଅନମ୍‌ଡାଜନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନାଜନଙ୍‌ ଆମଙନ୍‌ ଡର୍ତନେ, ଆନିନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ପୁର୍ତିନ୍‌ ଏତ୍ତେଲେ ଡୁଙ୍‌ୟମେନ୍‌ ଡ, ଆନିନ୍‌ ଆବୟଡମ୍‌ ଆ ଅନନ୍‌ ତିୟେନ୍‌, ଆନାଜନଙ୍‌ ଆମଙନ୍‌ ଡର୍ତନେ, ଆନିନ୍‌ ଅଃମ୍ମୋସ୍ସାଏ, ଆରି ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ପୁର୍ତିନ୍‌ ଆନବ୍‌ପନ୍‌ସୁଆତି ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନାପ୍ପାୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ପୁର୍ତିନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଅମ୍ମେଲେ ଅନୁରନ୍‌ ଅଲ୍‌ଞାଙେ, ତିଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ଆନା ଆମଙନ୍‌ ଡର୍ତନେ, ଆନିନ୍‌ ଆସନ୍‌ ପନ୍‌ସୁଆତିନ୍‌ ଅଃଡ୍ଡେଏ । ବନ୍‌ଡ ଆନା ଅଃଡ୍ଡର୍ନେ ଆନିନ୍‌ ଆସନ୍‌ ପନ୍‌ସୁଆତିନ୍‌ ଡେଏନ୍ନି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆବୟଡମନ୍‌ ଇସ୍ୱରନ୍‌ ଆଅନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଅଃଡ୍ଡର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ଆରି ତି ଆ ପନ୍‌ସୁଆତି କେନ୍‌ଆତେ, ପୁର୍ତିଲୋଙନ୍‌ ସନାଆରନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ମନ୍‌ରାଞ୍ଜି ସନାଆରନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଲୋଙଡନ୍‌ ଲଡଜେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆ କାବ୍ବାଡ଼ାଞ୍ଜି ପରାନ୍‌ସାତ୍ତିନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ପରାନ୍‌ସାତ୍ତିନ୍‌ ଆ କାବ୍ବାଡ଼ା ଲୁମ୍‌ତେ, ଆନିନ୍‌ ସନାଆରନ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତେ, ଆରି ଅସମୟ୍‌ ଆ କାବ୍ବାଡ଼ାନ୍‌ ଆ ଡୋସା ଗିୟ୍‌ତାତେ ଗାମ୍‌ଲେ ଆନିନ୍‌ ସନାଆରନ୍‌ ଆମଙ୍‌ ଅଃନ୍ନିଆୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ବନ୍‌ଡ ଆନା ଆଜାଡ଼ି କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ତେ, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଇସ୍ୱରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ ଲୁମେନ୍‌ ଗାମ୍‌ଲେ ଅଲ୍‌ଗିୟ୍‌ତାଏ, ତିଆସନ୍‌ ଆନିନ୍‌ ସନାଆରନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","କେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଡ ଞଙ୍‌ନେମରଞ୍ଜି ଜିଉଦା ଡେସାନ୍‌ ଜିରେଞ୍ଜି, ଆରି ଆନିନ୍‌ ତେତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ଡକୋଡାଲନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ଆରି ଜନନ୍‌ ନିୟ୍‌ ସାଲମନ୍‌ ଆ ତୁୟାୟ୍‌ ଏନୋନଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତେତ୍ତେ ଗୋଗୋୟ୍‌ ଡାଆନ୍‌ ଡକୋଏନ୍‌, ଆରି ମନ୍‌ରାଞ୍ଜି ତେତ୍ତେ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ତବ୍ବୁବ୍‌ଡାନେଜି । ");
INSERT INTO juy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ତି ଆ ଡିନ୍ନା ଜାୟ୍‌ ଜନନ୍‌ଆଡଙ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଡକ୍କୋଏଜି । ");
INSERT INTO juy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ଅବୟ୍‌ ଜିଉଦିମରନ୍‌ ଡ ଜନନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ମନଡ଼ିରନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ଅଲ୍‌ବାଡ୍ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ଆରି, ଆନିଞ୍ଜି ଜନନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଅଙ୍ଗା ମନ୍‌ରା ଜର୍ଦନ ଅଲନ୍‌ ଆ ଅଡିଗଡ୍‌ ଆମନ୍‌ ସରିନ୍‌ ଡକୋଏନ୍‌, ଆନା ଆ ବର୍ନେ ଆମନ୍‌ ସାକିନ୍‌ ତିୟେନ୍‌, ଗିଜା, ଆନିନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତଜି, ଆରି ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜି ଆମଙନ୍‌ ଜିର୍ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ଜନନ୍‌ ଜାଲଙେଞ୍ଜି, “ରୁଆଙନ୍‌ ସିଲଡ୍‌ ତନିୟନ୍‌ ଅଃଡ୍ଡେଲୋ ଡେନ୍‌, ମନ୍‌ରାନ୍‌ ଇନ୍ନିଙ୍‌ ଞାଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘ଞେନ୍‌ କ୍ରିସ୍ଟନ୍‌ ତଡ୍‌, ବନ୍‌ଡ ଞେନ୍‌ଆଡଙ୍‌ ଅବ୍ବାମ୍ମୁଙ୍‌ଡାଲେ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ଜି,’ କେନ୍‌ଆତେ ଞେନ୍‌ ବର୍ରନାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ମା ସାକିମର୍‌ଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ଆନା ଆଇବଜନ୍‌ ଓରୋଙ୍‌ତେ ଆନିନ୍‌ ବରନ୍‌, ବନ୍‌ଡ ଅଙ୍ଗା ସାଙ୍ଗ ବରନ୍‌ ଆମଙ୍‌ ତନଙ୍‌ଡାଲେ ବରନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ତେ, ଆନିନ୍‌ ବରନ୍‌ ଆ ସର୍ରଙ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଗୋଗୋୟ୍‌ ସର୍ଡାତନେ । ତିଅନ୍ତମ୍‌ ନମିଞେନ୍‌ ସନର୍ଡାଞେନ୍‌ ବରିଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ବନ୍‌ଡ ଆନିନ୍‌ ଗୋଗୋଜେତୋ, ଆରି ଞେନ୍‌ ଅସୋଜିଁୟ୍‌ତୋ ।” ");
INSERT INTO juy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ଆନା ତୋଣ୍ଡୋନ୍‌ ସିଲଡ୍‌ ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ସିଲଡ୍‌ ସୋଡ଼ା । ଆନା ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ତନାୟ୍‌, ଆନିନ୍‌ ପୁର୍ତିମର୍‌, ଆରି ଆନିନ୍‌ ପୁର୍ତିନ୍‌ ଆ ବର୍ନେ ବର୍ତନେ । ବନ୍‌ଡ ଆନା ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ସିଲଡ୍‌ ସୋଡ଼ା । ");
INSERT INTO juy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ଆନିନ୍‌ ଅଙ୍ଗାତେ ଆଗିୟ୍‌ଗିୟ୍‌ ଆରି ଅଙ୍ଗାତେ ଆଅମ୍‌ଡଙ୍‌ ତିଆତେ ଆସନ୍‌ ଆନିନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ, ବନ୍‌ଡ ଆ ସାକିନ୍‌ ଆନ୍ନିଙ୍‌ ଅଃଜ୍ଜାଏଜି । ");
INSERT INTO juy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ଆନା ଆ ସାକିନ୍‌ ଜାତେ, ଇସ୍ୱରନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଗାମ୍‌ଲେ ଆନିନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ଇସ୍ୱରନ୍‌ ଆନାଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌, ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ବର୍ତନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ପୁରାଡ଼ାନ୍‌ ଏର୍‌ତନରେଡନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ଆପେୟନ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ, ଆରି ଅଡ଼୍‌କୋନ୍‌ଆତେ ଆସିଲୋଙନ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ଆନା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମଙ୍‌ ଡର୍ତନେ, ଆନିନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞାଙେନ୍‌, ବନ୍‌ଡ ଆନା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଆଲ୍ଲେତେ, ଆନିନ୍‌ ଅନମେଙନ୍‌ ଅଃଗିଜେ, ଆରି ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବବ୍‌ରାବ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ସିଲଡ୍‌, ଜିସୁନ୍‌ ଆରି ଗୋଗୋୟ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞଙ୍‌ନେମର୍‌ ଏମ୍ମେତଜି ଆରି ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ତଜି ଗାମ୍‌ଲେ ପାରୁସିଞ୍ଜି ଅମ୍‌ଡଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ଜିସୁନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ଅଃତ୍ତିୟ୍‌ଲଜି, ବନ୍‌ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ଆ ବର୍ନେନ୍‌ ପାରୁସିଞ୍ଜି ଅମ୍‌ଡଙେଞ୍ଜି ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଆଜ୍ରନାଏନ୍‌ ଆନିନ୍‌ ଜିଉଦା ଗଡ଼ାନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆରି ଗାଲିଲିନ୍‌ ୟର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ଆନିନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ସମିରୋଣଗଡ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ସିଲତ୍ତେ ଆନିନ୍‌ ସମିରୋଣ ଡେସାଲୋଙନ୍‌ ସୁକାର୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ତୁଙେନ୍‌ । ତି ଆ ଗଡ଼ା, ଜାକୁବନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଜୋସେପନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗା ଲବ ତିୟେନ୍‌ ତି ଆ ତୁୟାୟ୍‌ଲୋଙ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ତେତ୍ତେ ଜାକୁବନ୍‌ ଆ କୁଆ ଅବୟ୍‌ ଡକୋଏନ୍‌, ଜିସୁନ୍‌ ଆମ୍ରଙ୍ଗାଏନ୍‌ ତି ଆ କୁଆଲୋଙ୍‌ ତଙ୍କୁମେନ୍‌ । ତିଆଡିଡ୍‌ ତମ୍‌ବାଇଂ । ");
INSERT INTO juy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ଜିସୁନ୍‌ ତେତ୍ତେ ତଙ୍କୁମ୍‌ଲେ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌, ଅବୟ୍‌ ସମିରୋଣବଜନ୍‌ ଡାଆବାନ୍‌ କୁଆନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ଇର୍ଗାଲ୍‌ଡାତିଁୟ୍‌, ଡାଆନ୍‌ ତିୟିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ତିଆଡିଡ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଜନୋମନ୍‌ ଞିଞିବାନ୍‌ ଗଡ଼ାନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ସମିରୋଣବଜନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆମନ୍‌ ଅବୟ୍‌ ଜିଉଦିମର୍‌, ଞେନ୍‌ ଅବୟ୍‌ ସମିରୋଣବୟ୍‌ । ତିଆସନ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ଆ ଡାଆ ଆମନ୍‌ ଏଙ୍ଗାଲେ ଗାତେ ?” ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସମିରୋଣମରଞ୍ଜି ଡ ଜିଉଦିମରଞ୍ଜି ଅଃନ୍ନଲ୍‌ଗାଡିଁୟ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଇସ୍ୱରନ୍‌ ଇନି ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ତନେ, ଆମନ୍‌ ଜନାଲମ୍‌ ନଙ୍‌, ଆରି ଆନା ଗାଡାନେନ୍‌ ଆସନ୍‌ ଡାଆନ୍‌ ତିୟିଁୟ୍‌ ଗାମ୍‌ଲେ ବେଡ୍‌ତମ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଆମନ୍‌ ଅମ୍ମଡେନ୍‌ ନଙ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଆମନ୍‌ ବେଡ୍‌ତେ ବନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅନମେଙ୍‌ଡାନ୍‌ ତିୟ୍‌ତମ୍‌ ବନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ତି ଆଇମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଆଜ୍ଞା, ଡାଆନ୍‌ ଗେଙ୍ଗେନନ୍‌ ଆସନ୍‌ ଅମଙ୍‌ନମ୍‌ ଇନ୍ନିଙ୍‌ ବାଲ୍‍ଟି ତଡ୍‌, ଆରି କୁଆନ୍‌ ଜରୁଡମ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଅଡ଼େଙ୍ଗା ସିଲଡ୍‌ ତି ଅନମେଙ୍‌ଡାନ୍‌ ଞାଙେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ପୁର୍ବା ଜୋଜୋଲେନ୍‌ ଜାକୁବନ୍‌ କେନ୍‌ ଆ କୁଆ ଅବ୍‌ଗାୟ୍‌ଗାୟେନ୍‌ । ଆରି, ଆନିନ୍‌, ଆ ଡାଙ୍ଗଡ଼ାଅନଞ୍ଜି ଡ ଆନିଞ୍ଜି ଆବ୍ରନେଞ୍ଜି ଆ ଜନ୍ତୁଞ୍ଜି କେନ୍‌ ଆ କୁଆ ଆ ଡାଆ ଗାଏଞ୍ଜି, ଆନିନ୍‌ ସିଲଡ୍‌ ପଙ୍‌ ଆମନ୍‌ ସୋଡ଼ା ?” ");
INSERT INTO juy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆନା କେନ୍‌ ଆ ଡାଆ ଗାତେ, ଆନିନ୍‌ ଆରି ଇର୍ଗାଲ୍‌ତେ; ");
INSERT INTO juy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ବନ୍‌ଡ ଞେନ୍‌ ଅଙ୍ଗା ଡାଆ ତିୟ୍‌ତାୟ୍‌, ତିଆତେ ଆନା ଗାତେ, ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ ଅଃନ୍ନିର୍ଗାଲେ, ଆର୍ପାୟ୍‌ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗା ଡାଆ ତିୟ୍‌ତାୟ୍‌, ତିଆତେ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ଡରୁଙ୍‌ଡମ୍‌ନେଡା ଅନ୍ତମ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ଗୋତ୍ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ଆଇମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଆଜ୍ଞା, ଞେନ୍‌ଆଡଙ୍‌ ତି ଆ ଡାଆ ତିୟିଁୟ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଆରି ଅଃନ୍ନିର୍ଗାଲିଁୟ୍‌, ଆରି ଡାଆବାନ୍‌ ଡିୟ୍‌ନେ ସଙାୟ୍‌ ଆ ତଙର୍‌ ଅଃନ୍ନିଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜିରା, ଅୟ୍‌ତବ୍‌ନମ୍‌ଆଡଙ୍‌ ତେନ୍ନେ ଓଡ୍ଡେଲେ ଇୟ୍‌ନୋରୋଙା ।” ");
INSERT INTO juy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ଆଇମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଅୟ୍‌ତବ୍‌ଞେନ୍‌ ଅବୟ୍‌ ତଡ୍‌ ।” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅୟ୍‌ତବ୍‌ଞେନ୍‌ ଅବୟ୍‌ ତଡ୍‌, କେନ୍‌ଆତେ ଆମନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ରନେ; ");
INSERT INTO juy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅୟ୍‌ତବ୍‌ନମ୍‌ଜି ମନ୍‌ଲୟ୍‌ ମନ୍‌ରା ଡକୋଏଞ୍ଜି, ଆରି ନମି ଅମଙ୍‌ନମ୍‌ ଆନା ଡକୋ, ଆନିନ୍‌ ନିୟ୍‌ ଅୟ୍‌ତବ୍‌ନମ୍‌ ତଡ୍‌, କେନ୍‌ଆତେ ଆମନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ରନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ଆଇମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆଜ୍ଞା, ଆମନ୍‌ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌, କେନ୍‌ଆତେ ଞେନ୍‌ ଜନାଲେ ରପ୍ତିତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି କେନ୍‌ ଆ ବରୁଲୋଙ୍‌ ପୁର୍ପୁର୍ରଞ୍ଜି, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଜିଉଦିମରଞ୍ଜି ଏଗାମ୍‌ତେ, ଜିରୁସାଲମଲୋଙନ୍‌ ତୁମ୍‌ ପୁର୍ପୁର୍‌ତନେବୋ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଆଇମର୍‌, ବର୍ନେଞେନ୍‌ ଡର୍ନା, ଏନ୍ନେଲେ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌ ଡ, ତି ଆ ଡିନ୍ନା କେନ୍‌ ଆ ବରୁଲୋଙ୍‌ ଅଡ଼େ ଜିରୁସାଲମଲୋଙନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ପନୁରନ୍‌ ଅଃଡ୍ଡେଏ । ");
INSERT INTO juy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ଆମ୍ୱେଞ୍ଜି ସମିରୋଣମରଞ୍ଜି ଆନାଆଡଙ୍‌ ଏପୁର୍ତେ, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଜନାଜି ତଡ୍‌, ବନ୍‌ଡ ଇନ୍‌ଲେଞ୍ଜି ଜିଉଦିମରଞ୍ଜି ଆନାଆଡଙ୍‌ ଏପୁର୍ତାୟ୍‌ ତିଆତେ ଇନ୍‌ଲେଞ୍ଜି ଜନାଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅନୁରନ୍‌ ଜିର୍ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ବନ୍‌ଡ ଅଙ୍ଗା ଆଡିଡ୍‌ ଆଜାଡ଼ି ସେନ୍‌ପୁର୍‌ମରଞ୍ଜି ପୁରାଡ଼ାନ୍‌ ଡ ଆଜାଡ଼ିନ୍‌ ବାତ୍ତେ ଆପେୟନ୍‌ଆଡଙ୍‌ ପୁର୍‌ତଜି, ତି ଡିନ୍ନା ଅଡ଼ୋତାୟ୍‌, ଆରି ନମି ନିୟ୍‌ ଅଡ଼ୋଲାୟ୍‌ନି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆପେୟନ୍‌ କେନ୍‌ ଆ ସେନ୍‌ପୁର୍‌ ସାୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ଇସ୍ୱରନ୍‌ ପୁରାଡ଼ା, ଆରି ଆନାଜି ଆନିନ୍‌ଆଡଙ୍‌ ପୁର୍‌ତଜି, ଆନିଞ୍ଜି ପୁରାଡ଼ାନ୍‌ ଡ ଆଜାଡ଼ିନ୍‌ ବାତ୍ତେ ପୁରେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ଆଇମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ମସିଅ ଆନିନ୍‌ଆଡଙ୍‌ କ୍ରିସ୍ଟ ଗାମ୍‌ତଜି, ଆନିନ୍‌ ଜିର୍ତାୟ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ଜନା, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆନିନ୍‌ ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଇୟ୍‌ତାୟ୍‌ ଅବ୍‌ଜନାଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ଆନିନ୍‌, ତି ଆ ମନ୍‌ରା ମା ନମିଞେନ୍‌ ଆମନ୍‌ ସରିନ୍‌ କଡାଡ଼ିତନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ତି ଆ ବନେଡ଼ା ଆ ଞଙ୍‌ନେମରଞ୍ଜି ତେତ୍ତେ ୟର୍ରନ୍‌ ଜିସୁନ୍‌ ଅବୟ୍‌ ଆଇମରନ୍‌ ସରିନ୍‌ ଆକ୍ରଡାଡ଼ିଲନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଞ୍ଜି, ସାନ୍ନି ଡେଏଞ୍ଜି । ବନ୍‌ଡ “ଆମନ୍‌ ଇନି ସାୟ୍‌ତେ ? ଅଡ଼େ ଇନିବା ଆନିନ୍‌ ସରିନ୍‌ କଡାଡ଼ିତନେ ?” ଗାମ୍‌ଲେ ଆନ୍ନିଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃବ୍ବର୍ରଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ସିଲତ୍ତେ ତି ଆଇମରନ୍‌ ଡାଆସୋଡନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଗଡ଼ାନ୍‌ ଜିର୍ରେ, ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ୟବା, ଅବୟ୍‌ନେଆଡଙ୍‌ ଆୟ୍‌ ଗିୟ୍‌ବା, ଞେନ୍‌ ଇନିଜି ଲୁମ୍‌ଲାୟ୍‌, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆନିନ୍‌ ବର୍ରନେ, ଆନିନ୍‌ ଜାଆରୋ କ୍ରିସ୍ଟନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ସିଲତ୍ତେ ମନ୍‌ରାଞ୍ଜି ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆମଙନ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ତି ଆ ବନେଡ଼ା ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଗାଗାନା ।” ");
INSERT INTO juy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଗାଗାନେନ୍‌ ଆସନ୍‌ ଅଙ୍ଗା ଜନୋମ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡକୋ, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଇନ୍ନିଙ୍‌ ଜନାଜି ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ତିଆସନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ଆନିନ୍‌ଆଡଙ୍‌ ଆନ୍ନିଙ୍‌ ଜନୋମନ୍‌ ପାଙ୍‌ତିୟ୍‌ଲାୟ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଆରି ଆନିନ୍‌ ଆତ୍ରିୟ୍‌ଲିଞନ୍‌ ଆ କାବ୍ବାଡ଼ା ଅନବ୍‌ସୁଜ୍ଜେନ୍‌, କେନ୍‌ଆତେ ମା ଜନୋମ୍‌ଞେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ଆମ୍ୱେଞ୍ଜି ଏଗାମ୍‌ତେ, ‘ଜନ୍‌ରୋମନ୍‌ ଗଗଡନ୍‌ ଆସନ୍‌ ଆରି ଉଞ୍ଜି ଆଙ୍ଗାୟ୍‌ ଡକୋ ।’ ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଜନ୍‌ରୋମ୍‌ଆଲଞ୍ଜି ଗିୟ୍‌ବା, ତି ଅଡ଼୍‌କୋନ୍‌ ଗଗଡନ୍‌ ଆସନ୍‌ ଅଗୁରେନ୍‌ନି । ");
INSERT INTO juy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ନମିନ୍ତାନ୍‌ ଗଗଡ୍‌ନ୍ନେମରନ୍‌ ବଡିନ୍‌ ଞାଙ୍‌ତେ, ଆରି ଆନିନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଆସନ୍‌ ଅଜନ୍‌ ରୁକ୍କୁତେ । ତି ବାତ୍ତେ ବୁବ୍ବୁଡ୍‌ନେମରନ୍‌ ଡ ଗଗଡ୍‌ନ୍ନେମରନ୍‌ ବାଗୁଞ୍ଜି ମାୟ୍‌ଲନ୍‌ ସର୍ଡାତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅବୟ୍‌ନେ ବିଡ୍‌ତେ ଆରି ଆନ୍ନାମର୍‌ ଅବୟ୍‌ନେ ଗଡ୍‌ତେ, କେନ୍‌ ଆ ବର୍ନେ ଆଜାଡ଼ିନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଜନ୍‌ରୋମ୍‌ଆଲ୍‌ ଆସନ୍‌ ଏଃଲ୍ଲନୁମ୍‌ଲନ୍‌, ତିଆତେ ଗଗଡନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲବେନ୍‌, ଆନ୍ନାମରଞ୍ଜି କାବ୍ବାଡ଼ାଲଞ୍ଜି, ଆରି ଆମ୍ୱେଞ୍ଜି ଆ କାବ୍ବାଡ଼ାଞ୍ଜି ଆ ଲାବ ଏଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ତି ଆ ଗଡ଼ାଲୋଙ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ସମିରୋଣମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆଇମରନ୍‌, “ଆମ୍ମୁଙ୍‌ ଞେନ୍‌ ଇନିଜି ଲୁମ୍‌ଲାୟ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବର୍ରିଁୟ୍‌ ।” ଗାମ୍‌ଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସାକିନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ଆରି ସମିରୋଣମରଞ୍ଜି, ଆମଙଞ୍ଜି ଡକୋନେନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, ତିଆସନ୍‌ ତେତ୍ତେ ଆନିନ୍‌ ବାଗୁ ଡିନ୍ନା ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ଆରି, ଜିସୁନ୍‌ ଆନପ୍ପୁଙ୍‌ବର୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ଆରି, ଆନିଞ୍ଜି ତି ଆଇମରନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ନମି ବର୍ନେନମ୍‌ ତୁମ୍‌ ଅମ୍ମେଲେ ଇନ୍‌ଲେଞ୍ଜି ଏଃଡ୍ଡର୍ନାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନ୍‌ଲେନ୍‌ଡମ୍‌ ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌, ଆରି ଆଜାଡ଼ିଡମ୍‌ କେନ୍‌ଆନିନ୍‌ ପୁର୍ତିନ୍‌ ଆନୁର୍‌ମର୍‌, ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଏଜନାଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ବାଗୁ ଡିନ୍ନା ଆ ତିକ୍କି ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଗାଲିଲିନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିସୁନ୍‌ ଆନିନ୍‌ଡମ୍‌ ବର୍ରନେ, “ଆ ସାଇଡମ୍‌ଲୋଙନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମାନ୍ନେଏଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ଆରି, ଜିସୁନ୍‌ ଗାଲିଲିନ୍‌ ଆରିୟ୍‌ଲାଞନ୍‌, ତେତ୍ତେବାଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଏଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ନିୟ୍‌ ପୁର୍ପୁରିଙନ୍‌ ଜିରୁସାଲମନ୍‌ ଇୟେଞ୍ଜି, ଆରି ଜିସୁନ୍‌ ଜିରୁସାଲମଲୋଙନ୍‌ ଇନିଜି ଲୁମେନ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଆନିଞ୍ଜି ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଗାଲିଲିନ୍‌ କାନ୍ନା ଗଡ଼ାନ୍‌ ୟର୍ରନେ । ଆମ୍ମୁଙ୍‌ ତେତ୍ତେ ଆନିନ୍‌ ଡାଆନ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ଗବ୍‌ଡେଲେନ୍‌ । ଆରି ତେତ୍ତେ ରାଜାସିଂଲୋଙନ୍‌ ଆକ୍ରାବ୍ବାଡ଼ାତନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ କପର୍ନାଉମ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ବମ୍ୱମ୍‌ଲନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ଜିସୁନ୍‌ ଜିଉଦାନ୍‌ ସିଲଡ୍‌ ଗାଲିଲିନ୍‌ ଜିର୍ରାୟ୍‌ ଗାମ୍‌ଲେ ଆରମ୍‌ଡଙେନ୍‌ ତି ମନ୍‌ରାନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟେନ୍‌ । ଆରବୁଗୋ ଆଡ୍ରକୋଏନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ମନବ୍‌ନଙ୍‌ବାନ୍‌ କପର୍ନାଉମନ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେ । ");
INSERT INTO juy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅରମ୍ମଡନ୍‌ ଡ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଏଃଗିୟ୍‌ଲୋ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଆଙ୍ଗାଜନଙ୍‌ ଏଃଡ୍ଡର୍ନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ତି ରାଜାସିଂଲୋଙନ୍‌ ଆକ୍ରାବ୍ବାଡ଼ାତନ୍‌ ଆ ମନ୍‌ରା ଗାମେନ୍‌, “ଏ ପ୍ରବୁ, ପସିୟ୍‌ଞେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ରବୁଏନ୍‌ ଆଡିଡ୍‌ ଇଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜିରା, ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ଅମେଙେନ୍‌ନି ।” ତି ଆ ମନ୍‌ରା ଜିସୁନ୍‌ ଆ ବର୍ନେ ଡର୍ରନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ଆରି, ଆନିନ୍‌ ଜିରା ଜିରା ଆ କମ୍ୱାରିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ରବାଙ୍‌ଡାଲେ “ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ଅମେଙେନ୍‌” ଗାମ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ତିଆସନ୍‌ ଆଙ୍ଗାବେଡ଼ା ଆନିନ୍‌ ମନଙେନ୍‌ ଗାମ୍‌ଲେ ଆନିନ୍‌ କମ୍ୱାରିମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ରୁବନ୍‌ ସାତଟାରେ ଆନିନ୍‌ ଅସୁନ୍‌ ତଡେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ସିଲତ୍ତେ ଆପେୟନ୍‌ ମନ୍ନେଏନ୍‌ ଅଙ୍ଗାବେଡ଼ା ଜିସୁନ୍‌, “ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ଅମେଙେନ୍‌,” ଗାମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ତି ଆ ବନେଡ଼ା ମା ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ମନଙେନ୍‌ । ଆରି ଆନିନ୍‌ ଡ ଆସିଂମରଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ଜିସୁନ୍‌ ଜିଉଦାନ୍‌ ସିଲଡ୍‌ ଗାଲିଲିନ୍‌ ଜିର୍ରେ କେନ୍‌ଆତେ ବାଗୁତର ଇଙନ୍‌ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଲୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ପୁର୍ପୁର୍‌ ଅବୟ୍‌ ଡକୋଏନ୍‌ ତିଆସନ୍‌ ଜିସୁନ୍‌ ଜିରୁସାଲମନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ଜିରୁସାଲମଲୋଙନ୍‌ ମେଣ୍ଡା ଗରନ୍ନେନ୍‌ ଆ ତୁୟାୟ୍‌ଲୋଙ୍‌ ଅବୟ୍‌ ବଣ୍ଡାନ୍‌ ଡକୋ; ଏବ୍ରି ଲଙ୍‌ଲଙନ୍‌ ବାତ୍ତେ ତିଆତେ ବେତେସ୍‌ଦା ଗାମ୍‌ତଜି, ତି ଆ ବଣ୍ଡାଲୋଙ୍‌ ମନ୍‌ଲୟ୍‌ ପିଣ୍ଡାନ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ତି ଆ ପିଣ୍ଡାରେଙ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ବମ୍ୱମ୍‌ନେମରଞ୍ଜି, କାଡ଼ୁମରଞ୍ଜି, ସୋତ୍ତାମରଞ୍ଜି ଆରି କାନ୍ନିମରଞ୍ଜି ଡକୋଲଞ୍ଜି । ଆଙ୍ଗାସରଙ୍‌ ଡାଆନ୍‌ ପୟର୍‌ତେ ତିଆତେ ଆନିଞ୍ଜି ଜଗେଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଆଙ୍ଗିୟ୍‌ ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ବଣ୍ଡାଲୋଙନ୍‌ ପଡ୍‌ଲନ୍‌ ଡାଆନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ପବ୍‌ୟରେ, ଆରି ଡାଆନ୍‌ ଆପ୍ରୟର୍‌ତେନ୍‌ ଆଡିଡ୍‌ ଆନା ବଣ୍ଡାଲୋଙନ୍‌ ଆମ୍ମୁଙ୍‌ ଗନେନ୍‌, ଆମଙନ୍‌ ଇନିଜନଙ୍‌ ଆ ରୋଗ ଡକୋଏନ୍‌ ଜନଙ୍‌ଡେନ୍‌ ଆନିନ୍‌ ମନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ତେତ୍ତେ ଅଟତିରିସି ବର୍ସେଙ୍‌ ଜାୟ୍‌ ଅବୟ୍‌ ବମ୍ୱମ୍‌ନେମରନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ଜିସୁନ୍‌ ତି ଆଗଡ଼ାୟନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ଗିୟ୍‌ଲେ, ଗୋଗୋୟ୍‌ ବର୍ସେଙ୍‌ ଜାୟ୍‌ ଆ ବମ୍ୱମ୍‌ନେ ଗାମ୍‌ଲେ ଜନାଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଇନି ମନନଙନ୍‌ ସାୟ୍‌ତମ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ବମ୍ୱମ୍‌ନେମରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆଜ୍ଞା, ଡାଆନ୍‌ ଆପ୍ରୟର୍‌ତେନ୍‌ ଆଡିଡ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅମ୍ମ ବଣ୍ଡାନ୍‌ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ମନ୍‌ରାଞେଞ୍ଜି ଆନ୍ନିଙ୍‌ ତଡ୍‌; ଆରି, ଞେନ୍‌ ଜିରା ଜିରା ଆନ୍ନାମର୍‌ ଞେନ୍‌ ସିଲଡ୍‌ ଆମ୍ମୁଙ୍‌ ଇୟ୍‌ତେ ଗନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଡୋନା, ସପାନମ୍‌ ପାଙ୍‌ଲେ ତଙିୟ୍‌ନା ।” ");
INSERT INTO juy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ସିଲତ୍ତେମା ତି ମନ୍‌ରାନ୍‌ ମନଙେନ୍‌ ଆରି ଆ ସପାନ୍‌ ପାଙ୍‌ଲେ ତଙିୟ୍‌ଲନେ । ତି ଆ ଡିନ୍ନା ଲୋଲୋନେ ଡିନ୍ନା ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ତିଆସନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆମ୍ରନଙେନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ବରେଞ୍ଜି, “ଲଙେ ଲୋଲୋନେ ଡିନ୍ନା, ତିଆସନ୍‌ ଆମନ୍‌ ସପାନ୍‌ ବୋୟ୍‌ଲେ ଆପ୍ରାଙ୍‌ତେନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଆଲ୍ଲେତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ବନ୍‌ଡ ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅଙ୍ଗା ମନ୍‌ରା ଞେନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲିଁୟ୍‌, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବର୍ରିଁୟ୍‌, ସପାନମ୍‌ ପାଙ୍‌ଲେ ତଙିୟ୍‌ନା ।” ");
INSERT INTO juy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅଙ୍ଗା ମନ୍‌ରା ସପାନମ୍‌ ପାଙ୍‌ଲେ ତଙିୟ୍‌ନା ଗାମ୍‌ଲେ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ରମ୍‌, ଆନିନ୍‌ ଆନା ?” ");
INSERT INTO juy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ବନ୍‌ଡ, ଆନିନ୍‌ ଆନା, ତି ଆମ୍ରନଙେନ୍‌ ଆ ମନ୍‌ରା ଅଃଜ୍ଜନାଲୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତେତ୍ତେ ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଡକୋଏଞ୍ଜି, ଆରି ଜିସୁନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ତିକ୍କି ଜିସୁନ୍‌ ଡ ତି ଆମ୍ରନଙେନ୍‌ ଆ ମନ୍‌ରା ସରେବାସିଂଲୋଙନ୍‌ ଅଲ୍‌ରବାଙେଞ୍ଜି, ତେତ୍ତେ ଜିସୁନ୍‌ ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଗିଜା, ଆମନ୍‌ ମନଙ୍‌ଲମ୍‌, ଆରି ଇର୍ସେନ୍‌ ଲୁମ୍‌ଡଙ୍‌, ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ଆମନ୍‌ ଆରି ଗୋଗୋୟ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ତି ଆ ମନ୍‌ରା ଜିର୍ରେ, ଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙେନ୍‌, ଆନିନ୍‌ ଜିସୁନ୍‌ ଗାମ୍‌ଲେ ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଆମ୍ରବ୍‌ନଙେନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଡଣ୍ଡାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆପେୟ୍‌ଞେନ୍‌ ଆଏଡ଼ର୍‌ କାବ୍ବାଡ଼ାତନ୍‌, ଆରି ଞେନ୍‌ ନିୟ୍‌ ଲୁମ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","କେନ୍‌ ଆସନ୍‌ ଜିଉଦିମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଆରାଲ୍ଲେଏନ୍‌ ତୁମ୍‌ ତଡ୍‌, ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଗାମ୍‌ଲେ ଆନିନ୍‌ଡମ୍‌ ଇସ୍ୱରନ୍‌ ସରିନ୍‌ ଅବ୍‌ଜତାଲନେ । ");
INSERT INTO juy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଇନ୍ନିଙ୍‌ ଲୁମ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ, ଆପେୟନ୍‌ ଅଙ୍ଗାତେ ଲୁମ୍‌ତେ ତିଆତେ ମା ଗିୟ୍‌ଲେ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଲୁମ୍‌ତେ । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆପେୟନ୍‌ ଅଙ୍ଗାତେ ଲୁମ୍‌ତେ, ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ତିଆତେ ମା ଲୁମ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆପେୟନ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ, ଆରି ଆପେୟନ୍‌ ଇନିଜି ଲୁମ୍‌ତେ, ଆନିନ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଅବ୍‌ତୁୟ୍‌ତେ, ଆରି କେନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ସୋଡ଼ା କାବ୍ବାଡ଼ାଞ୍ଜି ଲନୁମନ୍‌ ଆସନ୍‌ ଆପେୟନ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଅବ୍‌ତୁୟ୍‌ତେ, ଆରି ଆମ୍ୱେଞ୍ଜି ସାନ୍ନି ଡେତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ଆପେୟନ୍‌ ଏଙ୍ଗାଲେ ଆରବୁମରଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଡୋଲେ ଅବ୍‌ମେଙ୍‌ତଜି, ତି ଅନ୍ତମ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ନିୟ୍‌ ଆନା ଲଡୟ୍‌ତେ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ମେଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ଆପେୟନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ପନ୍‌ସୁଆତିଏ, ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ସନୋଡ଼ାନେନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଏଙ୍ଗାଲେ ମନାନ୍ନେନ୍‌ ଡେତେ, ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ଅଡ଼୍‌କୋଞ୍ଜି ମାନ୍ନେତଜି । ଆନା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଅଃମ୍ମାନ୍ନେଏ, ଆନିନ୍‌ଆଡଙ୍‌ ଆରାପ୍ପାୟ୍‌ଲାଞନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଆନିନ୍‌ ଆଃମ୍ମାନ୍ନେଏ ।” ");
INSERT INTO juy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନା ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ଆଡଙ୍‌ ଡର୍ତନେ, ଆନିନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞାଙେନ୍‌, ଆନିନ୍‌ ଆସନ୍‌ ପନ୍‌ସୁଆତିନ୍‌ ଅଃଡ୍ଡେଏ, ଆର୍ପାୟ୍‌ ରନବୁନ୍‌ ପଡ୍‌ଲେ ଅନମେଙ୍‌ଲୋଙନ୍‌ ଗନେନ୍‌ନି । ");
INSERT INTO juy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ଆରି ନମି ନିୟ୍‌ ଅଡ଼ୋଲାୟ୍‌ନି, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆରବୁମରଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଆ ସର୍ରଙ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି ଆରି ଆନାଜି ଅମ୍‌ଡଙ୍‌ତଜି, ତିଆଡିଡ୍‌ ଆନିଞ୍ଜି ଅମେଙ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆପେୟନ୍‌ ଏଙ୍ଗାଲେ ଅନମେଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ସନୋଡ଼ାନେନ୍‌ ଡକୋ, ଏତ୍ତେଲେ ଅନମେଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ସନୋଡ଼ାନେନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ଆରି, ଆନିନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଡେଏନ୍‌, ତିଆସନ୍‌ ଆପେୟନ୍‌ ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ସନୋଡ଼ାନେନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","କେନ୍‌ ଆସନ୍‌ ସାନ୍ନି ଡେଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ତିଆଡିଡ୍‌ ଆରବୁମରଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆ ସର୍ରଙନ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି, ");
INSERT INTO juy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ମସାନ୍ନିନ୍‌ ସିଲଡ୍‌ ଡୋଲନ୍‌ ଜିର୍ତାଜି, ଆରି ଆନାଜି ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲୁମେଞ୍ଜି, ଆନିଞ୍ଜି ୟର୍ମେଙ୍‌ଲେ ଡୋଲନ୍‌ ଅନମେଙନ୍‌ ଞାଙ୍‌ତଜି, ଆରି ଆନାଜି ଏର୍‌ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲୁମେଞ୍ଜି, ଆନିଞ୍ଜି ଡୋଲନ୍‌ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ଞେନ୍‌ ସନୋଡ଼ାଞେନ୍‌ ବାତ୍ତେ ଇନ୍ନିଙ୍‌ ଲୁମ୍‌ଲେ ଅଃର୍ରପ୍ତିଆୟ୍‌, ଇସ୍ୱରନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଙ୍ଗାଲେ ବାଁୟ୍‌ତିଁୟ୍‌, ଞେନ୍‌ ଏତ୍ତେଲେ ପନ୍‌ସୁଆତିତାୟ୍‌, ଆରି ପନ୍‌ସୁଆତିଞେନ୍‌ ଆଜାଡ଼ିନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ସୁମ୍‌ଞେନ୍‌ ବାତ୍ତେ ଲନୁମ୍‌ନେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଅଃନ୍ନେର୍ରାୟ୍‌ ଅଃଗୋୟ୍‌ଲାୟ୍‌, ଆର୍ପାୟ୍‌, ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ ତୁମ୍‌ ଲନୁମ୍‌ନେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଏର୍‌ତାୟ୍‌ ଗୋୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ଡନେଲୋଙ୍‌ଞେନ୍‌ ଞେନ୍‌ଡମ୍‌ ସାକିନ୍‌ ତିୟ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ଆଜାଡ଼ିନ୍‌ ଗାମ୍‌ଲେ ଅଃଜ୍ଜନାଲଙ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ବନ୍‌ଡ ଆରି ଅବୟ୍‌ନେ ଡନେଲୋଙ୍‌ଞେନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ, ଆରି ବର୍ନେଞେନ୍‌ ଆନିନ୍‌ ଅଙ୍ଗାତେ ସାକିନ୍‌ ତିୟ୍‌ତେ, ତିଆତେ ଆଜାଡ଼ିନ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ଜନା । ");
INSERT INTO juy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ଆମ୍ୱେଞ୍ଜି ଜନନ୍‌ ଆମଙ୍‌ ମନ୍‌ରାନ୍‌ ଏଆପ୍ପାୟେନ୍‌ ଆରି ଆନିନ୍‌ ଆଜାଡ଼ିନ୍‌ ଆ ଡନେଲୋଙ୍‌ ସାକିନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ବନ୍‌ଡ ଞେନ୍‌ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ସାକିନ୍‌ ଅଃଜ୍ଜାଆୟ୍‌, ଆର୍ପାୟ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅନୁରନ୍‌ ଏଞାଙ୍‌ତେ, ତିଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ ବର୍ତନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଜନନ୍‌ ଆଡୁଡୁନ୍‌ ଆରି ଆତର୍‌ତରନ୍‌ ଆ ପିଙ୍କ ଅନ୍ତମ୍‌ ଡକୋଏନ୍‌, ଆରି ଆମ୍ୱେଞ୍ଜି ଅସୋୟ୍‌ ଡିନ୍ନା ଆ ସନାଆରନ୍‌ ବାତ୍ତେ ସର୍ଡାନେନ୍‌ ଆସନ୍‌ ଲଡୟ୍‌ଲବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ଡନେଲୋଙ୍‌ଞେନ୍‌ ଜନନ୍‌ ଆତ୍ରିଏନ୍‌ ଆ ସାକି ସିଲଡ୍‌ ଆରି ଅବୟ୍‌ ସୋଡ଼ା ସାକିନ୍‌ ଡକୋ । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନିଜି ଇନିଜି ଆ କାବ୍ବାଡ଼ା ଲୁମ୍‌ଲେ ଅନବ୍‌ସୁଜ୍ଜେନ୍‌ ଆସନ୍‌ ଆପେୟନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ତିଆତେଜି ଞେନ୍‌ ଲୁମ୍‌ତାୟ୍‌, ଆରି ଆପେୟନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ଗାମ୍‌ଲେ ତିଆତେଜି ମା ଡନେଲୋଙ୍‌ଞେନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆପେୟନ୍‌ ନିୟ୍‌ ଞେନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ । ଆମ୍ୱେଞ୍ଜି ଆ ସର୍ରଙନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏଅମ୍‌ଡଙେ ଆରି ଆ ମୁକ୍କାନ୍‌ ନିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏଗିଜେ । ");
INSERT INTO juy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ଆରି ଆ ବର୍ନେନ୍‌ ଉଗର୍‌ଲୋଙ୍‌ବେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏଡକ୍କୋଏ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆନାଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଃଡ୍ଡର୍ନେ । ");
INSERT INTO juy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଏଞାଙ୍‌ତାୟ୍‌ ଅବ୍‌ଡିସୟ୍‌ଲେ, ଆମ୍ୱେଞ୍ଜି ତିଆତେ ଏପଡ଼େତନେ, ଆରି ତି ଆ ଡରମ୍ମ ସାସ୍ତ୍ର ଞେନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଅନମେଙନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଅନିୟନ୍‌ ଅଃଲ୍ଲଡୟ୍‌ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ଞେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଅଃସାଜାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଗୋ ଆ ମନ୍‌ରାଜି ତିଆତେ ଞେନ୍‌ ଜନା, ଆରି ଉଗର୍‌ଲୋଙ୍‌ବେନ୍‌ ଇସ୍ୱରନ୍‌ ଆସନ୍‌ ଡନୁଙ୍‌ୟମ୍‌ ଅବୟ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଇୟ୍‌ଲାୟ୍‌, ଆରି ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଃଜ୍ଜାଇଁୟ୍‌, ଆନ୍ନାମର୍‌ ଅବୟ୍‌ନେ ଆନିନ୍‌ଡମ୍‌ ଆଞୁମ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଏଜାତେ । ");
INSERT INTO juy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ଆମ୍ୱେଞ୍ଜି ତର୍ଡମ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଏସାୟ୍‌ତେ, ବନ୍‌ଡ ଆବୟଡମ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଏଃସାଜେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଏଙ୍ଗାଡାଲେ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଡର୍ତନେ ? ");
INSERT INTO juy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆ ମୁକ୍କାବା ବିରୁଦଲୋଙ୍‌ବେନ୍‌ କାୟ୍‌କାୟ୍‌ତାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ଏନ୍ନେଲେ ଏବ୍‌ଡିସୟ୍‌ଡଙ୍‌ । ବନ୍‌ଡ ଅଙ୍ଗା ମୋସା ଆମଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଇଙ୍‌ଡର୍ରନେ ଆନିନ୍‌ ମା ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଡୋସାତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ଆମ୍ୱେଞ୍ଜି ମୋସାନ୍‌ଆଡଙ୍‌ ଏଡର୍ରନ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଡର୍ତନ୍‌ ବନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ବର୍ନେଞେନ୍‌ ଇଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ବନ୍‌ଡ ମୋସାନ୍‌ ଅଙ୍ଗାତେ ଇଡେନ୍‌ ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଏଃଡ୍ଡର୍ରନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ବର୍ନେଞେନ୍‌ ଆରି ଏଙ୍ଗାଲେ ଏଡର୍ତନେ ?” ");
INSERT INTO juy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","କେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଗାଲିଲି ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌, ଆଗ୍ରାମ୍‌ଗାମ୍‌ ତିବିରିଆ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ଆରି ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌, ଜିସୁନ୍‌ ଆ ବୋର୍ସାନ୍‌ ବାତ୍ତେ ବମ୍ୱମ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଆମ୍ରବ୍‌ନଙେନ୍‌ ଆନିଞ୍ଜି ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ତୋଣ୍ଡୋ ବରୁନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲେ ତଙ୍କୁମେଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ତିଆଡିଡ୍‌ ଜିଉଦିମରଞ୍ଜି ଆନେଲାୟ୍‌ପୁର୍‌ ତୁୟାଲେ ପାଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ଆରି ଜିସୁନ୍‌ ଆଙାଙ୍‌ଡାଲେ ଆଗ୍ରିଜେନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙନ୍‌ ଇୟ୍‌ତାଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ପିଲିପନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କେନ୍‌ ଡିୟ୍‌ନେ ମନ୍‌ରାଞ୍ଜି ଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ରୁଟିନ୍‌ ଞିଲେ ପାଙ୍‌ଲେ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ଗାଗାନେନ୍‌ ତିୟ୍‌ବୋଜି ?” ");
INSERT INTO juy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ବନ୍‌ଡ ପିଲିପନ୍‌ଆଡଙ୍‌ ମନାଲ୍‌ମାଲନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ କେନ୍‌ଆତେ ବର୍ରନେ । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଇନି ଲୁମ୍‌ତେ ତିଆତେ ଆନିନ୍‌ ଜନା । ");
INSERT INTO juy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ପିଲିପନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅର୍ଜିଡ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ବାଗୁସଅ ଡିନାରି ଆ ରୁଟି ସରି ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌, ସିମନନ୍‌ ଆ ବୋଞାଙ୍‌ ଆନ୍ଦ୍ରିଅନ୍‌ ଗାମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ତେନ୍ନେ ଅବୟ୍‌ ଓବ୍ବାସିଜନ୍‌ ଡକୋ, ଆମଙନ୍‌ ଗମ୍ମନ୍‌ ବାତ୍ତେ ଆତୁବ୍‌ତୁବନ୍‌ ଆ ରୁଟି ମନ୍‌ଲୟ୍‌ ଆରି ବାଗୁ ଆଗାୟ୍‌ଗାୟ୍‌ ଅୟନ୍‌ ଡକୋ । ବନ୍‌ଡ ଡିୟ୍‌ନେ ମନ୍‌ରା ଆସନ୍‌ ତିଆତେ ଏଙ୍ଗାଲେ ସଡ଼ିତୁବେଜି !” ");
INSERT INTO juy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ତଙ୍କୁମ୍‌ବାଜି ।” ତି ଆ ପଡ଼ିଆଲୋଙ୍‌ ଗୋଗୋୟ୍‌ ଅଗାବନ୍‌ ଡକୋଏନ୍‌, ତିଆସନ୍‌ ତେତ୍ତେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ତଙ୍କୁମେଞ୍ଜି, ତେତ୍ତେ ମନ୍‌ଲୟ୍‌ ଅଜାର ଓବ୍ବାମରଞ୍ଜି ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ତି ରୁଟିନ୍‌ ଞମ୍‌ଲେ ସନେନ୍‌ସେନ୍‌ ତିୟ୍‌ଲେ ଆତଙ୍କୁମନ୍‌ ଆ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବନ୍ତାଲେ ତିୟେଞ୍ଜି, ତିଅନ୍ତମ୍‌ ଅୟନ୍‌ ନିୟ୍‌ ବନ୍ତାଏଞ୍ଜି, ଆନିଞ୍ଜି ଡିଅଙ୍ଗା ଜୋମେଞ୍ଜି, ଡିୟ୍‌ତେନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ଆରି, ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆବ୍ରୋଓଏଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଇନ୍ନିଙ୍‌ ମୋସ୍ସାଡଙେ ତଡ୍‌, ତିଆସନ୍‌ ଆର୍‌ଲାଗାଏନ୍‌ ଆ ରୁଟିଜି ଡକ୍କୋବା ।” ");
INSERT INTO juy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ମନ୍‌ରାଞ୍ଜି ଆଜ୍ରୋମେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଗମ୍ମନ୍‌ ବାତ୍ତେ ଆତୁବ୍‌ତୁବନ୍‌ ତି ମନ୍‌ଲୟ୍‌ ରୁଟିଲୋଙନ୍‌ ସିଲଡ୍‌ ଡିଅଙ୍ଗା ରୁଟିନ୍‌ ଲାଗାଏନ୍‌, ତି ଆରେବ୍‌ରେବ୍‌ ଆ ରୁଟିଜି ଆନିଞ୍ଜି ବାର ଗୁରୁଲ୍ଲି ବବ୍‌ରିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ଜିସୁନ୍‌ କେନ୍‌ ଆ ସାନ୍ନି କାବ୍ବାଡ଼ା ଆର୍‌ଲୁମେନ୍‌ଆତେ ଗିୟ୍‌ଲେ, ତେତ୍ତେ ଆଡ୍ରକୋଏଞ୍ଜି ଆ ମନ୍‌ରାଜି ଗାମେଞ୍ଜି, “ଅଙ୍ଗା ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ପୁର୍ତିନ୍‌ ଇୟ୍‌ତାୟ୍‌ ବନ୍‌, ତିଆତେ ଆଜାଡ଼ିଡମ୍‌ କେନ୍‌ଆନିନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବଡଗାଁୟ୍‌ ଅନବ୍‌ରାଜାନ୍‌ ଆସନ୍‌ ଏର୍‌ତଜି ଗୋୟ୍‌ତଜି ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଜନାଡାଲେ, ଆନିନ୍‌ ଆନ୍ନାଡାଲନ୍‌ ଆତିନ୍‌ସଜନ୍‌ ତୋଣ୍ଡୋ ବରୁନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ତି ଆ ଡିନ୍ନା ଆସ୍ରାଲ୍ଲୁମେନ୍‌ ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଜିରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","କି ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ କପର୍ନାଉମ୍‌ ଗଡ଼ାନ୍‌ ଜିରେଞ୍ଜି । ତିଆଡିଡ୍‌ ଲୋଙଡ୍‌ଲେ ପାଙେନ୍‌, ଆରି ଜିସୁନ୍‌ ତି ଜାୟ୍‌ ଆମଙଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ଜିରାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ତିଆଡିଡ୍‌ ଆକ୍ରାନ୍‌ ରିଙ୍ଗେଏନ୍‌, ତିଆସନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଅଡ୍ଡୋୟ୍‌ଡାନ୍‌ ଡୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ଞଙ୍‌ନେମରଞ୍ଜି ଅମ୍ମ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ମନ୍‌ଲୟ୍‌ ଅଡ଼େ ତୁଡ୍ରୁ କିଲୋମିଟର୍‌ ଆଜିର୍ରେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ତୋଣ୍ଡୋ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ତଙିୟ୍‌ଡାଲନ୍‌ ଆଜିର୍ରାଞନ୍‌ ଆନିଞ୍ଜି ଗିଜେଞ୍ଜି । ତିଆସନ୍‌ ଆନିଞ୍ଜି ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ଆତେ ଞେନ୍‌, ବତଙ୍‌ଡଙ୍‌ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଅନୋରୋଙନ୍‌ ସାଜେଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ଅଙ୍ଗାଲୋଙ୍‌ ଇୟେଞ୍ଜି, ତେତ୍ତେ ଅବ୍‌ତାଡ଼ନ୍‌ ତୁଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ତେତ୍ତେ ଆବୟନ୍‌ ଡୋଙ୍ଗାନ୍‌ ଡକୋଏନ୍‌, ଞଙ୍‌ନେମରଞ୍ଜି ତୁମ୍‌ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ଅମ୍ମ ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଜିରେଞ୍ଜି, ଜିସୁନ୍‌ଆଡଙ୍‌ ଆନିଞ୍ଜି ଅଃନ୍ନୋରୋଙ୍‌ଲଜି, ଗାମ୍‌ଲେ ତି ଆବାର୍ତାନ୍‌ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ମନ୍‌ରାଜି ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ଅଙ୍ଗାଲୋଙ୍‌ ପ୍ରବୁନ୍‌ ସନେନ୍‌ସେନନ୍‌ ଆତ୍ରିୟେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନିଞ୍ଜି ରୁଟିନ୍‌ ଜୋମେଞ୍ଜି, ତି ତେତ୍ତେ ତିବିରିଆ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ଡୋଙ୍ଗାଞ୍ଜି ଜିର୍ରାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ବନ୍‌ଡ ତେତ୍ତେ ଜିସୁନ୍‌ ମନ୍‌ରା ତଡ୍‌ କି ଆ ଞଙ୍‌ନେମରଞ୍ଜି ମନ୍‌ରାଜି ତଡ୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଆଜ୍ରନାଏଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଡୋଙ୍ଗାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ସାୟ୍‌ଲେ ସାୟ୍‌ଲେ କପର୍ନାଉମନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ଆରି, ତି ଆ ମନ୍‌ରାଜି ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରବାଙେଞ୍ଜି, ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଆମନ୍‌ ଆଙ୍ଗାବେଡ଼ା କେନ୍‌ ତେନ୍ନେ ଜିର୍ରାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଏଗ୍ରିଜେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏସାୟ୍‌ଡଙ୍‌ତିଁୟ୍‌, ତିଆସନ୍‌ ତଡ୍‌, ବନ୍‌ଡ ରୁଟିନ୍‌ ଜୋମ୍‌ଲେ ଆବ୍ରୋଓଲବେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏସାୟ୍‌ଡଙ୍‌ତିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ଆରଞିଡ୍‌ତେନ୍‌ ଆ ଜନୋମ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏକାବ୍ବାଡ଼ାଡଙ୍‌ନେ, ଆର୍ପାୟ୍‌ ଅଙ୍ଗା ଜନୋମ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ତନ୍‌ ତିଆତେ ଆସନ୍‌ କାବ୍ବାଡ଼ାନାବା । ତି ଆ ଜନୋମ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ତବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆତେ ଆସନ୍‌ ଆପେୟ୍‌ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ତିୟେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇସ୍ୱରନ୍‌ ଆରିଃସୁମ୍‌ତେନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଲୁମ୍‌ଲେ ଏରପ୍ତିଆୟ୍‌, ତିଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଇନି ଏଏଙ୍ଗାନାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇସ୍ୱରନ୍‌ ଆନାଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌, ଆମଙନ୍‌ ଡର୍ନାବା । କେନ୍‌ଆତେ ମା ଇସ୍ୱରନ୍‌ ଆରିଃସୁମ୍‌ତେନ୍‌ ଆ କାବ୍ବାଡ଼ା ।” ");
INSERT INTO juy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଅମଙ୍‌ନମ୍‌ ରପ୍ତି ଏଡର୍ନାୟ୍‌, ତିଆସନ୍‌ ଆମନ୍‌ ଇନି ଆ ସାନ୍ନି କାବ୍ବାଡ଼ା ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ତୁୟ୍‌ତଲେନ୍‌ ? ବର୍ନା ଇନି ଆମନ୍‌ ଲୁମ୍‌ଲେ ରପ୍ତିତେ ? ");
INSERT INTO juy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ମାନ୍ନାନ୍‌ ଜୋମେଞ୍ଜି, ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅନିଡଲନ୍‌ ଡକୋ, ‘ଗାଗାନେନ୍‌ ଆସନ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜନୋମନ୍‌ ତନିୟନ୍‌ ଡେଲୋ ।’” ");
INSERT INTO juy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ମୋସାନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଜନୋମନ୍‌ ଅଃତ୍ତିୟ୍‌ଲବେନ୍‌, ବନ୍‌ଡ ଆପେୟ୍‌ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଆଜାଡ଼ି ଜନୋମନ୍‌ ତିୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ଜନୋମ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଅନମେଙନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତିୟେଜି, ତିଆତେ ମା ଇସ୍ୱରନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ଜନୋମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ପ୍ରବୁ, ଆଏଡ଼ର୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ଜନୋମ୍‌ ତିୟ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ତି ଅନମେଙନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ଜନୋମ୍‌ ଞେନ୍‌ଡମ୍‌, ଆନା ଅମଙ୍‌ଞେନ୍‌ ଇୟ୍‌ତାୟ୍‌, ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ ଅଃଡ୍ଡୋଲୟ୍‌ଡାଏ, ଆନା ଅମଙ୍‌ଞେନ୍‌ ଡର୍ତନେ, ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ ଅଃନ୍ନିର୍ଗାଲ୍‌ଡାଏ । ");
INSERT INTO juy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଗିୟ୍‌ଲିଁୟ୍‌ ଜନଙ୍‌ଡେନ୍‌, ଏଃଡ୍ଡର୍ନେ । ");
INSERT INTO juy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ଆପେୟନ୍‌ ଡିଅଙ୍ଗା ମନ୍‌ରାଜି ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ତିଁୟ୍‌, ଆନିଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ଇୟ୍‌ତାଜି, ଆରି ଆନା ଅମଙ୍‌ଞେନ୍‌ ଇୟ୍‌ତାୟ୍‌, ଏଙ୍ଗାଲେ ଜନଙ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନମ୍‌ରେଙାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ସୁମ୍‌ଞେନ୍‌ ବାତ୍ତେ ଲନୁମ୍‌ନେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅଃପ୍ପଡ୍‌ଲନାୟ୍‌, ଆର୍ପାୟ୍‌, ଆନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ ଲନୁମ୍‌ନେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ପଡ୍‌ଲନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ଆରି, ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆନାଜିଆଡଙ୍‌ ଞେନ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅନ୍ନବ୍‌ଆଡ଼ଆୟ୍‌, ଆର୍ପାୟ୍‌ ଅନଞିଡ୍‌ ଡିନ୍ନାଇଙନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ୟର୍ମେଙ୍‌ତାଜି କେନ୍‌ଆତେ ଆନିନ୍‌ ଇସ୍ସୁମ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନାଜି ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଆମଙନ୍‌ ଡର୍ତଞ୍ଜି, ଆନିଞ୍ଜି ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞାଙେତଜି, କେନ୍‌ଆତେ ଆପେୟ୍‌ଞେନ୍‌ ଇସ୍ସୁମ୍‌ତେ, ତିଆସନ୍‌ ଅନଞିଡ୍‌ ଡିନ୍ନାଇଙନ୍‌ ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ୟର୍ମେଙ୍‌ତାଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“ଞେନ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଆପ୍ରଡ୍‌ଲନାଞନ୍ ଆ ଜନୋମ୍‌,” ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଆବର୍ରନେନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବିରୁଦଡାଲେ ଡୋସେଲେ ବର୍ରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“କେନ୍‌ଆନିନ୍‌ ପଙ୍‌ ଜୋସେପନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିସୁନ୍‌ ତଡ୍‌ ? ଆରି କେନ୍‌ ଆୟୋଙନ୍‌ ଡ ଆପେୟନ୍‌ଆଡଙ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଜନା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଏଙ୍ଗାଡାଲେ ନମି ଆନିନ୍‌ ଞେନ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନାୟ୍‌ ଗାମ୍‌ଲେ ବର୍ତନେ ?” ");
INSERT INTO juy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଡନୋସେନ୍‌ ଅମ୍‌ରେଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆପେୟନ୍‌ ଆନାଆଡଙ୍‌ ଡିଙ୍‌ତେ, ଆନିନ୍‌ ତୁମ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଇୟ୍‌ଲେ ରପ୍ତିତାୟ୍‌, ଆରି ଅନଞିଡ୍‌ ଡିନ୍ନାଇଙନ୍‌ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ୟର୍ମେଙ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଇଡେଞ୍ଜି, ‘ଅଡ଼୍‌କୋଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଞନଙନ୍‌ ଞାଙ୍‌ତଜି ।’ ଆନା ଆପେୟନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଞଙ୍‌ତନେ, ଆନିନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଇୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ଆନ୍ନିଙ୍‌ ଡେନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଅଲ୍‌ଗିଜେ, ତି ଆଗ୍ରାମ୍‌ଗାମ୍‌ ଏତ୍ତେଲେ ତଡ୍‌, ଆନା ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଇୟ୍‌ଲାୟ୍‌, ଆନିନ୍‌ ତୁମ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଆଗିୟ୍‌ଗିୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନା ଡର୍ତନେ, ଆନିନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ଞେନ୍‌ ଅନମେଙନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ଜନୋମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ପୁର୍ବା ଜୋଜୋବେଞ୍ଜି ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ମାନ୍ନାନ୍‌ ଜୋମେଞ୍ଜି, ଜନଙ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ରବୁଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ବନ୍‌ଡ କେନ୍‌ ଆ ଜନୋମ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ପଡ୍‌ଲନାୟ୍‌, ତିଆସନ୍‌ ଆନା କେନ୍‌ ଆ ଜନୋମ୍‌ ଜୋମ୍‌ତେ ଆନିନ୍‌ ଅଃର୍ରବୁଏ । ");
INSERT INTO juy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ଞେନ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଆପ୍ରଡ୍‌ଲନାଞନ୍‌ ଅନମେଙନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ଜନୋମ୍‌, ଆନା କେନ୍‌ ଆ ଜନୋମ୍‌ ଜୋମ୍‌ତେ, ଆନିନ୍‌ ଆଏଡ଼ର୍‌ ଆନମେଙନ୍‌ ଡକୋତେ, ଓଓ, ଞେନ୍‌ ଅଙ୍ଗା ଜନୋମ୍‌ ତିୟ୍‌ତବେନ୍‌ ତିଆତେ ଜେଲୁଞେନ୍‌, ଞେନ୍‌ ତିଆତେ ମନ୍‌ରାଞ୍ଜି ଆନମେଙ୍‌ ଆସନ୍‌ ତିୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ସିଲତ୍ତେ ଜିଉଦିମରଞ୍ଜି ବରାବ୍‌ଡାଲେ ତର୍ଡମ୍‌ ଅଲ୍‌ଡୁଲ୍‌ବାୟ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଏଙ୍ଗାଡାଲେ ଆ ଜେଲୁନ୍‌ ଜୋମ୍‌ଜୋମନ୍‌ ଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ଲେ ରପ୍ତିଲଙ୍‌ନେ ?” ");
INSERT INTO juy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆ ଜେଲୁ ଏଃଜ୍ଜୋମ୍‌ଲୋ ଡେନ୍‌ ଆରି ଆ ମିଞାମନ୍‌ ଏଃଗାଲୋ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଅନମେଙନ୍‌ ଏଃଞାଙେ । ");
INSERT INTO juy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ଆନା ଜେଲୁଞେନ୍‌ ଜୋମ୍‌ତେ ଆରି ମିଞାମ୍‌ଞେନ୍‌ ଗାତେ, ଆନିନ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଞାଙ୍‌ତେ, ଆରି ଞେନ୍‌ ଅନଞିଡ୍‌ ଡିନ୍ନାଇଙନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ୟର୍ମେଙ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜେଲୁଞେନ୍‌ ଆଜାଡ଼ି ଜନୋମନ୍‌ ଆରି ମିଞାମ୍‌ଞେନ୍‌ ଆଜାଡ଼ି ଗନାଗାନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ଆନା ଜେଲୁଞେନ୍‌ ଜୋମ୍‌ତେ ଆରି ମିଞାମ୍‌ଞେନ୍‌ ଗାତେ, ଆନିନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡକୋତନେ, ଞେନ୍‌ ଆମଙନ୍‌ ଡକୋତନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ଆମେଙ୍‌ ଆପେୟନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ଆରି ଆପେୟନ୍‌ ଅମ୍ମେଲେ ଞେନ୍‌ ଆନମେଙନ୍‌ ଡକୋତନାୟ୍‌, ତିଅନ୍ତମ୍‌ ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଜୋମ୍‌ତିଁୟ୍‌, ଆନିନ୍‌ ନିୟ୍‌ ଞେନ୍‌ ଅମ୍ମେଲେ ଆନମେଙନ୍‌ ଡକୋତନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","କେନ୍‌ଆତେ ମା ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଆପ୍ରଡ୍‌ଲନାଞନ୍‌ ଆ ଜନୋମ୍‌, ଅଙ୍ଗା ଜନୋମ୍‌ ପୁର୍ବା ଜୋଜୋବେଞ୍ଜି ଜୋମେଞ୍ଜି ଜନଙ୍‌ଡେନ୍‌ ରବୁଏଞ୍ଜି, କେନ୍‌ଆତେ ତିଅନ୍ତମ୍‌ ତଡ୍‌; ଆନା କେନ୍‌ ଆ ଜନୋମ୍‌ ଜୋମ୍‌ତେ, ଆନିନ୍‌ ଆଏଡ଼ର୍‌ ଜାୟ୍‌ ଆନମେଙନ୍‌ ଡକୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ଜିସୁନ୍‌ କପର୍ନାଉମ୍‌ଲୋଙନ୍‌ ଅବୟ୍‌ ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ଞନଙନ୍‌ ଆତ୍ରିୟେନ୍‌ ଆଡିଡ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ତିଆସନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆସ୍ରଣ୍ଡୋଙେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ନେ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆ ଞନଙ୍‌ ମାଡ୍ଡ ଅରସୁଡାନ୍‌, ଆନା କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଲେ ରପ୍ତିଏ ?” ");
INSERT INTO juy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","କେନ୍‌ ଆ ବର୍ନେ ଆସନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆନ୍ନିଙ୍‌ ଇନ୍ନିଙ୍‌ ଅଃବ୍ବର୍ରଜି ଜନଙ୍‌ଡେନ୍‌, ଆ ସନଣ୍ଡୋଙ୍‌ମରଞ୍ଜି ଡୋସେତଜି ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଜନାଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ଆତେ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ବିମୁର୍ସେ ଡେତବେନ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମ୍ମୁଙ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋଲନ୍‌, ଆନିନ୍‌ ତେତ୍ତେ ୟର୍ରନ୍‌ ଡେନ୍‌, ଆରି ଆମ୍ୱେଞ୍ଜି ଏଗିଜେନ୍‌ ଡେନ୍‌, ଇନି ଏଗାମ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ଇସ୍ୱରନ୍‌ ଆ ପୁରାଡ଼ା ତୁମ୍‌ ଅନମେଙନ୍‌ ତିୟ୍‌ତେ, ମନ୍‌ରାନ୍‌ ଆ ବୋର୍ସା ଇନ୍ନିଙ୍‌ ଲୁମ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ତି ଅନମେଙନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ପୁରାଡ଼ା ଆମ୍ୱେଞ୍ଜି ଅମ୍‌ଲନ୍‌ ଏରପ୍ତିତେ, ତିଆସନ୍‌ ଞେନ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ବର୍ରବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ଅଃଡ୍ଡର୍ନେଜି ।” ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନାଜି ଅଃଡ୍ଡର୍ନେଜି ଆରି ଆନା ଆନିନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତେ, ତିଆତେ ଜିସୁନ୍‌ ଆମ୍ମୁଙ୍‌ ସିଲଡ୍‌ ଆଜନା । ");
INSERT INTO juy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ଆନିନ୍‌ ଆରି ବର୍ରନେ, “କେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆପେୟନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ତନିୟନ୍‌ ଅଃଡ୍ଡେଲୋ ଡେନ୍‌ ଆନ୍ନିଙ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଇୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ଜିସୁନ୍‌ ଏନ୍ନେଲେ ଆବର୍ରନେନ୍‌ ଆସନ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଆ ସନଣ୍ଡୋଙ୍‌ମରଞ୍ଜି ମଡ଼େଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆନିନ୍‌ ସରିନ୍‌ ଆରି ଅଃବ୍ବୁଲ୍ଲେଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ତିଆସନ୍‌ ଜିସୁନ୍‌ ବାରଜଣଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ପଙ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ମଡ଼େଙ୍‌ଲନ୍‌ ଜିର୍‌ଜିରନ୍‌ ଏସାୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ସିମନ୍‌ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ପ୍ରବୁ ଆନା ଆମଙ୍‌ ଏଜିରେ ? ଅମଙ୍‌ନମ୍‌ ଅନମେଙନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆ ବର୍ନେ ଡକୋ; ");
INSERT INTO juy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ଆରି ଆମନ୍‌ ତି ଇସ୍ୱରନ୍‌ ଆ ମଡ଼ିର୍‌ମର୍‌ ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଏଡର୍ତନାୟ୍‌ ଆରି ଏଜନାତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଇନି ବାରଜଣବେଞ୍ଜିଆଡଙ୍‌ ଅଃସେଡାଲବେନ୍‌ ପଙ୍‌ ? ଡେଲୋଜନଙ୍‌ଡେନ୍‌, ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ସନୁମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ଆନିନ୍‌ ଇସ୍କାରିତ ସିମନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିଉଦାନ୍‌ଆଡଙ୍‌ ସେଙ୍‌ଲେ କେନ୍‌ଆତେ ବର୍ରନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ବାରଜଣଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ, ଆରି ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ରୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଗାଲିଲି ଗଡ଼ାଲୋଙନ୍‌ ବୁଲ୍ଲେଲଲନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ଜିଉଦା ଡେସାଲୋଙନ୍‌ ବନୁଲ୍ଲେବାନ୍‌ ଅଃଲ୍ଲଡୟ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ଜିଉଦିମରଞ୍ଜି ଆ ପୁତ୍ତସିଂପୁର୍‌ ତୁୟାଲେ ପାଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ତିଆସନ୍‌ ଆ ବୋଞାଙଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ତେନ୍ନେ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିଉଦା ଡେସାନ୍‌ ଜିରା । ଆମନ୍‌ ଆର୍‌ଲୁମ୍‌ତେନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଅଡ଼୍‌କୋନ୍‌ ତେତ୍ତେ ନିୟ୍‌ ଇୟ୍‌ଲୁମା । ଆରି ତେତ୍ତେ ଆମନ୍‌ଆଡଙ୍‌ ଆସ୍ରଣ୍ଡୋଙ୍‌ତମଞ୍ଜି ଆ ଞଙ୍‌ନେମର୍‌ଜି ନିୟ୍‌ ତିଆତେ ଗିଜେତଜି । ");
INSERT INTO juy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ଆନା ଅବ୍‌ଗିୟ୍‌ତାଡମ୍‌ନେନ୍‌ ଆସନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ ଆ କାବ୍ବାଡ଼ାନ୍‌ ଆସସଲୋଙନ୍‌ ଇନ୍ନିଙ୍‌ ଅଃଲ୍ଲୁମେ । ଆମନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ଲେ ରପ୍ତିଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଡମ୍‌ନା ।” ");
INSERT INTO juy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆ ବୋଞାଙଞ୍ଜି ନିୟ୍‌ ଆମଙନ୍‌ ଅଃଡ୍ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ନମିନ୍ତାନ୍‌ ରୟଙ୍‌ଞେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଅଡ଼ୋଆୟ୍‌, ବନ୍‌ଡ ଡିତାନ୍‌ ରୟଙ୍‌ବେନ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ପୁର୍ତିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ଲେ ଅଃର୍ରପ୍ତିବେନ୍‌, ବନ୍‌ଡ ଞେନ୍‌ଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତିଁୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆ କାବ୍ବାଡ଼ାନ୍‌ ପରାନ୍‌ସାତ୍ତିନ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଆ ପୁର୍ପୁର୍‌ ଇୟ୍‌ବା, ଞେନ୍‌ କେନ୍‌ ଆ ପୁର୍ପୁର୍‌ ଅଃନ୍ନିୟେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ନମିନ୍ତାନ୍‌ ରୟଙ୍‌ଞେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଅଡ଼ୋଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ବର୍ରନ୍‌ ଗାଲିଲି ଗଡ଼ାଲୋଙନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ବନ୍‌ଡ ଆ ବୋଞାଙଞ୍ଜି ଆଜିର୍ରେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଜିସୁନ୍‌ ନିୟ୍‌ ଏର୍‌ନବ୍‌ରାଙ୍‌ଡାନେନ୍‌ ଅବ୍‌ସସଲନ୍‌ ପୁର୍ପୁର୍‌ବାନ୍‌ ଇୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ପୁର୍ପୁରିଙନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସାୟ୍‌ଲେ ସାୟ୍‌ଲେ, “ଆନିନ୍‌ ଅଡ଼େଙ୍ଗା ?” ଗାମ୍‌ଲେ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ଆରି, ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଜିସୁନ୍‌ ଆ ବର୍ନେ ଅବ୍‌ସସଲନ୍‌ କଡାଡ଼ିଲଞ୍ଜି, ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “ଆନିନ୍‌ ମନଙ୍‌ମର୍‌,” ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “ଇଜ୍ଜା, ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆନ୍ନା ତଙର୍‌ଗଡ୍‌ ଓରୋଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ବନ୍‌ଡ ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ବତଙ୍‌ଡାଲେ, ଜିସୁନ୍‌ ଆ ବର୍ନେ ଆନ୍ନିଙ୍‌ ଇନ୍ନିଙ୍‌ ଅବ୍‌ରାଙ୍‌ଡାଲନ୍‌ ଅଃବ୍ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ପୁର୍‌ପୁରନ୍‌ ଆତ୍ରୁଙାରେନ୍‌ ଆଡିଡ୍‌ ଜିସୁନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଜିର୍ରେ ଞନଙନ୍‌ ଇୟ୍‌ଲେ ତିୟେ । ");
INSERT INTO juy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ସିଲତ୍ତେ ଜିଉଦିମରଞ୍ଜି ସାନ୍ନିଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଏର୍‌ପନଡ଼େନେନ୍‌ ଏଙ୍ଗାଲେ ଡିୟ୍‌ନେ ପଡ଼େନେନ୍‌ ଗୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “କେନ୍‌ ଞନଙନ୍‌ ଞେନ୍‌ଆତେ ତଡ୍‌, କେନ୍‌ଆତେ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ଆନା ଇସ୍ୱରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ ଲନୁମ୍‌ନେନ୍‌ ସାୟ୍‌ତେ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ତରିୟ୍‌ତାଞନ୍‌ ଆ ଞନଙ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌, ଅଡ଼େ ଞେନ୍‌ଡମ୍‌ କେନ୍‌ଆତେ ବର୍ତନାୟ୍‌, ତିଆତେ ଆନିନ୍‌ ରପ୍ତି ଜନାତେ । ");
INSERT INTO juy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ଆନା ଆ ଇସ୍ସୁମ୍‌ଡମନ୍‌ ବାତ୍ତେ ବର୍ତନେ, ଆନିନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଆସନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ସାୟ୍‌ତେ, ବନ୍‌ଡ ଆନା ଆନାପ୍ପାୟ୍‌ମରନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ଗୁଗୁ ପନେମେଙନ୍‌ ଆସନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ ଆଜାଡ଼ିଡମ୍‌, ଆରି ଆମଙନ୍‌ ଇନ୍ନିଙ୍‌ ପାତ୍ୟାନ୍‌ ଅବୟ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ମୋସାନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଅଃତ୍ତିୟ୍‌ଲବେନ୍‌ ପଙ୍‌ ? ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଏଃଞଣ୍ଡ୍ରମ୍‌ନେ । ଆମ୍ୱେଞ୍ଜି ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଏସାୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ମନ୍‌ରାଞ୍ଜି ଜାଲଙେଞ୍ଜି, “ଆମନ୍‌ଆଡଙ୍‌ ବୁତନ୍‌ ସୁମ୍‌ଲମ୍‌, ଆନା ଆମନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ସାୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଅବୟ୍‌ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ଲାୟ୍‌, ଆରି ତିଆତେ ଗିୟ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ସାନ୍ନି ଡେଲବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","କେନ୍‌ ଆସନ୍‌ ମୋସାନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଗନବ୍‌ରେଡନ୍‌ ଆସନ୍‌ ବାଁୟ୍‌ଲବେନ୍‌, କେନ୍‌ଆତେ ମୋସାନ୍‌ ସିଲଡ୍‌ ତଡ୍‌, ବନ୍‌ଡ କେନ୍‌ଆତେ ପୁର୍ବା ଜୋଜୋବେଞ୍ଜି ଆମ୍ମୁଙ୍‌ ଉଲଞ୍ଜି, ଆରି ଆମ୍ୱେଞ୍ଜି ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ନିୟ୍‌ ଓବ୍ବାସିୟ୍‌ବେଞ୍ଜିଆଡଙ୍‌ ଏଗବ୍‌ରେଡ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଅବୟ୍‌ ଓବ୍ବାସିଜନ୍‌ଆଡଙ୍‌ ଗବ୍‌ରେଡ୍‌ଡାଲେ, ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଅଃନ୍ନାଲେଲବୋ ଡେନ୍‌, ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଞେନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ମରବ୍‌ନଙ୍‌ଲାଞନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ଏବବ୍‌ରାବ୍‌ତିଁୟ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ଡାଣ୍ଡନ୍‌ ଆଗ୍ରିୟ୍‌ତାତେନ୍‌ଆତେ ଗିୟ୍‌ଲେ ଏବିସାରଡଙ୍‌, ଡରମ୍ମ ବିସାରନ୍‌ ଲୁମ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ସିଲତ୍ତେ ଜିରୁସାଲମବାଜି ଲାଙ୍‌ଲେନ୍ନେ ଏନ୍ନେଲେ ବର୍ରଞ୍ଜି, “ଜିଉଦିମରଞ୍ଜି ଅଙ୍ଗା ମନ୍‌ରାଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏର୍‌ତଜି ଗୋୟ୍‌ତଜି, ତି ଆ ମନ୍‌ରା କେନ୍‌ଆନିନ୍‌ ତଡ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ଆରି ଗିୟ୍‌ବା ଆନିନ୍‌ ଅବ୍‌ରାଙ୍‌ଡାଲନ୍‌ କଡାଡ଼ିତନେ, ଆରି ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଅମ୍ମେଲେ ଅଃର୍ରପ୍ତିଏଜି । କେନ୍‌ଆନିନ୍‌ କ୍ରିସ୍ଟନ୍‌ ଗାମ୍‌ଲେ ଆଜାଡ଼ିଡମ୍‌ ଆନିଞ୍ଜି ଜନାଜି ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ବୟ୍‌ଲେଙ୍‌, କେନ୍‌ଆନିନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌, ତିଆତେ ଇନ୍‌ଲେଞ୍ଜି ଜନାତବୋ, ବନ୍‌ଡ କ୍ରିସ୍ଟନ୍‌ ଅଙ୍ଗାବେଡ଼ା ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ତନାୟ୍‌, ତିଆତେ ଆନ୍ନିଙ୍‌ ଅଃଜ୍ଜନାଏଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ସିଲତ୍ତେ ଜିସୁନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଞନଙନ୍‌ ତିୟା ତିୟା ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଞେନ୍‌ ଆନା, ଆରି ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌ ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଆଜାଡ଼ିଡମ୍‌ ଆଜନାଜି ପଙ୍‌ ? ସନୋଡ଼ାଡମ୍‌ଞେନ୍‌ ବୟନ୍‌ ଞେନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ଆନିନ୍‌ ଆଜାଡ଼ିନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଃଜ୍ଜନାଏ । ");
INSERT INTO juy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆଜନା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌, ଆରି ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ବନ୍‌ଡ ଆନ୍ନିଙ୍‌ଜା, ଜିସୁନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଆସିଞ୍ଜି ଡକ୍କୋଲେ ଅଃର୍ରପ୍ତିଲଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆ ଡିନ୍ନା ଜାୟ୍‌ ଅୟମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଅଡ଼ୋଆୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ବନ୍‌ଡ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ନେ ଜିସୁନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି କି ବର୍ରଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଡିଅଙ୍ଗା ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଲୁମେନ୍‌, କ୍ରିସ୍ଟନ୍‌ ଜିର୍ରେ କେନ୍‌ ସିଲଡ୍‌ ଆରି ଗୋଗୋୟ୍‌ ଇଆୟ୍‌ ଲୁମ୍‌ଲେ ରପ୍ତିଏ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ଜିସୁନ୍‌ ଆ ବର୍ନେ ମନ୍‌ରାଞ୍ଜି ଏନ୍ନେଲେ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ପାରୁସିଞ୍ଜି ଅମ୍‌ଡଙେଞ୍ଜି, ତିଆସନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ରାଓଡ଼ାଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ସିପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଆରି ବସନ୍ନେଃ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋତନାୟ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆମଙ୍‌ ଜିର୍ତେ । ");
INSERT INTO juy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏସାୟ୍‌ଡଙ୍‌ତିଁୟ୍‌, ବନ୍‌ଡ ଏଃର୍ରବାଙିଁୟ୍‌; ଆରି, ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋତନାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ତେତ୍ତେ ଇୟ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ସିଲତ୍ତେ ଜିଉଦିମରଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଅଡ଼େଙ୍ଗା ଇୟ୍‌ତେ ଡ, ଇନ୍‌ଲେଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅଃର୍ରବାଙ୍‌ବୋ ? କେନ୍‌ଆନିନ୍‌ ଇନି ଗ୍ରିକ୍‌ମରଞ୍ଜି ଆ ଗଡ଼ାରେଙ୍‌ ଆଡ୍ରକୋତନେଞ୍ଜି ଜିଉଦିମର୍‌ଲେଞ୍ଜି ଆମଙ୍‌ରେଙ୍‌ ଜିର୍ରେ, ଗ୍ରିକ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଜିର୍ତେ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ଆନିନ୍‌ ଗାମ୍‌ତେ, ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏସାୟ୍‌ଡଙ୍‌ତିଁୟ୍‌, ବନ୍‌ଡ ଏଃର୍ରବାଙିଁୟ୍‌; ଆରି, ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋତନାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ତେତ୍ତେ ଇୟ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ, କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ଇନି ?” ");
INSERT INTO juy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ଅନଞିଡ୍‌ ଡିନ୍ନାନ୍‌, ଆ ଗରାମ୍‌ଗାମନ୍‌ ପୁର୍‌ପୁରନ୍‌ ଆ ସୋଡ଼ା ଡିନ୍ନାନ୍‌, ଜିସୁନ୍‌ ତନଙ୍‌ଡାଲେ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଆନ୍ନିଙ୍‌ ଇର୍ଗାଲ୍‌ଡାଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଜିର୍ରେ ଆୟ୍‌ ଗାଡାନେତୋ । ");
INSERT INTO juy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅନିଡଲନ୍‌ ଡକୋ, ‘ଆନା ଅମଙ୍‌ଞେନ୍‌ ଡର୍ତନେ, ଆ ଉଗର୍‌ଲୋଙନ୍‌ ସିଲଡ୍‌ ଅନମେଙନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌ ଆଲଡା ପେତେ ।’” ");
INSERT INTO juy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ଜିସୁନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ, ଆନାଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି, ଆନିଞ୍ଜି ତିକ୍କି କେନ୍‌ ଆ ମଡ଼ିର୍‌ ପୁରାଡ଼ା ଞାଙେଞ୍ଜି । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଜାୟ୍‌ ଜିସୁନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଞାଙେ, ତିଆସନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ତନିୟନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଡେଏ । ");
INSERT INTO juy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ମନ୍‌ରାଞ୍ଜି କେନ୍‌ ଆ ଞନଙ୍‌ ଆରମ୍‌ଡଙେଞ୍ଜି, ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ କେନ୍‌ଆନିନ୍‌ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ କ୍ରିସ୍ଟନ୍‌ ।” ବନ୍‌ଡ ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “କ୍ରିସ୍ଟନ୍‌ ଇନି ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଅଲ୍‌ଡୁଙ୍‌ନାୟ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅନିଡଲନ୍‌ ଡକୋ, କ୍ରିସ୍ଟନ୍‌ ଦାଉଦନ୍‌ ଆ କେଜ୍ଜାଲୋଙ୍‌, ଆରି ଆନିନ୍‌ ଦାଉଦନ୍‌ ଆଡ୍ରକୋନେ ବେତଲିମ ଗଡ଼ାଲୋଙନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆ ଲତ୍ତେଙ୍‌ଲୋଙ୍‌ ମନ୍‌ରାଞ୍ଜି ତରଙ୍‌ଆନ୍ନା ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ଆରି, ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ଆନିନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ମାୟ୍‌ବର୍ରଞ୍ଜି, ବନ୍‌ଡ ଆନ୍ନିଙ୍‌ ଜିସୁନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଆସିଞ୍ଜି ଡକ୍କୋଲେ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ସିପ୍ପାୟଞ୍ଜି ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ଆମଙ୍‌ ୟର୍ରଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ସିପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନିବା ଆନିନ୍‌ଆଡଙ୍‌ ଏଃନ୍ନୋରୋଙ୍‌ଲାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ସିପ୍ପାୟଞ୍ଜି ଜାଲଙେଞ୍ଜି, “ତି ଆ ମନ୍‌ରା ଏତ୍ତେଲେ ବର୍ତନ୍‌ ଡ, ଆଙ୍ଗିୟ୍‌ ଆନ୍ନିଙ୍‌ ଏତ୍ତେଲେ ଅଣ୍ଡ୍ରଙ୍‌ ବର୍ନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ସିଲତ୍ତେ ପାରୁସିଞ୍ଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଉଲ୍ଲୁଲବେନ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌, ଅଡ଼େ ପାରୁସିଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଆମଙନ୍‌ ଡର୍ରଞ୍ଜି ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ବନ୍‌ଡ କେନ୍‌ ଆ ମନ୍‌ରାଜି ବନାଁୟ୍‌ବରନ୍‌ ଅଃଜ୍ଜନାଏଞ୍ଜି, ଆନିଞ୍ଜି ସନୟ୍‌ପନ୍‌ ଞାଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","କେନ୍‌ ଆ ଆମ୍ମୁଙ୍‌, ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ନିକଦିମ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ତଗଲନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଏର୍‌ନମ୍‌ଡଙନ୍‌, ଆରି ଆ ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଏର୍‌ଜନନାନ୍‌, ବନାଁୟ୍‌ବର୍‌ଲେନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଅବ୍‌ଡୋସାତେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମନ୍‌ ନିୟ୍‌ ଅବୟ୍‌ ଗାଲିଲିମର୍‌ ପଙ୍‌ ? ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଅନ୍ନିଙ୍‌ ଆ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଅଃଡ୍ଡୁଙ୍‌ନାୟ୍‌, କେନ୍‌ଆତେ ସାସ୍ତ୍ରନ୍‌ ପଡ଼େଲନ୍‌ ଗିଜା ।” ");
INSERT INTO juy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆସିଂ ଜିର୍ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ଜିସୁନ୍‌ ଜିତବୁରନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ତି ଆବାର୍ତାନ୍‌ ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ଆନିନ୍‌ ଆରି ସରେବାସିଙନ୍‌ ୟର୍ରନାୟ୍‌, ଆରି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମଙନ୍‌ ଆଜିର୍ରାଞଞ୍ଜି, ଆନିନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ଞନଙନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ଆରି ସାସ୍ତ୍ରିଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ଅବୟ୍‌ ଡାରିନେବଜନ୍‌ ଞମ୍‌ଲେ ପାଙ୍‌ଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ ମଡ୍ଡିନ୍‌ ତବ୍‌ନଙ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, କେନ୍‌ ଆଇବୟ୍‌ ଆଡ୍ରାରିଲନ୍‌ ଆଡିଡ୍‌ ଞନମନ୍‌ ଡେଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଏନ୍ନେଗନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ତିଡର୍‌ଡାଲେ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ମୋସାନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ବାଁୟ୍‌ଲଲେନ୍‌; ତିଆସନ୍‌ ଆମନ୍‌ ଇନି ଗାମ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ଡୋସାନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ଞାଙ୍‌ଲେ ରପ୍ତିଏଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ମାଲ୍‌ଲେ କେନ୍‌ ଆ ବର୍ନେ ବରେଞ୍ଜି । ବନ୍‌ଡ ଜିସୁନ୍‌ ଜାୟ୍‌ତାନ୍‌ ବରୁମ୍‌ଡାଲେ ଆ ଅଣ୍ଡେର୍‌ସିନ୍‌ ବାତ୍ତେ ଲବଲୋଙନ୍‌ ଇଡିଡ୍‌ଲଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ବନ୍‌ଡ ଆନିଞ୍ଜି ନମିନ୍‌ ନମିନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆବର୍ରେଞ୍ଜି, ଜିସୁନ୍‌ ତେକ୍କେବବ୍‌ଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜିଲୋଙ୍‌ ଆନା ଏର୍‌ଡୋସା, ଆନିନ୍‌ ଆମ୍ମୁଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତିଡରେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ଆରି ଆନିନ୍‌ ଜାୟ୍‌ତାନ୍‌ ବରୁମ୍‌ଡାଲେ ଲବଲୋଙନ୍‌ ଇଡିଡ୍‌ଲଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ତିଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନିଞ୍ଜି ସୋଡ଼ାମରଞ୍ଜି ସିଲଡ୍‌ ଉଲନ୍‌ ଅବୟ୍‌ନେ ଅବୟ୍‌ନେ ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆରି ଜିସୁନ୍‌ ଡ ମଡ୍ଡିନ୍‌ ଆତନଙନ୍‌ ଆଇବୟ୍‌ ତୁମ୍‌ ତେତ୍ତେ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ଆରି, ଜିସୁନ୍‌ ତେକ୍କେବବ୍‌ଲନ୍‌ ଆଗ୍ରିଜେନ୍‌ ଆନ୍ନିଙ୍‌ ତଡ୍‌, ତିଆସନ୍‌ ଆନିନ୍‌ ତି ଆଇମରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଆଇମର୍‌, ଆନିଞ୍ଜି ଅଡ଼େଙ୍ଗା ? ଆମନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ଡୋସାନ୍‌ ଆସନ୍‌ ଆନ୍ନିଙ୍‌ ତଡ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ଆନିନ୍‌ ଜାଲଙେନ୍‌, “ଆନ୍ନିଙ୍‌ ତଡ୍‌, ପ୍ରବୁ ।” ସିଲତ୍ତେ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ନିୟ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ଡୋସାଅମ୍‌, ଜିରା ଲଙେ ସିଲଡ୍‌ ଆରି ଇର୍ସେନ୍‌ ଲୁମ୍‌ଡଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ଜିସୁନ୍‌ ଆରି ପାରୁସିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ପୁର୍ତିନ୍‌ ଆ ସନାଆର୍‌, ଆନା ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ତିଁୟ୍‌, ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ଜା ଲୋଙଡ୍‌ଲୋଙନ୍‌ ଅଃବ୍ବୁଲ୍ଲେଏ, ଆର୍ପାୟ୍‌ ଅନମେଙନ୍‌ ଆ ସନାଆର୍‌ ଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ସିଲତ୍ତେ ପାରୁସିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମନ୍‌ଡମ୍‌ ଆମନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ, ସାକିନମ୍‌ ଆଜାଡ଼ିନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ଡମ୍‌ ସାକିନ୍‌ ତିୟ୍‌ଲାୟ୍‌ ଜନଙ୍‌ଡେନ୍‌ ସାକିଞେନ୍‌ ଆଜାଡ଼ିନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌ ଆରି ଅଙ୍ଗାଲୋଙ୍‌ ଜିର୍ତେ, ତିଆତେ ଞେନ୍‌ ଜନା । ବନ୍‌ଡ ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଜିର୍ତାୟ୍‌ ଅଡ଼େ ଅଙ୍ଗାଲୋଙ୍‌ ଜିର୍ତେ, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଜନାଜି ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ଆମ୍ୱେଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଅନ୍ତମ୍‌ ଏପନ୍‌ସୁଆତିତେ, ଞେନ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ପନ୍‌ସୁଆତିଆୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ବନ୍‌ଡ ଞେନ୍‌ ପନ୍‌ସୁଆତିଲାୟ୍‌ ଜନଙ୍‌ଡେନ୍‌, ପନ୍‌ସୁଆତିଞେନ୍‌ ଆଜାଡ଼ିନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ତିନ୍‌ସୟ୍‌ଞେନ୍‌ ତଡ୍‌, ବନ୍‌ଡ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆପେୟନ୍‌ ଞେନ୍‌ ସରିନ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ଆରି, ବାଗୁ ମନ୍‌ରା ଆ ସାକି ମାୟ୍‌ଲନ୍‌ ଡେନ୍‌, ଆନିଞ୍ଜି ଅଙ୍ଗାତେ ବର୍ତଞ୍ଜି ତିଆତେ ଆଜାଡ଼ିନ୍‌, କେନ୍‌ଆତେ ବନାଁୟ୍‌ବର୍‌ଲୋଙ୍‌ବେନ୍‌ ନିୟ୍‌ ଆଇଡିଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ଞେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ଡମ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତାୟ୍‌, ଆରି ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆପେୟନ୍‌ ନିୟ୍‌ ଞେନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆପେୟ୍‌ନମ୍‌ ଅଡ଼େଙ୍ଗା ?” ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଃଜ୍ଜନାଇଁୟ୍‌, ଆରି ଆପେୟ୍‌ଞେନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଏଃଜ୍ଜନାଏ; ଞେନ୍‌ଆଡଙ୍‌ ଏଜନାଲିଁୟ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଏଜନାତେ ବନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ଜିସୁନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଞନଙନ୍‌ ଆତ୍ରିୟେନ୍‌ ଆଡିଡ୍‌ ତନିୟ୍‌ତିୟ୍‌ କୁମ୍ପଡ଼ିଞ୍ଜି ଆଡ୍ରକ୍କୋତେଞ୍ଜି ଆସିଂଲୋଙ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ବର୍ରନେ, ବନ୍‌ଡ ଆନ୍ନିଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃଞମ୍‌ଲଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆ ଡିନ୍ନା ଜାୟ୍‌ ଅୟମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଅଡ଼ୋଆୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ଜିସୁନ୍‌ ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଜିର୍ତେ, ଆରି ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏସାୟ୍‌ଡଙ୍‌ତିଁୟ୍‌, ଆରି ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଇର୍ସେଲୋଙ୍‌ ରବୁତବେନ୍‌, ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଜିର୍ତେ, ଆମ୍ୱେଞ୍ଜି ତେତ୍ତେ ଇୟ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ତିଆସନ୍‌ ଜିଉଦିମରଞ୍ଜି ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ ଗାମ୍‌ତେ ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଜିର୍ତେ, ଆମ୍ୱେଞ୍ଜି ତେତ୍ତେ ଇୟ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ, କେନ୍‌ଆନିନ୍‌ ଇନି ଇୟ୍‌ତେ ରବ୍ବୁଡମ୍‌ନେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଜାୟ୍‌ତାନ୍‌ ସିଲଡ୍‌ ଏଡୁଙ୍‌ଲନାୟ୍‌, ବନ୍‌ଡ ଞେନ୍‌ ତୋଣ୍ଡୋନ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌; ଆମ୍ୱେଞ୍ଜି ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ଏଡୁଙ୍‌ଲନାୟ୍‌, ବନ୍‌ଡ ଞେନ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଇର୍ସେଲୋଙ୍‌ ରବୁତବେନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ‘ଞେନ୍‌ ତିଆନିନ୍‌’ କେନ୍‌ଆତେ ଆମ୍ୱେଞ୍ଜି ଏଃଡ୍ଡର୍ରନ୍‌ ଡେନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଇର୍ସେଲୋଙ୍‌ ରବୁତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଆମନ୍‌ ଆନା ?” ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ତି ଆ ବର୍ନେ ଞେନ୍‌ ଆମ୍ମୁଙ୍‌ ମା ସିଲଡ୍‌ ବର୍ରନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ବର୍ନେଲୋଙ୍‌ବେନ୍‌ ବର୍ନେନ୍‌ ଆସନ୍‌ ଆରି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ଡୋସାନ୍‌ ଆସନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଗୋଗୋୟ୍‌ ବର୍ନେନ୍‌ ଡକୋ । ବନ୍‌ଡ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆଜାଡ଼ିନ୍‌, ଆରି ଆମଙନ୍‌ ସିଲଡ୍‌ ଞେନ୍‌ ଅଙ୍ଗାତେ ଅମ୍‌ଡଙ୍‌ଲାୟ୍‌, ତିଆତେ ମା ଞେନ୍‌ ପୁର୍ତିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଜନାତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ଆପେୟନ୍‌ ଆ ବର୍ନେ ଜିସୁନ୍‌ ବର୍ରନେ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଗନ୍‌ଲୁଡ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଆଙ୍ଗା ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଏଅମ୍‌ଡାୟ୍‌ତେ, ତିଆଡିଡ୍‌ ଗନ୍‌ଲୁଡ୍‌ତବେନ୍‌, ଆଜାଡ଼ିଡମ୍‌ ‘ଞେନ୍‌ ତି ଆ ମନ୍‌ରା ।’ ଆରି ଞେନ୍‌ ସନୋଡ଼ାଞେନ୍‌ ବାତ୍ତେ ଇନ୍ନିଙ୍‌ ଅଃଲ୍ଲୁମାୟ୍‌, ଆର୍ପାୟ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅଙ୍ଗାତେ ଞନଙନ୍‌ ଞାଙ୍‌ଲାୟ୍‌ ତିଆତେ ତୁମ୍‌ ଞେନ୍‌ ବର୍ତନାୟ୍‌, ଗାମ୍‌ଲେ ତିଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଜନାତେ । ");
INSERT INTO juy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଞେନ୍‌ ସରିନ୍‌ ଡକୋ, ଆନିନ୍‌ ତିନ୍‌ସୟ୍‌ଞେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନମ୍‌ରେଙ୍‌ଲିଁୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଡିତାନ୍‌ ଞେନ୍‌ ଆନିନ୍‌ ଆର୍‌ଲଡୟ୍‌ତେନ୍‌ ଆ କାବ୍ବାଡ଼ା ତୁମ୍‌ ଲୁମ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ଜିସୁନ୍‌ ଆ ବର୍ନେଜି କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ, ଜବ୍ର ମନ୍‌ରା ଆମଙନ୍‌ ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଅଙ୍ଗା ଜିଉଦିଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଜିସୁନ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ବର୍ନେଞେନ୍‌ ଅନ୍ତମ୍‌ ଏଞଣ୍ଡ୍ରମ୍‌ଲନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଆମ୍ୱେଞ୍ଜି ଞଙ୍‌ନେମର୍‌ଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ଆରି ଆମ୍ୱେଞ୍ଜି ଆଜାଡ଼ିନ୍‌ ଏଜନାତେ, ତି ଆଜାଡ଼ି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଉର୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଅବ୍ରାମନ୍‌ ଆ କେଜ୍ଜା, ଆରି ଆଙ୍ଗିୟ୍‌ ଆନ୍ନିଙ୍‌ ଆ କମ୍ୱାରି ଅଣ୍ଡ୍ରଙ୍‌ ଏଡକୋନାୟ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଡ଼ୁର୍‌ତବେନ୍‌ ଗାମ୍‌ଲେ ଆମନ୍‌ ଏଙ୍ଗାଲେ ବର୍ତନେ ? କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ଇନି ?” ");
INSERT INTO juy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନା ଇର୍ସେନ୍‌ ଲୁମ୍‌ତେ, ଆନିନ୍‌ ଇର୍ସେନ୍‌ ଆ କମ୍ୱାରି । ");
INSERT INTO juy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","କମ୍ୱାରିମରନ୍‌ ଆଏଡ଼ର୍‌ ଅସିଙନ୍‌ ଅଃଡ୍ଡକୋନେ, ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆଏଡ଼ର୍‌ ଡକୋତନେ । ");
INSERT INTO juy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ତିଆସନ୍‌, ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଉର୍ରବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଡ଼ୁର୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ଆମ୍ୱେଞ୍ଜି ଅବ୍ରାମନ୍‌ ଆ କେଜ୍ଜା, ତିଆତେ ଞେନ୍‌ ଜନା, ବନ୍‌ଡ ଞନଙ୍‌ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଃଜ୍ଜାଏ, ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଏସାୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ଆପେୟ୍‌ଞେନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅଙ୍ଗାତେ ଞେନ୍‌ ଗିୟ୍‌ଲାୟ୍‌, ତିଆତେ ଅଡ଼୍‌କୋନ୍‌ ବର୍ତନାୟ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଆପେୟ୍‌ବେନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅଙ୍ଗାତେ ଏଅମ୍‌ଡଙେନ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଏଲୁମ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଅବ୍ରାମନ୍‌ ଆପେୟ୍‌ଲେନ୍‌ ।” ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଅବ୍ରାମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅବ୍ରାମନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଲୁମ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅରମ୍‌ଡଙ୍‌ଲାଞନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଜାଡ଼ିଜି ତୁମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାତବେନ୍‌, ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏଏର୍‌ତେ ଏଗୋୟ୍‌ତେ; ଅବ୍ରାମନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଆ କାବ୍ବାଡ଼ା ଅଃଲ୍ଲୁମ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ଆପେୟ୍‌ବେନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଆମ୍ୱେଞ୍ଜି ଏଲୁମ୍‌ତେ ।” ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ଡାରିନେଲୋଙନ୍‌ ସିଲଡ୍‌ ଜନମ୍ମୁ ଅଃଡ୍ଡେଲଲେନ୍‌, ଇସ୍ୱରନ୍‌ ତୁମ୍‌ ଆବୟନ୍‌ ଆପେୟ୍‌ଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇସ୍ୱରନ୍‌ ଆପେୟ୍‌ବେନ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌ ବନ୍‌; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଞେନ୍‌ ତେନ୍ନେ ଇୟ୍‌ଲାୟ୍‌; ସନୋଡ଼ାଞେନ୍‌ ବାତ୍ତେ ଞେନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ଇନିବା ବର୍ନେଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଃଗନ୍‌ଲୁଡ୍‌ବେନ୍‌ ? ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞନଙ୍‌ଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ଲେ ସଏଲେ ଏଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ଆପେୟ୍‌ବେନ୍‌ ସନୁମ୍‌, ଆମଙନ୍‌ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଡୁଙ୍‌ଲନାୟ୍‌, ଆପେୟ୍‌ବେନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ ଲନୁମ୍‌ନେନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଲଡୟ୍‌ତବେନ୍‌ । ଆନିନ୍‌ ପୁର୍ବାନ୍‌ମା ସମ୍ୱବ୍‌ମର୍‌, ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ଜା ଆଜାଡ଼ିନ୍‌ ଅଃଡ୍ଡନେଲୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମଙନ୍‌ ଆଜାଡ଼ିନ୍‌ ଅବୟ୍‌ ତଡ୍‌ । ଆଙ୍ଗା ଆନିନ୍‌ ପାତ୍ୟାନ୍‌ ବର୍ତନେ, ଆନିନ୍‌ଡମ୍‌ ତିଆତେ ବର୍ତନେ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ପାତ୍ୟାମର୍‌, ଆରି ଆନିନ୍‌ ପାତ୍ୟାମରଞ୍ଜି ଆ ବାପା । ");
INSERT INTO juy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ବନ୍‌ଡ ଞେନ୍‌ ଆଜାଡ଼ିନ୍‌ ବରର୍‌ତନାଞନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଃଡ୍ଡର୍ନେ । ");
INSERT INTO juy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ଅମଙ୍‌ଞେନ୍‌ ଇର୍ସେନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଆନା ସାକିନ୍‌ ତିୟ୍‌ଲେ ରପ୍ତିତେ ? ଞେନ୍‌ ଆଜାଡ଼ିନ୍‌ ବର୍ରନାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନିବା ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଃଡ୍ଡର୍ନେ ? ");
INSERT INTO juy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ଆନା ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌, ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ତେ; ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଏଃଡ୍ଡୁଙ୍‌ଲନାୟ୍‌, ତିଆସନ୍‌ ଏଃନ୍ନମ୍‌ଡଙେ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ଜିଉଦିମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମନ୍‌ ଅବୟ୍‌ ସମିରୋଣବାୟ୍‌ ଆରି ଆମନ୍‌ଆଡଙ୍‌ ବୁତନ୍‌ ଆସୁମ୍‌ସୁମ୍‌, ଇନ୍‌ଲେନ୍‌ କେନ୍‌ଆତେ ଆଜାଡ଼ିନ୍‌ ଏଃବ୍ବର୍ନାୟ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ବୁତନ୍‌ ଆସୁମ୍‌ସୁମ୍‌ ତଡ୍‌, ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ଆଡଙ୍‌ ମାନ୍ନେତାୟ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଃମ୍ମାନ୍ନେଇଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ଞେନ୍‌ ଆସନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଞେନ୍‌ ଅଃସାଜାୟ୍‌, ବନ୍‌ଡ ଆରି ଅବୟ୍‌ନେ ଡକୋ, ଆନିନ୍‌ କେନ୍‌ଆତେ ସାୟ୍‌ତେ, ଆରି ଡନେଲୋଙ୍‌ଞେନ୍‌ ଆନିନ୍‌ ପନ୍‌ସୁଆତିତେ । ");
INSERT INTO juy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନା ଞନଙ୍‌ଞେନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ତନେ, ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ଜା ଅଃର୍ରବୁଏ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ଜିଉଦିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ନମି ଇନ୍‌ଲେଞ୍ଜି ଏଜନାଲାୟ୍‌, ଆମନ୍‌ଆଡଙ୍‌ ବୁତନ୍‌ ସୁମ୍‌ଲମ୍‌, ଅବ୍ରାମନ୍‌ ଡ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ରବୁଏଞ୍ଜି, ଆରି ଆମନ୍‌ ଗାମ୍‌ତେ, ଆନା ଞନଙ୍‌ଞେନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ତନେ, ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ଜା ଅଃର୍ରବୁଏ । ");
INSERT INTO juy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ଆମନ୍‌ ଇନି ଆପେୟ୍‌ଲେନ୍‌ ଅବ୍ରାମନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ପଙ୍‌ ? ଆନିନ୍‌ ତ ରବୁଏନ୍‌, ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ନିୟ୍‌ ରବୁଏଞ୍ଜି, ଆମନ୍‌ଡମ୍‌ ଆନା ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଆସନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଞେନ୍‌ଡମ୍‌ ସାୟ୍‌ଲାୟ୍‌ ଡେନ୍‌, ତିଆତେ ଇନ୍ନିଙ୍‌ ବରାଁୟ୍‌ବାଁୟ୍‌ ତଡ୍‌; ବନ୍‌ଡ ଆନାଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରବେନ୍‌ ଏଗାମ୍‌ତେ, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଗୁଗୁତେ ଅବ୍‌ପେମେଙ୍‌ତେ, ଆନିନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ଆରି, ଆମ୍ୱେଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏଜନାଏ, ବନ୍‌ଡ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜନା । ଆରି ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜନା ତଡ୍‌ ଗାମ୍‌ଲାଞନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅନ୍ତମ୍‌ ଞେନ୍‌ ପାତ୍ୟାମର୍‌ ଡେତିଁୟ୍‌, ବନ୍‌ଡ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜନା, ଆରି ଆ ବର୍ନେନ୍‌ ଞେନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ତନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ଆପେୟ୍‌ବେନ୍‌ ଅବ୍ରାମନ୍‌ ଡିନ୍ନାଞେନ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଆସାଡାଲନ୍‌ ମଅଁୟ୍‌ଲନେ, ଆରି ଆନିନ୍‌ ତିଆତେ ଗିୟ୍‌ଲେ ସର୍ଡାଲନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ସିଲତ୍ତେ ଜିଉଦିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମନ୍‌ ତ ନମିନ୍ତାନ୍‌ ପଚାସ ବର୍ସେଙ୍‌ ନିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଡେଅମ୍‌, ଆମନ୍‌ ଇନି ଅବ୍ରାମନ୍‌ଆଡଙ୍‌ ଗିଜେନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଅବ୍ରାମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ କଡେଞ୍ଜି ଆ ଆମ୍ମୁଙ୍‌ ଞେନ୍‌ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ତନିଡନ୍‌ ଆସନ୍‌ ଅରେଙନ୍‌ ଞିଡବେଞ୍ଜି, ବନ୍‌ଡ ଜିସୁନ୍‌ ଏର୍‌ନବ୍‌ରାଙ୍‌ଡାନେନ୍‌ ସରେବାସିଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ଜିସୁନ୍‌ ତଙରନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ଅବୟ୍‌ ଆ କାଡ଼ୁମରନ୍‌ଆଡଙ୍‌ ଗିଜେନ୍‌; ତି ଆ ମନ୍‌ରା ଆ ଜନମ୍ମୁନ୍‌ ମା ସିଲଡ୍‌ ଆ କାଡ଼ୁ । ");
INSERT INTO juy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ଆରି, ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଆନା ଇର୍ସେନ୍‌ ଆର୍‌ଲୁମେନ୍‌, କେନ୍‌ଆନିନ୍‌ ଆକାଡ଼ୁନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେଲୋ ? କେନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଅଡ଼େ ଆପେୟନ୍‌ ଡ ଆୟୋଙନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ଜିସୁନ୍‌ ଗାମେନ୍‌, “କେନ୍‌ ଆପେୟନ୍‌ ଅଡ଼େ କେନ୍‌ ଆୟୋଙନ୍‌ ଇର୍ସେନ୍‌ ଅଃଲ୍ଲୁମ୍‌ଲଜି, ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆ ବୋର୍ସା କାବ୍ବାଡ଼ା ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ କେନ୍‌ ଆମଙନ୍‌ ଅଲ୍‌ଗିୟ୍‌ତାଏ, ତିଆସନ୍‌ ଏନ୍ନେଗୋ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ଆଡକୋୟୋଙ୍‌ ଇଙନ୍‌ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଇନ୍‌ଲେଞ୍ଜି ଲୁମ୍‌ତବୋ; ତଗଲନ୍‌ ଜିର୍ତାୟ୍‌, ତିଆଡିଡ୍‌ ଆନ୍ନିଙ୍‌ କାବ୍ବାଡ଼ାଲନ୍‌ ଅଃର୍ରପ୍ତିଏଜି । ");
INSERT INTO juy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ଞେନ୍‌ ଅଙ୍ଗା ଜାୟ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଡକୋ, ତି ଜାୟ୍‌ ଞେନ୍‌ ପୁର୍ତିନ୍‌ ଆ ସନାଆର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ଏନ୍ନେଲେ ବର୍ରନ୍‌, ଜିସୁନ୍‌ ଲବଲୋଙନ୍‌ ବିଜଲ୍‌ଡାଲେ ତି ଆ ବିଜଲ୍‌ ବାତ୍ତେ ଲବନ୍‌ ଆବ୍‌କାଡ୍ଡୋଏନ୍‌, ଆରି ତି ଆ କାଡ଼ୁମରନ୍‌ ବାଗୁନ୍‌ ଆ ତୋଣ୍ଡୋମଡ୍‌ଲୋଙ୍‌ କାଡ୍ଡୋନ୍‌ ଜଡ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“ଜିରା, ସିଲୋଅ, ବଣ୍ଡାଲୋଙନ୍‌ ଇୟ୍‌ନାମଡ୍‌ନା ।” ସିଲତ୍ତେ ଆନିନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲେ ଆମଡ୍‌ନେ, ଆରି ଆନିନ୍‌ ଗିୟ୍‌ଲେ ରପ୍ତିଏନ୍‌ କି ୟର୍ରନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ତିଆସନ୍‌ ଆ ତୟ୍‌ଲିସିଂମରଞ୍ଜି, ଆରି, ଆମ୍ମୁଙ୍‌ ଆନିନ୍‌ ଆବ୍ରେଡ୍‌ବେଡ୍‌ଲନ୍‌ ଆଡିଡ୍‌ ଆନାଜି ଗିଜେଞ୍ଜି, ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆ ମନ୍‌ରା ଇନି ତଙ୍କୁମ୍‌ଡାଲେ ଅଃବ୍ବେଡ୍‌ବେଡ୍‌ଲ୍ଲନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “ଓଓ ତି ଆନିନ୍‌,” ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “ଇଜ୍ଜା, କେନ୍‌ଆନିନ୍‌ ତି ଆନିନ୍‌ ଅନ୍ତମ୍‌ ଗିୟ୍‌ତାତେ ।” ବନ୍‌ଡ ଆନିନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ତି ଆ ମନ୍‌ରା ।” ");
INSERT INTO juy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଏଙ୍ଗାଲେ ଆମନ୍‌ ନମି ଗିୟ୍‌ଲେ ରପ୍ତିତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ଆନିନ୍‌ ବର୍ରନେ, “ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଜିସୁ ଗାମ୍‌ତଜି, ଆନିନ୍‌ ବିଜଲନ୍‌ ବାତ୍ତେ ଲବନ୍‌ ଅବ୍‌କାଡ୍ଡୋଲେ ବାଗୁନ୍‌ ଅମଡ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଜଡ୍‌ଲିଁୟ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବର୍ରିଁୟ୍‌, ସିଲୋଅ ବଣ୍ଡାଲୋଙନ୍‌ ଜିର୍ରେ ଇୟ୍‌ନାମଡ୍‌ନା; ତିଆସନ୍‌ ଆ ବର୍ନେନ୍‌ ଅନ୍ତମ୍‌ ଞେନ୍‌ ଇୟ୍‌ଲେ ଆମଡ୍‌ନାଞନ୍‌, ଅବ୍‌ତାଡ଼ନ୍‌ ଗିୟ୍‌ଲେ ରପ୍ତିଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନିନ୍‌ ଅଡ଼େଙ୍ଗା ?” ଆନିନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଜନା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ଆମ୍ମୁଙ୍‌ ଆକାଡ଼ୁ ଆଡ୍ରକୋଏନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ଆନିଞ୍ଜି ପାରୁସିଞ୍ଜି ଆମଙ୍‌ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ଜିସୁନ୍‌ ଅଙ୍ଗା ଡିନ୍ନା ଲବନ୍‌ ଅବ୍‌କାଡ୍ଡୋଡାଲେ ତି ମନ୍‌ରାନ୍‌ ଆମଡ୍‌ଲୋଙ୍‌ ଜଡ୍‌ଲେ ମବ୍‌ନଙେନ୍‌ ତି ଆ ଡିନ୍ନା ଲୋଲୋନେ ଡିନ୍ନା ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ତିଆସନ୍‌, ଆନିନ୍‌ ଏଙ୍ଗାଡାଲେ ଗିୟ୍‌ଲେ ରପ୍ତିଏନ୍‌, କେନ୍‌ଆତେ ପାରୁସିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଆରି ବରେଞ୍ଜି । ସିଲତ୍ତେ ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନିନ୍‌ ବାଗୁନ୍‌ ଅମଡ୍‌ଲୋଙ୍‌ଞେନ୍‌ କାଡ୍ଡୋନ୍‌ ଜଡ୍‌ଲିଁୟ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞେନ୍‌ ଇୟ୍‌ଲେ ଆମଡ୍‌ନାଞନ୍‌ ନମି ଗିୟ୍‌ଲେ ରପ୍ତିତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ପାରୁସିଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “ତି ଆ ମନ୍‌ରା ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅଃଜ୍ଜିର୍ରାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଆଲ୍ଲେତେ ।” ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “ଇର୍ସେମରନ୍‌ ଏଙ୍ଗାଡାଲେ କେନ୍‌ ଏନ୍ନେଗନ୍‌ ଆ ସାନ୍ନି କାବ୍ବାଡ଼ା ଲୁମ୍‌ଲେ ରପ୍ତିଏ ?” ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଏତ୍ତେଲେ ତରଙ୍‌ଆନ୍ନା ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଆରି ବତର ତି ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନିନ୍‌ ଅମଡ୍‌ନମ୍‌ ମବ୍‌ନଙେନ୍‌ ଗରାମ୍‌ତେନ୍‌, ଆମନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇନି ଗାମ୍‌ତେ ?” ଆନିନ୍‌ ଗାମେନ୍‌, “ଆନିନ୍‌ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ବନ୍‌ଡ ଆନିନ୍‌ କରୋକ୍କୋଡନ୍‌ ସିଲଡ୍‌ ମା ଆକାଡ଼ୁ ଡକୋଏନ୍‌ ଆରି ନମି ଗିୟ୍‌ଲେ ରପ୍ତିତେ, କେନ୍‌ ଆ ବର୍ନେ ଆପେୟନ୍‌ ଡ ଆୟୋଙନ୍‌ଆଡଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ବରେଞ୍ଜି ଜାୟ୍‌ ଜିଉଦିମରଞ୍ଜି ତିଆତେ ଅଃଡ୍ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଆୟୋଙନ୍‌ ଡ ଆପେୟନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ଆନିନ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ବେନ୍‌ ପଙ୍‌ ? ଆନିନ୍‌ ଆକାଡ଼ୁନ୍‌ ଜନମ୍ମୁ ଡେଏନ୍‌ ଗାମ୍‌ଲେ ଏବର୍ତନେ । ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ନମି ଏଙ୍ଗାଲେ ଗିୟ୍‌ଲେ ରପ୍ତିତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ସିଲତ୍ତେ ଆୟୋଙନ୍‌ ଡ ଆପେୟନ୍‌ ଜାଲଙେଞ୍ଜି, “ଓଓ, ଇନ୍‌ଲେନ୍‌ ଜନା, କେନ୍‌ଆନିନ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଲେନ୍‌, ଆନିନ୍‌ ଆକାଡ଼ୁନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ବନ୍‌ଡ ଆନିନ୍‌ ନମି ଏଙ୍ଗାଲେ ଗିୟ୍‌ଲେ ରପ୍ତିତେ, ତିଆତେ ଇନ୍‌ଲେନ୍‌ ଜନା ତଡ୍‌, ଆରି ଆନା ଆମଡନ୍‌ ମବ୍‌ନଙେନ୍‌, ତିଆତେ ନିୟ୍‌ ଇନ୍‌ଲେନ୍‌ ଜନା ତଡ୍‌; ଆନିନ୍‌ଆଡଙ୍‌ ବର୍ବା, ଆନିନ୍‌ ତ ଆମୟଙ୍‌ମର୍‌, ଆନିନ୍‌ଡମ୍‌ ଆ ବର୍ନେନ୍‌ ବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ତି ମନ୍‌ରାନ୍‌ ଆୟୋଙ୍‌ ଡ ଆପେୟନ୍‌ ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ବତଙେଞ୍ଜି, ତିଆସନ୍‌ ଏନ୍ନେଲେ ବର୍ରଞ୍ଜି । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନାଜି ଜିସୁନ୍‌ଆଡଙ୍‌ କ୍ରିସ୍ଟ ଗାମ୍‌ଲେ ଡର୍ତଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ସିଲଡ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଆସନ୍‌ ଜିଉଦିମରଞ୍ଜି କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ତିଆସନ୍‌ ଆୟୋଙନ୍‌ ଡ ଆପେୟନ୍‌ ଗାମେନ୍‌, “ଆନିନ୍‌ ଆମୟଙ୍‌ମର୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ବର୍ବା ।” ");
INSERT INTO juy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆମ୍ମୁଙ୍‌ ଆକାଡ଼ୁ ଆଡ୍ରକୋଏନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ବାଗୁତର ଓଡ୍ଡେଡାଲେ ବରେଞ୍ଜି, “ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ତିୟ୍‌ଲେ ବର୍ନା, ତି ଆ ମନ୍‌ରା ଇର୍ସେମର୍‌, କେନ୍‌ଆତେ ଇନ୍‌ଲେନ୍‌ ଜନା ।” ");
INSERT INTO juy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ସିଲତ୍ତେ ଆନିନ୍‌ ଗାମେନ୍‌, “ଆନିନ୍‌ ଇର୍ସେମର୍‌ ପଙ୍‌ ଅଡ଼େ ଇଜ୍ଜା, ତିଆତେ ଞେନ୍‌ ଜନା ତଡ୍‌, ଞେନ୍‌ ଆବୟନ୍‌ ଜନା, ଞେନ୍‌ ଆମ୍ମୁଙ୍‌ ଆକାଡ଼ୁ ଡକୋଲିଁୟ୍‌, ନମି ଗିୟ୍‌ଲେ ରପ୍ତିତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ତିଆସନ୍‌ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନିନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଇନି ଏଙ୍ଗାଲମ୍‌ ? ଆନିନ୍‌ ଏଙ୍ଗାଡାଲେ ଅମଡ୍‌ନମ୍‌ ମବ୍‌ନଙେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ବର୍ରନାୟ୍‌ନି, ଆରି ଆମ୍ୱେଞ୍ଜି ଏଃନ୍ନମ୍‌ଡଙ୍‌ଲୋ; ଇନିବା ଆରି ବତର ଅନମ୍‌ଡଙନ୍‌ ଏସାୟ୍‌ତେ ? ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଆ ଞଙ୍‌ନେମରନ୍‌ ଏମ୍ମେନେନ୍‌ ଆସନ୍‌ ଏସାୟ୍‌ତେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ କଁୟ୍‌ଲେ ବରେଞ୍ଜି, “ଆମନ୍‌ ଆ ଞଙ୍‌ନେମରନ୍‌, ବନ୍‌ଡ ଇନ୍‌ଲେନ୍‌ ମୋସାନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ଇସ୍ୱରନ୍‌ ମୋସାନ୍‌ ସରିନ୍‌ କଡାଡ଼ିଲନ୍‌ ତିଆତେ ଇନ୍‌ଲେଞ୍ଜି ଜନା, ବନ୍‌ଡ କେନ୍‌ ଆ ମନ୍‌ରା ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌, ତିଆତେ ଇନ୍‌ଲେଞ୍ଜି ଜନା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ତି ଆ ମନ୍‌ରା ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆନିନ୍‌ ଅମଡ୍‌ଞେନ୍‌ ମବ୍‌ନଙେନ୍‌, ଆରି ଆନିନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌ ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଜନାଜି ତଡ୍‌, କେନ୍‌ଆତେ ଅବୟ୍‌ ସରାନ୍ନିଡାନ୍‌ ଆ ବର୍ନେ । ");
INSERT INTO juy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ଇସ୍ୱରନ୍‌ ଇର୍ସେମରଞ୍ଜି ଆ ବର୍ନେ ଅଃନ୍ନମ୍‌ଡଙେ, କେନ୍‌ଆତେ ଇନ୍‌ଲେଞ୍ଜି ଜନା, ବନ୍‌ଡ ଆନାଜି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତଜି, ଆରି ଆ ଇସ୍ସୁମନ୍‌ ଅନ୍ତମ୍‌ କାବ୍ବାଡ଼ାତଞ୍ଜି, ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେଞ୍ଜି ତୁମ୍‌ ଅମ୍‌ଡଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ପୁର୍ତିନ୍‌ ଆଗ୍ରଡେଲେନ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ଜା କରୋକ୍କୋଡନ୍‌ ସିଲଡ୍‌ ଆକାଡ଼ୁମରନ୍‌ ଆମଡ୍‌ ମବ୍‌ନଙେନ୍‌ ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଆଙ୍ଗିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଅମ୍‌ଡଙ୍‌ବୋ ! ");
INSERT INTO juy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌ ନଙ୍‌, ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ ଇନ୍ନିଙ୍‌ ଲୁମ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ ବନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇର୍ସେଲୋଙନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେଲେ, ଆମନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ତଲେନ୍‌ ?” ଏନ୍ନେଲେ ବର୍ରନ୍‌ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ଆନିଞ୍ଜି ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙେଞ୍ଜି ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ରବାଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଇନି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମଙ୍‌ ଡର୍ତନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ଆନିନ୍‌ ଜାଲଙେନ୍‌, “ଏ ପ୍ରବୁ, ଆନିନ୍‌ ଆନା ଞେନ୍‌ଆଡଙ୍‌ ବରିଁୟ୍‌, ଞେନ୍‌ ଆମଙନ୍‌ ଡର୍ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆଗିୟ୍‌ଗିୟ୍‌, ଆନା ନମିଞେନ୍‌ ଆମନ୍‌ ସରିନ୍‌ କଡାଡ଼ିତନେ, ଆନିନ୍‌, ତି ଆ ମନ୍‌ରା ।” ");
INSERT INTO juy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ସିଲତ୍ତେ ଆନିନ୍‌ ଗାମେନ୍‌, “ପ୍ରବୁ, ଞେନ୍‌ ଡର୍ତନାୟ୍‌,” ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ତୁଡ଼ୁମ୍‌ଡାଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ଲୋମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ଆରି ଜିସୁନ୍‌ ବର୍ରନେ, “ଅଃଗିଜେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଗିୟ୍‌ଲେ ରପ୍ତିତଜି, ଆରି ଆଗ୍ରିୟ୍‌ତେଞ୍ଜି ଆ ମନ୍‌ରାଜି କାଡ଼ୁତଜି, ତି ଆ ପନ୍‌ସୁଆତି ଆସନ୍‌ ଞେନ୍‌ ପୁର୍ତିନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ତେତ୍ତେ ଆନିନ୍‌ ସରିନ୍‌ ଆଡ୍ରକୋଏଞ୍ଜି ଆ ପାରୁସିଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ନିୟ୍‌ ଆକାଡ଼ୁଜି ଅବ୍‌ଡିସୟ୍‌ତଲେନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ଜିସୁନ୍‌ ଜାଲଙେଞ୍ଜି, “କାଡ଼ୁଲବେନ୍‌ ନଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏର୍‌ଡୋସା ଡେତବେନ୍‌ ବନ୍‌, ବନ୍‌ଡ ଗିୟ୍‌ଲେ ଏରପ୍ତିତାୟ୍‌, ଏଗ୍ରାମ୍‌ତେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଗୋଗୋୟ୍‌ ଡୋସାମର୍‌ଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ଜିସୁନ୍‌ ବର୍ରନେ, “ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନା ସନଙ୍‌ଗଡ୍‌ ମେଣ୍ଡା ଗୁଆଡ଼ାଲୋଙନ୍‌ ଅଃଗନେ, ବନ୍‌ଡ ଆନ୍ନାଗଡ୍‌ ଡାୟ୍‌ଲେ ଗନ୍‌ତେ, ଆନିନ୍‌ ରାଉମର୍‌, ସକାମର୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ଆନା ସନଙ୍‌ଗଡ୍‌ ଗନ୍‌ତେ, ଆନିନ୍‌ ତୁର୍‌ମେଡ୍‌ମର୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ଜଗେଡିଁୟ୍‌ମରନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ସନଙନ୍‌ ରୋତେ, ଆନିନ୍‌ ଆ ମେଣ୍ଡାଞ୍ଜି ଅବ୍‌ଞୁମ୍‌ଡାଲେ ଓଡ୍ଡେତଜି, ମେଣ୍ଡାଞ୍ଜି ଆ ସର୍ରଙନ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି, ଆରି ଆନିନ୍‌ ଗୋସ୍ସାମେଡନ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ପାଙ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ଆନିନ୍‌ ଆ ମେଣ୍ଡାଞ୍ଜି ଅମ୍‌ଡୁଙ୍‌ଲେ ପାଙ୍‌ଲାୟ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଆ ମୁକ୍କାଗଡଞ୍ଜି ଆମ୍ମୁଙ୍‌ଲନ୍‌ ଜିର୍ତେ, ଆରି ମେଣ୍ଡାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙ୍‌ତଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆ ସର୍ରଙନ୍‌ ଜନାତଜି । ");
INSERT INTO juy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ଆନିଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ଅମ୍ମଡେଞ୍ଜି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଆଙ୍ଗିୟ୍‌ ଅଃସଣ୍ଡୋଙେଜି, ଆର୍ପାୟ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ଆନ୍ନାରେଙ୍‌ ଜିର୍ତଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଅଣ୍ଡ୍ରଙ୍‌ ଅମ୍ମଡେଞ୍ଜି ଆ ମନ୍‌ରା ଆ ସର୍ରଙ୍‌ ଅଃନ୍ନମ୍ମଡେଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ଜିସୁନ୍‌ କେନ୍‌ ଆନବ୍‌ଜଙ୍‌ବର୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ବନ୍‌ଡ ତି ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ଇନି ଆନିଞ୍ଜି ଅଃଗନ୍‌ଲୁଡ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଆରି ବର୍ରନେ, “ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଞେନ୍‌ ମେଣ୍ଡାଞ୍ଜି ଆ ସନଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ଞେନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜିରାଞନ୍‌ ଆମ୍ମୁଙ୍‌ ଡିଅଙ୍ଗା ମନ୍‌ରା ଇୟ୍‌ଲାଜି, ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ରାଉମର୍‌ଜି, ସକାମର୍‌ଜି, ବନ୍‌ଡ ମେଣ୍ଡାଞ୍ଜି ଆ ବର୍ନେଞ୍ଜି ଅଃନ୍ନମ୍‌ଡଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ଞେନ୍‌ ସନଙନ୍‌, ଆନା ଅମଙ୍‌ଗଡ୍‌ଞେନ୍‌ ଗନ୍‌ତେ, ଆନିନ୍‌ ଡୋବ୍‌ତନେ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଅମ୍ମନ୍‌ ଜିର୍ତେ ଆରି ଡୁଆରାନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ତନୁରନ୍‌ ଇୟ୍‌ତେ ଞାଙେ । ");
INSERT INTO juy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ରାଉମରନ୍‌ ରାଉନେବାନ୍‌, ରନବ୍ବୁବାନ୍‌ ଆରି ଅନବ୍‌ମୋସ୍ସାନ୍‌ ଆସନ୍‌ ତୁମ୍‌ ଇୟ୍‌ତାୟ୍‌ । ବନ୍‌ଡ ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅନମେଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆରି ଗୋଗୋୟ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ଞେନ୍‌ ମନଙ୍‌ ତୁର୍‌ମେଡ୍‌ମର୍‌, ମନଙ୍‌ ତୁର୍‌ମେଡ୍‌ମରନ୍‌ ମେଣ୍ଡାଞ୍ଜି ଆସନ୍‌ ଆ ପରାନ୍ନାନ୍‌ ତିୟ୍‌ଡମ୍‌ତନେ । ");
INSERT INTO juy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ଆନା ବର୍ତନ୍ନାନ୍‌ ପାଙ୍‌ଲେ ଗୋସ୍ସାମେଡନ୍‌ ଜଗେତେ, ଆନିନ୍‌ ତୁର୍‌ମେଡ୍‌ମର୍‌ ତଡ୍‌, ଆରି ମେଣ୍ଡାଞ୍ଜି ଆ ସାଉକାର ତଡ୍‌, ଆନିନ୍‌ ବଲିଆନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଗିୟ୍‌ଲେ ମେଣ୍ଡାଞ୍ଜି ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିର୍ତେ; ଆରି ବଲିଆନ୍‌ ମେଣ୍ଡାନ୍‌ ପାଙ୍‌ଲେ ତରଙ୍‌ଆନ୍ନା ଏମ୍ମେଆୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ବର୍ତନ୍ନାନ୍‌ ପାଙ୍‌ଲେ ମେଣ୍ଡାନ୍‌ ଆତ୍ରୁର୍‌ତେନ୍‌ ଆ ମନ୍‌ରା ଜିର୍ରେ ସେତ୍ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମେଣ୍ଡାଞ୍ଜି ଆସନ୍‌ ଅଃନ୍ନିୟମେ । ");
INSERT INTO juy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ଞେନ୍‌ ମନଙ୍‌ ତୁର୍‌ମେଡ୍‌ମର୍‌ । ଆପେୟନ୍‌ ଏଙ୍ଗାଲେ ଞେନ୍‌ଆଡଙ୍‌ ଜନାତେ, ଆରି ଞେନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଜନା, ");
INSERT INTO juy_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ତିଅନ୍ତମ୍‌ ଞେନ୍‌ ମେଣ୍ଡାଞେଞ୍ଜି ଜନାତାୟ୍‌, ଆରି ମେଣ୍ଡାଞେଞ୍ଜି ନିୟ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆଜନାଜି, ଆରି ମେଣ୍ଡାଞ୍ଜି ଆସନ୍‌ ଞେନ୍‌ ପରାନ୍ନାଞେନ୍‌ ତିୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ମେଣ୍ଡାଞ୍ଜି ଆରି ଆନ୍ନାରେଙ୍‌ ଡକୋଜି, ଆନିଞ୍ଜି କେନ୍‌ ଗୋସ୍ସାଲୋଙନ୍‌ ଅବୟ୍‌ଜି ତଡ୍‌, ତିଆତେଜି ନିୟ୍‌ ଞେନ୍‌ ପାଙ୍‌ତାୟ୍‌ । ଆନିଞ୍ଜି ଓନୋଡ୍ଡେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି ଆରି ଅଡ଼୍‌କୋଞ୍ଜି ଆବୟନ୍‌ ଆ ତୁର୍‌ମେଡ୍‌ମର୍‌ ଆ ଗୋସ୍ସା ଡେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ଞେନ୍‌ ପରାନ୍ନାଞେନ୍‌ ତରିୟ୍‌ଲାଞନ୍‌ ଆପେୟନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌, ପରାନ୍ନାଞେନ୍‌ ତିୟ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଞେନ୍‌ ତିଆତେ ଆରି ଞାଙ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ପରାନ୍ନାଞେନ୍‌ ଆନ୍ନିଙ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ପାଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଏଜି, ବନ୍‌ଡ ଞେନ୍‌ଡମ୍‌ ତିଆତେ ତିୟ୍‌ତାୟ୍‌ । ତିଆତେ ତନିୟନ୍‌ ଆସନ୍‌ ଆରି ଆବ୍‌ଡିଡ୍‌ଲେ ପନାଙନ୍‌ ଆସନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସନୋଡ଼ାନେନ୍‌ ଡକୋ । ଏନ୍ନେଲେ ଲନୁମନ୍‌ ଆସନ୍‌ ଆପେୟନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବାଁୟ୍‌ଲିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ଆସନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଆରି ତରଙ୍‌ଆନ୍ନା ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ଆଡଙ୍‌ ବୁତନ୍‌ ଆସୁମ୍‌ସୁମ୍‌, ଆନିନ୍‌ ଆବାୟା, ଇନିବା ଆ ବର୍ନେନ୍‌ ଏଅମ୍‌ଡଙ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ଆନ୍ନାମରଞ୍ଜି ଗାମେଞ୍ଜି, “ବୁତନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରା ଏନ୍ନେଲେ ବର୍ରନ୍‌ ଅଃର୍ରପ୍ତିଏ, ବୁତନ୍‌ ଇନି ଆକାଡ଼ୁନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ଲେ ରପ୍ତିଏ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ଜିରୁସାଲମ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ସରେବାସିଙନ୍‌ ଆ ଗରନ୍ନେସିଂପୁରନ୍‌ ଡେଏନ୍‌, ତିଆଡିଡ୍‌ ରଙାଗାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ଆରି ଜିସୁନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ସୋଲମନନ୍‌ ଆ ପିଣ୍ଡାଲୋଙ୍‌ ବୁଲ୍ଲେଲଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ସିଲତ୍ତେ ଜିଉଦିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଏର୍ରେ ଗେରେଡାଲେ ବରେଞ୍ଜି, “ଆରି ଡିଅଙ୍ଗା ଡିନ୍ନା ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଡାଲ୍‌ଗଡ୍‌ତଲେନ୍‌ ? ଆଜାଡ଼ିଡମ୍‌ ରେୟ୍‌ଲଙ୍‌ ବର୍ନା, ଆମନ୍‌ ପଙ୍‌ କ୍ରିସ୍ଟନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଃଡ୍ଡର୍ନେ, ଆପେୟ୍‌ଞେନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଅଙ୍ଗା ଅଙ୍ଗା ଆ କାବ୍ବାଡ଼ାଜି ଞେନ୍‌ ଲୁମ୍‌ତାୟ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଏଃଡ୍ଡର୍ନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ମେଣ୍ଡାଞେନ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ମେଣ୍ଡାଞେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ସର୍ରଙ୍‌ଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି ଆରି ଞେନ୍‌ ଆନିଞ୍ଜି ଜନାତାଜି, ଆନିଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ତିଁୟ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ତିୟ୍‌ତାଜି, ଆନିଞ୍ଜି ଆଙ୍ଗିୟ୍‌ ଅଃମ୍ମୋସ୍ସାଏଜି, ଅସିଲୋଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆନ୍ନିଙ୍‌ ରୁୟ୍‌ଲେ ପାଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ଆପେୟ୍‌ଞେନ୍‌ ଅଙ୍ଗାତେ ଞେନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ତିଆତେ ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ମଡ଼ଗା, ଆରି ଆପେୟନ୍‌ ଆସିଲୋଙ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ତିଆତେ ରୁୟ୍‌ଲେ ପାଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ଆପେୟନ୍‌ ଡ ଞେନ୍‌ ଆବୟନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଜିଉଦିମରଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ତନିଡନ୍‌ ଆସନ୍‌ ଆରି ବତର ଅରେଙନ୍‌ ଞିଡବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ମନଙ୍‌ କାବ୍ବାଡ଼ାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଲବେନ୍‌, ତି ଆ କାବ୍ବାଡ଼ାଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅଙ୍ଗା ଆ କାବ୍ବାଡ଼ା ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏତିଡ୍‌ର୍ତିଁୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲରୁମେନ୍‌ ଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ଏଃତ୍ତିଡରମ୍‌, ବନ୍‌ଡ ଆମନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ତେ, ଆରି ଆମନ୍‌ ଅବୟ୍‌ ମନ୍‌ରା, ବନ୍‌ଡ ଆମନ୍‌ ଇସ୍ୱର ଗାମ୍‌ଡମ୍‌ତନେ, ତିଆସନ୍‌ ଏତିଡର୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ବନାଁୟ୍‌ବର୍‌ଲୋଙ୍‌ବେନ୍‌ ଏନ୍ନେଲେ ଆଇଡିଡ୍‌ ଡକୋ, ଇସ୍ୱରନ୍‌ ବର୍ତନେ, ‘ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରଜି ।’ ");
INSERT INTO juy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ଇନ୍‌ଲେଞ୍ଜି ଜନା, ଅଙ୍ଗାତେ ସାସ୍ତ୍ରନ୍‌ ବର୍ତନେ ତିଆତେ ଆଏଡ଼ର୍‌ ଆଜାଡ଼ିନ୍‌, ଆନାଜି ଆମଙ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅଡ଼ୋଲାୟ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଇସ୍ୱରଜି ଗନାମନ୍‌ ଡେଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ଇସ୍ୱରନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସେଡାଡାଲେ ମଡ଼ିର୍‌ ଅମ୍ମେଲେ ପୁର୍ତିନ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌, ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଗରାମ୍‌ଲାଞନ୍‌, ଆମନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ତେ ଏଗାମ୍‌ତିଁୟ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଅଃଲ୍ଲୁମ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଡର୍‌ଡଙ୍‌ନେ । ");
INSERT INTO juy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ବନ୍‌ଡ ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଅଃଲ୍ଲୁମ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଃଡ୍ଡର୍ରନେ ଜନଙ୍‌ଡେନ୍‌ କାବ୍ବାଡ଼ାଞେନ୍‌ ଗିୟ୍‌ଲେ ଡର୍ନାବା । ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ଡକୋ ଆରି ଆପେୟନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ରପ୍ତି ଏଜନାତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଆରି ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ବନ୍‌ଡ ଆନିନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଜବ୍‌ଲୟ୍‌ଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଆରି ଜର୍ଦନନ୍‌ ଆ ଅଡିଗଡ୍‌ ଜିର୍ରେ, ଜନନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଆମ୍ମୁଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟେଞ୍ଜି, ତେତ୍ତେ ଜିର୍ରେ ଇୟ୍‌ଲେ ଡକୋନେ । ");
INSERT INTO juy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙନ୍‌ ଜିର୍ରାଜି । ଆରି ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ଜନନ୍‌ ସିନା ଅନ୍ନିଙ୍‌ ଆ ସାନ୍ନି କାବ୍ବାଡ଼ା ଅଃଲ୍ଲୁମ୍‌ଲୋ, ବନ୍‌ଡ ଜନନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆସନ୍‌ ଇନିଜି ଇନିଜି ବର୍ରନେ ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆଜାଡ଼ିନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ଆରି ତେତ୍ତେ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ବେତନିଆବାୟ୍‌ ଲାଜାରନ୍‌ ଅସୁଏନ୍‌ । ବାଗୁନ୍‌ ଆ ତନାନଞ୍ଜି ମରିଅମନ୍‌ ଡ ମାର୍ତାନ୍‌ ତି ଆ ସାଇଲୋଙ୍‌ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","କେନ୍‌ ଆ ମରିଅମ ବତର ପ୍ରବୁନ୍‌ ଆ ତାଲ୍‌ଜଙ୍‌ଲୋଙ୍‌ ଲଙିଡ୍‌ ମିଞଲନ୍‌ ଲାଲେ ଆବବନ୍‌ ଆ ଉଉ ବାତ୍ତେ ଆତାଲ୍‌ଜଙନ୍‌ ଗଗଡେନ୍‌ । କେନ୍‌ ଆ ବବ୍‌ରେନ୍‌ ଲାଜାରନ୍‌ ଅସୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ତି ଆ ତନାନ୍‌ଜି, “ପ୍ରବୁ, ଡନୁଙ୍‌ୟମ୍‌ ଗଡ଼ିନମ୍‌ ଅସୁତେ,” ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଆମଙ୍‌ କବରନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ଜିସୁନ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ, ଆନିନ୍‌ ଗାମେନ୍‌, “କେନ୍‌ ଆସୁ ରନବୁନ୍‌ ଆସନ୍‌ ତଡ୍‌, ବନ୍‌ଡ କେନ୍‌ଆତେ ଇସ୍ୱରନ୍‌ ଅନବ୍‌ଗୁଗୁ ପନେମେଙ୍‌ ଆସନ୍‌ ଆରି ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଅନବ୍‌ଗୁଗୁ ପନେମେଙ୍‌ ଆସନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ଜିସୁନ୍‌ ମାର୍ତାନ୍‌, ଆ ବୋଲ୍‌ମାୟନ୍‌ ମରିଅମନ୍‌ ଡ ଲାଜାରନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ଜିସୁନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଆଡିଡ୍‌ ଲାଜାରନ୍‌ ଅସୁତେ ଗାମ୍‌ଲେ ଅମ୍‌ଡଙେନ୍‌, ତେତ୍ତେ ଆନିନ୍‌ ଆରି ବାର୍ତା ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍ ବରେଞ୍ଜି, “ମବା ଇନ୍‌ଲେଞ୍ଜି ଜିଉଦା ଡେସାନ୍‌ ଏୟର୍ନେବା ।” ");
INSERT INTO juy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଞନଙ୍‌ତିୟ୍‌ମର୍‌ ଜିଉଦିମରଞ୍ଜି ମିୟ୍‌ତାନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅରେଙନ୍‌ ବାତ୍ତେ ତନିଡନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି, ଆରି ତେତ୍ତେ ଏୟର୍ନେବା ଗାମ୍‌ତେ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ଜିସୁନ୍‌ ବର୍ରନେ, “ତମ୍‌ବାନ୍‌ ବାର ଗଣ୍ଟା ଅଃସାଆରେ ପଙ୍‌ ? ଆନା ତମ୍‌ବାନ୍‌ ଆସାଆର୍‌ ଇଙନ୍‌ ତଙିୟ୍‌ତନେ ଆନିନ୍‌ ଅଃତ୍ତୁଡ୍ଡୁବେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ କେନ୍‌ ପୁର୍ତିନ୍‌ ଆ ସନାଆର୍‌ ଗିୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ବନ୍‌ଡ ଆନିନ୍‌ ତଗଲନ୍‌ ତଙିୟ୍‌ଲନ୍‌ ଡେନ୍‌ ତୁଡ୍ଡୁବ୍‌ତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମଙନ୍‌ ସନାଆରନ୍‌ ଅବୟ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ଆନିନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆବର୍ରନେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରି ବରେଞ୍ଜି, “ଗଡ଼ିଲେନ୍‌ ଲାଜାରନ୍‌ ଆଡିମଡ୍‌, ବନ୍‌ଡ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅନବ୍‌ଡୋବାନ୍‌ ଇୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ଞଙ୍‌ନେମରଞ୍ଜି ଗାମେଞ୍ଜି, “ପ୍ରବୁ, ଆନିନ୍‌ ଆଡିମଡ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ମନଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ଲାଜାରନ୍‌ ଆ ରନବୁବର୍‌ ଜିସୁନ୍‌ ବର୍ରନେ, ବନ୍‌ଡ ଞଙ୍‌ନେମରଞ୍ଜି ଲାଜାରନ୍‌ ଆଲୁଡ୍‌ଲୁଡ୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ତିଆସନ୍‌, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ରେୟ୍‌ଲଙ୍‌ ବରେଞ୍ଜି, “ଲାଜାରନ୍‌ ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ଆରି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଡର୍ତନେ, ତିଆସନ୍‌ ଞେନ୍‌ ତେତ୍ତେ ଅଃଡ୍ଡକୋଲନାଞନ୍‌, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ସର୍ଡାତନାୟ୍‌, ବନ୍‌ଡ ମବା, ଇନ୍‌ଲେଞ୍ଜି ଆମଙନ୍‌ ଏଇୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ସିଲତ୍ତେ ତୋମାନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଦିଦୁମ୍‌ ଗାମ୍‌ଲେ ଓଡ୍ଡେଏଞ୍ଜି, ଆନିନ୍‌, ଆ ସର୍ସି ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ମବା ଇନ୍‌ଲେଞ୍ଜି ନିୟ୍‌ ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ ସରିନ୍‌ ଜିର୍ରେ, ଆନିନ୍‌ ସରିନ୍‌ ଆୟ୍‌ ରବୁଲଙ୍‌ନେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଜିସୁନ୍‌ ବେତନିଆନ୍‌ ତୁଙେନ୍‌ କି ଲାଜାରନ୍‌ ମସାନ୍ନିଲୋଙନ୍‌ ଡକ୍କୋଡାଲେ ଉଞ୍ଜି ଡିନ୍ନା ଡେଏନ୍‌ ଗାମ୍‌ଲେ ଜନାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ବେତନିଆନ୍‌ ସିଲଡ୍‌ ଜିରୁସାଲମନ୍‌ ୟାଗି କିଲୋମିଟର୍‌ ଆ ସଙାୟ୍‌ ଆ ତଙର୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ମାର୍ତାନ୍‌ ଡ ମରିଅମନ୍‌ ଆ ବବ୍‌ରେ ଲାଜାରନ୍‌ ଆର୍ରବୁଏନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ବନବ୍‌ୟୋବାନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ଜିଉଦିମରଞ୍ଜି ଆମଙଞ୍ଜି ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ଜିସୁନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗାମ୍‌ଲେ ମାର୍ତାନ୍‌ ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ରନବାଙନ୍‌ ଆସନ୍‌ ଇୟେନ୍‌, ବନ୍‌ଡ ମରିଅମନ୍‌ ଅସିଙନ୍‌ ତଙ୍କୁମ୍‌ଲେ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ମାର୍ତାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଗାମେନ୍‌, “ପ୍ରବୁ, ଆମନ୍‌ ତେନ୍ନେ ଡକୋଲମ୍‌ ନଙ୍‌, ବବ୍‌ରେଞେନ୍‌ ଅଃର୍ରବୁଏ ବନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ବନ୍‌ଡ ଆମନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଇନି ବେଡ୍‌ତେ, ତିଆତେ ଇସ୍ୱରନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ତମ୍‌, କେନ୍‌ଆତେ ଞେନ୍‌ ନମିଞେନ୍‌ ନିୟ୍‌ ଜନା ।” ");
INSERT INTO juy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ବବ୍‌ରେନମ୍‌ ଆରି ୟର୍ମେଙ୍‌ଲେ ଡୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ମାର୍ତାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅନଞିଡ୍‌ ଡିନ୍ନାଇଙନ୍‌ ୟନର୍ମେଙ୍‌ ଇଙନ୍‌, ଆନିନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଡୋତନେ, ତିଆତେ ଞେନ୍‌ ଜନା ।” ");
INSERT INTO juy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ୟନର୍ମେଙନ୍‌ ଡ ଅନମେଙନ୍‌ । ଆନା ଅମଙ୍‌ଞେନ୍‌ ଡର୍ତନେ, ଆନିନ୍‌ ରବୁଏନ୍‌ ଜନଙ୍‌ଡେନ୍‌, ଆନିନ୍‌ ଅମେଙ୍‌ତେ; ");
INSERT INTO juy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ଆରି ଆନା ଆମେଙ୍‌ମତ୍ତାନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡର୍ତନେ ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ ଜା ଅଃର୍ରବୁଏ । କେନ୍‌ଆତେ ଆମନ୍‌ ଡର୍ତନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ମାର୍ତାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଓଓ, ପ୍ରବୁ, ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଅଙ୍ଗା କ୍ରିସ୍ଟ କେନ୍‌ ପୁର୍ତିନ୍‌ ଇୟ୍‌ତାୟ୍‌ ବନ୍‌, ଆମନ୍‌ ତିଆନିନ୍‌, ଗାମ୍‌ଲେ ଞେନ୍‌ ଡର୍ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ମାର୍ତାନ୍‌ ଏନ୍ନେଲେ ବର୍ରନ୍‌ କି ଆନିନ୍‌ ଜିର୍ରେ, “ଞନଙ୍‌ତିୟ୍‌ମରନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ଆରି ଆନିନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେତମ୍‌,” ଗାମ୍‌ଲେ ଆ ବୋଲ୍‌ମାୟନ୍‌ ମରିଅମନ୍‌ଆଡଙ୍‌ ଅଜନା ଓଡ୍ଡେଡାଲେ ଇୟ୍‌ଲେ ବରେ । ");
INSERT INTO juy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ମରିଅମନ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ, ଲଡୋଲନ୍‌ ଆମଙନ୍‌ ଇୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଅମ୍ମ ସାଇନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜିରାୟ୍‌, ବନ୍‌ଡ ମାର୍ତାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ରବାଙେନ୍‌ ତି ଜାୟ୍‌ ଆନିନ୍‌ ତେତ୍ତେନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ଅଙ୍ଗା ଜିଉଦିମର୍‌ଜି ମରିଅମନ୍‌ ସରିନ୍‌ ଅସିଙନ୍‌ ଡକୋଡାଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବବ୍‌ୟୋଏଞ୍ଜି, ଆନିଞ୍ଜି ମରିଅମନ୍‌ ଲଡୋଡାଲନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେନ୍‌ଆତେ ଗିୟ୍‌ଲେ, ଆନିନ୍‌ ମସାନ୍ନିନ୍‌ ଜିର୍ରେ ଇୟ୍‌ତେ ୟେୟେଡାନେ, ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟ୍‌ଲେ ଆନିଞ୍ଜି ମରିଅମନ୍‌ ଆ କଣ୍ଡୋଙ୍‌ଗଡ୍‌ ସନ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ଜିସୁନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋଲନ୍‌ ମରିଅମନ୍‌ ତେତ୍ତେ ତୁଙାତୁଙା ଆଜଙ୍‌ବାନ୍‌ ତୁଡ଼ୁମ୍‌ଡାଲେ ବର୍ରନେ । “ପ୍ରବୁ, ଆମନ୍‌ ତେନ୍ନେ ଡକୋଲମ୍‌ ନଙ୍‌, ବବ୍‌ରେଞେନ୍‌ ଅଃର୍ରବୁଏ ବନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ମରିଅମନ୍‌ ଡ ଆନିନ୍‌ ସରିନ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି ଆ ଜିଉଦିମର୍‌ଜି ଆୟରେଞ୍ଜିଆତେ ଗିୟ୍‌ଲେ, ଜିସୁନ୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ଅନିଃୟମ୍‌ଡାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଆନିନ୍‌ ଏତିଲେନ୍‌ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ପ୍ରବୁ, ଜିରାୟ୍‌ ଆୟ୍‌ ଗିଜା ।” ");
INSERT INTO juy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ଜିସୁନ୍‌ ୟେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ଜିଉଦିମରଞ୍ଜି ଗାମେଞ୍ଜି, “ଗିୟ୍‌ବା, ଆନିନ୍‌ ଲାଜାରନ୍‌ଆଡଙ୍‌ ଏଙ୍ଗାଲେ ଡୁଙ୍‌ୟମେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ବନ୍‌ଡ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଗାମେଞ୍ଜି, “ଆନିନ୍‌ କାଡ଼ୁମରନ୍‌ ଆମଡ୍‌ ଅପ୍ପୁମ୍ମଡେନ୍‌ । ଆନିନ୍‌ ଲାଜାରନ୍‌ଆଡଙ୍‌ ରନବୁନ୍‌ ସିଲଡ୍‌ ଡୋବ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ ପଙ୍‌ ବନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ଜିସୁନ୍‌ ଅନିଃୟମ୍‌ଡାଏନ୍‌ କି ମସାନ୍ନିଲୋଙନ୍‌ ଜିରେନ୍‌, ତିଆତେ ଅବୟ୍‌ ଲୋଙର୍‌, ଆରି ତି ଲୋଙରନ୍‌ ଆମୁକ୍କାଲୋଙ୍‌ ଅବୟ୍‌ ଅରେଙନ୍‌ ଆଡଙ୍‌ଡଙ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବାଁୟ୍‌ଲେ ବରେଞ୍ଜି, “କେନ୍‌ ଆରେଙ୍‌ ଡେଡ୍‌ବା ।” ଆର୍ରବୁଏନ୍‌ ଆ ମନ୍‌ରା ଆ ତନାନ୍‌ ମାର୍ତାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ ତିଆତେ ସଅଏନ୍ନି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତିଲ୍ଲୋଙ୍‌ ତିଲ୍ଲେ ଉଞ୍ଜି ଡିନ୍ନା ଡେଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଡର୍ରନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙ୍‌ ଗିୟ୍‌ତେ, କେନ୍‌ଆତେ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅଃବ୍ବର୍ରମ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଅରେଙନ୍‌ ଡେଡେଞ୍ଜି । ଜିସୁନ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆଙାଙ୍‌ଡାଲନ୍‌ ବର୍ରନେ, “ଆପେୟ୍‌, ପାର୍ତନାଞେନ୍‌ ଅମ୍‌ଡଙେନ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସେଙ୍କେତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ଆମନ୍‌ ଡିତାନ୍‌ ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ତେ କେନ୍‌ଆତେ ଞେନ୍‌ ଜନା, ବନ୍‌ଡ କେନ୍‌ ଏର୍ରେ ଆତନଙଞ୍ଜି ଆ ମନ୍‌ରାଜି, ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ଗାମ୍‌ଲେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ କେନ୍‌ଆନିଞ୍ଜି ଅଲ୍‌ଡର୍ନେଜି, ତିଆସନ୍‌ ଞେନ୍‌ ଏନ୍ନେଲେ ବର୍ରନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ଆନିନ୍‌ ଏନ୍ନେଲେ ବର୍ରୋଙ୍‌ ବର୍ରନ୍‌, ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଲାଜାର୍‌, ଡୁଙ୍‌ଲନ୍‌ ଜିରାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ଆରବୁମରନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରାୟ୍‌; ଆସିନ୍‌ ଡ ତାଲ୍‌ଜଙନ୍‌ ତରିଲ୍‌ନେକାବନ୍‌ ବାତ୍ତେ ଆବଲଡ୍‌ ଡକୋଏନ୍‌ ଆରି ଆ ମୁକ୍କାଲୋଙନ୍‌ ଅବୟ୍‌ ସିନ୍‌ରିନ୍‌ ଆଜିବାଡ୍‌ ଡକୋଏନ୍‌ । ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆନିନ୍‌ଆଡଙ୍‌ ଉର୍ବା । ଆରି ଅବ୍‌ତଙିୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ତିଆସନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌, ଆନାଜି ମରିଅମନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାଜି, ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଗିୟ୍‌ଲେ ଆମଙନ୍‌ ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ବନ୍‌ଡ ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ପାରୁସିଞ୍ଜି ଆମଙ୍‌ ଜିର୍ରେ, ଜିସୁନ୍‌ ଇନିଜି ଲୁମେନ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ତିଆସନ୍‌ ପାରୁସିଞ୍ଜି ଡ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ସୋଡ଼ା ସୋବାନ୍‌ ଓଡ୍ଡେଡାଲେ ଅବ୍‌ରୁକ୍କୁଲନ୍‌ ବର୍ରଞ୍ଜି, “ତି ଆ ମନ୍‌ରା ଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଇନି ଏଙ୍ଗାନେବୋ ? ଆନିନ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଏନ୍ନେଲେ ଅମ୍‌ରେଙ୍‌ଲବୋ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆମଙନ୍‌ ଡର୍ତଞ୍ଜି, ଆରି ରୋମିଅମରଞ୍ଜି ଜିର୍ରେ କେନ୍‌ ସରେବାସିଂଲେନ୍‌ ଡ ମନ୍‌ରାଲେଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ଅବ୍‌ମୋସ୍ସାଆଜେଜି !” ");
INSERT INTO juy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ବନ୍‌ଡ ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଅବୟ୍‌ନେ, ଆଞୁମନ୍‌ କାୟାପା, ତି ଆ ବର୍ସେଙ୍‌ ଆ ମୁଡ଼ ରାଓଡ଼ା, ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନ୍ନିଙ୍‌ ଜନାଜି ତଡ୍‌ ! ");
INSERT INTO juy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଏର୍‌ନବ୍‌ମୋସ୍ସାଲେ, ଆର୍ପାୟ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆର୍ରବୁତେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ସୁକ୍କା । କେନ୍‌ଆତେ ନିୟ୍‌ ପଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଇୟମ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ ?” ");
INSERT INTO juy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","କୟାପାନ୍‌ ଆନିନ୍‌ଡମ୍‌ କେନ୍‌ଆତେ ଅଃବ୍ବର୍ରନେ । ବନ୍‌ଡ ଆନିନ୍‌ ତି ଆ ବର୍ସେଙ୍‌ ମୁଡ଼ ରାଓଡ଼ା ଡକୋଏନ୍‌, ତିଆସନ୍‌ କେନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ ଆ ତଅଡ୍‌ଗଡନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌ । ଜିସୁନ୍‌ ତି ଜିଉଦିମରଞ୍ଜି ଆସନ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ଜିଉଦିମରଞ୍ଜି ତୁମ୍‌ ଆସନ୍‌ ତଡ୍‌, ବନ୍‌ଡ ତରଙ୍‌ଆନ୍ନା ଆଡ୍ରେଏଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଅନବ୍‌ରୁକ୍କୁନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ରବୁତେ, ଗାମ୍‌ଲେ ଆନିନ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ତି ଆ ଡିନ୍ନା ସିଲଡ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଜିଉଦିମରଞ୍ଜି ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ତିଆସନ୍‌ ଜିସୁନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଅବ୍‌ରାଙ୍‌ଡାଲନ୍‌ ଅଃବ୍ବୁଲ୍ଲେଲୋ, ବନ୍‌ଡ ଆନିନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ, ଆରିଙ୍‌ରିଙନ୍‌ ଆ ତୁୟାୟ୍‌ରେଙ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଇପ୍ରଇମ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଗଡ଼ାନ୍‌ ଜିରେନ୍‌, ଆନିନ୍‌ ତେତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ଇୟ୍‌ଲେ ଡକୋନେ । ");
INSERT INTO juy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ତିଆଡିଡ୍‌ ଜିଉଦିମରଞ୍ଜି ଅନେଲାୟ୍‌ପୁରନ୍‌ ତୁୟାୟ୍‌ଲାୟ୍‌, ତିଆସନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ମବ୍‌ଡ଼ିର୍‌ନେନ୍‌ ଆସନ୍‌ ସନ୍ନା ସାଇରେଙନ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆ ଆମ୍ମୁଙ୍‌ ଡିନ୍ନା ଜିରୁସାଲମନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ସାଜେଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ସରେବାସିଂଲୋଙନ୍‌ ରୁକ୍କୁଲନ୍‌ ତନଙ୍‌ଡାଲେ ତର୍ଡମ୍‌ ଅଲ୍‌ବର୍ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନି ଏବ୍‌ଡିସୟ୍‌ତେ ? ଆନିନ୍‌ ଇନି ପୁର୍ପୁର୍‌ବାନ୍‌ ଅଃନ୍ନିଆୟ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି, ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌, ଆନିନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋ, ଆନ୍ନିଙ୍‌ ଜନାଲବେନ୍‌ ଡେନ୍‌, ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଜନାଲେନ୍‌ବା, ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ବାଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ଅନେଲାୟ୍‌ପୁରନ୍‌ ତୁଡ୍ରୁ ଡିନ୍ନା ଆ ଆମ୍ମୁଙ୍‌ ଜିସୁନ୍‌ ବେତନିଆ ଗଡ଼ାନ୍‌ ଜିରେନ୍‌ । ଆନିନ୍‌ ଅଙ୍ଗା ଲାଜାର୍‌ଆଡଙ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବ୍‌ୟର୍ମେଙେନ୍‌ ଆନିନ୍‌ ତେତ୍ତେ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ତିଆସନ୍‌ ଆନିଞ୍ଜି ତେତ୍ତେ ଆନିନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ବୁଜିନ୍‌ ତୁବେଞ୍ଜି, ମାର୍ତାନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗର୍ଗରେଞ୍ଜି ରୁରୁଏଞ୍ଜି, ଆନାଜି ଆନିନ୍‌ ସରିନ୍‌ ଗାଗାନେବାନ୍‌ ତଙ୍କୁମେଞ୍ଜି ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଲାଜାରନ୍‌ ଅବୟ୍‌ନେ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ତିଆଡିଡ୍‌ ମରିଅମନ୍‌ ବବୋଡ୍ଡା ଲଙିଡ୍‌ ମିଞଲନ୍‌ ପାଙ୍‌ଲେ ଜିସୁନ୍‌ ଆ ତାଲ୍‌ଜଙ୍‌ଲୋଙ୍‌ ଲାଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆ ଉଉନ୍‌ ବାତ୍ତେ ବାଗୁନ୍‌ ଆ ତାଲ୍‌ଜଙନ୍‌ ଗଡ୍‌ଗଡେନ୍‌ । ଆରି ଲଙିଡନ୍‌ ବାତ୍ତେ ଅସିଙନ୍‌ ଗଡ଼ସଣ୍ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଇସ୍କାରିତ ଜିଉଦାନ୍‌, ଆନା ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ରୟ୍‌ତେ, ଆନିନ୍‌ ଗାମେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“କେନ୍‌ ଲଙିଡ୍‌ମେନ୍‌ ୟାଗିସ ଡିନାରି ବାତ୍ତେ ତମ୍‌ଲେ, ଇନିବା ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଏଃତ୍ତିୟ୍‌ଲୋ ?” ");
INSERT INTO juy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ଆନିନ୍‌ ଡୋଲେୟ୍‌ମରଞ୍ଜି ଆସନ୍‌ ଆରିଃୟମେନ୍‌ ଏନ୍ନେଲେ ବର୍ରନେ, ଏତ୍ତେଲେ ତଡ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ଅବୟ୍‌ ରାଉମର୍‌ । ଆମଙନ୍‌ ତଙ୍କା ମୁନାନ୍‌ ଆଡ୍ରକୋଏନ୍‌, ତେତ୍ତେ ଇନିଜି ଡନକ୍କୋନ୍‌ ଡେଲୋ, ତିଆତେ ଆନିନ୍‌ ରାଉଡାଲନ୍‌ ପାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ବନ୍‌ଡ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ତରିଲ୍‌ନେଞେନ୍‌ ଆଡିଡ୍‌ ଆସନ୍‌ ଆନିନ୍‌ କେନ୍‌ଆତେ ଡକ୍କୋଲେ ରପ୍ତିଏ, ତିଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଏଗାମ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ଡୋଲେୟ୍‌ମରଞ୍ଜି ଡିତାନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋତଞ୍ଜି ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡିତାନ୍‌ ଅଃଡ୍ଡକୋନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ଜିସୁନ୍‌ ବେତନିଆଲୋଙନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ଜିଉଦିମରଞ୍ଜି ଆଜ୍ରନାଏଞ୍ଜି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ତେତ୍ତେ ଇୟ୍‌ଲାଜି, ଆନିନ୍‌ଆଡଙ୍‌ ତୁମ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ତଡ୍‌, ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରାଆଡଙ୍‌ ଜିସୁନ୍‌ ଆରବୁନ୍‌ ସିଲଡ୍‌ ଅବ୍‌ୟର୍ମେଙେନ୍‌ ତି ଆ ଲାଜାର୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଗିୟ୍‌ଗିୟ୍‌ବାନ୍‌ ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ଲାଜାରନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ତନ୍ତ୍ରଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଅମ୍ମେଲେ ଗୋଗୋୟ୍‌ଡମ୍‌ ଜିଉଦିମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲେ ଡର୍ନେଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ତି ଆବାର୍ତାନ୍‌ ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଜିସୁନ୍‌ ଜିରୁସାଲମନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଅମ୍‌ଡଙ୍‌ଡାଲେ, ");
INSERT INTO juy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ସିଣ୍ଡିଅଲନ୍‌ ଞମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ରନବାଙନ୍‌ ଆସନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆରି ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରଞ୍ଜି, “ଓସାନ୍ନା, ପ୍ରବୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଆନା ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ସନେନ୍‌ସେନ୍‌, ଇସ୍ରାଏଲନ୍‌ ଆ ରାଜା ସନେନ୍‌ସେନ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ଜିସୁନ୍‌ ଅବୟ୍‌ ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ତଙ୍କୁମ୍‌ଲେ ଜିର୍ରାୟ୍‌, ସାସ୍ତ୍ରଲୋଙନ୍‌ ଏଙ୍ଗାଲେ ଆଇଡିଡ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ଏ ସିଓନନ୍‌ ଆଇସିୟ୍‌, ବତଙ୍‌ଡଙମ୍‌, ଗିଜା, ରାଜାନମ୍‌ ଜିର୍ତାୟ୍‌, ଆନିନ୍‌ ଆଅନ୍‌ ଗୋଡୋଁୟନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ତଙ୍କୁମ୍‌ଲେ ଜିର୍ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି କେନ୍‌ଆତେ ଆମ୍ମୁଙ୍‌ ଅଃଗନ୍‌ଲୁଡ୍‌ଲଜି; ବନ୍‌ଡ ଆଙ୍ଗା ଆନିନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଞାଙେନ୍‌, ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଆନିନ୍‌ ଆସନ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ଆରି ତି ଅନ୍ତମ୍‌ ଆନିଞ୍ଜି ଆନିନ୍‌ ଆସନ୍‌ ଲୁମେଞ୍ଜି ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ମନ୍ନେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ଆରି, ଆନିନ୍‌ ଲାଜାରନ୍‌ଆଡଙ୍‌ ମସାନ୍ନିନ୍‌ ସିଲଡ୍‌ ଓଡ୍ଡେଲେ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆରବ୍‌ୟର୍ମେଙେନ୍‌ ଆଡିଡ୍‌ ଆନାଜି ଆନିନ୍‌ ସରିନ୍‌ ତେତ୍ତେ ଡକୋଏଞ୍ଜି, ଆନିଞ୍ଜି ତି ଆ କାବ୍ବାଡ଼ା ଆସନ୍‌ ସାକିନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ତିଆସନ୍‌ ନିୟ୍‌ ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ମାୟ୍‌ନେବାନ୍‌ ଇୟେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ କେନ୍‌ ଆ ସାନ୍ନି କାବ୍ବାଡ଼ା ଲୁମେନ୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଅମ୍‌ଡଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ସିଲତ୍ତେ ପାରୁସିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ଏଗିୟ୍‌ତେ, କାବ୍ବାଡ଼ାଲେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅଡ଼ଜାୟ୍‌ତେ, ଗିୟ୍‌ବା, ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜିନି ।” ");
INSERT INTO juy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ପୁର୍ପୁର୍‌ ଇଙନ୍‌ ସେନ୍‌ପୁର୍‌ବାନ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ଗ୍ରିକ୍‌ମର୍‌ଜି ଡକୋଏଞ୍ଜି ");
INSERT INTO juy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ଆନିଞ୍ଜି ଗାଲିଲି ଗଡ଼ାନ୍‌ ବେତ୍‌ସାଇଦାବାୟ୍‌ ପିଲିପନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲେ, ଆନିନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଏ ଆଜ୍ଞା, ଇନ୍‌ଲେଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଏସାୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ପିଲିପନ୍‌ ଆନ୍ଦ୍ରିଅନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନ୍ଦ୍ରିଅନ୍‌ ଡ ପିଲିପନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆଞ୍ରାଙ୍‌ତେନ୍‌ ଆ ବନେଡ଼ା ଅଡ଼ୋଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ଞେନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଗମ୍ମବାୟନ୍‌ ଲବଲୋଙନ୍‌ ଗଲୋଡାଲେ ଅଃର୍ରବୁଲୋ ଡେନ୍‌, ତିଆତେ ଆବୟନ୍‌ ଡକୋତନ୍‌ । ବନ୍‌ଡ ତିଆତେ ରବୁଏନ୍‌ ଡେନ୍‌, ଗୋଗୋୟ୍‌ ସିସାତେ । ");
INSERT INTO juy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ଆନା ଆପରାନ୍ନାଡମନ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଅବ୍ବଡ଼ୟ୍‌ତେ, ଆରି ଆନା ଆପରାନ୍ନାଡମନ୍‌ କେନ୍‌ ଆ ପୁର୍ତିଲୋଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଆସନ୍‌ ଡୋବ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ଆନା କାବ୍ବାଡ଼ାଞେନ୍‌ ଲୁମ୍‌ଲୁମନ୍‌ ସାୟ୍‌ତେ, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ତୋ, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋତନାୟ୍‌, ଆନିନ୍‌ ନିୟ୍‌ ତେତ୍ତେ ଡକୋତନେ, ଆନା କାବ୍ବାଡ଼ାଞେନ୍‌ ଲୁମ୍‌ତେ, ଆପେୟନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ମାନ୍ନେତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ନମି ଉଗର୍‌ଞେନ୍‌ ବିକ୍କଡ଼ଡାତେ ଞେନ୍‌ ଆରି ଇନି ଗାମାୟ୍‌ ? ‘ଆପେୟ୍‌, କେନ୍‌ ଆ ବନେଡ଼ା ସିଲଡ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଡୋବିଁୟ୍‌’ ଗାମାୟ୍‌ ପଙ୍‌ ? ବନ୍‌ଡ କେନ୍‌ ଆସନ୍‌ ମା ଞେନ୍‌ କେନ୍‌ ଆ ବନେଡ଼ା ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ଆପେୟ୍‌, ଅଞୁମ୍‌ନମ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡେଏତୋ ।” ତିଆଡିଡ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ସର୍ରଙନ୍‌ ଅଡ଼ୋଲାୟ୍‌, “ଞେନ୍‌ ଅବ୍‌ଗୁଗୁଲାୟ୍‌ ଅବ୍‌ପେମେଙ୍‌ଲାୟ୍‌, ଆରି ଅବ୍‌ଗୁଗୁତାୟ୍‌ ଅବ୍‌ପେମେଙ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ତିଆସନ୍‌ ତେତ୍ତେ ଆତନଙନ୍‌ ଆ ମନ୍‌ରାଜି ତିଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ, “ରୁଆଙନ୍‌ ତୁତ୍ତୁଡ୍‌ଲନ୍‌,” ଗାମେଞ୍ଜି, ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଗାମେଞ୍ଜି, “ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବର୍ରାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେନ୍‌ ଆ ସର୍ରଙ୍‌ ଞେନ୍‌ ଆସନ୍‌ ତଡ୍‌, ଆର୍ପାୟ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଅଡ଼ୋଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ନମି କେନ୍‌ ପୁର୍ତିନ୍‌ ଆ ପନ୍‌ସୁଆତି ଅଡ଼ୋଲାୟ୍‌, ନମି କେନ୍‌ ପୁର୍ତିନ୍‌ ଆସ୍ରାସନତେନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ଡୁଆରାନ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ଆରି ଞେନ୍‌ଆଡଙ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଅବ୍‌ଡୋଲିଁୟ୍‌ଜି ଡେନ୍‌, ଅଡ଼୍‌କୋଞ୍ଜିଆଡଙ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡିଙ୍‌ତାଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ଆନିନ୍‌ ଏଙ୍ଗାଡାଲେ ରବୁତେ, ତି ଆ ବର୍ନେ କେନ୍‌ଆତେ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ତିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “କ୍ରିସ୍ଟନ୍‌ ଆଏଡ଼ର୍‌ ଆମେଙ୍‌ ଡକୋତନ୍‌, ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ବନାଁୟ୍‌ବର୍‌ଲୋଙନ୍‌ ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌ । ଏତ୍ତେଲ୍‌ଡେନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ତୋଣ୍ଡୋନ୍‌ ଅନବ୍‌ଡୋନ୍‌ ଡେତେ ଗାମ୍‌ଲେ ଏଙ୍ଗାଲେ ଆମନ୍‌ ବର୍ତନେ ? ତି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆନା ?” ");
INSERT INTO juy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆରି ବସନ୍ନେଃ ମତ୍ରମ୍‌ ସନାଆରନ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଡକୋତନେ । ଲୋଙଡନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ମଡଙ୍‌ବେନ୍‌ ତଡ୍‌, ତିଆସନ୍‌ ସନାଆରନ୍‌ ଡକୋନ୍‌ ଆଡିଡ୍‌ ତଙିୟ୍‌ନାବା, ଆନା ଲୋଙଡ୍‌ଲୋଙନ୍‌ ତଙିୟ୍‌ତନେ, ଆନିନ୍‌ ଅଡ଼େଙ୍ଗା ଜିର୍ତେ, ତିଆତେ ଆନିନ୍‌ ଅଃଜ୍ଜନାଏ । ");
INSERT INTO juy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ସନାଆରନ୍‌ ଆଅନ୍‌ ଡେବେନ୍‌, ତିଆସନ୍‌ ସନାଆରନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଡକୋନ୍‌ ଆଡିଡ୍‌ ସନାଆର୍‌ଲୋଙନ୍‌ ଡର୍ନାବା ।” ଜିସୁନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରନ୍‌ କି ଜିରେନ୍‌ ଆରି ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଅବ୍‌ସସଲନ୍‌ ଡକୋଲନେ । ");
INSERT INTO juy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ଜିସୁନ୍‌, ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଡିୟ୍‌ତେ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଲୁମେନ୍‌ ଜନଙ୍‌ଡେନ୍‌, ଆନିଞ୍ଜି ଆମଙନ୍‌ ଅଃଡ୍ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ତିଆସନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଜିସାୟନ୍‌ ଆ ପୁର୍ବାଃତେବର୍‌ କେନ୍‌ଆତେ ଡେଡମେନ୍‌, “ଏ ପ୍ରବୁ, ବର୍ନେଲେନ୍‌ ଆନା ଡର୍ରନେ ? ଆରି ଆନା ଆମଙ୍‌ ପ୍ରବୁନ୍‌ ଆ ବୋର୍ସା ଅନବ୍‌ତୁଜନ୍‌ ଡେଲୋ ?” ");
INSERT INTO juy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","କେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଡର୍ରନ୍‌ ଅଃର୍ରପ୍ତିଲଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିସାୟନ୍‌ ଆରି ନିୟ୍‌ ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ଇସ୍ୱରନ୍‌ ଆମଡଞ୍ଜି ଅବ୍‌କାଡ଼ୁଏଞ୍ଜି, ଆରି ଆନିନ୍‌ ଆ ଉଗରଞ୍ଜି ଇଙଡେଞ୍ଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଅମଡନ୍‌ ବାତ୍ତେ ଗିୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଏଜି, ଆରି ଆନିଞ୍ଜି ଉଗର୍‌ଲୋଙନ୍‌ ଅଃଗନ୍‌ଲୁଡେଜି, ଆରି ଆନିଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ଅଃୟର୍ନାଜି, ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ମବ୍‌ନଙାଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","କେନ୍‌ଆତେ ଜିସାୟନ୍‌ ବର୍ରନେ ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଜିସୁନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙ୍‌ ଗିଜେନ୍‌ ଆରି ଆନିନ୍‌ ଆ ବର୍ନେନ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି, ବନ୍‌ଡ ଅସମୟ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙ୍‌ତଲେଞ୍ଜି ଗାମ୍‌ଲେ ପାରୁସିଞ୍ଜିଆଡଙ୍‌ ବତଙ୍‌ଡାଲେ ତିଆତେ ଅବ୍‌ରାଙ୍‌ଡାଲନ୍‌ ଅଃବ୍ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙ୍‌ ଅଃଲ୍ଲଡୟ୍‌ଲଜି, ବନ୍‌ଡ ମନ୍‌ରାନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙ୍‌ ଲଡଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ଜିସୁନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ଆନା ଅମଙ୍‌ଞେନ୍‌ ଡର୍ତନେ, ଆନିନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ତୁମ୍‌ ଅଃଡ୍ଡର୍ନେ, ବନ୍‌ଡ ଆନିନ୍‌ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆମଙ୍‌ ନିୟ୍‌ ଡର୍ତନେ । ");
INSERT INTO juy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ତିଁୟ୍‌, ଆନିନ୍‌ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଗିୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ଞେନ୍‌ ପୁର୍ତିନ୍‌ ଆନବ୍‌ସାଆର୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ତିଆସନ୍‌ ଆନା ଅମଙ୍‌ଞେନ୍‌ ଡର୍ତନେ ଆନିନ୍‌ ଆଲୋଙଡନ୍‌ ଅଃଡ୍ଡକୋନେ । ");
INSERT INTO juy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ଆନା ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଅଃଞଣ୍ଡ୍ରମ୍‌ନେ, ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃନ୍ନବ୍‌ପନ୍‌ସୁଆତିଆୟ୍‌ । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ପୁର୍ତିନ୍‌ ଆନବ୍‌ପନ୍‌ସୁଆତି ଆସନ୍‌ ଅଃନ୍ନିୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ପୁର୍ତିନ୍‌ ଅନୁରନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ଆନା ଞେନ୍‌ଆଡଙ୍‌ ବାସ୍ସେତିଁୟ୍‌ ଆରି ବର୍ନେଞେନ୍‌ ଅଃଜ୍ଜାଏ, ଆନିନ୍‌ ଆସନ୍‌ ପନ୍‌ସୁଆତିମରନ୍‌ ଅବୟ୍‌ନେ ଡକୋ । ଞେନ୍‌ ଅଙ୍ଗା ବର୍ନେ ବର୍ରନାୟ୍‌, ତିଆତେ ଅନଞିଡ୍‌ ଡିନ୍ନାଇଙନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପନ୍‌ସୁଆତିତେ । ");
INSERT INTO juy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଇସ୍ସୁମ୍‌ଞେନ୍‌ ବାତ୍ତେ ଇନ୍ନିଙ୍‌ ଅଃବ୍ବର୍ରନାୟ୍‌, ବନ୍‌ଡ ଞେନ୍‌ ଇନି ବର୍ନାୟ୍‌, ଏଙ୍ଗାଲେ ବର୍ନାୟ୍‌, ତିଆତେ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆପେୟନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବାଁୟ୍‌ଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ଆରି, ଆ ବନାଞନ୍‌, ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ତନ୍‌, ତିଆତେ ଞେନ୍‌ ଜନା । ତିଆସନ୍‌ ଅଙ୍ଗା ବର୍ନେଜି, ଆପେୟନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବର୍ରିଁୟ୍‌, ତି ଆ ବର୍ନେଜି ତୁମ୍‌ ଞେନ୍‌ ବର୍ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆ ଆମ୍ମୁଙ୍‌ ଡିନ୍ନା କେନ୍‌ଆତେ ଡେଏନ୍‌ । କେନ୍‌ ଆ ପୁର୍ତି ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆପେୟ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋଲାୟ୍‌ ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଜନାଏନ୍‌ । ଆନିନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌ ଅଙ୍ଗା କୁଲମ୍‌ଜିଆଡଙ୍‌ ଆନିନ୍‌ ଡିତାନ୍‌ ଡୁଙ୍‌ୟମେଞ୍ଜି, ଆମଙଞ୍ଜି ଆନିନ୍‌ ଅନଞିଡ୍‌ ଡନୁଙ୍‌ୟମନ୍‌ ଅବ୍‌ତୁଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ତିଆଡିନ୍ନା ଜିସୁନ୍‌ ଡ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ତଗଲ୍‌ ଗାଗାନେନ୍‌ ତଙ୍କୁମେଞ୍ଜି । ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସନୋରୋପ୍ପାୟନ୍‌ ଆସନ୍‌ ସିମନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଇସ୍କାରିତ ଜିଉଦାନ୍‌ ଆ ଉଗର୍‌ଲୋଙ୍‌ ସନୁମନ୍‌ ଗନେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ତିଆଡିଡ୍‌ ଆପେୟନ୍‌, ଜିସୁନ୍‌ ଆସିଲୋଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବୋର୍ସା ସୋରୋପ୍ପାୟେନ୍‌ ଆରି ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌, ଆରି ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଜିର୍ତେ, ଗାମ୍‌ଲେ ଆନିନ୍‌ ଜନାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ତିଆସନ୍‌ ଆନିନ୍‌ ଗରାଗାନେଲୋଙନ୍‌ ସିଲଡ୍‌ ଡୋଲନ୍‌ ଆ ଅଙ୍ଗିନ୍‌ ଉୟ୍‌ଲନ୍‌ ଅବୟ୍‌ ଟାବାଲନ୍‌ ପାଙ୍‌ଲେ ଆ କୁଣ୍ଡୁବ୍‌ଲୋଙନ୍‌ ରେଡ୍ଡୁବ୍‌ଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଅରାସିନେ ସିମ୍ମାଲୋଙନ୍‌ ଡାଆନ୍‌ ଲାଏନ୍‌, କି ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଅବ୍ବାଜଙ୍‌ଡାଲେ ଆ କୁଣ୍ଡୁବ୍‌ଲୋଙନ୍‌ ଆଜିବାଡନ୍‌ ଆ ଟାବାଲ୍‌ ବାତ୍ତେ ଗଗଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ଆନିନ୍‌ ଏତ୍ତେଲେ ଅବ୍ବାଜଙ୍‌ଲେ ସିମନ୍‌ ପିତ୍ରନ୍‌ ଆମଙ୍‌ ଜିର୍ରାୟ୍‌, ସିମନନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ ଆମନ୍‌ ପଙ୍‌ ଞେନ୍‌ ଅବ୍ବାଜଙ୍‌ତିଁୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ଅଙ୍ଗାତେ ଲୁମ୍‌ତାୟ୍‌, ତିଆତେ ଆମନ୍‌ ନମି ଅଃଜ୍ଜନାଏ, ବନ୍‌ଡ ତିକ୍କି ଜନାତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଇଜ୍ଜା, ଆମନ୍‌ ତାଲ୍‌ଜଙ୍‌ଞେନ୍‌ ଅବ୍ବାଜଙ୍‌ଡଙିଁୟ୍‌ ।” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ତାଲ୍‌ଜଙ୍‌ନମ୍‌ ଅଃନ୍ନବ୍‌ବ୍ବାଜଙ୍‌ଲମ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଞଙ୍‌ନେମର୍‌ଞେନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ସିମନ୍‌ ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ପ୍ରବୁ ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତାଲ୍‌ଜଙ୍‌ଞେନ୍‌ ତୁମ୍‌ ତଡ୍‌, ଅବ୍‌ନାସିଇଁୟ୍‌ ଆରି ଅବ୍‌ଗଡ୍ଡାଇଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆନା ଆଉମ୍ମାନେ, ଆନିନ୍‌ଆଡଙ୍‌ ଆ ତାଲ୍‌ଜଙନ୍‌ ତୁମ୍‌ ଅବ୍ବାଜଙ୍‌ତବୋ, ଆରି ଇନ୍ନିଙ୍‌ ଗନିୟ୍‌ଡାନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌, ଆନିନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ମଡ଼ିର୍‌; ଆମ୍ୱେଞ୍ଜି ଆମଡ଼ିର୍‌ଜି, ବନ୍‌ଡ ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନା ଆନିନ୍‌ଆଡଙ୍‌ ବନେରାମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତେ, ଜିସୁନ୍‌ ତିଆତେ ଆଜନା; ତିଆସନ୍‌ ଆନିନ୍‌ ଗାମେନ୍‌, “ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ଆମଡ଼ିର୍‌ଜି ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ଆନିନ୍‌ ଆ ତାଲ୍‌ଜଙଞ୍ଜି ଅବ୍ବାଜଙ୍‌ଡାଲେ ଆ ଅଙ୍ଗିନ୍‌ ରଲନ୍‌ ତଙ୍କୁମେନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଇନି ଲୁମ୍‌ଲାୟ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଜନାତବେନ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଞନଙ୍‌ତିୟ୍‌ମର୍‌ ଆରି ପ୍ରବୁ ଗାମ୍‌ଲେ ଏଓଡ୍ଡେତିଁୟ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଆଜାଡ଼ିନ୍‌ ଏବର୍ତନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆତେ ଞେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ଞେନ୍‌ ପ୍ରବୁ, ଞେନ୍‌ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଜନଙ୍‌ଡେନ୍‌ ଞେନ୍‌ ତାଲ୍‌ଜଙ୍‌ବେଞ୍ଜି ଅବ୍ବାଜଙ୍‌ଲବେନ୍‌, ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେ ତର୍ଡମ୍‌ ଆ ତାଲ୍‌ଜଙ୍‌ ଅଲ୍‌ନବ୍ବାଜଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଏଙ୍ଗାଲେ ଲୁମ୍‌ଲାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେ ଲୁମ୍‌ବା, ତିଆସନ୍‌ ଞେନ୍‌ ଅବ୍‌ଜଙ୍‌ଲନ୍‌ କେନ୍‌ଆତେ ଲୁମ୍‌ଲେ ଅବ୍‌ତୁୟ୍‌ଲବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, କମ୍ୱାରିମରନ୍‌ ଆ ସାଉକାରନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ତଡ୍‌, ଆରି ଅନାପ୍ପାୟନ୍‌ ଅନାପ୍ପାୟ୍‌ମରନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଜନାଡାଲେ, ଏନ୍ନେଲେ ଏଲୁମେନ୍‌ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ସନେନ୍‌ସେନ୍‌ ଡେତେବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ଞେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ଆ ବର୍ନେ ଅଃବ୍ବର୍ନାୟ୍‌, ଏଙ୍ଗାଗୋ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଞେନ୍‌ ସେଡାଲାୟ୍‌, ତିଆତେ ଞେନ୍‌ ଜନା; ବନ୍‌ଡ ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡେଡମେ, ତିଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଡେତେ, ‘ଆନା ଜନୋମ୍‌ଞେନ୍‌ ଜୋମେନ୍‌, ଆନିନ୍‌ ବିରୁଦଲୋଙ୍‌ଞେନ୍‌ ଆ ଡନୁଙ୍କୁଡ଼ିଜଙନ୍‌ ଅବ୍‌ଡୋଏନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ତିଆତେ ଡେଏନ୍‌ ଆଡିଡ୍‌, ‘ଞେନ୍‌ ତିଆନିନ୍‌’ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଏଡର୍ତନେ, ତିଆସନ୍‌ ତିଆତେ ଅଣ୍ଡ୍ରଙ୍‌ ଡେଏନ୍‌ ଆ ଆମ୍ମୁଙ୍‌ ଞେନ୍‌ ନମିଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଞେନ୍‌ ଅରାପ୍ପାୟ୍‌ଲାଞନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ଆନା ଜାତେ, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଜାତିଁୟ୍‌ ଆରି ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଜାତିଁୟ୍‌, ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆରାପ୍ପାୟ୍‌ଲିଞନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ଜାତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ଜିସୁନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋ ବର୍ନେନ୍‌ ଆବର୍ରନେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ଆକ୍ରାନ୍‌ ଡୁକ୍କଡାଲନ୍‌ ଅପ୍ପୁଡ୍‌ତମ୍‌ଲନ୍‌ ସାକିନ୍‌ ତିୟେନ୍‌, “ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଞେନ୍‌ଆଡଙ୍‌ ବନେରାମରଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ଆନାଆଡଙ୍‌ ସେଙ୍‌ଲେ ଆନିନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ ଗାମ୍‌ଲେ ସାନ୍ନିଡାଲେ ଞଙ୍‌ନେମରଞ୍ଜି ତର୍ଡମ୍‌ ଅଲ୍‌ନାଙାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଜିସୁନ୍‌ ଆନାଆଡଙ୍‌ ଗୋଗୋୟ୍‌ ଡୁଙ୍‌ୟମେନ୍‌, ଆନିନ୍‌ ଜିସୁନ୍‌ ଆ ମାୟଙ୍‌ଲୋଙ୍‌ ଇଙ୍‌ଡର୍ରନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ସିମନ୍‌ ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଇମ୍ମଡ୍‌ଡାଲେ ବରେନ୍‌, “ଆନିନ୍‌ ଆନାଆଡଙ୍‌ ସେଙ୍‌ଲେ ଏନ୍ନେଲେ ବର୍ତନେ, ଆନିନ୍‌ଆଡଙ୍‌ ଅପ୍ପୁଙା ।” ");
INSERT INTO juy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ଆନିନ୍‌ ଏତ୍ତେଲେମା ଜିସୁନ୍‌ ଆ ମାୟଙ୍‌ଲୋଙ୍‌ ଆଇଙ୍‌ଡରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ ଆନିନ୍‌ ଆନା ?” ");
INSERT INTO juy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ଜିସୁନ୍‌ ଜାଲଙ୍‌ଲନେ, “ଆନା ଆସନ୍‌ ଞେନ୍‌ କେନ୍‌ ଆରେବ୍‌ରେବ୍‌ ରୁଟିନ୍‌ ଜୋବ୍‌ଡାତାୟ୍‌ ଆରି ଆନାଆଡଙ୍‌ ତିୟ୍‌ତାୟ୍‌, ଆନିନ୍‌ ।” ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ତି ଆରେବ୍‌ରେବ୍‌ ରୁଟିନ୍‌ ଜୋବ୍‌ଡାଡାଲେ ତିଆତେ ସିମନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଇସ୍କାରିତ ଜିଉଦାନ୍‌ଆଡଙ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ଇସ୍କାରିତ ଜିଉଦାନ୍‌ ଆରେବ୍‌ରେବ୍‌ ରୁଟିନ୍‌ ଆଞ୍ରାଙେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସନୁମନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙନ୍‌ ଗନେନ୍‌ । ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଇନି ଲୁମ୍‌ଲୁମନ୍‌ ସାୟ୍‌ତମ୍‌, ତିଆତେ ଲଲୁମା ।” ");
INSERT INTO juy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ବନ୍‌ଡ ଜିସୁନ୍‌ ଜିଉଦାନ୍‌ଆଡଙ୍‌ ଇନିବା କେନ୍‌ ଆ ବର୍ନେ ବରେନ୍‌, ତିଆତେ ଗାଗାନେନ୍‌ ଆତଙ୍କୁମଞ୍ଜି ଆନ୍ନିଙ୍‌ ଅଃଜ୍ଜନାଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ଜିଉଦାନ୍‌ ଆମଙ୍‌ ତଙ୍କା ମୁନାନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ପୁର୍‌ପୁରନ୍‌ ଆସନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ଜନବନ୍‌ ଞିଞିନ୍‌ ଆସନ୍‌ ଇଜ୍ଜାନ୍‌ଡେନ୍‌ ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଅଜିଡ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏନ୍ନେଲେ ବରେନ୍‌ ଗାମ୍‌ଲେ ଲାଙ୍‌ଲେଡ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଅବ୍‌ଡିସୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ଜିଉଦାନ୍‌ ଆରେବ୍‌ରେବ୍‌ ରୁଟିନ୍‌ ଜାଲେ, ଅବ୍‌ତାଡ଼ନ୍‌ ଆନିନ୍‌ ଡାଣ୍ଡନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେନ୍‌ । ତିଆଡିଡ୍‌ ଆତଗଲ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ଜିଉଦାନ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେନ୍‌ ସିଲଡ୍‌ ଜିସୁନ୍‌ ଗାମେନ୍‌, “ନମି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡେଏନ୍‌, ଆରି ଆନିନ୍‌ ଅମ୍ମେଲେ ଇସ୍ୱରନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ଇସ୍ୱରନ୍‌ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଅମ୍ମେଲେ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡେଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ନିୟ୍‌ ଆ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଗୁଗୁତେ ଅବ୍‌ପେମେଙ୍‌ତେ । ଆନିନ୍‌ ତିଆତେ ଲଲୁମ୍‌ରୟତେ । ");
INSERT INTO juy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ପସିୟ୍‌ଜି, ଞେନ୍‌ ଆରି ବସନ୍ନେଃ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋତନାୟ୍‌ । ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏସାୟ୍‌ଡଙ୍‌ତିଁୟ୍‌; ଆରି, ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଜିର୍ତେ, ଆମ୍ୱେଞ୍ଜି ତେତ୍ତେ ଇୟ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ, କେନ୍‌ଆତେ ଞେନ୍‌ ଏଙ୍ଗାଲେ ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ବର୍ରାଜି, ଏତ୍ତେଲେ ନମି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ବର୍ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ଆମ୍ୱେଞ୍ଜି ତର୍ଡମ୍‌ ଅଲ୍‌ଡୁଙ୍‌ୟମ୍‌ବା, କେନ୍‌ ରଙ୍‌ ବନାଞନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ତବେନ୍‌; ଞେନ୍‌ ଏଙ୍ଗାଲେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ଲବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେ ତର୍ଡମ୍‌ ଅଲ୍‌ଡୁଙ୍‌ୟମ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ଆମ୍ୱେଞ୍ଜି ତର୍ଡମ୍‌ ଅଲ୍‌ଡୁଙ୍‌ୟମ୍‌ବା, ତି ବାତ୍ତେ ଆମ୍ୱେଞ୍ଜି ଞଙ୍‌ନେମର୍‌ଞେଞ୍ଜି ଗାମ୍‌ଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଜନାତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ସିମନ୍‌ ପିତ୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ ଆମନ୍‌ ଅଡ଼େଙ୍ଗା ଇୟ୍‌ତେ ?” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଜିର୍ତେ, ଆମ୍ୱେଞ୍ଜି ନମିଞେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ତେତ୍ତେ ଇୟ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ, ବନ୍‌ଡ ତିକ୍କି ଏଇୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ ନମିଞେନ୍‌ ଇନିବା ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ତେତ୍ତେ ଇୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଆୟ୍‌ ? ଞେନ୍‌ ଆମନ୍‌ ଆସନ୍‌ ପରାନ୍ନାଞେନ୍‌ ନିୟ୍‌ ତିୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆଜାଡ଼ିଡମ୍‌ ଆମନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ପରାନ୍ନାନମ୍‌ ତିୟ୍‌ତେ ? ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, କମ୍‌ସିମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଓଲେନ୍‌ ଆମନ୍‌ ୟାଗି ତର ଞେନ୍‌ଆଡଙ୍‌ ମୁର୍ସେତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଉଗର୍‌ବେନ୍‌ ବାଉଲ୍ଲି ଡେଡଙ୍‌ ତଡ୍‌, ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଡର୍ନାବା, ଅମଙ୍‌ଞେନ୍‌ ନିୟ୍‌ ଡର୍ନାବା । ");
INSERT INTO juy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ଆପେୟ୍‌ଞେନ୍‌ ଆସିଂଲୋଙ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌ ଡରକୋନେସିଙନ୍‌ ଡକୋ; ଅବୟ୍‌ ତଡ୍‌ ନଙ୍‌, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଗାମ୍‌ତବେନ୍‌ ବନ୍‌, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଡରକୋନେସିଙନ୍‌ ଅନବ୍‌ଜାଡାବାନ୍‌ ଇୟ୍‌ତେ; ");
INSERT INTO juy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ଆରି, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଡରକୋନେସିଙନ୍‌ ଇୟ୍‌ଲେ ଅବ୍‌ଜାଡାନାୟ୍‌ ସିଲଡ୍‌ଡେନ୍‌ ଆରି ଇୟ୍‌ତାୟ୍‌, ଆରି ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋତନାୟ୍‌, ତେତ୍ତେ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଡକୋନେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଓରୋଙ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ଆରି, ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଜିର୍ତେ, ତି ଆ ତଙର୍‌ ଆମ୍ୱେଞ୍ଜି ଆଜନାଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ତୋମାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ, ଆମନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଜିର୍ତେ, ତିଆତେ ଇନ୍‌ଲେଞ୍ଜି ଜନା ତଡ୍‌, ତି ଆ ତଙର୍‌ ଇନ୍‌ଲେଞ୍ଜି ଏଙ୍ଗାଲେ ଏଜନାଆୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ତଙରନ୍‌, ଆଜାଡ଼ିନ୍‌ ଆରି ଅନମେଙନ୍‌; ଅମଙ୍‌ଗଡ୍‌ଞେନ୍‌ ଅଃଜ୍ଜିର୍ରୋ ଡେନ୍‌ ଆନ୍ନିଙ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଜନାଲିଁୟ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଏଜନାତେ ବନ୍‌, ନମିଞେନ୍‌ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଏଜନାତେ ଆରି ଏଗିୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ପିଲିପନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ ଆପେୟନ୍‌ଆଡଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଲେନ୍‌, ଡିୟ୍‌ତେ ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ସରି ।” ");
INSERT INTO juy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ପିଲିପ, ଡିୟ୍‌ତେ ଡିନ୍ନା ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋତନାୟ୍‌, ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆରି ଅଃଜ୍ଜନାଲିଁୟ୍‌ ପଙ୍‌ ? ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲିଁୟ୍‌, ଆନିନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଗିଜେନ୍‌, ଏଙ୍ଗାଲେ ଆମନ୍‌ ‘ଆପେୟନ୍‌ଆଡଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଲେନ୍‌’ ଗାମ୍‌ଲେ ଏବର୍ତନେ ? ");
INSERT INTO juy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ଡକୋତନାୟ୍‌, ଆରି ଆପେୟନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡକୋତନେ, କେନ୍‌ଆତେ ଆମନ୍‌ ଅଃଡ୍ଡର୍ନେ ପଙ୍‌ ? ଞେନ୍‌ ଡିଅଙ୍ଗା ବର୍ନେଞ୍ଜି ବର୍ତନାୟ୍‌, ତିଆତେ ଇସ୍ସୁମ୍‌ଡମ୍‌ଞେନ୍‌ ବାତ୍ତେ ଞେନ୍‌ ଅଃବ୍ବର୍ନାୟ୍‌, ବନ୍‌ଡ ଆପେୟନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡକୋଡାଲନ୍‌ ଆ କାବ୍ବାଡ଼ାନ୍‌ ଆନିନ୍‌ ଲୁମ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ଡକୋତନାୟ୍‌, ଆରି ଆପେୟନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡକୋତନେ, କେନ୍‌ ବର୍ନେଞେନ୍‌ ଡର୍ନାବା, ଇଜ୍ଜାନ୍‌ଡେନ୍‌ କାବ୍ବାଡ଼ାଞେନ୍‌ ଗିୟ୍‌ଲେ ଡର୍ନାବା । ");
INSERT INTO juy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆନା ଅମଙ୍‌ଞେନ୍‌ ଡର୍ତନେ, ଞେନ୍‌ ଲରୁମ୍‌ତାଞନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି, ଆନିନ୍‌ ନିୟ୍‌ ଲୁମ୍‌ଲେ ରପ୍ତିତେ, ତି ସିଲଡ୍‌ ଆରି ସୋଡ଼ା କାବ୍ବାଡ଼ାଞ୍ଜି ଆନିନ୍‌ ଲୁମ୍‌ଲେ ରପ୍ତିତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ଜିର୍ତେ । ");
INSERT INTO juy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ଆରି, ଆମ୍ୱେଞ୍ଜି ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଇନି ଏବେଡ୍‌ତେ, ତିଆତେ ଞେନ୍‌ ଲୁମ୍‌ତାୟ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଆମଙ୍‌ ଆପେୟନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ଆମ୍ୱେଞ୍ଜି ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଇନିଜନଙ୍‌ ଏବେଡ୍‌ଲିଁୟ୍‌ ଡେନ୍‌, ଞେନ୍‌ ତିଆତେ ଲୁମ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଡୁଙ୍‌ୟମ୍‌ଲିଁୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ବନାଁୟ୍‌ଞେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ନାବା । ");
INSERT INTO juy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ଆରି, ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ପାର୍ତନାତନାୟ୍‌, ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଆଏଡ଼ର୍‌ ଡକୋନେନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଅବୟ୍‌ ଡନାଲ୍‌ଡୋଙ୍‌ମରନ୍‌ ତିୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ଆନିନ୍‌ ଆଜାଡ଼ି ପୁରାଡ଼ାନ୍‌ । ପୁର୍ତିନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲେ ଅଃର୍ରପ୍ତିଏ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପୁର୍ତିନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃଗିଜେ କି ଅଃଜ୍ଜନାଏ; ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଏଜନାତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋତନେ, ଆରି ଆନିନ୍‌ ଉଗର୍‌ଲୋଙ୍‌ବେନ୍‌ ଡକୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ଞେନ୍‌ ଜିରେନ୍‌ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌କୋନ୍‌ରାଲେ ଅମ୍‌ରେଙ୍‌ଲେ ଅଃଜ୍ଜିର୍‌ବେନ୍‌, ଞେନ୍‌ ଅମଙ୍‌ବେନ୍‌ ୟର୍ତନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ବସନ୍ନେଃ ଡକୋ, ପୁର୍ତିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆରି ଅଃଗିଜିଁୟ୍‌; ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଗିୟ୍‌ତିଁୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମେଙ୍‌ ଡକୋ, ଆରି ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଆମେଙ୍‌ ଏଡକୋତନେ । ");
INSERT INTO juy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆମଙ୍‌, ଆମ୍ୱେଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ଆରି ଞେନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଡକୋ, କେନ୍‌ଆତେ ତି ଆ ଡିନ୍ନା ଅଡ଼ୋଲାୟ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଜନାତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ଆନା ବନାଁୟ୍‌ଞେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଜାଲେ ତିଆତେଜି ଞଣ୍ଡ୍ରମ୍‌ତନେ, ଆନିନ୍‌ ମା ଞେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌, ଆରି ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌, ଆପେୟ୍‌ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ, ଆରି ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ଡାଲେ ଞେନ୍‌ଡମ୍‌ ଆମଙନ୍‌ ଅବ୍‌ତର୍ନେତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ଜିଉଦାନ୍‌, ଇସ୍କାରିତ ଜିଉଦାନ୍‌ ତଡ୍‌, ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ପ୍ରବୁ, ଇନିବା, ଆମନ୍‌ ପୁର୍ତିନ୍‌ ଆମଙ୍‌ ଅଃନ୍ନବ୍‌ତର୍ନେଲନେ, ବନ୍‌ଡ ଅମଙ୍‌ଲେନ୍‌ ଅବ୍‌ତର୍ନେତନେ ?” ");
INSERT INTO juy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଆନ୍ନିଙ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ଲିଁୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ବର୍ନେଞେନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ତନେ, ଆରି ଆପେୟ୍‌ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତେ, ଆରି ଆପେୟନ୍‌ ଡ ଞେନ୍‌ ଆମଙନ୍‌ ଜିର୍ରେ ଆନିନ୍‌ ସରିନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଏଡକୋତନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଅଃଡ୍ଡୁଙ୍‌ୟମିଁୟ୍‌, ଆନିନ୍‌ ବର୍ନେଞେନ୍‌ ଅଃଞଣ୍ଡ୍ରମ୍‌ନେ, ଆରି ଆମ୍ୱେଞ୍ଜି ଅଙ୍ଗା ଞନଙ୍‌ ଏଅମ୍‌ଡଙ୍‌ତେ, ତିଆତେ ଞେନ୍‌ଆତେ ତଡ୍‌, ତିଆତେ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆପେୟନ୍‌ଆତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ଞେନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଡକୋନ୍‌ ଆଡିଡ୍‌, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ବନ୍‌ଡ ତି ଡନାଲ୍‌ଡୋଙ୍‌ମରନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌, ଆପେୟନ୍‌ ଆନାଆଡଙ୍‌ ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌, ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଇୟ୍‌ତାୟ୍‌ ଞଙ୍‌ଞଙ୍‌ବେନ୍‌, ଆରି ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଇନିଜି ଇନିଜି ବର୍ରବେନ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ଏତ୍ତାୟ୍‌ବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ସୟୁନ୍‌ ତିୟ୍‌ଲେ ଜିର୍ତବେନ୍‌, ସୟୁଡମ୍‌ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ଲେ ଜିର୍ତବେନ୍‌; ପୁର୍ତିନ୍‌ ଏଙ୍ଗାଲେ ତିୟ୍‌ତିୟ୍‌ତନେ, ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏତ୍ତେଲେ ଅଃତ୍ତିୟ୍‌ବେନ୍‌ । ଉଗର୍‌ବେନ୍‌ ବାଉଲ୍ଲିଡେଡଙ୍‌ ତଡ୍‌ କି ବତଙ୍‌ଡଙେ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ଞେନ୍‌ ଜିର୍ତେ, ବନ୍‌ଡ ଞେନ୍‌ ଆରି ଅମଙ୍‌ବେନ୍‌ ୟର୍ତନାୟ୍‌, କେନ୍‌ ବର୍ନେଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଅମ୍‌ଡଙେନ୍‌ । ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଡୁଙ୍‌ୟମ୍‌ଲିଁୟ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆମଙ୍‌ ଜିର୍ତେ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏସର୍ଡାତନ୍‌ ବନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆପେୟନ୍‌ ଞେନ୍‌ ସିଲଡ୍‌ ମୁଡ଼ । ");
INSERT INTO juy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ଆରି, ଇନିଜି ଡେରୟ୍‌ତେ ତି ଅଡ଼୍‌କୋନ୍‌ ଅବ୍ବାମ୍ମୁଙ୍‌ ଞେନ୍‌ ନମିଞେନ୍‌ ମା ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌, ତିଆତେଜି ଡେଏନ୍‌ ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଡର୍ତନେ । ");
INSERT INTO juy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ଞେନ୍‌ ଆରି ଗୋଗୋୟ୍‌ ଅୟମ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଅଃକ୍କଡାଡ଼ିନାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପୁର୍ତିନ୍‌ ଆସ୍ରାସନତେନ୍‌ ଆ ମନ୍‌ରା ଜିର୍ତାୟ୍‌; ଉପରେଙ୍‌ଞେନ୍‌ ଆମଙନ୍‌ ଇନ୍ନିଙ୍‌ ଅଦିକାର ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ବନ୍‌ଡ ଆପେୟନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଙ୍ଗାଲେ ବାଁୟ୍‌ଲିଁୟ୍‌, ଏତ୍ତେଲେ ଞେନ୍‌ କାବ୍ବାଡ଼ାତନାୟ୍‌ । ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ପୁର୍ତିନ୍‌ ରପ୍ତି ଜନାତେ ।” “ଡୋନାବା, ତେନ୍ନେ ସିଲଡ୍‌ ଏଜିର୍ବା ।” ");
INSERT INTO juy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ଞେନ୍‌ ଆଜାଡ଼ି ଦ୍ରାକ୍ୟାନୁବନ୍‌, ଆରି ଆପେୟ୍‌ଞେନ୍‌ ଅର୍ରମରନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ଅମଙ୍‌ଞେନ୍‌ ଡିଅଙ୍ଗା କେଣ୍ଡାରଞ୍ଜି ଡକୋ, ଅଙ୍ଗା କେଣ୍ଡାର୍‌ ଅଃନ୍ନଜଏ, ତିଆତେ ଆନିନ୍‌ ଅଡ୍‌ଲେସେଡେନ୍‌; ଆରି, ଅଙ୍ଗା କେଣ୍ଡାର୍‌ ଅଜତେ, ଗୋଗୋୟ୍‌ ଅନଜନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ତିଆତେ ସାଲ୍‌ଡାତେ । ");
INSERT INTO juy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ଏଞ୍ରାଙେନ୍‌ ଆ ଞନଙ୍‌ ବାତ୍ତେ ଆମ୍ୱେଞ୍ଜି ମଡ଼ିର୍ରବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ଅମଙ୍‌ଞେନ୍‌ ଡକୋନାବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋତନାୟ୍‌ । କେଣ୍ଡାରନ୍‌ ଏଙ୍ଗାଲେ ଦ୍ରାକ୍ୟାନୁବନ୍‌ ଜାବ୍‌ଲେ ଅଃଡ୍ଡକୋଲନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ଡମ୍‌ ରପ୍ତି ଅଃନ୍ନଜଏ, ତିଅନ୍ତମ୍‌ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଏଃଡ୍ଡକୋଲନ୍‌ ଡେନ୍‌ ରପ୍ତି ଅଃନ୍ନଜବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ଞେନ୍‌ ଦ୍ରାକ୍ୟାନୁବନ୍‌, ଆମ୍ୱେଞ୍ଜି ଆ କେଣ୍ଡାରନ୍‌; ଆନା ଅମଙ୍‌ଞେନ୍‌ ଡକୋତନେ ଆରି ଞେନ୍‌ ଆନା ଆମଙ୍‌ ଡକୋତନାୟ୍‌, ଆନିନ୍‌ ଗୋଗୋୟ୍‌ ଅଜତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଇନ୍ନିଙ୍‌ ଲୁମ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ଆନ୍ନିଙ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଅଃଡ୍ଡକୋଲନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଆଡେୟ୍‌ଡଜନ୍‌ ଆ କେଣ୍ଡାର୍‌ ଅନ୍ତମ୍‌ ଡୁଆରାନ୍‌ ସନେଡନ୍‌ ଡେତେ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତିଆତେ ଅସର୍‌ତେ, ଆରି ମନ୍‌ରାଞ୍ଜି ତିଆତେ ରୁକ୍କୁଡାଲେ ତଗୋଲୋଙନ୍‌ ପିଡ୍‌ତଜି, ତିଆତେଜି ଜୋମ୍‌ତୋଡ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ଆମ୍ୱେଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ଏଡକୋଲନ୍‌ ଡେନ୍‌, ଆରି ବର୍ନେଞେନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଡକୋଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନି ଏଲଡୟ୍‌ତେ, ତିଆତେ ବେଡ୍‌ବା, ତିଆତେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତନିୟନ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ଆମ୍ୱେଞ୍ଜି ଗୋଗୋୟ୍‌ ଅଜଲବେନ୍‌ ଡେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡେତେ, ଆରି ଆମ୍ୱେଞ୍ଜି ଆଜାଡ଼ିଡମ୍‌ ଞଙ୍‌ନେମର୍‌ଞେଞ୍ଜି ଡେତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ଆପେୟନ୍‌ ଏଙ୍ଗାଲେ ଞେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌, ଞେନ୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତବେନ୍‌; ଡନୁଙ୍‌ୟମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଗବ୍‌ରିଲନ୍‌ ଡକୋନାବା । ");
INSERT INTO juy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ଞେନ୍‌ ଏଙ୍ଗାଲେ ଆପେୟ୍‌ଞେନ୍‌ ଆ ବନାଁୟ୍‌ ଞଣ୍ଡ୍ରମ୍‌ଡାଲନ୍‌ ଆ ଡନୁଙ୍‌ୟମ୍‌ଲୋଙନ୍‌ ଗବ୍‌ରିଲନ୍‌ ଡକୋତନାୟ୍‌, ତିଅନ୍ତମ୍‌ ଆମ୍ୱେଞ୍ଜି ବନାଁୟ୍‌ଞେଞ୍ଜି ଏଞଣ୍ଡ୍ରମ୍‌ଲନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଡନୁଙ୍‌ୟମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଗବ୍‌ରିଲନ୍‌ ଏଡକୋତନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ସନର୍ଡାଞେନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଡକୋନେ, ଆରି ସର୍ଡାବେନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅଲ୍‌ବରିଜେ, ତିଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ଞେନ୍‌ ଏଙ୍ଗାଲେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ଲବେନ୍‌, ଏତ୍ତେଲେ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ତର୍ଡମ୍‌ ଅଲ୍‌ଡୁଙ୍‌ୟମ୍‌ବା, କେନ୍‌ଆତେ ବନାଁୟ୍‌ଞେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ଅବୟ୍‌ ମନ୍‌ରାନ୍‌, ଆ ଗଡ଼ିଞ୍ଜି ଆସନ୍‌ ଆପରାନ୍ନାଡମନ୍‌ ଆତ୍ରିୟ୍‌ତେନ୍‌, କେନ୍‌ ସିଲଡ୍‌ ଆରି ସୋଡ଼ା ଡନୁଙ୍‌ୟମନ୍‌ ଇନ୍ନିଙ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଙ୍ଗାତେ ବାଁୟ୍‌ତବେନ୍‌, ତିଆତେ ଏଞଣ୍ଡ୍ରମ୍‌ଲନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଗଡ଼ିଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆରି କମ୍ୱାରିମର୍‌ଜି ଅଃଗାମ୍‌ବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସାଉକାରନ୍‌ ଇନି ଲୁମ୍‌ତେ, ତିଆତେ କମ୍ୱାରିମରନ୍‌ ଅଃଜ୍ଜନାଏ; ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଗଡ଼ି ଗାମ୍‌ଲବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଇନିଜି ଅମ୍‌ଡଙ୍‌ଲାୟ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାଲବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଃସେଡାଲିଁୟ୍‌, ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ସେଡାଲବେନ୍‌, ଆରି ଆମ୍ୱେଞ୍ଜି ଜିର୍ରେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଇୟ୍‌ତେ ଏବ୍‌ଜଅନେ, ଆରି ଜଅବେନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ନଗରି ଅଲ୍‌ଡେଏ, ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତବ୍‌ନଙ୍‌ଲବେନ୍‌ । ସିଲତ୍ତେ ଆମ୍ୱେଞ୍ଜି ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଇନି ଏବେଡ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ତର୍ଡମ୍‌ ଏଲ୍‌ଡୁଙ୍‌ୟମ୍‌ତେ, ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ବାଁୟ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ପୁର୍ତିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ଲବେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ଲିଁୟ୍‌ ଗାମ୍‌ଲେ ଜନାବା । ");
INSERT INTO juy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ଆମ୍ୱେଞ୍ଜି ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ଏଡୁଙ୍‌ଲନାୟ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ପୁର୍ତିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ମନ୍‌ରାଞେଞ୍ଜି ଗାମ୍‌ଲେ ଡୁଙ୍‌ୟମ୍‌ତବେନ୍‌ ବନ୍‌; ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ଏଃଡ୍ଡୁଙ୍‌ଲନାୟ୍‌, ଆର୍ପାୟ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ସେଡାଲବେନ୍‌, କେନ୍‌ ଆସନ୍‌ ପୁର୍ତିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","କମ୍ୱାରିମରନ୍‌ ଆ ସାଉକାରନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ତଡ୍‌, ଗାମ୍‌ଲେ ଅଙ୍ଗା ବର୍ନେ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌ ତିଆତେ ମନ୍ନେବା । ଆନିଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଡଣ୍ଡାୟ୍‌ଲିଁୟ୍‌ଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ଡଣ୍ଡାୟ୍‌ତବେଞ୍ଜି; ଆନିଞ୍ଜି ବର୍ନେଞେନ୍‌ ଞଣ୍ଡ୍ରମ୍‌ଲଞ୍ଜି ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ବର୍ନେବେଞ୍ଜି ନିୟ୍‌ ଞଣ୍ଡ୍ରମ୍‌ତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ବନ୍‌ଡ ଅଞୁମ୍‌ଞେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏତ୍ତେତବେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆନା ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌, ତିଆତେ ଆନିଞ୍ଜି ଜନାଜି ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ଞେନ୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନାୟ୍‌ବର୍ରାଜି ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଇର୍ସେଲୋଙନ୍‌ ଡୋସାମର୍‌ଜି ଅଃଡ୍ଡେଏଜି ବନ୍‌, ବନ୍‌ଡ ନମି ଆନିଞ୍ଜି ଆ ଇର୍ସେଞ୍ଜି ସନସନ୍‌ ଆସନ୍‌ ଇନ୍ନିଙ୍‌ ତଙର୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତିଁୟ୍‌, ଆନିନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ଅଙ୍ଗା କାବ୍ବାଡ଼ାଜି ଆନ୍ନିଙ୍‌ ଆରି ଅଣ୍ଡ୍ରଙ୍‌ ଲୁମେଜି, ଞେନ୍‌ ତି ଆ କାବ୍ବାଡ଼ାଜି ଆମଙଞ୍ଜି ଅଃଲ୍ଲୁମ୍‌ଲାୟ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଇର୍ସେଲୋଙନ୍‌ ଡୋସାମର୍‌ଜି ଅଃଡ୍ଡେଏଜି ବନ୍‌, ବନ୍‌ଡ ନମି ଆନିଞ୍ଜି ଗିଜେଞ୍ଜି, ଆନିଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଆରି ଆପେୟ୍‌ଞେନ୍‌ଆଡଙ୍‌ ବାଗୁନ୍‌ଲେନ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ଲଲେଞ୍ଜି ");
INSERT INTO juy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","‘ଆନିଞ୍ଜି କାଜ୍ଜାନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ଲିଁୟ୍‌ଜି ।’ ଆ ବନାଁୟ୍‌ବର୍‌ଲୋଙଞ୍ଜି ଆଇଡିଡ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡେଡମେ, ତିଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଏନ୍ନେଲେ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ଆପେୟନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଞେନ୍‌ ଡନାଲ୍‌ଡୋଙ୍‌ମରନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌, ଆନିନ୍‌ ଆଜାଡ଼ି ପୁରାଡ଼ାନ୍‌, ଆପେୟନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରାୟ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ଆରି, ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଞେନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆମ୍ମୁଙ୍‌ ସିଲଡ୍‌ ଞେନ୍‌ ସରିନ୍‌ ଡକୋଲନ୍‌ ଏଜିର୍ରାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡର୍ନେଲୋଙନ୍‌ ରବ୍‌ଡୋଲନ୍‌ ଏଡକୋତନ୍‌ ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ସିଲଡ୍‌ ଆନ୍ନାତବେଞ୍ଜି ଆରି କେନ୍‌ ଅନ୍ତମ୍‌ ଆ ଡିନ୍ନା ଅଡ଼ୋତାୟ୍‌, ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ରବ୍ବୁତବେଞ୍ଜି ଆରି ଆନିଞ୍ଜି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଏଗଙ୍କେଲ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ମନ୍‌ରାଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏନ୍ନେତବେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆପେୟନ୍‌ଆଡଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜନାଏଜି କି ଞେନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ବର୍ରବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ଆତେଜି ଡେଏନ୍‌ ଆଡିଡ୍‌, ଞେନ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଆମ୍ମୁଙ୍‌ ବର୍ରନାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏମନ୍ନେତେ । ଆମ୍ମୁଙ୍‌ମା ସିଲଡ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅଃବ୍ବର୍ରବେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ସରିନ୍‌ ଡକୋଲନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“ନମି ଞେନ୍‌ ଅନାପ୍ପାୟ୍‌ମର୍‌ଞେନ୍‌ ଆମଙ୍‌ ଜିର୍ତେ । ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଞେନ୍‌ ଅଡ଼େଙ୍ଗା ଜିର୍ତେ ଗାମ୍‌ଲେ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଃବ୍ବରିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ନମିଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଉଗର୍‌ଲୋଙ୍‌ବେନ୍‌ ଇର୍ସୋୟମ୍‌ଡାତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଞେନ୍‌ ଜିରେନ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ସୁକ୍କା ଡେତେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଅଃଜ୍ଜିର୍ରୋ ଡେନ୍‌ ତି ଡନାଲ୍‌ଡୋଙନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଅଃଜ୍ଜିରାୟ୍‌, ଞେନ୍‌ ଜିରେନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଞେନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ଆନିନ୍‌ ଜିର୍ରେ, ଇର୍ସେନ୍‌, ଡରମ୍ମନ୍‌ ଆରି ଇସ୍ୱରନ୍‌ ଆ ପନ୍‌ସୁଆତି ଆ ବର୍ନେ କେନ୍‌ ପୁର୍ତିନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ଅବ୍‌ଜନାଏଜି । ");
INSERT INTO juy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ଆନିଞ୍ଜି ଅମଙ୍‌ଞେନ୍‌ ଅଃଡ୍ଡର୍ନେଜି, ତିଆସନ୍‌ ତିଆତେ ଇର୍ସେ । ");
INSERT INTO juy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ଜିର୍ତେ, ଆମ୍ୱେଞ୍ଜି ଆରି ଞେନ୍‌ଆଡଙ୍‌ ଏଃଗିଜିଁୟ୍‌, ତିଆସନ୍‌ କେନ୍‌ଆତେ ଡରମ୍ମଞେନ୍‌ ଆ ବର୍ନେ ସାକିନ୍‌ ତିୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","କେନ୍‌ ପୁର୍ତିନ୍‌ ଆସ୍ରାସନତେନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ଅବ୍‌ଡୋସାଲନେ, ତିଆସନ୍‌ କେନ୍‌ଆତେ ଇସ୍ୱରନ୍‌ ଆ ପନ୍‌ସୁଆତି ଆସନ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆରି ଗୋଗୋୟ୍‌ ବର୍ନେଞ୍ଜି ବନରନ୍‌ ଆସନ୍‌ ଡକୋ, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ନମି ତିଆତେଜି ସଏଲେ ଏଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ବନ୍‌ଡ ଆଜାଡ଼ି ପୁରାଡ଼ାନ୍‌ ଜିର୍ରାୟ୍‌ ଡେନ୍‌, ଅଡ଼୍‌କୋନ୍‌ ଆଜନାଡ଼ିଜି ଗନ୍‌ଲୁଡନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବୋର୍ସାନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତିୟ୍‌ବେନ୍‌ । ଆନିନ୍‌ ଆ ସନୋଡ଼ାନେନ୍‌ ବାତ୍ତେ ଇନ୍ନିଙ୍‌ ଅଃବ୍ବର୍ନେ । ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ ଇନିଜି ଆଅମ୍‌ଡଙ୍‌, ଡିୟ୍‌ତେ ତୁମ୍‌ ଆନିନ୍‌ ଇୟ୍‌ତାୟ୍‌ ବର୍ନେ । ଇନିଜି ଡେରୟ୍‌ତେ ତି ଅଡ଼୍‌କୋନ୍‌ ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ଅବ୍‌ଜନାବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଗୁଗୁ ଅବ୍‌ପେମେଙ୍‌ତିଁୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ପାଙ୍‌ଲେ, ଆନିନ୍‌ ତିଆତେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ଅଙ୍ଗାତେ ଆପେୟ୍‌ଞେନ୍‌ଆତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ଆତେ, ତିଆସନ୍‌ ଞେନ୍‌ ଗାମ୍‌ଲାୟ୍‌, ଅମଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ପାଙ୍‌ଲେ ଆନିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ବସନ୍ନେଃ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଆରି ଞେନ୍‌ଆଡଙ୍‌ ଏଃଗିଜିଁୟ୍‌, ବନ୍‌ଡ ଆରି ବସନ୍ନେଃ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଗିୟ୍‌ତିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେ ତର୍ଡମ୍‌ ଅଲ୍‌ବର୍ବରେଞ୍ଜି, “ଆନିନ୍‌ ଗାମ୍‌ତେ, ‘ବସନ୍ନେଃ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଆରି ଞେନ୍‌ଆଡଙ୍‌ ଏଃଗିଜିଁୟ୍‌, ବନ୍‌ଡ ଆରି ବସନ୍ନେଃ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଗିୟ୍‌ତିଁୟ୍‌ । ଆରି ଆନିନ୍‌ ଗାମ୍‌ତେ, ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ଜିର୍ତେ ।’ କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ଇନି ? ");
INSERT INTO juy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘ବସନ୍ନେଃ’ କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ଇନି ? ଆନିନ୍‌ ଇନି ଗାମ୍‌ତେ, ଅଃଗନ୍‌ଲୁଡ୍‌ଲଙ୍‌ନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ସନେକ୍କୁବରନ୍‌ ଆସନ୍‌ ସାୟ୍‌ତଜି ଗାମ୍‌ଲେ ଜନାଡାଲେ, ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଗାମ୍‌ଲାୟ୍‌, ‘ବସନ୍ନେଃ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଆରି ଏଃଗିଜିଁୟ୍‌, ବନ୍‌ଡ ବସନ୍ନେଃ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଆରି ଏଗିୟ୍‌ତିଁୟ୍‌ ।’ କେନ୍‌ ଆ ବର୍ନେ ଆମ୍ୱେଞ୍ଜି ଏକଡାଡ଼ିଲନ୍‌, ଇଜ୍ଜା ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଏୟେତେ, ଏଗୁତେ, ବନ୍‌ଡ ପୁର୍ତିନ୍‌ ସର୍ଡାତନେ । ଆମ୍ୱେଞ୍ଜି ଅନିଃୟମ୍‌ଡାତବେନ୍‌, ବନ୍‌ଡ ଅନିଃୟମ୍‌ବେନ୍‌ ସର୍ଡାନ୍‌ ଗଡେଲ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","କୋକ୍କୋଡନ୍‌ ବେଡ଼ାନ୍‌ ଅଡ଼ୋଲାୟ୍‌ ଡେନ୍‌ କୋକ୍କୋଡନ୍‌ବଜନ୍‌ ଡଣ୍ଡତେ, ବନ୍‌ଡ ଆନିନ୍‌ ପସିଜନ୍‌ କୋଡେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ପୁର୍ତିଲୋଙନ୍‌ ଅବୟ୍‌ ପସିଜନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେଲୋ ଗାମ୍‌ଲେ ଆନିନ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ବତ୍ତାନ୍‌ କରୋଡାତେ । ");
INSERT INTO juy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ତି ଅନ୍ତମ୍‌ ଡେତବେନ୍‌ । ଆମ୍ୱେଞ୍ଜି ନମି ଏଇଃୟମ୍‌ତେ, ବନ୍‌ଡ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆରି ବତର ଲଗିୟ୍‌ତବେନ୍‌, ତିଆଡିଡ୍‌ ଉଗର୍‌ବେନ୍‌ ସର୍ଡାଲୋଙନ୍‌ ବରିୟ୍‌ତେ । ତି ଆ ସର୍ଡା ଅମଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ତବ୍‌ଲେ ପାଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ତି ଆ ଡିନ୍ନା ଅଡ଼ୋଲାୟ୍‌ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଆରି ଞେନ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଏଃବ୍ବେଡିଁୟ୍‌ । ଆଜାଡ଼ିଡମ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଆପେୟନ୍‌ଆଡଙ୍‌ ଇନି ଏବେଡ୍‌ତେ, ଆନିନ୍‌ ତିଆତେ ତିୟ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ନମିନ୍ତାନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଇନ୍ନିଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଏବେଡିଁୟ୍‌ । ବେଡ୍‌ବା, ଆଜାଡ଼ିଡମ୍‌ ଏଞାଙ୍‌ତେ, ଆରି ସନର୍ଡାବେନ୍‌ ବରିୟ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ଞେନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ବନ୍‌ଡ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ତିଆଡିଡ୍‌ ଞେନ୍‌ ଆରି ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଅଃବ୍ବର୍ବେନ୍‌, ଆପେୟନ୍‌ ଆ ବର୍ନେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ରେୟ୍‌ଲଙ୍‌ ବର୍ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ତି ଆ ଡିନ୍ନା ଅଡ଼ୋଲାୟ୍‌ ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଞୁମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଏବେଡ୍‌ତେ । ତିଆଡିଡ୍‌ ଞେନ୍‌ ଡନେଲୋଙ୍‌ବେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଅଃବ୍ବରାୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆପେୟନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତବେନ୍‌ । ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌ ଆରି ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏଡର୍ତନେ, ତିଆସନ୍‌ ଆପେୟନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ପୁର୍ତିନ୍‌ ଇୟ୍‌ଲାୟ୍‌; ଆରି ଞେନ୍‌ ପୁର୍ତିନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆପେୟନ୍‌ ଆମଙ୍‌ ୟର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଗାମେଞ୍ଜି, “ଗିଜା, ନମି ଆମନ୍‌ ରେୟ୍‌ଲଙ୍‌ ବର୍ତନେ, ଅନବ୍‌ଜଙ୍‌ବରନ୍‌ ବାତ୍ତେ ଆରି ଅଃବ୍ବର୍ନେ । ");
INSERT INTO juy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ଆମନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ଜନା, ଆରି ଆମନ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ସନେକ୍କୁବରନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ତଡ୍‌, ତିଆତେ ନମିଞେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଏଜନାଲାୟ୍‌; ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଆମନ୍‌ ଜିର୍ରାୟ୍‌ ଗାମ୍‌ଲେ କେନ୍‌ଆତେ ବାତ୍ତେ ଇନ୍‌ଲେଞ୍ଜି ଏଡର୍ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଇନି ନମିଞେନ୍‌ ଏଡର୍ତନ୍‌ ପଙ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ଗିୟ୍‌ବା, ଡିନ୍ନାନ୍‌ ଅଡ଼ୋତାୟ୍‌, ଓଓ, ଅଡ଼ୋଲାୟ୍‌ନି, ଅଙ୍ଗା ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ତରଙ୍‌ଆନ୍ନା ଡେତବେନ୍‌, ଆରି ଆମ୍ୱେଞ୍ଜି ରମ୍ମଙ୍‌ ଅସିଂ ଏଜିର୍‌ଜିର୍‌ତେ, ଆରି ଞେନ୍‌ ତିନ୍‌ସୟ୍‌ଞେନ୍‌ ଡକୋତନାୟ୍‌ । ବନ୍‌ଡ ଞେନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ତିନ୍‌ସୟ୍‌ଞେନ୍‌ ତଡ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆପେୟନ୍‌ ଞେନ୍‌ ସରିନ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଡକୋଡାଲନ୍‌ ସନୟୁନ୍‌ ଏଞାଙ୍‌ତେ, ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ବର୍ରବେନ୍‌ । ପୁର୍ତିନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଡଣ୍ଡାୟ୍‌ତବେନ୍‌, ବନ୍‌ଡ ଅବ୍ବୋମଙ୍‌ନାବା, ଞେନ୍‌ ପୁର୍ତିନ୍‌ ଜିନୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ଜିସୁନ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ବର୍ରନ୍‌, ରୁଆଙ୍‌ଗଡ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆଙାଙ୍‌ଡାଲେ ବର୍ରନେ, “ଆପେୟ୍‌ ଡିନ୍ନାନ୍‌ ଅଡ଼ୋଲାୟ୍‌ନି; ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ଆଡଙ୍‌ ଅବ୍‌ଗୁଗୁଆ ଅବ୍‌ପେମେଙା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଗୁଗୁତମ୍‌ ଅବ୍‌ପେମେଙ୍‌ତମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ଆମନ୍‌ ଆନାଜିଆଡଙ୍‌ ଆସିଲୋଙନ୍‌ ସୋରୋପ୍ପାୟେଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ତନିୟନ୍‌ ଆସନ୍‌, ଆମନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ତୋଣ୍ଡୋଲୋଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ଆରି, ଆମନ୍‌ ମା ଆବୟଡମ୍‌ ଆଜାଡ଼ି ଇସ୍ୱରନ୍‌, ଆମନ୍‌ଆଡଙ୍‌ ଜନନାନ୍‌ ଡ ଅନାପ୍ପାୟ୍‌ନମ୍‌ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ଆଡଙ୍‌ ଜନନାନ୍‌ ମା ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗା କାବ୍ବାଡ଼ା ଲୁମ୍‌ଲୁମନ୍‌ ଆସନ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ତିଆତେ ଞେନ୍‌ ସାଡ୍‌ଲେ ପୁର୍ତିଲୋଙନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଗୁଗୁଲମ୍‌ ଅବ୍‌ପେମେଙ୍‌ଲମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ଆରି ନମି, ଏ ଆପେୟ୍‌, ପୁର୍ତିନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗଡେଲେନ୍‌ ଆଡିଡ୍‌ ଆମନ୍‌ ସରିନ୍‌ ଞେନ୍‌ ଅଙ୍ଗା ଗନୁଗୁ ପନେମେଙ୍‌ ଡକୋଏନ୍‌, ତି ବାତ୍ତେ ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆମନ୍‌ ସରିନ୍‌ ଅବ୍‌ଗୁଗୁଇଁୟ୍‌ ଅବ୍‌ପେମେଙିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ଆମନ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ଅଙ୍ଗା ମନ୍‌ରାଜିଆଡଙ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ଞେନ୍‌ ଆମଙଞ୍ଜି ଅଞୁମ୍‌ନମ୍‌ ବର୍ରନାୟ୍‌; ଆନିଞ୍ଜି ଆମନ୍‌ଆତେ ଡକୋଏଞ୍ଜି, ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ଆମନ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ଆନିଞ୍ଜି ବର୍ନେନମ୍‌ ଞଣ୍ଡ୍ରମ୍‌ତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଇନିଜି ତିୟ୍‌ଲିଁୟ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଅମଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌, ତିଆତେ ଆନିଞ୍ଜି ନମି ଗନ୍‌ଲୁଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗା ବର୍ନେଜି ତିୟ୍‌ଲିଁୟ୍‌, ତିଆତେ ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ଲାଜି, ଆରି ଆନିଞ୍ଜି ତିଆତେ ଜାଏଞ୍ଜି, ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଆଜାଡ଼ିଡମ୍‌ ଆଜନାଜି, ଆରି ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ଗାମ୍‌ଲେ ଡର୍ତଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ଞେନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ପାର୍ତନାତନାୟ୍‌; ପୁର୍ତିନ୍‌ ଆସନ୍‌ ଅଃପ୍ପାର୍ତନାନାୟ୍‌, ବନ୍‌ଡ ଆନାଜିଆଡଙ୍‌ ଆମନ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ଆନିଞ୍ଜି ଆସନ୍‌ ପାର୍ତନାତନାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆମନ୍‌ଆତେଜି । ");
INSERT INTO juy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ଅଙ୍ଗା ଅଙ୍ଗାତେ ଞେନ୍‌ଆତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଆମନ୍‌ଆତେ, ଆରି ଅଙ୍ଗା ଅଙ୍ଗାତେ ଆମନ୍‌ଆତେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଞେନ୍‌ଆତେ; ଞେନ୍‌ ଆନିଞ୍ଜି ଅମ୍ମେଲେ ଗନୁଗୁ ପନେମେଙନ୍‌ ଡେଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ଞେନ୍‌ କେନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଅଃଡ୍ଡକୋନାୟ୍‌, ବନ୍‌ଡ କେନ୍‌ଆନିଞ୍ଜି ପୁର୍ତିଲୋଙନ୍‌ ଡକୋତଞ୍ଜି, ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ ଜିର୍ତାୟ୍‌ । ମଡ଼ିର୍‌ ଆପେୟ୍‌, ଅଙ୍ଗା ଆଞୁମ୍‌ ଆମନ୍‌ ଞେନ୍‌ ଅବ୍‌ଞୁମ୍‌ଲିଁୟ୍‌ ତି ଅଞୁମ୍‌ନମ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଡୋବାଜି, ଆମନ୍‌ ଡ ଞେନ୍‌ ଏଙ୍ଗାଲେ ଆବୟନ୍‌, ଆନିଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେ ଆବୟନ୍‌ ଡେଏତଜି । ");
INSERT INTO juy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ଆନିଞ୍ଜି ସରିନ୍‌ ଡରକୋଲନାଞନ୍‌ ଆଡିଡ୍‌ ଅଙ୍ଗା ଆଞୁମ୍‌ ଆମନ୍‌ ଞେନ୍‌ ଅବ୍‌ଞୁମ୍‌ଲିଁୟ୍‌ ତି ଅଞୁମ୍‌ନମ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଡୋବ୍‌ଲାଜି; ଆରି ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡେଡମେ ତିଆସନ୍‌, ‘ସନେଡନ୍‌ ଆ ଅନ୍‌ଜି ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଜା ଅବୟ୍‌ନେ ଅଃସେଏଡ୍‌ଲଜି ।’ ");
INSERT INTO juy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ବନ୍‌ଡ ନମି ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ ଇୟ୍‌ତାୟ୍‌, ଆରି ଆ ଉଗର୍‌ଲୋଙଞ୍ଜି ସର୍ଡାଞେନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅଲ୍‌ବରିଜେ, ତିଆସନ୍‌ ଞେନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଡକୋନ୍‌ ଆଡିଡ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ବର୍ତନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବର୍ନେନମ୍‌ ତିୟ୍‌ଲାଜି, ଆରି ପୁର୍ତିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଏଡ଼ୁର୍‌ମଡ୍‌ତଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଏଙ୍ଗାଲେ କେନ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ତଡ୍‌, ତିଅନ୍ତମ୍‌ ଆନିଞ୍ଜି କେନ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ଆମନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ଓରୋଙାଜି ଗାମ୍‌ଲେ ଞେନ୍‌ ଅଃପ୍ପାର୍ତନାନାୟ୍‌, ବନ୍‌ଡ ଆନିଞ୍ଜିଆଡଙ୍‌ ସନୁମନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡୋବାଜି ଗାମ୍‌ଲେ ପାର୍ତନାତନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ଞେନ୍‌ ଏଙ୍ଗାଲେ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ଅଃଡ୍ଡୁଙ୍‌ଲନାୟ୍‌, ତିଅନ୍ତମ୍‌ ଆନିଞ୍ଜି ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ଅଃଡ୍ଡୁଙ୍‌ଲନାଜି । ");
INSERT INTO juy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ଆଜାଡ଼ି ବର୍ନେନମ୍‌ ବାତ୍ତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ମବ୍‌ଡ଼ିରାଜି, ବର୍ନେନମ୍‌ ଆଜାଡ଼ିନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଙ୍ଗାଲେ ପୁର୍ତିନ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌, ଞେନ୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ପୁର୍ତିନ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ଆରି, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ନିୟ୍‌ ଆଜାଡ଼ିନ୍‌ ବାତ୍ତେ ଅଲ୍‌ମଡ଼ିରେଜି, ତିଆସନ୍‌ ଞେନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ମବ୍‌ଡ଼ିର୍‌ଡମ୍‌ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ଞେନ୍‌ କେନ୍‌ଆନିଞ୍ଜି ତୁମ୍‌ ଆସନ୍‌ ଅଃପ୍ପାର୍ତନାନାୟ୍‌, ଆ ବର୍ନେଞ୍ଜି ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନାଜି ଅମଙ୍‌ଞେନ୍‌ ଡର୍ତଞ୍ଜି, ଆନିଞ୍ଜି ଆସନ୍‌ ନିୟ୍‌ ପାର୍ତନାତନାୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆବୟନ୍‌ ଡେଏଜି, ତିଆସନ୍‌ ଞେନ୍‌ ପାର୍ତନାତନାୟ୍‌; ଏ ଆପେୟ୍‌, ଆମନ୍‌ ଏଙ୍ଗାଲେ ଅମଙ୍‌ଞେନ୍‌ ଡକୋତନେ ଆରି ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ ଡକୋତନାୟ୍‌, ଆନିଞ୍ଜି ନିୟ୍‌ ତିଅନ୍ତମ୍‌ ଅମଙ୍‌ଲେନ୍‌ ଡକୋନେତଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ଗାମ୍‌ଲେ ପୁର୍ତିନ୍‌ ଡର୍ତନେ । ");
INSERT INTO juy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ଆମନ୍‌ ଡ ଞେନ୍‌ ଏଙ୍ଗାଲେ ଆବୟନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ଆବୟନ୍‌ ଅନମ୍ମେନ୍‌ ଆସନ୍‌, ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗା ଗନୁଗୁ ପନେମେଙ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ତିଆତେ ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆନିଞ୍ଜି ଆବୟନ୍‌ ଅଲ୍‌ଡେଏଜି, ତିଆସନ୍‌ ଆମନ୍‌ ଏଙ୍ଗାଲେ ଅମଙ୍‌ଞେନ୍‌ ଡକୋତନେ, ଞେନ୍‌ ଏତ୍ତେଲେ ଆମଙଞ୍ଜି ଡକୋତନାୟ୍‌ । ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌, ଆରି ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଏଙ୍ଗାଲେ ଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ଆମନ୍‌ ଏତ୍ତେଲେ ଡୁଙ୍‌ୟମ୍‌ତଜି ଗାମ୍‌ଲେ ପୁର୍ତିନ୍‌ ଜନାତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ଏ ଆପେୟ୍‌, ଆନାଜିଆଡଙ୍‌ ଆମନ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ଞେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକୋତନାୟ୍‌, ଆନିଞ୍ଜି ନିୟ୍‌ ତେତ୍ତେ ଡକୋଡାଲନ୍‌, ଅଙ୍ଗା ଗନୁଗୁ ପନେମେଙ୍‌ ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ଲିଁୟ୍‌ ତିଆତେ ଆନିଞ୍ଜି ଗିଜେତଜି, କେନ୍‌ଆତେ ଲନଡୟ୍‌ଞେନ୍‌ । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପୁର୍ତିନ୍‌ ଆଗ୍ରଡେଲେନ୍‌ ଆ ଆମ୍ମୁଙ୍‌ ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ଏ ଡରମ୍ମମର୍‌ ଆପେୟ୍‌, ପୁର୍ତିନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜନାଏ, ବନ୍‌ଡ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଜନାତମ୍‌, ଆରି ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ଗାମ୍‌ଲେ କେନ୍‌ଆନିଞ୍ଜି ଜନାଜି । ");
INSERT INTO juy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ଆମନ୍‌ ଅଙ୍ଗା ଡନୁଙ୍‌ୟମ୍‌ ବାତ୍ତେ ଞେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ଲିଁୟ୍‌, ତିଆତେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମଙଞ୍ଜି ଡକୋତେ, ଆରି ଞେନ୍‌ ଆମଙଞ୍ଜି ଡକୋତନାୟ୍‌, ତିଆସନ୍‌ ଞେନ୍‌ ଅଞୁମ୍‌ନମ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାଲାଜି ଆରି ଅବ୍‌ଜନାତାଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","କେନ୍‌ ଆ ପାର୍ତନା ସାଡ୍‌ଲେ ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ କିଦ୍ରୋଣ ସନ୍ନା ଅଲନ୍‌ ଆ ଅଡିଗଡ୍‌ ଜିରେଞ୍ଜି । ତେତ୍ତେ ଅବୟ୍‌ କୋତ୍ତାନ୍‌ ଡକୋଏନ୍‌ ତି ଆ କୋତ୍ତାଲୋଙ୍‌ ଆନିଞ୍ଜି ଇୟ୍‌ଲେ ଗନେଜି । ");
INSERT INTO juy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ଅଙ୍ଗା ଜିଉଦା ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌, ଆନିନ୍‌ ନିୟ୍‌ ତେତ୍ତେ ଆଜନା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିସୁନ୍‌ ଜବ୍ର ତର ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ତେତ୍ତେ ଇୟିୟ୍‌ଲଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ତିଆସନ୍‌, ଜିଉଦାନ୍‌ ବଡଡ଼ ସିପ୍ପାୟଞ୍ଜି ଆରି ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ପାରୁସିଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି ଆ ସିପ୍ପାୟ୍‌ଜିଆଡଙ୍‌ ତେତ୍ତେ ଓରୋଙେଞ୍ଜି । ଆନିଞ୍ଜି ପିଙ୍କନ୍‌, ବଡ଼ାତୋଡନ୍‌ ଆରି ଅତିଆରଞ୍ଜି ଞମ୍‌ଲେ ତେତ୍ତେ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇନିଜି ଇନିଜି ଡେରୟ୍‌ତେ ତି ଅଡ଼୍‌କୋନ୍‌ ଆନିନ୍‌ ଜନାଏନ୍‌ । ତିଆସନ୍‌ ଆନିନ୍‌ ଅବ୍ବାମ୍ମୁଙ୍‌ଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, “ଆମ୍ୱେଞ୍ଜି ଆନାଆଡଙ୍‌ ଏସାୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ଆନିଞ୍ଜି ଜାଲଙେଞ୍ଜି, “ନାଜରିତ ଜିସୁନ୍‌ଆଡଙ୍‌ ।” ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଆନିନ୍‌ ।” ଅଙ୍ଗା ଜିଉଦା ଜିସୁନ୍‌ଆଡଙ୍‌ ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟେନ୍‌ ଆନିନ୍‌ ନିୟ୍‌ ତେତ୍ତେ ଆନିଞ୍ଜି ସରିନ୍‌ ଆତନଙ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“ଞେନ୍‌ ଆନିନ୍‌” ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆବର୍ରେଞ୍ଜି, ଆନିଞ୍ଜି ମଡ଼୍‌କିଣ୍ଡୋଙ୍‌ ଡେଲ୍ଲନ୍‌ ଜାୟ୍‌ତାନ୍‌ ଗୋଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ସିଲତ୍ତେ ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରି ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଆନାଆଡଙ୍‌ ଏସାୟ୍‌ତେ ?” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ନାଜରିତ ଜିସୁନ୍‌ଆଡଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ଜିସୁନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଆନିନ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଞେନ୍‌ ବର୍ରବେନ୍‌ । ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଏସାୟ୍‌ଡଙ୍‌ତିଁୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ବାଜି, ଆନିଞ୍ଜି ଜିରେତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ତିଆସନ୍‌ ଆନିନ୍‌ ଆବର୍ରନେନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଡେଡମେନ୍‌, “ଆନାଜିଆଡଙ୍‌ ଆମନ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଜା ଅବୟ୍‌ନେଆଡଙ୍‌ ଞେନ୍‌ ଅଃନ୍ନବ୍‌ଆଡ଼ଲଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ସିମନ୍‌ ପିତ୍ରନ୍‌ ଆମଙ୍‌ ଅବୟ୍‌ କଡ଼ିବନ୍‌ ଡକୋଏନ୍‌ । ଆନିନ୍‌ ତିଆତେ ତବ୍‌ଲେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ କମ୍ୱାରିମର୍‌ଆଡଙ୍‌ ଅଡ୍‌ଲେ ଆର୍ଜଡ଼ୋମ୍‌ଲୁଡନ୍‌ ଗଡ୍‌ଲେ ସେଡେନ୍‌; ତି ଆ କମ୍ୱାରିମର୍‌ ଆଞୁମ୍‌ ମାଲ୍‌କ । ");
INSERT INTO juy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ସିଲତ୍ତେ ଜିସୁନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କଡ଼ିବନ୍‌ କାପଲୋଙନ୍‌ ଡକ୍କୋଆ, ଆପେୟନ୍‌ ଅଙ୍ଗା ସିମ୍ମା ଞେନ୍‌ଆଡଙ୍‌ ତିୟ୍‌ଲିଁୟ୍‌, ଞେନ୍‌ ଇନି ତି ଆ ସିମ୍ମାଲୋଙ୍‌ ସିଲଡ୍‌ ଅଃଗାଆୟ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସିପ୍ପାୟଞ୍ଜି, ସୋଡ଼ା ସିପ୍ପାୟନ୍‌, ଡ ଜିଉଦିମରଞ୍ଜି ଆ ସିପ୍ପାୟ୍‌ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମେଞ୍ଜି କି ଜିଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ ଆନାନନ୍‌ ଆମଙ୍‌ ଓରୋଙେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆ ବର୍ସେଙ୍‌ କାୟାପାନ୍‌ ମୁଡ଼ ରାଓଡ଼ା ଡେଏନ୍‌, ଆରି ଆନାନନ୍‌, କାୟାପାନ୍‌ ଆ କୁଞାର୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆର୍ରବୁତେନ୍‌ ସୁକ୍କା, ଗାମ୍‌ଲେ କେନ୍‌ ଆ କାୟାପା ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ଞଙ୍‌ଞଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ସିମନ୍‌ ପିତ୍ରନ୍‌ ଡ ଆରି ଅବୟ୍‌ନେ ଞଙ୍‌ନେମର୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି । ତି ଆ ଞଙ୍‌ନେମର୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆଅମ୍ମଡ୍‌ ଡକୋଏନ୍‌, ତିଆସନ୍‌ ଆନିନ୍‌ ଜିସୁନ୍‌ ସରିନ୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆସିଂ ଆ ଡାଣ୍ଡ ଜିରେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଡୁଆରାନ୍‌ ଗରନ୍ନେନ୍‌ ଆ ତୁୟାୟ୍‌ ତନଙ୍‌ଲେ ଡକୋଲନ୍‌ । ତିଆସନ୍‌ ଅଙ୍ଗା ଞଙ୍‌ନେମର୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆଅମ୍ମଡ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ଡୁଆରାନ୍‌ ଜିର୍ରେ ଗରନ୍ନେନ୍‌ ଆଜ୍ରଗେତେନ୍‌ ଆ କମ୍ୱାରିବୟ୍‌ଆଡଙ୍‌ ବର୍ରେ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଅମ୍ମନ୍‌ ଓରୋଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ସିଲତ୍ତେ ତି ଗରନ୍ନେନ୍‌ ଆଜ୍ରଗେଏନ୍‌ ଆ କମ୍ୱାରିବୟ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ନିୟ୍‌ ତି ଆ ମନ୍‌ରା ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ତଡ୍‌ ପଙ୍‌ ?” ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ଇଜ୍ଜା, ଞେନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ରଙାନ୍‌ ଆସନ୍‌ କମ୍ୱାରିମରଞ୍ଜି ଡ ତଙିୟ୍‌ସିପ୍ପାୟଞ୍ଜି ତଗୋନ୍‌ ସୟ୍‌ଲେ ତେତ୍ତେ ତନଙ୍‌ଡାଲେ ତଗୋଲୋଙନ୍‌ ଞଡ୍‌ଞଡ୍‌ଲଞ୍ଜି; ପିତ୍ରନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ତେତ୍ତେ ତନଙ୍‌ଡାଲେ ତଗୋଲୋଙନ୍‌ ଞଡ୍‌ଞଡ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆ ବର୍ନେ ଡ ଆ ଞନଙନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ସେକ୍କୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଅବ୍‌ଗିୟ୍‌ତାଲନ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ଲାୟ୍‌; ଅଙ୍ଗାଲୋଙ୍‌ ଅଡ଼୍‌କୋ ଜିଉଦିମରଞ୍ଜି ରୁକ୍କୁତଞ୍ଜି, ରନୁକ୍କୁସିଂଲୋଙନ୍‌ ଡ ସରେବାସିଂଲୋଙନ୍‌ ଞେନ୍‌ ଡିତାନ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ଲାୟ୍‌; ଅବ୍‌ସସଲନ୍‌ ଞେନ୍‌ ଇନ୍ନିଙ୍‌ ଅଃବ୍ବର୍ରନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ସେକ୍କୁତିଁୟ୍‌ ? ଆନାଜି ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙେଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ବରାଜି; ଗିଜା, ଞେନ୍‌ ଇନିଜି ଗାମ୍‌ଲାୟ୍‌, ଆନିଞ୍ଜି ତି ଅଡ଼୍‌କୋନ୍‌ ଆଜନାଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ଜିସୁନ୍‌ ଏନ୍ନେଲେ ଆବର୍ରନେନ୍‌ ତଙିୟ୍‌ସିପ୍ପାୟଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ତି ଆ ତୁୟାୟ୍‌ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲନ୍‌ ଅବୟ୍‌ନେ, ଜିସୁନ୍‌ଆଡଙ୍‌ ବତନାଡ୍‌ ତାଡ୍‌ଲେ ବରେନ୍‌, “ଆମନ୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ଆଡଙ୍‌ ଏନ୍ନେଲେ ଜାଲଙ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଞେନ୍‌ ପରାନ୍‌ସାତ୍ତିବରନ୍‌ ବର୍ରନାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତି ପରାନ୍‌ସାତ୍ତିବରନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ତେମଡ୍‌ଲୋଙ୍‌ ସାକିନ୍‌ ତିୟ୍‌ବା; ଞେନ୍‌ ମନଙ୍‌ବରନ୍‌ ବର୍ରନାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ତିଡ୍‌ତିଁୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନାନନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆଏଡେତ୍ତେନ୍‌ ଆଜିବାଡନ୍‌ କାୟାପା ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆମଙ୍‌ ଆପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ସିମନ୍‌ ପିତ୍ରନ୍‌ ତେତ୍ତେ ତନଙ୍‌ଡାଲେ ତଗୋଲୋଙନ୍‌ ଆଞ୍ରଃଞଲ୍ଲନ୍‌ ଆଡିଡ୍‌ ତେତ୍ତେ ଆ ମନ୍‌ରାଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମନ୍‌ ନିୟ୍‌ ତି ଆ ମନ୍‌ରା ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ତଡ୍‌ ପଙ୍‌ ?” ବନ୍‌ଡ ଆନିନ୍‌ ମୁର୍ସେଡାଲେ ବର୍ରନେ, “ଇଜ୍ଜା, ଞେନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ କମ୍ୱାରିମର୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ପିତ୍ରନ୍‌ ଅଙ୍ଗା କମ୍ୱାରିମର୍‌ ଆଲୁଡ୍‌ ଗଡେନ୍‌, ତି ଆ କମ୍ୱାରିମର୍‌ ଆ କୁଲମ୍‌ ଅବୟ୍‌ନେ ବର୍ରନେ, “ତି କୋତ୍ତାଲୋଙନ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଞେନ୍‌ ଅଃଗିୟ୍‌ଲମ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ପିତ୍ରନ୍‌ ଆରି ମୁର୍ସେଡାଲେ ବର୍ରନେ, “ଇଜ୍ଜା, ଞେନ୍‌ ତଡ୍‌,” ଆରି ତେରଙ୍‌ କମ୍‌ସିମନ୍‌ ଓଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ କାୟାପାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ରାଜାସିଙନ୍‌ ଓରୋଙେଞ୍ଜି; ଜିଉଦିମରଞ୍ଜି ଅନେଲାୟ୍‌ପୁରନ୍‌ ପାଡ଼େନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଡେଡଙ୍‌ଜି ତଡ୍‌, ତିଆସନ୍‌ ଆନିଞ୍ଜି ରାଜାସିଙନ୍‌ ଅଃଗନ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ତିଆସନ୍‌ ପିଲାତନ୍‌ ଆମଙଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “କେନ୍‌ ଆ ମନ୍‌ରା ଆ ବିରୁଦଲୋଙନ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନି ଏକାୟ୍‌କାୟ୍‌ତିଁୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ଆନିଞ୍ଜି ପିଲାତନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “କେନ୍‌ ଆ ମନ୍‌ରା ଡୋସା କାବ୍ବାଡ଼ାନ୍‌ ଅଃଲ୍ଲୁମ୍‌ଲୋ ନଙ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଅମଙ୍‌ନମ୍‌ ଏଃନ୍ନୋରୋଙାୟ୍‌ ବନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ବନାଁୟ୍‌ବର୍‌ବେନ୍‌ ଅନ୍ତମ୍‌ ଇୟ୍‌ନବ୍‌ପନ୍‌ସୁଆତିବା ।” ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଅମଙ୍‌ଲେନ୍‌ ସନୋଡ଼ାନେନ୍‌ ଅବୟ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ଆନିନ୍‌ ଏଙ୍ଗାଡାଲେ ରବୁତେ, ତି ଆ ବର୍ନେ ଜିସୁନ୍‌ ଅଙ୍ଗାତେ ବର୍ରନେ, ତିଆତେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡେଡମେ, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଏତ୍ତେଲେ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ପିଲାତନ୍‌ ଆରି ଅମ୍ମ ରାଜାସିଙନ୍‌ ୟର୍ରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ବରେନ୍‌, “ଆମନ୍‌ ପଙ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ରାଜା ?” ");
INSERT INTO juy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ଡମ୍‌ କେନ୍‌ଆତେ ବର୍ତନେ, ଅଡ଼େ ଆନ୍ନିଙ୍‌ ବର୍ନେଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ରମ୍‌ଜି ?” ");
INSERT INTO juy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପିଲାତନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଅବୟ୍‌ ଜିଉଦିମର୍‌ ପଙ୍‌ ? ମନ୍‌ରାନମ୍‌ଜି ଡ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ଅସିଲୋଙ୍‌ଞେନ୍‌ ସୋରୋପ୍ପାୟ୍‌ଲମ୍‌ଜି, ଆମନ୍‌ ଇନି ଲୁମେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ରାଜ୍ୟଞେନ୍‌ କେନ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ତଡ୍‌, କେନ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ରାଜ୍ୟଞେନ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ସନଣ୍ଡୋଙ୍‌ମର୍‌ଞେଞ୍ଜି ଡନେଲୋଙ୍‌ଞେନ୍‌ ତନଙ୍‌ଡାଲେ ଅଲ୍‌ତିଡ୍‌ବାନ୍‌ ଡୁଙ୍‌ତଞ୍ଜି ବନ୍‌, ଆରି ଜିଉଦିମରଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ଅଃର୍ରପ୍ତିଇଁୟ୍‌ଜି ବନ୍‌ । ବନ୍‌ଡ ଇଜ୍ଜା, ରାଜ୍ୟଞେନ୍‌ କେନ୍‌ ତେନ୍ନେ ସିଲଡ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ତିଆସନ୍‌ ପିଲାତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଅବୟ୍‌ ରାଜା ପଙ୍‌ ?” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ତିଆତେ ଆମନ୍‌ ବର୍ତନେ, ଞେନ୍‌ ଅବୟ୍‌ ରାଜା । ଆଜାଡ଼ିନ୍‌ ଆ ଡନେଲୋଙ୍‌ ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ କରୋକ୍କୋଡନ୍‌ ଡେଲେ, ଞେନ୍‌ କେନ୍‌ ପୁର୍ତିନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ଆନାଜି ଆଜାଡ଼ିନ୍‌ ଆ ଡନେଲୋଙ୍‌ ଡକୋଜି, ଆନିଞ୍ଜି ସର୍ରଙ୍‌ଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ପିଲାତନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆଜାଡ଼ିନ୍‌ ଇନି ?” ପିଲାତନ୍‌ ଏନ୍ନେଲେ ବର୍ରନ୍‌ କି ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ, ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, “ପନବ୍‌ରଡନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ କେନ୍‌ ଆମଙନ୍‌ ଞେନ୍‌ ଅନ୍ନିଙ୍‌ ଆ ଡୋସା ଅଃଞାଙାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“ବନ୍‌ଡ ଏଲାୟ୍‌ପୁର୍‌ ଇଙନ୍‌ ଞେନ୍‌ ଅବୟ୍‌ ଆବଣ୍ଡିମରନ୍ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଅମ୍‌ରେଙ୍‌ତାୟ୍‌, କେନ୍‌ଆତେ ଅନଗଡ୍‌ଲୋଙ୍‌ବେନ୍‌ ଡକୋ, ତିଆସନ୍‌ ଞେନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ରାଜାଆଡଙ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି ଲଡୟ୍‌ତବେନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ଆନିଞ୍ଜି ଆରି ସଜିର୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “ଇଜ୍ଜା, କେନ୍‌ ଆ ମନ୍‌ରା ତଡ୍‌, ଆର୍ପାୟ୍‌ ବାରବ୍ବାନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙା ।” କେନ୍‌ ଆ ବାରବ୍ବା ଅବୟ୍‌ ସକାମର୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପିଲାତନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ସାମକାନ୍‌ ବାତ୍ତେ ଅବ୍‌ତିତ୍ତିଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ସିପ୍ପାୟଞ୍ଜି ଅବ୍ବାଙନ୍‌ ବାତ୍ତେ ରନୁବ୍ବବନ୍‌ ତୁବ୍‌ଲେ ଜିସୁନ୍‌ ଆବବ୍‌ଲୋଙ୍‌ ଅବ୍‌ରୁବ୍ବବେଞ୍ଜି, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ଲୁଲୁ ଅଙ୍ଗିନ୍‌ ଅବ୍‌ରଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ଆନିଞ୍ଜି ଆମଙନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଏ ଜିଉଦିମରଞ୍ଜି ଆ ରାଜା, ଲୋମ୍‌ତମ୍‌ !” ଗାମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ତାଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ପିଲାତନ୍‌ ଆରି ଡୁଆରାନ୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, “ଗିୟ୍‌ବା, ରନବୁ ପନବ୍‌ରଡନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ଅନ୍ନିଙ୍‌ ଆ ଡୋସା ଅଃଞାଙାୟ୍‌, କେନ୍‌ଆତେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଜନାତେ, ତିଆସନ୍‌ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ଅମଙ୍‌ବେନ୍‌ ଓରୋଙ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ସିଲତ୍ତେ ଜିସୁନ୍‌ ତି ଅବ୍ବାଙ୍‌ ରନୁବ୍ବବନ୍‌ ଡ ଅଣ୍ଡାରାୟ୍‌ଗନ୍‌ ଆ ସିନ୍‌ରି ରଲନ୍‌ ଡୁଆରାନ୍‌ ଜିର୍ରାୟ୍‌ । ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “କେରେ ଗିୟ୍‌ବା ତି ଆ ମନ୍‌ରା !” ");
INSERT INTO juy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ତିଆସନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଡ ତଙିୟ୍‌ସିପ୍ପାୟଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ସଜିର୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ବା, ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ବା ।” ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଇୟ୍‌ନମ୍‌ଡାୟ୍‌ବା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ସିଲଡ୍‌ ଅନ୍ନିଙ୍‌ ଆ ଡୋସା ଅଃଞାଙ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ଜିଉଦିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ବନାଁୟ୍‌ବର୍‌ଲେନ୍‌ ଅବୟ୍‌ ଡକୋ, ତି ଆ ବନାଁୟ୍‌ବର୍‌ ଅନ୍ତମ୍‌ ଆନିନ୍‌ ରନବୁ ପନବ୍‌ରଡନ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌, ଞେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଗାମ୍‌ଡମ୍‌ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ପିଲାତନ୍‌ କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆକ୍ରାନ୍‌ ବତଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ଆନିନ୍‌ ଆରି ଅମ୍ମ ରାଜାସିଙନ୍‌ ଗନ୍‌ଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ସିଲଡ୍‌ ଜିର୍ରାୟ୍‌ ?” ବନ୍‌ଡ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃଜ୍ଜାଲଙ୍‌ଲୋ ");
INSERT INTO juy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ସିଲତ୍ତେ ପିଲାତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ସରିନ୍‌ ଅଃକ୍କଡାଡ଼ିନେ ପଙ୍‌ ? ଆମନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଆସନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସନୋଡ଼ାନେନ୍‌ ଡକୋ ଆରି ଆମନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅନମ୍‌ଡାଜନ୍‌ ଆସନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ସନୋଡ଼ାନେନ୍‌ ଡକୋ, କେନ୍‌ଆତେ ଆମନ୍‌ ଜନା ତଡ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଇସ୍ୱରନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅନଡ଼େନ୍‌ ଅଃତ୍ତିୟ୍‌ଲମ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ବିରୁଦଲୋଙ୍‌ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ ଇନ୍ନିଙ୍‌ ସନୋଡ଼ାନେନ୍‌ ଅଃଡ୍ଡକୋଏ ବନ୍‌; ତିଆସନ୍‌ ଆନା ଞେନ୍‌ଆଡଙ୍‌ ଅସିଲୋଙ୍‌ନମ୍‌ ସୋରୋପ୍ପାୟ୍‌ଲିଁୟ୍‌ ଆ ଇର୍ସେନ୍‌ ବବରନ୍ତଙନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ତିଆସନ୍‌ ପିଲାତନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଆସନ୍‌ ଏରେନ୍‌ ଗୋଜେନ୍‌, ବନ୍‌ଡ ଜିଉଦିମରଞ୍ଜି ସଜିର୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “ଆମନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଅମ୍‌ରେଙେନ୍‌ ଡେନ୍‌, ଆମନ୍‌ କାଇସରନ୍‌ ଆ ଗଡ଼ି ତଡ୍‌; ଆନା ଆନିନ୍‌ଡମ୍‌ ରାଜା ଗାମ୍‌ଡମ୍‌ତନେ, ଆନିନ୍‌ କାଇସରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ବର୍ତନେ ।” ");
INSERT INTO juy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","କେନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ପିଲାତନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଡୁଆରାନ୍‌ ଓରୋଙ୍‌ଡାଲେ “ଅରେଙ୍‌ପିନ୍‌” ତିଆତେ ଏବ୍ରି ଲଙ୍‌ଲଙ୍‌ଲୋଙନ୍‌ “ଗବ୍‌ବତା” ଗାମ୍‌ଲେ ବର୍ତଞ୍ଜି, ତେତ୍ତେ ତି ପନ୍‌ସୁଆତି ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ତଙ୍କୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ତି ଆ ଡିନ୍ନା ଅନେଲାୟ୍‌ପୁରନ୍‌ ଆସନ୍‌ ଅନବ୍‌ଜାଡା ଡିନ୍ନା ଡକୋଏନ୍‌, ଆରି ତିଆଡିଡ୍‌ ଓୟୋଙନ୍‌ ତଡ଼ିଙ୍‌ ତମ୍‌ବାନ୍‌ । ପିଲାତନ୍‌ ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଗିୟ୍‌ବା, ରାଜାବେନ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ତିଆସନ୍‌ ଆନିଞ୍ଜି ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “ଆନିନ୍‌ଆଡଙ୍‌ ରବ୍ବୁବା, ଆନିନ୍‌ଆଡଙ୍‌ ରବ୍ବୁବା, ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାୟ୍‌ବା ।” ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ରାଜାବେନ୍ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜାୟ୍‌ ପଙ୍‌ ?” ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “କାଇସରନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆନ୍ନିଙ୍‌ ଆରି ରାଜାଲେନ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅନମ୍‌ଡାଜନ୍‌ ଆସନ୍‌ ପିଲାତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆସିଲୋଙଞ୍ଜି ସୋରୋପ୍ପାୟେଞ୍ଜି । ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ଜିସୁନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଆଅକ୍କାଡଙନ୍‌ ବୋୟ୍‌ଲେ “ଆଇଡାଡ଼ା” ଗାମ୍‌ଲେ ଅବୟ୍‌ ଜାଗାଲୋଙନ୍‌ ପାଙେନ୍‌, ତିଆତେ ଏବ୍ରି ଲଙ୍‌ଲଙ୍‌ଲୋଙନ୍‌ “ଗଲ୍‌ଗତା” ଗାମ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ତେତ୍ତେ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି, ଆରି ଆନିନ୍‌ ସରିନ୍‌ ବାଗୁ ମନ୍‌ରା, ଅବୟ୍‌ନେ ବାନ୍ନେଗଡ୍‌ ଆରି ଅବୟ୍‌ନେ ଅଡିଗଡ୍‌, ଜିସୁନ୍‌ଆଡଙ୍‌ ମଡ୍ଡିନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ପିଲାତନ୍‌ ଅବୟ୍‌ ଅରବ୍‌ଜନାଅଲନ୍‌ ଇଡ୍‌ଲେ ତୋଣ୍ଡୋ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ୟୋଡେନ୍‌ । ତେତ୍ତେ “ନାଜରିତ ଜିସୁନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ରାଜା” ଗାମ୍‌ଲେ ଆଇଡିଡ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ନେ କେନ୍‌ ଅରବ୍‌ଜନାଅଲନ୍‌ ପଡ଼େଲଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି, ତିଆତେ ଗଡ଼ାନ୍‌ ଆ ତୁୟାୟ୍‌ ଡକୋଏନ୍‌, ତି ଆ ଅଲା ଏବ୍ରି, ଲାଟିନ୍‌ ଆରି ଗ୍ରିକ୍‌ ଲଙ୍‌ଲଙ୍‌ଲୋଙନ୍‌ ଆଇଡିଡ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ତିଆସନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ସୋଡ଼ା ରାଓଡ଼ାଜି ପିଲାତନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି “ଜିଉଦିମରଞ୍ଜି ଆ ରାଜା ଗାମ୍‌ଲେ ଏର୍‌ନିଡ୍‌ଡାଲେ ଆର୍ପାୟ୍‌ ‘ଞେନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ରାଜା,’ ଗାମ୍‌ଲେ କେନ୍‌ଆନିନ୍‌ ବର୍ରନେ ଗାମ୍‌ଲେ ଇଡା ।” ");
INSERT INTO juy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ପିଲାତନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଞେନ୍‌ ଅଙ୍ଗାତେ ଇଡ୍‌ଲାୟ୍‌, ତିଆତେ ମା ଡକୋନେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ସିପ୍ପାୟଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଆରମ୍‌ଡାଜେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଉଞ୍ଜି ସିପ୍ପାୟଞ୍ଜି ଆ ସିନ୍‌ରିନ୍‌ ପାଙ୍‌ଲେ ଉଞ୍ଜି ବନ୍ତା ଏମ୍ମେଏଞ୍ଜି, ଡିଲେ ସିପ୍ପାୟଞ୍ଜି ଆସନ୍‌ ବ ବନ୍ତା ଲେକାଁୟ୍‌ ବନ୍ତାଲଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ଆ ଅଙ୍ଗିନ୍‌ ନିୟ୍‌ ପାଙେଞ୍ଜି । ତି ଆ ଅଙ୍ଗି ଆବୟ୍‌ବୟ୍‌ ତଡ୍‌, ତୋଣ୍ଡୋନ୍‌ ସିଲଡ୍‌ ଜାୟ୍‌ତାନ୍‌ ସମ୍ପରାନ୍‌ ଆପଡ୍‌ପଡ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ତିଆସନ୍‌ ସିପ୍ପାୟଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି, “ଇଜ୍ଜା, କେନ୍‌ଆତେ ଅଃପ୍ପେବୋ, ବନ୍‌ଡ କେନ୍‌ଆତେ ଆନାଆତେ ଡେତେ, ତିଆସନ୍‌ ଏବ୍‌କଡ଼ିବା,” ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆ କେନ୍‌ ବର୍ନେ ଡେଡମେ; “ଆନିଞ୍ଜି ସିନ୍‌ରିଞେନ୍‌ ବନ୍ତାଲଞ୍ଜି, ଆରି ଅଙ୍ଗିଞେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ଅବ୍‌କଡ଼ିଏଞ୍ଜି ।” ତିଆସନ୍‌ ସିପ୍ପାୟଞ୍ଜି କେନ୍‌ଆତେ ଲୁମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ଜିସୁନ୍‌ ଆଅକ୍କାଡଙ୍‌ ଆ ତୁୟାୟ୍‌ ଆୟୋଙନ୍‌ ମରିଅମନ୍‌, ଆୟୋଙନ୍‌ ଆ ବୋଲ୍‌ମାୟ୍‌, କ୍ଲେପାନ୍‌ ଆ ଡୁକ୍ରି ମରିଅମନ୍‌ ଡ ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌ ଆତନଙ୍‌ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ଜିସୁନ୍‌, ଆୟୋଙନ୍‌ ଡ ଅଙ୍ଗା ଞଙ୍‌ନେମର୍‌ଆଡଙ୍‌ ଆନିନ୍‌ ଡୁଙ୍‌ୟମେନ୍‌, ଆନିଞ୍ଜି ତେତ୍ତେ ଆତନଙଞ୍ଜି ଗିୟ୍‌ଲେ, ଆୟୋଙନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଗିଜା, ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ତି ଆ ଞଙ୍‌ନେମର୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଗିଜା, ଅୟୋଙ୍‌ନମ୍‌ !” ତି ଆ ଞଙ୍‌ନେମର୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆସିଙନ୍‌ ଓରୋଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ନମି ଅଡ଼୍‌କୋନ୍‌ ସୁଜ୍ଜେଏନ୍‌ ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଜନାଡାଲେ, ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆ ବର୍ନେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଡେଡମେ, ତିଆସନ୍‌ ଆନିନ୍‌, “ଞେନ୍‌ ଇର୍ଗାଲ୍‌ଡାତିଁୟ୍‌,” ଗାମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ତେତ୍ତେ ଅବୟ୍‌ ସିମ୍ମାଲୋଙନ୍‌ ସବୁର୍‌ଡାନ୍‌ ଆବରିୟ୍‌ ଡକୋଏନ୍‌, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଅବୟ୍‌ କପାଲୋଙନ୍‌ ସବୁର୍‌ଡାନ୍‌ ଜୋବ୍‌ଡାଡାଲେ ଅବୟ୍‌ ଡାଙ୍ଗୋଲୋଙନ୍‌ ରପଡ୍‌ଲେ ଜିସୁନ୍‌ ଆ ତଅଡ୍‌ଲୋଙ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ତି ସବୁର୍‌ଡାନ୍‌ ଗାଲେ ବର୍ରନେ, “ସୁଜ୍ଜେଏନ୍‌ !” ଆରି ଆନିନ୍‌ ଆବବନ୍‌ ଜାୟ୍‌ତାନ୍‌ ଏମ୍ମେଡାଲେ ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ତି ଆ ଡିନ୍ନା ଅନବ୍‌ଜାଡା ଡିନ୍ନା ଆଡ୍ରକୋଏନ୍‌, ମରାଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ତୋଣ୍ଡୋ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଡକୋଡଙେ ତଡ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆ ଲୋଲୋନେ ଡିନ୍ନା ସୋଡ଼ା ଲୋଲୋନେ ଡିନ୍ନା ଡକୋଏନ୍‌, ତିଆସନ୍‌ ଆଜଙଞ୍ଜି ଲବ୍‌ଗଡ୍‌ନେତୋ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆନ୍ନାଲୋଙ୍‌ ପାଙ୍‌ନେତୋ, ଗାମ୍‌ଲେ ଜିଉଦିମରଞ୍ଜି ପିଲାତନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ତିଆସନ୍‌, ସିପ୍ପାୟଞ୍ଜି ଜିର୍ରେ ଜିସୁନ୍‌ ସରିନ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଆରମ୍‌ଡାଜେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆଜଙ୍‌ ଲବ୍‌ଗଡାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ବନ୍‌ଡ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆମଙ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଞ୍ଜି, ଆନିନ୍‌ ରବୁଏନ୍ନି ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆଜଙ୍‌ ଅଃଲ୍ଲବ୍‌ଗଡ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ବନ୍‌ଡ ସିପ୍ପାୟଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ସେଲାନ୍‌ ବାତ୍ତେ ଜିସୁନ୍‌ ଆ ପକ୍କାଲୋଙ୍‌ ପଏନ୍‌, ଆରି ତେତ୍ତେ ସିଲଡ୍‌ ମିଞାମନ୍‌ ଡ ଡାଆନ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ଅଙ୍ଗା ମନ୍‌ରା କେନ୍‌ଆତେ ଗିଜେନ୍‌, ଆନିନ୍‌ ଏନ୍ନେଲେ ସାକିନ୍‌ ତିୟେନ୍‌, ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଡର୍ତନେ, ତିଆସନ୍‌ ଆନିନ୍‌ ଆଜାଡ଼ିନ୍‌ ବର୍ରନେ, ଆରି ଆନିନ୍‌ ଆଜାଡ଼ିନ୍‌ ବର୍ତନେ ଗାମ୍‌ଲେ ଆନିନ୍‌ ଜନା । ");
INSERT INTO juy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଡନେଡମନ୍‌ ଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଡେଏନ୍‌, “ଅବୟ୍‌ ଜନଙ୍‌ ଆଜାଙନ୍‌ ଅଃଲ୍ଲବ୍‌ଗଡେଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆରି ଅବୟ୍‌ ବର୍ନେନ୍‌ ଆଇଡିଡ୍‌, “ଆନିଞ୍ଜି ଆନାଆଡଙ୍‌ ପଏଞ୍ଜି, ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଗିୟ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆଡ୍ରେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆରାମାତିୟାବାୟ୍‌ ଜୋସେପନ୍‌ ପିଲାତନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲେ ଜିସୁନ୍‌ ଆ ମରା ପନାଙନ୍‌ ଆସନ୍‌ ଇୟ୍‌ଲେ ବରେ । କେନ୍‌ ଆ ଜୋସେପ ନିୟ୍‌ ଜିସୁନ୍‌ ଆ ସନଣ୍ଡୋଙ୍‌ମର୍‌ ଡକୋଏନ୍‌, ବନ୍‌ଡ ଜିଉଦିମରଞ୍ଜି ଆ ବନ୍ତଙ୍‌ଲୋଙ୍‌ ଆନିନ୍‌ ଅବ୍‌ସସଲନ୍‌ ଡକୋଲନ୍‌ । ପିଲାତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅନଡ଼େନ୍‌ ତିୟେନ୍‌, ଆରି ଜୋସେପନ୍‌ ଜିସୁନ୍‌ ଆ ମରା ତିଲ୍‌ତିଲନ୍‌ ଆସନ୍‌ ପାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ଅଙ୍ଗା ନିକଦିମ ତଗଲନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟେନ୍‌, ଆନିନ୍‌ ତିରିସି କେଜି ଲଙିଡ୍‌ମେନ୍‌ ଆମାୟ୍‌ମାୟନ୍‌ ଅଗୁରୁନ୍‌ ପାଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆ ମରା ପାଙ୍‌ଲେ ଜିଉଦିମରଞ୍ଜି ଆତ୍ରିଲ୍‌ତେଞ୍ଜି ଆନଗଡ୍‌ ଅନ୍ତମ୍‌ ତିଆତେ ଲଙିଡ୍‌ମେନ୍‌ ଜଡ୍‌ଲେ ସରୁ ଲମନ୍‌କାବନ୍‌ ବାତ୍ତେ ବଲେଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ଜିସୁନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଅମ୍‌ଡାଜେଞ୍ଜି, ତେତ୍ତେ ଅବୟ୍‌ କୋତ୍ତାନ୍‌ ଡକୋଏନ୍‌, ଆରି ତି ଆ କୋତ୍ତାଲୋଙ୍‌ ଅବୟ୍‌ ରଙ୍‌ ମସାନ୍ନିନ୍‌ ଡକୋଏନ୍‌, ତି ତେତ୍ତେ ଆଙ୍ଗିୟ୍‌ ଆନ୍ନିଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ତିଲେଜି । ");
INSERT INTO juy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ତିଆସନ୍‌ ତି ଆ ଡିନ୍ନା ଜିଉଦିମରଞ୍ଜି ଅନବ୍‌ଜାଡାନେ ଡିନ୍ନା ଆଡ୍ରକୋଏନ୍‌, ଆନିଞ୍ଜି ତି ତେତ୍ତେ ଆତୁୟାଜନ୍‌ ଜିସୁନ୍‌ ଆ ମରା ତିଲେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ପାଲ୍ଲିନ୍‌ ଆ ପର୍ତମ୍ମୁ ଡିନ୍ନା ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ଲୋଙଡ୍‌ ଲୋଙଡନ୍‌ ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌ ମସାନ୍ନିନ୍‌ ଆରିୟେନ୍‌, ତେତ୍ତେ ଆରେଙ୍‌ ଆଡେଡ୍‌ଡେଡ୍‌ ଇୟ୍‌ଲେ ଗିଜେ । ");
INSERT INTO juy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ତିଆସନ୍‌ ଆନିନ୍‌ ଇରେନ୍‌ କି ସିମନ୍‌ ପିତ୍ରନ୍‌ ଡ ଜିସୁନ୍‌ ଅଙ୍ଗା ଞଙ୍‌ନେମର୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମେନ୍‌ ତି ଆନ୍ନା ଞଙ୍‌ନେମରନ୍‌ ଆମଙ୍‌ ୟର୍ରନେ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ମରିଅମନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି, “ଆନାଜି ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ମସାନ୍ନିନ୍‌ ସିଲଡ୍‌ ପାଙେଞ୍ଜି, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଇୟ୍‌ଲେ ଡକ୍କୋଏଜି, ତିଆତେ ଇନ୍‌ଲେଞ୍ଜି ଜନାଜି ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଡ ତି ଆନ୍ନା ଞଙ୍‌ନେମରନ୍‌ ମସାନ୍ନିନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ଆନିଞ୍ଜି ବାଗୁଞ୍ଜି ଆବସାଣ୍ଡନ୍‌ ଇରେଞ୍ଜି, ଆରି ତି ଆନ୍ନା ଞଙ୍‌ନେମରନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଅବ୍‌ତିକ୍କିଲେ ମସାନ୍ନିଲୋଙନ୍‌ ଆମ୍ମୁଙ୍‌ ତୁଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ଆରି ଆନିନ୍‌ ଡୁଙ୍ଗୁଡାଲେ ଅମ୍ମନ୍‌ ଆଗ୍ରିଜେନ୍‌ ସରୁ ଲମନ୍‌କାବଞ୍ଜି ଆସେଡ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ଅମ୍ମନ୍‌ ଅଃଗନ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ତିକ୍କି ସିମନ୍‌ ପିତ୍ରନ୍‌ ନିୟ୍‌ ଆ ତିକ୍କିଗଡନ୍‌ ଜିର୍ରେ ତୁଙ୍‌ଲାୟ୍‌ କି ଅମ୍ମ ମସାନ୍ନିନ୍‌ ଗନ୍‌ଲେ ଆଗ୍ରିଜେନ୍‌, ସରୁ ଲମନ୍‌କାବଞ୍ଜି ଆସେଡ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ଆରି, ଜିସୁନ୍‌ ଆବବ୍‌ଲୋଙ୍‌ ଅଙ୍ଗା ସିନ୍‌ରି ଆଜିବାଡ୍‌ ଡକୋଏନ୍‌, ତିଆତେ ସରୁ ଲମନ୍‌କାବନ୍‌ ବୟନ୍‌ ଅଃଡ୍ଡକୋଲୋ, ଆନ୍ନାଲୋଙ୍‌ ଆଏଡେଃ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତି ଆନ୍ନା ଞଙ୍‌ନେମରନ୍‌, ଆନା ମସାନ୍ନିଲୋଙନ୍‌ ଆମ୍ମୁଙ୍‌ ତୁଙେନ୍‌, ଆନିନ୍‌ ନିୟ୍‌ ଅମ୍ମନ୍‌ ଗନ୍‌ଲେ ଗିଜେନ୍‌ କି ଡର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌, “ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ ଡୋତନେ,” ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆନିଞ୍ଜି ତି ଜାୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗନ୍‌ଲୁଡେଜି । ");
INSERT INTO juy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆସିଙଞ୍ଜି ୟର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ମରିଅମନ୍‌ ୟେଲେ ୟେଲେ ମସାନ୍ନିନ୍‌ ଆ ଡୁଆରାଲୋଙ୍‌ ଡକୋଲନ୍‌; ଆରି ଆନିନ୍‌ ୟେଲେ ୟେଲେ ଡୁଙ୍ଗୁଡାଲେ ଅମ୍ମ ମସାନ୍ନିନ୍‌ ଆଗ୍ରିଜେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ଜିସୁନ୍‌ ଆ ମରା ଅଙ୍ଗାଲୋଙ୍‌ ଡକ୍କୋଏଞ୍ଜି, ତି ତେତ୍ତେ ଆବବ୍‌ଗଡ୍‌ ଅବୟ୍‌ନେ ଆରି ତାଲ୍‌ଜଙ୍‌ ଗଡ୍‌ ଅବୟ୍‌ନେ, କେନ୍‌ ଅନ୍ତମ୍‌ ବାଗୁନେ ଜେଏରାଡମ୍‌ ଆ ସିନ୍‌ରି ଆରନେଜି ବାଗୁ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଆତଙ୍କୁମନ୍‌ ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ଆନିଞ୍ଜି ମରିଅମନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନିବା ୟେତେ ?” ମରିଅମନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଆନାଜି ପ୍ରବୁଞେନ୍‌ଆଡଙ୍‌ ପାଙେଞ୍ଜି, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଇୟ୍‌ଲେ ଡକ୍କୋଏଜି, ତିଆତେ ଞେନ୍‌ ଜନା ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ଆନିନ୍‌ ଏନ୍ନେଲେ ବର୍ନା ବର୍ନା କିଣ୍ଡୋଙ୍‌ଗଡ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଆଗ୍ରିଜେନ୍‌, ଜିସୁନ୍‌ ଆତନଙ୍‌, ବନ୍‌ଡ ତିଆତେ ଜିସୁନ୍‌ ଗାମ୍‌ଲେ ଆନିନ୍‌ ଅଃନ୍ନମ୍ମଡ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଇନିବା ୟେତେ ? ଆନାଆଡଙ୍‌ ସାୟ୍‌ତେ ?” ମରିଅମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ କୋତ୍ତାନ୍‌ ଆଜନଗେମର୍‌ ଅବ୍‌ଡିସୟ୍‌ଲେ, ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆଜ୍ଞା, ଆମନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପାଙେନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଡକ୍କୋଏନ୍‌, ଞେନ୍‌ଆଡଙ୍‌ ବରିଁୟ୍‌, ଆରି ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ମରିଅମ ।” ମରିଅମନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଏବ୍ରି ଲଙ୍‌ଲଙ୍‌ଲୋଙନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ରାବ୍‌ବୁନି !” ଆଗ୍ରାମ୍‌ଗାମନ୍‌ “ଞନଙ୍‌ତିୟ୍‌ମର୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ଡକ୍କୋଡଙିଂ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ନମିନ୍ତାନ୍‌ ଞେନ୍‌ ଆପେୟନ୍‌ ଆମଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜିରେ; ବନ୍‌ଡ ଆମନ୍‌ ବୋଞାଙ୍‌ଞେଞ୍ଜି ଆମଙ୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ ବରାଜି, ଞେନ୍‌ ଆପେୟ୍‌ଞେନ୍‌ ଡ ଆପେୟ୍‌ବେନ୍‌, ଆରି ଇସ୍ୱରଞେନ୍‌ ଡ ଇସ୍ୱରବେନ୍‌ ଆମଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଜିର୍ତେ ।” ");
INSERT INTO juy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ମଗ୍‌ଦଲିନି ମରିଅମନ୍‌ ଜିର୍ରେ, ଞେନ୍‌ ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲାୟ୍‌, ଆରି ଆନିନ୍‌, ଞେନ୍‌ଆଡଙ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ବର୍ରିଁୟ୍‌ ଗାମ୍‌ଲେ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ପାଲ୍ଲିନ୍‌ ଆ ପର୍ତମ୍ମୁ ଡିନ୍ନା ସାଲ୍ଲୁମ୍‌ ବେଡ଼ାନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଅବୟ୍‌ ଅସିଂଲୋଙନ୍‌ ଡକୋଲଞ୍ଜି, ଆରି ଜିଉଦିମରଞ୍ଜି ଆବନ୍ତଙ୍‌ଲୋଙ୍‌ ତି ଆସିଂ ଆ ସନଙ୍‌ଜି ଆଇଙଡ୍‌ ଡକୋଏନ୍‌, ତିଆଡିଡ୍‌ ଜିସୁନ୍‌ ଜିର୍ରେ ଆମଙଞ୍ଜି ମଡ୍ଡିନ୍‌ ତନଙ୍‌ଡାଲେ, “ଅମଙ୍‌ବେନ୍‌ ସୟୁନ୍‌ ଡକୋନେତୋ,” ଗାମ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ଏନ୍ନେଲେ ବର୍ରନ୍‌ କି ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆସିନ୍‌ ଡ ଆ ପକ୍କାନ୍‌ ଅବ୍‌ତୁଜେଞ୍ଜି । ସିଲତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ସର୍ଡାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରି ବରେଞ୍ଜି, “ଅମଙ୍‌ବେନ୍‌ ସୟୁନ୍‌ ଡକୋନେତୋ, ଆପେୟନ୍‌ ଏଙ୍ଗାଲେ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌, ଞେନ୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ତବେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ଆନିନ୍‌ ଏନ୍ନେଲେ ବର୍ରୋଙ୍‌ ବର୍ରନ୍‌ ଆଡଅଙ୍‌ଲୋଙଞ୍ଜି ଆରୁୟମ୍‌ଡାଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଜାବା ।” ");
INSERT INTO juy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ଆମ୍ୱେଞ୍ଜି ଆନ୍ନିଙ୍‌ ଆ ଇର୍ସେ ଏକେମାଏନ୍‌ ଡେନ୍‌, ଆ ଇର୍ସେନ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ କେମାନ୍‌ ଞାଙ୍‌ତେ; ଆରି ଆନ୍ନିଙ୍‌ ଆ ଇର୍ସେ କେମାନ୍‌ ଏଃତ୍ତିୟ୍‌ଲୋ ଡେନ୍‌, ଆ ଇର୍ସେନ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ କେମାନ୍‌ ଅଃଞାଙେ । ");
INSERT INTO juy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ବନ୍‌ଡ ଜିସୁନ୍‌ ଆରିୟ୍‌ଲାଞନ୍‌ ଆଡିଡ୍‌, ବାରଜଣଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ତୋମାନ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ନେ ଆନିନ୍‌ଆଡଙ୍‌ ଦିଦୁମ୍‌ ଗାମ୍‌ତଜି, ତିଆଡିଡ୍‌ ଆନିନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଅଃଡ୍ଡକୋଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ତିଆସନ୍‌ ଆନ୍ନା ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ଏଗିୟ୍‌ଲାୟ୍‌ ।” ବନ୍‌ଡ ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆସିଲୋଙନ୍‌ ଅବ୍ବାଙନ୍‌ ବାତ୍ତେ ଆପ୍ରୋସ୍ସଜେନ୍‌ଆତେଜି ଅଃଗିୟ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଆରି ତେତ୍ତେ ଅଣ୍ଡେର୍‌ସିଞେନ୍‌ ବାତ୍ତେ ଅଃସୁଙେଲାୟ୍‌ ଡେନ୍‌, ଆରି ଆ ପକ୍କାଲୋଙନ୍‌ ଅସିଞେନ୍‌ ବାତ୍ତେ ଅଃସୁଙେଲାୟ୍‌ ଡେନ୍‌ ଞେନ୍‌ ଏଙ୍ଗାଲ୍‌ଜନଙ୍‌ ଅଃଡ୍ଡର୍ନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ଆରି ଆତ ଡିନ୍ନା ଆ ତିକ୍କି ଆ ଞଙ୍‌ନେମରଞ୍ଜି ଆରି ଅମ୍ମନ୍‌ ଡକୋଲଞ୍ଜି ଆରି ତୋମାନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋଏନ୍‌ । ସନଙଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଆଇଙଡ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଜିର୍ରେ ଆମଙଞ୍ଜି ମଡ୍ଡିନ୍‌ ତନଙ୍‌ଡାଲେ, “ଅମଙ୍‌ବେନ୍‌ ସୟୁନ୍‌ ଡକୋନେତୋ,” ଗାମ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ତୋମାନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅଣ୍ଡେର୍‌ସିନମ୍‌ ବାତ୍ତେ ତେନ୍ନେ ସୁଙେଆ, କି ଅସିଞେନ୍‌ ଗିଜା, ଆରି ଅସିନମ୍‌ ତେକ୍କେଡାଲେ ପକ୍କାଲୋଙ୍‌ଞେନ୍‌ ଡକ୍କୋଆ; ଏର୍‌ଡର୍ନେମର୍‌ ଡେଡଙମ୍‌, ଡର୍ନା ।” ");
INSERT INTO juy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ତୋମାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ପ୍ରବୁଞେନ୍‌, ଇସ୍ୱରଞେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଗରିୟ୍‌ତିଞନ୍‌ ଡର୍ତନେ ପଙ୍‌ ? ଆନାଜି ଏର୍‌ଗନିଜନ୍‌ ଡର୍ରଞ୍ଜି, ଆନିଞ୍ଜି ସନେନ୍‌ସେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଗୋଗୋୟ୍‌ଡମ୍‌, ଆରି ଏର୍ଜାଡ଼ିକାନ୍‌ ଆ ସାନ୍ନି କାବ୍ବାଡ଼ାଜି ଲୁମେନ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ କେନ୍‌ ଆ ବଇଲୋଙ୍‌ ଆଇଡିଡ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ଜିସୁନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ କ୍ରିସ୍ଟନ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଏଡର୍ତନେ, ଆରି ଡର୍ରୋଙ୍‌ ଡର୍ରନ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅନମେଙନ୍‌ ଏଞାଙ୍‌ତେ, ତିଆସନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅନିଡନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ତିବିରିଆ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆରି ବତର ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଲନେ । ଆନିନ୍‌ କେନ୍‌ ଏନ୍ନେଲେ ଆମଙଞ୍ଜି ଅବ୍‌ତୁୟ୍‌ଲନେ; ");
INSERT INTO juy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ସିମନ୍‌ ପିତ୍ରନ୍‌, ତୋମାନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଦିଦୁମ ଗାମ୍‌ତଜି, ଗାଲିଲିନ୍‌ ଆ କାନ୍ନାବାୟ୍‌ ନିତନ୍‍, ଜେବଦିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ଆରି ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆରି ବାଗୁନେ ଏକ୍କାନ୍‌ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ସିମନ୍‌ ପିତ୍ରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଞେନ୍‌ ଞମ୍‌ୟବାନ୍‌ ଇୟ୍‌ତେ ।” ଆନିଞ୍ଜି ସିମନନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଇନ୍‌ଲେଞ୍ଜି ନିୟ୍‌ ଆମନ୍‌ ସରିନ୍‌ ଏଇୟ୍‌ତାୟ୍‌ ।” ଆନିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଡୋଙ୍ଗାଲୋଙନ୍‌ ଇୟ୍‌ଲେ ଡାଜେଜି, ଆରି ତି ଆ ତଗଲ୍‌ ଆନିଞ୍ଜି ଇନ୍ନିଙ୍‌ ଞମ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ଆସ୍ରାଆରେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆସର୍‌ଲଲୋଙନ୍‌ ଆତନଙ୍‌ ଡକୋଲନ୍‌, ବନ୍‌ଡ ଆନିନ୍‌ ଜିସୁନ୍‌ ଗାମ୍‌ଲେ ଞଙ୍‌ନେମରଞ୍ଜି ଅଃଜ୍ଜନାଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ, ପସିୟ୍‌ଜି ଅମଙ୍‌ବେନ୍‌ ଅୟନ୍‌ ଡକୋ ପଙ୍‌ ?” ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇଜ୍ଜା, ଇନ୍ନିଙ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଡୋଙ୍ଗାନ୍‌ ଆର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଜାଲନ୍‌ ସେଡ୍‌ବା, ଆମ୍ୱେଞ୍ଜି ଏଞାଙ୍‌ତେ ।” ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଜାଲନ୍‌ ସେଡେଞ୍ଜି, ଆରି ଏତ୍ତେଲେ ଆଗୋଗୋୟ୍‌ ଅୟନ୍‌ ଗତରେନ୍‌ ଡ, ଆନିଞ୍ଜି ତିଆତେ ଡିଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ତିଆସନ୍‌ ଅଙ୍ଗା ଞଙ୍‌ନେମର୍‌ଆଡଙ୍‌ ଜିସୁନ୍‌ ଡୁଙ୍‌ୟମେନ୍‌, ଆନିନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ତିଆନିନ୍‌ ପ୍ରବୁନ୍‌ ।” ସିମନ୍‌ ପିତ୍ରନ୍‌ ତିଆନିନ୍‌ ପ୍ରବୁନ୍‌ ଗାମ୍‌ଲେ ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ ଆ ଅଙ୍ଗିନ୍‌ ରଲନ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଅନ୍‌ତ୍ତିଡ୍‌ଲନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଆବଙ୍ଗୁୟ୍ ଡକୋଏନ୍‌; ");
INSERT INTO juy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ବନ୍‌ଡ ଆନ୍ନା ଞଙ୍‌ନେମରଞ୍ଜି ଅୟନ୍‌ ଆବରିଜନ୍‌ ଆ ଜାଲ ଡିଙ୍‌ଲେ ଡିଙ୍‌ଲେ ସନ୍ନା ଡୋଙ୍ଗାଲୋଙନ୍‌ ଜିର୍ରାଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆସର୍‌ଲଲୋଙନ୍‌ ସିଲଡ୍‌ ସଙାୟ୍‌ଲୋଙ୍‌ ଅଃଡ୍ଡକୋଲଜି, ବାଗୁସଅ ସନ୍ତି ଆ ସଙାୟ୍‌ଲୋଙ୍‌ ଆନିଞ୍ଜି ଅୟନ୍‌ ଞମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ଆନିଞ୍ଜି ଆସର୍‌ଲଲୋଙନ୍‌ ପଡ୍‌ଲନ୍‌ ତେତ୍ତେ ଆରଡ଼େତୋଡନ୍‌, ଆରି ତି ଆ ତୋଣ୍ଡୋ ଆଗାୟ୍‌ଗାୟ୍‌ ଅୟନ୍‌ ଡ ରୁଟିନ୍‌ ଆତମ୍ମିଜନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ନମିଞେନ୍‌ ଅଙ୍ଗା ଆୟ ଏଞମେନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ପାଙାୟ୍‌ବା ।” ");
INSERT INTO juy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ସିମନ୍‌ ପିତ୍ରନ୍‌ ଜିର୍ରେ ଅୟନ୍‌ ଆବରିଜନ୍‌ ଆ ଜାଲ ଡିଙ୍‌ଲେ ଇୟ୍‌ଲେ ପାଙେ । ତେତ୍ତେ ସୋଡ଼ାରାଡମ୍‌ ଆୟ ବସଅ ତେପନଟା ଡକୋଏନ୍‌, ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଜାଲନ୍‌ ଅଃନ୍ନତଡ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ୟବା ଆୟ୍‌ ଜୋମ୍‌ବା ।” ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଜା ଆମନ୍‌ ଆନା ଗାମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସନେକ୍କୁନ୍‌ ଆସନ୍‌ ଅଃନ୍ନୋମଙ୍‌ଲଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ପ୍ରବୁନ୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଆଜନାଜି । ");
INSERT INTO juy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ଜିସୁନ୍‌ ରୁଟିନ୍‌ ପାଙ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତିୟେଜି, ଆରି ତିଅନ୍ତମ୍‌ ଅୟନ୍‌ ନିୟ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତିୟେଜି । ");
INSERT INTO juy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆଡ୍ରୋଲନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, କେନ୍‌ଆତେ ମାୟ୍‌ଲେ ୟାଗି ତର, ଜିସୁନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ଆନିଞ୍ଜି ଆଗ୍ରାଗାଲଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ସିମନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଜନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ସିମନ୍‌, ଆମନ୍‌ କେନ୍‌ଆନିଞ୍ଜି ସିଲଡ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଗୋଗୋୟ୍‌ ଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌ ପଙ୍‌ ?” ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଓଓ, ପ୍ରବୁ, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତମ୍, ତିଆତେ ଆମନ୍‌ ଜନା ।” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆଅନ୍‌ ମେଣ୍ଡାଞେଞ୍ଜି ତୁରାଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ଜିସୁନ୍‌ ଆରି ବତର ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଜନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ସିମନ୍‌, ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌ ପଙ୍‌ ?” ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ଓଓ, ପ୍ରବୁ, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତମ୍, ତିଆତେ ଆମନ୍‌ ଜନା ।” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ମେଣ୍ଡାଞେଞ୍ଜି ଜୁବାୟାଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ଜିସୁନ୍‌ ୟାଗି ତର ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏ ଜନନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ସିମନ୍‌, ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତିଁୟ୍‌ ପଙ୍‌ ?” ଜିସୁନ୍‌ ଏନ୍ନେଲେ ୟାଗି ତର ଆନିନ୍‌ଆଡଙ୍‌ ଆବର୍ରେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ପ୍ରବୁ, ଆମନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଜନା, ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମ୍‌ତମ୍, ତିଆତେ ଆମନ୍‌ ଜନା ।” ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ମେଣ୍ଡାଞେଞ୍ଜି ତୁରାଜି ।” ");
INSERT INTO juy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ଆଜାଡ଼ିଡମ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ବର୍ତମ୍‌, “ବନେଣ୍ଡିଆ ଇଙନ୍‌ ଆମନ୍‌ ରେଡ୍ଡୁବ୍‌ଲନ୍‌ ଅଡ଼େଙ୍ଗା ଲଡୟ୍‌ ଅଡ଼େତ୍ତେ ବୁଲ୍ଲେଏନ୍‌, ବନ୍‌ଡ ଆମନ୍‌ ବୁଡାଲମ୍‌ ଡେନ୍‌ ଆମନ୍‌ ତେକ୍କେସିତନେ, ଆନ୍ନାମର୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅବ୍‌ରେଡ୍ଡୁବ୍‌ଡାଲେ, ଅଡ଼େଙ୍ଗା ଆମନ୍‌ ଅଃଲ୍ଲଡଜମ୍‌, ଅଡ଼େତ୍ତେ ଆମନ୍‌ଆଡଙ୍‌ ଓରୋଙ୍‌ତମ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ପିତ୍ରନ୍‌ ଏଙ୍ଗାଗୋ ଆ ରନବୁ ବାତ୍ତେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଗୁଗୁତେ ଅବ୍‌ପେମେଙ୍‌ତେ, ତିଆସନ୍‌ ଆନିନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ । ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ସିମନନ୍‌ ଆୟର୍‌ଗୁଡ଼ିଃଲନ୍‌ ଆଗ୍ରିଜେନ୍‌, ଜିସୁନ୍‌ ଅଙ୍ଗା ଞଙ୍‌ନେମର୍‌ଆଡଙ୍‌ ଡୁଙ୍‌ୟମେନ୍‌ ଆରି ଆନା ତଗଲ୍‌ ଗାଗାନେ ଇଙନ୍‌ ଜିସୁନ୍‌ ଆ ମାୟଙ୍‌ଲୋଙ୍‌ ଇଙ୍‌ଡର୍‌ଡାଲନ୍‌, “ପ୍ରବୁ, ଆମନ୍‌ଆଡଙ୍‌ ଆନା ବନେରାଞ୍ଜି ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତମ୍‌,” ଗାମ୍‌ଲେ ବରେନ୍‌, ଆନିନ୍‌ କିଣ୍ଡୋଙ୍‌ଗଡ୍‌ ଜିର୍ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ତିଆସନ୍‌ ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁ, କେନ୍‌ଆତେ ଆସନ୍‌ ଇନି ?” ");
INSERT INTO juy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ଜିସୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ବାର୍‌ଜନିର୍‌ଞେନ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ ଆମେଙନ୍‌ ଡକୋନେତୋ ଗାମ୍‌ଲେ ଞେନ୍‌ ଲଡୟ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଇନି ଅଡ଼ୋଅମ୍‌ ? ଆମନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙିୟ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ସିଲତ୍ତେ ତି ଆ ଞଙ୍‌ନେମର୍‌ ଅଃର୍ରବୁଏ ଗାମ୍‌ଲେ ବୋଞାଙଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ତି ଆ ବର୍ନେ ବୁର୍ବୁରାୟ୍‌ଲନେ, ବନ୍‌ଡ ଆନିନ୍‌ ଅଃର୍ରବୁଏ ଗାମ୍‌ଲେ ଜିସୁନ୍‌ ଅଃବ୍ବର୍ରନେ, “ଞେନ୍‌ ୟରର୍ତନାଞନ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ ଆମେଙନ୍‌ ଡକୋନେତୋ ଗାମ୍‌ଲେ ଞେନ୍‌ ଲଡୟ୍‌ଲାୟ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଇନି ଅଡ଼ୋଅମ୍‌,” ଗାମ୍‌ଲେ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ଆନା କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ସାକିନ୍‌ ତିୟେନ୍‌, ଆରି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଇଡେନ୍‌, ଆନିନ୍‌ ତି ଆ ଞଙ୍‌ନେମର୍‌; ଆରି ଆ ସାକିନ୍‌ ଆଜାଡ଼ିଡମ୍‌ ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି ଜନା । ");
INSERT INTO juy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ଜିସୁନ୍‌ ଆରି ଗୋଗୋୟ୍‌ଡମ୍‌ କାବ୍ବାଡ଼ାଞ୍ଜି ଲୁମେନ୍‌; ତି ଅଡ଼୍‌କୋନ୍‌ ତଙ୍‌ବୟ୍‌ ତଙ୍‌ବୟ୍‌ ଅମ୍ମେଲେ ଅନିଡନ୍‌ ଡେଏନ୍‌ ନଙ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଅନିଃୟମ୍‌ଲୋଙ୍‌ଞେନ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌ ଆ ବଇଜି ଡନକ୍କୋନ୍‌ ଆସନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଜାଗା ତଡ୍‌ ବନ୍‌ ।");
INSERT INTO juy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ଏ ତିଅପିଲ୍‌, ଅଙ୍ଗା ଆଡିଡ୍‌ ଜିସୁନ୍‌ ଆସ୍ରେଡାଏନ୍‌ ଆନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମର୍‌ଜିଆଡଙ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ଞନଙନ୍‌ ତିୟେନ୍‌ କି ତୋଣ୍ଡୋନ୍‌ ଜିରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ତିଆଡିଡ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ ଅଙ୍ଗା ଅଙ୍ଗା ଆ କାବ୍ବାଡ଼ାଜି ଲନୁମନ୍‌ ଆସନ୍‌ ଡ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ, ତି ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଞେନ୍‌ ଲୁକ ବଇଲୋଙନ୍‌ ଆମ୍ମୁଙ୍‌ ଇଡ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ଆନିନ୍‌ ନିୟ୍‌ ରବୁଏନ୍‌ କି ୟର୍ମେଙ୍‌ଲେ ଆଡ୍ରୋଲନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜବ୍ରତର ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଆମେଙ୍‌ ଅବ୍‌ତୁୟ୍‌ଲନ୍‌, ଆରି ବାକୁଡ଼ି ଡିନ୍ନା ଜାୟ୍‌ ନମିନ୍‌ ନମିନ୍‌ ଆମଙଞ୍ଜି ଅବ୍‌ତୁୟ୍‌ଡାଲନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଆ ବର୍ନେଜି ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ବତର ଆନିଞ୍ଜି ବୟନ୍‌ ଗାଗାନେବାନ୍‌ ଆତ୍ରଙ୍କୁମେଞ୍ଜି ଆଡିଡ୍‌ ଆନିନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଅନ୍ନିଙ୍‌ ଏଜିର୍‌ଡଙ୍‌, ଆର୍ପାୟ୍‌ ଆପେୟନ୍‌ ବାସାଲଙ୍‌ଲନ୍‌ ଗାମ୍‌ଲେ ଅଙ୍ଗା ବର୍ନେ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜି ବର୍ରବେନ୍‌, ତିଆତେ ଜଗେଲେ ଡକୋନାବା; ");
INSERT INTO juy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଡାଆଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ଲବେନ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ଅସୋୟ୍‌ ଡିନ୍ନା ଆ ତିକ୍କି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ତବ୍ବୁବ୍‌ଡାନ୍‌ ଏଞାଙ୍‌ତେ ।” ");
INSERT INTO juy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ଆନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିଞ୍ଜି ରୁକ୍କୁଡାଲନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ପ୍ରବୁ, କେନ୍‌ ଆଡିଡ୍‌ ରାଜ୍ୟନ୍‌ ଆ ବିଡ଼ାର୍‌ ଆରି ପଙ୍‌ ଇସ୍ରାଏଲନ୍‌ ଆସିଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ତେ ?” ");
INSERT INTO juy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ଜିସୁନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆପେୟନ୍‌ ଅଙ୍ଗା ଆଙ୍ଗାୟ୍‌ କି ଅଙ୍ଗା ବେଡ଼ା ଆନିନ୍‌ ଆ ସନୋଡ଼ାନେନ୍‌ ଆ ଜାୟ୍‌ତା ଡକ୍କୋଏନ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଜନନାନ୍‌ ଆସନ୍‌ ଏଏର୍‌ଡଙ୍‌ ଏଗୋୟ୍‌ଡଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ବନ୍‌ଡ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଅମଙ୍‌ବେନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ପନ୍ନେ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆମ୍ୱେଞ୍ଜି ବୋର୍ସାତବେନ୍‌, ଆରି ଜିରୁସାଲମ୍‌, ସମ୍ପରା ଜିଉଦା ଡେସାନ୍‌ ଡ ସମିରୋଣନ୍‌, ଆରି ପୁର୍ତିନ୍‌ ଆନେଙ୍‌ ଜାୟ୍‌ ଇୟ୍‌ଲେ ବର୍ନେଞେନ୍‌ ସାକିନ୍‌ ଇୟ୍‌ତେ ଏତିୟେ ।” ");
INSERT INTO juy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ଜିସୁନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆବର୍ରନ୍‌ ସିଲଡ୍‌, ଆନିଞ୍ଜି ଗିଜାନ୍‌ ଗିଜାନ୍‌ ଆନିନ୍‌ ତୋଣ୍ଡୋନ୍‌ ଜିରେନ୍‌, ଆରି ଅବୟ୍‌ ମେଗନ୍‌ ଜିର୍ରାୟ୍‌ କି ଞଙନେମରଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅନୋରୋଙନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ଆନିନ୍‌ ରୁଆଙନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ଆନିଞ୍ଜି ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ରୁଆଙନ୍‌ ଆଙାଙ୍‌ଲେ ଡକୋଲଞ୍ଜି, ତିଆଡିଡ୍‌ ଗିୟ୍‌ବା, ଜେଏଡମ୍‌ ଆ ସିନ୍‌ରି ଆଜିଜିନେ ବାଗୁ ମନ୍‌ରା ଜିସୁନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାଜି, ");
INSERT INTO juy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ଆରି ତି ଆ ମନ୍‌ରାଜି ଗାମେଞ୍ଜି, “ଏ ଗାଲିଲିବାଜି, ଇନିବା ଆମ୍ୱେଞ୍ଜି ତନଙ୍‌ଲେ ରୁଆଙନ୍‌ ଆଙାଙ୍‌ଲେ ଏସେତ୍ତେ ? କେନ୍‌ ଜିସୁନ୍‌, ଅମଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ରୁଆଙନ୍‌ ଅନୋରୋଙନ୍‌ ଡେଏନ୍‌, ଆନିନ୍‌ ରୁଆଙନ୍‌ ଆଜିର୍ରେନ୍‌ ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଙ୍ଗାଲେ ଏଗିଜେନ୍‌, ଆନିନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ମା ୟର୍ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିତବୁରନ୍‌ ସିଲଡ୍‌ ଜିରୁସାଲମନ୍‌ ୟର୍ରନେଜି । ତି ଆ ବରୁ ଜିରୁସାଲମନ୍‌ ଆ ତୁୟାୟ୍‌, ବଲୋଲୋନେ ଡିନ୍ନା ଆ ତଙର୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ପିତ୍ରନ୍‌, ଜନନ୍‌, ଜାକୁବନ୍‌, ଆନ୍ଦ୍ରିଅନ୍‌, ପିଲିପନ୍‌, ତୋମାନ୍‌, ବାର୍ତଲମିନ୍‌, ମାତିଉନ୍‌, ଆଲପିନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜାକୁବନ୍‌, ଉୟୁବ୍‌ମର୍‌ ସିମନନ୍‌ ଡ ଜାକୁବନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଜିଉଦାନ୍‌, ଆନିଞ୍ଜି ଅଙ୍ଗାଲୋଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆସିଂଲୋଙ୍‌ ଡକୋଲଞ୍ଜି ତେତ୍ତେ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ଆନିଞ୍ଜି ଡିତାନ୍‌ ଆଇମରଞ୍ଜି ସରିନ୍‌ ଆରି ଜିସୁନ୍‌ ଆ ନନ ମରିଅମନ୍‌ ଡ ଜିସୁନ୍‌ ଆ ବୋଞାଙ୍‌ଜି ସରିନ୍‌ ଆବମନ୍ନନ୍‌ ଏମ୍ମେଲନ୍‌ ପାର୍ତନାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ତେତ୍ତେ ବସଅ ବକୁଡ଼ି ମନ୍‌ରା ଜିସୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଡକୋଏଞ୍ଜି, ତିଆଡିଡ୍‌ ପିତ୍ରନ୍‌ ବୋଞାଙ୍‌ଜି ଆମଙ୍‌ ତନଙ୍‌ଲେ ବର୍ରନେ; ");
INSERT INTO juy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ଏ ବୋଞାଙ୍‌ଞେଞ୍ଜି, ଇସ୍କାରିତ ଜିଉଦାନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି ଆ ମନ୍‌ରାଜି ତଙରନ୍‌ ଅବ୍‌ତୁଜେଞ୍ଜି, ତି ଆ ବର୍ନେ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆମ୍ମୁଙ୍‌ ମା ଦାଉଦନ୍‌ ଆ ତଅଡ୍‌ଗଡ୍‌ ବର୍ରନେ, ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡନ୍‌ ତି ଆ ବର୍ନେ ଅନ୍ତମ୍‌ ଡେଡମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ନିୟ୍‌ ଇନ୍‌ଲେଞ୍ଜିଲୋଙ୍‌ ଅବୟ୍‌ନେ ଗାମ୍‌ଲେ ଡନିଡିନ୍‌ ଡେଏନ୍‌ ଆରି କେନ୍‌ ସେବା କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ଡକୋଲନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ଇସ୍କାରିତ ଜିଉଦାନ୍‌ ଇର୍ସେ କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ଲେ ଆରର୍ଜେଏନ୍‌ ଆ ତଙ୍କା ବାତ୍ତେ ଅବୟ୍‌ ବସେଙନ୍‌ ଞନିନ୍‌ ଡେଏନ୍‌, ଆରି ଆନିନ୍‌ ତି ଆ ବସେଙ୍‌ଲୋଙ୍‌ ସୟୋର୍‌ମଡ୍‌ଲେ ଆରକୁଡେନ୍‌ ଆ କିମ୍ପୋଙନ୍‌ ପତଡେନ୍‌ କି ଆ ଅନ୍‌ଲୟ୍‌ଡାନ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଆରି, କେନ୍‌ଆତେ ଜିରୁସାଲମନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଜନାଏଞ୍ଜି । ତିଆସନ୍‌, ତି ଆ ବସେଙ୍‌ ଆ ବର୍ନେଞ୍ଜି ବାତ୍ତେ “ଅକଲ୍‌ଦମା ।” କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ମିଞାମ୍‌ ବସେଙ୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ଞୁମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“ଆରି କନନ୍‌ ବଇଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ‘ଆସିଙନ୍‌ ରିକ୍କାଏତୋ; ତେତ୍ତେ ଆନ୍ନିଙ୍‌ ଡକୋଡଙ୍‌ନେ ତଡ୍‌ ।’ ଆରି ନିୟ୍‌ ଆଇଡିଡ୍‌, ‘ଆ କାବ୍ବାଡ଼ାନ୍‌ ଆନ୍ନାମର୍‌ ତନିୟନ୍‌ ଡେଏତୋ ।’ ");
INSERT INTO juy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ତିଆସନ୍‌, ପ୍ରବୁ ଜିସୁନ୍‌ ଜନନ୍‌ ଆମଙ୍‌ ଆତ୍ରବ୍ବୁବ୍‌ଡାଲନ୍‌ ଆଡିଡ୍‌ ସିଲଡ୍‌ ଉଲନ୍‌, ଅମଙ୍‌ଲେନ୍‌ ସିଲଡ୍‌ ତୋଣ୍ଡୋ ରୁଆଙନ୍‌ ଆଜିର୍ରେନ୍‌ ଆ ଡିନ୍ନା ସିଲଡ୍‌ ଡିଅଙ୍ଗା ଡିନ୍ନା ଜାୟ୍‌ ଇନ୍‌ଲେଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲନ୍‌, ");
INSERT INTO juy_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ତି ଆ ଡିନ୍ନା ଅଙ୍ଗା ମନ୍‌ରାଜି ଇନ୍‌ଲେଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲଞ୍ଜି, ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଇନ୍‌ଲେଞ୍ଜି ସରିନ୍‌ ଜିସୁନ୍‌ ୟର୍ମେଙ୍‌ଲେ ଆଡ୍ରୋଲନ୍‌ ଆ ବର୍ନେ ସାକିନ୍‌ ତିୟ୍‌ତବୋ ।” ");
INSERT INTO juy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ସିଲତ୍ତେ ଆନିଞ୍ଜି ବାଗୁ ମନ୍‌ରା; ଜୋସେପନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ବର୍ସବା ଗାମ୍‌ତଜି ଆରି ଜୁସ୍ତ ଗାମ୍‌ଲେ ନିୟ୍‌ ଓଡ୍ଡେତଜି, ଆନିନ୍‌ ଡ ମତିଅନ୍‌, କେନ୍‌ ବାଗୁଞ୍ଜି ଆନ୍ନାଏଞ୍ଜି କି ପାର୍ତନାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","“ଏ ପ୍ରବୁ, ଆମନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ଉଗର୍‌ ଜନାତେ, ଇସ୍କାରିତ ଜିଉଦାନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଆ ଡକୋନେଲୋଙ୍‌ ଆସନ୍‌ କେନ୍‌ ସେବା କାବ୍ବାଡ଼ାନ୍‌ ଆସନ୍‌ ଆମନ୍‌ ଆନିନ୍‌ ସେଡାଏନ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ଜିଉଦାନ୍‌ ଆ ପାଲ୍‌ତେଙ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରନ୍‌ ଆ କାବ୍ବାଡ଼ା ଆନା ଲୁମ୍‌ତେ ତିଆତେ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅବ୍‌ଜନାଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ଆରି, ଆନିଞ୍ଜି ତି ବାଗୁ ମନ୍‌ରା ଆସନ୍‌ ଅବ୍‌କଡ଼ିଏଞ୍ଜି, ସିଲତ୍ତେ ମତିଅନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ କଡ଼ିନ୍‌ ଡୋଲନେ; ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଏଗାରଜଣ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ବୟନ୍‌ ମାୟ୍‌ଲେ ଡନିଡିନ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ପେଣ୍ଟିକସ୍ଟ ଡିନ୍ନାନ୍‌ ଆରଡ଼ୋଲାଞନ୍‌, କ୍ରିସ୍ଟ ଡର୍ନେମରଞ୍ଜି ଆବଜାଗାଲୋଙନ୍‌ ରୁକ୍କୁଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ଆରି, ଆକ୍ରାନ୍‌ ଆରିଙ୍ଗେତେନ୍‌ ଆଡିଡ୍‌ ଆସ୍ରଡ୍ଡାତେନ୍‌ ଅନ୍ତମ୍‌ ଅବୟ୍‌ ସନଡ୍ଡାନ୍‌ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅଡ଼ୋଲାୟ୍‌, କି ଆନିଞ୍ଜି ଅଙ୍ଗା ଆସିଂଲୋଙ୍‌ ଆତଙ୍କୁମ୍‌ ଡକୋଲଞ୍ଜି, ତେତ୍ତେ ଇୟ୍‌ଲାୟ୍‌ ବରିଜେ । ");
INSERT INTO juy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ଆରି ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙଞ୍ଜି ଆଉଲ୍ଲାଙ୍‌ତୋଡନ୍‌ ଅନ୍ତମ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ପନ୍ନେ । ");
INSERT INTO juy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ସିଲତ୍ତେ ଅଡ଼୍‌କୋଞ୍ଜି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଞାଙେଞ୍ଜି, ଆରି, ପୁରାଡ଼ାନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଏଙ୍ଗାଲେ ବର୍ନେନ୍‌ ଆସନ୍‌ ବୋର୍ସାନ୍‌ ତିୟେଞ୍ଜି, ଏତ୍ତେଲେ ଆନିଞ୍ଜି ଆନ୍ନା ଆନ୍ନା ଆ ଲଙ୍‌ଲଙ୍‌ ବାତ୍ତେ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ତିଆଡିଡ୍‌ ସମ୍ପରା ପୁର୍ତିନ୍‌ ଆ ଜିଉଦିମର୍‌ଜି ଅଡ଼େତ୍ତେ ଅଡ଼େନ୍ନେ ସିଲଡ୍‌ ଜିର୍ରେ ଜିରୁସାଲମନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଡକୋନେଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ଆରି, ଏତ୍ତେଲେ ଆସ୍ରଡ୍ଡାଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଜବ୍ର ମନ୍‌ରା ରୁକ୍କୁଡାଲନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଲଙ୍‌ଲଙ୍‌ ବାତ୍ତେ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜିଆତେ ଆରମ୍‌ଡଙେଞ୍ଜି ଆନିଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଗିୟ୍‌ବା, ଅଙ୍ଗା ମନ୍‌ରାଜି କେନ୍‌ ବର୍ନେନ୍‌ ବର୍ତଞ୍ଜି, ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଗାଲିଲିବାଜି ତଡ୍‌ ପଙ୍‌ ଏଗାମ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ଏତ୍ତେଲ୍‌ଡେନ୍‌, ଇନ୍‌ଲେନ୍‌ ଜନମ୍ମୁ ଆଡ୍ରେଡେଲଙ୍‌ଲନ୍‌ ଆ ଡେସା ଆ ଲଙ୍‌ଲଙ୍‌ ଆ ବର୍ନେ ଏଙ୍ଗାଲେ ଅମ୍‌ଡଙ୍‌ତବୋ ? ");
INSERT INTO juy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ଇନ୍‌ଲେଞ୍ଜି ପାର୍ତିଅ, ମାଦିଅ, ଏଲାମିଅ, ମେସପଟାମିଆ, ଜିଉଦା ଡେସାନ୍‌, କାପାଦକିଆ, ପନ୍ତ, ଆସିଆ, ");
INSERT INTO juy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ପ୍ରୁଗିଆନ୍‌, ପମ୍ପୁଲିଆନ୍‌, ମିସର୍‌ ଆରି କୁରିଣିଅନ୍‌ ଆ ଡେସାନ୍‌ ଆ ତୁୟାୟ୍‌ ଲିବିଆରେଙନ୍‌ ଆ ମନ୍‌ରାଜି ଆରି ରୋମ୍‌ ଡେସାନ୍‌ ସିଲଡ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି ଜିଉଦିମରଞ୍ଜି ଡ ଜିଉଦି ଡରମ୍ମମରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","କ୍ରିତିଅ, ଆରବିଅମର୍‌ଜି; ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଅଙ୍ଗା ସୋଡ଼ା କାବ୍ବାଡ଼ା ଲୁମେନ୍‌ ତି ଆ ବର୍ନେ ଇନ୍‌ଲେନ୍‌ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଲଙ୍‌ଲଙ୍‌ଲେନ୍‌ ବାତ୍ତେ ଅମ୍‌ଡଙ୍‌ତବୋ ।” ");
INSERT INTO juy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ଆରି, ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ସାନ୍ନି ଡେଏଞ୍ଜି କି ତର୍ଡମ୍‌ ଅଲ୍‌ବର୍ବରେଞ୍ଜି, “କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ଇନି ?” ");
INSERT INTO juy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ବନ୍‌ଡ ଲାଙ୍‌ଲେନ୍ନେ ତିକ୍କଲାୟ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆନିଞ୍ଜି ରଙ୍‌ ଦ୍ରାକ୍ୟାଡାନ୍‌ ଆ ଜବୁଙନ୍‌ଆତେ ଗାଏଞ୍ଜି କି ବନ୍ନୁଲେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ବନ୍‌ଡ ଏଗାରଜଣ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ପିତ୍ରନ୍‌ ତନଙ୍‌ଡାଲେ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ତି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ବର୍ରନେ, “ଏ ଜିଉଦିମର୍‌ଜି ଆରି ଜିରୁସାଲମନ୍‌ ଏଡ୍ରକୋତନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାଜି, ଆମ୍ୱେଞ୍ଜି ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ବା ଆରି କେନ୍‌ଆତେ ଜନାବେନ୍‌ତୋ । ");
INSERT INTO juy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଆନିଞ୍ଜି ଆବନ୍ନୁଲ୍‌ଜି ଏବ୍‌ଡିସୟ୍‌ତେ, କେନ୍‌ ଆନିଞ୍ଜି ଏତ୍ତେଲେ ଆବନ୍ନୁଲ୍‌ଜି ତଡ୍‌, ଆରି ଓୟୋଙନ୍‌ ନିୟ୍‌ ନମି ନଟା ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ଜୋଏଲ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଅଙ୍ଗା ବର୍ନେ ବର୍ରନେ, ତି ଆ ବର୍ନେ ଅନ୍ତମ୍‌ କେନ୍‌ଆତେ ଡେତେ; ");
INSERT INTO juy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘ଇସ୍ୱରନ୍‌ ବର୍ରନେ, ଆତନିକ୍କି ଡିନ୍ନାଇଙନ୍‌ କେନ୍‌ ଅନ୍ତମ୍‌ ଡେତେ, ଞେନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ପୁରାଡ଼ାଞେନ୍‌ ଲାତାୟ୍‌ । ସିଲତ୍ତେ ଡାଙ୍ଗଡ଼ିଅନ୍‌ବେଞ୍ଜି ଡ ଡାଙ୍ଗଡ଼ାଅନ୍‌ବେଞ୍ଜି ପୁର୍ବାଃତେବରନ୍‌ ବର୍ତଞ୍ଜି, ବେଣ୍ଡିଆସିୟ୍‌ବେଞ୍ଜି ତନାଲ୍‌ମଡନ୍‌ ଗିୟ୍‌ତଜି, ଆରି, ବୁଡାମର୍‌ବେଞ୍ଜି ଗନୁମ୍‌ତେନ୍‌ ଗିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ତି ଆଡିଡ୍‌ ଞେନ୍‌ କମ୍ୱାରିମର୍‌ଞେଞ୍ଜି ଡ କମ୍ବାରିବୟ୍‌ଞେଞ୍ଜି, ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ପୁରାଡ଼ାଞେନ୍‌ ଲାତାୟ୍‌, ଆରି ଆନିଞ୍ଜି ପୁର୍ବାଃତେବରନ୍‌ ବର୍ତଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ଞେନ୍‌ ତୋଣ୍ଡୋ ରୁଆଙନ୍‌ ସରାନ୍ନିଡାନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଲୁମ୍‌ତାୟ୍‌; ଜାୟ୍‌ତାନ୍‌ ପୁର୍ତିଲୋଙନ୍‌ ଅରମ୍ମଡଞ୍ଜି ଗିୟ୍‌ତାତେ, ମିଞାମନ୍‌, ତଗୋନ୍‌ ଡ ଓମୋଡନ୍‌ ଅବ୍‌ତୁୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ଇସ୍ୱରନ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ବାତ୍ତେ ଆଜିର୍ତାଞନ୍‌ ଆମ୍ମୁଙ୍‌, ଓୟୋଙନ୍‌ ଲୋଙଡ୍‌ତେ, ଆରି ଆଙ୍ଗାୟ୍‌ତାନ୍‌ ମିଞାମନ୍‌ ଅନ୍ତମ୍‌ ଲୁଲୁଡମ୍‌ ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ଆରି, ତି ଆଡିଡ୍‌ ଏନ୍ନେଲେ ନିୟ୍‌ ଡେତେ, ଆନା ପ୍ରବୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପାର୍ତନାତନେ ଆନିନ୍‌ ଅନୁରନ୍‌ ଞାଙ୍‌ତେ ।’” ");
INSERT INTO juy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ଏ ଇସ୍ରାଏଲ୍‌ମର୍‌ଜି, କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଅମ୍‌ଡଙ୍‌ବା । ନାଜରିତ ଜିସୁନ୍‌ ବୋର୍ସାଡମନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି, ସରାନ୍ନିଡାନ୍‌ ଆ କାବ୍ବାଡ଼ା ଆରି ଅରମ୍ମଡନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଲୁମେନ୍‌; ତିଆତେଜି ଗିୟ୍‌ଲେ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌ ଗାମ୍‌ଲେ ଜନାଲଙ୍‌ଲନ୍‌ । ଆରି ଆନିନ୍‌ ଅମ୍ମେଲେ ଇସ୍ୱରନ୍‌ ଅମଙ୍‌ଲେନ୍‌ ତି ଆ କାବ୍ବାଡ଼ାଜି ଲୁମେନ୍‌ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଆଜନାଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ଆମ୍ମୁଙ୍‌ ମା ଇସ୍ୱରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅସିଲୋଙ୍‌ବେନ୍‌ ସନୋରୋପ୍ପାୟନ୍‌ ଆସନ୍‌ ଗବ୍‌ରିଏନ୍‌; ଆରି ଆମ୍ୱେଞ୍ଜି ଇର୍ସେମରଞ୍ଜି ବାତ୍ତେ ବାଁୟ୍‌ସିଡାଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ତାଙ୍‌ଲେ ଏରବ୍ବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ରନବୁନ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ୟର୍ମେଙେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରନବୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜିଲେ ଡକ୍କୋଲେ ଅଃର୍ରପ୍ତିଏ । ");
INSERT INTO juy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଆରି ଦାଉଦନ୍‌ ଜିସୁନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ; ‘ଞେନ୍‌ ଡିତାନ୍‌ ମୁକ୍କାବାଞେନ୍‌ ପ୍ରବୁନ୍‌ ଗିୟ୍‌ତାୟ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ଞେନ୍‌ ଡକୋ, ତିଆସନ୍‌ ଞେନ୍‌ ବାଉଲ୍ଲି ଅଃନ୍ନେମ୍ମେନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ତିଆସନ୍‌ ଉଗର୍‌ଞେନ୍‌ ସର୍ଡାଲନ୍‌, ଆଲାଙ୍‌ଞେନ୍‌ ମଅଁୟ୍‌ଲନ୍‌, ଆରି ଡଅଙ୍‌ଞେନ୍‌ ନିୟ୍‌, ଲୋଲୋତନେ ଗାମ୍‌ଲେ ଞେନ୍‌ ଆସାତନାୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ପରାନ୍ନାଞେନ୍‌ ପାତାଡ଼ଲୋଙନ୍‌ ଅଃନ୍ନମ୍‌ରେଙେ । ଆରି ଡର୍ନେମର୍‌ନମ୍‌ଜିଆଡଙ୍‌ ଆମନ୍‌ ମସାନ୍ନିଲୋଙନ୍‌ ଅଃନ୍ନବ୍‌ସଅଏ । ");
INSERT INTO juy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ଆମନ୍‌ ଅନମେଙନ୍‌ ଆ ତଙର୍‌ ଅବ୍‌ତୁୟ୍‌ଲିଁୟ୍‌, ଆମନ୍‌ ମୁକ୍କାବାନମ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅବ୍‌ସର୍ଡାତିଁୟ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ଏ ବୋଞାଙ୍‌ଜି, ପୁର୍ବା ଜୋଜୋଲେନ୍‌ ଦାଉଦ ରାଜାନ୍‌ ଆ ବର୍ନେ ଞେନ୍‌ ରେୟ୍‌ଲଙ୍‌ ଅମଙ୍‌ବେନ୍‌ ବର୍ତନାୟ୍‌, ଆନିନ୍‌ ଆର୍ରବୁଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତନିଲନ୍‌ ଡେଏନ୍‌, ଆରି ଆ ମସାନ୍ନିନ୍‌ ନମିନ୍ତାନ୍‌ ଅମଙ୍‌ଲେନ୍‌ ଡକୋ । ");
INSERT INTO juy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ଦାଉଦନ୍‌ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ ଡକୋଏନ୍‌, ଆ କେଜ୍ଜାଲୋଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ନେ ଅବ୍‌ରାଜାଲେ ଆ କୁର୍ସିଲୋଙନ୍‌ ଅନବ୍‌ତଙ୍କୁମନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବାସାଏନ୍‌ ଗାମ୍‌ଲେ ଆନିନ୍‌ ଆଜନା । ");
INSERT INTO juy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","କେନ୍‌ଆତେ ଆନିନ୍‌ ଆଜ୍ରନାଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପୁର୍ବାଃତେ ତନାଲ୍‌ମଡନ୍‌ ବାତ୍ତେ କ୍ରିସ୍ଟନ୍‌ ଆ ୟନର୍ମେଙ୍‌ ଆ ବର୍ନେ ବର୍ରନେ, ‘ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ପାତାଡ଼ଲୋଙନ୍‌ ଅଃସେଡ୍‌ଲଜି, କି ଆ ଡଅଙନ୍‌ ଅଃସଅଲୋ ନିୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ଇସ୍ୱରନ୍‌ କେନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅବ୍‌ୟର୍ମେଙେନ୍‌, ତି ଆ ବର୍ନେଜି ଇନ୍‌ଲେନ୍‌ ସାକିନ୍‌ ଏତିୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ଇସ୍ୱରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଅମ୍‌ଡାଜେନ୍‌ କି ଆର୍ଜଡ଼ୋମ୍‌ଗଡନ୍‌ ଅବ୍‌ତଙ୍କୁମେନ୍‌, ଆରି ଆନିନ୍‌ ଏଙ୍ଗାଲେ ବାସାଲଙ୍‌ଲନ୍‌ ତି ଅନ୍ତମ୍‌ ଇନ୍‌ଲେନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଏଞାଙ୍‌ଲାୟ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ନମି ଏଗିୟ୍‌ତେ ଆରି ଏଅମ୍‌ଡଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଦାଉଦନ୍‌ ରୁଆଙନ୍‌ ଅଃଜ୍ଜିର୍ରୋ, ବନ୍‌ଡ ଆନିନ୍‌ଡମ୍‌ ବର୍ତନେ; ‘ପ୍ରବୁନ୍‌ ପ୍ରବୁଞେନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ଞେନ୍‌ ଅଙ୍ଗା ଜାୟ୍‌ ବନେରାନମ୍‌ଜି ତାଲ୍‌ଜଙ୍‌ନମ୍‌ ଆ ଜାୟ୍‌ତା ଅଣ୍ଡ୍ରଙ୍‌ ଡକ୍କୋଆଜି, ତି ଜାୟ୍‌ ଆମନ୍‌ ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ଞେନ୍‌ ତଙ୍କୁମ୍‌ଲେ ଡକୋନା ।’” ");
INSERT INTO juy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ତିଆସନ୍‌ ଏ ଇସ୍ରାଏଲ୍‌ମର୍‌ଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ଜନାବେନ୍‌ତୋ, ଅଙ୍ଗା ଜିସୁ ଆମ୍ୱେନ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ତାଙ୍‌ଲେ ଏରବ୍ବୁଏନ୍‌, ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପ୍ରବୁ ଆରି କ୍ରିସ୍ଟ ଗାମ୍‌ଲେ ତବ୍‌ନଙେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","କେନ୍‌ ଆ ବର୍ନେ ମନ୍‌ରାଞ୍ଜି ଆରମ୍‌ଡଙେଞ୍ଜି, ଆ ଉଗରଞ୍ଜି ଆପପଗୋ ଡେଏଞ୍ଜି, ଆରି, ଆନିଞ୍ଜି ପିତ୍ରନ୍‌ ଡ ଆନ୍ନା ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ବୋଞାଙ୍‌ଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେନ୍‌ ଇନି ଏଏଙ୍ଗାନାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମ୍ୱେଞ୍ଜି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନାବା, ଆରି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଇର୍ସେଲୋଙ୍‌ ସିଲଡ୍‌ କେମାନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ତବ୍ବୁବ୍‌ଡାନାବା; ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆତନିୟ୍‌ତିୟ୍‌ ଏଞାଙ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ ଆ ପର୍ମାଡ଼ା ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌, ପସିୟ୍‌ବେଞ୍ଜି ଆସନ୍‌, ଆରି ପ୍ରବୁ ଇସ୍ୱରନ୍‌ ସାଙାୟ୍‌ରେଙ୍‌ ସିଲଡ୍‌ ଡିଅଙ୍ଗା ମନ୍‌ରାଜିଆଡଙ୍‌ ଆମଙନ୍‌ ଓଡ୍ଡେତଜି, ତି ଅଡ଼୍‌କୋଞ୍ଜି ଆସନ୍‌ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ଆରି ପିତ୍ରନ୍‌ ଜବ୍ର ବର୍ନେଞ୍ଜି ବର୍ରନ୍‌ ସାକିନ୍‌ ତିୟେନ୍‌, “କେନ୍‌ ପେଲ୍ଲାମରଞ୍ଜି ଆସନ୍‌ ପନବ୍‌ରଡନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଆଡିଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଡ଼ୁର୍‌ବେନ୍‌ତୋ ଗାମ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞଙ୍‌ଞଙେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ଆନାଜି ପିତ୍ରନ୍‌ ଆ ଞନଙ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଡର୍ରଞ୍ଜି ଆନିଞ୍ଜି ତବ୍ବୁବ୍‌ଡାଲଞ୍ଜି, ତିଆଡିଡ୍‌ ୟାଗି ଅଜାର ମନ୍‌ରା ମଣ୍ଡଡ଼ିଲୋଙନ୍‌ ମାୟ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ଆନିଞ୍ଜି ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲଞ୍ଜି, ଆ ଞନଙଞ୍ଜି ଅମ୍‌ଡଙେଞ୍ଜି, ପ୍ରବୁବୋଜନ୍‌ ଜୋମେଞ୍ଜି ଆରି ପାର୍ତନାଲନ୍‌ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ଆରି ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ସରାନ୍ନିଡାନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି, ଅରମ୍ମଡନ୍‌ ଆ କାବ୍ବାଡ଼ାଜି ଲୁମେଞ୍ଜି, ତିଆସନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ବତଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ବନ୍‌ଡ ଆନାଜି ଡର୍ରଞ୍ଜି ଆନିଞ୍ଜି ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲଞ୍ଜି, ଆନିଞ୍ଜି ଆ ଲବଞ୍ଜି, ଆନର୍ଜେଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ମୁର୍ସେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ଆରି ଆନିଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ବସେଙ୍‌ ଆ ଲବ ତମେଞ୍ଜି କି ଡାବ୍ବୋନ୍‌ ବାନ୍ତେଆଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ଆନିଞ୍ଜି ଆବମନ୍ନନ୍‌ ଏମ୍ମେଲନ୍‌ ଡିତାନ୍‌ ସରେବାସିଙନ୍‌ ରୁକ୍କୁଲନ୍‌ ଡକୋଲଞ୍ଜି, ଆରି ଅସିଂ ଅସିଂ ଇୟ୍‌ଲେ ରୁଟିନ୍‌ ରେବ୍‌ଲେ ସର୍ଡାନ୍‌ ବାତ୍ତେ ଆରି ଲଗଡ୍‌ ଉଗରନ୍‌ ବାତ୍ତେ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେଙ୍କେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ଆରି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଡୁଙ୍‌ୟମେଞ୍ଜି; ଅନୁରନ୍‌ ଆଞ୍ରାଙେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଇସ୍ୱରନ୍‌ ଡିତାନ୍‌ ମଣ୍ଡଡ଼ିଲୋଙନ୍‌ ଅବ୍‌ମାୟ୍‌ମାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ବଡିନ୍ନା ପାର୍ତନା ଇଙନ୍‌, ସାଲ୍ଲୁମନ୍‌ ୟାଗି ଗଣ୍ଟା ଇଙନ୍‌ ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ସରେବାସିଙନ୍‌ ଇୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ତିଆଡିଡ୍‌ ଅବୟ୍‌ ଆ ଗାଡ଼େମରନ୍‌ ମନ୍‌ରାଞ୍ଜି ବୋୟ୍‌ଲେ ପାଙେଞ୍ଜି; ତି ଆ ମନ୍‌ରା ଆୟୋଙନ୍‌ ଆ କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ମା ଆ ଗାଡ଼େ ଜନମ୍ମୁ ଡେଏନ୍‌ । ତେତ୍ତେ ମନଙ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଗରନ୍ନେନ୍‌ ଆଞୁମ୍‌ ଡକୋଏନ୍‌, ସରେବାସିଙନ୍‌ ଆରିୟ୍‌ତାଞଞ୍ଜି ଆ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ବେବ୍ବେଡ୍‌ନେନ୍‌ ଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ଡିତାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତେତ୍ତେ ଅମ୍‌ରେଙ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ଜିରେଜି । ");
INSERT INTO juy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ସରେବାସିଙନ୍‌ ଆରିୟେଞ୍ଜି ଆଡିଡ୍‌ ତି ଗାଡ଼େମରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବେଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆଙାଙ୍‌ଲେ ସେଡେଞ୍ଜି, ଆରି, ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ଅମଙ୍‌ଲେନ୍‌ ଆଙାଙାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ତି ଗାଡ଼େମରନ୍‌ ଇନ୍ନିଙ୍‌ ଞାଙ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଆସାଡାଲନ୍‌ ଆମଙ୍‌ବାଞ୍ଜି ଆଙାଙ୍‌ଲେ ସେଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅମଙ୍‌ଞେନ୍‌ ରୁପା ତଡ୍‌ କି ସୁନା ତଡ୍‌, ବନ୍‌ଡ ଅମଙ୍‌ଞେନ୍‌ ଇନି ଡକୋ ତିଆତେ ଞେନ୍‌ ଆମନ୍‌ ତିୟ୍‌ତମ୍‌; ନାଜରିତ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ତଙିୟ୍‌ନା ।” ");
INSERT INTO juy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ଆରି ପିତ୍ରନ୍‌ ତି ଗାଡ଼େମରନ୍‌ ଆର୍ଜଡ଼ୋମ୍‌ସି ଞମ୍‌ଲେ ଅବ୍‌ଡୋଏନ୍‌ । ସିଲତ୍ତେ ଅବ୍‌ତାଡ଼ନ୍‌ ଆ ତାଲ୍‌ଜଙନ୍‌ ଡ ଆମେଡଡ଼ିଞ୍ଜି ରଡୋଏନ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ଆରି ଆନିନ୍‌ ତୋର୍‌ଞାମ୍‌ଡାଲେ ତନଙେନ୍‌, କି ତଙିୟ୍‌ଲନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଇଡ୍ଡୋୟ୍‌ ଇଡ୍ଡୋୟ୍‌ଲନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେନ୍‌ଲେ ସେନ୍‌ଲେ ଆନିଞ୍ଜି ସରିନ୍‌ ସରେବାସିଙନ୍‌ ଗନ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ସିଲତ୍ତେ ଆନିନ୍‌ ଆତ୍ରଙିୟ୍‌ଲନ୍‌ ଡ ଇସ୍ୱରନ୍‌ ଆସ୍ରେଙ୍କେନେନ୍‌ ଆଡିଡ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଗିଜେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ଆରି କେନ୍‌ ଆ ମନ୍‌ରା ସରେବାସିଙନ୍‌ ମନଙ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଗରନ୍ନେଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଲେ ବେବ୍ବେଡ୍‌ଲନ୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଅମ୍ମଡେଞ୍ଜି, ଆନିନ୍‌ ଏଙ୍ଗାଲେ ମନଙେନ୍‌ ତିଆତେଜି ଗିୟ୍‌ଲେ ଆନିଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ଆନିନ୍‌ ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ବୟନ୍‌ ମାୟ୍‌ଲନ୍‌ ସୋଲମନନ୍‌ ଆ ପିଣ୍ଡାଲୋଙ୍‌ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ସାନ୍ନି ଡେଏଞ୍ଜି, ଆରି ଆମଙଞ୍ଜି ଇର୍ରାଜି କି ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି । ");
INSERT INTO juy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ପିତ୍ରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ବର୍ରନେ, “ଏ ଇସ୍ରାଏଲ୍‌ମର୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ଇନିବା କେନ୍‌ ମନ୍‌ରାନ୍‌ ଆସନ୍‌ ସାନ୍ନି ଡେତବେନ୍‌ ? ଇନ୍‌ଲେନ୍‌ ବପ୍ପୁଲେନ୍‌ ବାତ୍ତେ ଅଡ଼େ ବୋର୍ସାଲେନ୍‌ ବାତ୍ତେ କେନ୍‌ ମନ୍‌ରାନ୍‌ ଏବ୍‌ତଙିୟ୍‌ନେଲାୟ୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟ୍‌ଡାଲେ ଇନିବା ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ଆଙାଙ୍‌ଲେ ଏସେଡ୍‌ତଲେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଅବ୍ରାମନ୍‌, ଇସାକନ୍‌ ଡ ଜାକୁବନ୍‌ ଆ ଇସ୍ୱର, ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆ ଇସ୍ୱର, ଆ କମ୍ୱାରିମରନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆନିନ୍‌ ଅବ୍‌ଗୁଗୁଏନ୍‌ ଅବ୍‌ପେମେଙେନ୍‌; ତି ଆ ଜିସୁ ଆମ୍ୱେଞ୍ଜି ବନେରାମରଞ୍ଜି ଆସିଲୋଙ୍‌ ଏସୋରୋପ୍ପାୟେନ୍‌, ଆରି ପିଲାତନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ତାୟ୍‌ ଆଗ୍ରାମେନ୍‌, ତିଆଡିଡ୍‌ ପିଲାତନ୍‌ ଆତେମଡ୍‌ଲୋଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଃଡ୍ଡର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ଆନିନ୍‌ ମଡ଼ିର୍‌ ଆରି ଏର୍‌ଡୋସାମର୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଏଃଜ୍ଜାଲୋ, ଆପାଲ୍‌ତେଙନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଅବୟ୍‌ ସମ୍ୱବ୍‌ମରନ୍‌ ଅନମ୍‌ରେଙନ୍‌ ଆସନ୍‌ ପିଲାତନ୍‌ ଏବରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ବନ୍‌ଡ ଅନମେଙ୍‌ ତଙରନ୍‌ ଆରବ୍‌ତୁୟ୍‌ତେନ୍‌ ଆ ମନ୍‌ରା ଏରବ୍ବୁଏନ୍‌, ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଡୋଏନ୍‌, ତିଆତେଜି ଇନ୍‌ଲେନ୍‌ ସାକିନ୍‌ ଏତିୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ଆଞୁମ୍‌ଲୋଙନ୍‌ ଡକୋନ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ କେନ୍‌ ଆ ଗାଡ଼େମର୍‌ ମନଙେନ୍‌ । ନମିଞେନ୍‌ ଅଙ୍ଗାତେ ଆମ୍ୱେଞ୍ଜି ଗିୟ୍‌ଲେ ଆଜାଡ଼ିନ୍‌ ଗାମ୍‌ଲେ ଏଜନାଏନ୍‌; ତିଆତେ ଆଞୁମ୍‌ଲୋଙନ୍‌ ଡର୍ରନ୍‌ବୋ ଡେନ୍‌ ତୁମ୍‌ ଡେତେ; କେନ୍‌ ଆ ଗାଡ଼େମରନ୍‌ ଜିସୁନ୍‌ ଆମଙ୍‌ ଆଡର୍ରନେନ୍‌ ଆନିନ୍‌ ମନଙେନ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଏଗିଜେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ଆରି ନମି, ଏ ବୋଞାଙ୍‌ଜି, ସୋଡ଼ାମରଞ୍ଜି ଏଙ୍ଗାଲେ ଏର୍‌ଜନନାନ୍‌ ବାତ୍ତେ ଏତ୍ତେଏଞ୍ଜି, ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେ ଏର୍‌ଜନନାନ୍‌ ବାତ୍ତେ କେନ୍‌ଆତେ ଏଲୁମେନ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ଜନା । ");
INSERT INTO juy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଆଡ୍ରେଏନ୍‌ ଆ ବର୍ନେଜି ଇସ୍ୱରନ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ତଅଡ୍‌ଗଡ୍‌ ଆମ୍ମୁଙ୍‌ ମା ବର୍ରନେ, ମସିଅନ୍‌ ପନବ୍‌ରଡନ୍‌ ଞାଙ୍‌ତେ; ତି ଆ ବର୍ନେଜି ଅନ୍ତମ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଗବ୍‌ଡେଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ତିଆସନ୍‌, ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ୟର୍ନାୟ୍‌ବା, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆନିନ୍‌ ଇର୍ସେବେନ୍‌ କେମାତେ । ");
INSERT INTO juy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ଆରି ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ବୋର୍ସା ଏଞାଙ୍‌ତେ, ଆରି ଇସ୍ୱରନ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଆମ୍ମୁଙ୍‌ ମା ଆସ୍ରେଡାଏନ୍‌ ଆ ଜିସୁ କ୍ରିସ୍ଟ ଅମଙ୍‌ବେନ୍‌ ଆପ୍ପାୟ୍‌ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ଆମ୍ମୁଙ୍‌ ମା ମଡ଼ିର୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ବାତ୍ତେ ଇସ୍ୱରନ୍‌ ଆରବ୍‌ଜନାଏନ୍‌ ଅନ୍ତମ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ବାର୍‌ତନୁବନ୍‌ ଆଡ୍ରେତେନ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ ରୁଆଙ୍‌ଲୋଙନ୍‌ ଡକୋତନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ମୋସାନ୍‌ ବର୍ରନେ, ‘ପ୍ରବୁ ଇସ୍ୱରନ୍‌ ବୋଞାଙ୍‌ବେଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଞେନ୍‌ ଅନ୍ତମ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ତବ୍‌ନଙ୍‌ତେ, ଆନିନ୍‌ ଅଙ୍ଗା ବର୍ନେଜି ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେନ୍‌ ଅମ୍‌ଡଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ଆରି କେନ୍‌ ଅନ୍ତମ୍‌ ଡେତେ, ଅଙ୍ଗା ମନ୍‌ରା ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆ ବର୍ନେ ଆଲ୍ଲେତେ, ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଅନାନ୍ନାନ୍‌ ଡେତେ, ଆରି ରବୁତେ ।’ ");
INSERT INTO juy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ସାମୁଏଲ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ନିୟ୍‌ ତି ଆ ବର୍ନେ ବର୍ରନେ, ଆରି ତିକ୍କି ଆ ଡିନ୍ନାରେଙ୍‌ ଡିଅଙ୍ଗା ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ବର୍ରଞ୍ଜି, ତି ଆନିଞ୍ଜି ନିୟ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ଆମ୍ୱେଞ୍ଜି ତି ଆ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ଜି ଆଅନ୍‌ଜି, ଆରି, ‘କୁତ୍ତମ୍ମାବେନ୍‌ ଅମ୍ମେଲେ ପୁର୍ତିଲୋଙନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ କେଜ୍ଜାମର୍‌ଜି ଆସିର୍ବାଦନ୍‌ ଞାଙ୍‌ତଜି’ ଗାମ୍‌ଲେ ଇସ୍ୱରନ୍‌ ପୁର୍ବା ଜୋଜୋବେନ୍‌ ଅବ୍ରାମନ୍‌ ଆମନ୍‌ ବାସାଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ଆମ୍ୱେଞ୍ଜି ଡିଲେ ମନ୍‌ରାନ୍‌ ଆ ପେଲ୍ଲାଲୋଙନ୍‌ ସିଲଡ୍‌ ଆବ୍‌ଡିଡ୍‌ଲେ ଓରୋଙ୍‌ଡାଲେ ଆସିର୍ବାଦନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ପର୍ତମ୍ମୁ ଆ କମ୍ୱାରିମରନ୍‌ଆଡଙ୍‌ ଗବ୍‌ଡେଲ୍‌ଡାଲେ ଆପ୍ପାୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଆବର୍ରନ୍‌ ଆଡିଡ୍‌ ରାଓଡ଼ାଞ୍ଜି, ସରେବାସିଙନ୍‌ ଆଜ୍ରଗେତେଞ୍ଜି ଆ ସିପ୍ପାୟ୍‌ଜି ଡ ସାଦୁକିଞ୍ଜି ଆମଙଞ୍ଜି ଇୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ଆନିଞ୍ଜି ବରାବେଞ୍ଜି ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେଞ୍ଜି ଆରି ଜିସୁନ୍‌ ଆ ୟନର୍ମେଙ୍‌ ଆ ବର୍ନେ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ତିଆସନ୍‌ ଆନିଞ୍ଜି ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଆବାର୍ତାନ୍‌ ଜାୟ୍‌ ଡକ୍କୋଏଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତିଆଡିଡ୍‌ ଅରୁବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ବନ୍‌ଡ ଜବ୍ର ମନ୍‌ରାଜି ଆ ଞନଙଞ୍ଜି ଅମ୍‌ଡଙ୍‌ଡାଲେ ଡର୍ରଞ୍ଜି; ଆରି ତିଆଡିଡ୍‌ ଓବ୍ବାମରଞ୍ଜି ତୁମ୍‌ ଆ ଡନିଡି ମନ୍‌ଲୟ୍‌ ଅଜାର ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ତି ଆବାର୍ତାନ୍‌ ସୋଡ଼ାମରଞ୍ଜି, ପାପୁର୍‌ମରଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ଜିରୁସାଲମନ୍‌ ରୁକ୍କୁଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ତେତ୍ତେ ମୁଡ଼ ରାଓଡ଼ା ଆନାନନ୍‌, କାୟାପାନ୍‌, ଜନନ୍‌, ଆଲେକ୍‌ଜାଣ୍ଡାରନ୍‌ ଡ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆ କେଜ୍ଜାମର୍‌ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ଆନିଞ୍ଜି ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଆମୁକ୍କାବାଞ୍ଜି ମଡ୍ଡିନ୍‌ ତବ୍‌ନଙ୍‌ଲେ ବରେଞ୍ଜି, “ଆମ୍ୱେନ୍‌ କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଏଙ୍ଗାଲେ ଏଲୁମ୍‌ତେ ? ଅଙ୍ଗା ବୋର୍ସା ବାତ୍ତେ ଅଡ଼େ ଆନା ଆଞୁମ୍‌ଲୋଙ୍‌ ଆମ୍ୱେନ୍‌ କେନ୍‌ଆତେ ଏଲୁମେନ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ପିତ୍ରନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ବୋର୍ସା ଅମ୍ମେଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଏ ମନ୍‌ରାଞ୍ଜି ଆ ସୋଡ଼ାମର୍‌ଜି ଆରି ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମର୍‌ଜି, ");
INSERT INTO juy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ଲଙେ ଇନ୍‌ଲେନ୍‌ କେନ୍‌ ଆ ଗାଡ଼େମରନ୍‌ ଆସନ୍‌ ମନଙ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଏର୍‌ଲୁମ୍‌ଲାଞନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଆ ମନ୍‌ରା ଏଙ୍ଗାଲେ ମନଙେନ୍‌ ଗାମ୍‌ଲେ ଏବର୍ତଲେନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମ୍ୱେଞ୍ଜି ଅଡ଼୍‌କୋ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଜନାବା, ଅଙ୍ଗା ନାଜରିତ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ଏରବ୍ବୁଏନ୍‌, ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଡୋଏନ୍‌, ତି ଆଞୁମ୍‌ଲୋଙ୍‌ କେନ୍‌ ଆ ମନ୍‌ରା ମନଙେନ୍‌ କି ନମି କେନ୍‌ ମୁକ୍କାବାବେନ୍‌ ଆତନଙ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ଜିସୁନ୍‌ ଆ ବର୍ନେ ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆଇଡିଡ୍‌, ଆମ୍ୱେଞ୍ଜି ଗୁସିଂମରଞ୍ଜି, ‘ଆମ୍ୱେନ୍‌ ଅଙ୍ଗା ଆରେଙ୍‌ ଏବାସ୍ସେଏନ୍‌, ତିଆତେ କୁନେନ୍‌ ଆ ସୋଡ଼ା ଅରେଙ୍‌ ଡେଏନ୍‌, ଆନିନ୍‌ ତି ଆରେଙ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ଆନିନ୍‌ ତୁମ୍‌ ଅମ୍ମେଲେ ଇନ୍‌ଲେଞ୍ଜି ଅନୁରନ୍‌ ଞାଙ୍‌ତବୋ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରୁଆଙନ୍‌ ଆ ଜାୟ୍‌ତା ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଅନ୍ନିଙ୍‌ ଆଞୁମ୍‌ ବାତ୍ତେ ମନ୍‌ରାନ୍‌ ଅନୁରନ୍‌ ଅଃଞାଙେ ।” ");
INSERT INTO juy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ଆନିଞ୍ଜି ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ଆ ବୋର୍ସା ଗିୟ୍‌ଲେ ଆରି ଆନିଞ୍ଜି ଏର୍‌ପାଟମର୍‌ଜି ଗାମ୍‌ଲେ ଜନାଡାଲେ ସାନ୍ନି ଡେଏଞ୍ଜି ଆରି ଆନିଞ୍ଜି ଜିସୁନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲଞ୍ଜି ଗାମ୍‌ଲେ ତିଆଡିଡ୍‌ ଅମ୍ମଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ବନ୍‌ଡ ତି ଆମ୍ରନଙେନ୍‌ ଆ ମନ୍‌ରା ଆନିଞ୍ଜି ସରିନ୍‌ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲନ୍‌ ଗିଜେଞ୍ଜି କି, ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଆରି ଇନ୍ନିଙ୍‌ ବର୍ରନ୍‌ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ଆନିଞ୍ଜି ପନ୍‌ସୁଆତିଲୋଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଡାଣ୍ଡନ୍‌ ଜିର୍ବା ଗାମେଞ୍ଜି କି, ଆନିଞ୍ଜି ତର୍ଡମ୍‌ କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ଆନିଞ୍ଜି ଗାମେଞ୍ଜି “କେନ୍‌ ଆ ମନ୍‌ରାଜି ଇନି ଏଙ୍ଗାଗୋ ? ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ ଆନିଞ୍ଜି ଆର୍‌ଲୁମେଞ୍ଜି ଅବୟ୍‌ ସୋଡ଼ା ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ସମ୍ପରା ଜିରୁସାଲମବାଜି ଜନାଆଜେଞ୍ଜି, ଆରି ଇନ୍‌ଲେଞ୍ଜି ତିଆତେ ସସଲନ୍‌ ଅଃର୍ରପ୍ତିବୋ । ");
INSERT INTO juy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ବନ୍‌ଡ କେନ୍‌ ଆ ବର୍ନେ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅଃବ୍ବୁଡାୟ୍‌ନେ, ତିଆସନ୍‌ କେନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଆରି ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଇନ୍ନିଙ୍‌ ଏବର୍‌ଡଙ୍‌ନେ ଗାମ୍‌ଲେ ଏବବ୍‌ତଙ୍‌ବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ତିକ୍କି ଆନିଞ୍ଜି ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଜିସୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଇନ୍ନିଙ୍‌ ଏବର୍‌ଡଙ୍‌ନେ ଆରି ଇନ୍ନିଙ୍‌ ଞନଙନ୍‌ ଏତିୟ୍‌ଡଙ୍‌ ଗାମ୍‌ଲେ ଆକ୍ରାନ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଜାଲଙେଞ୍ଜି, “ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌ ଡେନ୍‌ ମନଙ୍‌ ଅଡ଼େ ବର୍ନେବେନ୍‌ ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌ ଡେନ୍‌ ମନଙ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ମା ବର୍ନାବା । ");
INSERT INTO juy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଇନିଜି ଏଗିୟ୍‌ଲାୟ୍‌ ଆରି ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌, ତିଆତେଜି ଏର୍‌ବନରନ୍‌ ଇନ୍‌ଲେନ୍‌ ଡକୋଲନ୍‌ ଏଃର୍ରପ୍ତିଆୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ସିଲତ୍ତେ ତେତ୍ତେ ଜବ୍ର ମନ୍‌ରା ଡକୋଏଞ୍ଜି ତିଆସନ୍‌ ଆନିଞ୍ଜି ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଡନଣ୍ଡାୟନ୍‌ ଆସନ୍‌ ତଙରନ୍‌ ଅଃଞାଙ୍‌ଲଜି, ସତ୍ତର୍‌ ବବ୍‌ତଙ୍‌ଡାଲେ ଅମ୍‌ରେଙେଞ୍ଜି । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତେତ୍ତେ ଇନିଜି ଡେଏନ୍‌ ତିଆତେଜି ଆସନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେଙ୍କେରାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ଅଙ୍ଗା ମନ୍‌ରା ସରାନ୍ନିଡାନ୍‌ ଅମ୍ମେଲେ ମନଙେନ୍‌ ଆନିନ୍‌ ବାକୁଡ଼ି ବର୍ସେଙ୍‌ ସିଲଡ୍‌ ଗୋଗୋୟ୍‌ ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ବଣ୍ଡିନ୍‌ ସିଲଡ୍‌ ଆଡ୍ରୁଙ୍‌ଲନାଞଞ୍ଜି ସିଲଡ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଆନିଞ୍ଜି ଆ ଗଡ଼ିଞ୍ଜି ଆମଙ୍‌ ଜିରେଞ୍ଜି ଆରି ସୋଡ଼ା ରାଓଡ଼ାନ୍‌ ଡ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରଞ୍ଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଇନିଜି ଗାମେଞ୍ଜି ତିଆତେ ଅଡ଼୍‌କୋନ୍‌ ଇୟ୍‌ଲେ ବର୍ନେଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ଡର୍ନେମରଞ୍ଜି ତି ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଆରମ୍‌ଡଙେଞ୍ଜି ଆବମନ୍ନନ୍‌ ଏମ୍ମେଲନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ଏନ୍ନେଲେ ପାର୍ତନାଲଞ୍ଜି; “ଏ ପ୍ରବୁ ଆମନ୍‌ ରୁଆଙନ୍‌, ପୁର୍ତିନ୍‌, ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆରି ତେତ୍ତେ ଡକୋନ୍‌ଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଗବ୍‌ଡେଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବାତ୍ତେ ଆମନ୍‌ ପୁର୍ବା ଜୋଜୋଲେନ୍‌ ଡ କମ୍ୱାରିମର୍‌ନମ୍‌ ଦାଉଦନ୍‌ ଆ ତଅଡ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ, ‘ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଇନିଆସନ୍‌ ବାବନ୍‌ଡ୍ରାବ୍‌ ବାବ୍ବାବେଞ୍ଜି, ଆରି ଇନିଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ଅଃଗଡେଲେନ୍‌ ଆ ବର୍ନେ ପାଙ୍‌ଲେ ତନ୍ତ୍ରଏଞ୍ଜି ? ");
INSERT INTO juy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ପ୍ରବୁନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଆରି ଆନିନ୍‌ ଆରବିସେକଏନ୍‌ ଆ ମନ୍‌ରା ଆ ବିରୁଦଲୋଙ୍‌, ପୁର୍ତିନ୍‌ ଆ ରାଜାଜି ତନଙେଞ୍ଜି, ଆରି ସୋଡ଼ାମରଞ୍ଜି ରୁକ୍କୁଲଞ୍ଜି ।’ ");
INSERT INTO juy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମଡ଼ିର୍‌ କମ୍ୱାରିମର୍‌ନମ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଆମନ୍‌ ଅବିସେକଏନ୍‌, ଆଜାଡ଼ିଡମ୍‌ ଏରୋଦନ୍‌ ଡ ପନ୍ତିଅ ପିଲାତନ୍‌ ବାଗୁଞ୍ଜି ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଡ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ସରିନ୍‌ ରୁକ୍କୁଡାଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବିରୁଦଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ବୋର୍ସାନମ୍‌ ଡ ଅନିଃୟମ୍‌ନମ୍‌ ବାତ୍ତେ ଅଡ଼୍‌କୋନ୍‌ ଇନି ଡେଡମ୍‌ତେ ଗାମ୍‌ଲେ ଆମନ୍‌ ଗବ୍‌ରିଏନ୍‌, ତିଆତେ ଲନୁମନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜି ରୁକ୍କୁଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ପ୍ରବୁ, ନମି ଆନିଞ୍ଜି ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ବବ୍‌ତଙ୍‌ତଲେଞ୍ଜି, ଆମନ୍‌ ତି ଆ ବର୍ନେ ଗିଜା ଆରି ଏର୍‌ବନ୍ତଙନ୍‌ ବର୍ନେନମ୍‌ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଆସନ୍‌ କେନ୍‌ କମ୍ୱାରିମର୍‌ନମ୍‌ଜିଆଡଙ୍‌ ବୋର୍ସାନ୍‌ ତିୟାଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ଆରି ମଡ଼ିର୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ନମ୍‌ ଜିସୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ମନବ୍‌ନଙନ୍‌ ଆସନ୍‌ ଆରି ଅରମ୍ମଡଞ୍ଜି ଡ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ଅସିନମ୍‌ ତେକ୍କେଆ ।” ");
INSERT INTO juy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ଆନିଞ୍ଜି ଆପାର୍ତନାଲଞ୍ଜି ଆ ତିକ୍କି, ଅଙ୍ଗା ଆ ଡରକୋନେଲୋଙ୍‌ ରୁକ୍କୁଲନ୍‌ ଡକୋଲଞ୍ଜି, ତି ତେତ୍ତେ ୟୁଲନେ । ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ବରିଜେଞ୍ଜି କି ଏର୍‌ବନ୍ତଙନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅପ୍ପୁଙ୍‌ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ଡର୍ନେମରଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଆବମନ୍ନନ୍‌ ଡ ଆବପରାନ୍ନାନ୍‌ ଡେଏଞ୍ଜି । ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଆନର୍ଜେଞ୍ଜି ଇନ୍‌ଲେନ୍‌ଆତେ ଅଃଗାମ୍‌ଲଜି, ବନ୍‌ଡ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆନର୍ଜେ ଆନିଞ୍ଜି ଆବସରିନ୍‌ ବାନ୍ତେଲେ ଜୋମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ସୋଡ଼ା ବୋର୍ସାନ୍‌ ବାତ୍ତେ ପ୍ରବୁ ଜିସୁନ୍‌ ଆ ୟନର୍ମେଙ୍‌ ଆ ବର୍ନେ ସାକିନ୍‌ ତିୟେଞ୍ଜି, ଆରି ଇସ୍ୱରନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆସିର୍ବାଦଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ତିଆସନ୍‌ ଆମଙ୍‌ଲୋଙଞ୍ଜି ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଇନ୍ନିଙ୍‌ ଅବାବ ଅଃଡ୍ଡେଲଜି, ଡିଅଙ୍ଗା ମନ୍‌ରାଜି ଆମଙ୍‌ ଲବସିମା, ଅସିଂ ଡକୋଏନ୍‌, ଆନିଞ୍ଜି ତିଆତେଜି ତମେଞ୍ଜି କି ତଙ୍କାନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ପାଙ୍‌ଲେ ଇୟ୍‌ଲାୟ୍‌ ତିୟେଜି; ");
INSERT INTO juy_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ଆରି ଡିଲେ ମନ୍‌ରାନ୍‌ ଆ ସନାୟ୍‌ସାୟ୍‌ ଅନ୍ତମ୍‌ ତିଆତେ ତିୟ୍‌ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ଆରି, ଜୋସେପନ୍‌, ଆନିନ୍‌ ଲେବି କେଜ୍ଜାମର୍‌ ସାଇପ୍ରସ୍‌ଲୋଙନ୍‌ ଜନମ୍ମୁ ଡେଏନ୍‌, ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବର୍ନବା ଗାମ୍‌ଲେ ଅବ୍‌ଞୁମେଞ୍ଜି, ବାଣ୍ଡାଲବୋ ଡେନ୍‌ କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌ “ବନବ୍‌ୟୋ ଡାଙ୍ଗଡ଼ାଅନ୍‌” ଡେତେ । ");
INSERT INTO juy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ଆ ବସେଙନ୍‌ ଅବୟ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ତିଆତେ ତମ୍‌ଲେ ତି ଆ ତଙ୍କା ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ତିୟେଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ଅନାନିଅ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆ ଡୁକ୍ରିନ୍‌ ଆଞୁମ୍‌ ସପିରା । ଆନିଞ୍ଜି ବାଗୁଞ୍ଜି କଡାଡ଼ିଡାଲନ୍‌ ଅସୋୟ୍‌ ଆନର୍ଜେଞ୍ଜି ତମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ଆରି ଆନିଞ୍ଜି ଅନର୍ଜେନ୍‌ ତମ୍‌ଲେ ଆଞ୍ରାଙେଞ୍ଜି ଆ ତଙ୍କା ଲାଙ୍‌ଲେଡ୍‌ ସଲେ ଡକ୍କୋଏଞ୍ଜି କି ଲାଙ୍‌ଲେଡ୍‌ ତଙ୍କାନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ତିୟେଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ଏ ଅନାନିଅ, ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆମଙ୍‌ ସସନେନ୍‌ ଆସନ୍‌ ଆରି ବସେଙନ୍‌ ତମ୍‌ଲେ ଏଞ୍ରାଙେନ୍‌ ଆ ତଙ୍କା ଲାଙ୍‌ଲେଡ୍‌ ସଲେ ଡନକ୍କୋନ୍‌ ଆସନ୍‌, ଇନିବା ସନୁମନ୍‌ ଉଗର୍‌ଲୋଙ୍‌ନମ୍‌ କାବ୍ବାଡ଼ାଲନ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ତି ଆ ବସେଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ତମେନ୍‌ ଆଡିଡ୍‌ ତିଆତେ ଆମନ୍‌ଆତେ ଅଃଡ୍ଡକୋଲୋ ପଙ୍‌ ? ଆରି ତରମେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତି ଆ ତଙ୍କା ଆମନ୍‌ଆତେ ଅଃଡ୍ଡକୋଲୋ ପଙ୍‌ ? ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ଏଙ୍ଗାଲେ ଉଗର୍‌ଲୋଙ୍‌ନମ୍‌ ଏନ୍ନେଲେ ଇୟମେନ୍‌ ? ଆମନ୍‌ ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ଅଃସସଲନ୍‌, ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସସଲନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ଅନାନିଅନ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ ଜାୟ୍‌ତାନ୍‌ ଗୋଙେନ୍‌ କି ରବୁଏନ୍‌ । ସିଲତ୍ତେ ଡିଅଙ୍ଗା ମନ୍‌ରା କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙେଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ଆରି ବେଣ୍ଡିଆମରଞ୍ଜି ଜିର୍ରାଜି କି ଅନାନିଅନ୍‌ ଆ ମରା ସିନ୍‌ରିନ୍‌ ୟୁମ୍‌ଲେ ବୋୟ୍‌ଲେ ପାଙେଞ୍ଜି କି ଇୟ୍‌ଲେ ତିଲେଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ୟାଗି ଗଣ୍ଟା ଆ ତିକ୍କି ଆ ଡୁକ୍ରିନ୍‌ ଇୟ୍‌ଲାୟ୍‌, ବନ୍‌ଡ ଇନି ଡେଏନ୍‌ ତିଆତେ ଆନିନ୍‌ ଅଃଜ୍ଜନାଲୋ । ");
INSERT INTO juy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ବର୍ନା ଲା, ଡିୟ୍‌ତେ ତଙ୍କା ବାତ୍ତେ ପଙ୍‌ ଆମ୍ୱେନ୍‌ ବସେଙନ୍‌ ଏତମେନ୍‌ ?” ଆନିନ୍‌ ଜାଲଙେନ୍‌, “ଓଓ, ଡିୟ୍‌ତେ ତଙ୍କା ବାତ୍ତେ ବସେଙନ୍‌ ଏତମ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପ୍ରବୁନ୍‌ ଆ ପୁରାଡ଼ା ମନାଲ୍‌ମାଲନ୍‌ ଆସନ୍‌ ଇନିବା ବାଗୁନ୍‌ବେନ୍‌ ଆବମନ୍ନନ୍‌ ଏଏମ୍ମେଲନ୍‌ ? ଗିଜା, ଆନାଜି ଅୟ୍‌ତବ୍‌ନମ୍‌ ଇୟ୍‌ଲେ ତିଲେଜି, ଆନିଞ୍ଜି ସନଙ୍‌ଲୋଙନ୍‌ ଅଡ଼ୋଲାଜିନି, ଆରି ଆନିଞ୍ଜି ଆମନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ବୋୟ୍‌ଲେ ଡାଣ୍ଡନ୍‌ ପାଙ୍‌ତମ୍‌ଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ସିଲତ୍ତେ ଅବ୍‌ତାଡ଼ନ୍‌ ସପିରାନ୍‌ ପିତ୍ରନ୍‌ ଆ ତାଲ୍‌ଜଙ୍‌ବା ଗୋଙେନ୍‌ କି ରବୁଏନ୍‌ । ଆରି ବେଣ୍ଡିଆମରଞ୍ଜି ଅମ୍ମସିଙନ୍‌ ଗନ୍‌ଲେ ସପିରାନ୍‌ ଆରବୁ ଇୟ୍‌ଲାୟ୍‌ ଗିଜେଜି, ତିଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଡୁଆରାନ୍‌ ବୋୟ୍‌ଲେ ପାଙେଞ୍ଜି କି ଆ ଅୟ୍‌ତବନ୍‌ ଆ ମସାନ୍ନି ଆତୟ୍‌ତୟ୍‌ ଇୟ୍‌ଲେ ତିଲେଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ସିଲତ୍ତେ ଅଡ଼୍‌କୋ ମଣ୍ଡଡ଼ିନ୍‌ ଆ ମନ୍‌ରାଜି ଆରି ଡିଅଙ୍ଗା ମନ୍‌ରା କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙେଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ବତଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଜବ୍ରଡମ୍‌ ଅରମ୍ମଡଞ୍ଜି ଡ ସାନ୍ନି କାବ୍ବାଡ଼ାଞ୍ଜି ଲୁମେଞ୍ଜି, ଆରି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ସୋଲମନନ୍‌ ଆ ପିଣ୍ଡାଲୋଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁକ୍କୁନେଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ବନ୍‌ଡ ଆନ୍ନାମରଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ସିଲଡ୍‌ ଆନ୍ନିଙ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ନେନ୍‌ ଆସନ୍‌ ଅଃନ୍ନୋମଙ୍‌ଲଜି, ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ସେଙ୍କେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ଆରି ଜବ୍ରଡମ୍‌ ଓବ୍ବାମରଞ୍ଜି ଡ ଆଇମରଞ୍ଜି ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି କି ମଣ୍ଡଡ଼ିଲୋଙନ୍‌ ମାୟ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ପିତ୍ରନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଆଡିଡ୍‌ ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅସୁମରଞ୍ଜି ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଆ ଉମ୍ମୁଲନ୍‌ ଜାବେତୋ ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଅସୁମରଞ୍ଜିଆଡଙ୍‌ ବୋୟ୍‌ଲେ ଡାଣ୍ଡନ୍‌ ସପାଲୋଙନ୍‌ ଡ କଟଲୋଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଡକ୍କୋଏଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଜିରୁସାଲମନ୍‌ ଆ ତୁୟାୟ୍‌ରେଙ୍‌ ଆଡ୍ରକୋଏନ୍‌ ସମ୍ପରାନ୍‌ ଆ ଗଡ଼ାରେଙ୍‌ ସିଲଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଅସୁମରଞ୍ଜି ଡ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରାଜି ଓରୋଙ୍‌ଲାଜି, ଆରି ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ମନଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି, ସାଦୁକିଞ୍ଜି ଇସ୍କତ୍ତାନ୍‌ ବାତ୍ତେ ପସୋୟ୍‌ଲଗୋ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ଆରି ଆନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିଲେ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକ୍କୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ବନ୍‌ଡ ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ବଣ୍ଡିସିଙନ୍‌ ଆ ସନଙ୍‌ଜି ରୋଆଜେନ୍‌, ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ଡୁଆରାନ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ଓରୋଙ୍‌ଲାଜି କି ଇୟ୍‌ଲାୟ୍‌ ବରେଜି; ");
INSERT INTO juy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ଜିର୍ବା, ସରେବାସିଂଲୋଙନ୍‌ ତନଙ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ କେନ୍‌ ଅନମେଙନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଇୟ୍‌ ବର୍ବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଅଣ୍ଡ୍ରଙନ୍‌ ଡୋତାନ୍‌ ସରେବାସିଙନ୍‌ ଜିର୍ରେ ଞନଙନ୍‌ ଇୟ୍‌ଲେ ତିୟେଜି । ତିଆଡିଡ୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଡ ଆ ସର୍ସି କାବ୍ବାଡ଼ାମରଞ୍ଜି ଜିର୍ରେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଡ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆ ପାପୁର୍‌ମରଞ୍ଜି ଓଡ୍ଡେଡାଲେ ରୁକ୍କୁଲଞ୍ଜି, ଆରି ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ବଣ୍ଡିସିଙନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ମନ୍‌ରାନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ସିପ୍ପାୟଞ୍ଜି ବଣ୍ଡିସିଙନ୍‌ ଇୟେଞ୍ଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନେରବାଙ୍‌ଲଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ୟର୍ରନାଜି କି ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, ");
INSERT INTO juy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ଇନ୍‌ଲେଞ୍ଜି ଇୟ୍‌ଲେ ଏଗିୟ୍‌ଲାୟ୍‌, ବଣ୍ଡିସିଙନ୍‌ ମନଙ୍‌ଡମ୍‌ ଆଇଙଡ୍‌ ଆରି ଜଗେସିଂମରଞ୍ଜି ସନଙ୍‌ଲୋଙନ୍‌ ଆତନଙ୍‌ଜି, ବନ୍‌ଡ ସନଙନ୍‌ ରୋଲେ ଅମ୍ମନ୍‌ ଇୟ୍‌ଲେ ଏଗିୟ୍‌ନାଞନ୍‌ ଆନ୍ନିଙ୍‌ ଏଃନ୍ନେରବାଙ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଲେ ସରେବାସିଙନ୍‌ ଆ ସିପ୍ପାୟ୍‌ ଡ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଇନି ଡେତେ ଗାମ୍‌ଲେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆ ବର୍ନେ ଇୟମ୍‌ଡାଲେ ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ତିଆଡିଡ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଜିର୍ରେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଅମ୍‌ଡଙ୍‌ବା, ଅଙ୍ଗା ମନ୍‌ରାଜି ଆମ୍ୱେନ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ବଣ୍ଡିଲେ ଏଡକ୍କୋଏଞ୍ଜି, ଆନିଞ୍ଜି ସରେବାସିଂଲୋଙନ୍‌ ତନଙ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ତଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ତିଆଡିଡ୍‌ ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ କାବ୍ବାଡ଼ାମରଞ୍ଜି ସରିନ୍‌ ଇୟ୍‌ଲେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଇୟ୍‌ଲେ ଓରୋଙେଜି । ବନ୍‌ଡ ବଡଗାଁୟ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଃନ୍ନେଓରୋଙ୍‌ଲଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅସମୟ୍‌ ମନ୍‌ରାଞ୍ଜି ଅରେଙନ୍‌ ବାତ୍ତେ ତିଡ୍‌ତଲେଞ୍ଜି ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ଆନିଞ୍ଜି ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଓରୋଙ୍‌ଲେ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜି ଆ ତେମଡ୍‌ଲୋଙ୍‌ ତବ୍‌ନଙ୍‌ଲେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“କେନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଞନଙନ୍‌ ଏତିୟ୍‌ଡଙ୍‌ ଗାମ୍‌ଲେ ଇନ୍‌ଲେନ୍‌ ଏବର୍ରବେନ୍‌, ବନ୍‌ଡ ଗିୟ୍‌ବା, ସମ୍ପରା ଜିରୁସାଲମନ୍‌ ଆମ୍ୱେଞ୍ଜି ଞନଙ୍‌ ଏତିୟେନ୍‌ ଆରି ତି ଆ ମନ୍‌ରା ଆ ରନବୁ ଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଏବ୍‌ଡୋସାତଲେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଡ ଆନ୍ନା ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜାଲଙ୍‌ଲଞ୍ଜି, “ଇନ୍‌ଲେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଏମାନ୍ନେତାୟ୍‌, ମନ୍‌ରାନ୍‌ ଆ ବର୍ନେ ଏଃମ୍ମାନ୍ନେଆୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ଅଙ୍ଗା ଜିସୁ ଆମ୍ୱେଞ୍ଜି ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ତାଙ୍‌ଲେ ଏରବ୍ବୁଏନ୍‌, ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆ ଇସ୍ୱର ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଡୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଆରି ଆନିନ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନେନ୍‌ ଡ ଇର୍ସେନ୍‌ ସିଲଡ୍‌ କେମାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌, ଇସ୍ୱରନ୍‌ ଆର୍ଜଡ଼ୋମ୍‌ସିନ୍‌ ବାତ୍ତେ ଆନିନ୍‌ଆଡଙ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମର୍‌ ଆରି ଅନୁର୍‌ମର୍‌ ଅମ୍ମେଲେ ତବ୍‌ନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ଆରି, ଇନ୍‌ଲେଞ୍ଜି କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେଜି ଆସନ୍‌ ସାକିମର୍‌ଜି, ଆରି ଅଙ୍ଗା ମନ୍‌ରାଜି ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ମାନ୍ନେତଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଆନିନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ତିୟେଞ୍ଜି, ତି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ନିୟ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଆସନ୍‌ ସାକିନ୍‌ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","କେନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନିଞ୍ଜି ଆକ୍ରାନ୍‌ ବରାବେଞ୍ଜି ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ସାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ବନ୍‌ଡ ଗମଲିଏଲ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ପାରୁସିନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଆ ଞନଙ୍‌ତିୟ୍‌ମର୍‌, ଆରି ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ମାନ୍ନେତଜି, ଆନିନ୍‌ ପନ୍‌ସୁଆତିଲୋଙନ୍‌ ତନଙ୍‌ଡାଲେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ବସନ୍ନେଃ ଆସନ୍‌ ଅନମ୍‌ଡୁଙନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ଆରି ଆନିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ ଇସ୍ରାଏଲ୍‌ମର୍‌ଜି, କେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆମ୍ୱେଞ୍ଜି ଇନି ଏଏଙ୍ଗାତାୟ୍‌ ଏଗାମ୍‌ତେ, ତିଆତେ ଆସନ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା । ");
INSERT INTO juy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମ୍ମୁଙ୍‌ ତିଉଦାନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଅବୟ୍‌ ସୋଡ଼ାମର୍‌ ଗାମ୍‌ଡମ୍‌ଲନ୍‌, ଆରି ଉଞ୍ଜିସଅ ମନ୍‌ରା ଆନିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲଞ୍ଜି; ବନ୍‌ଡ ଆନିନ୍‌ ରବୁଏନ୍‌, ଆରି ଡିଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି ତି ଅଡ଼୍‌କୋଞ୍ଜି ପିରିଙ୍‌ପାଡାନ୍‌ ଡେଆଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ତି ଆ ମନ୍‌ରା ସିଲଡ୍‌ଲ୍ଲନ୍‌, ମନ୍‌ରାନ୍‌ ଡନିଡିନ୍‌ ଆଡ୍ରେଏନ୍‌ ଆଡିଡ୍‌ ଗାଲିଲିବାୟ୍‌ ଜିଉଦାନ୍‌ ଡୁଙ୍‌ଲନାୟ୍‌ କି ମନ୍‌ରାଞ୍ଜି ଅବ୍‌ରୁକ୍କୁଡାଲେ ଗୋଡ଼େନ୍‌ ଅମ୍‌ଡୁଙେନ୍‌; ଆନିନ୍‌ ନିୟ୍‌ ରବୁଏନ୍‌, ଆରି ଡିଅଙ୍ଗା ମନ୍‌ରା ଆନିନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙେଞ୍ଜି, ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ପିରିଙ୍‌ପାଡାନ୍‌ ଡେଆଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଆ ମନ୍‌ରାଜି ଇନ୍ନିଙ୍‌ ଏଏଙ୍ଗାଡଙ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ବାଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ ଆନିଃୟମ୍‌ ଅଡ଼େ କେନ୍‌ ଆ କାବ୍ବାଡ଼ା ମନ୍‌ରାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡେଏନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ତିଆତେ ରସମ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ବନ୍‌ଡ ତିଆତେ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଡେଏନ୍‌ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଡଙ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ, ଅସମୟ୍‌ ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ଏଡୋତନ୍‌ ଗାମ୍‌ଲେ ରାଙ୍‌ଡାତବେନ୍‌ ।” ତେତ୍ତେ ଆତଙ୍କୁମ୍‌ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ଗମଲିଏଲନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ଆରି ଆନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଅମ୍ମସିଙନ୍‌ ଓଡ୍ଡେଡାଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ତିଡେଞ୍ଜି କି ଜିସୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଇନ୍ନିଙ୍‌ ଏବର୍‌ଡଙ୍‌ନେ ଗାମ୍‌ଲେ ବର୍ରେ ଅମ୍‌ରେଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ସିଲତ୍ତେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଜିସୁନ୍‌ ଆଞୁମ୍‌ ଆସନ୍‌ ତନିଡନ୍‌ କନଞନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ ଗାମ୍‌ଲେ ସର୍ଡାନ୍‌ ବାତ୍ତେ ପନ୍‌ସୁଆତିସିଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ଆରି ଆନିଞ୍ଜି ଡିତାନ୍‌ ସରେବାସିଂଲୋଙନ୍‌ ଡ ଅସିଂ ଅସିଂ ଇୟ୍‌ଲେ ଜିସୁନ୍‌ ମା କ୍ରିସ୍ଟ ଗାମ୍‌ଲେ ଞନଙନ୍‌ ତିୟେଞ୍ଜି; ଆନିଞ୍ଜି ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙନ୍‌ ଆସନ୍‌ ଅଃଲ୍ଲୋଲୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ତିଆଡିଡ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଗୋଗୋୟ୍‌ଲେ ପାଙେଞ୍ଜି, ଆରି ଗ୍ରିକ୍‌ ଲଙ୍‌ଲଙନ୍‌ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ଆ ଜିଉଦିଜି ଡ ଏବ୍ରିଲଙ୍‌ଲଙନ୍‌ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ଆ ଜିଉଦିଜି ଗୋଡ଼େଲଞ୍ଜି । ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ତି ଆଡିଡ୍‌ ଡିତାନ୍‌ ଆ ପଡ଼ି ଆସନ୍‌ ଡାବ୍ବୋନ୍‌ ଆବ୍ରାନ୍ତେଏଞ୍ଜି ଆଡିଡ୍‌ ଜୁଆର୍‌ବଜଞ୍ଜି ମନଙ୍‌ ଅଃଗିଜେଜି ଗାମ୍‌ଲେ ଗ୍ରିକ୍‌ ଲଙ୍‌ଲଙନ୍‌ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ଆ ଜିଉଦିଜି ଏବ୍ରିଲଙ୍‌ଲଙନ୍‌ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ଆ ଜିଉଦିଜି ଆ ବିରୁଦଲୋଙ୍‌ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ତିଆସନ୍‌ ବାରଜଣ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ବରେଞ୍ଜି, “ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜନୋମ୍‌ଜୋମନ୍‌ ଆ ବନାନ୍ତେଲୋଙ୍‌ ମଗାଡ୍‌ଲେ ଅଃଡ୍ଡକୋନେବୋ । ");
INSERT INTO juy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ତିଆସନ୍‌ ଏ ବୋଞାଙ୍‌ଜି, ଅମଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ସିଲଡ୍‌ ଅଙ୍ଗା ମନ୍‌ରାଜି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡ ବୁଡ୍ଡିନ୍‌ ଡକୋ ଏତ୍ତେଗନ୍‌ ଆ ମନ୍‌ରାଜି ସାତଜଣ କେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଆସନ୍‌ ସେଡାବା । ");
INSERT INTO juy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇନ୍‌ଲେନ୍‌ ପାର୍ତନାନେନ୍‌ ଡ ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଆସନ୍‌ ରୟଙ୍‌ଲଙ୍‌ତନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","କେନ୍‌ ଆ ବର୍ନେ ଅଡ଼୍‌କୋ ଞଙ୍‌ନେମରଞ୍ଜି ଅଡ଼େଏଞ୍ଜି, ଆରି ଆନିଞ୍ଜି କେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଆସନ୍‌ ଡର୍ନେନ୍‌ ଡ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆଞାଙ୍‌ଞାଙନ୍‌ ତିପାନ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆରି ପିଲିପନ୍‌, ପ୍ରକରନ୍‌, ନିକାନୋରନ୍‌, ତିମୋନନ୍‌, ପାର୍ମନାନ୍‌ ଡ ଆମ୍ମୁଙ୍‌ ଜିଉଦି ଡରମ୍ମଲୋଙନ୍‌ ଆମ୍ରାୟ୍‌ଲନ୍‌ ଆନ୍ତିଅକିଆବାୟ୍‌ ନିକଲାୟନ୍‌ ସେଡାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","କେନ୍‌ ସାତଜଣଞ୍ଜି ଆବବ୍‌ଲୋଙ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆସିଞ୍ଜି ଡକ୍କୋଡାଲେ ପାର୍ତନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଜନାଆଜେଞ୍ଜି ଆରି ଜିରୁସାଲମଲୋଙନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଗୋଗୋୟ୍‌ଲେ ପାଙେଞ୍ଜି; ଆରି ରାଓଡ଼ାଞ୍ଜି ନିୟ୍‌ ଗୋଗୋୟ୍‌ନେଡମ୍‌ କ୍ରିସ୍ଟାନୁଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ତିପାନନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ସନାୟୁମନ୍‌ ଡ ବୋର୍ସାନ୍‌ ଞାଙ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ସୋଡ଼ା ସୋଡ଼ା ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ଡ ଅରମ୍ମଡଞ୍ଜି ଲୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ବନ୍‌ଡ ଲିବର୍ତିଅ, କୁରିଣିଅ ଆରି ଆଲେକ୍‌ଜାଣ୍ଡ୍ରିଆ ଆଗ୍ରାମ୍‌ତେଞ୍ଜି ଜିଉଦିମରଞ୍ଜି ଆ ରନୁକ୍କୁସିଂ ଆ ମନ୍‌ରାଜି ଲାଙ୍‌ଲେନ୍ନେ ଆରି କିଲିକିଆନ୍‌ ଡ ଆସିଆବାଜି ଲାଙ୍‌ଲେନ୍ନେ ଜିର୍ରାଜି କି ତିପାନନ୍‌ ଆମଙ୍‌ ଗୋଡ଼େନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତବେଜି । ");
INSERT INTO juy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ଆରି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ତିପାନନ୍‌ଆଡଙ୍‌ ଏତ୍ତେଲେ ଆ ବୁଡ୍ଡି ତିଏନ୍‌ ଡ ଆନ୍ନିଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙ୍‌ଲେ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ତିଆସନ୍‌ ଆନିଞ୍ଜି “କେନ୍‌ ଆ ମନ୍‌ରା ମୋସାନ୍‌ ଡ ଇସ୍ୱରନ୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ନିଣ୍ଡୟେନ୍‌, ତିଆତେ ଇନ୍‌ଲେନ୍‌ ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌” ଗାମ୍‌ଲେ ବର୍ନେନ୍‌ ଆସନ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଞଙ୍‌ଞଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ଆରି, ଆନିଞ୍ଜି ମନ୍‌ରାଞ୍ଜି, ପାପୁର୍‌ମରଞ୍ଜି ଡ ସାସ୍ତ୍ରିଞ୍ଜି ସୁସ୍କାୟେଞ୍ଜି କି ତିପାନନ୍‌ଆଡଙ୍‌ ଞମ୍‌ଲେ ପନ୍‌ସୁଆତିସିଙନ୍‌ ଓରୋଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ଆରି ତେତ୍ତେ କଣ୍ଡାୟ୍‌ ସାକିମରଞ୍ଜି ତବ୍‌ନଙେଞ୍ଜି; ଆନିଞ୍ଜି ବର୍ରଞ୍ଜି, “କେନ୍‌ ଆ ମନ୍‌ରା, ମଡ଼ିର୍‌ ସରେବାସିଙନ୍‌ ଡ ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଆ ବିରୁଦଲୋଙ୍‌ ବର୍ତନେ । ");
INSERT INTO juy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ନାଜରିତ ଜିସୁନ୍‌ କେନ୍‌ ଆ ସରେବାସିଂ ପୁଡ୍‌ତେ ଆରି ମୋସାନ୍‌ ଅଙ୍ଗା ବନାଁୟ୍‌ବର୍‌ଜି ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ଲନ୍‌ ତି ଅଡ଼୍‌କୋନ୍‌ ବାରାୟ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଆନିନ୍‌ ବର୍ରନେ ଇନ୍‌ଲେନ୍‌ ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ତିଆଡିଡ୍‌ ତେତ୍ତେ ଆତଙ୍କୁମନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜି ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ତିପାନନ୍‌ ଆମଙ୍‌ଗଡ୍‌ ଆଙାଙ୍‌ଲେ ସେଡେଞ୍ଜି, ଆରି ତିପାନନ୍‌ ଆ ମୁକ୍କା ରୁଆଙ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆ ମୁକ୍କା ଅନ୍ତମ୍‌ ରାଙ୍‌ଡାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ସିଲତ୍ତେ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ତିପାନନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କେନ୍‌ ଆ କନାୟ୍‌କାୟ୍‌ଜି ଅଡ଼୍‌କୋନ୍‌ ଆଜାଡ଼ିନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ତିପାନନ୍‌ ବର୍ରନେ, “ଏ ବୋଞାଙ୍‌ଜି, ଆପେୟ୍‌ଜି, ଅମ୍‌ଡଙ୍‌ବା । ଆପେୟ୍‌ଲେନ୍‌ ଅବ୍ରାମନ୍‌ ଆରଣ ଡେସାଲୋଙନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଡକୋନେନ୍‌ ଆମ୍ମୁଙ୍‌, ଆନିନ୍‌ ମେସପଟାମିଆ ଡେସାଲୋଙନ୍‌ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌ ଗନୁଗୁ ପନେମେଙନ୍‌ ଆଞ୍ରାଙ୍‌ତେନ୍‌ ଆ ଇସ୍ୱର ଆମଙନ୍‌ ଅବ୍‌ଗିୟ୍‌ତାଲନେ । ");
INSERT INTO juy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଆମନ୍‌ ଅସିଂନମ୍‌ ଆ ମନ୍‌ରାଜି ଡ ଡେସାଡମ୍‌ନମ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଜିରାୟ୍‌ ଆରି ଞେନ୍‌ ଆମନ୍‌ ଅଙ୍ଗା ଡେସା ଅବ୍‌ତୁୟ୍‌ତମ୍‌ ତି ଆ ଡେସା ଜିରା ।’ ");
INSERT INTO juy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ସିଲତ୍ତେ ଆନିନ୍‌ କଲ୍‌ଦିଅଞ୍ଜି ଆ ଡେସା ସିଲଡ୍‌ ଜିର୍ରେ ଆରଣ ଡେସାନ୍‌ ଇୟ୍‌ଲେ ଡକୋନେ । ଆରି ଆ ବାପାନ୍‌ ଆର୍ରବୁଏନ୍‌ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ନମି ଆଙ୍ଗା ଡେସାଲୋଙ୍‌ ଏଡକୋତନ୍‌ ତି ଆ ଡେସା ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଓରୋଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ଆରି ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତେତ୍ତେ ଇନ୍ନିଙ୍‌ଜା ଅଃତ୍ତିୟ୍‌ଲୋ, ବତାଲ୍‌ଜଙ୍‌ ଆଜଙ୍‌ଜଙ୍‌ ଆ ଲବ ନିୟ୍‌ ଅଃତ୍ତିୟ୍‌ଲୋ, ବନ୍‌ଡ ଆନିନ୍‌ଆଡଙ୍‌ ଇସ୍ୱରନ୍‌ ବାସାଏନ୍‌ । ଅବ୍ରାମନ୍‌ଆଡଙ୍‌ ଅଙ୍ଗା ଡେସା ତିୟ୍‌ତାୟ୍‌ ତିଆତେ ଆନିନ୍‌ ଡ ଆ କେଜ୍ଜାମରଞ୍ଜିଆତେ ଡେତେ । ଇସ୍ୱରନ୍‌ ତିଆତେ ଆବ୍ରାସାଲନ୍‌ ଆଡିଡ୍‌ ଅବ୍ରାମନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ କୋଡନେ । ");
INSERT INTO juy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ଇସ୍ୱରନ୍‌ ଏନ୍ନେଲେ ବର୍ରନେ, ‘ଆ କେଜ୍ଜାମରଞ୍ଜି ବଡେସାନ୍‌ ଜିର୍ରେ ଇୟ୍‌ତେ ଡକୋନେଜି ଆରି ତି ଆ ଡେସା ଆ ମନ୍‌ରାଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଉଞ୍ଜିସଅ ବର୍ସେଙ୍‌ ଜାୟ୍‌ କମ୍ୱାରିନ୍‌ ଡକ୍କୋଡାଲେ ଡଣ୍ଡାୟ୍‌ତାଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରାଜି ଆନିଞ୍ଜିଆଡଙ୍‌ କମ୍ବାରିନ୍‌ ଡକ୍କୋତାଜି ଞେନ୍‌ ତି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ବିସାରତାଜି, ଆନିଞ୍ଜି ତି ଆ ଡେସା ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ତେନ୍ନେ ଞେନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ପୁରିଁୟ୍‌ଜି ।’ ");
INSERT INTO juy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ଆରି ଇସ୍ୱରନ୍‌ ଅବ୍ରାମନ୍‌ଆଡଙ୍‌ ଗନବ୍‌ରେଡ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲନୁମନ୍‌ ଆସନ୍‌ ବରେନ୍‌; ତି ଆ ବର୍ନେ ଅନ୍ତମ୍‌ ଅବ୍ରାମନ୍‌ ଇସାକନ୍‌ ଆକ୍ରୋଡେନ୍‌ ସିଲଡ୍‌ ଆଟ ଡିନ୍ନାଲୋଙ୍‌ ଗବ୍‌ରେଡେନ୍‌; ଇସାକନ୍‌ ଜାକୁବନ୍‌ଆଡଙ୍‌ ଗବ୍‌ରେଡେନ୍‌ ଆରି ଜାକୁବନ୍‌ ଆଅନଞ୍ଜି ବାରଜଣଞ୍ଜିଆଡଙ୍‌ ଗବ୍‌ରେଡେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ଆ ବୋଞାଙ୍‌ଡମଞ୍ଜି ଜୋସେପନ୍‌ଆଡଙ୍‌ ସଙ୍ଗତ୍ତାଡାଲେ ମିସର୍‌ ଡେସାବାଜି ଆମଙ୍‌ କମ୍ୱାରିନ୍‌ ତମେଞ୍ଜି । ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ ବୟନ୍‌ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ଆରି ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଡ଼୍‌କୋ ଡଣ୍ଡନ୍‌ ସିଲଡ୍‌ ଡୋବେନ୍‌, ଆନିନ୍‌ ମିସର୍‌ ଡେସାନ୍‌ ଆ ରାଜା ପାରୋନ୍‍ ଆ ମୁକ୍କାଗଡ୍‌ ଆତ୍ରନଙେନ୍‌ ଆଡିଡ୍‌, ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସନାୟୁମନ୍‌ ଡ ବୁଡ୍ଡିନ୍‌ ତିୟେନ୍‌, ଆରି ପାରୋନ୍‍ ଆନିନ୍‌ଆଡଙ୍‌ ମିସର୍‌ ଡେସା ରାଜାସିଙନ୍‌ ଆ ସୋଡ଼ାମର୍‌ ଅମ୍ମେଲେ ତବ୍‌ନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ତିକ୍କି ସମ୍ପରା ମିସର୍‌ ଡେସାନ୍‌ ଡ କିନାନ୍‌ ଡେସାଲୋଙନ୍‌ କାନ୍ତାରାନ୍‌ ଅଡ଼ୋଲାୟ୍‌ ଆରି ମନ୍‌ରାଞ୍ଜି ମାଡ୍ଡ ଡଣ୍ଡ ଡେଏଞ୍ଜି । ତିଆଡିଡ୍‌ ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଜନୋମନ୍‌ ଅଃଞାଙ୍‌ଲଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ମିସର୍‌ ଡେସାଲୋଙନ୍‌ ଜନ୍‌ରୋମନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ଜାକୁବନ୍‌ ଆରମ୍‌ଡଙେନ୍‌, ତେତ୍ତେ ଅନିୟନ୍‌ ଆସନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ଆରି ଆନିଞ୍ଜି ବାଗୁତର ଇଙନ୍‌ ତେତ୍ତେ ଜନ୍‌ରୋମ୍‌ବାନ୍‌ ଆରିୟେଞ୍ଜି ଆଡିଡ୍‌ ଜୋସେପନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ସେକୁଲ୍‌ଲନେ, ଆରି ମିସର୍‌ ଡେସାନ୍‌ ଆ ରାଜା ପାରୋନ୍‍ ନିୟ୍‌ ଜୋସେପନ୍‌ ଆସିଂମର୍‌ଜି ଗାମ୍‌ଲେ ଜନାଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜୋସେପନ୍‌ ଆ ବାପା, ଜାକୁବନ୍‌ ଡ ଆ କୁତ୍ତମ୍ମାଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ୟାକୁଡ଼ି ପନ୍ଦରଜଣଞ୍ଜି ମିସର୍‌ ଡେସାନ୍‌ ଜିରାୟ୍‌ବା ଗାମ୍‌ଲେ ଓଡ୍ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ଜାକୁବନ୍‌ ମିସର୍‌ ଡେସାନ୍‌ ଜିରେନ୍‌ ତେତ୍ତେ ଆନିନ୍‌ ଆରି ଆ ଅନଞ୍ଜି ଇୟ୍‌ଲେ ରବୁଏଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ଆମରାଞ୍ଜି ସିକିମ୍‌ ଡେସାନ୍‌ ପନାଙନ୍‌ ଡେଏନ୍‌, ତେତ୍ତେ ତରିଲ୍‌ନେନ୍‌ ଆସନ୍‌ ଆମୋରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଅବ୍ରାମନ୍‌ ରୁପାଡାବନ୍‌ ତିୟ୍‌ଲେ ତରିଲ୍‌ନେନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ମସାନ୍ନି ବସେଙନ୍‌ ଞିଏନ୍‌, ତେତ୍ତେ ଇୟ୍‌ଲେ ତିଲେଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ଆଙ୍ଗାଆତେ ଇସ୍ୱରନ୍‌ ଅବ୍ରାମନ୍‌ ଆମଙ୍‌ ବାସାଲନେ, ତି ଆ ବର୍ନେ ତୁୟାୟ୍‌ଲେ ଆପ୍ରାଙ୍‌ଲାଞନ୍‌ ମନ୍‌ରାଲେଞ୍ଜି ମିସର୍‌ ଡେସାଲୋଙନ୍‌ ଗୋଗୋୟ୍‌ଲେ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ଆତନିକ୍କି ମିସର୍‌ ଡେସାଲୋଙନ୍‌ ଆରି ଅବୟ୍‌ନେ ରାଜାଲନେ, ଆନିନ୍‌ ଜୋସେପନ୍‌ଆଡଙ୍‌ ଜନା ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ଆନିନ୍‌ ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜିଆଡଙ୍‌ ଅରିର୍ସୋୟମ୍‌ଡାନ୍‌ ଏମ୍ମେଏଞ୍ଜି, ଆରି ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆ ରେସାସିୟ୍‌ଜିଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଡୁଆରାନ୍‌ ଅମ୍‌ରେଙ୍‌ବା ଗାମ୍‌ଲେ ମନ୍‌ରାଞ୍ଜି ବାଞେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ତି ଆ ବନେଡ଼ା ମୋସାନ୍‌ ଜନମ୍ମୁ ଡେଏନ୍‌, ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ ମାଡ୍ଡ ମନଙ୍‌ ଡକୋଏନ୍‌ ଆରି ୟାଗି ଆଙ୍ଗାୟ୍‌ ଜାୟ୍‌ ଆନିନ୍‌ ଆପେୟନ୍‌ ଡ ଆୟୋଙନ୍‌ ଅସିଙନ୍‌ ଡକ୍କୋଡାଲେ ବନେଞ୍ଜି ଲୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ଆନିନ୍‌ ଡୁଆରାନ୍‌ ଆରମ୍‌ରେଙେଞ୍ଜି ସିଲଡ୍‌ ପାରୋନ୍‍ ଆ ଡାଙ୍ଗଡ଼ିଅନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ପାଙେନ୍‌ ଆରି ଆଅନ୍‌ଡମନ୍‌ ଅନ୍ତମ୍‌ ଇୟ୍‌ଲେ ବନେ । ");
INSERT INTO juy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ମୋସାନ୍‌ ମିସର୍‌ମରଞ୍ଜି ଆ ଞନଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଞଙ୍‌ଲନେ ଆରି ବର୍ନେଲୋଙନ୍‌ ଡ କାବ୍ବାଡ଼ାଲୋଙନ୍‌ ଆନିନ୍‌ ବୋର୍ସାଡମ୍‌ ଡେଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ଆଙ୍ଗା ଆନିନ୍‌ ବାକୁଡ଼ି ବର୍ସେଙ୍‌ ଡେଏନ୍‌, ତିଆଡିଡ୍‌ ଆ ବୋଞାଙଞ୍ଜି ଡ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ବୁଲ୍ଲେଜାଙନ୍‌ ଅନିୟନ୍‌ ସାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ତିଆଡିଡ୍‌ ଅବୟ୍‌ ମିସର୍‌ମରନ୍‌ ଅବୟ୍‌ ଇସ୍ରାଏଲ୍‌ମରନ୍‌ଆଡଙ୍‌ ଅରିର୍ସୋୟମ୍‌ଡାନ୍‌ ଆରେମ୍ମେଏନ୍‌ଆତେ ଗିୟ୍‌ଲେ, ମୋସାନ୍‌ ତି ଇସ୍ରାଏଲ୍‌ମରନ୍‌ଆଡଙ୍‌ ଡନେଡାଲେ ତି ମିସର୍‌ମରନ୍‌ଆଡଙ୍‌ ରବ୍ବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ଆନିନ୍‌ ଅମ୍ମେଲେ ଇସ୍ୱରନ୍‌ ଆ ବୋଞାଙଞ୍ଜିଆଡଙ୍‌ ଡୋବ୍‌ତଜି, ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଜନାତଜି ଗାମ୍‌ଲେ ମୋସାନ୍‌ ଅବ୍‌ଡିସୟେନ୍‌, ବନ୍‌ଡ ଆନିଞ୍ଜି ଅଃଜ୍ଜନାଲଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ତି ଆବାର୍ତାନ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆରଲ୍‌ତିଡେଞ୍ଜି ଆଡିଡ୍‌ ମୋସାନ୍‌ ଇୟ୍‌ଲେ ରବାଙେଜି କି ଆନିଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ମାୟ୍‌ମାୟନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି, ‘ଏ ମନ୍‌ରାଜି ଆମ୍ୱେଞ୍ଜି ବନୋଞାଙ୍‌ ଡେତବେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଇନିବା ତର୍ଡମ୍‌ ଏଗୋଡ଼େତନ୍‌ କି ଏଲ୍‌ତିଡ୍‌ତେ ?’ ");
INSERT INTO juy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ବନ୍‌ଡ ଅଙ୍ଗା ମନ୍‌ରା ଆରି ଅବୟ୍‌ନେଆଡଙ୍‌ ଅରିର୍ସୋୟମ୍‌ଡାନ୍‌ ଏମ୍ମେଏନ୍‌, ଆନିନ୍‌ ମୋସାନ୍‌ଆଡଙ୍‌ ରୁମ୍ପେଲ୍‌ଡାଲେ ବରେନ୍‌; ‘ଆନା ଆମନ୍‌ ଉପରେଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ଆସନ୍‌ ଡ ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ତବ୍‌ନଙ୍‌ଲମ୍‌ ? ");
INSERT INTO juy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ରୁବନ୍‌ ଏଙ୍ଗାଲେ ତି ମିସର୍‌ମରନ୍‌ଆଡଙ୍‌ ସମ୍ୱବେନ୍‌, ଏତ୍ତେଲେ ମା ଞେନ୍‌ଆଡଙ୍‌ ସନମ୍ୱବନ୍‌ ସାୟ୍‌ତେ ପଙ୍‌ ?’ ");
INSERT INTO juy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ମୋସାନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ଆରମ୍‌ଡଙେନ୍‌, ଆନିନ୍‌ ମିସର୍‌ ଡେସାନ୍‌ ଅମ୍‌ରେଙ୍‌ଲେ ମିଦିଅନ୍‌ ଡେସାନ୍‌ ଜିର୍ରେ ତେତ୍ତେ ଇୟ୍‌ଲେ ଡକୋନେ । ତେତ୍ତେ ବାଗୁ ଆ ଡାଙ୍ଗଡ଼ାଅନଞ୍ଜି ଜନମ୍ମୁ ଡେଏଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“ବାକୁଡ଼ି ବର୍ସେଙ୍‌ ଆ ତିକ୍କି ସିନୟ ବରୁନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଅବୟ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଅବୟ୍‌ ଆଡୁଡୁ ଜାଡ଼ିଆଲୋଙନ୍‌ ମୋସାନ୍‌ ଆମଙ୍‌ ଅବ୍‌ରାଙ୍‌ଡାଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମୋସାନ୍‌ ତିଆତେ ଗିୟ୍‌ଲେ ସାନ୍ନି ଡେଏନ୍‌, ଆରି ମନଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଜାଡ଼ିଆନ୍‌ ଆ ତୁୟାୟ୍‌ ଆରିୟେନ୍‌ ଆଡିଡ୍‌, କେନ୍‌ ଏନ୍ନେଲେ ପ୍ରବୁନ୍‌ ଆ ସର୍ରଙ୍‌ ଅଡ଼ୋଲାୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ଞେନ୍‌ ପୁର୍ବା ଜୋଜୋନମ୍‌ ଆ ଇସ୍ୱର, ଅବ୍ରାମନ୍‌, ଇସାକନ୍‌ ଡ ଜାକୁବନ୍‌ ଆ ଇସ୍ୱର ।’ ସିଲତ୍ତେ ମୋସାନ୍‌ ବନ୍ତଙ୍‌ ମାଡ୍ଡ ମନଙ୍‌ ଗିୟ୍‌ଗିଜନ୍‌ ଆସନ୍‌ ଅଃନ୍ନୋମଙ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ତି ସିଲଡ୍‌ ପ୍ରବୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ତାଲ୍‌ଜଙ୍‌ଲୋଙ୍‌ନମ୍‌ ଆ ପାଣ୍ଡୋୟ୍‌ ତବ୍‌ନା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗାଲୋଙ୍‌ ଆମନ୍‌ ଆତନଙ୍‌ ତି ତେତ୍ତେ ମଡ଼ିର୍‌ଡମ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ମନ୍‌ରାଞେଞ୍ଜି ମିସର୍‌ ଡେସାଲୋଙନ୍‌ ଡକୋଜି, ଞେନ୍‌ ଆ କାକୁର୍ତିଞ୍ଜି ଗିୟ୍‌ଲାୟ୍‌ ଆରି ଆ ୟନେଞ୍ଜି ଅମ୍‌ଡଙ୍‌ଲାୟ୍‌, ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ତବ୍‌ଲେ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ପଡ୍‌ଲନ୍‌ ଜିର୍ରାୟ୍‌, ଆରି ୟାଆ, ନମିଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ମିସର୍‌ ଡେସାନ୍‌ ଆପ୍ପାୟ୍‌ତମ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ଆନା ଆମନ୍‌ ଉପରେଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ଅବ୍‌ସୋଡ଼ାନେନ୍‌ ଆସନ୍‌ ଡ ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ତବ୍‌ନଙ୍‌ଲମ୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ମୋସାନ୍‌ଆଡଙ୍‌ ବାସ୍ସେଏଞ୍ଜି, ଇସ୍ୱରନ୍‌ ଜାଡ଼ିଆଲୋଙନ୍‌ ମୋସାନ୍‌ ଆମଙ୍‌ ଅବ୍‌ରାଙ୍‌ଡାଲନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଅମ୍ମେଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସୋଡ଼ାମର୍‌ ଆରି ପନ୍‌ସୁଆତିମର୍‌ ଅମ୍ମେଲେ ଆପ୍ପାୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","କେନ୍‌ ଆ ମନ୍‌ରା ମିସର୍‌ ଡେସାଲୋଙନ୍‌, ସୁପ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଡ ବାକୁଡ଼ି ବର୍ସେଙ୍‌ ଜାୟ୍‌ ଅରମ୍ମଡଞ୍ଜି ଡ ସାନ୍ନି କାବ୍ବାଡ଼ାଞ୍ଜି ଲୁମ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ଓରୋଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ମୋସାନ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, ‘ଇସ୍ୱରନ୍‌ ବୋଞାଙ୍‌ବେଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ଞେନ୍‌ ଅନ୍ତମ୍‌ ଅବୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ତବ୍‌ନଙ୍‌ତେ ।’ ");
INSERT INTO juy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","କେନ୍‌ ଆ ମନ୍‌ରା ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲନ୍‌ । ଆନିନ୍‌ ସିନୟ ବରୁଲୋଙନ୍‌ ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଡ ଆନିନ୍‌ ସରିନ୍‌ ଆକ୍ରଡାଡ଼ିଲନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲନ୍‌; ଆରି ଆନିନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ଜନାନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅନମେଙ୍‌ବରଞ୍ଜି ଞାଙେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“ବନ୍‌ଡ ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ମୋସାନ୍‌ ଆ ବର୍ନେ ଅନ୍ତମ୍‌ ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଆସନ୍‌ ଆଃଲ୍ଲଡୟ୍‌ଲଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବାସ୍ସେଏଞ୍ଜି, ଆରି ଆନିଞ୍ଜି ମିସର୍‌ ଡେସାନ୍‌ ୟର୍ନେନ୍‌ ସାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ଆନିଞ୍ଜି ଆରୋଣନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, ‘ମୁକ୍କାବାଲେନ୍‌ ଆମ୍ମୁଙ୍‌ଡାଲନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ତଙରନ୍‌ ଅନବ୍‌ତୁଜନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ତୁବ୍‌ଲେ ତିୟ୍‌ଲେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଙ୍ଗା ମୋସା ମିସର୍‌ ଡେସାନ୍‌ ସିଲଡ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ଓରୋଙ୍‌ଲଲେନ୍‌ ଆନିନ୍‌ ଇନି ଡେଏନ୍‌, ଇନ୍‌ଲେଞ୍ଜି ଜନା ତଡ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ସିଲତ୍ତେ ଆନିଞ୍ଜି ଅବୟ୍‌ ଡାମ୍ୱୁଡ଼ିନ୍‌ ଆ କୋଙ୍‌ଡାୟ୍‌ ତୁବେଞ୍ଜି କି ତିଆତେ ଆସନ୍‌ ଅନମଙନ୍‌ ତିୟେଞ୍ଜି । ଆରି ଆନିଞ୍ଜି ଆତ୍ରୁବେଞ୍ଜି ଆ କୋଙ୍‌ଡାୟ୍‌ ଆସନ୍‌ ସର୍ଡାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ରୁଆଙନ୍‌ ଡ ତୁତୁଜଞ୍ଜି ପୁର୍‌ପୁରନ୍‌ ଆସନ୍‌ ସୋରୋପ୍ପାୟେଞ୍ଜି, କେନ୍‌ ଆ ବର୍ନେ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆ ସାସ୍ତ୍ରଲୋଙ୍‌ ଆଇଡିଡ୍‌, ‘ଏ ଇସ୍ରାଏଲ୍‌ମର୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ବାକୁଡ଼ି ବର୍ସେଙ୍‌ ଜାୟ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଞେନ୍‌ ଆସନ୍‌ ଜନ୍ତୁଞ୍ଜି ଏଃର୍ରବ୍ବୁଲୋ ଆରି ଅନମଙନ୍‌ ଏଃତ୍ତିୟ୍‌ଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ପୁର୍‌ପୁରନ୍‌ ଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି କୋଙ୍‌ଡାଜଞ୍ଜି ଏତୁବେନ୍‌, ମୋଲକନ୍‌ ଆଡ୍ରକୋନେ ଡ ତୁତୁୟ୍‌ ଇସ୍ୱରବେନ୍‌ ରେମ୍ପାନ୍‌ ଆ କୋଙ୍‌ଡାୟ୍‌ ଏବୋୟେନ୍‌ । ତିଆସନ୍‌ ଞେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବଣ୍ଡିଡାଲେ ବାବିଲୋନ୍‌ ଡେସାନ୍‌ ଆ ଅଡିଗଡ୍‌ ଆପ୍ପାୟ୍‌ତବେନ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“ଆମନ୍‌ ଏଙ୍ଗାଲେ ଅରବ୍‌ଜଙନ୍‌ ଗିଜେନ୍‌, ତି ଏତ୍ତେଗନ୍‌ ଅବୟ୍‌ ସାକି ତମ୍ୱୁନ୍‌ ତୁବା ଗାମ୍‌ଲେ ଇସ୍ୱରନ୍‌ ମୋସାନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ତି ଆ ବର୍ନେ ଅନ୍ତମ୍‌ ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ସାକି ତମ୍ୱୁନ୍‌ ଞାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆ ପୁର୍ବା ଜୋଜୋଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଆଞ୍ରାଙେଞ୍ଜି ଆ ତମ୍ୱୁ ଜିଓସୟନ୍‌ ବୟନ୍‌ ବୋୟ୍‌ଲେ ଆମ୍ମୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ପାଙେଞ୍ଜି, ତିଆତେ ଦାଉଦନ୍‌ ଆବନେଡ଼ା ଜାୟ୍‌ ଆମଙଞ୍ଜି ଡକୋଏନ୍‌; ଆରି ଇସ୍ୱରନ୍‌ ଅଙ୍ଗା ଡେସା ଆ ମନ୍‌ରାଜି ଗଙ୍‌ତିଡେଞ୍ଜି, ଆନିଞ୍ଜି ତେତ୍ତେ ଜିର୍ରେ ଇୟ୍‌ଲେ ଡକୋନେଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ଦାଉଦନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ ସନାୟୁମନ୍‌ ଞାଙେନ୍‌ କି ଆନିନ୍‌ ଜାକୁବନ୍‌ ଆ ଇସ୍ୱର ଆସନ୍‌ ଅବୟ୍‌ ଡରକୋନେସିଙନ୍‌ ଗୁତାୟ୍‌ ଗାମ୍‌ଲେ ପାର୍ତନାଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ବନ୍‌ଡ ସୋଲମନନ୍‌ ଇସ୍ୱରନ୍‌ ଆସନ୍‌ ଅବୟ୍‌ ଅସିଙନ୍‌ ଗୁଏନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ସିଲଡ୍‌ ସୋଡ଼ା ଇସ୍ୱରନ୍‌, ମନ୍‌ରାନ୍‌ ଆଗ୍ରୁତେନ୍‌ ଆ ସରେବାସିଂଲୋଙ୍‌ ଅଃଡ୍ଡକୋନେ; କେନ୍‌ ଆ ବର୍ନେ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ବର୍ରନେ; ");
INSERT INTO juy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘ପ୍ରବୁନ୍‌ ଗାମ୍‌ତେ, ରୁଆଙନ୍‌ ତରଙ୍କୁମ୍‌ନେଞେନ୍‌, ପୁର୍ତିନ୍‌ ଡରକ୍କୋଜଙ୍‌ଞେନ୍‌ । ଆମ୍ୱେଞ୍ଜି ଞେନ୍‌ ଆସନ୍‌ ଏଙ୍ଗାଗୋ ଆସିଂ ଏଗୁତେ ? ଅଡ଼େ ଲରୋଲୋନେସିଂଞେନ୍‌ ଅଡ଼େଙ୍ଗା ? ");
INSERT INTO juy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","କେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଅସିଞେନ୍‌ ବାତ୍ତେ ଞେନ୍‌ ଅଃଗବ୍‌ଡେଲାୟ୍‌ ପଙ୍‌ ?’” ");
INSERT INTO juy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“ଆମ୍ୱେଞ୍ଜି ଡିଅଙ୍ଗା ଆ ପେଲ୍ଲାମର୍‌ଜି ! ଉଗର୍‌ବେନ୍‌ ଡିଅଙ୍ଗା ଆ ରଡୋ ! ଅଲୁଡ୍‌ବେନ୍‌ ଡିଅଙ୍ଗା ଆ କବୁଙ୍‌ ! ଆମ୍ୱେଞ୍ଜି ଆଏଡ଼ର୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଏସଙ୍ଗତ୍ତାତେ; ପୁର୍ବା ଜୋଜୋବେଞ୍ଜି ଏଙ୍ଗାଗୋ ଆମ୍ୱେଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଗୋଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ପୁର୍ବା ଜୋଜୋବେଞ୍ଜି ଅଡ଼୍‌କୋ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜିଆଡଙ୍‌ ଡଣ୍ଡାୟେଞ୍ଜି; ତି ଡରମ୍ମମରନ୍‌ ଆଜିର୍ତାଞନ୍‌ ଆ ବର୍ନେ ଆନାଜି ଇୟ୍‌ଲାୟ୍‌ ଅପ୍ପୁଙ୍‌ବରେଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ପୁର୍ବା ଜୋଜୋବେଞ୍ଜି ରବ୍ବୁଏଞ୍ଜି; ଆରି ନମି ଆମ୍ୱେଞ୍ଜି ବାଁୟ୍‌ସିଡାଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଏରବ୍ବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ଆମ୍ୱେଞ୍ଜି ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଏଞାଙେନ୍‌, ବନ୍‌ଡ ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଏଃମ୍ମାନ୍ନେଲୋ ।” ");
INSERT INTO juy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ତିପାନନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଆ ବର୍ନେଜି ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନିଞ୍ଜି ଆକ୍ରାନ୍‌ ବରାବେଞ୍ଜି, ଆରି ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ରମ୍‌ରମ୍‌ଜିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ବନ୍‌ଡ ଆନିନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ବରିୟ୍‌ ଡେଏନ୍‌ କି ରୁଆଙନ୍‌ ଆଙାଙ୍‌ଲେ ସେଡେନ୍‌, ଆରି ଇସ୍ୱରନ୍‌ ଆ ଗନୁଗୁ ପନେମେଙ୍‌ ଡ ଇସ୍ୱରନ୍‌ ଆର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଜିସୁନ୍‌ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲନ୍‌ ଗିଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ଆନିନ୍‌ ବର୍ରନେ, “ଗିୟ୍‌ବା, ରୁଆଙନ୍‌ ଆରୋରୋ ଆରି ମନ୍‌ରା ଡାଙ୍ଗଡ଼ାଅନନ୍‌ ଇସ୍ୱରନ୍‌ ଆର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ତନଙ୍‌ଲେ ଆଡ୍ରକୋତନ୍‌ ଞେନ୍‌ ଗିୟ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ବନ୍‌ଡ ଆନିଞ୍ଜି ଆକ୍ରାନ୍‌ ବାବ୍ବାବେଞ୍ଜି କି ଡୁବ୍‌ଡୁବ୍‌ଲୁଡ୍‌ଲଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ରୁମୁକ୍କେଲନ୍‌ ତିପାନନ୍‌ ଆମଙ୍‌ ଜିର୍ରାଜି, ");
INSERT INTO juy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ଆରି ଆନିଞ୍ଜି ତିପାନନ୍‌ଆଡଙ୍‌ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ଅରେଙନ୍‌ ବାତ୍ତେ ତିଡ୍‌ଲେ ତିଡ୍‌ଲେ ରବ୍ବୁଏଞ୍ଜି । ଆରି ସାକିମରଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ସିନ୍‌ରିଜି ସାଓଲ ଗାମ୍‌ଲେ ଅବୟ୍‌ ବେଣ୍ଡିଆମରନ୍‌ ଆମଙ୍‌ ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ଆନିଞ୍ଜି ତିପାନନ୍‌ଆଡଙ୍‌ ଅରେଙନ୍‌ ବାତ୍ତେ ଆତ୍ରିଡେଞ୍ଜି ଆଡିଡ୍‌ ଆନିନ୍‌ ପାର୍ତନାଲନ୍‌ ଗାମେନ୍‌, “ଏ ପ୍ରବୁ ଜିସୁ ପୁରାଡ଼ାଞେନ୍‌ ପାଙା ।” ");
INSERT INTO juy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ଆରି, ଆନିନ୍‌ ତୁଡ଼ୁମ୍‌ଡାଲେ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ଓଡ୍ଡେଲେ ବର୍ରନେ, “ଏ ପ୍ରବୁ, କେନ୍‌ ଆ ଇର୍ସେଞ୍ଜି ଆମନ୍‌ ଡିଡିଡଙ୍‌ ।” କେନ୍‌ଆତେ ବର୍ରନ୍‌ କି ଆନିନ୍‌ ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ତିଆଡିଡ୍‌ ଜିରୁସାଲମରେଙନ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଆ ମଣ୍ଡଡ଼ି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଜବ୍ର ଡଣ୍ଡାୟେଞ୍ଜି; ତିଆସନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଅମ୍‌ରେଙ୍‌ଡାଲେ ଅଡ଼୍‌କୋ ଡର୍ନେମରଞ୍ଜି ଜିଉଦା ଡେସାନ୍‌ ଡ ସମିରୋଣରେଙନ୍‌ ପିରିଙ୍‌ପାଡାନ୍‌ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ବୟ୍‌ଲେମରଞ୍ଜି ତିପାନନ୍‌ ତିଲେଞ୍ଜି ଆରି ଆନିନ୍‌ ଆସନ୍‌ ମାଡ୍ଡ ୟେୟେଡାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ବନ୍‌ଡ ସାଓଲନ୍‌ ଅସିଂ ଅସିଂ ଗନ୍‌ଲେ, ଓବ୍ବାମରଞ୍ଜି ଡ ଆଇମରଞ୍ଜି, ଡିଙ୍‌ଲେ ଓରୋଙ୍‌ଡାଲେ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଇୟ୍‌ଲେ ସୋରୋପ୍ପାୟ୍‌ଡାଲେ ମଣ୍ଡଡ଼ିଞ୍ଜି ବିର୍ସେଙ୍‌ବେଗଡ଼ାୟ ଏମ୍ମେଆଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ସିଲତ୍ତେ ଅଙ୍ଗା ମନ୍‌ରାଜି ପିରିଙ୍‌ପାଡାନ୍‌ ଡେଏଞ୍ଜି, ଆନିଞ୍ଜି ସମ୍ପରାନ୍‌ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ମନଙ୍‌ବରନ୍‌ ବର୍ରନ୍‌ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ଆରି ପିଲିପନ୍‌ ସମିରୋଣନ୍‌ ଆ ସୋଡ଼ା ଗଡ଼ାନ୍‌ ଜିର୍ରେ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ କ୍ରିସ୍ଟନ୍‌ ଆ ବର୍ନେ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ମନ୍‌ରାଞ୍ଜି ପିଲିପନ୍‌ ଆ ବର୍ନେ ଅମ୍‌ଡଙେଞ୍ଜି ଆରି ଆନିନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ ସାନ୍ନି କାବ୍ବାଡ଼ାଜି ଗିୟ୍‌ଲେ ଆବମନ୍ନନ୍‌ ବାତ୍ତେ ଆ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ସିଲଡ୍‌ ପୁରାଡ଼ାଞ୍ଜି ସଜିର୍‌ଡାଲେ ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆରି କାନ୍ନିମରଞ୍ଜି ଡ ସୋତ୍ତାମରଞ୍ଜି ଗୋଗୋୟ୍‌ନେଡମ୍‌ ମନଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ସିଲତ୍ତେ ତି ଆ ଗଡ଼ା ଆ ମନ୍‌ରାଜି ମାଡ୍ଡ ସର୍ଡାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ବନ୍‌ଡ ସିମନ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ତି ଆ ଗଡ଼ାଲୋଙ୍‌ ତନେୟ୍‌ଡାଲନ୍‌ ଆନିନ୍‌ଡମ୍‌ ଅବୟ୍‌ ସୋଡ଼ାମର୍‌ ଗାମ୍‌ଡମ୍‌ଲନ୍‌ ସମିରୋଣମରଞ୍ଜିଆଡଙ୍‌ ବବ୍‌ତଙାଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ଇସ୍ୱରନ୍‌ ଆ ବୋର୍ସା ଅଙ୍ଗାଆତେ ସୋଡ଼ା ଗାମ୍‌ତବୋ ତି ଆ ବୋର୍ସା କେନ୍‌ ମନ୍‌ରା ଆମଙ୍‌ ଡକୋ ଗାମ୍‌ଲେ ସନ୍ନା ସୋଡ଼ା ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ମାନ୍ନେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ଆନିନ୍‌ ତନେଜନ୍‌ ବାତ୍ତେ ଜବ୍ର ବର୍ସେଙ୍‌ ଡେଲୋ ସମିରୋଣମରଞ୍ଜିଆଡଙ୍‌ ବବ୍‌ତଙାଜେଞ୍ଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ସିମନନ୍‌ଆଡଙ୍‌ ମାନ୍ନେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ବନ୍‌ଡ ପିଲିପନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟ ଡ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଆରପ୍ପୁଙ୍‌ବରେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ତେତ୍ତେ ଆ ମନ୍‌ରାଜି ପିଲିପନ୍‌ ଆ ବର୍ନେଲୋଙ୍‌ ଡର୍ରଞ୍ଜି, ଆରି ଓବ୍ବାମର୍‌ ଆଇମର୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ତବ୍ବୁବ୍‌ଡାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ଆରି ସିମନନ୍‌ ନିୟ୍‌ ଡର୍ରନ୍‌ କି ତବ୍ବୁବ୍‌ଡାଲନ୍‌ ଆରି ପିଲିପନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲନ୍‌, ଆରି ଏର୍ଜାଡ଼ିକାନ୍‌ ଅରମ୍ମଡଞ୍ଜି ଡ ସୋଡ଼ା ସୋଡ଼ା ସାନ୍ନି କାବ୍ବାଡ଼ାଞ୍ଜି ଗିୟ୍‌ଲେ ଆନିନ୍‌ ସାନ୍ନି ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ସମିରୋଣବାଜି ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଜାଏଞ୍ଜି ଗାମ୍‌ଲେ ଜିରୁସାଲମନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଆନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମର୍‌ଜି ଆରମ୍‌ଡଙେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନିଞ୍ଜି ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ଆଡଙ୍‌ ଆମଙଞ୍ଜି ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ଆନିଞ୍ଜି ତେତ୍ତେ ଇୟେଞ୍ଜି କି, ଡର୍ନେମରଞ୍ଜି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଞାଙେତଜି ଗାମ୍‌ଲେ, ଆନିଞ୍ଜି ଆସନ୍‌ ଇୟ୍‌ଲେ ପାର୍ତନାନେଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଜିରାୟ୍‌; ଆନିଞ୍ଜି ଜିସୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ସତ୍ତର୍‌ ତବ୍ବୁବ୍‌ଡାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆବବ୍‌ଲୋଙ୍‌ ଆସିଞ୍ଜି ଆଡ୍ରକ୍କୋଏଞ୍ଜି, ଆନିଞ୍ଜି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଞାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ମନ୍‌ରାଞ୍ଜି ଆବବ୍‌ଲୋଙ୍‌ ଆସିଞ୍ଜି ଆଡ୍ରକ୍କୋଏଞ୍ଜି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆଜିର୍ରାଞନ୍‌ଆତେ ଗିୟ୍‌ଲେ, ତନେୟ୍‌ ସିମନନ୍‌ ପିତ୍ରନ୍‌ ଡ ଜନନ୍‌ଆଡଙ୍‌ ତଙ୍କାନ୍‌ ଜାସ୍ସେଲେ ବରେଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ଞେନ୍‌ ଜାୟ୍‌ ତି ଆ ବୋର୍ସା ତିୟିଁୟ୍‌ବା, ଆରି ଞେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଆବବ୍‌ଲୋଙ୍‌ ଅସିଞେନ୍‌ ଡକ୍କୋତାୟ୍‌ ଆନିନ୍‌ ନିୟ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଞାଙେତୋ ।” ");
INSERT INTO juy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଜାଲଙେନ୍‌, “ତଙ୍କାନମ୍‌ ଆମନ୍‌ ଅମ୍ପରା ରସମେତୋ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆମନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ତନିୟ୍‌ତିୟ୍‌ ତଙ୍କାନ୍‌ ବାତ୍ତେ ଞିଞିନ୍‌ ସାୟ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ଆମନ୍‌ କାବ୍ବାଡ଼ାଲୋଙ୍‌ଲେନ୍‌ ଇନ୍ନିଙ୍‌ ମରାୟ୍‌ନେ ତଡ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙ୍‌ ଉଗର୍‌ନମ୍‌ ମନଙ୍‌ ତଡ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ତିଆସନ୍‌, କେନ୍‌ ଇର୍ସେନମ୍‌ ସିଲଡ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ପାର୍ତନାନା, ଅସମୟ୍‌ ଉଗର୍‌ଲୋଙ୍‌ନମ୍‌ ଆନିଃୟମ୍‌ଜି ଆସନ୍‌ ଆମନ୍‌ କେମାନ୍‌ ଞାଙ୍‌ତେ ଜାଆରୋ । ");
INSERT INTO juy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଗିୟ୍‌ତମ୍‌, ଆମନ୍‌ ଉଗର୍‌ଲୋଙ୍‌ନମ୍‌ ଅସାଙଞ୍ଜି ଆବରିୟ୍‌ ଡକୋ, ଆରି ଇର୍ସେନ୍‌ ବାତ୍ତେ ଆମନ୍‌ ଆଜିବାଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ସିଲତ୍ତେ ସିମନନ୍‌ ଜନନ୍‌ ଡ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଜାଲଙ୍‌ଲେ ବର୍ରନେ, “ଆମ୍ୱେଞ୍ଜି ଇନିଜି ଇନିଜି ଏବର୍ରନେ ତିଆତେଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଅଡ଼ୋଡଙାୟ୍‌ ତଡ୍‌, ତିଆସନ୍‌ ଆମ୍ୱେଞ୍ଜି, ଞେନ୍‌ ଆସନ୍‌ ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ପାର୍ତନାନାବା ।” ");
INSERT INTO juy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","କେନ୍‌ ଏନ୍ନେଲେ ଆନିଞ୍ଜି ସାକିନ୍‌ ତିୟେଞ୍ଜି ଆରି ପ୍ରବୁନ୍‌ ଆ ବର୍ନେ ବର୍ରନ୍‌ ସମିରୋଣମରଞ୍ଜି ଆ ସାଇରେଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଅପ୍ପୁଙ୍‌ବର୍‌ଗଡ୍‌ଲେ ଜିରୁସାଲମନ୍‌ ୟର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ଇସ୍ୱରନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ପିଲିପନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଡୋନା, ଅର୍ଜଡ଼ୋମ୍‌ଗଡ୍‌ ଅଙ୍ଗା ତଙର୍‌ ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଗଜ୍ଜା ଗଡ଼ାନ୍‌ ଅଡ଼ୋଏନ୍‌, ତି ଆ ତଙର୍‌ଗଡ୍‌ ଜିରା ।” ତି ଆ ତଙର୍‌ଗଡ୍‌ ଆନ୍ନିଙ୍‌ ଅଃତ୍ତଙିୟ୍‌ନେଜି । ");
INSERT INTO juy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ସିଲତ୍ତେ ପିଲିପନ୍‌ ଡୋଲନ୍‌ ଜିରେନ୍‌ । ଆରି ଗିୟ୍‌ବା, ଅବୟ୍‌ ଇତିଓପିଆ ଡେସାନ୍‌ ଆ ମାୟ୍‌ତଲିଆ ପୁର୍‌ପୁରନ୍‌ ଆସନ୍‌ ଜିରୁସାଲମନ୍‌ ଇୟେନ୍‌; ଆନିନ୍‌ ଇତିଓପିଆବାଜି ଆ ରାଣି କାଣ୍ଡାକିନ୍‌ ଆ ରନ୍ନାସିଂ ଆ ଗୁମୁସ୍ତା ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ଆନିନ୍‌ ପୁର୍‌ପୁରନ୍‌ ସାଡ୍‌ଲନ୍‌ ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଆୟର୍ରନାଞନ୍‌ ଆଡିଡ୍‌ ରତ୍ତାଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ଜିସାୟ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆ ସାସ୍ତ୍ର ପଡ଼େଗଡ୍‌ଲନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ତିଆଡିଡ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ପିଲିପନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କେନ୍‌ ଆ ରତ୍ତା ଅଡମ୍‌ ଅଡମ୍‌ ଇୟ୍‌ ଜିରା ।” ");
INSERT INTO juy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ସିଲତ୍ତେ ପିଲିପନ୍‌ ଇରେନ୍‌ କି ତି ମାୟ୍‌ତଲିଆନ୍‌ ଜିସାୟ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆ ସାସ୍ତ୍ର ଆପ୍ରଡ଼େଲନ୍‌ଆତେ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଆମନ୍‌ ଅଙ୍ଗାତେ ପଡ଼େତନ୍‌, ତିଆତେ ଇନି ଗନ୍‌ଲୁଡ୍‌ତମ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ଆନିନ୍‌ ଗାମେନ୍‌, “ଞେନ୍‌ ଆନ୍ନିଙ୍‌ ଅଃଞଙ୍‌ଞଙ୍‌ଲିଁୟ୍‌ଜି ଡେନ୍‌ ଏଙ୍ଗାଲେ ଗନ୍‌ଲୁଡିଁୟ୍‌ ?” ଆରି ଆନିନ୍‌ ରତ୍ତାଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ଅମଙ୍‌ଞେନ୍‌ ଆୟ୍‌ ତଙ୍କୁମା ଗାମ୍‌ଲେ ପିଲିପନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ସାସ୍ତ୍ରଲୋଙନ୍‌ ଅଙ୍ଗାତେ ଆନିନ୍‌ ପଡ଼େଲନ୍‌, ତିଆତେ କେନ୍‌; “ମେଣ୍ଡାନ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଆପ୍ରାଙ୍‌ତେଞ୍ଜି ଅନ୍ତମ୍‌ ଆନିନ୍‌ ଓରୋଙେଞ୍ଜି, ଉପ୍ପୁରନ୍‌ ଆଗ୍ରଡ୍‌ତେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ଆଅନ୍‌ ମେଣ୍ଡାନ୍‌ ଏଙ୍ଗାଲେ କଡ଼ିଙ୍‌ଲେ ସେତ୍ତେ, ଏତ୍ତେଗନ୍‌ ଆନିନ୍‌ ଅବ୍‌କଡ଼ିଙ୍‌ଲନ୍‌ ସେଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ଆନିନ୍‌ ଗନବ୍‌ରଜନ୍‌ ଞାଙେନ୍‌ ଆରି ଆନ୍ନିଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅଃଡ୍ଡନେଲଜି । ଆକେଜ୍ଜାଞ୍ଜି ଆ ବର୍ନେ ଆନ୍ନିଙ୍‌ ବର୍ରନ୍‌ ଅଃର୍ରପ୍ତିଏ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆ ପରାନ୍ନାନ୍‌ ପୁର୍ତିନ୍‌ ସିଲଡ୍‌ ସଲନେ ।” ");
INSERT INTO juy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ମାୟ୍‌ତଲିଆନ୍‌ ପିଲିପନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଞେନ୍‌ ଅମଙ୍‌ନମ୍‌ କାକୁର୍ତିତନାୟ୍‌, ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଆନା ଆ ବର୍ନେ କେନ୍‌ ବର୍ରନେ, ଆନିନ୍‌ଡମ୍‌ ଆ ବର୍ନେ ଅଡ଼େ ଆରି ଆନ୍ନାମର୍‌ ଆ ବର୍ନେ କେନ୍‌ ଏନ୍ନେଲେ ବର୍ରନେ ?” ");
INSERT INTO juy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ସିଲତ୍ତେ ପିଲିପନ୍‌ ଅପ୍ପୁଡ୍‌ତମ୍‌ଲନ୍‌ ସାସ୍ତ୍ରଲୋଙନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ସିଲଡ୍‌ ଉଲନ୍‌ ଜିସୁନ୍‌ ଆ ମନଙ୍‌ବର୍‌ ମାୟ୍‌ତଲିଆନ୍‌ ଆମଙ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ଆନିଞ୍ଜି ତଙରନ୍‌ ଜିରା ଜିରା ଅବୟ୍‌ ବଣ୍ଡାନ୍‌ ଅଡ଼ୋଏଞ୍ଜି; ସିଲତ୍ତେ ମାୟ୍‌ତଲିଆନ୍‌ ଗାମେନ୍‌, “କେନ୍‌ ତେନ୍ନେ ତ ଡାଆନ୍‌ ଡକୋ, ଞେନ୍‌ ତବ୍ବୁବ୍‌ଡାନେନ୍‌ ଆସନ୍‌ ଇନ୍ନିଙ୍‌ ପଙ୍‌ ଡନଙ୍‌ଡଙନ୍‌ ଡକୋ ?” ");
INSERT INTO juy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ପିଲିପନ୍‌ ଗାମେନ୍‌, “ଆମନ୍‌ ସମ୍ପରା ଉଗରନ୍‌ ବାତ୍ତେ ଡର୍ରନ୍‌ ଡେନ୍‌, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆମନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ଞାଙ୍‌ତେ ।” ଆନିନ୍‌ ଜାଲଙ୍‌ଲେ ବର୍ରନେ, “ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ଡର୍ତନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ଆରି ଆନିନ୍‌ ରତ୍ତାନ୍‌ ତବ୍‌ନଙା ଗାମ୍‌ଲେ ରତ୍ତାନ୍‌ ଆସ୍ରଲ୍ଲାୟ୍‌ତେନ୍‌ ଆ ମନ୍‌ରାଆଡଙ୍‌ ବରେନ୍‌, ପିଲିପନ୍‌ ଡ ମାୟ୍‌ତଲିଆନ୍‌ ବାଗୁଞ୍ଜି ଅମ୍ମ ଡାଆନ୍‌ ଗନେଞ୍ଜି, ଆରି ପିଲିପନ୍‌ ମାୟ୍‌ତଲିଆନ୍‌ଆଡଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ଆନିଞ୍ଜି ଡାଆଲୋଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରାଞଞ୍ଜି ଆଡିଡ୍‌ ପ୍ରବୁନ୍‌ ଆ ପୁରାଡ଼ା ପିଲିପନ୍‌ଆଡଙ୍‌ ଓରୋଙେନ୍‌, ଆରି ମାୟ୍‌ତଲିଆନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଲୋ; ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ସର୍ଡାନ୍‌ ବାତ୍ତେ ଆନିନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ବନ୍‌ଡ ପିଲିପନ୍‌ ଅସ୍‌ଦୋଦ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ଗିୟ୍‌ତାଏନ୍‌, ଆରି ଆନିନ୍‌ ଜିରା ଜିରା ଗଡ଼ାରେଙନ୍‌ ମନଙ୍‌ବରନ୍‌ ଅପ୍ପୁଙ୍‌ବର୍‌ଡାଲେ କାଇସରିଆ ଗଡ଼ାନ୍‌ ଅଡ଼ୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ବନ୍‌ଡ ସାଓଲନ୍‌ ନମିନ୍ତାନ୍‌ ପ୍ରବୁନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜିଆଡଙ୍‌ ରନବ୍ବୁବରନ୍‌ ବର୍ରନ୍‌ ବବ୍‌ତଙେଞ୍ଜି । ଆନିନ୍‌ ମୁଡ଼ ରାଓଡ଼ାନ୍‌ ଆମଙ୍‌ ଇୟେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ଆରି ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ଆଡର୍ତନେଞ୍ଜି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଦମ୍ମେସକନ୍‌ ଆ ସରେବାସିଂରେଙ୍‌ ଓବ୍ବାମର୍‌ ଡେଏତୋ କି ଆଇମର୍‌ ଡେଏତୋ ରବାଙେଞ୍ଜି ଡେନ୍‌, ଆନିଞ୍ଜିଆଡଙ୍‌ ଜିଲେ ଜିରୁସାଲମନ୍‌ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ଅନଡ଼େଅଲନ୍‌ ବେଡେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ବନ୍‌ଡ ଆନିନ୍‌ ଜିରା ଜିରା ଦମ୍ମେସକନ୍‌ ଆ ତୁୟାୟ୍‌ ଆରଡ଼ୋଏନ୍‌ ଆଡିଡ୍‌ ଏରବ୍ବୋମଙ୍‌ଡାଗୋ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ସନାଆରନ୍‌ ଆମଙ୍‌ରେଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତରାଡେ । ");
INSERT INTO juy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ସିଲତ୍ତେ ଆନିନ୍‌ ଲବଲୋଙନ୍‌ ଆଗ୍ରୋଙେନ୍‌ ସିଲଡ୍‌ ଆନିନ୍‌ ଅବୟ୍‌ ସର୍ରଙନ୍‌ ଅମ୍‌ଡଙେନ୍‌, “ଏ ସାଓଲ, ଏ ସାଓଲ, ଆମନ୍‌ ଇନିଆସନ୍‌ ଞେନ୍‌ ଡଣ୍ଡାୟ୍‌ତିଁୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ସାଓଲନ୍‌ ଗାମେନ୍‌ । “ଏ ପ୍ରବୁ ଆମନ୍‌ ଆନା ?” ଆନିନ୍‌ ଗାମେନ୍‌, “ଆନାଆଡଙ୍‌ ଆମନ୍‌ ଡଣ୍ଡାୟ୍‌ତେ, ତି ଆ ଜିସୁ ଞେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ଆର୍ପାୟ୍‌ ଡୋନା, ଗଡ଼ାନ୍‌ ଇୟ୍‌ଗନା, ଆରି ଞେନ୍‌ ଏଙ୍ଗାଲେ ବର୍ତମ୍‌ ଏତ୍ତେଲେ ଲୁମା ।” ");
INSERT INTO juy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ଅଙ୍ଗା ମନ୍‌ରାଜି ସାଓଲନ୍‌ ସରିନ୍‌ ଇୟେଞ୍ଜି, ଆନିଞ୍ଜି ତି ଆ ସର୍ରଙ୍‌ ଅମ୍‌ଡଙେଞ୍ଜି ସିନା ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଅଃଗିୟ୍‌ଲଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ଆରି, ସାଓଲନ୍‌ ଲବଲୋଙନ୍‌ ସିଲଡ୍‌ ଡୋଲନ୍‌ ଆରାଙାଙ୍‌ଲନ୍‌, ଆନିନ୍‌ ଇନ୍ନିଙ୍‌ ଗିୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଲୋ । ତିଆସନ୍‌ ଆନିଞ୍ଜି ସାଓଲନ୍‌ ଆସି ଞମ୍‌ଲେ ଦମ୍ମେସକନ୍‌ ଓରୋଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ଆରି ଆନିନ୍‌ ୟାଗି ଡିନ୍ନା ଜାୟ୍‌ ଗିୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଲୋ, ଆରି ଇନ୍ନିଙ୍‌ ଅଃଜ୍ଜୋମ୍‌ଲୋ କି ଅଃଗାଲୋ । ");
INSERT INTO juy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ଦମ୍ମେସକନ୍‌ ଅନନିଅ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଞଙ୍‌ନେମରନ୍‌ ଡକୋଏନ୍‌; ତନାଲ୍‌ମଡ୍‌ଲୋଙନ୍‌ ପ୍ରବୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଅନନିଅ ।” ଆନିନ୍‌ ଜାଲଙେନ୍‌ “ବର୍ନା ପ୍ରବୁ ଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ପ୍ରବୁନ୍‌ ଅନନିଅନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଡୋନା, ଅବ୍‌ଜାଡାନା, ବିଙୟ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ତଙରନ୍‌ ଆଞୁମ୍‌ ଡକୋ, ତି ଆ ତଙର୍‌ଗଡ୍‌ ଜିର୍ରେ ଜିଉଦାନ୍‌ ଆସିଂ ଇୟା । ତେତ୍ତେ ତାର୍ସ ଗଡ଼ାନ୍‌ ଆ ମନ୍‌ରା ଡକୋ, ଆଞୁମନ୍‌ ସାଓଲ, ଆନିନ୍‌ ଇୟ୍‌ସାଜା; ଆନିନ୍‌ ତେତ୍ତେ ପାର୍ତନାତନେ । ");
INSERT INTO juy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ଆରି, ଅନନିଅ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଇୟ୍‌ଲେ ଆବବ୍‌ଲୋଙନ୍‌ ଆସିନ୍‌ ଡକ୍କୋଏନ୍‌ ଡେନ୍‌ ଆନିନ୍‌ ଆରି ଗିୟ୍‌ଲେ ରପ୍ତିତେ ଗାମ୍‌ଲେ ଆନିନ୍‌ ତନାଲ୍‌ମଡନ୍‌ ଗିଜେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ଅନନିଅନ୍‌ ଜାଲଙେନ୍‌, “ପ୍ରବୁ, ଜିରୁସାଲମ୍‌ ଗଡ଼ାଲୋଙନ୍‌ ମନ୍‌ରାନମ୍‌ଜିଆଡଙ୍‌ କେନ୍‌ ଆ ମନ୍‌ରା ଡିଅଙ୍ଗା ଡଣ୍ଡାୟେଞ୍ଜି, ତିଆତେ ଞେନ୍‌ ଜବ୍ର ମନ୍‌ରାଜି ଆମଙ୍‌ ସିଲଡ୍‌ କେନ୍‌ ଆ ମନ୍‌ରା ଆ ବର୍ନେ ଅମ୍‌ଡଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ଆରି, କେନ୍‌ ତେନ୍ନେ ଡିଅଙ୍ଗା ମନ୍‌ରା ଅଞୁମ୍‌ଲୋଙ୍‌ନମ୍‌ ପାର୍ତନାତଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଜିଲେ ପନାଙନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଅନଡ଼େଅଲନ୍‌ ଞାଙେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ବନ୍‌ଡ ପ୍ରବୁନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଜିରା, ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌, ରାଜାନ୍‌ ଆମଙ୍‌ ଡ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ଅଞୁମ୍‌ଞେନ୍‌ ଅନମ୍‌ତୁଙନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ସେଡାଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଅଞୁମ୍‌ଞେନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଡିଅଙ୍ଗା ପରାନ୍‌ଡଣ୍ଡନ୍‌ ଡେତେ, ତିଆତେ ଞେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଜନାତାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଅନନିଅନ୍‌ ଜିରେନ୍‌ କି ସାଓଲନ୍‌ ଆଡ୍ରକୋଲନ୍‌ ଆସିଂ ଇୟ୍‌ଲେ ଗନେ, ଆରି, ସାଓଲନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଆସିନ୍‌ ଡକ୍କୋଲେ ବର୍ରନେ, “ବୋଞାଙ୍‌ ସାଓଲ, ଆମନ୍‌ ତଙରନ୍‌ ଜରିରେନ୍‌ ଆଡିଡ୍‌ ଅଙ୍ଗା ପ୍ରବୁ ଜିସୁ ଅମଙ୍‌ନମ୍‌ ଅବ୍‌ତୁୟ୍‌ଲନ୍‌; ଆମନ୍‌ ଗିୟ୍‌ଲେ ରପ୍ତିଆ ଆରି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଞାଙା ଗାମ୍‌ଲେ ଆନିନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲିଁୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ସିଲତ୍ତେ ମା ଅବ୍‌ତାଡ଼ନ୍‌ ସାଓଲନ୍‌ ଆମଡ୍‌ ସିଲଡ୍‌ ଆବଲ୍ଲାବା ଅନ୍ତମ୍‌ଆତେ ଇନିତ୍ତି ଅସେଡେନ୍‌ ଆରି ଆମଡନ୍‌ ମନଙେନ୍‌; ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ଡୋଲନ୍‌ କି ତବ୍ବୁବ୍‌ଡାଲନ୍‌, ");
INSERT INTO juy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ଆରି ଆନିନ୍‌ ଗାଗାଲନ୍‌ କି ବପ୍ପୁଏନ୍‌, ତେତ୍ତେ ଦମ୍ମେସକନ୍‌ ଆ ଡର୍ନେମର୍‌ଜି ସରିନ୍‌ ଅସୋୟ୍‌ ଡିନ୍ନା ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ଆରି, ଆନିନ୍‌ ରନୁକ୍କୁସିଂରେଙନ୍‌ ଜିର୍ରେ, ଜିସୁନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌, ଗାମ୍‌ଲେ ବର୍ବର୍ରେ ପାଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ଆନାଜି ଆ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙେଞ୍ଜି ଆନିଞ୍ଜି ସାନ୍ନିଡାଲେ ବର୍ରଞ୍ଜି, “ଅଙ୍ଗା ମନ୍‌ରାଜି ଜିସୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ପାର୍ତନାଲଞ୍ଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ ଜିରୁସାଲମନ୍‌ ଓରୋଙ୍‌ଡାଲେ ଇୟ୍‌ଲେ ଅବ୍‌ରବ୍ବୁଏଜି, ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ଜିଲେ ସୋଡ଼ା ରାଓଡ଼ାଞ୍ଜି ଆମଙ୍‌ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ କେନ୍‌ ତେନ୍ନେ ଇୟ୍‌ଲାୟ୍‌, କେନ୍‌ ଆନିନ୍‌ ତି ଆ ମନ୍‌ରା ତଡ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ବନ୍‌ଡ ସାଓଲନ୍‌ ଆରି ବୋର୍ସାଲେ ପାଙେନ୍‌, କି ଜିସୁନ୍‌ ମା କ୍ରିସ୍ଟ, ଗାମ୍‌ଲେ ଆନିନ୍‌ ଏତ୍ତେଲେ ସାକିନ୍‌ ତିୟେନ୍‌ ଡ ଦମ୍ମେସକନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଆ ଜିଉଦିମର୍‌ଜି ଆରି ଜାଲଙ୍‌ଲନ୍‌ ଅଃର୍ରପ୍ତିଲଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ଜବ୍ର ଡିନ୍ନା ଆଡ୍ରେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସାଓଲନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଜିଉଦିମରଞ୍ଜି ରୁକ୍କୁଲନ୍‌ କଡାଡ଼ିଲଞ୍ଜି; ");
INSERT INTO juy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ବନ୍‌ଡ ଆନିଞ୍ଜି ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ଆ ବର୍ନେ ସାଓଲନ୍‌ ଜନାଏନ୍‌ । ଆରି, ଆନିଞ୍ଜି ସାଓଲନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ତଗଲ୍‌ ତମ୍‌ବା ଗଡ଼ାନ୍‌ ଆ ଡୁଆରାଲୋଙ୍‌ ଡଲ୍ଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ବନ୍‌ଡ ସାଓଲନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ତଗଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବୟ୍‌ ସିରାଲୋଙନ୍‌ ଅବ୍‌ତଙ୍କୁମ୍‌ଲେ କିନ୍ତାଲ୍‌ଗଡ୍‌ ଜାୟ୍‌ତାନ୍‌ ଅପ୍ପଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ତିକ୍କି ଆନିନ୍‌ ଜିରୁସାଲମନ୍‌ ଜିର୍ରେ ଞଙ୍‌ନେମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ନେନ୍‌ ଆସନ୍‌ ଏରେନ୍‌ ଗୋଜେନ୍‌; ବନ୍‌ଡ ଆନିନ୍‌ ଅବୟ୍‌ନେ ଞଙ୍‌ନେମର୍‌ ଗାମ୍‌ଲେ ଆନିଞ୍ଜି ଅଃଡ୍ଡର୍ରଞ୍ଜି, ଅଡ଼୍‌କୋଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବତଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ବନ୍‌ଡ ବର୍ନବାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ଓରୋଙ୍‌ଲାୟ୍‌; ତଙର୍‌ଲୋଙନ୍‌ ଏଙ୍ଗାଲେ ଆନିନ୍‌ ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ଗିଜେନ୍‌ ଆରି ପ୍ରବୁନ୍‌ ଏଙ୍ଗାଲେ ଆନିନ୍‌ ସରିନ୍‌ କଡାଡ଼ିଲନ୍‌, ଆନିନ୍‌ ଏଙ୍ଗାଲେ ଦମ୍ମେସକ ଗଡ଼ାଲୋଙନ୍‌ ଅବ୍‌ନୋମଙ୍‌ଲନ୍‌ ଜିସୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଅପ୍ପୁଙ୍‌ବରେନ୍‌, ତି ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ବର୍ନବାନ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","କେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ସାଓଲନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ବୟନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଲନ୍‌ ଆରି ଜିରୁସାଲମନ୍‌ ଆୟର୍‌ୟର୍‌ମନେଙ୍‌ ଇୟ୍‌ଲେ ଅବ୍‌ନୋମଙ୍‌ଲନ୍‌ ପ୍ରବୁନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଅପ୍ପୁଙ୍‌ବରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ଆନିନ୍‌ ଗ୍ରିକ୍‌ ଲଙ୍‌ଲଙନ୍‌ ବାତ୍ତେ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ଆ ଜିଉଦିଜି ସରିନ୍‌ ଅଲ୍‌ଜାଲଙେଞ୍ଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ସାଓଲନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ଏରେଞ୍ଜି ଗୋଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ତି ଆ ବର୍ନେ ଡର୍ନେ ବୋଞାଙଞ୍ଜି ଆଜ୍ରନାଏଞ୍ଜି, ସାଓଲନ୍‌ଆଡଙ୍‌ କାଇସରିଆ ଗଡ଼ାନ୍‌ ଓରୋଙ୍‌ଲେ ତାର୍ସ ଗଡ଼ାନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ଏନ୍ନେଗନ୍‌ ସମ୍ପରା ଜିଉଦାନ୍‌, ଗାଲିଲିନ୍‌ ଡ ସମିରୋଣ ଡେସାନ୍‌ ଆ ମଣ୍ଡଡ଼ିଜି ସୟୁଡମ୍‌ ଡକୋଏନ୍‌ । ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ ଡର୍ନେମରଞ୍ଜି ଗୋଗୋୟ୍‌ଲେ ପାଙେଞ୍ଜି, ଆରି ଡର୍ନେମରଞ୍ଜି ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ବତଙନ୍‌ ବାତ୍ତେ ଞଣ୍ଡ୍ରମ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ତିଆଡିଡ୍‌ ପିତ୍ରନ୍‌ ସମ୍ପରାନ୍‌ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ଲୁଦ ଗଡ଼ାଲୋଙନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ନିୟ୍‌ ତୁଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ତେତ୍ତେ ଆନିନ୍‌ ଏନିଅ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଇୟ୍‌ଲେ ରବାଙେ, ଆନିନ୍‌ ଆଟ ବର୍ସେଙ୍‌ ଡେଏନ୍‌ ଆଲୁଡ୍‌ଲୁଡ୍‌ ଡକୋଲନ୍‌, ଆନିନ୍‌ କାନ୍ନିଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଏନିଅ, ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ମବ୍‌ନଙ୍‌ତମ୍‌; ଡୋନା, ବରେଲ୍‌ବେଲ୍‌ନମ୍‌ଜି ଜୁବାୟା ।” ସିଲତ୍ତେ ଏନିଅନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଡୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ଆରି ଲୁଦ ଗଡ଼ାନ୍‌ ଡ ସାରୋଣବାଜି ଅଡ଼୍‌କୋଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ୟର୍ରନାଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଜାପୋ ଗଡ଼ାଲୋଙନ୍‌ ଟାବିତା ଗାମ୍‌ଲେ ଅବୟ୍‌ ଡର୍ନେବଜନ୍‌ ଡକୋଏନ୍‌, ବାଣ୍ଡାଲବୋ ଡେନ୍‌ କେନ୍‌ ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ଦର୍କା । ଆନିନ୍‌ ମନଙ୍‌ ଲନୁମଞ୍ଜି ଲୁମେନ୍‌ ଆରି ଡୋଲେୟ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ସାଜଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ତିଆଡିଡ୍‌ ଆନିନ୍‌ ଅସୁଡାଲେ ରବୁଏନ୍‌, ସିଲତ୍ତେ ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଉମ୍ମାଡାଲେ ଅବୟ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆସିଂଲୋଙ୍‌ ଅବ୍‌ଲୁଡ୍‌ଲୁଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଆରି, ଲୁଦ ଗଡ଼ାନ୍‌, ଜାପୋ ଗଡ଼ାନ୍‌ ଆ ତୁୟାୟ୍‌ ଆଡ୍ରକୋଏନ୍‌ ଆସନ୍‌, ପିତ୍ରନ୍‌ ଲୁଦ ଗଡ଼ାଲୋଙନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ଅମ୍‌ଡଙେଞ୍ଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ବାଗୁ ମନ୍‌ରା ଏନ୍ନେଲେ ବର୍ରେ ପିତ୍ରନ୍‌ ଆମଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି, “ଆମନ୍‌ ଆରି ଅବ୍‌ଡିଂଡଂନେ ଅମଙ୍‌ଲେନ୍‌ ଲଜିରାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ଆରି ପିତ୍ରନ୍‌ ଡୋଲନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଜାପୋ ଗଡ଼ାନ୍‌ ଜିରେନ୍‌ । ଆନିନ୍‌ ଆଜିର୍ରାଞନ୍‌ ସିଲଡ୍‌, ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ତୋଣ୍ଡୋନ୍‌ ଆସିଂ ଓରୋଙେଞ୍ଜି, ତେତ୍ତେ ଅଡ଼୍‌କୋ ଜୁଆର୍‌ବଜଞ୍ଜି ୟେୟେଡାଲଞ୍ଜି; ଆରି ଦର୍କାନ୍‌ ଆମେଙ୍‌ ଇଙନ୍‌ ଅଙ୍ଗା ଅଙ୍ଗିଜି ଆରି ଅଙ୍ଗା ସିନ୍‌ରିଜି ତାଞେନ୍‌, ତି ଅଡ଼୍‌କୋନ୍‌ ଅବ୍‌ତୁଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଅଡ଼୍‌କୋଞ୍ଜି ଅମ୍‌ଡୁଙ୍‌ଡାଲେ ତୁଡ଼ୁମ୍‌ଲେ ପାର୍ତନାଲନ୍‌; ଆରି ମଡ଼ଗଡ୍‌ ବୁଲ୍ଲେଲେ ଆଙାଙ୍‌ଲେ ବର୍ରନେ, “ଟାବିତା, ଡୋନା ।” ସିଲତ୍ତେ ଆନିନ୍‌ ସାବ୍‌କୁଡ୍‌ମଡ୍‌ଲନ୍‌, ଆରି ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଡୋଲନ୍‌ ତଙ୍କୁମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ଆରି ପିତ୍ରନ୍‌ ଟାବିତାନ୍‌ ଆସି ଞମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଡୋଏନ୍‌ କି ଇସ୍ୱରନ୍‌ ଆ ମନ୍‌ରାଜି ଡ ଜୁଆର୍‌ବଜଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ଆନିନ୍‌ ଆମେଙନ୍‌ ଅବ୍‌ତୁଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","କେନ୍‌ ଆ ବର୍ନେ ଜାପୋ ଗଡ଼ାନ୍‌ ସମ୍ପରାନ୍‌ ଜନାଆଜେଞ୍ଜି ଆରି ଜବ୍ର ମନ୍‌ରାଜି ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ଆରି, ପିତ୍ରନ୍‌ ଜବ୍ର ଡିନ୍ନା ଜାପୋ ଗଡ଼ାଲୋଙନ୍‌ ସିମନ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଉସାଲ୍‌ କାବ୍ବାଡ଼ାମରନ୍‌ ଆସିଂ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କାଇସରିଆ ଗଡ଼ାଲୋଙନ୍‌ କର୍ନିଏଲ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆନିନ୍‌ ଇଟାଲି ଡେସାନ୍‌ ଆ ସିପ୍ପାୟ୍‌ଜି ଆ ଡଡ଼ଲୋଙ୍‌ ସୋଡ଼ା ସିପ୍ପାୟ୍‌ ଡକୋଏନ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ଆନିନ୍‌ ଅବୟ୍‌ ବୟ୍‌ଲେମର୍‌; ଆରି ଆନିଞ୍ଜି ଅସିଙନ୍‌ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ବତଙେଞ୍ଜି । ଆନିନ୍‌ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଜବ୍ର ତନିୟ୍‌ତିୟଞ୍ଜି ତିୟେଞ୍ଜି, ଆରି ଡିତାନ୍‌ ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ପାର୍ତନାଲନେ । ");
INSERT INTO juy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ବଡିନ୍ନା ସାଲ୍ଲୁମନ୍‌ ୟାଗି ଗଣ୍ଟା ଇଙନ୍‌ ଆନିନ୍‌ ରୟ୍‌ଲଙ୍‌ଡମ୍‌ ଅବୟ୍‌ ତନାଲ୍‌ମଡନ୍‌ ଗିଜେନ୍‌, ଇସ୍ୱରନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ଆମଙନ୍‌ ଜିର୍ରେ ଇୟ୍‌ତାୟ୍‌ ବରେ, “ଏ କର୍ନିଏଲ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ସିଲତ୍ତେ ଆନିନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ଆଡଙ୍‌ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙ୍‌ଡାଲେ ବାବନ୍ତଙ୍‌ ବର୍ରନେ, “ଏ ପ୍ରବୁ ଇନି ?” ଆନିନ୍‌ କର୍ନିଏଲନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ପାର୍ତନାନମ୍‌ ଡ ତନିୟ୍‌ତିୟ୍‌ନମ୍‌ଜି ଅନୋଙ୍କେନ୍‌ ଆନମଙ୍‌ ଅନ୍ତମ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ତୁଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ନମି ଆମନ୍‌ ଜାପୋ ଗଡ଼ାନ୍‌ ମନ୍‌ରାନ୍‌ ଆପ୍ପାୟ୍‌ଲେ ସିମନନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଲେ ଓରୋଙାୟ୍‌; ଆନୋଡ୍ଡେଞୁମନ୍‌ ପିତ୍ର । ");
INSERT INTO juy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ଆନିନ୍‌ ସିମନ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ଉସାଲ୍‌ କାବ୍ବାଡ଼ାମରନ୍‌ ଆସିଂ ଡକୋତନ୍‌, ଆସିଙନ୍‌ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଡକୋ ।” ");
INSERT INTO juy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","କର୍ନିଏଲନ୍‌ ସରିନ୍‌ ଆକ୍ରଡାଡ଼ିଲନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଆଜିର୍ରେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନିନ୍‌ ଆସିଙନ୍‌ ଆଡ୍ରକୋତଞ୍ଜି ବାଗୁ କମ୍ୱାରିମରଞ୍ଜି ଡ ଆନିନ୍‌ଆଡଙ୍‌ ଆସ୍ରାକ୍କେତେଞ୍ଜି ଆ ସିପ୍ପାୟ୍‌ଜି ସିଲଡ୍‌ ଅବୟ୍‌ ବୟ୍‌ଲେ ସିପ୍ପାୟନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ଆରି ଆନିଞ୍ଜିଆଡଙ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ବର୍ନେ ବର୍ରେ ଜାପୋ ଗଡ଼ାନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ତି ଆବାର୍ତାନ୍‌ ଆନିଞ୍ଜି ଜିରା ଜିରା ଜାପୋ ଗଡ଼ାନ୍‌ ଆ ତୁୟାୟ୍‌ ଅଡ଼ୋଏଞ୍ଜି, ତିଆଡିଡ୍‌ ତମ୍‌ବାନ୍‌ ବାରଟାରେ ପିତ୍ରନ୍‌ ପାର୍ତନାନେନ୍‌ ଆସନ୍‌ ତୋଣ୍ଡୋ ମେଡ଼ନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ଆରି ଆନିନ୍‌ ଆଡ୍ରୋଲେୟ୍‌ଡାଏନ୍‌ ଗାଗାନେନ୍‌ ସାଜେନ୍‌; ବନ୍‌ଡ ଆନିଞ୍ଜି ଆଡ୍ରିଁୟ୍‌ଡିଁୟ୍‌ଲଞ୍ଜି ଆଡିଡ୍‌ ପିତ୍ରନ୍‌ ମୁର୍ସାଏନ୍‌ କି ତନାଲ୍‌ମଡନ୍‌ ଗିଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ରୁଆଙନ୍‌ ରୋଲନେ, ଆରି ଅବୟ୍‌ ସୋଡ଼ାଡମ୍‌ ଆ ମାଟ ଉଞ୍ଜିମନେଙନ୍‌ ଞମ୍‌ଲେ ପୁର୍ତିଲୋଙନ୍‌ ଜବ୍‌ଲୟ୍‌ତାଜି; ");
INSERT INTO juy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ତେତ୍ତେ ପୁର୍ତିଲୋଙନ୍‌ ଉଞ୍ଜି ଅଜଙନ୍‌ ଡକୋନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ଜନ୍ତୁଜି, ଆ କିମ୍ପୋଙଞ୍ଜି ଲବନ୍‌ ଅବ୍‌ଜାବ୍‌ଲେ ଆତ୍ରଙିୟ୍‌ତଞ୍ଜି ଆ ଜନ୍ତୁଜି ଡ ରୁଆଙନ୍‌ ଆ ଅନ୍ତିଡ୍‌ଜି ଡକୋଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ଆରି ପିତ୍ରନ୍‌ ଆମଙ୍‌ ଅବୟ୍‌ ସର୍ରଙନ୍‌ ଅଡ଼ୋଲାୟ୍‌, “ପିତ୍ର ଡୋନା, କେନ୍‌ଆତେଜି ରବ୍ବୁଡାଲେ ଜୋମା ।” ");
INSERT INTO juy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ଇଜ୍ଜା ପ୍ରବୁ, ଞେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଏର୍‌ମଡ଼ିରନ୍‌ ଡ ଏର୍‌ମନଙନ୍‌ ଆ ଜନୋମ୍‌ଜୋମ୍‌ଜି ଅଣ୍ଡ୍ରଙ୍‌ ଜୋମାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ଆରି ବତର ପିତ୍ରନ୍‌ ଆମଙ୍‌ ସର୍ରଙନ୍‌ ଅଡ଼ୋଲାୟ୍‌, “ଅଙ୍ଗାତେ ଇସ୍ୱରନ୍‌ ମଡ଼ିର୍‌ ଏମ୍ମେଏନ୍‌ ତିଆତେ ଆମନ୍‌ ମଡ଼ିର୍‌ ତଡ୍‌ ଗାମ୍‌ଡଙ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","କେନ୍‌ ଏନ୍ନେଲେ ୟାଗି ତର ଡେଏନ୍‌ କି, ତି ମାଟନ୍‌ ତୋଣ୍ଡୋ ରୁଆଙନ୍‌ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ପିତ୍ରନ୍‌ ଅଙ୍ଗା ତନାଲ୍‌ମଡ୍‌ ଗିଜେନ୍‌, ତି ଆଗ୍ରାମ୍‌ଗାମନ୍‌ ଇନି, ଗାମ୍‌ଲେ ଇୟମ୍‌ଡାଲେ ଆନିନ୍‌ ସାନ୍ନି ଆଡ୍ରେଏନ୍‌ ଆଡିଡ୍‌, ଗିୟ୍‌ବା, କର୍ନିଏଲନ୍‌ ଆରାପ୍ପାୟ୍‌ଲାଞଞ୍ଜି ଆ ମନ୍‌ରାଜି ସିମନନ୍‌ ଆସିଂ ଅଡ଼େଙ୍ଗା ଗାମ୍‌ଲେ ସାୟ୍‌ଲେ ସାୟ୍‌ଲେ ଅସିଙନ୍‌ ଆ ଗରନ୍ନେଲୋଙ୍‌ ଇୟ୍‌ଲେ ତନଙେଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଇୟ୍‌ଲେ ବରେଜି, “ସିମନ୍‌ ପିତ୍ର ଗାମ୍‌ଲେ ଅବୟ୍‌ କନୁଆମରନ୍‌ ତେନ୍ନେ ଡକୋତନ୍‌ ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ପିତ୍ରନ୍‌ କେନ୍‌ ଆତନାଲ୍‌ମଡ୍‌ ଇୟମ୍‌ଲେ ଆଡ୍ରକୋଲନ୍‌ ଆଡିଡ୍‌, ପୁରାଡ଼ାନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ଗିଜା, ୟାଗି ମନ୍‌ରା ଆମନ୍‌ଆଡଙ୍‌ ସାୟ୍‌ଡଙ୍‌ତମ୍‌ଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ଡୋନା, ଜାୟ୍‌ତାନ୍‌ ପଡ୍‌ନା, ଇନ୍ନିଙ୍‌ ଏର୍‌ଡାଲ୍‌ଗଡ୍‌ଲେ ଆନିଞ୍ଜି ସରିନ୍‌ ଜିରା, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଜାୟ୍‌ତାନ୍‌ ପଡ୍‌ଲନାୟ୍‌ କି ତି ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ବରେଜି, “ଗିୟ୍‌ବା, ଆମ୍ୱେଞ୍ଜି ଆନାଆଡଙ୍‌ ଏସାୟ୍‌ତେ ଞେନ୍‌ ଆନିନ୍‌ । ଆମ୍ୱେଞ୍ଜି ଇନିଆସନ୍‌ ଏଇୟ୍‌ଲାୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ଆନିଞ୍ଜି ଜାଲଙେଞ୍ଜି “କର୍ନିଏଲ୍‌ ଗାମ୍‌ଲେ ଅବୟ୍‌ ସୋଡ଼ା ସିପ୍ପାୟନ୍‌ ଇନ୍‌ଲେନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲଲେନ୍‌, ଆନିନ୍‌ ଅବୟ୍‌ ଡରମ୍ମମର୍‌, ଆରି ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ବତଙ୍‌ତେ, ଅଡ଼୍‌କୋ ଜିଉଦିମରଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ମାନ୍ନେତଜି । ଆମନ୍‌ଆଡଙ୍‌ ଆସିଙନ୍‌ ଓଡ୍ଡେଲେ ଓରୋଙ୍‌ଡାଲେ ଅମଙ୍‌ନମ୍‌ ସିଲଡ୍‌ ଞନଙନ୍‌ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌, ମଡ଼ିର୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍ମସିଙନ୍‌ ଓଡ୍ଡେଲେ ଓରୋଙେଞ୍ଜି, ତି ଆ ତଗଲ୍‌ ଆନିଞ୍ଜି ତେତ୍ତେ ଡକୋଲଞ୍ଜି । ତି ଆବାର୍ତାନ୍‌ ପିତ୍ରନ୍‌ ଡୋଲନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଜିରେନ୍‌; ଆରି, ଜାପୋ ଗଡ଼ାବାଜି ନିୟ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ବୋଞାଙଞ୍ଜି ଆନିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ଆବାର୍ତାନ୍‌ ଆନିଞ୍ଜି କାଇସରିଆ ଗଡ଼ାନ୍‌ ତୁଙେଞ୍ଜି, ଆରି କର୍ନିଏଲନ୍‌ ଆ କୁଲମଞ୍ଜି ଡ ଆ ସାଙ୍ଗଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଡାଲେ ରୁକ୍କୁଲଞ୍ଜି କି ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଜଗେଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପିତ୍ରନ୍‌ ଅମ୍ମସିଙନ୍‌ ଆଗ୍ରନ୍‌ବେଡ୍‌ତେନ୍‌ ଆଡିଡ୍‌ କର୍ନିଏଲନ୍‌ ଜିର୍ରାୟ୍‌ କି ତୁଡ଼ୁମ୍‌ଲେ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ଲୋମେ । ");
INSERT INTO juy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ବନ୍‌ଡ ପିତ୍ରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଡୋଲେ ବରେନ୍‌; “ଡୋନା, ଞେନ୍‌ ନିୟ୍‌ ଆମନ୍‌ ଅନ୍ତମ୍‌ ଅବୟ୍‌ ମନ୍‌ରା ।” ");
INSERT INTO juy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ କର୍ନିଏଲନ୍‌ ବାତ୍ତେ କଡାଡ଼ିଗଡ୍‌ଲନ୍‌ ଅମ୍ମସିଙନ୍‌ ଗନ୍‌ଲଞ୍ଜି, ଆରି ତେତ୍ତେ ଜବ୍ର ମନ୍‌ରା ରୁକ୍କୁଲନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଇୟ୍‌ଲେ ଗିଜେଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ଆରି ପିତ୍ରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଅବୟ୍‌ ଜିଉଦିମରନ୍‌ ଏର୍‌ଜିଉଦିମରନ୍‌ ସରିନ୍‌ ମାୟ୍‌ନେନ୍‌ ଆରି ଆସିଙନ୍‌ ଅନିୟନ୍‌ ଆସନ୍‌ ବନାଁୟ୍‌ବରନ୍‌ ଅନଡ଼େନ୍‌ ଅଃତ୍ତିୟେ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ମନଙ୍‌ଡମ୍‌ ଆଜନାଜି; ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଆନ୍ନିଙ୍‌ଆଡଙ୍‌ ଏର୍‌ମଡ଼ିର୍‌ ଆରି ମନଙ୍‌ ତଡ୍‌ ଗାମ୍‌ଲେ ଏବର୍‌ଡଙ୍‌ନେ ଗାମ୍‌ଲେ ଇସ୍ୱରନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବର୍ରିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ତିଆସନ୍‌ ଞେନ୍‌ ନିୟ୍‌ ଆରୋଡ୍ଡେଲିଞନ୍‌ ସିଲଡ୍‌ ଞେନ୍‌ ଅଃନ୍ନସାଲାୟ୍‌, ଅବ୍‌ତାଡ଼ନ୍‌ ଜିର୍ରାୟ୍‌ । ଆମ୍ୱେଞ୍ଜି ଇନିବା ଞେନ୍‌ଆଡଙ୍‌ ଏଓଡ୍ଡେଲିଁୟ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","କର୍ନିଏଲନ୍‌ ବର୍ରନେ, “ଉଞ୍ଜି ଡିନ୍ନା ଆମ୍ମୁଙ୍‌ ସାଲ୍ଲୁମନ୍‌ ୟାଗି ଗଣ୍ଟା ଇଙନ୍‌ ଞେନ୍‌ ଅସିଂଞେନ୍‌ ମା ପାର୍ତନାଲନାୟ୍‌; ଆରି ଗିଜା, ସାଆର୍‌ଡମ୍‌ ଆ ସିନ୍‌ରି ଆଜିଜିନେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ମୁକ୍କାବାଞେନ୍‌ ତନଙ୍‌ଡାଲେ ଇୟ୍‌ଲାୟ୍‌ ବର୍ନେ, ");
INSERT INTO juy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘କର୍ନିଏଲ୍‌, ପାର୍ତନାନମ୍‌ ଇସ୍ୱରନ୍‌ ଅମ୍‌ଡଙେନ୍‌, ଆରି ତନିୟ୍‌ତିୟ୍‌ନମ୍‌ଜି ଅଡ଼୍‌କୋନ୍‌ ଆନିନ୍‌ ଗିଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ତିଆସନ୍‌ ଜାପୋ ଗଡ଼ାନ୍‌ ମନ୍‌ରାନ୍‌ ଆପ୍ପାୟ୍‌ଡାଲେ ପିତ୍ର ଗାମ୍‌ଲେ ଆରୋଡ୍ଡେତେଞ୍ଜି ସିମନନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଲେ ଓରୋଙାୟ୍‌ । ଆନିନ୍‌ ଅନେଙ୍‌ ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଆଡ୍ରକୋତନ୍‌ ଉସାଲ୍‌ କାବ୍ବାଡ଼ାମର୍‌ ସିମନନ୍‌ ଆସିଂ କନୁଆନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ତିଆସନ୍‌ ଞେନ୍‌ ଅବ୍‌ତାଡ଼ନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଅନୋଡ୍ଡେନ୍‌ ଆସନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆପ୍ପାୟ୍‌ଲାଜି, ଆରି ବୟ୍‌ଲେଙ୍‌, ଆମନ୍‌ ଅସିଂଞେନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ଆରି, ପ୍ରବୁନ୍‌ ଇନିଜି ଆମନ୍‌ଆଡଙ୍‌ ବର୍ରମ୍‌, ତିଆତେ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଇନ୍‌ଲେନ୍‌ ଅଡ଼୍‌କୋନ୍‌ଲେନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ମୁକ୍କାଗଡ୍‌ ଏରୁକ୍କୁଲନାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଅପ୍ପୁଡ୍‌ତମ୍‌ଲନ୍‌ ଞନଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଉଲନେ, “ନମି ଞେନ୍‌ ଜନାଲେ ରପ୍ତିତାୟ୍‌, ଇସ୍ୱରନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ଆଡଙ୍‌ ଆବସମାନନ୍‌ ଗିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ଅଙ୍ଗାଜନଙ୍‌ ଆ ଜାତିମର୍‌ ଆରି ଏଙ୍ଗାଗୋମର୍‌ ଜନଙ୍‌ଡେନ୍‌ ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ବତଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ସେଙ୍କେତେ, ଆରି ଆ ଗନିୟ୍‌ଗିୟ୍‌ଲୋଙନ୍‌ ଡରମ୍ମ କାବ୍ବାଡ଼ାଞ୍ଜି ଲୁମ୍‌ତେ, ପ୍ରବୁନ୍‌ ତି ଆ ମନ୍‌ରାଆଡଙ୍‌ ଜାତେ । ");
INSERT INTO juy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ଆମ୍ୱେଞ୍ଜି ଜନାଜି, ଅଙ୍ଗା ସନୟୁବର୍‌ ଇସ୍ୱରନ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆପ୍ପାୟ୍‌ଲାୟ୍‌, ତି ଆ ସନୟୁବର୍‌ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଅପ୍ପୁଙ୍‌ବରେନ୍‌; କେନ୍‌ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜି ଆ ପ୍ରବୁ । ");
INSERT INTO juy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ମନ୍‌ରାଞ୍ଜି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନେନ୍‌ ଆସନ୍‌ ଡ ତବ୍ବୁବ୍‌ଡାନେନ୍‌ ଆସନ୍‌ ଆବର୍ରେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଉଲନ୍‌ ସମ୍ପରା ଇସ୍ରାଏଲ୍‌ ଡେସାଲୋଙନ୍‌ ଇନିଜି ଇନିଜି ଡେଏନ୍‌ ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆମ୍ୱେଞ୍ଜି ଜନାଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ଇସ୍ୱରନ୍‌ ଏଙ୍ଗାଲେ ନାଜରିତବାୟ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡ ବୋର୍ସାନ୍‌ ବାତ୍ତେ ଅବିସେକଏନ୍‌ ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଜନାଜି; ଆନିନ୍‌ ସମ୍ପରାନ୍‌ ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ସୋଡ଼ା ସୋଡ଼ା ସାନ୍ନି କାବ୍ବାଡ଼ାଞ୍ଜି ଲୁମେନ୍‌, ସନୁମନ୍‌ ଆସୁମ୍‌ସୁମନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ମବ୍‌ନଙେନ୍‌, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ଆରି, ଆନିନ୍‌ ଜିଉଦା ଡେସାନ୍‌ ଡ ଜିରୁସାଲମନ୍‌ ଇନିଜି ଅଡ଼୍‌କୋନ୍‌ ଲୁମେନ୍‌, ତିଆତେଜି ଆସନ୍‌ ଇନ୍‌ଲେନ୍‌ ସାକିନ୍‌ ଏତିୟ୍‌ତାୟ୍‌; ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଜିସୁ କ୍ରିସ୍ଟନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙ୍‌ଲୋଙନ୍‌ ତାଙ୍‌ଲେ ରବ୍ବୁଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ୟାଗି ଡିନ୍ନାଲୋଙ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଅବ୍‌ୟର୍ମେଙେନ୍‌ କି ଅବ୍‌ରାଙ୍‌ଡାଏନ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ଅଡ଼୍‌କୋ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଆନିନ୍‌ ଅଃନ୍ନବ୍‌ରାଙ୍‌ଡାଲନ୍‌, ଆର୍ପାୟ୍‌ ଇସ୍ୱରନ୍‌ ଆମ୍ମୁଙ୍‌ ଆସ୍ରେଡାଏନ୍‌ ଆ ସାକିମର୍‌ଜି ଆମଙ୍‌ ତୁମ୍‌ ଆନିନ୍‌ ଅବ୍‌ରାଙ୍‌ଡାଲନ୍‌; ଆନିନ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ୟର୍ମେଙ୍‌ଲେ ଆଡ୍ରୋଲନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଇନ୍‌ଲେନ୍‌ ଆନିନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଏଗାଲାୟ୍‌ ଏଜୋମ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ଆରି ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଆସନ୍‌, ଆରବୁମରଞ୍ଜି ଡ ଆମେଙ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଅନବ୍‌ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ତବ୍‌ନଙେନ୍‌ ଗାମ୍‌ଲେ ସାକିନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ବର୍ରଲେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ଆନା ଜିସୁନ୍‌ ଆମଙ୍‌ ଡର୍ତନେ, ଆନିନ୍‌ ଆଞୁମ୍‌ଲୋଙନ୍‌ ଇର୍ସେନ୍‌ ସିଲଡ୍‌ କେମାନ୍‌ ଞାଙ୍‌ତେ, ଗାମ୍‌ଲେ ଅଡ଼୍‌କୋ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆନିନ୍‌ ଆସନ୍‌ ସାକିନ୍‌ ତିୟେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପିତ୍ରନ୍‌ ଏନ୍ନେଲେ ଞନଙନ୍‌ ଆତ୍ରିୟେନ୍‌ ଆଡିଡ୍‌ ଡିଅଙ୍ଗା ମନ୍‌ରା ତେତ୍ତେ ବର୍ନେନ୍‌ ଅମ୍‌ଡଙେଞ୍ଜି, ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ପଡ୍‌ଲନାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ଏର୍‌ଜିଉଦିମରଞ୍ଜି ନିୟ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ତନିୟ୍‌ତିୟ୍‌ ଆଞ୍ରାଙେଞ୍ଜିଆତେ ଗିୟ୍‌ଲେ ଜାପୋନ୍‌ ସିଲଡ୍‌ ପିତ୍ରନ୍‌ ସରିନ୍‌ ଆରିୟ୍‌ଲାଞଞ୍ଜି ଆଗବ୍‌ରେଡଞ୍ଜି ଆ ଡର୍ନେମର୍‌ଜି ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିଞ୍ଜି ଆନ୍ନା ଆନ୍ନା ଲଙ୍‌ଲଙ୍‌ ବାତ୍ତେ ଆକ୍ରଡାଡ଼ିଲଞ୍ଜି ଡ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଆସ୍ରେଙ୍କେଏନ୍‌ଆତେ ଆନିଞ୍ଜି ଗିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ତିଆଡିଡ୍‌ ପିତ୍ରନ୍‌ ଗାମେନ୍‌, “ଇନ୍‌ଲେନ୍‌ ଅନ୍ତମ୍‌ କେନ୍‌ ଆ ମନ୍‌ରାଜି ନିୟ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଞାଙେଞ୍ଜି, ତବ୍ବୁବ୍‌ଡାନ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଆନ୍ନିଙ୍‌ ଇନି ଆନିଞ୍ଜିଆଡଙ୍‌ ଡଙ୍‌ଲେ ରପ୍ତିଏଜି ପଙ୍‌ ?” ");
INSERT INTO juy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ଆରି, ଆନିନ୍‌ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି । ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଆରି ଅସୋୟ୍‌ ଡିନ୍ନା ଆନିଞ୍ଜି ବୟନ୍‌ ଡକୋନେନ୍‌ ଆସନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ରଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ଏର୍‌ଜିଉଦିମରଞ୍ଜି ନିୟ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଜାଏଞ୍ଜି, ଗାମ୍‌ଲେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଡ ଜିଉଦା ଡେସାନ୍‌ ଆ ଡର୍ନେମର୍‌ଜି ଜନାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ବନ୍‌ଡ, ପିତ୍ରନ୍‌ ଜିରୁସାଲମନ୍‌ ଆଜିର୍ରାଞନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆଗବ୍‌ରେଡନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ଆନିନ୍‌ଆଡଙ୍‌ ନିଣ୍ଡୟ୍‌ଡାଲେ ବର୍ରଞ୍ଜି, ");
INSERT INTO juy_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ଆମନ୍‌ ଏର୍‌ଗନବ୍‌ରେଡନ୍‌ ଆ ମନ୍‌ରାଜି ଆସିଂ ଇୟେନ୍‌, ଆରି ଆମନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଇୟ୍‌ଲେ ଗାଗାନେ ।” ");
INSERT INTO juy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ଆରି, ଆମ୍ମୁଙ୍‌ ମା ସିଲଡ୍‌ ଇନିଜି ଇନିଜି ଡେଏନ୍‌, ତି ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ପିତ୍ରନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବନରନ୍‌ ଆସନ୍‌ ଉଲନେ; ");
INSERT INTO juy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ଞେନ୍‌ ଜାପୋ ଗଡ଼ାଲୋଙନ୍‌ ଡକୋଡାଲନ୍‌ ପାର୍ତନାଲନାୟ୍‌, ତିଆଡିଡ୍‌ ଞେନ୍‌ ମୁର୍ସାଲିଁୟ୍‌ କି ଅବୟ୍‌ ତନାଲ୍‌ମଡନ୍‌ ଗିୟ୍‌ଲାୟ୍‌, ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ସୋଡ଼ାଡମ୍‌ ଆ ମାଟ ଉଞ୍ଜି ମନେଙନ୍‌ ଞମ୍‌ଲେ ଜାୟ୍‌ତାନ୍‌ ଆଜ୍ରବ୍‌ଲୟ୍‌ତାଞଞ୍ଜି ଅନ୍ତମ୍‌ ଇନିଜିତ୍ତି ଅମଙ୍‌ଞେନ୍‌ ଅଡ଼ୋଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ଆରି ତିଆତେ ଅମଙ୍‌ଞେନ୍‌ ଜାୟ୍‌ ଅଡ଼ୋଲାୟ୍‌; ଞେନ୍‌ ତିଆତେ ଆସନ୍‌ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଗିୟ୍‌ଲେ ଇୟମ୍‌ଲାୟ୍‌ ଆରି ତେତ୍ତେ ପୁର୍ତିଲୋଙନ୍‌ ଉଞ୍ଜି ଆଜଙନ୍‌ ଆ ଜନ୍ତୁଜି, କିନ୍‌ରେଙ୍‌ ଜନ୍ତୁଞ୍ଜି, ଆ କିମ୍ପୋଙଞ୍ଜି ଲବନ୍‌ ଅବ୍‌ଜାବ୍‌ଲେ ଆତ୍ରଙିୟ୍‌ତଞ୍ଜି ଆ ଜନ୍ତୁଜି ଡ ରୁଆଙନ୍‌ ଆ ଅନ୍ତିଡ୍‌ଜି ଗିୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ଆରି, ‘ଏ ପିତ୍ର, ଡୋନା, କେନ୍‌ଆତେଜି ରବ୍ବୁଡାଲେ ଜୋମା ।’ କେନ୍‌ ଏନ୍ନେଲେ ଞେନ୍‌ଆଡଙ୍‌ ଆବର୍ରିଞଞ୍ଜି ଆ ସର୍ରଙ୍‌ ନିୟ୍‌ ଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ବନ୍‌ଡ ଞେନ୍‌ ଗାମ୍‌ଲାୟ୍‌, ‘ଇଜ୍ଜା, ପ୍ରବୁ, ଏର୍‌ମଡ଼ିର୍‌ ଜନୋମ୍‌ଜୋମଞ୍ଜି ଡ ମନଙ୍‌ତଡନ୍‌ ଆ ଜନୋମ୍‌ଜୋମ୍‌ଜି ତଅଡ୍‌ଲୋଙ୍‌ଞେନ୍‌ ଆଙ୍ଗିୟ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଗନେ ।’ ");
INSERT INTO juy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ବନ୍‌ଡ ରୁଆଙନ୍‌ ସିଲଡ୍‌ ଆରି ବତର ଅବୟ୍‌ ଜନାଲଙନ୍‌ ଅଡ଼ୋଲାୟ୍‌, ‘ଇସ୍ୱରନ୍‌ ଅଙ୍ଗାତେ ମବ୍‌ଡ଼ିରେନ୍‌, ତିଆତେ ଆମନ୍‌ ମଡ଼ିର୍‌ ତଡ୍‌ ଗାମ୍‌ଡଙ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","କେନ୍‌ ଅନ୍ତମ୍‌ ୟାଗି ତର ଡେଏନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଆରି ରୁଆଙନ୍‌ ଆବ୍‌ଡିଡେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ଆରି ଗିୟ୍‌ବା, ଞେନ୍‌ ଅଙ୍ଗାସିଂ ଡକୋଲନାୟ୍‌, ସିଲତ୍ତେମା ତେରଙ୍‌ ୟାଗି ମନ୍‌ରା ତେତ୍ତେ ଅଡ଼ୋଲାଜି, ଆନିଞ୍ଜିଆଡଙ୍‌ କାଇସରିଆନ୍‌ ସିଲଡ୍‌ ଅମଙ୍‌ଞେନ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ଆରି, ଇନ୍ନିଙ୍‌ ଏର୍‌ଡାଲ୍‌ଗଡ୍‌ଲେ ତି ଆ ମନ୍‌ରାଜି ସରିନ୍‌ ଜନିରନ୍‌ ଆସନ୍‌ ପୁରାଡ଼ାନ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ବର୍ରିଁୟ୍‌ । ଆରି, କେନ୍‌ ଜାପୋ ଗଡ଼ାନ୍‌ ଆ ବୋଞାଙ୍‌ଜି ତୁଡ୍ରୁ ମନ୍‌ରା ନିୟ୍‌ ଞେନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ କାଇସରିଆ ଗଡ଼ାନ୍‌ ଏଜିରେନ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଇନ୍‌ଲେଞ୍ଜି କର୍ନିଏଲନ୍‌ ଆସିଂ ଏତୁଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ଆନିନ୍‌ ଏଙ୍ଗାଲେ ଅବୟ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ଆଡଙ୍‌ ଗିଜେନ୍‌, ତି ଆ ବର୍ନେ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ବର୍ରଲେନ୍‌, ତି ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅମ୍ମସିଙନ୍‌ ତନଙ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, ‘ଜାପୋ ଗଡ଼ାନ୍‌ ମନ୍‌ରାନ୍‌ ଆପ୍ପାୟ୍‌ଲେ ସିମନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଅବ୍‌ନୋଡ୍ଡେଲେ ଓରୋଙାୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ଆନିନ୍‌ ଜିର୍ରେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ଇୟ୍‌ତାୟ୍‌ ତିୟ୍‌ବେନ୍‌, ଆରି ତି ଆ ଞନଙ୍‌ ବାତ୍ତେ ଆମନ୍‌, ଡ ଅସିଂନମ୍‌ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋନ୍‌ବେନ୍‌ ଅନୁରନ୍‌ ଏଞାଙ୍‌ତେ ।’ ");
INSERT INTO juy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞେନ୍‌ ବର୍ନେନ୍‌ ଅରୁଲନାଞନ୍‌ ଆଡିଡ୍‌ ଆମ୍ମୁଙ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଏଙ୍ଗାଲେ ଡଅଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ପଡ୍‌ଲନାୟ୍‌, ଏତ୍ତେଲେମା ଆ ଡଅଙ୍‌ଲୋଙଞ୍ଜି ନିୟ୍‌ ଇୟ୍‌ଲାୟ୍‌ ପନ୍ନେ । ");
INSERT INTO juy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ତିଆଡିଡ୍‌ ପ୍ରବୁନ୍‌ ଆ ବର୍ରନ୍‌ ଆ ବର୍ନେ କେନ୍‌ଆତେ ଞେନ୍‌ ମନ୍ନେଲାୟ୍‌, ‘ଆଜାଡ଼ିଡମ୍‌, ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଡାଆଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ତିୟ୍‌ଲବେନ୍‌, ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ତବ୍ବୁବ୍‌ଡାନ୍‌ ଏଞାଙ୍‌ତେ ।’ ");
INSERT INTO juy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ତିଆସନ୍‌, ଇନ୍‌ଲେଞ୍ଜି ପ୍ରବୁ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆମଙ୍‌ ଏଡର୍ରନାଞନ୍‌ ଆଡିଡ୍‌ ଇସ୍ୱରନ୍‌ ଏଙ୍ଗାଲେ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ତନିୟ୍‌ତିୟଞ୍ଜି ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ଲନ୍‌, ଏତ୍ତେଲେମା ଇସ୍ୱରନ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ତି ଆ ତନିୟ୍‌ତିୟ୍‌ଜି ତିୟେଞ୍ଜି, ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଞେନ୍‌ ଆନା ଡ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ରଙ୍‌ଲେ ରପ୍ତିଆୟ୍‌ !” ");
INSERT INTO juy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","କେନ୍‌ ଆ ବର୍ନେଜି ଆରମ୍‌ଡଙେଞ୍ଜି ଆନିଞ୍ଜି ରିଙ୍‌ ଗାମ୍‌ଲେ ଡକୋଲଞ୍ଜି, କି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ସେଙ୍କେଲେ ବର୍ରଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଇସ୍ୱରନ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ନିୟ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିନେନ୍‌ ଆସନ୍‌ ଡ ଅନମେଙନ୍‌ ଆସନ୍‌ ରୟଙନ୍‌ ତିୟେଞ୍ଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ତିପାନନ୍‌ ଆ ରନବୁ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଡର୍ନେମରଞ୍ଜି ଡନଣ୍ଡାୟନ୍‌ ଆଞ୍ରାଙେଞ୍ଜି ଆନିଞ୍ଜି ପିରିଙ୍‌ପାଡାନ୍‌ ଡେଏଞ୍ଜି, ଆନିଞ୍ଜି ଲାଙ୍‌ଲେନ୍ନେ ପୈନିକିଆ, ସାଇପ୍ରସନ୍‌ ଆରି ଆନ୍ତିଅକିଆନ୍‌ ଜାୟ୍‌ ଜିରେଞ୍ଜି କି ବୁଲ୍ଲେ ବୁଲ୍ଲେଲେ ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ ତୁମ୍‌ ମନଙ୍‌ବରନ୍‌ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେଜି ଆରି ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ବର୍ନେନ୍‌ ଅଃନ୍ନପ୍ପୁଙ୍‌ବର୍ରଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ବନ୍‌ଡ ଆରି ଲାଙ୍‌ଲେନ୍ନେ ସାଇପ୍ରସ୍‌ମରଞ୍ଜି ଡ କୁରିଣିଅମରଞ୍ଜି ଅନ୍ତିଅକିଆ ଗଡ଼ାନ୍‌ ଜିର୍ରେ ଗ୍ରିକ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ନିୟ୍‌ ପ୍ରବୁ ଜିସୁନ୍‌ ଆ ମନଙ୍‌ବର୍‌ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ଆରି, ପ୍ରବୁନ୍‌ ଆ ବୋର୍ସା ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋଏନ୍‌, ଗୋଗୋୟ୍‌ଡମ୍‌ ମନ୍‌ରାଞ୍ଜି ଡର୍ରଞ୍ଜି କି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ୟର୍ରନାଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ତି ଆ କବର ଜିରୁସାଲମ୍‌ ମଣ୍ଡଡ଼ିନ୍‌ ଆ ମନ୍‌ରାଜି ଅମ୍‌ଡଙେଞ୍ଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ବର୍ନବାନ୍‌ଆଡଙ୍‌ ଅନ୍ତିଅକିଆ ଗଡ଼ାନ୍‌ ଜାୟ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ଆନିନ୍‌ ତେତ୍ତେ ତୁଙେନ୍‌ କି ତେତ୍ତେ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଇସ୍ୱରନ୍‌ ଏଙ୍ଗାଲେ ସାୟୁମେଞ୍ଜି ତିଆତେ ଗିୟ୍‌ଲେ ସର୍ଡାଡାଏନ୍‌, ଆରି ଆନିଞ୍ଜି ସମ୍ପରା ଉଗରନ୍‌ ବାତ୍ତେ ଡର୍ରନ୍‌ ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ଡକୋନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ଲେ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ବର୍ନବାନ୍‌ ଅବୟ୍‌ ମନଙ୍‌ମର୍‌, ଆରି ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡ ଡର୍ନେଲୋଙନ୍‌ ଆନିନ୍‌ ରଡୋଡମ୍‌ ଡକୋଏନ୍‌ । କେନ୍‌ ଏନ୍ନେଲେ ଜବ୍ର ମନ୍‌ରାଞ୍ଜି ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ମାୟ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ବର୍ନବାନ୍‌ ସାଓଲନ୍‌ଆଡଙ୍‌ ସନାୟ୍‌ଡଙନ୍‌ ଆସନ୍‌ ତାର୍ସ ଗଡ଼ାନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ଆରି, ବର୍ନବାନ୍‌ ସାଓଲନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲେ ରବାଙେ କି ଆନିନ୍‌ଆଡଙ୍‌ ଅନ୍ତିଅକିଆନ୍‌ ଓରୋଙ୍‌ଲାୟ୍‌ । ଆନିଞ୍ଜି ତେତ୍ତେ ବବର୍ସେଙ୍‌ ମଣ୍ଡଡ଼ିନ୍‌ ବୟନ୍‌ ମାୟ୍‌ଲନ୍‌ ଡକୋଡାଲନ୍‌ ଜବ୍ର ମନ୍‌ରାଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେଞ୍ଜି, ଆରି କେନ୍‌ ଅନ୍ତିଅକିଆ ଗଡ଼ାନ୍‌ ଆ ଡର୍ନେମର୍‌ଜିଆଡଙ୍‌ କ୍ରିସ୍ଟାନୁ ଗାମ୍‌ଲେ ପର୍ତମ୍ମୁ ବର୍ନେନ୍‌ ଡେଲୋ । ");
INSERT INTO juy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ତି ଆଡିଡ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ଅନ୍ତିଅକିଆନ୍‌ ଜିର୍ରାଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ଆନିଞ୍ଜିଲୋଙ୍‌ ସିଲଡ୍‌ ଆଗାବ ଗାମ୍‌ଲେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ତନଙ୍‌ଡାଲେ କେନ୍‌ ସମ୍ପରା ପୁର୍ତିନ୍‌ ଅବୟ୍‌ ସୋଡ଼ା କାନ୍ତାରାନ୍‌ ଅଡ଼ୋତାୟ୍‌ ଗାମ୍‌ଲେ ପୁରାଡ଼ାନ୍‌ ଆ ବୋର୍ସା ବାତ୍ତେ ପୁର୍ବାଃତେବରନ୍‌ ବର୍ରନେ; କ୍ଲାଉଦିଅ ସୋଡ଼ା ରାଜାନ୍‌ ଡେସାନ୍‌ ଆସ୍ରାସନଏନ୍‌ ଆଡିଡ୍‌ ତି ଆ ପୁର୍ବାଃତେବର୍‌ ଡେଡମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ସିଲତ୍ତେ ଅଡ଼୍‌କୋ ଞଙ୍‌ନେମରଞ୍ଜି ରମ୍ମଙ୍‌ ଆ ରନପ୍ତି ଅନ୍ତମ୍‌ ଜିଉଦା ଡେସାଲୋଙନ୍‌ ଆଡ୍ରକୋଲଞ୍ଜି ଡର୍ନେ ବୋଞାଙଞ୍ଜିଆଡଙ୍‌ ଏସାୟ୍‌ସିବାଜି ଗାମ୍‌ଲେ କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ଆରି ଆନିଞ୍ଜି ଏତ୍ତେଲେ ଡାବ୍ବୋନ୍‌ ତଣ୍ଡ୍ରବ୍‌ଡାଲନ୍‌ ତିଆତେ ବର୍ନବାନ୍‌ ଡ ସାଓଲନ୍‌ ଆସିଲୋଙ୍‌ ମଣ୍ଡଡ଼ିନ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମର୍‌ଜି ଆମଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ତିଆଡିଡ୍‌ ଏରୋଦ ରାଜାନ୍‌ ମଣ୍ଡଡ଼ିନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଡଣ୍ଡାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ଆନିନ୍‌ ଜନନ୍‌ ଆ ବୋଞାଙ୍‌ ଜାକୁବନ୍‌ଆଡଙ୍‌ କଡ଼ିବନ୍‌ ବାତ୍ତେ ରବ୍ବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ସିଲତ୍ତେ ଜିଉଦିମରଞ୍ଜି ସର୍ଡାଏଞ୍ଜି, ତିଆସନ୍‌ ଏରୋଦ ରାଜାନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ନିୟ୍‌ ଞମ୍‌ଞମନ୍‌ ଆସନ୍‌ ଏରେନ୍‌ ଗୋଜେନ୍‌ । ତିଆଡିଡ୍‌ କମିରନ୍‌ ଏର୍‌ମନାୟ୍‌ ରୁଟିନ୍‌ ଆ ପୁର୍ପୁର୍‌ ଡିନ୍ନା ଡକୋଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଜିଲେ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକ୍କୋଏନ୍‌, ଆରି, ବଡଡ଼ଲୋଙନ୍‌ ଉଞ୍ଜି ମନ୍‌ରା ସିପ୍ପାୟଞ୍ଜି ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଜଗେଏଞ୍ଜି । ଅନେଲାୟ୍‌ପୁରନ୍‌ ସାଡ୍‌ଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଓରୋଙ୍‌ଡାଲେ ଅନବ୍‌ପନ୍‌ସୁଆତିନ୍‌ ଆସନ୍‌ ଏତ୍ତେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ତିଆସନ୍‌, ପିତ୍ରନ୍‌ ବଣ୍ଡିସିଂଲୋଙନ୍‌ ଡକ୍କୋଏଞ୍ଜି, ବନ୍‌ଡ ମଣ୍ଡଡ଼ିନ୍‌ ଆ ମନ୍‌ରାଜି ଆବମନ୍ନନ୍‌ ଏମ୍ମେଲନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ପାର୍ତନାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ତିକ୍କି ଏରୋଦ ରାଜାନ୍‌ ଅଙ୍ଗାଡିନ୍ନା ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବଣ୍ଡିସିଙନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ଅନୋରୋଙନ୍‌ ଆସନ୍‌ ଇୟେନ୍‌, ତି ଆ ପୁର୍ବା ତଗଲ୍‌ ପିତ୍ରନ୍‌ ବାଗୁ ସିପ୍ପାୟଞ୍ଜି ଆ ମଡ୍ଡି ଆଲୁଡ୍‌ଲୁଡ୍‌ ଡକୋଲନ୍‌, ଆନିନ୍‌ ବାଗୁ ସିଙ୍କୁଡ଼ିନ୍‌ ବାତ୍ତେ ଆଜିଜି ଡକୋଏନ୍‌, ଆରି ବଣ୍ଡିସିଙନ୍‌ ଆ ସନଙ୍‌ଲୋଙ୍‌ ସିପ୍ପାୟଞ୍ଜି ଜଗେଲେ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ଆରି ଗିୟ୍‌ବା, ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ଇୟ୍‌ଲାୟ୍‌, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଅସିଙନ୍‌ ସାଆର୍‌ଡମ୍‌ ଡେଏନ୍‌, ଆରି ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ପିତ୍ରନ୍‌ ଆ ପକ୍କାଲୋଙ୍‌ ଞମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ତର୍ତର୍ରେ ବରେନ୍‌, “ଲଡୋନା ।” ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ଆସିଲୋଙ୍‌ ସିଲଡ୍‌ ସିଙ୍କୁଡ଼ିନ୍‌ ଜଲଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ଆରି, ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ରେଡ୍ଡୁବ୍‌ନା, ପାଣ୍ଡୋୟନ୍‌ ରନା ।” ସିଲତ୍ତେ ପିତ୍ରନ୍‌ ରେଡ୍ଡୁବ୍‌ଲନ୍‌, ପାଣ୍ଡୋୟନ୍‌ ରଲନ୍‌; ଆରି ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ପିତ୍ରନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “କୋଟନ୍‌ ରନା ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞେନ୍‌ ସଣ୍ଡୋଙିୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ଆରି ପିତ୍ରନ୍‌ ଡୁଙ୍‌ଲନ୍‌ କି ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେନ୍‌; ବନ୍‌ଡ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ଆର୍‌ଲୁମେନ୍‌ଆତେଜି ମାଲମ୍ମି ଗାମ୍‌ଲେ ପିତ୍ରନ୍‌ ଅଃଜ୍ଜନାଲୋ, ଆନିନ୍‌ କେନ୍‌ଆତେ ଞେନ୍‌ ଗନୁମ୍‌ତେନ୍‌ ଗିୟ୍‌ତାୟ୍‌ ଗାମ୍‌ଲେ ଅବ୍‌ଡିସୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ଆନିଞ୍ଜି ପର୍ତମ୍ମୁ ଆରି ବାଗୁ ଜଗେଡିଁୟ୍‌ମରଞ୍ଜି ପଡ୍‌ଲେ, ଆତନିକ୍କି ଗରନ୍ନେନ୍‌ ଗଡ଼ାନ୍‌ ଆଜିର୍‌ଗଡ୍‌ତବନ୍‌ ଆ ଲୋଆଙ୍‌ ସନଙ୍‌ଲୋଙ୍‌ ଅଡ଼ୋଲାଜି, ଆନିଞ୍ଜି ଆସନ୍‌ ତି ଆ ସନଙ୍‌ ଆନିନ୍‌ଡମ୍‌ ରୋଲନେ, ଆରି ଆନିଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି କି ଅବୟ୍‌ ତଙର୍‌ଗଡ୍‌ ତଙିୟ୍‌ଲନ୍‌ ଜିରେଞ୍ଜି, ଆରି ସିଲତ୍ତେ ଅବ୍‌ତାଡ଼ନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ ପିତ୍ରନ୍‌ ଆମଙ୍‌ ସିଲଡ୍‌ ସବ୍‌ଙାୟ୍‌ଡାଲନ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ସିଲତ୍ତେ ଇନିଜି ଡେଏନ୍‌, ପିତ୍ରନ୍‌ ତିଆତେଜି ଜନାଡାଲେ ବର୍ରନେ, “କେନ୍‌ଆତେ ମାଲମ୍ମିଡମ୍‌ ଗାମ୍‌ଲେ ଞେନ୍‌ ନମିଞେନ୍‌ ଜନାଲିଁୟ୍‌ । ଏରୋଦନ୍‌ ଆସିଲୋଙ୍‌ ସିଲଡ୍‌, ଆରି ଇନିଜି ଡେତେ ଗାମ୍‌ଲେ ଜିଉଦିମରଞ୍ଜି ଅଡ଼୍‌କୋନ୍‌ ଆସାଲଞ୍ଜି, ତେତ୍ତେ ସିଲଡ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ଅନୁରନ୍‌ ଆସନ୍‌ ପ୍ରବୁନ୍‌ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମରନ୍‌ଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାୟ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ଆନିନ୍‌ କେନ୍‌ ଏନ୍ନେଲେ କଡାଡ଼ିଲନ୍‌ କି ଜନନ୍‌ ଆ ନନ ଆସିଂ ଜିର୍ରାୟ୍‌; ତେତ୍ତେ ଜବ୍ର ମନ୍‌ରା ରୁକ୍କୁଡାଲନ୍‌ ପାର୍ତନାଲଞ୍ଜି; କେନ୍‌ ଜନନ୍‌ଆଡଙ୍‌ ମାର୍କ ଗାମ୍‌ଲେ ନିୟ୍‌ ଓଡ୍ଡେତଜି । ");
INSERT INTO juy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ପିତ୍ରନ୍‌ ଡୁଆରାନ୍‌ ଆ ସନଙ୍‌ଲୋଙ୍‌ ଇୟ୍‌ଲେ ଡେବ୍‌ଡେବେନ୍‌, ରୋଦା ଗାମ୍‌ଲେ ଅବୟ୍‌ କମ୍ୱାରିସିଜନ୍‌ ସନଙନ୍‌ ରୋରୋବାନ୍‌ ଇୟ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ଆନିନ୍‌ ପିତ୍ରନ୍‌ ଆ ସର୍ରଙ୍‌ ଜନାଡାଲେ ସର୍ଡାନ୍‌ ବାତ୍ତେ ସନଙନ୍‌ ଅଃର୍ରୋଲୋ, ଆରି ଅମ୍ମନ୍‌ ଇରେନ୍‌ କି “ସନଙନ୍‌ ଆ ଡୁଆରାଗଡ୍‌ ପିତ୍ରନ୍‌ ଆତନଙ୍‌,” ଗାମ୍‌ଲେ ଇୟ୍‌ଲେ ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ଆନିଞ୍ଜି ଆନିନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି, “ଆମନ୍‌ ବାଇତମ୍‌ ।” ବନ୍‌ଡ କେନ୍‌ଆତେ ଆଜାଡ଼ିନ୍‌ ଗାମ୍‌ଲେ ଆନିନ୍‌ ଆକ୍ରାନ୍‌ ବର୍ରନେ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଗାମେଞ୍ଜି, “ଏତ୍ତେଲ୍‌ଡେନ୍‌ କେନ୍‌ଆତେ ପିତ୍ରନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅଲ୍‌ଡେଏ ।” ");
INSERT INTO juy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ତିଆଡିଡ୍‌ ପିତ୍ରନ୍‌ ନମିନ୍‌ ନମିନ୍‌ ସନଙ୍‌ଲୋଙନ୍‌ ଡେବ୍‌ଡେବ୍‌ଲଏନ୍‌, ଆରି ଆନିଞ୍ଜି ସନଙନ୍‌ ରୋଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଗିୟ୍‌ଲେ ସାନ୍ନି ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ଆରି, କଡ଼ିଙ୍‌ଲେ ଡକୋନେନ୍‌ ଆସନ୍‌ ପିତ୍ରନ୍‌ ଆସିନ୍‌ ବାତ୍ତେ ଆନିଞ୍ଜିଆଡଙ୍‌ ତାରିଆୟ୍‌ଏଞ୍ଜି, ପ୍ରବୁନ୍‌ ଏଙ୍ଗାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ବଣ୍ଡିସିଙନ୍‌ ସିଲଡ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ଓରୋଙ୍‌ଲାୟ୍‌, ତି ଆ ବର୍ନେଜି ଆମଙଞ୍ଜି ବରାୟ୍‌ଲନ୍‌ । ଆରି ଆନିନ୍‌ ଗାମେନ୍‌, “କେନ୍‌ ଆ ବର୍ନେଜି ଜାକୁବନ୍‌ ଡ ଡର୍ନେ ବୋଞାଙଞ୍ଜିଆଡଙ୍‌ ବର୍ବାଜି ।” ଆନିନ୍‌ ତେତ୍ତେ ସିଲଡ୍‌ ଆନ୍ନାରେଙ୍‌ ଜିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ଆତ୍ରଗାଡେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପିତ୍ରନ୍‌ ଅଡ଼େଙ୍ଗା ଜିରେନ୍‌ ଗାମ୍‌ଲେ ସିପ୍ପାୟଞ୍ଜି ୟୋଙ୍‌ୟାଙ୍‌ଲଗୋ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ପିତ୍ରନ୍‌ଆଡଙ୍‌ ସନାୟ୍‌ଡଙନ୍‌ ଆସନ୍‌ ଏରୋଦ ରାଜାନ୍‌ ସିପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି, ବନ୍‌ଡ ଆନିଞ୍ଜି ପିତ୍ରନ୍‌ଆଡଙ୍‌ ଅଃର୍ରବାଙ୍‌ଲଜି; ତିଆସନ୍‌ ଆନିନ୍‌ ସିପ୍ପାୟଞ୍ଜିଆଡଙ୍‌ ସେକ୍କୁଏଞ୍ଜି କି ଆନିଞ୍ଜିଆଡଙ୍‌ ରବ୍ବୁବା ଗାମ୍‌ଲେ ବରେଞ୍ଜି । ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଏରୋଦନ୍‌ ଜିଉଦା ଡେସାନ୍‌ ସିଲଡ୍‌ କାଇସରିଆ ଡେସାନ୍‌ ଜିର୍ରେ ତେତ୍ତେ ଇୟ୍‌ଲେ ଡକୋନେ । ");
INSERT INTO juy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ତିଆଡିଡ୍‌ ଏରୋଦ ରାଜାନ୍‌ ସୋର ଡେସାନ୍‌ ଡ ସିଦୋନ ଡେସାନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ମାଡ୍ଡ ବରାବେନ୍‌, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଏକ୍କାନ୍‌ ଏମ୍ମେଡାଲନ୍‌ ଏରୋଦ ରାଜାନ୍‌ ଆମଙ୍‌ ଇୟ୍‌ଲାଜି କି ରାଜାସିଙନ୍‌ ଆକ୍ରାବ୍ବାଡ଼ାତନେନ୍‌ ଆ ମନ୍‌ରା ବ୍ଲାସ୍ତନ୍‌ଆଡଙ୍‌ ଆଡନେଗଡଞ୍ଜି ଇୟ୍‌ଲାୟ୍‌ ଏମ୍ମେଏଜି; ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ମାୟ୍‌ମାୟ୍‌ନେନ୍‌ ଆସନ୍‌ ରାଜାନ୍‌ ଆମଙ୍‌ କଡାଡ଼ିନେବାନ୍‌ ଇୟେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଏରୋଦ ରାଜାନ୍‌ ଆ ଡେସା ସିଲଡ୍‌ ଜନୋମ୍‌ଜୋମଞ୍ଜି ସୋର ଡେସାନ୍‌ ଡ ସିଦୋନ ଡେସାନ୍‌ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ବଡିନ୍ନା ଏରୋଦ ରାଜାନ୍‌ ରାଜାକାବନ୍‌ ରଲନ୍‌ କି ରାଜା ତରଙ୍କୁମ୍‌ଲୋଙନ୍‌ ତଙ୍କୁମ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଅବୟ୍‌ ବାସଣନ୍‌ ତିୟେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ସିଲତ୍ତେ ମନ୍‌ରାଞ୍ଜି ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “କେନ୍‌ଆତେ ତ ଇସ୍ୱରନ୍‌ ଆ ସର୍ରଙ୍‌, ମନ୍‌ରାନ୍‌ ଆ ସର୍ରଙ୍‌ ତଡ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ଅବ୍‌ତାଡ଼ନ୍‌ ପ୍ରବୁନ୍‌ ଆ ପାଙ୍‌ଲଙ୍‌ବର୍‌ମର୍‌ ଅବୟ୍‌ନେ ଏରୋଦନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତିଡେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଅଃସେଙ୍କେଲୋ, ତିଆସନ୍‌ ଆନିନ୍‌ ବୋବ୍ବୋଡେନ୍‌ କି ରବୁଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଗୋଗୋୟ୍‌ଲେ ପାଙେନ୍‌ କି ସମ୍ପରାନ୍‌ ତୁଙାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ତିକ୍କି, ସାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ସେବା କାବ୍ବାଡ଼ାଞ୍ଜି ସାଡେଞ୍ଜି କି ମାର୍କ ଗାମ୍‌ଲେ ଆରୋଡ୍ଡେତେଞ୍ଜି ଜନନ୍‌ ସରିନ୍‌ ଆନିଞ୍ଜି ଜିରୁସାଲମନ୍‌ ସିଲଡ୍‌ ୟର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ତିଆଡିଡ୍‌ ଅନ୍ତିଅକିଆ ମଣ୍ଡଡ଼ିଲୋଙନ୍‌ ବର୍ନବାନ୍‌, ସିମନନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ନିଗର ଗାମ୍‌ଲେ ଓଡ୍ଡେତଜି, କୁରିଣିବାୟ୍‌ ଲୁକିଅନ୍‌, ଏରୋଦ ରାଜାନ୍‌ ଆସିଂ ଆଡ୍ରକୋଲନ୍‌ ମନଏମନ୍‌ ଡ ସାଓଲନ୍‌, କେନ୍‌ ଅନ୍ତମ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଡ ଞନଙ୍‌ତିୟ୍‌ମରଞ୍ଜି ଡକୋଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ଆନିଞ୍ଜି ପ୍ରବୁନ୍‌ ଆସ୍ରେନ୍‌ପୁରେଞ୍ଜି ଆଡିଡ୍‌ ଡ ଆରାନମ୍‌ଲଞ୍ଜି ଆଡିଡ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ବର୍ରନେ, “ଅଙ୍ଗା କାବ୍ବାଡ଼ା ଆସନ୍‌ ଞେନ୍‌ ସାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ଓଡ୍ଡେଲାଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଆନ୍ନାବାଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ସିଲତ୍ତେ ଆନିଞ୍ଜି ସାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ଆ ଡଅଙ୍‌ଲୋଙ୍‌ ଆସିଞ୍ଜି ଡକ୍କୋଡାଲେ ଆନମ୍‌ଡାଲନ୍‌ ପାର୍ତନାଲଞ୍ଜି କି ଆନିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","କେନ୍‌ ଏନ୍ନେଲେ ସାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଆ ବର୍ନେ ବାତ୍ତେ ଆପ୍ପାୟ୍‌ଡାଲେ ସେଲୁକିଆ ଡେସାନ୍‌ ଜିରେଞ୍ଜି, କି ତେତ୍ତେ ସିଲଡ୍‌ ଆନିଞ୍ଜି ଜାଜଲୋଙନ୍‌ ଡାୟ୍‌ଲେ କୁପ୍ର ଡେସାନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ଆନିଞ୍ଜି ସାଲାମି ଗଡ଼ାନ୍‌ ଆତ୍ରୁଙେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ରନୁକ୍କୁସିଂରେଙ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେଜି; ଆରି ଜନନ୍‌ ନିୟ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋଡାଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ସାଜଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ଆରି, ଆନିଞ୍ଜି ମଡ୍ଡି ସମେଁୟ୍‌ଣ୍ଡ୍ରାଲୋଙନ୍‌ ଡକୋନ୍‌ ଆ ଡେସାଜି ଅଡ଼୍‌କୋନ୍‌ ବୁଲ୍ଲେଡାଲେ ପାପୋ ଗଡ଼ାନ୍‌ ଜିର୍ରାଜି, ତେତ୍ତେ ଆନିଞ୍ଜି ଅବୟ୍‌ ତନେୟ୍‌ମରନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରବାଙେଜି, ଆନିନ୍‌ ଅବୟ୍‌ କଣ୍ଡାୟ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମର୍‌, ଆନିନ୍‌ ଜିଉଦିମର୍‌, ଆଞୁମନ୍‌ ବର୍‌ଜିସୁ । ");
INSERT INTO juy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ଆନିନ୍‌ ତେତ୍ତେ ଆ ରାଜ୍ୟପାଡ଼ ସେର୍ଗିୟ ପାଓଲନ୍‌ ସରିନ୍‌ ସାଙ୍ଗ ଡକୋଲଞ୍ଜି, ଆରି ତି ଆ ରାଜ୍ୟପାଡ଼ ଅବୟ୍‌ ବୁଡ୍ଡିମର୍‌ । ଆନିନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅନମ୍‌ଡଙନ୍‌ ସାଜେନ୍‌ । ତିଆସନ୍‌ ସାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ଆଡଙ୍‌ ଓଡ୍ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ବନ୍‌ଡ ତି ତନେୟ୍‌ମର୍‌ ଅଲ୍ଲିମାନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ରଙେଞ୍ଜି, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ରାଜ୍ୟପାଡ଼ନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଡର୍‌ଡଙ୍‌ନେ ତଡ୍‌ ଗାମ୍‌ଲେ ଆଙ୍‌ସାଲେ ଆଡନକ୍କୋ ଆସନ୍‌ ଏରେନ୍‌ ଗୋଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ବନ୍‌ଡ ସାଓଲନ୍‌, ଆନିନ୍‌ଆଡଙ୍‌ ପାଓଲ ନିୟ୍‌ ଗାମ୍‌ତଜି, ଆନିନ୍‌ ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ବରିୟ୍‌ଡାଲେ ତି ତନେୟ୍‌ମରନ୍‌ଆଡଙ୍‌ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙେନ୍‌ କି ବର୍ରନେ, ");
INSERT INTO juy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ଏ ସନୁମନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ! ଅଡ଼୍‌କୋ ମନଙ୍‌ କାବ୍ବାଡ଼ାଞ୍ଜି ଆମନ୍‌ ଡଙ୍‌ତେ, ଏର୍‌ମନଙନ୍‌ ଡ କନଣ୍ଡାୟଞ୍ଜି ଅମଙ୍‌ନମ୍‌ ଆବରିୟ୍‌, ଆଏଡ଼ର୍‌ ଆମନ୍‌ ପ୍ରବୁନ୍‌ ଆ ତଙର୍‌ କଣ୍ଡାୟ୍‌ ଗାମ୍‌ଲେ ବର୍ନେନ୍‌ ଆସନ୍‌ ଏର୍‌ତେ ଗୋୟ୍‌ତେ ! ");
INSERT INTO juy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ଆରି ନମିଞେନ୍‌ ଗିଜା, ପ୍ରବୁନ୍‌ ଆସିଲୋଙ୍‌ ସିଲଡ୍‌ ଡନଣ୍ଡାୟନ୍‌ ଞାଙ୍‌ତେ, ଆମନ୍‌ ଗଡ୍ଡେଃ ଆସନ୍‌ କାଡ଼ୁତମ୍‌, ଆମନ୍‌ ଓୟୋଙନ୍‌ ଆ ସନାଆର୍‌ ଗିୟ୍‌ଲେ ଅଃର୍ରପ୍ତିଏ ।” ସିଲତ୍ତେ ଅବ୍‌ତାଡ଼ନ୍‌ ପୋୟ୍‌ଡାନ୍‌ ଡ ଲୋଙଡନ୍‌ ଅଲ୍ଲିମାନ୍‌ଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ରୁବେ, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ କାଡ଼ୁଏନ୍‌, ତିଆସନ୍‌ ଆସିନ୍‌ ଞମ୍‌ଲେ ଆନିନ୍‌ଆଡଙ୍‌ ତନୁରିୟନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ ଅଡ଼େତ୍ତେ ଅଡ଼େନ୍ନେ ଆସାୟ୍‌ଲଗୋ ମନ୍‌ରାନ୍‌ ସାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ଏତ୍ତେଗନ୍‌ ଆଡ୍ରେଏନ୍‌ଆତେ ଗିୟ୍‌ଲେ ରାଜ୍ୟପାଡ଼ନ୍‌ ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ଡର୍ରନେ, ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଆନିନ୍‌ ପ୍ରବୁନ୍‌ ଆ ଞନଙ୍‌ ଅମ୍‌ଡଙ୍‌ଲେ ସାନ୍ନି ଡେଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ତିକ୍କି ପାଓଲନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ପାପୋ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଡାଆ ଜାଜଲୋଙନ୍‌ ଜିର୍ରେ ପମ୍ପୁଲିଆ ଡେସାନ୍‌ ପର୍ଗି ଗଡ଼ାନ୍‌ ଜିର୍ରାଜି; ବନ୍‌ଡ ଜନନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ରେଙ୍‌ଡାଲେ ଜିରୁସାଲମନ୍‌ ୟର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ଆନିଞ୍ଜି ପର୍ଗି ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଜିରେଞ୍ଜି କି ପିସିଦିଆ ଡେସାନ୍‌ ଆ ଗଡ଼ା ଅନ୍ତିଅକିଆ ଗାମ୍‌ଲେ ତେତ୍ତେ ଅଡ଼ୋଏଞ୍ଜି, ଆରି ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ରନୁକ୍କୁସିଙନ୍‌ ଜିର୍ରେ ଇୟ୍‌ଲେ ତଙ୍କୁମେଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ଆରି, ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଡ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ସାସ୍ତ୍ର ପଡ଼େନେନ୍‌ ଆସ୍ରୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ରନୁକ୍କୁସିଙନ୍‌ ଆ ସୋଡ଼ାମର୍‌ଜି ପାଓଲନ୍‌ ଡ ଆ ଗଡ଼ିଞ୍ଜି ଆମଙ୍‌ ଏନ୍ନେଲେ ବର୍ରେ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି, “ଏ ବୋଞାଙ୍‌ଜି, ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ଆନ୍ନିଙ୍‌ ଆମଙ୍‌ ମନ୍‌ରାଞ୍ଜି ଆସନ୍‌ ଅନବ୍‌ଉୟୁବନ୍‌ ଆ ଞନଙ୍‌ ଡକୋଏନ୍‌ ଡେନ୍‌, ଆୟ୍‌ ବର୍ନାବା ।” ");
INSERT INTO juy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ସିଲତ୍ତେ ପାଓଲନ୍‌ ତନଙ୍‌ଡାଲେ ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଆସିନ୍‌ ବାତ୍ତେ ତାରିଆୟ୍‌ଡାଲେ ବର୍ରନେ; “ଏ ଇସ୍ରାଏଲ୍‌ମର୍‌ଜି, ଆରି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଏବ୍ରତଙ୍‌ତେନ୍‌ ଆ ମନ୍‌ରାଜି ଅମ୍‌ଡଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","କେନ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆ ଇସ୍ୱର ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜିଆଡଙ୍‌ ସେଡାଏନ୍‌, ଆରି ଆନିଞ୍ଜି ମିସର୍‌ ଡେସାଲୋଙନ୍‌ ଜିର୍ଜିରିୟ୍‌ଲନ୍‌ ଇୟ୍‌ଲେ ଡକୋନେଞ୍ଜି ଆଡିଡ୍‌ ଇସ୍ୱରନ୍‌ ଆନିଞ୍ଜି ଅବ୍‌ଗୋଗୋଜେଞ୍ଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ ବୋର୍ସା ଡେନ୍ନାନ୍‌ ବାତ୍ତେ ମିସର୍‌ ଡେସାନ୍‌ ସିଲଡ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲେ ଓରୋଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ଆରି ବାକୁଡ଼ି ବର୍ସେଙ୍‌ ଡେତେ ଆନିନ୍‌ ଆରିଙ୍‌ରିଙ୍‌ଲୋଙନ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଞନଣ୍ଡ୍ରମ୍‌ ସଏଲେ ଡକୋଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ଆରି ଆନିନ୍‌ କିନାନ୍‌ ଡେସାଲୋଙନ୍‌ ସାତଟା ଜାତିନ୍‌ ଆ ମନ୍‌ରାଜି ସାୟ୍‌ଡ ଏମ୍ମେଏନ୍‌ କି ତି ଆ ଡେସା ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ଆନିଞ୍ଜି ତେତ୍ତେ ଉଞ୍ଜିସଅ ପଚାସ ବର୍ସେଙ୍‌ ଡକୋଲଞ୍ଜି ।” “ତି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଇସ୍ୱରନ୍‌ ସାମୁଏଲ୍‌ ପୁର୍ବାଃତେ ବର୍ନେମରନ୍‌ ଜାୟ୍‌ ଅନବ୍‌ପନ୍‌ସୁଆତିମରଞ୍ଜି ତବ୍‌ନଙେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ତିକ୍କି ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଅବୟ୍‌ ରାଜାନ୍‌ ସନାୟ୍‌ସାୟ୍‌ ଆଗ୍ରାମେଞ୍ଜି, ଇସ୍ୱରନ୍‌ ବେଞ୍ଜାମିନ୍‌ କେଜ୍ଜାନ୍‌ ସିଲଡ୍‌ କିସନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ସାଓଲନ୍‌ଆଡଙ୍‌ ତବ୍‌ନଙେନ୍‌; ଆନିନ୍‌ ବାକୁଡ଼ି ବର୍ସେଙ୍‌ ଜାୟ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ସାସନଏନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ବନ୍‌ଡ ତିକ୍କି ଆଡିଡ୍‌ ଇସ୍ୱରନ୍‌ ସାଓଲନ୍‌ଆଡଙ୍‌ ରାଜା ତରଙ୍କୁମନ୍‌ ସିଲଡ୍‌ ଅପ୍ପଡେନ୍‌ କି ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆ ରାଜାନେନ୍‌ ଆସନ୍‌ ଦାଉଦନ୍‌ ତବ୍‌ନଙେନ୍‌; ଆରି ଇସ୍ୱରନ୍‌ ଦାଉଦନ୍‌ ଆ ବର୍ନେ ନିୟ୍‌ ବର୍ରନେ, ଞେନ୍‌ ଜିସୟନ୍‌ ଆ ଡାଙ୍ଗଡ଼ାଅନ୍‌ ଦାଉଦନ୍‌ ଞାଙ୍‌ଲାୟ୍‌, ମନ୍ନଞେନ୍‌ ଏଙ୍ଗାଗୋ ଆ ମନ୍ନନ୍‌ ନିୟ୍‌ ଏତ୍ତେଗୋ, ଆନିନ୍‌ ଇସ୍ସୁମ୍‌ଞେନ୍‌ ବାତ୍ତେ ଅଡ଼୍‌କୋନ୍‌ ଆ କାବ୍ବାଡ଼ା ଲୁମ୍‌ତେ । ");
INSERT INTO juy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ଆରି ଇସ୍ୱରନ୍‌ ଏଙ୍ଗାଲେ ପର୍ମାଡ଼ାଲନେ ତି ଅନ୍ତମ୍‌ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜିଆଡଙ୍‌ ଅନୁରନ୍‌ ଆସନ୍‌ ଦାଉଦନ୍‌ ଆ କେଜ୍ଜାଲୋଙ୍‌ ସିଲଡ୍‌ ଅବୟ୍‌ ଅନୁର୍‌ମରନ୍‌ ଅମ୍‌ଡୁଙ୍‌ଲାୟ୍‌, ଆନିନ୍‌ ମା ଜିସୁ କ୍ରିସ୍ଟନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ଜିସୁନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଇୟାଞନ୍‌ ଆଡିଡ୍‌ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ତବ୍ବୁବ୍‌ଡାନେନ୍‌ ଆସନ୍‌ ଆମ୍ମୁଙ୍‌ ଜନନ୍‌ ଅଡ଼୍‌କୋ ଇସ୍ରାଏଲ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ବର୍ବରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ଆରି ତବ୍ବୁବ୍‌ଡାମର୍‌ ଜନନ୍‌ ଆ କାବ୍ବାଡ଼ାନ୍‌ ଅଣ୍ଡ୍ରଙ୍‌ ଅବ୍‌ସୁଜ୍ଜେଏନ୍‌ ଆଡିଡ୍‌ ବର୍ରନେ, ‘ଞେନ୍‌ ଅଙ୍ଗା ମନ୍‌ରା ଅଲ୍‌ଡେଏ ଗାମ୍‌ଲେ ଆମ୍ୱେଞ୍ଜି ଏବ୍‌ଡିସୟ୍‌ତେ, ଞେନ୍‌ ଆନିନ୍‌ ତଡ୍‌ । ବନ୍‌ଡ ଗିୟ୍‌ବା, ଞେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆରି ଅବୟ୍‌ନେ ଜିର୍ତାୟ୍‌, ଆ ତାଲ୍‌ଜଙ୍‌ଲୋଙନ୍‌ ଆ ପାଣ୍ଡୋୟ୍‌ ଆ ଲୁଆଡ୍‌ ଉଜୁଜନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଜିଞ୍ଜିନ୍‌ ତଡ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ଏ ଅବ୍ରାମନ୍‌ ଆ କେଜ୍ଜା ଇସ୍ରାଏଲ୍‌ ବୋଞାଙ୍‌ଜି ତନାନ୍‌ଜି ଆରି ଇସ୍ୱରନ୍‌ ଏବ୍ରତଙ୍‌ତେନ୍‌ ଆ ମନ୍‌ରାଜି, କେନ୍‌ ଅନୁରନ୍‌ ଆ ବର୍ନେ ଅମଙ୍‌ଲେନ୍‌ ମା ଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଜିରୁସାଲମନ୍‌ ଆ ମନ୍‌ରାଜି ଡ ତେତ୍ତେ ଆ ସୋଡ଼ାମର୍‌ଜି ଆନିନ୍‌ଆଡଙ୍‌ ଅନୁର୍‌ମର୍‌ ଗାମ୍‌ଲେ ଅଃଜ୍ଜନାଲଜି, ଆରି ଡିତାନ୍‌ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଆପ୍ରଡ଼େଲଞ୍ଜି ଆ ବର୍ନେ ଆନିଞ୍ଜି ଅଃଗନ୍‌ଲୁଡ୍‌ଲଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଜିସୁନ୍‌ଆଡଙ୍‌ ଅବ୍‌ଡୋସାଡାଲେ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ବର୍ନେ ଅନ୍ତମ୍‌ ଗବ୍‌ଡେଲେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ଆରି ରନବୁ ପନବ୍‌ରଡନ୍‌ ଆସନ୍‌ ଇନ୍ନିଙ୍‌ ଡୋସାନ୍‌ ଅଃଞାଙ୍‌ଲଜି ଜନଙ୍‌ଡେନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ ପିଲାତନ୍‌ଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ଆରି, ଡରମ୍ମ ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆନିନ୍‌ ଆସନ୍‌ ଇନିଜି ଆଇଡିଡ୍‌, ତିଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଲୁମ୍‌ଲେ ଆରବ୍‌ସୁଜ୍ଜେଏଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆଅକ୍କାଡଙନ୍‌ ସିଲଡ୍‌ ଅପ୍ପଡ୍‌ଲେ ପାଙ୍‌ଲାଜି କି ମସାନ୍ନିଲୋଙନ୍‌ ଇୟ୍‌ଲେ ଡକ୍କୋଏଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଆରବୁମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଅବ୍‌ୟର୍ମେଙେନ୍‌, ");
INSERT INTO juy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ଆରି, ଆନାଜି ଆନିନ୍‌ ସରିନ୍‌ ଗାଲିଲିନ୍‌ ସିଲଡ୍‌ ଜିରୁସାଲମନ୍‌ ଜିର୍ରାଜି, ଆନିଞ୍ଜି ଜବ୍ର ଡିନ୍ନା ଜାୟ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ଗିଜେଞ୍ଜି; ଆନିଞ୍ଜି ନମିଜି ଆ ମନ୍‌ରାଜି ଆମଙ୍‌ ସାକିନ୍‌ ତିୟ୍‌ତଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ଆରି, ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଆମଙ୍‌ ଇସ୍ୱରନ୍‌ ଅଙ୍ଗାତେ ପର୍ମାଡ଼ାଲନ୍‌ ତି ଆ ମନଙ୍‌ବର୍‌ ଇନ୍‌ଲେନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଏବ୍‌ଜନାତବେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ଇନ୍‌ଲେଞ୍ଜି ଇସ୍ୱରନ୍‌ ଆ ପସିୟ୍‌ଜି, ତିଆସନ୍‌ ଆନିନ୍‌ ଜିସୁନ୍‌ଆଡଙ୍‌ ଅବ୍‌ୟର୍ମେଙ୍‌ଡାଲେ ଆନିନ୍‌ ଅମଙ୍‌ଲେନ୍‌ ଅଙ୍ଗାତେ ପର୍ମାଡ଼ାଲନ୍‌ ତିଆତେ ଡେଡମେନ୍‌, ତିଅନ୍ତମ୍‌ କନନ୍‌ବଇନ୍‌ ବାଗୁ ପର୍ବଲୋଙନ୍‌ ନିୟ୍‌ ଆଇଡିଡ୍‌; ‘ଆମନ୍‌ ଡାଙ୍ଗଡ଼ାଅନ୍‌ଞେନ୍‌, ଲଙେ ଞେନ୍‌ ଆମନ୍‌ କୋଡ୍‌ଲମ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ଆରି ମସାନ୍ନିଲୋଙନ୍‌ ରନସୁମନ୍‌ ଆସନ୍‌ ଏର୍‌ନମ୍‌ରେଙନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ରନବୁନ୍‌ ସିଲଡ୍‌ ଅନବ୍‌ୟର୍ମେଙନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ; ‘ଞେନ୍‌ ଅଙ୍ଗାତେ ଦାଉଦନ୍‌ ଆମଙ୍‌ ପର୍ମାଡ଼ାଲନାୟ୍‌, ତି ଆଜାଡ଼ିଡମନ୍‌ ଡ ଆସିର୍ବାଦଞ୍ଜି ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ତିୟ୍‌ତବେନ୍‌ ।’ ");
INSERT INTO juy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ସାସ୍ତ୍ରଲୋଙନ୍‌ ଆରି ବଜାଗାଲୋଙ୍‌ ନିୟ୍‌ ଆଇଡିଡ୍‌ ଡକୋ; ‘ଆମନ୍‌ ମଡ଼ିର୍‌ମର୍‌ନମ୍‌ଆଡଙ୍‌ ମସାନ୍ନିଲୋଙନ୍‌ ଅଃନ୍ନବ୍‌ସଅଏ ।’ ");
INSERT INTO juy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାଉଦନ୍‌ ଆ ସରିକୋଡ୍‌ମରଞ୍ଜି ଆମଙ୍‌ ଇସ୍ୱରନ୍‌ ଆ ଇସ୍ସୁମ୍‌ ବାତ୍ତେ ସେବା କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ଲେ ଆରବ୍‌ସୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌, ଆନିନ୍‌ ରବୁଏନ୍‌ ଆରି ଆନିନ୍‌ ଆ ପୁର୍ବା ଜୋଜୋଞ୍ଜି ଆମଙ୍‌ ତିଲେଞ୍ଜି, ଆରି ଆ ମରାନ୍‌ ମସାନ୍ନିଲୋଙନ୍‌ ରସମେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ବନ୍‌ଡ ଇସ୍ୱରନ୍‌ ଆନାଆଡଙ୍‌ ଅବ୍‌ୟର୍ମେଙେନ୍‌, ଆନିନ୍‌ ଅଃର୍ରସମ୍‌ଲୋ । ");
INSERT INTO juy_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ତିଆସନ୍‌, ଏ ବୋଞାଙ୍‌ଜି, ଆମ୍ୱେଞ୍ଜି କେନ୍‌ଆତେ ଜନାବେନ୍‌ତୋ, କେନ୍‌ ଆ ମନ୍‌ରା ଅମ୍ମେଲେ ଅମଙ୍‌ବେନ୍‌ ଇର୍ସେନ୍‌ ସିଲଡ୍‌ କେମାନ୍‌ ଆଞନାଙ୍‌ ଆ ବର୍ନେ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଡେତେ; ");
INSERT INTO juy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ଆରି, ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ବାତ୍ତେ ଆମ୍ୱେଞ୍ଜି ଅନୁରନ୍‌ ଞାଙ୍‌ଲେ ଡରମ୍ମମର୍‌ ଅଃଡ୍ଡେଲବେନ୍‌, ଜିସୁନ୍‌ ଆମଙ୍‌ ଆଡର୍ତନେଞ୍ଜି ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋନ୍‌ ଆ ଇର୍ସେ ସିଲଡ୍‌ ଅନୁରନ୍‌ ଞାଙ୍‌ଲେ ଡରମ୍ମମର୍‌ ଡେତଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ତିଆସନ୍‌ ଗିୟ୍‌ଡମ୍‌ନାବା, ଅଙ୍ଗାତେ ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ବର୍ରଞ୍ଜି, ତିଆତେ ଅସମୟ୍‌ ଅମଙ୍‌ବେନ୍‌ ଅଡ଼ୋଡଙାୟ୍‌ ତଡ୍‌, ");
INSERT INTO juy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ଏ ଆଲ୍ଲେମର୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ଗିୟ୍‌ବା, ଆରି ସାନ୍ନିଡାଲେ ରବୁବେନ୍‌ତୋ; ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ଞେନ୍‌ ବନେଡ଼ାବେନ୍‌ ଅବୟ୍‌ କାବ୍ବାଡ଼ାନ୍‌ ଲୁମ୍‌ତାୟ୍‌, ଆନ୍ନିଙ୍‌ ତି ଆ କାବ୍ବାଡ଼ା ଆ ବର୍ନେ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ବର୍ରବେନ୍‌ ଜନଙ୍‌ଡେନ୍‌, ତିଆତେ ଆମ୍ୱେଞ୍ଜି ଏଃଡ୍ଡର୍ନେ ।’” ");
INSERT INTO juy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ମଣ୍ଡଡ଼ିସିଙନ୍‌ ସିଲଡ୍‌ ଡୁଙ୍‌ଲନ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌, ଆଜିର୍ତାଞନ୍‌ ଆ ଲୋଲୋନେ ଡିନ୍ନାଇଂ ନିୟ୍‌ ତି ଆ ବର୍ନେଜି ଆରି ଡାତେଙ୍‌ ଞନଙନ୍‌ ଆୟ୍‌ ତିୟ୍‌ବା ଗାମ୍‌ଲେ ତେତ୍ତେ ଆ ମନ୍‌ରାଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ସୋବାନ୍‌ ଆସ୍ରୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜବ୍ରଡମ୍‌ ଜିଉଦିମରଞ୍ଜି ଡ ଜିଉଦିଲୋଙନ୍‌ ଆମ୍ରାୟ୍‌ଲଞ୍ଜି ଏର୍‌ଜିଉଦିମରଞ୍ଜି ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ଲେ ପାଙେଞ୍ଜି; ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିଞ୍ଜି ସରିନ୍‌ କଡାଡ଼ିଡାଲନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ସନାୟୁମ୍‌ଲୋଙ୍‌ ଗବ୍‌ରିଲନ୍‌ ଡକୋନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞଙ୍‌ଞଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ତିକ୍କି, ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ଗଡ଼ାନ୍‌ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ପ୍ରବୁନ୍‌ ଆ ବର୍ନେ ଅନମ୍‌ଡଙନ୍‌ ଆସନ୍‌ ରୁକ୍କୁଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ବନ୍‌ଡ ଜିଉଦିମରଞ୍ଜି ମନ୍‌ରାଞ୍ଜିଆଡଙ୍‌ ଗିୟ୍‌ଲେ ଇସ୍କତ୍ତାଡାଏଞ୍ଜି, ଆରି ପାଓଲନ୍‌ ଆ ବର୍ନେ ନିଣ୍ଡୟ୍‌ଡାଲେ ଆନିନ୍‌ଆଡଙ୍‌ ଗବ୍‌ରଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ସିଲତ୍ତେ ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ଅବ୍ବୋମଙ୍‌ଡାଲନ୍‌ ବର୍ରଞ୍ଜି; “ଇସ୍ୱରନ୍‌ ଆ ବର୍ନେ ଅମଙ୍‌ବେନ୍‌ ବନ୍‌ ଆମ୍ମୁଙ୍‌ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଡେତେ; ବନ୍‌ଡ ଆମ୍ୱେଞ୍ଜି ତିଆତେ ଅଲାତ ଏଏମ୍ମେନ୍‌ କି ଆମ୍ୱେଞ୍ଜିଡମ୍‌ ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଆଞନାଙ୍‌ ଆସନ୍‌ ଜିଞ୍ଜିନ୍‌ଜି ତଡ୍‌ ଏଗାମ୍‌ଡମ୍‌ଲନ୍‌, ଗିୟ୍‌ବା, ଇନ୍‌ଲେଞ୍ଜି ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଏଅପ୍ପୁଙ୍‌ବର୍ତାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପ୍ରବୁନ୍‌ ଇନ୍‌ଲେଞ୍ଜିଆଡଙ୍‌ ଏନ୍ନେଲେ ବର୍ରଲେନ୍‌, ‘ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ସମ୍ପରା ପୁର୍ତିନ୍‌ ଆ ମନ୍‌ରାଜି ଅନୁରନ୍‌ ଞାଙ୍‌ଲେ ରପ୍ତିଏଜି, ତିଆସନ୍‌ ଞେନ୍‌ ଆମନ୍‌ଆଡଙ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆସନ୍‌ ସନାଆରନ୍‌ ଅନ୍ତମ୍‌ ଏମ୍ମେଲମ୍‌ ।’” ");
INSERT INTO juy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ଏର୍‌ଜିଉଦିମରଞ୍ଜି କେନ୍‌ଆତେ ଆରମ୍‌ଡଙେଞ୍ଜି ସର୍ଡାଡାଏଞ୍ଜି କି ଆନିଞ୍ଜି ପ୍ରବୁନ୍‌ ଆ ବର୍ନେ ଆସନ୍‌ ସେଙ୍କେଏଞ୍ଜି, ଆରି ଡିଅଙ୍ଗା ମନ୍‌ରା ଅଃନ୍ନଞିଡେନ୍‌ ଆନମେଙ୍‌ ଆସନ୍‌ ସନେଡାନ୍‌ ଡେଏନ୍‌, ଆନିଞ୍ଜି ତି ଆ ବର୍ନେଲୋଙ୍‌ ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପ୍ରବୁନ୍‌ ଆ ବର୍ନେ ସମ୍ପରାନ୍‌ ବୁର୍ବୁରାୟ୍‌ଲନେ । ");
INSERT INTO juy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ବନ୍‌ଡ ଜିଉଦିଲୋଙନ୍‌ ଆମ୍ରାୟ୍‌ଲଞ୍ଜି ଏର୍‌ଜିଉଦିମରଞ୍ଜି ସୋଡ଼ାବଜଞ୍ଜି ଡ ଗଡ଼ାନ୍‌ ଆ ସୋଡ଼ାମର୍‌ଜିଆଡଙ୍‌ ଜିଉଦିମରଞ୍ଜି ସୁସ୍କାୟେଞ୍ଜି କି, ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ଆଡଙ୍‌ ଡଣ୍ଡାୟ୍‌ଡାଲେ ଆ ଗଡ଼ାଞ୍ଜି ଆ ସଣ୍ଡି ସିଲଡ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମ୍‌ଡୁଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ସିଲତ୍ତେ ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ତାଲ୍‌ଜଙ୍‌ଲୋଙ୍‌ ଆ ଉମ୍ରିଲ ତି ଆ ଗଡ଼ା ଆ ମନ୍‌ରାଜି ଆ ବିରୁଦଲୋଙ୍‌ ତୁୟ୍‌ତୁୟ୍‌ଡାଲେ ଇକନିଅ ଗଡ଼ାନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ଆରି ଅନ୍ତିଅକିଆନ୍‌ ଆ ଞଙ୍‌ନେମର୍‌ଜି ସର୍ଡାନ୍‌ ଡ ମଡ଼ିର୍‌ ପୁରାଡ଼ାଲୋଙନ୍‌ ବରିଜେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ଅନ୍ତିଅକିଆ ଗଡ଼ାଲୋଙନ୍‌ ଏଙ୍ଗାଗୋ ଡେଏନ୍‌, ଇକନିଅ ଗଡ଼ାଲୋଙନ୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ମା ଡେଏନ୍‌; ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ଜିଉଦିମରଞ୍ଜି ଆ ରନୁକ୍କୁସିଂଲୋଙ୍‌ ଗନ୍‌ଲେ ଏତ୍ତେଲେ ଞନଙନ୍‌ ତିୟେଞ୍ଜି ଡ, ଜବ୍ରଡମ୍‌ ଜିଉଦିମରଞ୍ଜି ଡ ଗ୍ରିକ୍‌ମରଞ୍ଜି କ୍ରିସ୍ଟନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ବନ୍‌ଡ ଅଙ୍ଗା ଜିଉଦିମର୍‌ଜି ଅଃଡ୍ଡର୍ରଞ୍ଜି, ଆନିଞ୍ଜି ଡର୍ନେ ବୋଞାଙଞ୍ଜି ଆ ବିରୁଦଲୋଙ୍‌ ତନନଙନ୍‌ ଆସନ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ସୁସ୍କାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ତେତ୍ତେ ଜବ୍ର ଡିନ୍ନା ଜାୟ୍‌ ଡକୋଡାଲନ୍‌ ପ୍ରବୁନ୍‌ ଆମଙ୍‌ ଇଙ୍‌ଡର୍‌ଡାଲନ୍‌ ଅବ୍ବୋମଙ୍‌ଲନ୍‌ ମନଙ୍‌ବରନ୍‌ ଅପ୍ପୁଙ୍‌ବରେଞ୍ଜି; ଆରି ଆନିଞ୍ଜି ତେତ୍ତେ ଅରମ୍ମଡନ୍‌ ଡ ସାନ୍ନି କାବ୍ବାଡ଼ାନ୍‌ ବାତ୍ତେ ପ୍ରବୁନ୍‌ ଆ ସନାୟୁମ୍‌ବର୍‌ ଆଡନେଗଡ୍‌ଲୋଙ୍‌ ସାକିନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ବନ୍‌ଡ ଗଡ଼ାନ୍‌ ଆ ମନ୍‌ରାଜି ବାଗୁ ପାଲ୍ଲାଙ୍‌ ଡେଏଞ୍ଜି, ଲାଙ୍‌ଲେନ୍ନେ ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ଗଡ୍‌ ଡେଏଞ୍ଜି, ଆରି ଲାଙ୍‌ଲେନ୍ନେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆମଙ୍‌ଗଡ୍‌ ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ଲାଙ୍‌ଲେଡ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଡ ଜିଉଦିମରଞ୍ଜି ସୋଡ଼ାମରଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜିଆଡଙ୍‌ ଡନଣ୍ଡାୟନ୍‌ ଆସନ୍‌ ଆରି ଅରେଙନ୍‌ ବାତ୍ତେ ତିଡ୍‌ଲେ ରନବ୍ବୁନ୍‌ ଆସନ୍‌ କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ତିଆତେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆଜ୍ରନାଏଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ଲୁକାନିଆ ଡେସାନ୍‌ ଲୁସ୍ତ୍ରାନ୍‌ ଡ ଦର୍ବି ଗଡ଼ାନ୍‌ ଆରି ତି ଆ ତନ୍ନଡ୍‌ ଆ ଗଡ଼ାରେଙ୍‌ ଜିର୍ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ଆରି ତେତ୍ତେ ନିୟ୍‌ ଆନିଞ୍ଜି ମନଙ୍‌ବରନ୍‌ ଇୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ଲୁସ୍ତ୍ରା ଗଡ଼ାଲୋଙନ୍‌ ଅବୟ୍‌ ମନ୍‌ରାନ୍‌ ଡକୋଏନ୍‌, ଆ ତାଲ୍‌ଜଙନ୍‌ ବପ୍ପୁ ତଡ୍‌, ଆନିନ୍‌ ଆୟୋଙନ୍‌ ଆ କିମ୍ପୋଙ୍‌ଲୋଙ୍‌ ମା ସିଲଡ୍‌ ଆ ଗାଡ଼େ, ଆରି ଆନିନ୍‌ ଆଙ୍ଗିୟ୍‌ ତଙିୟ୍‌ଲନ୍‌ ଅଃର୍ରପ୍ତିଲୋ । ");
INSERT INTO juy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ତି ଆ ମନ୍‌ରା ପାଓଲନ୍‌ ଆ ଞନଙ୍‌ ଅମ୍‌ଡଙ୍‌ଲେ ଡକୋଲନ୍‌ । ପାଓଲନ୍‌ ତି ଗାଡ଼େମରନ୍‌ଆଡଙ୍‌ ଏର୍‌ସେଡ୍‌ମଡ୍‌ନେନ୍‌ ଆଙାଙେନ୍‌ କି ଆନିନ୍‌ ମନନଙନ୍‌ ଆସନ୍‌ ଆମଙନ୍‌ ଡର୍ନେନ୍‌ ଡକୋ ଗାମ୍‌ଲେ ଜନାଏନ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ତିଆସନ୍‌ ପାଓଲନ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ବର୍ରନେ, “ତାଲ୍‌ଜଙ୍‌ନମ୍‌ ବାତ୍ତେ ତୋର୍‌ଞାମ୍‌ଡାଲନ୍‌ ସବ୍‌ତଙ୍‌ଲନ୍‌ ତନଙା ।” ସିଲତ୍ତେ ତି ଆ ମନ୍‌ରା ଇଡ୍ଡୋୟ୍‌ଲନ୍‌ ତନଙେନ୍‌ କି ତଙିୟ୍‌ଲନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ପାଓଲନ୍‌ ଆର୍‌ଲୁମେନ୍‌ ଆ କାବ୍ବାଡ଼ା ଗିୟ୍‌ଲେ, ତେତ୍ତେ ଆ ମନ୍‌ରାଜି ଲୁକାନିଆ ଲଙ୍‌ଲଙନ୍‌ ବାତ୍ତେ ବାବ୍ବାବ୍‌ଲେ ବର୍ରଞ୍ଜି, “ଇସ୍ୱରଞ୍ଜି ବାଙ୍‌ସାୟ୍‌ଡାଲନ୍‌ ମନ୍‌ରାଞ୍ଜି ଅନ୍ତମ୍‌ ଏମ୍ମେଡାଲନ୍‌ ଅମଙ୍‌ରେଙ୍‌ଲେନ୍‌ ପଡ୍‌ଲନାଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ଆନିଞ୍ଜି ବର୍ନବାନ୍‌ଆଡଙ୍‌ ବୃଅସ୍ୱତି ଗାମ୍‌ଲେ ଓଡ୍ଡେଏଞ୍ଜି, ଆରି ପାଓଲନ୍‌ ସୋଡ଼ା ଅନପ୍ପୁଙ୍‌ବର୍‌ମର୍‌ ଆଡ୍ରେଏନ୍‌ ଆସନ୍‌ ଆନିନ୍‌ଆଡଙ୍‌ ବୁଦ ଗାମ୍‌ଲେ ଓଡ୍ଡେଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ଆରି ଗଡ଼ାନ୍‌ ଆ ମୁକ୍କାଗଡ୍‌ ଆଡ୍ରକୋଏନ୍‌ ବୃଅସ୍ୱତିନ୍‌ ମନ୍ଦିରନ୍‌ ଆ ରାଓଡ଼ା ମନ୍‌ରାଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ଆସନ୍‌ ଅନମଙନ୍‌ ତନିୟନ୍‌ ଆସନ୍‌ ସଣ୍ଡତାଙନ୍‌ ଡ ଆ ପଡ଼ୟ୍‌ତାରନ୍‌ ପାଙ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ବନ୍‌ଡ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି, ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ କେନ୍‌ଆତେ ଆରମ୍‌ଡଙେଞ୍ଜି ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ଅଙ୍ଗି ପେଲେ ମନ୍‌ରାଞ୍ଜି ଆମଙ୍‌ ଇରେଞ୍ଜି କି ଆନିଞ୍ଜିଆଡଙ୍‌ ସୋଡ଼ା ସର୍ରଙନ୍‌ ବାତ୍ତେ ଇୟ୍‌ଲେ ବରେଜି; ");
INSERT INTO juy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ଇନିବା ଆମ୍ୱେଞ୍ଜି କେନ୍‌ଆତେ ଏଲୁମ୍‌ତେ ? ଇନ୍‌ଲେଞ୍ଜି ନିୟ୍‌ ଆମ୍ୱେଞ୍ଜି ମା ଅନ୍ତମ୍‌ ମନ୍‌ରାଜି; ଆମ୍ୱେଞ୍ଜି କେନ୍‌ ଇନ୍ନିଙ୍‌ ବରାଁୟ୍‌ବାଁୟ୍‌ତଡନ୍‌ ଆ କୋଙ୍‌ଡାୟ୍‌ଜି ଅମ୍‌ରେଙ୍‌ଡାଲେ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ଆମେଙ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ୟର୍ନାୟ୍‌ବା ଗାମ୍‌ଲେ ଇନ୍‌ଲେଞ୍ଜି କେନ୍‌ ଆ ମନଙ୍‌ବର୍‌ ଅମଙ୍‌ବେନ୍‌ ଏବର୍ତନାୟ୍‌ । ଆନିନ୍‌ ରୁଆଙନ୍‌, ପୁର୍ତିନ୍‌, ସମେଁୟ୍‌ଣ୍ଡ୍ରାନ୍‌ ଆରି ତେତ୍ତେଆତେଜି ଅଡ଼୍‌କୋନ୍‌ ଗବ୍‌ଡେଲେନ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ଆନିନ୍‌ ପୁର୍ବାନ୍‌ ଅଡ଼୍‌କୋନ୍‌ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ରମ୍ମଙ୍‌ ରମ୍ମଙ୍‌ ଆ ତଙର୍‌ଲୋଙ୍‌ ତଙିୟ୍‌ନେନ୍‌ ଆସନ୍‌ ଅମ୍‌ରେଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ଡେଲୋଜନଙ୍‌ଡେନ୍‌ ଆନିନ୍‌ ସାକିତଡନ୍‌ ଅନ୍ତମ୍‌ ଅଃଡ୍ଡକୋଲନ୍‌, ଆନିନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଆସନ୍‌ ମନଙ୍‌ କାବ୍ବାଡ଼ାଞ୍ଜି ଲୁମେନ୍‌; ରୁଆଙନ୍‌ ସିଲଡ୍‌ ତରୁବନ୍‌, ଆଡିନ୍ନାଇଙନ୍‌ ଅନଜଞ୍ଜି ଡ ଜନୋମ୍‌ଜୋମଞ୍ଜି ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ତନ୍‌, ଆରି ଉଗର୍‌ଲୋଙ୍‌ଲେନ୍‌ ଅବ୍‌ସର୍ଡାଲଙ୍‌ତନ୍‌ ।” ");
INSERT INTO juy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","କେନ୍‌ ଏନ୍ନେଲେ ଆ ବର୍ନେଜି ବର୍ରନ୍‌ ଆନିଞ୍ଜି ଆସନ୍‌ ଅନମଙନ୍‌ ଏତିୟ୍‌ଡଙ୍‌ ଗାମ୍‌ଲେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ମନ୍‌ରାଜିଆଡଙ୍‌ କାକୁର୍ତିଃ ରଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ଅନ୍ତିଅକିଆନ୍‌ ଡ ଇକନିଅ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ଜିଉଦିମରଞ୍ଜି ଲୁସ୍ତ୍ରାନ୍‌ ଇୟ୍‌ଲେ ତେତ୍ତେ ଆ ମନ୍‌ରାଜିଆଡଙ୍‌ ଇୟ୍‌ଲାୟ୍‌ ସୁସ୍କାୟେଜି କି ପାଓଲନ୍‌ଆଡଙ୍‌ ତିଡରେଞ୍ଜି, ଆରି ଆନିନ୍‌ ରବୁଏନ୍‌ ଅବ୍‌ଡିସୟ୍‌ଡାଲେ ଗଡ଼ାନ୍‌ ସିଲଡ୍‌ ଡିଙ୍‌ଲେ ଡୁଆରାନ୍‌ ପାଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ବନ୍‌ଡ ଞଙ୍‌ନେମରଞ୍ଜି ଆନିନ୍‌ ଏର୍ରେ ତନଙ୍‌ଲେ ଆଡ୍ରକୋଲଞ୍ଜି ଆନିନ୍‌ ଡୋଲନ୍‌ ତନଙେନ୍‌ କି ଅମ୍ମ ଗଡ଼ାନ୍‌ ଜିରେନ୍‌ । ତି ଆବାର୍ତାନ୍‌ ଆନିନ୍‌ ବର୍ନବାନ୍‌ ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ ଦର୍ବି ଗଡ଼ାନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ଦର୍ବି ଗଡ଼ାଲୋଙନ୍‌ ମନଙ୍‌ବରନ୍‌ ଅପ୍ପୁଙ୍‌ବରେଞ୍ଜି ଆରି ତେତ୍ତେ ଜବ୍ର ମନ୍‌ରାଜି ଞଙ୍‌ନେମର୍‌ ଏମ୍ମେଏଞ୍ଜି କି ଆନିଞ୍ଜି ଲୁସ୍ତ୍ରାନ୍‌, ଇକନିଅନ୍‌ ଡ ଅନ୍ତିଅକିଆନ୍‌ ୟର୍ରନାଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ଆରି, ଆନିଞ୍ଜି ତେତ୍ତେ ଞଙ୍‌ନେମରଞ୍ଜି ଡର୍ନେଲୋଙନ୍‌ ରବ୍‌ଡୋଲନ୍‌ ଡକୋନେନ୍‌ ଆସନ୍‌ ବରେଞ୍ଜି, “ଇନ୍‌ଲେନ୍‌ ଜବ୍ର ଡଣ୍ଡଗଡ୍‌ ଜିର୍ରେ ଇସ୍ୱରନ୍‌ ଆ ରାଜ୍ୟଲୋଙ୍‌ ଗନ୍‌ତବୋ,” ଗାମ୍‌ଲେ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ଆରି ଆନିଞ୍ଜି ଡିଲେ ମଣ୍ଡଡ଼ିଲୋଙନ୍‌ ପାପୁର୍‌ମରଞ୍ଜି ସେଡାଲେ ତବ୍‌ନଙେଞ୍ଜି କି ଆନମ୍‌ଡାଲନ୍‌ ପାର୍ତନାଲଞ୍ଜି, ଆରି ଅଙ୍ଗା ପ୍ରବୁ ଆମଙ୍‌ ଆନିଞ୍ଜି ଡର୍ରଞ୍ଜି, ଆସିଲୋଙନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ସୋରୋପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ପିସିଦିଆ ଗଡ଼ାଗଡ୍‌ ପମ୍ପୁଲିଆନ୍‌ ଜିର୍ରାଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ଆରି ଆନିଞ୍ଜି ପର୍ଗି ଗଡ଼ାଲୋଙନ୍‌ ମନଙ୍‌ବରନ୍‌ ଅପ୍ପୁଙ୍‌ବରେଞ୍ଜି କି ଆତ୍ତାଲିଆନ୍‌ ଜିରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ତେତ୍ତେ ସିଲଡ୍‌ ଆନିଞ୍ଜି ଜାଜଲୋଙନ୍‌ ଡାୟ୍‌ଲେ ଅନ୍ତିଅକିଆନ୍‌ ଜିରେଞ୍ଜି; ତେତ୍ତେ ଆମ୍ମୁଙ୍‌ ଆନିଞ୍ଜି ଅଙ୍ଗା କାବ୍ବାଡ଼ା ଲୁମେଞ୍ଜି, ତିଆତେ ଲନୁମନ୍‌ ଆସନ୍‌ ଇସ୍ୱରନ୍‌ ଆ ସନାୟୁମ୍‌ଲୋଙ୍‌ ସୋରୋପ୍ପାୟ୍‌ଡମ୍‌ଲନ୍‌ ଆନିଞ୍ଜି ତେତ୍ତେ ସିଲଡ୍‌ ଡୁଙ୍‌ଜଙ୍‌ଲନାଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ଆନିଞ୍ଜି ଅନ୍ତିଅକିଆନ୍‌ ତୁଙେଞ୍ଜି କି ମଣ୍ଡଡ଼ିନ୍‌ ଆ ମନ୍‌ରାଜି ଇୟ୍‌ଲେ ଅବ୍‌ରୁକ୍କୁଏଜି, ଆରି ଇସ୍ୱରନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋଡାଲନ୍‌ ଇନିଜି ଆ କାବ୍ବାଡ଼ା ଲୁମେନ୍‌, ଆରି ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆସନ୍‌ ଡର୍ନେନ୍‌ ଆ ସନଙ୍‌ ଏଙ୍ଗାଲେ ରୋଏନ୍‌, ତି ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ତେତ୍ତେ ଇୟ୍‌ଲେ ବର୍ନେଜି । ");
INSERT INTO juy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ଆରି ଆନିଞ୍ଜି ତେତ୍ତେ ଡର୍ନେମରଞ୍ଜି ସରିନ୍‌ ଜବ୍ର ଡିନ୍ନା ଜାୟ୍‌ ଡକୋଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ତି ଆ ବନେଡ଼ା ଜିଉଦା ଡେସାନ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରା ଅନ୍ତିଅକିଆନ୍‌ ଜିର୍ରେ ତେତ୍ତେ ଆ ବୋଞାଙ୍‌ଜିଆଡଙ୍‌ ଏନ୍ନେଲେ ଞନଙନ୍‌ ଇୟ୍‌ଲାୟ୍‌ ତିୟେଜି, “ଆମ୍ୱେଞ୍ଜି ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଅନ୍ତମ୍‌ ଏଗବ୍‌ରେଡ୍‌ଲନ୍‌ ଡେନ୍‌ ଅନୁରନ୍‌ ଞାଙ୍‌ଲେ ଏଃର୍ରପ୍ତିଏ ।” ");
INSERT INTO juy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ସିଲତ୍ତେ ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ତି ଆ ବର୍ନେଲୋଙ୍‌ ତି ଆ ମନ୍‌ରାଜି ସରିନ୍‌ ଜବ୍ର ଅଲ୍‌ଞାଙ୍‌ତମେଞ୍ଜି, ତିଆସନ୍‌ ପାଓଲନ୍‌, ବର୍ନବାନ୍‌ ଆରି ଅନ୍ତିଅକିଆନ୍‌ ଆ ବୋଞାଙ୍‌ଜି ଲାଙ୍‌ଲେନ୍ନେ କେନ୍‌ଆତେ ଆସନ୍‌ କଡାଡ଼ିନେବାନ୍‌ ଜିରୁସାଲମନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଡ ପାପୁର୍‌ମରଞ୍ଜି ଆମଙ୍‌ ଇୟ୍‌ନେତୋ ଗାମ୍‌ଲେ କଡାଡ଼ିଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ମଣ୍ଡଡ଼ିନ୍‌ ଆ ମନ୍‌ରାଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରାପ୍ପାୟେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆନିଞ୍ଜି ପୈନିକିଆ ଗଡ଼ାନ୍‌ ଡ ସମିରୋଣ ଗଡ଼ାଗଡ୍‌ ଆଜିର୍ରେଞ୍ଜି ଆଡିଡ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଏଙ୍ଗାଡାଲେ ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଡର୍ରଞ୍ଜି, ତି ଆ କଡାଡ଼ିଜି ଆନିଞ୍ଜି ବର୍‌ଗଡ୍‌ଲଞ୍ଜି; ବୋଞାଙଞ୍ଜି କେନ୍‌ ଆ ବର୍ନେଜି ଅଡ଼୍‌କୋନ୍‌ ଆରମ୍‌ଡଙେଞ୍ଜି ମାଡ୍ଡ ସର୍ଡାଏଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ଆନିଞ୍ଜି ଜିରୁସାଲମନ୍‌ ଆତ୍ରୁଙେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ତେତ୍ତେ ଆ ମଣ୍ଡଡ଼ିମର୍‌ଜି, ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଡ ପାପୁର୍‌ମରଞ୍ଜି କେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଡୋଗଡ୍‌ଲାଜି, ଆରି ଇସ୍ୱରନ୍‌ ଆନିଞ୍ଜି ସରିନ୍‌ ଡକୋଡାଲନ୍‌ ଅଙ୍ଗା କାବ୍ବାଡ଼ାଜି ଲୁମେନ୍‌ ତି ଆ କଡାଡ଼ିଜି ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ବର୍ରଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ବନ୍‌ଡ ପାରୁସିଞ୍ଜି ଆ ଡଡ଼ଲୋଙ୍‌ ଆନାଜି ଡର୍ରଞ୍ଜି ଆନିଞ୍ଜି ଡୋଲନ୍‌ ବର୍ରଞ୍ଜି, “ଏର୍‌ଜିଉଦି ଞଙ୍‌ନେମରଞ୍ଜି ଗନବ୍‌ରେଡନ୍‌ ଆସନ୍‌ ଡ ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଞଣ୍ଡ୍ରମ୍‌ନେନ୍‌ ଆସନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଞଙ୍‌ଞଙ୍‌ତବୋଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ତିକ୍କି କେନ୍‌ଆତେଜି ଆସନ୍‌ କଡାଡ଼ିନେବାନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଡ ପାପୁର୍‌ମରଞ୍ଜି ରୁକ୍କୁଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ଆରି ମାଡ୍ଡ ଆରଲ୍‌ଡୁଲ୍‌ବାଞେଞ୍ଜି ସିଲଡ୍‌ଲ୍ଲନ୍‌ ପିତ୍ରନ୍‌ ଡୋଲନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ବରେଞ୍ଜି, “ଏ, ବୋଞାଙ୍‌ଜି ତନାନ୍‌ଜି, ଆମ୍ୱେଞ୍ଜି ଜନାଜି, ତଅଡ୍‌ଲୋଙ୍‌ଞେନ୍‌ ସିଲଡ୍‌ ମନଙ୍‌ବରନ୍‌ ଅମ୍‌ଡଙ୍‌ଡାଲେ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଏଙ୍ଗାଲ୍‌ଡେନ୍‌ ଅଲ୍‌ଡର୍ନେଜି, ତିଆସନ୍‌ ଜବ୍ର ଡିନ୍ନା ଆମ୍ମୁଙ୍‌ ଇସ୍ୱରନ୍‌ ଅମଙ୍‌ଲୋଙ୍‌ବେନ୍‌ ସିଲଡ୍‌ ଞେନ୍‌ଆଡଙ୍‌ ସେଡାଲିଁୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଆ ଉଗର୍‌ଲୋଙ୍‌ ଆନିଃୟମ୍‌ ଆଜ୍ରନାତେନ୍‌ ଆ ଇସ୍ୱର ଇନ୍‌ଲେଞ୍ଜି ଏଙ୍ଗାଲେ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ତିୟ୍‌ତିୟ୍‌ଲଙ୍‌ଲନ୍‌, ଏର୍‌ଜିଉଦିମରଞ୍ଜିଆଡଙ୍‌ ନିୟ୍‌ ଏତ୍ତେଲେ ମା ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ତିୟ୍‌ଲୋଙ୍‌ ତିୟ୍‌ଲେ ଆଡନେଗଡଞ୍ଜି ସାକିନ୍‌ ତିୟେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ଆରି, ଇସ୍ୱରନ୍‌ ଇନ୍‌ଲେଞ୍ଜି ଡ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଇନ୍ନିଙ୍‌ ତରଙ୍‌ଆନ୍ନା ଅଃନ୍ନେମ୍ମେଲଙ୍‌ଲନ୍‌, ଡର୍ନେନ୍‌ ବାତ୍ତେ ଆନିନ୍‌ ଆ ଉଗରଞ୍ଜି ମବ୍‌ଡ଼ିରେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ତିଆସନ୍‌ ଅଙ୍ଗା ରାଙଙ୍‌ ପୁର୍ବା ଜୋଜୋଲେଞ୍ଜି ଡ ଇନ୍‌ଲେଞ୍ଜି ଅଃର୍ରପ୍ତିଲବୋ, ତି ଆ ରାଙଙ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଆ ତାରଙ୍‌ଲୋଙ୍‌ ଅବ୍ବୋୟ୍‌ଡାଲେ ଇନିବା ଆମ୍ୱେଞ୍ଜି ଇସ୍ୱରନ୍‌ଆଡଙ୍‌ ଏମାଲ୍‌ତେ ? ");
INSERT INTO juy_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ବନ୍‌ଡ ଆନିଞ୍ଜି ଏଙ୍ଗାଲେ ଡର୍ନେନ୍‌ ବାତ୍ତେ ଅନୁରନ୍‌ ଞାଙେଞ୍ଜି, ଇନ୍‌ଲେଞ୍ଜି ନିୟ୍‌ ଏତ୍ତେଲେ ଡର୍ନେନ୍‌ ବାତ୍ତେ ପ୍ରବୁ ଜିସୁନ୍‌ ଆ ସନାୟୁମ୍‌ ଅମ୍ମେଲେ ଅନୁରନ୍‌ ଞାଙ୍‌ଲବୋ ।” ");
INSERT INTO juy_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ସିଲତ୍ତେ ତେତ୍ତେ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ରିଙ୍‌ ଗାମ୍‌ଲେ ଡକୋଲଞ୍ଜି, ଆରି ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ଅମ୍ମେଲେ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ ଇସ୍ୱରନ୍‌ ଇନିଜି ଆରମ୍ମଡ୍‌ ଡ ଇନିଜି ଆ ସାନ୍ନି କାବ୍ବାଡ଼ା ଲୁମେନ୍‌, ତିଆତେ ଆମଙଞ୍ଜି ସିଲଡ୍‌ ଅଡ଼୍‌କୋ ମନ୍‌ରାନ୍‌ ଅମ୍‌ଡଙେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ଆ ବର୍ନେଞ୍ଜି ଆସ୍ରୁଜ୍ଜେଏନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଜାକୁବନ୍‌ ବର୍ରନେ, “ଏ ବୋଞାଙ୍‌ଜି, ତନାନ୍‌ଜି ବର୍ନେଞେନ୍‌ ଅମ୍‌ଡଙ୍‌ବା । ");
INSERT INTO juy_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ଇସ୍ୱରନ୍‌ ଏଙ୍ଗାଲେ ଆଞୁମ୍‌ଡମନ୍‌ ଆସନ୍‌ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେନ୍ନେଆଡଙ୍‌ ସାୟୁମ୍‌ଡାଲେ ସେଡାଲେ ଓରୋଙ୍‌ଲାଜି, ତିଆତେ ସିମନନ୍‌ ବର୍ରନେ । ");
INSERT INTO juy_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ଆରି, ପୁର୍ବାଃତେ ବର୍ନେମରଞ୍ଜି ଆ ବର୍ନେ ବୟନ୍‌ କେନ୍‌ଆତେ ମାୟ୍‌ତନେ, ସାସ୍ତ୍ରଲୋଙନ୍‌ ଏନ୍ନେଲେ ଆଇଡିଡନ୍‌ ଡକୋ,” ");
INSERT INTO juy_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“କେନ୍‌ ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଞେନ୍‌ ୟର୍ତନାୟ୍‌ କି ଦାଉଦନ୍‌ ଆପୁଡ୍‌ସିଂ ଇୟ୍‌ତାୟ୍‌ ବାର୍‌ତୁବ୍‌ନାୟ୍‌, ତିଆତେ ଅଡ଼୍‌କୋନ୍‌ ଆରୁତୁଏଞ୍ଜିଆତେ ତେତ୍ତେମା ଇୟ୍‌ତାୟ୍‌ ଗୁନାୟ୍‌, ");
INSERT INTO juy_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ଏତ୍ତେଲ୍‌ଡେନ୍‌ ଆରି ଲାଙ୍‌ଲେଡ୍‌ ଆ ମନ୍‌ରାଜି ନିୟ୍‌ ପ୍ରବୁନ୍‌ଆଡଙ୍‌ ସାୟ୍‌ତଜି, ଆରି ଅଡ଼୍‌କୋ ଏର୍‌ଜିଉଦିମରଞ୍ଜି ମନ୍‌ରାଞେଞ୍ଜି ଅନେମ୍ମେନ୍‌ ଆସନ୍‌ ଞେନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଓଡ୍ଡେଲାଜି ଆନିଞ୍ଜି ଅଡ଼୍‌କୋଞ୍ଜି ଞେନ୍‌ଆଡଙ୍‌ ସଣ୍ଡୋଙ୍‌ତିଁୟ୍‌ଜି, ଅଡ଼୍‌କୋନ୍‌ ଆ କାବ୍ବାଡ଼ା ଆର୍‌ଲୁମ୍‌ତେନ୍‌ ଆ ପ୍ରବୁ କେନ୍‌ଆତେ ବର୍ତନେ । ");
INSERT INTO juy_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ଆମ୍ମୁଙ୍‌ମା ସିଲଡ୍‌ ଇସ୍ୱରନ୍‌ କେନ୍‌ ଆ ବର୍ନେ ବର୍ରନେ ।” ");
INSERT INTO juy_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“ତିଆସନ୍‌ ଞେନ୍‌ ଗାମ୍‌ତାୟ୍‌, ଅଙ୍ଗା ଏର୍‌ଜିଉଦିମର୍‌ଜି ଆବ୍‌ୟର୍‌ବୁଡ୍ଡିଲନ୍‌ ଇସ୍ୱରନ୍‌ ଆମଙ୍‌ ଜିର୍ତାଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଆରି ବାଉଲ୍ଲି ଅଃନ୍ନେମ୍ମେବୋଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ଆର୍ପାୟ୍‌ ଆନିଞ୍ଜି କୋଙ୍‌ଡାଜନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଆରମଙ୍‌ତେଞ୍ଜି ଏର୍‌ମଡ଼ିର୍‌ ଜନୋମ୍‌ଜୋମଞ୍ଜି ଏଜୋମ୍‌ଡଙ୍‌, ଜୋଣ୍ଡଡ଼ା କାବ୍ବାଡ଼ାନ୍‌ ଏଲୁମ୍‌ଡଙ୍‌, ଲମ୍ମସଙ୍କାଡାଲେ ଆର୍ରବ୍ବୁତେଞ୍ଜି ଆ ଜନ୍ତୁଜି ଆ ଜେଲୁ ଏଜୋମ୍‌ଡଙ୍‌, ଆରି ମିଞାମନ୍‌ ଏଜୋମ୍‌ଡଙ୍‌ ଗାମ୍‌ଲେ ସିଟିନ୍‌ ଇଡ୍‌ଲେ ଆମଙଞ୍ଜି ଏଆପ୍ପାୟ୍‌ବାଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ ପୁର୍ବାନ୍‌ ମା ସିଲଡ୍‌ ଡିଲେ ଗଡ଼ାରେଙନ୍‌ ମୋସାନ୍‌ ଆ ବନାଁୟ୍‌ବର୍‌ ଅନପ୍ପୁଙ୍‌ବରନ୍‌ ଡେତେ, ଆରି ଡିଲେ ଲୋଲୋନେ ଡିନ୍ନାଇଙନ୍‌ ରନୁକ୍କୁସିଂରେଙନ୍‌ ତି ଆ ବନାଁୟ୍‌ବର୍‌ ପଡ଼େନେନ୍‌ ଡେତେ ।” ");
INSERT INTO juy_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ସିଲତ୍ତେ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି, ପାପୁର୍‌ମରଞ୍ଜି ଡ ମଣ୍ଡଡ଼ିନ୍‌ ଆ ମନ୍‌ରାଜି ଅଡ଼୍‌କୋଞ୍ଜି ସରିନ୍‌ ମାୟ୍‌ଲନ୍‌ କଡାଡ଼ିଡାଲନ୍‌ ବୋଞାଙଞ୍ଜି ଆମଙ୍‌ଲୋଙ୍‌ ଆମ୍ମୁଙ୍‌ଗଡ୍‌ମରନ୍‌ ବର୍ସବା ଗାମ୍‌ଲେ ଆରୋଡ୍ଡେତେଞ୍ଜି ଜିଉଦାନ୍‌, ଆରି ସିଲାନ୍‌ଆଡଙ୍‌ ସେଡାଡାଲେ ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ସରିନ୍‌ ଅନ୍ତିଅକିଆନ୍‌ ଆପ୍ପାୟେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ଆରି, ଆନିଞ୍ଜି ଏନ୍ନେଲେ ଇଡ୍‌ଲେ ଆସିଲୋଙଞ୍ଜି ଆପ୍ପାୟେଞ୍ଜି; “ଇନ୍‌ଲେନ୍‌ ଅନାପ୍ପାୟ୍‌ ଞଙ୍‌ନେମରଞ୍ଜି ଡ ପାପୁର୍‌ ବୋଞାଙଞ୍ଜି, ଅନ୍ତିଅକିଆନ୍‌, ସିରିଆନ୍‌ ଡ କିଲିକିଆଲୋଙନ୍‌ ଆଡ୍ରକୋତନେଞ୍ଜି ଏର୍‌ଜିଉଦି ବୋଞାଙ୍‌ ତନାନଞ୍ଜିଆଡଙ୍‌ ଏଲୋମ୍‌ତବେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ଅମଙ୍‌ଲୋଙ୍‌ଲେନ୍‌ ସିଲଡ୍‌ ଲାଙ୍‌ଲେଡ୍‌ ମନ୍‌ରାଞ୍ଜି ଡୁଙ୍‌ଲନ୍‌ ଜିର୍ରେ ଅମଙ୍‌ବେନ୍‌ ଇୟ୍‌ଲୋଙ୍‌ ଇୟ୍‌ଲେ, ଅଙ୍ଗାତେ ଇନ୍‌ଲେନ୍‌ ଆମ୍ବେଞ୍ଜିଆଡଙ୍‌ ଏଃବ୍ବାଁୟ୍‌ଲବେନ୍‌ ତି ଆ ବର୍ନେଜି ବର୍ରନ୍‌ ଆମ୍ୱେଞ୍ଜିଆଡଙ୍‌ ଇୟ୍‌ତାୟ୍‌ ବାଉଲ୍ଲି ଏମ୍ମେବେଞ୍ଜି ଗାମ୍‌ଲେ ଇନ୍‌ଲେନ୍‌ ଏଅମ୍‌ଡଙ୍‌ଲାୟ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ତିଆସନ୍‌ ଇନ୍‌ଲେଞ୍ଜି କଡାଡ଼ିଡାଲନ୍‌ ଆବବୁଡ୍ଡିନ୍‌ ଏମ୍ମେଡାଲନ୍‌ ମନ୍‌ରାନ୍‌ ସେଡାଡାଲେ, ଡନୁଙ୍‌ୟମ୍‌ ବୋଞାଙ୍‌ଲେଞ୍ଜି ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ସରିନ୍‌ ଆନିଞ୍ଜିଆଡଙ୍‌ ଅମଙ୍‌ବେନ୍‌ ଏଆପ୍ପାୟ୍‌ଲାଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ଆନିଞ୍ଜି ପ୍ରବୁ ଜିସୁ କ୍ରିସ୍ଟନ୍‌ ଆଞୁମ୍‌ ଆସନ୍‌ ଆନମେଙଞ୍ଜି ମୁର୍ସେଡମେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ତିଆସନ୍‌ ଇନ୍‌ଲେନ୍‌ ଜିଉଦାନ୍‌ ଡ ସିଲାନ୍‌ଆଡଙ୍‌ ଏଆପ୍ପାୟ୍‌ଲାୟ୍‌, ଇନ୍‌ଲେନ୍‌ କେନ୍‌ ଏରିଡ୍‌ଲାଞନ୍‌ ଆ ବର୍ନେଜି ଆନିଞ୍ଜି ଅମଙ୍‌ବେନ୍‌ ଇୟ୍‌ତାୟ୍‌ କଡାଡ଼ିବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ଇନିଆସନ୍‌ଗାମେଣ୍ଡେନ୍‌ କେନ୍‌ ଏନ୍ନେଲେ ସନାୟ୍‌ସାୟ୍‌ ଡନଙ୍‌ଡଙଞ୍ଜି ତୁମ୍‌ ଏଇଡ୍‌ଲାୟ୍‌, ଗୋଗୋୟ୍‌ ଆରି ବାଉଲ୍ଲି ଅଃନ୍ନେମ୍ମେବୋଜି ଗାମ୍‌ଲେ ମଡ଼ିର୍‌ ପୁରାଡ଼ାନ୍‌ ଡ ଇନ୍‌ଲେଞ୍ଜି ଏବ୍‌ଡିସୟ୍‌ଲାୟ୍‌; ");
INSERT INTO juy_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","କୋଙ୍‌ଡାଜନ୍‌ ଆଞୁମ୍‌ଲୋଙ୍‌ ଆରମଙ୍‌ତେଞ୍ଜି ଏର୍‌ମଡ଼ିର୍‌ ଜନୋମ୍‌ଜୋମଞ୍ଜି ଏଜୋମ୍‌ଡଙ୍‌, ମିଞାମନ୍‌ ଏଜୋମ୍‌ଡଙ୍‌, ଲମ୍ମସଙ୍କାଡାଲେ ଆର୍ରବ୍ବୁତେଞ୍ଜି ଆ ଜନ୍ତୁଜି ଆ ଜେଲୁ ଏଜୋମ୍‌ଡଙ୍‌ ଆରି ଜୋଣ୍ଡଡ଼ା କାବ୍ବାଡ଼ାନ୍‌ ଏଲୁମ୍‌ଡଙ୍‌ । କେନ୍‌ଆତେଜି ସିଲଡ୍‌ ସବ୍‌ଙାୟ୍‌ଲନ୍‌ ଏଡକୋଲନ୍‌ ଡେନ୍‌, ଆମ୍ୱେଞ୍ଜି ଆସନ୍‌ ମନଙ୍‌ ଡେତେ । ଆସୁକ୍କା ଡକୋନାବା ।” ");
INSERT INTO juy_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ସିଟିନ୍‌ ଆପ୍ରାଙେଞ୍ଜି ଆ ମନ୍‌ରାଜି ତେତ୍ତେ ସିଲଡ୍‌ ଅନ୍ତିଅକିଆନ୍‌ ଜିରେଞ୍ଜି କି ତେତ୍ତେ ଆ ମନ୍‌ରାଜି ଇୟ୍‌ଲେ ଅବ୍‌ରୁକ୍କୁଏଜି, ସିଲଡ୍‌ଲ୍ଲନ୍‌ ଆସିଲୋଙଞ୍ଜି ସିଟିନ୍‌ ଇୟ୍‌ଲେ ତିୟେଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ଆନିଞ୍ଜି ତି ସିଟିନ୍‌ ପଡ଼େଡାଲନ୍‌ ଉୟୁବେଞ୍ଜି କି ସର୍ଡାଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଜିଉଦାନ୍‌ ଡ ସିଲାନ୍‌ ଆନିଞ୍ଜି ପୁର୍ବାଃତେ ବର୍ନେମର୍‌ଜି, ତିଆସନ୍‌ ଆନିଞ୍ଜି ଆନ୍ତିଅକିଆନ୍‌ ଆ ଡର୍ନେମର୍‌ଜି ଗୋଗୋୟ୍‌ ଅୟମ୍‌ ଜାୟ୍‌ ଜବ୍ର ଞନଙ୍‌ଞଙ୍‌ବରଞ୍ଜି ବାତ୍ତେ ବୋଞାଙ୍‌ ତନାନଞ୍ଜିଆଡଙ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ଲେ ଅବ୍‌ନୁୟୁବେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ଆରି, ଆନିଞ୍ଜି ତେତ୍ତେ ବସନ୍ନେଃ ଡକୋଲଞ୍ଜି କି ଅଙ୍ଗା ମନ୍‌ରାଜି ଆନିଞ୍ଜିଆଡଙ୍‌ ଆପ୍ପାୟ୍‌ଲାଜି ଆମଙଞ୍ଜି ୟର୍ନେନ୍‌ ଆସନ୍‌ ବୋଞାଙଞ୍ଜି ଆମଙ୍‌ ସିଲଡ୍‌ ଉଗୁରିୟ୍‌ ଅବ୍‌ଜୋଞ୍ଜୋନ୍‌ଲଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ବନ୍‌ଡ ସିଲାନ୍‌ ତେତ୍ତେ ଡକୋନେନ୍‌ ସାଜେନ୍‌ । ");
INSERT INTO juy_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ଆରି, ପାଓଲନ୍‌ ଡ ବର୍ନବାନ୍‌ ଅନ୍ତିଅକିଆନ୍‌ ଡକୋଡାଲନ୍‌ ଆନ୍ନାମରଞ୍ଜି ସରିନ୍‌ ନିୟ୍‌ ମାୟ୍‌ଲନ୍‌ ଜବ୍ର ମନ୍‌ରାଜି ଆମଙ୍‌ ମନଙ୍‌ବରନ୍‌ ଞନଙନ୍‌ ତିୟ୍‌ଲେ ଅପ୍ପୁଙ୍‌ବରେଞ୍ଜି । ");
INSERT INTO juy_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ଡିଅଙ୍ଗା ଡିନ୍ନା ଡକୋଡାଲନ୍‌ ପାଓଲନ୍‌ ବର୍ନବାନ୍‌ଆଡଙ୍‌ ବରେନ୍‌, “ୟାଆ, ଇନ୍‌ଲେଞ୍ଜି ଅଙ୍ଗା ଅଙ୍ଗା ଆ ଗଡ଼ାରେଙ୍‌ ପ୍ରବୁନ୍‌ ଆ ମନଙ୍‌ବର୍‌ ଅପ୍ପୁଙ୍‌ବର୍ରବୋ, ତି ଆ ଗଡ଼ାରେଙ୍‌ ନମିଞେନ୍‌ ଏୟର୍‌ନେ କି, ତେତ୍ତେ ଆ ବୋଞାଙ୍‌ଜି ଏମାୟ୍‌ନାଜି, ଆରି ଆନିଞ୍ଜି ଏଙ୍ଗାଗୋ ଡକୋଜି ଏଗିୟ୍‌ନାଜି ।” ");
INSERT INTO juy_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ସିଲତ୍ତେ ବର୍ନବାନ୍‌, ମ