﻿USE sofia;
DROP TABLE IF EXISTS sofia.jum_vpl;
CREATE TABLE jum_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jum_vpl WRITE;
INSERT INTO jum_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Wääna Jooŋ ïïjjenee kä naŋŋä polloŋ ke ŋommañ ye, ");
INSERT INTO jum_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","nänṭä ladaŋ aŋ batta cääygene biilke, aŋ mïïllä kul piik agee kä ääton wic, aŋ Wääktäŋ Jooŋ ken laay piik witin. ");
INSERT INTO jum_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Aŋ Jooŋ jaajjin ogo, “Dalä bownu wäätï!” Aŋ bownu wäättä. ");
INSERT INTO jum_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Aŋ Jooŋ bownu yoorre ŋeraŋ, aŋ Jooŋ bownu kiimme gïtï ke mïïllä. ");
INSERT INTO jum_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Aŋ Jooŋ bownu äkkene ogo, “Äŋ jïñe.” Aŋ mïïllä äkkene ogo, “Wïïrïn jïñe.” Aŋ biigin ti ḍakkä aŋ tïṇṇäŋänä äätin aŋ a nïïnnä kä keelok. ");
INSERT INTO jum_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Aŋ Jooŋ jaajjin ogo, “Dalä kewnä wäätï ṭeejjük piitti, aŋ wäätï a waan piik ke piik.” ");
INSERT INTO jum_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Aŋ Jooŋ näŋŋä kewnä, aŋ piik yek mä ïñïnä ke piik yek mä ñaaloŋŋu kiimme gïtï. Aŋ wäättä. ");
INSERT INTO jum_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Aŋ kewnä mä ñaaloŋŋu äkki Jooŋ ogo polloŋ. Aŋ biigin ti ḍakkä aŋ tïṇṇäŋänä äätin aŋ a nïïnkä kä yew. ");
INSERT INTO jum_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Aŋ Jooŋ jaajjin ogo, “Piik yaaka ïñï polloŋ ŋoy ye, yoken ḍüljï nänṭä keellä, aŋ nänṭä ïwon üüko woo.” Aŋ wäättä. ");
INSERT INTO jum_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Aŋ Jooŋ nänṭä ïwon äkkene ogo ŋommañ, aŋ nänṭ'a piik yoken agene kä ḍülgïn ye, äkkene ogo wiykä mäyken. Aŋ yoori Jooŋ aŋan ŋeraŋ. ");
INSERT INTO jum_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Aŋ Jooŋ jaajjin ogo, “Dalä wakkä garkä yül ŋommañ wic, aŋ gidok ṭulgen aŋ äcä käwkä, aŋ jengä gidok ṭulgen aŋ äcä käwkä daa kä biilken.” Aŋ wäättä. ");
INSERT INTO jum_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Aŋ ŋommañ wiñe yüllü kä wakkä garkä aŋ gidok ṭulgen aŋ äcä käwkä, aŋ jengä gidok ṭulgen ke käwken daa kä biilken. Aŋ yoori Jooŋ aŋan ŋeraŋ. ");
INSERT INTO jum_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Aŋ biigin ti ḍakkä aŋ tïṇṇäŋänä äätin aŋ a nïïnkä kä ḍäk. ");
INSERT INTO jum_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Aŋ Jooŋ jaajjin ogo, “Dalä wakkä bowku wäätï ñaalok polloŋ jï kïpï gïtï äŋ jïñe ke wïïrïn jïñe aŋ nüütï waadgä ke nïïnkä ke yuungu. ");
INSERT INTO jum_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Aŋ dalä waak bowku wäätï ñaalok polloŋ jï aŋ dïïkïdï ïñï ŋommañ wic.” Aŋ wäättä. ");
INSERT INTO jum_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Aŋ Jooŋ näŋŋä waak yaaka yäwaŋ dïïkïdï ïñï ye, kä yewwe. Bownu yaana tälaŋ ye, ken tïïcï äŋ jïñe, aŋ bownu yaana ḍeeḍaŋ ye, ken tïïcï wïïrïn jïñe. Aŋ cäänna Jooŋ kirkä naŋŋe. ");
INSERT INTO jum_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Aŋ iken ḍooci Jooŋ ñaalok polloŋ jï dïïkïdï ïñï ŋommañ wic, ");
INSERT INTO jum_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","aŋ tïïcï äŋ jïñe ke wïïrïn jïñe, aŋ kïpï gïtï bownu ke mïïllä. Aŋ yoori Jooŋ aŋan ŋeraŋ. ");
INSERT INTO jum_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Aŋ biigin ti ḍakkä aŋ tïṇṇäŋänä äätin aŋ a nïïnkä kä ŋan. ");
INSERT INTO jum_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Aŋ Jooŋ jaajjin ogo, “Dalä piik kümok kä waak'a a üdïn ye, aŋ dalä ḍïïrgä päyok ŋommañ wic ke ñaalok polloŋ jï.” ");
INSERT INTO jum_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Aŋ Jooŋ näŋŋä wakkä piik gïtken mäyken yaaka ḍoŋgaŋ ye, aŋ waak'a a üdïn layok ye, yaaka küümgenee piik gïtken ye, aŋ cäänna ḍïïrgä yaaka päydïdï polloŋ jï ye. Aŋ yoori Jooŋ aŋan ŋeraŋ. ");
INSERT INTO jum_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Aŋ ŋüülkï Jooŋ aŋ kiinne ogo, “Giide aŋ ḍiire aŋ piik yaaka wiykä mäyken gïtï ye küümge. Aŋ dalä ḍïïrgä ḍirä ŋommañ wic.” ");
INSERT INTO jum_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Aŋ biigin ti ḍakkä aŋ tïṇṇäŋänä äätin aŋ a nïïnkä kä duuc. ");
INSERT INTO jum_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Aŋ Jooŋ jaajjin ogo, “Ŋommañ äcä woo waak'a a üdïn ye, kä biilken, ḍigärgä ke waak'a muulu ïñï ye ke wakkä luum jïñe kä biilken.” Aŋ wäättä. ");
INSERT INTO jum_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Aŋ Jooŋ näŋŋä wakkä luum jïñe daa kä biilken, aŋ ḍigärgä daa kä biilken, ke waak'a muulu ïñï ye, muure kä biilken. Aŋ yoori Jooŋ aŋan ŋeraŋ. ");
INSERT INTO jum_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Aŋ Jooŋ jaajjin ogo, “Mänbaan naŋïn kä biilko aŋ äälïnkä, aŋ dale yak wiykä mäyken gïtken, ke ḍïïrgä polloŋ jïñe, ke ḍigärgä, ke waak luum jïñe, ke waak'a muulu ïñï ŋommañ wic ye, müktü mänbaan muure.” ");
INSERT INTO jum_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Aŋ Jooŋ mänbaan naŋŋe kä biilke. Kä biilkä yeeke ike Jooŋ mänbaan naŋŋe. Naŋŋe oon ke iiŋ. ");
INSERT INTO jum_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Aŋ ŋüülkï Jooŋ aŋ kiinne ogo, “Giide aŋ ḍiire aŋ ŋommañ wiñe küümge aŋ tïïje. Aŋ yak wiykä mäyken, ke ḍïïrgä polloŋ, ke waak'a muulu ïñï ŋommañ wic ye, muureen müge.” ");
INSERT INTO jum_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Aŋ Jooŋ jaajjin ogo, “Ikee iññe wakkä garkä yaaka gidok ṭulgen aŋ ääcïdï woo käwkä ŋommañ wic ye, aŋ jengä yaaka gidok ṭulgen aŋ ääcïdï woo käwkä ye, muure a wakkä äämkä yeekic. ");
INSERT INTO jum_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Aŋ wakkä luum jïñe yaaka ŋommañ wic ye, muureen ke ḍïïrgä polloŋ jïñe ke waak'a layok ŋommañ wic cääygene wääktäŋ ye, iññä wakkä garkä muureen a waak äämkä.” Aŋ wäättä. ");
INSERT INTO jum_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Aŋ Jooŋ wakkä yaaka naŋŋe ye, yoorre muureen ŋeraŋ kuckon. Aŋ biigin ti ḍakkä aŋ tïṇṇäŋänä äätin aŋ a nïïnkä kä ḍüügük. ");
INSERT INTO jum_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Naŋŋä polloŋ ke ŋommañ ke waak'a bilteen ye ḍaŋŋä. ");
INSERT INTO jum_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Aŋ Jooŋ ḍaŋŋä kä naŋŋä wakkä yeeke nïïnnä yaana kä ŋaṭükel ye ti, aŋ yore yïïkkene nïïnnä yaana kä ŋaṭükel ye ti kä nääŋkä yaaka naŋŋe ye muure. ");
INSERT INTO jum_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Aŋ Jooŋ nïïnnä ŋaṭükel ŋüülkene aŋ naŋŋe ladaŋ, kä yaana yore yïïkkeneeda kä ñuugula yen wakkä muure yaaka naŋŋe ye. ");
INSERT INTO jum_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yaanni a gin'a näŋŋä ḍoŋe wääna Pïṭo Jooŋ näŋŋee kä polloŋ ke ŋommañ ye. ");
INSERT INTO jum_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Aŋ jengä muure mor baati ŋommañ wic, aŋ wakkä garkä batta mor yülü woo, nääŋka Pïṭo Jooŋ batta mor tuucee ïñï ñaal ŋommañ wic ye, kä mänbaan bäwe yaana pïïtï ŋommañ wic ye. ");
INSERT INTO jum_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Aŋ ñomuk ku on piik kääjïdï woo ŋommañ jï määtï ŋommañ wiñe muure. ");
INSERT INTO jum_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Aŋ Pïṭo Jooŋ kuññu ŋomgu ŋommañ wic, aŋ naŋŋe a oon, aŋ kütkene umdin wääktäŋ üṇṇü. Aŋ oon üṇṇü. ");
INSERT INTO jum_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Aŋ Pïṭo Jooŋ pïïttä jengä garkä nänṭä battä me ogo Adan ñomuk aŋŋi, aŋ oon yaana naŋŋe ye ḍoocce wïca. ");
INSERT INTO jum_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Aŋ Pïṭo Jooŋ jengä yaaka ŋeraŋ me waŋgen ti aŋ ŋeraŋ ammä ti ye, muure yüülene ñaalok ŋommañ wic, aŋ jaan yaana me iñde üṇṇü ye, cääy ṭeejjük nänṭä garrä, aŋ jaan ŋäjjin ŋerrä ke yiñ cäänna bilti ṭeejjük. ");
INSERT INTO jum_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Aŋ ku on wii kääjïdï woo nänṭä battä me ogo Adan määtï nänṭä garrä, aŋ kïïptïdï gïtï wïca aŋ wäätcïdï ääŋken kä ŋan. ");
INSERT INTO jum_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Yaŋkalaŋ battä me ogo Pecüün, aŋ ike ken kaajit baan mä Hawela jï muure nänṭ'a cääyge tiilgä ye. ");
INSERT INTO jum_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Aŋ tiilgä yek baan yaanja ŋeraŋ. Aŋ jengä pïlkä yaaka ääcete me woo panḍeyni ye, bilti aŋ cäänna pämkä yaaka gäldïdï ŋeraŋ ye bilti wïca. ");
INSERT INTO jum_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Aŋ yäṇtäŋ wii yaŋkalaŋ ogo Jeyüün, aŋ a ike ken kaajit baan mä Küüc jï muure. ");
INSERT INTO jum_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Aŋ yäṇtäŋ wii yaana agene ḍäk ye, battä me ogo Adagiil, aŋ ike ken kaajit Acüür ti kä ñomuk. Aŋ wii yaana wäätcete kä ŋan ye, battä me ogo Puraat. ");
INSERT INTO jum_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Aŋ Pïṭo Jooŋ oon koowne aŋ ḍoocce Adan nänṭä garrä ogo ñuugelee aŋ tïïjje. ");
INSERT INTO jum_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Aŋ Pïṭo Jooŋ oon iingene aŋ kiinni ogo, “Jengä yaaka nänṭä garrä jï ye, amä muure, ");
INSERT INTO jum_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","aŋ jaan yen ŋäjjin ŋerrä ke yiñ ŋana ïkï ämjädä, naana ïkï bi ämjä ye, ïkï bi tüwü a gïtken.” ");
INSERT INTO jum_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Aŋ Pïṭo Jooŋ jaajjin ogo, “Batta ŋeraŋ oon cäwde pare aŋan, näŋgä m'ana ike yüükkütü ti cäwdä ye.” ");
INSERT INTO jum_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Aŋ Pïṭo Jooŋ kuññu ŋommañ aŋ näŋŋä wakkä luum jïñe muure ke ḍïïrgä polloŋ jïñe. Aŋ äckene oon ookcedeeda bi äkke ogoo, aŋ wakkä yaaka a üdïn ye muure yaana bärkänä oon ye, i daa wäätï a yäṇtonḍe. ");
INSERT INTO jum_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Aŋ ḍigärgä muure bääri oon kä yäṇtäŋgenen, ke ḍïïrgä polloŋ jïñe ke wakkä luum jïñe muure. Aŋ ike kä ḍoŋe batta käñon yaana äälene kä ike yüükkütü ti kä cäwdä ye. ");
INSERT INTO jum_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Aŋ Pïṭo Jooŋ oon iññe waŋgin nïïnkä kä pek, aŋ wääna oodene daa ye, ääcin woo ŋiiranḍe yaŋkalaŋ kä keelok aŋ nänṭä yeene paatte waŋ. ");
INSERT INTO jum_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Aŋ Pïṭo Jooŋ näŋŋä iiŋ kä ŋiiran yaana äbe woo oon gunne ti ye, aŋ äckene oon. ");
INSERT INTO jum_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Aŋ oon jaajjin ogo, “Yaanni tiññaŋ a äwnä yen äwgi aŋ a yäŋŋä yen yäŋgi. Aŋ ike bi battä me ogo, ‘iiŋ’ nääŋka äbene daa me woo ‘oon’ ti ye.” ");
INSERT INTO jum_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Aŋ ina ken oon wäyen ke meen daleeda buwin aŋ yore cooṭeeda ti iiŋe ti aŋ wäätene agene gaan keellä yaanna. ");
INSERT INTO jum_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Aŋ ñomuk ku on oon ke iiŋe muuṭuk yoken ladaŋ, aŋ yoken batta a lodgu. ");
INSERT INTO jum_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Aŋ ñomuk ku on wakkä luum jïñe muure yaaka naŋi Pïṭo Jooŋ ye ti, a kaaŋ ken wiñe bïtäraŋ meken gïtï. Aŋ iiŋ taaññe ogo, “A jïñe Jooŋ ikee kiinne ogo ŋana ikee ämje jengä ṭulgen yek nänṭä garrä jï muure?” ");
INSERT INTO jum_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Aŋ iiŋ kaaŋ kiinne ogo, “Jengä ṭulgen yaaka nänṭä garrä jï ye, ikoon ämon, ");
INSERT INTO jum_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","aŋ Jooŋ ikoon kiinnon ogo jaan yaana ṭeejjük yaanja ṭulge ŋana amjon aŋ ŋana tabdoon yok ikoon bi tüwjon.” ");
INSERT INTO jum_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Aŋ iiŋ kiini kaaŋ ogo, “Ikee batta bi tüwe! ");
INSERT INTO jum_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ŋäjjänä Jooŋ ääŋkalaŋ naana ikee bi ämje ye, waŋgic bi pätï woo aŋ ikee bi wääte bata Jooŋ aŋan, ikee ŋäjje ŋerrä ke yiñ.” ");
INSERT INTO jum_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Aŋ yoori iiŋ jaan ṭulge ŋeraŋ ammä ti, aŋ ŋeraŋ me waŋgen ti, aŋ me iñde witin waŋ. Aŋ uṭṭu ṭuule aŋ amme, aŋ cäänna oore äckene aŋ ämjin. ");
INSERT INTO jum_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Aŋ waŋgen pättä woo aŋ ḍuuggen ŋïjï yoken ladaŋ. Aŋ jittä jaan beel bata ŋoommu gitke, aŋ ṭuuri aŋ kümjï teygen ti. ");
INSERT INTO jum_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Aŋ Pïṭo Jooŋ tiiŋji kä yääwe äätä nänṭä garrä jï biigin ti aŋŋi, aŋ oon ke iiŋe Pïṭo Jooŋ ṭärki jengä gïtï nänṭä garrä jï. ");
INSERT INTO jum_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Aŋ Pïṭo Jooŋ oon bärkene aŋ taacce ogo, “Ïkï wali?” ");
INSERT INTO jum_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Aŋ luukke ogo, “Ïkï tiiŋjeneni äätä nänṭä garrä jï, aŋ ika booññu, yori ladaŋ aŋ ika ṭarrä.” ");
INSERT INTO jum_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Aŋ Pïṭo Jooŋ jaajjin ogo, “A ŋaani ken ïkï kiinney ogo yorü ladolat? Ïkï ämjini jaan yaana kollenii kä ogo ŋana ïkï ämjey ina?” ");
INSERT INTO jum_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Aŋ oon jaajjin ogo, “Iiŋ yaana äckanaa kä ina ken ika iñña jaan ṭuule aŋ ika ämjänä.” ");
INSERT INTO jum_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Aŋ Pïṭo Jooŋ iiŋ taaññe ogo, “A ŋaaka ina naŋŋi yaanna?” Aŋ iiŋ jaajjin ogo, “Kaaŋ ika amma ŋïngïn aŋ ika ämjänä.” ");
INSERT INTO jum_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Aŋ Pïṭo Jooŋ kaaŋ kiinne ogo, “Kä nääŋkä yaaka naŋŋi ye, ïkï agä tuumgon, wakkä luum jïñe waadgen ti, ke ḍigärgä ti muure. Aŋ ïkï bi muulu ïñï kä jïñü aŋ ŋomgu ken bi amä yuungu yüükü ti muure. ");
INSERT INTO jum_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Aŋ ika bi ḍuccu yiñ waadgic ti ikee ke iiŋ, ke kaaynic ti. Ike ïkï bi jiibey wïñü ti, aŋ ike bi kääjä ŋubdonḍe ti.” ");
INSERT INTO jum_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Aŋ iiŋ kiinne ogo, “Aŋ bääŋ pillä yüünü bi ŋucku ti naana ïkï laacci ye, aŋ kä pillä ïkï bi giidä merkä. Aŋ ïkï ṭäkä yoku ogo oorü ääto ko jiik yüükü, aŋ ike ken bi a mügdo yüünü.” ");
INSERT INTO jum_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Aŋ Aadam kiinne ogo, “Kä yaana tiiŋŋii kä jiik ïïŋü aŋ ämjinii kä jaan yaana kollenii kä ogo ŋana amjey ye, ŋommañ wiñe a tuumgon kä nääŋkä yüükü. Aŋ ïkï bi ämä kä pillä ñuugulani yüükü ti yuungu muure. ");
INSERT INTO jum_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Aŋ paañ ke küügü bi yülü woo baannü, aŋ ïkï bi ämä wakkä garkä yiil jï. ");
INSERT INTO jum_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Aŋ kä cannä ïkï bi ämä wakkä äämkä yüükü, ke ḍukci ïñï ŋommañ yaana naŋŋenii kä ye ti. Ïkï agä ŋomgu, aŋ ïkï bi ḍukcu ŋommañ jï.” ");
INSERT INTO jum_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Aŋ Aadam iiŋe äkkene ogo Awwa, nääŋka bi wäätee kä a miy yen me muure ye. ");
INSERT INTO jum_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Aŋ Aadam ke iiŋe näŋgi Pïṭo Jooŋ buruŋgu yek gaan aŋ iiŋkeneeda. ");
INSERT INTO jum_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Aŋ Pïṭo Jooŋ jaajjin ogo, “Mänbaan tiññaŋ inni wäättä bata ïkïïn ŋäjjä ŋerrä ke yiñ yaanni. Aŋ tiññaŋ ŋuca nuŋkodo ïnte lajjede aŋ uṭit jaan cäwdä ṭulge aŋ üdït ke cüle.” ");
INSERT INTO jum_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Aŋ ñuuli woo Pïṭo Jooŋ nänṭä garrä jï nänṭ'a battä me ogo Adan ye, ogo ato ŋommañ yaana naŋŋïïdako me ye ñuugele. ");
INSERT INTO jum_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Aŋ mänbaan ñuuli woo Jooŋ nänṭä garrä jï yaana battä me ogo Adan ye, aŋ malaŋŋi teyken yaaka battä me ogo korbïïm ye, tuci Jooŋ cäyok Adan kä ñomuk, aŋ gaaḍal wiñe wïïrde i lemme käl kä maañ tïïcï päy yen jaan cäwdä. ");
INSERT INTO jum_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Aŋ wääna Aadam nïïnnene ke iiŋe Awwa ye, iiŋe laaccä, aŋ giiṇṇä kaygon yeenen battä me ogo Kaayïïn. Aŋ Awwa wääna giiṇṇee kä ye jaajjin ogo, “Kä yüükkïn ti yen Pïṭo ika giiṇṇä oon.” ");
INSERT INTO jum_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Aŋ ŋuccin giiṇṇä määden aŋ äkki ogo Abïïl. Aŋ wääna ḍoŋgene ye, Abïïl ken wäättä aŋŋa kaaydo ḍiik, aŋ Kaayïïn ken aŋŋa pïïto. ");
INSERT INTO jum_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Aŋ nïïnkä yakkalaŋ ti Kaayïïn Pïṭo äckene waak'a pïïṇṇe ye ti. ");
INSERT INTO jum_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Aŋ daa Abïïl äccin ḍiik yeeke ti yaana a kaygon aŋ a caagon ye. Aŋ Abïïl ke gin'a äcce ye, gïmgï Pïṭo kä jon ñamme. ");
INSERT INTO jum_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Aŋ ike Kaayïïn ke gin'a äcce ye, batta agee kä gïmgïnï. Aŋ Kaayïïn pennä aŋ ñome ñerre yok kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Aŋ Kaayïïn taaji Pïṭo ogo, “Ïkï agä penon ina? Aŋ ñomü ñerdä ina? ");
INSERT INTO jum_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Aŋ naana ïkï näŋŋi nääŋk'a ŋeraŋ ye ïkï bi gïmgeni. Aŋ ïkï naana batta näŋdä nääŋk'a ŋeraŋ ye, nääŋkä yaackä ïkï bi keeygi äntüke ti, aŋ bi wäätï ḍoŋü ti, aŋ tïïjä bonu yokïn ŋana bääggädä.” ");
INSERT INTO jum_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Aŋ Kaayïïn määden Abïïl kiinne ogo, “Juwu atï woo yiil jï.” Aŋ wääna ḍakkene ti yiil jï ye, i Kaayïïn yore yelle aŋ määden näŋŋe ḍok. ");
INSERT INTO jum_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Aŋ Pïṭo Kaayïïn taaññe ogo, “Määdic Abïïl wali?” Aŋ luugi Kaayïïn ogo, “Kuju. A ika ken tïïcä määdo?” ");
INSERT INTO jum_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Aŋ taaji Pïṭo ogo, “A ŋaaka ina naŋŋi yaanna? Yïmgä määdic yääwïdï ïñï ŋommañ wic ika ti. ");
INSERT INTO jum_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Aŋ tiññaŋ ïkï agä tuumgon aŋ ïkï agä ñooṭon woo ŋommañ yaana poŋe kupkene aŋ gïmmïn kä yïmgä määdic ïṇtü ti ye. ");
INSERT INTO jum_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ïkï batta bi iñgi ŋommañ käwkä ŋerkä naana puuyu ye, aŋ ïkï bi laayä kamat nänṭä yüünü bi baati ŋommañ wic.” ");
INSERT INTO jum_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Aŋ Kaayïïn Pïṭo kiinne ogo, “Jooññu yeeni tälaŋ batta lïïldä kä waaññä. ");
INSERT INTO jum_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tiññaŋ ika ñooṭṭaa woo ŋommañ wic aŋ ñomü ṭukki woo ika ti, aŋ wäättana ika laayä i nänṭä yeeni baati ŋommañ wic, aŋ m'ana ika bi kaña ye, ika bi näga ḍok!” ");
INSERT INTO jum_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Aŋ kiini Pïṭo ogo, “Ba'ay batta aŋan! Naana m'ana ïkï nägey ḍok ye, bi wanä ääŋke kä ŋaṭükel bata yaana näŋŋey kä ḍok ye.” Aŋ Pïṭo Kaayïïn näŋgene gin'a ŋïcte daa kä me ye, nuŋko ŋana näkte daa ḍok m'ana ike kañgä ye. ");
INSERT INTO jum_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Aŋ Kaayïïn aŋgin yore Pïṭo ñome ti, aŋ attä cääjjin ŋommañ mä Nuut ti, Adan ti kä ñomuk. ");
INSERT INTO jum_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Aŋ Kaayïïn nïngin ke iiŋe aŋ laaccä aŋ gittä minneni oone battä me ogo Anook. Aŋ bättä baan aŋ äkkene ogo Anook kä yäṇtäŋ minneni yeene. ");
INSERT INTO jum_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Aŋ Anook gittä Iraat, aŋ Iraat gittä Maaweel, aŋ Maaweel gittä Matüceel, aŋ Matüceel gittä Lamak. ");
INSERT INTO jum_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Aŋ Lamak ḍiññä määngä kä yewwe, yaŋkalaŋ battä me ogo Aada aŋ yaŋkalaŋ ogo Cïlla. ");
INSERT INTO jum_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aŋ Aada gittä Yabal, aŋ ike ken a wäy yen m'aka cäyok kä keeññi aŋ kääjï ḍiik ye. ");
INSERT INTO jum_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Aŋ määden battä me ogo Yübal, a m'ana ïïjjïn ti keemmä gerger ke küüṇṇü kïllïŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Aŋ Cïlla gittä minneni oone battä me ogo Tubalkaayïïn, aŋ a ike ken yaacänä yok kä goññu kaykä yek bïlkä muure. Tubalkaayïïn käwen battä me ogo Naama. ");
INSERT INTO jum_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Aŋ Lamak määngä yeeke kiinne ogo, “Aada ke Cïlla tiiŋe, ikee määngä Lamak jiik yeeki tiiŋe. M'ana ika iñña yok kuuŋ ye näŋŋä ḍok, a durñu yaana ika ickana ye. ");
INSERT INTO jum_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Aŋ naana m'ana näkkä Kaayïïn ye wangä me ääŋke kä ŋaṭükel, aŋ m'ana bi näkï Lamak ye, bi wangä me ääŋke caykä kä ŋaṭükel witken kä ŋaṭükel.” ");
INSERT INTO jum_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Aŋ Aadam ŋuca nïngïn ke iiŋe, aŋ gittä minneni oone. Aŋ äkki meen ogo Ceet aŋ jaajjin ogo, “Jooŋ ika iñña minneni rätkana kä nänṭä Abïïl yaana nägi ḍuuggin Kaayïïn ye.” ");
INSERT INTO jum_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Aŋ wääna Ceet tällee kä ye gittä minneni aŋ äkkene ogo Ïnooc. Aŋ yuungu yaakca ti mäbaan wäättana jujjin kä maaŋŋä yäṇtäŋ Pïṭo. ");
INSERT INTO jum_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","A perrä yen kaaynä Aadam ikki. Wääna Jooŋ näŋŋee kä mänbaan ye, naŋŋe kä biilkä yeeke ike. ");
INSERT INTO jum_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Naŋŋe oon ke iiŋ aŋ ŋüülkene, aŋ wääna naŋŋeeda kä ye, äkkene ogo mänbaan. ");
INSERT INTO jum_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Aŋ wääna Aadam cääynee yuungu kä 130 ye, gittä minneni äälene kä beel bata ike, aŋ äkkene ogo Ceet. ");
INSERT INTO jum_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Aŋ wääna Ceet giidene daa me ye, Aadam cääynä yuungu 800, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Aŋ Aadam yuunge muure yaaka cääynee kä ŋommañ wic ye, a 930 aŋ tüwnü. ");
INSERT INTO jum_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Aŋ wääna Ceet cääynee yuungu kä 105 ye, gittä Ïnooc. ");
INSERT INTO jum_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Aŋ wääna Ïnooc giidene daa me ye, Ceet cääynä yuungu 807, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Aŋ Ceet yuunge muure yaaka cääynee kä ŋommañ wic ye, a 912 aŋ tüwnü. ");
INSERT INTO jum_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Aŋ wääna Ïnooc cääynee yuungu kä 90 ye, gittä Kinaan. ");
INSERT INTO jum_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Aŋ wääna Kinaan giidene daa me ye, Ïnooc cääynä yuungu 815, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Aŋ Ïnooc yuunge muure yaaka cääynee kä ŋommañ wic ye, a 905 aŋ tüwnü. ");
INSERT INTO jum_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Aŋ wääna Kinaan cääynee yuungu 70 ye, gittä Maalla. ");
INSERT INTO jum_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Aŋ wääna Maalla giidene daa me ye, Kinaan cääynä yuungu 840, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Aŋ Kinaan yuunge muure yaaka cääynee kä ŋommañ wic ye, a 910 aŋ tüwnü. ");
INSERT INTO jum_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Aŋ wääna Maalla cääynee yuungu 65 ye, gittä Yaarit. ");
INSERT INTO jum_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Aŋ wääna Yaarit giidene daa me ye, Maalla cääynä yuungu 830, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Aŋ Maalla yuunge muure yaaka cääynee kä ŋommañ wic ye, a 895 aŋ tüwnü. ");
INSERT INTO jum_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Aŋ wääna Yaarit cääynee yuungu 162 ye, gittä Ïdrïïc. ");
INSERT INTO jum_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Aŋ wääna Ïdrïïc giidene daa me ye, Yaarit cääynä yuungu 800, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Aŋ Yaarit yuunge muure yaaka cääynee kä ŋommañ wic ye, a 962 aŋ tüwnü. ");
INSERT INTO jum_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Aŋ wääna Ïdrïïc cääynee yuungu 65 ye, gittä minneni oone battä me ogo Matüceela. ");
INSERT INTO jum_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Aŋ wääna Matüceela giidene daa me ye, Ïdrïïc baaddin päy Jooŋ yuungu 300, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Aŋ Ïdrïïc yuunge muure yaaka cääynee kä ŋommañ wic ye, a 365. ");
INSERT INTO jum_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Aŋ Ïdrïïc baaddin päy Jooŋ, aŋ wïïccä ïñï kä yaana koowene daa Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Aŋ wääna Matüceela cääynee yuungu 187 ye, gittä Lamak. ");
INSERT INTO jum_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Aŋ wääna Lamak giidene daa me ye, Matüceela cääynä yuungu 782, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Aŋ Matüceela yuunge muure yaaka cääynee kä ŋommañ wic ye, a 969 aŋ tüwnü. ");
INSERT INTO jum_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Aŋ wääna Lamak cääynee yuungu 182 ye, gittä minneni oone. ");
INSERT INTO jum_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Aŋ äkkene ogo Noo. Aŋ ike jaajjin ogo, “Yaanni ïkïïn bi ïñïn yïïktäŋ kä bääŋ yen ñuugulani yek ïnko, ŋommañ yaana tuumi Pïṭo yaanni ye ti.” ");
INSERT INTO jum_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Aŋ Lamak wääna Noo giidene daa me ye, Lamak cääynä yuungu 595, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Aŋ Lamak yuunge muure yaaka cääynee kä ŋommañ wic ye, a 777 aŋ tüwnü. ");
INSERT INTO jum_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Aŋ wääna Noo yuunge aŋŋene 500 ye, gittä Caam ke Haam ke Yaapic. ");
INSERT INTO jum_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Aŋ wääna me jujjene kä ḍiirin ŋommañ wic, aŋ gittene kä ṭulgu ye, ");
INSERT INTO jum_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","malaŋŋi Jooŋ ṭulgu mäbaan yoori ŋeraŋ, aŋ iken wäkkä yaaka daa reeni ye aŋ ḍeyi. ");
INSERT INTO jum_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Aŋ Pïṭo jaajjin ogo, “Wääktäŋ yeeni batta bi cääy mänbaan ti ke on bata yuungu yaakca ti, ike a mänbaan yaana tüwït ye, aŋ yuungu yeeke batta bi käälcï woo 120.” ");
INSERT INTO jum_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Nïïnkä yaakca ti ŋommañ wic ook yakkalaŋ ḍoŋgaŋ aŋ teyaŋ, nääŋka malaŋŋi Jooŋ ḍiññene ṭulgu mäbaan aŋ gittene merkä ye. Aŋ a iken ken a mä teykä ñomuk ku on yaaka yäṇtäŋgenen pakä me ye. ");
INSERT INTO jum_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Aŋ Pïṭo yiñ mänbaan yoorre ḍiirin ŋommañ wic, aŋ yoorre jiik'a naŋtä juuggen ti ye, a yaacken muure kamat. ");
INSERT INTO jum_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Aŋ Pïṭo jone lüüjjïn kä yaana näŋŋee kä mänbaan ŋommañ wic ye, aŋ ike nüüjjïn jone ti. ");
INSERT INTO jum_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Aŋ Pïṭo jaajjin ogo, “Mänbaan yaana naŋŋä ŋommañ wic ye, üülü wic, mänbaan ke ḍigärgä ke waak'a layok ye, ke ḍïïrgä polloŋ jïñe, ika joni nüüjjïn kä yaana naŋŋä daa kä ye.” ");
INSERT INTO jum_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Aŋ a Noo ken käññä ŋerrä Pïṭo ti. ");
INSERT INTO jum_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Wakkä yaaka näŋŋä ḍuuggen yuungu Noo ti ke mä yeeke ye. Ñomuk ku on kilkä Noonu ti, a Noo ken a men wotconḍe aŋ ken ḍoŋe ladaŋ me gïtï. Aŋ Noo ken baadit päy Jooŋ. ");
INSERT INTO jum_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Aŋ Noo gittä merkä kä ḍäk. Yäṇtäŋgenen ogo Caam, aŋ Haam, aŋ Yaapic. ");
INSERT INTO jum_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Aŋ ŋommañ yaaññä Jooŋ ñome ti, aŋ ŋommañ küümmü kä nääŋkä yaackä. ");
INSERT INTO jum_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Aŋ ŋommañ wiñe yoori Jooŋ yaaññä, nääŋka mäbaan muure nääŋken yejgene ye. ");
INSERT INTO jum_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Aŋ Noo kiini Jooŋ ogo, “Nïïnkä mäbaan tiññaŋ düüñïn ñomi ti, nääŋka ŋommañ wiñe küümgene daa kä nääŋken yaacken ye. Aŋ ika ṭäkä iken cüccüdü woo ke ŋommañ. ");
INSERT INTO jum_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Aŋ näŋä kuun yen jaan yaana battä me ogo japar ye. Aŋ kuun näŋgä jï äärgä, aŋ paadä jok kä ḍuŋŋu toolï külok ke ŋäñe ti nuŋko piik ŋana kaaccete ti kuun jï. ");
INSERT INTO jum_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Aŋ naŋä aŋŋi bäyte pääyä kä men buŋe 130, aŋ gäpte men buŋe 25, aŋ külte 15. ");
INSERT INTO jum_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Aŋ kuun näŋgä wiñe aŋ kääl ṭuule wääktäŋ ḍoocci waan wiñe ke teye a men buŋe ṭonṭolle. Aŋ kuun tüke naŋjä kä gunne ti, aŋ kuun jïñe kiibä gïtï, ïñï ke ṭeejjük ke ñaalok. ");
INSERT INTO jum_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Aŋ ika ina tuucudu tääl piik ŋommañ wic, ika cüccüdü woo wakkä yaaka cääygene kä wääktäŋ yoken ti ye, polloŋ ŋoy. Waak'a ŋommañ wic ye, muure tüw. ");
INSERT INTO jum_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Aŋ ika bi ḍuccu jiik ḍoocin ke ïkï. Aŋ ïkï kaacci kuun jï ikee ke merkä yüükü ke ïïŋü aŋ määngä merkä yüükü. ");
INSERT INTO jum_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Aŋ wakkä yaaka a üdïn ye ti muure, ïkï äccä kuun jï kä yew yewni oon ke iiŋ dalä üt ke ïkï. ");
INSERT INTO jum_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ḍïïrgä ti daa kä biilken, aŋ ḍigärgä ti daa kä biilken, aŋ wakkä yaaka layok ŋommañ wic muure ye, daa kä biilken iken bi ätä ïkï ti kä yew yewni kaacï kuun jï üde kä. ");
INSERT INTO jum_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Aŋ kuju wakkä äämkä ti, aŋ ḍülü yokïn ïkï ti, wäätï a wakkä äämkä yüükü ke iken.” ");
INSERT INTO jum_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Aŋ Noo nääŋkä yaaka iingene daa Jooŋ ye, naŋŋe muure a gïtken. ");
INSERT INTO jum_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Aŋ Pïṭo Noo kiinne ogo, “Kaace ke mä än yüükü kuun jï. Yoorru a ïkï parü ken woduwot merkä kil yaakki ti. ");
INSERT INTO jum_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Aŋ kuju ḍigärgä ti oogen kä ŋaṭükel, aŋ määngen ti kä ŋaṭükel yaaka ladaŋ ye ti, aŋ ḍigärgä yaaka batta ladaŋ ye ti, kuju kä yew yewni oon ke iiŋ. ");
INSERT INTO jum_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Aŋ ke ḍïïrgä ti kuju oogen kä ŋaṭükel aŋ määngen kä ŋaṭükel, nuŋko kaaynen cääyene kä ŋommañ wic muure. ");
INSERT INTO jum_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Aŋ nïïnkä kä ŋaṭükel ika bi tuucu ñaal ŋommañ wic aŋ nääkä nïïnkä caykä kä ŋan wïrdïnnï gïtken ke äŋkä gïtken. Aŋ waak'a ääynä ŋommañ wic ye, bi cücü woo muure.” ");
INSERT INTO jum_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Aŋ Noo nääŋkä yaaka iingene daa kä Pïṭo ye, naŋŋe muure. ");
INSERT INTO jum_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Aŋ wääna piik yiiŋene kä tääl ŋommañ wic ye, Noo yuunge kä 600. ");
INSERT INTO jum_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Aŋ Noo kaaccä kuun jï ke iiŋe ke merkä yeeke ke määngä merkä yeeke, üdene kä piik tääl. ");
INSERT INTO jum_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Aŋ ḍigärgä yaaka ladaŋ ye, ke yaaka batta ladaŋ ye, ke ḍïïrgä ke wakkä yaaka layok ŋommañ wic ye muure, ");
INSERT INTO jum_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","waak'a kaaccä kuun jï ke Noo ye, kä yew yewni, oon ke iiŋ, bata yaana Noo kiinene daa kä Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Aŋ wääna nïïnkä kä ŋaṭükel ḍakkene ye, piik tääl üükïn woo ŋommañ wic. ");
INSERT INTO jum_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Aŋ wääna Noo yuunge wäättene kä 600 ye, paan yew ti, nïïnkä caay witken kä ŋaṭükel ti, piik waŋgen püürïn woo ïñï ŋommañ jï, aŋ cäänna ñaal puukin ïñï ñaalok polloŋ jï. ");
INSERT INTO jum_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Aŋ ñaal puukin ïñï ŋommañ wic nïïnkä caykä kä ŋan wïrdïnnï gïtken ke äŋkä gïtken. ");
INSERT INTO jum_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Aŋ nïïnnä yaanja ti ken kaaccene Noo kuun jï, ike ke iiŋe ke merkä yeeke Caam ke Haam ke Yaapic ke määngä yeeken. ");
INSERT INTO jum_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Iken ke waak luum jïñe daa kä biilken ke ḍigärgä muure ke waak'a muulu ïñï ŋommañ wic ye, ke ḍïïrgä yaaka päydïdï ye muure daa kä biilken. ");
INSERT INTO jum_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Aŋ wakkä yaaka cääygene kä yoken aŋ wääkï a üdïn ye, muure äätin kaaccä kuun jï kä yew yewni ke Noo. ");
INSERT INTO jum_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Aŋ bata yaana Jooŋ Noo iingenee da kä ye, waak äcce kuun jï oogen ke määngen. Aŋ Noo üüljï tüggïn Pïṭo kuun jï. ");
INSERT INTO jum_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Aŋ tääl yiiŋin nïïnkä caykä kä ŋan ŋommañ wic, aŋ piik üüttïn kä ḍiirin. Aŋ kuun ääri ñaalok piik ŋommañ wic. ");
INSERT INTO jum_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Aŋ piik üüttïn kä ḍiirin ŋommañ wic, aŋ kuun wäättan taamit ñaalok piik witin. ");
INSERT INTO jum_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Aŋ piik ḍiirin kä yaac ŋommañ wic, aŋ pämkä mäyken muure yaaka polloŋ ŋoy ye, äätte witin. ");
INSERT INTO jum_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Aŋ piik yoken küülï ñaalok, aŋ pämkä äädi witin ïñï men buŋe kä ŋaṭükel. ");
INSERT INTO jum_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Aŋ waak'a layok ŋommañ wic a üdïn ye tüwgïn muure, ḍïïrgä ke ḍigärgä ke wakkä luum jïñe ke waak'a muulu ïñï ye, ke mäbaan muure. ");
INSERT INTO jum_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Wakkä yaaka cäyok ŋommañ ïwon wic wääkï a üdïn ye, tüwgïn muure. ");
INSERT INTO jum_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Aŋ wakkä yaaka cäyok ŋommañ wic a üdïn ye, mäbaan ke ḍigärgä ke waak luum jïñe ke ḍïïrgä polloŋ jïñe cücce woo Pïṭo muure. Aŋ buccin a Noonu ke waak'a kaaccene kuun jï ye pääken. ");
INSERT INTO jum_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Aŋ piik ŋommañ mïïṭṭe wic nïïnkä kä 150. ");
INSERT INTO jum_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Aŋ Jooŋ Noo batta agee kä wiirgon ke wakkä luum jïñe, ke ḍigärgä muure yaaka ke ike kuun jï ye, aŋ tuccin jommu ŋommañ wic aŋ piik wüükïn ïñï. ");
INSERT INTO jum_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Aŋ piik waŋgen yaaka yiiŋete ye, yoken üüljï ke kälkä polloŋ jïñe cäänna, aŋ ñaal yore yuutkene kä mäṇṇä polloŋ jï. ");
INSERT INTO jum_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Aŋ piik ḍuukin ïñï kä ḍeewaŋ kä ḍeewaŋ ŋommañ wic nïïnkä 150 ti. ");
INSERT INTO jum_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Aŋ paan ŋaṭükel ti, nïïnnä caay witken kä ŋaṭükel ti, kuun cääjjin waadgä pämkä yaaka battä me ogo Araraat ye witin. ");
INSERT INTO jum_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Aŋ piik ïïñjïdï kä wüükïn ïñï aŋŋa paan caay ti, aŋ nïïnnä ïïjjïn ti yen paan caay pämkä witken üükïn woo. ");
INSERT INTO jum_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Aŋ wääna nïïnkä caykä kä ŋan ḍakkene ye, Noo kääl ṭuule yaana naŋŋe kuun gunne ti ye, kupkene. ");
INSERT INTO jum_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Aŋ tuccin gaaggaak. Aŋ kaaccä woo aŋ päydin ke piik ïwene ŋommañ wic. ");
INSERT INTO jum_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Aŋ tuccin gülküte ogo ato piik ookce naana ḍewcono ïñï ŋommañ wic ye. ");
INSERT INTO jum_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Aŋ gülküte batta a käñon nänṭ'a koojjee ïñï ye, aŋ ḍukcin Noo ti kuun jï, nääŋka ŋommañ wiñe muure mor agee kä küümon kä piik ye. Aŋ läjgi Noo ïṇte aŋ müŋŋe aŋ ḍuukke ike ti kuun jï. ");
INSERT INTO jum_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Aŋ kiiññä ŋuca nïïnkä kä ŋaṭükel, aŋ gülküte ŋocce tucce woo. ");
INSERT INTO jum_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Aŋ gülküte ḍuukin ike ti biigin ti aŋŋi, i ädit jaan yaana battä me ogo jeytüün ye gitke garrä tüke ti, aŋ ŋïjï Noo piik ḍewcin ïñï ŋommañ wic. ");
INSERT INTO jum_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Aŋ kiiññä nïïnkä kä ŋaṭükel yakkalaŋ ŋuca aŋ gülküte tucce, aŋ gülküte batta a ḍüükïdïnï ŋäjäk ike ti. ");
INSERT INTO jum_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Aŋ wääna Noo yuunge wäättene kä 601 ye, ïïjjïn ti nïïnnä yen yun kïcconḍe ti, piik ïwnä ŋommañ wic. Aŋ Noo kuun wiñe kuppe woo aŋ däämjin aŋ ŋommañ wiñe yooṭṭe a ïwon. ");
INSERT INTO jum_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Aŋ paan yew ti, nïïnnä caykä kä yew witken kä ŋaṭükel ti, ŋommañ wiñe ïwnä muure. ");
INSERT INTO jum_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Aŋ Jooŋ Noo kiinne ogo, ");
INSERT INTO jum_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Kääjä woo kuun jï ikee ke ïïŋü ke merkä yüükü ke määngä yeeken. ");
INSERT INTO jum_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ke wakkä muure yaaka ke ïkï a üdïn ye, ḍïïrgä ke ḍigärgä, ke wakkä luum jïñe äbä woo. Aŋ dalä gidok ŋommañ wic aŋ pïr aŋ ḍirä.” ");
INSERT INTO jum_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Aŋ Noo kääjin woo kuun jï ke merkä yeeke ke iiŋe ke määngä merkä yeeke. ");
INSERT INTO jum_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ke wakkä luum jïñe ke ḍigärgä ke wakkä yaaka muulu ïñï ŋommañ wic ye, ke ḍïïrgä muure, kääjin woo kuun jï daa kä biilken. ");
INSERT INTO jum_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Aŋ Pïṭo bätki Noo tambal aŋ kuññu ḍigärgä ti ke ḍïïrgä ti muure yaaka ladaŋ a waak ïïllä wäämmä yok ye ti. ");
INSERT INTO jum_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Aŋ Pïṭo ŋääccä pin yaana gïmgede ye, aŋ jaajjin jone ti ogo, “Ŋommañ wiñe batta ŋuca bi tuumu kä nääŋkä mänbaan, aŋ ike a nääŋkä yaackä ken ḍooje jone ti kä ḍine tinä, aŋ wakkä yaaka a üdïn ye, batta ŋuca bi näga ḍugin bata wääna näŋŋä daa kä ḍugin ye. ");
INSERT INTO jum_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Aŋ naana mor ŋommañ bilti ye, i pïïṇṇä ke errä, aŋ lüüy ke carrä, aŋ yiiwuk ke yiluk, aŋ äŋ jïñe ke wïïrïn jïñe, batta bi yüütï ïñï.” ");
INSERT INTO jum_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Aŋ Noo ŋüülkï Jooŋ ke merkä yeeke aŋ kiinne ogo, “Giide aŋ ḍiire aŋ ŋommañ wiñe küümge. ");
INSERT INTO jum_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Aŋ ikee bi booce kä wakkä luum jïñe yaaka ŋommañ wic ye, ke ḍïïrgä polloŋ jïñe, ke waak'a layok ŋommañ wic ye muure, ke yak wii jïñe. Yaakki muure bi daläbu cäyok ïnkïc ti. ");
INSERT INTO jum_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Waak'a layok a üdïn ŋommañ wic muure ye, a wakkä äämkä yeekic bata wakkä garkä yek pïïtïn. Waak muure iññe kä. ");
INSERT INTO jum_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Aŋ gin'a yïmge batta a püürïnï woo ye üṇṇü a yïmgä gïtï, yäŋŋonḍe ŋana ame. ");
INSERT INTO jum_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","“Aŋ mänbaan yaana bi näkï menen ye, bi jooju. Aŋ gin luum jïñe naana näkï mänbaan ye, bi tüw cäänna. Aŋ yaana näkï men ye, daa bi tüw. ");
INSERT INTO jum_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Aŋ yaana näkï men ye, daa bi näkä me ḍok, nääŋka Jooŋ mänbaan naŋŋeeda kä biilke ye. ");
INSERT INTO jum_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Giide, aŋ pïre aŋ ḍiire, aŋ ŋommañ wiñe küümge.” ");
INSERT INTO jum_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Aŋ Noo kiini Jooŋ ke merkä yeeke ogo, ");
INSERT INTO jum_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Tiññaŋ ika ḍuccudu jiik ḍoocin yeeki ke ikee aŋ ke kaaynä yeekic yaaka ŋätkic ti ye, ");
INSERT INTO jum_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ke waak naŋgin yaaka a üdïn kuun jï ke ikee ye muure, ḍïïrgä ke ḍigärgä ke waak luum jïñe yaaka layok ŋommañ wic ye muure. ");
INSERT INTO jum_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ika bi ḍuccu jiik ḍoocin yeeki ke ikee, aŋ baati ŋuca wakkä üdïn ti muure yaaka bi tüw kä piik tääl ye. Aŋ baati ŋuca tääl mooye yaana bi cüüṭï gïtï ŋommañ wiñe ye.” ");
INSERT INTO jum_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Aŋ Jooŋ jaajjin ogo, “Gin yaanni ika päjgada ŋïngïn gin'a nüütü jiik ḍoocin waan yeeni ti ke ikee ye, ke waak'a a naŋgin a üdïn ye muure, ke merkä yeekic ti ke cüle. ");
INSERT INTO jum_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Rüñït a gin'a ḍooccu ñaalok curuŋgu gïtï ye, aŋ bi wäätï a gin'a nüütï jiik ḍoocin waan yeeni ti ke ŋommañ ye. ");
INSERT INTO jum_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Aŋ naana ika ääcä polku ñaalok polloŋ jï ye, i rüñït ükü woo polku gïtï. ");
INSERT INTO jum_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Aŋ jiik ḍoocin yeeki ke ikee ke waak'a a üdïn ye muure bi payä. Aŋ baati tääl mooye yaana bi ätä nääkä waak'a a üdïn ye muure. ");
INSERT INTO jum_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Aŋ naana rüñït ükü woo curuŋgu gïtï aŋ yooṭu ye, jiik ḍoocin yeeki ke waak'a a üdïn ŋommañ wic muure ye bi payä.” ");
INSERT INTO jum_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Aŋ Noo kiini Jooŋ ogo, “A rüñït ken ḍooccu a paydin jiik ḍoocin yeeki ke waak'a a üdïn ŋommañ wic ye muure.” ");
INSERT INTO jum_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Aŋ merkä Noo yaaka kääjenee woo kuun jï ye, a Caam ke Haam ke Yaapic. Aŋ Haam a Kanaan wäyen. ");
INSERT INTO jum_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","M'aka ikki ḍiirin piirtin ŋommañ wic yaakki, käjä woo merkä Noo yaaka kä ḍäk ye ti. ");
INSERT INTO jum_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Aŋ wääna tääl baakkenee kä ye, Noo jujjin kä puuynu yiil, aŋ pïïttä jaan muulu beel bata lüütkon, aŋ ṭulge naŋgä me a määk. ");
INSERT INTO jum_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ääŋkalaŋ Noo mättä määk yaaka ñuŋŋe ye, aŋ ike nägi aŋ oodi keeñ yeene jï yore kä el. ");
INSERT INTO jum_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Aŋ Haam Kanaan wäyen, wäyen yoorre nïïn yore kä lat, aŋ ḍukcin üṇtük mädgen yaaka kä yewwe ye nüütkene. ");
INSERT INTO jum_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Aŋ Caam ke Yaapic kuññu burŋu, aŋ pedi gïtï ke ḍääge ñaalok büyken ti, aŋ wüttü ti wäyen ti kä ŋätken, aŋ wäyen kümï yok. I waŋgen agene kä ṭukin woo batta ṭäkï wäyen yoottu i yore elaŋ. ");
INSERT INTO jum_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Aŋ wääna Noo määk pättee woo wiñe ti ye, nääŋk'a näŋgene daa minneni yeene ḍeerconḍe ye ŋïññe. ");
INSERT INTO jum_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Aŋ jaajjin ogo, “Kanaan bi a tuumgon! Aŋ ike bi wäätï a kiingon yen kiinkä mädgen.” ");
INSERT INTO jum_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Aŋ Noo jaajjin ŋuca ogo, “Ŋüülkïn atï Pïṭo Jooŋ yen Caam ti! Aŋ Kanaan wäätï a kiingon yeene. ");
INSERT INTO jum_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Dalä baan Yaapic gääpänä woo Jooŋ, aŋ cääjjï keeññi yek Caam gïtï, aŋ Kanaan wäätï a kiingon yeene.” ");
INSERT INTO jum_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Aŋ wääna piik tääl baawkene ye, Noo cääynä yuungu 350. ");
INSERT INTO jum_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Aŋ Noo cääynä yuunge muure 950, aŋ wäättana tüwnü. ");
INSERT INTO jum_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Aŋ a kaaynä yek merkä Noo ikki, Caam ke Haam ke Yaapic. Aŋ iken gittä merkä kä ḍiräk wääna tääl baawkenee kä ye. ");
INSERT INTO jum_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Aŋ merkä Yaapic a Jomar ke Maajüüc ke Maday ke Yawaan ke Tabil ke Maacik ke Tiraac. ");
INSERT INTO jum_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Aŋ merkä Jomar a Ackanaac ke Rïpeec ke Tojarma. ");
INSERT INTO jum_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Aŋ merkä Yawaan a Alïca ke Tarcïïc aŋ mä Kaat ke mä Rudaan. ");
INSERT INTO jum_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Aŋ a kaaynä me yaakca ken ika piirtin gïtï, aŋ cääjjin wiykä mäyken ḍugin yaakka. Aŋ kiiptin gïtï kä bänkä yeeken ke äärgä yeeken tüggen, ke ṭoŋ yeeken aŋ wäättana kun yaŋkalaŋ daa kä lemmä yeenen. ");
INSERT INTO jum_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Aŋ merkä Haam a Küüc ke Macïr ke Püüt ke Kanaan. ");
INSERT INTO jum_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Aŋ merkä Küüc a Ceba ke Hawela ke Capta ke Raama ke Capteka. Aŋ merkä Raama a Cïïba ke Diidaan. ");
INSERT INTO jum_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Aŋ Küüc gittä Nimuraat, aŋ a m'ana ïïjjïn kä teynä ŋommañ wic ye. ");
INSERT INTO jum_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Aŋ ike a kiño teyconḍe Pïṭo ñome ti, aŋ a yaana jaayge kä me ogo, “Beelje bata kiño Nimuraat kä teynä Pïṭo ñome ti.” ");
INSERT INTO jum_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Aŋ yätkïtïn yeene ïïjjïn ti kä bänkä yek mä Baabïl ke Aaraak ke Akaat ke Kolina ŋommañ mä Cïnnaar ti. ");
INSERT INTO jum_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Aŋ ike yätkïtïn yeene gääppe woo aŋ wükcïn ŋommañ mä Acüür ti, aŋ a nänṭ'a bättee kä bänkä battä me ogo Nïïnawa ke Rabuut Eer ke Kaala ");
INSERT INTO jum_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ke Recen ye. Aŋ Recen a baan mooye yaana yäwaŋ cääy waan mä Nïïnawa ke Kaala ye. ");
INSERT INTO jum_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Aŋ Macïr a wäy yen mä Lüüt ke mä Anaam ke mä Leheep ke mä Naptüü ");
INSERT INTO jum_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ke mä Patarooc ke mä Kaptoor ke mä Kacaloo, yaaka gittä mä Palactïïn ye. ");
INSERT INTO jum_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Aŋ Kanaan kaygon yeene yaana giiṇṇe ye, battä me ogo Cïdoon, aŋ ŋuca giiṇṇä mä Haat ");
INSERT INTO jum_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ke mä Yaabüüc ke mä Amoor ke mä Jarjïïc ");
INSERT INTO jum_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ke mä Haaw ke mä Iraka ke mä Cïïn ");
INSERT INTO jum_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ke mä Arwaat ke mä Jamaar ke mä Hamaat. Aŋ wäättana äärgä tüggen yek mä Kanaan piirtin. ");
INSERT INTO jum_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Aŋ kewnä yen mä Kanaan juwu Cïdoon aŋ ḍakcïdï ke Jaraar ke Gajja, aŋ kä baan mä Caduum ke Amuura ke Adama ke Jobïïm ke Leeca ti. ");
INSERT INTO jum_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Aŋ a kaaynä Haam ikki ke äärgä yeeken tüggen ke lemmä yeenen ke bänkä yeeken ke ṭoŋ yeeken. ");
INSERT INTO jum_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Aŋ Caam cäänna gittä merkä aŋ ike a Yaapic määden mooye, aŋ a wäy yen kaaynä Aabir muure. ");
INSERT INTO jum_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Aŋ merkä Caam a Ilaam ke Acüür ke Arpiceet ke Lüüt ke Araam. ");
INSERT INTO jum_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aŋ merkä Araam a Üüc ke Üül ke Jaacir ke Maacik. ");
INSERT INTO jum_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aŋ Arpiceet gittä Caale aŋ Caale gittä Aabir. ");
INSERT INTO jum_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Aŋ Aabir gittä merkä kä yewwe. Aŋ yaŋkalaŋ äkki me ogo Paalic, nääŋka ŋommañ kiibene daa kä me gïtï nïïnkä yaaka giidene daa me ye ti. Aŋ määden battä me ogo Yaktaan. ");
INSERT INTO jum_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Aŋ Yaktaan gittä Almodaat ke Caalip ke Ajaramuut ke Yaare ");
INSERT INTO jum_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ke Adüraam ke Üjaal ke Dïkïla ");
INSERT INTO jum_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ke Übaal ke Abïmayaal ke Cïïba ");
INSERT INTO jum_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ke Opeer ke Hawela ke Yübaap. Iken yaakki muure a merkä Yaktaan. ");
INSERT INTO jum_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Aŋ iken cäyok nänṭ'a battä me ogo Miica ye, atï ke Caapir pääm mä ñomuŋŋu ti. ");
INSERT INTO jum_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Aŋ a kaaynä Caam ikki ke äärgä yeeken tüggen ke lemmä yeenen ke bänkä yeeken ke ṭoŋ yeeken. ");
INSERT INTO jum_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aŋ a äärgä tüggen yek Noo ikki ke merkä yeeken ke kaaynen, aŋ iken ti ṭoŋ piirtin ŋommañ wic wääna tääl baawkenee kä ye. ");
INSERT INTO jum_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Aŋ ñomuk kä on me muure ŋommañ wic lemmä yeenen a keelok, aŋ a jiik keelkä ken jaaygä. ");
INSERT INTO jum_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Aŋ wääna baŋŋene kä ñomuk ye, käññä nänṭä ḍääñgon gääpconḍe baan yaana battä me ogo Cïnnaar ye jï, aŋ iken cääjjin ïñï wïca. ");
INSERT INTO jum_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Aŋ iken luugjin pääken ogo, “Bätïn düüca aŋ peelïn tey.” Aŋ pämkä dalibuwin aŋ wäättana a düüca peelgon ken ñuugulene kä. Aŋ ŋomgu tïtkä dalibuwin aŋ wäättana a ḍiiney üllü ken ñuugulene kä. ");
INSERT INTO jum_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Aŋ iken jaajjin ogo, “Ääte ïkïïn näŋïn baan mooye, aŋ ïkïïn bätïn än mooye bääyconḍe yaana wiñe wätcïdï ti polloŋ jï ye. Aŋ ïkïïn näŋïn yäṇtäŋgono nuŋko ŋana pïïrtïtïn ŋommañ wic.” ");
INSERT INTO jum_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Aŋ Pïṭo kääjin ïñï ükcïdï baan mooye ke än bääyconḍe yaana batä mäbaan ye. ");
INSERT INTO jum_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Aŋ Pïṭo jaajjin ogo, “Iken a mä keelkä aŋ lemmä yeenen a keelok! Aŋ iken ikki jujjin kä nääŋkä ginani yaanni, iken batta bi yocu naŋŋä gin'a ṭäkkänä naŋgä ye. ");
INSERT INTO jum_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Aŋ kaacïn ïñï lemmä yeenen cüülkïn daa gïtï, nuŋko ŋana yaŋkalaŋ jiik menen ookcedeeda gïtï.” ");
INSERT INTO jum_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Aŋ piirji gïtï woo Pïṭo ŋommañ wic muure, aŋ yuuttu ïñï kä baṇṇä baan mooye. ");
INSERT INTO jum_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ina ken äkkene daa me ogo Baabïl yaanna nääŋka Pïṭo mäbaan lepen cüülleeda gïtï muure, aŋ mäŋkalaŋ daa jaayee kä lemmä yeene yaanna, aŋ iken piirji gïtï woo Pïṭo ŋommañ wiñe ti muure. ");
INSERT INTO jum_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","A perrä yen kaaynä Caam ikki. Wääna Caam yuunge aŋŋene kä 100 ye, aŋ wääna tääl baawkenee kä yuungu kä yewwe ye, ike gittä Arpiceet. ");
INSERT INTO jum_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Aŋ wääna Arpiceet giidene daa me ye, Caam cääynä yuungu 500, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Aŋ Arpiceet cääynä yuungu 35, aŋ gittä Caale. ");
INSERT INTO jum_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Aŋ wääna Caale giidene daa me ye, Arpiceet cääynä yuungu 403, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Aŋ Caale cääynä yuungu 30, aŋ gittä Aabir. ");
INSERT INTO jum_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Aŋ wääna Aabir giidene daa me ye, Caale cääynä yuungu 403, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Aŋ Aabir cääynä yuungu 34, aŋ gittä Paalic. ");
INSERT INTO jum_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Aŋ wääna Paalic giidene daa me ye, Aabir cääynä yuungu 430, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Aŋ Paalic cääynä yuungu 30, aŋ gittä Raaw. ");
INSERT INTO jum_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Aŋ wääna Raaw giidene daa me ye, Paalic cääynä yuungu 209, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Aŋ Raaw cääynä yuungu 32, aŋ gittä Cïrü. ");
INSERT INTO jum_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Aŋ wääna Cïrü giidene daa me ye, Raaw cääynä yuungu 207, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Aŋ Cïrü cääynä yuungu 30, aŋ gittä Nahüür. ");
INSERT INTO jum_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Aŋ wääna Nahüür giidene daa me ye, Cïrü cääynä yuungu 200, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Aŋ Nahüür cääynä yuungu 29, aŋ gittä Taare. ");
INSERT INTO jum_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Aŋ wääna Taare giidene daa me ye, Nahüür cääynä yuungu 119, aŋ gittä merkä oogen ke tïïrïn yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Aŋ Taare cääynä yuungu 70, aŋ gittä Abram ke Nahüür ke Araan. ");
INSERT INTO jum_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","A perrä yen kaaynä Taare ikki. Taare gittä Abram ke Nahüür ke Araan. Aŋ Araan gittä Luut. ");
INSERT INTO jum_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Aŋ Araan ïïjjïn wäyen Taare yütte wic kä tüwnü baan battä me ogo Üür a yen mä Kaldaan nänṭä yaana giidene daa me ye ti. ");
INSERT INTO jum_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aŋ Abram ke Nahüür ḍiññä muuṭuk. Aŋ iŋ Abram battä me ogo Caarraay, aŋ iŋ Nahüür battä me ogo Maalka. Aŋ Maalka iken ke Icka a tïïrïn Araan yaana a Nahüür määden ina. ");
INSERT INTO jum_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Aŋ Caarraay a burŋu batta a giidon merkä. ");
INSERT INTO jum_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Aŋ Taare minneni yeene Abram koowne ke Luut minneni minneni yeene Araan ke Caarraay iŋ minneni yeene Abram, aŋ kaaccene kä woo kä nänṭ'a battä me ogo Üür a yen mä Kaldaan ye ti, atï ŋommañ mä Kanaan ti. Aŋ wääna ḍäägene ti baan yaana battä me ogo Araan ye, i cääjjin ïñï wïca. ");
INSERT INTO jum_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Aŋ Taare cääynä yuungu 205, aŋ tüwnü baan Araan jï. ");
INSERT INTO jum_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Aŋ Abram kiini Pïṭo ogo, “Atä, baan yüünü mañjä ïñï ke mä yüükü ke än wääc, aŋ atä nänṭä yaana bi nüütkenii kä ye. ");
INSERT INTO jum_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Aŋ ïkï bi naŋeni wäätci agä ṭoŋ yäwke, aŋ ïkï bi tutkeni cäwdä ŋerconḍe, aŋ yäntonḍü bi naŋä täl, aŋ me bi käñï ŋüülkïn ika ti kä päy yüünü. ");
INSERT INTO jum_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aŋ m'aka ïkï ŋüülkïnï ye, bi ŋüülkü aŋ m'aka ïkï tuumgi ye, bi tuumu, aŋ ïkï bi wäätci agä ŋüülkïn yek äärgä tüggen ŋommañ wic muure.” ");
INSERT INTO jum_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Aŋ Abram baŋŋä bata yaana kiinene daa Pïṭo ye, aŋ attä ke minneni määden Luut. Aŋ Abram wääna kääjenee woo baan yaana battä me ogo Araan ye jï, yuunge caykä kä ŋüṭükel witken kä duuc. ");
INSERT INTO jum_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Aŋ Abram iiŋe Caarraay koowne ke Luut, ke wakkä yeeke yaaka bilti ye muure, iken ke Luut, ke kiinkä yaaka ḍooje ke ike Araan ye. Aŋ iken kaaccä woo muure üŋjïdï ŋommañ mä Kanaan ti. Aŋ wääna ḍakkene ti Kanaan ye, ");
INSERT INTO jum_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abrammä ättä ke ḍakene ti jaan mooye yaana battä me ogo Muura ye ti, cokulaŋ ti baan yaana battä me ogo Cakïïm ye ti. I nïïnkä yaakca ti mä Kanaan bilti ŋommañ yaanja jï. ");
INSERT INTO jum_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Aŋ Pïṭo üükïn woo Abram ti, aŋ kiinne ogo, “A kaaynä yüükü ken bi iñä ŋommañ yaanni.” Aŋ Abram Pïṭo bätkene tambal nänṭa üükene kä woo Pïṭo ye. ");
INSERT INTO jum_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Aŋ wäättana iken baŋŋä, aŋ cääjjin waadgä pämkä waan Betalï ke Aay, aŋ Betalï ḍïmjïdï kä ŋäjäk aŋ Aay ken kä ñomuk, aŋ keeñ yeene ṭeljene ïñï wïca. Aŋ Abram Pïṭo bätkene tambal aŋ maaŋŋe wïca. ");
INSERT INTO jum_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Aŋ Abram bakkä woo üŋjïn ïñï teettälaŋ yaana battä me ogo Najïp ye. ");
INSERT INTO jum_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Aŋ baan yaanja ti nänṭä aŋŋa käñ kä yaac, aŋ Abram baŋŋä Macïr atï cääjjïdï wïca a boorgon nääŋka käñ yaaññee kä wïca ye. ");
INSERT INTO jum_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Aŋ wääna iken ḍakkene ti tooy tük Macïr ye, iiŋe Caarraay kiinne ogo, “Ŋäjjä ïkï agä iiŋ ŋerconḍe. ");
INSERT INTO jum_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Naana ïkï bi yoorgi mä Macïr ye, iken bi jaajjï ogo, ‘A iiŋe inni.’ Aŋ ika bi näka ḍok aŋ ïkï bi mañjini agä üdon. ");
INSERT INTO jum_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Jaajjä ogo ïkï agjey käwo, aŋ kä jiik yüükü ika batta bi naŋga nääŋkalaŋ, aŋ ika bi üüdja ḍok.” ");
INSERT INTO jum_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Aŋ wääna kaaccene ti Macïr ye, ike yoori mä Macïr ŋeraŋ kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Aŋ wääna yoorene daa kä ḍuuŋkulen yek Parahuun ye, riingi Parahuun aŋ wäättana iji än mooye yeene jï. ");
INSERT INTO jum_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Aŋ kä ike Parahuun jone ñappä kä Abram, aŋ Abram iññi ḍiik ke däk ke tüürüŋŋï oogen ke määngen ke kiinkä oogen ke määngen ke kälämgä. ");
INSERT INTO jum_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Aŋ Pïṭo Parahuun ke mä yeeke tuckene yokïn rackïtïn yaajgonḍe kä jiik Caarraay iŋ Abram. ");
INSERT INTO jum_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Aŋ Parahuun Abram bärkene aŋ taaññe ogo, “A nääŋkä ŋaaka ika näŋganaa kä yaakka? Ika batta nüütkadaa ogo ïïŋü ina? ");
INSERT INTO jum_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Aŋ ika kiindaa ogo käwic ina, ke koowu daa kä a iiŋ yeeni? Ïïŋü ina, koowu aŋ ate!” ");
INSERT INTO jum_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Aŋ Parahuun mä yeeke iingene ogo Abram ñoolcï woo baannen ke iiŋe ke waak yeeke muure. ");
INSERT INTO jum_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Aŋ Abram juwu Macïr, aŋ üŋjïn ñaalok nänṭ'a battä me ogo Najïp ye, ke iiŋe ke Luut ke wakkä yeeken muure. ");
INSERT INTO jum_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Aŋ Abram aŋŋa ceeggon kä yaac kä ḍigärgä ke tiilgä gälkä ke tiilgä. ");
INSERT INTO jum_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Aŋ ike juwu Najïp, aŋ attä nänṭä ke nänṭä atï Betalï aŋ ḍakkä ti nänṭä yaana waan Betalï ke Aay ye ti, nänṭä yaana agee kä ṭïlcïnï kä ïñï keeñ yeene kä on ye. ");
INSERT INTO jum_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Aŋ a nänṭ'a ïïjjenee ti bättee kä tambal ye. Aŋ Abram Pïṭo maaŋŋe ŋuca wïca. ");
INSERT INTO jum_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Aŋ cäänna Luut yaana layok ke Abram ye, cääygene ḍigärgä ke keeññi. ");
INSERT INTO jum_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Aŋ nänṭä cäwdä yeenen ḍeeṭṭä ïñï, aŋ batta lïïṭït cäwdä nänṭä keellä kä ḍiirin ḍigärgä yeeken. ");
INSERT INTO jum_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Aŋ kaaydoni ḍigärgä yek Abram ke yek Luut äämä yääññäni. Aŋ mä Kanaan ke mä Peeric nïïnkä yaakca ti cäyok nänṭä yaanja ti cäänna. ");
INSERT INTO jum_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Aŋ Abram Luut kiinne ogo, “Ŋana ïkïï äämï yääññä, aŋ ŋana kaaydoni ḍigärgä yooko äämä yääññä, ïkïï agï mä keelkä. ");
INSERT INTO jum_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ŋommañ muure ina ñomü ti yaanna ïkïï pïïrtï. Naana ïkï üŋjü kä buŋ birrä ye, i ika üŋjü kä buŋ aam aŋ naana ïkï üŋjü kä buŋ aam ye, i ika üŋjü kä buŋ birrä.” ");
INSERT INTO jum_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Aŋ Luut wiñe äärene ñaalok aŋ cäälgä yek wii mä Üürdün yooṭṭe taaŋŋä Coogaar garaŋ bata nänṭä garrä yen Pïṭo, aŋ ŋeraŋ beel bata ŋommañ mä Macïr. I batta mor Pïṭo Caduum ke Amuura ḍüüme gïtï. ");
INSERT INTO jum_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Aŋ Luut wäkkä cäälgä yek wii mä Üürdün ḍoŋe, aŋ iken piirtin. Aŋ ike baŋŋä kä ñomuk. ");
INSERT INTO jum_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aŋ Abram cääjjin ŋommañ mä Kanaan ti, aŋ Luut cääjjin bänkä mäyken yek cäälgä gïtï, aŋ keeññi yeeke baakke ti baan yaana battä me ogo Caduum ye gunne ti. ");
INSERT INTO jum_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Aŋ nïïnkä yaakca ti mä Caduum nääŋä nääŋkä yaacken kä yaac yaaka batta ṭäkkänä Pïṭo ye. ");
INSERT INTO jum_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Aŋ Abram wääna piirtene ke Luut ye, kiini Pïṭo ogo, “Wïñü äärä ñaalok nänṭ'a cääyii kä yaanna ti, aŋ däämjä ñomuk ke ŋäjäk aŋ ñaalok ke ïñï. ");
INSERT INTO jum_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Aŋ ŋommañ yaanni bi iñe kä muure ke kaaynä yüükü ke cüle. ");
INSERT INTO jum_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Aŋ kaaynä yüükü bi naŋä ḍirä bata ŋomgu yek ŋommañ wiñe, aŋ batta bi lïïlgä me kä paŋŋä. ");
INSERT INTO jum_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Juwu, ŋommañ iñdenii kä, atä baadä bäyte ke gäpte.” ");
INSERT INTO jum_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Aŋ Abram keeññi yeeke baaŋŋe, aŋ attä cääjjïn jengä mäyken yek Mamar ŋoyin, baan yaana battä me ogo Hiburoon ye ti, aŋ cääjjin ïñï wïca. Aŋ Pïṭo bätkene tambal ŋuca. ");
INSERT INTO jum_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Aŋ nïïnkä yaakca ti yääññä juwin baan jï. Aŋ Amrapiil yätkä mä Cïnnaar, ke Ariyok yätkä mä Alicaar, ke Kadarlomaar yätkä mä Ilaam, ke Tidaal yätkä mä Jüwïïm ");
INSERT INTO jum_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ircin yääññäk Beera ti yätkä mä Caduum, ke Birca yätkä mä Amuura, ke Cannaap yätkä mä Adama, ke Camïbaar yätkä mä Jobïïm, ke yätkä mä Beela. Aŋ a Beela ken battä me ogo Coogaar. ");
INSERT INTO jum_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Aŋ iken yaaka kä duuc yaakka kääygä yeeken ḍülï yokïn ḍääñgon yaana battä me ogo Cadïïm ye ti, Koon Mooye yen Äyyä ti. ");
INSERT INTO jum_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Aŋ iken yuungu yaaka kä caay witken kä yewwe ye, müktü kä yätkä Kadarlomaar, aŋ yun yaana yoku wäätcete kä caay witken kä ḍäk ye, i tuuci yokïn woo. ");
INSERT INTO jum_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Aŋ wääna nääkenee yun ŋuca ye, Kadarlomaar ke yätkäni yaaka ñääkene ye ḍäägin ti, aŋ mä Rapïïn booji nänṭ'a battä me ogo Actarüüt Karnïïm ye ti, aŋ mä Jüüc booji nänṭ'a battä me ogo Haam ye ti, aŋ mä Ïïm booji nänṭ'a battä ogo Coobï Kiriteem ye ti, ");
INSERT INTO jum_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","aŋ mä Hüür booji pämkä yaaka battä me ogo Cïïr ye ti, ke ḍaakene daa ti El Paraan nänṭä teeṇṇä ti kä cokal. ");
INSERT INTO jum_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Aŋ iken ḍuukin ŋäjäk aŋ attä nänṭ'a battä me ogo En Micpeet ye ti. Aŋ nänṭä cäänna äkki me ogo Gaadic. Aŋ iken bänkä mä Amülïïk müügï muure ke mä Amoor yaaka cäyok Hajojon Taamar ye. ");
INSERT INTO jum_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Aŋ yätkäni mä Caduum, ke Amuura, ke Adama, ke Jobïïm, ke Beela yoken tooti yääññä ti ḍääñgon mä Cadïïm jï. Aŋ Beela a nänṭ'a cäänna äkki me ogo Coogaar ye. ");
INSERT INTO jum_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Aŋ näägjin ke Kadarlomaar yätkä mä Ilaam, ke Tidaal yätkä mä Jüwïïm, ke Amrapiil yätkä mä Cïnnaar, ke Ariyok yätkä mä Alicaar. Aŋ iken yätkäni kä ŋan pärjïdï ke yätkäni kä duuc. ");
INSERT INTO jum_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Aŋ ḍääñgon yen mä Cadïïm cääygene gïtï kälkä mäyken küüñgïn yek kälkä ñownä ïïlïn kä ḍiräk, aŋ wääna yätkä yen mä Caduum ke yen mä Amuura ñoolene daa meken ye, yakkalaŋ lüütï kälkä aŋ meken yakkalaŋ lüdgïn aajjin ñaalok pämkä witin. ");
INSERT INTO jum_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Aŋ yätkäni yaaka kä ŋan ye, waak muure yek mä Caduum ke Amuura peeji ke wakkä äämkä muure, aŋ iken ḍukcin ŋäjäk. ");
INSERT INTO jum_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Aŋ Luut yaana cääy Caduum a minneni Abram määden ina mügï iji, aŋ waak yeeke koowi muure. ");
INSERT INTO jum_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Aŋ män Luut yaŋkalaŋ bättä, aŋ attä Abram nüütkene nääŋkä yaaka näŋŋä ḍuuggen ye muure. Aŋ a Abram yen mä Iburu yaana cääy cokulaŋ ti jengä mäyken yek m'ana battä me ogo Mamar a män Amoor ye, Mamar ke mädgen Ickool ke Aneer a m'aka ñääkï ke Abram ye. ");
INSERT INTO jum_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Aŋ wääna Abram jiik tiiŋŋeeda kä ogo minneni määden müŋŋïï me ye, i ike ḍüttü 318 m'aka a giitin paa baanne, aŋ a ŋeelgin ye. Aŋ ädäŋŋi baati ŋätin, ke ḍakene ti baan battä me ogo Ḍaan. ");
INSERT INTO jum_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Aŋ wääna nänṭä üllee kä ye, Abram mä yeeke pääŋŋe gïtï, aŋ gutcin yääññäk aŋ meken booji. Aŋ kääygä Kadarlomaar buurcin woo, aŋ ñooli ke baan yaana battä me ogo Hoba ye, Damac ti kä ñaalok. ");
INSERT INTO jum_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Aŋ Abram waak muure müüŋŋe, aŋ Luut minneni määden ke waak yeeke ke määngä ke ook yaaka a müükïn ye ḍuugene ŋäjäk. ");
INSERT INTO jum_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Aŋ wääna Abram ḍuukenee kä nänṭa buuccee kä yätkä Kadarlomaar ke yätkäni yaaka ñääkene kä ye, yätkä yen mä Caduum kääjin woo pääkcïdï ike ḍääñgon yen mä Coobï jï, a ḍääñgon yen yätkä. ");
INSERT INTO jum_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Aŋ Malikcadiik yätkä yen mä Caalïm a män daaŋ yen Jooŋ yaana Küülaŋ kä Yaac ye, Abram äckene woo biŋŋan ke määk. ");
INSERT INTO jum_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Yätkä Malikcadiik Abram ŋüülkene aŋ jaajjin ogo, “Abram ŋüülkünü Jooŋ yaana Küülaŋ kä Yaac, näŋŋä polloŋ ke ŋommañ ye. ");
INSERT INTO jum_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Aŋ ŋüülkïn ḍükcï Jooŋ yaana Küülaŋ kä Yaac ye ti, kä yaana iññey kä teynä aŋ ädäŋŋi yüükü booññee da kä ye.” Aŋ Malikcadiik kiŋgi Abram waak muure yaaka piijene ye ti, kä caycayni. ");
INSERT INTO jum_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Aŋ yätkä yen mä Caduum Abram kiinne ogo, “Mä yeeki yaaka müügï me ye ken ḍuukkaa kä, aŋ waak muure koowu yaaka piijini ye.” ");
INSERT INTO jum_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Aŋ Abram yätkä yen mä Caduum kiinne ogo, “Ïṇtï lajjänä ñaalok aŋ ika lïïttä kä Pïṭo Jooŋ yaana Küülaŋ kä Yaac näŋŋä polloŋ ke ŋommañ ye ti, ");
INSERT INTO jum_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ogo ika batta kujjo ginkalaŋ waak yüükü ti, naana a tol aŋ naana a waynä umdonḍe ye, nuŋko ŋana jaayii kä ogo, ‘Abram naŋŋä kä ika a ceeggon.’ ");
INSERT INTO jum_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Waak'a ami mä yeeki yaaka ääton kä yääññäk ye, ken bi gïmgä pääken, aŋ Aneer ke Ickool ke Mamar, dale küjï yeeken.” ");
INSERT INTO jum_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Aŋ nïïnkä yakkalaŋ ti Pïṭo Abram umgene kä yooddin aŋ kiinne ogo, “Abram, ŋana ïkï booju. Ika agä kuurñu yüünü, aŋ gin'a bi iñenii kä ye, bi yäwaŋ.” ");
INSERT INTO jum_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Aŋ Abram jaajjin ogo, “Ay Pïṭo Jooŋ yeeni, gin'a iñdaa kä ye, ika bi näŋga ŋaaka? I ika batta agä giidon aŋŋi, aŋ m'ana bi yätï än yeeni jïñe ye, a Liyaajir yen mä Damac!” ");
INSERT INTO jum_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Aŋ Abram jaajjin ŋuca ogo, “Ika batta agja kä iñgon merkä, aŋ a kiingon yaana baanni ye, ken bi wäätï a yäto yeeni.” ");
INSERT INTO jum_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Aŋ kiini Pïṭo ogo, “Men yaanni batta bi wäätï a yäto yüünü, a minneni yaana bi giidä woo jïñü ti ye, ken bi wäätï a yäto yüünü.” ");
INSERT INTO jum_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Aŋ Pïṭo Abram koowne iññe woo wïca, aŋ kiinne ogo, “Däämjä ñaalok polloŋ jï, aŋ kirkä pagä naana bi lïïljeeda kä paŋŋä ye, kaaynä yüükü bi ḍirä aŋan.” ");
INSERT INTO jum_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Aŋ wina Abram luggin kä jiik Pïṭo, aŋ kä luggin yeene ḍoocce a men wotconḍe. ");
INSERT INTO jum_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Aŋ ike kiini ogo, “Ika agä Pïṭo yaana ïkï äbeney woo baan yaana battä me ogo Üür a yen mä Kaldaan ye, ika ṭäkä nänṭä yaanni iñdenii kä wäätï a yüünü.” ");
INSERT INTO jum_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Aŋ Abram jaajjin ogo, “Ay Pïṭo Jooŋ yeeni, bi ŋäjjä ogoo ogo bi wääto ogo yeeni?” ");
INSERT INTO jum_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Aŋ ike kiini Pïṭo ogo, “Ickaa naañ, ke ḍeel iiŋe, ke kabal yaane, yaaka yuungen a wäätin kä ḍäk ye, aŋ bäämle ke gülkütele.” ");
INSERT INTO jum_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Aŋ Abram waak yaakka muure äbene, aŋ ḍigärgä ken bääŋŋe gïtï aŋ baŋ yaŋkalaŋ daa biirjene ti menen ti, aŋ ḍïïrgä ken batta agee kä bääkin gïtï. ");
INSERT INTO jum_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Aŋ wääna weñgä kuuyene ïñï ogo yoku iken ämo waak tüwïn ye, i maki woo Abram. ");
INSERT INTO jum_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Aŋ wääna äŋ ütcedee kä ye, Abram oodi kä yaac, aŋ mïïllä mooye yaana yäwaŋ ye ike ääti wic. ");
INSERT INTO jum_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Aŋ Abram kiini Pïṭo ogo, “Ŋïjä ṭeṭaŋ! Kaaynä yüükü bi wäätï a boorgu baan yaana batta a yeenen ye ti, aŋ bi naŋgä a kiinkä aŋ bi joocu yuungu 400. ");
INSERT INTO jum_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Aŋ ṭoŋ yaaka iken naŋi a kiinkä yaakka bi jooju, aŋ iken wäättana bi käjä woo i ïnken pegaŋ kä wakkä. ");
INSERT INTO jum_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Aŋ ïkï bi tüwü kä ŋïïbbïn, aŋ ïkï bi jïkï me i yüüngü a ḍïïrïnï. ");
INSERT INTO jum_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Aŋ kilkä kä ŋan kaaynä yüükü bi ḍuku ŋäjäk winni, kä yaana nääŋkä yaackä yek mä Amoor batta mor ḍakene kä waan jooññu ti ye.” ");
INSERT INTO jum_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Aŋ wääna äŋ üttee kä aŋ nänṭä mïïldenee kä ye, Abram yuṭṭu jiinä ḍüüŋïdï woo pïïl jï ke diktäŋle dïïkïdï woo ṭenṭel ti kaajit waak bääkin waadgen gïtï. ");
INSERT INTO jum_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Aŋ äŋ jïñe yaanja ti, Pïṭo ḍuccin jiik ḍoocin ke Abram, aŋ jaajjin ogo, “Ŋommañ yaana jüwïdï wii mä Macïr aŋ atï ke wii mooye yaana yäwaŋ battä me ogo Puraat ye, bi iñä kaaynä yüükü, ");
INSERT INTO jum_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","baan mä Kinaan, ke mä Ginaac, ke mä Gadmoon, ");
INSERT INTO jum_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ke mä Haat, ke mä Peeric, ke mä Rapïïn, ");
INSERT INTO jum_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ke mä Amoor, ke mä Kanaan, ke mä Jarjïïc, ke mä Yaabüüc.” ");
INSERT INTO jum_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Aŋ Caarraay iŋ Abram, a burŋu. Aŋ cääyge ṭuul mä Macïr battä me ogo Haajir ñuugal baanne a kiingon. ");
INSERT INTO jum_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Aŋ Abram kiini Caarraay ogo, “Pïṭo ika ṭïïŋŋa kä giidä merkä. Atä nïïne ke kiingon yeeni, aŋ kä päy yeene ika bi näŋä merkä.” Aŋ Abram gïmmïn jiik iiŋe. ");
INSERT INTO jum_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Aŋ wääna Abram nääkenee yuungu kä caay ŋommañ mä Kanaan jï ye, Caarraay kiingon yeene Haajir yen mä Macïr koowne iññe oore Abram wäättä a iiŋe. ");
INSERT INTO jum_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Aŋ Abram nïngïn ke Haajir, aŋ Haajir laaccä. Aŋ wääna ḍoŋe yoorreeda kä laaccee ye, men mooye yeene wäättana kääckene kä ïllä yok. ");
INSERT INTO jum_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Aŋ Caarraay Abram kiinne ogo, “Ika agä piikon aŋ nääŋkä yaakka a wïñü ti. Kiingon yeeni iññenii kä a ïïŋü, aŋ wääna ḍoŋe yoorreeda kä laaccee kä ye, i ika wäättana ïla yok. Aŋ Pïṭo ïkïï bi nüütkï a ŋaani ken äätä kärgit.” ");
INSERT INTO jum_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Aŋ Caarraay luuki Abram ogo, “Ike a kiingon yüünü aŋ mor cääy ïntü ti, näŋgä nääŋkä yaaka daa yooddu päjjïdï ke ïkï ye.” Aŋ Caarraay Haajir kääckene kä jooññu ke buurce woo ike ti. ");
INSERT INTO jum_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Aŋ Haajir kañi malak yen Pïṭo jïïn wic kä cokal woo teettälaŋ, kä päy yaana atï Cüür ye ti. ");
INSERT INTO jum_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Aŋ taaji malak ogo, “Haajir, kiingon Caarraay, ïkï äätä wa? Aŋ ïkï atä wa?” Aŋ luukki ogo, “Ika buurcu woo men mooye yeeni Caarraay ti.” ");
INSERT INTO jum_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Aŋ kiini malak yen Pïṭo ogo, “Ḍukcu ŋäjäk men mooye yüünü ïṇte ti, aŋ jiik yeeke ken tiŋdä.” ");
INSERT INTO jum_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Aŋ cäänna kiini malak yen Pïṭo ogo, “Kaaynä yüükü bi naŋä ḍirä aŋ batta bi lïïlgä me kä paŋŋä kä ḍiirinenen.” ");
INSERT INTO jum_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Aŋ cäänna kiini malak yen Pïṭo ogo, “Ïkï agä laacon, aŋ ïkï bi giidä minneni oone. Aŋ bi äkkä ogo Icämayiil, nääŋka Pïṭo pillä yüünü tiiŋŋeeda kä ye. ");
INSERT INTO jum_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Aŋ Icämayiil bi beel bata gin luum jïñe, ïṇte bi iccede me ti, aŋ me daa bi ïnken iccätä ike ti, aŋ ike bi cääy kä yiñ ke mädgen muure.” ");
INSERT INTO jum_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Aŋ Pïṭo yaana ike kiini ye, äkkene yäṇtäŋ ogo, “Ïkï agä Jooŋ yaana ika yoodda ye” Aŋ ike ŋuccin jaajjin ogo, “Tiññaŋ M'ana ika yoodda ye, yoorru.” ");
INSERT INTO jum_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Aŋ ina ken jïïn äkkene daa kä me ogo Bïïr Lahaayi Rooy, aŋ aŋan ogo, Jïïn M'ana a Üdon Ika Yoodda ye. Aŋ mor bilti ke tiññaŋ wïca waadgä nänṭä battä me ogo, Gaadic ke Beerït. ");
INSERT INTO jum_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Aŋ Haajir Abram gitkene minneni oone, aŋ äkki Abram ogo Icämayiil. ");
INSERT INTO jum_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aŋ Abram wääna gitkene daa Haajir Icämayiil ye, yuunge a caykä kä cunuuk witken kä ḍüügük. ");
INSERT INTO jum_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Aŋ wääna Abram yuunge aŋŋene caykä kä waŋäḍeŋ witken kä waŋäḍeŋ ye, nüütkï woo Pïṭo yore, aŋ kiinne ogo, “Ika agä Jooŋ yaana Lïïṭït ye. Aŋ päy yeeni ken baaddä, aŋ dalä ïkï ḍoŋü ladaŋ. ");
INSERT INTO jum_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Aŋ ika bi ḍuccu jiik ḍoocin waan yoono ti ika ke ïkï, aŋ kaaynä yüükü bi naŋä ḍirä kä yaac.” ");
INSERT INTO jum_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Aŋ Abram waŋge kümjene ïñï Jooŋ ñomi ti, aŋ kiini Jooŋ ogo, ");
INSERT INTO jum_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“A jiik ḍoocin yooko ke ïkï ikki, ïkï bi wäätci agä wäy yen ṭoŋ ḍiirken. ");
INSERT INTO jum_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Aŋ ïkï batta bi ŋuca batti me ogo Abram, ïkï bi batti me ogo Abrayiim, nääŋka ïkï naŋŋeni wäättii kä a wäy yen ṭoŋ ḍiirken ye. ");
INSERT INTO jum_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Aŋ merkä yüükü bi naŋä ḍirä kä yaac, aŋ kaaynä yüükü bi wäätï a ṭoŋ ḍiirken, aŋ yätkäni bi käjä woo iken ti. ");
INSERT INTO jum_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Aŋ ika bi ḍuccu jiik ḍoocin yeeki ke ïkï ke kaaynä yaaka ŋäñü ti ye, kil ke kil ti. Yaakki a jiik ḍoocin ke cüle, ika bi kamat agä Jooŋ yüünü, aŋ agä Jooŋ yen kaaynä yaaka ŋäñü ti ye. ");
INSERT INTO jum_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Aŋ ŋommañ yen mä Kanaan nänṭ'a cääyii agii kä boorgon yaanna, bi iñenii kä muureen, ïkï ke kaaynä yüükü. Aŋ bi wäätï a nänṭä yeenen ke cüle, aŋ ika bi wäätä agä Jooŋ yeenen.” ");
INSERT INTO jum_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Aŋ Jooŋ Abrayiim kiinne ogo, “Jiik ḍoocin yeeki tïïcke, ïkï ke kaaynä yüükü yaaka bäätïdï ŋäñü ti ye. ");
INSERT INTO jum_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Aŋ a jiik ḍoocin yeeki yaaka ṭäkkä tïïje ye ikki, ïkï ke kaaynä yüükü, m'aka a ook waadgic ti ye dale iirgä me. ");
INSERT INTO jum_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Dale purpurri yeekic iirjänä me woo, aŋ iirrä yeenic ken bi wäätï a baacbaac jiik ḍoocin waadgo ti. ");
INSERT INTO jum_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Aŋ kilkä yaaka äätä ye ti, merkä oogen waadgic ti yaaka nïïnken kä cunuuk ye, dale iirgä me, naana a giitin baannü halla batta a kaaynä yüükü a kiiygin kä tiil boorgu ti ye. ");
INSERT INTO jum_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Aŋ naana a giiton baannü halla a kiygon kä tiil ye, i dale ergä me. Nuŋko jiik ḍoocin yeeki wäätee kä yokic ti ke cüle. ");
INSERT INTO jum_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Aŋ m'ana yaakkä kä errä ye, bi aŋgänä me yok mä yeeki gïtï, jiik ḍoocin yeeki tuuññe yok.” ");
INSERT INTO jum_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Aŋ Jooŋ Abrayiim kiinne ogo, “Caarraay ïïŋü ŋana ŋuca baddä ogo Caarraay, yäṇtonḍe bi wäätï ogo Caarra. ");
INSERT INTO jum_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ike bi ŋüülkü, aŋ ïkï bi gitkey minneni oone. Ike bi ŋüülkü, aŋ bi wäätï a miy yen ṭoŋ ḍiirken. Aŋ yätkäni yek ṭoŋ bi käjä woo kaaynä yeeke ti.” ");
INSERT INTO jum_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Aŋ Abrayiim waŋge kümjene ïñï aŋ yircin woo, aŋ jaajjin jone ti ogo, “Ika bi giidä minneni i yuungi wäättä caykä kä caay aŋŋi? Aŋ Caarra bi giit minneni i yuunge wäättä aŋŋi caykä kä waŋäḍeŋ aŋŋi?” ");
INSERT INTO jum_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Aŋ Abrayiim Jooŋ kiinne ogo, “Dalä Icämayiil ken pïr ñomü ti!” ");
INSERT INTO jum_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Aŋ luugi Jooŋ ogo, “Ba'ay! Ïïŋü Caarra ïkï bi gitkey minneni oone, aŋ bi äkkä ogo Icaak. Aŋ ika bi ḍuccu jiik ḍoocin yeeki ke ike, aŋ ke kaaynä yeeke yaaka ŋäñe ti ye. Aŋ bi wäätï a jiik ḍoocin yaaka batta düüñïdï ye. ");
INSERT INTO jum_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Aŋ Icämayiil ti, jiik yüükü tiiŋgenenii kä, ŋäjjä ike bi ŋüülkü, ike bi naŋä giit, aŋ bi ḍiirä kä yaac. Aŋ bi wäätï a wäy yen yätïnï yaaka kä caay witken kä yewwe ye, aŋ bi dalä wäätï a ṭoŋ yäwke. ");
INSERT INTO jum_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Aŋ ika bi ḍuccu jiik ḍoocin yeeki ke Icaak yaana bi gitkini kä Caarra ye, waan bata yaanni, yun yaana äätä yaanja ti.” ");
INSERT INTO jum_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Aŋ wääna Jooŋ ḍaŋŋee kä jiik ke Abrayiim ye, Abrayiim daljene ïñï. ");
INSERT INTO jum_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Aŋ äŋ jïñe yaanna ti, Abrayiim minneni yeene Icämayiil koowne ke ook yaaka a giitin baanne ye, ke yaaka agee kä kiygin kä tiil yeeke ye, aŋ iirre bata yaana kiinene daa kä Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Aŋ Abrayiim eri me i yuunge caykä kä waŋäḍeŋ witken kä waŋäḍeŋ. ");
INSERT INTO jum_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Aŋ minneni yeene Icämayiil yuunge kä caay witken kä ḍäk, wääna erene daa kä me ye. ");
INSERT INTO jum_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Aŋ äŋ jïñe yaanja ti, Abrayiimmä iiri me muuṭuk ke minneni yeene Icämayiil. ");
INSERT INTO jum_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Aŋ ook muure yaaka baanne ye, ke merkä oogen yaaka a giitin baanne ye, ke yaaka agee kä kiygin kä tiil boorgu ti ye, iirene daa kä me muure. ");
INSERT INTO jum_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Aŋ Pïṭo yore nüütkene woo Abrayiim jengä mäyken yek Mamar ti kä cokal i ike cääy keeñ yeene tük, äŋ gïtï aŋŋi. ");
INSERT INTO jum_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Aŋ Abrayiim däämjin ñaalok, aŋ yurcin ook kä ḍäk yudit kä cokal. Aŋ wääna yoorreeda kä ye, ike bänjin woo keeñ yeene tük atï paakcede, aŋ ḍüŋgene ïñï. ");
INSERT INTO jum_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Aŋ ike jaajjin ogo, “Mügdo, naana ika käññä ŋerrä ïkï ti ye, i ŋana kiingon yüünü kaajdii kä wic. ");
INSERT INTO jum_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yokic yïïkke ṭïïbbok jaan yaanni ŋoy, dale ikee äckene me piik kä ḍeewaŋ lukce kä woo kïïgïc. ");
INSERT INTO jum_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","“Inni kiingon yeenic cickene ti yaanni, dale ikee äckene me amma tääŋe ñaalok juuggic, aŋ wäättana daa ikee wükce.” Aŋ ike luuki ogo, “Ŋeraŋ, Naŋä daa bata yaana jaajjinii kä ye.” ");
INSERT INTO jum_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Aŋ Abrayiim bülcïn ŋäjäk kä bïraŋ keeñ yeene jï Caarra ti, aŋ kiinne ogo, “Kä bïraŋ! Kïïṭä woo ḍon gïtke kä ḍäk kakin yüükü yaaka ŋeraŋ ye ti, aŋ wacci naŋä a bïggï.” ");
INSERT INTO jum_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Aŋ Abrayiim lüüṇṇü däk yeeke ti, aŋ wäkkä naañ yaana a caagon ye, aŋ iññe kiingon yeene ogo naŋje ko bïraŋ. ");
INSERT INTO jum_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Aŋ wääna amma eeŋŋee kä ye, Abrayiim kuññu müṇṇü ke aak ke yäŋŋä peelgon aŋ ḍuckene wilgä ñomgen ti. Aŋ wääna jujjene kä ammä ye, i Abrayiim yuuttu gurken ti jaan ŋoy keeye. ");
INSERT INTO jum_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Aŋ wilgä tääccin ogo, “Ïïŋü Caarra wali?” Aŋ luugi Abrayiim ogo, “Bilti äräk keeñ jï.” ");
INSERT INTO jum_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Aŋ yaŋkalaŋ jaajjin ogo, “Yun yaanja ti ika bi ḍuuku ïkï ti bata waan yaanni ti, i ïïŋü Caarra bi miigä a giidon minneni!” I Caarra jiik yaakka tiiŋjede, i cääy keeñ tük oon ŋäc kä cokal. ");
INSERT INTO jum_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrayiim ke Caarra muuṭuk ḍuuŋdin, aŋ Caarra yuungu yek giidä agee kä aaygin. ");
INSERT INTO jum_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Aŋ Caarra yircin woo, aŋ jaajjin jone ti ogo, “Ika ṭiindänä aŋ oori daandin, tiññani ika bi käñä jon ñamme yaanni?” ");
INSERT INTO jum_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Aŋ Pïṭo Abrayiim taaññe ogo, “Caarra yïṭï ina aŋ jaay ogo, ‘A gïtken ika bi käñä minneni i ika ṭiindänä aŋŋi?’ ");
INSERT INTO jum_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ginkalaŋ bilti yaana Pïṭo yoje ye? Yun yaanja ti ika bi ḍuuku bata waan yaanni ti, aŋ Caarra bi käñï minneni.” ");
INSERT INTO jum_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Aŋ Caarra booccu ti, aŋ riccin woo aŋ jaajjin ogo, “Ika batta agä yïrcïdïnï woo.” Aŋ kiini Pïṭo ogo, “Ina, ïkï yircini woo.” ");
INSERT INTO jum_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Aŋ wääna ook ḍaŋŋene kä amma ye, juwin ñaalok aŋ däämjin kä taaŋŋä Caduum. Aŋ wääna atene kä ye Abrayiim attä ke iken iiccede päy jï. ");
INSERT INTO jum_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Aŋ Pïṭo jaajjin ogo, “Abrayiim yoku müngü kä gin'a ṭäkkä naŋä ye? ");
INSERT INTO jum_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Aŋ Abrayiim bi wäätï a ṭoŋ yäwken aŋ teyken, aŋ ike bi wäätï a ŋüülkïnnï yek ṭoŋ ḍiirken ŋommañ wic muure. ");
INSERT INTO jum_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ike wäägänä woo, a m'ana bi ïnï merkä yeeke ke mä äntüke yeene kä tïïññä päy yen Pïṭo kä naŋdin nääŋkä ŋerkä, ke nääŋkä wotku ye. Aŋ wäättan nääŋkä yaaka kiinnä kä Abrayiim ye bi näŋgä daa kä muure.” ");
INSERT INTO jum_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Aŋ Pïṭo Abrayiim kiinne ogo, “Ika tiiŋŋä yääw yen mä Caduum ke Amuura, kä yaana nääŋkä yaackä yeeken ḍiirene kä yaac ye. ");
INSERT INTO jum_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ika atä ïñï yuṭu nääŋkä yaackä yeeken bata yaana tiiŋŋä cïŋtäŋ ye. Naana batta a gïtken ye, ika ṭäkä ooku gïtï.” ");
INSERT INTO jum_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Aŋ ook ñomgen ṭuki woo üŋjïdï Caduum, aŋ Abrayiim ken buccin yudit Pïṭo ñome ti. ");
INSERT INTO jum_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Aŋ Abrayiim wükcïn ti ike ti, aŋ taaññe ogo, “Mä wotku ke mä yaackä bi nägä ḍugin muure? ");
INSERT INTO jum_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Aŋ naana mäkkalaŋ bilti wodaŋ caykä kä duuc baan mooye jï ye, nänṭä yoku üülü wic? Batta nänṭä kura bi daljä kä mä wotku yaaka caykä kä duuc jïñe ti ye? ");
INSERT INTO jum_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ïkï batta lïïṭä näŋä gin bata yaanna, kä näŋŋä ḍugin mä ŋerkä ke mä yaackä muure. Ïkï mä ŋerkä ke mä yaackä naŋdä kä nääŋkä keellä ina! A gïtken ïkï batta lïïṭä näŋjä aŋan! Batta yoku juco yen ŋommañ wiñe muure näŋï gin'a wodaŋ ye?” ");
INSERT INTO jum_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Aŋ Pïṭo jaajjin ogo, “Naana ika käññä mä wotku caykä kä duuc Caduum jï ye, baan mooye jïñe muure bi daljä ogo iken.” ");
INSERT INTO jum_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Aŋ Abrayiim jaajjin ogo, “Ika uccunu kä jiik ke Mügdo, i ika inni agä ŋomgu ke ṭaaṭaŋ käpet yaanni. ");
INSERT INTO jum_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Aŋ bi beel ogoo naana mä wotku yaaka caykä kä duuc yaakka buunjin kä duuc ye? Baan mooye muure bi ḍüümü gïtï kä buunjin yen me kä duuc?” Aŋ Pïṭo jaajjin ogo, “Naana ika käññä caykä kä ŋan witken kä duuc ye, i baan mooye batta ḍüümü gïtï.” ");
INSERT INTO jum_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Aŋ ŋoci taaji Abrayiim ogo, “Aŋ naana ïkï käññi mä ŋerkä caykä kä ŋan wïca ye?” Aŋ luugi Pïṭo ogo, “Batta bi ḍüümü gïtï kä yaaka caykä kä ŋan yaakka.” ");
INSERT INTO jum_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Aŋ Abrayiim jaajjin ogo, “Mügdo, ŋana ïkï pendä, dalä ika jaayä. Aŋ naana ïkï käññi mä ŋerkä caykä kä ḍäk wïca ye?” Aŋ luugi Pïṭo ogo, “Batta bi ḍüümü gïtï naana ika käññä caykä kä ḍäk wïca ye.” ");
INSERT INTO jum_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Aŋ Abrayiim jaajjin ogo, “Ika uccunu jiik ke Mügdo, aŋ dalä ika iiñjädä. Aŋ naana ïkï käññi mä ŋerkä caykä kä yewwe wïca ye?” Aŋ luugi Pïṭo ogo, “Batta bi ḍüümü gïtï kä yaaka caykä kä yewwe yaakka.” ");
INSERT INTO jum_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Aŋ düüñïn ti Abrayiim jaajjin ogo, “Mügdo, ŋana ika pingadaa, naana ïkï ŋoceni taajeni ääŋi kä keelok ye. Aŋ naana ïkï käññi mä ŋerkä kä caay wïca ye?” Aŋ luugi Pïṭo ogo, “Batta bi ḍüümü gïtï kä yaaka kä caay yaakka.” ");
INSERT INTO jum_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Aŋ wääna Pïṭo ḍaŋŋee kä jiik ke Abrayiim ye, ike ḍakkä aŋ Abrayiim ḍukcin baanne. ");
INSERT INTO jum_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Aŋ malaŋŋi kä yewwe äätin baan mooye yen mä Caduum biigin ti aŋŋi, i Luut cääy äntüke yen baan mooye ti. Aŋ wääna malaŋŋi yooṭṭeeda kä ye, ike juwin ñaalok paakke aŋ ḍüŋjïn ïñï, aŋ waŋge kümjene ïñï ŋomgu gïtï. ");
INSERT INTO jum_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Aŋ ike jaajjin ogo, “Mügdoni yeeki, ääte paa ba' kiingon yeenic. Aŋ kïïgïc looke woo, aŋ ïkïïn nïïnïn tiññaŋ aŋ ikee murje woo kä tïṇṇäŋänä.” Aŋ iken luukcin ogo, “Ba'ay, ikoon bi nïïnon woo käpet.” ");
INSERT INTO jum_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Aŋ ïïrï Luut ke gïmmene, aŋ wooyne ti baanne. Aŋ tutkene waak äämkä ḍiirken ke bïggï yaaka batta cääyge ti ŋimin ye, aŋ iken ämmä. ");
INSERT INTO jum_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","I iken batta mor ootunu, ook muure yek baan mooye yen mä Caduum dürjï ke dänkä duurin än yeenen küürï ti. ");
INSERT INTO jum_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Aŋ Luut yaawgä ogo, “Wali ook yaaka äätin baannü biigin ti tiññaŋ ye? Ickoon kä woo dalä nïïnon.” ");
INSERT INTO jum_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Aŋ Luut kaaccä woo iken ti, aŋ äntüke üüljene ŋäñe ti. ");
INSERT INTO jum_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Aŋ jaajjin ogo, “Ba'ay, müggü yeeki, yiñ yaanna ŋana naŋde. ");
INSERT INTO jum_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Däämme, ika cääyga ṭulgu kä yewwe yaaka kücï ook ye. Dale ken äcke kä woo, aŋ naŋe nääŋk'a daa ṭäkke naŋe daa kä ye. Ŋana ook yaakki naŋde nääŋkalaŋ, iken a wilgä yeeki aŋ tïïjä kä ika.” ");
INSERT INTO jum_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Aŋ luugi ogo, “Wükcü woo päy yoono waŋ,” Aŋ iken jaajjin ogo, “Men yaanni äätin winni a boorgon, aŋ ṭäkï ïkïïn nüütkïtï nääŋka naŋtïn ye! Ïkï bi näŋgini yiñ käärcï woo kä iken.” I iken wüükïdï ti Luut ti atï ṭäkï äntüke liktä gïtï. ");
INSERT INTO jum_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Aŋ malaŋŋi ïnken lajji woo, aŋ Luut guuŋi ti äräk aŋ äntüke üüljï. ");
INSERT INTO jum_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Aŋ ook muure yaaka yudok äntüke tük dürjï ke dänkä ye, uuyi waŋgin nuŋko ŋana äntüke kañte daa. ");
INSERT INTO jum_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Aŋ malaŋŋi Luut taaji ogo, “Ïkï cääygi ŋaannä winni? Ïkï cääygi märäŋgünü, ke ooglen yüükü, ke tïïrïn yüükü, ke mä yüükü yakkalaŋ baan mooye jï winni? Äcci woo nänṭä yaanni ti. ");
INSERT INTO jum_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ikoon ṭäkon nänṭä yaanni ḍüümon gïtï. Cïŋtäŋ yen yiñ mä baan yaanni ḍakkä ti Pïṭo ti, aŋ ikoon tuujonon ogo ḍüümjon gïtï.” ");
INSERT INTO jum_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Aŋ Luut attä nüütkïdï märäŋgene yaaka a ḍüccïnï jiik ṭäkï ḍïjï ṭulge ye, aŋ kiinne ogo, “Kä bïraŋ juwe kaace woo nänṭä yaanni ti! Pïṭo baan mooye ṭäkke ḍüüme gïtï.” Aŋ iken ḍüücï ogo ike ñääyo ogo ñääyon. ");
INSERT INTO jum_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Aŋ wääna buur kääjenee kä ye, malaŋŋi Luut jüümï yok ogo, “Kä bïraŋ, ïïŋü koowu ke tïïrïn yüükü yaaka kä yewwe winni yaakki. Aŋ kaace woo tiññaŋŋi, nuŋko ikee cüccete woo ke baan naana jooññu ätä ye.” ");
INSERT INTO jum_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Aŋ wääna Luut juugge riijjene kä ye, mügï malaŋŋi kä ïṇte aŋ iiŋe mügï kä ïṇte aŋ cäänna tïïrïn yeeke yaaka kä yewwe ye, müügï kä ïnken aŋ ici woo baan jï ṭeṭaŋ, nääŋka ängene daa ŋïngïn Pïṭo ye. ");
INSERT INTO jum_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Aŋ wääna äbene daa kä woo ye, kiini malak yaŋkalaŋ ogo, “Buurce woo üde, aŋ ŋana ikee däämmede ŋäjäk, aŋ ŋana ikee yuutcede ïñï nänṭä yaŋkalaŋ ti ḍääñgon jï. Lüüde nänṭä pämkä nuŋko ikee cüccete me woo!” ");
INSERT INTO jum_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Aŋ kiini Luut ogo, “Ba'ay, kura Mügdoni yeeki. ");
INSERT INTO jum_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Kiingon yeenic käññä ŋerrä ikee ti aŋ ika nüütkana biilin yaana batta düüñïdï ye, kä daljin üṇṇü yeeni. Aŋ ika batta bi lïïṭä lüüdü nänṭä pämkä, nuŋko ika wäätta ŋäc jooññu aŋ ika tüwdü. ");
INSERT INTO jum_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yooru, baan yaanni ike cokulaŋ ti, aŋ dalä ika lüüdü ike ti, aŋ ike cäänna ḍeeraŋ, tiiŋgaa dalä ika lüüdü nänṭä yaana ḍeeraŋ yaanja ti, nuŋko üdü kä.” ");
INSERT INTO jum_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Aŋ kiini malak ogo, “Jiik yüükü yaaka kiinnaa kä yaakka gïmgänä, aŋ baan yaanna batta bi ḍüümü gïtï. ");
INSERT INTO jum_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kä bïraŋ, lüüdü nänṭä yaanja ti, ika batta bi lïïṭä näŋä ginkalaŋ i ïkï batta mor ḍakci ti.” Aŋ ina ken baan yaanna äkkene daa me ogo Coogaar yaanna ogo ḍeeḍoḍeet. ");
INSERT INTO jum_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Aŋ Luut ḍakkä ti Coogaar i äŋ kääjïdï. ");
INSERT INTO jum_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Aŋ Pïṭo puukin ïñï cägärey kä polloŋ jïnä Caduum ti ke Amuura. ");
INSERT INTO jum_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Aŋ bänkä yaakca ḍüümme gïtï ke ḍääñgon ke m'aka cäyok bänkä gïtï ye, ke waak garkä yaaka a yülïn ye muure. ");
INSERT INTO jum_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Aŋ iŋ Luut däämjin ŋäjäk, aŋ wäättä a taŋkuulu yen äyyä. ");
INSERT INTO jum_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Aŋ Abrayiim cuuyin kä tïṇṇäŋänä aŋ ḍukcin nänṭä yaana yuuttee kä Pïṭo ñome ti ye. ");
INSERT INTO jum_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Aŋ ike däämjin ïñï taaŋŋä Caduum ke Amuura, ke taaŋŋä ḍääñgon ti, aŋ jiinä yooṭṭe ḍüüŋïdï ñaalok kä yaac ŋommañ jï, bata jiinä yek käälmaañ. ");
INSERT INTO jum_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Aŋ Jooŋ wääna bänkä mäyken yaaka cäyok ḍääñgon jï ye ḍüümmeeda kä gïtï ye, Abrayiim pajjene aŋ Luut määgene woo jooññu yaana näŋŋä ḍoŋe bänkä yaaka cääynee kä gïtï ye ti. ");
INSERT INTO jum_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Aŋ Luut booññu kä cäwdä Coogaar aŋ baŋŋä ke tïïrïn yeeke yaaka kä yew ye, aŋ attä cääjjin ṭuum pämkä gïtï. ");
INSERT INTO jum_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Aŋ nïïnnä yaŋkalaŋ ti tïïron yaana a kaygon ye, käwen ḍeerconḍe kiinne ogo, “Wäyo ḍuuŋdin, aŋ baati oon yaŋkalaŋ winni yaana ïkïï koowï ye, bata poñ yen me muure ŋommañ wic ye. ");
INSERT INTO jum_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Äätä wäyo nääkkï määk, aŋ wäättana ïkïï nïïnï ke ike aŋ wina ïkïi bi ääcï woo kaaynä wäyo ti.” ");
INSERT INTO jum_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Aŋ wïïrïn jïñe yaanja ti wäyen nääkki määk, aŋ tïïron yaana a kaygon ye kaaccä aŋ nïngïn ke wäyen. Aŋ nïïnjïn yaana nïïnjenee kä ke juwin yaana juwenee kä ye kucu wäyen. ");
INSERT INTO jum_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Aŋ tïṇṇäk aŋŋi tïïron yaana a kaygon ye, käwen ḍeerconḍe kiinne ogo, “Wïïrïn tiinuk ikoon nïïnnon ke wäyo, ŋocï nääkkï määk wïïrïn, aŋ ïkï kaacci nïïne ke ike nuŋko ääcii kä woo kaaynä wäyo ti.” ");
INSERT INTO jum_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Aŋ wïïrïn jïñe yaanja ti wäyen ŋoci määtki määk, aŋ tïïron yeene ḍeerconḍe attä kaaccä nïïnnene. Aŋ nïïnjïn yaana nïïnjenee kä ke juwin yaana juwenee kä ye kucu wäyen. ");
INSERT INTO jum_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Aŋ Luut tïïrïn yeeke muuṭuk laacce. ");
INSERT INTO jum_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Aŋ kaygon giiṇṇä minneni oone aŋ äkkene ogo Muwaab. Aŋ ike ken a wäy yen mä Muwaab ke tiññaŋ. ");
INSERT INTO jum_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Aŋ tïïron ḍeerconḍe yeene giiṇṇä minneni oone cäänna, aŋ äkkene ogo Benaammi, aŋ ike ken a wäy yen mä Amüün ke tiññaŋ. ");
INSERT INTO jum_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Aŋ Abrayiim nänṭä yaanja bäkkene wic attä nänṭä battä me ogo Najïp ye, aŋ cääjjin waan Gaadic ke Cüür, aŋ wäättan ike baŋŋä Jaraar. Aŋ cääy wïca bata boorgon, ");
INSERT INTO jum_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","aŋ wïca Abrayiim jaajjin kä iiŋe Caarra ogo, “Ike a käwo.” Aŋ Abimaliik yätkä yen mä Jaraar Caarra tuckene aŋ koowne. ");
INSERT INTO jum_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Aŋ wïïrïn jïñe yaanja ti Jooŋ äätin Abimaliik ti kä lääggï aŋ kiinne ogo, “Ïkï bi tüwü kä iiŋ yaanna, iiŋ yaana koowni yaanna a iŋ mäŋkalaŋ.” ");
INSERT INTO jum_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Aŋ Abimaliik batta mor nïnok ke Caarra, i ike jaajjin ogo, “Mügdo, ṭoŋ yaaka ḍuuggen ladaŋ ye bi ḍüümü gïtï? ");
INSERT INTO jum_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Batta a Abrayiim ken ika kiinna ogo, ‘Ike a käwo halla?’ Aŋ ike kä ḍoŋe gïmmïn aŋ jaajjin ogo, ‘Ee, ike a määdo.’ Nääŋkä yaakka naŋŋä kä jon laṇṇe, aŋ kä ḍoŋ laṇṇe.” ");
INSERT INTO jum_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Aŋ cäänna kiini Jooŋ lääggï ti ogo, “Ee, ŋäjjä ïkï jonü ladaŋ. Ina ken ṭïïŋŋenii kä näŋgin ika nääŋkä yaackä yaanna, aŋ batta bääggenenii kä tabjeeda kä yok yaanna. ");
INSERT INTO jum_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tiññaaŋŋi juwu iiŋ ḍuukku oore, oore a bäṭo, ike bi mälcï ñaalok kä ïkï aŋ ïkï bi üdü. Aŋ naana batta ḍuukkedeeda kä ye, ookci gïtï ïkï ke mä yüükü ikee bi tüwe muurijaan.” ");
INSERT INTO jum_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Aŋ kä tïṇṇäŋänä Abimaliik kiinkä yeeke muure bärkene ti, aŋ wääna nüütkeneeda kä gin'a näŋŋä ḍoŋe muure ye, i iken bojgin kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Aŋ Abrayiim bärki Abimaliik aŋ taaññe ogo, “A ŋaaka inni näŋgonoon kä yaanni? I ïkï yälkeneni jiik ŋaaka yaana ickaa kä ḍok nääŋkä yaackä ke yätkïtïn yeeni yaanni? Ïkï ika näŋganaa nääŋkä yaaka batta päjjïdï naŋtä me ye.” ");
INSERT INTO jum_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Aŋ Abrayiim taaji Abimaliik ogo, “A ŋaaka ken yoorri ina ke näŋii kä nääŋkä yaakka yaanna?” ");
INSERT INTO jum_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Aŋ luugi Abrayiim ogo, “Ika ḍuucu ogo me winni batta bojgo ko Jooŋ, aŋ iken bi ṭäko iiŋ yeeni aŋ ika bi nägjada ḍok aŋ koowjï. ");
INSERT INTO jum_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Aŋ a gïtken a käwo ṭul wäyo, aŋ batta a ṭul miyo ken koownu a iiŋ yeeni. ");
INSERT INTO jum_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Aŋ wääna kiinana kä Jooŋ ogo än wäyo mañjoo ïñï, aŋ ika atco nänṭä ke nänṭä ti ye, ike kiinnä ogo, ‘Näŋgaa ŋerrä. Nänṭä yaana atï kä ye, ïkï jaajjä ogo ika agjo määdic.’” ");
INSERT INTO jum_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Aŋ Abimaliik kuññu ḍiik ke däk ti, aŋ kuññu kiinkä oogen ke määngen yeeke ti, aŋ iññe Abrayiim. Aŋ ike cäänna iŋ Abrayiim Caarra ḍuukkeneeda kä. ");
INSERT INTO jum_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Aŋ Abimaliik jaajjin ogo, “Ŋommañ yeeni daamjä muure aŋ wäkä nänṭä yaana ṭäkkä cääyii kä ye.” ");
INSERT INTO jum_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Aŋ Caarra kiinne ogo, “Määdic iñdä tiilgä gälkä waŋgen 1,000. Yaanni nüütï m'aka ke ïkï ye ti, ogo ïkï ḍoŋü lado lat. Aŋ dalä me muure ŋäjjä ogo ïkï batta agjey näŋon ginkalaŋ yaana yaajoyaac ye.” ");
INSERT INTO jum_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Aŋ Abrayiim mälcin ñaalok Jooŋ ti, aŋ Jooŋ iŋ Abimaliik ke kiinkä yeeke yaaka a määngen ye ṭeeññe, aŋ wäättan iken käññä merkä ŋuca. ");
INSERT INTO jum_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kä yaana Pïṭo määngä yaaka ba' Abimaliik ye kurku yeeken yek giidä üüljeneeda kä gin'a näŋŋä ḍoŋe Caarra iŋ Abrayiim ti ye. ");
INSERT INTO jum_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Aŋ Pïṭo Caarra näŋgene ŋerrä bata yaana kiinneeda kä ye, aŋ gin'a irkeneeda kä jiik ye näŋgeneeda kä. ");
INSERT INTO jum_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Aŋ Caarra laaccä aŋ Abrayiim gitkene oonle i a daan aŋan, kä waan yaana kiinene daa kä Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Aŋ Abrayiim oonle yaana gitkene daa kä Caarra ye, äkkene ogo Icaak. ");
INSERT INTO jum_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Aŋ wääna Icaak nïïnke aŋŋene cunuuk ye, eri Abrayiim bata yaana iingene daa kä Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aŋ Icaak wääna giidene daa kä me ye i Abrayiim yuunge 100. ");
INSERT INTO jum_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Aŋ Caarra jaajjin ogo, “Jooŋ ika iñña tüggïn yaalgä, aŋ m'ana bi tïïŋï ye bi yiṭon kä.” ");
INSERT INTO jum_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Aŋ ike cäänna jaajjin ogo, “A ŋaani ken yoku Abrayiim kiine ogo Caarra bi niito merkä? Inni gitkänä oonle i ike aŋŋi daan yaanni.” ");
INSERT INTO jum_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aŋ Icaak kaarrä aŋ tääkki me kä aak, aŋ nïïnnä yaanja ti Abrayiim tuttu poñ waak äämkä. ");
INSERT INTO jum_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Aŋ Caarra Icämayiil yaana a giiton kä Abrayiim Haajir yen mä Macïr ti ye, yoorre minneni Icaak kääje yok. ");
INSERT INTO jum_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Aŋ ike Abrayiim kiinne ogo, “Kiingon iiŋe yaanni ñoolci woo ke minneni yeene, kiingon iiŋe yaanni minneni yeene batta bi ñääkï yäṇṇä ke minneni yeeni Icaak.” ");
INSERT INTO jum_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Aŋ Abrayiim jone yaaññä kä jiik yaakka kä yaana Icämayiil agee kä minneni yeene ye. ");
INSERT INTO jum_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Aŋ Abrayiim kiini Jooŋ ogo, “Ŋana jonü yaajaŋ kä oonle ke kiingon iiŋe yüünü. Jiik yaaka kiingi kä Caarra ye ken tiiŋä, aŋ kä Icaak kaaynä yüükü bi käjä woo. ");
INSERT INTO jum_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Aŋ ika cäänna bi näŋä ṭoŋ yek kaaynä Icämayiil minneni Haajir, kä yaana agee kä minneni yüünü cäänna ye.” ");
INSERT INTO jum_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Aŋ kä tïṇṇäŋänä aŋŋi Abrayiim juwin ñaalok, aŋ kuññu amma ke kücam piik aŋ iññe Haajir. Aŋ ŋääpkeneeda kä büyke ti. Aŋ tucce woo ke oonle, aŋ ike attä päy jï aŋ yääynä woo teettälaŋ nänṭ'a battä me ogo Bïïrcïba ye, aŋ aŋan ogo Jïïn Lïïttäŋ. ");
INSERT INTO jum_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Aŋ wääna piik baawkene kücam jï ye, minneni maaṭṭe ïñï jaan ŋoy. ");
INSERT INTO jum_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Aŋ attä cääjjin ïñï woo pare kä meec, i ñome agee kä ṭukon woo, aŋ ike jaajjin ogo, “Ika batta ṭäkä minneni tüw i yooddu.” Aŋ ike cääy ïñï wïca i waŋge dürok kä ïwok. ");
INSERT INTO jum_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Aŋ Jooŋ ïwok minneni tiiŋene ïñï, aŋ Haajir bärki malak yen Jooŋ kä ñaalok polloŋ jïnä ogo, “Haajir, a ŋaaka ken yaajaŋ? Ŋana ïkï booju! Ïwok minneni tiiŋi ïñï Jooŋ nänṭ'a nïïnee kä ye. ");
INSERT INTO jum_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Atä minneni koowu ñaalok ïntü ti, ike bi naŋä wäätï a ṭoŋ yäwke.” ");
INSERT INTO jum_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Aŋ ike kupki waŋgin Jooŋ aŋ yurcin jïïn a küümon kä piik. Aŋ ike attä kä bïraŋ kücam yeene küümgene kä piik aŋ äckene minneni mätcin. ");
INSERT INTO jum_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Aŋ Jooŋ daa ke minneni ke täle woo teettälaŋ luummuk. Aŋ wäättä a m'ana yaacänä yok kä ḍiŋŋä cäwgä ye. ");
INSERT INTO jum_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Aŋ wääna cääynee kä woo teettälaŋ nänṭ'a battä me ogo Paaraan ye, ḍijgi meen iiŋ ŋommañ mä Macïr ti. ");
INSERT INTO jum_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Aŋ waan yaanja ti Abimaliik äätin ke Paykool ḍuuŋgon kääygä yeeke ükcïdï Abrayiim aŋ kiinne ogo, “Jooŋ ke ïkï nääŋkä yaaka naŋdä muure ye ti. ");
INSERT INTO jum_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Lïïtkaa kä yäṇtäŋ Jooŋ ogo ika batta bi maljada ŋïngïn ke merkä yeeki ke kaaynä yeeki. Ïkï näŋgeneni nääŋkä ŋerkä, aŋ lïïtä ogo ika bi näŋgada nääŋkä ŋerkä ke baan yaana cääyii kä jï agii kä boorgon yaanni.” ");
INSERT INTO jum_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Aŋ Abrayiim jaajjin ogo, “Ika lïïtä.” ");
INSERT INTO jum_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Aŋ Abrayiim cïŋŋä Abimaliik ti kä yaana jïïn piik koojjene daa kä woo kiinkä Abimaliik kä ookïtïn kiinkä yeeke ti ye. ");
INSERT INTO jum_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Aŋ luugi Abimaliik ogo, “Kuju a ŋaani ken näŋŋä nääŋkä yaakka. Ïkï ika batta agja kä nüütkïdïnï, inni mor daa tiiŋdä tiññaaŋŋi yaanni.” ");
INSERT INTO jum_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Aŋ Abrayiim Abimaliik äckene woo ḍiik ke däk, aŋ iken muuṭuk näŋŋä jiik ḍoocin. ");
INSERT INTO jum_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Aŋ Abrayiim ŋuccin wääkin woo käbälgä määngen kä ŋaṭükel aŋ ḍoocce woo pääken. ");
INSERT INTO jum_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Aŋ Abimaliik Abrayiim taaññe ogo, “Käbälgä määngen yaaka wäägini woo kä ŋaṭükel aŋ ḍoocci woo pääken yaakki a yek ŋaaka?” ");
INSERT INTO jum_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Aŋ luugi Abrayiim ogo, “Käbälgä määngen yaaka kä ŋaṭükel yaakki gïmgä ïṇtï ti, dalä nüütï ogo jïïn yaanni küüññoo ko ika.” ");
INSERT INTO jum_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Aŋ nänṭä yaanja äkki me ogo Bïïrcïba, nüütï ogo nänṭ'a lïïttïï ko Abrayiim ke Abimaliik ye. ");
INSERT INTO jum_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Aŋ wääna näŋŋene jiik ḍoocin Bïïrcïba ye, Abimaliik ke Paykool ḍuuŋgon kääygä yeene ḍukcin baan yen mä Palactïïn ti. ");
INSERT INTO jum_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Aŋ Abrayiim pïïttä jaan battä me ogo tamaric ye Bïïrcïba ti, aŋ ike mäŋjin ñaalok Pïṭo Jooŋ yaana ke cüle ye ti. ");
INSERT INTO jum_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Aŋ Abrayiim cääynä bata boorgon baan mä Palactïïn ti nïïnkä kä ḍiräk. ");
INSERT INTO jum_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Aŋ wääna nääŋkä yaakki baakkene ye, Abrayiim puuci Jooŋ, aŋ kiinne ogo, “Ay Abrayiim!” Aŋ Abrayiim luukcin ogo, “Haa, ika inni.” ");
INSERT INTO jum_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Aŋ Jooŋ jaajjin ogo, “Minneni yüünü yaana a dune bilgä battä me ogo Icaak yaanna koowu, aŋ atä baan battä me ogo Müürïya. Aŋ aajjii kä pääm yaana bi nüütenii kä ye wic, aŋ eräpok dalä ïïl a yen wäämmä yok.” ");
INSERT INTO jum_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Aŋ Abrayiim juwin kä tïṇṇäŋänä, aŋ tüürüŋ yeene kooññe. Aŋ bäägin jengä yek ïïllä wäämmä yok. Aŋ kuññu kiinkä yeeke ti kä yewwe, ke minneni yeene Icaak. Aŋ attä kä päy nänṭ'a nüütene daa Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Aŋ nïïnnä ḍäk ti Abrayiim wiñe äärene ñaalok, aŋ nänṭä yooṭṭe kä utar. ");
INSERT INTO jum_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Aŋ Abrayiim kiinkä yeeke kiinne ogo, “Cääye winni ke tüürüŋ, dale ikoon aton mäṭon Jooŋ ke minneni, aŋ ikoon ḍuukon ikee ti.” ");
INSERT INTO jum_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Aŋ Abrayiim kuññu jengä ïïllä wäämmä yok, aŋ äcce minneni yeene Icaak ŋäñe ti, i ädit maañ kä päṭäkay ke cïcam ïṇte ti, aŋ attä muuṭuk. ");
INSERT INTO jum_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aŋ Icaak wäyen Abrayiim bärkene ogo, “Abba!” Aŋ luugi wäyen ogo, “Haa, minneni yeeni.” Aŋ taaji Icaak ogo, “Jengä ke maañ ikki, aŋ wali kabal yaana erï puuggin ïïlï a yen wäämmä yok ye?” ");
INSERT INTO jum_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Aŋ luugi Abrayiim ogo, “Minneni yeeni, Jooŋ kä ḍoŋe bi ükcï kabal yaana erï puuggin ïïlï a yen wäämmä yok ye.” Aŋ iken attä muuṭuk nänṭä keellä. ");
INSERT INTO jum_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Aŋ wääna ḍakkene ti nänṭ'a nüütene daa Jooŋ ye, Abrayiim bättä tambal wïca, aŋ jengä tooṇṇe, aŋ minneni yeene Icaak ḍiiŋŋe, aŋ maaṭṭe ñaalok jengä witin tambal wic. ");
INSERT INTO jum_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Aŋ Abrayiim ïṇte lajjene, aŋ cïcam koowne irtee kä pok minneni yeene. ");
INSERT INTO jum_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Aŋ malak yen Pïṭo ike yääwi kä polloŋ jïnä ogo, “Abrayiim, Abrayiim!” Aŋ luukke ogo, “Haa, ika inni.” ");
INSERT INTO jum_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Aŋ malak jaajjin ogo, “Ïṇtü ŋana ïccïdï woo minneni ti, aŋ ŋana naŋdä nääŋkalaŋ. Ïkï ŋïññeni tiññaŋ ïkï booju kä Jooŋ, ika batta agja kä ṭïïkon kä minneni yüünü yaana kä keelok yaanna.” ");
INSERT INTO jum_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Aŋ Abrayiim wiñe äärene ñaalok däämjin, aŋ yurcin kabal yaane mooye ŋäñe ti a mükon kä jengä kä ṭuŋke waadgen gïtï. Aŋ attä kabal müŋŋe erre pok a yen ïïllä wäämmä yok rättee kä yok minneni yeene. ");
INSERT INTO jum_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Aŋ Abrayiim nänṭä yaanja äkkene ogo Pïṭo bi ïccï. Aŋ ke tiññaŋ battä me ogo, “Pïṭo bi ïccï pääm yeene wic.” ");
INSERT INTO jum_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Aŋ Abrayiim ŋoci yääwi malak yen Pïṭo kä polloŋ jïnä. ");
INSERT INTO jum_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Aŋ jaajjin ogo, “Pïṭo jääyïdï ogo, ‘Ika lïïttä kä ḍoŋi kä yaana näŋŋii kä nääŋkä yaakka, aŋ ika batta agjey kä ṭïïkon kä minneni yüünü yaana a dune yaanna, ");
INSERT INTO jum_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ïkï bi ŋüülkeni, aŋ kaaynä yüükü bi ḍiirä kä yaac, bata kirkä polloŋ jïñe ke ṭiŋal yek wii jïñe. Aŋ kaaynä yüükü bi bänkä ädäŋŋi mükü. ");
INSERT INTO jum_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Aŋ kä päy kaaynä yüükü ṭoŋ muureen bi a ŋüülkïnï ŋommañ wic nääŋka tiiŋganaa kä jiik ye.’” ");
INSERT INTO jum_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Aŋ wäättan Abrayiimmä ḍukcin kiinkä yeeken ti, aŋ juwin attä ke iken jïïn yaana battä me ogo Bïïrcïba ye ti, aŋ Abrayiimmä cäygin wïca. ");
INSERT INTO jum_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Aŋ wääna yaakka ti muure ye, Abrayiim nüütkï me ogo, “Määdic Nahüür gitki Maalka merkä. ");
INSERT INTO jum_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Kaygon battä me ogo Üüc, aŋ määden a Büüc, ke Gamuweel Aaraam wäyen, ");
INSERT INTO jum_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ke Kaacit, ke Hajju, ke Pïldaac, ke Yaldaap, ke Batüwïïl.” ");
INSERT INTO jum_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Aŋ Batüwïïl gittä Rïpga. Aŋ Maalka merkä yaaka kä cunuuk yaakka gitkene Nahüür Abrayiim määden. ");
INSERT INTO jum_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Aŋ kiingon iiŋe yeene yaana battä me ogo Ruhuma ye, cäänna ike gitki merkä oogen, aŋ yäṇtäŋgenen ogo, Taabaa ke Jaam ke Taac ke Maakkaa. ");
INSERT INTO jum_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Aŋ Caarra cääynä yuunge 127. ");
INSERT INTO jum_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Aŋ tüwnü nänṭä battä me ogo Gariya Arba, aŋ tiññaŋ battä me ogo Hiburoon, ŋommañ yen mä Kanaan jï, aŋ Abrayiim attä nüüjï kä Caarra aŋ week ogo ike. ");
INSERT INTO jum_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Aŋ Abrayiim juwin ñaalok iiŋe tüwon gunne ti, aŋ ike ḍuuŋku yek mä Haat kiinne ogo, ");
INSERT INTO jum_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ika winni agä boorgon, aŋ agä willä waadgic ti. Kura yääjga ŋommañ taaŋŋe dale jïkcä ïñï män tüwon yeeni.” ");
INSERT INTO jum_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Aŋ mä Haat Abrayiim luugi ogo, ");
INSERT INTO jum_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Mügdo tiiŋä por, ïkï agä yätïn yen Jooŋ waadgo ti. Wäkä kälkä witken yooko ti yaana lïïkïdï ye, aŋ jïkcï ïñï wïca. Ikoon ti baati m'ana ïkï bi ṭïïgey kä kääl yeene yaana jïkïï kä män tüwon yüünü ye.” ");
INSERT INTO jum_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Aŋ Abrayiim juwin ñaalok aŋ ḍüŋjïn ïñï mä Haat ñomgen ti. ");
INSERT INTO jum_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Aŋ ike jaajjin iken ti ogo, “Naana ika gïmgana kä jïŋŋä män tüwon yeeni ye, por tiiŋe ika ti, Aproon tääcka kä minneni yen Cuwaar, ");
INSERT INTO jum_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","dale ika yääjga ṭuum yaana Makapeela jï a yeene ina, aŋ bilti nänṭ'a düüñete yiil yeene ye. Taaje dale yääjga kä, kä weel yaana bilti ye muure, wäätï a nänṭä yeeni yaana jïkä kä mä yeeki ye waadgic ti.” ");
INSERT INTO jum_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Aŋ Aproon daa bilti cääy mä yeeke waadgen gïtï, aŋ Abrayiim luuŋŋe i tiŋtä mä Haat muure yaaka äätin äntüke yen baan mooye yeene ti ye. ");
INSERT INTO jum_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Aŋ ike jaajjin ogo, “Ba'ay, mügdo, por tiiŋä ika ti, yiil yeeni ke ṭuum yaana jïñe ti ye iñenii kä. Iñenii kä mä yeeki ñomgen ti. Män tüwon yüünü jïgä.” ");
INSERT INTO jum_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Aŋ Abrayiim ŋuca ḍüŋjïn ïñï mä baan ñomgen ti, ");
INSERT INTO jum_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","aŋ ike Aproon luuŋŋe i tiŋtä me muure ogo, “Ba'ay, tiiŋä ika ti, dalä ika äccä weel yeene muure. Äccin yeeni gïmgä aŋ män tüwon yeeni bi jïkä ïñï wïca.” ");
INSERT INTO jum_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Aŋ Aproon Abrayiim luuŋŋe ogo, ");
INSERT INTO jum_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Tiiŋä ika ti mügdo, ŋommañ kä tiilgä gälkä waŋgen 400, aŋ yaanni a ŋaaka waadgo ti ika ke ïkï? Män tüwon yüünü jïgä.” ");
INSERT INTO jum_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Aŋ Abrayiim gïmmïn kä weel yen Aproon, aŋ kïïlkene tiilgä gälkä waŋgen 400 bata weel yaana jaajjenee kä mä Haat ñomgen ti ye. Aŋ kïïlle bata kïïllä yaana kïïṭene kä yääjoni ye. ");
INSERT INTO jum_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Aŋ yiil yen Aproon yaana Makapeela jï cokulaŋ ti Mamar ina, kiyi Abrayiim, muuṭuk ke yiil ke ṭuum yaana jïñe ti ye, ke jengä muure yaaka yiil täŋke ti ye. ");
INSERT INTO jum_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Yääjgi me Abrayiim wäättä aŋŋa nänṭä yeene, mä Haat muure yaaka äätin äntüke yen baan mooye ti ye ñomgen ti. ");
INSERT INTO jum_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Aŋ wäättan Abrayiim iiŋe Caarra jïŋŋe, ṭuum yaana yiil jï Makapeela, cokulaŋ ti Mamar ye, aŋ cäänna battä me ogo Hiburoon, ŋommañ mä Kanaan jï. ");
INSERT INTO jum_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Aŋ yiil ke ṭuum yaana jïñe ti ye, yääjgi mä Haat Abrayiim wäättä aŋŋa nänṭä yeene yen jïŋŋä. ");
INSERT INTO jum_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Aŋ Abrayiim ḍuuŋdin kä yaac, aŋ ŋüülkï Pïṭo kä pääygä muure. ");
INSERT INTO jum_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Aŋ Abrayiim kiingon yeene yaana tälaŋ agee kä mükkïnï waak än yeene jïñe muureen ye kiinne ogo, “Näŋä lïïttäŋ kä ḍooccin ïntü ïñï ämgi ti. ");
INSERT INTO jum_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Lïïtä kä Pïṭo, Jooŋ yen polloŋ jïñe ke ŋommañ wiñe, ogo minneni yeeni batta bi kujgeey iiŋ tïïrïn yek mä Kanaan yaaka ikki ika cääyä waadgen ti yaakki. ");
INSERT INTO jum_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Atä baan yeeni ti, aŋ minneni yeeni Icaak kujgu iiŋ mä yeeki ti.” ");
INSERT INTO jum_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Aŋ ike taaji kiingon ogo, “Aŋ naana ṭuul batta ṭäkï äätin ke ika ŋommañ yaanni ti ye? Icaak bi koowu ḍuuku cäyok ke mä yüükü ŋommañ yaana äätii kä yaanja ti?” ");
INSERT INTO jum_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aŋ Abrayiim kulcin ogo, “Ba'ay, minneni yeeni ŋana ḍuukcudu ŋäjäk wïca. ");
INSERT INTO jum_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Pïṭo Jooŋ yen polloŋ jïñe yaana ika äbana woo än yen wäyo ti ke ŋommañ yaana giidana me ye jï, yaana ika kiinna, aŋ ika irkana jiik lïïttä ogo, ‘Ŋommañ yaanni bi iñje kaaynä yeeki ye.’ Ike bi tüccï malak ñomü ti, aŋ ïkï bi käñgey iiŋ yaana kujgu minneni yeeni ye wïca. ");
INSERT INTO jum_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Aŋ naana ṭuul batta ṭäkï ḍuukin ke ïkï ye, i ḍoŋü äbini woo lïïttäŋ yeeni yaanni ti. Gin'a bilti ye minneni yeeni ŋana ḍuukcudu ŋäjäk wïca.” ");
INSERT INTO jum_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Aŋ kiingon ïṇte ḍoocce ïñï mügdo yeene Abrayiim ämge ti, aŋ lïïttä kä jiik yaakka. ");
INSERT INTO jum_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Aŋ kiingon kuññu kälämgä Abrayiim ti kä caay, ke wakkä muure ŋerken yek ḍey, aŋ koocce kälämgä ŋätin, aŋ juwin üŋjïn nänṭ'a battä me ogo Araam Naareen ye. Aŋ wïca ike attä baan mooye yaana cääyge kä Abrayiim määden yaana battä me ogo Nahüür ye ti. ");
INSERT INTO jum_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Aŋ ike kälämgä ḍüüŋŋe jïïn wic kä cokal woo baan mooye taaŋ biigin ti aŋŋi. I a wuuŋ yaana atcete määngä tipene piik ye. ");
INSERT INTO jum_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Aŋ kiingon mälcin ñaalok ogo, “Ay Pïṭo, Jooŋ yen mügdo yeeni Abrayiim, gin'a ṭäkkä ye, ḍääkkaa kä tiññaŋ, aŋ mügdo yeeni Abrayiim nüütkü woo biilin yaana batta düüñïdï ye. ");
INSERT INTO jum_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Yuuru, ika inni yuddu jïïn taaŋŋe ti yaanni, aŋ tïïrïn yek mä baan mooye kääjïdï woo äätïdï tïpï piik. ");
INSERT INTO jum_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","A gin'a ṭäkkä ïkï ti ye inni. Yaŋkalaŋ bi ñujgu yok ogo, ‘Kura immä wäl yüünü iñja kä mätcä kä piik.’ Aŋ naana ike gïmmä ogo, ‘Ee, mätcä, aŋ kälämgä yüükü bi määtkä cäänna ye!’ I dalä wäätï a yaana wäägini woo a iŋ kiingon yüünü Icaak ye. Aŋan ken bi ŋäjjä daa kä ogo ïkï nüüteneey woo biilin mügdo yeeni ti.” ");
INSERT INTO jum_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Aŋ i ike batta mor ḍak kä mallä, oja Rïpga kääjin woo ke wäl yeene büüye ti. Ike a ṭul Batüwïïl yaana a minneni yen Maalka yaana a iŋ Abrayiim määden yaana battä me ogo Nahüür ina. ");
INSERT INTO jum_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Aŋ Rïpga a ṭuul ŋerconḍe kuckon, aŋ a päjjïdïnï koownu ti, aŋ ike mor kücï oon. Ike kaaccä ïñï wäl yeene küümgede kä piik, aŋ ḍuukin woo ŋuca. ");
INSERT INTO jum_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Aŋ kiingon bänjin ti ike ti kä bïraŋ, aŋ kiinne ogo, “Kura iñja ika mätcä piik kä ḍeewaŋ wäl yüünü ti.” ");
INSERT INTO jum_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Aŋ ike jaajjin ogo, “Mätcä, mügdo yeeni.” Aŋ oja wäl ïmmene ïñï kä bïraŋ, aŋ iññe mätcin. ");
INSERT INTO jum_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Aŋ wääna iññeeda kä mätcenee piik ye, jaajjin ogo, “Kälämgä yüükü bi määtkä piik cäänna ke yääŋene.” ");
INSERT INTO jum_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Aŋ kä bïraŋ piik wäl yeeke ṭüljene kuun jï, aŋ bülcïn ŋäjäk jïïdük ŋüücïdï piik, aŋ kälämgä muure puukkene piik. ");
INSERT INTO jum_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","I daamgä kiingon a daamgon i batta jääyïdï woo jiikkalaŋ, ukcedee kä gïtï naana wään yeene ḍääkkene daa Pïṭo ye. ");
INSERT INTO jum_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Aŋ wääna kälämgä ḍaŋŋene kä maaṇṇä piik ye, ike ääcin woo juma yen tiilgä ke tiikinni mäyken yek tiilgä kä yewwe yek ïnke ḍuuggen aŋ iññeeda kä. ");
INSERT INTO jum_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Aŋ taaññe ogo, “Ïkï agä ṭul ŋaani?” “Kura nüütkaa, wääc cääyge nänṭä yaana nïïnon kä wïïrïn jïñe yaanni ti ye?” ");
INSERT INTO jum_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Aŋ ike luugi Rïpga ogo, “Ika agä ṭul Batüwïïl yaana giitä kä Maalka ke Nahüür ina.” ");
INSERT INTO jum_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Aŋ ŋuccin jaajjin ogo, “Ikoon cäygon kä pïïroni ke beelgä ïwïn yaaka amgä kälämgä ye ḍiräk, ke nänṭä yen wilgä yaana nïïne kä wïïrïn tiññaŋ ye.” ");
INSERT INTO jum_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Aŋ kiingon ḍüŋŋü, aŋ mälcin ñaalok Pïṭo ti, ");
INSERT INTO jum_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","aŋ jaajjin ogo, “Ŋüülkïn ḍükcï Pïṭo ti, Jooŋ yen mügdo yeeni Abrayiim. Pïṭo nüütïn woo biilin yaana batta düüñïdï ye, ke luggin mügdo yeeni ti. Aŋ ike ika üüŋjana ti kä ba' mügdo yeeni mä yeeke ti.” ");
INSERT INTO jum_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Aŋ Rïpga lüüṇṇü paa ba' meen, aŋ me nüütkene kä waak'a näŋŋä ḍuuggen ye muureen. ");
INSERT INTO jum_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Aŋ Rïpga cääyge määden battä me ogo Laabaan, buurcin woo jïïn wic pärjïdï ke oon. ");
INSERT INTO jum_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Kä yaana yuṭṭee kä juma käwen umdonḍe ti ke tiikinni ïnke ḍuuggen ti, aŋ tiiŋŋee kä Rïpga päkee kä jiik'a kiinene daa kä oon ye. Aŋ ike kaaccä woo oon ookcede, aŋ kaññe yudit ke kälämgä jïïn ti kä cokal. ");
INSERT INTO jum_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Aŋ kiini Laabaan ogo, “Äätä, ïkï yaana agä ŋüülkïnï kä Pïṭo ye. Ïkï yuddu woo winni ina? Ïkï tutkeneni än ke nänṭä yen kälämgä.” ");
INSERT INTO jum_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Aŋ oon attä ti än ti, aŋ waak duudi me ïñï kälämgä ŋätin, aŋ kälämgä iñi me pïïroni ke beelgä ïwïn, aŋ oon icki me piik ke m'aka ike kïïtkätä kälämgä ye, lukene kïïgen. ");
INSERT INTO jum_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Aŋ amma äbi me woo yuuti me ñomgen ti. Aŋ kiingon yen Abrayiim jaajjin ogo, “Ika batta ämjädä amma ke jiik yaaka äätänä kä ye nüütke kä woo.” Aŋ kiini Laabaan ogo, “Ee ŋeraŋ, nüütkoon.” ");
INSERT INTO jum_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Aŋ nüütkene ogo, “Ika agä kiingon Abrayiim. ");
INSERT INTO jum_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Aŋ Pïṭo mügdo yeeni ŋüülkene kä yäw, aŋ ike wäättä aŋŋa ceeggon. Iñi Pïṭo ḍiik ke däk ke tiilgä gälkä ke tiilgä, ke kiinkä oogen ke määngen ke kälämgä ke tüürüŋŋï. ");
INSERT INTO jum_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Aŋ Caarra iŋ mügdo yeeni, ike mügdo yeeni gitkene woo oonle i ike a ṭiin, aŋ mügdo yeeni waak yeeke iññeeda kä muure yaaka mügde ye. ");
INSERT INTO jum_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Aŋ mügdo yeeni ika daljana lïïttä. Ike jaajjin ogo, ‘Ŋana minneni yeeni kujgudu tïïrïn yek mä Kanaan ti, yaaka ikki ika cääyä waadgen ti yaakki. ");
INSERT INTO jum_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Atä än yen wäyo ti aŋ äntüke yeeni ti, aŋ minneni yeeni kujgu iiŋ wïca.’ ");
INSERT INTO jum_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Aŋ mügdo yeeni taaññä ogo, ‘Aŋ naana ṭuul batta ṭäkï äätin ke ika ŋommañ yaanni ti ye?’ ");
INSERT INTO jum_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Aŋ ika luuŋŋa ogo, ‘Pïṭo yaana ika äätä ñome ti ye, bi tüccï malak yeene ke ïkï, aŋ wään yüünü bi ḍaage, aŋ nuŋko bi minneni yeeni käñgeeda kä iiŋ mä yeeki ti, äntüke wäyo ti ye. ");
INSERT INTO jum_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Aŋ naana ïkï atä mä yeeki ti ye, ḍoŋü bi latï woo kä lïïttäŋ yeeni, naana daa cäänna ïkï ṭïïgïnï kä iññä iiŋ ye, ḍoŋü bi latï woo kä lïïttäŋ yeeni.’ ");
INSERT INTO jum_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Aŋ tiññaŋ wääna äätänä kä jïïn ti ye, ika mälcänä ñaalok ogo, ‘Ay, Pïṭo, Jooŋ yen mügdo yeeni, Abrayiim, kura wään yeeni yaanni ḍääkkaa kä. ");
INSERT INTO jum_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Yuuru, ika inni yuddu jïïn taaŋ yaanni. Aŋ gin'a ṭäkkä ye inni. Naana ṭuul yaŋkalaŋ kääjin woo tïpï piik ye, bi kiinä ogo, “Kura iñja woo piik kä ḍeewaŋ wäl yüünü ti mätcä kä.” ");
INSERT INTO jum_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Aŋ naana ika kiinna ogo, “Mätcä, aŋ kälämgä yüükü bi puukku cäänna ye,” dalä ken wäätï a yaana wagi Pïṭo a iŋ minneni yen mügdo yeeni ye.’ ");
INSERT INTO jum_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Aŋ i ika batta mor ḍagä kä mallä joni ti, oja Rïpga kääjin woo ke wäl piik yeene büüye ti. Aŋ ike kaaccä ïñï wäl yeene küümgede kä piik, aŋ ike kiinnä ogo, ‘Kura iñja piik mätcä kä.’ ");
INSERT INTO jum_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Aŋ kä bïraŋ aŋŋi, wäl yeene immene ïñï aŋ jaajjin ogo, ‘Uŋgo mätcä, aŋ kälämgä yüükü bi puukku cäänna.’ Aŋ wääna mätcänä kä ye, kälämgä puukkene cäänna. ");
INSERT INTO jum_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Aŋ ike taaññä ogo, ‘Ïkï agä ṭul ŋaani?’ Aŋ ika luuŋŋa ogo, ‘Ika agä ṭul Batüwïïl yaana giitä kä Nahüür ke Maalka ina.’ Aŋ iiŋkänä juma umdonḍe ti, ke tiikinni ïnke ḍuuggen ti. ");
INSERT INTO jum_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Aŋ ika ḍüŋjünü ïñï aŋ ika mälcänä ñaalok Pïṭo ti. Aŋ Pïṭo maaŋŋä, Jooŋ yen mügdo yeeni Abrayiim, yaana ika nüüdana päy yaana wodaŋ ye ti, ke käñga kä ṭuul yen ṭul mügdo yeeni määden, yaana bi a iŋ minneni mügdo yeeni ye. ");
INSERT INTO jum_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Aŋ nüütka naana ikee mügdo yeeni bi nüütke woo biilin yaana batta düüñïdï ye ke luggin, aŋ naana a ba'ay ye, i nüütka dale ika atä nänṭä yaŋkalaŋ ti.” ");
INSERT INTO jum_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Aŋ luugi Laabaan ke Batüwïïl ogo, “Nääŋkä yaakki ätä Pïṭo ti, baati jiik'a jääyon woo ye. ");
INSERT INTO jum_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rïpga inana, koowu aŋ ate kä, aŋ dalä ike wäätï a iŋ minneni mügdo yüünü, bata yaana jaajjene kä Pïṭo ye.” ");
INSERT INTO jum_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Aŋ wääna kiingon yen Abrayiim tiiŋŋee kä jiik yeeken ye, ike ḍüŋjïn ïñï ŋomgu gïtï, aŋ mälcin ñaalok Pïṭo ti. ");
INSERT INTO jum_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Aŋ kiingon ääcin woo waak wïlkïtïn a naŋgin kä tiilgä gälkä ke tiilgä, ke buruŋgu, aŋ iññe Rïpga. Aŋ cäänna määden ke meen iññe wakkä yaaka weel yeenen caraŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Aŋ ike ke ook yaaka äätene ye, ämmä aŋ mättä aŋ nïngïn wïca. Aŋ wääna juwene ñaalok kä tïṇṇäŋänä ye, kiingon yen Abrayiim jaajjin ogo, “Tiiŋga, dale ika ḍukcu mügdo yeeni ti.” ");
INSERT INTO jum_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Aŋ määden ke meen jaajjin ogo, “Dalä por Rïpga cääjjï nïïnkä kä caay ke ikoon, aŋ wäättan ike atï.” ");
INSERT INTO jum_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Aŋ kiinne ogo, “Ŋana ika koora kä, Pïṭo wään yeeni ḍaaŋŋe. Tiiŋga dale ika ḍukcu mügdo yeeni ti.” ");
INSERT INTO jum_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Aŋ iken jaajjin ogo, “Dale ṭuul bärkïn, aŋ taacïn.” ");
INSERT INTO jum_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Aŋ Rïpga bärki, aŋ taaji ogo, “Ïkï gïmmädä ikee ate ke oon yaanni?” Aŋ luuŋŋe ogo, “Ee, ika bi atä.” ");
INSERT INTO jum_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Aŋ käwen Rïpga tuci ke kiingon yaana ike pïrï ye, ke kiingon yen Abrayiim, ke m'aka äätene kä ye. ");
INSERT INTO jum_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Aŋ Rïpga ŋüülkï, aŋ kiini ogo, “Käwo, ïkï wäätci agä miy yen me ḍiirken caykä mäyken kä caykäcaayni! Aŋ dalä kaaynä yüükü bänkä yek ädäŋŋi yeeken peecä.” ");
INSERT INTO jum_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Aŋ Rïpga ke kiinkä yeeke määngen taappä kälämgä, aŋ oon baati ŋäc. Aŋ kiingon yen Abrayiim Rïpga koowne aŋ attene kä. ");
INSERT INTO jum_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aŋ Icaak yaana cääy Najïp ina, ḍuku Bïïr Lahaayi Rooy, aŋ aŋan ogo, Jïïn M'ana a Üdon Ika Yoodda ye ti. ");
INSERT INTO jum_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Aŋ ääŋkalaŋ ti biigin ti aŋŋi, Icaak attä yiil jï, aŋ laay i jone jaay jiikkalaŋ, aŋ wääna wiñe ääreneeda kä ñaalok ye, ike yurcin kälämgä äätïdï. ");
INSERT INTO jum_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Aŋ Rïpga cäänna wääna wiñe ääreneeda kä ñaalok ye, Icaak yooṭṭe, aŋ ike kuuyin ïñï kalman yeene ŋäc kä bïraŋ. ");
INSERT INTO jum_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Aŋ kiingon taaññe ogo, “A oon yaana wali ye ïya yiil jï äätïdï ïkïïn päägïdïn yaanja?” Aŋ luugi kiingon ogo, “A mügdo yeeni.” Aŋ ike burŋu yeene koowne aŋ waŋge kümme. ");
INSERT INTO jum_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Aŋ kiingon Icaak päkkene waak'a naŋŋe ye muure. ");
INSERT INTO jum_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Aŋ Icaak Rïpga äbene keeñ yen meen Caarra jï, aŋ wäättä aŋŋa iiŋe. Aŋ bilgene, aŋ Icaak jone lüynü kä ike kä tüwnü meen. ");
INSERT INTO jum_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Aŋ Abrayiim ḍiññä iiŋ yaŋkalaŋ ŋuca battä me ogo Katuura. ");
INSERT INTO jum_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Aŋ ike gitki Jumraan ke Yakcaan ke Midaan ke Mïdïyaan ke Ïcbaak aŋ Cüwa. ");
INSERT INTO jum_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yakcaan ken a wäy yen Cïïba ke Diidaan. Aŋ kaaynä yek Diidaan a mä Acüür ke mä Litüüc ke mä Liim. ");
INSERT INTO jum_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Aŋ merkä oogen yek Mïdïyaan a Ipa ke Eper ke Anook ke Abida aŋ Elda. Iken yaakca muureen a kaaynä yek Katuura. ");
INSERT INTO jum_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrayiim waak yeeke muure yädi minneni yeene Icaak. ");
INSERT INTO jum_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","I ike batta mor tüw, merkä yeeke yaaka giide kiinkä yeeke määngen ti ye, pääggene iñdinni. Aŋ piirre gïtï ke Icaak, aŋ iken tucce woo baan ti kä ñomuk. ");
INSERT INTO jum_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aŋ Abrayiim yuunge muure yaaka cääynee kä ŋommañ wic ye a 175. ");
INSERT INTO jum_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Aŋ ike wääkcin woo wääktäŋ tüwnü aŋ tüwnü, i yuunge a ḍïïrïnï a yääŋon kä cäwdä ŋommañ wic, aŋ ike cooṭi me ti dänkä yurge ti. ");
INSERT INTO jum_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Aŋ merkä yeeke Icaak ke Icämayiil ike jïgï ṭuum yaana Makapeela jï ye, cokulaŋ ti Mamar, yiil yen Aproon minneni Cuwaar yen mä Haat. ");
INSERT INTO jum_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Aŋ yiil yaana kiyi Abrayiim mä Haat ti ina, ken jïgene daa kä me iken ke iiŋe Caarra. ");
INSERT INTO jum_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Aŋ wääna Abrayiim tüwnee kä ye, minneni yeene Icaak ŋüülkï Jooŋ. Aŋ Icaak cääynä kä cokal Bïïr Lahaayi Rooy, aŋ aŋan ogo, Jïïn M'ana a Üdon Ika Yoodda ye ti. ");
INSERT INTO jum_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","A perrä kaaynä yek Icämayiil minneni Abrayiim, yaana giide Haajir kiingon yen Caarra yaana a yen mä Macïr ina ti. ");
INSERT INTO jum_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","A merkä oogen yek Icämayiil yäṇtäŋgenen ikki, aŋ a pergin a ïïjgïnï kä kaygon ti ke m'ana düüñïdï ye ti. Nabïyüüt ken a kaygon aŋ bäätcete Kedar ke Adbeel ke Mibcaam ");
INSERT INTO jum_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ke Micma ke Düüma ke Maaca ");
INSERT INTO jum_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ke Haddaat ke Tiima ke Yatuur ke Naapïc aŋ Kedeema. ");
INSERT INTO jum_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","A merkä oogen yek Icämayiil ikki, aŋ a yäṇtäŋŋi yek yätïnï yaaka äärgä tüggen kä caay witken kä yewwe ye, ke nänk'a cääyene kä ye, ke keeññi yeeken. ");
INSERT INTO jum_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Aŋ Icämayiil cääynä ŋommañ wic yuunge 137. Aŋ ike wääkcin woo wääktäŋ tüwnü aŋ tüwnü, aŋ ike cooṭi me ti dänkä yurge ti. ");
INSERT INTO jum_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Aŋ kaaynä yeeke cääjjin Hawela attä ke Cüür kä cokal Macïr ñome ti, bata gin'a ïkï üŋjüdü Acüür ye. Aŋ iken cäygin muure kä puudin gïtï ke mä yeeken. ");
INSERT INTO jum_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Wakkä yaakki a yaaka näŋŋä ḍuuggen Icaak ti minneni Abrayiim ti ye. Aŋ Abrayiim gittä Icaak. ");
INSERT INTO jum_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aŋ Icaak yuunge caykä kä ŋan wääna kuññee kä Rïpga ṭul Batüwïïl yaana a män Araam ina, aŋ ike baanne battä me ogo Padaan Araam aŋ ike a Laabaan mä Araam käwen. ");
INSERT INTO jum_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aŋ Icaak mälcin ñaalok Pïṭo ti kä yaana iiŋe agee kä burŋu ye. Aŋ mallä yen Icaak luugi Pïṭo aŋ iiŋe Rïpga laaccä yuunku. ");
INSERT INTO jum_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Aŋ merkälen yaaka kä yewwe jïñe ti ye yoken yuuku, aŋ attä tääccïdï Pïṭo ti kä yuuŋŋu merkä yoken. Aŋ tääccin ogo, “Nääŋkä yaakki näŋit ḍuuggen ika ti ina?” ");
INSERT INTO jum_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Aŋ kiini Pïṭo ogo, “Merkä yaaka jïñü ti yaakka bi wäätï a ṭoŋ kä yew. Aŋ me yüükü yaaka kä yew jïñü ti yaakka bi piirtit, aŋ ṭoŋ yaŋkalaŋ bi meken borgu kä teynä, aŋ kaygon yüünü määdenle bi ñuugele.” ");
INSERT INTO jum_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Aŋ wääna nïïnnä yen giidä yeene ḍäägenee kä ye, yore kaññe cäyge yuunku oogen jïñe ti. ");
INSERT INTO jum_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Aŋ yaana ïïjgene giidene woo ye, tïdaŋ aŋ yore a jiik bata gaan, aŋ äkki me ogo Ïïcü. ");
INSERT INTO jum_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Aŋ yuungon yaŋkalaŋ giidi me i määden Ïïcü agee kä mükon kä ŋubdonḍe. Aŋ äkki me ogo Yaagüüp. Aŋ wääna yuunku giidene daa kä me ye i Icaak yuunge caykä kä ḍüügük. ");
INSERT INTO jum_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Aŋ wääna merkä pïïrene ñaalok ye, Ïïcü wäättä aŋŋi män keñ laay woo luummuk, i määden Yaagüüp a män ŋïïbbïn cääy paa keeññi gïtï. ");
INSERT INTO jum_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aŋ Icaak a Ïïcü ken bilge nääŋka ämee kä yäŋgä waak luum jïñe yaaka äbätä Ïïcü ye, aŋ Rïpga a Yaagüüp ken daa bilge. ");
INSERT INTO jum_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Aŋ ääŋkalaŋ ti wina Yaagüüp cääpï yüückü, aŋ käägi ti Ïïcü ätä woo luummuk a bägon kuckon aŋ näkä käñ. ");
INSERT INTO jum_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Aŋ Ïïcü Yaagüüp kiinne ogo, “Ika tüwü kä käñ! Kura iñja yüückü tïtkä kä ḍeewaŋ!” A yaana Ïïcü äkkene daa me yäṇtäŋ yaŋkalaŋ ogo, Ïdoom ye, nüütï ogo “tïdda.” ");
INSERT INTO jum_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Aŋ luugi Yaagüüp ogo, “Ee, por kaykïtïn yüünü yääjgaa kä.” ");
INSERT INTO jum_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Aŋ Ïïcü jaajjin ogo, “Yuuru, ika tüwü kä käñ. Aŋ ŋerrä kaykïtïn yeeni a ŋaaka ika ti?” ");
INSERT INTO jum_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Aŋ kiini Yaagüüp ogo, “Por ïïjjä lïïtkaa.” Aŋ Ïïcü lïïttä, ogo kaykïtïn yeene yääjgedee Yaagüüp. ");
INSERT INTO jum_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Aŋ Yaagüüp Ïïcü iññe bïggï ke yüückü piiken. Aŋ ike ämmä aŋ mättä, aŋ wäättana juwin attä. Aŋ aŋan Ïïcü ñääynä kä kaykïtïn yeene. ");
INSERT INTO jum_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Aŋ käñ yaŋkalaŋ ŋuca äätin baan jï bata yaana näŋŋä ḍoŋe nïïnkä Abrayiim ti ina. Aŋ Icaak attä yätkä Abimaliik yen mä Palactïïn yaana cääy Jaraar ina ti. ");
INSERT INTO jum_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Aŋ Pïṭo üükïn woo Icaak ti aŋ kiinne ogo, “Ŋana ïkï atä ïñï Macïr. Cääyä baan yaana bi kiinenii kä ogo cääyjey ko ye. ");
INSERT INTO jum_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Cääyä baan yaanni ti ïkï agä boorgon, aŋ ika bi ke ïkï aŋ ïkï bi ŋüülkeni. Aŋ bänkä yaakki bi iñenii kä muure ïkï ke kaaynä yüükü, aŋ ika lïïttäŋŋi bi ḍaagä yaana lïïtkänä wääc Abrayiim ye. ");
INSERT INTO jum_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Aŋ kaaynä yüükü bi naŋä ḍirä kä yaac bata kiṭṭäni yek polloŋ jïñe, aŋ bänkä yaakki muure bi iñä daa kä. Aŋ kä päy kaaynä yüükü ṭoŋ muure bi a ŋüülkïnï ŋommañ wic. ");
INSERT INTO jum_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kä yaana Abrayiim tiiŋgana kä jiik yaaka ṭäkkä ike ti ye aŋ tïïcee kä iininni yeeki, ke nüüṇṇüni yeeki ye.” ");
INSERT INTO jum_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Aŋ Icaak cääjjin baan battä me ogo Jaraar. ");
INSERT INTO jum_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Aŋ wääna taajene daa kä ook yek baan yaanja kä iiŋe ye, i ike jaajjin ogo, “A käwo.” I booc kä jaajjin ogo, “A iiŋ yeeni.” Ike ḍüücï ogo, “ike bi nägjï ḍok mä baan yaanna, ogo iiŋe Rïpga, kä yaana ŋeree kä ŋer kä yaac ye.” ");
INSERT INTO jum_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aŋ wääna Icaak cääynee kä wïca nïïnkä kä ḍiräk ye, Abimaliik yätkä yen mä Palactïïn däämjin ïñï kä käälle yen än gunne aŋ Icaak yooṭṭe iiŋe Rïpga ñääjgede. ");
INSERT INTO jum_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Aŋ Abimaliik Icaak bärkene aŋ kiinne ogo, “Ay, Rïpga ina a ïïŋü yaanna! Ïkï jaayä ogo käwic ina?” Aŋ luugi Icaak ogo, “Ika booju, ika ḍuucu ogo mäŋkalaŋ ika bi nägjada ḍok aŋ koowje.” ");
INSERT INTO jum_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Aŋ Abimaliik jaajjin ogo, “A ŋaaka ina näŋgonoon kä aŋan yaanna? Aŋ naana yoku por mäŋkalaŋ ïïŋü nïïnne ye, ikoon yoku ickonoon ḍuuggin nääŋkä yaackä.” ");
INSERT INTO jum_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Aŋ Abimaliik me muure kolle ogo, “M'ana bi täpï yok men yaanni ke iiŋe ye tüwnü bi yoore ti.” ");
INSERT INTO jum_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aŋ baan yaanja ti Icaak pïïttä käwkä, aŋ yun yaanna ti ike iṭṭä cuukulli päk 100 ḍiräk kä käwkä yaaka pïïṇṇe ye, nääŋka ike ŋüülkene daa kä Pïṭo ye. ");
INSERT INTO jum_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Aŋ ike wäättä aŋŋa ceeggon mooye kä yaac, aŋ waak yeeke üüttïn kä ḍiirin. ");
INSERT INTO jum_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aŋ ike cäygene ḍiik ke däk ke kiinkä kä ḍiräk aŋ mämgi jï mä Palactïïn. ");
INSERT INTO jum_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Aŋ jïïdgä piik muure yaaka küüñï kiinkä wäyen nïïnkä yek wäyen Abrayiim ti ye, cïkï mä Palactïïn kä ŋomgu. ");
INSERT INTO jum_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Aŋ Icaak kiini Abimaliik ogo, “Aŋgä yorü ikoon ti. Ikoon borroon kä teynä.” ");
INSERT INTO jum_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Aŋ Icaak aŋgin yore wïca, aŋ attä keeññi yeeke ṭeljene ïñï Ḍääñgon Jaraar jï, aŋ cääjjin ïñï wïca. ");
INSERT INTO jum_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aŋ Icaak jïïdgä ḍuukke gomme yaaka küüñï me nïïnkä yek wäyen Abrayiim ti ye. Kä yaana cïkene daa mä Palactïïn wääna wäyen tüwnee kä ye. Aŋ äkkene kä yäṇtäŋgenen yaaka äkkene daa kä wäyen ñomuk ye. ");
INSERT INTO jum_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aŋ kiinkä Icaak küññü jïïn Ḍääñgon Jaraar jï, aŋ jïïn waŋe yaana yiiŋä kä piik ŋerkä ye kañi wïca. ");
INSERT INTO jum_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Aŋ kaaydoni yek mä Jaraar äätin aŋ büültïn ke kaaydoni yek Icaak, aŋ jayok ogo, “Piik a yooko!” Aŋ Icaak jïïn äkkene ogo Icik nääŋka iken büültene kä ke ike ye. ");
INSERT INTO jum_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Aŋ kaaydoni Icaak ŋuccin küññü jïïn yaŋkalaŋ, aŋ iken ŋuccin büültïn wïca jïïn yaanja ti. Aŋ äkki Icaak ogo Cittina nüütï ogo ätkïtïn. ");
INSERT INTO jum_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ike nänṭä yaanja bäkkene wic aŋ ŋuccin küññü jïïn yaŋkalaŋ wïca, aŋ baati m'ana ŋuca agene kä büültïnï kä ye. Aŋ äkki Icaak ogo Rabuut, aŋ jaajjin ogo, “Pïṭo ikoon iññon nänṭä, aŋ ikoon bi ḍiiron ŋommañ wic.” ");
INSERT INTO jum_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Aŋ Icaak wina daljene ïñï aŋ baŋŋä Bïïrcïba. ");
INSERT INTO jum_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Aŋ wïïrïn jïñe yaanja ti Pïṭo üükïn woo ike ti, aŋ ike kiini ogo, “Ika agä Jooŋ yen wääc Abrayiim. Ŋana ïkï booju, ika ke ïkï, ïkï bi ŋüülkeni aŋ kaaynä yüükü bi naŋä ḍiirä kä waan yen kiingon yeeni Abrayiim.” ");
INSERT INTO jum_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aŋ Icaak bättä tambal wïca, aŋ Pïṭo maaŋŋe. Aŋ keeñ yeene ṭeljene ïñï wïca, aŋ kiinkä yeeke küñjïn ïñï jïïn wïca. ");
INSERT INTO jum_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Aŋ ääŋkalaŋ ti wina yätkä Abimaliik äätin ike ti ke Ahüjaat yaana ike nüütü kä nääŋkä yaaka bilti ye, ke Paykool ḍuuŋgon kääygä yeene ätä Jaraar. ");
INSERT INTO jum_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aŋ tääckiti Icaak ogo, “Ikee äätede ika ti ina? I ina ika putka jï, aŋ ika ñooṭṭa woo yaanna.” ");
INSERT INTO jum_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Aŋ iken luukcin ogo, “Yoorron kä ŋer Pïṭo ke ïkï. Aŋ ikoon jaajjonon ogo yoku lïïttäŋ bilto ti waadgo ti, ke ïkï. Ïkïïn ḍüccïn jiik ḍoocin. ");
INSERT INTO jum_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Lïïtä ogo ikoon batta bi näŋgonda nääŋkä yaackä, bata yaana batta agini näŋgïnï kä nääŋkä yaackä ina, a nääŋkä ŋerkä ken näŋkiti kä kamat. Aŋ ïkï tucini woo kä ŋïïbbïn. Aŋ yooru yaana ŋüülkïnï kä Pïṭo ye.” ");
INSERT INTO jum_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Aŋ iken tutki Icaak ammani jon ñamme, aŋ ämmä aŋ mättä. ");
INSERT INTO jum_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Aŋ kä tïṇṇäŋänä iken murjin ïñï mäŋkalaŋ daa menen lïïtkede, aŋ iici Icaak aŋ iken attä kä ŋïïbbïn. ");
INSERT INTO jum_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Aŋ äŋ jïñe yaanja ti kiinkä yek Icaak äätin ike nüütkï kä jïïn yaana küüñï a kïcconḍe ye, aŋ kiini ogo, “Ikoon käññon piik!” ");
INSERT INTO jum_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Aŋ Icaak jïïn äkkene ogo Cïba. Aŋ ke tiññaŋ baan yaanja wäättana battä me ogo Bïïrcïba, aŋ aŋan ogo, “Jïïn Lïïttäŋ.” ");
INSERT INTO jum_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Aŋ Ïïcü wääna yuunge aŋŋene caykä kä ŋan ye, ḍiññä määngä kä yew tïïrïn mä Haat ti, määnge a Yahudïït ṭul Beerï, aŋ Bacamaat ṭul Eylüün. ");
INSERT INTO jum_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Aŋ a iken ken ääcin jon yiñe Icaak ke Rïpga ti. ");
INSERT INTO jum_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Icaak daandin aŋ waŋge bunnu batta ŋuca yüṭï, aŋ minneni yeene mooye Ïïcü bärkene ti, aŋ kiinne ogo, “Minneni yeeni!” Aŋ ike luugi ogo, “Ika inni.” ");
INSERT INTO jum_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aŋ Icaak jaajjin ogo, “Ika ḍuuŋdunu, aŋ nïïnnä yeeni yen tüwnü kuju. ");
INSERT INTO jum_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kaay yüünü koowu ke cäwgälen, aŋ atä woo kiñuk aŋ näkkaa gin luum jïñe. ");
INSERT INTO jum_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Aŋ tutkaa ginäämkä yaana ñabaŋ bilgä ye, aŋ ickaa kä dalä amä nuŋko ŋüülkenii i batta mor ika tüwü.” ");
INSERT INTO jum_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Aŋ wääna Icaak jaaynee ke minneni yeene Ïïcü ye, i tiŋtä Rïpga. Aŋ wääna Ïïcü attee kä woo luummuk kiñee kä waak luum jïñe aŋ äbedeeda ti ye, ");
INSERT INTO jum_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","i Rïpga minneni yeene Yaagüüp kiinne ogo, “Wääc tiiŋŋä määdic Ïïcü kiiṇde ogo, ");
INSERT INTO jum_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ickaa gin luum jïñe, aŋ näŋgaa kä ginäämkä yaana ñabaŋ ye amä nuŋko ŋüülkenii Pïṭo ñome ti, i ika batta mor tüwü.’ ");
INSERT INTO jum_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Minneni yeeni jiik yeeki tiiŋä bata yaana kiindenii kä ye. ");
INSERT INTO jum_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Atä kaacci ḍiik gïtï aŋ ickaa woo jüülonilen kä yew yaaka a caagin ye, dalä näŋgä wääc, a ginäämkä yaana ñabaŋ bilge ye. ");
INSERT INTO jum_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Aŋ ickä wääc dalä ame nuŋko bi ŋüülkey kä, i ike batta mor tüw.” ");
INSERT INTO jum_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Aŋ Yaagüüp meen Rïpga luuŋŋe ogo, “Määdo Ïïcü yore jüülaŋ, aŋ ika yori yïlaŋ. ");
INSERT INTO jum_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Aŋ naana por ika tapa yok wäyo ye? Ika bi yoora ogo ike maldooŋïngïn. Aŋ ike ika batta bi ŋüülka, bi ṭääkcï ika tuuma.” ");
INSERT INTO jum_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Aŋ kiini meen ogo, “Dalä tuummu ḍïmjï ika ti, minneni yeeni! Näŋjä bata yaana kiinnenii ye. Atä aŋ jüülonilen ickaa kä.” ");
INSERT INTO jum_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Aŋ ike attä aŋ jüülonilen koowne aŋ ickene meen. Aŋ meen tuttu ginäämkä yaana ñabaŋ ye, bata yaana bilgänä wäyen ye. ");
INSERT INTO jum_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Aŋ Rïpga kuññu buruŋgu ŋerkä yek minneni yeene mooye Ïïcü, yaaka äräk baanne ye, aŋ iiŋkene minneni yeene ḍeerconḍe Yaagüüp. ");
INSERT INTO jum_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Aŋ kümme ïnke ti ke bugge ti, ke nänṭä ḍoŋe yaana yïdälaŋ ye kä gäykä jüülonilen. ");
INSERT INTO jum_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Aŋ ike ginäämkä yaana ñabaŋ ke bïggï yaaka tooṇṇe ye iññe Yaagüüp ïṇte ti. ");
INSERT INTO jum_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Aŋ Yaagüüp attä äräk wäyen ti, aŋ jaajjin ogo, “Wäyo.” Aŋ wäyen luukcin ogo, “Haa, minneni yeeni. Ïkï agä Ïïcü halla ïkï agä Yaagüüp?” ");
INSERT INTO jum_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Aŋ Yaagüüp luukcin wäyen ti ogo, “Ika agä Ïïcü kaygon yüünü. Ika näŋŋä bata yaana kiinnaa kä ye. Juwu ñaalok aŋ yäŋŋä gin luum jïñe yeeni amä, nuŋko ŋüülkaa kä ye.” ");
INSERT INTO jum_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aŋ taaji Icaak ogo, “Kaññi ogoo kä bïraŋ aŋŋi minneni yeeni?” Aŋ luuŋŋe ogo, “Pïṭo yüünü Jooŋ ika yüükkana ti.” ");
INSERT INTO jum_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Aŋ Icaak Yaagüüp kiinne ogo, “Wüükü ti kä cokal dalä ïkï tabeni yok, aŋ ooku gïtï naana a ïkï Ïïcü minneni yeeni ye.” ");
INSERT INTO jum_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Aŋ Yaagüüp wükcïn ti wäyen ti, aŋ tabi yok Icaak. Aŋ ike jaajjin ogo, “Poŋ a poŋ Yaagüüp, aŋ ïnkä ke buggu a yek Ïïcü.” ");
INSERT INTO jum_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aŋ batta agee kä ookon gïtï nääŋka ïnke ke bugge jüüle kä jüül bata määden Ïïcü ye. Aŋ Icaak yore tootte ṭäkï Yaagüüp ŋüülkede. ");
INSERT INTO jum_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Aŋ taaññe ogo, “A gïtken ïkï agä minneni yeeni Ïïcü?” Aŋ luuŋŋe ogo, “Ee a ika.” ");
INSERT INTO jum_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aŋ Icaak jaajjin ogo, “Yäŋŋä gin luum jïñe yüünü äckaa kä dalä amä, minneni yeeni. Nuŋko ïkï bi iñenii kä ŋüülkïn yeeni ye.” Aŋ äckene daa Yaagüüp aŋ amme. Aŋ äckene määk aŋ maaṇṇe. ");
INSERT INTO jum_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Aŋ kiini wäyen Icaak ogo, “Äätä ti kä cokal minneni yeeni, aŋ muckaa gimgin.” ");
INSERT INTO jum_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Aŋ ike wüükïn ti kä cokal aŋ muckene. Aŋ Icaak ŋääccä pin burŋu yeene, aŋ ike ŋüülkï, aŋ jaajjin ogo, “Pin minneni yeeni beel bata pin yiil yaana a ŋüülkïnï kä Pïṭo ye. ");
INSERT INTO jum_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Dalä Jooŋ ïkï iñey tuñ yen polloŋ ke cekkïtïn ŋommañ wiñe ke päk ḍiirken ke määk ḍiirken. ");
INSERT INTO jum_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Dalä ṭoŋ ïkï ñuugilini, aŋ iken ïkï ḍüŋkïtï ïñï, aŋ wäätci agä mügdo yen mädgic aŋ kaaynä miic dalä cäänna ïkï ḍüŋkïtï ïñï. Aŋ tuummu wäätï m'aka ïkï tuumgi ye ti, aŋ ŋüülkïn wäätï m'aka ïkï ŋüülkïtï ye ti.” ");
INSERT INTO jum_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aŋ kä ḍeeraŋ aŋŋi wääna Icaak ḍaŋŋee kä ŋüülkïn Yaagüüp, aŋ Yaagüüp kaaccee kä woo wäyen ti ye, i määden Ïïcü kääjin äräk ätä kiñuk. ");
INSERT INTO jum_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Aŋ ike cäänna näŋŋä ginäämkä yaana ñabaŋ ye, aŋ äckene wäyen, aŋ jaajjin ogo, “Juwu ñaalok wäyo ämä yäŋŋä gin luum jïñe yeeni, nuŋko iñja kä ŋüülkïn yüünü.” ");
INSERT INTO jum_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aŋ taaji wäyen Icaak ogo, “Ïkï agä ŋaani?” Aŋ luuŋŋe ogo, “Ika agä minneni yüünü Ïïcü kaygon yüünü.” ");
INSERT INTO jum_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aŋ Icaak yore tïïcïn kä yaac, aŋ jaajjin ogo, “A ŋaani ken ina attä kiññä waak luum jïñe, aŋ ickana kä ammä muure i batta mor ïkï ḍäägä aŋ ŋüülkünü yaanna! Ee, aŋ ike bi a ŋüülkïnï a gïtken.” ");
INSERT INTO jum_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Aŋ wääna Ïïcü tiiŋŋee jiik yaakka wäyen ti ye, i ike weekcin kä yaac kä jon pille, aŋ wäyen kiinne ogo, “Ŋüülkaa cäänna ay wäyo!” ");
INSERT INTO jum_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Aŋ kiini Icaak ogo, “Määdic äätin, aŋ ika mallaŋïngïn, aŋ ŋüülkïn yüünü koowne.” ");
INSERT INTO jum_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Aŋ Ïïcü jaajjin ogo, “Ike battä me ogo Yaagüüp a gïtken. Ike aŋŋi ika mallaŋïngïn ääŋke kä yew, kaykïtïn yeeni koowne, aŋ tiññaŋ ŋüülkïn yeeni koowe cäänna.” Aŋ taaññe ogo, “Ïkï batta agä büüccïnï ŋüülkïn yaana a yeeni ye?” ");
INSERT INTO jum_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aŋ Icaak Ïïcü luuŋŋe ogo, “Ike ḍaŋŋa naŋŋä a mügdo yüünü, aŋ mädgen muure naŋŋä a kiinkä yeeke, aŋ iññä päk ke määk. Aŋ ïkï bi naŋeni ogoo tiññani minneni yeeni?” ");
INSERT INTO jum_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Aŋ Ïïcü wäyen taaññe ogo, “Wäyo, ïkï cääygi ŋüülkïn a keelok? Wäyo ŋüülkaa cäänna!” Aŋ Ïïcü weekcin kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Aŋ wäyen Icaak ike luugi ogo, “Ïkï bi cääyä woo kaakic cekkïtïn yen ŋommañ wiñe ti, aŋ woo kaakic tuñ yen polloŋ jï ti. ");
INSERT INTO jum_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Aŋ ïkï bi cääyä kä gaaḍal yüünü, aŋ ïkï bi ñuugulu määdic ti, aŋ naana ïkï ṭäkä ḍüŋü teetcädä woo ye, i wiṇṇan yeene bi erci woo ḍoŋü ti.” ");
INSERT INTO jum_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Aŋ waan yaanja ti, ÏïcüYaagüüp putkene jï kä yaana wäyen Yaagüüp iññeeda kä ŋüülkïn ye. Aŋ Ïïcü jaay joni ti ogo, “Waan nüüjdüŋ tüwnü wäyo cokilin, aŋ wäättan määdo Yaagüüp bi nägä ḍok.” ");
INSERT INTO jum_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Aŋ wääna Rïpga nüütkene daa me kä jiik minneni yeene mooye Ïïcü ye, i ike tuccin Yaagüüp ti, aŋ kiinne ogo, “Määdic Ïïcü ḍiigä jiik ogo, ïkï nägjïda ḍok. ");
INSERT INTO jum_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Jiik yeeki tiiŋä ṭeṭaŋ minneni yeeni. Juwu aŋ lüüdü määdo Laabaan ti Araan. ");
INSERT INTO jum_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Aŋ cääye ke ike kä ḍeeraŋ ke määdic jone lüye. ");
INSERT INTO jum_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Aŋ naana ike jone lüynü, aŋ gin'a näŋgeneeda kä wiiṭṭe woo ye, i ïkï bi tuckeni ïkï ḍuuku. Ina kura ikee yääye muuric kä nïïnnä keellä?” ");
INSERT INTO jum_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Aŋ Rïpga jaajjin Icaak ti ogo, “Üṇṇü yeeni putku jï kä määngä mä Haat. Naana Yaagüüp küjï iiŋ ṭulgu yek baan yaanni ti määngä mä Haat ti ye, bata määngä yek Ïïcü ye, päjjïdï iiñca yoku ika tüwü.” ");
INSERT INTO jum_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aŋ IcaakYaagüüp bärkene ti, aŋ ŋüülkene aŋ kolle ogo, “Ïkï ŋana ḍijä ṭulgu yek mä Kanaan yaakki ti. ");
INSERT INTO jum_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Juwu atä Padaan Araam paa ba daan wääc Batüwïïl, aŋ ḍijä iiŋ wïca ṭulgu nääyic Laabaan. ");
INSERT INTO jum_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Jooŋ yaana Lïïṭït ye ïkï ŋüülkey, aŋ ïkï iñey merkälen kä ḍiräk, aŋ kaaynä yüükü ḍirä aŋ wäätï a ṭoŋ ḍiirken! ");
INSERT INTO jum_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Aŋ ïkï iñey ŋüülkïn yaana iññe Abrayiim ina, ke kaaynä yüükü nuŋko bi mükïï ŋommañ yaana cääyii kä batta a yüünü yaanni ye, a ŋommañ yaana iñi Jooŋ Abrayiim ye!” ");
INSERT INTO jum_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aŋ Icaak Yaagüüp tucce woo, aŋ attä Padaan Araam cäyok ke nääyen Laabaan, a Rïpga määden minneni Batüwïïl a mä Araam, aŋ Rïpga a Yaagüüp ke Ïïcü meen. ");
INSERT INTO jum_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Aŋ Ïïcü ukcin gïtï ogo wäyen Icaak Yaagüüp ŋüülkenee aŋ tucce Padaan Araam ogo ḍijo iiŋ wïca, aŋ kollee ogo ŋana ḍijdo ṭulgu yek mä Kanaan ti. ");
INSERT INTO jum_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Aŋ Yaagüüp wäyen ke meen tiiŋgene, aŋ ḍakkä Padaan Araam. ");
INSERT INTO jum_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Aŋ wäättan ooki gïtï Ïïcü ogo wäyen Icaak batta ṭäko ṭulgu yek mä Kanaan nänṭä yeenen ti. ");
INSERT INTO jum_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Aŋ Ïïcü ŋïïpcïn wäyen taaŋŋe Icämayiil ti, aŋ ḍiññä ṭulgu yek Icämayiil ti kä keelok ŋocce ti määnge ti aŋ iiŋe kïcconḍe battä me ogo Maalat, aŋ ike a Nabïyüüt käwen aŋ a ṭul Icämayiil minneni Abrayiim. ");
INSERT INTO jum_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Aŋ Yaagüüp kääjin woo baan mooye Bïïrcïba jï, aŋ üŋjïn Araan. ");
INSERT INTO jum_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Aŋ kä lütcïn äŋ ike ḍakkä ti nänṭä ba ŋerrä aŋ yuuttu ïñï wïca nïïnjïdï ïñï, aŋ kuññu pääm nääkcenee kä wiñe aŋ oodi. ");
INSERT INTO jum_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Aŋ wääna ike oodene daa ye, i ike umgi lääggï cääyge ṭiiṭṭä yudit ŋommañ wic aŋ wiñe ḍakcïdï polloŋ jï aŋ malaŋŋi yek Jooŋ aajjïdï aŋ ḍüükïdï ïñï kä ike. ");
INSERT INTO jum_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Aŋ Pïṭo yuuttu ṭiiṭṭä ti ñaalok, aŋ jaajjin ogo, “Ika agä Pïṭo, Jooŋ yen daan wääc Abrayiim aŋ Jooŋ yen wääc Icaak. Ŋommañ yaana nïïnïï kä yaanna a yüünü aŋ bi iñenii ïkï ke kaaynä yüükü. ");
INSERT INTO jum_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Aŋ kaaynä yüükü bi ḍirä batta lïïltä me kä paŋŋä bata ṭüüpon yek ŋommañ. Aŋ iken bi pïïrjï woo täŋkä ti muure ñomuk ke ŋäjäk ke ñaalok ke ïñï, aŋ äärgä tüggen yek ŋommañ wiñe muure bi käñï ŋüülkïn kä waan yüünü ikee ke kaaynä yüükü. ");
INSERT INTO jum_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Aŋ ika ke ïkï aŋ ika ïkï bi tïïjeni ke nänṭ'a atii kä ye, aŋ ääŋkalaŋ ïkï bi ḍuugeni ke ŋommañ yaanni ti. Aŋ ïkï batta bi cakeni ke wakkä yaaka kiinnenii ye ḍääkkenii kä muure.” ");
INSERT INTO jum_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Aŋ Yaagüüp juwin ñaalok nïïnkä ti, aŋ jaajjin ogo, “A gïtken Pïṭo a nänṭä yaanni ti! Aŋ batta agä ŋïcon!” ");
INSERT INTO jum_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Aŋ ike booññu aŋ jaajjin ogo, “Nänṭä yaanni me yämde! A än Jooŋ inni aŋ a äntüke polloŋ jïñe.” ");
INSERT INTO jum_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Aŋ tïṇṇäŋänä aŋŋi Yaagüüp pääm yaana nääkkee kä wiñe ye, koowne aŋ yuutte a kolcan paydin aŋ puukkene wic ñownä. ");
INSERT INTO jum_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Aŋ nänṭä yaanja äkkene ogo Betalï. Aŋ aŋan nüütï ogo, “Än yen Jooŋ.” Aŋ kä on battä me ogo Lüüc. ");
INSERT INTO jum_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Aŋ Yaagüüp lïïttä aŋ jaajjin ogo, “Naana Jooŋ ke ika aŋ ika tïïñña wään yaanni ti aŋ naana ika iñña waak äämkä ke buruŋgu ye, ");
INSERT INTO jum_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","aŋ naana ika ḍukcunu paa ba wäyo kä ŋïïbbïn ye, i wäättan Pïṭo bi wäätï a Jooŋ yeeni. ");
INSERT INTO jum_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Aŋ kolcan paydin yaana yuuttu ñaalok yaanni bi wäätï a Än Jooŋ. Aŋ wakkä muure yaaka bi iña kä ye, ike bi iñä kä caycayni.” ");
INSERT INTO jum_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Aŋ Yaagüüp wään yeene ceeññe ke ḍake ti ŋommañ mä ñommuŋŋu ti. ");
INSERT INTO jum_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Aŋ ike yurcin jïïn kä uttar ke kurku kä ḍäk yek ḍiik nïnok ïñï jïïn taaŋŋe ti kïïjï puukkin piik. Aŋ jïïn tüke a üüljïnï kä pääm mooye peŋŋä. ");
INSERT INTO jum_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Aŋ naana kurku ḍiik yoken ḍüülünü ti muure ye, i kaaydoni pääm ḍüljünü woo jïïn tük, aŋ ḍiik puukkunu piik, aŋ wäättan pääm ḍuukunu üüljünü jïïn tük. ");
INSERT INTO jum_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Aŋ kaaydoni taaji Yaagüüp ogo, “Ikee age mä wa mädgo?” Aŋ iken luukcin ogo, “Ikoon agon mä Araan.” ");
INSERT INTO jum_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Aŋ iken taaññe ogo, “Laabaan yaana daan wäyen a Nahüür ina ŋäjje?” Aŋ iken luukcin ogo, “Ee, ŋäjjon.” ");
INSERT INTO jum_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Aŋ iken taaji Yaagüüp ogo, “Ike yore ŋeraŋ?” Aŋ iken luukcin ogo, “Ee, ike yore ŋeraŋ. Daamjä a ṭuulle yeene Rahiil ina äätä kïdït kun ḍiik yaanja.” ");
INSERT INTO jum_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Aŋ ike luukcin ogo, “Wuuŋ mor a äŋ gïtï, batta mor a wuuŋ yen ḍüülïn ti kurku ḍiik nänṭä keellä. Ḍiik puukke piik, aŋ ḍuuke äämdük.” ");
INSERT INTO jum_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Aŋ iken luukcin ogo, “Ikoon batta lïïṭon, ke kurku ḍiik muure ḍäägene ti, aŋ wäättan pääm ḍüljon woo jïïn tük, aŋ ḍiik puukkon piik.” ");
INSERT INTO jum_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Aŋ Yaagüüp por daa ïïñjïdï jayok ke iken ke Rahiil ḍääge ti i kïdït kun ḍiik yek wäyen aŋ ike ken a kaaydo. ");
INSERT INTO jum_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Aŋ wääna Yaagüüp Rahiil yoorreeda kä ke kun ḍiik yek nääyen Laabaan ye, ike attä jïïn ti aŋ pääm ḍüljene woo, aŋ ḍiik nääyen puukkene piik. ");
INSERT INTO jum_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Aŋ wäättan Yaagüüp Rahiil muckene gimgin, aŋ weekcin kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Aŋ Yaagüüp Rahiil nüütkene ogo ike agje ŋiiḍḍen ko wäyen ti, minneni yen woowen Rïpga. Aŋ Rahiil buurcin woo kä bïraŋ attä wäyen Laabaan nüütkene. ");
INSERT INTO jum_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Aŋ kä bïraŋ aŋŋi wääna Laabaan tiiŋŋee kä ogo ñaakonḍe Yaagüüp ḍäägono ye, ike lüüṇṇü pärcete kä, aŋ kääŋŋe yok aŋ muckene gimgin, aŋ äbene ti paa. Aŋ Laabaan nüütkï Yaagüüp waak'a näŋŋä ḍuuggen muure ye. ");
INSERT INTO jum_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Aŋ Laabaan jaajjin ogo, “Ïkï agä gaani ke yïmgä yeeki a gïtken.” Aŋ Yaagüüp cääynä wïca ke näŋe paan. ");
INSERT INTO jum_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Aŋ LaabaanYaagüüp kiinne ogo, “Ïkï batta ñuugulu ika ti käpet ogo ïkï cokuleey ti cokal ika ti. Aŋ nüütkaa iñdin yüünü bi a ŋïṭṭä?” ");
INSERT INTO jum_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Aŋ Laabaan cääygene ṭulge kä yewwe. Mooye battä me ogo Leya aŋ ḍeerconḍe battä me ogo Rahiil. ");
INSERT INTO jum_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Aŋ Leya waŋge a bunin, aŋ Rahiil ŋeraŋ biilke ti ke üükïnene woo ti. ");
INSERT INTO jum_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Aŋ Yaagüüp Rahiil bilgene aŋ nääyen kiinne ogo, “Ïkï bi ñuugeleni yuungu kä ŋaṭükel naana ika iñdaa ṭüülü ḍeerconḍe Rahiil, wäätï a iiŋ yeeni ye.” ");
INSERT INTO jum_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Aŋ Laabaan jaajjin ogo, “Iiñca ŋeraŋ iñenii kä ïkï, kä yaana iñä daa kä oon yaŋkalaŋ yaana a pare ye. Cääyä ke ika winni.” ");
INSERT INTO jum_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Aŋ Yaagüüp ñuugilin yuungu kä ŋaṭükel ogo Rahiil, aŋ yuungu yaakka yoorre belok bata nïïnkä ḍeewken kä yaana billee kä Rahiil ye. ");
INSERT INTO jum_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Aŋ wäättan Yaagüüp Laabaan kiinne ogo, “Iiŋ yeeni iñjakä dalä koowu nïïnon kä. Nïïnkä yeeki yek ñuugula yeeni ḍaaŋŋä.” ");
INSERT INTO jum_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Aŋ Laabaan näŋŋä ñäänkä, aŋ mäbaan barre muure ammani jonñamme ti. ");
INSERT INTO jum_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Aŋ wääna nänṭä cücülenee kä ye, i ike ṭuulṭule yeene Leya ken koowne aŋ ickene Yaagüüp, aŋ nïngïn ke Yaagüüp. ");
INSERT INTO jum_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Aŋ Laabaan kiingon yeene iiŋe Jïlpa iññe Leya ogo wääto ogo kiingon yeene. ");
INSERT INTO jum_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Aŋ wääna Yaagüüp cuuyenee kä tïṇṇäk aŋŋi ye, i kaññe a Leya! Aŋ Yaagüüp Laabaan taaññe ogo, “A ŋaaka inni näŋganaa kä yaanni? Ïkï ñuugeleneni ogo Rahiil! Aŋ ika maldaa ŋïngïn ina?” ");
INSERT INTO jum_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Aŋ Laabaan luukcin ogo, “Koowdin ṭuul ḍeerconḍe mooye ñome ti batta a näŋon ḍoŋe poñku bänkä yooko ti. ");
INSERT INTO jum_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Nïïnkä ŋaṭükel yek yaanni por ḍaagä, aŋ ikoon menen bi ŋuckini kä cäänna naana ïkï ḍukcini ika ñuugalanaa yuungu kä ŋaṭükel ŋuca ye.” ");
INSERT INTO jum_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Aŋ Yaagüüp näŋjin aŋan. Aŋ nïïnkä ŋaṭükel yaakka ḍaagi Yaagüüp Leya ti, aŋ wäättan Laabaan ṭuule Rahiil iññe Yaagüüp ogo wääto ogo iiŋe. ");
INSERT INTO jum_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Aŋ Laabaan kiingon yeene iiŋe Bila iññe ṭuulle Rahiil ogo wääto ogo kiingon yeene. ");
INSERT INTO jum_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Aŋ Yaagüüp nïngïn ke Rahiil cäänna, aŋ ike Rahiil bilge kä yaac kä Leya. Aŋ nääyen ñuugelene yuungu kä ŋaṭükel ŋuca. ");
INSERT INTO jum_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Aŋ wääna Pïṭo yuṭṭee Leya batta bilgene daa kä oore ye, naŋŋe giit aŋ Rahiil ken a burŋu. ");
INSERT INTO jum_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Aŋ Leya laaccä aŋ giiṇṇä minneni a oon aŋ äkkene yäṇtäŋ ogo Robïïn, a yaana jaajjenee kä ogo, “Pïṭo yuṭṭu pillä yeeni, aŋ wäättan tiññaŋ ika bi bilgana oon yeeni.” ");
INSERT INTO jum_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Aŋ ike ŋuccin laaccä ŋuca, aŋ giiṇṇä minneni a oon. Aŋ jaajjin ogo, “Kä yaana Pïṭo tiiŋŋee kä ogo ika batta bilgada oori ye, ken inni iña kä minneni yaanni ŋuca.” Aŋ äkkene yäṇtäŋ ogo Camoon. ");
INSERT INTO jum_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Aŋ ike ŋuccin laaccä ŋuca, aŋ giiṇṇä minneni a oon. Aŋ jaajjin ogo, “Tiññaŋ waan yaanni ti oon yeeni bi yore määre ti ika ti, kä yaana gitkänä daa merkälen oogen kä ḍäk ye.” Aŋ ina ken äkkeeda kä yäṇtäŋ ogo Laawï yaanna. ");
INSERT INTO jum_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Aŋ ike laaccä ŋuca, aŋ giiṇṇä minneni a oon. Aŋ jaajjin ogo, “Waan yaanni ti, ika bi mäŋä Pïṭo.” Aŋ ina ken äkkeeda kä yäṇtäŋ ogo Yahüüja yaanna. Aŋ wäättan ike yuuttu ïñï kä giidä. ");
INSERT INTO jum_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Aŋ wääna Rahiil yuṭṭee kä ike Yaagüüp batta agee kä gïtkïnï kä merkä ye, i ike käwen mämgene jï. Aŋ ike Yaagüüp kiinne ogo, “Iñja merkä, naana ye ika bi tüwü.” ");
INSERT INTO jum_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Aŋ Yaagüüp pennä kä yaac kä Rahiil, aŋ taaññe ogo, “Ika agä Jooŋ, yaana ïkï ṭïïŋŋey kä merkä ye?” ");
INSERT INTO jum_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Aŋ kiini Rahiil ogo, “Kiingon yeeni Bila koowu aŋ nïïne kä, ike bi ika gitka merkälen, aŋ kä ike, ika bi cääygana kä merkälen cäänna.” ");
INSERT INTO jum_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Aŋ Rahiil kiingon yeene Bila ickene oore Yaagüüp bata iiŋe, aŋ nïïnnene kä. ");
INSERT INTO jum_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Aŋ Bila laaccä, aŋ Yaagüüp gitkene minneni a oon. ");
INSERT INTO jum_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Aŋ Rahiil jaajjin ogo, “Jooŋ ika jooñña kä ŋer, aŋ cäänna jiik yeeki tiiŋŋe, aŋ ika iñña minneni a oon.” Aŋ ina ken äkkeeda kä yäṇtäŋ ogo Ḍaan yaanna. ");
INSERT INTO jum_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Aŋ kiingon yen Rahiil Bila ŋuccin laaccä ŋuca, aŋ Yaagüüp gitkene minneni a oon ŋuca. ");
INSERT INTO jum_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Aŋ Rahiil jaajjin ogo, “Kä yääññä teyconḍe ikoon näägonon ke käwo aŋ yoññu.” Aŋ äkkene yäṇtäŋ ogo Naptaalï. ");
INSERT INTO jum_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Aŋ wääna Leya yuṭṭee kä ike yuuttee kä ïñï kä giidä ye, ike kiingon yeene Jïlpa koowne, aŋ ickene Yaagüüp bata iiŋe. ");
INSERT INTO jum_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Aŋ Jïlpa kiingon yen Leya Yaagüüp gitkene minneni a oon. ");
INSERT INTO jum_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Aŋ Leya jaajjin ogo, “A ñaaynä ŋerconḍe ken äätin.” Aŋ äkkene yäṇtäŋ ogo Gaat. ");
INSERT INTO jum_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Aŋ Jïlpa kiingon yen Leya Yaagüüp gitkene minneni a oon ŋuca. ");
INSERT INTO jum_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Aŋ Leya jaajjin ogo, “Ika joni ñabaŋ, aŋ määngä ika bi bäärga ogo jon ñammä.” Aŋ äkkene yäṇtäŋ ogo Acïïr. ");
INSERT INTO jum_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Aŋ nïïnkä errä päk ti Robïïn attä yiil jï, aŋ käññä jaan läñ beel bata tääkäräŋ yiil jï, aŋ ickene meen. Aŋ Rahiil Leya kiinne ogo, “Kura iñja jaan yen minneni yüünü.” ");
INSERT INTO jum_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Aŋ Leya jaajjin ogo, “Ḍaŋŋa ïkï oon yeeni koowni, aŋ cäänna ṭäkkä jaan minneni yeeni koowdu?” Aŋ Rahiil jaajjin ogo, “Ike bi nïïn wïïrïn tiññaŋ ïkï ti rätä jaan minneni yüünü.” ");
INSERT INTO jum_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Aŋ wääna Yaagüüp ḍuuke kä yiil jï biigin ti aŋŋi ye, Leya attä pääkcin ike ti aŋ jaajjin ogo, “Ïkï nïïnä ika ti tiññaŋ ïkï rättenii kä jaan yen minneni yeeni.” Aŋ nïïnnene kä wïïrïn yaanja ti. ");
INSERT INTO jum_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Aŋ Jooŋ Leya tiiŋgene aŋ laaccä, aŋ Yaagüüp gitkene minneni a oon wäätcete kä duuce. ");
INSERT INTO jum_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Aŋ Leya jaajjin ogo, “Jooŋ ika iñña a yaana kiingon yeeni iññädaa kä oon yeeni ye.” Aŋ äkkene yäṇtäŋ ogo Yacakïïr. ");
INSERT INTO jum_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Aŋ Leya ŋuccin laaccä ŋuca, aŋ Yaagüüp gitkene minneni a oon yaana wäätcete kä ḍüügük ye. ");
INSERT INTO jum_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Aŋ Leya jaajjin ogo, “Jooŋ ika iñña iññä ŋerconḍe. Aŋ tiññaŋ oon yeeni ika bi eemda kä yaana gitkänä daa minneni yaana wäätcete kä ḍüügük ye.” Aŋ äkkene yäṇtäŋ ogo Jabuloon. ");
INSERT INTO jum_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Aŋ wäättana ike giiṇṇä minneni a iiŋ aŋ äkkene yäṇtäŋ ogo Ḍïïna. ");
INSERT INTO jum_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Aŋ Jooŋ Rahiil payne, aŋ tiiŋgene aŋ naŋŋe giit. ");
INSERT INTO jum_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Aŋ laaccä aŋ giiṇṇä minneni a oon. Aŋ jaajjin ogo, “Jooŋ loon yeeni aŋgene yok.” ");
INSERT INTO jum_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Aŋ äkkene yäṇtäŋ ogo Yuucip. Aŋ jaajjin ogo, “Pïṭo yoku ika ŋucka ti minneni a oon ŋuca.” ");
INSERT INTO jum_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Aŋ wääna Rahiil gitee kä Yuucip ye. YaagüüpLaabaan kiinne ogo, “Kura äkkaa dalä ika atä paa baan yeeni ti. ");
INSERT INTO jum_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dalä määngä yeeki koowu ke merkä yeeki yaaka ñuugelenenii kä ye, aŋ ika atä, kä yaana ŋäjjii kä ñuugulani yaaka näŋgenenii kä ye.” ");
INSERT INTO jum_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Aŋ kiini Laabaan ogo, “Naana ïkï gïmmädä ye kura cääyä winni kä yaana ŋäjjänä daa kä ṭïrkïtïn ti ogo, Pïṭo ika ŋüülkanada ko nääŋkä yüükü yaaka naŋŋeey ika ti ye. ");
INSERT INTO jum_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Nüütkaa ñuugula carrä yüünü, aŋ bi iñenii.” ");
INSERT INTO jum_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Aŋ luugi Yaagüüp ogo, “Ŋäjjä ñuugulin yaana ñuugelenenii kä ye, aŋ ḍiik yüükü tïïññä ogoo. ");
INSERT INTO jum_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ïkï cääygi kä ḍeewaŋ, aŋ wääna äätänä kä ye i ḍiirin kä yaac. Pïṭo ïkï ŋüülkeney kä ika kä waak'a naŋŋä ye muure. Aŋ tiññaŋ a tooku ken bi mä äntüke yeeki äärä daa kä ñaalok?” ");
INSERT INTO jum_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Aŋ Laabaan tääccin ogo, “A ŋaaka ken iñenii kä?” Aŋ Yaagüüp luukcin ogo, “Ïkï ŋana ika iñdaa ginkalaŋ, gin kä keelok ken näŋgaa kä, aŋ ika bi ceeñä kääjä ke tïïcä ḍiik yüükü. ");
INSERT INTO jum_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Dalä ika kaacä kurku ḍiik yüükü gïtï tiññaŋ, aŋ ika wääkä woo iken ti käbälgä ke ḍiik yaaka müücülaŋ ke yaaka pergaŋ muure ye, ke käbälgä yaaka ülaŋ ye muure. Aŋ iken bi wäätï a ñuugula carrä yeeni. ");
INSERT INTO jum_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Eemdin yeeni ken bi nütü woo kä ika ñomuk, naana ïkï äätä ukcudu ñuugula carrä yeeni yaana iñdaa kä ye. Ḍiik muure yaaka batta müücülaŋ ke yaaka batta pergaŋ ke käbälgä yaaka batta ülaŋ ḍiik gïtï ke käbälgä gïtï ye, naana kañgä me ye bi pakä me ogo yek kalgin.” ");
INSERT INTO jum_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Aŋ Laabaan jaajjin ogo, “Ŋeraŋ! Dalä wäätï bata yaana jaajjinii ye.” ");
INSERT INTO jum_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Aŋ nïïnnä yaanja ti Laabaan ḍiik oogen muure äbene woo yaaka cääygene äälgä ke yaaka pergaŋ ye, aŋ ke ḍiik määngen muure yaaka müücülaŋ ke yaaka pergaŋ ye, ke ḍiik määngen muure yaaka cääygene kä bowken yoken ti ye, ke käbälgälen muure yaaka ülaŋ ye. Aŋ müükkï Laabaan merkä oogen yeeke. ");
INSERT INTO jum_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Aŋ kuññu nïïnkä kä ḍäk päy jï waadgen ti ike ke Yaagüüp, aŋ Yaagüüp ceeñjin kääññä ḍiik Laabaan yakkalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Aŋ Yaagüüp kuññu jengä kimken yek garkä ti, jaan bumbay ke jaan battä me ogo, lüüc ke yaŋkalaŋ ogo dülüb, aŋ beeyne kä äälgä wotku bowken, nüütï bownu läcäŋgä. ");
INSERT INTO jum_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Aŋ ike läcäŋgä yaaka beeyne ye, ḍoocce kä ḍiik ñomgen ti kuun maaṇṇä pii ti nänṭ'a äätete mätene kä ḍiik ye, aŋ ḍiik yuugu naana äätïdï mätï ye. ");
INSERT INTO jum_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Aŋ ḍiik yuugu kimkä ñomgen ti, aŋ ḍiik gïïtïdï woo ṭulgen yaaka yoken a äälgä ke müücülaŋ ke pergaŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Aŋ Yaagüüp käbälgälen yaakka kibbene woo pääken, aŋ ḍiik ñomgen ṭukke ḍiik yaaka yoken a äälgä ye ke ülken yaaka a yek Laabaan ye ti. Aŋ ike ḍoŋe kipkene woo kurku, aŋ batta agee ḍoocin ke ḍiik Laabaan. ");
INSERT INTO jum_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Aŋ naana ḍiik määngen teyken iiŋjin ye, i Yaagüüp ḍüccïdï läcäŋgä ḍiik ñomgen ti kuun jï, ogo yuugu ko cokal läcäŋgä ti. ");
INSERT INTO jum_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Aŋ yaaka bämaŋ ye batta ḍuckede läcäŋgä. Aŋ bämken a yek Laabaan, aŋ teyken ken a yek Yaagüüp. ");
INSERT INTO jum_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ken ina Yaagüüp wäätee agee kä ceeggon kä yaac yaanna, aŋ cääyge ḍiik ḍiirken, ke kiinkä määngen ke oogen, ke kälämgä ke tüürüŋŋï. ");
INSERT INTO jum_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Aŋ Yaagüüp tiiŋŋä ogo merkälen Laabaan jaygo ogo, “Yaagüüp waak yaaka a yek wäyo ye koowne muure, aŋ a waak wäyo ken käññee cekkïtïn yaanna muure.” ");
INSERT INTO jum_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Aŋ yoori Yaagüüp ike batta bilgänä Laabaan bata wääna ina. ");
INSERT INTO jum_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Aŋ Pïṭo Yaagüüp kiinne ogo, “Ḍukcu baan yen wäygic ti, ke yen mä yüükü ti, aŋ ika bi ke ïkï.” ");
INSERT INTO jum_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Aŋ Yaagüüp tuccin aŋ Rahiil ke Leya bärkene woo nänṭ'a kääjee kä ḍiik yeeke ye. ");
INSERT INTO jum_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Aŋ iken kiinne ogo, “Yoorru wääc ŋuca ika batta bilga jone ti bata wääna ina. Aŋ Jooŋ yen wäyo ke ika kamat. ");
INSERT INTO jum_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ŋäjje wääc ñuugulunu kä teynä yeeni muure. ");
INSERT INTO jum_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Aŋ wääc ṭääkcin ika mallaŋïngïn aŋ ñuugula carrä yeeni aakdene yok ääŋke caaydin, aŋ Jooŋ ike batta gïmkätä kä näŋgin ika nääŋkä yaackä. ");
INSERT INTO jum_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Aŋ naana ike jaajjï ogo, ‘Ḍiik müücülgü ken bi a ñuugala carrä yüünü ye,’ i muure gitä woo ṭulgen müücülaŋ. Aŋ naana jaajjï ogo, ‘Ñuugula carrä yüünü bi wäätï a ḍiik yaaka cäygene äälgä ye,’ i ḍiik muure gitä woo ṭulgen yaaka cäygene äälgä ye. ");
INSERT INTO jum_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Aŋ Jooŋ ḍigärgä yek wääc koojjene woo, aŋ iñña kä ika. ");
INSERT INTO jum_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Aŋ waan yaana yuugene kä ḍiik ye ika läkkä aŋ däämjänä ñaalok, aŋ ika yurcunu ñukku yaaka yoken a äälgä aŋ müücülaŋ aŋ pergaŋ ye, yuugu ke ḍiik määngen. ");
INSERT INTO jum_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Aŋ malak yen Jooŋ ika kiinna kä lääggï ogo, ‘Yaagüüp!’ Aŋ luuŋŋu ogo, ‘Haa ika inni!’ ");
INSERT INTO jum_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Aŋ ike jaajjin ogo, ‘Däämjä ñaalok aŋ yoorci ñukku yaaka yoken a äälgä aŋ müücülaŋ aŋ pergaŋ yaakca ti, yuugu ke ḍiik määngen, kä yaana nääŋkä yaaka näŋkiti kä Laabaan yaakka yooddu daa kä muure ye. ");
INSERT INTO jum_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ika agä Jooŋ yaana üükïn woo Betalï ina, yaana cückïnïï yok kolcan paydin aŋ lïïtkanaa kä ina. Aŋ juwu aŋgä yorü baan yaanni jï aŋ ḍukcu baan yen mä yüükü ti.’” ");
INSERT INTO jum_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Aŋ Rahiil ke Leya luukcin ogo, “Baati gin'a a büccïnï yädon paa ba wäyo ye. ");
INSERT INTO jum_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Aŋ ikoon naŋŋon bata boorgu, aŋ ikoon yääjjonon woo aŋ tiil yooko amme. ");
INSERT INTO jum_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Cekkïtïn muure yaaka koojji woo Jooŋ wäyo ti ye a yooko ke merkälen yooko. Aŋ wakkä muure yaaka kiinini Jooŋ ye naŋä.” ");
INSERT INTO jum_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Aŋ Yaagüüp juwin ñaalok, aŋ merkälen yeeke ke määnge taappe kälämgä. ");
INSERT INTO jum_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Aŋ ḍigärgä yeeke muure kïïtte ñome ti, ke wakkä yeeke muure yaaka kaññe Padaan Araam ye, aŋ attä wäyen Icaak ti ŋommañ mä Kanaan ti. ");
INSERT INTO jum_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Aŋ wääna Laabaan attee kä ŋitee kä yok ḍiik yeeke ye, i Rahiil juŋku yek wäyen kalle. ");
INSERT INTO jum_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Aŋ Yaagüüp Laabaan mä Araam malleŋïngïn batta nüütkede ogo ike bagje. ");
INSERT INTO jum_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Aŋ ike likcin woo ke wakkä yeeke muure, aŋ ircin woo wii mä Puraat aŋ üŋjïn baan pämkä mä Jïlaat ti. ");
INSERT INTO jum_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Aŋ nïïnnä ḍäk ti Laabaan nüütkï me ogo Yaagüüp likcono woo. ");
INSERT INTO jum_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Aŋ ike mä yeeke yaaka a ook ye koowne ke ike, aŋ Yaagüüp baatte ŋäc waan yen nïïnkä kä ŋaṭükel, aŋ wääṇṇe ŋäc pämkä mä Jïlaat ti. ");
INSERT INTO jum_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Aŋ Jooŋ äätin Laabaan mä Araam ti kä lääggï kä mïïllä aŋ kolle ogo, “Waŋgü tïïccï, Yaagüüp ŋana kiiṇdä jiikkalaŋ ŋana yaacken aŋ ŋana ŋerken.” ");
INSERT INTO jum_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Aŋ Laabaan Yaagüüp wääṇṇe ŋäc, i keeñ yeene agee kä ṭeljïnï ïñï baan pämkä mä Jïlaat witin, aŋ Laabaan ke mä yeeke keeññi yeeken ṭelji ïñï wïca cäänna. ");
INSERT INTO jum_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Aŋ Laabaan Yaagüüp taaññe ogo, “Ïkï näŋŋi ŋaaka? Ika mallaaŋïngïn aŋ ṭulgu yeeki koojjini woo bata yaaka müügünü me yääññäk ye. ");
INSERT INTO jum_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Aŋ ïkï pooljudu woo liidit aŋ ika maldaa ŋïngïn ina? Ika batta nüütkadaa, yoku ïkï tucceni woo kä jon ñamme ke oollu uulgu yek gerger ke kuukcu? ");
INSERT INTO jum_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Aŋ ika daljadaa cäänna merkä ṭulgu yeeki ke ṭulgu yeeki batta ŋïïbdä aŋ kuundu ḍugin ina? Aŋan ïkï näŋŋi amkïtïn. ");
INSERT INTO jum_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Aŋ kä teynä yeeni ïkï yoku näŋgïda nääŋkä yaackä, aŋ Jooŋ yen wääc ika kiinna wïïrïn tiññaŋ ogo, ‘Waŋü tïïccï, Yaagüüp ŋana kiiṇdä jiikkalaŋ ŋana yaacken aŋ ŋana ŋerken.’ ");
INSERT INTO jum_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Aŋ tiññaŋ ïkï kaacci woo kä yaana waŋgü kurrene kä än wääc ye, aŋ juŋku yeeki kalä ina?” ");
INSERT INTO jum_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Aŋ Laabaan luugi Yaagüüp ogo, “Ika booññu kä ïkï, ika ḍuucu ogo ṭulgu yüükü bi koowjey ika ti ko teynä. ");
INSERT INTO jum_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Aŋ juŋku yüükü naana kaññi mäŋkalaŋ ti ye, men yaanna batta bi üt. Maawä mä yooko ñomgen ti parü, naana waak yaaka a yüükü yaakka bilti ika ti ye i koowu.” I kucu Yaagüüp ogo kalgin ko Rahiil. ");
INSERT INTO jum_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Aŋ Laabaan kaaccä keeñ jï ba Yaagüüp, ke keeñ jï ba Leya, ke keeññi gïtï ba kiinkä määngen yaaka kä yewwe ye, aŋ batta agee kä kañgon. Aŋ wääna kääjenee woo keeñ jï ba Leya ye, ike kaaccä keeñ jï ba Rahiil. ");
INSERT INTO jum_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Aŋ Rahiil juŋku koowne, aŋ paanne yokïn kaakcä kalman jï aŋ cääjgene gïtï, aŋ Laabaan keeñ maawne jïñe muure aŋ batta agee kä kañgin. ");
INSERT INTO jum_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Aŋ wäyen kiinne ogo, “Ŋana ïkï pendä. Ika batta lïïṭä juwin ñaalok ñomü ti, paan yeeni a ḍäägïnï.” Aŋ maawne aŋ juŋku batta agee kä kañgin. ");
INSERT INTO jum_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Aŋ Yaagüüp pennä aŋ Laabaan lilgene ogo, “A yiñ yaana wali ye ken naŋŋä ina ken keñja kä yaanna? ");
INSERT INTO jum_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Wakkä yeeki muure maawni gïtï aŋ a ŋaaka ken kaññi a yüünü? Ḍoocci ïñï winni mä yeeki ke mä yüükü ñomgen ti, aŋ dalä iken jüccï waadgo ti a ŋaani ken wodaŋ.” ");
INSERT INTO jum_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Aŋ ika cääynä ke ïkï yuungu caykä kä yewwe, käbälgä ke ḍiik yüükü batta a guuṭin, aŋ ika batta agä ämon ḍiik yätken yüükü. ");
INSERT INTO jum_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ḍiik yaaka jiiji gïtï wakkä kurkuŋgu ye, batta äbädä ïkï ti, aŋ yaaka a yääyin ye i waajä pari. Aŋ kamat ïkï ñuju ika ti ḍuukkin gin'a kali me kä äŋ jïñe ke mïïllä ye. ");
INSERT INTO jum_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ika nägana carrä kä äŋ jïñe, ke lüüy kä mïïllä jïñe, aŋ nïïnkä yäygin waŋgi ti. ");
INSERT INTO jum_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Aŋ cäwdä yeeni muure paa baannü a yuungu caykä kä yew. Ika ñuugulunu yuungu caay witken kä ŋan ogo tïïrïn yüükü yaaka kä yew ye, aŋ yuungu kä ḍüügük ogo ḍiik yüükü. Aŋ ïkï ñuugula carrä yeeni aakki woo ääŋke kä caay. ");
INSERT INTO jum_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Naana yoku Jooŋ yen wäyo Abrayiim ke yaana boojene kä Icaak ye, batta ke ika ye, ïkï yoku ika tuccaa woo ïnkï kä lat. Aŋ Jooŋ yuṭṭu pillä yeeni ke ñuugula yen ïṇtï, aŋ ïkï gerrey wïïrïn tiinuk.” ");
INSERT INTO jum_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Aŋ LaabaanYaagüüp luuŋŋe ogo, “Ṭulgu a ṭulgu yeeki, ke merkä yeeken, aŋ ḍiik a ḍiik yeeki. Aŋ waak'a yooddu yaakka muure a yeeki. Aŋ a ŋaaka ken bi tiññaŋ näŋgä ṭulgu yeeki yaakki ke merkälen yeeken yaaka giidi ye? ");
INSERT INTO jum_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Äätä tiññaŋ näŋï jiik ḍoocin ïkï ke ika aŋ wäätï a nüütïn woo waan yüünü ke ika.” ");
INSERT INTO jum_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Aŋ Yaagüüp kuññu pääm, aŋ yuutte ñaalok a kolcan paydin. ");
INSERT INTO jum_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Aŋ Yaagüüp mä yeeke kiinne ogo, “Ḍüüṭe ti pämkä.” Aŋ pämkä koowi aŋ naŋi a koota, aŋ iken ämmä koota ti. ");
INSERT INTO jum_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Aŋ äkki Laabaan ogo Yajar Cahadüüta, aŋ äkki Yaagüüp ogo Galïït. ");
INSERT INTO jum_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Aŋ Laabaan jaajjin ogo, “Koota yaanni tiññaŋ ken bi a yuṭo waan yüünü ke ika.” Aŋ ina ken batte daa me ogo Galïït yaanna. ");
INSERT INTO jum_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Aŋ cäänna äkki me ogo Mïcpaa, aŋ Laabaan jaajjin ogo, “Dalä Pïṭo däämï waadgo ti, naana ïkïï pïïrtïnï ye. ");
INSERT INTO jum_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Aŋ naana ṭulgu yeeki naŋdä kärgit kujgudu ti meken i batta ŋäjjä ye, i cäänna daa yoottu Jooŋ.” ");
INSERT INTO jum_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Aŋ Laabaan jaajjin ogo, “Koota ke kolcan paydin yaana ḍooccu waan yüünü ti ke ika ye inni. ");
INSERT INTO jum_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Koota yaanni ken a yuṭo aŋ kolcan paydin ken a yuṭo, ika batta bi koota pämkä yaanni cüüpü woo ogo ïkï ïrkïda, aŋ päjjïdï ŋana ïkï cüüpüdü woo koota pämkä yaanni ti ogo ika irkada. ");
INSERT INTO jum_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Dalä Jooŋ yen Abrayiim ke Nahüür ke dänkä yurgen jücï waadgo ti.” Aŋ Yaagüüp lïïttä kä Jooŋ yaana boojene kä wäyen Icaak ye. ");
INSERT INTO jum_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Aŋ Yaagüüp iccin wäämmä yok pääm wic, aŋ mä yeeke bärkene ammä ti, aŋ wääna ämmene ye, nïngïn pääm wic. ");
INSERT INTO jum_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Aŋ kä tïṇṇäŋänä Laabaan merkä ṭulge ke ṭulgu yeeke kuunne ḍugin aŋ ŋüülkene. Aŋ ḍukcin baannen. ");
INSERT INTO jum_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Aŋ Yaagüüp jujjin woo attä kä päy aŋ malaŋŋi yek Jooŋ pärjene kä. ");
INSERT INTO jum_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Aŋ wääna yoorene daa kä Yaagüüp ye, ike jaajjin ogo, “A nänṭä kääygä Jooŋ inni.” Aŋ ina ken nänṭä yaanna äkkeeda ogo Manaayim yaanna. ");
INSERT INTO jum_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Aŋ Yaagüüp tuccin tüüjgï ñome ti attä pärjïdï ke määden Ïïcü ŋommañ mä Cïïr ti baan mooye mä Ïdoom ti. ");
INSERT INTO jum_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Aŋ eenjene aŋ kiinne ogo, “Ikee ate aŋ mügdo yeeni Ïïcü kiine ogo, ‘Kiingon yüünü Yaagüüp jääyïdï ogo, “Ika attä Laabaan ti, aŋ ikoon cääyon ke ike ke tiññaŋ. ");
INSERT INTO jum_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ika cääyga däk, ke tüürüŋŋï ke ḍiik ke kiinkä oogen ke määngen. Ika tuucunu ṭäkä nüütküdü mügdo yeeni ogo ika käñjo ŋerrä ïkï ti.”’” ");
INSERT INTO jum_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Aŋ tüüjgï ḍuukin Yaagüüp ti, aŋ jaajjin ogo, “Ikoon atton määdic Ïïcü ti. Aŋ ike äätïdï ike pärjede aŋ ike ädit ook caykä mäyken kä ŋan.” ");
INSERT INTO jum_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Aŋ Yaagüüp booññu kä yaac aŋ yore rüütte, aŋ m'aka ke ike ye kiimme gïtï kurku kä yew, ke ḍiik ke däk ke kälämgä. ");
INSERT INTO jum_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Aŋ Yaagüüp jaajjin ogo, “Naana Ïïcü ätä aŋ kun keelok irke ye, yakkalaŋ lïïṭï lïkcï woo.” ");
INSERT INTO jum_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Aŋ Yaagüüp jaajjin ogo, “Ay Jooŋ yen daan wäyo Abrayiim ke wäyo Icaak, ay Pïṭo ika kiinnaa ogo, ‘Ḍukcu baan yüünü ti ke mä yüükü ti, nuŋko bi näŋgenii kä ŋerrä ye.’ ");
INSERT INTO jum_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ika batta päjjädä kä biilin yaana batta düüñïdï ye ke woṇṇu yaana nüütkana kä ika kiingon yüünü ye. Aŋ wääna ircänä woo wii mä Üürdün ye a lacan pare ken äddä. Aŋ tiññaŋ ika wäättä kurku kä yewwe. ");
INSERT INTO jum_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kura magja kä määdo Ïïcü. Ika booju kä ike, nuŋko äätïdï aŋ ika irkada, ke määngä ke merkä. ");
INSERT INTO jum_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Aŋ ïkï jaajjini ogo, ‘A gïtken ika ïkï bi näŋgeni ŋerrä, aŋ kilkä yüükü bi naŋä bata ṭiŋal yek wii jïñe yaaka batta lïïltä me kä paŋŋä ye.’” ");
INSERT INTO jum_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Aŋ ike nïïnnä wïca wïïrïn jïñe yaanja ti, aŋ waak yeeke ti ike määden Ïïcü wäkkene woo iñdin. ");
INSERT INTO jum_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Aŋ wäkkene woo ḍiik määngen 200, ke ñukku caykä kä yew, ke käbälgä määngen 200, ke käbälgä yätken caykä kä yew, ");
INSERT INTO jum_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ke kälämgä määngen caykä kä ḍäk ke ṭulgen, ke däk caykä kä ŋan ke yätkä kä caay, ke tüürüŋŋï määngen caykä kä yew aŋ oogen kä caay. ");
INSERT INTO jum_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Aŋ yaakka iññe kiinkä yeeke aŋ ike jaajjin ogo, “Ate ñomi ti aŋ waan yaŋkalaŋ dale kun yaŋkalaŋ atï ñomuk aŋ yaŋkalaŋ kä ŋäjäk.” ");
INSERT INTO jum_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Aŋ kiingon yaana ïïjjïdï ye iingene ogo, “Naana määdo Ïïcü purjene kä aŋ ïkï tajdey ogo, ‘Ïkï agä män ŋaani? Aŋ ïkï atä wa? Aŋ a ḍiik ŋaani ika ye?’ ");
INSERT INTO jum_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","I luugu ogo, ‘A yek kiingon yüünü Yaagüüp, yaakki a iñdin tuckudu mügdo yeeni Ïïcü. Aŋ Yaagüüp kä ḍoŋe bilti äätä ŋätko ti.’” ");
INSERT INTO jum_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Aŋ yewwe yeene ke ḍäke eenjene kä jiik keelkä ke yaaka muure baadit ḍigärgä ye, ogo, “Ikee jaajje jiik keelkä Ïïcü ti naana ike kaññe ye. ");
INSERT INTO jum_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Aŋ ikee jaajje ogo, ‘Kiingon yüünü Yaagüüp bilti äätä ŋätko ti.’” Ike payit ogo, “Bi läägä juuggin ïñï kä iñdin yaaka atï ñomi ti yaakki. Aŋ wäättan naana yooru ye, naana ṭäkï ye ika bi gïmga.” ");
INSERT INTO jum_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Aŋ ike a tüccïnï iñdin ñomuk aŋ ike nïïnnä nänṭä keeññi. ");
INSERT INTO jum_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Aŋ mïïllä jïñe keellä yaanja ti ike juwin ñaalok aŋ määngä yeeke yaaka kä yewwe ye koowne ke kiinkä yeeke määngen, ke merkä yeeke yaaka caay wiñen kä keelok ye, aŋ ircin woo wii mä Yabüük. ");
INSERT INTO jum_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Aŋ iken koowne aŋ tucce ircin woo wii, ke wakkä yeeke muure yaaka bilti ye, ");
INSERT INTO jum_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","aŋ Yaagüüp dalji me ïñï pare. Aŋ mügjïn ke oon ke buur kääje. ");
INSERT INTO jum_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Aŋ wääna yoorene daa kä oon yuccee kä ye. I Yaagüüp jemme ḍïïne ti, aŋ ḍïïne kooynu wääna mükcete kä ye. ");
INSERT INTO jum_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Aŋ kiini oon ogo, “Dalä ika atä buur kääjin.” Aŋ kiini Yaagüüp ogo, “Ïkï batta äkkedeni atä ke ŋüülkaa kä.” ");
INSERT INTO jum_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Aŋ taaji oon ogo, “Ïkï batti me ogo ŋaani?” Aŋ kiinne ogo, “Ika batta me ogo, Yaagüüp.” ");
INSERT INTO jum_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Aŋ kiini oon ogo, “Yäṇtonḍü ŋuca batta bi battä me ogo Yaagüüp, ïkï bi batti me ogo Icärayiil. A nääŋka mügjene ke Jooŋ ke me, aŋ yoññeeda kä ye.” ");
INSERT INTO jum_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Aŋ Yaagüüp jaajjin ogo, “Nüütkaa yäṇtonḍü.” Aŋ taaji oon ogo, “Ika tajdaa kä yäṇtonḍi ina?” Aŋ wäättan ŋüülkene wïca. ");
INSERT INTO jum_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Aŋ Yaagüüp nänṭä äkkene ogo Pïnïyel. Aŋ naana aŋan ye i ogo, “Ikoon yuurtonon woŋgin ke Jooŋ, aŋ ika por daa agä üdon.” ");
INSERT INTO jum_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Aŋ wääna Pïnïyel daljedeeda kä ïñï ye i kääcki äŋ wïca aŋ ike ŋoldïdï kä yaana ḍïïne agee kä kooyon kä ye. ");
INSERT INTO jum_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ina ke tiññaŋ mä Icärayiil batta ämene kä puuc mäyken waadgä ḍïïnä yaanna kä yaana Yaagüüp jemmeeda kä ḍïïne ti ye. ");
INSERT INTO jum_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Aŋ Yaagüüp däämjin aŋ Ïïcü yooṭṭe äätä ke ook 400. Aŋ ike merkä kiibgene gïtï Leya ke Rahiil ke kiinkä määngen yaaka kä yewwe ye. ");
INSERT INTO jum_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Aŋ ike kiinkä määngen ḍoocce ke merkälen yeeken ñomuk, aŋ Leya ke merkälen yeeke ŋäñe ti, aŋ Rahiil ke Yuucip ken a düüñïn meken muure. ");
INSERT INTO jum_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Aŋ ike kä ḍoŋe ïïjjïn attä ñomgen ti, aŋ ike ḍüŋjïn ïñï aŋ ñome düücce ïñï ŋommañ jï ääŋke kä ŋaṭükel ke ḍääge ti määden ti kä cokal. ");
INSERT INTO jum_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Aŋ Ïïcü yïŋŋä pärjin ke määden aŋ yoken käägi aŋ ŋïïbbïn kä ḍuuggen, aŋ muckene yok, aŋ weggin muuṭuk. ");
INSERT INTO jum_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Aŋ wääna Ïïcü yuṭṭee kä määngä ke merkälen ye, ike tääccin ogo, “A ŋaannä ika ke ïkï yaakka?” Aŋ luugi Yaagüüp ogo, “A merkä yeeki yaaka iñi Jooŋ kiingon yüünü kä ŋerrä ye.” ");
INSERT INTO jum_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Aŋ kiinkä määngen wüükïn ti ke merkä yeeken aŋ ḍüŋjïn ïñï. ");
INSERT INTO jum_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Aŋ Leya cäänna daa wüükïn ti ke merkä yeeke aŋ ḍüŋjïn ïñï. Aŋ düüñïn meken Yuucip ke Rahiil wüükïn ti aŋ ḍüŋjïn ïñï. ");
INSERT INTO jum_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Aŋ Ïïcü jaajjin ogo, “Yaakka muure nüütï ŋaaka ḍigärgä yaaka pärjonon kä yaakka?” Aŋ luugi Yaagüüp ogo, “Ogo ika käññä ŋerrä mügdo yeeni ti.” ");
INSERT INTO jum_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Aŋ Ïïcü jaajjin ogo, “Ika cääygana kä ḍiräk määdo, yaaka bilti yaakka tïïcïï kä ḍoŋü.” ");
INSERT INTO jum_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Aŋ Yaagüüp jaajjin ogo, “Ba'ay, naana ika käññä ŋerrä ïkï ti ye, i iñdin yeeni gïmgä. Waŋgü yaaka yoorru ye beeljin bata gin'a ika yuṭṭu Jooŋ ye, kä yaana gïmganaa kä, kä ŋerrä ye. ");
INSERT INTO jum_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kura iñdin yeeni gïmgä yaana äbi me ïkï ti yaanja, Jooŋ ŋerräŋer ke ika aŋ ika iñña wakkä kä ḍiräk.” Aŋ wina Ïïcü ïïrï Yaagüüp ke gïmme. ");
INSERT INTO jum_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Aŋ Ïïcü jaajjin ogo, “Juwe atïn, aŋ ika bi ïïjjä atä ñomü ti.” ");
INSERT INTO jum_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Aŋ Yaagüüp ike kiini ogo, “Mügdo yeeni ŋäjjä merkä lïjgaŋ aŋ ḍiik ke däk yaaka nïïtï ye ṭulgen lïjaŋ. Naana äddi me kä yaac äŋ jïñe kä keelok ye, i ḍigärgä muure bi tüwok. ");
INSERT INTO jum_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mügdo yeeni kura ïïjjä kiingon yüünü ñome ti, aŋ ikoon bi bääton kä ḍeeḍaŋ, waan yaana a yïïkon ḍigärgä ti ke merkälen ti ye, ke miikenii Cïïr.” ");
INSERT INTO jum_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Aŋ Ïïcü jaajjin ogo, “Dalä ook yakkalaŋ mäñgenii kä ïñï yaaka ke ika ye.” Aŋ Yaagüüp luukcin ogo, “Ina? Ika ñuynu yeeni muure ogo ika käñjo ŋerrä mügdo yeeni ti.” ");
INSERT INTO jum_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Aŋ nïïnnä yaanja ti Ïïcü ḍukcin attä Cïïr. ");
INSERT INTO jum_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Aŋ Yaagüüp baŋŋä Caküüt, aŋ kuṭṭu än, aŋ ḍigärgä yeeke näŋgene däŋkä. Ina ken nänṭä yaanna batte daa me ogo Caküüt yaanna. ");
INSERT INTO jum_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Aŋ Yaagüüp wääna äätee kä Padaan Araam ye, ḍäägin ti kä ŋer baan mooye yen mä Cakïïm ti ŋommañ yen mä Kanaan ti, aŋ keeññi yeeke ṭeljene ïñï baan mooye ñome ti. ");
INSERT INTO jum_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Aŋ kiññä ŋommañ yaana kurcenee kä keeñ yeene ye, minneni Hamuur Cakïïm wäyen ti tiilgä gälkä waŋgen 100. ");
INSERT INTO jum_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Aŋ näŋŋä tambal wïca aŋ äkkene ogo Jooŋ yen mä Icärayiil ogo Jooŋ. ");
INSERT INTO jum_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Aŋ Ḍïïna ṭul Leya yaana giide Yaagüüp ti ye, kaaccä woo atï ükcïdï ṭulgu yek baan. ");
INSERT INTO jum_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Aŋ wääna Cakïïm minneni Hamuur mä Haaw, yätïn yen baan yaanja Ḍïïna yoorre daa kä ye, i müüŋŋe. ");
INSERT INTO jum_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Aŋ jone ṭäkcin Ḍïïna ṭul Yaagüüp. Aŋ ṭuulle ḍeerconḍe bilgene aŋ jääjgene kä ŋer kuckon. ");
INSERT INTO jum_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Aŋ Cakïïm jaajjin wäyen Hamuur ti ogo, “Ṭuulle yaanna kujgaa kä wäätï a iiŋ yeeni.” ");
INSERT INTO jum_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Aŋ wääna Yaagüüp tiiŋŋee kä ogo ṭuulle yeene Ḍïïna müüŋŋïï Cakïïm ye, i merkälen yeeke a woo ke ḍigärgä yeeke, aŋ ike tïïŋjïn ïñï ke iken ḍuukene ti. ");
INSERT INTO jum_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Aŋ Hamuur Cakïïm wäyen attä jayok ke Yaagüüp. ");
INSERT INTO jum_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Aŋ wääna merkälen Yaagüüp äätene kä ti äätene woo aŋ tiiŋŋene kä gin'a näŋŋä ḍoŋe ye, i iken mïtcïn ñaalok aŋ piiṇdin kä yaac, kä yaana Cakïïm näŋŋee kä loon mä Icärayiil ti kä müüŋŋü ṭuulle Yaagüüp ye, aŋ a gin'a yoku batta päjjïdï naŋtä me ye. ");
INSERT INTO jum_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Aŋ kiini Hamuur ogo, “Minneni yeeni Cakïïm jone kaaccä ṭuulle yüünü ti, kura iñjeeda dalä wäätï a iiŋe. ");
INSERT INTO jum_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ḍïkïn jiik dale kuuwin wäätï waadgä mä yooko ke mä yeekic ti. ");
INSERT INTO jum_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Aŋ cääye ke ikoon waan a kupon ŋommañ yaanni ti, cääye nänṭ'a ṭäkke ye, aŋ laaye kä tettä aŋ ikee käñe wakkä yeekic jïñe ti.” ");
INSERT INTO jum_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Aŋ Cakïïm jaajjin Ḍïïna wäyen ti ke mädgen ti aŋ kiinne ogo, “Dale ika käñä ŋerrä ikee ti, aŋ ikee bi iñe wakkä muure yaaka taaja kä ye. ");
INSERT INTO jum_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Aŋ naana daa yelgä caraŋ bata ŋa' ke iñdin ye, ika äccädä waak'a ñuye ye muure. Aŋ ṭuul iña kä a iiŋ yeeni.” ");
INSERT INTO jum_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Aŋ merkälen Yaagüüp Cakïïm ke wäyen Hamuur luugi kä malläŋïngïn kä yaana Cakïïm käwen müüŋŋee da ye. ");
INSERT INTO jum_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Aŋ kiini ogo, “Ikoon batta lïïṭon nääŋkä yaakka naŋon, käwo iñon m'ana batta a ergon ye, yaanna bi wäätï a loon mooye ikoon ti. ");
INSERT INTO jum_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ikoon bi kaacon ḍeŋŋä jiik ti ke ikee kä gin kä keelok, dale ikee beelje bata ikoon kä iirrä ook yeekic muure. ");
INSERT INTO jum_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Aŋ wäättan ikee bi iñge ṭulgo aŋ ikoon bi kujon ṭulgic daa a yooko, aŋ ikoon bi cäyon ke ikee aŋ ïkïïn wäätïn agïn mä keelkä. ");
INSERT INTO jum_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Aŋ ikee naana batta gïmmede kä jiik yooko aŋ ikee batta iire ye, i käwo bi koowon aŋ ikoon bi aton.” ");
INSERT INTO jum_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Aŋ jiik yaakka Hamuur ñaappe jok ke minneni yeene Cakïïm. ");
INSERT INTO jum_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Aŋ Cakïïm batta a kooron kä naŋŋä nääŋkä yaakka, kä yaana jone ñappee kä ṭuul Yaagüüp ye. Aŋ Cakïïm ken tïïlcïdï eemtä me kä yaac äntüke yen wäyen ti, ");
INSERT INTO jum_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","aŋ Hamuur ke minneni yeene Cakïïm äätin äntüke baan mooye yeenen ti, aŋ iken jaajjin mä baan mooye yeenen ti ogo, ");
INSERT INTO jum_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Me yaakki näŋŋä ŋïïbbïn ke ïkïïn. Dale iken cäyok baan yoono jï aŋ layok, ŋommañ gääbaŋ päjjïdï iken ti, dale ïkïïn ḍïcïn ṭulgu yeeken, aŋ iken ïñïn ṭulgo a määngen. ");
INSERT INTO jum_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Aŋ iken bi gïmmä kä cäwdä ke ïkïïn bata mä keelkä ke ïkïïn, naana ook yooko iirgä me bata iken ye. ");
INSERT INTO jum_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Aŋ naana yaakki naŋïn ye, i ḍigärgä yeeken muure ke wakkä yeeken bi wäätï a yooko, ääte gïmmïn kä jiik yeeken, aŋ dale iken cäyok winni ke ïkïïn.” ");
INSERT INTO jum_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Aŋ me muure yaaka attä baan mooye tük ye gïmmïn kä jiik yaaka naŋi Hamuur ke Cakïïm yaanna, aŋ ook muure iiri me. ");
INSERT INTO jum_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Aŋ nïïnkä kä ḍäk wääna ook mor wääcene kuggu iirrä ye, merkälen Yaagüüp kä yewwe Camoon ke Laawï yaaka a Ḍïïna mädgen ye, iken gaaḍalli yeeken koowi aŋ ircin baan mooye jï i kucu me, aŋ ook muure nägi ḍugin. ");
INSERT INTO jum_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Aŋ iken Hamuur nägi ḍok ke minneni yeene Cakïïm kä gaaḍalli, aŋ Ḍïïna äbi woo äräk ba' Cakïïm aŋ iken attä. ");
INSERT INTO jum_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Aŋ merkä Yaagüüp äätin aŋ nääkin me aŋ baan mooye gaani jï kä yaana käwen müügene daa me ye. ");
INSERT INTO jum_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Aŋ ḍiik yeeken ke däk ke tüürüŋŋï yeeken koowi ke waak muure yaaka baan mooye jï ye ke yirkä. ");
INSERT INTO jum_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wakkä yeeken muure ke äärgä gïtken muure gaani. Iken cäänna merkälen lïcken yeeken koowi ke määngen aŋ kïïdï bata mä müükïn. ");
INSERT INTO jum_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Aŋ Yaagüüp jaajjin Camoon ti ke Laawï ti ogo, “Ikee ika äckana ḍok tïñïdïn tiññaŋ mä Kanaan ke mä Peeric ke me muure yek baan ika bi putkana jï. Aŋ ika batta cääygana ook kä ḍiräk, aŋ naana iken muure yoken ḍülgü aŋ ika irkana ye, i mä äntüke yeeki bi ḍüümgü gïtï.” ");
INSERT INTO jum_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Aŋ iken luukcin ogo, “Ikoon käwo daljon naŋde bata iiŋ yaana a baal ye?” ");
INSERT INTO jum_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Aŋ Jooŋ Yaagüüp kiinne ogo, “Atä Betalï ŋuca aŋ cääyä wïca. Aŋ bätkaa tambal wïca, Ika Jooŋ yaana üükïn woo ïkï ti wääna buurcinii kä woo määdic Ïïcü ti ina.” ");
INSERT INTO jum_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Aŋ Yaagüüp jaajjin mä äntüke yeene ti ke m'aka muure ke ike ye ti ogo, “Juŋku yaaka a pääken ye aŋge yokïn ikee ti, aŋ yokic laate woo aŋ ääkce buruŋgu latkä. ");
INSERT INTO jum_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Juwe atïn Betalï aŋ ika ṭäkä, Jooŋ bätkädä tambal wïca yaana ika yüükkana ti waan tïñïdïn ti aŋ ike ke ika nänṭä muure yaana atä kä ye ti.” ");
INSERT INTO jum_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Aŋ iken juŋku muure yaaka ke iken ye, iñi Yaagüüp ke jaljalli yaaka eŋtä gitken ti ye. Aŋ jïkke ïñï jaan mooye ŋoy, yaana cokulaŋ ti Cakïïm ye. ");
INSERT INTO jum_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Aŋ wääna Yaagüüp ke merkä yeeke bagene kä ye, mä bänkä yaaka cokulaŋ ti nänṭ'a kaajdene kä ye, nääkki Jooŋ liin mooye, aŋ batta agene kä ñoolgin ŋätin. ");
INSERT INTO jum_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Aŋ Yaagüüp äätin ke mä yeeke muure Lüüc yaana tiññaŋ battä me ogo Betalï ye, ŋommañ yen mä Kanaan ti. ");
INSERT INTO jum_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Aŋ ike bättä tambal wïca aŋ äkkene yäṇtäŋ ogo, El Betalï, aŋ aŋan ogo Jooŋ yen Betalï kä yaana Jooŋ üükenee woo ike ti kä lääggï wääna ike lüüdee kä woo määden ti ye. ");
INSERT INTO jum_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rïpga niito yeene Dïboora tüwnü aŋ jïgï me ïñï jaan mooye ŋoy Betalï ti kä ïñï, aŋ äkki me ogo, Aluun Baküüt, aŋ aŋan ogo “Jaan Ïwok.” ");
INSERT INTO jum_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Aŋ wääna Yaagüüp ḍuukee kä Padaan Araam ye, i Jooŋ üükïn woo ike ti ŋuca Betalï aŋ ike ŋüülkï. ");
INSERT INTO jum_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Aŋ ike kiini Jooŋ ogo, “Yäṇtonḍü ogo Yaagüüp, aŋ yäṇtonḍü batta ŋuca bi battä me ogo Yaagüüp ke on. Yäṇtonḍü bi battä me ogo Icärayiil.” Aŋ ike äkki Jooŋ ogo Icärayiil. ");
INSERT INTO jum_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Aŋ ike kiini Jooŋ ogo, “Ika agä Jooŋ yaana Lïïṭït ye, giidä aŋ ḍiirä aŋ wäätci age ṭoŋ aŋ ṭoŋ ḍiirken bi käjä woo ïkï ti aŋ ïkï bi wäätci agä daan yuur yen yätkäni. ");
INSERT INTO jum_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Aŋ ŋommañ yaana iññä Abrayiim ke Icaak ye bi iñenii kä cäänna ke kilkä yaaka äätä ŋäñü ti ye.” ");
INSERT INTO jum_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Aŋ Jooŋ ike dalji ïñï nänṭ'a jaaynene kä ye. ");
INSERT INTO jum_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Aŋ Yaagüüp ḍuccin kolcan paydin nänṭ'a jaaynene ke Jooŋ ye, aŋ puukkene wic määk ke ñownä aŋ yaanna nüütï a kolcan paydin yaana tïïlcïdï ye. ");
INSERT INTO jum_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Aŋ Yaagüüp nänṭä yaana jaaynene ke Jooŋ ye äkkene ogo Betalï. ");
INSERT INTO jum_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Aŋ Yaagüüp ke mä äntüke yeeke Betalï mañji ïñï aŋ wääna mor uterene kä utar Ipiraat ye, i wuuŋ yaana giidene Rahiil ye ḍäägin aŋ bääŋ yeene pegaŋ kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Aŋ wääna bääŋ yeene pekkee kä ïñï kä yaac ye, i iiŋ yaana gïtï ye ike kiini ogo, “Ŋana ïkï booju ïkï cääygi minnenile oone menen.” ");
INSERT INTO jum_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Aŋ ike tüw aŋ wääna wääktäŋ yeene kääjedee kä woo ye i minneni äkkene ogo Benaawni aŋ aŋan ogo “Minneni bääŋ yeeni.” Aŋ äkki wäyen ogo Benyamïïn aŋ aŋan ogo “Minneni yen ïntï birrä.” ");
INSERT INTO jum_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Aŋ Rahiil ṭüwnü aŋ jïkï me ïñï päy mä Ipiraat taaŋ. Aŋ cäänna Ipiraat battä me ogo Beetlaam. ");
INSERT INTO jum_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Aŋ Yaagüüpkolcan paydin ḍoocce wïca kääl Rahiil wic aŋ daa yoottu me wïca ke tiññaŋ. ");
INSERT INTO jum_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Aŋ Yaagüüp baŋŋä aŋ keeñ yeene ṭeljene ïñï Mekdaal Adaar taaŋŋañja. ");
INSERT INTO jum_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Aŋ wääna Yaagüüp cääye kä baan yaanja ti ye, i Robïïn Bila nïïnne, kiingon iiŋe yen wäyen, aŋ jiik yaakka tiiŋi Yaagüüp. Aŋ yaakki a yäṇtäŋŋi yek merkälen Yaagüüp yaaka kä caay witken kä yewwe ye. ");
INSERT INTO jum_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Aŋ merkälen Leya a Robïïn kaygon yen Yaagüüp ke Camoon ke Laawï ke Yahüüja ke Yacakïïr aŋ Jabuloon. ");
INSERT INTO jum_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Aŋ merkälen Rahiil a Yuucip ke Benyamïïn. ");
INSERT INTO jum_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Aŋ merkälen Bila kiingon yen Rahiil a Ḍaan ke Naptaalï. ");
INSERT INTO jum_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Aŋ merkälen Jïlpa kiingon yen Leya a Gaat ke Acïïr. Aŋ a merkälen Yaagüüp yaaka gitkene daa me Padaan Araam ye ikki. ");
INSERT INTO jum_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Aŋ Yaagüüp attä wäyen Icaak ti nänṭ'a battä me ogo Mamar ye cokulaŋ ti Gariya Arba, yaana tiññaŋ battä me ogo Hiburoon ye, nänṭ'a cääynene Abrayiim ke Icaak bata boorgu ye. ");
INSERT INTO jum_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aŋ Icaak cääynä ke yuunge ḍake 180. ");
INSERT INTO jum_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Aŋ ike wääkcin woo wääktäŋ tüwnü aŋ tüwnü aŋ ike cooṭi me ti dänkä yurge ti, i yuunge a päjjïnï, aŋ merkä yeeke Ïïcü ke Yaagüüp ken ike jïgï. ");
INSERT INTO jum_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","A perrä yen kaaynä Ïïcü ikki aŋ Ïïcü cäänna battä me ogo Ïdoom. ");
INSERT INTO jum_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Aŋ Ïïcü kuññu määngä yek mä Kanaan ti Adda ṭul Eylüün a mä Haat aŋ Oolïbaama ṭul Anna yen Jabüün a mä Haaw, ");
INSERT INTO jum_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ke Bacamaat ṭul Icämayiil a Nabïyüüt kuwen. ");
INSERT INTO jum_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Aŋ Adda Ïïcü gitkene Alïpaac aŋ Bacamaat giiṇṇä Rowïïl. ");
INSERT INTO jum_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aŋ Oolïbaama giiṇṇä Yahüüc ke Yalaam, aŋ Goora. Aŋ merkälen yaakki muure gitki me Ïïcü ŋommañ mä Kanaan ti. ");
INSERT INTO jum_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Aŋ Ïïcü määnge koowne ke merkälen yeeke ke ṭulgu yeeke ke m'aka cäyok ke ike ye muure nänṭä keellä ke ḍigärgä aŋ wakkä muure yaaka kaññe ŋommañ mä Kanaan jï ye, aŋ ike kaaccä woo määden Yaagüüp ti aŋ attä baan yaŋkalaŋ ti. ");
INSERT INTO jum_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Aŋ ŋommañ boonji woo iken ke ḍigärgä ke wakkä yeeken muure. ");
INSERT INTO jum_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Aŋ Ïïcü yaana battä me ogo Ïdoom ye, cääjjin kä tüümo wic baan mä Cïïr ti. ");
INSERT INTO jum_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","A perrä yen kaaynä Ïïcü ikki a wäy yen mä Ïdoom tüümo mä Cïïr ti. ");
INSERT INTO jum_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","A yäṇtäŋŋi merkä Ïïcü ikki, Alïpaac minneni Adda iŋ Ïïcü aŋ Rowïïl minneni Bacamaat iŋ Ïïcü. ");
INSERT INTO jum_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Merkä yek Alïpaac a Tïïmaan, ke Umar, ke Jappo, ke Jataam aŋ Gannaac. ");
INSERT INTO jum_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Aŋ Tïmna a kiingon iiŋe yen minneni Ïïcü Alïpaac, ike gittä Amaliik Alïpaac ti. A merkä yek Adda ikki iŋ Ïïcü. ");
INSERT INTO jum_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Aŋ a merkä Rowïïl ikki, Nahaat ke Jüra ke Camma aŋ Mïjja. Merkä yek Bacamaat ikki iŋ Ïïcü. ");
INSERT INTO jum_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Aŋ a merkä yek Oolïbaama ṭul Anna minneni Jabüün yaana gitkene Ïïcü ye, iken a Yahüüc ke Yalaam aŋ Goora. ");
INSERT INTO jum_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Kaaynä yaakki a yek Ïïcü yaaka wäättä a woydoni yek kaaynä ḍiirken ye, merkä yek minneni Ïïcü mooye Alïpaac wäättä a woydoni aŋ yäṇtäŋgenen ogo Tïïmaan ke Umar ke Jappo ke Gannaac ");
INSERT INTO jum_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ke Goora ke Jataam aŋ Amaliik. Aŋ yaakki a woydoni yek kaaynä yek ŋommañ mä Ïdoom ti. Merkä Alïpaac yaakki muure a kaaynä yek Adda iŋ Ïïcü. ");
INSERT INTO jum_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","A merkä yek Rowïïl ikki minneni Ïïcü, woydoni a Nahaat ke Jüra ke Camma aŋ Mïjja. Aŋ yaakki a woydoni yek kaaynä yek ŋommañ mä Ïdoom, iken a kaaynä Bacamaat iŋ Ïïcü. ");
INSERT INTO jum_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Aŋ a merkä yek Oolïbaama ikki iŋ Ïïcü, woydoni a Yahüüc ke Yalaam aŋ Goora. Aŋ a woydoni yaaka giidi iŋ Ïïcü Oolïbaama tïïronle Anna ye. ");
INSERT INTO jum_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Yaakki muure a kaaynä Ïïcü aŋ cäänna battä me ogo mä Ïdoom, aŋ a woydoni yeeken ikki. ");
INSERT INTO jum_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Aŋ a merkä oogen yek Cïïr ikki mä Hüür iken cäyok ŋommañ mä Ïdoom ti, a Luutaan ke Cubaal ke Jabüün ke Anna ");
INSERT INTO jum_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ke Dïïcüün ke Ïjaar aŋ Dïïcaan. Aŋ merkä oogen yek Cïïr yaaka cäyok ŋommañ mä Ïdoom ti ye a woydoni yek mä Hüür. ");
INSERT INTO jum_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Aŋ merkälen oogen Luutaan a Hüür ke Hamaam. Aŋ Luutaan käwen a Tïmna. ");
INSERT INTO jum_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Aŋ a merkä oogen yek Cubaal ikki Albaan ke Manaat ke Ibaal ke Cabbo aŋ Unaam. ");
INSERT INTO jum_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Aŋ merkä oogen yek Jabüün a Ayya ke Anna, aŋ ike a Anna yaana käññä ceere piike caraŋ woo teettälaŋ ina wääna ike kääjee kä tüürüŋŋï yek wäyen Jabüün ina. ");
INSERT INTO jum_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aŋ merkä yek Anna a Dïïcüün ke ṭuule Oolïbaama. ");
INSERT INTO jum_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Aŋ merkä yek Dïïcüün a Ïmdaan ke Ïjbaan ke Ïtïraan aŋ Kïïraan. ");
INSERT INTO jum_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Aŋ merkä yek Ïjaar a Bïlaan ke Jabaan aŋ Agaan. ");
INSERT INTO jum_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Aŋ merkä Dïïcaan a Üüc ke Araan. ");
INSERT INTO jum_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Aŋ woydoni yek kaaynä mä Hüür a Luutaan ke Cubaal ke Jabüün ke Anna ");
INSERT INTO jum_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ke Dïïcüün ke Ïjaar aŋ Dïïcaan. Iken a woydoni yek äärgä tüggen yek mä Hüür yaaka cäyok ŋommañ mä Cïïr ye ti. ");
INSERT INTO jum_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","A yätkäni yaaka mügdïn ŋommañ mä Ïdoom ye ikki, i mor baati yätkä yaana a mükon mä Icärayiil ye. ");
INSERT INTO jum_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beela minneni Bahüür wäättä a yätkä yen Ïdoom. Yäṇtäŋ baan yeene mooye battä me ogo Dïnaaba. ");
INSERT INTO jum_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Aŋ Beela tüwnü aŋ Jübaab minneni Jüra män nänṭ'a battä ogo Bücüra ye ken mükkü nänṭä yeene. ");
INSERT INTO jum_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Aŋ wääna Jübaab tüwnee kä ye, Ucaam yaana cääy ŋommañ mä Tïïmaan ti ye nänṭä yeene müŋŋe. ");
INSERT INTO jum_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Aŋ wääna Ucaam tüwnee ye, Haddaat minneni Baadaat yaana buuccu mä Mïdïyaan ŋommañ mä Muwaab ye ti, mükkü nänṭä yeene, aŋ yäṇtäŋ baan yeene mooye ogo Awïït. ");
INSERT INTO jum_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Aŋ wääna Haddaat tüwnee ye, Camla yen mä Macareega mükkü nänṭä yeene. ");
INSERT INTO jum_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Aŋ wääna Camla tüwnee kä ye, Caawüül yen mä Rabuut yaana cääy wii ḍok kä cokal ye mükkü nänṭä yeene. ");
INSERT INTO jum_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Aŋ wääna Caawüül tüwnee kä ye, Baalhanaan minneni Akabüür mükkü nänṭä yeene. ");
INSERT INTO jum_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Aŋ wääna Baalhanaan minneni Akabüür tüwnee kä ye, Haddaat mükkü nänṭä yeene aŋ yäṇtäŋ baan mooye yeene ogo Paaw. Aŋ iiŋe battä me ogo Matabïïl tïïronle Matareet aŋ ṭiin meen a Madahaab. ");
INSERT INTO jum_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","A yäṇtäŋŋi yek woydoni yek äärgä tüggen Ïïcü ikki ke nänkä yaaka cääyene kä ye, yäṇtäŋgenen a Tïmna ke Alwa ke Yatïït ");
INSERT INTO jum_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ke Oolïbaama ke Ïïla ke Peynüün ");
INSERT INTO jum_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ke Ganaac ke Tïïmaan ke Mïpcaar ");
INSERT INTO jum_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ke Majdïïl aŋ Iraam. Yaakki a woydoni yek mä Ïdoom kä Ïïcü ti wäy yen Ïdoommi daa kä nänk'a cääyene kä ye ke ŋommañ yaana küümgï ye. ");
INSERT INTO jum_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Aŋ wïca Yaagüüp ŋuccin cääynä ŋommañ mä Kanaan ti nänṭ'a cääynene kä wäyen bata boorgon ye. ");
INSERT INTO jum_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","A perrä yen kaaynä Yaagüüp ikki. Yuucip a minneni oone cääygene yuungu kä caay witken kä ŋaṭükel, i kääjï ḍiik ke merkä yek määngä wäyen Bila ke Jïlpa. Aŋ Yuucip wäyen äckene jiik yaackä kä nääŋk'a naŋtä mädgen yejgaŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Aŋ Yaagüüp Yuucip ken bilge kä yaac kä mädgen, nääŋka ike agee minneni yen ḍüŋkïtïn yeene ye, aŋ näŋgene burŋu ŋerrä. ");
INSERT INTO jum_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Aŋ wääna mädgen muure yuṭṭene ike bilgene daa wäyen kä yaac kä iken ye, putki jï kä yaac, aŋ batta jääckätä kä jon ñammä. ");
INSERT INTO jum_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Aŋ Yuucip cääyge lääggï aŋ wääna päkkenee daa mädgen ye, i iken ike putki jï kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Aŋ kiinne ogo, “Tiiŋe lääggï yaaka läkkä kä yaakki. ");
INSERT INTO jum_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ïkïïn müürïnaan cääyïn yiil jï ḍïïkïn päk witken aŋ wääna ḍeggon yeeni yuutte ñaalok ye, yeekic muure witken ḍüülï ti yeeni ti, aŋ ḍüŋjïn ïñï yeeni ti.” ");
INSERT INTO jum_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Aŋ taaji mädgen ogo, “Ïkï ḍuucu ogo ïkï bi wäätcey ogo yätkä yoono aŋ ikoon mügdonda?” Aŋ putki jï mädgen kä yaac kä lääggï ke jiik yeeke. ");
INSERT INTO jum_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Aŋ Yuucip läkkä lääggï yakkalaŋ aŋ nüütkene mädgen aŋ jaajjin ogo, “Tiiŋe ika läkkä lääggï yakkalaŋ. Äŋ ke paan ke kiṭṭäni kä caay wiñen kä keelok ḍüŋjïn ïñï ika ti.” ");
INSERT INTO jum_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Aŋ wääna nüütkeneeda wäyen ke mädgen ye, ike geri wäyen aŋ kiinne ogo, “A lääggï yaaka wali ye ika läkkii kä yaakka? Ïkï paydä ogo ika ke miic ke mädgic äätoon aŋ ḍüŋjoon ïñï ïkï ti?” ");
INSERT INTO jum_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Aŋ mämgï jï mädgen aŋ wäyen jiik yaakka tïïññe jone ti. ");
INSERT INTO jum_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Aŋ mädgen attä kääjï ḍiik wäyen Cakïïm kä cokal. ");
INSERT INTO jum_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Aŋ Yaagüüp Yuucip kiinne ogo, “Ika ṭäkä ïkï atä Cakïïm nänṭä yaana kääjene mädgic ḍiik ye.” Aŋ luugi Yuucip ogo, “Ŋeraŋ wäyo.” ");
INSERT INTO jum_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Aŋ kiini wäyen ogo, “Atä tiññaaŋŋi naana iken ke ḍiik cäyok ṭeṭaŋ ye, i ḍuuku aŋ nüütkaa jiik.” Aŋ tucce woo ḍääñgon yen mä Hiburoon jï nänṭ'a cääyene kä ye, aŋ ike attä Cakïïm. ");
INSERT INTO jum_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Aŋ kañi oon yaŋkalaŋ wiñe a ḍïïktïnï woo käpet, aŋ taaji oon ogo, “Ïkï määjä ŋaaka?” ");
INSERT INTO jum_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Aŋ luuŋŋe ogo, “Ika määjä mädgo. Kura nüütkaa nänṭä yaana kääjene kä ḍiik ye.” ");
INSERT INTO jum_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Aŋ oon jaajjin ogo, “Iken baŋŋä, iken tiiŋŋä jayok ogo, ‘Juwe atïn Duutaan.’” Aŋ Yuucip bäätcin mädgen ti, aŋ kaññe Duutaan. ");
INSERT INTO jum_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Aŋ yooṭi kä utar, aŋ i batta mor ḍägä ti iken ti kä cokal, iken lääljin pugin ogo nägjï ḍok. ");
INSERT INTO jum_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Aŋ iken luugjin pääken ogo, “Yooṭe män lääggï ïya äätä. ");
INSERT INTO jum_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Juwe näkïn ḍok aŋ yeepïn ïñï jïïn kalaŋ jï, aŋ ïkïïn jaaccïn ogo, ‘Ammïï gin kurkuŋgu yaŋkalaŋ.’ Aŋ ïkïïn bi yüṭïn a ŋaaka ken bi äbänä lääggï yeeke.” ");
INSERT INTO jum_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Aŋ wääna Robïïn tiiŋŋee kä aŋan ye, ike puccin ogo Yuucip määgee woo aŋ jaajjin ogo, “Ŋana näkïn ḍok.” ");
INSERT INTO jum_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Aŋ Robïïn jaajjin ogo, “Ŋana yïmge püükïtïn woo, ääte yeepïn jïïdük woo teettälaŋ winni, ŋana ïnko äccïtïn ike ti.” Aŋ Robïïn jaajjin kä waŋ yaana ṭäkee määgedeeda woo iken ti, aŋ tuce ŋäjäk wäyen ti ye. ");
INSERT INTO jum_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Aŋ wääna Yuucip ḍäägenee kä ti mädgen ti ye, i gütï yokïn woo kä burŋu yaana ŋeraŋ eŋde yaanna. ");
INSERT INTO jum_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Aŋ koowi aŋ yeepi jïïdük. Aŋ jïïn jïñe a ïwon kä piik. ");
INSERT INTO jum_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Aŋ wääna cääjjene ïñï ämene kä ye, iken däämjin woo aŋ yurcin yääjoni a yek mä Icämayiil ätä ŋommañ mä Jïlaat ti, ke kälämgä yeeken ḍürït ḍuk yaaka a päkkiṇṇi ye ke yek pïlkä äcä Macïr. ");
INSERT INTO jum_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Aŋ Yahüüja mädgen taaññe ogo, “A ŋaaka ken bi kañïn naana määdo näŋŋïn ḍok ye, aŋ yïmge paannïn yokïn ye? ");
INSERT INTO jum_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Juwe yääckïn mä Icämayiil, aŋ ïnko ŋana äccïtïn ike ti, ike a määdo aŋ a yïmgä yooko.” Aŋ Yahüüja tiiŋgi mädgen. ");
INSERT INTO jum_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Aŋ wääna yääjoni yek mä Icämayiil kaajdene kä ye, i Yuucip äbi woo mädgen jïïdük, aŋ yääjgi mä Icämayiil tiilgä gälkä waŋgen caykä kä yew. Aŋ Yuucip iji Macïr. ");
INSERT INTO jum_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Aŋ wääna Robïïn ḍukcenee kä jïïdük, aŋ Yuucip batta agee kä kañgon kä ye, ike buruŋgu yeeke jiiññe gïtï kä nüüjdüŋ. ");
INSERT INTO jum_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Aŋ ḍukcin mädgen ti, aŋ kiinne ogo, “Yuucip baati jïïdük, aŋ ika bi näŋjä ogoo?” ");
INSERT INTO jum_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Aŋ iken burŋu Yuucip koowi aŋ iṭṭä ñooŋ, aŋ burŋu büücï ti yïmgä gïtï. ");
INSERT INTO jum_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Aŋ iken burŋu ŋerrä äcki wäyen aŋ kiini ogo, “Yooru gin'a kaññon ye. Yaanni batta a burŋu yen minneni yüünü?” ");
INSERT INTO jum_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Aŋ ŋïjï Yaagüüp, aŋ jaajjin ogo, “A burŋu minneni yeeni. A amgon kä gin kurkuŋgu yaajgonḍe yaŋkalaŋ. Minneni yeeni jiijtin gïtï aŋŋa pïlkä.” ");
INSERT INTO jum_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Aŋ Yaagüüp buruŋgu yeeke jiiññe gïtï aŋ iiŋcin cuukul teye ti nüütï nüüjdüŋ yeene, aŋ nüüññü kä minneni yeene nïïnkä kä ḍiräk. ");
INSERT INTO jum_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Aŋ merkä yeeke oogen ke ṭulgu yeeke äätin ike lüüytü jok, aŋ ike yaakkä kä lüüynü jok, aŋ jaajjin ogo, “U'u ika bi ceeñä kä nüüjdüŋ ke ḍakä ti minneni yeeni ti käälok.” Aŋ wäyen weeŋŋä kä ike kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Aŋ wina mä Icämayiil Yuucip yääjgi Poṭïpaar Macïr. Ike a ḍuuŋgon kääygä yen yätkä Parahuun yaana a ḍuuŋgon tïïconi ye. ");
INSERT INTO jum_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Aŋ waan yaanja ti Yahüüja mädgen daljene ïñï, aŋ attä cääynä ke oon mä Adalaam yaŋkalaŋ battä me ogo Ïïra. ");
INSERT INTO jum_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Aŋ wïca Yahüüja yuṭṭu ṭuul mä Kanaan wäyen battä me ogo Cüwa aŋ ḍeyne. Aŋ wääna nïïnnene kä ye, ");
INSERT INTO jum_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","i ike laaccä aŋ giiṇṇä minneni oone, aŋ äkkene yäṇtäŋ ogo Eer. ");
INSERT INTO jum_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Aŋ ŋuccin laaccä aŋ giiṇṇä minneni oone, aŋ äkkene yäṇtäŋ ogo Unaan. ");
INSERT INTO jum_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Aŋ giiṇṇä minneni oone menen ŋuca, aŋ äkkene yäṇtäŋ ogo Cïïla. Aŋ waan yaana gittene me Cïïla ye, i iken cäyok Kaajïïp. ");
INSERT INTO jum_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Aŋ Yahüüja kaygon yeene Eer ḍijgene iiŋ battä me ogo Taamaar. ");
INSERT INTO jum_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Aŋ Eer kaygon Yahüüja yaajaŋ Pïṭo ñome ti, aŋ nägi ḍok Pïṭo. ");
INSERT INTO jum_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Aŋ Yahüüja Unaan kiinne ogo, “Atä aŋ iŋ määdic yädä, aŋ ḍääkä ñuugula yüünü ike ti bata oore keelle, äckii kä woo määdic merkä.” ");
INSERT INTO jum_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Aŋ ŋäjjänä Unaan minneni yaanna batta bi wäätï a yeene. Naana daa nïnok ke iŋ määden ye, i daa yïmgä pooke ïñï ŋomgu gïtï nuŋko ŋana määden käñdee ko kilkä. ");
INSERT INTO jum_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Aŋ yaaka naŋŋe yaakka a yiñ Pïṭo ñome ti, aŋ näŋŋe ḍok cäänna. ");
INSERT INTO jum_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Aŋ Yahüüja iŋ minneni yeene Taamaar kiinne ogo, “Cääyä agä boro paa ba' wääc ke minneni yeeni Cïïla täle.” Ike ḍüücï ogo, “Ike bi tüwje cäänna bata mädgen.” Aŋ Taamaar attä cääynä paa ba' wäyen. ");
INSERT INTO jum_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Aŋ yuungu yakkalaŋ ti Yahüüja iiŋe tüwnü, aŋ wääna ḍaŋŋee kä waan nüüjdüŋ ye i ike ke muukonḍe Ïïra yen Adalaam attene Tïmna nänṭä yaana ŋitene me käbälgä yeeke ye. ");
INSERT INTO jum_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Aŋ mäŋkalaŋ Taamaar nüütkene ogo daan wäyen ato Tïmna ŋito käbälgä. ");
INSERT INTO jum_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Aŋ wina buruŋgu borkïtïn yaaka eŋde ye gütte woo aŋ waŋge kümme kä burŋu yaana kümdene me waŋgen ye, aŋ cääjjin päy tük Anaayim baan mooye yaana päy jï Tïmna ye. Aŋ ŋäjje ṭeṭaŋ Yahüüja minneni yeene Cïïla tällä aŋ batta por kujgeeda. ");
INSERT INTO jum_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Aŋ wääna yoorene daa Yahüüja ye ike ḍüücï ogo ṭuul yaana ogo baal ye nääŋka waŋge agee kä kümgïn ye. ");
INSERT INTO jum_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Aŋ umgi ti Yahüüja kä päy taaŋŋe ti aŋ kiinne ogo, “Äätä nïïnï.” Aŋ kuje ogo iŋ minneni yeene. Aŋ taaji iiŋ ogo, “Ika bi iñja ŋaaka naana ïkïï nïïnnï ye?” ");
INSERT INTO jum_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Aŋ luugi Yahüüja ogo, “Ïkï bi tuckeni jüülole ḍiik yeeki ti.” Aŋ kiini iiŋ ogo, “Naana ye iñja ginkalaŋ dalä tïïjä bata luggin ke tuucii ḍeel.” ");
INSERT INTO jum_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Aŋ taaji Yahüüja ogo, “A luggin yaana wali ye ken iñenii?” Aŋ luugi iiŋ ogo, “Iñja baacbaac ke dira yeene ke lacan yaana ïntü ti yaanna.” Aŋ iñene daa Yahüüja aŋ nïïnnene kä aŋ laaccä. ");
INSERT INTO jum_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Aŋ Taamaar juwin kaaccä woo aŋ burŋu yaana eŋde waŋge ti ye gütte woo, aŋ iiŋcin buruŋgu borkïtïn. ");
INSERT INTO jum_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Aŋ Yahüüja tuccin müükonḍe Ïïra ogo jüülole ijje iiŋ ti, aŋ waak'a koownïï iiŋ ogo yek luggin ye äbee. Aŋ batta a kañgon kä Ïïra. ");
INSERT INTO jum_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Aŋ ike tääccin ook yakkalaŋ ti yek mä Anaayim ogo, “Wali iiŋ yaana a baal cääy päy taaŋ winni ye?” Aŋ luugi ogo, “Baati iiŋ yaana a wääton a baal winni ye.” ");
INSERT INTO jum_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Aŋ ike ḍukcin Yahüüja ti aŋ kiinne ogo, “Iiŋ batta agä kañgon. Aŋ ook yaaka nänṭä yaanja ti ye, jayok ogo iken batta cääygïda ko iiŋ yaana ogo baal wïca ye.” ");
INSERT INTO jum_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Aŋ kiini Yahüüja ogo, “Dalä waak yaaka iññä daa kä ye tïïje. Ikoon batta ṭäkon mä baan ikoon yirkoton, ika tuccunu ogo iiŋ iñjo jüülole, aŋ batta agii kä kañgon.” ");
INSERT INTO jum_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Aŋ pankä kä ḍäk mäŋkalaŋ äätin Yahüüja ti aŋ ike kiini ogo, “Taamaar iŋ minneni yüünü nääŋä nääŋka batta päjjïdï ye, ike a laacon kä balkïtïn.” Aŋ Yahüüja iinjin ogo, “Äbe woo, aŋ nääkke maañ dale tüw.” ");
INSERT INTO jum_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Aŋ wääna ike äbene daa me woo ye, i ike tuccin jiik daan wäyen ti jaay ogo, “Ika laacana kä oon yaana a män waak yaakki ye. Yooru waak yaakki a yek ŋaani, baacbaac ke dira yeene ke lacan?” ");
INSERT INTO jum_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Aŋ ŋïjï Yahüüja aŋ jaajjin ogo, “Ike ḍoŋe ladaŋ, a ika ken nääŋkä yällä, nääŋka ike batta agä kä iñgon minneni yeeni Cïïla ye.” Aŋ Yahüüja batta a nïïnïn ke ike ŋuca. ");
INSERT INTO jum_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Aŋ wääna waan yen giidä yeene ḍäägenee kä ye, i ŋïjï a yuunku jïñe ti. ");
INSERT INTO jum_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Aŋ wääna giidee kä ye, i minneni yaŋkalaŋ ïṇte äbene woo, aŋ gito kuññu wiṇṇanle tïṇṇä aŋ ḍekke ïṇte ti aŋ jaajjin ogo, “Yaanni kääjïdï woo ñomuk.” ");
INSERT INTO jum_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Aŋ wina ïṇte ḍuukke ti, aŋ määden ïïjïn kääjin woo! Aŋ gito jaajjin ogo, “Ïkï ïïjïnï kääjini woo ogoo?” Aŋ äkki me yäṇtäŋ ogo Paaric. ");
INSERT INTO jum_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Aŋ määden giidi me ke wiṇṇanle tïṇṇä ïṇte ti, aŋ äkki me yäṇtäŋ ogo Jüra. ");
INSERT INTO jum_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Aŋ Yuucip koowi mä Icämayiil aŋ iji Macïr, aŋ kiyi män Macïr yaŋkalaŋ battä me ogo Poṭïpaar a ḍuuŋgon kääygä yen yätkä Parahuun yaana a ḍuuŋgon yen tïïconi ye. ");
INSERT INTO jum_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Aŋ Pïṭo ke Yuucip aŋ naŋŋe a oon yaana woodit ye, aŋ cääy än yen mügdo yeene ti, yaana a män Macïr ye. ");
INSERT INTO jum_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Aŋ yoori mügdo yeene Pïṭo ke ike, aŋ waak'a naŋde ye ti muure, i iñtä Pïṭo wooddin. ");
INSERT INTO jum_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Aŋ Yuucip käññä ŋerrä mügdo yeene ti, aŋ naŋŋe a ñuugulo yeene yaana tïïlcïdï ye, aŋ ḍoocce a m'ana tïïcï wakkä än yeene jïñe muure ye. ");
INSERT INTO jum_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Aŋ waan yaana ḍoocceeda kä a tïïco än yeene jïñe muure ye, i Pïṭo män Macïr ŋüülkene kä Yuucip. Aŋ ŋüülkïn Pïṭo äätin ke wakkä yeeke ti muure äräk ke yiil jï. ");
INSERT INTO jum_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Aŋ wakkä yeeke muure müükkene Yuucip tïïje. Aŋ kä mügdïn Yuucip, ike batta payit gin kalaŋ, daa a ammani yaaka ame ye pääken. Aŋ Yuucip a men ŋerconḍe biilke ti ke üükïnene woo ti. ");
INSERT INTO jum_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Aŋ waan kalaŋ ti iŋ mügdo yen Yuucip waŋe nïïnjïn Yuucip ti, aŋ jaajjin ogo, “Äätä nïïnï.” ");
INSERT INTO jum_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Aŋ Yuucip yaakkä aŋ iŋ mügdo yeene kiinne ogo, “Yooru, mügdo yeeni ika müükkana waak muure yaaka än jï ye, aŋ batta payit gin kalaŋ. ");
INSERT INTO jum_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Baati mäŋkalaŋ yaana cääyge mügdïn winni bata ika ye, aŋ baati gin'a agee kä paangon yokïn ika ti ye, a ïkï parü, nääŋka agii kä iiŋe ye. Aŋ ika näŋä yiñ mooye yaanna Jooŋ ñome ti ogoo?” ");
INSERT INTO jum_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Aŋ iiŋ daa Yuucip tajde kamat kamat, aŋ ike yaakkä aŋ batta a nïïnon ke iiŋ aŋ batta cääy kä cokal ike ti ŋuca. ");
INSERT INTO jum_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Aŋ nïïnnä yaŋkalaŋ ti wääna Yuucip kaaccee kä äräk ñuugulee ye, i ñuuguloni yakkalaŋ yek än baati. ");
INSERT INTO jum_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Aŋ Yuucip mügï iiŋ kä burŋu yeene, aŋ kiini iiŋ ogo, “Äätä nïïnï!” Aŋ Yuucip buuṭin woo äräk aŋ burŋu yeene daljene ti iiŋ ïṇte ti. ");
INSERT INTO jum_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Aŋ wääna yoorene daa iiŋ burŋu daljeneeda ti ïṇte ti aŋ buuṭenee woo äräk ye, ");
INSERT INTO jum_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","i iiŋ ñuuguloni yek än bärkene ti, aŋ kiinne ogo, “Yoore män Iburu yaana äbi oon yeeni än ti ye, ïkïïn ñääyïn kä yokïn. Ike äätin än yeeni jï ogo ika nïïnjada, aŋ ika yaajjänä kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Aŋ wääna tiiŋŋa kä yaajjänä kä yaac ye, i ike buuṭin woo äräk, aŋ burŋu yeene cakke ti ïṇtï ti.” ");
INSERT INTO jum_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Aŋ iiŋ burŋu tïïññe ke men mooye yen Yuucip ḍääge paa. ");
INSERT INTO jum_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Aŋ nüütkene jiik keelkä, aŋ kiinne ogo, “Män Iburu yaana a kiingon yüünü ickonoon kä winni yaanni äätin ika ti ogo ika ñääyjada ko yok, ");
INSERT INTO jum_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","aŋ wääna yaajjänä kä ye, i buuṭin woo äräk aŋ burŋu yeene daljene ti ïntï ti.” ");
INSERT INTO jum_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Aŋ wääna Yuucip mügdo yeene tiiŋŋee kä jiik iiŋe yaaka jaayee kä ogo, “A yaaka näŋgana kiingon yüünü ye ikki ye,” i ike pennä kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Aŋ Yuucip müŋŋe aŋ icce gaŋgar nänṭa ḍucene yätkä m'aka üüle ye, aŋ Yuucip cäynä wïca. ");
INSERT INTO jum_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Aŋ Pïṭo ke Yuucip aŋ nüütkene woo biilin yaana batta düüñïdï ye, aŋ iññe ŋerrä ḍuuŋgon yen gaŋgar ti. ");
INSERT INTO jum_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Aŋ Yuucip ḍoocce a tïïco yen m'aka gaŋgar jï ye muure, aŋ naŋŋe a tïïco yen wakkä yaaka näŋit ḍuuggen gaŋgar jï ye. ");
INSERT INTO jum_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Aŋ ḍuuŋgon yen gaŋgar batta ŋuca tïïcï wakkä yaaka tïïcä Yuucip ye, kä yaana Pïṭo ke Yuucip ye. Aŋ naŋŋe woodit waak'a naŋde ye ti muure. ");
INSERT INTO jum_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Aŋ ääŋkalaŋ ti wääna nääŋkä yaakki baakkene kä ye, i wiñ yen lijoni määk yen yätkä mä Macïr ke wiñ yen pamdoni bïggï yeene nääŋkä yili mügdo yeenen yätkä yen mä Macïr ti. ");
INSERT INTO jum_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Aŋ Parahuun pennä ḍuuŋku yeeke yaaka kä yewwe yaakka ti, wiñ yen lijo määk ke wiñ yen pamdo bïggï, ");
INSERT INTO jum_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","aŋ iken icce gaŋgar jï än ḍuuŋgon yen tïïconi nänṭ'a tïïcene Yuucip ye. ");
INSERT INTO jum_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Aŋ ḍuuŋgon yen tïïconi Yuucip ḍoocce a m'ana tïïcï iken ye. Aŋ cäygin gaŋgar jï nïïnkä kä ḍeewaŋ. ");
INSERT INTO jum_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Aŋ wïïrïn jïñe kalaŋ ti gaŋgar jï, lijo määk ke pamdo bïggï yek yätkä yen mä Macïr läkkä muuṭuk, aŋ lääggï cääyge ŋüüllen gïtï päkkit. ");
INSERT INTO jum_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Aŋ wääna Yuucip äätene iken ti kä tïṇṇäŋänä ye, yoorre juuggin yejgaŋ. ");
INSERT INTO jum_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Aŋ ḍuuŋku yek Parahuun yaaka ke ike gaŋgar jï ye, tääckene ti ogo, “Ikee nüüje ina aŋŋi tiññaŋ?” ");
INSERT INTO jum_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Aŋ iken luukcin ogo, “Ikoon läkkon lääggï aŋ baati m'ana ikoon ŋüülgon gïtï ye.” Aŋ luugi Yuucip ogo, “Ŋüüllü gïtï lääggï batta äätïdï Jooŋ ti halla? Päkka kä.” ");
INSERT INTO jum_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Aŋ wiñ yen lijoni määk lääggï yeeke päkkene Yuucip ogo, “Lääggï yeeki ti, ika yuṭṭu jaan beel bata lüütkon meen ñomi ti, ");
INSERT INTO jum_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","aŋ jaan meen cääyge kimke kä ḍäk. Aŋ kä ḍeeraŋ aŋŋi ŋiimmin aŋ päwnä gïtï, aŋ ṭulge eggin. ");
INSERT INTO jum_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Aŋ ḍonṭule Parahuun cääy ïṇtï ti, aŋ ṭulge koownu aŋ taañjänä ḍonṭule Parahuun jï, aŋ ḍonṭule ḍooccu Parahuun ïṇte ti.” ");
INSERT INTO jum_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Aŋ Yuucip jaajjin ogo, “Lääggï yaakki nüütï ogo aŋŋi, kimkä kä ḍäk a nïïnkä kä ḍäk. ");
INSERT INTO jum_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Aŋ nïïnkä kä ḍäk Parahuun wïñü bi ääre ñaalok, aŋ ïkï bi ḍuukey nänṭä ñuugula yüünü ti, aŋ ḍonṭule Parahuun bi iñjeeda kä ïṇte ti, bata wääna agii kä lijo määk ina. ");
INSERT INTO jum_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aŋ kura paydaa naana wakkä attä ṭeṭaŋ ke ïkï ye, aŋ kura ŋerci ïñï kä päjgin ŋïngïn Parahuun kä ika. Aŋ yüükkaa ti dalä ika kääjä woo gaŋgar jï. ");
INSERT INTO jum_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ika müügana me kä tïññä ŋommañ mä Iburu ti, aŋ cäänna Macïr winni ika batta agä näŋon ginkalaŋ yaana päjjïdï ḍooca me gaŋgar jï ye.” ");
INSERT INTO jum_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Aŋ wääna wiñ yen pamdoni bïggï yuṭṭee kä ŋüüllü gïtï ŋeraŋ ye, ike Yuucip kiinne ogo, “Ika cäänna daa cääyga lääggï, ika äddä arwalli wiñi ti kä ḍäk yek bïggï. ");
INSERT INTO jum_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Aŋ arwal yaana meken witken ti yaanna cääyge jï biilkä bïggï ŋerken yaaka a pämgïnï Parahuun ye, aŋ amgä ḍïïrgä arwal jï wiñi ti.” ");
INSERT INTO jum_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Aŋ luugi Yuucip ogo, “Lääggï yaakki nüütï ogo aŋŋi, arwalli kä ḍäk a nïïnkä kä ḍäk. ");
INSERT INTO jum_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Aŋ nïïnkä kä ḍäk Parahuun wïñü bi ŋülje woo, aŋ ïkï bi ŋaapey kä jaan aŋ yäŋgü bi amgä ḍïïrgä.” ");
INSERT INTO jum_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Aŋ wääna nïïnkä kä ḍäk ḍakkene ye, i äŋ jïñe jon ñamme yen giidä Parahuun ti, ike näŋŋä ammani jon ñamme näŋgene ḍuuŋkulen yeeke muure, aŋ ike wiñ yen lijoni määk bärkene ke wiñ yen pamdoni bïggï aŋ äbene ḍuuŋkulen yeeke ñomgen ti. ");
INSERT INTO jum_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Aŋ ike wiñ yen lijoni määk ḍuukke nänṭä yeene ti, aŋ ike ŋuca ḍolle ḍoocce Parahuun ïṇte ti. ");
INSERT INTO jum_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Aŋ wiñ yen pamdoni bïggï aŋ ŋaappe ñaalok kä jaan bata yaana daa kiinene daa kä Yuucip ye. ");
INSERT INTO jum_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Aŋ wiñ yen lijoni määk Yuucip batta payde aŋ wiirre. ");
INSERT INTO jum_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Aŋ wääna yuungu kä yew ḍakkene kä ye yätkä Parahuun läkkä ogo ike yuddee wii yen mä Nïïl ḍok. ");
INSERT INTO jum_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Aŋ wïca däk kä ŋaṭükel kääjin woo wii mä Nïïl jï biilken ŋeraŋ aŋ a caagin aŋ ämï biiruŋ gïtï. ");
INSERT INTO jum_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Aŋ ŋuca däk kä ŋaṭükel kääjin woo wii mä Nïïl jï biilken yejgaŋ aŋ ṭomgaŋ, aŋ yuuttu meken yaaka wii ḍok gurken ti yaakca. ");
INSERT INTO jum_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Aŋ däk yaaka biilken yejgaŋ aŋ ṭomgaŋ yaakka, däk yaaka biilken ŋeraŋ, aŋ a caagin kä ŋaṭükel yaakka ami. Aŋ Parahuun cuuyin nïïnkä ti. ");
INSERT INTO jum_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Aŋ ŋuccin oodi, aŋ ŋuccin läkkä ogo päk witken kä ŋaṭükel ḍoŋgaŋ aŋ ŋeraŋ yülü woo meen keellä ti. ");
INSERT INTO jum_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Aŋ ŋuca päk witken kä ŋaṭükel puurin woo lïwgaŋ aŋ ïïwï jommu woo teettälaŋ. ");
INSERT INTO jum_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Aŋ päk witken yaaka lïwgaŋ yaakka, meken yaaka ŋeraŋ kä ŋaṭükel ḍoŋgaŋ yaakka ladi. Aŋ Parahuun cuuyin nïïnkä ti, aŋ ŋïññe a lääggï. ");
INSERT INTO jum_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Aŋ kä tïṇṇäŋänä aŋŋi ike cuuyin wiñe a ḍïïktïnï. Aŋ ike wäädin bärkene muure yek mä Macïr ke ŋäjjoni, aŋ päkki Parahuun lääggï yeeke. Aŋ baati m'ana lïïṭït ike ŋüülkütü gïtï ye. ");
INSERT INTO jum_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Aŋ wiñ yen lijoni määk Parahuun kiinne ogo, “Yiñ yeeni paynä tiññaŋ. ");
INSERT INTO jum_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Aŋ wääna pennii kä wiñ yen pamdoni bïggï ti ke ika ina, ikoon äccoon gaŋgar än yen ḍuuŋgon tïïconi jï. ");
INSERT INTO jum_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Aŋ wïïrïn keellä ti ikoon ti daa mäŋkalaŋ cääyge lääggï, aŋ lääggï yaŋkalaŋ cääyge ŋüüllen gïtï a pare. ");
INSERT INTO jum_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Aŋ wïca durñu yen mä Iburu kalaŋ ke ikoon gaŋgar jï, ike a ñuugulo yen ḍuuŋgon tïïconi. Aŋ wääna nüütkonon daa kä lääggï yooko ye, i ŋüülgonon kä gïtï. Aŋ mäŋkalaŋ daa lääggï yeeke ŋüülgeneeda kä gïtï. ");
INSERT INTO jum_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Aŋ daa wäättä bata yaana daa ŋüülgonon kä gïtï ye, ïkï ika ḍuukkaa nänṭä yeeni ti, aŋ wiñ yen pamdoni bïggï ŋaappi ñaalok.” ");
INSERT INTO jum_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Aŋ Parahuun Yuucip bärkene aŋ äbi me woo gaŋgar jï kä bïraŋ. Aŋ jiike ŋette woo, aŋ ääkcin buruŋgu, aŋ äätin Parahuun ñome ti. ");
INSERT INTO jum_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Aŋ kiini Parahuun ogo, “Ika cääyga lääggï, aŋ baati m'ana ika ŋüülga gïtï ye. Tiiŋŋä me jayok kä ïkï ogo naana ïkï tiiŋŋeey lääggï ye, i lïïljey ŋüüljey gïtï.” ");
INSERT INTO jum_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Aŋ Yuucip Parahuun luuŋŋe ogo, “Batta a ika a Jooŋ ken ïkï bi iñey luuŋŋu ŋïïbbïn jonü ti.” ");
INSERT INTO jum_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Aŋ Parahuun Yuucip kiinne ogo, “Lääggï yeeki ti ika yuddu wii yen mä Nïïl ḍok, ");
INSERT INTO jum_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","aŋ wïca däk kä ŋaṭükel kääjin woo wii mä Nïïl jï a caagin aŋ biilken ŋeraŋ aŋ ämï biiruŋ gïtï. ");
INSERT INTO jum_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Aŋ ŋuca däk kä ŋaṭükel kääjin woo bämaŋ aŋ biilken yejgaŋ kä yaac aŋ ṭomgaŋ. Aŋ däk yaacken bata yaakka aŋan batta agä yoorgin ŋommañ mä Macïr jï. ");
INSERT INTO jum_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Aŋ däk ṭoomken yaacken, däk caakken yaaka kä ŋaṭükel ïïjïn woo yaakka ami. ");
INSERT INTO jum_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Aŋ wääna meken amene daa ye, batta ŋïctä me ogo ämin meken, kä yaana iken iiñcete biilken yejgene yejok bata wääna ina, aŋ ika cuuynu. ");
INSERT INTO jum_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Aŋ ika cäänna yuṭṭu lääggï yeeki ti päk witken kä ŋaṭükel yülü woo meen keellä ti, ḍoŋgaŋ aŋ ŋeraŋ. ");
INSERT INTO jum_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Aŋ ŋuca päk witken kä ŋaṭükel puurin woo lïwgaŋ aŋ ïïwï jommu woo teettälaŋ. ");
INSERT INTO jum_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Aŋ päk witken yaaka lïwgaŋ yaakka, meken yaaka kä ŋaṭükel ŋeraŋ ye ladi. Aŋ päkkänä wäädin aŋ baati yaana ika ŋüülgada gïtï ye.” ");
INSERT INTO jum_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Aŋ Yuucip Parahuun kiinne ogo, “Lääggï yüükü a keelok. Aŋ Jooŋ ïkï nüütkeney gin'a bi naŋe ye. ");
INSERT INTO jum_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Däk ŋerkä yaaka kä ŋaṭükel yaakka a yuungu kä ŋaṭükel, aŋ päk witken yaaka kä ŋaṭükel ye a yuungu kä ŋaṭükel. Aŋ lääggï a yek keelkä. ");
INSERT INTO jum_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Aŋ däk ṭoomken yaaka biilken yejgaŋ kä ŋaṭükel yaaka kääjin woo meken ŋätin yaakka, a yuungu kä ŋaṭükel. Aŋ päk witken yaaka kä ŋaṭükel waŋgen baati yaaka ïïwï jommu mä teettälaŋ yaakka, cäänna a yuungu kä ŋaṭükel yek käñ. ");
INSERT INTO jum_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Bata yaana nüütkenenii kä ye, Jooŋ ïkï nüütkeney gin'a bi naŋe ye. ");
INSERT INTO jum_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Aŋ yuungu kä ŋaṭükel burru mooye bi ätä ŋommañ mä Macïr jï muure. ");
INSERT INTO jum_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Aŋ wäättan yuungu kä ŋaṭükel käñ bi ätä, aŋ burru mooye yaanna bi wiirgä me Macïr jï, aŋ käñ baan bi ḍüüme gïtï. ");
INSERT INTO jum_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Aŋ burru mooye bi wiirgä me baan jï kä yaana käñ yaana äätïdï ye bi yaajee kä yaac ye. ");
INSERT INTO jum_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ŋoccin gïtï lääggï yüükü yaakka a yuutin kä Jooŋ, aŋ bi naŋe kä bïraŋ. ");
INSERT INTO jum_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Aŋ tiññaŋ dalä ïkï wäkä oon yaana a yuṭo aŋ a ŋäjjo ye, aŋ ḍoocci a tïïco yen ŋommañ mä Macïr. ");
INSERT INTO jum_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Aŋ cäänna wäkä ḍüṭoni kujit kä keelok duuc ti yek giidä ŋommañ mä Macïr yuungu yaaka kä ŋaṭükel a yek burru mooye yaakka ti. ");
INSERT INTO jum_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Aŋ dalä iken päk muure ḍülgü yuungu ŋerken yaaka äätä yaakka ti, aŋ ḍoocunu mügdïn yüünü ti, aŋ ḍoocunu me bänkä mäyken gïtï aŋ tïïcä me wäätï a ammani. ");
INSERT INTO jum_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Aŋ päk yaakka bi ḍoocunu me a yek baan, kä yuungu yaaka äätä kä ŋaṭükel a yek käñ Macïr jï ye, nuŋko ŋana baan ḍüümte daa gïtï käñ ye.” ");
INSERT INTO jum_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Aŋ waŋ yaanna Parahuun ke ḍuuŋkulen yeeke muure ñaappe juuggin. ");
INSERT INTO jum_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Aŋ Parahuun ḍuuŋkulen yeeke taaññe ogo, “Ïkïïn bi käñïn oon bata yaanni aŋŋi, yaana cääyge wääktäŋ Jooŋ ye?” ");
INSERT INTO jum_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Aŋ Parahuun Yuucip kiinne ogo, “Baati m'ana a yuṭo aŋ a ŋäjjo bata ïkï aŋŋi ye, kä yaana Jooŋ nüütkeney kä waak yaakka muure ye. ");
INSERT INTO jum_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Aŋ ïkï bi ḍooceni tïïcä nänṭä yeeni, aŋ mä yeeki muure ïkï bi tiiŋkiti eennä yüünü. Aŋ a ika pari ken bi tälätäl ïkï ti kä yaana agä yätkä ye. ");
INSERT INTO jum_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Tiññaŋ ïkï waŋŋeni agä men mooye ŋommañ mä Macïr jï muure.” ");
INSERT INTO jum_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Aŋ Parahuun baacbaac yen tiikonle yeene äbene woo ïnte ti aŋ iiŋkene Yuucip ïnte ti, aŋ iiŋkene burŋu ŋerconḍe yeene aŋ dira tiilgä iiŋkene Yuucip ḍoŋe ti. ");
INSERT INTO jum_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Aŋ taappe teebälaŋ bagal yeene ti yaana bäätcïdï mügdïn yeene ti ye, aŋ me yaajjin ogo, “Ḍüŋje ïñï!” Aŋ ḍoocce a mügdo Macïr jï muure. ");
INSERT INTO jum_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Aŋ Parahuun Yuucip kiinne ogo, “Ika agä Parahuun, baati m'ana bi ïṇte ke kïye ääre ñaalok ŋommañ mä Macïr jï muure ye, naana ïkï batta agä jaajjïnï ye.” ");
INSERT INTO jum_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Aŋ Parahuun Yuucip iññe yäṇtäŋ mä Macïr ogo Capanaatpaniya, aŋ iññe iiŋ battä me ogo Acanaat ṭuulle Patipeera män daaŋ yen mä Uun. Aŋ Yuucip ŋommañ mä Macïr müŋŋe muure. ");
INSERT INTO jum_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Aŋ Yuucip yuunge caykä kä ḍäk wääna kaacce kä ñuugula yen yätkä Parahuun yen mä Macïr ti ye. Aŋ Yuucip aŋgin yore Parahuun ñome ti, aŋ attä laaynä ŋommañ mä Macïr jï muure. ");
INSERT INTO jum_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Aŋ yuungu kä ŋaṭükel yek burru yaakka ti ŋommañ giiṇṇä kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Aŋ Yuucip päk ḍüülene ti muure yek yuungu kä ŋaṭükel yaaka kääjin woo ŋommañ mä Macïr jï ye. Aŋ päk ḍoocce bänkä mäyken gïtï. Aŋ baan mooye kalaŋ daa ḍuckene jï päk yirkä yaaka gurke ti ye. ");
INSERT INTO jum_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Aŋ Yuucip kuuttu päk kä ḍiräk bata ṭiŋal yek wii jïñe, ke yuutee ïñï kä paŋŋä, kä yaana batta lïïlte daa me kä paŋŋä ye. ");
INSERT INTO jum_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","I yuungu käñ batta mor ḍägä, Yuucip gitki Acanaat merkä oogen kä yew ṭuulle yen Patipeera män daaŋ yen mä Uun ti. ");
INSERT INTO jum_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Aŋ Yuucip kaygon yeene äkkene ogo Manacca. Aŋ ike jaajjin ogo, “A yaana Jooŋ naŋŋa kä pillä yeeni muure wiirrä daa kä ke äntüke wäyo muure ye.” ");
INSERT INTO jum_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Aŋ Yuucip minneni yaana bäätcïdï ye, äkkene ogo Ipiraayim. Aŋ jaajjin ogo, “A yaana Jooŋ ika naŋŋa giidä kä yaac baan yaana wääccä kä jï pillä ye.” ");
INSERT INTO jum_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Aŋ yuungu kä ŋaṭükel yek burru yaaka äätin ŋommañ mä Macïr jï ye düüñïn, ");
INSERT INTO jum_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","aŋ yuungu kä ŋaṭükel yek käñ mooye uccin kä äätin bata yaana jaaynene daa Yuucip ye. Aŋ käñ wäättä bänkä gïtï muure, aŋ a ŋommañ mä Macïr pare ken cääyge päk. ");
INSERT INTO jum_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Aŋ wääna mä Macïr näkkene daa käñ ye, iken yaajjin Parahuun ti ogo päk. Aŋ Parahuun mä Macïr muure kiinne ogo, “Ate Yuucip ti aŋ gin'a kiine kä ye i naŋe.” ");
INSERT INTO jum_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Aŋ käñ tällä baan jï muure, aŋ Yuucip tuucku muure kupkene, aŋ yääjgede mä Macïr. Aŋ käñ yaaññä Macïr jï muure. ");
INSERT INTO jum_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Aŋ mä bänkä muure äätin Macïr Yuucip ti kïjï päk kä yaana käñ yaaññee ŋommañ wic muure ye. ");
INSERT INTO jum_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Aŋ wääna Yaagüüp tiiŋŋee kä ogo päk bilto ti Macïr ye, i merkä yeeke kiinne ogo, “Ikee däämme ina? ");
INSERT INTO jum_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ika tiiŋŋä ogo päk bilto ti Macïr. Ate ïñï wïca aŋ kiije päk yaaka ütïn kä ye nuŋko ŋana tüwtïn kä.” ");
INSERT INTO jum_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Aŋ Yuucip mädgen yaaka kä caay ye attä Macïr kïïjïdï päk, ");
INSERT INTO jum_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","aŋ Yaagüüp Benyamïïn, Yuucip määden batta agee kä tucon ke meken, booc nuŋko ginkalaŋ näŋit ḍoŋe ike ti. ");
INSERT INTO jum_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Aŋ merkälen Yaagüüp ḍakkä ti ke meken Macïr kïjï päk, kä yaana käñ biltee kä ti ŋommañ mä Kanaan ye. ");
INSERT INTO jum_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Aŋ a Yuucip ken a mügdo yen mä Macïr. Aŋ ike yääjgïdï mä baan muure päk. Aŋ Yuucip mädgen äätin, aŋ ḍüŋjïn ïñï ike ti ŋommañ jï. ");
INSERT INTO jum_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Aŋ Yuucip mädgen yoorre aŋ ŋïññe, aŋ täkkene bata m'ana a pare ye, aŋ rütkene ŋïngïn tajde ogo, “Ikee ääte wa?” Aŋ iken jaajjin ogo, “Ikoon ääton ŋommañ mä Kanaan ti kijon päk.” ");
INSERT INTO jum_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Aŋ Yuucip mädgen ŋïññe, aŋ ike batta agene kä ŋïcon. ");
INSERT INTO jum_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Aŋ Yuucip päjjin lääggï yeeke yaaka läkkee kä ogo iken ye. Aŋ iken kiini Yuucip ogo, “Ikee age mä jommu! Aŋ ikee äätene dääme ellä baan yoono!” ");
INSERT INTO jum_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Aŋ iken luukcin ike ti ogo, “U'u mügdo, kiinkä yüükü äätin kïjï päk. ");
INSERT INTO jum_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ikoon muuronaan agon merkä män keellä. Ikoon agon me wotken. Kiinkä yüükü batta a mä jommu.” ");
INSERT INTO jum_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Aŋ kiinne ogo, “U'u a ellä yen baan yoono ken umgene daame.” ");
INSERT INTO jum_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Aŋ iken jaajjin ogo, “Ikoon kiinkä yüükü agon mädin caay witken kä yew merkä män keellä ŋommañ yen mä Kanaan ti, aŋ tiññaŋ määdo ḍeerconḍe bilti cääy ke wäyo aŋ yaŋkalaŋ a yääyon.” ");
INSERT INTO jum_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Aŋ iken kiini Yuucip ogo, “Bata yaana kiinne kä ye ikee age mä jommu. ");
INSERT INTO jum_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Aŋ kä yaanni ikee puuce, ikee lïïtke kä yäṇtäŋ Parahuun, ikee batta bi kaace woo nänṭä yaanni ti ke määdic ḍeerconḍe ääte winni. ");
INSERT INTO jum_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tucce men kä keelok ikee ti aŋ dale ike atï määdic äbe i ikee kalaŋ age gaŋgar jï winni, nuŋko ukcon kä gïtï jiik yeekic naana ikee jaaye a gïtken ye. Naana batta gïtken ye, ikee lïïtke kä yäṇtäŋ Parahuun, ikee age mä jommu.” ");
INSERT INTO jum_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Aŋ ḍoocce muure gaŋgar jï, aŋ nääkin nïïnkä kä ḍäk. ");
INSERT INTO jum_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Aŋ nïïnnä ḍäk iken kiini Yuucip ogo, “Yaanni naŋe aŋ ikee bi üde, kä yaana booju kä Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Aŋ naana ikee age mä wotku ye, dale määdic yaŋkalaŋ cääy gaŋgar jï winni, aŋ ikee yakkalaŋ ate paa äce päk äärgä yeekic tüggen yaaka näkä käñ ye ti. ");
INSERT INTO jum_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Aŋ määdic ḍeerconḍe äckakä nuŋko jiik yeekic ŋïce daa me agene gïtken, nuŋko ŋana tüwde kä.” Aŋ iken yaakka gïmgï. ");
INSERT INTO jum_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Aŋ iken luugjin ogo, “A gïtken jooññu yaanni kaññïn kä gin'a näŋgïnïn määdo Yuucip ina. Ïkïïn yüṭṭïn pillä yäwconḍe yeene wääna ñujee ïkïïn ti yüükkïn ti, aŋ batta agïn yüükkïnï ti. Ina ken pillä yaanni wäättee kä ïkïïn ti yaanna.” ");
INSERT INTO jum_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Aŋ Robïïn luukcin ogo, “Ikee batta kolle ogo ŋana minneni näŋgede yiñ? Aŋ ikee batta tiŋde. Tiññaŋ yïmgä yeeke ken ikki joocïn kä me yaakki.” ");
INSERT INTO jum_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Aŋ batta ŋäjjänä ogo jiiken ookcïdïï gïtï Yuucip, nääŋka ike jaay kä aŋ jiik yeeke ŋüülge daa gïtï kä mäŋkalaŋ ye. ");
INSERT INTO jum_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Aŋ ike ñome ṭukke woo iken ti aŋ jujjin kä ïwok, aŋ wääna ḍaŋŋee kä ïwok ye, i ñome ṭuugene ti iken ti aŋ jaaynene ŋuca, aŋ Camoon koowne aŋ ḍiiŋŋe ñomgen ti. ");
INSERT INTO jum_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Aŋ Yuucip kiinkä yeeke iingene ogo kücümgü ook yaakka küümgïï ko päk, aŋ oon yaŋkalaŋ daa tiil yeeke ḍüükcï kücam yeene jï, aŋ ïñjï wakkä äämkä yek päy jïñe. Aŋ yaakka näŋgene daa kä me. ");
INSERT INTO jum_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Aŋ wäättan iken tüürüŋŋï yeeken kuucki ŋätkin päk yeeken aŋ attä. ");
INSERT INTO jum_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Aŋ nänṭä yaana yuuttene ïñï nïïnene kä ye, yaŋkalaŋ kücam yeene kupkene ogo tüürüŋ yeene äämgee, aŋ tiil yeeke kaññe kücam tük. ");
INSERT INTO jum_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Aŋ mädgen kiinne ogo, “Yuure tiil yeeki a ḍuukin ti, ikki kücam jï.” Aŋ iken juuggen yejgin aŋ yoken tïïcïn aŋ luugjin ogo, “A ŋaaka ken naŋi Jooŋ ïkïïn ti aŋŋi?” ");
INSERT INTO jum_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Aŋ wääna iken ḍakkene ti wäyen Yaagüüp ti ŋommañ mä Kanaan ti ye, wäyen nüütkï waak'a näŋŋä ḍuuggen iken ti ye muure ogo, ");
INSERT INTO jum_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Oon yaana a men mooye yen mä baan yaanja ye, ikoon rüüṇṇon ŋïngïn, aŋ ikoon käkkonon witin ogo ikoon agjon mä jommu yek baan yeenen. ");
INSERT INTO jum_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Aŋ kiinnon ogo, ‘Ikoon agon me wotken, ikoon batta agon mä jommu. ");
INSERT INTO jum_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ikoon mädin agon caay witken kä yew, aŋ wäyo a keelok, aŋ keelok a yääyon, aŋ ḍeerconḍe a paa ke wäyo ŋommañ mä Kanaan ti.’ ");
INSERT INTO jum_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Aŋ men mooye yen mä ŋommañ yaanja ikoon kiinnon ogo, ‘Aŋŋi ken bi ŋäjje kä ogo ikee agje me wotken. Määdic keelok dalje ïñï ika ti winni, aŋ kuje päk ije äcke äärgä tüggen yeekic yaaka näkä käñ ye ti. ");
INSERT INTO jum_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Aŋ määdicle äcka kä, nuŋko ŋäjje kä ogo ikee batta agje mä jommu, aŋ ogo mä wotken. Aŋ wäättan määdic ḍuukke kä, aŋ ikee bi kije aŋ yääje wakkä baan jï kä tettä.’” ");
INSERT INTO jum_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Aŋ wääna kücümgü yeeken pukte daa kä ye, iken muure yaŋkalaŋ daa ḍeggon yeene yen tiil bilti kücam yeene jï. Aŋ wääna iken ke wäyen ḍïïggï tiil yoorene daa ye, i iken bojgin. ");
INSERT INTO jum_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Aŋ iken kiini wäyen Yaagüüp ogo, “Ikee ṭäke merkä yeeki yääye muure? Yuucip baati, aŋ Camoon baati, aŋ tiññaŋ ikee ṭäke Benyamïïn koowde. Aŋ yaakki muure äätïdï a ika ti!” ");
INSERT INTO jum_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Aŋ Robïïn wäyen kiinne ogo, “Merkälen yeeki yaaka kä yewwe ye nägä ḍugin, naana batta agä ḍüügïnï ïkï ti ye, müükkaa kä ïṇtï ti, aŋ bi ḍuukkenii kä.” ");
INSERT INTO jum_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Aŋ Yaagüüp jaajjin ogo, “Minneni yeeni batta atï ke ikee wïca, määden tüwnü aŋ ike aŋŋa keelok yaana buccin ye. Ika agä daan aŋ naana ginkalaŋ näŋï ḍoŋe ike ti päy jï ye, ika bi äcka ḍok nüüjdüŋ, aŋ ika bi näga ḍok.” ");
INSERT INTO jum_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Aŋ käñ üüttïn ŋommañ mä Kanaan jï. ");
INSERT INTO jum_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Aŋ wääna iken päk yaaka äbänä Macïr ye baakkene ye, wäyen iken kiini ogo, “Ate ŋuca kijgon waak äämkä kä ḍeewaŋ.” ");
INSERT INTO jum_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Aŋ Yahüüja ike kiini ogo, “Men ikoon kollon kä car ogo waŋge batta bi yoorjon ŋuca, a naana määdo äjjon ye. ");
INSERT INTO jum_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Aŋ naana määdo tuccudu ke ikoon ye ikoon bi aton ïñï aŋ ïkï kijgini waak äämkä. ");
INSERT INTO jum_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Aŋ naana ike batta tuccudu ye, ikoon batta aton kä yaana kiinonon kä men ogo naana määdo batta äjjon ye, i waŋge batta bi yoorjon ŋuca ye.” ");
INSERT INTO jum_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Aŋ Yaagüüp jaajjin ogo, “Ika äckada ḍok yiñ kä nüütkïn men ogo ikee cääygeda ko määdic yaŋkalaŋ ina?” ");
INSERT INTO jum_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Aŋ iken luukcin ogo, “Men ikoon taaññon kä waŋ teyne, kä ḍuuggo ke mä äntüke yooko ogo wäyo mor ogo üdon? Aŋ ikoon cääygonda ko määdo yaŋkalaŋ? Aŋ tääctäŋŋi yeeke luuŋŋon. Aŋ ŋäjjon ogoo ogo bi jaajjo ogo, ‘Määdic äbe winni.’” ");
INSERT INTO jum_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Aŋ Yahüüja wäyen Yaagüüp kiinne ogo, “Minneni müükkaa kä dalä aton kä, nuŋko ütïn, aŋ ŋana tüwtïn kä ïkïïn ke merkä yooko. ");
INSERT INTO jum_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ika ḍoŋi bi rätä üṇṇü yeene, müükkaa kä ïntï ti, aŋ naana ike batta agä ḍüügïnï ïkï ti winni, aŋ ḍooccu ñomü ti ye, wäättan dalä leññä yeeni waajä ke on. ");
INSERT INTO jum_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Naana yoku ikoon batta koorron ye ikoon yoku ḍuukonon ääŋko kä yew.” ");
INSERT INTO jum_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Aŋ wäättan wäyen Yaagüüp iken kiini ogo, “Naana wäätcïdï aŋŋi ye, i kuje waak'a ŋeraŋ äbi woo ŋommañ kä ḍeewaŋ ye kücümgü yeekic gïtï, aŋ äcke men a iñdin käpet, kiñ kä ḍeewaŋ ke ḍuk yaaka a päkkiṇṇi ye ke yek pïlkä, ke ümbaküm, ke yüückü niit. ");
INSERT INTO jum_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Aŋ kuje tiil ääŋken kä yewwe yaaka ḍuukkene kä me kücümgü yeekic gïtï ina. Päjjïdï bülje, bi a yälgon. ");
INSERT INTO jum_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Aŋ cäänna määdic koowe aŋ ate ŋuca men ti. ");
INSERT INTO jum_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Dale Jooŋ yaana Lïïṭït ye, ikee iñe ŋerrä men ñome ti, dale määdic Camoon ḍuukke kä ke Benyamïïn. Aŋ bata ika naana merkä yeeki yäygin ye, i ika bi nüüjü kä iken.” ");
INSERT INTO jum_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Aŋ ook kuññu iñdinni ke tiil ääŋken kä yewwe ke Benyamïïn. Aŋ iken juwin aŋ attä ïñï Macïr. Aŋ yuuttu Yuucip ñome ti. ");
INSERT INTO jum_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Aŋ wääna Yuucip Benyamïïn yoorreeda kä ke iken ye, i jaajjin m'ana mügït än yeene ye ti ogo, “Ook yaakka ijä än yeeni ti, aŋ iṭä ḍeel aŋ toodu. Iken atï ämï ke ika äŋ gïtï.” ");
INSERT INTO jum_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Aŋ oon näŋjin bata yaana kiinene daa kä Yuucip ye, aŋ ook iññe äräk ba' Yuucip. ");
INSERT INTO jum_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Aŋ ook bojok kä yaana iken ijene daa me äräk ba' Yuucip ye, aŋ iken jayok ogo, “Bi kä tiil yaaka ḍooci me kücümgü gïtï waan yaana ïjjïnïn ti ina. Ken inni äbïnïn kä me külok winni yaanni, aŋ ïkïïn bi käkkïn witin, aŋ ïkïïn bi müügïn, aŋ ïkïïn bi äcïn agïn kiinkä, aŋ tüürüŋŋi yooko bi koowgu.” ");
INSERT INTO jum_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Aŋ iken attä m'ana mügït än Yuucip ye ti, aŋ jaaynene kä äntüke ti, ");
INSERT INTO jum_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","aŋ kiini ogo, “Ay men mooye ikoon äätonon winni waan yaana ḍakkä ina, aŋ ikoon kiññon päk. ");
INSERT INTO jum_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Aŋ wääna ḍukcodon kä paa ye, ikoon yuutton ïñï nänṭä ba' nïïnkä, aŋ kücümgü yooko kupkonon, aŋ wina muuronaan mäŋkalaŋ daa tiil yeeke kaññe kücam yeene tük, i tiil yooko daa päyï. Aŋ ikki ḍuugonon yaakki. ");
INSERT INTO jum_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Aŋ ikoon ääconon tiil yakkalaŋ ŋuca kijon kä päk, aŋ ikoon batta ŋäjjon a ŋaani ken inni tiil yooko ḍoocce kücümgü yooko gïtï.” ");
INSERT INTO jum_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Aŋ ike luukcin ogo, “Ŋïïbbïn ikee ti, ŋana ikee booje. Bi a Jooŋ yeenic yen wääc ken ḍuccin waak ŋerkä kücümgü yeekic gïtï. Ŋäjjä tiil yeekic koownu.” Aŋ wäättan Camoon äckeneeda kä woo. ");
INSERT INTO jum_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Aŋ wääna men ook iññeeda kä äräk ba' Yuucip ye, i iññe piik, aŋ kïïgen looki woo, aŋ tüürüŋŋï yeeken iññe beelgä. ");
INSERT INTO jum_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Aŋ iken iccinni tooti yokïn kä yaana Yuucip äätedee äŋ gïtï ye, kä nääŋka iken tiiŋene kä ogo iken bi ämo wïca ye. ");
INSERT INTO jum_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Aŋ wääna Yuucip äätenee paa ye, i iñdinni yaaka äbi ïnken ti ye, äckene daa kä äräk, aŋ iken ḍüŋjïn ïñï ñome ti ŋomgu gïtï. ");
INSERT INTO jum_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Aŋ tajdene kä cäwdä yeenen, aŋ taaññe ogo, “Wääc yore ŋeraŋ? Daan yaana kiiṇde ina. Aŋ ike mor a üdon?” ");
INSERT INTO jum_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Aŋ iken luukcin ogo, “Kiingon yüünü wäyo yore ŋeraŋ aŋ mor a üdon.” Aŋ iken ḍüŋjïn ïñï ŋuca kä eemdin. ");
INSERT INTO jum_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Aŋ Yuucip waŋge äärene ñaalok, aŋ määden Benyamïïn yaana a minneni meen ye yoorre, aŋ tääckene ti ogo, “A määdicle inni yaana kiinda kä ye?” Aŋ ike jaajjin ogo, “Jooŋ ïkï iñey ŋerrä minneni yeeni!” ");
INSERT INTO jum_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Aŋ Yuucip kaaccä woo kä bïraŋ kä yaana jone küümmee kä määden ye, aŋ attä äräk baanne aŋ weeŋŋä wïca. ");
INSERT INTO jum_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Aŋ wäättan ike waŋge püüjjene woo aŋ kääjin woo, aŋ jone yukkene aŋ jaajjin ogo, “Amma äbä.” ");
INSERT INTO jum_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Aŋ Yuucip iñi me woo pare kä därŋañ yeene, aŋ mädgen daa woo pääken. Aŋ mä Macïr yaaka ämmene kä ye daa woo pääken kä yaana mä Macïr batta ämene ke mä Iburu ye, ogo yaanna ogo ḍällä mä Macïr ti. ");
INSERT INTO jum_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Aŋ Yuucip mädgen ḍoocce ñome ti ḍooññe daa kä yuungen juwu mooye ti ke ḍeerconḍe ti, aŋ däämmä waŋgin i witken a ḍïïktïnï. ");
INSERT INTO jum_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Aŋ iken kujgi me ammani därŋañ Yuucip ti aŋ äckene daa kä me, aŋ Benyamïïn äcki me ääŋke kä duuc käälcïdï woo yek meken yaakka ti muure. Aŋ iken mättä ke Yuucip, aŋ juuggen ñappä. ");
INSERT INTO jum_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Aŋ Yuucip m'ana mügït än yeene jïñe ye iingene jiik ogo, “Kücümgü ook yaakka küümgü kä päk kä ḍiräk bata yaaka lïïltä kä äddin ye, aŋ yaŋkalaŋ daa tiil yeeke ḍuukci ti kücam yeene tük. ");
INSERT INTO jum_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Aŋ ḍonṭule ääygon kä tiilgä gälkä ḍoocci kücam yen määden ḍeerconḍe tük, nänṭä keellä ke tiil yaaka päk gïtï yaakka.” Aŋ ike näŋjin bata yaana kiinene daa Yuucip ye. ");
INSERT INTO jum_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Aŋ tïnnäk aŋŋi ook tuci me woo päy jï ke tüürüŋŋï yeeken. ");
INSERT INTO jum_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Aŋ wääna kaaccene kä woo baan mooye jï ye, Yuucip m'ana mügït än yeene ye kiinne ogo, “Kä bïraŋ ook yaakka ñoolu ŋätin. Aŋ naana wääṇṇi ŋätin ye, i taajä ogo, ‘Ŋerrä räddïï yok ko yiñ ina? ");
INSERT INTO jum_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ḍonṭule yen men mooye yeeni kale ina? A yaana mätee kä ye, aŋ a yaana cäänna paŋdee kä merkämäckä ye. Aŋ ikee näŋŋe mätkïtïn mooye!’” ");
INSERT INTO jum_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Aŋ wääna wääṇṇee daa ŋätin ye, i kiinne bata yaana daa kiinene daa Yuucip ye. ");
INSERT INTO jum_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Aŋ luugi ogo, “Men mooye yoono bi jaay ina aŋŋi? Ikoon kiinkä yüükü, batta lïïṭon näŋon nääŋkä yaakka. ");
INSERT INTO jum_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Yooru, tiil yaaka kaññon kücümgü yooko tügïn ye, ḍuukkini kä ŋäjäk ḍuugon ŋommañ mä Kanaan ti, aŋ tiilgä gälkä ke tiilgä yek än men mooye yüünü kalon ina? ");
INSERT INTO jum_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Aŋ naana ḍonṭule yeene kañi me mäŋkalaŋ ti ikoon ti ye, i men yaanna dalä tüw. Aŋ ikoon wääton agon kiinkä yeeke.” ");
INSERT INTO jum_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Aŋ ike luukcin ogo, “Ika gïmmädä kä jiik yeekic, aŋ a m'ana käññä ḍonṭule ye pare ken bi wäätï a kiingon yeeni, aŋ ikee yaakka bi ate kä tettä.” ");
INSERT INTO jum_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Aŋ iken muure kücümgü yeeken äbi ïñï tüürüŋŋï yeeken ŋätin kä bïraŋ, aŋ kupki. ");
INSERT INTO jum_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Aŋ m'ana mügït än Yuucip ye, juwin kä maawnä gïtï kücümgü, ïïjjïn ti kä kücam men mooye ti, aŋ yuuttu ïñï kücam men ḍeerconḍe ti, aŋ ḍonṭule kaññe kücam Benyamïïn jï. ");
INSERT INTO jum_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Aŋ mädgen buruŋgu yeeken jiijji gïtï woo kä nüüjdüŋ, aŋ tüürüŋŋï yeeken kooji aŋ ḍukcin baan mooye jï. ");
INSERT INTO jum_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Aŋ wääna Yahüüja ke mädgen äätene ti än yen Yuucip ti ye, i ike mor irä äräk, aŋ iken ḍüŋjïn ïñï ñome ti ŋommañ jï. ");
INSERT INTO jum_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Aŋ iken taaji Yuucip ogo, “A ŋaaka inni naŋŋe yaanni? Batta ŋäjje ogo oon yaana bata ika aŋŋi ye yuṭo ko paŋdin merkämäckä?” ");
INSERT INTO jum_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Aŋ Yahüüja luukcin ogo, “Ay, men mooye, ïkï kiingi ogo ŋaaka aŋ ikoon bi jaayon ogo ŋaaka aŋ ḍuuggo bi teeton woo ogoo? I Jooŋ yiñ yoono nüüdene woo aŋŋi. Aŋ tiññaŋ ikoon aŋŋon kiinkä yüükü, ikoon ke m'ana käññene me ḍonṭule ye.” ");
INSERT INTO jum_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Aŋ Yuucip jaajjin ogo, “Ay u'u yaakka batta naŋdä! A m'ana käññene me ḍonṭule ye ken wäätï a kiingon yeeni, aŋ ikee ate kä ŋïïbbïn paa wääc ti.” ");
INSERT INTO jum_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Aŋ Yahüüja wükcïn ti Yuucip ti, aŋ kiinne ogo, “Men mooye, kura dalä kiingon yüünü jaajjï jiik men mooye yeene ti. Aŋ ŋana ïkï peṇdä kiingon yüünü ti, naana cäänna ïkï beelä bata Parahuun ye. ");
INSERT INTO jum_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Men mooye ikoon taaññoon ogo, ‘Ikee cääygene kä wääc halla määdic?’ ");
INSERT INTO jum_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Aŋ ïkï luugini ogo, ‘Ee, ikoon cääygonon kä wäyo a daandïnï ke määdole, aŋ a minneni yeene yen düüñïn yuunge. Määden tüwnü aŋ a ike pare ken buccin merkä meen ti, aŋ ike bilgänä wäyen.’ ");
INSERT INTO jum_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Aŋ ïkï ikoon kiinnoon ogo, ‘Äbe winni, dale yooru kä waŋgi.’ ");
INSERT INTO jum_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Aŋ ïkï luugini ogo, ‘Minneni wäyen batta cakcede ïñï, aŋ naana cake ïñï ye, i wäyen bi tüw.’ ");
INSERT INTO jum_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Aŋ ikoon kiinnoon ogo, ‘Naana määdicle batta äätïdï ke ikee winni ye, waŋgi batta bi yoore ŋuca.’ ");
INSERT INTO jum_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Aŋ wääna ḍukconon kiingon yüünü wäyo ti ye, i kiinnon kä jiik'a jaajjinii kä ye. ");
INSERT INTO jum_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Aŋ ikoon kiinonon wäyo ogo, ‘ḍukce kiije päk kä ḍeewaŋ ŋuca.’ ");
INSERT INTO jum_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Aŋ luuŋŋon ogo, ‘Ikoon batta aton. A naana määdole bilti ke ikoon ye, ken bi aton kä, aŋ oon waŋge batta bi yooron a naana määdole bilti ke ikoon ye.’ ");
INSERT INTO jum_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Aŋ kiingon yüünü wäyo ikoon kiinnon ogo, ‘Ŋäjje iiŋ yeeni Rahiil ika gitkana merkälen oogen kä yewwe. ");
INSERT INTO jum_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Aŋ yaŋkalaŋ kaaccä woo ika ti, aŋ ika jaajjänä ogo, “A gïtken jiiji gïtï gin kurkuŋgu.” Aŋ batta agä yoorgon ke tiññaŋ. ");
INSERT INTO jum_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Aŋ naana yaanni koowe ika ti cäänna aŋ ginkalaŋ näŋï ḍoŋe ike ti ye, ika agä daan ika bi äcka ḍok yiñ, aŋ ika bi näga ḍok.’ ");
INSERT INTO jum_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Ken aŋŋi naana ika ḍukcu kiingon yüünü wäyo ti, i minneni baati ke ikoon ye, wäyo üṇṇü yeene a ḍekon ti üṇṇü yen minneni ti, ");
INSERT INTO jum_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","aŋ wäyo bi tüw naana minneni yoore baati ke ikoon ye. Ike a daandïnï, aŋ nüüjdüŋ yaana bi näŋgon daa kä ye ike bi näkä ḍok. ");
INSERT INTO jum_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Aŋ kiingon yüünü minneni müükkene daa wäyen, aŋ kiinnä ogo, ‘Naana minneni batta agä ḍüügïnï ŋäjäk ïkï ti ye, ika bi wääcä leññä ñomü ti yuungi muure.’ ");
INSERT INTO jum_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Aŋ aŋŋi kura men mooye, dalä kiingon yüünü minneni räde yok, aŋ ken wäätï a kiingon yüünü, aŋ dalä minneni ḍükcï ke mädgen. ");
INSERT INTO jum_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Aŋ ika bi ḍukcu wäyo ti ogoo naana minneni batta ke ika ye? Ika batta ṭäkä yurtu yiñ yaana ätä wäyo ti ye.” ");
INSERT INTO jum_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Aŋ Yuucip batta a lïïṭon kä yukkin jone m'aka yudok ñome ti yaakka ti muure, aŋ ike yaajjin ogo, “Kaace woo muurijaan winni.” Aŋ baati mäŋkalaŋ wääna yore nüütkeneeda kä woo mädgen ye. ");
INSERT INTO jum_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Aŋ ike weekcin kä yääw mooye ke tiiŋene daa mä Macïr, ke äntüke yen Parahuun. ");
INSERT INTO jum_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Aŋ Yuucip mädgen kiinne ogo, “Ika agä Yuucip! Wäyo mor üdon?” Aŋ mädgen batta a lïïṭïn kä luuŋŋu ike! Aŋ iken bojgin kä yaana yoken kañene daa däämmene waŋgin ke Yuucip ye. ");
INSERT INTO jum_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Aŋ Yuucip mädgen kiinne ogo, “Ääte ti ika ti kä cokal kura.” Aŋ iken äätin ti kä cokal. Aŋ kiinne ogo, “Ika agä määdic Yuucip yaana yääjjene woo Macïr ina. ");
INSERT INTO jum_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Aŋ ŋana ikee booje, aŋ ŋana ḍuuggic pingede ogo ika yääjjanada woo winni, Jooŋ ika tuujana ñomgic ti ogo ika mäkco üṇṇü me. ");
INSERT INTO jum_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Aŋ käñ cääyge yuungu kä yewwe baan jï, aŋ mor irä yuungu kä duuc yaaka pïïṇṇä ke errä bi baawgee kä ti ye. ");
INSERT INTO jum_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Aŋ Jooŋ ika tuujana ñomgic ti nuŋko buccee ko ŋommañ wic, aŋ määkoo ko woo üṇṇü yeenic nuŋko mä üdïn ḍïïrïïko. ");
INSERT INTO jum_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Aŋ batta a ikee ken ika tuujana winni, a Jooŋ. Aŋ ika naŋŋa bata wäy Parahuun ti, men mooye yen än yeene muure, aŋ ika naŋŋa agä mügdo yen ŋommañ mä Macïr muure. ");
INSERT INTO jum_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Aŋ ḍukce ŋäjäk kä bïraŋ ñaalok wäyo ti, aŋ nüütke ogo, ‘A jiik'a jääyete minneni yüünü Yuucip ye ikki, Jooŋ ika naŋŋa agä men mooye ŋommañ yen mä Macïr ti muure, ääte kä bïraŋ aŋ ŋana ïkï kuuru. ");
INSERT INTO jum_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ïkï bi cääyä baan mä Jiicaan ti, aŋ ïkï bi cokulu cokal ti ika ti, ïkï ke merkä yüükü ke merkä merkä yüükü, ke ḍiik ke däk yüükü ke wakkä yüükü muure. ");
INSERT INTO jum_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Aŋ ïkï bi tïïjeni wïca, nuŋko ŋana ïkï ke äntüke yüünü ke wakkä yüükü muure boccete ïñï. Yuungu mor irä kä duuc yaaka äätïdï a yek käñ ye.’ ");
INSERT INTO jum_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Aŋ tiññaŋ waŋgic yuṭṭu ke määdo Benyamïïn waŋge yuṭṭu ogo ika agjo Yuucip, aŋ ika inni jaayä ke ikee yaanni. ");
INSERT INTO jum_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Aŋ wäyo nüütke kä eemdin yeeni yaana kaññä Macïr winni ye, ke wakkä muure yaaka yoorre winni ye. Ate aŋ wäyo äbe ïñï winni kä bïraŋ.” ");
INSERT INTO jum_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Aŋ Yuucip määden Benyamïïn kunjene ti jone ti, aŋ ike jujjin kä ïwok, aŋ Benyamïïn weeŋŋä ḍoŋe ti cäänna. ");
INSERT INTO jum_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Aŋ Yuucip mädgen muure kuunne ḍugin, aŋ weggin, aŋ wäättana mädgen jaaynene kä. ");
INSERT INTO jum_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Aŋ wääna jiik ḍakkee än ti ba Parahuun ogo Yuucip mädgen äätono ye, i Parahuun ke ḍuuŋkulen yeeke juuggen ñappä. ");
INSERT INTO jum_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Aŋ Parahuun Yuucip kiinne ogo, “Mädgic nüütkü ogo näŋjo ogo aŋŋi, tüürüŋŋï yeeken koojjï, aŋ ḍukco ŋäjäk ŋommañ mä Kanaan ti ");
INSERT INTO jum_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","aŋ wäyen äbïï ke mä äntüke yeeken ika ti. Aŋ ikee bi iñe ŋommañ ŋerconḍe yen mä Macïr, aŋ ikee bi äme wakkä ŋerkä yaaka äpätä woo ŋommañ ye. ");
INSERT INTO jum_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Aŋ ïkï cäänna kiinneni ogo iken nüütkeey, ogo kuju teebälaŋŋi yek bägälgä yek mä Macïr ääcïï ko merkä yeeken ke määngen, aŋ wäyen äbïï aŋ ääto. ");
INSERT INTO jum_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Aŋ ŋana juuggic lüüjï wakkä yeekic, waak ŋerkä yek mä Macïr muure bi wäätï a yeekic.” ");
INSERT INTO jum_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Aŋ merkälen yek Yaagüüp yaanna naŋi. Aŋ iken iñi Yuucip teebälaŋŋi yek bägälgä bata yaana Parahuun iinjenee kä ye, aŋ iññe wakkä äämkä yek päy jïñe. ");
INSERT INTO jum_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Aŋ iken ti muure yaŋkalaŋ daa iññe buruŋgu, aŋ Benyamïïn iññe tiilgä gälkä waŋgen 300 ke buruŋgu kä duuc. ");
INSERT INTO jum_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Aŋ a waak yaaka tuckene wäyen ye ikki, tüürüŋŋï oogen kä caay a koocin kä wakkä ŋerkä yek mä Macïr, aŋ tüürüŋŋï määngen kä caay a koocin kä päk ke bïggï ke waak äämkä yakkalaŋ a yek wäyen päy jï. ");
INSERT INTO jum_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Aŋ wäättan ike mädgen tucce woo, aŋ wääna kaaccene kä woo ye, i kiinne ogo, “Ŋana ikee ääme yääññä päy jï.” ");
INSERT INTO jum_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Aŋ iken Macïr dalji ïñï aŋ attä wäyen Yaagüüp ti ŋommañ yen mä Kanaan ti. ");
INSERT INTO jum_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Aŋ kiini ogo, “Yuucip mor a üdon! Aŋ ike ken mügït ŋommañ mä Macïr jïñe muure.” Aŋ Yaagüüp wiñe ḍiiktin kä jiik kïccäŋgenen, aŋ iken batta agee kä gïmgïnï. ");
INSERT INTO jum_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Aŋ wääna wäyen nüütkene daa kä jiik'a kiinene daa Yuucip muure, aŋ wääna ike yuṭṭee teebälaŋŋi yek bägälgä yaaka tuuji Yuucip ike äcä ye, i wäyen Yaagüüp jone ḍuukin ïñï. ");
INSERT INTO jum_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Aŋ Yaagüüp jaajjin ogo, “Ḍaŋŋä, minneni yeeni Yuucip mor a üdon, ika bi atä yooru i batta mor ika tüwü.” ");
INSERT INTO jum_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Aŋ Yaagüüp wakkä yeeke kooññe muure bak Macïr. Aŋ wääna ike ḍakkee ti Bïïrcïba ye, ike iccin wäämmäni yok Jooŋ yen wäyen Icaak ti. ");
INSERT INTO jum_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Aŋ wääna wïïrïn aŋŋi ye, ike kiini Jooŋ kä yooddin aŋ bärkene ogo, “Yaagüüp! Yaagüüp!” Aŋ Yaagüüp luukcin ogo, “Haa, ika inni.” ");
INSERT INTO jum_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Aŋ ike jaajjin ogo, “Ika agä Jooŋ, Jooŋ yen wääc. Ïkï ŋana booju kä wään ïñï Macïr, ïkï bi naŋeni wäätci agä ṭoŋ yäwke wïca. ");
INSERT INTO jum_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Aŋ ika kä ḍoŋi bi atä ke ïkï ïñï Macïr, aŋ ŋuca ïkï bi ḍuugeni ŋäjäk. Aŋ waŋgü bi kümgü kä Yuucip kä ïṇte.” ");
INSERT INTO jum_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Aŋ Yaagüüp Bïïrcïba daljene ïñï, aŋ koowi merkä yeeke ke merkälen yeeken ke määngä yeeken kä teebälaŋŋi yek bägälgä yaaka tuuji Parahuun ogo taapce ko ye. ");
INSERT INTO jum_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Aŋ iken cäänna ḍigärgä yeeken koowi ke wakkä yeeken yaaka naŋi ŋommañ mä Kanaan ti ye. Aŋ Yaagüüp ke kaaynä yeeke muure attä Macïr. ");
INSERT INTO jum_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Merkä yeeke ke merkä merkä yeeke, ke kaaynä yeeke muure koowne attene Macïr. ");
INSERT INTO jum_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Aŋ yaakki a yäṇtäŋŋi yek kaaynä Icärayiil yaaka a merkä Yaagüüp attä Macïr ye, Robïïn a minneni Yaagüüp yaana a kaygon ye. ");
INSERT INTO jum_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Aŋ merkä yek Robïïn a Anook ke Pallü ke Hïjïroon aŋ Karmi. ");
INSERT INTO jum_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Aŋ merkä yek Camoon a Yamaweel ke Yamïïn ke Uhaat ke Yakïïn ke Cuwaar aŋ Caawüül. Caawüül meen a iiŋ mä Kanaan. ");
INSERT INTO jum_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Aŋ merkä yek Laawï a Jeercüün ke Kuhaat aŋ Miraarï. ");
INSERT INTO jum_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Aŋ merkä yek Yahüüja a Eer ke Unaan ke Cïïla ke Paaric aŋ Jüra. Aŋ Eer ke Unaan iken tüwgïn ŋommañ mä Kanaan ti. Aŋ merkälen Paaric a Hïjïroon ke Hamüül. ");
INSERT INTO jum_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Aŋ merkä yek Yacakïïr a Tolla ke Püwa ke Yoop aŋ Cïmarüün. ");
INSERT INTO jum_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Aŋ merkä yek Jabuloon a Cereet ke Ïloon aŋ Jalaal. ");
INSERT INTO jum_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Aŋ a merkä yek Leya ke Yaagüüp yaaka giidi Padaan Araam ye ikki, aŋ yaŋkalaŋ a iiŋ battä me ogo Ḍïïna. Aŋ merkä yeeke oogen ke ṭulgu muure a caykä kä ḍäk witken kä ḍäk. ");
INSERT INTO jum_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Aŋ merkä yek Gaat a Japhuun ke Hajjï ke Cünnï ke Ïjboon ke Eerï ke Aaroodï aŋ Aarelï. ");
INSERT INTO jum_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aŋ merkä yek Acïïr a Ïmna ke Ïcba ke Ïcbï aŋ Bïrrïya ke käwen battä me ogo Ceera. Aŋ Bïrrïya merkä yeeke a Hebir aŋ Malakeel. ");
INSERT INTO jum_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Aŋ a merkä yek Jïlpa kiingon yen Leya yaana iñene daa kä wäyen Laabaan ye ikki. Aŋ kaaynä yek Yaagüüp yaaka Jïlpa ti ye, a caay witken kä ḍüügük. ");
INSERT INTO jum_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Aŋ merkä yek Yaagüüp iiŋe Rahiil ti a Yuucip ke Benyamïïn. ");
INSERT INTO jum_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yuucip merkä yeeke yaaka giiṇṇe ŋommañ mä Macïr ti ye, a Manacca ke Ipiraayim. Aŋ meen a Acanaat ṭuulle yen Patipeera män daaŋ yen mä Uun. ");
INSERT INTO jum_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Aŋ merkä yek Benyamïïn a Beela ke Baakir ke Ajbeel ke Jïïra ke Naaman ke Eey ke Rooc ke Mupïïm ke Hüpïïm aŋ Aaret. ");
INSERT INTO jum_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Aŋ a merkä yek Rahiil ke Yaagüüp yaaka giidi ye ikki. Aŋ kaaynä muure yek Yaagüüp yaaka Rahiil ti ye, a caay witken kä ŋan. ");
INSERT INTO jum_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Aŋ minneni Ḍaan a Hoocïïm. ");
INSERT INTO jum_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Aŋ merkä yek Naptaalï a Yaaceel ke Jooni ke Yaacir aŋ Calïïm. ");
INSERT INTO jum_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Aŋ a merkä yek Bila kiingon yen Rahiil yaana iñene daa kä wäyen Laabaan ye ikki. Aŋ kaaynä muure yek Yaagüüp yaaka Bila ti ye, a ŋaṭükel. ");
INSERT INTO jum_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Aŋ merkä muure yek Yaagüüp yaaka tïïlcïdï a kaaynä yeeke yaaka attä Macïr ye, a caykä kä ḍüügük witken kä ḍüügük, i määngä merkä yeeke batta a pakin ti. ");
INSERT INTO jum_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Aŋ ŋucki ti merkä Yuucip yaaka kä yewwe giidi me Macïr ye. Aŋ äntüke Yaagüüp muure aŋŋa caykä kä ŋaṭükel ŋommañ mä Macïr ti. ");
INSERT INTO jum_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Aŋ Yaagüüp Yahüüja tucce ñome ti ogo pärjo ke Yuucip, aŋ iken nüütcï päy yen mä Jiicaan ti. Aŋ wääna iken ḍakkene kä ti Jiicaan ye, ");
INSERT INTO jum_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","i Yuucip teebälaŋ bagal yeene tooṇṇe, aŋ attä pärjin ke wäyen Yaagüüp baan mä Jiicaan jï. Aŋ wääna pärjene kä ye, i Yuucip wäyen kunne ḍok aŋ weggin kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Aŋ Yaagüüp Yuucip kiinne ogo, “Tiññaŋ dalä ika tüwü ïkï yoorreni, aŋ ïkï inni yoorreni mor agä üdon yaanni.” ");
INSERT INTO jum_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Aŋ Yuucip jaajjin mädgen ti ke äntüke yen wäyen ti muure ogo, “Ika bi atä Parahuun ti, aŋ nüütkü ogo mädgo ke äntüke yen wäyo ḍäägono ti ika ti, ääto ŋommañ mä Kanaan ti. ");
INSERT INTO jum_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Aŋ ikee agje kaaydoni yek ḍiik aŋ agje tïïconi yek ḍigärgä, aŋ ikee ḍiik yeekic ke däk ke wakkä yeekic muure yaaka bilto ti ye äbenee ke ikee. ");
INSERT INTO jum_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","“Aŋ naana Parahuun ikee bärkene, aŋ ikee taaññe ogo, ñuugula yeenic ogo ŋaaka ye, ");
INSERT INTO jum_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","i kiine ogo, ‘Ñuuguloni yüükü a tïïconi yek ḍigärgä kä ḍinen tinä, bata dänkä yurgen.’ Nuŋko bi dalje kä cääye kä baan mä Jiicaan ye ti, aŋ nääŋka kaaydoni muure yek mä Macïr ti agene mä ḍälkä ye.” ");
INSERT INTO jum_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Aŋ Yuucip attä Parahuun ti, aŋ nüütkene ogo, “Wäyo ke mädgo ke ḍiik ke däk ke wakkä yeeken muure ätä ŋommañ mä Kanaan ti, aŋ iken tiññaŋ a baan mä Jiicaan ti.” ");
INSERT INTO jum_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Aŋ kuññu mädgen kä duuc, aŋ iññe Parahuun ñome ti. ");
INSERT INTO jum_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Aŋ Parahuun Yuucip mädgen taaññe ogo, “Ñuugula yeenic a ŋaaka?” Aŋ Parahuun luugi ogo, “Ñuuguloni yüükü a kaaydoni ḍiik bata dänkä yurgen. ");
INSERT INTO jum_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ikoon äätonon cääjjodon Macïr winni bata boorgu, kä yaana wïca baati nänṭa kääjene ñuuguloni yüükü ḍiik ye, kä yaana käñ tällee ŋommañ mä Kanaan ti ye. Aŋ dalä kura ñuuguloni yüükü cääjjï baan mä Jiicaan ti.” ");
INSERT INTO jum_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Aŋ Parahuun Yuucip kiinne ogo, “Wääc ke mädgic äätin ïkï ti. ");
INSERT INTO jum_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Aŋ wäkä nänṭä yaana ṭäkkä ŋommañ mä Macïr ti ŋeraŋ ye, aŋ ḍuccii kä wääc ke mädgic. Aŋ dalä iken cääjjï baan mä Jiicaan ti. Aŋ naana ïkï ŋäjjä ook yakkalaŋ iken ti lïïṭït tïïcï ḍigärgä ye, i müükkü ḍigärgä yeeki dalä tïïcä.” ");
INSERT INTO jum_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Aŋ Yuucip wäyen Yaagüüp äbene yuutte Parahuun ñome ti. Aŋ Yaagüüp Parahuun ŋüülkene. ");
INSERT INTO jum_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Aŋ Parahuun Yaagüüp taaññe ogo, “Yüüngü kä ŋïṭṭä?” ");
INSERT INTO jum_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Aŋ Yaagüüp Parahuun luuŋŋe ogo, “Yuungu yeeki a 130, aŋ yuungu yeeki ḍewgaŋ aŋ yejgaŋ, aŋ batta a ḍakin yuungu dänkä yurgo ti yaaka cääynene kä ye.” ");
INSERT INTO jum_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Aŋ Yaagüüp Parahuun ŋüülkene, aŋ kaaccä woo üṇtük aŋgin yore Parahuun ti. ");
INSERT INTO jum_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Aŋ Yuucip wäyen ke mädgen ḍoocce ŋommañ mä Macïr jï, aŋ iññe ŋommañ yaana kääṭï kä ŋerrä baan mä Ramcïïc ti ye, bata yaana eenjene daa Parahuun ye. ");
INSERT INTO jum_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Aŋ Yuucip wäyen ke mädgen ke äntüke yen wäyen muure iññe wakkä äämkä daa kä yoken. ");
INSERT INTO jum_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Aŋ käñ yaaññä kä yaac aŋ ammani baati nänkä muure aŋ mäbaan yek mä Macïr ke yek mä Kanaan aŋŋa puudgu kä käñ. ");
INSERT INTO jum_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Aŋ Yuucip tiil muure yek ŋommañ mä Macïr ke yek mä Kanaan ḍülle yokïn, yaaka kijene me päk ye, aŋ Yuucip tiil äbene ḍoocce än Parahuun jï. ");
INSERT INTO jum_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Aŋ wääna tiil muure baakkene ŋommañ mä Macïr ti ke ŋommañ mä Kanaan ti ye, i mä Macïr muure äätin Yuucip ti aŋ kiini ogo, “Iñjon päk. Ikoon bääggodoon tüwon ina? Tiil yooko baakkin.” ");
INSERT INTO jum_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Aŋ luugi Yuucip ogo, “Ḍigärgä yeekic äbe aŋ ikee bi iñe päk rätke kä ḍigärgä yeekic naana tiil yeekic baakkin ye.” ");
INSERT INTO jum_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Aŋ iken ḍigärgä yeeken icki Yuucip aŋ iñi Yuucip päk rätkeneeda kä bägälgä ke ḍiik ke däk ke tüürüŋŋi. Aŋ iken iici Yuucip rätkede päk kä ḍigärgä yeeken yun yaanna ti. ");
INSERT INTO jum_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Aŋ wääna yun yaanna ḍüüñenee kä ye, iken ḍuukin yun kalaŋ ti, aŋ ike kiini ogo, “Men mooye yoono, ïkï batta päänkiti ŋïngïn ginkalaŋ ogo tiil yooko baakkono. Aŋ ḍigärgä yooko muure aŋŋa yüükü, baati gin'a a büccïnï iñgi kä ye, a gäyko ke yirkä yooko pääken. ");
INSERT INTO jum_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Aŋ ikoon bääggodoon tüwon ñomü ti ikoon ke yirkä yooko ina? Kiyjon ke yirkä yooko kä päk aŋ ikoon ke yirkä yooko ikoon wääton a kiinkä yek Parahuun. Aŋ iñjon käwkä nuŋko ŋana tüwdon kä, aŋ yirkä ŋana wäätcïdï a mardï.” ");
INSERT INTO jum_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Aŋ Yuucip ŋommañ mä Macïr muure kijgene Parahuun. Aŋ mä Macïr muure yirkä yeeken yääjji woo, kä yaana käñ yaaññee kä iken ti ye, aŋ ŋommañ aŋŋa yen Parahuun. ");
INSERT INTO jum_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Aŋ Yuucip mä Macïr naŋŋe a kiinkä muure. ");
INSERT INTO jum_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Aŋ a ŋommañ mä däŋkä pare ken batta agee kä kiygon a nääŋka Parahuun agee kä ḍüccïnï jiik ke iken aŋ iñdeeda kä päk yek ñuugula yeenen ye. Aŋ ken amgä, ina ken ŋommañ yeenen batta yääyge daa kä yaanna. ");
INSERT INTO jum_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Aŋ Yuucip me kiinne ogo, “Tiiŋe, ikee ke ŋommañ yeenic ikee kijgene Parahuun, aŋ käwkä yaakki koowe ije pïïde yirkä gïtï. ");
INSERT INTO jum_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Aŋ naana päk erre ye, i Parahuun iñe kä keelok duuc ti, aŋ ŋan ken ḍooce a käwkä aŋ a ammani yek ḍuuggic ke mä äntükeni yeekic ke merkälen yeekic.” ");
INSERT INTO jum_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Aŋ iken jaajjin ogo, “Üṇṇü yoono maŋŋi, aŋ men mooye, dalä ikoon käñon ŋerrä ïkï ti, aŋ ikoon bi wääton agon kiinkä yek Parahuun.” ");
INSERT INTO jum_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Aŋ naŋi Yuucip a jiik ḍoocin ŋommañ mä Macïr jï, ogo keelok duuc ti yen errä ogo yen Parahuun, aŋ jiik ḍoocin yaakka bilti ke tiññaŋ. Aŋ büccïdï a ŋommañ mä däŋkä pare ken batta a wääton a yen Parahuun. ");
INSERT INTO jum_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Aŋ mä Icärayiil cäygin ŋommañ mä Macïr jï, baan mä Jiicaan jï. Aŋ iken ŋommañ aŋŋa yeenen, aŋ iken gidgin aŋ ḍiirin kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Aŋ Yaagüüp cääynä ŋommañ mä Macïr ti yuungu kä caay witken kä ŋaṭükel. Aŋ yuungu yek Yaagüüp muure yek üṇṇü yeene a 147. ");
INSERT INTO jum_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Aŋ wääna tüwnü Yaagüüp cokulenee ye, i minneni yeene Yuucip bärkene ti, aŋ kiinne ogo, “Kura dalä ika käñä ŋerrä ïkï ti. Aŋ ïṇtü äcci äämi ti aŋ lïïtkaa ogo ika bi nüütkada biilin yaana batta düüñïdï ye ke woṇṇu. Aŋ ika ŋana jïgja ŋommañ mä Macïr jï. ");
INSERT INTO jum_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Aŋ naana ika baakkänä ye, äbaa woo ŋommañ mä Macïr jï, aŋ jïgja kälkä wäygo ti.” Aŋ luugi Yuucip ogo, “Bi naŋä bata yaana kiinnaa kä ye.” ");
INSERT INTO jum_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Aŋ Yaagüüp jaajjin ogo, “Lïïtkaa.” Aŋ lïïtkï Yuucip, aŋ Yaagüüp ḍüŋjïn ïñï bür yeene wic. ");
INSERT INTO jum_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Aŋ ääŋkalaŋ ti Yuucip nüütkï me ogo, “Wääc yore cäärin woo.” Aŋ merkä yeeke yaaka kä yewwe yaakka koowne, Manacca ke Ipiraayim. ");
INSERT INTO jum_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Aŋ Yaagüüp nüütkï me ogo, “Minneni yüünü Yuucip ḍäägin.” Aŋ Yaagüüp yore riijene ñaalok aŋ cääjjin bür wic. ");
INSERT INTO jum_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Aŋ Yaagüüp Yuucip kiinne ogo, “Jooŋ yaana Lïïṭït ye üükïn woo ika ti Lüüc ŋommañ mä Kanaan ti, aŋ ika ŋüülkana, ");
INSERT INTO jum_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","aŋ ika kiinna ogo, ‘Ïkï bi iñeni merkä kä ḍiräk. Aŋ kilkä yüükü bi wäätï a ṭoŋ ḍiirken, aŋ ŋommañ yaanni bi iñä kilkä yüükü aŋ bi wäätï a yeenen ke cüle.’ ");
INSERT INTO jum_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Aŋ tiññaŋ merkä yüükü yaaka giiṇṇi ŋommañ mä Macïr ti i batta mor ika äätä ïkï ti Macïr ye, a yeeki, Ipiraayim ke Manacca bi wäätï a yeeki bata Robïïn ke Camoon. ");
INSERT INTO jum_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Aŋ merkä yaaka bi ŋocci giidä ŋätken ti ye ken bi a yüükü, aŋ yäṇṇäni yeeken bi kañgä kä waan yen Ipiraayim ke Manacca. ");
INSERT INTO jum_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","“Wääna äätä kä Padaan Araam ye Rahiil tüwnü päy jï ŋommañ mä Kanaan ti, aŋ ika anjänä ïñï kä yaac, i ikoon aton ti Ipiraat. Aŋ jïkkä ïñï päy jï Ipiraat,” aŋ cäänna Ipiraat battä me ogo Beetlaam. ");
INSERT INTO jum_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Aŋ wääna Yaagüüp merkä Yuucip yoorreeda kä ye, i ike jaajjin ogo, “A ŋaannä ikki?” ");
INSERT INTO jum_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Aŋ Yuucip wäyen luuŋŋe ogo, “A merkälen oogen yeeki yaaka iñana kä Jooŋ Macïr winni ye.” Aŋ Yaagüüp jaajjin ogo, “Äbä ika ti winni dalä ŋüülkü.” ");
INSERT INTO jum_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Aŋ Yaagüüp waŋge tüŋïlïn kä dänkïtene, aŋ batta ŋuca yuṭï ṭeṭaŋ. Aŋ Yuucip merkälen ickeneeda ti kä cokal aŋ kuunene ti jone ti, aŋ muckene yokïn. ");
INSERT INTO jum_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Aŋ Yaagüüp Yuucip kiinne ogo, “Ika ḍuucu ogo ïkï batta bi yoorjïda ŋuca, aŋ Jooŋ tiññaŋ ika daljana ke cäänna kaaynä yüükü yoorru.” ");
INSERT INTO jum_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Aŋ merkälen äbi woo Yuucip daan wäyen uŋge ti, aŋ ike ñome teekke ïñï ŋommañ jï. ");
INSERT INTO jum_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Aŋ Yuucip iken koowi muuṭuk aŋ Ipiraayim kä ïṇte birrä ti üüŋjene buŋ aam yen Yaagüüp ti aŋ Manacca kä ïṇte aam ti aŋ üüŋjene buŋ birrä yen Yaagüüp ti, aŋ äbene ti kä cokal. ");
INSERT INTO jum_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Aŋ Yaagüüp bugge büülle gïtï aŋ ïnke lajjene woo, aŋ ḍoocce merkälen witken ti, aŋ ïṇte birrä ḍoocce Ipiraayim yaana ḍeeraŋ ye wiñe ti, aŋ ïṇte aam ḍoocce Manacca yaana a kaygon ye wiñe ti. ");
INSERT INTO jum_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Aŋ Yuucip ŋüülkene aŋ jaajjin ogo, “Jooŋ yaana baaddi wäygo Abrayiim ke Icaak ye, a Jooŋ yaana ika kaayna üṇṇü yeeni ti muure ke nïnnä yaanni ti ye. ");
INSERT INTO jum_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Aŋ malak yaana ika maŋŋa kä pillä muure ye, dalä merkälen ŋüülke. Aŋ dale yäṇtonḍi paytä me kä merkälen yaakka ke wäygo Abrayiim ke Icaak, aŋ iken daljänä ḍirä ŋommañ wic kä yaac.” ");
INSERT INTO jum_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Aŋ wääna Yuucip wäyen yoorreeda ïṇte birrä äcceeda Ipiraayim wiñe ti ye, yoorre yaajaŋ ike ti, aŋ Yuucip wäyen ïṇte müŋŋe aŋ ṭäkke aŋgede yok Ipiraayim wiñe ti aŋ ḍooccede Manacca wiñe ti. ");
INSERT INTO jum_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Aŋ Yuucip wäyen kiinne ogo, “Batta aŋan wäyo, yaanni ken a kaygon yeeni, ïntü bïrrä ḍoocci wiñe ti.” ");
INSERT INTO jum_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Aŋ wäyen yaakkä aŋ jaajjin ogo, “Ŋäjjä minneni yeeni, ŋäjjä. Ike cäänna bi mä yeeke ḍirä aŋ ike cäänna bi yäwaŋ, aŋ määden ḍeerconḍe ken bi yäwaŋ kä ike aŋ kilkä yeeke bi ḍiirä kä yaac aŋ wäätï a ṭoŋ ḍiirken.” ");
INSERT INTO jum_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Aŋ ŋüülkene nïïnnä yaanja ti aŋ jaajjin ogo, “Mä Icärayiil yäṇtäŋginic bi battä yokïn naana iken ŋüülkïdï mäŋkalaŋ ye, aŋ iken bi jayok ogo, ‘Dalä Jooŋ ïkï naŋey bata Ipiraayim ke Manacca.’” Aŋ ike Ipiraayim ḍoocce Manacca ñome ti. ");
INSERT INTO jum_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Aŋ Yaagüüp Yuucip kiinne ogo, “Ika ḍaŋŋa tüwü, aŋ Jooŋ bi ke ikee aŋ ikee bi ḍuuke ŋommañ dänkä yurgic ti. ");
INSERT INTO jum_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Aŋ baan yaana iñdä mädgic ye ti, ïkï iñdene baan taaŋŋe mooye yen mä Cakïïm kä mädgic, a yaana ärrä mä Amoor ti kä gaaḍal yeeni ke kaay yeeni ye.” ");
INSERT INTO jum_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Aŋ Yaagüüp merkä yeeke bärkene ti, aŋ kiinne ogo, “Wüüke ti ika ti, aŋ ikee nüütke a ŋaaka ken bi näŋï ḍoŋe ikee ti nïïnkä yaaka äätïdï ye ti. ");
INSERT INTO jum_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ääte ti aŋ tiiŋe, ikee merkälen yeeki, tiiŋe wääc Yaagüüp ti. ");
INSERT INTO jum_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Robïïn, ïkï agä kaygon yeeni, aŋ teynä yeeni ke ïkï agä minneni ïïjïnï woo yen dürkïtïnï, aŋ ïkï agä kültü yen eemdin ke kültü yen teynä. ");
INSERT INTO jum_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ïkï beelä bata piik tääl wiñe yaaka ïïjïdï ti ye, aŋ ïkï batta bi küülüküül ŋuca, nääŋka attii kä bür yen wääc ti aŋ ḍäälleeda kä yok ye. ");
INSERT INTO jum_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Camoon ke Laawï a mädin gaaḍalli yeeken a yek ïïrrä teynä. ");
INSERT INTO jum_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Dale ŋana ika kaaccädä ti nänṭa ḍülte yoken ye, aŋ dale ŋana yori coorcudu ti jiik yeeken yaaka ḍiikä ye ti. Kä piinkä yeeken iken nääkin me, aŋ iken yätkä naŋe a ŋolku kä ñääy. ");
INSERT INTO jum_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tuummu wäätï piinkä yeeken ti kä yaana yejgene yejok ye, aŋ piinkä yeeken yejgaŋ kä yaac, aŋ iken bi piirjä woo kaaynä yeeki gïtï, aŋ iken bi gääjä gïtï mä Icärayiil ti. ");
INSERT INTO jum_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yahüüja, mädgic ïkï bi maaŋgi. Ïṇtü bi wäätï ädäŋŋi yüükü ḍuuggen ti. Aŋ merkä yek wääc muure bi ḍüŋjïdï ïñï ñomü ti. ");
INSERT INTO jum_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahüüja a geel ṭuule yaana ḍaŋŋä kä ammä waak'a näge ye. Aŋ yore meecce woo aŋ baati m'ana ike rükü yok ye. ");
INSERT INTO jum_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yätkïtïn batta bi kaacï woo paa ba Yahüüja, aŋ kilkä yeeke kamat ken bi mügït aŋ ṭoŋ ike bi äckätä iñdinni aŋ ike bi tiiŋkätä. ");
INSERT INTO jum_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Aŋ tüürüŋle yeene bi weene kä jaan beel bata lüütkon meen, erele yeene bi weene kä jaan beel bata lüütkon meen yaana ŋeraŋ ye, aŋ buruŋgu yeeke bi pure kä määk, jïbbani yeeke bi pure kä piik yek jaan yaana beel bata lüütkon ye ṭulge. ");
INSERT INTO jum_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Aŋ waŋge bi tïdaŋ kä maaṇṇä määk kä yaac, aŋ leke bi bowaŋ kä maaṇṇä aak. ");
INSERT INTO jum_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Aŋ Jabuloon bi cääy ṭiŋal wii mooye jï, aŋ ike bi wäätï a nänṭ'a yuutcete ïñï kuudgu mäyken ye, aŋ tügge bi ḍakcïdï Cïdoon. ");
INSERT INTO jum_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Yacakïïr a tüürüŋ teyconḍe yaana nïïn waadgä baliṇṇi ye. ");
INSERT INTO jum_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Aŋ naana nänṭä yïïktäŋ yoorre ŋeraŋ, aŋ ŋommañ ŋeraŋ ye, i büyke gääŋe ïñï ḍürdee kä waak pekkä aŋ bi engä me ñuugal bata kiingon. ");
INSERT INTO jum_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Ḍaan bi mä yeeke müge aŋ iken bi belok bata kurku mä Icärayiil aŋan. ");
INSERT INTO jum_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Aŋ Ḍaan bi beel bata kaaŋ yaana cääy päy mooye taaŋ ye, aŋ a pääññä yaana cääy päy taaŋ ye, a yaana kääjä bagal ŋubduŋgene ti ye, aŋ taapdo ḍïmjï ṭarkic.” ");
INSERT INTO jum_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Aŋ Yaagüüp jaajjin ogo, “Ika kiijä maŋŋä yüünü, ay Pïṭo. ");
INSERT INTO jum_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gaat bi irkätä mäddoŋŋi, aŋ bi ñoole aŋ baadde. ");
INSERT INTO jum_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Acïïr ŋommañ yeene bi giit waak äämkä ñapken. Aŋ ike bi ḍüccïdï waak äämkä yek yätkä. ");
INSERT INTO jum_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naptaalï a pääy yaana kälit kä tettä yaana giit päykälen ŋerken ye. ");
INSERT INTO jum_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yuucip a jaan yaana giit kä yaac ye, a jaan yaana giit kä ceere yen piik ye, kimke muulu kaal wic. ");
INSERT INTO jum_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Aŋ ädäŋŋi yeeke ike irki kä yaacken, aŋ ike ḍiŋi kä cäwgä aŋ ike baaydi kä yaac. ");
INSERT INTO jum_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Aŋ kaay yeene agee kä yïïcon, aŋ bugge bïtäraŋ, kä teynä Jooŋ yen Yaagüüp yaana Lïïṭït ye, aŋ kä kaaydo yaana daŋit, a yen mä Icärayiil ye, ");
INSERT INTO jum_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","a Jooŋ yen wääc ken ïkï yüükkedey ti, aŋ a Jooŋ yaana Lïïṭït ye, ken ïkï ŋüülkedey kä ŋüülkïnni yek ñaal yaaka ñaalok polloŋ jï ye, ke ŋüülkïnni yek piik yaaka lürgaŋ ïñï ŋommañ jï ye, ke ŋüülkïnni yek tingä ke kun. ");
INSERT INTO jum_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ŋüülkïnni yek wääc yäwaŋ käälcïdï woo ŋüülkïnni yek pämkä dänken ke waak ŋerkä yek tüümoni yaaka ke cüle ye ti. Aŋ dale ŋüülkïnni yaakka muure wäätï a Yuucip wiñe ti, yaana a woydo waadgä mädgen ye. ");
INSERT INTO jum_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamïïn a bäw yaajgonḍe yaana meken jiije gïtï ye, kä tïṇṇäŋänä aŋŋi ämï yäŋgä yaaka näge ye, aŋ biigin ti aŋŋi waak'a näge ye pääge gïtï.” ");
INSERT INTO jum_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yaakki muure a kurku kä caay witken kä yew yek Icärayiil, aŋ a waak'a kiinene daa wäyen ye ikki, wääna ŋüülkedeeda kä ye, yaŋkalaŋ daa ŋüülkene kä ŋüülkïn yaana päjjïdï ke ike ye. ");
INSERT INTO jum_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Aŋ iken iingene kiinne ogo, “Ika bi yori cooṭu ti dänkä yurgo ti kä bïraŋ. Aŋ ika jïga ke wäygo ṭuum yaana yiil yen Aproon ti män Haat ye. ");
INSERT INTO jum_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","A ṭuum yaana yiil jï Makapeela jï cokulaŋ ti Mamar ŋommañ mä Kanaan ti ye, yaana kiyi Abrayiim Aproon män Haat ti, ogo wääto ogo yen jïïgïn ye. ");
INSERT INTO jum_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Aŋ a nänṭä yaana jïkkene me Abrayiim ke iiŋe Caarra ye ke nänṭä yaana jïkkene me Icaak ke iiŋe Rïpga ye. Aŋ Leya jïŋŋä wïca. ");
INSERT INTO jum_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Aŋ yiil ke ṭuum yaana jïñe ti yaanna kiygä me mä Haat ti.” ");
INSERT INTO jum_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Wääna Yaagüüp ḍaŋŋee kä iingin merkä yeeke ye, kïïge nuulene ñaalok bür wic, aŋ ike wääkcin woo wääktäŋ tüwnü aŋ tüwnü, aŋ cooṭi me ti dänkä yurge ti. ");
INSERT INTO jum_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Aŋ Yuucip wäyen ḍimgene gïtï, aŋ weekcin aŋ kunne yok. ");
INSERT INTO jum_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Aŋ Yuucip ñuuguloni yeeke iingene ogo wäyen tükkïï yokïn waak pïlkä ke ñownä nuŋko ŋana rotjeko, aŋ tükkï yokïn. ");
INSERT INTO jum_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Aŋ ike nääkin nïïnkä caykä kä ŋan, i tükü yokïn kä waak pïlkä ke ñownä, aŋ a nïïnkä yaaka a ḍoocin tutene me m'ana a tüwon ye. Aŋ mä Macïr nüüññü nïïnkä caykä kä ŋaṭükel. ");
INSERT INTO jum_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Aŋ wääna nïïnkä nüüjdüŋ baakkenee kä ye, i Yuucip ḍuuŋkulen yek Parahuun kiinne ogo, “Naana ika käñä ŋerrä ikee ti ye, i kura jiik yaakki icke Parahuun. ");
INSERT INTO jum_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Wäyo ika daljana lïïttä, aŋ ika kiinna ogo, ‘Ika cokulunu tüwnü, aŋ jïgja ṭuum yaana tutkunu ḍoŋi ŋommañ mä Kanaan ye ti wïca.’ Aŋ aŋŋi dalä ika kura atä wäyo jïkä ïñï aŋ ika bi ḍuuku.” ");
INSERT INTO jum_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Aŋ Parahuun luukcin ogo, “Ee, atä wääc jïgä bata yaana daljeney kä lïïttïï kä ye.” ");
INSERT INTO jum_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Aŋ Yuucip attä wäyen jïge. Aŋ ḍuuŋkulen muure yek Parahuun attä iken ke me mäyken muure yek ŋommañ mä Macïr, ");
INSERT INTO jum_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","aŋ cäänna ke mä äntüke yek Yuucip muure ke mädgen ke mä äntüke yen wäyen. Büccïdï a merkälen ke ḍiik ke däk yeeken ken dalji ïñï pääken baan mä Jiicaan jï. ");
INSERT INTO jum_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Aŋ attä kä teebälaŋŋi yek bägälgä kääygä ke m'aka taabit bägälgä ye, aŋ a ṭoŋ ḍiirken. ");
INSERT INTO jum_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Aŋ wääna ḍäägene ti nänṭä keennä päk Adaat wii mä Üürdün taaŋŋañja kä ñomuk ye, iken nüüjjïn kä yaac kä nüüjdüŋ mooye, aŋ iken nüüññü nïïnkä kä ŋaṭükel kä wäyen. ");
INSERT INTO jum_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Aŋ wääna mä Kanaan yuṭṭene nüüjdüŋ nänṭä keennä päk Adaat ye, iken jaajjin ogo, “A nüüjdüŋ mooye mä Macïr ti.” Ina ken nänṭä yaana Üürdün taaŋŋañja kä ñomuk batte daa me ogo Abil Macïr yaanna. ");
INSERT INTO jum_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Aŋ merkä Yaagüüp näŋjin bata yaana daa kiinneeda kä ye. ");
INSERT INTO jum_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Aŋ gaane koowi aŋ iji ŋommañ mä Kanaan jï, aŋ jïgï ṭuum yaana yiil Makapeela jï ye, cokulaŋ ti Mamar, nänṭ'a kiyi Abrayiim Aproon yen mä Haat ti ye, ogo nänṭä jïïgïn. ");
INSERT INTO jum_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Aŋ wääna Yuucip wäyen jïkkeeda ïñï ye, ike ḍukcin Macïr ke mädgen ke m'aka äätene jïŋŋä wäyen ti ye muure. ");
INSERT INTO jum_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Aŋ wääna Yuucip mädgen wäyen yoorene daa kä tüwnee ye, iken jaajjin ogo, “Yuucip ïkïïn bi pütkïn gïtï kä yiñ yaana näŋkïnïn daa ina.” ");
INSERT INTO jum_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Aŋ iken tuccin jiik Yuucip ti ogo, “Wääc ikoon iingonon i batta mor tüw, ");
INSERT INTO jum_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","aŋ jaay ogo, ‘Kura mädgic kulku kä nääŋkä yaackä ke yiñ yeenen yaana näŋgini kä ye.’ Aŋ tiññaŋ kura kulkoon kä nääŋkä yaackä yooko, ikoon agon kiinkä Jooŋ yen wääc.” Aŋ Yuucip weekcin wääna kiinene daa mädgen aŋan ye. ");
INSERT INTO jum_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Aŋ mädgen muure äätin ti ike ti aŋ ḍiimdin ïñï ñome ti, aŋ jaajjin ogo, “Ikoon agon kiinkä yüükü.” ");
INSERT INTO jum_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Aŋ Yuucip jaajjin iken ti ogo, “Ŋana ikee booje kä ika. Halla ika cääyä nänṭä Jooŋ? ");
INSERT INTO jum_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ikee ika näŋgana yiñ, aŋ ṭaaki Jooŋ naŋŋe a ŋerrä, ogo tïïcco ko üṇṇü yen me ḍiirken yaaka a üdïn tiññaŋ yaakki. ");
INSERT INTO jum_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ŋana ikee booje, ikee bi tïïje ke merkä yeekic.” Aŋ lüüyne juuggin kä jiik ŋerkä yaaka täpcin ti juuggen ti ye. ");
INSERT INTO jum_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Aŋ Yuucip mor daa cääy Macïr ke mä äntüke yen wäyen. Aŋ yuunge aŋŋa 110. ");
INSERT INTO jum_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Aŋ ike cääynä ke yuṭe merkä yek Ipiraayim ke merkä yeeken. Aŋ ike cääynä ke yuṭe merkä yek Makïïr minneni Manacca aŋ ken naŋŋe a yeeke. ");
INSERT INTO jum_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Aŋ Yuucip mädgen kiinne ogo, “Ika cokulunu tüwnü, Jooŋ bi ätä ikee ooke a gïtken, aŋ ikee bi koowe baan yaanni ti, aŋ ikee bi ije baan yaana lïïtkenee Abrayiim ke Icaak ke Yaagüüp ye ti.” ");
INSERT INTO jum_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Aŋ Yuucip mä Icärayiil kiinne ogo ike lïïtkïï, aŋ kiinne ogo, “Jooŋ bi ätä ikee ooke a gïtken, aŋ äwgi koowe winni aŋ ije.” ");
INSERT INTO jum_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Aŋ Yuucip tüwnü i yuunge a 110. Aŋ gaane tükkï me yok waak pïlkä ke ñownä nuŋko ŋana rotjeko, aŋ ḍooci me kuun jïŋŋä yeene jï Macïr.");
INSERT INTO jum_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Perrä yaanni a yen Yeecüwa Macii dänkä yurge, a kaaynä Daawüüt ke Abrayiim, ");
INSERT INTO jum_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrayiim a Icaak wäyen, Aŋ Icaak a Yaagüüp wäyen, aŋ Yaagüüp a Yahüüja wäyen ke mädge, ");
INSERT INTO jum_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","aŋ Yahüüja a Paaric wäyen ke Jüra meen a Taamaar, aŋ Paaric a Hïjïroon wäyen, aŋ Hïjïroon a Aaraam wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","aŋ Aaraam a Amïnadaap wäyen, aŋ Amïnadaap a Naac wäyen, aŋ Naac a Caalim wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","aŋ Caalim a Buwaac wäyen meen a Raahaap, aŋ Buwaac a Ubeet wäyen meen a Rawüüc, aŋ Ubeet a Yecce wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","aŋ Yecce a Yätkä Daawüüt wäyen. Aŋ Daawüüt a Cïlïmaan wäyen kä iŋ Üürïya ti, ");
INSERT INTO jum_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","aŋ Cïlïmaan a Raabaam wäyen, aŋ Raabaam a Abïïya wäyen, aŋ Abïïya a Acaap wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","aŋ Acaap a Yucapaat wäyen, aŋ Yucapaat a Yüraam wäyen, aŋ Yüraam a Üüjïya wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","aŋ Üüjïya a Yütaam wäyen, aŋ Yütaam a Ahaac wäyen, aŋ Ahaac a Hijakïya wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","aŋ Hijakïya a Manacca wäyen, aŋ Manacca a Amüün wäyen, aŋ Amüün a Yüücïya wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","aŋ Yüücïya a Yükünïya wäyen ke mädgen waan yen näpkïtïn ti Baabïl. ");
INSERT INTO jum_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aŋ wääna näpkïtïn ti Baabïl ye, Yükünïya a Caaltïïl wäyen, aŋ Caaltïïl a Jarabaabïl wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","aŋ Jarabaabïl a Abïyüüt wäyen, aŋ Abïyüüt a Ïlïyakïïm wäyen, aŋ Ïlïyakïïm a Ajüür wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","aŋ Ajüür a Caadik wäyen, aŋ Caadik a Akkïïm wäyen, aŋ Akkïïm a Alïyüüt wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","aŋ Alïyüüt a Ïlïyaajar wäyen, aŋ Ïlïyaajar a Mattaan wäyen, aŋ Mattaan a Yaagüüp wäyen, ");
INSERT INTO jum_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","aŋ Yaagüüp a Yuucip wäyen or Märïyam, yaana gittä Yeecüwa, yaana battä me ogo Macii ye. ");
INSERT INTO jum_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aŋ kilkä muure yaaka juwu Abrayiim ti atee ke Daawüüt ti ye kilkä kä caay witken kä ŋan, aŋ yaaka juwu Daawüüt ti atee ke näpkïtïn ti Baabïl ye kilkä kä caay witken kä ŋan, aŋ yaaka juwu näpkïtïn ti Baabïl atee ke Macii ti ye kilkä kä caay witken kä ŋan. ");
INSERT INTO jum_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Aŋ giidä yen Yeecüwa Macii näŋŋä ḍoŋe kä waan yaanni ogo aŋŋi. Wääna meen Märïyam wuuke daa Yuucip ye, i mor iken yoken batta coorgu, kañi me cäyge minneni kä Wääktäŋ Laṇṇä yen Jooŋ. ");
INSERT INTO jum_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aŋ oore Yuucip, ike a män woṇṇu, aŋ batta ṭäkï iccede loon gïtï aŋ ike jaajjin jone ti ogo daljebu liidid. ");
INSERT INTO jum_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aŋ wääna ike paydee kä aŋan ye, i malak yen Pïṭo üükïn woo ike ti kä lääggï, aŋ ike kiini ogo, “Yuucip, minneni Daawüüt, ŋana ïkï booju kä koownu Märïyam ogo ïïŋü, a Wääktäŋ Laṇṇä ken ina laaccee kä yaanna. ");
INSERT INTO jum_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aŋ ike bi giit minneni, aŋ bi äkkä yäṇtäŋ ogo Yeecüwa a yaana bi määkee kä woo mä yeeke kä nääŋken yaacken ye.” ");
INSERT INTO jum_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aŋ yaakki muure näŋŋä ḍuuggen ḍääkit jiik'a jaayi Pïṭo kä bäṭo ye ogo, ");
INSERT INTO jum_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yoore, ṭuul yaana kücï oon ye, bi laacï aŋ bi giit minneni, aŋ bi battä me ogo Ïmaanuwel,” aŋ naana aŋan ye, i ogo, “Jooŋ ke ïkïïn.” ");
INSERT INTO jum_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aŋ wääna Yuucip cuuyenee kä nïïnkä ti ye, ike näŋjin bata yaana daa kiinene daa malak yen Pïṭo ye, aŋ iiŋe koowne, ");
INSERT INTO jum_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","aŋ yoken batta agene kä coorgin ke iiŋe giide minneni. Aŋ äkki Yuucip ogo Yeecüwa. ");
INSERT INTO jum_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aŋ wääna Yeecüwa giidene daa me Beetlaam baan Yühüdïya ye, a nïïnkä Yätkä Ïïrüüdüc ti. Aŋ ook yakkalaŋ a ŋäjjoni ätä ñomuk äätin Oorcalïïm, ");
INSERT INTO jum_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","aŋ tääccin ogo, “Wali m'ana a giiton a yätkä yen Yühüüṇṇï ye? Kiṭṭä yeene yoorron wääna kääjenee kä ñaalok ye aŋ ikoon äätodon ike maaŋon.” ");
INSERT INTO jum_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aŋ wääna yätkä Ïïrüüdüc tiiŋŋee kä aŋan ye, i ike ṭeeŋŋä, ke mä Oorcalïïm muure. ");
INSERT INTO jum_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aŋ ike ḍuuŋku däŋkä ke nüütoni jiik ḍoocin yek Jooŋ bärkene ti muure aŋ tääckene ti ogo, “Macii bi giitä me a wa?” ");
INSERT INTO jum_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aŋ luugi me ogo, “A Beetlaam baan Yühüdïya jï, a pergon kä bäṭo ogo, ");
INSERT INTO jum_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Aŋ ïkï, Beetlaam, ŋommañ yen mä Yühüdïya ti, ïkï batta ḍeeḍäḍeeṭ bänkä mäyken yek mä Yühüdïya ti, aŋ ïkï ti mäŋkalaŋ bi ätä a mügdo yaana bi kääjï mä yeeki yek mä Icärayiil ye.’” ");
INSERT INTO jum_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aŋ Ïïrüüdüc ŋäjjoni bärkene ti kä ätkïtïn ukcenee gïtï a tooku ken üükene woo kiṭṭä. ");
INSERT INTO jum_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aŋ tucce Beetlaam aŋ kiinne ogo, “Ate aŋ minneni maawe ṭeṭaŋ. Aŋ naana kaññe ye, i ika icka jiik, aŋ cäänna ika bi atä maaŋä.” ");
INSERT INTO jum_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aŋ wääna tiiŋŋene jiik yätkä ye, i iken ättä kä päy yeenen. Aŋ, kiṭṭä yaana yoori ina üükïn woo aŋ iken wooyi ke yuutee ïñï nänṭä minneni. ");
INSERT INTO jum_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Aŋ wääna kiṭṭä yooṭene daa ye, iken juuggen ñappä kä jon ñammä mooye! ");
INSERT INTO jum_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aŋ iken kaaccä äräk aŋ minneni yoori ke meen Märïyam, aŋ ḍüŋgï ïñï aŋ maaŋi. Aŋ iken kücümgü yeeken kupki aŋ ääcin woo iccin a tiilgä ke ḍukpïlkä ke panḍeyni. ");
INSERT INTO jum_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aŋ iken koli Jooŋ kä lääggï ogo ŋana ḍukcodo Ïïrüüdüc ti, aŋ iken ḍukcin baannen kä päy yaŋkalaŋ. ");
INSERT INTO jum_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aŋ wääna ŋäjjoni ḍakkene kä ye, i malak yen Pïṭo üükïn woo Yuucip ti kä lääggï aŋ kiinne ogo, “Juwu, minneni koowu ke meen, aŋ yïïŋä Macïr, aŋ cääye wïca ke nüütke kä, winni Ïïrüüdüc minneni maawe, ṭäkke näge ḍok.” ");
INSERT INTO jum_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aŋ ike juwin minneni koowne ke meen kä mïïllä aŋ yïïŋŋe Macïr. ");
INSERT INTO jum_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aŋ cäygin wïca ke Ïïrüüdüc tüwe. Yaakki ḍääkit yaaka jaayi Pïṭo kä bäṭo ye ogo, “Ika bääṭänä woo minneni yeeni Macïr jï.” ");
INSERT INTO jum_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aŋ Ïïrüüdüc, wääna yoorreeda ike malene daa ŋïngïn ŋäjjoni ye, ike pennä kä yaac aŋ ike tuccin kääygä aŋ merkälen oogen näŋgi ḍugin muure, yaaka Beetlaam ye ke bänkä yaaka cokulaŋ ti ye, yaaka yuungen kä yewweni ke ïñï ye, kä waan yaana ookke gïtï ŋäjjoni ti kä üükïn woo kiṭṭä ye. ");
INSERT INTO jum_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aŋ ken ḍääkit yaaka jaayi bäṭo Ïrmïya ye ogo, ");
INSERT INTO jum_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Yääw tiiŋin Raama ïwok ke nüüjdüŋ mooye. Aŋ Rahiil week ogo merkä yeeke, ike yaakkä kä lüüynü jok ogo iken baawkono.” ");
INSERT INTO jum_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aŋ wääna Ïïrüüdüc tüwnee ye, i malak yen Pïṭo üükïn woo Yuucip ti kä lääggï Macïr. ");
INSERT INTO jum_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Aŋ kiinne ogo, “Juwu, minneni koowu ke meen aŋ ate ŋommañ yen mä Icärayiil, m'aka ṭäkï nääkä minneni ye tüwgïn.” ");
INSERT INTO jum_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aŋ ike juwin aŋ minneni koowne ke meen aŋ attä ŋommañ yen mä Icärayiil ti. ");
INSERT INTO jum_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aŋ wääna Yuucip tiiŋŋe ogo Aarkalayüüc mükko yätkïtïn Yühüdïya nänṭä wäyen Ïïrüüdüc ye, i ike booññu kä ḍukcin wïca, aŋ koli lääggï, aŋ ike attä baan mä Jalïïl. ");
INSERT INTO jum_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aŋ ike attä aŋ cääynä baan yaana battä me ogo Naacira ye. Aŋ a yaaka jaayi bäṭoni ye ken ḍääkit ḍuuggen ogo, “Ike bi battä me ogo män Naacira.” ");
INSERT INTO jum_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nïïnkä yaakca ti Büüṭo Yaaya äätin nüütï me kä jiik Jooŋ woo teettälaŋ baan mä Yühüdïya jï. ");
INSERT INTO jum_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Aŋ ike me päkkede ogo, “Ḍage, kä nääŋkä yaackä yeekic aŋ ḍuuke Jooŋ ti, Yätkïtïn Polloŋ jïñe a cokïlïnï.” ");
INSERT INTO jum_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aŋ a Yaaya ken jaaynene kä bäṭo Ïcaaya ogo, “Mäŋkalaŋ yaaw woo teettälaŋ wïca ogo, ‘Päy toote yok yen Pïṭo aŋ dale wotï woo.’ ” ");
INSERT INTO jum_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Aŋ Yaaya a jiik ṭakin yek kälämgä ken eŋde, aŋ ḍekcede ti kä boṇṇan teye ti, aŋ a ṭääŋgä ke kickä ken a waak äämkä yeeke. ");
INSERT INTO jum_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Aŋ umkutu m'aka cäyok wii mä Üürdün ḍoŋe ti ye, ke mä Yühüdïya muure ke mä Oorcalïïm. ");
INSERT INTO jum_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ike umkutu päkkätä nääŋkä yaackä yeeken, aŋ büüle wii mä Üürdün jï. ");
INSERT INTO jum_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aŋ wääna Yaaya mä Pïrrïcïïnnï ke mä Cüddügïïnnï yoorreeda äätete ike ti kä ḍiräk ogo iken büüljï ye, kiinne ogo, “Ikee merkä käggä! A ŋaani ken ikee kolle ogo ikee buurcee woo ko piinkä Jooŋ yaaka ääto ye? ");
INSERT INTO jum_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Näŋe käwkä yaaka nüütï ogo nääŋkä yaackä dallee buw aŋ ikee ḍuukenee Jooŋ ti ye. ");
INSERT INTO jum_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aŋ ikee ŋana ḍuuggic ḍooje ogo wääc ogo Abrayiim. Ikee kiine Jooŋ lïïṭï näŋï pämkä yaakka ti a merkä yek Abrayiim. ");
INSERT INTO jum_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aŋ tiññaŋ len a nüüton ti jengä bïcïŋgenen ti, aŋ jaan yaana giit ṭulge yejgaŋ ye, tääyänä me woo aŋ yeepänä me maccük. ");
INSERT INTO jum_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“M'aka nääŋkä yaackä yeeken dali buwin aŋ ḍuukin ŋäjäk Jooŋ ti ye, ken büülü kä piik. Aŋ m'ana bi ätä ŋäñi ti ye, ike ika bora kä teynä, aŋ ika yoku batta päjjädä agä kiingon yeene yaana yoku päjjïdï ädit waygä yeeke ye. Ike ikee bi büüle kä Wääktäŋ Laṇṇä yen Jooŋ ke maañ. ");
INSERT INTO jum_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aŋ kuun yeene a ïṇte ti kuujjedee kä woo külkï päk gïtï, aŋ taga yeene wiñe bi laate woo, aŋ päk yeeke bi ḍülje tuññu jï aŋ külkï bi tuñge maañ yaana batta tüwït ye.” ");
INSERT INTO jum_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aŋ wäättana Yeecüwa äätin kä ḍoŋe ätä Jalïïl atï wii yen mä Üürdün büülgü Yaaya. ");
INSERT INTO jum_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aŋ Yaaya yaakï aŋ kiinne ogo, “Ika ṭäkä büülja kä ïkï, aŋ ïkï ken äätä ika ti ogoo?” ");
INSERT INTO jum_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aŋ luugi Yeecüwa ogo, “Dalä jiik yaakka wäätï aŋan, nuŋko nääŋkä yaaka ṭäkkänä Jooŋ ye, näŋene ḍuuggen.” Aŋ Yaaya gïmmïn. ");
INSERT INTO jum_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aŋ Yeecüwa büüṭṭü aŋ kääjin woo piitti. Aŋ wina polloŋ yore kupkene, aŋ Wääktäŋ Jooŋ yooṭṭe küüyïdï ïñï ike ti kä biilkä gülküte aŋ koojjin ike ti. ");
INSERT INTO jum_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aŋ jiik jääyin ñaalok polloŋ jï ogo, “A Minneni yeeni, yaana bilgä ñapeñap joni ye, inni.” ");
INSERT INTO jum_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aŋ Yeecüwa koowi Wääktäŋ Jooŋ iññe woo teettälaŋ ogo püüccï booŋïn. ");
INSERT INTO jum_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aŋ büüṭṭü nïïnkä caykä kä ŋan äŋkä gïtken ke mïlkä gïtken, aŋ näägi käñ. ");
INSERT INTO jum_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aŋ booŋïn äätin ike ti aŋ ike kiini ogo, “Naana ïkï agä Minneni Jooŋ ye, pämkä yaakka kiinä dalä wäätï a bïggï.” ");
INSERT INTO jum_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aŋ luugi Yeecüwa ogo, “A pergon Meeŋka Jiik Jooŋ jï ogo, ‘Batta a gin äämkä pare ken mänbaan ḍooje, a jiik'a jaaygä Jooŋ ye, ken mänbaan ḍooje.’ ” ");
INSERT INTO jum_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aŋ koowi booŋïn iññe baan laṇṇä yen mä Oorcalïïm ti, aŋ yuutte änlaṇṇä yen Jooŋ leŋŋe ti ñaalok. ");
INSERT INTO jum_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aŋ kiinne ogo, “Naana ïkï agä Minneni Jooŋ ye, ḍoŋü yeepci ïñï, a pergon Meeŋka Jiik Jooŋ jï ogo, ‘Malaŋŋi yeeke bi iingee jiik ogo ïkï, aŋ ïkï bi tïïjjïda, aŋ ïkï bi ḍürdïda ñaalok ïnken ti, nuŋko ŋana tojdïda ko pääm kïyü ti.’ ” ");
INSERT INTO jum_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aŋ luugi Yeecüwa ogo, “Cäänna a pergon Meeŋka Jiik Jooŋ jï ogo, ‘Ŋana Pïṭo Jooŋ yüünü puuccudu.’ ” ");
INSERT INTO jum_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aŋ iji booŋïn ñaalok pääm bääynä ṭïṭṭe ti, aŋ nüütkene waak yek yätkïtïnnï yek ŋommañ wiñe muure ke waak'a yäwaŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aŋ kiinne ogo, “Wakkä yaakka muure bi iñenii kä, naana ika ḍüŋganaa ïñï aŋ ika maaŋŋaa ye.” ");
INSERT INTO jum_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aŋ luugi Yeecüwa ogo, “Wükcü woo ika ti wiñ yen meŋkeekeni! A pergon Meeŋka Jiik Jooŋ jï ogo, ‘Pïṭo Jooŋ yüünü ken ḍüŋgüdü ïñï, aŋ ike pare ken maaŋä.’ ” ");
INSERT INTO jum_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aŋ mañji ïñï booŋïn, aŋ malaŋŋi äätin ike yüükkï ti. ");
INSERT INTO jum_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aŋ wääna Yeecüwa tiiŋŋee kä ogo Yaaya müŋŋïï me aŋ üüljïnïï me ye, ike ḍukcin ŋommañ mä Jalïïl ti. ");
INSERT INTO jum_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Aŋ Naacira daljene ïñï, ike attä cääynä Kaparnahuum kä koon mooye taaŋ, ŋommañ mä Jaabïloon ke Naptaalï ti. ");
INSERT INTO jum_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aŋ yaakki ḍääkit yaaka jaayi bäṭo Ïcaaya ye ogo, ");
INSERT INTO jum_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ŋommañ mä Jaabïloon ke Naptaalï, koon mooye taaŋ wii mä Üürdün taaŋŋañja, Jalïïl yaana cäyene boorgu ye. ");
INSERT INTO jum_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","M'aka cäyok mïïllä gïtï ye, yuṭṭu bownu mooye. Aŋ m'aka cäyok ṭïïbbä tüwnü ti ye, bownu diikin ïñï iken ti.” ");
INSERT INTO jum_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Waan yaanja ti Yeecüwa juwin kä paŋŋä ogo, “Ḍage kä nääŋkä yaackä yeekic aŋ ḍuuke Jooŋ ti, Yätkïtïn Polloŋ jïñe cokilin.” ");
INSERT INTO jum_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Aŋ wääna Yeecüwa äätee kä koon mooye yen mä Jalïïl taaŋŋe ti ye, ike yurcin mädin kä yewwe, Camaan yaana battä me ogo Bütürüc ye ke määden Aṇdaraawuc. Aŋ yïïpcïdï ääŋ piitti, iken a m'aka müügü yak ye. ");
INSERT INTO jum_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aŋ kiinne ogo, “Ääte, bääte ika ti, aŋ ikee bi nüütke müüŋŋü me bata yaana müüge kä yak ye.” ");
INSERT INTO jum_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aŋ wina äŋkä yeeken dalji ïñï aŋ bäätcin ike ti. ");
INSERT INTO jum_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aŋ wääna atene kä ye, ike yurcin mädin yakkalaŋ kä yewwe ŋuca. Yaagüüp män Jabadï ke määden Yuhanna, cäyok kuun jï ke wäyen Jabadï, tütï äŋkä yeeken. Aŋ bärki Yeecüwa. ");
INSERT INTO jum_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aŋ wina kuun yeenen dalji ïñï ke wäyen aŋ bäätcin ike ti. ");
INSERT INTO jum_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Aŋ Yeecüwa attä laaynä Jalïïl jï muure, aŋ nüütï daaŋmallä yen Yühüüṇṇï jï, aŋ päkï kä Jiik Ŋerkä yen Yätkïtïn Polloŋ jïñe. Aŋ ṭïïñï yor carre ke rackïtïn muure waadgä mäbaan. ");
INSERT INTO jum_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Aŋ ŋäjji me aŋ yäṇtonḍe ḍakkä ke Cüürïya jï muure, aŋ m'aka a rackä ye, äbi me ike ti yaaka cäyge rackïtïnnï a päkkitṇi ke pillä yoken ti ye, ke yaaka cäygene meŋkeekeni ye, ke yaaka tüwdïdï ye, ke yaaka ämgen ke buggen a tüwïn ye, aŋ ṭeeññe muure. ");
INSERT INTO jum_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aŋ ṭoŋ diirken bäätcin ŋäñe ti mä Jalïïl ke Bänkä Caay, ke Oorcalïïm ke Yühüdïya, ke wii mä Üürdün taaŋŋañja. ");
INSERT INTO jum_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aŋ wääna Yeecüwa yuṭṭee kä ṭoŋ diirken ye, ike attä pääm wic, aŋ cääjjin ïñï. Aŋ baaddoni yeeke äätin ike ti, ");
INSERT INTO jum_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","aŋ ike uccin kä paŋŋä aŋ kiinne ogo, ");
INSERT INTO jum_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ñaaynä m'aka a aangï kä wääktäŋ ye ti, Yätkïtïn Polloŋ jïñe a yeenen. ");
INSERT INTO jum_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ñaaynä m'aka nüüjï ye ti, iken bi lüüygü me jugin. ");
INSERT INTO jum_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ñaaynä m'aka ḍuuggen ḍuukcutu ïñï ye ti, iken bi yätï ŋommañ wiñe muure. ");
INSERT INTO jum_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ñaaynä m'aka näkä käñ ke yeen kä woṇṇu ye ti, iken bi bur. ");
INSERT INTO jum_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ñaaynä m'aka ängïdï ŋïngïn ye ti, iken bi ängänä me ŋïngïn. ");
INSERT INTO jum_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ñaaynä m'aka juuggen ladaŋ ye ti, iken bi Jooŋ yoorgu. ");
INSERT INTO jum_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ñaaynä m'aka näŋï ŋïïbbïn ye ti, iken bi battä me ogo merkä yek Jooŋ. ");
INSERT INTO jum_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ñaaynä m'aka putkunu me gïtï kä woṇṇu yeenen ye, Yätkïtïn Polloŋ jïñe a yeenen. ");
INSERT INTO jum_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ñaaynä ikee ti naana ikee kirge me, aŋ ikee putkene me gïtï, aŋ ikee käkkete me witin kä yiñ ogo ika ye. ");
INSERT INTO jum_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Juuggic ñapï kä yaac, nääŋka iñdin yeenic yäwconḍe agee kä polloŋ jï ye, aŋ cäänna bäṭoni yaaka ñomgic ti ye putki gïtï aŋan. ");
INSERT INTO jum_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ikee age äyyä yek ŋommañ wiñe. Aŋ naana äyyä lämme yääynä ye, bi läpï ïñï ogoo ŋuca? Batta ŋuca päjjïdï ginkalaŋ ti, päjjïdï yeepänä me woo aŋ määrjänä me ïñï kä me kïïgen. ");
INSERT INTO jum_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ikee age diktäŋ yen ŋommañ wiñe. Baan mooye yaana pääm wic ye batta lïïlgä me kä paannä yok. ");
INSERT INTO jum_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aŋ baati m'ana diko paaŋe aŋ küme wic kä arwal ye. Ike ṭääkcï diko ḍooce nänṭ'a yuddee kä ye, aŋ ääcïdï diktäŋ me ti muure yaaka äräk ye. ");
INSERT INTO jum_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Cäänna dalä diktäŋ yüünü dïkï me ñomgen ti, nuŋko nääŋkä ŋerkä yüükü yoorge daa me aŋ mäŋene me Wääc yaana ñaalok polloŋ jï ye. ");
INSERT INTO jum_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ŋana ikee ḍuuce ogo ika äätonoo aŋgodoo yokïn jiik ḍoocin yek Müüca ke yaaka peri bäṭoni ye, ika batta aŋgädä yokïn, ika äätänä ḍääktä. ");
INSERT INTO jum_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ikee kiine a gïtken aŋŋa polloŋ ke ŋommañ baakke, baati ŋïcole ke ṭomṭom yaana bi käjä woo jiik ḍoocin yek Jooŋ ti ye, ke wakkä muure ḍagene. ");
INSERT INTO jum_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","M'ana jiik ïïnïnïle kä keelok liiŋŋe gïtï aŋ me nüüṇṇe kä päy yeene ye, bi battä me ogo men ḍeerconḍe Yätkïtïn Polloŋ jï ti, aŋ m'ana nääŋin kä jiik ïïnïnï yek Jooŋ aŋ nüütee ye, bi battä me ogo men mooye Yätkïtïn Polloŋ jï ti. ");
INSERT INTO jum_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ikee kiine naana nääŋkä ŋerkä yeekic batta käälcïdï woo yek Pïrrïcïïnnï ti ke nüütoni jiik ḍoocin yek Jooŋ ye, ikee batta bi kaace ti Yätkïtïn Polloŋ jï ti. ");
INSERT INTO jum_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tiiŋŋe kiinnene me dänkä yurgo yaaka kä on ye ogo, ‘Ŋana ïkï nääkä me, aŋ m'ana näkkä men ye päjjïdï joocu me.’ ");
INSERT INTO jum_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Aŋ ikee kiine m'ana a penon kä määden ke käwen ye, päjjïdï joocu me, aŋ m'ana määden kirre ogo, ‘Waanjï’ ye päjjïdï ḍoocunu me ïñï nänṭä ba' küüllü. Aŋ m'ana määden kirre ogo, ‘Booñ’ ye i päjjïdï atï maccük. ");
INSERT INTO jum_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Aŋ naana ïkï äccädä iccin tambal daaŋ laṇṇä jï, aŋ ïkï päjjini määdic ke käwic yaŋkalaŋ ikee age büültïnï ye, ");
INSERT INTO jum_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","gin yüünü daljä tambal ñome ti aŋ atä por cuure ke määdic, aŋ wäättan ḍuuku iccin yüünü iñä Jooŋ. ");
INSERT INTO jum_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Jiik toode kä bïraŋ ke cïŋdo yüünü yaana ïkï ijey nänṭä ba' jooññu ye, naŋe i mor ikee ääte päy jï, i mor batta ïkï ḍaakey ti juco ti, aŋ juco ïkï iñey tïïco, aŋ tïïco ïkï yeepey gaŋgar jï. ");
INSERT INTO jum_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ïkï kiineni a gïtken, ïkï batta bi kääjä woo gaŋgar jï ke gin yüünü yaana buccin ye, icceeda muure. ");
INSERT INTO jum_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ikee tiiŋŋe jaaye me ogo, ‘Ŋana ïkï näŋdä balkïtïn.’ ");
INSERT INTO jum_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Aŋ ikee kiine, m'ana däämjin iiŋ ti kä poŋ kääcinene ye, i ḍaŋŋa näŋŋä balkïtïn jone ti. ");
INSERT INTO jum_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Naana a waŋü birrä ken ïkï pugey ḍok kä yiñ ye, i luulu woo aŋ yeepci woo. Ŋeraŋ iiñca naana gïnü kalaŋ yääy ye, kä yaana gaanü muure yeepene daa me maccük ye. ");
INSERT INTO jum_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aŋ naana a ïṇtü birrä ken ïkï pugey ḍok kä yiñ ye, tocci woo aŋ yeepci woo. Ŋeraŋ iiñca naana gïnü kalaŋ yääy ye, kä yaana gaanü muure atee kä maccük ye. ");
INSERT INTO jum_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Cäänna jaayi me ogo, ‘M'ana iiŋe äkkene ye dale pirke meeŋka yen äkkin.’ ");
INSERT INTO jum_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aŋ ikee kiine, m'ana iiŋe äkkene i batta kä balkïtïn ye, i aŋan icce balkïtïn gïtï. Aŋ m'ana kuññu iiŋ yaana a äkkïnï ye, i aŋan näŋit balkïtïn. ");
INSERT INTO jum_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ŋuca tiiŋŋe kiinnene me dänkä yurgo yaaka kä on ye ogo, ‘Ŋana lïïttäŋŋi yüükü liigä gïtï ṭääkcä lïïttäŋŋi yüükü ḍaage ke Pïṭo.’ ");
INSERT INTO jum_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Aŋ ikee kiine ŋana ikee lïïte! Ŋana kä polloŋ a nänṭä ba' nook yen Jooŋ, ");
INSERT INTO jum_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","aŋ ŋana kä ŋommañ a nänṭä yaana ḍucee kä kïïge ye, aŋ ŋana kä Oorcalïïm a baan mooye yen yätkä yaana yäwaŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aŋ ŋana ïkï lïïtä kä wïñü ïkï batta lïïṭä näŋä jiikcan bownu ke yen üllü. ");
INSERT INTO jum_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jiik'a jaayä ye dalä wodaŋ naana daa a ‘Ee,’ ye, i daa a, ‘Ee,’ aŋ naana daa a ‘Uʼu,’ ye, i daa a ‘Uʼu,’ aŋ yaaka ŋuccin ti yaakka ti ye, i ätä yiñ ti. ");
INSERT INTO jum_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Tiiŋŋe jaayi me ogo, ‘Waŋ ke waŋ aŋ leŋŋä ke leŋŋä.’ ");
INSERT INTO jum_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Aŋ ikee kiine, män yiñ ŋana daŋde kä yiñ. Aŋ m'ana ïkï paccey taaŋŋü birrä ti ye, i menen ṭukkeeda kä ŋuca. ");
INSERT INTO jum_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aŋ m'ana ṭäkï ïkï cïŋey ogo ike iñjey burŋu jone ye, i iñjeeda ke burŋu mooye cäänna. ");
INSERT INTO jum_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aŋ naana ïkï ïïrgï kääygon ogo ike iiccey wuuŋ ko keelok ye, i ate ke ike wuuggu kä yew. ");
INSERT INTO jum_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aŋ m'ana ñujjin ïkï ti ye, i iñä. Aŋ m'ana ṭäkï kujit mïïngä ïkï ti ye, ŋana ṭïïgä. ");
INSERT INTO jum_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Tiiŋŋe jaayi me ogo, ‘M'ana yiire kä ye bilgä aŋ ädäŋ yüünü putku jï.’ ");
INSERT INTO jum_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aŋ ikee kiine ogo, ädäŋŋi yeekic bilge, aŋ mäṭe kä m'aka ikee putkene gïtï ye, ");
INSERT INTO jum_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","nuŋko bi wääte kä age merkälen yek Wääc yaana ñaalok polloŋ jï ye. Aŋ äŋ yeene naŋŋe kääjïdï ogo mä yaackä ke mä ŋerkä, aŋ ñaal yeene tuujede ogo mä wotku ke m'aka batta wodaŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Aŋ naana ikee bille m'aka ikee bilgene ye, a iññä yaana wali ye ken bi kañe? Aŋ yaakka batta a yaaka naŋtä ḍüṭoni yaacken cäänna ika? ");
INSERT INTO jum_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aŋ naana a mädgic ke käwgic pääken ken ŋïïbde ye, wali nääŋkä yeekic yaaka naŋde buṭe kä me ye? Aŋ yaakka batta a yaaka naŋtä waanjïnï cäänna ika? ");
INSERT INTO jum_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ikee dale age küümïn bata Wääc yaana ñaalok polloŋ jï, agee kä küümon kä ye. ");
INSERT INTO jum_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Waŋgic tïïce ŋana ŋerrä yeenic naŋde me ñomgen ti, ogo yoorjï me. Naana ikee nääŋe aŋan ye, ikee batta bi cäygene kä iñdin Wääc yaana ñaalok polloŋ jï ye ti. ");
INSERT INTO jum_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aŋ naana ïkï iñdä m'aka ṭäkï ye, ŋana nüddü kä yääw gülteteni me ñomgen ti bata yaana naŋtä lääñoni daaŋmallä yen Yühüüṇṇï ti, ke pääygä gïtï ogo iken maaŋjï me yokïn ye. Ikee kiine a gïtken, a iññä yeenen dune ina. ");
INSERT INTO jum_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Naana ïkï iñdä aangon ye, ïṇtü aam ŋana bääggädä ŋäjjä gin'a naŋtä ïṇtü birrä ye, ");
INSERT INTO jum_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","nuŋko iccin yüünü wäätee kä a paangon yok, aŋ Wääc yaana yuṭit waak muure yaaka a paangin yokïn ye, ken ïkï bi iñey. ");
INSERT INTO jum_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aŋ naana ikee mäṭe ye, ŋana ikee beele bata lääñoni. Iken billä mäṭï i yudok ñaalok daaŋmallä yen Yühüüṇṇï ti, ke yoggonni yek pääygä ti ogo iken yoorjï me. Ikee kiine a gïtken, a iñdin yeenen dune ina. ");
INSERT INTO jum_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Naana ïkï mäṭä ye kaacci äräk baannü aŋ äntüke üüljü, aŋ mäṭä Wääc yaana batta yoottu me ye ti. Aŋ Wääc yaana yuṭit waak muure yaaka a paangin yokïn ye, ken ïkï bi iñey. ");
INSERT INTO jum_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Aŋ naana ikee mäṭe ye, jiik'a a waanjï ye ŋana ŋoccede gïtï bata waanjïnï. Iken ḍüücï ogo iken bi tïïŋgïï Jooŋ ko jiik ḍiirken yeeken yaakka. ");
INSERT INTO jum_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ŋana ikee beeljede bata iken, Wääc ŋäjjä waak'a ṭäkke ye, i batta mor taaje. ");
INSERT INTO jum_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Mäṭe bata mallä yaanni ogo, Wäyo yaana ñaalok polloŋ jï ye, dalä Yäṇtonḍü wäätï a laṇṇä. ");
INSERT INTO jum_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Aŋ Yätkïtïn yüünü dalä ḍägä, aŋ ṭäktäŋ yüünü dalä wäätï ŋommañ wic bata yaana daa ñaalok polloŋ jï ye. ");
INSERT INTO jum_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Iñjon bïggï yooko yek äŋ yaanni jïñe. ");
INSERT INTO jum_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kulkoon ḍuuggen nääŋkä yaackä yooko bata yaana daa kulkodon kä m'aka ikoon näŋkoton nääŋkä yaackä ye. ");
INSERT INTO jum_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ŋana ikoon üüŋjodoon puuccinni gïtï, ṭääkcä määgoon woo yiñ gïtï. ");
INSERT INTO jum_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Aŋ naana me kulkudu kä nääŋkä yaackä yaaka näŋkiti ye, Wääc yaana ñaalok polloŋ jï ye, ïkï bi kulkey cäänna. ");
INSERT INTO jum_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aŋ naana me batta kulkudu kä nääŋkä yaackä yeeken ye, Wääc ïkï batta bi kulkey kä nääŋkä yaackä yüükü. ");
INSERT INTO jum_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Aŋ naana ikee büüṭe ye, ŋana ñomgic ñirde bata lääñoni, iken ñomgen ääkkätä, nüütkütü me ogo iken büüṭo. Ikee kiine a gïtken, a iñdin yeenen dune ina. ");
INSERT INTO jum_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aŋ naana ïkï büüṭü ye, jiikü püüjgü aŋ waŋgü püüjjü woo, ");
INSERT INTO jum_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nuŋko büültüŋ yüünü ŋana yootte daa me, dalä a Wääc yaana batta yoottu me yok ye ken yuṭit. Aŋ Wääc yaana yuṭit waak muure yaaka a paangin yokïn ye, ken ïkï bi iñey. ");
INSERT INTO jum_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ŋana ikee büüke waak ŋerkä ḍuckede ḍuuggic ŋommañ wic nänṭä yaana cüülge daa gïtï ḍiiḍini ke ḍuy ye, ke nänṭä yaana liikä gïtï käṭoni käṭene kä ye. ");
INSERT INTO jum_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ṭääkce büüke waak ŋerkä ḍucke ḍuuggic ñaalok polloŋ jï, nänṭä yaana ḍiiḍini ke ḍuy batta cüüṭï gïtï ye, ke nänṭä yaana batta liikä gïtï käṭoni käṭene kä ye. ");
INSERT INTO jum_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nänṭä yaana ḍuce kä waak ŋerkä yeekic ye, i juuggic daa a wïca cäänna. ");
INSERT INTO jum_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Waŋ a diko yen yor. Naana waŋgü ŋeraŋ ye, i yorü muure a küümon kä diktäŋ. ");
INSERT INTO jum_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aŋ naana waŋgü yejgaŋ ye, i yorü a küümon kä mïïllä. Aŋ naana diktäŋ yaana ïkï ti yaanna a mïïllä ye, i mïïllä yaanna bi yäwaŋ kä yaac! ");
INSERT INTO jum_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Baati m'ana wäätï a ñuugulo yen me mäyken kä yew ye, naana ye, i yaŋkalaŋ bi putke jï aŋ yaŋkalaŋ bi bilge, aŋ naana ye, i yaŋkalaŋ bi tiiŋgede aŋ yaŋkalaŋ bi gääle gïtï. Ikee batta lïïṭe age ñuuguloni yek Jooŋ ke tiil. ");
INSERT INTO jum_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ikee kiine a gïtken ŋana ikee payde jiik gïtkïc üṇṇü yeenic ti ogo, ŋaaka ken bi amje, aŋ ŋaaka ken bi maadje aŋ cäänna yokic ti ogo ŋaaka ken bi eŋdee. Üṇṇü batta büṭï witkin gin äämkä, aŋ gaan batta büṭï witkin buruŋgu? ");
INSERT INTO jum_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yoore por ḍïïrgä polloŋ jïñe iken batta pïïtï aŋ batta ïṭï, aŋ batta kuutit yokïn tuucku gïtï, aŋ Wääc yaana ñaalok polloŋ jï ye ken äämï iken. Aŋ ikee batta büṭa kääṭe kä yaac kä iken? ");
INSERT INTO jum_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","A ŋaani ken ikee ti kä paydin jiik jïñe yoku lïïṭï ŋüccï ti wuuŋ kä keelok üṇṇü yeene ti? ");
INSERT INTO jum_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Aŋ ikee päje jiik gïtkïc ogo buruŋgu ina? Yoore deykä yaaka yül woo ye iken batta ñuugal aŋ batta wïñï uṇtalli. ");
INSERT INTO jum_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Aŋ ikee kiine yätkä Cïlïmaan cekkïtïn yeene ti muure batta a eŋdïnï bata iken. ");
INSERT INTO jum_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aŋ naana Jooŋ deykä yaaka yül woo yaakka iiŋkede ye, yaaka a winni tiññaŋ aŋ tïṇṇäk yibjänä me maccük ye, ike batta bi kääṭï kä iiŋkin ikee? Aŋ ikee luggin yeenic ḍeeraŋ ina? ");
INSERT INTO jum_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ŋana ikee payde jiik gïtkïc aŋ ikee jaaye ogo, ‘A ŋaaka ken bi amïn?’ aŋ ‘A ŋaaka ken bi maatïn?’ aŋ ‘A ŋaaka ken bi eŋtïn?’ ");
INSERT INTO jum_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A wääkeni ken kälit waak yaakka ŋätin muure, aŋ Wääc yaana ñaalok polloŋ jï ye, ŋäjjä ogo ikee ṭäkce waak yaakka muure. ");
INSERT INTO jum_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Por ïïjje kälde Yätkïtïn yen Jooŋ ke woṇṇu yeene, aŋ waak yaakka muure bi ŋuckene kä me ti. ");
INSERT INTO jum_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Aŋ aŋan ikee ŋana payde jiik gïtkïc ogo tïṇṇäk, tïṇṇäk daa payit ḍoŋe. Äŋkä gïtken muure yaŋkalaŋ daa kä yiñ yeene yaana ike pääccätä ye. ");
INSERT INTO jum_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ŋana me jooje, nuŋko ŋana käñde kä jooññu. ");
INSERT INTO jum_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kä waan yaana juce kä me ye ken daa bi jooce kä me aŋ kä pääynä yaana pääje kä me ye ken daa bi pääjgene kä me. ");
INSERT INTO jum_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ïkï däämä luum yaana määdic ke käwic waŋe ti ye, aŋ jaan mooye yaana waŋü ti yaanna batta daamä ina? ");
INSERT INTO jum_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aŋ määdic kiiṇdä ogo, ‘Dalä luum yaana waŋü ti yaanna äbä woo,’ i jaan mooye a waŋü ti aŋan ogoo? ");
INSERT INTO jum_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ïkï lääño, paraŋ jaan mooye äbä woo waŋü ti nuŋko däämii ṭeṭaŋ, aŋ nuŋko luum määdic äbee daa woo waŋe ti ye. ");
INSERT INTO jum_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Wakkä latkä ŋana iñde gukku, aŋ ŋana waak yeekic yaaka tïïlcïdï ye yipgede kutuŋgu. Naana yibgene daa ye, bi määrjänä ïñï kä kïïgen, aŋ bi ḍuku ikee näke. ");
INSERT INTO jum_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ñujje, aŋ ikee bi iñge me. Määje, aŋ ikee bi käñe. Ṭume, aŋ äntüke bi kupkene kä me. ");
INSERT INTO jum_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","M'ana tääcï ye, bi iñgä me. Aŋ m'ana määjï ye, bi käñï. Aŋ m'ana ṭümï ye äntüke bi kupkene daa me. ");
INSERT INTO jum_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“A ŋaani ken naana minneni yeene tääccï ogo biŋŋan ye, i iñe pääm? ");
INSERT INTO jum_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aŋ naana tääccï ogo yakcan ye, i iñe kaaŋ? ");
INSERT INTO jum_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aŋ ikee mä yaackä, äccin wakkä ŋerkä merkä yeekic ti ŋäjje, aŋ Wääc yaana ñaalok polloŋ jï ye, bi äccïdï ogoo büṭa waak ŋerkä m'aka tääccï ike ti ye! ");
INSERT INTO jum_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Me näŋgede nääŋkä yaaka ṭäkke ogo näŋgede daa ko me ye, aŋ yaakki a jiik ḍoocin yek Müüca ke meeŋka bäṭoni. ");
INSERT INTO jum_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kaace kä äntüke ḍïïwconḍe. Äntüke yaana atï ḍüümtin ti ye, gääbaŋ aŋ päy yeene wääne paṭälaŋ, aŋ kaaccete kä me ḍiirken. ");
INSERT INTO jum_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aŋ äntüke yaana atï üṇṇü ti ye, ḍïïwaŋ aŋ päy yeene wääne pegaŋ, aŋ a me ḍeewken ken käñit. ");
INSERT INTO jum_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Waŋgic tïïce kä bäṭoni yaaka a yeloŋŋi ye. Iken äätä kä biilkä käbälgä aŋ külok a bäwni yaaka uudu ye. ");
INSERT INTO jum_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aŋ bi ŋïje kä nääŋken. Yoku jaan yaana beel bata lüütkon ye urgu me küügü ti, ke ŋoommu yoku urgu me tiim ti? ");
INSERT INTO jum_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Aŋ jaan ŋerconḍe daa giit ṭulge ŋerken aŋ jaan yaajgonḍe daa giit ṭulge yaacken. ");
INSERT INTO jum_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jaan ŋerconḍe batta giit ṭulge yaacken, aŋ jaan yaajgonḍe batta giit ṭulge ŋerken. ");
INSERT INTO jum_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jaan yaana batta giit ṭulge ŋerken ye tääyänä me ïñï aŋ yeepänä me maccük ");
INSERT INTO jum_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aŋ bata yaana jengä ŋïjde daa kä ṭulgen ye, cäänna bäṭoni yaaka a yeloŋŋi ye bi ŋïjde kä nääŋken. ");
INSERT INTO jum_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Batta a me muure yaaka ika bäärga ogo, ‘Pïṭo, Pïṭo,’ ye, ken bi kaacï ti Yätkïtïn Polloŋ jï ti. A m'aka nääŋä kä ṭäktäŋ Wäyo yaana polloŋ jï ye ken bi kaacï ti pääken. ");
INSERT INTO jum_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aŋ nïïnnä yaanja ti me ḍiirken ika bi kiiṇta ogo, ‘Pïṭo, Pïṭo, ikoon batta bäṭṭon kä yäṇtonḍü aŋ ikoon batta ñuuṭṭon meŋkeekeni kä yäṇtonḍü, aŋ ikoon batta näŋŋon wakkä yäwkä ḍiirken kä yäṇtonḍü?’ ");
INSERT INTO jum_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aŋ bi kiinä ogo, ‘Ikee kuje ogo wec. Aŋge yokic ika ti ikee yaaka liige gïtï jiik ḍoocin ye.’ ");
INSERT INTO jum_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Aŋ m'ana tiiŋŋä jiik yeeki yaakki, aŋ ñuugulene kä ye, bi beeljï bata ŋäjjo yaana än yeene korre karkar gïtï ye. ");
INSERT INTO jum_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aŋ ñaal määdin aŋ tääl äätin aŋ jommu küütïn aŋ än olle aŋ batta a ḍïmmïnï a yaana agee kä koṭon kä karkar wic ye. ");
INSERT INTO jum_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aŋ m'ana tiiŋŋä jiik yeeki yaakki aŋ batta agee kä ñüügïlïnï kä ye, bi beeljï bata oon amgonḍe yaana än yeene korre ṭiŋal gïtï ye. ");
INSERT INTO jum_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aŋ ñaal määdin aŋ tääl äätin aŋ jommu küütïn aŋ än olle aŋ ḍimmin ïñï aŋ ḍimminene yäwaŋ.” ");
INSERT INTO jum_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aŋ wääna Yeecüwa ḍaŋŋee kä jiik ye, ṭoŋ witken ḍiiktin kä nüüṇṇü yeene. ");
INSERT INTO jum_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nääŋka ike nüütee kä bata m'ana cääyge mügdïn ye, aŋ batta bata nüütoni jiik ḍoocin yek Jooŋ yeeken. ");
INSERT INTO jum_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aŋ wääna Yeecüwa kääjenee kä ïñï pääm wic ye, i ṭoŋ ḍiirken bäätcin ike ti. ");
INSERT INTO jum_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aŋ oon yaŋkalaŋ äätin ike ti näkä jaan, aŋ ḍüŋjïn ïñï ñome ti, aŋ kiinne ogo, “Mügdo, naana ïkï gïmmädä ye, laatca yokïn woo.” ");
INSERT INTO jum_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aŋ Yeecüwa ïṇte lajjene aŋ tamme yok aŋ jaajjin ogo, “Ika gïmmädä. Latci woo!” Aŋ kä ḍeeraŋ aŋŋi yore lattä woo kä jaan. ");
INSERT INTO jum_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aŋ kiini Yeecüwa ogo, “Yooru, mäŋkalaŋ ŋana nüütküdü, atä aŋ yorü nüütkü män daaŋ aŋ äccä gin'a iini Müüca ye, dalä wäätï a ŋäjjin iken ti ogo ïkï latteey woo.” ");
INSERT INTO jum_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aŋ wääna Yeecüwa kaaccee ti Kaparnahuum ye, i ḍuuŋgon kääygä yen mä Ruumaan yaŋkalaŋ äätin ike ti, aŋ ike ñujgi yok ogo, ");
INSERT INTO jum_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Mügdo, kiingon yeeni bilti nïïn ïñï paa bür wic a püündïnï, wääcï kä yaac.” ");
INSERT INTO jum_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aŋ kiini Yeecüwa ogo, “Ika bi äätä aŋ ike ṭeeñä.” ");
INSERT INTO jum_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Aŋ luugi kääygon ogo, “Mügdo, batta päjjïdï ïkï kääjä äräk baanni, jaajjä jiik kä winninä aŋ kiingon yeeni bi ṭeñ. ");
INSERT INTO jum_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ika cäänna agä oon ïñï mügdïn ti, ke kääygälen ïñï ika ti, aŋ yaana kiinä ogo, ‘Atä,’ ye, i daa atï, aŋ yaana kiinä ogo, ‘Äätä,’ ye, i daa ätä, aŋ naana kiingon yeeni kiinä ogo, ‘Yaanni naŋä,’ ye, i daa naŋe.” ");
INSERT INTO jum_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wääna Yeecüwa tiiŋŋee kä aŋan ye, wiñe ḍiiktin aŋ m'aka ike baattä ye, kiine ogo, “Ikee kiini a gïtken, Ika batta agä käñon mä Icärayiil ti m'ana luggin yeene tälaŋ aŋŋi ye. ");
INSERT INTO jum_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ikee kiine me ḍiirken bi üŋü kä ñomuk ke ŋäjäk aŋ cääjjï därŋañ äämkä ti ke Abrayiim, ke Icaak aŋ Yaagüüp Yätkïtïn Polloŋ jï ti. ");
INSERT INTO jum_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aŋ merkä mä Icärayiil ḍiirken, yaaka yoku Yätkïtïn a yeenen ye, bi yibjänä me mïïllä gïtï nänṭä ba' ïwok ke ŋeeynä me leken.” ");
INSERT INTO jum_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aŋ Yeecüwa ḍuuŋgon kääygä kiinne ogo, “Atä! Aŋ bi näŋï ḍoŋe ïkï ti bata yaana lugginii kä ye.” Aŋ waan yaanna ti kiingon yeene ṭeññä. ");
INSERT INTO jum_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aŋ wääna Yeecüwa ḍakkee kä ti paa ba' Bütürüc ye, i Bütürüc mareyḍe kaññe nïïn ïñï a raac yore ääṭï. ");
INSERT INTO jum_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aŋ tamme ïnkïn, aŋ yor äärtäŋene baakkin aŋ juwin ñaalok aŋ ike näŋgi gin äämkä. ");
INSERT INTO jum_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aŋ biigin yaanja ti ike icki me m'aka cäygene meŋkeekeni ye, aŋ wääktäŋŋi yaacken yaakka ñooṭṭe woo kä jiik, aŋ m'aka a rackä ye ṭeeññe muure. ");
INSERT INTO jum_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yaakki ḍääkit yaaka jaayi bäṭo Ïcaaya ye ogo, “Ike yor carreni yooko koowne aŋ rackïtïnnï yooko waaññe.” ");
INSERT INTO jum_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aŋ wääna Yeecüwa ṭoŋ yoorreeda kä ike ti ye, i baaddoni yeeke iññe jiik ogo iken irco woo koon mooye ti taaŋŋañja. ");
INSERT INTO jum_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aŋ nüüto yen jiik ḍoocin yek Jooŋ yaŋkalaŋ äätin aŋ ike kiini ogo, “Nüüto, nänṭ'a atii kä ye, i Ïkï baaddeni.” ");
INSERT INTO jum_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aŋ kiini Yeecüwa ogo, “Wiiwkä cääyge kälken, aŋ ḍïïrgä polloŋ jïñe cääyge kurken, aŋ Minneni Mänbaan batta cääyge nänṭ'a nääkcedee kä wiñe ye.” ");
INSERT INTO jum_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aŋ baaddo yeene yaŋkalaŋ ike kiini ogo, “Mügdo, dalä por ika atä wäyo jïgä, aŋ wäättan ika ḍuuku ïkï baaddeni.” ");
INSERT INTO jum_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aŋ kiini Yeecüwa ogo, “Bäätä ika ti, aŋ dalä mä tüwïn jïkï mä tüwïn yeeken.” ");
INSERT INTO jum_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aŋ wääna Yeecüwa kaaccee kä kuun jï ye, i baaddoni yeeke bäätcin ike ti. ");
INSERT INTO jum_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aŋ kä ḍeeraŋ aŋŋi jommuwiingä küütïn koon mooye jï, kuun wigde yok a yaana müüñe ye, i Yeecüwa a ooton. ");
INSERT INTO jum_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aŋ baaddoni attä ike cuujgi aŋ kiiṇtä ogo, “Mügdo, mäkkoon ikoon ḍaŋŋa müñon!” ");
INSERT INTO jum_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aŋ iken luugi ogo, “Ikee booje ina? Ikee yaaka luggin yeenic ḍeeraŋ ye!” Aŋ juwin ñaalok aŋ jommuwiingä ke koon mooye gerre, aŋ yuuttu ïñï. ");
INSERT INTO jum_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Aŋ baaddoni witken ḍiiktin aŋ tääjä pääken ogo, “A ŋaani inni? Jiike tiŋtä jommuwiingä ke koon mooye yaanni!” ");
INSERT INTO jum_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aŋ wääna Yeecüwa ircenee kä woo baan mä Jadarayïïn koon mooye taaŋŋañja ye, päägi ook kä yew käjä woo kälkä witin cäygene meŋkeekeni. Aŋ wïca baati m'ana kaajit kä päy yaanja ti ye, iken a mä yääññä. ");
INSERT INTO jum_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aŋ iken jaajjin kä yääw mooye ogo, “Ïkï ṭäkä ikoon naŋdoon ogoo, ïkï Minneni Jooŋ? Ïkï äätini winni ikoon joojjon, i waan batta mor ḍägä aŋŋi?” ");
INSERT INTO jum_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aŋ kutuŋgu ḍiirken yakkalaŋ bilti kääjï kä cokal iken ti. ");
INSERT INTO jum_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aŋ meŋkeekeni Yeecüwa malgä yok aŋ kiiṇtä ogo, “Naana ikoon ñoolcodoon woo ye, ñoolcon kutuŋgu gïtï.” ");
INSERT INTO jum_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aŋ kiini Yeecüwa ogo, “Ate!” Aŋ kääjin woo aŋ attä kaaccä kutuŋgu gïtï, aŋ kutuŋgu düürjïn ïñï koon mooye jï, aŋ bügjïn piitti aŋ müññü. ");
INSERT INTO jum_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aŋ m'aka kääjï kutuŋgu ye buurcin woo, attä baan jï, aŋ me nüütkï kä wakkä yaaka näŋŋä ḍuuggen ye muure, ke yaaka näŋŋä ḍuuggen m'aka cäygene meŋkeekeni ye ti. ");
INSERT INTO jum_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aŋ mä baan mooye muure kääjin woo Yeecüwa ti. Aŋ wääna yoorene daa ye, i malgä ogo baannen daljee ïñï. ");
INSERT INTO jum_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Aŋ ike kaaccä kuun jï ircin woo koon mooye taaŋŋañja, aŋ äätin baan yeene jï. ");
INSERT INTO jum_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aŋ wina mäkkalaŋ ike icki men yore a tüwon, nïïn gaan nïïnkä jï. Aŋ wääna luggin yeenen yoorene daa Yeecüwa ye, m'ana yore a tüwon yaanna kiinni ogo, “Minneni yeeni, jonü tiijgä! Nääŋkä yaacken yüükü kulkini me.” ");
INSERT INTO jum_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aŋ nüütoni yakkalaŋ yek jiik ḍoocin yek Jooŋ luugjin pääken ogo, “Oon yaanni jaay ina aŋŋi, ḍüücï ogo, ike agje Jooŋ?” ");
INSERT INTO jum_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","I daa paydin yeenen ŋäjjänä Yeecüwa, aŋ taaññe ogo, “Ikee payde yiñ juuggic ti ina? ");
INSERT INTO jum_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","A yaana wali ye ken poṭulaŋ jaajjä kä, ‘Nääŋkä yaackä yüükü a külkïnï,’ halla jiik, ‘Juwu ñaalok aŋ atä?’ ");
INSERT INTO jum_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aŋ ika ṭäkä ikee ŋäjje ogo Minneni Mänbaan cääygïïda ko mügdïn ŋommañ wic yen kulkin nääŋkä yaackä.” Aŋ m'ana yore a tüwon ye kiinne ogo, “Juwu ñaalok aŋ gaan nïïnkä yüünü koowu aŋ atä paa.” ");
INSERT INTO jum_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aŋ ike juwin aŋ attä paa. ");
INSERT INTO jum_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aŋ wääna ṭoŋ yuṭṭene ye, iken bojgin aŋ Jooŋ maaŋi yok yaana ïccïdï mügdïn mänbaan ti ye. ");
INSERT INTO jum_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aŋ wääna Yeecüwa kaajdee kä wïca ye, ike yuṭṭu men yaŋkalaŋ battä me ogo Matta cääy nänṭä ba' ḍüllü tiil, aŋ kiinne ogo, “Bäätä ika ti.” Aŋ juwin aŋ bäätcin ike ti. ");
INSERT INTO jum_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aŋ wääna Yeecüwa attene ke Matta paa baanne ammä ti ye, i ḍüṭoni yaacken ke mä yaackä äätin, aŋ cääjjin ïñï Yeecüwa ti ke baaddoni yeeke. ");
INSERT INTO jum_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aŋ wääna Pïrrïcïïnnï yuṭṭene aŋan ye, iken baaddoni yek Yeecüwa taaji ogo, “Nüüto yeenic ämï ke mä yaackä ke ḍüṭoni tiil ina?” ");
INSERT INTO jum_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aŋ wääna Yeecüwa tiiŋŋee kä aŋan ye, i ike jaajjin ogo, “M'aka yoken ŋeraŋ ye batta ṭäkï ṭiiño, a m'aka a rackä ye. ");
INSERT INTO jum_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ate aŋ jiik bäṭo yaakki ooke gïtï, ‘Ika ṭäkä me ängede ŋïngïn, batta a iirrä wäämmä yok ika ti.’ Ika batta äätänä bäärä mä wotku, a mä yaackä.” ");
INSERT INTO jum_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aŋ ääŋkalaŋ baaddoni yek Yaaya äätin Yeecüwa ti, aŋ tääccin ogo, “Ikoon ke Pïrrïcïïnnï büüṭon, aŋ baaddoni yüükü batta büüṭï ina?” ");
INSERT INTO jum_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aŋ luugi Yeecüwa ogo, “Yoku wilgä yek or ñääṇṇä nüüjï i mor or ñääṇṇä cäyok ke iken aŋŋi? Nïïnkä bi ätä yaana or ñääṇṇä koowge daa me iken ti ye, aŋ wäättan iken bi büüṭï. ");
INSERT INTO jum_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Aŋ baati m'ana burŋu kïcconḍe küüpe ti menen daane ti ye, burŋu pïïle kïcconḍe bi käjä woo daane ti, aŋ kääle bi täl. ");
INSERT INTO jum_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aŋ baati m'ana määk cotku pooke kücam määk daane jï ye. Aŋ naana naŋŋe ye, i kücam määk daane bi pür, aŋ määk bi puku woo, aŋ kücam määk bi yaac. Aŋ määk cotku pookcutu me kücam määk kïcconḍe jï, nuŋko cäyene ṭeṭaŋ muuṭuk ye.” ");
INSERT INTO jum_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aŋ wääna Yeecüwa jaayee jiik yaakka me ti ye, i yätï yaŋkalaŋ äätin ike ti, aŋ ḍüŋjïn ïñï aŋ jaajjin ogo, “Ṭuulle yeeni tüwnü tiññaaŋŋi. Aŋ äätä ïṇtü ḍoocci ike ti dalä cuyu.” ");
INSERT INTO jum_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aŋ Yeecüwa juwin aŋ attä ke ike aŋ baaddoni yeeke cäänna. ");
INSERT INTO jum_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aŋ iiŋ yaŋkalaŋ äätin ike ti a nääkïnï yuungu kä caay witken kä yew i iiŋä, aŋ äätin kä Yeecüwa ŋäñe ti, aŋ burŋu yeene tüke tamme yok. ");
INSERT INTO jum_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aŋ iiŋ jaajjin jone ti ogo, “Naana cäänna a burŋu yeene ken tabä yok ye, i ika bi ṭeñä.” ");
INSERT INTO jum_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aŋ Yeecüwa yore yelle aŋ iiŋ yoorre, aŋ kiine ogo, “Ṭuul yeeni jonü tiijgä. Luggin yüünü ïkï ṭeeññey.” Aŋ wina iiŋ ṭeññä. ");
INSERT INTO jum_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aŋ wääna Yeecüwa kaaccee kä äräk ba' yätï, aŋ yuṭṭee ṭoŋ lelene aŋ oolene uulgu nüüjdüŋ ye, ");
INSERT INTO jum_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","i ike jaajjin ogo, “Kaace woo üṇtük, ṭuulle batta a tüwon a ooton.” Aŋ ike yirkätä me. ");
INSERT INTO jum_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aŋ wääna ṭoŋ kaaccene üṇtük ye, i ike kaaccä äräk aŋ ṭuulle müŋŋe kä ïṇte, aŋ ṭuulle juwin ñaalok. ");
INSERT INTO jum_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aŋ jiik yaakka piirjin woo baan jï muure. ");
INSERT INTO jum_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Aŋ wääna Yeecüwa kaajdee kä wïca ye, i ook yakkalaŋ kä yewwe a uykuni ike baattä, aŋ yawdïdï ogo, “Ängoon ŋïngïn, Minneni Daawüüt!” ");
INSERT INTO jum_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aŋ wääna ike kaaccee kä äräk ye, uykuni äätin ike ti, aŋ taaññe ogo, “Ikee luggede ogo ika lïïltoo ko päṇṇä waŋgin ikee?” Aŋ iken luukcin ogo, “Ee, Mügdo.” ");
INSERT INTO jum_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aŋ täämme waŋgen ti, aŋ kiinne ogo, “Dale wäätï ikee ti kä luggin yeenic.” ");
INSERT INTO jum_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aŋ waŋgen pättä. Aŋ koli Yeecüwa kä car ogo, “Mäŋkalaŋ ŋana nüütkede kä gin yaanni.” ");
INSERT INTO jum_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aŋ iken ṭääkcin attä jiik piirji woo baan jï muure. ");
INSERT INTO jum_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aŋ wääna iken kaaccene kä woo ye, i oon yaŋkalaŋ äbi me ike ti batta jaay cäygene meŋkeeke. ");
INSERT INTO jum_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aŋ wääna Yeecüwa meŋkeeke ñooṭṭee daa kä woo ye, i wäättan oon jääyin woo. Aŋ ṭoŋ witken ḍiiktin, aŋ jayok ogo, “Baati gin'a a wääton bata yaanni Icärayiil jï ye.” ");
INSERT INTO jum_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aŋ Pïrrïcïïnnï ṭääkcin jayok ogo, “Ike a iñgon kä mügdo yen meŋkeekeni teynä, ina ken ñuuṭee kä meŋkeekeni yaanna.” ");
INSERT INTO jum_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aŋ Yeecüwa attä laaynä bänkä mäyken ke bänkälen gïtï, nüütï daaŋmallä yen Yühüüṇṇï ti, aŋ päkï kä Jiik Ŋerkä yen Yätkïtïn Polloŋ, aŋ ṭïïñï yor carre ke m'aka wääcï rackïtïn ye. ");
INSERT INTO jum_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aŋ wääna yurcenee kä ṭoŋ ye, i ängene ŋïngïn kä yaana iken witken agene yääyin aŋ batta käñdene yüükkïn ti, bata käbälgä yaaka batta cäygene kaaydo ye. ");
INSERT INTO jum_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aŋ baaddoni yeeke kiinne ogo, “Wakkä pïïtïn yaaka a eegin ye ḍiräk, aŋ iṭoni ken ḍewgaŋ. ");
INSERT INTO jum_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aŋ ñujje Mügdo yen errä wakkä pïïtïn ti, dale tucu iṭoni errä wakkä pïïtïn.” ");
INSERT INTO jum_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Aŋ Yeecüwa baaddoni yeeke yaaka kä caay witken kä yew ye, bärkene ti, aŋ iññe mügdïn ñuuṭene meŋkeekeni aŋ ṭiiñene rackïtïnnï ke yor carrä muure. ");
INSERT INTO jum_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A yäṇtäŋŋi yek tüüjgï yaaka kä caay witken kä yew ye ikki, Ïïjjïdï kä Camaan, yaana battä me ogo Bütürüc ye, ke määden Aṇdaraawuc, ke Yaagüüp minneni Jabadï, ke määden Yuhanna, ");
INSERT INTO jum_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ke Pïlïp, ke Bartalamawuc, ke Yuungon, ke Matta yaana a ḍüṭo ye, ke Yaagüüp minneni Alpï, ke Ṭaḍawuuc, ");
INSERT INTO jum_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ke Camaan yaana näkä maam kä baan yeene ye, ke Yahüüja Garyüütï yaana a aagdo ŋäc yeene ye. ");
INSERT INTO jum_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yeecüwa tuccin woo tüüjgï caay witken kä yew kä eenjinni yaakki ogo, “Ŋana ikee ate boorgu ti, aŋ ŋana ikee kaaccede ti baan mä Caamira yaŋkalaŋ jï. ");
INSERT INTO jum_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ṭääkce ate mä Icärayiil ti käbälgä yääyin yek Jooŋ. ");
INSERT INTO jum_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ate aŋ bäṭe ogo, ‘Yätkïtïn Polloŋ jïñe cokilin ti.’ ");
INSERT INTO jum_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","M'aka a rackä ye ṭeeñe, aŋ mä tüwïn cuujge tüwnü ti, aŋ mä jaan laade yokïn aŋ meŋkeekeni ñooṭe woo. Ikee kuññe käpet aŋ daa ice käpet. ");
INSERT INTO jum_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ŋana ikee kujde tiilgä kumku tiilgä gälkä yeekic gïtï, ŋana tiil mäyken ke lïcken cäänna. ");
INSERT INTO jum_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ŋana ikee kujde kücümgü wään yeenic ti, ke buruŋgu ŋana kügde ke waygä ke läcäŋgä, m'ana ñuugal ye päjjïdï äämgä me. ");
INSERT INTO jum_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Aŋ baan yaana kääckene ti ye, määje m'ana päjjïdï ye. Aŋ cääye än yeene ti ke kaace kä woo. ");
INSERT INTO jum_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aŋ naana ikee kaacce ti än ti ye, ŋïïpce. ");
INSERT INTO jum_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aŋ naana mä än päjjïdï ye, dale ŋïïbbïn yeenic wäätï iken ti, aŋ naana mä än batta päjjïdï ye, dale ŋïïbbïn yeenic ḍuku ikee ti. ");
INSERT INTO jum_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aŋ m'ana ikee tuuññe yokïn kä gïmgïn aŋ batta a tiiŋon jiik yeekic ye, i än ke baan yaanna dalje ïñï aŋ kïïgïc ṭeŋje woo kä ṭabür aŋ aŋan nüütï ogo ikee tuuññeda me yokïn. ");
INSERT INTO jum_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ikee, kiine a gïtken, jooññu mä Caduum ke Amuura bi lïïgïdï kä nïïnnä jooññu yaana bi jucu baan yaanja ye. ");
INSERT INTO jum_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Aŋ ikee tuccede woo bata käbälgä waadgä bäwni, dale witkic bïtäraŋ bata käggä, aŋ dale ḍuuggic ladaŋ bata gülküteni. ");
INSERT INTO jum_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Waŋgic tïïce kä me! Ikee bi müükkene yokïn tajdoni, aŋ ikee bi ḍooyge kä bäädan daaŋmallä yen Yühüüṇṇï ti. ");
INSERT INTO jum_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aŋ ikee bi ice mügdoni ñomgen ti, ke yätkäni ñomgen ti, nääŋka age kä baaddoni yeeki ye. Aŋ yaanna bi wäätï a waan yeenic yaana bi päkke kä mügdoni ke m'aka batta a lüggïnï, kä ika ye. ");
INSERT INTO jum_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aŋ naana ikee müügene ye, ŋana ikee payde jiik gïtkïc ogo ikee bi jaayje ogo ŋaaka halla jiik bi jaayje ogoo. Jooŋ ikee bi iñe jiik wuuŋ yaanja ti. ");
INSERT INTO jum_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Batta bi a ikee ken bi jaaye, a Wääktäŋ yen Jooŋ yaana a Wääc ye ken bi jaay kä ikee. ");
INSERT INTO jum_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Men bi määden ääkke ŋäc kä tüwnü, aŋ wäy minneni yeene bi ääkke ŋäc, aŋ merkälen bi juwu migen ke wäygen lapä ḍugin aŋ näkä me ḍugin. ");
INSERT INTO jum_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Me muure ikee bi putkene gïtï nääŋka age kä baaddoni yeeki ye. Aŋ m'ana yuddin ke düüñïn ti ye, bi käñï mäkkin. ");
INSERT INTO jum_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aŋ naana ikee putkene me gïtï baan yaŋkalaŋ ti ye, lüüde yaŋkalaŋ ti, ikee kiine a gïtken, Minneni Mänbaan bi ätä, i batta mor bänkä mä Icärayiil ḍaage kä laaynä muure. ");
INSERT INTO jum_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Baati ñujo yaana nüüto yeene käälede ïñï ye, aŋ baati kiingon yaana men mooye yeene käälede ïñï ye. ");
INSERT INTO jum_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Päjjïdï ñujo beeljï bata nüüto yeene, aŋ kiingon beeljï bata men mooye yeene. Aŋ naana ika men mooye yen än battä me ogo booŋïn ye, i cäänna mä paanä yeeke bi bäärgä me kä yäṇtäŋŋi yaacken. ");
INSERT INTO jum_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ŋana ikee booje kä iken, baati gin'a a kümgon wic aŋ batta a üükïnï woo ye, aŋ baati gin'a a paangon yok aŋ batta a ŋäjjïnï ye. ");
INSERT INTO jum_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jiik'a nüüde kä mïïllä gïtï ye, i daa jääye woo bownu gïtï aŋ jiik'a tiiŋŋe pääkic ye, i pääge woo nänṭä küüllü wic. ");
INSERT INTO jum_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ŋana ikee booje kä m'aka nääkä gaan, aŋ batta nääkä yor ye. Ṭääkce booje kä Jooŋ yaana nääkä gaan ke yor muuṭuk maccük ye. ");
INSERT INTO jum_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yerñä yaaka kä yewwe ye, batta yääygä me kä tiilñanle? Baati yaŋkalaŋ yaana ḍïmmïdï ïñï i batta ŋäjjänä Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Cäänna ke jiik witkic a pakin muure. ");
INSERT INTO jum_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ŋana ikee booje, ikee kääṭe kä yaac kä yerñä. ");
INSERT INTO jum_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“M'ana ika gïmgana me ñomgen ti ye, cäänna daa bi gïmgä Wäyo yaana ñaalok polloŋ jï ye ñome ti. ");
INSERT INTO jum_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aŋ m'ana ika reecca woo me ñomgen ti ye, cäänna daa bi reecä woo Wäyo yaana ñaalok polloŋ jï ye ñome ti. ");
INSERT INTO jum_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ŋana ikee ḍuuce ogo ika äätonoo ääconoo ŋïïbbïn ŋommañ wic. Ika batta äätänä ääcädä ŋïïbbïn, a gaaḍal. ");
INSERT INTO jum_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","‘Ika äätänä ḍuccudu yiñ waan men ke wäyen, aŋ ṭuulle ke meen, aŋ ṭuulle ke ṭiinmeen oore. ");
INSERT INTO jum_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Aŋ men ädäŋŋi yeeke a mä än yeene ti.’ ");
INSERT INTO jum_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“M'ana wäyen ke meen bilgene kä yaac ke käälce woo ika ti ye, batta päjjïdï ke ika, aŋ m'ana billä minneni yeene ke ṭuulle yeene kä yaac käälcïdï woo ika ti ye, batta päjjïdï ke ika. ");
INSERT INTO jum_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aŋ m'ana kaakkon yeene batta koowde aŋ bäätïdï ika ti ye, batta päjjïdï ke ika. ");
INSERT INTO jum_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aŋ m'ana üṇṇü yeene kaññe ye, i bi yääye, aŋ m'ana üṇṇü yeene yääyne ogo Ika ye, i bi kañe. ");
INSERT INTO jum_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“M'ana ikee gïmgene ye, i ika gïmgana, aŋ m'ana ika gïmgana ye, i M'ana ika tuujana ye gïmgene. ");
INSERT INTO jum_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aŋ m'ana bäṭo gïmgene ogo bäṭo yen Jooŋ ye, i bi käñï iññä yeene bata bäṭo, aŋ m'ana män woṇṇu gïmgene ogo wodowot ye, bi käñï iññä yeene bata män woṇṇu. ");
INSERT INTO jum_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aŋ m'ana minneni ḍeerconḍe iññe piik lüykü kä ḍonṭule ogo baaddo yeeni ye, ikee kiine a gïtken iññä yeene batta bi yääy.” ");
INSERT INTO jum_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aŋ wääna Yeecüwa ḍaŋŋee kä nüüṇṇü baaddoni yeeke yaaka kä caay witken kä yew ye, i ike attä wïca nüütï aŋ päkï bänkä mäyken yek mä Jalïïl gïtï. ");
INSERT INTO jum_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aŋ wääna Yaaya tiiŋŋee kä gaŋgar jï kä ñuugilin Macii ye, i ike tuccin baaddoni yeeke. ");
INSERT INTO jum_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Aŋ Yeecüwa taajjï ogo, “Ïkï agä Macii yaana keejjodon ye, halla ikoon kiijjon mäŋkalaŋ ŋuca?” ");
INSERT INTO jum_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aŋ iken luugi Yeecüwa ogo, “Ate aŋ Yaaya nüütke kä waak'a tiiŋŋe aŋ yoorre ye, ");
INSERT INTO jum_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","uykuni yuṭṭu aŋ puudgu jujjin woo, aŋ mä jaan lattä woo aŋ miŋkäni tiiŋŋä, aŋ mä tüwïn juwin ñaalok tüwnü ti, aŋ aangï päkki me Jiik Ŋerkä. ");
INSERT INTO jum_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aŋ ñaaynä m'ana batta ḍükcïdï ŋäjäk ogo Ika ye.” ");
INSERT INTO jum_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aŋ wääna baaddoni yek Yaaya kaaccene kä woo ye, Yeecüwa uccin kä päkkin ṭoŋ jiik ogo Yaaya aŋ kiiṇde ogo, “Wääna atte kä woo teettälaŋ Yaaya ti ye a ŋaaka ken ṭäkke yoodde? A biiruŋ yaaka boku jommu ye? ");
INSERT INTO jum_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aŋ a ŋaaka ken umgede woo yoodde? A oon yaana eŋit buruŋgu carkä ye? Uʼu! M'aka eŋit buruŋgu carkä ye a äärgä ti ba' yätkäni. ");
INSERT INTO jum_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aŋ a ŋaaka ken umgede woo yoodde? A bäṭo? Ee, ikee kiine, ike kääṭï kä bäṭo. ");
INSERT INTO jum_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A ike inni yaana jaaynene Meeŋka Jiik Jooŋ ye ogo, ‘Ika bi tuccu tuujgon yeeni ñomü ti, yaana bi tütï päy yüünü ñomü ti ye.’ ");
INSERT INTO jum_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ikee kiine a gïtken, baati m'ana a giiton kä määngä me waadgen ti muure yaana Büüṭo Yaaya bore kä yäwnä ye. A m'ana ḍeeraŋ Yätkïtïn Polloŋ jï ye ti, ken Yaaya bore kä yäwnä. ");
INSERT INTO jum_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Aŋ nïïnkä Büüṭo Yaaya ti ke tiññaŋ Yätkïtïn Polloŋ jïñe wääcï kä pillä, aŋ mä ïïrrä teynä ïrcïdï ike ti. ");
INSERT INTO jum_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aŋ meeŋkani bäṭoni muure ke jiik ḍoocin yek Müüca bäṭṭä ke Yaaya ḍääge. ");
INSERT INTO jum_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aŋ naana ikee ṭäke gïmmede kä yaaka jaayä ye, ike a Ïlïya, yaana jaaynene bäṭoni ogo bi ääto ye. ");
INSERT INTO jum_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aŋ m'ana cäyge gitke ye dale tïïŋï aŋ ooke gïtï! ");
INSERT INTO jum_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Aŋ kil yaakki bi iirjä ke ŋaaka? Belok bata merkälen yaaka cäyok nänṭä ba' weel, aŋ bäärjïdï meken ti ye ogo, ");
INSERT INTO jum_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ikee kütkene me ṭüürüül aŋ ikee batta ŋeele. Aŋ ikee uulgene me uullu nüüjdüŋ aŋ ikee batta nüüje.’ ");
INSERT INTO jum_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Aŋ Yaaya äätin batta ämï aŋ batta mätï, aŋ ikee jaaye ogo, ‘Cääygïïda ko meŋkeeke.’ ");
INSERT INTO jum_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aŋ Minneni Mänbaan äätin ämï aŋ mätï, aŋ ikee jaaye ogo, ‘Amtük ko yaac aŋ ogo maaddomääk,’ aŋ ogo, ‘Muukon ḍüṭoni yaacken ke mä yaackä.’ Aŋ ŋäjjin yaana a jïñe ye üükïdï woo kä ñuugula yeene.” ");
INSERT INTO jum_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aŋ Yeecüwa bänkä mäyken yaaka näŋŋee kä wakkä yäwken ye, gerde kä yaana iken batta agene kä ḍagin kä nääŋkä yaackä yeeken aŋ ḍuukene Jooŋ ti ye. ");
INSERT INTO jum_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Aŋ ike jaajjin ogo, “Jooññu ikee ti mä Korajïïn ke mä Beetcayda! Naana yoku wakkä yäwkä yaaka näŋgene kä yaakki, naŋŋä a mä yaackä ti Cüür ke Cïdoon ye, yoku mä yeeken ḍaŋŋä kä nääŋkä yaackä yeeken kä on, aŋ iiŋcin buruŋgu nüüjdüŋ aŋ tükcïn ṭaaṭaŋ witken ti nüütï ääkcin yeenen. ");
INSERT INTO jum_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aŋ ikee kiine, jooññu yen mä Cüür ke Cïdoon bi lïïkïdï kä jooññu yeenic nïïnnä jooññu ti. ");
INSERT INTO jum_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Aŋ ikee mä Kaparnahuum, ikee bi eemge me polloŋ jï? U'u! Ikee bi yipjene me nänṭä ba' mä tüwïn. Aŋ wakkä yäwkä yaaka näŋgene kä yaakki naana yoku naŋŋä a mä yaackä ti Caduum ye, yoku mor bilti cäyok ke nïïnnä yaanni ti. ");
INSERT INTO jum_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aŋ ikee kiine, jooññu Caduum bi lïïkïdï kä jooññu yeenic nïïnnä jooññu ti.” ");
INSERT INTO jum_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aŋ waan yaanja ti Yeecüwa mälcin ogo, “Wäyo, Mügdo yen polloŋ ke ŋommañ, ïkï maaŋeni yok kä yaana waak yaaka paanni yokïn ŋäjjoni ti ke m'aka a nüütïn ye, aŋ nüütkeneeda m'aka belok bata merkälen ye. ");
INSERT INTO jum_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, Wäyo, a yaaka ṭäkkä ogo wääto ye ikki. ");
INSERT INTO jum_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Waak muure iñana kä Wäyo ïṇtï ti. Aŋ baati m'ana ŋäjjä Minneni ye, a Wäy pare, aŋ baati m'ana ŋäjjä Wäy ye, a Minneni pare ke m'ana wagi Minneni aŋ nüütkene woo ike ye. ");
INSERT INTO jum_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ääte ika ti, ikee yaaka bäŋŋe kä ḍürdin wakkä pekkä ye, aŋ ikee bi iñe yïïktäŋ. ");
INSERT INTO jum_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kaakcä yeeni koowe, aŋ ŋäjje ika ti, kä yaana ika ḍoŋe agä ḍüügïnï kä ïñï ye, aŋ joni lüyeelüy ye, aŋ ikee bi käñe yïïktäŋ yokic ti. ");
INSERT INTO jum_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kaakcä yeeni lïïkïdï aŋ waak'a iñde kä ḍürde ye poṭulaŋ.” ");
INSERT INTO jum_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Aŋ waan yaanja ti Yeecüwa attä kaaññä yiil jï Äŋ jïñe Wääktäŋ ti, aŋ baaddoni yeeke näkki käñ aŋ iken uccin kä liŋŋä päk witken amgä. ");
INSERT INTO jum_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aŋ wääna yoorene daa Pïrrïcïïnnï ye, i Yeecüwa kiini ogo, “Yooru, Baaddoni yüükü nääŋä gin'a batta gïmkätä jiik ḍoocin Äŋ jïñe Wääktäŋ ti ye.” ");
INSERT INTO jum_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aŋ luugi Yeecüwa ogo, “Ikee batta age päkin nääŋk'a naŋe Daawüüt wääna näke daa käñ, ke m'aka ke ike ina? ");
INSERT INTO jum_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aŋ kaaccä än jï ba' Jooŋ aŋ ämmä bïggï latkä yaaka batta gïmkätä jiik ḍoocin ame ike, ke m'aka ke ike ye, a mä däŋkä pääken ken ämï. ");
INSERT INTO jum_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Halla ikee batta age päkin jiik ḍoocin yek Müüca ti ogo mä däŋkä yaaka ñuugolo änlaṇṇä jï ye, Äŋ jïñe Wääktäŋ ḍääldïï yok aŋ daa ḍuuggen ladolat? ");
INSERT INTO jum_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ikee kiine, mäŋkalaŋ bilti winni yäwaŋ kä änlaṇṇä yen Jooŋ. ");
INSERT INTO jum_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jiik Meeŋka bäṭo jayok ogo, ‘Ika ṭäkä me ängede ŋïngïn, batta a iirrä wäämmä yok ika ti.’ Aŋ naana jiik yaakki ookke gïtï ogo ŋaaka ye, i ikee batta bi juce m'aka ḍuuggen ladaŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aŋ Minneni Mänbaan a Mügdo yen Äŋ jïñe Wääktäŋ.” ");
INSERT INTO jum_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Aŋ Yeecüwa wïca daljene ïñï aŋ attä daaŋmallä yen Yühüüṇṇï ti, ");
INSERT INTO jum_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","nänṭ'a ike yuṭṭee kä oon yaŋkalaŋ ïṇte agee kä tüwon ye. Aŋ Yeecüwa taaji Pïrrïcïïnnï ogo, “Jiik ḍoocin gïmgïdï yoku men ṭïïñï Äŋ jïñe Wääktäŋ ti?” Aŋ iken ṭäkï ogo ike gïmmo ogo ee, nuŋko wäättan cïŋjïda ko. ");
INSERT INTO jum_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aŋ tääcki ti Yeecüwa ogo, “Ikee ti m'ana cäyge kabal aŋ ḍimjin käälok Äŋ jïñe Wääktäŋ ti ye, batta yoku müge aŋ äbe woo? ");
INSERT INTO jum_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aŋ ogoo büṭa mänbaan batta kääṭï kä yaac kä kabal! Päjjïdï jiik ḍoocin ti me näŋï nääŋkä ŋerkä Äŋ jïñe Wääktäŋ ti ye.” ");
INSERT INTO jum_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aŋ oon kiini Yeecüwa ogo, “Ïṇtü lajjä woo.” Aŋ oon ïṇte lajjene woo, aŋ ḍukcin bata menen. ");
INSERT INTO jum_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aŋ Pïrrïcïïnnï kaaccä woo läälä pugin ogo, Yeecüwa bi nägjï ḍok ogoo. ");
INSERT INTO jum_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Aŋ Yeecüwa, jiik yaakka ookke gïtï, aŋ kaaccä woo wïca. Aŋ me ḍiirken bäätcin ike ti, aŋ ṭeeññe muure. ");
INSERT INTO jum_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aŋ kolle ogo ŋana nüüto ko ike. ");
INSERT INTO jum_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aŋ yaakki ḍääkit yaaka jaayi bäṭo Ïcaaya ye ogo, ");
INSERT INTO jum_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“A ñuugulo yeeni yaana waŋŋä ye inni, aŋ ike a m'ana bilgä ñapeñap joni ye. Aŋ Wääktäŋ yeeni bi ḍoocu ike ti, aŋ ike bi bäṭï kä iirjin ṭoŋ ti muure. ");
INSERT INTO jum_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aŋ ike batta bi lel aŋ batta bi yaaw, aŋ baati m'ana bi tïïŋï yääwe pääygä gïtï ye. ");
INSERT INTO jum_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aŋ beellä gääŋon batta bi lige gïtï, aŋ ṭenṭel yaana käl ḍüüŋ jiinä ye batta cäänna üüljede, ke ääce iirjin kä yuctuŋ. ");
INSERT INTO jum_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aŋ ṭoŋ muure näkä guy yäṇtonḍe.” ");
INSERT INTO jum_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aŋ mäkkalaŋ ääcin oon a uyku aŋ batta jaay cäygene meŋkeeke, aŋ ṭeeñi Yeecüwa, aŋ oon jääyin woo aŋ yuṭṭu. ");
INSERT INTO jum_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aŋ me muure witken ḍiiktin, Aŋ iken jaajjin ogo, “Oon yaanni bi a Macii kaaynä yätkä Daawüüt yaana keeyïn ye inni?” ");
INSERT INTO jum_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aŋ wääna Pïrrïcïïnnï tiiŋŋene kä yaakki ye, i iken jaajjin ogo, “Ike batta lïïṭït ñoollu meŋkeekeni pare aŋan. A yaana teynä yeene kañdeeda kä booŋïn ti, mügdo yen meŋkeekeni ti ye.” ");
INSERT INTO jum_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aŋ paydinni yeeken ŋäjji Yeecüwa aŋ kiinne ogo, “Yätkïtïn yaana ḍoŋe ŋüüle gïtï ye, i yaac. Aŋ baan mooye ke äntükele yaana ḍoŋe ŋüüle gïtï ye, i batta bi yudit. ");
INSERT INTO jum_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aŋ naana wiñ yen meŋkeekeni ñüülcïdï woo wiñ yen meŋkeekeni menen ye, aŋan ḍoŋe ŋüülle gïtï. Aŋ yätkïtïn yeene bi yudit ogoo? ");
INSERT INTO jum_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aŋ naana ika ñuulcudu woo meŋkeekeni kä teynä booŋïn a gïtken ye, i aŋan baaddoni yeekic ñüülcïdï woo meŋkeekeni kä ŋaani? Aŋ aŋan iken bi wüütï a gütoni yeekic. ");
INSERT INTO jum_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aŋ naana a teynä Wääktäŋ Jooŋ ken ñuuṭu kä meŋkeekeni ye, i aŋan Yätkïtïn Jooŋ äätin ikee ti. ");
INSERT INTO jum_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yoku a ŋaani ken lïïṭï kaacï äräk ba' oon yaana teyaŋ bata booŋïn ye, aŋ waak yeeke peeje? A naana men teyaŋ kä ike aŋ por ike ḍiikä ye, aŋ wäättan nuŋko waak yeeke peejeeda kä ye. ");
INSERT INTO jum_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","M'ana batta ke ika ye, i a ädäŋ yeeni, aŋ m'ana batta ḍüṭon ye, i piirä gïtï. ");
INSERT INTO jum_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aŋ ikee kiine, nääŋkä yaackä ke aammin yok, bi kulkunu Jooŋ, aŋ m'ana aammä yok Wääktäŋ Laṇṇä ye, batta bi kulkunu Jooŋ. ");
INSERT INTO jum_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aŋ m'ana jaay jiik yaackä Minneni Mänbaan ti ye, bi kulkunu Jooŋ, aŋ m'ana jaay jiik yaackä Wääktäŋ Laṇṇä ti ye batta bi kulkunu Jooŋ, yuungu yaakki ti ke yuungu yaaka äätä ye ti. ");
INSERT INTO jum_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jaan ŋäjjänä me kä ṭulge. Naana jaan ŋeraŋ ye, i daa ṭulge ŋeraŋ. Aŋ naana jaan yaajaŋ ye, i daa ṭulge yejgaŋ. ");
INSERT INTO jum_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aŋ ikee merkä käggä! Yoku ikee jaaye jiik ŋerkä ogoo, i ina ikee age mä yaackä yaanna? Aŋ lemmä jaay wakkä yaaka jon agee kä küümgïnï ye. ");
INSERT INTO jum_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Män ŋerrä tuññu yeene ŋerconḍe jï ääcïdï woo wakkä ŋerkä, aŋ män yaaññä tuññu yeene yaajgonḍe jï ääcïdï woo yiñ. ");
INSERT INTO jum_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ikee kiine, nïïnnä jooññu ti mäŋkalaŋ daa bi taacä Jooŋ kä jiik'a jaayne a waanjï ye. ");
INSERT INTO jum_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kä jiik yüükü ïkï bi teetci woo, aŋ kä jiik yüükü ïkï bi jooci Jooŋ.” ");
INSERT INTO jum_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aŋ nüütoni yakkalaŋ yek jiik ḍoocin yek Jooŋ ke Pïrrïcïïnnï äätin Yeecüwa ti aŋ jaajjin ogo, “Nüüto, ikoon ṭäkon yurton gin'a nüütï yäwaŋ ïkï ti ye.” ");
INSERT INTO jum_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aŋ luugi Yeecüwa ogo, “Kil yaackä ke yaana batta cääyge luggin ye, ñüjï gin'a nüütï yäwaŋ ye, aŋ baati gin yäwnä yaana iñtedaa me ye, a gin yäwnä yen Bäṭo Yüünïc pare. ");
INSERT INTO jum_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bata yaana Yüünïc nääkenee kä äŋkä gïtken ke wïrdïnnï gïtken kä ḍäk yakcan mooye jï ye, i cäänna daa Minneni Mänbaan bi nääkä äŋkä gïtken ke wïrdïnnï gïtken kä ḍäk ŋommañ jï. ");
INSERT INTO jum_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aŋ mä Nïnawï bi juwu ñaalok nïïnnä jooññu ti ke kil yaakki aŋ bi joocu, aŋ wääna Yüünïc päkkee ye, iken ḍaŋŋä kä nääŋkä yaackä yeeken aŋ ḍuukin Jooŋ ti. Aŋ tiññaŋ m'ana tälaŋ Yüünïc ti ye a winni. ");
INSERT INTO jum_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aŋ yätkä iiŋe yen mä ïñïnä bi juwu ñaalok nïïnnä jooññu ti kä yiñ kil yaanni ti, aŋ bi jooje, kä yaana ike äätee kä ŋommañ ŋoy, tiŋdee kä ŋäjjin Cïlïmaan ye, aŋ tiññaŋ m'ana tälaŋ Cïlïmaan ti ye a winni. ");
INSERT INTO jum_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Aŋ naana wääktäŋ yaaññä kääjin woo men ti ye, i atï woo teettälaŋ määjï yïïktäŋ. Aŋ naana batta a käñon ye, ");
INSERT INTO jum_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","i jaajjï ogo, ‘Ika ḍukcu än yeeni yaana äätä kä ina ti.’ Aŋ naana ike ḍuukin aŋ än kaññe jïñe elaŋ aŋ a weecon aŋ a tooton ye, ");
INSERT INTO jum_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","I ike ḍukcï aŋ äcä meken kä ŋaṭükel yaaka teyaŋ kä yaac kä ike ye, iken kaacï aŋ cäyok wïca. Aŋ cäwdä yen men yaanna yaacï ïñï kä yaac batta bata wääna kä on ina. Aŋ cäänna bi wäätï kil yaaññä yaanni ti.” ");
INSERT INTO jum_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Wääna Yeecüwa jaayee kä ṭoŋ ti ye, i meen ke mädgen yudok üṇtük iken ṭäkï jaajjïdï ike ti. ");
INSERT INTO jum_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aŋ nüütkï mäŋkalaŋ ogo, “Miic ke mädgic yudok üṇtük ṭäkï jayok ke ïkï.” ");
INSERT INTO jum_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aŋ men luukke ogo, “A ŋaani ken a miyo? Aŋ a ŋaannä ken a mädgo?” ");
INSERT INTO jum_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aŋ ïṇte nüütte baaddoni yeeke ti, aŋ kiinne ogo, “A miyo ke mädgo ikki. ");
INSERT INTO jum_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aŋ m'aka nääŋä ṭäktäŋ Wäyo yaana polloŋ jï ye, ken a mädgo ke käwgo ke migo.” ");
INSERT INTO jum_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aŋ nïïnnä yaanja ti Yeecüwa än daljene ïñï aŋ attä cääjjin koon mooye taaŋ. ");
INSERT INTO jum_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aŋ ṭoŋ ḍiirken äätin ike ti, aŋ ike taappä kuun jï. Aŋ cääjjin ïñï aŋ ṭoŋ nüüṇṇe, i muure a yuutin koon mooye taaŋ. ");
INSERT INTO jum_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aŋ pääjgene wakkä ḍiirken kä gäärräni, aŋ jaajjin ogo, “Tiiŋe, pïïto attä woo mäpï käwkä yeeke. ");
INSERT INTO jum_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aŋ wääna ike mäpee ye, käwkä yakkalaŋ ḍiimdin päy jï, aŋ ḍïïrgä äätin aŋ ami. ");
INSERT INTO jum_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aŋ käwkä yakkalaŋ ḍiimdin ŋomgu ḍaraŋ wic. Aŋ yüülïn ñaalok kä bïraŋ kä yaana ŋomgu ejgene ejok ye. ");
INSERT INTO jum_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aŋ wääna äŋ kääjenee kä ye, waak garkä aarre aŋ ïwnä kä yaana bïcäŋgenen baawgene kä ti ye. ");
INSERT INTO jum_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aŋ käwkä yakkalaŋ ḍiimdin ïñï küügü gïtï, aŋ küügü yüülïn ñaalok aŋ käwkä mäji pugin. ");
INSERT INTO jum_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aŋ yakkalaŋ ḍiimdin ŋommañ ŋerrä ti, aŋ gidgin käwken, yakkalaŋ ääcin ääŋken caykä kä caay, aŋ yakkalaŋ ääcin ääŋken caykä kä ḍüügük, aŋ yakkalaŋ caykä kä ḍäk. ");
INSERT INTO jum_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aŋ m'ana cääyge gitke ye, dale tïïŋï aŋ ooke gïtï.” ");
INSERT INTO jum_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aŋ baaddoni äätin aŋ ike taaji ogo, “Ïkï jaayä kä gäärräni ina? ");
INSERT INTO jum_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aŋ luuŋŋe ogo, “Ŋäjjin yen jiik paangin yokïn yen Yätkïtïn Polloŋ jïñe äckene kä Jooŋ ikee. Aŋ batta agee äckïnï mäkkalaŋ. ");
INSERT INTO jum_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aŋ m'aka tiŋit nüüṇṇü yeeni ye, ukcin gïtï mooye bi iñge daa kä Jooŋ, aŋ iken bi cääyge ŋäjjin yaana kääṭï ye. Aŋ m'aka batta tiŋit ye, cäänna ukcin gïtï ḍeerconḍe yaana bilti iken ti ye bi koowgu Jooŋ iken ti. ");
INSERT INTO jum_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ken ina nüüdü daa kä gäärräni yaanna, Iken däämï aŋ batta yüṭï, aŋ tiŋit aŋ batta ookcutu gïtï. ");
INSERT INTO jum_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yaakki ḍääkit yaaka bari Ïcaaya ye ogo, ‘Ikee bi tiiŋe, aŋ batta bi ooke gïtï, aŋ ikee bi dääme, aŋ batta bi yoodde. ");
INSERT INTO jum_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Me yaakki juuggen üüldïn, aŋ gitken batta tiŋit, aŋ waŋgen mïdï, ken ina waŋgen batta yuṭene yaanna, aŋ gitken batta tiŋit, aŋ juuggen batta ükcïdï gïtï, aŋ iken batta ḍüükïdï ika ti, yaana ṭeeñä daa kä ye.’ ");
INSERT INTO jum_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Aŋ ñaaynä a waŋgic ti, kä yaana waŋgic yuṭene kä ye, ke gitkic ti, kä yaana gitkic tiŋdene kä ye. ");
INSERT INTO jum_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ikee kiine a gïtken, bäṭoni ḍiirken ke mä wotku iken ṭäkï ogo iken yuṭo waak'a yoorre ye, aŋ batta agene yoorgin, aŋ iken ṭäkï ogo iken tiiŋo waak'a tiiŋŋe ye, aŋ batta agene tiiŋgin. ");
INSERT INTO jum_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tiiŋe ŋüüllü gïtï yen gäärrä kä pïïto yaana mäpï käwkä ye. ");
INSERT INTO jum_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aŋ m'ana tiiŋŋä jiik Yätkïtïn aŋ batta agee kä ookon gïtï ye, i booŋïn ätä aŋ gin'a a pïïton jone ti ye oote woo. Yaakka a käwkä yaaka ḍiimdin ïñï päy jï ye. ");
INSERT INTO jum_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Käwkä yaaka ḍiimdin ŋomgu ḍaraŋ wic ye, nüütï m'ana tiŋit jiik aŋ koowde kä bïraŋ kä jon ñamme ye. ");
INSERT INTO jum_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aŋ ike batta cääyge bïcïŋgä, ike wääcï kä ḍeeraŋ, aŋ naana tïñïdïn ke putkin jï ätä ogo jiik ye, i kä ḍeeraŋ aŋŋi ike koojjï woo. ");
INSERT INTO jum_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aŋ käwkä yaaka ḍiimdin ïñï küügü gïtï ye, nüütï m'ana tiŋit jiik ye, aŋ kä miillä cekkïtïn yen ŋommañ wiñe jiik maace pugin ñaalok, aŋ ike dalcätä batta ääcïdï käwkä. ");
INSERT INTO jum_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Käwkä yaaka ḍiimdin ŋommañ ŋerrä ti ye, nüütï m'ana tiŋit jiik aŋ ookcede gïtï ye. Aŋ a m'ana ääcïdï käwkä, aŋ giit, caykä kä caay ke caykä kä ḍüügük ke caykä kä ḍäk ye. ");
INSERT INTO jum_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aŋ iken nüütkï Yeecüwa gäärrä yaŋkalaŋ, aŋ kiinne ogo, “Yätkïtïn yen polloŋ jïñe beel bata oon yaana mäppä käwkä ŋerkä yiil jï baanne ye, ");
INSERT INTO jum_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aŋ wääna me oodene daa ye, i ädäŋ yeene äätin aŋ mäpcin baaygä waadgä päk aŋ attä. ");
INSERT INTO jum_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aŋ wääna päk yüülene ñaalok ye, i cäänna daa baaygä üükïn woo. ");
INSERT INTO jum_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aŋ ñuuguloni yek men mooye äätin ike ti, aŋ taaji ogo, ‘Men mooye, batta a käwkä ŋerkä ken mämmi yiil jï baannü? Aŋ baaygä ätä wa?’ ");
INSERT INTO jum_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Aŋ luuŋŋe ogo, ‘A ädäŋ ken nääŋkä yaakka naŋŋe.’ Aŋ taaji ñuuguloni yeeke ogo, ‘Ïkï ṭäkä ikoon aton aŋ puudon woo?’ ");
INSERT INTO jum_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aŋ ike luukcin ogo, “Baʼay naana ikee ate puude woo ye, nuŋko päk yakkalaŋ putcede ti. ");
INSERT INTO jum_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dale yül nänṭä keellä ke nïïnnä errä ti, aŋ iṭoni bi kiinä nïïnnä errä ti baaygä ïïjgänä ergä aŋ ḍiikä yokïn a ḍïïggï, aŋ nääkkänä maañ, aŋ päk ken ḍüljünü tuññu jï.’” ");
INSERT INTO jum_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Aŋ iken nüütkï Yeecüwa gäärrä yaŋkalaŋ, aŋ kiinne ogo, “Yätkïtïn Polloŋ jïñe beel bata oon yaana kuññu käwcan jaan beel bata Jallä, aŋ pïïtte ïñï yiil jï baanne ye.” ");
INSERT INTO jum_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Aŋ a käwcan yaana ḍeeraŋ meken ti muure ye, ken ṭääkcin wääna yüülene ñaalok ye, meken borre yokïn muure yaaka yiil jï ye, aŋ wäättä a jaan mooye, yaana äätete ḍïïrgä aŋ näŋene kurken kimke ti ye.” ");
INSERT INTO jum_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Aŋ nüütkï Yeecüwa gäärrä yaŋkalaŋ, aŋ kiinne ogo, “Yätkïtïn yen polloŋ jïñe beel bata ŋimin yaaka koowi iiŋ kä ḍeewaŋ aŋ wäccee kä ḍon gïtke kä ḍäk yek kakin ke püüwene muure ye. ");
INSERT INTO jum_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aŋ waak yaakka muure kiinnene Yeecüwa ṭoŋ kä gäärrä. Baati gin'a batta agee kä jaaygon kä gäärrä ye. ");
INSERT INTO jum_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yaakki ḍääkit yaaka jaayi Jooŋ kä bäṭo ye ogo, “Ika poŋi bi kupku kä gäärräni, aŋ ika bi nüütü woo waak'a a paangin yokïn kä ïïjjïn ti naŋŋä ŋommañ ye ti.” ");
INSERT INTO jum_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aŋ ike ṭoŋ daljene ïñï, aŋ attä äräk. Aŋ baaddoni yeeke äätin ike ti, aŋ jaajjin ogo, “Ŋüülgoon gïtï gäärrä baaygä yiil jïñe.” ");
INSERT INTO jum_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aŋ ike luukcin ogo, “M'ana mäppä käwkä ŋerkä yaanna a Minneni Mänbaan. ");
INSERT INTO jum_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yiil a ŋommañ wiñe, aŋ käwkä ŋerkä a mäbaan yek Yätkïtïn Polloŋ jïñe. Aŋ baaygä a mäbaan yek booŋïn. ");
INSERT INTO jum_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ädäŋ yaana mäppä yaanna ken a booŋïn. Errä a düüñïn yuungu, aŋ iṭoni a Malaŋŋi. ");
INSERT INTO jum_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Aŋ bata yaana baaygä ḍülge daa me yokïn aŋ nääkkene daa me maañ ye, bi beeljï bata düüñïn yuungu. ");
INSERT INTO jum_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Minneni Mänbaan malaŋŋi yeeke bi tuce, aŋ iken bi aŋgä yokïn Yätkïtïn yeene ti m'aka läpï nääŋkä yaackä ke m'aka liigä gïtï jiik ḍoocin ye muure. ");
INSERT INTO jum_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aŋ yibjänä kääl maañ jï, nänṭä ba' ïwok ke nänṭä ba' ŋeeynä me leken. ");
INSERT INTO jum_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aŋ mä wotku bi dïkcï woo bata äŋ Yätkïtïn yen Wäyen ti. Aŋ m'ana cääyge gitke ye, dale tïïŋï aŋ ooke gïtï.” ");
INSERT INTO jum_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Yätkïtïn yen polloŋ jïñe beel bata waak ŋerkä yek paangin yokïn yiil jï, yaaka kañi oon aŋ kümme wic ye. Aŋ kä jone ñamme ike attä aŋ waak yeeke yääjjene woo muure aŋ kiññee yiil yaanna. ");
INSERT INTO jum_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Aŋ Yätkïtïn Polloŋ jïñe ŋuca beel bata oon yaana määjï tiilgä ye. ");
INSERT INTO jum_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aŋ wääna käññee kä yaana yäwaŋ aŋ päjjïdï ye, i ike attä aŋ waak yeeke yääjjene woo muure aŋ kiññee kä tiilñan yaanna. ");
INSERT INTO jum_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Aŋ Yätkïtïn Polloŋ jïñe ŋuca, beel bata ääŋ yaana yeepi me wii mooye jï, aŋ müügïn yak yakkalaŋ daa kä biilken ye. ");
INSERT INTO jum_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Aŋ wääna küümmee ye, wuuji me woo wii taaŋŋe ti, aŋ me cääjjin ïñï yak ŋerkä waki arwalli gïtï, aŋ yek yaackä yibji woo. ");
INSERT INTO jum_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aŋ a gin'a bi wäätï düüñïn yuungu ti ye inni. Aŋ malaŋŋi bi ätä aŋ mä yaackä bi kibbänä woo mä wotku gïtï ");
INSERT INTO jum_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","aŋ yibjänä kääl maañ jï. Nänṭä ba' ïwok ke nänṭä ba' ŋeeynä me leken. ");
INSERT INTO jum_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Aŋ Yeecüwa baaddoni yeeke taaññe ogo, “Wakkä yaakka ookke gïtï muure?” Aŋ luuki ogo, “Ee.” ");
INSERT INTO jum_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aŋ kiinne ogo, “Nüüto jiik ḍoocin yaana a baaddo yen Yätkïtïn Polloŋ jïñe ye, beel bata män än yaana ääcïdï woo waak dänken ke waak kïccäŋgenen tuññu yeene jï ye.” ");
INSERT INTO jum_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Aŋ wääna Yeecüwa gäärräni yaakka ḍaaŋŋeeda kä ye, ike kaaccä woo wïca, ");
INSERT INTO jum_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aŋ ike attä baan yeene ti nüütï daaŋmallä yen Yühüüṇṇï ti, aŋ me witken ḍiiktin. Aŋ tääcï ogo, “Oon yaanni ŋäjjin ke teynä nääŋkä yäwkä yaakki kañe wa? ");
INSERT INTO jum_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Batta a minneni ḍuŋo ina? Aŋ batta meen ina battä me ogo Märïyam ina? Aŋ mädgen batta a Yaagüüp, ke Yuucip, ke Camaan, aŋ Yahüüja? ");
INSERT INTO jum_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aŋ batta a käwgen muure ikki ke ïkïïn yaakki? Aŋ oon yaanni waak yaakka kañe wa muure aŋan? ");
INSERT INTO jum_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aŋ iken ike tuuji yok, aŋ batta agene gïmgïnï. Aŋ kiini Yeecüwa ogo, “Bäṭo eemtä me nänkä muure daa a baan yeene jï ke mä än yeeke ti pääken.” ");
INSERT INTO jum_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aŋ ike batta a näŋon wakkä yäwkä kä ḍiräk wïca, kä luggin yeenen bäwen ike ti. ");
INSERT INTO jum_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aŋ waan yaanja ti Mügdo Ïïrüüdüc tiiŋŋä ogo Yeecüwa. ");
INSERT INTO jum_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aŋ ñuuguloni yeeke kiinne ogo, “A Büüṭo Yaaya. Ike ken a jüwïnï ñaalok tüwnü ti, ina ken wakkä yäwkä ke teynä agee kä ïṇte ti yaanna.” ");
INSERT INTO jum_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Aŋ Ïïrüüdüc Yaaya müŋŋe aŋ ḍiiŋŋe aŋ äcce gaŋgar kä jiik Ïïrüdïya, iŋ määden Pïlïbbï. ");
INSERT INTO jum_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kä yaana kiinene daa Yaaya ogo, “Batta päjjïdï ike koowu.” ");
INSERT INTO jum_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aŋ ike ṭäkï ogo nägje ḍok, aŋ booññu kä mäbaan, kä yaana Yaaya batte daa me ogo, bäṭo ye. ");
INSERT INTO jum_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aŋ wääna nïïnnä giidä yen Ïïrüüdüc ti ye, i ṭuulle yen Ïïrüdïya ŋeeljin me ñomgen ti, aŋ Ïïrüüdüc ñaappe jok. ");
INSERT INTO jum_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Aŋ ike lïïttä ogo bi iñje gin'a ñujjee ko ye. ");
INSERT INTO jum_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aŋ ike jaajjin kä yaaka wäkkene daa meen ye, ogo, “Büüṭo Yaaya wiñe äckaa kä winni kä kooḍal.” ");
INSERT INTO jum_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aŋ yätkä nüüjjïn, kä yaana lïïttee kä wilgä yeeke ñomgen ti ye, aŋ ike iinjin ogo äbïï me. ");
INSERT INTO jum_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aŋ ike tuccin me aŋ Yaaya wiñe iiri me woo gaŋgar jï. ");
INSERT INTO jum_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aŋ wiñe äbi me kä kooḍal aŋ iñi me ṭuulle, aŋ äckene meen. ");
INSERT INTO jum_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aŋ baaddoni yeeke äätin gaane koowi aŋ jïgï. Aŋ iken attä Yeecüwa nüütkï. ");
INSERT INTO jum_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Aŋ wääna Yeecüwa tiiŋŋee kä aŋan ye, ike kaaccä woo wïca kä kuun aŋ attä nänṭä yaana nüüjee kä woo wïca pare ye. Aŋ wääna tiiŋene daa ṭoŋ ye, iken bäätcin ike ti kïïgen ïñï kä bänkä mäyken gïtï. ");
INSERT INTO jum_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aŋ wääna Yeecüwa kääjenee kä ïñï kuun jï ye, i ike yurcin ṭoŋ ḍiirken, aŋ ängene ŋïngïn aŋ ṭeeññe kä rackïtenen. ");
INSERT INTO jum_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aŋ wääna biigin ti aŋŋi ye, baaddoni äätin ike ti aŋ jaajjin ogo, “Winni a woo käpet, aŋ äŋ üttü, mäbaan tucci dalä atï bänkälen gïtï kïjï wakkä äämkä yeeken.” ");
INSERT INTO jum_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aŋ luugi Yeecüwa ogo, “Iken ŋana yoku atï, iñe ikee gin'a amgä ye.” ");
INSERT INTO jum_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aŋ iken jaajjin ogo, “Ikoon cäygonon kä bïggï kä duuc winni aŋ yak kä yewwe käpet.” ");
INSERT INTO jum_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aŋ ike luukcin ogo, “Äbe ika ti winni.” ");
INSERT INTO jum_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aŋ ike ṭoŋ kiinne ogo, “Cääjje ïñï luum gïtï.” Aŋ bïggï yaaka kä duuc ke yak yaaka kä yewwe ye koowne, aŋ däämjin ñaalok polloŋ jï, aŋ mäŋjin ñaalok. Aŋ bïggï liiŋŋe gïtï, aŋ iññe baaddoni, aŋ pääggi mäbaan. ");
INSERT INTO jum_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aŋ iken muure ämmä ke burene aŋ baaddoni ääṭin ñaalok arwalli kä caay witken kä yew a küümïn kä bïggï palken yek lïïktïnï yaaka buuccu ye. ");
INSERT INTO jum_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aŋ m'aka ämmä ye bi ḍakcïdï 5,000 ook pääken, i määngä ke merkälen batta a pakin ti. ");
INSERT INTO jum_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aŋ kä ḍeeraŋ aŋŋi Yeecüwa baaddoni yeeke kiinne ogo kaaco kuun jï wäätce ŋätin irco woo koon mooye taaŋŋañja, por ṭoŋ tucce woo. ");
INSERT INTO jum_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aŋ wääna Yeecüwa ṭoŋ äkkeneeda ye, ike attä pääm wic pare mäṭï. Aŋ wääna nänṭä aŋŋee kä biigin ti ye, i ike a wïca pare. ");
INSERT INTO jum_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aŋ waan yaanja ti kuun utirin woo koon taaŋŋe ti, aŋ piik nuuttin aŋ jommu küütïn aŋ kuun wigde yok. ");
INSERT INTO jum_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aŋ kä tïṇṇäŋänä aŋŋi Yeecüwa äätin baaddoni yeeke ti, i äätä piik witin. ");
INSERT INTO jum_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aŋ wääna yooṭene daa baaddoni ääte kä piik witin ye, i iken ṭeŋgin, aŋ yawgin kä liin ogo, “A callï!” ");
INSERT INTO jum_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aŋ kä bïraŋ aŋŋi iken kiini Yeecüwa ogo, “Juuggic tiijge, a ika. Ŋana ikee booje.” ");
INSERT INTO jum_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aŋ Bütürüc luukcin ogo, “Mügdo, naana a ïkï ye, kiinja dalä ika äätä ïkï ti piik witin.” ");
INSERT INTO jum_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aŋ kiini Yeecüwa ogo, “Ee, äätä.” Aŋ Bütürüc kääjin ïñï kuun ŋäc aŋ attä piik witin üŋjïn Yeecüwa ti. ");
INSERT INTO jum_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aŋ wääna yurcenee kä jommu mooye ye, i ike booññu, aŋ ṭäkï müñït, aŋ yaajjin ogo, “Mügdo, magja!” ");
INSERT INTO jum_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aŋ Yeecüwa ïṇte lajjene kä bïraŋ aŋ müŋŋe. Aŋ kiinne ogo, “Ïkï yaana luggin yüünü ḍeeraŋ ye, jüüggü riijä ina?” ");
INSERT INTO jum_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aŋ wääna iken kaaccene kuun jï ye, jommu yuuttu ïñï. ");
INSERT INTO jum_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aŋ m'aka kuun jï ye ike ḍüŋgï ïñï aŋ kiini ogo, “A gïtken ïkï agä Minneni yen Jooŋ.” ");
INSERT INTO jum_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Aŋ wääna iken ircene kä woo koon mooye ye, i iken äätin nänṭä yaana battä me ogo Janacareet ye. ");
INSERT INTO jum_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aŋ wääna mä nänṭä yaanja ti ike ŋïjene daa kä ye, i iken tuccin jiik bänkälen yaaka cokulaŋ ti ye muure, aŋ ike äcki me m'aka a rackä ye ogo ṭeeñje. ");
INSERT INTO jum_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Aŋ ñujgi ŋïngïn ogo burŋu yeene tüke ken cäänna yoku tabjï yok. Aŋ m'aka täppä yokïn ye, i ṭeññä muure. ");
INSERT INTO jum_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aŋ Pïrrïcïïnnï ke nüütoni jiik ḍoocin yek Jooŋ äätin yuṭit Yeecüwa ätä Oorcalïïm. Aŋ taaji ogo, ");
INSERT INTO jum_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Baaddoni yüükü poñku ḍuuŋku liikä gïtï ina? Iken ïnken batta looku poñ looŋŋu ïnkä ti.” ");
INSERT INTO jum_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aŋ luugi Yeecüwa ogo, “Aŋ ikee jiik ïïnïnï yek Jooŋ liige gïtï ogo poñku yeekic ina? ");
INSERT INTO jum_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jooŋ jaajjin ogo, ‘Wääc ke miic eemdä,’ aŋ, ‘M'ana wäyen ke meen kirre ye, i päjjïdï näkä me ḍok.’ ");
INSERT INTO jum_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aŋ ikee jaaye ogo päjjodo naana men wäyen ke meen kiinje ogo, ‘Buucka, ikee batta yüükkede ti. Äccin yaana yoku iñde kä ye, i iññä Jooŋ.’ ");
INSERT INTO jum_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Aŋ iken nüüde ogo wäygen ke migen ŋana eemdïï. Aŋ kä poñku yeekic ikee nääŋe bata gin'a jiik Jooŋ batta cääygene mügdïn ye. ");
INSERT INTO jum_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ikee lääñoni! Tooti Ïcaaya wääna bäṭṭee kä ogo ikee ye, ogo, ");
INSERT INTO jum_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Me yaakki ika eemta kä lepen, aŋ juuggen uturaŋ woo ika ti. ");
INSERT INTO jum_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aŋ ika maaŋga käpet, aŋ nüüṇṇü yeenen a jiik naŋgin kä mänbaan bata gin'a a iinin yen Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aŋ wäättan Yeecüwa ṭoŋ bärkene ti ike ti aŋ kiinne ogo, “Tiiŋe aŋ ooke gïtï. ");
INSERT INTO jum_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Batta a gin'a kaaccïdï poŋ jï ye ken men ḍääle, a gin'a kääjïdï woo poŋ jï ye, ken men ḍääle.” ");
INSERT INTO jum_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aŋ baaddoni äätin ike ti aŋ jaajjin ogo, “Ŋäjjä ogo Pïrrïcïïnnï piiṇdono wääna tiiŋŋene jiik'a jaayni ika?” ");
INSERT INTO jum_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aŋ luugi Yeecüwa ogo, “Gin'a batta a pïïton kä Wäyo yaana ñaalok polloŋ jï ye, bi puudunu me woo. ");
INSERT INTO jum_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dale buwin pääken. Iken a uykuni aŋ a woydoni yek uykuni. Aŋ naana uyku woyit uyku ye, muuṭuk bi ḍïmjï käälok.” ");
INSERT INTO jum_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aŋ ike kiini Bütürüc ogo, “Gäärrä yaanna ŋüülgoon kä gïtï.” ");
INSERT INTO jum_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aŋ ike jaajjin ogo, “Ikee cäänna batta mor ukce gïtï ke tiññaŋ? ");
INSERT INTO jum_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aŋ ikee batta yuṭe gin'a kaaccïdï poŋ jï ye atï kän jï aŋ kääjïdï woo gaan ti? ");
INSERT INTO jum_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aŋ gin'a kääjïdï woo poŋ jï ye kääjïdï woo jon ti, aŋ ken men ḍääle. ");
INSERT INTO jum_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aŋ jon jï kääjïdï woo, paydinni yaacken, nääŋ, balkïtïn, düüjïn a maam, kallä, yelkïtïn, ke aammin yok. ");
INSERT INTO jum_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aŋ a waak'a men ḍäältä ye ikki. Aŋ ammä i ïnkä batta a lookon men batta ḍääle.” ");
INSERT INTO jum_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Aŋ Yeecüwa kääjin woo wïca, aŋ attä baan mä Cüür ke Cïdoon. ");
INSERT INTO jum_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aŋ wina, iiŋ boorgu yaŋkalaŋ kääjin woo baan yaanja ti week ogo, “Ängaa ŋïngïn, ay Mügdo, Minneni Daawüüt, ṭuulle yeeni cääygene meŋkeeke, aŋ yuuge yok kä yaac.” ");
INSERT INTO jum_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aŋ batta agee kä luukon kä jiikkalaŋ. Aŋ baaddoni yeeke äätin ike ti, aŋ ike ñujgi yok ogo, “Ñoolci woo, ikoon lilgon gitkin.” ");
INSERT INTO jum_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aŋ luugi Yeecüwa ogo, “Ika tuujana Jooŋ käbälgä yääyin yek mä Icärayiil ti pääken.” ");
INSERT INTO jum_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aŋ iiŋ äätin aŋ ḍüŋjïn ïñï ike ti, aŋ jaajjin ogo, “Mügdo, yüükkaa ti.” ");
INSERT INTO jum_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aŋ luugi Yeecüwa ogo, “Batta päjjïdï ammani merkälen koowtu me, aŋ yipkätä me gukku.” ");
INSERT INTO jum_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aŋ iiŋ jaajjin ogo, “Ee, Mügdo, aŋ cäänna gukku ämï ammani yaaka ḍïïmdïdï däräŋgä me mäyken ti ye.” ");
INSERT INTO jum_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aŋ luugi Yeecüwa ogo, “Ay iiŋ, luggin yüünü teyaŋ! Dalä wäätï bata yaana ṭäkii kä ye.” Aŋ kä ḍeeraŋ aŋŋi ṭuulle yeene ṭeññä. ");
INSERT INTO jum_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Aŋ Yeecüwa wïca daljene ïñï aŋ attä kä koon mooye mä Jalïïl taaŋ. Aŋ aajjin ñaalok pääm wic aŋ cääjjin ïñï wïca. ");
INSERT INTO jum_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aŋ ṭoŋ ḍiirken äätin ike ti, ääcin m'aka a puudgu, ke uykuni, ke ŋolku ke m'aka batta jayok ke me ḍiirken yakkalaŋ yaaka a rackä ye, aŋ ḍooci ïñï ñome ti, aŋ ṭeeññe muure. ");
INSERT INTO jum_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aŋ ṭoŋ witken ḍiiktin, kä yaana yuuṭṭene m'aka batta jayok aŋ jääyene kä woo ye, ke ŋolku tutcene ye, ke puudgu jujjene kä woo ye, aŋ uykuni pättene ye, i wina iken Jooŋ mä Icärayiil maaŋi yok. ");
INSERT INTO jum_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Aŋ Yeecüwa baaddoni yeeke bärkene ti, aŋ kiinne ogo, “Ṭoŋ yaakki ängä ŋïngïn kä yaana cäynene ke ika nïïnkä kä ḍäk i iken batta cäygene kä gin äämkä ye. Aŋ ika batta ṭäkä iken tuccudu woo kä käñ, nuŋko bägit pääygä gïtï.” ");
INSERT INTO jum_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aŋ ike luugi baaddoni yeeke ogo, “Ïkïïn bi käñïn ammani wa woo käpet winni yaaka ṭoŋ yaakki bi burene kä ye?” ");
INSERT INTO jum_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aŋ iken taaji Yeecüwa ogo, “Ikee cääygene kä bïggï kä ŋïṭṭä?” Aŋ iken jaajjin ogo, “Kä ŋaṭükel, aŋ yak lïcken kä ḍeewaŋ.” ");
INSERT INTO jum_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aŋ ṭoŋ kiinne ogo cääjjo ïñï ŋomgu gïtï. ");
INSERT INTO jum_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aŋ bïggï yaaka kä ŋaṭükel ke yak ye, koowne aŋ ŋüülkene, aŋ liiŋŋe gïtï, aŋ iññe baaddoni, aŋ iñi baaddoni ṭoŋ. ");
INSERT INTO jum_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aŋ iken muure ämmä aŋ burru. Aŋ iken ääṭin ñaalok arwalli kä ŋaṭükel a küümïn kä bïggï palken yek lïïktïnï yaaka buuccu ye. ");
INSERT INTO jum_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aŋ m'aka ämmä ye a 4,000 yaaka a ook ye, i merkälen ke määngä batta a pakin ti. ");
INSERT INTO jum_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aŋ wääna ṭoŋ tucceeda kä woo ye, i ike taappä kuun jï aŋ attä baan mä Majadaan. ");
INSERT INTO jum_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aŋ Pïrrïcïïnnï ke Cüddügïïnnï äätin Yeecüwa ti, aŋ ike puuci aŋ ñujgï ŋïngïn ogo iken nüütkïï gin yäwnä Polloŋ jï. ");
INSERT INTO jum_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aŋ ike luukcin ogo, “Naana äŋ lütcïdï ye, i ikee jaaye ogo, ‘Jommu bi ŋeroŋer, kä tïṇṇä polloŋ jïñe.’ ");
INSERT INTO jum_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aŋ kä tïṇṇäŋänä aŋŋi, i ikee jaaye ogo, ‘Ñaal bi määdo ko polloŋ jïñe tïṇṇe ke üllü curuŋgu.’ Ikee yaacene yokïn kä ŋüüllü gïtï biilkä polloŋ, aŋ ikee batta lïïlte ŋüüllü gïtï waak'a üükïdï woo waadgä yuungu ti ye. ");
INSERT INTO jum_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mä yiñ ke kil baale määjï gin yäwnä, aŋ baati gin yäwnä yaana bi iñge daa me ye, a gin yäwnä yen Yüünïc pare.” Aŋ dalji ïñï Yeecüwa aŋ ike attä. ");
INSERT INTO jum_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aŋ wääna baaddoni ircene woo koon mooye taaŋŋañja ye, bïggï wiiṭi iken batta a ääcïnï. ");
INSERT INTO jum_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aŋ kiini Yeecüwa ogo, “Dääme aŋ waŋgic tïïce kä ŋimin yek Pïrrïcïïnnï ke Cüddügïïnnï.” ");
INSERT INTO jum_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aŋ iken uccin kä jiik pääken ogo, “Ike jaay aŋŋi nääŋka batta agïn ääcïnï kä bïggï ye.” ");
INSERT INTO jum_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aŋ ooki gïtï Yeecüwa, aŋ kiinne ogo, “Ikee yaaka luggin yeenic ḍeeraŋ ye, ikee luuge pääkic ogo ikee batta cäygeda ko bïggï ina? ");
INSERT INTO jum_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Aŋ batta mor ooke gïtï? Aŋ batta payde wääna äämmä 5,000 kä bïggï kä duuc, aŋ arwalli kä ŋïṭṭä yaaka ḍülle ye? ");
INSERT INTO jum_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aŋ bïggï kä ŋaṭükel äämmä 4,000, aŋ arwalli kä ŋïṭṭä yaaka buuccu ye? ");
INSERT INTO jum_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aŋ ikee yoññe ogoo kä ookcin gïtï, i ika batta jaayä ogo bïggï aŋan? Waŋgic tïïce kä ŋimin Pïrrïcïïnnï ke Cüddügïïnnï.” ");
INSERT INTO jum_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aŋ wäättan ooki gïtï baaddoni ogo batta jaayo ogo waŋgen tïïccï ko ŋimin bïggï, ko nüüṇṇü kärgit yen Pïrrïcïïnnï ke Cüddügïïnnï. ");
INSERT INTO jum_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Aŋ wääna Yeecüwa äätenee kä baan mä Kaacarïya Pïlïbbï ye, i baaddoni yeeke taaññe ogo, “Mäbaan jayok ogo Minneni Mänbaan ogo ŋaani?” ");
INSERT INTO jum_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aŋ iken jaajjin ogo, “Mäkkalaŋ jayok ogo Büüṭo Yaaya, aŋ yakkalaŋ jayok ogo Ïlïya, aŋ yakkalaŋ jayok ogo Ïrmïya, aŋ yakkalaŋ jayok ogo bäṭo yaŋkalaŋ.” ");
INSERT INTO jum_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aŋ taaji Yeecüwa ogo, “Aŋ ikee jaaye ogo Ika agjo ŋaani?” ");
INSERT INTO jum_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aŋ Camaan yaana battä me ogo Bütürüc ina luukcin ogo, “Ïkï agä Macii, Minneni Jooŋ yaana a üdon ye.” ");
INSERT INTO jum_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aŋ Yeecüwa ike luugi ogo, “Ñaaynä ïkï ti, Camaan minneni Yuhanna! Batta a mänbaan ken ïkï nüütkene yaakka, a Wäyo yaana ñaalok polloŋ jï ye. ");
INSERT INTO jum_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aŋ ïkï kiineni, ïkï agä Bütürüc, aŋ aŋan ogo karkar, äntüke yeeni bi badä karkar yaanni ti, aŋ teynäni yek tüwnü ike batta bi lïïlgä. ");
INSERT INTO jum_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aŋ ïkï bi iñeni kuponi yek Yätkïtïn Polloŋ jïñe, aŋ gin'a ḍeŋŋi ŋommañ wic ye, i bi a ḍekon ke ñaalok polloŋ jï, aŋ gin'a gütkïnï ŋommañ wic ye, i bi a gütkïnï ke ñaalok polloŋ jï.” ");
INSERT INTO jum_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aŋ baaddoni yeeke kolle ogo mäŋkalaŋ ŋana nüütkïdïï ogo Ike agje Macii. ");
INSERT INTO jum_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Aŋ waan yaanja ti Yeecüwa uccin kä nüütkïn baaddoni yeeke ogo Ike bääkkan daa atce Oorcalïïm, aŋ ike bi wääcce wakkä ḍiirken yätïnï ti, ke ḍuuŋku däŋkä ti, ke nüütoni jiik ḍoocin yek Jooŋ ti. Aŋ Ike bi nägjï me ḍok, aŋ nïïnnä ḍäk ti Ike bi juwee ñaalok tüwnü ti. ");
INSERT INTO jum_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aŋ koowi Bütürüc wüükke woo aŋ gerre, aŋ kiinne ogo, “Yoku ŋana iccätä Jooŋ, Mügdo! Aŋ yaanna ŋana yoku wäätcïdï a ïkï ti!” ");
INSERT INTO jum_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aŋ Bütürüc ṭukki Yeecüwa ñome aŋ kiinne ogo, “Wükcü woo ika ti, wiñ yen meŋkeekeni! Ïkï agä wïïṇṇan ika ti, paydinni yüükü batta ḍooju waak Jooŋ ti, a waak mänbaan ti.” ");
INSERT INTO jum_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aŋ wäättan Yeecüwa baaddoni yeeke kiinne ogo, “M'ana ṭäkï bäätïdï Ika ti ye, dale ḍoŋe wiire aŋ kaakkon yeene koowe aŋ bätä Ika ti. ");
INSERT INTO jum_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aŋ m'ana üṇṇü yeene tïïje ye, i bi yääye, aŋ m'ana üṇṇü yeene yääyne ogo ika ye, i bi kañe. ");
INSERT INTO jum_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aŋ a ŋaaka ken kañtä men naana wakkä ŋommañ wiñe koowne muure aŋ üṇṇü yeene yääyne ye? Aŋ a ŋaaka ken äccätä men ḍuukcedee üṇṇü yeene? ");
INSERT INTO jum_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aŋ Minneni Mänbaan bi ätä ke malaŋŋi yeeke kä maaŋŋä yen Wäyen, aŋ mäŋkalaŋ daa bi ḍuukke nääŋkä yeeke yaaka naŋŋe ye. ");
INSERT INTO jum_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ikee kiine a gïtken, mäkkalaŋ bilti winni batta bi näkkä tüwnü, ke yuṭene Minneni Mänbaan äätee kä yätkïtïn yeene.” ");
INSERT INTO jum_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aŋ wääna nïïnkä kä ḍüügük ḍakkene ye Yeecüwa Bütürüc koowne ke Yaagüüp ke määden Yuhanna, aŋ attene kä pääm küüllü wic pääken. ");
INSERT INTO jum_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aŋ ike ääkcin ñomgen ti, aŋ ñome dikcin woo bata äŋ, aŋ buruŋgu bojjin ïñï bata diko. ");
INSERT INTO jum_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aŋ wïca Müüca ke Ïlïya üükïn woo iken ti, aŋ jayok ke ike. ");
INSERT INTO jum_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aŋ Bütürüc Yeecüwa kiinne ogo, “Mügdo, ŋeraŋ kä biltinono ti winni. Aŋ naana ïkï ṭäkä ye, ika bi näŋä däŋkä kä ḍäk winni, yaŋkalaŋ a yüünü, aŋ yaŋkalaŋ a yen Müüca, aŋ yaŋkalaŋ a yen Ïlïya.” ");
INSERT INTO jum_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aŋ wääna ike mor jaayee kä ye, i curŋu ṭüüpülgü iken äädi yokïn, aŋ jiik kääjin woo curŋu gïtï aŋ jaay ogo, “A Minneni yeeni yaana bilgä ye inana, aŋ joni ñabaŋ kä Ike, tiiŋgede.” ");
INSERT INTO jum_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aŋ wääna baaddoni tiiŋŋene aŋan ye, i iken waŋgen kümjï ïñï bojok. ");
INSERT INTO jum_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aŋ Yeecüwa äätin aŋ täämme yokïn, aŋ kiinne ogo, “Juwe ñaalok, ŋana ikee booje.” ");
INSERT INTO jum_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aŋ wääna waŋgen äärene daa ñaalok ye, i iken batta a yuṭin mäŋkalaŋ a Yeecüwa pare. ");
INSERT INTO jum_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aŋ wääna iken kääcete ïñï pääm wic ye, i iken koli Yeecüwa ogo, “Mäŋkalaŋ ŋana nüütkede kä gin'a yoorre yaanni, ke Minneni Mänbaan juwe ñaalok tüwnü ti.” ");
INSERT INTO jum_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aŋ taaji baaddoni yeeke ogo, “Aŋ nüütoni yek jiik ḍoocin yek Jooŋ jayok ogo Ïlïya ken bi ïïjo äätin ina?” ");
INSERT INTO jum_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aŋ ike luukcin ogo, “Ïlïya äätïdï, aŋ wakkä bi toode muure. ");
INSERT INTO jum_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ikee kiine Ïlïya äätin ḍaŋŋa aŋ batta a ŋïcon kä me, aŋ näŋgi gin'a ṭäkkänä ye. Aŋ Minneni Mänbaan cäänna bi wääcï ïnken ti.” ");
INSERT INTO jum_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aŋ wäättan ooki gïtï baaddoni ogo jaayo ogo Büüṭo Yaaya. ");
INSERT INTO jum_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aŋ wääna äätene ti ye, oon yaŋkalaŋ äätin ike ti, aŋ ḍüŋjïn ïñï ñome ti. ");
INSERT INTO jum_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aŋ jaajjin ogo, “Mügdo, minneni yeeni ängä ŋïngïn, ike ḍïïmdïdï i wääcï pillä kä yaac. Aŋ ääŋkalaŋ ḍïïmjïdï maccük ke piitti. ");
INSERT INTO jum_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aŋ äckänä baaddoni yüükü, aŋ batta agene lïïlgon kä ṭeeññä. ");
INSERT INTO jum_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aŋ Yeecüwa luukcin ogo, “Ikee yaaka luggin yeenic ḍeeraŋ aŋ age kil yaaññä ye! Ke tooku ika cääyä ke ikee? Aŋ ke tooku ika wääcä ke ikee? Minneni ickakä winni.” ");
INSERT INTO jum_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aŋ Yeecüwa meŋkeeke gerre, aŋ kääjin woo minneni ti, aŋ minneni ṭeññä kä bïraŋ. ");
INSERT INTO jum_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aŋ baaddoni äätin Yeecüwa ti pääken, aŋ tääccin ogo, “Aŋ batta ñoolcodon woo ina?” ");
INSERT INTO jum_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aŋ iken kiini Yeecüwa ogo, “A luggin yeenic ḍine. Ikee kiine a gïtken naana ïkï cääygi luggin bata jaan yaana beel bata jallä käwconḍe, aŋ pääm yaanni kiinä ogo bagä wïca ye, i daa bak. Aŋ baati gin'a teyaŋ ïkï ti ye. ");
INSERT INTO jum_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Aŋ wääna yoken ḍülte daa Jalïïl ye, i iken kiini Yeecüwa ogo, “Minneni Mänbaan bi müükkünü me mäbaan, ");
INSERT INTO jum_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","aŋ bi näkä me ḍok, aŋ ike bi juwu ñaalok nïïnnä ḍäk ti.” Aŋ baaddoni yeeke nüüjjïn. ");
INSERT INTO jum_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aŋ wääna Yeecüwa ke baaddoni yeeke äätene Kaparnahuum ye, i ḍüṭoni yek änlaṇṇä äätin Bütürüc ti aŋ taaji ogo, “Nüüto yüünü batta äccïdï ḍüllü yen änlaṇṇä?” ");
INSERT INTO jum_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aŋ ike gïmmïn ogo, “Ee.” Aŋ wääna ike äätenee ti än jï ye, i Yeecüwa ïïjjïn jaajjin ike ti ogo, “Ïkï paydä ogo ŋaaka, Camaan? A ŋaani ken kujdene kä yätkäni yek ŋommañ wiñe ñuugulani ke ḍüllüni? A merkä yeeken ti halla a m'aka batta a mä baan ye ti?” ");
INSERT INTO jum_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aŋ luugi Bütürüc ogo, “A m'aka batta a mä baan ye ti.” Aŋ Yeecüwa ike kiini ogo, “Aŋ aŋan merkä yeeken tetgaŋ. ");
INSERT INTO jum_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aŋ ïkïïn batta ṭäkïn iken peeṇtïn, atä cääl jï aŋ yiipcä gora aŋ kuju yakcan yaana ïïjïdï ye, naana poŋe kupkini ye, i ïkï bi käñä tiilñan gällä waŋe. Koowu aŋ äckeeda kä, aŋ iñjeeda a yeeni ke yüünü. ");
INSERT INTO jum_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aŋ waan yaanja ti baaddoni äätin Yeecüwa ti aŋ taaji ogo, “A ŋaani ken yäwaŋ Yätkïtïn Polloŋ jï ti?” ");
INSERT INTO jum_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aŋ ike bääṭin ti minnenile, aŋ yuutte ñomgen ti. ");
INSERT INTO jum_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aŋ ike jaajjin ogo, “Ikee kiine a gïtken, naana ikee batta beeljede bata merkälen ye, ikee batta bi kaace ti Yätkïtïn Polloŋ jï ti. ");
INSERT INTO jum_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aŋ m'ana ḍoŋe ḍuuge ïñï bata minnenile yaanni ye, ken bi a m'ana yäwaŋ Yätkïtïn Polloŋ jï ye ti. ");
INSERT INTO jum_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aŋ m'ana gïmgïn minnenile bata yaanni kä yäṇtonḍi ye, i ika gïmgana. ");
INSERT INTO jum_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Aŋ m'ana merkälen lïcken yaakki yaaka a luggïnï kä ika ye puge ḍuuggin kä nääŋkä yaackä ye, iiñca päjjïdï men yaanna ḍikkänä me ḍok päämḍeynä mooye aŋ yeepänä me kul wii mooye jï. ");
INSERT INTO jum_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Jooññu ŋommañ wic kä wakkä yaaka naŋtä me a yek yiñ ye! Bääkkan daa päjjïdï waak yaakka näŋï ḍuuggen, aŋ jooññu m'ana äätete puuccin ye ti! ");
INSERT INTO jum_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Aŋ naana a ïṇtü ke kïyü ken ïkï pugey ḍok kä yiñ ye, iirä woo aŋ yeepci woo, iiñca päjjïdï ïkï kaacci ti üṇṇü ti ke cüle ïṇtü kä keelok ke kïyü kä keelok, kä yaana ïnkü ke kïïgü muuṭuk biltene ti, aŋ yeepini me maañ yaana ke cüle ye ti. ");
INSERT INTO jum_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aŋ naana a waŋü ken ïkï pugey ḍok kä yiñ ye, luulu woo aŋ yeepci woo, iiñca päjjïdï ïkï kaacci ti üṇṇü ti waŋü kä keelok, kä yaana waŋgü muuṭuk biltene ti, aŋ yeepini kä me maañ yaana ke cüle ye ti. ");
INSERT INTO jum_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Waŋgic tïïce ṭeṭaŋ ŋana merkälen lïcken yaakki waagde. Aŋ ikee kiine malaŋŋi yeeken polloŋ jï Wäyo daamgä waŋgin kamat polloŋ jï. ");
INSERT INTO jum_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Aŋ ikee payde ogo, ŋaaka? Naana men yaŋkalaŋ cäygene käbälgä caykä kä caay, aŋ keelok yääynä meken ti ye, ike batta bi yaaka caykä kä waŋäḍeŋ witken kä waŋäḍeŋ ye cake ïñï pääm wic, aŋ ike atï määjï yaana a yääyon ye? ");
INSERT INTO jum_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ikee kiine a gïtken, naana kaññe ye, ike jone bi ñapï kä yaac kä yaana kaññeeda kä yaanna, kä yaaka caykä kä waŋäḍeŋ witken kä waŋäḍeŋ batta a yääyin ye. ");
INSERT INTO jum_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aŋ cäänna batta a ṭäktäŋ yen Wääc yaana ñaalok polloŋ jï ye, ogo merkälen lïcken yaakki ti yaŋkalaŋ yääyo. ");
INSERT INTO jum_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Aŋ naana määdic ke käwic näŋŋä yiñ ïkï ti ye, atä aŋ nüütkü yiñ yeene waan yüünü ke ike pare. Aŋ naana ïkï tiiŋgeney ye, i ïkï käññi määdic. ");
INSERT INTO jum_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aŋ naana ïkï batta agä tïïŋgïnï ye kuju mäŋkalaŋ kä keelok ke yew aŋ ḍukce kä ke ïkï ŋuca nuŋko jiik'a jaayne ye yuute daa, kä biltin ti m'aka a yuṭin kä yew ke ḍäk ye. ");
INSERT INTO jum_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aŋ naana ike yaakkä kä tiiŋgin iken ye, i nüütkü äntüke Macii, aŋ naana ike yaakkä cäänna kä tiiŋgin äntüke Macii ye, dalä ike wäätï ïkï ti bata waanjï ke ḍüṭoni yaacken. ");
INSERT INTO jum_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ikee kiine a gïtken, gin'a ḍeŋŋe ŋommañ wic ye, i cäänna daa bi a ḍekon polloŋ jï, aŋ gin'a gütkene ŋommañ wic ye, i cäänna daa bi a gütkïnï polloŋ jï. ");
INSERT INTO jum_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Aŋ ikee kiine a gïtken ŋuca, naana mäkkalaŋ kä yewwe ikee ti gïmmïn ŋommañ wic kä gin'a tääccene ye, i bi näŋgene daa Wäyo yaana ñaalok polloŋ jï ye. ");
INSERT INTO jum_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aŋ naana mäkkalaŋ kä yewwe ke ḍäk yoken ḍülï nänṭä keellä kä yäṇtonḍi ye, i wïca ika agä waadgen ti.” ");
INSERT INTO jum_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Aŋ Bütürüc äätin Yeecüwa ti aŋ taaññe ogo, “Mügdo, naana määdo ïïñjïdï ika näŋgada nääŋkä yaackä ye kulku ääŋki kä ŋïṭṭä? Ääŋki kä ŋaṭükel?” ");
INSERT INTO jum_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aŋ kiini Yeecüwa ogo, “Ïkï batta kiinneni ogo ääŋke ko ŋaṭükel, a caykä kä ŋaṭükel ääŋke kä ŋaṭükel. ");
INSERT INTO jum_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Aŋ aŋŋi ina ken Yätkïtïn Polloŋ jïñe iircete daa me ke yätkä yaana ṭäkï ḍuccïdï ïñï ñuuguloni yeeke yaaka ike cääyge mïïngä iken ti ye. ");
INSERT INTO jum_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aŋ wääna ïïjjene cäjjin ïñï ye, i äcki me men kä keelok yaana a kujon mïïngä ike ti ye, 10,000 yek tiil. ");
INSERT INTO jum_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aŋ batta cäyge gin'a wänee kä mïïngä ye, aŋ yätkä yeene iinjin jiik ogo ike yääjjïï me woo ke iiŋe ke merkälen yeeke ke wakkä yeeke yaaka bilto ti ye muure ken wänjeko mïïngä. ");
INSERT INTO jum_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Aŋ ñuugulo yeene ḍüŋjïn ïñï ñome ti, aŋ ike ñujgi yok ogo, ‘Yuudu por aŋ waak yüükü bi wängenii kä muure.’ ");
INSERT INTO jum_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aŋ ike ängi ŋïngïn yätkä yeene aŋ kulkene kä mïïngä aŋ äkkene attä. ");
INSERT INTO jum_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aŋ wääna ñuugulo yaanna kaaccee kä woo ye i pärjin ke muukonḍe yaana agene kä ñuuguloni ye, a kujon tiil ike ti caykä kä caay, aŋ müŋŋe maaññe pok aŋ kiiṇde ogo, ‘Wängaa mïïngä yeeki yaaka agii kä koowgin ika.’ ");
INSERT INTO jum_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Aŋ menen yaana agene kä kiinkä ye ḍüŋjïn ïñï aŋ ike ñujgi yok ogo, ‘Yuudu por aŋ waak yüükü bi wängenii.’ ");
INSERT INTO jum_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aŋ ike yaakkä aŋ koowne aŋ äññe äcce gaŋgar ke mïïngä wanjeeda ko. ");
INSERT INTO jum_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aŋ wääna ñuuguloni yakkalaŋ yuṭṭene gin'a näŋŋä ḍoŋe ye, iken juuggen yejgin kä yaac, aŋ iken attä yätkä yeenen nüütkï kä wakkä yaaka näŋŋä ḍuuggen yaakka. ");
INSERT INTO jum_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aŋ bärki yätkä aŋ kiinne ogo, ‘Ïkï ñuugulo yaajgonḍe ïkï kulkeneni kä mïïngä yüükü muure kä yaana ñujganaa kä yok ye. ");
INSERT INTO jum_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aŋ ïkï müükonḍü batta ängä ŋïngïn bata yaana ängenenii ŋïngïn ye?’ ");
INSERT INTO jum_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aŋ yätkä pennä kä yaac, aŋ müükkene ḍujoni ogo ḍooyjï, ke mïïngä wanjeeda ko muure. ");
INSERT INTO jum_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Aŋ cäänna Wäyo yaana polloŋ jï ye, ikee bi naŋde kä nääŋkä keelkä aŋan naana m'ana määden ke käwen batta kulkede jone ti ye. ");
INSERT INTO jum_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aŋ wääna Yeecüwa ḍaŋŋee kä jiik yaakki ye, ike Jalïïl daljene ïñï, aŋ attä baan mä Yühüdïya ti kä ñomuk wii mä Üürdün ti. ");
INSERT INTO jum_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aŋ ṭoŋ ḍiirken bäätcin ike ti aŋ ṭeeññe wïca. ");
INSERT INTO jum_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aŋ Pïrrïcïïnnï yakkalaŋ äätin ike ti, aŋ ike puuci taaji ogo, “Yoku päjjïdï oon iiŋe äkke kä jiik'a bilti ye?” ");
INSERT INTO jum_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","“Aŋ luugi Yeecüwa ogo, “Ikee batta age päkin Meeŋka jiik Jooŋ jï ogo Näŋo ïïjjïn ti, iken naŋŋïï ogo oon ke iiŋ? ");
INSERT INTO jum_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aŋ ike jaajjin ogo, ‘Ina ken oon wäyen ke meen daleeda buwin aŋ yore cooṭeeda ti iiŋe ti, aŋ wäätene agene gaan keellä yaanna. ");
INSERT INTO jum_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Aŋ iken batta ŋuca a yew aŋŋa men keelok, aŋ gin'a coori yok Jooŋ ye dale ŋana piirgä gïtï mänbaan.” ");
INSERT INTO jum_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aŋ taaji ogo, “Aŋ Müüca iccin jiik ogo men iiŋe iñje meeŋka äkkin aŋ äkkee ina?” ");
INSERT INTO jum_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aŋ kiini Yeecüwa ogo, “A juuggic teynen ken ina tiiŋgene kä Müüca ogo määngic dalje buw yaanna, aŋ wääna ïïjjïn ti ye batta aŋan. ");
INSERT INTO jum_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aŋ ikee kiine, m'ana iiŋe äkkene kä jiik yakkalaŋ batta kä balkïtïn aŋ kuññu iiŋ yaŋkalaŋ ye, i aŋan näŋit balkïtïn.” ");
INSERT INTO jum_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aŋ kiini baaddoni yeeke ogo, “Aŋ naana a biilkä ika yek waadgä oon ke iiŋ ye, iiñca ŋana men kujit.” ");
INSERT INTO jum_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aŋ kiinne ogo, “Yaakki batta lïïltä gïmkätä me muure, a m'aka a yüükkïnï ti kä Jooŋ ye pääken. ");
INSERT INTO jum_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mäkkalaŋ a giitin kä migen a lucku, aŋ mäkkalaŋ a dïkïn kä mäbaan aŋ mäkkalaŋ wäkï cäwdä bata lucku ogo Yätkïtïn Polloŋ jïñe. M'ana lïïṭït gïmgïdï yaakki ye, i dale gïmge. ");
INSERT INTO jum_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Aŋ merkälen äbi me ike ti ogo ïnke ḍoocce witken ti aŋ ŋüülkee. Aŋ baaddoni me geri. ");
INSERT INTO jum_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aŋ Yeecüwa jaajjin ogo, “Dale merkälen ätä ika ti, aŋ ŋana ṭïïge, bata yaakki Yätkïtïn Polloŋ jïñe a yeenen.” ");
INSERT INTO jum_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aŋ ïnke ḍoocce witken ti aŋ ŋüülkene aŋ kaaccä woo. ");
INSERT INTO jum_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aŋ oon yaŋkalaŋ äätin ike ti aŋ ike taaji ogo, “Nüüto, a nääŋkä ŋerkä yaaka wali ye, ken bi naŋä käñä üṇṇü ke cüle?” ");
INSERT INTO jum_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aŋ kiini Yeecüwa ogo, “Ika tajdaa kä ŋerrä ina? M'ana ŋeraŋ ye a Keelok. Aŋ naana ïkï ṭäkä kaaccin ti üṇṇü ti ye jiik ïïnïnï tïïjä.” ");
INSERT INTO jum_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aŋ ike taaji ogo, “A jiik ïïnïnï yaaka wali ye?” Aŋ Yeecüwa jaajjin ogo, “Ŋana ïkï nääkä me, ŋana ïkï näŋä balkïtïn, ŋana ïkï käṭä, aŋ ŋana ïkï päkä kä yelkïtïn. ");
INSERT INTO jum_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wääc ke miic eemdä, aŋ m'ana yiire kä ye bilgä bata yorü aŋan.” ");
INSERT INTO jum_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aŋ kiini oon yaanna ogo, “Jiik ïïnïnï yaakka agä naŋdïnï muure, aŋ a ŋaaka ken mor buunu ika ti? ");
INSERT INTO jum_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aŋ kiini Yeecüwa ogo, “Naana ïkï ṭäkä wäätci agä küümon ye, atä aŋ waak yüükü yääjjä woo muure aŋ pääggä aangï aŋ ïkï bi cääygi waak ŋerkä ñaalok polloŋ jï, aŋ wäättan äätä, baaddaa.” ");
INSERT INTO jum_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aŋ wääna oon yaanna tiiŋŋee kä aŋan ye ike kaaccä woo i jone yaajaŋ nääŋka ike agee kä ceeggon ye. ");
INSERT INTO jum_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aŋ Yeecüwa baaddoni yeeke kiinne ogo, “Ikee kiine a gïtken, teyaŋ kä yaac kä kaaccin ti m'ana a ceeggon ye Yätkïtïn Polloŋ jï ti. ");
INSERT INTO jum_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aŋ ŋuca ikee kiine poṭulaŋ kä kaaccin woo kalman kääl tun ti kä yaana ceeggon kaacee kä ti Yätkïtïn Jooŋ ti ye. ");
INSERT INTO jum_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aŋ wääna baaddoni tiiŋŋene aŋan ye, i witken ḍiiktin kä yaac aŋ jaajjin ogo, “Aŋ a ŋaani ken bi käñï mäkkin?” ");
INSERT INTO jum_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aŋ Yeecüwa däämjin iken ti aŋ kiinne ogo, “Naana mäbaan ti ye yaakki batta a päyin, aŋ naana Jooŋ ti ye wakkä muure a päyin. ");
INSERT INTO jum_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aŋ kiini Bütürüc ogo, “Yooru ikoon wakkä muure daljonon aŋ ikoon bäätonon ïkï ti. Aŋ a ŋaaka ken bi kañon?” ");
INSERT INTO jum_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aŋ iken kiini Yeecüwa ogo, “Ikee kiine a gïtken, waan yaana wakkä muure naŋge daa me a kïccäŋgenen ye, aŋ Minneni Mänbaan cääjjee nook yen maaŋŋä yeene ti ye, i ikee yaaka ika baaddana ye, ikee cäänna bi cääjje nooŋŋi caay witken kä yew mügde äärgä tüggen yek mä Icärayiil yaaka caay witken kä yewwe ye. ");
INSERT INTO jum_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aŋ m'ana äärgä yeeke daljene ïñï ke mädgen ke käwgen ke wäyen ke meen ke merkä yeeke ke yiil yeene ogo ika ye, bi käñï ääŋke caykä kä caay a küümïn, aŋ bi yätï üṇṇü ke cüle. ");
INSERT INTO jum_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aŋ me ḍiirken yaaka ḍoŋgaŋ tiññaŋ ye, bi wäätï a m'aka batta tïïlcïdï ye, aŋ m'aka daamgä me batta tïïlcïdï tiññaŋ ye, ken bi wäätï a me mäyken. ");
INSERT INTO jum_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Aŋ Yätkïtïn Polloŋ jïñe beel bata men mooye yen yiil yaana murjin woo kä tïṇṇäŋänä määjï ñuuguloni ije yiil jï baanne ye. ");
INSERT INTO jum_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aŋ ike gïmmïn kä iñdin ñuuguloni, ñuugula carrä yen äŋ jïñe yaana lïïkïdï ye, aŋ tucce yiil jï baanne. ");
INSERT INTO jum_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ike ŋuca kaaccä woo äŋ poŋe mä tïṇṇäŋänä ti, aŋ yurcin mäkkalaŋ yudok batta ñuugal ginkalaŋ weeldük. ");
INSERT INTO jum_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aŋ kiinne ogo, ‘Ate cäänna ñuugele yiil yeeni jï, aŋ ikee bi iñe gin'a päjjïdï ye.’ ");
INSERT INTO jum_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aŋ iken attä yiil jï ñuugal. Aŋ ike kaaccä woo äŋ ṭeejjük, aŋ ŋuca kaaccä woo äŋ a gïïjjïnï woo, aŋ näŋjin kä yuudu keellä. ");
INSERT INTO jum_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Aŋ wääna wuuŋ mä biigin ti cokelenee ye, i ike kaaccä woo, aŋ käññä yakkalaŋ yudit. Aŋ taaññe ogo, ‘Ikee yudde winni äŋ yoome ikee batta ñuugele ina?’ ");
INSERT INTO jum_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Aŋ iken luukcin ike ti ogo, ‘Baati m'ana ikoon agon kä müükkïnï ñuugula ye.’ “Aŋ kiinne ogo, ‘Ate ñuugele yiil jï baanni cäänna.’ ");
INSERT INTO jum_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Aŋ wääna biigin ti ḍäägenee ye, män yiil m'ana agee kä ḍoocon ye, kiinne ogo, ‘Ñuuguloni bärkä iñä ñuugula carrä yeeken aŋ ïïjjä ti kä m'aka äätin ŋäjäk ye, ke ḍakci kä m'aka ïïjjïn ti ye.’ ");
INSERT INTO jum_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aŋ wääna m'aka müükkï me ñuugula wuuŋ biigin ti äätene muure ye yaŋkalaŋ daa iñi me ñuugala carrä yen äŋ jïñe yaana lïïkïdï ye. ");
INSERT INTO jum_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aŋ wääna me yaaka a ïïjjïnï äätene ye, ḍüücï ogo iken bi kujo ko ḍiräk, aŋ iken yaŋkalaŋ daa iñi me ñuugala carrä yen äŋ jïñe yaana lïïkïdï ye. ");
INSERT INTO jum_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aŋ wääna ñuugala carrä yeeken koowene daa ye, iken uccin kä ŋümïrïn men mooye yen yiil ti, ");
INSERT INTO jum_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","aŋ jayok ogo, ‘M'aka äätin ŋäjäk ye ñuugulin a wuuŋ kä keelok, aŋ iirjini ke ikoon yaaka ñuugulonon äŋ jïñe muure carrä gïtï ye.’ ");
INSERT INTO jum_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Aŋ yaŋkalaŋ luugi män yiil ogo, “Muukonḍi ïkï batta agenii kä piikon, ïkï batta gïmmïnï kä ñuugala carrä yen äŋ jïñe yaana lïïkïdï ye? ");
INSERT INTO jum_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yüünü ken koowu aŋ atä. Ika ṭäkä iñdä m'aka äätin ŋäjäk ye, bata yaana iññenii kä ye. ");
INSERT INTO jum_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ika batta teedäteet kä nääŋka ṭäkkä naŋä kä tiil yeeki ye? Jonü gïïraŋ kä yaana agä men ŋerconḍe me ti ye? ");
INSERT INTO jum_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Aŋ m'aka a ŋäjäk ye, ken bi wäätï a ñomuk aŋ m'aka a ñomuk ye, ken bi wäätï a ŋäjäk.” ");
INSERT INTO jum_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aŋ Yeecüwa wääna atee kä Oorcalïïm ye, ike kuññu baaddoni yaaka kä caay witken kä yewwe ye pääken, aŋ kiinne päy jï ogo, ");
INSERT INTO jum_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tiiŋe! Ïkïïn atïn Oorcalïïm. Aŋ Minneni Mänbaan bi ääkkänä ŋäc ḍuuŋku däŋkä ke nüütoni jiik ḍoocin yek Jooŋ, aŋ bi joocu me ke tüwe. ");
INSERT INTO jum_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aŋ wäättana müükkünü boorgu, aŋ bi ñiyene kä yok, aŋ ḍooygu kä bäädan aŋ ṭeljänä ti kaakkon jok. Aŋ nïïnkä kä ḍäk bi juwu ñaalok tüwnü ti. ");
INSERT INTO jum_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Aŋ miy yen merkä Jabadï, äätin Yeecüwa ti ke merkä yeeke. Aŋ ḍüŋjïn ïñï aŋ ike ñujgi yok kä ginkalaŋ. ");
INSERT INTO jum_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aŋ taaji Yeecüwa ogo, “Ïkï ṭäkä ŋaaka?” Aŋ Yeecüwa luuŋŋe ogo, “Ika ṭäkä merkä yeeki yaaka kä yewwe yaakki yaŋkalaŋ cääjjï büŋü birrä aŋ yaŋkalaŋ buŋ aam Yätkïtïn yüünü ti.” ");
INSERT INTO jum_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Aŋ kiini Yeecüwa ogo, “Gin yaana ñuye yaanna batta ŋäjje. Ikee bi lïïṭe mätce kä ḍon yaana bi mätcä kä ye, aŋ ikee bi lïïṭe wääce pillä yaana bi waajä ye?” Aŋ iken gïmmïn ogo, “Ee.” ");
INSERT INTO jum_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aŋ kiini Yeecüwa ogo, “Ikee bi mätce ḍon yeeni aŋ cääjjin buŋ birrä ke buŋ aam ti batta a ika ken äccädä a ḍückïnï m'aka a wäägïnï woo kä Wäyo ye. ");
INSERT INTO jum_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aŋ wääna baaddoni yaaka kä caay ye tiiŋŋene aŋan ye, iken mädin yaakka pingi. ");
INSERT INTO jum_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aŋ bärki ti Yeecüwa aŋ kiinne ogo, “Ŋäjje mügdoni yek ŋommañ wiñe iken engä, aŋ me mäyken yeeken ñuugal mügdïn yeenen iken ti. ");
INSERT INTO jum_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ŋana beeljïdï aŋan ikee ti, aŋ m'ana ṭäkï wäätcïdï a men mooye ikee ti ye, dale wäätï a ñuugulo yeenic. ");
INSERT INTO jum_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aŋ m'ana ṭäkï wäätcïdï a men mooye ikee ti ye, dale wäätï a kiingon yeenic. ");
INSERT INTO jum_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aŋ Minneni Mänbaan batta äätin ogo, ike ñüügïlïï me, ogo me ñuugelee aŋ üṇṇü yeene rätce ko me ḍiirken. ");
INSERT INTO jum_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aŋ wääna kaaccene woo Ariya ye, ṭoŋ ḍiirken bäätcin ike ti. ");
INSERT INTO jum_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aŋ ook yaŋkalaŋ kä yew cäyok päy taaŋ a uykuni aŋ wääna tiiŋŋene Yeecüwa kaajdee kä ye, iken yaajjin ogo, “Mügdo ängoon ŋïngïn Minneni Daawüüt!” ");
INSERT INTO jum_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Aŋ geri ṭoŋ ogo, “Tiiŋje ïñï.” Aŋ ṭääkcin yawgin kä yaac ogo, “Mügdo ängoon ŋïngïn Minneni Daawüüt!” ");
INSERT INTO jum_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aŋ Yeecüwa yuuttu ïñï aŋ bärkene aŋ taaññe ogo, “Ikee ṭäke näŋge ŋaaka?” ");
INSERT INTO jum_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Aŋ iken luukcin ogo, “Mügdo pätkoon waŋgin. ");
INSERT INTO jum_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aŋ ängi ŋïngïn Yeecüwa, aŋ täämme waŋgin, aŋ kä ḍeeraŋ aŋŋi waŋgen pättä aŋ bäätcin ike ti. ");
INSERT INTO jum_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aŋ wääna iken äätene Oorcalïïm kä cokal ye, aŋ ḍäägene ti baanle Beetpaac pääm yaana wiñe a jengä jeytüünni ye ti, i Yeecüwa tuccin baaddoni yeeke kä yewwe ñomgen ti. ");
INSERT INTO jum_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Aŋ kiini Yeecüwa ogo, “Ate baanle yaana ñomgic ti yaanna, aŋ ikee bi käñe tüürüŋ a weengon ke tüürüŋle yeene gunne ti. Gütke aŋ icka kä. ");
INSERT INTO jum_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aŋ naana mäŋkalaŋ ikee taaññe ye, i kiine ogo ṭäkkïï ko Mügdo, aŋ ikee bi dale buwin äbe. ");
INSERT INTO jum_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yaakki wäättä ḍääkit yaaka jaayi Jooŋ kä bäṭo ye ogo, ");
INSERT INTO jum_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mä Oorcalïïm kiine ogo, ‘Yooṭe, Yätkä yeenic äätïdï ikee ti. Aŋ ike ḍoŋe agee ḍuugïnï ïñï, aŋ taabit tüürüŋ, aŋ a tüürüŋle ken taabdee kä.’” ");
INSERT INTO jum_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aŋ baaddoni yaaka kä yew ye näŋjin bata yaana eenjene daa kä Yeecüwa ye. ");
INSERT INTO jum_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Aŋ iken tüürüŋ äbi ke tüürüŋle ike ti, aŋ tüürüŋle ḍucki ŋäc buruŋgu yeeken, aŋ Yeecüwa taappä. ");
INSERT INTO jum_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Aŋ ṭoŋ ḍiirken buruŋgu yeeken peti ïñï päy jï ñome ti, aŋ yakkalaŋ ŋüülïn jengä kimken ken peti ïñï päy jï. ");
INSERT INTO jum_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aŋ ṭoŋ ḍiirken yaaka äätä ñome ti ke yaaka ŋäñe ti ye, yawdïdï ogo, “Maaŋŋä Jooŋ ti kä Minneni yen Daawüüt! Ŋüülkïn m'ana äätïdï kä yäṇtäŋ Pïṭo ye ti! Maaŋŋä Jooŋ ti küüṭṭülaŋ polloŋ jï!” ");
INSERT INTO jum_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aŋ wääna Yeecüwa kaaccee kä ti Oorcalïïm ye, baan jïñe yore cükke muure aŋ me tääccin ogo, “A ŋaani ina?” ");
INSERT INTO jum_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aŋ ṭoŋ luukcin ogo, “A bäṭo Yeecüwa, män Naacira yen mä Jalïïl.” ");
INSERT INTO jum_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Aŋ Yeecüwa kaaccä kaal yen änlaṇṇä jï, aŋ m'aka kïjï ke m'aka yääjï ye ñooṭṭe woo muure wïca, aŋ däräŋgä yek räṇṇä tiil uuljene ïñï ke nooŋŋi yek m'aka yääjï gülküteni ye. ");
INSERT INTO jum_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aŋ kiini Yeecüwa ogo, “A pergon Meeŋka Jiik Jooŋ jï ogo, ‘Än yeeni bi battä me ogo än mallä,’ aŋ yelle yok a än muddoŋŋi!” ");
INSERT INTO jum_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aŋ uykuni ke puudgu äätin ike ti änlaṇṇä jï, aŋ ṭeeññe. ");
INSERT INTO jum_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aŋ wääna ḍuuŋku däŋkä ke nüütoni yek jiik ḍoocin yek Jooŋ yuṭṭene nääŋkä yäwkä yaaka naŋde ye, aŋ merkälen yaawene änlaṇṇä jï ogo, maaŋŋä Jooŋ ti kä Minneni yen Daawüüt ye ti, i iken piiṇdin. ");
INSERT INTO jum_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aŋ iken Yeecüwa taaji ogo, “Merkälen yaakka jiiken tiŋdä?” Aŋ luugi Yeecüwa ogo, “Ee. Ikee batta age päkin Meeŋka Jiik Jooŋ jï? Jaay ogo, ‘Ïkï merkälen ke tüṇtülgü nüüṇṇï ogo ïkï maaŋjïda.’” ");
INSERT INTO jum_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aŋ iken dalji ïñï Yeecüwa kaaccä woo baan mä Oorcalïïm jï attä Betani, aŋ nïïnïn wïca. ");
INSERT INTO jum_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aŋ kä tïṇṇäŋänä wääna Yeecüwa ḍukcedee kä baan jï ye, näägi käñ. ");
INSERT INTO jum_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aŋ yurcin jaan ŋoommu päy taaŋ, aŋ umgene ti aŋ batta a käñon ṭulge, a gitke pääken. Aŋ kiinne ogo, “Ŋana ïkï giidä ṭülgü ŋuca!” Aŋ kä ḍeeḍaŋ aŋŋi jaan ïjjïn woo. ");
INSERT INTO jum_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aŋ wääna yoorene daa baaddoni ye, iken witken ḍiiktin, aŋ tääccin ogo, “Jaan ŋoommu yaanni ïwnä ogoo kä bïraŋ aŋŋi?” ");
INSERT INTO jum_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aŋ luugi Yeecüwa ogo, “Ikee kiine a gïtken, naana ikee cääyge kä luggin aŋ juuggic batta riijä ye, ikee batta bi a nääŋkä yaaka näŋŋä jaan ŋoommu yaanni ti ye, pääken ken bi naŋde. Aŋ cäänna naana pääm yaanni kiine ogo, ‘Ḍïmjä wii mooye jï’ ye, i bi näŋï ḍoŋe. ");
INSERT INTO jum_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Aŋ naana ikee cäygene kä luggin ye wakkä muure yaaka ñuye kä mallä ye, bi kañe.” ");
INSERT INTO jum_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aŋ Yeecüwa attä kaal yen änlaṇṇä jï, aŋ juwin nüüṇṇü me aŋ ḍuuŋku däŋkä ke yätïnï äätin ike ti, aŋ tääccin ogo, “A mügdïn yaana wali ye, ken ñuugilii kä waak yaakka, aŋ a ŋaani ken ïkï iññey mügdïn yaanni?” ");
INSERT INTO jum_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aŋ luugi Yeecüwa ogo, “Ikee cäänna bi taaje kä tääctäŋ kä keelok, aŋ naana ika luuŋŋa ye, ikee cäänna bi nüütke kä mügdïn yaana wali ye ken naŋdä kä waak yaakki. ");
INSERT INTO jum_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mügdïn Büüllü yen Yaaya ätä wa, ätä polloŋ jï halla ätä mänbaan ti?” Aŋ iken luugjin pääken ogo, “Aŋ bi yore luuge ogoo? Naana ïkïïn jaaccïn ogo ääto polloŋ jï ye, ike ïkïïn bi kïïnïn ogo, aŋ ikee batta luggede kä ike ina? ");
INSERT INTO jum_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aŋ naana ïkïïn jaaccïn ogo ääto mänbaan ti ye, ïkïïn boocïn kä ṭoŋ, me muure Yaaya ŋäjjänä a bäṭo.” ");
INSERT INTO jum_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aŋ iken Yeecüwa luugi ogo, “Batta ŋäjjon.” Aŋ kiini Yeecüwa ogo, “Cäänna ikee batta nüütkede kä mügdïn yaana wali ye ken ñuugulu kä.” ");
INSERT INTO jum_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aŋ iken taaji Yeecüwa ogo, “Ikee päje ogo ŋaaka kä yaanni? Oon yaŋkalaŋ cääyge merkä kä yew. Aŋ ike attä minneni yaana a ïïcca ye ti, aŋ kiinni ogo, ‘Minneni yeeni, atä ñuugulu yiil jï tiññaŋ.’ ");
INSERT INTO jum_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Aŋ minneni luukcin ogo, ‘Ika batta atä.’ Aŋ wäättan jone ääkkene aŋ attä. ");
INSERT INTO jum_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Aŋ wäy attä minneni kalaŋ ti aŋ kiinne kä jiik keelkä, aŋ ike jaajjin ogo, ‘Abba, ika bi atä.’ Aŋ batta a aton. ");
INSERT INTO jum_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“M'aka kä yewwe yaakki ti, a ŋaani ken näŋŋä ṭäktäŋ wäyen?” Aŋ iken luukcin ogo, “A ïïcca.” Aŋ iken luugi Yeecüwa ogo, “Ikee kiine a gïtken ḍüṭoni yaacken ke balkä ikee bi yütene ti Yätkïtïn Jooŋ ti. ");
INSERT INTO jum_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aŋ Yaaya äätin ikee nüütkede päy woṇṇu, aŋ ikee batta age luggïnï kä ike. Aŋ ḍüṭoni yaacken ke balkä ken luggin kä ike. Aŋ wääna yuṭṭee kä aŋan ye, ikee cäänna batta age luggïnï kä ike, aŋ ikee batta age ḍagin kä nääŋkä yaackä yeekic.” ");
INSERT INTO jum_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Aŋ Yeecüwa jaajjin ogo, “Gäärrä yaanni tiiŋe ŋuca. Aŋ wïca oon yaŋkalaŋ a män ŋommañ pïïttä yiil aŋ yaŋŋe yok kä kaal, aŋ ṭummu taga aŋ kuṭṭu än küülconḍe yen tïïco. Aŋ müükkene pïïtoni ogo pïïtcïko, aŋ ike ïñjï yen ŋommañ, aŋ ike attä woo baan yaŋkalaŋ ti. ");
INSERT INTO jum_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aŋ wääna waan errä cokulenee ye, ike tuccin ñuuguloni pïïtoni ti ogo ike äckïï me yeeke. ");
INSERT INTO jum_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aŋ pïïtoni ñuuguloni yeeke koowi aŋ keelok jiibi, aŋ yaŋkalaŋ nägi ḍok, aŋ yaana wäätcete kä ḍäk ye yibi kä guygu. ");
INSERT INTO jum_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aŋ tuccin ñuuguloni yakkalaŋ ŋuca ḍiräk kä yaaka ïïjjïn ye, aŋ näŋgi nääŋkä keelkä. ");
INSERT INTO jum_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Aŋ düüñïn ti tuckene minneni yeene aŋ jaajjin ogo, ‘A minneni yeeni bi eemtä.’ ");
INSERT INTO jum_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Aŋ wääna minneni yoorene daa ye, jaajjin ogo, ‘A minneni män yiil inni, ääte näkïn ḍok nuŋko yäṇṇä yeene koowïn daa kä ye.’ ");
INSERT INTO jum_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Koowi aŋ yeepi woo yiil taaŋ aŋ nägi ḍok.” ");
INSERT INTO jum_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aŋ Yeecüwa tääccin ogo, “Aŋ naana män yiil ätä ye yoku pïïtoni yaakka naŋe ogoo?” ");
INSERT INTO jum_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aŋ luugi ogo, “Me yaacken yaakka bi näge ḍuuggin kä näŋŋä yaajgonḍe, aŋ yiil bi müükke pïïtoni yakkalaŋ yaaka bi ike äckänä yeeke waan errä ti ye.” ");
INSERT INTO jum_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aŋ kiini Yeecüwa ogo, “Ikee batta age päkin Meeŋka Jiik Jooŋ jï ogo, ‘Jaan kïye yaana tüüññïï yok kuṭoni ye ken wäätto ogo taŋkuulu yaana tïïlcïdï ye, aŋ a yaana naŋi Pïṭo ye inni, aŋ ken yäwaŋ daammä yoono ti? ");
INSERT INTO jum_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Aŋ ikee kiine, Yätkïtïn yen Jooŋ bi aŋgänä me yok ikee ti, aŋ iñgä me ṭoŋ yaaka gidok jengä ṭulgen yeeke ye. ");
INSERT INTO jum_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aŋ m'ana ḍïmjï pääm yaanni gïtï ye bi liiktit, aŋ m'ana ḍïmgänä gïtï pääm yaanni ye bi ruumtit gïtï.” ");
INSERT INTO jum_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aŋ wääna ḍuuŋku däŋkä ke Pïrrïcïïnnï tiiŋŋene gäärrä Yeecüwa ye i ooki gïtï ike jaay ogo iken. ");
INSERT INTO jum_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Aŋ iken ṭäkï ogo yoku mügjï aŋ iken bojgin kä ṭoŋ yaaka Yeecüwa ḍooccutu ogo bäṭo ye. ");
INSERT INTO jum_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Aŋ ŋuca Yeecüwa jaajjin kä gäärrä, aŋ iken kiinne ogo, ");
INSERT INTO jum_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yätkïtïn Polloŋ jïñe beel bata yätkä yaana tuttu ammani ñäänkä yek minneni yeene ye. ");
INSERT INTO jum_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aŋ ñuuguloni yeeke tucce m'aka a bargin ye ti ogo, ääto ammani ñäänkä ti, aŋ iken muure yaakkä kä äätin. ");
INSERT INTO jum_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Aŋ ŋuca tuccin ñuuguloni yakkalaŋ, aŋ kiinne ogo, ‘M'aka a bargin ye kiine ogo ammani tooṇṇoo, aŋ näckälen caakken ke yätkä yeeki iirroo pugin, aŋ wakkä muureen ogo päjjïnï aŋ ääto ammani ñäänkä ti.’ ");
INSERT INTO jum_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Aŋ iken jiik yaakka gäälji woo, aŋ piirjin woo yaŋkalaŋ attä yiil jï baanne, aŋ yaŋkalaŋ attä ñuugula yeene ti. ");
INSERT INTO jum_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aŋ yakkalaŋ ñuuguloni yeeke müügï, aŋ aammi yokïn kä yaac aŋ nägi ḍugin. ");
INSERT INTO jum_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Aŋ yätkä pennä, aŋ tuccin kääygä yeeke ogo nääkoni nägjï ḍugin aŋ baan mooye yeenen tuñjïï woo. ");
INSERT INTO jum_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aŋ ñuuguloni yeeke kiinne ogo, ‘Ammani ñäänkä a päjjïnï aŋ m'aka barrïn ye, batta päjjïdï kä äätin. ");
INSERT INTO jum_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ate nänṭ'a purcete pääygä ye, aŋ m'aka kaññe ye bare muure dale ätä ammani ñäänkä ti.’ ");
INSERT INTO jum_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aŋ ñuuguloni yaakka kaaccä woo attä pääygä gïtï, aŋ m'aka kañi ye, ḍüülï ti muure ŋerken ke yaacken, aŋ än jïñe yen ñäänkä küümmü kä wilgä. ");
INSERT INTO jum_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aŋ wääna yätkä kääjenee kä äräk yurtee kä wilgä ye, ike yuṭṭu oon yaŋkalaŋ batta eŋit buruŋgu ñäänkä. ");
INSERT INTO jum_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aŋ taaññe ogo, ‘Muukonḍi, ïkï kääjini ogoo äräk winni, i ïkï batta cäygini kä buruŋgu ñäänkä aŋan?’ Aŋ oon batta a lüükcïnï. ");
INSERT INTO jum_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aŋ wina yätkä jaajjin ñuuguloni ti ogo, ‘Ḍiige ïnke ti ke kïïge ti, aŋ yeepe mïïllä gïtï, nänṭä ba' ïwok ke ŋeeynä me leken.’ ");
INSERT INTO jum_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","M'aka a bargin ye ḍiräk, aŋ ḍeewken ken a wakin. ");
INSERT INTO jum_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Aŋ Pïrrïcïïnnï attä woo, aŋ läälin pugin ogo Yeecüwa baabjï jaajjo jiikkalaŋ nuŋko mügjïda ko ye. ");
INSERT INTO jum_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aŋ tuccin baaddoni yeeken ike ti, ke yüükkodotini yek Ïïrüüdüc, aŋ kiini ogo, “Nüüto, ïkï ŋäjjini jiik'a a gïtken ye ken jaayä. Aŋ ïkï nüütü kä päy Jooŋ a gïtken. Aŋ ïkï batta booju kä mäŋkalaŋ, aŋ ïkï batta wäkä gïtï me. ");
INSERT INTO jum_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nüütkoon ïkï paydä ogo ŋaaka yaanni ti? Yoku päjjïdï ikoon äccon ḍüllü iñgä me yätkä Kaycar yen mä Ruumaan halla ba'ay?” ");
INSERT INTO jum_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aŋ yiñ yeenen ŋäjjänä Yeecüwa aŋ taaññe ogo, “Ikee lääñoni, Ika puuccada ina? ");
INSERT INTO jum_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nüütka tiil yaaka äccätä me ḍüllü ti ye.” Aŋ ike äcki me woo tiil yek Ruumaan. ");
INSERT INTO jum_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aŋ iken taaji Yeecüwa ogo, “Biilkä ke perrä yaanni a yen ŋaani?” ");
INSERT INTO jum_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aŋ iken luukcin ogo, “A biilkä yätkä Kaycar yen mä Ruumaan.” Aŋ kiinne ogo, “Waak Kaycar iñe Kaycar, aŋ waak Jooŋ iñe Jooŋ.” ");
INSERT INTO jum_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Aŋ wääna tiiŋŋene aŋan ye, iken witken ḍiiktin aŋ daljï ïñï aŋ kaaccä woo. ");
INSERT INTO jum_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aŋ nïïnnä yaanja ti Cüddügïïnnï äätin Yeecüwa ti, aŋ iken a m'aka jayok ogo juwin tüwnü ti baawgo ti ye, aŋ ike taaji, ");
INSERT INTO jum_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","aŋ kiini ogo, “Nüüto, Müüca jaay ogo, naana oon tüwno i merkä baawgo ti ye, i määden boro koowje ääcee ko woo merkälen yek määden. ");
INSERT INTO jum_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aŋ mädin yakkalaŋ kä ŋaṭükel waadgo ti winni. Ïïcca ḍiññä aŋ tüwnü, aŋ batta a giton merkä, aŋ iiŋ dälkene mädgen. ");
INSERT INTO jum_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aŋ cäänna bäätcin ke ḍäk näŋjin nääŋkä keellä aŋ attä ke ŋaṭükel ti muure. ");
INSERT INTO jum_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Aŋ düüñïn ti muure iiŋ tüwnü cäänna. ");
INSERT INTO jum_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aŋ äŋ jïñe yen juwin tüwnü ti, m'aka kä ŋaṭükel yaakka ti, iiŋ bi wäätï a yen ŋaani, iken yaaka kuññu yaakka ti?” ");
INSERT INTO jum_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aŋ iken luugi Yeecüwa ogo, “Ikee age yääyin kä yaana ikee batta ŋäjje kä meeŋkani ke teynä yen Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aŋ äŋ jïñe yen juwin tüwnü ti me batta ḍïjï, aŋ batta ḍeygä me, aŋ bi beeljï bata malaŋŋi polloŋ jï. ");
INSERT INTO jum_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aŋ ikee batta age päkin Meeŋka Jiik Jooŋ jï wääna Abrayiim ke Icaak ke Yaagüüp tüwgene kä on ye? I Jooŋ jaajjin ogo, ");
INSERT INTO jum_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ika agä Jooŋ yen Abrayiim, ke Jooŋ yen Icaak, ke Jooŋ yen Yaagüüp.’ Aŋ ike batta a Jooŋ yen mä tüwïn a Jooŋ yen mä üdïn.” ");
INSERT INTO jum_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aŋ wääna ṭoŋ tiiŋŋene nüüṇṇe ye, i witken ḍiiktin. ");
INSERT INTO jum_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aŋ wääna Pïrrïcïïnnï tiiŋŋene ogo Cüddügïïnnï lüüynïï witin Yeecüwa ye, i Pïrrïcïïnnï yoken ḍülï nänṭä keellä ogo taajjï ŋuca. ");
INSERT INTO jum_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aŋ yaŋkalaŋ iken ti a nüüto yen jiik ḍoocin yek Jooŋ, aŋ ike puuci taaji ogo, ");
INSERT INTO jum_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Nüüto, a iinin yaana wali ye, ken tïïlcïdï jiik ḍoocin yek Müüca ti?” ");
INSERT INTO jum_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Aŋ luugi Yeecüwa ogo, “‘Pïṭo yüünü Jooŋ bilgä kä jonü muure, ke yorü muure, aŋ ke paydinni yüükü muure.’ ");
INSERT INTO jum_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A iinin yaana tïïlcïdï aŋ ïïjjïdï ye inni. ");
INSERT INTO jum_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aŋ yaana bäätcïdï ye beel bata menen, ‘M'ana yiire kä ye bilgä bata yorü aŋan.’ ");
INSERT INTO jum_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aŋ jiik ḍoocin muure yek Müüca ke nüüṇṇü yen bäṭoni a ḍekin ti jiik ïïnïnï yaaka kä yewwe yaakki ti.” ");
INSERT INTO jum_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Aŋ wääna Pïrrïcïïnnï yoken agene daa kä ḍülgïn ye, i iken taaji Yeecüwa ogo, ");
INSERT INTO jum_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ikee payde ogo ŋaaka kä Macii? Ike a minneni yen ŋaani?” Aŋ luugi ogo, “A minneni Daawüüt.” ");
INSERT INTO jum_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aŋ kiinne ogo, “Aŋ Daawüüt jaay kä Wääktäŋ Jooŋ, aŋ Macii badde ogo ‘Mügdo yeeni,’ ina? Aŋ Daawüüt jaay ogo, ");
INSERT INTO jum_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Pïṭo jaajjin Mügdo yeeni ti ogo, “cääjjä buŋi birrä ti, ke ädäŋŋi yüükü ḍoocu daa kä ïñï kïïgü ti.’ ");
INSERT INTO jum_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Aŋ naana Macii battä Daawüüt ogo, ‘Mügdo yeeni,’ ye, i a minneni yeene ogoo?” ");
INSERT INTO jum_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aŋ jiik yeeke ti baati m'ana lïïṭït kä luuŋŋu ike ye. Aŋ nïïnnä yaanja ti baati m'ana yore ñuwaŋ kä tajdin ike ŋuca ye. ");
INSERT INTO jum_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aŋ Yeecüwa ṭoŋ ke baaddoni yeeke kiinne ogo, ");
INSERT INTO jum_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nüütoni yek jiik ḍoocin yek Jooŋ ke Pïrrïcïïnnï yaaka nüütï jiik ḍoocin yek Müüca ye. ");
INSERT INTO jum_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nääŋe aŋ gin'a kiiṇte kä ye gïmgede. Aŋ ŋana ikee baadde nääŋken, iken päkï aŋ batta naŋtä. ");
INSERT INTO jum_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iken ḍiigä ḍürdïnni pekkä, aŋ ḍooccutu me ḍuuggen ti, aŋ iken kä ḍuuggen batta ṭäkï ïnken cükcütü yokïn ogo me yüükkïï ti. ");
INSERT INTO jum_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Iken nääŋken muure naŋtä ogo yoorjï me. Iken eŋit meeŋkani mäyken buggen ti a ṭuurgin cäyge gïtï biykälen yek meeŋka laṇṇä, aŋ iken eŋit buruŋgu tüggen a bültani bääykä. ");
INSERT INTO jum_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aŋ iken billä nänṭä ba' eemdin ke nänṭä ba' jon ñamme, aŋ me ñomgen ti nänṭä ŋerrä daaŋmallä yen Yühüüṇṇï jï, ");
INSERT INTO jum_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","aŋ iken ŋïïptä me weeldük kä eemdin, aŋ bäärgä me ogo, ‘Nüütoni.’ ");
INSERT INTO jum_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Aŋ ŋana ikee bäärge me ogo, ‘Nüütoni,’ ikee cäygene kä Nüüto a keelok, aŋ ikee iire muurijaan. ");
INSERT INTO jum_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aŋ mäŋkalaŋ ŋana bääre ŋommañ wic winni ogo, ‘Wääc,’ ikee cäygene kä Wäy a keelok a Jooŋ, yaana ñaalok polloŋ jï ye. ");
INSERT INTO jum_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ŋana ikee gïmmede mäŋkalaŋ ikee bääre ogo, ‘Mügdoni,’ ikee cäygene kä Mügdo a keelok, a Macii. ");
INSERT INTO jum_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aŋ m'ana tälaŋ waadgic ti ye, dale wäätï a ñuugulo yeenic. ");
INSERT INTO jum_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aŋ m'ana ḍoŋe äärede ñaalok ye, i bi ḍuukunu me ïñï, aŋ m'ana ḍoŋe ḍuukcede ïñï ye, i bi ääränä me ñaalok. ");
INSERT INTO jum_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Jooññu ikee ti nüütoni jiik ḍoocin yek Jooŋ ke Pïrrïcïïnnï, ikee lääñoni! Ikee äntüke yen Yätkïtïn Polloŋ jïñe üüljene me ñomgen ti, aŋ ikee kä ḍuuggic batta kaaccede ti. Aŋ m'aka ṭäkï kaaccïdï ye, i batta bääggede kaaccïdï. ");
INSERT INTO jum_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Jooññu ikee ti nüütoni jiik ḍoocin yek Jooŋ ke Pïrrïcïïnnï, ikee lääñoni! Ikee atcede ircede woo wii mooye ke ŋommañ yilte kä yok men, aŋ naana men keelok yore yelle ye, i ike naŋe päjjïdï atï maccük ääŋke kä yew bata ikee. ");
INSERT INTO jum_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Jooññu ikee ti woydoni uyken yaaka jayok ogo, ‘M'ana lïïtto ko änlaṇṇä ye, batta ogo ginkalaŋ, aŋ m'ana lïïtto ko tiilgä änlaṇṇä ye, i ogo ḍekon ko lïïttäŋ yeene.’ ");
INSERT INTO jum_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ikee uykuni bucken! A yaana wali ye ken tïïlcïdï, a tiilgä, halla a änlaṇṇä yaana tiilgä laadde yok ye? ");
INSERT INTO jum_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aŋ ikee jaaye ogo m'ana lïïtto ko tambal ye batta ogo ginkalaŋ, aŋ m'ana lïïtto ko äccin yaana äccïdïï me tambal wic ye, i ike ogo ḍekon ko lïïttäŋŋi yeeke. ");
INSERT INTO jum_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Aŋ ikee uykuni! A yaana wali ye ken tïïlcïdï, a äccin halla a tambal yaana äccin laadde yok ye? ");
INSERT INTO jum_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aŋ m'ana lïïttä kä tambal ye, i lïïttä kä wakkä yaaka tambal wic yaakka muure. ");
INSERT INTO jum_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aŋ m'ana lïïttä kä änlaṇṇä ye, i lïïttä kä ike, aŋ ke Jooŋ yaana cääy ike ti ye. ");
INSERT INTO jum_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aŋ m'ana lïïttä kä polloŋ ye, i lïïttä kä nook yen Jooŋ, ke Jooŋ yaana cääy ike wic ye. ");
INSERT INTO jum_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Jooññu ikee ti nüütoni jiik ḍoocin yek Jooŋ ke Pïrrïcïïnnï, ikee lääñoni! Ikee waŋgic tïïccede kä äccin caycayni, yek waak garkä yaaka kañde balkä yeekic gïtï ye, bata jengä kïlkä, aŋ ikee gin'a tïïlcïdï jiik ḍoocin yek Jooŋ ti ye gääle gïtï, woṇṇu ke ängin ŋïngïn ke luggin. Yoku päjjïdï wakkä yaaka tïïlcïdï ye, ŋana gääle gïtï. ");
INSERT INTO jum_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ikee woydoni uyken! Ikee yüüñ aŋgede yokïn piitti, aŋ kalman ken lade! ");
INSERT INTO jum_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Jooññu ikee ti nüütoni jiik ḍoocin yek Jooŋ ke Pïrrïcïïnnï, ikee lääñoni! Ikee ḍon ke kooḍal laade kä üṇtük, aŋ külok jïñe ti küümï kä ḍäälkä, aŋ küümï kä jon tälle ke gaannä wakkä me. ");
INSERT INTO jum_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ikee Pïrrïcïïnnï uyken, paraŋ ïïjje ḍon ke kooḍal looke jï woo, nuŋko üṇtük bi latee kä woo ye. ");
INSERT INTO jum_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Jooññu ikee ti nüütoni jiik ḍoocin yek Jooŋ ke Pïrrïcïïnnï, ikee lääñoni! Ikee beele bata kälkä yaaka a weecin ladaŋ, aŋ üṇtük üükïdï woo ŋeraŋ, aŋ gïtken ti a küümon kä mä tüwïn äwgen aŋ waak muure ḍälaŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aŋ ikee cäänna üükede woo age mä wotku mäkkalaŋ ti, aŋ juuggic ti a küümïn kä lääñtäŋ ke ṭäktäŋ yen liiŋŋä gïtï jiik ḍoocin. ");
INSERT INTO jum_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Jooññu ikee ti nüütoni jiik ḍoocin yek Jooŋ ke Pïrrïcïïnnï, ikee lääñoni! Ikee bäte kälkä witken yek bäṭoni ke mä wotku yaaka näge ḍugin dänkä yurgic ye, aŋ ŋeerde yokïn. ");
INSERT INTO jum_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aŋ ikee jaaye ogo, ‘Naana yoku ikoon bilton ti nïïnkä dänkä yurgo ti ye, ikoon yoko batta yoku coorron kä näŋŋä bäṭo.’ ");
INSERT INTO jum_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“Aŋ kä jiik yeekic yaakka ikee nüüte kä ḍuuggic ogo ikee agje kilkä m'aka nääkono bäṭoni ye. ");
INSERT INTO jum_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ate ñomuk aŋ waak'a ïïjjene dänkä yurgic ye ḍaage. ");
INSERT INTO jum_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ikee käggä! Merkä pääñdaŋŋi! Ikee bi likce woo ogoo kä yiñ yen maañ? ");
INSERT INTO jum_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Ina ken tuckede kä bäṭoni ke ŋäjjoni ke nüütoni jiik ḍoocin yek Jooŋ yaakka. Yakkalaŋ bi näge ḍugin kä ṭellä kaakkon jok, aŋ yakkalaŋ bi ḍooye daaŋmallä yen Yühüüṇṇï jï, aŋ bi ñoole baan ke baan. ");
INSERT INTO jum_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aŋ kä yaakki jooññu bi käjä ïñï ikee ti kä yïmgä mä wotku muure yaaka puuktin ŋommañ wic ye, ïïjjïdï ti kä yïmgä män woṇṇu Abïïl ke yïmgä Jakarïya ti minneni Barakïya yaaka näŋŋe waadgä änlaṇṇä ke tambal ti ye. ");
INSERT INTO jum_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aŋ ikee kiine a gïtken jooññu yaanna muure bi ätä ïñï kilkä yaakki ti. ");
INSERT INTO jum_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ay! Oorcalïïm, Oorcalïïm, baan mooye yaana nääkä bäṭoni, aŋ yibbä tüüjgï yek Jooŋ ye, ääŋki aŋŋa ŋïṭṭä muure ika ṭäkä ogo merkä yüükü ḍüljo yokïn bata aaṭṭä yaana ṭulge ḍülde yokïn bugge ti ye, aŋ ika batta bääggadaa! ");
INSERT INTO jum_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yoore än yeenic dälkene kä Jooŋ elaŋ. ");
INSERT INTO jum_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ikee kiine, a gïtken ika batta bi yoora ŋuca ke jaajje kä ogo, ‘Ŋüülkïn m'ana äätïdï kä yäṇtäŋ Pïṭo ye.’” ");
INSERT INTO jum_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Aŋ Yeecüwa kääjin woo kaal yen änlaṇṇä jï aŋ wääna atee kä ye, baaddoni yeeke äätin ike ti, aŋ ike nüütcütü ogo, däämjo baṇṇäni yek änlaṇṇä ti. ");
INSERT INTO jum_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aŋ luukke ogo, “Baṇṇäni yaakka muure yoodde? Ikee kiine a gïtken, baati pääm yaana bi mañjänä me menen wic ye, bi ḍüümtït gïtï muure.” ");
INSERT INTO jum_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aŋ wääna Yeecüwa cääjjenee kä pääm yaana wiñe a jengä jeytüünni ye ti, i baaddoni yeeke äätin ike ti pääken, aŋ ike taaji ogo, “Nüütkoon waak yaakki bi näŋe ḍuuggen tooku? Aŋ a ŋaaka ken bi a gin'a nüütï äätin yüünü ke düüñïn yuungu ye?” ");
INSERT INTO jum_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Aŋ luugi Yeecüwa ogo, “Waŋgic tïïce ŋana ikee yääyte mäŋkalaŋ. ");
INSERT INTO jum_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Me ḍiirken bi ätä kä yäṇtonḍi, aŋ jayok ogo, ‘Ika agä Macii!’ Aŋ iken me ḍiirken bi malgä ŋïngïn. ");
INSERT INTO jum_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aŋ ikee bi tiiŋe kä yääñdaŋŋi, ke jigärgä yek yääñdaŋŋi, aŋ ŋana yokic cükcede, waak yaakka bääkkan daa bi näŋï ḍuuggen, aŋ batta mor a düüñïn ina. ");
INSERT INTO jum_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aŋ ṭoŋ yakkalaŋ bi juwu kä yiñ ṭoŋ yakkalaŋ ti, aŋ yätkïtïn bi juwu kä yiñ yätkïtïn ti. Aŋ käñ bi wäätï ke buktuŋ ŋommañ nänkä yaaka a päkkitṇi ye ti. ");
INSERT INTO jum_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aŋ yaakki muure a ïïjjïn ti pillä yen giidä aŋ yaŋkalaŋ mor irä. ");
INSERT INTO jum_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Aŋ wäättan ikee bi müüke me, aŋ näke me ḍugin, aŋ ikee bi putkene gïtï ṭoŋ muure ogo ika. ");
INSERT INTO jum_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Aŋ waan yaanja ti me ḍiirken bi ñomgen yeljänä woo luggin ti, aŋ bi äägä ŋätin, aŋ bi puudu gïtï waadgen ti. ");
INSERT INTO jum_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aŋ bäṭoni ḍiirken yaaka a yeloŋŋi ye, bi ükü woo, aŋ me diirken bi yääygä ḍugin. ");
INSERT INTO jum_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aŋ kä ḍiirin yen liiŋŋä gïtï jiik ḍoocin, biilin yen me ḍiirken bi lüy. ");
INSERT INTO jum_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aŋ m'ana wääcï ke düüñïn ti ye, bi käñï mäkkin. ");
INSERT INTO jum_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aŋ Jiik Ŋerkä yen Yätkïtïn Polloŋ jïñe bi pakä me ŋommañ wic muure, nuŋko tiiŋge daa ṭoŋ muure, aŋ wäättan düüñïn bi ätä. ");
INSERT INTO jum_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ikee bi yuṭe ḍällä yen cüültïn yaana jaayi bäṭo Ḍaniyal ye, yudit külok Änlaṇṇä.” Dale m'ana päkï ye ükcï gïtï. ");
INSERT INTO jum_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Aŋ wäättan dale m'aka Yühüdïya ye, lüdok pämkä witin. ");
INSERT INTO jum_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aŋ dale m'ana cääy daaŋ wic ye, ŋana kääjïdï ïñï ogo ike kujje gin'a äräk baanne ye. ");
INSERT INTO jum_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aŋ dale m'ana yiil jï ye ŋana ḍükcïdï ŋäjäk ogo ike kujdee burŋu yeene. ");
INSERT INTO jum_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aŋ bi yaajaŋ kä yaac määngä yaaka lacok ke yaaka nïïtï ye nïïnkä yaakca ti! ");
INSERT INTO jum_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mäṭe nuŋko ŋana ŋañ yeenic wäätcedee a wiiññäk aŋŋi ke Äŋ Jïñe Wääktäŋ ti. ");
INSERT INTO jum_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aŋ pillä mooye bi näŋï ḍoŋe waan yaanja ti, yaana batta a näŋon ḍoŋe wääna daa kä ïïjjïn ti ŋommañ ye, ke tiññaŋ. Aŋ batta bi ŋüccï näŋï ḍoŋe ŋuca. ");
INSERT INTO jum_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aŋ naana nïïnkä yaakca batta ŋüüŋtü me yokïn ye, i baati m'ana bi üt ye, aŋ kä jiik mä wakin yek Jooŋ ken nïïnkä yaakca bi ŋüüŋge daa me yokïn. ");
INSERT INTO jum_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aŋ naana mäŋkalaŋ ikee kiinne ogo, ‘Däämme Macii inninne,’ ke ogo, ‘ïya wïca,’ ye, ŋana ikee luggede. ");
INSERT INTO jum_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Maciini yaaka a yeloŋŋi ke bäṭoni yaaka a yeloŋŋi ye bi ükü woo, aŋ näŋï nääŋkä ke waak'a yäwaŋ ye, ogo yääjjï ko witin me, ke cäänna m'aka a wakin kä Jooŋ ye naana päjjodo ye. ");
INSERT INTO jum_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yoore, ikee nüütkene kä yaakki i batta mor wuuŋ ḍägä. ");
INSERT INTO jum_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Aŋ naana mäŋkalaŋ ikee kiinne ogo, ‘Däämje, Macii ïya luummuk,’ ye, ŋana ikee kaaccede woo. Aŋ naana jaajjin ogo, ‘Däämme ike inni äräk,’ ye, ŋana ikee luggede. ");
INSERT INTO jum_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bata yaana wïldïn diikede kä ñomuk atee ke ŋäjäk ye, bi beeljï bata äätin yen Minneni Mänbaan. ");
INSERT INTO jum_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Aŋ nänṭ'a cäyge gin tüwon ye, i weñgä yoken ḍültü wïca. ");
INSERT INTO jum_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Aŋ kä ḍeeraŋ aŋŋi naana tïñïdïn yen nïïnkä yaakca ti düüñïn ye, äŋ bi üljï ïñï, aŋ paan batta bi dïkï aŋ kiṭṭäni polloŋ bi ḍiimdit ïñï, aŋ teynäni yek wakkä polloŋ jïñe bi bükcï. ");
INSERT INTO jum_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Aŋ waan yaanja ti gin'a nüütï ye, bi ükü woo polloŋ jï yen Minneni Mänbaan, aŋ wäättan ṭoŋ yek ŋommañ wiñe bi nüüjjï. Aŋ iken bi yürcï Minneni Mänbaan äätä curuŋgu gïtï kä teynä ke maaŋŋä yäwconḍe. ");
INSERT INTO jum_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aŋ malaŋŋi yeeke bi tuce kä ïwok gültete, aŋ m'aka waŋŋe ye bi ḍüülünü ti kä ñomuk ke ŋäjäk ke ñaalok ke ïñï ke nänkä muure ïñï polloŋ ŋoy. ");
INSERT INTO jum_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ŋäjje nüüṇṇü gäärrä yen kaapṭä yaanni ti. Naana kimke kattä ïñï aŋ gitke ŋiimmin ye, i ŋäjje ogo yïltüke cokolono. ");
INSERT INTO jum_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aŋ cäänna naana ikee yuṭṭee waak yaakka muure ye, i ŋïje ogo Minneni Mänbaan cokolono ti äntüke tük. ");
INSERT INTO jum_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ikee kiine a gïtken, waak yaakka muure bi näŋï ḍuuggen, i batta mor kil yaanni tüw. ");
INSERT INTO jum_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Polloŋ ke Ŋommañ bi wïïcï ïñï, aŋ jiik yeeki batta bi wïïcï ïñï. ");
INSERT INTO jum_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nïïnnä yaanja ke wuuŋ yaanja baati m'ana ŋäjjä ye, cäänna ke malaŋŋi yek polloŋ jïñe batta ŋäjjä, a Wäy pare ken ŋäjjä. ");
INSERT INTO jum_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Bata wääna wäättee kä nïïnkä Noo ti ye, cäänna bi wäätï äätin Minneni Mänbaan ti. ");
INSERT INTO jum_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Aŋ nïïnkä yaakca ti i mor tääl irä iken ämï aŋ mätï, aŋ iken ḍïjï aŋ ḍeygä me, ke nïïnnä yaana kaaccene kä Noo kuun jï ye. ");
INSERT INTO jum_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Aŋ iken batta ŋäjjä ginkalaŋ ke tääl ääte aŋ iken müüññe muure, aŋ bi wäätï bata äätin yen Minneni Mänbaan ti. ");
INSERT INTO jum_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Aŋ ook kä yew bi ñuugal yiil jï muuṭuk, aŋ keelok bi koowgu me aŋ yaŋkalaŋ bi mañjänä me ïñï. ");
INSERT INTO jum_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aŋ määngä kä yew bi ḍïjï päämḍeynä ti aŋ keelok bi koowgu me aŋ yaŋkalaŋ bi mañjänä me ïñï. ");
INSERT INTO jum_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Aŋ cäyä i ïkï kiijjädä woo kä yaana äätin Pïṭo yüünü kujjeda kä ye. ");
INSERT INTO jum_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aŋ yaakki ookci gïtï naana yoku men mooye yen än ŋäjjä wuuŋ yaana wali ken bi äätete käṭo ye, ike yoku kïïjjïdï woo aŋ än yeene batta bäägge liikä me gïtï. ");
INSERT INTO jum_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ikee dale yokic age tootin wuuggu muure, Minneni Mänbaan bi ätä kä wuuŋ yaana batta ike payde daa kä ye. ");
INSERT INTO jum_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Aŋ a ŋaani ken a ñuugulo yaana a lüggïnï aŋ a ŋäjjo ye, yaana müükkünü men mooye yeene än yeene jïñe muure ye, aŋ meken iñde waak äämkä kä wuuŋ yaana päjjïdï ye ti? ");
INSERT INTO jum_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ŋerrä ñuugulo yaana wäädänä men mooye yeene ñuugal naana ike ḍuku ye. ");
INSERT INTO jum_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ikee kiine a gïtken men mooye ñuugulo yaanna bi müükke wakkä yeeke muure. ");
INSERT INTO jum_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aŋ naana ñuugulo yaana a yaajgonḍe aŋ payit jone ti ogo, ‘Men mooye yeeni bi kuru,’ ");
INSERT INTO jum_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aŋ üccï kä giimmä ñuuguloni meken aŋ ämï aŋ mätï ke maaddo määŋŋi ye, ");
INSERT INTO jum_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","i men mooye yen ñuugulo yaanna bi ätä kä nïïnnä yaana batta ŋäjje ye, ke wuuŋ yaana batta ŋäjje ye. ");
INSERT INTO jum_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aŋ ñuugulo yaanna bi jooje kä jooññu yaajgonḍe, aŋ bi ḍooce ke lääñoni nänṭä ba' ïwok ke ŋeeynä me leken. ");
INSERT INTO jum_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Aŋ Yätkïtïn Polloŋ bi beeljï bata ṭulgu yaaka kä caay kuññu dikoni yeeken ye aŋ atï purjïdï ke or ñääṇṇä ye. ");
INSERT INTO jum_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yaaka kä duuc ye a amgï aŋ yaaka kä duuc ye a ŋäjjoni. ");
INSERT INTO jum_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yaaka kä duuc a amgï yaakka dikoni yeeken koowi aŋ batta a kujin ñownä dikoni. ");
INSERT INTO jum_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Aŋ yaaka kä duuc a ŋäjjoni yaakka kuññu küjbünni yek ñownä ke dikoni yeeken. ");
INSERT INTO jum_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aŋ wääna or ñääṇṇä kuurenee ye iken muure bäŋŋä aŋ oodi. ");
INSERT INTO jum_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Aŋ mïïllä kule gïtï iken cükï yokïn yääw ogo, ‘Yooṭe or ñääṇṇä ïya äätä! Kääje woo aŋ paake.’ ");
INSERT INTO jum_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Aŋ ṭulgu juwin ñaalok muure aŋ dikoni yeeken tooti yokïn. ");
INSERT INTO jum_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aŋ yaaka kä duuc a amgï yaakka jaajjin ŋäjjoni ti ogo, ‘Iñon ñownä yeekic ti kä ḍeewaŋ dikoni yooko ḍaŋŋa tüwok.’ ");
INSERT INTO jum_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Aŋ luugi ŋäjjoni ogo, ‘Uʼu, yaakki ïkïïn batta bi pääjjïnïn müürïnaan, päjjïdï ikee ate yääjoni ti aŋ kije yek ḍuuggic.’ ");
INSERT INTO jum_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Aŋ wääna iken attene kä kijene kä ye, i or ñääṇṇä ḍäägin ti, aŋ yaaka yoken agene kä tootin yaakka, kaaccene kä äräk nänṭä ba' ammani ñäänkä, aŋ äntüke üüljï me. ");
INSERT INTO jum_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aŋ kä ḍeeraŋ aŋŋi ṭulgu meken äätin aŋ jayok ogo, ‘Mügdo, Mügdo, kupkoon äntüke.’ ");
INSERT INTO jum_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Aŋ luugi or ñääṇṇä ogo, ‘Ikee kiine a gïtken, ikee kuje.’ ");
INSERT INTO jum_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aŋ aŋŋi kiijjede woo kä yaana nïïnnä ke wuuŋ yen ḍuukin yeeni kuje daa kä ye. ");
INSERT INTO jum_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Aŋ ŋuca Yätkïtïn Polloŋ jïñe a pääygon kä oon yaana atï taaŋkalaŋ kä utar, aŋ ñuuguloni yeeke bärkene ti aŋ müükkene tiil yeeke wääna atee kä ye. ");
INSERT INTO jum_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aŋ yaŋkalaŋ iññe kücümgü tiil kä duuc aŋ menen iññe kücümgü tiil kä yew, aŋ ḍäke iññe kücam tiil kä keelok aŋ yaŋkalaŋ daa iññe kä lïïldïn yeene. Aŋ wäättan ike attä. ");
INSERT INTO jum_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Aŋ yaana kuññu kücümgü tiil kä duuc ye attä aŋ ñuugulenee kä aŋ ŋuucin ti meken kä duuc ŋuca. ");
INSERT INTO jum_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aŋ yaana kuññu kücümgü tiil kä yew ye, näŋjin bata menen aŋ ŋuucin ti meken kä yew ŋuca. ");
INSERT INTO jum_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aŋ ñuugulo yaana kuññu kücam tiil kä keelok yaanna küññü kääl, aŋ tiil men mooye yeene jïkke ïñï. ");
INSERT INTO jum_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Aŋ wääna nïïnkä ḍiirene ye, i men mooye yen ñuuguloni yaakka ḍuukin, aŋ cääjjin ïñï paŋŋä tiil ti ke iken. ");
INSERT INTO jum_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Aŋ ñuugulo yaana a kujon kücümgü tiil kä duuc ye, äätin aŋ ääcin ti meken kä duuc ŋuca, aŋ jaajjin ogo, ‘Men mooye, ika iññaa kücümgü tiil kä duuc, aŋ yooru, ika ääcänä ti meken kä duuc ŋuca.’ ");
INSERT INTO jum_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Aŋ kiini men mooye yeene ogo, ‘Ŋeraŋ kä yaac! Ïkï ñuugulo ŋerconḍe yaana a lüggïnï ye, ïkï agä lüggïnï kä tïïññä gin ḍeerconḍe, ïkï bi ḍooceni ḍiirken gïtï, äätä kaacci jon ñamme gïtï yen men mooye yüünü ti.’ ");
INSERT INTO jum_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Aŋ ike yaana a kujon kücümgü tiil kä yew ye, cäänna äätin aŋ jaajjin ogo, ‘Men mooye ika iññaa kücümgü tiil kä yew aŋ ika ääcänä ti meken kä yew ŋuca.’ ");
INSERT INTO jum_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Aŋ kiini men mooye ogo, ‘Ŋeraŋ kä yaac! Ïkï ñuugulo ŋerconḍe yaana a lüggïnï ye, ïkï agä lüggïnï kä tïïññä gin ḍeerconḍe, ïkï bi ḍooceni ḍiirken gïtï, äätä kaacci jon ñamme gïtï yen men mooye yüünü ti.’ ");
INSERT INTO jum_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Aŋ yaana a kujon kücam tiil kä keelok ye äätin cäänna aŋ jaajjin ogo, “Men mooye yeeni, ïkï ŋäjjeni ñuugula yüünü caraŋ, ïkï iṭä nänṭ'a batta agii kä pïïton kä ye. Aŋ ïkï ḍüṭü nänṭ'a batta agii kä mäpon kä käwkä ye. ");
INSERT INTO jum_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Aŋ ika booññu aŋ ika attä aŋ tiil yüükü jïkkä ïñï. Tiil yüükü ikki.’ ");
INSERT INTO jum_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Aŋ luugi men mooye ogo, ‘Ïkï ñuugulo yaajgonḍe yaana a wuuñgon ye! Naana yoku ŋäjjä ika iṭä nänṭ'a batta agä pïïton kä, aŋ ika ḍüṭü nänṭ'a batta agä mäpon kä käwkä ye, ");
INSERT INTO jum_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","tiil yeeki batta äccädä kun tiil jï ina? Yoku ika käññä ginkalaŋ witken ti kä ḍeewaŋ.’ ");
INSERT INTO jum_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Aŋ men mooye iinjin ogo, ‘Kücam tiil koowe ñuugulo yaanna ti, aŋ iñe m'ana cäyge kücümgü tiil kä caay yaanna. ");
INSERT INTO jum_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aŋ m'ana cäyge ye bi iñgä me ḍiirken, aŋ bi cäyge kä ḍiräk, aŋ m'ana batta cäyge ye, yaaka bilti ike ti kä ḍeewaŋ ye, bi koojjunu me woo ike ti. ");
INSERT INTO jum_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aŋ ñuugulo yaana a waanjï yaanni yeepe woo mïïllä gïtï nänṭä ba' ïwok ke ŋeeynä me leken. ");
INSERT INTO jum_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Aŋ naana Minneni Mänbaan ätä kä maaŋŋä yeene, ke malaŋŋi yeeke muure ye, ike bi cääjjï nook yeene yen maaŋŋä wic. ");
INSERT INTO jum_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Aŋ ṭoŋ muure yoken bi ḍüülünü ti ñome ti, aŋ ike me bi kebe gïtï bata yaana kaaydo käbälgä kibbedeeda woo jüüloni gïtï ye. ");
INSERT INTO jum_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Aŋ ike käbälgä bi ḍooce buŋ birrä aŋ jüüloni bi ḍooce kä buŋ aam. ");
INSERT INTO jum_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Aŋ wäättan Yätkä m'aka cäyok buŋ birrä ti ye bi kiine ogo, ‘Ääte, ikee yaaka age ŋüülkïnï kä Wäyo ye, kaace ti Yätkïtïn ti yaana tutkene kä me wääna ïïjjïn ti naŋŋä ŋommañ ye ti. ");
INSERT INTO jum_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ika nägana käñ aŋ ika äämgana. Aŋ ika nägana yeen aŋ ika määtkana piik. Aŋ ika agä boorgon aŋ ika gïmgana äärgic ti. ");
INSERT INTO jum_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aŋ ika yori elaŋ, aŋ ika iiŋkana. Aŋ ika yore caraŋ, aŋ ika waañña. Aŋ ika cäyä gaŋgar, aŋ ika ookka.’ ");
INSERT INTO jum_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Aŋ bi luuku mä wotku ogo, ‘Pïṭo, a tooku ken yoorini näki käñ, aŋ ïkï äämgini, aŋ näki yeen, aŋ ïkï määtkini piik? ");
INSERT INTO jum_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aŋ a tooku ken yoorini agii boorgon, aŋ gïmgïnï äärgo ti, aŋ yorü elaŋ, aŋ iiŋkini kä? ");
INSERT INTO jum_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aŋ a tooku ken agii kä raac aŋ cääyii gaŋgar aŋ ïkï ookini kä?’ ");
INSERT INTO jum_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Aŋ bi luuku Yätkä ogo, “Ikee kiine a gïtken bata yaana näŋgene mädgi lïcken ke käwgi lïcken ye, i näŋgana kä ika.’ ");
INSERT INTO jum_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Aŋ ike bi jaajjï m'aka buŋ aam ti ye ogo, ‘Aŋge yokic ika ti ikee mä tuumgin, kaace maañ yaana ke cüle a tütkïnï booŋïn ke meŋkeekeni yeeke ye ti. ");
INSERT INTO jum_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ika nägana käñ aŋ ika batta aga kä äämgïnï. Aŋ ika nägana yeen aŋ ika batta aga kä määtkïnï piik. ");
INSERT INTO jum_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ika agä boorgon aŋ ika batta aga kä gïmgïnï äärgic ti. Aŋ yori elaŋ aŋ ika batta aga kä ïïŋkïnï. Aŋ ika agä raac aŋ ika cääyä gaŋgar aŋ ika batta aga kä ookon.’ ");
INSERT INTO jum_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Aŋ iken cäänna bi lüükcï jaajjï ogo, ‘Pïṭo, a tooku ken yoorini näki käñ ke yeen, aŋ agii boorgon aŋ yorü elaŋ aŋ agii raac aŋ cääyii gaŋgar aŋ ïkï batta agini kä yüükkïnï ti?’ ");
INSERT INTO jum_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Aŋ ike bi lüükcï ogo, ‘Ikee kiine a gïtken, naana ikee yaakke kä yüükkïn ti mädgi lïcken ke käwgi lïcken kä ḍeeraŋ ye, i ikee yaakke kä yüükkïn ti ika.’ ");
INSERT INTO jum_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Aŋ mä yaackä bi atï kaacï jooññu gïtï ke cüle, aŋ mä wotku bi kaacï ti üṇṇü gïtï ke cüle.” ");
INSERT INTO jum_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Aŋ wääna Yeecüwa ḍaŋŋee kä jiik yaakka muure ye, i baaddoni yeeke kiinne ogo, ");
INSERT INTO jum_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ŋäjje Poñ Kaaldin Wic äätïdï nïïnkä yew ti ñomuk, aŋ Minneni Mänbaan bi müükkünü me mäbaan aŋ ṭeljänä me ti ñaalok kaakkon jok.” ");
INSERT INTO jum_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aŋ ḍuuŋku däŋkä ke yätïnï yek Yühüüṇṇï yoken ḍülï nänṭä ba' ḍuuŋgon daaŋ küülconḍe yen Jooŋ yaana battä me ogo Kayaapa ye ti. ");
INSERT INTO jum_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Aŋ läälin pugin ogo Yeecüwa mügjï ko ätkïtïn aŋ nägjï ḍok. ");
INSERT INTO jum_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aŋ iken jaajjin ogo, “Ŋana waan Poñ Kaaldin Wic ti, nuŋko me lelit.” ");
INSERT INTO jum_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Aŋ wääna Yeecüwa cäyee kä Betani paa ba' Camaan yaana a näkon kä jaan ñomuk ina ye, ");
INSERT INTO jum_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","i iiŋ yaŋkalaŋ kääjin äräk ike ti ädit kuulkul pïtïna yaana kiygä me kä carrä ye, aŋ pookke Yeecüwa wiñe ti i ike cääy därŋañ ti ämï. ");
INSERT INTO jum_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aŋ wääna yoorene daa baaddoni ye, iken piiṇdin aŋ jayok ogo, “Yaakki ñiyene me ina! ");
INSERT INTO jum_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Päjjïdï yoku yääjji me woo kä caraŋ tiil yoku iñi me aangï.” ");
INSERT INTO jum_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Aŋ jiik yaakka ŋäjji Yeecüwa aŋ luukke ogo, “Ikee iiŋ rüüde yok ina? Ike näŋŋä nääŋkä ŋerken ika ti. ");
INSERT INTO jum_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ikee bi cäygene kä aangï ke ikee kamat aŋ ikee batta bi cäygene kä ika kamat. ");
INSERT INTO jum_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ike pïtïna yaakki pookke yori ti naŋŋe tutee kä jïŋŋä yeeni. ");
INSERT INTO jum_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ikee kiine a gïtken, nänṭä yaana päkene me Jiik Ŋerkä yen Jooŋ ŋommañ wic muure ye, nääŋka naŋi iiŋ yaanni ye, cäänna daa bi jaaygä me aŋ payte daa me.” ");
INSERT INTO jum_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aŋ baaddoni yaaka caay witken kä yewwe ye yaana battä me ogo Yahüüja Garyüütï ye attä ḍuuŋku däŋkä ti, ");
INSERT INTO jum_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aŋ tääccin ogo, “Ika bi iña ŋaaka naana müükkene kä ye?” Aŋ ike iñi tiilgä gälkä waŋgen caykä kä ḍäk. ");
INSERT INTO jum_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aŋ kä waan yaanja ti ike määjjin waan ääkkedeeda ŋäc. ");
INSERT INTO jum_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aŋ äŋ wiñe yen Poñ Bïggï Cotku ti baaddoni äätin Yeecüwa ti aŋ taaji ogo, “Ïkï ṭäkä tutkini nänṭä, yaana ämii kä amma Poñ Kaaldin Wic ye wa?” ");
INSERT INTO jum_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aŋ ike luukcin ogo, “Ate oon kalaŋ ti baan jï aŋ kiine ogo Nüüto jääyïdï ogo, ‘Wuuŋ yeeni waŋe cokilin, ika atä ämä amma Poñ Kaaldin Wic baannü, ke baaddoni yeeki.’ ” ");
INSERT INTO jum_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Aŋ baaddoni jiik yaaka kiinene daa Yeecüwa ye naŋi, aŋ tuttu amma yen Poñ Kaaldin Wic. ");
INSERT INTO jum_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aŋ biigin ti aŋŋi, Yeecüwa cääjjin ïñï amma ti ke baaddoni yeeke yaaka kä caay witken kä yew ika. ");
INSERT INTO jum_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aŋ wääna ämene kä ye, Yeecüwa jaajjin ogo, “Ikee nüütke a gïtken, mäŋkalaŋ ikee ti ika bi ääkka ŋäc.” ");
INSERT INTO jum_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Aŋ baaddoni anjin ïñï kä yaac, aŋ wäättana Yeecüwa tactä, kä kiṭuk kiṭuk ogo, “Pïṭo, bi a ika?” ");
INSERT INTO jum_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aŋ luukke ogo, “M'ana ïnko bi yïrjï gälŋä jï ye, i a m'ana bi ika ääkka ŋäc ye. ");
INSERT INTO jum_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aŋ Minneni Mänbaan bi tüw bata yaana jaaynene Meeŋka Jiik Jooŋ ye, aŋ m'ana bi Minneni Mänbaan ääkke ŋäc ye, bi yaajaŋ ke ike! Iiñca ŋeraŋ ŋana yoku ike giidi me.” ");
INSERT INTO jum_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aŋ taaji Yahüüja, yaana ike bi ääkkänä ŋäc ye ogo, “Nüüto, aŋ bi a ika?” Aŋ luuki Yeecüwa ogo, “Ïkï jaajjini.” ");
INSERT INTO jum_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aŋ wääna iken ämmene kä ye, Yeecüwa kuññu biŋŋan coṇṇu aŋ ŋüülkene, aŋ wiṇṇe gïtï aŋ iññe baaddoni, aŋ kiinne ogo, “Koowe ame a yori inni.” ");
INSERT INTO jum_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aŋ ḍon koowne aŋ mälcin ñaalok aŋ iññeeda kä aŋ jaajjin ogo, “Mätce ikee muurijaan. ");
INSERT INTO jum_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","A yïmgä yeeki ikki, a yek jiik ḍoocin yek Jooŋ kïccäŋgenen yaaka puuktin ogo kulkin nääŋkä yaackä yek me ḍiirken ye. ");
INSERT INTO jum_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ikee kiine, Ika batta bi mätcä piik jaan yaana ṭulge belok bata lüütkon ye ŋuca, aŋŋa nïïnnä kïcconḍe yaana bi mätcä kä ke ikee Yätkïtïn Wäyo ti ye.” ");
INSERT INTO jum_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aŋ iken ooljin uullu aŋ kaaccä woo üŋjïn pääm yaana wiñe a jengä jeytüünni ye ti. ");
INSERT INTO jum_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aŋ iken kiini Yeecüwa ogo, “Ikee muurijaan bi buurce woo ika ti wïïrïn tiññaŋ. A pergon Meeŋka Jiik Jooŋ jï ogo, ‘Kaaydo bi pacä aŋ käbälgä yek kaal jïñe bi gääctit gïtï.’ ");
INSERT INTO jum_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aŋ naana ika juwunu ñaalok tüwnü ti ye, ikee bi yüte ti Jalïïl.” ");
INSERT INTO jum_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Aŋ Bütürüc luukcin ike ti ogo, “Naana me muure ïkï daljini ïñï ye, ïkï batta bi daljeni ïñï.” ");
INSERT INTO jum_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Aŋ luugi Yeecüwa ogo, “Ïkï kiineni a gïtken wïïrïn tiññaŋ i mor toon batta weekcï ika bi reecca woo ääŋkü kä ḍäk ogo Ika kujjada.” ");
INSERT INTO jum_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Aŋ kiini Bütürüc ogo, “Naana cäänna ika tüwü ke ïkï ye, ïkï batta bi reeceni woo!” Aŋ baaddoni muure jaajjin jiik keelkä yaakka. ");
INSERT INTO jum_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Aŋ Yeecüwa attä ke iken nänṭä yaana battä me ogo Jecïmaani ye, aŋ baaddoni yeeke kiinne ogo, “Cäye winni, ika atä wïca mäṭä.” ");
INSERT INTO jum_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aŋ kuññu Bütürüc ke merkä Jabadï kä yewwe, Yaagüüp ke Yuhanna, aŋ ike uccin kä nüüjdüŋ aŋ jone yaaññä. ");
INSERT INTO jum_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aŋ kiinne ogo, “Joni nüüjï kä yaac aŋ a yaana ika tüwü ye. Wääde winni aŋ yäwe ke ika.” ");
INSERT INTO jum_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aŋ wükcïn woo kä ḍeeraŋ aŋ ḍüŋjïn ïñï aŋ mälcin, aŋ jaajjin ogo, “Wäyo naana päjjïdï ye ŋana ika naŋdaa wääcä waaññä yaana äätïdï yaanni. Aŋ ŋana ïkï nääŋä kä ṭäktäŋ yeeni, ṭääkcä näŋjä kä ṭäktäŋ yüünü ïkï.” ");
INSERT INTO jum_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aŋ ike ḍukcin baaddoni yeeke ti, aŋ wäädene a ootin. Aŋ Bütürüc kiinne ogo, “Ikee batta cäänna lïïṭe yäwe ke Ika wuuŋ kä keelok? ");
INSERT INTO jum_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yäwe aŋ mäṭe nuŋko ŋana ḍimjede puuccin gïtï. Wääktäŋ ṭäkï aŋ gaan ken bämaŋ. ");
INSERT INTO jum_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aŋ iken dalji ïñï Yeecüwa kaaccä woo ŋuca aŋ mäṭṭä ogo, “Wäyo naana waaññä yaanni batta a aŋgïnï yok ye, i daa waajä aŋ dalä ṭäktäŋ yüünü näŋï ḍoŋe. ");
INSERT INTO jum_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aŋ wääna ḍuukenee kä iken ti ŋuca ye, i kaññe a ootin waŋgin a pekin ïñï kä nïïnkä. ");
INSERT INTO jum_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aŋ daljene ïñï ŋuca aŋ attä aŋ mäṭṭä ääŋke kä ḍäk aŋ jaay jiik keelkä. ");
INSERT INTO jum_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Aŋ ike äätin baaddoni yeeke ti aŋ kiinne ogo, “Cumje ootene aŋ yïïke. Aŋ yoore wuuŋ ḍäägin aŋ Minneni Mänbaan müükkï me mä yaackä ïnken ti. ");
INSERT INTO jum_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Juwe aŋ atïn! Yoore, aagdo ŋäc yeeni inni!” ");
INSERT INTO jum_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Aŋ wääna Yeecüwa iiñjedee kä jaayee ye, Yahüüja yaana a baaddo ke meken yaaka kä caay witken kä yew ina äätin ke ṭoŋ ḍiirken kä gaaḍalli ke läcäŋgä tuuji kä ḍuuŋku däŋkä ke yätïnï yek me. ");
INSERT INTO jum_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aŋ iken a iñgin kä aagdo ŋäc Yahüüja gin'a nüütï ye, ogo, “M'ana bi ŋïïbä ye, ken a ike, i müge.” ");
INSERT INTO jum_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aŋ kä ḍeeraŋ aŋŋi ike äätin Yeecüwa ti aŋ jaajjin ogo, “Ogook, Nüüto?” Aŋ ŋïïmme kä jone. ");
INSERT INTO jum_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aŋ kiini Yeecüwa ogo, “Muukonḍi näŋä gin'a umgini ṭäkkä naŋdä ye.” Aŋ iken äätin aŋ Yeecüwa mügï. ");
INSERT INTO jum_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aŋ baaddo yen Yeecüwa yaŋkalaŋ gaaḍal yeene wuudene woo, aŋ kiingon yen ḍuuŋgon daaŋ küülconḍe tocce gitkin woo. ");
INSERT INTO jum_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aŋ kiini Yeecüwa ogo, “Gaaḍal yüünü ḍuukci ätte jï. M'aka ñuugal kä gaaḍal ye bi tüwok kä gaaḍal. ");
INSERT INTO jum_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ïkï batta ŋäjjä ogo ika lïïlco ñujjoo Wäyo ti, aŋ ike tucu malaŋŋi yeeke kä bïraŋ aŋ ika tïïca. ");
INSERT INTO jum_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aŋ yaakki bääkkan daa bi näŋï ḍuuggen ḍääkit yaaka jaayi Meeŋka jiik Jooŋ ye.” ");
INSERT INTO jum_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aŋ Yeecüwa ṭoŋ kiinne ogo, “Ika agä mäddok yaajgonḍe ina ääte kä gaaḍalli ke läcäŋgä ogo mügjada ko yaanna? Nïïnkä muure Ika cääynä kaal yen änlaṇṇä yen Jooŋ jï aŋ Ika batta mügda ina? ");
INSERT INTO jum_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aŋ yaakki muure näŋŋä ḍuuggen ḍääkit yaaka peri bäṭoni Meeŋka Jiik Jooŋ jï ye.” Aŋ baaddoni muure ike dalji ïñï aŋ buurcin woo. ");
INSERT INTO jum_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aŋ m'aka müügïn Yeecüwa ye ike iji Kayaapa ti yaana a ḍuuŋgon daaŋ küülconḍe ye ti, nänṭ'a ḍülte kä nüütoni jiik ḍoocin yek Jooŋ ke yätïnï yoken ye. ");
INSERT INTO jum_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","I baattä Bütürüc kä utar aŋŋa nänṭä ba' ḍuuŋgon daaŋ küülconḍe aŋ ike kaaccä ti aŋ cääjjin ïñï ke tïïconi, däämï düüñïn nääŋkä. ");
INSERT INTO jum_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aŋ ḍuuŋku däŋkä ke gütoni muure Yeecüwa määckätä ḍok m'aka jaajjï kä yelkïtïn ike ti, nuŋko näke daa kä ḍok ye. ");
INSERT INTO jum_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Aŋ me ḍiirken äätin jayok kä yelkïtïn ike ti. Aŋ gütoni batta a käñin jiik'a päjjïdï näke daa kä ḍok ye. Aŋ wäättan me kä yewwe äätin ");
INSERT INTO jum_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","aŋ jaajjin ogo, “Oon yaanni jaay ogo, ‘Ika lïïṭä änlaṇṇä yen Jooŋ ḍüümü gïtï aŋ ŋocu koru nïïnkä kä ḍäk.’” ");
INSERT INTO jum_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aŋ ḍuuŋgon daaŋ küülconḍe yuuttu ñaalok aŋ jaajjin Yeecüwa ti ogo, “Ïkï batta cäygini kä luukcin yaana jaajjidii kä cïŋŋä yaana üüŋïdï ïkï ti yaanna?” ");
INSERT INTO jum_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aŋ Yeecüwa daa a tïïŋjïnï ïñï. Aŋ kiini ḍuuŋgon daaŋ küülconḍe ŋuca ogo, “Kä yäṇtäŋ Jooŋ yaana a üdon ye, ïkï ḍooceni lïïttäŋ gïtï, nüütkoon naana ïkï agä Macii Minneni yen Jooŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aŋ kiini Yeecüwa ogo, “Ïkï jaajjini. Aŋ ikee kiine, kä waan yaanni ti ke ñomuk Minneni Mänbaan bi yoore cääy nänṭä teynä buŋ birrä yen Jooŋ ti, aŋ bi ätä kä curuŋgu yek Polloŋ.” ");
INSERT INTO jum_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aŋ ḍuuŋgon daaŋ küülconḍe burŋu yeene jeññe gïtï kä piinkä aŋ jaajjin ogo, ‘Oon yaanni jaay ina aŋŋi ḍüücï ogo iken iiro ke Jooŋ! Ïkïïn ṭäkïn mä yuṭin ina ŋuca? Aŋ tiiŋŋe kiirkä yeeke muure. ");
INSERT INTO jum_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Aŋ ikee payde ogo ŋaaka?” Aŋ iken luukcin ogo, “Ike päjjïdï tüw.” ");
INSERT INTO jum_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aŋ ŋüülgü ñomgin kä ñaangä aŋ giibi kä ïnken aŋ yakkalaŋŋi ike määbi täŋkin, i agene kümgon waŋgin.’ ");
INSERT INTO jum_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Aŋ kiiṇtä ogo, “Macii, nüütkoon naana ïkï agä bäṭo ye, ïkï jebini kä ŋaani?” ");
INSERT INTO jum_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aŋ Bütürüc cääy woo üṇtük. Aŋ ṭuulle yaana ñuugal ye äätin aŋ ike kiini ogo, “Ïkï cäänna ke Yeecüwa yen mä Jalïïl.” ");
INSERT INTO jum_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aŋ Bütürüc riccin woo me ñomgen ti muure. Aŋ jaajjin ogo, “Batta ŋäjjä ïkï jaayä ogo ŋaaka.” ");
INSERT INTO jum_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aŋ wääna ike attee kä äntüke yen kaal ti kä cokal ye, yooṭi ṭuulle yaana ñuugal ye yaŋkalaŋ ŋuca, aŋ m'aka yudok gunne ti ye kiinne ogo, “Oon yaanni ke Yeecüwa yen mä Naacira.” ");
INSERT INTO jum_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aŋ ŋuca ike riccin woo kä lïïttäŋ aŋ jaajjin ogo, “Oon yaanna kuju.” ");
INSERT INTO jum_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aŋ kä ḍeeraŋ aŋŋi m'aka yudok wïca ye äätin Bütürüc ti aŋ kiine ogo, “Ïkï bääkkan daa ke iken, jiik yüükü muure nüütï ïkï agä män Jalïïl.” ");
INSERT INTO jum_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aŋ ike jujjin kä tuummu ḍoŋe aŋ lïïtkede ogo, “Oon yaanna kuju.” Aŋ kä ḍeeraŋ aŋŋi toon weekcin. ");
INSERT INTO jum_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aŋ Bütürüc päjjin jiik'a jaayi Yeecüwa ye ogo, “I toon batta mor weekcï ïkï ika bi reecca woo ääŋkü kä ḍäk.” Aŋ Bütürüc kaaccä woo aŋ weeŋŋä kä yaac. ");
INSERT INTO jum_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Aŋ wääna tïṇṇäwic aŋŋi ye, ḍuuŋku däŋkä ke yätïnï yek Yühüüṇṇï näŋŋä waŋ teyne ogo nääkïï ko Yeecüwa. ");
INSERT INTO jum_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aŋ ḍiigi aŋ iji müükkï mügdo Biilaatuc yen mä Ruumaan. ");
INSERT INTO jum_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Aŋ wääna Yahüüja yaana ike ääkki ŋäc ina ŋïccee Yeecüwa jooce daa me ke tüwnü ti ye, ike jone lüüjjïn aŋ tiilgä gälkä yaaka caykä kä ḍäk yaakka ḍuukkene ḍuuŋku däŋkä ke yätïnï. ");
INSERT INTO jum_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Aŋ jaajjin ogo, “Ika näŋŋä nääŋkä yaackä kä ääkkin ŋäc m'ana ḍoŋe ladaŋ ye.” Aŋ iken jaajjin ogo, “Ikoon piilgon ŋaaka? Yaanna a ïkï ti.” ");
INSERT INTO jum_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aŋ Yahüüja tiilgä gälkä yibjene ïñï kaal yen änlaṇṇä yen Jooŋ jï, aŋ kaaccä woo aŋ ḍoŋe maaññe. ");
INSERT INTO jum_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aŋ ḍuuŋku däŋkä yakkalaŋ tiil koowi aŋ jaajjin ogo, “Batta päjjïdï ḍoocïn tuññu änlaṇṇä jï i a tiil yek yïmgä aŋŋi. ");
INSERT INTO jum_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aŋ iken ḍuccin jiik aŋ tiil kiññene yiil äjo ogo wääto ogo, nänṭä jïŋŋä boorgu. ");
INSERT INTO jum_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Aŋ ken ina ke tiññaŋ yiil yaanna batte daa me ogo, Yiil Yïmgä yaanna. ");
INSERT INTO jum_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yaakki ḍääkit barrä yen bäṭo Ïrmïya ogo, “Iken kuññu tiilgä gälkä caykä kä ḍäk, a äccin yaana ḍooccete daa kä mä Icärayiil ye. ");
INSERT INTO jum_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aŋ kiññene yiil äjo, bata yaana iingana kä Pïṭo ye.” ");
INSERT INTO jum_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aŋ Yeecüwa yuuttu mügdo Biilaatuc yen mä Ruumaan ñome ti, aŋ taaji mügdo ogo, “Ïkï agä yätkä yen Yühüüṇṇï?” Aŋ luugi Yeecüwa ogo, “Ïkï jaajjini.” ");
INSERT INTO jum_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aŋ wääna käkkene daa wic ḍuuŋku däŋkä ke yätïnï yek Yühüüṇṇï ye, i ike batta a lüükcïnï. ");
INSERT INTO jum_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Aŋ taaji Biilaatuc ogo, “Ïkï batta tiŋdä käkkinni witkin yaaka üüŋütü me ïkï ti yaakka?” ");
INSERT INTO jum_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aŋ batta agee kä luukon kä jiikkalaŋ, aŋ mügdo wiñe ḍiiktin. ");
INSERT INTO jum_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aŋ yuungu muure ti Poñ Kaaldin Wic ti, mügdo yen mä Ruumaan äkkïdï men kä keelok yaana cääy gaŋgar jï aŋ wakä ṭoŋ ye. ");
INSERT INTO jum_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aŋ waan yaanja ti iken cääygene mäŋkalaŋ gaŋgar jï ŋäjjänä battä me ogo Barabaac. ");
INSERT INTO jum_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aŋ wääna mäbaan yoken ḍülene daa kä ye, i iken taaji Biilaatuc ogo, “A ŋaani ken ṭäkke äkke kä, Barabaac halla Yeecüwa yaana battä me ogo Macii ye?” ");
INSERT INTO jum_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Aŋ ŋäjje iken Yeecüwa müükkene daa kä puutin. ");
INSERT INTO jum_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aŋ wääna Biilaatuc cäyee kä nook yen jooññu wic ti ye, tucki iiŋe jiik aŋ kiinne ogo, “M'ana ḍoŋe ladaŋ yaanna daläbu. Ika wääccä lääggï kä yaac wïïrïn tiññaŋ kä ike.” ");
INSERT INTO jum_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aŋ ḍuuŋku däŋkä ke yätïnï ṭoŋ ïïrï ogo ñujjo Barabaac ken äkkee aŋ Yeecüwa ken nägjï ḍok. ");
INSERT INTO jum_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aŋ Biilaatuc ṭoŋ taaññe ogo, “Yaaka kä yewwe yaakki ti wali yaana äkke kä ye?” Aŋ ṭoŋ luukcin ogo, “Barabaac!” ");
INSERT INTO jum_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aŋ tääcki ti Biilaatuc ogo, “Aŋ Yeecüwa yaana battä me ogo Macii ye ken naŋä ogoo?” Aŋ ṭoŋ muure luukcin ogo, “Näge ḍok kä ṭellä kaakkon jok!” ");
INSERT INTO jum_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aŋ tääcki ti Biilaatuc ogo, “Ina, a yiñ yaana wali ye ken naŋŋe?” Aŋ iken üüttïn kä yääw ṭeṭaŋ ogo, “Näge ḍok kä ṭellä kaakkon jok!” ");
INSERT INTO jum_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aŋ wääna yoorene daa Biilaatuc ike batta käñdee kä waan, aŋ a büültïn ken tälit ye, i ike kuññu piik aŋ ïnke lookke woo me ñomgen ti, aŋ jaajjin ogo, “Ika ḍoŋi ladaŋ kä yïmgä oon yaanna. Yaanna a nääŋkä yeekic!” ");
INSERT INTO jum_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aŋ me muure luukcin ogo, “Dalä yïmgä yeeke a ikoon ti ke merkä yooko ti!” ");
INSERT INTO jum_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aŋ Barabaac äkkeneeda. Aŋ iinjin ogo Yeecüwa ḍooyjï me, aŋ müükkene kääygä mä Ruumaan ogo ṭeljïï ti kaakkon jok. ");
INSERT INTO jum_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aŋ kääygä yek mügdo Biilaatuc Yeecüwa koowi, aŋ iji wiñ yeenen ti, aŋ kun yen kääygä ḍüülï ti muure ike ti. ");
INSERT INTO jum_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aŋ burŋu yeene güüdï woo, aŋ iiŋki burŋu beel bata yen yätkä. ");
INSERT INTO jum_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Aŋ ṭurki tarbüc eemdin yen küügü aŋ iiŋkene daa wiñe ti, aŋ ḍucki lacan ïṇte birrä ti aŋ ḍüŋjïn ïñï ñome ti aŋ ñiyene yok aŋ kiiṇtä ogo, “Ogook? Yätkä yen Yühüüṇṇï!” ");
INSERT INTO jum_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aŋ ŋüülkï yokïn ñaangä, aŋ lacan koowi aŋ jebene daa kä wiñe ti. ");
INSERT INTO jum_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aŋ wääna ñiynene kä yok ye, i güüdï yokïn woo aŋ iiŋki buruŋgu yeeke aŋ koowi iji woo ṭelcätä ti kaakkon jok. ");
INSERT INTO jum_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Aŋ wääna kaaccene kä woo ye, i iken purjin ke oon yaŋkalaŋ yen mä Giiräwaan, battä me ogo Camaan, aŋ ïïrï kääygä ogo kaakkon Yeecüwa koowje äddee. ");
INSERT INTO jum_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aŋ iken ḍakkä ti nänṭä yaana battä me ogo Kulukuuta ye, aŋ aŋan ogo nänṭä yen äwnä men wiñe. ");
INSERT INTO jum_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aŋ ike iñi määk a ñukin kä kalkale aŋ wääna näkkeneeda kä ye, ike yaakkä kä maaṇṇä. ");
INSERT INTO jum_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aŋ wääna ike ṭeljene daa ti kaakkon jok ye, iken buruŋgu yeeke ŋüülï gïtï aŋ naŋi kä jaan. ");
INSERT INTO jum_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aŋ iken cääjjin ïñï aŋ ike tïïcä. ");
INSERT INTO jum_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aŋ wiñe ti iken ḍuccin jiik pergin yek cïŋŋä yaana üŋjïdï ike ti ye jayok ogo, “A Yeecüwa inni, Yätkä yen Yühüüṇṇï.” ");
INSERT INTO jum_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aŋ ñagatṇi yakkalaŋ kä yewwe ṭeli me ke ike, keelok kä buŋ birrä ti aŋ yaŋkalaŋ kä buŋ aam ti. ");
INSERT INTO jum_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aŋ m'aka kaajit ye yawok kiirä witken bergä kä ñääy, ");
INSERT INTO jum_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","aŋ jayok ogo, “Ïkï yaana jaayä ogo änlaṇṇä yen Jooŋ ḍüümjey gïtï, aŋ ŋuca korjey nïïnkä ko ḍäk ye! Ḍoŋü mäkkä! Kääjä ïñï kaakkon jok naana ïkï agä Minneni Jooŋ a gïtken ye.” ");
INSERT INTO jum_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aŋ cäänna ḍuuŋku däŋkä ke nüütoni jiik ḍoocin yek Jooŋ ke yätïnï ike ñiyge yok kiiṇtä ogo, ");
INSERT INTO jum_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ike mäkkalaŋ maŋŋe, aŋ ḍoŋe batta lïïlde kä mäkkin! Naana ike a yätkä yen mä Icärayiil ye, dale käjä ïñï kaakkon jok tiññaaŋŋi, aŋ ikoon bi luggon kä ike. ");
INSERT INTO jum_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ike lüggïdï kä Jooŋ aŋ dale Jooŋ ike mäkkänä tiññaaŋŋi naana ike ṭäkkänä ye, kä yaana jaayee kä ogo ike agje Minneni Jooŋ ye.” ");
INSERT INTO jum_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aŋ cäänna ñagatṇi yaaka a ṭeljïnï ti ke ike kaakkonni jugin ye, ike kirgä cäänna kä jiik keelkä. ");
INSERT INTO jum_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aŋ wääna äŋ yuuttee ṭeejjük ye i mïïllä ŋommañ äätte wic muure ke näŋe wuuggu kä ḍäk. ");
INSERT INTO jum_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Aŋ wääna wuuŋ ḍäk ti ye, Yeecüwa yaajjin kä yääw mooye aŋ jaajjin ogo, “Ïlï, Ïlï, lama cabaktaani?” Aŋ aŋan ogo, “Jooŋ yeeni, Jooŋ yeeni, ika daldaabu ina?” ");
INSERT INTO jum_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aŋ wääna mäkkalaŋ yuddene kä wïca aŋ tiiŋŋene kä aŋan ye, i iken jaajjin ogo, “Ike bäärä bäṭo Ïlïya.” ");
INSERT INTO jum_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yaŋkalaŋ iken ti lüüṇṇü aŋ uṇtal küümgene kä määk peñkä aŋ ḍoocce lacan ti aŋ läjgeneeda ogo maadje. ");
INSERT INTO jum_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aŋ meken jaajjin ogo, “Dalä bu pare tïka, yoorïn naana Ïlïya bi ätä ike mäkkänä ye.” ");
INSERT INTO jum_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aŋ Yeecüwa yaajjin ŋuca kä yääw mooye aŋ wääktäŋ yeene ḍoocce. ");
INSERT INTO jum_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aŋ kä ḍeeraŋ aŋŋi burŋu yaana a daaŋjïnï änlaṇṇä ti ye, jeññä gïtï ääŋke kä yewwe bäätin ïñï kä ñaaloŋŋu ke ïñï, aŋ ŋommañ bukcin aŋ ḍaraŋŋi bääktin. ");
INSERT INTO jum_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aŋ kälkä witken kupkin, aŋ me ḍiirken yek Jooŋ yaaka a tüwïn ye, juwin ñaalok. ");
INSERT INTO jum_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aŋ iken kääjin woo kälkä gïtï, i ḍaŋŋa Yeecüwa a jüwïnï, aŋ iken attä baan mooye laṇṇä jï Oorcalïïm aŋ yoken nüütkï woo me ḍiirken. ");
INSERT INTO jum_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aŋ wääna ḍuuŋgon kääygä yen mä Ruumaan ke kääygä yaaka ke ike däämene Yeecüwa aŋ yuṭṭene bukcin ŋommañ ke waak'a näŋŋä ḍuuggen ye, iken bojgin kä yaac aŋ jaajjin ogo, “A gïtken ike a Minneni yen Jooŋ!” ");
INSERT INTO jum_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aŋ wïca määngä ḍiirken yakkalaŋ däämmïdï kä utar, a yaaka Yeecüwa bäädänä kä Jalïïl aŋ ñuugulunu ye. ");
INSERT INTO jum_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Aŋ Märïyam yaana battä me ogo Majdalïïna bilti ke iken ke Märïyam yaana a Yaagüüp ke Yuucip meen ina ke merkälen Jabadï meen. ");
INSERT INTO jum_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aŋ wääna biigin ti ḍäägenee ye, oon yaŋkalaŋ a ceeggon äätin ätä Raama battä me ogo Yuucip, aŋ ike cäänna a baaddo yen Yeecüwa. ");
INSERT INTO jum_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aŋ ike attä Biilaatuc ti, aŋ ñujjin ogo Yeecüwa gaane, aŋ Biilaatuc iinjin ogo ïñjïda ko me. ");
INSERT INTO jum_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aŋ gaane koowi Yuucip, aŋ paarre yok kä burŋu kïcconḍe yen jïŋŋä me. ");
INSERT INTO jum_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Aŋ maaṭṭe kääl yeene kïcconḍe jï, yaana agee kä küüñgon pääm ti bata ṭuumpoŋe ye. Aŋ pääm ḍüljene ti kääl tük aŋ attä. ");
INSERT INTO jum_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aŋ Märïyam yaana battä me ogo Majdalïïna ke Märïyam yaŋkalaŋ bilti wïca cäyok ñomgen agene ṭukin ti kääl wic. ");
INSERT INTO jum_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Aŋ nïïnnä yaana äätïdï Äŋ Jïñe Wääktäŋ ti ye, ḍuuŋku däŋkä ke Pïrrïcïïnnï attä yoken ḍülï Biilaatuc ñome ti. ");
INSERT INTO jum_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Aŋ jaajjin ogo, “Mügdo, ikoon paydon wääna maldo ŋïngïn yaanja mor agee kä üdon kä ye, jaajjin ogo, ‘Ika bi juwu ñaalok nïïnkä kä ḍäk tüwnü ti.’ ");
INSERT INTO jum_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Aŋ iinjä dalä kääl wiñe tïïcä me ke nïïnnä ḍäk ti. Nuŋkodo baaddoni yeeke äätïdï aŋ gaane kaltä, aŋ me kiiṇtä ogo, ‘Juwono tüwnü ti.’ Aŋ aŋan yelkïtïn yaana düüñïn ti ye, bi yaajaŋ kä yaana ïïjjïn ti ye.” ");
INSERT INTO jum_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aŋ iken luugi Biilaatuc ogo, “Kuje tïïconi aŋ ate näŋe tïïññä bata yaana lïïlde ye. ");
INSERT INTO jum_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aŋ iken attä aŋ kääl wiñe näŋgi tïïññä, aŋ üüljï kä pääm aŋ märki gin'a ŋïcte daa kä ye, aŋ ḍuccin tïïconi. ");
INSERT INTO jum_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Aŋ tïṇṇä wic yen ïïjjïn ti nïïnnä ŋaṭükel ti, Märïyam yaana battä me ogo Majdalïïna ke Märïyam yaŋkalaŋ attä ükcïdï kääl wiñe. ");
INSERT INTO jum_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aŋ kä ḍeeraŋ aŋŋi ŋommañ bukcin kä yaac kä yaana malak yen Pïṭo kääjenee ïñï polloŋ jï ye, aŋ äätin aŋ pääm ḍüljene woo, aŋ cääjjene kä wic. ");
INSERT INTO jum_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aŋ biilke beel bata wïldïn, aŋ buruŋgu yeeke bowaŋ bata aak. ");
INSERT INTO jum_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aŋ tïïconi bojgin kä yaac aŋ yoken tïïcïn kä liin ke beeljene bata mä tüwïn. ");
INSERT INTO jum_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aŋ malak määngä kiinne ogo, “Ŋana ikee booje, ŋäjjä ikee määje Yeecüwa yaana ṭelji me ti kaakkon jok ina. ");
INSERT INTO jum_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ike batta a winni ike juwin ñaalok tüwnü ti, bata yaana jaajjenee kä ye. Ääte nänṭä yaana nïïnee kä ye yoore. ");
INSERT INTO jum_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ate kä bïraŋ, aŋ baaddoni yeeke kiine ogo, ‘Ike juwono ñaalok tüwnü ti, aŋ bilto ti ato ñomgic ti Jalïïl. Aŋ ike bi yoorje wïca.’ Yaaka nüütkene kä yaakki payde.” ");
INSERT INTO jum_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aŋ määngä kääl wiñe dalji ïñï kä bïraŋ kä liin, i a küümïn kä jon ñamme mooye, aŋ lüdgïn baaddoni yeeke nüütkütü. ");
INSERT INTO jum_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aŋ kä ḍeeraŋ aŋŋi, Yeecüwa purjene kä aŋ kiinne ogo, “Ogook?” Aŋ iken wükcïn ti ike ti aŋ tabi kïïgïn kä maaŋŋä. ");
INSERT INTO jum_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aŋ iken kiini Yeecüwa ogo, “Ŋana ikee booje. Ate aŋ mädgo nüütke ogo ato Jalïïl, aŋ ika bi yoorjada wïca.” ");
INSERT INTO jum_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aŋ wääna määngä äätene kä päy jï ye, i tïïconi yakkalaŋ attä baan jï, aŋ ḍuuŋku däŋkä yek Jooŋ päkki kä waak'a näŋŋä ḍuuggen ye muure. ");
INSERT INTO jum_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aŋ wääna ḍuuŋku däŋkä purjene ke yätïnï ye, i iken läälin pugin, aŋ kääygä iñi tiil kä ḍiräk. ");
INSERT INTO jum_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Aŋ kiini ogo, “Jaaye ogo baaddoni yeeke ken äätono ko mïïllä i ikee agje ootin, aŋ gaane kallïï. ");
INSERT INTO jum_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aŋ naana mügdo yaakki tiiŋŋe ye, i ikoon bi yuuton ñaalok kä ikee nuŋko ŋana kaaccede kä tïñïdïn gïtï.” ");
INSERT INTO jum_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aŋ kääygä tiil koowi, aŋ iken näŋjin bata yaana daa kiinene daa kä ḍuuŋku däŋkä yek Jooŋ ye. Aŋ jiik yaakki piirjin woo Yühüüṇṇï ti ke tiññaŋ. ");
INSERT INTO jum_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aŋ baaddoni yaaka kä caay wiñen kä keelok ye attä Jalïïl, pääm yaana nüütkene daa Yeecüwa ogo atcï ko ye ti. ");
INSERT INTO jum_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aŋ wääna ike yoorene daa kä ye, ike maaŋi aŋ yakkalaŋ juuggen riijjin. ");
INSERT INTO jum_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aŋ Yeecüwa äätin iken ti, aŋ jaajjin ogo, “Mügdïn yen polloŋ jïñe ke mügdïn yen ŋommañ wiñe, iñana kä Jooŋ muure. ");
INSERT INTO jum_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aŋ wäättan ate aŋ näŋe baaddoni ṭoŋ ti muure, aŋ iken büüle kä yäṇtäŋ Wäy ke Minneni ke Wääktäŋ Laṇṇä yen Jooŋ. ");
INSERT INTO jum_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aŋ iken nüüde dale tiŋit wakkä muure yaaka iingene kä ye. Aŋ wina ika bi ke ikee kamat ke düüñïn yen yuungu ti.”");
ALTER TABLE jum_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
