﻿USE sofia;
DROP TABLE IF EXISTS sofia.jpn1965_vpl;
CREATE TABLE jpn1965_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jpn1965_vpl WRITE;
INSERT INTO jpn1965_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","アブラハムの子孫、ダビデの子孫、イエス・キリストの系図。 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","アブラハムにイサクが生まれ、イサクにヤコブが生まれ、ヤコブにユダとその兄弟たちが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ユダに、タマルによってパレスとザラが生まれ、パレスにエスロンが生まれ、エスロンにアラムが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","アラムにアミナダブが生まれ、アミナダブにナアソンが生まれ、ナアソンにサルモンが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","サルモンに、ラハブによってボアズが生まれ、ボアズに、ルツによってオベデが生まれ、オベデにエッサイが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","エッサイにダビデ王が生まれた。 ダビデに、ウリヤの妻によってソロモンが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ソロモンにレハベアムが生まれ、レハベアムにアビヤが生まれ、アビヤにアサが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","アサにヨサパテが生まれ、ヨサパテにヨラムが生まれ、ヨラムにウジヤが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ウジヤにヨタムが生まれ、ヨタムにアハズが生まれ、アハズにヒゼキヤが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ヒゼキヤにマナセが生まれ、マナセにアモンが生まれ、アモンにヨシヤが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ヨシヤに、バビロン移住のころエコニヤとその兄弟たちが生まれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","バビロン移住の後、エコニヤにサラテルが生まれ、サラテルにゾロバベルが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ゾロバベルにアビウデが生まれ、アビウデにエリヤキムが生まれ、エリヤキムにアゾルが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","アゾルにサドクが生まれ、サドクにアキムが生まれ、アキムにエリウデが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","エリウデにエレアザルが生まれ、エレアザルにマタンが生まれ、マタンにヤコブが生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ヤコブにマリヤの夫ヨセフが生まれた。キリストと呼ばれるイエスはこのマリヤからお生まれになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","それで、アブラハムからダビデまでの代が全部で十四代、ダビデからバビロン移住までが十四代、バビロン移住からキリストまでが十四代になる。 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","イエス・キリストの誕生は次のようであった。その母マリヤはヨセフの妻と決まっていたが、ふたりがまだいっしょにならないうちに、聖霊によって身重になったことがわかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","夫のヨセフは正しい人であって、彼女をさらし者にはしたくなかったので、内密に去らせようと決めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","彼がこのことを思い巡らしていたとき、主の使いが夢に現われて言った。「ダビデの子ヨセフ。恐れないであなたの妻マリヤを迎えなさい。その胎に宿っているものは聖霊によるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","マリヤは男の子を産みます。その名をイエスとつけなさい。この方こそ、ご自分の民をその罪から救ってくださる方です。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","このすべての出来事は、主が預言者を通して言われた事が成就するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","「見よ、処女がみごもっている。そして男の子を産む。その名はインマヌエルと呼ばれる。」（訳すと、神は私たちとともにおられる、という意味である。） ");
INSERT INTO jpn1965_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ヨセフは眠りからさめ、主の使いに命じられたとおりにして、その妻を迎え入れ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","そして、子どもが生まれるまで彼女を知ることがなく、その子どもの名をイエスとつけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","イエスが、ヘロデ王の時代に、ユダヤのベツレヘムでお生まれになったとき、見よ、東方の博士たちがエルサレムにやって来て、こう言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","「ユダヤ人の王としてお生まれになった方はどこにおいでになりますか。私たちは、東のほうでその方の星を見たので、拝みにまいりました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","それを聞いて、ヘロデ王は恐れ惑った。エルサレム中の人も王と同様であった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","そこで、王は、民の祭司長たち、学者たちをみな集めて、キリストはどこで生まれるのかと問いただした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","彼らは王に言った。「ユダヤのベツレヘムです。預言者によってこう書かれているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","『ユダの地、ベツレヘム。 あなたはユダを治める者たちの中で、 決して一番小さくはない。 わたしの民イスラエルを治める支配者が、 あなたから出るのだから。』」 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","そこで、ヘロデはひそかに博士たちを呼んで、彼らから星の出現の時間を突き止めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","そして、こう言って彼らをベツレヘムに送った。「行って幼子のことを詳しく調べ、わかったら知らせてもらいたい。私も行って拝むから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","彼らは王の言ったことを聞いて出かけた。すると、見よ、東方で見た星が彼らを先導し、ついに幼子のおられる所まで進んで行き、その上にとどまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","その星を見て、彼らはこの上もなく喜んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","そしてその家にはいって、母マリヤとともにおられる幼子を見、ひれ伏して拝んだ。そして、宝の箱をあけて、黄金、乳香、没薬を贈り物としてささげた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","それから、夢でヘロデのところへ戻るなという戒めを受けたので、別の道から自分の国へ帰って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","彼らが帰って行ったとき、見よ、主の使いが夢でヨセフに現われて言った。「立って、幼子とその母を連れ、エジプトへ逃げなさい。そして、私が知らせるまで、そこにいなさい。ヘロデがこの幼子を捜し出して殺そうとしています。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","そこで、ヨセフは立って、夜のうちに幼子とその母を連れてエジプトに立ちのき、 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ヘロデが死ぬまでそこにいた。これは、主が預言者を通して、「わたしはエジプトから、わたしの子を呼び出した。」と言われた事が成就するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","その後、ヘロデは、博士たちにだまされたことがわかると、非常におこって、人をやって、ベツレヘムとその近辺の二歳以下の男の子をひとり残らず殺させた。その年令は博士たちから突き止めておいた時間から割り出したのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","そのとき、預言者エレミヤを通して言われた事が成就した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","「ラマで声がする。 泣き、そして嘆き叫ぶ声。 ラケルがその子らのために泣いている。 ラケルは慰められることを拒んだ。 子らがもういないからだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ヘロデが死ぬと、見よ、主の使いが、夢でエジプトにいるヨセフに現われて、言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","「立って、幼子とその母を連れて、イスラエルの地に行きなさい。幼子のいのちをつけねらっていた人たちは死にました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","そこで、彼は立って、幼子とその母を連れて、イスラエルの地にはいった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","しかし、アケラオが父ヘロデに代わってユダヤを治めていると聞いたので、そこに行ってとどまることを恐れた。そして、夢で戒めを受けたので、ガリラヤ地方に立ちのいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","そして、ナザレという町に行って住んだ。これは預言者たちを通して「この方はナザレ人と呼ばれる。」と言われた事が成就するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","そのころ、バプテスマのヨハネが現われ、ユダヤの荒野で教えを宣べて、言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","「悔い改めなさい。天の御国が近づいたから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","この人は預言者イザヤによって、 「荒野で叫ぶ者の声がする。『主の道を用意し、主の通られる道をまっすぐにせよ。』」 と言われたその人である。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","このヨハネは、らくだの毛の着物を着、腰には皮の帯を締め、その食べ物はいなごと野蜜であった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","さて、エルサレム、ユダヤ全土、ヨルダン川沿いの全地域の人々がヨハネのところへ出て行き、 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","自分の罪を告白して、ヨルダン川で彼からバプテスマを受けた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","しかし、パリサイ人やサドカイ人が大ぜいバプテスマを受けに来るのを見たとき、ヨハネは彼らに言った。「まむしのすえたち。だれが必ず来る御怒りをのがれるように教えたのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","それなら、悔い改めにふさわしい実を結びなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","『われわれの先祖はアブラハムだ。』と心の中で言うような考えではいけません。あなたがたに言っておくが、神は、この石ころからでも、アブラハムの子孫を起こすことがおできになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","斧もすでに木の根元に置かれています。だから、良い実を結ばない木は、みな切り倒されて、火に投げ込まれます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","私は、あなたがたが悔い改めるために、水のバプテスマを授けていますが、私のあとから来られる方は、私よりもさらに力のある方です。私はその方のはきものを脱がせてあげる値うちもありません。その方は、あなたがたに聖霊と火とのバプテスマをお授けになります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","手に箕を持っておられ、ご自分の脱穀場をすみずみまできよめられます。麦を倉に納め、殻を消えない火で焼き尽くされます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","さて、イエスは、ヨハネからバプテスマを受けるために、ガリラヤからヨルダンにお着きになり、ヨハネのところに来られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","しかし、ヨハネはイエスにそうさせまいとして、言った。「私こそ、あなたからバプテスマを受けるはずですのに、あなたが、私のところにおいでになるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ところが、イエスは答えて言われた。「今はそうさせてもらいたい。このようにして、すべての正しいことを実行するのは、わたしたちにふさわしいのです。」そこで、ヨハネは承知した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","こうして、イエスはバプテスマを受けて、すぐに水から上がられた。すると、天が開け、神の御霊が鳩のように下って、自分の上に来られるのをご覧になった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","また、天からこう告げる声が聞こえた。「これは、わたしの愛する子、わたしはこれを喜ぶ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","さて、イエスは、悪魔の試みを受けるため、御霊に導かれて荒野に上って行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","そして、四十日四十夜断食したあとで、空腹を覚えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","すると、試みる者が近づいて来て言った。「あなたが神の子なら、この石がパンになるように、命じなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","イエスは答えて言われた。「『人はパンだけで生きるのではなく、神の口から出る一つ一つのことばによる。』と書いてある。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","すると、悪魔はイエスを聖なる都に連れて行き、神殿の頂に立たせて、 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","言った。「あなたが神の子なら、下に身を投げてみなさい。『神は御使いたちに命じて、その手にあなたをささえさせ、あなたの足が石に打ち当たることのないようにされる。』と書いてありますから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","イエスは言われた。「『あなたの神である主を試みてはならない。』とも書いてある。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","今度は悪魔は、イエスを非常に高い山に連れて行き、この世のすべての国々とその栄華を見せて、 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","言った。「もしひれ伏して私を拝むなら、これを全部あなたに差し上げましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","イエスは言われた。「引き下がれ、サタン。『あなたの神である主を拝み、主にだけ仕えよ。』と書いてある。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","すると悪魔はイエスを離れて行き、見よ、御使いたちが近づいて来て仕えた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ヨハネが捕えられたと聞いてイエスは、ガリラヤへ立ちのかれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","そしてナザレを去って、カペナウムに来て住まわれた。ゼブルンとナフタリとの境にある、湖のほとりの町である。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","これは、預言者イザヤを通して言われた事が、成就するためであった。すなわち、 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","「ゼブルンの地とナフタリの地、湖に向かう道、 ヨルダンの向こう岸、異邦人のガリラヤ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","暗やみの中にすわっていた民は偉大な光を見、 死の地と死の陰にすわっていた人々に、 光が上った。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","この時から、イエスは宣教を開始して、言われた。「悔い改めなさい。天の御国が近づいたから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","イエスがガリラヤ湖のほとりを歩いておられたとき、ふたりの兄弟、ペテロと呼ばれるシモンとその兄弟アンデレをご覧になった。彼らは湖で網を打っていた。漁師だったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","イエスは彼らに言われた。「わたしについて来なさい。あなたがたを、人間をとる漁師にしてあげよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","彼らはすぐに網を捨てて従った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","そこからなお行かれると、イエスは、別のふたりの兄弟、ゼベダイの子ヤコブとその兄弟ヨハネが、父ゼベダイといっしょに舟の中で網を繕っているのをご覧になり、ふたりをお呼びになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","彼らはすぐに舟も父も残してイエスに従った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","イエスはガリラヤ全土を巡って、会堂で教え、御国の福音を宣べ伝え、民の中のあらゆる病気、あらゆるわずらいを直された。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","イエスのうわさはシリヤ全体に広まった。それで、人々は、さまざまの病気と痛みに苦しむ病人、悪霊につかれた人、てんかん持ちや、中風の者などをみな、みもとに連れて来た。イエスは彼らをお直しになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","こうしてガリラヤ、デカポリス、エルサレム、ユダヤおよびヨルダンの向こう岸から大ぜいの群衆がイエスにつき従った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","この群衆を見て、イエスは山に登り、おすわりになると、弟子たちがみもとに来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","そこで、イエスは口を開き、彼らに教えて、言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","「心の貧しい者は幸いです。天の御国はその人のものだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","悲しむ者は幸いです。その人は慰められるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","柔和な者は幸いです。その人は地を相続するからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","義に飢え渇いている者は幸いです。その人は満ち足りるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","あわれみ深い者は幸いです。その人はあわれみを受けるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","心のきよい者は幸いです。その人は神を見るからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","平和をつくる者は幸いです。その人は神の子どもと呼ばれるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","義のために迫害されている者は幸いです。天の御国はその人のものだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","わたしのために、ののしられたり、迫害されたり、また、ありもしないことで悪口雑言を言われたりするとき、あなたがたは幸いです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","喜びなさい。喜びおどりなさい。天においてあなたがたの報いは大きいのだから。あなたがたより前に来た預言者たちも、そのように迫害されました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","あなたがたは、地の塩です。もし塩が塩けをなくしたら、何によって塩けをつけるのでしょう。もう何の役にも立たず、外に捨てられて、人々に踏みつけられるだけです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","あなたがたは、世界の光です。山の上にある町は隠れる事ができません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","また、あかりをつけて、それを枡の下に置く者はありません。燭台の上に置きます。そうすれば、家にいる人々全部を照らします。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","このように、あなたがたの光を人々の前で輝かせ、人々があなたがたの良い行ないを見て、天におられるあなたがたの父をあがめるようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","わたしが来たのは律法や預言者を廃棄するためだと思ってはなりません。廃棄するためにではなく、成就するために来たのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","まことに、あなたがたに告げます。天地が滅びうせない限り、律法の中の一点一画でも決してすたれることはありません。全部が成就されます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","だから、戒めのうち最も小さいものの一つでも、これを破ったり、また破るように人に教えたりする者は、天の御国で、最も小さい者と呼ばれます。しかし、それを守り、また守るように教える者は、天の御国で、偉大な者と呼ばれます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","まことに、あなたがたに告げます。もしあなたがたの義が、律法学者やパリサイ人の義にまさるものでないなら、あなたがたは決して天の御国に、はいれません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","昔の人々に、『人を殺してはならない。人を殺す者はさばきを受けなければならない。』と言われたのを、あなたがたは聞いています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","しかし、わたしはあなたがたに言います。兄弟に向かって腹を立てる者は、だれでもさばきを受けなければなりません。兄弟に向かって『能なし。』と言うような者は、最高議会に引き渡されます。また、『ばか者。』と言うような者は燃えるゲヘナに投げ込まれます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","だから、祭壇の上に供え物をささげようとしているとき、もし兄弟に恨まれていることをそこで思い出したなら、 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","供え物はそこに、祭壇の前に置いたままにして、出て行って、まずあなたの兄弟と仲直りをしなさい。それから、来て、その供え物をささげなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","あなたを告訴する者とは、あなたが彼といっしょに途中にある間に早く仲良くなりなさい。そうでないと、告訴する者は、あなたを裁判官に引き渡し、裁判官は下役に引き渡して、あなたはついに牢に入れられることになります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","まことに、あなたに告げます。あなたは最後の一コドラントを支払うまでは、そこから出ては来られません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","『姦淫してはならない。』と言われたのを、あなたがたは聞いています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","しかし、わたしはあなたがたに言います。だれでも情欲をいだいて女を見る者は、すでに心の中で姦淫を犯したのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","もし、右の目が、あなたをつまずかせるなら、えぐり出して、捨ててしまいなさい。からだの一部を失っても、からだ全体ゲヘナに投げ込まれるよりは、よいからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","もし、右の手があなたをつまずかせるなら、切って、捨ててしまいなさい。からだの一部を失っても、からだ全体ゲヘナに落ちるよりは、よいからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","また『だれでも、妻を離別する者は、妻に離婚状を与えよ。』と言われています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","しかし、わたしはあなたがたに言います。だれであっても、不貞以外の理由で妻を離別する者は、妻に姦淫を犯させるのです。また、だれでも、離別された女と結婚すれば、姦淫を犯すのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","さらにまた、昔の人々に、『偽りの誓いを立ててはならない。あなたの誓ったことを主に果たせ。』と言われていたのを、あなたがたは聞いています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","しかし、わたしはあなたがたに言います。決して誓ってはいけません。すなわち、天をさして誓ってはいけません。そこは神の御座だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","地をさして誓ってもいけません。そこは神の足台だからです。エルサレムをさして誓ってもいけません。そこは偉大な王の都だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","あなたの頭をさして誓ってもいけません。あなたは、一本の髪の毛すら、白くも黒くもできないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","だから、あなたがたは、『はい。』は『はい。』、『いいえ。』は『いいえ。』とだけ言いなさい。それ以上のことは悪いことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","『目には目で、歯には歯で。』と言われたのを、あなたがたは聞いています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","しかし、わたしはあなたがたに言います。悪い者に手向かってはいけません。あなたの右の頬を打つような者には、左の頬も向けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","あなたを告訴して下着を取ろうとする者には、上着もやりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","あなたに一ミリオン行けと強いるような者とは、いっしょに二ミリオン行きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","求める者には与え、借りようとする者は断わらないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","『自分の隣人を愛し、自分の敵を憎め。』と言われたのを、あなたがたは聞いています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","しかし、わたしはあなたがたに言います。自分の敵を愛し、迫害する者のために祈りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","それでこそ、天におられるあなたがたの父の子どもになれるのです。天の父は、悪い人にも良い人にも太陽を上らせ、正しい人にも正しくない人にも雨を降らせてくださるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","自分を愛してくれる者を愛したからといって、何の報いが受けられるでしょう。取税人でも、同じことをしているではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","また、自分の兄弟にだけあいさつしたからといって、どれだけまさったことをしたのでしょう。異邦人でも同じことをするではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","だから、あなたがたは、天の父が完全なように、完全でありなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","人に見せるために人前で善行をしないように気をつけなさい。そうでないと、天におられるあなたがたの父から、報いが受けられません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","だから、施しをするときには、人にほめられたくて会堂や通りで施しをする偽善者たちのように、自分の前でラッパを吹いてはいけません。まことに、あなたがたに告げます。彼らはすでに自分の報いを受け取っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","あなたは、施しをするとき、右の手のしていることを左の手に知られないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","あなたの施しが隠れているためです。そうすれば、隠れた所で見ておられるあなたの父が、あなたに報いてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","また、祈るときには、偽善者たちのようであってはいけません。彼らは、人に見られたくて会堂や通りの四つ角に立って祈るのが好きだからです。まことに、あなたがたに告げます。彼らはすでに自分の報いを受け取っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","あなたは、祈るときには自分の奥まった部屋にはいりなさい。そして、戸をしめて、隠れた所におられるあなたの父に祈りなさい。そうすれば、隠れた所で見ておられるあなたの父が、あなたに報いてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","また、祈るとき、異邦人のように同じことばを、ただくり返してはいけません。彼らはことば数が多ければ聞かれると思っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","だから、彼らのまねをしてはいけません。あなたがたの父なる神は、あなたがたがお願いする先に、あなたがたに必要なものを知っておられるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","だから、こう祈りなさい。 『天にいます私たちの父よ。 御名があがめられますように。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","御国が来ますように。 みこころが天で行なわれるように地でも行なわれますように。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","私たちの日ごとの糧をきょうもお与えください。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","私たちの負いめをお赦しください。 私たちも、私たちに負いめのある人たちを赦しました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","私たちを試みに会わせないで、悪からお救いください。』［国と力と栄えは、とこしえにあなたのものだからです。アーメン。］ ");
INSERT INTO jpn1965_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","もし人の罪を赦すなら、あなたがたの天の父もあなたがたを赦してくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","しかし、人を赦さないなら、あなたがたの父もあなたがたの罪をお赦しになりません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","断食するときには、偽善者たちのようにやつれた顔つきをしてはいけません。彼らは、断食していることが人に見えるようにと、その顔をやつすのです。まことに、あなたがたに告げます。彼らはすでに自分の報いを受け取っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","しかし、あなたが断食するときには、自分の頭に油を塗り、顔を洗いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","それは、断食していることが、人には見られないで、隠れた所におられるあなたの父に見られるためです。そうすれば、隠れた所で見ておられるあなたの父が報いてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","自分の宝を地上にたくわえるのはやめなさい。そこでは虫とさびで、きず物になり、また盗人が穴をあけて盗みます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","自分の宝は、天にたくわえなさい。そこでは、虫もさびもつかず、盗人が穴をあけて盗むこともありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","あなたの宝のあるところに、あなたの心もあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","からだのあかりは目です。それで、もしあなたの目が健全なら、あなたの全身が明るいが、 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","もし、目が悪ければ、あなたの全身が暗いでしょう。それなら、もしあなたのうちの光が暗ければ、その暗さはどんなでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","だれも、ふたりの主人に仕えることはできません。一方を憎んで他方を愛したり、一方を重んじて他方を軽んじたりするからです。あなたがたは、神にも仕え、また富にも仕えるということはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","だから、わたしはあなたがたに言います。自分のいのちのことで、何を食べようか、何を飲もうかと心配したり、また、からだのことで、何を着ようかと心配したりしてはいけません。いのちは食べ物よりたいせつなもの、からだは着物よりたいせつなものではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","空の鳥を見なさい。種蒔きもせず、刈り入れもせず、倉に納めることもしません。けれども、あなたがたの天の父がこれを養っていてくださるのです。あなたがたは、鳥よりも、もっとすぐれたものではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","あなたがたのうちだれが、心配したからといって、自分のいのちを少しでも延ばすことができますか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","なぜ着物のことで心配するのですか。野のゆりがどうして育つのか、よくわきまえなさい。働きもせず、紡ぎもしません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","しかし、わたしはあなたがたに言います。栄華を窮めたソロモンでさえ、このような花の一つほどにも着飾ってはいませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","きょうあっても、あすは炉に投げ込まれる野の草さえ、神はこれほどに装ってくださるのだから、ましてあなたがたに、よくしてくださらないわけがありましょうか。信仰の薄い人たち。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","そういうわけだから、何を食べるか、何を飲むか、何を着るか、などと言って心配するのはやめなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","こういうものはみな、異邦人が切に求めているものなのです。しかし、あなたがたの天の父は、それがみなあなたがたに必要であることを知っておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","だから、神の国とその義とをまず第一に求めなさい。そうすれば、それに加えて、これらのものはすべて与えられます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","だから、あすのための心配は無用です。あすのことはあすが心配します。労苦はその日その日に、十分あります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","さばいてはいけません。さばかれないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","あなたがたがさばくとおりに、あなたがたもさばかれ、あなたがたが量るとおりに、あなたがたも量られるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","また、なぜあなたは、兄弟の目の中のちりに目をつけるが、自分の目の中の梁には気がつかないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","兄弟に向かって、『あなたの目のちりを取らせてください。』などとどうして言うのですか。見なさい、自分の目には梁があるではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","偽善者たち。まず自分の目から梁を取りのけなさい。そうすれば、はっきり見えて、兄弟の目からも、ちりを取り除くことができます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","聖なるものを犬に与えてはいけません。また豚の前に、真珠を投げてはなりません。それを足で踏みにじり、向き直ってあなたがたを引き裂くでしょうから。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","求めなさい。そうすれば与えられます。捜しなさい。そうすれば見つかります。たたきなさい。そうすれば開かれます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","だれであれ、求める者は受け、捜す者は見つけ出し、たたく者には開かれます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","あなたがたも、自分の子がパンを下さいと言うときに、だれが石を与えるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","また、子が魚を下さいと言うのに、だれが蛇を与えるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","してみると、あなたがたは、悪い者ではあっても、自分の子どもには良い物を与えることを知っているのです。とすれば、なおのこと、天におられるあなたがたの父が、どうして、求める者たちに良いものを下さらないことがありましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","それで、何事でも、自分にしてもらいたいことは、ほかの人にもそのようにしなさい。これが律法であり預言者です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","狭い門からはいりなさい。滅びに至る門は大きく、その道は広いからです。そして、そこからはいって行く者が多いのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","いのちに至る門は小さく、その道は狭く、それを見いだす者はまれです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","にせ預言者たちに気をつけなさい。彼らは羊のなりをしてやって来るが、うちは貪欲な狼です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","あなたがたは、実によって彼らを見分けることができます。ぶどうは、いばらからは取れないし、いちじくは、あざみから取れるわけがないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","同様に、良い木はみな良い実を結ぶが、悪い木は悪い実を結びます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","良い木が悪い実をならせることはできないし、また、悪い木が良い実をならせることもできません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","良い実を結ばない木は、みな切り倒されて、火に投げ込まれます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","こういうわけで、あなたがたは、実によって彼らを見分けることができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","わたしに向かって、『主よ、主よ。』と言う者がみな天の御国にはいるのではなく、天におられるわたしの父のみこころを行なう者がはいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","その日には、大ぜいの者がわたしに言うでしょう。『主よ、主よ。私たちはあなたの名によって預言をし、あなたの名によって悪霊を追い出し、あなたの名によって奇蹟をたくさん行なったではありませんか。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","しかし、その時、わたしは彼らにこう宣告します。『わたしはあなたがたを全然知らない。不法をなす者ども。わたしから離れて行け。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","だから、わたしのこれらのことばを聞いてそれを行なう者はみな、岩の上に自分の家を建てた賢い人に比べることができます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","雨が降って洪水が押し寄せ、風が吹いてその家に打ちつけたが、それでも倒れませんでした。岩の上に建てられていたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","また、わたしのこれらのことばを聞いてそれを行なわない者はみな、砂の上に自分の家を建てた愚かな人に比べることができます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","雨が降って洪水が押し寄せ、風が吹いてその家に打ちつけると、倒れてしまいました。しかもそれはひどい倒れ方でした。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","イエスがこれらのことばを語り終えられると、群衆はその教えに驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","というのは、イエスが、律法学者たちのようにではなく、権威ある者のように教えられたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","イエスが山から降りて来られると、多くの群衆がイエスに従った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","すると、ひとりのらい病人がみもとに来て、ひれ伏して言った。「主よ。お心一つで、私をきよめることがおできになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","イエスは手を伸ばして、彼にさわり、「わたしの心だ。きよくなれ。」と言われた。すると、すぐに彼のらい病はきよめられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","イエスは彼に言われた。「気をつけて、だれにも話さないようにしなさい。ただ、人々へのあかしのために、行って、自分を祭司に見せなさい。そして、モーセの命じた供え物をささげなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","イエスがカペナウムにはいられると、ひとりの百人隊長がみもとに来て、懇願して、 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","言った。「主よ。私のしもべが中風やみで、家に寝ていて、ひどく苦しんでおります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","イエスは彼に言われた。「行って、直してあげよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","しかし、百人隊長は答えて言った。「主よ。あなたを私の屋根の下にお入れする資格は、私にはありません。ただ、おことばをいただかせてください。そうすれば、私のしもべは直りますから。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","と申しますのは、私も権威の下にある者ですが、私自身の下にも兵士たちがいまして、そのひとりに『行け。』と言えば行きますし、別の者に『来い。』と言えば来ます。また、しもべに『これをせよ。』と言えば、そのとおりにいたします。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","イエスは、これを聞いて驚かれ、ついて来た人たちにこう言われた。「まことに、あなたがたに告げます。わたしはイスラエルのうちのだれにも、このような信仰を見たことがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","あなたがたに言いますが、たくさんの人が東からも西からも来て、天の御国で、アブラハム、イサク、ヤコブといっしょに食卓に着きます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","しかし、御国の子らは外の暗やみに放り出され、そこで泣いて歯ぎしりするのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","それから、イエスは百人隊長に言われた。「さあ行きなさい。あなたの信じたとおりになるように。」すると、ちょうどその時、そのしもべはいやされた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","それから、イエスは、ペテロの家に来られて、ペテロのしゅうとめが熱病で床に着いているのをご覧になった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","イエスが手にさわられると、熱がひき、彼女は起きてイエスをもてなした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","夕方になると、人々は悪霊につかれた者を大ぜい、みもとに連れて来た。そこで、イエスはみことばをもって霊どもを追い出し、また病気の人々をみなお直しになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","これは、預言者イザヤを通して言われた事が成就するためであった。「彼が私たちのわずらいを身に引き受け、私たちの病を背負った。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","さて、イエスは群衆が自分の回りにいるのをご覧になると、向こう岸に行くための用意をお命じになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","そこに、ひとりの律法学者が来てこう言った。「先生。私はあなたのおいでになる所なら、どこにでもついてまいります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","すると、イエスは彼に言われた。「狐には穴があり、空の鳥には巣があるが、人の子には枕する所もありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","また、別のひとりの弟子がイエスにこう言った。「主よ。まず行って、私の父を葬ることを許してください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ところが、イエスは彼に言われた。「わたしについて来なさい。死人たちに彼らの中の死人たちを葬らせなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","イエスが舟にお乗りになると、弟子たちも従った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","すると、見よ、湖に大暴風が起こって、舟は大波をかぶった。ところが、イエスは眠っておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","弟子たちはイエスのみもとに来て、イエスを起こして言った。「主よ。助けてください。私たちはおぼれそうです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","イエスは言われた。「なぜこわがるのか、信仰の薄い者たちだ。」それから、起き上がって、風と湖をしかりつけられると、大なぎになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","人々は驚いてこう言った。「風や湖までが言うことをきくとは、いったいこの方はどういう方なのだろう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","それから、向こう岸のガダラ人の地にお着きになると、悪霊につかれた人がふたり墓から出て来て、イエスに出会った。彼らはひどく狂暴で、だれもその道を通れないほどであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","すると、見よ、彼らはわめいて言った。「神の子よ。いったい私たちに何をしようというのです。まだその時ではないのに、もう私たちを苦しめに来られたのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ところで、そこからずっと離れた所に、たくさんの豚の群れが飼ってあった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","それで、悪霊どもはイエスに願ってこう言った。「もし私たちを追い出そうとされるのでしたら、どうか豚の群れの中にやってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","イエスは彼らに「行け。」と言われた。すると、彼らは出て行って豚にはいった。すると、見よ、その群れ全体がどっとがけから湖へ駆け降りて行って、水におぼれて死んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","飼っていた者たちは逃げ出して町に行き、悪霊につかれた人たちのことなどを残らず知らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","すると、見よ、町中の者がイエスに会いに出て来た。そして、イエスに会うと、どうかこの地方を立ち去ってくださいと願った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","イエスは舟に乗って湖を渡り、自分の町に帰られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","すると、人々が中風の人を床に寝かせたままで、みもとに運んで来た。イエスは彼らの信仰を見て、中風の人に、「子よ。しっかりしなさい。あなたの罪は赦された。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","すると、律法学者たちは、心の中で、「この人は神をけがしている。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","イエスは彼らの心の思いを知って言われた。「なぜ、心の中で悪いことを考えているのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","『あなたの罪は赦された。』と言うのと、『起きて歩け。』と言うのと、どちらがやさしいか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","人の子が地上で罪を赦す権威を持っていることを、あなたがたに知らせるために。」こう言って、それから中風の人に、「起きなさい。寝床をたたんで、家に帰りなさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","すると、彼は起きて家に帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","群衆はそれを見て恐ろしくなり、こんな権威を人にお与えになった神をあがめた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","イエスは、そこを去って道を通りながら、収税所にすわっているマタイという人をご覧になって、「わたしについて来なさい。」と言われた。すると彼は立ち上がって、イエスに従った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","イエスが家で食事の席に着いておられるとき、見よ、取税人や罪人が大ぜい来て、イエスやその弟子たちといっしょに食卓に着いていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","すると、これを見たパリサイ人たちが、イエスの弟子たちに言った。「なぜ、あなたがたの先生は、取税人や罪人といっしょに食事をするのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","イエスはこれを聞いて言われた。「医者を必要とするのは丈夫な者ではなく、病人です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","『わたしはあわれみは好むが、いけにえは好まない。』とはどういう意味か、行って学んで来なさい。わたしは正しい人を招くためではなく、罪人を招くために来たのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","するとまた、ヨハネの弟子たちが、イエスのところに来てこう言った。「私たちとパリサイ人は断食するのに、なぜ、あなたの弟子たちは断食しないのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","イエスは彼らに言われた。「花婿につき添う友だちは、花婿がいっしょにいる間は、どうして悲しんだりできましょう。しかし、花婿が取り去られる時が来ます。そのときには断食します。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","だれも、真新しい布切れで古い着物の継ぎをするようなことはしません。そんな継ぎ切れは着物を引き破って、破れがもっとひどくなるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","また、人は新しいぶどう酒を古い皮袋に入れるようなことはしません。そんなことをすれば、皮袋は裂けて、ぶどう酒が流れ出てしまい、皮袋もだめになってしまいます。新しいぶどう酒を新しい皮袋に入れれば、両方とも保ちます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","イエスがこれらのことを話しておられると、見よ、ひとりの会堂管理者が来て、ひれ伏して言った。「私の娘がいま死にました。でも、おいでくださって、娘の上に御手を置いてやってください。そうすれば娘は生き返ります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","イエスが立って彼について行かれると、弟子たちもついて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","すると、見よ。十二年の間長血をわずらっている女が、イエスのうしろに来て、その着物のふさにさわった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","「お着物にさわることでもできれば、きっと直る。」と心のうちで考えていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","イエスは、振り向いて彼女を見て言われた。「娘よ。しっかりしなさい。あなたの信仰があなたを直したのです。」すると、女はその時から全く直った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","イエスはその管理者の家に来られて、笛吹く者たちや騒いでいる群衆を見て、 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","言われた。「あちらに行きなさい。その子は死んだのではない。眠っているのです。」すると、彼らはイエスをあざ笑った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","イエスは群衆を外に出してから、うちにおはいりになり、少女の手を取られた。すると少女は起き上がった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","このうわさはその地方全体に広まった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","イエスがそこを出て、道を通って行かれると、ふたりの盲人が大声で、「ダビデの子よ。私たちをあわれんでください。」と叫びながらついて来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","家にはいられると、その盲人たちはみもとにやって来た。イエスが「わたしにそんなことができると信じるのか。」と言われると、彼らは「そうです。主よ。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","そこで、イエスは彼らの目にさわって、「あなたがたの信仰のとおりになれ。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","すると、彼らの目があいた。イエスは彼らをきびしく戒めて、「決してだれにも知られないように気をつけなさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ところが、彼らは出て行って、イエスのことをその地方全体に言いふらした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","この人たちが出て行くと、見よ、悪霊につかれたおしが、みもとに連れて来られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","悪霊が追い出されると、そのおしはものを言った。群衆は驚いて、「こんなことは、イスラエルでいまだかつて見たことがない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","しかし、パリサイ人たちは、「彼は悪霊どものかしらを使って、悪霊どもを追い出しているのだ。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","それから、イエスは、すべての町や村を巡って、会堂で教え、御国の福音を宣べ伝え、あらゆる病気、あらゆるわずらいを直された。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","また、群衆を見て、羊飼いのない羊のように弱り果てて倒れている彼らをかわいそうに思われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","そのとき、弟子たちに言われた。「収穫は多いが、働き手が少ない。 ");
INSERT INTO jpn1965_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","だから、収穫の主に、収穫のために働き手を送ってくださるように祈りなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","イエスは十二弟子を呼び寄せて、汚れた霊どもを制する権威をお授けになった。霊どもを追い出し、あらゆる病気、あらゆるわずらいを直すためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","さて、十二使徒の名は次のとおりである。まず、ペテロと呼ばれるシモンとその兄弟アンデレ、ゼベダイの子ヤコブとその兄弟ヨハネ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ピリポとバルトロマイ、トマスと取税人マタイ、アルパヨの子ヤコブとタダイ、 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","熱心党員シモンとイエスを裏切ったイスカリオテ・ユダである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","イエスは、この十二人を遣わし、そのとき彼らにこう命じられた。「異邦人の道に行ってはいけません。サマリヤ人の町にはいってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","イスラエルの家の滅びた羊のところに行きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","行って、『天の御国が近づいた。』と宣べ伝えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","病人を直し、死人を生き返らせ、らい病人をきよめ、悪霊を追い出しなさい。あなたがたは、ただで受けたのだから、ただで与えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","胴巻に金貨や銀貨や銅貨を入れてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","旅行用の袋も、二枚目の下着も、くつも、杖も持たずに行きなさい。働く者が食べ物を与えられるのは当然だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","どんな町や村にはいっても、そこでだれが適当な人かを調べて、そこを立ち去るまで、その人のところにとどまりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","その家にはいるときには、平安を祈るあいさつをしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","その家がそれにふさわしい家なら、その平安はきっとその家に来るし、もし、ふさわしい家でないなら、その平安はあなたがたのところに返って来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","もしだれも、あなたがたを受け入れず、あなたがたのことばに耳を傾けないなら、その家またはその町を出て行くときに、あなたがたの足のちりを払い落としなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","まことに、あなたがたに告げます。さばきの日には、ソドムとゴモラの地でも、その町よりはまだ罰が軽いのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","いいですか。わたしが、あなたがたを遣わすのは、狼の中に羊を送り出すようなものです。ですから、蛇のようにさとく、鳩のようにすなおでありなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","人々には用心しなさい。彼らはあなたがたを議会に引き渡し、会堂でむち打ちますから。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","また、あなたがたは、わたしのゆえに、総督たちや王たちの前に連れて行かれます。それは、彼らと異邦人たちにあかしをするためです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","人々があなたがたを引き渡したとき、どのように話そうか、何を話そうかと心配するには及びません。話すべきことは、そのとき示されるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","というのは、話すのはあなたがたではなく、あなたがたのうちにあって話されるあなたがたの父の御霊だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","兄弟は兄弟を死に渡し、父は子を死に渡し、子どもたちは両親に立ち逆らって、彼らを死なせます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","また、わたしの名のために、あなたがたはすべての人々に憎まれます。しかし、最後まで耐え忍ぶ者は救われます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","彼らがこの町であなたがたを迫害するなら、次の町にのがれなさい。というわけは、確かなことをあなたがたに告げるのですが、人の子が来るときまでに、あなたがたは決してイスラエルの町々を巡り尽くせないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","弟子はその師にまさらず、しもべはその主人にまさりません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","弟子がその師のようになれたら十分だし、しもべがその主人のようになれたら十分です。彼らは家長をベルゼブルと呼ぶぐらいですから、ましてその家族の者のことは、何と呼ぶでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","だから、彼らを恐れてはいけません。おおわれているもので、現わされないものはなく、隠されているもので知られずに済むものはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","わたしが暗やみであなたがたに話すことを明るみで言いなさい。また、あなたがたが耳もとで聞くことを屋上で言い広めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","からだを殺しても、たましいを殺せない人たちなどを恐れてはなりません。そんなものより、たましいもからだも、ともにゲヘナで滅ぼすことのできる方を恐れなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","二羽の雀は一アサリオンで売っているでしょう。しかし、そんな雀の一羽でも、あなたがたの父のお許しなしには地に落ちることはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","また、あなたがたの頭の毛さえも、みな数えられています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","だから恐れることはありません。あなたがたは、たくさんの雀よりもすぐれた者です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ですから、わたしを人の前で認める者はみな、わたしも、天におられるわたしの父の前でその人を認めます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","しかし、人の前でわたしを知らないと言うような者なら、わたしも天におられるわたしの父の前で、そんな者は知らないと言います。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","わたしが来たのは地に平和をもたらすためだと思ってはなりません。わたしは、平和をもたらすために来たのではなく、剣をもたらすために来たのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","なぜなら、わたしは人をその父に、娘をその母に、嫁をそのしゅうとめに逆らわせるために来たからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","さらに、家族の者がその人の敵となります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","わたしよりも父や母を愛する者は、わたしにふさわしい者ではありません。また、わたしよりも息子や娘を愛する者は、わたしにふさわしい者ではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","自分の十字架を負ってわたしについて来ない者は、わたしにふさわしい者ではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","自分のいのちを自分のものとした者はそれを失い、わたしのために自分のいのちを失った者は、それを自分のものとします。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","あなたがたを受け入れる者は、わたしを受け入れるのです。また、わたしを受け入れる者は、わたしを遣わした方を受け入れるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","預言者を預言者だというので受け入れる者は、預言者の受ける報いを受けます。また、義人を義人だということで受け入れる者は、義人の受ける報いを受けます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","わたしの弟子だというので、この小さい者たちのひとりに、水一杯でも飲ませるなら、まことに、あなたがたに告げます。その人は決して報いに漏れることはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","イエスはこのように十二弟子に注意を与え、それを終えられると、彼らの町々で教えたり宣べ伝えたりするため、そこを立ち去られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","さて、獄中でキリストのみわざについて聞いたヨハネは、その弟子たちに託して、 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","イエスにこう言い送った。「おいでになるはずの方は、あなたですか。それとも、私たちは別の方を待つべきでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","イエスは答えて、彼らに言われた。「あなたがたは行って、自分たちの聞いたり見たりしていることをヨハネに報告しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","盲人が見、足なえが歩き、らい病人がきよめられ、つんぼの人が聞こえ、死人が生き返り、貧しい者には福音が宣べ伝えられているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","だれでも、わたしにつまずかない者は幸いです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","この人たちが行ってしまうと、イエスは、ヨハネについて群衆に話しだされた。「あなたがたは、何を見に荒野に出て行ったのですか。風に揺れる葦ですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","でなかったら、何を見に行ったのですか。柔らかい着物を着た人ですか。柔らかい着物を着た人なら王の宮殿にいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","でなかったら、なぜ行ったのですか。預言者を見るためですか。そのとおり。だが、わたしが言いましょう。預言者よりもすぐれた者をです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","この人こそ、 『見よ、わたしは使いをあなたの前に遣わし、 あなたの道を、あなたの前に備えさせよう。』 と書かれているその人です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","まことに、あなたがたに告げます。女から生まれた者の中で、バプテスマのヨハネよりすぐれた人は出ませんでした。しかも、天の御国の一番小さい者でも、彼より偉大です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","バプテスマのヨハネの日以来今日まで、天の御国は激しく攻められています。そして、激しく攻める者たちがそれを奪い取っています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ヨハネに至るまで、すべての預言者たちと律法とが預言をしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","あなたがたが進んで受け入れるなら、実はこの人こそ、きたるべきエリヤなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","耳のある者は聞きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","この時代は何にたとえたらよいでしょう。市場にすわっている子どもたちのようです。彼らは、ほかの子どもたちに呼びかけて、 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","こう言うのです。 『笛を吹いてやっても、君たちは踊らなかった。 弔いの歌を歌ってやっても、悲しまなかった。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ヨハネが来て、食べも飲みもしないと、人々は『あれは悪霊につかれているのだ。』と言い、 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","人の子が来て食べたり飲んだりしていると、『あれ見よ。食いしんぼうの大酒飲み、取税人や罪人の仲間だ。』と言います。でも、知恵の正しいことは、その行ないが証明します。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","それから、イエスは、数々の力あるわざの行なわれた町々が悔い改めなかったので、責め始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","「ああコラジン。ああベツサイダ。おまえたちのうちで行なわれた力あるわざが、もしもツロとシドンで行なわれたのだったら、彼らはとうの昔に荒布をまとい、灰をかぶって悔い改めていたことだろう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","しかし、そのツロとシドンのほうが、おまえたちに言うが、さばきの日には、まだおまえたちよりは罰が軽いのだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","カペナウム。どうしておまえが天に上げられることがありえよう。ハデスに落とされるのだ。おまえの中でなされた力あるわざが、もしもソドムでなされたのだったら、ソドムはきょうまで残っていたことだろう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","しかし、そのソドムの地のほうが、おまえたちに言うが、さばきの日には、まだおまえよりは罰が軽いのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","そのとき、イエスはこう言われた。「天地の主であられる父よ。あなたをほめたたえます。これらのことを、賢い者や知恵のある者には隠して、幼子たちに現わしてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","そうです、父よ。これがみこころにかなったことでした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","すべてのものが、わたしの父から、わたしに渡されています。それで、父のほかには、子を知る者がなく、子と、子が父を知らせようと心に定めた人のほかは、だれも父を知る者がありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","すべて、疲れた人、重荷を負っている人は、わたしのところに来なさい。わたしがあなたがたを休ませてあげます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","わたしは心優しく、へりくだっているから、あなたがたもわたしのくびきを負って、わたしから学びなさい。そうすればたましいに安らぎが来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","わたしのくびきは負いやすく、わたしの荷は軽いからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","そのころ、イエスは、安息日に麦畑を通られた。弟子たちはひもじくなったので、穂を摘んで食べ始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","すると、パリサイ人たちがそれを見つけて、イエスに言った。「ご覧なさい。あなたの弟子たちが、安息日にしてはならないことをしています。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","しかし、イエスは言われた。「ダビデとその連れの者たちが、ひもじかったときに、ダビデが何をしたか、読まなかったのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","神の家にはいって、祭司のほかは自分も供の者たちも食べてはならない供えのパンを食べました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","また、安息日に宮にいる祭司たちは安息日の神聖を冒しても罪にならないということを、律法で読んだことはないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","あなたがたに言いますが、ここに宮より大きな者がいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","『わたしはあわれみは好むが、いけにえは好まない。』ということがどういう意味かを知っていたら、あなたがたは、罪のない者たちを罪に定めはしなかったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","人の子は安息日の主です。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","イエスはそこを去って、会堂にはいられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","そこに片手のなえた人がいた。そこで、彼らはイエスに質問して、「安息日にいやすことは正しいことでしょうか。」と言った。これはイエスを訴えるためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","イエスは彼らに言われた。「あなたがたのうち、だれかが一匹の羊を持っていて、もしその羊が安息日に穴に落ちたら、それを引き上げてやらないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","人間は羊より、はるかに値うちのあるものでしょう。それなら、安息日に良いことをすることは、正しいのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","それから、イエスはその人に、「手を伸ばしなさい。」と言われた。彼が手を伸ばすと、手は直って、もう一方の手と同じようになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","パリサイ人は出て行って、どのようにしてイエスを滅ぼそうかと相談した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","イエスはそれを知って、そこを立ち去られた。すると多くの人がついて来たので、彼らをみないやし、 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","そして、ご自分のことを人々に知らせないようにと、彼らを戒められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","これは、預言者イザヤを通して言われた事が成就するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","「これぞ、わたしの選んだわたしのしもべ、 わたしの心の喜ぶわたしの愛する者。 わたしは彼の上にわたしの霊を置き、 彼は異邦人にさばきを宣べる。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","争うこともなく、叫ぶこともせず、 大路でその声を聞く者もない。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","彼はいたんだ葦を折ることもなく、 くすぶる燈心を消すこともない、 正義を勝利に導くまでは。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","異邦人は彼の名に望みをかける。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","そのとき、悪霊につかれた、目も見えず、口もきけない人が連れて来られた。イエスが彼をいやされたので、そのおしはものを言い、目も見えるようになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","群衆はみな驚いて言った。「この人は、ダビデの子なのだろうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","これを聞いたパリサイ人は言った。「この人は、ただ悪霊どものかしらベルゼブルの力で、悪霊どもを追い出しているだけだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","イエスは彼らの思いを知ってこう言われた。「どんな国でも、内輪もめして争えば荒れすたれ、どんな町でも家でも、内輪もめして争えば立ち行きません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","もし、サタンがサタンを追い出していて仲間割れしたのだったら、どうしてその国は立ち行くでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","また、もしわたしがベルゼブルによって悪霊どもを追い出しているのなら、あなたがたの子らはだれによって追い出すのですか。だから、あなたがたの子らが、あなたがたをさばく人となるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","しかし、わたしが神の御霊によって悪霊どもを追い出しているのなら、もう神の国はあなたがたのところに来ているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","強い人の家にはいって家財を奪い取ろうとするなら、まずその人を縛ってしまわないで、どうしてそのようなことができましょうか。そのようにして初めて、その家を略奪することもできるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","わたしの味方でない者はわたしに逆らう者であり、わたしとともに集めない者は散らす者です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","だから、わたしはあなたがたに言います。人はどんな罪も冒涜も赦していただけます。しかし、聖霊に逆らう冒涜は赦されません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","また、人の子に逆らうことばを口にする者でも、赦されます。しかし、聖霊に逆らうことを言う者は、だれであっても、この世であろうと次に来る世であろうと、赦されません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","木が良ければ、その実も良いとし、木が悪ければその実も悪いとしなさい。木のよしあしはその実によって知られるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","まむしのすえたち。おまえたち悪い者に、どうして良いことが言えましょう。心に満ちていることを口が話すのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","良い人は、良い倉から良い物を取り出し、悪い人は、悪い倉から悪い物を取り出すものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","わたしはあなたがたに、こう言いましょう。人はその口にするあらゆるむだなことばについて、さばきの日には言い開きをしなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","あなたが正しいとされるのは、あなたのことばによるのであり、罪に定められるのも、あなたのことばによるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","そのとき、律法学者、パリサイ人たちのうちのある者がイエスに答えて言った。「先生。私たちは、あなたからしるしを見せていただきたいのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","しかし、イエスは答えて言われた。「悪い、姦淫の時代はしるしを求めています。だが預言者ヨナのしるしのほかには、しるしは与えられません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ヨナは三日三晩大魚の腹の中にいましたが、同様に、人の子も三日三晩、地の中にいるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ニネベの人々が、さばきのときに、今の時代の人々とともに立って、この人々を罪に定めます。なぜなら、ニネベの人々はヨナの説教で悔い改めたからです。しかし、見なさい。ここにヨナよりもまさった者がいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","南の女王が、さばきのときに、今の時代の人々とともに立って、この人々を罪に定めます。なぜなら、彼女はソロモンの知恵を聞くために地の果てから来たからです。しかし、見なさい。ここにソロモンよりもまさった者がいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","汚れた霊が人から出て行って、水のない地をさまよいながら休み場を捜しますが、見つかりません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","そこで、『出て来た自分の家に帰ろう。』と言って、帰って見ると、家はあいていて、掃除してきちんとかたづいていました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","そこで、出かけて行って、自分よりも悪いほかの霊を七つ連れて来て、みなはいり込んでそこに住みつくのです。そうなると、その人の後の状態は、初めよりもさらに悪くなります。邪悪なこの時代もまた、そういうことになるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","イエスがまだ群衆に話しておられるときに、イエスの母と兄弟たちが、イエスに何か話そうとして、外に立っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","すると、だれかが言った。「ご覧なさい。あなたのおかあさんと兄弟たちが、あなたに話そうとして外に立っています。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","しかし、イエスはそう言っている人に答えて言われた。「わたしの母とはだれですか。また、わたしの兄弟たちとはだれですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","それから、イエスは手を弟子たちのほうに差し伸べて言われた。「見なさい。わたしの母、わたしの兄弟たちです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","天におられるわたしの父のみこころを行なう者はだれでも、わたしの兄弟、姉妹、また母なのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","その日、イエスは家を出て、湖のほとりにすわっておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","すると、大ぜいの群衆がみもとに集まったので、イエスは舟に移って腰をおろされた。それで群衆はみな浜に立っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","イエスは多くのことを、彼らにたとえで話して聞かされた。 「種を蒔く人が種蒔きに出かけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","蒔いているとき、道ばたに落ちた種があった。すると鳥が来て食べてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","また、別の種が土の薄い岩地に落ちた。土が深くなかったので、すぐに芽を出した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","しかし、日が上ると、焼けて、根がないために枯れてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","また、別の種はいばらの中に落ちたが、いばらが伸びて、ふさいでしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","別の種は良い地に落ちて、あるものは百倍、あるものは六十倍、あるものは三十倍の実を結んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","耳のある者は聞きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","すると、弟子たちが近寄って来て、イエスに言った。「なぜ、彼らにたとえでお話しになったのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","イエスは答えて言われた。「あなたがたには、天の御国の奥義を知ることが許されているが、彼らには許されていません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","というのは、持っている者はさらに与えられて豊かになり、持たない者は持っているものまでも取り上げられてしまうからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","わたしが彼らにたとえで話すのは、彼らは見てはいるが見ず、聞いてはいるが聞かず、また、悟ることもしないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","こうしてイザヤの告げた預言が彼らの上に実現したのです。 『あなたがたは確かに聞きはするが、 決して悟らない。 確かに見てはいるが、決してわからない。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","この民の心は鈍くなり、 その耳は遠く、 目はつぶっているからである。 それは、彼らがその目で見、その耳で聞き、 その心で悟って立ち返り、 わたしにいやされることのないためである。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","しかし、あなたがたの目は見ているから幸いです。また、あなたがたの耳は聞いているから幸いです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","まことに、あなたがたに告げます。多くの預言者や義人たちが、あなたがたの見ているものを見たいと、切に願ったのに見られず、あなたがたの聞いていることを聞きたいと、切に願ったのに聞けなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ですから、種蒔きのたとえを聞きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","御国のことばを聞いても悟らないと、悪い者が来て、その人の心に蒔かれたものを奪って行きます。道ばたに蒔かれるとは、このような人のことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","また岩地に蒔かれるとは、みことばを聞くと、すぐに喜んで受け入れる人のことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","しかし、自分のうちに根がないため、しばらくの間そうするだけで、みことばのために困難や迫害が起こると、すぐにつまずいてしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","また、いばらの中に蒔かれるとは、みことばを聞くが、この世の心づかいと富の惑わしとがみことばをふさぐため、実を結ばない人のことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ところが、良い地に蒔かれるとは、みことばを聞いてそれを悟る人のことで、その人はほんとうに実を結び、あるものは百倍、あるものは六十倍、あるものは三十倍の実を結びます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","イエスは、また別のたとえを彼らに示して言われた。 「天の御国は、こういう人にたとえることができます。ある人が自分の畑に良い種を蒔いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ところが、人々の眠っている間に、彼の敵が来て麦の中に毒麦を蒔いて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","麦が芽ばえ、やがて実ったとき、毒麦も現われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","それで、その家の主人のしもべたちが来て言った。『ご主人。畑には良い麦を蒔かれたのではありませんか。どうして毒麦が出たのでしょう。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","主人は言った。『敵のやったことです。』すると、しもべたちは言った。『では、私たちが行ってそれを抜き集めましょうか。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","だが、主人は言った。『いやいや。毒麦を抜き集めるうちに、麦もいっしょに抜き取るかもしれない。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","だから、収穫まで、両方とも育つままにしておきなさい。収穫の時期になったら、私は刈る人たちに、まず、毒麦を集め、焼くために束にしなさい。麦のほうは、集めて私の倉に納めなさい、と言いましょう。』」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","イエスは、また別のたとえを彼らに示して言われた。「天の御国は、からし種のようなものです。それを取って、畑に蒔くと、 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","どんな種よりも小さいのですが、生長すると、どの野菜よりも大きくなり、空の鳥が来て、その枝に巣を作るほどの木になります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","イエスは、また別のたとえを話された。「天の御国は、パン種のようなものです。女が、パン種を取って、三サトンの粉の中に入れると、全体がふくらんで来ます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","イエスは、これらのことをみな、たとえで群衆に話され、たとえを使わずには何もお話しにならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","それは、預言者を通して言われた事が成就するためであった。 「わたしはたとえ話をもって口を開き、 世の初めから隠されていることどもを物語ろう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","それから、イエスは群衆と別れて家にはいられた。すると、弟子たちがみもとに来て、「畑の毒麦のたとえを説明してください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","イエスは答えてこう言われた。「良い種を蒔く者は人の子です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","畑はこの世界のことで、良い種とは御国の子どもたち、毒麦とは悪い者の子どもたちのことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","毒麦を蒔いた敵は悪魔であり、収穫とはこの世の終わりのことです。そして、刈り手とは御使いたちのことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ですから、毒麦が集められて火で焼かれるように、この世の終わりにもそのようになります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","人の子はその御使いたちを遣わします。彼らは、つまずきを与える者や不法を行なう者たちをみな、御国から取り集めて、 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","火の燃える炉に投げ込みます。彼らはそこで泣いて歯ぎしりするのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","そのとき、正しい者たちは、天の父の御国で太陽のように輝きます。耳のある者は聞きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","天の御国は、畑に隠された宝のようなものです。人はその宝を見つけると、それを隠しておいて、大喜びで帰り、持ち物を全部売り払ってその畑を買います。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","また、天の御国は、良い真珠を捜している商人のようなものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","すばらしい値うちの真珠を一つ見つけた者は、行って持ち物を全部売り払ってそれを買ってしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","また、天の御国は、海におろしてあらゆる種類の魚を集める地引き網のようなものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","網がいっぱいになると岸に引き上げ、すわり込んで、良いものは器に入れ、悪いものは捨てるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","この世の終わりにもそのようになります。御使いたちが来て、正しい者の中から悪い者をえり分け、 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","火の燃える炉に投げ込みます。彼らはそこで泣いて歯ぎしりするのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","あなたがたは、これらのことがみなわかりましたか。」彼らは「はい。」とイエスに言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","そこで、イエスは言われた。「だから、天の御国の弟子となった学者はみな、自分の倉から新しい物でも古い物でも取り出す一家の主人のようなものです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","これらのたとえを話し終えると、イエスはそこを去られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","それから、ご自分の郷里に行って、会堂で人々を教え始められた。すると、彼らは驚いて言った。「この人は、こんな知恵と不思議な力をどこで得たのでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","この人は大工の息子ではありませんか。彼の母親はマリヤで、彼の兄弟は、ヤコブ、ヨセフ、シモン、ユダではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","妹たちもみな私たちといっしょにいるではありませんか。とすると、いったいこの人は、これらのものをどこから得たのでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","こうして、彼らはイエスにつまずいた。しかし、イエスは彼らに言われた。「預言者が尊敬されないのは、自分の郷里、家族の間だけです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","そして、イエスは、彼らの不信仰のゆえに、そこでは多くの奇蹟をなさらなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","そのころ、国主ヘロデは、イエスのうわさを聞いて、 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","侍従たちに言った。「あれはバプテスマのヨハネだ。ヨハネが死人の中からよみがえったのだ。だから、あんな力が彼のうちに働いているのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","実は、このヘロデは、自分の兄弟ピリポの妻ヘロデヤのことで、ヨハネを捕えて縛り、牢に入れたのであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","それは、ヨハネが彼に、「あなたが彼女をめとるのは不法です。」と言い張ったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ヘロデはヨハネを殺したかったが、群衆を恐れた。というのは、彼らはヨハネを預言者と認めていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","たまたまヘロデの誕生祝いがあって、ヘロデヤの娘がみなの前で踊りを踊ってヘロデを喜ばせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","それで、彼は、その娘に、願う物は何でも必ず上げると、誓って堅い約束をした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ところが、娘は母親にそそのかされて、こう言った。「今ここに、バプテスマのヨハネの首を盆に載せて私に下さい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","王は心を痛めたが、自分の誓いもあり、また列席の人々の手前もあって、与えるように命令した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","彼は人をやって、牢の中でヨハネの首をはねさせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","そして、その首は盆に載せて運ばれ、少女に与えられたので、少女はそれを母親のところに持って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","それから、ヨハネの弟子たちがやって来て、死体を引き取って葬った。そして、イエスのところに行って報告した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","イエスはこのことを聞かれると、舟でそこを去り、自分だけで寂しい所に行かれた。すると、群衆がそれと聞いて、町々から、歩いてイエスのあとを追った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","イエスは舟から上がられると、多くの群衆を見られ、彼らを深くあわれんで、彼らの病気を直された。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","夕方になったので、弟子たちはイエスのところに来て言った。「ここは寂しい所ですし、時刻ももう回っています。ですから群衆を解散させてください。そして村に行ってめいめいで食物を買うようにさせてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","しかし、イエスは言われた。「彼らが出かけて行く必要はありません。あなたがたで、あの人たちに何か食べる物を上げなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","しかし、弟子たちはイエスに言った。「ここには、パンが五つと魚が二匹よりほかありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","すると、イエスは言われた。「それを、ここに持って来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","そしてイエスは、群衆に命じて草の上にすわらせ、五つのパンと二匹の魚を取り、天を見上げて、それらを祝福し、パンを裂いてそれを弟子たちに与えられたので、弟子たちは群衆に配った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","人々はみな、食べて満腹した。そして、パン切れの余りを取り集めると、十二のかごにいっぱいあった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","食べた者は、女と子どもを除いて、男五千人ほどであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","それからすぐ、イエスは弟子たちを強いて舟に乗り込ませて、自分より先に向こう岸へ行かせ、その間に群衆を帰してしまわれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","群衆を帰したあとで、祈るために、ひとりで山に登られた。夕方になったが、まだそこに、ひとりでおられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","しかし、舟は、陸からもう何キロメートルも離れていたが、風が向かい風なので、波に悩まされていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","すると、夜中の三時ごろ、イエスは湖の上を歩いて、彼らのところに行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","弟子たちは、イエスが湖の上を歩いておられるのを見て、「あれは幽霊だ。」と言って、おびえてしまい、恐ろしさのあまり、叫び声を上げた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","しかし、イエスはすぐに彼らに話しかけ、「しっかりしなさい。わたしだ。恐れることはない。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","すると、ペテロが答えて言った。「主よ。もし、あなたでしたら、私に、水の上を歩いてここまで来い、とお命じになってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","イエスは「来なさい。」と言われた。そこで、ペテロは舟から出て、水の上を歩いてイエスのほうに行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ところが、風を見て、こわくなり、沈みかけたので叫び出し、「主よ。助けてください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","そこで、イエスはすぐに手を伸ばして、彼をつかんで言われた。「信仰の薄い人だな。なぜ疑うのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","そして、ふたりが舟に乗り移ると、風がやんだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","そこで、舟の中にいた者たちは、イエスを拝んで、「確かにあなたは神の子です。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","彼らは湖を渡ってゲネサレの地に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","すると、その地の人々は、イエスと気がついて、付近の地域にくまなく知らせ、病人という病人をみな、みもとに連れて来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","そして、せめて彼らに、着物のふさにでもさわらせてやってくださいと、イエスにお願いした。そして、さわった人々はみな、いやされた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","そのころ、パリサイ人や律法学者たちが、エルサレムからイエスのところに来て、言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","「あなたの弟子たちは、なぜ昔の先祖たちの言い伝えを犯すのですか。パンを食べるときに手を洗っていないではありませんか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","そこで、イエスは彼らに答えて言われた。「なぜ、あなたがたも、自分たちの言い伝えのために神の戒めを犯すのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","神は『あなたの父と母を敬え。』また『父や母をののしる者は、死刑に処せられる。』と言われたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","それなのに、あなたがたは、『だれでも、父や母に向かって、私からあなたのために差し上げられる物は、供え物になりましたと言う者は、 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","その物をもって父や母を尊んではならない。』と言っています。こうしてあなたがたは、自分たちの言い伝えのために、神のことばを無にしてしまいました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","偽善者たち。イザヤはあなたがたについて預言しているが、まさにそのとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","『この民は、口先ではわたしを敬うが、 その心は、わたしから遠く離れている。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","彼らが、わたしを拝んでも、むだなことである。 人間の教えを、教えとして教えるだけだから。』」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","イエスは群衆を呼び寄せて言われた。「聞いて悟りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","口にはいる物は人を汚しません。しかし、口から出るもの、これが人を汚します。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","そのとき、弟子たちが、近寄って来て、イエスに言った。「パリサイ人が、みことばを聞いて、腹を立てたのをご存じですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","しかし、イエスは答えて言われた。「わたしの天の父がお植えにならなかった木は、みな根こそぎにされます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","彼らのことは放っておきなさい。彼らは盲人を手引きする盲人です。もし、盲人が盲人を手引きするなら、ふたりとも穴に落ち込むのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","そこで、ペテロは、イエスに答えて言った。「私たちに、そのたとえを説明してください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","イエスは言われた。「あなたがたも、まだわからないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","口にはいる物はみな、腹にはいり、かわやに捨てられることを知らないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","しかし、口から出るものは、心から出て来ます。それは人を汚します。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","悪い考え、殺人、姦淫、不品行、盗み、偽証、ののしりは心から出て来るからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","これらは、人を汚すものです。しかし、洗わない手で食べることは人を汚しません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","それから、イエスはそこを去って、ツロとシドンの地方に立ちのかれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","すると、その地方のカナン人の女が出て来て、叫び声をあげて言った。「主よ。ダビデの子よ。私をあわれんでください。娘が、ひどく悪霊に取りつかれているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","しかし、イエスは彼女に一言もお答えにならなかった。そこで、弟子たちはみもとに来て、「あの女を帰してやってください。叫びながらあとについて来るのです。」と言ってイエスに願った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","しかし、イエスは答えて、「わたしは、イスラエルの家の滅びた羊以外のところには遣わされていません。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","しかし、その女は来て、イエスの前にひれ伏して、「主よ。私をお助けください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","すると、イエスは答えて、「子どもたちのパンを取り上げて、小犬に投げてやるのはよくないことです。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","しかし、女は言った。「主よ。そのとおりです。ただ、小犬でも主人の食卓から落ちるパンくずはいただきます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","そのとき、イエスは彼女に答えて言われた。「ああ、あなたの信仰はりっぱです。その願いどおりになるように。」すると、彼女の娘はその時から直った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","それから、イエスはそこを去って、ガリラヤ湖の岸を行き、山に登って、そこにすわっておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","すると、大ぜいの人の群れが、足なえ、不具者、盲人、おしの人、そのほかたくさんの人をみもとに連れて来た。そして、彼らをイエスの足もとに置いたので、イエスは彼らをおいやしになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","それで、群衆は、おしがものを言い、不具者が直り、足なえが歩き、盲人が見えるようになったのを見て、驚いた。そして、彼らはイスラエルの神をあがめた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","イエスは弟子たちを呼び寄せて言われた。「かわいそうに、この群衆はもう三日間もわたしといっしょにいて、食べる物を持っていないのです。彼らを空腹のままで帰らせたくありません。途中で動けなくなるといけないから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","そこで弟子たちは言った。「このへんぴな所で、こんなに大ぜいの人に、十分食べさせるほどたくさんのパンが、どこから手にはいるでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","すると、イエスは彼らに言われた。「どれぐらいパンがありますか。」彼らは言った。「七つです。それに、小さい魚が少しあります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","すると、イエスは群衆に、地面にすわるように命じられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","それから、七つのパンと魚とを取り、感謝をささげてからそれを裂き、弟子たちに与えられた。そして、弟子たちは群衆に配った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","人々はみな、食べて満腹した。そして、パン切れの余りを取り集めると、七つのかごにいっぱいあった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","食べた者は、女と子どもを除いて、男四千人であった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","それから、イエスは群衆を解散させて舟に乗り、マガダン地方に行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","パリサイ人やサドカイ人たちがみそばに寄って来て、イエスをためそうとして、天からのしるしを見せてくださいと頼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","しかし、イエスは彼らに答えて言われた。「あなたがたは、夕方には、『夕焼けだから晴れる。』と言うし、 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","朝には、『朝焼けでどんよりしているから、きょうは荒れ模様だ。』と言う。そんなによく、空模様の見分け方を知っていながら、なぜ時のしるしを見分けることができないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","悪い、姦淫の時代はしるしを求めています。しかし、ヨナのしるしのほかには、しるしは与えられません。」そう言って、イエスは彼らを残して去って行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","弟子たちは向こう岸に行ったが、パンを持って来るのを忘れた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","イエスは彼らに言われた。「パリサイ人やサドカイ人たちのパン種には注意して気をつけなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","すると、彼らは、「これは私たちがパンを持って来なかったからだ。」と言って、議論を始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","イエスはそれに気づいて言われた。「あなたがた、信仰の薄い人たち。パンがないからだなどと、なぜ論じ合っているのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","まだわからないのですか、覚えていないのですか。五つのパンを五千人に分けてあげて、なお幾かご集めましたか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","また、七つのパンを四千人に分けてあげて、なお幾かご集めましたか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","わたしの言ったのは、パンのことなどではないことが、どうしてあなたがたには、わからないのですか。ただ、パリサイ人やサドカイ人たちのパン種に気をつけることです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","彼らはようやく、イエスが気をつけよと言われたのは、パン種のことではなくて、パリサイ人やサドカイ人たちの教えのことであることを悟った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","さて、ピリポ・カイザリヤの地方に行かれたとき、イエスは弟子たちに尋ねて言われた。「人々は人の子をだれだと言っていますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","彼らは言った。「バプテスマのヨハネだと言う人もあり、エリヤだと言う人もあります。またほかの人たちはエレミヤだとか、また預言者のひとりだとも言っています。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","イエスは彼らに言われた。「あなたがたは、わたしをだれだと言いますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","シモン・ペテロが答えて言った。「あなたは、生ける神の御子キリストです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","するとイエスは、彼に答えて言われた。「バルヨナ・シモン。あなたは幸いです。このことをあなたに明らかに示したのは人間ではなく、天にいますわたしの父です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ではわたしもあなたに言います。あなたはペテロです。わたしはこの岩の上にわたしの教会を建てます。ハデスの門もそれには打ち勝てません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","わたしは、あなたに天の御国のかぎを上げます。何でもあなたが地上でつなぐなら、それは天においてもつながれており、あなたが地上で解くなら、それは天においても解かれています。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","そのとき、イエスは、ご自分がキリストであることをだれにも言ってはならない、と弟子たちを戒められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","その時から、イエス・キリストは、ご自分がエルサレムに行って、長老、祭司長、律法学者たちから多くの苦しみを受け、殺され、そして三日目によみがえらなければならないことを弟子たちに示し始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","するとペテロは、イエスを引き寄せて、いさめ始めた。「主よ。神の御恵みがありますように。そんなことが、あなたに起こるはずはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","しかし、イエスは振り向いて、ペテロに言われた。「下がれ。サタン。あなたはわたしの邪魔をするものだ。あなたは神のことを思わないで、人のことを思っている。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","それから、イエスは弟子たちに言われた。「だれでもわたしについて来たいと思うなら、自分を捨て、自分の十字架を負い、そしてわたしについて来なさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","いのちを救おうと思う者はそれを失い、わたしのためにいのちを失う者は、それを見いだすのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","人は、たとい全世界を手に入れても、まことのいのちを損じたら、何の得がありましょう。そのいのちを買い戻すのには、人はいったい何を差し出せばよいでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","人の子は父の栄光を帯びて、御使いたちとともに、やがて来ようとしているのです。その時には、おのおのその行ないに応じて報いをします。 ");
INSERT INTO jpn1965_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","まことに、あなたがたに告げます。ここに立っている人々の中には、人の子が御国とともに来るのを見るまでは、決して死を味わわない人々がいます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","それから六日たって、イエスは、ペテロとヤコブとその兄弟ヨハネだけを連れて、高い山に導いて行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","そして彼らの目の前で、御姿が変わり、御顔は太陽のように輝き、御衣は光のように白くなった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","しかも、モーセとエリヤが現われてイエスと話し合っているではないか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","すると、ペテロが口出ししてイエスに言った。「先生。私たちがここにいることは、すばらしいことです。もし、およろしければ、私が、ここに三つの幕屋を造ります。あなたのために一つ、モーセのために一つ、エリヤのために一つ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","彼がまだ話している間に、見よ、光り輝く雲がその人々を包み、そして、雲の中から、「これは、わたしの愛する子、わたしはこれを喜ぶ。彼の言うことを聞きなさい。」という声がした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","弟子たちは、この声を聞くと、ひれ伏して非常にこわがった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","すると、イエスが来られて、彼らに手を触れ、「起きなさい。こわがることはない。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","それで、彼らが目を上げて見ると、だれもいなくて、ただイエスおひとりだけであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","彼らが山を降りるとき、イエスは彼らに、「人の子が死人の中からよみがえるときまでは、いま見た幻をだれにも話してはならない。」と命じられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","そこで、弟子たちは、イエスに尋ねて言った。「すると、律法学者たちが、まずエリヤが来るはずだと言っているのは、どうしてでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","イエスは答えて言われた。「エリヤが来て、すべてのことを立て直すのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","しかし、わたしは言います。エリヤはもうすでに来たのです。ところが彼らはエリヤを認めようとせず、彼に対して好き勝手なことをしたのです。人の子もまた、彼らから同じように苦しめられようとしています。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","そのとき、弟子たちは、イエスがバプテスマのヨハネのことを言われたのだと気づいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","彼らが群衆のところに来たとき、ひとりの人がイエスのそば近くに来て、御前にひざまずいて言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","「主よ。私の息子をあわれんでください。てんかんで、たいへん苦しんでおります。何度も何度も火の中に落ちたり、水の中に落ちたりいたします。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","そこで、その子をお弟子たちのところに連れて来たのですが、直すことができませんでした。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","イエスは答えて言われた。「ああ、不信仰な、曲がった今の世だ。いつまであなたがたといっしょにいなければならないのでしょう。いつまであなたがたにがまんしていなければならないのでしょう。その子をわたしのところに連れて来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","そして、イエスがその子をおしかりになると、悪霊は彼から出て行き、その子はその時から直った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","そのとき、弟子たちはそっとイエスのもとに来て、言った。「なぜ、私たちには悪霊を追い出せなかったのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","イエスは言われた。「あなたがたの信仰が薄いからです。まことに、あなたがたに告げます。もし、からし種ほどの信仰があったら、この山に、『ここからあそこに移れ。』と言えば移るのです。どんなことでも、あなたがたにできないことはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","［ただし、この種のものは、祈りと断食によらなければ出て行きません。］」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","彼らがガリラヤに集まっていたとき、イエスは彼らに言われた。「人の子は、いまに人々の手に渡されます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","そして彼らに殺されるが、三日目によみがえります。」すると、彼らは非常に悲しんだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","また、彼らがカペナウムに来たとき、宮の納入金を集める人たちが、ペテロのところに来て言った。「あなたがたの先生は、宮の納入金を納めないのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","彼は「納めます。」と言って、家にはいると、先にイエスのほうからこう言い出された。「シモン。どう思いますか。世の王たちはだれから税や貢を取り立てますか。自分の子どもたちからですか、それともほかの人たちからですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ペテロが「ほかの人たちからです。」と言うと、イエスは言われた。「では、子どもたちにはその義務がないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","しかし、彼らにつまずきを与えないために、湖に行って釣りをして、最初に釣れた魚を取りなさい。その口をあけるとスタテル一枚が見つかるから、それを取って、わたしとあなたとの分として納めなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","そのとき、弟子たちがイエスのところに来て言った。「それでは、天の御国では、だれが一番偉いのでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","そこで、イエスは小さい子どもを呼び寄せ、彼らの真中に立たせて、 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","言われた。「まことに、あなたがたに告げます。あなたがたも悔い改めて子どもたちのようにならない限り、決して天の御国には、はいれません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","だから、この子どものように、自分を低くする者が、天の御国で一番偉い人です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","また、だれでも、このような子どものひとりを、わたしの名のゆえに受け入れる者は、わたしを受け入れるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","しかし、わたしを信じるこの小さい者たちのひとりにでもつまずきを与えるような者は、大きい石臼を首にかけられて、湖の深みでおぼれ死んだほうがましです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","つまずきを与えるこの世は忌まわしいものです。つまずきが起こることは避けられないが、つまずきをもたらす者は忌まわしいものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","もし、あなたの手か足の一つがあなたをつまずかせるなら、それを切って捨てなさい。片手片足でいのちにはいるほうが、両手両足そろっていて永遠の火に投げ入れられるよりは、あなたにとってよいことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","また、もし、あなたの一方の目が、あなたをつまずかせるなら、それをえぐり出して捨てなさい。片目でいのちにはいるほうが、両目そろっていて燃えるゲヘナに投げ入れられるよりは、あなたにとってよいことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","あなたがたは、この小さい者たちを、ひとりでも見下げたりしないように気をつけなさい。まことに、あなたがたに告げます。彼らの天の御使いたちは、天におられるわたしの父の御顔をいつも見ているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","［人の子は、滅んでいる者を救うために来たのです。］ ");
INSERT INTO jpn1965_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","あなたがたはどう思いますか。もし、だれかが百匹の羊を持っていて、そのうちの一匹が迷い出たとしたら、その人は九十九匹を山に残して、迷った一匹を捜しに出かけないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","そして、もし、いたとなれば、まことに、あなたがたに告げます。その人は迷わなかった九十九匹の羊以上にこの一匹を喜ぶのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","このように、この小さい者たちのひとりが滅びることは、天にいますあなたがたの父のみこころではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","また、もし、あなたの兄弟が罪を犯したなら、行って、ふたりだけのところで責めなさい。もし聞き入れたら、あなたは兄弟を得たのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","もし聞き入れないなら、ほかにひとりかふたりをいっしょに連れて行きなさい。ふたりか三人の証人の口によって、すべての事実が確認されるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","それでもなお、言うことを聞き入れようとしないなら、教会に告げなさい。教会の言うことさえも聞こうとしないなら、彼を異邦人か取税人のように扱いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","まことに、あなたがたに告げます。何でもあなたがたが地上でつなぐなら、それは天においてもつながれており、あなたがたが地上で解くなら、それは天においても解かれているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","まことに、あなたがたにもう一度、告げます。もし、あなたがたのうちふたりが、どんな事でも、地上で心を一つにして祈るなら、天におられるわたしの父は、それをかなえてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ふたりでも三人でも、わたしの名において集まる所には、わたしもその中にいるからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","そのとき、ペテロがみもとに来て言った。「主よ。兄弟が私に対して罪を犯したばあい、何度まで赦すべきでしょうか。七度まででしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","イエスは言われた。「七度まで、などとはわたしは言いません。七度を七十倍するまでと言います。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","このことから、天の御国は、地上の王にたとえることができます。 王はそのしもべたちと清算をしたいと思った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","清算が始まると、まず一万タラントの借りのあるしもべが、王のところに連れて来られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","しかし、彼は返済することができなかったので、その主人は彼に、自分も妻子も持ち物全部も売って返済するように命じた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","それで、このしもべは、主人の前にひれ伏して、『どうかご猶予ください。そうすれば全部お払いいたします。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","しもべの主人は、かわいそうに思って、彼を赦し、借金を免除してやった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ところが、そのしもべは、出て行くと、同じしもべ仲間で、彼から百デナリの借りのある者に出会った。彼はその人をつかまえ、首を絞めて、『借金を返せ。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","彼の仲間は、ひれ伏して、『もう少し待ってくれ。そうしたら返すから。』と言って頼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","しかし彼は承知せず、連れて行って、借金を返すまで牢に投げ入れた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","彼の仲間たちは事の成り行きを見て、非常に悲しみ、行って、その一部始終を主人に話した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","そこで、主人は彼を呼びつけて言った。『悪いやつだ。おまえがあんなに頼んだからこそ借金全部を赦してやったのだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","私がおまえをあわれんでやったように、おまえも仲間をあわれんでやるべきではないか。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","こうして、主人は怒って、借金を全部返すまで、彼を獄吏に引き渡した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","あなたがたもそれぞれ、心から兄弟を赦さないなら、天のわたしの父も、あなたがたに、このようになさるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","イエスはこの話を終えると、ガリラヤを去って、ヨルダンの向こうにあるユダヤ地方に行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","すると、大ぜいの群衆がついて来たので、そこで彼らをおいやしになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","パリサイ人たちがみもとにやって来て、イエスを試みて、こう言った。「何か理由があれば、妻を離別することは律法にかなっているでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","イエスは答えて言われた。「創造者は、初めから人を男と女に造って、 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","『それゆえ、人はその父と母を離れて、その妻と結ばれ、ふたりの者が一心同体になるのだ。』と言われたのです。それを、あなたがたは読んだことがないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","それで、もはやふたりではなく、ひとりなのです。こういうわけで、人は、神が結び合わせたものを引き離してはなりません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","彼らはイエスに言った。「では、モーセはなぜ、離婚状を渡して妻を離別せよ、と命じたのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","イエスは彼らに言われた。「モーセは、あなたがたの心がかたくななので、その妻を離別することをあなたがたに許したのです。しかし、初めからそうだったのではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","まことに、あなたがたに告げます。だれでも、不貞のためでなくて、その妻を離別し、別の女を妻にする者は姦淫を犯すのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","弟子たちはイエスに言った。「もし妻に対する夫の立場がそんなものなら、結婚しないほうがましです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","しかし、イエスは言われた。「そのことばは、だれでも受け入れることができるわけではありません。ただ、それが許されている者だけができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","というのは、母の胎内から、そのように生まれついた独身者がいます。また、人から独身者にさせられた者もいます。また、天の御国のために、自分から独身者になった者もいるからです。それができる者はそれを受け入れなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","そのとき、イエスに手を置いて祈っていただくために、子どもたちが連れて来られた。ところが、弟子たちは彼らをしかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","しかし、イエスは言われた。「子どもたちを許してやりなさい。邪魔をしないでわたしのところに来させなさい。天の御国はこのような者たちの国なのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","そして、手を彼らの上に置いてから、そこを去って行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","すると、ひとりの人がイエスのもとに来て言った。「先生。永遠のいのちを得るためには、どんな良いことをしたらよいのでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","イエスは彼に言われた。「なぜ、良いことについて、わたしに尋ねるのですか。良い方は、ひとりだけです。もし、いのちにはいりたいと思うなら、戒めを守りなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","彼は「どの戒めですか。」と言った。そこで、イエスは言われた。「殺してはならない。姦淫してはならない。盗んではならない。偽証をしてはならない。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","父と母を敬え。あなたの隣人をあなた自身のように愛せよ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","この青年はイエスに言った。「そのようなことはみな、守っております。何がまだ欠けているのでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","イエスは、彼に言われた。「もし、あなたが完全になりたいなら、帰って、あなたの持ち物を売り払って貧しい人たちに与えなさい。そうすれば、あなたは天に宝を積むことになります。そのうえで、わたしについて来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ところが、青年はこのことばを聞くと、悲しんで去って行った。この人は多くの財産を持っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","それから、イエスは弟子たちに言われた。「まことに、あなたがたに告げます。金持ちが天の御国にはいるのはむずかしいことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","まことに、あなたがたにもう一度、告げます。金持ちが神の国にはいるよりは、らくだが針の穴を通るほうがもっとやさしい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","弟子たちは、これを聞くと、たいへん驚いて言った。「それでは、だれが救われることができるのでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","イエスは彼らをじっと見て言われた。「それは人にはできないことです。しかし、神にはどんなことでもできます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","そのとき、ペテロはイエスに答えて言った。「ご覧ください。私たちは、何もかも捨てて、あなたに従ってまいりました。私たちは何がいただけるでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","そこで、イエスは彼らに言われた。「まことに、あなたがたに告げます。世が改まって人の子がその栄光の座に着く時、わたしに従って来たあなたがたも十二の座に着いて、イスラエルの十二の部族をさばくのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","また、わたしの名のために、家、兄弟、姉妹、父、母、子、あるいは畑を捨てた者はすべて、その幾倍もを受け、また永遠のいのちを受け継ぎます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ただ、先の者があとになり、あとの者が先になることが多いのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","天の御国は、自分のぶどう園で働く労務者を雇いに朝早く出かけた主人のようなものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","彼は、労務者たちと一日一デナリの約束ができると、彼らをぶどう園にやった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","それから、九時ごろに出かけてみると、別の人たちが市場に立っており、何もしないでいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","そこで、彼はその人たちに言った。『あなたがたも、ぶどう園に行きなさい。相当のものを上げるから。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","彼らは出て行った。それからまた、十二時ごろと三時ごろに出かけて行って、同じようにした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","また、五時ごろ出かけてみると、別の人たちが立っていたので、彼らに言った。『なぜ、一日中仕事もしないでここにいるのですか。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","彼らは言った。『だれも雇ってくれないからです。』彼は言った。『あなたがたも、ぶどう園に行きなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","こうして、夕方になったので、ぶどう園の主人は、監督に言った。『労務者たちを呼んで、最後に来た者たちから順に、最初に来た者たちにまで、賃金を払ってやりなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","そこで、五時ごろに雇われた者たちが来て、それぞれ一デナリずつもらった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","最初の者たちがもらいに来て、もっと多くもらえるだろうと思ったが、彼らもやはりひとり一デナリずつであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","そこで、彼らはそれを受け取ると、主人に文句をつけて、 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","言った。『この最後の連中は一時間しか働かなかったのに、あなたは私たちと同じにしました。私たちは一日中、労苦と焼けるような暑さを辛抱したのです。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","しかし、彼はそのひとりに答えて言った。『私はあなたに何も不当なことはしていない。あなたは私と一デナリの約束をしたではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","自分の分を取って帰りなさい。ただ私としては、この最後の人にも、あなたと同じだけ上げたいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","自分のものを自分の思うようにしてはいけないという法がありますか。それとも、私が気前がいいので、あなたの目にはねたましく思われるのですか。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","このように、あとの者が先になり、先の者があとになるものです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","さて、イエスは、エルサレムに上ろうとしておられたが、十二弟子だけを呼んで、道々彼らに話された。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","「さあ、これから、わたしたちはエルサレムに向かって行きます。人の子は、祭司長、律法学者たちに引き渡されるのです。彼らは人の子を死刑に定めます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","そして、あざけり、むち打ち、十字架につけるため、異邦人に引き渡します。しかし、人の子は三日目によみがえります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","そのとき、ゼベダイの子たちの母が、子どもたちといっしょにイエスのもとに来て、ひれ伏して、お願いがありますと言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","イエスが彼女に、「どんな願いですか。」と言われると、彼女は言った。「私のこのふたりの息子が、あなたの御国で、ひとりはあなたの右に、ひとりは左にすわれるようにおことばを下さい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","けれども、イエスは答えて言われた。「あなたがたは自分が何を求めているのか、わかっていないのです。わたしが飲もうとしている杯を飲むことができますか。」彼らは「できます。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","イエスは言われた。「あなたがたはわたしの杯を飲みはします。しかし、わたしの右と左にすわることは、このわたしの許すことではなく、わたしの父によってそれに備えられた人々があるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","このことを聞いたほかの十人は、このふたりの兄弟のことで腹を立てた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","そこで、イエスは彼らを呼び寄せて、言われた。「あなたがたも知っているとおり、異邦人の支配者たちは彼らを支配し、偉い人たちは彼らの上に権力をふるいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","あなたがたの間では、そうではありません。あなたがたの間で偉くなりたいと思う者は、みなに仕える者になりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","あなたがたの間で人の先に立ちたいと思う者は、あなたがたのしもべになりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","人の子が来たのが、仕えられるためではなく、かえって仕えるためであり、また、多くの人のための、贖いの代価として、自分のいのちを与えるためであるのと同じです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","彼らがエリコを出て行くと、大ぜいの群衆がイエスについて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","すると、道ばたにすわっていたふたりの盲人が、イエスが通られると聞いて、叫んで言った。「主よ。私たちをあわれんでください。ダビデの子よ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","そこで、群衆は彼らを黙らせようとして、たしなめたが、彼らはますます、「主よ。私たちをあわれんでください。ダビデの子よ。」と叫び立てた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","すると、イエスは立ち止まって、彼らを呼んで言われた。「わたしに何をしてほしいのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","彼らはイエスに言った。「主よ。この目をあけていただきたいのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","イエスはかわいそうに思って、彼らの目にさわられた。すると、すぐさま彼らは見えるようになり、イエスについて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","それから、彼らはエルサレムに近づき、オリーブ山のふもとのベテパゲまで来た。そのとき、イエスは、弟子をふたり使いに出して、 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","言われた。「向こうの村へ行きなさい。そうするとすぐに、ろばがつながれていて、いっしょにろばの子がいるのに気がつくでしょう。それをほどいて、わたしのところに連れて来なさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","もしだれかが何か言ったら、『主がお入用なのです。』と言いなさい。そうすれば、すぐに渡してくれます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","これは、預言者を通して言われた事が成就するために起こったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","「シオンの娘に伝えなさい。 『見よ。あなたの王が、 あなたのところにお見えになる。 柔和で、ろばの背に乗って、 それも、荷物を運ぶろばの子に乗って。』」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","そこで、弟子たちは行って、イエスが命じられたとおりにした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","そして、ろばと、ろばの子とを連れて来て、自分たちの上着をその上に掛けた。イエスはそれに乗られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","すると、群衆のうち大ぜいの者が、自分たちの上着を道に敷き、また、ほかの人々は、木の枝を切って来て、道に敷いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","そして、群衆は、イエスの前を行く者も、あとに従う者も、こう言って叫んでいた。 「ダビデの子にホサナ。 祝福あれ。主の御名によって来られる方に。 ホサナ。いと高き所に。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","こうして、イエスがエルサレムにはいられると、都中がこぞって騒ぎ立ち、「この方は、どういう方なのか。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","群衆は、「この方は、ガリラヤのナザレの、預言者イエスだ。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","それから、イエスは宮にはいって、宮の中で売り買いする者たちをみな追い出し、両替人の台や、鳩を売る者たちの腰掛けを倒された。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","そして彼らに言われた。「『わたしの家は祈りの家と呼ばれる。』と書いてある。それなのに、あなたがたはそれを強盗の巣にしている。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","また、宮の中で、盲人や足なえがみもとに来たので、イエスは彼らをいやされた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ところが、祭司長、律法学者たちは、イエスのなさった驚くべきいろいろのことを見、また宮の中で子どもたちが「ダビデの子にホサナ。」と言って叫んでいるのを見て腹を立てた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","そしてイエスに言った。「あなたは、子どもたちが何と言っているか、お聞きですか。」イエスは言われた。「聞いています。『あなたは幼子と乳飲み子たちの口に賛美を用意された。』とあるのを、あなたがたは読まなかったのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","イエスは彼らをあとに残し、都を出てベタニヤに行き、そこに泊まられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","翌朝、イエスは都に帰る途中、空腹を覚えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","道ばたにいちじくの木が見えたので、近づいて行かれたが、葉のほかは何もないのに気づかれた。それで、イエスはその木に「おまえの実は、もういつまでも、ならないように。」と言われた。すると、たちまちいちじくの木は枯れた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","弟子たちは、これを見て、驚いて言った。「どうして、こうすぐにいちじくの木が枯れたのでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","イエスは答えて言われた。「まことに、あなたがたに告げます。もし、あなたがたが、信仰を持ち、疑うことがなければ、いちじくの木になされたようなことができるだけでなく、たとい、この山に向かって、『動いて、海にはいれ。』と言っても、そのとおりになります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","あなたがたが信じて祈り求めるものなら、何でも与えられます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","それから、イエスが宮にはいって、教えておられると、祭司長、民の長老たちが、みもとに来て言った。「何の権威によって、これらのことをしておられるのですか。だれが、あなたにその権威を授けたのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","イエスは答えて、こう言われた。「わたしも一言あなたがたに尋ねましょう。もし、あなたがたが答えるなら、わたしも何の権威によって、これらのことをしているかを話しましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ヨハネのバプテスマは、どこから来たものですか。天からですか。それとも人からですか。」すると、彼らはこう言いながら、互いに論じ合った。「もし、天から、と言えば、それならなぜ、彼を信じなかったか、と言うだろう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","しかし、もし、人から、と言えば、群衆がこわい。彼らはみな、ヨハネを預言者と認めているのだから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","そこで、彼らはイエスに答えて、「わかりません。」と言った。イエスもまた彼らにこう言われた。「わたしも、何の権威によってこれらのことをするのか、あなたがたに話すまい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ところで、あなたがたは、どう思いますか。ある人にふたりの息子がいた。その人は兄のところに来て、『きょう、ぶどう園に行って働いてくれ。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","兄は答えて『行きます。おとうさん。』と言ったが、行かなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","それから、弟のところに来て、同じように言った。ところが、弟は答えて『行きたくありません。』と言ったが、あとから悪かったと思って出かけて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ふたりのうちどちらが、父の願ったとおりにしたのでしょう。」彼らは言った。「あとの者です。」イエスは彼らに言われた。「まことに、あなたがたに告げます。取税人や遊女たちのほうが、あなたがたより先に神の国にはいっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","というのは、あなたがたは、ヨハネが義の道を持って来たのに、彼を信じなかった。しかし、取税人や遊女たちは彼を信じたからです。しかもあなたがたは、それを見ながら、あとになって悔いることもせず、彼を信じなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","もう一つのたとえを聞きなさい。 ひとりの、家の主人がいた。彼はぶどう園を造って、垣を巡らし、その中に酒ぶねを掘り、やぐらを建て、それを農夫たちに貸して、旅に出かけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","さて、収穫の時が近づいたので、主人は自分の分を受け取ろうとして、農夫たちのところへしもべたちを遣わした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","すると、農夫たちは、そのしもべたちをつかまえて、ひとりは袋だたきにし、もうひとりは殺し、もうひとりは石で打った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","そこでもう一度、前よりももっと多くの別のしもべたちを遣わしたが、やはり同じような扱いをした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","しかし、そのあと、その主人は、『私の息子なら、敬ってくれるだろう。』と言って、息子を遣わした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","すると、農夫たちは、その子を見て、こう話し合った。『あれはあと取りだ。さあ、あれを殺して、あれのものになるはずの財産を手に入れようではないか。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","そして、彼をつかまえて、ぶどう園の外に追い出して殺してしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","このばあい、ぶどう園の主人が帰って来たら、その農夫たちをどうするでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","彼らはイエスに言った。「その悪党どもを情け容赦なく殺して、そのぶどう園を、季節にはきちんと収穫を納める別の農夫たちに貸すに違いありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","イエスは彼らに言われた。「あなたがたは、次の聖書のことばを読んだことがないのですか。 『家を建てる者たちの見捨てた石。 それが礎の石になった。 これは主のなさったことだ。 私たちの目には、 不思議なことである。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","だから、わたしはあなたがたに言います。神の国はあなたがたから取り去られ、神の国の実を結ぶ国民に与えられます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","また、この石の上に落ちる者は、粉々に砕かれ、この石が人の上に落ちれば、その人を粉みじんに飛ばしてしまいます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","祭司長たちとパリサイ人たちは、イエスのこれらのたとえを聞いたとき、自分たちをさして話しておられることに気づいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","それでイエスを捕えようとしたが、群衆を恐れた。群衆はイエスを預言者と認めていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","イエスはもう一度たとえをもって彼らに話された。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","「天の御国は、王子のために結婚の披露宴を設けた王にたとえることができます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","王は、招待しておいたお客を呼びに、しもべたちを遣わしたが、彼らは来たがらなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","それで、もう一度、次のように言いつけて、別のしもべたちを遣わした。『お客に招いておいた人たちにこう言いなさい。「さあ、食事の用意ができました。雄牛も太った家畜もほふって、何もかも整いました。どうぞ宴会にお出かけください。」』 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ところが、彼らは気にもかけず、ある者は畑に、別の者は商売に出て行き、 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","そのほかの者たちは、王のしもべたちをつかまえて恥をかかせ、そして殺してしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","王は怒って、兵隊を出して、その人殺しどもを滅ぼし、彼らの町を焼き払った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","そのとき、王はしもべたちに言った。『宴会の用意はできているが、招待しておいた人たちは、それにふさわしくなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","だから、大通りに行って、出会った者をみな宴会に招きなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","それで、しもべたちは、通りに出て行って、良い人でも悪い人でも出会った者をみな集めたので、宴会場は客でいっぱいになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ところで、王が客を見ようとしてはいって来ると、そこに婚礼の礼服を着ていない者がひとりいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","そこで、王は言った。『あなたは、どうして礼服を着ないで、ここにはいって来たのですか。』しかし、彼は黙っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","そこで、王はしもべたちに、『あれの手足を縛って、外の暗やみに放り出せ。そこで泣いて歯ぎしりするのだ。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","招待される者は多いが、選ばれる者は少ないのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","そのころ、パリサイ人たちは出て来て、どのようにイエスをことばのわなにかけようかと相談した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","彼らはその弟子たちを、ヘロデ党の者たちといっしょにイエスのもとにやって、こう言わせた。「先生。私たちは、あなたが真実な方で、真理に基づいて神の道を教え、だれをもはばからない方だと存じています。あなたは、人の顔色を見られないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","それで、どう思われるのか言ってください。税金をカイザルに納めることは、律法にかなっていることでしょうか。かなっていないことでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","イエスは彼らの悪意を知って言われた。「偽善者たち。なぜ、わたしをためすのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","納め金にするお金をわたしに見せなさい。」そこで彼らは、デナリを一枚イエスのもとに持って来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","そこで彼らに言われた。「これは、だれの肖像ですか。だれの銘ですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","彼らは、「カイザルのです。」と言った。そこで、イエスは言われた。「それなら、カイザルのものはカイザルに返しなさい。そして神のものは神に返しなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","彼らは、これを聞いて驚嘆し、イエスを残して立ち去った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","その日、復活はないと言っているサドカイ人たちが、イエスのところに来て、質問して、 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","言った。「先生。モーセは『もし、ある人が子のないままで死んだなら、その弟は兄の妻をめとって、兄のための子をもうけねばならない。』と言いました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ところで、私たちの間に七人兄弟がありました。長男は結婚しましたが、死んで、子がなかったので、その妻を弟に残しました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","次男も三男も、七人とも同じようになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","そして、最後に、その女も死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","すると復活の際には、その女は七人のうちだれの妻なのでしょうか。彼らはみな、その女を妻にしたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","しかし、イエスは彼らに答えて言われた。「そんな思い違いをしているのは、聖書も神の力も知らないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","復活の時には、人はめとることも、とつぐこともなく、天の御使いたちのようです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","それに、死人の復活については、神があなたがたに語られた事を、あなたがたは読んだことがないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","『わたしは、アブラハムの神、イサクの神、ヤコブの神である。』とあります。神は死んだ者の神ではありません。生きている者の神です。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","群衆はこれを聞いて、イエスの教えに驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","しかし、パリサイ人たちは、イエスがサドカイ人たちを黙らせたと聞いて、いっしょに集まった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","そして、彼らのうちのひとりの律法の専門家が、イエスをためそうとして、尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","「先生。律法の中で、たいせつな戒めはどれですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","そこで、イエスは彼に言われた。「『心を尽くし、思いを尽くし、知力を尽くして、あなたの神である主を愛せよ。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","これがたいせつな第一の戒めです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","『あなたの隣人をあなた自身のように愛せよ。』という第二の戒めも、それと同じようにたいせつです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","律法全体と預言者とが、この二つの戒めにかかっているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","パリサイ人たちが集まっているときに、イエスは彼らに尋ねて言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","「あなたがたは、キリストについて、どう思いますか。彼はだれの子ですか。」彼らはイエスに言った。「ダビデの子です。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","イエスは彼らに言われた。「それでは、どうしてダビデは、御霊によって、彼を主と呼び、 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","『主は私の主に言われた。 「わたしがあなたの敵を あなたの足の下に従わせるまでは、 わたしの右の座に着いていなさい。」』 と言っているのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ダビデがキリストを主と呼んでいるのなら、どうして彼はダビデの子なのでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","それで、だれもイエスに一言も答えることができなかった。また、その日以来、もはやだれも、イエスにあえて質問をする者はなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","そのとき、イエスは群衆と弟子たちに話をして、 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","こう言われた。「律法学者、パリサイ人たちは、モーセの座を占めています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ですから、彼らがあなたがたに言うことはみな、行ない、守りなさい。けれども、彼らの行ないをまねてはいけません。彼らは言うことは言うが、実行しないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","また、彼らは重い荷をくくって、人の肩に載せ、自分はそれに指一本さわろうとはしません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","彼らのしていることはみな、人に見せるためです。経札の幅を広くしたり、衣のふさを長くしたりするのもそうです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","また、宴会の上座や会堂の上席が大好きで、 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","広場であいさつされたり、人から先生と呼ばれたりすることが好きです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","しかし、あなたがたは先生と呼ばれてはいけません。あなたがたの教師はただひとりしかなく、あなたがたはみな兄弟だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","あなたがたは地上のだれかを、われらの父と呼んではいけません。あなたがたの父はただひとり、すなわち天にいます父だけだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","また、師と呼ばれてはいけません。あなたがたの師はただひとり、キリストだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","あなたがたのうちの一番偉大な者は、あなたがたに仕える人でなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","だれでも、自分を高くする者は低くされ、自分を低くする者は高くされます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","しかし、わざわいが来ますぞ。偽善の律法学者、パリサイ人たち。あなたがたは、人々から天の御国をさえぎっているのです。自分もはいらず、はいろうとしている人々をもはいらせないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","［わざわいが来ますぞ。偽善の律法学者、パリサイ人たち。あなたがたは、やもめたちの家を食いつぶしていながら、見えのために長い祈りをするからです。ですから、あなたがたは、人一倍ひどい罰を受けます。］ ");
INSERT INTO jpn1965_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","わざわいが来ますぞ。偽善の律法学者、パリサイ人たち。改宗者をひとりつくるのに、海と陸とを飛び回り、改宗者ができると、その人を自分より倍も悪いゲヘナの子にするからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","わざわいが来ますぞ。目の見えぬ手引きども。あなたがたはこう言う。『だれでも、神殿をさして誓ったのなら、何でもない。しかし、神殿の黄金をさして誓ったら、その誓いを果たさなければならない。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","愚かで、目の見えぬ人たち。黄金と、黄金を神聖なものにする神殿と、どちらがたいせつなのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","また、こう言う。『だれでも、祭壇をさして誓ったのなら、何でもない。しかし、祭壇の上の供え物をさして誓ったら、その誓いを果たさなければならない。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","目の見えぬ人たち。供え物と、その供え物を神聖なものにする祭壇と、どちらがたいせつなのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ですから、祭壇をさして誓う者は、祭壇をも、その上のすべての物をもさして誓っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","また、神殿をさして誓う者は、神殿をも、その中に住まわれる方をもさして誓っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","天をさして誓う者は、神の御座とそこに座しておられる方をさして誓うのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","わざわいが来ますぞ。偽善の律法学者、パリサイ人たち。あなたがたは、はっか、いのんど、クミンなどの十分の一を納めているが、律法の中ではるかに重要なもの、すなわち正義もあわれみも誠実もおろそかにしているのです。これこそしなければならないことです。ただし、他のほうもおろそかにしてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","目の見えぬ手引きども。あなたがたは、ぶよは、こして除くが、らくだはのみこんでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","わざわいが来ますぞ。偽善の律法学者、パリサイ人たち。あなたがたは、杯や皿の外側はきよめるが、その中は強奪と放縦でいっぱいです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","目の見えぬパリサイ人たち。まず、杯の内側をきよめなさい。そうすれば、外側もきよくなります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","わざわいが来ますぞ。偽善の律法学者、パリサイ人たち。あなたがたは白く塗った墓のようなものです。墓はその外側は美しく見えても、内側は、死人の骨や、あらゆる汚れたものがいっぱいなように、 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","あなたがたも、外側は人に正しいと見えても、内側は偽善と不法でいっぱいです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","わざわいが来ますぞ。偽善の律法学者、パリサイ人たち。あなたがたは預言者の墓を建て、義人の記念碑を飾って、 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","『私たちが、先祖の時代に生きていたら、預言者たちの血を流すような仲間にはならなかっただろう。』と言います。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","こうして、預言者を殺した者たちの子孫だと、自分で証言しています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","あなたがたも先祖の罪の目盛りの不足分を満たしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","おまえたち蛇ども、まむしのすえども。おまえたちは、ゲヘナの刑罰をどうしてのがれることができよう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","だから、わたしが預言者、知者、律法学者たちを遣わすと、おまえたちはそのうちのある者を殺し、十字架につけ、またある者を会堂でむち打ち、町から町へと迫害して行くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","それは、義人アベルの血からこのかた、神殿と祭壇との間で殺されたバラキヤの子ザカリヤの血に至るまで、地上で流されるすべての正しい血の報復があなたがたの上に来るためです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","まことに、あなたがたに告げます。これらの報いはみな、この時代の上に来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ああ、エルサレム、エルサレム。預言者たちを殺し、自分に遣わされた人たちを石で打つ者。わたしは、めんどりがひなを翼の下に集めるように、あなたの子らを幾たび集めようとしたことか。それなのに、あなたがたはそれを好まなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","見なさい。あなたがたの家は荒れ果てたままに残される。 ");
INSERT INTO jpn1965_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","あなたがたに告げます。『祝福あれ。主の御名によって来られる方に。』とあなたがたが言うときまで、あなたがたは今後決してわたしを見ることはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","イエスが宮を出て行かれるとき、弟子たちが近寄って来て、イエスに宮の建物をさし示した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","そこで、イエスは彼らに答えて言われた。「このすべての物に目をみはっているのでしょう。まことに、あなたがたに告げます。ここでは、石がくずされずに、積まれたまま残ることは決してありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","イエスがオリーブ山ですわっておられると、弟子たちが、ひそかにみもとに来て言った。「お話しください。いつ、そのようなことが起こるのでしょう。あなたの来られる時や世の終わりには、どんな前兆があるのでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","そこで、イエスは彼らに答えて言われた。「人に惑わされないように気をつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","わたしの名を名のる者が大ぜい現われ、『私こそキリストだ。』と言って、多くの人を惑わすでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","また、戦争のことや、戦争のうわさを聞くでしょうが、気をつけて、あわてないようにしなさい。これらは必ず起こることです。しかし、終わりが来たのではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","民族は民族に、国は国に敵対して立ち上がり、方々にききんと地震が起こります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","しかし、そのようなことはみな、産みの苦しみの初めなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","そのとき、人々は、あなたがたを苦しいめに会わせ、殺します。また、わたしの名のために、あなたがたはすべての国の人々に憎まれます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","また、そのときは、人々が大ぜいつまずき、互いに裏切り、憎み合います。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","また、にせ預言者が多く起こって、多くの人々を惑わします。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","不法がはびこるので、多くの人たちの愛は冷たくなります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","しかし、最後まで耐え忍ぶ者は救われます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","この御国の福音は全世界に宣べ伝えられて、すべての国民にあかしされ、それから、終わりの日が来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","それゆえ、預言者ダニエルによって語られたあの『荒らす憎むべき者』が、聖なる所に立つのを見たならば、（読者はよく読み取るように。） ");
INSERT INTO jpn1965_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","そのときは、ユダヤにいる人々は山へ逃げなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","屋上にいる者は家の中の物を持ち出そうと下に降りてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","畑にいる者は着物を取りに戻ってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","だが、その日、悲惨なのは身重の女と乳飲み子を持つ女です。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ただ、あなたがたの逃げるのが、冬や安息日にならぬよう祈りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","そのときには、世の初めから、今に至るまで、いまだかつてなかったような、またこれからもないような、ひどい苦難があるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","もし、その日数が少なくされなかったら、ひとりとして救われる者はないでしょう。しかし、選ばれた者のために、その日数は少なくされます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","そのとき、『そら、キリストがここにいる。』とか、『そこにいる。』とか言う者があっても、信じてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","にせキリスト、にせ預言者たちが現われて、できれば選民をも惑わそうとして、大きなしるしや不思議なことをして見せます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","さあ、わたしは、あなたがたに前もって話しました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","だから、たとい、『そら、荒野にいらっしゃる。』と言っても、飛び出して行ってはいけません。『そら、へやにいらっしゃる。』と聞いても、信じてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","人の子の来るのは、いなずまが東から出て、西にひらめくように、ちょうどそのように来るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","死体のある所には、はげたかが集まります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","だが、これらの日の苦難に続いてすぐに、太陽は暗くなり、月は光を放たず、星は天から落ち、天の万象は揺り動かされます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","そのとき、人の子のしるしが天に現われます。すると、地上のあらゆる種族は、悲しみながら、人の子が大能と輝かしい栄光を帯びて天の雲に乗って来るのを見るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","人の子は大きなラッパの響きとともに、御使いたちを遣わします。すると御使いたちは、天の果てから果てまで、四方からその選びの民を集めます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","いちじくの木から、たとえを学びなさい。枝が柔らかになって、葉が出て来ると、夏の近いことがわかります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","そのように、これらのことのすべてを見たら、あなたがたは、人の子が戸口まで近づいていると知りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","まことに、あなたがたに告げます。これらのことが全部起こってしまうまでは、この時代は過ぎ去りません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","この天地は滅び去ります。しかし、わたしのことばは決して滅びることがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ただし、その日、その時がいつであるかは、だれも知りません。天の御使いたちも子も知りません。ただ父だけが知っておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","人の子が来るのは、ちょうど、ノアの日のようだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","洪水前の日々は、ノアが箱舟にはいるその日まで、人々は、飲んだり、食べたり、めとったり、とついだりしていました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","そして、洪水が来てすべての物をさらってしまうまで、彼らはわからなかったのです。人の子が来るのも、そのとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","そのとき、畑にふたりいると、ひとりは取られ、ひとりは残されます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ふたりの女が臼をひいていると、ひとりは取られ、ひとりは残されます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","だから、目をさましていなさい。あなたがたは、自分の主がいつ来られるか、知らないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","しかし、このことは知っておきなさい。家の主人は、どろぼうが夜の何時に来ると知っていたら、目を見張っていたでしょうし、また、おめおめと自分の家に押し入られはしなかったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","だから、あなたがたも用心していなさい。なぜなら、人の子は、思いがけない時に来るのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","主人から、その家のしもべたちを任されて、食事時には彼らに食事をきちんと与えるような忠実な思慮深いしもべとは、いったいだれでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","主人が帰って来たときに、そのようにしているのを見られるしもべは幸いです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","まことに、あなたがたに告げます。その主人は彼に自分の全財産を任せるようになります。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ところが、それが悪いしもべで、『主人はまだまだ帰るまい。』と心の中で思い、 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","その仲間を打ちたたき、酒飲みたちと飲んだり食べたりし始めていると、 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","そのしもべの主人は、思いがけない日の思わぬ時間に帰って来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","そして、彼をきびしく罰して、その報いを偽善者たちと同じにするに違いありません。しもべはそこで泣いて歯ぎしりするのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","そこで、天の御国は、たとえて言えば、それぞれがともしびを持って、花婿を出迎える十人の娘のようです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","そのうち五人は愚かで、五人は賢かった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","愚かな娘たちは、ともしびは持っていたが、油を用意しておかなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","賢い娘たちは、自分のともしびといっしょに、入れ物に油を入れて持っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","花婿が来るのが遅れたので、みな、うとうとして眠り始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ところが、夜中になって、『そら、花婿だ。迎えに出よ。』と叫ぶ声がした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","娘たちは、みな起きて、自分のともしびを整えた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ところが愚かな娘たちは、賢い娘たちに言った。『油を少し私たちに分けてください。私たちのともしびは消えそうです。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","しかし、賢い娘たちは答えて言った。『いいえ、あなたがたに分けてあげるにはとうてい足りません。それよりも店に行って、自分のをお買いなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","そこで、買いに行くと、その間に花婿が来た。用意のできていた娘たちは、彼といっしょに婚礼の祝宴に行き、戸がしめられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","そのあとで、ほかの娘たちも来て、『ご主人さま、ご主人さま。あけてください。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","しかし、彼は答えて、『確かなところ、私はあなたがたを知りません。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","だから、目をさましていなさい。あなたがたは、その日、その時を知らないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","天の御国は、しもべたちを呼んで、自分の財産を預け、旅に出て行く人のようです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","彼は、おのおのその能力に応じて、ひとりには五タラント、ひとりには二タラント、もうひとりには一タラントを渡し、それから旅に出かけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","五タラント預かった者は、すぐに行って、それで商売をして、さらに五タラントもうけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","同様に、二タラント預かった者も、さらに二タラントもうけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ところが、一タラント預かった者は、出て行くと、地を掘って、その主人の金を隠した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","さて、よほどたってから、しもべたちの主人が帰って来て、彼らと清算をした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","すると、五タラント預かった者が来て、もう五タラント差し出して言った。『ご主人さま。私に五タラント預けてくださいましたが、ご覧ください。私はさらに五タラントもうけました。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","その主人は彼に言った。『よくやった。良い忠実なしもべだ。あなたは、わずかな物に忠実だったから、私はあなたにたくさんの物を任せよう。主人の喜びをともに喜んでくれ。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","二タラントの者も来て言った。『ご主人さま。私は二タラント預かりましたが、ご覧ください。さらに二タラントもうけました。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","その主人は彼に言った。『よくやった。良い忠実なしもべだ。あなたは、わずかな物に忠実だったから、私はあなたにたくさんの物を任せよう。主人の喜びをともに喜んでくれ。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ところが、一タラント預かっていた者も来て、言った。『ご主人さま。あなたは、蒔かない所から刈り取り、散らさない所から集めるひどい方だとわかっていました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","私はこわくなり、出て行って、あなたの一タラントを地の中に隠しておきました。さあどうぞ、これがあなたの物です。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ところが、主人は彼に答えて言った。『悪いなまけ者のしもべだ。私が蒔かない所から刈り取り、散らさない所から集めることを知っていたというのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","だったら、おまえはその私の金を、銀行に預けておくべきだった。そうすれば私は帰って来たときに、利息がついて返してもらえたのだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","だから、そのタラントを彼から取り上げて、それを十タラント持っている者にやりなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","だれでも持っている者は、与えられて豊かになり、持たない者は、持っているものまでも取り上げられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","役に立たぬしもべは、外の暗やみに追い出しなさい。そこで泣いて歯ぎしりするのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","人の子が、その栄光を帯びて、すべての御使いたちを伴って来るとき、人の子はその栄光の位に着きます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","そして、すべての国々の民が、その御前に集められます。彼は、羊飼いが羊と山羊とを分けるように、彼らをより分け、 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","羊を自分の右に、山羊を左に置きます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","そうして、王は、その右にいる者たちに言います。『さあ、わたしの父に祝福された人たち。世の初めから、あなたがたのために備えられた御国を継ぎなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","あなたがたは、わたしが空腹であったとき、わたしに食べる物を与え、わたしが渇いていたとき、わたしに飲ませ、わたしが旅人であったとき、わたしに宿を貸し、 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","わたしが裸のとき、わたしに着る物を与え、わたしが病気をしたとき、わたしを見舞い、わたしが牢にいたとき、わたしをたずねてくれたからです。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","すると、その正しい人たちは、答えて言います。『主よ。いつ、私たちは、あなたが空腹なのを見て、食べる物を差し上げ、渇いておられるのを見て、飲ませてあげましたか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","いつ、あなたが旅をしておられるときに、泊まらせてあげ、裸なのを見て、着る物を差し上げましたか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","また、いつ、私たちは、あなたのご病気やあなたが牢におられるのを見て、おたずねしましたか。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","すると、王は彼らに答えて言います。『まことに、あなたがたに告げます。あなたがたが、これらのわたしの兄弟たち、しかも最も小さい者たちのひとりにしたのは、わたしにしたのです。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","それから、王はまた、その左にいる者たちに言います。『のろわれた者ども。わたしから離れて、悪魔とその使いたちのために用意された永遠の火にはいれ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","おまえたちは、わたしが空腹であったとき、食べる物をくれず、渇いていたときにも飲ませず、 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","わたしが旅人であったときにも泊まらせず、裸であったときにも着る物をくれず、病気のときや牢にいたときにもたずねてくれなかった。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","そのとき、彼らも答えて言います。『主よ。いつ、私たちは、あなたが空腹であり、渇き、旅をし、裸であり、病気をし、牢におられるのを見て、お世話をしなかったのでしょうか。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","すると、王は彼らに答えて言います。『まことに、おまえたちに告げます。おまえたちが、この最も小さい者たちのひとりにしなかったのは、わたしにしなかったのです。』 ");
INSERT INTO jpn1965_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","こうして、この人たちは永遠の刑罰にはいり、正しい人たちは永遠のいのちにはいるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","イエスは、これらの話をすべて終えると、弟子たちに言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","「あなたがたの知っているとおり、二日たつと過越の祭りになります。人の子は十字架につけられるために引き渡されます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","そのころ、祭司長、民の長老たちは、カヤパという大祭司の家の庭に集まり、 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","イエスをだまして捕え、殺そうと相談した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","しかし、彼らは、「祭りの間はいけない。民衆の騒ぎが起こるといけないから。」と話していた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","さて、イエスがベタニヤで、らい病人シモンの家におられると、 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ひとりの女がたいへん高価な香油のはいった石膏のつぼを持ってみもとに来て、食卓に着いておられたイエスの頭に香油を注いだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","弟子たちはこれを見て、憤慨して言った。「何のために、こんなむだなことをするのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","この香油なら、高く売れて、貧乏な人たちに施しができたのに。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","するとイエスはこれを知って、彼らに言われた。「なぜ、この女を困らせるのです。わたしに対してりっぱなことをしてくれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","貧しい人たちは、いつもあなたがたといっしょにいます。しかし、わたしは、いつもあなたがたといっしょにいるわけではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","この女が、この香油をわたしのからだに注いだのは、わたしの埋葬の用意をしてくれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","まことに、あなたがたに告げます。世界中のどこででも、この福音が宣べ伝えられる所なら、この人のした事も語られて、この人の記念となるでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","そのとき、十二弟子のひとりで、イスカリオテ・ユダという者が、祭司長たちのところへ行って、 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","こう言った。「彼をあなたがたに売るとしたら、いったいいくらくれますか。」すると、彼らは銀貨三十枚を彼に支払った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","そのときから、彼はイエスを引き渡す機会をねらっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","さて、種なしパンの祝いの第一日に、弟子たちがイエスのところに来て言った。「過越の食事をなさるのに、私たちはどこで用意をしましょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","イエスは言われた。「都にはいって、これこれの人のところに行って、『先生が「わたしの時が近づいた。わたしの弟子たちといっしょに、あなたのところで過越を守ろう。」と言っておられる。』と言いなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","そこで、弟子たちはイエスに言いつけられたとおりにして、過越の食事の用意をした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","さて、夕方になって、イエスは十二弟子といっしょに食卓に着かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","みなが食事をしているとき、イエスは言われた。「まことに、あなたがたに告げます。あなたがたのうちひとりが、わたしを裏切ります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","すると、弟子たちは非常に悲しんで、「主よ。まさか私のことではないでしょう。」とかわるがわるイエスに言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","イエスは答えて言われた。「わたしといっしょに鉢に手を浸した者が、わたしを裏切るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","確かに、人の子は、自分について書いてあるとおりに、去って行きます。しかし、人の子を裏切るような人間はのろわれます。そういう人は生まれなかったほうがよかったのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","すると、イエスを裏切ろうとしていたユダが答えて言った。「先生。まさか私のことではないでしょう。」イエスは彼に、「いや、そうだ。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","また、彼らが食事をしているとき、イエスはパンを取り、祝福して後、これを裂き、弟子たちに与えて言われた。「取って食べなさい。これはわたしのからだです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","また杯を取り、感謝をささげて後、こう言って彼らにお与えになった。「みな、この杯から飲みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","これは、わたしの契約の血です。罪を赦すために多くの人のために流されるものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ただ、言っておきます。わたしの父の御国で、あなたがたと新しく飲むその日までは、わたしはもはや、ぶどうの実で造った物を飲むことはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","そして、賛美の歌を歌ってから、みなオリーブ山へ出かけて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","そのとき、イエスは弟子たちに言われた。「あなたがたはみな、今夜、わたしのゆえにつまずきます。『わたしが羊飼いを打つ。すると、羊の群れは散り散りになる。』と書いてあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","しかしわたしは、よみがえってから、あなたがたより先に、ガリラヤへ行きます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","すると、ペテロがイエスに答えて言った。「たとい全部の者があなたのゆえにつまずいても、私は決してつまずきません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","イエスは彼に言われた。「まことに、あなたに告げます。今夜、鶏が鳴く前に、あなたは三度、わたしを知らないと言います。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ペテロは言った。「たとい、ごいっしょに死ななければならないとしても、私は、あなたを知らないなどとは決して申しません。」弟子たちはみなそう言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","それからイエスは弟子たちといっしょにゲツセマネという所に来て、彼らに言われた。「わたしがあそこに行って祈っている間、ここにすわっていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","それから、ペテロとゼベダイの子ふたりとをいっしょに連れて行かれたが、イエスは悲しみもだえ始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","そのとき、イエスは彼らに言われた。「わたしは悲しみのあまり死ぬほどです。ここを離れないで、わたしといっしょに目をさましていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","それから、イエスは少し進んで行って、ひれ伏して祈って言われた。「わが父よ。できますならば、この杯をわたしから過ぎ去らせてください。しかし、わたしの願うようにではなく、あなたのみこころのように、なさってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","それから、イエスは弟子たちのところに戻って来て、彼らの眠っているのを見つけ、ペテロに言われた。「あなたがたは、そんなに、一時間でも、わたしといっしょに目をさましていることができなかったのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","誘惑に陥らないように、目をさまして、祈っていなさい。心は燃えていても、肉体は弱いのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","イエスは二度目に離れて行き、祈って言われた。「わが父よ。どうしても飲まずには済まされぬ杯でしたら、どうぞみこころのとおりをなさってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","イエスが戻って来て、ご覧になると、彼らはまたも眠っていた。目をあけていることができなかったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","イエスは、またも彼らを置いて行かれ、もう一度同じことをくり返して三度目の祈りをされた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","それから、イエスは弟子たちのところに来て言われた。「まだ眠って休んでいるのですか。見なさい。時が来ました。人の子は罪人たちの手に渡されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","立ちなさい。さあ、行くのです。見なさい。わたしを裏切る者が近づきました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","イエスがまだ話しておられるうちに、見よ、十二弟子のひとりであるユダがやって来た。剣や棒を手にした大ぜいの群衆もいっしょであった。群衆はみな、祭司長、民の長老たちから差し向けられたものであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","イエスを裏切る者は、彼らと合図を決めて、「私が口づけをするのが、その人だ。その人をつかまえるのだ。」と言っておいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","それで、彼はすぐにイエスに近づき、「先生。お元気で。」と言って、口づけした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","イエスは彼に、「友よ。何のために来たのですか。」と言われた。そのとき、群衆が来て、イエスに手をかけて捕えた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","すると、イエスといっしょにいた者のひとりが、手を伸ばして剣を抜き、大祭司のしもべに撃ってかかり、その耳を切り落とした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","そのとき、イエスは彼に言われた。「剣をもとに納めなさい。剣を取る者はみな剣で滅びます。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","それとも、わたしが父にお願いして、十二軍団よりも多くの御使いを、今わたしの配下に置いていただくことができないとでも思うのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","だが、そのようなことをすれば、こうならなければならないと書いてある聖書が、どうして実現されましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","そのとき、イエスは群衆に言われた。「まるで強盗にでも向かうように、剣や棒を持ってわたしをつかまえに来たのですか。わたしは毎日、宮ですわって教えていたのに、あなたがたは、わたしを捕えなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","しかし、すべてこうなったのは、預言者たちの書が実現するためです。」そのとき、弟子たちはみな、イエスを見捨てて、逃げてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","イエスをつかまえた人たちは、イエスを大祭司カヤパのところへ連れて行った。そこには、律法学者、長老たちが集まっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","しかし、ペテロも遠くからイエスのあとをつけながら、大祭司の中庭まではいって行き、成り行きを見ようと役人たちといっしょにすわった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","さて、祭司長たちと全議会は、イエスを死刑にするために、イエスを訴える偽証を求めていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","偽証者がたくさん出て来たが、証拠はつかめなかった。しかし、最後にふたりの者が進み出て、 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","言った。「この人は、『わたしは神の神殿をこわして、それを三日のうちに建て直せる。』と言いました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","そこで、大祭司は立ち上がってイエスに言った。「何も答えないのですか。この人たちが、あなたに不利な証言をしていますが、これはどうなのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","しかし、イエスは黙っておられた。それで、大祭司はイエスに言った。「私は、生ける神によって、あなたに命じます。あなたは神の子キリストなのか、どうか。その答えを言いなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","イエスは彼に言われた。「あなたの言うとおりです。なお、あなたがたに言っておきますが、今からのち、人の子が、力ある方の右の座に着き、天の雲に乗って来るのを、あなたがたは見ることになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","すると、大祭司は、自分の衣を引き裂いて言った。「神への冒涜だ。これでもまだ、証人が必要でしょうか。あなたがたは、今、神をけがすことばを聞いたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","どう考えますか。」彼らは答えて、「彼は死刑に当たる。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","そうして、彼らはイエスの顔につばきをかけ、こぶしでなぐりつけ、また、他の者たちは、イエスを平手で打って、 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","こう言った。「当ててみろ。キリスト。あなたを打ったのはだれか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ペテロが外の中庭にすわっていると、女中のひとりが来て言った。「あなたも、ガリラヤ人イエスといっしょにいましたね。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","しかし、ペテロはみなの前でそれを打ち消して、「何を言っているのか、私にはわからない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","そして、ペテロが入口まで出て行くと、ほかの女中が、彼を見て、そこにいる人々に言った。「この人はナザレ人イエスといっしょでした。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","それで、ペテロは、またもそれを打ち消し、誓って、「そんな人は知らない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","しばらくすると、そのあたりに立っている人々がペテロに近寄って来て、「確かに、あなたもあの仲間だ。ことばのなまりではっきりわかる。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","すると彼は、「そんな人は知らない。」と言って、のろいをかけて誓い始めた。するとすぐに、鶏が鳴いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","そこでペテロは、「鶏が鳴く前に三度、あなたは、わたしを知らないと言います。」とイエスの言われたあのことばを思い出した。そうして、彼は出て行って、激しく泣いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","さて、夜が明けると、祭司長、民の長老たち全員は、イエスを死刑にするために協議した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","それから、イエスを縛って連れ出し、総督ピラトに引き渡した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","そのとき、イエスを売ったユダは、イエスが罪に定められたのを知って後悔し、銀貨三十枚を、祭司長、長老たちに返して、 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","「私は罪を犯した。罪のない人の血を売ったりして。」と言った。しかし、彼らは、「私たちの知ったことか。自分で始末することだ。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","それで、彼は銀貨を神殿に投げ込んで立ち去った。そして、外に出て行って、首をつった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","祭司長たちは銀貨を取って、「これを神殿の金庫に入れるのはよくない。血の代価だから。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","彼らは相談して、その金で陶器師の畑を買い、旅人たちの墓地にした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","それで、その畑は、今でも血の畑と呼ばれている。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","そのとき、預言者エレミヤを通して言われた事が成就した。「彼らは銀貨三十枚を取った。イスラエルの人々に値積もりされた人の値段である。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","彼らは、主が私にお命じになったように、その金を払って、陶器師の畑を買った。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","さて、イエスは総督の前に立たれた。すると、総督はイエスに「あなたは、ユダヤ人の王ですか。」と尋ねた。イエスは彼に「そのとおりです。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","しかし、祭司長、長老たちから訴えがなされたときは、何もお答えにならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","そのとき、ピラトはイエスに言った。「あんなにいろいろとあなたに不利な証言をしているのに、聞こえないのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","それでも、イエスは、どんな訴えに対しても一言もお答えにならなかった。それには総督も非常に驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ところで総督は、その祭りには、群衆のために、いつも望みの囚人をひとりだけ赦免してやっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","そのころ、バラバという名の知れた囚人が捕えられていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","それで、彼らが集まったとき、ピラトが言った。「あなたがたは、だれを釈放してほしいのか。バラバか、それともキリストと呼ばれているイエスか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ピラトは、彼らがねたみからイエスを引き渡したことに気づいていたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","また、ピラトが裁判の席に着いていたとき、彼の妻が彼のもとに人をやって言わせた。「あの正しい人にはかかわり合わないでください。ゆうべ、私は夢で、あの人のことで苦しいめに会いましたから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","しかし、祭司長、長老たちは、バラバのほうを願うよう、そして、イエスを死刑にするよう、群衆を説きつけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","しかし、総督は彼らに答えて言った。「あなたがたは、ふたりのうちどちらを釈放してほしいのか。」彼らは言った。「バラバだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ピラトは彼らに言った。「では、キリストと言われているイエスを私はどのようにしようか。」彼らはいっせいに言った。「十字架につけろ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","だが、ピラトは言った。「あの人がどんな悪い事をしたというのか。」しかし、彼らはますます激しく「十字架につけろ。」と叫び続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","そこでピラトは、自分では手の下しようがなく、かえって暴動になりそうなのを見て、群衆の目の前で水を取り寄せ、手を洗って、言った。「この人の血について、私には責任がない。自分たちで始末するがよい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","すると、民衆はみな答えて言った。「その人の血は、私たちや子どもたちの上にかかってもいい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","そこで、ピラトは彼らのためにバラバを釈放し、イエスをむち打ってから、十字架につけるために引き渡した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","それから、総督の兵士たちは、イエスを官邸の中に連れて行って、イエスの回りに全部隊を集めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","そして、イエスの着物を脱がせて、緋色の上着を着せた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","それから、いばらで冠を編み、頭にかぶらせ、右手に葦を持たせた。そして、彼らはイエスの前にひざまずいて、からかって言った。「ユダヤ人の王さま。ばんざい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","また彼らはイエスにつばきをかけ、葦を取り上げてイエスの頭をたたいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","こんなふうに、イエスをからかったあげく、その着物を脱がせて、もとの着物を着せ、十字架につけるために連れ出した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","そして、彼らが出て行くと、シモンというクレネ人を見つけたので、彼らは、この人にイエスの十字架を、むりやりに背負わせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ゴルゴタという所（「どくろ」と言われている場所）に来てから、 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","彼らはイエスに、苦みを混ぜたぶどう酒を飲ませようとした。イエスはそれをなめただけで、飲もうとはされなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","こうして、イエスを十字架につけてから、彼らはくじを引いて、イエスの着物を分け、 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","そこにすわって、イエスの見張りをした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","また、イエスの頭の上には、「これはユダヤ人の王イエスである。」と書いた罪状書きを掲げた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","そのとき、イエスといっしょに、ふたりの強盗が、ひとりは右に、ひとりは左に、十字架につけられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","道を行く人々は、頭を振りながらイエスをののしって、 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","言った。「神殿を打ちこわして三日で建てる人よ。もし、神の子なら、自分を救ってみろ。十字架から降りて来い。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","同じように、祭司長たちも律法学者、長老たちといっしょになって、イエスをあざけって言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","「彼は他人を救ったが、自分は救えない。イスラエルの王さまなら、今、十字架から降りてもらおうか。そうしたら、われわれは信じるから。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","彼は神により頼んでいる。もし神のお気に入りなら、いま救っていただくがいい。『わたしは神の子だ。』と言っているのだから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","イエスといっしょに十字架につけられた強盗どもも、同じようにイエスをののしった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","さて、十二時から、全地が暗くなって、三時まで続いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","三時ごろ、イエスは大声で、「エリ、エリ、レマ、サバクタニ。」と叫ばれた。これは、「わが神、わが神。どうしてわたしをお見捨てになったのですか。」という意味である。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","すると、それを聞いて、そこに立っていた人々のうち、ある人たちは、「この人はエリヤを呼んでいる。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","また、彼らのひとりがすぐ走って行って、海綿を取り、それに酸いぶどう酒を含ませて、葦の棒につけ、イエスに飲ませようとした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ほかの者たちは、「私たちはエリヤが助けに来るかどうか見ることとしよう。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","そのとき、イエスはもう一度大声で叫んで、息を引き取られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","すると、見よ。神殿の幕が上から下まで真二つに裂けた。そして、地が揺れ動き、岩が裂けた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","また、墓が開いて、眠っていた多くの聖徒たちのからだが生き返った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","そして、イエスの復活の後に墓から出て来て、聖都にはいって多くの人に現われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","百人隊長および彼といっしょにイエスの見張りをしていた人々は、地震やいろいろの出来事を見て、非常な恐れを感じ、「この方はまことに神の子であった。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","そこには、遠くからながめている女たちがたくさんいた。イエスに仕えてガリラヤからついて来た女たちであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","その中に、マグダラのマリヤ、ヤコブとヨセフとの母マリヤ、ゼベダイの子らの母がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","夕方になって、アリマタヤの金持ちでヨセフという人が来た。彼もイエスの弟子になっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","この人はピラトのところに行って、イエスのからだの下げ渡しを願った。そこで、ピラトは、渡すように命じた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ヨセフはそれを取り降ろして、きれいな亜麻布に包み、 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","岩を掘って造った自分の新しい墓に納めた。墓の入口には大きな石をころがしかけて帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","そこにはマグダラのマリヤとほかのマリヤとが墓のほうを向いてすわっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","さて、次の日、すなわち備えの日の翌日、祭司長、パリサイ人たちはピラトのところに集まって、 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","こう言った。「閣下。あの、人をだます男がまだ生きていたとき、『自分は三日の後によみがえる。』と言っていたのを思い出しました。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ですから、三日目まで墓の番をするように命じてください。そうでないと、弟子たちが来て、彼を盗み出して、『死人の中からよみがえった。』と民衆に言うかもしれません。そうなると、この惑わしのほうが、前のばあいより、もっとひどいことになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ピラトは「番兵を出してやるから、行ってできるだけの番をさせるがよい。」と彼らに言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","そこで、彼らは行って、石に封印をし、番兵が墓の番をした。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","さて、安息日が終わって、週の初めの日の明け方、マグダラのマリヤと、ほかのマリヤが墓を見に来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","すると、大きな地震が起こった。それは、主の使いが天から降りて来て、石をわきへころがして、その上にすわったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","その顔は、いなずまのように輝き、その衣は雪のように白かった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","番兵たちは、御使いを見て恐ろしさのあまり震え上がり、死人のようになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","すると、御使いは女たちに言った。「恐れてはいけません。あなたがたが十字架につけられたイエスを捜しているのを、私は知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ここにはおられません。前から言っておられたように、よみがえられたからです。来て、納めてあった場所を見てごらんなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ですから急いで行って、お弟子たちにこのことを知らせなさい。イエスが死人の中からよみがえられたこと、そして、あなたがたより先にガリラヤに行かれ、あなたがたは、そこで、お会いできるということです。では、これだけはお伝えしました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","そこで、彼女たちは、恐ろしくはあったが大喜びで、急いで墓を離れ、弟子たちに知らせに走って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","すると、イエスが彼女たちに出会って、「おはよう。」と言われた。彼女たちは近寄って御足を抱いてイエスを拝んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","すると、イエスは言われた。「恐れてはいけません。行って、わたしの兄弟たちに、ガリラヤに行くように言いなさい。そこでわたしに会えるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","女たちが行き着かないうちに、もう、数人の番兵が都に来て、起こった事を全部、祭司長たちに報告した。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","そこで、祭司長たちは民の長老たちとともに集まって協議し、兵士たちに多額の金を与えて、 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","こう言った。「『夜、私たちが眠っている間に、弟子たちがやって来て、イエスを盗んで行った。』と言うのだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","もし、このことが総督の耳にはいっても、私たちがうまく説得して、あなたがたには心配をかけないようにするから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","そこで、彼らは金をもらって、指図されたとおりにした。それで、この話が広くユダヤ人の間に広まって今日に及んでいる。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","しかし、十一人の弟子たちは、ガリラヤに行って、イエスの指示された山に登った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","そして、イエスにお会いしたとき、彼らは礼拝した。しかし、ある者は疑った。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","イエスは近づいて来て、彼らにこう言われた。「わたしには天においても、地においても、いっさいの権威が与えられています。 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","それゆえ、あなたがたは行って、あらゆる国の人々を弟子としなさい。そして、父、子、聖霊の御名によってバプテスマを授け、 ");
INSERT INTO jpn1965_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","また、わたしがあなたがたに命じておいたすべてのことを守るように、彼らを教えなさい。見よ。わたしは、世の終わりまで、いつも、あなたがたとともにいます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","神の子イエス・キリストの福音のはじめ。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","預言者イザヤの書にこう書いてある。 「見よ。わたしは使いをあなたの前に遣わし、 あなたの道を整えさせよう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","荒野で叫ぶ者の声がする。 『主の道を用意し、主の通られる道をまっすぐにせよ。』」 そのとおりに、 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","バプテスマのヨハネが荒野に現われて、罪が赦されるための悔い改めのバプテスマを説いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","そこでユダヤ全国の人々とエルサレムの全住民が彼のところへ行き、自分の罪を告白して、ヨルダン川で彼からバプテスマを受けていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ヨハネは、らくだの毛で織った物を着て、腰に皮の帯を締め、いなごと野蜜を食べていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","彼は宣べ伝えて言った。「私よりもさらに力のある方が、あとからおいでになります。私には、かがんでその方のくつのひもを解く値うちもありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","私はあなたがたに水でバプテスマを授けましたが、その方は、あなたがたに聖霊のバプテスマをお授けになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","そのころ、イエスはガリラヤのナザレから来られ、ヨルダン川で、ヨハネからバプテスマをお受けになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","そして、水の中から上がられると、すぐそのとき、天が裂けて御霊が鳩のように自分の上に下られるのを、ご覧になった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","そして天から声がした。「あなたは、わたしの愛する子、わたしはあなたを喜ぶ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","そしてすぐ、御霊はイエスを荒野に追いやられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","イエスは四十日間荒野にいて、サタンの誘惑を受けられた。野の獣とともにおられたが、御使いたちがイエスに仕えていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ヨハネが捕えられて後、イエスはガリラヤに行き、神の福音を宣べて言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","「時が満ち、神の国は近くなった。悔い改めて福音を信じなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ガリラヤ湖のほとりを通られると、シモンとシモンの兄弟アンデレが湖で網を打っているのをご覧になった。彼らは漁師であった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","イエスは彼らに言われた。「わたしについて来なさい。人間をとる漁師にしてあげよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","すると、すぐに、彼らは網を捨て置いて従った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","また少し行かれると、ゼベダイの子ヤコブとその兄弟ヨハネをご覧になった。彼らも舟の中で網を繕っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","すぐに、イエスがお呼びになった。すると彼らは父ゼベダイを雇い人たちといっしょに舟に残して、イエスについて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","それから、一行はカペナウムにはいった。そしてすぐに、イエスは安息日に会堂にはいって教えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","人々は、その教えに驚いた。それはイエスが、律法学者たちのようにではなく、権威ある者のように教えられたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","すると、すぐにまた、その会堂に汚れた霊につかれた人がいて、大声でわめいて言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","「ナザレの人イエス。いったい私たちに何をしようというのです。あなたは私たちを滅ぼしに来たのでしょう。私はあなたがどなたか知っています。神の聖者です。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","イエスは彼をしかって、「黙れ。この人から出て行け。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","すると、その汚れた霊はその人をひきつけさせ、大声をあげて、その人から出て行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","人々はみな驚いて、互いに論じ合って言った。「これはどうだ。権威のある、新しい教えではないか。汚れた霊をさえ戒められる。すると従うのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","こうして、イエスの評判は、すぐに、ガリラヤ全地の至る所に広まった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","イエスは会堂を出るとすぐに、ヤコブとヨハネを連れて、シモンとアンデレの家にはいられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ところが、シモンのしゅうとめが熱病で床に着いていたので、人々はさっそく彼女のことをイエスに知らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","イエスは、彼女に近寄り、その手を取って起こされた。すると熱がひき、彼女は彼らをもてなした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","夕方になった。日が沈むと、人々は病人や悪霊につかれた者をみな、イエスのもとに連れて来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","こうして町中の者が戸口に集まって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","イエスは、さまざまの病気にかかっている多くの人をお直しになり、また多くの悪霊を追い出された。そして悪霊どもがものを言うのをお許しにならなかった。彼らがイエスをよく知っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","さて、イエスは、朝早くまだ暗いうちに起きて、寂しい所へ出て行き、そこで祈っておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","シモンとその仲間は、イエスを追って来て、 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","彼を見つけ、「みんながあなたを捜しております。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","イエスは彼らに言われた。「さあ、近くの別の村里へ行こう。そこにも福音を知らせよう。わたしは、そのために出て来たのだから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","こうしてイエスは、ガリラヤ全地にわたり、その会堂に行って、福音を告げ知らせ、悪霊を追い出された。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","さて、ひとりのらい病人が、イエスのみもとにお願いに来て、ひざまずいて言った。「お心一つで、私はきよくしていただけます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","イエスは深くあわれみ、手を伸ばして、彼にさわって言われた。「わたしの心だ。きよくなれ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","すると、すぐに、そのらい病が消えて、その人はきよくなった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","そこでイエスは、彼をきびしく戒めて、すぐに彼を立ち去らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","そのとき彼にこう言われた。「気をつけて、だれにも何も言わないようにしなさい。ただ行って、自分を祭司に見せなさい。そして、人々へのあかしのために、モーセが命じた物をもって、あなたのきよめの供え物をしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ところが、彼は出て行って、この出来事をふれ回り、言い広め始めた。そのためイエスは表立って町の中にはいることができず、町はずれの寂しい所におられた。しかし、人々は、あらゆる所からイエスのもとにやって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","数日たって、イエスがカペナウムにまた来られると、家におられることが知れ渡った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","それで多くの人が集まったため、戸口のところまですきまもないほどになった。この人たちに、イエスはみことばを話しておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","そのとき、ひとりの中風の人が四人の人にかつがれて、みもとに連れて来られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","群衆のためにイエスに近づくことができなかったので、その人々はイエスのおられるあたりの屋根をはがし、穴をあけて、中風の人を寝かせたままその床をつり降ろした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","イエスは彼らの信仰を見て、中風の人に、「子よ。あなたの罪は赦されました。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ところが、その場に律法学者が数人すわっていて、心の中で理屈を言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","「この人は、なぜ、あんなことを言うのか。神をけがしているのだ。神おひとりのほか、だれが罪を赦すことができよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","彼らが心の中でこのように理屈を言っているのを、イエスはすぐにご自分の霊で見抜いて、こう言われた。「なぜ、あなたがたは心の中でそんな理屈を言っているのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","中風の人に、『あなたの罪は赦された。』と言うのと、『起きて、寝床をたたんで歩け。』と言うのと、どちらがやさしいか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","人の子が地上で罪を赦す権威を持っていることを、あなたがたに知らせるために。」こう言ってから、中風の人に、 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","「あなたに言う。起きなさい。寝床をたたんで、家に帰りなさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","すると彼は起き上がり、すぐに床を取り上げて、みなの見ている前を出て行った。それでみなの者がすっかり驚いて、「こういうことは、かつて見たことがない。」と言って神をあがめた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","イエスはまた湖のほとりに出て行かれた。すると群衆がみな、みもとにやって来たので、彼らに教えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","イエスは、道を通りながら、アルパヨの子レビが収税所にすわっているのをご覧になって、「わたしについて来なさい。」と言われた。すると彼は立ち上がって従った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","それから、イエスは、彼の家で食卓に着かれた。取税人や罪人たちも大ぜい、イエスや弟子たちといっしょに食卓に着いていた。こういう人たちが大ぜいいて、イエスに従っていたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","パリサイ派の律法学者たちは、イエスが罪人や取税人たちといっしょに食事をしておられるのを見て、イエスの弟子たちにこう言った。「なぜ、あの人は取税人や罪人たちといっしょに食事をするのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","イエスはこれを聞いて、彼らにこう言われた。「医者を必要とするのは丈夫な者ではなく、病人です。わたしは正しい人を招くためではなく、罪人を招くために来たのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ヨハネの弟子たちとパリサイ人たちは断食をしていた。そして、イエスのもとに来て言った。「ヨハネの弟子たちやパリサイ人の弟子たちは断食するのに、あなたの弟子たちはなぜ断食しないのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","イエスは彼らに言われた。「花婿が自分たちといっしょにいる間、花婿につき添う友だちが断食できるでしょうか。花婿といっしょにいる時は、断食できないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","しかし、花婿が彼らから取り去られる時が来ます。その日には断食します。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","だれも、真新しい布切れで古い着物の継ぎをするようなことはしません。そんなことをすれば、新しい継ぎ切れは古い着物を引き裂き、破れはもっとひどくなります。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","また、だれも新しいぶどう酒を古い皮袋に入れるようなことはしません。そんなことをすれば、ぶどう酒は皮袋を張り裂き、ぶどう酒も皮袋もだめになってしまいます。新しいぶどう酒は新しい皮袋に入れるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ある安息日のこと、イエスは麦畑の中を通って行かれた。すると、弟子たちが道々穂を摘み始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","すると、パリサイ人たちがイエスに言った。「ご覧なさい。なぜ彼らは、安息日なのに、してはならないことをするのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","イエスは彼らに言われた。「ダビデとその連れの者たちが、食物がなくてひもじかったとき、ダビデが何をしたか、読まなかったのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","アビヤタルが大祭司のころ、ダビデは神の家にはいって、祭司以外の者が食べてはならない供えのパンを、自分も食べ、またともにいた者たちにも与えたではありませんか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","また言われた。「安息日は人間のために設けられたのです。人間が安息日のために造られたのではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","人の子は安息日にも主です。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","イエスはまた会堂にはいられた。そこに片手のなえた人がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","彼らは、イエスが安息日にその人を直すかどうか、じっと見ていた。イエスを訴えるためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","イエスは手のなえたその人に、「立って、真中に出なさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","それから彼らに、「安息日にしてよいのは、善を行なうことなのか、それとも悪を行なうことなのか。いのちを救うことなのか、それとも殺すことなのか。」と言われた。彼らは黙っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","イエスは怒って彼らを見回し、その心のかたくななのを嘆きながら、その人に、「手を伸ばしなさい。」と言われた。彼は手を伸ばした。するとその手が元どおりになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","そこでパリサイ人たちは出て行って、すぐにヘロデ党の者たちといっしょになって、イエスをどうして葬り去ろうかと相談を始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","それから、イエスは弟子たちとともに湖のほうに退かれた。すると、ガリラヤから出て来た大ぜいの人々がついて行った。またユダヤから、 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","エルサレムから、イドマヤから、ヨルダンの川向こうやツロ、シドンあたりから、大ぜいの人々が、イエスの行なっておられることを聞いて、みもとにやって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","イエスは、大ぜいの人なので、押し寄せて来ないよう、ご自分のために小舟を用意しておくように弟子たちに言いつけられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","それは、多くの人をいやされたので、病気に悩む人たちがみな、イエスにさわろうとして、みもとに押しかけて来たからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","また、汚れた霊どもが、イエスを見ると、みもとにひれ伏し、「あなたこそ神の子です。」と叫ぶのであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","イエスは、ご自身のことを知らせないようにと、きびしく彼らを戒められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","さて、イエスは山に登り、ご自身のお望みになる者たちを呼び寄せられたので、彼らはみもとに来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","そこでイエスは十二弟子を任命された。それは、彼らを身近に置き、また彼らを遣わして福音を宣べさせ、 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","悪霊を追い出す権威を持たせるためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","こうして、イエスは十二弟子を任命された。そして、シモンにはペテロという名をつけ、 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ゼベダイの子ヤコブとヤコブの兄弟ヨハネ、このふたりにはボアネルゲ、すなわち、雷の子という名をつけられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","次に、アンデレ、ピリポ、バルトロマイ、マタイ、トマス、アルパヨの子ヤコブ、タダイ、熱心党員シモン、 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","イスカリオテ・ユダ。このユダが、イエスを裏切ったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","イエスが家に戻られると、また大ぜいの人が集まって来たので、みなは食事する暇もなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","イエスの身内の者たちが聞いて、イエスを連れ戻しに出て来た。「気が狂ったのだ。」と言う人たちがいたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","また、エルサレムから下って来た律法学者たちも、「彼は、ベルゼブルに取りつかれている。」と言い、「悪霊どものかしらによって、悪霊どもを追い出しているのだ。」とも言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","そこでイエスは彼らをそばに呼んで、たとえによって話された。「サタンがどうしてサタンを追い出せましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","もし国が内部で分裂したら、その国は立ち行きません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","また、家が内輪もめをしたら、家は立ち行きません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","サタンも、もし内輪の争いが起こって分裂していれば、立ち行くことができないで滅びます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","確かに、強い人の家に押し入って家財を略奪するには、まずその強い人を縛り上げなければなりません。そのあとでその家を略奪できるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","まことに、あなたがたに告げます。人はその犯すどんな罪も赦していただけます。また、神をけがすことを言っても、それはみな赦していただけます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","しかし、聖霊をけがす者はだれでも、永遠に赦されず、とこしえの罪に定められます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","このように言われたのは、彼らが、「イエスは、汚れた霊につかれている。」と言っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","さて、イエスの母と兄弟たちが来て、外に立っていて、人をやり、イエスを呼ばせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","大ぜいの人がイエスを囲んですわっていたが、「ご覧なさい。あなたのおかあさんと兄弟たちが、外であなたをたずねています。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","すると、イエスは彼らに答えて言われた。「わたしの母とはだれのことですか。また、兄弟たちとはだれのことですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","そして、自分の回りにすわっている人たちを見回して言われた。「ご覧なさい。わたしの母、わたしの兄弟たちです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","神のみこころを行なう人はだれでも、わたしの兄弟、姉妹、また母なのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","イエスはまた湖のほとりで教え始められた。おびただしい数の群衆がみもとに集まった。それでイエスは湖の上の舟に乗り、そこに腰をおろされ、群衆はみな岸べの陸地にいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","イエスはたとえによって多くのことを教えられた。その教えの中でこう言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","「よく聞きなさい。種を蒔く人が種蒔きに出かけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","蒔いているとき、種が道ばたに落ちた。すると、鳥が来て食べてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","また、別の種が土の薄い岩地に落ちた。土が深くなかったので、すぐに芽を出した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","しかし日が上ると、焼けて、根がないために枯れてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","また、別の種がいばらの中に落ちた。ところが、いばらが伸びて、それをふさいでしまったので、実を結ばなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","また、別の種が良い地に落ちた。すると芽ばえ、育って、実を結び、三十倍、六十倍、百倍になった。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","そしてイエスは言われた。「聞く耳のある者は聞きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","さて、イエスだけになったとき、いつもつき従っている人たちが、十二弟子とともに、これらのたとえのことを尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","そこで、イエスは言われた。「あなたがたには、神の国の奥義が知らされているが、ほかの人たちには、すべてがたとえで言われるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","それは、『彼らは確かに見るには見るがわからず、聞くには聞くが悟らず、悔い改めて赦されることのないため。』です。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","そして彼らにこう言われた。「このたとえがわからないのですか。そんなことで、いったいどうしてたとえの理解ができましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","種蒔く人は、みことばを蒔くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","みことばが道ばたに蒔かれるとは、こういう人たちのことです――みことばを聞くと、すぐサタンが来て、彼らに蒔かれたみことばを持ち去ってしまうのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","同じように、岩地に蒔かれるとは、こういう人たちのことです――みことばを聞くと、すぐに喜んで受けるが、 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","根を張らないで、ただしばらく続くだけです。それで、みことばのために困難や迫害が起こると、すぐにつまずいてしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","もう一つの、いばらの中に種を蒔かれるとは、こういう人たちのことです――みことばを聞いてはいるが、 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","世の心づかいや、富の惑わし、その他いろいろな欲望がはいり込んで、みことばをふさぐので、実を結びません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","良い地に蒔かれるとは、みことばを聞いて受け入れ、三十倍、六十倍、百倍の実を結ぶ人たちです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","また言われた。「あかりを持って来るのは枡の下や寝台の下に置くためでしょうか。燭台の上に置くためではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","隠れているのは、必ず現われるためであり、おおい隠されているのは、明らかにされるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","聞く耳のある者は聞きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","また彼らに言われた。「聞いていることによく注意しなさい。あなたがたは、人に量ってあげるその量りで、自分にも量り与えられ、さらにその上に増し加えられます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","持っている人は、さらに与えられ、持たない人は、持っているものまでも取り上げられてしまいます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","また言われた。「神の国は、人が地に種を蒔くようなもので、 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","夜は寝て、朝は起き、そうこうしているうちに、種は芽を出して育ちます。どのようにしてか、人は知りません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","地は人手によらず実をならせるもので、初めに苗、次に穂、次に穂の中に実がはいります。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","実が熟すると、人はすぐにかまを入れます。収穫の時が来たからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","また言われた。「神の国は、どのようなものと言えばよいでしょう。何にたとえたらよいでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","それはからし種のようなものです。地に蒔かれるときには、地に蒔かれる種の中で、一番小さいのですが、 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","それが蒔かれると、生長してどんな野菜よりも大きくなり、大きな枝を張り、その陰に空の鳥が巣を作れるほどになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","イエスは、このように多くのたとえで、彼らの聞く力に応じて、みことばを話された。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","たとえによらないで話されることはなかった。ただ、ご自分の弟子たちにだけは、すべてのことを解き明かされた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","さて、その日のこと、夕方になって、イエスは弟子たちに、「さあ、向こう岸へ渡ろう。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","そこで弟子たちは、群衆をあとに残し、舟に乗っておられるままで、イエスをお連れした。他の舟もイエスについて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","すると、激しい突風が起こり、舟は波をかぶって水でいっぱいになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ところがイエスだけは、とものほうで、枕をして眠っておられた。弟子たちはイエスを起こして言った。「先生。私たちがおぼれて死にそうでも、何とも思われないのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","イエスは起き上がって、風をしかりつけ、湖に「黙れ、静まれ。」と言われた。すると風はやみ、大なぎになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","イエスは彼らに言われた。「どうしてそんなにこわがるのです。信仰がないのは、どうしたことです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","彼らは大きな恐怖に包まれて、互いに言った。「風や湖までが言うことをきくとは、いったいこの方はどういう方なのだろう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","こうして彼らは湖の向こう岸、ゲラサ人の地に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","イエスが舟から上がられると、すぐに、汚れた霊につかれた人が墓場から出て来て、イエスを迎えた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","この人は墓場に住みついており、もはやだれも、鎖をもってしても、彼をつないでおくことができなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","彼はたびたび足かせや鎖でつながれたが、鎖を引きちぎり、足かせも砕いてしまったからで、だれにも彼を押えるだけの力がなかったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","それで彼は、夜昼となく、墓場や山で叫び続け、石で自分のからだを傷つけていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","彼はイエスを遠くから見つけ、駆け寄って来てイエスを拝し、 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","大声で叫んで言った。「いと高き神の子、イエスさま。いったい私に何をしようというのですか。神の御名によってお願いします。どうか私を苦しめないでください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","それは、イエスが、「汚れた霊よ。この人から出て行け。」と言われたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","それで、「おまえの名は何か。」とお尋ねになると、「私の名はレギオンです。私たちは大ぜいですから。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","そして、自分たちをこの地方から追い出さないでくださいと懇願した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ところで、そこの山腹に、豚の大群が飼ってあった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","彼らはイエスに願って言った。「私たちを豚の中に送って、彼らに乗り移らせてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","イエスがそれを許されたので、汚れた霊どもは出て行って、豚に乗り移った。すると、二千匹ほどの豚の群れが、険しいがけを駆け降り、湖へなだれ落ちて、湖におぼれてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","豚を飼っていた者たちは逃げ出して、町や村々でこの事を告げ知らせた。人々は何事が起こったのかと見にやって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","そして、イエスのところに来て、悪霊につかれていた人、すなわちレギオンを宿していた人が、着物を着て、正気に返ってすわっているのを見て、恐ろしくなった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","見ていた人たちが、悪霊につかれていた人に起こったことや、豚のことを、つぶさに彼らに話して聞かせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","すると、彼らはイエスに、この地方から離れてくださるよう願った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","それでイエスが舟に乗ろうとされると、悪霊につかれていた人が、お供をしたいとイエスに願った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","しかし、お許しにならないで、彼にこう言われた。「あなたの家、あなたの家族のところに帰り、主があなたに、どんなに大きなことをしてくださったか、どんなにあわれんでくださったかを、知らせなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","そこで、彼は立ち去り、イエスが自分にどんなに大きなことをしてくださったかを、デカポリスの地方で言い広め始めた。人々はみな驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","イエスが舟でまた向こう岸へ渡られると、大ぜいの人の群れがみもとに集まった。イエスは岸べにとどまっておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","すると、会堂管理者のひとりでヤイロという者が来て、イエスを見て、その足もとにひれ伏し、 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","いっしょうけんめい願ってこう言った。「私の小さい娘が死にかけています。どうか、おいでくださって、娘の上に御手を置いてやってください。娘が直って、助かるようにしてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","そこで、イエスは彼といっしょに出かけられたが、多くの群衆がイエスについて来て、イエスに押し迫った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ところで、十二年の間長血をわずらっている女がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","この女は多くの医者からひどいめに会わされて、自分の持ち物をみな使い果たしてしまったが、何のかいもなく、かえって悪くなる一方であった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","彼女は、イエスのことを耳にして、群衆の中に紛れ込み、うしろから、イエスの着物にさわった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","「お着物にさわることでもできれば、きっと直る。」と考えていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","すると、すぐに、血の源がかれて、ひどい痛みが直ったことを、からだに感じた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","イエスも、すぐに、自分のうちから力が外に出て行ったことに気づいて、群衆の中を振り向いて、「だれがわたしの着物にさわったのですか。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","そこで弟子たちはイエスに言った。「群衆があなたに押し迫っているのをご覧になっていて、それでも『だれがわたしにさわったのか。』とおっしゃるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","イエスは、それをした人を知ろうとして、見回しておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","女は恐れおののき、自分の身に起こった事を知り、イエスの前に出てひれ伏し、イエスに真実を余すところなく打ち明けた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","そこで、イエスは彼女にこう言われた。「娘よ。あなたの信仰があなたを直したのです。安心して帰りなさい。病気にかからず、すこやかでいなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","イエスが、まだ話しておられるときに、会堂管理者の家から人がやって来て言った。「あなたのお嬢さんはなくなりました。なぜ、このうえ先生を煩わすことがありましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","イエスは、その話のことばをそばで聞いて、会堂管理者に言われた。「恐れないで、ただ信じていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","そして、ペテロとヤコブとヤコブの兄弟ヨハネのほかは、だれも自分といっしょに行くのをお許しにならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","彼らはその会堂管理者の家に着いた。イエスは、人々が、取り乱し、大声で泣いたり、わめいたりしているのをご覧になり、 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","中にはいって、彼らにこう言われた。「なぜ取り乱して、泣くのですか。子どもは死んだのではない。眠っているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","人々はイエスをあざ笑った。しかし、イエスはみんなを外に出し、ただその子どもの父と母、それにご自分の供の者たちだけを伴って、子どものいる所へはいって行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","そして、その子どもの手を取って、「タリタ、クミ。」と言われた。（訳して言えば、「少女よ。あなたに言う。起きなさい。」という意味である。） ");
INSERT INTO jpn1965_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","すると、少女はすぐさま起き上がり、歩き始めた。十二歳にもなっていたからである。彼らはたちまち非常な驚きに包まれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","イエスは、このことをだれにも知らせないようにと、きびしくお命じになり、さらに、少女に食事をさせるように言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","イエスはそこを去って、郷里に行かれた。弟子たちもついて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","安息日になったとき、会堂で教え始められた。それを聞いた多くの人々は驚いて言った。「この人は、こういうことをどこから得たのでしょう。この人に与えられた知恵や、この人の手で行なわれるこのような力あるわざは、いったい何でしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","この人は大工ではありませんか。マリヤの子で、ヤコブ、ヨセ、ユダ、シモンの兄弟ではありませんか。その妹たちも、私たちとここに住んでいるではありませんか。」こうして彼らはイエスにつまずいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","イエスは彼らに言われた。「預言者が尊敬されないのは、自分の郷里、親族、家族の間だけです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","それで、そこでは何一つ力あるわざを行なうことができず、少数の病人に手を置いていやされただけであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","イエスは彼らの不信仰に驚かれた。それからイエスは、近くの村々を教えて回られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","また、十二弟子を呼び、ふたりずつ遣わし始め、彼らに汚れた霊を追い出す権威をお与えになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","また、彼らにこう命じられた。「旅のためには、杖一本のほかは、何も持って行ってはいけません。パンも、袋も、胴巻きに金も持って行ってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","くつは、はきなさい。しかし二枚の下着を着てはいけません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","また、彼らに言われた。「どこででも一軒の家にはいったら、そこの土地から出て行くまでは、その家にとどまっていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","もし、あなたがたを受け入れない場所、また、あなたがたに聞こうとしない人々なら、そこから出て行くときに、そこの人々に対する証言として、足の裏のちりを払い落としなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","こうして十二人が出て行き、悔い改めを説き広め、 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","悪霊を多く追い出し、大ぜいの病人に油を塗っていやした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","イエスの名が知れ渡ったので、ヘロデ王の耳にもはいった。人々は、「バプテスマのヨハネが死人の中からよみがえったのだ。だから、あんな力が、彼のうちに働いているのだ。」と言っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","別の人々は、「彼はエリヤだ。」と言い、さらに別の人々は、「昔の預言者の中のひとりのような預言者だ。」と言っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","しかし、ヘロデはうわさを聞いて、「私が首をはねたあのヨハネが生き返ったのだ。」と言っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","実は、このヘロデが、自分の兄弟ピリポの妻ヘロデヤのことで、――ヘロデはこの女を妻としていた。――人をやってヨハネを捕え、牢につないだのであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","これは、ヨハネがヘロデに、「あなたが兄弟の妻を自分のものとしていることは不法です。」と言い張ったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ところが、ヘロデヤはヨハネを恨み、彼を殺したいと思いながら、果たせないでいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","それはヘロデが、ヨハネを正しい聖なる人と知って、彼を恐れ、保護を加えていたからである。また、ヘロデはヨハネの教えを聞くとき、非常に当惑しながらも、喜んで耳を傾けていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ところが、良い機会が訪れた。ヘロデがその誕生日に、重臣や、千人隊長や、ガリラヤのおもだった人などを招いて、祝宴を設けたとき、 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ヘロデヤの娘がはいって来て、踊りを踊ったので、ヘロデも列席の人々も喜んだ。そこで王は、この少女に、「何でもほしい物を言いなさい。与えよう。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","また、「おまえの望む物なら、私の国の半分でも、与えよう。」と言って、誓った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","そこで少女は出て行って、「何を願いましょうか。」とその母親に言った。すると母親は、「バプテスマのヨハネの首。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","そこで少女はすぐに、大急ぎで王の前に行き、こう言って頼んだ。「今すぐに、バプテスマのヨハネの首を盆に載せていただきとうございます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","王は非常に心を痛めたが、自分の誓いもあり、列席の人々の手前もあって、少女の願いを退けることを好まなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","そこで王は、すぐに護衛兵をやって、ヨハネの首を持って来るように命令した。護衛兵は行って、牢の中でヨハネの首をはね、 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","その首を盆に載せて持って来て、少女に渡した。少女は、それを母親に渡した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ヨハネの弟子たちは、このことを聞いたので、やって来て、遺体を引き取り、墓に納めたのであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","さて、使徒たちは、イエスのもとに集まって来て、自分たちのしたこと、教えたことを残らずイエスに報告した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","そこでイエスは彼らに、「さあ、あなたがただけで、寂しい所へ行って、しばらく休みなさい。」と言われた。人々の出入りが多くて、ゆっくり食事する時間さえなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","そこで彼らは、舟に乗って、自分たちだけで寂しい所へ行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ところが、多くの人々が、彼らの出て行くのを見、それと気づいて、方々の町々からそこへ徒歩で駆けつけ、彼らよりも先に着いてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","イエスは、舟から上がられると、多くの群衆をご覧になった。そして彼らが羊飼いのいない羊のようであるのを深くあわれみ、いろいろと教え始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","そのうち、もう時刻もおそくなったので、弟子たちはイエスのところに来て言った。「ここはへんぴな所で、もう時刻もおそくなりました。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","みんなを解散させてください。そして、近くの部落や村に行って何か食べる物をめいめいで買うようにさせてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","すると、彼らに答えて言われた。「あなたがたで、あの人たちに何か食べる物を上げなさい。」そこで弟子たちは言った。「私たちが出かけて行って、二百デナリものパンを買ってあの人たちに食べさせるように、ということでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","するとイエスは彼らに言われた。「パンはどれぐらいありますか。行って見て来なさい。」彼らは確かめて言った。「五つです。それと魚が二匹です。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","イエスは、みなを、それぞれ組にして青草の上にすわらせるよう、弟子たちにお命じになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","そこで人々は、百人、五十人と固まって席に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","するとイエスは、五つのパンと二匹の魚を取り、天を見上げて祝福を求め、パンを裂き、人々に配るように弟子たちに与えられた。また、二匹の魚もみなに分けられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","人々はみな、食べて満腹した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","そして、パン切れを十二のかごにいっぱい取り集め、魚の残りも取り集めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","パンを食べたのは、男が五千人であった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","それからすぐに、イエスは弟子たちを強いて舟に乗り込ませ、先に向こう岸のベツサイダに行かせ、ご自分は、その間に群衆を解散させておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","それから、群衆に別れ、祈るために、そこを去って山のほうに向かわれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","夕方になったころ、舟は湖の真中に出ており、イエスだけが陸地におられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","イエスは、弟子たちが、向かい風のために漕ぎあぐねているのをご覧になり、夜中の三時ごろ、湖の上を歩いて、彼らに近づいて行かれたが、そのままそばを通り過ぎようとのおつもりであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","しかし、弟子たちは、イエスが湖の上を歩いておられるのを見て、幽霊だと思い、叫び声をあげた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","というのは、みなイエスを見ておびえてしまったからである。しかし、イエスはすぐに彼らに話しかけ、「しっかりしなさい。わたしだ。恐れることはない。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","そして舟に乗り込まれると、風がやんだ。彼らの心中の驚きは非常なものであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","というのは、彼らはまだパンのことから悟るところがなく、その心は堅く閉じていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","彼らは湖を渡って、ゲネサレの地に着き、舟をつないだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","そして、彼らが舟から上がると、人々はすぐにイエスだと気がついて、 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","そのあたりをくまなく走り回り、イエスがおられると聞いた場所へ、病人を床に載せて運んで来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","イエスがはいって行かれると、村でも町でも部落でも、人々は病人たちを広場に寝かせ、そして、せめて、イエスの着物の端にでもさわらせてくださるようにと願った。そして、さわった人々はみな、いやされた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","さて、パリサイ人たちと幾人かの律法学者がエルサレムから来ていて、イエスの回りに集まった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","イエスの弟子のうちに、汚れた手で、すなわち洗わない手でパンを食べている者があるのを見て、 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","――パリサイ人をはじめユダヤ人はみな、昔の人たちの言い伝えを堅く守って、手をよく洗わないでは食事をせず、 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","また、市場から帰ったときには、からだをきよめてからでないと食事をしない。まだこのほかにも、杯、水差し、銅器を洗うことなど、堅く守るように伝えられた、しきたりがたくさんある。―― ");
INSERT INTO jpn1965_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","パリサイ人と律法学者たちは、イエスに尋ねた。「なぜ、あなたの弟子たちは、昔の人たちの言い伝えに従って歩まないで、汚れた手でパンを食べるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","イエスは彼らに言われた。「イザヤはあなたがた偽善者について預言をして、こう書いているが、まさにそのとおりです。 『この民は、口先ではわたしを敬うが、 その心は、わたしから遠く離れている。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","彼らが、わたしを拝んでも、むだなことである。 人間の教えを、教えとして教えるだけだから。』 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","あなたがたは、神の戒めを捨てて、人間の言い伝えを堅く守っている。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","また言われた。「あなたがたは、自分たちの言い伝えを守るために、よくも神の戒めをないがしろにしたものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","モーセは、『あなたの父と母を敬え。』また『父や母をののしる者は、死刑に処せられる。』と言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","それなのに、あなたがたは、もし人が父や母に向かって、私からあなたのために上げられる物は、コルバン（すなわち、ささげ物）になりました、と言えば、 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","その人には、父や母のために、もはや何もさせないようにしています。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","こうしてあなたがたは、自分たちが受け継いだ言い伝えによって、神のことばを空文にしています。そして、これと同じようなことを、たくさんしているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","イエスは再び群衆を呼び寄せて言われた。「みな、わたしの言うことを聞いて、悟るようになりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","外側から人にはいって、人を汚すことのできる物は何もありません。人から出て来るものが、人を汚すものなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","17","イエスが群衆を離れて、家にはいられると、弟子たちは、このたとえについて尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","イエスは言われた。「あなたがたまで、そんなにわからないのですか。外側から人にはいって来る物は人を汚すことができない、ということがわからないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","そのような物は、人の心には、はいらないで、腹にはいり、そして、かわやに出されてしまうのです。」イエスは、このように、すべての食物をきよいとされた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","また言われた。「人から出るもの、これが、人を汚すのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","内側から、すなわち、人の心から出て来るものは、悪い考え、不品行、盗み、殺人、 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","姦淫、貪欲、よこしま、欺き、好色、ねたみ、そしり、高ぶり、愚かさであり、 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","これらの悪はみな、内側から出て、人を汚すのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","イエスは、そこを出てツロの地方へ行かれた。家にはいられたとき、だれにも知られたくないと思われたが、隠れていることはできなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","汚れた霊につかれた小さい娘のいる女が、イエスのことを聞きつけてすぐにやって来て、その足もとにひれ伏した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","この女はギリシヤ人で、スロ・フェニキヤの生まれであった。そして、自分の娘から悪霊を追い出してくださるようにイエスに願い続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","するとイエスは言われた。「まず子どもたちに満腹させなければなりません。子どもたちのパンを取り上げて、小犬に投げてやるのはよくないことです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","しかし、女は答えて言った。「主よ。そのとおりです。でも、食卓の下の小犬でも、子どもたちのパンくずをいただきます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","そこでイエスは言われた。「そうまで言うのですか。それなら家にお帰りなさい。悪霊はあなたの娘から出て行きました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","女が家に帰ってみると、その子は床の上に伏せっており、悪霊はもう出ていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","それから、イエスはツロの地方を去り、シドンを通って、もう一度、デカポリス地方のあたりのガリラヤ湖に来られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","人々は、耳が聞こえず、口のきけない人を連れて来て、彼の上に手を置いてくださるように願った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","そこで、イエスは、その人だけを群衆の中から連れ出し、その両耳に指を差し入れ、それからつばきをして、その人の舌にさわられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","そして、天を見上げ、深く嘆息して、その人に「エパタ。」すなわち、「開け。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","すると彼の耳が開き、舌のもつれもすぐに解け、はっきりと話せるようになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","イエスは、このことをだれにも言ってはならない、と命じられたが、彼らは口止めされればされるほど、かえって言いふらした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","人々は非常に驚いて言った。「この方のなさったことは、みなすばらしい。つんぼを聞こえるようにし、おしを話せるようにしてくださった。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","そのころ、また大ぜいの人の群れが集まっていたが、食べる物がなかったので、イエスは弟子たちを呼んで言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","「かわいそうに、この群衆はもう三日間もわたしといっしょにいて、食べる物を持っていないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","空腹のまま家に帰らせたら、途中で動けなくなるでしょう。それに遠くから来ている人もいます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","弟子たちは答えた。「こんなへんぴな所で、どこからパンを手に入れて、この人たちに十分食べさせることができましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","すると、イエスは尋ねられた。「パンはどれぐらいありますか。」弟子たちは、「七つです。」と答えた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","すると、イエスは群衆に、地面にすわるようにおっしゃった。それから、七つのパンを取り、感謝をささげてからそれを裂き、人々に配るように弟子たちに与えられたので、弟子たちは群衆に配った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","また、魚が少しばかりあったので、そのために感謝をささげてから、これも配るように言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","人々は食べて満腹した。そして余りのパン切れを七つのかごに取り集めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","人々はおよそ四千人であった。それからイエスは、彼らを解散させられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","そしてすぐに弟子たちとともに舟に乗り、ダルマヌタ地方へ行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","パリサイ人たちがやって来て、イエスに議論をしかけ、天からのしるしを求めた。イエスをためそうとしたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","イエスは、心の中で深く嘆息して、こう言われた。「なぜ、今の時代はしるしを求めるのか。まことに、あなたがたに告げます。今の時代には、しるしは絶対に与えられません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","イエスは彼らを離れて、また舟に乗って向こう岸へ行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","弟子たちは、パンを持って来るのを忘れ、舟の中には、パンがただ一つしかなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","そのとき、イエスは彼らに命じて言われた。「パリサイ人のパン種とヘロデのパン種とに十分気をつけなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","そこで弟子たちは、パンを持っていないということで、互いに議論し始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","それに気づいてイエスは言われた。「なぜ、パンがないといって議論しているのですか。まだわからないのですか、悟らないのですか。心が堅く閉じているのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","目がありながら見えないのですか。耳がありながら聞こえないのですか。あなたがたは、覚えていないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","わたしが五千人に五つのパンを裂いて上げたとき、パン切れを取り集めて、幾つのかごがいっぱいになりましたか。」彼らは答えた。「十二です。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","「四千人に七つのパンを裂いて上げたときは、パン切れを取り集めて幾つのかごがいっぱいになりましたか。」彼らは答えた。「七つです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","イエスは言われた。「まだ悟らないのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","彼らはベツサイダに着いた。すると人々が、盲人を連れて来て、さわってやってくださるようにイエスに願った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","イエスは盲人の手を取って村の外に連れて行かれた。そしてその両眼につばきをつけ、両手を彼に当ててやって、「何か見えるか。」と聞かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","すると彼は、見えるようになって、「人が見えます。木のようですが、歩いているのが見えます。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","それから、イエスはもう一度彼の両眼に両手を当てられた。そして、彼が見つめていると、すっかり直り、すべてのものがはっきり見えるようになった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","そこでイエスは、彼を家に帰し、「村にはいって行かないように。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","それから、イエスは弟子たちとピリポ・カイザリヤの村々へ出かけられた。その途中、イエスは弟子たちに尋ねて言われた。「人々はわたしをだれだと言っていますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","彼らは答えて言った。「バプテスマのヨハネだと言っています。エリヤだと言う人も、また預言者のひとりだと言う人もいます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","するとイエスは、彼らに尋ねられた。「では、あなたがたは、わたしをだれだと言いますか。」ペテロが答えてイエスに言った。「あなたは、キリストです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","するとイエスは、自分のことをだれにも言わないようにと、彼らを戒められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","それから、人の子は必ず多くの苦しみを受け、長老、祭司長、律法学者たちに捨てられ、殺され、三日の後によみがえらなければならないと、弟子たちに教え始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","しかも、はっきりとこの事がらを話された。するとペテロは、イエスをわきにお連れして、いさめ始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","しかし、イエスは振り向いて、弟子たちを見ながら、ペテロをしかって言われた。「下がれ。サタン。あなたは神のことを思わないで、人のことを思っている。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","それから、イエスは群衆を弟子たちといっしょに呼び寄せて、彼らに言われた。「だれでもわたしについて来たいと思うなら、自分を捨て、自分の十字架を負い、そしてわたしについて来なさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","いのちを救おうと思う者はそれを失い、わたしと福音とのためにいのちを失う者はそれを救うのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","人は、たとい全世界を得ても、いのちを損じたら、何の得がありましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","自分のいのちを買い戻すために、人はいったい何を差し出すことができるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","このような姦淫と罪の時代にあって、わたしとわたしのことばを恥じるような者なら、人の子も、父の栄光を帯びて聖なる御使いたちとともに来るときには、そのような人のことを恥じます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","イエスは彼らに言われた。「まことに、あなたがたに告げます。ここに立っている人々の中には、神の国が力をもって到来しているのを見るまでは、決して死を味わわない者がいます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","それから六日たって、イエスは、ペテロとヤコブとヨハネだけを連れて、高い山に導いて行かれた。そして彼らの目の前で御姿が変わった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","その御衣は、非常に白く光り、世のさらし屋では、とてもできないほどの白さであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","また、エリヤが、モーセとともに現われ、彼らはイエスと語り合っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","すると、ペテロが口出ししてイエスに言った。「先生。私たちがここにいることは、すばらしいことです。私たちが、幕屋を三つ造ります。あなたのために一つ、モーセのために一つ、エリヤのために一つ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","実のところ、ペテロは言うべきことがわからなかったのである。彼らは恐怖に打たれたのであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","そのとき雲がわき起こってその人々をおおい、雲の中から、「これは、わたしの愛する子である。彼の言うことを聞きなさい。」という声がした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","彼らが急いであたりを見回すと、自分たちといっしょにいるのはイエスだけで、そこにはもはやだれも見えなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","さて、山を降りながら、イエスは彼らに、人の子が死人の中からよみがえるときまでは、いま見たことをだれにも話してはならない、と特に命じられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","そこで彼らは、そのおことばを心に堅く留め、死人の中からよみがえると言われたことはどういう意味かを論じ合った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","彼らはイエスに尋ねて言った。「律法学者たちは、まずエリヤが来るはずだと言っていますが、それはなぜでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","イエスは言われた。「エリヤがまず来て、すべてのことを立て直します。では、人の子について、多くの苦しみを受け、さげすまれると書いてあるのは、どうしてなのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","しかし、あなたがたに告げます。エリヤはもう来たのです。そして人々は、彼について書いてあるとおりに、好き勝手なことを彼にしたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","さて、彼らが、弟子たちのところに帰って来て、見ると、その回りに大ぜいの人の群れがおり、また、律法学者たちが弟子たちと論じ合っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","そしてすぐ、群衆はみな、イエスを見ると驚き、走り寄って来て、あいさつをした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","イエスは彼らに、「あなたがたは弟子たちと何を議論しているのですか。」と聞かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","すると群衆のひとりが、イエスに答えて言った。「先生。おしの霊につかれた私の息子を、先生のところに連れてまいりました。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","その霊が息子に取りつきますと、所かまわず彼を押し倒します。そして彼はあわを吹き、歯ぎしりして、からだをこわばらせてしまいます。それでお弟子たちに、霊を追い出してくださるようにお願いしたのですが、お弟子たちにはできませんでした。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","イエスは答えて言われた。「ああ、不信仰な世だ。いつまであなたがたといっしょにいなければならないのでしょう。いつまであなたがたにがまんしていなければならないのでしょう。その子をわたしのところに連れて来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","そこで、人々はイエスのところにその子を連れて来た。その子がイエスを見ると、霊はすぐに彼をひきつけさせたので、彼は地面に倒れ、あわを吹きながら、ころげ回った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","イエスはその子の父親に尋ねられた。「この子がこんなになってから、どのくらいになりますか。」父親は言った。「幼い時からです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","この霊は、彼を滅ぼそうとして、何度も火の中や水の中に投げ込みました。ただ、もし、おできになるものなら、私たちをあわれんで、お助けください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","するとイエスは言われた。「できるものなら、と言うのか。信じる者には、どんなことでもできるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","するとすぐに、その子の父は叫んで言った。「信じます。不信仰な私をお助けください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","イエスは、群衆が駆けつけるのをご覧になると、汚れた霊をしかって言われた。「おしとつんぼの霊。わたしが、おまえに命じる。この子から出て行きなさい。二度と、はいってはいけない。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","するとその霊は、叫び声をあげ、その子を激しくひきつけさせて、出て行った。するとその子が死人のようになったので、多くの人々は、「この子は死んでしまった。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","しかし、イエスは、彼の手を取って起こされた。するとその子は立ち上がった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","イエスが家にはいられると、弟子たちがそっとイエスに尋ねた。「どうしてでしょう。私たちには追い出せなかったのですが。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","すると、イエスは言われた。「この種のものは、祈りによらなければ、何によっても追い出せるものではありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","さて、一行はそこを去って、ガリラヤを通って行った。イエスは、人に知られたくないと思われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","それは、イエスは弟子たちを教えて、「人の子は人々の手に引き渡され、彼らはこれを殺す。しかし、殺されて、三日の後に、人の子はよみがえる。」と話しておられたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","しかし、弟子たちは、このみことばが理解できなかった。また、イエスに尋ねるのを恐れていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","カペナウムに着いた。イエスは、家にはいった後、弟子たちに質問された。「道で何を論じ合っていたのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","彼らは黙っていた。道々、だれが一番偉いかと論じ合っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","イエスはおすわりになり、十二弟子を呼んで、言われた。「だれでも人の先に立ちたいと思うなら、みなのしんがりとなり、みなに仕える者となりなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","それから、イエスは、ひとりの子どもを連れて来て、彼らの真中に立たせ、腕に抱き寄せて、彼らに言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","「だれでも、このような幼子たちのひとりを、わたしの名のゆえに受け入れるならば、わたしを受け入れるのです。また、だれでも、わたしを受け入れるならば、わたしを受け入れるのではなく、わたしを遣わされた方を受け入れるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ヨハネがイエスに言った。「先生。先生の名を唱えて悪霊を追い出している者を見ましたが、私たちの仲間ではないので、やめさせました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","しかし、イエスは言われた。「やめさせることはありません。わたしの名を唱えて、力あるわざを行ないながら、すぐあとで、わたしを悪く言える者はないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","わたしたちに反対しない者は、わたしたちの味方です。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","あなたがたがキリストの弟子だからというので、あなたがたに水一杯でも飲ませてくれる人は、決して報いを失うことはありません。これは確かなことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","また、わたしを信じるこの小さい者たちのひとりにでもつまずきを与えるような者は、むしろ大きい石臼を首にゆわえつけられて、海に投げ込まれたほうがましです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","もし、あなたの手があなたのつまずきとなるなら、それを切り捨てなさい。不具の身でいのちにはいるほうが、両手そろっていてゲヘナの消えぬ火の中に落ち込むよりは、あなたにとってよいことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","もし、あなたの足があなたのつまずきとなるなら、それを切り捨てなさい。片足でいのちにはいるほうが、両足そろっていてゲヘナに投げ入れられるよりは、あなたにとってよいことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","もし、あなたの目があなたのつまずきを引き起こすのなら、それをえぐり出しなさい。片目で神の国にはいるほうが、両目そろっていてゲヘナに投げ入れられるよりは、あなたにとってよいことです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","そこでは、彼らを食ううじは、尽きることがなく、火は消えることがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","すべては、火によって、塩けをつけられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","塩は、ききめのあるものです。しかし、もし塩に塩けがなくなったら、何によって塩けを取り戻せましょう。あなたがたは、自分自身のうちに塩けを保ちなさい。そして、互いに和合して暮らしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","イエスは、そこを立って、ユダヤ地方とヨルダンの向こうに行かれた。すると、群衆がまたもみもとに集まって来たので、またいつものように彼らを教えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","すると、パリサイ人たちがみもとにやって来て、夫が妻を離別することは許されるかどうかと質問した。イエスをためそうとしたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","イエスは答えて言われた。「モーセはあなたがたに、何と命じていますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","彼らは言った。「モーセは、離婚状を書いて妻を離別することを許しました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","イエスは言われた。「モーセは、あなたがたの心がかたくななので、この命令をあなたがたに書いたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","しかし、創造の初めから、神は、人を男と女に造られたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","それゆえ、人はその父と母を離れて、 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ふたりの者が一心同体になるのです。それで、もはやふたりではなく、ひとりなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","こういうわけで、人は、神が結び合わせたものを引き離してはなりません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","家に戻った弟子たちが、この問題についてイエスに尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","そこで、イエスは彼らに言われた。「だれでも、妻を離別して別の女を妻にするなら、前の妻に対して姦淫を犯すのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","妻も、夫を離別して別の男にとつぐなら、姦淫を犯しているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","さて、イエスにさわっていただこうとして、人々が子どもたちを、みもとに連れて来た。ところが、弟子たちは彼らをしかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","イエスはそれをご覧になり、憤って、彼らに言われた。「子どもたちを、わたしのところに来させなさい。止めてはいけません。神の国は、このような者たちのものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","まことに、あなたがたに告げます。子どものように神の国を受け入れる者でなければ、決してそこに、はいることはできません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","そしてイエスは子どもたちを抱き、彼らの上に手を置いて祝福された。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","イエスが道に出て行かれると、ひとりの人が走り寄って、御前にひざまずいて、尋ねた。「尊い先生。永遠のいのちを自分のものとして受けるためには、私は何をしたらよいでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","イエスは彼に言われた。「なぜ、わたしを『尊い』と言うのですか。尊い方は、神おひとりのほかには、だれもありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","戒めはあなたもよく知っているはずです。『殺してはならない。姦淫してはならない。盗んではならない。偽証を立ててはならない。欺き取ってはならない。父と母を敬え。』」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","すると、その人はイエスに言った。「先生。私はそのようなことをみな、小さい時から守っております。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","イエスは彼を見つめ、その人をいつくしんで言われた。「あなたには、欠けたことが一つあります。帰って、あなたの持ち物をみな売り払い、貧しい人たちに与えなさい。そうすれば、あなたは天に宝を積むことになります。そのうえで、わたしについて来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","すると彼は、このことばに顔を曇らせ、悲しみながら立ち去った。なぜなら、この人は多くの財産を持っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","イエスは、見回して、弟子たちに言われた。「裕福な者が神の国にはいることは、何とむずかしいことでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","弟子たちは、イエスのことばに驚いた。しかし、イエスは重ねて、彼らに答えて言われた。「子たちよ。神の国にはいることは、何とむずかしいことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","金持ちが神の国にはいるよりは、らくだが針の穴を通るほうがもっとやさしい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","弟子たちは、ますます驚いて互いに言った。「それでは、だれが救われることができるのだろうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","イエスは、彼らをじっと見て言われた。「それは人にはできないことですが、神は、そうではありません。どんなことでも、神にはできるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ペテロがイエスにこう言い始めた。「ご覧ください。私たちは、何もかも捨てて、あなたに従ってまいりました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","イエスは言われた。「まことに、あなたがたに告げます。わたしのために、また福音のために、家、兄弟、姉妹、母、父、子、畑を捨てた者で、 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","その百倍を受けない者はありません。今のこの時代には、家、兄弟、姉妹、母、子、畑を迫害の中で受け、後の世では永遠のいのちを受けます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","しかし、先の者があとになり、あとの者が先になることが多いのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","さて、一行は、エルサレムに上る途中にあった。イエスは先頭に立って歩いて行かれた。弟子たちは驚き、また、あとについて行く者たちは恐れを覚えた。すると、イエスは再び十二弟子をそばに呼んで、ご自分に起ころうとしていることを、話し始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","「さあ、これから、わたしたちはエルサレムに向かって行きます。人の子は、祭司長、律法学者たちに引き渡されるのです。彼らは、人の子を死刑に定め、そして、異邦人に引き渡します。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","すると彼らはあざけり、つばきをかけ、むち打ち、ついに殺します。しかし、人の子は三日の後に、よみがえります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","さて、ゼベダイのふたりの子、ヤコブとヨハネが、イエスのところに来て言った。「先生。私たちの頼み事をかなえていただきたいと思います。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","イエスは彼らに言われた。「何をしてほしいのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","彼らは言った。「あなたの栄光の座で、ひとりを先生の右に、ひとりを左にすわらせてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","しかし、イエスは彼らに言われた。「あなたがたは自分が何を求めているのか、わかっていないのです。あなたがたは、わたしの飲もうとする杯を飲み、わたしの受けようとするバプテスマを受けることができますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","彼らは「できます。」と言った。イエスは言われた。「なるほどあなたがたは、わたしの飲む杯を飲み、わたしの受けるべきバプテスマを受けはします。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","しかし、わたしの右と左にすわることは、わたしが許すことではありません。それに備えられた人々があるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","十人の者がこのことを聞くと、ヤコブとヨハネのことで腹を立てた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","そこで、イエスは彼らを呼び寄せて、言われた。「あなたがたも知っているとおり、異邦人の支配者と認められた者たちは彼らを支配し、また、偉い人たちは彼らの上に権力をふるいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","しかし、あなたがたの間では、そうでありません。あなたがたの間で偉くなりたいと思う者は、みなに仕える者になりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","あなたがたの間で人の先に立ちたいと思う者は、みなのしもべになりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","人の子が来たのも、仕えられるためではなく、かえって仕えるためであり、また、多くの人のための、贖いの代価として、自分のいのちを与えるためなのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","彼らはエリコに来た。イエスが、弟子たちや多くの群衆といっしょにエリコを出られると、テマイの子のバルテマイという盲人のこじきが、道ばたにすわっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ところが、ナザレのイエスだと聞くと、「ダビデの子のイエスさま。私をあわれんでください。」と叫び始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","そこで、彼を黙らせようと、大ぜいでたしなめたが、彼はますます、「ダビデの子よ。私をあわれんでください。」と叫び立てた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","すると、イエスは立ち止まって、「あの人を呼んで来なさい。」と言われた。そこで、彼らはその盲人を呼び、「心配しないでよい。さあ、立ちなさい。あなたをお呼びになっている。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","すると、盲人は上着を脱ぎ捨て、すぐ立ち上がって、イエスのところに来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","そこでイエスは、さらにこう言われた。「わたしに何をしてほしいのか。」すると、盲人は言った。「先生。目が見えるようになることです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","するとイエスは、彼に言われた。「さあ、行きなさい。あなたの信仰があなたを救ったのです。」すると、すぐさま彼は見えるようになり、イエスの行かれる所について行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","さて、彼らがエルサレムの近くに来て、オリーブ山のふもとのベテパゲとベタニヤに近づいたとき、イエスはふたりの弟子を使いに出して、 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","言われた。「向こうの村へ行きなさい。村にはいるとすぐ、まだだれも乗ったことのない、ろばの子が、つないであるのに気がつくでしょう。それをほどいて、引いて来なさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","もし、『なぜそんなことをするのか。』と言う人があったら、『主がお入用なのです。すぐに、またここに送り返されます。』と言いなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","そこで、出かけて見ると、表通りにある家の戸口に、ろばの子が一匹つないであったので、それをほどいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","すると、そこに立っていた何人かが言った。「ろばの子をほどいたりして、どうするのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","弟子たちが、イエスの言われたとおりを話すと、彼らは許してくれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","そこで、ろばの子をイエスのところへ引いて行って、自分たちの上着をその上に掛けた。イエスはそれに乗られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","すると、多くの人が、自分たちの上着を道に敷き、またほかの人々は、木の葉を枝ごと野原から切って来て、道に敷いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","そして、前を行く者も、あとに従う者も、叫んでいた。 「ホサナ。 祝福あれ。主の御名によって来られる方に。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","祝福あれ。いま来た、われらの父ダビデの国に。 ホサナ。いと高き所に。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","こうして、イエスはエルサレムに着き、宮にはいられた。そして、すべてを見て回った後、時間ももうおそかったので、十二弟子といっしょにベタニヤに出て行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","翌日、彼らがベタニヤを出たとき、イエスは空腹を覚えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","葉の茂ったいちじくの木が遠くに見えたので、それに何かありはしないかと見に行かれたが、そこに来ると、葉のほかは何もないのに気づかれた。いちじくのなる季節ではなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","イエスは、その木に向かって言われた。「今後、いつまでも、だれもおまえの実を食べることのないように。」弟子たちはこれを聞いていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","それから、彼らはエルサレムに着いた。イエスは宮にはいり、宮の中で売り買いしている人々を追い出し始め、両替人の台や、鳩を売る者たちの腰掛けを倒し、 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","また宮を通り抜けて器具を運ぶことをだれにもお許しにならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","そして、彼らに教えて言われた。「『わたしの家は、すべての民の祈りの家と呼ばれる。』と書いてあるではありませんか。それなのに、あなたがたはそれを強盗の巣にしたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","祭司長、律法学者たちは聞いて、どのようにしてイエスを殺そうかと相談した。イエスを恐れたからであった。なぜなら、群衆がみなイエスの教えに驚嘆していたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","夕方になると、イエスとその弟子たちは、いつも都から外に出た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","朝早く、通りがかりに見ると、いちじくの木が根まで枯れていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ペテロは思い出して、イエスに言った。「先生。ご覧なさい。あなたののろわれたいちじくの木が枯れました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","イエスは答えて言われた。「神を信じなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","まことに、あなたがたに告げます。だれでも、この山に向かって、『動いて、海にはいれ。』と言って、心の中で疑わず、ただ、自分の言ったとおりになると信じるなら、そのとおりになります。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","だからあなたがたに言うのです。祈って求めるものは何でも、すでに受けたと信じなさい。そうすれば、そのとおりになります。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","また立って祈っているとき、だれかに対して恨み事があったら、赦してやりなさい。そうすれば、天におられるあなたがたの父も、あなたがたの罪を赦してくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","27","彼らはまたエルサレムに来た。イエスが宮の中を歩いておられると、祭司長、律法学者、長老たちが、イエスのところにやって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","そして、イエスに言った。「何の権威によって、これらのことをしておられるのですか。だれが、あなたにこれらのことをする権威を授けたのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","そこでイエスは彼らに言われた。「一言尋ねますから、それに答えなさい。そうすれば、わたしも、何の権威によってこれらのことをしているかを、話しましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ヨハネのバプテスマは、天から来たのですか、人から出たのですか。答えなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","すると、彼らは、こう言いながら、互いに論じ合った。「もし、天から、と言えば、それならなぜ、彼を信じなかったかと言うだろう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","だからといって、人から、と言ってよいだろうか。」――彼らは群衆を恐れていたのである。というのは、人々がみな、ヨハネは確かに預言者だと思っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","そこで彼らは、イエスに答えて、「わかりません。」と言った。そこでイエスは彼らに、「わたしも、何の権威によってこれらのことをするのか、あなたがたに話すまい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","それからイエスは、たとえを用いて彼らに話し始められた。 「ある人がぶどう園を造って、垣を巡らし、酒ぶねを掘り、やぐらを建て、それを農夫たちに貸して、旅に出かけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","季節になると、ぶどう園の収穫の分けまえを受け取りに、しもべを農夫たちのところへ遣わした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ところが、彼らは、そのしもべをつかまえて袋だたきにし、何も持たせないで送り帰した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","そこで、もう一度別のしもべを遣わしたが、彼らは、頭をなぐり、はずかしめた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","また別のしもべを遣わしたところが、彼らは、これも殺してしまった。続いて、多くのしもべをやったけれども、彼らは袋だたきにしたり、殺したりした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","その人には、なおもうひとりの者がいた。それは愛する息子であった。彼は、『私の息子なら、敬ってくれるだろう。』と言って、最後にその息子を遣わした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","すると、その農夫たちはこう話し合った。『あれはあと取りだ。さあ、あれを殺そうではないか。そうすれば、財産はこちらのものだ。』 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","そして、彼をつかまえて殺してしまい、ぶどう園の外に投げ捨てた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ところで、ぶどう園の主人は、どうするでしょう。彼は戻って来て、農夫どもを打ち滅ぼし、ぶどう園をほかの人たちに与えてしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","あなたがたは、次の聖書のことばを読んだことがないのですか。 『家を建てる者たちの見捨てた石、 それが礎の石になった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","これは主のなさったことだ。 私たちの目には、 不思議なことである。』」 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","彼らは、このたとえ話が、自分たちをさして語られたことに気づいたので、イエスを捕えようとしたが、やはり群衆を恐れた。それで、イエスを残して、立ち去った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","さて、彼らは、イエスに何か言わせて、わなに陥れようとして、パリサイ人とヘロデ党の者数人をイエスのところへ送った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","彼らはイエスのところに来て、言った。「先生。私たちは、あなたが真実な方で、だれをもはばからない方だと存じています。あなたは人の顔色を見ず、真理に基づいて神の道を教えておられるからです。ところで、カイザルに税金を納めることは律法にかなっていることでしょうか、かなっていないことでしょうか。納めるべきでしょうか、納めるべきでないのでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","イエスは彼らの擬装を見抜いて言われた。「なぜ、わたしをためすのか。デナリ銀貨を持って来て見せなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","彼らは持って来た。そこでイエスは彼らに言われた。「これはだれの肖像ですか。だれの銘ですか。」彼らは、「カイザルのです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","するとイエスは言われた。「カイザルのものはカイザルに返しなさい。そして神のものは神に返しなさい。」彼らはイエスに驚嘆した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","また、復活はないと主張していたサドカイ人たちが、イエスのところに来て、質問した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","「先生。モーセは私たちのためにこう書いています。『もし、兄が死んで妻をあとに残し、しかも子がないばあいには、その弟はその女を妻にして、兄のための子をもうけなければならない。』 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","さて、七人の兄弟がいました。長男が妻をめとりましたが、子を残さないで死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","そこで次男がその女を妻にしたところ、やはり子を残さずに死にました。三男も同様でした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","こうして、七人とも子を残しませんでした。最後に、女も死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","復活の際、彼らがよみがえるとき、その女はだれの妻なのでしょうか。七人ともその女を妻にしたのですが。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","イエスは彼らに言われた。「そんな思い違いをしているのは、聖書も神の力も知らないからではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","人が死人の中からよみがえるときには、めとることも、とつぐこともなく、天の御使いたちのようです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","それに、死人がよみがえることについては、モーセの書にある柴の個所で、神がモーセにどう語られたか、あなたがたは読んだことがないのですか。『わたしは、アブラハムの神、イサクの神、ヤコブの神である。』とあります。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","神は死んだ者の神ではありません。生きている者の神です。あなたがたはたいへんな思い違いをしています。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","律法学者がひとり来て、その議論を聞いていたが、イエスがみごとに答えられたのを知って、イエスに尋ねた。「すべての命令の中で、どれが一番たいせつですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","イエスは答えられた。「一番たいせつなのはこれです。『イスラエルよ。聞け。われらの神である主は、唯一の主である。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","心を尽くし、思いを尽くし、知性を尽くし、力を尽くして、あなたの神である主を愛せよ。』 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","次にはこれです。『あなたの隣人をあなた自身のように愛せよ。』この二つより大事な命令は、ほかにありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","そこで、この律法学者は、イエスに言った。「先生。そのとおりです。『主は唯一であって、そのほかに、主はない。』と言われたのは、まさにそのとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","また『心を尽くし、知恵を尽くし、力を尽くして主を愛し、また隣人をあなた自身のように愛する。』ことは、どんな全焼のいけにえや供え物よりも、ずっとすぐれています。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","イエスは、彼が賢い返事をしたのを見て、言われた。「あなたは神の国から遠くない。」それから後は、だれもイエスにあえて尋ねる者がなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","イエスが宮で教えておられたとき、こう言われた。「律法学者たちは、どうしてキリストをダビデの子と言うのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ダビデ自身、聖霊によって、こう言っています。 『主は私の主に言われた。 「わたしがあなたの敵を あなたの足の下に従わせるまでは、 わたしの右の座に着いていなさい。」』 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ダビデ自身がキリストを主と呼んでいるのに、どういうわけでキリストがダビデの子なのでしょう。」大ぜいの群衆は、イエスの言われることを喜んで聞いていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","イエスはその教えの中でこう言われた。「律法学者たちには気をつけなさい。彼らは、長い衣をまとって歩き回ったり、広場であいさつされたりすることが大好きで、 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","また会堂の上席や、宴会の上座が大好きです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","また、やもめの家を食いつぶし、見えを飾るために長い祈りをします。こういう人たちは人一倍きびしい罰を受けるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","それから、イエスは献金箱に向かってすわり、人々が献金箱へ金を投げ入れる様子を見ておられた。多くの金持ちが大金を投げ入れていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","そこへひとりの貧しいやもめが来て、レプタ銅貨を二つ投げ入れた。それは一コドラントに当たる。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","すると、イエスは弟子たちを呼び寄せて、こう言われた。「まことに、あなたがたに告げます。この貧しいやもめは、献金箱に投げ入れていたどの人よりもたくさん投げ入れました。 ");
INSERT INTO jpn1965_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","みなは、あり余る中から投げ入れたのに、この女は、乏しい中から、あるだけを全部、生活費の全部を投げ入れたからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","イエスが、宮から出て行かれるとき、弟子のひとりがイエスに言った。「先生。これはまあ、何とみごとな石でしょう。何とすばらしい建物でしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","すると、イエスは彼に言われた。「この大きな建物を見ているのですか。石がくずされずに、積まれたまま残ることは決してありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","イエスがオリーブ山で宮に向かってすわっておられると、ペテロ、ヤコブ、ヨハネ、アンデレが、ひそかにイエスに質問した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","「お話しください。いつ、そういうことが起こるのでしょう。また、それがみな実現するようなときには、どんな前兆があるのでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","そこで、イエスは彼らに話し始められた。「人に惑わされないように気をつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","わたしの名を名のる者が大ぜい現われ、『私こそそれだ。』と言って、多くの人を惑わすでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","また、戦争のことや戦争のうわさを聞いても、あわててはいけません。それは必ず起こることです。しかし、終わりが来たのではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","民族は民族に、国は国に敵対して立ち上がり、方々に地震があり、ききんも起こるはずだからです。これらのことは、産みの苦しみの初めです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","だが、あなたがたは、気をつけていなさい。人々は、あなたがたを議会に引き渡し、また、あなたがたは会堂でむち打たれ、また、わたしのゆえに、総督や王たちの前に立たされます。それは彼らに対してあかしをするためです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","こうして、福音がまずあらゆる民族に宣べ伝えられなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","彼らに捕えられ、引き渡されたとき、何と言おうかなどと案じるには及びません。ただ、そのとき自分に示されることを、話しなさい。話すのはあなたがたではなく、聖霊です。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","また兄弟は兄弟を死に渡し、父は子を死に渡し、子は両親に逆らって立ち、彼らを死に至らせます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","また、わたしの名のために、あなたがたはみなの者に憎まれます。しかし、最後まで耐え忍ぶ人は救われます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","『荒らす憎むべきもの』が、自分の立ってはならない所に立っているのを見たならば（読者はよく読み取るように。）ユダヤにいる人々は山へ逃げなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","屋上にいる者は降りてはいけません。家から何かを取り出そうとして中にはいってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","畑にいる者は着物を取りに戻ってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","だが、その日、悲惨なのは身重の女と乳飲み子を持つ女です。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ただ、このことが冬に起こらないように祈りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","その日は、神が天地を創造された初めから、今に至るまで、いまだかつてなかったような、またこれからもないような苦難の日だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","そして、もし主がその日数を少なくしてくださらないなら、ひとりとして救われる者はないでしょう。しかし、主は、ご自分で選んだ選びの民のために、その日数を少なくしてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","そのとき、あなたがたに、『そら、キリストがここにいる。』とか、『ほら、あそこにいる。』とか言う者があっても、信じてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","にせキリスト、にせ預言者たちが現われて、できれば選民を惑わそうとして、しるしや不思議なことをして見せます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","だから、気をつけていなさい。わたしは、何もかも前もって話しました。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","だが、その日には、その苦難に続いて、太陽は暗くなり、月は光を放たず、 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","星は天から落ち、天の万象は揺り動かされます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","そのとき、人々は、人の子が偉大な力と栄光を帯びて雲に乗って来るのを見るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","そのとき、人の子は、御使いたちを送り、地の果てから天の果てまで、四方からその選びの民を集めます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","いちじくの木から、たとえを学びなさい。枝が柔らかになって、葉が出て来ると、夏の近いことがわかります。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","そのように、これらのことが起こるのを見たら、人の子が戸口まで近づいていると知りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","まことに、あなたがたに告げます。これらのことが全部起こってしまうまでは、この時代は過ぎ去りません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","この天地は滅びます。しかし、わたしのことばは決して滅びることがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ただし、その日、その時がいつであるかは、だれも知りません。天の御使いたちも子も知りません。ただ父だけが知っておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","気をつけなさい。目をさまし、注意していなさい。その定めの時がいつだか、あなたがたは知らないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","それはちょうど、旅に立つ人が、出がけに、しもべたちにはそれぞれ仕事を割り当てて責任を持たせ、門番には目をさましているように言いつけるようなものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","だから、目をさましていなさい。家の主人がいつ帰って来るか、夕方か、夜中か、鶏の鳴くころか、明け方か、わからないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","主人が不意に帰って来たとき眠っているのを見られないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","わたしがあなたがたに話していることは、すべての人に言っているのです。目をさましていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","さて、過越の祭りと種なしパンの祝いが二日後に迫っていたので、祭司長、律法学者たちは、どうしたらイエスをだまして捕え、殺すことができるだろうか、とけんめいであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","彼らは、「祭りの間はいけない。民衆の騒ぎが起こるといけないから。」と話していた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","イエスがベタニヤで、らい病人シモンの家におられたとき、食卓に着いておられると、ひとりの女が、純粋で、非常に高価なナルド油のはいった石膏のつぼを持って来て、そのつぼを割り、イエスの頭に注いだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","すると、何人かの者が憤慨して互いに言った。「何のために、香油をこんなにむだにしたのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","この香油なら、三百デナリ以上に売れて、貧乏な人たちに施しができたのに。」そうして、その女をきびしく責めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","すると、イエスは言われた。「そのままにしておきなさい。なぜこの人を困らせるのですか。わたしのために、りっぱなことをしてくれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","貧しい人たちは、いつもあなたがたといっしょにいます。それで、あなたがたがしたいときは、いつでも彼らに良いことをしてやれます。しかし、わたしは、いつもあなたがたといっしょにいるわけではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","この女は、自分にできることをしたのです。埋葬の用意にと、わたしのからだに、前もって油を塗ってくれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","まことに、あなたがたに告げます。世界中のどこででも、福音が宣べ伝えられる所なら、この人のした事も語られて、この人の記念となるでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ところで、イスカリオテ・ユダは、十二弟子のひとりであるが、イエスを売ろうとして祭司長たちのところへ出向いて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","彼らはこれを聞いて喜んで、金をやろうと約束した。そこでユダは、どうしたら、うまいぐあいにイエスを引き渡せるかと、ねらっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","種なしパンの祝いの第一日、すなわち、過越の小羊をほふる日に、弟子たちはイエスに言った。「過越の食事をなさるのに、私たちは、どこへ行って用意をしましょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","そこで、イエスは、弟子のうちふたりを送って、こう言われた。「都にはいりなさい。そうすれば、水がめを運んでいる男に会うから、その人について行きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","そして、その人がはいって行く家の主人に、『弟子たちといっしょに過越の食事をする、わたしの客間はどこか、と先生が言っておられる。』と言いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","するとその主人が自分で、席が整って用意のできた二階の広間を見せてくれます。そこでわたしたちのために用意をしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","弟子たちが出かけて行って、都にはいると、まさしくイエスの言われたとおりであった。それで、彼らはそこで過越の食事の用意をした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","夕方になって、イエスは十二弟子といっしょにそこに来られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","そして、みなが席に着いて、食事をしているとき、イエスは言われた。「まことに、あなたがたに告げます。あなたがたのうちのひとりで、わたしといっしょに食事をしている者が、わたしを裏切ります。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","弟子たちは悲しくなって、「まさか私ではないでしょう。」とかわるがわるイエスに言いだした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","イエスは言われた。「この十二人の中のひとりで、わたしといっしょに、同じ鉢にパンを浸している者です。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","確かに、人の子は、自分について書いてあるとおりに、去って行きます。しかし、人の子を裏切るような人間はのろわれます。そういう人は生まれなかったほうがよかったのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","それから、みなが食事をしているとき、イエスはパンを取り、祝福して後、これを裂き、彼らに与えて言われた。「取りなさい。これはわたしのからだです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","また、杯を取り、感謝をささげて後、彼らに与えられた。彼らはみなその杯から飲んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","イエスは彼らに言われた。「これはわたしの契約の血です。多くの人のために流されるものです。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","まことに、あなたがたに告げます。神の国で新しく飲むその日までは、わたしはもはや、ぶどうの実で造った物を飲むことはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","そして、賛美の歌を歌ってから、みなでオリーブ山へ出かけて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","イエスは、弟子たちに言われた。「あなたがたはみな、つまずきます。『わたしが羊飼いを打つ。すると、羊は散り散りになる。』と書いてありますから。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","しかしわたしは、よみがえってから、あなたがたより先に、ガリラヤへ行きます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","すると、ペテロがイエスに言った。「たとい全部の者がつまずいても、私はつまずきません。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","イエスは彼に言われた。「まことに、あなたに告げます。あなたは、きょう、今夜、鶏が二度鳴く前に、わたしを知らないと三度言います。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ペテロは力を込めて言い張った。「たとい、ごいっしょに死ななければならないとしても、私は、あなたを知らないなどとは決して申しません。」みなの者もそう言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ゲツセマネという所に来て、イエスは弟子たちに言われた。「わたしが祈る間、ここにすわっていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","そして、ペテロ、ヤコブ、ヨハネをいっしょに連れて行かれた。イエスは深く恐れもだえ始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","そして彼らに言われた。「わたしは悲しみのあまり死ぬほどです。ここを離れないで、目をさましていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","それから、イエスは少し進んで行って、地面にひれ伏し、もしできることなら、この時が自分から過ぎ去るようにと祈り、 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","またこう言われた。「アバ、父よ。あなたにおできにならないことはありません。どうぞ、この杯をわたしから取りのけてください。しかし、わたしの願うことではなく、あなたのみこころのままを、なさってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","それから、イエスは戻って来て、彼らの眠っているのを見つけ、ペテロに言われた。「シモン。眠っているのか。一時間でも目をさましていることができなかったのか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","誘惑に陥らないように、目をさまして、祈り続けなさい。心は燃えていても、肉体は弱いのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","イエスは再び離れて行き、前と同じことばで祈られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","そして、また戻って来て、ご覧になると、彼らは眠っていた。ひどく眠けがさしていたのである。彼らは、イエスにどう言ってよいか、わからなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","イエスは三度目に来て、彼らに言われた。「まだ眠って休んでいるのですか。もう十分です。時が来ました。見なさい。人の子は罪人たちの手に渡されます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","立ちなさい。さあ、行くのです。見なさい。わたしを裏切る者が近づきました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","そしてすぐ、イエスがまだ話しておられるうちに、十二弟子のひとりのユダが現われた。剣や棒を手にした群衆もいっしょであった。群衆はみな、祭司長、律法学者、長老たちから差し向けられたものであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","イエスを裏切る者は、彼らと前もって次のような合図を決めておいた。「私が口づけをするのが、その人だ。その人をつかまえて、しっかりと引いて行くのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","それで、彼はやって来るとすぐに、イエスに近寄って、「先生。」と言って、口づけした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","すると人々は、イエスに手をかけて捕えた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","そのとき、イエスのそばに立っていたひとりが、剣を抜いて大祭司のしもべに撃ちかかり、その耳を切り落とした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","イエスは彼らに向かって言われた。「まるで強盗にでも向かうように、剣や棒を持ってわたしを捕えに来たのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","わたしは毎日、宮であなたがたといっしょにいて、教えていたのに、あなたがたは、わたしを捕えなかったのです。しかし、こうなったのは聖書のことばが実現するためです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","すると、みながイエスを見捨てて、逃げてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ある青年が、素はだに亜麻布を一枚まとったままで、イエスについて行ったところ、人々は彼を捕えようとした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","すると、彼は亜麻布を脱ぎ捨てて、はだかで逃げた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","彼らがイエスを大祭司のところに連れて行くと、祭司長、長老、律法学者たちがみな、集まって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ペテロは、遠くからイエスのあとをつけながら、大祭司の庭の中まではいって行った。そして、役人たちといっしょにすわって、火にあたっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","さて、祭司長たちと全議会は、イエスを死刑にするために、イエスを訴える証拠をつかもうと努めたが、何も見つからなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","イエスに対する偽証をした者は多かったが、一致しなかったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","すると、数人が立ち上がって、イエスに対する偽証をして、次のように言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","「私たちは、この人が『わたしは手で造られたこの神殿をこわして、三日のうちに、手で造られない別の神殿を造ってみせる。』と言うのを聞きました。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","しかし、この点でも証言は一致しなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","そこで大祭司が立ち上がり、真中に進み出てイエスに尋ねて言った。「何も答えないのですか。この人たちが、あなたに不利な証言をしていますが、これはどうなのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","しかし、イエスは黙ったままで、何もお答えにならなかった。大祭司は、さらにイエスに尋ねて言った。「あなたは、ほむべき方の子、キリストですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","そこでイエスは言われた。「わたしは、それです。人の子が、力ある方の右の座に着き、天の雲に乗って来るのを、あなたがたは見るはずです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","すると、大祭司は、自分の衣を引き裂いて言った。「これでもまだ、証人が必要でしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","あなたがたは、神をけがすこのことばを聞いたのです。どう考えますか。」すると、彼らは全員で、イエスには死刑に当たる罪があると決めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","そうして、ある人々は、イエスにつばきをかけ、御顔をおおい、こぶしでなぐりつけ、「言い当ててみろ。」などと言ったりし始めた。また、役人たちは、イエスを受け取って、平手で打った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ペテロが下の庭にいると、大祭司の女中のひとりが来て、 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ペテロが火にあたっているのを見かけ、彼をじっと見つめて、言った。「あなたも、あのナザレ人、あのイエスといっしょにいましたね。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","しかし、ペテロはそれを打ち消して、「何を言っているのか、わからない。見当もつかない。」と言って、出口のほうへと出て行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","すると女中は、ペテロを見て、そばに立っていた人たちに、また、「この人はあの仲間です。」と言いだした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","しかし、ペテロは再び打ち消した。しばらくすると、そばに立っていたその人たちが、またペテロに言った。「確かに、あなたはあの仲間だ。ガリラヤ人なのだから。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","しかし、彼はのろいをかけて誓い始め、「私は、あなたがたの話しているその人を知りません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","するとすぐに、鶏が、二度目に鳴いた。そこでペテロは、「鶏が二度鳴く前に、あなたは、わたしを知らないと三度言います。」というイエスのおことばを思い出した。それに思い当たったとき、彼は泣き出した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","夜が明けるとすぐに、祭司長たちをはじめ、長老、律法学者たちと、全議会とは協議をこらしたすえ、イエスを縛って連れ出し、ピラトに引き渡した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ピラトはイエスに尋ねた。「あなたは、ユダヤ人の王ですか。」イエスは答えて言われた。「そのとおりです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","そこで、祭司長たちはイエスをきびしく訴えた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ピラトはもう一度イエスに尋ねて言った。「何も答えないのですか。見なさい。彼らはあんなにまであなたを訴えているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","それでも、イエスは何もお答えにならなかった。それにはピラトも驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ところでピラトは、その祭りには、人々の願う囚人をひとりだけ赦免するのを例としていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","たまたま、バラバという者がいて、暴動のとき人殺しをした暴徒たちといっしょに牢にはいっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","それで、群衆は進んで行って、いつものようにしてもらうことを、ピラトに要求し始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","そこでピラトは、彼らに答えて、「このユダヤ人の王を釈放してくれというのか。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ピラトは、祭司長たちが、ねたみからイエスを引き渡したことに、気づいていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","しかし、祭司長たちは群衆を扇動して、むしろバラバを釈放してもらいたいと言わせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","そこで、ピラトはもう一度答えて、「ではいったい、あなたがたがユダヤ人の王と呼んでいるあの人を、私にどうせよというのか。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","すると彼らはまたも「十字架につけろ。」と叫んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","だが、ピラトは彼らに、「あの人がどんな悪い事をしたというのか。」と言った。しかし、彼らはますます激しく「十字架につけろ。」と叫んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","それで、ピラトは群衆のきげんをとろうと思い、バラバを釈放した。そして、イエスをむち打って後、十字架につけるようにと引き渡した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","兵士たちはイエスを、邸宅、すなわち総督官邸の中に連れて行き、全部隊を呼び集めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","そしてイエスに紫の衣を着せ、いばらの冠を編んでかぶらせ、 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","それから、「ユダヤ人の王さま。ばんざい。」と叫んであいさつをし始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","また、葦の棒でイエスの頭をたたいたり、つばきをかけたり、ひざまずいて拝んだりしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","彼らはイエスを嘲弄したあげく、その紫の衣を脱がせて、もとの着物をイエスに着せた。それから、イエスを十字架につけるために連れ出した。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","そこへ、アレキサンデルとルポスとの父で、シモンというクレネ人が、いなかから出て来て通りかかったので、彼らはイエスの十字架を、むりやりに彼に背負わせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","そして、彼らはイエスをゴルゴタの場所（訳すと、「どくろ」の場所）へ連れて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","そして彼らは、没薬を混ぜたぶどう酒をイエスに与えようとしたが、イエスはお飲みにならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","それから、彼らは、イエスを十字架につけた。そして、だれが何を取るかをくじ引きで決めたうえで、イエスの着物を分けた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","彼らがイエスを十字架につけたのは、午前九時であった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","イエスの罪状書きには、「ユダヤ人の王。」と書いてあった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","また彼らは、イエスとともにふたりの強盗を、ひとりは右に、ひとりは左に、十字架につけた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","29","道を行く人々は、頭を振りながらイエスをののしって言った。「おお、神殿を打ちこわして三日で建てる人よ。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","十字架から降りて来て、自分を救ってみろ。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","また、祭司長たちも同じように、律法学者たちといっしょになって、イエスをあざけって言った。「他人は救ったが、自分は救えない。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","キリスト、イスラエルの王さま。たった今、十字架から降りてもらおうか。われわれは、それを見たら信じるから。」また、イエスといっしょに十字架につけられた者たちもイエスをののしった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","さて、十二時になったとき、全地が暗くなって、午後三時まで続いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","そして、三時に、イエスは大声で、「エロイ、エロイ、ラマ、サバクタニ。」と叫ばれた。それは訳すと「わが神、わが神。どうしてわたしをお見捨てになったのですか。」という意味である。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","そばに立っていた幾人かが、これを聞いて、「そら、エリヤを呼んでいる。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","すると、ひとりが走って行って、海綿に酸いぶどう酒を含ませ、それを葦の棒につけて、イエスに飲ませようとしながら言った。「エリヤがやって来て、彼を降ろすかどうか、私たちは見ることにしよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","それから、イエスは大声をあげて息を引き取られた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","神殿の幕が上から下まで真二つに裂けた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","イエスの正面に立っていた百人隊長は、イエスがこのように息を引き取られたのを見て、「この方はまことに神の子であった。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","また、遠くのほうから見ていた女たちもいた。その中にマグダラのマリヤと、小ヤコブとヨセの母マリヤと、またサロメもいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","イエスがガリラヤにおられたとき、いつもつき従って仕えていた女たちである。このほかにも、イエスといっしょにエルサレムに上って来た女たちがたくさんいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","すっかり夕方になった。その日は備えの日、すなわち安息日の前日であったので、 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","アリマタヤのヨセフは、思い切ってピラトのところに行き、イエスのからだの下げ渡しを願った。ヨセフは有力な議員であり、みずからも神の国を待ち望んでいた人であった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ピラトは、イエスがもう死んだのかと驚いて、百人隊長を呼び出し、イエスがすでに死んでしまったかどうかを問いただした。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","そして、百人隊長からそうと確かめてから、イエスのからだをヨセフに与えた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","そこで、ヨセフは亜麻布を買い、イエスを取り降ろしてその亜麻布に包み、岩を掘って造った墓に納めた。墓の入口には石をころがしかけておいた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","マグダラのマリヤとヨセの母マリヤとは、イエスの納められる所をよく見ていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","さて、安息日が終わったので、マグダラのマリヤとヤコブの母マリヤとサロメとは、イエスに油を塗りに行こうと思い、香料を買った。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","そして、週の初めの日の早朝、日が上ったとき、墓に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","彼女たちは、「墓の入口からあの石をころがしてくれる人が、だれかいるでしょうか。」とみなで話し合っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ところが、目を上げて見ると、あれほど大きな石だったのに、その石がすでにころがしてあった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","それで、墓の中にはいったところ、真白な長い衣をまとった青年が右側にすわっているのが見えた。彼女たちは驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","青年は言った。「驚いてはいけません。あなたがたは、十字架につけられたナザレ人イエスを捜しているのでしょう。あの方はよみがえられました。ここにはおられません。ご覧なさい。ここがあの方の納められた所です。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ですから行って、お弟子たちとペテロに、『イエスは、あなたがたより先にガリラヤへ行かれます。前に言われたとおり、そこでお会いできます。』とそう言いなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","女たちは、墓を出て、そこから逃げ去った。すっかり震え上がって、気も転倒していたからである。そしてだれにも何も言わなかった。恐ろしかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","［さて、週の初めの日の朝早くによみがえったイエスは、まずマグダラのマリヤにご自分を現わされた。イエスは、以前に、この女から七つの悪霊を追い出されたのであった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","マリヤはイエスといっしょにいた人たちが嘆き悲しんで泣いているところに行き、そのことを知らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ところが、彼らは、イエスが生きておられ、お姿をよく見た、と聞いても、それを信じようとはしなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","その後、彼らのうちのふたりがいなかのほうへ歩いていたおりに、イエスは別の姿でご自分を現わされた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","そこでこのふたりも、残りの人たちのところへ行ってこれを知らせたが、彼らはふたりの話も信じなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","しかしそれから後になって、イエスは、その十一人が食卓に着いているところに現われて、彼らの不信仰とかたくなな心をお責めになった。それは、彼らが、よみがえられたイエスを見た人たちの言うところを信じなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","それから、イエスは彼らにこう言われた。「全世界に出て行き、すべての造られた者に、福音を宣べ伝えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","信じてバプテスマを受ける者は、救われます。しかし、信じない者は罪に定められます。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","信じる人々には次のようなしるしが伴います。すなわち、わたしの名によって悪霊を追い出し、新しいことばを語り、 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","蛇をもつかみ、たとい毒を飲んでも決して害を受けず、また、病人に手を置けば病人はいやされます。」 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","主イエスは、彼らにこう話されて後、天に上げられて神の右の座に着かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","そこで、彼らは出て行って、至る所で福音を宣べ伝えた。主は彼らとともに働き、みことばに伴うしるしをもって、みことばを確かなものとされた。］ 別の追加文 ［さて、女たちは、命じられたすべてのことを、ペテロとその仲間の人々にさっそく知らせた。その後、イエスご自身、彼らによって、きよく、朽ちることのない、永遠の救いのおとずれを、東の果てから、西の果てまで送り届けられた。］ ");
INSERT INTO jpn1965_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","私たちの間ですでに確信されている出来事については、初めからの目撃者で、みことばに仕える者となった人々が、私たちに伝えたそのとおりを、多くの人が記事にまとめて書き上げようと、すでに試みておりますので、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","私も、すべてのことを初めから綿密に調べておりますから、あなたのために、順序を立てて書いて差し上げるのがよいと思います。尊敬するテオピロ殿。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","それによって、すでに教えを受けられた事がらが正確な事実であることを、よくわかっていただきたいと存じます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ユダヤの王ヘロデの時に、アビヤの組の者でザカリヤという祭司がいた。彼の妻はアロンの子孫で、名をエリサベツといった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ふたりとも、神の御前に正しく、主のすべての戒めと定めを落度なく踏み行なっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","エリサベツは不妊の女だったので、彼らには子がなく、ふたりとももう年をとっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","さて、ザカリヤは、自分の組が当番で、神の御前に祭司の務めをしていたが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","祭司職の習慣によって、くじを引いたところ、主の神殿にはいって香をたくことになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","彼が香をたく間、大ぜいの民はみな、外で祈っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ところが、主の使いが彼に現われて、香壇の右に立った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","これを見たザカリヤは不安を覚え、恐怖に襲われたが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","御使いは彼に言った。「こわがることはない。ザカリヤ。あなたの願いが聞かれたのです。あなたの妻エリサベツは男の子を産みます。名をヨハネとつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","その子はあなたにとって喜びとなり楽しみとなり、多くの人もその誕生を喜びます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","彼は主の御前にすぐれた者となるからです。彼は、ぶどう酒も強い酒も飲まず、まだ母の胎内にあるときから聖霊に満たされ、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","そしてイスラエルの多くの子らを、彼らの神である主に立ち返らせます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","彼こそ、エリヤの霊と力で主の前ぶれをし、父たちの心を子どもたちに向けさせ、逆らう者を義人の心に立ち戻らせ、こうして、整えられた民を主のために用意するのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","そこで、ザカリヤは御使いに言った。「私は何によってそれを知ることができましょうか。私ももう年寄りですし、妻も年をとっております。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","御使いは答えて言った。「私は神の御前に立つガブリエルです。あなたに話をし、この喜びのおとずれを伝えるように遣わされているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ですから、見なさい。これらのことが起こる日までは、あなたは、おしになって、ものが言えなくなります。私のことばを信じなかったからです。私のことばは、その時が来れば実現します。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","人々はザカリヤを待っていたが、神殿であまり暇取るので不思議に思った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","やがて彼は出て来たが、人々に話をすることができなかった。それで、彼は神殿で幻を見たのだとわかった。ザカリヤは、彼らに合図を続けるだけで、おしのままであった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","やがて、務めの期間が終わったので、彼は自分の家に帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","その後、妻エリサベツはみごもり、五か月の間引きこもって、こう言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","「主は、人中で私の恥を取り除こうと心にかけられ、今、私をこのようにしてくださいました。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ところで、その六か月目に、御使いガブリエルが、神から遣わされてガリラヤのナザレという町のひとりの処女のところに来た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","この処女は、ダビデの家系のヨセフという人のいいなずけで、名をマリヤといった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","御使いは、はいって来ると、マリヤに言った。「おめでとう、恵まれた方。主があなたとともにおられます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","しかし、マリヤはこのことばに、ひどくとまどって、これはいったい何のあいさつかと考え込んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","すると御使いが言った。「こわがることはない。マリヤ。あなたは神から恵みを受けたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ご覧なさい。あなたはみごもって、男の子を産みます。名をイエスとつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","その子はすぐれた者となり、いと高き方の子と呼ばれます。また、神である主は彼にその父ダビデの王位をお与えになります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","彼はとこしえにヤコブの家を治め、その国は終わることがありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","そこで、マリヤは御使いに言った。「どうしてそのようなことになりえましょう。私はまだ男の人を知りませんのに。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","御使いは答えて言った。「聖霊があなたの上に臨み、いと高き方の力があなたをおおいます。それゆえ、生まれる者は、聖なる者、神の子と呼ばれます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ご覧なさい。あなたの親類のエリサベツも、あの年になって男の子を宿しています。不妊の女といわれていた人なのに、今はもう六か月です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","神にとって不可能なことは一つもありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","マリヤは言った。「ほんとうに、私は主のはしためです。どうぞ、あなたのおことばどおりこの身になりますように。」こうして御使いは彼女から去って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","そのころ、マリヤは立って、山地にあるユダの町に急いだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","そしてザカリヤの家に行って、エリサベツにあいさつした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","エリサベツがマリヤのあいさつを聞いたとき、子が胎内でおどり、エリサベツは聖霊に満たされた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","そして大声をあげて言った。「あなたは女の中の祝福された方。あなたの胎の実も祝福されています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","私の主の母が私のところに来られるとは、何ということでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ほんとうに、あなたのあいさつの声が私の耳にはいったとき、私の胎内で子どもが喜んでおどりました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","主によって語られたことは必ず実現すると信じきった人は、何と幸いなことでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","マリヤは言った。 「わがたましいは主をあがめ、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","わが霊は、わが救い主なる神を喜びたたえます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","主はこの卑しいはしために 目を留めてくださったからです。 ほんとうに、これから後、どの時代の人々も、 私をしあわせ者と思うでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","力ある方が、 私に大きなことをしてくださいました。 その御名はきよく、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","そのあわれみは、主を恐れかしこむ者に、 代々にわたって及びます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","主は、御腕をもって力強いわざをなし、 心の思いの高ぶっている者を追い散らし、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","権力ある者を王位から引き降ろされます。 低い者を高く引き上げ、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","飢えた者を良いもので満ち足らせ、 富む者を何も持たせないで追い返されました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","主はそのあわれみをいつまでも忘れないで、 そのしもべイスラエルをお助けになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","私たちの先祖たち、アブラハムとその子孫に 語られたとおりです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","マリヤは三か月ほどエリサベツと暮らして、家に帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","さて月が満ちて、エリサベツは男の子を産んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","近所の人々や親族は、主がエリサベツに大きなあわれみをおかけになったと聞いて、彼女とともに喜んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","さて八日目に、人々は幼子に割礼するためにやって来て、幼子を父の名にちなんでザカリヤと名づけようとしたが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","母は答えて、「いいえ、そうではなくて、ヨハネという名にしなければなりません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","彼らは彼女に、「あなたの親族にはそのような名の人はひとりもいません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","そして、身振りで父親に合図して、幼子に何という名をつけるつもりかと尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","すると、彼は書き板を持って来させて、「彼の名はヨハネ。」と書いたので、人々はみな驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","すると、たちどころに、彼の口が開け、舌は解け、ものが言えるようになって神をほめたたえた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","そして、近所の人々はみな恐れた。さらにこれらのことの一部始終が、ユダヤの山地全体にも語り伝えられて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","聞いた人々はみな、それを心にとどめて、「いったいこの子は何になるのでしょう。」と言った。主の御手が彼とともにあったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","さて父ザカリヤは、聖霊に満たされて、預言して言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","「ほめたたえよ。イスラエルの神である主を。 主はその民を顧みて、贖いをなし、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","救いの角を、われらのために、 しもべダビデの家に立てられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","古くから、その聖なる預言者たちの口を通して、 主が話してくださったとおりに。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","この救いはわれらの敵からの、 すべてわれらを憎む者の手からの救いである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","主はわれらの父祖たちにあわれみを施し、 その聖なる契約を、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","われらの父アブラハムに誓われた誓いを覚えて、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","われらを敵の手から救い出し、 われらの生涯のすべての日に、 きよく、正しく、 恐れなく、主の御前に仕えることを許される。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","幼子よ。あなたもまた、 いと高き方の預言者と呼ばれよう。 主の御前に先立って行き、その道を備え、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","神の民に、罪の赦しによる 救いの知識を与えるためである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","これはわれらの神の深いあわれみによる。 そのあわれみにより、 日の出がいと高き所からわれらを訪れ、 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","暗黒と死の陰にすわる者たちを照らし、 われらの足を平和の道に導く。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","さて、幼子は成長し、その霊は強くなり、イスラエルの民の前に公に出現する日まで荒野にいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","そのころ、全世界の住民登録をせよという勅令が、皇帝アウグストから出た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","これは、クレニオがシリヤの総督であったときの最初の住民登録であった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","それで、人々はみな、登録のために、それぞれ自分の町に向かって行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ヨセフもガリラヤの町ナザレから、ユダヤのベツレヘムというダビデの町へ上って行った。彼は、ダビデの家系であり血筋でもあったので、 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","身重になっているいいなずけの妻マリヤもいっしょに登録するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ところが、彼らがそこにいる間に、マリヤは月が満ちて、 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","男子の初子を産んだ。それで、布にくるんで、飼葉おけに寝かせた。宿屋には彼らのいる場所がなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","さて、この土地に、羊飼いたちが、野宿で夜番をしながら羊の群れを見守っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","すると、主の使いが彼らのところに来て、主の栄光が回りを照らしたので、彼らはひどく恐れた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","御使いは彼らに言った。「恐れることはありません。今、私はこの民全体のためのすばらしい喜びを知らせに来たのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","きょうダビデの町で、あなたがたのために、救い主がお生まれになりました。この方こそ主キリストです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","あなたがたは、布にくるまって飼葉おけに寝ておられるみどりごを見つけます。これが、あなたがたのためのしるしです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","すると、たちまち、その御使いといっしょに、多くの天の軍勢が現われて、神を賛美して言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","「いと高き所に、栄光が、神にあるように。 地の上に、平和が、 御心にかなう人々にあるように。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","御使いたちが彼らを離れて天に帰ったとき、羊飼いたちは互いに話し合った。「さあ、ベツレヘムに行って、主が私たちに知らせてくださったこの出来事を見て来よう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","そして急いで行って、マリヤとヨセフと、飼葉おけに寝ておられるみどりごとを捜し当てた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","それを見たとき、羊飼いたちは、この幼子について告げられたことを知らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","それを聞いた人たちはみな、羊飼いの話したことに驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","しかしマリヤは、これらのことをすべて心に納めて、思いを巡らしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","羊飼いたちは、見聞きしたことが、全部御使いの話のとおりだったので、神をあがめ、賛美しながら帰って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","八日が満ちて幼子に割礼を施す日となり、幼子はイエスという名で呼ばれることになった。胎内に宿る前に御使いがつけた名である。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","さて、モーセの律法による彼らのきよめの期間が満ちたとき、両親は幼子を主にささげるために、エルサレムへ連れて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","――それは、主の律法に「母の胎を開く男子の初子は、すべて、主に聖別された者、と呼ばれなければならない。」と書いてあるとおりであった。―― ");
INSERT INTO jpn1965_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","また、主の律法に「山ばと一つがい、または、家ばとのひな二羽。」と定められたところに従って犠牲をささげるためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","そのとき、エルサレムにシメオンという人がいた。この人は正しい、敬虔な人で、イスラエルの慰められることを待ち望んでいた。聖霊が彼の上にとどまっておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","また、主のキリストを見るまでは、決して死なないと、聖霊のお告げを受けていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","彼が御霊に感じて宮にはいると、幼子イエスを連れた両親が、その子のために律法の慣習を守るために、はいって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","すると、シメオンは幼子を腕に抱き、神をほめたたえて言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","「主よ。今こそあなたは、あなたのしもべを、 みことばどおり、安らかに去らせてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","私の目があなたの御救いを見たからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","御救いはあなたが 万民の前に備えられたもので、 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","異邦人を照らす啓示の光、 御民イスラエルの光栄です。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","父と母は、幼子についていろいろ語られる事に驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","また、シメオンは両親を祝福し、母マリヤに言った。「ご覧なさい。この子は、イスラエルの多くの人が倒れ、また、立ち上がるために定められ、また、反対を受けるしるしとして定められています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","剣があなたの心さえも刺し貫くでしょう。それは多くの人の心の思いが現われるためです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","また、アセル族のパヌエルの娘で女預言者のアンナという人がいた。この人は非常に年をとっていた。処女の時代のあと七年間、夫とともに住み、 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","その後やもめになり、八十四歳になっていた。そして宮を離れず、夜も昼も、断食と祈りをもって神に仕えていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ちょうどこのとき、彼女もそこにいて、神に感謝をささげ、そして、エルサレムの贖いを待ち望んでいるすべての人々に、この幼子のことを語った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","さて、彼らは主の律法による定めをすべて果たしたので、ガリラヤの自分たちの町ナザレに帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","幼子は成長し、強くなり、知恵に満ちて行った。神の恵みがその上にあった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","さて、イエスの両親は、過越の祭りには毎年エルサレムに行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","イエスが十二歳になられたときも、両親は祭りの慣習に従って都へ上り、 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","祭りの期間を過ごしてから、帰路についたが、少年イエスはエルサレムにとどまっておられた。両親はそれに気づかなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","イエスが一行の中にいるものと思って、一日の道のりを行った。それから、親族や知人の中を捜し回ったが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","見つからなかったので、イエスを捜しながら、エルサレムまで引き返した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","そしてようやく三日の後に、イエスが宮で教師たちの真中にすわって、話を聞いたり質問したりしておられるのを見つけた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","聞いていた人々はみな、イエスの知恵と答えに驚いていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","両親は彼を見て驚き、母は言った。「まあ、あなたはなぜ私たちにこんなことをしたのです。見なさい。父上も私も、心配してあなたを捜し回っていたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","するとイエスは両親に言われた。「どうしてわたしをお捜しになったのですか。わたしが必ず自分の父の家にいることを、ご存じなかったのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","しかし両親には、イエスの話されたことばの意味がわからなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","それからイエスは、いっしょに下って行かれ、ナザレに帰って、両親に仕えられた。母はこれらのことをみな、心に留めておいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","イエスはますます知恵が進み、背たけも大きくなり、神と人とに愛された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","皇帝テベリオの治世の第十五年、ポンテオ・ピラトがユダヤの総督、ヘロデがガリラヤの国主、その兄弟ピリポがイツリヤとテラコニテ地方の国主、ルサニヤがアビレネの国主であり、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","アンナスとカヤパが大祭司であったころ、神のことばが、荒野でザカリヤの子ヨハネに下った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","そこでヨハネは、ヨルダン川のほとりのすべての地方に行って、罪が赦されるための悔い改めに基づくバプテスマを説いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","そのことは預言者イザヤのことばの書に書いてあるとおりである。 「荒野で叫ぶ者の声がする。 『主の道を用意し、 主の通られる道をまっすぐにせよ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","すべての谷はうずめられ、 すべての山と丘とは低くされ、 曲がった所はまっすぐになり、 でこぼこ道は平らになる。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","こうして、あらゆる人が、 神の救いを見るようになる。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","それで、ヨハネは、彼からバプテスマを受けようとして出て来た群衆に言った。「まむしのすえたち。だれが必ず来る御怒りをのがれるように教えたのか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","それならそれで、悔い改めにふさわしい実を結びなさい。『われわれの先祖はアブラハムだ。』などと心の中で言い始めてはいけません。よく言っておくが、神は、こんな石ころからでも、アブラハムの子孫を起こすことがおできになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","斧もすでに木の根元に置かれています。だから、良い実を結ばない木は、みな切り倒されて、火に投げ込まれます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","群衆はヨハネに尋ねた。「それでは、私たちはどうすればよいのでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","彼は答えて言った。「下着を二枚持っている者は、一つも持たない者に分けなさい。食べ物を持っている者も、そうしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","取税人たちも、バプテスマを受けに出て来て、言った。「先生。私たちはどうすればよいのでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ヨハネは彼らに言った。「決められたもの以上には、何も取り立ててはいけません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","兵士たちも、彼に尋ねて言った。「私たちはどうすればよいのでしょうか。」ヨハネは言った。「だれからも、力ずくで金をゆすったり、無実の者を責めたりしてはいけません。自分の給料で満足しなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","民衆は救い主を待ち望んでおり、みな心の中で、ヨハネについて、もしかするとこの方がキリストではあるまいか、と考えていたので、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ヨハネはみなに答えて言った。「私は水であなたがたにバプテスマを授けています。しかし、私よりもさらに力のある方がおいでになります。私などは、その方のくつのひもを解く値うちもありません。その方は、あなたがたに聖霊と火とのバプテスマをお授けになります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","また手に箕を持って脱穀場をことごとくきよめ、麦を倉に納め、殻を消えない火で焼き尽くされます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ヨハネは、そのほかにも多くのことを教えて、民衆に福音を知らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","さて国主ヘロデは、その兄弟の妻ヘロデヤのことについて、また、自分の行なった悪事のすべてを、ヨハネに責められたので、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ヨハネを牢に閉じ込め、すべての悪事にもう一つこの悪事を加えた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","さて、民衆がみなバプテスマを受けていたころ、イエスもバプテスマをお受けになり、そして祈っておられると、天が開け、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","聖霊が、鳩のような形をして、自分の上に下られるのをご覧になった。また、天から声がした。「あなたは、わたしの愛する子、わたしはあなたを喜ぶ。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","教えを始められたとき、イエスはおよそ三十歳で、人々からヨセフの子と思われていた。このヨセフは、ヘリの子、順次さかのぼって、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","マタテの子、レビの子、メルキの子、ヤンナイの子、ヨセフの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","マタテヤの子、アモスの子、ナホムの子、エスリの子、ナンガイの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","マハテの子、マタテヤの子、シメイの子、ヨセクの子、ヨダの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ヨハナンの子、レサの子、ゾロバベルの子、サラテルの子、ネリの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","メルキの子、アデイの子、コサムの子、エルマダムの子、エルの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ヨシュアの子、エリエゼルの子、ヨリムの子、マタテの子、レビの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","シメオンの子、ユダの子、ヨセフの子、ヨナムの子、エリヤキムの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","メレヤの子、メナの子、マタタの子、ナタンの子、ダビデの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","エッサイの子、オベデの子、ボアズの子、サラの子、ナアソンの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","アミナダブの子、アデミンの子、アルニの子、エスロンの子、パレスの子、ユダの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ヤコブの子、イサクの子、アブラハムの子、テラの子、ナホルの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","セルグの子、レウの子、ペレグの子、エベルの子、サラの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","カイナンの子、アルパクサデの子、セムの子、ノアの子、ラメクの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","メトセラの子、エノクの子、ヤレデの子、マハラレルの子、カイナンの子、 ");
INSERT INTO jpn1965_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","エノスの子、セツの子、アダムの子、このアダムは神の子である。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","さて、聖霊に満ちたイエスは、ヨルダンから帰られた。そして御霊に導かれて荒野におり、 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","四十日間、悪魔の試みに会われた。その間何も食べず、その時が終わると、空腹を覚えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","そこで、悪魔はイエスに言った。「あなたが神の子なら、この石に、パンになれと言いつけなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","イエスは答えられた。「『人はパンだけで生きるのではない。』と書いてある。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","また、悪魔はイエスを連れて行き、またたくまに世界の国々を全部見せて、 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","こう言った。「この、国々のいっさいの権力と栄光とをあなたに差し上げましょう。それは私に任されているので、私がこれと思う人に差し上げるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ですから、もしあなたが私を拝むなら、すべてをあなたのものとしましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","イエスは答えて言われた。「『あなたの神である主を拝み、主にだけ仕えなさい。』と書いてある。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","また、悪魔はイエスをエルサレムに連れて行き、神殿の頂に立たせて、こう言った。「あなたが神の子なら、ここから飛び降りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","『神は、御使いたちに命じてあなたを守らせる。』とも、 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","『あなたの足が石に打ち当たることのないように、彼らの手で、あなたをささえさせる。』とも書いてあるからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","するとイエスは答えて言われた。「『あなたの神である主を試みてはならない。』と言われている。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","誘惑の手を尽くしたあとで、悪魔はしばらくの間イエスから離れた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","イエスは御霊の力を帯びてガリラヤに帰られた。すると、その評判が回り一帯に、くまなく広まった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","イエスは、彼らの会堂で教え、みなの人にあがめられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","それから、イエスはご自分の育ったナザレに行き、いつものとおり安息日に会堂にはいり、朗読しようとして立たれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","すると、預言者イザヤの書が手渡されたので、その書を開いて、こう書いてある所を見つけられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","「わたしの上に主の御霊がおられる。 主が、貧しい人々に福音を伝えるようにと、 わたしに油を注がれたのだから。 主はわたしを遣わされた。 捕われ人には赦免を、 盲人には目の開かれることを告げるために。 しいたげられている人々を自由にし、 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","主の恵みの年を告げ知らせるために。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","イエスは書を巻き、係りの者に渡してすわられた。会堂にいるみなの目がイエスに注がれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","イエスは人々にこう言って話し始められた。「きょう、聖書のこのみことばが、あなたがたが聞いたとおり実現しました。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","みなイエスをほめ、その口から出て来る恵みのことばに驚いた。そしてまた、「この人は、ヨセフの子ではないか。」と彼らは言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","イエスは言われた。「きっとあなたがたは、『医者よ。自分を直せ。』というたとえを引いて、カペナウムで行なわれたと聞いていることを、あなたの郷里のここでもしてくれ、と言うでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","また、こう言われた。「まことに、あなたがたに告げます。預言者はだれでも、自分の郷里では歓迎されません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","わたしが言うのは真実のことです。エリヤの時代に、三年六か月の間天が閉じて、全国に大ききんが起こったとき、イスラエルにもやもめは多くいたが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","エリヤはだれのところにも遣わされず、シドンのサレプタにいたやもめ女にだけ遣わされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","また、預言者エリシャのときに、イスラエルには、らい病人がたくさんいたが、そのうちのだれもきよめられないで、シリヤ人ナアマンだけがきよめられました。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","これらのことを聞くと、会堂にいた人たちはみな、ひどく怒り、 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","立ち上がってイエスを町の外に追い出し、町が立っていた丘のがけのふちまで連れて行き、そこから投げ落とそうとした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","しかしイエスは、彼らの真中を通り抜けて、行ってしまわれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","それからイエスは、ガリラヤの町カペナウムに下られた。そして、安息日ごとに、人々を教えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","人々は、その教えに驚いた。そのことばに権威があったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","また、会堂に、汚れた悪霊につかれた人がいて、大声でわめいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","「ああ、ナザレ人のイエス。いったい私たちに何をしようというのです。あなたは私たちを滅ぼしに来たのでしょう。私はあなたがどなたか知っています。神の聖者です。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","イエスは彼をしかって、「黙れ。その人から出て行け。」と言われた。するとその悪霊は人々の真中で、その人を投げ倒して出て行ったが、その人は別に何の害も受けなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","人々はみな驚いて、互いに話し合った。「今のおことばはどうだ。権威と力とでお命じになったので、汚れた霊でも出て行ったのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","こうしてイエスのうわさは、回りの地方の至る所に広まった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","イエスは立ち上がって会堂を出て、シモンの家にはいられた。すると、シモンのしゅうとめが、ひどい熱で苦しんでいた。人々は彼女のためにイエスにお願いした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","イエスがその枕もとに来て、熱をしかりつけられると、熱がひき、彼女はすぐに立ち上がって彼らをもてなし始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","日が暮れると、いろいろな病気で弱っている者をかかえた人たちがみな、その病人をみもとに連れて来た。イエスは、ひとりひとりに手を置いて、いやされた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","また、悪霊どもも、「あなたこそ神の子です。」と大声で叫びながら、多くの人から出て行った。イエスは、悪霊どもをしかって、ものを言うのをお許しにならなかった。彼らはイエスがキリストであることを知っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","朝になって、イエスは寂しい所に出て行かれた。群衆は、イエスを捜し回って、みもとに来ると、イエスが自分たちから離れて行かないよう引き止めておこうとした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","しかしイエスは、彼らにこう言われた。「ほかの町々にも、どうしても神の国の福音を宣べ伝えなければなりません。わたしは、そのために遣わされたのですから。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","そしてユダヤの諸会堂で、福音を告げ知らせておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","群衆がイエスに押し迫るようにして神のことばを聞いたとき、イエスはゲネサレ湖の岸べに立っておられたが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","岸べに小舟が二そうあるのをご覧になった。漁師たちは、その舟から降りて網を洗っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","イエスは、そのうちの一つの、シモンの持ち舟に乗り、陸から少し漕ぎ出すように頼まれた。そしてイエスはすわって、舟から群衆を教えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","話が終わると、シモンに、「深みに漕ぎ出して、網をおろして魚をとりなさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","するとシモンが答えて言った。「先生。私たちは、夜通し働きましたが、何一つとれませんでした。でもおことばどおり、網をおろしてみましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","そして、そのとおりにすると、たくさんの魚がはいり、網は破れそうになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","そこで別の舟にいた仲間の者たちに合図をして、助けに来てくれるように頼んだ。彼らがやって来て、そして魚を両方の舟いっぱいに上げたところ、二そうとも沈みそうになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","これを見たシモン・ペテロは、イエスの足もとにひれ伏して、「主よ。私のような者から離れてください。私は、罪深い人間ですから。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","それは、大漁のため、彼もいっしょにいたみなの者も、ひどく驚いたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","シモンの仲間であったゼベダイの子ヤコブやヨハネも同じであった。イエスはシモンにこう言われた。「こわがらなくてもよい。これから後、あなたは人間をとるようになるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","彼らは、舟を陸に着けると、何もかも捨てて、イエスに従った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","さて、イエスがある町におられたとき、全身らい病の人がいた。イエスを見ると、ひれ伏してお願いした。「主よ。お心一つで、私はきよくしていただけます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","イエスは手を伸ばして、彼にさわり、「わたしの心だ。きよくなれ。」と言われた。すると、すぐに、そのらい病が消えた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","イエスは、彼にこう命じられた。「だれにも話してはいけない。ただ祭司のところに行って、自分を見せなさい。そして人々へのあかしのため、モーセが命じたように、あなたのきよめの供え物をしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","しかし、イエスのうわさは、ますます広まり、多くの人の群れが、話を聞きに、また、病気を直してもらいに集まって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","しかし、イエスご自身は、よく荒野に退いて祈っておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ある日のこと、イエスが教えておられると、パリサイ人と律法の教師たちも、そこにすわっていた。彼らは、ガリラヤとユダヤとのすべての村々や、エルサレムから来ていた。イエスは、主の御力をもって、病気を直しておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","するとそこに、男たちが、中風をわずらっている人を、床のままで運んで来た。そして、何とかして家の中に運び込み、イエスの前に置こうとしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","しかし、大ぜい人がいて、どうにも病人を運び込む方法が見つからないので、屋上に上って屋根の瓦をはがし、そこから彼の寝床を、ちょうど人々の真中のイエスの前に、つり降ろした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","彼らの信仰を見て、イエスは「友よ。あなたの罪は赦されました。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ところが、律法学者、パリサイ人たちは、理屈を言い始めた。「神をけがすことを言うこの人は、いったい何者だ。神のほかに、だれが罪を赦すことができよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","その理屈を見抜いておられたイエスは、彼らに言われた。「なぜ、心の中でそんな理屈を言っているのか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","『あなたの罪は赦された。』と言うのと、『起きて歩け。』と言うのと、どちらがやさしいか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","人の子が地上で罪を赦す権威を持っていることを、あなたがたに悟らせるために。」と言って、中風の人に、「あなたに命じる。起きなさい。寝床をたたんで、家に帰りなさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","すると彼は、たちどころに人々の前で立ち上がり、寝ていた床をたたんで、神をあがめながら自分の家に帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","人々はみな、ひどく驚き、神をあがめ、恐れに満たされて、「私たちは、きょう、驚くべきことを見た。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","この後、イエスは出て行き、収税所にすわっているレビという取税人に目を留めて、「わたしについて来なさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","するとレビは、何もかも捨て、立ち上がってイエスに従った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","そこでレビは、自分の家でイエスのために大ぶるまいをしたが、取税人たちや、ほかに大ぜいの人たちが食卓に着いていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","すると、パリサイ人やその派の律法学者たちが、イエスの弟子たちに向かって、つぶやいて言った。「なぜ、あなたがたは、取税人や罪人どもといっしょに飲み食いするのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","そこで、イエスは答えて言われた。「医者を必要とするのは丈夫な者ではなく、病人です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","わたしは正しい人を招くためではなく、罪人を招いて、悔い改めさせるために来たのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","彼らはイエスに言った。「ヨハネの弟子たちは、よく断食をしており、祈りもしています。また、パリサイ人の弟子たちも同じなのに、あなたの弟子たちは食べたり飲んだりしています。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","イエスは彼らに言われた。「花婿がいっしょにいるのに、花婿につき添う友だちに断食させることが、あなたがたにできますか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","しかし、やがてその時が来て、花婿が取り去られたら、その日には彼らは断食します。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","イエスはまた一つのたとえを彼らに話された。「だれも、新しい着物から布切れを引き裂いて、古い着物に継ぎをするようなことはしません。そんなことをすれば、その新しい着物を裂くことになるし、また新しいのを引き裂いた継ぎ切れも、古い物には合わないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","また、だれも新しいぶどう酒を古い皮袋に入れるようなことはしません。そんなことをすれば、新しいぶどう酒は皮袋を張り裂き、ぶどう酒は流れ出て、皮袋もだめになってしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","新しいぶどう酒は新しい皮袋に入れなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","また、だれでも古いぶどう酒を飲んでから、新しい物を望みはしません。『古い物は良い。』と言うのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ある安息日に、イエスが麦畑を通っておられたとき、弟子たちは麦の穂を摘んで、手でもみ出しては食べていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","すると、あるパリサイ人たちが言った。「なぜ、あなたがたは、安息日にしてはならないことをするのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","イエスは彼らに答えて言われた。「あなたがたは、ダビデが連れの者といっしょにいて、ひもじかったときにしたことを読まなかったのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ダビデは神の家にはいって、祭司以外の者はだれも食べてはならない供えのパンを取って、自分も食べたし、供の者にも与えたではありませんか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","そして、彼らに言われた。「人の子は、安息日の主です。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","別の安息日に、イエスは会堂にはいって教えておられた。そこに右手のなえた人がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","そこで律法学者、パリサイ人たちは、イエスが安息日に人を直すかどうか、じっと見ていた。彼を訴える口実を見つけるためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","イエスは彼らの考えをよく知っておられた。それで、手のなえた人に、「立って、真中に出なさい。」と言われた。その人は、起き上がって、そこに立った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","イエスは人々に言われた。「あなたがたに聞きますが、安息日にしてよいのは、善を行なうことなのか、それとも悪を行なうことなのか。いのちを救うことなのか、それとも失うことなのか、どうですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","そして、みなの者を見回してから、その人に、「手を伸ばしなさい。」と言われた。そのとおりにすると、彼の手は元どおりになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","すると彼らはすっかり分別を失ってしまって、イエスをどうしてやろうかと話し合った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","このころ、イエスは祈るために山に行き、神に祈りながら夜を明かされた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","夜明けになって、弟子たちを呼び寄せ、その中から十二人を選び、彼らに使徒という名をつけられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","すなわち、ペテロという名をいただいたシモンとその兄弟アンデレ、ヤコブとヨハネ、ピリポとバルトロマイ、 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","マタイとトマス、アルパヨの子ヤコブと熱心党員と呼ばれるシモン、 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ヤコブの子ユダとイエスを裏切ったイスカリオテ・ユダである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","それから、イエスは、彼らとともに山を下り、平らな所にお立ちになったが、多くの弟子たちの群れや、ユダヤ全土、エルサレム、さてはツロやシドンの海べから来た大ぜいの民衆がそこにいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","イエスの教えを聞き、また病気を直していただくために来た人々である。また、汚れた霊に悩まされていた人たちもいやされた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","群衆のだれもが何とかしてイエスにさわろうとしていた。大きな力がイエスから出て、すべての人をいやしたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","イエスは目を上げて弟子たちを見つめながら、話しだされた。「貧しい者は幸いです。神の国はあなたがたのものですから。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","いま飢えている者は幸いです。あなたがたは、やがて飽くことができますから。 いま泣いている者は幸いです。あなたがたは、いまに笑うようになりますから。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","人の子のために、人々があなたがたを憎むとき、また、あなたがたを除名し、はずかしめ、あなたがたの名をあしざまにけなすとき、あなたがたは幸いです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","その日には、喜びなさい。おどり上がって喜びなさい。天ではあなたがたの報いは大きいからです。彼らの先祖も、預言者たちをそのように扱ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","しかし、富んでいるあなたがたは、哀れな者です。慰めを、すでに受けているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","いま食べ飽きているあなたがたは、哀れな者です。やがて、飢えるようになるからです。いま笑っているあなたがたは、哀れな者です。やがて悲しみ泣くようになるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","みなの人にほめられるときは、あなたがたは哀れな者です。彼らの先祖は、にせ預言者たちをそのように扱ったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","しかし、いま聞いているあなたがたに、わたしはこう言います。あなたの敵を愛しなさい。あなたを憎む者に善を行ないなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","あなたをのろう者を祝福しなさい。あなたを侮辱する者のために祈りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","あなたの片方の頬を打つ者には、ほかの頬をも向けなさい。上着を奪い取る者には、下着も拒んではいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","すべて求める者には与えなさい。奪い取る者からは取り戻してはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","自分にしてもらいたいと望むとおり、人にもそのようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","自分を愛する者を愛したからといって、あなたがたに何の良いところがあるでしょう。罪人たちでさえ、自分を愛する者を愛しています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","自分に良いことをしてくれる者に良いことをしたからといって、あなたがたに何の良いところがあるでしょう。罪人たちでさえ、同じことをしています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","返してもらうつもりで人に貸してやったからといって、あなたがたに何の良いところがあるでしょう。貸した分を取り返すつもりなら、罪人たちでさえ、罪人たちに貸しています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ただ、自分の敵を愛しなさい。彼らによくしてやり、返してもらうことを考えずに貸しなさい。そうすれば、あなたがたの受ける報いはすばらしく、あなたがたは、いと高き方の子どもになれます。なぜなら、いと高き方は、恩知らずの悪人にも、あわれみ深いからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","あなたがたの天の父があわれみ深いように、あなたがたも、あわれみ深くしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","さばいてはいけません。そうすれば、自分もさばかれません。人を罪に定めてはいけません。そうすれば、自分も罪に定められません。赦しなさい。そうすれば、自分も赦されます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","与えなさい。そうすれば、自分も与えられます。人々は量りをよくして、押しつけ、揺すり入れ、あふれるまでにして、ふところに入れてくれるでしょう。あなたがたは、人を量る量りで、自分も量り返してもらうからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","イエスはまた一つのたとえを話された。「いったい、盲人に盲人の手引きができるでしょうか。ふたりとも穴に落ち込まないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","弟子は師以上には出られません。しかし十分訓練を受けた者はみな、自分の師ぐらいにはなるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","あなたは、兄弟の目にあるちりが見えながら、どうして自分の目にある梁には気がつかないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","自分の目にある梁が見えずに、どうして兄弟に、『兄弟。あなたの目のちりを取らせてください。』と言えますか。偽善者たち。まず自分の目から梁を取りのけなさい。そうしてこそ、兄弟の目のちりがはっきり見えて、取りのけることができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","悪い実を結ぶ良い木はないし、良い実を結ぶ悪い木もありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","木はどれでも、その実によってわかるものです。いばらからいちじくは取れず、野ばらからぶどうを集めることはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","良い人は、その心の良い倉から良い物を出し、悪い人は、悪い倉から悪い物を出します。なぜなら人の口は、心に満ちているものを話すからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","なぜ、わたしを『主よ、主よ。』と呼びながら、わたしの言うことを行なわないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","わたしのもとに来て、わたしのことばを聞き、それを行なう人たちがどんな人に似ているか、あなたがたに示しましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","その人は、地面を深く掘り下げ、岩の上に土台を据えて、それから家を建てた人に似ています。洪水になり、川の水がその家に押し寄せたときも、しっかり建てられていたから、びくともしませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","聞いても実行しない人は、土台なしで地面に家を建てた人に似ています。川の水が押し寄せると、家は一ぺんに倒れてしまい、そのこわれ方はひどいものとなりました。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","イエスは、耳を傾けている民衆にこれらのことばをみな話し終えられると、カペナウムにはいられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ところが、ある百人隊長に重んじられているひとりのしもべが、病気で死にかけていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","百人隊長は、イエスのことを聞き、みもとにユダヤ人の長老たちを送って、しもべを助けに来てくださるようお願いした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","イエスのもとに来たその人たちは、熱心にお願いして言った。「この人は、あなたにそうしていただく資格のある人です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","この人は、私たちの国民を愛し、私たちのために会堂を建ててくれた人です。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","イエスは、彼らといっしょに行かれた。そして、百人隊長の家からあまり遠くない所に来られたとき、百人隊長は友人たちを使いに出して、イエスに伝えた。「主よ。わざわざおいでくださいませんように。あなたを私の屋根の下にお入れする資格は、私にはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ですから、私のほうから伺うことさえ失礼と存じました。ただ、おことばをいただかせてください。そうすれば、私のしもべは必ずいやされます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","と申しますのは、私も権威の下にある者ですが、私の下にも兵士たちがいまして、そのひとりに『行け。』と言えば行きますし、別の者に『来い。』と言えば来ます。また、しもべに『これをせよ。』と言えば、そのとおりにいたします。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","これを聞いて、イエスは驚かれ、ついて来ていた群衆のほうに向いて言われた。「あなたがたに言いますが、このようなりっぱな信仰は、イスラエルの中にも見たことがありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","使いに来た人たちが家に帰ってみると、しもべはよくなっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","それから間もなく、イエスはナインという町に行かれた。弟子たちと大ぜいの人の群れがいっしょに行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","イエスが町の門に近づかれると、やもめとなった母親のひとり息子が、死んでかつぎ出されたところであった。町の人たちが大ぜいその母親につき添っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","主はその母親を見てかわいそうに思い、「泣かなくてもよい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","そして近寄って棺に手をかけられると、かついでいた人たちが立ち止まったので、「青年よ。あなたに言う、起きなさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","すると、その死人が起き上がって、ものを言い始めたので、イエスは彼を母親に返された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","人々は恐れを抱き、「大預言者が私たちのうちに現われた。」とか、「神がその民を顧みてくださった。」などと言って、神をあがめた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","イエスについてこの話がユダヤ全土と回りの地方一帯に広まった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","さて、ヨハネの弟子たちは、これらのことをすべてヨハネに報告した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","すると、ヨハネは、弟子の中からふたりを呼び寄せて、主のもとに送り、「おいでになるはずの方は、あなたですか。それとも、私たちはほかの方を待つべきでしょうか。」と言わせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ふたりはみもとに来て言った。「バプテスマのヨハネから遣わされてまいりました。『おいでになるはずの方は、あなたですか。それとも私たちはなおほかの方を待つべきでしょうか。』とヨハネが申しております。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ちょうどそのころ、イエスは、多くの人々を病気と苦しみと悪霊からいやし、また多くの盲人を見えるようにされた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","そして、答えてこう言われた。「あなたがたは行って、自分たちの見たり聞いたりしたことをヨハネに報告しなさい。盲人が見えるようになり、足なえが歩き、らい病人がきよめられ、つんぼの人が聞こえ、死人が生き返り、貧しい者に福音が宣べ伝えられています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","だれでも、わたしにつまずかない者は幸いです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ヨハネの使いが帰ってから、イエスは群衆に、ヨハネについて話しだされた。「あなたがたは、何を見に荒野に出て行ったのですか。風に揺れる葦ですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","でなかったら、何を見に行ったのですか。柔らかい着物を着た人ですか。きらびやかな着物を着て、ぜいたくに暮らしている人たちなら宮殿にいます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","でなかったら、何を見に行ったのですか。預言者ですか。そのとおり。だが、わたしが言いましょう。預言者よりもすぐれた者をです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","その人こそ、 『見よ、わたしは使いをあなたの前に遣わし、 あなたの道を、あなたの前に備えさせよう。』 と書かれているその人です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","あなたがたに言いますが、女から生まれた者の中で、ヨハネよりもすぐれた人は、ひとりもいません。しかし、神の国で一番小さい者でも、彼よりすぐれています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ヨハネの教えを聞いたすべての民は、取税人たちさえ、ヨハネのバプテスマを受けて、神の正しいことを認めたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","これに反して、パリサイ人、律法の専門家たちは、彼からバプテスマを受けないで、神の自分たちに対するみこころを拒みました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","では、この時代の人々は、何にたとえたらよいでしょう。何に似ているでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","市場にすわって、互いに呼びかけながら、こう言っている子どもたちに似ています。 『笛を吹いてやっても、君たちは踊らなかった。 弔いの歌を歌ってやっても、泣かなかった。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","というわけは、バプテスマのヨハネが来て、パンも食べず、ぶどう酒も飲まずにいると、『あれは悪霊につかれている。』とあなたがたは言うし、 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","人の子が来て、食べもし、飲みもすると、『あれ見よ。食いしんぼうの大酒飲み、取税人や罪人の仲間だ。』と言うのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","だが、知恵の正しいことは、そのすべての子どもたちが証明します。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","さて、あるパリサイ人が、いっしょに食事をしたい、とイエスを招いたので、そのパリサイ人の家にはいって食卓に着かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","すると、その町にひとりの罪深い女がいて、イエスがパリサイ人の家で食卓に着いておられることを知り、香油のはいった石膏のつぼを持って来て、 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","泣きながら、イエスのうしろで御足のそばに立ち、涙で御足をぬらし始め、髪の毛でぬぐい、御足に口づけして、香油を塗った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","イエスを招いたパリサイ人は、これを見て、「この方がもし預言者なら、自分にさわっている女がだれで、どんな女であるか知っておられるはずだ。この女は罪深い者なのだから。」と心ひそかに思っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","するとイエスは、彼に向かって、「シモン。あなたに言いたいことがあります。」と言われた。シモンは、「先生。お話しください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","「ある金貸しから、ふたりの者が金を借りていた。ひとりは五百デナリ、ほかのひとりは五十デナリ借りていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","彼らは返すことができなかったので、金貸しはふたりとも赦してやった。 では、ふたりのうちどちらがよけいに金貸しを愛するようになるでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","シモンが、「よけいに赦してもらったほうだと思います。」と答えると、イエスは、「あなたの判断は当たっています。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","そしてその女のほうを向いて、シモンに言われた。「この女を見ましたか。わたしがこの家にはいって来たとき、あなたは足を洗う水をくれなかったが、この女は、涙でわたしの足をぬらし、髪の毛でぬぐってくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","あなたは、口づけしてくれなかったが、この女は、わたしがはいって来たときから足に口づけしてやめませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","あなたは、わたしの頭に油を塗ってくれなかったが、この女は、わたしの足に香油を塗ってくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","だから、わたしは言うのです。『この女の多くの罪は赦されています。というのは、彼女はよけい愛したからです。しかし少ししか赦されない者は、少ししか愛しません。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","そして女に、「あなたの罪は赦されています。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","すると、いっしょに食卓にいた人たちは、心の中でこう言い始めた。「罪を赦したりするこの人は、いったいだれだろう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","しかし、イエスは女に言われた。「あなたの信仰が、あなたを救ったのです。安心して行きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","その後、イエスは、神の国を説き、その福音を宣べ伝えながら、町や村を次から次に旅をしておられた。十二弟子もお供をした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","また、悪霊や病気を直していただいた女たち、すなわち、七つの悪霊を追い出していただいたマグダラの女と呼ばれるマリヤ、 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ヘロデの執事クーザの妻ヨハンナ、スザンナ、そのほか自分の財産をもって彼らに仕えている大ぜいの女たちもいっしょであった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","さて、大ぜいの人の群れが集まり、また方々の町からも人々がみもとにやって来たので、イエスはたとえを用いて話された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","「種を蒔く人が種蒔きに出かけた。蒔いているとき、道ばたに落ちた種があった。すると、人に踏みつけられ、空の鳥がそれを食べてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","また、別の種は岩の上に落ち、生え出たが、水分がなかったので、枯れてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","また、別の種はいばらの真中に落ちた。ところが、いばらもいっしょに生え出て、それを押しふさいでしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","また、別の種は良い地に落ち、生え出て、百倍の実を結んだ。」 イエスは、これらのことを話しながら「聞く耳のある者は聞きなさい。」と叫ばれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","さて、弟子たちは、このたとえがどんな意味かをイエスに尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","そこでイエスは言われた。「あなたがたに、神の国の奥義を知ることが許されているが、ほかの者には、たとえで話します。彼らが見ていても見えず、聞いていても悟らないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","このたとえの意味はこうです。種は神のことばです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","道ばたに落ちるとは、こういう人たちのことです。みことばを聞いたが、あとから悪魔が来て、彼らが信じて救われることのないように、その人たちの心から、みことばを持ち去ってしまうのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","岩の上に落ちるとは、こういう人たちのことです。聞いたときには喜んでみことばを受け入れるが、根がないので、しばらくは信じていても、試練のときになると、身を引いてしまうのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","いばらの中に落ちるとは、こういう人たちのことです。みことばを聞きはしたが、とかくしているうちに、この世の心づかいや、富や、快楽によってふさがれて、実が熟するまでにならないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","しかし、良い地に落ちるとは、こういう人たちのことです。正しい、良い心でみことばを聞くと、それをしっかりと守り、よく耐えて、実を結ばせるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","あかりをつけてから、それを器で隠したり、寝台の下に置いたりする者はありません。燭台の上に置きます。はいって来る人々に、その光が見えるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","隠れているもので、あらわにならぬものはなく、秘密にされているもので、知られず、また現われないものはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","だから、聞き方に注意しなさい。というのは、持っている人は、さらに与えられ、持たない人は、持っていると思っているものまでも取り上げられるからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","イエスのところに母と兄弟たちが来たが、群衆のためにそばへ近寄れなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","それでイエスに、「あなたのおかあさんと兄弟たちが、あなたに会おうとして、外に立っています。」という知らせがあった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ところが、イエスは人々にこう答えられた。「わたしの母、わたしの兄弟たちとは、神のことばを聞いて行なう人たちです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","そのころのある日のこと、イエスは弟子たちといっしょに舟に乗り、「さあ、湖の向こう岸へ渡ろう。」と言われた。それで弟子たちは舟を出した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","舟で渡っている間にイエスはぐっすり眠ってしまわれた。ところが突風が湖に吹きおろして来たので、弟子たちは水をかぶって危険になった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","そこで、彼らは近寄って行ってイエスを起こし、「先生、先生。私たちはおぼれて死にそうです。」と言った。イエスは、起き上がって、風と荒波とをしかりつけられた。すると風も波も治まり、なぎになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","イエスは彼らに、「あなたがたの信仰はどこにあるのです。」と言われた。弟子たちは驚き恐れて互いに言った。「風も水も、お命じになれば従うとは、いったいこの方はどういう方なのだろう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","こうして彼らは、ガリラヤの向こう側のゲラサ人の地方に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","イエスが陸に上がられると、この町の者で悪霊につかれている男がイエスに出会った。彼は、長い間着物も着けず、家には住まないで、墓場に住んでいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","彼はイエスを見ると、叫び声をあげ、御前にひれ伏して大声で言った。「いと高き神の子、イエスさま。いったい私に何をしようというのです。お願いです。どうか私を苦しめないでください。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","それは、イエスが、汚れた霊に、この人から出て行け、と命じられたからである。汚れた霊が何回となくこの人を捕えたので、彼は鎖や足かせでつながれて看視されていたが、それでもそれらを断ち切っては悪霊によって荒野に追いやられていたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","イエスが、「何という名か。」とお尋ねになると、「レギオンです。」と答えた。悪霊が大ぜい彼にはいっていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","悪霊どもはイエスに、底知れぬ所に行け、とはお命じになりませんようにと願った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ちょうど、山のそのあたりに、おびただしい豚の群れが飼ってあったので、悪霊どもは、その豚にはいることを許してくださいと願った。イエスはそれを許された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","悪霊どもは、その人から出て、豚にはいった。すると、豚の群れはいきなりがけを駆け下って湖にはいり、おぼれ死んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","飼っていた者たちは、この出来事を見て逃げ出し、町や村々でこの事を告げ知らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","人々が、この出来事を見に来て、イエスのそばに来たところ、イエスの足もとに、悪霊の去った男が着物を着て、正気に返って、すわっていた。人々は恐ろしくなった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","目撃者たちは、悪霊につかれていた人の救われた次第を、その人々に知らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ゲラサ地方の民衆はみな、すっかりおびえてしまい、イエスに自分たちのところから離れていただきたいと願った。そこで、イエスは舟に乗って帰られた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","そのとき、悪霊を追い出された人が、お供をしたいとしきりに願ったが、イエスはこう言って彼を帰された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","「家に帰って、神があなたにどんなに大きなことをしてくださったかを、話して聞かせなさい。」そこで彼は出て行って、イエスが自分にどんなに大きなことをしてくださったかを、町中に言い広めた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","さて、イエスが帰られると、群衆は喜んで迎えた。みなイエスを待ちわびていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","するとそこに、ヤイロという人が来た。この人は会堂管理者であった。彼はイエスの足もとにひれ伏して自分の家に来ていただきたいと願った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","彼には十二歳ぐらいのひとり娘がいて、死にかけていたのである。イエスがお出かけになると、群衆がみもとに押し迫って来た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ときに、十二年の間長血をわずらった女がいた。だれにも直してもらえなかったこの女は、 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","イエスのうしろに近寄って、イエスの着物のふさにさわった。すると、たちどころに出血が止まった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","イエスは、「わたしにさわったのは、だれですか。」と言われた。みな自分ではないと言ったので、ペテロは、「先生。この大ぜいの人が、ひしめき合って押しているのです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","しかし、イエスは、「だれかが、わたしにさわったのです。わたしから力が出て行くのを感じたのだから。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","女は、隠しきれないと知って、震えながら進み出て、御前にひれ伏し、すべての民の前で、イエスにさわったわけと、たちどころにいやされた次第とを話した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","そこで、イエスは彼女に言われた。「娘よ。あなたの信仰があなたを直したのです。安心して行きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","イエスがまだ話しておられるときに、会堂管理者の家から人が来て言った。「あなたのお嬢さんはなくなりました。もう、先生を煩わすことはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","これを聞いて、イエスは答えられた。「恐れないで、ただ信じなさい。そうすれば、娘は直ります。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","イエスは家にはいられたが、ペテロとヨハネとヤコブ、それに子どもの父と母のほかは、だれもいっしょにはいることをお許しにならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","人々はみな、娘のために泣き悲しんでいた。しかし、イエスは言われた。「泣かなくてもよい。死んだのではない。眠っているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","人々は、娘が死んだことを知っていたので、イエスをあざ笑っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","しかしイエスは、娘の手を取って、叫んで言われた。「子どもよ。起きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","すると、娘の霊が戻って、娘はただちに起き上がった。それでイエスは、娘に食事をさせるように言いつけられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","両親がひどく驚いていると、イエスは、この出来事をだれにも話さないように命じられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","イエスは、十二人を呼び集めて、彼らに、すべての悪霊を追い出し、病気を直すための、力と権威とをお授けになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","それから、神の国を宣べ伝え、病気を直すために、彼らを遣わされた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","イエスは、こう言われた。「旅のために何も持って行かないようにしなさい。杖も、袋も、パンも、金も。また下着も、二枚は、いりません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","どんな家にはいっても、そこにとどまり、そこから次の旅に出かけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","人々があなたがたを受け入れないばあいは、その町を出て行くときに、彼らに対する証言として、足のちりを払い落としなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","十二人は出かけて行って、村から村へと回りながら、至る所で福音を宣べ伝え、病気を直した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","さて、国主ヘロデは、このすべての出来事を聞いて、ひどく当惑していた。それは、ある人々が、「ヨハネが死人の中からよみがえったのだ。」と言い、 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ほかの人々は、「エリヤが現われたのだ。」と言い、さらに別の人々は、「昔の預言者のひとりがよみがえったのだ。」と言っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ヘロデは言った。「ヨハネなら、私が首をはねたのだ。そうしたことがうわさされているこの人は、いったいだれなのだろう。」ヘロデはイエスに会ってみようとした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","さて、使徒たちは帰って来て、自分たちのして来たことを報告した。それからイエスは彼らを連れてベツサイダという町へひそかに退かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ところが、多くの群衆がこれを知って、ついて来た。それで、イエスは喜んで彼らを迎え、神の国のことを話し、また、いやしの必要な人たちをおいやしになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","そのうち、日も暮れ始めたので、十二人はみもとに来て、「この群衆を解散させてください。そして回りの村や部落にやって、宿をとらせ、何か食べることができるようにさせてください。私たちは、こんな人里離れた所にいるのですから。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","しかしイエスは、彼らに言われた。「あなたがたで、何か食べる物を上げなさい。」彼らは言った。「私たちには五つのパンと二匹の魚のほか何もありません。私たちが出かけて行って、この民全体のために食物を買うのでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","それは、男だけでおよそ五千人もいたからである。しかしイエスは、弟子たちに言われた。「人々を、五十人ぐらいずつ組にしてすわらせなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","弟子たちは、そのようにして、全部をすわらせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","するとイエスは、五つのパンと二匹の魚を取り、天を見上げて、それらを祝福して裂き、群衆に配るように弟子たちに与えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","人々はみな、食べて満腹した。そして、余ったパン切れを取り集めると、十二かごあった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","さて、イエスがひとりで祈っておられたとき、弟子たちがいっしょにいた。イエスは彼らに尋ねて言われた。「群衆はわたしのことをだれだと言っていますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","彼らは、答えて言った。「バプテスマのヨハネだと言っています。ある者はエリヤだと言い、またほかの人々は、昔の預言者のひとりが生き返ったのだとも言っています。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","イエスは、彼らに言われた。「では、あなたがたは、わたしをだれだと言いますか。」ペテロが答えて言った。「神のキリストです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","するとイエスは、このことをだれにも話さないようにと、彼らを戒めて命じられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","そして言われた。「人の子は、必ず多くの苦しみを受け、長老、祭司長、律法学者たちに捨てられ、殺され、そして三日目によみがえらねばならないのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","イエスは、みなの者に言われた。「だれでもわたしについて来たいと思うなら、自分を捨て、日々自分の十字架を負い、そしてわたしについて来なさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","自分のいのちを救おうと思う者は、それを失い、わたしのために自分のいのちを失う者は、それを救うのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","人は、たとい全世界を手に入れても、自分自身を失い、損じたら、何の得がありましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","もしだれでも、わたしとわたしのことばとを恥と思うなら、人の子も、自分と父と聖なる御使いとの栄光を帯びて来るときには、そのような人のことを恥とします。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","しかし、わたしは真実をあなたがたに告げます。ここに立っている人々の中には、神の国を見るまでは、決して死を味わわない者たちがいます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","これらの教えがあってから八日ほどして、イエスは、ペテロとヨハネとヤコブとを連れて、祈るために、山に登られた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","祈っておられると、御顔の様子が変わり、御衣は白く光り輝いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","しかも、ふたりの人がイエスと話し合っているではないか。それはモーセとエリヤであって、 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","栄光のうちに現われて、イエスがエルサレムで遂げようとしておられるご最期についていっしょに話していたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ペテロと仲間たちは、眠くてたまらなかったが、はっきり目がさめると、イエスの栄光と、イエスといっしょに立っているふたりの人を見た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","それから、ふたりがイエスと別れようとしたとき、ペテロがイエスに言った。「先生。ここにいることは、すばらしいことです。私たちが三つの幕屋を造ります。あなたのために一つ、モーセのために一つ、エリヤのために一つ。」ペテロは何を言うべきかを知らなかったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","彼がこう言っているうちに、雲がわき起こってその人々をおおった。彼らが雲に包まれると、弟子たちは恐ろしくなった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","すると雲の中から、「これは、わたしの愛する子、わたしの選んだ者である。彼の言うことを聞きなさい。」と言う声がした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","この声がしたとき、そこに見えたのはイエスだけであった。彼らは沈黙を守り、その当時は、自分たちの見たこのことをいっさい、だれにも話さなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","次の日、一行が山から降りて来ると、大ぜいの人の群れがイエスを迎えた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","すると、群衆の中から、ひとりの人が叫んで言った。「先生。お願いです。息子を見てやってください。ひとり息子です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ご覧ください。霊がこの子に取りつきますと、突然叫び出すのです。そしてひきつけさせてあわを吹かせ、かき裂いて、なかなか離れようとしません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","お弟子たちに、この霊を追い出してくださるようお願いしたのですが、お弟子たちにはできませんでした。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","イエスは答えて言われた。「ああ、不信仰な、曲がった今の世だ。いつまで、あなたがたといっしょにいて、あなたがたにがまんしていなければならないのでしょう。あなたの子をここに連れて来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","その子が近づいて来る間にも、悪霊は彼を打ち倒して、激しくひきつけさせてしまった。それで、イエスは汚れた霊をしかって、その子をいやし、父親に渡された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","人々はみな、神のご威光に驚嘆した。 イエスのなさったすべてのことに、人々がみな驚いていると、イエスは弟子たちにこう言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","「このことばを、しっかりと耳に入れておきなさい。人の子は、いまに人々の手に渡されます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","しかし、弟子たちは、このみことばが理解できなかった。このみことばの意味は、わからないように、彼らから隠されていたのである。また彼らは、このみことばについてイエスに尋ねるのを恐れた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","さて、弟子たちの間に、自分たちの中で、だれが一番偉いかという議論が持ち上がった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","しかしイエスは、彼らの心の中の考えを知っておられて、ひとりの子どもの手を取り、自分のそばに立たせ、 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","彼らに言われた。「だれでも、このような子どもを、わたしの名のゆえに受け入れる者は、わたしを受け入れる者です。また、わたしを受け入れる者は、わたしを遣わされた方を受け入れる者です。あなたがたすべての中で一番小さい者が一番偉いのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ヨハネが答えて言った。「先生。私たちは、先生の名を唱えて悪霊を追い出している者を見ましたが、やめさせました。私たちの仲間ではないので、やめさせたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","しかしイエスは、彼に言われた。「やめさせることはありません。あなたがたに反対しない者は、あなたがたの味方です。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","さて、天に上げられる日が近づいて来たころ、イエスは、エルサレムに行こうとして御顔をまっすぐ向けられ、 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ご自分の前に使いを出された。彼らは行って、サマリヤ人の町にはいり、イエスのために準備した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","しかし、イエスは御顔をエルサレムに向けて進んでおられたので、サマリヤ人はイエスを受け入れなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","弟子のヤコブとヨハネが、これを見て言った。「主よ。私たちが天から火を呼び下して、彼らを焼き滅ぼしましょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","しかし、イエスは振り向いて、彼らを戒められた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","そして一行は別の村に行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","さて、彼らが道を進んで行くと、ある人がイエスに言った。「私はあなたのおいでになる所なら、どこにでもついて行きます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","すると、イエスは彼に言われた。「狐には穴があり、空の鳥には巣があるが、人の子には枕する所もありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","イエスは別の人に、こう言われた。「わたしについて来なさい。」しかしその人は言った。「まず行って、私の父を葬ることを許してください。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","すると彼に言われた。「死人たちに彼らの中の死人たちを葬らせなさい。あなたは出て行って、神の国を言い広めなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","別の人はこう言った。「主よ。あなたに従います。ただその前に、家の者にいとまごいに帰らせてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","するとイエスは彼に言われた。「だれでも、手を鋤につけてから、うしろを見る者は、神の国にふさわしくありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","その後、主は、別に七十人を定め、ご自分が行くつもりのすべての町や村へ、ふたりずつ先にお遣わしになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","そして、彼らに言われた。「実りは多いが、働き手が少ない。だから、収穫の主に、収穫のために働き手を送ってくださるように祈りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","さあ、行きなさい。いいですか。わたしがあなたがたを遣わすのは、狼の中に小羊を送り出すようなものです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","財布も旅行袋も持たず、くつもはかずに行きなさい。だれにも、道であいさつしてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","どんな家にはいっても、まず、『この家に平安があるように。』と言いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","もしそこに平安の子がいたら、あなたがたの祈った平安は、その人の上にとどまります。だが、もしいないなら、その平安はあなたがたに返って来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","その家に泊まっていて、出してくれる物を飲み食いしなさい。働く者が報酬を受けるのは、当然だからです。家から家へと渡り歩いてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","どの町にはいっても、あなたがたを受け入れてくれたら、出される物を食べなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","そして、その町の病人を直し、彼らに、『神の国が、あなたがたに近づいた。』と言いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","しかし、町にはいっても、人々があなたがたを受け入れないならば、大通りに出て、こう言いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","『私たちは足についたこの町のちりも、あなたがたにぬぐい捨てて行きます。しかし、神の国が近づいたことは承知していなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","あなたがたに言うが、その日には、その町よりもソドムのほうがまだ罰が軽いのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ああコラジン。ああベツサイダ。おまえたちの間に起こった力あるわざが、もしもツロとシドンでなされたのだったら、彼らはとうの昔に荒布をまとい、灰の中にすわって、悔い改めていただろう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","しかし、さばきの日には、そのツロとシドンのほうが、まだおまえたちより罰が軽いのだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","カペナウム。どうしておまえが天に上げられることがありえよう。ハデスにまで落とされるのだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","あなたがたに耳を傾ける者は、わたしに耳を傾ける者であり、あなたがたを拒む者は、わたしを拒む者です。わたしを拒む者は、わたしを遣わされた方を拒む者です。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","さて、七十人が喜んで帰って来て、こう言った。「主よ。あなたの御名を使うと、悪霊どもでさえ、私たちに服従します。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","イエスは言われた。「わたしが見ていると、サタンが、いなずまのように天から落ちました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","確かに、わたしは、あなたがたに、蛇やさそりを踏みつけ、敵のあらゆる力に打ち勝つ権威を授けたのです。だから、あなたがたに害を加えるものは何一つありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","だがしかし、悪霊どもがあなたがたに服従するからといって、喜んではなりません。ただあなたがたの名が天に書きしるされていることを喜びなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ちょうどこのとき、イエスは、聖霊によって喜びにあふれて言われた。「天地の主であられる父よ。あなたをほめたたえます。これらのことを、賢い者や知恵のある者には隠して、幼子たちに現わしてくださいました。そうです、父よ。これがみこころにかなったことでした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","すべてのものが、わたしの父から、わたしに渡されています。それで、子がだれであるかは、父のほかには知る者がありません。また父がだれであるかは、子と、子が父を知らせようと心に定めた人たちのほかは、だれも知る者がありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","それからイエスは、弟子たちのほうに向いて、ひそかに言われた。「あなたがたの見ていることを見る目は幸いです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","あなたがたに言いますが、多くの預言者や王たちがあなたがたの見ていることを見たいと願ったのに、見られなかったのです。また、あなたがたの聞いていることを聞きたいと願ったのに、聞けなかったのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","すると、ある律法の専門家が立ち上がり、イエスをためそうとして言った。「先生。何をしたら永遠のいのちを自分のものとして受けることができるでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","イエスは言われた。「律法には、何と書いてありますか。あなたはどう読んでいますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","すると彼は答えて言った。「『心を尽くし、思いを尽くし、力を尽くし、知性を尽くして、あなたの神である主を愛せよ。』また『あなたの隣人をあなた自身のように愛せよ。』とあります。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","イエスは言われた。「そのとおりです。それを実行しなさい。そうすれば、いのちを得ます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","しかし彼は、自分の正しさを示そうとしてイエスに言った。「では、私の隣人とは、だれのことですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","イエスは答えて言われた。 「ある人が、エルサレムからエリコへ下る道で、強盗に襲われた。強盗どもは、その人の着物をはぎ取り、なぐりつけ、半殺しにして逃げて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","たまたま、祭司がひとり、その道を下って来たが、彼を見ると、反対側を通り過ぎて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","同じようにレビ人も、その場所に来て彼を見ると、反対側を通り過ぎて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ところが、あるサマリヤ人が、旅の途中、そこに来合わせ、彼を見てかわいそうに思い、 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","近寄って傷にオリーブ油とぶどう酒を注いで、ほうたいをし、自分の家畜に乗せて宿屋に連れて行き、介抱してやった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","次の日、彼はデナリ二つを取り出し、宿屋の主人に渡して言った。『介抱してあげてください。もっと費用がかかったら、私が帰りに払います。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","この三人の中でだれが、強盗に襲われた者の隣人になったと思いますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","彼は言った。「その人にあわれみをかけてやった人です。」するとイエスは言われた。「あなたも行って同じようにしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","さて、彼らが旅を続けているうち、イエスがある村にはいられると、マルタという女が喜んで家にお迎えした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","彼女にマリヤという妹がいたが、主の足もとにすわって、みことばに聞き入っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ところが、マルタは、いろいろともてなしのために気が落ち着かず、みもとに来て言った。「主よ。妹が私だけにおもてなしをさせているのを、何ともお思いにならないのでしょうか。私の手伝いをするように、妹におっしゃってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","主は答えて言われた。「マルタ、マルタ。あなたは、いろいろなことを心配して、気を使っています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","しかし、どうしても必要なことはわずかです。いや、一つだけです。マリヤはその良いほうを選んだのです。彼女からそれを取り上げてはいけません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","さて、イエスはある所で祈っておられた。その祈りが終わると、弟子のひとりが、イエスに言った。「主よ。ヨハネが弟子たちに教えたように、私たちにも祈りを教えてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","そこでイエスは、彼らに言われた。「祈るときには、こう言いなさい。 『父よ。御名があがめられますように。 御国が来ますように。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","私たちの日ごとの糧を毎日お与えください。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","私たちの罪をお赦しください。私たちも私たちに負いめのある者をみな赦します。 私たちを試みに会わせないでください。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","また、イエスはこう言われた。「あなたがたのうち、だれかに友だちがいるとして、真夜中にその人のところに行き、『君。パンを三つ貸してくれ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","友人が旅の途中、私のうちへ来たのだが、出してやるものがないのだ。』と言ったとします。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","すると、彼は家の中からこう答えます。『めんどうをかけないでくれ。もう戸締まりもしてしまったし、子どもたちも私も寝ている。起きて、何かをやることはできない。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","あなたがたに言いますが、彼は友だちだからということで起きて何かを与えることはしないにしても、あくまで頼み続けるなら、そのためには起き上がって、必要な物を与えるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","わたしは、あなたがたに言います。求めなさい。そうすれば与えられます。捜しなさい。そうすれば見つかります。たたきなさい。そうすれば開かれます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","だれであっても、求める者は受け、捜す者は見つけ出し、たたく者には開かれます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","あなたがたの中で、子どもが魚を下さいと言うときに、魚の代わりに蛇を与えるような父親が、いったいいるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","卵を下さいと言うのに、だれが、さそりを与えるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","してみると、あなたがたも、悪い者ではあっても、自分の子どもには良い物を与えることを知っているのです。とすれば、なおのこと、天の父が、求める人たちに、どうして聖霊を下さらないことがありましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","イエスは悪霊、それもおしの悪霊を追い出しておられた。悪霊が出て行くと、おしがものを言い始めたので、群衆は驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","しかし、彼らのうちには、「悪霊どものかしらベルゼブルによって、悪霊どもを追い出しているのだ。」と言う者もいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","また、イエスをためそうとして、彼に天からのしるしを求める者もいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","しかし、イエスは、彼らの心を見抜いて言われた。「どんな国でも、内輪もめしたら荒れすたれ、家にしても、内輪で争えばつぶれます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","サタンも、もし仲間割れしたのだったら、どうしてサタンの国が立ち行くことができましょう。それなのにあなたがたは、わたしがベルゼブルによって悪霊どもを追い出していると言います。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","もしもわたしが、ベルゼブルによって悪霊どもを追い出しているのなら、あなたがたの仲間は、だれによって追い出すのですか。だから、あなたがたの仲間が、あなたがたをさばく人となるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","しかし、わたしが、神の指によって悪霊どもを追い出しているのなら、神の国はあなたがたに来ているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","強い人が十分に武装して自分の家を守っているときには、その持ち物は安全です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","しかし、もっと強い者が襲って来て彼に打ち勝つと、彼の頼みにしていた武具を奪い、分捕り品を分けます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","わたしの味方でない者はわたしに逆らう者であり、わたしとともに集めない者は散らす者です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","汚れた霊が人から出て行って、水のない所をさまよいながら、休み場を捜します。一つも見つからないので、『出て来た自分の家に帰ろう。』と言います。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","帰って見ると、家は、掃除をしてきちんとかたづいていました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","そこで、出かけて行って、自分よりも悪いほかの霊を七つ連れて来て、みなはいり込んでそこに住みつくのです。そうなると、その人の後の状態は、初めよりもさらに悪くなります。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","イエスが、これらのことを話しておられると、群衆の中から、ひとりの女が声を張り上げてイエスに言った。「あなたを産んだ腹、あなたが吸った乳房は幸いです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","しかし、イエスは言われた。「いや、幸いなのは、神のことばを聞いてそれを守る人たちです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","さて、群衆の数がふえて来ると、イエスは話し始められた。「この時代は悪い時代です。しるしを求めているが、ヨナのしるしのほかには、しるしは与えられません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","というのは、ヨナがニネベの人々のために、しるしとなったように、人の子がこの時代のために、しるしとなるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","南の女王が、さばきのときに、この時代の人々とともに立って、彼らを罪に定めます。なぜなら、彼女はソロモンの知恵を聞くために地の果てから来たからです。しかし、見なさい。ここにソロモンよりもまさった者がいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ニネベの人々が、さばきのときに、この時代の人々とともに立って、この人々を罪に定めます。なぜなら、ニネベの人々はヨナの説教で悔い改めたからです。しかし、見なさい。ここにヨナよりもまさった者がいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","だれも、あかりをつけてから、それを穴倉や、枡の下に置く者はいません。燭台の上に置きます。はいって来る人々に、その光が見えるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","からだのあかりは、あなたの目です。目が健全なら、あなたの全身も明るいが、しかし、目が悪いと、からだも暗くなります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","だから、あなたのうちの光が、暗やみにならないように、気をつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","もし、あなたの全身が明るくて何の暗い部分もないなら、その全身はちょうどあかりが輝いて、あなたを照らすときのように明るく輝きます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","イエスが話し終えられると、ひとりのパリサイ人が、食事をいっしょにしてください、とお願いした。そこでイエスは家にはいって、食卓に着かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","そのパリサイ人は、イエスが食事の前に、まずきよめの洗いをなさらないのを見て、驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","すると、主は言われた。「なるほど、あなたがたパリサイ人は、杯や大皿の外側はきよめるが、その内側は、強奪と邪悪とでいっぱいです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","愚かな人たち。外側を造られた方は、内側も造られたのではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","とにかく、うちのものを施しに用いなさい。そうすれば、いっさいが、あなたがたにとってきよいものとなります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","だが、忌まわしいものだ。パリサイ人。あなたがたは、はっか、うん香、あらゆる野菜などの十分の一を納めているが、公義と神への愛とはなおざりにしています。これこそ、実行しなければならない事がらです。ただし他のほうも、なおざりにしてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","忌まわしいものだ。パリサイ人。あなたがたは、会堂の上席や、市場であいさつされることが好きです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","忌まわしいことだ。あなたがたは、人目につかぬ墓のようで、その上を歩く人々も気がつかない。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","すると、ある律法の専門家が、答えて言った。「先生。そのようなことを言われることは、私たちをも侮辱することです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","しかし、イエスは言われた。「あなたがた律法の専門家たちも忌まわしいものだ。あなたがたは、人々には負いきれない荷物を負わせるが、自分は、その荷物に指一本もさわろうとはしない。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","忌まわしいことだ。あなたがたは、預言者たちの墓を建てている。しかし、あなたがたの先祖は預言者たちを殺したのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","そのようにして、あなたがたは、自分の先祖のしたことの証人となり、それを認めています。なぜなら、あなたがたの先祖が預言者たちを殺し、あなたがたがその墓を建てているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","だから、神の知恵もこう言いました。『わたしは預言者たちや使徒たちを彼らに遣わすが、彼らは、そのうちのある者を殺し、ある者を迫害する。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","それは、アベルの血から、祭壇と神の家との間で殺されたザカリヤの血に至るまでの、世の初めから流されたすべての預言者の血の責任を、この時代が問われるためである。そうだ。わたしは言う。この時代はその責任を問われる。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","52","忌まわしいものだ。律法の専門家たち。あなたがたは、知識のかぎを持ち去り、自分もはいらず、はいろうとする人々をも妨げたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","イエスがそこを出て行かれると、律法学者、パリサイ人たちのイエスに対する激しい敵対と、いろいろのことについてのしつこい質問攻めとが始まった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","彼らは、イエスの口から出ることに、言いがかりをつけようと、ひそかに計った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","そうこうしている間に、おびただしい数の群衆が集まって来て、互いに足を踏み合うほどになった。イエスはまず弟子たちに対して、話しだされた。「パリサイ人のパン種に気をつけなさい。それは彼らの偽善のことです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","おおいかぶされているもので、現わされないものはなく、隠されているもので、知られずに済むものはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ですから、あなたがたが暗やみで言ったことが、明るみで聞かれ、家の中でささやいたことが、屋上で言い広められます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","そこで、わたしの友であるあなたがたに言います。からだを殺しても、あとはそれ以上何もできない人間たちを恐れてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","恐れなければならない方を、あなたがたに教えてあげましょう。殺したあとで、ゲヘナに投げ込む権威を持っておられる方を恐れなさい。そうです。あなたがたに言います。この方を恐れなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","五羽の雀は二アサリオンで売っているでしょう。そんな雀の一羽でも、神の御前には忘れられてはいません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","それどころか、あなたがたの頭の毛さえも、みな数えられています。恐れることはありません。あなたがたは、たくさんの雀よりもすぐれた者です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","そこで、あなたがたに言います。だれでも、わたしを人の前で認める者は、人の子もまた、その人を神の御使いたちの前で認めます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","しかし、わたしを人の前で知らないと言う者は、神の御使いたちの前で知らないと言われます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","たとい、人の子をそしることばを使う者があっても、赦されます。しかし、聖霊をけがす者は赦されません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","また、人々があなたがたを、会堂や役人や権力者などのところに連れて行ったとき、何をどう弁明しようか、何を言おうかと心配するには及びません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","言うべきことは、そのときに聖霊が教えてくださるからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","群衆の中のひとりが、「先生。私と遺産を分けるように私の兄弟に話してください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","すると彼に言われた。「いったいだれが、わたしをあなたがたの裁判官や調停者に任命したのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","そして人々に言われた。「どんな貪欲にも注意して、よく警戒しなさい。なぜなら、いくら豊かな人でも、その人のいのちは財産にあるのではないからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","それから人々にたとえを話された。 「ある金持ちの畑が豊作であった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","そこで彼は、心の中でこう言いながら考えた。『どうしよう。作物をたくわえておく場所がない。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","そして言った。『こうしよう。あの倉を取りこわして、もっと大きいのを建て、穀物や財産はみなそこにしまっておこう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","そして、自分のたましいにこう言おう。「たましいよ。これから先何年分もいっぱい物がためられた。さあ、安心して、食べて、飲んで、楽しめ。」』 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","しかし神は彼に言われた。『愚か者。おまえのたましいは、今夜おまえから取り去られる。そうしたら、おまえが用意した物は、いったいだれのものになるのか。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","自分のためにたくわえても、神の前に富まない者はこのとおりです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","それから弟子たちに言われた。「だから、わたしはあなたがたに言います。いのちのことで何を食べようかと心配したり、からだのことで何を着ようかと心配したりするのはやめなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","いのちは食べ物よりたいせつであり、からだは着物よりたいせつだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","烏のことを考えてみなさい。蒔きもせず、刈り入れもせず、納屋も倉もありません。けれども、神が彼らを養っていてくださいます。あなたがたは、鳥よりも、はるかにすぐれたものです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","あなたがたのうちのだれが、心配したからといって、自分のいのちを少しでも延ばすことができますか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","こんな小さなことさえできないで、なぜほかのことまで心配するのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ゆりの花のことを考えてみなさい。どうして育つのか。紡ぎもせず、織りもしないのです。しかし、わたしはあなたがたに言います。栄華を窮めたソロモンでさえ、このような花の一つほどにも着飾ってはいませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","しかし、きょうは野にあって、あすは炉に投げ込まれる草をさえ、神はこのように装ってくださるのです。ましてあなたがたには、どんなによくしてくださることでしょう。ああ、信仰の薄い人たち。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","何を食べたらよいか、何を飲んだらよいか、と捜し求めることをやめ、気をもむことをやめなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","これらはみな、この世の異邦人たちが切に求めているものです。しかし、あなたがたの父は、それがあなたがたにも必要であることを知っておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","何はともあれ、あなたがたは、神の国を求めなさい。そうすれば、これらの物は、それに加えて与えられます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","小さな群れよ。恐れることはありません。あなたがたの父である神は、喜んであなたがたに御国をお与えになるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","持ち物を売って、施しをしなさい。自分のために、古くならない財布を作り、朽ちることのない宝を天に積み上げなさい。そこには、盗人も近寄らず、しみもいためることがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","あなたがたの宝のあるところに、あなたがたの心もあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","腰に帯を締め、あかりをともしていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","主人が婚礼から帰って来て戸をたたいたら、すぐに戸をあけようと、その帰りを待ち受けている人たちのようでありなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","帰って来た主人に、目をさましているところを見られるしもべたちは幸いです。まことに、あなたがたに告げます。主人のほうが帯を締め、そのしもべたちを食卓に着かせ、そばにいて給仕をしてくれます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","主人が真夜中に帰っても、夜明けに帰っても、いつでもそのようであることを見られるなら、そのしもべたちは幸いです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","このことを知っておきなさい。もしも家の主人が、どろぼうの来る時間を知っていたなら、おめおめと自分の家に押し入られはしなかったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","あなたがたも用心していなさい。人の子は、思いがけない時に来るのですから。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","そこで、ペテロが言った。「主よ。このたとえは私たちのために話してくださるのですか。それともみなのためなのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","主は言われた。「では、主人から、その家のしもべたちを任されて、食事時には彼らに食べ物を与える忠実な思慮深い管理人とは、いったいだれでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","主人が帰って来たときに、そのようにしているのを見られるしもべは幸いです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","わたしは真実をあなたがたに告げます。主人は彼に自分の全財産を任せるようになります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ところが、もし、そのしもべが、『主人の帰りはまだだ。』と心の中で思い、下男や下女を打ちたたき、食べたり飲んだり、酒に酔ったりし始めると、 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","しもべの主人は、思いがけない日の思わぬ時間に帰って来ます。そして、彼をきびしく罰して、不忠実な者どもと同じめに会わせるに違いありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","主人の心を知りながら、その思いどおりに用意もせず、働きもしなかったしもべは、ひどくむち打たれます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","しかし、知らずにいたために、むち打たれるようなことをしたしもべは、打たれても、少しで済みます。すべて、多く与えられた者は多く求められ、多く任された者は多く要求されます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","わたしが来たのは、地に火を投げ込むためです。だから、その火が燃えていたらと、どんなに願っていることでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","しかし、わたしには受けるバプテスマがあります。それが成し遂げられるまでは、どんなに苦しむことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","あなたがたは、地に平和を与えるためにわたしが来たと思っているのですか。そうではありません。あなたがたに言いますが、むしろ、分裂です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","今から、一家五人は、三人がふたりに、ふたりが三人に対抗して分かれるようになります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","父は息子に、息子は父に対抗し、母は娘に、娘は母に対抗し、しゅうとめは嫁に、嫁はしゅうとめに対抗して分かれるようになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","群衆にもこう言われた。「あなたがたは、西に雲が起こるのを見るとすぐに、『にわか雨が来るぞ。』と言い、事実そのとおりになります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","また南風が吹きだすと、『暑い日になるぞ。』と言い、事実そのとおりになります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","偽善者たち。あなたがたは地や空の現象を見分けることを知りながら、どうして今のこの時代を見分けることができないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","また、なぜ自分から進んで、何が正しいかを判断しないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","あなたを告訴する者といっしょに役人の前に行くときは、途中でも、熱心に彼と和解するよう努めなさい。そうでないと、その人はあなたを裁判官のもとにひっぱって行きます。裁判官は執行人に引き渡し、執行人は牢に投げ込んでしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","あなたに言います。最後の一レプタを支払うまでは、そこから決して出られないのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ちょうどそのとき、ある人たちがやって来て、イエスに報告した。ピラトがガリラヤ人たちの血をガリラヤ人たちのささげるいけにえに混ぜたというのである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","イエスは彼らに答えて言われた。「そのガリラヤ人たちがそのような災難を受けたから、ほかのどのガリラヤ人よりも罪深い人たちだったとでも思うのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","そうではない。わたしはあなたがたに言います。あなたがたも悔い改めないなら、みな同じように滅びます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","また、シロアムの塔が倒れ落ちて死んだあの十八人は、エルサレムに住んでいるだれよりも罪深い人たちだったとでも思うのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","そうではない。わたしはあなたがたに言います。あなたがたも悔い改めないなら、みな同じように滅びます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","イエスはこのようなたとえを話された。 「ある人が、ぶどう園にいちじくの木を植えておいた。実を取りに来たが、何も見つからなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","そこで、ぶどう園の番人に言った。『見なさい。三年もの間、やって来ては、このいちじくの実のなるのを待っているのに、なっていたためしがない。これを切り倒してしまいなさい。何のために土地をふさいでいるのですか。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","番人は答えて言った。『ご主人。どうか、ことし一年そのままにしてやってください。木の回りを掘って、肥やしをやってみますから。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","もしそれで来年、実を結べばよし、それでもだめなら、切り倒してください。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","イエスは安息日に、ある会堂で教えておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","すると、そこに十八年も病の霊につかれ、腰が曲がって、全然伸ばすことのできない女がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","イエスは、その女を見て、呼び寄せ、「あなたの病気はいやされました。」と言って、 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","手を置かれると、女はたちどころに腰が伸びて、神をあがめた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","すると、それを見た会堂管理者は、イエスが安息日にいやされたのを憤って、群衆に言った。「働いてよい日は六日です。その間に来て直してもらうがよい。安息日には、いけないのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","しかし、主は彼に答えて言われた。「偽善者たち。あなたがたは、安息日に、牛やろばを小屋からほどき、水を飲ませに連れて行くではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","この女はアブラハムの娘なのです。それを十八年もの間サタンが縛っていたのです。安息日だからといってこの束縛を解いてやってはいけないのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","こう話されると、反対していた者たちはみな、恥じ入り、群衆はみな、イエスのなさったすべての輝かしいみわざを喜んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","そこで、イエスはこう言われた。「神の国は、何に似ているでしょう。何に比べたらよいでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","それは、からし種のようなものです。それを取って庭に蒔いたところ、生長して木になり、空の鳥が枝に巣を作りました。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","またこう言われた。「神の国を何に比べましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","パン種のようなものです。女がパン種を取って、三サトンの粉に混ぜたところ、全体がふくれました。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","イエスは、町々村々を次々に教えながら通り、エルサレムへの旅を続けられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","すると、「主よ。救われる者は少ないのですか。」と言う人があった。イエスは、人々に言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","「努力して狭い門からはいりなさい。なぜなら、あなたがたに言いますが、はいろうとしても、はいれなくなる人が多いのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","家の主人が、立ち上がって、戸をしめてしまってからでは、外に立って、『ご主人さま。あけてください。』と言って、戸をいくらたたいても、もう主人は、『あなたがたがどこの者か、私は知らない。』と答えるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","すると、あなたがたは、こう言い始めるでしょう。『私たちは、ごいっしょに、食べたり飲んだりいたしましたし、私たちの大通りで教えていただきました。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","だが、主人はこう言うでしょう。『私はあなたがたがどこの者だか知りません。不正を行なう者たち。みな出て行きなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","神の国にアブラハムやイサクやヤコブや、すべての預言者たちがはいっているのに、あなたがたは外に投げ出されることになったとき、そこで泣き叫んだり、歯ぎしりしたりするのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","人々は、東からも西からも、また南からも北からも来て、神の国で食卓に着きます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","いいですか、今しんがりの者があとで先頭になり、いま先頭の者がしんがりになるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ちょうどそのとき、何人かのパリサイ人が近寄って来て、イエスに言った。「ここから出てほかの所へ行きなさい。ヘロデがあなたを殺そうと思っています。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","イエスは言われた。「行って、あの狐にこう言いなさい。『よく見なさい。わたしは、きょうと、あすとは、悪霊どもを追い出し、病人を直し、三日目に全うされます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","だが、わたしは、きょうもあすも次の日も進んで行かなければなりません。なぜなら、預言者がエルサレム以外の所で死ぬことはありえないからです。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ああ、エルサレム、エルサレム。預言者たちを殺し、自分に遣わされた人たちを石で打つ者、わたしは、めんどりがひなを翼の下にかばうように、あなたの子らを幾たび集めようとしたことか。それなのに、あなたがたはそれを好まなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","見なさい。あなたがたの家は荒れ果てたままに残される。わたしはあなたがたに言います。『祝福あれ。主の御名によって来られる方に。』とあなたがたの言うときが来るまでは、あなたがたは決してわたしを見ることができません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ある安息日に、食事をしようとして、パリサイ派のある指導者の家にはいられたとき、みんながじっとイエスを見つめていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","そこには、イエスの真正面に、水腫をわずらっている人がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","イエスは、律法の専門家、パリサイ人たちに、「安息日に病気を直すことは正しいことですか、それともよくないことですか。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","しかし、彼らは黙っていた。それで、イエスはその人を抱いて直してやり、そしてお帰しになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","それから、彼らに言われた。「自分の息子や牛が井戸に落ちたのに、安息日だからといって、すぐに引き上げてやらない者があなたがたのうちにいるでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","彼らは答えることができなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","招かれた人々が上座を選んでいる様子に気づいておられたイエスは、彼らにたとえを話された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","「婚礼の披露宴に招かれたときには、上座にすわってはいけません。あなたより身分の高い人が、招かれているかもしれないし、 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","あなたやその人を招いた人が来て、『この人に席を譲ってください。』とあなたに言うなら、そのときあなたは恥をかいて、末席に着かなければならないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","招かれるようなことがあって、行ったなら、末席に着きなさい。そうしたら、あなたを招いた人が来て、『どうぞもっと上席にお進みください。』と言うでしょう。そのときは、満座の中で面目を施すことになります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","なぜなら、だれでも自分を高くする者は低くされ、自分を低くする者は高くされるからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","また、イエスは、自分を招いてくれた人にも、こう話された。「昼食や夕食のふるまいをするなら、友人、兄弟、親族、近所の金持ちなどを呼んではいけません。でないと、今度は彼らがあなたを招いて、お返しすることになるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","祝宴を催すばあいには、むしろ、貧しい人、不具の人、足なえ、盲人たちを招きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","その人たちはお返しができないので、あなたは幸いです。義人の復活のときお返しを受けるからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","イエスといっしょに食卓に着いていた客のひとりはこれを聞いて、イエスに、「神の国で食事する人は、何と幸いなことでしょう。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","するとイエスはこう言われた。 「ある人が盛大な宴会を催し、大ぜいの人を招いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","宴会の時刻になったのでしもべをやり、招いておいた人々に、『さあ、おいでください。もうすっかり、用意ができましたから。』と言わせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ところが、みな同じように断わり始めた。最初の人はこう言った。『畑を買ったので、どうしても見に出かけなければなりません。すみませんが、お断わりさせていただきます。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","もうひとりはこう言った。『五くびきの牛を買ったので、それをためしに行くところです。すみませんが、お断わりさせていただきます。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","また、別の人はこう言った。『結婚したので、行くことができません。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","しもべは帰って、このことを主人に報告した。すると、おこった主人は、そのしもべに言った。『急いで町の大通りや路地に出て行って、貧しい人や、不具の人や、盲人や、足なえをここに連れて来なさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","しもべは言った。『ご主人さま。仰せのとおりにいたしました。でも、まだ席があります。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","主人は言った。『街道や垣根のところに出かけて行って、この家がいっぱいになるように、無理にでも人々を連れて来なさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","言っておくが、あの招待されていた人たちの中で、私の食事を味わう者は、ひとりもいないのです。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","さて、大ぜいの群衆が、イエスといっしょに歩いていたが、イエスは彼らのほうに向いて言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","「わたしのもとに来て、自分の父、母、妻、子、兄弟、姉妹、そのうえ自分のいのちまでも憎まない者は、わたしの弟子になることができません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","自分の十字架を負ってわたしについて来ない者は、わたしの弟子になることはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","塔を築こうとするとき、まずすわって、完成に十分な金があるかどうか、その費用を計算しない者が、あなたがたのうちにひとりでもあるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","基礎を築いただけで完成できなかったら、見ていた人はみな彼をあざ笑って、 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","『この人は、建て始めはしたものの、完成できなかった。』と言うでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","また、どんな王でも、ほかの王と戦いを交えようとするときは、二万人を引き連れて向かって来る敵を、一万人で迎え撃つことができるかどうかを、まずすわって、考えずにいられましょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","もし見込みがなければ、敵がまだ遠くに離れている間に、使者を送って講和を求めるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","そういうわけで、あなたがたはだれでも、自分の財産全部を捨てないでは、わたしの弟子になることはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ですから、塩は良いものですが、もしその塩が塩けをなくしたら、何によってそれに味をつけるのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","土地にも肥やしにも役立たず、外に投げ捨てられてしまいます。聞く耳のある人は聞きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","さて、取税人、罪人たちがみな、イエスの話を聞こうとして、みもとに近寄って来た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","すると、パリサイ人、律法学者たちは、つぶやいてこう言った。「この人は、罪人たちを受け入れて、食事までいっしょにする。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","そこでイエスは、彼らにこのようなたとえを話された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","「あなたがたのうちに羊を百匹持っている人がいて、そのうちの一匹をなくしたら、その人は九十九匹を野原に残して、いなくなった一匹を見つけるまで捜し歩かないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","見つけたら、大喜びでその羊をかついで、 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","帰って来て、友だちや近所の人たちを呼び集め、『いなくなった羊を見つけましたから、いっしょに喜んでください。』と言うでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","あなたがたに言いますが、それと同じように、ひとりの罪人が悔い改めるなら、悔い改める必要のない九十九人の正しい人にまさる喜びが天にあるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","また、女の人が銀貨を十枚持っていて、もしその一枚をなくしたら、あかりをつけ、家を掃いて、見つけるまで念入りに捜さないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","見つけたら、友だちや近所の女たちを呼び集めて、『なくした銀貨を見つけましたから、いっしょに喜んでください。』と言うでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","あなたがたに言いますが、それと同じように、ひとりの罪人が悔い改めるなら、神の御使いたちに喜びがわき起こるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","またこう話された。 「ある人に息子がふたりあった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","弟が父に、『おとうさん。私に財産の分け前を下さい。』と言った。それで父は、身代をふたりに分けてやった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","それから、幾日もたたぬうちに、弟は、何もかもまとめて遠い国に旅立った。そして、そこで放蕩して湯水のように財産を使ってしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","何もかも使い果たしたあとで、その国に大ききんが起こり、彼は食べるにも困り始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","それで、その国のある人のもとに身を寄せたところ、その人は彼を畑にやって、豚の世話をさせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","彼は豚の食べるいなご豆で腹を満たしたいほどであったが、だれひとり彼に与えようとはしなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","しかし、我に返ったとき彼は、こう言った。『父のところには、パンのあり余っている雇い人が大ぜいいるではないか。それなのに、私はここで、飢え死にしそうだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","立って、父のところに行って、こう言おう。「おとうさん。私は天に対して罪を犯し、またあなたの前に罪を犯しました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","もう私は、あなたの子と呼ばれる資格はありません。雇い人のひとりにしてください。」』 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","こうして彼は立ち上がって、自分の父のもとに行った。ところが、まだ家までは遠かったのに、父親は彼を見つけ、かわいそうに思い、走り寄って彼を抱き、口づけした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","息子は言った。『おとうさん。私は天に対して罪を犯し、またあなたの前に罪を犯しました。もう私は、あなたの子と呼ばれる資格はありません。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ところが父親は、しもべたちに言った。『急いで一番良い着物を持って来て、この子に着せなさい。それから、手に指輪をはめさせ、足にくつをはかせなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","そして肥えた子牛を引いて来てほふりなさい。食べて祝おうではないか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","この息子は、死んでいたのが生き返り、いなくなっていたのが見つかったのだから。』そして彼らは祝宴を始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ところで、兄息子は畑にいたが、帰って来て家に近づくと、音楽や踊りの音が聞こえて来た。それで、 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","しもべのひとりを呼んで、これはいったい何事かと尋ねると、 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","しもべは言った。『弟さんがお帰りになったのです。無事な姿をお迎えしたというので、おとうさんが、肥えた子牛をほふらせなさったのです。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","すると、兄はおこって、家にはいろうともしなかった。それで、父が出て来て、いろいろなだめてみた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","しかし兄は父にこう言った。『ご覧なさい。長年の間、私はおとうさんに仕え、戒めを破ったことは一度もありません。その私には、友だちと楽しめと言って、子山羊一匹下さったことがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","それなのに、遊女におぼれてあなたの身代を食いつぶして帰って来たこのあなたの息子のためには、肥えた子牛をほふらせなさったのですか。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","父は彼に言った。『おまえはいつも私といっしょにいる。私のものは、全部おまえのものだ。 ");
INSERT INTO jpn1965_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","だがおまえの弟は、死んでいたのが生き返って来たのだ。いなくなっていたのが見つかったのだから、楽しんで喜ぶのは当然ではないか。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","イエスは、弟子たちにも、こういう話をされた。 「ある金持ちにひとりの管理人がいた。この管理人が主人の財産を乱費している、という訴えが出された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","主人は、彼を呼んで言った。『おまえについてこんなことを聞いたが、何ということをしてくれたのだ。もう管理を任せておくことはできないから、会計の報告を出しなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","管理人は心の中で言った。『主人にこの管理の仕事を取り上げられるが、さてどうしよう。土を掘るには力がないし、こじきをするのは恥ずかしいし。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ああ、わかった。こうしよう。こうしておけば、いつ管理の仕事をやめさせられても、人がその家に私を迎えてくれるだろう。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","そこで彼は、主人の債務者たちをひとりひとり呼んで、まず最初の者に、『私の主人に、いくら借りがありますか。』と言うと、 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","その人は、『油百バテ。』と言った。すると彼は、『さあ、あなたの証文だ。すぐにすわって五十と書きなさい。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","それから、別の人に、『さて、あなたは、いくら借りがありますか。』と言うと、『小麦百コル。』と言った。彼は、『さあ、あなたの証文だ。八十と書きなさい。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","この世の子らは、自分たちの世のことについては、光の子らよりも抜けめがないものなので、主人は、不正な管理人がこうも抜けめなくやったのをほめた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","そこで、わたしはあなたがたに言いますが、不正の富で、自分のために友をつくりなさい。そうしておけば、富がなくなったとき、彼らはあなたがたを、永遠の住まいに迎えるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","小さい事に忠実な人は、大きい事にも忠実であり、小さい事に不忠実な人は、大きい事にも不忠実です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ですから、あなたがたが不正の富に忠実でなかったら、だれがあなたがたに、まことの富を任せるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","また、あなたがたが他人のものに忠実でなかったら、だれがあなたがたに、あなたがたのものを持たせるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","しもべは、ふたりの主人に仕えることはできません。一方を憎んで他方を愛したり、または一方を重んじて他方を軽んじたりするからです。あなたがたは、神にも仕え、また富にも仕えるということはできません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","さて、金の好きなパリサイ人たちが、一部始終を聞いて、イエスをあざ笑っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","イエスは彼らに言われた。「あなたがたは、人の前で自分を正しいとする者です。しかし神は、あなたがたの心をご存じです。人間の間であがめられる者は、神の前で憎まれ、きらわれます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","律法と預言者はヨハネまでです。それ以来、神の国の福音は宣べ伝えられ、だれもかれも、無理にでも、これにはいろうとしています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","しかし律法の一画が落ちるよりも、天地の滅びるほうがやさしいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","だれでも妻を離別してほかの女と結婚する者は、姦淫を犯す者であり、また、夫から離別された女と結婚する者も、姦淫を犯す者です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ある金持ちがいた。いつも紫の衣や細布を着て、毎日ぜいたくに遊び暮らしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ところが、その門前にラザロという全身おできの貧乏人が寝ていて、 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","金持ちの食卓から落ちる物で腹を満たしたいと思っていた。犬もやって来ては、彼のおできをなめていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","さて、この貧乏人は死んで、御使いたちによってアブラハムのふところに連れて行かれた。金持ちも死んで葬られた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","その金持ちは、ハデスで苦しみながら目を上げると、アブラハムが、はるかかなたに見えた。しかも、そのふところにラザロが見えた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","彼は叫んで言った。『父アブラハムさま。私をあわれんでください。ラザロが指先を水に浸して私の舌を冷やすように、ラザロをよこしてください。私はこの炎の中で、苦しくてたまりません。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","アブラハムは言った。『子よ。思い出してみなさい。おまえは生きている間、良い物を受け、ラザロは生きている間、悪い物を受けていました。しかし、今ここで彼は慰められ、おまえは苦しみもだえているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","そればかりでなく、私たちとおまえたちの間には、大きな淵があります。ここからそちらへ渡ろうとしても、渡れないし、そこからこちらへ越えて来ることもできないのです。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","彼は言った。『父よ。ではお願いです。ラザロを私の父の家に送ってください。 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","私には兄弟が五人ありますが、彼らまでこんな苦しみの場所に来ることのないように、よく言い聞かせてください。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","しかしアブラハムは言った。『彼らには、モーセと預言者があります。その言うことを聞くべきです。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","彼は言った。『いいえ、父アブラハム。もし、だれかが死んだ者の中から彼らのところに行ってやったら、彼らは悔い改めるに違いありません。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","アブラハムは彼に言った。『もしモーセと預言者との教えに耳を傾けないのなら、たといだれかが死人の中から生き返っても、彼らは聞き入れはしない。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","イエスは弟子たちにこう言われた。「つまずきが起こるのは避けられない。だが、つまずきを起こさせる者は、忌まわしいものです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","この小さい者たちのひとりに、つまずきを与えるようであったら、そんな者は石臼を首にゆわえつけられて、海に投げ込まれたほうがましです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","気をつけていなさい。もし兄弟が罪を犯したなら、彼を戒めなさい。そして悔い改めれば、赦しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","かりに、あなたに対して一日に七度罪を犯しても、『悔い改めます。』と言って七度あなたのところに来るなら、赦してやりなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","使徒たちは主に言った。「私たちの信仰を増してください。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","しかし主は言われた。「もしあなたがたに、からし種ほどの信仰があったなら、この桑の木に、『根こそぎ海の中に植われ。』と言えば、言いつけどおりになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ところで、あなたがたのだれかに、耕作か羊飼いをするしもべがいるとして、そのしもべが野らから帰って来たとき、『さあ、さあ、ここに来て、食事をしなさい。』としもべに言うでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","かえって、『私の食事の用意をし、帯を締めて私の食事が済むまで給仕しなさい。あとで、自分の食事をしなさい。』と言わないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","しもべが言いつけられたことをしたからといって、そのしもべに感謝するでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","あなたがたもそのとおりです。自分に言いつけられたことをみな、してしまったら、『私たちは役に立たないしもべです。なすべきことをしただけです。』と言いなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","そのころイエスはエルサレムに上られる途中、サマリヤとガリラヤの境を通られた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ある村にはいると、十人のらい病人がイエスに出会った。彼らは遠く離れた所に立って、 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","声を張り上げて、「イエスさま、先生。どうぞあわれんでください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","イエスはこれを見て、言われた。「行きなさい。そして自分を祭司に見せなさい。」彼らは行く途中でいやされた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","そのうちのひとりは、自分のいやされたことがわかると、大声で神をほめたたえながら引き返して来て、 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","イエスの足もとにひれ伏して感謝した。彼はサマリヤ人であった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","そこでイエスは言われた。「十人いやされたのではないか。九人はどこにいるのか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","神をあがめるために戻って来た者は、この外国人のほかには、だれもいないのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","それからその人に言われた。「立ち上がって、行きなさい。あなたの信仰が、あなたを直したのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","さて、神の国はいつ来るのか、とパリサイ人たちに尋ねられたとき、イエスは答えて言われた。「神の国は、人の目で認められるようにして来るものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","『そら、ここにある。』とか、『あそこにある。』とか言えるようなものではありません。いいですか。神の国は、あなたがたのただ中にあるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","イエスは弟子たちに言われた。「人の子の日を一日でも見たいと願っても、見られない時が来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","人々が『こちらだ。』とか、『あちらだ。』とか言っても行ってはなりません。あとを追いかけてはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","いなずまが、ひらめいて、天の端から天の端へと輝くように、人の子は、人の子の日には、ちょうどそのようであるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","しかし、人の子はまず、多くの苦しみを受け、この時代に捨てられなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","人の子の日に起こることは、ちょうど、ノアの日に起こったことと同様です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ノアが箱舟にはいるその日まで、人々は、食べたり、飲んだり、めとったり、とついだりしていたが、洪水が来て、すべての人を滅ぼしてしまいました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","また、ロトの時代にあったことと同様です。人々は食べたり、飲んだり、売ったり、買ったり、植えたり、建てたりしていたが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ロトがソドムから出て行くと、その日に、火と硫黄が天から降って、すべての人を滅ぼしてしまいました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","人の子の現われる日にも、全くそのとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","その日には、屋上にいる者は家に家財があっても、取り出しに降りてはいけません。同じように、畑にいる者も家に帰ってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ロトの妻を思い出しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","自分のいのちを救おうと努める者はそれを失い、それを失う者はいのちを保ちます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","あなたがたに言いますが、その夜、同じ寝台で男がふたり寝ていると、ひとりは取られ、他のひとりは残されます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","女がふたりいっしょに臼をひいていると、ひとりは取られ、他のひとりは残されます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","37","弟子たちは答えて言った。「主よ。どこでですか。」主は言われた。「死体のある所、そこに、はげたかも集まります。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","いつでも祈るべきであり、失望してはならないことを教えるために、イエスは彼らにたとえを話された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","「ある町に、神を恐れず、人を人とも思わない裁判官がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","その町に、ひとりのやもめがいたが、彼のところにやって来ては、『私の相手をさばいて、私を守ってください。』と言っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","彼は、しばらくは取り合わないでいたが、後には心ひそかに『私は神を恐れず人を人とも思わないが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","どうも、このやもめは、うるさくてしかたがないから、この女のために裁判をしてやることにしよう。でないと、ひっきりなしにやって来てうるさくてしかたがない。』と言った。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","主は言われた。「不正な裁判官の言っていることを聞きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","まして神は、夜昼神を呼び求めている選民のためにさばきをつけないで、いつまでもそのことを放っておかれることがあるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","あなたがたに言いますが、神は、すみやかに彼らのために正しいさばきをしてくださいます。しかし、人の子が来たとき、はたして地上に信仰が見られるでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","自分を義人だと自任し、他の人々を見下している者たちに対しては、イエスはこのようなたとえを話された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","「ふたりの人が、祈るために宮に上った。ひとりはパリサイ人で、もうひとりは取税人であった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","パリサイ人は、立って、心の中でこんな祈りをした。『神よ。私はほかの人々のようにゆする者、不正な者、姦淫する者ではなく、ことにこの取税人のようではないことを、感謝します。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","私は週に二度断食し、自分の受けるものはみな、その十分の一をささげております。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ところが、取税人は遠く離れて立ち、目を天に向けようともせず、自分の胸をたたいて言った。『神さま。こんな罪人の私をあわれんでください。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","あなたがたに言うが、この人のほうが、前の人よりも、義と認められ、家に帰って行きました。なぜなら、だれでも自分を高くする者は低くされ、自分を低くする者は高くされるからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","イエスにさわっていただこうとして、人々がその幼子たちを、みもとに連れて来た。ところが、弟子たちがそれを見てしかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","しかしイエスは、幼子たちを呼び寄せて、こう言われた。「子どもたちをわたしのところに来させなさい。止めてはいけません。神の国は、このような者たちのものです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","まことに、あなたがたに告げます。子どものように神の国を受け入れる者でなければ、決してそこに、はいることはできません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","またある役人が、イエスに質問して言った。「尊い先生。私は何をしたら、永遠のいのちを自分のものとして受けることができるでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","イエスは彼に言われた。「なぜ、わたしを『尊い』と言うのですか。尊い方は、神おひとりのほかにはだれもありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","戒めはあなたもよく知っているはずです。『姦淫してはならない。殺してはならない。盗んではならない。偽証を立ててはならない。父と母を敬え。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","すると彼は言った。「そのようなことはみな、小さい時から守っております。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","イエスはこれを聞いて、その人に言われた。「あなたには、まだ一つだけ欠けたものがあります。あなたの持ち物を全部売り払い、貧しい人々に分けてやりなさい。そうすれば、あなたは天に宝を積むことになります。そのうえで、わたしについて来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","すると彼は、これを聞いて、非常に悲しんだ。たいへんな金持ちだったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","イエスは彼を見てこう言われた。「裕福な者が神の国にはいることは、何とむずかしいことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","金持ちが神の国にはいるよりは、らくだが針の穴を通るほうがもっとやさしい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","これを聞いた人々が言った。「それでは、だれが救われることができるでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","イエスは言われた。「人にはできないことが、神にはできるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","すると、ペテロが言った。「ご覧ください。私たちは自分の家を捨てて従ってまいりました。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","イエスは彼らに言われた。「まことに、あなたがたに告げます。神の国のために、家、妻、兄弟、両親、子どもを捨てた者で、だれひとりとして、 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","この世にあってその幾倍かを受けない者はなく、後の世で永遠のいのちを受けない者はありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","さてイエスは、十二弟子をそばに呼んで、彼らに話された。「さあ、これから、わたしたちはエルサレムに向かって行きます。人の子について預言者たちが書いているすべてのことが実現されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","人の子は異邦人に引き渡され、そして彼らにあざけられ、はずかしめられ、つばきをかけられます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","彼らは人の子をむちで打ってから殺します。しかし、人の子は三日目によみがえります。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","しかし弟子たちには、これらのことが何一つわからなかった。彼らには、このことばは隠されていて、話された事が理解できなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","イエスがエリコに近づかれたころ、ある盲人が、道ばたにすわり、物ごいをしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","群衆が通って行くのを耳にして、これはいったい何事ですか、と尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ナザレのイエスがお通りになるのだ、と知らせると、 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","彼は大声で、「ダビデの子のイエスさま。私をあわれんでください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","彼を黙らせようとして、先頭にいた人々がたしなめたが、盲人は、ますます「ダビデの子よ。私をあわれんでください。」と叫び立てた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","イエスは立ち止まって、彼をそばに連れて来るように言いつけられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","彼が近寄って来たので、「わたしに何をしてほしいのか。」と尋ねられると、彼は、「主よ。目が見えるようになることです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","イエスが彼に、「見えるようになれ。あなたの信仰があなたを直したのです。」と言われると、 ");
INSERT INTO jpn1965_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","彼はたちどころに目が見えるようになり、神をあがめながらイエスについて行った。これを見て民はみな神を賛美した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","それからイエスは、エリコにはいって、町をお通りになった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ここには、ザアカイという人がいたが、彼は取税人のかしらで、金持ちであった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","彼は、イエスがどんな方か見ようとしたが、背が低かったので、群衆のために見ることができなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","それで、イエスを見るために、前方に走り出て、いちじく桑の木に登った。ちょうどイエスがそこを通り過ぎようとしておられたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","イエスは、ちょうどそこに来られて、上を見上げて彼に言われた。「ザアカイ。急いで降りて来なさい。きょうは、あなたの家に泊まることにしてあるから。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ザアカイは、急いで降りて来て、そして大喜びでイエスを迎えた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","これを見て、みなは、「あの方は罪人のところに行って客となられた。」と言ってつぶやいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ところがザアカイは立って、主に言った。「主よ。ご覧ください。私の財産の半分を貧しい人たちに施します。また、だれからでも、私がだまし取った物は、四倍にして返します。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","イエスは、彼に言われた。「きょう、救いがこの家に来ました。この人もアブラハムの子なのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","人の子は、失われた人を捜して救うために来たのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","人々がこれらのことに耳を傾けているとき、イエスは、続けて一つのたとえを話された。それは、イエスがエルサレムに近づいておられ、そのため人々は神の国がすぐにでも現われるように思っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","それで、イエスはこう言われた。 「ある身分の高い人が、遠い国に行った。王位を受けて帰るためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","彼は自分の十人のしもべを呼んで、十ミナを与え、彼らに言った。『私が帰るまで、これで商売しなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","しかし、その国民たちは、彼を憎んでいたので、あとから使いをやり、『この人に、私たちの王にはなってもらいたくありません。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","さて、彼が王位を受けて帰って来たとき、金を与えておいたしもべたちがどんな商売をしたかを知ろうと思い、彼らを呼び出すように言いつけた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","さて、最初の者が現われて言った。『ご主人さま。あなたの一ミナで、十ミナをもうけました。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","主人は彼に言った。『よくやった。良いしもべだ。あなたはほんの小さな事にも忠実だったから、十の町を支配する者になりなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","二番目の者が来て言った。『ご主人さま。あなたの一ミナで、五ミナをもうけました。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","主人はこの者にも言った。『あなたも五つの町を治めなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","もうひとりが来て言った。『ご主人さま。さあ、ここにあなたの一ミナがございます。私はふろしきに包んでしまっておきました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","あなたは計算の細かい、きびしい方ですから、恐ろしゅうございました。あなたはお預けにならなかったものをも取り立て、お蒔きにならなかったものをも刈り取る方ですから。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","主人はそのしもべに言った。『悪いしもべだ。私はあなたのことばによって、あなたをさばこう。あなたは、私が預けなかったものを取り立て、蒔かなかったものを刈り取るきびしい人間だと知っていた、というのか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","だったら、なぜ私の金を銀行に預けておかなかったのか。そうすれば私は帰って来たときに、それを利息といっしょに受け取れたはずだ。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","そして、そばに立っていた者たちに言った。『その一ミナを彼から取り上げて、十ミナ持っている人にやりなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","すると彼らは、『ご主人さま。その人は十ミナも持っています。』と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","彼は言った。『あなたがたに言うが、だれでも持っている者は、さらに与えられ、持たない者からは、持っている物までも取り上げられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ただ、私が王になるのを望まなかったこの敵どもは、みなここに連れて来て、私の目の前で殺してしまえ。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","これらのことを話して後、イエスは、さらに進んで、エルサレムへと上って行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","オリーブという山のふもとのベテパゲとベタニヤに近づかれたとき、イエスはふたりの弟子を使いに出して、 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","言われた。「向こうの村に行きなさい。そこにはいると、まだだれも乗ったことのない、ろばの子がつないであるのに気がつくでしょう。それをほどいて連れて来なさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","もし、『なぜ、ほどくのか。』と尋ねる人があったら、こう言いなさい。『主がお入用なのです。』」 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","使いに出されたふたりが行って見ると、イエスが話されたとおりであった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","彼らがろばの子をほどいていると、その持ち主が、「なぜ、このろばの子をほどくのか。」と彼らに言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","弟子たちは、「主がお入用なのです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","そしてふたりは、それをイエスのもとに連れて来た。そして、そのろばの子の上に自分たちの上着を敷いて、イエスをお乗せした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","イエスが進んで行かれると、人々は道に自分たちの上着を敷いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","イエスがすでにオリーブ山のふもとに近づかれたとき、弟子たちの群れはみな、自分たちの見たすべての力あるわざのことで、喜んで大声に神を賛美し始め、 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","こう言った。 「祝福あれ。 主の御名によって来られる王に。 天には平和。 栄光は、いと高き所に。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","するとパリサイ人のうちのある者たちが、群衆の中から、イエスに向かって、「先生。お弟子たちをしかってください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","イエスは答えて言われた。「わたしは、あなたがたに言います。もしこの人たちが黙れば、石が叫びます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","エルサレムに近くなったころ、都を見られたイエスは、その都のために泣いて、 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","言われた。「おまえも、もし、この日のうちに、平和のことを知っていたのなら。しかし今は、そのことがおまえの目から隠されている。 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","やがておまえの敵が、おまえに対して塁を築き、回りを取り巻き、四方から攻め寄せ、 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","そしておまえとその中の子どもたちを地にたたきつけ、おまえの中で、一つの石もほかの石の上に積まれたままでは残されない日が、やって来る。それはおまえが、神の訪れの時を知らなかったからだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","宮にはいられたイエスは、商売人たちを追い出し始め、 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","こう言われた。「『わたしの家は、祈りの家でなければならない。』と書いてある。それなのに、あなたがたはそれを強盗の巣にした。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","イエスは毎日、宮で教えておられた。祭司長、律法学者、民のおもだった者たちは、イエスを殺そうとねらっていたが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","どうしてよいかわからなかった。民衆がみな、熱心にイエスの話に耳を傾けていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","イエスは宮で民衆を教え、福音を宣べ伝えておられたが、ある日、祭司長、律法学者たちが、長老たちといっしょにイエスに立ち向かって、 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","イエスに言った。「何の権威によって、これらのことをしておられるのですか。あなたにその権威を授けたのはだれですか。それを言ってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","そこで答えて言われた。「わたしも一言尋ねますから、それに答えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ヨハネのバプテスマは、天から来たのですか、人から出たのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","すると彼らは、こう言って、互いに論じ合った。「もし、天から、と言えば、それならなぜ、彼を信じなかったか、と言うだろう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","しかし、もし、人から、と言えば、民衆がみなで私たちを石で打ち殺すだろう。ヨハネを預言者と信じているのだから。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","そこで、「どこからか知りません。」と答えた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","するとイエスは、「わたしも、何の権威によってこれらのことをするのか、あなたがたに話すまい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","また、イエスは、民衆にこのようなたとえを話された。 「ある人がぶどう園を造り、それを農夫たちに貸して、長い旅に出た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","そして季節になったので、ぶどう園の収穫の分けまえをもらうために、農夫たちのところへひとりのしもべを遣わした。ところが、農夫たちは、そのしもべを袋だたきにし、何も持たせないで送り帰した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","そこで、別のしもべを遣わしたが、彼らは、そのしもべも袋だたきにし、はずかしめたうえで、何も持たせないで送り帰した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","彼はさらに三人目のしもべをやったが、彼らは、このしもべにも傷を負わせて追い出した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ぶどう園の主人は言った。『どうしたものか。よし、愛する息子を送ろう。彼らも、この子はたぶん敬ってくれるだろう。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ところが、農夫たちはその息子を見て、議論しながら言った。『あれはあと取りだ。あれを殺そうではないか。そうすれば、財産はこちらのものだ。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","そして、彼をぶどう園の外に追い出して、殺してしまった。 こうなると、ぶどう園の主人は、どうするでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","彼は戻って来て、この農夫どもを打ち滅ぼし、ぶどう園をほかの人たちに与えてしまいます。」これを聞いた民衆は、「そんなことがあってはなりません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","イエスは、彼らを見つめて言われた。「では、 『家を建てる者たちの見捨てた石、 それが礎の石となった。』 と書いてあるのは、何のことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","この石の上に落ちれば、だれでも粉々に砕け、またこの石が人の上に落ちれば、その人を粉みじんに飛び散らしてしまうのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","律法学者、祭司長たちは、イエスが自分たちをさしてこのたとえを話されたと気づいたので、この際イエスに手をかけて捕えようとしたが、やはり民衆を恐れた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","さて、機会をねらっていた彼らは、義人を装った間者を送り、イエスのことばを取り上げて、総督の支配と権威にイエスを引き渡そう、と計った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","その間者たちは、イエスに質問して言った。「先生。私たちは、あなたがお話しになり、お教えになることは正しく、またあなたは分け隔てなどせず、真理に基づいて神の道を教えておられることを知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ところで、私たちが、カイザルに税金を納めることは、律法にかなっていることでしょうか。かなっていないことでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","イエスはそのたくらみを見抜いて彼らに言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","「デナリ銀貨をわたしに見せなさい。これはだれの肖像ですか。だれの銘ですか。」彼らは、「カイザルのです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","すると彼らに言われた。「では、カイザルのものはカイザルに返しなさい。そして神のものは神に返しなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","彼らは、民衆の前でイエスのことばじりをつかむことができず、お答えに驚嘆して黙ってしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ところが、復活があることを否定するサドカイ人のある者たちが、イエスのところに来て、質問して、 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","こう言った。「先生。モーセは私たちのためにこう書いています。『もし、ある人の兄が妻をめとって死に、しかも子がなかったばあいは、その弟はその女を妻にして、兄のための子をもうけなければならない。』 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ところで、七人の兄弟がいました。長男は妻をめとりましたが、子どもがなくて死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","次男も、 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","三男もその女をめとり、七人とも同じようにして、子どもを残さずに死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","あとで、その女も死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","すると復活の際、その女はだれの妻になるでしょうか。七人ともその女を妻としたのですが。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","イエスは彼らに言われた。「この世の子らは、めとったり、とついだりするが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","次の世にはいるのにふさわしく、死人の中から復活するのにふさわしい、と認められる人たちは、めとることも、とつぐこともありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","彼らはもう死ぬことができないからです。彼らは御使いのようであり、また、復活の子として神の子どもだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","それに、死人がよみがえることについては、モーセも柴の個所で、主を、『アブラハムの神、イサクの神、ヤコブの神。』と呼んで、このことを示しました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","神は死んだ者の神ではありません。生きている者の神です。というのは、神に対しては、みなが生きているからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","律法学者のうちのある者たちが答えて、「先生。りっぱなお答えです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","彼らはもうそれ以上何も質問する勇気がなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","すると、イエスが彼らに言われた。「どうして人々は、キリストをダビデの子と言うのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ダビデ自身が詩篇の中でこう言っています。 『主は私の主に言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","「わたしが、あなたの敵を あなたの足台とする時まで、 わたしの右の座に着いていなさい。」』 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","こういうわけで、ダビデがキリストを主と呼んでいるのに、どうしてキリストがダビデの子でしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","また、民衆がみな耳を傾けているときに、イエスは弟子たちにこう言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","「律法学者たちには気をつけなさい。彼らは、長い衣をまとって歩き回ったり、広場であいさつされたりすることが好きで、また会堂の上席や宴会の上座が好きです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","また、やもめの家を食いつぶし、見えを飾るために長い祈りをします。こういう人たちは人一倍きびしい罰を受けるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","さてイエスが、目を上げてご覧になると、金持ちたちが献金箱に献金を投げ入れていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","また、ある貧しいやもめが、そこにレプタ銅貨二つを投げ入れているのをご覧になった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","それでイエスは言われた。「わたしは真実をあなたがたに告げます。この貧しいやもめは、どの人よりもたくさん投げ入れました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","みなは、あり余る中から献金を投げ入れたのに、この女は、乏しい中から、持っていた生活費の全部を投げ入れたからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","宮がすばらしい石や奉納物で飾ってあると話していた人々があった。するとイエスはこう言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","「あなたがたの見ているこれらの物について言えば、石がくずされずに積まれたまま残ることのない日がやって来ます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","彼らは、イエスに質問して言った。「先生。それでは、これらのことは、いつ起こるのでしょう。これらのことが起こるときは、どんな前兆があるのでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","イエスは言われた。「惑わされないように気をつけなさい。わたしの名を名のる者が大ぜい現われ、『私がそれだ。』とか『時は近づいた。』とか言います。そんな人々のあとについて行ってはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","戦争や暴動のことを聞いても、こわがってはいけません。それは、初めに必ず起こることです。だが、終わりは、すぐには来ません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","それから、イエスは彼らに言われた。「民族は民族に、国は国に敵対して立ち上がり、 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","大地震があり、方々に疫病やききんが起こり、恐ろしいことや天からのすさまじい前兆が現われます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","しかし、これらのすべてのことの前に、人々はあなたがたを捕えて迫害し、会堂や牢に引き渡し、わたしの名のために、あなたがたを王たちや総督たちの前に引き出すでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","それはあなたがたのあかしをする機会となります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","それで、どう弁明するかは、あらかじめ考えないことに、心を定めておきなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","どんな反対者も、反論もできず、反証もできないようなことばと知恵を、わたしがあなたがたに与えます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","しかしあなたがたは、両親、兄弟、親族、友人たちにまで裏切られます。中には殺される者もあり、 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","わたしの名のために、みなの者に憎まれます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","しかし、あなたがたの髪の毛一筋も失われることはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","あなたがたは、忍耐によって、自分のいのちを勝ち取ることができます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","しかし、エルサレムが軍隊に囲まれるのを見たら、そのときには、その滅亡が近づいたことを悟りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","そのとき、ユダヤにいる人々は山へ逃げなさい。都の中にいる人々は、そこから立ちのきなさい。いなかにいる者たちは、都にはいってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","これは、書かれているすべてのことが成就する報復の日だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","その日、悲惨なのは身重の女と乳飲み子を持つ女です。この地に大きな苦難が臨み、この民に御怒りが臨むからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","人々は、剣の刃に倒れ、捕虜となってあらゆる国に連れて行かれ、異邦人の時の終わるまで、エルサレムは異邦人に踏み荒らされます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","そして、日と月と星には、前兆が現われ、地上では、諸国の民が、海と波が荒れどよめくために不安に陥って悩み、 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","人々は、その住むすべての所を襲おうとしていることを予想して、恐ろしさのあまり気を失います。天の万象が揺り動かされるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","そのとき、人々は、人の子が力と輝かしい栄光を帯びて雲に乗って来るのを見るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","これらのことが起こり始めたなら、からだをまっすぐにし、頭を上に上げなさい。贖いが近づいたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","それからイエスは、人々にたとえを話された。「いちじくの木や、すべての木を見なさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","木の芽が出ると、それを見て夏の近いことがわかります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","そのように、これらのことが起こるのを見たら、神の国は近いと知りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","まことに、あなたがたに告げます。すべてのことが起こってしまうまでは、この時代は過ぎ去りません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","この天地は滅びます。しかし、わたしのことばは決して滅びることがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","あなたがたの心が、放蕩や深酒やこの世の煩いのために沈み込んでいるところに、その日がわなのように、突然あなたがたに臨むことのないように、よく気をつけていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","その日は、全地の表に住むすべての人に臨むからです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","しかし、あなたがたは、やがて起ころうとしているこれらすべてのことからのがれ、人の子の前に立つことができるように、いつも油断せずに祈っていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","さてイエスは、昼は宮で教え、夜はいつも外に出てオリーブという山で過ごされた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","民衆はみな朝早く起きて、教えを聞こうとして、宮におられるイエスのもとに集まって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","さて、過越の祭りといわれる、種なしパンの祝いが近づいていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","祭司長、律法学者たちは、イエスを殺すための良い方法を捜していた。というのは、彼らは民衆を恐れていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","さて、十二弟子のひとりで、イスカリオテと呼ばれるユダに、サタンがはいった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ユダは出かけて行って、祭司長たちや宮の守衛長たちと、どのようにしてイエスを彼らに引き渡そうかと相談した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","彼らは喜んで、ユダに金をやる約束をした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ユダは承知した。そして群衆のいないときにイエスを彼らに引き渡そうと機会をねらっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","さて、過越の小羊のほふられる、種なしパンの日が来た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","イエスは、こう言ってペテロとヨハネを遣わされた。「わたしたちの過越の食事ができるように、準備をしに行きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","彼らはイエスに言った。「どこに準備しましょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","イエスは言われた。「町にはいると、水がめを運んでいる男に会うから、その人がはいる家にまでついて行きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","そして、その家の主人に、『弟子たちといっしょに過越の食事をする客間はどこか、と先生があなたに言っておられる。』と言いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","すると主人は、席が整っている二階の大広間を見せてくれます。そこで準備をしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","彼らが出かけて見ると、イエスの言われたとおりであった。それで、彼らは過越の食事の用意をした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","さて時間になって、イエスは食卓に着かれ、使徒たちもイエスといっしょに席に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","イエスは言われた。「わたしは、苦しみを受ける前に、あなたがたといっしょに、この過越の食事をすることをどんなに望んでいたことか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","あなたがたに言いますが、過越が神の国において成就するまでは、わたしはもはや二度と過越の食事をすることはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","そしてイエスは、杯を取り、感謝をささげて後、言われた。「これを取って、互いに分けて飲みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","あなたがたに言いますが、今から、神の国が来る時までは、わたしはもはや、ぶどうの実で造った物を飲むことはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","それから、パンを取り、感謝をささげてから、裂いて、弟子たちに与えて言われた。「これは、あなたがたのために与える、わたしのからだです。わたしを覚えてこれを行ないなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","食事の後、杯も同じようにして言われた。「この杯は、あなたがたのために流されるわたしの血による新しい契約です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","しかし、見なさい。わたしを裏切る者の手が、わたしとともに食卓にあります。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","人の子は、定められたとおりに去って行きます。しかし、人の子を裏切るような人間はのろわれます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","そこで弟子たちは、そんなことをしようとしている者は、いったいこの中のだれなのかと、互いに議論をし始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","また、彼らの間には、この中でだれが一番偉いだろうかという論議も起こった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","すると、イエスは彼らに言われた。「異邦人の王たちは人々を支配し、また人々の上に権威を持つ者は守護者と呼ばれています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","だが、あなたがたは、それではいけません。あなたがたの間で一番偉い人は一番年の若い者のようになりなさい。また、治める人は仕える人のようでありなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","食卓に着く人と給仕する者と、どちらが偉いでしょう。むろん、食卓に着く人でしょう。しかしわたしは、あなたがたのうちにあって給仕する者のようにしています。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","けれども、あなたがたこそ、わたしのさまざまの試練の時にも、わたしについて来てくれた人たちです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","わたしの父がわたしに王権を与えてくださったように、わたしもあなたがたに王権を与えます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","それであなたがたは、わたしの国でわたしの食卓に着いて食事をし、王座に着いて、イスラエルの十二の部族をさばくのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","シモン、シモン。見なさい。サタンが、あなたがたを麦のようにふるいにかけることを願って聞き届けられました。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","しかし、わたしは、あなたの信仰がなくならないように、あなたのために祈りました。だからあなたは、立ち直ったら、兄弟たちを力づけてやりなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","シモンはイエスに言った。「主よ。ごいっしょになら、牢であろうと、死であろうと、覚悟はできております。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","しかし、イエスは言われた。「ペテロ。あなたに言いますが、きょう鶏が鳴くまでに、あなたは三度、わたしを知らないと言います。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","それから、弟子たちに言われた。「わたしがあなたがたを、財布も旅行袋もくつも持たせずに旅に出したとき、何か足りない物がありましたか。」彼らは言った。「いいえ。何もありませんでした。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","そこで言われた。「しかし、今は、財布のある者は財布を持ち、同じく袋を持ち、剣のない者は着物を売って剣を買いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","あなたがたに言いますが、『彼は罪人たちの中に数えられた。』と書いてあるこのことが、わたしに必ず実現するのです。わたしにかかわることは実現します。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","彼らは言った。「主よ。このとおり、ここに剣が二振りあります。」イエスは彼らに、「それで十分。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","それからイエスは出て、いつものようにオリーブ山に行かれ、弟子たちも従った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","いつもの場所に着いたとき、イエスは彼らに、「誘惑に陥らないように祈っていなさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","そしてご自分は、弟子たちから石を投げて届くほどの所に離れて、ひざまずいて、こう祈られた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","「父よ。みこころならば、この杯をわたしから取りのけてください。しかし、わたしの願いではなく、みこころのとおりにしてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","すると、御使いが天からイエスに現われて、イエスを力づけた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","イエスは、苦しみもだえて、いよいよ切に祈られた。汗が血のしずくのように地に落ちた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","イエスは祈り終わって立ち上がり、弟子たちのところに来て見ると、彼らは悲しみの果てに、眠り込んでしまっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","それで、彼らに言われた。「なぜ、眠っているのか。起きて、誘惑に陥らないように祈っていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","イエスがまだ話をしておられるとき、群衆がやって来た。十二弟子のひとりで、ユダという者が、先頭に立っていた。ユダはイエスに口づけしようとして、みもとに近づいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","だが、イエスは彼に、「ユダ。口づけで、人の子を裏切ろうとするのか。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","イエスの回りにいた者たちは、事の成り行きを見て、「主よ。剣で撃ちましょうか。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","そしてそのうちのある者が、大祭司のしもべに撃ってかかり、その右の耳を切り落とした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","するとイエスは、「やめなさい。それまで。」と言われた。そして、耳にさわって彼を直してやられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","そして押しかけて来た祭司長、宮の守衛長、長老たちに言われた。「まるで強盗にでも向かうように、剣や棒を持ってやって来たのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","あなたがたは、わたしが毎日宮でいっしょにいる間は、わたしに手出しもしなかった。しかし、今はあなたがたの時です。暗やみの力です。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","彼らはイエスを捕え、引いて行って、大祭司の家に連れて来た。ペテロは、遠く離れてついて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","彼らは中庭の真中に火をたいて、みなすわり込んだので、ペテロも中に混じって腰をおろした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","すると、女中が、火あかりの中にペテロのすわっているのを見つけ、まじまじと見て言った。「この人も、イエスといっしょにいました。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ところが、ペテロはそれを打ち消して、「いいえ、私はあの人を知りません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","しばらくして、ほかの男が彼を見て、「あなたも、彼らの仲間だ。」と言った。しかし、ペテロは、「いや、違います。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","それから一時間ほどたつと、また別の男が、「確かにこの人も彼といっしょだった。この人もガリラヤ人だから。」と言い張った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","しかしペテロは、「あなたの言うことは私にはわかりません。」と言った。それといっしょに、彼がまだ言い終えないうちに、鶏が鳴いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","主が振り向いてペテロを見つめられた。ペテロは、「きょう、鶏が鳴くまでに、あなたは、三度わたしを知らないと言う。」と言われた主のおことばを思い出した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","彼は、外に出て、激しく泣いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","さて、イエスの監視人どもは、イエスをからかい、むちでたたいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","そして目隠しをして、「言い当ててみろ。今たたいたのはだれか。」と聞いたりした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","また、そのほかさまざまな悪口をイエスに浴びせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","夜が明けると、民の長老会、それに祭司長、律法学者たちが、集まった。彼らはイエスを議会に連れ出し、 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","こう言った。「あなたがキリストなら、そうだと言いなさい。」しかしイエスは言われた。「わたしが言っても、あなたがたは決して信じないでしょうし、 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","わたしが尋ねても、あなたがたは決して答えないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","しかし今から後、人の子は、神の大能の右の座に着きます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","彼らはみなで言った。「ではあなたは神の子ですか。」すると、イエスは彼らに「あなたがたの言うとおり、わたしはそれです。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","すると彼らは「これでもまだ証人が必要でしょうか。私たち自身が彼の口から直接それを聞いたのだから。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","そこで、彼らは全員が立ち上がり、イエスをピラトのもとに連れて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","そしてイエスについて訴え始めた。彼らは言った。「この人はわが国民を惑わし、カイザルに税金を納めることを禁じ、自分は王キリストだと言っていることがわかりました。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","するとピラトはイエスに、「あなたは、ユダヤ人の王ですか。」と尋ねた。イエスは答えて、「そのとおりです。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ピラトは祭司長たちや群衆に、「この人には何の罪も見つからない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","しかし彼らはあくまで言い張って、「この人は、ガリラヤからここまで、ユダヤ全土で教えながら、この民を扇動しているのです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","それを聞いたピラトは、この人はガリラヤ人かと尋ねて、 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ヘロデの支配下にあるとわかると、イエスをヘロデのところに送った。ヘロデもそのころエルサレムにいたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ヘロデはイエスを見ると非常に喜んだ。ずっと前からイエスのことを聞いていたので、イエスに会いたいと思っていたし、イエスの行なう何かの奇蹟を見たいと考えていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","それで、いろいろと質問したが、イエスは彼に何もお答えにならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","祭司長たちと律法学者たちは立って、イエスを激しく訴えていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ヘロデは、自分の兵士たちといっしょにイエスを侮辱したり嘲弄したりしたあげく、はでな衣を着せて、ピラトに送り返した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","この日、ヘロデとピラトは仲よくなった。それまでは互いに敵対していたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ピラトは祭司長たちと指導者たちと民衆とを呼び集め、 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","こう言った。「あなたがたは、この人を、民衆を惑わす者として、私のところに連れて来たけれども、私があなたがたの前で取り調べたところ、あなたがたが訴えているような罪は別に何も見つかりません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ヘロデとても同じです。彼は私たちにこの人を送り返しました。見なさい。この人は、死罪に当たることは、何一つしていません。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","だから私は、懲らしめたうえで、釈放します。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","しかし彼らは、声をそろえて叫んだ。「この人を除け。バラバを釈放しろ。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","バラバとは、都に起こった暴動と人殺しのかどで、牢にはいっていた者である。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ピラトは、イエスを釈放しようと思って、彼らに、もう一度呼びかけた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","しかし、彼らは叫び続けて、「十字架だ。十字架につけろ。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","しかしピラトは三度目に彼らにこう言った。「あの人がどんな悪いことをしたというのか。あの人には、死に当たる罪は、何も見つかりません。だから私は、懲らしめたうえで、釈放します。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ところが、彼らはあくまで主張し続け、十字架につけるよう大声で要求した。そしてついにその声が勝った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ピラトは、彼らの要求どおりにすることを宣告した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","すなわち、暴動と人殺しのかどで牢にはいっていた男を願いどおりに釈放し、イエスを彼らに引き渡して好きなようにさせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","彼らは、イエスを引いて行く途中、いなかから出て来たシモンというクレネ人をつかまえ、この人に十字架を負わせてイエスのうしろから運ばせた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","大ぜいの民衆やイエスのことを嘆き悲しむ女たちの群れが、イエスのあとについて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","しかしイエスは、女たちのほうに向いて、こう言われた。「エルサレムの娘たち。わたしのことで泣いてはいけない。むしろ自分自身と、自分の子どもたちのことのために泣きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","なぜなら人々が、『不妊の女、子を産んだことのない胎、飲ませたことのない乳房は、幸いだ。』と言う日が来るのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","そのとき、人々は山に向かって、『われわれの上に倒れかかってくれ。』と言い、丘に向かって、『われわれをおおってくれ。』と言い始めます。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","彼らが生木にこのようなことをするのなら、枯れ木には、いったい、何が起こるでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ほかにもふたりの犯罪人が、イエスとともに死刑にされるために、引かれて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","「どくろ」と呼ばれている所に来ると、そこで彼らは、イエスと犯罪人とを十字架につけた。犯罪人のひとりは右に、ひとりは左に。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","そのとき、イエスはこう言われた。「父よ。彼らをお赦しください。彼らは、何をしているのか自分でわからないのです。」彼らは、くじを引いて、イエスの着物を分けた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","民衆はそばに立ってながめていた。指導者たちもあざ笑って言った。「あれは他人を救った。もし、神のキリストで、選ばれた者なら、自分を救ってみろ。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","兵士たちもイエスをあざけり、そばに寄って来て、酸いぶどう酒を差し出し、 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","「ユダヤ人の王なら、自分を救え。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","「これはユダヤ人の王。」と書いた札もイエスの頭上に掲げてあった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","十字架にかけられていた犯罪人のひとりはイエスに悪口を言い、「あなたはキリストではないか。自分と私たちを救え。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ところが、もうひとりのほうが答えて、彼をたしなめて言った。「おまえは神をも恐れないのか。おまえも同じ刑罰を受けているではないか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","われわれは、自分のしたことの報いを受けているのだからあたりまえだ。だがこの方は、悪いことは何もしなかったのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","そして言った。「イエスさま。あなたの御国の位にお着きになるときには、私を思い出してください。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","イエスは、彼に言われた。「まことに、あなたに告げます。あなたはきょう、わたしとともにパラダイスにいます。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","そのときすでに十二時ごろになっていたが、全地が暗くなって、三時まで続いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","太陽は光を失っていた。また、神殿の幕は真二つに裂けた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","イエスは大声で叫んで、言われた。「父よ。わが霊を御手にゆだねます。」こう言って、息を引き取られた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","この出来事を見た百人隊長は、神をほめたたえ、「ほんとうに、この人は正しい方であった。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","また、この光景を見に集まっていた群衆もみな、こういういろいろの出来事を見たので、胸をたたいて悲しみながら帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","しかし、イエスの知人たちと、ガリラヤからイエスについて来ていた女たちとはみな、遠く離れて立ち、これらのことを見ていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","さてここに、ヨセフという、議員のひとりで、りっぱな、正しい人がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","この人は議員たちの計画や行動には同意しなかった。彼は、アリマタヤというユダヤ人の町の人で、神の国を待ち望んでいた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","この人が、ピラトのところに行って、イエスのからだの下げ渡しを願った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","それから、イエスを取り降ろして、亜麻布で包み、そして、まだだれをも葬ったことのない、岩に掘られた墓にイエスを納めた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","この日は準備の日で、もう安息日が始まろうとしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ガリラヤからイエスといっしょに出て来た女たちは、ヨセフについて行って、墓と、イエスのからだの納められる様子を見届けた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","そして、戻って来て、香料と香油を用意した。 安息日には、戒めに従って、休んだが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","週の初めの日の明け方早く、女たちは、準備しておいた香料を持って墓に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","見ると、石が墓からわきにころがしてあった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","はいって見ると、主イエスのからだはなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","そのため女たちが途方にくれていると、見よ、まばゆいばかりの衣を着たふたりの人が、女たちの近くに来た。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","恐ろしくなって、地面に顔を伏せていると、その人たちはこう言った。「あなたがたは、なぜ生きている方を死人の中で捜すのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ここにはおられません。よみがえられたのです。まだガリラヤにおられたころ、お話しになったことを思い出しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","人の子は必ず罪人らの手に引き渡され、十字架につけられ、三日目によみがえらなければならない、と言われたでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","女たちはイエスのみことばを思い出した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","そして、墓から戻って、十一弟子とそのほかの人たち全部に、一部始終を報告した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","この女たちは、マグダラのマリヤとヨハンナとヤコブの母マリヤとであった。彼女たちといっしょにいたほかの女たちも、このことを使徒たちに話した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ところが使徒たちにはこの話はたわごとと思われたので、彼らは女たちを信用しなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","［しかしペテロは、立ち上がると走って墓へ行き、かがんでのぞき込んだところ、亜麻布だけがあった。それで、この出来事に驚いて家に帰った。］ ");
INSERT INTO jpn1965_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ちょうどこの日、ふたりの弟子が、エルサレムから十一キロメートル余り離れたエマオという村に行く途中であった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","そして、ふたりでこのいっさいの出来事について話し合っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","話し合ったり、論じ合ったりしているうちに、イエスご自身が近づいて、彼らとともに道を歩いておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","しかしふたりの目はさえぎられていて、イエスだとはわからなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","イエスは彼らに言われた。「歩きながらふたりで話し合っているその話は、何のことですか。」すると、ふたりは暗い顔つきになって、立ち止まった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","クレオパというほうが答えて言った。「エルサレムにいながら、近ごろそこで起こった事を、あなただけが知らなかったのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","イエスが、「どんな事ですか。」と聞かれると、ふたりは答えた。「ナザレ人イエスのことです。この方は、神とすべての民の前で、行ないにもことばにも力のある預言者でした。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","それなのに、私たちの祭司長や指導者たちは、この方を引き渡して、死刑に定め、十字架につけたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","しかし私たちは、この方こそイスラエルを贖ってくださるはずだ、と望みをかけていました。事実、そればかりでなく、その事があってから三日目になりますが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","また仲間の女たちが私たちを驚かせました。その女たちは朝早く墓に行ってみましたが、 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","イエスのからだが見当たらないので、戻って来ました。そして御使いたちの幻を見たが、御使いたちがイエスは生きておられると告げた、と言うのです。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","それで、仲間の何人かが墓に行ってみたのですが、はたして女たちの言ったとおりで、イエスさまは見当たらなかった、というのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","するとイエスは言われた。「ああ、愚かな人たち。預言者たちの言ったすべてを信じない、心の鈍い人たち。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","キリストは、必ず、そのような苦しみを受けて、それから、彼の栄光にはいるはずではなかったのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","それから、イエスは、モーセおよびすべての預言者から始めて、聖書全体の中で、ご自分について書いてある事がらを彼らに説き明かされた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","彼らは目的の村に近づいたが、イエスはまだ先へ行きそうなご様子であった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","それで、彼らが、「いっしょにお泊まりください。そろそろ夕刻になりますし、日もおおかた傾きましたから。」と言って無理に願ったので、イエスは彼らといっしょに泊まるために中にはいられた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","彼らとともに食卓に着かれると、イエスはパンを取って祝福し、裂いて彼らに渡された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","それで、彼らの目が開かれ、イエスだとわかった。するとイエスは、彼らには見えなくなった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","そこでふたりは話し合った。「道々お話しになっている間も、聖書を説明してくださった間も、私たちの心はうちに燃えていたではないか。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","すぐさまふたりは立って、エルサレムに戻ってみると、十一使徒とその仲間が集まって、 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","「ほんとうに主はよみがえって、シモンにお姿を現わされた。」と言っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","彼らも、道であったいろいろなことや、パンを裂かれたときにイエスだとわかった次第を話した。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","これらのことを話している間に、イエスご自身が彼らの真中に立たれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","彼らは驚き恐れて、霊を見ているのだと思った。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","すると、イエスは言われた。「なぜ取り乱しているのですか。どうして心に疑いを起こすのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","わたしの手やわたしの足を見なさい。まさしくわたしです。わたしにさわって、よく見なさい。霊ならこんな肉や骨はありません。わたしは持っています。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","41","それでも、彼らは、うれしさのあまりまだ信じられず、不思議がっているので、イエスは、「ここに何か食べ物がありますか。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","それで、焼いた魚を一切れ差し上げると、 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","イエスは、彼らの前で、それを取って召し上がった。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","さて、そこでイエスは言われた。「わたしがまだあなたがたといっしょにいたころ、あなたがたに話したことばはこうです。わたしについてモーセの律法と預言者と詩篇とに書いてあることは、必ず全部成就するということでした。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","そこで、イエスは、聖書を悟らせるために彼らの心を開いて、 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","こう言われた。「次のように書いてあります。キリストは苦しみを受け、三日目に死人の中からよみがえり、 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","その名によって、罪の赦しを得させる悔い改めが、エルサレムから始まってあらゆる国の人々に宣べ伝えられる。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","あなたがたは、これらのことの証人です。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","さあ、わたしは、わたしの父の約束してくださったものをあなたがたに送ります。あなたがたは、いと高き所から力を着せられるまでは、都にとどまっていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","それから、イエスは、彼らをベタニヤまで連れて行き、手を上げて祝福された。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","そして祝福しながら、彼らから離れて行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","彼らは、非常な喜びを抱いてエルサレムに帰り、 ");
INSERT INTO jpn1965_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","いつも宮にいて神をほめたたえていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","初めに、ことばがあった。ことばは神とともにあった。ことばは神であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","この方は、初めに神とともにおられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","すべてのものは、この方によって造られた。造られたもので、この方によらずにできたものは一つもない。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","この方にいのちがあった。このいのちは人の光であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","光はやみの中に輝いている。やみはこれに打ち勝たなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","神から遣わされたヨハネという人が現われた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","この人はあかしのために来た。光についてあかしするためであり、すべての人が彼によって信じるためである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","彼は光ではなかった。ただ光についてあかしするために来たのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","すべての人を照らすそのまことの光が世に来ようとしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","この方はもとから世におられ、世はこの方によって造られたのに、世はこの方を知らなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","この方はご自分のくにに来られたのに、ご自分の民は受け入れなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","しかし、この方を受け入れた人々、すなわち、その名を信じた人々には、神の子どもとされる特権をお与えになった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","この人々は、血によってではなく、肉の欲求や人の意欲によってでもなく、ただ、神によって生まれたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ことばは人となって、私たちの間に住まわれた。私たちはこの方の栄光を見た。父のみもとから来られたひとり子としての栄光である。この方は恵みとまことに満ちておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ヨハネはこの方について証言し、叫んで言った。「『私のあとから来る方は、私にまさる方である。私より先におられたからである。』と私が言ったのは、この方のことです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","私たちはみな、この方の満ち満ちた豊かさの中から、恵みの上にさらに恵みを受けたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","というのは、律法はモーセによって与えられ、恵みとまことはイエス・キリストによって実現したからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","いまだかつて神を見た者はいない。父のふところにおられるひとり子の神が、神を説き明かされたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ヨハネの証言は、こうである。ユダヤ人たちが祭司とレビ人をエルサレムからヨハネのもとに遣わして、「あなたはどなたですか。」と尋ねさせた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","彼は告白して否まず、「私はキリストではありません。」と言明した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","また、彼らは聞いた。「では、いったい何ですか。あなたはエリヤですか。」彼は言った。「そうではありません。」「あなたはあの預言者ですか。」彼は答えた。「違います。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","そこで、彼らは言った。「あなたはだれですか。私たちを遣わした人々に返事をしたいのですが、あなたは自分を何だと言われるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","彼は言った。「私は、預言者イザヤが言ったように『主の道をまっすぐにせよ。』と荒野で叫んでいる者の声です。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","彼らは、パリサイ人の中から遣わされたのであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","彼らはまた尋ねて言った。「キリストでもなく、エリヤでもなく、またあの預言者でもないなら、なぜ、あなたはバプテスマを授けているのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ヨハネは答えて言った。「私は水でバプテスマを授けているが、あなたがたの中に、あなたがたの知らない方が立っておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","その方は私のあとから来られる方で、私はその方のくつのひもを解く値うちもありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","この事があったのは、ヨルダンの向こう岸のベタニヤであって、ヨハネはそこでバプテスマを授けていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","その翌日、ヨハネは自分のほうにイエスが来られるのを見て言った。「見よ、世の罪を取り除く神の小羊。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","私が『私のあとから来る人がある。その方は私にまさる方である。私より先におられたからだ。』と言ったのは、この方のことです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","私もこの方を知りませんでした。しかし、この方がイスラエルに明らかにされるために、私は来て、水でバプテスマを授けているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","またヨハネは証言して言った。「御霊が鳩のように天から下って、この方の上にとどまられるのを私は見ました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","私もこの方を知りませんでした。しかし、水でバプテスマを授けさせるために私を遣わされた方が、私に言われました。『聖霊がある方の上に下って、その上にとどまられるのがあなたに見えたなら、その方こそ、聖霊によってバプテスマを授ける方である。』 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","私はそれを見たのです。それで、この方が神の子であると証言しているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","その翌日、またヨハネは、ふたりの弟子とともに立っていたが、 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","イエスが歩いて行かれるのを見て、「見よ、神の小羊。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ふたりの弟子は、彼がそう言うのを聞いて、イエスについて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","イエスは振り向いて、彼らがついて来るのを見て、言われた。「あなたがたは何を求めているのですか。」彼らは言った。「ラビ（訳して言えば、先生）。今どこにお泊まりですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","イエスは彼らに言われた。「来なさい。そうすればわかります。」そこで、彼らはついて行って、イエスの泊まっておられる所を知った。そして、その日彼らはイエスといっしょにいた。時は十時ごろであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ヨハネから聞いて、イエスについて行ったふたりのうちのひとりは、シモン・ペテロの兄弟アンデレであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","彼はまず自分の兄弟シモンを見つけて、「私たちはメシヤ（訳して言えば、キリスト）に会った。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","彼はシモンをイエスのもとに連れて来た。イエスはシモンに目を留めて言われた。「あなたはヨハネの子シモンです。あなたをケパ（訳すとペテロ）と呼ぶことにします。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","その翌日、イエスはガリラヤに行こうとされた。そして、ピリポを見つけて「わたしに従って来なさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ピリポは、ベツサイダの人で、アンデレやペテロと同じ町の出身であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","彼はナタナエルを見つけて言った。「私たちは、モーセが律法の中に書き、預言者たちも書いている方に会いました。ナザレの人で、ヨセフの子イエスです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ナタナエルは彼に言った。「ナザレから何の良いものが出るだろう。」ピリポは言った。「来て、そして、見なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","イエスはナタナエルが自分のほうに来るのを見て、彼について言われた。「これこそ、ほんとうのイスラエル人だ。彼のうちには偽りがない。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ナタナエルはイエスに言った。「どうして私をご存じなのですか。」イエスは言われた。「わたしは、ピリポがあなたを呼ぶ前に、あなたがいちじくの木の下にいるのを見たのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ナタナエルは答えた。「先生。あなたは神の子です。あなたはイスラエルの王です。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","イエスは答えて言われた。「あなたがいちじくの木の下にいるのを見た、とわたしが言ったので、あなたは信じるのですか。あなたは、それよりもさらに大きなことを見ることになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","そして言われた。「まことに、まことに、あなたがたに告げます。天が開けて、神の御使いたちが人の子の上を上り下りするのを、あなたがたはいまに見ます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","それから三日目に、ガリラヤのカナで婚礼があって、そこにイエスの母がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","イエスも、また弟子たちも、その婚礼に招かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ぶどう酒がなくなったとき、母がイエスに向かって「ぶどう酒がありません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","すると、イエスは母に言われた。「あなたはわたしと何の関係があるのでしょう。女の方。わたしの時はまだ来ていません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","母は手伝いの人たちに言った。「あの方が言われることを、何でもしてあげてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","さて、そこには、ユダヤ人のきよめのしきたりによって、それぞれ八十リットルから百二十リットル入りの石の水がめが六つ置いてあった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","イエスは彼らに言われた。「水がめに水を満たしなさい。」彼らは水がめを縁までいっぱいにした。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","イエスは彼らに言われた。「さあ、今くみなさい。そして宴会の世話役のところに持って行きなさい。」彼らは持って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","宴会の世話役はぶどう酒になったその水を味わってみた。それがどこから来たのか、知らなかったので、――しかし、水をくんだ手伝いの者たちは知っていた。――彼は、花婿を呼んで、 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","言った。「だれでも初めに良いぶどう酒を出し、人々が十分飲んだころになると、悪いのを出すものだが、あなたは良いぶどう酒をよくも今まで取っておきました。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","イエスはこのことを最初のしるしとしてガリラヤのカナで行ない、ご自分の栄光を現わされた。それで、弟子たちはイエスを信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","その後、イエスは母や兄弟たちや弟子たちといっしょに、カペナウムに下って行き、長い日数ではなかったが、そこに滞在された。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ユダヤ人の過越の祭りが近づき、イエスはエルサレムに上られた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","そして、宮の中に、牛や羊や鳩を売る者たちと両替人たちがすわっているのをご覧になり、 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","細なわでむちを作って、羊も牛もみな、宮から追い出し、両替人の金を散らし、その台を倒し、 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","また、鳩を売る者に言われた。「それをここから持って行け。わたしの父の家を商売の家としてはならない。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","弟子たちは、「あなたの家を思う熱心がわたしを食い尽くす。」と書いてあるのを思い起こした。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","そこで、ユダヤ人たちが答えて言った。「あなたがこのようなことをするからには、どんなしるしを私たちに見せてくれるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","イエスは彼らに答えて言われた。「この神殿をこわしてみなさい。わたしは、三日でそれを建てよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","そこで、ユダヤ人たちは言った。「この神殿は建てるのに四十六年かかりました。あなたはそれを、三日で建てるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","しかし、イエスはご自分のからだの神殿のことを言われたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","それで、イエスが死人の中からよみがえられたとき、弟子たちは、イエスがこのように言われたことを思い起こして、聖書とイエスが言われたことばとを信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","イエスが、過越の祭りの祝いの間、エルサレムにおられたとき、多くの人々が、イエスの行なわれたしるしを見て、御名を信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","しかし、イエスは、ご自身を彼らにお任せにならなかった。なぜなら、イエスはすべての人を知っておられたからであり、 ");
INSERT INTO jpn1965_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","また、イエスはご自身で、人のうちにあるものを知っておられたので、人についてだれの証言も必要とされなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","さて、パリサイ人の中にニコデモという人がいた。ユダヤ人の指導者であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","この人が、夜、イエスのもとに来て言った。「先生。私たちは、あなたが神のもとから来られた教師であることを知っています。神がともにおられるのでなければ、あなたがなさるこのようなしるしは、だれも行なうことができません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","イエスは答えて言われた。「まことに、まことに、あなたに告げます。人は、新しく生まれなければ、神の国を見ることはできません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ニコデモは言った。「人は、老年になっていて、どのようにして生まれることができるのですか。もう一度、母の胎にはいって生まれることができましょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","イエスは答えられた。「まことに、まことに、あなたに告げます。人は、水と御霊によって生まれなければ、神の国にはいることができません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","肉によって生まれた者は肉です。御霊によって生まれた者は霊です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","あなたがたは新しく生まれなければならない、とわたしが言ったことを不思議に思ってはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","風はその思いのままに吹き、あなたはその音を聞くが、それがどこから来てどこへ行くかを知らない。御霊によって生まれる者もみな、そのとおりです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ニコデモは答えて言った。「どうして、そのようなことがありうるのでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","イエスは答えて言われた。「あなたはイスラエルの教師でありながら、こういうことがわからないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","まことに、まことに、あなたに告げます。わたしたちは、知っていることを話し、見たことをあかししているのに、あなたがたは、わたしたちのあかしを受け入れません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","あなたがたは、わたしが地上のことを話したとき、信じないくらいなら、天上のことを話したとて、どうして信じるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","だれも天に上った者はいません。しかし天から下った者はいます。すなわち人の子です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","モーセが荒野で蛇を上げたように、人の子もまた上げられなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","それは、信じる者がみな、人の子にあって永遠のいのちを持つためです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","神は、実に、そのひとり子をお与えになったほどに、世を愛された。それは御子を信じる者が、ひとりとして滅びることなく、永遠のいのちを持つためである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","神が御子を世に遣わされたのは、世をさばくためではなく、御子によって世が救われるためである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","御子を信じる者はさばかれない。信じない者は神のひとり子の御名を信じなかったので、すでにさばかれている。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","そのさばきというのは、こうである。光が世に来ているのに、人々は光よりもやみを愛した。その行ないが悪かったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","悪いことをする者は光を憎み、その行ないが明るみに出されることを恐れて、光のほうに来ない。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","しかし、真理を行なう者は、光のほうに来る。その行ないが神にあってなされたことが明らかにされるためである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","その後、イエスは弟子たちと、ユダヤの地に行き、彼らとともにそこに滞在して、バプテスマを授けておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","一方ヨハネもサリムに近いアイノンでバプテスマを授けていた。そこには水が多かったからである。人々は次々にやって来て、バプテスマを受けていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","――ヨハネは、まだ投獄されていなかったからである。―― ");
INSERT INTO jpn1965_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","それで、ヨハネの弟子たちが、あるユダヤ人ときよめについて論議した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","彼らはヨハネのところに来て言った。「先生。見てください。ヨルダンの向こう岸であなたといっしょにいて、あなたが証言なさったあの方が、バプテスマを授けておられます。そして、みなあの方のほうへ行きます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ヨハネは答えて言った。「人は、天から与えられるのでなければ、何も受けることはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","あなたがたこそ、『私はキリストではなく、その前に遣わされた者である。』と私が言ったことの証人です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","花嫁を迎える者は花婿です。そこにいて、花婿のことばに耳を傾けているその友人は、花婿の声を聞いて大いに喜びます。それで、私もその喜びで満たされているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","あの方は盛んになり私は衰えなければなりません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","上から来る方は、すべてのものの上におられ、地から出る者は地に属し、地のことばを話す。天から来る方は、すべてのものの上におられる。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","この方は見たこと、また聞いたことをあかしされるが、だれもそのあかしを受け入れない。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","そのあかしを受け入れた者は、神は真実であるということに確認の印を押したのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","神がお遣わしになった方は、神のことばを話される。神が御霊を無限に与えられるからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","父は御子を愛しておられ、万物を御子の手にお渡しになった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","御子を信じる者は永遠のいのちを持つが、御子に聞き従わない者は、いのちを見ることがなく、神の怒りがその上にとどまる。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","イエスがヨハネよりも弟子を多くつくって、バプテスマを授けていることがパリサイ人の耳にはいった。それを主が知られたとき、 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","――イエスご自身はバプテスマを授けておられたのではなく、弟子たちであったが、―― ");
INSERT INTO jpn1965_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","主はユダヤを去って、またガリラヤへ行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","しかし、サマリヤを通って行かなければならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","それで主は、ヤコブがその子ヨセフに与えた地所に近いスカルというサマリヤの町に来られた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","そこにはヤコブの井戸があった。イエスは旅の疲れで、井戸のかたわらに腰をおろしておられた。時は六時ごろであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ひとりのサマリヤの女が水をくみに来た。イエスは「わたしに水を飲ませてください。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","弟子たちは食物を買いに、町へ出かけていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","そこで、そのサマリヤの女は言った。「あなたはユダヤ人なのに、どうしてサマリヤの女の私に、飲み水をお求めになるのですか。」――ユダヤ人はサマリヤ人とつきあいをしなかったからである。―― ");
INSERT INTO jpn1965_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","イエスは答えて言われた。「もしあなたが神の賜物を知り、また、あなたに水を飲ませてくれと言う者がだれであるかを知っていたなら、あなたのほうでその人に求めたことでしょう。そしてその人はあなたに生ける水を与えたことでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","彼女は言った。「先生。あなたはくむ物を持っておいでにならず、この井戸は深いのです。その生ける水をどこから手にお入れになるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","あなたは、私たちの先祖ヤコブよりも偉いのでしょうか。ヤコブは私たちにこの井戸を与え、彼自身も、彼の子たちも家畜も、この井戸から飲んだのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","イエスは答えて言われた。「この水を飲む者はだれでも、また渇きます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","しかし、わたしが与える水を飲む者はだれでも、決して渇くことがありません。わたしが与える水は、その人のうちで泉となり、永遠のいのちへの水がわき出ます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","女はイエスに言った。「先生。私が渇くことがなく、もうここまでくみに来なくてもよいように、その水を私に下さい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","イエスは彼女に言われた。「行って、あなたの夫をここに呼んで来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","女は答えて言った。「私には夫はありません。」イエスは言われた。「私には夫がないというのは、もっともです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","あなたには夫が五人あったが、今あなたといっしょにいるのは、あなたの夫ではないからです。あなたが言ったことはほんとうです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","女は言った。「先生。あなたは預言者だと思います。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","私たちの先祖は、この山で礼拝しましたが、あなたがたは、礼拝すべき場所はエルサレムだと言われます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","イエスは彼女に言われた。「わたしの言うことを信じなさい。あなたがたが父を礼拝するのは、この山でもなく、エルサレムでもない、そういう時が来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","救いはユダヤ人から出るのですから、わたしたちは知って礼拝していますが、あなたがたは知らないで礼拝しています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","しかし、真の礼拝者たちが霊とまことによって父を礼拝する時が来ます。今がその時です。父はこのような人々を礼拝者として求めておられるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","神は霊ですから、神を礼拝する者は、霊とまことによって礼拝しなければなりません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","女はイエスに言った。「私は、キリストと呼ばれるメシヤの来られることを知っています。その方が来られるときには、いっさいのことを私たちに知らせてくださるでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","イエスは言われた。「あなたと話しているこのわたしがそれです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","このとき、弟子たちが帰って来て、イエスが女の人と話しておられるのを不思議に思った。しかし、だれも、「何を求めておられるのですか。」とも、「なぜ彼女と話しておられるのですか。」とも言わなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","女は、自分の水がめを置いて町へ行き、人々に言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","「来て、見てください。私のしたこと全部を私に言った人がいるのです。この方がキリストなのでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","そこで、彼らは町を出て、イエスのほうへやって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","そのころ、弟子たちはイエスに、「先生。召し上がってください。」とお願いした。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","しかし、イエスは彼らに言われた。「わたしには、あなたがたの知らない食物があります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","そこで、弟子たちは互いに言った。「だれか食べる物を持って来たのだろうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","イエスは彼らに言われた。「わたしを遣わした方のみこころを行ない、そのみわざを成し遂げることが、わたしの食物です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","あなたがたは、『刈り入れ時が来るまでに、まだ四か月ある。』と言ってはいませんか。さあ、わたしの言うことを聞きなさい。目を上げて畑を見なさい。色づいて、刈り入れるばかりになっています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","すでに、刈る者は報酬を受け、永遠のいのちに入れられる実を集めています。それは蒔く者と刈る者がともに喜ぶためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","こういうわけで、『ひとりが種を蒔き、ほかの者が刈り取る。』ということわざは、ほんとうなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","わたしは、あなたがたに自分で労苦しなかったものを刈り取らせるために、あなたがたを遣わしました。ほかの人々が労苦して、あなたがたはその労苦の実を得ているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","さて、その町のサマリヤ人のうち多くの者が、「あの方は、私がしたこと全部を私に言った。」と証言したその女のことばによってイエスを信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","そこで、サマリヤ人たちはイエスのところに来たとき、自分たちのところに滞在してくださるように願った。そこでイエスは二日間そこに滞在された。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","そして、さらに多くの人々が、イエスのことばによって信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","そして彼らはその女に言った。「もう私たちは、あなたが話したことによって信じているのではありません。自分で聞いて、この方がほんとうに世の救い主だと知っているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","さて、二日の後、イエスはここを去って、ガリラヤへ行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","イエスご自身が、「預言者は自分の故郷では尊ばれない。」と証言しておられたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","そういうわけで、イエスがガリラヤに行かれたとき、ガリラヤ人はイエスを歓迎した。彼らも祭りに行っていたので、イエスが祭りの間にエルサレムでなさったすべてのことを見ていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","イエスは再びガリラヤのカナに行かれた。そこは、かつて水をぶどう酒にされた所である。さて、カペナウムに病気の息子がいる王室の役人がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","この人は、イエスがユダヤからガリラヤに来られたと聞いて、イエスのところへ行き、下って来て息子をいやしてくださるように願った。息子が死にかかっていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","そこで、イエスは彼に言われた。「あなたがたは、しるしと不思議を見ないかぎり、決して信じない。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","その王室の役人はイエスに言った。「主よ。どうか私の子どもが死なないうちに下って来てください。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","イエスは彼に言われた。「帰って行きなさい。あなたの息子は直っています。」その人はイエスが言われたことばを信じて、帰途についた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","彼が下って行く途中、そのしもべたちが彼に出会って、彼の息子が直ったことを告げた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","そこで子どもがよくなった時刻を彼らに尋ねると、「きのう、七時に熱がひきました。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","それで父親は、イエスが「あなたの息子は直っている。」と言われた時刻と同じであることを知った。そして彼自身と彼の家の者がみな信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","イエスはユダヤを去ってガリラヤにはいられてから、またこのことを第二のしるしとして行なわれたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","その後、ユダヤ人の祭りがあって、イエスはエルサレムに上られた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","さて、エルサレムには、羊の門の近くに、ヘブル語でベテスダと呼ばれる池があって、五つの回廊がついていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","その中に大ぜいの病人、盲人、足なえ、やせ衰えた者が伏せっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","5","そこに、三十八年もの間、病気にかかっている人がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","イエスは彼が伏せっているのを見、それがもう長い間のことなのを知って、彼に言われた。「よくなりたいか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","病人は答えた。「主よ。私には、水がかき回されたとき、池の中に私を入れてくれる人がいません。行きかけると、もうほかの人が先に降りて行くのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","イエスは彼に言われた。「起きて、床を取り上げて歩きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","すると、その人はすぐに直って、床を取り上げて歩き出した。 ところが、その日は安息日であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","そこでユダヤ人たちは、そのいやされた人に言った。「きょうは安息日だ。床を取り上げてはいけない。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","しかし、その人は彼らに答えた。「私を直してくださった方が、『床を取り上げて歩け。』と言われたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","彼らは尋ねた。「『取り上げて歩け。』と言った人はだれだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","しかし、いやされた人は、それがだれであるか知らなかった。人が大ぜいそこにいる間に、イエスは立ち去られたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","その後、イエスは宮の中で彼を見つけて言われた。「見なさい。あなたはよくなった。もう罪を犯してはなりません。そうでないともっと悪い事があなたの身に起こるから。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","その人は行って、ユダヤ人たちに、自分を直してくれた方はイエスだと告げた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","このためユダヤ人たちは、イエスを迫害した。イエスが安息日にこのようなことをしておられたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","イエスは彼らに答えられた。「わたしの父は今に至るまで働いておられます。ですからわたしも働いているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","このためユダヤ人たちは、ますますイエスを殺そうとするようになった。イエスが安息日を破っておられただけでなく、ご自身を神と等しくして、神を自分の父と呼んでおられたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","そこで、イエスは彼らに答えて言われた。「まことに、まことに、あなたがたに告げます。子は、父がしておられることを見て行なう以外には、自分からは何事も行なうことができません。父がなさることは何でも、子も同様に行なうのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","それは、父が子を愛して、ご自分のなさることをみな、子にお示しになるからです。また、これよりもさらに大きなわざを子に示されます。それは、あなたがたが驚き怪しむためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","父が死人を生かし、いのちをお与えになるように、子もまた、与えたいと思う者にいのちを与えます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","また、父はだれをもさばかず、すべてのさばきを子にゆだねられました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","それは、すべての者が、父を敬うように子を敬うためです。子を敬わない者は、子を遣わした父をも敬いません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","まことに、まことに、あなたがたに告げます。わたしのことばを聞いて、わたしを遣わした方を信じる者は、永遠のいのちを持ち、さばきに会うことがなく、死からいのちに移っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","まことに、まことに、あなたがたに告げます。死人が神の子の声を聞く時が来ます。今がその時です。そして、聞く者は生きるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","それは、父がご自分のうちにいのちを持っておられるように、子にも、自分のうちにいのちを持つようにしてくださったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","また、父はさばきを行なう権を子に与えられました。子は人の子だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","このことに驚いてはなりません。墓の中にいる者がみな、子の声を聞いて出て来る時が来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","善を行なった者は、よみがえっていのちを受け、悪を行なった者は、よみがえってさばきを受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","わたしは、自分からは何事も行なうことができません。ただ聞くとおりにさばくのです。そして、わたしのさばきは正しいのです。わたし自身の望むことを求めず、わたしを遣わした方のみこころを求めるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","もしわたしだけが自分のことを証言するのなら、わたしの証言は真実ではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","わたしについて証言する方がほかにあるのです。その方のわたしについて証言される証言が真実であることは、わたしが知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","あなたがたは、ヨハネのところに人をやりましたが、彼は真理について証言しました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","といっても、わたしは人の証言を受けるのではありません。わたしは、あなたがたが救われるために、そのことを言うのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","彼は燃えて輝くともしびであり、あなたがたはしばらくの間、その光の中で楽しむことを願ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","しかし、わたしにはヨハネの証言よりもすぐれた証言があります。父がわたしに成し遂げさせようとしてお与えになったわざ、すなわちわたしが行なっているわざそのものが、わたしについて、父がわたしを遣わしたことを証言しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","また、わたしを遣わした父ご自身がわたしについて証言しておられます。あなたがたは、まだ一度もその御声を聞いたこともなく、御姿を見たこともありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","また、そのみことばをあなたがたのうちにとどめてもいません。父が遣わした者をあなたがたが信じないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","あなたがたは、聖書の中に永遠のいのちがあると思うので、聖書を調べています。その聖書が、わたしについて証言しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","それなのに、あなたがたは、いのちを得るためにわたしのもとに来ようとはしません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","わたしは人からの栄誉は受けません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ただ、わたしはあなたがたを知っています。あなたがたのうちには、神の愛がありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","わたしはわたしの父の名によって来ましたが、あなたがたはわたしを受け入れません。ほかの人がその人自身の名において来れば、あなたがたはその人を受け入れるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","互いの栄誉は受けても、唯一の神からの栄誉を求めないあなたがたは、どうして信じることができますか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","わたしが、父の前にあなたがたを訴えようとしていると思ってはなりません。あなたがたを訴える者は、あなたがたが望みをおいているモーセです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","もしあなたがたがモーセを信じているのなら、わたしを信じたはずです。モーセが書いたのはわたしのことだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","しかし、あなたがたがモーセの書を信じないのであれば、どうしてわたしのことばを信じるでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","その後、イエスはガリラヤの湖、すなわち、テベリヤの湖の向こう岸へ行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","大ぜいの人の群れがイエスにつき従っていた。それはイエスが病人たちになさっていたしるしを見たからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","イエスは山に登り、弟子たちとともにそこにすわられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","さて、ユダヤ人の祭りである過越が間近になっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","イエスは目を上げて、大ぜいの人の群れがご自分のほうに来るのを見て、ピリポに言われた。「どこからパンを買って来て、この人々に食べさせようか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","もっとも、イエスは、ピリポをためしてこう言われたのであった。イエスは、ご自分では、しようとしていることを知っておられたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ピリポはイエスに答えた。「めいめいが少しずつ取るにしても、二百デナリのパンでは足りません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","弟子のひとりシモン・ペテロの兄弟アンデレがイエスに言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","「ここに少年が大麦のパンを五つと小さい魚を二匹持っています。しかし、こんなに大ぜいの人々では、それが何になりましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","イエスは言われた。「人々をすわらせなさい。」その場所には草が多かった。そこで男たちはすわった。その数はおよそ五千人であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","そこで、イエスはパンを取り、感謝をささげてから、すわっている人々に分けてやられた。また、小さい魚も同じようにして、彼らにほしいだけ分けられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","そして、彼らが十分食べたとき、弟子たちに言われた。「余ったパン切れを、一つもむだに捨てないように集めなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","彼らは集めてみた。すると、大麦のパン五つから出て来たパン切れを、人々が食べたうえ、なお余ったもので十二のかごがいっぱいになった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","人々は、イエスのなさったしるしを見て、「まことに、この方こそ、世に来られるはずの預言者だ。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","そこで、イエスは、人々が自分を王とするために、むりやりに連れて行こうとしているのを知って、ただひとり、また山に退かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","夕方になって、弟子たちは湖畔に降りて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","そして、舟に乗り込み、カペナウムのほうへ湖を渡っていた。すでに暗くなっていたが、イエスはまだ彼らのところに来ておられなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","湖は吹きまくる強風に荒れ始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","こうして、四、五千メートルほどこぎ出したころ、彼らは、イエスが湖の上を歩いて舟に近づいて来られるのを見て、恐れた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","しかし、イエスは彼らに言われた。「わたしだ。恐れることはない。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","それで彼らは、イエスを喜んで舟に迎えた。舟はほどなく目的の地に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","その翌日、湖の向こう岸にいた群衆は、そこには小舟が一隻あっただけで、ほかにはなかったこと、また、その舟にイエスは弟子たちといっしょに乗られないで、弟子たちだけが行ったということに気づいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","しかし、主が感謝をささげられてから、人々がパンを食べた場所の近くに、テベリヤから数隻の小舟が来た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","群衆は、イエスがそこにおられず、弟子たちもいないことを知ると、自分たちもその小舟に乗り込んで、イエスを捜してカペナウムに来た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","そして湖の向こう側でイエスを見つけたとき、彼らはイエスに言った。「先生。いつここにおいでになりましたか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","イエスは答えて言われた。「まことに、まことに、あなたがたに告げます。あなたがたがわたしを捜しているのは、しるしを見たからではなく、パンを食べて満腹したからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","なくなる食物のためではなく、いつまでも保ち、永遠のいのちに至る食物のために働きなさい。それこそ、人の子があなたがたに与えるものです。この人の子を父すなわち神が認証されたからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","すると彼らはイエスに言った。「私たちは、神のわざを行なうために、何をすべきでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","イエスは答えて言われた。「あなたがたが、神が遣わした者を信じること、それが神のわざです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","そこで彼らはイエスに言った。「それでは、私たちが見てあなたを信じるために、しるしとして何をしてくださいますか。どのようなことをなさいますか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","私たちの先祖は、荒野でマナを食べました。『彼は彼らに天からパンを与えて食べさせた。』と書いてあるとおりです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","イエスは彼らに言われた。「まことに、まことに、あなたがたに告げます。モーセはあなたがたに天からのパンを与えたのではありません。しかし、わたしの父は、あなたがたに天からまことのパンをお与えになります。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","というのは、神のパンは、天から下って来て、世にいのちを与えるものだからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","そこで彼らはイエスに言った。「主よ。いつもそのパンを私たちにお与えください。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","イエスは言われた。「わたしがいのちのパンです。わたしに来る者は決して飢えることがなく、わたしを信じる者はどんなときにも、決して渇くことがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","しかし、あなたがたはわたしを見ながら信じようとしないと、わたしはあなたがたに言いました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","父がわたしにお与えになる者はみな、わたしのところに来ます。そしてわたしのところに来る者を、わたしは決して捨てません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","わたしが天から下って来たのは、自分のこころを行なうためではなく、わたしを遣わした方のみこころを行なうためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","わたしを遣わした方のみこころは、わたしに与えてくださったすべての者を、わたしがひとりも失うことなく、ひとりひとりを終わりの日によみがえらせることです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","事実、わたしの父のみこころは、子を見て信じる者がみな永遠のいのちを持つことです。わたしはその人たちをひとりひとり終わりの日によみがえらせます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ユダヤ人たちは、イエスが「わたしは天から下って来たパンである。」と言われたので、イエスについてつぶやいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","彼らは言った。「あれはヨセフの子で、われわれはその父も母も知っている、そのイエスではないか。どうしていま彼は『わたしは天から下って来た。』と言うのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","イエスは彼らに答えて言われた。「互いにつぶやくのはやめなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","わたしを遣わした父が引き寄せられないかぎり、だれもわたしのところに来ることはできません。わたしは終わりの日にその人をよみがえらせます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","預言者の書に、『そして、彼らはみな神によって教えられる。』と書かれていますが、父から聞いて学んだ者はみな、わたしのところに来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","だれも神を見た者はありません。ただ神から出た者、すなわち、この者だけが、父を見たのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","まことに、まことに、あなたがたに告げます。信じる者は永遠のいのちを持ちます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","わたしはいのちのパンです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","あなたがたの先祖は荒野でマナを食べたが、死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","しかし、これは天から下って来たパンで、それを食べると死ぬことがないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","わたしは、天から下って来た生けるパンです。だれでもこのパンを食べるなら、永遠に生きます。またわたしが与えようとするパンは、世のいのちのための、わたしの肉です。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","すると、ユダヤ人たちは、「この人は、どのようにしてその肉を私たちに与えて食べさせることができるのか。」と言って互いに議論し合った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","イエスは彼らに言われた。「まことに、まことに、あなたがたに告げます。人の子の肉を食べ、またその血を飲まなければ、あなたがたのうちに、いのちはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","わたしの肉を食べ、わたしの血を飲む者は、永遠のいのちを持っています。わたしは終わりの日にその人をよみがえらせます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","わたしの肉はまことの食物、わたしの血はまことの飲み物だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","わたしの肉を食べ、わたしの血を飲む者は、わたしのうちにとどまり、わたしも彼のうちにとどまります。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","生ける父がわたしを遣わし、わたしが父によって生きているように、わたしを食べる者も、わたしによって生きるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","これは、天から下って来たパンです。あなたがたの先祖が食べて死んだようなものではありません。このパンを食べる者は永遠に生きます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","これは、イエスがカペナウムで教えられたとき、会堂で話されたことである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","そこで、弟子たちのうちの多くの者が、これを聞いて言った。「これはひどいことばだ。そんなことをだれが聞いておられようか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","しかし、イエスは、弟子たちがこうつぶやいているのを、知っておられ、彼らに言われた。「このことであなたがたはつまずくのか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","それでは、もし人の子がもといた所に上るのを見たら、どうなるのか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","いのちを与えるのは御霊です。肉は何の益ももたらしません。わたしがあなたがたに話したことばは、霊であり、またいのちです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","しかし、あなたがたのうちには信じない者がいます。」――イエスは初めから、信じない者がだれであるか、裏切る者がだれであるかを、知っておられたのである。―― ");
INSERT INTO jpn1965_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","そしてイエスは言われた。「それだから、わたしはあなたがたに、『父のみこころによるのでないかぎり、だれもわたしのところに来ることはできない。』と言ったのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","こういうわけで、弟子たちのうちの多くの者が離れ去って行き、もはやイエスとともに歩かなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","そこで、イエスは十二弟子に言われた。「まさか、あなたがたも離れたいと思うのではないでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","すると、シモン・ペテロが答えた。「主よ。私たちがだれのところに行きましょう。あなたは、永遠のいのちのことばを持っておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","私たちは、あなたが神の聖者であることを信じ、また知っています。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","イエスは彼らに答えられた。「わたしがあなたがた十二人を選んだのではありませんか。しかしそのうちのひとりは悪魔です。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","イエスはイスカリオテ・シモンの子ユダのことを言われたのであった。このユダは十二弟子のひとりであったが、イエスを売ろうとしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","その後、イエスはガリラヤを巡っておられた。それは、ユダヤ人たちがイエスを殺そうとしていたので、ユダヤを巡りたいとは思われなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","さて、仮庵の祭りというユダヤ人の祝いが近づいていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","そこで、イエスの兄弟たちはイエスに向かって言った。「あなたの弟子たちもあなたがしているわざを見ることができるように、ここを去ってユダヤに行きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","自分から公の場に出たいと思いながら、隠れた所で事を行なう者はありません。あなたがこれらの事を行なうのなら、自分を世に現わしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","兄弟たちもイエスを信じていなかったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","そこでイエスは彼らに言われた。「わたしの時はまだ来ていません。しかし、あなたがたの時はいつでも来ているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","世はあなたがたを憎むことはできません。しかしわたしを憎んでいます。わたしが、世について、その行ないが悪いことをあかしするからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","あなたがたは祭りに上って行きなさい。わたしはこの祭りには行きません。わたしの時がまだ満ちていないからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","こう言って、イエスはガリラヤにとどまられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","しかし、兄弟たちが祭りに上ったとき、イエスご自身も、公にではなく、いわば内密に上って行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ユダヤ人たちは、祭りのとき、「あの方はどこにおられるのか。」と言って、イエスを捜していた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","そして群衆の間には、イエスについて、いろいろとひそひそ話がされていた。「良い人だ。」と言う者もあり、「違う。群衆を惑わしているのだ。」と言う者もいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","しかし、ユダヤ人たちを恐れたため、イエスについて公然と語る者はひとりもいなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","しかし、祭りもすでに中ごろになったとき、イエスは宮に上って教え始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ユダヤ人たちは驚いて言った。「この人は正規に学んだことがないのに、どうして学問があるのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","そこでイエスは彼らに答えて言われた。「わたしの教えは、わたしのものではなく、わたしを遣わした方のものです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","だれでも神のみこころを行なおうと願うなら、その人には、この教えが神から出たものか、わたしが自分から語っているのかがわかります。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","自分から語る者は、自分の栄光を求めます。しかし自分を遣わした方の栄光を求める者は真実であり、その人には不正がありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","モーセがあなたがたに律法を与えたではありませんか。それなのに、あなたがたはだれも、律法を守っていません。あなたがたは、なぜわたしを殺そうとするのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","群衆は答えた。「あなたは悪霊につかれています。だれがあなたを殺そうとしているのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","イエスは彼らに答えて言われた。「わたしは一つのわざをしました。それであなたがたはみな驚いています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","モーセはこのためにあなたがたに割礼を与えました。――ただし、それはモーセから始まったのではなく、先祖たちからです。――それで、あなたがたは安息日にも人に割礼を施しています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","もし、人がモーセの律法が破られないようにと、安息日にも割礼を受けるのなら、わたしが安息日に人の全身をすこやかにしたからといって、何でわたしに腹を立てるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","うわべによって人をさばかないで、正しいさばきをしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","そこで、エルサレムのある人たちが言った。「この人は、彼らが殺そうとしている人ではないか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","見なさい。この人は公然と語っているのに、彼らはこの人に何も言わない。議員たちは、この人がキリストであることを、ほんとうに知ったのだろうか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","けれども、私たちはこの人がどこから来たのか知っている。しかし、キリストが来られるとき、それが、どこからか知っている者はだれもいないのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","イエスは、宮で教えておられるとき、大声をあげて言われた。「あなたがたはわたしを知っており、また、わたしがどこから来たかも知っています。しかし、わたしは自分で来たのではありません。わたしを遣わした方は真実です。あなたがたは、その方を知らないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","わたしはその方を知っています。なぜなら、わたしはその方から出たのであり、その方がわたしを遣わしたからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","そこで人々はイエスを捕えようとしたが、しかし、だれもイエスに手をかけた者はなかった。イエスの時が、まだ来ていなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","群衆のうちの多くの者がイエスを信じて言った。「キリストが来られても、この方がしているよりも多くのしるしを行なわれるだろうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","パリサイ人は、群衆がイエスについてこのようなことをひそひそと話しているのを耳にした。それで祭司長、パリサイ人たちは、イエスを捕えようとして、役人たちを遣わした。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","そこでイエスは言われた。「まだしばらくの間、わたしはあなたがたといっしょにいて、それから、わたしを遣わした方のもとに行きます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","あなたがたはわたしを捜しますが、見いだすことはありません。また、わたしがいる所に、あなたがたは来ることができません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","そこで、ユダヤ人たちは互いに言った。「私たちには、見つからないという。それならあの人はどこへ行こうとしているのか。まさかギリシヤ人の中に離散している人々のところへ行って、ギリシヤ人を教えるつもりではあるまい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","『あなたがたはわたしを捜すが、見いだすことはない。』また『わたしのいる所にあなたがたは来ることができない。』とあの人が言ったこのことばは、どういう意味だろうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","さて、祭りの終わりの大いなる日に、イエスは立って、大声で言われた。「だれでも渇いているなら、わたしのもとに来て飲みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","わたしを信じる者は、聖書が言っているとおりに、その人の心の奥底から、生ける水の川が流れ出るようになる。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","これは、イエスを信じる者が後になってから受ける御霊のことを言われたのである。イエスはまだ栄光を受けておられなかったので、御霊はまだ注がれていなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","このことばを聞いて、群衆のうちのある者は、「あの方は、確かにあの預言者なのだ。」と言い、 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","またある者は、「この方はキリストだ。」と言った。またある者は言った。「まさか、キリストはガリラヤからは出ないだろう。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","キリストはダビデの子孫から、またダビデがいたベツレヘムの村から出る、と聖書が言っているではないか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","そこで、群衆の間にイエスのことで分裂が起こった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","その中にはイエスを捕えたいと思った者もいたが、イエスに手をかけた者はなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","それから役人たちは祭司長、パリサイ人たちのもとに帰って来た。彼らは役人たちに言った。「なぜあの人を連れて来なかったのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","役人たちは答えた。「あの人が話すように話した人は、いまだかつてありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","すると、パリサイ人が答えた。「おまえたちも惑わされているのか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","議員とかパリサイ人のうちで、だれかイエスを信じた者があったか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","だが、律法を知らないこの群衆は、のろわれている。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","彼らのうちのひとりで、イエスのもとに来たことのあるニコデモが彼らに言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","「私たちの律法では、まずその人から直接聞き、その人が何をしているのか知ったうえでなければ、判決を下さないのではないか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","彼らは答えて言った。「あなたもガリラヤの出身なのか。調べてみなさい。ガリラヤから預言者は起こらない。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","［そして人々はそれぞれ家に帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","イエスはオリーブ山に行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","そして、朝早く、イエスはもう一度宮にはいられた。民衆はみな、みもとに寄って来た。イエスはすわって、彼らに教え始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","すると、律法学者とパリサイ人が、姦淫の場で捕えられたひとりの女を連れて来て、真中に置いてから、 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","イエスに言った。「先生。この女は姦淫の現場でつかまえられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","モーセは律法の中で、こういう女を石打ちにするように命じています。ところで、あなたは何と言われますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","彼らはイエスをためしてこう言ったのである。それは、イエスを告発する理由を得るためであった。しかし、イエスは身をかがめて、指で地面に書いておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","けれども、彼らが問い続けてやめなかったので、イエスは身を起こして言われた。「あなたがたのうちで罪のない者が、最初に彼女に石を投げなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","そしてイエスは、もう一度身をかがめて、地面に書かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","彼らはそれを聞くと、年長者たちから始めて、ひとりひとり出て行き、イエスがひとり残された。女はそのままそこにいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","イエスは身を起こして、その女に言われた。「婦人よ。あの人たちは今どこにいますか。あなたを罪に定める者はなかったのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","彼女は言った。「だれもいません。」そこで、イエスは言われた。「わたしもあなたを罪に定めない。行きなさい。今からは決して罪を犯してはなりません。」］ ");
INSERT INTO jpn1965_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","イエスはまた彼らに語って言われた。「わたしは、世の光です。わたしに従う者は、決してやみの中を歩むことがなく、いのちの光を持つのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","そこでパリサイ人はイエスに言った。「あなたは自分のことを自分で証言しています。だから、あなたの証言は真実ではありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","イエスは答えて、彼らに言われた。「もしこのわたしが自分のことを証言するなら、その証言は真実です。わたしは、わたしがどこから来たか、また、どこへ行くかを知っているからです。しかしあなたがたは、わたしがどこから来たのか、またどこへ行くのか知りません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","あなたがたは肉によってさばきます。わたしはだれをもさばきません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","しかし、もしわたしがさばくなら、そのさばきは正しいのです。なぜなら、わたしひとりではなく、わたしとわたしを遣わした方とがさばくのだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","あなたがたの律法にも、ふたりの証言は真実であると書かれています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","わたしが自分の証人であり、また、わたしを遣わした父が、わたしについてあかしされます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","すると、彼らはイエスに言った。「あなたの父はどこにいるのですか。」イエスは答えられた。「あなたがたは、わたしをも、わたしの父をも知りません。もし、あなたがたがわたしを知っていたなら、わたしの父をも知っていたでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","イエスは宮で教えられたとき、献金箱のある所でこのことを話された。しかし、だれもイエスを捕えなかった。イエスの時がまだ来ていなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","イエスはまた彼らに言われた。「わたしは去って行きます。あなたがたはわたしを捜すけれども、自分の罪の中で死にます。わたしが行く所に、あなたがたは来ることができません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","そこで、ユダヤ人たちは言った。「あの人は『わたしが行く所に、あなたがたは来ることができない。』と言うが、自殺するつもりなのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","それでイエスは彼らに言われた。「あなたがたが来たのは下からであり、わたしが来たのは上からです。あなたがたはこの世の者であり、わたしはこの世の者ではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","それでわたしは、あなたがたが自分の罪の中で死ぬと、あなたがたに言ったのです。もしあなたがたが、わたしのことを信じなければ、あなたがたは自分の罪の中で死ぬのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","そこで、彼らはイエスに言った。「あなたはだれですか。」イエスは言われた。「初めからわたしがあなたがたに話して来たことは何でしたか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","あなたがたについて言うべきこと、さばくべきことがたくさんあります。しかし、わたしを遣わした方は真実であって、わたしはその方から聞いたことをそのまま世に告げるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","彼らは、イエスが父のことを語っておられたことを悟らなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","イエスは言われた。「あなたがたが人の子を上げてしまうと、その時、あなたがたは、わたしが何であるか、また、わたしがわたし自身からは何事もせず、ただ父がわたしに教えられたとおりに、これらのことを話していることを、知るようになります。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","わたしを遣わした方はわたしとともにおられます。わたしをひとり残されることはありません。わたしがいつも、そのみこころにかなうことを行なうからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","イエスがこれらのことを話しておられると、多くの者がイエスを信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","そこでイエスは、その信じたユダヤ人たちに言われた。「もしあなたがたが、わたしのことばにとどまるなら、あなたがたはほんとうにわたしの弟子です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","そして、あなたがたは真理を知り、真理はあなたがたを自由にします。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","彼らはイエスに答えた。「私たちはアブラハムの子孫であって、決してだれの奴隷になったこともありません。あなたはどうして、『あなたがたは自由になる。』と言われるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","イエスは彼らに答えられた。「まことに、まことに、あなたがたに告げます。罪を行なっている者はみな、罪の奴隷です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","奴隷はいつまでも家にいるのではありません。しかし、息子はいつまでもいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ですから、もし子があなたがたを自由にするなら、あなたがたはほんとうに自由なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","わたしは、あなたがたがアブラハムの子孫であることを知っています。しかしあなたがたはわたしを殺そうとしています。わたしのことばが、あなたがたのうちにはいっていないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","わたしは父のもとで見たことを話しています。ところが、あなたがたは、あなたがたの父から示されたことを行なうのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","彼らは答えて言った。「私たちの父はアブラハムです。」イエスは彼らに言われた。「あなたがたがアブラハムの子どもなら、アブラハムのわざを行ないなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ところが今あなたがたは、神から聞いた真理をあなたがたに話しているこのわたしを、殺そうとしています。アブラハムはそのようなことはしなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","あなたがたは、あなたがたの父のわざを行なっています。」彼らは言った。「私たちは不品行によって生まれた者ではありません。私たちにはひとりの父、神があります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","イエスは言われた。「神がもしあなたがたの父であるなら、あなたがたはわたしを愛するはずです。なぜなら、わたしは神から出て来てここにいるからです。わたしは自分で来たのではなく、神がわたしを遣わしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","あなたがたは、なぜわたしの話していることがわからないのでしょう。それは、あなたがたがわたしのことばに耳を傾けることができないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","あなたがたは、あなたがたの父である悪魔から出た者であって、あなたがたの父の欲望を成し遂げたいと願っているのです。悪魔は初めから人殺しであり、真理に立ってはいません。彼のうちには真理がないからです。彼が偽りを言うときは、自分にふさわしい話し方をしているのです。なぜなら彼は偽り者であり、また偽りの父であるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","しかし、このわたしは真理を話しているために、あなたがたはわたしを信じません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","あなたがたのうちだれか、わたしに罪があると責める者がいますか。わたしが真理を話しているなら、なぜわたしを信じないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","神から出た者は、神のことばに聞き従います。ですから、あなたがたが聞き従わないのは、あなたがたが神から出た者でないからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ユダヤ人たちは答えて、イエスに言った。「私たちが、あなたはサマリヤ人で、悪霊につかれていると言うのは当然ではありませんか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","イエスは答えられた。「わたしは悪霊につかれてはいません。わたしは父を敬っています。しかしあなたがたは、わたしを卑しめています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","しかし、わたしはわたしの栄誉を求めません。それをお求めになり、さばきをなさる方がおられます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","まことに、まことに、あなたがたに告げます。だれでもわたしのことばを守るならば、その人は決して死を見ることがありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ユダヤ人たちはイエスに言った。「あなたが悪霊につかれていることが、今こそわかりました。アブラハムは死に、預言者たちも死にました。しかし、あなたは、『だれでもわたしのことばを守るならば、その人は決して死を味わうことがない。』と言うのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","あなたは、私たちの父アブラハムよりも偉大なのですか。そのアブラハムは死んだのです。預言者たちもまた死にました。あなたは、自分自身をだれだと言うのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","イエスは答えられた。「わたしがもし自分自身に栄光を帰するなら、わたしの栄光はむなしいものです。わたしに栄光を与える方は、わたしの父です。この方のことを、あなたがたは『私たちの神である。』と言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","けれどもあなたがたはこの方を知ってはいません。しかし、わたしは知っています。もしわたしがこの方を知らないと言うなら、わたしはあなたがたと同様に偽り者となるでしょう。しかし、わたしはこの方を知っており、そのみことばを守っています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","あなたがたの父アブラハムは、わたしの日を見ることを思って大いに喜びました。彼はそれを見て、喜んだのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","そこで、ユダヤ人たちはイエスに向かって言った。「あなたはまだ五十歳になっていないのにアブラハムを見たのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","イエスは彼らに言われた。「まことに、まことに、あなたがたに告げます。アブラハムが生まれる前から、わたしはいるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","すると彼らは石を取ってイエスに投げつけようとした。しかし、イエスは身を隠して、宮から出て行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","またイエスは道の途中で、生まれつきの盲人を見られた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","弟子たちは彼についてイエスに質問して言った。「先生。彼が盲目に生まれついたのは、だれが罪を犯したからですか。この人ですか。その両親ですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","イエスは答えられた。「この人が罪を犯したのでもなく、両親でもありません。神のわざがこの人に現われるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","わたしたちは、わたしを遣わした方のわざを、昼の間に行なわなければなりません。だれも働くことのできない夜が来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","わたしが世にいる間、わたしは世の光です。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","イエスは、こう言ってから、地面につばきをして、そのつばきで泥を作られた。そしてその泥を盲人の目に塗って言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","「行って、シロアム（訳して言えば、遣わされた者）の池で洗いなさい。」そこで、彼は行って、洗った。すると、見えるようになって、帰って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","近所の人たちや、前に彼がこじきをしていたのを見ていた人たちが言った。「これはすわって物ごいをしていた人ではないか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ほかの人は、「これはその人だ。」と言い、またほかの人は、「そうではない。ただその人に似ているだけだ。」と言った。当人は、「私がその人です。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","そこで、彼らは言った。「それでは、あなたの目はどのようにしてあいたのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","彼は答えた。「イエスという方が、泥を作って、私の目に塗り、『シロアムの池に行って洗いなさい。』と私に言われました。それで、行って洗うと、見えるようになりました。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","また彼らは彼に言った。「その人はどこにいるのですか。」彼は「私は知りません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","彼らは、前に盲目であったその人を、パリサイ人たちのところに連れて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ところで、イエスが泥を作って彼の目をあけられたのは、安息日であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","こういうわけでもう一度、パリサイ人も彼に、どのようにして見えるようになったかを尋ねた。彼は言った。「あの方が私の目に泥を塗ってくださって、私が洗いました。私はいま見えるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","すると、パリサイ人の中のある人々が、「その人は神から出たのではない。安息日を守らないからだ。」と言った。しかし、ほかの者は言った。「罪人である者に、どうしてこのようなしるしを行なうことができよう。」そして、彼らの間に、分裂が起こった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","そこで彼らはもう一度、盲人に言った。「あの人が目をあけてくれたことで、あの人を何だと思っているのか。」彼は言った。「あの方は預言者です。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","しかしユダヤ人たちは、目が見えるようになったこの人について、彼が盲目であったが見えるようになったということを信ぜず、ついにその両親を呼び出して、 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","尋ねて言った。「この人はあなたがたの息子で、生まれつき盲目だったとあなたがたが言っている人ですか。それでは、どうしていま見えるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","そこで両親は答えた。「私たちは、これが私たちの息子で、生まれつき盲目だったことを知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","しかし、どのようにしていま見えるのかは知りません。また、だれがあれの目をあけたのか知りません。あれに聞いてください。あれはもうおとなです。自分のことは自分で話すでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","彼の両親がこう言ったのは、ユダヤ人たちを恐れたからであった。すでにユダヤ人たちは、イエスをキリストであると告白する者があれば、その者を会堂から追放すると決めていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","そのために彼の両親は、「あれはもうおとなです。あれに聞いてください。」と言ったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","そこで彼らは、盲目であった人をもう一度呼び出して言った。「神に栄光を帰しなさい。私たちはあの人が罪人であることを知っているのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","彼は答えた。「あの方が罪人かどうか、私は知りません。ただ一つのことだけ知っています。私は盲目であったのに、今は見えるということです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","そこで彼らは言った。「あの人はおまえに何をしたのか。どのようにしてその目をあけたのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","彼は答えた。「もうお話ししたのですが、あなたがたは聞いてくれませんでした。なぜもう一度聞こうとするのです。あなたがたも、あの方の弟子になりたいのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","彼らは彼をののしって言った。「おまえもあの者の弟子だ。しかし私たちはモーセの弟子だ。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","私たちは、神がモーセにお話しになったことは知っている。しかし、あの者については、どこから来たのか知らないのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","彼は答えて言った。「これは、驚きました。あなたがたは、あの方がどこから来られたのか、ご存じないと言う。しかし、あの方は私の目をおあけになったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","神は、罪人の言うことはお聞きになりません。しかし、だれでも神を敬い、そのみこころを行なうなら、神はその人の言うことを聞いてくださると、私たちは知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","盲目に生まれついた者の目をあけた者があるなどとは、昔から聞いたこともありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","もしあの方が神から出ておられるのでなかったら、何もできないはずです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","彼らは答えて言った。「おまえは全く罪の中に生まれていながら、私たちを教えるのか。」そして、彼を外に追い出した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","イエスは、彼らが彼を追放したことを聞き、彼を見つけ出して言われた。「あなたは人の子を信じますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","その人は答えた。「主よ。その方はどなたでしょうか。私がその方を信じることができますように。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","イエスは彼に言われた。「あなたはその方を見たのです。あなたと話しているのがそれです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","彼は言った。「主よ。私は信じます。」そして彼はイエスを拝した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","そこで、イエスは言われた。「わたしはさばきのためにこの世に来ました。それは、目の見えない者が見えるようになり、見える者が盲目となるためです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","パリサイ人の中でイエスとともにいた人々が、このことを聞いて、イエスに言った。「私たちも盲目なのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","イエスは彼らに言われた。「もしあなたがたが盲目であったなら、あなたがたに罪はなかったでしょう。しかし、あなたがたは今、『私たちは目が見える。』と言っています。あなたがたの罪は残るのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","「まことに、まことに、あなたがたに告げます。羊の囲いに門からはいらないで、ほかの所を乗り越えて来る者は、盗人で強盗です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","しかし、門からはいる者は、その羊の牧者です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","門番は彼のために開き、羊はその声を聞き分けます。彼は自分の羊をその名で呼んで連れ出します。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","彼は、自分の羊をみな引き出すと、その先頭に立って行きます。すると羊は、彼の声を知っているので、彼について行きます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","しかし、ほかの人には決してついて行きません。かえって、その人から逃げ出します。その人たちの声を知らないからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","イエスはこのたとえを彼らにお話しになったが、彼らは、イエスの話されたことが何のことかよくわからなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","そこで、イエスはまた言われた。「まことに、まことに、あなたがたに告げます。わたしは羊の門です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","わたしの前に来た者はみな、盗人で強盗です。羊は彼らの言うことを聞かなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","わたしは門です。だれでも、わたしを通ってはいるなら、救われます。また安らかに出入りし、牧草を見つけます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","盗人が来るのは、ただ盗んだり、殺したり、滅ぼしたりするだけのためです。わたしが来たのは、羊がいのちを得、またそれを豊かに持つためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","わたしは、良い牧者です。良い牧者は羊のためにいのちを捨てます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","牧者でなく、また、羊の所有者でない雇い人は、狼が来るのを見ると、羊を置き去りにして、逃げて行きます。それで、狼は羊を奪い、また散らすのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","それは、彼が雇い人であって、羊のことを心にかけていないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","わたしは良い牧者です。わたしはわたしのものを知っています。また、わたしのものは、わたしを知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","それは、父がわたしを知っておられ、わたしが父を知っているのと同様です。また、わたしは羊のためにわたしのいのちを捨てます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","わたしにはまた、この囲いに属さないほかの羊があります。わたしはそれをも導かなければなりません。彼らはわたしの声に聞き従い、一つの群れ、ひとりの牧者となるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","わたしが自分のいのちを再び得るために自分のいのちを捨てるからこそ、父はわたしを愛してくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","だれも、わたしからいのちを取った者はいません。わたしが自分からいのちを捨てるのです。わたしには、それを捨てる権威があり、それをもう一度得る権威があります。わたしはこの命令をわたしの父から受けたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","このみことばを聞いて、ユダヤ人たちの間にまた分裂が起こった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","彼らのうちの多くの者が言った。「あれは悪霊につかれて気が狂っている。どうしてあなたがたは、あの人の言うことに耳を貸すのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ほかの者は言った。「これは悪霊につかれた者のことばではない。悪霊がどうして盲人の目をあけることができようか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","そのころ、エルサレムで、宮きよめの祭りがあった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","時は冬であった。イエスは、宮の中で、ソロモンの廊を歩いておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","それでユダヤ人たちは、イエスを取り囲んで言った。「あなたは、いつまで私たちに気をもませるのですか。もしあなたがキリストなら、はっきりとそう言ってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","イエスは彼らに答えられた。「わたしは話しました。しかし、あなたがたは信じないのです。わたしが父の御名によって行なうわざが、わたしについて証言しています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","しかし、あなたがたは信じません。それは、あなたがたがわたしの羊に属していないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","わたしの羊はわたしの声を聞き分けます。またわたしは彼らを知っています。そして彼らはわたしについて来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","わたしは彼らに永遠のいのちを与えます。彼らは決して滅びることがなく、また、だれもわたしの手から彼らを奪い去るようなことはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","わたしに彼らをお与えになった父は、すべてにまさって偉大です。だれもわたしの父の御手から彼らを奪い去ることはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","わたしと父とは一つです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ユダヤ人たちは、イエスを石打ちにしようとして、また石を取り上げた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","イエスは彼らに答えられた。「わたしは、父から出た多くの良いわざを、あなたがたに示しました。そのうちのどのわざのために、わたしを石打ちにしようとするのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ユダヤ人たちはイエスに答えた。「良いわざのためにあなたを石打ちにするのではありません。冒涜のためです。あなたは人間でありながら、自分を神とするからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","イエスは彼らに答えられた。「あなたがたの律法に、『わたしは言った、あなたがたは神である。』と書いてはありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","もし、神のことばを受けた人々を、神と呼んだとすれば、聖書は廃棄されるものではないから、 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","『わたしは神の子である。』とわたしが言ったからといって、どうしてあなたがたは、父が、聖別して世に遣わした者について、『神を冒涜している。』と言うのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","もしわたしが、わたしの父のみわざを行なっていないのなら、わたしを信じないでいなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","しかし、もし行なっているなら、たといわたしの言うことが信じられなくても、わざを信用しなさい。それは、父がわたしにおられ、わたしが父にいることを、あなたがたが悟り、また知るためです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","そこで、彼らはまたイエスを捕えようとした。しかし、イエスは彼らの手からのがれられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","そして、イエスはまたヨルダンを渡って、ヨハネが初めにバプテスマを授けていた所に行かれ、そこに滞在された。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","多くの人々がイエスのところに来た。彼らは、「ヨハネは何一つしるしを行なわなかったけれども、彼がこの方について話したことはみな真実であった。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","そして、その地方で多くの人々がイエスを信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","さて、ある人が病気にかかっていた。ラザロといって、マリヤとその姉妹マルタとの村の出で、ベタニヤの人であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","このマリヤは、主に香油を塗り、髪の毛でその足をぬぐったマリヤであって、彼女の兄弟ラザロが病んでいたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","そこで姉妹たちは、イエスのところに使いを送って、言った。「主よ。ご覧ください。あなたが愛しておられる者が病気です。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","イエスはこれを聞いて、言われた。「この病気は死で終わるだけのものではなく、神の栄光のためのものです。神の子がそれによって栄光を受けるためです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","イエスはマルタとその姉妹とラザロとを愛しておられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","そのようなわけで、イエスは、ラザロが病んでいることを聞かれたときも、そのおられた所になお二日とどまられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","その後、イエスは、「もう一度ユダヤに行こう。」と弟子たちに言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","弟子たちはイエスに言った。「先生。たった今ユダヤ人たちが、あなたを石打ちにしようとしていたのに、またそこにおいでになるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","イエスは答えられた。「昼間は十二時間あるでしょう。だれでも、昼間歩けば、つまずくことはありません。この世の光を見ているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","しかし、夜歩けばつまずきます。光がその人のうちにないからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","イエスは、このように話され、それから、弟子たちに言われた。「わたしたちの友ラザロは眠っています。しかし、わたしは彼を眠りからさましに行くのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","そこで弟子たちはイエスに言った。「主よ。眠っているのなら、彼は助かるでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","しかし、イエスは、ラザロの死のことを言われたのである。だが、彼らは眠った状態のことを言われたものと思った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","そこで、イエスはそのとき、はっきりと彼らに言われた。「ラザロは死んだのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","わたしは、あなたがたのため、すなわちあなたがたが信じるためには、わたしがその場に居合わせなかったことを喜んでいます。さあ、彼のところへ行きましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","そこで、デドモと呼ばれるトマスが、弟子の仲間に言った。「私たちも行って、主といっしょに死のうではないか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","それで、イエスがおいでになってみると、ラザロは墓の中に入れられて四日もたっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ベタニヤはエルサレムに近く、三千メートルほど離れた所にあった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","大ぜいのユダヤ人がマルタとマリヤのところに来ていた。その兄弟のことについて慰めるためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","マルタは、イエスが来られたと聞いて迎えに行った。マリヤは家ですわっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","マルタはイエスに向かって言った。「主よ。もしここにいてくださったなら、私の兄弟は死ななかったでしょうに。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","今でも私は知っております。あなたが神にお求めになることは何でも、神はあなたにお与えになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","イエスは彼女に言われた。「あなたの兄弟はよみがえります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","マルタはイエスに言った。「私は、終わりの日のよみがえりの時に、彼がよみがえることを知っております。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","イエスは言われた。「わたしは、よみがえりです。いのちです。わたしを信じる者は、死んでも生きるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","また、生きていてわたしを信じる者は、決して死ぬことがありません。このことを信じますか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","彼女はイエスに言った。「はい。主よ。私は、あなたが世に来られる神の子キリストである、と信じております。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","こう言ってから、帰って行って、姉妹マリヤを呼び、「先生が見えています。あなたを呼んでおられます。」とそっと言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","マリヤはそれを聞くと、すぐ立ち上がって、イエスのところに行った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","さてイエスは、まだ村にはいらないで、マルタが出迎えた場所におられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","マリヤとともに家にいて、彼女を慰めていたユダヤ人たちは、マリヤが急いで立ち上がって出て行くのを見て、マリヤが墓に泣きに行くのだろうと思い、彼女について行った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","マリヤは、イエスのおられた所に来て、お目にかかると、その足もとにひれ伏して言った。「主よ。もしここにいてくださったなら、私の兄弟は死ななかったでしょうに。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","そこでイエスは、彼女が泣き、彼女といっしょに来たユダヤ人たちも泣いているのをご覧になると、霊の憤りを覚え、心の動揺を感じて、 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","言われた。「彼をどこに置きましたか。」彼らはイエスに言った。「主よ。来てご覧ください。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","イエスは涙を流された。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","そこで、ユダヤ人たちは言った。「ご覧なさい。主はどんなに彼を愛しておられたことか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","しかし、「盲人の目をあけたこの方が、あの人を死なせないでおくことはできなかったのか。」と言う者もいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","そこでイエスは、またも心のうちに憤りを覚えながら、墓に来られた。墓はほら穴であって、石がそこに立てかけてあった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","イエスは言われた。「その石を取りのけなさい。」死んだ人の姉妹マルタは言った。「主よ。もう臭くなっておりましょう。四日になりますから。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","イエスは彼女に言われた。「もしあなたが信じるなら、あなたは神の栄光を見る、とわたしは言ったではありませんか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","そこで、彼らは石を取りのけた。イエスは目を上げて、言われた。「父よ。わたしの願いを聞いてくださったことを感謝いたします。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","わたしは、あなたがいつもわたしの願いを聞いてくださることを知っておりました。しかしわたしは、回りにいる群衆のために、この人々が、あなたがわたしをお遣わしになったことを信じるようになるために、こう申したのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","そして、イエスはそう言われると、大声で叫ばれた。「ラザロよ。出て来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","すると、死んでいた人が、手と足を長い布で巻かれたままで出て来た。彼の顔は布切れで包まれていた。イエスは彼らに言われた。「ほどいてやって、帰らせなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","そこで、マリヤのところに来ていて、イエスがなさったことを見た多くのユダヤ人が、イエスを信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","しかし、そのうちの幾人かは、パリサイ人たちのところへ行って、イエスのなさったことを告げた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","そこで、祭司長とパリサイ人たちは議会を召集して言った。「われわれは何をしているのか。あの人が多くのしるしを行なっているというのに。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","もしあの人をこのまま放っておくなら、すべての人があの人を信じるようになる。そうなると、ローマ人がやって来て、われわれの土地も国民も奪い取ることになる。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","しかし、彼らのうちのひとりで、その年の大祭司であったカヤパが、彼らに言った。「あなたがたは全然何もわかっていない。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ひとりの人が民の代わりに死んで、国民全体が滅びないほうが、あなたがたにとって得策だということも、考えに入れていない。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ところで、このことは彼が自分から言ったのではなくて、その年の大祭司であったので、イエスが国民のために死のうとしておられること、 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","また、ただ国民のためだけでなく、散らされている神の子たちを一つに集めるためにも死のうとしておられることを、預言したのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","そこで彼らは、その日から、イエスを殺すための計画を立てた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","そのために、イエスはもはやユダヤ人たちの間を公然と歩くことをしないで、そこから荒野に近い地方に去り、エフライムという町にはいり、弟子たちとともにそこに滞在された。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","さて、ユダヤ人の過越の祭りが間近であった。多くの人々が、身を清めるために、過越の祭りの前にいなかからエルサレムに上って来た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","彼らはイエスを捜し、宮の中に立って、互いに言った。「あなたがたはどう思いますか。あの方は祭りに来られることはないでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","さて、祭司長、パリサイ人たちはイエスを捕えるために、イエスがどこにいるかを知っている者は届け出なければならないという命令を出していた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","イエスは過越の祭りの六日前にベタニヤに来られた。そこには、イエスが死人の中からよみがえらせたラザロがいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","人々はイエスのために、そこに晩餐を用意した。そしてマルタは給仕していた。ラザロは、イエスとともに食卓に着いている人々の中に混じっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","マリヤは、非常に高価な、純粋なナルドの香油三百グラムを取って、イエスの足に塗り、彼女の髪の毛でイエスの足をぬぐった。家は香油のかおりでいっぱいになった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ところが、弟子のひとりで、イエスを裏切ろうとしているイスカリオテ・ユダが言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","「なぜ、この香油を三百デナリに売って、貧しい人々に施さなかったのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","しかしこう言ったのは、彼が貧しい人々のことを心にかけていたからではなく、彼は盗人であって、金入れを預かっていたが、その中に収められたものを、いつも盗んでいたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","イエスは言われた。「そのままにしておきなさい。マリヤはわたしの葬りの日のために、それを取っておこうとしていたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","あなたがたは、貧しい人々とはいつもいっしょにいるが、わたしとはいつもいっしょにいるわけではないからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","大ぜいのユダヤ人の群れが、イエスがそこにおられることを聞いて、やって来た。それはただイエスのためだけではなく、イエスによって死人の中からよみがえったラザロを見るためでもあった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","祭司長たちはラザロも殺そうと相談した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","それは、彼のために多くのユダヤ人が去って行き、イエスを信じるようになったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","その翌日、祭りに来ていた大ぜいの人の群れは、イエスがエルサレムに来ようとしておられると聞いて、 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","しゅろの木の枝を取って、出迎えのために出て行った。そして大声で叫んだ。 「ホサナ。 祝福あれ。 主の御名によって来られる方に。 イスラエルの王に。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","イエスは、ろばの子を見つけて、それに乗られた。それは次のように書かれているとおりであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","「恐れるな。シオンの娘。 見よ。あなたの王が来られる。 ろばの子に乗って。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","初め、弟子たちにはこれらのことがわからなかった。しかし、イエスが栄光を受けられてから、これらのことがイエスについて書かれたことであって、人々がそのとおりにイエスに対して行なったことを、彼らは思い出した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","イエスがラザロを墓から呼び出し、死人の中からよみがえらせたときにイエスといっしょにいた大ぜいの人々は、そのことのあかしをした。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","そのために群衆もイエスを出迎えた。イエスがこれらのしるしを行なわれたことを聞いたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","そこで、パリサイ人たちは互いに言った。「どうしたのだ。何一つうまくいっていない。見なさい。世はあげてあの人のあとについて行ってしまった。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","さて、祭りのとき礼拝のために上って来た人々の中に、ギリシヤ人が幾人かいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","この人たちがガリラヤのベツサイダの人であるピリポのところに来て、「先生。イエスにお目にかかりたいのですが。」と言って頼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ピリポは行ってアンデレに話し、アンデレとピリポとは行って、イエスに話した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","すると、イエスは彼らに答えて言われた。「人の子が栄光を受けるその時が来ました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","まことに、まことに、あなたがたに告げます。一粒の麦がもし地に落ちて死ななければ、それは一つのままです。しかし、もし死ねば、豊かな実を結びます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","自分のいのちを愛する者はそれを失い、この世でそのいのちを憎む者はそれを保って永遠のいのちに至るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","わたしに仕えるというのなら、その人はわたしについて来なさい。わたしがいる所に、わたしに仕える者もいるべきです。もしわたしに仕えるなら、父はその人に報いてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","今わたしの心は騒いでいる。何と言おうか。『父よ。この時からわたしをお救いください。』と言おうか。いや。このためにこそ、わたしはこの時に至ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","父よ。御名の栄光を現わしてください。」そのとき、天から声が聞こえた。「わたしは栄光をすでに現わしたし、またもう一度栄光を現わそう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","そばに立っていてそれを聞いた群衆は、雷が鳴ったのだと言った。ほかの人々は、「御使いがあの方に話したのだ。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","イエスは答えて言われた。「この声が聞こえたのは、わたしのためにではなくて、あなたがたのためにです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","今がこの世のさばきです。今、この世を支配する者は追い出されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","わたしが地上から上げられるなら、わたしはすべての人を自分のところに引き寄せます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","イエスは自分がどのような死に方で死ぬかを示して、このことを言われたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","そこで、群衆はイエスに答えた。「私たちは、律法で、キリストはいつまでも生きておられると聞きましたが、どうしてあなたは、人の子は上げられなければならない、と言われるのですか。その人の子とはだれですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","イエスは彼らに言われた。「まだしばらくの間、光はあなたがたの間にあります。やみがあなたがたを襲うことのないように、あなたがたは、光がある間に歩きなさい。やみの中を歩く者は、自分がどこに行くのかわかりません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","あなたがたに光がある間に、光の子どもとなるために、光を信じなさい。」 イエスは、これらのことをお話しになると、立ち去って、彼らから身を隠された。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","イエスが彼らの目の前でこのように多くのしるしを行なわれたのに、彼らはイエスを信じなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","それは、「主よ。だれが私たちの知らせを信じましたか。また主の御腕はだれに現わされましたか。」と言った預言者イザヤのことばが成就するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","彼らが信じることができなかったのは、イザヤがまた次のように言ったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","「主は彼らの目を盲目にされた。また、彼らの心をかたくなにされた。それは、彼らが目で見、心で理解し、回心し、そしてわたしが彼らをいやす、ということがないためである。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","イザヤがこう言ったのは、イザヤがイエスの栄光を見たからで、イエスをさして言ったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","しかし、それにもかかわらず、指導者たちの中にもイエスを信じる者がたくさんいた。ただ、パリサイ人たちをはばかって、告白はしなかった。会堂から追放されないためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","彼らは、神からの栄誉よりも、人の栄誉を愛したからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","また、イエスは大声で言われた。「わたしを信じる者は、わたしではなく、わたしを遣わした方を信じるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","また、わたしを見る者は、わたしを遣わした方を見るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","わたしは光として世に来ました。わたしを信じる者が、だれもやみの中にとどまることのないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","だれかが、わたしの言うことを聞いてそれを守らなくても、わたしはその人をさばきません。わたしは世をさばくために来たのではなく、世を救うために来たからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","わたしを拒み、わたしの言うことを受け入れない者には、その人をさばくものがあります。わたしが話したことばが、終わりの日にその人をさばくのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","わたしは、自分から話したのではありません。わたしを遣わした父ご自身が、わたしが何を言い、何を話すべきかをお命じになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","わたしは、父の命令が永遠のいのちであることを知っています。それゆえ、わたしが話していることは、父がわたしに言われたとおりを、そのままに話しているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","さて、過越の祭りの前に、この世を去って父のみもとに行くべき自分の時が来たことを知られたので、世にいる自分のものを愛されたイエスは、その愛を残るところなく示された。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","夕食の間のことであった。悪魔はすでにシモンの子イスカリオテ・ユダの心に、イエスを売ろうとする思いを入れていたが、 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","イエスは、父が万物を自分の手に渡されたことと、ご自分が父から来て父に行くことを知られ、 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","夕食の席から立ち上がって、上着を脱ぎ、手ぬぐいを取って腰にまとわれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","それから、たらいに水を入れ、弟子たちの足を洗って、腰にまとっておられる手ぬぐいで、ふき始められた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","こうして、イエスはシモン・ペテロのところに来られた。ペテロはイエスに言った。「主よ。あなたが、私の足を洗ってくださるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","イエスは答えて言われた。「わたしがしていることは、今はあなたにはわからないが、あとでわかるようになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ペテロはイエスに言った。「決して私の足をお洗いにならないでください。」イエスは答えられた。「もしわたしが洗わなければ、あなたはわたしと何の関係もありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","シモン・ペテロは言った。「主よ。私の足だけでなく、手も頭も洗ってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","イエスは彼に言われた。「水浴した者は、足以外は洗う必要がありません。全身きよいのです。あなたがたはきよいのですが、みながそうではありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","イエスはご自分を裏切る者を知っておられた。それで、「みながきよいのではない。」と言われたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","イエスは、彼らの足を洗い終わり、上着を着けて、再び席に着いて、彼らに言われた。「わたしがあなたがたに何をしたか、わかりますか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","あなたがたはわたしを先生とも主とも呼んでいます。あなたがたがそう言うのはよい。わたしはそのような者だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","それで、主であり師であるこのわたしが、あなたがたの足を洗ったのですから、あなたがたもまた互いに足を洗い合うべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","わたしがあなたがたにしたとおりに、あなたがたもするように、わたしはあなたがたに模範を示したのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","まことに、まことに、あなたがたに告げます。しもべはその主人にまさらず、遣わされた者は遣わした者にまさるものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","あなたがたがこれらのことを知っているのなら、それを行なうときに、あなたがたは祝福されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","わたしは、あなたがた全部の者について言っているのではありません。わたしは、わたしが選んだ者を知っています。しかし聖書に『わたしのパンを食べている者が、わたしに向かってかかとを上げた。』と書いてあることは成就するのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","わたしは、そのことが起こる前に、今あなたがたに話しておきます。そのことが起こったときに、わたしがその人であることをあなたがたが信じるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","まことに、まことに、あなたがたに告げます。わたしの遣わす者を受け入れる者は、わたしを受け入れるのです。わたしを受け入れる者は、わたしを遣わした方を受け入れるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","イエスは、これらのことを話されたとき、霊の激動を感じ、あかしして言われた。「まことに、まことに、あなたがたに告げます。あなたがたのうちのひとりが、わたしを裏切ります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","弟子たちは、だれのことを言われたのか、わからずに当惑して、互いに顔を見合わせていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","弟子のひとりで、イエスが愛しておられた者が、イエスの右側で席に着いていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","そこで、シモン・ペテロが彼に合図をして言った。「だれのことを言っておられるのか、知らせなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","その弟子は、イエスの右側で席に着いたまま、イエスに言った。「主よ。それはだれですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","イエスは答えられた。「それはわたしがパン切れを浸して与える者です。」それからイエスは、パン切れを浸し、取って、イスカリオテ・シモンの子ユダにお与えになった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","彼がパン切れを受けると、そのとき、サタンが彼にはいった。そこで、イエスは彼に言われた。「あなたがしようとしていることを、今すぐしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","席に着いている者で、イエスが何のためにユダにそう言われたのか知っている者は、だれもなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ユダが金入れを持っていたので、イエスが彼に、「祭りのために入用の物を買え。」と言われたのだとか、または、貧しい人々に何か施しをするように言われたのだとか思った者も中にはいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ユダは、パン切れを受けるとすぐ、外に出て行った。すでに夜であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ユダが出て行ったとき、イエスは言われた。「今こそ人の子は栄光を受けました。また、神は人の子によって栄光をお受けになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","神が、人の子によって栄光をお受けになったのであれば、神も、ご自身によって人の子に栄光をお与えになります。しかも、ただちにお与えになります。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","子どもたちよ。わたしはいましばらくの間、あなたがたといっしょにいます。あなたがたはわたしを捜すでしょう。そして、『わたしが行く所へは、あなたがたは来ることができない。』とわたしがユダヤ人たちに言ったように、今はあなたがたにも言うのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","あなたがたに新しい戒めを与えましょう。あなたがたは互いに愛し合いなさい。わたしがあなたがたを愛したように、そのように、あなたがたも互いに愛し合いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","もしあなたがたの互いの間に愛があるなら、それによって、あなたがたがわたしの弟子であることを、すべての人が認めるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","シモン・ペテロがイエスに言った。「主よ。どこにおいでになるのですか。」イエスは答えられた。「わたしが行く所に、あなたは今はついて来ることができません。しかし後にはついて来ます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ペテロはイエスに言った。「主よ。なぜ今はあなたについて行くことができないのですか。あなたのためにはいのちも捨てます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","イエスは答えられた。「わたしのためにはいのちも捨てる、と言うのですか。まことに、まことに、あなたに告げます。鶏が鳴くまでに、あなたは三度わたしを知らないと言います。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","「あなたがたは心を騒がしてはなりません。神を信じ、またわたしを信じなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","わたしの父の家には、住まいがたくさんあります。もしなかったら、あなたがたに言っておいたでしょう。あなたがたのために、わたしは場所を備えに行くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","わたしが行って、あなたがたに場所を備えたら、また来て、あなたがたをわたしのもとに迎えます。わたしのいる所に、あなたがたをもおらせるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","わたしの行く道はあなたがたも知っています。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","トマスはイエスに言った。「主よ。どこへいらっしゃるのか、私たちにはわかりません。どうして、その道が私たちにわかりましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","イエスは彼に言われた。「わたしが道であり、真理であり、いのちなのです。わたしを通してでなければ、だれひとり父のみもとに来ることはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","あなたがたは、もしわたしを知っていたなら、父をも知っていたはずです。しかし、今や、あなたがたは父を知っており、また、すでに父を見たのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ピリポはイエスに言った。「主よ。私たちに父を見せてください。そうすれば満足します。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","イエスは彼に言われた。「ピリポ。こんなに長い間あなたがたといっしょにいるのに、あなたはわたしを知らなかったのですか。わたしを見た者は、父を見たのです。どうしてあなたは、『私たちに父を見せてください。』と言うのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","わたしが父におり、父がわたしにおられることを、あなたは信じないのですか。わたしがあなたがたに言うことばは、わたしが自分から話しているのではありません。わたしのうちにおられる父が、ご自分のわざをしておられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","わたしが父におり、父がわたしにおられるとわたしが言うのを信じなさい。さもなければ、わざによって信じなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","まことに、まことに、あなたがたに告げます。わたしを信じる者は、わたしの行なうわざを行ない、またそれよりもさらに大きなわざを行ないます。わたしが父のもとに行くからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","またわたしは、あなたがたがわたしの名によって求めることは何でも、それをしましょう。父が子によって栄光をお受けになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","あなたがたが、わたしの名によって何かをわたしに求めるなら、わたしはそれをしましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","もしあなたがたがわたしを愛するなら、あなたがたはわたしの戒めを守るはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","わたしは父にお願いします。そうすれば、父はもうひとりの助け主をあなたがたにお与えになります。その助け主がいつまでもあなたがたと、ともにおられるためにです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","その方は、真理の御霊です。世はその方を受け入れることができません。世はその方を見もせず、知りもしないからです。しかし、あなたがたはその方を知っています。その方はあなたがたとともに住み、あなたがたのうちにおられるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","わたしは、あなたがたを捨てて孤児にはしません。わたしは、あなたがたのところに戻って来るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","いましばらくで世はもうわたしを見なくなります。しかし、あなたがたはわたしを見ます。わたしが生きるので、あなたがたも生きるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","その日には、わたしが父におり、あなたがたがわたしにおり、わたしがあなたがたにおることが、あなたがたにわかります。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","わたしの戒めを保ち、それを守る人は、わたしを愛する人です。わたしを愛する人はわたしの父に愛され、わたしもその人を愛し、わたし自身を彼に現わします。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","イスカリオテでないユダがイエスに言った。「主よ。あなたは、私たちにはご自分を現わそうとしながら、世には現わそうとなさらないのは、どういうわけですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","イエスは彼に答えられた。「だれでもわたしを愛する人は、わたしのことばを守ります。そうすれば、わたしの父はその人を愛し、わたしたちはその人のところに来て、その人とともに住みます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","わたしを愛さない人は、わたしのことばを守りません。あなたがたが聞いていることばは、わたしのものではなく、わたしを遣わした父のことばなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","このことをわたしは、あなたがたといっしょにいる間に、あなたがたに話しました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","しかし、助け主、すなわち、父がわたしの名によってお遣わしになる聖霊は、あなたがたにすべてのことを教え、また、わたしがあなたがたに話したすべてのことを思い起こさせてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","わたしは、あなたがたに平安を残します。わたしは、あなたがたにわたしの平安を与えます。わたしがあなたがたに与えるのは、世が与えるのとは違います。あなたがたは心を騒がしてはなりません。恐れてはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","『わたしは去って行き、また、あなたがたのところに来る。』とわたしが言ったのを、あなたがたは聞きました。あなたがたは、もしわたしを愛しているなら、わたしが父のもとに行くことを喜ぶはずです。父はわたしよりも偉大な方だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","そして今わたしは、そのことの起こる前にあなたがたに話しました。それが起こったときに、あなたがたが信じるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","わたしは、もう、あなたがたに多くは話すまい。この世を支配する者が来るからです。彼はわたしに対して何もすることはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","しかしそのことは、わたしが父を愛しており、父の命じられたとおりに行なっていることを世が知るためです。立ちなさい。さあ、ここから行くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","わたしはまことのぶどうの木であり、わたしの父は農夫です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","わたしの枝で実を結ばないものはみな、父がそれを取り除き、実を結ぶものはみな、もっと多く実を結ぶために、刈り込みをなさいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","あなたがたは、わたしがあなたがたに話したことばによって、もう刈り込みが済むんだのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","わたしにとどまりなさい。わたしも、あなたがたの中にとどまります。枝がぶどうの木についていなければ、枝だけでは実を結ぶことができません。同様にあなたがたも、わたしにとどまっていなければ、実を結ぶことはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","わたしはぶどうの木で、あなたがたは枝です。人がわたしにとどまり、わたしもその人の中にとどまっているなら、そういう人は多くの実を結びます。わたしを離れては、あなたがたは何もすることができないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","だれでも、もしわたしにとどまっていなければ、枝のように投げ捨てられて、枯れます。人々はそれを寄せ集めて火に投げ込むので、それは燃えてしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","あなたがたがわたしにとどまり、わたしのことばがあなたがたにとどまるなら、何でもあなたがたのほしいものを求めなさい。そうすれば、あなたがたのためにそれがかなえられます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","あなたがたが多くの実を結び、わたしの弟子となることによって、わたしの父は栄光をお受けになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","父がわたしを愛されたように、わたしもあなたがたを愛しました。わたしの愛の中にとどまりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","もし、あなたがたがわたしの戒めを守るなら、あなたがたはわたしの愛にとどまるのです。それは、わたしがわたしの父の戒めを守って、わたしの父の愛の中にとどまっているのと同じです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","わたしがこれらのことをあなたがたに話したのは、わたしの喜びがあなたがたのうちにあり、あなたがたの喜びが満たされるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","わたしがあなたがたを愛したように、あなたがたも互いに愛し合うこと、これがわたしの戒めです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","人がその友のためにいのちを捨てるという、これよりも大きな愛はだれも持っていません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","わたしがあなたがたに命じることをあなたがたが行なうなら、あなたがたはわたしの友です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","わたしはもはや、あなたがたをしもべとは呼びません。しもべは主人のすることを知らないからです。わたしはあなたがたを友と呼びました。なぜなら父から聞いたことをみな、あなたがたに知らせたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","あなたがたがわたしを選んだのではありません。わたしがあなたがたを選び、あなたがたを任命したのです。それは、あなたがたが行って実を結び、そのあなたがたの実が残るためであり、また、あなたがたがわたしの名によって父に求めるものは何でも、父があなたがたにお与えになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","あなたがたが互いに愛し合うこと、これが、わたしのあなたがたに与える戒めです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","もし世があなたがたを憎むなら、世はあなたがたよりもわたしを先に憎んだことを知っておきなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","もしあなたがたがこの世のものであったなら、世は自分のものを愛したでしょう。しかし、あなたがたは世のものではなく、かえってわたしが世からあなたがたを選び出したのです。それで世はあなたがたを憎むのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","しもべはその主人にまさるものではない、とわたしがあなたがたに言ったことばを覚えておきなさい。もし人々がわたしを迫害したなら、あなたがたをも迫害します。もし彼らがわたしのことばを守ったなら、あなたがたのことばをも守ります。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","しかし彼らは、わたしの名のゆえに、あなたがたに対してそれらのことをみな行ないます。それは彼らがわたしを遣わした方を知らないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","もしわたしが来て彼らに話さなかったら、彼らに罪はなかったでしょう。しかし今では、その罪について弁解の余地はありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","わたしを憎んでいる者は、わたしの父をも憎んでいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","もしわたしが、ほかのだれも行なったことのないわざを、彼らの間で行なわなかったのなら、彼らには罪がなかったでしょう。しかし今、彼らはわたしをも、わたしの父をも見て、そのうえで憎んだのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","これは、『彼らは理由なしにわたしを憎んだ。』と彼らの律法に書かれていることばが成就するためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","わたしが父のもとから遣わす助け主、すなわち父から出る真理の御霊が来るとき、その御霊がわたしについてあかしします。 ");
INSERT INTO jpn1965_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","あなたがたもあかしするのです。初めからわたしといっしょにいたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","これらのことをあなたがたに話したのは、あなたがたがつまずくことのないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","人々はあなたがたを会堂から追放するでしょう。事実、あなたがたを殺す者がみな、そうすることで自分は神に奉仕しているのだと思う時が来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","彼らがこういうことを行なうのは、父をもわたしをも知らないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","しかし、わたしがこれらのことをあなたがたに話したのは、その時が来れば、わたしがそれについて話したことを、あなたがたが思い出すためです。わたしが初めからこれらのことをあなたがたに話さなかったのは、わたしがあなたがたといっしょにいたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","しかし今わたしは、わたしを遣わした方のもとに行こうとしています。しかし、あなたがたのうちには、ひとりとして、どこに行くのですかと尋ねる者がありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","かえって、わたしがこれらのことをあなたがたに話したために、あなたがたの心は悲しみでいっぱいになっています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","しかし、わたしは真実を言います。わたしが去って行くことは、あなたがたにとって益なのです。それは、もしわたしが去って行かなければ、助け主があなたがたのところに来ないからです。しかし、もし行けば、わたしは助け主をあなたがたのところに遣わします。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","その方が来ると、罪について、義について、さばきについて、世にその誤りを認めさせます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","罪についてというのは、彼らがわたしを信じないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","また、義についてとは、わたしが父のもとに行き、あなたがたがもはやわたしを見なくなるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","さばきについてとは、この世を支配する者がさばかれたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","わたしには、あなたがたに話すことがまだたくさんありますが、今あなたがたはそれに耐える力がありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","しかし、その方、すなわち真理の御霊が来ると、あなたがたをすべての真理に導き入れます。御霊は自分から語るのではなく、聞くままを話し、また、やがて起ころうとしていることをあなたがたに示すからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","御霊はわたしの栄光を現わします。わたしのものを受けて、あなたがたに知らせるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","父が持っておられるものはみな、わたしのものです。ですからわたしは、御霊がわたしのものを受けて、あなたがたに知らせると言ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","しばらくするとあなたがたは、もはやわたしを見なくなります。しかし、またしばらくするとわたしを見ます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","そこで、弟子たちのうちのある者は互いに言った。「『しばらくするとあなたがたは、わたしを見なくなる。しかし、またしばらくするとわたしを見る。』また『わたしは父のもとに行くからだ。』と主が言われるのは、どういうことなのだろう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","そこで、彼らは「しばらくすると、と主が言われるのは何のことだろうか。私たちには主の言われることがわからない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","イエスは、彼らが質問したがっていることを知って、彼らに言われた。「『しばらくするとあなたがたは、わたしを見なくなる。しかし、またしばらくするとわたしを見る。』とわたしが言ったことについて、互いに論じ合っているのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","まことに、まことに、あなたがたに告げます。あなたがたは泣き、嘆き悲しむが、世は喜ぶのです。あなたがたは悲しむが、しかし、あなたがたの悲しみは喜びに変わります。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","女が子を産むときには、その時が来たので苦しみます。しかし、子を産んでしまうと、ひとりの人が世に生まれた喜びのために、もはやその激しい苦痛を忘れてしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","あなたがたにも、今は悲しみがあるが、わたしはもう一度あなたがたに会います。そうすれば、あなたがたの心は喜びに満たされます。そして、その喜びをあなたがたから奪い去る者はありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","その日には、あなたがたはもはや、わたしに何も尋ねません。まことに、まことに、あなたがたに告げます。あなたがたが父に求めることは何でも、父は、わたしの名によってそれをあなたがたにお与えになります。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","あなたがたは今まで、何もわたしの名によって求めたことはありません。求めなさい。そうすれば受けるのです。それはあなたがたの喜びが満ち満ちたものとなるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","これらのことを、わたしはあなたがたにたとえで話しました。もはやたとえでは話さないで、父についてはっきりと告げる時が来ます。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","その日には、あなたがたはわたしの名によって求めるのです。わたしはあなたがたに代わって父に願ってあげようとは言いません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","それはあなたがたがわたしを愛し、また、わたしを神から出て来た者と信じたので、父ご自身があなたがたを愛しておられるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","わたしは父から出て、世に来ました。もう一度、わたしは世を去って父のみもとに行きます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","弟子たちは言った。「ああ、今あなたははっきりとお話しになって、何一つたとえ話はなさいません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","いま私たちは、あなたがいっさいのことをご存じで、だれもあなたにお尋ねする必要がないことがわかりました。これで、私たちはあなたが神から来られたことを信じます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","イエスは彼らに答えられた。「あなたがたは今、信じているのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","見なさい。あなたがたが散らされて、それぞれ自分の家に帰り、わたしをひとり残す時が来ます。いや、すでに来ています。しかし、わたしはひとりではありません。父がわたしといっしょにおられるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","わたしがこれらのことをあなたがたに話したのは、あなたがたがわたしにあって平安を持つためです。あなたがたは、世にあっては患難があります。しかし、勇敢でありなさい。わたしはすでに世に勝ったのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","イエスはこれらのことを話してから、目を天に向けて、言われた。「父よ。時が来ました。あなたの子があなたの栄光を現わすために、子の栄光を現わしてください。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","それは子が、あなたからいただいたすべての者に、永遠のいのちを与えるため、あなたは、すべての人を支配する権威を子にお与えになったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","その永遠のいのちとは、彼らが唯一のまことの神であるあなたと、あなたの遣わされたイエス・キリストとを知ることです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","あなたがわたしに行なわせるためにお与えになったわざを、わたしは成し遂げて、地上であなたの栄光を現わしました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","今は、父よ、みそばで、わたしを栄光で輝かせてください。世界が存在する前に、ごいっしょにいて持っていましたあの栄光で輝かせてください。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","わたしは、あなたが世から取り出してわたしに下さった人々に、あなたの御名を明らかにしました。彼らはあなたのものであって、あなたは彼らをわたしに下さいました。彼らはあなたのみことばを守りました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","いま彼らは、あなたがわたしに下さったものはみな、あなたから出ていることを知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","それは、あなたがわたしに下さったみことばを、わたしが彼らに与えたからです。彼らはそれを受け入れ、わたしがあなたから出て来たことを確かに知り、また、あなたがわたしを遣わされたことを信じました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","わたしは彼らのためにお願いします。世のためにではなく、あなたがわたしに下さった者たちのためにです。なぜなら彼らはあなたのものだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","わたしのものはみなあなたのもの、あなたのものはわたしのものです。そして、わたしは彼らによって栄光を受けました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","わたしはもう世にいなくなります。彼らは世におりますが、わたしはあなたのみもとにまいります。聖なる父。あなたがわたしに下さっているあなたの御名の中に、彼らを保ってください。それはわたしたちと同様に、彼らが一つとなるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","わたしは彼らといっしょにいたとき、あなたがわたしに下さっている御名の中に彼らを保ち、また守りました。彼らのうちだれも滅びた者はなく、ただ滅びの子が滅びました。それは、聖書が成就するためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","わたしは今みもとにまいります。わたしは彼らの中でわたしの喜びが全うされるために、世にあってこれらのことを話しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","わたしは彼らにあなたのみことばを与えました。しかし、世は彼らを憎みました。わたしがこの世のものでないように、彼らもこの世のものでないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","彼らをこの世から取り去ってくださるようにというのではなく、悪い者から守ってくださるようにお願いします。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","わたしがこの世のものでないように、彼らもこの世のものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","真理によって彼らを聖別してください。あなたのみことばは真理です。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","あなたがわたしを世に遣わされたように、わたしも彼らを世に遣わしました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","わたしは、彼らのため、わたし自身を聖別します。彼ら自身も真理によって聖別されるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","わたしは、ただこの人々のためだけでなく、彼らのことばによってわたしを信じる人々のためにもお願いします。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","それは、父よ、あなたがわたしにおられ、わたしがあなたにいるように、彼らがみな一つとなるためです。また、彼らもわたしたちにおるようになるためです。そのことによって、あなたがわたしを遣わされたことを、世が信じるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","またわたしは、あなたがわたしに下さった栄光を、彼らに与えました。それは、わたしたちが一つであるように、彼らも一つであるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","わたしは彼らにおり、あなたはわたしにおられます。それは、彼らが全うされて一つとなるためです。それは、あなたがわたしを遣わされたことと、あなたがわたしを愛されたように彼らをも愛されたこととを、この世が知るためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","父よ。お願いします。あなたがわたしに下さったものをわたしのいる所にわたしといっしょにおらせてください。あなたがわたしを世の始まる前から愛しておられたためにわたしに下さったわたしの栄光を、彼らが見るようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","正しい父よ。この世はあなたを知りません。しかし、わたしはあなたを知っています。また、この人々は、あなたがわたしを遣わされたことを知りました。 ");
INSERT INTO jpn1965_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","そして、わたしは彼らにあなたの御名を知らせました。また、これからも知らせます。それは、あなたがわたしを愛してくださったその愛が彼らの中にあり、またわたしが彼らの中にいるためです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","イエスはこれらのことを話し終えられると、弟子たちとともに、ケデロンの川筋の向こう側に出て行かれた。そこに園があって、イエスは弟子たちといっしょに、そこにはいられた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ところで、イエスを裏切ろうとしていたユダもその場所を知っていた。イエスがたびたび弟子たちとそこで会合されたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","そこで、ユダは一隊の兵士と、祭司長、パリサイ人たちから送られた役人たちを引き連れて、ともしびとたいまつと武器を持って、そこに来た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","イエスは自分の身に起ころうとするすべてのことを知っておられたので、出て来て、「だれを捜すのか。」と彼らに言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","彼らは、「ナザレ人イエスを。」と答えた。イエスは彼らに「それはわたしです。」と言われた。イエスを裏切ろうとしていたユダも彼らといっしょに立っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","イエスが彼らに、「それはわたしです。」と言われたとき、彼らはあとずさりし、そして地に倒れた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","そこで、イエスがもう一度、「だれを捜すのか。」と問われると、彼らは「ナザレ人イエスを。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","イエスは答えられた。「それはわたしだと、あなたがたに言ったでしょう。もしわたしを捜しているのなら、この人たちはこのままで去らせなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","それは、「あなたがわたしに下さった者のうち、ただのひとりをも失いませんでした。」とイエスが言われたことばが実現するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","シモン・ペテロは、剣を持っていたが、それを抜き、大祭司のしもべを撃ち、右の耳を切り落とした。そのしもべの名はマルコスであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","そこで、イエスはペテロに言われた。「剣をさやに収めなさい。父がわたしに下さった杯を、どうして飲まずにいられよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","そこで、一隊の兵士と千人隊長、それにユダヤ人から送られた役人たちは、イエスを捕えて縛り、 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","まずアンナスのところに連れて行った。彼がその年の大祭司カヤパのしゅうとだったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","カヤパは、ひとりの人が民に代わって死ぬことが得策である、とユダヤ人に助言した人である。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","シモン・ペテロともうひとりの弟子は、イエスについて行った。この弟子は大祭司の知り合いで、イエスといっしょに大祭司の中庭にはいった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","しかし、ペテロは外で門のところに立っていた。それで、大祭司の知り合いである、もうひとりの弟子が出て来て、門番の女に話して、ペテロを連れてはいった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","すると、門番のはしためがペテロに、「あなたもあの人の弟子ではないでしょうね。」と言った。ペテロは、「そんな者ではない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","寒かったので、しもべたちや役人たちは、炭火をおこし、そこに立って暖まっていた。ペテロも彼らといっしょに、立って暖まっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","そこで、大祭司はイエスに、弟子たちのこと、また、教えのことについて尋問した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","イエスは彼に答えられた。「わたしは世に向かって公然と話しました。わたしはユダヤ人がみな集まって来る会堂や宮で、いつも教えたのです。隠れて話したことは何もありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","なぜ、あなたはわたしに尋ねるのですか。わたしが人々に何を話したかは、わたしから聞いた人たちに尋ねなさい。彼らならわたしが話した事がらを知っています。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","イエスがこう言われたとき、そばに立っていた役人のひとりが、「大祭司にそのような答え方をするのか。」と言って、平手でイエスを打った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","イエスは彼に答えられた。「もしわたしの言ったことが悪いなら、その悪い証拠を示しなさい。しかし、もし正しいなら、なぜ、わたしを打つのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","アンナスはイエスを、縛ったままで大祭司カヤパのところに送った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","一方、シモン・ペテロは立って、暖まっていた。すると、人々は彼に言った。「あなたもあの人の弟子ではないでしょうね。」ペテロは否定して、「そんな者ではない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","大祭司のしもべのひとりで、ペテロに耳を切り落とされた人の親類に当たる者が言った。「私が見なかったとでもいうのですか。あなたは園であの人といっしょにいました。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","それで、ペテロはもう一度否定した。するとすぐ鶏が鳴いた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","さて、彼らはイエスを、カヤパのところから総督官邸に連れて行った。時は明け方であった。彼らは、過越の食事が食べられなくなることのないように、汚れを受けまいとして、官邸にはいらなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","そこで、ピラトは彼らのところに出て来て言った。「あなたがたは、この人に対して何を告発するのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","彼らはピラトに答えた。「もしこの人が悪いことをしていなかったら、私たちはこの人をあなたに引き渡しはしなかったでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","そこでピラトは彼らに言った。「あなたがたがこの人を引き取り、自分たちの律法に従ってさばきなさい。」ユダヤ人たちは彼に言った。「私たちには、だれを死刑にすることも許されてはいません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","これは、ご自分がどのような死に方をされるのかを示して話されたイエスのことばが成就するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","そこで、ピラトはもう一度官邸にはいって、イエスを呼んで言った。「あなたは、ユダヤ人の王ですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","イエスは答えられた。「あなたは、自分でそのことを言っているのですか。それともほかの人が、あなたにわたしのことを話したのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ピラトは答えた。「私はユダヤ人ではないでしょう。あなたの同国人と祭司長たちが、あなたを私に引き渡したのです。あなたは何をしたのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","イエスは答えられた。「わたしの国はこの世のものではありません。もしこの世のものであったなら、わたしのしもべたちが、わたしをユダヤ人に渡さないように、戦ったことでしょう。しかし、事実、わたしの国はこの世のものではありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","そこでピラトはイエスに言った。「それでは、あなたは王なのですか。」イエスは答えられた。「わたしが王であることは、あなたが言うとおりです。わたしは、真理のあかしをするために生まれ、このことのために世に来たのです。真理に属する者はみな、わたしの声に聞き従います。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ピラトはイエスに言った。「真理とは何ですか。」 彼はこう言ってから、またユダヤ人たちのところに出て行って、彼らに言った。「私は、あの人には罪を認めません。 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","しかし、過越の祭りに、私があなたがたのためにひとりの者を釈放するのがならわしになっています。それで、あなたがたのために、ユダヤ人の王を釈放することにしましょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","すると彼らはみな、また大声をあげて、「この人ではない。バラバだ。」と言った。このバラバは強盗であった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","そこで、ピラトはイエスを捕えて、むち打ちにした。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","また、兵士たちは、いばらで冠を編んで、イエスの頭にかぶらせ、紫色の着物を着せた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","彼らは、イエスに近寄っては、「ユダヤ人の王さま。ばんざい。」と言い、またイエスの顔を平手で打った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ピラトは、もう一度外に出て来て、彼らに言った。「よく聞きなさい。あなたがたのところにあの人を連れ出して来ます。あの人に何の罪も見られないということを、あなたがたに知らせるためです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","それでイエスは、いばらの冠と紫色の着物を着けて、出て来られた。するとピラトは彼らに「さあ、この人です。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","祭司長たちや役人たちはイエスを見ると、激しく叫んで、「十字架につけろ。十字架につけろ。」と言った。ピラトは彼らに言った。「あなたがたがこの人を引き取り、十字架につけなさい。私はこの人には罪を認めません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ユダヤ人たちは彼に答えた。「私たちには律法があります。この人は自分を神の子としたのですから、律法によれば、死に当たります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ピラトは、このことばを聞くと、ますます恐れた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","そして、また官邸にはいって、イエスに言った。「あなたはどこの人ですか。」しかし、イエスは彼に何の答えもされなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","そこで、ピラトはイエスに言った。「あなたは私に話さないのですか。私にはあなたを釈放する権威があり、また十字架につける権威があることを、知らないのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","イエスは答えられた。「もしそれが上から与えられているのでなかったら、あなたにはわたしに対して何の権威もありません。ですから、わたしをあなたに渡した者に、もっと大きい罪があるのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","こういうわけで、ピラトはイエスを釈放しようと努力した。しかし、ユダヤ人たちは激しく叫んで言った。「もしこの人を釈放するなら、あなたはカイザルの味方ではありません。自分を王だとする者はすべて、カイザルにそむくのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","そこでピラトは、これらのことばを聞いたとき、イエスを外に引き出し、敷石（ヘブル語ではガバタ）と呼ばれる場所で、裁判の席に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","その日は過越の備え日で、時は六時ごろであった。ピラトはユダヤ人たちに言った。「さあ、あなたがたの王です。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","彼らは激しく叫んだ。「除け。除け。十字架につけろ。」ピラトは彼らに言った。「あなたがたの王を私が十字架につけるのですか。」祭司長たちは答えた。「カイザルのほかには、私たちに王はありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","そこでピラトは、そのとき、イエスを、十字架につけるため彼らに引き渡した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","彼らはイエスを受け取った。そして、イエスはご自分で十字架を負って、「どくろの地」という場所（ヘブル語でゴルゴタと言われる）に出て行かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","彼らはそこでイエスを十字架につけた。イエスといっしょに、ほかのふたりの者をそれぞれ両側に、イエスを真中にしてであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ピラトは罪状書きも書いて、十字架の上に掲げた。それには「ユダヤ人の王ナザレ人イエス。」と書いてあった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","それで、大ぜいのユダヤ人がこの罪状書きを読んだ。イエスが十字架につけられた場所は都に近かったからである。またそれはヘブル語、ラテン語、ギリシヤ語で書いてあった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","そこで、ユダヤ人の祭司長たちがピラトに、「ユダヤ人の王、と書かないで、彼はユダヤ人の王と自称した、と書いてください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ピラトは答えた。「私の書いたことは私が書いたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","さて、兵士たちは、イエスを十字架につけると、イエスの着物を取り、ひとりの兵士に一つずつあたるよう四分した。また下着をも取ったが、それは上から全部一つに織った、縫い目なしのものであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","そこで彼らは互いに言った。「それは裂かないで、だれの物になるか、くじを引こう。」それは、「彼らはわたしの着物を分け合い、わたしの下着のためにくじを引いた。」という聖書が成就するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","兵士たちはこのようなことをしたが、イエスの十字架のそばには、イエスの母と母の姉妹と、クロパの妻のマリヤとマグダラのマリヤが立っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","イエスは、母と、そばに立っている愛する弟子とを見て、母に「女の方。そこに、あなたの息子がいます。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","それからその弟子に「そこに、あなたの母がいます。」と言われた。その時から、この弟子は彼女を自分の家に引き取った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","この後、イエスは、すべてのことが完了したのを知って、聖書が成就するために、「わたしは渇く。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","そこには酸いぶどう酒のいっぱいはいった入れ物が置いてあった。そこで彼らは、酸いぶどう酒を含んだ海綿をヒソプの枝につけて、それをイエスの口もとに差し出した。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","イエスは、酸いぶどう酒を受けられると、「完了した。」と言われた。そして、頭をたれて、霊をお渡しになった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","その日は備え日であったため、ユダヤ人たちは安息日に（その安息日は大いなる日であったので）、死体を十字架の上に残しておかないように、すねを折ってそれを取りのける処置をピラトに願った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","それで、兵士たちが来て、イエスといっしょに十字架につけられた第一の者と、もうひとりの者とのすねを折った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","しかし、イエスのところに来ると、イエスがすでに死んでおられるのを認めたので、そのすねを折らなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","しかし、兵士のうちのひとりがイエスのわき腹を槍で突き刺した。すると、ただちに血と水が出て来た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","それを目撃した者があかしをしているのである。そのあかしは真実である。その人が、あなたがたにも信じさせるために、真実を話すということをよく知っているのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","この事が起こったのは、「彼の骨は一つも砕かれない。」という聖書のことばが成就するためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","また聖書の別のところには、「彼らは自分たちが突き刺した方を見る。」と言われているからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","そのあとで、イエスの弟子ではあったがユダヤ人を恐れてそのことを隠していたアリマタヤのヨセフが、イエスのからだを取りかたづけたいとピラトに願った。それで、ピラトは許可を与えた。そこで彼は来て、イエスのからだを取り降ろした。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","前に、夜イエスのところに来たニコデモも、没薬とアロエを混ぜ合わせたものをおよそ三十キログラムばかり持って、やって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","そこで、彼らはイエスのからだを取り、ユダヤ人の埋葬の習慣に従って、それを香料といっしょに亜麻布で巻いた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","イエスが十字架につけられた場所に園があって、そこには、まだだれも葬られたことのない新しい墓があった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","その日がユダヤ人の備え日であったため、墓が近かったので、彼らはイエスをそこに納めた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","さて、週の初めの日に、マグダラのマリヤは、朝早くまだ暗いうちに墓に来た。そして、墓から石が取りのけてあるのを見た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","それで、走って、シモン・ペテロと、イエスが愛された、もうひとりの弟子とのところに来て、言った。「だれかが墓から主を取って行きました。主をどこに置いたのか、私たちにはわかりません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","そこでペテロともうひとりの弟子は外に出て来て、墓のほうへ行った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ふたりはいっしょに走ったが、もうひとりの弟子がペテロよりも速かったので、先に墓に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","そして、からだをかがめてのぞき込み、亜麻布が置いてあるのを見たが、中にはいらなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","シモン・ペテロも彼に続いて来て、墓にはいり、亜麻布が置いてあって、 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","イエスの頭に巻かれていた布切れは、亜麻布といっしょにはなく、離れた所に巻かれたままになっているのを見た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","そのとき、先に墓に着いたもうひとりの弟子もはいって来た。そして、見て、信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","彼らは、イエスが死人の中からよみがえらなければならないという聖書を、まだ理解していなかったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","それで、弟子たちはまた自分のところに帰って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","しかし、マリヤは外で墓のところにたたずんで泣いていた。そして、泣きながら、からだをかがめて墓の中をのぞき込んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","すると、ふたりの御使いが、イエスのからだが置かれていた場所に、ひとりは頭のところに、ひとりは足のところに、白い衣をまとってすわっているのが見えた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","彼らは彼女に言った。「なぜ泣いているのですか。」彼女は言った。「だれかが私の主を取って行きました。どこに置いたのか、私にはわからないのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","彼女はこう言ってから、うしろを振り向いた。すると、イエスが立っておられるのを見た。しかし、彼女にはイエスであることがわからなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","イエスは彼女に言われた。「なぜ泣いているのですか。だれを捜しているのですか。」彼女は、それを園の管理人だと思って言った。「あなたが、あの方を運んだのでしたら、どこに置いたのか言ってください。そうすれば私が引き取ります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","イエスは彼女に言われた。「マリヤ。」彼女は振り向いて、ヘブル語で、「ラボニ（すなわち、先生）。」とイエスに言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","イエスは彼女に言われた。「わたしにすがりついていてはいけません。わたしはまだ父のもとに上っていないからです。わたしの兄弟たちのところに行って、彼らに『わたしは、わたしの父またあなたがたの父、わたしの神またあなたがたの神のもとに上る。』と告げなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","マグダラのマリヤは、行って、「私は主にお目にかかりました。」と言い、また、主が彼女にこれらのことを話されたと弟子たちに告げた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","その日、すなわち週の初めの日の夕方のことであった。弟子たちがいた所では、ユダヤ人を恐れて戸がしめてあったが、イエスが来られ、彼らの中に立って言われた。「平安があなたがたにあるように。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","こう言ってイエスは、その手とわき腹を彼らに示された。弟子たちは、主を見て喜んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","イエスはもう一度、彼らに言われた。「平安があなたがたにあるように。父がわたしを遣わしたように、わたしもあなたがたを遣わします。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","そして、こう言われると、彼らに息を吹きかけて言われた。「聖霊を受けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","あなたがたがだれかの罪を赦すなら、その人の罪は赦され、あなたがたがだれかの罪をそのまま残すなら、それはそのまま残ります。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","十二弟子のひとりで、デドモと呼ばれるトマスは、イエスが来られたときに、彼らといっしょにいなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","それで、ほかの弟子たちが彼に「私たちは主を見た。」と言った。しかし、トマスは彼らに「私は、その手に釘の跡を見、私の指を釘のところに差し入れ、また私の手をそのわきに差し入れてみなければ、決して信じません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","八日後に、弟子たちはまた室内におり、トマスも彼らといっしょにいた。戸が閉じられていたが、イエスが来て、彼らの中に立って「平安があなたがたにあるように。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","それからトマスに言われた。「あなたの指をここにつけて、わたしの手を見なさい。手を伸ばして、わたしのわきに差し入れなさい。信じない者にならないで、信じる者になりなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","トマスは答えてイエスに言った。「私の主。私の神。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","イエスは彼に言われた。「あなたはわたしを見たから信じたのですか。見ずに信じる者は幸いです。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","この書には書かれていないが、まだほかの多くのしるしをも、イエスは弟子たちの前で行なわれた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","しかし、これらのことが書かれたのは、イエスが神の子キリストであることを、あなたがたが信じるため、また、あなたがたが信じて、イエスの御名によっていのちを得るためである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","この後、イエスはテベリヤの湖畔で、もう一度ご自分を弟子たちに現わされた。その現わされた次第はこうであった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","シモン・ペテロ、デドモと呼ばれるトマス、ガリラヤのカナのナタナエル、ゼベダイの子たち、ほかにふたりの弟子がいっしょにいた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","シモン・ペテロが彼らに言った。「私は漁に行く。」彼らは言った。「私たちもいっしょに行きましょう。」彼らは出かけて、小舟に乗り込んだ。しかし、その夜は何もとれなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","夜が明けそめたとき、イエスは岸べに立たれた。けれども弟子たちには、それがイエスであることがわからなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","イエスは彼らに言われた。「子どもたちよ。食べる物がありませんね。」彼らは答えた。「はい。ありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","イエスは彼らに言われた。「舟の右側に網をおろしなさい。そうすれば、とれます。」そこで、彼らは網をおろした。すると、おびただしい魚のために、網を引き上げることができなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","そこで、イエスの愛されたあの弟子がペテロに言った。「主です。」すると、シモン・ペテロは、主であると聞いて、裸だったので、上着をまとって、湖に飛び込んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","しかし、ほかの弟子たちは、魚の満ちたその網を引いて、小舟でやって来た。陸地から遠くなく、百メートル足らずの距離だったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","こうして彼らが陸地に上がったとき、そこに炭火とその上に載せた魚と、パンがあるのを見た。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","イエスは彼らに言われた。「あなたがたの今とった魚を幾匹か持って来なさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","シモン・ペテロは舟に上がって、網を陸地に引き上げた。それは百五十三匹の大きな魚でいっぱいであった。それほど多かったけれども、網は破れなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","イエスは彼らに言われた。「さあ来て、朝の食事をしなさい。」弟子たちは主であることを知っていたので、だれも「あなたはどなたですか。」とあえて尋ねる者はいなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","イエスは来て、パンを取り、彼らにお与えになった。また、魚も同じようにされた。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","イエスが、死人の中からよみがえってから、弟子たちにご自分を現わされたのは、すでにこれで三度目である。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","彼らが食事を済ませたとき、イエスはシモン・ペテロに言われた。「ヨハネの子シモン。あなたは、この人たち以上に、わたしを愛しますか。」ペテロはイエスに言った。「はい。主よ。私があなたを愛することは、あなたがご存じです。」イエスは彼に言われた。「わたしの小羊を飼いなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","イエスは再び彼に言われた。「ヨハネの子シモン。あなたはわたしを愛しますか。」ペテロはイエスに言った。「はい。主よ。私があなたを愛することは、あなたがご存じです。」イエスは彼に言われた。「わたしの羊を牧しなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","イエスは三度ペテロに言われた。「ヨハネの子シモン。あなたはわたしを愛しますか。」ペテロは、イエスが三度「あなたはわたしを愛しますか。」と言われたので、心を痛めてイエスに言った。「主よ。あなたはいっさいのことをご存じです。あなたは、私があなたを愛することを知っておいでになります。」イエスは彼に言われた。「わたしの羊を飼いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","まことに、まことに、あなたに告げます。あなたは若かった時には、自分で帯を締めて、自分の歩きたい所を歩きました。しかし年をとると、あなたは自分の手を伸ばし、ほかの人があなたに帯をさせて、あなたの行きたくない所に連れて行きます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","これは、ペテロがどのような死に方をして、神の栄光を現わすかを示して、言われたことであった。こうお話しになってから、ペテロに言われた。「わたしに従いなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ペテロは振り向いて、イエスが愛された弟子があとについて来るのを見た。この弟子はあの晩餐のとき、イエスの右側にいて、「主よ。あなたを裏切る者はだれですか。」と言った者である。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ペテロは彼を見て、イエスに言った。「主よ。この人はどうですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","イエスはペテロに言われた。「わたしの来るまで彼が生きながらえるのをわたしが望むとしても、それがあなたに何のかかわりがありますか。あなたは、わたしに従いなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","そこで、その弟子は死なないという話が兄弟たちの間に行き渡った。しかし、イエスはペテロに、その弟子が死なないと言われたのでなく、「わたしの来るまで彼が生きながらえるのをわたしが望むとしても、それがあなたに何のかかわりがありますか。」と言われたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","これらのことについてあかしした者、またこれらのことを書いた者は、その弟子である。そして、私たちは、彼のあかしが真実であることを、知っている。 ");
INSERT INTO jpn1965_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","イエスが行なわれたことは、ほかにもたくさんあるが、もしそれらをいちいち書きしるすなら、世界も、書かれた書物を入れることができまい、と私は思う。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","テオピロよ。私は前の書で、イエスが行ない始め、教え始められたすべてのことについて書き、 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","お選びになった使徒たちに聖霊によって命じてから、天に上げられた日のことにまで及びました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","イエスは苦しみを受けた後、四十日の間、彼らに現われて、神の国のことを語り、数多くの確かな証拠をもって、ご自分が生きていることを使徒たちに示された。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","彼らといっしょにいるとき、イエスは彼らにこう命じられた。「エルサレムを離れないで、わたしから聞いた父の約束を待ちなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ヨハネは水でバプテスマを授けたが、もう間もなく、あなたがたは聖霊のバプテスマを受けるからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","そこで、彼らは、いっしょに集まったとき、イエスにこう尋ねた。「主よ。今こそ、イスラエルのために国を再興してくださるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","イエスは言われた。「いつとか、どんなときとかいうことは、あなたがたは知らなくてもよいのです。それは、父がご自分の権威をもってお定めになっています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","しかし、聖霊があなたがたの上に臨まれるとき、あなたがたは力を受けます。そして、エルサレム、ユダヤとサマリヤの全土、および地の果てにまで、わたしの証人となります。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","こう言ってから、イエスは彼らが見ている間に上げられ、雲に包まれて、見えなくなられた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","イエスが上って行かれるとき、弟子たちは天を見つめていた。すると、見よ、白い衣を着た人がふたり、彼らのそばに立っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","そして、こう言った。「ガリラヤの人たち。なぜ天を見上げて立っているのですか。あなたがたを離れて天に上げられたこのイエスは、天に上って行かれるのをあなたがたが見たときと同じ有様で、またおいでになります。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","そこで、彼らはオリーブという山からエルサレムに帰った。この山はエルサレムの近くにあって、安息日の道のりほどの距離であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","彼らは町にはいると、泊まっている屋上の間に上がった。この人々は、ペテロとヨハネとヤコブとアンデレ、ピリポとトマス、バルトロマイとマタイ、アルパヨの子ヤコブと熱心党員シモンとヤコブの子ユダであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","この人たちは、婦人たちやイエスの母マリヤ、およびイエスの兄弟たちとともに、みな心を合わせ、祈りに専念していた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","そのころ、百二十名ほどの兄弟たちが集まっていたが、ペテロはその中に立ってこう言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","「兄弟たち。イエスを捕えた者どもの手引きをしたユダについて、聖霊がダビデの口を通して預言された聖書のことばは、成就しなければならなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ユダは私たちの仲間として数えられており、この務めを受けていました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","（ところがこの男は、不正なことをして得た報酬で地所を手に入れたが、まっさかさまに落ち、からだは真二つに裂け、はらわたが全部飛び出してしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","このことが、エルサレムの住民全部に知れて、その地所は彼らの国語でアケルダマ、すなわち『血の地所』と呼ばれるようになった。） ");
INSERT INTO jpn1965_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","実は詩篇には、こう書いてあるのです。『彼の住まいは荒れ果てよ、そこには住む者がいなくなれ。』また、『その職は、ほかの人に取らせよ。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ですから、主イエスが私たちといっしょに生活された間、 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","すなわち、ヨハネのバプテスマから始まって、私たちを離れて天に上げられた日までの間、いつも私たちと行動をともにした者の中から、だれかひとりが、私たちとともにイエスの復活の証人とならなければなりません。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","そこで、彼らは、バルサバと呼ばれ別名をユストというヨセフと、マッテヤとのふたりを立てた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","そして、こう祈った。「すべての人の心を知っておられる主よ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","この務めと使徒職の地位を継がせるために、このふたりのうちのどちらをお選びになるか、お示しください。ユダは自分のところへ行くために脱落して行きましたから。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","そしてふたりのためにくじを引くと、くじはマッテヤに当たったので、彼は十一人の使徒たちに加えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","五旬節の日になって、みなが一つ所に集まっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","すると突然、天から、激しい風が吹いて来るような響きが起こり、彼らのいた家全体に響き渡った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","また、炎のような分かれた舌が現われて、ひとりひとりの上にとどまった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","すると、みなが聖霊に満たされ、御霊が話させてくださるとおりに、他国のことばで話しだした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","さて、エルサレムには、敬虔なユダヤ人たちが、天下のあらゆる国から来て住んでいたが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","この物音が起こると、大ぜいの人々が集まって来た。彼らは、それぞれ自分の国のことばで弟子たちが話すのを聞いて、驚きあきれてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","彼らは驚き怪しんで言った。「どうでしょう。いま話しているこの人たちは、みなガリラヤの人ではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","それなのに、私たちめいめいの国の国語で話すのを聞くとは、いったいどうしたことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","私たちは、パルテヤ人、メジヤ人、エラム人、またメソポタミヤ、ユダヤ、カパドキヤ、ポントとアジヤ、 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","フルギヤとパンフリヤ、エジプトとクレネに近いリビヤ地方などに住む者たち、また滞在中のローマ人たちで、 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ユダヤ人もいれば改宗者もいる。またクレテ人とアラビヤ人なのに、あの人たちが、私たちのいろいろな国ことばで神の大きなみわざを語るのを聞こうとは。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","人々はみな、驚き惑って、互いに「いったいこれはどうしたことか。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","しかし、ほかに「彼らは甘いぶどう酒に酔っているのだ。」と言ってあざける者たちもいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","そこで、ペテロは十一人とともに立って、声を張り上げ、人々にはっきりとこう言った。「ユダヤの人々、ならびにエルサレムに住むすべての人々。あなたがたに知っていただきたいことがあります。どうか、私のことばに耳を貸してください。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","今は朝の九時ですから、あなたがたの思っているようにこの人たちは酔っているのではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","これは、預言者ヨエルによって語られた事です。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","『神は言われる。 終わりの日に、わたしの霊をすべての人に注ぐ。 すると、あなたがたの息子や娘は預言し、 青年は幻を見、 老人は夢を見る。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","その日、わたしのしもべにも、はしためにも、 わたしの霊を注ぐ。 すると、彼らは預言する。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","また、わたしは、上は天に不思議なわざを示し、 下は地にしるしを示す。 それは、血と火と立ち上る煙である。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","主の大いなる輝かしい日が来る前に、 太陽はやみとなり、月は血に変わる。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","しかし、主の名を呼ぶ者は、みな救われる。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","イスラエルの人たち。このことばを聞いてください。神はナザレ人イエスによって、あなたがたの間で力あるわざと、不思議なわざと、あかしの奇蹟を行なわれました。それらのことによって、神はあなたがたに、この方のあかしをされたのです。これは、あなたがた自身がご承知のように、 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","神の定めた計画と神の予知とによって引き渡されたこの方を、あなたがたは不法な者の手によって十字架につけて殺しました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","しかし神は、この方を死の苦しみから解き放って、よみがえらせました。この方が死につながれていることなど、ありえないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ダビデはこの方について、こう言っています。 『私はいつも、自分の目の前に主を見ていた。 主は、私が動かされないように、 私の右におられるからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","それゆえ、私の心は楽しみ、 私の舌は大いに喜んだ。 さらに私の肉体も望みの中に安らう。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","あなたは私のたましいをハデスに捨てて置かず、 あなたの聖者が朽ち果てるのを お許しにならないからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","あなたは、私にいのちの道を知らせ、 御顔を示して、私を喜びで満たしてくださる。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","兄弟たち。先祖ダビデについては、私はあなたがたに、確信をもって言うことができます。彼は死んで葬られ、その墓は今日まで私たちのところにあります。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","彼は預言者でしたから、神が彼の子孫のひとりを彼の王位に着かせると誓って言われたことを知っていたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","それで後のことを予見して、キリストの復活について、『彼はハデスに捨てて置かれず、その肉体は朽ち果てない。』と語ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","神はこのイエスをよみがえらせました。私たちはみな、そのことの証人です。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ですから、神の右に上げられたイエスが、御父から約束された聖霊を受けて、今あなたがたが見聞きしているこの聖霊をお注ぎになったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ダビデは天に上ったわけではありません。彼は自分でこう言っています。 『主は私の主に言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","わたしがあなたの敵をあなたの足台とするまでは わたしの右の座に着いていなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ですから、イスラエルのすべての人々は、このことをはっきりと知らなければなりません。すなわち、神が、今や主ともキリストともされたこのイエスを、あなたがたは十字架につけたのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","人々はこれを聞いて心を刺され、ペテロとほかの使徒たちに、「兄弟たち。私たちはどうしたらよいでしょうか。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","そこでペテロは彼らに答えた。「悔い改めなさい。そして、それぞれ罪を赦していただくために、イエス・キリストの名によってバプテスマを受けなさい。そうすれば、賜物として聖霊を受けるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","なぜなら、この約束は、あなたがたと、その子どもたち、ならびにすべての遠くにいる人々、すなわち、私たちの神である主がお召しになる人々に与えられているからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ペテロは、このほかにも多くのことばをもって、あかしをし、「この曲がった時代から救われなさい。」と言って彼らに勧めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","そこで、彼のことばを受け入れた者は、バプテスマを受けた。その日、三千人ほどが弟子に加えられた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","そして、彼らは使徒たちの教えを堅く守り、交わりをし、パンを裂き、祈りをしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","そして、一同の心に恐れが生じ、使徒たちによって、多くの不思議なわざとあかしの奇蹟が行なわれた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","信者となった者たちはみないっしょにいて、いっさいの物を共有にしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","そして、資産や持ち物を売っては、それぞれの必要に応じて、みなに分配していた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","そして毎日、心を一つにして宮に集まり、家でパンを裂き、喜びと真心をもって食事をともにし、 ");
INSERT INTO jpn1965_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","神を賛美し、すべての民に好意を持たれた。主も毎日救われる人々を仲間に加えてくださった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ペテロとヨハネは午後三時の祈りの時間に宮に上って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","すると、生まれつき足のきかない男が運ばれて来た。この男は、宮にはいる人たちから施しを求めるために、毎日「美しの門」という名の宮の門に置いてもらっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","彼は、ペテロとヨハネが宮にはいろうとするのを見て、施しを求めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ペテロは、ヨハネとともに、その男を見つめて、「私たちを見なさい。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","男は何かもらえると思って、ふたりに目を注いだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","すると、ペテロは、「金銀は私にはない。しかし、私にあるものを上げよう。ナザレのイエス・キリストの名によって、歩きなさい。」と言って、 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","彼の右手を取って立たせた。するとたちまち、彼の足とくるぶしが強くなり、 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","おどり上がってまっすぐに立ち、歩きだした。そして歩いたり、はねたりしながら、神を賛美しつつ、ふたりといっしょに宮にはいって行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","人々はみな、彼が歩きながら、神を賛美しているのを見た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","そして、これが、施しを求めるために宮の「美しの門」にすわっていた男だとわかると、この人の身に起こったことに驚き、あきれた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","この人が、ペテロとヨハネにつきまとっている間に、非常に驚いた人々がみないっせいに、ソロモンの廊という回廊にいる彼らのところに、やって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ペテロはこれを見て、人々に向かってこう言った。「イスラエル人たち。なぜこのことに驚いているのですか。なぜ、私たちが自分の力とか信仰深さとかによって彼を歩かせたかのように、私たちを見つめるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","アブラハム、イサク、ヤコブの神、すなわち、私たちの先祖の神は、そのしもべイエスに栄光をお与えになりました。あなたがたは、この方を引き渡し、ピラトが釈放すると決めたのに、その面前でこの方を拒みました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","そのうえ、このきよい、正しい方を拒んで、人殺しの男を赦免するように要求し、 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","いのちの君を殺しました。しかし、神はこのイエスを死者の中からよみがえらせました。私たちはそのことの証人です。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","そして、このイエスの御名が、その御名を信じる信仰のゆえに、あなたがたがいま見ており知っているこの人を強くしたのです。イエスによって与えられる信仰が、この人を皆さんの目の前で完全なからだにしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ですから、兄弟たち。私は知っています。あなたがたは、自分たちの指導者たちと同様に、無知のためにあのような行ないをしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","しかし、神は、すべての預言者たちの口を通して、キリストの受難をあらかじめ語っておられたことを、このように実現されました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","そういうわけですから、あなたがたの罪をぬぐい去っていただくために、悔い改めて、神に立ち返りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","それは、主の御前から回復の時が来て、あなたがたのためにメシヤと定められたイエスを、主が遣わしてくださるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","このイエスは、神が昔から、聖なる預言者たちの口を通してたびたび語られた、あの万物の改まる時まで、天にとどまっていなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","モーセはこう言いました。『神である主は、あなたがたのために、私のようなひとりの預言者を、あなたがたの兄弟たちの中からお立てになる。この方があなたがたに語ることはみな聞きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","その預言者に聞き従わない者はだれでも、民の中から滅ぼし絶やされる。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","また、サムエルをはじめとして、彼に続いて語ったすべての預言者たちも、今の時について宣べました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","あなたがたは預言者たちの子孫です。また、神がアブラハムに、『あなたの子孫によって、地の諸民族はみな祝福を受ける。』と言って、あなたがたの先祖と結ばれたあの契約の子孫です。 ");
INSERT INTO jpn1965_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","神は、まずそのしもべを立てて、あなたがたにお遣わしになりました。それは、この方があなたがたを祝福して、ひとりひとりをその邪悪な生活から立ち返らせてくださるためなのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","彼らが民に話していると、祭司たち、宮の守衛長、またサドカイ人たちがやって来たが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","この人たちは、ペテロとヨハネが民を教え、イエスのことを例にあげて死者の復活を宣べ伝えているのに、困り果て、 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","彼らに手をかけて捕えた。そして翌日まで留置することにした。すでに夕方だったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","しかし、みことばを聞いた人々が大ぜい信じ、男の数が五千人ほどになった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","翌日、民の指導者、長老、学者たちは、エルサレムに集まった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","大祭司アンナス、カヤパ、ヨハネ、アレキサンデル、そのほか大祭司の一族もみな出席した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","彼らは使徒たちを真中に立たせて、「あなたがたは何の権威によって、また、だれの名によってこんなことをしたのか。」と尋問しだした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","そのとき、ペテロは聖霊に満たされて、彼らに言った。「民の指導者たち、ならびに長老の方々。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","私たちがきょう取り調べられているのが、病人に行なった良いわざについてであり、その人が何によっていやされたか、ということのためであるなら、 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","皆さんも、またイスラエルのすべての人々も、よく知ってください。この人が直って、あなたがたの前に立っているのは、あなたがたが十字架につけ、神が死者の中からよみがえらせたナザレ人イエス・キリストの御名によるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","『あなたがた家を建てる者たちに捨てられた石が、礎の石となった。』というのはこの方のことです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","この方以外には、だれによっても救いはありません。世界中でこの御名のほかには、私たちが救われるべき名としては、どのような名も、人間に与えられていないからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","彼らはペテロとヨハネとの大胆さを見、またふたりが無学な、普通の人であるのを知って驚いたが、ふたりがイエスとともにいたのだ、ということがわかって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","そればかりでなく、いやされた人がふたりといっしょに立っているのを見ては、返すことばもなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","彼らはふたりに議会から退場するように命じ、そして互いに協議した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","彼らは言った。「あの人たちをどうしよう。あの人たちによって著しいしるしが行なわれたことは、エルサレムの住民全部に知れ渡っているから、われわれはそれを否定できない。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","しかし、これ以上民の間に広がらないために、今後だれにもこの名によって語ってはならないと、彼らをきびしく戒めよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","そこで彼らを呼んで、いっさいイエスの名によって語ったり教えたりしてはならない、と命じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ペテロとヨハネは彼らに答えて言った。「神に聞き従うより、あなたがたに聞き従うほうが、神の前に正しいかどうか、判断してください。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","私たちは、自分の見たこと、また聞いたことを、話さないわけにはいきません。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","そこで、彼らはふたりをさらにおどしたうえで、釈放した。それはみなの者が、この出来事のゆえに神をあがめていたので、人々の手前、ふたりを罰するすべがなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","この奇蹟によっていやされた男は四十歳余りであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","釈放されたふたりは、仲間のところへ行き、祭司長たちや長老たちが彼らに言ったことを残らず報告した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","これを聞いた人々はみな、心を一つにして、神に向かい、声を上げて言った。「主よ。あなたは天と地と海とその中のすべてのものを造られた方です。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","あなたは、聖霊によって、あなたのしもべであり私たちの先祖であるダビデの口を通して、こう言われました。 『なぜ異邦人たちは騒ぎ立ち、 もろもろの民はむなしいことを計るのか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","地の王たちは立ち上がり、 指導者たちは、主とキリストに反抗して、 一つに組んだ。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","事実、ヘロデとポンテオ・ピラトは、異邦人やイスラエルの民といっしょに、あなたが油を注がれた、あなたの聖なるしもべイエスに逆らってこの都に集まり、 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","あなたの御手とみこころによって、あらかじめお定めになったことを行ないました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","主よ。いま彼らの脅かしをご覧になり、あなたのしもべたちにみことばを大胆に語らせてください。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","御手を伸ばしていやしを行なわせ、あなたの聖なるしもべイエスの御名によって、しるしと不思議なわざを行なわせてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","彼らがこう祈ると、その集まっていた場所が震い動き、一同は聖霊に満たされ、神のことばを大胆に語りだした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","信じた者の群れは、心と思いを一つにして、だれひとりその持ち物を自分のものと言わず、すべてを共有にしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","使徒たちは、主イエスの復活を非常に力強くあかしし、大きな恵みがそのすべての者の上にあった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","彼らの中には、ひとりも乏しい者がなかった。地所や家を持っている者は、それを売り、代金を携えて来て、 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","使徒たちの足もとに置き、その金は必要に従っておのおのに分け与えられたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","キプロス生まれのレビ人で、使徒たちによってバルナバ（訳すと、慰めの子）と呼ばれていたヨセフも、 ");
INSERT INTO jpn1965_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","畑を持っていたので、それを売り、その代金を持って来て、使徒たちの足もとに置いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ところが、アナニヤという人は、妻のサッピラとともにその持ち物を売り、 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","妻も承知のうえで、その代金の一部を残しておき、ある部分を持って来て、使徒たちの足もとに置いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","そこで、ペテロがこう言った。「アナニヤ。どうしてあなたはサタンに心を奪われ、聖霊を欺いて、地所の代金の一部を自分のために残しておいたのか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","それはもともとあなたのものであり、売ってからもあなたの自由になったのではないか。なぜこのようなことをたくらんだのか。あなたは人を欺いたのではなく、神を欺いたのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","アナニヤはこのことばを聞くと、倒れて息が絶えた。そして、これを聞いたすべての人に、非常な恐れが生じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","青年たちは立って、彼を包み、運び出して葬った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","三時間ほどたって、彼の妻はこの出来事を知らずにはいって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ペテロは彼女にこう言った。「あなたがたは地所をこの値段で売ったのですか。私に言いなさい。」彼女は「はい。その値段です。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","そこで、ペテロは彼女に言った。「どうしてあなたがたは心を合わせて、主の御霊を試みたのですか。見なさい、あなたの夫を葬った者たちが、戸口に来ていて、あなたをも運び出します。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","すると彼女は、たちまちペテロの足もとに倒れ、息が絶えた。はいって来た青年たちは、彼女が死んだのを見て、運び出し、夫のそばに葬った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","そして、教会全体と、このことを聞いたすべての人たちとに、非常な恐れが生じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","また、使徒たちの手によって、多くのしるしと不思議なわざが人々の間で行なわれた。みなは一つ心になってソロモンの廊にいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ほかの人々は、ひとりもこの交わりに加わろうとしなかったが、その人々は彼らを尊敬していた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","そればかりか、主を信じる者は男も女もますますふえていった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ついに、人々は病人を大通りへ運び出し、寝台や寝床の上に寝かせ、ペテロが通りかかるときには、せめてその影でも、だれかにかかるようにするほどになった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","また、エルサレムの付近の町々から、大ぜいの人が、病人や、汚れた霊に苦しめられている人などを連れて集まって来たが、その全部がいやされた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","そこで、大祭司とその仲間たち全部、すなわちサドカイ派の者はみな、ねたみに燃えて立ち上がり、 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","使徒たちを捕え、留置場に入れた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ところが、夜、主の使いが牢の戸を開き、彼らを連れ出し、 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","「行って宮の中に立ち、人々にこのいのちのことばを、ことごとく語りなさい。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","彼らはこれを聞くと、夜明けごろ宮にはいって教え始めた。一方、大祭司とその仲間たちは集まって来て、議会とイスラエル人のすべての長老を召集し、使徒たちを引き出して来させるために、人を獄舎にやった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ところが役人たちが行ってみると、牢の中には彼らがいなかったので、引き返してこう報告した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","「獄舎は完全にしまっており、番人たちが戸口に立っていましたが、あけてみると、中にはだれもおりませんでした。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","宮の守衛長や祭司長たちは、このことばを聞いて、いったいこれはどうなって行くのかと、使徒たちのことで当惑した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","そこへ、ある人がやって来て、「大変です。あなたがたが牢に入れた人たちが、宮の中に立って、人々を教えています。」と告げた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","そこで、宮の守衛長は役人たちといっしょに出て行き、使徒たちを連れて来た。しかし、手荒なことはしなかった。人々に石で打ち殺されるのを恐れたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","彼らが使徒たちを連れて来て議会の中に立たせると、大祭司は使徒たちを問いただして、 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","言った。「あの名によって教えてはならないときびしく命じておいたのに、何ということだ。エルサレム中にあなたがたの教えを広めてしまい、そのうえ、あの人の血の責任をわれわれに負わせようとしているではないか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ペテロをはじめ使徒たちは答えて言った。「人に従うより、神に従うべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","私たちの先祖の神は、あなたがたが十字架にかけて殺したイエスを、よみがえらせたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","そして神は、イスラエルに悔い改めと罪の赦しを与えるために、このイエスを君とし、救い主として、ご自分の右に上げられました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","私たちはそのことの証人です。神がご自分に従う者たちにお与えになった聖霊もそのことの証人です。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","彼らはこれを聞いて怒り狂い、使徒たちを殺そうと計った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ところが、すべての人に尊敬されている律法学者で、ガマリエルというパリサイ人が議会の中に立ち、使徒たちをしばらく外に出させるように命じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","それから、議員たちに向かってこう言った。「イスラエルの皆さん。この人々をどう扱うか、よく気をつけてください。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","というのは、先ごろチゥダが立ち上がって、自分を何か偉い者のように言い、彼に従った男の数が四百人ほどありましたが、結局、彼は殺され、従った者はみな散らされて、あとかたもなくなりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","その後、人口調査のとき、ガリラヤ人ユダが立ち上がり、民衆をそそのかして反乱を起こしましたが、自分は滅び、従った者たちもみな散らされてしまいました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","そこで今、あなたがたに申したいのです。あの人たちから手を引き、放っておきなさい。もし、その計画や行動が人から出たものならば、自滅してしまうでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","しかし、もし神から出たものならば、あなたがたには彼らを滅ぼすことはできないでしょう。もしかすれば、あなたがたは神に敵対する者になってしまいます。」彼らは彼に説得され、 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","使徒たちを呼んで、彼らをむちで打ち、イエスの名によって語ってはならないと言い渡したうえで釈放した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","そこで、使徒たちは、御名のためにはずかしめられるに値する者とされたことを喜びながら、議会から出て行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","そして、毎日、宮や家々で教え、イエスがキリストであることを宣べ伝え続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","そのころ、弟子たちがふえるにつれて、ギリシヤ語を使うユダヤ人たちが、ヘブル語を使うユダヤ人たちに対して苦情を申し立てた。彼らのうちのやもめたちが、毎日の配給でなおざりにされていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","そこで、十二使徒は弟子たち全員を呼び集めてこう言った。「私たちが神のことばをあと回しにして、食卓のことに仕えるのはよくありません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","そこで、兄弟たち。あなたがたの中から、御霊と知恵とに満ちた、評判の良い人たち七人を選びなさい。私たちはその人たちをこの仕事に当たらせることにします。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","そして、私たちは、もっぱら祈りとみことばの奉仕に励むことにします。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","この提案は全員の承認するところとなり、彼らは、信仰と聖霊とに満ちた人ステパノ、およびピリポ、プロコロ、ニカノル、テモン、パルメナ、アンテオケの改宗者ニコラオを選び、 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","この人たちを使徒たちの前に立たせた。そこで使徒たちは祈って、手を彼らの上に置いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","こうして神のことばは、ますます広まって行き、エルサレムで、弟子の数が非常にふえて行った。そして、多くの祭司たちが次々に信仰にはいった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","さて、ステパノは恵みと力とに満ち、人々の間で、すばらしい不思議なわざとしるしを行なっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ところが、いわゆるリベルテンの会堂に属する人々で、クレネ人、アレキサンドリヤ人、キリキヤやアジヤから来た人々などが立ち上がって、ステパノと議論した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","しかし、彼が知恵と御霊によって語っていたので、それに対抗することができなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","そこで、彼らはある人々をそそのかし、「私たちは彼がモーセと神とをけがすことばを語るのを聞いた。」と言わせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","また、民衆と長老たちと律法学者たちを扇動し、彼を襲って捕え、議会にひっぱって行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","そして、偽りの証人たちを立てて、こう言わせた。「この人は、この聖なる所と律法とに逆らうことばを語るのをやめません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","『あのナザレ人イエスはこの聖なる所をこわし、モーセが私たちに伝えた慣例を変えてしまう。』と彼が言うのを、私たちは聞きました。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","議会で席に着いていた人々はみな、ステパノに目を注いだ。すると彼の顔は御使いの顔のように見えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","大祭司は、「そのとおりか。」と尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","そこでステパノは言った。「兄弟たち、父たちよ。聞いてください。私たちの父祖アブラハムが、カランに住む以前まだメソポタミヤにいたとき、栄光の神が彼に現われて、 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","『あなたの土地とあなたの親族を離れ、わたしがあなたに示す地に行け。』と言われました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","そこで、アブラハムはカルデヤ人の地を出て、カランに住みました。そして、父の死後、神は彼をそこから今あなたがたの住んでいるこの地にお移しになりましたが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ここでは、足の踏み場となるだけのものさえも、相続財産として彼にお与えになりませんでした。それでも、子どももなかった彼に対して、この地を彼とその子孫に財産として与えることを約束されたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","また神は次のようなことを話されました。『彼の子孫は外国に移り住み、四百年間、奴隷にされ、虐待される。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","そして、こう言われました。『彼らを奴隷にする国民は、わたしがさばく。その後、彼らはのがれ出て、この所で、わたしを礼拝する。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","また神は、アブラハムに割礼の契約をお与えになりました。こうして、彼にイサクが生まれました。彼は八日目にイサクに割礼を施しました。それから、イサクにヤコブが生まれ、ヤコブに十二人の族長が生まれました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","族長たちはヨセフをねたんで、彼をエジプトに売りとばしました。しかし、神は彼とともにおられ、 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","あらゆる患難から彼を救い出し、エジプト王パロの前で、恵みと知恵をお与えになったので、パロは彼をエジプトと王の家全体を治める大臣に任じました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ところが、エジプトとカナンとの全地にききんが起こり、大きな災難が襲って来たので、私たちの先祖たちには、食物がなくなりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","しかし、ヤコブはエジプトに穀物があると聞いて、初めに私たちの先祖たちを遣わしました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","二回目のとき、ヨセフは兄弟たちに、自分のことを打ち明け、ヨセフの家族のことがパロに明らかになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","そこで、ヨセフは人をやって、父ヤコブと七十五人の全親族を呼び寄せました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ヤコブはエジプトに下り、そこで彼も私たちの先祖たちも死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","そしてシケムに運ばれ、かねてアブラハムがいくらかの金でシケムのハモルの子から買っておいた墓に葬られました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","神がアブラハムにお立てになった約束の時が近づくにしたがって、民はエジプトの中にふえ広がり、 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ヨセフのことを知らない別の王がエジプトの王位につくときまで続きました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","この王は、私たちの同胞に対して策略を巡らし、私たちの先祖を苦しめて、幼子を捨てさせ、生かしておけないようにしました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","このようなときに、モーセが生まれたのです。彼は神の目にかなった、かわいらしい子で、三か月の間、父の家で育てられましたが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ついに捨てられたのをパロの娘が拾い上げ、自分の子として育てたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","モーセはエジプト人のあらゆる学問を教え込まれ、ことばにもわざにも力がありました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","四十歳になったころ、モーセはその兄弟であるイスラエル人を、顧みる心を起こしました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","そして、同胞のひとりが虐待されているのを見て、その人をかばい、エジプト人を打ち倒して、乱暴されているその人の仕返しをしました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","彼は、自分の手によって神が兄弟たちに救いを与えようとしておられることを、みなが理解してくれるものと思っていましたが、彼らは理解しませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","翌日彼は、兄弟たちが争っているところに現われ、和解させようとして、『あなたがたは、兄弟なのだ。それなのにどうしてお互いに傷つけ合っているのか。』と言いました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","すると、隣人を傷つけていた者が、モーセを押しのけてこう言いました。『だれがあなたを、私たちの支配者や裁判官にしたのか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","きのうエジプト人を殺したように、私も殺す気か。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","このことばを聞いたモーセは、逃げてミデアンの地に身を寄せ、そこで男の子ふたりをもうけました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","四十年たったとき、御使いが、モーセに、シナイ山の荒野で柴の燃える炎の中に現われました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","その光景を見たモーセは驚いて、それをよく見ようとして近寄ったとき、主の御声が聞こえました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","『わたしはあなたの先祖の神、アブラハム、イサク、ヤコブの神である。』そこで、モーセは震え上がり、見定める勇気もなくなりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","すると、主は彼にこう言われたのです。『あなたの足のくつを脱ぎなさい。あなたの立っている所は聖なる地である。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","わたしは、確かにエジプトにいるわたしの民の苦難を見、そのうめき声を聞いたので、彼らを救い出すために下って来た。さあ、行きなさい。わたしはあなたをエジプトに遣わそう。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","『だれがあなたを支配者や裁判官にしたのか。』と言って人々が拒んだこのモーセを、神は柴の中で彼に現われた御使いの手によって、支配者また解放者としてお遣わしになったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","この人が、彼らを導き出し、エジプトの地で、紅海で、また四十年間荒野で、不思議なわざとしるしを行ないました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","このモーセが、イスラエルの人々に、『神はあなたがたのために、私のようなひとりの預言者を、あなたがたの兄弟たちの中からお立てになる。』と言ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","また、この人が、シナイ山で彼に語った御使いや私たちの先祖たちとともに、荒野の集会において、生けるみことばを授かり、あなたがたに与えたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ところが、私たちの先祖たちは彼に従うことを好まず、かえって彼を退け、エジプトをなつかしく思って、 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","『私たちに、先立って行く神々を作ってください。私たちをエジプトの地から導き出したモーセは、どうなったのかわかりませんから。』とアロンに言いました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","そのころ彼らは子牛を作り、この偶像に供え物をささげ、彼らの手で作った物を楽しんでいました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","そこで、神は彼らに背を向け、彼らが天の星に仕えるままにされました。預言者たちの書に書いてあるとおりです。 『イスラエルの家よ。あなたがたは 荒野にいた四十年の間に、 ほふられた獣と供え物とを、 わたしにささげたことがあったか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","あなたがたは、モロクの幕屋と ロンパの神の星をかついでいた。 それらは、あなたがたが拝むために 作った偶像ではないか。 それゆえ、わたしは、あなたがたを バビロンのかなたへ移す。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","私たちの先祖のためには、荒野にあかしの幕屋がありました。それは、見たとおりの形に造れとモーセに言われた方の命令どおりに、造られていました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","私たちの先祖は、この幕屋を次々に受け継いで、神が先祖たちの前から異邦人を追い払い、その領土を取らせてくださったときには、ヨシュアとともにそれを運び入れ、ついにダビデの時代となりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ダビデは神の前に恵みをいただき、ヤコブの神のために御住まいを得たいと願い求めました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","けれども、神のために家を建てたのはソロモンでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","しかし、いと高き方は、手で造った家にはお住みになりません。預言者が語っているとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","『主は言われる。 天はわたしの王座、 地はわたしの足の足台である。 あなたがたは、どのような家を わたしのために建てようとするのか。 わたしの休む所とは、どこか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","わたしの手が、これらのものを みな、造ったのではないか。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","かたくなで、心と耳とに割礼を受けていない人たち。あなたがたは、先祖たちと同様に、いつも聖霊に逆らっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","あなたがたの先祖が迫害しなかった預言者がだれかあったでしょうか。彼らは、正しい方が来られることを前もって宣べた人たちを殺したが、今はあなたがたが、この正しい方を裏切る者、殺す者となりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","あなたがたは、御使いたちによって定められた律法を受けたが、それを守ったことはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","人々はこれを聞いて、はらわたが煮え返る思いで、ステパノに向かって歯ぎしりした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","しかし、聖霊に満たされていたステパノは、天を見つめ、神の栄光と、神の右に立っておられるイエスとを見て、 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","こう言った。「見なさい。天が開けて、人の子が神の右に立っておられるのが見えます。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","人々は大声で叫びながら、耳をおおい、いっせいにステパノに殺到した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","そして彼を町の外に追い出して、石で打ち殺した。証人たちは、自分たちの着物をサウロという青年の足もとに置いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","こうして彼らがステパノに石を投げつけていると、ステパノは主を呼んで、こう言った。「主イエスよ。私の霊をお受けください。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","そして、ひざまずいて、大声でこう叫んだ。「主よ。この罪を彼らに負わせないでください。」こう言って、眠りについた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","サウロは、ステパノを殺すことに賛成していた。その日、エルサレムの教会に対する激しい迫害が起こり、使徒たち以外の者はみな、ユダヤとサマリヤの諸地方に散らされた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","敬虔な人たちはステパノを葬り、彼のために非常に悲しんだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","サウロは教会を荒らし、家々にはいって、男も女も引きずり出し、次々に牢に入れた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","他方、散らされた人たちは、みことばを宣べながら、巡り歩いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ピリポはサマリヤの町に下って行き、人々にキリストを宣べ伝えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","群衆はピリポの話を聞き、その行なっていたしるしを見て、みなそろって、彼の語ることに耳を傾けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","汚れた霊につかれた多くの人たちからは、その霊が大声で叫んで出て行くし、大ぜいの中風の者や足のきかない者は直ったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","それでその町に大きな喜びが起こった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ところが、この町にシモンという人がいた。彼は以前からこの町で魔術を行なって、サマリヤの人々を驚かし、自分は偉大な者だと話していた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","小さな者から大きな者に至るまで、あらゆる人々が彼に関心を抱き、「この人こそ、大能と呼ばれる、神の力だ。」と言っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","人々が彼に関心を抱いたのは、長い間、その魔術に驚かされていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","しかし、ピリポが神の国とイエス・キリストの御名について宣べるのを信じた彼らは、男も女もバプテスマを受けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","シモン自身も信じて、バプテスマを受け、いつもピリポについていた。そして、しるしとすばらしい奇蹟が行なわれるのを見て、驚いていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","さて、エルサレムにいる使徒たちは、サマリヤの人々が神のことばを受け入れたと聞いて、ペテロとヨハネを彼らのところへ遣わした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ふたりは下って行って、人々が聖霊を受けるように祈った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","彼らは主イエスの御名によってバプテスマを受けていただけで、聖霊がまだだれにも下っておられなかったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ふたりが彼らの上に手を置くと、彼らは聖霊を受けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","使徒たちが手を置くと聖霊が与えられるのを見たシモンは、使徒たちのところに金を持って来て、 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","「私が手を置いた者がだれでも聖霊を受けられるように、この権威を私にも下さい。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ペテロは彼に向かって言った。「あなたの金は、あなたとともに滅びるがよい。あなたは金で神の賜物を手に入れようと思っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","あなたは、このことについては何の関係もないし、それにあずかることもできません。あなたの心が神の前に正しくないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","だから、この悪事を悔い改めて、主に祈りなさい。あるいは、心に抱いた思いが赦されるかもしれません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","あなたはまだ苦い胆汁と不義のきずなの中にいることが、私にはよくわかっています。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","シモンは答えて言った。「あなたがたの言われた事が何も私に起こらないように、私のために主に祈ってください。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","このようにして、使徒たちはおごそかにあかしをし、また主のことばを語って後、エルサレムへの帰途につき、サマリヤ人の多くの村でも福音を宣べ伝えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ところが、主の使いがピリポに向かってこう言った。「立って南へ行き、エルサレムからガザに下る道に出なさい。」（このガザは今、荒れ果てている。） ");
INSERT INTO jpn1965_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","そこで、彼は立って出かけた。すると、そこに、エチオピヤ人の女王カンダケの高官で、女王の財産全部を管理していた宦官のエチオピヤ人がいた。彼は礼拝のためエルサレムに上り、 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","いま帰る途中であった。彼は馬車に乗って、預言者イザヤの書を読んでいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","御霊がピリポに「近寄って、あの馬車といっしょに行きなさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","そこでピリポが走って行くと、預言者イザヤの書を読んでいるのが聞こえたので、「あなたは、読んでいることが、わかりますか。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","すると、その人は、「導く人がなければ、どうしてわかりましょう。」と言った。そして馬車に乗っていっしょにすわるように、ピリポに頼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","彼が読んでいた聖書の個所には、こう書いてあった。 「ほふり場に連れて行かれる羊のように、 また、黙々として 毛を刈る者の前に立つ小羊のように、 彼は口を開かなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","彼は、卑しめられ、そのさばきも取り上げられた。 彼の時代のことを、だれが話すことができようか。 彼のいのちは地上から取り去られたのである。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","宦官はピリポに向かって言った。「預言者はだれについて、こう言っているのですか。どうか教えてください。自分についてですか。それとも、だれかほかの人についてですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ピリポは口を開き、この聖句から始めて、イエスのことを彼に宣べ伝えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","道を進んで行くうちに、水のある所に来たので、宦官は言った。「ご覧なさい。水があります。私がバプテスマを受けるのに、何かさしつかえがあるでしょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","38","そして馬車を止めさせ、ピリポも宦官も水の中へ降りて行き、ピリポは宦官にバプテスマを授けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","水から上がって来たとき、主の霊がピリポを連れ去られたので、宦官はそれから後彼を見なかったが、喜びながら帰って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","それからピリポはアゾトに現われ、すべての町々を通って福音を宣べ伝え、カイザリヤに行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","さてサウロは、なおも主の弟子たちに対する脅かしと殺害の意に燃えて、大祭司のところに行き、 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ダマスコの諸会堂あての手紙を書いてくれるよう頼んだ。それは、この道の者であれば男でも女でも、見つけ次第縛り上げてエルサレムに引いて来るためであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ところが、道を進んで行って、ダマスコの近くまで来たとき、突然、天からの光が彼を巡り照らした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","彼は地に倒れて、「サウロ、サウロ。なぜわたしを迫害するのか。」という声を聞いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","彼が、「主よ。あなたはどなたですか。」と言うと、お答えがあった。「わたしは、あなたが迫害しているイエスである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","立ち上がって、町にはいりなさい。そうすれば、あなたのしなければならないことが告げられるはずです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","同行していた人たちは、声は聞こえても、だれも見えないので、ものも言えずに立っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","サウロは地面から立ち上がったが、目は開いていても何も見えなかった。そこで人々は彼の手を引いて、ダマスコへ連れて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","彼は三日の間、目が見えず、また飲み食いもしなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","さて、ダマスコにアナニヤという弟子がいた。主が彼に幻の中で、「アナニヤよ。」と言われたので、「主よ。ここにおります。」と答えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","すると主はこう言われた。「立って、『まっすぐ』という街路に行き、サウロというタルソ人をユダの家に尋ねなさい。そこで、彼は祈っています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","彼は、アナニヤという者がはいって来て、自分の上に手を置くと、目が再び見えるようになるのを、幻で見たのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","しかし、アナニヤはこう答えた。「主よ。私は多くの人々から、この人がエルサレムで、あなたの聖徒たちにどんなにひどいことをしたかを聞きました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","彼はここでも、あなたの御名を呼ぶ者たちをみな捕縛する権限を、祭司長たちから授けられているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","しかし、主はこう言われた。「行きなさい。あの人はわたしの名を、異邦人、王たち、イスラエルの子孫の前に運ぶ、わたしの選びの器です。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","彼がわたしの名のために、どんなに苦しまなければならないかを、わたしは彼に示すつもりです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","そこでアナニヤは出かけて行って、その家にはいり、サウロの上に手を置いてこう言った。「兄弟サウロ。あなたが来る途中でお現われになった主イエスが、私を遣わされました。あなたが再び見えるようになり、聖霊に満たされるためです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","するとただちに、サウロの目からうろこのような物が落ちて、目が見えるようになった。彼は立ち上がって、バプテスマを受け、 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","食事をして元気づいた。 サウロは数日の間、ダマスコの弟子たちとともにいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","そしてただちに、諸会堂で、イエスは神の子であると宣べ伝え始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","これを聞いた人々はみな、驚いてこう言った。「この人はエルサレムで、この御名を呼ぶ者たちを滅ぼした者ではありませんか。ここへやって来たのも、彼らを縛って、祭司長たちのところへ引いて行くためではないのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","しかしサウロはますます力を増し、イエスがキリストであることを証明して、ダマスコに住むユダヤ人たちをうろたえさせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","多くの日数がたって後、ユダヤ人たちはサウロを殺す相談をしたが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","その陰謀はサウロに知られてしまった。彼らはサウロを殺してしまおうと、昼も夜も町の門を全部見張っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","そこで、彼の弟子たちは、夜中に彼をかごに乗せ、町の城壁伝いにつり降ろした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","サウロはエルサレムに着いて、弟子たちの仲間にはいろうと試みたが、みなは彼を弟子だとは信じないで、恐れていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ところが、バルナバは彼を引き受けて、使徒たちのところへ連れて行き、彼がダマスコへ行く途中で主を見た様子や、主が彼に向かって語られたこと、また彼がダマスコでイエスの御名を大胆に宣べた様子などを彼らに説明した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","それからサウロは、エルサレムで弟子たちとともにいて自由に出はいりし、主の御名によって大胆に語った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","そして、ギリシヤ語を使うユダヤ人たちと語ったり、論じたりしていた。しかし、彼らはサウロを殺そうとねらっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","兄弟たちはそれと知って、彼をカイザリヤに連れて下り、タルソへ送り出した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","こうして教会は、ユダヤ、ガリラヤ、サマリヤの全地にわたり築き上げられて平安を保ち、主を恐れかしこみ、聖霊に励まされて前進し続けたので、信者の数がふえて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","さて、ペテロはあらゆる所を巡回したが、ルダに住む聖徒たちのところへも下って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","彼はそこで、八年の間も床に着いているアイネヤという人に出会った。彼は中風であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ペテロは彼にこう言った。「アイネヤ。イエス・キリストがあなたをいやしてくださるのです。立ち上がりなさい。そして自分で床を整えなさい。」すると彼はただちに立ち上がった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ルダとサロンに住む人々はみな、アイネヤを見て、主に立ち返った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ヨッパにタビタ（ギリシヤ語に訳せば、ドルカス）という女の弟子がいた。この女は、多くの良いわざと施しをしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ところが、そのころ彼女は病気になって死に、人々はその遺体を洗って、屋上の間に置いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ルダはヨッパに近かったので、弟子たちは、ペテロがそこにいると聞いて、人をふたり彼のところへ送って、「すぐに来てください。」と頼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","そこでペテロは立って、いっしょに出かけた。ペテロが到着すると、彼らは屋上の間に案内した。やもめたちはみな泣きながら、彼のそばに来て、ドルカスがいっしょにいたころ作ってくれた下着や上着の数々を見せるのであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ペテロはみなの者を外に出し、ひざまずいて祈った。そしてその遺体のほうを向いて、「タビタ。起きなさい。」と言った。すると彼女は目をあけ、ペテロを見て起き上がった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","そこで、ペテロは手を貸して彼女を立たせた。そして聖徒たちとやもめたちとを呼んで、生きている彼女を見せた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","このことがヨッパ中に知れ渡り、多くの人々が主を信じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","そして、ペテロはしばらくの間、ヨッパで、皮なめしのシモンという人の家に泊まっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","さて、カイザリヤにコルネリオという人がいて、イタリヤ隊という部隊の百人隊長であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","彼は敬虔な人で、全家族とともに神を恐れかしこみ、ユダヤの人々に多くの施しをなし、いつも神に祈りをしていたが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ある日の午後三時ごろ、幻の中で、はっきりと神の御使いを見た。御使いは彼のところに来て、「コルネリオ。」と呼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","彼は、御使いを見つめていると、恐ろしくなって、「主よ。何でしょうか。」と答えた。すると御使いはこう言った。「あなたの祈りと施しは神の前に立ち上って、覚えられています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","さあ今、ヨッパに人をやって、シモンという人を招きなさい。彼の名はペテロとも呼ばれています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","この人は皮なめしのシモンという人の家に泊まっていますが、その家は海べにあります。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","御使いが彼にこう語って立ち去ると、コルネリオはそのしもべたちの中のふたりと、側近の部下の中の敬虔な兵士ひとりとを呼び寄せ、 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","全部のことを説明してから、彼らをヨッパへ遣わした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","その翌日、この人たちが旅を続けて、町の近くまで来たころ、ペテロは祈りをするために屋上に上った。昼の十二時ごろであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","すると彼は非常に空腹を覚え、食事をしたくなった。ところが、食事の用意がされている間に、彼はうっとりと夢ごこちになった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","見ると、天が開けており、大きな敷布のような入れ物が、四隅をつるされて地上に降りて来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","その中には、地上のあらゆる種類の四つ足の動物や、はうもの、また、空の鳥などがいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","そして、彼に、「ペテロ。さあ、ほふって食べなさい。」という声が聞こえた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","しかしペテロは言った。「主よ。それはできません。私はまだ一度も、きよくない物や汚れた物を食べたことがありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","すると、再び声があって、彼にこう言った。「神がきよめた物を、きよくないと言ってはならない。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","こんなことが三回あって後、その入れ物はすぐ天に引き上げられた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ペテロが、いま見た幻はいったいどういうことだろう、と思い惑っていると、ちょうどそのとき、コルネリオから遣わされた人たちが、シモンの家をたずね当てて、その門口に立っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","そして、声をかけて、ペテロと呼ばれるシモンという人がここに泊まっているだろうかと尋ねていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ペテロが幻について思い巡らしているとき、御霊が彼にこう言われた。「見なさい。三人の人があなたをたずねて来ています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","さあ、下に降りて行って、ためらわずに、彼らといっしょに行きなさい。彼らを遣わしたのはわたしです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","そこでペテロは、その人たちのところへ降りて行って、こう言った。「あなたがたのたずねているペテロは、私です。どんなご用でおいでになったのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","すると彼らはこう言った。「百人隊長コルネリオという正しい人で、神を恐れかしこみ、ユダヤの全国民に評判の良い人が、あなたを自分の家にお招きして、あなたからお話を聞くように、聖なる御使いによって示されました。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","それで、ペテロは、彼らを中に入れて泊まらせた。 明くる日、ペテロは、立って彼らといっしょに出かけた。ヨッパの兄弟たちも数人同行した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","その翌日、彼らはカイザリヤに着いた。コルネリオは、親族や親しい友人たちを呼び集め、彼らを待っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ペテロが着くと、コルネリオは出迎えて、彼の足もとにひれ伏して拝んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","するとペテロは彼を起こして、「お立ちなさい。私もひとりの人間です。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","それから、コルネリオとことばをかわしながら家にはいり、多くの人が集まっているのを見て、 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","彼らにこう言った。「ご承知のとおり、ユダヤ人が外国人の仲間にはいったり、訪問したりするのは、律法にかなわないことです。ところが、神は私に、どんな人のことでも、きよくないとか、汚れているとか言ってはならないことを示してくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","それで、お迎えを受けたとき、ためらわずに来たのです。そこで、お尋ねしますが、あなたがたは、いったいどういうわけで私をお招きになったのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","するとコルネリオがこう言った。「四日前のこの時刻に、私が家で午後三時の祈りをしていますと、どうでしょう、輝いた衣を着た人が、私の前に立って、 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","こう言いました。『コルネリオ。あなたの祈りは聞き入れられ、あなたの施しは神の前に覚えられている。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","それで、ヨッパに人をやってシモンを招きなさい。彼の名はペテロとも呼ばれている。この人は海べにある、皮なめしのシモンの家に泊まっている。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","それで、私はすぐあなたのところへ人を送ったのですが、よくおいでくださいました。いま私たちは、主があなたにお命じになったすべてのことを伺おうとして、みな神の御前に出ております。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","そこでペテロは、口を開いてこう言った。 「これで私は、はっきりわかりました。神はかたよったことをなさらず、 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","どの国の人であっても、神を恐れかしこみ、正義を行なう人なら、神に受け入れられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","神はイエス・キリストによって、平和を宣べ伝え、イスラエルの子孫にみことばをお送りになりました。このイエス・キリストはすべての人の主です。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","あなたがたは、ヨハネが宣べ伝えたバプテスマの後、ガリラヤから始まって、ユダヤ全土に起こった事がらを、よくご存じです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","それは、ナザレのイエスのことです。神はこの方に聖霊と力を注がれました。このイエスは、神がともにおられたので、巡り歩いて良いわざをなし、また悪魔に制せられているすべての者をいやされました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","私たちは、イエスがユダヤ人の地とエルサレムとで行なわれたすべてのことの証人です。人々はこの方を木にかけて殺しました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","しかし、神はこのイエスを三日目によみがえらせ、現われさせてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","しかし、それはすべての人々にではなく、神によって前もって選ばれた証人である私たちにです。私たちは、イエスが死者の中からよみがえられて後、ごいっしょに食事をしました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","イエスは私たちに命じて、このイエスこそ生きている者と死んだ者とのさばき主として、神によって定められた方であることを人々に宣べ伝え、そのあかしをするように、言われたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","イエスについては、預言者たちもみな、この方を信じる者はだれでも、その名によって罪の赦しが受けられる、とあかししています。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ペテロがなおもこれらのことばを話し続けているとき、みことばに耳を傾けていたすべての人々に、聖霊がお下りになった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","割礼を受けている信者で、ペテロといっしょに来た人たちは、異邦人にも聖霊の賜物が注がれたので驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","彼らが異言を話し、神を賛美するのを聞いたからである。そこでペテロはこう言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","「この人たちは、私たちと同じように、聖霊を受けたのですから、いったいだれが、水をさし止めて、この人たちにバプテスマを受けさせないようにすることができましょうか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","そして、イエス・キリストの御名によってバプテスマを受けるように彼らに命じた。彼らは、ペテロに数日間滞在するように願った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","さて、使徒たちやユダヤにいる兄弟たちは、異邦人たちも神のみことばを受け入れた、ということを耳にした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","そこで、ペテロがエルサレムに上ったとき、割礼を受けた者たちは、彼を非難して、 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","「あなたは割礼のない人々のところに行って、彼らといっしょに食事をした。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","そこでペテロは口を開いて、事の次第を順序正しく説明して言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","「私がヨッパの町で祈っていると、うっとりと夢ごこちになり、幻を見ました。四隅をつり下げられた大きな敷布のような入れ物が天から降りて来て、私のところに届いたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","その中をよく見ると、地の四つ足の獣、野獣、はうもの、空の鳥などが見えました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","そして、『ペテロ。さあ、ほふって食べなさい。』と言う声を聞きました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","しかし私は、『主よ。それはできません。私はまだ一度も、きよくない物や汚れた物を食べたことがありません。』と言いました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","すると、もう一度天から声がして、『神がきよめた物を、きよくないと言ってはならない。』というお答えがありました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","こんなことが三回あって後、全部の物がまた天へ引き上げられました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","すると、どうでしょう。ちょうどそのとき、カイザリヤから私のところへ遣わされた三人の人が、私たちのいた家の前に来ていました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","そして御霊は私に、ためらわずにその人たちといっしょに行くように、と言われました。そこで、この六人の兄弟たちも私に同行して、私たちはその人の家にはいって行きました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","その人が私たちに告げたところによると、彼は御使いを見ましたが、御使いは彼の家の中に立って、『ヨッパに使いをやって、ペテロと呼ばれるシモンを招きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","その人があなたとあなたの家にいるすべての人を救うことばを話してくれます。』と言ったというのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","そこで私が話し始めていると、聖霊が、あの最初のとき私たちにお下りになったと同じように、彼らの上にもお下りになったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","私はそのとき、主が、『ヨハネは水でバプテスマを授けたが、あなたがたは、聖霊によってバプテスマを授けられる。』と言われたみことばを思い起こしました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","こういうわけですから、私たちが主イエス・キリストを信じたとき、神が私たちに下さったのと同じ賜物を、彼らにもお授けになったのなら、どうして私などが神のなさることを妨げることができましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","人々はこれを聞いて沈黙し、「それでは、神は、いのちに至る悔い改めを異邦人にもお与えになったのだ。」と言って、神をほめたたえた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","さて、ステパノのことから起こった迫害によって散らされた人々は、フェニキヤ、キプロス、アンテオケまでも進んで行ったが、ユダヤ人以外の者にはだれにも、みことばを語らなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ところが、その中にキプロス人とクレネ人が幾人かいて、アンテオケに来てからはギリシヤ人にも語りかけ、主イエスのことを宣べ伝えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","そして、主の御手が彼らとともにあったので、大ぜいの人が信じて主に立ち返った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","この知らせが、エルサレムにある教会に聞こえたので、彼らはバルナバをアンテオケに派遣した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","彼はそこに到着したとき、神の恵みを見て喜び、みなが心を堅く保って、常に主にとどまっているようにと励ました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","彼はりっぱな人物で、聖霊と信仰に満ちている人であった。こうして、大ぜいの人が主に導かれた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","バルナバはサウロを捜しにタルソへ行き、 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","彼に会って、アンテオケに連れて来た。そして、まる一年の間、彼らは教会に集まり、大ぜいの人たちを教えた。弟子たちは、アンテオケで初めて、キリスト者と呼ばれるようになった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","そのころ、預言者たちがエルサレムからアンテオケに下って来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","その中のひとりでアガボという人が立って、世界中に大ききんが起こると御霊によって預言したが、はたしてそれがクラウデオの治世に起こった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","そこで、弟子たちは、それぞれの力に応じて、ユダヤに住んでいる兄弟たちに救援の物を送ることに決めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","彼らはそれを実行して、バルナバとサウロの手によって長老たちに送った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","そのころ、ヘロデ王は、教会の中のある人々を苦しめようとして、その手を伸ばし、 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ヨハネの兄弟ヤコブを剣で殺した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","それがユダヤ人の気に入ったのを見て、次にはペテロをも捕えにかかった。それは、種なしパンの祝いの時期であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ヘロデはペテロを捕えて牢に入れ、四人一組の兵士四組に引き渡して監視させた。それは、過越の祭りの後に、民の前に引き出す考えであったからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","こうしてペテロは牢に閉じ込められていた。教会は彼のために、神に熱心に祈り続けていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ところでヘロデが彼を引き出そうとしていた日の前夜、ペテロは二本の鎖につながれてふたりの兵士の間で寝ており、戸口には番兵たちが牢を監視していた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","すると突然、主の御使いが現われ、光が牢を照らした。御使いはペテロのわき腹をたたいて彼を起こし、「急いで立ち上がりなさい。」と言った。すると、鎖が彼の手から落ちた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","そして御使いが、「帯を締めて、くつをはきなさい。」と言うので、彼はそのとおりにした。すると、「上着を着て、私について来なさい。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","そこで、外に出て、御使いについて行った。彼には御使いのしている事が現実の事だとはわからず、幻を見ているのだと思われた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","彼らが、第一、第二の衛所を通り、町に通じる鉄の門まで来ると、門がひとりでに開いた。そこで、彼らは外に出て、ある通りを進んで行くと、御使いは、たちまち彼を離れた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","そのとき、ペテロは我に返って言った。「今、確かにわかった。主は御使いを遣わして、ヘロデの手から、また、ユダヤ人たちが待ち構えていたすべての災いから、私を救い出してくださったのだ。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","こうとわかったので、ペテロは、マルコと呼ばれているヨハネの母マリヤの家へ行った。そこには大ぜいの人が集まって、祈っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","彼が入口の戸をたたくと、ロダという女中が応対に出て来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ところが、ペテロの声だとわかると、喜びのあまり門をあけもしないで、奥へ駆け込み、ペテロが門の外に立っていることをみなに知らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","彼らは、「あなたは気が狂っているのだ。」と言ったが、彼女はほんとうだと言い張った。そこで彼らは、「それは彼の御使いだ。」と言っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","しかし、ペテロはたたき続けていた。彼らが門をあけると、そこにペテロがいたので、非常に驚いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","しかし彼は、手ぶりで彼らを静かにさせ、主がどのようにして牢から救い出してくださったかを、彼らに話して聞かせた。それから、「このことをヤコブと兄弟たちに知らせてください。」と言って、ほかの所へ出て行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","さて、朝になると、ペテロはどうなったのかと、兵士たちの間に大騒ぎが起こった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ヘロデは彼を捜したが見つけることができないので、番兵たちを取り調べ、彼らを処刑するように命じ、そして、ユダヤからカイザリヤに下って行って、そこに滞在した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","さて、ヘロデはツロとシドンの人々に対して強い敵意を抱いていた。そこで彼らはみなでそろって彼をたずね、王の侍従ブラストに取り入って和解を求めた。その地方は王の国から食糧を得ていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","定められた日に、ヘロデは王服を着けて、王座に着き、彼らに向かって演説を始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","そこで民衆は、「神の声だ。人間の声ではない。」と叫び続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","するとたちまち、主の使いがヘロデを打った。ヘロデが神に栄光を帰さなかったからである。彼は虫にかまれて息が絶えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","主のみことばは、ますます盛んになり、広まって行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","任務を果たしたバルナバとサウロは、マルコと呼ばれるヨハネを連れて、エルサレムから帰って来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","さて、アンテオケには、そこにある教会に、バルナバ、ニゲルと呼ばれるシメオン、クレネ人ルキオ、国主ヘロデの乳兄弟マナエン、サウロなどという預言者や教師がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","彼らが主を礼拝し、断食をしていると、聖霊が、「バルナバとサウロをわたしのために聖別して、わたしが召した任務につかせなさい。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","そこで彼らは、断食と祈りをして、ふたりの上に手を置いてから、送り出した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ふたりは聖霊に遣わされて、セルキヤに下り、そこから船でキプロスに渡った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","サラミスに着くと、ユダヤ人の諸会堂で神のことばを宣べ始めた。彼らはヨハネを助手として連れていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","島全体を巡回して、パポスまで行ったところ、にせ預言者で、名をバルイエスというユダヤ人の魔術師に出会った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","この男は地方総督セルギオ・パウロのもとにいた。この総督は賢明な人であって、バルナバとサウロを招いて、神のことばを聞きたいと思っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ところが、魔術師エルマ（エルマという名を訳すと魔術師）は、ふたりに反対して、総督を信仰の道から遠ざけようとした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","しかし、サウロ、別名でパウロは、聖霊に満たされ、彼をにらみつけて、 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","言った。「ああ、あらゆる偽りとよこしまに満ちた者、悪魔の子、すべての正義の敵。おまえは、主のまっすぐな道を曲げることをやめないのか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","見よ。主の御手が今、おまえの上にある。おまえは盲になって、しばらくの間、日の光を見ることができなくなる。」と言った。するとたちまち、かすみとやみが彼をおおったので、彼は手を引いてくれる人を捜し回った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","この出来事を見た総督は、主の教えに驚嘆して信仰にはいった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","パウロの一行は、パポスから船出して、パンフリヤのペルガに渡った。ここでヨハネは一行から離れて、エルサレムに帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","しかし彼らは、ペルガから進んでピシデヤのアンテオケに行き、安息日に会堂にはいって席に着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","律法と預言者の朗読があって後、会堂の管理者たちが、彼らのところに人をやってこう言わせた。「兄弟たち。あなたがたのうちどなたか、この人たちのために奨励のことばがあったら、どうぞお話しください。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","そこでパウロが立ち上がり、手を振りながら言った。「イスラエルの人たち、ならびに神を恐れかしこむ方々。よく聞いてください。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","この民イスラエルの神は、私たちの先祖たちを選び、民がエジプトの地に滞在していた間にこれを強大にし、御腕を高く上げて、彼らをその地から導き出してくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","そして約四十年間、荒野で彼らを養われました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","それからカナンの地で、七つの民を滅ぼし、その地を相続財産として分配されました。これが、約四百五十年間のことです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","その後、預言者サムエルの時代までは、さばき人たちをお遣わしになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","それから彼らが王をほしがったので、神はベニヤミン族の人、キスの子サウロを四十年間お与えになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","それから、彼を退けて、ダビデを立てて王とされましたが、このダビデについてあかしして、こう言われました。『わたしはエッサイの子ダビデを見いだした。彼はわたしの心にかなった者で、わたしのこころを余すところなく実行する。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","神は、このダビデの子孫から、約束に従って、イスラエルに救い主イエスをお送りになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","この方がおいでになる前に、ヨハネがイスラエルのすべての民に、前もって悔い改めのバプテスマを宣べ伝えていました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ヨハネは、その一生を終えようとするころ、こう言いました。『あなたがたは、私をだれと思うのですか。私はその方ではありません。ご覧なさい。その方は私のあとからおいでになります。私は、その方のくつのひもを解く値うちもありません。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","兄弟の方々、アブラハムの子孫の方々、ならびに皆さんの中で神を恐れかしこむ方々。この救いのことばは、私たちに送られているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","エルサレムに住む人々とその指導者たちは、このイエスを認めず、また安息日ごとに読まれる預言者のことばを理解せず、イエスを罪に定めて、その預言を成就させてしまいました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","そして、死罪に当たる何の理由も見いだせなかったのに、イエスを殺すことをピラトに強要したのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","こうして、イエスについて書いてあることを全部成し終えて後、イエスを十字架から取り降ろして墓の中に納めました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","しかし、神はこの方を死者の中からよみがえらせたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","イエスは、ご自分といっしょにガリラヤからエルサレムに上った人たちに、幾日もお現われになりました。きょう、その人たちがこの民に対してイエスの証人となっています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","私たちは、神が先祖たちに対してなされた約束について、あなたがたに良い知らせをしているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","神は、イエスをよみがえらせ、それによって、私たち子孫にその約束を果たされました。詩篇の第二篇に、『あなたは、わたしの子。きょう、わたしがあなたを生んだ。』と書いてあるとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","神がイエスを死者の中からよみがえらせて、もはや朽ちることのない方とされたことについては、『わたしはダビデに約束した聖なる確かな祝福を、あなたがたに与える。』というように言われていました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ですから、ほかの所でこう言っておられます。『あなたは、あなたの聖者を朽ち果てるままにはしておかれない。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ダビデは、その生きていた時代において神のみこころに仕えて後、死んで先祖の仲間に加えられ、ついに朽ち果てました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","しかし、神がよみがえらせた方は、朽ちることがありませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ですから、兄弟たち。あなたがたに罪の赦しが宣べられているのはこの方によるということを、よく知っておいてください。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","モーセの律法によっては解放されることのできなかったすべての点について、信じる者はみな、この方によって、解放されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ですから、預言者に言われているような事が、あなたがたの上に起こらないように気をつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","『見よ。あざける者たち。驚け。そして滅びよ。 わたしはおまえたちの時代に一つのことをする。 それは、おまえたちに、どんなに説明しても、 とうてい信じられないほどのことである。』」 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ふたりが会堂を出るとき、人々は、次の安息日にも同じことについて話してくれるように頼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","会堂の集会が終わってからも、多くのユダヤ人と神を敬う改宗者たちが、パウロとバルナバについて来たので、ふたりは彼らと話し合って、いつまでも神の恵みにとどまっているように勧めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","次の安息日には、ほとんど町中の人が、神のことばを聞きに集まって来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","しかし、この群衆を見たユダヤ人たちは、ねたみに燃え、パウロの話に反対して、口ぎたなくののしった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","そこでパウロとバルナバは、はっきりとこう宣言した。「神のことばは、まずあなたがたに語られなければならなかったのです。しかし、あなたがたはそれを拒んで、自分自身を永遠のいのちにふさわしくない者と決めたのです。見なさい。私たちは、これからは異邦人のほうへ向かいます。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","なぜなら、主は私たちに、こう命じておられるからです。 『わたしはあなたを立てて、異邦人の光とした。 あなたが地の果てまでも救いをもたらすためである。』」 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","異邦人たちは、それを聞いて喜び、主のみことばを賛美した。そして、永遠のいのちに定められていた人たちは、みな、信仰にはいった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","こうして、主のみことばは、この地方全体に広まった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ところが、ユダヤ人たちは、神を敬う貴婦人たちや町の有力者たちを扇動して、パウロとバルナバを迫害させ、ふたりをその地方から追い出した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ふたりは、彼らに対して足のちりを払い落として、イコニオムへ行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","弟子たちは喜びと聖霊に満たされていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","イコニオムでも、ふたりは連れ立ってユダヤ人の会堂にはいり、話をすると、ユダヤ人もギリシヤ人も大ぜいの人々が信仰にはいった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","しかし、信じようとしないユダヤ人たちは、異邦人たちをそそのかして、兄弟たちに対し悪意を抱かせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","それでも、ふたりは長らく滞在し、主によって大胆に語った。主は、彼らの手にしるしと不思議なわざを行なわせ、御恵みのことばの証明をされた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ところが、町の人々は二派に分かれ、ある者はユダヤ人の側につき、ある者は使徒たちの側についた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","異邦人とユダヤ人が彼らの指導者たちといっしょになって、使徒たちをはずかしめて、石打ちにしようと企てたとき、 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ふたりはそれを知って、ルカオニヤの町であるルステラとデルベ、およびその付近の地方に難を避け、 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","そこで福音の宣教を続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ルステラでのことであるが、ある足のきかない人がすわっていた。彼は生まれながらの足なえで、歩いたことがなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","この人がパウロの話すことに耳を傾けていた。パウロは彼に目を留め、いやされる信仰があるのを見て、 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","大声で、「自分の足で、まっすぐに立ちなさい。」と言った。すると彼は飛び上がって、歩き出した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","パウロのしたことを見た群衆は、声を張り上げ、ルカオニヤ語で、「神々が人間の姿をとって、私たちのところにお下りになったのだ。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","そして、バルナバをゼウスと呼び、パウロがおもに話す人であったので、パウロをヘルメスと呼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","すると、町の門の前にあるゼウス神殿の祭司は、雄牛数頭と花飾りを門の前に携えて来て、群衆といっしょに、いけにえをささげようとした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","これを聞いた使徒たち、バルナバとパウロは、衣を裂いて、群衆の中に駆け込み、叫びながら、 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","言った。「皆さん。どうしてこんなことをするのですか。私たちも皆さんと同じ人間です。そして、あなたがたがこのようなむなしいことを捨てて、天と地と海とその中にあるすべてのものをお造りになった生ける神に立ち返るように、福音を宣べ伝えている者たちです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","過ぎ去った時代には、神はあらゆる国の人々がそれぞれ自分の道を歩むことを許しておられました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","とはいえ、ご自身のことをあかししないでおられたのではありません。すなわち、恵みをもって、天から雨を降らせ、実りの季節を与え、食物と喜びとで、あなたがたの心を満たしてくださったのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","こう言って、ようやくのことで、群衆が彼らにいけにえをささげるのをやめさせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ところが、アンテオケとイコニオムからユダヤ人たちが来て、群衆を抱き込み、パウロを石打ちにし、死んだものと思って、町の外に引きずり出した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","しかし、弟子たちがパウロを取り囲んでいると、彼は立ち上がって町にはいって行った。その翌日、彼はバルナバとともにデルベに向かった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","彼らはその町で福音を宣べ、多くの人を弟子としてから、ルステラとイコニオムとアンテオケとに引き返して、 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","弟子たちの心を強め、この信仰にしっかりとどまるように勧め、「私たちが神の国にはいるには、多くの苦しみを経なければならない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","また、彼らのために教会ごとに長老たちを選び、断食をして祈って後、彼らをその信じていた主にゆだねた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ふたりはピシデヤを通ってパンフリヤに着き、 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ペルガでみことばを語ってから、アタリヤに下り、 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","そこから船でアンテオケに帰った。そこは、彼らがいま成し遂げた働きのために、以前神の恵みにゆだねられて送り出された所であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","そこに着くと、教会の人々を集め、神が彼らとともにいて行なわれたすべてのことと、異邦人に信仰の門を開いてくださったこととを報告した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","そして、彼らはかなり長い期間を弟子たちとともに過ごした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","さて、ある人々がユダヤから下って来て、兄弟たちに、「モーセの慣習に従って割礼を受けなければ、あなたがたは救われない。」と教えていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","そしてパウロやバルナバと彼らとの間に激しい対立と論争が生じたので、パウロとバルナバと、その仲間のうちの幾人かが、この問題について使徒たちや長老たちと話し合うために、エルサレムに上ることになった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","彼らは教会の人々に見送られ、フェニキヤとサマリヤを通る道々で、異邦人の改宗のことを詳しく話したので、すべての兄弟たちに大きな喜びをもたらした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","エルサレムに着くと、彼らは教会と使徒たちと長老たちに迎えられ、神が彼らとともにいて行なわれたことを、みなに報告した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","しかし、パリサイ派の者で信者になった人々が立ち上がり、「異邦人にも割礼を受けさせ、また、モーセの律法を守ることを命じるべきである。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","そこで使徒たちと長老たちは、この問題を検討するために集まった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","激しい論争があって後、ペテロが立ち上がって言った。「兄弟たち。ご存じのとおり、神は初めのころ、あなたがたの間で事をお決めになり、異邦人が私の口から福音のことばを聞いて信じるようにされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","そして、人の心の中を知っておられる神は、私たちに与えられたと同じように異邦人にも聖霊を与えて、彼らのためにあかしをし、 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","私たちと彼らとに何の差別もつけず、彼らの心を信仰によってきよめてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","それなのに、なぜ、今あなたがたは、私たちの先祖も私たちも負いきれなかったくびきを、あの弟子たちの首に掛けて、神を試みようとするのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","私たちが主イエスの恵みによって救われたことを私たちは信じますが、あの人たちもそうなのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","すると、全会衆は沈黙してしまった。そして、バルナバとパウロが、彼らを通して神が異邦人の間で行なわれたしるしと不思議なわざについて話すのに、耳を傾けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ふたりが話し終えると、ヤコブがこう言った。「兄弟たち。私の言うことを聞いてください。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","神が初めに、どのように異邦人を顧みて、その中から御名をもって呼ばれる民をお召しになったかは、シメオンが説明したとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","預言者たちのことばもこれと一致しており、それにはこう書いてあります。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","『この後、わたしは帰って来て、 倒れたダビデの幕屋を建て直す。 すなわち、廃墟と化した幕屋を建て直し、 それを元どおりにする。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","それは、残った人々、すなわち、 わたしの名で呼ばれる異邦人がみな、 主を求めるようになるためである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","大昔からこれらのことを知らせておられる主が、 こう言われる。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","そこで、私の判断では、神に立ち返る異邦人を悩ませてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ただ、偶像に供えて汚れた物と不品行と絞め殺した物と血とを避けるように書き送るべきだと思います。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","昔から、町ごとにモーセの律法を宣べる者がいて、それが安息日ごとに諸会堂で読まれているからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","そこで使徒たちと長老たち、また、全教会もともに、彼らの中から人を選んで、パウロやバルナバといっしょにアンテオケへ送ることを決議した。選ばれたのは兄弟たちの中の指導者たちで、バルサバと呼ばれるユダおよびシラスであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","彼らはこの人たちに託して、こう書き送った。「使徒および長老たちは、アンテオケ、シリヤ、キリキヤにいる異邦人の兄弟たちに、あいさつをいたします。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","私たちの中のある者たちが、私たちからは何も指示を受けていないのに、いろいろなことを言ってあなたがたを動揺させ、あなたがたの心を乱したことを聞きました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","そこで、私たちは人々を選び、私たちの愛するバルナバおよびパウロといっしょに、あなたがたのところへ送ることに衆議一決しました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","このバルナバとパウロは、私たちの主イエス・キリストの御名のために、いのちを投げ出した人たちです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","こういうわけで、私たちはユダとシラスを送りました。彼らは口頭で同じ趣旨のことを伝えるはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","聖霊と私たちは、次のぜひ必要な事のほかは、あなたがたにその上、どんな重荷も負わせないことを決めました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","すなわち、偶像に供えた物と、血と、絞め殺した物と、不品行とを避けることです。これらのことを注意深く避けていれば、それで結構です。以上。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","さて、一行は送り出されて、アンテオケに下り、教会の人々を集めて、手紙を手渡した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","それを読んだ人々は、その励ましによって喜んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ユダもシラスも預言者であったので、多くのことばをもって兄弟たちを励まし、また力づけた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","彼らは、しばらく滞在して後、兄弟たちの平安のあいさつに送られて、彼らを送り出した人々のところへ帰って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","パウロとバルナバはアンテオケにとどまって、ほかの多くの人々とともに、主のみことばを教え、宣べ伝えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","幾日かたって後、パウロはバルナバにこう言った。「先に主のことばを伝えたすべての町々の兄弟たちのところに、またたずねて行って、どうしているか見て来ようではありませんか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ところが、バルナバは、マルコとも呼ばれるヨハネもいっしょに連れて行くつもりであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","しかしパウロは、パンフリヤで一行から離れてしまい、仕事のために同行しなかったような者はいっしょに連れて行かないほうがよいと考えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","そして激しい反目となり、その結果、互いに別行動をとることになって、バルナバはマルコを連れて、船でキプロスに渡って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","パウロはシラスを選び、兄弟たちから主の恵みにゆだねられて出発した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","そして、シリヤおよびキリキヤを通り、諸教会を力づけた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","それからパウロはデルベに、次いでルステラに行った。そこにテモテという弟子がいた。信者であるユダヤ婦人の子で、ギリシヤ人を父としていたが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ルステラとイコニオムとの兄弟たちの間で評判の良い人であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","パウロは、このテモテを連れて行きたかったので、その地方にいるユダヤ人の手前、彼に割礼を受けさせた。彼の父がギリシヤ人であることを、みなが知っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","さて、彼らは町々を巡回して、エルサレムの使徒たちと長老たちが決めた規定を守らせようと、人々にそれを伝えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","こうして諸教会は、その信仰を強められ、日ごとに人数を増して行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","それから彼らは、アジヤでみことばを語ることを聖霊によって禁じられたので、フルギヤ・ガラテヤの地方を通った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","こうしてムシヤに面した所に来たとき、ビテニヤのほうに行こうとしたが、イエスの御霊がそれをお許しにならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","それでムシヤを通って、トロアスに下った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ある夜、パウロは幻を見た。ひとりのマケドニヤ人が彼の前に立って、「マケドニヤに渡って来て、私たちを助けてください。」と懇願するのであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","パウロがこの幻を見たとき、私たちはただちにマケドニヤへ出かけることにした。神が私たちを招いて、彼らに福音を宣べさせるのだ、と確信したからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","そこで、私たちはトロアスから船に乗り、サモトラケに直航して、翌日ネアポリスに着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","それからピリピに行ったが、ここはマケドニヤのこの地方第一の町で、植民都市であった。私たちはこの町に幾日か滞在した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","安息日に、私たちは町の門を出て、祈り場があると思われた川岸に行き、そこに腰をおろして、集まった女たちに話した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","テアテラ市の紫布の商人で、神を敬う、ルデヤという女が聞いていたが、主は彼女の心を開いて、パウロの語る事に心を留めるようにされた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","そして、彼女も、またその家族もバプテスマを受けたとき、彼女は、「私を主に忠実な者とお思いでしたら、どうか、私の家に来てお泊まりください。」と言って頼み、強いてそうさせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","私たちが祈り場に行く途中、占いの霊につかれた若い女奴隷に出会った。この女は占いをして、主人たちに多くの利益を得させている者であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","彼女はパウロと私たちのあとについて来て、「この人たちは、いと高き神のしもべたちで、救いの道をあなたがたに宣べ伝えている人たちです。」と叫び続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","幾日もこんなことをするので、困り果てたパウロは、振り返ってその霊に、「イエス・キリストの御名によって命じる。この女から出て行け。」と言った。すると即座に、霊は出て行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","彼女の主人たちは、もうける望みがなくなったのを見て、パウロとシラスを捕え、役人たちに訴えるため広場へ引き立てて行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","そして、ふたりを長官たちの前に引き出してこう言った。「この者たちはユダヤ人でありまして、私たちの町をかき乱し、 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ローマ人である私たちが、採用も実行もしてはならない風習を宣伝しております。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","群衆もふたりに反対して立ったので、長官たちは、ふたりの着物をはいでむちで打つように命じ、 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","何度もむちで打たせてから、ふたりを牢に入れて、看守には厳重に番をするように命じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","この命令を受けた看守は、ふたりを奥の牢に入れ、足に足かせを掛けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","真夜中ごろ、パウロとシラスが神に祈りつつ賛美の歌を歌っていると、ほかの囚人たちも聞き入っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ところが突然、大地震が起こって、獄舎の土台が揺れ動き、たちまちとびらが全部あいて、みなの鎖が解けてしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","目をさました看守は、見ると、牢のとびらがあいているので、囚人たちが逃げてしまったものと思い、剣を抜いて自殺しようとした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","そこでパウロは大声で、「自害してはいけない。私たちはみなここにいる。」と叫んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","看守はあかりを取り、駆け込んで来て、パウロとシラスとの前に震えながらひれ伏した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","そして、ふたりを外に連れ出して「先生がた。救われるためには、何をしなければなりませんか。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ふたりは、「主イエスを信じなさい。そうすれば、あなたもあなたの家族も救われます。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","そして、彼とその家の者全部に主のことばを語った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","看守は、その夜、時を移さず、ふたりを引き取り、その打ち傷を洗った。そして、そのあとですぐ、彼とその家の者全部がバプテスマを受けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","それから、ふたりをその家に案内して、食事のもてなしをし、全家族そろって神を信じたことを心から喜んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","夜が明けると、長官たちは警吏たちを送って、「あの人たちを釈放せよ。」と言わせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","そこで看守は、この命令をパウロに伝えて、「長官たちが、あなたがたを釈放するようにと、使いをよこしました。どうぞ、ここを出て、ご無事に行ってください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ところが、パウロは、警吏たちにこう言った。「彼らは、ローマ人である私たちを、取り調べもせずに公衆の前でむち打ち、牢に入れてしまいました。それなのに今になって、ひそかに私たちを送り出そうとするのですか。とんでもない。彼ら自身で出向いて来て、私たちを連れ出すべきです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","警吏たちは、このことばを長官たちに報告した。すると長官たちは、ふたりがローマ人であると聞いて恐れ、 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","自分で出向いて来て、わびを言い、ふたりを外に出して、町から立ち去ってくれるように頼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","牢を出たふたりは、ルデヤの家に行った。そして兄弟たちに会い、彼らを励ましてから出て行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","彼らはアムピポリスとアポロニヤを通って、テサロニケへ行った。そこには、ユダヤ人の会堂があった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","パウロはいつもしているように、会堂にはいって行って、三つの安息日にわたり、聖書に基づいて彼らと論じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","そして、キリストは苦しみを受け、死者の中からよみがえらなければならないことを説明し、また論証して、「私があなたがたに伝えているこのイエスこそ、キリストなのです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","彼らのうちの幾人かはよくわかって、パウロとシラスに従った。またほかに、神を敬うギリシヤ人が大ぜいおり、貴婦人たちも少なくなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ところが、ねたみにかられたユダヤ人は、町のならず者をかり集め、暴動を起こして町を騒がせ、またヤソンの家を襲い、ふたりを人々の前に引き出そうとして捜した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","しかし、見つからないので、ヤソンと兄弟たちの幾人かを、町の役人たちのところへひっぱって行き、大声でこう言った。「世界中を騒がせて来た者たちが、ここにもはいり込んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","それをヤソンが家に迎え入れたのです。彼らはみな、イエスという別の王がいると言って、カイザルの詔勅にそむく行ないをしているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","こうして、それを聞いた群衆と町の役人たちとを不安に陥れた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","彼らは、ヤソンとそのほかの者たちから保証金を取ったうえで釈放した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","兄弟たちは、すぐさま、夜のうちにパウロとシラスをベレヤへ送り出した。ふたりはそこに着くと、ユダヤ人の会堂にはいって行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ここのユダヤ人は、テサロニケにいる者たちよりも良い人たちで、非常に熱心にみことばを聞き、はたしてそのとおりかどうかと毎日聖書を調べた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","そのため、彼らのうちの多くの者が信仰にはいった。その中にはギリシヤの貴婦人や男子も少なくなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ところが、テサロニケのユダヤ人たちは、パウロがベレヤでも神のことばを伝えていることを知り、ここにもやって来て、群衆を扇動して騒ぎを起こした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","そこで兄弟たちは、ただちにパウロを送り出して海べまで行かせたが、シラスとテモテはベレヤに踏みとどまった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","パウロを案内した人たちは、彼をアテネまで連れて行った。そしてシラスとテモテに一刻も早く来るように、という命令を受けて、帰って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","さて、アテネでふたりを待っていたパウロは、町が偶像でいっぱいなのを見て、心に憤りを感じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","そこでパウロは、会堂ではユダヤ人や神を敬う人たちと論じ、広場では毎日そこに居合わせた人たちと論じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","エピクロス派とストア派の哲学者たちも幾人かいて、パウロと論じ合っていたが、その中のある者たちは、「このおしゃべりは、何を言うつもりなのか。」と言い、ほかの者たちは、「彼は外国の神々を伝えているらしい。」と言った。パウロがイエスと復活とを宣べ伝えたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","そこで彼らは、パウロをアレオパゴスに連れて行ってこう言った。「あなたの語っているその新しい教えがどんなものであるか、知らせていただけませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","私たちにとっては珍しいことを聞かせてくださるので、それがいったいどんなものか、私たちは知りたいのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","アテネ人も、そこに住む外国人もみな、何か耳新しいことを話したり、聞いたりすることだけで、日を過ごしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","そこでパウロは、アレオパゴスの真中に立って言った。「アテネの人たち。あらゆる点から見て、私はあなたがたを宗教心にあつい方々だと見ております。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","私が道を通りながら、あなたがたの拝むものをよく見ているうちに、『知られない神に。』と刻まれた祭壇があるのを見つけました。そこで、あなたがたが知らずに拝んでいるものを、教えましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","この世界とその中にあるすべてのものをお造りになった神は、天地の主ですから、手でこしらえた宮などにはお住みになりません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","また、何かに不自由なことでもあるかのように、人の手によって仕えられる必要はありません。神は、すべての人に、いのちと息と万物とをお与えになった方だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","神は、ひとりの人からすべての国の人々を造り出して、地の全面に住まわせ、それぞれに決められた時代と、その住まいの境界とをお定めになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","これは、神を求めさせるためであって、もし探り求めることでもあるなら、神を見いだすこともあるのです。確かに、神は、私たちひとりひとりから遠く離れてはおられません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","私たちは、神の中に生き、動き、また存在しているのです。あなたがたのある詩人たちも、『私たちもまたその子孫である。』と言ったとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","そのように私たちは神の子孫ですから、神を、人間の技術や工夫で造った金や銀や石などの像と同じものと考えてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","神は、そのような無知の時代を見過ごしておられましたが、今は、どこででもすべての人に悔い改めを命じておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","なぜなら、神は、お立てになったひとりの人により義をもってこの世界をさばくため、日を決めておられるからです。そして、その方を死者の中からよみがえらせることによって、このことの確証をすべての人にお与えになったのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","死者の復活のことを聞くと、ある者たちはあざ笑い、ほかの者たちは、「このことについては、またいつか聞くことにしよう。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","こうして、パウロは彼らの中から出て行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","しかし、彼につき従って信仰にはいった人たちもいた。それは、アレオパゴスの裁判官デオヌシオ、ダマリスという女、その他の人々であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","その後、パウロはアテネを去って、コリントへ行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ここで、アクラというポント生まれのユダヤ人およびその妻プリスキラに出会った。クラウデオ帝が、すべてのユダヤ人をローマから退去させるように命令したため、近ごろイタリヤから来ていたのである。パウロはふたりのところに行き、 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","自分も同業者であったので、その家に住んでいっしょに仕事をした。彼らの職業は天幕作りであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","パウロは安息日ごとに会堂で論じ、ユダヤ人とギリシヤ人を承服させようとした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","そして、シラスとテモテがマケドニヤから下って来ると、パウロはみことばを教えることに専念し、イエスがキリストであることを、ユダヤ人たちにはっきりと宣言した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","しかし、彼らが反抗して暴言を吐いたので、パウロは着物を振り払って、「あなたがたの血は、あなたがたの頭上にふりかかれ。私には責任がない。今から私は異邦人のほうに行く。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","そして、そこを去って、神を敬うテテオ・ユストという人の家に行った。その家は会堂の隣であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","会堂管理者クリスポは、一家をあげて主を信じた。また、多くのコリント人も聞いて信じ、バプテスマを受けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ある夜、主は幻によってパウロに、「恐れないで、語り続けなさい。黙ってはいけない。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","わたしがあなたとともにいるのだ。だれもあなたを襲って、危害を加える者はない。この町には、わたしの民がたくさんいるから。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","そこでパウロは、一年半ここに腰を据えて、彼らの間で神のことばを教え続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ところが、ガリオがアカヤの地方総督であったとき、ユダヤ人たちはこぞってパウロに反抗し、彼を法廷に引いて行って、 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","「この人は、律法にそむいて神を拝むことを、人々に説き勧めています。」と訴えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","パウロが口を開こうとすると、ガリオはユダヤ人に向かってこう言った。「ユダヤ人の諸君。不正事件や悪質な犯罪のことであれば、私は当然、あなたがたの訴えを取り上げもしようが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","あなたがたの、ことばや名称や律法に関する問題であるなら、自分たちで始末をつけるのがよかろう。私はそのようなことの裁判官にはなりたくない。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","こうして、彼らを法廷から追い出した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","そこで、みなの者は、会堂管理者ソステネを捕え、法廷の前で打ちたたいた。ガリオは、そのようなことは少しも気にしなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","パウロは、なお長らく滞在してから、兄弟たちに別れを告げて、シリヤへ向けて出帆した。プリスキラとアクラも同行した。パウロは一つの誓願を立てていたので、ケンクレヤで髪をそった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","彼らがエペソに着くと、パウロはふたりをそこに残し、自分だけ会堂にはいって、ユダヤ人たちと論じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","人々は、もっと長くとどまるように頼んだが、彼は聞き入れないで、 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","「神のみこころなら、またあなたがたのところに帰って来ます。」と言って別れを告げ、エペソから船出した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","それからカイザリヤに上陸してエルサレムに上り、教会にあいさつしてからアンテオケに下って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","そこにしばらくいてから、彼はまた出発し、ガラテヤの地方およびフルギヤを次々に巡って、すべての弟子たちを力づけた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","さて、アレキサンドリヤの生まれで、雄弁なアポロというユダヤ人がエペソに来た。彼は聖書に通じていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","この人は、主の道の教えを受け、霊に燃えて、イエスのことを正確に語り、また教えていたが、ただヨハネのバプテスマしか知らなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","彼は会堂で大胆に話し始めた。それを聞いていたプリスキラとアクラは、彼を招き入れて、神の道をもっと正確に彼に説明した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","そして、アポロがアカヤへ渡りたいと思っていたので、兄弟たちは彼を励まし、そこの弟子たちに、彼を歓迎してくれるようにと手紙を書いた。彼はそこに着くと、すでに恵みによって信者になっていた人たちを大いに助けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","彼は聖書によって、イエスがキリストであることを証明して、力強く、公然とユダヤ人たちを論破したからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","アポロがコリントにいた間に、パウロは奥地を通ってエペソに来た。そして幾人かの弟子に出会って、 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","「信じたとき、聖霊を受けましたか。」と尋ねると、彼らは、「いいえ、聖霊の与えられることは、聞きもしませんでした。」と答えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","「では、どんなバプテスマを受けたのですか。」と言うと、「ヨハネのバプテスマです。」と答えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","そこで、パウロは、「ヨハネは、自分のあとに来られるイエスを信じるように人々に告げて、悔い改めのバプテスマを授けたのです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","これを聞いたその人々は、主イエスの御名によってバプテスマを受けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","パウロが彼らの上に手を置いたとき、聖霊が彼らに臨まれ、彼らは異言を語ったり、預言をしたりした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","その人々は、みなで十二人ほどであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","それから、パウロは会堂にはいって、三か月の間大胆に語り、神の国について論じて、彼らを説得しようと努めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","しかし、ある者たちが心をかたくなにして聞き入れず、会衆の前で、この道をののしったので、パウロは彼らから身を引き、弟子たちをも退かせて、毎日ツラノの講堂で論じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","これが二年の間続いたので、アジヤに住む者はみな、ユダヤ人もギリシヤ人も主のことばを聞いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","神はパウロの手によって驚くべき奇蹟を行なわれた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","パウロの身に着けている手ぬぐいや前掛けをはずして病人に当てると、その病気は去り、悪霊は出て行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ところが、諸国を巡回しているユダヤ人の魔よけ祈祷師の中のある者たちも、ためしに、悪霊につかれている者に向かって主イエスの御名をとなえ、「パウロの宣べ伝えているイエスによって、おまえたちに命じる。」と言ってみた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","そういうことをしたのは、ユダヤの祭司長スケワという人の七人の息子たちであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","すると悪霊が答えて、「自分はイエスを知っているし、パウロもよく知っている。けれどおまえたちは何者だ。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","そして悪霊につかれている人は、彼らに飛びかかり、ふたりの者を押えつけて、みなを打ち負かしたので、彼らは裸にされ、傷を負ってその家を逃げ出した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","このことがエペソに住むユダヤ人とギリシヤ人の全部に知れ渡ったので、みな恐れを感じて、主イエスの御名をあがめるようになった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","そして、信仰にはいった人たちの中から多くの者がやって来て、自分たちのしていることをさらけ出して告白した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","また魔術を行なっていた多くの者が、その書物をかかえて来て、みなの前で焼き捨てた。その値段を合計してみると、銀貨五万枚になった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","こうして、主のことばは驚くほど広まり、ますます力強くなって行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","これらのことが一段落すると、パウロは御霊の示しにより、マケドニヤとアカヤを通ったあとでエルサレムに行くことにした。そして、「私はそこに行ってから、ローマも見なければならない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","そこで、自分に仕えている者の中からテモテとエラストのふたりをマケドニヤに送り出したが、パウロ自身は、なおしばらくアジヤにとどまっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","そのころ、この道のことから、ただならぬ騒動が持ち上がった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","それというのは、デメテリオという銀細工人がいて、銀でアルテミス神殿の模型を作り、職人たちにかなりの収入を得させていたが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","彼が、その職人たちや、同業の者たちをも集めて、こう言ったからである。「皆さん。ご承知のように、私たちが繁盛しているのは、この仕事のおかげです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ところが、皆さんが見てもいるし聞いてもいるように、あのパウロが、手で作った物など神ではないと言って、エペソばかりか、ほとんどアジヤ全体にわたって、大ぜいの人々を説き伏せ、迷わせているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","これでは、私たちのこの仕事も信用を失う危険があるばかりか、大女神アルテミスの神殿も顧みられなくなり、全アジヤ、全世界の拝むこの大女神のご威光も地に落ちてしまいそうです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","そう聞いて、彼らは大いに怒り、「偉大なのはエペソ人のアルテミスだ。」と叫び始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","そして、町中が大騒ぎになり、人々はパウロの同行者であるマケドニヤ人ガイオとアリスタルコを捕え、一団となって劇場へなだれ込んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","パウロは、その集団の中にはいって行こうとしたが、弟子たちがそうさせなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","アジヤ州の高官で、パウロの友人である人たちも、彼に使いを送って、劇場にはいらないように頼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ところで、集会は混乱状態に陥り、大多数の者は、なぜ集まったのかさえ知らなかったので、ある者はこのことを叫び、ほかの者は別のことを叫んでいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ユダヤ人たちがアレキサンデルという者を前に押し出したので、群衆の中のある人たちが彼を促すと、彼は手を振って、会衆に弁明しようとした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","しかし、彼がユダヤ人だとわかると、みなの者がいっせいに声をあげ、「偉大なのはエペソ人のアルテミスだ。」と二時間ばかりも叫び続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","町の書記役は、群衆を押し静めてこう言った。「エペソの皆さん。エペソの町が、大女神アルテミスと天から下ったそのご神体との守護者であることを知らない者が、いったいいるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","これは否定できない事実ですから、皆さんは静かにして、軽はずみなことをしないようにしなければいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","皆さんがここに引き連れて来たこの人たちは、宮を汚した者でもなく、私たちの女神をそしった者でもないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","それで、もしデメテリオとその仲間の職人たちが、だれかに文句があるのなら、裁判の日があるし、地方総督たちもいることですから、互いに訴え出たらよいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","もしあなたがたに、これ以上何か要求することがあるなら、正式の議会で決めてもらわなければいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","きょうの事件については、正当な理由がないのですから、騒擾罪に問われる恐れがあります。その点に関しては、私たちはこの騒動の弁護はできません。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","こう言って、その集まりを解散させた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","騒ぎが治まると、パウロは弟子たちを呼び集めて励まし、別れを告げて、マケドニヤへ向かって出発した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","そして、その地方を通り、多くの勧めをして兄弟たちを励ましてから、ギリシヤに来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","パウロはここで三か月を過ごしたが、そこからシリヤに向けて船出しようというときに、彼に対するユダヤ人の陰謀があったため、彼はマケドニヤを経て帰ることにした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","プロの子であるベレヤ人ソパテロ、テサロニケ人アリスタルコとセクンド、デルベ人ガイオ、テモテ、アジヤ人テキコとトロピモは、パウロに同行していたが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","彼らは先発して、トロアスで私たちを待っていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","種なしパンの祝いが過ぎてから、私たちはピリピから船出し、五日かかってトロアスで彼らと落ち合い、そこに七日間滞在した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","週の初めの日に、私たちはパンを裂くために集まった。そのときパウロは、翌日出発することにしていたので、人々と語り合い、夜中まで語り続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","私たちが集まっていた屋上の間には、ともしびがたくさんともしてあった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ユテコというひとりの青年が窓のところに腰を掛けていたが、ひどく眠けがさし、パウロの話が長く続くので、とうとう眠り込んでしまって、三階から下に落ちた。抱き起こしてみると、もう死んでいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","パウロは降りて来て、彼の上に身をかがめ、彼を抱きかかえて、「心配することはない。まだいのちがあります。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","そして、また上がって行き、パンを裂いて食べてから、明け方まで長く話し合って、それから出発した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","人々は生き返った青年を家に連れて行き、ひとかたならず慰められた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","さて、私たちは先に船に乗り込んで、アソスに向けて出帆した。そしてアソスでパウロを船に乗せることにしていた。パウロが、自分は陸路をとるつもりで、そう決めておいたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","こうして、パウロはアソスで私たちと落ち合い、私たちは彼を船に乗せてミテレネに着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","そこから出帆して、翌日キヨスの沖に達し、次の日サモスに立ち寄り、その翌日ミレトに着いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","それはパウロが、アジヤで時間を取られないようにと、エペソには寄港しないで行くことに決めていたからである。彼は、できれば五旬節の日にはエルサレムに着いていたい、と旅路を急いでいたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","パウロは、ミレトからエペソに使いを送って、教会の長老たちを呼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","彼らが集まって来たとき、パウロはこう言った。 「皆さんは、私がアジヤに足を踏み入れた最初の日から、私がいつもどんなふうにあなたがたと過ごして来たか、よくご存じです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","私は謙遜の限りを尽くし、涙をもって、またユダヤ人の陰謀によりわが身にふりかかる数々の試練の中で、主に仕えました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","益になることは、少しもためらわず、あなたがたに知らせました。人々の前でも、家々でも、あなたがたを教え、 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ユダヤ人にもギリシヤ人にも、神に対する悔い改めと、私たちの主イエスに対する信仰とをはっきりと主張したのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","いま私は、心を縛られて、エルサレムに上る途中です。そこで私にどんなことが起こるのかわかりません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ただわかっているのは、聖霊がどの町でも私にはっきりとあかしされて、なわめと苦しみが私を待っていると言われることです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","けれども、私が自分の走るべき行程を走り尽くし、主イエスから受けた、神の恵みの福音をあかしする任務を果たし終えることができるなら、私のいのちは少しも惜しいとは思いません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","皆さん。御国を宣べ伝えてあなたがたの中を巡回した私の顔を、あなたがたはもう二度と見ることがないことを、いま私は知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ですから、私はきょうここで、あなたがたに宣言します。私は、すべての人たちが受けるさばきについて責任がありません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","私は、神のご計画の全体を、余すところなくあなたがたに知らせておいたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","あなたがたは自分自身と群れの全体とに気を配りなさい。聖霊は、神がご自身の血をもって買い取られた神の教会を牧させるために、あなたがたを群れの監督にお立てになったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","私が出発したあと、狂暴な狼があなたがたの中にはいり込んで来て、群れを荒らし回ることを、私は知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","あなたがた自身の中からも、いろいろな曲がったことを語って、弟子たちを自分のほうに引き込もうとする者たちが起こるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ですから、目をさましていなさい。私が三年の間、夜も昼も、涙とともにあなたがたひとりひとりを訓戒し続けて来たことを、思い出してください。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","いま私は、あなたがたを神とその恵みのみことばとにゆだねます。みことばは、あなたがたを育成し、すべての聖別された人々の中にあって御国を継がせることができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","私は、人の金銀や衣服をむさぼったことはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","あなたがた自身が知っているとおり、この両手は、私の必要のためにも、私とともにいる人たちのためにも、働いて来ました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","このように労苦して弱い者を助けなければならないこと、また、主イエスご自身が、『受けるよりも与えるほうが幸いである。』と言われたみことばを思い出すべきことを、私は、万事につけ、あなたがたに示して来たのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","こう言い終わって、パウロはひざまずき、みなの者とともに祈った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","みなは声をあげて泣き、パウロの首を抱いて幾度も口づけし、 ");
INSERT INTO jpn1965_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","彼が、「もう二度と私の顔を見ることがないでしょう。」と言ったことばによって、特に心を痛めた。それから、彼らはパウロを船まで見送った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","私たちは彼らと別れて出帆し、コスに直航し、翌日ロドスに着き、そこからパタラに渡った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","そこにはフェニキヤ行きの船があったので、それに乗って出帆した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","やがてキプロスが見えて来たが、それを左にして、シリヤに向かって航海を続け、ツロに上陸した。ここで船荷を降ろすことになっていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","私たちは弟子たちを見つけ出して、そこに七日間滞在した。彼らは、御霊に示されて、エルサレムに上らぬようにと、しきりにパウロに忠告した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","しかし、滞在の日数が尽きると、私たちはそこを出て、旅を続けることにした。彼らはみな、妻や子どももいっしょに、町はずれまで私たちを送って来た。そして、ともに海岸にひざまずいて祈ってから、私たちは互いに別れを告げた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","それから私たちは船に乗り込み、彼らは家へ帰って行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","私たちはツロからの航海を終えて、トレマイに着いた。そこの兄弟たちにあいさつをして、彼らのところに一日滞在した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","翌日そこを立って、カイザリヤに着き、あの七人のひとりである伝道者ピリポの家にはいって、そこに滞在した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","この人には、預言する四人の未婚の娘がいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","幾日かそこに滞在していると、アガボという預言者がユダヤから下って来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","彼は私たちのところに来て、パウロの帯を取り、自分の両手と両足を縛って、「『この帯の持ち主は、エルサレムでユダヤ人に、こんなふうに縛られ、異邦人の手に渡される。』と聖霊がお告げになっています。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","私たちはこれを聞いて、土地の人たちといっしょになって、パウロに、エルサレムには上らないよう頼んだ。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","するとパウロは、「あなたがたは、泣いたり、私の心をくじいたりして、いったい何をしているのですか。私は、主イエスの御名のためなら、エルサレムで縛られることばかりでなく、死ぬことさえも覚悟しています。」と答えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","彼が聞き入れようとしないので、私たちは、「主のみこころのままに。」と言って、黙ってしまった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","こうして数日たつと、私たちは旅仕度をして、エルサレムに上った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","カイザリヤの弟子たちも幾人か私たちと同行して、古くからの弟子であるキプロス人マナソンのところに案内してくれた。私たちはそこに泊まることになっていたのである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","エルサレムに着くと、兄弟たちは喜んで私たちを迎えてくれた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","次の日、パウロは私たちを連れて、ヤコブを訪問した。そこには長老たちがみな集まっていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","彼らにあいさつしてから、パウロは彼の奉仕を通して神が異邦人の間でなさったことを、一つ一つ話しだした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","彼らはそれを聞いて神をほめたたえ、パウロにこう言った。「兄弟よ。ご承知のように、ユダヤ人の中で信仰にはいっている者は幾万となくありますが、みな律法に熱心な人たちです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ところで、彼らが聞かされていることは、あなたは異邦人の中にいるすべてのユダヤ人に、子どもに割礼を施すな、慣習に従って歩むな、と言って、モーセにそむくように教えているということなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","それで、どうしましょうか。あなたが来たことは、必ず彼らの耳にはいるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ですから、私たちの言うとおりにしてください。私たちの中に誓願を立てている者が四人います。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","この人たちを連れて、あなたも彼らといっしょに身を清め、彼らが頭をそる費用を出してやりなさい。そうすれば、あなたについて聞かされていることは根も葉もないことで、あなたも律法を守って正しく歩んでいることが、みなにわかるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","信仰にはいった異邦人に関しては、偶像の神に供えた肉と、血と、絞め殺した物と、不品行とを避けるべきであると決定しましたので、私たちはすでに手紙を書きました。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","そこで、パウロはその人たちを引き連れ、翌日、ともに身を清めて宮にはいり、清めの期間が終わって、ひとりひとりのために供え物をささげる日時を告げた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ところが、その七日がほとんど終わろうとしていたころ、アジヤから来たユダヤ人たちは、パウロが宮にいるのを見ると、全群衆をあおりたて、彼に手をかけて、 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","こう叫んだ。「イスラエルの人々。手を貸してください。この男は、この民と、律法と、この場所に逆らうことを、至る所ですべての人に教えている者です。そのうえ、ギリシヤ人を宮の中に連れ込んで、この神聖な場所をけがしています。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","彼らは前にエペソ人トロピモが町でパウロといっしょにいるのを見かけたので、パウロが彼を宮に連れ込んだのだと思ったのである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","そこで町中が大騒ぎになり、人々は殺到してパウロを捕え、宮の外へ引きずり出した。そして、ただちに宮の門が閉じられた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","彼らがパウロを殺そうとしていたとき、エルサレム中が混乱状態に陥っているという報告が、ローマ軍の千人隊長に届いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","彼はただちに、兵士たちと百人隊長たちとを率いて、彼らのところに駆けつけた。人々は千人隊長と兵士たちを見て、パウロを打つのをやめた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","千人隊長は近づいてパウロを捕え、二つの鎖につなぐように命じたうえ、パウロが何者なのか、何をしたのか、と尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","しかし、群衆がめいめい勝手なことを叫び続けたので、その騒がしさのために確かなことがわからなかった。そこで千人隊長は、パウロを兵営に連れて行くように命令した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","パウロが階段にさしかかったときには、群衆の暴行を避けるために、兵士たちが彼をかつぎ上げなければならなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","大ぜいの群衆が「彼を除け。」と叫びながら、ついて来たからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","兵営の中に連れ込まれようとしたとき、パウロが千人隊長に、「一言お話ししてもよいでしょうか。」と尋ねると、千人隊長は、「あなたはギリシヤ語を知っているのか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","するとあなたは、以前暴動を起こして、四千人の刺客を荒野に引き連れて逃げた、あのエジプト人ではないのか。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","パウロは答えた。「私はキリキヤのタルソ出身のユダヤ人で、れっきとした町の市民です。お願いです。この人々に話をさせてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","千人隊長がそれを許したので、パウロは階段の上に立ち、民衆に向かって手を振った。そして、すっかり静かになったとき、彼はヘブル語で次のように話した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","「兄弟たち、父たちよ。いま私が皆さんにしようとする弁明を聞いてください。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","パウロがヘブル語で語りかけるのを聞いて、人々はますます静粛になった。そこでパウロは話し続けた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","「私はキリキヤのタルソで生まれたユダヤ人ですが、この町で育てられ、ガマリエルのもとで私たちの先祖の律法について厳格な教育を受け、今日の皆さんと同じように、神に対して熱心な者でした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","私はこの道を迫害し、男も女も縛って牢に投じ、死にまでも至らせたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","このことは、大祭司も、長老たちの全議会も証言してくれます。この人たちから、私は兄弟たちへあてた手紙までも受け取り、ダマスコへ向かって出発しました。そこにいる者たちを縛り上げ、エルサレムに連れて来て処罰するためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ところが、旅を続けて、真昼ごろダマスコに近づいたとき、突然、天からまばゆい光が私の回りを照らしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","私は地に倒れ、『サウロ、サウロ。なぜわたしを迫害するのか。』という声を聞きました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","そこで私が答えて、『主よ。あなたはどなたですか。』と言うと、その方は、『わたしは、あなたが迫害しているナザレのイエスだ。』と言われました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","私といっしょにいた者たちは、その光は見たのですが、私に語っている方の声は聞き分けられませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","私が、『主よ。私はどうしたらよいのでしょうか。』と尋ねると、主は私に、『起きて、ダマスコに行きなさい。あなたがするように決められていることはみな、そこで告げられる。』と言われました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ところが、その光の輝きのために、私の目は何も見えなかったので、いっしょにいた者たちに手を引かれてダマスコにはいりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","すると、律法を重んじる敬虔な人で、そこに住むユダヤ人全体の間で評判の良いアナニヤという人が、 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","私のところに来て、そばに立ち、『兄弟サウロ。見えるようになりなさい。』と言いました。すると、そのとき、私はその人が見えるようになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","彼はこう言いました。『私たちの先祖の神は、あなたにみこころを知らせ、義なる方を見させ、その方の口から御声を聞かせようとお定めになったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","あなたはその方のために、すべての人に対して、あなたの見たこと、聞いたことの証人とされるのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","さあ、なぜためらっているのですか。立ちなさい。その御名を呼んでバプテスマを受け、自分の罪を洗い流しなさい。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","こうして私がエルサレムに帰り、宮で祈っていますと、夢ごこちになり、 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","主を見たのです。主は言われました。『急いで、早くエルサレムを離れなさい。人々がわたしについてのあなたのあかしを受け入れないからです。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","そこで私は答えました。『主よ。私がどの会堂ででも、あなたの信者を牢に入れたり、むち打ったりしていたことを、彼らはよく知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","また、あなたの証人ステパノの血が流されたとき、私もその場にいて、それに賛成し、彼を殺した者たちの着物の番をしていたのです。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","すると、主は私に、『行きなさい。わたしはあなたを遠く、異邦人に遣わす。』と言われました。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","人々は、彼の話をここまで聞いていたが、このとき声を張り上げて、「こんな男は、地上から除いてしまえ。生かしておくべきではない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","そして、人々がわめき立て、着物を放り投げ、ちりを空中にまき散らすので、 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","千人隊長はパウロを兵営の中に引き入れるように命じ、人々がなぜこのようにパウロに向かって叫ぶのかを知ろうとして、彼をむち打って取り調べるようにと言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","彼らがむちを当てるためにパウロを縛ったとき、パウロはそばに立っている百人隊長に言った。「ローマ市民である者を、裁判にもかけずに、むち打ってよいのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","これを聞いた百人隊長は、千人隊長のところに行って報告し、「どうなさいますか。あの人はローマ人です。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","千人隊長はパウロのところに来て、「あなたはローマ市民なのか、私に言ってくれ。」と言った。パウロは「そうです。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","すると、千人隊長は、「私はたくさんの金を出して、この市民権を買ったのだ。」と言った。そこでパウロは、「私は生まれながらの市民です。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","このため、パウロを取り調べようとしていた者たちは、すぐにパウロから身を引いた。また千人隊長も、パウロがローマ市民だとわかると、彼を鎖につないでいたので、恐れた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","その翌日、千人隊長は、パウロがなぜユダヤ人に告訴されたのかを確かめたいと思って、パウロの鎖を解いてやり、祭司長たちと全議会の召集を命じ、パウロを連れて行って、彼らの前に立たせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","パウロは議会を見つめて、こう言った。「兄弟たちよ。私は今日まで、全くきよい良心をもって、神の前に生活して来ました。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","すると大祭司アナニヤは、パウロのそばに立っている者たちに、彼の口を打てと命じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","そのとき、パウロはアナニヤに向かってこう言った。「ああ、白く塗った壁。神があなたを打たれる。あなたは、律法に従って私をさばく座に着きながら、律法にそむいて、私を打てと命じるのですか。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","するとそばに立っている者たちが、「あなたは神の大祭司をののしるのか。」と言ったので、 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","パウロが言った。「兄弟たち。私は彼が大祭司だとは知らなかった。確かに、『あなたの民の指導者を悪く言ってはいけない。』と書いてあります。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","しかし、パウロは、彼らの一部がサドカイ人で、一部がパリサイ人であるのを見て取って、議会の中でこう叫んだ。「兄弟たち。私はパリサイ人であり、パリサイ人の子です。私は死者の復活という望みのことで、さばきを受けているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","彼がこう言うと、パリサイ人とサドカイ人との間に意見の衝突が起こり、議会は二つに割れた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","サドカイ人は、復活はなく、御使いも霊もないと言い、パリサイ人は、どちらもあると言っていたからである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","騒ぎがいよいよ大きくなり、パリサイ派のある律法学者たちが立ち上がって激しく論じて、「私たちは、この人に何の悪い点も見いださない。もしかしたら、霊か御使いかが、彼に語りかけたのかもしれない。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","論争がますます激しくなったので、千人隊長は、パウロが彼らに引き裂かれてしまうのではないかと心配し、兵隊に、下に降りて行って、パウロを彼らの中から力ずくで引き出し、兵営に連れて来るように命じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","その夜、主がパウロのそばに立って、「勇気を出しなさい。あなたは、エルサレムでわたしのことをあかししたように、ローマでもあかしをしなければならない。」と言われた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","夜が明けると、ユダヤ人たちは徒党を組み、パウロを殺してしまうまでは飲み食いしないと誓い合った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","この陰謀に加わった者は、四十人以上であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","彼らは、祭司長たち、長老たちのところに行って、こう言った。「私たちは、パウロを殺すまでは何も食べない、と堅く誓い合いました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","そこで、今あなたがたは議会と組んで、パウロのことをもっと詳しく調べるふりをして、彼をあなたがたのところに連れて来るように千人隊長に願い出てください。私たちのほうでは、彼がそこに近づく前に殺す手はずにしています。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ところが、パウロの姉妹の子が、この待ち伏せのことを耳にし、兵営にはいってパウロにそれを知らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","そこでパウロは、百人隊長のひとりを呼んで、「この青年を千人隊長のところに連れて行ってください。お伝えすることがありますから。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","百人隊長は、彼を連れて千人隊長のもとに行き、「囚人のパウロが私を呼んで、この青年があなたにお話しすることがあるので、あなたのところに連れて行くようにと頼みました。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","千人隊長は彼の手を取り、だれもいない所に連れて行って、「私に伝えたいことというのは何か。」と尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","すると彼はこう言った。「ユダヤ人たちは、パウロについてもっと詳しく調べようとしているかに見せかけて、あす、議会にパウロを連れて来てくださるように、あなたにお願いすることを申し合わせました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","どうか、彼らの願いを聞き入れないでください。四十人以上の者が、パウロを殺すまでは飲み食いしない、と誓い合って、彼を待ち伏せしているのです。今、彼らは手はずを整えて、あなたの承諾を待っています。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","そこで千人隊長は、「このことを私に知らせたことは、だれにも漏らすな。」と命じて、その青年を帰らせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","そしてふたりの百人隊長を呼び、「今夜九時、カイザリヤに向けて出発できるように、歩兵二百人、騎兵七十人、槍兵二百人を整えよ。」と言いつけた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","また、パウロを乗せて無事に総督ペリクスのもとに送り届けるように、馬の用意もさせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","そして、次のような文面の手紙を書いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","「クラウデオ・ルシヤ、つつしんで総督ペリクス閣下にごあいさつ申し上げます。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","この者が、ユダヤ人に捕えられ、まさに殺されようとしていたとき、彼がローマ市民であることを知りましたので、私は兵隊を率いて行って、彼を助け出しました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","それから、どんな理由で彼が訴えられたかを知ろうと思い、彼をユダヤ人の議会に出頭させました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","その結果、彼が訴えられているのは、ユダヤ人の律法に関する問題のためで、死刑や投獄に当たる罪はないことがわかりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","しかし、この者に対する陰謀があるという情報を得ましたので、私はただちに彼を閣下のもとにお送りし、訴える者たちには、閣下の前で彼のことを訴えるようにと言い渡しておきました。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","そこで兵士たちは、命じられたとおりにパウロを引き取り、夜中にアンテパトリスまで連れて行き、 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","翌日、騎兵たちにパウロの護送を任せて、兵営に帰った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","騎兵たちは、カイザリヤに着き、総督に手紙を手渡して、パウロを引き合わせた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","総督は手紙を読んでから、パウロに、どの州の者かと尋ね、キリキヤの出であることを知って、 ");
INSERT INTO jpn1965_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","「あなたを訴える者が来てから、よく聞くことにしよう。」と言った。そして、ヘロデの官邸に彼を守っておくように命じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","五日の後、大祭司アナニヤは、数人の長老およびテルトロという弁護士といっしょに下って来て、パウロを総督に訴えた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","パウロが呼び出されると、テルトロが訴えを始めてこう言った。 「ペリクス閣下。閣下のおかげで、私たちはすばらしい平和を与えられ、また、閣下のご配慮で、この国の改革が進行しておりますが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","その事実をあらゆる面において、また至る所で認めて、私たちは心から感謝しております。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","さて、あまりご迷惑をおかけしないように、ごく手短に申し上げますから、ご寛容をもってお聞きくださるようお願いいたします。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","この男は、まるでペストのような存在で、世界中のユダヤ人の間に騒ぎを起こしている者であり、ナザレ人という一派の首領でございます。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","この男は宮さえもけがそうとしましたので、私たちは彼を捕えました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","8","閣下ご自身で、これらすべてのことについて彼をお調べくださいますなら、私たちが彼を訴えております事がらを、おわかりになっていただけるはずです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ユダヤ人たちも、この訴えに同調し、全くそのとおりだと言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","そのとき、総督がパウロに、話すようにと合図したので、パウロはこう答えた。 「閣下が多年に渡り、この民の裁判をつかさどる方であることを存じておりますので、私は喜んで弁明いたします。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","お調べになればわかることですが、私が礼拝のためにエルサレムに上って来てから、まだ十二日しかたっておりません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","そして、宮でも会堂でも、また市内でも、私がだれかと論争したり、群衆を騒がせたりするのを見た者はありません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","いま私を訴えていることについて、彼らは証拠をあげることができないはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","しかし、私は、彼らが異端と呼んでいるこの道に従って、私たちの先祖の神に仕えていることを、閣下の前で承認いたします。私は、律法にかなうことと、預言者たちが書いていることとを全部信じています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","また、義人も悪人も必ず復活するという、この人たち自身も抱いている望みを、神にあって抱いております。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","そのために、私はいつも、神の前にも人の前にも責められることのない良心を保つように、と最善を尽くしています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","さて私は、同胞に対して施しをし、また供え物をささげるために、幾年ぶりかで帰って来ました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","その供え物のことで私は清めを受けて宮の中にいたのを彼らに見られたのですが、別に群衆もおらず、騒ぎもありませんでした。ただアジヤから来た幾人かのユダヤ人がおりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","もし彼らに、私について何か非難したいことがあるなら、自分で閣下の前に来て訴えるべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","でなければ、今ここにいる人々に、議会の前に立っていたときの私にどんな不正を見つけたかを言わせてください。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","彼らの中に立っていたとき、私はただ一言、『死者の復活のことで、私はきょう、あなたがたの前でさばかれているのです。』と叫んだにすぎません。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","しかしペリクスは、この道について相当詳しい知識を持っていたので、「千人隊長ルシヤが下って来るとき、あなたがたの事件を解決することにしよう。」と言って、裁判を延期した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","そして百人隊長に、パウロを監禁するように命じたが、ある程度の自由を与え、友人たちが世話をすることを許した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","数日後、ペリクスはユダヤ人である妻ドルシラを連れて来て、パウロを呼び出し、キリスト・イエスを信じる信仰について話を聞いた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","しかし、パウロが正義と節制とやがて来る審判とを論じたので、ペリクスは恐れを感じ、「今は帰ってよい。おりを見て、また呼び出そう。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","それとともに、彼はパウロから金をもらいたい下心があったので、幾度もパウロを呼び出して話し合った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","二年たって後、ポルキオ・フェストがペリクスの後任になったが、ペリクスはユダヤ人に恩を売ろうとして、パウロを牢につないだままにしておいた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","フェストは州総督として着任すると、三日後にカイザリヤからエルサレムに上った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","すると、祭司長たちとユダヤ人のおもだった者たちが、パウロのことを訴え出て、 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","パウロを取り調べる件について自分たちに好意を持ってくれるように頼み、パウロをエルサレムに呼び寄せていただきたいと彼に懇願した。彼らはパウロを途中で殺害するために待ち伏せをさせていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ところが、フェストは、パウロはカイザリヤに拘置されているし、自分はまもなく出発の予定であると答え、 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","「だから、その男に何か不都合なことがあるなら、あなたがたのうちの有力な人たちが、私といっしょに下って行って、彼を告訴しなさい。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","フェストは、彼らのところに八日あるいは十日ばかり滞在しただけで、カイザリヤへ下って行き、翌日、裁判の席に着いて、パウロの出廷を命じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","パウロが出て来ると、エルサレムから下って来たユダヤ人たちは、彼を取り囲んで立ち、多くの重い罪状を申し立てたが、それを証拠立てることはできなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","しかしパウロは弁明して、「私は、ユダヤ人の律法に対しても、宮に対しても、またカイザルに対しても、何の罪も犯してはおりません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ところが、ユダヤ人の歓心を買おうとしたフェストは、パウロに向かって、「あなたはエルサレムに上り、この事件について、私の前で裁判を受けることを願うか。」と尋ねた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","すると、パウロはこう言った。「私はカイザルの法廷に立っているのですから、ここで裁判を受けるのが当然です。あなたもよくご存じのとおり、私はユダヤ人にどんな悪いこともしませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","もし私が悪いことをして、死罪に当たることをしたのでしたら、私は死をのがれようとはしません。しかし、この人たちが私を訴えていることに一つも根拠がないとすれば、だれも私を彼らに引き渡すことはできません。私はカイザルに上訴します。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","そのとき、フェストは陪席の者たちと協議したうえで、こう答えた。「あなたはカイザルに上訴したのだから、カイザルのもとへ行きなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","数日たってから、アグリッパ王とベルニケが、フェストに敬意を表するためにカイザリヤに来た。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ふたりがそこに長く滞在していたので、フェストはパウロの一件を王に持ち出してこう言った。「ペリクスが囚人として残して行ったひとりの男がおります。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","私がエルサレムに行ったとき、祭司たちとユダヤ人の長老たちとが、その男のことを私に訴え出て、罪に定めるように要求しました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","そのとき私は、『被告が、彼を訴えた者の面前で訴えに対して弁明する機会を与えられないで、そのまま引き渡されるということはローマの慣例ではない。』と答えておきました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","そういうわけで、訴える者たちがここに集まったとき、私は時を移さず、その翌日、裁判の席に着いて、その男を出廷させました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","訴えた者たちは立ち上がりましたが、私が予期していたような犯罪についての訴えは何一つ申し立てませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ただ、彼と言い争っている点は、彼ら自身の宗教に関することであり、また、死んでしまったイエスという者のことで、そのイエスが生きているとパウロは主張しているのでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","このような問題をどう取り調べたらよいか、私には見当がつかないので、彼に『エルサレムに上り、そこで、この事件について裁判を受けたいのか。』と尋ねたところが、 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","パウロは、皇帝の判決を受けるまで保護してほしいと願い出たので、彼をカイザルのもとに送る時まで守っておくように、命じておきました。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","すると、アグリッパがフェストに、「私も、その男の話を聞きたいものです。」と言ったので、フェストは、「では、明日お聞きください。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","こういうわけで、翌日、アグリッパとベルニケは、大いに威儀を整えて到着し、千人隊長たちや市の首脳者たちにつき添われて講堂にはいった。そのとき、フェストの命令によってパウロが連れて来られた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","そこで、フェストはこう言った。「アグリッパ王、ならびに、ここに同席の方々。ご覧ください。ユダヤ人がこぞって、一刻も生かしてはおけないと呼ばわり、エルサレムでも、ここでも、私に訴えて来たのは、この人のことです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","私としては、彼は死に当たることは何一つしていないと思います。しかし、彼自身が皇帝に上訴しましたので、彼をそちらに送ることに決めました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ところが、彼について、わが君に書き送るべき確かな事がらが一つもないのです。それで皆さんの前に、わけてもアグリッパ王よ、あなたの前に、彼を連れてまいりました。取り調べをしてみたら、何か書き送るべきことが得られましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","囚人を送るのに、その訴えの個条を示さないのは、理に合わないと思うのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","すると、アグリッパがパウロに、「あなたは、自分の言い分を申し述べてよろしい。」と言った。そこでパウロは、手を差し伸べて弁明し始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","「アグリッパ王。私がユダヤ人に訴えられているすべてのことについて、きょう、あなたの前で弁明できることを、幸いに存じます。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","特に、あなたがユダヤ人の慣習や問題に精通しておられるからです。どうか、私の申し上げることを、忍耐をもってお聞きくださるよう、お願いいたします。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","では申し述べますが、私が最初から私の国民の中で、またエルサレムにおいて過ごした若い時からの生活ぶりは、すべてのユダヤ人の知っているところです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","彼らは以前から私を知っていますので、証言するつもりならできることですが、私は、私たちの宗教の最も厳格な派に従って、パリサイ人として生活してまいりました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","そして今、神が私たちの先祖に約束されたものを待ち望んでいることで、私は裁判を受けているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","私たちの十二部族は、夜も昼も熱心に神に仕えながら、その約束のものを得たいと望んでおります。王よ。私は、この希望のためにユダヤ人から訴えられているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","神が死者をよみがえらせるということを、あなたがたは、なぜ信じがたいこととされるのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","以前は、私自身も、ナザレ人イエスの名に強硬に敵対すべきだと考えていました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","そして、それをエルサレムで実行しました。祭司長たちから権限を授けられた私は、多くの聖徒たちを牢に入れ、彼らが殺されるときには、それに賛成の票を投じました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","また、すべての会堂で、しばしば彼らを罰しては、強いて御名をけがすことばを言わせようとし、彼らに対する激しい怒りに燃えて、ついには国外の町々にまで彼らを追跡して行きました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","このようにして、私は祭司長たちから権限と委任を受けて、ダマスコへ出かけて行きますと、 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","その途中、正午ごろ、王よ、私は天からの光を見ました。それは太陽よりも明るく輝いて、私と同行者たちとの回りを照らしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","私たちはみな地に倒れましたが、そのとき声があって、ヘブル語で私にこう言うのが聞こえました。『サウロ、サウロ。なぜわたしを迫害するのか。とげのついた棒をけるのは、あなたにとって痛いことだ。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","私が『主よ。あなたはどなたですか。』と言いますと、主がこう言われました。『わたしは、あなたが迫害しているイエスである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","起き上がって、自分の足で立ちなさい。わたしがあなたに現われたのは、あなたが見たこと、また、これから後わたしがあなたに現われて示そうとすることについて、あなたを奉仕者、また証人に任命するためである。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","わたしは、この民と異邦人との中からあなたを救い出し、彼らのところに遣わす。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","それは彼らの目を開いて、暗やみから光に、サタンの支配から神に立ち返らせ、わたしを信じる信仰によって、彼らに罪の赦しを得させ、聖別された人々の中にあって御国を受け継がせるためである。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","こういうわけで、アグリッパ王よ、私は、この天からの啓示にそむかず、 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ダマスコにいる人々をはじめエルサレムにいる人々に、またユダヤの全地方に、さらに異邦人にまで、悔い改めて神に立ち返り、悔い改めにふさわしい行ないをするようにと宣べ伝えて来たのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","そのために、ユダヤ人たちは私を宮の中で捕え、殺そうとしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","こうして、私はこの日に至るまで神の助けを受け、堅く立って、小さい者にも大きい者にもあかしをしているのです。そして、預言者たちやモーセが、後に起こるはずだと語ったこと以外は何も話しませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","すなわち、キリストは苦しみを受けること、また、死者の中からの復活によって、この民と異邦人とに最初に光を宣べ伝える、ということです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","パウロがこのように弁明していると、フェストが大声で、「気が狂っているぞ。パウロ。博学があなたの気を狂わせている。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","するとパウロは次のように言った。「フェスト閣下。気は狂っておりません。私は、まじめな真理のことばを話しています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","王はこれらのことをよく知っておられるので、王に対して私は率直に申し上げているのです。これらのことは片隅で起こった出来事ではありませんから、そのうちの一つでも王の目に留まらなかったものはないと信じます。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","アグリッパ王。あなたは預言者を信じておられますか。もちろん信じておられると思います。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","するとアグリッパはパウロに、「あなたは、わずかなことばで、私をキリスト者にしようとしている。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","パウロはこう答えた。「ことばが少なかろうと、多かろうと、私が神に願うことは、あなたばかりでなく、きょう私の話を聞いている人がみな、この鎖は別として、私のようになってくださることです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ここで王と総督とベルニケ、および同席の人々が立ち上がった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","彼らは退場してから、互いに話し合って言った。「あの人は、死や投獄に相当することは何もしていない。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","またアグリッパはフェストに、「この人は、もしカイザルに上訴しなかったら、釈放されたであろうに。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","さて、私たちが船でイタリヤへ行くことが決まったとき、パウロと、ほかの数人の囚人は、ユリアスという親衛隊の百人隊長に引き渡された。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","私たちは、アジヤの沿岸の各地に寄港して行くアドラミテオの船に乗り込んで出帆した。テサロニケのマケドニヤ人アリスタルコも同行した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","翌日、シドンに入港した。ユリアスはパウロを親切に取り扱い、友人たちのところへ行って、もてなしを受けることを許した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","そこから出帆したが、向かい風なので、キプロスの島陰を航行した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","そしてキリキヤとパンフリヤの沖を航行して、ルキヤのミラに入港した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","そこに、イタリヤへ行くアレキサンドリヤの船があったので、百人隊長は私たちをそれに乗り込ませた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","幾日かの間、船の進みはおそく、ようやくのことでクニドの沖に着いたが、風のためにそれ以上進むことができず、サルモネ沖のクレテの島陰を航行し、 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","その岸に沿って進みながら、ようやく、良い港と呼ばれる所に着いた。その近くにラサヤの町があった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","かなりの日数が経過しており、断食の季節もすでに過ぎていたため、もう航海は危険であったので、パウロは人々に注意して、 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","「皆さん。この航海では、きっと、積荷や船体だけではなく、私たちの生命にも、危害と大きな損失が及ぶと、私は考えます。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","しかし百人隊長は、パウロのことばよりも、航海士や船長のほうを信用した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","また、この港が冬を過ごすのに適していなかったので、大多数の者の意見は、ここを出帆して、できれば何とかして、南西と北西とに面しているクレテの港ピニクスまで行って、そこで冬を過ごしたいということになった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","おりから、穏やかな南風が吹いて来ると、人々はこの時とばかり錨を上げて、クレテの海岸に沿って航行した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ところが、まもなくユーラクロンという暴風が陸から吹きおろして来て、 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","船はそれに巻き込まれ、風に逆らって進むことができないので、しかたなく吹き流されるままにした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","しかしクラウダという小さな島の陰にはいったので、ようやくのことで小舟を処置することができた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","小舟を船に引き上げ、備え綱で船体を巻いた。また、スルテスの浅瀬に乗り上げるのを恐れて、船具をはずして流れるに任せた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","私たちは暴風に激しく翻弄されていたので、翌日、人々は積荷を捨て始め、 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","三日目には、自分の手で船具までも投げ捨てた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","太陽も星も見えない日が幾日も続き、激しい暴風が吹きまくるので、私たちが助かる最後の望みも今や絶たれようとしていた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","だれも長いこと食事をとらなかったが、そのときパウロが彼らの中に立って、こう言った。「皆さん。あなたがたは私の忠告を聞き入れて、クレテを出帆しなかったら、こんな危害や損失をこうむらなくて済んだのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","しかし、今、お勧めします。元気を出しなさい。あなたがたのうち、いのちを失う者はひとりもありません。失われるのは船だけです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","昨夜、私の主で、私の仕えている神の御使いが、私の前に立って、 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","こう言いました。『恐れてはいけません。パウロ。あなたは必ずカイザルの前に立ちます。そして、神はあなたと同船している人々をみな、あなたにお与えになったのです。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ですから、皆さん。元気を出しなさい。すべて私に告げられたとおりになると、私は神によって信じています。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","私たちは必ず、どこかの島に打ち上げられます。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","十四日目の夜になって、私たちがアドリヤ海を漂っていると、真夜中ごろ、水夫たちは、どこかの陸地に近づいたように感じた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","水の深さを測ってみると、四十メートルほどであることがわかった。少し進んでまた測ると、三十メートルほどであった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","どこかで暗礁に乗り上げはしないかと心配して、ともから四つの錨を投げおろし、夜の明けるのを待った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ところが、水夫たちは船から逃げ出そうとして、へさきから錨を降ろすように見せかけて、小舟を海に降ろしていたので、 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","パウロは百人隊長や兵士たちに、「あの人たちが船にとどまっていなければ、あなたがたも助かりません。」と言った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","そこで兵士たちは、小舟の綱を断ち切って、そのまま流れ去るのに任せた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ついに夜の明けかけたころ、パウロは、一同に食事をとることを勧めて、こう言った。「あなたがたは待ちに待って、きょうまで何も食べずに過ごして、十四日になります。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ですから、私はあなたがたに、食事をとることを勧めます。これであなたがたは助かることになるのです。あなたがたの頭から髪一筋も失われることはありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","こう言って、彼はパンを取り、一同の前で神に感謝をささげてから、それを裂いて食べ始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","そこで一同も元気づけられ、みなが食事をとった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","船にいた私たちは全部で二百七十六人であった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","十分食べてから、彼らは麦を海に投げ捨てて、船を軽くした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","夜が明けると、どこの陸地かわからないが、砂浜のある入江が目に留まったので、できれば、そこに船を乗り入れようということになった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","錨を切って海に捨て、同時にかじ綱を解き、風に前の帆を上げて、砂浜に向かって進んで行った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ところが、潮流の流れ合う浅瀬に乗り上げて、船を座礁させてしまった。へさきはめり込んで動かなくなり、ともは激しい波に打たれて破れ始めた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","兵士たちは、囚人たちがだれも泳いで逃げないように、殺してしまおうと相談した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","しかし百人隊長は、パウロをあくまでも助けようと思って、その計画を押え、泳げる者がまず海に飛び込んで陸に上がるように、 ");
INSERT INTO jpn1965_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","それから残りの者は、板切れや、その他の、船にある物につかまって行くように命じた。こうして、彼らはみな、無事に陸に上がった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","こうして救われてから、私たちは、ここがマルタと呼ばれる島であることを知った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","島の人々は私たちに非常に親切にしてくれた。おりから雨が降りだして寒かったので、彼らは火をたいて私たちみなをもてなしてくれた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","パウロがひとかかえの柴をたばねて火にくべると、熱気のために、一匹のまむしがはい出して来て、彼の手に取りついた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","島の人々は、この生き物がパウロの手から下がっているのを見て、「この人はきっと人殺しだ。海からはのがれたが、正義の女神はこの人を生かしてはおかないのだ。」と互いに話し合った。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","しかし、パウロは、その生き物を火の中に振り落として、何の害も受けなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","島の人々は、彼が今にも、はれ上がって来るか、または、倒れて急死するだろうと待っていた。しかし、いくら待っても、彼に少しも変わった様子が見えないので、彼らは考えを変えて、「この人は神さまだ。」と言いだした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","さて、その場所の近くに、島の首長でポプリオという人の領地があった。彼はそこに私たちを招待して、三日間手厚くもてなしてくれた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","たまたまポプリオの父が、熱病と下痢とで床に着いていた。そこでパウロは、その人のもとに行き、祈ってから、彼の上に手を置いて直してやった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","このことがあってから、島のほかの病人たちも来て、直してもらった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","それで彼らは、私たちを非常に尊敬し、私たちが出帆するときには、私たちに必要な品々を用意してくれた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","三か月後に、私たちは、この島で冬を過ごしていた、船首にデオスクロイの飾りのある、アレキサンドリヤの船で出帆した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","シラクサに寄港して、三日間とどまり、 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","そこから回って、レギオンに着いた。一日たつと、南風が吹き始めたので、二日目にはポテオリに入港した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ここで、私たちは兄弟たちに会い、勧められるままに彼らのところに七日間滞在した。こうして、私たちはローマに到着した。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","私たちのことを聞いた兄弟たちは、ローマからアピオ・ポロとトレス・タベルネまで出迎えに来てくれた。パウロは彼らに会って、神に感謝し、勇気づけられた。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","私たちがローマにはいると、パウロは番兵付きで自分だけの家に住むことが許された。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","三日の後、パウロはユダヤ人のおもだった人たちを呼び集め、彼らが集まったときに、こう言った。「兄弟たち。私は、私の国民に対しても、先祖の慣習に対しても、何一つそむくことはしていないのに、エルサレムで囚人としてローマ人の手に渡されました。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ローマ人は私を取り調べましたが、私を死刑にする理由が何もなかったので、私を釈放しようと思ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ところが、ユダヤ人たちが反対したため、私はやむなくカイザルに上訴しました。それは、私の同胞を訴えようとしたのではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","このようなわけで、私は、あなたがたに会ってお話ししようと思い、お招きしました。私はイスラエルの望みのためにこの鎖につながれているのです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","すると、彼らはこう言った。「私たちは、あなたのことについて、ユダヤから何の知らせも受けておりません。また、当地に来た兄弟たちの中で、あなたについて悪いことを告げたり、話したりした者はおりません。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","私たちは、あなたが考えておられることを、直接あなたから聞くのがよいと思っています。この宗派については、至る所で非難があることを私たちは知っているからです。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","そこで、彼らは日を定めて、さらに大ぜいでパウロの宿にやって来た。彼は朝から晩まで語り続けた。神の国のことをあかしし、また、モーセの律法と預言者たちの書によって、イエスのことについて彼らを説得しようとした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ある人々は彼の語る事を信じたが、ある人々は信じようとしなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","こうして、彼らは、お互いの意見が一致せずに帰りかけたので、パウロは一言、次のように言った。「聖霊が預言者イザヤを通してあなたがたの先祖に語られたことは、まさにそのとおりでした。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","『この民のところに行って、告げよ。 あなたがたは確かに聞きはするが、 決して悟らない。 確かに見てはいるが、決してわからない。 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","この民の心は鈍くなり、 その耳は遠く、 その目はつぶっているからである。 それは、彼らがその目で見、 その耳で聞き、 その心で悟って、立ち返り、 わたしにいやされることのないためである。』 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ですから、承知しておいてください。神のこの救いは、異邦人に送られました。彼らは、耳を傾けるでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","30","こうしてパウロは満二年の間、自費で借りた家に住み、たずねて来る人たちをみな迎えて、 ");
INSERT INTO jpn1965_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","大胆に、少しも妨げられることなく、神の国を宣べ伝え、主イエス・キリストのことを教えた。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","神の福音のために選び分けられ、使徒として召されたキリスト・イエスのしもべパウロ、 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","――この福音は、神がその預言者たちを通して、聖書において前から約束されたもので、 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","御子に関することです。御子は、肉によればダビデの子孫として生まれ、 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","きよい御霊によれば、死者の中からの復活により、大能によって公に神の御子として示された方、私たちの主イエス・キリストです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","このキリストによって、私たちは恵みと使徒の務めを受けました。それは、御名のためにあらゆる国の人々の中に信仰の従順をもたらすためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","あなたがたも、それらの人々の中にあって、イエス・キリストによって召された人々です。――このパウロから、 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ローマにいるすべての、神に愛されている人々、召された聖徒たちへ。 私たちの父なる神と主イエス・キリストから恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","まず第一に、あなたがたすべてのために、私はイエス・キリストによって私の神に感謝します。それは、あなたがたの信仰が全世界に言い伝えられているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","私が御子の福音を宣べ伝えつつ霊をもって仕えている神があかししてくださることですが、私はあなたがたのことを思わぬ時はなく、 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","いつも祈りのたびごとに、神のみこころによって、何とかして、今度はついに道が開かれて、あなたがたのところに行けるようにと願っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","私があなたがたに会いたいと切に望むのは、御霊の賜物をいくらかでもあなたがたに分けて、あなたがたを強くしたいからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","というよりも、あなたがたの間にいて、あなたがたと私との互いの信仰によって、ともに励ましを受けたいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","兄弟たち。ぜひ知っておいていただきたい。私はあなたがたの中でも、ほかの国の人々の中で得たと同じように、いくらかの実を得ようと思って、何度もあなたがたのところに行こうとしたのですが、今なお妨げられているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","私は、ギリシヤ人にも未開人にも、知識のある人にも知識のない人にも、返さなければならない負債を負っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ですから、私としては、ローマにいるあなたがたにも、ぜひ福音を伝えたいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","私は福音を恥とは思いません。福音は、ユダヤ人をはじめギリシヤ人にも、信じるすべての人にとって、救いを得させる神の力です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","なぜなら、福音のうちには神の義が啓示されていて、その義は、信仰に始まり信仰に進ませるからです。「義人は信仰によって生きる。」と書いてあるとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","というのは、不義をもって真理をはばんでいる人々のあらゆる不敬虔と不正に対して、神の怒りが天から啓示されているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","なぜなら、神について知りうることは、彼らに明らかであるからです。それは神が明らかにされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","神の、目に見えない本性、すなわち神の永遠の力と神性は、世界の創造された時からこのかた、被造物によって知られ、はっきりと認められるのであって、彼らに弁解の余地はないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","というのは、彼らは、神を知っていながら、その神を神としてあがめず、感謝もせず、かえってその思いはむなしくなり、その無知な心は暗くなったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","彼らは、自分では知者であると言いながら、愚かな者となり、 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","不滅の神の御栄えを、滅ぶべき人間や、鳥、獣、はうもののかたちに似た物と代えてしまいました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","それゆえ、神は、彼らをその心の欲望のままに汚れに引き渡され、そのために彼らは、互いにそのからだをはずかしめるようになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","それは、彼らが神の真理を偽りと取り代え、造り主の代わりに造られた物を拝み、これに仕えたからです。造り主こそ、とこしえにほめたたえられる方です。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","こういうわけで、神は彼らを恥ずべき情欲に引き渡されました。すなわち、女は自然の用を不自然なものに代え、 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","同じように、男も、女の自然な用を捨てて男どうしで情欲に燃え、男が男と恥ずべきことを行なうようになり、こうしてその誤りに対する当然の報いを自分の身に受けているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","また、彼らが神を知ろうとしたがらないので、神は彼らを良くない思いに引き渡され、そのため彼らは、してはならないことをするようになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","彼らは、あらゆる不義と悪とむさぼりと悪意とに満ちた者、ねたみと殺意と争いと欺きと悪だくみとでいっぱいになった者、陰口を言う者、 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","そしる者、神を憎む者、人を人と思わぬ者、高ぶる者、大言壮語する者、悪事をたくらむ者、親に逆らう者、 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","わきまえのない者、約束を破る者、情け知らずの者、慈愛のない者です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","彼らは、そのようなことを行なえば、死罪に当たるという神の定めを知っていながら、それを行なっているだけでなく、それを行なう者に心から同意しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ですから、すべて他人をさばく人よ。あなたに弁解の余地はありません。あなたは、他人をさばくことによって、自分自身を罪に定めています。さばくあなたが、それと同じことを行なっているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","私たちは、そのようなことを行なっている人々に下る神のさばきが正しいことを知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","そのようなことをしている人々をさばきながら、自分で同じことをしている人よ。あなたは、自分は神のさばきを免れるのだとでも思っているのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","それとも、神の慈愛があなたを悔い改めに導くことも知らないで、その豊かな慈愛と忍耐と寛容とを軽んじているのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ところが、あなたは、かたくなさと悔い改めのない心のゆえに、御怒りの日、すなわち、神の正しいさばきの現われる日の御怒りを自分のために積み上げているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","神は、ひとりひとりに、その人の行ないに従って報いをお与えになります。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","忍耐をもって善を行ない、栄光と誉れと不滅のものとを求める者には、永遠のいのちを与え、 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","党派心を持ち、真理に従わないで不義に従う者には、怒りと憤りを下されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","患難と苦悩とは、ユダヤ人をはじめギリシヤ人にも、悪を行なうすべての者の上に下り、 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","栄光と誉れと平和は、ユダヤ人をはじめギリシヤ人にも、善を行なうすべての者の上にあります。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","神にはえこひいきなどはないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","律法なしに罪を犯した者はすべて、律法なしに滅び、律法の下にあって罪を犯した者はすべて、律法によってさばかれます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","それは、律法を聞く者が神の前に正しいのではなく、律法を行なう者が正しいと認められるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","――律法を持たない異邦人が、生まれつきのままで律法の命じる行ないをするばあいは、律法を持たなくても、自分自身が自分に対する律法なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","彼らはこのようにして、律法の命じる行ないが彼らの心に書かれていることを示しています。彼らの良心もいっしょになってあかしし、また、彼らの思いは互いに責め合ったり、また、弁明し合ったりしています。―― ");
INSERT INTO jpn1965_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","私の福音によれば、神のさばきは、神がキリスト・イエスによって人々の隠れたことをさばかれる日に、行なわれるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","もし、あなたが自分をユダヤ人ととなえ、律法を持つことに安んじ、神を誇り、 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","みこころを知り、なすべきことが何であるかを律法に教えられてわきまえ、 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","20","また、知識と真理の具体的な形として律法を持っているため、盲人の案内人、やみの中にいる者の光、愚かな者の導き手、幼子の教師だと自任しているのなら、 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","どうして、人を教えながら、自分自身を教えないのですか。盗むなと説きながら、自分は盗むのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","姦淫するなと言いながら、自分は姦淫するのですか。偶像を忌みきらいながら、自分は神殿の物をかすめるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","律法を誇りとしているあなたが、どうして律法に違反して、神を侮るのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","これは、「神の名は、あなたがたのゆえに、異邦人の中でけがされている。」と書いてあるとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","もし律法を守るなら、割礼には価値があります。しかし、もしあなたが律法にそむいているなら、あなたの割礼は、無割礼になったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","もし割礼を受けていない人が律法の規定を守るなら、割礼を受けていなくても、割礼を受けている者とみなされないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","また、からだに割礼を受けていないで律法を守る者が、律法の文字と割礼がありながら律法にそむいているあなたを、さばくことにならないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","外見上のユダヤ人がユダヤ人なのではなく、外見上のからだの割礼が割礼なのではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","かえって人目に隠れたユダヤ人がユダヤ人であり、文字ではなく、御霊による、心の割礼こそ割礼です。その誉れは、人からではなく、神から来るものです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","では、ユダヤ人のすぐれたところは、いったい何ですか。割礼にどんな益があるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","それは、あらゆる点から見て、大いにあります。第一に、彼らは神のいろいろなおことばをゆだねられています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","では、いったいどうなのですか。彼らのうちに不真実な者があったら、その不真実によって、神の真実が無に帰することになるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","絶対にそんなことはありません。たとい、すべての人を偽り者としても、神は真実な方であるとすべきです。それは、 「あなたが、そのみことばによって正しいとされ、さばかれるときには勝利を得られるため。」 と書いてあるとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","しかし、もし私たちの不義が神の義を明らかにするとしたら、どうなるでしょうか。人間的な言い方をしますが、怒りを下す神は不正なのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","絶対にそんなことはありません。もしそうだとしたら、神はいったいどのように世をさばかれるのでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","でも、私の偽りによって、神の真理がますます明らかにされて神の栄光となるのであれば、なぜ私がなお罪人としてさばかれるのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","「善を現わすために、悪をしようではないか。」と言ってはいけないのでしょうか。――私たちはこの点でそしられるのです。ある人たちは、それが私たちのことばだと言っていますが、――もちろんこのように論じる者どもは当然罪に定められるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","では、どうなのでしょう。私たちは他の者にまさっているのでしょうか。決してそうではありません。私たちは前に、ユダヤ人もギリシヤ人も、すべての人が罪の下にあると責めたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","それは、次のように書いてあるとおりです。 「義人はいない。ひとりもいない。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","悟りのある人はいない。神を求める人はいない。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","すべての人が迷い出て、 みな、ともに無益な者となった。 善を行なう人はいない。ひとりもいない。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","「彼らののどは、開いた墓であり、 彼らはその舌で欺く。」 「彼らのくちびるの下には、まむしの毒があり、」 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","「彼らの口は、のろいと苦さで満ちている。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","「彼らの足は血を流すのに速く、 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","彼らの道には破壊と悲惨がある。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","また、彼らは平和の道を知らない。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","「彼らの目の前には、神に対する恐れがない。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","さて、私たちは、律法の言うことはみな、律法の下にある人々に対して言われていることを知っています。それは、すべての口がふさがれて、全世界が神のさばきに服するためです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","なぜなら、律法を行なうことによっては、だれひとり神の前に義と認められないからです。律法によっては、かえって罪の意識が生じるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","しかし、今は、律法とは別に、しかも律法と預言者によってあかしされて、神の義が示されました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","すなわち、イエス・キリストを信じる信仰による神の義であって、それはすべての信じる人に与えられ、何の差別もありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","すべての人は、罪を犯したので、神からの栄誉を受けることができず、 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ただ、神の恵みにより、キリスト・イエスによる贖いのゆえに、価なしに義と認められるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","神は、キリスト・イエスを、その血による、また信仰による、なだめの供え物として、公にお示しになりました。それは、ご自身の義を現わすためです。というのは、今までに犯されて来た罪を神の忍耐をもって見のがして来られたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","それは、今の時にご自身の義を現わすためであり、こうして神ご自身が義であり、また、イエスを信じる者を義とお認めになるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","それでは、私たちの誇りはどこにあるのでしょうか。それはすでに取り除かれました。どういう原理によってでしょうか。行ないの原理によってでしょうか。そうではなく、信仰の原理によってです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","人が義と認められるのは、律法の行ないによるのではなく、信仰によるというのが、私たちの考えです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","それとも、神はユダヤ人だけの神でしょうか。異邦人にとっても神ではないのでしょうか。確かに神は、異邦人にとっても、神です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","神が唯一ならばそうです。この神は、割礼のある者を信仰によって義と認めてくださるとともに、割礼のない者をも、信仰によって義と認めてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","それでは、私たちは信仰によって律法を無効にすることになるのでしょうか。絶対にそんなことはありません。かえって、律法を確立することになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","それでは、肉による私たちの先祖アブラハムのばあいは、どうでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","もしアブラハムが行ないによって義と認められたのなら、彼は誇ることができます。しかし、神の御前では、そうではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","聖書は何と言っていますか。「それでアブラハムは神を信じた。それが彼の義とみなされた。」とあります。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","働く者のばあいに、その報酬は恵みでなくて、当然支払うべきものとみなされます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","何の働きもない者が、不敬虔な者を義と認めてくださる方を信じるなら、その信仰が義とみなされるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ダビデもまた、行ないとは別の道で神によって義と認められる人の幸いを、こう言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","「不法を赦され、罪をおおわれた人たちは、 幸いである。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","主が罪を認めない人は幸いである。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","それでは、この幸いは、割礼のある者にだけ与えられるのでしょうか。それとも、割礼のない者にも与えられるのでしょうか。私たちは、「アブラハムには、その信仰が義とみなされた。」と言っていますが、 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","どのようにして、その信仰が義とみなされたのでしょうか。割礼を受けてからでしょうか。まだ割礼を受けていないときにでしょうか。割礼を受けてからではなく、割礼を受けていないときにです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","彼は、割礼を受けていないとき信仰によって義と認められたことの証印として、割礼というしるしを受けたのです。それは、彼が、割礼を受けないままで信じて義と認められるすべての人の父となり、 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","また割礼のある者の父となるためです。すなわち、割礼を受けているだけではなく、私たちの父アブラハムが無割礼のときに持った信仰の足跡に従って歩む者の父となるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","というのは、世界の相続人となるという約束が、アブラハムに、あるいはまた、その子孫に与えられたのは、律法によってではなく、信仰の義によったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","もし律法による者が相続人であるとするなら、信仰はむなしくなり、約束は無効になってしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","律法は怒りを招くものであり、律法のないところには違反もありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","そのようなわけで、世界の相続人となることは、信仰によるのです。それは、恵みによるためであり、こうして約束がすべての子孫に、すなわち、律法を持っている人々にだけでなく、アブラハムの信仰にならう人々にも保証されるためなのです。「わたしは、あなたをあらゆる国の人々の父とした。」と書いてあるとおりに、アブラハムは私たちすべての者の父なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","このことは、彼が信じた神、すなわち死者を生かし、無いものを有るもののようにお呼びになる方の御前で、そうなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","彼は望みえないときに望みを抱いて信じました。それは、「あなたの子孫はこのようになる。」と言われていたとおりに、彼があらゆる国の人々の父となるためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","アブラハムは、およそ百歳になって、自分のからだが死んだも同然であることと、サラの胎の死んでいることとを認めても、その信仰は弱りませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","彼は、不信仰によって神の約束を疑うようなことをせず、反対に、信仰がますます強くなって、神に栄光を帰し、 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","神には約束されたことを成就する力があることを堅く信じました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","だからこそ、それが彼の義とみなされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","しかし、「彼の義とみなされた。」と書いてあるのは、ただ彼のためだけでなく、 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","また私たちのためです。すなわち、私たちの主イエスを死者の中からよみがえらせた方を信じる私たちも、その信仰を義とみなされるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","主イエスは、私たちの罪のために死に渡され、私たちが義と認められるために、よみがえられたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ですから、信仰によって義と認められた私たちは、私たちの主イエス・キリストによって、神との平和を持っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","またキリストによって、いま私たちの立っているこの恵みに信仰によって導き入れられた私たちは、神の栄光を望んで大いに喜んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","そればかりではなく、患難さえも喜んでいます。それは、患難が忍耐を生み出し、 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","忍耐が練られた品性を生み出し、練られた品性が希望を生み出すと知っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","この希望は失望に終わることがありません。なぜなら、私たちに与えられた聖霊によって、神の愛が私たちの心に注がれているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","私たちがまだ弱かったとき、キリストは定められた時に、不敬虔な者のために死んでくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","正しい人のためにでも死ぬ人はほとんどありません。情け深い人のためには、進んで死ぬ人があるいはいるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","しかし私たちがまだ罪人であったとき、キリストが私たちのために死んでくださったことにより、神は私たちに対するご自身の愛を明らかにしておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ですから、今すでにキリストの血によって義と認められた私たちが、彼によって神の怒りから救われるのは、なおさらのことです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","もし敵であった私たちが、御子の死によって神と和解させられたのなら、和解させられた私たちが、彼のいのちによって救いにあずかるのは、なおさらのことです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","そればかりでなく、私たちのために今や和解を成り立たせてくださった私たちの主イエス・キリストによって、私たちは神を大いに喜んでいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","そういうわけで、ちょうどひとりの人によって罪が世界にはいり、罪によって死がはいり、こうして死が全人類に広がったのと同様に、――それというのも全人類が罪を犯したからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","というのは、律法が与えられるまでの時期にも罪は世にあったからです。しかし罪は、何かの律法がなければ、認められないものです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ところが死は、アダムからモーセまでの間も、アダムの違反と同じようには罪を犯さなかった人々をさえ支配しました。アダムはきたるべき方のひな型です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ただし、恵みには違反のばあいとは違う点があります。もしひとりの違反によって多くの人が死んだとすれば、それにもまして、神の恵みとひとりの人イエス・キリストの恵みによる賜物とは、多くの人々に満ちあふれるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","また、賜物には、罪を犯したひとりによるばあいと違った点があります。さばきのばあいは、一つの違反のために罪に定められたのですが、恵みのばあいは、多くの違反が義と認められるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","もしひとりの人の違反により、ひとりによって死が支配するようになったとすれば、なおさらのこと、恵みと義の賜物とを豊かに受けている人々は、ひとりの人イエス・キリストにより、いのちにあって支配するのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","こういうわけで、ちょうど一つの違反によってすべての人が罪に定められたのと同様に、一つの義の行為によってすべての人が義と認められて、いのちを与えられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","すなわち、ちょうどひとりの人の不従順によって多くの人が罪人とされたのと同様に、ひとりの従順によって多くの人が義人とされるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","律法がはいって来たのは、違反が増し加わるためです。しかし、罪の増し加わるところには、恵みも満ちあふれました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","それは、罪が死によって支配したように、恵みが、私たちの主イエス・キリストにより、義の賜物によって支配し、永遠のいのちを得させるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","それでは、どういうことになりますか。恵みが増し加わるために、私たちは罪の中にとどまるべきでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","絶対にそんなことはありません。罪に対して死んだ私たちが、どうして、なおもその中に生きていられるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","それとも、あなたがたは知らないのですか。キリスト・イエスにつくバプテスマを受けた私たちはみな、その死にあずかるバプテスマを受けたのではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","私たちは、キリストの死にあずかるバプテスマによって、キリストとともに葬られたのです。それは、キリストが御父の栄光によって死者の中からよみがえられたように、私たちも、いのちにあって新しい歩みをするためです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","もし私たちが、キリストにつぎ合わされて、キリストの死と同じようになっているのなら、必ずキリストの復活とも同じようになるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","私たちの古い人がキリストとともに十字架につけられたのは、罪のからだが滅びて、私たちがもはやこれからは罪の奴隷でなくなるためであることを、私たちは知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","死んでしまった者は、罪から解放されているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","もし私たちがキリストとともに死んだのであれば、キリストとともに生きることにもなる、と信じます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","キリストは死者の中からよみがえって、もはや死ぬことはなく、死はもはやキリストを支配しないことを、私たちは知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","なぜなら、キリストが死なれたのは、ただ一度罪に対して死なれたのであり、キリストが生きておられるのは、神に対して生きておられるのだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","このように、あなたがたも、自分は罪に対しては死んだ者であり、神に対してはキリスト・イエスにあって生きた者だと、思いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ですから、あなたがたの死ぬべきからだを罪の支配にゆだねて、その情欲に従ってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","また、あなたがたの手足を不義の器として罪にささげてはいけません。むしろ、死者の中から生かされた者として、あなたがた自身とその手足を義の器として神にささげなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","というのは、罪はあなたがたを支配することがないからです。なぜなら、あなたがたは律法の下にはなく、恵みの下にあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","それではどうなのでしょう。私たちは、律法の下にではなく、恵みの下にあるのだから罪を犯そう、ということになるのでしょうか。絶対にそんなことはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","あなたがたはこのことを知らないのですか。あなたがたが自分の身をささげて奴隷として服従すれば、その服従する相手の奴隷であって、あるいは罪の奴隷となって死に至り、あるいは従順の奴隷となって義に至るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","神に感謝すべきことには、あなたがたは、もとは罪の奴隷でしたが、伝えられた教えの規準に心から服従し、 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","罪から解放されて、義の奴隷となったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","あなたがたにある肉の弱さのために、私は人間的な言い方をしています。あなたがたは、以前は自分の手足を汚れと不法の奴隷としてささげて、不法に進みましたが、今は、その手足を義の奴隷としてささげて、聖潔に進みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","罪の奴隷であった時は、あなたがたは義については、自由にふるまっていました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","その当時、今ではあなたがたが恥じているそのようなものから、何か良い実を得たでしょうか。それらのものの行き着く所は死です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","しかし今は、罪から解放されて神の奴隷となり、聖潔に至る実を得たのです。その行き着く所は永遠のいのちです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","罪から来る報酬は死です。しかし、神の下さる賜物は、私たちの主キリスト・イエスにある永遠のいのちです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","それとも、兄弟たち。あなたがたは、律法が人に対して権限を持つのは、その人の生きている期間だけだ、ということを知らないのですか。――私は律法を知っている人々に言っているのです。―― ");
INSERT INTO jpn1965_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","夫のある女は、夫が生きている間は、律法によって夫に結ばれています。しかし、夫が死ねば、夫に関する律法から解放されます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ですから、夫が生きている間に他の男に行けば、姦淫の女と呼ばれるのですが、夫が死ねば、律法から解放されており、たとい他の男に行っても、姦淫の女ではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","私の兄弟たちよ。それと同じように、あなたがたも、キリストのからだによって、律法に対しては死んでいるのです。それは、あなたがたが他の人、すなわち死者の中からよみがえった方と結ばれて、神のために実を結ぶようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","私たちが肉にあったときは、律法による数々の罪の欲情が私たちのからだの中に働いていて、死のために実を結びました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","しかし、今は、私たちは自分を捕えていた律法に対して死んだので、それから解放され、その結果、古い文字にはよらず、新しい御霊によって仕えているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","それでは、どういうことになりますか。律法は罪なのでしょうか。絶対にそんなことはありません。ただ、律法によらないでは、私は罪を知ることがなかったでしょう。律法が、「むさぼってはならない。」と言わなかったら、私はむさぼりを知らなかったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","しかし、罪はこの戒めによって機会を捕え、私のうちにあらゆるむさぼりを引き起こしました。律法がなければ、罪は死んだものです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","私はかつて律法なしに生きていましたが、戒めが来たときに、罪が生き、私は死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","それで私には、いのちに導くはずのこの戒めが、かえって死に導くものであることが、わかりました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","それは、戒めによって機会を捕えた罪が私を欺き、戒めによって私を殺したからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ですから、律法は聖なるものであり、戒めも聖であり、正しく、また良いものなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","では、この良いものが、私に死をもたらしたのでしょうか。絶対にそんなことはありません。それはむしろ、罪なのです。罪は、この良いもので私に死をもたらすことによって、罪として明らかにされ、戒めによって、極度に罪深いものとなりました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","私たちは、律法が霊的なものであることを知っています。しかし、私は罪ある人間であり、売られて罪の下にある者です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","私には、自分のしていることがわかりません。私は自分がしたいと思うことをしているのではなく、自分が憎むことを行なっているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","もし自分のしたくないことをしているとすれば、律法は良いものであることを認めているわけです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ですから、それを行なっているのは、もはや私ではなく、私のうちに住みついている罪なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","私は、私のうち、すなわち、私の肉のうちに善が住んでいないのを知っています。私には善をしたいという願いがいつもあるのに、それを実行することがないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","私は、自分でしたいと思う善を行なわないで、かえって、したくない悪を行なっています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","もし私が自分でしたくないことをしているのであれば、それを行なっているのは、もはや私ではなくて、私のうちに住む罪です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","そういうわけで、私は、善をしたいと願っているのですが、その私に悪が宿っているという原理を見いだすのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","すなわち、私は、内なる人としては、神の律法を喜んでいるのに、 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","私のからだの中には異なった律法があって、それが私の心の律法に対して戦いをいどみ、私を、からだの中にある罪の律法のとりこにしているのを見いだすのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","私は、ほんとうにみじめな人間です。だれがこの死の、からだから、私を救い出してくれるのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","私たちの主イエス・キリストのゆえに、ただ神に感謝します。ですから、この私は、心では神の律法に仕え、肉では罪の律法に仕えているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","こういうわけで、今は、キリスト・イエスにある者が罪に定められることは決してありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","なぜなら、キリスト・イエスにある、いのちの御霊の原理が、罪と死の原理から、あなたを解放したからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","肉によって無力になったため、律法にはできなくなっていることを、神はしてくださいました。神はご自分の御子を、罪のために、罪深い肉と同じような形でお遣わしになり、肉において罪を処罰されたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","それは、肉に従って歩まず、御霊に従って歩む私たちの中に、律法の要求が全うされるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","肉に従う者は肉的なことをもっぱら考えますが、御霊に従う者は御霊に属することをひたすら考えます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","肉の思いは死であり、御霊による思いは、いのちと平安です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","というのは、肉の思いは神に対して反抗するものだからです。それは神の律法に服従しません。いや、服従できないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","肉にある者は神を喜ばせることができません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","けれども、もし神の御霊があなたがたのうちに住んでおられるなら、あなたがたは肉の中にではなく、御霊の中にいるのです。キリストの御霊を持たない人は、キリストのものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","もしキリストがあなたがたのうちにおられるなら、からだは罪のゆえに死んでいても、霊が、義のゆえに生きています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","もしイエスを死者の中からよみがえらせた方の御霊が、あなたがたのうちに住んでおられるなら、キリスト・イエスを死者の中からよみがえらせた方は、あなたがたのうちに住んでおられる御霊によって、あなたがたの死ぬべきからだをも生かしてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ですから、兄弟たち。私たちは、肉に従って歩む責任を、肉に対して負ってはいません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","もし肉に従って生きるなら、あなたがたは死ぬのです。しかし、もし御霊によって、からだの行ないを殺すなら、あなたがたは生きるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","神の御霊に導かれる人は、だれでも神の子どもです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","あなたがたは、人を再び恐怖に陥れるような、奴隷の霊を受けたのではなく、子としてくださる御霊を受けたのです。私たちは御霊によって、「アバ、父。」と呼びます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","私たちが神の子どもであることは、御霊ご自身が、私たちの霊とともに、あかししてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","もし子どもであるなら、相続人でもあります。私たちがキリストと、栄光をともに受けるために苦難をともにしているなら、私たちは神の相続人であり、キリストとの共同相続人であります。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","今の時のいろいろの苦しみは、将来私たちに啓示されようとしている栄光に比べれば、取るに足りないものと私は考えます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","被造物も、切実な思いで神の子どもたちの現われを待ち望んでいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","それは、被造物が虚無に服したのが自分の意志ではなく、服従させた方によるのであって、望みがあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","被造物自体も、滅びの束縛から解放され、神の子どもたちの栄光の自由の中に入れられます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","私たちは、被造物全体が今に至るまで、ともにうめきともに産みの苦しみをしていることを知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","そればかりでなく、御霊の初穂をいただいている私たち自身も、心の中でうめきながら、子にしていただくこと、すなわち、私たちのからだの贖われることを待ち望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","私たちは、この望みによって救われているのです。目に見える望みは、望みではありません。だれでも目で見ていることを、どうしてさらに望むでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","もしまだ見ていないものを望んでいるのなら、私たちは、忍耐をもって熱心に待ちます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","御霊も同じようにして、弱い私たちを助けてくださいます。私たちは、どのように祈ったらよいかわからないのですが、御霊ご自身が、言いようもない深いうめきによって、私たちのためにとりなしてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","人間の心を探り窮める方は、御霊の思いが何かをよく知っておられます。なぜなら、御霊は、神のみこころに従って、聖徒のためにとりなしをしてくださるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","神を愛する人々、すなわち、神のご計画に従って召された人々のためには、神がすべてのことを働かせて益としてくださることを、私たちは知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","なぜなら、神は、あらかじめ知っておられる人々を、御子のかたちと同じ姿にあらかじめ定められたからです。それは、御子が多くの兄弟たちの中で長子となられるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","神はあらかじめ定めた人々をさらに召し、召した人々をさらに義と認め、義と認めた人々にはさらに栄光をお与えになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","では、これらのことからどう言えるでしょう。神が私たちの味方であるなら、だれが私たちに敵対できるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","私たちすべてのために、ご自分の御子をさえ惜しまずに死に渡された方が、どうして、御子といっしょにすべてのものを、私たちに恵んでくださらないことがありましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","神に選ばれた人々を訴えるのはだれですか。神が義と認めてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","罪に定めようとするのはだれですか。死んでくださった方、いや、よみがえられた方であるキリスト・イエスが、神の右の座に着き、私たちのためにとりなしていてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","私たちをキリストの愛から引き離すのはだれですか。患難ですか、苦しみですか、迫害ですか、飢えですか、裸ですか、危険ですか、剣ですか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","「あなたのために、私たちは一日中、 死に定められている。 私たちは、ほふられる羊とみなされた。」 と書いてあるとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","しかし、私たちは、私たちを愛してくださった方によって、これらすべてのことの中にあっても、圧倒的な勝利者となるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","私はこう確信しています。死も、いのちも、御使いも、権威ある者も、今あるものも、後に来るものも、力ある者も、 ");
INSERT INTO jpn1965_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","高さも、深さも、そのほかのどんな被造物も、私たちの主キリスト・イエスにある神の愛から、私たちを引き離すことはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","私はキリストにあって真実を言い、偽りを言いません。次のことは、私の良心も、聖霊によってあかししています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","私には大きな悲しみがあり、私の心には絶えず痛みがあります。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","もしできることなら、私の同胞、肉による同国人のために、この私がキリストから引き離されて、のろわれた者となることさえ願いたいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","彼らはイスラエル人です。子とされることも、栄光も、契約も、律法を与えられることも、礼拝も、約束も彼らのものです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","先祖たちも彼らのものです。またキリストも、人としては彼らから出られたのです。このキリストは万物の上にあり、とこしえにほめたたえられる神です。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","しかし、神のみことばが無効になったわけではありません。なぜなら、イスラエルから出る者がみな、イスラエルなのではなく、 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","アブラハムから出たからといって、すべてが子どもなのではなく、「イサクから出る者があなたの子孫と呼ばれる。」のだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","すなわち、肉の子どもがそのまま神の子どもではなく、約束の子どもが子孫とみなされるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","約束のみことばはこうです。「私は来年の今ごろ来ます。そして、サラは男の子を産みます。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","このことだけでなく、私たちの先祖イサクひとりによってみごもったリベカのこともあります。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","その子どもたちは、まだ生まれてもおらず、善も悪も行なわないうちに、神の選びの計画の確かさが、行ないにはよらず、召してくださる方によるようにと、 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","「兄は弟に仕える。」と彼女に告げられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","「わたしはヤコブを愛し、エサウを憎んだ。」と書いてあるとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","それでは、どういうことになりますか。神に不正があるのですか。絶対にそんなことはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","神はモーセに、「わたしは自分のあわれむ者をあわれみ、自分のいつくしむ者をいつくしむ。」と言われました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","したがって、事は人間の願いや努力によるのではなく、あわれんでくださる神によるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","聖書はパロに、「わたしがあなたを立てたのは、あなたにおいてわたしの力を示し、わたしの名を全世界に告げ知らせるためである。」と言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","こういうわけで、神は、人をみこころのままにあわれみ、またみこころのままにかたくなにされるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","すると、あなたはこう言うでしょう。「それなのになぜ、神は人を責められるのですか。だれが神のご計画に逆らうことができましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","しかし、人よ。神に言い逆らうあなたは、いったい何ですか。形造られた者が形造った者に対して、「あなたはなぜ、私をこのようなものにしたのですか。」と言えるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","陶器を作る者は、同じ土のかたまりから、尊いことに用いる器でも、また、つまらないことに用いる器でも作る権利を持っていないのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ですが、もし神が、怒りを示してご自分の力を知らせようと望んでおられるのに、その滅ぼされるべき怒りの器を、豊かな寛容をもって忍耐してくださったとしたら、どうでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","それも、神が栄光のためにあらかじめ用意しておられたあわれみの器に対して、その豊かな栄光を知らせてくださるためになのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","神は、このあわれみの器として、私たちを、ユダヤ人の中からだけでなく、異邦人の中からも召してくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","それは、ホセアの書でも言っておられるとおりです。 「わたしは、わが民でない者をわが民と呼び、 愛さなかった者を愛する者と呼ぶ。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","『あなたがたは、わたしの民ではない。』と、 わたしが言ったその場所で、彼らは、 生ける神の子どもと呼ばれる。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","また、イスラエルについては、イザヤがこう叫んでいます。 「たといイスラエルの子どもたちの数は、 海べの砂のようであっても、 救われるのは、残された者である。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","主は、みことばを完全に、しかも敏速に、 地上に成し遂げられる。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","また、イザヤがこう預言したとおりです。 「もし万軍の主が、私たちに 子孫を残されなかったら、 私たちはソドムのようになり、 ゴモラと同じものとされたであろう。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","では、どういうことになりますか。義を追い求めなかった異邦人は義を得ました。すなわち、信仰による義です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","しかし、イスラエルは、義の律法を追い求めながら、その律法に到達しませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","なぜでしょうか。信仰によって追い求めることをしないで、行ないによるかのように追い求めたからです。彼らは、つまずきの石につまずいたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","それは、こう書かれているとおりです。 「見よ。わたしは、 シオンに、つまずきの石、妨げの岩を置く。 彼に信頼する者は、 失望させられることがない。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","兄弟たち。私が心の望みとし、また彼らのために神に願い求めているのは、彼らの救われることです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","私は、彼らが神に対して熱心であることをあかしします。しかし、その熱心は知識に基づくものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","というのは、彼らは神の義を知らず、自分自身の義を立てようとして、神の義に従わなかったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","キリストが律法を終わらせられたので、信じる人はみな義と認められるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","モーセは、律法による義を行なう人は、その義によって生きる、と書いています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","しかし、信仰による義はこう言います。「あなたは心の中で、だれが天に上るだろうか、と言ってはいけない。」それはキリストを引き降ろすことです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","また、「だれが地の奥底に下るだろうか、と言ってはいけない。」それはキリストを死者の中から引き上げることです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","では、どう言っていますか。「みことばはあなたの近くにある。あなたの口にあり、あなたの心にある。」これは私たちの宣べ伝えている信仰のことばのことです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","なぜなら、もしあなたの口でイエスを主と告白し、あなたの心で神はイエスを死者の中からよみがえらせてくださったと信じるなら、あなたは救われるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","人は心に信じて義と認められ、口で告白して救われるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","聖書はこう言っています。「彼に信頼する者は、失望させられることがない。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ユダヤ人とギリシヤ人との区別はありません。同じ主が、すべての人の主であり、主を呼び求めるすべての人に対して恵み深くあられるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","「主の御名を呼び求める者は、だれでも救われる。」のです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","しかし、信じたことのない方を、どうして呼び求めることができるでしょう。聞いたことのない方を、どうして信じることができるでしょう。宣べ伝える人がなくて、どうして聞くことができるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","遣わされなくては、どうして宣べ伝えることができるでしょう。次のように書かれているとおりです。「良いことの知らせを伝える人々の足は、なんとりっぱでしょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","しかし、すべての人が福音に従ったのではありません。「主よ。だれが私たちの知らせを信じましたか。」とイザヤは言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","そのように、信仰は聞くことから始まり、聞くことは、キリストについてのみことばによるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","でも、こう尋ねましょう。「はたして彼らは聞こえなかったのでしょうか。」むろん、そうではありません。 「その声は全地に響き渡り、 そのことばは地の果てまで届いた。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","でも、私はこう言いましょう。「はたしてイスラエルは知らなかったのでしょうか。」まず、モーセがこう言っています。 「わたしは、民でない者のことで、 あなたがたのねたみを起こさせ、 無知な国民のことで、あなたがたを怒らせる。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","またイザヤは大胆にこう言っています。 「わたしは、わたしを求めない者に見いだされ、 わたしをたずねない者に自分を現わした。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","またイスラエルについては、こう言っています。 「不従順で反抗する民に対して、 わたしは一日中、手を差し伸べた。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","すると、神はご自分の民を退けてしまわれたのですか。絶対にそんなことはありません。この私もイスラエル人で、アブラハムの子孫に属し、ベニヤミン族の出身です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","神は、あらかじめ知っておられたご自分の民を退けてしまわれたのではありません。それともあなたがたは、聖書がエリヤに関する個所で言っていることを、知らないのですか。彼はイスラエルを神に訴えてこう言いました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","「主よ。彼らはあなたの預言者たちを殺し、あなたの祭壇をこわし、私だけが残されました。彼らはいま私のいのちを取ろうとしています。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ところが彼に対して何とお答えになりましたか。「バアルにひざをかがめていない男子七千人が、わたしのために残してある。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","それと同じように、今も、恵みの選びによって残された者がいます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","もし恵みによるのであれば、もはや行ないによるのではありません。もしそうでなかったら、恵みが恵みでなくなります。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","では、どうなるのでしょう。イスラエルは追い求めていたものを獲得できませんでした。選ばれた者は獲得しましたが、他の者は、かたくなにされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","こう書かれているとおりです。 「神は、彼らに鈍い心と 見えない目と聞こえない耳を与えられた。 今日に至るまで。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ダビデもこう言います。 「彼らの食卓は、彼らにとって わなとなり、網となり、 つまずきとなり、報いとなれ。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","その目はくらんで見えなくなり、 その背はいつまでもかがんでおれ。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","では、尋ねましょう。彼らがつまずいたのは倒れるためなのでしょうか。絶対にそんなことはありません。かえって、彼らの違反によって、救いが異邦人に及んだのです。それは、イスラエルにねたみを起こさせるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","もし彼らの違反が世界の富となり、彼らの失敗が異邦人の富となるのなら、彼らの完成は、それ以上の、どんなにかすばらしいものを、もたらすことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","そこで、異邦人の方々に言いますが、私は異邦人の使徒ですから、自分の務めを重んじています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","そして、それによって何とか私の同国人にねたみを引き起こさせて、その中の幾人でも救おうと願っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","もし彼らの捨てられることが世界の和解であるとしたら、彼らの受け入れられることは、死者の中から生き返ることでなくて何でしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","初物がきよければ、粉の全部がきよいのです。根がきよければ、枝もきよいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","もしも、枝の中のあるものが折られて、野生種のオリーブであるあなたがその枝に混じってつがれ、そしてオリーブの根の豊かな養分をともに受けているのだとしたら、 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","あなたはその枝に対して誇ってはいけません。誇ったとしても、あなたが根をささえているのではなく、根があなたをささえているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","枝が折られたのは、私がつぎ合わされるためだ、とあなたは言うでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","そのとおりです。彼らは不信仰によって折られ、あなたは信仰によって立っています。高ぶらないで、かえって恐れなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","もし神が台木の枝を惜しまれなかったとすれば、あなたをも惜しまれないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","見てごらんなさい。神のいつくしみときびしさを。倒れた者の上にあるのは、きびしさです。あなたの上にあるのは、神のいつくしみです。ただし、あなたがそのいつくしみの中にとどまっていればであって、そうでなければ、あなたも切り落とされるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","彼らであっても、もし不信仰を続けなければ、つぎ合わされるのです。神は、彼らを再びつぎ合わすことができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","もしあなたが、野生種であるオリーブの木から切り取られ、もとの性質に反して、栽培されたオリーブの木につがれたのであれば、これらの栽培種のものは、もっとたやすく自分の台木につがれるはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","兄弟たち。私はあなたがたに、ぜひこの奥義を知っていていただきたい。それは、あなたがたが自分で自分を賢いと思うことがないようにするためです。その奥義とは、イスラエル人の一部がかたくなになったのは異邦人の完成のなる時までであり、 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","こうして、イスラエルはみな救われる、ということです。こう書かれているとおりです。 「救う者がシオンから出て、 ヤコブから不敬虔を取り払う。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","これこそ、彼らに与えたわたしの契約である。 それは、わたしが彼らの罪を取り除く時である。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","彼らは、福音によれば、あなたがたのゆえに、神に敵対している者ですが、選びによれば、先祖たちのゆえに、愛されている者なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","神の賜物と召命とは変わることがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ちょうどあなたがたが、かつては神に不従順であったが、今は、彼らの不従順のゆえに、あわれみを受けているのと同様に、 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","彼らも、今は不従順になっていますが、それは、あなたがたの受けたあわれみによって、今や、彼ら自身もあわれみを受けるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","なぜなら、神は、すべての人をあわれもうとして、すべての人を不従順のうちに閉じ込められたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ああ、神の知恵と知識との富は、何と底知れず深いことでしょう。そのさばきは、何と知り尽くしがたく、その道は、何と測り知りがたいことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","なぜなら、だれが主のみこころを知ったのですか。また、だれが主のご計画にあずかったのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","また、だれが、まず主に与えて報いを受けるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","というのは、すべてのことが、神から発し、神によって成り、神に至るからです。どうか、この神に、栄光がとこしえにありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","そういうわけですから、兄弟たち。私は、神のあわれみのゆえに、あなたがたにお願いします。あなたがたのからだを、神に受け入れられる、きよい、生きた供え物としてささげなさい。それこそ、あなたがたの霊的な礼拝です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","この世と調子を合わせてはいけません。いや、むしろ、神のみこころは何か、すなわち、何が良いことで、神に受け入れられ、完全であるのかをわきまえ知るために、心の一新によって自分を変えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","私は、自分に与えられた恵みによって、あなたがたひとりひとりに言います。だれでも、思うべき限度を越えて思い上がってはいけません。いや、むしろ、神がおのおのに分け与えてくださった信仰の量りに応じて、慎み深い考え方をしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","一つのからだには多くの器官があって、すべての器官が同じ働きはしないのと同じように、 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","大ぜいいる私たちも、キリストにあって一つのからだであり、ひとりひとり互いに器官なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","私たちは、与えられた恵みに従って、異なった賜物を持っているので、もしそれが預言であれば、その信仰に応じて預言しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","奉仕であれば奉仕し、教える人であれば教えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","勧めをする人であれば勧め、分け与える人は惜しまずに分け与え、指導する人は熱心に指導し、慈善を行なう人は喜んでそれをしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","愛には偽りがあってはなりません。悪を憎み、善に親しみなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","兄弟愛をもって心から互いに愛し合い、尊敬をもって互いに人を自分よりまさっていると思いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","勤勉で怠らず、霊に燃え、主に仕えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","望みを抱いて喜び、患難に耐え、絶えず祈りに励みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","聖徒の入用に協力し、旅人をもてなしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","あなたがたを迫害する者を祝福しなさい。祝福すべきであって、のろってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","喜ぶ者といっしょに喜び、泣く者といっしょに泣きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","互いに一つ心になり、高ぶった思いを持たず、かえって身分の低い者に順応しなさい。自分こそ知者だなどと思ってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","だれに対してでも、悪に悪を報いることをせず、すべての人が良いと思うことを図りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","あなたがたは、自分に関する限り、すべての人と平和を保ちなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","愛する人たち。自分で復讐してはいけません。神の怒りに任せなさい。それは、こう書いてあるからです。「復讐はわたしのすることである。わたしが報いをする、と主は言われる。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","もしあなたの敵が飢えたなら、彼に食べさせなさい。渇いたなら、飲ませなさい。そうすることによって、あなたは彼の頭に燃える炭火を積むことになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","悪に負けてはいけません。かえって、善をもって悪に打ち勝ちなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","人はみな、上に立つ権威に従うべきです。神によらない権威はなく、存在している権威はすべて、神によって立てられたものです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","したがって、権威に逆らっている人は、神の定めにそむいているのです。そむいた人は自分の身にさばきを招きます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","支配者を恐ろしいと思うのは、良い行ないをするときではなく、悪を行なうときです。権威を恐れたくないと思うなら、善を行ないなさい。そうすれば、支配者からほめられます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","それは、彼があなたに益を与えるための、神のしもべだからです。しかし、もしあなたが悪を行なうなら、恐れなければなりません。彼は無意味に剣を帯びてはいないからです。彼は神のしもべであって、悪を行なう人には怒りをもって報います。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ですから、ただ怒りが恐ろしいからだけでなく、良心のためにも、従うべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","同じ理由で、あなたがたは、みつぎを納めるのです。彼らは、いつもその務めに励んでいる神のしもべなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","あなたがたは、だれにでも義務を果たしなさい。みつぎを納めなければならない人にはみつぎを納め、税を納めなければならない人には税を納め、恐れなければならない人を恐れ、敬わなければならない人を敬いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","だれに対しても、何の借りもあってはいけません。ただし、互いに愛し合うことについては別です。他の人を愛する者は、律法を完全に守っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","「姦淫するな、殺すな、盗むな、むさぼるな。」という戒め、またほかにどんな戒めがあっても、それらは、「あなたの隣人をあなた自身のように愛せよ。」ということばの中に要約されているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","愛は隣人に対して害を与えません。それゆえ、愛は律法を全うします。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","あなたがたは、今がどのような時か知っているのですから、このように行ないなさい。あなたがたが眠りからさめるべき時刻がもう来ています。というのは、私たちが信じたころよりも、今は救いが私たちにもっと近づいているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","夜はふけて、昼が近づきました。ですから、私たちは、やみのわざを打ち捨てて、光の武具を着けようではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","遊興、酩酊、淫乱、好色、争い、ねたみの生活ではなく、昼間らしい、正しい生き方をしようではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","主イエス・キリストを着なさい。肉の欲のために心を用いてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","あなたがたは信仰の弱い人を受け入れなさい。その意見をさばいてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","何でも食べてよいと信じている人もいますが、弱い人は野菜よりほかには食べません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","食べる人は食べない人を侮ってはいけないし、食べない人も食べる人をさばいてはいけません。神がその人を受け入れてくださったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","あなたはいったいだれなので、他人のしもべをさばくのですか。しもべが立つのも倒れるのも、その主人の心次第です。このしもべは立つのです。なぜなら、主には、彼を立たせることができるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ある日を、他の日に比べて、大事だと考える人もいますが、どの日も同じだと考える人もいます。それぞれ自分の心の中で確信を持ちなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","日を守る人は、主のために守っています。食べる人は、主のために食べています。なぜなら、神に感謝しているからです。食べない人も、主のために食べないのであって、神に感謝しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","私たちの中でだれひとりとして、自分のために生きている者はなく、また自分のために死ぬ者もありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","もし生きるなら、主のために生き、もし死ぬなら、主のために死ぬのです。ですから、生きるにしても、死ぬにしても、私たちは主のものです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","キリストは、死んだ人にとっても、生きている人にとっても、その主となるために、死んで、また生きられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","それなのに、なぜ、あなたは自分の兄弟をさばくのですか。また、自分の兄弟を侮るのですか。私たちはみな、神のさばきの座に立つようになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","次のように書かれているからです。 「主は言われる。わたしは生きている。 すべてのひざは、わたしの前にひざまずき、 すべての舌は、神をほめたたえる。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","こういうわけですから、私たちは、おのおの自分のことを神の御前に申し開きすることになります。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ですから、私たちは、もはや互いにさばき合うことのないようにしましょう。いや、それ以上に、兄弟にとって妨げになるもの、つまずきになるものを置かないように決心しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","主イエスにあって、私が知り、また確信していることは、それ自体で汚れているものは何一つないということです。ただ、これは汚れていると認める人にとっては、それは汚れたものなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","もし、食べ物のことで、あなたの兄弟が心を痛めているのなら、あなたはもはや愛によって行動しているのではありません。キリストが代わりに死んでくださったほどの人を、あなたの食べ物のことで、滅ぼさないでください。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ですから、あなたがたが良いとしている事がらによって、そしられないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","なぜなら、神の国は飲み食いのことではなく、義と平和と聖霊による喜びだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","このようにキリストに仕える人は、神に喜ばれ、また人々にも認められるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","そういうわけですから、私たちは、平和に役立つことと、お互いの霊的成長に役立つこととを追い求めましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","食べ物のことで神のみわざを破壊してはいけません。すべての物はきよいのです。しかし、それを食べて人につまずきを与えるような人のばあいは、悪いのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","肉を食べず、ぶどう酒を飲まず、そのほか兄弟のつまずきになることをしないのは良いことなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","あなたの持っている信仰は、神の御前でそれを自分の信仰として保ちなさい。自分が、良いと認めていることによって、さばかれない人は幸福です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","しかし、疑いを感じる人が食べるなら、罪に定められます。なぜなら、それが信仰から出ていないからです。信仰から出ていないことは、みな罪です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","私たち力のある者は、力のない人たちの弱さをになうべきです。自分を喜ばせるべきではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","私たちはひとりひとり、隣人を喜ばせ、その徳を高め、その人の益となるようにすべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","キリストでさえ、ご自身を喜ばせることはなさらなかったのです。むしろ、「あなたをそしる人々のそしりは、わたしの上にふりかかった。」と書いてあるとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","昔書かれたものは、すべて私たちを教えるために書かれたのです。それは、聖書の与える忍耐と励ましによって、希望を持たせるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","どうか、忍耐と励ましの神が、あなたがたを、キリスト・イエスにふさわしく、互いに同じ思いを持つようにしてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","それは、あなたがたが、心を一つにし、声を合わせて、私たちの主イエス・キリストの父なる神をほめたたえるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","こういうわけですから、キリストが神の栄光のために、私たちを受け入れてくださったように、あなたがたも互いに受け入れなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","私は言います。キリストは、神の真理を現わすために、割礼のある者のしもべとなられました。それは先祖たちに与えられた約束を保証するためであり、 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","また異邦人も、あわれみのゆえに、神をあがめるようになるためです。こう書かれているとおりです。 「それゆえ、私は異邦人の中で、 あなたをほめたたえ、 あなたの御名をほめ歌おう。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","また、こうも言われています。 「異邦人よ。主の民とともに喜べ。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","さらにまた、 「すべての異邦人よ。主をほめよ。 もろもろの国民よ。主をたたえよ。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","さらにまた、イザヤがこう言っています。 「エッサイの根が起こる。 異邦人を治めるために立ち上がる方である。 異邦人はこの方に望みをかける。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","どうか、望みの神が、あなたがたを信仰によるすべての喜びと平和をもって満たし、聖霊の力によって望みにあふれさせてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","私の兄弟たちよ。あなたがた自身が善意にあふれ、すべての知恵に満たされ、また互いに訓戒し合うことができることを、この私は確信しています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ただ私が所々、かなり大胆に書いたのは、あなたがたにもう一度思い起こしてもらうためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","それも私が、異邦人のためにキリスト・イエスの仕え人となるために、神から恵みをいただいているからです。私は神の福音をもって、祭司の務めを果たしています。それは異邦人を、聖霊によってきよめられた、神に受け入れられる供え物とするためです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","それで、神に仕えることに関して、私はキリスト・イエスにあって誇りを持っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","私は、キリストが異邦人を従順にならせるため、この私を用いて成し遂げてくださったこと以外に、何かを話そうなどとはしません。キリストは、ことばと行ないにより、 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","また、しるしと不思議をなす力により、さらにまた、御霊の力によって、それを成し遂げてくださいました。その結果、私はエルサレムから始めて、ずっと回ってイルリコに至るまで、キリストの福音をくまなく伝えました。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","このように、私は、他人の土台の上に建てないように、キリストの御名がまだ語られていない所に福音を宣べ伝えることを切に求めたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","それは、こう書いてあるとおりです。 「彼のことを伝えられなかった人々が 見るようになり、 聞いたことのなかった人々が 悟るようになる。」 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","そういうわけで、私は、あなたがたのところに行くのを幾度も妨げられましたが、 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","今は、もうこの地方には私の働くべき所がなくなりましたし、また、イスパニヤに行くばあいは、あなたがたのところに立ち寄ることを多年希望していましたので、 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","――というのは、途中あなたがたに会い、まず、しばらくの間あなたがたとともにいて心を満たされてから、あなたがたに送られ、そこへ行きたいと望んでいるからです。―― ");
INSERT INTO jpn1965_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ですが、今は、聖徒たちに奉仕するためにエルサレムへ行こうとしています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","それは、マケドニヤとアカヤでは、喜んでエルサレムの聖徒たちの中の貧しい人たちのために醵金することにしたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","彼らは確かに喜んでそれをしたのですが、同時にまた、その人々に対してはその義務があるのです。異邦人は霊的なことでは、その人々からもらいものをしたのですから、物質的な物をもって彼らに奉仕すべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","それで、私はこのことを済ませ、彼らにこの実を確かに渡してから、あなたがたのところを通ってイスパニヤに行くことにします。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","あなたがたのところに行くときは、キリストの満ちあふれる祝福をもって行くことと信じています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","兄弟たち。私たちの主イエス・キリストによって、また、御霊の愛によって切にお願いします。私のために、私とともに力を尽くして神に祈ってください。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","私がユダヤにいる不信仰な人々から救い出され、またエルサレムに対する私の奉仕が聖徒たちに受け入れられるものとなりますように。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","その結果として、神のみこころにより、喜びをもってあなたがたのところへ行き、あなたがたの中で、ともにいこいを得ることができますように。 ");
INSERT INTO jpn1965_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","どうか、平和の神が、あなたがたすべてとともにいてくださいますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ケンクレヤにある教会の執事で、私たちの姉妹であるフィベを、あなたがたに推薦します。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","どうぞ、聖徒にふさわしいしかたで、主にあってこの人を歓迎し、あなたがたの助けを必要とすることは、どんなことでも助けてあげてください。この人は、多くの人を助け、また私自身をも助けてくれた人です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","キリスト・イエスにあって私の同労者であるプリスカとアクラによろしく伝えてください。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","この人たちは、自分のいのちの危険を冒して私のいのちを守ってくれたのです。この人たちには、私だけでなく、異邦人のすべての教会も感謝しています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","またその家の教会によろしく伝えてください。私の愛するエパネトによろしく。この人はアジヤでキリストを信じた最初の人です。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","あなたがたのために非常に労苦したマリヤによろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","私の同国人で私といっしょに投獄されたことのある、アンドロニコとユニアスにもよろしく。この人々は使徒たちの間によく知られている人々で、また私より先にキリストにある者となったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","主にあって私の愛するアムプリアトによろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","キリストにあって私たちの同労者であるウルバノと、私の愛するスタキスとによろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","キリストにあって練達したアペレによろしく。アリストブロの家の人たちによろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","私の同国人ヘロデオンによろしく。ナルキソの家の主にある人たちによろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","主にあって労している、ツルパナとツルポサによろしく。主にあって非常に労苦した愛するペルシスによろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","主にあって選ばれた人ルポスによろしく。また彼と私との母によろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","アスンクリト、フレゴン、ヘルメス、パトロバ、ヘルマスおよびその人たちといっしょにいる兄弟たちによろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","フィロロゴとユリヤ、ネレオとその姉妹、オルンパおよびその人たちといっしょにいるすべての聖徒たちによろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","あなたがたはきよい口づけをもって互いのあいさつをかわしなさい。キリストの教会はみな、あなたがたによろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","兄弟たち。私はあなたがたに願います。あなたがたの学んだ教えにそむいて、分裂とつまずきを引き起こす人たちを警戒してください。彼らから遠ざかりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","そういう人たちは、私たちの主キリストに仕えないで、自分の欲に仕えているのです。彼らは、なめらかなことば、へつらいのことばをもって純朴な人たちの心をだましているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","あなたがたの従順はすべての人に知られているので、私はあなたがたのことを喜んでいます。しかし、私は、あなたがたが善にはさとく、悪にはうとくあってほしい、と望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","平和の神は、すみやかに、あなたがたの足でサタンを踏み砕いてくださいます。 どうか、私たちの主イエスの恵みが、あなたがたとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","私の同労者テモテが、あなたがたによろしくと言っています。また私の同国人ルキオとヤソンとソシパテロがよろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","この手紙を筆記した私、テルテオも、主にあってあなたがたにごあいさつ申し上げます。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","私と全教会との家主であるガイオも、あなたがたによろしくと言っています。市の収入役であるエラストと兄弟クワルトもよろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","26","私の福音とイエス・キリストの宣教によって、すなわち、世々にわたって長い間隠されていたが、今や現わされて、永遠の神の命令に従い、預言者たちの書によって、信仰の従順に導くためにあらゆる国の人々に知らされた奥義の啓示によって、あなたがたを堅く立たせることができる方、 ");
INSERT INTO jpn1965_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","知恵に富む唯一の神に、イエス・キリストによって、御栄えがとこしえまでありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","神のみこころによってキリスト・イエスの使徒として召されたパウロと、兄弟ソステネから、 ");
INSERT INTO jpn1965_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","コリントにある神の教会へ。すなわち、私たちの主イエス・キリストの御名を、至る所で呼び求めているすべての人々とともに、聖徒として召され、キリスト・イエスにあってきよめられた方々へ。主は私たちの主であるとともに、そのすべての人々の主です。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","私たちの父なる神と主イエス・キリストから、恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","私は、キリスト・イエスによってあなたがたに与えられた神の恵みのゆえに、あなたがたのことをいつも神に感謝しています。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","というのは、あなたがたは、ことばといい、知識といい、すべてにおいて、キリストにあって豊かな者とされたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","それは、キリストについてのあかしが、あなたがたの中で確かになったからで、 ");
INSERT INTO jpn1965_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","その結果、あなたがたはどんな賜物にも欠けるところがなく、また、熱心に私たちの主イエス・キリストの現われを待っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","主も、あなたがたを、私たちの主イエス・キリストの日に責められるところのない者として、最後まで堅く保ってくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","神は真実であり、その方のお召しによって、あなたがたは神の御子、私たちの主イエス・キリストとの交わりに入れられました。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","さて、兄弟たち。私は、私たちの主イエス・キリストの御名によって、あなたがたにお願いします。どうか、みなが一致して、仲間割れすることなく、同じ心、同じ判断を完全に保ってください。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","実はあなたがたのことをクロエの家の者から知らされました。兄弟たち。あなたがたの間には争いがあるそうで、 ");
INSERT INTO jpn1965_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","あなたがたはめいめいに、「私はパウロにつく。」「私はアポロに。」「私はケパに。」「私はキリストにつく。」と言っているということです。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","キリストが分割されたのですか。あなたがたのために十字架につけられたのはパウロでしょうか。あなたがたがバプテスマを受けたのはパウロの名によるのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","私は、クリスポとガイオのほか、あなたがたのだれにもバプテスマを授けたことがないことを感謝しています。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","それは、あなたがたが私の名によってバプテスマを受けたと言われないようにするためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","私はステパナの家族にもバプテスマを授けましたが、そのほかはだれにも授けた覚えはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","キリストが私をお遣わしになったのは、バプテスマを授けさせるためではなく、福音を宣べ伝えさせるためです。それも、キリストの十字架がむなしくならないために、ことばの知恵によってはならないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","十字架のことばは、滅びに至る人々には愚かであっても、救いを受ける私たちには、神の力です。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","それは、こう書いてあるからです。 「わたしは知恵ある者の知恵を滅ぼし、 賢い者の賢さをむなしくする。」 ");
INSERT INTO jpn1965_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","知者はどこにいるのですか。学者はどこにいるのですか。この世の議論家はどこにいるのですか。神は、この世の知恵を愚かなものにされたではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","事実、この世が自分の知恵によって神を知ることがないのは、神の知恵によるのです。それゆえ、神はみこころによって、宣教のことばの愚かさを通して、信じる者を救おうと定められたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ユダヤ人はしるしを要求し、ギリシヤ人は知恵を追求します。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","しかし、私たちは十字架につけられたキリストを宣べ伝えるのです。ユダヤ人にとってはつまずき、異邦人にとっては愚かでしょうが、 ");
INSERT INTO jpn1965_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","しかし、ユダヤ人であってもギリシヤ人であっても、召された者にとっては、キリストは神の力、神の知恵なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","なぜなら、神の愚かさは人よりも賢く、神の弱さは人よりも強いからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","兄弟たち、あなたがたの召しのことを考えてごらんなさい。この世の知者は多くはなく、権力者も多くはなく、身分の高い者も多くはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","しかし神は、知恵ある者をはずかしめるために、この世の愚かな者を選び、強い者をはずかしめるために、この世の弱い者を選ばれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","また、この世の取るに足りない者や見下されている者を、神は選ばれました。すなわち、有るものをない者のようにするため、無に等しいものを選ばれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","これは、神の御前でだれをも誇らせないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","しかしあなたがたは、神によってキリスト・イエスのうちにあるのです。キリストは、私たちにとって、神の知恵となり、また、義ときよめと、贖いとになられました。 ");
INSERT INTO jpn1965_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","まさしく、「誇る者は主にあって誇れ。」と書かれているとおりになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","さて兄弟たち。私があなたがたのところへ行ったとき、私は、すぐれたことば、すぐれた知恵を用いて、神のあかしを宣べ伝えることはしませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","なぜなら私は、あなたがたの間で、イエス・キリスト、すなわち十字架につけられた方のほかは、何も知らないことに決心したからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","あなたがたといっしょにいたときの私は、弱く、恐れおののいていました。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","そして、私のことばと私の宣教とは、説得力のある知恵のことばによって行なわれたものではなく、御霊と御力の現われでした。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","それは、あなたがたの持つ信仰が、人間の知恵にささえられず、神の力にささえられるためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","しかし私たちは、成人の間で、知恵を語ります。この知恵は、この世の知恵でもなく、この世の過ぎ去って行く支配者たちの知恵でもありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","私たちの語るのは、隠された奥義としての神の知恵であって、それは、神が、私たちの栄光のために、世界の始まる前から、あらかじめ定められたものです。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","この知恵を、この世の支配者たちは、だれひとりとして悟りませんでした。もし悟っていたら、栄光の主を十字架につけはしなかったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","まさしく、聖書に書いてあるとおりです。 「目が見たことのないもの、 耳が聞いたことのないもの、 そして、人の心に思い浮かんだことのないもの。 神を愛する者のために、 神の備えてくださったものは、みなそうである。」 ");
INSERT INTO jpn1965_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","神はこれを、御霊によって私たちに啓示されたのです。御霊はすべてのことを探り、神の深みにまで及ばれるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","いったい、人の心のことは、その人のうちにある霊のほかに、だれが知っているでしょう。同じように、神のみこころのことは、神の御霊のほかにはだれも知りません。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ところで、私たちは、この世の霊を受けたのではなく、神の御霊を受けました。それは、恵みによって神から私たちに賜わったものを、私たちが知るためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","この賜物について話すには、人の知恵に教えられたことばを用いず、御霊に教えられたことばを用います。その御霊のことばをもって御霊のことを解くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","生まれながらの人間は、神の御霊に属することを受け入れません。それらは彼には愚かなことだからです。また、それを悟ることができません。なぜなら、御霊のことは御霊によってわきまえるものだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","御霊を受けている人は、すべてのことをわきまえますが、自分はだれによってもわきまえられません。 ");
INSERT INTO jpn1965_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","いったい、「だれが主のみこころを知り、主を導くことができたか。」ところが、私たちには、キリストの心があるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","さて、兄弟たちよ。私は、あなたがたに向かって、御霊に属する人に対するようには話すことができないで、肉に属する人、キリストにある幼子に対するように話しました。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","私はあなたがたには乳を与えて、堅い食物を与えませんでした。あなたがたには、まだ無理だったからです。実は、今でもまだ無理なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","あなたがたは、まだ肉に属しているからです。あなたがたの間にねたみや争いがあることからすれば、あなたがたは肉に属しているのではありませんか。そして、ただの人のように歩んでいるのではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ある人が、「私はパウロにつく。」と言えば、別の人は、「私はアポロに。」と言う。そういうことでは、あなたがたは、ただの人たちではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","アポロとは何でしょう。パウロとは何でしょう。あなたがたが信仰にはいるために用いられたしもべであって、主がおのおのに授けられたとおりのことをしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","私が植えて、アポロが水を注ぎました。しかし、成長させたのは神です。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","それで、たいせつなのは、植える者でも水を注ぐ者でもありません。成長させてくださる神なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","植える者と水を注ぐ者は、一つですが、それぞれ自分自身の働きに従って自分自身の報酬を受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","私たちは神の協力者であり、あなたがたは神の畑、神の建物です。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","与えられた神の恵みによって、私は賢い建築家のように、土台を据えました。そして、ほかの人がその上に家を建てています。しかし、どのように建てるかについてはそれぞれが注意しなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","というのは、だれも、すでに据えられている土台のほかに、ほかの物を据えることはできないからです。その土台とはイエス・キリストです。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","もし、だれかがこの土台の上に、金、銀、宝石、木、草、わらなどで建てるなら、 ");
INSERT INTO jpn1965_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","各人の働きは明瞭になります。その日がそれを明らかにするのです。というのは、その日は火とともに現われ、この火がその力で各人の働きの真価をためすからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","もしだれかの建てた建物が残れば、その人は報いを受けます。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","もしだれかの建てた建物が焼ければ、その人は損害を受けますが、自分自身は、火の中をくぐるようにして助かります。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","あなたがたは神の神殿であり、神の御霊があなたがたに宿っておられることを知らないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","もし、だれかが神の神殿をこわすなら、神がその人を滅ぼされます。神の神殿は聖なるものだからです。あなたがたがその神殿です。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","だれも自分を欺いてはいけません。もしあなたがたの中で、自分は今の世の知者だと思う者がいたら、知者になるためには愚かになりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","なぜなら、この世の知恵は、神の御前では愚かだからです。こう書いてあります。「神は、知者どもを彼らの悪賢さの中で捕える。」 ");
INSERT INTO jpn1965_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","また、次のようにも書いてあります。「主は、知者の論議を無益だと知っておられる。」 ");
INSERT INTO jpn1965_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ですから、だれも人間を誇ってはいけません。すべては、あなたがたのものです。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","パウロであれ、アポロであれ、ケパであれ、また世界であれ、いのちであれ、死であれ、また現在のものであれ、未来のものであれ、すべてあなたがたのものです。 ");
INSERT INTO jpn1965_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","そして、あなたがたはキリストのものであり、キリストは神のものです。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","こういうわけで、私たちを、キリストのしもべ、また神の奥義の管理者だと考えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","このばあい、管理者には、忠実であることが要求されます。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","しかし、私にとっては、あなたがたによる判定、あるいは、およそ人間による判決を受けることは、非常に小さなことです。事実、私は自分で自分をさばくことさえしません。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","私にはやましいことは少しもありませんが、だからといって、それで無罪とされるのではありません。私をさばく方は主です。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ですから、あなたがたは、主が来られるまでは、何についても、先走ったさばきをしてはいけません。主は、やみの中に隠れた事も明るみに出し、心の中のはかりごとも明らかにされます。そのとき、神から各人に対する称賛が届くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","さて、兄弟たち。以上、私は、私自身とアポロに当てはめて、あなたがたのために言って来ました。それは、あなたがたが、私たちの例によって、「書かれていることを越えない。」ことを学ぶため、そして、一方にくみし、他方に反対して高慢にならないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","いったいだれが、あなたをすぐれた者と認めるのですか。あなたには、何か、もらったものでないものがあるのですか。もしもらったのなら、なぜ、もらっていないかのように誇るのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","あなたがたは、もう満ち足りています。もう豊かになっています。私たち抜きで、王さまになっています。いっそのこと、あなたがたがほんとうに王さまになっていたらよかったのです。そうすれば、私たちも、あなたがたといっしょに王になれたでしょうに。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","私は、こう思います。神は私たち使徒を、死罪に決まった者のように、行列のしんがりとして引き出されました。こうして私たちは、御使いにも人々にも、この世の見せ物になったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","私たちはキリストのために愚かな者ですが、あなたがたはキリストにあって賢い者です。私たちは弱いが、あなたがたは強いのです。あなたがたは栄誉を持っているが、私たちは卑しめられています。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","今に至るまで、私たちは飢え、渇き、着る物もなく、虐待され、落ち着く先もありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","また、私たちは苦労して自分の手で働いています。はずかしめられるときにも祝福し、迫害されるときにも耐え忍び、 ");
INSERT INTO jpn1965_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ののしられるときには、慰めのことばをかけます。今でも、私たちはこの世のちり、あらゆるもののかすです。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","私がこう書くのは、あなたがたをはずかしめるためではなく、愛する私の子どもとして、さとすためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","たといあなたがたに、キリストにある養育係が一万人あろうとも、父は多くあるはずがありません。この私が福音によって、キリスト・イエスにあって、あなたがたを生んだのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ですから、私はあなたがたに勧めます。どうか、私にならう者となってください。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","そのために、私はあなたがたのところへテモテを送りました。テモテは主にあって私の愛する、忠実な子です。彼は、私が至る所のすべての教会で教えているとおりに、キリスト・イエスにある私の生き方を、あなたがたに思い起こさせてくれるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","私があなたがたのところへ行くことはあるまいと、思い上がっている人たちがいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","しかし、主のみこころであれば、すぐにもあなたがたのところへ行きます。そして、思い上がっている人たちの、ことばではなく、力を見せてもらいましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","神の国はことばにはなく、力にあるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","あなたがたはどちらを望むのですか。私はあなたがたのところへむちを持って行きましょうか。それとも、愛と優しい心で行きましょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","あなたがたの間に不品行があるということが言われています。しかもそれは、異邦人の中にもないほどの不品行で、父の妻を妻にしている者がいるとのことです。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","それなのに、あなたがたは誇り高ぶっています。そればかりか、そのような行ないをしている者をあなたがたの中から取り除こうとして悲しむこともなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","私のほうでは、からだはそこにいなくても心はそこにおり、現にそこにいるのと同じように、そのような行ないをした者を主イエスの御名によってすでにさばきました。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","あなたがたが集まったときに、私も、霊においてともにおり、私たちの主イエスの権能をもって、 ");
INSERT INTO jpn1965_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","このような者をサタンに引き渡したのです。それは彼の肉が滅ぼされるためですが、それによって彼の霊が主の日に救われるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","あなたがたの高慢は、よくないことです。あなたがたは、ほんのわずかのパン種が、粉のかたまり全体をふくらませることを知らないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","新しい粉のかたまりのままでいるために、古いパン種を取り除きなさい。あなたがたはパン種のないものだからです。私たちの過越の小羊キリストが、すでにほふられたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ですから、私たちは、古いパン種を用いたり、悪意と不正のパン種を用いたりしないで、パン種のはいらない、純粋で真実なパンで、祭りをしようではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","私は前にあなたがたに送った手紙で、不品行な者たちと交際しないようにと書きました。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","それは、世の中の不品行な者、貪欲な者、略奪する者、偶像を礼拝する者と全然交際しないようにという意味ではありません。もしそうだとしたら、この世界から出て行かなければならないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","私が書いたことのほんとうの意味は、もし、兄弟と呼ばれる者で、しかも不品行な者、貪欲な者、偶像を礼拝する者、人をそしる者、酒に酔う者、略奪する者がいたなら、そのような者とはつきあってはいけない、いっしょに食事をしてもいけない、ということです。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","外部の人たちをさばくことは、私のすべきことでしょうか。あなたがたがさばくべき者は、内部の人たちではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","外部の人たちは、神がおさばきになります。その悪い人をあなたがたの中から除きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","あなたがたの中には、仲間の者と争いを起こしたとき、それを聖徒たちに訴えないで、あえて、正しくない人たちに訴え出るような人がいるのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","あなたがたは、聖徒が世界をさばくようになることを知らないのですか。世界があなたがたによってさばかれるはずなのに、あなたがたは、ごく小さな事件さえもさばく力がないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","私たちは御使いをもさばくべき者だ、ということを、知らないのですか。それならこの世のことは、言うまでもないではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","それなのに、この世のことで争いが起こると、教会のうちでは無視される人たちを裁判官に選ぶのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","私はあなたがたをはずかしめるためにこう言っているのです。いったい、あなたがたの中には、兄弟の間の争いを仲裁することのできるような賢い者が、ひとりもいないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","それで、兄弟は兄弟を告訴し、しかもそれを不信者の前でするのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","そもそも、互いに訴え合うことが、すでにあなたがたの敗北です。なぜ、むしろ不正をも甘んじて受けないのですか。なぜ、むしろだまされていないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ところが、それどころか、あなたがたは、不正を行なう、だまし取る、しかもそのようなことを兄弟に対してしているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","あなたがたは、正しくない者は神の国を相続できないことを、知らないのですか。だまされてはいけません。不品行な者、偶像を礼拝する者、姦淫をする者、男娼となる者、男色をする者、 ");
INSERT INTO jpn1965_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","盗む者、貪欲な者、酒に酔う者、そしる者、略奪する者はみな、神の国を相続することができません。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","あなたがたの中のある人たちは以前はそのような者でした。しかし、主イエス・キリストの御名と私たちの神の御霊によって、あなたがたは洗われ、きよい者とされ、義と認められたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","すべてのことが私には許されたことです。しかし、すべてが益になるわけではありません。私にはすべてのことが許されています。しかし、私はどんなことにも支配されはしません。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","食物は腹のためにあり、腹は食物のためにあります。ところが神は、そのどちらをも滅ぼされます。からだは不品行のためにあるのではなく、主のためであり、主はからだのためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","神は主をよみがえらせましたが、その御力によって私たちをもよみがえらせてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","あなたがたのからだはキリストのからだの一部であることを、知らないのですか。キリストのからだを取って遊女のからだとするのですか。そんなことは絶対に許されません。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","遊女と交われば、一つからだになることを知らないのですか。「ふたりの者は一心同体となる。」と言われているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","しかし、主と交われば、一つ霊となるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","不品行を避けなさい。人が犯す罪はすべて、からだの外のものです。しかし、不品行を行なう者は、自分のからだに対して罪を犯すのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","あなたがたのからだは、あなたがたのうちに住まれる、神から受けた聖霊の宮であり、あなたがたは、もはや自分自身のものではないことを、知らないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","あなたがたは、代価を払って買い取られたのです。ですから自分のからだをもって、神の栄光を現わしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","さて、あなたがたの手紙に書いてあったことについてですが、男が女に触れないのは良いことです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","しかし、不品行を避けるため、男はそれぞれ自分の妻を持ち、女もそれぞれ自分の夫を持ちなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","夫は自分の妻に対して義務を果たし、同様に妻も自分の夫に対して義務を果たしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","妻は自分のからだに関する権利を持ってはおらず、それは夫のものです。同様に夫も自分のからだについての権利を持ってはおらず、それは妻のものです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","互いの権利を奪い取ってはいけません。ただし、祈りに専心するために、合意の上でしばらく離れていて、また再びいっしょになるというのならかまいません。あなたがたが自制力を欠くとき、サタンの誘惑にかからないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","以上、私の言うところは、容認であって、命令ではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","私の願うところは、すべての人が私のようであることです。しかし、ひとりひとり神から与えられたそれぞれの賜物を持っているので、人それぞれに行き方があります。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","次に、結婚していない男とやもめの女に言いますが、私のようにしていられるなら、それがよいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","しかし、もし自制することができなければ、結婚しなさい。情の燃えるよりは、結婚するほうがよいからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","次に、すでに結婚した人々に命じます。命じるのは、私ではなく主です。妻は夫と別れてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","――もし別れたのだったら、結婚せずにいるか、それとも夫と和解するか、どちらかにしなさい。――また夫は妻を離別してはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","次に、そのほかの人々に言いますが、これを言うのは主ではなく、私です。信者の男子に信者でない妻があり、その妻がいっしょにいることを承知しているばあいは、離婚してはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","また、信者でない夫を持つ女は、夫がいっしょにいることを承知しているばあいは、離婚してはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","なぜなら、信者でない夫は妻によってきよめられており、また、信者でない妻も信者の夫によってきよめられているからです。そうでなかったら、あなたがたの子どもは汚れているわけです。ところが、現にきよいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","しかし、もし信者でないほうの者が離れて行くのであれば、離れて行かせなさい。そのようなばあいには、信者である夫あるいは妻は、縛られることはありません。神は、平和を得させようとしてあなたがたを召されたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","なぜなら、妻よ。あなたが夫を救えるかどうかが、どうしてわかりますか。また、夫よ。あなたが妻を救えるかどうかが、どうしてわかりますか。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ただ、おのおのが、主からいただいた分に応じ、また神がおのおのをお召しになったときのままの状態で歩むべきです。私は、すべての教会で、このように指導しています。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","召されたとき割礼を受けていたのなら、その跡をなくしてはいけません。また、召されたとき割礼を受けていなかったのなら、割礼を受けてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","割礼は取るに足らぬこと、無割礼も取るに足らぬことです。重要なのは神の命令を守ることです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","おのおの自分が召されたときの状態にとどまっていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","奴隷の状態で召されたのなら、それを気にしてはいけません。しかし、もし自由の身になれるなら、むしろ自由になりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","奴隷も、主にあって召された者は、主に属する自由人であり、同じように、自由人も、召された者はキリストに属する奴隷だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","あなたがたは、代価をもって買われたのです。人間の奴隷となってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","兄弟たち。おのおの召されたときのままの状態で、神の御前にいなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","処女のことについて、私は主の命令を受けてはいませんが、主のあわれみによって信頼できる者として、意見を述べます。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","現在の危急のときには、男はそのままの状態にとどまるのがよいと思います。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","あなたが妻に結ばれているなら、解かれたいと考えてはいけません。妻に結ばれていないのなら、妻を得たいと思ってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","しかし、たといあなたが結婚したからといって、罪を犯すのではありません。たとい処女が結婚したからといって、罪を犯すのではありません。ただ、それらの人々は、その身に苦難を招くでしょう。私はあなたがたを、そのようなめに会わせたくないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","兄弟たちよ。私は次のことを言いたいのです。時は縮まっています。今からは、妻のある者は、妻のない者のようにしていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","泣く者は泣かない者のように、喜ぶ者は喜ばない者のように、買う者は所有しない者のようにしていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","世の富を用いる者は用いすぎないようにしなさい。この世の有様は過ぎ去るからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","あなたがたが思い煩わないことを私は望んでいます。独身の男は、どうしたら主に喜ばれるかと、主のことに心を配ります。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","しかし、結婚した男は、どうしたら妻に喜ばれるかと世のことに心を配り、 ");
INSERT INTO jpn1965_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","心が分かれるのです。独身の女や処女は、身もたましいもきよくなるため、主のことに心を配りますが、結婚した女は、どうしたら夫に喜ばれるかと、世のことに心を配ります。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ですが、私がこう言っているのは、あなたがた自身の益のためであって、あなたがたを束縛しようとしているのではありません。むしろあなたがたが秩序ある生活を送って、ひたすら主に奉仕できるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","もし、処女である自分の娘の婚期も過ぎようとしていて、そのままでは、娘に対しての扱い方が正しくないと思い、またやむをえないことがあるならば、その人は、その心のままにしなさい。罪を犯すわけではありません。彼らに結婚させなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","しかし、もし心のうちに堅く決意しており、ほかに強いられる事情もなく、また自分の思うとおりに行なうことのできる人が、処女である自分の娘をそのままにしておくのなら、そのことはりっぱです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ですから、処女である自分の娘を結婚させる人は良いことをしているのであり、また結婚させない人は、もっと良いことをしているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","妻は夫が生きている間は夫に縛られています。しかし、もし夫が死んだなら、自分の願う人と結婚する自由があります。ただ主にあってのみ、そうなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","私の意見では、もしそのままにしていられたら、そのほうがもっと幸いです。私も、神の御霊をいただいていると思います。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","次に、偶像にささげた肉についてですが、私たちはみな知識を持っているということなら、わかっています。しかし、知識は人を高ぶらせ、愛は人の徳を建てます。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","人がもし、何かを知っていると思ったら、その人はまだ知らなければならないほどのことも知ってはいないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","しかし、人が神を愛するなら、その人は神に知られているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","そういうわけで、偶像にささげた肉を食べることについてですが、私たちは、世の偶像の神は実際にはないものであること、また、唯一の神以外には神は存在しないことを知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","なるほど、多くの神や、多くの主があるので、神々と呼ばれるものならば、天にも地にもありますが、 ");
INSERT INTO jpn1965_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","私たちには、父なる唯一の神がおられるだけで、すべてのものはこの神から出ており、私たちもこの神のために存在しているのです。また、唯一の主なるイエス・キリストがおられるだけで、すべてのものはこの主によって存在し、私たちもこの主によって存在するのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","しかし、すべての人にこの知識があるのではありません。ある人たちは、今まで偶像になじんで来たため偶像にささげた肉として食べ、それで彼らのそのように弱い良心が汚れるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","しかし、私たちを神に近づけるのは食物ではありません。食べなくても損にはならないし、食べても益にはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ただ、あなたがたのこの権利が、弱い人たちのつまずきとならないように、気をつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","知識のあるあなたが偶像の宮で食事をしているのをだれかが見たら、それによって力を得て、その人の良心は弱いのに、偶像の神にささげた肉を食べるようなことにならないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","その弱い人は、あなたの知識によって、滅びることになるのです。キリストはその兄弟のためにも死んでくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","あなたがたはこのように兄弟たちに対して罪を犯し、彼らの弱い良心を踏みにじるとき、キリストに対して罪を犯しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ですから、もし食物が私の兄弟をつまずかせるなら、私は今後いっさい肉を食べません。それは、私の兄弟につまずきを与えないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","私には自由がないでしょうか。私は使徒ではないのでしょうか。私は私たちの主イエスを見たのではないでしょうか。あなたがたは、主にあって私の働きの実ではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","たとい私がほかの人々に対しては使徒でなくても、少なくともあなたがたに対しては使徒です。あなたがたは、主にあって、私が使徒であることの証印です。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","私をさばく人たちに対して、私は次のように弁明します。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","いったい私たちには飲み食いする権利がないのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","私たちには、ほかの使徒、主の兄弟たち、ケパなどと違って、信者である妻を連れて歩く権利がないのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","それともまた、私とバルナバだけには、生活のための働きをやめる権利がないのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","いったい自分の費用で兵士になる者がいるでしょうか。自分でぶどう園を造りながら、その実を食べない者がいるでしょうか。羊の群れを飼いながら、その乳を飲まない者がいるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","私がこんなことを言うのは、人間の考えによって言っているのでしょうか。律法も同じことを言っているではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","モーセの律法には、「穀物をこなしている牛に、くつこを掛けてはいけない。」と書いてあります。いったい神は、牛のことを気にかけておられるのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","それとも、もっぱら私たちのために、こう言っておられるのでしょうか。むろん、私たちのためにこう書いてあるのです。なぜなら、耕す者が望みを持って耕し、脱穀する者が分配を受ける望みを持って仕事をするのは当然だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","もし私たちが、あなたがたに御霊のものを蒔いたのであれば、あなたがたから物質的なものを刈り取ることは行き過ぎでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","もし、ほかの人々が、あなたがたに対する権利にあずかっているのなら、私たちはなおさらその権利を用いてよいはずではありませんか。それなのに、私たちはこの権利を用いませんでした。かえって、すべてのことについて耐え忍んでいます。それは、キリストの福音に少しの妨げも与えまいとしてなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","あなたがたは、宮に奉仕している者が宮の物を食べ、祭壇に仕える者が祭壇の物にあずかることを知らないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","同じように、主も、福音を宣べ伝える者が、福音の働きから生活のささえを得るように定めておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","しかし、私はこれらの権利を一つも用いませんでした。また、私は自分がそうされたくてこのように書いているのでもありません。私は自分の誇りをだれかに奪われるよりは、死んだほうがましだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","というのは、私が福音を宣べ伝えても、それは私の誇りにはなりません。そのことは、私がどうしても、しなければならないことだからです。もし福音を宣べ伝えなかったら、私はわざわいに会います。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","もし私がこれを自発的にしているのなら、報いがありましょう。しかし、強いられたにしても、私には務めがゆだねられているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","では、私にどんな報いがあるのでしょう。それは、福音を宣べ伝えるときに報酬を求めないで与え、福音の働きによって持つ自分の権利を十分に用いないことなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","私はだれに対しても自由ですが、より多くの人を獲得するために、すべての人の奴隷となりました。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ユダヤ人にはユダヤ人のようになりました。それはユダヤ人を獲得するためです。律法の下にある人々には、私自身は律法の下にはいませんが、律法の下にある者のようになりました。それは律法の下にある人々を獲得するためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","律法を持たない人々に対しては、――私は神の律法の外にある者ではなく、キリストの律法を守る者ですが、――律法を持たない者のようになりました。それは律法を持たない人々を獲得するためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","弱い人々には、弱い者になりました。弱い人々を獲得するためです。すべての人に、すべてのものとなりました。それは、何とかして、幾人かでも救うためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","私はすべてのことを、福音のためにしています。それは、私も福音の恵みをともに受ける者となるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","競技場で走る人たちは、みな走っても、賞を受けるのはただひとりだ、ということを知っているでしょう。ですから、あなたがたも、賞を受けられるように走りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","また闘技をする者は、あらゆることについて自制します。彼らは朽ちる冠を受けるためにそうするのですが、私たちは朽ちない冠を受けるためにそうするのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ですから、私は決勝点がどこかわからないような走り方はしていません。空を打つような拳闘もしてはいません。 ");
INSERT INTO jpn1965_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","私は自分のからだを打ちたたいて従わせます。それは、私がほかの人に宣べ伝えておきながら、自分自身が失格者になるようなことのないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","そこで、兄弟たち。私はあなたがたにぜひ次のことを知ってもらいたいのです。私たちの先祖はみな、雲の下におり、みな海を通って行きました。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","そしてみな、雲と海とで、モーセにつくバプテスマを受け、 ");
INSERT INTO jpn1965_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","みな同じ御霊の食べ物を食べ、 ");
INSERT INTO jpn1965_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","みな同じ御霊の飲み物を飲みました。というのは、彼らについて来た御霊の岩から飲んだからです。その岩とはキリストです。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","にもかかわらず、彼らの大部分は神のみこころにかなわず、荒野で滅ぼされました。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","これらのことが起こったのは、私たちへの戒めのためです。それは、彼らがむさぼったように私たちが悪をむさぼることのないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","あなたがたは、彼らの中のある人たちにならって、偶像崇拝者となってはいけません。聖書には、「民が、すわっては飲み食いし、立っては踊った。」と書いてあります。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","また、私たちは、彼らのある人たちが姦淫をしたのにならって姦淫をすることはないようにしましょう。彼らは姦淫のゆえに一日に二万三千人死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","私たちは、さらに、彼らの中のある人たちが主を試みたのにならって主を試みることはないようにしましょう。彼らは蛇に滅ぼされました。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","また、彼らの中のある人たちがつぶやいたのにならってつぶやいてはいけません。彼らは滅ぼす者に滅ぼされました。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","これらのことが彼らに起こったのは、戒めのためであり、それが書かれたのは、世の終わりに臨んでいる私たちへの教訓とするためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ですから、立っていると思う者は、倒れないように気をつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","あなたがたの会った試練はみな人の知らないようなものではありません。神は真実な方ですから、あなたがたを耐えることのできないような試練に会わせるようなことはなさいません。むしろ、耐えることのできるように、試練とともに、脱出の道も備えてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ですから、私の愛する者たちよ。偶像礼拝を避けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","私は賢い人たちに話すように話します。ですから私の言うことを判断してください。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","私たちが祝福する祝福の杯は、キリストの血にあずかることではありませんか。私たちの裂くパンは、キリストのからだにあずかることではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","パンは一つですから、私たちは、多数であっても、一つのからだです。それは、みなの者がともに一つのパンを食べるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","肉によるイスラエルのことを考えてみなさい。供え物を食べる者は、祭壇にあずかるではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","私は何を言おうとしているのでしょう。偶像の神にささげた肉に、何か意味があるとか、偶像の神に真実な意味があるとか、言おうとしているのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","いや、彼らのささげる物は、神にではなくて悪霊にささげられている、と言っているのです。私は、あなたがたに悪霊と交わる者になってもらいたくありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","あなたがたが主の杯を飲んだうえ、さらに悪霊の杯を飲むことは、できないことです。主の食卓にあずかったうえ、さらに悪霊の食卓にあずかることはできないことです。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","それとも、私たちは主のねたみを引き起こそうとするのですか。まさか、私たちが主よりも強いことはないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","すべてのことは、してもよいのです。しかし、すべてのことが有益とはかぎりません。すべてのことは、してもよいのです。しかし、すべてのことが徳を高めるとはかぎりません。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","だれでも、自分の利益を求めないで、他人の利益を心がけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","市場に売っている肉は、良心の問題として調べ上げることはしないで、どれでも食べなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","地とそれに満ちているものは、主のものだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","もし、あなたがたが信仰のない者に招待されて、行きたいと思うときは、良心の問題として調べ上げることはしないで、自分の前に置かれる物はどれでも食べなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","しかし、もしだれかが、「これは偶像にささげた肉です。」とあなたがたに言うなら、そう知らせた人のために、また良心のために、食べてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","私が良心と言うのは、あなたの良心ではなく、ほかの人の良心です。私の自由が、他の人の良心によってさばかれるわけがあるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","もし、私が神に感謝をささげて食べるなら、私が感謝する物のために、そしられるわけがあるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","こういうわけで、あなたがたは、食べるにも、飲むにも、何をするにも、ただ神の栄光を現わすためにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ユダヤ人にも、ギリシヤ人にも、神の教会にも、つまずきを与えないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","私も、人々が救われるために、自分の利益を求めず、多くの人の利益を求め、どんなことでも、みなの人を喜ばせているのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","私がキリストを見ならっているように、あなたがたも私を見ならってください。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","さて、あなたがたは、何かにつけて私を覚え、また、私があなたがたに伝えたものを、伝えられたとおりに堅く守っているので、私はあなたがたをほめたいと思います。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","しかし、あなたがたに次のことを知っていただきたいのです。すべての男のかしらはキリストであり、女のかしらは男であり、キリストのかしらは神です。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","男が、祈りや預言をするとき、頭にかぶり物を着けていたら、自分の頭をはずかしめることになります。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","しかし、女が、祈りや預言をするとき、頭にかぶり物を着けていなかったら、自分の頭をはずかしめることになります。それは髪をそっているのと全く同じことだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","女がかぶり物を着けないのなら、髪も切ってしまいなさい。髪を切り、頭をそることが女として恥ずかしいことなら、かぶり物を着けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","男はかぶり物を着けるべきではありません。男は神の似姿であり、神の栄光の現われだからです。女は男の栄光の現われです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","なぜなら、男は女をもとにして造られたのではなくて、女が男をもとにして造られたのであり、 ");
INSERT INTO jpn1965_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","また、男は女のために造られたのではなく、女が男のために造られたのだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ですから、女は頭に権威のしるしをかぶるべきです。それも御使いたちのためにです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","とはいえ、主にあっては、女は男を離れてあるものではなく、男も女を離れてあるものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","女が男をもとにして造られたように、同様に、男も女によって生まれるのだからです。しかし、すべては神から発しています。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","あなたがたは自分自身で判断しなさい。女が頭に何もかぶらないで神に祈るのは、ふさわしいことでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","自然自体が、あなたがたにこう教えていないでしょうか。男が長い髪をしていたら、それは男として恥ずかしいことであり、 ");
INSERT INTO jpn1965_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","女が長い髪をしていたら、それは女の光栄であるということです。なぜなら、髪はかぶり物として女に与えられているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","たとい、このことに異議を唱えたがる人がいても、私たちにはそのような習慣はないし、神の諸教会にもありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ところで、聞いていただくことがあります。私はあなたがたをほめません。あなたがたの集まりが益にならないで、かえって害になっているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","まず第一に、あなたがたが教会の集まりをするとき、あなたがたの間には分裂があると聞いています。ある程度は、それを信じます。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","というのは、あなたがたの中でほんとうの信者が明らかにされるためには、分派が起こるのもやむをえないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","しかし、そういうわけで、あなたがたはいっしょに集まっても、それは主の晩餐を食べるためではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","食事のとき、めいめい我先にと自分の食事を済ませるので、空腹な者もおれば、酔っている者もいるというしまつです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","飲食のためなら、自分の家があるでしょう。それとも、あなたがたは、神の教会を軽んじ、貧しい人たちをはずかしめたいのですか。私はあなたがたに何と言ったらよいでしょう。ほめるべきでしょうか。このことに関しては、ほめるわけにはいきません。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","私は主から受けたことを、あなたがたに伝えたのです。すなわち、主イエスは、渡される夜、パンを取り、 ");
INSERT INTO jpn1965_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","感謝をささげて後、それを裂き、こう言われました。「これはあなたがたのための、わたしのからだです。わたしを覚えるために、このようにしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","夕食の後、杯をも同じようにして言われました。「この杯は、わたしの血による新しい契約です。これを飲むたびに、わたしを覚えるために、このようにしなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ですから、あなたがたは、このパンを食べ、この杯を飲むたびに、主が来られるまで、主の死を告げ知らせるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","したがって、もし、ふさわしくないままでパンを食べ、主の杯を飲む者があれば、主のからだと血に対して罪を犯すことになります。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ですから、ひとりひとりが自分を吟味して、そのうえでパンを食べ、杯を飲みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","みからだをわきまえないで、飲み食いするならば、その飲み食いが自分をさばくことになります。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","そのために、あなたがたの中に、弱い者や病人が多くなり、死んだ者が大ぜいいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","しかし、もし私たちが自分をさばくなら、さばかれることはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","しかし、私たちがさばかれるのは、主によって懲らしめられるのであって、それは、私たちが、この世とともに罪に定められることのないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ですから、兄弟たち。食事に集まるときは、互いに待ち合わせなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","空腹な人は家で食べなさい。それは、あなたがたが集まることによって、さばきを受けることにならないためです。その他のことについては、私が行ったときに決めましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","さて、兄弟たち。御霊の賜物についてですが、私はあなたがたに、ぜひ次のことを知っていていただきたいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ご承知のように、あなたがたが異教徒であったときには、どう導かれたとしても、引かれて行った所は、ものを言わない偶像の所でした。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ですから、私は、あなたがたに次のことを教えておきます。神の御霊によって語る者はだれも、「イエスはのろわれよ。」と言わず、また、聖霊によるのでなければ、だれも、「イエスは主です。」と言うことはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","さて、御霊の賜物にはいろいろの種類がありますが、御霊は同じ御霊です。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","奉仕にはいろいろの種類がありますが、主は同じ主です。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","働きにはいろいろの種類がありますが、神はすべての人の中ですべての働きをなさる同じ神です。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","しかし、みなの益となるために、おのおのに御霊の現われが与えられているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ある人には御霊によって知恵のことばが与えられ、ほかの人には同じ御霊にかなう知識のことばが与えられ、 ");
INSERT INTO jpn1965_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","またある人には同じ御霊による信仰が与えられ、ある人には同一の御霊によって、いやしの賜物が与えられ、 ");
INSERT INTO jpn1965_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ある人には奇蹟を行なう力、ある人には預言、ある人には霊を見分ける力、ある人には異言、ある人には異言を解き明かす力が与えられています。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","しかし、同一の御霊がこれらすべてのことをなさるのであって、みこころのままに、おのおのにそれぞれの賜物を分け与えてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ですから、ちょうど、からだが一つでも、それに多くの部分があり、からだの部分はたとい多くあっても、その全部が一つのからだであるように、キリストもそれと同様です。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","なぜなら、私たちはみな、ユダヤ人もギリシヤ人も、奴隷も自由人も、一つのからだとなるように、一つの御霊によってバプテスマを受け、そしてすべての者が一つの御霊を飲む者とされたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","確かに、からだはただ一つの器官ではなく、多くの器官から成っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","たとい、足が、「私は手ではないから、からだに属さない。」と言ったところで、そんなことでからだに属さなくなるわけではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","たとい、耳が、「私は目ではないから、からだに属さない。」と言ったところで、そんなことでからだに属さなくなるわけではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","もし、からだ全体が目であったら、どこで聞くのでしょう。もし、からだ全体が聞くところであったら、どこでかぐのでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","しかしこのとおり、神はみこころに従って、からだの中にそれぞれの器官を備えてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","もし、全部がただ一つの器官であったら、からだはいったいどこにあるのでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","しかしこういうわけで、器官は多くありますが、からだは一つなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","そこで、目が手に向かって、「私はあなたを必要としない。」と言うことはできないし、頭が足に向かって、「私はあなたを必要としない。」と言うこともできません。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","それどころか、からだの中で比較的に弱いと見られる器官が、かえってなくてはならないものなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","また、私たちは、からだの中で比較的に尊くないとみなす器官を、ことさらに尊びます。こうして、私たちの見ばえのしない器官は、ことさらに良いかっこうになりますが、 ");
INSERT INTO jpn1965_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","かっこうの良い器官にはその必要がありません。しかし神は、劣ったところをことさらに尊んで、からだをこのように調和させてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","それは、からだの中に分裂がなく、各部分が互いにいたわり合うためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","もし一つの部分が苦しめば、すべての部分がともに苦しみ、もし一つの部分が尊ばれれば、すべての部分がともに喜ぶのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","あなたがたはキリストのからだであって、ひとりひとりは各器官なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","そして、神は教会の中で人々を次のように任命されました。すなわち、第一に使徒、次に預言者、次に教師、それから奇蹟を行なう者、それからいやしの賜物を持つ者、助ける者、治める者、異言を語る者などです。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","みなが使徒でしょうか。みなが預言者でしょうか。みなが教師でしょうか。みなが奇蹟を行なう者でしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","みながいやしの賜物を持っているでしょうか。みなが異言を語るでしょうか。みなが解き明かしをするでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","あなたがたは、よりすぐれた賜物を熱心に求めなさい。 また私は、さらにまさる道を示してあげましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","たとい、私が人の異言や、御使いの異言で話しても、愛がないなら、やかましいどらや、うるさいシンバルと同じです。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","また、たとい私が預言の賜物を持っており、またあらゆる奥義とあらゆる知識とに通じ、また、山を動かすほどの完全な信仰を持っていても、愛がないなら、何の値うちもありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","また、たとい私が持っている物の全部を貧しい人たちに分け与え、また私のからだを焼かれるために渡しても、愛がなければ、何の役にも立ちません。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","愛は寛容であり、愛は親切です。また人をねたみません。愛は自慢せず、高慢になりません。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","礼儀に反することをせず、自分の利益を求めず、怒らず、人のした悪を思わず、 ");
INSERT INTO jpn1965_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","不正を喜ばずに真理を喜びます。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","すべてをがまんし、すべてを信じ、すべてを期待し、すべてを耐え忍びます。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","愛は決して絶えることがありません。預言の賜物ならばすたれます。異言ならばやみます。知識ならばすたれます。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","というのは、私たちの知っているところは一部分であり、預言することも一部分だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","完全なものが現われたら、不完全なものはすたれます。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","私が子どもであったときには、子どもとして話し、子どもとして考え、子どもとして論じましたが、おとなになったときには、子どものことをやめました。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","今、私たちは鏡にぼんやり映るものを見ていますが、その時には顔と顔とを合わせて見ることになります。今、私は一部分しか知りませんが、その時には、私が完全に知られているのと同じように、私も完全に知ることになります。 ");
INSERT INTO jpn1965_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","こういうわけで、いつまでも残るものは信仰と希望と愛です。その中で一番すぐれているのは愛です。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","愛を追い求めなさい。また、御霊の賜物、特に預言することを熱心に求めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","異言を話す者は、人に話すのではなく、神に話すのです。というのは、だれも聞いていないのに、自分の霊で奥義を話すからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ところが預言する者は、徳を高め、勧めをなし、慰めを与えるために、人に向かって話します。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","異言を話す者は自分の徳を高めますが、預言する者は教会の徳を高めます。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","私はあなたがたがみな異言を話すことを望んでいますが、それよりも、あなたがたが預言することを望みます。もし異言を話す者がその解き明かしをして教会の徳を高めるのでないなら、異言を語る者よりも、預言する者のほうがまさっています。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ですから、兄弟たち。私があなたがたのところへ行って異言を話すとしても、黙示や知識や預言や教えなどによって話さないなら、あなたがたに何の益となるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","笛や琴などいのちのない楽器でも、はっきりした音を出さなければ、何を吹いているのか、何をひいているのか、どうしてわかりましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","また、ラッパがもし、はっきりしない音を出したら、だれが戦闘の準備をするでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","それと同じように、あなたがたも、舌で明瞭なことばを語るのでなければ、言っている事をどうして知ってもらえるでしょう。それは空気に向かって話しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","世界にはおそらく非常に多くの種類のことばがあるでしょうが、意味のないことばなど一つもありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","それで、もし私がそのことばの意味を知らないなら、私はそれを話す人にとって異国人であり、それを話す人も私にとって異国人です。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","あなたがたのばあいも同様です。あなたがたは御霊の賜物を熱心に求めているのですから、教会の徳を高めるために、それが豊かに与えられるよう、熱心に求めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","こういうわけですから、異言を語る者は、それを解き明かすことができるように祈りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","もし私が異言で祈るなら、私の霊は祈るが、私の知性は実を結ばないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ではどうすればよいのでしょう。私は霊において祈り、また知性においても祈りましょう。霊において賛美し、また知性においても賛美しましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","そうでないと、あなたが霊において祝福しても、異言を知らない人々の座席に着いている人は、あなたの言っていることがわからないのですから、あなたの感謝について、どうしてアーメンと言えるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","あなたの感謝は結構ですが、他の人の徳を高めることはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","私は、あなたがたのだれよりも多くの異言を話すことを神に感謝していますが、 ");
INSERT INTO jpn1965_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","教会では、異言で一万語話すよりは、ほかの人を教えるために、私の知性を用いて五つのことばを話したいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","兄弟たち。物の考え方において子どもであってはなりません。悪事においては幼子でありなさい。しかし考え方においてはおとなになりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","律法にこう書いてあります。「『わたしは、異なった舌により、異国の人のくちびるによってこの民に語るが、彼らはなおわたしの言うことを聞き入れない。』と主は言われる。」 ");
INSERT INTO jpn1965_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","それで、異言は信者のためのしるしではなく、不信者のためのしるしです。けれども、預言は不信者でなく、信者のためのしるしです。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","ですから、もし教会全体が一か所に集まって、みなが異言を話すとしたら、初心の者とか信者でない者とかがはいって来たとき、彼らは、あなたがたを気違いだと言わないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","しかし、もしみなが預言をするなら、信者でない者や初心の者がはいって来たとき、その人はみなの者によって罪を示されます。みなにさばかれ、 ");
INSERT INTO jpn1965_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","心の秘密があらわにされます。そうして、神が確かにあなたがたの中におられると言って、ひれ伏して神を拝むでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","兄弟たち。では、どうすればよいのでしょう。あなたがたが集まるときには、それぞれの人が賛美したり、教えたり、黙示を話したり、異言を話したり、解き明かしたりします。そのすべてのことを、徳を高めるためにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","もし異言を話すのならば、ふたりか、多くても三人で順番に話すべきで、ひとりは解き明かしをしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","もし解き明かす者がだれもいなければ、教会では黙っていなさい。自分だけで、神に向かって話しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","預言する者も、ふたりか三人が話し、ほかの者はそれを吟味しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","もしも座席に着いている別の人に黙示が与えられたら、先の人は黙りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","あなたがたは、みながかわるがわる預言できるのであって、すべての人が学ぶことができ、すべての人が勧めを受けることができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","預言者たちの霊は預言者たちに服従するものなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","それは、神が混乱の神ではなく、平和の神だからです。聖徒たちのすべての教会で行なわれているように、 ");
INSERT INTO jpn1965_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","教会では、妻たちは黙っていなさい。彼らは語ることを許されていません。律法も言うように、服従しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","もし何かを学びたければ、家で自分の夫に尋ねなさい。教会で語ることは、妻にとってはふさわしくないことです。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","神のことばは、あなたがたのところから出たのでしょうか。あるいはまた、あなたがたにだけ伝わったのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","自分を預言者、あるいは、御霊の人と思う者は、私があなたがたに書くことが主の命令であることを認めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","もしそれを認めないなら、その人は認められません。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","それゆえ、私の兄弟たち。預言することを熱心に求めなさい。異言を話すことも禁じてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ただ、すべてのことを適切に、秩序をもって行ないなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","兄弟たち。私は今、あなたがたに福音を知らせましょう。これは、私があなたがたに宣べ伝えたもので、あなたがたが受け入れ、また、それによって立っている福音です。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","また、もしあなたがたがよく考えもしないで信じたのでないなら、私の宣べ伝えたこの福音のことばをしっかりと保っていれば、この福音によって救われるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","私があなたがたに最もたいせつなこととして伝えたのは、私も受けたことであって、次のことです。キリストは、聖書の示すとおりに、私たちの罪のために死なれたこと、 ");
INSERT INTO jpn1965_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","また、葬られたこと、また、聖書に従って三日目によみがえられたこと、 ");
INSERT INTO jpn1965_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","また、ケパに現われ、それから十二弟子に現われたことです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","その後、キリストは五百人以上の兄弟たちに同時に現われました。その中の大多数の者は今なお生き残っていますが、すでに眠った者もいくらかいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","その後、キリストはヤコブに現われ、それから使徒たち全部に現われました。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","そして、最後に、月足らずで生まれた者と同様な私にも、現われてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","私は使徒の中では最も小さい者であって、使徒と呼ばれる価値のない者です。なぜなら、私は神の教会を迫害したからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ところが、神の恵みによって、私は今の私になりました。そして、私に対するこの神の恵みは、むだにはならず、私はほかのすべての使徒たちよりも多く働きました。しかし、それは私ではなく、私にある神の恵みです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","そういうわけですから、私にせよ、ほかの人たちにせよ、私たちはこのように宣べ伝えているのであり、あなたがたはこのように信じたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ところで、キリストは死者の中から復活された、と宣べ伝えられているのなら、どうして、あなたがたの中に、死者の復活はない、と言っている人がいるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","もし、死者の復活がないのなら、キリストも復活されなかったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","そして、キリストが復活されなかったのなら、私たちの宣教は実質のないものになり、あなたがたの信仰も実質のないものになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","それどころか、私たちは神について偽証をした者ということになります。なぜなら、もしもかりに、死者の復活はないとしたら、神はキリストをよみがえらせなかったはずですが、私たちは神がキリストをよみがえらせた、と言って神に逆らう証言をしたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","もし、死者がよみがえらないのなら、キリストもよみがえらなかったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","そして、もしキリストがよみがえらなかったのなら、あなたがたの信仰はむなしく、あなたがたは今もなお、自分の罪の中にいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","そうだったら、キリストにあって眠った者たちは、滅んでしまったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","もし、私たちがこの世にあってキリストに単なる希望を置いているだけなら、私たちは、すべての人の中で一番哀れな者です。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","しかし、今やキリストは、眠った者の初穂として死者の中からよみがえられました。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","というのは、死がひとりの人を通して来たように、死者の復活もひとりの人を通して来たからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","すなわち、アダムにあってすべての人が死んでいるように、キリストによってすべての人が生かされるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","しかし、おのおのにその順番があります。まず初穂であるキリスト、次にキリストの再臨のときキリストに属している者です。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","それから終わりが来ます。そのとき、キリストはあらゆる支配と、あらゆる権威、権力を滅ぼし、国を父なる神にお渡しになります。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","キリストの支配は、すべての敵をその足の下に置くまで、と定められているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","最後の敵である死も滅ぼされます。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","「彼は万物をその足の下に従わせた。」からです。ところで、万物が従わせられた、と言うとき、万物を従わせたその方がそれに含められていないことは明らかです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","しかし、万物が御子に従うとき、御子自身も、ご自分に万物を従わせた方に従われます。これは、神が、すべてにおいてすべてとなられるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","もしこうでなかったら、死者のゆえにバプテスマを受ける人たちは、何のためにそうするのですか。もし、死者は決してよみがえらないのなら、なぜその人たちは、死者のゆえにバプテスマを受けるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","また、なぜ私たちもいつも危険にさらされているのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","兄弟たち。私にとって、毎日が死の連続です。これは、私たちの主キリスト・イエスにあってあなたがたを誇る私の誇りにかけて、誓って言えることです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","もし、私が人間的な動機から、エペソで獣と戦ったのなら、何の益があるでしょう。もし、死者の復活がないのなら、「あすは死ぬのだ。さあ、飲み食いしようではないか。」ということになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","思い違いをしてはいけません。友だちが悪ければ、良い習慣がそこなわれます。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","目をさまして、正しい生活を送り、罪をやめなさい。神についての正しい知識を持っていない人たちがいます。私はあなたがたをはずかしめるために、こう言っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ところが、ある人はこう言うでしょう。「死者は、どのようにしてよみがえるのか。どのようなからだで来るのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","愚かな人だ。あなたの蒔く物は、死ななければ、生かされません。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","あなたが蒔く物は、後にできるからだではなく、麦やそのほかの穀物の種粒です。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","しかし神は、みこころに従って、それにからだを与え、おのおのの種にそれぞれのからだをお与えになります。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","すべての肉が同じではなく、人間の肉もあり、獣の肉もあり、鳥の肉もあり、魚の肉もあります。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","また、天上のからだもあり、地上のからだもあり、天上のからだの栄光と地上のからだの栄光とは異なっており、 ");
INSERT INTO jpn1965_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","太陽の栄光もあり、月の栄光もあり、星の栄光もあります。個々の星によって栄光が違います。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","死者の復活もこれと同じです。朽ちるもので蒔かれ、朽ちないものによみがえらされ、 ");
INSERT INTO jpn1965_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","卑しいもので蒔かれ、栄光あるものによみがえらされ、弱いもので蒔かれ、強いものによみがえらされ、 ");
INSERT INTO jpn1965_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","血肉のからだで蒔かれ、御霊に属するからだによみがえらされるのです。血肉のからだがあるのですから、御霊のからだもあるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","聖書に「最初の人アダムは生きた者となった。」と書いてありますが、最後のアダムは、生かす御霊となりました。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","最初にあったのは血肉のものであり、御霊のものではありません。御霊のものはあとに来るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","第一の人は地から出て、土で造られた者ですが、第二の人は天から出た者です。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","土で造られた者はみな、この土で造られた者に似ており、天からの者はみな、この天から出た者に似ているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","私たちは土で造られた者のかたちを持っていたように、天上のかたちをも持つのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","兄弟たちよ。私はこのことを言っておきます。血肉のからだは神の国を相続できません。朽ちるものは、朽ちないものを相続できません。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","聞きなさい。私はあなたがたに奥義を告げましょう。私たちはみなが眠ってしまうのではなく、みな変えられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","終わりのラッパとともに、たちまち、一瞬のうちにです。ラッパが鳴ると、死者は朽ちないものによみがえり、私たちは変えられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","朽ちるものは、必ず朽ちないものを着なければならず、死ぬものは、必ず不死を着なければならないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","しかし、朽ちるものが朽ちないものを着、死ぬものが不死を着るとき、「死は勝利にのまれた。」としるされている、みことばが実現します。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","「死よ。おまえの勝利はどこにあるのか。死よ。おまえのとげはどこにあるのか。」 ");
INSERT INTO jpn1965_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","死のとげは罪であり、罪の力は律法です。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","しかし、神に感謝すべきです。神は、私たちの主イエス・キリストによって、私たちに勝利を与えてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ですから、私の愛する兄弟たちよ。堅く立って、動かされることなく、いつも主のわざに励みなさい。あなたがたは自分たちの労苦が、主にあってむだでないことを知っているのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","さて、聖徒たちのための献金については、ガラテヤの諸教会に命じたように、あなたがたにもこう命じます。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","私がそちらに行ってから献金を集めるようなことがないように、あなたがたはおのおの、いつも週の初めの日に、収入に応じて、手もとにそれをたくわえておきなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","私がそちらに行ったとき、あなたがたの承認を得た人々に手紙を持たせて派遣し、あなたがたの献金をエルサレムに届けさせましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","しかし、もし私も行くほうがよければ、彼らは、私といっしょに行くことになるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","私は、マケドニヤを通って後、あなたがたのところへ行きます。マケドニヤを通るつもりでいますから。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","そして、たぶんあなたがたのところに滞在するでしょう。冬を越すことになるかもしれません。それは、どこに行くとしても、あなたがたに送っていただこうと思うからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","私は、いま旅の途中に、あなたがたの顔を見たいと思っているのではありません。主がお許しになるなら、あなたがたのところにしばらく滞在したいと願っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","しかし、五旬節まではエペソに滞在するつもりです。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","というのは、働きのための広い門が私のために開かれており、反対者も大ぜいいるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","テモテがそちらへ行ったら、あなたがたのところで心配なく過ごせるよう心を配ってください。彼も、私と同じように、主のみわざに励んでいるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","だれも彼を軽んじてはいけません。彼を平安のうちに送り出して、私のところに来させてください。私は、彼が兄弟たちとともに来るのを待ち望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","兄弟アポロのことですが、兄弟たちといっしょにあなたがたのところへ行くように、私は強く彼に勧めました。しかし、彼は今、そちらへ行こうとは全然思っていません。しかし、機会があれば行くでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","目を覚ましていなさい。堅く信仰に立ちなさい。男らしく、強くありなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","いっさいのことを愛をもって行ないなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","兄弟たちよ。あなたがたに勧めます。ご承知のように、ステパナの家族は、アカヤの初穂であって、聖徒たちのために熱心に奉仕してくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","あなたがたは、このような人たちに、また、ともに働き、労しているすべての人たちに服従しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","ステパナとポルトナトとアカイコが来たので、私は喜んでいます。なぜなら、彼らは、あなたがたの足りない分を補ってくれたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","彼らは、私の心をも、あなたがたの心をも安心させてくれました。このような人々の労をねぎらいなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","アジヤの諸教会がよろしくと言っています。アクラとプリスカ、また彼らの家の教会が主にあって心から、あなたがたによろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","すべての兄弟たちが、あなたがたによろしくと言っています。きよい口づけをもって、互いにあいさつをかわしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","パウロが、自分の手であいさつを書きます。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","主を愛さない者はだれでも、のろわれよ。主よ、来てください。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","主イエスの恵みが、あなたがたとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","私の愛は、キリスト・イエスにあって、あなたがたすべての者とともにあります。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","神のみこころによるキリスト・イエスの使徒パウロ、および兄弟テモテから、コリントにある神の教会、ならびにアカヤ全土にいるすべての聖徒たちへ。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","私たちの父なる神と主イエス・キリストから、恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","私たちの主イエス・キリストの父なる神、慈愛の父、すべての慰めの神がほめたたえられますように。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","神は、どのような苦しみのときにも、私たちを慰めてくださいます。こうして、私たちも、自分自身が神から受ける慰めによって、どのような苦しみの中にいる人をも慰めることができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","それは、私たちにキリストの苦難があふれているように、慰めもまたキリストによってあふれているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","もし私たちが苦しみに会うなら、それはあなたがたの慰めと救いのためです。もし私たちが慰めを受けるなら、それもあなたがたの慰めのためで、その慰めは、私たちが受けている苦難と同じ苦難に耐え抜く力をあなたがたに与えるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","私たちがあなたがたについて抱いている望みは、動くことがありません。なぜなら、あなたがたが私たちと苦しみをともにしているように、慰めをもともにしていることを、私たちは知っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","兄弟たちよ。私たちがアジヤで会った苦しみについて、ぜひ知っておいてください。私たちは、非常に激しい、耐えられないほどの圧迫を受け、ついにいのちさえも危くなり、 ");
INSERT INTO jpn1965_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ほんとうに、自分の心の中で死を覚悟しました。これは、もはや自分自身を頼まず、死者をよみがえらせてくださる神により頼む者となるためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ところが神は、これほどの大きな死の危険から、私たちを救い出してくださいました。また将来も救い出してくださいます。なおも救い出してくださるという望みを、私たちはこの神に置いているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","あなたがたも祈りによって、私たちを助けて協力してくださるでしょう。それは、多くの人々の祈りにより私たちに与えられた恵みについて、多くの人々が感謝をささげるようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","私たちがこの世の中で、特にあなたがたに対して、きよさと神から来る誠実さとをもって、人間的な知恵によらず、神の恵みによって行動していることは、私たちの良心のあかしするところであって、これこそ私たちの誇りです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","私たちは、あなたがたへの手紙で、あなたがたが読んで理解できること以外は何も書いていません。そして私は、あなたがたが十分に理解してくれることを望みます。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","あなたがたは、ある程度は、私たちを理解しているのですから、私たちの主イエスの日には、あなたがたが私たちの誇りであるように、私たちもあなたがたの誇りであるということを、さらに十分に理解してくださるよう望むのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","この確信をもって、私は次のような計画を立てました。まず初めにあなたがたのところへ行くことによって、あなたがたが恵みを二度受けられるようにしようとしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","すなわち、あなたがたのところを通ってマケドニヤに行き、そしてマケドニヤから再びあなたがたのところに帰り、あなたがたに送られてユダヤに行きたいと思ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","そういうわけですから、この計画を立てた私が、どうして軽率でありえたでしょう。それとも、私の計画は人間的な計画であって、私にとっては、「しかり、しかり。」は同時に、「否、否。」なのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","しかし、神の真実にかけて言いますが、あなたがたに対する私たちのことばは、「しかり。」と言って、同時に「否。」と言うようなものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","私たち、すなわち、私とシルワノとテモテとが、あなたがたに宣べ伝えた神の子キリスト・イエスは、「しかり。」と同時に「否。」であるような方ではありません。この方には「しかり。」だけがあるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","神の約束はことごとく、この方において「しかり。」となりました。それで私たちは、この方によって「アーメン。」と言い、神に栄光を帰するのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","私たちをあなたがたといっしょにキリストのうちに堅く保ち、私たちに油を注がれた方は神です。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","神はまた、確認の印を私たちに押し、保証として、御霊を私たちの心に与えてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","私はこのいのちにかけ、神を証人にお呼びして言います。私がまだコリントへ行かないでいるのは、あなたがたに対する思いやりのためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","私たちは、あなたがたの信仰を支配しようとする者ではなく、あなたがたの喜びのために働く協力者です。あなたがたは、信仰に堅く立っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","そこで私は、あなたがたを悲しませることになるような訪問は二度とくり返すまいと決心したのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","もし私があなたがたを悲しませているのなら、私が悲しませているその人以外に、だれが私を喜ばせてくれるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","あのような手紙を書いたのは、私が行くときには、私に喜びを与えてくれるはずの人たちから悲しみを与えられたくないからでした。それは、私の喜びがあなたがたすべての喜びであることを、あなたがたすべてについて確信しているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","私は大きな苦しみと心の嘆きから、涙ながらに、あなたがたに手紙を書きました。それは、あなたがたを悲しませるためではなく、私があなたがたに対して抱いている、あふれるばかりの愛を知っていただきたいからでした。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","もしある人が悲しみのもとになったとすれば、その人は、私を悲しませたというよりも、ある程度――というのは言い過ぎにならないためですが、――あなたがた全部を悲しませたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","その人にとっては、すでに多数の人から受けたあの処罰で十分ですから、 ");
INSERT INTO jpn1965_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","あなたがたは、むしろ、その人を赦し、慰めてあげなさい。そうしないと、その人はあまりにも深い悲しみに押しつぶされてしまうかもしれません。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","そこで私は、その人に対する愛を確認することを、あなたがたに勧めます。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","私が手紙を書いたのは、あなたがたがすべてのことにおいて従順であるかどうかをためすためであったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","もしあなたがたが人を赦すなら、私もその人を赦します。私が何かを赦したのなら、私の赦したことは、あなたがたのために、キリストの御前で赦したのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","これは、私たちがサタンに欺かれないためです。私たちはサタンの策略を知らないわけではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","私が、キリストの福音のためにトロアスに行ったとき、主は私のために門を開いてくださいましたが、 ");
INSERT INTO jpn1965_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","兄弟テトスに会えなかったので、心に安らぎがなく、そこの人々に別れを告げて、マケドニヤへ向かいました。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","しかし、神に感謝します。神はいつでも、私たちを導いてキリストによる勝利の行列に加え、至る所で私たちを通して、キリストを知る知識のかおりを放ってくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","私たちは、救われる人々の中でも、滅びる人々の中でも、神の前にかぐわしいキリストのかおりなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ある人たちにとっては、死から出て死に至らせるかおりであり、ある人たちにとっては、いのちから出ていのちに至らせるかおりです。このような務めにふさわしい者は、いったいだれでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","私たちは、多くの人のように、神のことばに混ぜ物をして売るようなことはせず、真心から、また神によって、神の御前でキリストにあって語るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","私たちはまたもや自分を推薦しようとしているのでしょうか。それとも、ある人々のように、あなたがたにあてた推薦状とか、あなたがたの推薦状とかが、私たちに必要なのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","私たちの推薦状はあなたがたです。それは私たちの心にしるされていて、すべての人に知られ、また読まれているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","あなたがたが私たちの奉仕によるキリストの手紙であり、墨によってではなく、生ける神の御霊によって書かれ、石の板にではなく、人の心の板に書かれたものであることが明らかだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","私たちはキリストによって、神の御前でこういう確信を持っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","何事かを自分のしたことと考える資格が私たち自身にあるというのではありません。私たちの資格は神からのものです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","神は私たちに、新しい契約に仕える者となる資格を下さいました。文字に仕える者ではなく、御霊に仕える者です。文字は殺し、御霊は生かすからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","もし石に刻まれた文字による、死の務めにも栄光があって、モーセの顔の、やがて消え去る栄光のゆえにさえ、イスラエルの人々がモーセの顔を見つめることができなかったほどだとすれば、 ");
INSERT INTO jpn1965_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","まして、御霊の務めには、どれほどの栄光があることでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","罪に定める務めに栄光があるのなら、義とする務めには、なおさら、栄光があふれるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","そして、かつて栄光を受けたものは、このばあい、さらにすぐれた栄光のゆえに、栄光のないものになっているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","もし消え去るべきものにも栄光があったのなら、永続するものには、なおさら栄光があるはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","このような望みを持っているので、私たちはきわめて大胆に語ります。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","そして、モーセが、消えうせるものの最後をイスラエルの人々に見せないように、顔におおいを掛けたようなことはしません。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","しかし、イスラエルの人々の思いは鈍くなったのです。というのは、今日に至るまで、古い契約が朗読されるときに、同じおおいが掛けられたままで、取りのけられてはいません。なぜなら、それはキリストによって取り除かれるものだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","かえって、今日まで、モーセの書が朗読されるときはいつでも、彼らの心にはおおいが掛かっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","しかし、人が主に向くなら、そのおおいは取り除かれるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","主は御霊です。そして、主の御霊のあるところには自由があります。 ");
INSERT INTO jpn1965_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","私たちはみな、顔のおおいを取りのけられて、鏡のように主の栄光を反映させながら、栄光から栄光へと、主と同じかたちに姿を変えられて行きます。これはまさに、御霊なる主の働きによるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","こういうわけで、私たちは、あわれみを受けてこの務めに任じられているのですから、勇気を失うことなく、 ");
INSERT INTO jpn1965_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","恥ずべき隠された事を捨て、悪巧みに歩まず、神のことばを曲げず、真理を明らかにし、神の御前で自分自身をすべての人の良心に推薦しています。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","それでもなお私たちの福音におおいが掛かっているとしたら、それは、滅びる人々のばあいに、おおいが掛かっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","そのばあい、この世の神が不信者の思いをくらませて、神のかたちであるキリストの栄光にかかわる福音の光を輝かせないようにしているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","私たちは自分自身を宣べ伝えるのではなく、主なるキリスト・イエスを宣べ伝えます。私たち自身は、イエスのために、あなたがたに仕えるしもべなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","「光が、やみの中から輝き出よ。」と言われた神は、私たちの心を照らし、キリストの御顔にある神の栄光を知る知識を輝かせてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","私たちは、この宝を、土の器の中に入れているのです。それは、この測り知れない力が神のものであって、私たちから出たものでないことが明らかにされるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","私たちは、四方八方から苦しめられますが、窮することはありません。途方にくれていますが、行きづまることはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","迫害されていますが、見捨てられることはありません。倒されますが、滅びません。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","いつでもイエスの死をこの身に帯びていますが、それは、イエスのいのちが私たちの身において明らかに示されるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","私たち生きている者は、イエスのために絶えず死に渡されていますが、それは、イエスのいのちが私たちの死ぬべき肉体において明らかに示されるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","こうして、死は私たちのうちに働き、いのちはあなたがたのうちに働くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","「私は信じた。それゆえに語った。」と書いてあるとおり、それと同じ信仰の霊を持っている私たちも、信じているゆえに語るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","それは、主イエスをよみがえらせた方が、私たちをもイエスとともによみがえらせ、あなたがたといっしょに御前に立たせてくださることを知っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","すべてのことはあなたがたのためであり、それは、恵みがますます多くの人々に及んで感謝が満ちあふれ、神の栄光が現われるようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ですから、私たちは勇気を失いません。たとい私たちの外なる人は衰えても、内なる人は日々新たにされています。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","今の時の軽い患難は、私たちのうちに働いて、測り知れない、重い永遠の栄光をもたらすからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","私たちは、見えるものにではなく、見えないものにこそ目を留めます。見えるものは一時的であり、見えないものはいつまでも続くからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","私たちの住まいである地上の幕屋がこわれても、神の下さる建物があることを、私たちは知っています。それは、人の手によらない、天にある永遠の家です。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","私たちはこの幕屋にあってうめき、この天から与えられる住まいを着たいと望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","それを着たなら、私たちは裸の状態になることはないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","確かにこの幕屋の中にいる間は、私たちは重荷を負って、うめいています。それは、この幕屋を脱ぎたいと思うからでなく、かえって天からの住まいを着たいからです。そのことによって、死ぬべきものがいのちにのまれてしまうためにです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","私たちをこのことにかなう者としてくださった方は神です。神は、その保証として御霊を下さいました。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","そういうわけで、私たちはいつも心強いのです。ただし、私たちが肉体にいる間は、主から離れているということも知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","確かに、私たちは見るところによってではなく、信仰によって歩んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","私たちはいつも心強いのです。そして、むしろ肉体を離れて、主のみもとにいるほうがよいと思っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","そういうわけで、肉体の中にあろうと、肉体を離れていようと、私たちの念願とするところは、主に喜ばれることです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","なぜなら、私たちはみな、キリストのさばきの座に現われて、善であれ悪であれ、各自その肉体にあってした行為に応じて報いを受けることになるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","こういうわけで、私たちは、主を恐れることを知っているので、人々を説得しようとするのです。私たちのことは、神の御前に明らかです。しかし、あなたがたの良心にも明らかになることが、私の望みです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","私たちはまたも自分自身をあなたがたに推薦しようとするのではありません。ただ、私たちのことを誇る機会をあなたがたに与えて、心においてではなく、うわべのことで誇る人たちに答えることができるようにさせたいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","もし私たちが気が狂っているとすれば、それはただ神のためであり、もし正気であるとすれば、それはただあなたがたのためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","というのは、キリストの愛が私たちを取り囲んでいるからです。私たちはこう考えました。ひとりの人がすべての人のために死んだ以上、すべての人が死んだのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","また、キリストがすべての人のために死なれたのは、生きている人々が、もはや自分のためにではなく、自分のために死んでよみがえった方のために生きるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ですから、私たちは今後、人間的な標準で人を知ろうとはしません。かつては人間的な標準でキリストを知っていたとしても、今はもうそのような知り方はしません。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","だれでもキリストのうちにあるなら、その人は新しく造られた者です。古いものは過ぎ去って、見よ、すべてが新しくなりました。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","これらのことはすべて、神から出ているのです。神は、キリストによって、私たちをご自分と和解させ、また和解の務めを私たちに与えてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","すなわち、神は、キリストにあって、この世をご自分と和解させ、違反行為の責めを人々に負わせないで、和解のことばを私たちにゆだねられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","こういうわけで、私たちはキリストの使節なのです。ちょうど神が私たちを通して懇願しておられるようです。私たちは、キリストに代わって、あなたがたに願います。神の和解を受け入れなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","神は、罪を知らない方を、私たちの代わりに罪とされました。それは、私たちが、この方にあって、神の義となるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","私たちは神とともに働く者として、あなたがたに懇願します。神の恵みをむだに受けないようにしてください。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","神は言われます。 「わたしは、恵みの時にあなたに答え、 救いの日にあなたを助けた。」 確かに、今は恵みの時、今は救いの日です。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","私たちは、この務めがそしられないために、どんなことにも人につまずきを与えないようにと、 ");
INSERT INTO jpn1965_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","あらゆることにおいて、自分を神のしもべとして推薦しているのです。すなわち非常な忍耐と、悩みと、苦しみと、嘆きの中で、 ");
INSERT INTO jpn1965_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","また、むち打たれるときにも、入獄にも、暴動にも、労役にも、徹夜にも、断食にも、 ");
INSERT INTO jpn1965_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","また、純潔と知識と、寛容と親切と、聖霊と偽りのない愛と、 ");
INSERT INTO jpn1965_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","真理のことばと神の力とにより、また、左右の手に持っている義の武器により、 ");
INSERT INTO jpn1965_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","また、ほめられたり、そしられたり、悪評を受けたり、好評を博したりすることによって、自分を神のしもべとして推薦しているのです。私たちは人をだます者のように見えても、真実であり、 ");
INSERT INTO jpn1965_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","人に知られないようでも、よく知られ、死にそうでも、見よ、生きており、罰せられているようであっても、殺されず、 ");
INSERT INTO jpn1965_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","悲しんでいるようでも、いつも喜んでおり、貧しいようでも、多くの人を富ませ、何も持たないようでも、すべてのものを持っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","コリントの人たち。私たちはあなたがたに包み隠すことなく話しました。私たちの心は広く開かれています。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","あなたがたは、私たちの中で制約を受けているのではなく、自分の心で自分を窮屈にしているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","私は自分の子どもに対するように言います。それに報いて、あなたがたのほうでも心を広くしてください。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","不信者と、つり合わぬくびきをいっしょにつけてはいけません。正義と不法とに、どんなつながりがあるでしょう。光と暗やみとに、どんな交わりがあるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","キリストとベリアルとに、何の調和があるでしょう。信者と不信者とに、何のかかわりがあるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","神の宮と偶像とに、何の一致があるでしょう。私たちは生ける神の宮なのです。神はこう言われました。 「わたしは彼らの間に住み、また歩む。 わたしは彼らの神となり、 彼らはわたしの民となる。 ");
INSERT INTO jpn1965_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","それゆえ、彼らの中から出て行き、 彼らと分離せよ、と主は言われる。 汚れたものに触れないようにせよ。 そうすれば、わたしはあなたがたを受け入れ、 ");
INSERT INTO jpn1965_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","わたしはあなたがたの父となり、 あなたがたはわたしの息子、娘となる、 と全能の主が言われる。」 ");
INSERT INTO jpn1965_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","愛する者たち。私たちはこのような約束を与えられているのですから、いっさいの霊肉の汚れから自分をきよめ、神を恐れかしこんできよきを全うしようではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","私たちに対して心を開いてください。私たちは、だれにも不正をしたことがなく、だれをもそこなったことがなく、だれからも利をむさぼったことがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","責めるためにこう言うのではありません。前にも言ったように、あなたがたは、私たちとともに死に、ともに生きるために、私たちの心のうちにあるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","私のあなたがたに対する信頼は大きいのであって、私はあなたがたを大いに誇りとしています。私は慰めに満たされ、どんな苦しみの中にあっても喜びに満ちあふれています。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","マケドニヤに着いたとき、私たちの身には少しの安らぎもなく、さまざまの苦しみに会って、外には戦い、うちには恐れがありました。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","しかし、気落ちした者を慰めてくださる神は、テトスが来たことによって、私たちを慰めてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ただテトスが来たことばかりでなく、彼があなたがたから受けた慰めによっても、私たちは慰められたのです。あなたがたが私を慕っていること、嘆き悲しんでいること、また私に対して熱意を持っていてくれることを知らされて、私はますます喜びにあふれました。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","あの手紙によってあなたがたを悲しませたけれども、私はそれを悔いていません。あの手紙がしばらくの間であったにしろあなたがたを悲しませたのを見て、悔いたけれども、 ");
INSERT INTO jpn1965_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","今は喜んでいます。あなたがたが悲しんだからではなく、あなたがたが悲しんで悔い改めたからです。あなたがたは神のみこころに添って悲しんだので、私たちのために何の害も受けなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","神のみこころに添った悲しみは、悔いのない、救いに至る悔い改めを生じさせますが、世の悲しみは死をもたらします。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ご覧なさい。神のみこころに添ったその悲しみが、あなたがたのうちに、どれほどの熱心を起こさせたことでしょう。また、弁明、憤り、恐れ、慕う心、熱意を起こさせ、処罰を断行させたことでしょう。あの問題について、あなたがたは、自分たちがすべての点で潔白であることを証明したのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","ですから、私はあなたがたに手紙を書きましたが、それは悪を行なった人のためでもなく、その被害者のためでもなくて、私たちに対するあなたがたの熱心が、神の御前に明らかにされるためであったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","こういうわけですから、私たちは慰めを受けました。 この慰めの上にテトスの喜びが加わって、私たちはなおいっそう喜びました。テトスの心が、あなたがたすべてによって安らぎを与えられたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","私はテトスに、あなたがたのことを少しばかり誇りましたが、そのことで恥をかかずに済みました。というのは、私たちがあなたがたに語ったことがすべて真実であったように、テトスに対して誇ったことも真実となったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","彼は、あなたがたがみなよく言うことを聞き、恐れおののいて、自分を迎えてくれたことを思い出して、あなたがたへの愛情をますます深めています。 ");
INSERT INTO jpn1965_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","私は、あなたがたに全幅の信頼を寄せることができるのを喜んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","さて、兄弟たち。私たちは、マケドニヤの諸教会に与えられた神の恵みを、あなたがたに知らせようと思います。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","苦しみゆえの激しい試練の中にあっても、彼らの満ちあふれる喜びは、その極度の貧しさにもかかわらず、あふれ出て、その惜しみなく施す富となったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","私はあかしします。彼らは自ら進んで、力に応じ、いや力以上にささげ、 ");
INSERT INTO jpn1965_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","聖徒たちをささえる交わりの恵みにあずかりたいと、熱心に私たちに願ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","そして、私たちの期待以上に、神のみこころに従って、まず自分自身を主にささげ、また、私たちにもゆだねてくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","それで私たちは、テトスがすでにこの恵みのわざをあなたがたの間で始めていたのですから、それを完了させるよう彼に勧めたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","あなたがたは、すべてのことに、すなわち、信仰にも、ことばにも、知識にも、あらゆる熱心にも、私たちから出てあなたがたの間にある愛にも富んでいるように、この恵みのわざにも富むようになってください。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","こうは言っても、私は命令するのではありません。ただ、他の人々の熱心さをもって、あなたがた自身の愛の真実を確かめたいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","あなたがたは、私たちの主イエス・キリストの恵みを知っています。すなわち、主は富んでおられたのに、あなたがたのために貧しくなられました。それは、あなたがたが、キリストの貧しさによって富む者となるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","この献金のことについて、私の意見を述べましょう。それはあなたがたの益になることだからです。あなたがたは、このことを昨年から、他に先んじて行なっただけでなく、このことを他に先んじて願った人たちです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ですから、今、それをし遂げなさい。喜んでしようと思ったのですから、持っている物で、それをし遂げることができるはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","もし熱意があるならば、持たない物によってではなく、持っている程度に応じて、それは受納されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","私はこのことによって、他の人々には楽をさせ、あなたがたには苦労をさせようとしているのではなく、平等を図っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","今あなたがたの余裕が彼らの欠乏を補うなら、彼らの余裕もまた、あなたがたの欠乏を補うことになるのです。こうして、平等になるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","「多く集めた者も余るところがなく、少し集めた者も足りないところがなかった。」と書いてあるとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","私があなたがたのことを思うのと同じ熱心を、テトスの心にも与えてくださった神に感謝します。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","彼は私の勧めを受け入れ、非常な熱意をもって、自分から進んであなたがたのところに行こうとしています。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","また私たちは、テトスといっしょに、ひとりの兄弟を送ります。この人は、福音の働きによって、すべての教会で称賛されていますが、 ");
INSERT INTO jpn1965_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","そればかりでなく、彼は、この恵みのわざに携わっている私たちに同伴するよう諸教会の任命を受けたのです。私たちがこの働きをしているのは、主ご自身の栄光のため、また、私たちの誠意を示すためにほかなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","私たちは、この献金の取り扱いについて、だれからも非難されることがないように心がけています。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","それは、主の御前ばかりでなく、人の前でも公明正大なことを示そうと考えているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","また、彼らといっしょに、もうひとりの兄弟を送ります。私たちはこの兄弟が多くのことについて熱心であることを、しばしば認めることができました。彼は今、あなたがたに深い信頼を寄せ、ますます熱心になっています。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","テトスについて言えば、彼は私の仲間で、あなたがたの間での私の同労者です。兄弟たちについて言えば、彼らは諸教会の使者、キリストの栄光です。 ");
INSERT INTO jpn1965_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","ですから、あなたがたの愛と、私たちがあなたがたを誇りとしている証拠とを、諸教会の前で、彼らに示してほしいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","聖徒たちのためのこの奉仕については、いまさら、あなたがたに書き送る必要はないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","私はあなたがたの熱意を知り、それについて、あなたがたのことをマケドニヤの人々に誇って、アカヤでは昨年から準備が進められていると言ったのです。こうして、あなたがたの熱心は、多くの人を奮起させました。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","私が兄弟たちを送ることにしたのは、このばあい、私たちがあなたがたについて誇ったことがむだにならず、私が言っていたとおりに準備していてもらうためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","そうでないと、もしマケドニヤの人が私といっしょに行って、準備ができていないのを見たら、あなたがたはもちろんですが、私たちも、このことを確信していただけに、恥をかくことになるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","そこで私は、兄弟たちに勧めて、先にそちらに行かせ、前に約束したあなたがたの贈り物を前もって用意していただくことが必要だと思いました。どうか、この献金を、惜しみながらするのではなく、好意に満ちた贈り物として用意しておいてください。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","私はこう考えます。少しだけ蒔く者は、少しだけ刈り取り、豊かに蒔く者は、豊かに刈り取ります。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ひとりひとり、いやいやながらでなく、強いられてでもなく、心で決めたとおりにしなさい。神は喜んで与える人を愛してくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","神は、あなたがたを、常にすべてのことに満ち足りて、すべての良いわざにあふれる者とするために、あらゆる恵みをあふれるばかり与えることのできる方です。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","「この人は散らして、貧しい人々に与えた。 その義は永遠にとどまる。」 と書いてあるとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","蒔く人に種と食べるパンを備えてくださる方は、あなたがたにも蒔く種を備え、それをふやし、あなたがたの義の実を増し加えてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","あなたがたは、あらゆる点で豊かになって、惜しみなく与えるようになり、それが私たちを通して、神への感謝を生み出すのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","なぜなら、この奉仕のわざは、聖徒たちの必要を十分に満たすばかりでなく、神への多くの感謝を通して、満ちあふれるようになるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","このわざを証拠として、彼らは、あなたがたがキリストの福音の告白に対して従順であり、彼らに、またすべての人々に惜しみなく与えていることを知って、神をあがめることでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","また彼らは、あなたがたのために祈るとき、あなたがたに与えられた絶大な神の恵みのゆえに、あなたがたを慕うようになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","ことばに表わせないほどの賜物のゆえに、神に感謝します。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","さて、私パウロは、キリストの柔和と寛容をもって、あなたがたにお勧めします。私は、あなたがたの間にいて、面と向かっているときはおとなしく、離れているあなたがたに対しては強気な者です。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","しかし、私は、あなたがたのところに行くときには、私たちを肉に従って歩んでいるかのように考える人々に対して勇敢にふるまおうと思っているその確信によって、強気にふるまうことがなくて済むように願っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","私たちは肉にあって歩んではいても、肉に従って戦ってはいません。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","私たちの戦いの武器は、肉の物ではなく、神の御前で、要塞をも破るほどに力のあるものです。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","私たちは、さまざまの思弁と、神の知識に逆らって立つあらゆる高ぶりを打ち砕き、すべてのはかりごとをとりこにしてキリストに服従させ、 ");
INSERT INTO jpn1965_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","また、あなたがたの従順が完全になるとき、あらゆる不従順を罰する用意ができているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","あなたがたは、うわべのことだけを見ています。もし自分はキリストに属する者だと確信している人がいるなら、その人は、自分がキリストに属しているように、私たちもまたキリストに属しているということを、もう一度、自分でよく考えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","あなたがたを倒すためにではなく、立てるために主が私たちに授けられた権威については、たとい私が多少誇りすぎることがあっても、恥とはならないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","私は手紙であなたがたをおどしているかのように見られたくありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","彼らは言います。「パウロの手紙は重みがあって力強いが、実際に会ったばあいの彼は弱々しく、その話しぶりは、なっていない。」 ");
INSERT INTO jpn1965_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","そういう人はよく承知しておきなさい。離れているときに書く手紙のことばがそうなら、いっしょにいるときの行動もそのとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","私たちは、自己推薦をしているような人たちの中のだれかと自分を同列に置いたり、比較したりしようなどとは思いません。しかし、彼らが自分たちの間で自分を量ったり、比較したりしているのは、知恵のないことなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","私たちは、限度を越えて誇りはしません。私たちがあなたがたのところまで行くのも、神が私たちに量って割り当ててくださった限度内で行くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","私たちは、あなたがたのところまでは行かないのに無理に手を伸ばしているのではありません。事実、私たちは、キリストの福音を携えてあなたがたのところにまで行ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","私たちは、自分の限度を越えてほかの人の働きを誇ることはしません。ただ、あなたがたの信仰が成長し、あなたがたによって、私たちの領域内で私たちの働きが広げられることを望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","それは、私たちがあなたがたの向こうの地域にまで福音を宣べ伝えるためであって、決して他の人の領域でなされた働きを誇るためではないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","誇る者は、主にあって誇りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","自分で自分を推薦する人でなく、主に推薦される人こそ、受け入れられる人です。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","私の少しばかりの愚かさをこらえていただきたいと思います。いや、あなたがたはこらえているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","というのも、私は神の熱心をもって、熱心にあなたがたのことを思っているからです。私はあなたがたを、清純な処女として、ひとりの人の花嫁に定め、キリストにささげることにしたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","しかし、蛇が悪巧みによってエバを欺いたように、万一にもあなたがたの思いが汚されて、キリストに対する真実と貞潔を失うことがあってはと、私は心配しています。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","というわけは、ある人が来て、私たちの宣べ伝えなかった別のイエスを宣べ伝えたり、あるいはあなたがたが、前に受けたことのない異なった霊を受けたり、受け入れたことのない異なった福音を受けたりするときも、あなたがたはみごとにこらえているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","私は自分をあの大使徒たちに少しでも劣っているとは思いません。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","たとい、話は巧みでないにしても、知識についてはそうではありません。私たちは、すべての点で、いろいろなばあいに、そのことをあなたがたに示して来ました。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","それとも、あなたがたを高めるために、自分を低くして報酬を受けずに神の福音をあなたがたに宣べ伝えたことが、私の罪だったのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","私は他の諸教会から奪い取って、あなたがたに仕えるための給料を得たのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","あなたがたのところにいて困窮していたときも、私はだれにも負担をかけませんでした。マケドニヤから来た兄弟たちが、私の欠乏を十分に補ってくれたのです。私は、万事につけあなたがたの重荷にならないようにしましたし、今後もそうするつもりです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","私にあるキリストの真実にかけて言います。アカヤ地方で私のこの誇りが封じられることは決してありません。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","なぜでしょう。私があなたがたを愛していないからでしょうか。神はご存じです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","しかし、私は、今していることを今後も、し続けるつもりです。それは、私たちと同じように誇るところがあるとみなされる機会をねらっている者たちから、その機会を断ち切ってしまうためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","こういう者たちは、にせ使徒であり、人を欺く働き人であって、キリストの使徒に変装しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","しかし、驚くには及びません。サタンさえ光の御使いに変装するのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ですから、サタンの手下どもが義のしもべに変装したとしても、格別なことはありません。彼らの最後はそのしわざにふさわしいものとなります。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","くり返して言いますが、だれも、私を愚かと思ってはなりません。しかし、もしそう思うなら、私を愚か者扱いにしなさい。私も少し誇ってみせます。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","これから話すことは、主によって話すのではなく、愚か者としてする思い切った自慢話です。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","多くの人が肉によって誇っているので、私も誇ることにします。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","あなたがたは賢いのに、よくも喜んで愚か者たちをこらえています。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","事実、あなたがたは、だれかに奴隷にされても、食い尽くされても、だまされても、いばられても、顔をたたかれても、こらえているではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","言うのも恥ずかしいことですが、言わなければなりません。私たちは弱かったのです。しかし、人があえて誇ろうとすることなら、――私は愚かになって言いますが、――私もあえて誇りましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","彼らはヘブル人ですか。私もそうです。彼らはイスラエル人ですか。私もそうです。彼らはアブラハムの子孫ですか。私もそうです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","彼らはキリストのしもべですか。私は狂気したように言いますが、私は彼ら以上にそうなのです。私の労苦は彼らよりも多く、牢に入れられたことも多く、また、むち打たれたことは数えきれず、死に直面したこともしばしばでした。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","ユダヤ人から三十九のむちを受けたことが五度、 ");
INSERT INTO jpn1965_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","むちで打たれたことが三度、石で打たれたことが一度、難船したことが三度あり、一昼夜、海上を漂ったこともあります。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","幾度も旅をし、川の難、盗賊の難、同国民から受ける難、異邦人から受ける難、都市の難、荒野の難、海上の難、にせ兄弟の難に会い、 ");
INSERT INTO jpn1965_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","労し苦しみ、たびたび眠られぬ夜を過ごし、飢え渇き、しばしば食べ物もなく、寒さに凍え、裸でいたこともありました。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","このような外から来ることのほかに、日々私に押しかかるすべての教会への心づかいがあります。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","だれかが弱くて、私が弱くない、ということがあるでしょうか。だれかがつまずいていて、私の心が激しく痛まないでおられましょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","もしどうしても誇る必要があるなら、私は自分の弱さを誇ります。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","主イエス・キリストの父なる神、永遠にほめたたえられる方は、私が偽りを言っていないのをご存じです。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","ダマスコではアレタ王の代官が、私を捕えようとしてダマスコの町を監視しました。 ");
INSERT INTO jpn1965_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","そのとき私は、城壁の窓からかごでつり降ろされ、彼の手をのがれました。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","無益なことですが、誇るのもやむをえないことです。私は主の幻と啓示のことを話しましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","私はキリストにあるひとりの人を知っています。この人は十四年前に――肉体のままであったか、私は知りません。肉体を離れてであったか、それも知りません。神はご存じです。――第三の天にまで引き上げられました。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","私はこの人が、――それが肉体のままであったか、肉体を離れてであったかは知りません。神はご存じです。―― ");
INSERT INTO jpn1965_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","パラダイスに引き上げられて、人間には語ることを許されていない、口に出すことのできないことばを聞いたことを知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","このような人について私は誇るのです。しかし、私自身については、自分の弱さ以外には誇りません。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","たとい私が誇りたいと思ったとしても、愚か者にはなりません。真実のことを話すのだからです。しかし、誇ることは控えましょう。私について見ること、私から聞くこと以上に、人が私を過大に評価するといけないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","また、その啓示があまりにもすばらしいからです。そのために私は、高ぶることのないようにと、肉体に一つのとげを与えられました。それは私が高ぶることのないように、私を打つための、サタンの使いです。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","このことについては、これを私から去らせてくださるようにと、三度も主に願いました。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","しかし、主は、「わたしの恵みは、あなたに十分である。というのは、わたしの力は、弱さのうちに完全に現われるからである。」と言われたのです。ですから、私は、キリストの力が私をおおうために、むしろ大いに喜んで私の弱さを誇りましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ですから、私は、キリストのために、弱さ、侮辱、苦痛、迫害、困難に甘んじています。なぜなら、私が弱いときにこそ、私は強いからです。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","私は愚か者になりました。あなたがたが無理に私をそうしたのです。私は当然あなたがたの推薦を受けてよかったはずです。たとい私は取るに足りない者であっても、私はあの大使徒たちにどのような点でも劣るところはありませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","使徒としてのしるしは、忍耐を尽くしてあなたがたの間でなされた、あの奇蹟と不思議と力あるわざです。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","あなたがたが他の諸教会より劣っている点は何でしょうか。それは、私のほうであなたがたには負担をかけなかったことだけです。この不正については、どうか、赦してください。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","今、私はあなたがたのところに行こうとして、三度目の用意ができています。しかし、あなたがたに負担はかけません。私が求めているのは、あなたがたの持ち物ではなく、あなたがた自身だからです。子は親のためにたくわえる必要はなく、親が子のためにたくわえるべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","ですから、私はあなたがたのたましいのためには、大いに喜んで財を費やし、また私自身をさえ使い尽くしましょう。私があなたがたを愛すれば愛するほど、私はいよいよ愛されなくなるのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","あなたがたに重荷は負わせなかったにしても、私は、悪賢くて、あなたがたからだまし取ったのだと言われます。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","あなたがたのところに遣わした人たちのうちのだれによって、私があなたがたを欺くようなことがあったでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","私はテトスにそちらに行くように勧め、また、あの兄弟を同行させました。テトスはあなたがたを欺くようなことをしたでしょうか。私たちは同じ心で、同じ歩調で歩いたのではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","あなたがたは、前から、私たちがあなたがたに対して自己弁護をしているのだと思っていたことでしょう。しかし、私たちは神の御前で、キリストにあって語っているのです。愛する人たち。すべては、あなたがたを築き上げるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","私の恐れていることがあります。私が行ってみると、あなたがたは私の期待しているような者でなく、私もあなたがたの期待しているような者でないことになるのではないでしょうか。また、争い、ねたみ、憤り、党派心、そしり、陰口、高ぶり、騒動があるのではないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","私がもう一度行くとき、またも私の神が、あなたがたの面前で、私をはずかしめることはないでしょうか。そして私は、前から罪を犯していて、その行なった汚れと不品行と好色を悔い改めない多くの人たちのために、嘆くようなことにはならないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","私があなたがたのところへ行くのは、これで三度目です。すべての事実は、ふたりか三人の証人の口によって確認されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","私は二度目の滞在のときに前もって言っておいたのですが、こうして離れている今も、前から罪を犯している人たちとほかのすべての人たちに、あらかじめ言っておきます。今度そちらに行ったときには、容赦はしません。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","こう言うのは、あなたがたはキリストが私によって語っておられるという証拠を求めているからです。キリストはあなたがたに対して弱くはなく、あなたがたの間にあって強い方です。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","確かに、弱さのゆえに十字架につけられましたが、神の力のゆえに生きておられます。私たちもキリストにあって弱い者ですが、あなたがたに対する神の力のゆえに、キリストとともに生きているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","あなたがたは、信仰に立っているかどうか、自分自身をためし、また吟味しなさい。それとも、あなたがたのうちにはイエス・キリストがおられることを、自分で認めないのですか。――あなたがたがそれに不適格であれば別です。―― ");
INSERT INTO jpn1965_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","しかし、私たちは不適格でないことを、あなたがたが悟るように私は望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","私たちは、あなたがたがどんな悪をも行なわないように神に祈っています。それによって、私たち自身の適格であることが明らかになるというのではなく、たとい私たちは不適格のように見えても、あなたがたに正しい行ないをしてもらいたいためです。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","私たちは、真理に逆らっては何をすることもできず、真理のためなら、何でもできるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","私たちは、自分は弱くてもあなたがたが強ければ、喜ぶのです。私たちはあなたがたが完全な者になることを祈っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","そういうわけで、離れていてこれらのことを書いているのは、私が行ったとき、主が私に授けてくださった権威を用いて、きびしい処置をとることのないようにするためです。この権威が与えられたのは築き上げるためであって、倒すためではないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","終わりに、兄弟たち。喜びなさい。完全な者になりなさい。慰めを受けなさい。一つ心になりなさい。平和を保ちなさい。そうすれば、愛と平和の神はあなたがたとともにいてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","きよい口づけをもって、互いにあいさつをかわしなさい。すべての聖徒たちが、あなたがたによろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","主イエス・キリストの恵み、神の愛、聖霊の交わりが、あなたがたすべてとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","使徒となったパウロ――私が使徒となったのは、人間から出たことでなく、また人間の手を通したことでもなく、イエス・キリストと、キリストを死者の中からよみがえらせた父なる神によったのです。―― ");
INSERT INTO jpn1965_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","および私とともにいるすべての兄弟たちから、ガラテヤの諸教会へ。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","どうか、私たちの父なる神と主イエス・キリストから、恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","キリストは、今の悪の世界から私たちを救い出そうとして、私たちの罪のためにご自身をお捨てになりました。私たちの神であり父である方のみこころによったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","どうか、この神に栄光がとこしえにありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","私は、キリストの恵みをもってあなたがたを召してくださったその方を、あなたがたがそんなにも急に見捨てて、ほかの福音に移って行くのに驚いています。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ほかの福音といっても、もう一つ別に福音があるのではありません。あなたがたをかき乱す者たちがいて、キリストの福音を変えてしまおうとしているだけです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","しかし、私たちであろうと、天の御使いであろうと、もし私たちが宣べ伝えた福音に反することをあなたがたに宣べ伝えるなら、その者はのろわれるべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","私たちが前に言ったように、今もう一度私は言います。もしだれかが、あなたがたの受けた福音に反することを、あなたがたに宣べ伝えているなら、その者はのろわれるべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","いま私は人に取り入ろうとしているのでしょうか。いや。神に、でしょう。あるいはまた、人の歓心を買おうと努めているのでしょうか。もし私がいまなお人の歓心を買おうとするようなら、私はキリストのしもべとは言えません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","兄弟たちよ。私はあなたがたに知らせましょう。私が宣べ伝えた福音は、人間によるものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","私はそれを人間からは受けなかったし、また教えられもしませんでした。ただイエス・キリストの啓示によって受けたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","以前ユダヤ教徒であったころの私の行動は、あなたがたがすでに聞いているところです。私は激しく神の教会を迫害し、これを滅ぼそうとしました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","また私は、自分と同族で同年輩の多くの者たちに比べ、はるかにユダヤ教に進んでおり、先祖からの伝承に人一倍熱心でした。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","けれども、生まれたときから私を選び分け、恵みをもって召してくださった方が、 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","異邦人の間に御子を宣べ伝えさせるために、御子を私のうちに啓示することをよしとされたとき、私はすぐに、人には相談せず、 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","先輩の使徒たちに会うためにエルサレムにも上らず、アラビヤに出て行き、またダマスコに戻りました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","それから三年後に、私はケパをたずねてエルサレムに上り、彼のもとに十五日間滞在しました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","しかし、主の兄弟ヤコブは別として、ほかの使徒にはだれにも会いませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","私があなたがたに書いていることには、神の御前で申しますが、偽りはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","それから、私はシリヤおよびキリキヤの地方に行きました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","しかし、キリストにあるユダヤの諸教会には顔を知られていませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","けれども、「以前私たちを迫害した者が、そのとき滅ぼそうとした信仰を今は宣べ伝えている。」と聞いてだけはいたので、 ");
INSERT INTO jpn1965_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","彼らは私のことで神をあがめていました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","それから十四年たって、私は、バルナバといっしょに、テトスも連れて、再びエルサレムに上りました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","それは啓示によって上ったのです。そして、異邦人の間で私の宣べている福音を、人々の前に示し、おもだった人たちには個人的にそうしました。それは、私が力を尽くしていま走っていること、またすでに走ったことが、むだにならないためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","しかし、私といっしょにいたテトスでさえ、ギリシヤ人であったのに、割礼を強いられませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","実は、忍び込んだにせ兄弟たちがいたので、強いられる恐れがあったのです。彼らは私たちを奴隷に引き落とそうとして、キリスト・イエスにあって私たちの持つ自由をうかがうために忍び込んでいたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","私たちは彼らに一時も譲歩しませんでした。それは福音の真理があなたがたの間で常に保たれるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","そして、おもだった者と見られていた人たちからは、――彼らがどれほどの人たちであるにしても、私には問題ではありません。神は人を分け隔てなさいません。――そのおもだった人たちは、私に対して、何もつけ加えることをしませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","それどころか、ペテロが割礼を受けた者への福音をゆだねられているように、私が割礼を受けない者への福音をゆだねられていることを理解してくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","ペテロにみわざをなして、割礼を受けた者への使徒となさった方が、私にもみわざをなして、異邦人への使徒としてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","そして、私に与えられたこの恵みを認め、柱として重んじられているヤコブとケパとヨハネが、私とバルナバに、交わりのしるしとして右手を差し伸べました。それは、私たちが異邦人のところへ行き、彼らが割礼を受けた人々のところへ行くためです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ただ私たちが貧しい人たちをいつも顧みるようにとのことでしたが、そのことなら私も大いに努めて来たところです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ところが、ケパがアンテオケに来たとき、彼に非難すべきことがあったので、私は面と向かって抗議しました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","なぜなら、彼は、ある人々がヤコブのところから来る前は異邦人といっしょに食事をしていたのに、その人々が来ると、割礼派の人々を恐れて、だんだんと異邦人から身を引き、離れて行ったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","そして、ほかのユダヤ人たちも、彼といっしょに本心を偽った行動をとり、バルナバまでもその偽りの行動に引き込まれてしまいました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","しかし、彼らが福音の真理についてまっすぐに歩んでいないのを見て、私はみなの面前でケパにこう言いました。「あなたは、自分がユダヤ人でありながらユダヤ人のようには生活せず、異邦人のように生活していたのに、どうして異邦人に対して、ユダヤ人の生活を強いるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","私たちは、生まれながらのユダヤ人であって、異邦人のような罪人ではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","しかし、人は律法の行ないによっては義と認められず、ただキリスト・イエスを信じる信仰によって義と認められる、ということを知ったからこそ、私たちもキリスト・イエスを信じたのです。これは、律法の行ないによってではなく、キリストを信じる信仰によって義と認められるためです。なぜなら、律法の行ないによって義と認められる者は、ひとりもいないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","しかし、もし私たちが、キリストにあって義と認められようとすることによって、罪人となってしまうのなら、キリストは罪の助成者なのでしょうか。そんなことは絶対にありえないことです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","けれども、もし私が前に打ちこわしたものをもう一度建てるなら、私は自分自身を違反者にしてしまうのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","しかし私は、神に生きるために、律法によって律法に死にました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","私はキリストとともに十字架につけられました。もはや私が生きているのではなく、キリストが私のうちに生きておられるのです。いま私が、この世に生きているのは、私を愛し私のためにご自身をお捨てになった神の御子を信じる信仰によっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","私は神の恵みを無にはしません。もし義が律法によって得られるとしたら、それこそキリストの死は無意味です。」 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","ああ愚かなガラテヤ人。十字架につけられたイエス・キリストが、あなたがたの目の前に、あんなにはっきり示されたのに、だれがあなたがたを迷わせたのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ただこれだけをあなたがたから聞いておきたい。あなたがたが御霊を受けたのは、律法を行なったからですか。それとも信仰をもって聞いたからですか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","あなたがたはどこまで道理がわからないのですか。御霊で始まったあなたがたが、いま肉によって完成されるというのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","あなたがたがあれほどのことを経験したのは、むだだったのでしょうか。万が一にもそんなことはないでしょうが。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","とすれば、あなたがたに御霊を与え、あなたがたの間で奇蹟を行なわれた方は、あなたがたが律法を行なったから、そうなさったのですか。それともあなたがたが信仰をもって聞いたからですか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","アブラハムは神を信じ、それが彼の義とみなされました。それと同じことです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","ですから、信仰による人々こそアブラハムの子孫だと知りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","聖書は、神が異邦人をその信仰によって義と認めてくださることを、前から知っていたので、アブラハムに対し、「あなたによってすべての国民が祝福される。」と前もって福音を告げたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","そういうわけで、信仰による人々が、信仰の人アブラハムとともに、祝福を受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","というのは、律法の行ないによる人々はすべて、のろいのもとにあるからです。こう書いてあります。「律法の書に書いてある、すべてのことを堅く守って実行しなければ、だれでもみな、のろわれる。」 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","ところが、律法によって神の前に義と認められる者が、だれもいないということは明らかです。「義人は信仰によって生きる。」のだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","しかし律法は、「信仰による。」のではありません。「律法を行なう者はこの律法によって生きる。」のです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","キリストは、私たちのためにのろわれたものとなって、私たちを律法ののろいから贖い出してくださいました。なぜなら、「木にかけられる者はすべてのろわれたものである。」と書いてあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","このことは、アブラハムへの祝福が、キリスト・イエスによって異邦人に及ぶためであり、その結果、私たちが信仰によって約束の御霊を受けるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","兄弟たち。人間のばあいにたとえてみましょう。人間の契約でも、いったん結ばれたら、だれもそれを無効にしたり、それにつけ加えたりはしません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","ところで、約束は、アブラハムとそのひとりの子孫に告げられました。神は「子孫たちに」と言って、多数をさすことはせず、ひとりをさして、「あなたの子孫に」と言っておられます。その方はキリストです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","私の言おうとすることはこうです。先に神によって結ばれた契約は、その後四百三十年たってできた律法によって取り消されたり、その約束が無効とされたりすることがないということです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","なぜなら、相続がもし律法によるのなら、もはや約束によるのではないからです。ところが、神は約束を通してアブラハムに相続の恵みを下さったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","では、律法とは何でしょうか。それは約束をお受けになった、この子孫が来られるときまで、違反を示すためにつけ加えられたもので、御使いたちを通して仲介者の手で定められたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","仲介者は一方だけに属するものではありません。しかし約束を賜わる神は唯一者です。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","とすると、律法は神の約束に反するのでしょうか。絶対にそんなことはありません。もしも、与えられた律法がいのちを与えることのできるものであったなら、義は確かに律法によるものだったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","しかし聖書は、逆に、すべての人を罪の下に閉じ込めました。それは約束が、イエス・キリストに対する信仰によって、信じる人々に与えられるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","信仰が現われる以前には、私たちは律法の監督の下に置かれ、閉じ込められていましたが、それは、やがて示される信仰が得られるためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","こうして、律法は私たちをキリストへ導くための私たちの養育係となりました。私たちが信仰によって義と認められるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","しかし、信仰が現われた以上、私たちはもはや養育係の下にはいません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","あなたがたはみな、キリスト・イエスに対する信仰によって、神の子どもです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","バプテスマを受けてキリストにつく者とされたあなたがたはみな、キリストをその身に着たのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ユダヤ人もギリシヤ人もなく、奴隷も自由人もなく、男子も女子もありません。なぜなら、あなたがたはみな、キリスト・イエスにあって、一つだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","もしあなたがたがキリストのものであれば、それによってアブラハムの子孫であり、約束による相続人なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ところが、相続人というものは、全財産の持ち主なのに、子どものうちは、奴隷と少しも違わず、 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","父の定めた日までは、後見人や管理者の下にあります。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","私たちもそれと同じで、まだ小さかった時には、この世の幼稚な教えの下に奴隷となっていました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","しかし定めの時が来たので、神はご自分の御子を遣わし、この方を、女から生まれた者、また律法の下にある者となさいました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","これは律法の下にある者を贖い出すためで、その結果、私たちが子としての身分を受けるようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","そして、あなたがたは子であるゆえに、神は「アバ、父。」と呼ぶ、御子の御霊を、私たちの心に遣わしてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ですから、あなたがたはもはや奴隷ではなく、子です。子ならば、神による相続人です。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","しかし、神を知らなかった当時、あなたがたは本来は神でない神々の奴隷でした。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","ところが、今では神を知っているのに、いや、むしろ神に知られているのに、どうしてあの無力、無価値の幼稚な教えに逆戻りして、再び新たにその奴隷になろうとするのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","あなたがたは、各種の日と月と季節と年とを守っています。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","あなたがたのために私の労したことは、むだだったのではないか、と私はあなたがたのことを案じています。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","お願いです。兄弟たち。私のようになってください。私もあなたがたのようになったのですから。あなたがたは私に何一つ悪いことをしていません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","ご承知のとおり、私が最初あなたがたに福音を伝えたのは、私の肉体が弱かったためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","そして私の肉体には、あなたがたにとって試練となるものがあったのに、あなたがたは軽蔑したり、きらったりしないで、かえって神の御使いのように、またキリスト・イエスご自身であるかのように、私を迎えてくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","それなのに、あなたがたのあの喜びは、今どこにあるのですか。私はあなたがたのためにあかししますが、あなたがたは、もしできれば自分の目をえぐり出して私に与えたいとさえ思ったではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","それでは、私は、あなたがたに真理を語ったために、あなたがたの敵になったのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","あなたがたに対するあの人々の熱心は正しいものではありません。彼らはあなたがたを自分たちに熱心にならせようとして、あなたがたを福音の恵みから締め出そうとしているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","良いことで熱心に慕われるのは、いつであっても良いものです。それは私があなたがたといっしょにいるときだけではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","私の子どもたちよ。あなたがたのうちにキリストが形造られるまで、私は再びあなたがたのために産みの苦しみをしています。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","それで、今あなたがたといっしょにいることができたら、そしてこんな語調でなく話せたらと思います。あなたがたのことをどうしたらよいかと困っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","律法の下にいたいと思う人たちは、私に答えてください。あなたがたは律法の言うことを聞かないのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","そこには、アブラハムにふたりの子があって、ひとりは女奴隷から、ひとりは自由の女から生まれた、と書かれています。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","女奴隷の子は肉によって生まれ、自由の女の子は約束によって生まれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","このことには比喩があります。この女たちは二つの契約です。一つはシナイ山から出ており、奴隷となる子を産みます。その女はハガルです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","このハガルは、アラビヤにあるシナイ山のことで、今のエルサレムに当たります。なぜなら、彼女はその子どもたちとともに奴隷だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","しかし、上にあるエルサレムは自由であり、私たちの母です。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","すなわち、こう書いてあります。 「喜べ。子を産まない不妊の女よ。 声をあげて呼ばわれ。 産みの苦しみを知らない女よ。 夫に捨てられた女の産む子どもは、 夫のある女の産む子どもよりも多い。」 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","兄弟たちよ。あなたがたはイサクのように約束の子どもです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","しかし、かつて肉によって生まれた者が、御霊によって生まれた者を迫害したように、今もそのとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","しかし、聖書は何と言っていますか。「奴隷の女とその子どもを追い出せ。奴隷の女の子どもは決して自由の女の子どもとともに相続人になってはならない。」 ");
INSERT INTO jpn1965_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","こういうわけで、兄弟たちよ。私たちは奴隷の女の子どもではなく、自由の女の子どもです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","キリストは、自由を得させるために、私たちを解放してくださいました。ですから、あなたがたは、しっかり立って、またと奴隷のくびきを負わせられないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","よく聞いてください。このパウロがあなたがたに言います。もし、あなたがたが割礼を受けるなら、キリストは、あなたがたにとって、何の益もないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","割礼を受けるすべての人に、私は再びあかしします。その人は律法の全体を行なう義務があります。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","律法によって義と認められようとしているあなたがたは、キリストから離れ、恵みから落ちてしまったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","私たちは、信仰により、御霊によって、義をいただく望みを熱心に抱いているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","キリスト・イエスにあっては、割礼を受ける受けないは大事なことではなく、愛によって働く信仰だけが大事なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","あなたがたはよく走っていたのに、だれがあなたがたを妨げて、真理に従わなくさせたのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","そのような勧めは、あなたがたを召してくださった方から出たものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","わずかのパン種が、こねた粉の全体を発酵させるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","私は主にあって、あなたがたが少しも違った考えを持っていないと確信しています。しかし、あなたがたをかき乱す者は、だれであろうと、さばきを受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","兄弟たち。もし私が今でも割礼を宣べ伝えているなら、どうして今なお迫害を受けることがありましょう。それなら、十字架のつまずきは取り除かれているはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","あなたがたをかき乱す者どもは、いっそのこと不具になってしまうほうがよいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","兄弟たち。あなたがたは、自由を与えられるために召されたのです。ただ、その自由を肉の働く機会としないで、愛をもって互いに仕えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","律法の全体は、「あなたの隣人をあなた自身のように愛せよ。」という一語をもって全うされるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","もし互いにかみ合ったり、食い合ったりしているなら、お互いの間で滅ぼされてしまいます。気をつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","私は言います。御霊によって歩みなさい。そうすれば、決して肉の欲望を満足させるようなことはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","なぜなら、肉の願うことは御霊に逆らい、御霊は肉に逆らうからです。この二つは互いに対立していて、そのためあなたがたは、自分のしたいと思うことをすることができないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","しかし、御霊によって導かれるなら、あなたがたは律法の下にはいません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","肉の行ないは明白であって、次のようなものです。不品行、汚れ、好色、 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","偶像礼拝、魔術、敵意、争い、そねみ、憤り、党派心、分裂、分派、 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ねたみ、酩酊、遊興、そういった類のものです。前にもあらかじめ言ったように、私は今もあなたがたにあらかじめ言っておきます。こんなことをしている者たちが神の国を相続することはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","しかし、御霊の実は、愛、喜び、平安、寛容、親切、善意、誠実、 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","柔和、自制です。このようなものを禁ずる律法はありません。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","キリスト・イエスにつく者は、自分の肉を、さまざまの情欲や欲望とともに、十字架につけてしまったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","もし私たちが御霊によって生きるのなら、御霊に導かれて、進もうではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","互いにいどみ合ったり、そねみ合ったりして、虚栄に走ることのないようにしましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","兄弟たちよ。もしだれかがあやまちに陥ったなら、御霊の人であるあなたがたは、柔和な心でその人を正してあげなさい。また、自分自身も誘惑に陥らないように気をつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","互いの重荷を負い合い、そのようにしてキリストの律法を全うしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","だれでも、りっぱでもない自分を何かりっぱでもあるかのように思うなら、自分を欺いているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","おのおの自分の行ないをよく調べてみなさい。そうすれば、誇れると思ったことも、ただ自分だけの誇りで、ほかの人に対して誇れることではないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","人にはおのおの、負うべき自分自身の重荷があるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","みことばを教えられる人は、教える人とすべての良いものを分け合いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","思い違いをしてはいけません。神は侮られるような方ではありません。人は種を蒔けば、その刈り取りもすることになります。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","自分の肉のために蒔く者は、肉から滅びを刈り取り、御霊のために蒔く者は、御霊から永遠のいのちを刈り取るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","善を行なうのに飽いてはいけません。失望せずにいれば、時期が来て、刈り取ることになります。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ですから、私たちは、機会のあるたびに、すべての人に対して、特に信仰の家族の人たちに善を行ないましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","ご覧のとおり、私は今こんなに大きな字で、自分のこの手であなたがたに書いています。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","あなたがたに割礼を強制する人たちは、肉において外見を良くしたい人たちです。彼らはただ、キリストの十字架のために迫害を受けたくないだけなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","なぜなら、割礼を受けた人たちは、自分自身が律法を守っていません。それなのに彼らがあなたがたに割礼を受けさせようとするのは、あなたがたの肉を誇りたいためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","しかし私には、私たちの主イエス・キリストの十字架以外に誇りとするものが決してあってはなりません。この十字架によって、世界は私に対して十字架につけられ、私も世界に対して十字架につけられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","割礼を受けているか受けていないかは、大事なことではありません。大事なのは新しい創造です。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","どうか、この基準に従って進む人々、すなわち神のイスラエルの上に、平安とあわれみがありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","これからは、だれも私を煩わさないようにしてください。私は、この身に、イエスの焼き印を帯びているのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","どうか、私たちの主イエス・キリストの恵みが、兄弟たちよ、あなたがたの霊とともにありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","神のみこころによるキリスト・イエスの使徒パウロから、キリスト・イエスにある忠実なエペソの聖徒たちへ。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","私たちの父なる神と主イエス・キリストから、恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","私たちの主イエス・キリストの父なる神がほめたたえられますように。神はキリストにおいて、天にあるすべての霊的祝福をもって私たちを祝福してくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","すなわち、神は私たちを世界の基の置かれる前からキリストのうちに選び、御前できよく、傷のない者にしようとされました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","神は、ただみこころのままに、私たちをイエス・キリストによってご自分の子にしようと、愛をもってあらかじめ定めておられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","それは、神がその愛する方によって私たちに与えてくださった恵みの栄光が、ほめたたえられるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","私たちは、この御子のうちにあって、御子の血による贖い、すなわち罪の赦しを受けているのです。これは神の豊かな恵みによることです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","神はこの恵みを私たちの上にあふれさせ、あらゆる知恵と思慮深さをもって、 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","みこころの奥義を私たちに知らせてくださいました。それは、神が御子においてあらかじめお立てになったご計画によることであって、 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","時がついに満ちて、この時のためのみこころが実行に移され、天にあるものも地にあるものも、いっさいのものが、キリストにあって一つに集められることなのです。このキリストにあって、 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","私たちは彼にあって御国を受け継ぐ者ともなったのです。私たちは、みこころによりご計画のままをみな実現される方の目的に従って、このようにあらかじめ定められていたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","それは、前からキリストに望みを置いていた私たちが、神の栄光をほめたたえる者となるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","またあなたがたも、キリストにあって、真理のことば、すなわちあなたがたの救いの福音を聞き、またそれを信じたことによって、約束の聖霊をもって証印を押されました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","聖霊は私たちが御国を受け継ぐことの保証であられます。これは神の民の贖いのためであり、神の栄光がほめたたえられるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","こういうわけで、私は主イエスに対するあなたがたの信仰と、すべての聖徒に対する愛とを聞いて、 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","あなたがたのために絶えず感謝をささげ、あなたがたのことを覚えて祈っています。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","どうか、私たちの主イエス・キリストの神、すなわち栄光の父が、神を知るための知恵と啓示の御霊を、あなたがたに与えてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","また、あなたがたの心の目がはっきり見えるようになって、神の召しによって与えられる望みがどのようなものか、聖徒の受け継ぐものがどのように栄光に富んだものか、 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","また、神の全能の力の働きによって私たち信じる者に働く神のすぐれた力がどのように偉大なものであるかを、あなたがたが知ることができますように。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","神は、その全能の力をキリストのうちに働かせて、キリストを死者の中からよみがえらせ、天上においてご自分の右の座に着かせて、 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","すべての支配、権威、権力、主権の上に、また、今の世ばかりでなく、次に来る世においてもとなえられる、すべての名の上に高く置かれました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","また、神は、いっさいのものをキリストの足の下に従わせ、いっさいのものの上に立つかしらであるキリストを、教会にお与えになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","教会はキリストのからだであり、いっさいのものをいっさいのものによって満たす方の満ちておられるところです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","あなたがたは自分の罪過と罪との中に死んでいた者であって、 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","そのころは、それらの罪の中にあってこの世の流れに従い、空中の権威を持つ支配者として今も不従順の子らの中に働いている霊に従って、歩んでいました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","私たちもみな、かつては不従順の子らの中にあって、自分の肉の欲の中に生き、肉と心の望むままを行ない、ほかの人たちと同じように、生まれながら御怒りを受けるべき子らでした。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","しかし、あわれみ豊かな神は、私たちを愛してくださったその大きな愛のゆえに、 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","罪過の中に死んでいたこの私たちをキリストとともに生かし、――あなたがたが救われたのは、ただ恵みによるのです。―― ");
INSERT INTO jpn1965_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","キリスト・イエスにおいて、ともによみがえらせ、ともに天の所にすわらせてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","それは、あとに来る世々において、このすぐれて豊かな御恵みを、キリスト・イエスにおいて私たちに賜わる慈愛によって明らかにお示しになるためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","あなたがたは、恵みのゆえに、信仰によって救われたのです。それは、自分自身から出たことではなく、神からの賜物です。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","行ないによるのではありません。だれも誇ることのないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","私たちは神の作品であって、良い行ないをするためにキリスト・イエスにあって造られたのです。神は、私たちが良い行ないに歩むように、その良い行ないをもあらかじめ備えてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ですから、思い出してください。あなたがたは、以前は肉において異邦人でした。すなわち、肉において人の手による、いわゆる割礼を持つ人々からは、無割礼の人々と呼ばれる者であって、 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","そのころのあなたがたは、キリストから離れ、イスラエルの国から除外され、約束の契約については他国人であり、この世にあって望みもなく、神もない人たちでした。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","しかし、以前は遠く離れていたあなたがたも、今ではキリスト・イエスの中にあることにより、キリストの血によって近い者とされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","キリストこそ私たちの平和であり、二つのものを一つにし、隔ての壁を打ちこわし、 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","ご自分の肉において、敵意を廃棄された方です。敵意とは、さまざまの規定から成り立っている戒めの律法なのです。このことは、二つのものをご自身において新しいひとりの人に造り上げて、平和を実現するためであり、 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","また、両者を一つのからだとして、十字架によって神と和解させるためなのです。敵意は十字架によって葬り去られました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","それからキリストは来られて、遠くにいたあなたがたに平和を宣べ、近くにいた人たちにも平和を宣べられました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","私たちは、このキリストによって、両者ともに一つの御霊において、父のみもとに近づくことができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","こういうわけで、あなたがたは、もはや他国人でも寄留者でもなく、今は聖徒たちと同じ国民であり、神の家族なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","あなたがたは使徒と預言者という土台の上に建てられており、キリスト・イエスご自身がその礎石です。 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","この方にあって、組み合わされた建物の全体が成長し、主にある聖なる宮となるのであり、 ");
INSERT INTO jpn1965_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","このキリストにあって、あなたがたもともに建てられ、御霊によって神の御住まいとなるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","こういうわけで、あなたがた異邦人のためにキリスト・イエスの囚人となった私パウロが言います。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","あなたがたのためにと私がいただいた、神の恵みによる私の務めについて、あなたがたはすでに聞いたことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","先に簡単に書いたとおり、この奥義は、啓示によって私に知らされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","それを読めば、私がキリストの奥義をどう理解しているかがよくわかるはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","この奥義は、今は、御霊によって、キリストの聖なる使徒たちと預言者たちに啓示されていますが、前の時代には、今と同じようには人々に知らされていませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","その奥義とは、福音により、キリスト・イエスにあって、異邦人もまた共同の相続者となり、ともに一つのからだに連なり、ともに約束にあずかる者となるということです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","私は、神の力の働きにより、自分に与えられた神の恵みの賜物によって、この福音に仕える者とされました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","すべての聖徒たちのうちで一番小さな私に、この恵みが与えられたのは、私がキリストの測りがたい富を異邦人に宣べ伝え、 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","また、万物を創造された神の中に世々隠されていた奥義を実行に移す務めが何であるかを明らかにするためにほかなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","これは、今、天にある支配と権威とに対して、教会を通して、神の豊かな知恵が示されるためであって、 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","私たちの主キリスト・イエスにおいて実現された神の永遠のご計画に沿ったことです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","私たちはこのキリストにあり、キリストを信じる信仰によって大胆に確信をもって神に近づくことができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","ですから、私があなたがたのために受けている苦難のゆえに落胆することのないようお願いします。私の受けている苦しみは、そのまま、あなたがたの光栄なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","こういうわけで、私はひざをかがめて、 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","天上と地上で家族と呼ばれるすべてのものの名の元である父の前に祈ります。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","どうか父が、その栄光の豊かさに従い、御霊により、力をもって、あなたがたの内なる人を強くしてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","こうしてキリストが、あなたがたの信仰によって、あなたがたの心のうちに住んでいてくださいますように。また、愛に根ざし、愛に基礎を置いているあなたがたが、 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","すべての聖徒とともに、その広さ、長さ、高さ、深さがどれほどであるかを理解する力を持つようになり、 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","人知をはるかに越えたキリストの愛を知ることができますように。こうして、神ご自身の満ち満ちたさまにまで、あなたがたが満たされますように。 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","どうか、私たちのうちに働く力によって、私たちの願うところ、思うところのすべてを越えて豊かに施すことのできる方に、 ");
INSERT INTO jpn1965_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","教会により、またキリスト・イエスにより、栄光が、世々にわたって、とこしえまでありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","さて、主の囚人である私はあなたがたに勧めます。召されたあなたがたは、その召しにふさわしく歩みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","謙遜と柔和の限りを尽くし、寛容を示し、愛をもって互いに忍び合い、 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","平和のきずなで結ばれて御霊の一致を熱心に保ちなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","からだは一つ、御霊は一つです。あなたがたが召されたとき、召しのもたらした望みが一つであったのと同じです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","主は一つ、信仰は一つ、バプテスマは一つです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","すべてのものの上にあり、すべてのものを貫き、すべてのもののうちにおられる、すべてのものの父なる神は一つです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","しかし、私たちはひとりひとり、キリストの賜物の量りに従って恵みを与えられました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","そこで、こう言われています。 「高い所に上られたとき、 彼は多くの捕虜を引き連れ、 人々に賜物を分け与えられた。」 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","――この「上られた。」ということばは、彼がまず地の低い所に下られた、ということでなくて何でしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","この下られた方自身が、すべてのものを満たすために、もろもろの天よりも高く上られた方なのです。―― ");
INSERT INTO jpn1965_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","こうして、キリストご自身が、ある人を使徒、ある人を預言者、ある人を伝道者、ある人を牧師また教師として、お立てになったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","それは、聖徒たちを整えて奉仕の働きをさせ、キリストのからだを建て上げるためであり、 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ついに、私たちがみな、信仰の一致と神の御子に関する知識の一致とに達し、完全におとなになって、キリストの満ち満ちた身たけにまで達するためです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","それは、私たちがもはや、子どもではなくて、人の悪巧みや、人を欺く悪賢い策略により、教えの風に吹き回されたり、波にもてあそばれたりすることがなく、 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","むしろ、愛をもって真理を語り、あらゆる点において成長し、かしらなるキリストに達することができるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","キリストによって、からだ全体は、一つ一つの部分がその力量にふさわしく働く力により、また、備えられたあらゆる結び目によって、しっかりと組み合わされ、結び合わされ、成長して、愛のうちに建てられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","そこで私は、主にあって言明し、おごそかに勧めます。もはや、異邦人がむなしい心で歩んでいるように歩んではなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","彼らは、その知性において暗くなり、彼らのうちにある無知と、かたくなな心とのゆえに、神のいのちから遠く離れています。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","道徳的に無感覚となった彼らは、好色に身をゆだねて、あらゆる不潔な行ないをむさぼるようになっています。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","しかし、あなたがたはキリストのことを、このようには学びませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ただし、ほんとうにあなたがたがキリストに聞き、キリストにあって教えられているのならばです。まさしく真理はイエスにあるのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","その教えとは、あなたがたの以前の生活について言うならば、人を欺く情欲によって滅びて行く古い人を脱ぎ捨てるべきこと、 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","またあなたがたが心の霊において新しくされ、 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","真理に基づく義と聖をもって神にかたどり造り出された、新しい人を身に着るべきことでした。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ですから、あなたがたは偽りを捨て、おのおの隣人に対して真実を語りなさい。私たちはからだの一部分として互いにそれぞれのものだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","怒っても、罪を犯してはなりません。日が暮れるまで憤ったままでいてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","悪魔に機会を与えないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","盗みをしている者は、もう盗んではいけません。かえって、困っている人に施しをするため、自分の手をもって正しい仕事をし、ほねおって働きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","悪いことばを、いっさい口から出してはいけません。ただ、必要なとき、人の徳を養うのに役立つことばを話し、聞く人に恵みを与えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","神の聖霊を悲しませてはいけません。あなたがたは、贖いの日のために、聖霊によって証印を押されているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","無慈悲、憤り、怒り、叫び、そしりなどを、いっさいの悪意とともに、みな捨て去りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","お互いに親切にし、心の優しい人となり、神がキリストにおいてあなたがたを赦してくださったように、互いに赦し合いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ですから、愛されている子どもらしく、神にならう者となりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","また、愛のうちに歩みなさい。キリストもあなたがたを愛して、私たちのために、ご自身を神へのささげ物、また供え物とし、香ばしいかおりをおささげになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","あなたがたの間では、聖徒にふさわしく、不品行も、どんな汚れも、またむさぼりも、口にすることさえいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","また、みだらなことや、愚かな話や、下品な冗談を避けなさい。そのようなことは良くないことです。むしろ、感謝しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","あなたがたがよく見て知っているとおり、不品行な者や、汚れた者や、むさぼる者――これが偶像礼拝者です。――こういう人はだれも、キリストと神との御国を相続することができません。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","むなしいことばに、だまされてはいけません。こういう行ないのゆえに、神の怒りは不従順な子らに下るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","ですから、彼らの仲間になってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","あなたがたは、以前は暗やみでしたが、今は、主にあって、光となりました。光の子どもらしく歩みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","――光の結ぶ実は、あらゆる善意と正義と真実なのです。―― ");
INSERT INTO jpn1965_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","そのためには、主に喜ばれることが何であるかを見分けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","実を結ばない暗やみのわざに仲間入りしないで、むしろ、それを明るみに出しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","なぜなら、彼らがひそかに行なっていることは、口にするのも恥ずかしいことだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","けれども、明るみに引き出されるものは、みな、光によって明らかにされます。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","明らかにされたものはみな、光だからです。それで、こう言われています。 「眠っている人よ。目をさませ。 死者の中から起き上がれ。 そうすれば、キリストが、あなたを照らされる。」 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","そういうわけですから、賢くない人のようにではなく、賢い人のように歩んでいるかどうか、よくよく注意し、 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","機会を十分に生かして用いなさい。悪い時代だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","ですから、愚かにならないで、主のみこころは何であるかを、よく悟りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","また、酒に酔ってはいけません。そこには放蕩があるからです。御霊に満たされなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","詩と賛美と霊の歌とをもって、互いに語り、主に向かって、心から歌い、また賛美しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","いつでも、すべてのことについて、私たちの主イエス・キリストの名によって父なる神に感謝しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","キリストを恐れ尊んで、互いに従いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","妻たちよ。あなたがたは、主に従うように、自分の夫に従いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","なぜなら、キリストは教会のかしらであって、ご自身がそのからだの救い主であられるように、夫は妻のかしらであるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","教会がキリストに従うように、妻も、すべてのことにおいて、夫に従うべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","夫たちよ。キリストが教会を愛し、教会のためにご自身をささげられたように、あなたがたも、自分の妻を愛しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","キリストがそうされたのは、みことばにより、水の洗いをもって、教会をきよめて聖なるものとするためであり、 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ご自身で、しみや、しわや、そのようなものの何一つない、きよく傷のないものとなった栄光の教会を、ご自分の前に立たせるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","そのように、夫も自分の妻を自分のからだのように愛さなければなりません。自分の妻を愛する者は自分を愛しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","だれも自分の身を憎んだ者はいません。かえって、これを養い育てます。それはキリストが教会をそうされたのと同じです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","私たちはキリストのからだの部分だからです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","「それゆえ、人はその父と母を離れ、妻と結ばれ、ふたりは一心同体となる。」 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","この奥義は偉大です。私は、キリストと教会とをさして言っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","それはそうとして、あなたがたも、おのおの自分の妻を自分と同様に愛しなさい。妻もまた自分の夫を敬いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","子どもたちよ。主にあって両親に従いなさい。これは正しいことだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","「あなたの父と母を敬え。」これは第一の戒めであり、約束を伴ったものです。すなわち、 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","「そうしたら、あなたはしあわせになり、地上で長生きする。」という約束です。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","父たちよ。あなたがたも、子どもをおこらせてはいけません。かえって、主の教育と訓戒によって育てなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","奴隷たちよ。あなたがたは、キリストに従うように、恐れおののいて真心から地上の主人に従いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","人のごきげんとりのような、うわべだけの仕え方でなく、キリストのしもべとして、心から神のみこころを行ない、 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","人にではなく、主に仕えるように、善意をもって仕えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","良いことを行なえば、奴隷であっても自由人であっても、それぞれその報いを主から受けることをあなたがたは知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","主人たちよ。あなたがたも、奴隷に対して同じようにふるまいなさい。おどすことはやめなさい。あなたがたは、彼らとあなたがたとの主が天におられ、主は人を差別されることがないことを知っているのですから。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","終わりに言います。主にあって、その大能の力によって強められなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","悪魔の策略に対して立ち向かうことができるために、神のすべての武具を身に着けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","私たちの格闘は血肉に対するものではなく、主権、力、この暗やみの世界の支配者たち、また、天にいるもろもろの悪霊に対するものです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","ですから、邪悪な日に際して対抗できるように、また、いっさいを成し遂げて、堅く立つことができるように、神のすべての武具をとりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","では、しっかりと立ちなさい。腰には真理の帯を締め、胸には正義の胸当てを着け、 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","足には平和の福音の備えをはきなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","これらすべてのものの上に、信仰の大盾を取りなさい。それによって、悪い者が放つ火矢を、みな消すことができます。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","救いのかぶとをかぶり、また御霊の与える剣である、神のことばを受け取りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","すべての祈りと願いを用いて、どんなときにも御霊によって祈りなさい。そのためには絶えず目をさましていて、すべての聖徒のために、忍耐の限りを尽くし、また祈りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","また、私が口を開くとき、語るべきことばが与えられ、福音の奥義を大胆に知らせることができるように私のためにも祈ってください。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","私は鎖につながれて、福音のために大使の役を果たしています。鎖につながれていても、語るべきことを大胆に語れるように、祈ってください。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","あなたがたにも私の様子や、私が何をしているかなどを知っていただくために、主にあって愛する兄弟であり、忠実な奉仕者であるテキコが、一部始終を知らせるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","テキコをあなたがたのもとに遣わしたのは、ほかでもなく、あなたがたが私たちの様子を知り、また彼によって心に励ましを受けるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","どうか、父なる神と主イエス・キリストから、平安と信仰に伴う愛とが兄弟たちの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","私たちの主イエス・キリストを朽ちぬ愛をもって愛するすべての人の上に、恵みがありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","キリスト・イエスのしもべであるパウロとテモテから、ピリピにいるキリスト・イエスにあるすべての聖徒たち、また監督と執事たちへ。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","どうか、私たちの父なる神と主イエス・キリストから、恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","私は、あなたがたのことを思うごとに私の神に感謝し、 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","あなたがたすべてのために祈るごとに、いつも喜びをもって祈り、 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","あなたがたが、最初の日から今日まで、福音を広めることにあずかって来たことを感謝しています。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","あなたがたのうちに良い働きを始められた方は、キリスト・イエスの日が来るまでにそれを完成させてくださることを私は堅く信じているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","私があなたがたすべてについてこのように考えるのは正しいのです。あなたがたはみな、私が投獄されているときも、福音を弁明し立証しているときも、私とともに恵みにあずかった人々であり、私は、そのようなあなたがたを、心に覚えているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","私が、キリスト・イエスの愛の心をもって、どんなにあなたがたすべてを慕っているか、そのあかしをしてくださるのは神です。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","私は祈っています。あなたがたの愛が真の知識とあらゆる識別力によって、いよいよ豊かになり、 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","あなたがたが、真にすぐれたものを見分けることができるようになりますように。またあなたがたが、キリストの日には純真で非難されるところがなく、 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","イエス・キリストによって与えられる義の実に満たされている者となり、神の御栄えと誉れが現わされますように。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","さて、兄弟たち。私の身に起こったことが、かえって福音を前進させることになったのを知ってもらいたいと思います。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","私がキリストのゆえに投獄されている、ということは、親衛隊の全員と、そのほかのすべての人にも明らかになり、 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","また兄弟たちの大多数は、私が投獄されたことにより、主にあって確信を与えられ、恐れることなく、ますます大胆に神のことばを語るようになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","人々の中にはねたみや争いをもってキリストを宣べ伝える者もいますが、善意をもってする者もいます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","一方の人たちは愛をもってキリストを伝え、私が福音を弁証するために立てられていることを認めていますが、 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","他の人たちは純真な動機からではなく、党派心をもって、キリストを宣べ伝えており、投獄されている私をさらに苦しめるつもりなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","すると、どういうことになりますか。つまり、見せかけであろうとも、真実であろうとも、あらゆるしかたで、キリストが宣べ伝えられているのであって、このことを私は喜んでいます。そうです、今からも喜ぶことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","というわけは、あなたがたの祈りとイエス・キリストの御霊の助けによって、このことが私の救いとなることを私は知っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","それは、私がどういうばあいにも恥じることなく、いつものように今も大胆に語って、生きるにしても、死ぬにしても、私の身によって、キリストのすばらしさが現わされることを求める私の切なる願いと望みにかなっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","私にとっては、生きることはキリスト、死ぬこともまた益です。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","しかし、もしこの肉体のいのちが続くとしたら、私の働きが豊かな実を結ぶことになるので、どちらを選んだらよいのか、私にはわかりません。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","私は、その二つのものの間に板ばさみとなっています。私の願いは、世を去ってキリストとともにいることです。実はそのほうが、はるかにまさっています。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","しかし、この肉体にとどまることが、あなたがたのためには、もっと必要です。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","私はこのことを確信していますから、あなたがたの信仰の進歩と喜びとのために、私が生きながらえて、あなたがたすべてといっしょにいるようになることを知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","そうなれば、私はもう一度あなたがたのところに行けるので、私のことに関するあなたがたの誇りは、キリスト・イエスにあって増し加わるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ただ、キリストの福音にふさわしく生活しなさい。そうすれば、私が行ってあなたがたに会うにしても、また離れているにしても、私はあなたがたについて、こう聞くことができるでしょう。あなたがたは霊を一つにしてしっかりと立ち、心を一つにして福音の信仰のために、ともに奮闘しており、 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","また、どんなことがあっても、反対者たちに驚かされることはないと。それは、彼らにとっては滅びのしるしであり、あなたがたにとっては救いのしるしです。これは神から出たことです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","あなたがたは、キリストのために、キリストを信じる信仰だけでなく、キリストのための苦しみをも賜わったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","あなたがたは、私について先に見たこと、また、私についていま聞いているのと同じ戦いを経験しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","こういうわけですから、もしキリストにあって励ましがあり、愛の慰めがあり、御霊の交わりがあり、愛情とあわれみがあるなら、 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","私の喜びが満たされるように、あなたがたは一致を保ち、同じ愛の心を持ち、心を合わせ、志を一つにしてください。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","何事でも自己中心や虚栄からすることなく、へりくだって、互いに人を自分よりもすぐれた者と思いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","自分のことだけではなく、他の人のことも顧みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","あなたがたの間では、そのような心構えでいなさい。それはキリスト・イエスのうちにも見られるものです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","キリストは、神の御姿であられる方なのに、神のあり方を捨てることができないとは考えないで、 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ご自分を無にして、仕える者の姿をとり、人間と同じようになられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","キリストは人間と同じようなかたちになり、自分を卑しくし、死にまで従い、実に十字架の死にまでも従われたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","それゆえ、神は、キリストを高く上げて、すべての名にまさる名をお与えになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","それは、イエスの御名によって、天にあるもの、地にあるもの、地の下にあるもののすべてが、ひざをかがめ、 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","すべての口が、「イエス・キリストは主である。」と告白して、父なる神がほめたたえられるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","そういうわけですから、愛する人たち、いつも従順であったように、私がいるときだけでなく、私のいない今はなおさら、恐れおののいて自分の救いを達成してください。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","神は、みこころのままに、あなたがたのうちに働いて志を立てさせ、事を行なわせてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","すべてのことを、つぶやかず、疑わずに行ないなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","それは、あなたがたが、非難されるところのない純真な者となり、また、曲がった邪悪な世代の中にあって傷のない神の子どもとなり、 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","いのちのことばをしっかり握って、彼らの間で世の光として輝くためです。そうすれば、私は、自分の努力したことがむだではなく、苦労したこともむだでなかったことを、キリストの日に誇ることができます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","たとい私が、あなたがたの信仰の供え物と礼拝とともに、注ぎの供え物となっても、私は喜びます。あなたがたすべてとともに喜びます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","あなたがたも同じように喜んでください。私といっしょに喜んでください。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","しかし、私もあなたがたのことを知って励ましを受けたいので、早くテモテをあなたがたのところに送りたいと、主イエスにあって望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","テモテのように私と同じ心になって、真実にあなたがたのことを心配している者は、ほかにだれもいないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","だれもみな自分自身のことを求めるだけで、キリスト・イエスのことを求めてはいません。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","しかし、テモテのりっぱな働きぶりは、あなたがたの知っているところです。子が父に仕えるようにして、彼は私といっしょに福音に奉仕して来ました。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","ですから、私のことがどうなるかがわかりしだい、彼を遣わしたいと望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","しかし私自身も近いうちに行けることと、主にあって確信しています。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","しかし、私の兄弟、同労者、戦友、またあなたがたの使者として私の窮乏のときに仕えてくれた人エパフロデトは、あなたがたのところに送らねばならないと思っています。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","彼は、あなたがたすべてを慕い求めており、また、自分の病気のことがあなたがたに伝わったことを気にしているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ほんとうに、彼は死ぬほどの病気にかかりましたが、神は彼をあわれんでくださいました。彼ばかりでなく私をもあわれんで、私にとって悲しみに悲しみが重なることのないようにしてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","そこで、私は大急ぎで彼を送ります。あなたがたが彼に再び会って喜び、私も心配が少なくなるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ですから、喜びにあふれて、主にあって、彼を迎えてください。また、彼のような人々には尊敬を払いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","なぜなら、彼は、キリストの仕事のために、いのちの危険を冒して死ぬばかりになったからです。彼は私に対して、あなたがたが私に仕えることのできなかった分を果たそうとしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","最後に、私の兄弟たち。主にあって喜びなさい。前と同じことを書きますが、これは、私には煩わしいことではなく、あなたがたの安全のためにもなることです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","どうか犬に気をつけてください。悪い働き人に気をつけてください。肉体だけの割礼の者に気をつけてください。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","神の御霊によって礼拝をし、キリスト・イエスを誇り、人間的なものを頼みにしない私たちのほうこそ、割礼の者なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","ただし、私は、人間的なものにおいても頼むところがあります。もし、ほかの人が人間的なものに頼むところがあると思うなら、私は、それ以上です。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","私は八日目の割礼を受け、イスラエル民族に属し、ベニヤミンの分かれの者です。きっすいのヘブル人で、律法についてはパリサイ人、 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","その熱心は教会を迫害したほどで、律法による義についてならば非難されるところのない者です。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","しかし、私にとって得であったこのようなものをみな、私はキリストのゆえに、損と思うようになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","それどころか、私の主であるキリスト・イエスを知っていることのすばらしさのゆえに、いっさいのことを損と思っています。私はキリストのためにすべてのものを捨てて、それらをちりあくたと思っています。それは、私には、キリストを得、また、 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","キリストの中にある者と認められ、律法による自分の義ではなくて、キリストを信じる信仰による義、すなわち、信仰に基づいて、神から与えられる義を持つことができる、という望みがあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","私は、キリストとその復活の力を知り、またキリストの苦しみにあずかることも知って、キリストの死と同じ状態になり、 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","どうにかして、死者の中からの復活に達したいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","私は、すでに得たのでもなく、すでに完全にされているのでもありません。ただ捕えようとして、追求しているのです。そして、それを得るようにとキリスト・イエスが私を捕えてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","兄弟たちよ。私は、自分はすでに捕えたなどと考えてはいません。ただ、この一事に励んでいます。すなわち、うしろのものを忘れ、ひたむきに前のものに向かって進み、 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","キリスト・イエスにおいて上に召してくださる神の栄冠を得るために、目標を目ざして一心に走っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ですから、成人である者はみな、このような考え方をしましょう。もし、あなたがたがどこかでこれと違った考え方をしているなら、神はそのこともあなたがたに明らかにしてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","それはそれとして、私たちはすでに達しているところを基準として、進むべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","兄弟たち。私を見ならう者になってください。また、あなたがたと同じように私たちを手本として歩んでいる人たちに、目を留めてください。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","というのは、私はしばしばあなたがたに言って来たし、今も涙をもって言うのですが、多くの人々がキリストの十字架の敵として歩んでいるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","彼らの最後は滅びです。彼らの神は彼らの欲望であり、彼らの栄光は彼ら自身の恥なのです。彼らの思いは地上のことだけです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","けれども、私たちの国籍は天にあります。そこから主イエス・キリストが救い主としておいでになるのを、私たちは待ち望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","キリストは、万物をご自身に従わせることのできる御力によって、私たちの卑しいからだを、ご自身の栄光のからだと同じ姿に変えてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","そういうわけですから、私の愛し慕う兄弟たち、私の喜び、冠よ。どうか、このように主にあってしっかりと立ってください。私の愛する人たち。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ユウオデヤに勧め、スントケに勧めます。あなたがたは、主にあって一致してください。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","ほんとうに、真の協力者よ。あなたにも頼みます。彼女たちを助けてやってください。この人たちは、いのちの書に名のしるされているクレメンスや、そのほかの私の同労者たちとともに、福音を広めることで私に協力して戦ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","いつも主にあって喜びなさい。もう一度言います。喜びなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","あなたがたの寛容な心を、すべての人に知らせなさい。主は近いのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","何も思い煩わないで、あらゆるばあいに、感謝をもってささげる祈りと願いによって、あなたがたの願い事を神に知っていただきなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","そうすれば、人のすべての考えにまさる神の平安が、あなたがたの心と思いをキリスト・イエスにあって守ってくれます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","最後に、兄弟たち。すべての真実なこと、すべての誉れあること、すべての正しいこと、すべてのきよいこと、すべての愛すべきこと、すべての評判の良いこと、そのほか徳と言われること、称賛に値することがあるならば、そのようなことに心を留めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","あなたがたが私から学び、受け、聞き、また見たことを実行しなさい。そうすれば、平和の神があなたがたとともにいてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","私のことを心配してくれるあなたがたの心が、今ついによみがえって来たことを、私は主にあって非常に喜んでいます。あなたがたは心にかけてはいたのですが、機会がなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","乏しいからこう言うのではありません。私は、どんな境遇にあっても満ち足りることを学びました。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","私は、貧しさの中にいる道も知っており、豊かさの中にいる道も知っています。また、飽くことにも飢えることにも、富むことにも乏しいことにも、あらゆる境遇に対処する秘訣を心得ています。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","私は、私を強くしてくださる方によって、どんなことでもできるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","それにしても、あなたがたは、よく私と困難を分け合ってくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","ピリピの人たち。あなたがたも知っているとおり、私が福音を宣べ伝え始めたころ、マケドニヤを離れて行ったときには、私の働きのために、物をやり取りしてくれた教会は、あなたがたのほかには一つもありませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","テサロニケにいたときでさえ、あなたがたは一度ならず二度までも物を送って、私の乏しさを補ってくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","私は贈り物を求めているのではありません。私のほしいのは、あなたがたの収支を償わせて余りある霊的祝福なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","私は、すべての物を受けて、満ちあふれています。エパフロデトからあなたがたの贈り物を受けたので、満ち足りています。それは香ばしいかおりであって、神が喜んで受けてくださる供え物です。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","また、私の神は、キリスト・イエスにあるご自身の栄光の富をもって、あなたがたの必要をすべて満たしてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","どうか、私たちの父なる神に御栄えがとこしえにありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","キリスト・イエスにある聖徒のひとりひとりに、よろしく伝えてください。私といっしょにいる兄弟たちが、あなたがたによろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","聖徒たち全員が、そして特に、カイザルの家に属する人々が、よろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","どうか、主イエス・キリストの恵みが、あなたがたの霊とともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","神のみこころによる、キリスト・イエスの使徒パウロ、および兄弟テモテから、 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","コロサイにいる聖徒たちで、キリストにある忠実な兄弟たちへ。どうか、私たちの父なる神から、恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","私たちは、いつもあなたがたのために祈り、私たちの主イエス・キリストの父なる神に感謝しています。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","それは、キリスト・イエスに対するあなたがたの信仰と、すべての聖徒に対してあなたがたが抱いている愛のことを聞いたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","それらは、あなたがたのために天にたくわえられてある望みに基づくものです。あなたがたは、すでにこの望みのことを、福音の真理のことばの中で聞きました。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","この福音は、あなたがたが神の恵みを聞き、それをほんとうに理解したとき以来、あなたがたの間でも見られるとおりの勢いをもって、世界中で、実を結び広がり続けています。福音はそのようにしてあなたがたに届いたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","これはあなたがたが私たちと同じしもべである愛するエパフラスから学んだとおりのものです。彼は私たちに代わって仕えている忠実な、キリストの仕え人であって、 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","私たちに、御霊によるあなたがたの愛を知らせてくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","こういうわけで、私たちはそのことを聞いた日から、絶えずあなたがたのために祈り求めています。どうか、あなたがたがあらゆる霊的な知恵と理解力によって、神のみこころに関する真の知識に満たされますように。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","また、主にかなった歩みをして、あらゆる点で主に喜ばれ、あらゆる善行のうちに実を結び、神を知る知識を増し加えられますように。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","また、神の栄光ある権能に従い、あらゆる力をもって強くされて、忍耐と寛容を尽くし、 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","また、光の中にある、聖徒の相続分にあずかる資格を私たちに与えてくださった父なる神に、喜びをもって感謝をささげることができますように。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","神は、私たちを暗やみの圧制から救い出して、愛する御子のご支配の中に移してくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","この御子のうちにあって、私たちは、贖い、すなわち罪の赦しを得ています。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","御子は、見えない神のかたちであり、造られたすべてのものより先に生まれた方です。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","なぜなら、万物は御子にあって造られたからです。天にあるもの、地にあるもの、見えるもの、また見えないもの、王座も主権も支配も権威も、すべて御子によって造られたのです。万物は、御子によって造られ、御子のために造られたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","御子は、万物よりも先に存在し、万物は御子にあって成り立っています。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","また、御子はそのからだである教会のかしらです。御子は初めであり、死者の中から最初に生まれた方です。こうして、ご自身がすべてのことにおいて、第一のものとなられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","なぜなら、神はみこころによって、満ち満ちた神の本質を御子のうちに宿らせ、 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","その十字架の血によって平和をつくり、御子によって万物を、ご自分と和解させてくださったからです。地にあるものも天にあるものも、ただ御子によって和解させてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","あなたがたも、かつては神を離れ、心において敵となって、悪い行ないの中にあったのですが、 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","今は神は、御子の肉のからだにおいて、しかもその死によって、あなたがたをご自分と和解させてくださいました。それはあなたがたを、きよく、傷なく、非難されるところのない者として御前に立たせてくださるためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","ただし、あなたがたは、しっかりとした土台の上に堅く立って、すでに聞いた福音の望みからはずれることなく、信仰に踏みとどまらなければなりません。この福音は、天の下のすべての造られたものに宣べ伝えられているのであって、このパウロはそれに仕える者となったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ですから、私は、あなたがたのために受ける苦しみを喜びとしています。そして、キリストのからだのために、私の身をもって、キリストの苦しみの欠けたところを満たしているのです。キリストのからだとは、教会のことです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","私は、あなたがたのために神からゆだねられた務めに従って、教会に仕える者となりました。神のことばを余すところなく伝えるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","これは、多くの世代にわたって隠されていて、いま神の聖徒たちに現わされた奥義なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","神は聖徒たちに、この奥義が異邦人の間にあってどのように栄光に富んだものであるかを、知らせたいと思われたのです。この奥義とは、あなたがたの中におられるキリスト、栄光の望みのことです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","私たちは、このキリストを宣べ伝え、知恵を尽くして、あらゆる人を戒め、あらゆる人を教えています。それは、すべての人を、キリストにある成人として立たせるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","このために、私もまた、自分のうちに力強く働くキリストの力によって、労苦しながら奮闘しています。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","あなたがたとラオデキヤの人たちと、そのほか直接私の顔を見たことのない人たちのためにも、私がどんなに苦闘しているか、知ってほしいと思います。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","それは、この人たちが心に励ましを受け、愛によって結び合わされ、理解をもって豊かな全き確信に達し、神の奥義であるキリストを真に知るようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","このキリストのうちに、知恵と知識との宝がすべて隠されているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","私がこう言うのは、だれもまことしやかな議論によって、あなたがたをあやまちに導くことのないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","私は、肉体においては離れていても、霊においてはあなたがたといっしょにいて、あなたがたの秩序とキリストに対する堅い信仰とを見て喜んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","あなたがたは、このように主キリスト・イエスを受け入れたのですから、彼にあって歩みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","キリストの中に根ざし、また建てられ、また、教えられたとおり信仰を堅くし、あふれるばかり感謝しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","あのむなしい、だましごとの哲学によってだれのとりこにもならぬよう、注意しなさい。そのようなものは、人の言い伝えによるものであり、この世に属する幼稚な教えによるものであって、キリストに基づくものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","キリストのうちにこそ、神の満ち満ちたご性質が形をとって宿っています。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","そしてあなたがたは、キリストにあって、満ち満ちているのです。キリストはすべての支配と権威のかしらです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","キリストにあって、あなたがたは人の手によらない割礼を受けました。肉のからだを脱ぎ捨て、キリストの割礼を受けたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","あなたがたは、バプテスマによってキリストとともに葬られ、また、キリストを死者の中からよみがえらせた神の力を信じる信仰によって、キリストとともによみがえらされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","あなたがたは罪によって、また肉の割礼がなくて死んだ者であったのに、神は、そのようなあなたがたを、キリストとともに生かしてくださいました。それは、私たちのすべての罪を赦し、 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","いろいろな定めのために私たちに不利な、いや、私たちを責め立てている債務証書を無効にされたからです。神はこの証書を取りのけ、十字架に釘づけにされました。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","神は、キリストにおいて、すべての支配と権威の武装を解除してさらしものとし、彼らを捕虜として凱旋の行列に加えられました。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","こういうわけですから、食べ物と飲み物について、あるいは、祭りや新月や安息日のことについて、だれにもあなたがたを批評させてはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","これらは、次に来るものの影であって、本体はキリストにあるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","あなたがたは、ことさらに自己卑下をしようとしたり、御使い礼拝をしようとする者に、ほうびをだまし取られてはなりません。彼らは幻を見たことに安住して、肉の思いによっていたずらに誇り、 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","かしらに堅く結びつくことをしません。このかしらがもとになり、からだ全体は、関節と筋によって養われ、結び合わされて、神によって成長させられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","もしあなたがたが、キリストとともに死んで、この世の幼稚な教えから離れたのなら、どうして、まだこの世の生き方をしているかのように、 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","「すがるな。味わうな。さわるな。」というような定めに縛られるのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","そのようなものはすべて、用いれば滅びるものについてであって、人間の戒めと教えによるものです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","そのようなものは、人間の好き勝手な礼拝とか、謙遜とか、または、肉体の苦行などのゆえに賢いもののように見えますが、肉のほしいままな欲望に対しては、何のききめもないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","こういうわけで、もしあなたがたが、キリストとともによみがえらされたのなら、上にあるものを求めなさい。そこにはキリストが、神の右に座を占めておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","あなたがたは、地上のものを思わず、天にあるものを思いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","あなたがたはすでに死んでおり、あなたがたのいのちは、キリストとともに、神のうちに隠されてあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","私たちのいのちであるキリストが現われると、そのときあなたがたも、キリストとともに、栄光のうちに現われます。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","ですから、地上のからだの諸部分、すなわち、不品行、汚れ、情欲、悪い欲、そしてむさぼりを殺してしまいなさい。このむさぼりが、そのまま偶像礼拝なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","このようなことのために、神の怒りが下るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","あなたがたも、以前、そのようなものの中に生きていたときは、そのような歩み方をしていました。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","しかし今は、あなたがたも、すべてこれらのこと、すなわち、怒り、憤り、悪意、そしり、あなたがたの口から出る恥ずべきことばを、捨ててしまいなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","互いに偽りを言ってはいけません。あなたがたは、古い人をその行ないといっしょに脱ぎ捨てて、 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","新しい人を着たのです。新しい人は、造り主のかたちに似せられてますます新しくされ、真の知識に至るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","そこには、ギリシヤ人とユダヤ人、割礼の有無、未開人、スクテヤ人、奴隷と自由人というような区別はありません。キリストがすべてであり、すべてのうちにおられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","それゆえ、神に選ばれた者、きよい、愛されている者として、あなたがたは深い同情心、慈愛、謙遜、柔和、寛容を身に着けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","互いに忍び合い、だれかがほかの人に不満を抱くことがあっても、互いに赦し合いなさい。主があなたがたを赦してくださったように、あなたがたもそうしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","そして、これらすべての上に、愛を着けなさい。愛は結びの帯として完全なものです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","キリストの平和が、あなたがたの心を支配するようにしなさい。そのためにこそあなたがたも召されて一体となったのです。また、感謝の心を持つ人になりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","キリストのことばを、あなたがたのうちに豊かに住まわせ、知恵を尽くして互いに教え、互いに戒め、詩と賛美と霊の歌とにより、感謝にあふれて心から神に向かって歌いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","あなたがたのすることは、ことばによると行ないによるとを問わず、すべて主イエスの名によってなし、主によって父なる神に感謝しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","妻たちよ。主にある者にふさわしく、夫に従いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","夫たちよ。妻を愛しなさい。つらく当たってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","子どもたちよ。すべてのことについて、両親に従いなさい。それは主に喜ばれることだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","父たちよ。子どもをおこらせてはいけません。彼らを気落ちさせないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","奴隷たちよ。すべてのことについて、地上の主人に従いなさい。人のごきげんとりのような、うわべだけの仕え方ではなく、主を恐れかしこみつつ、真心から従いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","何をするにも、人に対してではなく、主に対してするように、心からしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","あなたがたは、主から報いとして、御国を相続させていただくことを知っています。あなたがたは主キリストに仕えているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","不正を行なう者は、自分が行なった不正の報いを受けます。それには不公平な扱いはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","主人たちよ。あなたがたは、自分たちの主も天におられることを知っているのですから、奴隷に対して正義と公平を示しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","目をさまして、感謝をもって、たゆみなく祈りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","同時に、私たちのためにも、神がみことばのために門を開いてくださって、私たちがキリストの奥義を語れるように、祈ってください。この奥義のために、私は牢に入れられています。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","また、私がこの奥義を、当然語るべき語り方で、はっきり語れるように、祈ってください。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","外部の人に対して賢明にふるまい、機会を十分に生かして用いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","あなたがたのことばが、いつも親切で、塩味のきいたものであるようにしなさい。そうすれば、ひとりひとりに対する答え方がわかります。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","私の様子については、主にあって愛する兄弟、忠実な奉仕者、同労のしもべであるテキコが、あなたがたに一部始終を知らせるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","私がテキコをあなたがたのもとに送るのは、あなたがたが私たちの様子を知り、彼によって心に励ましを受けるためにほかなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","また彼は、あなたがたの仲間のひとりで、忠実な愛する兄弟オネシモといっしょに行きます。このふたりが、こちらの様子をみな知らせてくれるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","私といっしょに囚人となっているアリスタルコが、あなたがたによろしくと言っています。バルナバのいとこであるマルコも同じです。――この人については、もし彼があなたがたのところに行ったなら、歓迎するようにという指示をあなたがたは受けています。―― ");
INSERT INTO jpn1965_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","ユストと呼ばれるイエスもよろしくと言っています。割礼を受けた人では、この人たちだけが、神の国のために働く私の同労者です。また、彼らは私を激励する者となってくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","あなたがたの仲間のひとり、キリスト・イエスのしもべエパフラスが、あなたがたによろしくと言っています。彼はいつも、あなたがたが完全な人となり、また神のすべてのみこころを十分に確信して立つことができるよう、あなたがたのために祈りに励んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","私はあかしします。彼はあなたがたのために、またラオデキヤとヒエラポリスにいる人々のために、非常に苦労しています。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","愛する医者ルカ、それにデマスが、あなたがたによろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","どうか、ラオデキヤの兄弟たちに、またヌンパとその家にある教会に、よろしく言ってください。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","この手紙があなたがたのところで読まれたなら、ラオデキヤ人の教会でも読まれるようにしてください。あなたがたのほうも、ラオデキヤから回って来る手紙を読んでください。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","アルキポに、「主にあって受けた務めを、注意してよく果たすように。」と言ってください。 ");
INSERT INTO jpn1965_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","パウロが自筆であいさつを送ります。私が牢につながれていることを覚えていてください。どうか、恵みがあなたがたとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","パウロ、シルワノ、テモテから、父なる神および主イエス・キリストにあるテサロニケ人の教会へ。恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","私たちは、いつもあなたがたすべてのために神に感謝し、祈りのときにあなたがたを覚え、 ");
INSERT INTO jpn1965_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","絶えず、私たちの父なる神の御前に、あなたがたの信仰の働き、愛の労苦、主イエス・キリストへの望みの忍耐を思い起こしています。 ");
INSERT INTO jpn1965_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","神に愛されている兄弟たち。あなたがたが神に選ばれた者であることは私たちが知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","なぜなら、私たちの福音があなたがたに伝えられたのは、ことばだけによったのではなく、力と聖霊と強い確信とによったからです。また、私たちがあなたがたのところで、あなたがたのために、どのようにふるまったかは、あなたがたが知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","あなたがたも、多くの苦難の中で、聖霊による喜びをもってみことばを受け入れ、私たちと主とにならう者になりました。 ");
INSERT INTO jpn1965_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","こうして、あなたがたは、マケドニヤとアカヤとのすべての信者の模範になったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","主のことばが、あなたがたのところから出てマケドニヤとアカヤに響き渡っただけでなく、神に対するあなたがたの信仰はあらゆる所に伝わっているので、私たちは何も言わなくてよいほどです。 ");
INSERT INTO jpn1965_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","私たちがどのようにあなたがたに受け入れられたか、また、あなたがたがどのように偶像から神に立ち返って、生けるまことの神に仕えるようになり、 ");
INSERT INTO jpn1965_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","また、神が死者の中からよみがえらせなさった御子、すなわち、やがて来る御怒りから私たちを救い出してくださるイエスが天から来られるのを待ち望むようになったか、それらのことは他の人々が言い広めているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","兄弟たち。あなたがたが知っているとおり、私たちがあなたがたのところに行ったことは、むだではありませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","ご承知のように、私たちはまずピリピで苦しみに会い、はずかしめを受けたのですが、私たちの神によって、激しい苦闘の中でも大胆に神の福音をあなたがたに語りました。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","私たちの勧めは、迷いや不純な心から出ているものではなく、だましごとでもありません。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","私たちは神に認められて福音をゆだねられた者ですから、それにふさわしく、人を喜ばせようとしてではなく、私たちの心をお調べになる神を喜ばせようとして語るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","ご存じのとおり、私たちは今まで、へつらいのことばを用いたり、むさぼりの口実を設けたりしたことはありません。神がそのことの証人です。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","また、キリストの使徒たちとして権威を主張することもできたのですが、私たちは、あなたがたからも、ほかの人々からも、人からの名誉を受けようとはしませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","それどころか、あなたがたの間で、母がその子どもたちを養い育てるように、優しくふるまいました。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","このようにあなたがたを思う心から、ただ神の福音だけではなく、私たち自身のいのちまでも、喜んであなたがたに与えたいと思ったのです。なぜなら、あなたがたは私たちの愛する者となったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","兄弟たち。あなたがたは、私たちの労苦と苦闘を覚えているでしょう。私たちはあなたがたのだれにも負担をかけまいとして、昼も夜も働きながら、神の福音をあなたがたに宣べ伝えました。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","また、信者であるあなたがたに対して、私たちが敬虔に、正しく、また責められるところがないようにふるまったことは、あなたがたがあかしし、神もあかししてくださることです。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","また、ご承知のとおり、私たちは父がその子どもに対してするように、あなたがたひとりひとりに、 ");
INSERT INTO jpn1965_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","ご自身の御国と栄光とに召してくださる神にふさわしく歩むように勧めをし、慰めを与え、おごそかに命じました。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","こういうわけで、私たちとしてもまた、絶えず神に感謝しています。あなたがたは、私たちから神の使信のことばを受けたとき、それを人間のことばとしてではなく、事実どおりに神のことばとして受け入れてくれたからです。この神のことばは、信じているあなたがたのうちに働いているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","兄弟たち。あなたがたはユダヤの、キリスト・イエスにある神の諸教会にならう者となったのです。彼らがユダヤ人に苦しめられたのと同じように、あなたがたも自分の国の人に苦しめられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","ユダヤ人は、主であられるイエスをも、預言者たちをも殺し、また私たちをも追い出し、神に喜ばれず、すべての人の敵となっています。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","彼らは、私たちが異邦人の救いのために語るのを妨げ、このようにして、いつも自分の罪を満たしています。しかし、御怒りは彼らの上に臨んで窮みに達しました。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","兄弟たちよ。私たちは、しばらくの間あなたがたから引き離されたので、――といっても、顔を見ないだけで、心においてではありませんが、――なおさらのこと、あなたがたの顔を見たいと切に願っていました。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","それで私たちは、あなたがたのところに行こうとしました。このパウロは一度ならず二度までも心を決めたのです。しかし、サタンが私たちを妨げました。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","私たちの主イエスが再び来られるとき、御前で私たちの望み、喜び、誇りの冠となるのはだれでしょう。あなたがたではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","あなたがたこそ私たちの誉れであり、また喜びなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","そこで、私たちはもはやがまんできなくなり、私たちだけがアテネにとどまることにして、 ");
INSERT INTO jpn1965_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","私たちの兄弟であり、キリストの福音において神の同労者であるテモテを遣わしたのです。それは、あなたがたの信仰についてあなたがたを強め励まし、 ");
INSERT INTO jpn1965_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","このような苦難の中にあっても、動揺する者がひとりもないようにするためでした。あなたがた自身が知っているとおり、私たちはこのような苦難に会うように定められているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","あなたがたのところにいたとき、私たちは苦難に会うようになる、と前もって言っておいたのですが、それが、ご承知のとおり、はたして事実となったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","そういうわけで、私も、あれ以上はがまんができず、また誘惑者があなたがたを誘惑して、私たちの労苦がむだになるようなことがあってはいけないと思って、あなたがたの信仰を知るために、彼を遣わしたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","ところが、今テモテがあなたがたのところから私たちのもとに帰って来て、あなたがたの信仰と愛について良い知らせをもたらしてくれました。また、あなたがたが、いつも私たちのことを親切に考えていて、私たちがあなたがたに会いたいと思うように、あなたがたも、しきりに私たちに会いたがっていることを、知らせてくれました。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","このようなわけで、兄弟たち。私たちはあらゆる苦しみと患難のうちにも、あなたがたのことでは、その信仰によって、慰めを受けました。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","あなたがたが主にあって堅く立っていてくれるなら、私たちは今、生きがいがあります。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","私たちの神の御前にあって、あなたがたのことで喜んでいる私たちのこのすべての喜びのために、神にどんな感謝をささげたらよいでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","私たちは、あなたがたの顔を見たい、信仰の不足を補いたいと、昼も夜も熱心に祈っています。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","どうか、私たちの父なる神であり、また私たちの主イエスである方ご自身が、私たちの道を開いて、あなたがたのところに行かせてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","また、私たちがあなたがたを愛しているように、あなたがたの互いの間の愛を、またすべての人に対する愛を増させ、満ちあふれさせてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","また、あなたがたの心を強め、私たちの主イエスがご自分のすべての聖徒とともに再び来られるとき、私たちの父なる神の御前で、きよく、責められるところのない者としてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","終わりに、兄弟たちよ。主イエスにあって、お願いし、また勧告します。あなたがたはどのように歩んで神を喜ばすべきかを私たちから学んだように、また、事実いまあなたがたが歩んでいるように、ますますそのように歩んでください。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","私たちが、主イエスによって、どんな命令をあなたがたに授けたかを、あなたがたは知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","神のみこころは、あなたがたがきよくなることです。あなたがたが不品行を避け、 ");
INSERT INTO jpn1965_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","各自わきまえて、自分のからだを、きよく、また尊く保ち、 ");
INSERT INTO jpn1965_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","神を知らない異邦人のように情欲におぼれず、 ");
INSERT INTO jpn1965_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","また、このようなことで、兄弟を踏みつけたり、欺いたりしないことです。なぜなら、主はこれらすべてのことについて正しくさばかれるからです。これは、私たちが前もってあなたがたに話し、きびしく警告しておいたところです。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","神が私たちを召されたのは、汚れを行なわせるためではなく、聖潔を得させるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","ですから、このことを拒む者は、人を拒むのではなく、あなたがたに聖霊をお与えになる神を拒むのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","兄弟愛については、何も書き送る必要がありません。あなたがたこそ、互いに愛し合うことを神から教えられた人たちだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","実にマケドニヤ全土のすべての兄弟たちに対して、あなたがたはそれを実行しています。しかし、兄弟たち。あなたがたにお勧めします。どうか、さらにますますそうであってください。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","また、私たちが命じたように、落ち着いた生活をすることを志し、自分の仕事に身を入れ、自分の手で働きなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","外の人々に対してもりっぱにふるまうことができ、また乏しいことがないようにするためです。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","眠った人々のことについては、兄弟たち、あなたがたに知らないでいてもらいたくありません。あなたがたが他の望みのない人々のように悲しみに沈むことのないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","私たちはイエスが死んで復活されたことを信じています。それならば、神はまたそのように、イエスにあって眠った人々をイエスといっしょに連れて来られるはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","私たちは主のみことばのとおりに言いますが、主が再び来られるときまで生き残っている私たちが、死んでいる人々に優先するようなことは決してありません。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","主は、号令と、御使いのかしらの声と、神のラッパの響きのうちに、ご自身天から下って来られます。それからキリストにある死者が、まず初めによみがえり、 ");
INSERT INTO jpn1965_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","次に、生き残っている私たちが、たちまち彼らといっしょに雲の中に一挙に引き上げられ、空中で主と会うのです。このようにして、私たちは、いつまでも主とともにいることになります。 ");
INSERT INTO jpn1965_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","こういうわけですから、このことばをもって互いに慰め合いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","兄弟たち。それらがいつなのか、またどういう時かについては、あなたがたは私たちに書いてもらう必要がありません。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","主の日が夜中の盗人のように来るということは、あなたがた自身がよく承知しているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","人々が「平和だ。安全だ。」と言っているそのようなときに、突如として滅びが彼らに襲いかかります。ちょうど妊婦に産みの苦しみが臨むようなもので、それをのがれることは決してできません。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","しかし、兄弟たち。あなたがたは暗やみの中にはいないのですから、その日が、盗人のようにあなたがたを襲うことはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","あなたがたはみな、光の子ども、昼の子どもだからです。私たちは、夜や暗やみの者ではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","ですから、ほかの人々のように眠っていないで、目をさまして、慎み深くしていましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","眠る者は夜眠り、酔う者は夜酔うからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","しかし、私たちは昼の者なので、信仰と愛を胸当てとして着け、救いの望みをかぶととしてかぶって、慎み深くしていましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","神は、私たちが御怒りに会うようにお定めになったのではなく、主イエス・キリストにあって救いを得るようにお定めになったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","主が私たちのために死んでくださったのは、私たちが、目ざめていても、眠っていても、主とともに生きるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","ですから、あなたがたは、今しているとおり、互いに励まし合い、互いに徳を高め合いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","兄弟たちよ。あなたがたにお願いします。あなたがたの間で労苦し、主にあってあなたがたを指導し、訓戒している人々を認めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","その務めのゆえに、愛をもって深い尊敬を払いなさい。お互いの間に平和を保ちなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","兄弟たち。あなたがたに勧告します。気ままな者を戒め、小心な者を励まし、弱い者を助け、すべての人に対して寛容でありなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","だれも悪をもって悪に報いないように気をつけ、お互いの間で、またすべての人に対して、いつも善を行なうよう務めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","いつも喜んでいなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","絶えず祈りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","すべての事について、感謝しなさい。これが、キリスト・イエスにあって神があなたがたに望んでおられることです。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","御霊を消してはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","預言をないがしろにしてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","すべてのことを見分けて、ほんとうに良いものを堅く守りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","悪はどんな悪でも避けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","平和の神ご自身が、あなたがたを全くきよめてくださいますように。主イエス・キリストの来臨のとき、責められるところのないように、あなたがたの霊、たましい、からだが完全に守られますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","あなたがたを召された方は真実ですから、きっとそのことをしてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","兄弟たち。私たちのためにも祈ってください。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","すべての兄弟たちに、きよい口づけをもってあいさつをなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","この手紙がすべての兄弟たちに読まれるように、主によって命じます。 ");
INSERT INTO jpn1965_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","私たちの主イエス・キリストの恵みが、あなたがたとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","パウロ、シルワノ、テモテから、私たちの父なる神および主イエス・キリストにあるテサロニケ人の教会へ。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","父なる神と主イエス・キリストから、恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","兄弟たち。あなたがたのことについて、私たちはいつも神に感謝しなければなりません。そうするのが当然なのです。なぜならあなたがたの信仰が目に見えて成長し、あなたがたすべての間で、ひとりひとりに相互の愛が増し加わっているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","それゆえ私たちは、神の諸教会の間で、あなたがたがすべての迫害と患難とに耐えながらその従順と信仰とを保っていることを、誇りとしています。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","このことは、あなたがたを神の国にふさわしい者とするため、神の正しいさばきを示すしるしであって、あなたがたが苦しみを受けているのは、この神の国のためです。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","つまり、あなたがたを苦しめる者には、報いとして苦しみを与え、 ");
INSERT INTO jpn1965_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","苦しめられているあなたがたには、私たちとともに、報いとして安息を与えてくださることは、神にとって正しいことなのです。そのことは、主イエスが、炎の中に、力ある御使いたちを従えて天から現われるときに起こります。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","そのとき主は、神を知らない人々や、私たちの主イエスの福音に従わない人々に報復されます。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","そのような人々は、主の御顔の前とその御力の栄光から退けられて、永遠の滅びの刑罰を受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","その日に、主イエスは来られて、ご自分の聖徒たちによって栄光を受け、信じたすべての者の――そうです。あなたがたに対する私たちの証言は、信じられたのです。――感嘆の的となられます。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","そのためにも、私たちはいつも、あなたがたのために祈っています。どうか、私たちの神が、あなたがたをお召しにふさわしい者にし、また御力によって、善を慕うあらゆる願いと信仰の働きとを全うしてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","それは、私たちの神であり主であるイエス・キリストの恵みによって、主イエスの御名があなたがたの間であがめられ、あなたがたも主にあって栄光を受けるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","さて兄弟たちよ。私たちの主イエス・キリストが再び来られることと、私たちが主のみもとに集められることに関して、あなたがたにお願いすることがあります。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","霊によってでも、あるいはことばによってでも、あるいは私たちから出たかのような手紙によってでも、主の日がすでに来たかのように言われるのを聞いて、すぐに落ち着きを失ったり、心を騒がせたりしないでください。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","だれにも、どのようにも、だまされないようにしなさい。なぜなら、まず背教が起こり、不法の人、すなわち滅びの子が現われなければ、主の日は来ないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","彼は、すべて神と呼ばれるもの、また礼拝されるものに反抗し、その上に自分を高く上げ、神の宮の中に座を設け、自分こそ神であると宣言します。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","私がまだあなたがたのところにいたとき、これらのことをよく話しておいたのを思い出しませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","あなたがたが知っているとおり、彼がその定められた時に現われるようにと、いま引き止めているものがあるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","不法の秘密はすでに働いています。しかし今は引き止める者があって、自分が取り除かれる時まで引き止めているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","その時になると、不法の人が現われますが、主は御口の息をもって彼を殺し、来臨の輝きをもって滅ぼしてしまわれます。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","不法の人の到来は、サタンの働きによるのであって、あらゆる偽りの力、しるし、不思議がそれに伴い、 ");
INSERT INTO jpn1965_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","また、滅びる人たちに対するあらゆる悪の欺きが行なわれます。なぜなら、彼らは救われるために真理への愛を受け入れなかったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","それゆえ神は、彼らが偽りを信じるように、惑わす力を送り込まれます。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","それは、真理を信じないで、悪を喜んでいたすべての者が、さばかれるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","しかし、あなたがたのことについては、私たちはいつでも神に感謝しなければなりません。主に愛されている兄弟たち。神は、御霊によるきよめと、真理による信仰によって、あなたがたを、初めから救いにお選びになったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","ですから神は、私たちの福音によってあなたがたを召し、私たちの主イエス・キリストの栄光を得させてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","そこで、兄弟たち。堅く立って、私たちのことば、または手紙によって教えられた言い伝えを守りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","どうか、私たちの主イエス・キリストであり、私たちの父なる神である方、すなわち、私たちを愛し、恵みによって永遠の慰めとすばらしい望みとを与えてくださった方ご自身が、 ");
INSERT INTO jpn1965_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","あらゆる良いわざとことばとに進むよう、あなたがたの心を慰め、強めてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","終わりに、兄弟たちよ。私たちのために祈ってください。主のみことばが、あなたがたのところでと同じように早く広まり、またあがめられますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","また、私たちが、ひねくれた悪人どもの手から救い出されますように。すべての人が信仰を持っているのではないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","しかし、主は真実な方ですから、あなたがたを強くし、悪い者から守ってくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","私たちが命じることを、あなたがたが現に実行しており、これからも実行してくれることを私たちは主にあって確信しています。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","どうか、主があなたがたの心を導いて、神の愛とキリストの忍耐とを持たせてくださいますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","兄弟たちよ。主イエス・キリストの御名によって命じます。締まりのない歩み方をして私たちから受けた言い伝えに従わないでいる、すべての兄弟たちから離れていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","どのように私たちを見ならうべきかは、あなたがた自身が知っているのです。あなたがたのところで、私たちは締まりのないことはしなかったし、 ");
INSERT INTO jpn1965_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","人のパンをただで食べることもしませんでした。かえって、あなたがたのだれにも負担をかけまいとして、昼も夜も労苦しながら働き続けました。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","それは、私たちに権利がなかったからではなく、ただ私たちを見ならうようにと、身をもってあなたがたに模範を示すためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","私たちは、あなたがたのところにいたときにも、働きたくない者は食べるなと命じました。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","ところが、あなたがたの中には、何も仕事をせず、おせっかいばかりして、締まりのない歩み方をしている人たちがあると聞いています。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","こういう人たちには、主イエス・キリストによって、命じ、また勧めます。静かに仕事をし、自分で得たパンを食べなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","しかしあなたがたは、たゆむことなく善を行ないなさい。兄弟たちよ。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","もし、この手紙に書いた私たちの指示に従わない者があれば、そのような人には、特に注意を払い、交際しないようにしなさい。彼が恥じ入るようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","しかし、その人を敵とはみなさず、兄弟として戒めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","どうか、平和の主ご自身が、どんなばあいにも、いつも、あなたがたに平和を与えてくださいますように。どうか、主があなたがたすべてと、ともにおられますように。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","パウロが自分の手であいさつを書きます。これは私のどの手紙にもあるしるしです。これが私の手紙の書き方です。 ");
INSERT INTO jpn1965_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","どうか、私たちの主イエス・キリストの恵みが、あなたがたすべてとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","私たちの救い主なる神と私たちの望みなるキリスト・イエスとの命令による、キリスト・イエスの使徒パウロから、 ");
INSERT INTO jpn1965_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","信仰による真実のわが子テモテへ。父なる神と私たちの主なるキリスト・イエスから、恵みとあわれみと平安とがありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","私がマケドニヤに出発するとき、あなたにお願いしたように、あなたは、エペソにずっととどまっていて、ある人たちが違った教えを説いたり、 ");
INSERT INTO jpn1965_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","果てしのない空想話と系図とに心を奪われたりしないように命じてください。そのようなものは、論議を引き起こすだけで、信仰による神の救いのご計画の実現をもたらすものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","この命令は、きよい心と正しい良心と偽りのない信仰とから出て来る愛を、目標としています。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","ある人たちはこの目当てを見失い、わき道にそれて無益な議論に走り、 ");
INSERT INTO jpn1965_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","律法の教師でありたいと望みながら、自分の言っていることも、また強く主張していることについても理解していません。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","しかし私たちは知っています。律法は、もし次のことを知っていて正しく用いるならば、良いものです。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","すなわち、律法は、正しい人のためにあるのではなく、律法を無視する不従順な者、不敬虔な罪人、汚らわしい俗物、父や母を殺す者、人を殺す者、 ");
INSERT INTO jpn1965_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","不品行な者、男色をする者、人を誘拐する者、うそをつく者、偽証をする者などのため、またそのほか健全な教えにそむく事のためにあるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","祝福に満ちた神の、栄光の福音によれば、こうなのであって、私はその福音をゆだねられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","私は、私を強くしてくださる私たちの主キリスト・イエスに感謝をささげています。なぜなら、キリストは、私をこの務めに任命して、私を忠実な者と認めてくださったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","私は以前は、神をけがす者、迫害する者、暴力をふるう者でした。それでも、信じていないときに知らないでしたことなので、あわれみを受けたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","私たちの主の、この恵みは、キリスト・イエスにある信仰と愛とともに、ますます満ちあふれるようになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","「キリスト・イエスは、罪人を救うためにこの世に来られた。」ということばは、まことであり、そのまま受け入れるに値するものです。私はその罪人のかしらです。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","しかし、そのような私があわれみを受けたのは、イエス・キリストが、今後彼を信じて永遠のいのちを得ようとしている人々の見本にしようと、まず私に対してこの上ない寛容を示してくださったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","どうか、世々の王、すなわち、滅びることなく、目に見えない唯一の神に、誉れと栄えとが世々限りなくありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","私の子テモテよ。以前あなたについてなされた預言に従って、私はあなたにこの命令をゆだねます。それは、あなたがあの預言によって、信仰と正しい良心を保ち、勇敢に戦い抜くためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","ある人たちは、正しい良心を捨てて、信仰の破船に会いました。 ");
INSERT INTO jpn1965_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","その中には、ヒメナオとアレキサンデルがいます。私は、彼らをサタンに引き渡しました。それは、神をけがしてはならないことを、彼らに学ばせるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","そこで、まず初めに、このことを勧めます。すべての人のために、また王とすべての高い地位にある人たちのために願い、祈り、とりなし、感謝がささげられるようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","それは、私たちが敬虔に、また、威厳をもって、平安で静かな一生を過ごすためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","そうすることは、私たちの救い主である神の御前において良いことであり、喜ばれることなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","神は、すべての人が救われて、真理を知るようになるのを望んでおられます。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","神は唯一です。また、神と人との間の仲介者も唯一であって、それは人としてのキリスト・イエスです。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","キリストは、すべての人の贖いの代価として、ご自身をお与えになりました。これが時至ってなされたあかしなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","そのあかしのために、私は宣伝者また使徒に任じられ――私は真実を言っており、うそは言いません。――信仰と真理を異邦人に教える教師とされました。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","ですから、私は願うのです。男は、怒ったり言い争ったりすることなく、どこででもきよい手を上げて祈るようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","同じように女も、つつましい身なりで、控えめに慎み深く身を飾り、はでな髪の形とか、金や真珠や高価な衣服によってではなく、 ");
INSERT INTO jpn1965_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","むしろ、神を敬うと言っている女にふさわしく、良い行ないを自分の飾りとしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","女は、静かにして、よく従う心をもって教えを受けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","私は、女が教えたり男を支配したりすることを許しません。ただ、黙っていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","アダムが初めに造られ、次にエバが造られたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","また、アダムは惑わされなかったが、女は惑わされてしまい、あやまちを犯しました。 ");
INSERT INTO jpn1965_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","しかし、女が慎みをもって、信仰と愛ときよさとを保つなら、子を産むことによって救われます。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","「人がもし監督の職につきたいと思うなら、それはすばらしい仕事を求めることである。」ということばは真実です。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","ですから、監督はこういう人でなければなりません。すなわち、非難されるところがなく、ひとりの妻の夫であり、自分を制し、慎み深く、品位があり、よくもてなし、教える能力があり、 ");
INSERT INTO jpn1965_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","酒飲みでなく、暴力をふるわず、温和で、争わず、金銭に無欲で、 ");
INSERT INTO jpn1965_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","自分の家庭をよく治め、十分な威厳をもって子どもを従わせている人です。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","――自分自身の家庭を治めることを知らない人が、どうして神の教会の世話をすることができるでしょう。―― ");
INSERT INTO jpn1965_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","また、信者になったばかりの人であってはいけません。高慢になって、悪魔と同じさばきを受けることにならないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","また、教会外の人々にも評判の良い人でなければいけません。そしりを受け、悪魔のわなに陥らないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","執事もまたこういう人でなければなりません。謹厳で、二枚舌を使わず、大酒飲みでなく、不正な利をむさぼらず、 ");
INSERT INTO jpn1965_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","きよい良心をもって信仰の奥義を保っている人です。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","まず審査を受けさせなさい。そして、非難される点がなければ、執事の職につかせなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","婦人執事も、威厳があり、悪口を言わず、自分を制し、すべてに忠実な人でなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","執事は、ひとりの妻の夫であって、子どもと家庭をよく治める人でなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","というのは、執事の務めをりっぱに果たした人は、良い地歩を占め、また、キリスト・イエスを信じる信仰について強い確信を持つことができるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","私は、近いうちにあなたのところに行きたいと思いながらも、この手紙を書いています。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","それは、たとい私がおそくなったばあいでも、神の家でどのように行動すべきかを、あなたが知っておくためです。神の家とは生ける神の教会のことであり、その教会は、真理の柱また土台です。 ");
INSERT INTO jpn1965_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","確かに偉大なのはこの敬虔の奥義です。 「キリストは肉において現われ、 霊において義と宣言され、 御使いたちに見られ、 諸国民の間に宣べ伝えられ、 世界中で信じられ、 栄光のうちに上げられた。」 ");
INSERT INTO jpn1965_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","しかし、御霊が明らかに言われるように、後の時代になると、ある人たちは惑わす霊と悪霊の教えとに心を奪われ、信仰から離れるようになります。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","それは、うそつきどもの偽善によるものです。彼らは良心が麻痺しており、 ");
INSERT INTO jpn1965_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","結婚することを禁じたり、食物を断つことを命じたりします。しかし食物は、信仰があり、真理を知っている人が感謝して受けるようにと、神が造られた物です。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","神が造られた物はみな良い物で、感謝して受けるとき、捨てるべき物は何一つありません。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","神のことばと祈りとによって、きよめられるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","これらのことを兄弟たちに教えるなら、あなたはキリスト・イエスのりっぱな奉仕者になります。信仰のことばと、あなたが従って来た良い教えのことばとによって養われているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","俗悪な、年寄り女がするような空想話を避けなさい。むしろ、敬虔のために自分を鍛練しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","肉体の鍛練もいくらかは有益ですが、今のいのちと未来のいのちが約束されている敬虔は、すべてに有益です。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","このことばは、真実であり、そのまま受け入れるに値することばです。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","私たちはそのために労し、また苦心しているのです。それは、すべての人々、ことに信じる人々の救い主である、生ける神に望みを置いているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","これらのことを命じ、また教えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","年が若いからといって、だれにも軽く見られないようにしなさい。かえって、ことばにも、態度にも、愛にも、信仰にも、純潔にも信者の模範になりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","私が行くまで、聖書の朗読と勧めと教えとに専念しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","長老たちによる按手を受けたとき、預言によって与えられた、あなたのうちにある聖霊の賜物を軽んじてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","これらの務めに心を砕き、しっかりやりなさい。そうすれば、あなたの進歩はすべての人に明らかになるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","自分自身にも、教える事にも、よく気をつけなさい。あくまでそれを続けなさい。そうすれば、自分自身をも、またあなたの教えを聞く人たちをも救うことになります。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","年寄りをしかってはいけません。むしろ、父親に対するように勧めなさい。若い人たちには兄弟に対するように、 ");
INSERT INTO jpn1965_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","年とった婦人たちには母親に対するように、若い女たちには真に混じりけのない心で姉妹に対するように勧めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","やもめの中でもほんとうのやもめを敬いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","しかし、もし、やもめに子どもか孫かがいるなら、まずこれらの者に、自分の家の者に敬愛を示し、親の恩に報いる習慣をつけさせなさい。それが神に喜ばれることです。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","ほんとうのやもめで、身寄りのない人は、望みを神に置いて、昼も夜も、絶えず神に願いと祈りをささげていますが、 ");
INSERT INTO jpn1965_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","自堕落な生活をしているやもめは、生きてはいても、もう死んだ者なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","彼女たちがそしりを受けることのないように、これらのことを命じなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","もしも親族、ことに自分の家族を顧みない人がいるなら、その人は信仰を捨てているのであって、不信者よりも悪いのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","やもめとして名簿に載せるのは、六十歳未満の人でなく、ひとりの夫の妻であった人で、 ");
INSERT INTO jpn1965_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","良い行ないによって認められている人、すなわち、子どもを育て、旅人をもてなし、聖徒の足を洗い、困っている人を助け、すべての良いわざに務め励んだ人としなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","若いやもめは断わりなさい。というのは、彼女たちは、キリストにそむいて情欲に引かれると、結婚したがり、 ");
INSERT INTO jpn1965_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","初めの誓いを捨てたという非難を受けることになるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","そのうえ、怠けて、家々を遊び歩くことを覚え、ただ怠けるだけでなく、うわさ話やおせっかいをして、話してはいけないことまで話します。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","ですから、私が願うのは、若いやもめは結婚し、子どもを産み、家庭を治め、反対者にそしる機会を与えないことです。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","というのは、すでに、道を踏みはずし、サタンのあとについて行った者があるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","もし信者である婦人の身内にやもめがいたら、その人がそのやもめを助け、教会には負担をかけないようにしなさい。そうすれば、教会はほんとうのやもめを助けることができます。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","よく指導の任に当たっている長老は、二重に尊敬を受けるにふさわしいとしなさい。みことばと教えのためにほねおっている長老は特にそうです。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","聖書に「穀物をこなしている牛に、くつこを掛けてはいけない。」また、「働き手が報酬を受けることは当然である。」と言われているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","長老に対する訴えは、ふたりか三人の証人がなければ、受理してはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","罪を犯している者をすべての人の前で責めなさい。ほかの人をも恐れさせるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","私は、神とキリスト・イエスと選ばれた御使いたちとの前で、あなたにおごそかに命じます。これらのことを偏見なしに守り、何事もかたよらないで行ないなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","また、だれにでも軽々しく按手をしてはいけません。また、他人の罪にかかわりを持ってはいけません。自分をきよく保ちなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","これからは水ばかり飲まないで、胃のために、また、たびたび起こる病気のためにも、少量のぶどう酒を用いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","ある人たちの罪は、それがさばきを受ける前から、だれの目にも明らかですが、ある人たちの罪は、あとで明らかになります。 ");
INSERT INTO jpn1965_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","同じように、良い行ないは、だれの目にも明らかですが、そうでないばあいでも、いつまでも隠れたままでいることはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","くびきの下にある奴隷は、自分の主人を十分に尊敬すべき人だと考えなさい。それは神の御名と教えとがそしられないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","信者である主人を持つ人は、主人が兄弟だからといって軽く見ず、むしろ、ますますよく仕えなさい。なぜなら、その良い奉仕から益を受けるのは信者であり、愛されている人だからです。あなたは、これらのことを教え、また勧めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","違ったことを教え、私たちの主イエス・キリストの健全なことばと敬虔にかなう教えとに同意しない人がいるなら、 ");
INSERT INTO jpn1965_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","その人は高慢になっており、何一つ悟らず、疑いをかけたり、ことばの争いをしたりする病気にかかっているのです。そこから、ねたみ、争い、そしり、悪意の疑りが生じ、 ");
INSERT INTO jpn1965_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","また、知性が腐ってしまって真理を失った人々、すなわち敬虔を利得の手段と考えている人たちの間には、絶え間のない紛争が生じるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","しかし、満ち足りる心を伴う敬虔こそ、大きな利益を受ける道です。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","私たちは何一つこの世に持って来なかったし、また何一つ持って出ることもできません。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","衣食があれば、それで満足すべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","金持ちになりたがる人たちは、誘惑とわなと、また人を滅びと破滅に投げ入れる、愚かで、有害な多くの欲とに陥ります。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","金銭を愛することが、あらゆる悪の根だからです。ある人たちは、金を追い求めたために、信仰から迷い出て、非常な苦痛をもって自分を刺し通しました。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","しかし、神の人よ。あなたは、これらのことを避け、正しさ、敬虔、信仰、愛、忍耐、柔和を熱心に求めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","信仰の戦いを勇敢に戦い、永遠のいのちを獲得しなさい。あなたはこのために召され、また、多くの証人たちの前でりっぱな告白をしました。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","私は、すべてのものにいのちを与える神と、ポンテオ・ピラトに対してすばらしい告白をもってあかしされたキリスト・イエスとの御前で、あなたに命じます。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","私たちの主イエス・キリストの現われの時まで、あなたは命令を守り、傷のない、非難されるところのない者でありなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","その現われを、神はご自分の良しとする時に示してくださいます。神は祝福に満ちた唯一の主権者、王の王、主の主、 ");
INSERT INTO jpn1965_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","ただひとり死のない方であり、近づくこともできない光の中に住まわれ、人間がだれひとり見たことのない、また見ることのできない方です。誉れと、とこしえの主権は神のものです。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","この世で富んでいる人たちに命じなさい。高ぶらないように。また、たよりにならない富に望みを置かないように。むしろ、私たちにすべての物を豊かに与えて楽しませてくださる神に望みを置くように。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","また、人の益を計り、良い行ないに富み、惜しまずに施し、喜んで分け与えるように。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","また、まことのいのちを得るために、未来に備えて良い基礎を自分自身のために築き上げるように。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","テモテよ。ゆだねられたものを守りなさい。そして、俗悪なむだ話、また、まちがって「霊知」と呼ばれる反対論を避けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","これを公然と主張したある人たちは、信仰からはずれてしまいました。 恵みが、あなたがたとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","神のみこころにより、キリスト・イエスにあるいのちの約束によって、キリスト・イエスの使徒となったパウロから、 ");
INSERT INTO jpn1965_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","愛する子テモテへ。父なる神および私たちの主キリスト・イエスから、恵みとあわれみと平安がありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","私は、夜昼、祈りの中であなたのことを絶えず思い起こしては、先祖以来きよい良心をもって仕えている神に感謝しています。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","私は、あなたの涙を覚えているので、あなたに会って、喜びに満たされたいと願っています。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","私はあなたの純粋な信仰を思い起こしています。そのような信仰は、最初あなたの祖母ロイスと、あなたの母ユニケのうちに宿ったものですが、それがあなたのうちにも宿っていることを、私は確信しています。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","それですから、私はあなたに注意したいのです。私の按手をもってあなたのうちに与えられた神の賜物を、再び燃え立たせてください。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","神が私たちに与えてくださったものは、おくびょうの霊ではなく、力と愛と慎みとの霊です。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","ですから、あなたは、私たちの主をあかしすることや、私が主の囚人であることを恥じてはいけません。むしろ、神の力によって、福音のために私と苦しみをともにしてください。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","神は私たちを救い、また、聖なる招きをもって召してくださいましたが、それは私たちの働きによるのではなく、ご自身の計画と恵みとによるのです。この恵みは、キリスト・イエスにおいて、私たちに永遠の昔に与えられたものであって、 ");
INSERT INTO jpn1965_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","それが今、私たちの救い主キリスト・イエスの現われによって明らかにされたのです。キリストは死を滅ぼし、福音によって、いのちと不滅を明らかに示されました。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","私は、この福音のために、宣教者、使徒、また教師として任命されたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","そのために、私はこのような苦しみにも会っています。しかし、私はそれを恥とは思っていません。というのは、私は、自分の信じて来た方をよく知っており、また、その方は私のお任せしたものを、かの日のために守ってくださることができると確信しているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","あなたは、キリスト・イエスにある信仰と愛をもって、私から聞いた健全なことばを手本にしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","そして、あなたにゆだねられた良いものを、私たちのうちに宿る聖霊によって、守りなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","あなたの知っているとおり、アジヤにいる人々はみな、私を離れて行きました。その中には、フゲロとヘルモゲネがいます。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","オネシポロの家族を主があわれんでくださるように。彼はたびたび私を元気づけてくれ、また私が鎖につながれていることを恥とも思わず、 ");
INSERT INTO jpn1965_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","ローマに着いたときには、熱心に私を捜して見つけ出してくれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","――かの日には、主があわれみを彼に示してくださいますように。――彼がエペソで、どれほど私に仕えてくれたかは、あなたが一番よく知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","そこで、わが子よ。キリスト・イエスにある恵みによって強くなりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","多くの証人の前で私から聞いたことを、他の人にも教える力のある忠実な人たちにゆだねなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","キリスト・イエスのりっぱな兵士として、私と苦しみをともにしてください。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","兵役についていながら、日常生活のことに掛かり合っている者はだれもありません。それは徴募した者を喜ばせるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","また、競技をするときも、規定に従って競技をしなければ栄冠を得ることはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","労苦した農夫こそ、まず第一に収穫の分け前にあずかるべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","私が言っていることをよく考えなさい。主はすべてのことについて、理解する力をあなたに必ず与えてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","私の福音に言うとおり、ダビデの子孫として生まれ、死者の中からよみがえったイエス・キリストを、いつも思っていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","私は、福音のために、苦しみを受け、犯罪者のようにつながれています。しかし、神のことばは、つながれてはいません。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","ですから、私は選ばれた人たちのために、すべてのことを耐え忍びます。それは、彼らもまたキリスト・イエスにある救いと、それとともに、とこしえの栄光を受けるようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","次のことばは信頼すべきことばです。「もし私たちが、彼とともに死んだのなら、彼とともに生きるようになる。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","もし耐え忍んでいるなら、彼とともに治めるようになる。もし彼を否んだなら、彼もまた私たちを否まれる。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","私たちは真実でなくても、彼は常に真実である。彼にはご自身を否むことができないからである。」 ");
INSERT INTO jpn1965_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","これらのことを人々に思い出させなさい。そして何の益にもならず、聞いている人々を滅ぼすことになるような、ことばについての論争などしないように、神の御前できびしく命じなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","あなたは熟練した者、すなわち、真理のみことばをまっすぐに説き明かす、恥じることのない働き人として、自分を神にささげるよう、努め励みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","俗悪なむだ話を避けなさい。人々はそれによってますます不敬虔に深入りし、 ");
INSERT INTO jpn1965_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","彼らの話は癌のように広がるのです。ヒメナオとピレトはその仲間です。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","彼らは真理からはずれてしまい、復活がすでに起こったと言って、ある人々の信仰をくつがえしているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","それにもかかわらず、神の不動の礎は堅く置かれていて、それに次のような銘が刻まれています。「主はご自分に属する者を知っておられる。」また、「主の御名を呼ぶ者は、だれでも不義を離れよ。」 ");
INSERT INTO jpn1965_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","大きな家には、金や銀の器だけでなく、木や土の器もあります。また、ある物は尊いことに、ある物は卑しいことに用います。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","ですから、だれでも自分自身をきよめて、これらのことを離れるなら、その人は尊いことに使われる器となります。すなわち、きよめられたもの、主人にとって有益なもの、あらゆる良いわざに間に合うものとなるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","それで、あなたは、若い時の情欲を避け、きよい心で主を呼び求める人たちとともに、義と信仰と愛と平和を追い求めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","愚かで、無知な思弁を避けなさい。それが争いのもとであることは、あなたが知っているとおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","主のしもべが争ってはいけません。むしろ、すべての人に優しくし、よく教え、よく忍び、 ");
INSERT INTO jpn1965_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","反対する人たちを柔和な心で訓戒しなさい。もしかすると、神は彼らに悔い改めの心を与えて真理を悟らせ、 ");
INSERT INTO jpn1965_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","一時は悪魔に捕えられて思うままになっていた人々でも、目ざめてそのわなをのがれることもあるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","終わりの日には困難な時代がやって来ることをよく承知しておきなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","そのときに人々は、自分を愛する者、金を愛する者、大言壮語する者、不遜な者、神をけがす者、両親に従わない者、感謝することを知らない者、汚れた者になり、 ");
INSERT INTO jpn1965_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","情け知らずの者、和解しない者、そしる者、節制のない者、粗暴な者、善を好まない者になり、 ");
INSERT INTO jpn1965_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","裏切る者、向こう見ずな者、慢心する者、神よりも快楽を愛する者になり、 ");
INSERT INTO jpn1965_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","敬虔のかたちをしていても、その実を否定する者になるからです。こういう人々を避けなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","こういう人々の中には、家々にはいり込み、愚かな女たちをたぶらかしている者がいます。その女たちは、さまざまの情欲に引き回されて罪に罪を重ね、 ");
INSERT INTO jpn1965_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","いつも学んではいるが、いつになっても真理を知ることのできない者たちです。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","また、こういう人々は、ちょうどヤンネとヤンブレがモーセに逆らったように、真理に逆らうのです。彼らは知性の腐った、信仰の失格者です。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","でも、彼らはもうこれ以上に進むことはできません。彼らの愚かさは、あのふたりのばあいのように、すべての人にはっきりわかるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","しかし、あなたは、私の教え、行動、計画、信仰、寛容、愛、忍耐に、 ");
INSERT INTO jpn1965_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","またアンテオケ、イコニオム、ルステラで私にふりかかった迫害や苦難にも、よくついて来てくれました。何というひどい迫害に私は耐えて来たことでしょう。しかし、主はいっさいのことから私を救い出してくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","確かに、キリスト・イエスにあって敬虔に生きようと願う者はみな、迫害を受けます。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","しかし、悪人や詐欺師たちは、だましたりだまされたりしながら、ますます悪に落ちて行くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","けれどもあなたは、学んで確信したところにとどまっていなさい。あなたは自分が、どの人たちからそれを学んだかを知っており、 ");
INSERT INTO jpn1965_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","また、幼いころから聖書に親しんで来たことを知っているからです。聖書はあなたに知恵を与えてキリスト・イエスに対する信仰による救いを受けさせることができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","聖書はすべて、神の霊感によるもので、教えと戒めと矯正と義の訓練とのために有益です。 ");
INSERT INTO jpn1965_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","それは、神の人が、すべての良い働きのためにふさわしい十分に整えられた者となるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","神の御前で、また、生きている人と死んだ人とをさばかれるキリスト・イエスの御前で、その現われとその御国を思って、私はおごそかに命じます。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","みことばを宣べ伝えなさい。時が良くても悪くてもしっかりやりなさい。寛容を尽くし、絶えず教えながら、責め、戒め、また勧めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","というのは、人々が健全な教えに耳を貸そうとせず、自分につごうの良いことを言ってもらうために、気ままな願いをもって、次々に教師たちを自分たちのために寄せ集め、 ");
INSERT INTO jpn1965_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","真理から耳をそむけ、空想話にそれて行くような時代になるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","しかし、あなたは、どのようなばあいにも慎み、困難に耐え、伝道者として働き、自分の務めを十分に果たしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","私は今や注ぎの供え物となります。私が世を去る時はすでに来ました。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","私は勇敢に戦い、走るべき道のりを走り終え、信仰を守り通しました。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","今からは、義の栄冠が私のために用意されているだけです。かの日には、正しい審判者である主が、それを私に授けてくださるのです。私だけでなく、主の現われを慕っている者には、だれにでも授けてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","あなたは、何とかして、早く私のところに来てください。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","デマスは今の世を愛し、私を捨ててテサロニケに行ってしまい、また、クレスケンスはガラテヤに、テトスはダルマテヤに行ったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","ルカだけは私とともにおります。マルコを伴って、いっしょに来てください。彼は私の務めのために役に立つからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","私はテキコをエペソに遣わしました。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","あなたが来るときは、トロアスでカルポのところに残しておいた上着を持って来てください。また、書物を、特に羊皮紙の物を持って来てください。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","銅細工人のアレキサンデルが私をひどく苦しめました。そのしわざに応じて主が彼に報いられます。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","あなたも彼を警戒しなさい。彼は私たちのことばに激しく逆らったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","私の最初の弁明の際には、私を支持する者はだれもなく、みな私を見捨ててしまいました。どうか、彼らがそのためにさばかれることのありませんように。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","しかし、主は、私とともに立ち、私に力を与えてくださいました。それは、私を通してみことばが余すところなく宣べ伝えられ、すべての国の人々がみことばを聞くようになるためでした。私はししの口から助け出されました。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","主は私を、すべての悪のわざから助け出し、天の御国に救い入れてくださいます。主に、御栄えがとこしえにありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","プリスカとアクラによろしく。また、オネシポロの家族によろしく。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","エラストはコリントにとどまり、トロピモは病気のためにミレトに残して来ました。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","何とかして、冬になる前に来てください。ユブロ、プデス、リノス、クラウデヤ、またすべての兄弟たちが、あなたによろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","主があなたの霊とともにおられますように。恵みが、あなたがたとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","神のしもべ、また、イエス・キリストの使徒パウロ――私は、神に選ばれた人々の信仰と、敬虔にふさわしい真理の知識とのために使徒とされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","それは、偽ることのない神が、永遠の昔から約束してくださった永遠のいのちの望みに基づくことです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","神は、ご自分の定められた時に、このみことばを宣教によって明らかにされました。私は、この宣教を私たちの救い主なる神の命令によって、ゆだねられたのです。――このパウロから、 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","同じ信仰による真実のわが子テトスへ。父なる神および私たちの救い主なるキリスト・イエスから、恵みと平安がありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","私があなたをクレテに残したのは、あなたが残っている仕事の整理をし、また、私が指図したように、町ごとに長老たちを任命するためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","それには、その人が、非難されるところがなく、ひとりの妻の夫であり、その子どもは不品行を責められたり、反抗的であったりしない信者であることが条件です。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","監督は神の家の管理者として、非難されるところのない者であるべきです。わがままでなく、短気でなく、酒飲みでなく、けんか好きでなく、不正な利を求めず、 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","かえって、旅人をよくもてなし、善を愛し、慎み深く、正しく、敬虔で、自制心があり、 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","教えにかなった信頼すべきみことばを、しっかりと守っていなければなりません。それは健全な教えをもって励ましたり、反対する人たちを正したりすることができるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","実は、反抗的な者、空論に走る者、人を惑わす者が多くいます。特に、割礼を受けた人々がそうです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","彼らの口を封じなければいけません。彼らは、不正な利を得るために、教えてはいけないことを教え、家々を破壊しています。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","彼らと同国人であるひとりの預言者がこう言いました。 「クレテ人は昔からのうそつき、 悪いけだもの、 なまけ者の食いしんぼう。」 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","この証言はほんとうなのです。ですから、きびしく戒めて、人々の信仰を健全にし、 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","ユダヤ人の空想話や、真理から離れた人々の戒めには心を寄せないようにさせなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","きよい人々には、すべてのものがきよいのです。しかし、汚れた、不信仰な人々には、何一つきよいものはありません。それどころか、その知性と良心までも汚れています。 ");
INSERT INTO jpn1965_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","彼らは、神を知っていると口では言いますが、行ないでは否定しています。実に忌まわしく、不従順で、どんな良いわざにも不適格です。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","しかし、あなたは健全な教えにふさわしいことを話しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","老人たちには、自制し、謹厳で、慎み深くし、信仰と愛と忍耐とにおいて健全であるように。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","同じように、年をとった婦人たちには、神に仕えている者らしく敬虔にふるまい、悪口を言わず、大酒のとりこにならず、良いことを教える者であるように。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","そうすれば、彼女たちは、若い婦人たちに向かって、夫を愛し、子どもを愛し、 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","慎み深く、貞潔で、家事に励み、優しく、自分の夫に従順であるようにと、さとすことができるのです。それは、神のことばがそしられるようなことのないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","同じように、若い人々には、思慮深くあるように勧めなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","また、すべての点で自分自身が良いわざの模範となり、教えにおいては純正で、威厳を保ち、 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","非難すべきところのない、健全なことばを用いなさい。そうすれば、敵対する者も、私たちについて、何も悪いことが言えなくなって、恥じ入ることになるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","奴隷には、すべての点で自分の主人に従って、満足を与え、口答えせず、 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","盗みをせず、努めて真実を表わすように勧めなさい。それは、彼らがあらゆることで、私たちの救い主である神の教えを飾るようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","というのは、すべての人を救う神の恵みが現われ、 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","私たちに、不敬虔とこの世の欲とを捨て、この時代にあって、慎み深く、正しく、敬虔に生活し、 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","祝福された望み、すなわち、大いなる神であり私たちの救い主であるキリスト・イエスの栄光ある現われを待ち望むようにと教えさとしたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","キリストが私たちのためにご自身をささげられたのは、私たちをすべての不法から贖い出し、良いわざに熱心なご自分の民を、ご自分のためにきよめるためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","あなたは、これらのことを十分な権威をもって話し、勧め、また、責めなさい。だれにも軽んじられてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","あなたは彼らに注意を与えて、支配者たちと権威者たちに服従し、従順で、すべての良いわざを進んでする者とならせなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","また、だれをもそしらず、争わず、柔和で、すべての人に優しい態度を示す者とならせなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","私たちも以前は、愚かな者であり、不従順で、迷った者であり、いろいろな欲情と快楽の奴隷になり、悪意とねたみの中に生活し、憎まれ者であり、互いに憎み合う者でした。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","しかし、私たちの救い主なる神のいつくしみと人への愛とが現われたとき、 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","神は、私たちが行なった義のわざによってではなく、ご自分のあわれみのゆえに、聖霊による、新生と更新との洗いをもって私たちを救ってくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","神は、この聖霊を、私たちの救い主なるイエス・キリストによって、私たちに豊かに注いでくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","それは、私たちがキリストの恵みによって義と認められ、永遠のいのちの望みによって、相続人となるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","これは信頼できることばですから、私は、あなたがこれらのことについて、確信をもって話すように願っています。それは、神を信じている人々が、良いわざに励むことを心がけるようになるためです。これらのことは良いことであって、人々に有益なことです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","しかし、愚かな議論、系図、口論、律法についての論争などを避けなさい。それらは無益で、むだなものです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","分派を起こす者は、一、二度戒めてから、除名しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","このような人は、あなたも知っているとおり、堕落しており、自分で悪いと知りながら罪を犯しているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","私がアルテマスかテキコをあなたのもとに送ったら、あなたは、何としてでも、ニコポリにいる私のところに来てください。私はそこで冬を過ごすことに決めています。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","ぜひとも、律法学者ゼナスとアポロとが旅に出られるようにし、彼らが不自由しないように世話をしてあげなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","私たち一同も、なくてならないもののために、正しい仕事に励むように教えられなければなりません。それは、実を結ばない者にならないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","私といっしょにいる者たち一同が、あなたによろしくと言っています。私たちの信仰の友である人々に、よろしく言ってください。恵みが、あなたがたすべてとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","キリスト・イエスの囚人であるパウロ、および兄弟テモテから、私たちの愛する同労者ピレモンへ。また、 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","姉妹アピヤ、私たちの戦友アルキポ、ならびにあなたの家にある教会へ。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","私たちの父なる神と主イエス・キリストから、恵みと平安があなたがたの上にありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","私は、祈りのうちにあなたのことを覚え、いつも私の神に感謝しています。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","それは、主イエスに対してあなたが抱いている信仰と、すべての聖徒に対するあなたの愛とについて聞いているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","私たちの間でキリストのためになされているすべての良い行ないをよく知ることによって、あなたの信仰の交わりが生きて働くものとなりますように。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","私はあなたの愛から多くの喜びと慰めとを受けました。それは、聖徒たちの心が、兄弟よ、あなたによって力づけられたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","私は、あなたのなすべきことを、キリストにあって少しもはばからず命じることができるのですが、こういうわけですから、 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","むしろ愛によって、あなたにお願いしたいと思います。年老いて、今はまたキリスト・イエスの囚人となっている私パウロが、 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","獄中で生んだわが子オネシモのことを、あなたにお願いしたいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","彼は、前にはあなたにとって役に立たない者でしたが、今は、あなたにとっても私にとっても、役に立つ者となっています。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","そのオネシモを、あなたのもとに送り返します。彼は私の心そのものです。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","私は、彼を私のところにとどめておき、福音のために獄中にいる間、あなたに代わって私のために仕えてもらいたいとも考えましたが、 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","あなたの同意なしには何一つすまいと思いました。それは、あなたがしてくれる親切は強制されてではなく、自発的でなければいけないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","彼がしばらくの間あなたから離されたのは、たぶん、あなたが彼を永久に取り戻すためであったのでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","もはや奴隷としてではなく、奴隷以上の者、すなわち、愛する兄弟としてです。特に私にとってそうですが、あなたにとってはなおさらのこと、肉においても主にあっても、そうではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","ですから、もしあなたが私を親しい友と思うなら、私を迎えるように彼を迎えてやってください。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","もし彼があなたに対して損害をかけたか、負債を負っているのでしたら、その請求は私にしてください。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","この手紙は私の自筆です。私がそれを支払います。――あなたが今のようになれたのもまた、私によるのですが、そのことについては何も言いません。―― ");
INSERT INTO jpn1965_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","そうです。兄弟よ。私は、主にあって、あなたから益を受けたいのです。私の心をキリストにあって、元気づけてください。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","私はあなたの従順を確信して、あなたにこの手紙を書きました。私の言う以上のことをしてくださるあなたであると、知っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","それにまた、私の宿の用意もしておいてください。あなたがたの祈りによって、私もあなたがたのところに行けることと思っています。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","キリスト・イエスにあって私とともに囚人となっているエパフラスが、あなたによろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","私の同労者たちであるマルコ、アリスタルコ、デマス、ルカからもよろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","主イエス・キリストの恵みが、あなたがたの霊とともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","神は、むかし先祖たちに、預言者たちを通して、多くの部分に分け、また、いろいろな方法で語られましたが、 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","この終わりの時には、御子によって、私たちに語られました。神は、御子を万物の相続者とし、また御子によって世界を造られました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","御子は神の栄光の輝き、また神の本質の完全な現われであり、その力あるみことばによって万物を保っておられます。また、罪のきよめを成し遂げて、すぐれて高い所の大能者の右の座に着かれました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","御子は、御使いたちよりもさらにすぐれた御名を相続されたように、それだけ御使いよりもまさるものとなられました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","神は、かつてどの御使いに向かって、こう言われたでしょう。 「あなたは、わたしの子。 きょう、わたしがあなたを生んだ。」 またさらに、 「わたしは彼の父となり、 彼はわたしの子となる。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","さらに、長子をこの世界にお送りになるとき、こう言われました。 「神の御使いはみな、彼を拝め。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","また御使いについては、 「神は、御使いたちを風とし、 仕える者たちを炎とされる。」 と言われましたが、 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","御子については、こう言われます。 「神よ。あなたの御座は世々限りなく、 あなたの御国の杖こそ、まっすぐな杖です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","あなたは義を愛し、不正を憎まれます。 それゆえ、神よ。あなたの神は、 あふれるばかりの喜びの油を、 あなたとともに立つ者にまして、 あなたに注ぎなさいました。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","またこう言われます。 「主よ。あなたは、初めに 地の基を据えられました。 天も、あなたの御手のわざです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","これらのものは滅びます。 しかし、あなたはいつまでもながらえられます。 すべてのものは着物のように古びます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","あなたはこれらを、外套のように巻かれます。 これらを、着物のように取り替えられます。 しかし、あなたは変わることがなく、 あなたの年は尽きることがありません。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","神は、かつてどの御使いに向かって、こう言われたでしょう。 「わたしがあなたの敵を あなたの足台とするまでは、 わたしの右の座に着いていなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","御使いはみな、仕える霊であって、救いの相続者となる人々に仕えるため遣わされたのではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","ですから、私たちは聞いたことを、ますますしっかり心に留めて、押し流されないようにしなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","もし、御使いたちを通して語られたみことばでさえ、堅く立てられて動くことがなく、すべての違反と不従順が当然の処罰を受けたとすれば、 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","私たちがこんなにすばらしい救いをないがしろにしたばあい、どうしてのがれることができましょう。この救いは最初主によって語られ、それを聞いた人たちが、確かなものとしてこれを私たちに示し、 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","そのうえ神も、しるしと不思議とさまざまの力あるわざにより、また、みこころに従って聖霊が分け与えてくださる賜物によってあかしされました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","神は、私たちがいま話している後の世を、御使いたちに従わせることはなさらなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","むしろ、ある個所で、ある人がこうあかししています。 「人間が何者だというので、 これをみこころに留められるのでしょう。 人の子が何者だというので、 これを顧みられるのでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","あなたは、彼を、 御使いよりも、しばらくの間、低いものとし、 彼に栄光と誉れの冠を与え、 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","万物をその足の下に従わせられました。」 万物を彼に従わせたとき、神は、彼に従わないものを何一つ残されなかったのです。それなのに、今でもなお、私たちはすべてのものが人間に従わせられているのを見てはいません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","ただ、御使いよりも、しばらくの間、低くされた方であるイエスのことは見ています。イエスは、死の苦しみのゆえに、栄光と誉れの冠をお受けになりました。その死は、神の恵みによって、すべての人のために味わわれたものです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","神が多くの子たちを栄光に導くのに、彼らの救いの創始者を、多くの苦しみを通して全うされたということは、万物の存在の目的であり、また原因でもある方として、ふさわしいことであったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","きよめる方も、きよめられる者たちも、すべて元は一つです。それで、主は彼らを兄弟と呼ぶことを恥としないで、こう言われます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","「わたしは御名を、わたしの兄弟たちに告げよう。 教会の中で、わたしはあなたを賛美しよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","またさらに、 「わたしは彼に信頼する。」 またさらに、 「見よ、わたしと、神がわたしに賜わった子たちは。」 と言われます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","そこで、子たちはみな血と肉とを持っているので、主もまた同じように、これらのものをお持ちになりました。これは、その死によって、悪魔という、死の力を持つ者を滅ぼし、 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","一生涯死の恐怖につながれて奴隷となっていた人々を解放してくださるためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","主は御使いたちを助けるのではなく、確かに、アブラハムの子孫を助けてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","そういうわけで、神のことについて、あわれみ深い、忠実な大祭司となるため、主はすべての点で兄弟たちと同じようにならなければなりませんでした。それは民の罪のために、なだめがなされるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","主は、ご自身が試みを受けて苦しまれたので、試みられている者たちを助けることがおできになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","そういうわけですから、天の召しにあずかっている聖なる兄弟たち。私たちの告白する信仰の使徒であり、大祭司であるイエスのことを考えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","モーセが神の家全体のために忠実であったのと同様に、イエスはご自分を立てた方に対して忠実なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","家よりも、家を建てる者が大きな栄誉を持つのと同様に、イエスはモーセよりも大きな栄光を受けるのにふさわしいとされました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","家はそれぞれ、だれかが建てるのですが、すべてのものを造られた方は、神です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","モーセは、しもべとして神の家全体のために忠実でした。それは、後に語られる事をあかしするためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","しかし、キリストは御子として神の家を忠実に治められるのです。もし私たちが、確信と、希望による誇りとを、終わりまでしっかりと持ち続けるならば、私たちが神の家なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","ですから、聖霊が言われるとおりです。 「きょう、もし御声を聞くならば、 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","荒野での試みの日に 御怒りを引き起こしたときのように、 心をかたくなにしてはならない。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","あなたがたの先祖たちは、 そこでわたしを試みて証拠を求め、 四十年の間、わたしのわざを見た。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","だから、わたしはその時代を憤って言った。 彼らは常に心が迷い、 わたしの道を悟らなかった。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","わたしは、怒りをもって誓ったように、 決して彼らをわたしの安息にはいらせない。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","兄弟たち。あなたがたの中では、だれも悪い不信仰の心になって生ける神から離れる者がないように気をつけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","「きょう。」と言われている間に、日々互いに励まし合って、だれも罪に惑わされてかたくなにならないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","もし最初の確信を終わりまでしっかり保ちさえすれば、私たちは、キリストにあずかる者となるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","「きょう、もし御声を聞くならば、 御怒りを引き起こしたときのように、 心をかたくなにしてはならない。」 と言われているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","聞いていながら、御怒りを引き起こしたのはだれでしたか。モーセに率いられてエジプトを出た人々の全部ではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","神は四十年の間だれを怒っておられたのですか。罪を犯した人々、しかばねを荒野にさらした、あの人たちをではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","また、わたしの安息にはいらせないと神が誓われたのは、ほかでもない、従おうとしなかった人たちのことではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","それゆえ、彼らが安息にはいれなかったのは、不信仰のためであったことがわかります。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","こういうわけで、神の安息にはいるための約束はまだ残っているのですから、あなたがたのうちのひとりでも、万が一にもこれにはいれないようなことのないように、私たちは恐れる心を持とうではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","福音を説き聞かされていることは、私たちも彼らと同じなのです。ところが、その聞いたみことばも、彼らには益になりませんでした。みことばが、それを聞いた人たちに、信仰によって、結びつけられなかったからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","信じた私たちは安息にはいるのです。 「わたしは、怒りをもって誓ったように、 決して彼らをわたしの安息にはいらせない。」 と神が言われたとおりです。みわざは創世の初めから、もう終わっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","というのは、神は七日目について、ある個所で、「そして、神は、すべてのみわざを終えて七日目に休まれた。」と言われました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","そして、ここでは、「決して彼らをわたしの安息にはいらせない。」と言われたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","こういうわけで、その安息にはいる人々がまだ残っており、前に福音を説き聞かされた人々は、不従順のゆえにはいれなかったのですから、 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","神は再びある日を「きょう。」と定めて、長い年月の後に、前に言われたと同じように、ダビデを通して、 「きょう、もし御声を聞くならば、 あなたがたの心をかたくなにしてはならない。」 と語られたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","もしヨシュアが彼らに安息を与えたのであったら、神はそのあとで別の日のことを話されることはなかったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","したがって、安息日の休みは、神の民のためにまだ残っているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","神の安息にはいった者ならば、神がご自分のわざを終えて休まれたように、自分のわざを終えて休んだはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","ですから、私たちは、この安息にはいるよう力を尽くして努め、あの不従順の例にならって落後する者が、ひとりもいないようにしようではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","神のことばは生きていて、力があり、両刃の剣よりも鋭く、たましいと霊、関節と骨髄の分かれ目さえも刺し通し、心のいろいろな考えやはかりごとを判別することができます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","造られたもので、神の前で隠れおおせるものは何一つなく、神の目には、すべてが裸であり、さらけ出されています。私たちはこの神に対して弁明をするのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","さて、私たちのためには、もろもろの天を通られた偉大な大祭司である神の子イエスがおられるのですから、私たちの信仰の告白を堅く保とうではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","私たちの大祭司は、私たちの弱さに同情できない方ではありません。罪は犯されませんでしたが、すべての点で、私たちと同じように、試みに会われたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","ですから、私たちは、あわれみを受け、また恵みをいただいて、おりにかなった助けを受けるために、大胆に恵みの御座に近づこうではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","大祭司はみな、人々の中から選ばれ、神に仕える事がらについて人々に代わる者として、任命を受けたのです。それは、罪のために、ささげ物といけにえとをささげるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","彼は、自分自身も弱さを身にまとっているので、無知な迷っている人々を思いやることができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","そしてまた、その弱さのゆえに、民のためだけでなく、自分のためにも、罪のためのささげ物をしなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","まただれでも、この名誉は自分で得るのではなく、アロンのように神に召されて受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","同様に、キリストも大祭司となる栄誉を自分で得られたのではなく、彼に、 「あなたは、わたしの子。 きょう、わたしがあなたを生んだ。」 と言われた方が、それをお与えになったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","別の個所で、こうも言われます。 「あなたは、とこしえに、 メルキゼデクの位に等しい祭司である。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","キリストは、人としてこの世におられたとき、自分を死から救うことのできる方に向かって、大きな叫び声と涙とをもって祈りと願いをささげ、そしてその敬虔のゆえに聞き入れられました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","キリストは御子であられるのに、お受けになった多くの苦しみによって従順を学び、 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","完全な者とされ、彼に従うすべての人々に対して、とこしえの救いを与える者となり、 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","神によって、メルキゼデクの位に等しい大祭司ととなえられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","この方について、私たちは話すべきことをたくさん持っていますが、あなたがたの耳が鈍くなっているため、説き明かすことが困難です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","あなたがたは年数からすれば教師になっていなければならないにもかかわらず、神のことばの初歩をもう一度だれかに教えてもらう必要があるのです。あなたがたは堅い食物ではなく、乳を必要とするようになっています。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","まだ乳ばかり飲んでいるような者はみな、義の教えに通じてはいません。幼子なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","しかし、堅い食物はおとなの物であって、経験によって良い物と悪い物とを見分ける感覚を訓練された人たちの物です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","ですから、私たちは、キリストについての初歩の教えをあとにして、成熟を目ざして進もうではありませんか。死んだ行ないからの回心、神に対する信仰、 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","きよめの洗いについての教え、手を置く儀式、死者の復活、とこしえのさばきなど基礎的なことを再びやり直したりしないようにしましょう。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","神がお許しになるならば、私たちはそうすべきです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","一度光を受けて天からの賜物の味を知り、聖霊にあずかる者となり、 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","神のすばらしいみことばと、後にやがて来る世の力とを味わったうえで、 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","しかも堕落してしまうならば、そういう人々をもう一度悔い改めに立ち返らせることはできません。彼らは、自分で神の子をもう一度十字架にかけて、恥辱を与える人たちだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","土地は、その上にしばしば降る雨を吸い込んで、これを耕す人たちのために有用な作物を生じるなら、神の祝福にあずかります。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","しかし、いばらやあざみなどを生えさせるなら、無用なものであって、やがてのろいを受け、ついには焼かれてしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","だが、愛する人たち。私たちはこのように言いますが、あなたがたについては、もっと良いことを確信しています。それは救いにつながることです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","神は正しい方であって、あなたがたの行ないを忘れず、あなたがたがこれまで聖徒たちに仕え、また今も仕えて神の御名のために示したあの愛をお忘れにならないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","そこで、私たちは、あなたがたひとりひとりが、同じ熱心さを示して、最後まで、私たちの希望について十分な確信を持ち続けてくれるように切望します。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","それは、あなたがたがなまけずに、信仰と忍耐によって約束のものを相続するあの人たちに、ならう者となるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","神は、アブラハムに約束されるとき、ご自分よりすぐれたものをさして誓うことがありえないため、ご自分をさして誓い、 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","こう言われました。「わたしは必ずあなたを祝福し、あなたを大いにふやす。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","こうして、アブラハムは、忍耐の末に、約束のものを得ました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","確かに、人間は自分よりすぐれた者をさして誓います。そして、確証のための誓いというものは、人間のすべての反論をやめさせます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","そこで、神は約束の相続者たちに、ご計画の変わらないことをさらにはっきり示そうと思い、誓いをもって保証されたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","それは、変えることのできない二つの事がらによって、――神は、これらの事がらのゆえに、偽ることができません。――前に置かれている望みを捕えるためにのがれて来た私たちが、力強い励ましを受けるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","この望みは、私たちのたましいのために、安全で確かな錨の役を果たし、またこの望みは幕の内側にはいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","イエスは私たちの先駆けとしてそこにはいり、永遠にメルキゼデクの位に等しい大祭司となられました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","このメルキゼデクは、サレムの王で、すぐれて高い神の祭司でしたが、アブラハムが王たちを打ち破って帰るのを出迎えて祝福しました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","またアブラハムは彼に、すべての戦利品の十分の一を分けました。まず彼は、その名を訳すと義の王であり、次に、サレムの王、すなわち平和の王です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","父もなく、母もなく、系図もなく、その生涯の初めもなく、いのちの終わりもなく、神の子に似た者とされ、いつまでも祭司としてとどまっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","その人がどんなに偉大であるかを、よく考えてごらんなさい。族長であるアブラハムでさえ、彼に一番良い戦利品の十分の一を与えたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","レビの子らの中で祭司職を受ける者たちは、自分もアブラハムの子孫でありながら、民から、すなわち彼らの兄弟たちから、十分の一を徴集するようにと、律法の中で命じられています。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","ところが、レビ族の系図にない者が、アブラハムから十分の一を取って、約束を受けた人を祝福したのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","いうまでもなく、下位の者が上位の者から祝福されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","一方では、死ぬべき人間が十分の一を受けていますが、他のばあいは、彼は生きているとあかしされている者が受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","また、いうならば、十分の一を受け取るレビでさえアブラハムを通して十分の一を納めているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","というのは、メルキゼデクがアブラハムを出迎えたときには、レビはまだ父の腰の中にいたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","さて、もしレビ系の祭司職によって完全に到達できたのだったら、――民はそれを基礎として律法を与えられたのです。――それ以上何の必要があって、アロンの位でなく、メルキゼデクの位に等しいと呼ばれる他の祭司が立てられたのでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","祭司職が変われば、律法も必ず変わらなければなりませんが、 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","私たちが今まで論じて来たその方は、祭壇に仕える者を出したことのない別の部族に属しておられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","私たちの主が、ユダ族から出られたことは明らかですが、モーセは、この部族については、祭司に関することを何も述べていません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","もしメルキゼデクに等しい、別の祭司が立てられるのなら、以上のことは、いよいよ明らかになります。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","その祭司は、肉についての戒めである律法にはよらないで、朽ちることのない、いのちの力によって祭司となったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","この方については、こうあかしされています。 「あなたは、とこしえに、 メルキゼデクの位に等しい祭司である。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","一方で、前の戒めは、弱く無益なために、廃止されましたが、 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","――律法は何事も全うしなかったのです。――他方で、さらにすぐれた希望が導き入れられました。私たちはこれによって神に近づくのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","また、そのためには、はっきりと誓いがなされています。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","――彼らのばあいは、誓いなしに祭司となるのですが、主のばあいには、主に対して次のように言われた方の誓いがあります。 「主は誓ってこう言われ、 みこころを変えられることはない。 『あなたはとこしえに祭司である。』」―― ");
INSERT INTO jpn1965_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","そのようにして、イエスは、さらにすぐれた契約の保証となられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","また、彼らのばあいは、死ということがあるため、務めにいつまでもとどまることができず、大ぜいの者が祭司となりました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","しかし、キリストは永遠に存在されるのであって、変わることのない祭司の務めを持っておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","したがって、ご自分によって神に近づく人々を、完全に救うことがおできになります。キリストはいつも生きていて、彼らのために、とりなしをしておられるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","また、このようにきよく、悪も汚れもなく、罪人から離れ、また、天よりも高くされた大祭司こそ、私たちにとってまさに必要な方です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","ほかの大祭司たちとは違い、キリストには、まず自分の罪のために、その次に、民の罪のために毎日いけにえをささげる必要はありません。というのは、キリストは自分自身をささげ、ただ一度でこのことを成し遂げられたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","律法は弱さを持つ人間を大祭司に立てますが、律法のあとから来た誓いのみことばは、永遠に全うされた御子を立てるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","以上述べたことの要点はこうです。すなわち、私たちの大祭司は天におられる大能者の御座の右に着座された方であり、 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","人間が設けたのではなくて、主が設けられた真実の幕屋である聖所で仕えておられる方です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","すべて、大祭司は、ささげ物といけにえとをささげるために立てられます。したがって、この大祭司も何かささげる物を持っていなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","もしキリストが地上におられるのであったら、決して祭司とはなられないでしょう。律法に従ってささげ物をする人たちがいるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","その人たちは、天にあるものの写しと影とに仕えているのであって、それらはモーセが幕屋を建てようとしたとき、神から御告げを受けたとおりのものです。神はこう言われたのです。「よく注意しなさい。山であなたに示された型に従って、すべてのものを作りなさい。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","しかし今、キリストはさらにすぐれた務めを得られました。それは彼が、さらにすぐれた約束に基づいて制定された、さらにすぐれた契約の仲介者であるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","もしあの初めの契約が欠けのないものであったなら、後のものが必要になる余地はなかったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","しかし、神は、それに欠けがあるとして、こう言われたのです。 「主が、言われる。 見よ。日が来る。 わたしが、イスラエルの家やユダの家と 新しい契約を結ぶ日が。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","それは、わたしが彼らの先祖たちの手を引いて、 彼らをエジプトの地から導き出した日に 彼らと結んだ契約のようなものではない。 彼らがわたしの契約を守り通さないので、 わたしも、彼らを顧みなかったと、 主は言われる。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","それらの日の後、わたしが、 イスラエルの家と結ぶ契約は、これであると、 主が言われる。 わたしは、わたしの律法を彼らの思いの中に入れ、 彼らの心に書きつける。 わたしは彼らの神となり、 彼らはわたしの民となる。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","また彼らが、おのおのその町の者に、 また、おのおのその兄弟に教えて、 『主を知れ。』と言うことは決してない。 小さい者から大きい者に至るまで、 彼らはみな、わたしを知るようになるからである。 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","なぜなら、わたしは彼らの不義にあわれみをかけ、 もはや、彼らの罪を思い出さないからである。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","神が新しい契約と言われたときには、初めのものを古いとされたのです。年を経て古びたものは、すぐに消えて行きます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","初めの契約にも礼拝の規定と地上の聖所とがありました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","幕屋が設けられ、その前部の所には、燭台と机と供えのパンがありました。聖所と呼ばれる所です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","また、第二の垂れ幕のうしろには、至聖所と呼ばれる幕屋が設けられ、 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","そこには金の香壇と、全面を金でおおわれた契約の箱があり、箱の中には、マナのはいった金のつぼ、芽を出したアロンの杖、契約の二つの板がありました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","また、箱の上には、贖罪蓋を翼でおおっている栄光のケルビムがありました。しかしこれらについては、今いちいち述べることができません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","さて、これらの物が以上のように整えられた上で、前の幕屋には、祭司たちがいつもはいって礼拝を行なうのですが、 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","第二の幕屋には、大祭司だけが年に一度だけはいります。そのとき、血を携えずにはいるようなことはありません。その血は、自分のために、また、民が知らずに犯した罪のためにささげるものです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","これによって聖霊は次のことを示しておられます。すなわち、前の幕屋が存続しているかぎり、まことの聖所への道は、まだ明らかにされていないということです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","この幕屋はその当時のための比喩です。それに従って、ささげ物といけにえとがささげられますが、それらは礼拝する者の良心を完全にすることはできません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","それらは、ただ食物と飲み物と種々の洗いに関するもので、新しい秩序の立てられる時まで課せられた、からだに関する規定にすぎないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","しかしキリストは、すでに成就したすばらしい事がらの大祭司として来られ、手で造った物でない、言い替えれば、この造られた物とは違った、さらに偉大な、さらに完全な幕屋を通り、 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","また、やぎと子牛との血によってではなく、ご自分の血によって、ただ一度、まことの聖所にはいり、永遠の贖いを成し遂げられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","もし、やぎと雄牛の血、また雌牛の灰を汚れた人々に注ぎかけると、それがきよめの働きをして肉体をきよいものにするとすれば、 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","まして、キリストが傷のないご自身を、とこしえの御霊によって神におささげになったその血は、どんなにか私たちの良心をきよめて死んだ行ないから離れさせ、生ける神に仕える者とすることでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","こういうわけで、キリストは新しい契約の仲介者です。それは、初めの契約のときの違反を贖うための死が実現したので、召された者たちが永遠の資産の約束を受けることができるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","遺言には、遺言者の死亡証明が必要です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","遺言は、人が死んだとき初めて有効になるのであって、遺言者が生きている間は、決して効力はありません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","したがって、初めの契約も血なしに成立したのではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","モーセは、律法に従ってすべての戒めを民全体に語って後、水と赤い色の羊の毛とヒソプとのほかに、子牛とやぎの血を取って、契約の書自体にも民の全体にも注ぎかけ、 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","「これは神があなたがたに対して立てられた契約の血である。」と言いました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","また彼は、幕屋と礼拝のすべての器具にも同様に血を注ぎかけました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","それで、律法によれば、すべてのものは血によってきよめられる、と言ってよいでしょう。また、血を注ぎ出すことがなければ、罪の赦しはないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","ですから、天にあるものにかたどったものは、これらのものによってきよめられる必要がありました。しかし天にあるもの自体は、これよりもさらにすぐれたいけにえで、きよめられなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","キリストは、本物の模型にすぎない、手で造った聖所にはいられたのではなく、天そのものにはいられたのです。そして、今、私たちのために神の御前に現われてくださるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","それも、年ごとに自分の血でない血を携えて聖所にはいる大祭司とは違って、キリストは、ご自分を幾度もささげることはなさいません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","もしそうでなかったら、世の初めから幾度も苦難を受けなければならなかったでしょう。しかしキリストは、ただ一度、今の世の終わりに、ご自身をいけにえとして罪を取り除くために、来られたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","そして、人間には、一度死ぬことと死後にさばきを受けることが定まっているように、 ");
INSERT INTO jpn1965_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","キリストも、多くの人の罪を負うために一度、ご自身をささげられましたが、二度目は、罪を負うためではなく、彼を待ち望んでいる人々の救いのために来られるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","律法には、後に来るすばらしいものの影はあっても、その実物はないのですから、律法は、年ごとに絶えずささげられる同じいけにえによって神に近づいて来る人々を、完全にすることができないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","もしそれができたのであったら、礼拝する人々は、一度きよめられた者として、もはや罪を意識しなかったはずであり、したがって、ささげ物をすることは、やんだはずです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","ところがかえって、これらのささげ物によって、罪が年ごとに思い出されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","雄牛とやぎの血は、罪を除くことができません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","ですから、キリストは、この世界に来て、こう言われるのです。 「あなたは、いけにえやささげ物を望まないで、 わたしのために、からだを造ってくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","あなたは全焼のいけにえと 罪のためのいけにえとで 満足されませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","そこでわたしは言いました。 『さあ、わたしは来ました。 聖書のある巻に、 わたしについてしるされているとおり、 神よ、あなたのみこころを行なうために。』」 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","すなわち、初めには、「あなたは、いけにえとささげ物、全焼のいけにえと罪のためのいけにえ（すなわち、律法に従ってささげられる、いろいろの物）を望まず、またそれらで満足されませんでした。」と言い、 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","また、「さあ、わたしはあなたのみこころを行なうために来ました。」と言われたのです。後者が立てられるために、前者が廃止されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","このみこころに従って、イエス・キリストのからだが、ただ一度だけささげられたことにより、私たちはきよめられたものとされているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","また、すべて祭司は毎日立って礼拝の務めをなし、同じいけにえをくり返しささげますが、それらは決して罪を除き去ることができません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","しかし、キリストは、罪のために一つの永遠のいけにえをささげて後、神の右の座に着き、 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","それからは、その敵がご自分の足台となるのを待っておられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","キリストはきよめられる人々を、一つのささげ物によって、永遠に全うされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","聖霊も私たちに次のように言って、あかしされます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","「それらの日の後、わたしが、 彼らと結ぼうとしている契約は、これであると、 主は言われる。 わたしは、わたしの律法を彼らの心に置き、 彼らの思いに書きつける。」 またこう言われます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","「わたしは、もはや決して彼らの罪と不法とを思い出すことはしない。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","これらのことが赦されるところでは、罪のためのささげ物はもはや無用です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","こういうわけですから、兄弟たち。私たちは、イエスの血によって、大胆にまことの聖所にはいることができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","イエスはご自分の肉体という垂れ幕を通して、私たちのためにこの新しい生ける道を設けてくださったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","また、私たちには、神の家をつかさどる、この偉大な祭司があります。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","そのようなわけで、私たちは、心に血の注ぎを受けて邪悪な良心をきよめられ、からだをきよい水で洗われたのですから、全き信仰をもって、真心から神に近づこうではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","約束された方は真実な方ですから、私たちは動揺しないで、しっかりと希望を告白しようではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","また、互いに勧め合って、愛と善行を促すように注意し合おうではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","ある人々のように、いっしょに集まることをやめたりしないで、かえって励まし合い、かの日が近づいているのを見て、ますますそうしようではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","もし私たちが、真理の知識を受けて後、ことさらに罪を犯し続けるならば、罪のためのいけにえは、もはや残されていません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","ただ、さばきと、逆らう人たちを焼き尽くす激しい火とを、恐れながら待つよりほかはないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","だれでもモーセの律法を無視する者は、二、三の証人のことばに基づいて、あわれみを受けることなく死刑に処せられます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","まして、神の御子を踏みつけ、自分をきよめた契約の血を汚れたものとみなし、恵みの御霊を侮る者は、どんなに重い処罰に値するか、考えてみなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","私たちは、「復讐はわたしのすることである。わたしが報いをする。」、また、「主がその民をさばかれる。」と言われる方を知っています。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","生ける神の手の中に陥ることは恐ろしいことです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","あなたがたは、光に照らされて後、苦難に会いながら激しい戦いに耐えた初めのころを、思い起こしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","人々の目の前で、そしりと苦しみとを受けた者もあれば、このようなめに会った人々の仲間になった者もありました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","あなたがたは、捕えられている人々を思いやり、また、もっとすぐれた、いつまでも残る財産を持っていることを知っていたので、自分の財産が奪われても、喜んで忍びました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","ですから、あなたがたの確信を投げ捨ててはなりません。それは大きな報いをもたらすものなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","あなたがたが神のみこころを行なって、約束のものを手に入れるために必要なのは忍耐です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","「もうしばらくすれば、 来るべき方が来られる。おそくなることはない。 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","わたしの義人は信仰によって生きる。 もし、恐れ退くなら、 わたしのこころは彼を喜ばない。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","私たちは、恐れ退いて滅びる者ではなく、信じていのちを保つ者です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","信仰は望んでいる事がらを保証し、目に見えないものを確信させるものです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","昔の人々はこの信仰によって称賛されました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","信仰によって、私たちは、この世界が神のことばで造られたことを悟り、したがって、見えるものが目に見えるものからできたのではないことを悟るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","信仰によって、アベルはカインよりもすぐれたいけにえを神にささげ、そのいけにえによって彼が義人であることの証明を得ました。神が、彼のささげ物を良いささげ物だとあかししてくださったからです。彼は死にましたが、その信仰によって、今もなお語っています。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","信仰によって、エノクは死を見ることのないように移されました。神に移されて、見えなくなりました。移される前に、彼は神に喜ばれていることが、あかしされていました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","信仰がなくては、神に喜ばれることはできません。神に近づく者は、神がおられることと、神を求める者には報いてくださる方であることとを、信じなければならないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","信仰によって、ノアは、まだ見ていない事がらについて神から警告を受けたとき、恐れかしこんで、その家族の救いのために箱舟を造り、その箱舟によって、世の罪を定め、信仰による義を相続する者となりました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","信仰によって、アブラハムは、相続財産として受け取るべき地に出て行けとの召しを受けたとき、これに従い、どこに行くのかを知らないで、出て行きました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","信仰によって、彼は約束された地に他国人のようにして住み、同じ約束をともに相続するイサクやヤコブとともに天幕生活をしました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","彼は、堅い基礎の上に建てられた都を待ち望んでいたからです。その都を設計し建設されたのは神です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","信仰によって、サラも、すでにその年を過ぎた身であるのに、子を宿す力を与えられました。彼女は約束してくださった方を真実な方と考えたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","そこで、ひとりの、しかも死んだも同様のアブラハムから、天の星のように、また海べの数えきれない砂のように数多い子孫が生まれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","これらの人々はみな、信仰の人々として死にました。約束のものを手に入れることはありませんでしたが、はるかにそれを見て喜び迎え、地上では旅人であり寄留者であることを告白していたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","彼らはこのように言うことによって、自分の故郷を求めていることを示しています。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","もし、出て来た故郷のことを思っていたのであれば、帰る機会はあったでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","しかし、事実、彼らは、さらにすぐれた故郷、すなわち天の故郷にあこがれていたのです。それゆえ、神は彼らの神と呼ばれることを恥となさいませんでした。事実、神は彼らのために都を用意しておられました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","信仰によって、アブラハムは、試みられたときイサクをささげました。彼は約束を与えられていましたが、自分のただひとりの子をささげたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","神はアブラハムに対して、「イサクから出る者があなたの子孫と呼ばれる。」と言われたのですが、 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","彼は、神には人を死者の中からよみがえらせることもできる、と考えました。それで彼は、死者の中からイサクを取り戻したのです。これは型です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","信仰によって、イサクは未来のことについて、ヤコブとエサウを祝福しました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","信仰によって、ヤコブは死ぬとき、ヨセフの子どもたちをひとりひとり祝福し、また自分の杖のかしらに寄りかかって礼拝しました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","信仰によって、ヨセフは臨終のとき、イスラエルの子孫の脱出を語り、自分の骨について指図しました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","信仰によって、モーセは生まれてから、両親によって三か月の間隠されていました。彼らはその子の美しいのを見たからです。彼らは王の命令をも恐れませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","信仰によって、モーセは成人したとき、パロの娘の子と呼ばれることを拒み、 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","はかない罪の楽しみを受けるよりは、むしろ神の民とともに苦しむことを選び取りました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","彼は、キリストのゆえに受けるそしりを、エジプトの宝にまさる大きな富と思いました。彼は報いとして与えられるものから目を離さなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","信仰によって、彼は、王の怒りを恐れないで、エジプトを立ち去りました。目に見えない方を見るようにして、忍び通したからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","信仰によって、初子を滅ぼす者が彼らに触れることのないように、彼は過越と血の注ぎとを行ないました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","信仰によって、彼らは、かわいた陸地を行くのと同様に紅海を渡りました。エジプト人は、同じようにしようとしましたが、のみこまれてしまいました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","信仰によって、人々が七日の間エリコの城の周囲を回ると、その城壁はくずれ落ちました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","信仰によって、遊女ラハブは、偵察に来た人たちを穏やかに受け入れたので、不従順な人たちといっしょに滅びることを免れました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","これ以上、何を言いましょうか。もし、ギデオン、バラク、サムソン、エフタ、またダビデ、サムエル、預言者たちについても話すならば、時が足りないでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","彼らは、信仰によって、国々を征服し、正しいことを行ない、約束のものを得、ししの口をふさぎ、 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","火の勢いを消し、剣の刃をのがれ、弱い者なのに強くされ、戦いの勇士となり、他国の陣営を陥れました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","女たちは、死んだ者をよみがえらせていただきました。またほかの人たちは、さらにすぐれたよみがえりを得るために、釈放されることを願わないで拷問を受けました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","また、ほかの人たちは、あざけられ、むちで打たれ、さらに鎖につながれ、牢に入れられるめに会い、 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","また、石で打たれ、試みを受け、のこぎりで引かれ、剣で切り殺され、羊ややぎの皮を着て歩き回り、乏しくなり、悩まされ、苦しめられ、 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","――この世は彼らにふさわしい所ではありませんでした。――荒野と山とほら穴と地の穴とをさまよいました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","この人々はみな、その信仰によってあかしされましたが、約束されたものは得ませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","神は私たちのために、さらにすぐれたものをあらかじめ用意しておられたので、彼らが私たちと別に全うされるということはなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","こういうわけで、このように多くの証人たちが、雲のように私たちを取り巻いているのですから、私たちも、いっさいの重荷とまつわりつく罪とを捨てて、私たちの前に置かれている競走を忍耐をもって走り続けようではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","信仰の創始者であり、完成者であるイエスから目を離さないでいなさい。イエスは、ご自分の前に置かれた喜びのゆえに、はずかしめをものともせずに十字架を忍び、神の御座の右に着座されました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","あなたがたは、罪人たちのこのような反抗を忍ばれた方のことを考えなさい。それは、あなたがたの心が元気を失い、疲れ果ててしまわないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","あなたがたはまだ、罪と戦って、血を流すまで抵抗したことがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","そして、あなたがたに向かって子どもに対するように語られたこの勧めを忘れています。 「わが子よ。 主の懲らしめを軽んじてはならない。 主に責められて弱り果ててはならない。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","主はその愛する者を懲らしめ、 受け入れるすべての子に、 むちを加えられるからである。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","訓練と思って耐え忍びなさい。神はあなたがたを子として扱っておられるのです。父が懲らしめることをしない子がいるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","もしあなたがたが、だれでも受ける懲らしめを受けていないとすれば、私生子であって、ほんとうの子ではないのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","さらにまた、私たちには肉の父がいて、私たちを懲らしめたのですが、しかも私たちは彼らを敬ったのであれば、なおさらのこと、私たちはすべての霊の父に服従して生きるべきではないでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","なぜなら、肉の父親は、短い期間、自分が良いと思うままに私たちを懲らしめるのですが、霊の父は、私たちの益のため、私たちをご自分のきよさにあずからせようとして、懲らしめるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","すべての懲らしめは、そのときは喜ばしいものではなく、かえって悲しく思われるものですが、後になると、これによって訓練された人々に平安な義の実を結ばせます。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","ですから、弱った手と衰えたひざとを、まっすぐにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","また、あなたがたの足のためには、まっすぐな道を作りなさい。足なえの人も関節をはずすことのないため、いやむしろ、いやされるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","すべての人との平和を追い求め、また、きよめられることを追い求めなさい。きよくなければ、だれも主を見ることができません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","そのためには、あなたがたはよく監督して、だれも神の恵みから落ちる者がないように、また、苦い根が芽を出して悩ましたり、これによって多くの人が汚されたりすることのないように、 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","また、不品行の者や、一杯の食物と引き替えに自分のものであった長子の権利を売ったエサウのような俗悪な者がないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","あなたがたが知っているとおり、彼は後になって祝福を相続したいと思ったが、退けられました。涙を流して求めても、彼には心を変えてもらう余地がありませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","あなたがたは、手でさわれる山、燃える火、黒雲、暗やみ、あらし、 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","ラッパの響き、ことばのとどろきに近づいているのではありません。このとどろきは、これを聞いた者たちが、それ以上一言も加えてもらいたくないと願ったものです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","彼らは、「たとい、獣でも、山に触れるものは石で打ち殺されなければならない。」というその命令に耐えることができなかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","また、その光景があまり恐ろしかったので、モーセは、「私は恐れて、震える。」と言いました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","しかし、あなたがたは、シオンの山、生ける神の都、天にあるエルサレム、無数の御使いたちの大祝会に近づいているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","また、天に登録されている長子たちの教会、万民の審判者である神、全うされた義人たちの霊、 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","さらに、新しい契約の仲介者イエス、それに、アベルの血よりもすぐれたことを語る注ぎかけの血に近づいています。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","語っておられる方を拒まないように注意しなさい。なぜなら、地上においても、警告を与えた方を拒んだ彼らが処罰を免れることができなかったとすれば、まして天から語っておられる方に背を向ける私たちが、処罰を免れることができないのは当然ではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","あのときは、その声が地を揺り動かしましたが、このたびは約束をもって、こう言われます。「わたしは、もう一度、地だけではなく、天も揺り動かす。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","この「もう一度」ということばは、決して揺り動かされることのないものが残るために、すべての造られた、揺り動かされるものが取り除かれることを示しています。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","こういうわけで、私たちは揺り動かされない御国を受けているのですから、感謝しようではありませんか。こうして私たちは、慎みと恐れとをもって、神に喜ばれるように奉仕をすることができるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","私たちの神は焼き尽くす火です。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","兄弟愛をいつも持っていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","旅人をもてなすことを忘れてはいけません。こうして、ある人々は御使いたちを、それとは知らずにもてなしました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","牢につながれている人々を、自分も牢にいる気持ちで思いやり、また、自分も肉体を持っているのですから、苦しめられている人々を思いやりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","結婚がすべての人に尊ばれるようにしなさい。寝床を汚してはいけません。なぜなら、神は不品行な者と姦淫を行なう者とをさばかれるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","金銭を愛する生活をしてはいけません。いま持っているもので満足しなさい。主ご自身がこう言われるのです。「わたしは決してあなたを離れず、また、あなたを捨てない。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","そこで、私たちは確信に満ちてこう言います。 「主は私の助け手です。私は恐れません。 人間が、私に対して何ができましょう。」 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","神のみことばをあなたがたに話した指導者たちのことを、思い出しなさい。彼らの生活の結末をよく見て、その信仰にならいなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","イエス・キリストは、きのうもきょうも、いつまでも、同じです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","さまざまの異なった教えによって迷わされてはなりません。食物によってではなく、恵みによって心を強めるのは良いことです。食物に気を取られた者は益を得ませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","私たちには一つの祭壇があります。幕屋で仕える者たちには、この祭壇から食べる権利がありません。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","動物の血は、罪のための供え物として、大祭司によって聖所の中まで持って行かれますが、からだは宿営の外で焼かれるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","ですから、イエスも、ご自分の血によって民をきよめるために、門の外で苦しみを受けられました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","ですから、私たちは、キリストのはずかしめを身に負って、宿営の外に出て、みもとに行こうではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","私たちは、この地上に永遠の都を持っているのではなく、むしろ後に来ようとしている都を求めているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","ですから、私たちはキリストを通して、賛美のいけにえ、すなわち御名をたたえるくちびるの果実を、神に絶えずささげようではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","善を行なうことと、持ち物を人に分けることとを怠ってはいけません。神はこのようないけにえを喜ばれるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","あなたがたの指導者たちの言うことを聞き、また服従しなさい。この人々は神に弁明する者であって、あなたがたのたましいのために見張りをしているのです。ですから、この人たちが喜んでそのことをし、嘆いてすることにならないようにしなさい。そうでないと、あなたがたの益にならないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","私たちのために祈ってください。私たちは、正しい良心を持っていると確信しており、何事についても正しく行動しようと願っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","また、もっと祈ってくださるよう特にお願いします。それだけ、私があなたがたのところに早く帰れるようになるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","永遠の契約の血による羊の大牧者、私たちの主イエスを死者の中から導き出された平和の神が、 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","イエス・キリストにより、御前でみこころにかなうことを私たちのうちに行ない、あなたがたがみこころを行なうことができるために、すべての良いことについて、あなたがたを完全な者としてくださいますように。どうか、キリストに栄光が世々限りなくありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","兄弟たち。このような勧めのことばを受けてください。私はただ手短に書きました。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","私たちの兄弟テモテが釈放されたことをお知らせします。もし彼が早く来れば、私は彼といっしょにあなたがたに会えるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","すべてのあなたがたの指導者たち、また、すべての聖徒たちによろしく言ってください。イタリヤから来た人たちが、あなたがたによろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","恵みが、あなたがたすべてとともにありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","神と主イエス・キリストのしもべヤコブが、国外に散っている十二の部族へあいさつを送ります。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","私の兄弟たち。さまざまな試練に会うときは、それをこの上もない喜びと思いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","信仰がためされると忍耐が生じるということを、あなたがたは知っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","その忍耐を完全に働かせなさい。そうすれば、あなたがたは、何一つ欠けたところのない、成長を遂げた、完全な者となります。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","あなたがたの中に知恵の欠けた人がいるなら、その人は、だれにでも惜しげなく、とがめることなくお与えになる神に願いなさい。そうすればきっと与えられます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","ただし、少しも疑わずに、信じて願いなさい。疑う人は、風に吹かれて揺れ動く、海の大波のようです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","そういう人は、主から何かをいただけると思ってはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","そういうのは、二心のある人で、その歩む道のすべてに安定を欠いた人です。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","貧しい境遇にある兄弟は、自分の高い身分を誇りとしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","富んでいる人は、自分が低くされることに誇りを持ちなさい。なぜなら、富んでいる人は、草の花のように過ぎ去って行くからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","太陽が熱風を伴って上って来ると、草を枯らしてしまいます。すると、その花は落ち、美しい姿は滅びます。同じように、富んでいる人も、働きの最中に消えて行くのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","試練に耐える人は幸いです。耐え抜いて良しと認められた人は、神を愛する者に約束された、いのちの冠を受けるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","だれでも誘惑に会ったとき、神によって誘惑された、と言ってはいけません。神は悪に誘惑されることのない方であり、ご自分でだれを誘惑なさることもありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","人はそれぞれ自分の欲に引かれ、おびき寄せられて、誘惑されるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","欲がはらむと罪を生み、罪が熟すると死を生みます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","愛する兄弟たち。だまされないようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","すべての良い贈り物、また、すべての完全な賜物は上から来るのであって、光を造られた父から下るのです。父には移り変わりや、移り行く影はありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","父はみこころのままに、真理のことばをもって私たちをお生みになりました。私たちを、いわば被造物の初穂にするためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","愛する兄弟たち。あなたがたはそのことを知っているのです。しかし、だれでも、聞くには早く、語るにはおそく、怒るにはおそいようにしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","人の怒りは、神の義を実現するものではありません。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","ですから、すべての汚れやあふれる悪を捨て去り、心に植えつけられたみことばを、すなおに受け入れなさい。みことばは、あなたがたのたましいを救うことができます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","また、みことばを実行する人になりなさい。自分を欺いて、ただ聞くだけの者であってはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","みことばを聞いても行なわない人がいるなら、その人は自分の生まれつきの顔を鏡で見る人のようです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","自分をながめてから立ち去ると、すぐにそれがどのようであったかを忘れてしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","ところが、完全な律法、すなわち自由の律法を一心に見つめて離れない人は、すぐに忘れる聞き手にはならないで、事を実行する人になります。こういう人は、その行ないによって祝福されます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","自分は宗教に熱心であると思っても、自分の舌にくつわをかけず、自分の心を欺いているなら、そのような人の宗教はむなしいものです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","父なる神の御前できよく汚れのない宗教は、孤児や、やもめたちが困っているときに世話をし、この世から自分をきよく守ることです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","私の兄弟たち。あなたがたは私たちの栄光の主イエス・キリストを信じる信仰を持っているのですから、人をえこひいきしてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","あなたがたの会堂に、金の指輪をはめ、りっぱな服装をした人がはいって来、またみすぼらしい服装をした貧しい人もはいって来たとします。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","あなたがたが、りっぱな服装をした人に目を留めて、「あなたは、こちらの良い席におすわりなさい。」と言い、貧しい人には、「あなたは、そこで立っていなさい。でなければ、私の足もとにすわりなさい。」と言うとすれば、 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","あなたがたは、自分たちの間で差別を設け、悪い考え方で人をさばく者になったのではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","よく聞きなさい。愛する兄弟たち。神は、この世の貧しい人たちを選んで信仰に富む者とし、神を愛する者に約束されている御国を相続する者とされたではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","それなのに、あなたがたは貧しい人を軽蔑したのです。あなたがたをしいたげるのは富んだ人たちではありませんか。また、あなたがたを裁判所に引いて行くのも彼らではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","あなたがたがその名で呼ばれている尊い御名をけがすのも彼らではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","もし、ほんとうにあなたがたが、聖書に従って、「あなたの隣人をあなた自身のように愛せよ。」という最高の律法を守るなら、あなたがたの行ないはりっぱです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","しかし、もし人をえこひいきするなら、あなたがたは罪を犯しており、律法によって違反者として責められます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","律法全体を守っても、一つの点でつまずくなら、その人はすべてを犯した者となったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","なぜなら、「姦淫してはならない。」と言われた方は、「殺してはならない。」とも言われたからです。そこで、姦淫しなくても人殺しをすれば、あなたは律法の違反者となったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","自由の律法によってさばかれる者らしく語り、またそのように行ないなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","あわれみを示したことのない者に対するさばきは、あわれみのないさばきです。あわれみは、さばきに向かって勝ち誇るのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","私の兄弟たち。だれかが自分には信仰があると言っても、その人に行ないがないなら、何の役に立ちましょう。そのような信仰がその人を救うことができるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","もし、兄弟また姉妹のだれかが、着る物がなく、また、毎日の食べ物にもこと欠いているようなときに、 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","あなたがたのうちだれかが、その人たちに、「安心して行きなさい。暖かになり、十分に食べなさい。」と言っても、もしからだに必要な物を与えないなら、何の役に立つでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","それと同じように、信仰も、もし行ないがなかったなら、それだけでは、死んだものです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","さらに、こう言う人もあるでしょう。「あなたは信仰を持っているが、私は行ないを持っています。行ないのないあなたの信仰を、私に見せてください。私は、行ないによって、私の信仰をあなたに見せてあげます。」 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","あなたは、神はおひとりだと信じています。りっぱなことです。ですが、悪霊どももそう信じて、身震いしています。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","ああ愚かな人よ。あなたは行ないのない信仰がむなしいことを知りたいと思いますか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","私たちの父アブラハムは、その子イサクを祭壇にささげたとき、行ないによって義と認められたではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","あなたの見ているとおり、彼の信仰は彼の行ないとともに働いたのであり、信仰は行ないによって全うされ、 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","そして、「アブラハムは神を信じ、その信仰が彼の義とみなされた。」という聖書のことばが実現し、彼は神の友と呼ばれたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","人は行ないによって義と認められるのであって、信仰だけによるのではないことがわかるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","同様に、遊女ラハブも、使者たちを招き入れ、別の道から送り出したため、その行ないによって義と認められたではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","たましいを離れたからだが、死んだものであるのと同様に、行ないのない信仰は、死んでいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","私の兄弟たち。多くの者が教師になってはいけません。ご承知のように、私たち教師は、格別きびしいさばきを受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","私たちはみな、多くの点で失敗をするものです。もし、ことばで失敗をしない人がいたら、その人は、からだ全体もりっぱに制御できる完全な人です。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","馬を御するために、くつわをその口にかけると、馬のからだ全体を引き回すことができます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","また、船を見なさい。あのように大きな物が、強い風に押されているときでも、ごく小さなかじによって、かじを取る人の思いどおりの所へ持って行かれるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","同様に、舌も小さな器官ですが、大きなことを言って誇るのです。ご覧なさい。あのように小さい火があのような大きい森を燃やします。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","舌は火であり、不義の世界です。舌は私たちの器官の一つですが、からだ全体を汚し、人生の車輪を焼き、そしてゲヘナの火によって焼かれます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","どのような種類の獣も鳥も、はうものも海の生き物も、人類によって制せられるし、すでに制せられています。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","しかし、舌を制御することは、だれにもできません。それは少しもじっとしていない悪であり、死の毒に満ちています。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","私たちは、舌をもって、主であり父である方をほめたたえ、同じ舌をもって、神にかたどって造られた人をのろいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","賛美とのろいが同じ口から出て来るのです。私の兄弟たち。このようなことは、あってはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","泉が甘い水と苦い水を同じ穴からわき上がらせるというようなことがあるでしょうか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","私の兄弟たち。いちじくの木がオリーブの実をならせたり、ぶどうの木がいちじくの実をならせたりするようなことは、できることでしょうか。塩水が甘い水を出すこともできないことです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","あなたがたのうちで、知恵のある、賢い人はだれでしょうか。その人は、その知恵にふさわしい柔和な行ないを、良い生き方によって示しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","しかし、もしあなたがたの心の中に、苦いねたみと敵対心があるならば、誇ってはいけません。真理に逆らって偽ることになります。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","そのような知恵は、上から来たものではなく、地に属し、肉に属し、悪霊に属するものです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","ねたみや敵対心のあるところには、秩序の乱れや、あらゆる邪悪な行ないがあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","しかし、上からの知恵は、第一に純真であり、次に平和、寛容、温順であり、また、あわれみと良い実とに満ち、えこひいきがなく、見せかけのないものです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","義の実を結ばせる種は、平和をつくる人によって平和のうちに蒔かれます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","何が原因で、あなたがたの間に戦いや争いがあるのでしょう。あなたがたのからだの中で戦う欲望が原因ではありませんか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","あなたがたは、ほしがっても自分のものにならないと、人殺しをするのです。うらやんでも手に入れることができないと、争ったり、戦ったりするのです。あなたがたのものにならないのは、あなたがたが願わないからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","願っても受けられないのは、自分の快楽のために使おうとして、悪い動機で願うからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","貞操のない人たち。世を愛することは神に敵することであることがわからないのですか。世の友となりたいと思ったら、その人は自分を神の敵としているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","それとも、「神は、私たちのうちに住まわせた御霊を、ねたむほどに慕っておられる。」という聖書のことばが、無意味だと思うのですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","しかし、神は、さらに豊かな恵みを与えてくださいます。ですから、こう言われています。「神は、高ぶる者を退け、へりくだる者に恵みをお授けになる。」 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","ですから、神に従いなさい。そして、悪魔に立ち向かいなさい。そうすれば、悪魔はあなたがたから逃げ去ります。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","神に近づきなさい。そうすれば、神はあなたがたに近づいてくださいます。罪ある人たち。手を洗いきよめなさい。二心の人たち。心をきよくしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","あなたがたは、苦しみなさい。悲しみなさい。泣きなさい。あなたがたの笑いを悲しみに、喜びを憂いに変えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","主の御前でへりくだりなさい。そうすれば、主があなたがたを高くしてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","兄弟たち。互いに悪口を言い合ってはいけません。自分の兄弟の悪口を言い、自分の兄弟をさばく者は、律法の悪口を言い、律法をさばいているのです。あなたが、もし律法をさばくなら、律法を守る者ではなくて、さばく者です。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","律法を定め、さばきを行なう方は、ただひとりであり、その方は救うことも滅ぼすこともできます。隣人をさばくあなたは、いったい何者ですか。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","聞きなさい。「きょうか、あす、これこれの町に行き、そこに一年いて、商売をして、もうけよう。」と言う人たち。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","あなたがたには、あすのことはわからないのです。あなたがたのいのちは、いったいどのようなものですか。あなたがたは、しばらくの間現われて、それから消えてしまう霧にすぎません。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","むしろ、あなたがたはこう言うべきです。「主のみこころなら、私たちは生きていて、このことを、または、あのことをしよう。」 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","ところがこのとおり、あなたがたはむなしい誇りをもって高ぶっています。そのような高ぶりは、すべて悪いことです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","こういうわけで、なすべき正しいことを知っていながら行なわないなら、それはその人の罪です。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","聞きなさい。金持ちたち。あなたがたの上に迫って来る悲惨を思って泣き叫びなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","あなたがたの富は腐っており、あなたがたの着物は虫に食われており、 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","あなたがたの金銀にはさびが来て、そのさびが、あなたがたを責める証言となり、あなたがたの肉を火のように食い尽くします。あなたがたは、終わりの日に財宝をたくわえました。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","見なさい。あなたがたの畑の刈り入れをした労働者への未払い賃金が、叫び声をあげています。そして、取り入れをした人たちの叫び声は、万軍の主の耳に届いています。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","あなたがたは、地上でぜいたくに暮らし、快楽にふけり、殺される日にあたって自分の心を太らせました。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","あなたがたは、正しい人を罪に定めて、殺しました。彼はあなたがたに抵抗しません。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","こういうわけですから、兄弟たち。主が来られる時まで耐え忍びなさい。見なさい。農夫は、大地の貴重な実りを、秋の雨や春の雨が降るまで、耐え忍んで待っています。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","あなたがたも耐え忍びなさい。心を強くしなさい。主の来られるのが近いからです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","兄弟たち。互いにつぶやき合ってはいけません。さばかれないためです。見なさい。さばきの主が、戸口のところに立っておられます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","苦難と忍耐については、兄弟たち、主の御名によって語った預言者たちを模範にしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","見なさい。耐え忍んだ人たちは幸いであると、私たちは考えます。あなたがたは、ヨブの忍耐のことを聞いています。また、主が彼になさったことの結末を見たのです。主は慈愛に富み、あわれみに満ちておられる方だということです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","私の兄弟たちよ。何よりもまず、誓わないようにしなさい。天をさしても地をさしても、そのほかの何をさしてもです。ただ、「はい。」を「はい。」、「いいえ。」を「いいえ。」としなさい。それは、あなたがたが、さばきに会わないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","あなたがたのうちに苦しんでいる人がいますか。その人は祈りなさい。喜んでいる人がいますか。その人は賛美しなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","あなたがたのうちに病気の人がいますか。その人は教会の長老たちを招き、主の御名によって、オリーブ油を塗って祈ってもらいなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","信仰による祈りは、病む人を回復させます。主はその人を立たせてくださいます。また、もしその人が罪を犯していたなら、その罪は赦されます。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","ですから、あなたがたは、互いに罪を言い表わし、互いのために祈りなさい。いやされるためです。義人の祈りは働くと、大きな力があります。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","エリヤは、私たちと同じような人でしたが、雨が降らないように祈ると、三年六か月の間、地に雨が降りませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","そして、再び祈ると、天は雨を降らせ、地はその実を実らせました。 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","私の兄弟たち。あなたがたのうちに、真理から迷い出た者がいて、だれかがその人を連れ戻すようなことがあれば、 ");
INSERT INTO jpn1965_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","罪人を迷いの道から引き戻す者は、罪人のたましいを死から救い出し、また、多くの罪をおおうのだということを、あなたがたは知っていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_1","090_1_1","1PE","1","1","1","イエス・キリストの使徒ペテロから、ポント、ガラテヤ、カパドキヤ、アジヤ、ビテニヤに散って寄留している、選ばれた人々、すなわち、 ");
INSERT INTO jpn1965_vpl VALUES ("P11_2","090_1_2","1PE","1","2","2","父なる神の予知に従い、御霊のきよめによって、イエス・キリストに従うように、またその血の注ぎかけを受けるように選ばれた人々へ。どうか、恵みと平安が、あなたがたの上にますます豊かにされますように。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_3","090_1_3","1PE","1","3","3","私たちの主イエス・キリストの父なる神がほめたたえられますように。神は、ご自分の大きなあわれみのゆえに、イエス・キリストが死者の中からよみがえられたことによって、私たちを新しく生まれさせて、生ける望みを持つようにしてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_4","090_1_4","1PE","1","4","4","また、朽ちることも汚れることも、消えて行くこともない資産を受け継ぐようにしてくださいました。これはあなたがたのために、天にたくわえられているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_5","090_1_5","1PE","1","5","5","あなたがたは、信仰により、神の御力によって守られており、終わりのときに現わされるように用意されている救いをいただくのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_6","090_1_6","1PE","1","6","6","そういうわけで、あなたがたは大いに喜んでいます。ただ、いましばらくの間は、やむをえず、さまざまの試練のために、悩まされていますが、 ");
INSERT INTO jpn1965_vpl VALUES ("P11_7","090_1_7","1PE","1","7","7","信仰の試練は、火を通して精練されてもなお朽ちて行く金よりも尊いのであって、イエス・キリストの現われのときに称賛と光栄と栄誉に至るものであることがわかります。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_8","090_1_8","1PE","1","8","8","あなたがたはイエス・キリストを見たことはないけれども愛しており、いま見てはいないけれども信じており、ことばに尽くすことのできない、栄えに満ちた喜びにおどっています。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_9","090_1_9","1PE","1","9","9","これは、信仰の結果である、たましいの救いを得ているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_10","090_1_10","1PE","1","10","10","この救いについては、あなたがたに対する恵みについて預言した預言者たちも、熱心に尋ね、細かく調べました。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_11","090_1_11","1PE","1","11","11","彼らは、自分たちのうちにおられるキリストの御霊が、キリストの苦難とそれに続く栄光を前もってあかしされたとき、だれを、また、どのような時をさして言われたのかを調べたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_12","090_1_12","1PE","1","12","12","彼らは、それらのことが、自分たちのためではなく、あなたがたのための奉仕であるとの啓示を受けました。そして今や、それらのことは、天から送られた聖霊によってあなたがたに福音を語った人々を通して、あなたがたに告げ知らされたのです。それは御使いたちもはっきり見たいと願っていることなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_13","090_1_13","1PE","1","13","13","ですから、あなたがたは、心を引き締め、身を慎み、イエス・キリストの現われのときあなたがたにもたらされる恵みを、ひたすら待ち望みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_14","090_1_14","1PE","1","14","14","従順な子どもとなり、以前あなたがたが無知であったときのさまざまな欲望に従わず、 ");
INSERT INTO jpn1965_vpl VALUES ("P11_15","090_1_15","1PE","1","15","15","あなたがたを召してくださった聖なる方にならって、あなたがた自身も、あらゆる行ないにおいてきよくなりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_16","090_1_16","1PE","1","16","16","それは、「わたしが聖であるから、あなたがたも、聖でなければならない。」と書いてあるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_17","090_1_17","1PE","1","17","17","また、人をそれぞれのわざに従って公平にさばかれる方を父と呼んでいるのなら、あなたがたが地上にしばらくとどまっている間の時を、恐れかしこんで過ごしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_18","090_1_18","1PE","1","18","18","ご承知のように、あなたがたが先祖から伝わったむなしい生き方から贖い出されたのは、銀や金のような朽ちる物にはよらず、 ");
INSERT INTO jpn1965_vpl VALUES ("P11_19","090_1_19","1PE","1","19","19","傷もなく汚れもない小羊のようなキリストの、尊い血によったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_20","090_1_20","1PE","1","20","20","キリストは、世の始まる前から知られていましたが、この終わりの時に、あなたがたのために、現われてくださいました。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_21","090_1_21","1PE","1","21","21","あなたがたは、死者の中からこのキリストをよみがえらせて彼に栄光を与えられた神を、キリストによって信じる人々です。このようにして、あなたがたの信仰と希望は神にかかっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_22","090_1_22","1PE","1","22","22","あなたがたは、真理に従うことによって、たましいをきよめ、偽りのない兄弟愛を抱くようになったのですから、互いに心から熱く愛し合いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_23","090_1_23","1PE","1","23","23","あなたがたが新しく生まれたのは、朽ちる種からではなく、朽ちない種からであり、生ける、いつまでも変わることのない、神のことばによるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_24","090_1_24","1PE","1","24","24","「人はみな草のようで、 その栄えは、みな草の花のようだ。 草はしおれ、 花は散る。 ");
INSERT INTO jpn1965_vpl VALUES ("P11_25","090_1_25","1PE","1","25","25","しかし、主のことばは、 とこしえに変わることがない。」 とあるからです。あなたがたに宣べ伝えられた福音のことばがこれです。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_1","090_2_1","1PE","2","1","1","ですから、あなたがたは、すべての悪意、すべてのごまかし、いろいろな偽善やねたみ、すべての悪口を捨てて、 ");
INSERT INTO jpn1965_vpl VALUES ("P12_2","090_2_2","1PE","2","2","2","生まれたばかりの乳飲み子のように、純粋な、みことばの乳を慕い求めなさい。それによって成長し、救いを得るためです。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_3","090_2_3","1PE","2","3","3","あなたがたはすでに、主がいつくしみ深い方であることを味わっているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_4","090_2_4","1PE","2","4","4","主のもとに来なさい。主は、人には捨てられたが、神の目には、選ばれた、尊い、生ける石です。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_5","090_2_5","1PE","2","5","5","あなたがたも生ける石として、霊の家に築き上げられなさい。そして、きよい祭司として、イエス・キリストを通して、神に喜ばれる霊のいけにえをささげなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_6","090_2_6","1PE","2","6","6","なぜなら、聖書にこうあるからです。 「見よ。わたしはシオンに、選ばれた石、 尊い礎石を置く。 彼に信頼する者は、 決して失望させられることがない。」 ");
INSERT INTO jpn1965_vpl VALUES ("P12_7","090_2_7","1PE","2","7","7","したがって、より頼んでいるあなたがたには尊いものですが、より頼んでいない人々にとっては、「家を建てる者たちが捨てた石、それが礎の石となった。」のであって、 ");
INSERT INTO jpn1965_vpl VALUES ("P12_8","090_2_8","1PE","2","8","8","「つまずきの石、妨げの岩。」なのです。彼らがつまずくのは、みことばに従わないからですが、またそうなるように定められていたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_9","090_2_9","1PE","2","9","9","しかし、あなたがたは、選ばれた種族、王である祭司、きよい国民、神の所有とされた民です。それは、あなたがたを、やみの中から、ご自分の驚くべき光の中に招いてくださった方のすばらしいみわざを、あなたがたが宣べ伝えるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_10","090_2_10","1PE","2","10","10","あなたがたは、以前は神の民ではなかったのに、今は神の民であり、以前はあわれみを受けない者であったのに、今はあわれみを受けた者です。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_11","090_2_11","1PE","2","11","11","愛する者たちよ。あなたがたにお勧めします。旅人であり寄留者であるあなたがたは、たましいに戦いをいどむ肉の欲を遠ざけなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_12","090_2_12","1PE","2","12","12","異邦人の中にあって、りっぱにふるまいなさい。そうすれば、彼らは、何かのことであなたがたを悪人呼ばわりしていても、あなたがたのそのりっぱな行ないを見て、おとずれの日に神をほめたたえるようになります。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_13","090_2_13","1PE","2","13","13","人の立てたすべての制度に、主のゆえに従いなさい。それが主権者である王であっても、 ");
INSERT INTO jpn1965_vpl VALUES ("P12_14","090_2_14","1PE","2","14","14","また、悪を行なう者を罰し、善を行なう者をほめるように王から遣わされた総督であっても、そうしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_15","090_2_15","1PE","2","15","15","というのは、善を行なって、愚かな人々の無知の口を封じることは、神のみこころだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_16","090_2_16","1PE","2","16","16","あなたがたは自由人として行動しなさい。その自由を、悪の口実に用いないで、神の奴隷として用いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_17","090_2_17","1PE","2","17","17","すべての人を敬いなさい。兄弟たちを愛し、神を恐れ、王を尊びなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_18","090_2_18","1PE","2","18","18","しもべたちよ。尊敬の心を込めて主人に服従しなさい。善良で優しい主人に対してだけでなく、横暴な主人に対しても従いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_19","090_2_19","1PE","2","19","19","人がもし、不当な苦しみを受けながらも、神の前における良心のゆえに、悲しみをこらえるなら、それは喜ばれることです。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_20","090_2_20","1PE","2","20","20","罪を犯したために打ちたたかれて、それを耐え忍んだからといって、何の誉れになるでしょう。けれども、善を行なっていて苦しみを受け、それを耐え忍ぶとしたら、それは、神に喜ばれることです。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_21","090_2_21","1PE","2","21","21","あなたがたが召されたのは、実にそのためです。キリストも、あなたがたのために苦しみを受け、その足跡に従うようにと、あなたがたに模範を残されました。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_22","090_2_22","1PE","2","22","22","キリストは罪を犯したことがなく、その口に何の偽りも見いだされませんでした。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_23","090_2_23","1PE","2","23","23","ののしられても、ののしり返さず、苦しめられても、おどすことをせず、正しくさばかれる方にお任せになりました。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_24","090_2_24","1PE","2","24","24","そして自分から十字架の上で、私たちの罪をその身に負われました。それは、私たちが罪を離れ、義のために生きるためです。キリストの打ち傷のゆえに、あなたがたは、いやされたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P12_25","090_2_25","1PE","2","25","25","あなたがたは、羊のようにさまよっていましたが、今は、自分のたましいの牧者であり監督者である方のもとに帰ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_1","090_3_1","1PE","3","1","1","同じように、妻たちよ。自分の夫に服従しなさい。たとい、みことばに従わない夫であっても、妻の無言のふるまいによって、神のものとされるようになるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_2","090_3_2","1PE","3","2","2","それは、あなたがたの、神を恐れかしこむ清い生き方を彼らが見るからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_3","090_3_3","1PE","3","3","3","あなたがたは、髪を編んだり、金の飾りをつけたり、着物を着飾るような外面的なものでなく、 ");
INSERT INTO jpn1965_vpl VALUES ("P13_4","090_3_4","1PE","3","4","4","むしろ、柔和で穏やかな霊という朽ちることのないものを持つ、心の中の隠れた人がらを飾りにしなさい。これこそ、神の御前に価値あるものです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_5","090_3_5","1PE","3","5","5","むかし神に望みを置いた敬虔な婦人たちも、このように自分を飾って、夫に従ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_6","090_3_6","1PE","3","6","6","たとえばサラも、アブラハムを主と呼んで彼に従いました。あなたがたも、どんなことをも恐れないで善を行なえば、サラの子となるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_7","090_3_7","1PE","3","7","7","同じように、夫たちよ。妻が女性であって、自分よりも弱い器だということをわきまえて妻とともに生活し、いのちの恵みをともに受け継ぐ者として尊敬しなさい。それは、あなたがたの祈りが妨げられないためです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_8","090_3_8","1PE","3","8","8","最後に申します。あなたがたはみな、心を一つにし、同情し合い、兄弟愛を示し、あわれみ深く、謙遜でありなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_9","090_3_9","1PE","3","9","9","悪をもって悪に報いず、侮辱をもって侮辱に報いず、かえって祝福を与えなさい。あなたがたは祝福を受け継ぐために召されたのだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_10","090_3_10","1PE","3","10","10","「いのちを愛し、 幸いな日々を過ごしたいと思う者は、 舌を押えて悪を言わず、 くちびるを閉ざして偽りを語らず、 ");
INSERT INTO jpn1965_vpl VALUES ("P13_11","090_3_11","1PE","3","11","11","悪から遠ざかって善を行ない、 平和を求めてこれを追い求めよ。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_12","090_3_12","1PE","3","12","12","主の目は義人の上に注がれ、 主の耳は彼らの祈りに傾けられる。 しかし主の顔は、 悪を行なう者に立ち向かう。」 ");
INSERT INTO jpn1965_vpl VALUES ("P13_13","090_3_13","1PE","3","13","13","もし、あなたがたが善に熱心であるなら、だれがあなたがたに害を加えるでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_14","090_3_14","1PE","3","14","14","いや、たとい義のために苦しむことがあるにしても、それは幸いなことです。彼らの脅かしを恐れたり、それによって心を動揺させたりしてはいけません。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_15","090_3_15","1PE","3","15","15","むしろ、心の中でキリストを主としてあがめなさい。そして、あなたがたのうちにある希望について説明を求める人には、だれにでもいつでも弁明できる用意をしていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_16","090_3_16","1PE","3","16","16","ただし、優しく、慎み恐れて、また、正しい良心をもって弁明しなさい。そうすれば、キリストにあるあなたがたの正しい生き方をののしる人たちが、あなたがたをそしったことで恥じ入るでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_17","090_3_17","1PE","3","17","17","もし、神のみこころなら、善を行なって苦しみを受けるのが、悪を行なって苦しみを受けるよりよいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_18","090_3_18","1PE","3","18","18","キリストも一度罪のために死なれました。正しい方が悪い人々の身代わりとなったのです。それは、肉においては死に渡され、霊においては生かされて、私たちを神のみもとに導くためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_19","090_3_19","1PE","3","19","19","その霊において、キリストは捕われの霊たちのところに行ってみことばを宣べられたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_20","090_3_20","1PE","3","20","20","昔、ノアの時代に、箱舟が造られていた間、神が忍耐して待っておられたときに、従わなかった霊たちのことです。わずか八人の人々が、この箱舟の中で、水を通って救われたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_21","090_3_21","1PE","3","21","21","そのことは、今あなたがたを救うバプテスマをあらかじめ示した型なのです。バプテスマは肉体の汚れを取り除くものではなく、正しい良心の神への誓いであり、イエス・キリストの復活によるものです。 ");
INSERT INTO jpn1965_vpl VALUES ("P13_22","090_3_22","1PE","3","22","22","キリストは天に上り、御使いたち、および、もろもろの権威と権力を従えて、神の右の座におられます。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_1","090_4_1","1PE","4","1","1","このように、キリストは肉体において苦しみを受けられたのですから、あなたがたも同じ心構えで自分自身を武装しなさい。肉体において苦しみを受けた人は、罪とのかかわりを断ちました。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_2","090_4_2","1PE","4","2","2","こうしてあなたがたは、地上の残された時を、もはや人間の欲望のためではなく、神のみこころのために過ごすようになるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_3","090_4_3","1PE","4","3","3","あなたがたは、異邦人たちがしたいと思っていることを行ない、好色、情欲、酔酒、遊興、宴会騒ぎ、忌むべき偶像礼拝などにふけったものですが、それは過ぎ去った時で、もう十分です。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_4","090_4_4","1PE","4","4","4","彼らは、あなたがたが自分たちといっしょに度を過ごした放蕩に走らないので不思議に思い、また悪口を言います。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_5","090_4_5","1PE","4","5","5","彼らは、生きている人々をも死んだ人々をも、すぐにもさばこうとしている方に対し、申し開きをしなければなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_6","090_4_6","1PE","4","6","6","というのは、死んだ人々にも福音が宣べ伝えられていたのですが、それはその人々が肉体においては人間としてさばきを受けるが、霊においては神によって生きるためでした。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_7","090_4_7","1PE","4","7","7","万物の終わりが近づきました。ですから、祈りのために、心を整え身を慎みなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_8","090_4_8","1PE","4","8","8","何よりもまず、互いに熱心に愛し合いなさい。愛は多くの罪をおおうからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_9","090_4_9","1PE","4","9","9","つぶやかないで、互いに親切にもてなし合いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_10","090_4_10","1PE","4","10","10","それぞれが賜物を受けているのですから、神のさまざまな恵みの良い管理者として、その賜物を用いて、互いに仕え合いなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_11","090_4_11","1PE","4","11","11","語る人があれば、神のことばにふさわしく語り、奉仕する人があれば、神が豊かに備えてくださる力によって、それにふさわしく奉仕しなさい。それは、すべてのことにおいて、イエス・キリストを通して神があがめられるためです。栄光と支配が世々限りなくキリストにありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_12","090_4_12","1PE","4","12","12","愛する者たち。あなたがたを試みるためにあなたがたの間に燃えさかる火の試練を、何か思いがけないことが起こったかのように驚き怪しむことなく、 ");
INSERT INTO jpn1965_vpl VALUES ("P14_13","090_4_13","1PE","4","13","13","むしろ、キリストの苦しみにあずかれるのですから、喜んでいなさい。それは、キリストの栄光が現われるときにも、喜びおどる者となるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_14","090_4_14","1PE","4","14","14","もしキリストの名のために非難を受けるなら、あなたがたは幸いです。なぜなら、栄光の御霊、すなわち神の御霊が、あなたがたの上にとどまってくださるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_15","090_4_15","1PE","4","15","15","あなたがたのうちのだれも、人殺し、盗人、悪を行なう者、みだりに他人に干渉する者として苦しみを受けるようなことがあってはなりません。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_16","090_4_16","1PE","4","16","16","しかし、キリスト者として苦しみを受けるのなら、恥じることはありません。かえって、この名のゆえに神をあがめなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_17","090_4_17","1PE","4","17","17","なぜなら、さばきが神の家から始まる時が来ているからです。さばきが、まず私たちから始まるのだとしたら、神の福音に従わない人たちの終わりは、どうなることでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_18","090_4_18","1PE","4","18","18","義人がかろうじて救われるのだとしたら、神を敬わない者や罪人たちは、いったいどうなるのでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("P14_19","090_4_19","1PE","4","19","19","ですから、神のみこころに従ってなお苦しみに会っている人々は、善を行なうにあたって、真実であられる創造者に自分のたましいをお任せしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_1","090_5_1","1PE","5","1","1","そこで、私は、あなたがたのうちの長老たちに、同じく長老のひとり、キリストの苦難の証人、また、やがて現われる栄光にあずかる者として、お勧めします。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_2","090_5_2","1PE","5","2","2","あなたがたのうちにいる、神の羊の群れを、牧しなさい。強制されてするのではなく、神に従って、自分から進んでそれをなし、卑しい利得を求める心からではなく、心を込めてそれをしなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_3","090_5_3","1PE","5","3","3","あなたがたは、その割り当てられている人たちを支配するのではなく、むしろ群れの模範となりなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_4","090_5_4","1PE","5","4","4","そうすれば、大牧者が現われるときに、あなたがたは、しぼむことのない栄光の冠を受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_5","090_5_5","1PE","5","5","5","同じように、若い人たちよ。長老たちに従いなさい。みな互いに謙遜を身に着けなさい。神は高ぶる者に敵対し、へりくだる者に恵みを与えられるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_6","090_5_6","1PE","5","6","6","ですから、あなたがたは、神の力強い御手の下にへりくだりなさい。神が、ちょうど良い時に、あなたがたを高くしてくださるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_7","090_5_7","1PE","5","7","7","あなたがたの思い煩いを、いっさい神にゆだねなさい。神があなたがたのことを心配してくださるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_8","090_5_8","1PE","5","8","8","身を慎み、目をさましていなさい。あなたがたの敵である悪魔が、ほえたけるししのように、食い尽くすべきものを捜し求めながら、歩き回っています。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_9","090_5_9","1PE","5","9","9","堅く信仰に立って、この悪魔に立ち向かいなさい。ご承知のように、世にあるあなたがたの兄弟である人々は同じ苦しみを通って来たのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_10","090_5_10","1PE","5","10","10","あらゆる恵みに満ちた神、すなわち、あなたがたをキリストにあってその永遠の栄光の中に招き入れてくださった神ご自身が、あなたがたをしばらくの苦しみのあとで完全にし、堅く立たせ、強くし、不動の者としてくださいます。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_11","090_5_11","1PE","5","11","11","どうか、神のご支配が世々限りなくありますように。アーメン。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_12","090_5_12","1PE","5","12","12","私の認めている忠実な兄弟シルワノによって、私はここに簡潔に書き送り、勧めをし、これが神の真の恵みであることをあかししました。この恵みの中に、しっかりと立っていなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_13","090_5_13","1PE","5","13","13","バビロンにいる、あなたがたとともに選ばれた婦人がよろしくと言っています。また私の子マルコもよろしくと言っています。 ");
INSERT INTO jpn1965_vpl VALUES ("P15_14","090_5_14","1PE","5","14","14","愛の口づけをもって互いにあいさつをかわしなさい。 キリストにあるあなたがたすべての者に、平安がありますように。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_1","091_1_1","2PE","1","1","1","イエス・キリストのしもべであり使徒であるシモン・ペテロから、私たちの神であり救い主であるイエス・キリストの義によって私たちと同じ尊い信仰を受けた方々へ。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_2","091_1_2","2PE","1","2","2","神と私たちの主イエスを知ることによって、恵みと平安が、あなたがたの上にますます豊かにされますように。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_3","091_1_3","2PE","1","3","3","というのは、私たちをご自身の栄光と徳によってお召しになった方を私たちが知ったことによって、主イエスの、神としての御力は、いのちと敬虔に関するすべてのことを私たちに与えるからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_4","091_1_4","2PE","1","4","4","その栄光と徳によって、尊い、すばらしい約束が私たちに与えられました。それは、あなたがたが、その約束のゆえに、世にある欲のもたらす滅びを免れ、神のご性質にあずかる者となるためです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_5","091_1_5","2PE","1","5","5","こういうわけですから、あなたがたは、あらゆる努力をして、信仰には徳を、徳には知識を、 ");
INSERT INTO jpn1965_vpl VALUES ("P21_6","091_1_6","2PE","1","6","6","知識には自制を、自制には忍耐を、忍耐には敬虔を、 ");
INSERT INTO jpn1965_vpl VALUES ("P21_7","091_1_7","2PE","1","7","7","敬虔には兄弟愛を、兄弟愛には愛を加えなさい。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_8","091_1_8","2PE","1","8","8","これらがあなたがたに備わり、ますます豊かになるなら、あなたがたは、私たちの主イエス・キリストを知る点で、役に立たない者とか、実を結ばない者になることはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_9","091_1_9","2PE","1","9","9","これらを備えていない者は、近視眼であり、盲目であって、自分の以前の罪がきよめられたことを忘れてしまったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_10","091_1_10","2PE","1","10","10","ですから、兄弟たちよ。ますます熱心に、あなたがたの召されたことと選ばれたこととを確かなものとしなさい。これらのことを行なっていれば、つまずくことなど決してありません。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_11","091_1_11","2PE","1","11","11","このようにあなたがたは、私たちの主であり救い主であるイエス・キリストの永遠の御国にはいる恵みを豊かに加えられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_12","091_1_12","2PE","1","12","12","ですから、すでにこれらのことを知っており、現に持っている真理に堅く立っているあなたがたであるとはいえ、私はいつもこれらのことを、あなたがたに思い起こさせようとするのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_13","091_1_13","2PE","1","13","13","私が地上の幕屋にいる間は、これらのことを思い起こさせることによって、あなたがたを奮い立たせることを、私のなすべきことと思っています。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_14","091_1_14","2PE","1","14","14","それは、私たちの主イエス・キリストも、私にはっきりお示しになったとおり、私がこの幕屋を脱ぎ捨てるのが間近に迫っているのを知っているからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_15","091_1_15","2PE","1","15","15","また、私の去った後に、あなたがたがいつでもこれらのことを思い起こせるよう、私は努めたいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_16","091_1_16","2PE","1","16","16","私たちは、あなたがたに、私たちの主イエス・キリストの力と来臨とを知らせましたが、それは、うまく考え出した作り話に従ったのではありません。この私たちは、キリストの威光の目撃者なのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_17","091_1_17","2PE","1","17","17","キリストが父なる神から誉れと栄光をお受けになったとき、おごそかな、栄光の神から、こういう御声がかかりました。「これはわたしの愛する子、わたしの喜ぶ者である。」 ");
INSERT INTO jpn1965_vpl VALUES ("P21_18","091_1_18","2PE","1","18","18","私たちは聖なる山で主イエスとともにいたので、天からかかったこの御声を、自分自身で聞いたのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_19","091_1_19","2PE","1","19","19","また、私たちは、さらに確かな預言のみことばを持っています。夜明けとなって、明けの明星があなたがたの心の中に上るまでは、暗い所を照らすともしびとして、それに目を留めているとよいのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_20","091_1_20","2PE","1","20","20","それには何よりも次のことを知っていなければいけません。すなわち、聖書の預言はみな、人の私的解釈を施してはならない、ということです。 ");
INSERT INTO jpn1965_vpl VALUES ("P21_21","091_1_21","2PE","1","21","21","なぜなら、預言は決して人間の意志によってもたらされたのではなく、聖霊に動かされた人たちが、神からのことばを語ったのだからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_1","091_2_1","2PE","2","1","1","しかし、イスラエルの中には、にせ預言者も出ました。同じように、あなたがたの中にも、にせ教師が現われるようになります。彼らは、滅びをもたらす異端をひそかに持ち込み、自分たちを買い取ってくださった主を否定するようなことさえして、自分たちの身にすみやかな滅びを招いています。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_2","091_2_2","2PE","2","2","2","そして、多くの者が彼らの好色にならい、そのために真理の道がそしりを受けるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_3","091_2_3","2PE","2","3","3","また彼らは、貪欲なので、作り事のことばをもってあなたがたを食い物にします。彼らに対するさばきは、昔から怠りなく行なわれており、彼らが滅ぼされないままでいることはありません。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_4","091_2_4","2PE","2","4","4","神は、罪を犯した御使いたちを、容赦せず、地獄に引き渡し、さばきの時まで暗やみの穴の中に閉じ込めてしまわれました。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_5","091_2_5","2PE","2","5","5","また、昔の世界を赦さず、義を宣べ伝えたノアたち八人の者を保護し、不敬虔な世界に洪水を起こされました。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_6","091_2_6","2PE","2","6","6","また、ソドムとゴモラの町を破滅に定めて灰にし、以後の不敬虔な者へのみせしめとされました。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_7","091_2_7","2PE","2","7","7","また、無節操な者たちの好色なふるまいによって悩まされていた義人ロトを救い出されました。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_8","091_2_8","2PE","2","8","8","というのは、この義人は、彼らの間に住んでいましたが、不法な行ないを見聞きして、日々その正しい心を痛めていたからです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_9","091_2_9","2PE","2","9","9","これらのことでわかるように、主は、敬虔な者たちを誘惑から救い出し、不義な者どもを、さばきの日まで、懲罰のもとに置くことを心得ておられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_10","091_2_10","2PE","2","10","10","汚れた情欲を燃やし、肉に従って歩み、権威を侮る者たちに対しては、特にそうなのです。彼らは、大胆不敵な、尊大な者たちで、栄誉ある人たちをそしって、恐れるところがありません。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_11","091_2_11","2PE","2","11","11","それに比べると、御使いたちは、勢いにも力にもまさっているにもかかわらず、主の御前に彼らをそしって訴えることはしません。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_12","091_2_12","2PE","2","12","12","ところがこの者どもは、捕えられ殺されるために自然に生まれついた、理性のない動物と同じで、自分が知りもしないことをそしるのです。それで動物が滅ぼされるように、彼らも滅ぼされてしまうのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_13","091_2_13","2PE","2","13","13","彼らは不義の報いとして損害を受けるのです。彼らは昼のうちから飲み騒ぐことを楽しみと考えています。彼らは、しみや傷のようなもので、あなたがたといっしょに宴席に連なるときに自分たちのだましごとを楽しんでいるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_14","091_2_14","2PE","2","14","14","その目は淫行に満ちており、罪に関しては飽くことを知らず、心の定まらない者たちを誘惑し、その心は欲に目がありません。彼らはのろいの子です。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_15","091_2_15","2PE","2","15","15","彼らは正しい道を捨ててさまよっています。不義の報酬を愛したベオルの子バラムの道に従ったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_16","091_2_16","2PE","2","16","16","しかし、バラムは自分の罪をとがめられました。ものを言うことのないろばが、人間の声でものを言い、この預言者の気違いざたをはばんだのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_17","091_2_17","2PE","2","17","17","この人たちは、水のない泉、突風に吹き払われる霧です。彼らに用意されているものは、まっ暗なやみです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_18","091_2_18","2PE","2","18","18","彼らは、むなしい大言壮語を吐いており、誤った生き方をしていて、ようやくそれをのがれようとしている人々を肉欲と好色によって誘惑し、 ");
INSERT INTO jpn1965_vpl VALUES ("P22_19","091_2_19","2PE","2","19","19","その人たちに自由を約束しながら、自分自身が滅びの奴隷なのです。人はだれかに征服されれば、その征服者の奴隷となったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_20","091_2_20","2PE","2","20","20","主であり救い主であるイエス・キリストを知ることによって世の汚れからのがれ、その後再びそれに巻き込まれて征服されるなら、そのような人たちの終わりの状態は、初めの状態よりももっと悪いものとなります。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_21","091_2_21","2PE","2","21","21","義の道を知っていながら、自分に伝えられたそのきよい命令にそむくよりは、それを知らなかったほうが、彼らにとってよかったのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P22_22","091_2_22","2PE","2","22","22","彼らに起こったことは、「犬は自分の吐いた物に戻る。」とか、「豚は身を洗って、またどろの中にころがる。」とかいう、ことわざどおりです。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_1","091_3_1","2PE","3","1","1","愛する人たち。いま私がこの第二の手紙をあなたがたに書き送るのは、これらの手紙により、記憶を呼びさまさせて、あなたがたの純真な心を奮い立たせるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_2","091_3_2","2PE","3","2","2","それは、聖なる預言者たちによって前もって語られたみことばと、あなたがたの使徒たちが語った、主であり救い主である方の命令とを思い起こさせるためなのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_3","091_3_3","2PE","3","3","3","まず第一に、次のことを知っておきなさい。終わりの日に、あざける者どもがやって来てあざけり、自分たちの欲望に従って生活し、 ");
INSERT INTO jpn1965_vpl VALUES ("P23_4","091_3_4","2PE","3","4","4","次のように言うでしょう。「キリストの来臨の約束はどこにあるのか。先祖たちが眠った時からこのかた、何事も創造の初めからのままではないか。」 ");
INSERT INTO jpn1965_vpl VALUES ("P23_5","091_3_5","2PE","3","5","5","こう言い張る彼らは、次のことを見落としています。すなわち、天は古い昔からあり、地は神のことばによって水から出て、水によって成ったのであって、 ");
INSERT INTO jpn1965_vpl VALUES ("P23_6","091_3_6","2PE","3","6","6","当時の世界は、その水により、洪水におおわれて滅びました。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_7","091_3_7","2PE","3","7","7","しかし、今の天と地は、同じみことばによって、火に焼かれるためにとっておかれ、不敬虔な者どものさばきと滅びとの日まで、保たれているのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_8","091_3_8","2PE","3","8","8","しかし、愛する人たち。あなたがたは、この一事を見落としてはいけません。すなわち、主の御前では、一日は千年のようであり、千年は一日のようです。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_9","091_3_9","2PE","3","9","9","主は、ある人たちがおそいと思っているように、その約束のことを遅らせておられるのではありません。かえって、あなたがたに対して忍耐深くあられるのであって、ひとりでも滅びることを望まず、すべての人が悔い改めに進むことを望んでおられるのです。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_10","091_3_10","2PE","3","10","10","しかし、主の日は、盗人のようにやって来ます。その日には、天は大きな響きをたてて消えうせ、天の万象は焼けてくずれ去り、地と地のいろいろなわざは焼き尽くされます。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_11","091_3_11","2PE","3","11","11","このように、これらのものはみな、くずれ落ちるものだとすれば、あなたがたは、どれほどきよい生き方をする敬虔な人でなければならないことでしょう。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_12","091_3_12","2PE","3","12","12","そのようにして、神の日の来るのを待ち望み、その日の来るのを早めなければなりません。その日が来れば、そのために、天は燃えてくずれ、天の万象は焼け溶けてしまいます。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_13","091_3_13","2PE","3","13","13","しかし、私たちは、神の約束に従って、正義の住む新しい天と新しい地を待ち望んでいます。 ");
INSERT INTO jpn1965_vpl VALUES ("P23_14