﻿USE sofia;
DROP TABLE IF EXISTS sofia.jnjl_vpl;
CREATE TABLE jnjl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jnjl_vpl WRITE;
INSERT INTO jnjl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dawitni zalaassin; Abrahamni zalaassin koonte Yesus Kiristoosni koontoni tuzaas haniiswa: ");
INSERT INTO jnjl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Yisaqnin kooni. Yisaq Yaqobnin kooni. Yaqob Yuudanawa Aybaasakitoninna kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuuda Faaresninnawa Zaaraninna Tiimar sinfa asuskin kooni. Faares Esromnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Esrom dey Aaramnin kooni. Aaram Aminadabni kooni. Aminadab dey Ne'asonnin kooni. Ne'ason dey Selimonnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Selimon Rakeb yistefa asuskin Boyeznin kooni. Boyez Rut yistefa asuskin Iyyobednin kooni. Iyyobed Isseynin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Issey dey taato sina Dawitnin kooni. Taato Dawit Ooriyonni asuskin Solomonnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon dey Robiyamnin kooni. Robiyam Abiyanin kooni. Abiyan Asafnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf Iyyosafixnin kooni. Iyyosafix Iyyuramnin kooni. Iyyuram Ooziyanin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ooziyan Iyyuatamnin kooni. Iyyuatam Akaaznin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Akaaz Izqiyasnin kooni. Izqiyas Minasenin kooni. Minaase Amosnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Amos Iyyusiyasnin kooni. Iyyusiyas Baabilonni boojoni neyaasik Ikoniyonnawa Aybaasakitoninna kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baabilonni bochoneen orfo Ikoniyon Selatiyalnin kooni. Selatiyal Zerubabelnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel Abiyudnin kooni. Abiyud Eeliyakemnin kooni. Eeliyakem Azarnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azar Sadoknin kooni. Sadok akimnin kooni. Akim Eeliyudnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eeliyud Alazarnin kooni. Alazar Maatanin kooni. Maatan Yaqobnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaqob Kiristoos yiste Yesusnin kooni Maaraminon teege Yosefnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ese Abrahamniistan kabira Dawitniista kar'ananneen asire acheechche koonto. Dawitniistan kabira Baabilonni boojo kar'ananneen asire acheechche koonto. Baabilonni boojoostan kabira Kiristoosni koontoosta kar'ananneen asire acheech koontowa. ");
INSERT INTO jnjl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesus Kiristoosni koontoni tochoos haniiswa; intoba Maarami Yosefnik teegtera diis girunoy Korto Ayyanak naanertera beste. ");
INSERT INTO jnjl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Teegere duusi Yosef ooko asu sinna boor'a Maaraminon asuni sina kisire makok aane sholowe. Baak aachok beyanak shole. ");
INSERT INTO jnjl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sinuntano bar ekka safarefeen Daamiisa wosiya miitok bestera: «Dawitni naa Yosefno! Teegera duusita nawaas naanertenaas Korto Ayyanakin sinna boor'a Maaraminon ephak digotaatawa. ");
INSERT INTO jnjl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bar naanin tanonir; es naas darabaasin boor'besiissin fatunir sinna boor'a sunbaason ‹Yesus› yiratu sunsuta.» ");
INSERT INTO jnjl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Es bar dey sinnaas Daamiis raajjusik: ");
INSERT INTO jnjl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Esenu durbaas naanertona; naanin dey tanona; Sunbaason dey ‹Amanuel› usone yiste bar sinanaktu han bar zuuttera sini. Kotbaas dey: ‹Ha'oos innoneen anetu fawa› uwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosef afay'nitan guzire Daamiisa wosiya makenaasimato zagi. Teegere duusina Maaraminon ephphe keeba hami. ");
INSERT INTO jnjl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Uzun nawubaasin tanonanneen Yosef barneen ane aane kune. Koonte naasa sunanon «Yesus» yire sunsi. ");
INSERT INTO jnjl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus Yuuda Betelemuk taato Herodisni neyaasik koontefena kabaasik aruni meya awakesna diman Yerusalem yeesete. ");
INSERT INTO jnjl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ekka yit mamussete: «Koonte Ayhudni taatoski ayinso? Baakuraason awukesan biyaat barik kaa'nonik yaaniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Taato Herodis es baron odenaase naye. Yerusalemuk feese asuni meya zuuttere barneen ane nayesete. ");
INSERT INTO jnjl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Maagni gaanynye meenawa daraasa tumani assinynyani meena asin zuutire Kiristoos ay koontonamato mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Baasso dey: «Yuudani daasta fa Betelemuk raajjuus ekka yire tichinar faar. ");
INSERT INTO jnjl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Yuudani daastaki fa katama Betelemne! Ta dara sina Israelnon oodni ha'sinynya neekin kesnir sinna boor'a inya inya katamaassin ne aafa hatota wuza› yistera maktera faar» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Esseen orfo Herodis aruni meyanon aachok teegere baakuraas baassok bestena wonaason mamsire ari. ");
INSERT INTO jnjl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Baassotin ekka yit wosi: «Betelem hamfaat koonte naasin gasasutiwa; danefaatine taak dey yaara makoti. Ta dey hamma barik kaa'nona» ");
INSERT INTO jnjl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Baasso dey taatoosa kaamanon odere hamete. Awakesna diman biyete baakuraas naas feena dimaasta hamma yeronanneen zoonsit faar. ");
INSERT INTO jnjl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Baakuraason biyeteese akama gira girsete. ");
INSERT INTO jnjl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Keer girsere daag naas intoba Maaramineen ane feen biyete. Barki sina sinbesiisik sagadesere saxinibesiison gachche warqe, ixaananewa kumbine asi ima imesete. ");
INSERT INTO jnjl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aruni meya wolsere Herodisniki hamonoytemato baassok Ha'o miitok makena boor'a ooma ugnak daabesi hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aruni meya hametenneen orfo Daamiisa wosiya miitok Yosefnik bestera: «Herodis daag naasin worunak sholedifer sinna boor'a kabira naasin intobaasneen ane ephpha Giphtsi hamma; ta neek makonanneen esta fowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosef dey kabire daag naasin intobaasneen ane ephphe waalak Giphtsi hami. ");
INSERT INTO jnjl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Daamiis raajjubaasik: «Naataasin Giphtsin teegengwa» yina bar sinanaktu Giphtsi hamete. Herodis kitunanneen esta diisete. ");
INSERT INTO jnjl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Esseen orfo Herodis aruni meya barin eshere aatte hamobesiison araat akamanon gi'tere aruni meyakin odena neyaasik Beetelemnewa biratobaastana fa daastaki neeba hepnewa esseen daakalo fa garo garo naanggotaason zuutire wortonak zagi. ");
INSERT INTO jnjl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Es kabaasik raajju Ermiyasnik makte raajiis siniwa. ");
INSERT INTO jnjl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Rahel naanggotbaasik waasi; waasnewa akama soosone asi kaama Ramak odte. Naanggotbaas aafa sinna boor'a fakuk aane chima» yiste bar sini. ");
INSERT INTO jnjl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodis kitinanneen orfo Daamiisa wosiya Giphtsik Yosefnik miitok bestera: ");
INSERT INTO jnjl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Daag naasa kaanon tishkuk shole bar kitiwa. Kabira daag naaneesin intobaasneen ane ephpha Israelni daa hamma» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yosef kabire daag naasin intobaasneen ephphe Israelni daa hami. ");
INSERT INTO jnjl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herodisni naa Arkelawos ababaasa edde Yuudaki daasta taattenamato odere esta hama dige. Sinuntano orfo miito biire Galiilani daa hami. ");
INSERT INTO jnjl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Raajjunik: «Naazirawi ustona» yiste bar sinanak Naaziret yiste katamaassi hamme di. ");
INSERT INTO jnjl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Es kabaasik haphqife Yohannis Yuudani daastaki ichma daassi maket ye. ");
INSERT INTO jnjl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Es maket yeenaas dey: «Samani taatoos tai'se sinna boor'a harmutiwa» yifar. ");
INSERT INTO jnjl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Raajju sina Isayyasni matsafaassi: « ‹Daamiisa ugnanon hoossuti; sapsira dey zeephti› iyaafe ichma daassi chaaget fe asuni kaama» yistera makte bar haniiswa. ");
INSERT INTO jnjl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohannis mayfena mayaas Gaalani esak wiche maama. Geshobaasta dey googoni talfa taar'et feer. Muubaas dey bilnganewa zaboni eesne. ");
INSERT INTO jnjl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Es kabaasik Yerusalemun, Yuudani daa zuuttambaase asiissin, Yordanosni biratoosta fa daas zuuttambaase asiissi fe asuni meya zuuttere barki yeet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Boor'besiison harmifaafe Yordanoski akaassi barik haphuktet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohannis showo Ferisawini meenawa Seduqawini meena haphuktok barki yeesefeen biyaat: «Nitto ufoni naanggota; yoonak fa Ha'oosi gi'sin kesatik oonso nittok makeri? ");
INSERT INTO jnjl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ese harmuntiison besifa wosto wostoti. ");
INSERT INTO jnjl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nibnitiissi: ‹Abraham inno abawa› yifetimatotawa. Nittok makefawungwa; Ha'oos han shu'aaskitosin kabgira Abrahamni naanggota zagunak chimanawa. ");
INSERT INTO jnjl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hash anfala i'oosi diisi kunfarwa; ma'a gaana gaannoy i'oosikito zuuttera katerna geesi ha'tona. ");
INSERT INTO jnjl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ta harmiyaasik akaktu haphquna; ta chaa'mabaasi taar'anon kotanak chimnoynar tayistan akamanon denalo sina bar ta orfoosta yoonir. Bar Korto Ayyanaknawa geyaknatu haphquna. ");
INSERT INTO jnjl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Meyaason sama ha'una manshiis kushubaassitu fa; oodaason mai'sire kaynuna; zagooson botobaassi gaagana; sinuntano ufaason tishunoy geesi kiichuna» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Es kabaasik Yesus Yohannis barin haphqunak Galiilan Yordanoski akaaski ye. ");
INSERT INTO jnjl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sinuntano Yohannis: «Taan ne haphqutak sholsu sinna feen ne taaki yaafatoso?» yit kali. ");
INSERT INTO jnjl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesus wolgire: «Taan kalataatawa; ooko sina baron zagunak sholsu sinna boor'a beywa» yin es kabaasik Yohannis «ma'i» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesus haphuktenanneen orfo geregere akaassin kesi. Estan samaas gachchen Ha'oni Ayyana nakalone faar sinna basaasta kerefeen bi. ");
INSERT INTO jnjl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kaama dey saman yaara: «Haniis ta shunfana naaswa; bariktu girefawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Esseen orfo Ha'oni Ayyana Yesus dabulosnik fattantonak zoonsira ichma daassi hami. ");
INSERT INTO jnjl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Estak Yesus acheechasir wonnewa waalne soomenanneen orfo makte. ");
INSERT INTO jnjl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Fattanoni bar tai'sere: «Ne Ha'oni naa sinfaatane han shu'aasikito tusha sinanak ajajebbo» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sinuntano Yesus wolgire: « ‹Asu Ha'oosi noonosin kesfa kaama zuuttambaase asiktano muu muuk aane feefe› yistera tichchewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Esseen orfo Daabulos Yesusnin Yerusalem ephphe taamme betemeqdesiisi tukta yeetaat: ");
INSERT INTO jnjl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Eeka yi: « ‹Wochonees shu'aasta tuusa'onoymato neen oodanak Ha'oos wosibaason ajajonawa. Kushubesiisik dey neen kabugsonewa› yistera tichchewa; ese ne Ha'oni Naa sinfaatane yeet golo teetneeson ha'uwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus dey wolgire: « ‹Daama Ha'oneeson fattanotaata› yistera dey tichchewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Hepsa dey Daabulos Yesusnin akama dicha aamta kisire yeetaat han daasi taatoni ulfinanon zuutire besaat: ");
INSERT INTO jnjl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«Ne taak gandera sagadefaatane han baron zuutira neek imanawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Es kabaasik Yesus: «Hantan kes! Ne Sexana; ‹Daama Ha'oneesik kaa'no. Bar baron shiipho› yistera tichchewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Es kabaasik Daabulos barin beyi; Ha'oosi wosiya dey tai'sera barin argasit faaser. ");
INSERT INTO jnjl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesus Yohannis taatoni keer girubaason odenayse Galiila hami. ");
INSERT INTO jnjl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naaziretnon beyfaat Zabiloonnewa Niftalemne asi awurajja Galiilani baarisi ha'ta fa Kifirnahom yistefa katamaassi hamme di. ");
INSERT INTO jnjl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Es bar dey sinnay raajju Isayyas ekka yit makena kaamaas sinanakwa. ");
INSERT INTO jnjl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zabulonni daas, Niftalemni daas, Yordanosni yesalo baarisi ha'ta fa; Aazabni meenir sina Galiila; ");
INSERT INTO jnjl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Talmaassi fe daraas; akama chaarefa bi; kituni yirara faana daasta diise baassok; chaarefa kessa beste.» ");
INSERT INTO jnjl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Es wonaastaneen kabire Yesus: «Ha'oosi taato tai'sewa; Harmutiwa» iyaafe mako ephi. ");
INSERT INTO jnjl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesus Galiilaki baarisi tesha aatfet hep ayni meya Phexiros yistefe Simoonninnawa ayba Indiriyasninna kurxummi eshak yugudobesiison akaassi ha'sefeen bi. Baasso wostoos dey kurxummini esha. ");
INSERT INTO jnjl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesus dey baassok: «Taneen ane yaafaat asuni meyanon Ha'oosi taatosi wolgutik nittotin zagunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Baasso dey geregere yugudobesiison beyfaat barneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Estan aatte oom hep ayna ayna Zebdewosni naanggot sina Yaqobnawa Yohannisna asin bi. Ababesi Zebdewosneen ane goonuusta diisefaat yugudobesiison mai'sifeen biyaat teege. ");
INSERT INTO jnjl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Baasso dey geregere goonuusewa ababesiisna asin beyfaat Yesusneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus baasso Ayhudni shiiphoni keyaasikitosi assit Ha'oosi taatoni misirachchuni kaamaason maket daraasasi fa showo tesa meroson zuutire fatit Galiilani daa zuuttambaase asiissi biratet feer. ");
INSERT INTO jnjl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesus zagina chowaasi wolla Soriyani daa zuuttambaase asiissi odte. Showo tesa merok mette asuni meyanonnawa rakkokna oottere fe asuni meyanon, dey kiina ayyana ephna baassotin, akataki merobesi faana baassotinnawa laafani meyanonna zuuttire ephphe Yesusniki teshshesete. Bar dey zuuttambesiise asin fati. ");
INSERT INTO jnjl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galiilani daastaki, asir katamaassin, Yerusalemun, Yuudan, dey Yordanosni yeesalon showo dara Yesusneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus showo dara barki yeefeen biyaat aamaasta kesse di. Nawobaasakito dey barki yeeseten ");
INSERT INTO jnjl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ekka yit assu ephi: ");
INSERT INTO jnjl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ha'oosi taato baassor sinna boor'a; amantobesiison Ha'oosta zagsefaat; teetbesiison daa ephefe baasso suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ha'o baassok chima imnir sinna boor'a; suumet feesefe baasso suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Teetbesiison daa ephefe baasso; han daason warasosoner sinna boor'a suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ooko sina wostooson; maktere iktet feesefe baasso; gawusoner sinna boor'a suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Feeshun yisefe baasso; baassok feeshun ustonir sinna boor'a suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nibbesi kayim sina baasso; Ha'ooson biyoner sinna boor'a suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Asunin gansit feesefe baasso; Ha'oni naanggot yistere; teegtosoner sinna boor'a suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ooko sina wuzaasi boor'a kabugtesefe baasso; Ha'oosi taato baassor sinna boor'a suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Ta boor'a asuni meya nittotin me'efe kabaasiknawa kabugsefe kabaasikna dey eshak sunnitiison mangsisefe kabaasik nitto suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Waagnitiis den samak akama sinna boor'a girotiwa. Dey akamanon giroti. Nittoostan zeemme fe raajjuni meyaasta esiisimatotu shana katisetewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Dey Yesus: «Nitto han daasi kawowa. Sinuntano kawoos kaar'ba tishifaanane aakkagira kaar'nirinso? Ek gero hai'tera asuni wochosi yetonaastano ke'ana wuzaba aafawa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nitto han daasik chaarefawa. Aamaasta keetera di katamaas aachonak aafawa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Asu tona tonire waashshi duusifewoso? Tega dimtatanoso duusaan keyaassi fe asusik zuutira chaarefanari? ");
INSERT INTO jnjl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Esiisimato asuni meya nitto ma'a wostooson biyere samaki abantiisin ulfinsusonek chaarefnitiis asu zuuttambaase asi sina chaarongwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Dey Yesus: «Ta Museni tumaasonnawa raajjuni meeni kaamaasonna shaarok yaanarne faar sinna nittok bestonaatawa. Ta yaanaas zagunakwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ta futok nittok makefawungwa; samaasewa daase aatananneen tumaassin millu duktonu wostota feeshnoy aafawa aatana wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ese han ajajiissin ater sina isaason shaarefe barnawa esiisimato dey asunik assife barna samaki taatoossik zuuttambaase asiistan daakalotu sinana. Sinuntano zagife bar wedey assife bar oonu sinfaanane samaki taatoossi arkir yisteretu teegtona. ");
INSERT INTO jnjl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nittok makefawungwa; nitto ooko sinaas Museni tumaasi assinynyaasatannawa Ferisawini meyaastanna denalo sina shakaanane samaki Ha'oosi taatosi isanne aafawa giruti wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Zeemoti baassok ‹Kaa worutiita› wori basaasta mangsu kater yistenamato odetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sinuntano ta nittok makefawungwa; aybaasata gi'tefe basaasta mangsu katerwa. Dey aybaasin: ‹Ne ke'nor› yire me'a basaasta mangsu katerwa. Oonu dey: ‹Ne odo oyo› yife bar zuuttambaase geeni tir'maassi giruni mangsutu katonirwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Es bari boor'a Ha'oosik imata imneeson shoo'aasta teshshefata kabaasik ayneesin tugita chowa foobaason yaadatefaatane; ");
INSERT INTO jnjl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Es Ha'oosik imata imneeson shoo'aasi tesha kunsaat zeemma hamma ayneesneen ane ganowa. Estan wolla yaara imneeson imma. ");
INSERT INTO jnjl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Gumanees neen malaten mangsuni kar'ni keer hamfata kabaasik zeemma uguntak taptera ganowa. Ekka zagu shakaatane gumanees neen aatire gaanynyanik imin gaanynyaas dey aatire meya taar'osik imin taatoni keer girutawa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Futo neek makefawungwa; koi'ni duudeeson kaasutanneen isanne taatoni keyaassin aafa kesata wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Dey Yesus: « ‹Gerkesatiita!› yistenasimato odetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sinuntano ta nittok makefawungwa; mashkasuki biire ane kunanak shole bar zuuttere es kabaasik barneen ane nibbaassik gerkesiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Hoi'ta aafnees neen tuusa'sifaanane woi'ira kisuwa; atune zuuttera geeni tir'maassi ha'tobaasneen atuneessin isaron turkifaatane wayyawa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hoi'ta kushunees neen tuusa'sifaanane kar'a ha'uwa; atunees zuuttera geeni tir'maassi ha'tobaasneen atuneessin isaron turkifaatane wayyawa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Asubaason gafkife bar zuuttambaase gafkuni tichaason imowa» yistena baron odetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sinuntano ta nittok makefawungwa: «Asubaas gerkesfeen dannoy baak gafkife bar zuuttambaase hamma gerkesanaktu zagifewa. Esiisimato dey gafukte baron ephpha bar dey gerkesiwa.» ");
INSERT INTO jnjl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Esha tewutiita; sinuntano teyiti baron Daamiisik zagutiwa» yistena baron odetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sinuntano ta nittok makefawungwa; isanne tewutiita; Den samaas Ha'oosi zigimu sinna boor'a samaasiknu sinfanak tewutiita. ");
INSERT INTO jnjl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Han daas dey Ha'oni wocho yer'na dima sinna boor'a han daasik tewutiita. Yerusalem dey arkitto taatoosa katama sinna boor'a Yerusalemuk tewutiita. ");
INSERT INTO jnjl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Somneesi fashaassin isaron foro wedey kara zaguk aafa chimata wuza sinna boor'a teetneesik tewutaata. ");
INSERT INTO jnjl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sinuntano nitto wollaas «Aa» sinfaanane «Aa» sinun wedey «Indaane» sinfaanane «Indaane» uti. Es baristan oomaas manguskingwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« ‹Aafaasik aafa; ay'aasik ay'a› yistenamato odetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ta nittok makefawungwa; mangu wuza nittoosta zagife asusin guma kaastotiita. Sinuntano hoi'ta gachneeson bocha barik alda gachneeson dey shelgira besuwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sikaloki gaag mayoneeson ephphetoonak neen malatefe barik tukaastaki gaag mayooson daysira imma. ");
INSERT INTO jnjl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Isa asu; isa kiilo meetiri hamatak neen giddisifaanane hep kiilo meetiri daysira barneen ane hamma. ");
INSERT INTO jnjl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Neekin shiiphefe barik imma; neekin liqonak sholefe barik kalataatawa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","« ‹Asunin shungwa; gumaneesin oomto› yiste baron odetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sinuntano ta nittok makefawungwa; gumantiisin shunti; nittotin kabugsefe baassok shiiphoti. ");
INSERT INTO jnjl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Es baron zagaatine samak fe abantiisik naanggota sinati. Ha'oos manguni meyaastanawa ma'a asuni meyaastana awa ichanak zagir. Ookoni meyaastanawa boor'ni meyaastana iro ichanak zagir. ");
INSERT INTO jnjl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nittotin shunfe baasso baassotin shunfaatine awu ke'atirinso? Girbo zuutife baassonu esiisontanoso zagseferi? ");
INSERT INTO jnjl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ayniti aynitiisakitonik naga ooshshesefaatine aro gaddo wuza zagitiso? Aazabni meyanu esiisontanoso zagseferi? ");
INSERT INTO jnjl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Es bari boor'a samak fe abantiis kayim sinnamato nitto dey kayim sinti» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Asuni meya biyotowa iyaat ma'a wostontiison asuni sina zagustan teetnitiison oodtiwa. Es baron zagaatine samak fe abantiiskin danati waagniti aafawa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Es bari boor'a tukamni meyak imfeti kabaasik sinnoy sinne bestesefe baasso asuni meya ulfinsusonek Ayhudni shiiphoni keyaassinawa ugnaastana zagsefeesimato biistok zagutiitawa. Ta futok makefawungwa; waagbesiison ephpheteesetewa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sinuntano ne tukamni meyak imfata kabaasik hoi'ta kushunees zagifana baron alda kushunees arunaata. ");
INSERT INTO jnjl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tukamni meyak imfata imnees aachok sinun. Aachok zagte baron biife abanees neek kaasuna. ");
INSERT INTO jnjl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ha'o shiiphefeti kabaasik sinnoy sinne bestesefe baassosimato sinatiita. Baasso asu taan biyo iyaat Ayhudni shiiphoni keyaassinawa ugnaasi ha'tana yerefaat Ha'oni shiipho shuneter. Futo nittok makefawungwa; waagbesiison ephpheteesetewa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sinuntano ne Ha'o shiiphefata kabaasik keeneeson kulfaat biistonoy abaneeski shiiphowa. Aachok zagte baron biife abanees neek kaasunawa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aazabni meya wolumbesiisi aatamak odtoninne faar sinnatu baassok bestefa. Sinuntano nitto shiiphefeti kabaasik baassosimato shimaasik heppa heppa wolgaat shiiphotiita. ");
INSERT INTO jnjl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ese nitto baassosimato sinatiitawa. Abantiis nitto shiiphonoy faani nittok sholsu wuzason arirwa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ese nitto ekka yira shiiphsoti: « ‹Den samak fe abaniiso; Korto sunnees tegifawungwa; ");
INSERT INTO jnjl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Taatonees yoonwa; ne shunfata bar; den samak sinfanaasimato; han daastak dey sinun. ");
INSERT INTO jnjl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hawungti muuniison; hawung imma. ");
INSERT INTO jnjl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Innotin miir'efe baassotin; feeshun yifeniisimato; mangsuniison feeshun uwa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Manguussin oodtano; fatanasi innotin gedataata. Taatoos, hugnaasewa ulfinaase; koi'ba foontonon neerwa; aamin.› ");
INSERT INTO jnjl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Asuni meya nittoosta katisete miir'aason feeshun iyaatine den samak fe abantiis nittooson feeshun una. ");
INSERT INTO jnjl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sinuntano asuni meya nittoosta katisete miir'aason feeshun uu shakaatine abantiis nitto boor'aason aafa feeshun unawuza. ");
INSERT INTO jnjl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Soomera shiiphefeti kabaasik sinnoy sinne bestesefe baassosimato suumotiita. Baasso soomere shiiphobesiison asu arunak sinbesiison aliqsisefe. Futo nittok makefawungwa; waagbesiison ephpheteesetewa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sinuntano ne soomera shiiphefata kabaasik aafneessi masera fochowa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ekka zagaatane aachok fe abaneesteno soomere shiiphoneeson oom asu aafa aruna wuza. Aachok biife abanees neek kaasuna. ");
INSERT INTO jnjl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Konymar muunaasta shiira dey mangunaasta wiis dey yiishshe wiisona han daasta waaga zuututiitawa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sinuntano konymar muunoynar dey shiira mangunoynar wiisi dey yiishshe wiisonoyna dimta den samak waagnitiison zuututiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Waagnees faanaasta nibnees dey esta foonawa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Atuni tonaas aafawa; es bari boor'a ne aafaas fayya sinfaanane atunees zuuttera chaarefatu sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sinuntano aafnees mettana sinfaanane atunees zuuttera talmatu sinana. Ese neyista fa chaarefaas talma sinnanneen talmaas dey awune faaron arkira talmonirinso? ");
INSERT INTO jnjl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Isa asu hep daamnik wostinynya sinanak aafa chimanawuza. Isaasin oomtefaat hepsaasin shunar sinana wedey isaasin ulfinsaat hepsaasin kashshuna. Esiisimato isa asu Ha'oknawa waagakna wostinynya sinanak aafa chima wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Es bari boor'a nittok makefawungwa; foontiisik awu muunittaaso? Awu ushanittaaso? Awu mayanittaaso? yira rakkatotiitawa. Kaa muustan atu mayaastan denalotanoso? ");
INSERT INTO jnjl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Samaasta fulifa kasaasikitonon biitiwa; aane bukfa, aane kar'fa; gombissi dey aane gaagfa. Samaki fe abantiistu maasifer. Nitto barikitoniistan akamanon denalowa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nittoossin duudere woggabaasta isa wona daysuk chimnir oonso? ");
INSERT INTO jnjl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Eekin mayni boor'a awuniron rakkatefetiso? Bakkeesta diise fur'aasikito aakkak dichfanamato gasasira biitiwa. Aane hopsefa; aane sukfa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sinuntano nittok makefawungwa; Solomonnu fa ulfinba zuuttambaase asik fur'aasikitosin isaasne faaron aane mayewa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Amantonti yo'ina nitto! Ese Ha'oos hash hawung biistefaat wono geyaassi ha'toni bakkeestaki fur'aason ekka maysir sinnanneen nittotin aakkak arkissira maysu beynirinso? ");
INSERT INTO jnjl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ese awu muunittaaso? Awu ushanittaaso? Awu mayanittaaso? Uuk rakkatotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Es baron zuuttire Aazabni meyanu sholseterwa. Es bar zuuttera nittok sholsifanamato samaki abantiis arifewa. ");
INSERT INTO jnjl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sinuntano nitto zeemma Ha'oosi taatononnawa ooko sina baronna sholoti. Es wuzaasikito zuuttera nittok daytera imtona. ");
INSERT INTO jnjl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Es bari boor'a wonotiison safarok rakkatotiita. Wonotiisik wonoti wonaas barik rakkaton. Wonaasik mangubaas hooronawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Nittoosta mangsu katonoynamato ooniistanu mangsu kar'atiita. ");
INSERT INTO jnjl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nitto oom asusata mangsu kar'fetiisne fa mangsuni kar'a nittoosta dey katona. Esiisimato dey nitto oomiisik safarefeti safareesik wolla nittok safartona. ");
INSERT INTO jnjl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ne aafaassi kuni tuchaason biinoy ayneesa aafsi kuni diimaason aakkak biitso? ");
INSERT INTO jnjl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wedey ne aaffaassi kuni tucha feen ayneesin ‹Aafneessi kuni diimaason kisunawa› aakkak yifasso? ");
INSERT INTO jnjl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sinnoy sinne bestefe ne; zeemma ne aafaassi kuni tuchaason kisaat esseen orfo ayneesa aafsi kuni diimaason kisutak gasasira biyatawa. ");
INSERT INTO jnjl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Korto sina wuzason kanaasik imatiita. Inquntiison mukoosi sina ha'utiita. Mukoosikito wochobaasiktu yer'ana. Kanaasikito dey wolla nittotin saar'ana. ");
INSERT INTO jnjl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Shiiphoti nittok imtona; Sholoti danati; Gamalaason ki'ti nittok gachchona. ");
INSERT INTO jnjl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Shiiphe bar zuuttere ephphetoona; Sholefe bar danana; Gamalaason ki'fe barik gachchona. ");
INSERT INTO jnjl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nittoossin naabaas daabbo mamsin shu'a imni aba oonso? ");
INSERT INTO jnjl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kurxummi mamsifaanane zawa imnir oonso? ");
INSERT INTO jnjl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ese nitto mangu asu sinfaat naanggotnitiisik ma'a wuza ima aritinneen eekin den samak fe abantiis shiiphefe baassok futoosik aakka daysire ima beynirinso? ");
INSERT INTO jnjl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ese asuni meya nittok zagsonek sholefeti baron zuutira nitto dey oomiisik esiisimato zaguti. Tumaasewa raajjuni meeni kaamaase esiisontu makefa. ");
INSERT INTO jnjl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Tugo finynyiissi kamo giruti; Tishuni finynyiis ugunbaas akama taga; es finynyiissi kamo girife baasso dey showo. ");
INSERT INTO jnjl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kaani keer taamfa ugnaasi finynya tugowa. Ugunbaas dey tiir'owa. Es baron danni asuni meya dey kiiskuwa. ");
INSERT INTO jnjl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Sikalobesiissi bo'inynya iririkane feer sinefaat fantuni koma mayye nitto ganeyaassi yoosonek fe esh raajjuni meyakin teetnitiison oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Baassotin dey arsotiis gaanbesiistakwa; seer'akin wayinini gaana wedey asewaaskin belesini gaana kephteroso? ");
INSERT INTO jnjl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Esiisimato ma'a i'oos zuuttera ma'a gaanatu gaanfa. Mangu i'oos dey mangu gaanatu gaanfa. ");
INSERT INTO jnjl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ma'a i'oos mangu gaana gaananak wedey mangu i'oos ma'a gaana gaananak aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ma'a gaana gaannoy i'oosikito zuuttera katera geyaassi ha'tona. ");
INSERT INTO jnjl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Es bari boor'a esh raajjuni meyanon gaanbesiistaktu aruti. ");
INSERT INTO jnjl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Den samak fe abataasa fiqadinon zagife barteno taan: ‹Daamiiso! Daamiiso!› yife bar zuuttere Ha'oni taatoossi aafa giruna wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mangsuni kar'ni wono showobesiis: ‹Daamiiso! Daamiiso! Ne sunaasik raaji aane makoweninoso? Ne sunaasik kiina ayyanaason aane kisuweninoso? Ne sunaasik showo biistera artonoy wuza aane zaguweninoso?› usone. ");
INSERT INTO jnjl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Es kabaasik: ‹Ta nittotin aane arifat; nitto mangu meya tayistan wokti› una. ");
INSERT INTO jnjl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Ese han kaamnaason odere wostota feeshife bar zuuttambaase keebaason kaa'oni kaputta keer'a nibbare yere asune feerwa. ");
INSERT INTO jnjl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iroos ichi, omaraas dey wori. Sirus dey sirira es keyaason tugi. Sinuntano es keyaas kaa'ota kaputta keetera diir sinna boor'a aane gandowa. ");
INSERT INTO jnjl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Han kaamnaason odere wostota feeshunoy bar zuuttere keebaason fuututa keer'a gowwa asune feerwa. ");
INSERT INTO jnjl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iroos ichi; omaraas dey ya. Sirus dey sirira es keyaason tugin geregere gande. Gandobaas dey akama mangu sini» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus es wuzasikitonon makere koi'sinanneen orfo darani meya bar makena assusik diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Es darani meya diinqesetees Museni tumaasi assinynyanimato sinnoynamato isa ha'suni hugnaba feena asunimato assit feer sinna boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus aamaastan kerefena kabaasik showo dara barneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Isa awataatoni mettan barki tai'sere: «Daamiiso! Taan shunfaatane fatuk chimatawa» yit sagade. ");
INSERT INTO jnjl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus kushubaason shongere ta'ifaat: «Shunfawungwa kayimma» yin geregere merobaassin fari. ");
INSERT INTO jnjl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Estan Yesus: «Faruneeson ooknu makotaatawa. Sinuntano hamma teetneeson maagnik besuwa. Baassok zaala sinanak faruneeson besifa Muse ajajena maa'aason imma» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesus Kifirnahomni katamaassi kar'fena kabaasik isa tii meya taar'oni meeni gaanynya barki yeere ekka yit shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Daamiiso! Wostinynyataas laafa sinne akamanon mettere keer kunferwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus dey: «Ta yaara wostinynyaneesin fatunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tii meya taar'oni meeni gaanynyaas wolgire: «Daamiiso! Ne taaki keer girutak ta sholsu asutewa. Sinuntano isa kaamnin makefaatane wostinynyataas farunawa. ");
INSERT INTO jnjl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ta dey oom gaanynye meeni ha'suusi sikalositu ha'ifawungwa. Ta dey ta sikaloossi ha'sifana meya taar'oni meya feeseterwa. Isaasin ‹Ek hamma› iyaanane hamar. Oomiisin dey ‹yowa› iyaanane yeer. Wostinynyataasin dey: ‹Han baron zaguwa› iyaanane zagir» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus es baron odenayse diinqere barneen ane feese baassok: «Futo nittok makefawungwa; Israelni meeni ganeyaassinnu effatena amantobare yere asunin aane danutwa. ");
INSERT INTO jnjl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nittok makefawungwa; showobesiis awkesannawa awgirunna yeesere Abrahamneen Isaqneen Yaqobneen isarik Ha'oosi taatoni maddita ane muusone. ");
INSERT INTO jnjl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sinuntano han Ha'oosi taatosi girsonek teegtere fe baasso ek gerakalo talmaassitu ha'tosone. Estak waasnewa ha'ni koyet foone baassok sinana» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesus tii meya taar'oni meeni gaanynyaasin: «Hamma, amantoneesimato neek sinfawungwa» yi. Wostinynyabaas dey es kabaasik fari. ");
INSERT INTO jnjl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesus Phexirosni keer girifena kabaasik Phexirosni asusi into gumtanni mero mettera kunfeen bi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Asusi kushunon ta'in meroos dey ma'i. Kabira dey barin irbasi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Waalfana kabaasik kiina ayyana ephna showo asuni meyanon Yesusniki ephphe yeeseten bar es kiina ayyanaason kaambaasik kisi. Dey mettaniisin zuuttire fati. ");
INSERT INTO jnjl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Es baron zagubaasik raajju Isayyasni matsafaassi: «Bar hopiniison ephphe tee; meroniison dey innoostan kabgi» yire makena raajiis sini. ");
INSERT INTO jnjl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesus showo asuni meya biratobaasta zuuttosobesiison biyaat baarisi yesalo finonek nawoni meyanon ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Estan isa Museni tumaasi assinynya Yesusniki yeere: «Assinynyano, ne hamfata dima zuuttambaase asiissi neneen ane hamanawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus wolgire: «Bowasikito ha'ifana dooi'ba faarwa. Samak fulifa kasaas diifana keeba faarwa. Sinuntano Asuni Naa teetbaasonnu teesuna dimba aafawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nawobaasasin oomiis «Daamiiso, zeemma hamma abataas kititen kabbaronak ma'i uwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesus wolgire: «Taneen hamniwa, Kitubesiison kabbarsonek kituni meyak beywa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Estan Yesus goonuussi girin nawobaasakito dey barneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Baariistak akama akani guuboos kabira goonuuson koor'anak kar'i. Sinuntano es kabaasik Yesus kunfer. ");
INSERT INTO jnjl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nawoni meya Yesusniki yeesere: «Daamiiso tishunirwa, innotin fu'aywa» yiset nuskisete. ");
INSERT INTO jnjl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus dey: «Amantontiis yo'ina nitto awuni boor'a digefetiso?» yi. Estan kabire sirusewa baariise asin ke'in akama naga sini. ");
INSERT INTO jnjl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Asuni meya diinqesere: «Sirusewa baariise ajajamena han bar aro asunso» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Baariison finne Gergesenon sinfa daasta kar'fena kabaasik kiina ayyana ephna hep asu moogaassin kesse Yesusneen uphesete. Es hep asuni meya akamanon mangu sinete boor'a asu es ugnaasik aata aane chimfe. ");
INSERT INTO jnjl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Es hep asuni meya dey: «Ne Ha'oni naa Yesusno, inno neneen ane awuni isarni faarinso? Wonaas kar'noyfeen innotin rakkisutak yaatoso?» yit chaagete. ");
INSERT INTO jnjl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Baassostan woksok akama showo mukoni wodo feesh dimta maadifar. ");
INSERT INTO jnjl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kiina ayyanaas dey: «Innotin kisutar sinfaanane ek mukoosi wodosi hamanik zaguwa» yit shiiphse. ");
INSERT INTO jnjl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus dey: «hamoti» yi. Kiina ayyanaasikito dey kessa hamma mukoosi wodosi girse. Estan mukoosi wodo zuuttera kumaastan yeet baariissi taptera eella akaassi girira kitise. ");
INSERT INTO jnjl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mukooson keemfe kezzoosakito dey katamaassi hamme kiina ayyana ephna asuni meeni chowaasonnawa sina wuzasonna maksete. ");
INSERT INTO jnjl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Katamaassi fe asuni meya zuuttere Yesusnin biyonek kesete. Daabesiison gafkire hamanak shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Esseen orfo Yesus goonuussi diire baariison finne daabaastaki katamaassi hami. ");
INSERT INTO jnjl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Estak asuni meya oppota kuni isa laafa asunin Yesusniki ephphe yeesete. Yesus amantobesiison biyaat: «Ne han naataaso! Harewa, boor'neesi feeshun unon danitwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Museni tumaasi assinynyaasasin isa isaas nibbesiissi «Han bar Ha'oosta mei'ni kaama makewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesus dey baasso safaraason arifaat: «Awuni boor'a nibnitiissi effatena mangu wuza safarefetiso? ");
INSERT INTO jnjl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Boor'nees feeshun usingwa wedey kabira hamma uusinso kashoyi? ");
INSERT INTO jnjl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sinuntano Asuni Naa han daastak boor'aason feeshun uni ha'suni hugnaba faanamato arutikwa» iyaat laafa asusin: «Kabira opponeeson wor'a keene hamma» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Asus dey kabire keeba hami. ");
INSERT INTO jnjl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Daraas dey es baron biyaat diinqesete. Han effatena ha'suni hugnaason asunik ima Ha'ooson dey galattesete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesus es dimaastan kabire hamfeen Maatiwos yiste isa asu girbo zuuttefana dimaasta diifen biyaat: «Taneen ane hamniwa» yi. Bar dey kabire barneen ane hami. ");
INSERT INTO jnjl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesus Maatiwosni keer muu muunak tai'sere feen showo girbo zuutife baassotnawa boor'ni meena esta yeesere Yesusneen nawobaasakitoneen ane isarik maddita muuk tai'sete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ferisawini meya es baron biyefaat nawobaasakitonin: «Assinynyantiis awuni boor'a girbo zuutife baassoneen boor'ni meya neen ane muu meediferinso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus es maksete baron odefaat: «Hetni asu sholsifenaas mettanni meyaktano fayyani meyaktawa. ");
INSERT INTO jnjl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hamfaat: ‹Ta sholefanaas fakiyaasontano maa'aasontawa› yistera tichche bar awu sinnamato feretira gasasutiwa. Ta yaanaas ookoni meyak sinnoynaron boor'ni meya harmiya zagsonek teegokwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Es kabaasik Yohannisni nawoosakito Yesusniki yeesere: «Innotnawa Ferisawini meena showo wona soomera shiiphenirwa. Sinuntano ne nawoosakito soomere shiipho beyefees awuni boor'anso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus baassok ekka yire wolgi: «Mariis baassoneen ane feen mozgituni meya suumok chimoneroso? Sinuntano mariis baassostan oor kesse hamana wona yoonawa. Es kabaasiktu soomere shiiphsonewa» ");
INSERT INTO jnjl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kur'u maamaata gaddo erbe kunsire zoorife asu oonu aafewa. Ekka zagaanane gaddo erbees kur'u maamaason kongsirwa. Karatobaas dey tagir. ");
INSERT INTO jnjl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Esiisimato kur'u ha'matoossi gaddo wayinini usha gedfe asu oonu aafewa; Sinuntano ekka zagaanane ha'matoos karatera wayiniisi usha dey wuukterwa. Ha'matoos dey ke'nor sinar. Es bari boor'a gaddo wayinini ushaason gaddo ha'matosi geda sholsuwa. Hepobaase dey ma'arik duuna. ");
INSERT INTO jnjl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesus es baron makefeen isa gaanynya barki yeere sinba kaa'nere: «Naanaas kitiwa, yaara kushuneesik ta'ifaatane farunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus dey kabire asusneen ane hami. Nawobaasakito dey ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Estak asire heppe wogga harinba wuuktet faana isa mashkasu Yesusni orfo kamo yaara maambaason ta'i. ");
INSERT INTO jnjl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bar dey nibbaassi: «Maambaasi fashanonnu ta'ifaanane farunawa» yit faar. ");
INSERT INTO jnjl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus yerqere barki biyaat: «Harewe naanaase! Amantonees neen fatiwe» yi. Asus dey es kabaasik fari. ");
INSERT INTO jnjl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesus gaanynyaasa keer kar'fena kabaasik waasit, markata fugetnawa sasetna yere darani bi. ");
INSERT INTO jnjl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesus dey: «Nawaas afay'nintu kunitano aane kituwa; Hantan shaatotiwa» yin barin kanyere mi'esete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Daraasin kisinanneen orfo keer girire nawaasi kushunon zatin daakun kabi. ");
INSERT INTO jnjl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Es chowaasi wolla es daa zuuttambaase asiissi zi'i. ");
INSERT INTO jnjl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesus es dimaastan kabire hamfeen hep aaftishuni meya: «Dawitni naaso! Innotin fakifaywa» yit chaaget basa orfoose hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aaftishusakito Yesus girina keyaassi girsete. Bar: «Ta aafnitiison gachak chimanamato amanefetiyoso?» yire mamsi. Baasso dey: «Aa, amanefeniwa, Daamiiso!» yit wolgisete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Estan Yesus kushubaasik baasso aafaason ta'ifaat: «Amantontiisimato nittok sinfawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aaffesiis dey gachche. Yesus dey: «Han wuzason ooniknu makotiita» yit chinire ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sinuntano baasso estan kesere es daa zuuttambaase asiista basa chowaason maksete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Es aaffesiis gachchena baasso kesse hamefe kabaasik kiina ayyana ephna isa nibtaato asunin ephphe Yesusniki teshshesete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kiina ayyanaas asusasin kesnanneen orfo nibtaatoos dey wolle. Daraas dey: «Effatena wuza Israelni daastak isanne aane biistera artowawa» yiset diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sinuntano Ferisawini meya: «Kiina ayyanaason asusasin kisifenaas kiina ayyanaasi gaanynyanikwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus Ayhudni shiiphoni keyaassi assit Ha'oosi taatoni misirachchuni kaamanon maket daraasasi fa merosonnawa rakkobesiisonna zuutire fatit katamaassinawa ke'e zuuttambaase asiissina kutit feer. ");
INSERT INTO jnjl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Daraas kezzoba foonto fantunimato rakkatesefeennawa tiir'o baassotin ephaan feesetenna biyaat baassok kenashte. ");
INSERT INTO jnjl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Estan nawobaasakitonik: «Foshaas akamawa; sinuntano wostinynyaas garowa. ");
INSERT INTO jnjl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ese foshaasi Daam foshaasta wostoni wostinynyanin wosunak shiiphotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus asire heppe nawobaasakitonin teegere kiina ayyanaason asusasin kissonek; merosonnawa rakkoosonna fatusonek ha'suni hugna baassok imi. ");
INSERT INTO jnjl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Asire heppe wosini meeni sunaas haniiswa: Phexiros yistefe Simonnawa ayba Indiriyasna, Zebdewosni naanggot Yaqobnawa ayba Yohannisna, ");
INSERT INTO jnjl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filiphoos, Bertelemewos, Tomas, girbo zuutife Matewos, Ilfiyosni naa Yaqob, Tadewos, ");
INSERT INTO jnjl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Koonefe Simon, Yesusnin aatire ima Askorotki Yuuda. ");
INSERT INTO jnjl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesus es asire heppe wosini meyanon ekka yit wosi: «Aazabni meyaki hamatiita. Dey Samirawini meeni katamaassi girutiita. ");
INSERT INTO jnjl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sinuntano fantunimato tishire fe Israelni daraaski hamti. ");
INSERT INTO jnjl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hamfaat: ‹Samaki taatoos tai'sewa› yira makotiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mettanni meyanon fatuti. Kitiisin kitun kabguti. Awataatoni mettaniisin fatuti. Kiina ayyanaason asusasin kisuti. Baak ephti baron baak imti. ");
INSERT INTO jnjl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Warqekin wedey birrikin wedey naasikin wosuste waaga tach'amantiista koor'ira ephatiita. ");
INSERT INTO jnjl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wostinynyanik muuba sholsu sinna boor'a ugunnitiisik ha'mato wedey hep gaagtera mayte maama wedey chaa'ma wedey haaro ephatiita. ");
INSERT INTO jnjl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Isa katamasi wedey ke'esi girifeti kabaasik nittotin ephniis oo sinnamato gasasuti. Es daason gafkira kesatinneen esta footi. ");
INSERT INTO jnjl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Asuni keer girifeti kabaasik naga ooshshosoti. ");
INSERT INTO jnjl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nitto nagaason ephpheteesefaatene nagantiis baassok kar'ana. Sinuntano ephphetoo beyfaatene nagantiis nittok woluna. ");
INSERT INTO jnjl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nitto maketi kaamaason ephphetoo wedey odo beyefaatene es keyaassin wedey es katamaassin kesfeti kabaasik wochontiisi tulonon esta tebuti. ");
INSERT INTO jnjl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta nittok futok makefawungwa, mangsuni kar'ni wonoti ke'oos es katamaastan Sedomiknawa Gamoraknatu kasho sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Ese! Ta nittotin fantunimato iririkaasi ganesi wosuna. Es bari boor'a nitto zawunimato nibnitire yerer; nakalonimato garam sinti. ");
INSERT INTO jnjl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Asuni meya nittotin mangsuni kar'ak shonggosta aatire imone. Ayhudni shiiphoni keyaassik dey nittotin ichosone. Es bari boor'a asusatan teetnitiison oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta chowaasik daa ha'sife baassokinawa taate meyakina oottera hamatir sinna boor'a baasso sinaknawa Aazabni meeni sinakna ta zaal sinati. ");
INSERT INTO jnjl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Asuni meya nittotin shongoosta aatire imefe kabaasik baassok makoti bar es sa'atiistak imtona sinna boor'a: ‹Aakka wedey awu makonittaaso?› yife safara nittotin ephanaatawa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nittoossi faara makoniis samaki Abantiisa Ayyanatano nittotewa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ayiis aybaasin, Abaas naabaasin kituk aatire imana. Naanggotaas dey ababaasatanawa intobaastana guma sinna kabira kituk aatira imana. ");
INSERT INTO jnjl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta boor'a asu zuuttambaase nittotin oomtona. Sinuntano koi'ba kar'ananneen chimme yere bar faruna. ");
INSERT INTO jnjl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Isa katamaassi shana nittoosta arkissisefe kabaasik ooma katamasi shaatoti. Ta futo nittok makefawungwa; Asuni Naa yoonanneen Israelni daa zuuttambaase asiissi aafawa kar'a koi'suti wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Arinynyaas assife basaastan, wostinynyaas daambaasatan aafa denalo sinanawuza. ");
INSERT INTO jnjl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Arinynyaas assinynybaasamato; Wostinynyaas dey daambaasamato sinfaanane hooronawa. Keeni Abaasin: ‹Beelzebulwa› yisetenneen keerki asuni meyanon aakkak mangu suna sunsu beyonerinso? ");
INSERT INTO jnjl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Ese asuni meyanon digotiita; Geepto wuzaas ammanon kessa aafa besto beyana wuza. Aacho wuzaas ammanon kesa aafa beyana wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ta talmaassi nittok makena baron chaarefaasta makoti. Saaksok odeti baron tega dimaasta yerefaat awasuti. ");
INSERT INTO jnjl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ashaason woraat kesse kaason woruk chimnoy asuni meyanon digotiita. Sinuntano ashaasewa kaase woraat kessa geeni tir'maassi tishkuk chimni Ha'ooson digoti. ");
INSERT INTO jnjl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Hep mejmariis uuch duudesi waagtertanoso? Es kasaasikitosin isarnu abantiisa fiqadi sinnoyfeen daasta kere wor'a aafa tishuna wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nitto somaasi fashanu zuuttambaase faadtowa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ese nitto showo meejmaristan denalo sinti boor'a digotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Ta chowaason asuni sinak zaala makefe bar zuuttambaase asik den samak fe Abataasa sinak ta dey barik zaala makona. ");
INSERT INTO jnjl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Asuni sinak taan mormefe barin zuutira ta dey den samak fe Abataasa sinak mormona. ");
INSERT INTO jnjl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ta yaanay han daasta naga ephpha yaanar zagira safarotiitawa. Ta faassotano naga ephpha yoonak aane yootwa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ta yaanay arqa naasin ababaasata; mashka nawaason intobaasta; naasa asunon naasa intota guma sinne kabsonektu yaangwa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Es bari boor'a asunik gumabaas keebaassi fe asustu sinnirwa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tayistan denalo ababaasin wedey intobaason shunfe bar taar sinanak aane sholsifawa. Tayistan denalo arqa naabaasin wedey mashka nawubaason shunfe bar taar sinanak aane sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Basa teetni mesqeliison wor'e taneen ane yoonoy bar taar sinanak aane sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kaabaason fu'ok sholefe bar zuuttambaase tishkuna. Ta sunaasik kaabaason tishkife bar zuuttambaase fu'ona. ");
INSERT INTO jnjl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nittotin ephphe tee bar taan dey ephphetoona. Taan ephphete bar taan wosi Abaasin dey ephphetoona. ");
INSERT INTO jnjl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Raajjuusin raajjuni meeni sunak ephphete bar raajjuni meeni waagaason danana. Ookoosin ookoni meeni sunak ephphete bar ookoni meeni waagaason danana. ");
INSERT INTO jnjl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Futo nittok makefawungwa; ta nawo sinna boor'a han garo garoosasin isaasik koocho aka kubbayyak ima bar waagbaas aafa tishuna wuza.» ");
INSERT INTO jnjl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus asire heppe nawobaasakitonik es ajajiison makere ko'sinayse estan kesse tai'soosta fa katamaasikitosi assuknawa makokna hami. ");
INSERT INTO jnjl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Haphqife Yohannis taatoni keer feegedo Kiristoosni wostooson odere nawobaasasin barki wosire: ");
INSERT INTO jnjl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Es yoonir yiste Kiristoos nengwa wedey oomnin oodanirinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesus dey wolgire: «Hamfaat biiti baronnawa odeti baronna zuutira Yohannisnik makoti. ");
INSERT INTO jnjl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aaftishuni meya biyosoner. Engitni meya kutusoner. Awataatoni mettanni meya farsoner. Odo oyoni meya odosoner. Kituni meya kitun kabsoner. Tukamni meyak misirachchuni kaamaas maktonir. ");
INSERT INTO jnjl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ta chowaasik tuusa'onoy bar zuuttere suustowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohannisni wosiisakito wolle hamobesiise Yesus daraasik Yohannisni chowaasik ekka yit mako ephi: «Awu biyatikinso ichma daassi kesetiri? Sirus shorkifana sobboqoosonnoso? ");
INSERT INTO jnjl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wedey awu biyatikinso kesetiri? Gada maya maye asuninnoso? Esenu gada maya maye baasso taate meeni keertu feesetewa. ");
INSERT INTO jnjl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Wedey awu biyatikinso kesetiri? Raajjuninnoso? Nittok makefawungwa; raajjusatan denalo sina baringwa. ");
INSERT INTO jnjl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","‹Ese ugunneeson sabsuni wositaasin ne sinaasta zeemma wosunawa› yistera tichchenaas barikwa. ");
INSERT INTO jnjl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Futo nittok makefawugwa; mashkasukin koonte asuni meeni ganeyaassin haphqife Yohannisniistan denalo aane kabuwewa. Sinuntano samaki taatoossi ater sina bar Yohannisniistan arkuna. ");
INSERT INTO jnjl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Haphquni Yohannisni neyaastan kabira hash hawung kar'ananneen samaki taatoos akamanon tugtettu fa. Sir giruk kabefe baasso danone. ");
INSERT INTO jnjl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","«Raajjuni meeni assusewa Museni tumaase haphqife Yohannisni neyaasta kar'ananneen raaji make. ");
INSERT INTO jnjl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ese dey ephphetook sholefaatine yoonir yiste Eeliyas han Yohanniswa. ");
INSERT INTO jnjl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Odoni odoba feena bar odowowa. ");
INSERT INTO jnjl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Eekin han wonni koontooson awuneen hoossunarinso? Gabata diisefaat zomobaason teegsefaafa; ");
INSERT INTO jnjl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Ululle nittok fugni, aane suruweti. Sooso soosoni aane waasuweti› yisefa naanggotaasne feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yohannis muunoynawa wayinini usha ushnoyna yeen: ‹Kiina ayyana basaassi faarwa› yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Asuni Naa meetnawa wayinini usha ushetna yeen: ‹Muunewa wayinini usha shunar dey girbo zuutife baassonawa boor'ni meena asi koonwa› yisete. Sinfanaknu matsafaas futo sina wostobaasik artewa.» ");
INSERT INTO jnjl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Estan Yesus arkiron biistera artonoy wuza zagtena katamaasikitoni harmu beyaasik ekka yit wee'o ephi. ");
INSERT INTO jnjl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Haybunewe Korazin, Haybunewe Betesayida! Nittoossi zagte biistera artonoy wuzaas Tirosuknawa Sidonakna zagte sinfaanane suumoni maya mayere bedna teetbesiista wochire showo wona zeemme harmusone kabawe. ");
INSERT INTO jnjl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ese nittok makefawungwe, mangsuni kar'ni wono ke'oos nittoostan Tirosuknawa Sidonaknatu kasho sinanawe. ");
INSERT INTO jnjl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kifirnahomne den sama tegitose? Yeet ke'oni dimaassitu kerotarwe. Neyissi zagte biistera artonoy wuzaas Sodomuk zagte sinfaanane bar tishunoy hash hawungneen kar'a foona kabawe. ");
INSERT INTO jnjl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ese neek makefawungwe; mangsuni kar'ni wono neyista kar'ni ke'oostan Sodomiktu kashonawe» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Es kabaasik Yesus ekka yi: «Samaasewa daase asi Daam Abataaso! Han baron techumni meyakinnawa aruni meyakinna aachaat han garo garo naanggotaasik ammanon kisira besita barik neen galattefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aa, Abataaso han baron zagutak ne ma'a safara siniwa. ");
INSERT INTO jnjl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Abataas zuuttambaase asin taak imiwa. Abaasneen oom naasin arifer oonu aafewa. Esiisimato dey Naasneen oom Abaasin arifer oonu aafewa. Naas ammanon kisire besu shakaanane Abaasin oonu aruk aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Nitto ba'anti fayna hopiis zuuttera taaki yootiwa. Ta nittok beysa imana. ");
INSERT INTO jnjl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Waanjonaason wor'ti; taakin dey arutiwa. Ta garam dey kenashterwa. Kaantiisik dey beysa danati. ");
INSERT INTO jnjl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Waanjoos kulnor, ba'anaas dey kashowa.» ");
INSERT INTO jnjl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Es kabaasik Yesus beysani wonaasik zagoni foshaasi ganesi kamo aatte hami. Nawobaasakito maktesete boor'a bona zagooson mo'e koya ephete. ");
INSERT INTO jnjl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ferisawini meya es baron biyefaat: «Ne nawoosakito beysani wonaasik zagtonak kalto wuzason zagsedifewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesus dey baassok ekka yi: «Dawitnawa barneen ane fe asuni meena maktesefe kabaasik Dawit awu zaginamato aane feretuwetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ha'oosi keer girire maagni meyaktano barik sinun barneen fe asuni meyak kalto korto daabbooson mewa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Wedey maagni meya beysani wonaason ooda beyye betemeqdesi wosto wostesefaatene boor'a sinna aane faadtefa sinnamato Museni tumaassin aane feretuwetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sinuntano ta nittok makefawungwa, betemeqdesiistan denalo sina bar hanta feerwa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‹Fakiyaasontu sholefantano Maa'aasontawa› yifa matsafaasi kaama awu sinnamato yaadateti sinfaanane boor'besi foonto baassosta mangsu kar'ati kabatawa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ese Asuni Naa beysani wonaasiknu daamwa.» ");
INSERT INTO jnjl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus estan kesse hamme Ayhudni shiiphoni keyaassi giri. ");
INSERT INTO jnjl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Estak isa kushuba laafa asu feer. Yesusnin malatok sholet feese isa isa asuni meya: «Beysani wonaasik mettannin fatu faqqadtongwa aanenso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus baassok wolgire: «Nitto ganeyaassin fantuba faana isa asu beysani wonaasik gawusi gandefaanane kisunor oonso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","«Ese asu fantuustan denalo aakkak sina beynirinso? Es bari boor'a beysani wonaasik ma'a wuza zagu aane kaltowawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Esseen orfo kushuba laafa asusin: «Kushuneeson zeephwa» yin zeephi. Isa kushusimato dey ma'a kushu sini. ");
INSERT INTO jnjl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sinuntano Ferisawini meya estan kesere Yesusnin aakkak worsonemato merkesete. ");
INSERT INTO jnjl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sinuntano Yesus baasso mangu safaraason araat estan shaate. Showo asuni meya dey barneen ane hamete. Mettanni meyanon dey zuutire fati. ");
INSERT INTO jnjl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Bar oo sinnamato kisire maksonoytemato ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Es bar dey sinnaas raajju Isayyasni matsafaassi tichchera kuni bar sinanakwa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ese ta korina wostinynyataas han barwa; barin ta shunnar dey bariktu girefan; Ayyananaason basaasta zaguna; bar futoni mangsuni kar'aason daraasik awasuna. ");
INSERT INTO jnjl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bar aafa karakkarona wuza; dey aafa chaagana wuza; kaambaas gero kessa aafa odona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mestera eesto sobboqoosonnu; aafa kiir'ana wuza; chuwet di kar'aason aafa tishkunawuza; es baron zagunaas; futoni mangsuni kar'aason meronanneengwa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aazabni meya basa sunaasiktu abdi zagsone. ");
INSERT INTO jnjl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Esseen orfo asuni meya kiina ayyana ephna aaftishu nibba taato asunin ephphe yeesete. Yesus dey fatin asus biyaknawa wollokna chimi. ");
INSERT INTO jnjl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Daraas zuuttere diinqesere: «Han asus Dawitni naateeso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sinuntano Ferisawini meya odesere: «Han bar Beelzebul yistefa kiina ayyanaasi gaanynyanik sina shakaanane kiina ayyanaason aafa kisuna wuza» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sinuntano Yesus baasso safaraason arifaat ekka yi: «Bare bare oor oor keset fa taatoos zuuttera tishutu tishunawa. Esiisimato dey bare bare oor oor keset fa katamaas wedey keyaas aafa chimma yerona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sexanaas sexanaason kisir sinfaanane bare bare oor oor kesiwa uwa. Ese bari taatoos aakkak chimma yeronirinso? ");
INSERT INTO jnjl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ese ta Beelzebulnik kiina ayyanaason kisaanane nitto zoonsifeti baasso awuk kissonerinso? Ese nitto zoonsifeti baassonu nittoosta mangsu kar'eterwa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sinuntano ta kiina ayyanaason kisifanaas Ha'oosi Ayyanak sinnanneen Ha'oosi taato nittoki yaara kar'iwa uwa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Dey isa asu zeemme hugnaba feena barin taar'noy basa keer girire waagbaason bo'ok aakkak chimnirinso? Hugnaba feena barin taar'attu keyaassi fayiison bo'ok chimanawa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Taneen ane sinnoy bar taan tugga'er; dey taneen ane zuutunoy bar siker. ");
INSERT INTO jnjl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Es bari boor'a ta nittok makefawungwa; asu wostefena boor'aasewa me'aase zuuttera feeshun ustona. Sinuntano Ha'oosi Korto Ayyananon me'a bar boor'baas aafa feeshun ustona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Asuni Naanita mei'ni kaama maksefe bar boor'baas feeshun ustona. Sinuntano Korto Ayyanaasta mei'ni kaama makefe bar han daastak sinun yooni daasta boor'baas aafa feeshun ustona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«I'oos zuuttera gaanbaastaktu artefa sinna boor'a ma'a i'onti faafaanane ma'a gaana danati. I'oos mangu sinfaanane gaanbaas dey mangu sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nitto ufoni naanggota mangu sinfaat aakkak ma'a wuza wollok chimtiso? Asu nibbaassi tuumma fu'te barontu noonobaasik wollefewa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","«Ma'a asu nibbaassi zuutina ma'a mazgabiistan ma'a wuza kisifewa. Mangu asu dey nibbaassi zuutina mangu mazgabiistan mangu wuza kisifewa ");
INSERT INTO jnjl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Futo nittok makefawungwa; asuni meya wolumsefe sinnoy mangu wolla zuuttambaase asik mangsuni kar'ni wono wolguba imonerwa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wollefata kaamneesik neek mangsu katona. Dey wollefata kaamaasik neyista mangsu katona.» ");
INSERT INTO jnjl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Es kabaasik isa isa Ferisawini meenawa Museni tumaasi assinynyana Yesusnin: «Ne biistera artonoy wuza zagin biyanik sholefeniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sinuntano bar wolgire: «Mangu koontoosewa amanonoy koontoose biistera artonoy wuza sholer. Sinuntano raajju Yonasni biistera artonoy wuzasneen ooma biistera artonoy wuza aafa imtona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonas inya kurxummiisi katasi keez wonnewa waalne kunnamato Asuni Naa dey moogaassi keez wonnewa waalne kunana. ");
INSERT INTO jnjl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Neneweni katamaasik asuni meya Yonasni awasuuson odesere boor'besiisik gaabbesere harmisete boor'a mangsuni kar'ni wono han neeni koontoosneen ane kabsere baassosta mangsu kar'osone. Ese hash Yonasniistan denalo hanta feerwa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yeeshdaaki mashka taatoos Solomonni techmaason odok daani dilan kabira yaana boor'a mangsuni kar'ni wono han neeni koontoosneen ane kabira baassosta mangsu kar'ana. Ese hash Solomonniistan denalo hanta feerwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Dey Yesus ekka yi: «Kiina ayyana asunisin kesfana kabaasik beysa sholet akaba foonto dimaassitu kutifa. Sinuntano sholena beysaason aafa danana wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Estan ‹Zeemoti kesna keyaassi wolla hamanawa› yifa. Wolla yeen es keyaas fa wuzba foonto sinna futtera kayimma diifen danfa. ");
INSERT INTO jnjl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Estan dey hamma baristan denalo mangu naafun kiina ayyana ephpha yaara girira barneen ane esta faafa. Es asusik zeemoti foobaastan orfoti foobaas akamanon mangu sinfa. Esiisimato han mangu koontoosta sinniis esiisne faarwa.» ");
INSERT INTO jnjl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesus daraasik makefeen intobaasewa aybaasakitona barneen uphere wollok sholsefaat gerakalo yersefeer. ");
INSERT INTO jnjl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Esta feese asuni meyaassin isaas Yesusnin: «Intoneesewa ayneesakitona neen uphsonek sholefaat gero yerseferwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus dey es make asusik wolgire: «Intonaas oonso? Aytaasakito dey oonotnaysinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kushubaason nawobaasakitoniki besaat: «Ese intonaasewa aytaasakitona haniiswa: ");
INSERT INTO jnjl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Den samaki Abataasa safaranon zagsefe baasso zuuttere ayta, eetna dey intonawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yesus es wono keerun kesse baarisi tesha di. ");
INSERT INTO jnjl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Showo dara basa tesha zuuttena boor'a bar goonuusta kese di. Daraas dey zuuttere baarisi tesha yersefeer. ");
INSERT INTO jnjl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Estan showo wuza besok baassok mako ephi: «Isa bulinynya zala bukanak kesi. ");
INSERT INTO jnjl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bukfena kabaasik isa isa zalaas ugnaasta kere wor'i. Kasaasikito dey yaara kephpha ma. ");
INSERT INTO jnjl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oomaas akama hoi'ba foonto kaa'oosta kere wor'i. Akama ho'a aafa sinna boor'a geregere kayi. Esiis dey zalaas ho'aassi sikalera aane giruwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sinuntano awa kesfana kabaasik aliqi. Tasba tishina boor'a dey ichimi. ");
INSERT INTO jnjl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ooma zalaas dey seer'aasi ganesi kere wor'i. Seer'aas kayira geer'a fu'e. ");
INSERT INTO jnjl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ooma zalaas ma'a daasta kere wor'i. Isaas tiyanon, isaas issunasiron, isaas keezasiron gaani. ");
INSERT INTO jnjl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Odoni odoba feena bar odowowa.» ");
INSERT INTO jnjl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Estan nawobaasakito barki tai'sere: «Awuni boor'a daraasik besok makefasso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bar dey wolgire: «Nittok den samaki Ha'oosi aacho chowanon arutik imtewa. Sinuntano baassok aane imtowawa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Feena barik fayista dayistera imtona dey arkuna. Sinuntano garo kiisku feena barkin es barik fa barnu basaastan ootterwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Baasso biyefet biyonorne feeseter. Odefet odonorne feeseter dey yaadatonorne feeseter sinete boor'atu besok makefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Es bari boor'a raajju Isayyasniissi: « ‹Odoson odetir; sinuntano aane yaadatefeti; biyason biitir sinuntano nibnitiissi aane yaadatefeti. ");
INSERT INTO jnjl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Han daraasa niba muumiwa, odobesiis oyewa; aafbesiis dey talmewa; ekka sina shakaanane aafbesiisik biire; odobesiisik odesere; nibbesiissi yaadatere taaki wolseten fatuna kabawa.› «Yistera maktera kuni raajiis baassosta sinanawa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Sinuntano nitto aafaas biyar; odontiis dey oder sinna boor'a suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Futok nittok makefawungwa; showo raajjuni meenawa ookoni meena nitto biyefeti baron biyonek eenantesere aane biyoto. Odefeti baron eenantesere aane odosoto. ");
INSERT INTO jnjl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Ese nitto zalaasi bukinynyani besosi kotanon odotiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ugnaasta bukte zalaas besifanaas Ha'oosi taatoni kaamanon odere yaadatonoy asusingwa. Dey geregere Sexana yaara nibaassin bukte kaamaason kephfa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kaa'oosta bukte zalaas besifanaas kaambaason odere geregere girak ephpheteefe asusingwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sinuntano tasba aafa sinna boor'a Ha'oosi kaamtan kabi chowa shana wedey kabugto kar'fana kabaasik geregere tuusa'sefe. ");
INSERT INTO jnjl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Seer'aasi ganesi bukte zalaasi besifanaas kaambaason odere ephpheteefe asuswa. Sinuntano han daastaki fooni safaraasewa otumni keeshtanaase kaambaason geer'a gaanba foonto zagifa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma'a daasta bukte zalaas besifanaas kaambaason odere yaadatefe asusingwa. Bar gaana gaanar. Isaas tiyanon, isaas issunasiron isaas keezasiron gaanfa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Dey Yesus ooma beso ekka yit make: «Samaki taatoos foshaasta ma'a zala buka asune faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sinuntano asu zuuttere kunnanneen orfo guma yeere zagoossi kaxakaxa bukaat hami. ");
INSERT INTO jnjl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Zagoos kayira gaanfana kabaasik kaxakaxaas dey ane kessa beste. ");
INSERT INTO jnjl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Foshaasi abani wostinynyani meya barki hamere: ‹Daamiiso; foshneesta ma'a zalaatanoso buktari? Eekin kaxakaxa ayin yaso?› yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«Bar dey baassok wolgire: ‹Han baron zagiis gumaaswa› yi. Wostinynyabaasakito dey: ‹Eekin hamma es kaxakaxaason waar'anik sholefatoso?› yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«Sinuntano bar wolgire: ‹Kaxakaxaason waar'feti kabaasik zagooson dey waar'tir sinna boor'a aafawa sinanawuza› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Beyfaani katona wonaas kar'ananneen ane dichfoon. Kar'ni wono kar'ni baassok: ‹Kaxakaxaason zeemma waar'ti; geyak kiichchonamato basa basak basati. Sinuntano zagooson botonaassi gaagtiwa› una» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Dey Yesus ooma beso ekka yit make: «Samaki taatoos asu ephphe taamme buloossi bukna fi'fi'oni gaanane faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bar zala zuuttambaase asiistan hater. Sinuntano dichfana kabaasik akakilti zuuttambaase asiistan arkifa dey i'o sinfa. Kasaasikito dey yaara waa'baassi keeba keer'a diifa.» ");
INSERT INTO jnjl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Dey Yesus ooma beso ekka yit make: «Samaki taatoos isa mashkasu keez safare buwaneen tushina masone faarwa. Es masoos dey tushoos kesanak zagi.» ");
INSERT INTO jnjl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus es baron zuutire besok daraasik make. Beso foontonon isa wuzane aane makowe. ");
INSERT INTO jnjl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Es barnu ekka sinnaas raajjuniki kamo: «Wolumnaason besoktu makona; han daa testenanneen kabira; aachera fa wuzason makona» yistera tichche bar sinanakwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Estan Yesus daraasin geggessaat keer giri. Nawobaasakito dey barki tai'sesere: «Buloostaki kaxakaxaasi besoni kotanon innok makowa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesus dey ekka yit wolgi: «Ma'a zalaason bukaas Asuni Naawa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Buloos han daaswa. Ma'a zalaas Ha'oosi taatoni naanggotawa. Kaxakaxaas dey sexanni naanggotawa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kaxakaxaason bukaas guma sina Dabuloswa. Kar'ni wonaas dey han daasi ko'awa. Kar'niis dey Ha'oosi wosiyanikitowa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Es Kaxakaxaas kephtera kiichchefanaasimato han daasi ko'ak dey esiisimatotu sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Es kabaasik Asuni Naa wosibaasikitonon wosuna. Barikito dey oomiisin boor'a wostosonek zagsefe mangu meyanon zuutira basa taatoossin kephpha kissona. ");
INSERT INTO jnjl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dey kayo geyaassi ha'sona. Estak waasnewa ay'ni koyet foone sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sinuntano ookoni meya ababesiisa taatosi awanimato chaarosone. Odoni odoba feenaas odowowa.» ");
INSERT INTO jnjl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tusire dey Yesus ekka yi: «Samaki taatoos buloossi aachera kuni otmane faarwa. Isa asu es otmaason danne aachi. Akamanon girobaastan kabi chowa hamme fa foobaason zuutire kisire waagaat es bulooson waage.» ");
INSERT INTO jnjl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Hepsa Yesus ekka yi: «Dey samaki taatoos keeshu Inqu waagok shole naggaddene faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Es naggaddees akamanon sholsu inquuson danynaayse hamme fa wuzbaason zuutire kisire waagaat es baron waage.» ");
INSERT INTO jnjl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tusire dey Yesus: «Esiisimato dey samaki taatoos baariissi ha'tefaat showo tesa kurxummiison zuuti yugudone faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Yugudoos tuumnanneen orfo kurxummiison eshefe baasso zatte baarisi ha'ta kissefe. Estan diisere ma'a ma'aason korisere masaassi gedesefe. Mangu manguuson dey gero ha'sefe. ");
INSERT INTO jnjl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Esiisimato han daasi ko'ak ekkatu sinana. Ha'oosi wosiyanikito yaara boor'ni meyanon ookoni meyaassin koruna. ");
INSERT INTO jnjl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Manguni meyanon dey kayo geyaassi ha'sone. Estak waasnewa ay'ni koyet foone sinana.» ");
INSERT INTO jnjl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dey Yesus: «Han baron zuutira yaadatetiyoso?» yi. Baasso dey: «Aa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesus dey: «Ese samaki taatosi aacho chowanon mai'sire arife tumaasi assinynyaas; koda kunfana keyaassin gaddo sinaaysewa kur'u sinaayse ephphe kisife waagni abane feerwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus es besosikitonon makere koi'sinaase estan kesse hami. ");
INSERT INTO jnjl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Koontena katama Naaziret yeere Ayhudni shiiphoni keyaassi daraasin assit feer. Asuni meya dey diinqere: «Han asus han techmaasewa biistera artonoy wuzaase asin ayin ephphe yeso? ");
INSERT INTO jnjl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Han bar kar'inynya Yosefni naastenoso? Intobaas dey Maaramitanoso? Aybaasakito dey Yaqob, Yosef, Simonnawa Yuudanatenoso? ");
INSERT INTO jnjl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Eetbaasikito dey innoneen anetanoso faasenari? Eekin han asus effatena aruuson zuutire ayin daniso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Es bari boor'a basa chowaasik tuusa'sere ephphetoo beyete. Sinuntano Yesus: «Raajju ulfina dana beyfenaas koontena daastanawa keebaassina koi'bawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Baasso amano beyaastan kabi chowa estak showo biistera artonoy wuza aane zaguwe. ");
INSERT INTO jnjl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Es kabaasik Galiilaki daason ha'sife Herodis Yesusni chowaasi wollanon ode. ");
INSERT INTO jnjl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wostinynyabaasakitonik: «Haniis Haphqife Yohanniswa. Bar kitun kabiwa. Es bari boor'atu han biistera artonoy wuzaas barki kamo zagtedifawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodis ayba Filiphosni asu sina Herodiyadani boor'a Yohannisnin ootire taatoni keer taatire feer. ");
INSERT INTO jnjl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yohannis Herodisnik: «Ayneesa asunon ephatak tumaassi kaltowa» yire makena boor'a. ");
INSERT INTO jnjl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodis Yohannisnin woruk sholet feer. Sinuntano daraas Yohannisnin raajju zagiretu biyefe sinna boor'a dige. ");
INSERT INTO jnjl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodis koontena wonaason ulfinsifena wono Herodiyadani nawaas teegtere yeese baasso ganeyaassi suru surira Herodisnin girsi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Es bari boor'a Herodis bar shiiphena wuzason zuutire imanak teyire warege. ");
INSERT INTO jnjl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nawaas dey intobaasik kiittera: «Haphqife Yohannisni teetaason han koranaassi gedda hash taak imma» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Taatoos es chowaasik suume. Sinuntano girina teyyaasik barneen ane diise baasso boor'a iichchere Yohannisni teetaas imtonak zagi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Taatoni keer wosire Yohannisni teetaason kati. ");
INSERT INTO jnjl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Es kate teetaason koranasi gedde teshshere nawaasik imete. Bar dey taamma intobaasik imi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohannisni nawoosakito yeesere dugnobaason ephphe kabbarsete. Hamere dey es chowaason Yesusnik maksete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesus Yohannisni kituuson odenaase goonuussi diire bar bar duuk isa shaato dimsi hami. Daraas dey es baron odeseteyse katama katamabaassin kesse wochok barki hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesus goonuussin kerere showo darani biyaat baassok kenashte. Mettanni meyanon dey fati. ");
INSERT INTO jnjl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Waalfana kabaasik nawobaasakito barki tai'sere «Han bar zabowa, gerok dey waali. Daraas hamme ke'esikitosin muubesi waagsonek geggessuwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sinuntano Yesus: «Nitto baasso muusoneeson imotitano hamonek aane sholsifawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Baasso dey: «Innoki fayiis uuch muuma daabbonewa hep kurxumminetano ooma hantak aafawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Bar dey: «Es baron hang taaki teshshotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Daraas shaa'aasta duusonek ajaje. Estan uuch muuma daabboosonnawa hep kurxummiisonna ephphe den sama biire galatni shiipho shiiphe. Daabbooson dey batte nawobaasakitonik imin baasso dey daraasik woshete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Zuuttambesiise meere gawuseten nawobaasakito dey fu'te battoos asire heppe masa tuumanon zuutisete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Meese asuni meya mashkasusewa naanggotaase faadtonoyfeen uuch kum arqasu sinone. ");
INSERT INTO jnjl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Estan Yesus geregere nawobaasakitonin: «Daraasin geggessuna kabaneen goonuussi diisera zeemma yesalo fintiwa» yit ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Daraasin geggessinayse Ha'o shiiphonak bar bar den aamaasta kesi. Waalfana kabaasik Yesus bar bartu estak feer. ");
INSERT INTO jnjl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Es kabaasik Goonuus baarisi ganeta feen ek sinaastak siru faar sinna boor'a akaasi guubo shimsi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wassi izgin sa'atiistak Yesus baariista kutit nawobaasakitoniki ye. ");
INSERT INTO jnjl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nawobaasakito dey akaasta kutit hamfeen biyefaat: «Han bar kitawa» yire digak chaagesete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesus dey geregere: «Harewa! Digotiitawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Es kabaasik Phexiros wolgire: «Daamiiso! Ne sinfaatane akaasta kutit neeki yoonak taan ajajowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus dey: «Yowa» yi. Estan Phexiros goonuussin kerere Yesusniki hamanak akaasta kuti. ");
INSERT INTO jnjl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sinuntano sirusi hugnanon biire dige. Baariis barin koor'anak hambaase: «Daamtaaso! Taan fu'aywa» yit chaagi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus geregere shongere kushubaason zatte: «Amantone yo'inar ne, awuni boor'a nibneessi ek hang yitso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesusnawa Phexirosna goonuussi girsefe kabaasik sirus yere. ");
INSERT INTO jnjl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Goonuussi diise baasso dey zuuttere: «Futok ne Ha'oni Naawa» yit Yesusnik sagadesete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesusnawa nawobaasakitona baariison finere Gensaret sinfa daasta yeesete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Estak asuni meya Yesus sinbaason arseteyse biratoosta fa daa zuuttambaase asiissi wosseten mettanni meyanon zuutire barki teshshesete. ");
INSERT INTO jnjl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mettanni meya maybaasi fashanon ta'uk shiiphset feeseter. Ta'i baasso dey zuuttere merobesiissin farsete. ");
INSERT INTO jnjl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Esseen orfo Yerusalemun yeese Museni tumaasi assinynyanawa Ferisawini meena Yesusniki tai'sesere: ");
INSERT INTO jnjl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ne nawoosakito awuni boor'a kur'uni meeni dubbiyooson aatefeso? Muu meesefe kabaasik kushubesiison aane masesefewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesus wolgire: «Nitto dubbiyooson oodakwa iyaat awuni boor'a Ha'oosi ajajinon aatfetiso? ");
INSERT INTO jnjl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ha'oos: ‹Abanesinnawa intoneesonna ulfinsuwa. Ababaasin wedey intobaason me'a bar kitunak sholsifawa› yifawa. ");
INSERT INTO jnjl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sinuntano nitto isa asu ababaasin wedey intobaason: ‹Ta nittok imana argasuuson Ha'oosik maba zagira imingwa› iyaanane; ");
INSERT INTO jnjl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","‹Es asus ababaasin wedey intobaason ulfinsunak aane sholsifawa› yifeti. Es bari boor'a nitto dubbiyooson oodakwa iyaat Ha'oosi kaamanon aatfetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sinnoy sinne bestefe nitto raajju Isayyas ekka yire nitto chowaasik makena raajiis futowa. ");
INSERT INTO jnjl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","« ‹Han daraas noono noonobaasiktu taan ulfinsifewa, sinuntano nibbaas tayistan wokawa. ");
INSERT INTO jnjl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Asu tumena tumaason Ha'oni tuma zagire assifaafe; shima shiipho shiiphesefewa› » yi. ");
INSERT INTO jnjl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tusire dey Yesus daraasin hang barki teegere: «Odotiwa! Dey yaadatotiwa! ");
INSERT INTO jnjl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Asunin kiinsifaas noonosin kesfa bartano noonosi girifa bartawa.» ");
INSERT INTO jnjl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Estan nawoni meya barki yeesere: «Ferisawini meya han ne maketa kaamaason odesere nibbesiissi kejfaan tuusa'setemato aritoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesus wolgire: «Samaki Abataas toknoyna akakiltiis zuuttera waaterwa. ");
INSERT INTO jnjl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Baasso aaftishu dey aaftishuni meyanon zoonsir sinete boor'a beytiwa. Aaftishu aaftishusin zoonsifaanane hepere gawusitu gandosonewa.» ");
INSERT INTO jnjl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Phexiros dey Yesusnin: «Besoson kotta innok makowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus wolgire: «Nitto dey hashneen kar'a aane yaadatowetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Noonosi girifa bar zuuttera kataassi kamo aatta gero kesfanamato aane aruwetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sinuntano asuni noonosin kesfa bar nibsintu kesfawa. Asunin dey kiinsifaas es barwa. ");
INSERT INTO jnjl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mangunon safaro, asunin woru, soolo, gerkesa, wiiso, esha zaalni mako, asuni sunni mangsu zuuttera asuni nibsintu kesfawa ");
INSERT INTO jnjl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Asunin kiinsifaas dey es bartano kushu masonoy muustawa.» ");
INSERT INTO jnjl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesus estan kesse Tirosni katamaassinawa Sidonani katamaassina hami. ");
INSERT INTO jnjl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Estak isa kene'aki mashkasu Yesusniki yaara: «Dawitni Naa Daamiiso! Naanaas kiina ayyanak oottera akamanon mettedifar sinna boor'a taak kenashtefaywa» yit chaagi. ");
INSERT INTO jnjl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sinuntano Yesus isa wuzane wolgunoy shaakki. Es kabaasik nawobaasakito barki tai'sere: «Han asus inno orfoose yaafaafa chaaget faar sinna boor'a geggessifaywa» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus wolgire: «Ta wostera yaanaas fantunimato tishire fe Israelni meyaktano oomni meyak aane yootwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sinuntano asus yaara wochobaassi kaa'nera: «Daamiiso! Taan argasaywa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sinuntano Yesus barik wolgire: «Naanggotaasi daabbonon ephphe kanak ha'u aane sholsifawe» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bar dey wolgira: «Futowa, Daamiiso! Kanaasikitonu daambaysakitoni sillawotan zigtefa fufuntoosontu maasefawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Es kabaasik Yesus wolgire: «Han asuse! Amantonees akamawe. Sholeta bar neek sinungwe» yi. Nawubaas dey es sa'atiistak fari. ");
INSERT INTO jnjl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesus estan kabire Galiilaki baarisi tesha yeere den aamaasta kesse hamme di. ");
INSERT INTO jnjl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Showo asuni meya laafaasakitonin aaftishusakitonin engitiisin, nibtaatosakitoninnawa oom showo mettanni meyanonna ephpheteshshere basa wochoossi kunusseten bar dey baassotin fati. ");
INSERT INTO jnjl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Es bari boor'a daraas nibtaatoos wollefeen, laafaas farifeen, engitiis kaanne kutifeen, aaftishuus biifeen biisere diinqok Israelni Ha'ooson galattesete. ");
INSERT INTO jnjl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesus nawobaasakitonin teegere: «Daraas taneen ane keez wona feeshete sinna boor'a muusone wuza aafa sinna boor'a baassok kenashtefawungwa; uguntak makak mikishere gandosonoytemato afurbesiise gafkuk aane sholefatwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nawobaasakito dey: «Eekin han effatena daraasin gausuni tusha han ichma daassik ayin dananirinso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesus: «Apun daabbonso nittoki faari?» yi. Baasso dey: «Naafun muuma daabbonewa garo garo kiisku kurxumminetu innokik faarwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Esseen orfo daraas daasta duusonek ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Naafun muuma daabboosewa garo garo kiisku kurxummiise asin ephphe Ha'o galattefaat batte nawobaasakitonik imi. Baasso dey daraasik woshete. ");
INSERT INTO jnjl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Zuuttambesiise meesere gawuseten fu'te battooson naafun masa zuutisete. ");
INSERT INTO jnjl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Meese baasso mashkasusewa naanggotaase faadtonoynaron acheech kum arqasu sinone. ");
INSERT INTO jnjl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Daraasin geggessinanneen orfo goonuussi diire Megdon yiste daa hami. ");
INSERT INTO jnjl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ferisawini meenawa Sedukawini meena Yesusniki yeesere barin fattanok sholsefaat: «Den saman biistera artonoy wuza innok besuwa» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sinuntano Yesus wolgire: «Waalin samaas she'in biifeti kabaasik: ‹Noi'sunirwa› yifeti. ");
INSERT INTO jnjl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","E'so dey: ‹Samaas gumalla karayen biifeti kabaasik hawung akama iro ichnirwa› yifeti. Ese samaasi gitonon aruk chimtir. Sinuntano neyaasi besonon aruk aane chimefeti? ");
INSERT INTO jnjl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mangunewa amanamtonoy koontoos besotu sholefawa? Sinuntano raajju Yonasni besostan ooma beso aafa imtona wuza.» Estan Yesus baassotin beyye hami. ");
INSERT INTO jnjl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nawoni meya baariison finefe kabaasik daabboni epha daagsete. ");
INSERT INTO jnjl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesus baassotin: «Ese arutiwa, Ferisawini meenawa Sadukawini meena asi masoossin teetnitiison oodtiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Baasso dey: «Daabbo epha daageni boor'atongwa» yiset baassotna baassotna wolumsete. ");
INSERT INTO jnjl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesus baasso safaraason arifaat: «Amantonti yo'ina nitto awuni boor'a nittotna nittotna ‹Daabbo epha beyni boor'atongwa› yit wolumsefetiso? ");
INSERT INTO jnjl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hashnu aane yaadatowetinoso? Uuch muuma daabbooson uuch kum asusik hooren fu'te battooson apun masa zuutisetimato aane yaadatowetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Esiismato dey naafun muuma daabbooson acheech kum asusik hooren apun masa zuutisetimato aane yaadatowetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Eekin ta makenaas daabboni chowa sina beybaason aakkak yaadato beytiso? Hashnu Ferisawini meenawa Sedukawini meena asi masoossin teetnitiison oodtiwa?» ");
INSERT INTO jnjl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Estan nawobaasakito dey Yesus teetnitiison oodtiwa yinaas daabboossi girifa masoos sinnoynaron Ferisawini meenawa Sedukawini meena asi assuussin teetbesiison oodosonek sinbaason yaadatesete. ");
INSERT INTO jnjl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus Filiphoos Qesariya yistefa daa kar'naase nawobaasakitonin: «Asuni meya Asuni Naanin oowa yisefeso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Baasso dey: «Isa isaas ‹Haphqife Yohanniswa› yisefe. Oomiis dey ‹Eliyaswa› yisefe. Oomiis ‹Ermiyaswa wedey raajjuni meyaassin isaaswa› usotu yisedifewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesus dey: «Eekin nitto Taan oowa yifetiso» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Phexiros wolgire: «Ne hayewa Ha'oosi Naa Kiristooswa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus wolgire: «Yonani naa Simonno! Ne suustowa. Han baron neek ammanon besiis samaki fe Abataasteno ashnewa harinnetawa. ");
INSERT INTO jnjl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta dey neek ekka yifawungwa, ne phexiroswa han kaa'oosta betekiristaninaason keer'anarwa. Es betekiristaniison kituni hugnaas meronak aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Samaki taatosi gachosikitonon neek imanawa. Ne han daastak taar'ta bar den samak taatotu sinana. Han daastak kotta bar den samak kottotu sinana.» ");
INSERT INTO jnjl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Estan Yesus nawobaasakitonik bar Kiristoos sinbaason ooniknu maksonoytemato ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Es wononeen kabire Yesus nawobaasakitonik: «Yerusalem hamanak sholsifawa. Estak dey kur'uni meyakin, maagni gaanynyanikin, Museni tumaasi assinynyanikin shana tayista kar'ana. Dey worsoner. Sinuntano keezsinari wono kitun kabuna» uu ephi. ");
INSERT INTO jnjl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Phexiros dey Yesusnin oor kisire: «Daamiiso! Han bar isanne neyista aafawa kar'anawuza» yit ke'u ephi. ");
INSERT INTO jnjl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Sinuntano Yesus phexironiki yerqere: «Tayistan ek hamma! Ne Sexana! Asuniisontano Ha'oosi fiqadinon aane safarefe sinna boor'a taak tuusa sintiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Estan orfo Yesus nawobaasakitonik: «Taneen ane hamak sholefe bar teetbaason beyye mesqelibaason wor'e taneen ane yowowa. ");
INSERT INTO jnjl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kaabaason fu'onak sholefe bar zuuttere tishkuna. Sinuntano ta boor'a kaabaason tishki bar zuuttere danana. ");
INSERT INTO jnjl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Asu han daastak barik sholsi wuzason zuutire danfaat kaabaason tishkifaanane awu barik ke'nirinso? wedey asu kaabaasi soolak aro wuza kaasunak chimnirinso? ");
INSERT INTO jnjl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Asuni Naa Ababaasa ulfinak wosibaasneen ane yoonirwa. Es kabaasik zuuttambaase asik wostobesisimato baassok kaasuna. ");
INSERT INTO jnjl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Futok nittok makefawungwa; Asuni Naa taatobaasi ulfinak yeefeen biyone kabaneen hanta yere baassossin kitunoy asuni meya feeseterwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Issun wonaneen orfo Yesus Phexirosnin, Yaqobninnawa Yaqobni ay Yohannisninna asin ephphe isa dicha aamaasta baasso baassotin zoonsire kesi. ");
INSERT INTO jnjl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Estak baasso sinak gitobaas sooltera sinbaas dey awanimato chaare. Maybaas dey forera chaarefnimato palpali. ");
INSERT INTO jnjl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Musenawa Eeliyasna dey Yesusneen ane wolumsefeen biyesete. ");
INSERT INTO jnjl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Estan Phexiros Yesusnin: «Daamiiso! Hanta fo innok ma'arwa. Ma'i iyaatane isaron neek, isaron Musenik, isaron Eliyasnik sini keez hafo keer'anawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Phexiros es baron makefeen palpalifa shaaru yaara baassotin yini. Dey es shaaruussin: «Barik girefana Naataas haniiswa. Barin odotiwa» yifa kaama odte. ");
INSERT INTO jnjl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nawobaasakito dey es kaamaason odesere akamanon digsete boor'a sinbesiisik daasta gandesete. ");
INSERT INTO jnjl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sinuntano Yesus baassoki tai'sere ta'ifaat: «Kabutiwa, digotiitawa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Baasso dey kaanne biyeten Yesusnintano oom ooninnu aane biyoto. ");
INSERT INTO jnjl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aamaastan kersefeen Yesus: «Asuni Naa kitun kabunanneen han biiti baron ooknu makotiitawa» yire nawobaasakitonin ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nawobaasakito dey: «Eekin Museni tumaasi assinynyani meya awuni boor'a zeemme Eeliyas yoonak sholsifawa yisefeso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus wolgire: «Futowa, Eeliyas zeemme yeere zuuttambaase asin mai'suna. ");
INSERT INTO jnjl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sinuntano ta nittok makefawungwa; Eeliyas sina zeemme yewa; asuni meya dey aane arsoto sinna boor'a sholsete baron zuutire basaasta zagsete. Esiisimato dey Asuni Naa baasso kushusi shana ephphetoonak sholsifawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Es kabaasik nawobaasakito Yesus makena bar haphqife Yohannisni chowaason sinnamato arsete. ");
INSERT INTO jnjl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesusnawa keez nawobaasakitona daraaski wolle yeesefe kabaasik isa asu Yesusniki tai'sere wochobaassi kaa'nefaat: ");
INSERT INTO jnjl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Daamiiso! Naataasik kenashtefaywa; ephpha ha'ifa meroos mangunon shana besit faarwa. Showo wona akasinawa geesina gansir. ");
INSERT INTO jnjl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne nawooski ephpha yaan; sinuntano fatuk aane chimoto» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus wolgire: «Nitto amanonoy elinga koonto, aageneen kar'anso nittoneen ane foonari? Aageneen kar'anso nittotin fakunari? Naasin hang taaki teshshotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesus kiina ayyanaason ke'in basaassin kesi. Naas dey es kabaasik fari. ");
INSERT INTO jnjl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Estan nawobaasakito baasso baasso Yesusniki tai'sere: «Inno kiina ayyanaason kisu chima beyniis awuni boor'anso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus dey wolgire: «Nitto amantoos yo'ina boor'awa. Futo nittok makefawungwa; fi'fi'oni gaanane fa amantonti faafaanane han aamaason ‹Hantan kabira ek hamme› iyaatine hamanawa. Nittok chimtonoywuza isanne aafawa. ");
INSERT INTO jnjl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sinuntano han effatena kiina ayyanaas soomere shiiphoktano baak aafawa kesana wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nawobaasakito Galiilak zuuttesere feeseten Yesus baassok: «Asuni Naa asuni meeni kushusi aattere imtonirwa; ");
INSERT INTO jnjl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Baasso dey worsoner; sinuntano keezsinari wono kitun kabuna» yi. Nawobaasakito es chowaasik dey akamanon suumesete. ");
INSERT INTO jnjl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesusnawa nawobaasakitona Kifirnahom kar'efe kabaasik betemeqdesini girbo zuutife asuni meya phexirosniki tai'sere: «Nitto assinynyaas betemeqdesik giribtefa girbooson aane girbefenoso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Phexiros wolgire: «Girberwa» yi. Estan Phexiros keer girifena kabaasik Yesus zeemme: «Simon phexiros; neek awu sinna bestefaso? Han daastaki taate meya karaxa wedey girbo zuutisefees ookininso? Naanggotbesiiskiningwa wedey irbanikininso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Phexiros dey: «Irbaaskingwa» yire wolgi. Yesus dey: «Ese naanggotbesiisikito girbo aaffa kaasusone wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sinuntano baassosta tuusa sinnoynimato hamfaat kurxummiisi eshmiyanon baariissi ha'uwa. Estan zeemma ootte kurxummiisi noononon shoo'sifata kabaasik birri danata. Taamma dey ta sunaasiknawa ne sunaasikna kaasuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Es kabaasik nawobaasakito Yesusniki tai'sere: «Samaki taatoossi zuuttambaase asiistan arkir oonso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesus dey: Isa daaga nawa teegere baasso ganeyaassi yeeti. ");
INSERT INTO jnjl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ekka dey yi: «Futo nittok makefawungwa; soolto shakatinenawa han daaga naanggotaasne feer sina shakaatinena samaki taatoossi isanne aafawa giruti wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Es bari boor'a han daaga nawaasimato teetbaason daa ephfe bar den samaki taatoossi arkirwa. ");
INSERT INTO jnjl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Esiisimato haniisne fe daaga nawaason ta sunaasik ephpheteefe bar taan ephphetoona.» ");
INSERT INTO jnjl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Dey Tusire: «Oonu han taak amanefe garo garoosasin isaasin tuusa'sife bar wooni shu'a suutbaasta taatera baarisi tir'maassi ha'tefaanane ma'arwa. ");
INSERT INTO jnjl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Asuni meya tuusa'osonek zaguni wuzaasik han daas haybubawungwa! Tuusa'suni wuzaas aafawa yobeyana wuza. Sinuntano es tuusaasik ugna sinni asus haybubawowa! ");
INSERT INTO jnjl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Es bari boor'a wochonees wedey kushunees tuusa'sunir sinfaanane kar'a ha'uwa. Hep kushune wedey hep wochone faafaan koi'ba foonto geesi ha'toneestan dungu wedey engit sinna koi'ba foonto kaa danne wayyawa. ");
INSERT INTO jnjl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aafnees tuusa'sunir sinfaanane wo'ira ha'uwa. Hep aafne faafaan geeni tir'maassi ha'toneestan isa aafne faafaan kaa danfaatane wayyawa. ");
INSERT INTO jnjl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Den samak baassok hoorera faase Ha'oosi wosiyanikito samak fe Abataasa sinanon wonna wonna biyeter sinna boor'a han garo garoosasin isaasinnu kashshunoytimato arutiwa.  ");
INSERT INTO jnjl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Asuni Naa dey yeenaas tishi baassotin fu'okwa.» ");
INSERT INTO jnjl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Dey Yesus: «Awu sinna nittok bestefaso? Isa asu tiya fantuba faafaananenawa es barissin isar tishifaanane izginasire izgineeson aamaasta beyfaat tishi baron sholok aafanoso hamana wuza? ");
INSERT INTO jnjl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Futo nittok makefawungwa; danfena kabaasik tishunoy izginasire izgineestan es tishira beste bariktu akamanon girefe. ");
INSERT INTO jnjl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Esiisimato dey han garo garoosasin isar tishunak den samak fe Abantiisa safaratawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Dey tusire: «Aynees neen miir'efaanane neneen barneen ane faatiista neen miir'ena baron makowa. Odefaanane wolgira ayne zagutawa. ");
INSERT INTO jnjl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sinuntano odo shakaanane hep wedey keez zaalniktu chowaas futo sinfa sinna boor'a hep wedey keez asunin ephpha barki hamma. ");
INSERT INTO jnjl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Baassotin odo beyfaanane betekiristaniisik makowa. Betekiristaniison dey odo beyfaanane Ha'ooson amanonor wedey boor'inynyana zagira faaduwa. ");
INSERT INTO jnjl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ta futok nittok makefawungwa; han daastak taar'efeti bar samak dey taatotu sinana. Han daasta kotfeti bar samak dey kottotu sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Dey nittok makefawungwa; nittoossin heppiis han daastak aaffa wuzaasiknu sinun isar sinne shiiphsefaatene samaki fe abataas baassok zaguna. ");
INSERT INTO jnjl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Hep wedey keez sinne ta sunaasik zuuttesefe dimaasta ta baasso ganeyaassi foonawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Estan Phexiros Yesusniki yeere: «Daamiiso! Aytaas taan miir'efaanane apuna wolla feeshun unarinso? naafuna wollanoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus wolgire: «Naafunasira wolla naafunetano naafuna wolla koi'bawa aafawa unawuza. ");
INSERT INTO jnjl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Esiisimato den samaki taatoos wostinynyabaasakitoni kushusi fa waagbaason faadunak shole taatone faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Es waagbaason faadu ephfena kabaasik asir kuma mekiliti sinni kowa basaasta faana isa asunin barki ephphe yeesete. ");
INSERT INTO jnjl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Es wostinynyaas kaasuna waaga turkifaan barneen asubaasneen naanggotbaasneen fa waagbaas zuuttera kessa waagtera kowa kaastonak daambaas ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sinuntano wostinynyaas daambaasa wochosi kaa'nere: ‹Daamiiso, taak fakuwa, zuuttambaase asin kaasunawa› yit shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Daambaas dey barik kenashtefaat gafki. Kowaason dey kaasto beyi. ");
INSERT INTO jnjl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Sinuntano es wostinynyaas estan kesse hamfeen wostoni zomoba sinarik tiya diinari liqsinarin danne: ‹Liqsina waagnaason kaasuwa› yit zatte geer'i. ");
INSERT INTO jnjl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Es wostoni zomoba sina wostinynyaas dey wochobaassi kaa'nere: ‹Taak fakuwa, zuuttambaase asin kaasunawa› yit shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sinuntano asus aane ma'i uwe. Kowaason kaasunanneen taamme taatoni keer taati. ");
INSERT INTO jnjl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Es sina baron wostoni zomoba sina oom wostinynyaasakito bar zagina baron biyefaat akamanon suumesete. Hamere dey sina baron zuutire daambesiisik maksete. ");
INSERT INTO jnjl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Estan daambaas es wostinynyaasin teegsire: ‹Ne mangu wostinynya, taan shiiphen es effatena kowaason zuutira neek beyin.› ");
INSERT INTO jnjl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eekin ta neen fakinaasimato zomone sina es wostinynyaasin fakutak aane sholsifanoso? ");
INSERT INTO jnjl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Daambaas gi'tere kowaason zuutire kaasunanneen shana biyanak taatoni keyaason ha'sife baassok aatire imi. ");
INSERT INTO jnjl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Ese nitto dey isa isarnitiis aynitisakitonin nibnitiissin koi'sira feeshun uu shakaatine den samak fe abataas dey nittoosta esiisimatotu zagunawa.» ");
INSERT INTO jnjl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus es baron makere koi'sinanneen orfo Galiilan kesse Yordanosni yesalo fa Yuudani daasta hami. ");
INSERT INTO jnjl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Showo dara basa orfoose hami. Baassossin dey mette asuni meyanon estak fati. ");
INSERT INTO jnjl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ferisawini meya dey yeesere barin fattanok sholsefaat: «Asu sina chowa aaffarik sinun asubaason teetba kotte gafkunak faqqadtonoso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus wolgire ekka yi: «Ha'oos zeemma arqarnawa mashkare zagira tesinamato aane feretuwetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‹Es bari boor'a asu Ababaasinnawa intobaasonna beyye asubaasneen isar sinana. Hepobesiise dey isa atu sinone› ");
INSERT INTO jnjl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ese baasso hanneen ekalo isa atutano hep atutawa. Ha'oos isar zagina baassotin asu oor kisunaatawa» ");
INSERT INTO jnjl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ferisawini meya dey wolgire: «Eekin Muse awuni boor'a ‹Teetni kotni ticha imme teetba kotowa› yire ajajeso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesus wolgire: «Nitto nibaasi chimni boor'atu asuntiisikitonon teetba kotta gafkutik maketeno tesustaneen ekkatawa. ");
INSERT INTO jnjl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","«Sinuntano ta nittok makefawungwa: ‹Isa asu gerkesni chowak sinnoynaron asubaason teetba kotte gafkaat ooma asu ephfaanane gerkesiwa.› » ");
INSERT INTO jnjl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nawobaasakito dey: «Abanewa intone asi chowaas ekka sinfaanane ephnewa girune asin beyaas ma'arwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sinuntano Yesus wolgire: «Imtena baassoktano han effatena assus asu zuuttambesiise asik aafa chimtona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Intobesiisi keensin arqarbesi foonto sinne koonter feeseter. Dey asu arqarbesiison kar'nar feeseter. Samaki taatoosikwa iyaat arqarbesi foontone feer sinar feeseter. Ephphetook chimni bar ephphetoowowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Estan Yesus kushubaason barikitoniista ta'ire shiiphonak asuni meya daaga naanggotaason Yesusniki ephphe yeesete. Sinuntano Nawobaasakito kalesete. ");
INSERT INTO jnjl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sinuntano Yesus: «Samaki taatoos han naanggotaasne fayiisik sinna boor'a daaga naanggotaason beyfaani taaki yoosonwa, kalatiitawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kushubaason naanggotaasta ta'ire suusaat estan aatte hami. ");
INSERT INTO jnjl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Isa asu Yesusniki yeere: «Assinynyano! Koi'ba foonto kaa dananak aro ma'a wuza zagunarinso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus wolgire: «Ma'a wuzni chowa awuniron taaki mamsifatso? Ma'ar sinaas isa Ha'oos koi'bawa. Kaani keer giruk sholefaatane ajajiisikitonon oodwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Asus dey wolgire: «Aaffa ajajiisikitonso?» yi. Yesus barik: «Asuni worutaata, gerkesataata, wiisotaata, esha zaala makotaata ");
INSERT INTO jnjl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Abanesinnawa intoneesonna ulfinsu, Wolkoneesin teetneeson shunfataasimato shun» yifa ajajiisikitowa. ");
INSERT INTO jnjl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na'o asus dey: «Es baron zuutira ooddatu fawungwa, ooma yo'ir aambanso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus dey: «Tuum sinatak sholefaatane hamma fa wuzneeson kisira waagera tukamni meyak imma. Samak otma danatawa; eekaat yeen taneen ane hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sinuntano na'o asus akama otumba faana boor'a es kaamaason odenayse suumet hami. ");
INSERT INTO jnjl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesus nawobaasakitonik: «Futo nittok makefawungwa; otum asunik samaki taatoossi giruus akamanon fayawa. ");
INSERT INTO jnjl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dey nittok makefawungwa; otum asu Ha'oosi taatosi girubaastan gaala marufni kattosi kamo aatfaanane kashowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nawobaasakito es baron odeseteyse akamanon diinqesefaat: «Eekin oonso faruk chimniri?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus dey baassoki biyaat: «Han bar asunik aafa chimtona wuza. Sinuntano Ha'oosik zuuttambaase chimtonawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Es kabaasik Phexiros wolgire: «Ese inno zuuttambaase asin beyya neek zoonusteniwa; eekin awu danungeniso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus baassok ekka yi: «Futo nittok makefawungwa; Asuni Naa ulfinni zigimubaasta duuna gaddo yooni daastak; taak zoonustesefe nitto dey asire heppe Israelni zigimoosta duusotiwa. Asire heppe Israelni asteserista dey mangsu kar'atiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta sunaasikwa iyaat keyaasikitonon wedey ayisakitonin wedey eetisikitonon wedey ababaasinnawa intobaasonna wedey naanggotaason wedey bulooson beya bar zuuttambaase tiya kushunontu danana. Koi'ba foonto kaa dey danana. ");
INSERT INTO jnjl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sinuntano zeema baasso showobesiis orfotir sinone. Orfotir sina baasso zeemar sinone.» ");
INSERT INTO jnjl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tusire dey Yesus ekka yi: «Samaki taatoos wayinini akakiltini dimaasta wostesefe wostinynyani sholok e'so wonsak kesa wayinini akakiltiisi abane faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bar wostinynyaasakitonik isa wonak isa diinari kaasunak wollere wayinini akakiltini dimaasta wosi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Dey keez sa'atiista kesse oom wosto foonto meya yaboosta yerse asuni meyanon bi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Es baassok dey: ‹Nitto dey ek wayinini akakiltiini dimaasta hamfaat wostotiwa. Nittok sholsi waagaason kaasuna› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Baasso dey wayinini akakiltiisi dimta hamete. Dey issun sa'atiisanawa izgin sa'atiistana kesse esiisimato zagi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Asire isse sa'atiista kesse oom asuni meya yersefeen biyaat: ‹Nitto dey wosto foonto wonaason zuutira awuni boor'a hanta yeretirinso?› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Baasso dey: ‹Innotin wosussuni asunin turkira yerenirwa› yisete. Bar dey: ‹Ek wayinini akakiltiisi dimaasta hamfaat wostotiwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Waalfana kabaasik wayinini akakiltiisi daam wosussife barin: ‹Wostinynyaasakitonin teegera orfoti baassostan kabgira siinaki baassosta kar'ana kabaneen wostesete wostoosi waaganon kaasuwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Asire isse sa'atik wostoosi giri baasso yeesere isa isarbesiis isa diinari ephete. ");
INSERT INTO jnjl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Zeemme wostoosi giri baasso dey yeesere orfoti baassostan daytonon ephonenne faar sinna baassok beste. Sinuntano baasso dey isa isarbesiis isa diinari ephete. ");
INSERT INTO jnjl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Waagbesiison epheteese wayiniisi akakiltini abanita ekka yit unyisete. ");
INSERT INTO jnjl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Han orfo giri baasso isa sa'atinintu wosussete. Wonaason zuutira noi'sak kiichchere feesha innoneen isa kixxe kaasitwa› ");
INSERT INTO jnjl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wayiniisi akakiltini aba wostinynyaasakitonisin isaasik: ‹Zomotaaso! Ta neen aane miir'otwa. Wonaasik isa diinari kaasunaktanoso neneen ane wollenari? ");
INSERT INTO jnjl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ese ne haa'ooson ephpha hamma. Han neek imnaasimato orfoti barik imanak sholefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Waagnaasta shunnaron zagunak aafanoso chimanawuza? Wedey garam asu sinna boor'a ne taan koonetoso?› » ");
INSERT INTO jnjl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Estan Yesus: «Zeema baasso orfotir sinone; Orfoti baasso dey zeemar sinone» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Esseen orfo Yesus Yerusalem hamefet ugnaastak asire heppe nawobaasakitonin baasso baassotin barki tai'sire: ");
INSERT INTO jnjl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ese Yerusalem hamanirwa; Asuni Naa dey maagni gaanynye meyaknawa Museni tumaasi assinynyani meyakna aattere imtona. Baasso dey kituni mangsuni kar'a basaasta kar'oner. ");
INSERT INTO jnjl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kanyosonek, ichosoneknawa suutosonekna Aazabni meyak aatire imone. Sinuntano bar keezsinari wono kitun kabuna» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Estan Zebdewosni naanggotiisa into naanggotisneen ane Yesusniki yaara sinba kaa'nera bar barik isa wuza zagunak shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus dey: «Awu sholefaasse?» yi. Bar dey: «Han hep naanggottaas ne taatoossi isaas o'itneesta; isaas dey alidneesta duusonak zaguwa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Sinuntano Yesus wolgire: «Nitto shiiphefeti wuzason aane arifeti. Ta ushanak fa shanani toofoosi ushaason ushatik chimatiroso?» Baasso dey: «Aa chimaniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Bar dey: «Taa shanani toofoosi ushanon ushatiwa; Sinuntano o'itnaastanawa alidnaastana duuson Abataas hoossina baassoteno duusonek zaguniis tatewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Es baron ode oom asir nawoni meya es hep ayna ayna asiista haaresete. ");
INSERT INTO jnjl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sinuntano Yesus baassotin barki teegere ekka yi: «Aazabni meeni gaanynye meya darabesiisa ha'sinynyawa. Baassotin zoonsisefe meya dey baassosta ha'suni hugnabesi faanamato arsefeti. ");
INSERT INTO jnjl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nitto ganeyaassi ekka sinanak aane sholsifawa. Sinuntano oonu nittoossin arkir sinanak sholefaanane nitto wostinynya sinowa. ");
INSERT INTO jnjl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Esiisimato dey nittoossin denalo sinak sholefe bar nitto boz sinowa. ");
INSERT INTO jnjl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Asuni Naa dey oomiisik wostonaknawa showoni meyanon fatuk kaabaason aatire imaktu yeeteno baasso barik wostosonek aane yowewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Esseen orfo Iyyarikon kesse hamefeen showo dara Yesusneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Estak dey ugunni teshta diise hep aaftishuni meya Yesus baassoki esta kamo aatbaason odeseteyse: «Daamiiso! Dawitni Naaso! Innotin fakifaywa!» yit chaagete. ");
INSERT INTO jnjl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Daraas dey: «Shaakkutiwa» yit ke'isete. Sinuntano baasso: «Daamiiso! Dawitni Naaso! Innotin fakifaywa!» yit aatamsire chaagete. ");
INSERT INTO jnjl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesus dey yerere baassotin barki teegere: «Nittok awu zagunak sholefetiso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Baasso dey: «Daamiiso! Aafniis gachchonak zagaywa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus baassok kenashtefaat aaffesiison ta'i. Geregere dey aafbesiis biin Yesusneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesusnawa nawobaasakitona Yerusalem tai'sesete. Dabrazayitini kumaasta fa Beetefage yistefa ke'eessi kar'efe kabaasik nawobaasasin heppin ekka yit wosi: ");
INSERT INTO jnjl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Ek sinnitiista fa ke'eessi hamti; estak tuptera yere hanya nawubaneen yerefeen danati. Kotta taaki ephpha yoosoti. ");
INSERT INTO jnjl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Oonu ‹Awuniron barikitonon kottifetirinso?› iyaanane ‹Daamiis barikitonon sholefawungwa› uti. Bar dey geregere hanyaasikitonon gafkuna» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Es bar dey sinnaas raajjuni meyaki kamo ekka yistera makte bar sinanakwa. ");
INSERT INTO jnjl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Tsiyonni katama yistefa Yerusalemuk: ‹Ne taatoos garam sinne; hanyaasi naatana diire; neeki yoonirwe› yira makoti» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nawobaasakito dey hamere Yesus ajajenaasimato zagsete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hanyaason dey naabaasneen ephphe yeesete. Maybesiison dey hanyaasikitoni geshota kunusseten Yesus barista di. ");
INSERT INTO jnjl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Daraasa ganesin showobesiis maybesiison ugnaasta yiir'ete. Oomiis dey i'oni tosha kiir'taafe ugnaasta yiir'et feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sina zeema baassotnawa orfoose hamefe baassotna: «Hosana Dawitni naasik sinfawungwa. Daamiisa sunak yeefe bar suustowa. Hosana den Samak» yit chaagete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesus Yerusalemni katamaassi girifena kabaasik asuni meya zuuttere: «Haniis oonso?» uuk shorkesete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Daraas dey: «Haniis Galiilani daasta fa Naaziret katamaassin ye raajju Yesuswa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Esseen orfo Yesus dey betemeqdesiissi girire kisire waagsefe baassotinnawa geron waagsefe baassotinna zuutire kalle kisi. Waaga soolefe baasso tarabbezasonnawa nakalo waagsefe baasso kodaasonna shelgire ha'i. ");
INSERT INTO jnjl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","« ‹Ta keyaas shiiphoni keya yisteratu teegtona› yistera tichchewa. Sinuntano nitto bo'inynyani meeni dugadug zagsetiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesus betemeqdesiissi feen aaftishuni meenawa engitni meena barki yeeseten fati. ");
INSERT INTO jnjl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sinuntano maagni gaanynye meenawa Museni tumaasi assinynyaasna Yesus zagina biistera artonoy wuzaasewa betemeqdesiissi «Hosana Dawitni naasik» yit chaaget fa naanggotaasonna biyeteese gi'tesete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Baasso dey: «Han naanggotaas maksefana baron aane odefenoso?» yisete. Yesus dey: «Odedifawungwa: ‹Daaga naanggotaaskinnawa tama tamfa daaga naanggotaasi kaamsinna galata ne teetaasik hoossitwa› yifa kaamaason isanne aane feretira biyetinoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Baassotin beyye katamaassin kesse Bitaniya yistefa ke'eessi hamme esta ha'i. ");
INSERT INTO jnjl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesus e'so wonsak wolle katama hamfet makte. ");
INSERT INTO jnjl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ugnaasi teshta di isa belesini i'o biyaat ek barki hamin tosha toshatano isa gaanane aane dane. Estan ekka yi: «Hawungneen ekalo neekin isa gaanane bestonaatawe» yi. I'oos dey es kabaasik geregere ichimi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nawobaasakito es baron biyefaat: «Han belesiisi i'oos geregere aakkak ichimiso!» yiset diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus dey wolgire: «Futo nittok makefawungwa; amantonti faafaananenawa awuzakne uu shakaatinena han Belesiista sina barne faaron zagu koi'ba sinnoynaron han aamaasonnu: ‹Waatera yeet baariissi ha'towe› iyaatine sinanawa. ");
INSERT INTO jnjl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Amanera shiiphefeti baron zuutira ephphatootiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesus betemeqdesiissi girire assifeen maagni gaanynye meenawa daraasa kur'uni meena barki yeesere: «Han baron aro ha'suni hugnakinso zagidifatari? Han ha'suni hugnaason dey neek imaas oonso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus wolgire: «Isa mamsu nittotin mamsunawa. Es baron taak wolgaatine ta dey han baron aro ha'suni hugnak zagifanamato nittok makonawa. ");
INSERT INTO jnjl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohannisni haphquus ayin yaarinso? Ha'ooskiningwa wedey asunikininso?» yi. Baasso dey baassotna baassotna ekka yit merkesete: « ‹Ha'ooskingwa› iyaanine ‹Eekin awuni boor'a barik amano beytiso?› yirwa. ");
INSERT INTO jnjl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dey: ‹Asunikingwa› iyaanine asu zuuttambaase Yohannisnin raajju zagire biyefe boor'a daraasin digeniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Estan Yesusnik wolgire: «Aane arifeniwa» yisete. Bar dey wolgire: «Ese ta dey aro ha'suni hugnak han baron zuutira zagifanamato aafawa nittok makona wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tusire Yesus dey ekka yi: «Nittok awu sinna bestefaso? Isa asu hep naanggotba feer. Isaaski tai'sere: ‹Naataaso, hash hawung hamma wayinini akakilti dimaasta wostowa› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naas dey wolgire: ‹Beyin, aafa hamana wuza› yi. Sinuntano orfo gaabbere wostok hami. ");
INSERT INTO jnjl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dey hepsaaski tai'sere esiisimato maken naas wolgire: ‹Ma'iwa, hamanawa daamtaaso› yi. Sinuntano aane wostok hame. ");
INSERT INTO jnjl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ese han heppiisasin ababaasa ajajinon zagiis aafferinso?» yi. Baasso dey: «Tesuni barwa» yisete. Yesus dey ekka yi: «Futok nittok makefawungwa; girbo zuutife baassonawa gerkesefe baassotna Ha'oosi taatoossi giruk nittoostan zeemonewa. ");
INSERT INTO jnjl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohannis ookoni ugnaason nittok besuk yeen barik aane amanoweti. Sinuntano girbo zuutife baassonawa gerkesefe baassona barik amanesete. Nitto es baron biira boor'nitiison harmira aane barik amanoweti.» ");
INSERT INTO jnjl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Dey Yesus ekka yi: «Ooma beso dey odotiwa; wayinini akakilti toka isa asu feer. Bar dey biratobaason oja ojje wayinini usha ti'una doo'a yiishshe hoossi. Toolo keer'e bulinynyani meyak imaat ooma daa hami. ");
INSERT INTO jnjl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wayiniis gaanana wona kar'fana kabaasik basa haa'ooson ephphe yoosonek wostinynyabaasakitonin bulinynyani meyaki wosi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bulinynyani meya wostinynyaasakitonin ephphe isaasin ichete; isaasin worsete; oomiisin dey shu'ak ichete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wayinini akakiltiisi aba sinatiistan oom showo wostinynyanin dey wosi. Bulinynyani meya dey zeemotiisimato zagsete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Koi'baasta dey Wayiniisi aba: ‹Naataasin digsonewa› iyaat naabaasin wosi. ");
INSERT INTO jnjl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sinuntano bulinynyani meya naasin biyeteese baassotna baassotna: ‹Foshaason tooniis han barwa. Yaani woraat foshaason innor zaguniwa› yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naasin dey ephere wayiniisi foshni gerakalo kissere worsete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Eekin wayinini akakiltiisi daam yeefena kabaasik es bulinynyani meyaasta awu zagunirne faar sinna nittok bestefaso?» ");
INSERT INTO jnjl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Baasso dey wolgisere: «Es mangu asuni meyanon mangu woru woraattu wayinini akakiltini dimanon wonba wonbaasik gaanbaason imni oom bulinynyani meyak imanawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tusire dey Yesus baassok Korto matsafaassin ekka yi: « ‹Shu'ni keyaason oo'efe baasso kashshisete shu'aas; keyaasik kajjabaasta duuni shu'a siniwa; es bar dey Daamiiskintu siniwa; inno aafaasiknu diinqiwa› yistera tichche baron; aane feretuwetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Es bari boor'a nittok makefawungwa; Ha'oosi taato nittoostan oottera gaana gaanni daraasik imtonirwa.  ");
INSERT INTO jnjl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Es shu'aasta gande bar eestona; shu'aas basaasta gandona bar zuuttere fichintona. ");
INSERT INTO jnjl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","«Maagni gaanynye meenawa Ferisawini meena es besoson odesefaat baassosta makenamato arsete. ");
INSERT INTO jnjl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Es bari boor'a ephosonek sholsete. Sinuntano daraas raajju zagire biyeter sinna boor'a digsete.» ");
INSERT INTO jnjl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Hepsa dey Yesus besok ekka yit make: ");
INSERT INTO jnjl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Samaki taatoos naabaasik sargini koota koote taatone faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Taatoos teegte asuni meya kootaaski yoosonek wostinynyabaasin baassoki wosi. Sinuntano baasso kootaaski yoosonek aane sholsoto. ");
INSERT INTO jnjl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«Hepsa dey taatoos oom wostinynyani meyanon wosire teegte asuni meyaki hamfaat: ‹Ese sargini kootaason hoossin; omorusewa faru moonaase shuktera zuuttambaase hoore. Han sargisi kootaki yootiwa› yira makoti» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Sinuntano baasso hantaki wuzane unoy beyere isaas bulobaasi; oomiis nagadbaasi hami. ");
INSERT INTO jnjl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Oomiis dey wostinynyani meyanon ephphe salphsire ichche worsesete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Estan taatoos gi'tere meya taar'osakitonin wosire es wori baassotin worsonek zagi. Katamabesiison dey geyak kiichchonak zagi. ");
INSERT INTO jnjl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Estan wostinynyabaasakitonik ekka yi: «Sargini kootaas hoore; sinuntano teegte baasso kootaasik sholsunor sinete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ese ek ari ugnaasta kesfaat danti asusin zuutira han sargini kootaaski teegotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Wostinynyani meya dey ari ugnaasta kesere danete baassotin mangusin; ma'aasin zuutire teegsere sargini keyaason tuunisete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Sinuntano taatoos teegte irbaasakitonin biyak keer girifena kabaasik sargini maya maynoy isa asunin estak bi. ");
INSERT INTO jnjl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","«Estan ekka yi: ‹Zomotaaso; sargini maya maynoy aakkak hansi girisso?› yin asus dey shaakki. ");
INSERT INTO jnjl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«Taatoos dey wostinynyabaasakitonin: ‹Kushubaasewa wochobaase asin taar'a gerakalo fa talmaassi kisira ha'utiwa. Estak waasnewa ay'ni koyne sinanawa› » yi. ");
INSERT INTO jnjl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tusire dey Yesus: «Teegte asuni meya showo; kortertes dey garowa.» ");
INSERT INTO jnjl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Estan Ferisawini meya hamere Yesusnin wolumbaaski kamo aakkak chowusi gedonemato merkesete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Baasso nawoni meyanon Herodisni keen sina asuni meyaneen Yesusniki wossere: «Assinynyano! Ne futonir sintamatonawa Ha'oosi ugnanon futok assifatamatona arifeniwa. Asuni digak zagifata wuza aafa. Asunin dey aane korife. ");
INSERT INTO jnjl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ese innok makebbo; neek awu sinna bestefaso? Keesarnik girboni girbo sholsungwa wedey sholsutanso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesus baasso manguuson arifaat: «Sinnoy sinne bestesefe nitto, awuniron taan fattanefetiso? ");
INSERT INTO jnjl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Girbo kaastefa birriison taak besibbetiso!» yi. Baasso dey isa diinari teshshere besisete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bar dey: «Han barista fa gitoosewa baristaki fa tichaase oonirinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Baasso wolgire: «Keesarnirwa» yisete. Bar dey: «Ese Keesarniison keesarnik Ha'oosiron dey Ha'oosik imtiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Baasso dey es baron odeseteyse wolumbaasik diinqesefaat barin beyere hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Es wono: «Kitun kabu aafa» yisefe Sedukawini meya Yesusniki yeesere ekka yit mamussete: ");
INSERT INTO jnjl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Assinynyano! Muse: ‹Isa asu nawuba koonunoy kitifaanane aybaas es asuson ephphe es kiti aybaasik zalba fu'owowa› yiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Naafun ayna ayna innoki feeseter. Baassossin arkiis asu ephaat nawa koonunoy kiti. Es bari boor'a ate aybaas es asuson ephi. ");
INSERT INTO jnjl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Esiisimato dey hepsaas keezsaas hamma naafunsa kar'ananneen es asuson ephaat kitisete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Zuuttambesiise kitisetenneen orfo asus dey kiti. ");
INSERT INTO jnjl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ese naafunobesiise asuson ephetewa, kitun kabuni wono naafuniisasin aafferikinso asu sinanari?» ");
INSERT INTO jnjl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus wolgire: «Korto matsafaasikitononnawa Ha'oosi hugnanonna aane arifeti sinna boor'a daagefetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kitun kabsefe kabaasik asuni meya samak faase Ha'oosi wosiyane feertu sinonetano asu aafa ephosone wuza dey aafa girusone wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sinuntano kitun kabuni chowaasik Ha'oos nittok makena baron aane feretuwetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ekkatu yiwa: ‹Ta Abrahamni Ha'o, Isaaqni Ha'o, Yaqobni Ha'owa› Es bari boor'a bar hayewni meeni Ha'otano kituni meeni Ha'otawa.» ");
INSERT INTO jnjl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Daraas dey es baron odesere assubaasik diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesus Sedukawini meyanon maksone wuza turuksire shaakkusonek zaginamato Ferisawini meya odeseteyse isarik zuuttesete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Baassossin isa Museni tumaasi aru Yesusnin fattanok sholefaat ekka yit mamsi: ");
INSERT INTO jnjl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Assinynyano! Tumaassin aaffa ajajisinso arkiri?» ");
INSERT INTO jnjl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus barik wolgire: «Daama Ha'oneeson tuuma nibneesik, tuuma kaaneesik, tuuma safaraneesik keeshtowa. ");
INSERT INTO jnjl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Zuuttambaase asiistan denalonewa tesuni ajajiise esiiswa. ");
INSERT INTO jnjl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Esiisne fa hepsaniis dey: ‹Asunin ne neen keeshtefataasimato keeshtowa› yifa barwa. ");
INSERT INTO jnjl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tumaasi assunewa raajjuni meeni assuse es hep ajajiistatu kapta zagiwa.» ");
INSERT INTO jnjl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ferisawini meya zuuttesere feeseten Yesus ekka yit mamsi: ");
INSERT INTO jnjl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Kiristoosni chowaas nittok awu sinna bestefaso? Bar ooni naaso?» Baasso dey wolgire: «Dawitni naawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus ekka yi: «Eekin Dawit Ha'oni Ayyanak tuumme aakkak ‹Daamta› yire teegeso? ");
INSERT INTO jnjl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","« ‹Ha'oos, Daamtaasin; gumaneesin wochoneesi sikalosi yer'atak zagunanneen; hoi'ta teshnaasta duwa› yiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Dawit teetbaasik: ‹Daamta› yire teegenanneen eekin Kiristoos aakkak nawuba sinnirinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Baassossin isa kaamanu wolguk chimar oonu aafe. Es wononeen barin mamsuk chimar oonu aafe. ");
INSERT INTO jnjl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Esseen orfo Yesus daraasiknawa nawobaasakitonikna ekka yire make: ");
INSERT INTO jnjl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Museni tumaasi assinynyanawa Ferisawini meena Museni kodaasta diisetewa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Es bari boor'a baasso maksefe baron zuutira zagsoti dey oodti. Sinuntano baasso maksefe baron wostota aane feeshisefe sinna boor'a wostesefe baron zagutiita. ");
INSERT INTO jnjl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Faya dey wor'ak chimtonoy ba'a taar'e asuni ogogta wossisefe. Sinuntano baasso kushubesiisi waa'aknu ta'uk isanne aane sholsefe. ");
INSERT INTO jnjl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Asu baassotin biyanaktu wostobesiison wostesefe. Kur'amabesiison taggisere shiiphoni kabak maytefa maambesiisi fashanon dey dichisefe. ");
INSERT INTO jnjl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Koota maastefanaasta ulfinto dima, Ayhudni shiiphoni keyaassik dey ulfinni kodta duuktu sholsefe. ");
INSERT INTO jnjl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Gabaastak asu baassotin naga ooshshonaknawa: ‹Assinynyano!› yire teegsoneknatu sholsefe. ");
INSERT INTO jnjl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Sinuntano nitto assinynyantiis isar sinna boor'anawa nitto zuuttamnitiise dey ayna ayna sineti boor'ana ‹Assinynya› yistera teegtotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Den samak fe Abantiis isar sinna boor'a han daastak ooninnu: ‹Aabba› yira teegotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nitto arki assinynyantiis isa Kiristoos sinna boor'a ooniknu ‹Arki assinynya› yistera teegtotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nittoossin denalo sina bar nitto wostinynya sinowa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Teetbaason den teggife bar daa hatona. Teetbaason daa hatessife bar den teguna.» ");
INSERT INTO jnjl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Dey Yesus ekka yi: «Asu samaki taatosi girunoynamato gamalaason kulfife sinnoy sinne bestefe Museni tumaasi assinynyani meenawa Ferisawini meena haybuntiwa! Nitto teetaasik giruk aane sholefeti dey giruni baassotin aane gedfetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Nitto sinnoy sinne bestefe Museni tumaasi assinynyani meenawa Ferisawini meena shiiphontiison dichuk dicha asusikitoni keyaason maara turuksifeti boor'a haybuntiwa. Ese akama mangsuni kar'atu ephphatootiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Sinnoy sinne bestefe Museni tumaasi assinynyani meenawa Ferisawini meena haybuntiwa. Isa asu nitto amantooson ephphetoonak zaguk Baariistanawa ichma daastana biratesefeti. Ma'i yire ephpheteenanneen orfo nittoostan denalo hep kushunon geeni tir'maassi girunak hoorer zagsefeti. ");
INSERT INTO jnjl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Nitto aaftishu zoonsino! Haybuntiwa! ‹Asu betemeqdesiisik teyifaanane aafa aguna wuza› yifeti. Sinuntano ‹Betemeqdesiissiki fa warqeesik teyifaanane es teyyaasik ootterwa› yifeti. ");
INSERT INTO jnjl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nitto gowwa dey aaftishu; warqesingwa warqeeson korto zagi betemeqdesinoso wayyayi? ");
INSERT INTO jnjl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Esiisimato dey: ‹Asu shoo'aasik teyifaanane aafa aguna wuza; Sinuntano barista kuni maa'aasik teyifaanane es teyyaasik ootterwa› yifeti. ");
INSERT INTO jnjl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nitto aaftishu; maa'aasingwa maa'aason korto zagi shoo'asinso wayyayi? ");
INSERT INTO jnjl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Es bari boor'a shoo'aasik teyife bar shoo'aasiknawa shoo'aasta kuni maa'aasiknatu teyifewa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Betemeqdesiisik teyife bar betemeqdesiisiknawa barissi fa wuzasiknatu teyifewa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Samaasik teyife bar Ha'oosi zigimuknawa barista diifa bariknatu teyifewa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Sinnoy sinne bestefe Museni tumaasi assinynyani meenawa Ferisawini meena haybuntiwa. Azmachakin, insilaalikinnawa kemunikinna asiriissin isaron imfeti. Sinuntano tumaassi fa inya inya wuzasikitonon beyfeti. Es barikito dey futoni mangsuni kar'a, fakiya, amanto asu sinne bestooswa. Ek baron beynoy han baron dey zagutik sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nitto aaftishu zoonsino! Ushfeti wuzaassin kolachooson naalla kisira ha'aat gaalane fa inya wuzason koor'fetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Sinnoy sinne bestefe Museni tumaasi assinynyanawa Ferisawini meena habuntiwa. Sikalobesiis bo'onewa tiittanne tuumma feentu toofosewa koranaase asi tukanon kayimsifetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ne aaftishu Ferisawi! Zeemma toofosewa koranaase asi sikalonon massa kaynuwa. Estan gerakalobaasneen kayma sinanawa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Sinnoy sinne bestefe Museni tumaasi assinynyani meenawa Ferisawini meena yerefawutiwa. Sikalobesiis kituni meeni megaknawa kiinakna tuumma feen gerakalobesiis boorok maattera keeshira kuni moogasne feeseterwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Esiisimato nitto dey gerok asunik ookone feer sinnatu biistefetiwa. Sinuntano sikalontiis sinnoy sinne bestoknawa mangukna tuumma faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Sinnoy sinne bestefe Museni tumaasi assinynyani meenawa Ferisawini meena habuntiwa. Raajjuni meeni moogaason shu'ak keer'etir, ookoni meeni moogaason dey keeshshira ma'issetir. ");
INSERT INTO jnjl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","« ‹Zeemoti abaniisa meeni neyak inno faani sinfaanane raajjuni meeni hannaason baassoneen ane sinna wuukuni kabatawa› yifetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ese raajjuni meyanon wori baasso naanggota sinnitiison nitto teetaasik zaala maketiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ese nitto abaasakito gatisete baron nitto koi'sitiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nitto zawa, ufoni naanggota geeni tir'maasi ke'osin aakkak eella kesak chimatirinso? ");
INSERT INTO jnjl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Es bari boor'a ta raajjuni meyanon, techumni meyanon, assinynyani meyanon nittoki wosunawa. Baassotin dey worsoti, suutati, Ayhudni shiiphoni keyaassik ichati. Isa katamaassin ooma katamaassi kabgira kofkuti. ");
INSERT INTO jnjl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Es bari boor'a ooko sina Abelni hannaastan kabira betemeqdesiissinawa maa'a imtefana shoo'aasi ganesi worseti Berakiyyani naa Zakkariyasni hannaasta kar'ananneen han daasta wuukte ookoni meeni hannaasik ke'o nittoosta kar'nirwa. ");
INSERT INTO jnjl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Futok nittok makefawungwa, han ke'oos zuuttambaase han koontoosta kar'nirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tusire dey Yesus: «Yerusalemne Yerusalemne! Raajjuni meyanon worifa ne! Neeki wostere ye baassotin shu'ak ichfa ne! Ako nawubaasikitonon kosobaassi zuutifanaysimato ta dey naanggotneesikitonon zuutunak apuna wolla sholense! Sinuntano nitto aane sholoweti. ");
INSERT INTO jnjl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ese keentiis ona sinnatu ha'tona. ");
INSERT INTO jnjl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nittok makefawungwa, ‹Daamiisa sunak yeefe bar suustowa› utinneen hanneen ekalo taan aafawa biyati wuza.» ");
INSERT INTO jnjl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesus betemeqdesin kesse hamfeen nawobaasakito shu'ak keete betemeqdesiison besuk barki tai'sesete. ");
INSERT INTO jnjl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sinuntano Yesus wolgire: «Han baron zuutira biitiyoso? Futo nittok makefawungwa; boktonoy shu'aas shu'aasta diira fui'tonir aafawa.» ");
INSERT INTO jnjl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bar Dabrazayitini kumaasta diifen nawobaas baasso baasso barki tai'sesere: «Innok makowa; han bar aagenso sinanari? Ne yoosewa han daasi koi'ni besone aambanso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus wolgire: «Oonu nittotin eshanaatawa! ");
INSERT INTO jnjl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Showobesiis ‹Ta Kiristooswa!› yit ta sunaasik yoosone. Showobesiisin dey eshone. ");
INSERT INTO jnjl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Neebonewa neeboni odune odoti. Es bar dey sinanak sholsu sinna boor'a digotiita. Sinuntano koi'baas hanneengwa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Daraas daraasata; taatoos taatoosta kabuna. Maknewa daani shorkone showo dimsi sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Es bar zuuttera kophoni merosi keektone faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Es kabaasik asuni meya nitto shana ephphatootik aatire imone dey worsone. Ta sunaasi boor'a dara zuuttambaase asi sina oomtester sinati. ");
INSERT INTO jnjl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Es kabaasik showoni meya tuusa'sere orfo wolsone. Isaas oomiisin aatire imana. Asuni meya dey baassotna baassotna wal oomtososone. ");
INSERT INTO jnjl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Showo esh raajjuni meya kabsone. Showo meyanon dey eshone. ");
INSERT INTO jnjl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Manguusi aatamtan kabi chowa showoni meeni keeshtanaas koochona. ");
INSERT INTO jnjl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sinuntano koi'ba kar'ananneen chimme yere bar faruna. ");
INSERT INTO jnjl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dara zuuttambaase asik zaala sinanak Ha'oosi taatoni misirachchuni kaamaas daa zuuttambaase asiista maktona. Es kabaasiktu koi'baas yoona. ");
INSERT INTO jnjl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Ese raajju Danielnik maktenaasimato ‹Kiinsuni mangu wuzaas› korto dimaasta yerefeen biifena kabaasik feretife bar yaadatowowa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Es kabaasik Yuuda feese baasso den aamaaski eelosotowa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Keyaasi tukta fe bar keyaassi fa wuzason ephanak keronaata. ");
INSERT INTO jnjl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bulota fe bar maybaason ephanak orfo wolunaata. ");
INSERT INTO jnjl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Es kabaasik naaner asusikitonewa tama tanifa barikitone haybubawungwa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ese eelati wonaas yeeshu wedey beysani wonak sinnoynamato shiiphsoti. ");
INSERT INTO jnjl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Es kabaasik han daas testenanneen kabira hawung kar'a sinnor hanneen ekalo dey isanne sinnor akama shana sinanawa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Es wonaasikito kawuna shaki sinfaanane asha mayoos zuuttere fui'tona kabatawa. Sinuntano kortere fe asuni meeni boor'a es wonaasikito kawunana. ");
INSERT INTO jnjl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Es kabaasik oonu: ‹Ese Kiristoos hanta feer› wedey ‹Ekesta feer yifaanane amanotiitawa› ");
INSERT INTO jnjl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Eshni Kiristoosni meenawa eshni raajjuni meena kabsone. Baassok chimtefaanane kortere feese baassotinnu daagsuk akama akama biistera artonoy wuznewa diinqine bessone. ");
INSERT INTO jnjl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","«Ese han baron zuutira zeemma nittok makengwa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Es bari boor'a: ‹Zaboossitu fewa› yisefaatene kesatiita. ‹Aacho dimsitu fewa› yisefaatene amanotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kawuna kawunna awakesnarkin awagirinarki biistefanaasimato Asuni Naani yoos dey esiisimatotu sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kitu wuza faanaastatu arikasaas zuuttefa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Es shanani wonaasikito aatnanneen orfo geregere awaas talmona; assaas dey chaarefbaason kalana; baakuraasikito dey samastan kere woottona; samaastaki hugnaasikito shorkona. ");
INSERT INTO jnjl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Estan Asuni Naani beso samaasta bestona. Es kabaasik han daasta fe daraas zuuttere waassone. Asuni Naa dey akama hugnaknawa akama ulfinakna shaaruusikitota yeefeen biyone. ");
INSERT INTO jnjl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Akama markatani kaama odsuni Ha'oosi wosiyaasikitonon wosuna. Baasso dey samaasi diltan hamma dilbaasta kar'a fa acheech fashaassi hamere barik kortere feese baassotin zuutusone» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tusire dey Yesus: «Han belesini i'oosi besostan biira aruti. Waa'baas boodera tosha kotfana kabaasik begani assa ta'baason arutiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Esiisimato nitto dey es baron zuutira biyefeti kabaasik wonaas yaara finynyi tai'namato arutiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Futo nittok makefawungwa; es bar zuuttera sinana kabaneen han koontoos aafa aatana wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Samaasewa daase aatana; sinuntano kaamnaasikito isanne aafa aatana wuza.» ");
INSERT INTO jnjl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Dey Yesus: «Es wonaasewa es sa'atiise asin Abaasteno samaki wosiyaasnu sinun Naaso sino oonu arifer aafe. ");
INSERT INTO jnjl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noohni neyaasik sinnaasimato Asuni Naani yoos dey ekkatu sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Es neyaasik tishuni akaastan zeemma Nooh Merkebiissi girina wononeen asuni meya meetnawa ushetna; ephetnawa giritna feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tishuni akaas yaara zuuttambesiise asin tishkunanneen aane arsoto. Asuni Naani yoos dey esiisimatotu sinana. ");
INSERT INTO jnjl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Es kabaasik hep asuni meya buloni dimta ane wostosone. Isaas oottona; isaas fui'tona. ");
INSERT INTO jnjl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hep mashkasu isa dimta meya ni'ona; isaas oottona isaas fui'tona. ");
INSERT INTO jnjl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ese nitto Daamiis aro sa'atita yoonamato aane aruweti sinna boor'a guzira oodti. ");
INSERT INTO jnjl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sinuntano isa wuza arutiwa; keeni abaas waalaasi aaffa sa'atiista wiis yoonamato ari sinfaanane guzire keebaas dey yiishtonoynamato kalana kabawa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Esiisimato Asuni Naa dey nitto arunoyti sa'atiista yoonir sinna boor'a hoorera oodtiwa.» ");
INSERT INTO jnjl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Dey Yesus: «Muubesiison sholsinaastak imonek daambaas keerki fe asusata taassina amanamto dey nibbare yere wostinynyaas oonso? ");
INSERT INTO jnjl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Daambaas yeefena kabaasik ekka zagifeen danana es wostinynyaas suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Futo nittok makefawungwa; es wostinynyaasin fa waagba zuuttambaase asiistatu taassunawa. ");
INSERT INTO jnjl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sinuntano es mangu wostinynyaas: ‹Daamtaas wokketu yoonawa› yit nibbaassi safarefaananenawa, ");
INSERT INTO jnjl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wostoni zomoba sina baassotin ichak kabifaananena zayini meyaneen ane meere ushfaanane; ");
INSERT INTO jnjl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Es wostinynyaasa daam bar arunoyna wonaknawa oodnoyna sa'atikna yoona. ");
INSERT INTO jnjl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Es wostinynyaasin heppik kalasire ixabaason dey sinnoy sinne bestesefe baassoneen ane zaguna. Estak waasnewa ay'ni koyet foone sinana» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Tusire dey Yesus: «Es kabaasik samaki taatoos tonbesiison ephere mariisin ephak hoorera kesa asir durba naanggotane faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Baassossin uuchiis gowwa; uuchiis dey techumba faanar. ");
INSERT INTO jnjl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gowwaasikito tonbaason ephefanaknu ooma fu'tana zayiti aane ephowa. ");
INSERT INTO jnjl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Techumba faana barikito tonaasneen ane ooma dayto zayiti ephese. ");
INSERT INTO jnjl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mariis wokbaase zuuttere afay' ephaan kunesete. ");
INSERT INTO jnjl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Wassi daani kixxe sinfana kabaasik: ‹Ese mariis ye kessa ephoti› yifa womo odte. ");
INSERT INTO jnjl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Es kabaasik es durba naanggotaasikito zuuttera kabi tonbaason hoossise. ");
INSERT INTO jnjl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Gowwa durba naanggotaasikito techumba faana barikitoki: ‹Inno tonaas tishunir sinna boor'a nitto zayitiistan innok imotiwe› yise. ");
INSERT INTO jnjl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sinuntano techumba faana durba naanggotaas wolgira: ‹Nittoknawa innokna hooroni zayiti innoki aafa; ek hamma waagtefana keyaassin nittoron waagsoti› yise. ");
INSERT INTO jnjl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Gowwa durba naanggotaas waagonak hamefana kabaasik mariis ye. Hoorera fa durba naanggotaas mariisneen ane sargisi koota faanaasta girsete; gamalaas dey kulufte. ");
INSERT INTO jnjl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Orfo fu'te durba naanggotaasikito yaasera: ‹Daamiiso! Daamiiso! Innok gachaywa› yise. ");
INSERT INTO jnjl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sinuntano bar wolgire: ‹Futo nittok makefawungwe; ta nittotin aane arifat› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ese wonaasewa sa'atiise aane arifeti sinna boor'a guzira oodti.» ");
INSERT INTO jnjl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tusire dey Yesus ooma beso make: «Samaki taatoossi giruni chowaas ekkatu sinana; ooma daa hamak kesa isa asu wostinynyabaasakitonin teegere fa waagbaason imnaaysimatowa. ");
INSERT INTO jnjl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Es Daamiis isa isarbesiisik hugnabaasimato isaasik uuch mekiliti; hepsaasik hep mekiliti, keezsaasik isa mekiliti imaat hami. ");
INSERT INTO jnjl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Uuch mekiliti epha bar hamme nagadere ooma uuch mekiliti buu'si. ");
INSERT INTO jnjl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Esiisimato hep mekiliti epha bar hamme nagadere ooma hep mekiliti buu'si. ");
INSERT INTO jnjl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sinuntano isa mekiliti epha bar daambaasa waaganon taamme daason yiishshe yiiti. ");
INSERT INTO jnjl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Showo wonaneen orfo es wostinynyaasakitoni daam yeere baassoneen ane faadu ephi. ");
INSERT INTO jnjl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Uuch mekiliti epha bar yeere ooma uuch mekiliti buu'sire: ‹Daamiiso! Ne taak uuch mekilititu imitwa; ese ta ooma uuch mekiliti buui'singwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Daambaas dey: ‹Ne ma'ar dey amanamto wostinynyawa; garo kiisku wuzaasik amanamto sinit sinna boor'a ta akama wuzaasta neen taatsunawa; hang yaara daamneesa girasi giruwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hep mekiliti epha bar dey tai'sere: ‹Daamiiso hep mekilititu taak imitwa; ese dey ooma hep mekiliti buu'singwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Daambaas dey: ‹Ne ma'ar dey amanamto wostinynya; garo kiisku wuzaasik amanamto sinta boor'a ta akama wuzaastatu neen taatsunawa. Yaara daamneesa girasi giruwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Isa mekiliti epha bar tai'sere: ‹Daamiiso buknoyta dimaastan kar'tar; sikonoyta dimaastan zuutitar; ne keena budu asu sinneeson aringwa. ");
INSERT INTO jnjl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Es bari boor'a digefaattu hamma dey waagneeson daason yiishsha yiitingwa. Esewa; waagnees hanifawa› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Daambaas dey wolgire: ‹Ne mangu dey awuja wostinynya; ta buknoyna dimaastan kar'ar; sikonoyna dimaastan zuutinar sinnaason aritar sinnanneen; ");
INSERT INTO jnjl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ese waagnaason nagadere buu'suni baassok imit sinfaanane ma'ar sinanan kabawa; estan ta dey yaara mekilitinaason buu'baasneen ane ephana kabawa. ");
INSERT INTO jnjl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ese waagaason basa kushuussin ephpha asir mekiliti faana barik imtiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Faana barik dayistona dey arkuna; sinuntano garo kiisku faana barkin es fa barnu basaastan oottona. ");
INSERT INTO jnjl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Han ke'noy wostinynyaasin ek gero fa talmaassi kisira ha'utiwa; estak waasnewa ay'ni koyne sinana› yi. ");
INSERT INTO jnjl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Asuni Naa Ha'oosi wosiya zuuttambaaseneen ane ulfinbaasik yeefena kabaasik ulfinni zigimubaasta duuna. ");
INSERT INTO jnjl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dara zuuttere barki sina zuuttosone. Keemeriis fantuuson fizoossin korifenaasimato bar dey daraasin baassotna baassotna asin koruna. ");
INSERT INTO jnjl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Fantuusikitonon hoi'ta teshbaasta fizoosikitonon dey alda teshbaasta yeetuna. ");
INSERT INTO jnjl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Estan taatoos dey ho'itbaasta yere baassok ekka una: ‹Abataas suusna nitto yootiwa. Han daas testenanneen kabira nittok hoorera fa taatooson ephphatootiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Maktena maasiti; iktena ushiti; Irba sinna nittoki yaana irbasiti. ");
INSERT INTO jnjl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Atatu kutina maysiti; mettena mamsiti; taatena yaara mamsiti.› ");
INSERT INTO jnjl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ookoni meya dey wolgire ekka usone: ‹Daamiiso ne makten biira aage maasiniso? Wedey ikten biira aage ushiniso? ");
INSERT INTO jnjl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Irba sinna yeen aage neen irbasiniso? Wedey atatu kutifeen biira aage neen maysiniso? ");
INSERT INTO jnjl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Metten wedey taaten aage neeki yaara mamsiniso?› ");
INSERT INTO jnjl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Taatoos dey wolgire: ‹Futok nittok makefawungwa; zuuttambesiise asiistan ater sina han aytaasakitonisin isaasik zagiti bar taaktu zagitiwa› una. ");
INSERT INTO jnjl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Estan alda teshaasta yerse baassok dey ekka una: ‹Nitto erwutto; dabulosniknawa wosibaasikitokna hoore koi'ba foonto geyaassi hantan hamtiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Maktena aane maasuweti; Iktena aane ushuweti. ");
INSERT INTO jnjl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Irba sinna yaana aane irbasuweti; atatu kutina aane maysuweti; mettena dey taatena aane mamsuweti› ");
INSERT INTO jnjl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Baasso dey wolugsere: ‹Daamiiso makten wedey ikten; irba sinna yeen wedey atatu sinna kutifeen; metten wedey taaten biira aage argasu beynisso?› usone. ");
INSERT INTO jnjl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Taatoos dey: ‹Futo nittok makefawungwa; zuuttambesiise asiistan ater sina han aytaasakitonisin isaasik zagu beyti bar taak zagu beytimatowa› yire wolguna. ");
INSERT INTO jnjl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Es bari boor'a es baasso koi'ba foonto ke'oni keer hamone; sinuntano ookoni meya dey koi'ba foonto kaani keer hamone.» ");
INSERT INTO jnjl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesus es kaamaason zuutire makere koi'sinaase nawobaasakitonik: ");
INSERT INTO jnjl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Hep wonaneen orfo faasikani heeboos sinanamato aridifeti. Asuni Naa dey suuttonak aattere imtonirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Es kabaasik maagni gaanynye meenawa daraasa kur'uni meena Keyyaffa yistefe maagni gaanynye meeni gaanynyaasa ojni keerkalo zuuttesete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Estak dey Yesusnin aacho ugnak ephoneknawa worsonekna merkesete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sinuntano: «Daraasa ganesi naga tishuna boor'a heeboni wonaasik aafa sinanawuza» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesus zeemo sinak awataatoni mettan sina Bitaniyaki Simonni keertu fe. ");
INSERT INTO jnjl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Estak muu muunak tai'sere feen isa mashkasu waagba akama chima shitto albastiros yiste bilqadisi tuumanon ephpha barki yaara teetbaasta wuuki. ");
INSERT INTO jnjl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nawobaasakito es baron biire haaresefaat: «Han shitoos awuni boor'a baak ke'nor siniso? ");
INSERT INTO jnjl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Hamma akama waagsi waagtera tukamni meyak imtona kabawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesus es baron arifaat ekka yi: «Bar taak ma'a wuzatu zagiwa. Asuson awuniron hopsidifetirinso? ");
INSERT INTO jnjl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tukamni meya wonna wonna nittoneen anetu foosonewa. Sinuntano ta wonna wonna nittoneen ane aafawa foona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bar han shittooson atunaasta wuukinaas ta moogsi kabbartonak hoossukwa. ");
INSERT INTO jnjl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Futo nittok makefawungwa; aytaknu sinun han Misirachchuni kaamaas daa zuuttambaase asiistak maktefana kabaasik bar taak zagina bar dey baron safarok maktettu foonawa.» ");
INSERT INTO jnjl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Es kabaasik Askorotki Yuuda yistefe asire heppe nawobaasasin isaas maagni gaanynye meyaki hamme: ");
INSERT INTO jnjl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","«Ta Yesusnin aatira nittok imaanane awu taak imatirinso?» yi. Baasso dey keezasir shu'ni birri imete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Es sa'atiistan kabire aatire imana ma'a ugna sholet feer. ");
INSERT INTO jnjl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kixxa maastefana heeboosi tesuni wono nawobaasakito Yesusniki tai'sesere: «Faasikani heeboosi meeta'unon muutak ay hoossunik sholefatso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Bar dey: «Ek katamaassi hamfeti kabaasik danati asusa keer hamfaat: ‹Assinynyaas: sa'atinaas yaara kar'i; nawotaasakitoneen ane faasikani heeboosi meeta'unon neeki keertu zagunawa yifewa› utiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nawobaasakito dey Yesus ajajenaasimato zagsete. Faasikani heeboosi meeta'unon dey hoossisete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Waalfana kabaasik Yesus asire heppe nawobaasakitoneen ane muuk diisesete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Meesefeen Yesus: «Futo nittok makefawungwa, nittoossin isaas taan aatire imnirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Isa isarbesiis akamanon suumesere: «Daamiiso; tawa iyaatoso?» yiset mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus wolgire: «Taneen ane koranaassi dukife bartu taan aatire imnirwa. ");
INSERT INTO jnjl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Asuni Naa barik tichchenaasimato kituk hamnirwa. Sinuntano Asuni Naanin aatire imni bar haybubawowa. Es asus koonto shaki sinfaanane barik wayyawa» ");
INSERT INTO jnjl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aatire imni Yuuda dey wolgire: «Assinynyano; tawa iyaatoso?» yi. Yesus dey: «Ne maketaasimatowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Meesefeen Yesus tushaason ephphe galattefaat batte nawobaasakitonik: «Esewa, muutiwa; haniis ashnaaswa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Toofooson dey ephphe galattefaat: «Zuuttamnitiise han toofoossin ushtiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Haniis showo asuni meeni boor'aas feeshun ustonak wuuktoni gaddo teyyaasi harinnaaswa. ");
INSERT INTO jnjl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sinuntano nittok makefawungwa; abataasa taatosi nittoneen ane han gaddo wayinini gaanni ushanon ushananneen hawungneen ekalo hepsi aafawa ushanawuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Gaama gaametenneen orfo den Dabrazayitini kumaasta kesete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Estan Yesus: « ‹Keemeriisin ichana; fantuusi wodo dey siktona› yistera tichchera faar sinna boor'a hawungti waalaasik zuuttamnitiise taan mormotiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sinuntano kitun kabinanneen orfo nittoostan zeemma Galiilatu hamana» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Phexiros wolgire: «Oomiis zuuttere neen mormesefeknu ta neen aafa mormona wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus: «Futo neek makefawungwa; hawungti waalaasik ako oorunoyfeen; keeza wolla taan mormotawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sinuntano Phexiros dey: «Neneen ane kitu sholsifaananenu isanne aafawa neen mormona wuza» yi. Oom Nawobaasakito dey esiisimato maksete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Estan Yesus nawobaasakitoneen Getesemani yistefa dimaasta hami. Estak nawobaasakitonin: «Ta ek hamma shiiphonar sinna boor'a nitto hanta footiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yesus Phexirosninnawa hep Zabdewosni naanggotiisinna zoonsire hami. Tiir'o barin ephaan suumo ephi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ekka dey yi: «Kaanaas kituta kar'ananneen akamanon suumewa. Nitto hanta faafaat taneen ane chimtiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Baassostan garonon eksefaat kaa'nere ekka yit shiiphe: «Abataaso; chimtefaanane han shanani toofoos tayistan aatungwa. Sinuntano ne shuntamato sinanaastano ta shunnamatotawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Es keez nawobaasakitoniki wolle yeere kunefeen dani. Phexirosnin: «Taneen ane isa sa'atine guzuk aane chimetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Fatanasi girunoytimato guzira shiiphotiwa. Ayyanaas hooreratu fa, sinuntano ashaas hopiyawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hepsa dey hamme ekka yit shiiphe: «Abataaso! Han shanani toofoos ushanon ushnoy faana aatak chimtonor sinfaanane ne shunta bar sinungwa» ");
INSERT INTO jnjl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wolle yeere kar'in nawobaasakitoni aafaas afay'nik fayfaan kunefeen dani. ");
INSERT INTO jnjl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dey baassotin beyye hamme keezsa ukkotiisimato shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Estan nawobaasakitoniki yeere: «Hashneen kar'a kunfetiyoso? Dey beysa ephtifetiyoso? Ese Asuni Naa boor'ni meeni kushusi aattere imtona sa'atiis kar'iwa. ");
INSERT INTO jnjl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kabseni hamniwa. Taan aatire imni bar tai'sewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Es baron makefeen asire heppe nawobaasasin isaas sina Yuuda ye. Barneen ane dey siifonewa mukne epho showo dara yeesete. Baasso dey maagni gaanynye meyakinnawa daraasa kur'uni meyakinna wostere yeeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aatire imni Yuuda: «Ta daamona barintu ephatiwa» yire baassok beso imme feer. ");
INSERT INTO jnjl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuuda geregere Yesusniki tai'sere: «Assinynyano! Naga neek sinfawungwa» yit daame. ");
INSERT INTO jnjl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus: «Zomotaaso! Ese yaata chowaason koi'suwa?» yi. Estan asuni meya Yesusniki tai'sesere ephete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Es kabaasik Yesusneen ane fe baassossin isaas kushubaason shongere siifoson kisire maagni gaanynye meeni gaanynyaasa wostinynyani odonon kace. ");
INSERT INTO jnjl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sinuntano Yesus barik ekka yi: «Siifo kisife baasso zuuttere siifoktu tishusone sinna boor'a siifoneeson zanbaassi wolgira gedwa. ");
INSERT INTO jnjl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Abataasin shiiphefaanane bar showo kumsi faadtoni meya taar'o Ha'oni wosiya wosuk hopunirne faar sinna nittok bestefawoso? ");
INSERT INTO jnjl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ekka sinar sinfaanane: ‹Shana ephphetoonak sholsifa› yifa korto matsafaasi kaama aakkak sinanak chimnirinso?» ");
INSERT INTO jnjl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Es kabaasik Yesus daraasik: «Bo'inynyani ephni asunimato siifonewa mukne ephpha taan ephatik yaatiyoso? Wonna wonna betemeqdesiissi assit nittoneen ane faana kabaasik aane taan epheti. ");
INSERT INTO jnjl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sinuntano han bar zuuttambaase sinnaas raajjuni meeni matsafaassi tichchera kuni bar sinanakwa» yi. Es kabaasik nawobaasakito zuuttambesiise barin beyere eelesete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesusnin epha asuni meya maagni gaanynye meeni gaanynya sina Keyyaffaniki taamete. Estak dey Museni tumaasi assinynyanawa kur'uni meena zuuttere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Sinuntano Phexiros maagni gaanynye meeni gaanynyaasa ojni keerkalo kar'ananneen woksok orfobaase hami. Sinni chowaasi ko'anon biyanak keerkalo girire tasoni meyaneen di. ");
INSERT INTO jnjl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Maagni gaanynye meenawa Ayhudni shonggota diisefe baassotna zuuttere Yesusniista kituni mangsuni kar'a katusonek esh zaalnin sholset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Showo esh zaalni meya tai'sisefeknu Yesusnin kituta katuni zaala aane danoto. Koi'baasta dey hep zaal tai'sere: ");
INSERT INTO jnjl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Han asus: ‹Betemeqdesiison bogaat keezsinari wono wolgira keer'anawa› yiwa» yit maksete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Maagni gaanynye meeni gaanynyaas kabire: «Han asuni meya neyista maksefe zaalaason aane wolgifenoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sinuntano Yesus shaakki. Maagni gaanynye meeni gaanynyaas dey: «Hayewa Ha'oosi sunak neen teysifawungwa! Ne Ha'oni naa Kiristoos sinneeson innok makowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus: «Ne maketaasimatowa; nittok makefawungwa, hawungneen ekalo Asuni Naa hugnaba faana Ha'oosi ho'itta diifen biyatiwa. Esiisimato dey samaki shaaruusikitota yeefeen biyatiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Es kabaasik maagni gaanynye meeni gaanynyaas maybaason karasaat: «Ha'oosta mei'ni kaama makewa. Nittonu me'baason odetiwa. Haniistan ooma zaala awuniron sholsunirinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Eekin nittok awu sinna bestefaso? Baasso dey: «Kitutu barik sholsuwa» yit wolgisete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Es kabaasik sinba tujeset, ki'eset, bocheset: ");
INSERT INTO jnjl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Kiristoosno! Neen ichaas oonso? Raaji innok makebbo» yiset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Phexiros ojni keerkalo diifen isa keerki wostinynya barki tai'sera: «Ne dey Galiilaki Yesusneen ane faatarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sinuntano Phexiros: «Ne makefata baron aane arifatwe» yit zuuttambesiise asi sinak morme. ");
INSERT INTO jnjl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Finynya kesfeen ooma keerki wostinynya dey barin biyaat esta fe baassok: «Han bar Naaziretki Yesusneen ane feerwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hepsa dey Phexiros teyire: «Es makefata asusin aane arifatwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Garo sa'atineen orfo esta yere asuni meya tai'sere Phexirosnin: «Wolumnees assidifawa, futok ne baasso ganeyaassin isaaswa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Es kabaasik Phexiros: «Ta es asusin aane arifatwa» yit bar barin wolgire erwuknawa tewukna kabi. Estan geregere ako oori. ");
INSERT INTO jnjl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Phexiros dey: «Ako oorunoyfeen keeza wolla mormotawa» yit Yesus makena bar nibbaassi keji. Gerakalo kesse dey akamanon suumere waasi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","E'so wonsak maagni gaanynye meenawa daraasa kur'uni meena zuuttere Yesusniista kituni mangsuni kar'a katusonek merkesete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Estan Yesusnin taar'e ephphe taamme ha'sife Pilatosniki aatire imete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesusniista mangsu katenamato aatire ima Yuuda biyaat gaabbe. Keezasir shu'ni birriison dey maagni gaanynye meyaknawa kur'uni meyakna wolgire imi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«Kayim asusin kituk aatire imnaasik boor'a wostengwa» yi. Sinuntano baasso: «Eekin innotin aamba tiir'e? Ne girowa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuuda dey keezasir shu'ni birriison betemeqdesiissi taamme ha'aat hamme geetere kiti. ");
INSERT INTO jnjl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Maagni gaanynye meya keezasir shu'ni birriison ephere: «Han bar harinni waaga sinna boor'a betemeqdesiisik imte waagaassi woi'sunik sholsutawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Estan merkesere irbani mooga sinanak koda ooi'fe basa daanon waagsete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Es bari boor'a es daas hash hawungneen kar'a: «Harinni daa» yisteratu teegtefa. ");
INSERT INTO jnjl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Esiisik: «Israelni naanggotaasikito gammatesete barik sinni waaga keezasir shu'ni birriison ephete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Daamiis taan ajajenaasimato koda ooi'fe basa daasik kaassete» yistera raajju Ermiyasniki kamo makte bar sini. ");
INSERT INTO jnjl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesus daa ha'sife Philaxosni sina ta'i. Bar dey: «Ne Ayhudni taatonoso?» yit mamsi. Yesus wolgire: «Ne maketaasimatowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Maagni meeni gaanynyasakitonawa kur'uni meena barin malassefeen isa wuzane aane wolguwe. ");
INSERT INTO jnjl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Estan Pilatos: «Apun wuza neyista teshshere malassedifemato aane odefenoso?» ");
INSERT INTO jnjl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Daa ha'sife bar akamanon diinqonanneen teshshesete malataasik isa kaamanu aane wolguwe. ");
INSERT INTO jnjl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Daason ha'sife bar faasika fasikaasik daraas isa taato kottonak mamsinaysimato taatoos kotin dostere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Es kabaasik manguk arto Barbaan yiste taato feer. ");
INSERT INTO jnjl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Baasso zuuttere feeseten Pilatos: «Barbaaniningwa wedey Kiristoos yiste Yesusnin kotanak sholefetiso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatos ekka yinaas baasso manguk aatire imobesiison arire feer sinna boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatos mangsuni kar'ni kodaasta diifen basa asus: «Han asusa chowanon waalin miitok akama shana biingwa. Han kayim asusata isa wuzane zagutaatawa» yira wosi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sinuntano maagni gaanynye meenawa kur'uni meena Barbaan kottonaknawa Yesus wortonakna mamsusonek daraasin kiitisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Daa ha'sife bar wolgire: «Heppiisasin aafferin kotanak sholefetiso?» yit daraasin mamsi. Baasso dey: «Barbaannintu kotatak sholefeniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatos: «Eekin Kiristoos yistefe Yesusnin awu zagunarinso?» yi. Zuuttambesiise: «Suuttowowa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ha'sife bar: «Aamso? Bar mangsina wuza aambanso?» yi. Sinuntano baasso: «Suuttowowa» yit chaaga arkissisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatos biin naga turuksunir sinbaase aka barik teshshosonek zagire daraasa sina kushubaason maset: «Ta han asusa harinsik aafotwa. Nittotu mamustonirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Daraas zuuttere: «Han asusa hanna innoostanawa naanggotniistana sinun» yire wolgisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Es kabaasik Barbaannin kotte gafkaat Yesusnin alanggak ishshire suuttonak aatire imi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Es kabaasik ha'sife basa meya taar'osakito Yesusnin ephphe ha'sife basa ojaasi keerkalo taamete. Meya taar'osakitonin dey Yesusni biratoosta zuutisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Maambaason gaa'efaat she'a maama maysisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Seer'a ma'ire teetbaasta guufsisete. Hoi'ta kushubaassi sobboqoni haaro ootisefaat sinba kaa'nesere: «Ayhudni taatono! Naga neek sinfawungwa» yit kanyesete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tujeset haarooson dey kushubaassin ephere teetbaason icheset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kanyesetenneen orfo she'a maamaason gaa'efaat basa maamaason wolgire maysisere suuttonak ephphe hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ha'sife basa ojaasi keerkalon kesefe kabaasik Simon yistefe Qerenaki asunin danesere mesqeliison wor'anak giddisisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Esseen orfo kotbaas dey: «Teetni mega» yistera teegtefa Golgota kar'ete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Estak tisha woi'to wayinini usha ushanak imete. Bar dey bechchire biyaat ushanak aane sholowe. ");
INSERT INTO jnjl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Suutetenneen orfo maambaasta ixa ha'sere haa'esete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Esta diisefaat oodet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","«Han bar Ayhudni taato Yesuswa» yifa malatni ticha den mesqeliisi teetta yeetisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Es kabaasik hep bo'inynyanin isaasin oi'ta teshbaasta, isaasin dey alda teshbaasta Yesusneen ane suutete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Esta kamo aatfe asuni meya dey kashshuk teetbesiison shorkisefaafe me'esete: ");
INSERT INTO jnjl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Betemeqdesiison bogaat keezsinari wono keer'ni ne ese teetneeson fu'owa! Ha'oni Naa sinfaatane mesqelistan kerowa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Esiisimato dey maagni gaanynye meya, Museni tumaasi assinynyanawa kur'uni meena isarik ekka yiset kanyet feeseter: ");
INSERT INTO jnjl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Oomiisin fu'e, sinuntano teetbaason fu'ok aane chime. Israelni taato sinfaanane hash mesqelistan kerowowa. Inno dey barik amanoniwa. ");
INSERT INTO jnjl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bar Ha'oosik amanewa. ‹Ta Ha'oni Naawa› yiwa. Ese Ha'oos barin shunar sinfaanane hash barin fu'ongwa.» ");
INSERT INTO jnjl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Esiisimato dey barneen ane suutte bo'inynyani meya dey me'eset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Issun sa'atiistan kabira hamma izgin sa'ati kar'ananneen daa zuuttambaase asiista talma sini. ");
INSERT INTO jnjl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Izgin sa'atiistak Yesus: «Elohe! Elohe! lamasebeqtani!» yire akama kaamak chaagi. Kotbaas dey: «Ha'onaase! Ha'onaase! Awuni boor'a taan beyitse» uu. ");
INSERT INTO jnjl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Esta yerse asuni meya odesefaat «Han bar Eliyasnintu teegedifewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Geregere baassossin isar eelle sefinegi ephphetesshere suqaro wayini tuunire sobboqoni haaroni fashta duusire ushanak imi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sinuntano oomiisakito «Beytiwa, Eeliyas yeere barin fu'obane biyaniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus hepsak akama kaamak chaagge kaabaason aatire imi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Es kabaasik betemeqdesiisi yinu denun kabira daa kar'a heppik karate. Daas dey shorke. Daastaki kaa'oos dey kalate. ");
INSERT INTO jnjl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Moogaasikito dey gachchen sir kunse kortoni meyaassin showoni meya kitun kabsete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Moogaassin kesere Yesus kitun kabinanneen orfo korto katama Yerusalem girsete. Estak dey showo asuni meyak bestesete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tii meya taar'oni meeni gaanynyaasnawa barneen ane Yesusnin oodet feese baassotna daasi shorkononnawa sina chowaasonna biyeseteyse akamanon digsere: «Han bar futok Ha'oni Naawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yesusnin argasit Galiilan basa orfoose hama showo mashka meya woksok yersefaat biyet esta feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Baassossin Megdelawitki Maarami, Yaqobnawa Yosefna asi into Maarami, Zebdewosni naanggotiisa into dey esta feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Waalfana kabaasik Yosef yiste isa otum asu Armatiyasni kataman ye. Bar dey Yesusni nawo. ");
INSERT INTO jnjl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Es bar Pilatosniki tai'sere Yesusni dugnooson ephanak mamsi. Pilatos dey imtonak ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosef dugnooson kayma maamak zuuti. ");
INSERT INTO jnjl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Shu'ak katera hoorera kuni Yosefni gaddo moogsi taamme kabbare. Estan moogaasi noonota inya shu'a bukalsire ukaat hami. ");
INSERT INTO jnjl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Megdelawitki Maaraminewa ooma Maaramine moogaasi sinta diisefer. ");
INSERT INTO jnjl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wonotirik beysani wonaasi hooroneen orfo maagni gaanynye meenawa Ferisawini meena isarik Pilatosniki hamere ekka yisete: ");
INSERT INTO jnjl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«Daamiiso! Han eshinynyaas zeemo kaak feena kabaasik: ‹Keezsinari wono kitun kabunarwa› yina bar nibniista kejiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Es bari boor'a nawobaasakito waalin yeesere dugnooson wiisefaat daraasik: ‹Kitun kabiwa› usonoytemato keez wona kar'ananneen moogaason oodosonek ajajowa. Es bar sina shakaanane orfoti daagsuus sinatiistan akamanon mangu sinarwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatos wolgire: «Oodni meya taar'oni meya feeseter sinna boor'a ephpha hamfaat arifetimato oodsutiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Baasso dey hamere moogaasi noononon shu'ak kulfaat tukbaasta maatamak ichche oodni asunin oodsisete. ");
INSERT INTO jnjl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Beysani wonaas aatnanneen orfo torbaniisi tesuni wono wonsa she'u feteetifana kabaasik Megdelawitki Maaraminewa ooma Maaramine moogaason biyak hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Daamiisa wosiya den saman kerena boor'a akama daani shorko sini. Bar dey tai'sera moogaas uktera kunna shu'aason bukalsaat barista di. ");
INSERT INTO jnjl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Daamiisa wosiyani gito dey kawunanimato chaaret faar. Maybaas dey ironi she'animato foro. ");
INSERT INTO jnjl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tasoni meya dey Daamiisa wosiyanon digak korkit kitune feer sinete. ");
INSERT INTO jnjl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sinuntano Daamiisa wosiya mashka meyak: «Nitto digotiitawe, suutte Yesusnin sholefetimato aringwe. ");
INSERT INTO jnjl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bar hantak aafe, makenaasimato kitun kabi. Kunna dimaason hani yaasefaat biyotiwe. ");
INSERT INTO jnjl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Taptera hamfaat: ‹Kitun kabiwa, Ek Galiila zeemme hamnir. Estak uphotiwa› yira nawobaasakitonik makotiwe. Ese ta nittok maken» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Estan digaknawa akama girakna taptesere moogaasi teshan nawoni meyak makok eelesete. ");
INSERT INTO jnjl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yesus uguntak baassok uphere: «Naga nittok sinfawungwe» yi. Baasso dey barki tai'sesere wochobaason ephphe sagadesete. ");
INSERT INTO jnjl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Es kabaasik Yesus: «Digotiitawe! Hamfaat Galiila hamonek aytaasakitonik maksoti. Estak taan biyosone» yi. ");
INSERT INTO jnjl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mashka meya hamefeen meya taar'oni meyaassin isa isaas katamaassi hamere sina chowaason zuutire maagni gaanynye meyak maksete. ");
INSERT INTO jnjl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Maagni gaanynye meya kur'uni meyaneen zuuttere merkesetenneen orfo meya taar'osakitonik akama waaga imefaat ekka yisete: ");
INSERT INTO jnjl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","« ‹Inno kunfeni wassi nawobaasakito yeesere dugnooson wiisetewa› yira daraasik makotiwa. ");
INSERT INTO jnjl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Han chowaason ha'sife bar odefaanane inno barik mai'sira makoni. Dey rakko nittoosta kar'noynamato zaguniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Meya taar'osakito waagaason ephefaat baassok maktenaasimato zagsete. Es chowaas dey hawungneen kar'a Ayhudni meeni ganeyaassi maktettu faafa. ");
INSERT INTO jnjl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Asire isse nawobaasakito Yesus hamonek makena Galiilaki fa aamaasta hamete. ");
INSERT INTO jnjl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yesusnin biyeteese barik sagadesete. Sinuntano baassossin isa isaas «Han wuzaas futota» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus baassoki tai'sere: «Samaknawa han daastakna ha'suni hugna zuuttera taak imtewa; ");
INSERT INTO jnjl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ese hamfaat han daasta fe daraasin zuutira aba, Naa, Korto Ayyanaasi sunak haphqira ta nawo zaguti; ");
INSERT INTO jnjl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ta nittok ajajena baron zuutire oodosonek assuti. Ta han daasi ko'a kar'ananneen wonna wonna nittoneen anetu fawungwa» yi.");
INSERT INTO jnjl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Haniis Ha'oni Naa sina Yesus Kiristoosni chowaason makefa misirachchuni kaamni tesu. ");
INSERT INTO jnjl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Raajju sina Isayyasni matsafaassi: «Ugunneeson sabsuni wositarin; ne sinaasta zeemma wosuna; ");
INSERT INTO jnjl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dey: « ‹Daamiisa ugnanon hoossuti; sabsira mai'suti› yit; zaboossi chaagfe asuni kaama.» yistera tichche. ");
INSERT INTO jnjl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Es bari boor'a haphqife Yohannis ichma daassi: «Boor'nitiis feeshun ustonak harmira haphuqtoti» yit maket ye. ");
INSERT INTO jnjl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yuudani daastannawa Yerusalemni katamaassinna zuuttere akam showo asuni meya Yohannisniki yeesere boor'besiison harmifaafe Yordanosni akaassi barik haphukteset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Haphqife Yohannisni maamaas gaalani esak wichonontu mayfe. Geshobaason dey talfaktu taar'efe. Muubaas bilnganewa zaboni eesne. ");
INSERT INTO jnjl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Asuni meyak: «Ta mugira chaa'mabaasi taar'anon kotak sholsunoynar tayistan akamanon ulfinto ta orfoosta yoonir. ");
INSERT INTO jnjl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ta nittotin akaktu haphquna. Sinuntano bar Korto Ayyanaktu nittotin haphquna» yit maket feer. ");
INSERT INTO jnjl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Es kabaasik Yesus Galiilaki daasta fa katama Naaziretun yeere Yordanoski akaassi Yohannisnik haphukte. ");
INSERT INTO jnjl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Geregere Yesus akaassin kesfena kabaasik samaas gachchefennawa Ha'oni Ayyana nakalonimato sinna basaasta kerefeenna bi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Es kabaasik: «Shunfanana naata newa. Neektu ta girefawungwa» yifa kaama den saman odte. ");
INSERT INTO jnjl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Geregere Korto Ayyana barin ichma daassi taami. ");
INSERT INTO jnjl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ichma daassi Sexanak fattantet acheechasir wona di. Buur'uni Gonyoneentu fe. Ha'oni wosiya dey barin argasse. ");
INSERT INTO jnjl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohannis taatoni keer girinanneen orfo Yesus Ha'oosi misirachchuni kaamanon maket Galiila hami. ");
INSERT INTO jnjl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Assifena kabaasik dey: «Wonaas ko'i, Ha'oosi taatoni ha'su tai'se. Boor'nitiison harmira misirachchuni kaamaasik amanoti» iyaafe maket feer. ");
INSERT INTO jnjl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesus Galiilaki baarisi tesha kamo aatfet wostobesi qurxummini esha sinna Simonnawa ayba Indiriyasna yugudobesiison akaassi ha'sefeen bi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus dey baassok: «Taneen ane yootiwa. Eekaat Ha'oosi taatosi asunin zuututik zagunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Baasso dey geregere yugudobesiison beyfaat barneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Estan garonon eksefena kabaasik Zabdiyosni naanggot Yaqobnawa ayba Yohannisna feeseter. Baasso goonuusta diisefaat yugudobesiison ma'issefeen bi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Estan geregere hang barki yoosonek teege. Baasso dey ababesi Zabdiyosnin wostinynyasakitoneen goonuusta beyye ha'aat barneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesusnawa nawobaasakitona Kifirnahom katama hamete. Geregere Yesus beysani wonaasik Ayhudni shiiphoni keyaassi girire assu ephi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yesus Museni tumaasi assinynyani meya assisefemato sinnoynaron daason ha'sife baassomato sinna boor'a assifena assusik diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Es kabaasik Ayhudni shiiphoni keyaassi kiina ayyana ephna isa asu ekka yit chaagi: ");
INSERT INTO jnjl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Naaziretki Yesusno! Inno neneen awuni isarni faarinso? Innotin tishkutak yaataroso? Oo sintamato ta arifawungwa. Ne Ha'oosi Kortowa!» ");
INSERT INTO jnjl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesus dey: «Isa kaama kotnoy basaassin kes!» yit chinire ke'i. ");
INSERT INTO jnjl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kiina ayyanaas asusin gansira tookonak zagira akama kaamak chaagga basaassin kesi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Asuni meya zuuttere diinqok: «Han bar aambanso? Aroni gaddo assunso? Kiina ayyanaason ha'suni hugnak ajajen bar dey ajajamer» yit baassotna baassotna mamsit feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Geregere Yesusni chowaasi wolla Galiilani biratoosta fa daa zuuttambaase asiissi zi'i. ");
INSERT INTO jnjl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Es kabaasik Yesus Ayhudni shiiphoni keyaassin kesse Yaqobneen Yohannisneen ane Simonnawa Andriyasna asi keer giri. ");
INSERT INTO jnjl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Estak Simonni asusi into gumtanni mero mettera kunir. Bari mettooson geregere Yesusnik maksete. ");
INSERT INTO jnjl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesus barki tai'sere kushubaassi zatte kabgi. Meroos dey ma'in kabira baassotin irbasi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Awa girin talmefana kabaasik asuni meya mettanni meyanonnawa kiina ayyana ephna meyanonna zuutire Yesusniki ephphe yeesete. ");
INSERT INTO jnjl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Katamaassi fe asuni meya zuuttambesiise keyaasi fochata zuuttere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesus showo tesa merok mettere fe showo asunin fati. Showo kiina ayyanaason dey kisi. Kiina ayyanaasnu bar oo sinnamato arsera faaser sinna boor'a Yesus isa wuzane maksonak aane sholowe. ");
INSERT INTO jnjl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wonsa wassi kabire wonnoyfeen Yesus keerun kesse isa fuchcha dima hamme Ha'o shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simonnawa barneen ane feese baassotna sholok kabi hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Danere: «Asu zuuttere neen sholediferwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesus wolgire: «Ta yaanaas esiisik sinna boor'a hantan ooma tai'so dimaasta faase katamaassi dey hamfaani kaambaason makongwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayhudni shiiphoni keyaassi kaambaason maket kiina ayyanaason asusasin kisit Galiilani daa zuuttambaase asiissi kutit feer. ");
INSERT INTO jnjl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Isa awataatoni mettan barki yeere kaa'nefaat: «Ne shunfaatane fatuk chimatawa» yit shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus barik kenashtefaat kushubaason shongere atubaason taptifaat: «Shunfaungwa, kayimma» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Asus geregere merobaassin fari. ");
INSERT INTO jnjl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesus asusin mai'sire kiitire gafkaat: ");
INSERT INTO jnjl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Han baron ooknu makonoytamato aruwa. Sinuntano hamma teetneeson maagisik besu. Baassok zaala sinanak faruneesik Museni tumaas makena maa'aason imma» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sinuntano asus estan kesnaase sina chowaason asu zuuttambaase asik wollok kabi. Es bari boor'a Yesus ammanon kesse aaffa katamaassinu girunak aane chime. Baak gerakalo asu foonto dima hamme di. Asuni meya dey daa daassin barki yeeset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Garo wonaneen orfo Yesus Kifirnahom katama wolle yeere keer feenamato odte. ");
INSERT INTO jnjl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Keyaassi tuumme focharaas tiir'onanneen showo asu zuutte. Yesus dey baassok kaambaason assittu fe. ");
INSERT INTO jnjl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Acheech asu isa laafa asuni wor'e Yesusniki yeesete. ");
INSERT INTO jnjl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dara showena boor'a Yesusniki tai'suk aane chimoto. Bar feena dimaastaki keyaasi aafanon kabgaat oppobaase yeet keer gedete. ");
INSERT INTO jnjl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus baasso amantooson biyaat laafa asusin: «Naa! Boor'nees feeshun yistewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Esta diise Museni tumaasi assinynyaasasin isa isaas nibbesiissi: ");
INSERT INTO jnjl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Han asus awuni boor'a effatena mei'ni kaama makefeso? Isa Ha'oneen ooma boor'aason feeshun uuk chimnir oonso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Geregere Yesus nibbesiisi safaranon ayyanabaasik arifaat ekka yi: «Nibnitiissi awuniron ekka safaredifetirinso? ");
INSERT INTO jnjl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Laafaasin: ‹Boor'nees feeshun yistewa› usingwa ‹Kabira opponeeson wor'a hamma› uusinso kashoyi? ");
INSERT INTO jnjl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Sinuntano Asuni Naa daastak boor'aason feeshun uuk ha'suni hugnaba foobaason aruti» iyaat laafaasin: ");
INSERT INTO jnjl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Neek makefawungwa: Kabira opponeeson wor'a keene hamma!» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Geregere kabire oppobaason wor'e asu zuuttambaase asi sina kesse hami. Es bari boor'a asuni meya zuuttere diinqeset: «Effatena wuza biira aane aruweni!» yit Ha'ooson galattesete. ");
INSERT INTO jnjl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus hepsa wolle Galiilaki baarisi tesha hami. Showo dara dey zuuttesere barki yeeseten assi. ");
INSERT INTO jnjl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Esta kamo aatfeen girbo zuuttefanaasta di Alfiyosni naa Lewinin biyaat: «Taneen ane hamniwa» yi. Bar dey kabire barneen ane hami. ");
INSERT INTO jnjl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Esseen orfo Yesus Lewini keer muu meefen showo asuni meya dey ane feeseter. Baassossin showo boor'ni meenawa girbo zuutife baassona Yesusnawa basa nawoni meena ane muu meesedifer. ");
INSERT INTO jnjl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ferisawini meeni keen sina tumaasi assinynyani meya Yesus girbo zuutife baassonawa boor'ni meena ane meefen biyefaat: «Girbo zuutife baassonawa boor'ni meena awuniron ane meere ushdiferinso?» yit nawoni meyanon mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus es baron odefaat: «Mettanteno fayyanik etni asu aane sholsifewa. Ta yaanay boor'ni meyanon Ha'ooski wolguktano ookoni meyaktawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yohannisni nawoosnawa Ferisawini meena soomere shiiphseter. Isa isa asuni meya Yesusniki yeesere: «Yohannisni nawoosakitonawa Ferisawini meeni nawoosnakitona soomere shiiphseter. Ne nawoni meya soomere shiiphso beyefees awuni boor'anso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus dey baassok wolgire: «Mariis baassoneen ane feen mozgituni meya soomere shiiphsonek sholsifawoso? Indaanewa! Mariis baassoneen ane feen soomere shiiphsonek aane sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sinuntano mariis baassostan oor kesana wona yoona. Es kabaasik soomere shiiphsone. ");
INSERT INTO jnjl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Kur'u maamaasta gaddo erbe kunsire zoorifer aafe. Es baro zagaanane gaddo erbees kur'u mayaason karasir. Karatobaas dey zeemmati baristan akamatu sinana. ");
INSERT INTO jnjl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Esiisimato kur'u ha'matoossi ora wayinini usha gedfer aafewa. Gedfaanane wayinini ushaas ha'matooson karasirwa. Waynini ushaas wuukter ha'matoos dey mangirwa. Es bari boor'a ora wayinini ushaasik gaddo ha'matotu sholsifarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Beysani wonasik Yesus foshaasta kamo aatfeen nawoni meya ane hamefet bona zago buggisete. ");
INSERT INTO jnjl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ferisawini meya: «Ne nawoni meya beysani wonaasik zagtonak sholsunoyson awuniron zagsefeso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesus dey wolgire: «Dawitnawa barneen ane feese asusneen maktefena kabaasik awu zaginamato aane feretuwetinoso ");
INSERT INTO jnjl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiyatar maagni gaanynye meeni gaanynya sinne feena neyaasik Ha'oosi keer girire maagni meyaktano oonu muunak sholsunoy tushaason me. Estan barneen ane feese baassok dey imi» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Dey Yesus: «Beysani wona asuniktu testetano asu beysani wonnir sinne aane testowewa. ");
INSERT INTO jnjl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Es bari boor'a Asuni Naa beysani wonaasiknu daambaywa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Dey Yesus wolle Ayhudni shiiphoni keyaassi giri. Estak dey kushuba laafa asu feer. ");
INSERT INTO jnjl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Isa isa meya malatok chowa sholsefaat: «Han beysani wonaasik fatunitto biyaniwa» yire oodet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus dey kushuba laafa asusin: «Kabira hang ganeya yaara yerowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Estan asuni meyak: «Beysani wonaasik ma'aron zagungwa wedey mangunon zagunso; kaani fatungwa wedey worun; aaffarinso faqadteri makebbetiso?» yire mamsi. Sinuntano baasso shaakisete. ");
INSERT INTO jnjl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus nibbesiisi chimak haarefaat biratoosta feese asuni meyanon gi'ak biyaat asusin: «Kushuneeson zeephwa» yi. Bar dey zeephin kushubaas fari. ");
INSERT INTO jnjl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Estan Ferisawini meya geregere kesere Yesusnin aakkak worsonemato Herodisni keena sine baassoneen ane merkesete. ");
INSERT INTO jnjl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesus nawobaasneen ane Galiilani baariiski hami. Galiilani daastan yeese showo asuni meya orfobaase hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bar zagit feena wuzason zuutire odesefaat Yuudani daastan, Yerusalemni katamaassin, Edomiyasni daastan, Yordanosni akaasi yesalo fa daastan, Tirosuknawa Sidonunna asi katamaassi biratotan Yesusniki yeesete. ");
INSERT INTO jnjl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Daraasa showotan kabi chowa asuni meya tugsiset feeseter sinna boor'a goonu barik hoossusonek nawoni meyanon ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Showo asunin fatir sinna boor'a merobesi faana baasso zuuttere barin ta'ire farsonek tiir'siset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Asusasi fa kiina ayyana Yesusnin biyenaase sinba gandera: «Ne Ha'oni naawa» yit chaaget faaser. ");
INSERT INTO jnjl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kiina ayyanaasikitonon dey bar oo sinnamato maksonoynamato zaggire ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus aamaasta kesfaat bar shunna basakitonin teege. Basakito dey barki yeese. ");
INSERT INTO jnjl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Barneen ane foosonek; kaambaason maksonek wosunak; kiina ayyanaasikitonon asusasin kisusonek ha'suni hugnabesi foonak asire heppe asunin koraat: «Wosi» yire teege. ");
INSERT INTO jnjl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Es kortese asire heppe asusakito «Phexiros» yire sunsina Simon ");
INSERT INTO jnjl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","«Boanerges» uus dey «Dedoni naanggot» yire sunsina Zabdiyosni naanggot Yaqobnawa Yohannisna, ");
INSERT INTO jnjl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andriyas, Filiphoos, Bertelemewos, Maatiwos, Tomas, Ilfiyosni naa Yaqob, Tadewos, koonefe baassokin ye Simon, ");
INSERT INTO jnjl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yesusnin aatire ima Askorotki Yuuda. ");
INSERT INTO jnjl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Esseen orfo Yesus keer ye. Barneen nawoni meyaneen showo asuni meya hepsa dey zuuttesete boor'a muuni muuk aane chimoto. ");
INSERT INTO jnjl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","«Yesus nifasewa» yistefa wolla odesefaat koonni meya ephak yeesete. ");
INSERT INTO jnjl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yerusalemun yeese Museni tumaasi assinynyani meya: «Yesus Beelzebul basaassi faarwa! Kiina ayyanaasikitonon kisifenaas baron ha'sifa barikwa» yit wolumsete. ");
INSERT INTO jnjl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus baassotin barki teegere besok ekka yi: «Sexanaas aakkak Sexanaason kisuk chimnirinso? ");
INSERT INTO jnjl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Isa taatoos bare bare oor oor kesfaanane taatobaas zagira yerok aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Esiisimato isa keer fe asu oor oor kesfaanane zagire fook aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Es bari boor'a Sexanaas bare bare oor oor kesfaanane tishutu tishunatano aafa zagira yerona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Isa zag asuni keer girire zeemme es zag asusin ephphe taar'noy keebaassi fa foobaason bo'ok chimnir aafe. Taar'naneen orfotu bo'ok chimana. ");
INSERT INTO jnjl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Futo makefawungwa, asuni meya wostesefe boor'aasewa maksefe me'aase zuuttera feeshun ustona. ");
INSERT INTO jnjl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Sinuntano Korto Ayyanaasta mei'ni kaama maksefe baasso boor'aas koi'ba foonto kowatu sinanatano boor'besiis isanne aafa feeshun ustona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","« ‹Kiina ayyana basaassi faarwa› » yiset feeseter sinna boor'atu Yesus es baron make. ");
INSERT INTO jnjl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesusni intoosewa aybaasakitona yeesere gerakalo yersefaat barki wosisere teegsisete. ");
INSERT INTO jnjl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Es biratoosta diise asuni meya: «Ne intoosewa ayneesakitona gerok neen sholsediferwa» yire maksete. ");
INSERT INTO jnjl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesus wolgire: «Intona oonso? Aytaasakito oona oonanso?» yit wolgi. ");
INSERT INTO jnjl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Biratoosta diise baassoki biifet: «Ese intonaasewa aytaasakitona haniiswa: ");
INSERT INTO jnjl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ha'oosi fiqadinon zagsefe baasso zuuttere ayta, eetna, intonawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Hepsa wolle Yesus baarisi tesha daraasin assuk kabi. Akam showo asu barki esta yeesere zuuttesete boor'a Yesus goonuussi girire baariista di. Daraas zuuttere baarisi tesha feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Besok showo wuza baassok assi. Assifena kabaasik dey ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Odotiwa! Bukinynyaas meeni bukak kesi. ");
INSERT INTO jnjl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Bukfena kabaasik isa isaas ugnaasi ha'ta kere wor'i. Kasaas dey kephpha maase. ");
INSERT INTO jnjl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oomaas dey garo ho'ba faana kaa'oosta kere wor'i. Akama ho'a aafa sinna boor'a geregere kayi ");
INSERT INTO jnjl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sinuntano awa kesfana kabaasik aliqi. Tasbaas aane zaguwa sinna boor'a ichimi. ");
INSERT INTO jnjl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ooma zalaas dey seer'a faana daasta kere wor'i. Seer'aas kessa geer'na boor'a aane gaana. ");
INSERT INTO jnjl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oomaas ma'a buloosta kere wor'a bar kayira dichcha gaana gaani. Isaas keezasiron, isaas issunasiron, isaas tiyanon gaani.» ");
INSERT INTO jnjl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Estan dey Yesus: «Odoni odoba feenay odowowa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesusni tesha feese asuni meenawa asire heppe nawobaasakitona Yesus bar bar sinfena kabaasik: «Besok maketa chowaasi kota aambanso?» yire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Bar dey wolgire: «Nittok Ha'oosi taatoni aacho chowni aruus imte. Sinuntano nittoneen foonto oomni meyak zuuttambaase besoktu maktefawa. ");
INSERT INTO jnjl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Es bar dey: « ‹Baasso Ha'ooski wolseten boor'besiis feeshun ustonoynamato; aafbesiisik biifet aane yaadatesefe; odobesiisik odefet aane gasasisefewa› » yistenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Dey Yesus baassok ekka yi: «Han besoson nitto aane aruwetinoso? Eekan ooma besosikitonon zuutira aakkak aruk chimfetiso? ");
INSERT INTO jnjl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bukinynyaas kaambaasontu bukfe. ");
INSERT INTO jnjl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kaambaason buktefana kabaasik ugnaasi ha'ta kere wor'a bar kaambaason odesefe kabaasik geregere Sexana yaara es kaamaason nibbesiissin ephpha tishkifana asuni meyawa. ");
INSERT INTO jnjl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Esiisimato dey kaa'oosta bukte bar kaambaason odesefe kabaasik geregere girak ephpheteesefe baassowa. ");
INSERT INTO jnjl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sinuntano es kabaasiktano baassossi kaambaasi tasa aane zaguwa. Garo wonaneen orfo kaambaasi boor'a isa rakko wedey kabugto yaafana kabaasik geregere tuusa'sere gandesefe. ");
INSERT INTO jnjl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Seer'a faana daasta bukte bar dey kaambaason odefe baassotingwa. ");
INSERT INTO jnjl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Sinuntano han daastaki fooni chowaasi safara otumni keeshtanaasewa ooma ooma wuzni eenanto baasso nibaassi girira geer'fana boor'a gaana foonto fu'tesefe. ");
INSERT INTO jnjl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma'a ho'aasta bukte bar dey kaambaason odere ephpheteesefe asuni meyawa. Es baasso isaas keezasiron, isaas issunasiron, isaas tiyanon gaanefe.» ");
INSERT INTO jnjl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tusire dey: «Isa asu tona tonire waashshi wedey kuphoni sikalosi duusifewoso? Tega dimtatanoso duusifenari? ");
INSERT INTO jnjl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Es bari boor'a aachera ammanon kesnor uktera chaarefaasta kesnoy wuza aafawa. ");
INSERT INTO jnjl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ese odoni odoba feena bar odowowa.» ");
INSERT INTO jnjl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Dey Yesus ekka yi: «Han chowaasikitonon gasasira odotiwa! Nitto safarefeti safareesik wolla nittok safartera imtona. Es baristannu nittoosta dayister. ");
INSERT INTO jnjl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Feena barik dayistera imter. Sinuntano tishfaanane es barik fa barnu ootter.» ");
INSERT INTO jnjl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dey Yesus tusire ekka yi: «Ha'oosi taato buloostaki zala bukfe asune faar. ");
INSERT INTO jnjl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Asus waalin kunfe wonnanneen dey kabife. Aakkak sindifanamato arunoyfeen zalaas kayifa; dey dichfa. ");
INSERT INTO jnjl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Buloos dey teetbak zeemma kaygifa. Estan ke'oba kisifa. Fotira gaana gaanfa. ");
INSERT INTO jnjl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Meyaas katta kar'ni wona kar'nanneen asus magadak kar'a ephfe.» ");
INSERT INTO jnjl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ekka dey yi: «Ha'oosi taatonon awuneen hoossunirinso? Aro besok dey hoossira makonirinso? ");
INSERT INTO jnjl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Fi'fi'oni gaanane faarwa; bar dey buloosta buktefana kabaasik daasta fa zala zuuttambaase asiistan aterwa. ");
INSERT INTO jnjl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sinuntano buktera kayinanneen orfo gooru buktera kayi zala zuuttambaase asiistan arkir sinfa. Samaastaki kasaas waay'baassi keeba keer'a duunanneen inya inya waay'a kisifa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus asuni meya gasasire odok chimoneesne faaron effa showo besok kaambaason baassok maket feer. ");
INSERT INTO jnjl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bar assifena kabaasik beso foonto aane assuwe. Sinuntano baasso baasso sinefe kabaasik chowaason zuutire nawoni meyak kotte maket feer. ");
INSERT INTO jnjl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Es wono waalin Yesus nawoni meyak: «Han baarisi yesalo finaniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Daraasin estak beyfaat Yesus diina goonuussi girire barin ephphe hamete. Ooma goonuusikito dey barneen ane faaser. ");
INSERT INTO jnjl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Akama akani guuboosi ipuwa kabira akaas goonuussi tuumananneen ipuwaas goonuuson ichet faar. ");
INSERT INTO jnjl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Es kabaasik Yesus goonuusi orfosi bokta boktere kunfer. Nawoni meya barin guzgisere: «Assinynyano! Inno tishuus neen aane tiir'efanoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bar guzire ipuwaason ke'i. Baariison dey: «Beyya shaakku!» yi. Ipuwaas dey siru beyi. Akama naganu sini. ");
INSERT INTO jnjl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesus nawoni meyanon: «Awuniron ekka digedifetirinso? Hashneen amantonti aafanoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Akamanon digesere baassotna baassotna: «Eekan ipuwaasewa baariise ajajamenar han bar oonso?» yisesete. ");
INSERT INTO jnjl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Galiilani baariison goonuk finere yesalo Gergesenonki daasta kar'ete. ");
INSERT INTO jnjl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesus goonuussin kerobaase geregere kiina ayyana ephna asu shu'ni moogaassin kesse barik uphe. ");
INSERT INTO jnjl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Es asus dey moogni dimsitu feefe. Oonu barin bittani shashsharaknu taar'e duusuk aane chimfe. ");
INSERT INTO jnjl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Showo wona wochoni bittaknawa shashsharakna taatet feer. Sinuntano Shashsharaason buggitnawa bittaason kiir'etna feer. Barin merok oonu chimfer aafe. ");
INSERT INTO jnjl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wonna wonna toonawa waalinna shu'ni moogaastanawa kumaastana kutifaafe chaaget feer. Atubaason shu'ak buu'e mazasit feer. ");
INSERT INTO jnjl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kiina ayyanaas woksok Yesusni biinayse eella sinba kaa'nefaat. ");
INSERT INTO jnjl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tega kaamak: «Akamanon ulfinto Ha'oosi naa Yesusno! Taneen awune faarinso? Taan kiichunoytamato Ha'oosi sunak tewuwa!» yit chaagi. ");
INSERT INTO jnjl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Es baron yinaas Yesus: «Ne kiina ayyana han asusasin kes» yina boor'a. ");
INSERT INTO jnjl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesus dey: «Sunne oonso?» yire mamsi. Asus wolgire: «Inno showo sinni boor'a sunna Legewon» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Barikitonon daastan kalle kofkunoynamato chinire Yesusni shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Es daasta fa kumaasi tesha showo mukoni wodo keemtedifar. ");
INSERT INTO jnjl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","«Hamma mukoossi girunik innotin gafkuwa» yit shiiphse. ");
INSERT INTO jnjl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus dey hamma girunak maken kiina ayyanaasikito kessa mukoosikitosi giri. Hep kuma sinni muko kumaastan eelera baariissi girira kiti. ");
INSERT INTO jnjl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mukooson keemfe kezzoosakito eelere hamme katamaassinawa ke'eessina sina chowaason maksete. Asuni meya dey sina baron biyak kesete. ");
INSERT INTO jnjl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesusniki yeeseten es showo kiina ayyanaas ephna asus nibbaas wolin maya mayye diifen biyeteese digsete. ");
INSERT INTO jnjl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Es kiina ayyanaas ephna asusa chowanonnawa mukoosikitotana sina baron zuutire zeemme biya asuni meya es yeese baassok maksete. ");
INSERT INTO jnjl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Es kabaasik es daasta fe asuni meya Yesus daabesiistan kesse hamanak shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus goonuussi girifena kabaasik kiina ayyanaas basaassin kesna asus: «Neneen ane hamanawa» yit shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sinuntano Yesus aane ma'i uwe. Asusik wolgire: «Keene wolla hamfaat keerki asuni meyak Daamiis neek awune fa akama wuza zaginamatonawa aakkak neek kenashtenamatona makowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Asus dey Yesus barik zagina chowaason: «Asir katama» yistefa daasta hamme awasi. Ode baasso zuuttere diinqeset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus dey goonuk yesalo hepsa wolle finfena kabaasik showo asu baarisi tesha barki esta zuuttere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ayhudni shiiphoni keyaasi gaanynyaasasin Yayiros yiste isa asu yeere Yesusnin biinayse wochobaassi kaa'nere: ");
INSERT INTO jnjl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","«Ate naanaas akamanon mettera kituna agaat kunirwa. Farira kaak foonak yaara kushuneeson barista ta'uwa» yire chinire shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesus dey barneen ane hami. Showo asu orfobaase tiir'sisedifer. ");
INSERT INTO jnjl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Asire heppe neya harinba wuuktet faana isa asu faar. ");
INSERT INTO jnjl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Showo etni asuniki hamfaafa akamanon rakkatet waagbaason dey koi'sit faar. Sinuntano merobaas arkittu hamitano faruk aane chima. ");
INSERT INTO jnjl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Bar Yesusni chowaason odera faar sinna boor'a asusa ganesi orfo kamo yaara maambaason ta'i. ");
INSERT INTO jnjl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Es baron zaginaas: «Maambaasta ta'ifaanane farunawa» yira faar. ");
INSERT INTO jnjl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Es wuuktet fa harinbaas geregere yere. Merobaassin farinamato atubaastak ari. ");
INSERT INTO jnjl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus dey geregere basaassin hugna kesnamato araat daraasa ganesi yerqere «Maamnaasta ta'is oonso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nawoni meya wolgire: «Daraas tiir'sisefeen biifat: ‹Oonso taan ta'iri› yifatoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sinuntano Yesus es baron zagiis oo sinnamato aruk yerqere bi. ");
INSERT INTO jnjl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Estan asus barik zagte baron arina boor'a digera korkit yaara sinba kaa'nera futooson zuutira make. ");
INSERT INTO jnjl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bar dey: «Naanaase! Amantonees neen fatiwe. Maar'on hamme; meroneessin faruwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesus es baron makefena kabaasik Ayhudni shiiphoni keyaasi gaanynya Yayirosni keerun yeese asuni meya barik: «Naanees kitiwa. Hash awuniron assinynyaasin hopsifasso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sinuntano Yesus es baron odefet Ayhudni shiiphoni keyaasi gaanynyanin: «Amanotano digotaatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesus dey Phexirosneen, Yaqobneen, Yaqobni ay Yohannisneentano oom asu barneen ane hamanak aane ma'i uwe. ");
INSERT INTO jnjl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ayhudni shiiphoni keyaasi gaanynyaasa keer yeere kar'fena kabaasik asuni meya sasetnawa waasitna chaaga aatamsisefeen bi. ");
INSERT INTO jnjl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Keer girire: «Awuni boor'a saset waasidifetirinso? Nawaas afay'totu afay'tetano aane kituwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Asuni meya dey kanyni mi'a mi'esete. Sinuntano Yesus baassotin zuutire keerun kalle kisaat nawaasi abaninnawa intononna dey barneen ane feese baassotin zoonsire nawa faanaassi giri. ");
INSERT INTO jnjl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nawaasi kushunon dey zatte: «Xalita kum!» yi. Es kaamaasi kota dey: «Garo nawaase kabuwe yifawungwe» uu. ");
INSERT INTO jnjl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bar dey geregere kabira ek hang kuti. Woggabaas dey asire heppe sinana. Es bar sinfana kabaasik asuni meya akamanon diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sinuntano Yesus: «Sina chowaason oonu arunaata» yire baassok ajajefaat dey: «Nawaas muuna muu imti» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus estan kesse daabaasta ye. Nawoni meya orfobaase hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Beysani wonaasik Ayhudni shiiphoni keyaassi assu ephi. Showo asuni meya odesere diinqeset ekka yisete: «Han asus han wuzason zuutire ayin daniso? Aro arunso han barik imteri? Han biistera artonoy wuzasikitonon zagifenaas aakkakinso? ");
INSERT INTO jnjl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Haniis i'o kar'fe Maaramini naastenoso? Yaqobni, Yosani, Yuudanawa Simonna asi ayistenoso? Eetbaasikitonu han innoneen anetanoso faasenari?» Esiison yiset ephphetoo beyesete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sinuntano Yesus: «Raajju daabaastak, koonbaasa ganesinawa keer ane feena asusa ganesitano oom geroni asusa sinak ulfintowa» yire make. ");
INSERT INTO jnjl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Estak dey garo mettanni meenistatu kushubaason ta'ire fatiteno ooma biistera artonoy wuza aane zaguk chime. ");
INSERT INTO jnjl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Daraas amano beyobesiisik diinqe. Estan Yesus ke'e ke'eessi kutifaafe assit feer. ");
INSERT INTO jnjl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Asire heppe nawobaasakitonin hang barki teegere hep hep zagire wosi. Kiina ayyanaasikitota ha'suni hugna imi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Estan ekka yire ajaje: «Hamati ugunnitiisik haarotano tusha wedey ha'mato wedey tach'amaasta birri koor'ira ephatiita. ");
INSERT INTO jnjl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Wochontiissi chaa'ma yer'titano hep maama ephatiita. ");
INSERT INTO jnjl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Isa asuni keer girifeti kabaasik es katamaassin kesatinneen esta footi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Asuni meya nittotin ephphetooknawa odokna beyete dimaasta wochontiisi tulonon tebaat essin kessa hamti. Es bar dey baassosta zaala sinana.» ");
INSERT INTO jnjl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Estan es wostere hama baasso dey kesere asuni meyak: «Boor'nitiison harmira Ha'ooski woluti» yit assisete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Showo kiina ayyana asunisin kissete. Showo mettannin dey zayiti muudfaafe fatisete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesusni sunaas artera faar sinna boor'a taato Herodis basa chowaason ode. Isa isa meya: «Haphqife Yohannis kitun kabi. Es bari boor'a biistera artonoy wuza barik zagtedifar» yiset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Oomiis dey: «Eliyaswa» yisete; isakadiis dey: «Zeemoti raajjuni meyaassin isaasamatowa» yiset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sinuntano Herodis odere: «Han bar ta suutbaason katina Haphqife Yohanniswa. Ese bartu kitun kabirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herodis ayba Filiphosni asu sina Herodiyadanon asu zagire ephi. Haphqife Yohannis Herodisnin: «Ayneesa asunon ephatak neek aane sholsifawa» yire make. Es bari boor'a wosire Haphqife Yohannisnin ootire taatoni keer taati. ");
INSERT INTO jnjl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Herodis Haphqife Yohannis ooko dey korto asu sinnamatona arir sinna boor'a digerenawa oodetna feer. Herodis basa wollaason odena odena faadaasik nayettu feefe. Sinuntano giraktu odefe. Es bari boor'a Herodiyas Haphqife Yohannisnin es makena wuzaasik haarera woruk sholefanaknu aane chima. ");
INSERT INTO jnjl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodis koontena wonaason ulfinsuk daason ha'sife baassok; taar'oni gaanynyaniknawa arto Galiilaki meyakna akama koota koote. Es bar dey Herodiya sholefana ma'a wona sini. ");
INSERT INTO jnjl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodiyadani nawa kootaas maastefana keyaassi girira baasso sina surit eresira Herodisninnawa barneen ane feese baassotinna girsi. Taatoos dey nawaason: «Ne sholeta wuza awunu sinun taan mamsuwe imanawe» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hepsa dey: «Taatonaasi isa kununonnu sinfanak mamsita baron zuutira neek imanawe» yire teyi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bar dey intobaaski hamma: «Awu mamsunaasse» yi. Intobaas dey: «‹Haphqife Yohannisni teetaason› yira mamsuwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nawaas dey geregere taatoski wolla hamma: «Haphqife Yohannisni teetaason han koranaassi gedtera hash taak imtonak sholefaungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Taatoos es mamsina mamsusik akamanon suume. Sinuntano zeemme teyina boor'a muu muusonek teegte asuni meeni sina nawaasik kalanak aane sholowe. ");
INSERT INTO jnjl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Geregere taatoos oodfe taar'osasin isarin Yohannisni suutaason kar'e teshshonak wosi. Taar'oos dey hamme taatoni keyaassin suutbaason kar'i. ");
INSERT INTO jnjl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kar'na teetaason koranaassi gedde teshshosi nawaasik imin nawaas dey intobaasik imi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohannisni nawoosakito es baron odeseteyse yeesere dugnobaason ephphe kabbarsete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wosini meya wostere hameteessin wolle yeesere Yesusniki sina zuuttesete. Zagsete baronnawa assisete baronna zuutire barik maksete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Baassoki yeefernawa wolle hamfe asuna showo sinna boor'a muuni muuknu sa'ati aane danoto. Es bari boor'a Yesus: «Nitto nitto isa shaato dimsi hamfaat garo wona beysa ephtiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Estan baasso baasso goonuusi diisere isa shaato dimsi hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sinuntano hamefeen asuni meya biyere baasso sinobesiison arsete. Estan katama katamaassin kesere wochok eelere baasso kar'ono feeseten zeemme hamme baasso kersoneesta zuuttesete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus goonuussin kerefena kabaasik showo asuni biire kezzoba foonto fantune feeseter sinobesiisik suume. Estan showo wuza baassotin assuk kabi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Geroki dimaas waalet hambaase nawobaasakito Yesusniki tai'sesere: «Han faani dimaas zabowa; gerok dey waaldifar; ");
INSERT INTO jnjl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Han asuni meya muusone wuza aafa sinna boor'a biratoosta fa beedeessinawa ke'eessina hamere muubesi waagsonek geggessuwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sinuntano bar wolgire: «Baasso muusone muuson nitto imtiwa» yi. Baasso dey: «Eekan inno hamma hep tiya diinari zuutira kisira waagera imaniroso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesus: «Apun tushanso faari? Hamma biyebbetiso» yi. Baasso dey biyere: «Uuch muuma tushnewa hep qurxumminetu faarwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesus dey daraasi chiro kuwaasta bag bagge duussonek ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Estan tiya tiyanawa uuchasir uuchasirna sinefaafe madadak diisete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesus dey ukkoti uuch muuma tushaasewa hep qurxummiise ephphe den sama biire Ha'o galattefaat tushaason batte daraasik woshonek nawobaasakitonik imi. Esiisimato hep qurxummiison imin zuuttambesiise asik haa'esete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Zuuttambesiise meesere gawsete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nawoosakito dey fu'te batto tushaasewa qurxummiise asin asire heppe masa tuumanon zuutisete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tushaason me arqasusa faada uuch kum sinana. ");
INSERT INTO jnjl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesus geregere daraasin geggesifet nawobaasakitonin goonuussi diisere yesalo Betesayida finere zeemme hamonek ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Esseen orfo Yesus baassostan oor kesse Ha'o shiiphonak aamaasta kesi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Waalfana kabaasik goonuus baarisi ganetatu fa. Es kabaasik Yesus bar bar daastatu fe. ");
INSERT INTO jnjl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nawobaasakito siru baasso sinaasta siridifar sinna boor'a akaason ichche finak rakkassefeen bi. Wassi izgin sa'atin hamma asire heppe sa'atineen fa kabaassi baariista kutit hang baassoki ye. Baassotinnu aatte hamana kaba. ");
INSERT INTO jnjl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sinuntano baasso baariista kutit hamfeen biyesefaat: «Kitawa» yisefaat chaagete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Zuuttambesiise biyaat naysete. Yesus dey geregere: «Harewa! Tawa! Digotiitawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Goonuussi girire baassoneen ane duubaase sirus beyya yere. Es bari boor'a nawoosakito akamanon diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nibbesiis yaadato beyya faar sinna boor'a zeemmati zagte biistera artonoy tushaasi chowanon aane arsoto. ");
INSERT INTO jnjl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Baariison finere Gensaret yiste daasta kar'ete. Goonuuson ek daasta tai'sire taar'e yeetisete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Goonuussin kersefe kabaasik asuni meya geregere Yesusnin arsete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Es daa zuuttambaase asi biratoosta ek hang eelefaafe Yesus feenaasta mettanni meyanon oppota wor'e teshshesete. ");
INSERT INTO jnjl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bar hamna hamna dima zuuttambaase asi ke'eessi, katamaassi, beedeessi feese mettanni meyanon ek yaboosta ephetaafe teshsho maybaasi fashanonne ta'usonek shiiphset feeseter. Ta'i baassonu zuuttere farset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ferisawini meenawa Yerusalemun yeese isa isa Museni tumaasi assinynyaasna Yesusniki yeesere zuuttesete. ");
INSERT INTO jnjl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesusni nawoosasin isa isaas tumaasimato mastera kayimnoy kushuk muu meesefeen biyete. Kayimnoy uus mastonoy kushu uu. ");
INSERT INTO jnjl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ferisawini meenawa oom Ayhudni meena kur'uni meeni tumaason oodak kushubesiison maso shaksefaatene aane meesefe. ");
INSERT INTO jnjl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Esiisimato dey gaban wolsefe kabaasik masonoy aane meesefe. Tuwooson, gimaason, bittak wosuste kodaason, masane fa ooma ooma tumasonneen oodettu feesefe. ");
INSERT INTO jnjl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Es bari boor'a Ferisawini meenawa Museni tumaasi assinynyaasna: «Eekin ne nawoosakito kur'uni meeni tumaason beyefaat awuni boor'a kushubesiison masonoy muu meesefeso» yit Yesusnin mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sinuntano bar wolgire ekka yi: «Nitto sinnoy sinne bestefe asuwa; raajju Isayyas nitto chowaasik makefena kabaasik: « ‹Han daraas noonoba noonobaasiktu taan ulfinsifeteno; nibbaas tayistan akamanon wokawa. ");
INSERT INTO jnjl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Asu tumena tumaason; Ha'onir zagsere assisefaafe; shimaasiktu taan ulfinsifewa› yire makena bar futowa. ");
INSERT INTO jnjl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«Nitto Ha'oosi ajajinon beyefaat asuni tumatu oodefetiwa.» ");
INSERT INTO jnjl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Dey Yesus tusire: «Nitto tumaason oodakwa iyaat Ha'oosi tumanon beyati ma'a ugunniti faarwa. ");
INSERT INTO jnjl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muse: ‹Abanesinnawa intoneesonna ulfinsuwa› Dey: ‹Ababaasin wedey intobaason me'a bar wortonak sholsifa› yifa. ");
INSERT INTO jnjl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sinuntano nitto ‹Isa asu ababaasin wedey intobaason argasuna wuzba faafaananenawa es baron dey: «Han bar Ha'oosik imna imawa» iyaanane; ");
INSERT INTO jnjl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ababaasiknawa intobaasikna argasu beyak chimanawa› yisefeti. ");
INSERT INTO jnjl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Esiisik teetnitiisi tumanon oodak Ha'oosi kaamanon shaarefeti. Dey effa effa showo wuza zagsefeti.» ");
INSERT INTO jnjl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesus dey daraasin hepsa barki teegere: «Zuuttamnitiise gasasira taakin odotiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Asuni kiinsifaas asunisin kesfa bartano geron asunisi girifa bar aane kiinsifawa. ");
INSERT INTO jnjl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ese odoni odoba feena bar odowowa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus daraasin beyfaat keer hamfena kabaasik nawobaasakito besosi kotanon mamussete ");
INSERT INTO jnjl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Bar dey baassok wolgire: «Nitto dey aane gazguwetinoso? Geron asuni katasi girifa bar isanne asunin aane kiinsifa sinnamato aane aruwetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kataassi girifa bar gerotu kesfatano nibaassi aane girifawa» yi. Ekka ubaasik Yesus muu zuuttera kayma sinbaason make. ");
INSERT INTO jnjl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tusire dey: «Asunin kiinsifaas asusa nibsin kesfa wuzasikitowa. ");
INSERT INTO jnjl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Es bar dey mangunon safaro, soolo, wiiso, asuni woru; ");
INSERT INTO jnjl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Gerkesa, jooro, mangu, esha, gafo, koona, hamato, beeganto, gironata uwa. ");
INSERT INTO jnjl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Es mangu wuzaasikito zuuttera asuni nibsintu kesfa. Asunin dey kiinsifa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesus estan kabire Tirosni katamaasi tesha fa ke'eessi hami. Esta isa keer girire foobaason oonu arunoynamato shole. Sinuntano aachok aane chime. ");
INSERT INTO jnjl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Garo nawubaason kiina ayyana ephna isa mashkasu Yesusni chowaason odefaat geregere yaara wochobaassi sagade. ");
INSERT INTO jnjl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Asus Sirofiniqawini meeni keena sina Girikni kaamatu wollefa. Bar dey nawubaassin kiina ayyanaason kisunak Yesusni shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sinuntano Yesus: «Naanggotaasi muunon ephphe kanak ha'u ma'arta. Shakaani naanggotaas zeemma maara gawun» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Asus wolgira: «Futowa Daamtaaso! Kanaasikitonu sillawoosi sikalosi faafaattu naanggotaas maafana kabaasik zigifa fufuntooson maafawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Es bari boor'a Yesus barik: «Ekka makoneesik kiina ayyanaas naaneessin kesiwe; maar'o hamme» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Asus dey keeba wolla hamma kar'in kiina ayyanaas kesfaan nawaas farira kuphoosta kunfeen dani. ");
INSERT INTO jnjl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Estan Yesus Xirosun kesse Sidon kamo aatte asir katama yistefa daastak Galiilani baariiski ye. ");
INSERT INTO jnjl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Estak isa odoba oyonawa babula asuna asin asuni meya Yesusniki ephphe yeesete. Kushubaason dey basaasta ta'unak shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus asusin daraasatan bar barin oor kisire kushubaasi waa'ak odobaassi gedaat tuja tujere asusa termanon tapti. ");
INSERT INTO jnjl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Den sama kaanne biyaat sikalere safarere «Eefta» yi. Kotbaas dey «gachcho» uu. ");
INSERT INTO jnjl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Geregere odobaas gachche. Terumbaas dey kotte. Isa tuusa'o foontonon mai'sire wolle. ");
INSERT INTO jnjl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesus: «Han baron ooknu makotiita» yire ephphe ye baassok ajaje. Sinuntano baasso makotiita yina baron beyfaat arkissire wolumsesete. ");
INSERT INTO jnjl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Asuni meya akamanon diinqok: «Zuuttambaase asin ma'ar zagiwa. Odo oyoni meya odosonek; nibtaatoni meya wolumsonek zagi!» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Es wonaassik showo dara hepsa dey zuutte. Muusone muu aafa sinna boor'a Yesus nawoni meyanon barki teegere: ");
INSERT INTO jnjl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Daraas hawung keez wona kar'e taneen anetu feesete. Muubesi aafa sinna boor'a baassok safarefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Baassossin isa isaas woka daan yeeseter sinna boor'a afur keebesi gafkaanane ugunta gooda taateseterwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nawobaasakito dey: «Han zaboossi asu ayin tusha danna han effetena daraasin maasuk chimnirinso?» yire wolugsete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus: «Nittoki apun tushanso faari?» yire mamsi. Baasso dey: «Naafun tushatu faarwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Daraasin daasta duussonek ajaje. Estan naafun muuma tushaason ephphe Ha'o galattefaat batte woshonek nawobaasakitonik imi. Baasso dey daraasik woshete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Baassoki garo qurxummi faar. Es barik Ha'ooson galattefaat woshonek nawobaasakitonin ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nawoosakito dey asuni meya meesere gawseten fu'te battooson inya inya naafun masa tuumanon zuutisete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tushaason meese asuni meya acheech kum sinone. Estan geggessi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Esseen orfo nawobaasakitoneen goonuussi diisere Dalmanuta yistefa daasta hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ferisawini meya Yesusniki yeesere barneen karakkaro ephete. Fattanok sholsefaat biistera artonoy wuza saman besunak mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Basa teetaasik akamanon sikalere safarefaat: «Han koontoos awuni boor'a biistera artonoy wuza sholefaso? Futoktu makefawungwa, han koontoosik isa biistera artonoy wuza aafa imtona wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ferisawini meyanon beyfaat hepsi wolle goonuussi diire yesalo fini. ");
INSERT INTO jnjl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nawobaasakito tusha ephphe hama daagsete boor'a goonuussi fayiis isa tushatano ooma aafa. ");
INSERT INTO jnjl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus baassotin: «Ferisawini meenawa Herodisna asi masoossin teetnitiison oodtiwa» yire ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Baassotna baassotna: «Innoki tusha aafa sinna boor'awa» yit wolumsete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus es baasso safaraason arifaat: « ‹Tusha innoki aafa sinna boor'awa› yit nittotna nittotna awuniron wolumsedifetirinso? Hashneen aane gazguwetinoso? Aane aruwetinoso? Nibnitiis yaadato beyiyoso? ");
INSERT INTO jnjl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Aafniti feen aane bifetinoso? Odonti feen aane odefetinoso? Nibnitiissi aane kar'fanoso? ");
INSERT INTO jnjl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Uuch muuma tushaason uuch kum asusik batfana kabaasik fu'te battooson apun masa kabugsetiso?» yi. Baasso dey: «Asire heppe» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Dey «Naafun muuma tushaason acheech kum asunik batfana kabaasik fu'te battooson apun masa kabugsetiso?» Baasso dey: «Naafun» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bar dey: «Hashnu aane aruwetinoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betesayida kar'efe kabaasik asuni meya isa aaftishunin ephphe yeesere Yesus taptunak dey shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bar dey aaftishuusi kushubaassi zatte ke'eessin gerakalo kisire aaffaassi tujfaat kushubaasik ta'ire: «Isa biidifata wuza faaroso?» yire mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aaftishuus den kaanne: «Asusakito kutit yere i'onimato kutisedifeen biidifawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hepsa Yesus kushubaason aaffaasta ta'i. Estan asus mai'sire bi. Farire woksokneen fa wuzason zuutire mai'sire bi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Estan Yesus asusin keeba gafkaat: «Ke'eessi girutaata» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesusnawa nawobaasakitona Kesariyani Filiphoos yistefa katamaasi tesha fa ke'esikitosi hamete. Ugnaastak: «Asuni meya ta oo sinnamato maksefeso?» yire nawobaasakitonin mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Baasso dey wolgire: «Isa isaas Haphqife Yohanniswa; oomiis dey Eliyaswa; oomiis dey raajjusasin isaaswa» yiretu maksefewa. ");
INSERT INTO jnjl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","«Eekan nittoke; taan oo yifetiso?» yire mamsi. Phexiros wolgire: «Ne Kiristooswa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesus baassok: «Ta chowaason ooniknu makotiita» yire ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesus nawoni meyak ekka yit assu ephi: «Asuni Naa akama shana ephphetoonak sholsifawa. Kur'uni meeni sinak, maagni gaanynyani sinak, Museni tumaasi assinynyani meeni sinak kashistonir dey wortonir. Sinuntano keez wonaneen orfo kitun kabunir.» ");
INSERT INTO jnjl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Es baron dey ammanon baassok make. Es kabaasik Phexiros Yesusnin oor ephphe: «Ekka utaatawa» yit ke'i. ");
INSERT INTO jnjl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sinuntano Yesus nawobaasakitoniki yerqere biyaat Phexirosnin ekka yire ke'i: «Ne Sexana, asusarontano Ha'oosiron aane safarefe sinna boor'a haak orfona hamma.» ");
INSERT INTO jnjl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Estan Yesus daraasin nawobaasakitoneen ane teegere ekka yi: «Taneen ane hamak shole bar basa teetni safaraason beyowa. Basaasta kar'ni masqalini shanaason wor'e taneen ane hamowa. ");
INSERT INTO jnjl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kaabaason fu'ok sholefe bar zuuttere turkuna. Taaknawa misirachchuni kaamaasikna iyaat kaabaason turki bar zuuttere fatuna. ");
INSERT INTO jnjl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Asu han daastaki fa wuzason zuutire danfaat kaabaason turkifaanane barik awu ke'nirinso? ");
INSERT INTO jnjl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Asu kaabaason furok aro waaga kaasunirinso? ");
INSERT INTO jnjl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Han amanonoynawa boor'bare yere koontoosi ganesi taaknawa ta kaamaasikna iichchefe bar zuuttambaase Asuni Naa Ababaasa ulfinak korto wosiyaasneen ane yeefena kabaasik barik iichchona.» ");
INSERT INTO jnjl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Dey Yesus: «Futo nittok makefawungwa; Hanta yerse asuni meyaassin Ha'oosi taato akama hugnak yaafeen biinoyfeegedo kitusonor isa isar feeseterwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Issun wonaneen orfo Yesus Phexirosnin Yaqobninnawa Yohannisninna den tega aamaasta baasso baassotin ephphe kesi. Estak baasso sinaasta gitobaas soolte. ");
INSERT INTO jnjl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Maybaas dey palpalira fore. Han daastaki maama mei'fe bar oonu kaynuk chimnoynarne faar sinna akamanon fore. ");
INSERT INTO jnjl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Estan Eliyasnawa Musena Yesusneen ane wolumsefeen biyete. ");
INSERT INTO jnjl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phexiros Yesusnik: «Assinynyano! Hanta fooniis innok ma'arwa. Isaron neek isaron Musenik isaron Eliyasnik keez hafo keer'aniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Akamanon digesete boor'a Phexiros makefena wuzasonnu aane aruwe. ");
INSERT INTO jnjl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Shaaru yaara baassotin yinin es shaaruussi: «Keeshtefana Naataas hanifewa! Barin odotiwa!» yifa kaama odte. ");
INSERT INTO jnjl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Geregere yerqere biyeten Yesus bar barteno baassoneen oom ooninnu aane biyoto. ");
INSERT INTO jnjl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aamaastan kersefe kabaasik Yesus: «Asuni Naa kitun kabunanneen han biyeti baron ooniknu maksotiitawa» yire ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Basa kaamaason nibbesiissi ephefaat: «Kitun kabu uus aambanso?» yiset baassotna baassotna wolumsete. ");
INSERT INTO jnjl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Baasso dey: «Museni tumaasi assinynyani meya awuni boor'a ‹Eeliyas zeemme yoonak sholsifa yisefeso?› » yit barin mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bar dey wolgire: «Aa; Eeliyas zeemme yeere zuuttambaase asin zeep'ana. Sinuntano Asuni Naa akama shanaason ephphetoonamatonawa kashistonamatona tichchenaas awuni boor'anso? ");
INSERT INTO jnjl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sinuntano nittok makefawungwa: ‹Eeliyas dey yewa. Barik tichchenaasimato sholseteeson zuutire basaasta zagsete› » yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ukkoti fu'te nawoni meyaki wolsere yeesefe kabaasik showo dara baasso biratoosta zuuttere feeseten Museni tumaasi assinynyani meya dey baassoneen we'nisefeen bi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Geregere daraas zuuttere Yesusni biyeteese diinqesete. Barki eelle naga ooshshesete. ");
INSERT INTO jnjl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus dey baassok: «Aro wuzanson baassoneen karakkarsedifetiri?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Daraasasin isa asu wolgire: «Assinynyano! Niba taar'a ayyana ephna naataasin neeki teshshengwa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kabfana kabaasik ephphatu ha'ifa; noonobaassi gusa kar'ettu ay'baaso koyfe; dey kongsir; kissonek ne nawoosakitonik makena aane chimoto» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesus wolgire: «Amanonoy koonto aageneen nittoneen ane foonarinso? Aageneen nittotin fakunarinso? Hang taaki teshshotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Baasso dey naasin barki tessheseten barin biinayse kiina ayyanaas geregere naasin gansira tookonak zagira gusa kar'et daasta bukale. ");
INSERT INTO jnjl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesus naasa abanin: «Han bar ephnanneen apun neyanso?» yire mamsi. Asus dey wolgire: «Daagbaaseneengwa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Showo wona tishkunak geyaassinawa akasina gedar. Neek chimtefaanane innok kenashtowa; dey argasuwa» yit shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus dey: «Chimfaatane yifatoso? Amanefe barik zuuttambaase chimterwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Geregere naasa aba: «Amanefawungwa! Amanoni hopinaason argasuwa» yit chaagi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus dey daraas kuytet yoobaason biyaat kiina ayyanaason: «Ne niba taato; odo oyo ayyanaas naasasin kes! Hepsi wolla girunoytamato ajajefan!» yire ke'i. ");
INSERT INTO jnjl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Naas akamanon tookonak zagira chaagga kesi. Showobesiis: «Kiti» usonenneen dugnone feer sini. ");
INSERT INTO jnjl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sinuntano Yesus kushubaassi zatte kabgin yere. ");
INSERT INTO jnjl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesus keer girinanneen orfo nawobaasakito: «Inno kisuk hopiniis awuni boor'anso?» yire bar barin mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","«Han effaas soomoknawa shiiphokna sina shakaanane isanne kesak aafa chimanawuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Estan kesere Galiila kamo aatte hamete. Yesus nawoni meyak assit feer sinna boor'a bar feena dimaason oonu arunak aane sholowe. Ekka dey yi: «Asuni Naa asuni meeni kushusi aattere imtok wortere keezsinari wono kitun kabunir.» ");
INSERT INTO jnjl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Es chowaas baassok aane galowa. Barin mamsuk dey digsete. ");
INSERT INTO jnjl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesusnawa nawobaasakitona Kifirnahom yeesete. Keer girsetenneen orfo: «Nittotna nittotna ugnaasta aambanso wolumsetiri?» yire baassotin mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sinuntano baasso ugunne hamefet: «Zuuttambaase asiisatan arkir oo sinungeso?» yisere wolumsete boor'a shaakkisete. ");
INSERT INTO jnjl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesus dey diifaat asire heppeesin barki teegere «sina zeemak sholefe bar zuuttambaase asi orfo sino; dey zuuttambaase asi wostinynya sinanak sholsifa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Isa daaga nawa teshshere ganebesiissi yeetaat idimme: ");
INSERT INTO jnjl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Haniisne fa daaga naanggotaassin isaason ta sunaasik irba zagire ephpheteefe bar zuuttambaase taan ephphetoonawa. Taan ephpheteefe bar dey zuuttere taan wosi barintu ephpheteeteno taantawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohannis Yesusnik: «Assinynyano! Isa asu ne sunaasik kiina ayyanaason kisifeen biyaat innoneen ane sina beyna boor'a kalniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sinuntano Yesus: «Ta sunaasik biistera artonoy wuza wostefaat geregere tayista mangu kaama wollok chimnir aafe sinna boor'a kalatiitawa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Innotin tugga'onoy bar innoneen anewa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Futo nittok makefawungwa; Kiristoosnir sinti boor'a ta sunaasik isa toofo aka nittok ima bar waagba aafa tishuna wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tusire dey: «Han taak amanefa garo garo naanggotaassin isaason tuusa'sife bar zuuttere faya wooni shu'a suutbaasta taatera tir'maassi ha'tefaanane ma'ana kabawa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kushunees tuusa'saanane kar'a ha'uwa. Hep kushune faafaan geeni tir'maassi ha'toostan kushu dungu sinna kaani keer giru ma'arwa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Geeni tir'maas toobaas kitunoynar; geebaas tishunoynarwa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Wochonees tuusa'saanane kar'a ha'uwa. Hep wochone faafaan geeni tir'maassi ha'toostan wocho foonto sinna kaani keer giru ma'arwa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Geeni tir'maas toobaas kitunoynar; geebaas tishunoynarwa ");
INSERT INTO jnjl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aafnees tuusa'saanane wo'ira kisuwa. Hep aafne faafaan geeni tir'maassi ha'toneesneen isa aafne faafaan kaani keer giru ma'arwa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Geeni tir'maas toobaas kitunoynar geebaas dey tishunoynarwa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Maa'a zuuttambaase kawok mochera kayimfanaysimato asu dey zuuttere geyak kaymanak sholsifa. ");
INSERT INTO jnjl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Kawo ma'arwa; sinuntano kawo kaar'ba foonto sinfaanane awuk kaatutirinso? Kaantiissi kawoni kaar'a foongwa. Nittotna nittotna isa safarak footi» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus estan kabire Yordanosnon finne Yuudaki daasta hami. Showo asu barki esta hepsa zuutteseten zeemoti zagifenaysimato assit feer. ");
INSERT INTO jnjl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Isa isa Ferisawini meya yeesere barin fattanok: «Asu asubaason gafkunak tumaas makewoso?» yire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus dey wolgire: «Muse nittok aambanso ajajenari?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Baasso dey: «Muse gafkuni tichaason imme gafkunak makewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus wolgire: «Nitto nibaasi chimaktu es ajajiison tichiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sinuntano ‹Ha'o testoosi tesuta arqarnawa mashkare zagiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Es bari boor'a asu ababaasinnawa intobaasonna beyye asubaasneen isar sinfe. ");
INSERT INTO jnjl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Hepobesiise isa atutu sinone›. Es bari boor'a baasso isa atutano hanneen ekalo heptewa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ha'o isar zagina baron ese asu oor kisunaatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Keer girsetenneen orfo nawobaasakito hepsa es chowaason kabugsere mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus dey: «Asubaason gafkaat ooma asu ephfe bar asubaasta gerkesiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Asus dey teegobaaskin kessa oomniki girifaanane gerkesiwa» yit wolgi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yesus garo garo naanggotaason taptunak asuni meya barki teshshesete. Es teshshe baassotin dey nawobaasakito kalesete. ");
INSERT INTO jnjl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sinuntano Yesus biyaat gi'tere: «Garo garo naanggotaas taaki yooson; beyti kalatiita. Ha'oosi taato han barikitone fayisirwa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Futo nittok makefawungwa; Ha'oosi taatonon daaga nawane faaron zagire ephphetoonoy bar isanne aafawa giruna wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Idimme kushubaasik ta'ire suusi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus ugna hamanak kesfeen isa asu barki eelle yeere sinba kaa'nefaat: «Garam assinynyano! Koi'ba foonto kaa dananak awu zagunarinso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus wolgire ekka yi: «Awuniron taan garam yifasso? Isa Ha'oosneen ooma garama aafawa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ajajiis dey: ‹Kaa worutaata, gerkesataata, wiisotaata, esha zaala makotaata, asunin eshataata, abanesinnawa intoneesonna asin ulfinsu› yifanamato aritarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Asus wolgire: «Assinynyano! Es baron zuutira garonaaseneen ooddatu fawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus biire keeshte; dey ekka yi: «Isa wuzatu neekin yo'irwa. Hamfaat fa otumneeson zuutira kisira waagaat tukamni meyak imma. Den samak otma danatawa. Eekaat yeen taneen ane hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sinuntano es chowaasik sinbaas karaye. Akama otumba faar sinna boor'a suumet hami. ");
INSERT INTO jnjl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus yerqere biyaat nawoni meyak: «Otumbesi faana baassok Ha'oosi taatosi giru awune faaron tiir'onso!» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nawoni meya es makena kaamaasik diinqesete. Sinuntano Yesus tusire: «Naanggotno! Ha'oosi taatosi giru awune fa tiir'onso! ");
INSERT INTO jnjl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Otum asu Ha'oosi taatosi girubaastan gaala marufni aafsi kamo aatbaastu kashowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nawoni meya zeemotiistan akamanon diinqesefaat baassotna baassotna: «Esenu oo faruk chimnirinso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus baassotin biyaat: «Futoosik han bar asunik aafa chimtona wuza. Sinuntano Ha'oosik chimter. Ha'oosik zuuttambaase chimterwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Phexiros dey: «Esenu inno zuuttambaase beyya neneen ane yaaniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus wolgire: «Futok nittok makefawungwa; taaknawa misirachchuni kaamaasikna keebaason wedey aybaasakitonin wedey eetbaasikitonon wedey intobaason wedey ababaasin wedey naanggotbaason wedey bulobaason beya bar daysire dananawa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Hash han neyaasik kabugtok keyaason, ayisakitonin, eetisikitonon, intoosikitonon, naanggotaason, bulooson tiya kushunon danana. Yooni neyaasik dey koi'ba foonto kaa dannor oonu aafewa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sinuntano sina zeemme fe showoni meya orfo wolsone. Orfo wollefe baasso dey sina zeemone» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Den Yerusalem hamfa ugnaasik hamefeen Yesus sina zeemet feer sinna boor'a nawobaasakito diinqesete. Orfobaase hama baasso dey digset feeseter. Hepsi dey asire heppe nawobaasakitonin barki tai'sire basaasta kar'anak fa chowaason baassok mako ephi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Ese Yerusalem hamnirwa. Asuni Naa maagni gaanynyaniknawa Museni tumaasi assinynyani meyakna aattere imtonir. Baasso dey kituni mangsuni kar'a basaasta kar'oner. Aazabni meyak aatire imoner. ");
INSERT INTO jnjl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Baasso dey kanyoner, tujosoner, ichoner dey worsoner, Sinuntano keez wonaneen orfo kitun kabunir» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Esseen orfo Zabdiyosni naanggot Yaqobnawa Yohannisna Yesusniki yeesere: «Assinynyano! Inno mamsuni chowaason zuutira zagutak sholefeniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus dey: «Nittok awu zagunakinso sholefetiri?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Baasso dey wolgire: «Ne taatosi ulfintoni kabaasik isarniis oi'ta teshneesta isarniis dey alda teshneesta duunik ma'i uwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sinuntano Yesus: «Mamsifeti baron aane arifetiwa. Ta ushanak fa shanani ushaason; ta haphuktonak fa haphuktooson haphuktotik chimatiroso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Baasso dey: «Aa, chimaniwa» yisete. Yesus: «Ta ushanak fa ushaason ushati; Ta haphuktonak fa haphuktooson haphuktotiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sinuntano o'itnaastanawa alidnaastana duus hoorena baassoktano es baron imniis tatewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Fu'te asir nawoosakito odesere Yaqobniistanawa Yohannisnistana gi'tesete. ");
INSERT INTO jnjl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus asire heppe nawoosakitonin barki teegere ekka yi: «Aazabni meeni gaanynya yistefe baasso darabesiisin hugnak ha'sisefemato arsefeti. Esiisimato dey zoonsisefe baasso dey es daraasata ha'suni tuuma hugnabesi faanamatona arsefeti. ");
INSERT INTO jnjl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sinuntano nittokik ekkatawa. Nittoossin arkir sinak sholefe bar nitto wostinynya sinowa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nittoossin oonu zeemak sholefe bar zuuttamnitiise asi boz sinowa. ");
INSERT INTO jnjl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Esiisimato Asuni Naasnu wostonaknawa kaabaason showoni meyanon furok aatire imanaktano barik wostosonekna aane yowewa.» ");
INSERT INTO jnjl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus nawoni meyaneen Iyyariko yeesete. Estan kesefeen showo dara baassoneen ane hamedifer. Ugnaasi ha'ta dey Temewosni naa aaftishu Bartemewos diifaat shiiphet feer. ");
INSERT INTO jnjl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Naaziretki Yesus sinbaason odenayse: «Dawitni zalaassin koonte Yesusno! Taan maarowa» yit chaaga ephi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Showo asuni meya shaakkunak ke'isete. Sinuntano bar: «Dawitni zalaassin koonte naaso taak kenashtowa» yit aatamsire chaagi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus yerefaat: «Teegotiwa!» yi. Baasso dey Aaftishusin: «Harewa! Kabuwa neen teegedifewa!» yit teegsete. ");
INSERT INTO jnjl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bar dey geregere kabire tukaastaki maybaason ha'aat Yesusniki ye. ");
INSERT INTO jnjl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus wolgire: «Awu neek zagunak sholefasso?» yi. Aaftishuus dey: «Assinynyano! Biyanakwa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus dey: «Hamma, amantonees neen fatiwa» yi. Geregere biyet ugunne basa orfoose hami. ");
INSERT INTO jnjl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesusnawa nawobaasakitona Yerusalem tai'sesefe kabaasik Betefagenewa Bitaniyane asiissi kamo Dabrazayitini kumaasta kar'ete. Estan nawobaasasin heppin ekka yit wosi. ");
INSERT INTO jnjl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Ek sinnitiista fa ke'eessi hamti. Esta kar'etiise oonu barista duunoyna hanyani nawa tuptera yerefeen danati. Kotta hang ephpha yootiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Oonu: ‹Awagan han baron zagidifetirinso?› iyaanane ‹Daamiisik sholsina boor'a, hash geregere wolgire gafkuna› » uti. ");
INSERT INTO jnjl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Baasso dey hameten hanyani nawa ugnaasi teshta keeni fochata tuptera yerefeen danere kotete. ");
INSERT INTO jnjl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Esta yerse baassossin isa isaas: «Hanyaasi nawanon awuniron kotdifetirinso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Baasso dey Yesus ajajenaasimato maksete. Asuni meya dey wolle beyete. ");
INSERT INTO jnjl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nawoosakito hanyaason Yesusniki ephphe yeesete. Maybesiison geshobaasta kunusseten barista di. ");
INSERT INTO jnjl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Showo asuni meya maybesiison ugnaasta yiir'ete. Oomiis dey i'oni tosha kiir'e yiir'et feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sina zeema baassonawa orfobaase yeesefe baassona zuuttere: «Hosana! Daamiisa sunak yeefe bar suustowa. ");
INSERT INTO jnjl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Daamiisa sunak yooni abani Dawitni taatoos suustowa. Hosana den samak» yit chaaget feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesus Yerusalemki betemeqdesiissi giri. Biratere zuuttambaase asin biinanneen orfo gerok waaldifar sinna boor'a asire heppe nawobaasakitoneen Bitaniya hami. ");
INSERT INTO jnjl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wonotiri wono Bitaniyan kesefeen Yesus makte. ");
INSERT INTO jnjl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Toshbare yere belesini i'o woksok biyaat gaana barissin bestonitto iyaat barki hami. Sinuntano gaanfana asba sina beyna boor'a tosha toshatano isanne danna gaana aafa. ");
INSERT INTO jnjl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Es bari boor'a belesiison: «Hawungneen ekalo oonu neekin isanne gaana muunaatawe» yi. Nawobaasakito dey es baron odesete. ");
INSERT INTO jnjl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yerusalem kar'efe kabaasik betemeqdesiisi ojni keerkalo girire estak kisire waagsefe baassotinnawa geron waagsefe baassotinna kalle kisu ephi. Waaga soolet fe baasso tarabbezasonnawa nakalo waagefe baasso kodaasonna shelgire ha'i. ");
INSERT INTO jnjl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Estan Yesus: «Oonu isa wuza wor'e betemeqdesiisi keerkalo girunaatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dey esta fe asusik assifena kabaasik ekka yi: «‹Keenaas dara zuuttambaase asi Ha'oni shiiphoni keyawa› yistera aane tichchowanoso? Sinuntano nitto bo'inynyani dugadug zagitiwa.» ");
INSERT INTO jnjl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Maagni meeni gaanynyani meenawa Museni tumaasi assinynyaasna es baron odesete. Daraasneen zuuttere basa assusik diinqet feeseter sinna boor'a Yesusnin digsete. Es bari boor'a aakkak worsonemato sholset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Waalfana kabaasik dey Yesusnawa nawobaasakitona katamaassin gerakalo kesete. ");
INSERT INTO jnjl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","E'so wonsak ugunne hamefeen belesiis tasbaasneen ichimma diifen biyete. ");
INSERT INTO jnjl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Phexiros nibbaasta kejfaan: «Assinynyano! Ne erwita belesiis ichimiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus baassok wolgire ekka yi: «Ha'oosik amanotiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Futo nittok makefawungwa; Oonu nibaassi sinungaso unoy makona bar zagtonamato amanere han aamaason: ‹Waatera baariissi ha'towe› iyaanane barik sinanawa. ");
INSERT INTO jnjl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Es bari boor'a shiiphok mamsiti wuzason zuutira dantir zagira amanotiwa nittok sinana. ");
INSERT INTO jnjl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Shiiphefeti kabaasik den samak fe Abantiis boor'nitiison feeshun unak asuniista isa chowniti faafaanane feeshun utiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sinuntano nitto asusa mangsunon feeshun uu shakaatine den samak fe Abantiis boor'nitiison aafa feeshun unawuza.» ");
INSERT INTO jnjl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hepsa dey Yerusalem yeesete. Yesus betemeqdesiissi kutifeen maagni gaanynyani meya, Museni tumaasi assinynyanawa kur'uni meena barki yeesere: ");
INSERT INTO jnjl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«Han baron awuni ha'suni hugnakinso zagidifatari? Wedey han baron zagutak ha'suni hugna neek imar oonso?» yit mamsisete. ");
INSERT INTO jnjl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus dey: «Ta isa mamsu nittotin mamsunawa. Es mamsunaason wolgifaatine ta dey han baron awuni ha'suni hugnak zagifanamato nittok makonawa. ");
INSERT INTO jnjl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohannisni haphquus Ha'ooskin yaaringwa wedey asunikininso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Baassotna baassotna ekka yisete: «Ha'okin yaar iyaanine eekin awuniron bar makena baron amano beytiso? unir. ");
INSERT INTO jnjl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ese asunikin uniroso?» ekka usonoytemato asu zuuttere Yohannisnin futoosik Ha'oni raajjuwa yiset feeseter sinna boor'a daraasin digsete. ");
INSERT INTO jnjl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yesusnik wolgire: «Aane arifeniwa» yisete. Yesus dey: «Ta dey awuni ha'suni hugnak han baron zagifanamato aafawa nittok makona wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Besok dey assunak kabi: «Isa asu wayinini shaa tokke, oja ojje, gaanbaason ti'una doo'a yiishshe, toolo keer'i. Estan bulinynyani meyak kira imaat woka dima hami. ");
INSERT INTO jnjl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kephtona wonba kar'fana kabaasik gaanbaastan ephphe yoonak wostinynyaasin bulinynyani meyaki wosi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Baasso dey ephphe ichere kushkush gafuksete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Hepsa oom wostinynyanin baassoki wosi. Es barin dey ichche teetbaason kar'ere salphisire gafuksete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tusire oomnin wosi; es barin dey worsete. Oom showonin wosin isa isaasin ichesete dey isa isaasin worsete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Fu'te isa keeshtefena naabaasin: ‹Naataasin baassoki wosaanane ulfinsubesiwa› iyaat zuuttambesiise asi orfoosta wosi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Sinuntano es bulinynyani meya baassotna baassotna: ‹Foshaason tooniis han barwa! Yaani woraat foshaason innor zaguniwa› yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Estan ephphe worsere wayiniisi foshni gerakalo ha'sete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Ese wayiniisi daam awu zagunirinso? Yeere bulinynyani meyanon woraat wayiniisi foshanon oomni meyak imanawa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ese: « ‹Shu'ni keyaason keer'fe baasso gonesete shu'aas; shu'ni keyaasi kajjata duuni sholsu shu'a siniwa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Es barnu Daamiiskintu siniwa; biife innoknu akamanon diinqiwa!› » yifa tichaason aane feretira biyetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Maagni gaanynyani meya, Museni tumaasi assinynyanawa kur'uni meena es makena besos baassosta sinbaason arsete boor'a barin ephphe taar'ak sholsete. Sinuntano daraasin digsefaat beyye hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wolumbaasik barin ephak isa isa Ferisawini meyakinnawa Herodisni keen sina baassotinna Yesusniki wosisete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Barki yeesere: «Assinynyano! Ne futonir sintamato arifeniwa. Asuni sina biira korunoy wedey asu awu una uuk zagifata wuza aafawa. Futok Ha'oosi ugnanontu assifatwa. Makowa, Roomni taate meeni taatoosik girboni ima sholsungwa wedey sholsutanso? Imaniringwa wedey kalanirinso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sinuntano bar sirbesiissiki mangunon araat: «Awuni boor'a taan wollak takalok sholefetiso? Isa saantibi teshsheni biyungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Baasso dey teshshesete. Yesus dey: «Han gitoosewa tichbaase oonirinso?» yire mamsi. Baasso dey: «Roomni taate meeni taatoosarwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesus dey: «Ese taatoosaron taatoosik; Ha'oosiron Ha'oosik imtiwa» yi. Wolgubaasik dey diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","«Kitun kabu aafa» yisefe isa isa Seduqawini meya barki yeesere ekka yit mamussete: ");
INSERT INTO jnjl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Assinynyano! ‹Isa asu nawa koonunoy asubaason ha'aat kitifaanane aybaas dey es asuson ephphe zalba sinanak aybaasik koonuwo› yire Muse innok tichi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ese naafun ayni meya feeseter. Tesuni bar asu ephphe nawa koonunoy kiti. ");
INSERT INTO jnjl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hepsaas dey ephphe nawa koonunoy kiti. Esiisimato Keessaas dey ekka sini. ");
INSERT INTO jnjl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Naafunobesiise asuson ephphe nawa koonunoy kitisete. Zuuttambesiise asi orfota asus dey kiti. ");
INSERT INTO jnjl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Asuson naafunobesiise ephete sinna boor'a kitun kabuni wono baassossin oonik asu sinnirinso?» ");
INSERT INTO jnjl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus wolgire ekka yi: «Tichaasonnawa Ha'oosi hugnanonna aane arifeti sinna boor'a daagefetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kiti baasso kitun kabsefe kabaasik den samak faase Ha'oosi wosinimatotu foosonetano ephne girune aafa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Sinuntano kituni meya kitun kabsonemato Ha'oos: ‹Ta Abrahamni Ha'o, Yisaqni Ha'o, Yaqobni Ha'owa› yit es saabaassiki geyaasi chowak makefa dimaasta Musenik makena baron Museni tichaassi aane feretira biyetinoso? ");
INSERT INTO jnjl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bar hayewni meeni Ha'otano kituni meeni Ha'otawa. Es bari boor'a nitto akamanon daagefetiwa.» ");
INSERT INTO jnjl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Museni tumaasi assinynyaasasin isaas baasso karakkaroson ode. Yesus ma'aron wolgubaason gasasifaat barki yeere: «Zuuttambaase asiistan denalo sholsu ajajiis aaffarinso?» yire mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus wolgire: «Ajaji zuuttambaase asiistan denaloos: ‹Israelno odowa! Inno Daama Ha'oniis isa Daamawa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ne dey tuuma nibneesik, tuuma kaaneesik, tuuma safaraneesik, tuuma hugnaneesik Daama Ha'oneeson shungwa› yifarwa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hepsa ajajiis dey ekkawa: ‹Wolkoneesin ne neen shunfataasimato shungwa› Esiistan denalo ooma ajaji aafawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tumaasi assinynya wolgire: «Ma'arwa; Assinynyano! ‹Ha'oos isarwa; barneen ooma Ha'o aafawa› yira futok wolgitwa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tuuma nibak, tuuma safarak, tuuma hugnak baron shun. Dey Wolkoneesin teetneeson shunfataasimato shuna kiichchefa maa'aastannawa ooma ooma imaastanna denalowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Asus aruk wolginamato Yesus araat: «Ne Ha'oni taatoossin wokka faatartawa» yi. Esseen orfo oonu mamsuni mamsuk aane chime. ");
INSERT INTO jnjl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus betemeqdesiissi assifet ekka yi: «Museni tumaasi assinynyani meya: ‹Kiristoos Dawitni zalaassin koonte naawa› aakkak yisefeso? ");
INSERT INTO jnjl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawit teetbaasik Korto Ayyanak zoonustere makefena kabaasik: « ‹Daamiis Daamtaasik gumaneesakitonin; wochoneesi sikalosi yer'atak zaguna kabaneen; oi'ta teshnaasta duwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Dawit teetbaasik ‹Daamta› utu yiwa. Eekan aakkak Dawitni zalaassin koonte naaba sinnirinso?» Showo daraas dey girak odeset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus assifena kabaasik ekka yi: «Dicha dicha maya mayye ek hang kutu, gabaastak asu naga ooshshonak sholsefe tumaasi assinynyani meyakin teetnitiison oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Baasso Ayhudni shiiphoni keyaasik tega koda, koota maastefanaasta tega dimatu sholsefewa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dicha tukama asusikitonon fa wuzbaason ephefe. Dey dicha shiiphoni shiiphok biistokwa iyaat es effatena wuza zagsefe baasso akama mangsuni kar'atu ephphetoosonewa.» ");
INSERT INTO jnjl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus imte ima zuuttefana saaxiniisi sinta diifen asuni meya waaga sir ha'sefeen bi. Showo otumni meya akama waaga imet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Isa tukama dicha asu waagbaas isa duude sinna hep garo garo naasini saantibi imi. ");
INSERT INTO jnjl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nawoni meyanon teegere: «Futo nittok makefawungwa, waagbesiison ima baasso zuuttambesiise asiistan denalo han tukama asus arkissira imiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Zuuttambesiise baassok hoorera fu'tesontu imetewa. Sinuntano han asus tukama sinfaat barik fayiison fu'onoy zuutira imiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus betemeqdesiissin kesfeen nawoni meyaassin isaas: «Assinynyano! Han shu'asikitonewa han shu'ni keyaasikitone awune fa diinqi sinnamato biwa» yit make. ");
INSERT INTO jnjl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus dey wolgire: «Han inya inya shu'ni keyaasikitonon biidifatoso? Han shu'aasikito isa isaasta diira fui'tonir aafawa. Zuuttera bokterwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesus betemeqdesiisi sinta fa Dabrazayitini kumaasta diifen Phexiros, Yaqob, Yohannisnawa Andriyasna baasso baasso barki tai'sere: ");
INSERT INTO jnjl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Han bar aagenso sinanari? Han bar zuuttambaase sinfana kabaasik besobaas aambanso? Innok makowa» yire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus dey ekka yi: «Oonu nittotin eshnoynamato teetnitiison oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Showoni meya: ‹Ta Kiristooswa› yit ta sunaasik yoosone. Showoni meyanon dey eshone. ");
INSERT INTO jnjl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Neeboni chownewa neeboni odune odefeti kabaasik digotiitawa. Es bar dey sinanak faarwa. Sinuntano koi'baas hashtawa. ");
INSERT INTO jnjl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Daraas daraasata; taatoos taatoosta kabuna. Showo dimta dey daani shorkonewa makne sinana. Es bar dey akama keektoni tesuwa. ");
INSERT INTO jnjl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Nitto dey teetnitiison oodtiwa. Shonggoni kuphamaasta nitto aattera imtoti. Ayhudni shiiphoni keyaassik ichchosoti. Zaala sinatik taakwa iyaat ha'sife baasso sinanawa taate meena asi sinana yeroti. ");
INSERT INTO jnjl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Es bar sinbaasneen zeemma misirachchuni kaamaas dara zuuttambaase asik maktonak sholsuwa. ");
INSERT INTO jnjl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nittotin ephphe aatire imefe kabaasik: ‹Awutaaso makoni?› uuk zeemma rakkatotiitawa. Sinuntano es kabaasik nittok imtoni baron makoti. Makoniis dey Korto Ayyanatano nittotewa. ");
INSERT INTO jnjl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ayiis aybaasin, abaas naabaasin kituk aatire imana. Naanggotaas kooni aba intoosta manguk kabsera worsona. ");
INSERT INTO jnjl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Asu zuuttambaase asi sina ta sunaasi boor'a oomtester sinati. Sinuntano koi'ba kar'ananneen chimme yere bar faruna. ");
INSERT INTO jnjl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Dey zina wuzaas kayma dimaason kiinifa barik sholsunoy dimaasta yerefeen biyaatine feretife bar yaadatowowa. Es kabaasik Yuudak feese baasso aamaaski eeloto. Zinaas korto dimaasta yerefeen biifeti kabaasik feretife bar gasasuwowa ");
INSERT INTO jnjl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Keyaasi tukta fe bar daa kerere isa wuza ephak keer girunaata. ");
INSERT INTO jnjl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Foshaasta fe bar maybaason ephanak orfo wolunaata. ");
INSERT INTO jnjl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Es kabaasik naanerisewa nawa tanifa asusikitone yerefawungwa! ");
INSERT INTO jnjl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sinuntano es wonaas yeeshussi sinnoynamato shiiphoti. ");
INSERT INTO jnjl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Es kabaasik Ha'o tesina testoostan kabira hash hawungneen kar'a biistonor wedey hanneennu sinnoy shana sinana. ");
INSERT INTO jnjl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Daamiis es wonaasikitonon kawunsu shaki sinfaanane asha mayo asu zuuttambaase fui'tona kabatawa. Sinuntano bar korina asuni meeni boor'a wonaasikitonon kawunsi. ");
INSERT INTO jnjl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Es kabaasik oonu sino: ‹Kiristoos hanta feerwa› wedey ‹Ekesta feerwa› yifaanane amanotita. ");
INSERT INTO jnjl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Esh Kiristoosni meenawa esh raajjuni meena yoosoner. Es baasso chimtefaanane Ha'o korina baassotinnu daagsuk besonewa biistera artonoy wuzne zagsone. ");
INSERT INTO jnjl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Esiisiktu ta zuuttambaase asin zeemma nittok maken sinna boor'a teetnitiison oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Es kabaasik es shanaasneen orfo: ‹Awaas talmona; assaas dey aafa chaarona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Baakuraasikito saman zigtosona; samak fa hugnaasikito dey shorkona› ");
INSERT INTO jnjl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Es kabaasik Asuni Naa akama hugnaknawa ulfinakna shaaruussi yeefeen biyone. ");
INSERT INTO jnjl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bar dey Ha'oosi wosiyanon wosire daa daassin, daasi diltan kabira daasi koi'ta kar'e fe barik korte asuni meyanon zuutuna. ");
INSERT INTO jnjl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Besoson belesini i'oostan aruti. Waay'baas tosha kotta toshbaas dey boodefana kabaasik kawo tai'senamato arifetiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Esiisimato nitto es bar zuuttambaase sinin biifeti kabaasik Asuni Naani yoo tai'sera finynyaassi kar'namato arutiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Futo nittok makefawungwa; es bar zuuttambaase sinnoyfeen han koontoos aafa aatana wuza. ");
INSERT INTO jnjl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Samaasewa daase aatana. Sinuntano kaamnaasikito aafa aatana wuza. ");
INSERT INTO jnjl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Sinuntano es wonaasi chowanon wedey es sa'atiisi chowanon Abaasteno samaki Ha'oosi wosiyaas wedey Naas aane arife. ");
INSERT INTO jnjl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Es wonaas aage sinanamato aane arifeti sinna boor'a guzira oodti ");
INSERT INTO jnjl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Esiis dey Keebaason beyfaat ooma daa hama asusne faarwa. Bar dey wostinynyabaasakito wostosonak wosto haa'e imaat keyaason oodfe barin dey: ‹Guzira oodwa› yire ajaje. ");
INSERT INTO jnjl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Es bari boor'a keyaasi aba aage yoonirto aane arifeti sinna boor'a teetnitiison oodti. Awuzakne waalin wedey daani kixxe wedey ako oorifena kabaasik wedey wonsa wassi sinak chimana. ");
INSERT INTO jnjl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Diinqone yeere kunfeni dannoynamato guzutiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","«Nittok makenaasimato oomisikneen zuutira ‹guzuti› yira makefawungwa.» ");
INSERT INTO jnjl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ayhudni faasikasewa kixxa maastefana heeboose zagtonak hep wona fui'tera faar. Maagni gaanynyanawa Museni tumaasi assinynyaasna Yesusni ephphe worsone manguni ugna sholset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sinuntano baasso: «Daraas faasso kabguba, han heeboossi aafa zaguniwuza» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesus Bitaniya yiste ke'e zeemo awataatoni mettan sina Simonni keer diifer. Esta muuni muuk diifen isa mashkasu waagba akama chima shunto naardosini toshakin wosuste shitto albastiros yistefa shu'ak wosuste bilqadisi tuumanon ephpha ya. Bilqadisi ukanon mesira shittooson Yesusni teetaasta wuuki. ");
INSERT INTO jnjl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Es Simonni keer diise asuni meeni ganeyaassin isa isaas zagte barik gi'tesere: «Han shittoos baak wuuktera ke'nor sinnaas awuni boor'anso? ");
INSERT INTO jnjl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Waagtefaanane isa wogga wosuste wostoni birrineen denalo waagtera tukamnik imtok chimtona kabawa» yisesete. Asuson dey ke'isete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sinuntano Yesus: «Beytiwa! Awuniron baron rakkisidifetirinso? Bar taak ma'a wuza zagiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tukamni meya wonna wonna nittoneen anetu feesete sinna boor'a sholeti wono argasutik chimatiwa. Sinuntano ta wonna wonna nittoneen ane aafawa foona wuza. ");
INSERT INTO jnjl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Han asus bar chimnayson taak zagiwa. Ashnaas moogsi girunak hoossuk zeemma shittok woshshi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ta futo nittok makefawungwa; Han misirachchuni kaamaas daasi biratota zuuttambaase asiista maktefana dima aaffaristanu han asus zagina bar baron safaronir sinna maktonawa.» ");
INSERT INTO jnjl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Asire heppe nawoosasin isa Askorotki Yuuda Yesusnin aatire imak maagni gaanynye meyaki hami. ");
INSERT INTO jnjl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Baasso dey es baron odeseteyse girsete. Waaga dey imonek abdi imete. Es bari boor'a Yuuda dey Yesusnin aatire imana ugna sholet feer. ");
INSERT INTO jnjl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ayhudni faasikani fantu shuktera kixxa maastefana heeboosi tesuni wonaasta nawoni meya Yesusniki yeesere: «Faasika maastefa meeta'uson muutak ay hamma hoossunik sholefasso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesus dey nawoosasin heppiisin wosire: «Ek katama hamti. Estak dey akani gima wor'o asunin uphoti. Basa orfoose hamti. ");
INSERT INTO jnjl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bar hamme girina keyaassi girifaat keyaasi abanin: ‹Assinynyaas, nawotaasneen ane faasikani muuson muuna irbani keya ayfaso?› yifewa uti. ");
INSERT INTO jnjl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bar segenetiista hoorera yiitera di taga keya nittok besuna. Esta hoossuti» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Es nawoosakito katamaassi hamere makenaasimato danere faasikani muuson hoossisete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Waalfana kabaasik Yesus asire heppe nawobaasneen ane ye. ");
INSERT INTO jnjl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Diisefa meesefeen: «Nittok futo makefawungwa; nittoossin isaas han taneen meefe bar taan aatire imnir» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Baasso dey suumesere isa isarbesiis: «Ta sinungataaso?» yiset Yesusnin mamussesete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus wolgire: «Asire heppesasin isaas han taneen ane koranaassi dukire meefe barwa. ");
INSERT INTO jnjl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Asuni Naa barik tichchenaasimato kitunak faar. Sinuntano Asuni Naanin aatire imni es asus haybubawowa. Es asus koonto shaki sinfaanane ma'arwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Meesefeen Yesus tushaason ephphe Ha'o galattefaat batte: «Ese, haniis ashnaaswa» yire nawoosakitonik imi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tofoosonn dey ephphe Ha'o galattefaat imi. Zuuttere es toofoossin ushete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ekka dey yi: «Han bar showoni meyak wuuktoni teyyani harinnaaswa. ");
INSERT INTO jnjl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","«Futo nittok makefawungwa; Ha'oosi taatoni ha'susi gaddo wayinini ushaason ushana kabaneen han barissin hepsi aafa ushanawuza.» ");
INSERT INTO jnjl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Esseen orfo galatni gaama gaamere ek Dabrazayitini kumaasta kesete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus nawobaasakitonik: « ‹Keemeriisin ichcha woruna; fantuusikito dey siktona› yistera tichchena boor'a zuuttera ha'aat eelatiwa. ");
INSERT INTO jnjl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sinuntano ta kitun kabinanneen orfo ek Galiila zeemma hamana» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phexiros dey: «Zuuttambesiise ha'aat eelefeknu ta aafa ekka zaguna wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus dey: «Futo neek makefawungwa; hawung han waalaasik ako heppa wolle oorunoyfeen ne keeza wolla mormotawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Phexiros kaambaason chinire: «Neneen ane kitunannu sinfaanane aafa mormona wuza» yi. Zuuttere dey basaasimato maksete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Esseen orfo: «Getesemani» yiste dimta hamete. Yesus nawoni meyanon: «Ta ekesta shiiphona; nitto hanta diifotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Estan Phexirosnin, Yaqobnin, Yohannisnin barneen ane zoonsire hami. Akamanon suumet nayo ephi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nawobaasakitonik dey: «Kaanaas kitunanneen kar'a akamanon suumewa. Hanta faafaat guzira oodtiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Garonon ek sina eksere daasta gandere chimtonir sinfaanane shanani wonaas basaastan aatanamato shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ekka dey yi: «Aabba abataaso! Zuuttera neek chimterwa. Han ephphatoonak fa shanaason tayistan woksu. Sinuntano ta sholena bar sinnoynamato ne sholeta bar sinunwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wolle yeere kunefeen bi. Phexirosnin dey: «Simonno; kuntaroso? Isa sa'atine guzire oodak aane chimenoso? ");
INSERT INTO jnjl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Fatanaassi girunoytimato guzira shiiphotiwa. Ayyana hooreratu fa sinuntano ashaas hopiyawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Estan wolle dey ukkoti shiiphena shiiphooson shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wolle dey yeen aaffesiis afay'nik fayna boor'a kunefeen bi. Barik maksefe baronnu aane arsoto. ");
INSERT INTO jnjl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Keezsa dey yeere: «Hashneen kunfetiyoso? Hashneen beysa ephdifetiyoso? Ese haye hooronawa, sa'atiis kar'i; Asuni Naa boor'ni meeni kushusi aattere imtonir. ");
INSERT INTO jnjl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kabini hamni; Hash taan aatire imni bar tai'se» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Geregere es baron makefena kabaasik asire heppesasin isaas Yuuda sinfe bar ye. Barneen ane sikonewa mukne epho maagni gaanynyanikin, Museni tumaasi assinynyanikin, kur'uni meyakin wostere yeese showo asuni meya feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aatire imni Yuuda zeemme: «Ta daamona barintu nitto makira ephpha hamtiwa» yire besok makere feer. ");
INSERT INTO jnjl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Geregere yeere Yesusniki tai'sere: «Assinynyano!» yit daame. ");
INSERT INTO jnjl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Es ane yeese baasso dey Yesusnin ephete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Esta yere baassossin isaas siifo zanbaassin kisire maagni gaanynye meeni gaanynyaasa wostinynyani odonon kace. ");
INSERT INTO jnjl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus dey: «Bo'inynyanin ephnirimato sikonewa mukne ephpha taan ephatik yaatiyoso? ");
INSERT INTO jnjl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Betemeqdesiissi wonna wonna nittoneen ane faafaat assifana kabaasik aane taan epheti. Sinuntano tichche bar ko'unak han bar siniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nawoni meya dey zuuttambesiise barin beyfaat eelesete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Atubaasta wor'a maama mayo isa na'o asu basa orfoose hamet feer. ");
INSERT INTO jnjl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Asuni meya barin ephefe kabaasik maamaason ha'aat atatubaase eeli. ");
INSERT INTO jnjl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesusnin maagni gaanynye meeni gaanynyaaski ephere hamete. Museni tumaasi assinynya, kur'uni meenawa maagni gaanynye meena zuuttere kuphisete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phexiros maagni gaanynye meeni gaanynyaasa ojni keerkalo kar'ananneen woksok orfobaase hami. Estak dey wostinynyani meyaneen diifaat geya besit feer. ");
INSERT INTO jnjl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Maagni meeni gaanynyaasnawa shoongoose zuuttesere Yesusnin woruk zaalnin sholsere aane danoto. ");
INSERT INTO jnjl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Showobesiis esha zaala makset feeseter. Sinuntano maksefe zaalaas isarba foonto sini. ");
INSERT INTO jnjl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Isa isa asuni meya kabsere: « ‹Ta han kushuk keete Betemeqdesiison bogaat keezsinari wono ooma kushuk keetonoron keer'ana› yifeen odeniwa» yit esha zaala maksete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sinuntano hashnu zaalni meeni kaamaas aane isar sina. ");
INSERT INTO jnjl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Maagni gaanynye meeni gaanynyaas baasso ganeyaassin kabire Yesusnin: «Han baasso neyista maksefe zaalaas aambanso? Isaronnu wolgu beytaroso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sinuntano bar shaakki. Isaronnu aane wolguwe. Hepsinu Maagni gaanynye meeni gaanynyaas: «Suusto Ha'oosi naa Kiristoos nenoso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus wolgire: «Tawa; Asuni Naa Ha'oosi o'itta diifeennawa samaki shaaruusta yeefeenna biyatiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Maagni gaanynye meeni gaanynyaas maybaason karasaat: «Hanneen ekalo ooma zaala awuniron sholsunirinso? ");
INSERT INTO jnjl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ha'ooson me'baason odetiwa. Nittok awu sinna bestefaso?» yi. Baasso zuuttesere: «Kitu barik sholsuwa» yit mangsu kar'esete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Isa isaas basaasta tujo ephete. Aaffaason maamak ukaat ki'et: «Raaji innok makowa» yisete. Wostinynyani meya dey bochet ephphe hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Phexiros haat ojni keerkalo feen isa Maagni gaanynye meeni gaanynyaasa keeri wostinynya ya. ");
INSERT INTO jnjl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Phexiros geya besifeen gasasira biyaat: «Ne dey Naaziretki Yesusneen ane faatarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sinuntano bar wolgire: «Ne makefata baron ta aane arutwe. Aane gasasut» yit morme. Gerakalo finynya kesfena kabaasik ako oori. ");
INSERT INTO jnjl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Keerki wostinynyaas hepsa dey biira esta yere baassok: «Haniis baasso keengwa» yit make. ");
INSERT INTO jnjl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bar dey hepsa: «Morme» Garonon feere esta yere asuni meya Phexirosnin: «Futok ne Galiilaki asu sinta boor'a baasso keengwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sinuntano bar: «Han maksefeti asusin aane arifatwa!» yit barin bar wolgire erwit teyi. ");
INSERT INTO jnjl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Geregere dey ako hepsa oori. Phexirosnin Yesus: «Ako hepsa wolle oorunoyfeen ne keeza wolla mormotawa» yina kaamaas nibbaasta kejfaan seektere waasi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","E'so wonsak maagni gaanynyani meya kur'uni meyaneen, Museni tumaasi assinynyanawa shonggoni meena zuuttere isarik merkesete. Esseen orfo Yesusnin taar'e taamme Philaxosnik aatire imete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatos dey: «Ne Ayhudni meeni taatonoso?» yire mamsi. Yesus dey: «Aa, ne maketaasimatowa» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Maagni meeni gaanynyani meya Yesusnin showo chowak malasset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatos dey: «Isaronne aane wolgifenoso? Apun chowanso neyista malassediferi» yire mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesus isa wuzane aane wolguwe sinna boor'a Pilatos diinqe. ");
INSERT INTO jnjl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilatos faasikani heebo heeboosik asuni meya mamussete isa taatonin kotte gafkit feer. ");
INSERT INTO jnjl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Manguk taatoosata kabsere kaani woruk taatere fe asuni meyaassin isa Barbaan yiste asu feer. ");
INSERT INTO jnjl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Darani meya yeesere: «Hazozoti zagifataasimato isa taatonin innok kotwa» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilatos wolgire maagni gaanynyani meya koonak aatire imetemato arina boor'a: «Ayhudni meeni taatosin kotanak sholefetiyoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sinuntano maagni gaanynyani meya Yesusnin beyfaat Barbaanin kotanak Pilatoosnin mamussonek daraasin kabugsesete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatos hepsa wolgire: «Eekin Ayhudni meeni taatowa yifeti barin awu zagunak sholefetiso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Darani meya dey: «Suuttowowa!» yit chaagete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatos dey: «Aamso? Zagina mangsu aambanso?» yi. Sinuntano baasso: «Suuttowowa!» yit chaaga aatamsisete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatos daraasa safaranon zaguk sholefaat Barbaanin baassok kotaat Yesusnin alanggak ichchonak zagire suuttonak aatire imi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Taar'osakito: «Pratoriyon» yistefa daa ha'sife basa ojni keerkalo Yesusnin ephphe hamete. Estan oom taar'oni meyanon isarik zuutisete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","She'a maya maysisete; dey seer'a ma'ire zawudi zagire teetbaasta guufsisete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Estan: «Ayhudni taatono! Naga neek sinfawungwa!» yit naga ooshsheset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Teetbaason sobboqok ichet, tujet barik kaa'net moosesete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kanyesetenneen orfo she'a mayaason gaay'aat basa mayaason mayissere suuttonak ephphe hamesete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Isa ugunni wof Aleksandirosnawa Rufosna asi aba sina Simon yiste qerenaki asu beeden yeefeen danere mesqeliison wor'anak giddisisete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Estan Yesusnin ephphe Golgota yistera teegtefa dimaasta taamete. Es Golgota uus dey: «Teetni megani dima» uu. ");
INSERT INTO jnjl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Estak dey kumbineen woi'to wayinini usha ushanak imesete. Sinuntano bar aane ushe. ");
INSERT INTO jnjl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Estan suutesete; maybaasta dey ixa ha'sere aa'esete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Es suutesefe kabaasik e'so keez sa'ati. ");
INSERT INTO jnjl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Malataasi ticha: «Ayhudni taato» yifar. ");
INSERT INTO jnjl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hep bo'inynyanin teshshesete Yesusneen ane isaasin oi'ta teshbaasta isaasin dey halda teshbaasta suutesete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Matsafaas: «Manguni meyaneen faadtewa» yina bar ko'i. ");
INSERT INTO jnjl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Teshba aatfe ugunni wofni meya teetbesiison shorkit ekka yit me'et feeseter: «Yi, ‹Betemeqdesiison bogaat keezsinari wono keer'anarwa› yi neno! ");
INSERT INTO jnjl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ese hash mesqelistan kerera teetneeson fu'owa!» ");
INSERT INTO jnjl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Esiisimato maagni gaanynyani meenawa Museni tumaasi assinynyaasna baassotna baassotna: «Oomiisin fu'e, sinuntano teetbaason fu'ok aane chime! ");
INSERT INTO jnjl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ese biira barik amanonik bar muudto Israelni taatoos hash mesqelistan kerowowa» yiset kanyesete. Barneen ane suutte bo'inynyani meya dey barin me'et feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tooni issun sa'atiistan kabira izgin sa'ati kar'ana kabaneen daas zuuttera talma sini. ");
INSERT INTO jnjl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Izgin sa'atiista Yesus: «Elohe, elohe, lamasebeqtani» yire akama kaamak chaagi. Kotbaas dey: «Ha'onaase! Ha'onaase! Awuni boor'a taan beyitse?» uu. ");
INSERT INTO jnjl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Esta yere asuni meyaassin isa isaas odesere: «Odotiwa; Eliyasnintu teegedifewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Isar eelle aka ephak chima wuzaassi haphqire sobboqota duusire suutire ushanak Yesusnik imaat: «Beytiwa shakaani Eeliyas yeere kessunitto biyaniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesus akama kaamak chaagi; Kaabaas dey kesi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Betemeqdesiisi yinu denun daa heppik karate. ");
INSERT INTO jnjl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yesusni sinaasta yere tii meeni gaanynyaas kaabaas kesbaason biyaat: «Han asus futok Ha'oni naawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Isa isa mashka meya dey woksok biyet feeseter. Es baassossin Megdelawitki Maarami, Salome, hate Yaqobnawa Yoosana asi into Maaramine feeseter. ");
INSERT INTO jnjl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Baasso Yesus Galiilak feena kabaasik Yesusneen ane hamefaafa argasit faaser. Esiisimato Yesusneen ane Yerusalem hama ooma showo mashkasu faaser. ");
INSERT INTO jnjl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Gerok waalfana kabaasik Armatiyaski Yosef yiste asu ye. Yosef shoonggo keysefe baassossin isaas dey ulfinto asu. Bar dey Ha'oosi taatonon abdik oodet feer. Wonaas beysani wonaastan zeemma fa hoossuni wona sinna boor'a digonoy Pilatosniki girire Yesusni dugnooson imanak mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatos dey: «Aakkak tai'ni kitiso?» yit diinqe. Tii taar'oni meeni gaanynyaasin teegsire: «Futok Yesus kitiyoso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tii taar'oni meeni gaanynyaaskin odenanneen orfo Yosefnik Yesusni dugnooson imi. ");
INSERT INTO jnjl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosef dey kinoni maama waagere mesqelistan dugnooson kessire kimme katera hoore shu'ni moogsi kabbare. Estan inya shu'a bukalsire moogaasi noononon uki. ");
INSERT INTO jnjl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Megdelawitki Maaraminewa Yosani into Maaramine Yesusni dugnooson ay kabbarsetemato biyedifar. ");
INSERT INTO jnjl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Beysani wona aatnanneen orfo Megdelawitki Maarami, Salome, Yaqobni into Maaramine yeesere Yesusni dugnooson woshshuk sawa wuzakin hoore shitto waagsete. ");
INSERT INTO jnjl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Torbaniisi tesuni wono e'so awa kesfana kabaasik moogaaski hamete. ");
INSERT INTO jnjl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Baassotna baassotna: «Shu'aason moogaasi noonotan innok bukalsunir oonso?» yiset faaser. ");
INSERT INTO jnjl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Es baron dey yisetees shu'aas akama inya sinna boor'a. Sinuntano kaanne biyeten shu'aas bukalera shaatenamato biyete. ");
INSERT INTO jnjl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Moogaassi girseten foro maya mayo na'o asu oi'ta wolusta diifen biire naysete. ");
INSERT INTO jnjl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Es na'o asus: «Nayotiita! Suutte Naaziretki Yesusnintu sholedifetimato arifawungwe. Bar kabi; hantak aafe; barin kunussete dimaason biyoti. ");
INSERT INTO jnjl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ese hamfaat nawoni meyaknawa phexirosna: ‹Nittok makenaasimato nittoostan zeemme Galiila hamnir. Estak biyati› yira maksoti» yi. ");
INSERT INTO jnjl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Es mashkasusikito digak korkiset moogaassin kessa eelese. Akamanon digsena boor'a isa wuzane ooknu aane maksowa. ");
INSERT INTO jnjl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesus Torbaniisi tesuni wono e'so kitun kabinanneen orfo zeemme naafun kiina ayyana barissin kisina Megdelawitki Maaramik beste. ");
INSERT INTO jnjl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bar dey hamma suumetnawa waasitna feese basa zoonsini meyak es baron make. ");
INSERT INTO jnjl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Baasso dey hayew sinbaasewa barik bestobaase odesefe kabaasik aane amantosoto. ");
INSERT INTO jnjl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Esseen orfo baassossin hep nawobaasakito beede hamefeen Yesus uguntak ooma gitok beste. ");
INSERT INTO jnjl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Baasso dey wolle hamme oom nawoni meyak maksete. Es baasso dey aane amanosoto. ");
INSERT INTO jnjl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Esseen orfo dey asire issees muu meesefeen Yesus baassok bestere: «Yesus kitun kabire kaak fe; inno dey aafniisik biini» yisere makse baassotin amano beyobesiisiknawa nibbesiisi chimakna baassotin ke'i. ");
INSERT INTO jnjl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tusire dey ekka yi: «Daasi birato zuuttambaase asiista hamti. Misirachchuni kaamaason asu zuuttambaase asik makoti. ");
INSERT INTO jnjl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Amanere haphukte bar faruna. Sinuntano amanonoy basaasta mangsu kater. ");
INSERT INTO jnjl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Amane baasso han besoson zagsone; ta sunaasik kiina ayyanaason kisusone; gaddo noonok wolumsone. ");
INSERT INTO jnjl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Zawaasikitonon ephone; woruni wuzanu ushefaatene baassotin isanne aafa miir'ona wuza. Kushubesiison mettanni meenista ta'usone baasso dey farsone.» ");
INSERT INTO jnjl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Daam Yesus es baron nawoni meyak makenanneen orfo den sama hami. Ha'oosi hoi'ta teshta di. ");
INSERT INTO jnjl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Baasso dey kesere daa daa zuuttambaase asiissi hamefaafe maksete. Daamiis dey baassoneen ane wostet feer. Biistera artonoy wuzani zaguk maksefe misirachchuni kaamaas futo sinbaason besit feer.");
INSERT INTO jnjl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ulfinto Tewofilosno; inno ganeyaassi sina chowaasikitonon besuni ticha zeemo sinak showoni meya tichisetewa. ");
INSERT INTO jnjl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Es tichaason dey innok aatiis tesubaastan kabgire aafak biya baassotnawa Ha'oosi kaamanon makset feese baassotnawa; ");
INSERT INTO jnjl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tanu ta teetaasik tesubaastan kabgira gasasira biinanneen orfo tochooson zeeme zoonsobaason oodda neek tichunak ma'ar sinna bestewa. ");
INSERT INTO jnjl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Es baron zaginaas ne odeta chowaas futo sinbaason arutakwa. ");
INSERT INTO jnjl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodis Yuudaki daasta taato sinna neyaasik Abiyani maagni wosto wostesefe baassossin sina Zakkariyas yiste isa maag feer. Bar dey Aaronni zalaassin sina Eelsabet yiste asuba faar. ");
INSERT INTO jnjl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hepobesiise Ha'oosi sina ooko sinne feeseter. Daamiisa kaamanonnawa tumaasonna zuuttambaase asin isa muda foontonon oodet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sinuntano Eelsabet zagiya sinna boor'a koonubesi aafa. Hepobesiise dey kur'sete. ");
INSERT INTO jnjl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Isa wono Zakkariyas basa wostoni taraasik betemeqdesiissi maagni wostooson wostedifer. ");
INSERT INTO jnjl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ukkoti maagni meeni tumaasimato Daamiisa betemeqdesiissi girire ixana kiichunak ixa barik kar'i. ");
INSERT INTO jnjl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Betemeqdesiissi ixanaas kiichchefana kabaasik dara zuuttere gerakalo yerefaat Ha'o shiiphedifer. ");
INSERT INTO jnjl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Daamiisa wosiya ixana kiichchefana shoo'aasi hoi'ta teshta yerefaat barik beste. ");
INSERT INTO jnjl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakkariyas wosiyaason biinaase nayere dige. ");
INSERT INTO jnjl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sinuntano wosiyaas: «Zakkariyasno digotaatawa! Shiiphonees odtewa. Asune Eelsabet arqa naanin tanonir. Sunbaason dey ‹Yohannis› yira sunsuta. ");
INSERT INTO jnjl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Basa koontoos neek akama gira sinanawa. Showo asuni meya dey basa koontoosik girosonewa, ");
INSERT INTO jnjl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bar Daamiisa sina arkirtu sinana. Wayinini usha sinun ooma zaysuni usha isanne aafa ushanawuza. Intobaasi keensi feegedo Korto Ayyanak tuumtona. ");
INSERT INTO jnjl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bar Israelni daraasasin showobesiisin Daama Ha'obesiiski wolguna. ");
INSERT INTO jnjl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Bar raajju Eeliyasnisimato Ha'oosi ayyanaknawa hugnakna Daamiisa sina zeemana. Abani meeni nibaason naanggotbesiiski, ajajamonoy baassotin kayimni meeni techmaassi wolguna. Daraasin daamiisik hoorere feer sinonek zaguna» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sinuntano Zakkariyas Ha'oosi wosiyak: «Han bar futo sinbaason awuk aruna? Ta kur'in, asunaas dey woggabaas koi'i» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ha'oosi wosiyaas wolgira: «Ta Ha'oosi sina yerefa Gabureliwa. Han misirachchuson neek makonak wostera yaanarwa. ");
INSERT INTO jnjl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sinuntano ne wonbaas kar'fana kabaasik sinni kaamnaason amano beyta boor'a han chowaas sinananneen nibtaatotu sinatawa. Wolla dey aafa chimata wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Es kabaasik asuni meya Zakkariyas kesananneen oodet feeseter. Betemeqdesiissin tai'ni kesa beybaasik diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zakkariyas betemeqdesiissin kesfena kabaasik asuni meyaneen wollok aane chime. Es bari boor'a betemeqdesiissi isa barik beste wuza faanamato asuni meya arsesete. Bar wollonoy kushubaasik besit feer. Esiisik nibtaato sinne fui'te. ");
INSERT INTO jnjl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakkariyas betemeqdesiissiki basa taraasi wostoni wona ko'ubaase keeba hami. ");
INSERT INTO jnjl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Garo wonaneen orfo asuba Eelsabet naanertera uuch assa keebaassi aachera di. ");
INSERT INTO jnjl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ekka dey yi: «Daamiis han ma'a wuzason taak zagiwa. Asusa ganesi fa kashistonaason tishki.» ");
INSERT INTO jnjl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Eelsabet naanertenari issunsa assaasik Ha'oosi wosiya sina Gabureli Galiilaki daasta fa Naaziretni katamaassi Ha'ooskin wostera hami. ");
INSERT INTO jnjl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wostera hamnaas Dawitni zalaassin sina Yosefnik teegtera di isa durba nawaki. Es durba nawaasi suna dey Maarami. ");
INSERT INTO jnjl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ha'oosi wosiya barki yaara: «Ne akamanon suustowe. Naga neek sinfawungwe. Daamiis neneen anetu fewe» ne mashkasusi ganesin suustowe yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maarami Ha'oosi wosiyani wollaasik akamanon nayefaat: «Han bar aakkati nagani ooshshonso?» yit safare. ");
INSERT INTO jnjl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ha'oosi wosiya Maaramik: «Ha'oosi sina adda danit sinna boor'a digotaatawe. ");
INSERT INTO jnjl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ese ne naanertotarwe, arqa naanin dey tanotar. Sunbaason dey ‹Yesus› yira sunsuta. ");
INSERT INTO jnjl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bar dey akamtu sinana. Zuuttambaase asiistan denalo sina Ha'oni Naa yisteretu teegtona. Daama Ha'oos ababa Dawitni zigimooson barik imnir. ");
INSERT INTO jnjl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yaqobni zalaasta koi'ba foontonon taattonir. Taatobaasnu koi'ba aafa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maarami Ha'oosi wosiyak wolgira: «Ta durbawa; han bar aakkak sinak chimnirin?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ha'oosi wosiya wolgira: «Korto Ayyana neyista yoona. Zuuttambaase asiistan denalo sina Ha'oosi hugna dey neyista kerona. Es bari boor'a koontoni Naas korto. Dey Ha'oni naa ustona. ");
INSERT INTO jnjl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ne koona sina Eelsabetnu kur'ubaastak arqa naani naanerte. Zagiya yiste bar naanertenaneen haniis issunsa asba. ");
INSERT INTO jnjl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ha'oosik chimtonoy wuza aafa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maarami dey: «Ta Daamiisa bozawa. Ese ne maketaasimato sinun» yi. Estan Ha'oosi wosiya kessa hami. ");
INSERT INTO jnjl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Es kabaasik Maarami taptanon kabira aamaasta fa Yuudani daastaki isa katamaassi hami. ");
INSERT INTO jnjl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakkariyasniki keer girira asuba Eelsabetnon naga ooshshe. ");
INSERT INTO jnjl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Eelsabet Maaramini nagaason odefana kabaasik katbaassi di nawaas fille. Eelsabet dey Korto Ayyanak tuumte. ");
INSERT INTO jnjl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kaambaason dey teggira: «Ne mashkasusi ganesin suustowe. Neekin koontoni bar dey suustowe. ");
INSERT INTO jnjl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Daamtaasa into taan mamsuk yoobaas awune fa akama ulfinanba! ");
INSERT INTO jnjl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ne nagaasi kaamanon odefana kabaasik katnaassi fa nawaas girak fille. ");
INSERT INTO jnjl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Daamiis makena baron zagunir sinbaason amane ne awune fa suustonse!» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maarami dey ekka yi: «Kaanaas Daamiisin galattonir; ");
INSERT INTO jnjl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Ha'oos kashisto wostinynya; sina taan biina boor'a; tuuma nibnaasi safarak; hetna sina Ha'onaasik girona. Hawungneen ekalo koontoos; zuuttera taan: ‹Ne suustowe› una. ");
INSERT INTO jnjl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Hugnaba faana Ha'oos; taak akama wuza zagina boor'a; sunbaas dey Korto. ");
INSERT INTO jnjl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ha'ooson digefe baassok; koontoostan aatta koontoosta kar'a fakuna. ");
INSERT INTO jnjl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Chima woribaasik hugnabaason besi; beegantefe baassotin nibbesiisi safaranon gedda sike. ");
INSERT INTO jnjl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Daason ha'sife arki arki meyanon zigimobesiistan kessi; sinuntano kashistefe baassotin ulfinak den teggi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Maktanni meyanon ma'a wuzak gawusi; otumni meyanon kushkush kalla kofki. ");
INSERT INTO jnjl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Abrahamniknawa basa zalaasikna; koi'ba foonto neya besina fakibaason safarok; Wostinynyaba sina Israelnin argasi; es baron zaginaas zeemoti abaniisakitonik imna abdini kaamaason koi'sukwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maarami dey keez assa sinni wona Eelsabetneen ane diira wolla keeba hami. ");
INSERT INTO jnjl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Eelsabet kophona wona kar'in arqa naanin kophe. ");
INSERT INTO jnjl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wolkobaasewa koonbaasikitone Daamiis akama fakiya barik zaginamato odesere barneen ane girsete. ");
INSERT INTO jnjl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nangirinsinari wono daag naasin haarkoni kunsuk asuni meya yeesete. Ababaasa sunak Zakkariyas yire sunsuk sholset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sinuntano intobaas: «Indaane, sunba Yohannis yisteretu suntona» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Baasso dey: «Ne kooniisasin han sunaasik sunter aafewe» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Estan ababa Zakkariyasnin: «Naanees oo yistere sunustonakinso sholefatari?» yire kushubesiisik besire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bar dey tichuni wuza imonek mamsire: «Sunba Yohanniswa» yire tichi. Zuuttambesiise es barik diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Geregere Zakkariyasni terma kotten Ha'ooson galattet wolle. ");
INSERT INTO jnjl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Es baristan kabi chowa wolkoni meya zuuttesere digesete. Es wollaasi chowa zuuttera kumaasta fa Yuudani daasi biratota wolumtera zi'i. ");
INSERT INTO jnjl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Es baron ode baasso zuuttere: «Han daag naa hanneen awu sinungeso?» yit baassotna baassotna mamussesete. Es bar sinnaas Ha'oosi argasu Yohannisneen ane faar sinna boor'a. ");
INSERT INTO jnjl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Es daag naasa aba Zakkariyas Korto Ayyanak tuumtere ekka yit raaji make. ");
INSERT INTO jnjl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Yaara darabaasin furena boor'anawa argasina boor'ana; Daama Israelni Ha'oosik galata sinfawung. ");
INSERT INTO jnjl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Es barnu ibe zeemma; Korto raajjuni meyaki kamo makenaasimato; wostinynyaba sina Dawitni zalaassin; akam fatunirin innok kabgi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Fu'enaas dey; gumayefe baasso kushuussinnawa; oomtesefe baasso kushuussinwa. ");
INSERT INTO jnjl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Es baron zaginaas inno abani meyak; fakibaason besunaknawa; girina korto teyyaason zagunaknawa; es girina teyyaason dey teyira imnaas; abani Abrahamnikwa. ");
INSERT INTO jnjl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Es abdini kaamaas; dey gumaniisa kushusin birmadumma kessa; isa diga foontonon barik wostet foonikwa. ");
INSERT INTO jnjl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Esiisimato dey neeniison zuuttambaase; Ha'oosi sina kortoknawa ookokna foonikwa. ");
INSERT INTO jnjl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Dey ne han daag naaso; zuuttambaase asi denalo sina Ha'oosi raajju ustotawa; ugnaason hoossutak; Daamiisa sina zeemma hamata. ");
INSERT INTO jnjl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Daamiis dey boor'besiison feeshun uuk; farsone ugnaasi arunon baassok imana. ");
INSERT INTO jnjl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ha'oniis fakirnawa kenashterna; sinbaasik faruni chaarefa denun innok chaaronak zaguna. ");
INSERT INTO jnjl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Bar talmaassinawa kituni tiishoossina fe baassok chaarsuna; Inno taaruuson dey nagani ugnak zoonsunakwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Daag naas dey dichi. Korto Ayyanaasik dey chimi. Israelni daraasik ammano bestona wona kar'ana kabaneen ichma daassi di. ");
INSERT INTO jnjl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Es kabaasik Romanni taate meeni taato Agustos Keesar basa ha'suussi fe asuni meya zuuttere darani faadak tichchosonek ajaji kesi. ");
INSERT INTO jnjl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Es tesuni darani faada zagtefana kabaasik Kemerewos Soriyani daason ha'sit feer. ");
INSERT INTO jnjl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Asu isarba isarbaas dey sunbaason tichchonak koontena daasta hamet feer. ");
INSERT INTO jnjl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosef koontenaas Dawitni zalaassin sinna boor'a Galiilaki fa Naaziretki katamaassin kabire Yuudani daastaki fa Dawit koontena katama Betelemi hami. ");
INSERT INTO jnjl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tichchok hamnaas naanertera fa teegere duusina nawa Maaramineen. ");
INSERT INTO jnjl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Betelemuk feeseten Maarami kophona wona kar'i. ");
INSERT INTO jnjl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Uzun naabaasi esta kophe. Irba ha'ifena keyaas asunik oottera ko'ina boor'a maama taksira miya muuba maafana magaassi kunsi. ");
INSERT INTO jnjl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Es daasta waali waalin nor'obesiison keemet ha'sefe keemerni meya feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Baassok dey Daamiisa wosiya diinqone beste. Daamiisa ulfinni chaarefa baasso biratoosta chaarsi. Baasso dey akamanon digsete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sinuntano Ha'oosi wosiya dey baassok: «Harewa digotiita! Asu zuuttambaase asin akamanon girsuni ma'a odu nittok ephpha yaanwa. ");
INSERT INTO jnjl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hash hawung han Dawitni katamaassi fatir sina Daam Kiristoos nittok koontewa. ");
INSERT INTO jnjl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Han bar nittok mallato sinana: Daag naa maama takistere miya muuba maafana magaassi kunfeen danati» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Geregere showo Samaki wosiya es Ha'oosi wosiyaasneen ane bestesera: ");
INSERT INTO jnjl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Den samak Ha'oosik ulfina sinfawungwa! han daastak dey; Ha'o shunfana asuni meya zuuttambesiise asik; naga sinfawungawa» yit Ha'ooson galattesete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ha'oosi wosiyaasikito oor kessa den sama hamnanneen orfo keemeriisakito baassotna baassotna: «Ese han sina baronnawa Daamiis innok besina wuzaase asinna biyanik Betelem hamniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Baasso dey taptak hamere Maaraminonnawa Yosefninna danete. Daag naas dey miya muuba maafana magaassi kunfeen biyete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Daag naasin dey biyetenneen orfo Ha'oosi wosiya baassok makena naasa chowanon maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Es keemeriisakito makena baron ode baasso zuuttere diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Sinuntano Maarami es chowaason zuutira nibbaassi ephaat safaret faar. ");
INSERT INTO jnjl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Keemeriisakito chowaas zuuttera Ha'oosi wosiya baassok makenaasimato sinin biyobesiisiknawa odobesiisikna Ha'ooson galattetnawa ulfinsitna wolle hamesete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nangirinsinari wono naas haarko kunana tumaasta zeemma intoba naanertonoyfeen Ha'oosi wosiya sunsina sunaasik «Yesus» yisetere sunte. ");
INSERT INTO jnjl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Museni tumaasimato kayimni tumaas zagtona wona kar'i. Es bari boor'a Yosefnawa Maaramine daag naasin Daamiisa sina tai'suk Yerusalem ephphe hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Es baron ekka zagsetees Daamiisa tumak: «Uzun sina arqa naa zuuttere Daamiisik imtere korto sinanar» yifa ajaji tichchera faar sinna boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Esiisimato Daamiisa tumaassi: «Hep ameta wedey hep nakaloni nawa maa'a imak sholsu» yifa ajaji faar. ");
INSERT INTO jnjl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Es kabaasik Simon yiste isa asu Yerusalemuk feer. Bar kaabaason Ha'ok imme fe ooko asu. Israelni faruni abdiison oodet feer. Korto Ayyanaas dey barneen faar. ");
INSERT INTO jnjl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bar Daamiisa muudtonin biinoy kitunoynamato Korto Ayyanaas barik ammanon besira faar. ");
INSERT INTO jnjl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Es wono Korto Ayyanaas Simonni kabgira betemeqdesiissi hamanak zagin hami. Yosefnawa Maaramine tumaas makenaasimato zaguk daag naasin ephphe betemeqdesiissi girseten, ");
INSERT INTO jnjl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simon dey daag naasin ephphe idimme Ha'ooson galattet ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Daamiiso! Ese! Taak imta Abdini kaamaas ko'iwa; haye wostinynyane sina taan; nagak den neeki ephwa. ");
INSERT INTO jnjl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ne fatuuson aafnaasik biingwa; ");
INSERT INTO jnjl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Es bar dey dara zuuttambaase asi sina hoossita barwa. ");
INSERT INTO jnjl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bar Aazabni meyak futooson ammanon besuni chaaref sinana; ne dara sina Israelni meyak ulfinawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yosefnawa Maaramine makte daag naasa chowak diinqeset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simon dey baassotin suusnanneen orfo daag naasa intok: «Han daag naas Israelni meyak showobesiisik tishuk, showobesiisik dey faruni ugnatu sinana. Barin showobesiis ephphetoo beyobesiis beso sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Es barik showo asuni nibsi aachera fa safara ammanon kessa bestona. Nibneeson dey suumoni siifoos kalasira aatana» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Es kabaasik Aaserni zalaassin Fanuelni nawa Haanna yiste isa raajju faar. Bar dey akamanon kur'u. Teegobaasseen ane naafunasir wogga ane diisefeen bar kiti. ");
INSERT INTO jnjl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Esseen orfo woggaba nangnasire acheechche kar'ananneen wonna wonna betemeqdesiissin tishunoy soomera shiiphet Ha'oosik wostet faar. ");
INSERT INTO jnjl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bar dey es kabaasik geregere yaara Ha'ooson galatte. Daag naasa chowanon Yerusalemni furtooson oodet feese baassok zuuttambesiise asik maket faar. ");
INSERT INTO jnjl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosefnawa Maaramine Daamiisa kaamsi makte tumaason koi'issetenneen orfo Galiilaki daasta fa feesefe katama Naaziret wolsete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Daag naas dey dichetnawa zagitna hami. Techmak dey tuumi. Ha'oosi otma barneen ane faar. ");
INSERT INTO jnjl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yosefnawa Maaramine wogga woggaasik Ayhudni faasikani heebooson ulfinsuk Yerusalem hamet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesus asire heppe woggaba sinfana kabaasik zagtet faanaasimato heebooson ulfinsuk Yerusalem hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Heeboos koi'inanneen orfo Yosefnawa Maaramine keebesi wolsere hamefe kabaasik Yesus Yerusalemuk fu'te. Sinuntano baasso es baro aane arsoto. ");
INSERT INTO jnjl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bar ugunni wofiisseen anetu fewa yisefaat isa wonni ugna hamete. Estan arsefe koonbesiiskinawa zomobesiiskina sholok kabsete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sholere turuksetenneen orfo wolle Yerusalem hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Keez wonaneen orfo betemeqdesiissi assife baasso ganeyaassi diifaat odefennawa mamsu mamsifeenna danete. ");
INSERT INTO jnjl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ode baasso dey zuuttere gasasubaasiknawa wolgifena wolgusikna diinqeset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yosefnawa Maaramine dey betemeqdesiissi barin biyeteese diinqesete. Intobaas dey: «Naataaso! Awuni boor'a innoti ekka zagitso? Abaneesneen taneen innotin tiir'o ephaan neen sholet faanirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesus wolgire: «Awuniron taan sholefeti? Abataasa keer foonak sholsu sinnamato aane aruwetino?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sinuntano bar makena chowaas baassok aane galowa. ");
INSERT INTO jnjl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Estan Yesus baassoneen ane wolle Naaziret hami. Baassok dey ma'i yire ajajamet feer. Intobaas dey es chowaason zuutira nibbaassi ephaat faar. ");
INSERT INTO jnjl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus dey techmak; yer'aknawa addakna Ha'oosi sinaknawa asusa sinakna dichet feer. ");
INSERT INTO jnjl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Romanni taatoosa taato Tibariyos taattena asire uuchche woggaasik Pentenawi Pilatos Yuudaki daason ha'sit feer. Herodis dey Galiilaki daason ha'sit feer. Esiisimato dey ayba Filiphoos Ituriyasnonnawa Tikonidosnonna ha'sir. Lisaniyos dey Absanisno ha'sir. ");
INSERT INTO jnjl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Haannanawa Keyyaffana maagni gaanynye meeni gaanynya; es kabaasik Zakkariyasni naa Yohannis ichma daassi feen Ha'oni kaama barki ya. ");
INSERT INTO jnjl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Es bari boor'a Yohannis Yordanosni akaasi biratota fa daa zuuttambaase asiissi kutifaafe: «Boor'nitiisi fakiyanon danatik harmira haphuktotiwa» yit maket feer. ");
INSERT INTO jnjl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Es bar dey sinnaas raajju Isayyas Yohannisni chowaasik ekka yit tichinaasimatowa: «Ese han bar ichma daassi ekka yit chaagfe asuni kaamawa; ‹Daamiisa ugnanon hoossuti! Ugnaason dey sapsira hoi'issuti! ");
INSERT INTO jnjl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Doo'aas zuuttera kachchera tuumun! Aamaasewa kumaase dey zuuttera golon! Halda ugnaas zeephton! Kecha kecha ugnaas danaron! ");
INSERT INTO jnjl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Asu zuuttere Ha'oosi fatunon biyo!› » ");
INSERT INTO jnjl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Haphuktok Yohannisniki ye asuni meyak ekka yit feer: «Nitto ufoni naanggota! Yoonak fa Ha'oosi gi'sin eella kesatik oonso nittok makeri? ");
INSERT INTO jnjl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ese harmuntiison besifa wosto wostotitano nibnitiissi: ‹Inno Abrahamni naanggotawa› yit teetefeti baron beyti. Ha'oos han kuni shu'aasikitosin kabgira Abrahamnik naanggota zaguk chimanamato nittok makefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hash i'ooson tasbaassi kar'a ha'uni anfala hoorera faarwa. Es bari boor'a ma'a gaana gaannoy i'oos zuuttera katera geyaassi ha'tonirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Daraas dey Yohannisnin: «Eekin awu zagunirinso?» yire mamussesete. ");
INSERT INTO jnjl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohannis wolgire: «Hep maamba feena bar isaason maamba foontoosik imowa. Muuba feena bar muuba foontoosik bagge imowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Girbo zuutife baasso dey haphuktok barki yeesere: «Assinynyano! Inno dey awu zagunirinso?» yit mamussesete. ");
INSERT INTO jnjl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Bar dey: «Makte ajajiistan daysira mamsutiita» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Meya taar'oni meya dey yeesere: «Inno dey awu zagunirinso?» yire mamussete. Bar dey wolgire: «Asusa waaganon hugnak bo'otiita. Ooninnu sinfaanane eshak malatotiita. Nittok imtefa wostoni waagaas hoorona» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Es neyaasik asuni meya zuuttere Kiristoosni yooson abdik oodet feeseter. Es bari boor'a Yohannisnin: «Han asu awuzakne Kiristoos sina beyungeso?» yit nibbesiissi safarsete. ");
INSERT INTO jnjl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohannis zuuttambesiise asik ekka yi: «Ta nittotin akaktu haphquna. Sinuntano tayistan denalo chaa'mabaasi taar'anonnu kotanak sholsuoonar yoonir. Bar Korto Ayyanaknawa geyaknatu nittotin haphquna. ");
INSERT INTO jnjl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Bar oodaastaki meyaason sama ha'unak manshi kushubaassi faar. Kayninanneen orfo kayma meyaason botoossi gaagnir; kadnaason dey tishunoy geyak kiichunir» ");
INSERT INTO jnjl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Esiisimato Yohannis showo ugnak daraasin kiitit Ha'oosi ma'a odunon maket feer. ");
INSERT INTO jnjl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sinuntano Galiilanon ha'sit fe Herodisnin ayba Filiphosni asu Herodiyadano ephna boor'anawa ooma showo mangsubaasikna barin ke'i. ");
INSERT INTO jnjl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodis es mangsubaasta daysire Yohannisnin taatoni keer gedi. ");
INSERT INTO jnjl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Daraas zuuttere haphuktere kesnanneen orfo Yesus dey haphukte. Bar Ha'ooson shiiphefeen sama gachche. ");
INSERT INTO jnjl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Korto Ayyana nakalone faar sinna basaasta kere. Es kabaasik: «Keeshtefana naataas newa; neektu girefawungwa» yifa kaama saman ya. ");
INSERT INTO jnjl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus daraasi assuk kabifena kabaasik keezasir woggaba sinana. Daraasik Yesus Yosefni naa sinnamatotu bestefa. Esiis dey Yosef Eelini naa. ");
INSERT INTO jnjl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eeli Matini naa; Mati Lewini naa; Lewi Milkini naa; Milki Yonanni naa; Yona Yosefni naa; ");
INSERT INTO jnjl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosef Matatiyyuni naa; Matatiyyu Amosni naa; Amos Nahomni naa; Nahom Esilimni naa; Esilim Naageni naa; ");
INSERT INTO jnjl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naage Ma'aatni naa; Ma'aat Matatiyyuni naa; Matatiyyu Semeyni naa; Semey Yosefni naa; Yosef Yodani naa; ");
INSERT INTO jnjl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda Yonanni naa; Yonan Reesni naa; Rees Zerubabelni naa; Zerubabel Selatiyalni naa; Selatiyal Nerini naa; ");
INSERT INTO jnjl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Milkini naa; Milki Hadini naa; Hadi Kosamni naa; Kosam Elmodamni naa; Elmodam Erini naa; ");
INSERT INTO jnjl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri Iyyasuni naa; Iyyasu Eliazarni naa; Eliazar Yuramni naa; Yuram Matatni naa; Matat Lewini naa; ");
INSERT INTO jnjl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi Simonni naa; Simon Yuudani naa; Yuuda Yosefni naa; Yosef Yonanni naa; Yonan Eliyakimni naa; ");
INSERT INTO jnjl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim Meliyani naa; Meliya Maynanni naa; Maynan Matatni naa. Matat Natani naa. Nata Dawitni naa. ");
INSERT INTO jnjl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawit Isseyni naa. Issey Iyyobedni naa. Iyyobed Boyezni naa. Boyez Salimonni naa. Salimon Ne'asonni naa. ");
INSERT INTO jnjl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ne'ason Aminadabni naa. Aminadab Aaramni naa. Aaram Aarinini naa. Aarini Eesiromni naa. Eesirom Faresni naa. Faares Yihudani naa. Yihuda Yaqobni naa. ");
INSERT INTO jnjl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yaqob Yisaqni naa. Yisaq Abrahamni naa. Abraham Taarani naa. Taara Nakorni naa. ");
INSERT INTO jnjl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor Serohini naa. Serohi Rehuni naa. Rehu Felegni naa. Feleg Eberni naa. Eber Shelahini naa. ");
INSERT INTO jnjl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelahi Kayinni naa. Kayin Afarkisadni naa. Afarkisad Semni naa. Sem Noohni naa. Nooh Lamehini naa. ");
INSERT INTO jnjl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamehi Matusalani naa. Matusala Henokni naa. Henok Yaaredni naa. Yaared Melalielni naa. Melaliel Kayinanni naa. ");
INSERT INTO jnjl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinan Henosni naa. Henos Seetni naa. Seet Addamni naa. Addam Ha'oni naa yiset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus Korto Ayyanak tuumme Yordanoski akaassin woli. Estan ichma daa hamanak Korto Ayyana barin zoonsi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ichma daassi feen acheechasir wona Daabulos boor'a wostonak mamsi. Es wonaassi isanne aane muwe sinna boor'a koi'baasta makte. ");
INSERT INTO jnjl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Daabulos dey Yesusnin: «Ese ne Ha'oni naa sinfaatane han shu'aason tusha sinanak ajajowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesus dey: « ‹Asu tusha tushak aane feefe› yistera tichchera faar» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Estan dey Daabulos Yesusnin isa tega dimta kisi. Han daasta fa taatoosikitonon zuutire isarga walgire besaat: ");
INSERT INTO jnjl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","«Han daasi ha'suusewa ulfinbaase zuutira neek imanawa. Han bar zuuttera taak imte sinna boor'a ta sholena barik imak chimanawa. ");
INSERT INTO jnjl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Es bari boor'a ne taak sagadefaatane han bar zuuttambaase neer sinanawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesus wolgire: « ‹Daama Ha'oneesik sagado. Bar baron shiipho› yistera tichche» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Esseen orfo Daabulos Yesusni Yerusalem betemeqdesiisi teetta taamme yeetaat: «Ne Ha'oni naa sinfaatane hantan yeet daasta fillebbo. ");
INSERT INTO jnjl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‹Neen oodosonak Ha'o wosibaason ajajona. ");
INSERT INTO jnjl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Dey wochonees shu'aasta tuusa'onoynamato kushubesiisik teere neen ephonewa› yistera tichchera faarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesus dey: « ‹Daama Ha'oneeson fattanotaata› yistera tichchera faar» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Daabulos Yesusnin fattanere koi'sinanneen orfo kar'o danne wolunanneen es kabaasik beyye hami. ");
INSERT INTO jnjl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesus Korto Ayyanani hugnak tuumme wolle Galiila ye. Basa chowaasi wolla es biratoosta fa ke'eessi tuumi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Bar Ayhudni shiiphoni keyaasikitosi baassotin assit feer. Zuuttambesiise barin galattesete. ");
INSERT INTO jnjl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Esseen orfo Yesus dichna daa Naaziret ye. Zeemoti zagit feenaasimato beysani wonaasik Ayhudni shiiphoni keyaassi hamme Ha'oosi kaamanon feretunak kabi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Raajju Isayyas tichina matsafanon imtete. Woore ekka yistera tichche dima dani: ");
INSERT INTO jnjl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Daamiisa Ayyana tayistatu fa; tukamni meyak ma'a misirachchuni oduuson makonak taassi; taatere feese meya kottosonek; aaftishuni meya biyosoneknawa; rakkoossi feese meyanon; birmadumma kisunaktu taan muudi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dey Daamiis darabaasin fatuna; woggaason awajonaktu taan wosi.» ");
INSERT INTO jnjl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Feretaat tichaason birire wostinynyaasik imaat di. Ayhudni shiiphoni keyaassi diise baasso zuuttere barin kootkire biya ephete. ");
INSERT INTO jnjl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bar dey baassok: «Hashti ferettefeen odeti matsafaasi kaama hash hawung ko'iwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Baasso zuuttere basa chawaason ma'arik wolumsete. Wollefena akama keeshu kaamaasik diinqeset: «Han bar Yosefni naastenoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesus baassok: « ‹Ne hetni asuno; teetneeso fatuwa!› yifa besoson tayista makotimato arifawungwa. Esiisimato dey Kifirnahomuk: ‹Zagit yisten odeni baron zuutira han koonteta daastak dey zaguwa› yisefeti» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Futo nittok makefawungwa; Raajjuus koontena daastaki asubaas barin aane ulfinsife. ");
INSERT INTO jnjl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«Futooson nittok makonawa; raajju Eeliyasni neyaasik keez wogganewa issun assane iro aane icha sinna boor'a daa zuuttambaase asiista akama maka sini. Es kabaasik Israelni daasta showo dicha asu faaser. ");
INSERT INTO jnjl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sinuntano Eeliyas Sidona yistefa daasta fa Sirapta yistefa ke'eessi isa dicha asukitu wostere hamiteno ooma ookinu aane wostere hame. ");
INSERT INTO jnjl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Esiisimato Raajju Eelsani neyaasik Israelni daasta showo awataatoni mettan feeseter. Sinuntano Soriyaki awataatoni mettan sina Niimantu farirteno baassossin oonu aane faruwe.» ");
INSERT INTO jnjl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayhudni shiiphoni keyaassi diise baasso zuuttesere es baron odeseteyse akamanon gi'tesete. ");
INSERT INTO jnjl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kabserenu Yesusni guchche zatte katamaasi gerakalo kissete. Gawuussi tugire ha'uk sholsefaat baasso katamaas keetena kumaasta ephphe kesete. ");
INSERT INTO jnjl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sinuntano bar baasso ganeyaassi kamo aatte hami. ");
INSERT INTO jnjl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Estan Yesus Galiilaki daasta fa Kifirnahom yiste katamaassi hami. Estak beysani wonaasik daraasin assit feer. ");
INSERT INTO jnjl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Assifena kabaasik ha'suni hugnaba feena asunimato sinna boor'a diinqeset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Es Ayhudni shiiphoni keyaassi kiina ayyana ephna isa asu feer. Bar dey chaaget ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Naaziretki Yesusno! Inno neneen ane awuni isarni faarinso? innoti tishkutak yaataroso? Ne oo sintamato ta arifawungwa; Ne Ha'oosi Kortowa!». ");
INSERT INTO jnjl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesus kiina ayyanaason: «Isa kaama kotnoy asusasin kes!» yire ke'i. Kiina ayyanaas daraasa sina asusin gansira isanne miir'onoy gafkira kesi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Asuni meya zuuttambesiise baassotna baassotna: «Han maktefa kaama aro kaamanso? Akama ha'suni hugnaknawa kaambaasi giidokna kiina ayyanaason ke'in barikito dey gafkira kesar» yiset diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesus zagina chowaasi wolla es daasi biratota wolumtera zi'i. ");
INSERT INTO jnjl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus Ayhudni shiiphoni keyaassin kesse Simonni keer hami. Estak Simonni asusi into gumtanni mero mettera kunir sinna boor'a: «Yesusnin fatuwa» yisere shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus dey barki tesha tai'sere yerefaat meroos baro kofkunak ajajen meroos dey baron gafki; daakun kabira baassotin irbasi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Awa girifana kabaasik asuni meya showo tesa merok mettere feese mettanni meyanon zuutire Yesusniki ephphe yeesete. Bar dey isa isarbesiisata kushubaasik ta'ire fati. ");
INSERT INTO jnjl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kiina ayyanaasikito dey showo asunisin: «Ne Ha'oni naawa!» iyaafa chaagga keset faaser. Bar Muudto sinbaaso kiina ayyanaasikito arser sinna boor'a Yesus: «Isa kaamane kotataata!» yire ke'ire kali. ");
INSERT INTO jnjl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wonfana kabaasik Yesus estan kesse asu foonto fuchcha dimta hami. Asuni meya barin sholere danere: «Innotin beyya hamataatawa» yit shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sinuntano Yesus baassok wolgire: «Ta wostera yaanaas es barik sinna boor'a Ha'oosi taatoni Misirachchuni kaamanon ooma katamaassi fe asuni meyak hamma makonak sholsuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Es bari boor'a Yuudani daasta fa Ayhudni shiiphoni keyaasikitosi girifaafe kaambaason maket feer. ");
INSERT INTO jnjl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Isa wona Yesus Gensaretki Baarisi ha'a feen showo asuni meya ek barki tai'sere Ha'oosi kaamanon odok tugset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bar es Baarisi ha'a yere hep goonu bi. Kurxummi eshefe baasso goonuussin kerere yugudobesiison mei'sedifer. ");
INSERT INTO jnjl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesus Simoonnir sina goonuussi giri. Simoonnin: «Han goonuuson daastan ek akaasta garonon taak chiksuwa» yi. Estan goonuusta diifaat esta fe daraasin assi. ");
INSERT INTO jnjl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wolumbaaso koi'sinanneen orfo Simoonnin: «Goonuuson tir'maasta eksaat neneen zomoneesakitoneen Kurxummiison eshak yugudontiison tir'maassi ha'utiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon wolgire: «Assinynyano! Waalaason zuutira kabet ha'ira isanne aane daneniwa. Sinuntano hash ne maketanneen kurxummiison eshak yugudooson akaassi ha'unawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Es baron zagsobesiise yugudoos karatonanneen akama showo kurxummi hophete. ");
INSERT INTO jnjl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Estan ooma goonuusta fe zomobesiisakito yeesere argassonek giphsok teegsete. Baasso dey yeesere hep goonuuson akaas koor'ananneen kurxummik tuunisete. ");
INSERT INTO jnjl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Barnawa basa zomosakitona zuuttere ephete kurxummiisi aatamak akamanon diinqesete. Simon Phexiros dey sina chowaason biyaat Yesusni sina kaa'nere: «Daamiiso! Ta boor' sinna boor'a tayistan eksowa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Esiisimato Simonni zomo sina Zebdewosni naanggotiis Yaqobnawa Yohannisna diinqesete. Yesus Simoonnin: «Harewa digotaata! Hawungneen ekalo asuni meyanon Ha'ooski zuutunir sinatawa.» ");
INSERT INTO jnjl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Baasso dey goonubesiison akaassin kisire daasta kunsaat zuuttambaase asin beyye Yesusni nawo sinete. ");
INSERT INTO jnjl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Isawa Yesus isa katamasi feen atubaason awataatoni mero koi'sina asu barin biire sinba kaa'nefaat: «Daamiiso! Sholefaatane taan kayimsuk chimatawa» yit shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus kushubaason shongere atubaason taptifaat: «Sholefawungwa! Faruwa!» yi. Geregere merobaassin fari. ");
INSERT INTO jnjl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tusire dey Yesus: «Han sina chowaason ooniknu makotaatawa. Sinuntano hamfaat kayimneeson maagnik besuwa. Asusik zaala sinanak kayimneeson besifa Muse ajajena maa'aason imma» yire ajaje. ");
INSERT INTO jnjl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesus zagina chowaasi wolla zeemotiistan tagi. Showo asuni meya barkin odoknawa merobesiissin farusonekna sholsefaat zuutteset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sinuntano Yesus bar bar showo wona shaato dimsi hamfaafe shiiphet feer. ");
INSERT INTO jnjl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Isa wona Yesus asuni meyanon assifeen Ferisawini meenewa Museni tumaasi assinynyani meena basa tesha diisefer. Es baasso Galiilannawa Yuudaki ke'e zuuttambaase asiissina dey Yerusalemunna yeeseter. Yesus mettaniisin fatuna Ha'oosi hugna barneen ane faar. ");
INSERT INTO jnjl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Asuni meya isa laafa asunin kuphota wor'ere Yesusniki yeesete. Laafaasin Yesus feena keyaassi gedde basa sina kunsuk sholsete. ");
INSERT INTO jnjl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sinuntano asusa showotan kabi chowa laafa asusi keer gedak aane chimoto. Es bari boor'a keyaasi tukta kesfaat yiiroson bogge laafaasi kuphobaase keer gedde asusa ganesi Yesusni sina kunussete. ");
INSERT INTO jnjl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus baasso amantooson biyaat laafaasin: «Ne han asuso! Boor'nees feeshun yistewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Museni tumaasi assinynyanawa Ferisawini meena: «Ha'oosta mei'ni kaama makefees han bar oonso? Boor'aason feeshun uuk chimniis Ha'o bar bartano oom oonso?» yit nibbesiissi safarsete. ");
INSERT INTO jnjl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesus dey nibbesiisi safaranon arifaat: «Nibnitiissi awuniron ekka safarefetiso? ");
INSERT INTO jnjl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‹Boor'nees feeshun› yistewa uustannawa: ‹Kabira hamma› uustanna aaffarinso kashoyi? ");
INSERT INTO jnjl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sinuntano Asuni Naa han daasta boor'aason feeshun una ha'suni hugnaba faanamato arutik sholsifawa» iyaat laafaasin: «Ne han asuso kabira kuphoneeson wor'a keene hamma!» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Geregere laafaas asusa sina kabire kunna kuphooson wor'e Ha'o galattet keeba hami. ");
INSERT INTO jnjl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Es baron biya asuni meya akamanon diinqoknawa digakna: «Hawung diinqi wuza biini» yiset Ha'ooson galattesete. ");
INSERT INTO jnjl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesus estan kesse hamfena kabaasik Lewi yiste girbo zuuti asu girbo zuuttefana keyaassi diifaat waaga zuutifeen biire: «Taneen ane hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi fa wuzason zuutire beyfaat kabire Yesusneen ane hami. ");
INSERT INTO jnjl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Estan Lewi keebaassi Yesusnik akama koota hoossi. Es kootaasta showo girbo zuutife baassonawa oom irbana teegtere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ferisawini meenewa baasso keen sina Museni tumaasi assinynyana Yesusni nawoosakitonita: «Nitto awagan girbo zuutife asuni meyaneennawa boor'inynyani meyaneenna isarik maara ushtifetirinso?» yit unyisete. ");
INSERT INTO jnjl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus dey wolgire: «Mettanni meyaktano fayyanik hetni asu aane sholsifewa. ");
INSERT INTO jnjl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ta yaanay boor'ni meyanon Ha'ooski wolguktano kayimni meyanon teegok aane yootwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Baasso dey: «Haphqife Yohannisni nawoosnawa Ferisawini meeni nawoosakitona showo wona soomere Ha'o shiiphseter. Sinuntano ne nawoosakito awuni boor'anso meere ushefeysi?» yire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus wolgire: «Mariis ane feen mozgituusakito soomere shiiphosonanne faar sinna bestefawoso? ");
INSERT INTO jnjl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sinuntano mari baassostan oor kesana wona yoona. Es kabaasik soomere shiiphosonewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tusire dey Yesus isa beso baassok make: «Gaddo mayaastan erbe kar'e kur'u mayta kunsire zoorifer aafe. Zagtefaanane gaddooson karasir. Gaddo erbees dey kur'usneen isar aafa sinanawuza. ");
INSERT INTO jnjl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Esiisimato dey kur'u ha'matosi gaddo wayinini usha gedfe asu oonu aafewa. Gedfaanane gaddo wayinini ushaas ha'matooson karasir; bar dey wuukter; ha'matoos dey ke'nor sinar. ");
INSERT INTO jnjl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ora wayinini ushaason gaddo ha'matosi geda sholsifa. ");
INSERT INTO jnjl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Showo wona kaagga di wayinini ushaason usha asu gaddooson ushanak aane sholefe. ‹Kaaga wayinini ushaastu ma'arwa› utu una» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Beysani wonak Yesus foshaasta kamo aatte hamfeen basa nawoosakito zagoni bona buggire mo'e koyete. ");
INSERT INTO jnjl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ferisawini meyaassin isa isaas: «Beysani wonak zagtonak sholsunoy wuzason awuniron zagidifetirinso?» yire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus wolgire: «Dawitnawa barneen ane fe asuni meena maktesefe kabaasik bar zagina baron aane feretira biyetinoso? ");
INSERT INTO jnjl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ha'oosi keer girire maagni meyaktano oom asu muunoyna Ha'ok imto tushaason ephphe me. Barneen feese baassok dey imi» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Estan Yesus: «Asuni Naa beysani wonaasi daamwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ooma beysani wonak dey Ayhudni shiiphoni keyaassi girire assit feer. Esta hoi'ta kushuba laafa sina isa asu feer. ");
INSERT INTO jnjl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Museni tumaasi assinynyanawa Ferisawini meena Yesusni malassone ugnani danak sholsefaat: «Beysani wonaasik asunin fatunitto biyaniwa» yit oodet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sinuntano Yesus baasso nibaasi safaranon arifaat kushuba laafa asusin: «Kabira ganeyaassi yerowa» yi. Bar dey kabire ganeyaassi yere. ");
INSERT INTO jnjl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Estan baassotin: «Ta nittotin mamsunawa; Beysani wonaasik ma'aron zagungwa wedey mangunon zagunso? Kaani fatungwa wedey tishkunso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Biratobaasta fe asusi zuutire biinanneen orfo laafa asusin: «Kushuneeson zeephwa» yi. Bar dey zeephin Kushubaas dey fari. ");
INSERT INTO jnjl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Museni tumaasi assinynyanawa Ferisawini meena akamanon gi'tesere Yesusniista awu zagsonemato baassotna baassotna merkesete. ");
INSERT INTO jnjl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Es wonaassi Yesus shiiphonak den aamaasta kesi. Es Waalaason zuutire Ha'ooski shiiphet ha'i. ");
INSERT INTO jnjl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wonfana kabaasik nawobaasakitonin barki teege. Baassossin asire heppeesin korire: «Wosi» yire teege. ");
INSERT INTO jnjl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Baasso dey Phexiros yire teegena Simonnawa ayba Indiriyas, Yaqob, Yohannis, Filiphoos, Bertelemewos, ");
INSERT INTO jnjl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maatiwos, Tomas, Ilfiyosni naa Yaqob, kooner yistefe Simon, ");
INSERT INTO jnjl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yaqobni naa Yihudanawa orfo Yesusni aatire ima Askorotki Yuudanawa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus wosibaasakitoneen aamaastan kerere golo daasta yere. Nawoni meyaassin showobesiis dey esta feeseter. Esiisimato showo asuni meya barkin odosoneknawa merobesiissin farsonekna Yuudani daasta fa Yerusalemni katama; baarisi ha'taki fa katama Tirosunnawa Sidonanna ye showo dara feer. ");
INSERT INTO jnjl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kiina ayyanak oottere mettet feese baasso dey farsete. ");
INSERT INTO jnjl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ha'oosi fatuni hugna Yesusniissin kesfaafa zuuttambesiise fatit faar sinna boor'a esta zuuttere feese asuni meya barin ta'isere farsonek sholset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus nawobaasakitoniki yerqere biyet ekka yi: «Ha'oosi taatoni ha'su; nittor sinna boor'a; nitto tukamiis suustowa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hash maktet fe nitto; gawutir sinna boor'a suustowa. Hash waassefe nitto; woli mi'atir sinna boor'a suustowa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Asuni Naa sina ta boor'a asuni meya nittotin oomtesere, korire, kashshiserenawa nittok mangu suna imefe kabaasikna nitto suustowa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Samak waagnitiis akama sinna boor'a han bar zuuttambaase nittoosta kar'fana kabaasik giroti dey filloti. Zeemoti ababesiisakito dey raajjuni meyaasta ekkatu zagsete. ");
INSERT INTO jnjl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Sinuntano nitto otumno! Han daastaki foontiisik; sholsu wuzason daneti boor'a; habuntiwa; ");
INSERT INTO jnjl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hash gawi nitto; woli maktotir sinna boor'a; habuntiwayerefawutiwa; hash mi'fe nitto; woli suumera waasutir sinna boor'a; yerefawutiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«Asuni meya zuuttere mai'nitiison maksefe nitto habuntiwa. Baasso abaasnu eshni raajjuni meyak ekkatu zagsetewa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Sinuntano odefe nittok ekka yifawungwa, gumantiisin shunti. Nittotin oomtefe baassok ma'aron zaguti. ");
INSERT INTO jnjl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nittotin erwife baassotin eebbisuti. Nittotin miir'efe baassok dey shiiphoti. ");
INSERT INTO jnjl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Isa gachneeson bocha barik hepsaason dey bochanak besu. Kootineeson ephfe barik shaamisineeson daysira imma. ");
INSERT INTO jnjl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Neekin shiiphefe baassok imma. Waagneeson epha barin neek wolgunak mamsutaata. ");
INSERT INTO jnjl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Asuni meya nittok zagsonek sholefeti baron nitto dey esiisimato baassok zagutiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nittotin shunfe baassotin shunfaatine aro gaddo wuza danatirinso? Boor'ni meyanu baassotin shunefe baassotintu shunefe. ");
INSERT INTO jnjl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma'aron nittok zagi baassok ma'aron zagifaatine aro gaddo wuza danatirinso? Boor'ni meyanu esiisontu zagsefewa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","‹Kowa kaassonewa› iyaat baassok liqsaatine aro gaddo wuza danatirinso? Boor'ni meyanu es liqsisete baron wolgire ephaasik boor'ni meya boor'ni meyaktu liqessisefewa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sinuntano nitto gumantiisi shunti. Baassok dey ma'aron zaguti. ‹Wolgira ephaniwa› yira abdi zagunoy liqessuti. Es baron zagaatine waagnitiis akama sinana. Dey zuuttambaase asi denalo sina Ha'oosi naanggota sinati. Ha'oos baron galattonoy baassokneennawa manguni meyakneenna garamawa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Samaki Abantiis kenashter sinna boor'a nitto dey kenashter sintiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Ooniistanu mangsu kar'atiita; nittoosta dey aafa mangsu katona wuza. Nitto asuniista nalga wostotiita; nittoosta nalga aafa sinanawuza. Feeshun uti nittok dey feeshun ustona. ");
INSERT INTO jnjl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Imtiwa; nittok dey imtona. Safarera imti safareesik wolla nittok safartera imtona. Ma'a safarek tuumma tichera tiir'era woottonanneen safartera nittok imtonawa.» ");
INSERT INTO jnjl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dey han besoson ekka yit make: «Aaftishu aaftishuni zoonsuk chimniroso? Zoonsifaanane hepobaase ane zatere gawuussitu gandosonawa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Arinynyaas assinynyaasatan denalo aafa sinanawuza. Sinuntano mai'sire ari arinynyaas assinynyaasne feer sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ne aafaassi yere inya i'ooson biinoy ayneesa aafsi kuni diimaason aakkak biitso? ");
INSERT INTO jnjl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne aafaassi yere i'ooson biinoy aakkak ayneesin: ‹Aytaaso aafneessi kuni diimaason kisunaroso?› uuk chimisso? Sinnoy sinne bestefe ne zeemma aafneessi kuni i'ooson kisuwa. Estan ayneesa aafsi kuni diimaason gasasira biyak chimatawa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Ma'a i'oos mangu gaana aane gaanfa. Esiisimato dey mangu i'o ma'a gaana aane gaanfa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","I'o zuuttambaase gaambaasiktu artefa. Seer'akin belesini gaana aane kephtefa. Alaluussin wayinini gaana aane kephtefa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma'a asu nibbaassi fa ma'a chowaasontu kisife. Mangu asu nibbaassi tuuma mangu chowaasontu kisife. Asu nibbaassi tuumma fu'te barontu noonobaasik wollefe. ");
INSERT INTO jnjl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ta makena baron zagunoy awuniron: ‹Daamiiso! Daamiiso!› yit taan teegefetiso? ");
INSERT INTO jnjl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Taaki yooni barnawa kaamnaason odere wostota feeshife barna oone feer sinnamato makonawa. ");
INSERT INTO jnjl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bar doo'aason akamanon yiishshe kaa'oosta keebaason keer'a asune feerwa. Omara yaara es keyaason tugin es keyaas yiishtera keetena boor'a shorkunak aane chima. ");
INSERT INTO jnjl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kaamnaason odere wostota feeshunoy bar keebaason mai'sire yiihnoy fuutuusta keer'a asune feerwa. Omaraas yaara keyaason tugifana kabaasik geregere gande. Gandobaasnu akamanon mangu sini» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus es baron zuuttambaase daraasik makere koi'sinanneen orfo Kifirnahom yistefa katamaassi hami. ");
INSERT INTO jnjl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Estak isa Romanni tii meya taar'oni meeni gaanynya feer. Bar dey isa shunfena wostinynyaba akamanon mettere kituk tai'sere feer. ");
INSERT INTO jnjl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Es tii meya taar'oni meeni gaanynyaas Yesusni chowaason odenayse Ayhudni kur'uni meyanon: «Yesus yeere wostinynyataasin fatunak hamma taak shiiphotiwa» yire barki wosi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Baasso Yesusniki hamere: «Han asu daraniisi shunar; Ayhudni shiiphoni keya dey keer'i; es bari boor'a han baron barik zagutak sholsuwa» yit chinire shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Es bari boor'a Yesus baassoneen ane hami. Keebaaski tai'sefena kabaasik tii meya taar'oni gaanynyaas zomobaasakitonin Yesusniki ekka yit wosi: «Daamiiso; ne taaki keer girutak ta sholsu asutewa; kutira hoputaata. ");
INSERT INTO jnjl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ta teetnaasiknu neeki yoonak sholsu asutewa. Es bari boor'a ek faataasta faagedo kaama makowa; wostinynyataas dey farunawa. ");
INSERT INTO jnjl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ta teetnaasik oom ha'sinynyani meeni sikalosi ha'i asuwa. Ta sikaloossi dey ta ajajefana meya taar'oni meya feeseterwa. Isaasin: ‹Ek hamma› iyaanane hamar; Oomiisin: ‹Hani yowa!› iyaanane yeer; wostinynyataasin: ‹Han baron zaguwa› iyaanane zagir» ");
INSERT INTO jnjl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesus es baron odere diinqe. Yerqere orfobaase yeesefe asuni meyak: «Israelni daraasasinnu effatena amanto aane danutwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wostere Yesusniki hama asuni meya tii meya taar'oosa gaanynyani keer wolle yeeseten wostinynyaas farire feen danete. ");
INSERT INTO jnjl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wonotirik Yesus Nayin yistefa isa katama hami. Basa nawoosnawa showo darana barneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesus es katamaasi finynyita kar'fena kabaasik asuni meya dugno wor'ere katamaassin kesedifer. Es kiti bar dey intobaasik isa bar bar. Intobaas dey dicha asu. Showo es katamaasi dara dey ane feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Daamiis baron biire kenashtefaat: «Harewe waasutaatawe!» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Estan Yesus ek sina taarifaat saa'ooson ta'i. Wor'a baasso dey yersete. Yesus dey: «Han na'o naaso kabuwa yifawungwa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kitu naas dey kabire wollo ephi. Estan Yesus naasa intok: «Naane hanifewe» yit imi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Asuni meya zuuttambesiise akamanon digsere: «Akam raajju inno ganeyaassin kabiwa. Ha'oos dey bari daraasi argasuk yawa» yit Ha'ooson galattesete. ");
INSERT INTO jnjl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesus zagina chowaasi wolla Yuudani daastanawa biratobaastaki fa daa zuuttambaase asiissi odte. ");
INSERT INTO jnjl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Haphqife Yohannisni nawoosakito Yesus zagina chowaason zuutire Yohannisnik maksete. Nawobaasasin heppin teegere: ");
INSERT INTO jnjl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«Es yoonir yiste Kiristoos nengwa wedey oomnin oodanirinso? yira mamsutiwa» yit Yesusniki wosi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Baasso dey Yesusniki hamere: « ‹Es yoonir yiste Kiristoos nengwa wedey oomnin oodanirinso?› yira mamsutiwa yit haphquni Yohannis neeki wosin yaanirwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yesus es kabaasik asuni meyanon showo meroossinnawa kiina ayyanaasonna asusasin kisi. Showo aaftishuni meeni aafaason gachi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesus Yohannisnikin wostere yeese baassok: «Hamfaat biiti baronnawa odeti baronna Yohannisnik makoti. Aaftishuni meya biyosone; engitfe baasso kaanne kutusone; awataatoni mettanni meya kayimone; Odoba oyoos odona; kituus kabuna; Tukamni meyak dey Misirachchuni kaamaas maktona. ");
INSERT INTO jnjl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ta wostefana wostoosik tuusa'onoy bar suustowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohannisni wosiisakito wolle hametenneen orfo Yesus Yohannisni chowaason daraasik: «Siru shorkifana waajosoningwa wedey awu biyatik ichma daa yaatiso? ");
INSERT INTO jnjl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Wedey keeshu maya mayo asuni meyanonnoso? Ese keeshu maya mayye ge'efe baasso taate meeni keertu feesete. ");
INSERT INTO jnjl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Eekin awu biyatik kesetiso? Raajjuninnoso? Ese nittok makefawungwa; bar raajjusatan denalowa. ");
INSERT INTO jnjl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","‹Ese sinneesta hamfaafe ugunneeson sapsuni wositaasin neyistan zeemma wosuna› yistera tichchenaas barwa ");
INSERT INTO jnjl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ta nittok makefawungwa; mashkasu kophena asusa ganesin Yohannisniistan denalo oonu aafewa. Sinuntano Ha'oosi taatosi fe asusasin atees basaastan denalowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Es baron odeseteyse asuni meya zuuttere girbo zuutife baassoneen Yohannisniki yeesere haphuktesere feeseter sinna boor'a Ha'oosi wosto futo sinbaason arsesete. ");
INSERT INTO jnjl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sinuntano Ferisawini meenawa Museni tumaasi assinynyana Ha'oosi safaranon tugga'ok Yohannisnik haphukto beyet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus tusire dey: «Han neyaasi koontonon awuneen hoossunarinso? Awune feeseterinso? ");
INSERT INTO jnjl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gabata diisefaat bare bare teegsetaafa: ‹Markata fugni aane sursoweti; soosenik aane waassoweti› yiset kassefa naanggotaasne feeseterwa. ");
INSERT INTO jnjl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Haphquni Yohannis tusha muunoy wayinini usha ushnoy yeen nitto: ‹Kiina ayyana faarwa› yiseti. ");
INSERT INTO jnjl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Asuni Naa meetnawa ushetna yeen: ‹Han bar muunewa ushne shuna asuwa; dey girbo zuutife baassonawa boor'ni meena asi zomowa› yiseti. ");
INSERT INTO jnjl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Techmaasi futo sina naanggotba zuuttambaase asiistatu artefa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ferisawini meyaassin isar Yesus muu muunak keeba teege. Yesus dey asusa keer hamme muuk di. ");
INSERT INTO jnjl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Es katamaassi isa boor'inynya asu faar. Bar dey Yesus Ferisawiisa keer foobaason odefaat albastiros yiste shu'ak wosuste bilqadisi shitto ephpha esta hami. ");
INSERT INTO jnjl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesusni orfoosta wochobaasi tesha yerefaat waasit harafbaasik haatira sombaasik ku'et faar. Wochobaason daamet shittok woshshit faar. ");
INSERT INTO jnjl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yesusni barki keer teege Ferisawiis es baron biyaat: «Han asu raajju sinfaanane han barin fochfa asus oo sinnamatonawa aro boor'ba faanamatona aruna kabawa» yit nibbaassi safare. ");
INSERT INTO jnjl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesus dey: «Simon! Ta neek isa makona wuza faarwa» yi. Bar dey: «Assinynyano; ma'arwa makowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus dey: «Isa asunikin waaga liqe hep asuni meya feeseterwa. Isaas uuch tiya birri; hepsaas dey uuchasir birri liqsete. ");
INSERT INTO jnjl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wolgire kaassone waaga tishfaan kowaason hepobesiise asik beyi. Eekan hepobesiise asiissn liqsi barin akamanon shunnis aafferinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon dey: «Akama kowa basaasta beytena bartongwa» yi. Yesus dey: «Wolgita bar futowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Estan Yesus asuski yerqefaat Simoonnik: «Han asuso biitoso? Ta neeki keer girifana kabaasik orgonaasik akanu aane teshshowe. Sinuntano bar wochonaason harafbaasik haatira sombaasik dey ku'i. ");
INSERT INTO jnjl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ta neeki keer girifana kabaasik ne taan aane daamowe. Sinuntano bar ta neeki keer girinanneen hang orgonaason daamo aane yeetuwa. ");
INSERT INTO jnjl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne teetnaason zayitik aane foche. Sinuntano bar orgonaason shittok woshshi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Es bari boor'a neek makefawungwa; bar akamanon shunna boor'a akama boor'baas feeshun yistewa. Garo boor'baas feeshun yistena bar garonontu shunfewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Estan Yesus asuson: «Boor'nees feeshun yistewe» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Barneen ane muu meet diise baasso dey: «Boor'aason feeshun yifees han bar oonso?» yiset nibbesiissi safarsete. ");
INSERT INTO jnjl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sinuntano Yesus asusik: «Amantonees neen fatiwe; maar'on hamme» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Esseen orfo Yesus katama katamaassinawa ke'e ke'eessina hamfaafe Misirachchuni kaamaason awajet Ha'oosi taatoni chowanon maket feer. Asire heppe nawobaasakito dey ane feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Esiisimato kiina ayyana baassossin kesna mashkasunewa meroossina farse mashkasune ane feeseter. Baassossin dey naafun kiina ayyana barissin kesna Megdelawit sinfa Maarami; ");
INSERT INTO jnjl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Taato Herodisni keyaason ha'sife Kuuzani asu Yohanna, Soossinanewa ooma showo mashkasune dey feeseter. Es baasso Yesusninnawa nawobaasakitoninna waagbesiisik argasset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Showo dara dey katama katamaassin barki yeesere zuuttesefe kabaasik Yesus han besoson baassok make: ");
INSERT INTO jnjl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Isa bulinynya zala bukanak kesi. Bukfena kabaasik isa isa zalaas ugnaasta zigira yete. Kasaas dey ma. ");
INSERT INTO jnjl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ooma zalaas kaa'oosta wor'i. Kayifana kabaasik haar'ba tishina boor'a ichimi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ooma zalaas dey seer'aasi ganesi wor'i. Seer'aas ane kayira geer'a tishki. ");
INSERT INTO jnjl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ooma zalaas ma'a ho'aassi wor'i. Kayira dichcha tiya kushunon daysira gaani» yi. Es baron makere koi'sinaase kaambaason teggire: «Odoba feenaas odowowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nawobaasakito Yesusnin: «Han besos kotba aambanso?» yire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesus dey ekka yire baassok wolgi: «Ha'oosi taatoni aacho chowanon arutik nittok imtewa. Sinuntano oomni meyak chowa zuuttera besoktu maktefawa. Baasso biyefet aane yaadatesefe. Odefet dey aane gasasisefe. ");
INSERT INTO jnjl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Besosi kota haniiswa. Zalaas Ha'oosi kaamawa. ");
INSERT INTO jnjl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ugnaasi ha'ta wor'a zalaas kaambaason odefe asuni meyawa. Sinuntano baasso amanere farsonoytemato Daabulos yeere Ha'oosi kaamanon nibbesiissin ephfe. ");
INSERT INTO jnjl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kaa'oosta wor'a bar kaambaason odesefe kabaasik girak ephpheteesefe baassowa. Amantobesiis es kabaasik sinfaat tasba aafa sinna boor'a fatana kar'fana kabaasik tai'nintu kaadesefe. ");
INSERT INTO jnjl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Seer'aasi ganesi wor'a zalaas kaambaason odefe baassowa. Sinuntano han daastaki fa fooni safarak, otumni danni safaraasnawa ma'a fooni ge'aas geer'a gaanbesi foonto zagifa. ");
INSERT INTO jnjl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma'a ho'aassi wor'a zalaas ma'a tuuma nibak kaambaason odere wostota feeshife baassowa. Kaambaasik zagire gaana gaaneter. ");
INSERT INTO jnjl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Tona tonire waashshi wedey kuphoni sikalosi duusife asu aafe. Sinuntano keer girife asu chaarefaason biyanak tega dimtatu duusifewa. ");
INSERT INTO jnjl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ammanon kesnor aacho, artonor chaarefaasta kesnoy aacho wuza aafawa. ");
INSERT INTO jnjl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ese aakkak odotimato gasasutiwa. Feena barik dayistera imtona. Sinuntano isa wuzba foontoos taak faarwa yifena barnu basaastan ootter» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesusni intoosewa aybaasakitona barki yeesete. Sinuntano daraasa showotan kabi chowa barin uphok aane chimoto. ");
INSERT INTO jnjl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Asuni meya Yesusnik: «Intoneesewa ayneesakitona neen biyak sholere gero yersefewa» yire maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesus dey: «Intonaasewa aytaasakitona Ha'oosi kaamanon odesere wostota feeshife baassowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Isa wono Yesus basa nawoosakitoneen goonuusta diifaat: «Han baarisi yesalo finaniwa» yi. Baasso dey finak kabsete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Baariista hamefeen Yesus afay'ni kuni. Es kabaasik akaasta akama ipuwa kabi. Aka goonuussi tuumet hambaase zuuttambesiise asin tiir'o ephi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Es kabaasik nawobaasakito: «Daamiiso! Daamiiso! Ko'unirwa!» yit Yesusnin guzgisete. Bar dey guzire ipuwaasewa akaasi guubone asin ke'in geregere shaakki dey akama naga sini. ");
INSERT INTO jnjl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Esseen orfo Yesus baassok: «Amantontiis ayfaso?» yi. Sinuntano baassotna baassotna digaknawa diinqokna: «Ipuwaasewa akaasi guubone ajajamenar han bar oonso?» yisesete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Baariison finere Galiilaki daasi yesalo fa Gerasenon kar'ete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesus goonuussin daa kerefena kabaasik kiina ayyana basaassi faana isa asu katamaassin kesse uphe. Es asus maybaason gaa'e ha'aat atatu kutu ephna wonaas woki. Feefenaas dey moogni biratotatano keerta. ");
INSERT INTO jnjl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Yesus kiina ayyanaason asusasin kesanak ke'ina boor'a barin biinayse sinba gandera kaambaason teggira: «Ne zuuttambaase asiistan denalo sina Ha'oosi naa Yesusno! Taneen awuni isarne faarinso? Adarawa taan kiichutaatawa!» yit chaagi. Akama neya basaassi diir sinna boor'a shashsharaknawa wochoni ginokna taatere oodtet feer. Sinuntano Shashsharaason buggit wochoni ginooson kiir'et feer. Kiina ayyanaas dey ichma daa ephpha hamet faar. ");
INSERT INTO jnjl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus dey: «Ne sunne oonso?» yire mamsi. Showo kiina ayyana girira faar sinna boor'a: «Legewon» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kiina ayyanaasikito dey: «Inya gawuussi innotin kalla gafkutaatawa» yit Yesusnin shiiphse. ");
INSERT INTO jnjl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Es dimaasta fa kumaasi teshta showo muko yerefaat maadifar. Kiina ayyanaasikito: «Ek mukoossi girunik ajajowa» yira Yesusni shiiphse. Bar dey: «Hamma giruti» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kiina ayyanaasikito asusasin kessa mukoosikitosi girise. Mukoosikito dey kumaastan sharastet baariissi girira koote. ");
INSERT INTO jnjl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mukooson keemfe keemeriisakito sina chowaason biyefaat eelere hamme katama katamaassinawa ke'e ke'eessina maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Asuni meya dey zagte chowaason biyak keebesi keebesiissin kesere Yesusniki yeesete. Showo kiina ayyana basaassin kesna asus nibba wolin maya mayye Yesusni wochoosi tesha diifen biyere digesete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Showo kiina ayyanaas basaassin kesna asus aakkak farinamato aafak biya baasso asuni meyak maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Esseen orfo Gergesenonki asuni meya zuuttere akamanon digsete boor'a Yesus estan hamanak shiiphsete. Yesus dey goonuussi diire wolle hami. ");
INSERT INTO jnjl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Showo kiina ayyana basaassin kesna asus: «Neneen ane hamanawa» yit Yesusnin shiiphe. Sinuntano Yesus ekka yit makere gafki: ");
INSERT INTO jnjl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Keene wolla hamfaat Ha'o neek zagina chowaason zuutira makowa» Asus dey Yesus barik zagina chowaason katamaassi kutifaat maket hami. ");
INSERT INTO jnjl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Dara zuuttere Yesusnin oodet feeseter sinna boor'a wolle yeefena kabaasik girak ephpheteesete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Es kabaasik Ayhudni shiiphoni keyaasi gaanynya sunba Iyyaros yiste asu ye. Yesusni wochoossi gandere barki keer hamanak shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Neebaas asire heppe sinna isa mashka nawubaas mettera kituk kar'a faar sinna boor'atu es baron zagi. Yesus barneen ane hamfena kabaasik ane hamfe daraas ugnaason tiir'sire tugit feer. ");
INSERT INTO jnjl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Asire heppe neya barissin hanna wuuktet faana isa mashkasu dey faar. Bar dey fa waagbaason zuutira hetni asunik koi'si. Oonu baron fatuk aane chime. ");
INSERT INTO jnjl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bar dey orfo kamo yaara Yesusni maamaasi fashanon ta'i. Geregere wuuktet fa harinbaas yere. ");
INSERT INTO jnjl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesus dey: «Taan ta'i oonso?» yire mamsi. Zuuttere: «Inno aane ta'uweniwa» yisete. Phexiros dey: «Daamiiso, dara zuuttere neen ganeya gedde tugire tiir'sifeen biifat taan ta'iis oonso?» yifatoso. ");
INSERT INTO jnjl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sinuntano Yesus: «Hugna taaysin kesnamato aringwa, futoosik isa asu taan ta'iwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mashkasus dey aachonoy korkit yaara Yesusni sina sagade. Awuniron barin ta'inamatonawa aakkak geregere farinamatona dara zuuttambaase asi sinak make. ");
INSERT INTO jnjl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus asusik: «Naanaase amantonees neen fatiwe. Nagak hamme» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus es baron makefeen isa asu Ayhudni shiiphoni keyaasi gaanynya Iyyarosni keerun yeere: «Naane kitiwa. Hanneen ekalo assinynyaasin baak hopsutaatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sinuntano Yesus es baron odere Iyyarosnin: «Harewa! Digotaata. Amantowa, Naanees farunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesus Iyyarosni keer kar'fena kabaasik barneen ane giriis Phexiros, Yohannis, Yaqobnawa nawaasi abaneen intoneentano oom barneen girsonek aane sholowe. ");
INSERT INTO jnjl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Asu zuuttere: «Yi! Yi!» yit waassedifer. Sinuntano Yesus: «Waasutiita, nawaas kunutu kunitano aane kituwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Asuni meya nawaas kitubaason arsete boor'a Yesusniista mi'esete. ");
INSERT INTO jnjl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sinuntano Yesus kushubaason zatte: «Han Nawaase kabuwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nawaas dey kaaba wolin geregere kabira di. Yesus dey: «muuna muuba imotiwa» yire ajaje. ");
INSERT INTO jnjl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kooni abaasnawa intoose diinqesete. Sinuntano Yesus sina chowaason ooknu maksonoytemato ajaje. ");
INSERT INTO jnjl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus asire heppe wosini meyanon barki teegere kiina ayyanaason asuniissin kissoneknawa mero zuuttambaase asiissin fatusonekna giidonewa ha'suni hugnane baassok imi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Esiisimato dey Ha'oosi taatoni kaamanon asu zuuttambaase asik maksoneknawa mettanni meyanon fatusonekna wosi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ekka dey yi: «Ugunnitiisik sinni haaro sinun, ha'mato sinun, tusha sinun, waaga sinun, mayti baristan oomanon daysira ephpha hamatiita. ");
INSERT INTO jnjl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Es giriti katamaassin kesatinneen zeemma giriti keyaassi footi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Asuni meya nittotin ephphetoo beyefaatene estan kesfeti kabaasik orgontiisi tulooson tebira wootuti. Es bar dey baassosta zaala sinana» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wosini meya dey kesere misirachchuni kaamaason maket mettaniisin fatit ke'e ke'eessi aatet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Isa isa asuni meya: «Haphqife Yohannis kitun kabiwa» yiset feeseter sinna boor'a Galiilaki daason ha'sife Herodis Yesus zagina chowaason zuutire odere ephphe zaguna wuza daage. ");
INSERT INTO jnjl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Esiisimato isa isa asuni meya: «Raajju Eeliyas wolle yewa» yiseten, oomiis dey: «Zeemoti raajjuni meyaassin isaas kitun kabiwa» yiset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodis dey: «Haphqife Yohannisnin ta suutbaason katira woringwa. Eekin han odefana bar oonso?» yi. Aaffaasik dey biyanak shole. ");
INSERT INTO jnjl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wosini meya hameteessin wolle yeesere zagsete wuzason zuutire Yesusnik maksete. Bar dey Betesayida yistefa katamaasi tesha fa shaato dima baasso baassotin ephphe hami. ");
INSERT INTO jnjl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Daraas dey Yesus ay hamdifenamato arifaat baasso orfoose hamete. Yesus dey shunne Ha'oosi taatoni chowanon baassok assi. Meroossin faruk sholsere yeese baassotin dey fati. ");
INSERT INTO jnjl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Gero waalfana kabaasik asire heppe nawobaasakito Yesusniki yeesere: «Han faani dimaas ichma daawa. Es bari boor'a daraas biratoosta fa katamaassinawa beedesina hamme muunewa kununi dimne sholsonek gafkuwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesus wolgire: «Nitto muusone baron baassok imtiwa» yi. Baasso dey wolugsere: «Innoki fayiis uuch muuma tushnewa hep kurxumminewa. Es bar dey hamma waagera daysu shakaanine han effe daraasik aafawa hoorona wuza» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Estak uuch kum sinni arqasu feer. Yesus nawobaasakitonik: «Uuchasir uuchasir zagira bag bagga duusutiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Baasso dey Yesus makenaasimato duusisete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Estan uuch muuma tushaasewa hep kurxummiise kabgire den sama kaanne Ha'o galattefaat batte daraasik haa'onek nawobaasakitonik imi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dara zuuttere meere gawi. Nawoni meya dey fu'te battooson zuutiseten asire heppe masa tuuma kabi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Isa wona Yesus bar bar Ha'o shiiphefeen nawobaasakito barki yeesere feeseter. Yesus dey baassotin: «Asuni meya taan oo yisefeso?» yire mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Baasso dey wolgire: «Isa isaas haphquni Yohanniswa. Isa isaas Eeliyas, dey oomiis zeemoti raajjuni meyaassin isaas kitun kabiwa yisefewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Baassok dey: «Eekan nitto taan oo yifetiso?» yire mamsi. Phexiros wolgire: «Ne Ha'okin wostere ye Kiristooswa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesus baassok: «Es baron ooknu makotiita» yit chinire make. ");
INSERT INTO jnjl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tusire dey: «Asuni Naa akama shana ephphetoonak sholsuwa. Esiis dey kur'uni meyak, maagni gaanynyanik, Museni tumaasi assinynyanik kashistona dey wortona. Keessinari wono dey kitun kabuna» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Estan dey zuuttambesiise asik: «Taneen ane hamak sholefe bar oonu sinfaanane basa teetni chowaason beyo. Wonna wonna mesqelibaason wor'e taneen ane yowowa. ");
INSERT INTO jnjl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kaabaason fu'ok sholefe bar zuuttere kaabaason tishkuna. Taakwa iyaat kaabaason aatire imfe bar kaabaason fu'ona. ");
INSERT INTO jnjl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Asu zuuttere han daastaki otmaason danaat kaabaason tishkaanane wedey yoi'gaanane barik awu ke'nirinso? ");
INSERT INTO jnjl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Oonu sinfaanane taaknawa ta kaamaasikna iichchefe bar Asuni Naa basa ulfintoosiknawa samaki Ababaasa ulfintokna dey korto Ha'oosi wosiyaasikitoni ulfinak yeefena kabaasik barik iichchona. ");
INSERT INTO jnjl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Futo nittok makefawungwa, hanta yeese baasso ganeyaassin Ha'oosi taatonon biyonoy kitunor feeseterwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus es baron makena nangirin wonaneen orfo Phexirosnin, Yohannisninnawa Yaqobninna zoonsire Ha'o shiiphonak isa aamta kesi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Estak shiiphefeen sinbaasi gitobaas soolte. Maambaas dey forera palpalli. ");
INSERT INTO jnjl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Geregere hep asu Musenawa Eeliyasna Yesusneen uphere wolumsete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ulfinak ammanon bestesere Yesus Yerusalemuk shana ephphetoonamatonawa kitunamatona wolumsesete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Sinuntano Phexiros barneen ane fe baassona afay' ephaan kuneter. Guzisere Yesusni ulfinaasonnawa barneen ane wolet fe hep asuni meyanonna biyete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Es ane wolumset fe asuni meya Yesusniistan oor kesere hamefe kabaasik Phexiros: «Daamiiso hanta foos innok ma'arwa. Keez hafo ha'uniwa. Isar neer, Isar Musenir, Isar dey Eeliyasnir» yi. Sinuntano awu makedifenamato aane aruwe. ");
INSERT INTO jnjl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Phexiros es baron makefeen shaaru yaara baassotin yini. Shaaruus yinifana kabaasik digesete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Shaaruussi kamo: «Ta korina naataas haniiswa. Barin odotiwa» yifa kaama ya. ");
INSERT INTO jnjl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Es kaamaas odtenanneen orfo Yesus bar bar beste. Nawobaasakito dey biyete wuzason es kabaasik ooknu maksonoy shaakkisete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wonotiri wono aamaastan kersetenneen orfo showo dara Yesusnik huphe. ");
INSERT INTO jnjl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Es daraasa ganesin isa asu ekka yit chaagi: «Assinynyano, han bar taak isa naatawa; yaara biyatak shiiphefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kiina ayyanaas barin chaagsir. Daasta gansira dey tookonak zagira gusa kar'ar. Atubaason mazasira Miir'enanneen orfo akama shanak beyfa. ");
INSERT INTO jnjl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne nawoosakito es kiina ayyanaason naasasin kissonek shiiphena aane chimoto.» ");
INSERT INTO jnjl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus esta fe daraasin: «Amantonti foonto elinga koonto, aageneen kar'a nittoneen ane foonari? Aageneen kar'a nittotin fa kunarinso? Naaneesin hang teshshebbo» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Naas hang Yesusniki tai'sefena kabaasik kiina ayyanaas naasin daasta gansin tooke. Sinuntano Yesus kiina ayyanaason ke'ire naasin fatire ababaasik imi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Asuni meya zuuttere Ha'oosi akama hugnanon biyesete boor'a diinqesete. Asu zuuttere Yesus zagina wuzaasik diinqesefeen Yesus Nawobaasakitonik ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Han makefana kaamaason gazgira odotiwa. Asuni Naa asuni meeni kushusi aattere imtonirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sinuntano es bar makena bar aane baassok galowa. Es wollaasi aacho chowanon arsonek aane chimoto. Wolgire mamsuk dey digsete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nawobaasakitoni ganesi: «Innoossin oonso arkiri?» uni karakkaro kabi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sinuntano Yesus baasso nibaasi safaranon arifaat isa garo naanin teshshere teshba yeeti. ");
INSERT INTO jnjl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Estan baassok: «Han garo naasin ta sunaasik ephphete bar oonu sinfaanane taan ephphetoonawa. Taan ephphete bar wosi Abataasin dey ephphetoonawa. Nitto ganeyaassin atees zuuttamnitiise asiistan arkirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohannis dey Yesusnin: «Daamiiso, isa asu ne sunaasik kiina ayyanaason asunisin kisifeen biira innoneen ane sina beyna boor'a kalniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesus wolgire: «Nittotin oomtonoy bar zuuttere nittoneen ane sinna boor'a kalatiitawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus den sama hamana wona kar'baase Yerusalem hamanak budire kabi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Basaastan zeemme sina hamni wosinin gafki. Baasso dey sholsuuson zuutire hoossusonek Samariyaki fa isa ke'esi kar'ete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sinuntano Yerusalem hamnir sinbaaso araat asuni meya aane ephphetoosoto. ");
INSERT INTO jnjl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nawobaasasin Yaqobnawa Yohannisna es baron biyaat: «Daamiiso, den saman geya kerera baassotin kiichunak ajajonik ma'i utaroso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sinuntano Yesus yerqere baassotin ke'i. Aro tesa ayyana nittoneen ane faanamato aane aruwetiwa. Asuni Naa yeenaas asuni kaani fatuktano tishkuktawa. ");
INSERT INTO jnjl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Estan kabsere ooma ke'esi hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesusnawa nawobaasakitona ugunne hamefeen isa asu: «Ne hamta hamtaassi neneen ane hamanak sholefaungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus wolgire: «Bowasikito dooi'ba faarwa. Kasaas dey keeba faarwa, sinuntano Asuni Naa teetbaasonnu teesuna dimba aafawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dey oom asunin: «Taneen hamniwa» yi. Asus dey: «Daamiiso, zeemma hamma abataasin kabbaronak ma'i uwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesus wolgire: «Kituni meya kitubesiison kabbarsonek beywa. Sinuntano ne hamma Ha'oosi taatoni chowanon makowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oom asu dey: «Daamiiso neneen ane hamanawa. Sinuntano zeemma hamma taaki keerki asuni meyanon maar'on footi unak ma'i uwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesus dey: «Gachuni boda ephaat orfo yerqefe asu Ha'oosi taatok sholsutewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Esseen orfo Daamiis oom naafunasire heppe asuni korire bar hamana katamaassinawa ke'e zuuttambaase asiissina zeemme hamonek hep hep zagire gafki. ");
INSERT INTO jnjl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ekka dey yi: «Ese Foshaas tagawa. Sinuntano zuutuni wostinynyani meya garowa. Es bari boor'a foshaasi aba wostinynyani meyanon daysire gafkunak shiiphotiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ese hamtiwa! Nittotin fantunimato zagira iririkaasi ganesi wosunawa. ");
INSERT INTO jnjl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ugunnitiisik sinni waagni kar'diddi sinun, ha'mato sinun, chaa'ma sinun ephatiita. Ugnaasta yerera ooninnu sinfaanane naga ooshshotiita. ");
INSERT INTO jnjl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Aaffa keernu girifeti kabaasik zeemma: ‹Naga han keyaasik sinfawungwa› uti. ");
INSERT INTO jnjl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Es keyaassi naga shuna asu feefaanane nagantiis es asusasi foona. Ekka sina shakaanane nagantiis nittokitu woluna. ");
INSERT INTO jnjl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wostinynya wostobaasi waaganon dananak sholsuwa. Es bari boor'a zeemmati giriti keyaassi faafaat imete baron maatnawa ushetna footi. Isa keerun isa keer hamatiita. ");
INSERT INTO jnjl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aaffa katamaassinu girifeti kabaasik asuni meya nittotin keebesiissi ephpheteere imete baron muusoti. ");
INSERT INTO jnjl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Es katamaassi fe mettaniisakitonin fatuti. Daraasik dey: ‹Ha'oosi taato nittoki tai'sewa› yit makoti. ");
INSERT INTO jnjl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sinuntano aaffa katamaassi hamma girini asuni meya nittotin ephphe too beyefatene katamani dara zuuttefena yaboosta kesfaat: ");
INSERT INTO jnjl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Wochoniista fa katamantiisi tulonon han yaboosta nittok tebuniwa. Sinuntano Ha'oosi taato nittoki ta'baason arutiwa› ");
INSERT INTO jnjl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nittok makefawungwa, mangsuni kar'ni wono es katamaastaki kar'ni mangsuni kar'aastan Sodomni katamaasta kar'ni mangsuni kar'aastu kashowa. ");
INSERT INTO jnjl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Haybunewe Korazin! Haybunewe Beetesayidane! Nittoosta zagte biistera artonoy wuzaas Tirosniistanawa Sidonaniistana zagte sinfaanane zeemme ibe mangsubesiissin wolsere suumoni maama mayere bedna wochisere harmusone kabawe. ");
INSERT INTO jnjl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Es bari boor'a mangsuni kar'ni wono nittoostan Tirosiknawa Sidonakna kashotu sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kifirnahomne! Den sama teguk sholetose? Wolla yeet ke'oni dimaassitu kerotawe. ");
INSERT INTO jnjl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","«Nittotin ode bar taan dey odona. Nittotin ephphetoo beya bar taan aafa ephphetoona wuza. Taan ephphetoo beya bar dey taan wosi barin aafa ephphetoona wuza.» ");
INSERT INTO jnjl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wostere hama naafunasire heppe asuni meya girak wolle yeesete. Yesusnik dey: «Daamiiso, kiina ayyanaasnu ne sunaasik ajachchewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesus baassok ekka yi: «Sexanaas kawunnimato den saman kere wor'difen biingwa. ");
INSERT INTO jnjl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ese zawasewa gamzatoose asin yer'atik gumantiisa hugna zuuttambaase asiista ha'suni hugna imingwa. Nittotin miir'oni wuza isanne aafawa. ");
INSERT INTO jnjl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sinuntano kiina ayyanaas nittok ajachchobaasik girotiitawa. Sunnitiis den sama tichchobaasik girotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Es kabaasik Yesus Korto Ayyanani girak tuumme: «Samaasewa daase asi Daam sina Abataaso, han baron zuutira techumni meyakinnawa aruna meyakinna aachira han daag asuni meyak ammanon besita boor'a neen galattefawungwa. Aa, Abataaso, han bar ne ma'a safaraasik siniwa. ");
INSERT INTO jnjl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Zuuttambaase Abataaskin taak imtewa. Naas oo sinnamato Abaasteno oonu arifer aafe. Esiisimato dey Abaas oo sinnamato naas wedey bar amma besunak sholena barteno oom oonu arifer aafe» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dey Yesus nawobaasakitoniki yerqere baasso baassok: «Han nitto biifeti baron biife baasso suustowa. ");
INSERT INTO jnjl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nittok makefawungwa, showo raajjuni meenawa taate meena han nitto biifeti baron biyonek sholset feeseter. Sinuntano aane biyoto. Nitto odefeti baron odosonek sholset feeseter. Sinuntano aane odosoto» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Isa wono Museni tumaasi aru Yesusniki ye. Barin fattanonak sholefaat: «Assinynyano, koi'ba foonto kaa dananak awu zagunak sholsifaso?» yire mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus wolgire: «Tumaassi awu yisteranso tichchenari? Feretira aro aru danisso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Asus wolgire: « ‹Tumaas makefanaas Daama Ha'oneeson tuuma nibneesik, tuuma kaaneesik, tuuma hugnaneesiknawa tuuma safaraneesikna shungwa› Dey: ‹Asu zuuttambaase asin ne ne teetaason shunfataasimato shungwa› yisteratu tichchewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus dey: «Ma'arontu wolgitwa. Ese ne dey esiisimato zaguwa. Koi'ba foonto kaa dey danatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sinuntano asus teetbaason ooko zaguk sholefaat: «Asu zuuttambaase oonso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus ekka yire wolgi: «Isa asu Yerusalemun kabire Iyyariko hamfeen ugunta bo'inynyani meya danere maybaason gaa'e ichche kaa kaak ha'aat hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Diinqone isa maag es ugnaasik hamaas ichchere kuni asusin biyaat shaatere hami. ");
INSERT INTO jnjl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Esiisimato dey isa Lewi es ugnaasik hamaas biyaat shaatere hami. ");
INSERT INTO jnjl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Isa Samariyani asu es ugnaasik hamaas asusin dani. Asusin biinayse barik kenashte. ");
INSERT INTO jnjl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ek barki tai'sere mazabaasta woyinini ushnewa zayitine woshshire taar'i. Estan basa hanyaasta duusire irbani ha'ifena keer taamme kati. Estak mettaniisik sholsuuson zagi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wonotirik hep diinari kisire es irbani keyaasi abanik imaat: ‹Han asusin oodda metissuwa. Han imna baristan denalo waaga kisaatane ta yaafana kabaasik kaasuna› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Eekin bo'inynyaasa kushusi ichchere gande asusik ma'a wuza zagiis aaffer sinna neek bestefaso?» ");
INSERT INTO jnjl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tumaasi aru: «Es barik kenashtere argasi barwa» yire wolgi. Yesus dey: «Ese ne dey hamfaat esiisimato zaguwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus basa nawoosneen ugunne hamere isa ke'esi kar'i. Es ke'eessi Maarta yiste isa asu barin keeba ephpha hami. ");
INSERT INTO jnjl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Bar dey Maarami yiste eetba faar. Maarami dey Yesus makefena baron odet wochobaassi diifar. ");
INSERT INTO jnjl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sinuntano Maarta wostoba arkina boor'a diira odok aane chima. Yesusniki yaara: «Daamiiso, eetnaas wostooson ta tayista ha'aat diifana kabaasik shaakkira biifa toso? Taan argasunak makowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sinuntano Yesus: «Maartane, Maartane, showo wuzak rakkatedifatarwe. Tiir'o dey neen ephiwe. ");
INSERT INTO jnjl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sinuntano sholsuus isa wuza koi'bawe. Maarami ma'a wuza koriwe. Es baron dey baristan ephnir oonu aafe» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Isa wono Yesus isa dimta Ha'o shiiphet feer. Shiiphphobaason koi'sifena kabaasik nawobaasakitonisin isaas: «Daamiiso, Yohannis nawobaasakitonik Ha'oni shiipho assinaasimato ne dey innotin Ha'oni shiipho assuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesus dey: «Shiiphefeti kabaasik ekka utiwa: « ‹Samak fe Abaniiso; sunnees ulfintefawungwa; taatonees yoongwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wona wonaasik sholsu; muuniison innok imma; ");
INSERT INTO jnjl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Innotin miir'e baassotin; feeshun yifeniisimato; mangsuniison innok feeshun uwa; fatanasi innotin gedataata› manguussin fu'otano» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tusire dey Yesus nawobaasakitonik: «Isa beso, nittoossin isar zomoba feenari, wassi daani ganeyak zomobaaski hamme: ‹Zomotaaso keez muuma tusha taak liqessaywa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Isa zomota ugnan taaki yewa. Barik imana muu tishiwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Es zomobaas keer kunigedo: ‹Taan hopsutaatawa. Gamalaas kuluftewa. Naanggotnaas dey taneen kunirwa. Kabira imanak aane chimut uninnoso?› ");
INSERT INTO jnjl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nittok makefawungwa; zomoba sinna boor'a kabire ima beyfenak shimsubaasi boor'a kabire sholena baron zuutire imanawa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Es bari boor'a ta dey nittok makonaas haniiswa: Shiiphphoti, nittok imtona. Sholoti, danati. Gamalaason ki'ti, nittok gachchona. ");
INSERT INTO jnjl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Shiiphphefe bar zuuttere ephphetoona. Sholefe bar dey danana. Gamalaason ki'fe barik gachchona. ");
INSERT INTO jnjl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nitto ganeyaassin aba sinfaat nawubaas tusha shiiphphen shu'a imnir oonso? kurxummi shiiphphen zawa imnir fooniroso? ");
INSERT INTO jnjl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wedey akoni kewa shiiphen gamzato imniroso? ");
INSERT INTO jnjl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nitto mangu asu sinfaat naanggotnitiisik ma'a wuza ima arifaatine samak fe abantiis eekin shiiphefe baassok Korto Ayyanaason aakkak arkissire ima beynirinso!» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Isa wona Yesus niba taar'a kiina ayyana isa nibtaato asunisin kisit feer. Kiina ayyana kesnanneen orfo asus wollo ephi. Daraas dey es sina chowaasik diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sinuntano daraasasin isa isaas: «Kiina ayyanaason kisifenaas bari gaanynya sina Beelzebulnikwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oomiis dey Yesusnin fattanok den saman isa mallato besunak mamussete. ");
INSERT INTO jnjl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sinuntano Yesus nibbesiisi safaranon arifaat: «Isa taato bagtera bare bare oor oor kesfaanane es taatoos tishirwa. Esiisimato dey isa keerki asu oor oor kesfaanane gander. ");
INSERT INTO jnjl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nitto taan: ‹Bar kiina ayyanaason kisifenaas bari gaanynya sina beelzebulnikwa› yitiwa. Sexana bare bare oor oor kesar sinfaanane taatobaas aakkak yeronirinso? ");
INSERT INTO jnjl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ese ta kiina ayyanaason kisifanaas Beelzebulnik sinfaanane nitto naanggotaasikito ooni sunak kissongaso? Es bari boor'a nitto naanggotaas nittoosta mangsu kar'nirwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sinuntano ta kiina ayyanaason kisifanaas Ha'oni hugnak sinfaanane Ha'oosi taato nittoki yoobaason arutiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Isa zag asu fa neeboni meebaason zuutire taar'ere keebaason oodfaanane fa waagbaas mai'siratu oodtonawa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sinuntano basaastan denalo chim asu yeere merefaanane es teetena neeboni meebaason kossire fa waagbaason boojere taamme haa'arwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Taneen ane sinnoy bar taan oomterwa. Taneen ane zuutunoy bar sikerwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Kiina ayyanaas asusasin kesfana kabaasik beysa ephana dima sholet aka foonto ichma daassi biratefa. Turkifana kabaasik: ‹Zeemoti kesna keenaassi wolunawa› yifa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wolla yaafana kabaasik keyaas futtera hoorera feen danfa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Esseen orfo hamma ooma baristan akamanon manguuson naafun zagira ephpha yaara girira diifa. Es asusik zeemmatiistan orfoti bar akamanon mangu sinfa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus es baron makefeen daraasa ganesin isa mashkasu kaambaason teggira: «Neen naanerte magaasewa tamta tamaase suustowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sinuntano Yesus wolgire: «Suustoos Ha'oosi kaamanon odere wostota feeshife baassowe» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Showo asuni meya yeesere Yesusniki zuutteseten ekka yi: «Han koontoos mangu koontowa. Mallato biyaktu sholefa. Sinuntano raajju Yonasni maallatoostan ooma mallato aafa imtona wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Raajju Yonas Neneweki asuni meyak mallato sinnaasimato Asuni Naa dey han koontoosik mallato sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kawudaaki taatono Solomonni techmaason odok daasi dilsin kabira ya. Es bari boor'a mangsuni kar'ni wono han koontoosneen kabira baassosta mangsu kar'ana. Sinuntano Solomonniistan denalo hanta feerwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Neneweki asuni meya mangsu kar'ni wono han koontoosneen kabire baassosta mangsu kar'oner. Baasso Yonas makena Ha'oosi kaamanon odesere boor'besiissin harmisete. Ese dey Yonasniistan denalo hanta feerwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tusire dey Yesus ekka yi: «Tona tonire aacho dimsi wedey gupkosi duusife asu aafe. Sinuntano keer girife asusik chaarsunak tega dimtatu duusife. ");
INSERT INTO jnjl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Atuneesi tona aafneeswa. Aafnees fayya sinfaanane atune zuuttera chaarefatu sinana. Sinuntano aafnees mettana sinfaanane atune zuuttera talmatu sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Es bari boor'a neyissi fa chaarefaas talmonoynamato aruwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ese atune zuuttera chaarefak tuumma talma foonto sinfaanane atunees zuuttera mai'sira saamfa tonnimatotu chaaronawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Es baron makefeen isa Ferisawi muu muunak Yesusnin barki keer teege. Ferisawiisa keer girire ane muu muunak di. ");
INSERT INTO jnjl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yesus muu muunoy zeemme kushubaason maso beyna boor'a Ferisawiis diinqe. ");
INSERT INTO jnjl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Estan Daamiis barik ekka yi: «Nitto Ferisawiis, toofosewa koranaase asi tukanontu kayimsira masefeti. Sinuntano sikalontiis bo'aknawa mangukna tuumawa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nitto gowwa, tukabaason tesi Ha'oos sikalobaason aane tesuwanoso? ");
INSERT INTO jnjl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ese toofontiissi fa baronnawa koranantiissi fa baronna tukamiisik imtiwa. Es kabaasik zuuttambaase nittok kayma sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Nitto Ferisawiis haybuntiwa! Azmachaassinnawa chirataassinna esiisimato dey fuso fuso sausaassin asiriissin isaron Ha'ok imtir. Sinuntano futoni wostoosonnawa Ha'oosi keeshtananonna beytiwa. Es baron zagaat han baron beyti bar ma'artawa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Nitto Ferisawiis haybuntiwa! Ayhudni shiiphoni keyaassik ulfinni kodta duuktu sholefeti. Gabaasta dey asu nittotin arkissuni naga ooshshonak sholefetiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Asuni meya arunoy tukabaasta kutisefe moogane feer sinti boor'a haybuntiwa!» ");
INSERT INTO jnjl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tumaasi arunisin isaas: «Assinynyano, ekka unees innotinnu mei'tiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus wolgire: «Tumaason arife nitto dey haybuntiwa! Asu wor'ak chimnoyna faya ba'a asuniista wossitir. Sinuntano nitto teetnitiisik kushuntiisi waa'aknu aane ta'ifeti. ");
INSERT INTO jnjl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Esiisimato dey nitto abaasakito worsete raajjuni meeni moogaason gadasifeti boor'a haybuntiwa! ");
INSERT INTO jnjl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ese nitto abaasakito worsete raajjuni meeni moogaason gadasifeti boor'a nitto dey baasso wostesete wostoosik isar sinnitiisontu besifetiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Es bari boor'a Ha'oosi techma ekka yiwa: ‹Raajjuni meyanonnawa wosini meyanonna wosunawa. Baasso isa isaasin worsone. Oomiisin dey kalle kofuksone. ");
INSERT INTO jnjl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Daa testenanneen kabira wuukte raajjuni meeni hannaasik Han koontoos mamustonirwa› ");
INSERT INTO jnjl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Futo nittok makefawungwa; Abelni hannaastaneen kabira shoo'aastanawa betemeqdesiissi ganesina wuukte Zakkariyasni hannaasta kar'ananneen han koontoos mamustonirwa. ");
INSERT INTO jnjl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Tumaasi arife nitto haybuntiwa! Aruni gamalaasi gachonon ephti, sinuntano nitto teetaasik aane giruweti. Giruni baassotin dey kaletiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Estan Yesusnin noonobaassin kesfa kaamaasik barin fattanok Museni tumaasi assinynyanawa Ferisawini meena oomtoknawa showo mamsuni mamsukna kabsete. ");
INSERT INTO jnjl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Es kabaasik showo kum dara zuuttesete. Showobesiistan kabi chowa baassotna baassotna tugset feeseter. Yesus zeemme nawobaasakitonik ekka yi: «Ferisawini meeni masoossin esiis dey sinnoy sinne bestoossin teetnitiison oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Geepto wuzaas ammanon kesa aafa beyana wuza. Aacho wuzaas dey arto aafa beyana wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Es bari boor'a talmaassi wolleti bar zuuttera chaarefaasta odtona. Aacho dimsi saaksera wolleti bar dey tega dimta ammano maktona. ");
INSERT INTO jnjl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Zomota sina nittok ekka yifawungwa, ashnitiison woraat esseen orfo ooma wuza zaguk chimonoy baassotin digotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sinuntano oonin digotik sholsifanamato nittok makonawa. Worinanneen orfo geeni tir'maassi ha'uk hugnaba faana Ha'ooson digotiwa; aa bar baron digotiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Uuch meejmar hep duudesi waagtertanoso? Barissin isaasnu Ha'oosi sina aane daagtefawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nitto somaasi fashanu faadtowa. Es bari boor'a digotiitawa, nitto showo meejmaristan denalowa.» ");
INSERT INTO jnjl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Tusire dey Yesus ekka yi: «Nittok yifawungwa; asuni sina bar taar sinbaason zaala make barik Asuni Naa dey Ha'oosi wosiyani sinak barik zaal sinne makonawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Asuni sina taan mormefe barin Ha'oosi wosini sinak dey barin mormonawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Asuni Naanita mei'ni kaama makefe bar oonu boor'baas feeshun ustonawa. Sinuntano Korto Ayyanaasta mei'ni kaama makefe basa boor'baas aafa feeshun ustona wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Asuni meya nittotin Ayhudni shiiphoni keyaasikitosi wedey gaannye meyakinawa daa ha'sife baassokina ephphe taamefe kabaasik: ‹Awu wollonittaaso wedey aakkak wolgunittaaso› yit rakkatotiita. ");
INSERT INTO jnjl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Es kabaasik Korto Ayyanaas makoti baron nittok assunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Daraasa ganesin isa asu Yesusnin: «Assinynyano, aytaas abaniisa karranon taak haa'anak makowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sinuntano Yesus wolgire: «Ne han asu, nittoosta gaanynya wedey abantiisa karranon haa'anak zagi oonso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dey tusire: «Asuni kaa teetenaas waagni aatamtantawa. Es bari boor'a eenantoostan teetnitiison oodtiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Estan tusire isa beso ekka yit make: «Buloba akama gaana gaanna isa otum asu feer. ");
INSERT INTO jnjl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Es asus dey: ‹Han effatena meenaason zuutira gaagana dima aafa sinna boor'a awu zagunarinso?› yit nibbaassi safare. ");
INSERT INTO jnjl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dey ekka yi: ‹Fa botonaasikitono zuutira bogga ha'aat ooma taga taga boto mar'a meenaasonnawa fa wuznaasonna zuutira gaaganawa› ");
INSERT INTO jnjl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Esseen orfo ta taa teetaasik wolgira: ‹Showo neya kar'a hooroni otumna zuutin. Ese kaanaase diira muu, ush, giro una› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sinuntano Ha'oos barin: ‹Ne gowwa, hawungti waalaasik kaanees oottonirwa. Ese ne han zuutita bar oonik sinnirinso?› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«Esiisimato han daastak teetbaasik otma zuutife bar Ha'oosi sina tukam sina asus esiisne feerwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Estan Yesus nawobaasakitonik: «Nittok yifawungwa, kaantiisik muuti baron wedey atuntiista mayati barik tiir'o ephanaatawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Esiis dey kaa muustan, atu mayaastan denalowa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kasaasikitono biitiwa; aane bukfa; aane kar'fa; meebaason zuutifana botoba aafa; sinuntano Ha'otu maasifar. Nitto kasaastan akamanon denalowa! ");
INSERT INTO jnjl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nittoossin rakkatere neebaasta isa wona daysuk chimnir oonso? ");
INSERT INTO jnjl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Es kasho chowaason zaguk chimnoytir sinnanneen oomaasik awuniron tiir'o nittotin ephfaso? ");
INSERT INTO jnjl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Fur'aas aakkak kayira dichfanamato biitiwa; aane hopifa; aane sukfa; sinuntano Solomonnu fa ulfintobaasik fur'aassin isaasne faaronnu aane mayewa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ha'oos hawung biistefaat wono geyaassi ha'toni kuwaason ekka maysinanneen amantonti yo'ina nittotin aakkane faaron arkissira maysuni! ");
INSERT INTO jnjl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«Es bari boor'a nitto: ‹Awu muunirinso? wedey awu ushanirinso?› yit rakkatotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Es baron han daastaki fe asuni meya zuuttere sholeseter. Sinuntano samak fe Abantiis es bar zuuttambaase nittok sholsifanamato arir. ");
INSERT INTO jnjl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Es baron zagustan zeemma Ha'oosi taatono sholoti. Sholsuus zuuttera nittok imtona. ");
INSERT INTO jnjl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Abantiis taatobaason nittok imanak ma'a safaraba sinna boor'a nitto garo wodo digotiita. ");
INSERT INTO jnjl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nittoki fayiison kisira waagera tukamiisik imti. Wiis tai'sonoyna dimta, konymar muunoyna dimta, kur'unoy ha'matosi, ko'unoy otma den sama keer zuututi. ");
INSERT INTO jnjl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Waagnitiis faanaasta nibnitiis dey esta foona.» ");
INSERT INTO jnjl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tusire dey Yesus ekka yi: «Kawunanon teebera wostok hooroti. Tonnitiis dey chaaron. ");
INSERT INTO jnjl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Daambesiis sargini keerun wolunanneen oodfe wostinynyane feer sinti. Baasso dey daambesiis yeere gamalaason ki'fena kabaasik geregere gachak hoore fe asuni meyane feeseterwa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Daambesiis yeefena kabaasik guzire oodde fe wostinynyani meya suustowa. Futok makefawungwa, daambesiis kawunanon teebere baassotin maddiisi biratota duusuna dey irbasunawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Daambesiis wassi wedey wassineen orfo yeere kar'fena kabaasik guzire oodde feeseten danfena wostinynyani meya suustowa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Han baron dey arutiwa, wiis aage yoonamato keeni abaas ari sinfaanane keebaason yiishshe girifena kabaasik shaakkire biyana kabatawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Asuni Naa dey safaronoyti wonaktu yoona sinna boor'a nitto dey hoorera oodtiwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Phexiros dey: «Daamiiso, han makefata besos inno innokingwa wedey oomisikneenninso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Daamiis wolgire: «Ese keerki asu zuuttambesiise asik muubesiison sholsifana kabaastak imanaknawa ha'sunakna daamiis taassina nibbarere amanamto wostinynya oonso? ");
INSERT INTO jnjl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Daambaas wolle yeere es maktenaasimato zagifeen danna wostinynyaas suustowa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Futo nittok makefawungwa, daambaas fa wuzba zuuttambaase asiistatu taassunawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sinuntano es wostinynyaas: ‹Daamtaas tai'ni aafa yoonawuza, woknir› yit ushet, zayet arqa wostinynyaasinnawa mashka wostinynyaasonna icha ephfe. ");
INSERT INTO jnjl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Es wostinynyaasa daam bar safaronoyna wontanawa oodnoyna sa'atitana yoona. Kace kacere ixabaason dey amanonoy baassoneen zaguna. ");
INSERT INTO jnjl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Daambaasa safaranon arifegedo hooronoy wedey daambaas sholefena wuzason zagunoy wostinynyaas mangu ke'otu ephphetoona. ");
INSERT INTO jnjl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sinuntano daambaasa safaranon arunoy ke'ota katuni mangsu zagi bar garo ke'otu ephphetoona. Showo wuza imtena barkin showo wuzatu sholtefar. Akama adara imtena barkin akamatu oodtefar.» ");
INSERT INTO jnjl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tusire dey Yesus ekka yi: «Ta han daasta geyatu ephpha yaanwa. Hash saami sinfaanane aakka girona kabanso! ");
INSERT INTO jnjl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sinuntano ta haphuktona shanani haphukto faarwa. Hamma ko'una kabaneen beysana aafawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ta han daasta naga ephpha yaanarne faar sinna nittok bestefawoso? indaanewa, ta ephpha yaanay oor oor kisutano nagatawa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hash hawungneen kabira isa keyaassi feese uuch asuni meya oor oor kesonerwa. Keeziis heppiisata, heppiis keeziisata kabire wol faassosonewa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Abaas naasata, Naas abaasata, Intoos nawaasta, Nawaas intoosta, Intoos naasa asuta, Naasa asu naasa intota kabsere wol faassere oor oor kesonewa.» ");
INSERT INTO jnjl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dey Yesus daraasik ekka yi: «Shaaru awgirun kesin biifeti kabaasik geregere: ‹Hash hawung iro ichnirwa› yifeti. Es bar dey sinfa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Siru kawudan kabira sirifana kabaasik: ‹hash hawung noi'sunirwa› yifeti. Es bar dey sinfa. ");
INSERT INTO jnjl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sinnoy sinne bestefe nitto daasewa samaase asi gitonon biyak sinni baron aritirwa. Eekan han fa neyaasta sinni baron biire aru aakkak hopitiso? ");
INSERT INTO jnjl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nitto teetnitiisik biira futoni mangsuni kar'a awagan kar'a beytiso? ");
INSERT INTO jnjl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gumane es neen malaten gaanynyani sina ta'atak hamfata kabaasik zeemma uguntak faagedo ganok duudowa. Eeku shakaatane neen zatte gaanynyaaski taamarwa. Gaanynyaas dey aatire meya taar'osik imana. Meya taar'oos dey taatoni keer gedana. ");
INSERT INTO jnjl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Neek makefawungwa, koi'ni duudeeson kaasunoy es taatoni keyaassin aafawa kesata wuza.» ");
INSERT INTO jnjl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Es kabaasik asuni meya Yesusniki yeesere: «Galiilaki asuni meya maa'a imefeen Pilatos wori; Harinbesiison dey maa'aasneen ane woi'si» yit maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus dey wolgire: «Eekin es Galiilaki asuni meya oom Galiilaki asusatan denalo boor'besi faanar sinne nittok bestefewoso? ");
INSERT INTO jnjl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Indaanewa, nitto dey boor'nitiison harmu shakaatine esiisimatotu tishutiwa yifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Selehomki shu'ni keyaas shakira ichcha worina asire nangne asuni meeni chowaason awu safarefetiso? Baasso Yerusalemki fe asuni meya zuuttambesiise asiisatan denalo boor'ne feer sinne nittok bestefewoso? ");
INSERT INTO jnjl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Indaanewa; nitto dey boor'nitiison harmu shakaatine zuuttamnitiise esiisimatotu tishutiwa yifawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesus ekka yit han besoson make: «Isa asu wayinini foshbaasta isa belesi yiste i'oba faar. Es belesiissin gaana kephanak hamme isanne aane dane. ");
INSERT INTO jnjl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wayinini foshaasi wostinynyanik: ‹Esenu gaana kephanak keez wogga han belesiiski yaara isanne aane danutwa. Es bari boor'a kar'a ha'uwa, awuniron baak daason mangsidifarinso?› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wostinynyaas wolgire: ‹Daamiiso, biratobaason yiishsha futu ha'ira biyanak hanetiison beywa. ");
INSERT INTO jnjl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wonne gaanfaanane ma'arwa, gaana shakaanane kar'a ha'utawa› » yi. ");
INSERT INTO jnjl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesus isa beysani wonak Ayhudni shiiphoni keyaassi assit feer. ");
INSERT INTO jnjl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Estak asire nangne wogga kiina ayyana geshobaason kuupsina isa mashkasu faar. Bar dey kaanne kutuk aane chimfa. ");
INSERT INTO jnjl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus baron biire barki teegefaat: «Ne han asuse meroneessin faritwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kushubaasik ta'in geregere kaanna yere. Ha'ooson dey galatte. ");
INSERT INTO jnjl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sinuntano Ayhudni shiiphoni keyaasi gaanynya Yesus beysani wonaasik fatubaasik gi'tere daraasik: «Issun wostoni wona faarwa. Es wostoni wonaasikitosi yaara farutitano beysani wonaasiktawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Daamiis wolgire: «Sinnoy sinne bestefe nitto, nitto ganeyaassin beysani wonaasik gachubaason wedey hanyabaason tuptenaastan kotte akani uhshusi ephphe hamnor oonso? ");
INSERT INTO jnjl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Han mashkasus Abrahamni zala sinna faagedo asire nangne wogga kiina ayyanak taatera faar. Eekin beysani wonaasik han asuson taatoossin kottonak aane sholsifanoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ekka makobaasik barin oomtefe baassotin zuutire iichshi. Sinuntano daraas bar wostena diinqi wostoosik zuuttere giresete. ");
INSERT INTO jnjl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Estan Yesus ekka yi: «Ha'oosi taato awune faarinso? Awuneen hoossira nittok makonarinso? ");
INSERT INTO jnjl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Isa asu ephphe taamme buloossi bukna fi'fi'oni gaanane faarwa. Bar dey kayira dichcha i'o sini. Kasaas dey waa'baassi keeba keer'a di.» ");
INSERT INTO jnjl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hepsa dey Yesus ekka yi: «Ha'oosi taatonon awuneen hoossunarinso? ");
INSERT INTO jnjl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Isa mashkasu tusho kesanak woi'sina masone faarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Esseen orfo Yesus Yerusalem hamfena kabaasik katama katamaassinawa ke'e ke'eessina fe asusin assit aatet feer. ");
INSERT INTO jnjl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Isa asu yeere: «Daamiiso, faruniis garo asu koi'banoso?» yi. Yesus dey ekka yire wolgi: ");
INSERT INTO jnjl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Tugo finynyiissi giruk kabotiwa. Nittok makefawungwa, showobesiis giruk sholseter, sinuntano giruk aafa chimosone wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Keyaasi aba kabire gamalaason kulfinanneen orfo nitto gero yerefaat: ‹Daamiiso gachaywa› iyaafa gamalaason ki'ati. Bar dey: ‹Nitto oo sintimatonawa ayin yaasetimatona aane arifatwa› yire wolguna. ");
INSERT INTO jnjl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nitto dey: ‹Neneen ane maara ushniwa, zuuttoni dimaastak dey innotin assitwa› uti. ");
INSERT INTO jnjl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bar dey hepsa wolgire: ‹Nitto oo sintimatonawa ayin yaasetimatona aane arifatwa. Mangu wuza zagife nitto tayistan woktiwa› una. ");
INSERT INTO jnjl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Abrahamnin, Yisaqnin Yaqobninnawa raajjuni meyanonna zuutira Ha'oosi taatosi feeseten biyatiwa. Sinuntano nitto ek gero ha'tera waasnewa ha'ni koyne nittok sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Asuni meya awa kesnarkinnawa awa girinarkinna, yeeshdaannawa kawudaanna yeesere Ha'oosi taatoni kootanon muusonek tai'sosone. ");
INSERT INTO jnjl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ese dey zeema baasso orfo wolser sinone; orfo wolse baasso dey zeemar sinone» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Es kabaasik Ferisawini meyaassin isa isar yeesere: «Herodis neen worunak sholediferwa kabira hantan hamma» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Bar wolgire: «Hamfaat es bowasik: ‹Esenu hawungnawa wonona kiina ayyanaason asusasin kisunar, mettanni meyanon fatunar, keessinari wono dey wostonaason koi'sunar› yiwa utiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Raajjuus Yerusalemni gerakalo kitunak aane sholsifawa. Es bari boor'a hawungneen wononeen yoononeen ek Yerusalem hamanarwa. ");
INSERT INTO jnjl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalem Yerusalemne! Raajjuni meyanon worifa ne! Neeki wostere yeese baassotin shu'ak keri ne! Ako nawubaason kosobaasi sikalosi zuutira geepefanaasimato naanggotneeson zuutuk apuna wolla sholen. Sinuntano neneen daraneesneen taan beyeti. ");
INSERT INTO jnjl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Esenu keentiis ona sinnatu fui'tona. Nittok makefawungwa: ‹Daamiisa sunak yeefe bar suustowa› utinneen hawungneen ekalo taan aafa biyati wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Isa beysani wonak Ferisawini meeni gaanynyaasasin isaaski Yesus muu muunak giri. Ferisawini meya bar zaguna wuzason biyonek oodet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Estak dey isa atuba wolsina mettan asu feer. ");
INSERT INTO jnjl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesus Museni tumaasi aruni meyanonnawa Ferisawini meyanonna: «Tumaas beysani wonaasik mettaniisin fatu kalfawa wedey aane kalfanso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sinuntano baasso shaakisete. Yesus asusin ta'ire fatire gafki. ");
INSERT INTO jnjl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dey Yesus: «Nittoossin isa asu nawuba wedey gachuba beysani wonak gawu girifaanane eelle kisunor oonso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Baasso dey isa wuzane wolguk aane chimoto. ");
INSERT INTO jnjl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesus koota muusonek teegte asuni meya ulfinni dimta duuk kabsefeen biyaat han besoson make: ");
INSERT INTO jnjl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Isa asu sargi kootere teegefaanane ulfinni dimta duutatawa. Awuzakne neyistan ulfinto asu teegtere feer sinanak chimana. ");
INSERT INTO jnjl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Hepontiise asin teege asus yeere: ‹Han kodaason barik imma› iyaanane ne iichchet kerera daakalo duutawa. ");
INSERT INTO jnjl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","«Sinuntano teegtera hamfata kabaasik daakaloki dimaasta duwa. Neen teege bar yeere: ‹Zomotaaso kabira denaloki ulfinto dimaasta duwa› una. Ne dey es kabaasik neneen ane teegte baasso sina ulfina danatawa. ");
INSERT INTO jnjl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Esiis dey teetbaason den teggunak sholefe bar daa hatona. Teetbaason daa hatessife bar den teguna.» ");
INSERT INTO jnjl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesus kootaason hoossi asusik dey: «Meshmeta wedey meeta'uni kootera hoossifata kabaasik koobaason wolgire kaasuk kootere teegoni zomoneesakitonin, ayneesa kitonin, koonneesakitonin wedey otum wolkonesakitonin tegotaatawa. ");
INSERT INTO jnjl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sinuntano koota hoossifa ta kabaasik tukamiisin, engitiisin, laafaasinnawa aaftishusinna teegowa. ");
INSERT INTO jnjl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Baasso dey kowa kaasuk aafa chimone wuza sinna boor'a ne dey suustowa. Ookoni meya kitun kabsefe wono koobaason Ha'oos neek kaasunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesusneen muuni muuk diise baassossin isaas es baron odaat: «Ha'oosi taatoni kootanon muuk duuni bar aakka suustonso!» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus dey: «Isa asu akama meeta'uni koota hoossire showo asunin teege. ");
INSERT INTO jnjl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Es Kootaas maastona sa'atiis kar'fana kabaasik kootaason hoossi bar: ‹Ese zuuttambaase hoorena boor'a yootiwa› yire teegonak wostinynyabaasin wosi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sinuntano zuuttambesiise kootaaski yoo beyonek chowa sholsete. Isaas: ‹Daa waagena boor'a hamma biyanak sholsuwa. Taak fakiya zaguwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Oomiis dey: ‹Uuch kamada gachwa waagen sinna boor'a kamadera biyanarwa. Taak fakiya zaguwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Oomiis dey: ‹Asu ephpha mari sinna boor'a yoonak aafa chimanawuza› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Wostinynyabaas wolle yeere es baron daambaasik make. Es kabaasik keyaasi daam gi'tere wostinynyabaasin: ‹Tai'nin ek katamaasi ari uguntannawa garo garo shaatoostanna kesfaat tukamiisin, laafaasin, aaftishusin engitfe baassotin hang teegera yowa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wostinynyaas wolle yeere: ‹Daamiiso, maketa baron zuutira zaginwa. Sinuntano hashnu duustoni dima faarwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Es bari boor'a daambaas wostinynyaasin: ‹Keenaas tuumananneen ek katamaasi gerakalo fa ari ugnaastanawa shaatoostana kesfaat danta asus zuuttere yeere girsonek zaguwa. ");
INSERT INTO jnjl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nittok makefawungwa, han teegtere beya asuni meyaassin isa asunu ta kootaason aafawa muusone wuza› » yi. ");
INSERT INTO jnjl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Showo dara Yesusni orfoose hamefeen yerqere baassok: ");
INSERT INTO jnjl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Taaki yoonak shole bar zuuttere ababaasin, intobaason, asubaason, naanggotbaason, aybaasakitonin, eetbaasikitonon, kaabaason gedde oomto shakaanane ta nawo sinanak aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Basa mesqeliison wor'e ta orfoose yoonoy bar nawota sinanak aafa chima wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Nittoossin isar shu'ni keya keer'anak sholefaanane es keyaason keer'e kisunak hooroni waaga foobaason zeemme diire awune fa waaga koi'sunamato safaronoy asu oonso? ");
INSERT INTO jnjl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Es baro zagu shakaat kaptaason yiishshe keer'e koi'su hopifaanane es keyaason biya asu zuuttere barin kanyarwa. ");
INSERT INTO jnjl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹Han asus keer'anak kabina keyaason keer'e koi'suk aane chimewa› yittu kanyosone. ");
INSERT INTO jnjl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Asir kum meya taar'oba feena isa taato hepasir kum meya taar'oba feena oom taatoosneen etere merok sholefaanane gumabaasin merobaasewa mero beybaase zeemme diire merkonor oonso? ");
INSERT INTO jnjl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Neebere wolguk hopunir sinfaanane es oom taatoos wokak feen kur'uni wosire ganok mamsifewa. ");
INSERT INTO jnjl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Esiisimato nittoossin fa wuzbaason zuutire taakwa yaat beynoy oonu sinfaanane nawota sinanak aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Kawoos ma'arwa; Sinuntano kaar'baason turkifaanane aakkak kaar'ak chimnirinso? ");
INSERT INTO jnjl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Es effatena kawoos daasik taa'o aafa sinanawuza sinna boor'a ek gero kisiretu ha'sonewa. Odoni odoba feena bar odowowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Girbo zuutife baassotnawa boor'ni meena odok zuuttesere Yesusniki yeesete. ");
INSERT INTO jnjl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ferisawini meenewa Museni tumaasi assinynyana: «Han asus boor'ni meyanon barki tai'sir. Baassoneen ane dey meer» yit Yesusniista unyisete. ");
INSERT INTO jnjl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Es bari boor'a Yesus han besoson ekka yit baassok make: ");
INSERT INTO jnjl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Nitto ganeyaassin tiya fantuba faana isa asu, es fantubaassin isar tishfaanane izginasire izgineeson feesh dimaasta ha'aat tishi baron danananneen sholok hamnor oonso? ");
INSERT INTO jnjl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Danfena kabaasik girere ogogbaasta wor'e keeba yeefewa. ");
INSERT INTO jnjl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hamme keeba kar'fena kabaasik zomobaasakitoninnawa wolkobaasakitoninna isarik teegere: ‹Tishi fantunaason danna boor'a taneen ane girotiwa› una. ");
INSERT INTO jnjl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nittok makefawungwa, esiisimato dey harmiya sholsunoyna izginasire izgine ookoni meyaastan denalo harmire wolife isa boor' asusik den samak akama gira sinfawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Tusire dey Yesus ekka yi: «birrikin wosuste asir saantibiba faana isa mashkasu asiriissin isaas tishfaanane danananneen tona tonira keebaason futira sholonoy asu oonso? ");
INSERT INTO jnjl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Danfana kabaasik zomobaasikitononnawa wolkobaasikitononna isarik teegera: ‹Tishi birrini saantibinaason danna boor'a taneen ane giroti› una. ");
INSERT INTO jnjl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nittok makefawungwa, harmi isa boor' asusik Ha'oosi wosini sinak esiisimato dey gira sinfawa.» ");
INSERT INTO jnjl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tusire dey Yesus: «Hep naanggotba feena isa asu feer. ");
INSERT INTO jnjl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hate naas ababaasin: ‹Abataaso otumneessin taak kar'ni baron haa'a imma› yi. Abaas dey otumbaason hep naanggotiisik haa'i. ");
INSERT INTO jnjl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hate naas garo wonaneen orfo waagbaason ephphe woka dima hami. Es hamna dimaastak sholenamato sikere waagbaason tishki. ");
INSERT INTO jnjl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Fayiison zuutire koi'sinanneen orfo es daasta akama maka giri. Barin dey rakko ephi. ");
INSERT INTO jnjl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Es bari boor'a es daastak isa asuniki teete. Es asus dey muko keemanak zagi. ");
INSERT INTO jnjl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Naas dey mukoosi muunon muunak sholet feer. Sinuntano es baronnu barik ima asu aafe. ");
INSERT INTO jnjl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Estan naas nibbaassi ekka yit safare: ‹Abataasa keerki wostinynyaas apuninso muu gawire fu'eferi? Sinuntano ta hantak makak kitunarwa! ");
INSERT INTO jnjl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kabira abataaski hamfaat Abataaso; Ha'oosewa neena asi sina mangsingwa. ");
INSERT INTO jnjl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Hanneen ekalo ne naa sinna teegtonak aane sholsifawa. Sinuntano wostinynyanesasin isaasne feer zagira ephphatowa› unawa. ");
INSERT INTO jnjl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Estan kabi ababaaski hami. Ababaas dey woksok yeefeen biire kenashte. Ek barki eelle idimme daame. ");
INSERT INTO jnjl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Naas: ‹Abataaso, Ha'oosewa neena asi sina mangsingwa. Hawungneen ekalo ne naa sinna teegtonak aane sholsifawa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sinuntano ababaas wostinynyabaasakitonik ekka yi: ‹Tai'nin oomaastan denalo gada maama teshshera maysutiwa. Kushubaassi dey gila yeetira, wochobaassi chaa'ma yetutiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Faru zibiicchaason teshshera shukti. Muuni, dey gironi. ");
INSERT INTO jnjl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Han naataas kitire feer. Hash dey kaak feer. Tishire feer. Hash dey beste› yi. Baasso dey girok kabsete. ");
INSERT INTO jnjl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Es kabaasik arki naas buloni foshtatu fe. Yeere ke'e tai'sefena kabaasik surunewa ililchune asi kaama ode. ");
INSERT INTO jnjl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wostinynyaasasin isarin teegere: ‹Han odefana wuzaas aambanso?› yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wostinynyaas wolgire: ‹Aynees wolle yeena boor'awa. Abanees dey faru zibiiccha barik shuktewa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Arki aybaas gi'tere keer girunak aane sholowe. Ababaas keerun kesse keer girunak shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Arki naas wolgire ababaasik: ‹Effatena showo neya neek wosten. Maketaason isanne aane bewut. Zomotaasneen ane maara gironak isa garo nor'oninne aane imewa. ");
INSERT INTO jnjl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sinuntano han Naanees otumneeson gerkesa asuneen sikere tishkaat yeen faru zibichcha barik shukit› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ababaas dey: ‹Naataaso, ne wonna wonna taneen anetu faatwa. Taar sina bar zuuttera neerwa. ");
INSERT INTO jnjl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sinuntano han aynees kitire feer. Hash kaak feer. Tishire feyiis hash dey beste. Es bari boor'a gironik sholsifawa› » yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus nawobaasakitonik: «Isa otum asu otumbaason ha'sife isa wostinynyaba feer. Asuni meya otum asusik: ‹Han otumneeson ha'sife bar otumneeson siket feerwa› yit maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Es otum asus otumbaason ha'sife barin teegere: ‹Han odefana ne chowaas aambanso? Hanneen ekalo ta otumnaason ha'sutak aafa chimata wuza sinna boor'a kushuneessi fa otumnaasi faadani tichanon taak imma› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Otumbaason ha'sife bar dey nibbaassi: ‹Daamtaas han wostoossin taan kalle kisunir sinna boor'a awu zagunarinso? Bulonak hugnana aafa. Shiiphonak iichchonar. ");
INSERT INTO jnjl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Awu zagunamato aringwa. Daamtaas wostoossin taan kisaanane keebesiissi taan ephonek zomoni hoossunawa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Estan daambaasa kowa baassosta faana asuni meyanon isa isarbesiisin teegere. Tesuni asusin: ‹Daamtaasa kowa apuninso neyista faari?› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bar dey: ‹Isa tiya waasha zayitini kowatu faarwa› yi. Otumbaason ha'sife bar: ‹Effar foobaason besifa tichaasi wuli esewa; diifaat uuchasir waasha zayitini kowa faar yira tichuwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Estan oomiisin: ‹Neyista fa kowa apuninso?› yi. Bar dey: ‹Tiya kumtali zagoni kowa faarwa› yi. Otumbaason ha'sife bar: ‹Effar sinbaason besifa wulini tichaas esewa; nangnasir kumtali yira tichuwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Daambaas amanamtoba foonto wostinynyaasin haxxumabaasi techmanon diinqe. Ha'oni asusatan denalo han daastaki asuni meya han daastaki foobesiisik haxxe sinobesiisontu besifa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Nittok makefawungwa, han daastaki waagaas koi'fana kabaasik sama keeruk nittotin ephonek han waagaasik zomontirin hoossutiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Garo wuzaasik amanamtoos inya wuzaasik amanamto sinana. Garo wuzaasik amanamtonoy bar inya wuzaasik aafawa amanamtona wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ese han daastaki waagaasik amanamto beyfaatine futoni waagaason oonso amanere nittok imniri? ");
INSERT INTO jnjl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Oom asusa waagaasik amanamto sina shakaatine nitto teetni waagaason oonso nittok imniri? ");
INSERT INTO jnjl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Isa asu hep daamnik boz sinanak aafewa chimanawuza. Isaasin oomtefaat hepsaasin shunana. Isaasin ulfinsuna hepsaasi kashshuna. Ha'oosiknawa waaga asikna boz sinak aafa chimati wuza.» ");
INSERT INTO jnjl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ferisawini meya waaga shuneter sinna boor'a es baron odaat Yesusnin kanyesete. ");
INSERT INTO jnjl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesus dey: «Nitto teetnitiison asuni sina ooko zagifetiwa. Sinuntano Ha'oos nibnitiisi safaranon arirwa. Asuni sinak ulfintoos Ha'oosi sinak oomtesterwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tusire dey Yesus: «Tumaasewa raajjuni meeni tichaase Yohannisniista kar'ananneen maktet faar. Esseen hang dey Ha'oosi taatoni misirachchuni kaamaas maktedifar. Asu zuuttere dey es Ha'oosi taatosi girunak kabedifewa. ");
INSERT INTO jnjl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sinuntano tumaassin isa duktone yo'ubaastan samaasewa daase aatfaanane kashowa. ");
INSERT INTO jnjl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Asubaason gafkaat ooma asu ephfe bar zuuttere gerkesowa. Esiisimato dey teegobaaskin gafukte asuson epha bar gerkesowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Dey Yesus ekka yi: «waagba chima She'a maamnewa sesa maamne mayo isa otum asu feer. Bar dey wonna akama ge'aktu feefe. ");
INSERT INTO jnjl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Atuba zuuttera mazayena Alazar yiste tukam otum asusa finynyita kunfer. ");
INSERT INTO jnjl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Es tukam asus otum asusa madditan zigifa fufuntooson muunak sholet feer. Kanaasikito dey yaataafa mazabaason naarit faar. ");
INSERT INTO jnjl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Es tukamiis dey kiti. Ha'oosi wosiyanikito dey Abrahamni tesha ephpha taami. Otum asus dey kitire kabbarte. ");
INSERT INTO jnjl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ke'oni dimaassi feefaat kaanne woksok Abrahamninnawa basa tesha fe Alazarninna bi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Es otum asus: ‹Aba Abrahamno, taak kenashtowa. Han geyaasi winosi yerenar sinna boor'a kushubaasi sanak aka dukire terumnaason haatunak Alazarnin taaki wosuwa› yit chaagi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Abraham wolgire ekka yi: ‹Naataaso, ne daastaki fooneesi neyak ma'a wuza dantamato safarowa. Sinuntano Alazar dey daastak mangu wuza ephpheteena boor'a hash bar hanta ma'arik foona ne dey shanasi foota. ");
INSERT INTO jnjl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Es baristan denalo nittonawa innona asi ganeyaassi inya gawu faarwa. Es bari boor'a innokin nittoki dey nittokin innoki finak chimnir oonu aafewa.› ");
INSERT INTO jnjl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Otum asus dey ekka yi: ‹Ese Aba Abrahamno, Alazarnin abataasa keer wosutak shiiphefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Uuch ayta feeseter sinna boor'a baasso dey han shanani dimaassi yoosonoytemato hamme makowowa.› ");
INSERT INTO jnjl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Sinuntano Abraham: ‹Baassok Musenawa raajjuni meena feeseterwa. Baassokin odosotowa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Otum asus dey: ‹Ekkatawa aba Abrahamno, isa asu kitun kabire hamme makefaanane harmusobesiwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham dey: ‹Museni tichaasonnawa raajjuni meeni matsafaasonna odo beya baasso isa asu kitun kabire hamme makefenaknu aafawa odosone wuza.› » ");
INSERT INTO jnjl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus nawobaasakitonik ekka yi: «Asuni meyanon tuusa'sira boor'a wostosonek zaguniwuza yoo beyana wuza aafawa. Sinuntano es boor'aassi tuusanon ephphe yooni asus yerefawowa. ");
INSERT INTO jnjl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Oonu han garo garo naanggotaassin isaason tuusa'subaastan inya wooni shu'a suutbaasta taatera tir'maassi ha'tefaanane ma'arwa. ");
INSERT INTO jnjl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Es bari boor'a nitto teetaasik arutiwa. Ayne neen miir'efaanane ke'uwa. Es mangsubaasik gaabbefaanane feeshun uwa. ");
INSERT INTO jnjl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wonaassin naafuna wolle neen miir'efaananenawa neeki wolle yeefaafe: ‹Mangsunaasik gaabbengwa› iyaanane feeshun uwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Wosibaasakito dey Daamiisin: «Amantoniison innok daysaywa?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Daamiis dey wolgire: «fi'fi'oni gaanane fa garo amantonti faafaanane han di teyaason: ‹Waatera yeet tir'maassi toktowe› yifaatine nittok ajajamtonawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tusire dey Yesus ekka yi: «Nitto ganeyaassin isaas bulinynyaba wedey fantuni keemerba feenar es wostinynyaas wostobaassin wolle yeefena kabaasik geregere: ‹Hang tai'sera diira muuneeson muwa› yifewoso? ");
INSERT INTO jnjl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Es baristan zeemme: ‹Meeta'u taak hoossuwa. Ta maara ushananneen taar'era taak wostowa. Esseen orfo ne dey maara ushata› utanoso yifenari? ");
INSERT INTO jnjl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Eekin es wostinynyabaas daambaas makena baron ma'i yire wostobaasik daambaas galattefewoso? ");
INSERT INTO jnjl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ese nitto dey makte baron zuutira zagifeti kabaasik: ‹Inno ke'noy wostinynyawa; Zagunik sholsi wostoosontu wosteniwa› utiwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus Yerusalem hamaas Samariyanewa Galiilane asi ganesi kamo aati. ");
INSERT INTO jnjl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Isa ke'esi kar'fena kabaasik asir awataatoni meroni mettanni meya barin huphsere woksok yeesesefaat: ");
INSERT INTO jnjl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«Yesus Daamniiso, innok kenashtefaywa!» yiset tega kaamak maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus baassotin biyaat: «Hamefaat atuntiison maagni meyak besutiwa» yi. Baasso dey hamefegedo ugnaastak farsete. ");
INSERT INTO jnjl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Baasso ganeyaassin isaas farubaason biinaase akama kaamak chaagge Ha'ooson galattet wolle ye. ");
INSERT INTO jnjl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesusni wochoossi kaa'nere galatte. Bar dey Samariyaki asu. ");
INSERT INTO jnjl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesus ekka yi: «Awataatoni merobesiissin fariis asir asutenoso? Eekin izginiis ayfeeseteso? ");
INSERT INTO jnjl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Han alaga asusteno oom Ha'ooson galattok wolle yeer aafenoso?» ");
INSERT INTO jnjl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesus es asusin: «Kabira hamma; amantonees neen fatiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ferisawini meya Yesusnin: «Ha'oosi taato aagenso yoonari?» yire mamussete. Bar dey ekka yire wolgi: «Ha'oosi taato asuni meya biisefeesne fa ugnak aafawa yoonawuza. ");
INSERT INTO jnjl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Hantawa wedey ek estawa uuk aafa chimone wuza. Ha'oosi taato han nitto ganeyaassitu fawa.» ");
INSERT INTO jnjl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tusire Yesus nawobaasakitonik ekka yi: «Asusa Naani wonaasikitosi isaason biyak kaltoti wona yoona. Sinuntano aafa biyati wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Asuni meya: ‹Kiristoos hantatu fewa wedey ek estatu fewa› yire nittok maksone. Baasso orfone hamatiita dey zoonustotiita. ");
INSERT INTO jnjl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kawuna samaasta kawunna dilaneen dila katira chaarsifanaasimato Asuni Naa yeefena wono esiisimatotu sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sinuntano es bar sinbaasneen zeemma Asuni Naa akama shana ephphetoonaknawa han koontoosik dey kashistonakna sholsuwa. ");
INSERT INTO jnjl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noohni neyaasik sinnaasimato Asuni Naa yeefena wono dey ekkatu sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nooh merkebiissi giruna wona kar'ananneen asuni meya meetnawa ushetna; ephetnawa giritna feeseter. Tishkuni akaas yaara zuuttambesiise asin tishki. ");
INSERT INTO jnjl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Looxni neyaasik dey esiisimatotu sini. Asuni meya meetnawa ushetna; keerun kisire waagetnawa geron waagere yeetna; toko toketnawa keya keer'etna feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sinuntano Loox Sodomun kesna wono saman geenewa geeni kayone woottera zuuttambesiise asin tishki. ");
INSERT INTO jnjl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Asuni Naa wolle yoona wono ekkatu sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Es wono keyaasi tukta fe bar oonu sinfaanane keer fa wuzbaason ephanak keronaata. Buloni dimaasta fe asus keer wolunaata. ");
INSERT INTO jnjl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Looxni asus sinna baron safaroti. ");
INSERT INTO jnjl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kaabaason fu'ok shole bar zuuttambaase tishkuna. Sinuntano kaabaason aatire ima bar fu'ona. ");
INSERT INTO jnjl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nittok makefawungwa; es wonoti waalaasik hep asu isa kuphota kunona; isaas oottona; isaas fui'tona. ");
INSERT INTO jnjl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hep mashkasu isa dimta meya ni'ona; isaas oottona; Hepsaas fui'tona.  ");
INSERT INTO jnjl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hep asu buloni dimaasta wostosone; isaas oottona; hepsaas fui'tona» ");
INSERT INTO jnjl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nawoni meya dey: «Daamiiso; oottere hamonees ayinso?» yit mamussete. Yesus dey: «Asha faanaastatu arikasa zuuttefawa» yit wolgi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus nawobaasakitonik hopunoy wonna wonna shiiphsonek sholsu sinnamato besuk han besoson ekka yit make: ");
INSERT INTO jnjl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Isa katamaasi Ha'ooson digonor asunin dey iichchonoy isa gaanynya feer. ");
INSERT INTO jnjl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Es katamaassi isa dicha asu faar. Bar dey gaanynyaaski hamfaafa: ‹Taanawa ta gumaasna asi ganesi fa malataasik mangsu kar'wa› iyaafa shimsi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Gaanynyaas dey es kabaasik ma'i aane uwe. Sinuntano orfo nibbaassi ekka yi: ‹Ha'ooson digo beyfanak wedey asunin iichcho beyfanak han dicha asus taan shimsit faar sinna boor'a wonna wonna taan rakkisunoynamato barik mangsu kar'anawa› » ");
INSERT INTO jnjl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tusire dey Daamiis: «Mangu gaanynyaas makena baro yaadatoti. ");
INSERT INTO jnjl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eekin toone waalinne Ha'ooski chaaget feese bari korto asusin aafanoso baassok mangsu kar'anawuza? Baassotin argasunoy wokniroso? ");
INSERT INTO jnjl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nittok makefawungwa; tapteratu mangsu kar'anawa. Sinuntano Asuni Naa wolle han daasta yeefena kabaasik amantoba faana asunin danungeso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tusire Yesus teetbesiison ooko zagire teetoknawa oomiisin dey kashshisefe baassokna han besoson make: ");
INSERT INTO jnjl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Hep asuni meya shiiphok betemeqdesi hamete. Isaas Ferisawi; hepsaas girbo zuuti asu. ");
INSERT INTO jnjl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«Ferisawiis yerefaat nibbaassi ekka yit shiiphe: ‹Ha'oose; ta oom asuni meenimato bo'inynya, mangu, gerkesar sina beyna boor'a neen galattefan. Han baristan denalo han girbo zuutife boor'inynya asusne feer sina beyna boor'a neen galattefan. ");
INSERT INTO jnjl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ta torbaniissin hep wona soomenar. Danfanaastan asiriissin isaron imnar› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Sinuntano girbo zuutife asus woksok yerefaat den sama kaanne biyanaknu aane chime. Nibbaason ki'et: ‹Ha'oose; ta boor'inynyaasin fakuwe› yit shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nittok makefawungwa; Ferisawisatan denalo Ha'oosi sina ooko sinne faattere keeba hami. Teetbaason den teggife bar daa hatona. Sinuntano teetbaason daa hatessife bar den teguna.» ");
INSERT INTO jnjl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesus garo garo naanggotaason suusanak barki teshshesete. Nawobaasakito dey es baron biyaat kalesete. ");
INSERT INTO jnjl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sinuntano Yesus garo garo naanggotaason barki teegere ekka yi: «Garo garo naanggota taaki yoonoynamato kalatiita. Ha'oosi taato han barikitone feyisikwa. ");
INSERT INTO jnjl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nittok futo makefawungwa; Ha'oosi taatonon han garo garo naanggotaasne faaron zagire ephphetoonoy bar aafawa giruna wuza.» ");
INSERT INTO jnjl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayhudni gaanynye meyaassin isaas: «Garam assinynyano, koi'ba foonto kaak danak awu zagunarinso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus ekka yire wolgi: «Awuniron taan garam yifasso? Isa Ha'oosneen oom garam oonu aafewa. ");
INSERT INTO jnjl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‹Gerkesataata; kaa worutaata, wiisotaata, esha zaala makotaata, abanesinnawa intoneesonna ulfinsu› yifa ajajiison aritarwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Asus dey: «Es ajajiisikitonon daagnaseneen ooddatu fawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus es baron odenaase: «Ese isa wuza zaguta wuzatu fu'terwa, fa wuzneeson zuutira waagera tukamni meyak imma. Sama keeruk danatawa. Eekan taneen ane hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sinuntano asus akama otumba faar sinna boor'a es baron odenaase akamanon suume. ");
INSERT INTO jnjl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus asusi akamanon suumenamato biyaat ekka yi: «Akama otumbesi faana baassok Ha'oosi taatosi giru awune fa tiir'onso? ");
INSERT INTO jnjl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Otum asu Ha'oosi taatosi girubaastan gaala marufni aafsi kamo aatbaastu kashowa.» ");
INSERT INTO jnjl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Es baron ode asuni meya: «Eekin oonso faruk chimniri?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sinuntano Yesus wolgire: «Asunik chimtonoy wuzaas Ha'oosik chimterwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Phexiros: «Ese inno fa wuzniison zuutira beyya neneen ane yaaniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Yesus wolgire: «Futo nittok makefawungwa, Ha'oosi taatokwa iyaat keebaason wedey asubaason wedey aybaasakitonin wedey kooni aba intooson wedey naanggotbaason beya bar han daastak hep kushunon, yooni neyaasik koi'ba foonto kaa ephphetoonor oonu aafewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus asire heppe nawobaasakitonin oor kisaat baassok ekka yi: «Ese ek Yerusalem hamanirwa. Asuni Naani chowaasik raajjuni meyaki kamo tichche bar ko'unirwa ");
INSERT INTO jnjl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bar Aazabni meyak aattere imtonir. Baasso dey barin kashshusone, me'osone, tujosone. ");
INSERT INTO jnjl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ichosone, estan worsone. Sinuntano bar keessinari wono kitun kabuna.» ");
INSERT INTO jnjl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sinuntano nawobaasakitonik es makena chowaas zuuttera aane galowa. Bar makena chowaas baassok aachena boor'a awu makenamato aane arsoto. ");
INSERT INTO jnjl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus Iyyariko tai'sefena kabaasik isa aaftishu ugunta diifaat shiiphedifer. ");
INSERT INTO jnjl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aaftishuus teshba kamo aatfe daraasa kaamanon odefaat: «Han bar aambanso?» yire mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Baasso dey: «Naaziretki Yesustu hanta kamo aattiferwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aaftishuus dey: «Dawitni naa Yesusno, taan fakifaywa» yit chaagi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sinaasta hamet fe asuni meya: «Shaakkuwa!» yit kalete. Sinuntano bar kaambaason teggire: «Dawitni naaso taan fakifaywa» yit chaagi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Estan Yesus yerere asusin: «Hang taaki yowa» yit ajaje. Aaftishuus barki tai'sefena kabaasik: ");
INSERT INTO jnjl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Neek awu zagunakinso sholefatari?» yire mamsi. Aaftishuus: «Daamiiso, biyanaktu sholefaungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus dey: «Biwa, amantonees neen fatiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aaftishuus geregere bi. Ha'ooson dey galattet Yesusneen ane hami. Daraas zuuttere es baron biyeteese Ha'ooson galattesete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus Iyyarikoni katamaassi kamo aatte hamdifer. ");
INSERT INTO jnjl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Estak Zakkiwoos yiste girbo zuutife baasso gaanynya sina otum asu feer. ");
INSERT INTO jnjl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Bar Yesus aaffer sinnamato biyanak sholet feer. Sinuntano yer'ba kawuna sinna boor'a daraasa showotan kabi chowa biyak aane chime. ");
INSERT INTO jnjl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yesus aatte hamana ugnaasta barin biyak sina eelle isa teeni i'ota kesi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesus esta kar'fena kabaasik den kaanne biyaat: «Zakkiwosno, Taptera kerowa; hash hawung neeki keer feeshanak sholsuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakkiwoos dey taptere kerere girak Yesusnin keeba ephphe hami. ");
INSERT INTO jnjl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Es baron biya asuni meya zuuttere: «Boor' sina asusa keer muu muunak giriwa» yit Yesusniista unyisete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sinuntano Zakkiwoos yerere Yesusnin: «Daamiiso, fa otumnaasi isa kununon tukamiisik imanawa. Asuniistan eshak ephna waaga faafaanane acheech kushu zagira wolgunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Yesus: «Asuni Naa tishi barin sholoknawa fu'oknatu yewa. Han asus dey Abrahamni naa sinna boor'a hash hawung faru han keyaasik siniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Darani meya es baron odesefeen Yesus isa beso baassok make. Bar Yerusalem tai'sena boor'a asuni meyak Ha'oosi taato yaara kar'difanne faar sinna baassok beste. ");
INSERT INTO jnjl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Es bari boor'a ekka yi: «Taattere yoonak woka daa hama isa ulfinto asu feer. ");
INSERT INTO jnjl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Hamnoyfegedo zeemme wostinynyabaasasin asirin teegere: ‹Ta wolla yoonanneen nagadera bu'sutiwa› yit asir miinani imaat hami. ");
INSERT INTO jnjl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sinuntano es daasi asuni meya barin oomtesete boor'a: ‹Han asus innoosta taattonak aane sholefeni› yire hamnanneen orfo wosinin wossete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Sinuntano es asus taattere daabaasta wolle ye. Es wostinynyabaasik imna waagaason nagadesere awune faaron buu'sisetemato arunak teegsi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Issoonsa wostinynyaas yeere: ‹Daamiiso, imta birriis asiron buu'ewa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Daambaas: ‹Ne ma'a wostinynya, ma'aron zagitwa. Garo wuzaasik amanamto sinna bestetwa. Asir katamaason ha'sutak ha'suni hugna neek imingwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hepsani wostinynyaas dey yeere: ‹Daamiiso imta birriis uuchon buu'ewa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Daambaas dey: ‹Ne uuch katamaason ha'sutak taassingwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Oom wostinynyaas dey yeere ekka yi: ‹Daamtaaso, erbesi birira kunsina birrinees hanifawa. ");
INSERT INTO jnjl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ne kunsunoytaason ephtar; Buknoytaason dey kar'tar; Ne keena budu asu sinta boor'a digengwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Daambaas dey ekka yi: ‹Ne mangu wostinynya, han wolumneesik neyista mangsu kar'anawa. Ta kunsunoynaason ephar, buknoynaason kar'a keena budu asu sinnaason aritannen; ");
INSERT INTO jnjl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ta yaara waagnaason koontobaasneen ephanak awagan baankini keer kunsu beyisso?› ");
INSERT INTO jnjl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Estan Daamiis esta yeese baassok: ‹Waagaason barkin ephpha asir birri faana barik imtiwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Baasso wolgire: ‹Daamiiso, barki asir birriba faarwa› yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Daamiis ekka yi: ‹Nittok makefawungwa, faana barik daytera imterwa. Sinuntano foontoosatan barik fa barnu ootterwa. ");
INSERT INTO jnjl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sinuntano ta baassosta taattonak sholonoy ta gumaasakitonin hani teshshera taaki sina worutiwa.› » ");
INSERT INTO jnjl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus es baron makenanneen orfo ek Yerusalem hamak nawoni meeni sina zeemi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dabrazayitini kumaasi tesha fa Betefagenewa Bitaniyane sinfa katama tai'senaase nawobaasasin heppin ekka yire wosi: ");
INSERT INTO jnjl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Ek sinnitiista fa ke'eessi hamtiwa. Estak oonu barista duunoyna hanyani nawa tuptera yerefeen danati. Kotta yootiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Oonu: ‹Awuniron kottifetirinso?› yisere mamussefaatene: ‹Daamiisik sholsu sinna boor'awa› » uti. ");
INSERT INTO jnjl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wostere hama baasso Yesus maktenaasimato danete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hanyaasi abani meya kotefeen biyere: «Awuniron kottifetirinso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Baasso dey wolgire: «Daamiisik sholsu sinna boor'awa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Estan hanyaason Yesusniki ephphe yeesete. Geshobaasta maya kunussere Yesus duunak zagsete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Asuni meya bar hamfena ugnaasta maybesiison yiir'et feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dabrazayitini kumaastan kerefa ugnaasta tai'sesefe kabaasik basa nawoni meya biisete biistera artonoy wuza zuuttambaase asik girak tuumere kaambesiison teggire Ha'ooson ekka yit galattesete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«Daamiisa sunak yeefe taatoos suustowa. Den samak naga, ulfina dey tegira fa Ha'oosik sinun» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Daraasa ganesi fe isa isa Ferisawini meya Yesusnin: «Assinynyano, han nawoneesakito shaakkusonek zaguwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bar dey: «Nittok makefawungwa, baasso shaakkisefeknu shu'aasikito chaagerwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesus Yerusalem katamaassi tai'sere katamaason biyaat barik waasi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ekka dey yi: «Neek naga sinni baron hawung aamse arita! Sinuntano hash ne aafaassin aachewe. ");
INSERT INTO jnjl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ne gumaas biratoneeson ojba ojje ganeya gedde neen shana bessone wona yoonirwe. ");
INSERT INTO jnjl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ha'oos neen fu'ok yaana baron aane aruwe sinna boor'a neennawa ne sikaloossi fa naanggotneesikitone asin worsone. Boktonoy isa shu'anu shu'aasta diira aafa bestona wuza.» ");
INSERT INTO jnjl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Estan Yesus betemeqdesiissi girire estak nagadet fe baassotin kalle kisi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ekka dey yi: « ‹Ta keyaas Ha'o shiiphtona keyatu sinana› yisteratu tichche. Sinuntano nitto bo'inynyani meeni dugadug zagseti» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesus wonna wonna es betemeqdesiissi assit feer. Maagni gaanynye meenewa tumaasi assinynyana, daraasin ha'sife oom asuni meena barin woruk sholset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sinuntano daraas zuuttere barki tai'sere odet feeseter sinna boor'a isa wuzane zaguk aane chimoto. ");
INSERT INTO jnjl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Isa wono Yesus betemeqdesiissi daraasin assifeennawa misirachchuni kaamaason makefeenna maagni gaanynye meenewa Museni tumaasi assinynyana dey kur'uni meena barki yeesere isa mamsu mamussete: ");
INSERT INTO jnjl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«Ne han baron zagifataas aro ha'suni hugnakinso? Wedey han baron zagutak ha'suni hugna neek imaas oonso makebbo?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesus dey wolgire ekka yi: «Ta dey isa mamsu nittotin mamsunawa. Nitto dey wolgutiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohannis haphqifena bar den samaningwa wedey asunikininso?» ");
INSERT INTO jnjl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Baassotna baassotna ekka yit merkesete: « ‹Den samanwa› iyaanine: ‹Eekin awuniron amano beytiso?› unir, ");
INSERT INTO jnjl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‹Asunikingwa› iyaanine daraas zuuttere Yohannis raajju sinbaason amaneseter sinna boor'a innotin shu'ak icheterwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Estan: «Ayin sinnamato aane aruweniwa» yire wolugsete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesus dey wolgire: «Ese ta dey han baron aro ha'suni hugnak zagifanamato nittok aafawa makona wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tusire dey Yesus han besoson ekka yit daraasik make: «Isa asu wayinini akakilti tokke bulinynyani meyak kiraba kaassonek imaat showo neya ooma daa hamme woki. ");
INSERT INTO jnjl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gaana zuuttona wona kar'fana kabaasik gaanaason ephak wostinynyabaasin bulinynyani meyaki wosi. Sinuntano bulinynyani meya wostinynyaasin ichesere kushkush gafuksete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hepsak dey oom wostinynyanin wosi. Barin dey ichesere iishshire kushkush gafuksete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Keessak dey oom wostinynyanin wosi. Dey ichche mazasire gero kissere ha'sete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Woyiniisi foshni aba: ‹Eekin awu zagunarinso? Dey isa keeshtefana naataasin wosuna. Awuzakne barin digere ulfinsusonetto› yi. ");
INSERT INTO jnjl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sinuntano bulinynyani meya naasi biyeteese baassotna baassotna: ‹Foshaas han bariktu kar'anawa, hani yaani woruniwa, estan foshaas innok sinanawa› yit merkesete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Naasin wayiniisi foshni gerakalo kisire worsete. Ese Wayiniisi akakiltiisi aba es bulinynyani meyaasta awu zagunir sinna bestefaso? ");
INSERT INTO jnjl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wayiniisi akakiltiisi aba yeere es bulinynyani meyanon woruna; wayinini foshanon oomnik imana.» Asuni meya es baron odeseteyse: «Es bar ekka sinanaatawa!» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sinuntano Yesus baassoki biyaat ekka yi: «Ese keyaason keer'fe baasso kashshire beyete i'oos keyaasik yeeto siniwa» yistera tichche bar aambanso? ");
INSERT INTO jnjl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Es yeetoosta heephtefe bar fulirwa. Basaasta gandena bar eester. ");
INSERT INTO jnjl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Museni tumaasi assinynyanawa maagni gaanynyana makte besos baassosta sinbaason arsefaat es kabaasik barin ephak sholsete. Sinuntano daraasi digsete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Estan Yesusnin ephone kar'o sholset feeseter. Ha'sife basa kushuussinawa taatosi ha'suni hugnaaskina aatire imonek chinuni kaama noonobaassin kesfaan ephak oodet feeseter. Es bari boor'a ma'a asune feer sinne barkin chowa kephni aafonin wossete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aafoni meya Yesusniki yeesere ekka yire mamussete: «Assinynyano, ne futooson makefatamatonawa assifatamatona; Ha'oosi ugnanon dey isa koruba foontonon assifatamato arifeniwa. ");
INSERT INTO jnjl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ese Romanni taate meeni taato Keesarnik girboni ima sholsungwa aanenso?» ");
INSERT INTO jnjl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sinuntano bar nibbesiisi mangu safaranon arifaat ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Isa duude taak besutiwa! Han barista fa gitoosewa tichaase oonirinso?» Baasso dey: «Keesarnirwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesus wolgire: «Ese Keesarnir sina baron Keesarnik imti. Ha'oosir sina baron Ha'oosik imti» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Es makena kaamaasik daraasa sinak barin ephak aane chimoto. Makena wolguusik diinqere shaakisete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kitun kabu aafawa yisefe isa isa Seduk'awini meya Yesusniki yeesere ekka yit mamussete: ");
INSERT INTO jnjl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Assinynyano! ‹Isar asu ephphe nawa koonunoy kitifaanane aybaas asuson ephphe kiti barik zala sinni nawa koonuwo› yire Muse tichiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ese naafun ayna ayna feeseter. Arkiis asu ephphe nawa koonunoy kiti. ");
INSERT INTO jnjl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hepsaas dey es asuson ephphe koonunoy kiti. ");
INSERT INTO jnjl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Keessaas dey es asuson ephi. Naafunobaase esiisimato es asuson ephere naanggota koonunoy kiti. ");
INSERT INTO jnjl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Koi'baasta dey asus kiti. ");
INSERT INTO jnjl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ese naafunobesiise asuson ephete. Kitun kabuni wono ooni asunso sinanari?» ");
INSERT INTO jnjl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus baassok wolgire: «Han daasi naanggota asu epheter dey girseter. ");
INSERT INTO jnjl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yooni daasta fook kitun kabsoni baasso aafa asu ephone wuza wedey girusone wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ha'oni wosiyane feer sinone sinna boor'a aafa kitusone wuza. Kitun kabsete boor'a baasso Ha'oni naanggotawa. ");
INSERT INTO jnjl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kitun kabuni chowaasik Muse saabaassi kiichchoni tochoossi Daamiisin: ‹Abrahamni Ha'o, Yisaqni Ha'o, Yaqobni Ha'o› yire teegewa. ");
INSERT INTO jnjl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Zuuttambesiise barik hayew sinete boor'a bar hayewni meeni Ha'otano kituni meeni Ha'otawa.» ");
INSERT INTO jnjl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Museni tumaasi assinynyani meyaassin isa isaas: «Assinynyano, ne ma'arontu maketwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Esseen orfo isa asunu Yesusnin mamsuk aane chimoto. ");
INSERT INTO jnjl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Estan Yesus baassok ekka yi: «Asuni meya Kiristoosni aakkakinso: ‹Dawitni naawa› yisefeysi? ");
INSERT INTO jnjl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Dawit teetbaasik gaamni tichaassi ekka yi: « ‹Daamiis Daamtaasik; gumaneesin wochoneesi sikalosi; yer'atak zagunanneen; ta hoi'taasta duwa› yiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Ese Dawit Daam yire teegenanneen aakkak Kiristoos nawuba sinnirinso?» ");
INSERT INTO jnjl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Asuni meya zuuttere odesefeen Yesus nawobaasakitonik ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Dicha maama mayere kutisefaat gabaasta asuni meya baassotin naga ooshshosonek sholset Ayhudni shiiphoni keyaassi dey ulfinni kodta duuk, koota maastefanaasta ulfinni dima sholsefe Museni tumaason assinynyani meyakin teetnitiison oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Baasso dicha asusi keyanon meere turuksuk asu taan biyowa iyaat shiiphobesiison dichisefe. Es baasso akama mangsuni kar'atu ephphetoosonewa.» ");
INSERT INTO jnjl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus otumni meya waaga kephtefana saxiniissi waagbesiison ha'sefeen bi. ");
INSERT INTO jnjl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Esiisimato isa tukama dicha asu hep duude imdifeen biyaat: ");
INSERT INTO jnjl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","«Futo nittok makefawungwa, han tukama dicha asus zuuttambesiise asi denalo imiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Asuni meya fa waagbesiistan fu'tesontu imete. Sinuntano han asus barik fayiison koi'siratu imi» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Isa isa asuni meya betemeqdesiis keeshu keeshu shu'aknawa Ha'oosik imte waaga asikna keeshira keetobaason wolumset feeseter. Sinuntano Yesus ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Han biifeti bar zuuttambaase shu'aas shu'aasta kopuktera keetenamato boktona wona yoona.» ");
INSERT INTO jnjl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Baasso dey: «Assinynyano! Han bar aagenso sinanari? Bar dey sinanak besoba aambanso?» yire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus ekka yire wolgi: «Daagonoytimato arutiwa. Showo asuni meya: ‹Ta Kiristooswa, wonaas ta'i› yit ta sunaasik yoosone. Sinuntano nitto baassok zoonustotiita. ");
INSERT INTO jnjl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Neeboosi odunonnawa daraasa mangu wolumni shorkone asin odefeti kabaasik nawotiita. Es bar zeemma sinanak sholsuwa. Sinuntano koi'baas geregere aafa sinanawuza.» ");
INSERT INTO jnjl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tusire Yesus ekka yi: «Dara daraasata, taato taatoosta kabuna. ");
INSERT INTO jnjl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Akama daani shorko sinana. Daadaassi dey maknewa, showo tesa merone sinana. Den saman akama deessu beso sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Sinuntano es bar zuuttambaase sinbaasneen zeemma asuni meya nittotin ephone dey kabugsone. Ayhudni shiipho keernawa taatoni keerna aatire imone. Ta sunaasi boor'a taatoni meyakinawa daason ha'sife baassokina taamone. ");
INSERT INTO jnjl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Es bar dey ta sunaasik zaala makotik ma'a ugna sinana. ");
INSERT INTO jnjl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ese mamustoti mamsusik ‹Awu wolgunirinso?› yira zeemma safaronoytimato nibnitiissi ephtiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nitto gumaas wolguknawa merokna chimnoyna kaamnewa arune ta nittok imanawa. ");
INSERT INTO jnjl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nittotin kooni baassonawa aynitiisakitona, koonnitiisnawa zomontiisna nittotin aatire imone. Nittoossin isa isaas wortosone. ");
INSERT INTO jnjl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ta sunaasi boor'a asu zuuttambaase nittotin oomtona. ");
INSERT INTO jnjl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sinuntano somnitiisi ganesin isarnu aafa tishuna wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chimme yerok kaantiison fu'otiwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tusire dey Yesus ekka yi: «Meya taar'oos gumaas Yerusalemnon biratere kuphobaason biifeti kabaasik bar tishunak ta'baason arutiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Es kabaasik Yuudaki daasta feese baasso den aamaaski eeloto. Katamaassi fe baasso kesoto. Gerakalo feese baasso katamaassi girsoneeta. ");
INSERT INTO jnjl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tichchera fa raajiis zuuttambaase ko'unak haniis gumani kaastoni wonawa. ");
INSERT INTO jnjl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Es kabaasik naaner asusikitonewa nawa tanifa barikitone haybubawungwa! Daasta akama shana sinana. Daraasata dey Ha'oni gi'a yoona. ");
INSERT INTO jnjl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Baassossin showobesiis siifok kacchere kitusone. Boojchesere dey daadaassi hamone. Es Aazabni meeni neyaas ko'unanneen Yerusalem Aazabni yetona.» ");
INSERT INTO jnjl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tusire dey Yesus ekka yi: «Awaasta, assaastanawa baakuraastana diinqi beso sinana. Baariisewa akaasi guubone asi deessu kaamaasikna daa zuuttambaase asiista fe daraasin tiir'o ephana. ");
INSERT INTO jnjl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Samaastaki testoni shorkotan kabi chowa asuni meya han daasta yooni wuzason oodak digak shorkosone. ");
INSERT INTO jnjl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Es kabaasik Asuni Naa akama hugnaknawa akama ulfinakna shaaruusta yeefeen biyone. ");
INSERT INTO jnjl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nitto dey es wuzaasikito sinanak tesifana kabaasik fui'tontiis tai'sena boor'a den kaanna biiti.» ");
INSERT INTO jnjl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tusire dey Yesus ekka yit han besoson make: «Belesini i'oosewa ooma i'oosikitononna biitiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tosha kotin biifeti kabaasik bega tai'senamato aruti. ");
INSERT INTO jnjl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Esiisimato es wuzaasikito sinin biifeti kabaasik Ha'oosi taato ta'baason aruti. ");
INSERT INTO jnjl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Futo nittok makefawungwa, es bar zuuttambaase ko'unanneen han koontoos aafa aatana wuza. ");
INSERT INTO jnjl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Samaasewa daase aatana. Sinuntano kaamnaas aafa aatana wuza.» ");
INSERT INTO jnjl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tusire dey Yesus ekka yi: «Nibnitiis ushak, zayyak, han daastaki fooson safarok hopunoynamato arutiwa. Es baron shakaatine es wonaas dey diinqo eshminimatotu nittotin ephanawa. ");
INSERT INTO jnjl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Es wonaas han daasta fe asu zuuttambaase asin ephana. ");
INSERT INTO jnjl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Es bari boor'a yooni mangu wuzaassin aatatiknawa Asuni Naani sina dey yerok chimatikna wonna wonna chimma shiiphotiwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesus wonna wonna betemeqdesiissi assifaafe waali waalin Dabrazayitini kumaasta kesse ha'it feer. ");
INSERT INTO jnjl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Asuni meya dey barkin odok e'so e'so betemeqdesiissi hamet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ayhudni faasika yistefa kixxani heeboos zagtona wona ta'a faar. ");
INSERT INTO jnjl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Maagni gaanynye meenewa Museni tumaasi assinynyana daraasin digsefaat Yesusnin aakkak worsonemato ugna sholset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sexana asire heppe nawobaasa ganesin isa Askorotki Yuuda sinfe basaassi giri. ");
INSERT INTO jnjl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Estan Yuuda Maagni gaanynye meyakinawa betemeqdesiisi tasoni meeni ha'sinynyani meyakina hamme Yesusnin aakkak aatire imanamato merke. ");
INSERT INTO jnjl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Baasso dey chowbaasik girere birri barik imonek wuli girsete. ");
INSERT INTO jnjl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Es wuliisik ma'i yire aatire imanak asu foonto kar'o oodet feer. ");
INSERT INTO jnjl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Esseen orfo Ayhudni faasikani fantu shuktona kixxani heeboos kar'i. ");
INSERT INTO jnjl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesus: «Faasikani meeta'uson muunik hamma hoossutiwa» yire Phexiros Yohannisna asin wosi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Baasso dey wolgire: «Ayhudni faasikani meeta'uson ay hoossunikinso sholefa tari?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Bar dey: «Ek katamaassi girifeti kabaasik akani gima wor'o asuni danati. Orfobaase hamfaat bar girina keyaassi giruti. ");
INSERT INTO jnjl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Estan keeni abaasin: ‹Assinynyaas nawobaasneen ane Ayhudni faasikani meeta'uson muuna irbani keya ayfaso?› yifewa uti. ");
INSERT INTO jnjl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Asus irbanik hoorera di keeni tukta keete keya besuna. Nitto dey esta hoossuti.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Es hep nawobaas dey hamere zuuttambaase Yesus makenaasimato sinin danere meeta'uson esta hoossisete. ");
INSERT INTO jnjl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Meeta'uni sa'atiis kar'fana kabaasik Yesus wosibaasakitoneen muunak kasayere di. ");
INSERT INTO jnjl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yesus baassok ekka yi: «Tayista kar'ni shanaason ephphatoonaasneen zeemma han meeta'uson nittoneen muunak akamanon sholettu fawungwa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nittok makefawungwa, Ha'oosi taatosi han bari aacho chowaas ko'unanneen han faasikani meeta'uson hepsi aafa muuna wuza.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Estan ushaason toofobaase ephphe Ha'o galattefaat: «Esewa, zuuttamnitiise han baron haa'era ushtiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nittok makefawungwa, hashneen kabira Ha'oosi taato yoonanneen han wayiniisi ushanon aafawa ushanawuza.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tushaason dey ephphe Ha'o galattefaat batte imet: «Esewa, han bar nittok imtoni ashnaaswa. Han baron taan safaronir zagutiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Meeta'uneen orfo dey ushaason toofobaase ephphe: «Han ushati bar ta nittok wuukuna arinnaasne faarwa. Bar dey nittotin Ha'oneen ane gansuni gaddo teyyawa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Sinuntano taan aatire imni asusa kushu han maddiista taneentu fawa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Asuni Naa zeemma Ha'oosi kaamsi maktera kunnaasimato kitunir. Sinuntano barin kituk aatire imni bar haybubawowa!» ");
INSERT INTO jnjl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nawobaasakito dey: «Inno ganeyaassi han effatena wuzason zaguniis oonso?» yiset baassotna baassotna mamussesete. ");
INSERT INTO jnjl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tusire nawobaasakito dey: «Inno ganeyaassin arkir oonso?» yit baassotna baassotna we'nisete. ");
INSERT INTO jnjl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus baassok ekka yi: «Han daasi taatoni meya darabesiisata ha'suni hugnabesi faarwa. Ha'sife baasso dey ma'aron zagir yisteretu teegtesefewa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sinuntano nitto ekka zagutiitawa. Nittoossin arkiis hater, dey ha'sife bar wostinynyane feer sinowa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Muuk muunak tai'sere fe barnawa yerefaat woshfe barna asiissin oonso arkiri? Muu muunak tai'sere fe bartenoso? Sinuntano ta nitto ganeyaassi isa wostinynyane faanarwa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nitto taan shana ephfana kabaasik chimma taneen yeretiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Abataas taan taassinaasimato ta dey nittotin taassunawa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Taatonaassi ta maddiistan muuti dey ushati. Kinawoosta diifaat asire heppe Israelni zalaasta mangsu kar'atiwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tusire dey Yesus ekka yi: «Simonno! Simonno! Sexana nittotin zago si'anne si'anak mamsiwa. ");
INSERT INTO jnjl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sinuntano amantonees tishunoynamato neekwa iyaat Ha'o shiiphen. Ne taaki wolifa ta kabaasik ayneesakitoni chinuwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simon wolgire: «Daamiiso, ta taatoni keer giruk, kituk neneen ane hooreratu fawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Sinuntano Yesus: «phexiros Hash hawung ako oorunoyfeen keeza wolla taan mormotawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Estan Yesus nawobaasakitonin: «Waagni kar'diddi, ha'mato, chaa'ma ephnoytiron nittotin wosina kabaasik yo'i wuza faaroso?» yi. Baasso dey: «Isanne yo'i wuza aafawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesus baassok ekka yi: «Ese hash waagni kar'diddinewa ha'matone faana bar ephowa. Siifoba foontoos maybaason kisire waagere siifo waagowo. ");
INSERT INTO jnjl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nittok makefawungwa, ta chowaasik zeemma tichaassi: ‹Manguni meyaneen faadtewa› yiste bar ko'unak sholsuwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nawobaasakito dey: «Daamiiso, hantak hep siifo faarwa» yisete. Bar dey: «Hooronawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus ooma wonoti zagifenaasimato Dabrazayitini kumaasta hami. Nawobaasakito dey ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Esta kar'efe kabaasik: «Fatanasi girunoytimato Ha'o shiiphotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Baassostan shu'a ha'tera kar'fanaasne fa dima wokke hamme kaa'nere ekka yit shiiphe: ");
INSERT INTO jnjl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Abataaso! Shunfaatane han ta ephphatoonak fa shanani toofooson tayistan shaalwa. Es bar dey ne shuntasimato sinuntano ta shunnaasimatota.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Estan Ha'oosi wosiya dey saman yaara barin chini. ");
INSERT INTO jnjl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Es kabaasik akamanon tiir'o barin ephaan shiiphet feer. Chawobaas dey harinnimato daasta tokit faar. ");
INSERT INTO jnjl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Shiiphotan kabire nawobaaski wolle ye. Baasso dey suumotan kabi chowa kunefeen danne ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«Awagan kuntirinso? Fatanasi girunoytimato kabira shiiphotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus es baro makefeen asire heppe nawobaasasin isa Yuuda sinfe bar showo asuni zoonsire yeere kar'i. Yuuda dey Yesusnin daamok tai'se. ");
INSERT INTO jnjl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sinuntano Yesus: «Yuudano! Asuni Naani daamoknoso aatira imatari?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesusneen ane fe nawoni meya es chowaason biyaat: «Daamiiso! Siifok kaconiroso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Baassossin isaas maagni gaanynye meeni gaanynyani wostinynyaasa hoi'ta odonon kace. ");
INSERT INTO jnjl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sinuntano Yesus: «Beywa! Hepsa effatena wuza zagutaatawa» iyaat asusa odonon ta'ire fati. ");
INSERT INTO jnjl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Estan Yesus barin ephak yeese maagni gaanynye meyanon, betemeqdesiisi tasoni meyanon ha'sife baassonawa kur'uni meyanonna ekka yi: «Bo'inynyani ephni asunimato siifonewa mukne ephpha yaasetiyoso? ");
INSERT INTO jnjl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wonna wonna betemeqdesiissi nittoneen ane faana kabaasik aane ephoweti. Haye han bar nittotnawa talmaasi ha'sune asi wonawa.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Estan Yesusnin epha asuni meya Maagni gaanynye meeni gaanynyaasa ojni keerkalo taamete. Phexiros dey woksok barneen ane hamdifer. ");
INSERT INTO jnjl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Asuni meya Maagiisa ojni keerkalo geya sookere isarik diifaat besisedifer. Phexiros dey baasso ganeyaassi geeni besuk di. ");
INSERT INTO jnjl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Isa keeri wostinynya Phexiros geeni diya diifen gasasira biyaat: «Han asus Yesusneen ane feerwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sinuntano Phexiros: «Ne han asuse! Makefata barin aane arifatwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Garono feere isa asu dey biire: «Ne baassossin isaaswa» yi. Phexiros: «Ne han asuso! Tatewa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Garo wonaneen orfo oom asu dey Phexirosni biyaat: «Futok han asu Galiilakir sinna boor'a barneen ane feerwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sinuntano Phexiros: «Ne han asuso! Makefata baron ta aane arifatwa.» Es baron makere koi'sunoyfeen geregere ako oori. ");
INSERT INTO jnjl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Es kabaasik Yesus yerqere Phexirosnin bi. Phexiros: «Hash hawung ako oorunoyfeen keeza wolla taan mormotawa» yire Daamiis makena kaamaason yaadate. ");
INSERT INTO jnjl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ek gerakalo kesse akamanon suumere waasi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Es kabaasik Yesusnin ephaat fe asuni meya barin kanyere icheset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Aaffaason ukaat: «Oonso neen ichari? Raajju sinfaatane aribbo?» yit feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Showo wuza maket me'et feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wonfana kabaasik daraasa kur'uni meya, Maagni gaanynye meenawa Museni tumaasi assinynyana zuuttesete. Estan Yesusnin es baasso kuphamaasta tai'sisete. ");
INSERT INTO jnjl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ekka dey yisete: «Ne Kiristoosnoso? Innok makebbo.» Yesus wolgire ekka yi: «Makefanak aane amanefeti. ");
INSERT INTO jnjl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mamsifanak aane wolgifeti. ");
INSERT INTO jnjl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sinuntano hawungneen kabira Asuni Naa Ha'oosi hugnani hoi'ta ulfinto dimaasta duunirwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Es kabaasik zuuttesere: «Eekin ne Ha'oni naanoso?» yisete. Bar dey: «Aa, sinnaason nittonu maksetiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Baasso dey: «Hanneen ekalo oom zaal aane sholsifewa. Innonu basa noonoossin odeniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Esta fe asuni meya zuuttesere kabi Yesusnin ephere Pilatosniki taamete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ekka yit barin malatesete: «Han asus daraniisin eshfeen, keesarnik girbo giribtonoynamato kalfeen dey: ‹Ta Kiristoos taatowa› yifeen danni.» ");
INSERT INTO jnjl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatos: «Ne Ayhudni taatonoso?» yire mamsi. Yesus dey: «Ne yitaasimatowa» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Estan Pilatos maagni gaanynyaniknawa daraasikna ekka yi: «Ta han asusatan isa mangsune aane danutwa.» ");
INSERT INTO jnjl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sinuntano baasso: «Han asus Galiilan kabira hanta kar'ananneen, Yuudaki daa zuuttambaase asiissi daraasin manguk kabgit feerwa» yiset chinire malatesete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatos Galiilan yiste baron odenaase: «Han bar Galiilaki asunoso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesus Herodisni ha'suussin yeer sinbaason Pilatos araat Herodisniki wosi. Es kabaasik Herodis Yerusalem yeere feer. ");
INSERT INTO jnjl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodis Yesusnin biyanak showo wona sholet feer sinna boor'a biinaase akamanon gire. Yesus zagit feefena biistera artonoy wuzason wosten biyanak sholet feer. ");
INSERT INTO jnjl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Es bari boor'a Yesusnin showo mamsu mamsi. Sinuntano Yesus isanne aane wolguwe. ");
INSERT INTO jnjl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Maagni gaanynye meenawa Museni tumaasi assinynyana chinire malatet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodis meya taar'obaasneen ane Yesusni kashshire kanynye keeshu maama maysire wolgire Pilatosniki gafki. ");
INSERT INTO jnjl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodisnawa Pilatosna zeemme faassere feyiis es wono ganere zomo sinete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Estan Pilatos maagni gaanynyanin, daraasin ha'sife baassotnawa daraasinna isarik zuutire teege. ");
INSERT INTO jnjl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ekka dey yi: « ‹Han asu daraasin mangu ugnak zoonsiwa› yira taaki teshsheti. Ta nitto sinak tu'nira nitto maketi malataassin isa mangsu basaastan aane danut. ");
INSERT INTO jnjl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Esiisimato Herodis dey isa mangsu aane dane sinna boor'a innoki wolgire gafki. Ese han asusin kituta katuni mangsu aane zaguwe. ");
INSERT INTO jnjl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Es bari boor'a baak ichcha kotanawa.» ");
INSERT INTO jnjl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatos heebo heeboosi wonak isa taatonin baassok kotar. ");
INSERT INTO jnjl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Estan dara zuuttere isarik: «Han asusin tishkaat Barbaannin innok kotwa» yit chaagete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barbaan katamaassi fe daraasin manguk kabgubaasiknawa kaa worubaasikna taatere fe asu. ");
INSERT INTO jnjl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatos Yesusnin kotanak sholefaat hepsa daraasin mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sinuntano daraas: «Suutwa! Suutwa!» yit chaagete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatos keezsa wolgire: «Han asu wostena mangsu aambanso? Ta barin kituta katuni mangsu aane danut sinna boor'a ichcha kotanawa?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sinuntano baasso kaambesiison teggire: «Suutwa» yisete. Baasso chaagaas dey aatami. ");
INSERT INTO jnjl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Es bari boor'a Pilatos sholseteeson zagsonek baassok aatire imi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Daraasi manguk kabgirenawa kaa worirena taatere fe Barbaannin kotanak mamussete. Es asusin dey baassok kotaat Yesusnin sholseteeson zagsonek aatire imi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesusnin ephphe hamefeen Kerenaki asu Simon yiste ugunni wof balagarin katama yeefeen danere mesqeliison wossire basa orfoose hamanak zagsete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Showo dara dey Yesusni orfoose hamedifer. Es baassossin nibbesiison ki'et, waasset fa mashkasu faaser. ");
INSERT INTO jnjl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sinuntano Yesus baassoki yerqere ekka yi: «Nitto Yerusalemki mashkasuse, nitto teetasiknawa naanggotnitiisikna waasutitano taak waasutiita. ");
INSERT INTO jnjl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ese: ‹Zagiyaas, koonunoy magaasewa tanunoy tamaase suusto› ustona wona yoona. ");
INSERT INTO jnjl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Es kabaasik asuni meya aamaason: ‹Innoosta gandowe› Kumaason dey: ‹Innotin aachuwe› uuk kabosone ");
INSERT INTO jnjl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ese han baron kewa i'oosta ekka zagtenanneen ichmaasta awu zagsonkoso?» ");
INSERT INTO jnjl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Esiisimato mangu wosto woste hep asunin dey Yesusneen ane woruk ephphe hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Keraniyo yiste dimaasta kar'eteese Yesusnin esta suutete. Dey mangu wosto woste asusakitonin isaasin hoi'taasta, hepsaasin aldaasta suutete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Esseen orfo Yesus: «Abataaso, zagsefe baron aane arsoto sinna boor'a feeshun uwa» yi. Meya taar'oni meya dey maybaasta ixa ha'sere haa'esete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Es kabaasik daraas yerefa biidifer. Daraasin ha'sife baasso: «Oomiisin fu'e, Ha'o barin korina Kiristoos sinfaanane teetbaason fu'en biyaniwa» yit kanyesete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Meya taar'osakito dey esiisimato kanyesete. Barki tai'sere suqaro wayinini usha imet: ");
INSERT INTO jnjl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Esiisimato dey: «Ne Ayhudni taato sinfaatane teetneeson fu'owa» yiset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Suuttena mesqeliisi teetta: «Haniis Ayhudni taatowa» yifa ticha tichire yeetisete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mangu wosto wostere suutte baassossin isaas Yesusnin: «Ne Kiristoostenoso? Ese teetneesonnawa innotinna fu'owa» yit me'i. ");
INSERT INTO jnjl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sinuntano hepsaas wolgire ekka yit ke'i: «Neyista kituni mangsu katera feen Ha'ooson aane digefenoso? ");
INSERT INTO jnjl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Inno zagini mangsuusik sholsu ke'o ephpha taadifenir. Sinuntano han asus isa mangsu aane mangsuwewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tusire Yesusnin: «Daamiiso! Taato sinna yaafata kabaasik taan safarowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus wolgire: «Neek futo makefawungwa, hash hawung taneen ane genneti footawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Es kabaasik wonaasi issun sa'atin kabira izgin kar'ananneen daas zuuttera talme. ");
INSERT INTO jnjl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Awaas talme; betemeqdesiisi yinu heppik karate. ");
INSERT INTO jnjl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesus akama tega kaamak chaagge: «Abataaso! Kaanaason ne kushuussi adarak imingwa» yi. Es kabaasik geregere kaabaas kesi. ");
INSERT INTO jnjl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tii meya taar'oni gaanynyaas sina chowaason biinaase: «Han asus futok ookowa» yit Ha'ooson galatte. ");
INSERT INTO jnjl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Es baron biyak esta zuuttere fe asus sina chowaason zuutire biyeteese nibbesiison ki'et wolsete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesusnin tai'sonon arsefe baassonawa Galiilan kabsere basa orfoose hama mashkasuse zuuttere woksok yersefaat sinfa wuzason biyet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ayhudni shongo zuuttesefe baassossin isa Yosef yiste ma'a ooko asu feer. ");
INSERT INTO jnjl_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Es asus Yesusniista zagte kituni mangsuni kar'ni chowaassi aane giruwe. Bar dey Armatiyas yistefa Yuudani katamaassi Ha'oosi taatoni yoonon abdik oodet feer. ");
INSERT INTO jnjl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilatosniki hamme Yesusni dugnooson imanak shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Estan dugnooson kessire maama kimme shu'ak katera hoore oonu kabbartonoyna moogsi kabbare. ");
INSERT INTO jnjl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Es baron zaginaas beysani wonni hooroni wonaasik. ");
INSERT INTO jnjl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galiilan kabsera Yesusni orfoose ya mashkasusikito Yosefneen hamera moogaason biye. Dugnobaas dey aakka kabbartenamato biyete. ");
INSERT INTO jnjl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Estan keebesi wolsere dugnooson woshshuk kimaminewa shittone hoossisete. Tumaasimato beysani wonaasik beysa ephete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Guddani wono wonsa waassiise mashka meya hoossisete shittooson ephere ek moogaaski hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Moogaasta uktera kuni shu'aas bukalera kunfeen danete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Sinuntano moogaassi mogire biyeten Yesusni dugnooson aane danoto. ");
INSERT INTO jnjl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Han bar aambanso iyaat diinqesefeen akamanon palpalu chaaret yere maya mayo hep asu baasso tesha yere. ");
INSERT INTO jnjl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mashka meya digsefaat daassi biyefeen asusakito baassok ekka yi: «Hayew sina barin awuniron kituni meeni ganeyaassin sholedifetirin? ");
INSERT INTO jnjl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Bar kabi! Hantak aafe. Galiilaki feena kabaasik awu makenamato yaadatoti. ");
INSERT INTO jnjl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹Asuni Naa boor'ni meeni kushuussi aattere imtonak, suuttonaknawa keessinari wono kitun kabunakna sholsu› yire makenar faar.» ");
INSERT INTO jnjl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mashka meya dey Yesus makena kaamaason yaadatesete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Moogaasi estan wolsere biyete baron zuutire asire isse nawobaasiknawa oom meyakna maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Es baron wosini meyak maksees megdelawitki Maarami, Yohannanewa Yaqobna asi into Maarami, dey ooma mashka meya feeseter. ");
INSERT INTO jnjl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sinuntano baasso mashka meya maksete bar miitone faar sinna bestena boor'a aane amantosoto. ");
INSERT INTO jnjl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sinuntano Phexiros kabi moogaaski eeli. Esta kar'faat sir mogire biin sesa kinoni maamaas bar bar kunfeen biyaat diinqet wolle keer ye. ");
INSERT INTO jnjl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Es wono nawoni meyaassin hep asu kabire Yerusalemun asire heppe kiilo meetiri wokba faana Hemawos yiste ke'esi hamedifer. ");
INSERT INTO jnjl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Baasso dey sina chowaason zuuttambaase kabgire wolumsedifer. ");
INSERT INTO jnjl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Es chowaason safaretnawa wolletna feeseten Yesus tai'sere baassoneen hamdifer. ");
INSERT INTO jnjl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Sinuntano aafbesiisik biyefet bar oo sinnamato aane arsoto. ");
INSERT INTO jnjl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesus dey: «Ugunne hamfaat nittotna nittotna wollefeti wuzaas aambanso?» yi. Baasso dey suumere shaakkire yessete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Baassossin isa Keleyopha yistefe asus ekka yi: «Hangnettaki wonaassi han Yerusalemuk sina chowaason arunoy asu nenenetu irbawa.» ");
INSERT INTO jnjl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Bar dey: «Sina chowaas aambanso?» yi. Baasso dey ekka yisete: «Naaziretki Yesusniista zagte barwa. Bar Ha'onewa asu zuuttambaase asi sinana wostoknawa kaamakna chim raajjuwa. ");
INSERT INTO jnjl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Barin maagni gaanynyanawa innotin ha'sife baassotna kituni mangsu kar'e aatire imere suutete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sinuntano inno Israelnon furonirwa yira abdi zaginiis baringwa. Es bar sinnanneen hawung keez wonawa. ");
INSERT INTO jnjl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Inno ganeyaassin isa isa mashka meya innotin diinqisisetewa. Baasso wonsa waasi ek moogaaski hamere dugnobaason turuksete. Wolsere bar hayew sinbaason make Ha'oni wosini kaama odesenamato innok maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Inno ganeyaassin isa isa meya ek moogaaski hamme es mashka meya makseteesimato sinin biyete. Sinuntano Yesusnin aane biyoto.» ");
INSERT INTO jnjl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesus dey baassok: «Nitto yaadatonoornawa raajjuni meya maksete baron amanok nibnitiis taptonor. ");
INSERT INTO jnjl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kiristoos han shanaason ephphetoonaknawa den ulfinbaaski girunak aane sholsifano?» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Estan Museni tumaassinnawa raajjuni meeni tichaassinna kabgire barik tichche baron korto ticha zuuttambaase asiissin kisaafe assi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Baasso hamefe ke'eessi tai'sesefe kabaasik Yesus aatte hamninne feer sinne baassok beste. ");
INSERT INTO jnjl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sinuntano baasso: «Gerok waali, awaas dey giridifar sinna boor'a innoneen ha'uwa» yit chinire shiiphsete. Bar dey baassoneen ha'uk keer giri. ");
INSERT INTO jnjl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Baassoneen ane muuk di. Tushaason dey ephphe galattefaat batte imi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Es kabaasik aaffesiis gachchen Yesus sinbaason arsete. Sinuntano bar baasso sinan tishi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Baassotna baassotna dey: «Ugnaasta faani innotin wolumsit kayma tichaassin kisaafe maken nibniison geenimato matanoso?» yisesete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Es kabaasik kabsere Yerusalem wolle hamete. Estak asire isse nawobaasnawa baassoneen feese baassotna asin isarik zuuttere feeseten danete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Baasso dey: «Daamiis futok kabiwa! Simoonniknu bestewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Es hep nawoni meya ugnaasta sina barewa Yesus tushaason batfena kabaasik aakkak arsetematona maksete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Es baron wolumsefeen Yesus bar ganebesiissi yerefaat: «Naga nittok sinfawung!» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sinuntano baasso nayere kita biyetenne faar sinfaan digak tuumete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesus dey ekka yi: «Awuniron nayedifetirinso? Awagan nibnitiissi mamefaso? ");
INSERT INTO jnjl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kushunaasewa wochonaase asin biiti. Taptira ta sinnaason aruti. Taan biifetiisimato kitaas ashnewa megane barki aafawa.» ");
INSERT INTO jnjl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Es baron makefaat kushubaasewa wochobaase asin baassok besi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Baasso dey giraknawa diinqokna tuumefaat bar sinbaason aane amanosoto. Yesus dey ekka yi: «Isa maastoni wuza faaroso?» yire mamsi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Baasso dey kiichcho kurxummi imete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Bar dey ephphe baasso sinak me. ");
INSERT INTO jnjl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yesus ekka dey yi: «Nittoneen ane faana kabaasik Museni tumaassi raajjuni meeni tichaassinawa gaamni tichaassina taak tichche bar zuuttera ko'unak sholsu yira nittok makenaas haniiswa» yi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Es kabaasik korto tichaason yaadatsonek nibbesiison gachi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ekka dey yi: «Kiristoos shana ephphetoonamatonawa keezsinari wono dey kitun kabunamatona zeemma tichchera faar. ");
INSERT INTO jnjl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Esiisimato dey Yerusalemun kabira dara zuuttambaase asik harminewa boor'ni fakine basa sunaasik awastonir yistera tichche. ");
INSERT INTO jnjl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Es barik nitto zaalwa. ");
INSERT INTO jnjl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ta abataas nittok imna abdiison nittok wosuna. Nitto dey denun hugna imtona kabaneen Yerusalem katamaassi footi.» ");
INSERT INTO jnjl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Esseen orfo nawobaasakitonin ephphe Bitaniya hami. Kushubaason kabgire baassotin suusi. ");
INSERT INTO jnjl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Suusfet baassostan oor kesse den sama hami. ");
INSERT INTO jnjl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Baasso dey barik kaa'nere akama girak Yerusalem wolle hamete. ");
INSERT INTO jnjl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ha'ooson galattet wonna wonna betemeqdesiissi aane tishisefe.");
INSERT INTO jnjl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Zeemmaneen kaam feer. Bar dey Ha'ooskitu fe; Kaamiis dey Ha'o; ");
INSERT INTO jnjl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bar dey zeemme Ha'oosneentu fe. ");
INSERT INTO jnjl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Zuuttambaase bariktu teste; teste wuzaas zuuttera barki kamotu teste; isa wuzane barneen gerakalo tester aafa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kaa barki faar; es kaas dey asunik chaarefa sinna faar. ");
INSERT INTO jnjl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Chaarefaas talmaassi chaarsir; talmaas baron aane merowa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ha'ooskin wostere ye sumba Yohannis yiste isa asu feer. ");
INSERT INTO jnjl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Zuuttambesiise barki kamo amanosonek bar chaarefaasi chowanon zaala makonaktu ye. ");
INSERT INTO jnjl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Chaarefaasi chowanon zaala makonaktu yeeteno bar chaarefte. ");
INSERT INTO jnjl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Asu zuuttambaase asik chaarsuni futoni chaarefa han daasta yaadifar. ");
INSERT INTO jnjl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Han daasta feer; han daas bariktu teste; sinfanaknu han daas aane ephphatowa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Basa keen sina baassoki ye; sinuntano baasso barin aane ephphetoosoto. ");
INSERT INTO jnjl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sinuntano ephpheteesere sunbaasik amanefe baasso zuuttere Ha'oni naanggota sinonek mabti imi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Baasso Ha'oni naanggota sinetees asuni tumak wedey hannakin wedey ashakin wedey teegoni fiqadik aane koontosoto. Baasso koontesetees Ha'okingwa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kaamiis asha sinne inno ganeyaassi ha'i. Inno dey Ababaaski feena kabaasik fa ulfinbaasne fa isa naa bar basa ulfinaason biini. Bar dey Ha'oni otumaknawa futokna tuum. ");
INSERT INTO jnjl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohannis basa chowaason zaala maket: « ‹Ta orfoosta yooni bar taneen sinak feer. Tayistan dey denalo› yira makenaas barwa» yire chaagi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Basa tumaastan inno zuuttamniise otmaasta otma daysira ephphataani. ");
INSERT INTO jnjl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tumaas Museniki kamo imte. Sinuntano otumnewa futone Yesus Kiristoosniki kamo ya. ");
INSERT INTO jnjl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ha'ooson biyar oonu aafe. Sinuntano abani sina Ha'oosneen fe isa naas bar bar Ha'oos oo sinnamato innok ammanon besi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ayhudni meeni ha'sinynyani meya Yerusalemun maagni meenawa baassotin argassefe Lewini meena asin Yohannisniki wosisere: «Ne oonso?» yire mamussisete kabaasik makena zaalni kaamaas haniiswa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bar dey aachunoy: «Yoonir yiste muudtos tatewa» yire ammanon make. ");
INSERT INTO jnjl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Baasso dey: «Eekin ne oonso? Eliyasnoso?» yire mamussete. Bar dey: «Indaanewa» yire wolgi. Baasso dey: «Eekin raajjunoso?» yisete. Bar dey: «Indaanewa» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Baasso dey: «Eekin ne oonso? Innotin wosi baassok hamma makonik ne teetaason oo yifasso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Bar: «Raajju Isayyasniissi maktenaasimato ‹Daamiisa ugnanon zeep'ti› yire ichma daassi chaagfe asusa kaamatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Baasso wostere yeesetees Ferisawini meyakin. ");
INSERT INTO jnjl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Baasso dey Yohannisnin: «Ese ne Kiristoos wedey Eeliyas wedey yoonir yiste raajjuus sina shakaatane awuniron haphqidifa?» yisere mamussete. ");
INSERT INTO jnjl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohannis wolgire: «Ta akaktu haphquna. Sinuntano nitto arunoytir ganentiissi yereferwa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ta orfoosta yooni basa chaa'maasi taar'anon kotak sholsunoynar barwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Han bar zuuttera sinnaas Yohannis haphqit feena Yordanosni akaasi yesalo awa kesnarki fa Bitaniyaktu sini. ");
INSERT INTO jnjl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wonotirik Yesus Yohannisniki yeefeen biyaat ekka yi: «Ese han daasta fe asusa boor'anon baassostan tishkuni Ha'oni fantu ");
INSERT INTO jnjl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‹Ta orfoosta yooni bar taneen sinak feer. Tayistan dey denalo› yira makenaas barwa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tanu es yooni barin aane arifatwa. Sinuntano ta akak haphqit yaanaas Israelni meyak barin arsonekwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohannis ekka yire zaala make: «Korto Ayyana saman nakalone faar sinna basaasta kerefeen biin. ");
INSERT INTO jnjl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Akak haphqunak taan wosi bar: ‹Korto Ayyana kerefeennawa basaasta diifeenna biyata bartu Korto Ayyanak haphquniiswa› yira makena kabaneen tanu aane arutwa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ta dey biina boor'a bar Ha'oni naa sinbaason zaala makefan.» ");
INSERT INTO jnjl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Wonotirik Yohannis hep nawobaasneen esta yerefer. ");
INSERT INTO jnjl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesus estak aatfeen Yohannis biyaat: «Ese haniis Ha'oosi fantuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hep Yohannisni nawoosakito Yohannis es baron makefeen odesefaat Yesusni orfoose hamete. ");
INSERT INTO jnjl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Baasso Yesusni orfoose hamefeen yerqere biyaat «Awu sholedifetirinso?» yi. Baasso dey: «Rebi! Ayinso faafatari?» yisete. (Rebi! Uus assinynya uu.) ");
INSERT INTO jnjl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Bar dey: «Yaara biitiwa» yi. Hamere feefenamato biyere Es wono ane feeshete. Es kabaasik dey wonni asir sa'ati sinana. ");
INSERT INTO jnjl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yohannis makena kaamaason odere barneen ane hame nawoosasin isa Simon Phexirosni ay sina Andriyas feer. ");
INSERT INTO jnjl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Bar zeemme ayba Simooniki hamme: «Mesiisin danniwa» yi. Mesi uus muudto uu. ");
INSERT INTO jnjl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yesusniki dey ephphe ye. Yesus barin biire: «Ne Yona'ani Simoonwa, ne hawungneen ekalo ‹Keefa› yisteratu teegtotawa» yi. Kotbaas dey «Phexiros wedey Inya shu'a» uwa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wonotirik Yesus Galiila hamanak shole. Filiphosnin dey danne: «Taneen ane hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filiphoos dey Andriyasnawa Phexirosna asimato Betesayidaki katamaassitu feesefe. ");
INSERT INTO jnjl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filiphoos Naatinaelnin danne: «Museni tumaassinawa raajjuni meya basa chowbaason tichisete barin daningwa. Esiis dey Yosefni naa Naaziretki Yesuswa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naatinael dey: «Naaziretun ma'a wuza kesak chimniroso?» yi. Filiphoos: «Yaara biwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesus dey Naatinael hang barki yeefeen biyaat: «Futoni Israelni asu hanifewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Naatinael dey: «Taan ayik arifasso?» yit mamsi. Yesus wolgire: «Filiphoos teegonoyfeen Belesini i'oosi diisi diifen biingwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naatinael wolgire: «Assinynyano! Ne Ha'oni naawa. Ne Israelni taatowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus wolgire: « ‹Belesini i'oosi diisi diifen biingwa› yina boor'anoso amanetari? Haniistan denalo wuzanu biyatarwa. ");
INSERT INTO jnjl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Futok nittok makefawungwa; Samaas gachchefaan Ha'oosi wosiya daa Asuni Naaski kerefeennawa kesfeenna biyatiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Keezsinari wono Galiilani awurajjaassi Qaanani katamaassi sargi faar. Yesusni intoos dey estak faar. ");
INSERT INTO jnjl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesusnawa nawoni meena es sargiista teegtesere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Waynini ushaas ko'ifana kabaasik Yesusni intoos: «Waynini ushbesiis koi'faantu feesetewa!» yira Yesusnik make. ");
INSERT INTO jnjl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesus wolgire: «Intonaase! eekin taan awu zaguwa yifasse? Ta wonaas hashnu aane kar'awe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesusni intoos dey wostinynyani meyak: «Bar makena baron zuutira zagutiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayhudni meya masere kayimefe tumaasimato issun shu'ni waasha esta diisefar. Isa isarbaas hep wedey keez gima akatu ephfa. ");
INSERT INTO jnjl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus wostinynyani meyak: «Waashasikitosi aka tuunutiwa» yin noonobaastaneen katisere tuunisete. ");
INSERT INTO jnjl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Estan Yesus: «Hash kitta kootaasi gaanynyanik imtiwa» yin imete. ");
INSERT INTO jnjl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Gaanynyaas waynini usha sina akaason bechchire biin ayin yaanamato aane aruwe. Sinuntano akaason kita wostinynyani meya arsedifer. Gaanynyaas mariisin teegere ");
INSERT INTO jnjl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Asu zuuttambaase zeemme ma'a waynini ushaasontu imfe. Estan ushshe zaysetenneen orfo manguuson imfe. Ne ma'a waynini ushaason hashneen duusaan diifar» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesus es biistera artonoy wuzason zeemme Galiilaki fa Qanak zaguk ulfinbaason ammanon besi. Nawoni meya dey barik amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Esseen orfo Yesus intobaasneen, aybaasakitonen, nawoni meyaneen ane Kifirnahom kersete. Estak garo wona diisete. ");
INSERT INTO jnjl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayhudni meeni faasikani heeboos tai'sera faar. Yesus Yerusalem kesi. ");
INSERT INTO jnjl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Betemeqdesi yaboosta miyaason, fantuuson, nakalooson waagsefe baassotin dani. Dey oom waaga soolefe baasso diisefa waaga soolesefen bi. ");
INSERT INTO jnjl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Gaaduni alangga ma'ire fantuusonnawa miyaasonna zuutire betemeqdesiisi yabotan kalle kisi. Sooltefa waagbesiison dey sikere tarabbezaason shelgire ha'i. ");
INSERT INTO jnjl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nakalo waagsefe baassotin: «Han baron hantan ephpha kesti! Abataasa keyanon nagadni keya zagutiita!» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nawoni meya dey: «Keeneesik fa ta seektoos taan mawa» yistera tichchenamato gasasisete. ");
INSERT INTO jnjl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ayhudni meya dey: «Han zagifata barik aro biistera artonoy wuza innok besutasso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesus wolgire: «Han betemeqdesiis kiddiste kiddusaninon bogaani ta keessinari wono wolgira keer'anawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ayhudni meya: «Han betemeqdesiis kiddiste kiddusani acheechasire issune neya koi'siratu keetera kesi. Eekin ne aakkak keessinari wono keer'a?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sinuntano Yesus basa atusontu: «Betemeqdesi kiddiste kiddusani» yire make. ");
INSERT INTO jnjl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Es bari boor'a Ha'oos Yesusnin kitun kabinanneen orfo nawoni meya es baron makenamato nibesiista keji. Estan tichaasewa Yesus makena kaamaasonna amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesus faasikani heeboosi wono Yerusalemuk zagina biistera artonoy wuzason biyete boor'a showo asuni meya barik amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Bar asusa nibsi fa wuzason zuutire arir sinna boor'a oonu asuni chowa barik makonak aane sholsifa. Yesus asuni meyanon zuutire arifena boor'a baassotin aane amanefe. ");
INSERT INTO jnjl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ferisawini keen sina Ayhudni gaannye meyaassin isa Nikodimos yiste asu feer. ");
INSERT INTO jnjl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Bar isa wono talmak Yesusniki yeere: «Assinynyano! Ha'o barneen sinna asu sina shakaanane han ne zagifata biistera artonoy wuzasikitonon zaguk chimnir aafewa. Es bari boor'a ne Ha'okin ye assinynya sintamato arifeniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus wolgire: «Futo neek makefangwa: Asu hepsa koonto shakaanane Ha'oosi taatonon biyanak aafa chimanawuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimos dey: «Asu kur'inanneen orfo aakkak hepsa koontok chimnirinso? Hepsak intobaasi keensi girire koontok chimniroso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus wolgire: «Futo neek makefangwa: Asu akakinnawa Ha'oni ayyanakinna koonto shakaanane Ha'oosi taatosi giruk aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Asunikin koonte bar asuwa. Sinuntano Ha'oosi Ayyanakin koonte bar Ha'ooskin gaddo kaa daniwa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‹Hepsi koontotik sholsuwa› yina boor'a diinqotaatawa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Siru sholena daatu sirifawa. Kaambaasontu odota. Sinuntano ayin yaanamatonawa ay hamdifanamatona aane arifewa. Ha'oosi ayyanakin koonte bar zuuttambaase esiisimatowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimos: «Han bar aakkak sinanak chimnirinso?» yire mamsi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus wolgire: «Ne arto Israelni assinynya sinna faafaat han baron aane arifenoso? ");
INSERT INTO jnjl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Futo neek makefangwa: Arifeni barontu makefeni, biini bariktu zaala makefeni. Makefeni baronu aane ephpha taafeti. ");
INSERT INTO jnjl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Han daastaki chowanon makena amanonoy nitto den samaki chowaason makefaanane aakkak amanoti? ");
INSERT INTO jnjl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Den saman kere Asuni Naasneen oom den sama kesar oonu aafewa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Muse ichma daassi bittak wosuste zawuni besoson suutnaysimato Asuni Naa suuttonak sholsuwa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Esiis dey Asuni Naanik amanefe bar zuuttambaase koi'ba foonto kaaba foonakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Barik amanefe bar zuuttambaase koi'ba foonto kaa dananaktano tishunoynamato Ha'oos isa nawuba bar barin aatira imma han daason baak keeshtewa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ha'o isa naabaasin han daasta wosinaas daasta mangsuni kar'ak sinnoynamato han daason barki kamo fu'okwa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Barik amanefe basaasta mangsu aafa katona wuza. Sinuntano amanonoy bar isa Ha'oosi naa bar barik amano beyna boor'a mangsu basaasta katewa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chaarefaas han daasta ya. Asuni meya wostobesiis mangu sinna boor'a chaarefaason beyfaat talmaason shunete. Esiistu mangsuni kar'aaswa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Manguuson zagife bar zuuttambaase chaarefaason oomterwa. Wostobaas ammanon kesnoynamato chaarefaaski aane yeefe. ");
INSERT INTO jnjl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sinuntano Ha'o sholefana wostooson zagife bar wostobaas Ha'oosik ammanon bestonak chaarefaaski yeefewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Esseen orfo Yesus nawoni meyaneen ane Yuudani daa hamete. Estak baassoneen ane feefaat haphqidifer. ");
INSERT INTO jnjl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohannis dey Salemni tai'soosta fa Henonuk showo aka faar sinna boor'a estak haphqit feer. Asuni meya haphuktok yeefaafe haphuktet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Es bar sinnaas Yohannis taatoni keer girunoy feen. ");
INSERT INTO jnjl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yohannisni nawoni meenawa isa Ayhudni asuna asi ganeyaassi Ayhudni meeni tumaassi fa kayimni chowaasik kirikkiri kabi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yohannisnik yeesere: «Assinynyano! Yordanosni akaasi yesalo awa kesnarki neneen ane feena kabaasik ne basa chowaason zaala maketa bar dey haphqidiferwa. Showo asuni meya dey barki hamediferwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohannis wolgire: «Den saman imtonoyfeen asu isa wuza ephphetook aafawa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹Yoonir yiste muudtos tatewa. Sinuntano basa sinaastatu wostera yaangwa› yira makenamato nittonu zaala makotiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mariyaas mariisarwa, mariisin argasuk ane fe muzgituus mariisa kaamanon odefena kabaasik akamanontu girefewa. Es giraas dey taarwa. Es giraas dey hash siniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bar arkittonak, ta dey hatonak sholsuwa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Denun yooni bar zuuttambaase asi denalowa. Han daastaki bar han daastakirwa. Han daastaki chowatu makefa. Saman yooni bar zuuttambaase asi denalowa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Biina baronnawa odena baronnatu zaala makefe. Sinuntano zaalbaason oonu aane ephpheteefe. ");
INSERT INTO jnjl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Makefena zaalni kaambaason ephphete bar Ha'oos futo sinbaason gasasi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ha'oos Ayyanabaason tuunira imfana boor'a Ha'o wosina bar Ha'oosi kaamanontu makefewa. ");
INSERT INTO jnjl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Abaas naasin keeshter; zuuttambaase asin kushubaassi imi. ");
INSERT INTO jnjl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nawubaasik amanefe bar zuuttambaase koi'ba foonto kaaba faarwa. Nawubaasik amanonoy bar Ha'oosi gi'atu basaasta foonirtano kaason aafa danana wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ferisawini meya Yesus Yohannisniitan arkissire showo asuni nawoba zagire haphqit feenamato odesete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Sinuntano haphqiis Yesus sinnoynaron nawobaasakitotu haphqit feer. ");
INSERT INTO jnjl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesus dey es baron arinaase Yuudani awurajjason beyfaat Galiila hepsa wolle hami. ");
INSERT INTO jnjl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samariyani awurajja kamo aatte hamana sholsira faar. ");
INSERT INTO jnjl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Es bari boor'a Yaqob nawuba Yosefnik imna dimaasi teshta fa «Sikar» yistefa Samariyani katama ye. ");
INSERT INTO jnjl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Estak Yaqobni akani doo'a faar. Yesus ugunne kutuk hopina boor'a es doo'aasi tesha di. Es kabaasik wonaasi issun sa'ati sinana. ");
INSERT INTO jnjl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Nawoni meya dey muuni waagosi katama hamete. Es kabaasik Samariyan isa mashkasu akani kitak ya. Yesus barki: «Aka imin ushungwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Es asus: «Ne Yuudani asu sinfaat ta Samariyani asu sina taakin aakkak aka shiiphotaso?» yi. Ayhudni meya samariyani asuni meyaneen isarbesi aafa sinna boor'atu es baron make. ");
INSERT INTO jnjl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus wolgire: «Ha'oosi imanonnawa ‹Aka taak imin ushungwe› yiis oo sinnamato araatane shiiphoniis newe. Eekan bar dey kaani aka neek imana kabawe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Asus dey wolgira ekka yi: «Ne kitata wuzne aafawa. Doo'aas dey yeet wokawa. Eekin kaani aka Ayin dana? ");
INSERT INTO jnjl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ne han akani doo'aason innok ima abani Yaqobniistan arkutaroso? Barneen naanggotbaasneen waagbaasneen han barontu ushetewa.» ");
INSERT INTO jnjl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus wolgire: «Han akaason ushfe baasso zuuttere hepsa wolletu iktosonewe. ");
INSERT INTO jnjl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ta imana akaason ushni baasso zuuttere koi'ba foonto neya isanne aafa iktosone wuza. Ta imana akaason ushni barik Ha'oni Ayyana basaassi koi'ba foonto kaani kor'atu sinana» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Asus dey: «Han asuso! Iktonoynamatonawa akani kissi hanta wolla yoonoynamato es akaason taak imma» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesus dey: «Hamfaat teegoneesin teegera wolla hanta yowe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Asus wolgira: «Teegota aafewa» yi. Yesus: « ‹Teegota aafe› unees ma'aron maketwe. ");
INSERT INTO jnjl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ne uuch teegoniki girira kestarwe. Hash neneen ane fe barnu teegonete sinna boor'a maketaas futowe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Asus dey: «Han asuso! Ne raajju sintamato aringwa. ");
INSERT INTO jnjl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Inno abani meya han aamaasiktu sagadesetewa. Sinuntano nitto dey ‹Asuni meya sagadosonek sholsifanaas Yerusalemukwa› yisefeti» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesus dey ekka yi: «Han asuse, han aamaasik wedey Yerusalemuk Abaasik sagadonooyti wona yoonamato amanowe. ");
INSERT INTO jnjl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nitto Samirawiis arunoyti Ha'oktu sagadesefeti. Sinuntano faru yoonaas Ayhudnikin sinna boor'a inno arifeni Ha'oosiktu sagadefeni. ");
INSERT INTO jnjl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sinuntano futok sagadesefe baasso Abaasik kayma Ayyanaknawa futokna sagadosone wona yoona. Es bar dey hash siniwa. Abaas dey sagadosonek effatenaasontu sholefe. ");
INSERT INTO jnjl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ha'oos korto Ayyanawa. Barik sagadesefe baasso dey korto Ayyanaknawa futoosikna sagadosonek sholsuwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Asus dey: «Kiristoos yistefe Mesiis yoonamato arifawungwa. Bar yeere zuuttambaase asin innok makona» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesus dey: «Han neneen wolefees ta barwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Es kabaasik nawoni meya hameteessin wolle yeesete. Yesus mashkasusneen wollobaasik diinqesete. Sinuntano: «Awu sholedifa wedey Asusneen Awagan wolledifa?» yire mamsir oonu aafe. ");
INSERT INTO jnjl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Estan asus gimaason estak beyfaat katama hamma asuni meyak: ");
INSERT INTO jnjl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ta zagina baron zuutire make asusin yaafaat biitiwa. Toogiso bar Kiristoos sina beyungeso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Asuni meya dey katamaassin kesere barki yeesete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Es kabaasik nawoni meya: «Assinynyano! Maktetwa muwa» yit shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sinuntano bar: «Nitto arunoytir ta muuna muu taak faarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Es bari boor'a nawoni meya: «Bar muuna muu ephphe ye asu feerteso?» yisesete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesus baassok ekka yi: «Ta muu taan wosi basa safaraason zagunewa wostobaason koi'sunakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nitto ‹Meeni zuutu kar'anak acheech assatu faarwa› yifetitanoso? Ese nittok makefawungwa ‹Kaanna hash meyaas katnamato fosshaason biitiwa› yifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kar'ni bar wostobaasi waaganon ephphetoonirwa. Koi'ba foonto kaak sinni gaana zuutuna. Es bari boor'a bukni barnawa kar'ni barna ane girosone. Ese bukfeesewa kar'feese isaruk girsonekwa. ");
INSERT INTO jnjl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‹Isaas bukana isa ay kar'ana› yifa kaamaas han baristak futo siniwa. ");
INSERT INTO jnjl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ta nitto hopunoytiison kar'atik wosingwa. Oom meyaas hopsesete. Sinuntano nitto baasso hopsesete baron zuutiti.» ");
INSERT INTO jnjl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mashkasus: «Ta zagina baron zuutire taak makewa» yira makena kaamaasik es katamaassi feese Samariyaki asuni meyaassin showobesiis barik amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samariyaki asuni meya Yesusniki yeesefe kabaasik showo wona baassoneen ane foonak shiiphsete. Bar dey esta hep wona feeshi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yesus makena kaamaasik oom showo asuni meya amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mashkasusik dey: «Hanneen ekalo ne maketa boor'a sinnoynamato inno teetniisik odeni boor'a bar futoknu han daason fatunir sinnamato ariniwe» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Hep wonaneen orfo estan wolle Galiila hami. ");
INSERT INTO jnjl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesus zeemme «Raajju basa daasta aane ulfintefe» yire makenar faar. ");
INSERT INTO jnjl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sinuntano Galiila kar'fena kabaasik Galiilaki asuni meya faasikani heeboosik Yerusalem hamfena kabaasik Yesus zagina chowaason biyete boor'a barin ma'arik ephpheteesete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Esseen orfo Yesus akaason wayinini usha zagire soolena daa Galiilaki Qaana hepsa wolle ye. Es kabaasik Kifirnahomuk naaba mettena isa taatoni herasho feer. ");
INSERT INTO jnjl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Herashoos Yesus Yuudan Galiila yeenamato ode. Naabaas kitunak akamanon mettere feer sinna boor'a Yesusniki yeere: «Kifirnahom kerera naataasin fataywa» yire shiiphphe. ");
INSERT INTO jnjl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesus dey: «Nitto biistera artonoy wuznewa diinqi chowne biya shakaatine isanne aane amanefetiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Herashoos dey: «Daamtaaso! Naataas kitunoy feen tai'ni kar'wa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesus barik: «Hamma! Naanees farunawa» yi. Asus Yesus barik makena kaamaason amanere hami. ");
INSERT INTO jnjl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wolle hamfeen basa wostinynyani meya barin sholok kesere ugunta uphsere: «Naas fariwa» yisere maksete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Bar: «Naas apun sa'atikinso farinari?» yire mamsin. Baasso wolugsere: «Hazo naafun sa'atiktu atubaasi gumtana gafkiwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Naasa aba dey Yesus: «Naanees farunawa» yinaas es sa'atiista sinnamato ari. Barnawa keerki asuni meyaneen ane amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Esiis dey Yesus Yuudan Galiila yeere zagina hepsa biistera artonoy wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Esseen orfo Ayhudni meeni heebo faar sinna boor'a Yesus den Yerusalem kesi. ");
INSERT INTO jnjl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalemuk fantuus girifaat kesfana finynyaasi tesha isa kuphira kuni aka faar. Es akaas Ibrawini meeni kaamak «Betezata» yisteratu teegtefa. Bar dey uuch tukbaasta ukbare yere finoba faar. ");
INSERT INTO jnjl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Es finoossi showo mettan aaftishu, laafanawa engitfe meena esta kunsefer. Baasso dey akaasi shorkonon oodet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Aat aatta daamiisa wosiya kuphira kuni akaassi keretaafa akaason shorkit faar. Es akaasi shorkoneen orfo zeemme akaassi giri asu aaffa tesa meroossinnu farit feer. ");
INSERT INTO jnjl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Estak keezasire nangne neya laafa sinne fe isa asu feer. ");
INSERT INTO jnjl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus es asusin kunfeen biyaat hashneen kar'e showo neya ekkak feenamato araat: «Farutak sholefatoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mettan asus: «Daamtaaso! Akaas shorkefana kabaasik taan akaassi kessuni asuta aafewa; ta giruk hamfana kabaasik oom asu zeemfe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesus dey: «Kabira opponeeson wor'a hamma!» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mettan asus geregere farire oppobaason wor'e hami. Es bar sinnaas beysani wonakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ayhudni meya fari asusin: «Hash hawung beysani wona sinna boor'a opponeeson wor'atak aane chimsifawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sinuntano bar: «Taan fati asus ‹Opponeeson wor'a hamma› yiwa» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Baasso dey: « ‹Opponeeson wor'a hamma› yi asus bar oonso?» yire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yesus eksere daraasa ganesi giri sinna boor'a fari asus oo fatinamato aane aruwe. ");
INSERT INTO jnjl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Esseen orfo Yesus fatina asusin betemeqdesiissi danne: «Ese haye faritwa. Haniistan denalo wuza neyista kar'noynamato hanneen ekalo boor'a wostotaatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Asus hamme Ayhudni meyak: «Taan fatiis Yesuswa» yire make. ");
INSERT INTO jnjl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Beysani wonaasik es baron zagina boor'a Ayhudni meya Yesus kesse girunoynamato kalak sholset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sinuntano Yesus: «Abataas hash hawungneen kar'e wostedife. Ta dey wostenarwa» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Esenu beysani wonaason ooda beybaas bar bar sinnoynamato teetbaason dey Ha'ooseen isar zagire: «Ha'oos taak abatawa» yina boor'a Ayhudni meya akamanon woruk sholset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tusire dey baassok ekka yi: «Futo nittok makefawungwa, Abaas zagifeen biinaysontano naas teetbaasik isa wuzane zagunak aafa chimanawuza. Abaas zagifena barontu zuutire naas dey zagifewa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Abaas naasin keeshter sinna boor'a bar zaguna baron zuutire besifewa. Nittonu diinqotimato haniistan denalo wostonu besuna. ");
INSERT INTO jnjl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Abaas kituussinnu kabgire kaa imfenasimato naas dey sholsefe baassok kaa imfewa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Asu zuuttere Abaasin ulfinsifenasimato naasin dey ulfinsunak mangsuni kar'aason zuutire naabaasik aatire imiwa. Es bari boor'a Abaas ooniistanu sinfaanane aafa mangsu kar'anawuza. Naasin ulfinsunoy bar wosi Abaasin aafa ulfinsunawuza. ");
INSERT INTO jnjl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Futo nittok makefawungwa, kaamnaason odefe barnawa taan wosi barik amanefe barna koi'ba foonto kaaba faarwa. Bar kituni keeruntu kaani keer finiteno basaasta aafa mangsu katona wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Futo nittok makefawungwa, kituni meya Ha'oosi naani kaamanon odosone wona yoonawa. Wonaas dey hashwa. Odefe baassonu kaak foosone. ");
INSERT INTO jnjl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Abaas teetbaasik kaaba faanamato naas dey teetbaasik kaaba foonak imiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Asuni Naa sinna boor'a mangsuni kar'ni ha'suni hugna imiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Es barik diinqotiitawa, moogaassi fe baasso zuuttere kaambaason odosone dey moogaassin kesone wona yoona. ");
INSERT INTO jnjl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ma'aron zagi baasso kitun kabire kaak foosone. Mangunon zagi baasso kitun kabiseten baassosta mangsu katona. ");
INSERT INTO jnjl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Ta ta teetaasik isa wuzane zaguk aafa chimanawuza. Mangsu kar'anaas Abaaskin odena baron koi'bawa. Taan wosi basa safaraasontano ta safaraason zaguk aane sholefat sinna boor'a mangsuni kar'naas futowa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ta ta teetaasiron zaala makefaanane kaamnaason futo zagire ephphetoonir aafewa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Taak zaala makoniis Abaaswa; Barnu taak makona zaalaas futonir sinnamato arifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nitto Yohanniisiki wosinin wositi. Yohannis dey futok zaala makewa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ta asuni zaala aane sholefat; Sinuntano nitto farutiktu Yohannis makena zaalaason makedifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohannis saamfat chaarsi tonane feerwa. Nitto dey garo wona es chaarefaasik girok sholseti. ");
INSERT INTO jnjl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Sinfanaknu ta chowaason Yohannisniistan denalo makoni zaala faarwa. Ta koi'sunak Abataas taak imna wosto han zagifana barwa. Abataas taan wosinamato zaala taak makonirwa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Taan wosi Abaas taak zaala makewa. Nitto kaambaason isanne aane odosoweti. Gitobaasonnu aane biyosoweti. ");
INSERT INTO jnjl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Bar wosina barin amano beyti boor'a kaambaas nittoossi aafa foona wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nitto barik koi'ba foonto kaa danatinne faar sinna bestefaan tichaason wee'efetiwa. Es tichaasnu taaktu zaala makefawa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sinfanaknu nitto kaanti foonak taaki yoo aane sholofeti. ");
INSERT INTO jnjl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Ta asunikin ulfina aane sholefat. ");
INSERT INTO jnjl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Sinuntano Ha'ooson keeshto nibnitiissi aafa sinnamato arifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Abataasa sunak ye taan aane ephphatoweti. Oomiis teetbari sunak yeen barin ephpha taasetir. ");
INSERT INTO jnjl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nittotna nittotna wal ulfina sholet fe nitto isa Ha'ooskin bestoni ulfinaason aane sholefeti sinna boor'a aakkak amanok chimatirinso? ");
INSERT INTO jnjl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ta Abaasa sina nittotin malatonanne faar sinna bestonaatawa. Nittotin malatoniis nitto abdatefeti Musewa. ");
INSERT INTO jnjl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Museni amaneseti sinfaanane taan dey amanoti kabawa. Bar ta chowaason tichire feer. ");
INSERT INTO jnjl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tichaason amano shakfaatine kaamnaason aakkak amanotirinso?» ");
INSERT INTO jnjl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Esseen orfo Yesus Tiberiyados yistefa Galiilani baarisi yesalo hami. ");
INSERT INTO jnjl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mettanni meyanon fatuk zagina biistera artonoy wuza biisete boor'a showo dara barki hamete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesus nawoni meyaneen ane aamaasta kesse di. ");
INSERT INTO jnjl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ayhudni faasikani heeboos tai'sera faar. ");
INSERT INTO jnjl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus showo dara barki yeesefeen kaanne biyaat Filiphosnin: «Han baasso muusonek tusha Ayin waagonirinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Bar zaguna baron arifet Filiphosnin fattanok es baron mamsi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filiphoos: «Garo garonon isa isarbesiis muusonek hep tiya wona wosuste wostoni waagni birrik waagte tusha aafawa hoorona wuza» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nawobaasakitonisin isaas Simon Phexirosni ay sina Andriyas Yesusnik ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Uuch muuma tushnewa hep kurxummine epho naa hanta feerwa. Sinuntano effetena daranik Awagira kar'ni?» ");
INSERT INTO jnjl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesus: «Asuni meya duusonek zagutiwa» yi. Estak akama kuwa faar. Es diise baassossin arqasus uuch kum sinnir. ");
INSERT INTO jnjl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesus uuch tushaason ephphe galattefaat diise baassok hooroniison haa'osonek nawoni meyak imi. Kurxummiison dey esiisimato. ");
INSERT INTO jnjl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Meesere gawsetenneen orfo Yesus nawoni meyanon: «Isanne zigunoynamato fu'tana battooson zuututiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Baasso dey maaste uuch hagewni tushaastan fu'te batto zuutire asire heppe masa tuumi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Estan kabi chowa asuni meya Yesus zagina biistera artonoy wuzason biyeteese: «Han bar futok han daasta yoonak fe raajjuuswa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Es bari boor'a Yesus yeesere barin ephere taato zaguk sholsetemato arifaat hepsa wolle bar bar den aamaasta hami. ");
INSERT INTO jnjl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Waalfana kabaasik nawoni meya yeet baariiski kersete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Goonuussi diisere baarisi yesalo Kifirnahom finak kabsete. Es kaba talmera faar. Yesus dey baassoki aane yowe. ");
INSERT INTO jnjl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Akama hugnabare yere siru sirit faar sinna boor'a baariis shorke. ");
INSERT INTO jnjl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Uuch wedey issun kilometrine faaron hametenneen orfo Yesus akaasta taarire kutit goonuuski tai'sefena kabaasik baasso biyaat digsete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sinuntano bar: «Tawa! Digotiita!» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bar goonuussi girire duunak sholsete; geregerenu goonuus hamme kar'one dimaasta kar'i. ");
INSERT INTO jnjl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wonotirik baarisi yesalo yere daraas isa goonu tano estak ooma goonu aafa sinnamatonawa nawoni meya baasso baassotu hamerteno Yesus baassoneen aane giruwe sinbaason arsete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sinuntano ooma goonuusikito Tiberiyadosni katamaassin Yesus suusna tushaason meesete dimaasi tesha yeesete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Asuni meya dey Yesus wedey nawoni meya estak aafsato sinbesiison araat goonuusikitosi diisere Yesusnin sholset Kifirnahom wolsete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Es baarisi teshan danere: «Assinynyano! Hanta aagenso yaatari?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesus wolgire: «Futo nittok makefawungwa, taan sholetiis tusha maara gawseti boor'atano biistera artonoy wuza biiti boor'atawa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tishuni tushaasik wostotiitawa. Sinuntano Asuni Naa nittok imana koi'ba foonto kaak sinni tushaasik wostoti. Aba Ha'oos artoni maatama basaasta ichi.» ");
INSERT INTO jnjl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Baasso dey: «Eekin Ha'oosi wostonon wostonik awu zagunik sholsifaso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesus wolgire: «Es Ha'oosi wostoos bar wosina barik amanotikwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Es bari boor'a baasso dey ekka yisete: «Ese, inno biira amanonik ne aro biistera artonoy wuza zagutasso? Awunu wostotasso? ");
INSERT INTO jnjl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‹Muusonek den saman tusha baassok imiwa› yistera tichchenaasimato abaniisakito ichma daassi Manna meesetewa.» ");
INSERT INTO jnjl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesus ekka yi: «Futo nittok makefawungwa, saman tusha imaas Musetewa. Futoni tusha saman imniis Abataaswa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ha'oosi tusha barnu saman kerera han daastaki fe asunik dey kaa imnirwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Baasso dey: «Daamniiso! Es tushaason wonna wonnatu imatawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesus baassok ekka yi: «Kaa imni tusha tawa. Taaki yooni bar kaa isanne aafa maktona wuza. Taak amanefe bar wonna wonna isanne aafa iktona kaa wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Sinuntano taan biira amano beynitiisik han baron nittok makengwa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Abataas imna baasso zuuttere taaki yoosone. Taaki yoosoni baassotin dey isanne gerakalo aafa kisuna wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ta sholena baron zagunaktawa, taan wosi basa safaranon zagunaktu saman kerengwa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Taan wosi basa safara taak imna baassotin zuutira isanne tishkunoynamato mangsuni kar'ni wono kitun kabgunakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Abataasa safara Naasin biire barik amanefe baasso zuuttesere koi'ba foonto kaa danonekwa. Es baassotinnu ta mangsuni kar'ni wono kitun kabgunawa.» ");
INSERT INTO jnjl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ayhudni meya dey: «Saman kere kaani tusha tawa» ubaasik unyisete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ekka dey yisete: «Haniis ababaasinnawa intobaasona arifeni Yosefni naa Yesustenoso? Eekin aakkak: ‹Samantu kerengwa› yifeso?» ");
INSERT INTO jnjl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesus wolgire ekka yi: «Nittotna nittotna unyutiitawa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taan wosi abataas zataananetano oonu taaki yook aafawa chimanawuza. Ta mangsuni kar'ni wono barin kitun kabgunawa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Raajjuni tichaassi: ‹Zuuttambesiise Ha'okin arir sinonewa› yistera tichche. Esenu Abaaskin odere ari bar zuuttere taaki yoona. ");
INSERT INTO jnjl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ha'ooskin sina shakaanane Abaasinnu biyar oonu aafewa. Abataaskin sina bar bartu biyarwa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Futo nittok makefawungwa; Taak amanefe bar koi'ba foonto kaaba faarwa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kaani tusha tawa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Abantiisakito ichma daassi Manna meesete. Sinuntano kitisete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Saman kere tushaas haniiswa, Es tushaason muuni bar aafa kituna wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Saman kere kaa imni tusha tawa. Asu han tushaason meefaanane koi'ba foonto kaaktu foona. Han daasi asunik kaa sinanak ta imana tushaas ashnaaswa.» ");
INSERT INTO jnjl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ayhudni meya dey: «Han asus ashbaason innok aakkak imak chimnirinso?» yit baassotna baassotna mai'sire karakkarsete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesus baassok ekka yi: «Futo nittok makefawungwa; Asusa Naani ashaason muu shakaatine harinbaason dey usha shakaatine Es maa'a sina ashnaason nitto kaanti aafawa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ashnaason meefe barnawa harinnaason ushfe barna koi'ba foonto kaaba faarwa. Ta koi'baasi wono barin kitun kabgunawa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ashnaas futoni muu, harinnaas dey futoni ushawa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ashnaason meefe barnawa harinnaason dey ushfe barna taneentu foona. Ta dey barneentu foona. ");
INSERT INTO jnjl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hayew abataas taan wosinamato ta dey barkin kabi chowa hayew sinnamato ta ashaason meefe bar dey taakin kabi chowa hayew sinana. ");
INSERT INTO jnjl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Saman kere tushaas haniiswa. Abantiisakito saman kere tushaason meesere kitiseteysimatotawa. Han tushaason meefe bar koi'ba foonto kaaktu foona.» ");
INSERT INTO jnjl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus Kifirnahomuk assifena kabaasik han baron Ayhudni shiiphoni keyaassik make. ");
INSERT INTO jnjl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nawoni meyaassin showobesiis odesefaat: «Han bar chima wollawa. Oonso ephphetook chimniri?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sinuntano Yesus nawoni meya es kaamaasik unyisetemato nibbaassi arifaat ekka yi: «Han bar tuusa'suniroso? ");
INSERT INTO jnjl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Eeka Asuni Naa zeemme den feenaasta hamfeen biifeti kabaasik awu utisso? ");
INSERT INTO jnjl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kaa imfaas Ha'oosi Ayyanawa; asuni hugnaas isanne aane ke'fawa. Ta makena kaamaas kaa imfa Ayyananewa kaanewa. ");
INSERT INTO jnjl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sinuntano nittoossin amanonor isa isar feeseter» Yesus baassossin amanonor oo sinnamatonawa barin aatire imniis oo sinnamatona zeemmenu arire feer sinna boor'a es baron make. ");
INSERT INTO jnjl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tusire dey: «Abaaskin imtonoynaron oonu taaki yook chimnir aafe sinna boor'atu es baron makengwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Esseen orfo nawoni meyaassin showobesiis orfo wolsere barneen ane aane hamoto. ");
INSERT INTO jnjl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesus asire heppe nawobaasakitonin: «Nitto dey wolla hamatik sholefetiyoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Phexiros: «Daamtaaso, ooki wolla hamanirinso? Neeki koi'ba foonto kaa imfa kaama faar. ");
INSERT INTO jnjl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ne Korto Ha'oosi Naa sintamato amaneni dey ariniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesus wolgire: «Nitto asire heppeesin koriis tatenoso? Nittoossin isaas Dabuloswa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Es yina bar dey Simonni naa sina Asqorotki Yuudaningwa. Asire heppe nawoosasin isaas sinfenaknu aatire imniis bar sinna boor'atu make. ");
INSERT INTO jnjl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Esseen orfo Ayhudni meeni ha'sinynyani meya Yesusnin woruk sholset feeseter sinna boor'a Yuudani daasta wolle hamaason beyfaat Galiilani daasta kutit feer. ");
INSERT INTO jnjl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ayhudni meeni hafoni heeboos tai'sera faar. ");
INSERT INTO jnjl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Estan basa ayni meya: «Ne nawoosakito zagifata wostooson biyosonek hantan kabira Yuudaki daasta hamma! ");
INSERT INTO jnjl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ammanon artok sholefe asu wostobaason aachok wostefer aafewa. Ne dey han wuzasikitonon zagifaatane teetneeson han daasi asunik ammanon besutawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Es baron yisetees aybaasakitonu barik amano beyete boor'a. ");
INSERT INTO jnjl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesus baassok ekka yi: «Ta wonaas hashnu aane kar'awa. Sinuntano nitto wonaas wonna wonna ma'a faarwa. ");
INSERT INTO jnjl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Han daas nittotin oomtona ugna aafa. Sinuntano ta wostobesiis mangu sinbaason maket faanar sinna boor'a taan oomtesefe. ");
INSERT INTO jnjl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nitto den heebooski hamti; ta wonaas hashne aane kar'a sinna boor'a den heebooski aafa hamana wuza» ");
INSERT INTO jnjl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Es baron makefaat Galiilak fu'te. ");
INSERT INTO jnjl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sinuntano aybaasakito heeboni dimaasta hametenneen orfo Yesus dey ammanon sinnoynamato aachere hami. ");
INSERT INTO jnjl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayhudni meya: «Barki ayinso?» yiset heeboosik ye asusa ganesi sholsete feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Daraasa ganesinu basa chowaas akamanon unychedifar. Isa isaas: «Bar ma'a asuwa» yi. Oomiis: «Aanewa! Daraasin esharwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sinuntano Ayhudni meeni gaannye meyanon digsete boor'a oonu basa chowaason ammanon aane wollowe. ");
INSERT INTO jnjl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yesus heeboosi ganetak den betemeqdesiissi hamme assu ephi. ");
INSERT INTO jnjl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayhudni meya: «Han asus assinynyani meyakin arunoynaron tichaason aakkak aruk chimiso?» yit diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesus wolgire ekka yi: «Ta assifana barnu taakintawa; taan wosi Ha'ooskingwa. ");
INSERT INTO jnjl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Basa fiqadiison zaguk sholefer feefaanane han assus Ha'okin wedey ta teetakin sinbaason aruk chimana. ");
INSERT INTO jnjl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Basa teetaassin makefe bar teetbari ulfintotu sholefewa. Sinuntano wosi barin ulfinaason sholefe bar futonirwa. Basaassi esha wuza aafa. ");
INSERT INTO jnjl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muse tumaason nittok aane imenoso? Sinuntano nittoossin tumaason zagifer isanne aafewa. Taan woruk awuniron sholedifetirinso?» ");
INSERT INTO jnjl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Daraas wolugsere: «Kiina ayyana neyissi faarwa! Dey neen oonso woruk sholediferi?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus baassok wolgire ekka yi: «Isa biistera artonoy wuza zagina nitto zuuttera diinqeseti. ");
INSERT INTO jnjl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muse haarkoni kunuusi tumanon nittok imiwa. Es tumaas dey yaanaas abani meyakintano Musenikintawa. Nittonu dey beysani wonak naanggota haarko kunsifete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ese Museni tumaas shaartonoynamato beysani wonak naanggota haarko kunir sinnanneen ta asunin beysani wonak fatina boor'a tayista awagan gi'ifetiso? ");
INSERT INTO jnjl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Futoni mangsuni kar'a kar'titano asuni sina biyak mangsu kar'atiitawa.» ");
INSERT INTO jnjl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Es kaba Yerusalemuk feese isa isa asuni meya ekka yisete: «Woruk sholsefees han bartenoso? ");
INSERT INTO jnjl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Esenu bar han ammanon makedifewa, isa wuzane aane maksotowa. Gaannye meyanu han asus Kiristoos sinnamato futok arsetetaaso? ");
INSERT INTO jnjl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sinuntano han bar koontena daas ay sinnamato arinirwa. Kiristoos yeefena kabaasik ayin sinnamato oonu aafa aruna wuza.» ");
INSERT INTO jnjl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesus betemeqdesiissi assifena kabaasik kaambaason teggire ekka yi: «Taan futok arsetirwa; ayin yaanamato dey arsetirwa; ta teetnak aane yootwa. Sinuntano taan wosi bar nitto arunoyti futonirwa. ");
INSERT INTO jnjl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Barkin yaana boor'anawa bar taan wosina boor'ana ta barin arifawungwa» ");
INSERT INTO jnjl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Es bari boor'a ephonek sholset feeseter. Sinuntano bar oottona wonaas aane kar'a sinna boor'a oonu ephak aane kushubaason aane shongowe. ");
INSERT INTO jnjl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sinuntano daraasasin showobesiis barik amanesete. Dey: «eekin Kiristoos yeefena kabaasik han bar zagina biistera artonoy wuzaasi denalo zagungeso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ferisawini meya basa chowaason daraas unyisefen odesete. Maagni gaanynye meenawa Ferisawini meena Yesusnin ephphe yoosonek betemeqdesi tasoni meyanon wossete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesus dey ekka yi: «Nittoneen ane foonaas garo wonnirongwa; estan taan wosi barki hamanar. ");
INSERT INTO jnjl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nitto taan sholoti; aafa danati wuza; ta faanaasta yook aafa chimati wuza.» ");
INSERT INTO jnjl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ayhudni meya: «Inno barin dannoyni dima ay hamnirinso? Awuzakne Girikni meeni ganeyaassi siktere fe Ayhudni meyaki hamme Aazabni meyanon assunittongwa? ");
INSERT INTO jnjl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹Nitto taan sholoti; aafa danati wuza. Ta faanaasta yook aafa chimati wuza› yina kaamaas aambanso?» yit baassotna baassotna wolumsete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Heeboosi koi'ni wonoti arki wonaasta Yesus yerefaat kaambaason: «Oonu ikter feefaanane taaki yeefaat usho. ");
INSERT INTO jnjl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Taan amanefe bar tichaas makenaasimato kaani akani kor'a basa nibaassin kesanawa» yit make. ");
INSERT INTO jnjl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesus es baron makenaas barik amanefe baasso ephphetoosonek fa Ha'oni Ayyanani chowaasikwa. Yesus aane ulfintowe sinna boor'a Korto Ayyanaas aane kerowa. ");
INSERT INTO jnjl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Daraasasin isa isa meya es kaamaason odeseteyse: «Han bar futok raajjusoso!» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Oomiis dey: «Han bar muudtowa» yisete. Sinuntano oomiis: «Kiristoos Galiilan aafawa yoonawuza. ");
INSERT INTO jnjl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Muudtos Dawitni zalaassin koontonamatonawa Dawit feefena katama Betelemun yoonamatona tichaassi aane tichchowanoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Es bari boor'a basa chowaasik daraasa ganesi oor oor kesa sini. ");
INSERT INTO jnjl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Isa isaas barin ephak sholsete. Sinuntano ephak kushubaason basaasta shonger oonu aafe. ");
INSERT INTO jnjl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Estan betemeqdesiisi tasoni meya maagni gaanynye meyakinawa Ferisawini meyakina wolle hameten ekka yire mamussete: «Awuni boor'a Yesusnin ephpha yoo beyetiso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Betemeqdesiisi tasoni meya: «Es asus wollefenaasimato woller oonu aafewa» yire wolugsete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ferisawini meya dey: «Nitto dey eshtetiyoso? ");
INSERT INTO jnjl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ha'sife baassossinawa Ferisawini meyaassinna barik amaner feesetertaaso? ");
INSERT INTO jnjl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Han Museni tumaason arunoy daraas erwuttowa» ");
INSERT INTO jnjl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ferisawini meyaassin zeemo sinak Yesusniki hama Nikodimos yistefe isaas: ");
INSERT INTO jnjl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Inno tumaasimato zeemme isa asu malattena malataas odtonoyfeennawa awu zaginamato artonoyfeenna mangsu aane katefawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Baasso dey wolugsere: «Ne dey Galiilakinnoso? Raajju Galiilan aafa kabuna wuza sinnamato tichaason tu'nira aruwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Estan isa isarbesiis keebesi keebesi hamete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Estan Yesus Dabrazayitini kumaasta hami. ");
INSERT INTO jnjl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wonotiri wono e'so betemeqdesiissi wolle ye. Daraas zuuttere barki yeesete. Bar dey diifaat baassotin assit feer. ");
INSERT INTO jnjl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Museni tumaasi assinynyanawa Ferisawini meena gerkesfeen ootte mashkasu teshshesete dara zuuttambaase asi sina yeetisete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesunik dey ekka yisete: «Assinynyano! Han asus gerkesfeen oottewa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Innok imte tumaassi es ekka zagifa asus shu'ak ichchera kitunak Muse ajajewa. Ne han bari chowaason awu utasso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Es baron ekka yisetees barkin malatoni chowa danne fattansonek sholsefaatwa. Sinuntano Yesus mugire kushubaasi waay'ak daasta tichu ephi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Heppa heppa wolgire mamussobesiise kaanne: «Nittoossin boor'ba foontoos tesuni shu'aason barista ha'ire ichowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hepsa dey mugire daasta tichi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Baasso dey es baron odeseteyse kur'usatan kabire na'oosata kar'e isa isarbesiis estan hamete. Yesus dey dara zuuttambaase asi sina yere Mashkasusneen Yesusneen esta fu'te. ");
INSERT INTO jnjl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesus kaanne: «Han asuse, neen malate baasso ay feesetese? Neyista mangsu kar'ar isanne aafenose?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Asus dey: «Daamtaaso! Isanne aafewa» yi. Yesus dey: «Ta dey neyista aafawe mangsu kar'anawuza; hamme; hawungneen ekalo gerkesataatawe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Hepsa dey Yesus baassok: «Ta han daasta fe asusik chaarefawa. Taaki yeefe bar zuuttambaase kaa imfa chaarefaasontu dananatano talmaassi aafa foona wuza» yire make. ");
INSERT INTO jnjl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ferisawini meya dey: «Ne ne teetaasiktu zaala makefatwa; es maketa zaalaas futotawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesus wolgire baassok ekka yi: «Ta ta teetaasi chowanon zaala makefaanane ayin yaanamatonawa ay hamanamatona arifan sinna boor'a zaalnaas futowa. Sinuntano nitto ayin yaanamatonawa ay hamanamatona aane arifetiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nitto asunimatotu mangsu kar'feti. Ta isa asunita mangsu aafa kar'anawuza. ");
INSERT INTO jnjl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mangsu kar'fanaknu taan wosi Abaas taneen anetu fe sinna boor'anawa mangsu kar'fana kabaasik dey ta ta sina beyna boor'ana es mangsuni kar'naas futowa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Hep asu makena zaala futo sinnamato nitto tumaassi tichchera faar. ");
INSERT INTO jnjl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Es bari boor'a ta teetaasiron tatu zaala makonirwa. Taan wosi abataas dey ta chowaasik zaala makona.» ");
INSERT INTO jnjl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Baasso dey: «Eekin abaneeski ayinso?» yisete. Yesus wolgire: «Taan wedey abataasin futok aane arsefetiwa. Taan arseti sinfaanane abataasin dey aruti kabawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesus han kaamaason makena betemeqdesiisi waaga zuuttefana saaxiniisi tesha diifaat assifetwa. Sinuntano bar oottona wonaas aane kar'a sinna boor'a oonu barin aane ephe. ");
INSERT INTO jnjl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus dey hepsa: «Ta hamanarwa; nitto dey taan sholsoti. Sinuntano boor'nitiisik kitutir; ta hamana dimaassi nitto yootik aafa chimati wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayhudni meya: « ‹Ta hamana dimaasta nitto yoosotik aafa chimati wuza› ubaas bar barin woruniroso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Bar dey ekka yi: «Nitto han daastakir; ta den samakirwa. Nitto han daastakir; ta han daastakirtewa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Es bari boor'atu: ‹Nitto boor'nitiisik kitutirwa› yira makengwa. Ta oo sinnamato arira amano beyfaatine boor'nitiisik kitutirwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Baasso dey: «Eekin ne oonso?» yisete. Yesus wolgire: «Zeemmeneen maket feyiis ta barwa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nittoosta showo makona wuznewa showo mangsu kar'ana wuzne faarwa. Sinuntano taan wosi bar futonirwa. Ta dey barkin odena baron han daastaki asunik makefawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Abaasa chowanon makenamato baasso aane arsoto. ");
INSERT INTO jnjl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Es bari boor'a Yesus ekka yi: «Nitto Asuni Naanin den teggifeti kabaasik ta bar sinnamato arutiwa. Esiisimato dey abataas taak assina barontu makentano ta taakin isa wuzane aane zagifat sinbaason yaadatotiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Taan wosi bar taneen anewa. Ta wonna wonna zagifanaas barin girsuk sinna boor'a ta taan aane beye» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesus es wuzasikitonon makobaase showobesiis barik amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesus barik amanese Ayhudni meyak: «Ta kaamaasik fafaatine futok nitto ta nawowa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Futooson dey arutiwa; futoos dey birmadumma nittotin kisuna» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Baasso wolugsere: «Inno Abrahamni zalawa; isa asuniknu isanne boz aane sineniwa; aakkak ne innotin ‹Bozoossin kesatirwa› yifasso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesus wolgire ekka yi: «Futo nittok makefawungwa; boor'aason wostefe bar zuuttere boor'ni bozwa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Boz wonna wonna keer aane feefe. Naastu wonna wonna keer feeferwa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ese Naas birmadumma kisaanane futok birmadumma kesati. ");
INSERT INTO jnjl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abrahamni zala sinnitiison arifawungwa; sinuntano kaamnaason ephpha too beyeti boor'a taan worutik sholefeti. ");
INSERT INTO jnjl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ta Abataaskin biina barontu makefan; nitto dey abantiiskin odeti barontu zagsefeti.» ");
INSERT INTO jnjl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ayhudni meya dey barik: «Inno aba Abrahamwa» yisete. Yesus wolgire baassok: «Abrahamni naanggota sineti sinfaanane Abraham zagifenaasimato zaguti kabawa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ta Ha'ooskin odena futooson nittok maken. Sinuntano nitto taan woruk sholefeti. Abraham dey ekka aane zaguwe. ");
INSERT INTO jnjl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nitto abantiisa wostonontu wostefetiwa» yi. Baasso dey: «Inno gerkesak aane koontoweniwa. Isa abani feer; es bar dey Ha'ooswa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesus dey ekka yi: «Ha'oos abanti sini sinfaanane taan shunati kabawa. Ta Ha'ooskin yaana boor'a Ha'oostu taan wosirtano ta teetnak aane yootwa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Awuni boor'anso ta wollaason gasasu beyfetiisi? Kaamnaason odok aane sholefetiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nitto abanti sina Dabulosni naanggotwa. Abanti sholefena barontu zaguk sholefeti. Bar zeemmeneen kaa worir. Futo barki aafa sinna boor'a futok aane yerefe. Bar eshinynya, eshni aba sinna boor'a esha wollefena kabaasik teetbaassintu wollefe. ");
INSERT INTO jnjl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Sinuntano ta futo wollefana boor'a nitto aane amanefetiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nittoossin: ‹Boor'a wostetwa› yire taan wee'ok chimnir oonso? Ta futo wollenar sinfaanane awuniron amano beyfetiso? ");
INSERT INTO jnjl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ha'ooskin sina bar Ha'oosi kaamanon oder. Nitto Ha'ooskin sina beyti boor'a aane odefeti» ");
INSERT INTO jnjl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayhudni meya wolgire: « ‹Ne Samirawiwa, kiina ayyana dey neyissi faarwa› uniis futotanoso makeniri?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus wolgire ekka yi: «Tayissi kiina ayyana aafawa. Ta abataasin ulfinsinar; sinuntano nitto taan kashshitir. ");
INSERT INTO jnjl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Sinfanaknu ta teetnaasi ulfinanon aane sholefat. Ta ulfinaason sholefernawa mangsu kar'nirna oom feer. ");
INSERT INTO jnjl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Futo nittok makefawungwa, kaamnaason oodfe bar isanne aafa kituna wuza.» ");
INSERT INTO jnjl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayhudni meya: «Neyissi kiina ayyana faanamato haye ariniwa. Abrahamnu kitiwa; raajjuni meya dey kitisetewa. Sinuntano ne: ‹Kaamnaason oodfe bar isanne aafa kituna wuza› yifat. ");
INSERT INTO jnjl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ne kiti abani Abrahamniistan arkutaroso? Raajjuni meya kitisete. Eekin ne teetneeson oo uu?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesus wolgire: «Ta teetnaason ulfinsifaanane shimatu sinana. Taan ulfinsuniis nitto: ‹Ha'oni› yisefeti abataaswa. ");
INSERT INTO jnjl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nitto barin aane arsefeti; sinuntano ta barin mai'sira arinar. Aane arifat yifaanane nittoosimato eshinynyatu sinana. Sinuntano ta barin mai'sira arinar; kaambaason dey oodnar. ");
INSERT INTO jnjl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nitto abanti sina Abraham ta wonaason biyanak akamanon gire; dey biire gire» ");
INSERT INTO jnjl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayhudni meya dey: «Ne uuchasir woggane kar'noyfeen Abrahamnin biitoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesus dey: «Futo nittok makefawungwa; Abraham koontonoy feen ta fawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Estan barin ichak shu'a kabugsete; sinuntano Yesus aachere betemeqdesiissin kesse hami. ");
INSERT INTO jnjl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesus ugunne hamfet aaftishu sinne koonte asunin bi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nawoni meya: «Assinynyano! Han asus aaftishu sinne koontenaas oo wostena boor'aasikinso? Bar wostena boor'asikingwa wedey barin kooni aba intoos wostesete boor'aasikinso?» yire mamussete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesus ekka yire wolgi: «Han asus aaftishu sinne koontenaas bar wedey barin kooni aba intoos wostesete boor'aasiktawa. Ha'oosi wosto barki kamo ammanon bestonakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wonaas chaarefbaase feen taan wosi basa wostonon wostonik sholsifawa. Oonu wostok chimnoyna talma yoonirwa. ");
INSERT INTO jnjl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Han daasta faana kabaasik ta han daasi chaarefawa.» ");
INSERT INTO jnjl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Es baron makefaat daasta tujere ho'a tushire haar'aasik aaftishuusa aafanon woshshaat: ");
INSERT INTO jnjl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","«Ek hamfaat Silom yistefa kuphira kuni akaassi masowa» yi. Silom uusi kota: «Wostere hamar» uu. Es bari boor'a hamme dey masere biyet wolle ye. ");
INSERT INTO jnjl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sinati kabaasik shiiphefeen biye asuni meenawa wolkobaasakitona: «Han asus zeemo sinak diifaat shiiphefeen biini bartenoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Isa isaas: «Barwa» yisete. Oomiis dey: «Indaanewa; gitobaastu barne feerwa» yisete. Asus: «Es aaftishuus tawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Asuni meya dey: «Eekin aafnees aakkak biyak chimiso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Bar wolgire: «Yesus yistefe asus ho'a tushire haar'aasik aafnaason woshshaat: ‹Silom yistefa kuphira kuni akaassi hamma masowa› yin; hamma masera biingwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","«Es asus ayinso feenari?» yisete. Bar dey: «Ay feenamato aane arutwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Estan asuni meya sinak aaftishu sinne fe asusin ephere Ferisawini meyaki taamete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesus es asusa aafanon ho'a tushire haar'aasik woshshire fatinaas beysani wona. ");
INSERT INTO jnjl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ferisawini meya: «Aakkak biyak chimisso?» yire hepsa asusin mamussete. Bar dey: «Aafnaason ho'a tushire haar'aasik woshshintu masera biyak chimingwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ferisawini meyaassin isa isaas: «Han asus beysani wonaason aane oodfe sinna boor'a Ha'ooskin yeertewa» yisete. Oomiis dey: «Boor'ba feena asu effatena biistera artonoy wuza aakkak zaguk chimnirinso?» yisete. Baasso ganeyaassi dey oor oor kesa sini. ");
INSERT INTO jnjl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Es bari boor'a Ferisawini meya sinak aaftishu sinne fe asusin: «Aafnees biyanak zagi asusa chowanon ne awu yifasso?» yit dey mamussete. Bar wolgire: «Raajjuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ayhudni ha'sinynyani meya es asus aaftishu sinnamatonawa orfo dey biinamatona basa abaasnawa intoose asin teegsere mamussonenneen aane amanosoto. ");
INSERT INTO jnjl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Abaasnawa intoose: «Aaftishu sinnetu koonte yisefeti nitto naas haniiso? Eekin hash aakkak biyak chimi?» yisere mamussete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Abaasnawa intoose wolugsere: «Haniis inno naa; aaftishu sinne koontobaason arifeniwa. ");
INSERT INTO jnjl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sinuntano hash aakkak biinamatonawa aaffaason oo fatinamatona aane arifeni. Bar teetba chim asuwa; barin mamsuti. Basa chowaason bar makona» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","«Kiristooswa» yire make asu feefaanane Ayhudni ha'sinynyani meya Ayhudni zuuttoni keyaassin kalle kissonek zeemme merkesere feeseter sinna boor'a baassotin digsefaattu ekka maksete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Es bari boor'a abaasnawa intoose: «Bar teetba chim asuwa; barin mamsuti» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Estan sinak aaftishu sinne fe asusin hepsak teegesere: «Ne futooson makera Ha'ooson ulfinsuwa. Han asus boor' sinbaason inno arifeniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sinak aaftishu sinne fe asus wolgire: «Boor'ba faarto aafato aane arifatwa. Ta arifanaas sinak aaftishu sinnaasewa hash dey biyak chimnaase koi'bawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Baasso dey: «Aambanso neek zaginari? Aakkakinso aafneeson fatinari?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Bar wolgire: «Zeemma nittok makengwa; odok aane sholoweti. Hepsa awuniron odotik sholetiso? Nitto dey basa nawo sinatik sholsedifetiroso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Barin me'et: «Netu basa nawoteno inno Museni nawowa. ");
INSERT INTO jnjl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ha'oos Museneen wollenamato inno arifeniwa. Sinuntano han asus ayin sinnamato aane arifeni» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Asus wolgire ekka yi: «Han asus ayin sinnamato aru shakuntiis diinqi chowawa; sinuntano aafnaason fatiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ha'ooson digefe barinnawa safarabaason dey zagife barinna Ha'oos oderwa. Sinuntano boor'ba faana barin aane odefa sinnamato artowa. ");
INSERT INTO jnjl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Aaftishu sinne koonte asuni aafa oonu fatidifen daa testenaneen kabira aane odtowa. ");
INSERT INTO jnjl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Han asus Ha'ooskin sina shaki sinfaanane isa wuzane zagunak aafa chimanawuza.» ");
INSERT INTO jnjl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Baasso dey: «Boor'ak koonte ne innotin assutaroso?» yisefaat Ayhudni shiiphoni keyaassin gerakalo kalle kissesete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus fari asusin Ayhudni shiiphoni keyaassin gerakalo kalle kissesetemato ode. Dey danne: «Asuni Naanik amanefatoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Bar wolgire: «Daamtaaso! Barik amanonak bar oonso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesus dey: «Sina zeemma biitwa; hash dey neneen ane wollefees ta barwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Asus dey: «Daamtaaso! Amanonawa» yit barik sagade. ");
INSERT INTO jnjl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesus dey: «Ta han daasta yaanaas mangsuni kar'akwa. Aaftishu sina baasso biyonek; biidifeni yisefe baasso dey aaftishu sinobesiison besukwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Es kabaasik teshba yerse isa isa Ferisawini meya es baron odesere: «Eekan inno dey aaftishunoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesus dey wolgire: «Aaftishu sinefaatine nittok boor'a sinana kabatawa; sinuntano ‹Biidifenir› yisefeti boor'a boor'nitiisneentu fui'totiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Dey Yesus: «Ta futo nittok makefawungwa; fantuusi olani finynyisi kamo girunoy ooma ugnak girife bar wiiswa; dey bo'inynyawa. ");
INSERT INTO jnjl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sinuntano finynyibaasik girife bar fantuusi keemerwa. ");
INSERT INTO jnjl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Barik finynyaason oodfe bar gachana. Fantuusikito dey kaambaason odona. Basa fantuusikitonon sunba sunbaasik teegere kisuna. ");
INSERT INTO jnjl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Basa teetni fantuusikitonon zuutire kisinanneen orfo barikitoni sinaasta zeemana. Fantuusikito dey kaambaason arser sinna boor'a orfobaase hamona. ");
INSERT INTO jnjl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Sinuntano oomiisa kaamanon aane arsefa sinna boor'a basaastan eelatu eelanatano isanne orfobaase aafa hamana wuza» ");
INSERT INTO jnjl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus es besoson baassok make. Sinuntano baasso makena wuzaas awu sinnamato aane arsoto. ");
INSERT INTO jnjl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hepsa dey Yesus ekka yi: «Futo nittok makefawungwa; fantuusi finynya tawa. ");
INSERT INTO jnjl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tayistan zeemme yeese baasso zuuttere wiis; dey bo'inynyawa. Fantuusikito dey baasso kaamaason aane odosowa. ");
INSERT INTO jnjl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","«Finynyaas tawa; taaki kamo girife bar faruna; giruna, kesana, feeshni dima dey danana. ");
INSERT INTO jnjl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Wiisiis wiisere shukke tishkunaktano baak aane yeefe. Sinuntano ta baassok kaa sinanaknawa foobesiisik tuumma fu'te kaa danonektu yaangwa. ");
INSERT INTO jnjl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ta ma'a keemerwa; ma'a keemeriis kaabaason fantuusikwa iyaat aatire imar. ");
INSERT INTO jnjl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Waagak keemfe bar fantuusikito basar sina beyna boor'a iririka yaafana kabaasik fantuuson ha'aat eelfe. Iririkaas dey fantuuson ephin oomaas siktefa. ");
INSERT INTO jnjl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Es keemeriis waagaktu keemfe sinna boor'a fantuusik aane safarefe; dey teetbaasiktu eelfe. ");
INSERT INTO jnjl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ta ma'a keemerwa; ta fantunaason arinarwa. Fantunaasikito dey taan arserwa. ");
INSERT INTO jnjl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ta barikitonon arifanaas Abaas taan arifenasimatonawa ta dey abataasin arifanasimatowa. Kaanaason dey fantunaasikwa iyaat aatira imanar. ");
INSERT INTO jnjl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Han olaassi foonto gerok ooma fantuna faaser. Barikitonon dey ephpha yoonak sholsuwa. Barikito kaamnaason odosona. Isa wodo sinana; keemeriis dey isar sinana. ");
INSERT INTO jnjl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Hepsa wolla ephanak kaanaason dey aatira imanar sinna boor'a abataas taan keeshter. ");
INSERT INTO jnjl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kaanaason ta shunaasik aatira imana; taakin dey oonu ephanak aafa chimanawuza. Kaanaason aatira imaknawa wolgira dey ephanakna ha'suni hugnana faarwa. Es ajajiison dey dannaas abataaskingwa» ");
INSERT INTO jnjl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Es makena barik hepsa Ayhudni meeni ganeyaassi oor oor kesa sini. ");
INSERT INTO jnjl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Baassossin showobesiis: «kiina ayyana basaassi faarwa. Nifasewa; awuniron barin odedifetirinso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Oomiis dey: «Han basa wollaas kiina ayyana basaassi faana asuni wollatawa; kiina ayyana basaassi faana asu aaftishuni aafaason fatunak chimniroso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yerusalemuk betemeqdesiison kayimsuni heeboos ulfintona wonaas kar'i; Es assaas dey yeesho. ");
INSERT INTO jnjl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus betemeqdesiissi Solomonni kesfa giruni dagafiyo yistefa dimaasta kutit feer. ");
INSERT INTO jnjl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Es kabaasik Ayhudni meya Yesusnin ganeya gedere ekka yisete: «Aageneenninso neen laphphebatet fooniri? Ne Ha'oosi muudto sina Kiristoos sinneeson amma zagira innok makowa.» ");
INSERT INTO jnjl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesus baassok wolgire ekka yi: «Nittok makena baron aane amanesefeti; ta abataasa sunak wostefana wostoos ta oo sinnamato taak zaalawa. ");
INSERT INTO jnjl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Sinuntano nitto ta fantu sina beyeti boor'a aane amanefeti. ");
INSERT INTO jnjl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta fantuusikito ta kaamaason odeser; ta dey barikitonon arinar. Taak dey zoonusteser. ");
INSERT INTO jnjl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ta koi'ba foonto kaa barikitok imana; isanne aafa tishusonawuza. Ta kushuussin oonu aafa bo'ona wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Barikitonon taak ima Abataas zuuttambaase asi denalo. Abataasa kushusinnu barikitonon bo'onir oonu aafe. ");
INSERT INTO jnjl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taanawa Abataasna inno isarwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hepsa dey Ayhudni meya barin ichche woruk shu'a ephete. ");
INSERT INTO jnjl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesus dey: «Abataaskin showo ma'a wosto nittok besin; eekin taan ichcha worutiis aaffa wostonasikinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayhudni meya dey wolgire: «Inno neen ichcha woruniis Ha'oosta mei'ni kaama maketa boor'atano ma'a wostonesiktawa. Ne asu sinna faagedo teetneeson Ha'o zagitwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesus dey ekka yi: «Nitto tumaassi ‹Ha'oos nittotin› ‹Koo'lowa› yingwa yifar tichchera faartanoso? ");
INSERT INTO jnjl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ese Ha'oosi korto matsafaason feeshuk aafawa chimtona wuza. Ha'oosi kaama yaana baassotin Ha'oosi kayma kaama ‹Nitto koo'lowa› yira teegenanneen; ");
INSERT INTO jnjl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Eekin Abaas korto zagina barinnawa han daasta wosina barinna ‹Ta Ha'oni naawa› ubaasik awuni boor'a ‹Ha'oosta mei'ni kaama makewa› yifetiso? ");
INSERT INTO jnjl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ta wostefana wostoos Abataasar sina shakaanane taan amanotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sinuntano ta wostefana wostoos Abataasar sinfaanane taak amano beyfetiknu wostonaasik amanotiwa. Es barik Abaas tayissi feenamatonawa ta dey Abaasasi faanamatona mai'sira arsotiwa» ");
INSERT INTO jnjl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Baasso dey hepsa ephonek sholsete; sinuntano bar kushubesiissin aatte kesse hami. ");
INSERT INTO jnjl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Hepsa dey Yesus Yordanosni akaason finne zeemoti Yohannis haphqit feena dimaasta hamme esta di. ");
INSERT INTO jnjl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Showo asuni meya barki yeesere: «Yohannis isa biistera artonoy wuzane aane zaguwe; sinuntano Yohannis han asusa chowanon makena wuzaas zuuttambaase futowa» yisesete. ");
INSERT INTO jnjl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Estak dey showobesiis Yesusnik amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bitaniyak Alazar yiste isa asu mettere feer. Bitaniya Maaraminewa eetba Maartane feesefe ke'e. ");
INSERT INTO jnjl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Es Maarami sinfa bar Daamiisa wochonon shitto woshshira dey sombaasik ku'a bar. Es mettees dey bari ay sina Alazar. ");
INSERT INTO jnjl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Eete eete dey: «Daamiiso! Es ne shunfata bar mettewa» yisere Yesuniki wosisete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesus es baron odenaase: «Han meroos barin woruni merotawa; sinuntano Ha'oosik ulfina sinanaknawa Ha'oosi naa dey han merosik ulfintonaknatu mettewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus Maartanon; eetba Maaraminonnawa aybesi Alazarninna shunar. ");
INSERT INTO jnjl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sinuntano Yesus Alazarni mettonon odefaat feena dimaasta hep wona feeshi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Esseen orfo nawoni meyak: «Hepsa wolla Yuudaki daasta hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nawoni meya: «Assinynyano! Garo wonaneen sinak Ayhudni meya neen shu'ak ichonek sholset feeseterwa. Hepsa dey wolla esta hamatak sholetoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesus wolgire ekka yi: «Wonaassi asire heppe sa'atitanoso faari? Wonak kutife bar han daasi chaarefanon biidifer sinna boor'a aafawa tuusa'ona wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sinuntano talmaassi kutife bar chaarefa barki aafa sinna boor'a tuusa'erwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Es baron makenanneen orfo: «Zomoni sina Alazar afay'tewa. Sinuntano ta hamma afay'nitan barin guzgunarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nawoni meya dey: «Daamiiso! Afay'nin kunir sinfaanane farunawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesus Alazar kiti sinbaasontu baassok make. Sinuntano afay'nin kunnanne faar sinnatu baassok beste. ");
INSERT INTO jnjl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Es bari boor'a Yesus ammanon: «Alazar kitiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nitto amanotik esta fo beynaasik nittokwa iyaat girefawungwa. Sinuntano hash kabini barki hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Es kabaasik «Didimos» yistefe Tomas oom nawoni meyak: «Kabini Yesusneen ane kitunik inno dey hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Alazarni kituus kabbartenanneen acheech wona kar'faan Yesus ye. Asuni meya dey Alazar kitubaason Yesusnik maksete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bitaniya Yerusalemniistan wokbaas keez kiilo meetiri sinana. ");
INSERT INTO jnjl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Showo Ayhudni meya Maartanewa Maaramine asi aybesi kitifaan baassotin chinuk yeesere esta feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maarta Yesus yoobaason odenaase uphonak kesi. Sinuntano Maarami keer diifar. ");
INSERT INTO jnjl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maarta Yesusnik: «Daamiiso! Ne hanta faatar sinfaanane aytaas kituna kabatawa. ");
INSERT INTO jnjl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sinuntano hashnu ne Ha'ooskin shiiphefata baron zuutira neek imanamato arifawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesus dey barik: «Aynees kitun kabunawe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maarta dey: «Koi'baasi wono kitun kabuni kabaasik kabunamato arifawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus dey barik: «Kitun kabunewa kaane tawe. Taak amanefe bar kitifenaknu hayewtu sinana. ");
INSERT INTO jnjl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Taak feefe barnawa taak amanefe barna zuuttere isanne aafa kituna wuza. Es baron amanefatose?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Bar dey: «Aa Daamiiso! Ne han daasta yooni Muudto Ha'oosi naa sintamato ta amanefawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maarta es baron makefaat hamma eetbaason aachok teegera: «Assinynyaas yewe; neen dey sholediferwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maarami odenayse taptak kabira barki hami. ");
INSERT INTO jnjl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Es kabaasik Yesus Maarta uphena dimaastatu feeteno hashnu hang ke'e aane giruwe. ");
INSERT INTO jnjl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Baron chinuk barneen ane keer diise Ayhudni meya Maarami taptera kabi kesbaase Alazarni moogaaski hamma waasunak hamarne faar sinfaan orfobaase hamete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maarami Yesus feenaasta hamma biinayse wochobaassi gandera: «Daamiiso! Ne hanta faatar sinfaanane aytaas kituna kabatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesus bar waasifeennawa barneen ane yeese Ayhudni meya waassefeen biyaat teetbaasiknu akamanon seektere suumere; ");
INSERT INTO jnjl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«Ayinso kunsitiri?» yi. Baasso dey: «Daamiiso! Yaara biwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesus arafa kessire waasi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Es bari boor'a Ayhudni meya: «Awune faaron shunfenamato biitiwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sinuntano baassossin isa isaas: «Aaftishuusa aafanon fati bar han asus kitunoynamato zaguk aafanoso chimanawuza?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus teetbaasik hepsa dey akamanon seektere suumefaat moogaaski hami. Moogaas dey inya shu'ak uktera kuni dugadug. ");
INSERT INTO jnjl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesus: «Shu'aason kabgutiwa» yi. Kiti basa eet Maarta: «Daamiiso! Kitinanneen acheech wona sinna boor'a hash zeyarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesus dey: « ‹Amanefaatane Ha'oosi ulfinanon biyatawe› yira neek aane makotose?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Asuni meya dey shu'aason kabugsete. Esseen orfo Yesus den kaanne: «Abataaso! Ta shiiphooson odeta boor'a galattefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Wonna wonna dey shiiphonaason odefatamato arifawungwa. Sinuntano ekka makenaas ne taan wosuneeson han yerse asuni meya amanosonekwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesus es baron makefaat: «Alazarno! Hang keswa» yire akama tega kaamak teege. ");
INSERT INTO jnjl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kitu Alazar kushubaasewa wochobaase zuuttena eekobaase kesi. Sinbaas dey maamak taatena eekobaasetu fa. Yesus asuni meyak: «Kotaani kutuwowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Maaraminon chinuk yeese Ayhudni meyaassin showobesiis Yesus zagina baron biyefaat barik amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sinuntano baassossin isa isaas Ferisawini meyaki hamere Yesus zagina baron maksete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Es bari boor'a maagni gaanynye meenawa Ferisawini meena shonggosta zuuttesefe baassotin zuutisere: «Han asus showo biistera artonoy wuza zagidifer sinna boor'a awu zagaanine wayyanso? ");
INSERT INTO jnjl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Baak beyfaanine asu zuuttere barik amanonir; Roomni meya dey yeesere inno betemeqdesiisonnawa asuniisinna tishkiseseterwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sinuntano es woggaassik maagni gaanynye meeni gaanynya sina Qeyyaffa yistefe baassossin isaas: «Nitto isanne aane arifetiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Dara zuuttere tishubaastan isa asu daraasa teetak kitifaanane nittok ma'ar sinnamato aane yaadatefetinoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Es baron dey makenaas basa teetaassin kisiretawa. Sinuntano es woggaassik bar maagni gaanynye meeni gaanynya sinna boor'a Yesus daraasa teetak kitunak feenamato besifena kabaasiktu es raajiison make. ");
INSERT INTO jnjl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesus daraasa teetak kitunaas Ayhudni daranik koi'ba sinnoynamato Ha'oosik amanera daadaassi siktera faase naanggotaason dey isarik zuutunakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Es wononeen kabsere Yesusnin woruk merkesete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Es bari boor'a Yesus Ayhudni meeni ganeyaassi ammanon kesse aane kutuwe. Sinuntano essin kesse zaboosi tesha fa daa Efrem yistefa katamaassi hami. Estak dey nawoni meyaneen di. ");
INSERT INTO jnjl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayhudni meeni faasikani heeboos tai'sera faar. Showo asuni meya es heeboos kar'noyfeen zeemme masere kayimme hoorok feesefe daa daassin Yerusalem kesete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yesusnin sholset feeseter sinna boor'a betemeqdesiissi yersefaat baassotna baassotna: «Awu safarefetiso? Han heeboosta yoonir sinna nittok aane bestefanoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Maagni gaanynye meenawa Ferisawini meena Yesusnin ephak bar feena dimaason arife asu feefaanane baassok makonak ajajesere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ayhudni faasikani heeboos zagtonak issun wona fu'tefana kabaasik Yesus kitun kabgina Alazar feefena Bitaniya hami. ");
INSERT INTO jnjl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Estak feese asuni meya meeta'u barik hoossisete. Maarta dey wostotatu fa. Alazar dey Yesusneen ane muu muusonek tai'sere feese baassossin isaaswa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Es kabaasik Maarami akama chima waagak waagte kayma naardosik wosuste isa buttulle shitto ephpha Yesusni wochoosta wuukaat sombaasik dey wochobaason ku'i. Keyaas dey naardosini shittoni sawak tuumi. ");
INSERT INTO jnjl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nawobaasasin isaas Yesusnin aatire imni Askorotki Yuuda ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Han shittoos isa wogga wosuste wostoni birrisi waagtera awuni boor'a tukamnik imto beyiso?» ");
INSERT INTO jnjl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Bar ekka yinaas tukamnik safarere sinnoynaron wiis sinna boor'awa. Waaga ephfees bar sinna boor'a kar'diddiissi ha'tefa barissin ephphe dostere feer. ");
INSERT INTO jnjl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesus dey ekka yi: «Ashnaas kabbartona wonoti bariktu taan hoossi sinna boor'a beytiwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","«Tukamni meya wonna wonna nittoneentu feesetewa. Sinuntano ta nittoneen wonna wonna aafa foona wuza.» ");
INSERT INTO jnjl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Es kabaasik showo Ayhudni meya Yesus Bitaniya foobaason odesefaat yeesete. Es yeesetees Yesus bar barin biya sinnoyanron kitun kabi Alazarninneen biyaktu yeesete. ");
INSERT INTO jnjl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sinuntano Maagni gaanynye meya Alazarnin dey woruk merkesete. ");
INSERT INTO jnjl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Esiis dey Alazarnistan kabi chowa Ayhudni meyaassin showobesiis Yesusnik amaneset feeseter sinna boor'a. ");
INSERT INTO jnjl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wonotirik Ayhudni faasikani heeboosik ye showo dara Yesus Yerusalem yoonir sinbaason odesete. ");
INSERT INTO jnjl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Es bari boor'a Deya kiir'e ephere barin uphok kesere: «Hosana! Daamiisa sunak yeefe Israelni taatoos suustowa» yit chaaget feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus hanyani nawa danne barista di. Esiis dey: ");
INSERT INTO jnjl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Ne Tsiyonni katama Yerusalemne digotaatawe! esenu taatonees hanyani naata diire yoonir.» yistera tichchewa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nawoni meyak es chowaas zeemma baassok aane galowa. Sinuntano Yesus ulfintenanneen orfo es tichaas barik tichchenamatonawa barik zagtenamato yaadatesete. ");
INSERT INTO jnjl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesus Alazarnin moogaassin teegere kitun kabgifena kabaasik barneen ane fe asuni meya Yesusni chowaasik zaala makset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Showo asuni meya uphok yeesetees es biistera artonoy wuzason zaginamato odesere feeseter sinna boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Estan Ferisawini meya baassotna baassotna: «Han daasta fe asu zuuttambaase basa orfoose hamiwa! Inno isa wuzanu zaguk aane chimeni sinnamato biyetiyoso?» yisesete. ");
INSERT INTO jnjl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Heeboosik Ha'oni shiiphok Yerusalem yeese baasso ganeyaassin isa isa Girikni asuni meya feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Baasso dey Galiilaki Betesayidani asu sina Filiphosniki hamere: «Daamniiso! Yesusni biyanik sholefeniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filiphoos hamme Indriyasnik make. Indriyasnawa Filiphosna hamere Yesusnik maksete. ");
INSERT INTO jnjl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesus baassok wolgire ekka yi: «Asuni Naa ulfintona sa'atiis kar'iwa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Futo futo nittok yifawungwa, isa zagoni gaana ho'aassi zigira kitu shakaanane bar bartu fui'tonirwa. Sinuntano kitira kayifaanane showo gaanatu gaanana. ");
INSERT INTO jnjl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kaabaason shunfe bar tishkir. Han daastak kaabaason oomtefe bar koi'ba foonto kaatu barin oodnir. ");
INSERT INTO jnjl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Taak wostok sholefe bar taneen ane yowo. Ta faanaasta wostinynyataas dey foona. Taak wostefe barin dey Abaas ulfinsuna.» ");
INSERT INTO jnjl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tusire dey Yesus: «Hash kaanaason tiir'o ephiwa. Awu unarinso? ‹Abataaso! Han sa'atiisssin taan fu'aywa› unataaso? Sinuntano ekka unoynamato ta yaanay han shanani sa'atisikwa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Abataaso! Ne sunneeson ulfinsuwa» yi. Esseen orfo saman: «Sunnaason ulfinsingwa, hepsa dey ulfinsunawa!» yifa kaama odte. ");
INSERT INTO jnjl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Esta yere asuni meya es baron odefaat: «Dedowa» yisete. Oomiis dey: «Ha'oosi wosiyatu barik wollerwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus dey: «Es kaamaas odtenaas nittokwa iyaattano taaktawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","«Haye han daasi mangsuni kar'ni sa'atiis kar'iwa. Han daasi ha'sinynya sina Sexana gerakalo ha'tonaas hayewa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ta han daastan den tegifana kabaasik asusin zuutira taaki yoonak zaguna» ");
INSERT INTO jnjl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus aro kitu kitunak feenamato besuktu es kaamaason make. ");
INSERT INTO jnjl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Darani meya dey: «Inno tumaassi odeniis: ‹Kiristoos koi'ba foonto neya foonir› yifarwa. Eekin ne: ‹Asuni Naa den tegunak sholsifawa› yifataas aakkanso? Es Asuni Naas oonso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesus dey: «Hash garo wona nittoneen ane chaarefaas faarwa. Talma nittotin ephnoynamato chaarefaas faana kabaasik kututi. Talmaassi kutife bar ay hamdifenamato aane arife. ");
INSERT INTO jnjl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nitto chaarefni naanggota sinotik chaarefaas faana kabaasik es chaarefaasik amanosotiwa» yi. Yesus es baron makenanneen orfo baassostan shaate. ");
INSERT INTO jnjl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesus effatena showo biistera artonoy wuza baasso sina zagifenaknu Ayhudni meya barik aane amanosoto. ");
INSERT INTO jnjl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Es bar dey sinnaas raajju Isayyas: «Daamiiso! Oonso makeni kaamaason amaneri? Ha'oosi hugna dey oonik ammanon besteso?» yire makena kaamaas ko'unakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Hepsa dey raajju Isayyas baasso amano beyaasik ekka yit ammanon make: ");
INSERT INTO jnjl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Aaffesiisik biirenawa; nibbesiissi yaadaterena; wolsonoytematonawa; fatunoynamatona; Ha'oos aaffesiison tishki; nibbesiison dey chini.» ");
INSERT INTO jnjl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayyas han baron yinaas basa ulfinaason biina boor'awa. Es bari boor'a Yesusni chowaasik es baron make. ");
INSERT INTO jnjl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","43","Sinfanaknu Ayhudni meyanon ha'sife baassossin showobesiis Yesusnik amanesete. Sinuntano Ha'ooskin bestefa ulfinaastan asunikin bestefa ulfinaason shunesete boor'a Ferisawini meya Ayhudni shiiphoni keyaassin baassotin kalle kissonoytemato digsefaat amanobesiison ammanon aane maksoto. ");
INSERT INTO jnjl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesus kaambaason teggire ekka yi: «Taak amanefe bar taak koi'ba sinnoynaron taan wosi barik dey amanewa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Taan biya bar taan wosi barin dey biyanawa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Taak amanefe bar zuuttere talmaassi foonoynamato ta chaarefa sinna han daasta yaangwa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kaamnaason odere wostota feeshunoy basaasta mangsu kar'niis tatewa. Ta yaanaas han daason fu'oktano han daasta mangsuni kar'aktawa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Taan ephphetoo beyye kaamnaason dey wostota feeshunoy basaasta mangsu kar'nir feerwa. Ta makena kaamaas koi'ni wono basaasta mangsu kar'anawa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ta taakin aane makotwa. Sinuntano ta una baronnawa makona ajajiisonna imaas taan wosi Abaaswa. ");
INSERT INTO jnjl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Basa ajajiis dey koi'ba foonto kaa sinnamato arifawungwa. Es bari boor'a Abaas taak makena baron nittok makengwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Wonaas dey Ayhudni faasikani heeboos zagtonoyfeen zeemmawa. Yesus han daason beyye den ababaaski hamana wona kar'baason ari. Han daasta fe basar sina baassotin shunet feer. Dey kituk kar'ananneen shuni. ");
INSERT INTO jnjl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesusnawa basa nawoosna meeta'u meesedifer. Sinuntano Sexana Simonni naa Askorotki Yuudani nibaassi Yesusnin aatire imanak zagi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Abaas ha'suni hugna zuuttambaase asin barik imnamatonawa Ha'ooskin yeenamatona; dey Ha'ooski wolle hamnir sinnamato Yesus arire feer. ");
INSERT INTO jnjl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Es bari boor'a meeta'ustan kabire tukaastaki mayna maamaason gaa'e kunsaat koyguni maama ephphe geshobaasta taar'e. ");
INSERT INTO jnjl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Esseen orfo gabatesi aka gedde nawobaasakitoni wochonon masi. Taar'ena maamaasik dey ku'i. ");
INSERT INTO jnjl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Phexirosnin masak yeen bar dey: «Daamiiso! Ne ta wochooson masataroso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus wolgire: «Ta zagifana baron ne hash aafawa aruta wuza. Sinuntano wolitu yaadatotawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Phexiros dey: «Ne ta wochooson isanne aafawa masata wuza!» yi. Yesus dey: «Wochoneeson masa shakaanane taakin haa'one aafawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Phexiros dey: «Daamiiso! Ekka sinfaanane wochonaason koi'ba sinnoynaron kushunaasewa teetnaase asin gedda maswa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus dey: «Atubaason mase bar atuba zuuttera kayma sinna boor'a wochobaason masonaastano ooma aane sholsifawa. Nitto dey kayimwa. Sinuntano zuuttamnitiise kayimtewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus: «Zuuttamnitiise kayimtewa» yinaas barin aatire imni bar oo sinnamato arire feer sinna boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Baasso wochooson masse kesnanneen orfo maybaason mayye wolle ukkoti diinaasta di. Ekka dey yi: «Ta awu zaginamato yaadatetiyoso? ");
INSERT INTO jnjl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nitto taan: ‹Assinynya wedey Daam› yisefeti. Ta assinynyanawa Daamna sinna boor'a es maketiis futowa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ese ta nitto Daamnawa assinynyana sinfaat wochontiison masnanneen nitto dey nittotna nittotna wochontiison masotik sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ta nittok zaginaysimato nitto dey zagsotiktu beso nittok imingwa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Futo nittok makefawungwa, wostinynya daambaasatan denalo aane sinfewa. Wostere hamfe bar dey barin wosi basaastan denalo aane sinfewa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Es baron arira wostota feeshaatine nitto suustowa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Han baron makefanaas zuuttamnitiise asi chowatawa. Ta korina nittotin arifawungwa. Sinuntano korto matsafaassi: ‹Tushnaason taneen me bar guma sinne tayista kabiwa› yiste bar ko'unak sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Han bar sinnoyfeen zeemma nittok makenaas sinfana kabaasik ta Kiristoos sinnamato amanotikwa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Futo futo nittok makefawungwa, ta wosina barin ephpheteefe bar taan dey ephphetoona. Taan ephphete bar dey taan wosi barin ephphetoona.» ");
INSERT INTO jnjl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus es baron makenanneen orfo ayyanabaason tiir'o ephaan: «Futo futo nittok makefawungwa, nittoossin isaas taan aatire imnirwa» yit ammanon kisire make. ");
INSERT INTO jnjl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nawobaasakito ooni chowa makenamato aane arsoto sinna boor'a aafe aafe biyesete. ");
INSERT INTO jnjl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nawobaasakitonisin Yesus shunfena isa nawoos Yesusni tesha kasayere diifer. ");
INSERT INTO jnjl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Phexiros es nawoosin aafa kiir'e: «Ooni chowa makenamato mamsibbo» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Bar dey ek Yesusniki tai'sere: «Daamiiso, oonso neen aatire imniri?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesus dey wolgire: «Han tushaason utoossi dukira tuchuna barwa» yi. Estan tushaason utoossi dukire Askorotki Simonni naa sina Yuudanik tuchi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuuda tushaason ephnanneen orfo geregere Sexana basaassi giri. Yesus dey Yuudanin: «Ese zagutak sholeta baron tai'nin zaguwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sinuntano esta muu muusonek kasayere diise baassossin es Yesus makefena bar awu sinnamato arir aafe. ");
INSERT INTO jnjl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yuuda waaga ephar sinna boor'a nawoni meyaassin isa isaas Yesus: «Heeboosik sholsu wuzason waagowa wedey tukamni meyak ima imma» yinanne faartu sinna baassok beste. ");
INSERT INTO jnjl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuuda dey es tushaason ephnanneen orfo geregere kesse hami. Es kabaasik dey waala. ");
INSERT INTO jnjl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuuda kesse hamnanneen orfo Yesus ekka yi: «Haye Asuni Naa ulfintewa. Ha'oos dey barki kamo ulfintewa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ha'oos barki kamo ulfintena boor'a Ha'oos dey barin ulfinsunawa. Geregere dey ulfinsunawa. ");
INSERT INTO jnjl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Naanggotno! Akama wona nittoneen aane aafa foona wuza. Nitto dey taan sholsoti. Ayhudni ha'sinynyani meyak: ‹Ta hamana dimaassi nitto yootik aafa chimati wuza› yira makenaasimato hash nittok dey makefan. ");
INSERT INTO jnjl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nittotna nittotna shunosotik gaddo ajaji nittok imana. Ta nittotin shunnaasimato nittotna nittotna dey shunosoti. ");
INSERT INTO jnjl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nittotna nittotna shunesefaatine ta nawo sinetimato asuni meya zuuttesere arsonewa.» ");
INSERT INTO jnjl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Phexiros Yesusnin: «Daamiiso! Ayinso hamatari?» yire mamsi. Yesus dey: «Hash ta hamana dimaassi ne yootak aafawa chimata wuza. Sinuntano woli yook chimatawa» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Phexiros dey: «Daamiiso! Hash ne orfoose yook chima beyanaas awuni boor'anso? Ta kaanaasonnu sinun neekwa iyaat aatira imanawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesus ekka yire barik wolgi: «Kaaneeson taakwa iyaat aatira imataro? Futo futo neek makefawungwa, ako oorunoyfeen keeza wolla taan mormotawa.» ");
INSERT INTO jnjl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus ekka yi: «Nibnitiis nawonaata, Ha'oosik amanoti. Taak dey amanoti. ");
INSERT INTO jnjl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Showo fooni dima Abataasa keeruk faar. Ekka sina shakaanane: ‹Footi dima nittok hoossunak hamanarwa› yira nittok makona kabatawa. ");
INSERT INTO jnjl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Hamma footi dima hoossinanneen orfo ta faanaasta nitto dey footik hepsa wolla yaara nittotin ephpha hamana. ");
INSERT INTO jnjl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ta hamana dimaassi zoonsuni ugnaason dey arsetir.» ");
INSERT INTO jnjl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas: «Daamiiso! Ne hamata dimaason aane aruweniwa. Eekin ugnaason aakkak arunisso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus dey Tomasnik: «Abaaski zoonsuni ugunnewa futone dey kaane tawa. Taaki kamo sina shakaanane oonu Abaaski hamnir aafewa. ");
INSERT INTO jnjl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Taan arseti sinfaanane Abataasin dey arutiwa. Sinuntano hawungneen ekalo arsotiwa. Dey biyetiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filiphoos dey: «Daamiiso! Abaasin besuwa; innok hooronawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesus wolgire: «Filiphosno! Effatena wona nittoneen ane faana taan aane aruwenoso? Taan biya bar Abaasin biwa. Eekin aakkak ne: ‹Abaasin innok besuwa› yifasso? ");
INSERT INTO jnjl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ta Abaasasi faanamato, Abaas dey tayissi feenamato aane amanefenoso? Ta nittok makefana kaamaas ta teetaaskintawa. Sinuntano wostobaason wostefees tayissi feefe Abaaswa. ");
INSERT INTO jnjl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ta Abaasasi faanamato, Abaas dey tayissi feenamato taak amanotiwa. Es baron shakaatine wostena wostonaasi boor'a taak amanoti. ");
INSERT INTO jnjl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Futo futo nittok makefawungwa, ta Abaaski hamanar sinna boor'a taak amanefe bar ta wostefana wostooson dey wostona. Es baristan denalonontu wostona. ");
INSERT INTO jnjl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Abaas Naabaaski kamo ulfintonak ta sunaasik shiiphefeti shiiphooson zuuttambaase ta nittok zaguna. ");
INSERT INTO jnjl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Aaffa wuzasonnu ta sunaasik shiiphefaatine ta zaguna. ");
INSERT INTO jnjl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Taan keeshtetir sinfaanane ajajinaason oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ta Abaasin shiiphonawa. Bar dey koi'ba foontonon nittoneen ane fooni ooma nittotin chinuni baron imana. ");
INSERT INTO jnjl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Es bar dey futoni Ayyanaaswa. Han daas biyaknawa arunakna aafa chimanawuza sinna boor'a ephphetook aafa chimanawuza. Sinuntano bar nittoneen ane faar dey nittoossi foonir sinna boor'a nitto aruti. ");
INSERT INTO jnjl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Ababa intoba foonto naanggotaasne faaron zagira nittotin aafa beyana wuza. Ta nittoki wolla yoonar. ");
INSERT INTO jnjl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Garo wonaneen orfo han daas taan aafa biyana wuza. Sinuntano hepsa wolla nitto taan biyati. Ta hayew sinna boor'a nitto dey hayew sinati. ");
INSERT INTO jnjl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ta Abaasasi faanamato, nitto dey tayissi faatimato, ta dey nittoossi faanamato es wono arsoti. ");
INSERT INTO jnjl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Taan keeshtefe bar ajajinaason ephpheteere wostota feeshife barwa. Abataas dey taan keeshtefe barin keeshtona. Ta dey barin keeshtona. Teetnaason dey barik ammanon besuna.» ");
INSERT INTO jnjl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Askorotki Yuuda sinnoy oom Yuuda: «Daamiiso! Han daasi asunik sinnoynaron innok teetneeson ammanon besutaas aakkakinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesus wolgire ekka yi: «Taan keeshtefe bar kaamnaason oodar. Abataas dey barin keeshtona. Inno dey barki yaara barneen ane fooni. ");
INSERT INTO jnjl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Taan keeshtonoy bar kaamnaason aane oodfe. Han odefeti kaamaas taan wosi Abaasartano taartawa. ");
INSERT INTO jnjl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Nittoneen ane faana kabaasik han baron nittok maken. ");
INSERT INTO jnjl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sinuntano Abaas ta sunaasik wosuna nittotin chinuni Korto Ayyanaas zuuttambaase asin assuna. Ta nittok makena baron yaadatotik nittotin zaguna. ");
INSERT INTO jnjl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Nagaason nittok beyanawa. Naganaason nittok imana. Ta nittok imana nagaas han daas imfana barne faartawa. Nibnitiis nawonaata dey digonaata. ");
INSERT INTO jnjl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‹Ta hamanar, wolla dey nittoki yoonar› yira makena baron odeseti. Taan keeshtetir sinfaanane Abaas tayistan arkir sinna boor'a ta Abataaski hamnaasik girsoti kabawa. ");
INSERT INTO jnjl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Es bar sinfana kabaasik amanosotik zeemma nittok makengwa. ");
INSERT INTO jnjl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Han daason ha'sife Sexaniis yoonir sinna boor'a hawungneen ekalo akamanon nittoneen aafa wollona wuza. Bar tayista isa wuza zaguna hugnaba aafa. ");
INSERT INTO jnjl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sinuntano ta Abaasin keeshtefanamato han daas arunak Abaas taan ajajena baron zuutira zagunarwa. Hantan kabini hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Tusire dey: «Ta wayiniisi tuzanimatowa. Es wayiniison oodfees Abataaswa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Gaana gaannoy tayista fa waay'aason zuutire kar'e ha'unir. Gaana gaanfa waay'aason dey fanire mai'sira gaananak oodana. ");
INSERT INTO jnjl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nitto ta makena kaamaasik kayim sinetiwa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Taneen ane footi. Ta dey nittoneen ane foona. Waay'aas wayiniisi tuzta fo shakaanane teetbaasik bar bar gaana gaanak aafa chimanawuza. Esiisimato nitto dey taneen ane fo shakaatine gaana gaanatik aafa chimati wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Ta wayinisikitoni tuzatowa. Nitto dey bari waay'awa. Taneen ane feefe barnawa ta dey barneen ane faana barnatu akama gaana gaannirwa. Ta foontonon isa wuzane zaguk aafa chimati wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Taneen ane foonoy bar waay'asimato gerakalo ha'tere ichimana. Es Waay'aas dey kephtera geesi ha'tera kiichchona. ");
INSERT INTO jnjl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","«Tayissi faasefaatinenawa kaamnaas dey nittoossi faafaananena sholeti wuzason zuutira shiiphefaatine danati. ");
INSERT INTO jnjl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Akama gaana gaanna ta nawo sinefaatine es barik Abataas ulfintona. ");
INSERT INTO jnjl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Abaas taan keeshtenaasimato ta dey nittotin keeshtonawa. Es bari boor'a ta keeshtanaasik foosoti. ");
INSERT INTO jnjl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ta Abataasa ajajinon zaginamatonawa keeshtanbaasik faafanamatona nitto dey ajajinaason zagifaatine ta keeshtanaasik foosoti. ");
INSERT INTO jnjl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Han baron nittok makenaas ta giraas nittoossi foonaknawa nitto giraas dey tuuma sinanakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ta ajajiis haniis: ta nittotin keeshtenaasimato nitto dey wal keeshtosotikwa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Asu kaabaason zomobaasikwa iyaat aatire imaastan denalo keeshtana aafawa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nitto dey ta ajajena baron zagifaatine ta zomowa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wostinynyaas daambaas zagifena baron aane arife sinna boor'a hawungneen ekalo nittotin wostinynyata aafa unawuza. Sinuntano Abataaskin odena baron zuuttambaase nittok maken sinna boor'a zomota yingwa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tatu nittotin korirteno nitto taan aane koruwetiwa. Hamma akama gaana gaanotik, gaannitiis dey foonak ta nittotin taassingwa. Es bari boor'a Abaas ta sunaasik shiipheti wuzason zuutire imana. ");
INSERT INTO jnjl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ese ta nittotin ajajefanaas nittotna nittotna wal keeshtosotikwa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Han daas nittotin oomtefaanane nittoostan zeemma taan oomtenamato aruti. ");
INSERT INTO jnjl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Han daastaki asuni meenimato sineti sinfaatine barir sina baassotin shunana kabawa. Sinuntano nitto han daasir sina beyti boor'anawa ta nittotin han daasi asunisin korina boor'anatu han daas nittotin oomtefa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‹Wostinynyaas Daambaasatan denalo aane sinfewa› yira nittok makena baron gasasuti. Taan shanasi gedak kalle kofuksetenneen nittotin dey shanasi gedak kalle kofukseterwa. Kaamaason odesefaatene nitto kaamaason dey odosonewa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Sinuntano taan wosi barin aane arsefe sinna boor'a han baron zuutire taar sinti boor'a nittoosta zagsone. ");
INSERT INTO jnjl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ta yaara baassok mako shakin sinfaanane baassosta boor'a sinana kabatawa. Sinuntano hash boor'besiisik maksone wuza aafawa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Taan oomtefe bar Abataasin dey oomter. ");
INSERT INTO jnjl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Oom asu wostonoyna wostooson baasso ganeyaassi wosto shakin sinfaanane baassosta boor'a sinana kabatawa. Sinuntano hash han baron zuutire biyetinneen orfo taneen Abataasinneen oomtesete. ");
INSERT INTO jnjl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Esiis dey sinnaas baasso tumaassi: ‹Shimaasiktu taan oomtesete› yistera tichche kaamaas ko'unakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Sinuntano Abaaskin yooni barewa ta dey nittoki wosuna chinuni futoni Korto Ayyanaase yaara ta chowaasik zaala makona. ");
INSERT INTO jnjl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nitto dey zeemmaneen taneen ane faasetir sinna boor'a ta chowaasik zaala maksoti. ");
INSERT INTO jnjl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Han baron nittok makenaas amantontiis tuusa'onoynamatowa. ");
INSERT INTO jnjl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ayhudni shiiphoni keyaassin nittotin kalle kissone. Es baristan denalo dey nittotin wori bar zuuttambaase Ha'oosik wostesetenne faaron sinna faadtona wona yoona. ");
INSERT INTO jnjl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Abaasin wedey taan aane arsoto sinna boor'atu es baron ekka zagsefe. ");
INSERT INTO jnjl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sinuntano han baron nittok makenaas es wonaas kar'fana kabaasik ta awu nittok makenamato yaadatotikwa. Nittoneen ane faana boor'atu han baron zuutira zeemma nittok mako beyingwa. ");
INSERT INTO jnjl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Sinuntano hash taan wosi barki hamanar. Nittoossin dey: ‹Ay hama?› yire taan mamsunir aafe. ");
INSERT INTO jnjl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sinuntano han baron nittok makena boor'a nibnitiis suumok tuumi. ");
INSERT INTO jnjl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sinuntano futooson nittok makefawungwa, ta hamaas nittok ma'arwa. Ta hama shakaanane chinuni korto Ayyanaas nittoki aafa yoonawuza. Sinuntano ta hamfaanane chinuni korto Ayyanaason nittok wosuna. ");
INSERT INTO jnjl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bar yaara han daason boor'ni chowaasik, ookoni chowaasik, mangsuni kar'ni chowaassik wee'ona. ");
INSERT INTO jnjl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Taak amano beyobesiisiktu boor'ni chowaasik wee'ona. ");
INSERT INTO jnjl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ta Abaaski hamanar sinna boor'anawa hawungneen ekalo dey taan aafa biyati wuza sinna boor'anatu ookoni chowaasik wee'ona. ");
INSERT INTO jnjl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Han daason ha'sife basaasta mangsu katena boor'atu mangsuni kar'ni chowaassik wee'ona. ");
INSERT INTO jnjl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Nittok makona wuza akama faar. Sinuntano hash nittoosta fayar. ");
INSERT INTO jnjl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Futo sina Ha'oosi chowanon ammanon kisira besuni Ayyanaas yaafana kabaasik futo zuuttambaase asiissi nittotin zoosuna. Bar odefana barontu nittok makonatano bari teetaassin kisira aafa makona wuza. Dey yooni wuzasikitonon nittok makona. ");
INSERT INTO jnjl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Bar taar sina baristantu epha nittok makona sinna boor'a taan ulfinsuna. ");
INSERT INTO jnjl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Abaasar sina bar zuuttera taar. Es bari boor'atu: ‹Taar sina baristantu epha nittok makona› yinwa. ");
INSERT INTO jnjl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Garo wonaneen orfo taan aafa biyati wuza; dey garo wonaneen orfo hepsa taan biyati.» ");
INSERT INTO jnjl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nawobaasakitonisin isa isaas baassotna baassotna: « ‹Abataaski dey hamanar sinna boor'a garo wonaneen orfo taan aafa biyati wuza; Dey garo wonaneen orfo hepsa taan biyati› yifenaas aambanso?» yisesete. ");
INSERT INTO jnjl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","«Ese han ‹Garo wonaneen orfo› yifena wuzaas aambanso? Makefena wuzason aane galowa» yisesete. ");
INSERT INTO jnjl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus dey barin mamsuk sholsetemato arifaat ekka yi: «Nittotna nittotna ‹Garo wonaneen orfo taan aafa biyatiwuza; Dey garo wonaneen orfo taan biyati› yina boor'anoso wal mamussefetiis? ");
INSERT INTO jnjl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Futo nittok makefawungwa, nitto chaaga waasuti. Sinuntano han daasi asuni meya girsone. Nitto suumoti, sinuntano suumontiis girak sooltona. ");
INSERT INTO jnjl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mashka asu kophoni keektoni wonbaas kar'fana kabaasik suumefa. Sinuntano nawa kooninanneen orfo han daasta nawa koontena boor'a girabaastan kabi chowa aata shanabaason aane yaadatefa. ");
INSERT INTO jnjl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Esiisimato nitto hash suumotir, sinuntano hepsa wolla nittotin biyanar. Nibnitiis dey girona. Es girantiison dey nittoostan ephnir aafe. ");
INSERT INTO jnjl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Es wono taakin isa wuzane aafa shiiphoti wuza. Futo nittok makefan, Abaas ta sunaasik shiiphsefeti wuzason zuutire nittok imana. ");
INSERT INTO jnjl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hashneen kar'a ta sunaasik isa wuzane aane shiiphoweti. Girantiis tuuma sinanak shiiphoti danati. ");
INSERT INTO jnjl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Esseen hawung besoktu nittok maken. Hanneen besok makonoyna wona yoona. Sinuntano Abaasa chowanon nittok ammanon makona. ");
INSERT INTO jnjl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Es wono ta sunaasik shiiphoti. Ta dey: ‹Abaasin nittok shiiphonawa› aafa unawuza. ");
INSERT INTO jnjl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Esiis dey Abaas teetbaasik nittotin shunar. Bar dey shunfenaas taan shunti boor'anawa Ha'ooskin yoonaason amaneseti boor'anawa. ");
INSERT INTO jnjl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Abaaskin kessa han daasta yaan. Hepsa dey han daason beyya Abataaski hamanar.» ");
INSERT INTO jnjl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nawobaasakito dey: «Haye besok sinnoynaron ammanon maketwa. ");
INSERT INTO jnjl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Zuuttambaase aritar sinna boor'a oonu neen mamsunak aane sholsifa sinnamato haye ariniwa. Es bar dey ne Ha'ooskin yaatamato amanonik zagiwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesus ekka yire baassok wolgi: «Futoosik haye amanetiyoso? ");
INSERT INTO jnjl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ese isa isarnitiis siktera keenti keenti hamati wonaasewa ta taan beyoti wonaase yoona. Es sa'atiis dey haye kar'iwa. Sinuntano Abaas taneen ane feena boor'a tatatewa. ");
INSERT INTO jnjl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Han baron nittok makenaas taneen ane faafaani naga nittok foonakwa. Han daasta faafeti kabaasik shana nittok faar. Sinuntano harewa! Ta han daason merengwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus es baron makenanneen orfo sama biire ekka yi: «Abataaso! Haye wonaas kar'iwa. Ta ne Naas neen ulfinsunak Naaneesin ulfinsuwa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Esiis dey asu zuuttambaase asiista ha'suni hugna imta boor'a barik imta baasso zuuttambesiise asik koi'ba foonto kaa imanak barin ulfinsutawa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Koi'ba foonto kaas dey ne ne futoni Ha'o sinnesonnawa wosita Yesus Kiristoosninna aruwa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ne taak imta wostooson wostera koi'sira han daastak neen ulfinsingwa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Abataaso! Han daas testonoyfeen ne faataasta faana kabaasik fa ulfinaaski wolgira taan ulfinsuwa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Han daastan korira taak imta baassok ne oo sintamato besingwa. Baasso dey neerwa. Ne dey baassotin taak imitwa. Baasso dey kaamneeson oodesete. ");
INSERT INTO jnjl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Taak imta bar zuuttera neekin sinnamato baasso haye arsete. ");
INSERT INTO jnjl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ne taak maketa kaamaason baassok maken. Baasso dey ephpheteesete. Ta neekin yaanamato dey futok arsete. Ne taan wositamato dey amanesete. ");
INSERT INTO jnjl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Ne taak imanak imta nawoni meya neer sinete boor'atu shiiphefantano han daasiktawa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Taar sina baasso zuuttere neerwa. Neer sina baasso dey taarwa. Ta dey baassoktu ulfintona. ");
INSERT INTO jnjl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Hawungneen ekalo ta han daastak aafa foona wuza. Sinuntano baasso han daastatu foosone. Ta neeki yoonar. Korto Abataaso! Han taak imanak imta baassotin innomato isar sinonek ne taak imta sunneesik oodwa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Baassoneen ane faana kabaasik baassotin ne sunaasik oodin; imanak taak imta baassotin dey oodin. Tichaasi kaama ko'unak tishuni naasteno baassossin oonu aane tishuwe. ");
INSERT INTO jnjl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Haye neeki yoonar. Ta giraas baassok tuuma sinanak han daastak faana kabaasik han baron makengwa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ta kaamneeson baassok maken. Ta han daastakir sina beynasimato baasso dey han daastakirtewa. Es bari boor'a han daas baassotin oomte. ");
INSERT INTO jnjl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Baassotin mangu sina bariissin oodataktano han daastan gero kisutak aafa shiiphona wuza. ");
INSERT INTO jnjl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ta han daastakir sina beynasimato baasso dey han daastakirtewa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Futoosik baassotin korto zaguwa. Kaamnees futowa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ne taan han daasta fe asuski wositaasimato ta dey baassotin wosin. ");
INSERT INTO jnjl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Baasso futok ne wostoosik teetbesiison aatire imonek ta ta teetaason maa'a zagira baassok imingwa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Baasso kaamaasi boor'a taak amanefe baassokneentu shiiphedifantano nawotaasakitonik koi'batawa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ta shiiphefanaas zuuttambesiise isar sinonekwa. Es barik ne taan wositamato han daas dey amanona. Esiis dey Abataaso! Ne tayissi faatamato ta dey neyissi faanamato baasso dey innoossi foosonekwa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Inno isar sinniisimato baasso dey isar sinonek ne taak imta ulfinaason baassok imin. ");
INSERT INTO jnjl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Futok isar sinonees dey ta baassossi ne tayissi faatamatowa. Es barik ne taan wositamatonawa taan keeshtetaasne faaron baassotin dey keeshtetamatona han daas arunakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Abataaso! Han daas testonoyfeen taan keeshteta boor'a ne taak imta ulfinaason biyonek han ne taak imta baasso dey ta faanaasta taneen ane foosonek sholefan. ");
INSERT INTO jnjl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ooko Abataaso! Han daas neen aane aruwa. Sinuntano ta neen arinar. Han baasso dey ne taan wositamato arsete. ");
INSERT INTO jnjl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne taan keeshteta keeshtanaas baassossi dey sinanaknawa ta dey baassossi foonakna baasso dey neen arsonek zagin. Dey arsonek zaguna.» ");
INSERT INTO jnjl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus es baron shiiphenanneen orfo nawobaasakitoneen ane Kedironni kophaasi yesalo hami. Yesusnawa nawobaasakitona akakiltiisi girsete. ");
INSERT INTO jnjl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesusnawa nawobaasakitona showo wona esta zuutteseter sinna boor'a aatire ima Yuuda es dimaason arir. ");
INSERT INTO jnjl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Es bari boor'a Yuuda showo meya taar'oni meeni zuuttoneen dey maagni gaanynye meyakinnawa Ferisawini meyakinna wostere yeese oodfe baasso ha'sinynyani meyanonna zoonsire esta hami. Baasso dey faanosi, tonanewa neeboni meene ephaat feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesus dey basaasta kar'ni baron zuuttambaase arifaat baassoki hamme: «Oonininso sholetiri?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Baasso dey: «Naaziretki Yesusnintu sholefeniwa» yisete. Bar dey: «Tawa» yi. Aatire ima Yuuda dey baassoneen ane yerefer. ");
INSERT INTO jnjl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesus: «Tawa» ubaase orfobesiisik hamere daasta gandesete. ");
INSERT INTO jnjl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesus hepsak dey: «Oonininso sholetiri?» yire mamsi. Baasso dey: «Naaziretki Yesusninwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Bar dey: «Tawa yinaaskaso; ese sholefetiis taan sinfaanane han taneen ane feese baassotin beyfaani hamotowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Es bar dey sinnaas: «Abataaso! Han taak imta baassossin isarinnu aane tishkutwa» yina kaamaas ko'unakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Phexiros kutesiko ephphe feer sinna boor'a kisire maagni gaanynye meeni gaanynyaasa wostinynyani oi'ta odonon kace. Wostinynyaasa suna dey Malkos. ");
INSERT INTO jnjl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sinuntano Yesus Phexirosnin: «Kutesikoneeson zanbaassi wolgira gedwa. Abaas taak imna shanani ushaason aafa ushana wuzane faar sinna neek bestefawoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Esseen orfo meya taar'osneen baassotin ajajefe baassoneennawa Ayhudni meeni tasoni meeni ha'sinynyani meena Yesusnin ephere taar'ete. ");
INSERT INTO jnjl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Zeemme Haannaniki ephphe hamete. Es neyaasik Haanna maagni gaanynye meeni gaanynya sina Keyyaffanik naashba. ");
INSERT INTO jnjl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Keyyaffa: «Daraasa teetak isa asu kitifaanane ma'arwa» yire Ayhudni meyanon ha'sife baassok zeemo sinak mekama ima asu. ");
INSERT INTO jnjl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Phexiros oom nawoosna Yesusni orfoose hamete. Es oom nawoos dey maagni gaanynye meeni gaanynyaasik arto. Es bari boor'a bar maagni gaanynye meeni gaanynyani ojni keerkalo Yesusneen ane giri. ");
INSERT INTO jnjl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Sinuntano Phexiros gerakalo ojaasi finynyini tesha yerefer. Maagni gaanynye meeni gaanynyaasik arto nawoos kesse keyaason oodfa mashka wostinynyaasik makere Phexirosnin keerkalo gedi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Es keyaason oodfa mashka wostinynyaas Phexirosnin: «Ne dey han asusa nawoosasin isaastenoso?» yi. Bar wolgire: «Indaanewe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gerok koocho sinna boor'a wostinynyani meenawa oodfe baasso ha'sinynya kaa'oni geya sookere yersefaat bessedifer. Phexiros dey baassoneen ane yerefaat besidifer. ");
INSERT INTO jnjl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Es kabaasik maagni gaanynye meeni gaanynyaas Yesusnin nawobaasakitoni chowanonnawa basa assuse asin mamsi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesus dey ekka yit wolgi: «Ta han daa zuuttambaase asik ammanontu maken. Ayhudni meya zuuttambesiise zuuttesefe Ayhudni shiiphoni keyaassik sinun wedey betemeqdesiissi wonna wonna assin. Aachok isa wuzane aane makot. ");
INSERT INTO jnjl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Eekan awuniron taan mamsifatso? Makefana kabaasik ode baassotin mamsuwa. Ta makena baron baasso arseterwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesus es baron makefena kabaasik esta yere oodfe baasso ha'sinynyaasasin isaas: «Maagni gaanynye meeni gaanynyaasik ekka yitnoso wolgutari?» yit Yesusnin bochi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesus dey: «Mangu kaama maken sinfaanane es makena barik zaal sinna makowa. Makena bar futo sinfaanane awuni boor'a taan ichfasso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Estan Haanna Yesusnin taatobaase wolgire maagni gaanynye meeni gaanynya sina Keyyaffaniki gafki. ");
INSERT INTO jnjl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Phexiros yerefaat geya besidifer. Oom asuni meya dey: «Ne han asusa nawoosasin isaastenoso?» yisete. Bar dey: «Indaanewa» yit morme. ");
INSERT INTO jnjl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Phexiros odobaason kacena basa koon sina maagni gaanynye meeni gaanynyaasa wostinynyaasasin isaas: «Atakiltini dimaassi Yesusneen ane feen aane biyutoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Phexiros dey hepsa wolle morme; es kabaasik geregere ako oori. ");
INSERT INTO jnjl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Esseen orfo e'so wonsak Yesusnin Keyyaffani keerun ephere daa ha'sife Philaxosni ojni keerkalo taamete. Ayhudni meya faasikani heeboosi meeta'unon muusonek sholsu sinna boor'a kiinonoytemato uuk daa ha'sife basa ojni keerkalo aane girsoto. ");
INSERT INTO jnjl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Es bari boor'a daa ha'sife bar gero kesse: «Han asusata malateti malataas aambanso?» yit baassotin mamsi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Baasso dey wolgire: «Han asus mangu wuza zagu shaki sinfaanane aatira neek imani kabatawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatos dey: «Nitto ephpha hamfaat tumantiisimato basaasta mangsu kar'tiwa» yi. Ayhudni meya dey: «Inno tumaasik asunin woru kaltowa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Es bar dey sinaas Yesus aro kitu kitunamato makena kaamaas ko'unakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatos hepsa wolle ojni keerkalo giri. Yesusnin barki teegsire: «Ne Ayhudni meeni taatonoso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesus wolgire: «Han ne makefata bar neekiningwa wedey oom asuni meya ta chowaason neek makseterinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatos wolgire: «Ta Ayhudnoso? Neen taak aatire imaas ne keen sinna baassonawa maagni gaanynyaasnawa. Ne awu mangsisso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesus wolgire: «Ta taatoos han daastakirtawa; taatonaas han daastakir sini sinfaanane Ayhudni ha'sinynyani meeni kushusi aattera imtonoynamato ta meya taar'oni meya neebsone kabawa. Sinuntano ta taatoos han daastakirtawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatos wolgire: «Ne eekin taatonoso?» yi. Yesus dey: «Ta taato sinnamato nenu maketwa. Ta koontenaasewa han daasta yaanaase futooson asuni meyak makonakwa. Futooskin sina bar zuuttere kaamnaason odonawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatos wolgire: «Futo aambanso?» yire mamsi. Estan Pilatos hepsa Ayhudni meyaki kesse: «Ta isa mangsune basaastan aane danut. ");
INSERT INTO jnjl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Sinuntano faasikani heeboosik isa taatonin ta nittok kotana bar artowa. Es bari boor'a Ayhudni meeni taatosin nittok kotanak sholefetiyoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Sinuntano baasso zuuttambesiise: «Barbaannintu kotatatano Yesusnintawa!» yiset chaagete. Barbaan dey bo'inynya. ");
INSERT INTO jnjl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Esseen orfo Pilatos Yesusnin ichshi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Meya taar'obaasakito dey seer'ani zawudi ma'ire teetbaasta guufsaat wayintajji maya mayissesete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Barki yeesefaafe: «Ayhudni taatooso! Naga neek sinfawungwa» yiset bochet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatos hepsa gero kesse baassok: «Esenu isa mangsu basaastan aane danut sinnamato arutik barin nittok gero kissunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesus seer'ani zawudi guufere wayintajji maya mayye gerakalo kesi. Pilatos: «Ese asus hanifewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Maagni gaanynye meenawa taar'oni meeni ha'sinynyaasna biyere: «Suutwa! Suutwa!» yiset chaagesete. Sinuntano Pilatos: «Ta isa mangsune basaastan aane danutwa. Nitto ephpha taamfaat suuttiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayhudni meya wolugsere: «Inno tumani faarwa; han asus bar barin wolgire: ‹Ta Ha'oni naa› yina boor'a es tumaniisimato kitunaktu sholsifawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatos es baron odenayse akamanon dige. ");
INSERT INTO jnjl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wolle ojaasi keerkalo girifaat Yesusnin: «Ne ayininso yaatari?» yire mamsi. Sinuntano Yesus isa wuzane aane wolguwe. ");
INSERT INTO jnjl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatos dey: «Taak aane makefenoso? Ta neen kotanak wedey suutanak ha'suni hugnana faanamato aane aruwenoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesus dey: «Ha'ooskin ha'suni hugna neek imto shaki sinfaanane ne tayista isa hugnane aafawa. Taan neek aatire ima asus akama boor'ba faarwa.» ");
INSERT INTO jnjl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatos es baro odenayse Yesusnin kotak shole. Sinuntano Ayhudni meya: «Han barin kotaatane ne Qeesarni keentewa. Teetbaason taato zagi bar zuuttere Keesarni gumawa» yiset chaagete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatos es baron odere Yesusnin gerakalo kisaat: «Yiito shu'a» yistefa dimaasta mangsuni kar'ni kodaasta di. Es dimaas Ibrayistini noonok «Gabata» yisteratu teegtefa. ");
INSERT INTO jnjl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Faasikani heeboosi hooroni wona sinna faar. Wonaas dey issun sa'ati sinana. Es kabaasik Philatos Ayhudni meyak: «Hanifewa taatontiis» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sinuntano baasso: «Tishkuwa! Tishkuwa! Suutwa!» yit chaagesete. Pilatos wolgire: «Taatontiisin suutanaroso?» yi. Maagni gaanynye meya: «Keesarteno oom taatoni aafewa» yit wolugsete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Es kabaasik Pilatos Yesusnin suuttonak aatire imi. Baasso dey Yesusnin ephphe hamete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesus mesqeliison wor'e: «Teetni mega» yistefa dimaasta kesi. Es dimaas Ibrawini meeni noonok: «Golgotatu» yistefa. ");
INSERT INTO jnjl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Esta taamme suutete. Barneen ane oom hep asunin; isaasin aldaasta; isaasin hoi'taasta; Yesusnin ganeyaassi zagire suutete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatos dey: «Naaziretki Yesus Ayhudni taato» yifa ticha tichisere mesqeliisi teetta yeeti. ");
INSERT INTO jnjl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesus suuttena dimaas Yerusalemni katamaasik ta'a sinna boor'a showo Ayhudni meya es tichaason feretisete. Tichaas dey tichchenaas Ibrayistini meeni noonok; Roomni meeni noonoknawa Girikni meeni noonoknatu tichche. ");
INSERT INTO jnjl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ayhudni maagni gaanynye meya Philaxosnin: «Ne ‹Ayhudni meeni taatowa› yira tichutaatawa. Sinuntano han asus: ‹Ta Ayhudni meeni taatowa› yi yiratu tichutawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatos: «Tichina baron tichingwa» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Meya taar'osakito Yesusnin suutetenneen orfo maybaason isarba isarbaasik isa kushu kar'anak acheech dimta bagesete. Gaag mayooson dey ephete. Es gaag mayoos denun kabira yeet kar'a shimanonik wichertano zootterta. ");
INSERT INTO jnjl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Es bari boor'a meya taar'osakito baassotna baassotna: «Oonik kar'nitto arunik ixxa ha'uniistano aafa karasuni wuza» yisesete. Esiis dey sinnaas: «Maynaason baassotna baassotna; Haa'esete; maynaasta ixxa ha'sesete.» Yifa tichaasi kaama ko'unak sinna boor'a meya taar'osakito dey ekka zagsete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesus suuttena mesqeliisi teshta intobaasewa intobaasi eetne; Kilopani asu Maaraminewa Magdelawitki Maaramine esta yersefar. ");
INSERT INTO jnjl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesusni intoos bar shunfena nawoosa tesha yerefeen bi. Dey Intobaasik: «Intonaase! Naanees hanifewe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Esseen orfo nawoosin: «Intone hanifawa» yi. Esseen orfo nawoos Maaraminon ephphe keeba hami. ");
INSERT INTO jnjl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Estan Yesus zuuttambaase ko'inamato arifaat tichchera kuni bar ko'unak: «Iktengwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Estak suqaro waynini usha tuumma diina koda faar. Waynini ushaason aka ephak chima wuzaassi haphqire i'ota duusire noonobaassi tuchisete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesus waynini ushaason suutire ushnayse: «Ko'iwa» yi. Estan teetbaason daa mugire kiti. ");
INSERT INTO jnjl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Beysani wonaasi hooroni wona sinna boor'anawa es beysani wonaas dey akama heebo sinna boor'ana suuttere yere asusa dugno beysani wonaasik mesqeliista aane feeshfa. Es bari boor'a Ayhudni meeni ha'sinynyani meya suuttere yere baasso orgooson kiir'e kessusonek ajajonak Philaxosni shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Estan meya taar'osakito yeesere Yesusneen ane suuttere yere tesuni basa orgonon kiir'esete. Tusire dey hepsaasa orgonon kiir'esete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sinuntano Yesusniki yeesefe kabaasik bar kitinamato biyaat orgobaason aane kiir'oto. ");
INSERT INTO jnjl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Meya taar'osasin isaas teshbaason ebok kejin geregere harinnewa akane kesi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Es baron biya bar nitto amanotik zaala make. Makena zaalaas dey futo. Makefena bar futo sinnamato bar arife. ");
INSERT INTO jnjl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Es bar dey sinnaas: «Basa megaassin isarnu aafa kiitona wuza» yifa tichaasi kaama ko'unakwa. ");
INSERT INTO jnjl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dey ooma tichaasnu: «Kejete barin biyonewa» yifa. ");
INSERT INTO jnjl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ayhudni ha'sinynyani meyanon digefaat aachok Yesusni nawo sina Armatiyaski Yosef Yesusni dugnooson ephanak Philaxosnin shiiphe. Pilatos dey ephanak make. Estan Yosef hamme dugnooson ephi. ");
INSERT INTO jnjl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Zeemo sinak talmak Yesuniki ye Nikodimos fayba keezasir kiilo sinni Kumbinewa Reettine woi'to sawa wuza ephphe ye. ");
INSERT INTO jnjl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yosefnawa Nikodimosna Yesusni dugnooson ephphe taamme Ayhudni meeni zuutuni tumaasimato shitto woshshire wor'a maamak kimete. ");
INSERT INTO jnjl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Bar suuttena dimaas toktera di akakiltiisi teshta. Es toktera di akakiltiisi ganesi asuni dugno girunoyna gaddo shu'ni mooga faar. ");
INSERT INTO jnjl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Beysani wonaasi hooroni wona sinna boor'anawa moogaas dey ta'a sinna boor'ana Yesusni dugnooson esta kabbarsete. ");
INSERT INTO jnjl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Guddani wono she'u feteetunoyfeen Megdelawitki Maarami moogaaski hami. Moogaasta uktera kuni inya shu'aas bukalera kunfeen bi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bar eelet Simon phexirosnikinawa Yesus shunfena oom nawooskina hamma: «Daamiisa dugnonon shu'ni moogaassin ephetewa. Ay kunussetemato aane aruweniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Estan Phexiros oom nawoosna kesere moogaaski hamete. ");
INSERT INTO jnjl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hepobesiise eelet hameter. Sinuntano oom nawoos Phexirosnistan taptere eelle zeemme moogaasi esta kar'i. ");
INSERT INTO jnjl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mogire biin Yesus kimtena maamaas kunfeen bi. Sinuntano sir aane giruwe. ");
INSERT INTO jnjl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Phexiros dey orfobaase yeere moogaassi girin kimtena maamaas kunfeen bi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Dey teetbaasta marte maamaas kimte maamaasneen sinnoynaron teetbak birtera ooma dimta kunfeen bi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Estan dey zeemme moogaaski ye oom nawoos girire biire dey amane. ");
INSERT INTO jnjl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","«Bar kitun kabunak sholsifa» yifa tichaasi kaamanon hashnu aane yaadatosoto. ");
INSERT INTO jnjl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Esseen orfo nawoni meya wolle feesefe dimaasta hamete. ");
INSERT INTO jnjl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Megdelawitki Maarami moogaasi gerakalo yerefaat waasidifar. Waasifat moogaassi mogira bi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Hep Ha'oni wosiya foro maya mayera Yesusni dugno kunnaasta isaas boktaasta isaas chogoosta diisefeen bi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Baasso dey: «Han asuse! Awuni boor'a waasidifatarinse?» yisete. Bar wolgira: «Daamtaasa dugnonon ephphe hamete. Ay kunussetemato aane arut» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Es baron iyaat orfoba wolla biin Yesus yerefeen bi. Sinuntano bar sinbaason aane aruwa. ");
INSERT INTO jnjl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesus: «Han asuse! Awuni boor'a waasidifatarinse? Oonininse sholedifatari?» yi. Bar akakiltini tasowa iyaat: «Daamiiso! Ne ephaatane ay kunsitamato makowa. Ta ephpha hamanawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesus baron: «Maaram» yi. Bar dey orfo wolla Ibrayistini noonok: «Rabuni» yi. Kotbaas dey: «Assinynyano» uu. ");
INSERT INTO jnjl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesus: «Hashne den Abaaski aane hamut sinna boor'a taan ta'utaatawe. Sinuntano aytaasakitoniki hamfaat: ‹Ta abataaskinawa abantiisikna, Ha'onaaskinawa Ha'ontiiskina hamanar yi› yira makowe» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Estan Magdelawitki Maarami hamma nawoni meyak: «Daamiisin biingwa» yi. Dey bar barik awu makenamato baassok make. ");
INSERT INTO jnjl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Es guddani wono waalin nawoni meya Ayhudni meeni ha'sinynyani meyanon digesete boor'a gamalaasikitonon kulfaat zuuttesere feeseter. Yesus yeere baasso ganeyaassi yerefaat: «Naga nittok sinfawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Es baron makefaat kushubaasewa teshbaase asin baassok besi. Nawoni meya dey daamiisin biyeteyse akamanon girsete. ");
INSERT INTO jnjl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesus hepsa dey: «Naga nittok sinfawungwa. Abaas taan wosinaysimato ta dey nittotin wosunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Es baron makefaat baassosta fugin: «Korto Ayyanaason ephpheteesete. ");
INSERT INTO jnjl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nitto asuni meeni boor'aason feeshun iyaatine boor'besiis feeshun ustona. Nitto asuni meeni boor'aason feeshun uu shakaatine aafa feeshun ustona wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Es kabaasik asire heppesasin isaas; Didimoos yistefe Tomas Yesus yeena kabaasik baassoneen ane aafe. ");
INSERT INTO jnjl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Oom nawoni meya Tomasnik: «Daamiisin biiniwa» yisete. Sinuntano bar: «Musmarik ichche kushubaastaki sakaasson kushunaasi waay'ak sir zugera biinoynawa dey kushunaasi waay'ak teshbaastaki mazanon taptira biinoyna isanne aafa amanona wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Hepsa dey nangrinsinari wono nawoni meya isarik feeseter. Tomas dey baassoneen ane feer. Gamalaasikito kuluftobaase feen Yesus yeere baasso ganeyaassi yerefaat: «Naga nittok sinfawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Esseen orfo Tomasnin: «Kushuneesi waay'anon teshshera kushunaasi sakaasta ta'ira biwa. Kushuneeson teshshera teshnaastaki mazaason ta'uwa; amaner sintano amanonor sinatatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas dey: «Daamtaaso! Ha'onaase!» yire wolgi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesus dey Tomasnin: «Ne biita boor'atu amanetwa. Biinoy amanefe baasso suustowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesus han tichaassi tichchonoy showo biistera artonoy wuza nawoni meyaneen ane feena kabaasik zagi. ");
INSERT INTO jnjl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sinuntano Yesus bar Kiristoos Ha'oosi Naa sinbaason amanotiknawa amanera dey basa sunaasik koi'ba foonto kaa danatiknatu han bar tichchewa. ");
INSERT INTO jnjl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Esseen orfo Yesus Galiilaki baarisi tesha hepsa nawoni meyak ammanon beste. Es baassok ammanon bestenaas haniisimatowa. ");
INSERT INTO jnjl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Phexirons, «Mano» yistefe Tomas, Galiilak fa Qaanani katamaassiki Naatinael, Zabdiyosni naanggotiisnawa nawobaasasin oom hep nawoosna isarik feeseter. ");
INSERT INTO jnjl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Phexiros baassok: «Kurxummni eshak hamnarwa» yi. Baasso dey: «Neneen ane hamaniwa» yisete. Kesere dey goonuussi girsete. Sinuntano es waalaasik isarinnu aane ephosoto. ");
INSERT INTO jnjl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wonfana kabaasik Yesus es baarisi ha'a yere. Sinuntano nawoni meya Yesus sinbaason aane arsoto. ");
INSERT INTO jnjl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesus: «Naanggotno! Isa eshsha ephti qurxummi faaroso?» yire mamsi. Baasso dey: «Aafawa» yire wolugsete. ");
INSERT INTO jnjl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Bar dey: «Yugudooson goonuusi oi'ta teshta ha'utiwa; Estan danati» yi. Baasso dey ha'sete. Showo qurxummi ootte sinna boor'a zatte kisuk aane chimoto. ");
INSERT INTO jnjl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesus shunfena nawoos Phexirosnin: «Daamiiswabiti!» yi. Es bari boor'a Simon Phexiros daamniis sinbaason odenayse atatubaase sinna boor'a maambaason mayye baariissi giri. ");
INSERT INTO jnjl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sinuntano oom nawoni meya daastan woketees isa tiya metiritano akamanon aane wokoto. Qurxummi tuumma fa yugudooson zatet goonuussi diisere yeesete. ");
INSERT INTO jnjl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Goonuussin kersefe kabaasik kurxummi barista kunna kaa'oni geenewa tushne biyete. ");
INSERT INTO jnjl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesus: «Hashti eshsha ephti kurxummiissin teshshotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Phexiros goonuussi girire isa tiirewa uuchasire keeze inya inya qurxummik tuumma fa yugudooson zatte daasta kisi. Effatena showo sinfanaknu yugudoos aane karatowa. ");
INSERT INTO jnjl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesus baassotin: «Yaara ufeshshu muutiwa» yi. Daamiis bar sinbaason arsete boor'a nawoosasin isarnu: «Ne oonso?» yire mamsuk chimar aafe. ");
INSERT INTO jnjl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesus yeere tushaason ephphe baassok imaat kesse kurxummiison dey imi. ");
INSERT INTO jnjl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesus kitun kabinanneen orfo nawoni meyak keessa wolle uphoba. ");
INSERT INTO jnjl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ufeshshu meesetenneen orfo Yesus Simon Phexirosnin: «Yohanisni naa Simonno! Han baassostan denalo taan keeshtefatoso?» yire mamsi. Bar wolgire: «Aa, Daamtaaso! Shunfanamato ne aritarwa» yi. Yesus dey: «Garo garo fantunaason keemma» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Hepsa dey Yesus: «Yohannisni naa Simonno, taan keeshtefatoso?» yi. «Aa, Daamtaaso! Shunfanamato ne aritarwa» yi. Yesus wolgire: «Fantunaasikitonon keemma» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Keessak dey: «Yohannisni naa Simonno taan shunfa toso?» yi. Keessak dey: «Taan shunfa toso?» yina boor'a Phexiros suumere: «Daamtaaso! Ne zuuttambaase asin aritarwa. Shunfanamato dey ne aritarwa» yi. Yesus: «Fantunaasikitonon keemma. ");
INSERT INTO jnjl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Futo neek makefangwa: Ne na'o asu sinfa ta kabaasik ne teetneesik geshoneeson talfak taar'era shunta dima hamet faatar. Sinuntano kur'ifata kabaasik kushuneeson kabgira besaan oom asu taatuna. Ne shunnoyta dima dey taamana» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus ekka yinaas Phexiros aro kitu kitire Ha'ooson ulfinsunamatotu besifa. Es baron iyaat: «Taneen ane hamniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phexiros yerqere Yesus shunfena nawobaas basa orfoose hamfeen bi. Es bar dey meeta'u maastefana kabaasik Yesusniki tai'sere: «Daamtaaso! Neen aatire imniis oonso?» yire mamsi barwa. ");
INSERT INTO jnjl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Phexiros Yesus shunfena nawobaasin biyaat Yesusnin: «Han asus awu sinni?» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesus: «Ta wolla yoona kabaneen bar kaak foonak sholefaanane neen awu tiir'e. Ne taneen ane hamniwa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Es bari boor'a nawoni meeni ganeyaassi: «Es nawoos aafa kituna wuza» yifa wolla zi'i. Sinuntano Yesus: «Ta wolla yoona kabaneen bar kaak foonak sholefaanane neen awu tiir'eso?» utu yiteno: «Aafa kituna wuza» aane uwe. ");
INSERT INTO jnjl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Es nawoos han chowaasikitonon zuutire zaala makere tichiwa. Bar makena zaalaas futo sinnamato arifeni. ");
INSERT INTO jnjl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus zagina ooma showo wuza faar. Taak bestefanaysimato bar zagina wuzaas zuuttera isarba isarbaasik tichche sinfaanane es tichaason han daas teetbaasik wor'ak chimana kabatawa.");
INSERT INTO jnjl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tewofilosno! Zeemoti tichina tichaasta Yesus wostena wuzaasewa assina assuse asinna tichingwa. Es Tichinaas dey Yesus wostobaason jammarena wonaastan kabgira, ");
INSERT INTO jnjl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Den sama hamana wononeen kar'a wostena wostosongwa. Den sama hamnaas bar korina wosibaasik Korto Ayyanaaski kamo ajajibaason imnanneen orfowa. ");
INSERT INTO jnjl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Akama shanaason ephpheteere kitinanneen orfo hayew sinne foobaason showo ugnak ammanon biiste zaalaak kesse baassok beste. Acheechasir wona kesse bestefaafe Ha'oosi taatoni chowanon baassok assi. ");
INSERT INTO jnjl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Baassoneen ane feena kabaasik ekka yire ajaje: «Ta makena Abaaskin imte abdiison oodtitano Yerusalemun kesatiita. ");
INSERT INTO jnjl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohannis akaktu haphqi; sinuntano nitto garo wonaneen orfo Korto Ayyanaktu haphuqtoti» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Baasso Yesusneen ane isarik zuuttere feeseten: «Daamiiso! Israelni taatooson wolgira imata wonaas hashnoso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesus dey wolgire: «Abaas basa ha'suni hugnaasik hoossina wonaasewa neyaase asin nitto arutik aafawa chimati wuza. ");
INSERT INTO jnjl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sinuntano Korto Ayyanaas nittoosta kerefana kabaasik hugna danatiwa. Es kabaasik Yerusalemuk, Yuudak, Samariyaknawa hamma daani dila kar'ananneenna taak zaal sinatiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Es baron makenanneen orfo baasso biyefeen den sama hami. Shaaruus dey barin ephpha aaffesiissin aachi. ");
INSERT INTO jnjl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bar den sama hamfeen baasso dey den sama kootkire biyefeen diinqone foro maama mayo hep asu baasso tesha yerefaat: ");
INSERT INTO jnjl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«Nitto Galiilaki asu! Awagan den sama kootkira biyet yeretirinso? Han den sama hamfeen biyeti Yesus den sama hamfeen biyetiisimato wolle dey yoonirwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Esseen orfo Dabrazayitini kumaastan Yerusalem wolsete. Es Dabrazayitini kumaas Yerusalemniistan wokbaas isa beysani wonni kutuni ugna sinana. ");
INSERT INTO jnjl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yerusalem yeesere den diisefe segenetiista kesete. Es kese baasso dey Phexiros, Yohannis, Yaqob, Indiriyas, Filiphoos, Tomas, Bertelomewos, Matiyos, Ilfiyosni naa Yaqob, Kooner yistefe Simonnawa Yaqobni naa Yuudana. ");
INSERT INTO jnjl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Es baasso zuuttambesiise isarik Ha'oni shiiphok wonna wonna zuutteset feeseter. Baassoneen ane dey isa isa mashka meya Yesusni into Maarami esiisimato dey Yesusni ayni meya feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Es wono Phexiros tiirewa hepasire sinni amanynyini meeni ganesi yerefaat ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ayni meyane! Yesusnin ephpha baassok zoonsi sina Yuudani chowaasik Korto Ayyanaas zeemma Dawitniki kamo makena tichaasi kaama ko'unak sholsuwa. ");
INSERT INTO jnjl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuuda innoossin isar sinne faattere han inno wostefeni wostooson wostet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Sinuntano han asus es wostena mangu wostobaasi waagak daa waage. Estan sinbaasik gandere kixxek karate. Kenashbaas dey fe'te. ");
INSERT INTO jnjl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Es chowaas dey Yerusalemuk feese baasso zuuttambesiise asik odte. Es bari boor'a es daas baasso noonoosik: ‹Akkeldaama› yistera teegte. Kotbaas dey: ‹Harinni daa› uu. ");
INSERT INTO jnjl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Es bar sinnaas gaamni matsafaassi: « ‹Foona keebaas ona sinfawungwa; oonu barissi foonaatawa› dey: ‹Barik imte wostooson; oom asu basaastan ephphe wostowowa.› yistera tichchena boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Es bari boor'a Daam Yesus inno ganeyaassi kutit feena kabaasik innoneen ane feese baassossin; ");
INSERT INTO jnjl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Esiisimato dey Yohannisni haphqustan kabira Daam Yesus den sama hamna wonaastaneen kar'e ane feese asuni meyaassin isa asu innoneen ane kitun kabubaasi chowaasik zaal sinanak sholsuwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Esseen orfo hep asunin ephphe yeesete. Es baasso dey Barsabaas wedey Iyyosixos yistefe Yosefnawa Matiyasna. ");
INSERT INTO jnjl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ekka yisere shiiphsete: «Asu zuuttambaase asi nibanon arife Daamiiso! Han heppiisasin oonin koritamato ne innok besuwa. ");
INSERT INTO jnjl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Shiiphefeniis Yuuda beyye basa teetni dimaassi hamna wostoosewa wosi sinaason ephphetooni barinna innok besutakwa» ");
INSERT INTO jnjl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Estan ixaason hai'seten Matiyasnik kesi. Es bari boor'a bar asire isse wosini meyaneen ane faatte. ");
INSERT INTO jnjl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Penxekooste yiste heeboos kar'fana kabaasik nawoni meya zuuttambesiise isarik isa dimta zuuttere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Diinqo akama ipuwani kaamane fa kaama den saman ya. Baasso feesete keyaassi dey tuumi. ");
INSERT INTO jnjl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Termane fa geeni wino baassok beste. Bagte bagtera isa isarbesiisata di. ");
INSERT INTO jnjl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Zuuttambesiise Korto Ayyanak tuuntesete. Korto Ayyanaas baassok imna aruusimato ooma noonok wolumsete. ");
INSERT INTO jnjl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Es kabaasik daa daassin yeese Ha'ooson digsefe Ayhudni meya Yerusalemuk feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Es kaamaason odesefe kabaasik showo asuni meya zuuttesete. Isarbesi isarbesiis baasso teetni noonoosik wolumsefeen odesete boor'a diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Diinqoknawa dajokna ekka yisete: «Han ekka wolumsefe baasso zuuttambesiise Galiilaki asutenoso? ");
INSERT INTO jnjl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Eekin inno daani noonoosik wolumsefeen odefeniis aakkanso? ");
INSERT INTO jnjl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Inno Partenaki, Meedki, Elamki, Mesopetomiyaki, Yuudaki, Kepedokiyaki, Pantoski, Iisiyaki, ");
INSERT INTO jnjl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firgiyaki, Punfiliyaki, Giphtsiki, Kerenani tesha fa Libiyani awurajjaasitu faafeni. Inno Roomun ye Ayhudni meenawa Ayhud sina inno dey faanir. ");
INSERT INTO jnjl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Esiisimato Qerxesni asuni meenawa Arabni asuni meena zuuttere Ha'oosi akama wostonon inno teetni noonoosik wolumsefeen odedifeniwa» ");
INSERT INTO jnjl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Es bari boor'a zuuttambesiise diinqesere: «Han wuzaas aambanso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sinuntano isa isaas: «Wayinini usha ushere zaysetewa» yit kanyesete. ");
INSERT INTO jnjl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Es kabaasik Phexiros asire isse wosini meyaneen yerefaat kaambaason teggire daraasik ekka yit make: «Nitto Yuudani daastaki asunawa Yerusalemuk feese nittona zuuttamnitiise han sina chowaason aruk sholefaatine ta makefana baron mai'sira odotiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hash wonnanneen keez sa'ati sinna boor'a nitto safarefetisimato han baasso aane zaysotowa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sinuntano han bar sinnaas raajju Iyyuel ekka yit makena bar ko'unakwa: ");
INSERT INTO jnjl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","« ‹Ha'oos koi'ni wonaasikitosi; Ayyananaason asu zuuttambaase asiista kessunawa; arqaasnawa mashka naanggotnitiise raaji maksone; na'oni meya dey raa'i biyone; kur'uni meya dey miito miitosone. ");
INSERT INTO jnjl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Esiisimato dey es wonaasikitosi; arqa wostinynyataasatanawa; mashka wostinynyanaastana; Ayyananaason kessunawa; baasso dey Raaji maksone. ");
INSERT INTO jnjl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Den samak diinqi wuzasikitonon; han daastak dey biistera artonoy wuza besunawa; hanna, geya, geeni ki'na dey bestona. ");
INSERT INTO jnjl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Akama dey diinqi sina Daamiisa wona yoonoyfeen; zeemma Awaas talmona; assaas dey hannane faar sinana. ");
INSERT INTO jnjl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Daamiisa sunanon teegefe bar zuuttere fui'tona› yiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Israelni asuni meeno! Han kaamaason odotiwa. Nitto teetaasik arifetisimato Naaziretki Yesus bar oo sinnamato Ha'oos nitto ganeyaassi barki kamo zagina akama akama wostoos, biistera artonoy wuzaasewa besose futo sinbaas artewa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bar teetbaasik Ha'oos zeemma koppa'ena bariknawa arina barikna nittok aattere imtewa. Nitto dey barin tumabesi foonto meeni kushusi suuttonak zagira worseti. ");
INSERT INTO jnjl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sinuntano kituus barin ephpha fu'onak aane chima sinna boor'a Ha'oos kituusi shananon tishkira barin kitun kabgi. ");
INSERT INTO jnjl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawit dey basa chowaasik ekka yi: « ‹Daamiisin wonna wonna sinnaastatu biifawungwa; nawonoynamato bar hoi'ta teshnaastatu fewa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Es bari boor'a nibnaas gire; noononaas dey girak tuunte; Esiisimato ashnaas dey abdiktu faafa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kaanaason ke'oni dimaassi aafa beyana wuza; Kortoneesin dey; moogaassi kuuppe fui'tonak aafa zaguta wuza. ");
INSERT INTO jnjl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kaani ugnaason taak assitwa; ne taneen ane sinta boor'a; giranaas tuuma sinana.› ");
INSERT INTO jnjl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Aytaasakitono! Zeemoti abani meeni ganeyaassin isaas sina Dawit kitire kabbartenamato; moogbaas dey hawungneen kar'a innokik faanamato ammanon nittok makonawa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Sinuntano Dawit es baron makenaas raajju sinna boor'anawa dey Ha'oos barik: ‹Ne zalaassin isaasin ne zigimoosta duusunawa› yit teyya girina abdini kaamaason arire feer sinna boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Es bari boor'a: ‹Kiristoos› ke'oni dimaassi fui'tonoynamatonawa ashbaas dey moogaassi kuupnoynamatonatu zeemme biyaat kitun kabuna bari chowaason make. ");
INSERT INTO jnjl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Es Yesusnin Ha'oos kitun kabgiwa. Inno dey zuuttera es chowaasik zaalwa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ha'oosi hoi'ta teshta duuk den tegifena kabaasiknawa Korto Ayyanaasi abdinon Abaaskin ephna kabaasikna han biifeti baronnawa odefeti baronna kessiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Ese den sama kesaas Dawit sinna beybaason Dawit teetbaasik ekka yit makewa: « ‹Daamiis Daamtaasik; gumaneesin ne ha'suni hugnaasi sikalosi; zaguna kabaneen; hoi'ta teshnaasta duwa.› ");
INSERT INTO jnjl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Ese han nitto suutti Yesusnin Ha'oos Daam dey Kiristoos zaginamato Israelni meeni daraas zuuttere futok aruwowa!» ");
INSERT INTO jnjl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Daraas dey es baron odesefe kabaasik nibbesiissi akamanon safarsere Phexirosninnawa oom wosini meyanonna: «Ayni meyane! Eekin awu zagunirinso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phexiros dey ekka yi: «Harmutiwa; boor'nitiis dey feeshun ustonak isa isarnitiis Yesus Kiristoosni sunaasik haphuqtoti. Ha'oosi ima sina Korto Ayyanaason ephphatootiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Abdini kaamaas nittoknawa naanggotnitiisikitoknawa. Esiisimato dey Daama Ha'oos barki teegona woksok feese baasso zuuttambesiise asiknawa.» ");
INSERT INTO jnjl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Dey ooma showo kaama zaala maket: «Han elinga koontoosta yooni ke'oossin teetnitiison fu'otiwa» yire kiiti. ");
INSERT INTO jnjl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Baassossin showobesiis es kaamaason ephpheteesere haphuktesete. Es wono keez kum sinni asuni meya amanere daytesete. ");
INSERT INTO jnjl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Baasso dey wosini meeni assuuson odesere isarik fook, tushaason isarik muuknawa shiiphokna chimet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Es kabaasik wosini meeni kushuussi showo biistera artonoy wuznewa diinqine zagtet faar sinna boor'a asu zuuttambaase dige. ");
INSERT INTO jnjl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Amanynyini meya zuuttere isariktu feesefe. Fa wuzbesiis zuuttera gaara. ");
INSERT INTO jnjl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Fa wuzbesiisonnawa otumbesiisonna kisire waagefaafe es waagaason isarba isarbaasik sholsinamato haa'e imet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wonna wonna betemeqdesiissi zuutteset feeseter. Keebesi keebesiissik dey wol teegsefaafe isarik tushaason batte giraknawa ma'a nibakna meeset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Daamiisin dey galatteset feeseter. Dara zuuttambaase dey baassotin ulfinsit feer. Ha'oos dey faruni asuni meyanon wonna wonna baassosta daysit faar. ");
INSERT INTO jnjl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Isa wona Phexirosnawa Yohannisna Ha'o shiiphtefana wonni izgin sa'atiista betemeqdesiiski kesete. ");
INSERT INTO jnjl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Estak «Gada» yistefa betemeqdesiisi finynyi faar. Estak intobaasi keensin laafa sinne koonte isa asu feer. Bar dey betemeqdesiissi girife asuskin waaga shiiphonak wonna wonna asuni meya wor'e teshshosi duusit feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Es asus Phexiros Yohannisna betemeqdesiissi girsefeen biyaat waaga imonek baassotin shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Phexiros Yohannisna asuski kootkire biyefaat Phexiros: «Hang innoki biwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Asus dey baassokin isa wuzane imonerwa iyaat kootkire bi. ");
INSERT INTO jnjl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Sinuntano Phexiros: «Birrinewa warqene taakik aafawa. Sinuntano taaki fa baron neek imanawa. Naaziretki Yesus Kiristoosni sunaasik kabira kutuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Hoi'ta kushubaasi zatte kabgin geregere wochobaasewa kumarkushbaase zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kabire dey yere. Kutit baassoneen ane betemeqdesiissi giri. Bar dey kutit, fillet Ha'ooson galattet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Daraasakito zuuttambesiise kutifeennawa Ha'ooson galattefeenna biyete. ");
INSERT INTO jnjl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","«Gada finynya» yistera teegtefa betemeqdesiisi finynyita diifaat shiiphet fe bar sinnamato arsete. Basaastaki sina chowaasik akamanon dajesere diinqeset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Fari asus Phexirosninnawa Yohannisninna asin zataat feen daraas zuuttere diinqok: «Solomonni dagafiyo» yistefa dimaasta baassoki eelet hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Phexiros asuni meyanon biinayse ekka yi: «Israelni daraaso! Han chowaasik awuni boor'a diinqedifetirinso? Awuniron kootkira biidifetirinso? Inno teetniri hugnak wedey Ha'ooson digoniisik han asus farire kutunak zaginirne faar sinna nittok bestefawoso? ");
INSERT INTO jnjl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Inno abani meya Abraham Yisaqnawa Yaqobna asi Ha'o bari Naa Yesusnin ulfinsiwa. Sinuntano nitto kitunak Philaxosni sina aatira barin imetiwa. Pilatos dey kotanak sholen nitto: ‹Aane sholefeniwa› yiseti. ");
INSERT INTO jnjl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nitto Kortoosinnawa ookoosinna: ‹Aane sholefeni› yisefaat kaa wori barin kotanak shiiphseti. ");
INSERT INTO jnjl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kaa imfe barin worseti. Sinuntano Ha'oos barin kitun kabgi. Es chowaasik inno zaalwa. ");
INSERT INTO jnjl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Han biifeti asusinnawa arifeti asusinna farire chima dannaas Yesusni sunaasik beste amantoosikwa. Yesusnik amanobaasik zuuttamnitiise asi sina tuuma faru daniwa. ");
INSERT INTO jnjl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Hashnu aytaasakitono! Han Yesusniista zagseti bar nittotin ha'sife baassosimato tugga'ok zagsetimato arifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sinuntano Ha'oos zeemma raajjuni meya zuuttambesiise asiki kamo: ‹Kiristoos› shana ephphetoonak sholsifa yina kaamaas esiisik ko'unak zagiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ese boor'nitiis feeshun ustonak harmira Daamiiski wolutiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Daamiiskin hepsa wolla gaddo sinati wona nittok yoonak Daamiis zeemme korina Kiristoosnin nittok wosuna. ");
INSERT INTO jnjl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Es Yesus den samak foonaas Ha'oos zeemma korto raajjuni meyaki kamo makenaasimato han daas zuuttera hepsa wolla gaddo sinna wosustona kabaneengwa. ");
INSERT INTO jnjl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muse dey ekka yiwa: ‹Daama Ha'oos taan kabginaasimato nitto ganeyaassin raajjunin nittok kabgunawa. Bar nittok makona baron zuutira odotiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Es raajjuusin odo beya bar zuuttere daraasa ganesin oor kesse tishunawa.› ");
INSERT INTO jnjl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuelniistan kabire feese raajjuni meya zuuttere han wonaasi chowanon esiisimato maksetewa. ");
INSERT INTO jnjl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Raajjuni meyak makte abdiis nittokwa; esiisimato dey Ha'oos Abrahamnik: ‹Han daasta fe darani meya zuuttere ne zalaasiktu suustosonewa› yira abaniisakitoneen ane girina teyyaasi kaama nittoktu siniwa. ");
INSERT INTO jnjl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Es bari boor'a Ha'o zeemma nawubaasin kabgira wosinaas nittokwa. Es baron dey zaginaas nitto isarniti isarnitiis mangu wostontiissin wolini suusanakwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Phexiros Yohannisna daraasik maksefeen maagni meenawa betemeqdesini tasoni gaanynyaasna esiisimato dey Seduk'awini meya baassoki yeesete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Es hep wosini meya daraasik Yesusni kitun kabuuson assubesiisiknawa barki kamo kitun kabu foobaasonna kotte maksete boor'a akamanon gi'tesete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Es bari boor'a Phexiros Yohannisna asin ephere gerok waala sinna boor'a wonananneen taatoni keer foosonek zagsete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sinuntano basakitoni kaamaason ode baasso ganeyaassin showobesiis amanesete. Amane asuni meeni faadaas dey uuch kuma sinana. ");
INSERT INTO jnjl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wonotirik Ayhudni meeni gaanynye meenawa kur'uni meena dey Museni tumaasi assinynyani meya Yerusalemuk zuuttesete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Zuuttese asuni meeni ganeyaassin maagni gaanynye meeni gaanynya Haannanawa Keyyaffana; Yohannisnawa Iskindirosna; maagni gaanynye meeni gaanynyaasa keerki meyaneen zuuttere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Baasso dey Phexiros Yohannisna asin ganebesiissi yeetaat: «Han baron zagsetiis aro hugnak wedey ooni sunakinso?» yit mamussete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Es kabaasik Phexiros Korto Ayyanak tuuntere ekka yit wolgi: «Daraasa ha'sinynyanawa kur'uni meyane! ");
INSERT INTO jnjl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Hash hawung inno mamustoniis isa laafa asusata zagte ma'a wostoosewa aakkak farinamatonawa. ");
INSERT INTO jnjl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Han asus farire nitto sina yerenaas nitto suutni Ha'oos dey kitun kabgina Naaziretki Yesus Kiristoosni sunaasik sinnamato nittonawa Israelni dara zuuttambaase asikna arto sinungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Keyaason keer'fe nitto kashshira ha'iti shu'aas barwa; bar dey kajjaasta duuni shu'awa. ");
INSERT INTO jnjl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Es bari boor'a faru ooma ookinnu aafawa. Inno farunik sholsina Ha'oos asunik imna suna barneen ooma samaneen daakuk oonu aafewa.» ");
INSERT INTO jnjl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Shonggoni meya Phexiros Yohannisna diga foontonon maksobesiison biyeteese arubesi foonto asu sinobesiison arseter sinna boor'a diinqesete. Yesusneen ane feeser sinobesiison dey arsete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Fari asus Phexirosneen Yohannisneen ane yerefeen biyaat maksone wuza turuksete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Estan shonggoostan kesonek zagsefaat ekka yit merkesete: ");
INSERT INTO jnjl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Eekin han asusakitonista awu zagunirinso? Yerusalemuk fe asu zuuttambaase asik baasso zagsete biistera artonoy wuzaas arto siniwa. Es bari boor'a mormonik aafawa chimani wuza. ");
INSERT INTO jnjl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sinuntano han chowaas daraasa ganesi tagunoynamato hawungneen ekalo han Yesusni sunaason kabgire ooniknu maksonoytemato deessira kalaniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Estan baassotin teegsere Yesusni sunaasik isanne maksonoytemato wedey assusonoytemato chinire ajajesete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sinuntano Phexiros Yohannisna wolgire ekka yisete: «Ha'oosik ajajamoostan nittok ajajamonik Ha'oosi sinak sholsunoso? Nitto teetnitiisik makebbetiso. ");
INSERT INTO jnjl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Inno biini baronnawa odeni baronna mako aafa beyaniwuza» ");
INSERT INTO jnjl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Daraasa gaannye meenawa shongoosta diisefe baassona Phexirosninnawa Yohannisninna ke'uk isa chowane dano beyobesiisik dey daraasin digsefaat hepsi dey deessire kotte gafuksete. Es baron dey zagsetees daraas zuuttere sina chowaasik Ha'ooson galattet feer sinna boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Es biistera artonoy wuzaasik fari asus woggabaas acheechasirneen denalo. ");
INSERT INTO jnjl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Phexiros Yohannisna kottesetenneen orfo amanynyi sina zomobesiiski yeesere maagni gaanynye meenawa kur'uni meena maksete baron zuutire maksete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Baasso dey es baron odeseteyse isarik kaambesiison teggire Ha'ooski ekka yit shiiphsete: «Samaasewa daase; baariisewa siruk fa testoose asin zuutire tesi Daamiiso! ");
INSERT INTO jnjl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Korto Ayyanaaski kamo wostinynyane sina abani Dawitni noonoossi: « ‹Aazabni meya awuniron gi'teseteso? daraas awuniron shimak koppa'eseteso? ");
INSERT INTO jnjl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Daasta fe taate meya hooresere; daason ha'sife baasso dey isarik zuuttesere; Daamiisatanawa basa Muudtosatana kabsete.› yira make Ha'oos newe. ");
INSERT INTO jnjl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Futoosik Herodisnawa Pentenawi Pilatosna Aazabiisneen Israelni daraasneen han katamaassi Muudto zagita korto wostinynyane Yesusniista kabsete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Es bar dey ekka sinnaas ne zeemma ne hugnaasiknawa ne fiqadisikna koppa'eta baron ko'issonekwa. ");
INSERT INTO jnjl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Hashnu Daamniiso; fokkorabesiison biwa. Wostinynyaneesakito kaamneeson diga foontonon maksonek chima baassok imma. ");
INSERT INTO jnjl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Korto wostinynyane Yesusni sunaasik mettanni meya farsoneknawa biistera artonoy wuzne; diinqine zagtonak kushuneeson shonggowa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Shiiphsetenneen orfo zuuttesere feesete dimaas shorke. Zuuttambesiise Korto Ayyanak tuuntesete. Ha'oosi kaamanon diga foontonon maksete. ");
INSERT INTO jnjl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Amanynyini meya zuuttere isa nibaknawa isa safaraknatu feesefe. Oonu: «Haniis taarwa» yifena wuza aafa. Fa wuzbesiis zuuttera gaara. ");
INSERT INTO jnjl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wosini meya dey Daam Yesusni kitun kabuuson akama hugnak zaala makset feeseter. Zuuttambesiise asiista akama Ha'oni otma faar. ");
INSERT INTO jnjl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Daason wedey keyaason waagefaafe waagbesiison isa baristatu teshshesefe sinna boor'a ganebesiissi isa rakkata aafe. ");
INSERT INTO jnjl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Waagaason teshshere wosini meyak imet feeseter. Isa isarbesiisik sholsinaasne faaron haa'et feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Koontena daabaas Qophiros sina Yosef yiste isa Lewi feer. Wosini meya barin: «Barnabas» yiretu teegsefe. Kotbaas dey: «Chinuni naa» uu. ");
INSERT INTO jnjl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bar dey daabaason waagere waagaason teshshere wosini meyak imi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Hananiya yiste isa asu asuba Saphphiraneen daa kisire waagsete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Asubaas arifeen es daa waagtena waagaassin fu'efaat taamme wosini meeni wochoossi kunsi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Sinuntano Phexiros: «Hananiyano! Korto Ayyanaason eshataknawa daasi waagtan fu'otakna awuni boor'a Sexana nibneessi giriso. ");
INSERT INTO jnjl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kisira waagonoyfeen daas neertanoso? Kisira waagetanneen orfo waagaas neertanoso? Eekin awuni boor'a han wuzason nibneessi safaretso? Ha'oosontu eshittano asunintawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hananiya es kaamaason odenayse kere wor'e kiti. Es baron ode asuni meya zuuttere akamanon digsete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na'oni meya kabsere kitubaason kimme kabbarsete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Keez sa'atineen orfo asubaas teegobaasata sina chowaason arunoy yaara kar'i. ");
INSERT INTO jnjl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phexiros dey: «Makebbe; daantiison waagsetiis han waagaassinose?» yi. Bar dey wolgira: «Aa; han barissitu waageniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Phexiros dey: «Daamiisa Ayyananon fattanok aakkak isarik merketise? Ese teegoneesin kabbare asuni meeni wochoos han finynyiissitu fawe. Neen dey ephphe kabbarsonerwe» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bar dey geregere wochobaassi kere wor'a kiti. Asuni meya dey girseten kitira kunfeen danne taamme teegobaasa moogni tesha kabbarsete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Betekiristaniissinawa es baron ode asuni meya zuuttambesiise asiistana akama diga sini. ");
INSERT INTO jnjl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Daraasa ganesi showo biistera artonoy wuznewa diinqine wosini meeni kushuussi zagtet faar. Zuuttere isa nibak Solomonni dagafiyo yistefa dimaasta zuuttet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Baassoneen oom asu baassossi wo'itok oonu chimfer aafe. Sinuntano daraas akamanon ulfinsit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Daamiisik amanefe arqarnawa mashkare akamanon daytet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Phexiros esta kamo hamfena kabaasik yirarabaasnu mettanni meyaasta kamo aatanak mettanni meyanon oppotanawa saa'otana wor'e ugunta kisire kunsit feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Asuni meya Yerusalemni biratoosta faase katamaasikitosin mettanni meyanonnawa kiina ayyana ephaan mettet fe baassotinna ephphe yeeset feeseter. Mettanni meya dey zuuttere farit feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Maagni gaanynye meeni gaanynyaasnawa barneen ane feese Seduqawini meeni keen sina baassona zuuttere koonak wosini meyaasta kabsete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wosini meyanon ephere daraasa taatoni keer gedesete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sinuntano Daamiisa wosiya wassi taatoni keyaason gachcha baassotin kisaat: ");
INSERT INTO jnjl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Hamfaat betemeqdesiisi yerefaat han kaani kaamaason zuutira daraasik makotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wosini meya dey wonfana kabaasik baassok maktenaasimato betemeqdesiissi hamme assisete. Maagni gaanynye meeni gaanynyaasnawa barneen ane fe baassotna yeesere shonggosta diisefe baassotinnawa Ayhudni kur'uni meyanonna isarik zuutisete. Wosini meyanon dey ephphe yoosonek asunin taatoni keer wosisete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sinuntano tasoni meeni ha'sinynyani meya taatoni keer hamere aane danoto. Wolle yeesere dey: ");
INSERT INTO jnjl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Taatoni keyaasi gamala mai'sira kuluftera yerer; tasoos dey finynyibaasta yersefeen biini. Sinuntano gachcha girira ooninnu aane daneni» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Betemeqdesini tasoni meyanon ajajefe barnawa maagni gaanynye meena es baron odeseteyse: «Han bar awutaaso?» yiset sina wuzaasik ephphe maksone wuza tishi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Es kabaasik isa asu yeere: «Taatoni keer taatiti asusakito betemeqdesiissi yersefaat daraasin assidifewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Estan tasoosa gaanynyanawa basa wostinynyaasna hamme baassotin ephphe yeesete. Sinuntano daraas shu'ak baassotin ichnoynamato digsefaat hugnak aane ephoto. ");
INSERT INTO jnjl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wosini meyanon ephpheteshsho shonggosi sina yeetisete. Maagni gaanynye meeni gaanynyaas ekka yit mamsi: ");
INSERT INTO jnjl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Han sunaasik daraasin assunoytimato kalla faanir; sinuntano nitto Yerusalemni daraasin assira koi'siti; dey Yesusnin woriis inno zagira basa hannaasik mamustonik sholsefeti!» ");
INSERT INTO jnjl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phexiros oom wosisakitona wolgire: «Asunik ajajamoostan Ha'oosik ajajamoniktu sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nitto i'oosta suutta worseti Yesusnin abaniisa Ha'o barin kitun kabgiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bar dey Israelni daraasik harminewa boor'aason feeshun une imanak Ha'oos barin zuuttambaase asi zoonsinawa fatunirna zagira o'itbaasta duunak zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Inno dey es chowaasik zaalwa. Ha'oosik ajajamefe baassok imna Korto Ayyanaas dey zaalawa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Shonggosta diise baasso dey es baron odeseteyse akamanon haaresere baassotin woruk sholsete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sinuntano dara zuuttambaase asi sina ulfinto tumaasi assinynya Gamaliya yiste shonggosta diisefe baassossin isa Farisawi kabire wosini meyanon gero kissonek zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Estan shonggosta diisefe baassok ekka yi: «Israelni asuni meyane! Han asusakitonista zagutik safareti baristan teetnitiison oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Zeemo sinak Tewodas yiste asu teetbaason iny zagire kabin acheech tii asu dey barik zoonustesete. Sinuntano bar worte. Barneen zoonuste asusakito dey sikte. Koppa'ena wuzaas dey baak tishira fu'te. ");
INSERT INTO jnjl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Esseen orfo dey darani faada zagtena kabaasik Galiilaki Yuuda kabire showo daranin barik zoonustonak zagi. Es asus dey worte. Barik zoonuste baasso dey siktesete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Es bari boor'a hash ta nittok makefanaas han asusakitonin beyatiknawa baassostan shaatotiknawa. Han wostobesiis asunikin sinfaanane tishutu tishuna. ");
INSERT INTO jnjl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Sinuntano Ha'ooskin sinfaanane baassotin yeetutik aafa chimati wuza. Dey Ha'oosneen faasser sinatiitawa» yi. Baasso dey basa kiitooson ephpheteesete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wosini meyanon hang baassoki teegsere ichaat Yesusni sunaason teegsere maksonoytemato ke'ire gafuksete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Sinuntano wosini meya Yesusni sunaasik kashistoos sholsu zagire faadisete boor'a shonggosi sina giret kesete. ");
INSERT INTO jnjl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Wonna wonna betemeqdesiissinawa keya keyaassina Yesus Kiristoosni chowaasik assuusonnawa misirachchuni kaamaason makoosonna aane yeetusoto. ");
INSERT INTO jnjl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Es wonaasi amanynyini meeni faadaas daytet hambaase. Girikni noono wollefe Ayhudni meya Yuudaki Ayhudni meyaasta unyisete. Es unyisetees wonna wonna haachefa argasuni imaas baasso dicha asusikitok beytera faar sinna boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Estan asire heppe wosini meya amanynyini meyanon zuutire ekka yisete: «Muuni haa'akwa iyaat Ha'oosi kaamanon mako beyanik aane sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ese ayni meyane; nitto ganeyaassin ma'a amalabesi faana Korto Ayyanaknawa techmakna tuum naafun asunin korani han wostooson wostosonek imniwa. ");
INSERT INTO jnjl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sinuntano inno shiiphoknawa kaamaason makokna chimani.» ");
INSERT INTO jnjl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Es kaamaas zuuttambesiise asin girsi. Estan amantoknawa Korto Ayyanakna tuunto Isxifanosnin, Filiphosnin, Prokorosnin, Nikarosnin, Timonannin, Permenannin, Ayhudni meyaassi girire fe Ansokiyaki Nikolawosnin korsete. ");
INSERT INTO jnjl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Es baassotin teshshere wosini meeni sina yeetisete. Wosini meya dey shiiphsetenneen orfo kushubesiison baassosta ta'isete. ");
INSERT INTO jnjl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ha'oosi kaama dey tagit hamna boor'a amane asusa faada Yerusalemuk akamanon daytet hami. Maagni meyaassin dey showobesiis amanesete. ");
INSERT INTO jnjl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Isxifanos Ha'oni otmaknawa hugnakna tuumme daraasa ganesi diinqinewa biistera artonoy wuzne zagit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Es kabaasik: «Birmadumma kesa asuni meeni zuuttoni keya» yistera teegtefa Ayhudni shiiphoni keyaasi asuni meya; Qerenaki asuni meenawa Iskindiriyaki asuni meena; Kilqiyannawa Iisiyanna isa isa asuni meya kabsere Isxifanosneen ane karakkarsete. ");
INSERT INTO jnjl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sinuntano Isxifanos maket feena techmaasonnawa Ayyanaasonna yeetuk aane chimoto. ");
INSERT INTO jnjl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Estan dey: «Isxifanos Museniistanawa Ha'oostana mei'ni kaama makefeen odeniwa» uni asuni meyanon aachok kabugsete. ");
INSERT INTO jnjl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ekkak daraasin, kur'uni meyanon, tumaasi assinynyani meyanon basaasta kabugsete. Isxifanosnin ephere shonggosi sina tai'sisete. ");
INSERT INTO jnjl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Basaasta esha zaala makoni asunin ephphe yeesete. Baasso dey: «Han asus han betemeqdesiistanawa tumaastana mei'ni kaama makooson aane beye. ");
INSERT INTO jnjl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Dey: ‹Han Naaziretki Yesus han betemeqdesiison bognir; Muse imna tumaason dey soolonir› yire makefeen odeni» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Es kabaasik shonggosta diise baasso zuuttere Isxifanosnin kootkire biyeten sinbaas Ha'oni wosini sinane faar sinna beste. ");
INSERT INTO jnjl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Maagni gaanynye meeni gaanynyaas Isxifanosnin: «Han neyista maktefa chowaas futonoso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Isxifanos wolgire ekka yi: «Aytaasakitonawa abataasakitona odotiwa! Abani Abraham Kaaran duuk hamnoy zeemme Mesepetomiyak feen ulfinto Ha'oos barik ammanon bestera: ");
INSERT INTO jnjl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹Daaneestannawa koonneesasinna kessa ta besuna dimaas hamma› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Es kabaasik Keledawini meeni daastan kesse hamme Kaaran di. Estan ababa kitinanneen orfo hash han nitto faafeti daasta Ha'o barin teshshewa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ha'oos hantak wochobaasonnu yeetuna dima barik aane ima. Sinuntano han daason bariknawa barneen orfoki zalbaasikna imanak Ha'o teyya giriwa. Es teyyaason girinaas Abraham nawubaasin koonunoyfeengwa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Zalbaas dey alaga daasta foonamatonawa acheech tiya wogga boza zagsere miir'ak ha'susonematona makera faarwa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Estan dey: ‹Bozok yer'e ha'si daraasata mangsu kar'anar. Esseen orfo birmadumma kesere taan shiiphsone› yira Ha'oos makewa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Estak dey haarkoni kunni teyyaason barik imi. Es bari boor'a Abraham Isaqnin koontenari nangirinsinari wono haarko kunsi. Esiisimato dey Isaaq naaba Yaqobnin haarko kunsi. Yaqob dey asire heppe zalaasi aba sina naanggotbaason haarko kunsi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Yaqobni naanggotiis Yosefniista koonesere boz sinanak Giphtsi waagsete. Sinuntano Ha'oos barneen anetu fa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Basaasta kar'a shana zuuttambaase asiissin barin kisi. Giphtsiki taato Fere'onni sina addanewa techumne imi. Fere'on dey Giphtsiniistanawa fa wuzbaastana ha'sunir zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Es kabaasik Giphtsiniistanawa Kene'aniistana maknewa akama shanane sini. Abaniisakito dey muusone muu turuksete. ");
INSERT INTO jnjl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yaqob dey Giphtsik meya foobaason odere zeemme abaniisakitonin Giphtsi wosi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Hepsa wolle hamefe kabaasik Yosef aybaasakitonik ammanon kisire make. Fere'on dey Yosefni koon sinobesiison ari. ");
INSERT INTO jnjl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Esseen orfo Yosef wosire ababa Yaqobninnawa basa koonni meyanonna barki yoosonek zagi. Baasso dey faadbesiis naafunasire uuchche. ");
INSERT INTO jnjl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Estan Yaqob Giphtsi hami. Barnawa abaniisakitona estak kitisete. ");
INSERT INTO jnjl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kitubesiis dey Sekem oottera hamma Abraham Hemorni naanggotaaskin basa birriisik waagena moogaassi kabbarte. ");
INSERT INTO jnjl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ha'oos Abrahamnik teyyak imna abdiis ko'unak tai'set yaafana kabaasik Giphtsiki fe daraniisa faada arkit hami. ");
INSERT INTO jnjl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Es bar dey sinnaas Yosefni arunoy oom taato Giphtsik taattena wononeengwa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Es ora taatoos daraniisin manguk kabire abaniisakitonin shana besi. Daaga naanggotbesiis kitunaknawa ek gero kissere ha'sonekna abaniisakitonin giddisi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Es kabaasik Muse koonte. Bar dey Ha'oosi sina keeshu daag naa sini. Keez assa ababaasa keer diire dichi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Gero kesse kunsiseten taato Fere'onni nawaas danna ephpha bari naa zagira dichi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Muse dey Giphtsini meeni techmaason zuutire ari. Wollaknawa wostokna chim asu sini. ");
INSERT INTO jnjl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Acheechasir woggaba sinfana kabaasik ayba sina Israelni naanggotaason mamsunak nibbaassi safare. ");
INSERT INTO jnjl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Isa Giphtsini asu basa ayiisin miir'efeen danne Giphtsini asusin woruk guma kaaste. ");
INSERT INTO jnjl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Basa keen sina baasso Ha'oos barki kamo baassotin birmadumma kisunir zagire biisediferne faar sinnatu barik bestedifa. Sinuntano baasso es baron aane arsoto. ");
INSERT INTO jnjl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Wonotirik hep Israelni asu barna barna faassefeen danne gansunak sholefaat: ‹Nitto ayna aynawa, awuni boor'a nittotna nittotna faassedifetirinso?› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Es zomobaasin miir'et fe bar Musenin ek tugire: ‹Ne innoosta mangsu kar'ataknawa ha'sutakna zagiis oonso? ");
INSERT INTO jnjl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Hazoti Giphtsini asusin woritaasimato taan dey worutak sholedifataroso?› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Muse es baron odenaase Midiyamni daa guuzze hamme di. Estak hep arqa naanggotnin kooni. ");
INSERT INTO jnjl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Muse es daastak acheechasir wogga tuumfana kabaasik Siinaki aamaasi tesha fa ichma daassiki saabaassi saamet fa geyaasi winoossi Ha'oni wosiya barik beste. ");
INSERT INTO jnjl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Muse es biina chowaasik diinqet ek barki tai'se. Estan ekka yifa Daamiisa kaamanon dey ode: ");
INSERT INTO jnjl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Ta ne abasakitoni Ha'owa, Abrahamni Ha'o, Yisaqni Ha'o, Yaqobni Ha'owa› Muse dey digak biyanaknu aane chime. ");
INSERT INTO jnjl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Daamiis dey ekka yi: ‹Yereta dimaas korto daa sinna boor'a wochoneessin chaa'maneeson kisuwa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Giphtsik fe darataasa shananon futok biingwa. Rakkobesiisi chaaganon odengwa. Es bari boor'a fu'onak kerengwa. Hashnu hani yowa. Neen wolgira Giphtsi wosunawa.› ");
INSERT INTO jnjl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","« ‹Innoosta mangsu kar'ataknawa ha'sutakna oonso neen zagiri?› yit oomtesete. Sinuntano Ha'oos es Musenin saabaassi beste Ha'oosi wosiyaaski kamo ha'sunirnawa furonirna zagira baassoki wosi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Es asus dey Giphtsiki daasta she'a baariistanawa ichma daassina diinqinewa biistera artonoy wuzne zagit acheechasir wogga baassotin zoonsi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‹Daama Ha'ontiis taan kabginaasimato nitto ganeyaassin raajjunin nittok kabgunawa› yire Israelni meyak makees es musewa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Zaboossi Israelni maabaraasneen ane; Siinaki aamaasta make Ha'oosi wosiyaneen ane esiisimato dey abaniisakitoneen ane feyiis Musewa. Kaani kaamaason dey ephphe innok aatiis es Musewa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Sinuntano abaniisakito barin oomtotu oomtesetetano aane ajajamosoto. Nibbesiissi dey Giphtsi wolle kerok safarsete. ");
INSERT INTO jnjl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aaronnin dey: ‹Giphtsin innotin zoonsire kisi Museniista awu kar'namato aane aruweni sinna boor'a inno sinaasta zeemma zoonsuni ha'osikitonon innok wostowa› yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Es kabaasik alaqani gitok koo'lo hoo'e maa'a imete. Kushubesiisi wostok dey girsete. ");
INSERT INTO jnjl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sinuntano Ha'o baassostan oor kesi. Samaasta fa baakuraasik sagadosonek aatira imi. Esiis dey raajjuni meyaki kamo: « ‹Nitto Israelni meyane! acheechasir wogga zaboossik shukti waagaasewa maa'aase taaknoso? ");
INSERT INTO jnjl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ephpha hamtiis Molokni durkaniisewa; Refam yiste ha'ontiisi baakurani suuraasewa; es bar dey kushuntiisik wostera; barik kaa'net faati ha'ontiiswa; ta dey Baabilonni ekalok kabugtotik; nittotin zaguna yistera tichchenaasimatowa› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Inno abani meya ichma daassi zaalni durkanibesi faarwa. Es durkaniison Ha'oos barik makenaasimatonawa besinaasimatona wostees Musewa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ha'oos baasso sinaastan kalla eelsina aazabni meeni daason ephefe kabaasik Iyyasuneen ane durkaniison ephphe girsete. Dawitni neyaas kar'ananneen esta di. ");
INSERT INTO jnjl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawit Ha'oosi sina ulfina danne Yaqobni Ha'oos ha'una keya keer'anak shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sinuntano Ha'oosik es keyaason keer'aas Solomonwa. ");
INSERT INTO jnjl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Sinuntano zuuttambaase asiistan denalo sina Ha'oos asuni kushuk keete keesi aane diifa. Es bar dey raajjuniki kamo: ");
INSERT INTO jnjl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","« ‹Samaas ta zigimuwa; han daas dey wochonaas yer'ana dimawa; eekin awune fa keyanso taak keer'atiri? beysa ephana keyaas dey awune faarinso?› » yife Daamiis. ");
INSERT INTO jnjl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","«Han baron zuutira wostees; ta kushustanoso?» yifawa Ha'oos. ");
INSERT INTO jnjl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Nitto eling asuni meya, nibniti taato, odontiis odonor, nitto dey nitto abani meenimato Korto Ayyanaason wonna wonna oomtetir. ");
INSERT INTO jnjl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Raajjuni meyaassin nitto abani meya kabgusonoyter oonso? Baasso ookoosa yoonon zeemme makse baassotin worsesete. Nitto dey hash han ookoosin aatire imak worseti. ");
INSERT INTO jnjl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nitto Ha'oosi wosiyaki kamo makte tumaason ephpha taaseti. Sinuntano aane oodeti.» ");
INSERT INTO jnjl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Shonggosta diise baasso es baron odeseteyse akamanon haaresere Isxifanosniista ha'besiison karmisete. ");
INSERT INTO jnjl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sinuntano Isxifanos Korto Ayyanak tuumme den sama kootkire Ha'oosi ulfinanon bi. Yesusnin dey Ha'oosi hoi'ta teshta yerefeen bi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Estan: «Sama gachchefaan Asuni Naa Ha'oosi o'itta yerefeen biidifawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Es kabaasik akama kaamak chaagete. Odobesiison ukere ek barki eelete. ");
INSERT INTO jnjl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Barin ephphe katamaassin kissere shu'ak ichesete. Zaalni meya dey maybesiison oodanak ephphe taamme Sawul yistefe isa na'o asuni wochoossi kunussete. ");
INSERT INTO jnjl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Isxifanosnin ichesefeen: «Daam Yesusno! Kaanaason neeki ephwa» yit shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kaa'nere dey akama kaamak: «Daamiiso han boor'besiiso baassosta faadutaatawa» yit chaagi. Es baron yinanneen orfo kiti. ");
INSERT INTO jnjl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawul Isxifanos wortobaasik gire. Es kabaasik Yerusalemuk fa betekiristaniista kabugto kabi. Wosini meya baasso baassoteno oom amanynyini meya zuuttere Yuudanawa Samariyaki daa zuuttambaase asiissi siktesete. ");
INSERT INTO jnjl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Shiiphok chimme fe asuni meya Isxifanosnin dugnooson kabbarsete. Barik dey akamanon waassete. ");
INSERT INTO jnjl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sinuntano Sawul betekiristaniison tishkuk kabet feer. Keya keyaassi girifaafe arqa kiristanaasinnawa mashka kiristanaassonna zatte kisitaafe taatoni keer gedet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Sikte amanynyini meya hamete hamete daassi kaambaason makset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filiphoos dey Samariyani katamaassi hamme Kiristoosni chowaason make. ");
INSERT INTO jnjl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Showo dara dey Filiphoos makena baron odetnawa zagifena biistera artonoy wuzasonna biyefaat gasasire barin odet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kiina ayyanaasikito dey akama kaamak chaaget showo asuniissin keset faar. Showo laafanawa engitna farset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Es bari boor'a es katamaassi akama gira sini. ");
INSERT INTO jnjl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Es katamaassi Simon yiste isa asu tolfata tolfatefaafe Samariyaki daraasin diinqisit feer: Dey: «Ta arkitto asuwa» iyaafe maket feer. ");
INSERT INTO jnjl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Garosatan kabgire gaymasata kar'e fe asu zuuttere: «Han asu arkitto yistera teegtefa Ha'oni hugnawa» yiset gasasire odet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Es gasasire odesefees showo wona tolfatak baassotin diinqisit feer sinna boor'a. ");
INSERT INTO jnjl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Sinuntano Filiphoos Ha'oosi taatosonnawa Yesus Kiristoosni sunaasonna makena misirachchuni kaamaasonna odesere arqaas mashkaas amanere haphuktesete. ");
INSERT INTO jnjl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tolfattu Simoonnu amanere haphuktere Filiphosneen ane isar sini. Zagtet fa diinqisewa akama biistera artonoy wuzason biire diinqet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yerusalemuk fe wosini meya Samariyaki daraas Ha'oosi kaamanon ephphetoosobesiison odefaat Phexirosninnawa Yohannisninna asin Samariya wossete. ");
INSERT INTO jnjl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Phexirosninnawa Yohannisninna dey hamere Samariyaki asuni meya Korto Ayyana ephphetoosonek Ha'o shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Esiis dey Daamni Yesusni sunaasiktu haphuktesetetano Korto Ayyana baassosta aane kerowa. ");
INSERT INTO jnjl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Estan Phexiros Yohannisna kushubesiison baassosta ta'ubesiise Korto Ayyana ephpheteesete. ");
INSERT INTO jnjl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Wosini meya kushubesiison asuni meyaasta ta'iseten Korto Ayyana imtobaason biyaat Simon waaga ephpheteshshere: ");
INSERT INTO jnjl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Ta dey kushunaason ta'una asuni meya Korto Ayyana ephphetoosonek han ha'suni hugnaason taak imtiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sinuntano Phexiros: «Ha'oosi imanon waagneesik waagotak safareta boor'a waagnees neneen ane tishungwa! ");
INSERT INTO jnjl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nibnees Ha'oosi sina mangu sinna boor'a han wostoossi girira wostota dimnewa ixane neek aafawa. ");
INSERT INTO jnjl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ese han manguneessin harmira Daamiiski woluwa. Awuzakne han nibneesi mangu safaranon feeshun unitto shiiphowa. ");
INSERT INTO jnjl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ne suqaro koonak tuumma faatamatonawa boor'aasik taatera faatamatotu biidifawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon dey: «Han makseti barissin isarnu tayista kar'noynamato nitto wolla Daamiisin taak shiiphotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Phexiros Yohannisna zaala makserenawa Daamiisa kaamanon maksetenneen orfo showo Samariyani ke'eessi hamefaafe misirachchuni kaamaason makset Yerusalem wolle hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Daamiisa wosiya Filiphosnin: «Kabira Yerusalemun Gaaza katifa ichma daassiki ugna kawuda wolla hamma» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bar dey kabire hami. Hindake yistefa Itophiyani taatosi foononnawa waagbaasonna ha'sife isa jandaraba Itophiyani asu Ha'ok kaa'nok Yerusalem yeere feer. ");
INSERT INTO jnjl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Es jandarabaas wolle daaba hamfena kabaasik seregellata diifaat raajju Isayyasni tichaason feretit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Estan Korto Ayyanaas Filiphosnin: «Ek saragalaski tai'sera uphowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Estan Filiphoos dey taptere ek seregellaaski hamfeen Itophiyani asus raajju Isayyasni tichaason feretifeen odaat: «Han feretifa ta bar neek galedifaroso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Itophiyani jandarabaas dey wolgire: «Taak kotte makoni asu foontonon aakkak taak galonirinso?» iyaat Filiphosnin: «Han seregellaasta kessa taneen ane duwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jandarabaas dey feretit feena tichaas ekkatu yifa: «Bar shuktok zattera hama fantune feer; esabaason kar'fe baasso sina shaakkife Fantusamato kaambaason aane kote. ");
INSERT INTO jnjl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Salphate; dey futoni mangsuni kar'a barik aane katowa; kaabaas han daastan kaltera tishina boor'a; Han koontoosi chowanon oo makok chimnirinso?» ");
INSERT INTO jnjl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jandarabaas dey wolgire Filiphosnin: «Raajjuus han baron ooni chowanso makenari? Basa teetnirinwa wedey oom asunirinso? Taak makaaywa» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filiphoos dey es tichaastan kabire Yesusni chowaason maket fa Ha'oosi kaamanon kotte make. ");
INSERT INTO jnjl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hamere isa akani tesha kar'eten Jandarabaas: «Ese hanta aka faarwa, haphuktonak kalni wuza aambanso?» yi.  ");
INSERT INTO jnjl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filiphoos wolgire: «Tuuma nibneesik amanefaatane haphuktok chimatawa» yi. Jandarabaas dey: «Yesus Kiristoos Ha'oni naa sinnamato amanefawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jandarabaas saragalaas yeronak ajaje. Hepobesiise yeet akaassi kerseten Filiphoos Jandarabaasin haphqi. ");
INSERT INTO jnjl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Akaassin kesefe kabaasik Daamiisa Ayyana Filiphosnin ephpha hami. Jandarabaas dey Filiphosnin esseen orfo aane biye. Giret ugunbaason hami. ");
INSERT INTO jnjl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Sinuntano Filiphoos Azaxonuk biiste. Qisariya hamme kar'ananneen aatfena katama katamaassi misirachchuni kaamanon make. ");
INSERT INTO jnjl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Es kabaasik Sawul Daamiisa nawoni meyanon worunak deessit maagni gaanynye meeni gaanynyaaski hami. ");
INSERT INTO jnjl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Daamiisa ugnak zoonustefe meyanon arqasinnawa mashkasonna danfena kabaasik taar'taafe Yerusalem teshshok chimanamato Demaskoki fa Ayhudni shiiphoni keyaasikitok ticha imtonak maagni meyanon mamsi. ");
INSERT INTO jnjl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Demasko hamme kar'fena kabaasik biratobaasta den saman diinqone chaarefa palpali. ");
INSERT INTO jnjl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Es kabaasik bar daa kere gande. Estan: «Sawulno, Sawulno, awuni boor'a taan kabgidifa?» yifa kaama ode. ");
INSERT INTO jnjl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sawul dey: «Daamiiso! Ne oonso?» yi. Bar dey wolgire: «Ta han ne kabgifata Yesuswa. ");
INSERT INTO jnjl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sinuntano hash kabira ek katamaassi hamma. Zagutak sholsuuson estak neek maksonewa.» ");
INSERT INTO jnjl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sawulneen ane hama asuni meya kaamaason odesete. Sinuntano ooninnu aane biyoto sinna boor'a maksone wuza tishifaan shaakkisere yersete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawul dey gandena dimaastan kabi. Sinuntano aaffaason woyin biyanak aane chima. Es bari boor'a asuni meya kushubaason zatte zoonsit Demasko katama ephphe hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Keez wona kar'ananeen aaftishu sinne muu muunoynawa ushnoyna di. ");
INSERT INTO jnjl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Es kabaasik Demaskok Hananiya yiste isa Daamiisa nawo feer. Daamiis raa'ik: «Hananiyano!» yire teege. Bar dey: «Abetwa; Daamiisob hantatu fawungwa» yit koyi. ");
INSERT INTO jnjl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Daamiis dey barik ekka yi: «Kabira zeephto yistefa ugnaasik hamma. Estak Yihuda yistefe asusa keer Sawul yiste isa Terseski asusin sholowa. Hash bar shiiphotatu fewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sawul dey Hananiya yiste asu yeere kushubaason aaffaasta ta'fena kabaasik biyanamato raa'ik bi. ");
INSERT INTO jnjl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sinuntano Hananiya wolgire ekka yi: «Daamtaaso! Han asus Yerusalemuk feese amanynyisata akama shana katinamato ta showo asunikin odengwa. ");
INSERT INTO jnjl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Hashnu han Demaskok feese ne sunaason teegesefe baassotin zuuttambesiise asin taar'anak maagni gaanynyasakitonikin fiqadi ephiwa» ");
INSERT INTO jnjl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Daamiis dey Hananiyanik ekka yi: «Bar Aazabni meeni sina; taate meeni sinanawa Israelni daraasa sinana ta sunaason wor'ni ta korina korto kodana sinna boor'a barki hamma. ");
INSERT INTO jnjl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ta sunaasik awune fa shana ephphetoonak feenamato ta barik ammanon besunawa» ");
INSERT INTO jnjl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Estan Hananiya hamme es bar feena keyaassi giri. Kushubaason Sawulniista ta'ire: «Ayta Sawulno! Hani yaafeen ugnaasta ammanon neek uphe Daam Yesus aafnees biyanaknawa Korto Ayyanak tuuntotakna taan neeki wosiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Geregere Sawulni aaffaastan i'oni gongane fa wuza zigin biyak chimi; dey kabire haphukte. ");
INSERT INTO jnjl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Muu dey meere chimi. Demaskok feese nawoni meyaneen ane garo wona di. ");
INSERT INTO jnjl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Geregere Sawul Demaskok: «Yesus Ha'oni Naawa» yit Ayhudni shiiphoni keyaasikitosi assu ephi. ");
INSERT INTO jnjl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ode baasso dey zuuttere diinqok: «Han asus Yerusalemuk han sunaason teegefe baassotin zuuttambesiise asin tishkit fe bartenoso? Dey hani yeenaas baassotin taar'e maagni gaanynyasakitoniki taamme imaktanoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sinuntano Sawul zeemotiistan daysire chimet hami. Demasko fe Ayhudni meya Yesus bar Kiristoos sinnamato kotte assubaasik maksone wuza turksit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Showo wonaneen orfo Ayhudni meya Sawulni woruk merkesete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sinuntano bar baasso mangu mekamaason ari. Baasso dey barin woruk toone waalinne bar kesfena katamaasi finynyaasi kitonon oodet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sinuntano basa nawoosakito wassi katamaasi shu'ni ojaasi kattosi kamo Sawulnin masasi duusire kessisete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sawul Yerusalem hamme kar'e estak feese Daamiisa nawoneen ane woi'tonak shole. Sinuntano Sawul Kiristoosnin amanobaas futo sinna baassok aane bestowa sinna boor'a zuuttere digesete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Sinuntano Barnabas Sawulnin wosini meyaki ephphe taamme uguntak feen Daamiis aakkak barik ammanon uphenamato; barneen dey wollenamatonawa Demaskok Daamiisa sunanon aakkak digaba foontonon assinamatona baassok make. ");
INSERT INTO jnjl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Es bari boor'a Sawul baassoneen ane feefaat Yerusalemniissi biratefaafe Daamiisa sunak dey digaba foontonon maket feer. ");
INSERT INTO jnjl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Girikni noono wollesefe Ayhudni meyaneen wollefaafe karakkaret feer. Sinuntano baasso barin woruk hooresere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ayni meya es baron arseteyse Qisariya ephphe hamete. Estan Terses hamanak zagisete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Es kabaasik Yuudak, Galiilaknawa Samariyakna fa betekiristaniis naga dani. Daamiisin ulfinsitnawa Korto Ayyanaasik chimetna faadbaas dey daytet hami. ");
INSERT INTO jnjl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Phexiros daadaassi biratet feena kabaasik Lida yiste daasta feese amanynyini meyaki hami. ");
INSERT INTO jnjl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Estak dey Eeniya yiste asu nangirin wogga laafa sinne mettere kuphota kunfeen dani. ");
INSERT INTO jnjl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phexiros dey: «Eeniyano! Yesus Kiristoos neen fatunawa; kabira kuphoneeson yiir'wa» yin Bar dey geregere kabi. ");
INSERT INTO jnjl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lidaniissinawa Seronaneessina feese asuni meya zuuttere barin biyefaat Daamiiski wolsete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iyyopheni daastak dey Xabita yiste isa amanynyi faar. Sunbaasi kota dey Girikni noonok «Dorqa» uu. «Dorqa» uus dey «Gimuwa» uu. Bar dey wonna wonna ma'a wosto zaguk tukamni meyanon argasit faar. ");
INSERT INTO jnjl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Es kabaasik bar mettera kiti. Asuni meya dey dugnooson masse segenetiista kunussete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida Iyyophek ta'a sinna boor'a Iyyophek feese nawoni meya Phexiros Lidak foobaason odeseteyse hep asuni wossere: «Adarawa taptera innoki yaafaywa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Es bari boor'a Phexiros kabire wosineen ane hamme esta kar'fena kabaasik segenetiissi barin ephphe hamete. Dicha asusikito zuuttera Dorqa kaak faana kabaasik wostena wondaboosewa maamaase asin besaafa waasset faaser. ");
INSERT INTO jnjl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Sinuntano Phexiros zuuttambesiise asin keerun kisaat kaa'nere shiiphe. Ek dugnooski yerqere: «Xabitane kabuwe» yi. Bar dey aaffaason woora Phexirosnin biinaase kaanna di. ");
INSERT INTO jnjl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bar kushubaason shongere zatte kabgi. Dicha mashkasusikitoknawa oom amanynyini meyanonna teegere nawaason kaabarereron baasso sinna tai'si. ");
INSERT INTO jnjl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Es chowaas Iyyopheki daasta zuuttambaase asiissi zi'ira arte. Showo asuni meya dey Daamiisik amanesete. ");
INSERT INTO jnjl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Phexiros Simon yiste isa wooma kaa'a asuneen ane Iyyophek showo wona di. ");
INSERT INTO jnjl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Qisariya yiste daa diife sunba Qornelewos yiste isa asu feer. Bar dey Romanni meeni taatosi sikalosi fa Ixaliyani toray yistefa barissi tii meeni gaanynya. ");
INSERT INTO jnjl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Bar dey basa keer feese asuni meyaneen Ha'ooson shiiphoknawa digakna esiisimato dey tukamni meyak akama ima imet feer. Wonna wonna dey Ha'ooski shiiphet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Isawa izgin sa'ati kar'fana kabaasik Ha'oni wosiya barki yaara: «Qornelewosno!» yira teegefeen ammanon raa'ik bi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Qornelewos Ha'oosi wosiyanon kootki biyaat nayere: «Daamiiso! Aambanso?» yi. Ha'oosi wosiya dey ekka yi: «Shiiphonesewa tukamni meyak imfata imneese Ha'oosi sina neen safaronir sinna den hamiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hashnu asutni meyanon ek Iyyophe wosira Phexiros yiste Simoonnin teegsuwa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Bar hash dichaasi tesha fe googo kaa'fe Simonni keer irba sinne diifewa.» ");
INSERT INTO jnjl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Qornelewosnik han wosiyaason make Ha'oosi wosiya kessa hamnanneen orfo wostinynyabasakitonisin heppinnawa Qornelewos ha'sifena baassossin Ha'ooson digefe isa meyataar'oninna teegere ");
INSERT INTO jnjl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Zuuttambaase asin baassok makenanneen orfo baassotin Iyyophe wosi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wonotiri wono wostere hama asuni meya katamaaski tai'sesefe kabaasik issun sa'atik Phexiros Ha'o shiiphonak segenetiista kesi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Es kabaasik Phexiros maktere muu muunak shole. Muu barik hoorefeen bar shaakkire diifaat raa'i bi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Biina raa'iis dey samaas gachchefaan isa inya yinune fa wuza samaasi acheech fashbaasta oottera daasta kerefeen bi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Es yinusta dey acheech wochobare yere kaabare yere wuza wochoba foonto daasta nibbaasik zayifa testoosewa den samaastak fulifa kasaasikitone faaser. ");
INSERT INTO jnjl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Es kabaasik: «phexiros Kabira han barikitonon shukka muwa» yifa kaama ode. ");
INSERT INTO jnjl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Sinuntano Phexiros: «Daamiiso! Aafawa sinanawuza. Ta kayma sinnoy wuza wedey kiina wuza maara aane biyutwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dey: «Ha'oos kayimsina baron ne kiinawa utak aane sholsifawa» yifa kaamaas hepsa barki ya. ");
INSERT INTO jnjl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Es bar dey keeza wolla maktenanneen orfo es erbeesne fa wuzaas geregere wolla den sama oottera hami. ");
INSERT INTO jnjl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Phexiros biina raa'iisi kota «Awutaaso?» yit nibbaassi safarefeen; Qornelewos wosina asuni meya Simonni keyaason sholere danne yeesere keyaasi finynyita yersefeer. ");
INSERT INTO jnjl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Teegere dey «Phexiros» yiste Simon irba sinne feenaas hantanoso?. ");
INSERT INTO jnjl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Phexiros raa'iisi chowanon safaret feen Korto Ayyanaas barik ekka yi: «Ese keez asu neen sholsedifewa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Baassotin tatu wosir sinna boor'a ek hang unoy kabira baassoneen aane hamma.» ");
INSERT INTO jnjl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Phexiros kerere: «Sholsefeti asus tawa. Yaati chowaas aambanso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Baasso dey: «Tii meya taar'oni meyanon ha'sife Qornelewos yistefe barkintu wostera yaaniwa. Bar dey Ayhudni daraas zuuttere barin ulfinsina Ha'ooson dige ma'a asuwa. Neen barki keer teegere ne maketa baron odonak korto Ha'oni wosiyaas barik makewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Phexiros dey es wostere ye asuni meyanon keer gedde irbasire ha'sone dima dey shiiphere ha'si. Hepsinari wono kabire baassoneen ane hami. Iyyophek feese isa isa ayni meya barneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wonotiri wono Kesariya kar'ete. Qornelewos dey basa koonisinnawa tai'so zomobaasinna asin zuutire teegere baassoneen ane oodet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Phexiros keer girifena kabaasik Qornelewos barki tai'sere wochobaasi kaa'ne. ");
INSERT INTO jnjl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Sinuntano Phexiros: «Kabuwa ta dey neyiisimato asuwa» yit kabgi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Phexiros barin wolumsit ane keer girifena kabaasik showo asuni meya zuuttere feeseten bi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Baassok dey ekka yi: «Isa Ayhudni meeni asu oom Aazabni meeni asuneen ane isar sinne foonak wedey keebaasi girunoynamato inno tumaasik aane sholsifa sinnamato nitto teetnitisiknu arsetirwa. Sinuntano ta ooninnu kiin wedey kayim unoynamato Ha'oos taak ammanon makewa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Es bari boor'a taaki wosifeti kabaasik ek hang unoytu kabira yaanwa. Ese awuni boor'a taan teegetimato arunak sholefawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Qornelewos dey ekka yi: «Acheech wonaneen sinak han izgin sa'atiistak keenaassi shiiphefana diinqone isa chaaret yere maama mayo asu yeere sinna yere. ");
INSERT INTO jnjl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ekka dey yi: ‹Qornelewosno! Ha'oos shiiphoneeson odewa. Tukamni meyak imfata imnees safartewa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ese ek Iyyophe wosini meyanon wosira Phexiros yistefe Simoonin teegowa. Bar baarisi tesha fe googo kaa'fe Simonni keer irba sinne diifewa› ");
INSERT INTO jnjl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Estan ta dey geregere neeki wosini meyanon wosingwa. Ne dey yoonesik ma'arontu zagitwa. Ese inno zuuttamniise asik Ha'oos makotak ajajena baron zuutira odonikna Ha'oosi sina zuuttera faaniwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Phexiros dey ekka yit mako ephi: «Futoosik Ha'oos ooninnu aane korifa sinnamato aringwa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sinuntano aaffa daani asunu sinfenak Ha'ooson digefe barinnawa futo sina chowaason zagife asusinna Ha'oos shunarwa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ha'oos Israelni daraasik kaambaason wosubaas artowa. Asu zuuttambaase asi Daam sina Yesusniki kamo nagaason maket yaas Ha'ooswa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yohannisni haphquni chowaason makena wonaastan kabira Galiilan hamma Yuudani daasta kar'a sina wuzason arsedifetiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dey Ha'oos Naaziretki Yesusnin Korto Ayyanak muudnamatonawa hugna barik imnamatona arsedifetiwa. Ha'oos dey barneen ane faana boor'a ma'a wuzason zagitnawa Daabulos ephna baassotin zuutire fatit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yuudani daastanawa Yerusalemni katamaassina bar zagina chowaasik inno zuuttamniise zaalwa. Sinuntano asuni meya barin i'ota suutere worsete. ");
INSERT INTO jnjl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Sinuntano Ha'oos keezsinari wono kitun kabira ammanon bestonak zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ammanon bestenaas dey zeemme Ha'o korina baassoktano dara zuuttambaase asiktawa. Bar kitun kabinanneen orfo barneen ane meere usha inno zaalwa. ");
INSERT INTO jnjl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Han baron zuutira daraasik makonik bar hayewni meyaastanawa kituni meyaastana mangsu kar'anak Ha'oos barin taassinaas bar sinbaason zaala makonik bar innotin ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Barik amanefe bar zuuttambaase sunbaasik boor'ani feeshun uuson ephphetoosonemato raajjuni meya zuuttere zaala maksetewa.» ");
INSERT INTO jnjl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Phexiros es baron makefeen kaambaason ode baasso zuuttambesiise asiista Korto Ayyanaas kere. ");
INSERT INTO jnjl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Phexirosneen ane yeese haarko kuni Ayhudni amanynyini meya Aazabni meyanu Korto Ayyanaason ephphetoosobesiisik diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Aazabni meyak Korto Ayyanaas imtenamato arsetees baasso ooma noonok wolumsefeennawa Ha'ooson galattesefenna odesete boor'awa. Es kabaasik Phexiros: ");
INSERT INTO jnjl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Han asuni meya innoosimato Korto Ayyanaason ephpheteesetewa. Eekan baasso akak haphuktosonoytemato kalnir oonso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Estan Yesus Kiristoosni sunaasik haphuktosonek ajaje. Esseen orfo Phexiros garo wonanon baassoneen ane foonak shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yuudak feese wosini meenawa ayni meena Aazabni meya Ha'oosi kaamanon ephpheteesetemato odesete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Phexiros Yerusalem wolle yeefena kabaasik haarko kunu sholsu sinnamato amanesefe Ayhudni meeni kiristanani meya Phexirosnin: ");
INSERT INTO jnjl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Awuni boor'a haarko kununoy asuni meeni keer girira baassoneen ane muu maadifatarso?» yit wee'esete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Sinuntano Phexiros ekka yit isarba isarbaasik zuuttambaase asin kotte baassok make: ");
INSERT INTO jnjl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Ta Iyyopheni katamaassi Ha'oni shiiphota faana raa'i biin. Es biina raa'iis dey inya yinuni maamane fa wuza acheech fashbaastan oottera den saman ta faana dimaasta keredifeen biin. ");
INSERT INTO jnjl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Es baron kootkira biifana es yinuni maamaasta acheech wochobare yeere kaabare yere wuza buur'uni gonyo, nibbak daasta zayifa testoosewa samaastaki fulifa kasaase asin biin. ");
INSERT INTO jnjl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‹Phexirosno! Kabira han baron shukka muwa› yifa kaama oden. ");
INSERT INTO jnjl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Sinuntano Daamiiso! Taak aafawa sinanawuza; Ta kiina wuza wedey zina wuza noononasi maara aane biyutwa. ");
INSERT INTO jnjl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Hepsa dey: ‹Ha'oos kayma zagina baron ne kiinawa utak aane sholsifawa› yifa kaamaason den saman oden. ");
INSERT INTO jnjl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Es bar dey keeza wolla sinnanneen orfo es maamane fa wuzaas zuuttambaase wolla den sama oottera hami. ");
INSERT INTO jnjl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Es kabaasik Qisariyan keez asu taaki wostere ta faana keyaasi yeesete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Isaronnu ek hang unoy baassoneen hamanak Korto Ayyanaas taak make. Han issun ayni meya dey taneen anetu feesete. Baassoneen ane dey Qornolosni keer girini. ");
INSERT INTO jnjl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Bar dey Ha'oni wosiya barki keer girira yeere feen biinamatonawa ‹Ek Iyyophe asunin wosira Phexiros yistefe Simoonnin teegsuwa, bar dey ");
INSERT INTO jnjl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yeere neenawa ne keer feese asuni meena zuuttere farusone kaama neek makonawa› yit barik makenamato innok make. ");
INSERT INTO jnjl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ta dey makefana kabaasik Korto Ayyanaas zeemma innoosta kerenaasimato baassosta dey kere. ");
INSERT INTO jnjl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Es kabaasik: ‹Yohannis akaktu haphqiwa. Sinuntano nitto Korto Ayyanaktu haphuktotiwa› yit Daamiis makena kaamaason yaadaten. ");
INSERT INTO jnjl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Inno Daamni Yesus Kiristoosnin amanefeni kabaasik Ha'oos innok imna es imaason baassok dey imnanneen eekan Ha'ooson kalak chimnir ta oonso?» ");
INSERT INTO jnjl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Baasso dey es baron odeseteyse ephphe maksone wuza turuksefaat shaakkisete. «Ese Ha'oos Aazabni meya gaddo kaasi wolsonek baassotin zaguni boor'aassin harmiyaason baassok imiwa» uuk Ha'ooson galattesete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Isxifanos shu'ak ichchere kitina kabaasik kar'a shanaasik sikte amanynyini meya Fiinqe, Kophphiros; hamma Ansokiya kar'ana kabaneen hamete. Ha'oosi kaamanon Ayhudni meyatano oom asuni meyak aane maksoto. ");
INSERT INTO jnjl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Sinuntano Koppirosunnawa Kerenanna yeese isa isa amanynyini meya Ansokiya hamefe kabaasik Girikni meyakneen Daam Yesusni ma'a odunon maksete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Daamiis dey hugnabaasik baassotin argasit feer. Showo asuni meya dey amanere Daamiiski wolsete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Yerusalemuk fa betekiristaniis es baron odenayse Barnabasnin Ansokiya wosi. ");
INSERT INTO jnjl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bar dey hamme Ha'oos otumbaason darabaasik aakkak imnamato biinayse gire. Zuuttambesiise tuuma nibak amanere Daamiisik chimme yersonek kiiti. ");
INSERT INTO jnjl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Esiis dey Barnabas Korto Ayyanaknawa amantokna tuumme fe ma'a asu sinna boor'a faadbesi showo asuni meya Daamiiski wolsete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Esseen orfo Barnabas Sawulnin sholonak Terses hami. ");
INSERT INTO jnjl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Dannaayse ek Ansokiya ephphe hami. Hepobesiise isa wogga betekiristaniisneen ane isarik showo asuni meyanon assisete. Es wonaastaneen kabira nawoni meya: «Kiristana» yistere teegtesete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Es kabaasik isa isa raajjuni meya Yerusalemun kabire Ansokiya hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Baasso ganeyaassin isaas: «Agabos» yistefe bar kabire daa zuuttambaase asiissi akama maka sinanamato Korto Ayyanaas maken raaji make. Es bar dey sinnaas Kelawudos Keesarni taato sinna neyaasikwa. ");
INSERT INTO jnjl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Es bari boor'a Ansokiyak feesefe amanynyini meya Yuudak feese ayiisakitonik sinni argasu isa isarbesiise chimetemato waaga kissere baassok imtonak wollere buggisete. ");
INSERT INTO jnjl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Es argasuni waagaason dey Barnabasniknawa Sawulnikna Betekiristaniisi kur'uni meyak wosisete. ");
INSERT INTO jnjl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Es neyaasik Herodis yistefe taatoos isa isa amanynyini meyanon kabgu ephi. ");
INSERT INTO jnjl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yohannisni ay Yaqobnin siifok wortonak zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Es wuzaas Ayhudni meyanon girsinamato biinayse Phexirosnin dey ootire taati. Es bar sinnaas Ayhudni meya kixxani heeboos ulfintona wonaasikitosiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Phexirosnin ootinanneen orfo taatoni keer gedi. Ayhudni faasikani heeboos aatnanneen orfo daraasa sina tai'sunanneen acheech acheech sinfaafe oodonek acheech meya taar'oni meyak aatire imi. ");
INSERT INTO jnjl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Estan Phexiros taatoni keyaassi oodtet feer. Sinuntano betekiristaniis zaggira basa chowaasik Ha'ooski shiiphet faar. ");
INSERT INTO jnjl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Wonotiri wono Herodis Phexirosnin daraasik tai'sunak hoorere feen es waalaasik Phexiros hep shashsharak taatere hep meya taar'oni meeni ganesi kunfer. Oom tasoosakito taatoni keyaasi finynyanon oodet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Es kabaasik Daamiisa wosiya ammanon beste. Taatoni keyaassi dey chaarefaas chaare. Ha'oosi wosiya Phexirosni teshason ta'uk nuskira: «Taptera kabuwa» yi. Es kabaasik shashsharaas kushubaassin zigi. ");
INSERT INTO jnjl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ha'oosi wosiya dey: «Maamneeson mayya chaa'maneeson yer'wa» yi. Phexiros dey Ha'oosi wosiya maktenaasimato zagi. Estan Ha'oosi wosiyaas: «Wor'a maamneeson mayya taneen ane yowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Phexiros dey kesse barneen ane hami. Sinuntano raa'i biidifeenne faar sinnatu barik bestetano Ha'oosi wosiyaas zagina bar amma sinna barik aane bestowa. ");
INSERT INTO jnjl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tesuniisewa hepsani tasoosinna aatere ek katamaassi taamfa bittani gamalaaski kar'ete. Gamalaas dey teetbak gachchen baasso dey kesere isa garo ugnak hamete. Diinqok Ha'oosi wosiya Phexirosnistan oor kessa hami. ");
INSERT INTO jnjl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Phexiros nibbaassi wolle: «Daamiis wosibaason wosire Herodisni kushuussinnawa Ayhud tayista safarena chowaassinna kisinamato hash aringwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Es baro arinanneen orfo showo asuni meya isarik zuuttesere shiiphset feesete Marqos yiste Yohannisni into Maaramini keer hami. ");
INSERT INTO jnjl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Esta kar'e keyaasi gamalanon ki'in Roda yiste isa keeri wostinynya oo sinnamato gasasuk gamalaaski tai'se. ");
INSERT INTO jnjl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Phexirosni kaama sinbaaso araat girabaasi aatamtan kabira gamalaason gachnoy orfo wolla eella: «Phexiros finynyi yerefe» yira make. ");
INSERT INTO jnjl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Asuni meya dey: «Nifasetwe, aakka ekka sinana» yisete. Sinuntano bar futo sinbaaso gasasira make. Baasso wolgire: «Basa wosiyaaswa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Phexiros tusi tusire gamalaason ki'i. Baasso gamalaason gachche biyaat diinqesete. ");
INSERT INTO jnjl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bar shaakkusonek zagaat Daamiis taatoni keerun aakkak barin kisinamato make. Estan: «Ta kesaason Yaqobniknawa ayiisakitonikna makoti» iyaat ooma dima hami. ");
INSERT INTO jnjl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wono e'sotirik meya taar'osakito: «Phexiros ay hamiso» yiset ganebesiissi inya shorko kabi. ");
INSERT INTO jnjl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodis Phexirosnin sholere turkifaat tasoni meyanon tu'nire mamsinanneen orfo wortosonek ajaje. Esseen orfo Herodis Yuudan Qisariya hamme esta di. ");
INSERT INTO jnjl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodis Tiroskinawa Sidonakina fe asuni meyaneen faassere feer. Daabesiis muu danfanaay taatoosa ha'suussin sinna boor'a taatoosa erasho sina Bilastoosnikin argasuni mekama dannanneen orfo isarik taatoosneen ane ganok mamsi. ");
INSERT INTO jnjl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ootte wonaasta Herodis taatoni mayaason mayye taatoni zigimuusta diifaat daraasik wolle. ");
INSERT INTO jnjl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Daraas dey: «Han bar Ha'oni kaamatano asuni kaamatawa» yit chaagete. ");
INSERT INTO jnjl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herodis Ha'oosik ulfina ima beyna boor'a Daamiisa wosiya geregere ichin towak maastere kiti. ");
INSERT INTO jnjl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Sinuntano Ha'oosi kaama dichetnawa tagitna hami. ");
INSERT INTO jnjl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabasnawa Sawulna wostobesiison koi'sire Yerusalemun wolsete. Marqos yistefe Yohannisnin zoonsire yeesete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ansokiya fa betekiristaniissi raajjuni meenawa kaambaasi assinynyana feeseter. Baasso dey Barnabas, kara yistefe Simon, Kerenaki Lukiyos, acheechsa daason ha'sife Herodisni zomo Minahenawa Sawulna feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Es baasso Daamiisik wostetnawa soomere shiiphsetna feeseten Korto Ayyana: «Barnabasnawa Sawulna asin ta teegena wostoosik oor kisuti» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Baasso soomere shiiphsefaat kushubesiison baassosta ta'ire shiiphsetenneen orfo gafuksete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabasnawa Sawulna dey Korto Ayyanaas wosin ek Selewukiya kessete. Estan dey Merkebik Kophphiros kessete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Silmanak feesete kabaasik Ha'oosi kaamanon Ayhudni shiiphoni keyaassi maksete. Yohannis dey baassotin argasit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kophphiros yistefa akak birato daason finere Paafu kar'efe kabaasik Beriyasus yiste isa Ayhudawi sina tolfattunin danete; bar dey eshinynya raajju. ");
INSERT INTO jnjl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Bar dey Sergiyos Phawulos yiste daason ha'sife isa aru asusneen anetu feefe. Es daa ha'sife asus Ha'oni kaama odonak sholere Barnabasninnawa Sawulninna barki teegsi. ");
INSERT INTO jnjl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Sinuntano sunbaasi kota Helmas sina tolfattuus daason ha'sife asus amanonoynamato sholefaat baassotin tugga'e. ");
INSERT INTO jnjl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Phawulos sinfe Sawul Korto Ayyanak tuumme kootki biyaat: ");
INSERT INTO jnjl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Ne ma'a wuzaasi guma! Eshnewa mangune neyissi tuumna Sexanni naa. Zeephto Daamiisa ugnanon elingsuuson aafanoso beyata wuza? ");
INSERT INTO jnjl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Daamiisa kushu neen ke'in aaftishu sinatar. Garo wonniron awuni chaarefa aafa biyatawuza» yi. Geregere ki'nanewa talumne basaasta kere. Kushubaason ephphe zoonsuni asuni sholok ek hang kuti. ");
INSERT INTO jnjl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Daason ha'sife asus sina chowaason biyaat Daamiisa aruno diinqok amane. ");
INSERT INTO jnjl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Phawulosnawa zomobaasakitona Phafun kabsere Pinifiliya fa Pergen hamete. Estan Yohannis baassostan oor kesse wolle Yerusalem hami. ");
INSERT INTO jnjl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Sinuntano baasso Pergenun kabsere Pisidiya fa Ansokiya hamete. Baysani wonaasik Ayhudni shiiphoni keyaassi girsere diisete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Museni tumaasewa raajjuni meeni tichaase ferettenanneen orfo Ayhudni shiiphoni keyaason ha'sife baasso: «Ayni meeno; daraasi merkoni kaama nittoki faafaanane makotiwa» yit wossete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Phawulos daakun kabire kushuni besuk: «Israelni asuni meyane, Ha'ooson digefe nitto zuuttera odotiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Han Israelni daraasa Ha'o abaniisakitonin kori. Giphtsini daasta feeseten dey den teggi. Woribaasi hugnak estan kisi. ");
INSERT INTO jnjl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Acheechasir wogga ichma daassik baassotin faki. ");
INSERT INTO jnjl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kene'aki daasta fa naafun taatoosikitonon tishkaat daabesiison bari daraas warasonak zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Es bar zuuttera acheech tiirewa uuchasire woggaassiktu ko'i. Esseen orfo raajju Samuelniista kar'ananneen ha'suni erashe meyanon imi. ");
INSERT INTO jnjl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Estan daraas taato baassosta taattonak shiiphsete. Ha'oos dey Biniyamni keenaassin Qiisni naa Sawulni imin acheechasir wogga baassotin ha'si. ");
INSERT INTO jnjl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sawulni kessinanneen orfo Dawitnin baassok taassi. Barin dey: ‹Ta nibane feernawa ta sholenaason zuutire zaguni Isseyni naa Dawitnin daningwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ha'o girina teyyaasimato es asusa zaltan fatir sina Yesusnin Israelik teshshe. ");
INSERT INTO jnjl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesus yoonoyfeen zeemma Yohannis Israelni dara zuuttere harmire haphuktosonek makere feer. ");
INSERT INTO jnjl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohannis wosibaason koi'sinaase: ‹Ta oo sinna nittok bestefanso? Ta bartewa. Sinuntano orgobaasi chaa'mani taar'anonnu kotak chimnoynar taneen orfo yoonirwa› yit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Abrahamni zalaassin koonte ay sina nittonawa inno ganeyaassi Ha'ooson digefe baasso zuuttambesiise asik han faruni kaama woste. ");
INSERT INTO jnjl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Sinuntano Yerusalemki asuni meenewa baassotin ha'sife baassotna Yesusnin aane arsoto. Beysa beysani wonaasik ferettefa raajjuni meeni tichaasi kaama ko'unak basaasta mangsu kar'esete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Barin kituta katuni isa mangsune turuksefeknu Pilatos kituni mangsu basaasta kar'anak shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Barik tichche baron zuutire ko'issetenneen orfo mesqelistan kessisere moogaassi kabbarsete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Sinuntano Ha'o barin kitun kabgi. ");
INSERT INTO jnjl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galiilan kabsere Yerusalem kar'ananneen barneen ane yeese baassok showo wona biiste. Baasso dey hash daraasa sina zaalwa. ");
INSERT INTO jnjl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Inno dey Ha'o abani meyak girina teyyani kaamaason nittok makeni. ");
INSERT INTO jnjl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Yesusni kitun kabgubaasik baassok girina teyyani kaamaason naanggotbesi sina innok zagi. Esiis dey hepsa gaamni tichaassi ekka yistera tichchera faar: « ‹Ne taak naatawa; Ta neen hash hawung koonin.› ");
INSERT INTO jnjl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Bar dey aane kuupe sinnamatonawa; Ha'oos kitun kabgubaasonna gasasuk; ‹Korto amanamtera fa eebbaason; Dawitnik girina abdiison nittok imana› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«Esiisimato ooma dimta: « ‹Kortonees kuupanak aafa zagutawuza› yifawa. ");
INSERT INTO jnjl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«Dawit basa neyaasik Ha'oosi safaranon wostenanneen orfo kiti. Ababaasakitoneen kabbarte; ashbaas dey kuupi. ");
INSERT INTO jnjl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Sinuntano Ha'o kitun kabgina bar aane kuupe. ");
INSERT INTO jnjl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Ese aytaasakitono; boor'ni fakiya bestefanaas Yesusniki kamo sinbaas nittok makte baron aruti. Barik amanefe bar zuuttere Museni tumaasik danonoyna ookooson danana. ");
INSERT INTO jnjl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Es bari boor'a raajjuni meyaki kamo: ‹Kanyfe nitto biitiwa; diinqoti, tishuti, oonu nittok makefenak amanonoyti wosto nitto neyaasik wostona› » yisete bar kar'noynamato teetnitiison aruti. ");
INSERT INTO jnjl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Phawulosnawa Barnabasna Ayhudni shiiphoni keyaassin kesefe kabaasik asuni meya es wuzason yooni beysani wonaasik hepsi wolle maksonek shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Zuuttoos boktenanneen orfo showo Ayhudni meenawa amanok baassossi woi'tere Ha'o shiiphsefe asuni meena Phawulosnawa Barnabasna asi orfoose hamete. Basakito dey Ha'oosi otmak chimme foosonek mekama ime. ");
INSERT INTO jnjl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hepsani beysani wonaasik katamaassiki daraasasin arki sinar Ha'oosi kaamanon odok zuuttesete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ayhudni meya akam darani biyeteese koonesete. Phawulosni wollaason tugga'ok me'esete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Sinuntano Phawulosnawa Barnabasna diga foontonon: «Ha'oosi kaama zeemma nittok maktonak sholsuwa. Sinuntano nitto kashshiseti. Dey koi'ba foonto kaa nittok sholsunoynamato teetnitiista mangsu kar'eti boor'a inno Aazabni meyaki hamnirwa. ");
INSERT INTO jnjl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Daamiis kaambaassi: ‹Faruni kaamaason daasi diltaneen katutak Aazabni meyakneen chaarefa zaginwa› yire innotin ajaje» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Aazabni meya es baron odeseteyse girsere Daamiisa kaamak ulfina imesete. Koi'ba foonto kaak hoore baasso zuuttere amanesete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Daamiisa kaama es biratoosta fa daa zuuttambaase asiista zi'i. ");
INSERT INTO jnjl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Sinuntano Ayhudni meya Ha'ooson shiiphok dey ulfinto mashka meyanonnawa katamaassi feese otum asuni meyanonna Phawulosniistanawa Barnabasniistana kabugsere daabesiistan kalle kissete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Phawulosnawa Barnabasna wochobesiistaki tulonon tebaat Iqoniyon hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Amane baasso dey giraknawa Korto Ayyanakna tuumesete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoniyonuk Phawulosnawa Barnabasna hazozotiisimato Ayhudni shiiphoni keyaassi girsere mai'sire maksete boor'a Ayhudniissinnawa Girikniissinna akam showo asu amanesete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Sinuntano amanonoy Ayhudni meya Aazabni meyanon kabugsere ayni meyanon oomtosonek zagsete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Phawulosnawa Barnabasna Daamiisa chowanon diga foontonon makset showo wona Ikoniyon diisete. Daamiis dey maksete Ha'oosi otumni kaamanon biistera artonoy besoknawa diinqi wostokna ammanon besit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Katamaassi fe daraas heppik bagtere isa kunuus Ayhudni meyaneen, isa kunuus dey wosini meyaneen sini. ");
INSERT INTO jnjl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Es kabaasik Aazabni meenawa Ayhudnin ha'sife baassotna isarik sinere wosini meyanon shu'ak ichak sholsete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Baasso es baron arseteese Likoniyani awurajaassi faase Listira, Darbe yistefa katamaasikitosinawa biratobaastana shaatere hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Estak Ha'oosi kaamanon maksete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listirak koontenanneen kutire biinoy wochoba laafa asu feer. ");
INSERT INTO jnjl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Es asus Phawulosni wollaason odedifer. Phawulos kootkire barki biyaat farunak amantoba foobaason araat akama kaamak: ");
INSERT INTO jnjl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","«Kabira wochoneesik yerowa» yin geregere fillere kabire taarire kuti. ");
INSERT INTO jnjl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Daraas Phawulos zagina chowaason biyeteyse Likaoniyawini meeni kaamak: «ha'oosikito asune faar sinna inno ganeyaassi kerewa!» yit chaagete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabasnin dey Diya yisete. Arkiro makedifer Phawulos sinna boor'a Hermen yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Katamaasi gerakalota fa Diyani betemeqdesiisi maag omorunewa taato fur'ane ephphe katamaasi finynyita daraasneen ane baassok maa'a imak shole. ");
INSERT INTO jnjl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wosini meya Barnabasnawa Phawulosna es baron odeseteyse maybesiison karasisere daraasa ganesi eelesete. Kaambesiison teggisere: ");
INSERT INTO jnjl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Nitto han baron awagan ekka zagidifetirinso? Inno nittone fe asuwa. Nitto han foonto wuzaassin kessa samaason, daason, akasewa sir kuni testooson zuutira tesi hayewa Ha'ooski wolutik kaambaason nittok makefeniwa. ");
INSERT INTO jnjl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ha'oos aata neyaassi darani meya zuuttere teetbesiri ugnak hamonek shaakkira beyi. ");
INSERT INTO jnjl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Sinuntano bar zaalbaason makefa ma'a wostooson wosto aane beya; saman iro ichanak zagi; maaraason baassok imi; muuknawa girakna nibbesiison gawusi» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Es baron zuutire maksefeknu akama kaboktu darani meya maa'a baassok imonoytemato kalete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Sinuntano Ayhudni meya Ansokiyannawa Ikoniyonna yeesere daraasin eeshshisere Phawulosnin shu'ak ichosone zagsete. Estan kitiwa iyaat bokosire katamaassin gerakalo kissete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Sinuntano nawoni meya ganeya gedde feeseten kabire katamaassi giri. Wonotirik Barnabasneen ane Derben hami. ");
INSERT INTO jnjl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Phawulosnawa Barnabasna Derbenuk Ha'oosi kaamanon maksere showo asunin amansisetenneen orfo Listiranewa Ikonoyonne asiissi aatte Pisidiya fa Ansokiya hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nawoni meyanon zagguk, Ha'oosik chimme foosonek merkeset: «Ha'oosi taatosi girunik showo shana ephphatoonik sholsifa» yit assisete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Betekiristaniisikitosi kur'uni meyanon korire taassisetenneen orfo soomere shiiphsefaat amanesete Daamiisik adara imete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidiya kamo aatere Pinifiliya yeesete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pergamonuk kaambaason maksetenneen orfo Ataliya kersete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Estak wostesete wostooson Ha'oosi otmak koi'sisere baassok adara ima Ansokiya Merkebik hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hamme kar'e betekiristaniissi fe amanynyi meyanon zuutire Ha'o baassoneen faafaat zagina baron zuuttambaase asinnawa Aazabni meya dey faruni ugna gachchobaason maksete. ");
INSERT INTO jnjl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nawoni meyaneen ane showo wona esta diisete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Isa isa asuni meya Yuudan Ansokiya hamere: «Museni tumaasimato haarko kunu beyfaatine farutik aafa chimati wuza» yiset ayni meyanon assuk jammarsete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Es barik Phawulosnawa Barnabasna baassoneen ane akama chima kirikkiri zagsete. Estan Phawulosnawa Barnabasna Antsokiyak feese oom amanynyini meyaneen sinere Yerusalem hamere es chowaason wosini meyaknawa kur'uni meyakna maksonek zagte. ");
INSERT INTO jnjl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Betekiristaniis ugunbesiisik argasseten Aazabni meeni Ha'oki wolunon makset Feenqenewa Samariyane asiissi aatesete. Ode ayni meya zuuttesere girsete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yerusalem kar'esefe kabaasik betekiristaniis, wosini meenewa kur'uni meene sinne ephete. Baasso dey Ha'o baassoneen sinna wostena wostooson zuutire maksete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ferisawini keenaassin amane baasso isa isaas kabsere: «Aazabni meya haarko kunosoneknawa Museni tumaasi oodonekna zagu sholsuwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Wosini meenewa kur'uni meena es chowaason tu'nusonek zuuttesete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Akamanon karakkarsetenneen orfo Phexiros kabire baassok: «Ayni meyane; Ha'o showo wonaneen sinak nitto ganeyaassin taan korira Aazabni meya Ha'oosi kaamanon taakin odere amanosonek zagubaason arsefetiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Asusa nibanon arifa Ha'oos Korto Ayyananon innok imnaasimato baassok dey imma baassotin ephpha toobaason besi. ");
INSERT INTO jnjl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nibbesiison amantok kaynina boor'a baassotnawa innotna asi ganeyaassi aane dilowa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ese abaniisakitonawa innotna wor'ak chimnoyni waanjooson nawoni meeni ogogta wossuk hash awuni boor'a Ha'ooson shimsidifetirinso? ");
INSERT INTO jnjl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Innonu faruniis baassosimato Daamni Yesusni otmaasik amanokwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Estan daraas zuuttere shaakki. Barnabasnawa Phawulosna Ha'o baassoki kamo Aazabni meeni ganeyasi zagina biistera artonoy diinqi chowaason makseten odesete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Baasso dey maksere koi'sisetenneen orfo Yaqob kabire: «Ayni meyane; ese odotiwa! ");
INSERT INTO jnjl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ha'oos barik teegtoni daranin baasso ganeyaassin korunak tesusta Aazabni meyaki aakkak yaanamato Simon innok makewa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Raajjuni meyaki kamo dey: ");
INSERT INTO jnjl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","« ‹Esseen orfo wolunawa; Bogte Dawitni keyaason wolgira keer'ana; bogtera gande baron dey wolgira yeetuna; Hepsinu dey wolgira keer'ana. ");
INSERT INTO jnjl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Es baron dey zagunaas; Fu'te asuni meenawa; ta sunaasik teegte Aazabni meena; zuuttere ta Daamiisin sholsonekwa; zeemmaneen han bar zuuttera artonak zagiis; ta Daamiiswa› yiste barneen isarwa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Es bari boor'a ta safaraas Ha'ooski woli Aazabni meyanon shimsunoynimatowa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Es baristan ‹koo'loosik maa'a sinna imtok kiina muuson muutiita; gerkesaastan wokti; geetera kiti baron muutiita; hanna muutiita› yira baassok tichunik sholsuwa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ibeneen Museni tumaas beysa beysani wonaasik Ayhudni shiiphoni keyaassi ferettet faar; kaambaas dey katama katamaassina makterwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Esseen orfo wosini meenawa kur'uni meena betekiristanini meyaneen ane sinere ganebesiissin garo asunin korisere Phawulosnawa Barnabasna ane Ansokiya wosusonek buggisete. Ayni meeni ganeyaassi ma'a ha'subaasik arto sina Bersabas yiste Yuudaninnawa Silasninna korisete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tichche tichaason Phawulosniknawa Barnabasnikna wosisete; es bar dey ekka yifar: «Ayni meya; wosini meenawa kur'uni meena Aazabni meeni keenaassin amanere Ansokiyak; Soriyak; Kilqiya feese ayniisakitono! Naga nittok ooshshefeniwa» ");
INSERT INTO jnjl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Isa isa asuni meya inno ajajonoyniron innoossin kesere maksete barik nitto nibaason shoruksetematonawa rakkisisetematona odeniwa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Es bari boor'a isarik zuuttera wolleninneen orfo asuni meyanon korira shunto ayni Barnabasneen Phawulosneen ane nittoki wosuk isar sinni. ");
INSERT INTO jnjl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Barnabasnawa Phawulosna Daamni Yesusni sunaasik kaabesiison aatire ima asuwa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nittok tichiniis baron kaamak kotte maksonek Yuudaninnawa Silasninna wosiniwa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Han sholsu chowaasneen ooma ba'a nittoosta wossunoynimato Korto Ayyanaasewa innotna ma'ar sinnamato biiniwa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Esiis dey koo'loosik imtera kiina muu muutiita; hanna muutiita, geetera kiti waagni asha muutiita, gerkestan wokti; es effatena wuza zuuttambaase asiissin teetnitiison oodatine ma'aron zagitiwa; maar'ongwa. ");
INSERT INTO jnjl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Woste asuni meya dey: «Maar'ongwa» iyaat Ansokiya hamete; kiristanani meyanon isarik zuutire tichaason imete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Baasso dey tichaason ephere feretisetenneen orfo danete ma'a mekamaasik girsete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuudanawa Silasna teetbesiisik raajju sinete boor'a ayni meyanon akamanon merkere zaggisete dey chinisete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Esta garo wona diisetenneen orfo ayni meya «ma'aron hamoti» yiseten wolle baassotin wosi baassoki hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sinuntano Silas esta fui'tonak shole. ");
INSERT INTO jnjl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Phawulosnawa Barnabasna oom showo amanynyi meyaneen Daamiisa kaamanon assitnawa maketna Ansokiya garo wona diisete. ");
INSERT INTO jnjl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Garo wonaneen orfo Phawulos Barnabasni: «Kabin Daamiisa kaamanon makeni makeni katamaassi wolla hamma ayni meyanon mamsuniwa; aakka feesetemato dey biyaniwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas dey Marqos yistefe Yohannis baassoneen ane hamanak shole. ");
INSERT INTO jnjl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Sinuntano Marqos sinak zeemme baassoneen ane wostoosi hama beyfaat Piniphiliyak oor kesse Yerusalem hamna boor'a Phawulos barin ephphe hamak aane sholowe. ");
INSERT INTO jnjl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Estan baassotna baassotna asi ganeyaassi kirikkiri kabin oor oor kesete. Es bari boor'a Barnabas Marqosnin ephphe merkebik Kophiros hami. ");
INSERT INTO jnjl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Sinuntano Phawulos dey Silasnin kori. Ayni meya dey Phawulosnin Daamiisa otmak adara imetenneen orfo hami. ");
INSERT INTO jnjl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Betekiristaniisikitonon chinit Soriyanewa Kilqiyane asiissi kamo aatte hami. ");
INSERT INTO jnjl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Phawulos Derbenawa Listirane sinfa daasta hami. Estak Ximotiyos yiste amanynyi asu feer. Intobaas Ayhudni meeni kiristana. Sinuntano ababaas Girikni daani asu. ");
INSERT INTO jnjl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ximotiyos Listiranewa Iqoniyone asiissi fe ayni meeni ganeyaassi ma'ariktu artefe. ");
INSERT INTO jnjl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Phawulos Ximotiyosnin ephphe barneen ane hamanak sholefaat es biratoosta fe Ayhudni meeni boor'a Ximotiyosnin haarko kunsi. Es baron dey zaginaas esta feese Ayhudni meya zuuttere Ximotiyosni abaas Girikni daani asu sinbaason arsere feeseter sinna boor'a. ");
INSERT INTO jnjl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Baasso dey isa katamaassin kesse ooma katamasi hamefe kabaasik Yerusalemuk feese wosini meenawa kur'uni meena wolumsere aatisete sitiriison amanynyini meyak assiset feeseter. Dey wostota feeshusonek makset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Es bari boor'a Betekiristaniisikito amantobesiisik chimere faadbesiis dey wona wonaasik daytet faar. ");
INSERT INTO jnjl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Phawulosnawa barneen ane fe baassona Iisiyak kaambaason maksonoytemato Korto Ayyanaas kalna boor'a Firgiyanewa Galatiyaniissi kamo aatte hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Miisiyani dilaasta kar'efe kabaasik Bitaniya hamonek kabsete. Sinuntano Yesusni Ayyanaas esta kamo hamonoytemato kali. ");
INSERT INTO jnjl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Es bari boor'a Miisiya kamo aatte Tiroadda kersete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Estan waalin isa Meqedoniyani asu yerefaat: «Hang Meqedoniya finfaat innotin argasuwa» yifeen Phawulos raa'ik bi. ");
INSERT INTO jnjl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Phawulos es raa'ison biinanneen orfo geregere Meqedoniya hamak sholeni. Esiis dey Meqedoniyak feese asuni meyak misirachchuni kaamaason makonik Ha'oos innotin teegene faar sinna bestena boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tiroaddan Merkebisi diira Samotiraqe hamni. Wonotiri wono dey Naaphule hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Estan kabira hamma Filiphisiyus kar'ni. Filiphisiyus dey Meqedoniyani katama sinfaat Romanni ha'suusi sikalosi fa waradani katmawa. Es katamaassi garo wona diini. ");
INSERT INTO jnjl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Beysani wono dey shiiphok zuuttesefe dima katamaasi gerakalota fa wor'a akaasi ha'ta sinnamato safareni boor'a esta hamni. Esta diifaat zuuttesera faase mashkasusikitok Ha'oosi kaamanon makeni. ");
INSERT INTO jnjl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Odet faase mashkasusikitosin Lidiya yiste isa asu faar. Bar dey Ha'ooson shiiphe asu. Tiyatironi katamaassin koonte wantajjini maamni naggadde. Daamiis nibbaason gachna boor'a Phawulos makefena kaamaason gasasira odet faar. ");
INSERT INTO jnjl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Barewa bari keerki baassotna zuuttere haphuktesetenneen orfo: «Daamiisik amanonaason gasasira arsetinneen taaki keer yaara duutiwa» yit chinira shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Isawa shiiphoni dimaasta hamfeni hanneenti sinni wuza wollefa kiina ayyana ephna keeri wostinynya sina isa durba nawa innok uphe. Bar dey tolfatbaasik baron ha'sife baassok akama waaga danonek zagit faar. ");
INSERT INTO jnjl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Bar Phawulosnawa innotna asi orfoose yaafaafa: «Han baasso faruni ugnaason nittok makset feese zuuttambaase asi denalo sina Ha'oosi wostinynyani meyawa!» yit chaaget faar. ");
INSERT INTO jnjl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Es baron dey showo wona zagi. Sinuntano Phawulos haarere yerqere kiina ayyanaason: «Yesus Kiristoosni sunaasik barissin kesatak ajajefan!» yi. Kiina ayyanaas dey es kabaasik kesi. ");
INSERT INTO jnjl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Baron ha'sife baasso buu'a danefe abdibesiis kessa hambaason biyeteyse Phawulosninnawa Silasninna ephete. Zatte dey yaboosta taamme gaannye meeni sina tai'sisete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Roomani daason ha'sisefe baassoki tai'sire ekka yisete: «Han baasso Ayhud meeni keengwa! Katamaniison dey naga turuksisete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Inno Roomki asu ephphatoonik wedey zagunik sholsunoy sitiriisontu maksefe.» ");
INSERT INTO jnjl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Daraas dey isarik Phawulosnawa Silasna asiista kabsete. Daa ha'sisefe baasso dey maybesiison gaa'ere haarok ichosonek ajajesete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Akamanon ichesetenneen orfo taatoni keer gedesete. Tasoos mai'sire oodanak ajajesete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tasoos dey es ajajiison ephnanneen orfo taatoni keyaasi keerkalo fa keyaasi bagtosi gedde wochobesiison ginosi gedde sippe taar'i. ");
INSERT INTO jnjl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Wassi daani kixxek Phawulosnawa Silasna shiiphoknawa gaamakna Ha'ooson galatteset feeseter. Es kabaasik oom taatoni meya dey baassotin odesedifer. ");
INSERT INTO jnjl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Diinqone taatoni keyaasi kapta shorkonanneen akama daani shorko sini. Taatoni keyaasi gamala zuuttera gachche. Taatoni meeni shahsaraas dey baak kotte. ");
INSERT INTO jnjl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tasoos afay'nitan guzire taatoni keyaasi gamala gachchobaason biinayse taatoni meya aatte kesetenne faar sinna barik bestefaan bar barin wolgire worunak sikobason bokosire kisi. ");
INSERT INTO jnjl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Sinuntano Pawwulos kaambaason teggire chaagge: «Inno zuuttamniise hantatu faaniwa, ne neyista mangu wuza zagutaatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tasoos tona ephphe yoosonek teegere eelle keerkalo giri. Korkit dey Phawulosnawa Silasna asi wochoossi gandere sagade. ");
INSERT INTO jnjl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Baassotin gero kisaat: «Daamni meyane! Farunak awu zagunak sholsifaso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Baasso dey: «Daam Yesusnik amanowa; neenawa neeki keerki asuni meena farsonewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Estan Daamiisa kaamanon bariknawa barki keer feese baasso zuuttambesiise asikna maksete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Es sa'atiistak tasoos wassi Phawulosnawa Silasna asin ephphe taamme mazabesiison masi. Geregere dey barnawa barki keer feese baassotna zuuttere haphuktesete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Esseen orfo Taatoni keyaason tasoos Phawulosninnawa Silasninna keeba ephphe taamme muu maasi. Ha'ooson amanena boor'a basa keerki asuni meyaneen zuuttere giresete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wonfana kabaasik daason ha'sife baasso: «Taatoni meyanon kotta gafkutiwa» yit baasso polisinin wossete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tasoos bar dey: «Daason ha'sife baasso kottotik polisinin wosisete sinna boor'a kessa nagak hamtiwa» yit Phawulosnik make. ");
INSERT INTO jnjl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Sinuntano Phawulos: «Inno Roomki asu sinna faani daraasa sinak mangsu kar'ba foontonon yaboosta ichere innotin taatoni keer gedete. Hash dey aachok innotin taatoni keerun kisuk sholsefeso? Es bar aafawa sinanawuza baasso yeesere innotin kotte kissotowa!» yit wolgi. ");
INSERT INTO jnjl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Polisini meya es kaamaason daason ha'sife baassok maksete. Daason ha'sife baasso Phawulosnawa Silasna Roomki asu sinobesiison arseteyse digsete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yeesere dey mangsini yisere taatoni keerun baassotin kissete; katamaassin dey kesse hamonek shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Phawulosnawa Silasna taatoni keerun kesere Lidiyani keer hamete. Estak hamme ayni meyanon danere chinisefaat katamaason gafkire kesse hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Phawulosnawa Silasna Anfipholiyanewa Apholoniyane asiissi kamo aatte Teselonqe hamete. Estak Ayhudni shiiphoni keya faar. ");
INSERT INTO jnjl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Phawulos hazozoti zagifenaasimato Ayhudni shiiphoni keyaassi giri. Keez beysani wona sinniron korto matsafaassin kisaafe daraasik kotte maket feer. ");
INSERT INTO jnjl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kiristoos shanaason ephphetoonaknawa kitun kabunak sholsu sinnamato kotte maket: «Han ta nittok makefana Yesus bar kiristooswa» yit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Estan Ayhudniissin isa isaas kaambaason odesere Phawulosneen Silasneen ane isar sinete. Faadbesi akam showo Ha'ooson shiiphsefe Aazabni meenawa showo arto mashka meene kaambaason odesere baassoneen ane isar sinete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Sinuntano Ayhudni meya koonesere naga tishkuni wostobesi foonto asuni meyanon zuutire baassosta kabugsete. Katamaassi dey naga tishunak zagsete. Phawulosnawa Silasna asin daraasik aatire imak Iyyasonni keyaason kephire zuuttesete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Sinuntano baassotin aane danoto sinna boor'a Iyyasonnawa ayni meyaassin isa isaasin zatte katamaassi fe gaanynye meeni sina taamefaat: «Han asuni meya han daason zuutire naga turksi; hash dey hanta yeesetewa. ");
INSERT INTO jnjl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Iyyason dey baassotin ephphetewa: ‹Yesus yiste oom taato feerwa› yisefaafe Keesarni ajajiison tugga'sedifewa» ");
INSERT INTO jnjl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Daraasnawa katamaason ha'sife baassotna es baron odeseteyse shapharesete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Estan Iyyasoninnawa oom meyanonna waasi teegsonek zagsere gafuksete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ayni meya geregere Phawulosnawa Silasna waalin Beriya hamonek zagsete. Esta kar'eteyse dey Ayhudni shiiphoni keyaassi girsete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beriyak fe asuni meya Teselonqeki asuni meyaastan ma'a yaadatbesi faar sinna boor'a kaambaason ma'arik ephpheteesete. Es kaamaas futo sinbaason arsere wonna wonna korto matsafaason ferere biyet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Es bari boor'a baassossin showoos amanesete. Dey showo Girikni daani otumba faana mashka meenewa arqa meena amanesete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Sinuntano Teselonqek feese Ayhudni meya Phawulos Ha'oosi kaamanon Beriyak makenamato arseteyse esta hamere daraasin manguk kabgire faasso kabugsete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Es kabaasik ayni meya geregere Phawulosnin ek baarisi tesha hamanak zagsete. Sinuntano Silasnawa Ximotiyosna Beriyak fu'tesete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Phawulosnin ephphe kesa baasso dey barin Atena katisete. Estan Silasnawa Ximotiyosna taptere taaki yoosotowa yifa Phawulosni ajajiison ephphe Beriya wolsete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Phawulos Atenak Silasninnawa Ximotiyosninna oodfeen katamaassi koo'lo tuuma feen biyaat ayyanabaasik haare. ");
INSERT INTO jnjl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Es bari boor'a Ayhudni shiiphoni keyaassin Ayhudni meyaneennawa Ha'ooson shiiphsefe asuni meyaneenna gabaasta wonna wonna danfena asusakitonen we'nit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ephikoros yistefe baassonawa Istokos yistefe baassotna barki yeesefaafe we'nit feeseter. Isa isa meya: «Han sinnoy wolla wollefe bar awunak sholefeso?» yiseten oomni meya dey: «Gaddo koo'loosi chowanontu makefewa» yit feeseter. Es baron dey makesetees Phawulos Yesusninnawa kitun kabuni odusonna makena boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Es bari boor'a Phawulosnin Ariyosfagos yiste dimaasta zuuttera fa shonggosta ephphe hamfaat ekka yisete: «Han ne makefata gaddo assus awu sinnamato arunik innok makowa? ");
INSERT INTO jnjl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Isa isa gaddo gaddo wuza neekin inno odeni sinna boor'a es bar awu sinnamato arunik sholefeniwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Es baron yise Atenaki asuni meenawa Atenak feese irbani meena gaddo gaddo wuza woloknawa odokna wonbesiison aatu shuneseter. ");
INSERT INTO jnjl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Es kabaasik Phawulos Ariyosfagosuk zuuttera fa shonggosi ganesi yerefaat ekka yi: «Han Atenaki asuni meyane! Nitto showo hugnak haymanotintison zaggira ephefetimato biingwa. ");
INSERT INTO jnjl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nitto katamaassi biratefat Ha'o shiiphefeti dimaason biifana kabaasik: ‹Artonoy Ha'ok› yistera tichchera faana shoo'ason daningwa. Ese ta nittok makonaas es arunoy shiiphefeti Ha'oosongwa. ");
INSERT INTO jnjl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Es bar han daasewa han daasta fa testo zuuttambaase asin zuutira tesiis samaasewa daase asi Daamawa. Bar asuni kushu keer'na betemeqdesiisi aane faafawa. ");
INSERT INTO jnjl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kaasonnawa katfeni baronna dey ooma wuzasikitononu zuutira asunik imniis bar sinna boor'a isa wuzane barkin aane yo'ifawa. Asuni argasu dey barik aane sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Neebesiisonnawa foosone daasi dilanonna dilera imi. Asuni zalaason zuutira isa asunikintu tesi. Han daa zuuttambaase asiista dey foosonek zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Es baron zaginaas dey asuni meya Ha'ooson sholere tu'nire awuzakne baron danak chimonekwa. Sinfanaknu bar isarni isarniisatan wokatawa. ");
INSERT INTO jnjl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","« ‹Kaa danniis; shorkera kutifeniis; dey faafeni foosnu barikwa› Esiis dey; Nittoossin gaama arsefe nitto aruni meya ‹Inno zuuttamniise Ha'oosi naanggotawa› yiseteysimatowa. ");
INSERT INTO jnjl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«Ese inno Ha'oni naanggota sinninneen bar asuni techmaknawa warqekna, birrik, wedey shu'ak wosuste gito zagira safaronik aane sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ese Ha'oos asuni meya zeemoti daagni neyaasik zagsete baron baak aatira hash daadaassi fe asu zuuttere harmusonek ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bar korina asuski kamo han daa zuuttambaase asiista futok mangsu kar'ana wona duusi. Es baron besinaas es korina asusin kitun kabubaasikwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","«Kitun kabu» yifa kaamaason odeseteyse isa isaas kanyesete. Sinuntano oomiis: «Han chowaason hepsa neekin odonik sholefeniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Esseen orfo Phawulos baasso ganeyaassin kesse hami. ");
INSERT INTO jnjl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Sinuntano isa isa asuni meya Phawulos makena chowaason ephpheteere amanesete. Amane baassossin Ariyosfagosni shonggota diisefe baasso Diyonasyus yiste asunawa Demaris yiste isa mashkasune dey oom asuni meya feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Esseen orfo Phawulos Atenan kabire Qoronxos hami. ");
INSERT INTO jnjl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Estak Phantoski asu sina aqila yiste isa Ayhudni meeni asunin dani. Bar dey: «Ayhud zuuttere Roomun keso» yit Roomki taate meeni taato Qelawudos ajajena boor'a asuba Phirisqilaneen Ixaliyan yeenaas ta'a wonawa. Es bari boor'a Phawulos baassotin hamme wol ari. ");
INSERT INTO jnjl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Bar dey baassosimato durkani zoorir sinna boor'a baassoneen ane diifaat wostet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Beysani beysani wonaasik Ayhudni shiiphoni keyaassi hamfaafe Ayhudni meyaknawa Girikni meyakna amanosonek kabet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silasnawa Ximotiyosna Meqedoniyan yeesefe kabaasik Phawulos: «Yesus bar Kiristooswa» yit Ayhudni meyak mai'sire zaala maket wonaasikitonon aatit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Sinuntano Ayhudni meya barin tugga'esere me'esefe kabaasik maambaasi tulonon tebire: «Ese nitto hannaas teetnitistawa; ta aafa mamustonawuza. Hanneen ekalo Aazabni meyakitu hamanawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Estan kesse Tiitos Iyyosixos yiste asuni keer hami. Es asus Ha'ooson shiiphet feer. Keebaas dey Ayhudni shiiphoni keyaasi tesha. ");
INSERT INTO jnjl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Qersiphos yiste Ayhudni shiiphoni keyaasi gaanynya dey barki keerki meyaneen zuuttere Daamiisin amanesete. Showo Qoronxoski asuni meya dey Phawulos makefeen odesere amanere haphuktesete. ");
INSERT INTO jnjl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Daamiis dey waalin Phawulosnin raa'ik uphere ekka yi: «Digotaatawa! Makowa! Dey shaakutaata! ");
INSERT INTO jnjl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ta neneen anetu fawungwa. Han katamaassi showo asuta feerwa. Oonu sinfaanane neyista isa miir'oni wuza katuk aafa chimanawuza.» ");
INSERT INTO jnjl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Estan Phawulos Ha'oosi kaamanon assit isa wogganewa issun assane esta di. ");
INSERT INTO jnjl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gaaliyos Akayanon ha'sunak taatefena kabaasik Ayhudni meya isar sinere Phawulosniista kabsete. Phawulosnin ephphe mangsu katefana shonggosta taamefaat: ");
INSERT INTO jnjl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«Han asus tumaason tugga'oni hugnak asuni meya Ha'ooson shiiphsonek zagit feerwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Phawulos wolguba makonak hoorefena kabaasik Gaaliyos Ayhudni mayak ekka yi: «Nitto Ayhudni keen sina meyane! Nittoosta miir'a wedey faya mangsu zagte sinfaanane malatnitiison nibira odona kabawa. ");
INSERT INTO jnjl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Sinuntano merketi kaamnitiisiknawa, sunnitiisikna dey tumantiisiknatu malatedifeti sinnanneen teetnitiisi girowa. Ta han barissi girira mangsu kar'anak aane sholefatwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ekka yire mangsuni kar'ni shongostan baassotin kisi. ");
INSERT INTO jnjl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Es kabaasik asu zuuttere Ayhudni shiiphoni keyaasi gaanynya sina Soostensenin ephphe shonggosta ichesete. Es bar zuuttera sinfana kabaasik Gaaliyos aane kalle shaakkire bi. ");
INSERT INTO jnjl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Phawulos showo wona Qoronxosuk ayni meyaneen diinanneen orfo: «Maar'on» iyaat merkebisi diire Soriya hami. Phirisqillanawa Aqilane dey barneen ane feeseter. Phawulos gibaba faana boor'a Kinkiriiya yiste dimaasta sombaason fiitte. ");
INSERT INTO jnjl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efeson kar'efe kabaasik Phirisqillaninnawa Aqilanonna esta foosonek zagi. Sinuntano bar Ayhudni shiiphoni keyaassi girire Ayhudni meyaneen wollet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Showo wona baassoneen ane foonak sholseten bar aane ma'i uwe. ");
INSERT INTO jnjl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Sinuntano bar: «Ha'o iyaanane hepsa wolla yoona» iyaat Efesonun kesse merkebisi diire hami. ");
INSERT INTO jnjl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Qisariya kar'faat Yerusalem hamme amanynyini meyanon naga ooshshefaat yeet wolle Ansokiya kere. ");
INSERT INTO jnjl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ansokiyak garo wona di. Esseen orfo kabire Galatiyanewa Firgiyane asiissi kutifaafe amanynyini meyanon chimonek zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Koontoba Iskindiriyakir sinna Aphphilos yiste Ayhudni daani asu Efeson ye. Bar dey Korto matsafaason mai'sire aru; dey ma'a wolumni aruba feena asu. ");
INSERT INTO jnjl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Es asus Daamiisa ugnanon mai'sire assit dey Ayyanaasik kiichchet Yesusni chowaason maket feer. Sinuntano bar arifenaas Yohannisni haphquson koi'bawa ");
INSERT INTO jnjl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Bar digaba foontonon Ayhudni shiiphoni keyaassi kotte mako ephi. Sinuntano Phiriskillanawa aqilane odeseteyse keebesi ephphe taamme Ha'oosi ugnanon mai'sire kotte barik maksete. ");
INSERT INTO jnjl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aphphilos Akaya hamanak safarefena kabaasik ayni meya dey es basa safaraason chinisere Akayak fe ayni meya ma'arik barin ephphetoosonek ticha tichire imete. Esta hamme Ha'oosi otmak amanynyi sinne fe baassotin akamanon argasi. ");
INSERT INTO jnjl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Yesus bar Kiristoos sinbaason korto matsafasin kisire makefaafe akama we'nuk Ayhudni meyanon makere meret feer. ");
INSERT INTO jnjl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aphphilos Qoronxosuk feena kabaasik Phawulos tukaki daasta kamo aatte Efeson hamme kar'i. Estak faadbesi garo amanynyini meyanon danne: ");
INSERT INTO jnjl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«Amanefeti kabaasik Korto Ayyanaason ephpha taasetiyoso?» yit mamsi. Baasso dey: «Aane ephphatoweniwa. Korto Ayyanaas foobaasonnu aane odoweniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Phawulos dey: «Eekan aro haphuqtonson haphuqtetiri?» yi. Baasso dey: «Yohannisni haphuqtosongwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Phawulos dey: «Yohannisni haphquus boor'ni harminirwa. Daraasik dey makenaas: ‹Ta orfoose yooni barik amanoti› yit feer. Es bar dey Yesuswa!» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Es baron odeseteyse Daam Yesusni sunaasik haphuktesete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Phawulos kushubaason baassosta ta'ifena kabaasik Korto Ayyanaas baassosta keren gaddo noono wolumsesete. Raaji dey mako ephesete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Es asuni meeni faadaas dey asire heppe sinana. ");
INSERT INTO jnjl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Phawulos Ayhudni shiiphoni keyaassi hamme keez assa sinniron digaba foontonon Ha'oosi taatoni chowanon maketnawa assitna feer. ");
INSERT INTO jnjl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Sinuntano isa isa meya nibbesiison kalere Daamiisa ugnanon daraasa sina me'et aafawa amanoniwuza yisefe kabaasik baassostan woki. Amanynyi meyanon dey baasso baassotin oor kisire Xiranosni keerki assuni keyaassi wonna wonna assit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Phawulos es baron zaginaas hep wogga sinana. Es kabaasik Iisiyak feese Ayhudni meenawa Aazabni meena zuuttere Daamiisa kaamanon odosonek chimesete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ha'oos Phawulosniki kamo akama biistera artonoy wuza zagit faar. ");
INSERT INTO jnjl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Atubaas ta'ina maamaasewa kushuni marabibaase asin ephphe taamme mettanni meyaasta kunusseten mettanni meya merobesiissin farit feeseter. Kiina ayyanaas dey asusasin keset faar. ");
INSERT INTO jnjl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kiina ayyanaason asusasin kisset kutise isa isa Ayhudni meya: «Phawulos makefena Daam Yesusni sunaasik nittotin ajajefeni» uuk kiina ayyanaason asusasin kisuk kabet feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ayhud sina maagni gaanynyaasasin isa Asqewani naafun naanggotiis dey esiisimato zagset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Sinuntano kiina ayyanaas wolgira: «Yesusnin arifan; Phawulosnin chowaason arifan; nitto oonso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kiina ayyanaas ephna asus dey fillere baassotin ephphe baassosta chimi dey mere. Mazayerenawa atatuna keerun eelle kesete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Es wuzaas dey Efesonuk feese Ayhudnawa Aazabni meena asik artena boor'a zuuttambesiise digesete. Daam Yesusni sunaas akamanon ulfinto sini. ");
INSERT INTO jnjl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Amane baassossin dey showo asu mangu wostobesiison ammanon kisire harmifaafe yeeset feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Showo tolfattuni meya dey tolfatni matsafabesiison zuutire dara zuuttambesiise asi sina kiichisete. Es tolfatni matsafaasi waaga dey gammatten uuchasir kuma shu'ni birri sini. ");
INSERT INTO jnjl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Esiisimato Daamiisa kaama akama hugnak tagitnawa meretna hami. ");
INSERT INTO jnjl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Es bar zuuttera sinnanneen orfo Phawulos Meqedoniyanewa Akayane asiissi aatte Yerusalem hamanak ayyanabaassi safarefaat: «Esta kar'etenneen orfo Rooma hamaktu sholsuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Estan barin argassefe baassossin heppin Ximotiyosnawa Erasixosninna asin Meqedoniya wosaat bar teetbaasik garo wona Iisiyak di. ");
INSERT INTO jnjl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Es kabaasik Daamiisa uguntan kabi chowa Efesonuk naga tishi. ");
INSERT INTO jnjl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dimexiros yiste birri wuukife asus Arxemisni Betemeqdesiisi gito birrik wostefaafe birri wuukife baassok akama buu'a danonek zagit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Es bari boor'a es asus birri wuukife baassotinnawa basasne fa wostobesi faana baassotinna isa dima zuutire ekka yi: «Asuni meyane! Inno otma danfeniis han wostoosik sinnamato arifetiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Han Phawulos: ‹Kushuk wosuste gitoos bar Ha'otawa› yi Efesonuk koi'ba sinnoynaron garo daatu fu'tetano Iisiyanon zuuttambaase asin showo daranin assinamatonawa amanosonek zaginamatona nitto biiti dey odetiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Es effatena ugnaasik inno wostoos kashisterwa. Es bar koi'ba sinnoynaron Iisiyanewa daa zuuttambaase asiissi fe asu zuuttere shiiphefena arki ha'o arxemisni betemeqdesiis ke'inor sinna fu'tobawa. Bari arkittoos dey shaarterwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Asuni meya dey es baron odeseteyse gi'tesere: «Efesonki arxemis arkittowa» yit chaagesete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Katamaas zuuttera naga turki. Meqedoniyaki asuni meya dey hep Phawulosni zomo sina Gayiyosnawa Aristirokosna asin zatere daraasa zuuttoni dimaasta eelete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Phawulos daraasa zuuttota hamanak sholet feer. Sinuntano nawoni meya kalesete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Iisiyani daason ha'sife basa zomo sina baassossin isa isaas Phawulosniki aachok asunin wosire: «Daraasa zuuttoni dimta hamma ammanon kessa bestotatawa» yit shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Daraasa ganesi akama buuncho kabina boor'a arki sinaas awuniron zuuttenamato aane aruwe. Es bari boor'a isaas isa wuza oomiis dey ooma wuza maket chaaget feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayhudni meyaassin Iskindir yiste asusin tugire teshsho daraasa sina yeetisete. Daraasa ganesin isa isaas mai'sire we'nunak chinire kiitisete. Bar dey daraas shaakkunak kushubaasik besire baassok wollonak hoore. ");
INSERT INTO jnjl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Sinuntano bar Ayhudni meeni keen sinbaason arseteyse zuuttere isa kaamak: «Efesonki arxemis arkittowa» yit hep sa'ati sinniron chaagesete. ");
INSERT INTO jnjl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Koi'baastak katamaasi ha'suni tichaason tichife bar daraas shaakkunak zagaat: «Nitto Efesonni asuni meyane! Efesonni katamaassi fe daraas arkitto arxemisni betemeqdesiisewa saman kere inya shu'aase asin oodfenamato asu zuuttambaase asik artowa. ");
INSERT INTO jnjl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Es baron mormonir oonu aafe sinna boor'a shaakkutiknawa taptera isa mangu wuza zagunoytimato teetnitiison oodatik sholsuwa. ");
INSERT INTO jnjl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Betemeqdesiison bo'oknawa ha'oniison mei'noy asuni meyanon ephpha hanta yaasetiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dimexirosnawa barneen ane feese birri wuukife baassotna malatosone asu feefaanane mangsu katona wonaas faarwa. Daason ha'sife baasso feeseter sinna boor'a estak malassotowa. ");
INSERT INTO jnjl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ooma sholefei wuza faafaanane tumaasi shonggoni zuuttota biistonawa. ");
INSERT INTO jnjl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Haniistan ooma hawungti zagseti wuzaas: ‹Faasso kabgiwa› yistera mamustonoynimato digeniwa. Wedey ‹Han kabi faassoos awuni boor'a kabiso?› yistera mamustefaanine wolguni malsi aafawa.» ");
INSERT INTO jnjl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Es baron makefaat zuuttere fe daraasin boktosonek zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nagani tishuus koochenanneen orfo Phawulos amanynyini meyanon isarik zuutire kiitire chinaat: «Maar'on duuti» iyaat baassostan oor kesse Meqedoniya hami. ");
INSERT INTO jnjl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Es aatfena dima dimaassi amanynyini meyanon showo kiito kiitire chininanneen orfo Girikni daa hami. ");
INSERT INTO jnjl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Esta keez assa diinanneen orfo merkebi diire Soriya hamanak safare. Sinuntano Ayhudni meya basaasta chowa sholsetemato arinaayse Meqedoniya kamo wolle yoonak hoorere kabi. ");
INSERT INTO jnjl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Payirosni naa Beriyaki Susiphaxiros Teselonqeki Aristirokosnawa Sikondusna Derbenki Gayiyos, Ximotiyos, Iisiyaki Tikiqosnawa Trofemosna ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Es baasso sina zeemme hamefaat Xiroaddak innotin oodesete. ");
INSERT INTO jnjl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Sinuntano inno kixxani heeboos aatnanneen orfo Filiphisiyusun merkebi diira uuch wonak baasso feesete Xiroadda kar'a esta naafun wona diini. ");
INSERT INTO jnjl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Guddani wono isarik Daamiisa meeta'unon muunik zuuttera diifeni kabaasik Phawulos wonotirik hamanak sholsu sinna boor'a baassoneen wollet feer. Wassi daani kixxe kar'ananeen wolumbaason dichi. ");
INSERT INTO jnjl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Inno zuuttera faani fooqiissi showo tona faar. ");
INSERT INTO jnjl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Awuxekis yiste isa na'o naa maskotiista diifer, Phawulos wolumbaason dichina boor'a es na'o naasin akama afay' ephaan fooqiistan gande. Asuni meya dey kitire kunfeen kabugsete. ");
INSERT INTO jnjl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Sinuntano Phawulos kerere naasin mugire idimfaat: «Kaaba faarwa digotiitawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Phawulos wolle den fooqiista kesse amanynyini meyaneen Daamiisa meeta'unon batte me. Wonana kabaneen asuni meyaneen wollenanneen orfo kabire hami. ");
INSERT INTO jnjl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Asuni meya dey fari naasin ephphe keer hamete. Es barik dey akamanon giresete. ");
INSERT INTO jnjl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Inno Phawulosnin merkebisi duusunik sholeni boor'a zeemma merkebi diira Aason hamni. Es baron dey zaginiis Phawulos wochok hamanak sholena boor'a. ");
INSERT INTO jnjl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aasonuk uphefeni kabaasik merkebisi duunak zagira Mixilini barneen ane hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wonotiri wono kabira merkebisi diira Kiyyuni sinaasta fa dimaasta kar'ni. Wonotir wono Samoon finna wonotiri wono Milixi kar'ni. ");
INSERT INTO jnjl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Phawulos Iisiyak showo wona duuk aane sholowe sinna boor'a Efeson shaatonoy aatte hami. Es baron zaginaas Penxekosteni heeboosik Yerusalem hamme aatunak sholet feer sinna boor'a. ");
INSERT INTO jnjl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Phawulos milixinun asunin Efeson wosire betekiristanini kur'uni meyanon teegsi. ");
INSERT INTO jnjl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Barki yeeseten ekka yi: «Han Iisiya yaana wonaneen wonna wonna nittoneen ane aakkak aatinamato nitto teetnitiisik arifetiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ayhudni meeni chowni sholostan kabi chowa shana tayista katisefeknu futoni garamaknawa harafakna Daamiisik wostet faanarwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Yaboosta sinun nitto keenti keentiissi nittok sholsifayson zuutiratu assintano isa wuzane makonoy aane fu'otwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ayhudni meenawa Aazabni meena boor'besiison harmire Ha'ooski wolsoneknawa Daamni Yesusnin amanosonekna mai'sira baassok makengwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Hashnu ta esta hamfana kabaasik awu tayista kar'nitto arunoy Korto Ayyanak ajachchera Yerusalem hamnarwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Sinuntano katama katamaassi taatonewa rakkone tayista kar'ana baron Korto Ayyanaas taak makewa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ha'oosi otumni misirachchuni kaamanon makonak Daam Yesusnikin ephna barik wostoni giddiison koi'sanane kaanaas taak ke'nir yira aafawa faaduna wuza. ");
INSERT INTO jnjl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Hash hawungneen kar'a nitto ganeyaassi kutifaafa Ha'oosi taatoni kaamanon makettu fawungwa. Sinuntano hanneen ekalok oonu taan aafa biyana wuza sinnamato arifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Es bari boor'a nittoossin isar tishifenaknu ta aafa mamustonawuza yit hash hawungti wonaasta nittok makefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ha'oosi fiqadinon zuutiratu nittok makentano isa fu'ena wuza aafawa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nittotin betekiristanini kur'u zagira Korto Ayyanaas kori. Ese nitto teetasiknawa keemfeti wodoosikna teetnitiison arutiwa. Ha'oos bari naasa hannak waagena betekiristaniison mai'sira oodtiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ta hamnanneen orfo wodoosik kenashtonoy keena budu iririkasne fe asuni meya yoosonemato arifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Esiisimato isa isa asuni meya nitto ganeyasin kabsere elinga assu assire amanynyini meyanon baassoki wolgusonerwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Es bari boor'a isa isarnitiisik keez wogga toonewa waalinne arafnaason wuukit nittotin kiitinamato yaadatefaat guzuti. ");
INSERT INTO jnjl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Hashnu kortoni meyaneen ane risti nittok imanak chimni Ha'oosiknawa otumbaasi kaamak nittotin chinira yeetuni barik nittotin aatira adara imingwa. ");
INSERT INTO jnjl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ta ookinnu birri, warqe wedey maama ephphatoonak aane fantot. ");
INSERT INTO jnjl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kushunaasik wosto wostefaat taaknawa taneen fe zoomotaasakitoninna argasit faanamato nitto aridifeti. ");
INSERT INTO jnjl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‹Ephpheteesefe basaastan imfe bar suustowa› yifa Daam Yesusni kaamanon safarok kushuniisik wostet hopini meyanon argasunik sholsu sinnamato showo ugnak nittok besifawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Es baron iyaat kaa'nere baassoneen shiiphe. ");
INSERT INTO jnjl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Zuuttere akamanon waassere Phawulosnin idimme daamesete. ");
INSERT INTO jnjl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Arkiron suumosonek zagiis «Hanneen ekalo taan aafa biyati wuza» yina boor'a. Estan merkebi diistefana dimaasta zoonsire geggesisete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Baassostan oor kesse hamninneen orfo merkebisi diira Qos yiste dimta hamni; Wonotirik Ruud yiste dimta hamni; Estan Paxira yistefa katamasi hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Estan Fiinqe sinfa daa hamma merkebi danna barissi diira hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kophirosnon alda teshniista biyaat Soriya hamma Merkebiis wor'na ba'aason kessifana Xiroski wodebiiski hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Estak amanynyini meyanon sholera danna naafun wona diini. Baasso dey Korto Ayyanak tuntesere Pawulonin: «Yerusalem hamataatawa» yit makesete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Estak fooni wonaas ko'ubaase amanynyini meyaastan oor kessa ugunniison hamni. Zuuttambesiise asubesiiseneen naanggotbesiseneen kesere katamaasi gerakalo kar'ananeen innotin geggesisete. Baarisi tesha kaa'nera baassoneen ane shiipheni. ");
INSERT INTO jnjl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Estan baassotin maar'on iyaat Inno merkebiissi girira diini. Baasso dey wolle keebesi hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Inno Xirosun kabira Pentelemayis kar'ni. Estak amanynyini meyaneen uphera naga ooshshefaat baassoneen ane isa wona feeshni. ");
INSERT INTO jnjl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wonotiri wono estan kessa Qisariya hamni. Estak naafun daaqonynyisasin isar sinna Filiphoos yistefe wongelawiisa keer girira barneen ane diini. ");
INSERT INTO jnjl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Barki keer raaji maksefa acheech durba naanggotba faaser. ");
INSERT INTO jnjl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Showo wona esta diifeni Agabos yiste raajju Yuudan innoki ye. ");
INSERT INTO jnjl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Es raajjuus innoki yeere Phawulosni talfaason ephphe basa teetni kushusonnawa wochoosonna taar'aat: «Korto Ayyanaas han talfaasi abanin Yerusalemuk feese Ayhudni meya haniisimato taar'ere Aazabni meyak aatire imonerwa yifawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Es baron odeniise innotnawa esta feese baassotna Phawulos Yerusalem hamnoynamato shiipheni. ");
INSERT INTO jnjl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Sinuntano Phawulos wolgire: «Ekka waasira awuniron nibnaason shorkifetiso? Ta Daam Yesusni sunaasik Yerusalemuk taato koi'ba sinnoynaron kitunu sinfaanane hooreratu fawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kiitini kiitooson ephphetoo beybaase: «Ese Daamiis yina bar sinungwa» iyaat beyni. ");
INSERT INTO jnjl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Estak garo wona diininneen orfo ba'aniison taar'a hoossira Yerusalem hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Qisariyak feese amanynyini meyaassin isa isaas innoneen ane yeesete. Baasso dey barki keer beysa ephanik Minasonni keer innotin zoonsisete. Bar dey zeemme amanere fe Kophiroski asusasin isaas. ");
INSERT INTO jnjl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Hamma Yerusalem kar'feni kabaasik amanynyini meya innotin girak ephete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wonotiri wono Phawulos innoneen ane Yaqobniki keer hami. Estak dey kur'uni meya zuuttere feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Phawulos dey naga ooshshenanneen orfo Ha'oos barki kamo Aazabni meeni ganeyaassi zagina wuzason isarba isarbaasik baassok make. ");
INSERT INTO jnjl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Es baron odeseteyse Ha'ooson galattesete. Phawulosnin dey ekka yisete: «Ayniiso! Showo kumak faadtoni Ayhudni meya amanesetematonawa zuuttambesiise dey Museni tumaasik ma'a koonabesi faanamato arifatwa. ");
INSERT INTO jnjl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ne Aazabni meeni ganeyaassi feese Ayhudni meyanon: ‹Naanggotnitiison haarko kunsutiita wedey tumaason zagutiita› yit assuneesik Museni tumaason zagsobeyonek zagitarwa yistet fa wollaason odesetewa. ");
INSERT INTO jnjl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ese awu zagifaanine ma'ari? Ne yooson futoosik odeseterwa. ");
INSERT INTO jnjl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Es bari boor'a han inno neek makefeni baron zaguwa. Gibabesi faana acheech asu innoneen ane feeseterwa. ");
INSERT INTO jnjl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Baassotin ephpha Betemeqdesi hamfaat teetneeson kayimsuwa. Sombesiison dey fiittosonek betemeqdesiisik imtefa imni waagaason baassok kaasuwa. Es baron zagaatane neyista wolumte wollaas zuuttera shima sinbaasewa nenu teetneesik dey tumaasik ajajame asu sintamato zuuttambaase arunawa. ");
INSERT INTO jnjl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Sinuntano Aazabni meyaassin amane baassok: ‹Koo'loosik maa'a imte kiina muuson muutiita, hannaason muutiita, geetera kiti waagaasi ashanon muutiita, gerkesasin wokti› yifa tichaason wollera buggira baassok gafkiniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Esseen orfo Phawulos asuni meyanon ephphe wonotirik baassoneen ane teetbaason kayimsi; kayimsone wonaas aage sinanamatonawa es wono isa isarbesiisa teetak imtefa gibani maa'aasi waaga aage kaastonamato yaadassuk betemeqdesiisi giri. ");
INSERT INTO jnjl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Naafunsa wonaas ko'unak kar'fana kabaasik Iisiyan yeese Ayhudni meya Phawulosnin betemeqdesiisi biyete boor'a daraasin zuutire basaasta kabgisere ephesete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«Israelni asuni meyane!, Innotin argasutiwa, daraaniisinnawa tumaanisonna, dey daa daasi fe asu zuuttambaase asin assit feyiis han asuswa. Es bar bariknu beynoy Aazabni meyanon betemeqdesiisi gedfaafe han kayma dimaason kiinsiwa» yit chaagesete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Es baron makesetees zeemo sinak Efesonki Trofemos barneen ane katamaassi kutifeen biyete boor'a barin Phawulos betemeqdesiisi ephphe girine faar sinna baassok bestera faar. ");
INSERT INTO jnjl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Katamaas zuuttera naga turki. Dara dey zuuttere isarik eelle yeere Phawulosnin ephphe zatte betemeqdesiissin kissete. Geregere betemeqdesiisi gamalanon kulufte. ");
INSERT INTO jnjl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Asuni meya Phawulosnin Woruk sholsefe kabaasik: «Yerusalemni katama zuuttambaase asiissi naga tishiwa» yifa wosiyaas Romanni meya taar'oni meyanon ajajefe gaanynyaaski hamma kar'i. ");
INSERT INTO jnjl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Estan bar meya taar'osakitoninnawa tii meeni gaanynyasakitoninna ephphe eelet hamme kar'i. Asuni meya dey meya taar'oni meyanon ajajefe gaanynyaasnawa meya taar'oni meyanonna biyeteyse Phawulosnin ichaason beyete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Es kabaasik meya taar'oni meyanon ajajefe gaanynyaas tai'sere ephphe Phawulosnin hep shashsharak taatonak ajaje. Esseen orfo bar oo sinnamatonawa awu zaginamatona mamsi. ");
INSERT INTO jnjl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Darani meya dey isa isaas isa wuza yisten oomiis dey ooma wuza maket chaaget feeseter. Meya taar'oni meyanon ajajefe bar daraasa chaagatan kabi chowa futo sinna wuzason arunak aane chime sinna boor'a Phawulosnin meya taar'oni meeni ke'e ephphe hamonek ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Phawulos gefaasta kar'fena kabaasik daraas zuuttere akama gi'ak kabsere barin miir'oni wuza basaasta katusonek feeseter sinna boor'a meya taar'osakito barin wor'e hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Daraas dey: «Wortowowa» yit orfoose chaaget barneen ane hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Meya taar'osakito barin ephphe hamere feesefe dimaasta kar'efe kabaasik Phawulos meya taar'oni meyanon ajajefe gaanynyaasin: «Ta isa wuza neek makonak ma'i utaroso?» yi. Ajajefe gaanynyaas dey: «Girikni noono arifatoso? ");
INSERT INTO jnjl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Eekan zeemo sinak dara nuurunak zagire kaa wori acheech kum asuni meyanon ephphe ichma daa hama Giphtsini asus netenoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Phawulos dey: «Ta Kilqiya fa arto Tersesni katamaassin koonte Ayhudawiwa. Adarawa daraasik makonak ma'i utak mamsifawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Bar dey makowa ubaase Phawulos gefaasta yerefaat kushubaason kabgire daraas shaakunak zagi. Daraas dey shaakki. Phawulos Ibrayistini noonok ekka yit make. ");
INSERT INTO jnjl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Nitto aytaasakitonawa abataasakitona! Hash nittok makona wolguni wolumnaason odotiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ibrayistini noonok makefeen odeseteyse akamanon shaakkisete. Estan Phawulos dey ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Ta Kilqiyaki fa Terseski katamaassin koonte Ayhudawiwa; sinuntano dichnaas han Yerusalemni katamaassiwa; taan assiis Gamaliya sinfe asuswa; abani meeni tumaason mai'sira arira dey han nitto zagifetisimato hashnu Ha'oosik akamanon koone asuwa. ");
INSERT INTO jnjl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Han ugnaasik zoonustefe baassotin kituta kar'one kabaneen kabgit faanar. Arqasinnawa mashkasonna taar'taafa aatira taatoni keer imet faanar. ");
INSERT INTO jnjl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Es bar futo sinbaason Maagni gaanynye meeni gaanynyaasnawa kur'uni meeni shonggose taak zaalwa. Esiisimato dey Demaskok feese han asuni meyanon taar'a Yerusalem teshshera ke'o danonek Demaskok feese Ayhud sina ayni meyaki tichisete tichaason ephnaas han baassokingwa. ");
INSERT INTO jnjl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Ta Demasko hamet katamaaski tai'sefana kabaasik toosta diinqone akama chaarefa saman biratonaasta palpalit chaare. ");
INSERT INTO jnjl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Es kabaasik daasta kere gandera: ‹Sawulno! Sawulno! Awuni boor'a taan kabgidifa?› yifa kaama oden. ");
INSERT INTO jnjl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ta dey: ‹Daamiiso! Ne oonso?› yin. Bar dey: ‹Ta han ne kabgifata Naaziretki Yesuswa› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Taneen ane feese baasso es chaarefaasontu biyetetano bar taan wolumsifena kaamaason aane odosoto. ");
INSERT INTO jnjl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ta dey: ‹Daamiiso! Awu zagunarinso?› yina Daamiis dey: ‹Kabira Demasko hamma; zagutak sholsi bar zuuttera estak neek maktonawa› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Es chaarefaasi palpalutan kabi chowa biyanak aane chimut sinna boor'a taneen ane feese asuni meya kushunaassi zatere zoonsit Demasko katisete. ");
INSERT INTO jnjl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Estak Hananiya yiste isa asu feer. Bar dey Ayhudni meeni sinak ulfinto; tumaasik ha'i ayyantu asu. ");
INSERT INTO jnjl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Bar yeere teshna yerefaat: ‹Ayta Sawulno! Aafnees biyungwa!› yi. Aafnaas dey es kabaasik geregere gachche; barin dey biin. ");
INSERT INTO jnjl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Bar dey taak ekka yi: ‹Abaniisakitoni Ha'o bari safaraason arutak, ookoosin biyataknawa dey kaambaason noonobaassin odotakna neen zeemma koriwa. ");
INSERT INTO jnjl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Es baron dey zaginaas biita baronnawa odeta baronna asu zuuttambaase asi sina barik zaal sinatakwa. ");
INSERT INTO jnjl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Eekan Hash awu oodaat diitarin? Kabira basa sunaason teegok haphuktera boor'neessin kayimwa› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Esseen orfo Yerusalem wolla hamma betemeqdesiisi Ha'o shiiphefaat temesxok raa'i biin. ");
INSERT INTO jnjl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Daamiis dey bestere: ‹Ne ta chowaasik makota zaalaason aafa ephphetoosone wuza sinna boor'a taptera Yerusalemun keswa› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ta dey ekka yin: ‹Daamiiso! Ayhudni shiiphoni keya zuuttambaase asiissi hamfaafa Neek amanefe baassotin zuutira ephpha taatoni keer gednamatonawa ichnamatona baasso teetbesiisik arsedifewa. ");
INSERT INTO jnjl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Neek zaal sina Isxifanosnin worsefe kabaasik ta dey baassoneen ane isar sinna teshbesi yerefaat baasso mayaason oodet faanarwa› ");
INSERT INTO jnjl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Daamiis dey: ‹Woka daak feese Aazabni meyaki neen wosunar sinna boor'a kabira hamma› » yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Estaneen kar'e daraas zuuttere Phawulos makena wollaason odeset feeseter. Estan kaambesiison teggisere: «Han effetena asu kaak foonak aane sholsifa sinna boor'a daastan tishuwowa» yit chaagete. ");
INSERT INTO jnjl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Baasso dey chaaget; maybesiison kisire sirusta birassit; tulooson den sama buket feeseter. ");
INSERT INTO jnjl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ajajefe gaanynyaas es baron biinayse Phawulosnin meya taar'oni meya feesefe dimaassi ephphe hamonek ajaje. Daraas basaasta awuni boor'a effaron chaagetemato arunak ichchet mamustonak ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Sinuntano talfak taar'ere ichonek hooresefe kabaasik Phawulos teshba yere tii meeni gaanynyak: «Roomni asusnin mangsu kar'noyfeen ichatik sholsunoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tii meeni gaanynyaas es baron odenayse ajajefe gaanynyaaski hamme: «Han asus Roomki daani asuwa; awu zagutakinso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Es bari boor'a ajajefe gaanynyaas Phawulosniki tai'sere: «Ne Roomki daani asunoso? Taak makebbo» yi. Phawulos dey: «Aa, ta Roomki daani asuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ajajefe gaanynyaas: «Ta Roomki asu sinanak akama waagatu kaasira waagengwa» yi. Sinuntano Phawulos: «Ta Roomni daastatu koontengwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Estan barin tu'nuk hoorere feese baasso basaastan oor kesse hamete. Gaanynyaas dey Roomki asu sinbaason arinaayse shashsharak taatonak ajajobaasik dige. ");
INSERT INTO jnjl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Wonotiri wono ajajefe gaanynyaas Ayhudni meya Phawulosnin malassete chowa futobaas awu sinnamato arunak shole. Estan maagni gaanynye meyanonnawa shonggota diisefe baassotinna zuuttosonek ajaje. Phawulosnin taatoni keerun kotsire teshshe baasso sina tai'si. ");
INSERT INTO jnjl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Phawulos shonggosta diise baassotin kootkire biyaat: «Aytaasakitono! Ta hawungneen kar'a Ha'oosi sina faana foonaas ma'a kanukwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Hananiya sinfe maagni gaanynye meeni gaanynya Phawulosni tesha yere asuni meyanon Phawulosni noonooson ichosonek ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Es kabaasik Phawulos Hananiyanin: «Ne booro maattera di sawane faatarwa; Ha'oos neen ichnirwa! Ne tumaasimato mangsu kar'atak diifaat kessa tumaasneen gerakalo taan ichosonek ajajotaroso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Esta yerse asuni meya: «Ha'oosi maagni gaanynye meeni gaanynyaasin me'fatoso?» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Phawulos dey: «Aytaasakitono! Maagni gaanynye meeni gaanynya sinbaason aane arutwa. Ha'oosi kaamsi: ‹Daraasin ha'sife baassosta mangu kaama makotaatawa› yistera tichchera faarwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Sinuntano Phawulos esta yere baassossin isa kunuus Seduqawi; isa kunuus Ferisawi sinobesiison arifaat: «Aytaasakitono! Ta Ferisawini meeni keenaassin koonte Ferisawiwa. Hash ta mangsu kar'tefana dimaasta tai'senaas imte abdisiknawa kitun kabuni chowaasiknawa» yit zuuttoosi sina kaambaason teggire chaagi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Es baron makobaase Ferisawini meenawa Seduqawini meena asi ganeyaassi faasso kabin shonggos heppik bagte. ");
INSERT INTO jnjl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Seduqawini meya: «Kitun kabu aafa; Ha'oosi wosiya dey aafa; Ayyanaas dey aafa» yifar; sinuntano Ferisawini meya: «Es bar zuuttambaase faarwa» yiretu amanesefe. ");
INSERT INTO jnjl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Es bari boor'a nagani tishu sini. Ferisawini meeni ganeyaassin isa isa Museni tumaason assife baasso kabsere: «Han asusata isa mangsune aane daneniwa. Awuzakne Ayyana wedey Ha'oni wosiya barik make sinanawa» yit chinire we'nisete. ");
INSERT INTO jnjl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Faassoos arkit yoobaase asuni meya Phawulosnin buu'e tishuksonoytemato ajajefe bar digefaat meya taar'oni meya hamere asuni meeni ganeyasin kisire teshshere meya taar'oni meya feesefe dimaasta ephphe hamonek ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Wonotiri wono waalin Daamiis Phawulosni tesha yerefaat: «Digotaatawa! Yerusalemuk ta chowaason maketaasimato Room dey hamma ta chowaason makotak sholsuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wonfana kabaasik Ayhudni meya zuuttesere: «Phawulosnin worunoy muu aafa muuni wuza dey aka aafa ushani wuza» yit teyisesete. ");
INSERT INTO jnjl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Es baron merkees acheechasir asuneen denalo. ");
INSERT INTO jnjl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Es baasso dey maagni gaanynye meyakinawa kur'uni meyakina hamere: «Phawulosnin woruninneen: ‹Muu aafa muuni wuza› yit chinira teyiniwa. ");
INSERT INTO jnjl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nitto dey shonggosneen ane isar sinna basa chowaason mai'sire tu'nuti wuza faarne faar zagira Phawulosnin nittoki tai'sunak ajajefe barin mamsutiwa. Inno dey hanta kar'noyfeen worunik hooreniwa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Sinuntano Phawulosni eeti naa es mekamaason odefaat meya taar'oni meeni ke'e hamme Phawulosnik make. ");
INSERT INTO jnjl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Phawulos dey tii meeni gaanynyaasasin isarin teegere: «Han naas ajajefe gaanynyaasik makona wuza faar sinna boor'a gaanynyasneen uphsuwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Tii meeni gaanynyaas dey naasin taamme ajajefe gaanynyaaski katifaat: «Han naas neek makona wuza faar sinna boor'a taato sina Phawulos taan teegere neeki ephpha yoonak shiiphewa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ajajefe gaanynyaas dey naasin kushubaassi zatte eksefaat: «Taak makota wuzaas aambanso?» yit mamsi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Naas dey ekka yi: «Ayhudni meya Phawulosni chowaason chinire tu'nusonerne faar zagsere wono shonggosi sina tai'sutak neen mamsusonek merkesetewa. ");
INSERT INTO jnjl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Sinuntano ne ma'i utaatawa. Phawulosnin woruninneen muu aafa muuni wuza aka dey aafawa ushani wuza yisere teyisete acheechasirneen denalo asu barin woruk oodediferwa. Hash baasso oodeset feesetees ne wolgusongwa» ");
INSERT INTO jnjl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ajajefe gaanynyaas: «Han taak maketa chowaason ooniknu makotaatawa» iyaat naasin gafki. ");
INSERT INTO jnjl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Esseen orfo ajajefe gaanynyaas Tii meeni gaanynyaasasin heppin teegere: «Waalin keez sa'atiista Qisariya hamni hep tii meya taar'oninnawa, naafunasir faza eelsuni asuninna, dey hep tii ebo fokni asunin hoossutiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Phawulosnik fazasikitonon hoossira daason ha'sife Filkisniki nagak kar'anak zagutiwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ekka yifa ticha dey tichire: ");
INSERT INTO jnjl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Qelaudewos Lusiyosnikin arkitto daason ha'sife Filkisno! Naga neek sinfawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Han asusin Ayhudni meya worsone kabawa. Sinuntano bar Roomki daani asu sinbaason arina boor'a meya taar'oni meyaneen ane esta kar'a fu'engwa. ");
INSERT INTO jnjl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Barin awuni chowak malassetemato arunak sholefaat baasso shonggosta tai'sin. ");
INSERT INTO jnjl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Malassetees dey baasso tumaason biifa chowaasik sinbaason aringwa. Sinuntano kituta katuni wedey barin taatoni keer gedni chowatawa. ");
INSERT INTO jnjl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Han asusin woruk koppa'sere hooresetemato odenayse geregere neeki gafkingwa. Malatese baasso malatbesiison neeki sina tai'susonek makengwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Estan meya taar'oni meya baassok maktenaasimato Phawulosnin waalin ephphe taamme Antiphatirisniki katisete. ");
INSERT INTO jnjl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wonotiri wono faza eelsife asuni meya Phawulosneen ane hamonek zagifaat meya taar'oni meya feesefe dimaaski wolsete. ");
INSERT INTO jnjl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Faza eelsife asuni meya dey Qisariya kar'eteyse tichaason daason ha'sife barik imefaat Phawulosnin dey sinba tai'sisete. ");
INSERT INTO jnjl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Daason ha'sife bar tichaason feretinanneen orfo Phawulosnin: «Ne! Ayki daani asunso?» yit mamsi. Qilkiyaki daani asu sinbaason arinaayse: ");
INSERT INTO jnjl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«Neen malatesefe baasso yeesefaaten chowneeson baassokin dey odonawa» yi. Herodisni masaraassi oodtere foonak ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Uuch wonaneen orfo maagni gaanynye meeni gaanynya Hananiya isa isa kur'uni meyaneen Tertelus yiste wobisneen ane Qesariya hami. Baasso dey Phawulosni chowaason daason ha'sife Filkisniki hamere malatesete. ");
INSERT INTO jnjl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Phawulos teegtere yeefena kabaasik Tertelus ekka yit malatonak kabire: «Ulfinto Filkisno! Neeki kamo akama naga danniwa, Han ne ma'a ha'susik daraaniis foobaas sooltewa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Akamanon ulfinto Filkisno! Han ma'a wostoneeson daa daassinawa aagene aagenena akama galataktu ephpha taafeniwa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Sinuntano haniistan denalo neen hopsunoynaron kawunbaase neek makona baron garamak innotin odotak shiiphefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Han asus innoosta mangu mero siniwa. Han daa zuuttambaase asiissi fe Ayhudni meeni ganeyaassi naga tishki. Naazirawini meya yistefe baassok zoonsibesiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Dey betmeqdesiison kiinuk kabefeen ephniwa. Tumaniisimato mangsu kar'anik sholera faanir. ");
INSERT INTO jnjl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Sinuntano meya taar'oni meyanon ajajefe gaanynya Lusiyus yeere akama hugnak inno kushuussin ephi. ");
INSERT INTO jnjl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Barin malatesefe baassotin dey neeki yoosonek ajaje Ne teetneesik barin tu'nira han inno barin malateni chowaason zuuttira arutak chimatawa.» ");
INSERT INTO jnjl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayhudni meya dey: «Han chowaas zuuttera futowa» yiset malataasik isar sinete. ");
INSERT INTO jnjl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Daason ha'sife Filkis Phawulos makonak kushubaason kabgire besi. Phawulos dey ekka yit mako ephi: «Showo neya han daraasata mangsu kar'et faatamato arinar sinna boor'a tayista malate malataasi wolgunon neek makonaas girakwa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ha'oni shiiphok Yerusalem hamnanneen asire heppe wonaastan aane daytowa sinnamato ne teetneesik arutak chimatawa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Betemeqdesiissi sinun Ayhudni shiiphoni keyaassi wedey katamaassi ooneennu we'nifana wedey daraas naga turkunak zagifana taan aane danoto. ");
INSERT INTO jnjl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Hash taan malatesete chowaasik isa zaala neek tai'susonek aafa chimone wuza. ");
INSERT INTO jnjl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Sinuntano han baron neek makonak sholefawungwa; baasso eshni ugna yisefe es ugnaasik ta inno abani meeni Ha'oosontu shiiphefawungwa. Museni tumaasi tichche baronnawa raajjuni meyaki kamo makte baronna zuutira amanenarwa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Baasso dey abdi zagsefeysimato ta dey ookoni meenawa ooko sinnoy meena kitun kabsonemato Ha'oosik abdi zagifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Es bari boor'a ta Ha'oosi sinaknawa asuni sinakna kayma nibna foonak wonna wonna duudefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Yerusalemun kesnanneen hang showo wogga aatnanneen orfo darataasik sinni argasuni waagnewa Ha'oosik imtoni imaason imanak yaangwa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Betemeqdesiisik dey kayimni sitiriison zagit faanatu danetewa. Es kabaasik taneen ane daraas aafe. Dey nagani tishuus aane kabuwa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Sinuntano Iisiyan yeese Ayhudni meya esta feeseter. Baasso tayista malatosone chowa faafaanane neeki sina tai'sere malatosotowa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","«Esseen orfo shonggosi sina tai'fana kabaasik danete mangsu faafaanane maksotowa. ");
INSERT INTO jnjl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Baasso ganeyaassi yerefaat: ‹Kituni meeni kitun kabu faarwa unaasiktu hash hawung mangsu tayista katonak nitto sina ta'ingwa› yit tega kaamak chaagga makengwa. Esiistano ooma zagina wuza aafawa.» ");
INSERT INTO jnjl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Sinuntano Filkis Daamiisa ugnanon mai'sire arire feer sinna boor'a: «Meya taar'oni meyanon ajajefe gaanynya Lusiyos yeefena kabaasik nitto chowaason koi'sunawa» iyaat gafki. ");
INSERT INTO jnjl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Phawulosnin oodet fe tii meya taar'osin: «Birmadumma kalnoy mai'sira oodwa; dey koonbaasakito barik sholsi wuza ephphe yeesefe kabaasik kalataatawa» yit ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Garo wonaneen orfo Filkis Ayhudawi sina asuba Dirusillaneen ane ye. Phawulosnin teegsire Kiristoos Yesusnik amanoni chowaason maken ode. ");
INSERT INTO jnjl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Phawulos ookoni chowaasonnawa teetni ha'suse asi chowanonna dey yooni mangsuni kar'aasi chowanon makobaase Filkis digere: «Hash hantan hamma; taak ho'itna wononeen wosira teegsunawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Filkis Phawulosnikin waaga muunak abdi zagit feer. Es bari boor'a showo wona teegsifaafe wolumsit feer. ");
INSERT INTO jnjl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Hep wogganeen orfo Porqiyos Fistos Filkisni kodaasta ha'sunir sinne taatte. Filkis Ayhudni meyanon girsunak sholefaat Phawulosnin kota beyi. ");
INSERT INTO jnjl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fistos ha'sifena awurajjaassi girire keez wona aatinanneen orfo Qisariyan Yerusalem hami. ");
INSERT INTO jnjl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Estak Maagni gaanynye meenawa isa isa Ayhudni meyanon zoonsife baassona Phawulosnin malatesete. ");
INSERT INTO jnjl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Phawulosnin ugunta oodde worsonek sholsefaat Fistosnik: «Phawulosnin Yerusalem ootire teshshok innok ma'a wuza zaguwa» yit shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Sinuntano Fistos wolgire: «Phawulos Qisariyak taatoni keer oodtettu fewa; ta dey hash taptera esta hamnarwa. ");
INSERT INTO jnjl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ese nittotin ha'sife meya taneen ane Qisariya hamotowa; estak Phawulos zagina mangsu faafaanane malatosotowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fistos dey nangirin wedey asir wona sinniron baassoneen ane aatinanneen orfo Qisariya hami. Wonotiri wono mangsuni kar'ni kodaasta diifaat Phawulosnin tai'susonek ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Phawulos tai'sefena kabaasik Yerusalemun ye Ayhudni meya ganeya gedde yersefaat showo zaalba foonto faya malata basaasta malatesete. ");
INSERT INTO jnjl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Phawulos dey: «Ayhudni tumaasta sinun betemeqdesista wedey Qesarniista isa zagina mangsu aafa» yit malataasi wolgunon wolgi. ");
INSERT INTO jnjl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fistos Ayhudni meyanon girsuk sholefaat Phawulosnin: «Yerusalem hamfaat han chowaasik mangsu katonak taaki sina ta'atak sholefatoso?» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Sinuntano Phawulos wolgire: «Tayista mangsu kar'ak chimni Qeesarni mangsuni kar'ni kodaasi sina yerefawungwa. Ne mai'sira arifataasimato Ayhudni meyaasta isa mangsune aane katutwa. ");
INSERT INTO jnjl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ese miir'anewa kituta katuni mangsune zagin sinfaanane kitun fui'tona aafa unawuza. Sinuntano baasso malataas shima sinfaanane taan baassok aatire imanak oonu aafa chimanawuza. Chownaas Qeesarni sina biistongwa» yinwa. ");
INSERT INTO jnjl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Es kabaasik Fistos barneen ane merkesefe baassoneen ane merkere: «Yigibanynyi yitanneen Qesarniki hamatawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Garo wonaneen orfo taato Agriphanawa Berniqena Fistosnin «Ekku nagak yaata» uuk Qisariya yeesete. ");
INSERT INTO jnjl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Estak showo wona diisete boor'a Fistos Phawulosni chowaason ekka yit taato Agriphanik make: «Filkis taatire kunsina isa asu hantatu fe. ");
INSERT INTO jnjl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ta Yerusalemuk faana kabaasik maagni gaanynyanawa Ayhudni kur'uni meena han asusa chowanon malatesere basaasta mangsu kar'anak taan mamussete. ");
INSERT INTO jnjl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Sinuntano ta: ‹Malatte asus malate baasso sina yerere malattena malataasi wolgunon imnoyfeen malate barin aatire ima Roomani meeni dubbiyotawa› yira baassok wolgingwa. ");
INSERT INTO jnjl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Estan malatese baasso hanta zuuttesefe kabaasik ta dey woknoy wonotiri wono mangsuni kar'ni kodaasta diifaat es asusin tai'susonek ajajen. ");
INSERT INTO jnjl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Malatese baasso dey teshba yersefaat maksefe kabaasik ta safarenaasne fa mangu wuza isanne basaasta aane maksoto. ");
INSERT INTO jnjl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sinuntano barneen ane we'nit feesetees baasso teetni haymanotisiknawa Phawulos ‹Hayewwa› yifena kiti Yesusni chowaasiknawa. ");
INSERT INTO jnjl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ta dey han effatena chowaason tu'nu taan rakkisina boor'a: Phawulosnin: ‹Yerusalem hamfaan estak han chowaasik mangsu neyista kar'anak sholefatoso?› yin. ");
INSERT INTO jnjl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Sinuntano Phawulos chowbaas Qesarnikik biistonak sholefaat: ‹Yigibanynyi› ubaasik esta gafkunanneen taatere foonak ajajen.» ");
INSERT INTO jnjl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripha Fistosnin: «Ta han asus makefeen odonak sholefawungwa» yi. Fistos dey: «Wono makefeen odotawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Estan wonotiri wono Agriphanawa Berniqena akama ulfinak meya taar'oni meeni gaanynyasakitoniknawa katamaassi fe arto meyakna geeptere yeesere mangsuni kar'ni addarashisi girsete. Esseen orfo Fistos Phawulosnin teegsi. ");
INSERT INTO jnjl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fistos dey: «Taato Agriphano! Nitto innoneen ane fe asuni meya zuuttere! ‹Han asus hanneen ekalok kaak foonak aane sholsifa› yit chaaget Yerusalemuknawa han Qisariyak feese Ayhudni meya basaasta mangsu kar'anak taan mamussete asus hanifewa. ");
INSERT INTO jnjl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Sinuntano ta barin kituta katuni mangsu aane danut. Bar dey: ‹Chownaas Qeeasrnik biistongwa› yina boor'a esta wosunak hooren. ");
INSERT INTO jnjl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Sinuntano basa chowaasik Daamtaasik tichuna amma wuza aafawa. Estan tu'nira biininneen orfo tichuna wuza dananatto iyaat nitto sina arkiron dey taato Agriphano! Neeki sina tai'singwa. ");
INSERT INTO jnjl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Isa taato denalo fe taatoski wostere hamfena kabaasik malattena malataasi chowanon amma zagu beya ma'ar sinna taak aane bestowawa.» ");
INSERT INTO jnjl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripha dey Phawulosnin: «Chowneeson makotak chimatawa» yi. Phawulos kushubaason kabgire malatena malataasi wolgunon make. ");
INSERT INTO jnjl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Taato Agriphano! Ayhudni meya taan malatesete malata zuuttambaase asik wolgubaason hash hawung neeki sina imfana kabaasik ta ta teetaasik akamanontu girengwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Esiis dey ne Ayhudni meeni sitirisewa karakkaroose asin mai'sira aritarwa. Es bari boor'a fakiyak taan odotak shiiphefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Garonaaseneen aakkak faanamato Ayhudni meya zuuttere arseterwa. Tesustan kabgira darataasa ganesinawa Yerusalemukna faana foonaason arseterwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ta chowaasik zaala maksonek ma'i yisefaatene haymanotiniison akamanon zaggire oodefe Ferisawini meeni keen sinna faanamato tesustaneen kabire arseterwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Sinuntano hash mangsu tayista katonak hanta yerenaas Ha'oos abaniisakitonik imna teyyani kaamaasik abdi zagifana boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Es abdiista kar'onek asire heppe inno asteseriis Ha'ooson toone waalinne chimme shiiphok oodedifer. Taatono! Taan Ayhudni meya malatesetees es abdiisikwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ha'oos kituni meyanon kitun kabgunir sinbaas awuni boor'a nittoki amantoba foonto chowa sinniso? ");
INSERT INTO jnjl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Ta dey ta teetaasik Naaziretki Yesusni sunaason chimnaasne faaron tugga'ok sholsu sinnamato safaret faanar. ");
INSERT INTO jnjl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yerusalemuk zaginaas esiisongwa. Maagni gaanynye meyakin ephna ha'suni hugnaasik amanynyini meyaassin showonin taatoni keer taatin. Baassotin worsefe kabaasik baassoneen ane isar sinin. ");
INSERT INTO jnjl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Showo wona Ayhudni shiiphoni keya keyaasi hamfaafa ke'o ephphetoosoneknawa Daamiisata mei'ni kaama maksonekna kabet faanar. Baassosta akamanon haarera ooma geroni katamaassinu hamfaafa kabgit faanar. ");
INSERT INTO jnjl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Han chowaasik maagni gaanynye meyakin ha'suni hugnanewa ajajine ephpha Demasko hamdifanar. ");
INSERT INTO jnjl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Taatono! Ugunaasta faana toosta awaasi chaarefatan denalo sina chaarefa biin. Es chaarefaas biratonaastanawa taneen ane hamet feese baasso biratoostana saman chaare. ");
INSERT INTO jnjl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Zuuttamniise daasta gandera kunfeni Ayhudni meeni noonok: ‹Sawulno! Sawulno! Awuniron taan kabgidifa? kamo bittaasta yer'ana iyaatane teetnesontu miir'otawa› yifa kaamaason oden. ");
INSERT INTO jnjl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ta dey: ‹Daamiiso! Ne oonso?› yin. Bar dey: ‹Ta; ne kabgifata Yesuswa; ");
INSERT INTO jnjl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Sinuntano hash kabira wochoneesik yerowa. Ta; neek bestenaas biita ta wuzasiknawa hanneen dey neek besunak fa wuzaasikna wostinynyata sinna zaala taak makotaktu neen taatsingwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Israelni daraasa kushusinnawa neen wosuna Aazabni meeni daraasa kushusinna neen oodana. ");
INSERT INTO jnjl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Aafbesiison gachataknawa talmaassin chaarefaasta kisutakna dey Sexanaasi ha'suni sikalosin Ha'ooski wolgutakna neen zagunawa. Baasso dey boor'besiisi fakiyanon danone. Taak amanobesiisik dey korto sina baassoneen risti danone.› ");
INSERT INTO jnjl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Taato Agriphano! Saman taak beste raa'isik aane ajajamo beyutwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Sinuntano zeemma Demaskok feese asuni meyak estan dey Yerusalemuknawa Yuudani daa zuuttambaase asiissi fe baassokna esiisimato dey Aazabni meya harmusonek maken. Harmusobesiison besifa wosto wostosonek awasingwa ");
INSERT INTO jnjl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Es bari boor'a Ayhudni meya betemeqdesiisik taan ephphe woruk kabsete. ");
INSERT INTO jnjl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Hash hawungneen kar'a Ha'oosi argasu tayistan aane tishuwa. Es bari boor'a garosiknawa gaymasikna han futooson maket hanta yerefawungwa. Raajjuni meenawa Musena zeemme ekka sinana yisere maksete baron makenastano ooma isa wuzane aane makotwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Baasso dey: ‹Kiristoos shanaason ephphetoona; kitun kabuusik dey tesunir sinne chaarefaason Israelni daraasiknawa Aazabni meyakna ammanon besuna› yiseretu maksetewa.» ");
INSERT INTO jnjl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Phawulos es baron makefeen Fistos: «Phawulosno! Nifasetwa. Akamanon arunees nifaso sinatak neen zagiwa» yit chaagge make. ");
INSERT INTO jnjl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Sinuntano Phawulos: «Akamanon ulfinto Fistosno! Futosewa futo sina barontu makentano aane nifasotwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Basa sina ammanon makena taatoos han baron arifewa. Es bar dey aachonor sina beyna boor'a taatoos arunamato arifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Taato Agriphano! Raajjuni meyanon amanees tatanoso? Ne dey amanefatamato arifawungwa» ");
INSERT INTO jnjl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripha dey Phawulosnin: «Han garo kabisasi taan kiristana zagutak sholedifatarwa bi» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Phawulos dey: «Garo kabaasik sinun akama kabak ne ne sinnoytaron hash hawung ta wollaason ode baasso zuuttere han taatonaastano tane feer sinonek Ha'ooson shiiphefawungwa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Esseen orfo taato Agripha; daason ha'sife barnawa Berniqenonna dey baassoneen ane diise asuni meya zuuttesere kabsete. ");
INSERT INTO jnjl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Estan kesere hamefet baassotna baassotna: «Han asusin kituta wedey taatok katuni isa wuzane aane zaguwewa» yit wolumsete. ");
INSERT INTO jnjl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripha dey Fistosnin: «Han asus: Qesarniki yigibanynyi uu shaki sinfaanane baak kotana kabawa» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Merkebik Ixaliya hamanik wonaas katobaase Phawulosnawa oom taatoni meena; taatoosa taatoni meya taar'osakitonisin isa Yuliyos yiste tii meeni gaanynyaasik taamme imete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Iisiyani baarisi ha'ta faase wodebiiski hamfa Adiramixiyonni merkebiissi diira hamni. Teselonqek feefe Meqedoniyani daani asu sina Aristirokos dey innoneen ane feer. ");
INSERT INTO jnjl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wonotiri wono Sidona hamma kar'ni, Yuliyos Phawulosnik kenashtefaat Phawulos hamme zomobaaskin barik sholsi argasu ephphe yoonak fiqadi imi. ");
INSERT INTO jnjl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Estan kabira sirus ek sinniistak sirit faar sinna boor'a baarisi ganesi kuni daa kophirosnon teetera hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Qilqiyanewa Pinifiliyane asi tesha fa baariison finninneen orfo Liqiyak fa Mura yistefa katamasi kar'ni. ");
INSERT INTO jnjl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Estak tii meeni gaanynyaas Ixaliya hama Iskindiriyani merkebi danne barissi duunik zagi. ");
INSERT INTO jnjl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Showo wona nibi nibi kutira akama rakkok Qenidos yistefa katamasi kar'ni. Sirus ek sina hamnoynimato kalna boor'a Silmonani tesha kamo aatta baarisi ganesi kuni daa Qerxesnon teetera hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Akama rakkok teshba teshbaase aatninneen orfo Lasiya yistefa katamaassi tesha fa «Ma'a wodebi» yistefa dimaasta kar'ni. ");
INSERT INTO jnjl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kutifeni kutuniis faya sinna boor'anawa soomoni wonaas aatna boor'ana es kabaasik merkebik kutuus adaga sinna boor'a Phawulos asuni meyak ekka yi: ");
INSERT INTO jnjl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Asuni meyane! Hanneen ekaloki fa kutuniis akama adaga faar sinnatu taak bestedifawa. Feche ba'astanawa merkebiistana koi'ba sinnoynaron asuni kaatanu akama adaganewa tishune kar'nirwa» ");
INSERT INTO jnjl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Sinuntano tii meeni gaanynyaas Phawulos makena baristan merkebiissi fe asusin ajajefe barinnawa merkebiisi abaninnatu odedifer. ");
INSERT INTO jnjl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Es wodebiista yeeshuuson aatuk mangu sinbaasik yeesho esta yerok aane mai'fa sinna boor'a showo asuni meya: «Hama chimtefaanane kawudan awugirukinawa yeeshdaani awugirukina fa Feenqe yistefa Qerxesni wedebiski kar'ere yeeshuuson aatuni» yisere maksete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Garo kawudani sirus sirifeen biyeteyse baasso safareteesne faar sinna baassok bestefaan merkebiis yeronak zagifa baron kabugsere hamak kabsete. Wedebiistan kabsere Qerxes kamo teshba teshbaase aatte hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Sinuntano woknoyfeen «Yeeshdaani awukesaki ipuwa» yiste hugnaba faana ipuwa baarisi ganeyasi kuni daastan kabira baariiski ya. ");
INSERT INTO jnjl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Merkebiis ipuwaasik tugtera ipuwaason tugire hamak aane chima sinna boor'a shaakkira ipuwaasik tugtet hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","«Qeda» yiste baarisi ganesi kuni daason teetera hamfeni kabaasik akama rakkok merkebiisi goonunon mai'sira zatta merkebiison fu'ok chimni. ");
INSERT INTO jnjl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Merkebiissi diise baasso goonuuson hang merkebiski zatte kissetenneen orfo merkebiisi biratonon gaaduk taar'esete. Merkebiis: «Surtiis» yiste fuutuni daasta gandonoytemato digsefaat sharaason kessisefaaten sirus merkebiison kalin hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ipuwaas akamanon innoosta chimet hamna boor'a wonotiri wono merkebiista feche ba'aason kessisere baariissi ha'u ephesete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Keezsinari wono merkebisiki ke'ni kodaason kushubesiisik kissere ha'sete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Showo wona awa wedey baakura aane biistowa sinbaasik sirus innoosta chimet hamna boor'a: «Hanneen ekalok aafawa fui'toni wuza» yit abdi buggini. ");
INSERT INTO jnjl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Asuni meya dey isa muune muunoy showo wona diisete. Es bari boor'a Phawulos baasso ganeyasi yerefaat ekka yi: «Asuni meyane! Ta makena baron odera Qerxesun kabu beyeti sinfaanane han adagasewa tishuuse nittoosta kar'ana kabatawa. ");
INSERT INTO jnjl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Hashnu han merkebiis bar bartu miir'amonittano nittoossin oonu tishunir aafewa. Es bari boor'a ‹Harewa digotiitawa› yit nittotin chinifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Aata waalaasik barir sina ta shiiphefana Ha'oos wosina wosibaas teshna yerefaat: ");
INSERT INTO jnjl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹Phawulosno! Digotaatawa; Qeesarni sina yerotak sholsuwa. Neneen ane hamfe baassotin dey zuutira Ha'oos neekwa iyaat kitun fu'onirwa› yit taak makewa. ");
INSERT INTO jnjl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Es bari boor'a asuni meyane! Digotiitawa! Taak makena baron zuuttambaase asin zagunamato Ha'oosik amanefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Sinfanaknu sirus isa Baarini ganesi kuni daasi ha'ta taamma innotin ha'una.» ");
INSERT INTO jnjl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Asire acheechche sinnari wono waalin Adiriyan yiste baarisi ganeyata siruusik ekna hangna tugtet hamfeni wassi daani kixxestak merkebiistaki wostinynyani meya golo daasta kar'etene faar sinna baassok beste. ");
INSERT INTO jnjl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Es bari boor'a baarisi tir'manon hoossire biini gaaduuson baarisi ha'seten acheechasir meetiri sini. Garonon feesere hepsa dey hoossire biyak gaaduuson ha'seten keezasir meetiri sini. ");
INSERT INTO jnjl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Merkebiis baarisi ha'ta fa shu'aasneen heephtonoynamato digsefaat merkebiisi orfota merkebiison yeetuni wuza acheechon baariissi kessisete. Estan waalaas wonanak shiiphsete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Merkebiissiki wostinynyani meya sirun kesak sholsete boor'a merkebiison yeetuni wuzason ek sinaasta ha'unirne feer sinere goonuuson baariissi ha'sete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Es kabaasik Phawulos tii meeni gaanynyaasinnawa taar'oni meyanonna: «Han Merkebiissi feese baasso merkebiissi shaakkisere du shakisefaatene nitto fui'tok aafa chimati wuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Estan taar'oni meya goonuuson epha gaaduuson kar'eten goonuus akaasta kunna hamanak gafuksete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Waalaas wonanakfana kabaasik Phawulos zuuttambesiise muu muusonek shiiphe. Ekka dey yi: «Isa wuzane muunoy afurnitise asire acheechche wona kar'tiwa. ");
INSERT INTO jnjl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Es bari boor'a muu muutik shiiphefawungwa. Es bar dey kaak footik nittotin chinunawa isa miir'anu nittoosta aafa kar'anawuza» yi. ");
INSERT INTO jnjl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Es baron yinanneen orfo tusha ephphe zuuttambesiise asi sina Ha'o galattefaat batte muu ephi. ");
INSERT INTO jnjl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Es kabaasik zuuttambesiise chima danere muu ephphe meesete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Merkebiissi fe inno zuuttamniise hep tiirewa naafunasire issune asu. ");
INSERT INTO jnjl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Zuuttambesiise meesere gawusetenneen orfo markabista feche zagooson baariissi ha'uk merkebiisi ba'a kashonak zagsete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Wonfana kabaasik hamme kar'ete dimaason aane arsoto. Sinuntano fuutuusi teshta fa baarisi tugo daa biyete. Chimtefaanane merkebiison tugire esta katuk sholsete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Merkebiison yeetifa gaaduuson kotere baariissi gafuksete. Es kabaasik merkebiison kalfa bari gaaduuson kotete. Hangkaloki fa sharaason siruski den teggire baarisi ha'ta kamo aatte kesak hamete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Sinuntano merkebiis tuultera di fuutuusta heephtena boor'a yeet tukna sheligte. Merkebiis sinbaasik fuutuussi kejja diina boor'a shorko beyi. Sinuntano orfobaas ipuwaasi tugutan kabi chowa mestet faar. ");
INSERT INTO jnjl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Taatoni meyaassin isarnu akaassi ichere kesse tishunoynamato taar'oni meya woruk sholsete. ");
INSERT INTO jnjl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Sinuntano tii meeni gaanynyaas Phawulosnin fu'onak sholena boor'a baasso safaraason aane ephphetowe. Es baristan akani ichche fina chimefe baasso merkebiissin kesere baarisi fillefaafe zeemme daasta kessonek ajaje. ");
INSERT INTO jnjl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Fu'te baasso dey merkebiisi zoodanonnawa merkebiisi mestoni kattosi kamona kesonek ajaje. Ekkak zuuttambesiise ma'arik daasta kar'ete. ");
INSERT INTO jnjl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ma'arik daasta kar'ninneen orfo es baarisi ganesi kuni daas Malta yistefanamato arini. ");
INSERT INTO jnjl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Es daasta fe asuni meya akama diinqi ma'a innok zagsete. Es kabaasik iro ichin koochedifar sinna boor'a geya sookere zuuttamniise besunik zagsete. ");
INSERT INTO jnjl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Sinuntano Phawulos waa'a zuutire geyaassi ha'ifeen geyaasi gumutan kabi chowa ufo kessa kushubaason saar'a here'tera yere. ");
INSERT INTO jnjl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Es daasta fe asuni meya Phawulosni kushuusta ufoos here'tera yerefeen biyeteyse baassotna baassotna wol: «Han asus futok kaa woraat ye asuwa! Baariistaki akani guubosin nagak kesfenaknu ooko Ha'oosi ke'osin aatte kaak foonak aane chimewa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Sinuntano Phawulos ufooson geyaassi tebire ha'i. Ufoosi saar'a barin isanne aane miir'owa. ");
INSERT INTO jnjl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Asuni meya dey: «Hashtu atubaas wolsuna wedey geregere kitire gandona» yiset oodeset feeseter. Sinuntano akama sa'ati oodesefeknu basaasta isa miir'a aane kar'a sinnamato biyeteyse safarabesiison soolesere: «Han bar ha'owa» yisete. ");
INSERT INTO jnjl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Es faani dimaas tesha baarisi ganesi kuni daasi ha'sinynya Puppeliyosni daa faar. Es asus innotin barki keer ephphe keez wona ma'arik irbasi. ");
INSERT INTO jnjl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Puppeliyosni aba gumtannewa keenni ichne meraan kunfer. Phawulos es asuski keer girire kushubaason ta'ire shiiphen fari. ");
INSERT INTO jnjl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Es bar sinnanneen orfo baarisi ganesi kuni daasta feesefe oom mettanni meya yeesere farisete. ");
INSERT INTO jnjl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Showo ima dey innok ephphe yeesete. Ulfinsubesiison dey innok bessete. Estan kabfeni kabaasik ugunniisik sholsi wuzason merkebiissi kunussete. ");
INSERT INTO jnjl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Keez assa diininneen orfo es yeeshuuson baarisi ganesi kuni daasta neetta Iskindiriyani merkebiissi diira hamni. Es merkebiista Diyosqoros yiste mano ha'oni gito barista faar. ");
INSERT INTO jnjl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Serakuski katamasi kar'a keez wona esta diini. ");
INSERT INTO jnjl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Estan baariison biratera hamma Regiyun katama kar'ni. Estak isa wona aatininneen orfo kawudani sirus sirina boor'a hepsinari wono Putiyolus hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Estak ayni meyanon danna baassoneen ane naafun wona duunik innotin shiiphsete. Esseen orfo Room hamni. ");
INSERT INTO jnjl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Roomuk feese ayni meya inno yooson odeseteyse hamma Afiyusni gabaastanawa Keez ha'uni dimaastana kar'ere innotin ephak yeesete. Phawulos baassotin biinayse Ha'ooson galattere nibaas chima dani. ");
INSERT INTO jnjl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Room girifeni kabaasik Phawulosnin oodni taar'o imten bar bar foonak fiqadi imte. ");
INSERT INTO jnjl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Keez wonaneen orfo Phawulos esta feese Ayhudni meeni gayma meyanon barki teegsi. Baasso zuuttesefe kabaasik ekka yi: «Aytaasakitono! Ta Israelni daraasatanawa abani meeni tumaastana zagina mangsu isa wuzane aafawa. Sinuntano Yerusalemuk taatera Romanni meeni kushuussi aattera imtengwa. ");
INSERT INTO jnjl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Roomni meya taan tu'nisetenneen orfo kituta katuni mangsu aane danoto sinna boor'a baak kottonek safarsete. ");
INSERT INTO jnjl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Sinuntano Ayhudni meya baak kotnaason tugga'obesiise Qesarnik: ‹Yigibanynyi› unak giddi siniwa. Sinfanaknu darataasin malatonaktawa. ");
INSERT INTO jnjl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Hashnu nittotin teegsinaas nittotin biyanaknawa han baron dey nittok makonaknawa. Ta han shashsharaasik taatenaas Israelni meyak imte abdiisikwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Baasso dey ekka yit wollugsete: «Yuudani daastan ne chowaasik tichche ticha aane innok kar'awa. Hanta yeese baassossin oonu ne chowaasik mangu wuza woller aafewa. ");
INSERT INTO jnjl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Sinuntano han ne faata haymanotiison daadaassi asuni meya tugga'sefemato arifeniwa. Es bari boor'a ne safaraas awu sinnamato neekin odonik sholefeniwa.» ");
INSERT INTO jnjl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Wona duusisere showo asu sinere barki keer yeesete. Bar dey e'son kabira hamma waalin kar'ana kabaneen Ha'oosi taatoni chowanon make. Baassotin amansuk Museni tumaassinnawa raajjuni meeni matsafasinna kisire Yesusni chowaason ammanon baassok make. ");
INSERT INTO jnjl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Isa isa asuni meya makena kaamaason amanesete. Sinuntano oomiis aane amanosoto. ");
INSERT INTO jnjl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Baasso dey baassotna baassotna aane isa niba sinoto. Sinfanaknu oor oor kesonoy feeseten Phawulos koi'baasta ekka yi: «Korto Ayyanaas raajju Isayyasniki kamo nitto abani meyak makena bar futowa. ");
INSERT INTO jnjl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","« ‹Ek daraaski hamfaat; odoson odesetir, sinuntano aane yaadatesefeti; biyason biitir, sinuntano gazgira aane biifeti;; nibnitiissi dey aane kunsifeti. ");
INSERT INTO jnjl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Han daraasa niba muumiwa; odobesiis dey oyewa; aafbesiis dey simewa; ekka sina shaki sinfaanane aafbesiisik biyere; odobesiisik odere; nibbesiissik yaadatesere taaki wolseten; ta dey baassotin fatuna kabawa› yi. ");
INSERT INTO jnjl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«Ese han Ha'oosi fatuni wosiya Aazabni meyak wostenamato arutiwa. Baasso dey ma'i yisere ephphetoosone» ");
INSERT INTO jnjl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Phawulos es baron makobaase Ayhudni meya baassotna baassotna akamanon we'niset kesse hamete ");
INSERT INTO jnjl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Phawulos kira ephna keyaassi hep wogga di. Barki keer yeesefe asuni meyanon zuutire keebaassi ephet feer. ");
INSERT INTO jnjl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Oonu barin kalnoynaron Ha'oosi taatonon maket Daam Yesus Kiristoosni chowaason diga foontonon assit feer.");
INSERT INTO jnjl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Kiristoos Yesusni wostinynya dey wosi sinanak teegtere Ha'oosi misirachchuni kaamanon makonak kortere fe Phawulosnikin woste wosiya. ");
INSERT INTO jnjl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Es misirachchuni kaamaas Ha'oos raajjuni meyaki kamo korto matsafaasikitosi zeemme imna abdini kaamawa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Es misirachchuni kaamaas Ha'oosi Naa ashak Dawitni zalaassin koontobaasontu makefa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Esiisimato dey Daamni Yesus Kiristoos korto Ayyanak akama hugnak kitun kabubaasik Ha'oni Naa sinbaas arte. ");
INSERT INTO jnjl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kiristoosni sunaasik Aazabni meya zuuttere amanosoneknawa ajajamosonekna zaguk barki kamo wosi sinna teegtoni Ha'oni otma danniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nitto dey Yesus Kiristoosnir sinatik Ha'oos teegena Aazabni meyaassin isaaswa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Es bari boor'a Ha'oosik shunterenawa bari korto dara sinatik teegtere fe Roomanki asuni meya zuuttera: Abani sina Ha'oos; Daam Yesus Kiristoosni otmaasewa nagaase nittok sinfawung. ");
INSERT INTO jnjl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nitto amantoosi wolla han daasta zuuttera odtena boor'a zuuttambaase asiistan zeemma Yesus Kiristoosniki kamo zuuttamntiise asik Ha'onaason galattefan ");
INSERT INTO jnjl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Wonna wonna shiiphet faanamato Naasa chowanon makefa misirachchuni kaamaason makok tuuma nibnaasik wostefana Ha'oos zaalawa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Hash dey koi'baasta nittoki yoonak Ha'oosi fiqadi sinna ugunaas kaananak wonna wonna shiiphefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Amantok chimma footik zaguni ayyanani ima nittok haa'anak nittotin biyanak kalten. ");
INSERT INTO jnjl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Esiis dey ta nitto amantoosik nitto dey ta amantoosik innotna innotna chimanikwa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Aytaasakitono! Oom Aazabni meeni ganeyaassi showo amanynyini dannaysimato nitto ganeyaassin dey amanynyinin dananak sholet faanar. Sinuntano nittoki yoonak showo wona hoorera kesna hashneen kar'a sina beynamato arutik sholefan. ");
INSERT INTO jnjl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Girikni asu sina baassotinnawa sinnoy baassotinna, ari baassotinnawa arunoy baassotinna asik makonak adara tayista faar. ");
INSERT INTO jnjl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Es bari boor'a Roomki feese nittok misirachchuni kaamaason makonak akamanontu sholefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ta misirachchuni kaamaasik aafa iichchonawuza. Misirachchuni kaamaas zeemma Ayhudni meyak dey Aazabni meyaknawa; esiis dey amanesefe baassotin zuutira fatuk chimni Ha'oni hugnawa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ookoos amantoktu kaa danana yistera tichchewa. Ha'oosi ooko dey misirachchuni kaamaasik ammanon bestena boor'a tesustan kabira hamma koi'ba kar'a asu ooko sinanaas amantokwa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Asuni meya mangubesiisik futoos artonoynamato zagsefe. Ha'ooson digo beyobesiisiknawa mangubesiisi boor'ana zuuttambesiise asiista Ha'oni gi'a saman yoonawa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Baassotin ke'unaas Ha'oosi chowanon arsonek sholsi baron Ha'oos baassok ammanon besin arsere feeseter sinna boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Han daas testenanneen kabira asuni meyak bestonoy Ha'oosi haala koi'ba foonto hugnabaasewa bar Ha'o sinbaase tesina testooski kamo ammano kessa bestena boor'a asuni meya mangsisefe mangsuusik teetone wuzbesi aafawa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Baasso Ha'ooson arsere feesefet bar Ha'o sinbaasik sholsu ulfinnewa galatne barik aane imosoto. Safarabesiisik ke'nor sinete. Yaadatonoy nibbesiis dey talme. ");
INSERT INTO jnjl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","«Techumni faar» yisefet gowwa sinete. ");
INSERT INTO jnjl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Koi'ba foonto Ha'ooson ulfinsuustan aatni wuza sina asuni gitok, kasak, acheech wochoba faana waagak wedey daasta bokotefa testoosi gitok wosuste suuraasik ulfina imete. ");
INSERT INTO jnjl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Es bari boor'a baassotna baassotna baasso ashaasta iichu wuza zagsonek Ha'oos kiinak tuuma mangu eenantobesiisik ajajamosonek aatira imiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Es bar dey sinaas Ha'oosi futonon eshak soolsere tesi baron beyfaat testooson Ha'o zagire shiiphsete boor'anawa barik dey wostesete boor'anawa. Sinuntano Ha'oos koi'ba foontonon galatamtowa. Aamin. ");
INSERT INTO jnjl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Asuni meya es baron zagsete boor'a Ha'oos baassok sinnoy iichu eenantobesiisik aatira imi. Mashka asubesiisikito artera fa arqasuneen kunuson beyfaat artonoy ugnak soolsete. ");
INSERT INTO jnjl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Esiisimato arqasuni meya artera fa mashkasuneen kunuson beyye baassotna baassotna igak kiichchesete. Es bari boor'a arqasuni meya arqasuneen iichu wuza zagsete. Es mangu wostobesiisik sholsi ke'o baassosta kar'in ephphetoosoner. ");
INSERT INTO jnjl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Asuni meya Ha'ooson aruk sholo beyete boor'a iichu wuza zagsonek Ha'oos ke'noy kanuk aatira imi. ");
INSERT INTO jnjl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Es bari boor'a miir'ok, mangsuk, tiittanak, nuuruk, koonak, kaani woruk, faassok, eeshshuk, mangu safarakneen tuumme feer sinete. Esiisimato dey hamater sinone. ");
INSERT INTO jnjl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Asuni suna mangsir; Ha'ooson oomter; asunin ulfinsunor; beeganto; tane fe asu aafe yir; mangu wuza wosto sholer; aba intobesiisik ajajamonorwa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Yaadatbesi foonto; wuli boker; keeshtambesi foonto keena buduwa. ");
INSERT INTO jnjl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","«Es baron zagife baasso zuuttere kitusonek sholsifawa» yifa Ha'oosi tumanon arsefet es baron zuutire zagsefe. Zagu koi'ba sinnoynaron esiisimato zagsefe baassotin dey chinisefewa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Oom asuniista mangsu kar'fe ne teetneesik teetota wuzne aafawa. Oom asusata mangsu kar'fata kabaasik teetneestatu mangsu kar'difatwa. Ne asuniista mangsu kar'faat es asus zagifena barontu zagifatwa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Es baron zagsefe baassosta Ha'oos sholsu mangsu kar'fanamato arifeniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ese han asuso! Ne ekka zagsefe asuni meyaasta mangsu kar'faat baasso zagsefe baron zagifata kabaasik Ha'oosi mangsuni kar'sin aatta kesatanne faaroso? ");
INSERT INTO jnjl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Wedey Ha'oosi ma'a, fakire oodbaas, fakibaas neek aatamubaason kashshitoso? Ha'oos ma'baason arkissinaas harmutak neen zoonsunak sinnamato aane aruwenoso? ");
INSERT INTO jnjl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ese ne harmu beyneesiknawa xiiqi ephneesikna Ha'oosi gi'newa futoni mangsuni kar'ne yaafana wono neyista kar'ni ke'oos arkunaktu zagifatwa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ha'oos isarba isarbaasik wostobaasimato imanawa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ma'a wostooson chimme wostet ulfina; addanewa koi'ba foonto foone sholsefe baassok koi'ba foonto kaa imana. ");
INSERT INTO jnjl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Sinuntano baasso teetaasik ke'ni wuza sholsefe baassok, futoosik ajajamonoy manguusik ajajame baassosta Ha'oni gi'newa Ha'oni mangsuni kar'ne yoona. ");
INSERT INTO jnjl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mangu wuza zagsefe Ayhudni meyaasta sinun Aazabni meyaasta shananewa rakkone yoona. ");
INSERT INTO jnjl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Sinuntano ma'a wuza wostesefe baasso Ayhud meyak sinun Aazabni meyak galata, ulfina dey naga imtona. ");
INSERT INTO jnjl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ha'o asuni meeni ganesi aane korifa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Museniki kamo imte tumabesi foonto boor'a wostesefe baasso zuuttere Museniki kamo imte tumbesi aafa sinfanaknu tishiseterwa. Sinuntano tumabesi feen boor'a wostesefe baassosta es tumaasimato mangsu katona. ");
INSERT INTO jnjl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Es bari boor'a Ha'oosi sinak ooko sinniis tumaason odere wostota feeshife baassoteno odere wostota feeshunoy baassotewa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Museniki kamo imte tumbesi foonto Aazabni meya testobesiisik tumaas ajajefana barontu zagsefe. Es bari boor'a tumabesi tishifanaknu nibbesiissi fa tumaasik zagsonek sholsi baron arseter. ");
INSERT INTO jnjl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Es bar dey besifanaas tumaas ajajefana bar zuuttera baasso nibaassi faar sinbaasonwa. Dey kanubesiis zaala maker. Isa isa wono kanubesiis baassotin we'er; isa isa wono dey aane we'efa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Es bar dey ammanon kessa bestonaas han makefana misirachchuni kaamaasik Ha'oos Kiristoos Yesusniki kamo asuni meya wostesefe aacho wuzaasta mangsu kar'fana wonowa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ne dey: «Ta Ayhudwa» iyaat tumaasik teetefaat. Ha'oosir sinneesik dey ge'fatwa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ne Ha'oosi fiqadinon aritar. Tumaason aritar sinna boor'a ma'aron zaguuson aritarwa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ta: «Aaftishuni meyanon zoonsinar; talmaassi fe baassok dey chaarefwa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Arunoy baassok leejji imnar; daaga naanggotaason assinar» yifat. Esiisimato dey: «Tumaasi aruknawa futokna tuumma faanarwa» yifatwa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Eeka oomiisin assifat ne teetaason awuni boor'a assu beyisso? Ne: «wiisotiita» yifat wiisefatoso? ");
INSERT INTO jnjl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ne: «Gerkesatiita» yifat gerkesfatoso? Ne koo'looson oomtefaat betemeqdesiison bo'efatoso? ");
INSERT INTO jnjl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ne Ha'oosi tumanon aruk ge'fat; sinuntano bari tumaason bokok Ha'oosik ulfina aane imfe. ");
INSERT INTO jnjl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Esiis dey: «Nitto Ayhudni meeni boor'a Ha'oosi suna Aazabni sinak mechefa» yistera tichchenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Haarkoni kunaas waagba foonaas tumaason zagitar sinfaananewa. Sinuntano tumaason boketar sinfaanane haarko kunnees haarko kunnoytar sinnatu faadtona. ");
INSERT INTO jnjl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Es bari boor'a haarko kunnoy Aazabni meeni keeniis tumaasi ajajinon zagir sinfaanane haarko kunu beybaas haarko kuni sinnatanoso faadtonari? ");
INSERT INTO jnjl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ne tichchera fa tumane feen dey haarko kunar sinfaat tumaason boker sinfaatane ashak haarko kunnoy sinfaat tumaason zagife Aazabni meeni keeniis neyista mangsu kar'eterwa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ese sunak Ayhud sina bar futoni Ayhudtewa. Esiisimato geroki biistefa ashni haarkoni kunuus futoni haarkoni kunutawa. ");
INSERT INTO jnjl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Futoni Ayhud sikalobaassik Ayhud sina barwa. Futoni haarkoni kunuus Ha'oni Ayyanak sinfa nibni haarkoni kunutano tumaassi tichchenaasimato ashni haarkoni kunuustawa. Es effetena asus dey galata ephpheteefenaas Ha'ooskintano asunikintawa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Eekin Ayhud sinaas awu ke'nirinso? Haarkoni kunuus waagba aambanso? ");
INSERT INTO jnjl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Futoosik Ayhud sina showo ugnak ke'arwa; arki chowaas Ha'oos kaambaason Ayhudni meyak adara imbaaswa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Eekin Ayhudni meyaassin isa isa meya amantobesi foonto sinefaatene baasso amano beyaas Ha'oosi amanamtonon waagba turuksuniroso? ");
INSERT INTO jnjl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Isanne aafa turuksuna wuza! «Kaamneestan kabi chowa ne futowa; gumaneesin dey malatera dawotawa.» yistera tichchenaasimato asu zuuttere eshinynya sinfenaknu Ha'oos futo sinun. ");
INSERT INTO jnjl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Sinuntano inno mangsuus Ha'oosi ookonon besunir sinfaanane awu unirinso? Ha'oos inno mangsuusi boor'a innotin ke'ifaanane bar futoni mangsu aane kar'fa unoso? Han baron makefanaas asuni safaranimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Isanne ekkatawa; ekka sinfaanane Ha'oos aakkak han daasta mangsu kar'nirin? ");
INSERT INTO jnjl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Sinuntano ta eshinynya sinaas Ha'oosi futonon ammanon besira ulfinbaasi arkunon besunir sinfaanane eekin ta boor'inynyanimato awuni boor'a tayista mangsu katonirinso? ");
INSERT INTO jnjl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Isa isa asuni meya: «Ma'a wuza dananik mangu wuza zaguni» yira assinarne faaron zagire taan malatesefe. Es bari boor'a es effetena asuni meyaasta katoni mangsuus likkiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Eekin inno Ayhudiis Aazabni meyaastan denalo sinni unoso? Isanne indaanewa. Asuni meya zuuttere Ayhud sino Aazab sinefeknu boor'besi faanar sinetematotu zeemma nittok assiniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Matsafaassi: «Isa ooko asunu aafe; isarnu aafewa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Yaadatba feenar oonu aafe; Ha'ooson sholefer isarnu aafe. ");
INSERT INTO jnjl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Zuuttambesiise ugnaastan shaatesete; isarik ke'nor sinete; ma'aron zagifer oonu aafe; isarnu aafe. ");
INSERT INTO jnjl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Asuni miir'oni mangu kaama makok; noonobesiis gachchera kuni moogane faarwa; terumbesiisiktu eeshshisefe; Terumbesiisi wolla dey zawuni kewanimato asuni miir'er. ");
INSERT INTO jnjl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Noonobesiis erwiyaknawa suqarokna tuumma faar. ");
INSERT INTO jnjl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Wochobesiis asuni woruk tapter. ");
INSERT INTO jnjl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ugunbesiista tishunewa shaantune faar. ");
INSERT INTO jnjl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Nagani ugnaason aane arsefe. ");
INSERT INTO jnjl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ha'ooson aane digsefe» yistera tichchenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Museni tumaasi ajaji makefanaas tumaasi daakalo feese baassotin sinnamato arifeni. Es bari boor'a asuni meya ephphe maksone wuza tishina boor'a shaakkisefe. Daa zuuttambaase Ha'oosi mangsuni kar'ni sikalosiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Es bari boor'a oonu Ha'oosi sina tumaason zaguk aafa ooko sinanawuza. Tumaaski kamotu boor'aas artefa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Sinuntano hash Ha'oos asuni meyanon ooko zaguna ugnaas tumaas sholsunoynaron ammanon bestewa. Esiis dey Museni tumaassinawa raajjuni meyakinna zaala makte. ");
INSERT INTO jnjl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Es bari boor'a Ha'oos isa koruba foontonon Yesus Kiristoosnik amanefe baasso zuuttere ooko sinonek zagi. ");
INSERT INTO jnjl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Asuni meya zuuttere boor'a wostesete; Ha'oosi ulfina dey baassostan yo'i. ");
INSERT INTO jnjl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Es bari boor'a asuni meya zuuttere Kiristoos Yesus zagina furiiski kamo baak Ha'oosi otmaktu ooko sinone. ");
INSERT INTO jnjl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Ha'oos Yesus Kiristoosnin maa'a zagira imnaas barik amanefe baasso zuuttere harinbaasik boor'besiisi fakiyanon danonekwa. Ha'oos es baron zaginaas fakibaasik zeemoti zagte boor'aason ke'unoy beynaas bari futoni mangsuni kar'aason ammanon kisira besunakwa. Han neyaassik dey Ha'o teetbaasik ooko sinbaason besinaas Yesus Kiristoosnik amanefe baassotin zuutira ooko zagubaasikwa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Eekin teetoni wuzni awu faarinso? Isa wuzaknu teetonik aafawa chimani wuza. Teeto beyaniis awuni boor'anso? Museni tumaason zagifeni boor'anoso? Indaanewa. Sinuntano amantokwa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Es bari boor'a Ha'oos asu ooko sinanak zagifanaas bar tumaasi ajajinon zagina boor'a sinnoynaron amantok sinbaasontu yaadatefeniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Wedey Ha'oos Ayhudni meenir koi'banoso? Aazabni meyak dey Ha'otanoso? Futoosik Aazabni meyak dey Ha'owa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ha'oos isarwa; Ayhudni meyanon sinun Aazabni meyanon amantok ooko zaguniis barwa. ");
INSERT INTO jnjl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Eekin amantoni boor'a tumaason shaaronir unoso? Indaanewa; zaggiratu oodaniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ese ashak abani sina Abraham daniwa uni wuza aambanso? ");
INSERT INTO jnjl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abraham ooko sinnaas wostok sini sinfaanane teetona wuza danana kabawa. Sinuntano Ha'oosi sina teetok aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Korto matsafaas: «Abraham Ha'ooson amante, amantobaas dey ooko sinna faadte» yifatanoso? ");
INSERT INTO jnjl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Wosto wostefe asu barik sholsu wostoni waagaasontu daniteno baak imte imatawa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Wostok dananawa unoy boor'ni meyanon ooko zagifa Ha'oosik amanefaanane amantobaas ooko sinnatu faadtona. ");
INSERT INTO jnjl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dawit teetbaasik Ha'oos wosto foontonon ooko zagira faadina asus awune faaron suusto sinbaason besuk: ");
INSERT INTO jnjl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Mangsubesiis ‹feeshun› yistena baassonawa boor'besiis tishiktena asuni meena suustowa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Daamiis boor'baason faadunoyna asu suustowa» yi. ");
INSERT INTO jnjl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Eekin Dawit makena es suustoos haarko kune baassok koi'bangwa wedey haarko kunnoy baassokneeninso? Haarko kunnoy baassokneengwa. Abraham Ha'oosik amanena boor'a amantobaas ooko sinna faadte yiniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Eekin Abraham amantobaas ooko sinna faadtenaas aagenso? Haarko kunnoyfeeningwa wedey haarko kunfaninso? Haarko kunnoyfeentano haarko kunnanneentawa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abraham zeemme Haarko kunnoyfeen amantobaas ooko sinna faadtenamato aruna mallato sinanaktu haarko kuni. Es bari boor'a Abraham haarko kunnoy amanoni baassoknawa amantobesiis ooko sinna faadtona baasso zuuttambesiise asikna abawa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Esiisimato Abraham haarko kune baassok dey abawa. Haarko kune baassok aba sinnaas dey haarko kunete boor'a koi'ba sinnoynaron bar haarko kunnoyfeena kabaasik fa amantobaasik zoonustesefe baassokwa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abrahamniknawa basa zalaasikna han daason warasonak Ha'oos abdi imnaas amantok danna ookosiktano tumaason zagina boor'atawa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Abdiison warasoniis tumaason zagi baasso sinefaatene amantoos waagba aafa foona wuza. Abdiis dey waagba foontotu sinana. ");
INSERT INTO jnjl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Tumaas Ha'oni gi'atu ephpha yaafa. Sinuntano tuma tishifaanane tumaason zagunoy aata aafa foona wuza. ");
INSERT INTO jnjl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Es bari boor'a abdiis yerenaas amantoostawa. Es abdiis dey Abrahamni zala zuutira Ha'oosi otmak imter sinbaas es barik artewa. Esiis dey tumaasik zoonustefe asuni meyak koi'ba sinnoynaron Abrahamniisimato amane baasso zuuttambesiise asikwa. Esiisik Abraham inno zuuttamniise asik abawa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Abrahamni chowaasik: «Neen showo asuni zalaasik aba zaginwa» yistera tichche. Es abdiis Abrahamnik imtenaas kiti asuni meyanon kitun kabgifa Ha'oosiknawa foontoson faar zagifa Ha'oosikna amanena boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abraham zalnees akamanon showona yistera maktenaasimato showo asuni zalaasik aba sinanak abdik amanenaas isa abdi zaguk chimtonoyna wuzaasikwa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abraham woggabaas tiya kar'a faar sinna boor'a ashbaasik hopire kitune feer sini. Koonuk dey aafa chimanawuza sinnamatonawa asuba Saara dey aafa koonuna wuza sinnamatona arifenaknu amantobaasik aane hopuwe. ");
INSERT INTO jnjl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Amantobaasik zag sinnetu Ha'oosik ulfina imiteno Ha'oos imna abdiisik isanne ek hang aane uwe. ");
INSERT INTO jnjl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ha'oos bar imna abdiison zagunir sinnamato tuuma nibak amanere feerwa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Es bari boor'atu Abrahamni amantoos ooko sinna faadte. ");
INSERT INTO jnjl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Sinuntano «Ooko sinne faadte» yistera tichche kaamaas tichchenaas Abrahamnik koi'ba sinnoynaron; ");
INSERT INTO jnjl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Innokneengwa; Daamni Yesusnin kitun kabgi Ha'oosik amanefe innok dey amantoniis ooko sinna faadtonawa. ");
INSERT INTO jnjl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Es Daamni Yesus inno boor'aasik kituk aattere imtere innotin dey ooko zaguk kitun kabiis barwa. ");
INSERT INTO jnjl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ese inno ooko sinaason danniis amantok sinna boor'a Daamni Yesus Kiristoosniki kamo Ha'oosneen ane nagani faar. ");
INSERT INTO jnjl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Han amantok zagira faani Ha'oosi otmasi giriniis barik sinna boor'a abdik Ha'oosi ulfinanon haa'er sinniisik teetefeni. ");
INSERT INTO jnjl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Es bar bar sinnoynaron shanaassin chima bester sinnamato arini boor'a ephpha taafeni shanaasik teetefeni. ");
INSERT INTO jnjl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Fakiyaassik fatanaason chima; chimaassin dey abdi bestefawa. ");
INSERT INTO jnjl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Innok imte Korto Ayyanaaski kamo Ha'oosi keeshtanaas nibniissi tuumna boor'a innok imte abdiis aafa iishshuna wuza. ");
INSERT INTO jnjl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Inno hopi sinna faani Ha'oosi wona kar'fana kabaasik Kiristoos boor'ni meyak kitiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ookoni edde kituni asunin dana akamanon rakkowa; Sinfanaknu ma'a asuni edde kituk chimni asu awuzakne bestonak chimana. ");
INSERT INTO jnjl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Sinuntano inno boor'bare yere asu sinna faani Kiristoos inno eddeessi kitiwa. Es bar dey Ha'oos innotin keeshtena keeshtambaas awune fa akama sinnamatotu besifa. ");
INSERT INTO jnjl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ese inno ooko sinniis Yesus Kiristoosni hannaasik sinfaanane dey daysira Ha'oosi gi'sin fui'tok chimaniis barki kamowa. ");
INSERT INTO jnjl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Inno Ha'oosi guma sinna faani bari Naasa kituk barneen ane ganeniwa. Hash Ha'oosneen ane ganeninneen orfo dey daysira basa kaaski kamo faruni. ");
INSERT INTO jnjl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Es bar koi'ba sinnoynaron; Ha'oosneen ane ganooson danniis Yesus Kiristoosniki kamo Ha'oosik teetoniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Isa asuniki kamo han daasta boor'a ya. Es boor'aaski kamo dey kitu ya. Esiisimato dey asu zuuttere wostena boor'baasik kitu asu zuuttambaase asiista ya. ");
INSERT INTO jnjl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Museni tumaas imtonoyfeen zeemma boor'a han daasta faar. Sinuntano tumaas tishifaanane boor'aas boor'ane faar sinna aane faadtefa. ");
INSERT INTO jnjl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Sinuntano Addamniisimato tumaason aatak boor'a wostonoy asuni meyanonnu fu'onoy kitu Addamniistan kabira Museniki kar'a asu zuuttambaase asiista ha'suni hugnaba dani. Es Addam hanneenti yooni Kiristoosnik besowa. ");
INSERT INTO jnjl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Sinuntano Ha'oosi otmani imaas asusa boor'nimatotawa. Isa asuni boor'aasik showni meya kitisetemato dey Ha'oosi otmaknawa isa Yesus Kiristoosniki kamona beste Ha'oosi ima showoni meyak dayistera imtewa. ");
INSERT INTO jnjl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Esiisimato baak Ha'oos imna bari imaas teshshena otmaasi gaana isa asusa boor'a ephpha yaana gaanaasne faartawa. Isa asusa boor'ak imte mangsuni kar'aas ke'o ephpha ya. Showo boor'aasik baak imte imaas ooko ephpha ya. ");
INSERT INTO jnjl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Isa asusa boor'aasik kitu asu zuuttambaase asiisata ha'suni hugna dannanneen tuumma fu'te Ha'oosi imanon ephphe ooko sine baasso zuuttere isa asu sina Yesus Kiristoosniki kamo merere kaak taattosone. ");
INSERT INTO jnjl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ese isa Addamni boor'aas ke'oni mangsuni kar'a asu zuuttambaase asiista ephpha yaanamato isa Kiristoosni ooko wostoos showoni meyanon ke'oossin birmadumma kisira kaa imana. ");
INSERT INTO jnjl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Isa asu sina Addamni ajajamto beyaasik showoni meya boor'besi faanar sinetemato isa asu sina Kiristoosni ajajamtoosik showoni meya ooko sinone. ");
INSERT INTO jnjl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Boor'a arkunaktu tuma ya. Sinuntano boor'aas arkinamato Ha'oosi otma dey akamanon arki. ");
INSERT INTO jnjl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Es bar dey sinnaas boor'aas kituki kamo asu zuuttambaase asiista taattenamato Daamni Yesus Kiristoosniki kamo koi'ba foonto kaa bestonak Ha'oosi otma ookooson imanak taattonawa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Eeka awu unisso? Ha'oosi otma arkunak boor'a wostet fooniroso? ");
INSERT INTO jnjl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Indaanewa; Inno boor'aasik kitini; eekin aakkak boor'a wostet foonirinso? ");
INSERT INTO jnjl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Kiristoos Yesusneen ane isar sinak haphukte inno zuuttera bar kitinaasimato kitubaason besuk haphuktoniison aane aruwetinoso? ");
INSERT INTO jnjl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Haphuktok barneen ane kabbartefeni kabaasik basa kituuson besiniwa. Es bari boor'a Kiristoos Abaasa ulfinak kitun kabinamato inno dey gaddo kaak fooniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kitubaasik ekkak barneen ane isar sinnineen esiisimato kitun kabubaasik dey barneen ane isar sinaniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Innoosta hugna dana boor'aas tishunaknawa boor'aasi boz sinne fooniis feeshanakna kur'u testoniis Kiristoosneen ane suuttenamato arifeniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kiti asu boor'aasi ha'suni sikalosin birmadumma kesiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Esiisimato Kiristoosneen ane kitifaanine barneen ane dey kaak foonimato amnefeniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kiristoos kitun kabubaasik hepsa aafa kituna wuza sinnamatonawa kituus dey basaasta ha'suni hugnaba aafa sinnamatona arifeniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Bar kitifena kabaasik boor'a basaasta ha'suni hugnaba foonoynamato hepsa dey wolunoynamato zagire isarga kitiwa. Hashnu kaak feena foobaas Ha'oosikwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ese nitto kiti asune faaron boor'aassin oor kesetimatonawa Kiristoos Yesusniki kamo dey Ha'oosik kaak faatimatona faaduti. ");
INSERT INTO jnjl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ese boor'aas kituni atuntiista ha'suni hugnaba foonaknawa ashni eenantosikna ajajamer nittotin zagunak ma'i utiitawa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Esiisimato atuntiisi billitinon mangu wuza wostoni koda zagira boor'aasik ajajamonak zagutiita. Sinuntano kitun kabira hayew sinetimato zagira teetnitiison Ha'oosik imti. Atuntiisi billitinon zuutira ooko sina wuza wostoni koda zagira Ha'oosik ajajamonak zaguti. ");
INSERT INTO jnjl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Hash nitto faaseti foos Ha'oosi otumani sikalositano tumaasi daakalosi sina beyna boor'a boor'aas nittotin ha'sunak aane sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Eeka awu unirinso? Museni tumaasi sikalosi sinniis feeshfaan Ha'oosi otumani sikalosi sinni boor'a boor'aason wostoni unoso? indaanewa! ");
INSERT INTO jnjl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Isa asunik bozba sinfaat ajajamok teetnitiison imfeti kabaasik es ajajamefeti asusik basa boz sinnitiison arsefeti. Esiisimato boor'aasik ajajamefaatine kitu nittoosta ephpha yooni boor'aasik bozbaytu sinatiwa. Sinuntano Ha'oosik ajajamefaatine ooko sina wuzason danatiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Nitto zeemo sinak boor'aasi boz sinnatu faasetiwa. Sinuntano hash ephpha taati aruuson nibnitiissin kamo ajajamontiisik Ha'oosik galata sinfawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Boor'aasik boz sinaasin birmadumma kessa ooko sina wuzaasi boz sintiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ta han ekka asunik galoni noonok makefanaas nitto safaraasi hopitan kabi chowawa. Zeemo sinak atuntiisi billiti zuuttera kiinnewa mangune asi boza zagira imesetimato hash dey atuntiisi billitinon zuuttira korto sinanak ookoosi boza zagira imtiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Boor'ni boz sinna faati kabaasik ooko sina wuzason zagutik giddinti aafawa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Eekin es kabaasik aro ke'ni wuza dantiso? Hash nittotin iichuni wuzatano isa ke'ni wuza aane danetiwa. Es bari ko'aas dey kituwa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Sinuntano hash boor'aasik boz sinaasin birmadumma kessa Ha'oosi boz sinnitiisik danati buu'aas korto sinawa. Es korto sinaasi ko'a dey koi'ba foonto kaawa. ");
INSERT INTO jnjl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Boor'aasi wostosin bestoni waagaas kituwa. Sinuntano Ha'ooskin imtoni imaas Daamni Kiristoos Yesusniki kamo koi'ba foonto kaawa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Aytaasakitono! Han baron aane aruwetinoso? Makefanaas tumaason arife asuni meyakwa. Tumaas asuniista ha'suni hugnaba foonaas asu kaak feefena kabaasik koi'bawa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Isa beso nittok makona; Girira di asu teegobaas kaak feena kabaasik barneen ane tumaasik taatera diirwa. Sinuntano teegobaas kitifaanane es taatena tumaassin birmadumma kesiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Es bari boor'a teegobaas kaak feen oomniki girifaanane soolewa yistefa. Sinuntano teegobaas kitifaanane barneen ane taatena tumaassin birmadumma kesi sinna boor'a oom asuniki girifaanane soole aafa ustona wuza. ");
INSERT INTO jnjl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Aytaasakitono! Nitto chowaas dey esiisimatowa. Nitto Kiristoosni atuni billiti sineti boor'a kituk oor kesane faaron tumaastan oor kestiwa. Es bari boor'a Ha'oosik wostok gaana gaananik kitun kabi Kiristoosni keen sinetiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ashni fiqadiisik faani kabaasik tumaas kabgifana mangu eenantoos kituni gaana gaananik atuniisi billitisi wostet faar. ");
INSERT INTO jnjl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Sinuntano hash innotin taar'a fa tumaassin kitira oor kesni boor'a tumaasi taatosin birmadumma kesniwa. Es bari boor'a hanneen ekalo wostoniis gaddo sina Korto Ayyanaasi ugnaktano zeemmati tichche kur'u tumaasi ugnaktawa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ese awu unirinso? Tumaas teetbaasik boor'anoso? Indaanewa; Sinuntano boor'a awu sinnamato arunak zagiis tumaaswa. Tumaas «Eenantotaata» uu shaki sinfaanane eenanto awu sinnamato aruni kabatawa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Boor'aas tumaaskin ya ajajiisik ugna danna eenanto tayissi foonak zagi. Sinuntano tumaas tishifaanane boor'aas kitu wuzawa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Zeemma tumaas imtonoyfeen ta hayew sinnatu faafawungwa. Sinuntano tumaasi ajaji yaananneen orfo ta kitifaana boor'aas kaa dani. ");
INSERT INTO jnjl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Kaa imanak imte tumaasi ajaji tayista kitu ephpha yawa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Boor'aas tumaasi ajajiiski kamo ugna danna taan eshi. Ajajiiski kamo dey taan wori. ");
INSERT INTO jnjl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Tumaas kortowa; ajajiis dey korto, futonewa ma'arnewa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Eekin han ma'ar sina wuzaas tayista kitu ephpha ya unoso? Indaanewa! Sinuntano boor'aas boor'a sinna ammano bestonak ma'a wuzaaski kamo kitu tayista ephpha ya. Esiisik boor'aas ajajiiski kamo boor'aas awune fa mangu sinnamato arte. ");
INSERT INTO jnjl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tumaas Ha'ooskin yaar sinnamato arifeniwa. Sinuntano ta boor'aasik boz sinanak kessa waagte asha mayowa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ta zagifana baron aane arifat. Shunfana wuzason zagu shakaatu oomtefana wuzason zagifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ese ta zagifanaas zaguk sholonoyna wuzason sinnanneen tumaas ma'ar sinbaason makonawa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Zaguk sholonoyna wuzason zagifaas tayissi fa boor'aastano tatewa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Tayissi wedey ashnaassi fa haalasi isanne ma'a wuza aafa sinnamato arifan. Ma'a wuzni zaguk sholefanaknu es ma'a wuzason zaguk aane chimfat. ");
INSERT INTO jnjl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Zagunak sholefana ma'a wuzason aane zagifat. Sinuntano zaguk sholonoyna mangu wuzasontu zagifan. ");
INSERT INTO jnjl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Zagunak sholonoyna mangu wuzason zagir sinnanneen es baron zagifaas tayissi fa boor'aastano tatewa uwa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Es bari boor'a ooma tuma tayista wostet faanamato biingwa. Ma'a wuzason zagunak sholefaat mangu wuza zagunak tugtefan. ");
INSERT INTO jnjl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Sikalonaas Ha'oosi tumaktu girefa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Sinuntano kanunaassi fa tumaasneen neebefaafa atunaasi billitisi wostefa boor'aasi tumak taato taan zagifa ooma testoni safara tayissi faanamato biingwa. ");
INSERT INTO jnjl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ta awune faaron miir'am asunso? Han kituussi taamfa ashnaassin oo taan fu'onak chimnirinso? ");
INSERT INTO jnjl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Daamni Yesus Kiristoosniki kamo Ha'oosik galata sinfawungwa. Ese ta teetnaasi kanuk Ha'oosi tumak ajajamer sinfaat ashnaasi haalak boor'aasik ajajamer siningwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Es bari boor'a Kiristoos Yesusnik fe baasso haye aafa baassosta mangsu katona wuza. ");
INSERT INTO jnjl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kiristoos Yesusniki kamo bestefa kaa imfa korto Ayyanaasi tuma boor'aassinnawa kituussinna birmadumma taan kisiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Asuni haalani hopitan kabi chowa tumaas zaguk chimnoynaason Ha'oos zagiwa. Ha'o bari Naasin boor'ba faana asune feer zagira boor'aasik wosi. Ashbaasik dey boor'aason mangsu kar'e tishki. ");
INSERT INTO jnjl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Es baron dey zaginaas ashni safarak sinnoynaron Ayyanani safarasimato feefe innoki kamo futo sina tumaasi ajaji wostota feeshanakwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ashni safarasimato feefe baasso ashni safarasontu safarsefe. Sinuntano Ayyanani safarasimato feesefe baasso ayyanani safarasontu safaresefe. ");
INSERT INTO jnjl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ashni wuza sina baron safaroos kitutu ephpha yaafa. Sinuntano Ayyanani wuza sina baron safaroos kaanewa naganetu imfa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Ashni wuza sina baron safarefe asu Ha'oosi tumak aane ajajamefe; ajajamonak dey aafa chimanawuza sinna boor'a Ha'oosi gumawa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ashni eenantok zoonustesefe baasso Ha'ooson girsuk aafa chimone wuza. ");
INSERT INTO jnjl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Sinuntano nitto Ha'oosi Ayyana sikalontisi faar sinfaanane Ayyanani safarasiktano Ashni eenantoosimato aafa footi wuza. Kiristoosni Ayyana basaassi foonto asu Kiristoosni keentewa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Sinuntano Kiristoos nittoossi feefaanane awune faaronnu atuntiis boor'aastan kabi chowa kitunir sinfanaknu Ha'oos nittotin ooko zagina boor'a ayyanantiis hayewawa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Yesusnin kitun kabgi Ha'oosi Ayyana nittoossi faar sinfaanane Kiristoosnin kitun kabgi Ha'oos nittoossi fa Ayyanabaaski kamo kituni atuntiisik kaa imanawa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Es bari boor'a aytaasakitono! Giddisuni wuza innoosta faarwa; sinuntano es giddisuni wuzaas ashni safarak fooniktawa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ashni safarak fafaatine kitutirwa. Sinuntano korto Ayyanaasi hugnak ashni wostontiison woraatine kaak footiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ha'oosi Ayyanak zoonustefe baasso zuuttere Ha'oosi naanggotawa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Es bari boor'a: «Aabba! Abaniiso!» yira teegoti naawba sinati Ayyanatu ephpha taatitano digak fook hepsa wolla boz sinni ayyana aane ephphatoowetiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ha'oosi Ayyana inno ayyanaasneen ane sinna Ha'oosi naanggota sinniison innok zaala makefawa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ese Ha'oosi naanggota sinfaanine barir sina baron warasoniwa; Kiristoosneen ane dey warasonir; hash basa shanaason haa'er sinfaanine woli dey ulfinbaason haa'er sinaniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Hashti fa shanaas hanneenti innok ammanon bestonak fa ulfinaasneen ane hoossifeni kabaasik isa wuzaneennu hoossunik aafa chimani wuza zagiratu faadifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Testo zuuttera Ha'oosi naanggotni ammanon kesse bestooson akama kaltanaktu oodtifawa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Testo zuuttambaase ke'nor sinanak mangsu barista katewa. Esiis dey bari teetni shunak sinnoynaron abdik oodanak zagi Ha'oosi fiqadikwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Es abdiis dey testo zuuttambaase teetbaasik tishuni bozoossin birmadumma kessa Ha'oosi naanggotak hoore birmadummanewa ulfinne asin haa'er sinanamatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Testo zuuttambaase isarik hawungneen kar'a keektoni merok oottera haanet foobaason arifeniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Sinuntano haanet fa testo bar bar koi'batawa; tesuni ima sina Korto Ayyanaason ephphete inno dey atuniisi furi sina Ha'oos ammanon kisira besunak fa Ha'oosi naanggota sinaason abdik oodet sikaloki atuniissi haanettu faaniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Inno fariniis es abdiisikwa; sinuntano abdi zagifeni wuzaas biister sinfaanane abdi sinbaas feesharwa. Aafak biistefa baron oo abdi zagunirinso? ");
INSERT INTO jnjl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Sinuntano aafak biifeni wuzason abdi zagifaanine fakiyak oodani. ");
INSERT INTO jnjl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Esiisimato aakkak shiiphok chimanimato aane arifeni sinna boor'a Korto Ayyanaas hopiniison argasuna. Korto Ayyanaas teetbaasik kaamak wollok chimnoyni haanok innok noonona. ");
INSERT INTO jnjl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Asusa nibanon tu'nira biifa Ha'oos Korto Ayyanaasi safara awu sinnamato arir. Korto Ayyanaas kortoni meyak noonefanaas Ha'oosi fiqadinimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ha'ooson shunfe baassoknawa bari safaraasimatona teegte asuni meyakna Ha'oos zuuttambaase asin ma'arik zagunamato arifeniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Es bar dey sinnaas zeemma arina baasso Naasa gitononnawa Naas dey showo ayni meeni ganeyaassin uuzza sinanak Ha'oos zeemma buggina boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Zeemma korina baassotin teege; teegena baassotin ooko zagi; ooko zagina baassotin dey ulfinsi. ");
INSERT INTO jnjl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Eekin han wuzason awu unirin? Ha'oos innoneen ane sinfaanane oo innotin tuuga'ok chimnirinso? ");
INSERT INTO jnjl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ha'oos bari Naasik kenashtonoy innokwa iyaat aatira imnanneen aakkak zuuttambaase asin Naasneen ane waagba foontonon ima beynirinso? ");
INSERT INTO jnjl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ha'oos korina baassotin oo malatok chimnirinso? Ooko zaguniis Ha'ooswa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Oonso baassosta mangsu kar'niri? Kiristoos Yesus baassosta mangsu kar'niroso? Bar innokwa iyaat kiti; kitun kabire aba Ha'oosi ho'itta di; innok natifees dey barwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kiristoosni keeshtanaastan oor kisuk chimniis oonso? Rakko wedey shananoso? Kabugto wedey makanoso? Atatu sinangwa wedey adagangwa? wedey siifonso? ");
INSERT INTO jnjl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Es dey: «Ne boor'a wonaason zuutira kitusneen ane neebefeni; shuktoni fantusiktonimato faadtefeniwa.» yistera tichchenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ese innotin shuna Kiristoosnik es wuzason zuutira merera innotin neebera merefa wuza zuuttambaase asiistan denalo sinaniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Es bari boor'a kitunu sinun, kaanu sinun, Ha'oosi wosiyanu sinun, ha'suni hugnabesi faana baassonu sinoto, hashti fa bar sinun, hanneenti yooni bar sinun, hugnaba faana bar sinun, ");
INSERT INTO jnjl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","Tegaas sinun, daaksoos sinun, aaffa testoosnu sinun Daamni Kiristoos Yesusnikin danni Ha'oosi keeshtanatan oor kisuni wuza aafa sinnamato gasasiratu fawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Kiristoosneen ane faafaat futooson makefan; Aafa dey eshana wuza. Ha'oosi Korto Ayyanak zoonustefa kanunaas dey aafa eshana wuza sinnamato taak zaala makona. ");
INSERT INTO jnjl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Akama suumonewa ko'unoy rakkone nibnaassi faarwa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ashak koonta sina inno meyakwa iyaat ta Kiristoosnistan oor kessa Ha'oosi erwiya tayista kar'faanane shunana kabawa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Baasso Israelni meyawa; Ha'oos dey baassotin naanggotba zagiwa. Ulfinbaason baassok ammanon kisira besiwa. Baassoneen ane dey teyya giri; tumaason dey baassok imi. Futoni Ha'oni shiiphosi sitirinon baassok besi; Abdini kaambaason dey baassok imi. ");
INSERT INTO jnjl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Baasso koontobesiisik asteserni abani meyakin yeeseterwa. Kiristoos dey ashak yeenaas baasso zalaassinwa. Bar zuuttambaase asi denalowa; Koi'ba foontonon dey suusto Ha'owa; Aamin! ");
INSERT INTO jnjl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Israelni zala zuuttera futoni Israelni meyata sina beyna boor'a Ha'oosi kaama shaartewa utawa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Esiisimato dey Abrahamni zala zuuttera Abrahamni naanggotawa utawa. Ha'oos Abrahamnin: «Zalnees teegtonaas Yisaqniki kamowa» yina boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Es bari boor'a ashak Abrahamnikin koontesete boor'a Ha'oni naanggotatawa. Sinuntano zala sinna faadtoniis abdini kaamaasi naanggotaas koi'bawa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Es bar dey Ha'oos imna abdini kaamaas: «Hawungti wogga han kabaasta yoona; Saara dey arqa naanin kophona» yifarwa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Es bar koi'ba sinnoynaron Ribqa asteserni abani sina Yisaqnin mano naanggotnin naanertefana kabaasik; ");
INSERT INTO jnjl_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Ha'oosi koru wostok sinnoynaron teegok sinbaason ammanon besunak hep naanggotiis koontobaasneen zeemma wedey ma'aronnawa mangunonna zagsobesiisneen sinak Ha'oos Ribqak: «Arkiis hateesik ha'ir sinanawe» yi. ");
INSERT INTO jnjl_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Esiis dey: «Yaqobnin shunin sinuntano Eesawunin oomten» yistera tichchenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Eekin awu unirinso? Ha'o korir uuk chimaniroso? Isanne Ha'oos korir uuk aafa chimani wuza. ");
INSERT INTO jnjl_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ha'oos Musenin: «Feeshun unak sholena baassotin feeshun una; kenashtonak sholena baassotin kenashtona» yiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ese han bar bestefanaas asuni fiqadiknawa wostokna sinnoynaron Ha'oosi fakiyakwa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Es bari boor'a korto matsafaasi Giphtsini taatoosa chowak: «Neeki kamo hugnanaason besuknawa sunnaas dey daa zuuttambaase asiissi artonak zagukna neen taassingwa» yifa kaama tichchewa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Es bari boor'a Ha'oos fakunak sholena baassotin fakuna; sholena baassotin dey nibbesiis chimanak zagunawa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Es bari boor'a: «Ha'oosi fiqadinon oonu tugga'ok aafa chimanawuza. Eekin bar asuni meyanon mangu wostobesiisik awuni boor'a wee'efasso?» yira taan mamsutar sinana. ");
INSERT INTO jnjl_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ne han asuso! Ha'oosneen karakkarotak ne oonso? Kodaas baron hooi'fe barin: «Awuniron taan ekka zagira wostetso?» unak chimniroso? ");
INSERT INTO jnjl_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Kodaason hooi'fe bar isa tesa ho'aassin isa kodaason ulfinnir, oomaason dey sinnoy wostota feeshanak zagire wostonak mabtiba aafanoso? ");
INSERT INTO jnjl_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ha'oos gi'baason besuknawa hugnabaason ammanon kissira besunakna sholefaat tishuk hoorera fa gi'ni asusakitonik akamanon faki sinfaananekaso? ");
INSERT INTO jnjl_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Dey zeemma ulfinak hoossina feeshu yina asuni meyak ulfinbaasi arkunon ammanon kisira besunak sinfaananekaso? ");
INSERT INTO jnjl_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Feeshun yina asuni meya dey Ayhudni meyaassin koi'ba sinnoynaron Aazabni meyaassin dey teegewa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Es bar dey raajju Hoseniki kamo ekka yistenamatowa: «Ta dara sinnoy baassotin: ‹Darata› yira teegona; shuntonoy daraasin dey; ‹Shunto› yira teegona. ");
INSERT INTO jnjl_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Baasso ‹Ta darate› yistere teegtesete dimaasta; ‹Hayewa Ha'oosi naanggota› yistere teegtosone.» ");
INSERT INTO jnjl_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Raajju Isayyas dey Israelni chowaasik ekka yit kaambaason teggire make: «Israelni naanggotaasi faada baarini fuutunimato arkifanaknu baassossin faruniis garo meya koi'besiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Daamiis woknoy taptak han daasta mangsu kar'ana» ");
INSERT INTO jnjl_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Esiisimato Isayyas: «Zuuttambaase asi denalo sina Daamiis; innok zala fu'o shaki sinfaanane; Sodomni katamaasewa; Gamorani katamaas tishinaasimato; inno dey tishuni kabawa» yit zeemme makewa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Eekin awu unirinso? Ooko sina wuzason danak wostonoy Aazabni meya ooko wuzason danetewa; es ooko wuzaas dey amantok bestefa barwa. ");
INSERT INTO jnjl_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Sinuntano ooko sina wuzason dananik zagifa tumaasik zoonustet fe Israelni meya tumaason oodak aane chimoto sinna boor'a ookooski hamme aane kar'oto. ");
INSERT INTO jnjl_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Es bar awuni boor'a ekka siniso? Ooko sina wuzaaski hamme kar'a beyetees baasso ooko sina wuzason danak sholsetees amantok sinnoynaron wostok sinna boor'awa. Es bari boor'a tuusa'suni shu'aasik tuusa'esete. ");
INSERT INTO jnjl_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Esiis dey: «Ese asuni meyanon tuusa'suni shu'a Siyonuk duusuna; Es shu'aas asuni meyanon tuusa'sira gansuni kaa'owa. Barik amanefe bar aafa iichchona wuza.» yistera tichchenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Aytaasakitono! Nibnaassi fa akama kaltanaasewa Ha'ooskiki tai'sit faana shiiphonaase Israelni meya farsonekwa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Aruus likki sina beybaastano baasso Ha'oosik kaambaasimato fooni koona baassossi faanamato ta teetnaasik zaala sinanawa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ha'oos asuni meyanon ooko zaguna ugnaason aane arsoto sinna boor'a teetbesiisi ookoni ugnaasiktu zoonustetetano Ha'oosi ooko ugnak aane zoonustosoto. ");
INSERT INTO jnjl_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Amanefe asu zuuttere amantok ooko sinanak Museni tumaas Kiristoosniistak yerewa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Tumaason oodak bestefa ookoosik Museni matsafaassi: «Tumaason zagife bar zuuttere kaak foonawa» yifarwa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Sinuntano Ha'oos asuni meyanon amantok ooko zagubaas ekka yistera tichchewa: «Nibneessi oo sama kesnirinso?» utaatawa. Esiis dey Kiristoosnin kessukwa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Wedey nibneessi «Tiir'oni dimaassi oo keronirinso?» utaatawa. Esiis dey Kiristoosnin kitun kabgukwa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Dey ekka yistera tichchewa: «Ha'oosi kaama teshnetu fawa. Dey noononeessinawa nibneessinatu fawa» Es kaamaas dey inno makefeni amantoni kaamaaswa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Yesus Daam sinbaason noononeesik zaala makefaatanenawa Ha'oos barin kitun kabginamato nibneessi amanefaatanena farutawa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Asu nibbaassi amanere ooko sinana; noonobaasik dey zaala makere faruna. ");
INSERT INTO jnjl_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Korto matsafaassi: «Barik amanefe bar zuuttere aafa iichchonawuza» yistenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ese isa Daamiis zuuttambaase asi Daam sinna boor'a Ayhudni meeni ganeyaassinawa Aazabni meeni ganeyasina oor oorba aafawa. Bar; barki shiiphsefe baasso zuuttambesiise asik otumbaason daysire imana. ");
INSERT INTO jnjl_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","«Daamiisa sunanon teegefe bar zuuttere farunawa» yistewa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Sinuntano barin amanonoy aakkak teegok chimone? Basa chowaason odonoy aakkak amanosone? Assinynya foontonon dey aakkak odok chimone? ");
INSERT INTO jnjl_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Assinynyani meya wostere hamonoy aakkak kaambaason assuk chimone? Esiis dey: «Misirachchuni oduuson maksefe baasso yoos aakka girsifaso!» yistera tichchenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Sinuntano Isayyas: «Daamiiso! Makeni oduuson oonso amaneri?» yire makenaasimato misirachchuni oduuson ephpheteese baasso zuuttambesiisetawa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ese amanto bestefanaas Misirachchuni oduuson odokwa. Es oduus dey Kiristoosni chowaasik maktefa kaamaaswa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Shakaan mamsungwa; eekin kaambaason aane odosoto unoso? Korto matsafaassi: «Kaambesiis daa zuuttambaase asiissi odte; makesete kaamaas daasi dilta kar'i» yistera tichchenaasimato futoosik odesetewa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Shakaan mamsungwa; dey Israelni meya kaambaason aane arsoto unoso? Ekka ustonoynamato Muse zeemme: «Kashisto daraasin koonotik zagira gaabbisisunawa; yaadatonoy daraasik dey nittotin haarsuna» yiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Raajju Isayyas dey: «Taan sholsonoy baassok besten; ‹Ha'ooski ayinso?› yire mamsunoy baassok ammanon besten» yit digonoy makewa. ");
INSERT INTO jnjl_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Sinuntano Israelni meeni chowaasik: «Ajajamonoy daraasnawa nuurife daraasna taaki yoonak wonaason zuutira kushunaason shongen» yifa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Shakaani dey mamsungwa; Ha'oos darabaasin ha'iyoso? Isanne aane ha'uwawa. Ta teetnaasik Israelni daani asuwa; Abrahamni zala sina Biniyamni keengwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ha'oos zeemma korina daraasin aane ha'uwawa. Korto matsafaas Eeliyasni chowaasik awu yinamato aane yaadatowetinoso? Dey Eeliyas Israelni daraasin awu yire malatenamato aane aruwetinoso? ");
INSERT INTO jnjl_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Es kabaasik Eeliyas: «Daamiiso! Raajjunesakitonin worsete; sho'aneesikitonon bogesete; ta dey ta ta fui'tengwa, taan dey worsonek sholsedifeer» yire feer. ");
INSERT INTO jnjl_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Sinuntano Ha'oos awu yiranso barik wolginari?: «Baal yistefa koo'loosik kaa'nonor naafun kum asunin taak fui'engwa» yiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Han neyaasik dey sinfanaknu Ha'oosi otmak kortere fui'ter garo feeseterwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ese bari koruus Ha'oosi otmak sinfaanane wostoktawa uwa; wostok sini sinfaanane Ha'oosi otma futonir sinana kabatawa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Eekin gaanbaas awu siniso? Israelni meya sholesete baron aane danoto; sinuntano kortese baasso danete; fui'te baasso dey nibbesiison chinisete. ");
INSERT INTO jnjl_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Esiis dey: «Ha'oos nibbesiison muumsi; es bari boor'a hawungneen kar'a aafbesi biinoynamato; odobesi odonoynamatowa» yistera tichchenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dawit dey: «Maddibesiis ephfa eshmiya; gansuni doo'a sinna baassotin rakkisifawungwa; zagsete manguus baassosta kar'fawungwa; ");
INSERT INTO jnjl_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Aafbesi biinor sinna talmon; geshobesiis rakkok wonna wonna kuupufawung» yiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Shakaani dey mamsungwa; Ayhudni meya gandesetees hepsa wolle kabsonoytematonoso? Indaanewa! Ayhudni mangsuusi boor'a Aazabni meya faru danetewa. Es bar dey sinaas Ayhudni meya Aazabni meyaasta koonosonek zagukwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Sinuntano Ayhudni meeni boor'aas han daasik eebba bestonak zagiwa. Baasso gandoos Aazabni meyak eebba siniwa. Ayhudni meya farsete sinfaanane eebbaas awune fa akama sinana kabanso! ");
INSERT INTO jnjl_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ese hash makonaas Aazab sina nittokwa, Aazabni meeni wosi sinnamato wostefana wostoos ulfina sinnatu taak bestefawa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Es baron dey zaginaas ta koon sina Ayhudni meyanon koonosonek zagunakwa. Es barik dey awuzakne baassossin isa isarin fatuk chimana sinana ukwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ha'o baassotin ha'ifana kabaasik ooma han daasi daraas Ha'oosneen ane ganenanneen Ha'oos baassotin ephpha taafana kabaasik awu sinana sinna nittok bestefaso? Es bar kitun kabune faarwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Isa tesa tushoossin tesuni bar Ha'oosik imtera korto sinfaanane, tushoos zuuttera kortowa; esiisimato isa i'oos tasbaas korto sinfaanane waay'baas dey kortotu sinana. ");
INSERT INTO jnjl_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Goorgu di bunaasi way'animato sina Ayhudni meya katere ha'tesetenneen nitto buur'u di bunaasi i'oni way'animato sina Aazabiis baasso eddesi girira es tasaas imfana eebbaason haa'er sinfaatine; ");
INSERT INTO jnjl_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Nitto Aazabni meya; waay'asimato katere ha'te Ayhudni meyaasta ge'atiitawa, Sinuntano nitto ge'efaatine waa'a waa'a sineti boor'a tasaas nittotin wor'anastano nitto tasaason wor'ak aafa chimati wuza sinnamato yaadatoti. ");
INSERT INTO jnjl_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Sinuntano: «Waa'asikito kiitera gandenaas ta bari edde girunakwa» uti sinanawa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Likkiwa! Baasso katere gandesetees amano beyobesisikwa. Sinuntano nitto chimma yeeretiis amaneseti boor'awa. Ese digotiistano ge'atik aane sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ha'oos testoosik waay'a sina Ayhudni meyak kenashto shakaanane nittok dey aafa kenashtona wuza. ");
INSERT INTO jnjl_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ese Ha'oosi garamanonnawa deessubaasonna biitwa. Deessubaason besifanaas gande baassostawa. Sinuntano garambaason besifanaas nittokwa. Es baron dey zagifanaas bari garamaasik chimma yerefaatinewa. Chimma yero shakaatine nitto dey katera gandetirwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ayhudni meya amano beyobesiissin wolsefaatene zeemoti katesete dimbesiista wolsonewa. Ha'oos zeemoti dimbesiista baassotin wolgunak chimanawa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Sinuntano nitto Aazabni meya testontiisik buur'u di bunaasi waa'a sinna faani nitto goorgu di buna sinnoy dimaasta tokto chimtetinneen han baasso testobesiisik goorguki bunni waa'a sina Ayhudni meya wolle zeemoti dimbesiista aakkak tokto beyone. ");
INSERT INTO jnjl_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Aytaasakitono!: «Inno aruwa» yit teetotitawa. Ta nittok makona isa aacho chowa faarwa; Esiis dey Israelni meyaassin isa isaas nibbesiis chimnaas Ha'oos teegena Aazabni meya zuuttere Ha'ooski wolsone kabaneengwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ese es barik Israelni darani meya zuuttere farusonewa. Ekka dey yistera tichchewa; «Fatunir Tsiyonun yoonawa; Yaqobni zala zuuttambaase asiissin manguuson tishkunawa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Boor'besiison tishkifana kabaasik; Baassoneen ane giruna; teyyani kaamaas haniiswa.» ");
INSERT INTO jnjl_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Israelni meya misirachchuni kaamaason ephphetoo beyobesiisik nitto Aazabni meyanon ke'ak Ha'oosi guma sinetewa. Sinuntano Ha'o baassotin korubaastan kabi chowa asteseriisi abani meeni boor'a baasso Ha'oosi zomowa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ha'oos korira otumbaasi imanon imnanneen orfo zagina wuzaasik safarabaason aane gaabbefa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Nitto Aazabni meya zeemo Ha'oosik ajajamonor sinna faatir. Sinuntano hash Ayhudni meya ajajamo beyete boor'a nitto fakiya daneti. ");
INSERT INTO jnjl_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Nitto fakiya danesetiisne faaron baasso dey fakiya danonek hash baasso Ha'oosik ajajamonor sinete. ");
INSERT INTO jnjl_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ha'oos fakibaason asu zuuttambaase asik besukwa iyaat asuni meyanon zuutira ajajamo beyobesiisi taato sinonek zagiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ha'oosi techumnewa arune awune faaron akamanso! Mangsuni kar'baas dey tu'nustonor; ugunbaas dey aane artefawa! ");
INSERT INTO jnjl_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","«Daamiisa safaranon arifer oonso? Barin kiitunir oonso?» ");
INSERT INTO jnjl_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","«Ha'oosik liqsaat liqsina baron wolgire ephnir oonso?» ");
INSERT INTO jnjl_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Zuuttambaase yaanaas barkin, Barki kamonawa bariknawa. Koi'ba foontonon ulfina barik sinfawungwa; aamin! ");
INSERT INTO jnjl_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ese aytaasakitono! Atuntiison Ha'ooson girsuni hayewa imanewa korto maa'ane zagira Ha'oosik imatik Ha'oosi garamak shiiphfawungwa. Es bar dey ma'a nibnitiissin kesfa futoni Ha'oni shiiphoswa. ");
INSERT INTO jnjl_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ma'a wuzaasewa girsuni wuzaase dey tuuma sina Ha'oosi fiqadinon aru chimatik kanuntiison gaddosuk nibnitiisi safarak sooltotitano han daastaki asuni meyane feer sinatiitawa. ");
INSERT INTO jnjl_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Dey isa isarnitiis Ha'oos nittok imna amantoosimato shuphak safarotitano nittok sholsistan denalo teetnitiisik beegantok safarotiita yira taak imte Ha'oosi otmak makefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Isa atuniista showo billiti faar, Es atuniisi billiti dey teetba teetbaasik ooma ooma wostoba faar. ");
INSERT INTO jnjl_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Esiisimato dey inno showo sinfaat Kiristoosnik isa atu sinniwa. Isa atuusi billiti sinni boor'a innotna innotna isarwa. ");
INSERT INTO jnjl_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Es bari boor'a Ha'oos otumbaasik innok imna showo tesa imaason wostota feeshuniwa. Es innok imte imaas Ha'oosi kaamanon awasu sinfaanane amantonisimato Ha'oosi kaamanon awasuni. ");
INSERT INTO jnjl_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Innok imte imaas oomni meyanon argasu sinfaanane chima argasuni. Innok imte imaas asunin assu sinfaanane mai'sira assuni. ");
INSERT INTO jnjl_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Innok imte imaas chinu sinfaanane chinuni, Innok imte imaas asunik ima sinfaanane ma'a nibak imani. Innok imte imaas ha'su sinfaanane chima ha'suni, Innok imte imaas kenashto sinfaanane es baron dey girak zaguni. ");
INSERT INTO jnjl_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Sinnoy sinna bestoni uba foontonon futoni keeshtananti foon. Mangu wuzason oomtoti, Ma'a sina wuzasneen ane isar sinti. ");
INSERT INTO jnjl_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Nittotna nittotna ayna ayna asi keeshtanaasik shunoti. Nittotna nittotna ulfinsuk taptoti. ");
INSERT INTO jnjl_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Hopunoy guzu Ayyanaasik zoonustera Daamiisik wostotiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Abdiisik girotiwa, Shana yaana wono fakuti. Wonna wonna shhiiphoti. ");
INSERT INTO jnjl_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Amanynyi ayni meyanon rakobesisiisik argasuti. Irba sinne ye baassotin ephpha irbasuti. ");
INSERT INTO jnjl_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Nittotin kabgife baassotin suusti, suustitano erwutiitawa. ");
INSERT INTO jnjl_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Girefe baassoneen ane girsoti, waassefe baassoneen ane waasusoti. ");
INSERT INTO jnjl_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Nittotna nittotna isa safarak isar sinna footi. Teetnitiison tegguk beegantooson beyya tukamni meyaneen ane isarik foosoti, Teetnitiisik inno aru utiitawa. ");
INSERT INTO jnjl_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Asu zuuttambaase asi sinak ma'ar sina wuza zagutitano asuni meya nittoosta mangu wuza zagsefe kabaasik wolgira mangu wuza baassosta zagutiita. ");
INSERT INTO jnjl_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Nittok chimter sinafaanane asu zuuttambaaseneen ane nagak footik nittokin sholsi wuzason zuuttira zagusoti. ");
INSERT INTO jnjl_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Koontaasakitono! Gi'ason Ha'oosik beytitano nitto wolla guma kaastotiitawa: «Guma kaastoniisnawa gumani qowaason wolguniisna tawa yifawa Daama Ha'oos» yistera tichchewa. ");
INSERT INTO jnjl_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Es bari boor'a gumani kaastostan gumanees maktefaanane maasu iktefaanane dey ushu, Es baron zaguneesik teetbaasta iichchanni geya wotutawa. ");
INSERT INTO jnjl_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Mangu wuzason ma'arik merotano mangu wuzaasik mertotaata. ");
INSERT INTO jnjl_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Aaffa ha'suusnu sinun imtefanaas Ha'oosi fiqadik sinna boor'anawa hash dey feese ha'sinynyani meya taatesetees Ha'oosik sinna boor'ana asu zuuttere basa denalo ha'sife baassok ajajamonak sholsuwa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Es bari boor'a ha'sife baassotin tugga'efe bar zuuttere Ha'oosi ajajinontu tugga'efewa, Ajajamo beyfe bar dey basastatu ke'o ephphe yeefewa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ha'sife baasso digtesefees mangu wuza zagsefe baassoktano ma'a wuza zagsefe baassoktawa. Ha'sife baassotin digo beya sholefatoso? Ese ma'a wuza zaguwa, baassokin dey galata danatawa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ha'sife bar neek ma'a wuza zagunak taate Ha'oni wostinynyawa. Ha'sife bar siifo taar'enaas shimak sina beyna boor'a mangu wuza zagir sinfaatane barin digowa. Bar mangu wuza zagife baassotin ke'uknawa Ha'oosi gumani kaastonon besunakna Ha'oosi wostinynyawa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Es bari boor'a dey Ha'oosi ke'onon digoos koi'ba sinnoynaron, haalantiis nittotin wee'ona boor'a ha'sife baassok ha'u sholsuwa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Girbo kaasifetiis dey es bari boor'awa; ha'sife baasso es wostooson wostesefees Ha'oosik wostokwa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Isarba isarbaasik sholsi wuzason zaguti. Girbo girbotik sholsina barik girbo girboti; karaxa sholsina barik karaxa kaasuti; digotik sholsina barin digoti; ulfina sholsina barik ulfina imti. ");
INSERT INTO jnjl_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Nittotna nittona keeshtosoti tano ooni kowanu nittoosta foonata; Es bari boor'a asusin zuutire shunfe bar tumaason zagiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«Gerkesataata, worutaata, wiisotaata, eenantotaata» yifa ajajisewa ooma ooma ajajiisikitone zuuttera: «Asu zuuttambaase asin ne ne teetaason shunfataysimato shungwa» yifa isa ajajiissi zuuttera giriwa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Asusin shunfe bar es shunna asusata mangu wuza aane zagife. Es bari boor'a asunin shunfe bar ajajiison zuutire zagiwa uwa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ese Afay'nitan guzuti wonaas hash kar'namato arutiwa. Zeemoti amaneni wonaastan hashti faruni wonaas mai'sira yaara innoki kar'iwa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Waalaas aatdifarwa; wonaas dey ta'i; es bari boor'a talmaasi wostonon beyya chaarefaasi neeboni meyaason mayaniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Yaahoknawa ushshe zawokna gerkesaknawa wojochokna faassoknawa mangu koonakna sinnoynaron wonaasi chaarefaassi feefe asuni meenimato ma'arik foosoti. ");
INSERT INTO jnjl_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Es bari boor'a Daam Yesus Kiristoosnin maytitano ashnitiisi kaltananon tuunuk safarotiitawa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Nitto ganeyaassi amantobaasik hopi sina asusin ephphatootitano basa teetni safaraasta karakkarotiita. ");
INSERT INTO jnjl_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Isa beso biyani: isa asu beste wuzason zuutire muunak chinuni amantoba foona. Sinuntano amantobaasik zagu beya bar tokte toko bar barontu meefe; ");
INSERT INTO jnjl_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Barin Ha'oos ephphata sinna boor'a beste wuzason zuuttire meefe bar muunoy barin kashshunaatawa; muunoy bar dey meefe basaasta mangsu kar'anatawa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Eekan oom asusa wostinynyanita mangsu kar'fees ne oonso? Bar yerefenak wedey gandefenak daambaasa girowa; dey Daamiis barin yeetu chimana sinna boor'a chimme yeronawa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Esiisimato isa wonaas ooma wonaastan denalo ulfinto zagire safarefeer foonak chimanawa; Oomiis dey wonaas zuuttera isa kixxe ulfinbatu faartano wonaasikitoni ganesi oorba oorba aafawa yiretu safarefewa. Ese es barne fa wuzaasik asu isarba isarbaasik nibbaassi safarenaysimato zaguwowa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Isa wonaason ooma wonaastan denalo zagire ulfinsifer feefaanane Daamiisa ulfinakwa iyaatwa. Beste muusonnu zuutire meefe bar Daamiisa ulfinakwa iyaattu meefe, Meefena muusik dey Daamiisin galattefe. Beste muuson zuutire muunoy bar Daamiisa ulfinakwa iyaat aane meefe. Es muu beybaasik dey Ha'ooson galattefe. ");
INSERT INTO jnjl_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Innoossin teetbaasik kitifer wedey teetbaasik feefer aafewa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Faafaanine Daamiisiktu fooni; kiitifaanine dey Daamiisiktu kiituni. Es bari boor'a kitifenik kaak faafenik inno teetniisik Daamiisarwa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Es bari boor'a Kiristoos kitire kitun kabinaas hayewni meyaknawa kituni meyakna Daam sinanakwa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Eekan ne ayneesata awagan mangsu kar'fasso? wedey Awagan ayneesin kashshifasso? Inno zuuttamniise Ha'oosi mangsuni kar'ni kodaasi sinta yeeronirwa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Dey matsafaassi: « ‹Ta hayewawa› yifawa Ha'oos; ke'aas zuuttera ta sina kaa'nonawa; termaas dey; Ta Ha'o sinnamato taak zaala makonawa» yistera tichchena boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Es bari boor'a inno isarni isarniis teetnisi wostok Ha'oosi sina ta'a wolguba imanirwa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Es bari boor'a isarniis oomiisata mangsu kar'anita; Sinuntano oonu aybaasa ugunta gansuni wuza wedey tuusa duusunoynamato teetbaason oodo. ");
INSERT INTO jnjl_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Isa wuza zinawa yire safarefe asu es wuzaas bariktu zina sinanatano aaffa wuzanu teetbaasik kiina sina beynamato ta Daam Yesuniki kamo mai'sira aringwa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ne maafata muusi boor'a ayneesik tuusa sinatar sinfaanane keeshtanaas neyissi aafawa; Es bari boor'a Kiristoos barik kitina asusin maafata muusi boor'a tishunak zagutaatawa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ese nittokik ma'ar sina wuzason oomni meya kashshusonek zagutiitawa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Ha'oosi taato Korto Ayyanak bestefa ooko, naganewa giranetano muunewa ushne asi chowatawa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Esiisimato Kiristoosnik wostefe asu Ha'oosontu girsife, asuni sinak dey galatamtowa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Es bari boor'a nagaas bestefana wuzaasonnawa innotna innotna chimani wuzasonna sholoniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Muuni boor'a Ha'oosi wostonon boganittawa. Muus zuuttera kaymawa; sinuntano oom asusin tuusa'suni muuson muus likkitawa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Es bari boor'a ayneesin tuusa'isunoytamato asha muu beya wedey waynini usha usha beya wedey aaffa tuusa'suni wuza zagu beya ma'arwa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ese han amantonees neenawa Ha'oose asi ganeyasi sinungwa, Likkiwa yire amanena wuzason zagin kanubaas wee'onoyna asu galatamtowa. ");
INSERT INTO jnjl_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Sinuntano awuzakne yifet meefe asus zagina wuzaas amantok sina beyna boor'a mangsu basaasta katerwa, amantok zagtonoy wuzaas zuuttera boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Amantok chim sina inno hopini meeni hopiyaason wor'aniktu sholsifatano inno teetniison girsunik aane sholsifawa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Isarni isarniis oom asusin amantobaasik chimanak barik ke'ni wuzaasewa barin girsuni wuzaase asin zaguniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kiristoos teetbaason aane girsuwe; sinuntano korto matsafaassi: «Asuni meya neen me'ete me'aas tayistatu kar'iwa» yifa kaama basaasta kar'i. ");
INSERT INTO jnjl_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Korto matsafaassin danfeni fakiyaasewa chinuse abdini foonak zeemma tichchenaas innotin assukwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Fakinewa chinune imfa Ha'oos nittotna nittotna Kiristoos Yesusni besosik zoonustok oomiisneen isar sinne fooson nittok imangwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Es bar sinnaas Daamni Yesus Kiristoosni Aba Ha'ooson isa nibaknawa isa kaamakna ulfinsutikwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Kiristoos Ha'oosi ulfinak nittotin ephpheteenamato, nitto zuuttamnitiise isaas oomiisin ephphatoosoti. ");
INSERT INTO jnjl_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Han ta makefanaas Ha'oos zeema abani meyak girina teyyani kaamaas ko'unak Ha'oosi futokwa iyaat Kiristoos Ayhudni meeni wostinynya siniwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Dey Aazabni meya Ha'ooson fakibaasik galattosonekwa. Tichaassi: «Es bari boor'a Aazabni meeni ganeyaassi neen galattonawa; sunneesik dey gaamak galata imanawa» yistera tichchenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Dey: «Nitto Aazabni meyane! Ha'oosi daraneen ane girotiwa» yistera tichchewa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Hepsa dey: «Aazabni meyane! Zuuttera Daamiisin galattoti; daraas dey zuuttera Daamiisin galattoti» yistera tichchewa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Esiisimato dey raajju Isayyas dey: «Isseyni zalaassin koontonir yoona; Aazabni meeni zoonsi sinanak kabuna; baasso dey abdibesiison basaasta zagsone» yifawa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Nitto abdiis Korto Ayyanaasi hugnak dichet hamanak abdini Ha'ooson amantontiisik giranewa nagane tuunira nittok imangwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Aytaasakitono! Ma'ak tuuma nitto; tuuma aruk tuumesetiis; isaas oomiisin kiituk chimatik sinnamato ta aringwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Ha'o taak imna otmaasimato nittotin yadasunak sholefaat isa isa chowa digaba foontonon tichingwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Han Ha'oosi otma taak imtenaas Ha'oosi misirachchuni kaamanon Aazabni meyak makonak maagnimato sinna Kiristoos Yesusnik wostonakwa. Esiis dey Aazabni meya Korto Ayyanak korteserenawa Ha'ooson dey girsuni maa'a sinerena tai'sosonektu wostedifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Es bari boor'a Kiristoos Yesusniki kamo Ha'oosik wostonak chimnaasik teetefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Aazabni meya ajajamer sinonek zagunak Kiristoos ta kaamaasiknawa ta wostoski kamona wostena wuzasontano ooma isa wuzane makonak aafa chimanawuza. ");
INSERT INTO jnjl_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Esiisimato dey akama akama biistera artonoy wuzasiknawa diinqi wostoosikitokna dey Korto Ayyanaasi hugnak Yerusalemun kabira Eliwarqoni biratoostana kar'a Kiristoosni misirachchuni kaamaason makengwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Wonna wonna kaltefanaas dey oom asu kaputna kaptaasta keer'ak sinnoynaron Kiristoosni sunaas teegtonoyna dima zuuttambaase asiissi misirachchuni kaamaason makonakwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Esiis dey: «Zeemo sinak basa chowaason maktonoyna asuni meya biyone; basa chowaason odonoy baasso yaadatosone» yistera tichchenaasimatowa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Hashneen kar'a nittoki yoonoynamato showo wona kaltengwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Sinuntano hash han biratoosta faase daasta wostonaason koi'sina boor'a; dey showo neyaastan kabira nittotin biyanak akamanon kaltet faanar sinna boor'a, ");
INSERT INTO jnjl_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Ispen hamfana kabaasik shaatera nittotin biyanak koppa'engwa. Garo wonanon nittoneen ane girak aatinanneen orfo ugunnaasik sinni argasu taak zagutimato abdi zagifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Sinuntano hash Ha'oni asuni meyak imtoni argasuni waaga ephpha Yerusalem hamnarwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Esiis dey Meqedoniyaknawa Akiyakna feese Ha'oni asuni meya Yerusalemuk feese tukamni meyak imtoni argasuni waaga wossonek buggire kabsete boor'awa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Es argasuuson baasso fiqadik imetees giddi sinna boor'awa. Aazabni meya Ayhudni meyaneen ane ayyanani eebba haa'er sineteneen Aazabni meya ashni foobesiisik Ayhudni meyanon argasusonek giddiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Es bari boor'a han zuutte argasuni waagaason Yerusalem ephpha taamma imnanneen orfo nittoki kamo Ispen hamanawa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Nittoki yaafana kabaasik Kiristoosni eebbaason tuumanon ephpha yoonamato arifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Aytaasakitono! Taak Ha'ooski shiiphok kabefana kabonaasik taan argasutimato Daamni Yesus Kiristoosniknawa Korto Ayyanaasi keeshtanakna nittotin shiiphefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Es shiiphotiis dey Yuudani daasta feese amanonoy asuni meeni kushusin fui'tonaknawa Yerusalemuk fa wostonaason Ha'oni asuni meya ephphetoosonematowa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Es bar dey sinnanneen orfo Ha'o iyaanane girak nittoki yaara nittoneen ane halagalfatonak sholefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Nagani Ha'oos zuuttamnitisneen ane sinfawungwa; Aamin! ");
INSERT INTO jnjl_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Kinkirayasni katamaasi fa betekiristaniissi wostet fa Feeben amanamto eetni sinbaason arutik sholefawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Bar taannawa oom showo asuni meyanonna argasir sinna boor'a amanynyini irbani meyanon ephphetoo sholsifanaysimato Daamiisa sunak ephpha taara barik sholsi wuza zuuttambaase asik argasutik adara yifawungwa. ");
INSERT INTO jnjl_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Kiristoos Yesusni wostoosik taneen ane isar sinne wostet feese Prisklaniknawa Aqilakna naganaason maksoti. ");
INSERT INTO jnjl_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Baasso dey zeemo sinak ta edde kituknu sinfanak hoorere feeseterwa. Es barik dey baassotin galattefawungwa. Ta ta ta sinnoynaron Aazab sinefaat kiristana sina amanynyini meeni betekiristaniisikitoneen baassotin galattesedifewa. ");
INSERT INTO jnjl_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Baassoki keer Ha'oni shiiphok zuuttesefe amanynyini meyak naganaason maksoti. Iisiyani daastak zeemme Kiristoosnik amane bariknawa shunfana Ephenetoosnikna naganaason makotiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Nittok akamanon hopi Maaramik naga makoti. ");
INSERT INTO jnjl_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Taneen ane taatere feese baassoknawa wosini meeni ganeyaasik arto sina Ayhud koontaasakitonikna dey Andronikosniknawa Yuuniyaasnikna naga makoti. Baasso Kiristoosnik amanoosik tayistan zeemme feeseterwa. ");
INSERT INTO jnjl_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Daamiisik shunfana Ampiliyatosnik naganaason makotiwa. ");
INSERT INTO jnjl_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Kiristoosni wostoosik innoneen ane isar sina Ur