﻿USE sofia;
DROP TABLE IF EXISTS sofia.jnje_vpl;
CREATE TABLE jnje_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES jnje_vpl WRITE;
INSERT INTO jnje_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ዳዊትኒ ዛላስን አብራሀምኒ ዛላስኒ ኮንቴ የሱስ ክርስቶስኒ ኮንቶኒ ቱዛስ ሀኒስዋ፦ ");
INSERT INTO jnje_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","አብራሀም ይሳቅንን ኮኒ። ይሳቅ ያቆብኒን ኮኒ። ያቆብ ዩዳናዋ አይባሳክቶኒና ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ዩዳ ፋሬስኒንናዋ ዛራንና ትማር ስኒፋ አሱስኪን ኮኒ። ፋሬስ ኤስሮምኒን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ኤስሮም ደይ ኣራምንን ኮኒ። ኣራም አምናዳብን ኮኒ። አምናዳብ ደይ ነአሶኒን ኮኒ። ነአሶን ደይ ሴልሞኒን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ሴልሞን ራኬብ ይስቴፋ አሱስኪን ቦየዝንን ኮኒ። ቦየዝ ሩት ይስቴፋ አሱስኪን እዮቤድኒን ኮኒ። እዮቤድ እሴይኒን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","እሴይ ደይ ታቶ ስና ዳዊትኒን ኮኒ። ታቶ ዳዊት ኦርዮን አሱስኪን ሶሎሞኒን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ሶሎሞን ደይ ሮብያምኒን ኮኒ። ሮብያም አብያንን ኮኒ። አብያን አሳፍኒን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","አሳፍ እዮሳፍጥኒን ኮኒ። እዮሳፍጥ እዩራምኒን ኮኒ። እዩራም ኦዝያኒን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ኦዝያን እዩአታምኒን ኮኒ። እዩአታም አካዝኒን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","አካዝ እዝቅያስኒን ኮኒ። እዝቅያስ ምናሴንን ኮኒ። ምናሴ አሞስኒን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","አሞስ እዩስያስኒን ኮኒ። እዩስያስ ባብሎን ቦጆን ነያሲክ እኮኒዮናዋ አይባሳክቶኒና ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ባብሎን ቦቾኔን ኦርፎ እኮኒዮን ሴላትያልንን ኮኒ። ሴላትያል ዘሩባቤልንን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ዘሩባቤል አብዩድንን ኮኒ። አብዩድ ኤልያኬምኒን ኮኒ። ኤልያኪም አዛርንን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","አዛር ሳዶኪንን ኮኒ። ሳዶክ አክምኒን ኮኒ። አክም ኤልዩድኒን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ኤልዩድ አላዛርኒን ኮኒ። አላዛር ማታንን ኮኒ። ማታን ያቆብንን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ያቆብ ክርስቶስ ይስቴ የሱስኒን ኮኒ ማራሚኖን ቴጌ ዮሴፍንን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ኤሴ አብራሀምኒስታን ካብራ ዳዊትኒስታ ካርአናኔን አሲሬ አቼቼ ኮኒቶ። ዳዊትኒስታን ካብራ ባብሎን ቦጆ ካርአናኔን አሲሬ አቼቼ ኮንቶ። ባብሎን ቦጆስታን ካብራ ክርስቶስኒ ኮንቶስታ ካርአናኔን አሲሬ አቼቼ ኮንቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","የሱስ ክርስቶስኒ ኮንቶኒ ቶቾስ ሀኒስዋ፤ እንቶባ ማራሚ ዮሴፍኒክ ቴግቴራ ዲስ ግሩኖይ ኮርቶ አያናክ ናኔርቴራ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ቴጌሬ ዱስ ዮሴፍ ኦኮ አሱ ስንና ቦርአ ማራሚኖን አሱኒ ስና ክስሬ ማኮክ ኣኔ ሾሎዌ። ባክ ኣቾክ ቤያናክ ሾሌ። ");
INSERT INTO jnje_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ስኑንታኖ ባር ኤካ ሳፋሬፌን ዳሚሳ ዎስያ ሚቶክ ቤስቴራ፦ «ዳዊትኒ ና ዮሴፍኖ! ቴጌራ ዱስታ ናዋስ ናኔርቴናስ ኮርቶ አያናኪን ስንና ቦርአ ማራሚኖን ኤጳክ ድጎታታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ባር ናኒን ታኖንር፤ ኤስ ናስ ዳራባስን ቦርእቤሲስን ፋቱኒር ስንና ቦርአ ሱንባሶን ‹የሱስ› ይራቱ ሱንሱታ።» ");
INSERT INTO jnje_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ኤስ ባር ደይ ስንናስ ዳሚስ ራጁሲክ፦ ");
INSERT INTO jnje_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«ኤሴኑ ዱርባስ ናኔርቶና፤ ናኒን ደይ ታኖና፤ ሱንባሶን ደይ ‹አማኑኤል› ኡሶነ ይስቴ ባር ስናናክቱ ሀን ባር ዙቴራ ስኒ። ኮትባስ ደይ፦ ‹ሀኦስ እኖኔን አነቱ ፋዋ› ኡዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ዮሴፍ አፋይኒታን ጉዝሬ ዳሚሳ ዎስያ ማኬናሲማቶ ዛግ። ቴጌሬ ዱስና ማራሚኖን ኤጴ ኬባ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ኡዙን ናዉባስን ታኖናኔን ዮሴፍ ባርኔን ኣነ ኩነ። ኮንቴ ናሳ ሱናኖን «የሱስ» ይሬ ሱንስ። ");
INSERT INTO jnje_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","የሱስ ዩዳ ቤቴለሙክ ታቶ ሄሮድስኒ ነያሲክ ኮንቴፌና ካባሲክ አሩኒ ሜያ አዋኬስና ድማን የሩሳሌም ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ኤካ ይት ማሙስሴቴ፦ «ኮንቴ አይሁድኒ ታቶስኪ አይንሶ? ባኩራሶን አውኬሳን ብያት ባርኪ ካኖንክ ያንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ታቶ ሄሮድስ ኤስ ባሮን ኦድናይሴ ናየ። የሩሳለሙክ ፌሴ አሱኒ ሜያ ዙቴሬ ባርኔን አነ ናየሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ማግኒ ጋኝኜ ሜናዋ ዳራሳ ቱማኒ አስሲኛኒ ሜና አሲን ዙትሬ ክርስቶስ አይ ኮንቶናማቶ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ባሶ ደይ፦ «ዩዳኒ ዳስታክ ፋ ቤቴለሙክ ራጁኡስ ኤካ ይሬ ትችናር ፋር። ");
INSERT INTO jnje_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹ዩዳኒ ዳስታኪ ፋ ካታማ ቤቴለምኔ! ታ ዳራ ስና እስራኤልኖን ኦድኒ አእስኛ ኔኪን ኬስኒር ስንና ቦርአ እኛ እኛ ካታማስን ነ ኣፋ ሀቶታዉዛ› ይስቴራ ማክቴራ ፋር» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ኤሴን ኦርፎ ሄሮድስ አሩኒ ሜያኖን ኣቾክ ቴጌሬ ባኩራስ ባሶክ ቤስቴና ዎናሶን ማምሲሬ አሪ። ");
INSERT INTO jnje_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ባሶትን ኤካ ይት ዎሲ፦ «ቤቴለም ሀምፋት ኮንቴ ናስን ጋሳሱትዋ፤ ዳነፋትኔ ታኪ ደይ ያራ ማኮት። ታ ደይ ሀማ ባርኪ ካኖና» ");
INSERT INTO jnje_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ባሶ ደይ ታቶሳ ካማኖን ኦዴሬ ሀሜቴ። አዋኬስና ድማን ብየቴ ባኩራስ ናስ ፌና ድማስታ ሀማ የሮናኔን ዞንሲት ፋር። ");
INSERT INTO jnje_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ባኩራሶን ብየቴይሴ አካማ ግራ ግርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ኬር ግርሴሬ ዳግ ናስ እንቶባ ማራሚኔን አነ ፌን ብየቴ። ባርኪ ስና ስኒቤሲሲክ ሳጋዶሬ ሳጥኒቤሲሶን ጋችቼ ዋርቄ፥ እጣናነዋ ኩምብነ አሲ እማ ባሪክ እሜሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","አሩኒ ሜያ ዎልሴሬ ሄሮድስኒክ ሀሞኖይቴማቶ ባሶክ ሀኦስ ሚቶክ ማኬና ቦርአ ኦማ ኡግናክ ዳቤሲ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","አሩኒ ሜያ ሀሜቴኔን ኦርፎ ዳሚሳ ዎስያ ሚቶክ ዮሴፍኒክ ቤስቴራ፦ «ሄሮድስ ዳግ ናስን ዎሩናክ ሾሌድፌር ስንና ቦርአ ካብራ ናስን እንቶባስኔን አነ ኤጳ ግጵፂ ሀማ፤ ታ ኔክ ማኮናኔን ኤስታ ፎዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ዮሴፍ ደይ ካብሬ ዳግ ናስን እንቶባስኔን አነ ኤጴ ዋላክ ግጵጽ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ዳሚስ ራጁባሲክ፦ «ናታስን ግጵፂን ቴጌንዋ» ይና ባር ስናናክቱ ግጵፂ ሀሜቴ። ሄሮድስ ክቱናኔን ኤስታ ዲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ኤሴን ኦርፎ ሄሮድስ አሩኒ ሜያ ባሪን ኤሸሬ አቴ ሀሞቤሲሶን አራት አካማኖን ግእቴሬ አሩኒ ሜያኪን ኦደና ነያሲክ ቤቴለምነዋ ብራቶባስታና ፋ ዳስታኪ ኔባ ሄፕነዋ ኤሴን ዳካሎ ፋ ጋሮ ጋሮ ናንጎታሶን ዙትሬ ዎርቶናክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ኤስ ካባሲክ ራጁ ኤርምያስኒክ ማክቴ ራጂስ ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«ራሄል ናንጎትባሲክ ዋሲ፤ ዋስነዋ አካማ ሶሶነ አሲ ካማ ራማክ ኦድቴ። ናንጎትባስ ኣፋ ስንና ቦርአ ፋኩክ ኣነ ችማ» ይስቴ ባር ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ሄሮድስ ክትናኔን ኦርፎ ዳሚሳ ዎስያ ግጵጽክ ዮሴፍኒክ ሚቶክ ቤስቴራ፦ ");
INSERT INTO jnje_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«ዳግ ናሳ ካኖን ትሽኩክ ሾሌ ባር ክትዋ። ካብራ ዳግ ናኔስን እንቶባስኔን አነ ኤጳ እስራኤልኒ ዳ ሀማ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ዮሴፍ ካብሬ ዳግ ናስን እንቶባስኔን ኤጴ እስራኤልኒ ዳ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ሄሮድስኒ ና አሪኬላዎስ አባባሳ ኤድደ ዩዳክ ዳስታክ ታቴናማቶ ኦዴሬ ኤስታ ሀማ ድጌ። ስኑንታኖ ኦርፎ ሚቶ ቢሬ ጋሊላን ዳ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ራጁኒክ፦ «ናዝራው ኡስቶና» ይስቴ ባር ስናናክ ናዝሬት ይስቴ ካታማሲ ሀምሜ ድ። ");
INSERT INTO jnje_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ኤስ ካባሲክ ሀጵቅፌ ዮሀኒስ ዩዳኒ ዳስታኪ ኢችማ ዳስ ሲ ማኬት የ። ");
INSERT INTO jnje_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ኤስ ማኬት ዬናስ ደይ፦ «ሳማኒ ታቶስ ታእሴ ስንና ቦርአ ሀርሙትዋ» ይፋር። ");
INSERT INTO jnje_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ራጁ ስና እሳያስኒ ማፃፋሲ፦ « ‹ዳሚሳ ኡግናኖን ሆስሱቲ፤ ሳፕስራ ደይ ዜጵት› እያፌ ኢችማ ዳስ ሲ ቻጌት ፌ አሱኒ ካማ» ይስቴራ ማክቴ ባር ሀኒስዋ። ");
INSERT INTO jnje_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ዮሀኒስ ማይፌና ማማስ ጋላኒ ኤሳክ ዊቼ ማማ። ጌሾባስታ ደይ ጎጎኒ ታልፋ ታርኤት ፌር። ሙባስ ደይ ብልጛነዋ ዛቦኒ ኤስነ። ");
INSERT INTO jnje_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ኤስ ካባሲክ የሩሳለሙን፥ ዩዳኒ ዳ ዙታምባሴ አሲስን፥ ዮርዳኖስኒ ብራቶስታ ፋ ዳ ዙታምባሴ አሲስ ፌ አሱኒ ሜያ ዙቴሬ ባርኪ ዬት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ቦርቤሲሶን ሀርምፋፌ ዮርዳኖሲክ አካስ ባሪክ ሀጱክቴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ዮሀኒስ ሾዎ ፌርሳዊኒ ሜናዋ ሴዱቃዊኒ ሜና ሀጱክቶክ ባርኪ ዬሴፌን ብያት፦ «ንቶ ኡፎን ናንጎታ፤ ዮናክ ፋ ሀኦሲ ግእስን ኬሳትክ ኦንሶ ንቶክ ማኬሪ? ");
INSERT INTO jnje_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ኤሴ ሀርሙንትሶን ቤሲፋ ዎስቶ ዎስቶት። ");
INSERT INTO jnje_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ንብንትስ፦ ‹አብራሀም እንኖ አባዋ› ይፌትማቶታዋ። ንቶክ ማኬፋውጙዋ፤ ሀኦስ ሀን ሹኣሲክቶስን ካብግራ አብራሀምኒ ናንጎታ ዛጉናክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ሀሽ አንፋላ እኦሲ ዲስ ኩንፋርዋ፤ ማአ ጋና ጋንኖይ እኦሲክቶ ዙቴራ ካቴራ ጌሲ ሀእቶና። ");
INSERT INTO jnje_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ታ ሀርምያሲክ አካክቱ ሀጵቁና፤ ታ ቻኣማባሲ ታርአኖን ኮታናክ ችምኖይናር ታይስታን አካማኖን ደናሎ ስና ባር ታ ኦርፎስታ ዮኒር። ባር ኮርቶ አያናክናዋ ጌያክናቱ ሀጵቁና። ");
INSERT INTO jnje_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ሜያሶን ሳማ ሀኡና ማንሺስ ኩሹባስቱ ፋ፤ ኦዳሶን ማእስሬ ካይኑና፤ ዛጎሶን ቦቶባሲ ጋጋና፤ ስኑንታኖ ኡፋሶን ትሹኖይ ጌሲ ኪቹና» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ኤስ ካባሲክ የሱስ ዮሀኒስ ባሪን ሀጵቁናክ ጋሊላን ዮርዳኖስኒ አካስኪ የ። ");
INSERT INTO jnje_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ስኑንታኖ ዮሀኒስ፦ «ታን ነ ሀጵቁታክ ሾልሱ ስንና ፌን ነ ታኪ ያፋቶሶ?» ይት ካል። ");
INSERT INTO jnje_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","የሱስ ዎልግሬ፦ «ታን ካላታታዋ፤ ኦኮ ስና ባሮን ዛጉናክ ሾልሱ ስንና ቦርአ ቤይዋ» ይን ኤስ ካባሲክ ዮሀኒስ «ማእ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","የሱስ ሀጱክቴናኔን ኦርፎ ጌሬጌሬ አካስን ኬስ። ኤስታን ሳማስ ጋቼን ሀኦኒ አያና ናካሎነ ፋር ስንና ባሳስታ ኬሬፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ካማ ደይ ሳማኔ ያራ፦ «ሀኒስ ታ ሹንፋና ናስዋ፤ ባርኪቱ ግሬፋውጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ኤሴን ኦርፎ ሀኦኒ አያና የሱስ ዳቡሎስኒክ ፋታንቶናክ ዞንስራ ኢችማ ዳስ ሲ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ኤስታክ የሱስ አቼችአሲር ዎነዋ ዋልነ ሶሜናኔን ኦርፎ ማክቴ። ");
INSERT INTO jnje_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ፋታኖኒ ባር ታእሴሬ፦ «ነ ሀኦኒ ና ስኒፋታነ ሀን ሹኣሲክቶ ቱሻ ስናናክ አጃጀባ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ስኑንታኖ የሱስ ዎልግሬ፦ « ‹አሱ ሀኦሲ ኖኖስን ኬስፋ ካማ ዙታምባሴ አሲክታኖ ሙ ሙክ ኣነ ፌፌ› ይስቴራ ትቼዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ኤሴን ኦርፎ ዳቡሎስ የሱስኒን የሩሳሌም ኤጴ ታሜ ቤቴሜቅደሲሲ ቱክታ ዬታት፦ ");
INSERT INTO jnje_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ኤካ ይ፦ « ‹ዎቾኔስ ሹኣስታ ቱሳእኦኖይማቶ ኔን ኦዳናክ ሀኦስ ዎሲባሶን አጃጆናዋ። ኩሹቤሲሲክ ደይ ኔን ካቡግሶነዋ› ይስቴራ ትቼዋ፤ ኤሴ ነ ሀኦኒ ና ስኒፋታነ ዬት ጎሎ ቴትኔሶን ሀኡዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","የሱስ ደይ ዎልግሬ፦ « ‹ዳማ ሀኦኔሶን ፋታኖታታ› ይስቴራ ደይ ትቼዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ሄፕሳ ደይ ዳቡሎስ የሱስኒን አካማ ድቻ ኣምታ ክስሬ ዬታት ሀን ዳሲ ታቶኒ ኡልፍናኖን ዙትሬ ቤሳት፦ ");
INSERT INTO jnje_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«ነ ታክ ጋንደራ ሳጋደፋታነ ሀን ባሮን ዙትራ ኔክ እማናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ኤስ ካባሲክ የሱስ፦ «ሀንታን ኬስ! ነ ሴጣና፤ ‹ዳማ ሀኦኔሲክ ካእኖ። ባር ባሮን ሺጶ› ይስቴራ ትቼዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ኤስ ካባሲክ ዳቡሎስ ባሪን ቤይ፤ ሀኦሲ ዎስያ ደይ ታእሴራ ባሪን አሪጋስት ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","የሱስ ዮሀኒስ ታቶኒ ኬር ግሩባሶን ኦደናይሴ ጋሊላ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ናዝሬትኖን ቤይፋት ዛብሎነዋ ንፍታለምነ አሲ አዉራጃ ጋሊላን ባርሲ ሀእታ ፋ ክፍርናሆም ይስቴፋ ካታማሲ ሀምሜ ድ። ");
INSERT INTO jnje_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ኤስ ባር ደይ ስንናይ ራጁ ኢሳያስ ኤካ ይት ማኬና ካማስ ስናናክዋ። ");
INSERT INTO jnje_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«ዛቡሎኒ ዳስ፥ ንፍታለምን ዳስ፥ ዮርዳኖስኒ የሳሎ ባርሲ ሀእታ ፋ፤ አዛብኒ ሜኒር ስና ጋሊላ፤ ");
INSERT INTO jnje_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ታልማስ ፌ ዳራስ፤ አካማ ቻሬፋ ቢ፤ ክቱኒ ይራራ ፋና ዳስታክ ዲሴ ባሶክ፤ ቻሬፋ ኬሳ ቤስቴ።» ");
INSERT INTO jnje_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ኤስ ዎናስታኔን ካብሬ የሱስ፦ «ሀኦሲ ታቶ ታእሴዋ፤ ሀርሙትዋ» እያፌ ማኮ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","የሱስ ጋሊላኪ ባርሲ ቴሻ ኣትፌት ሄፕ አይኒ ሜያ ጴጥሮስ ይስቴፌ ስሞንናዋ አይባ እንድርያስና ኩርጡምሚ ኤሻክ ዩጉዶቤሲሶን አካሲ ሀእሴፌን ቢ። ባሶ ዎስቶስ ደይ ኩርጡሚኒ ኤሻ። ");
INSERT INTO jnje_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","የሱስ ደይ ባሶክ፦ «ታኔን አነ ያፋት አሱኒ ሜያኖን ሀኦሲ ታቶስ ዎልጉትክ ንቶትን ዛጉናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ባሶ ደይ ጌሬጌሬ ዩጉዶቤሲሶን ቤይፋት ባርኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ኤስታን አቴ ኦም ሄፕ አይና አይና ዘብደዎስኒ ናንጎት ሲና ያቆብናዋ ዮሀኒስና አሲን ቢ። አባቤስ ዘብደዎስኔን አነ ጎኑስታ ዲሴፋት ዩጉዶቤሲሶን ማእስፌን ብያት ቴጌ። ");
INSERT INTO jnje_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ባሶ ደይ ጌሬጌሬ ጎኑሴዋ አባቤሲስና አሲን ቤይፋት የሱስኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","የሱስ ባሶ አይሁድኒ ሺጶኒ ኬያሲክቶስ አሲት ሀኦሲ ታቶኒ ምስራቹኒ ካማሶን ማኬት ዳራሳሲ ፋ ሾዎ ቴሳ ሜሮሶን ዙትሬ ፋቲት ጋሊላኒ ዳ ዙታምባሴ አሲስ ብራቴት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","የሱስ ዛግና ቾዋሲ ዎላ ሶርያኒ ዳ ዙታምባሴ አሲስ ኦድቴ። ሾዎ ቴሳ ሜሮክ ሜቴ አሱኒ ሜያኖንናዋ ራኮክና ኦቴሬ ፌሴ አሱኒ ሜያኖን፥ ደይ ኪና አያና ኤጵና ባሶትን፥ አካታክ ሜሮቤስ ፋና ባሶትናዋ ላፋኒ ሜያኖንና ዙትሬ ኤጴ የሱስኒክ ቴሸሴቴ። ባር ደይ ዙታምቤሲሴ አሲን ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ጋሊላኒ ዳስታኪ፥ አሲር ካታማስን፥ የሩሳለሙን፥ ዩዳን፥ ደይ ዮርዳኖስኒ ዬሳሎን ሾዎ ዳራ የሱስኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","የሱስ ሾዎ ዳራ ባርኪ ዬፌን ብያት ኣማስታ ኬሴ ድ። ናዎባሳክቶ ደይ ባርኪ ዬሴቴን ");
INSERT INTO jnje_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ኤካ ይት አስሱ ኤጲ፦ ");
INSERT INTO jnje_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«ሀኦሲ ታቶ ባሶር ስንና ቦርአ፤ አማንቶቤሲሶን ሀኦስታ ዛግሴፋት፤ ቴትቤሲሶን፤ ዳ ኤጴፌ ባሶ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ሀኦ ባሶክ ችማ እምንር ስንና ቦርአ፤ ሱሜት ፌሴፌ ባሶ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ቴትቤሲሶን ዳ ኤጴፌ ባሶ፤ ሀን ዳሶን ዋራሶሶነር ስንና ቦርአ፤ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ኦኮ ስና ዎስቶሶን፤ ማክቴሬ እክቴት ፌሴፌ ባሶ፤ ጋዉሶነር ስንና ቦርአ፤ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ፌሹን ይሴፌ ባሶ፤ ባሶክ ፌሹን ኡስቶኒር ስንና ቦርአ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ንብቤስ ካይም ስንና ባሶ፤ ሀኦሶን ብዮነር ስንና ቦርአ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","አሱኒን ጋንሲት ፌሴፌ ባሶ፤ ሀኦኒ ናንጎት ይስቴሬ፤ ቴግቶሶነር ስንና ቦርአ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ኦኮ ስና ዉዛስ ቦርአ ካቡግቴሴፌ ባሶ፤ ሀኦሲ ታቶ ባሶር ስንና ቦርአ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«ታ ቦርአ አሱኒ ሜያ ንቶትን ሜእኤፌ ካባሲክናዋ ካቡግሴፌ ካባሲክና ደይ ኤሻክ ሱንትሶን ማግስሴፌ ካባሲክ ንቶ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ዋግኒትስ ደን ሳማክ አካማ ስንና ቦርአ ግሮትዋ። ደይ አካማኖን ግሮት። ንቶስታን ዜምሜ ፌ ራጁኒ ሜያስታ ኤሲስማቶቱ ሻና ካትሴቴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ደይ የሱስ፦ «ንቶ ሀን ዳስ ካዎዋ። ስኑንታኖ ካዎስ ካርባ ትሽፋናነ ኣካግራ ካርንሪንሶ? ኤክ ጌሮ ሀእቴራ አሱኒ ዎቾስ የቶናስታኖ ኬአና ዉዛባ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ንቶ ሀን ዳሲክ ቻሬፋዋ። ኣማስታ ኬቴራ ድ ካታማስ ኣቾናክ ኣፋዋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","አሱ ቶና ቶኒሬ ዋሺ ዱስፌዎሶ? ቴጋ ድምታታኖሶ ዱሳን ኬያስ ፌ አሱሲክ ዙትራ ቻሬፋናሪ? ");
INSERT INTO jnje_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ኤሲስማቶ አሱኒ ሜያ ንቶ ማአ ዎስቶሶን ብየሬ ሳማኪ አባንቲስን ኡልፍንሱሶነክ ቻሬፍኒትስ አሱ ዙታምባሴ አሲ ስና ቻሮጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ደይ የሱስ፦ «ታ ሙሴኒ ቱማሶንናዋ ራጁኒ ሜኒ ካማሶንና ሻሮክ ያናርነ ፋር ስንና ንቶክ ቤስቶናታዋ። ታ ያናስ ዛጉናክዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ታ ፉቶክ ንቶክ ማኬፋውጙዋ፤ ሳማሴዋ ዳሴ ኣታናኔን ቱማስን ምሉ ዱክቶኑ ዎስቶታ ፌሽኖይ ኣፋዋ ኣታና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ኤሴ ሀን አጃጂስን አቴር ስና እሳይሶን ሻሬፌ ባርናዋ ኤሲስማቶ ደይ አሱኒክ አሲፌ ባርና ሳማኪ ታቶስ ስክ ዙታምባሴ አሲስታን ዳካሎቱ ስናና። ስኑንታኖ ዛግፌ ባር ወደይ አሲፌ ባር ኦኑ ስንፋናነ ሳማኪ ታቶስ አሪክር ይስቴሬቱ ቴግቶና። ");
INSERT INTO jnje_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ንቶክ ማኬፋውጙዋ፤ ንቶ ኦኮ ስናስ ሙሴኒ ቱማሲ አስሲኛሳታንናዋ ፌርሳዊኒ ሜያስታንና ደናሎ ስና ሻካናነ ሳማኪ ሀኦሲ ታቶስ እሳንነ ኣፋዋ ግሩት ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«ዜሞቲ ባሶክ ‹ካ ዎሩትታ› ዎሪ ባሳስታ ማጝሱ ካቴር ይስቴናማቶ ኦደትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ስኑንታኖ ታ ንቶክ ማኬፋውጙዋ፤ አይባሳታ ግቴፌ ባሳስታ ማጝሱ ካቴርዋ። ደይ አይባስን፦ ‹ነ ኬእኖር› ይሬ ሜአ ባሳስታ ማጝሱ ካቴርዋ። ኦኑ ደይ፦ ‹ነ ኦዶ ኦዮ› ይፌ ባር ዙታምባሴ ጌኒ ትርእማሲ ግሩኒ ማጝሱቱ ካቶኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ኤስ ባሪ ቦርኣ ሀኦሲክ እማታ እምኔሶን ሾኣስታ ቴሸፋታ ካባሲክ አይኔስን ቱግታ ቾዋ ፎባሶን ያዳቴፋታነ፤ ");
INSERT INTO jnje_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ኤስ ሀኦሲክ እማታ እምኔሶን ሾኣሲ ተሻ ኩንሳት ዜምማ ሀማ አይኔስኔን አነ ጋኖዋ። ኤስታን ዎላ ያራ እምኔሶን እማ። ");
INSERT INTO jnje_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ጉማኔስ ኔን ማላቴን ማጝሱ ካርኒ ኬር ሀሚፋታ ካባሲክ ዜምማ ኡጉንታክ ታፕቴራ ጋኖዋ። ኤካ ዛጉ ሻካታነ ጉማኔስ ኔን ኣትሬ ጋኛኒክ እምን ጋኝኛስ ደይ ኣትሬ ሜያ ታርኦሲክ እምን ታቶኒ ኬር ግሩታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ፉቶ ኔክ ማኬፋውጙዋ፤ ኮእኒ ዱዴሶን ካሱታኔን እሳንነ ታቶኒ ኬያስን ኣፋ ኬሳታዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ደይ የሱስ፦ « ‹ጌርኬሳትታ!› ይስቴናስማቶ ኦዴትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ስኑንታኖ ታ ንቶክ ማኬፋውጙዋ፤ ማሽካሱክ ቢሬ አነ ኩናናክ ሾሌ ባር ዙቴሬ ኤስ ካባሲክ ባርኔን አነ ንባሲክ ጌርኬስዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ሆእታ ኣፍኔስ ኔን ቱሳስፋናነ ዎእራ ክሱዋ፤ አቱነ ዙቴራ ጌኒ ትርእማሲ ሀቶባስኔን አቱኔስን እሳሮን ቱርክፋታነ ዋያዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ሆእታ ኩሹኔስ ኔን ቱሳስፋናነ ካርአ ሀኡዋ፤ አቱኔስ ዙቴራ ጌኒ ትርእማሲ ሀቶባስኔን አቱኔስን እሳሮን ቱርክፋታነ ዋያዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«አሱባሶን ጋፍክፌ ባር ዙታምባሴ ጋፍኩኒ ትቻሶን እሞዋ» ይስቴና ባሮን ኦደትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ስኑንታኖ ታ ንቶክ ማኬፋውጙዋ፦ «አሱባስ ጌርኬስፌን ዳንኖይ ባክ ጋፍክፌ ባር ዙታምባሴ ሀማ ጌርኬሳናክቱ ዛግፌዋ። ኤሲስማቶ ደይ ጋፉክቴ ባሮን ኤጳ ባር ደይ ጌርኬስዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«ኤሻክ ቴዉትታ ስኑንታኖ ቴይት ባሮን ዳሚሲክ ዛጉትዋ» ይስቴና ባሮን ኦደትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ስኑንታኖ ታ ንቶክ ማኬፋውጙዋ፤ እሳንነ ቴዉትታ፤ ደን ሳማስ ሀኦሲ ዝግሙ ስንና ቦርአ ሳማሲክኑ ስኒፋናክ ቴዉትታ። ");
INSERT INTO jnje_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ሀን ዳስ ደይ ሀኦኒ ዎቾ የርእና ድማ ስንና ቦርአ ሀን ዳሲክ ቴዉትታ። የሩሳሌም ደይ አሪክቶ ታቶሳ ካታማ ስንና ቦርአ የሩሳለሙክ ቴዉትታ። ");
INSERT INTO jnje_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ሶምኔስ ፋሻስን እሳሮን ፎሮ ወደይ ካራ ዛጉክ ኣፋ ችማታዉዛ ስንና ቦርአ ቴትኔሲክ ቴዉታታ። ");
INSERT INTO jnje_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ስኑንታኖ ንቶ ዎላስ «ኣ» ስንፋናነ «ኣ» ስኑን ወደይ «እንዳነ» ስንፋናነ «እንዳነ» ኡት። ኤስ ባርስታን ኦማስ ማጙሲክንዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« ‹ኣፋሲክ ኣፋ፤ አይኣሲክ አይአ› ይስቴናማቶ ኦደትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ታ ንቶክ ማኬፋውጙዋ፤ ማጙ ዉዛ ንቶስታ ዛግፌ አሱስን ጉማ ካስቶትታ። ስኑንታኖ ሆእታ ጋችኔሶን ቦቻ ባሪክ አልዳ ጋችኔሶን ደይ ሸልግራ ቤሱዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ስካሎኪ ጋግ ማዮኔሶን ኤጴቶናክ ኔን ማላቴፌ ባሪክ ቱካስታክ ጋግ ማዮሶን ዳይስራ እማ። ");
INSERT INTO jnje_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","እሳ አሱ፤ እሳ ኪሎ ሜትር ሀማታክ ኔን ግድስፋናነ ሄፕ ኪሎ ሜትር ዳይስራ ባርኔን አኔ ሀማ። ");
INSERT INTO jnje_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ኔኪን ሺጴፌ ባሪክ እማ፤ ኔኪን ልቆናክ ሾሌፌ ባሪክ ካላታታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","« ‹አሱኒን ሹንዋ፤ ጉማኔስን ኦምቶ› ይስቴ ባሮን ኦደትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ስኑንታኖ ታ ንቶክ ማኬፋውጙዋ፤ ጉማንትስን ሹንት፤ ንቶትን ካቡግሴፌ ባሶክ ሺጶት። ");
INSERT INTO jnje_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ኤስ ባሮን ዛጋትነ ሳማኪ ፌ አባንትሲክ ናንጎታ ስናት። ሀኦስ ማጙኒ ሜያስታናዋ ማአ አሱኒ ሜያስታና አዋ እቻናክ ዛግር። ኦኮኒ ሜያስታናዋ ቦርእኒ ሜያስታና እሮ እቻናክ ዛግር። ");
INSERT INTO jnje_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ንቶትን ሹንፌ ባሶ ባሶትን ሹንፋትነ አዉ ኬአትሪንሶ? ግርቦ ዙትፌ ባሶኑ ኤሲሶንታኖሶ ዛግሴፌሪ? ");
INSERT INTO jnje_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","አይንት አይንትሳክቶኒክ ናጋ ኦሸሴፋትነ አሮ ጋድዶ ዉዛ ዛግትሶ? አዛብኒ ሜያኑ ኤሲሶንታኖሶ ዛግሴፌሪ? ");
INSERT INTO jnje_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ኤስ ባሪ ቦርኣ ሳማኪ ፌ አባንቲስ ካይም ስንናማቶ ንቶ ደይ ካይም ስኒት» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«አሱኒ ሜያ ብዮቶዋ እያት ማአ ዎስቶኒትሶን አሱኒ ስና ዛጉስታን ቴትንትሶን ኦድትዋ። ኤስ ባሮን ዛጋትነ ሳማክ ፌ አባንቲስኪን ዳናት ዋግንት ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ኤስ ባሪ ቦርኣ ቱካምኒ ሜያክ እምፌት ካባሲክ ስኖይ ስንነ ቤስቴሴፌ ባሶ አሱኒ ሜያ ኡልፍንሱሶነክ አይሁድኒ ሺጶኒ ኬያስናዋ ኡግናስታና ዛግሴፌስማቶ ቢስቶክ ዛጉትታዋ። ታ ፉቶክ ማኬፋውጙዋ፤ ዋግቤሲሶን ኤጴቴሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ስኑንታኖ ነ ቱካምኒ ሜያክ እምፋታ ካባሲክ ሆእታ ኩሹኔስ ዛግፋና ባሮን አልዳ ኩሹኔስ አሩናታ። ");
INSERT INTO jnje_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ቱካምኒ ሜያክ እምፋታ እምኔስ ኣቾክ ስኑን። ኣቾክ ዛግቴ ባሮን ቢፌ አባኔስ ኔክ ካሱና። ");
INSERT INTO jnje_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«ሀኦ ሺጴፌት ካባሲክ ስኖይ ስንነ ቤስቴሴፌ ባሶስማቶ ስናትታ። ባሶ አሱ ታን ብዮ እያት አይሁድኒ ሺጶኒ ኬያስናዋ ኡግናሲ ሀእታና የሬፋት ሀኦኒ ሺጶ ሹነቴር። ፉቶ ንቶክ ማኬፋውጙዋ፤ ዋግቤሲሶን ኤጴቴሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ስኑንታኖ ነ ሀኦ ሺጴፋታ ካባሲክ ኬኔሶን ኩልፋት ቢስቶኖይ አባኔሲክ ሺጶዋ። ኣቾክ ዛግቴ ባሮን ቢፌ አባኔስ ኔክ ካሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","አዛብኒ ሜያ ዎሉምቤሲስ ኣታማክ ኦድቶኒነ ፋር ስንናቱ ባሶክ ቤስቴፋ። ስኑንታኖ ንቶ ሺጴፌት ካባሲክ ባሶስማቶ ሽማሲክ ሄፓ ሄፓ ዎልጋት ሺጶትታ። ");
INSERT INTO jnje_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ኤሴ ንቶ ባሶስማቶ ስናትታዋ። አባንቲስ ንቶ ሺጶኖይ ፋኒ ንቶክ ሾልሱ ዉዛሶን አሪርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ኤሴ ንቶ ኤካ ይራ ሺጵሶት፦ « ‹ደን ሳማክ ፌ አባኒሶ፤ ኮርቶ ሱኔስ ቴግፋዉጝዋ፤ ");
INSERT INTO jnje_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ታቶኔስ ዮንዋ፤ ነ ሹንፋታ ባር፤ ደን ሳማክ ስኒፋናስማቶ፤ ሀን ዳስታክ ደይ ስኑን። ");
INSERT INTO jnje_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ሀውጙት ሙኒሶን፤ ሀውጙ እኖክ እማ። ");
INSERT INTO jnje_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","እኖትን ሚርእኤፌ ባሶትን፤ ፌሹን ይፌኒሲማቶ፤ ማጝሱኒሶን ፌሹን ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ማንጙስን ኦድታኖ፤ ፋታናሲ እኖትን ጌዳታታ። ታቶስ፥ ሁግናሴዋ ኡልፍናሴ፤ ኮእባ ፎንቶኖን ኔርዋ፤ ኣሚን።› ");
INSERT INTO jnje_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«አሱኒ ሜያ ንቶስታ ካትሴቴ ሚርእኣሶን ፌሹን እያትነ ደን ሳማክ ፌ አባንቲስ ንቶሶን ፌሹን ኡና። ");
INSERT INTO jnje_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ስኑንታኖ አሱኒ ሜያ ንቶስታ ካትሴቴ ሚርእኣሶን ፌሹን ኡ ሻካትነ አባንቲስ ንቶ ቦርኣሶን ኣፋ ፌሹን ኡናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«ሶሜራ ሺጴፌት ካባሲክ ስኖይ ስንነ ቤስቴሴፌ ባሶስማቶ ሱሞትታ። ባሶ ሶሜሬ ሺጶቤሲሶን አሱ አሩናክ ስንቤሲሶን አልቅስሴፌ። ፉቶ ንቶክ ማኬፋውጙዋ፤ ዋግቤሲሶን ኤጴቴሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ስኑንታኖ ነ ሶሜራ ሺጴፋታ ካባሲክ ኣፍኔስ ማሴራ ፎቾዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ኤካ ዛጋታነ ኣቾክ ፌ አባኔስቴኖ ሶሜሬ ሺጶኔሶን ኦም አሱ ኣፋ አሩና ዉዛ። ኣቾክ ቢፌ አባኔስ ኔክ ካሱና። ");
INSERT INTO jnje_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«ኮኝማር ሙናስታ ሺራ ደይ ማጙናስታ ዊስ ደይ ዪሸ ዊሶና ሀን ዳስታ ዋጋ ዙቱትታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ስኑንታኖ ኮኝማር ሙኖይናር ደይ ሺራ ማጙኖይናር ዊስ ደይ ዪሸ ዊሶኖይና ድምታ ደን ሳማክ ዋግንትሶን ዙቱትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ዋግኔስ ፋናስታ ንብኔስ ደይ ኤስታ ፎናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","አቱኒ ቶናስ ኣፋዋ፤ ኤስ ባሪ ቦርኣ ነ ኣፋስ ፋያ ስንፋናነ አቱኔስ ዙቴራ ቻሬፋቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ስኑንታኖ ኣፍኔስ ሜቴታና ስንፋናነ አቱኔስ ዙቴራ ታልማቱ ስናና። ኤሴ ነይስታ ፋ ቻሬፋስ ታልማ ስንናኔን ታልማስ ደይ አዉነ ፋሮን አሪክራ ታልሞንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«እሳ አሱ ሄፕ ዳምኒክ ዎስትኛ ስናናክ ኣፋ ችማናዉዛ። እሳይስን ኦምቴፋት ሄፕሳስን ሹናር ስናና ወደይ እሳይስን ኡልፍንሳት ሄፕሳስን ካሹና። ኤሲስማቶ እሳ አሱ ሀኦስክናዋ ዋጋክና ዎስትኛ ስናናክ ኣፋ ችማ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ኤስ ባሪ ቦርኣ ንቶክ ማኬፋውጙዋ፤ ፎንትሲክ አዉ ሙንታሶ? አዉ ኡሻኒታሶ? አዉ ማያንታሶ? ይራ ራካቶትታዋ። ካ ሙስታን አቱ ማያስታን ደናሎታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ሳማስታ ፉልፋ ካሳሲክቶኖን ቢትዋ፤ ኣነ ቡክፋ፥ ኣነ ካርፋ፤ ጎምብስ ደይ ኣነ ጋግፋ። ሳማክ ፌ አባንቲስቱ ማስፌር። ንቶ ባርኪቶኒስታን አካማኖን ደናሎዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ንቶስን ዱደሬ ዎጋባስታ እሳ ዎና ዳይሱክ ችምንር ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ኤኪን ማይኒ ቦርአ አዉኒሮን ራካቴፌትሶ? ባኬስታ ዲሴ ፉርኣሲክቶ ኣካክ ድችፋናማቶ ጋሳሲራ ቢትዋ። ኣነ ሆፕሴፋ፤ ኣነ ሱክፋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ስኑንታኖ ንቶክ ማኬፋውጙዋ፤ ሶሎሞንኑ ፋ ኡልፍንባ ዙታምባሴ አሲክ ፉርኣሲክቶስን እሳይስንነ ፋሮን ኣነ ማየዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","አማንቶኒት ዮእና ንቶ! ኤሴ ሀኦስ ሀሽ ሀውጙ ቢስቴፋት ዎኖ ጌያስ ሀቶኒ ባኬስታክ ፉርኣሶን ኤካ ማይስር ስንናኔን ንቶትን ኣካክ አሪክስራ ማይሱ ቤይንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ኤሴ አዉ ሙኒታሶ? አዉ ኡሻኒታሶ? አዉ ማያኒታሶ? ኡክ ራካቶትታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ኤስ ባሮን ዙትሬ ኣዛብኒ ሜያኑ ሾልሴቴርዋ። ኤስ ባር ዙቴራ ንቶክ ሾልስፋናማቶ ሳማኪ አባንቲስ አሪፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ስኑንታኖ ንቶ ዜምማ ሀኦሲ ታቶኖናዋ ኦኮ ስና ባሮንና ሾሎት። ኤስ ዉዛሲክቶ ዙቴራ ንቶክ ዳይቴራ እምቶና። ");
INSERT INTO jnje_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ኤስ ባሪ ቦርኣ ዎኖትሶን ሳፋሮክ ራካቶትታ። ዎኖትሲክ ዎኖት ዎናስ ባሪክ ራካቶን። ዎናሲክ ማጙባስ ሆሮናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«ንቶስታ ማጝሱ ካቶኖይናማቶ ኦኒስታኑ ማጝሱ ካርአትታ። ");
INSERT INTO jnje_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ንቶ ኦም አሱሳታ ማጝሱ ካርፌትስነ ፋ ማጝሱኒ ካርአ ንቶስታ ደይ ካቶና። ኤሲስማቶ ደይ ንቶ ኦሚሲክ ሳፋሬፌት ሳፋሬሲክ ዎላ ንቶክ ሳፋርቶና። ");
INSERT INTO jnje_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ነ ኣፋሲ ኩኒ ቱቻሶን ቢኖይ አይኔሳ ኣፍስ ኩኒ ዲማሶን ኣካክ ቢትሶ? ");
INSERT INTO jnje_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ወደይ ነ ኣፋሲ ኩኒ ቱቻ ፌን አይኔስን ‹ኣፍኔስ ኩኒ ዲማሶን ክሱናዋ› ኣካክ ይፋሶ? ");
INSERT INTO jnje_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ስኖይ ስንነ ቤስቴፌ ነ ዜምማ ነ ኣፋስ ኩኒ ቱቻሶን ክሳት ኤሴን ኦርፎ አይኔሳ ኣፍስ ኩኒ ዲማሶን ክሱታክ ጋሳሲራ ብያታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ኮርቶ ስና ዉዛሶን ካናሲክ እማትታ። እንቁንትሶን ሙኮሲ ስና ሀኡትታ። ሙኮሲክቶ ዎቾባሲክቱ የርአና። ካናሲክቶ ደይ ዎል ላ ንቶትን ሳርአና። ");
INSERT INTO jnje_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«ሺጶት ንቶክ እምቶና፤ ሾሎት ዳናት፤ ጋማላሶን ክእት ንቶክ ጋቾና። ");
INSERT INTO jnje_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ሺጴ ባር ዙቴሬ ኤጴቶና፤ ሾሌፌ ባር ዳናና፤ ጋማላሶን ክእፌ ባሪክ ጋቾና። ");
INSERT INTO jnje_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ንቶስን ናባስ ዳቦ ማምሲን ሹአ እምኒ አባ ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ኩርጡምሚ ማምሲፋናን ዛዋ እምኒር ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ኤሴ ንቶ ማጙ አሱ ስንፋት ናንጎትኒትሲክ ማአ ዉዛ እማ አሪትኔን ኤኪን ደን ሳማኪ ፌ አባንቲስ ሺጴፌ ባሶክ ፉቶሲክ ኣካ ዳይስሬ እማ ቤይንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ኤሴ አሱኒ ሜያ ንቶክ ዛግሶነክ ሾሌፌት ባሮን ዙትራ ንቶ ደይ ኦሚሲክ ኤሲስማቶ ዛጉት። ቱማሴዋ ራጁኒ ሜኒ ካማሴ ኤሲሶንቱ ማኬፋ። ");
INSERT INTO jnje_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«ቱጎ ፍኚኒ ካሞ ግሩት፤ ትሹኒ ፍኚስ ኡጉንባስ አካማ ታጋ፤ ኤስ ፍኚሲ ካሞ ግሪፌ ባሶ ደይ ሾዎ። ");
INSERT INTO jnje_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ካኒ ኬር ታምፋ ኡግናሲ ፍኛ ቱጎዋ። ኡጉንባስ ደይ ትርእኦዋ። ኤስ ባሮን ዳኒ አሱኒ ሜያ ደይ ኪስኩዋ። ");
INSERT INTO jnje_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«ስካሎቤሲስ ቦእኛ እሪርካነ ፌር ስንነፋት ፋንቱኒ ኮማ ማየ ንቶ ጋነያስ ዮሶነክ ፌ ኤሽ ራጁኒ ሜያኪን ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ባሶትን ደይ አሪሶትስ ጋንቤሲስታክዋ፤ ሴርአሲኪን ዋይኒን ጋና ወደይ አሴዋስኪን ቤለስኒ ጋና ኬጵቴሮሶ? ");
INSERT INTO jnje_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ኤሲስማቶ ማአ እኦስ ዙቴራ ማአ ጋናቱ ጋንፋዋ። ማጙ እኦስ ደይ ማጙ ጋናቱ ጋንፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ማአ እኦስ ማጙ ጋና ጋናናክ ወደይ ማጙ እኦስ ማአ ጋና ጋናናክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ማአ ጋና ጋኖይ እኦሲክቶ ዙቴራ ካቴራ ጌሲ ሀቶና። ");
INSERT INTO jnje_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ኤስ ባሪ ቦርኣ ኤሽ ራጁኒ ሜያኖን ጋንቤሲስታክቱ አሩት። ");
INSERT INTO jnje_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«ደን ሳማክ ፌ አባታሳ ፍቃድኖን ዛግፌ ባርቴኖ ታን፦ ‹ዳሚሶ! ዳሚሶ!› ይፌ ባር ዙቴሬ ሀኦኒ ታቶሲ ኣፋ ግሩና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ማጝሱኒ ካርኒ ዎኖ ሾዎቤሲስ፦ ‹ዳሚሶ! ዳሚሶ! ነ ሱናሲክ ራጅ ኣነ ማኮዌኒኖሶ? ነ ሱናሲክ ኪና አያናሶን ኣነ ክሱዌንኖሶ? ነ ሱናሲክ ሾዎ ቢስቴራ አሪቶኖይ ዉዛ ኣነ ዛጉዌንኖሶ?› ኡሶነ። ");
INSERT INTO jnje_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ኤስ ካባሲክ፦ ‹ታ ንቶትን ኣነ አሪፋት፤ ንቶ ማጙ ሜያ ታይስታን ዎክት› ኡና። ");
INSERT INTO jnje_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«ኤሴ ሀን ካምናሶን ኦዴሬ ዎስቶታ ፌሽፌ ባር ዙታምባሴ ኬባሶን ካኦኒ ካፑታ ኬርአ ንብባሬ የሬ አሱነ ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","እሮስ እቺ፥ ኦማራስ ደይ ዎርእ። ስሩስ ደይ ስርራ ኤስ ኬያሶን ቱጊ። ስኑንታኖ ኤስ ኬያስ ካኦታ ካፑቴራ ኬቴራ ዲር ስንና ቦርአ ኣነ ጋንዶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ሀን ካምናሶን ኦዴሬ ዎስቶታ ፌሹኖይ ባር ዙቴሬ ኬባሶን ፉቱታ ኬርአ ጎዋ አሱነ ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","እሮስ እቺ፤ ኦማራስ ደይ ያ። ስሩስ ደይ ስርራ ኤስ ኬያሶን ቱግን ጌሬጌሬ ጋንደ። ጋንዶባስ ደይ አካማ ማጙ ስኒ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","የሱስ ኤስ ዉዛሲክቶኖን ማኬሬ ኮእስናኔን ኦርፎ ዳራኒ ሜያ ባር ማኬና አሱሲክ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ኤስ ዳራኒ ሜያ ዲንቀሴቴስ ሙሴኒ ቱማሲ አስሲኛኒማቶ ስኖይናማቶ እሳ ሀእሱኒ ሁግናባ ፌና አሱኒማቶ አሲት ፌር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","የሱስ ኣማስታን ኬሬፌና ካባሲክ ሾዎ ዳራ ባርኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","እሳ አዋታቶኒ ሜታን ባርኪ ታእሴሬ፦ «ዳሚሶ! ታን ሹንፋታነ ፋቱታክ ችማታዋ» ይት ሳጋደ። ");
INSERT INTO jnje_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","የሱስ ኩሹባሶን ሾሬ ታእፋት፦ «ሹንፋዉጝዋ ካይምማ» ይን ጌሬጌሬ ሜሮባስን ፋር። ");
INSERT INTO jnje_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ኤስታን የሱስ፦ «ፋሩኔሶን ኦኒክኑ ማኮታታዋ። ስኑንታኖ ሀማ ቴትኔሶን ማግኒክ ቤሱዋ። ባሶክ ዛላ ስናናክ ፋሩኔሶን ቤስፋ ሙሴ አጃጀና ማኣሶን እማ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","የሱስ ክፍርናሆምኒ ካታማሲ ካርፌና ካባሲክ እሳ ት ሜያ ታርኦኒ ሜኒ ጋኛ ባርኪ ዬሬ ኤካ ይት ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«ዳሚሶ! ዎስትኛታስ ላፋ ስንነ አካማኖን ሜቴሬ ኬር ኩንፌርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","የሱስ ደይ፦ «ታ ያራ ዎስትኛኔስን ፋቱናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ት ሜያ ታርኦኒ ሜኒ ጋኝኛስ ዎልግሬ፦ «ዳሚሶ! ነ ታክ ኬር ግሩታክ ታ ሾልሱ አሱቴዋ። ስኑንታኖ እሳ ካምኒን ማኬፋታነ ዎስትኛታስ ፋሩናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ታ ደይ ኦም ጋኜ ሜኒ ሀእሱሲ ስካሎስቱ ሀእፋዉጝዋ። ታ ደይ ታ ስካሎሲ ሀእስፋና ሜያ ታርኦኒ ሜያ ፌሴቴርዋ። እሳይስን ‹ኤክ ሀማ› እያናነ ሀማር። ኦሚስን ደይ ‹ዮዋ› እያናነ ዬር። ዎስትኛታስን ደይ፦ ‹ሀን ባሮን ዛጉዋ› እያናነ ዛግር» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","የሱስ ኤስ ባሮን ኦደናይሴ ዲንቀሬ ባርኔን አነ ፌሴ ባሶክ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፤ እስራኤልኒ ሜኒ ጋነያስኑ ኤፋቴና አማንቶባሬ የሬ አሱኒን ኣነ ዳኑትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ንቶክ ማኬፋውጙዋ፤ ሾዎቤሲስ አዉኬሳናዋ አዉግሩና ዬሴሬ አብራሀምኔን እሳቅኔን ያቆብኔን እሳሪክ ሀኦሲ ታቶኒ ማድታ አነ ሙሶነ። ");
INSERT INTO jnje_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ስኑንታኖ ሀን ሀኦሲ ታቶስ ግርሶነክ ቴግቴሬ ፌ ባሶ ኤክ ጌራካሎ ታልማስቱ ሀእቶሶነ። ኤስታክ ዋስነዋ ሀእኒ ኮየት ፎነ ባሶክ ስናና» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","የሱስ ት ሜያ ታርኦኒ ሜኒ ጋኝኛስን፦ «ሀማ፥ አማንቶኔስማቶ ኔክ ስንፋውጝዋ» ይ። ዎስትኛባስ ደይ ኤስ ካባሲክ ፋሪ። ");
INSERT INTO jnje_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","የሱስ ጴጥሮስኒ ኬር ግሪፌና ካባሲክ ጴጥሮስኒ አሱሲ እንቶ ጉምታኒ ሜሮ ሜቴራ ኩንፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","አሱሲ ኩሹኖን ታእን ሜሮስ ደይ ማእ። ካብራ ደይ ባሪን እርባስ። ");
INSERT INTO jnje_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ዋልፋና ካባሲክ ኪና አያና ኤጰና ሾዎ አሱኒ ሜያኖን የሱስኒክ ኤጴ ዬሴቴን ባር ኤስ ኪና አያናሶን ካምባሲክ ክሲ። ደይ ሜታኒስን ዙትሬ ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ኤስ ባሮን ዛጉባሲክ ራጁ እሳያስኒ ማፃፋሲ፦ «ባር ሆፕኒሶን ኤጴ ቴ፤ ሜሮኒሶን ደይ እኖስታን ካብግ» ይሬ ማኬና ራጂስ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","የሱስ ሾዎ አሱኒ ሜያ ብራቶባስታ ዙቶሶቤሲሶን ብያት ባርሲ የሳሎ ፍኖነክ ናዎኒ ሜያኖን አጃጄ። ");
INSERT INTO jnje_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ኤስታን እሳ ሙሴኒ ቱማሲ አስሲኛ የሱስኒክ ዬሬ፦ «አስሲኛኖ፥ ነ ሀምፋታ ድማ ዙታምባሴ አሲስ ነኔን አነ ሀማናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","የሱስ ዎልግሬ፦ «ቦዋሲክቶ ሀእፋና ዶእባ ፋርዋ። ሳማኪ ፉልፋ ካሳስ ዲፋና ኬባ ፋርዋ። ስኑንታኖ አሱኒ ና ቴትባሶንኑ ቴሱና ድምባ ኣፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ናዎባሳስን ኦሚስ «ዳሚሶ፥ ዜምማ ሀማ አባታስ ክትቴን ካባሮናክ ማእ ኡዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","የሱስ ዎልግሬ፦ «ታኔን ሀምንዋ፥ ክቱቤሲሶን ካባርሶነክ ክቱኒ ሜያክ ቤይዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ኤስታን የሱስ ጎኑሲ ግርን ናዎባሳክቶ ደይ ባርኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ባሪስታክ አካማ አካኒ ጉቦስ ካብራ ጎኑሶን ኮርአናክ ካርእ። ስኑንታኖ ኤስ ካባሲክ የሱስ ኩንፌር። ");
INSERT INTO jnje_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ናዎኒ ሜያ የሱስኒኪ ዬሴሬ፦ «ዳሚሶ ትሹንርዋ፥ እኖትን ፉአይዋ» ይሴት ኑሲክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","የሱስ ደይ፦ «አማንቶኒትስ ዮእና ንቶ አዉኒ ቦርአ ድጌፌትሶ?» ይ። ኤስታን ካብሬ ስሩሴዋ ባሪሴ አሲን ኬእን አካማ ናጋ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","አሱኒ ሜያ ዲንቄሴሬ፦ «ስሩሴዋ ባሪሴ አጃጃሜና ሀን ባር አሮ አሱንሶ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ባሪሶን ፍን ነ ጌርጌሴኖን ስንፋ ዳስታክ ካርፌና ካባሲክ ኪና አያና ኤጵና ሄፕ አሱ ሞጋስን ኬሴ የሱስኔን ኡጰሴቴ። ኤስ ሄፕ አሱኒ ሜያ አካማኖን ማጙ ስንነቴ ቦርአ አሱ ኤስ ኡግናሲክ ኣታ ኣነ ችምፌ። ");
INSERT INTO jnje_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ኤስ ሄፕ አሱኒ ሜያ ደይ፦ «ነ ሀኦኒ ና የሱስኖ፥ እንኖ ነኔን አነ አዉኒ እሳርን ፋሪንሶ? ዎናስ ካርኖይፌን እኖትን ራክሱታክ ያቶሶ?» ይት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ባሶስታን ዎክሶክ አካማ ሾዎ ሙኮኒ ዎዶ ፌሽ ድምታ ማድፋር። ");
INSERT INTO jnje_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ኪና አያናስ ደይ፦ «እኖትን ክሱታር ስንፋናነ ኤክ ሙኮስ ዎዶስ ሀማኒክ ዛጉዋ» ይት ሺጵሴ። ");
INSERT INTO jnje_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","የሱስ ደይ፦ «ሀሞት» ይ። ኪና አያናሲክቶ ደይ ኬሳ ሀማ ሙኮሲ ዎዶስ ግርሴ። ኤስታን ሙኮሲ ዎዶ ዙቴራ ኩማስታን ዬት ባሪሲ ታፕቴራ ኤልላ አካሲ ግርራ ክትሴ። ");
INSERT INTO jnje_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ሙኮሶን ኬምፌ ኬዞሳክቶ ደይ ካታማሲ ሀምሜ ኪና አያና ኤጵና አሱኒ ሜኒ ቾዋሶንናዋ ስና ዉዛሶንና ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ካታማሲ ፌ አሱኒ ሜያ ዙቴሬ የሱስኒን ብዮነክ ኬሴቴ። ዳቤሲሶን ጋፍክሬ ሀማናክ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ኤሴን ኦርፎ የሱስ ጎኑሲ ዲሬ ባሪሶን ፍን ነ ዳባስታክ ካታማሲ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ኤስታክ አሱኒ ሜያ ኦፖታ ኩኒ እሳ ላፋ አሱኒን የሱስኒኪ ኤጴ ዬሴቴ። የሱስ አማንቶቤሲሶን ብያት፦ «ነ ሀን ናታሶ! ሀሬዋ፥ ቦርኔስ ፌሹን ኡኖን ዳኒትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ሙሴኒ ቱማሲ አስሲኛሳስን እሳ እሳይስ ንብቤሲስ «ሀን ባር ሀኦስታ ሜእኒ ካማ ማኬዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","የሱስ ደይ ባሶ ሳፋራሶን አሪፋት፦ «አዉኒ ቦርአ ንብንትሲ ኤፋቴና ማጙ ዉዛ ሳፋሬፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ቦርኔስ ፌሹን ኡስጝዋ ወደይ ካብራ ሀማ ኡስንሶ ካሾይ? ");
INSERT INTO jnje_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ስኑንታኖ አሱኒ ና ሀን ዳስታኪ ቦርኣሶን ፌሹን ኡኒ ሀእሱኒ ሁግናባ ፋናማቶ አሩትክዋ» እያት ላፋ አሱስን፦ «ካብራ ኦፖኔሶን ዎርአ ኬነ ሀማ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","አሱስ ደይ ካብሬ ኬባ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ዳራስ ደይ ኤስ ባሮን ብያት ዲንቀሴቴ። ሀን ኤፋቴና ሀእሱኒ ሁግናሶን አሱኒክ እማ ሀኦሶን ደይ ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","የሱስ ኤስ ድማስታን ካብሬ ሀምፌን ማትዎስ ይስቴ እሳ አሱ ግርቦ ዙቴፋና ድማስታ ዲፌን ብያት፦ «ታኔን አነ ሀምንዋ» ይ። ባር ደይ ካብሬ ባርኔን አነ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","የሱስ ማትዎስኒ ኬር ሙ ሙናክ ታእሴሬ ፌን ሾዎ ግርቦ ዙትፌ ባሶትናዋ ቦርእኒ ሜና ኤስታ ዬሴሬ የሱስኔን ናዎባሳክቶኔን አነ እሳሪክ ማድታ ሙክ ታእሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ፌርሳዊኒ ሜያ ኤስ ባሮን ብየፋት ናዎባሳክቶኒን፦ «አስሲኛኒትስ አዉኒ ቦርአ ግርቦ ዙትፌ ባሶኔን ቦርን ሜያ ኔን አነ ሙ ሜድፌሪንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","የሱስ ኤስ ማክሴቴ ባሮን ኦደፋት፦ «ሄትኒ አሱ ሾልስፌናስ ሜታኒ ሜያክታኖ ፋያኒ ሜያክታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ሀምፋት፦ ‹ታ ሾሌፋናስ ፋክያሶንታኖ ማኣሶንታዋ› ይስቴራ ትቼ ባር አዉ ስንናማቶ ፌሬትራ ጋሳሱትዋ። ታ ያናስ ኦኮኒ ሜያክ ስኖይናሮን ቦርእኒ ሜያ ሀርምያ ዛግሶነክ ቴጎናክዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ኤስ ካባሲክ ዮሀኒስኒ ናዎሳክቶ የሱስኒክ ዬሴሬ፦ «እኖትናዋ ፌርሳዊኒ ሜና ሾዎ ዎና ሶሜራ ሺጴኒርዋ። ስኑንታኖ ነ ናዎሳክቶ ሶሜሬ ሺጶ ቤየፌስ አዉኒ ቦርአንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","የሱስ ባሶክ ኤካ ይሬ ዎልጊ፦ «ማሪስ ባሶኔን አነ ፌን ሞዝግቱን ሜያ ሱሞክ ችሞነሮሶ? ስኑንታኖ ማሪስ ባሶስታን ኦር ኬሴ ሀማና ዎና ዮናዋ። ኤስ ካባሲክቱ ሶሜሬ ሺጵሶነዋ» ");
INSERT INTO jnje_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ኩርኡ ማማታ ጋድዶ ኤርቤ ኩንስሬ ዞርፌ አሱ ኦኑ ኣፌዋ። ኤካ ዛጋናነ ጋድዶ ኤርቤስ ኩርኡ ማማሶን ኮጝስርዋ። ካራቶባስ ደይ ታግር። ");
INSERT INTO jnje_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ኤሲስማቶ ኩርኡ ሀማቶሲ ጋድዶ ዋይኒን ኡሻ ጌድፌ አሱ ኦኑ ኣፌዋ፤ ስኑንታኖ ኤካ ዛጋናነ ሀማቶስ ካራቴራ ዋይኒስ ኡሻ ደይ ዉክቴርዋ። ሀማቶስ ደይ ኬእኖር ስናርዋ። ኤስ ባሪ ቦርኣ ጋድዶ ዋይኒን ኡሻሶን ጋድዶ ሀማቶሲ ጌዳ ሾልሱዋ። ሄፖባሴ ደይ ማአሪክ ዱና። ");
INSERT INTO jnje_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","የሱስ ኤስ ባሮን ማኬፌን እሳ ጋኛ ባርኪ ዬሬ ስንባ ካአኔሬ፦ «ናናስ ክትዋ፥ ያራ ኩሹኔሲክ ታእፋታነ ፋሩናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","የሱስ ደይ ካብሬ አሱስኔን አነ ሀሚ። ናዎባሳክቶ ደይ አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ኤስታክ አሲሬ ሄፔ ዎግጋ ሀርንባስ ዉክቴት ፋና እሳ ማሽካሱ የሱስኒን ኦርፎ ካሞ ያራ ማምባሶን ታእ። ");
INSERT INTO jnje_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ባር ደይ ንብባሲ፦ «ማምባሲ ፋሻኖኑ ታእፋናኔ ፋሩናዋ» ይት ፋር። ");
INSERT INTO jnje_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","የሱስ የርቄሬ ባርኪ ብያት፦ «ሀሬዌ ናናሴ! አማንቶኔስ ኔን ፋትዌ» ይ። አሱስ ደይ ኤስ ካባሲክ ፋሪ። ");
INSERT INTO jnje_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","የሱስ ጋኛአሳ ኬር ካርፌና ካባሲክ ዋሴት፥ ማርካታ ፉጌትናዋ ሳሴትና የሬ ዳራኒና ቢ። ");
INSERT INTO jnje_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","የሱስ ደይ፦ «ናዋስ አፋይኒንቱ ኩንታኖ ኣነ ክቱዋ፤ ሀንታን ሻቶትዋ» ይን ባሪን ካኘሬ ምእኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ዳራስን ክስናኔን ኦርፎ ኬር ግሪሬ ናዋሲ ኩሹኖን ዛትን ዳኩን ካቢ። ");
INSERT INTO jnje_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ኤስ ቾዋሲ ዎላ ኤስ ዳ ዙታምባሴ አሲስ ዝእ። ");
INSERT INTO jnje_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","የሱስ ኤስ ድማስታን ካብሬ ሀምፌን ሄፕ ኣፍትሹኒ ሜያ፦ «ዳዊትኒ ናሶ! እኖትን ፋክፋይዋ» ይት ቻጌት ባሳ ኦርፎሴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ኣፍትሹሳክቶ የሱስ ግርና ኬያሲ ግርሴቴ። ባር፦ «ታ ኣፍንትሶን ጋቻክ ችማናማቶ አማነፌትዮሶ?» ይሬ ማምሲ። ባሶ ደይ፦ «ኣ፥ አማነፌኒዋ፥ ዳሚሶ!» ይት ዎልግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ኤስታን የሱስ ኩሹባሲክ ባሶ ኣፋሶን ታእፋት፦ «አማንቶኒትስማቶ ንቶክ ስንፋውጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ኣፌሲስ ደይ ጋችቼ። የሱስ ደይ፦ «ሀን ዉዛሶን ኦኒክኑ ማኮትታዋ» ይት ችኒሬ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ስኑንታኖ ባሶ ኤስታን ኬሴሬ ኤስ ዳ ዙታምባሴ አሲስታ ባሳ ቾዋሶን ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ኤስ ኣፌሲስ ጋችቼና ባሶ ኬሴ ሀሜፌ ካባሲክ ኪና አያና ኤጵና እሳ ንብታቶ አሱኒን ኤጴ የሱስኒኪ ቴሸሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ኪና አያናስ አሱሳስን ኬስናኔን ኦርፎ ንብታቶስ ደይ ዎል ሌ። ዳራስ ደይ፦ «ኤፋቴና ዉዛ እስራኤልኒ ዳስታኪ እሳንነ ኣነ ቢስቴራ አሪቶዋዋ» ይሴት ዲንቄሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ስኑንታኖ ፌርሳዊኒ ሜያ፦ «ኪና አያናሶን አሱሳስን ክስፌናስ ኪና አያናሲ ጋኛኒክዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","የሱስ አይሁድኒ ሺጶኒ ኬያሲ አሲት ሀኦሲ ታቶኒ ምስራቹኒ ካማኖን ማኬት ዳራሳሲ ፋ ሜሮሶንናዋ ራኮቤሲሶንና ዙትሬ ፋቲት ካታማስናዋ ኬኤ ዙታምባሴ አሲስና ኩቲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ዳራስ ኬዞባ ፎንቶ ፋንቱኒማቶ ራካቴሴፌንናዋ ትርእኦ ባሶትን ኤጳን ፌሴቴማቶና ብያት ባሶክ ኬናሽቴ። ");
INSERT INTO jnje_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ኤስታን ናዎባሳክቶኒክ፦ «ፎሻስ አካማዋ፤ ስኑንታኖ ዎስትኛስ ጋሮዋ። ");
INSERT INTO jnje_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ኤሴ ፎሻስ ዳም ፎሻስታ ዎስቶኒ ዎስትኛኒን ዎሱናክ ሺጶትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","የሱስ አሲሬ ሄፔ ናዎባሳክቶኒን ቴጌሬ ኪና አያናሶን አሱሳስን ክሶነክ፤ ሜሮሶንናዋ ራክኮሶንና ፋቱሶነክ ሀእሱኒ ሁግና ባሶክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","አሲሬ ሄፔ ዎስኒ ሜኒ ሱናስ ሀኒስዋ፦ ጴጥሮስ ይስቴፌ ስሞንናዋ አይባ እንድርያስና፥ ዘብደዎስኒ ናንጎት ያቆብናዋ አይባ ዮሀኒስና፥ ");
INSERT INTO jnje_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ፍልጶስ፥ ቤርቴሌሜዎስ፥ ቶማስ፥ ግርቦ ዙትፌ ማትዎስ፥ እልፍዮስኒ ና ያቆብ፥ ታዴዎስ፥ ");
INSERT INTO jnje_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ኮነፌ ስሞን፥ የሱስኒን ኣትሬ እማ አሲኮሮትኪ ዩዳ። ");
INSERT INTO jnje_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","የሱስ ኤስ አሲሬ ሄፔ ዎስኒ ሜያኖን ኤካ ይት ዎሲ፦ «አዛብኒ ሜያኪ ሀማትታ። ደይ ሳምራዊኒ ሜኒ ካታማስኢ ግሩትታ። ");
INSERT INTO jnje_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ስኑንታኖ ፋንቱኒማቶ ትሽሬ ፌ እስራኤልኒ ዳራሲክ ሀምት። ");
INSERT INTO jnje_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ሀምፋት፦ ‹ሳማኪ ታቶስ ታእሴዋ› ይራ ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ሜታንኒ ሜያኖን ፋቱት። ክትስኒ ክቱኒ ካብጉት። አዋታቶኒ ሜታኒስን ፋቱት። ኪና አያናሶን አሱሳስን ክሱት። ባክ ኤጵት ባሮን ባክ እምት። ");
INSERT INTO jnje_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ዋርቄኪን ወደይ ብርኪን ወደይ ናስኪን ዎሱስቴ ዋጋ ታችአማንትስታ ኮርእራ ኤጳትታ። ");
INSERT INTO jnje_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ዎስትኛኒክ ሙባ ሾልሱ ስንና ቦርአ ኡጉንትሲክ ሀማቶ ወደይ ሄፕ ጋግቴራ ማይቴ ማማ ወደይ ቻእማ ወደይ ሃሮ ኤጳትታ። ");
INSERT INTO jnje_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","እሳ ካታማሲ ወደይ ኬኤስ ግሪፌት ካባሲክ ንቶትን ኤጵኒስ ኦ ስንናማቶ ጋሳሱት። ኤስ ዳሶን ጋፍኪራ ኬሳትኔን ኤስታ ፎቲ። ");
INSERT INTO jnje_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","አሱኒ ኬር ግሪፌት ካባሲክ ናጋ ኦሾሶት። ");
INSERT INTO jnje_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ንቶ ናጋሶን ኤጴቴሴፋቴነ ናጋንትስ ባሶክ ካርአና። ስኑንታኖ ኤጴቶ ቤይፋቴነ ናጋንትስ ንቶክ ዎሉና። ");
INSERT INTO jnje_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ንቶ ማኬት ካማሶን ኤጴቶ ወደይ ኦዶ ቤየፋቴነ ኤስ ኬያስን ወደይ ኤስ ካታማስን ኬስፌት ካባሲክ ዎቾንትስ ቱሎኖን ኤስታ ቴቡት። ");
INSERT INTO jnje_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ታ ንቶክ ፉቶክ ማኬፋውጙዋ፥ ማጝሱኒ ካርእኒ ዎኖት ኬኦስ ኤስ ካታማስታን ሴዶሚክናዋ ጋሞራክናቱ ካሾ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«ኤሴ! ታ ንቶትን ፋንቱኒማቶ እሪርካስ ጋነሲ ዎሱናዋ። ኤስ ባሪ ቦርኣ ንቶ ዛዉኒማቶ ንብኒትሬ የሬር፤ ናካሎኒማቶ ጋራም ስንት። ");
INSERT INTO jnje_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","አሱኒ ሜያ ንቶትን ማጝሱኒ ካርአክ ሾንጎስታ ኣትሬ እሞነ። አይሁድኒ ሺጶኒ ኬያሲክ ደይ ንቶትን እቾሶነ። ኤስ ባሪ ቦርኣ አሱሳታን ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ታ ቾዋሲክ ዳ ሀእሲፌ ባሶክናዋ ታቴ ሜያክና ኦቴራ ሀማትር ስንና ቦርአ ባሶ ስናክናዋ ኣዛብኒ ሜኒ ስናክና ታ ዛል ስናት። ");
INSERT INTO jnje_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","አሱኒ ሜያ ንቶትን ሾጝጎስታ ኣትሬ እሜፌ ካባሲክ ባሶክ ማኮት ባር ኤስ ሳአትስታክ ንቶክ እምቶና ስንና ቦርአ፦ ‹ኣክካ ወደይ አዉ ማኮንታሶ?› ይፌ ሳፋራ ንቶትን ኤጳናታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ንቶሲ ፋራ ማኮኒስ ሳማኪ አባንትሳ አያናታኖ ንቶቴዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","አይስ አይባስን፥ አባስ ናባስን ክቱክ ኣትሬ እማና። ናንጎታስ ደይ አባባሳታናዋ እንቶባስታና ጉማ ስንና ካብራ ክቱክ ኣትራ እማና። ");
INSERT INTO jnje_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ታ ቦርአ አሱ ዙታምባሴ ንቶትን ኦምቶና። ስኑንታኖ ኮእባ ካርአናኔን ችሜ የሬ ባር ፋሩና። ");
INSERT INTO jnje_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","እሳ ካታማሲ ሻና ንቶስታ አሪክስሴፌ ካባሲክ ኦማ ካታማሲ ሻቶት። ታ ፉቶ ንቶክ ማኬፋውጙዋ፤ አሱኒ ና ዮናኔን እስራኤልኒ ዳ ዙታምባሴ አሲስ ኣፋዋ ካርአ ኮእሱት ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","አሪኛአስ አሲፌ ባሳስታን፥ ዎስትኛአስ ዳምባሳታን ኣፋ ደናሎ ስናናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","አሪኛአስ አስሲኛባሳማቶ፤ ዎስትኛአስ ደይ ዳምባሳማቶ ስንፋናነ ሆሮናዋ። ኬኒ አባስን፦ ‹ቤልዘቡልዋ› ይሴቴኔን ኬርኪ አሱኒ ሜያኖን ኣካክ ማጙ ሱና ሱንሱ ቤዮነሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«ኤሴ አሱኒ ሜያኖን ድጎትታ፤ ጌፕቶ ዉዛስ አምማኖን ኬሳ ኣፋ ቤስቶ ቤያና ዉዛ። ኣቾ ዉዛስ አምማኖን ኬሳ ኣፋ ቤያና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ታ ታልማስን ንቶክ ማኬና ባሮን ቻሬፋስታ ማኮት። ሳክሶክ ኦደት ባሮን ቴጋ ድማስታ የሬፋት አዋሱት። ");
INSERT INTO jnje_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","አሻሶን ዎራት ኬሴ ካሶን ዎሩክ ችምኖይ አሱኒ ሜያኖን ድጎትታ። ስኑንታኖ አሻሴዋ ካሴ ዎራት ኬሳ ጌኒ ትርእማስ ትሽኩክ ችምኒ ሀኦሶን ድጎት። ");
INSERT INTO jnje_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ሄፕ ሜጅማሪስ ኡች ዱዴስ ዋግቴርታኖሶ? ኤስ ካሳሲክቶስን እሳርንኑ አባንትሳ ፍቃድ ስኖይፌን ዳስታክ ኬሬ ዎርአ ኣፋ ትሹና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ንቶ ሶማስ ፋሻኑ ዙታምባሴ ፋድቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ኤሴ ንቶ ሾዎ ሜጅማርስታን ደናሎ ስንት ቦርአ ድጎትታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«ታ ቾዋሶን አሱኒ ስናክ ዛላ ማኬፌ ባር ዙታምባሴ አሲክ ደን ሳማኪ ፌ አባታሳ ስናክ ታ ደይ ባርኪ ዛላ ማኮና። ");
INSERT INTO jnje_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","አሱኒ ስናክ ታን ሞርሜፌ ባሪን ዙትራ ታ ደይ ደን ሳማኪ ፌ አባታሳ ስናክ ሞርሞና። ");
INSERT INTO jnje_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ታ ያናስ ሀን ዳስታክ ናጋ ኤጳ ያናር ዛግራ ሳፋሮትታዋ። ታ ፋሶታኖ ናጋ ኤጳ ዮናክ ኣነ ዮትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ታ ያናስ ኣርቃ ናስን አባባሳታ፤ ማሽካ ናዋሶን እንቶባስታ፤ ናሳ አሱኖን ናሳ እንቶታ ጉማ ስንነ ካቡሶነክቱ ያጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ኤስ ባሪ ቦርኣ አሱኒክ ጉማባስ ኬባስ ፌ አሱስቱ ስኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ታይስታን ደናሎ አባባስን ወደይ እንቶባሶን ሹንፌ ባር ታር ስናናክ ኣነ ሾልስፋዋ። ታይስታን ደናሎ ኣርቃ ናባስን ወደይ ማሽካ ናዉባሶን ሹንፌ ባር ታር ስናናክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ባሳ ቴትኒ ሜስቀሊሶን ዎርኤ ታኔን አነ ዮኖይ ባር ታር ስናናክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ካባሶን ፉኦክ ሾሌፌ ባር ዙታምባሴ ትሽኩና። ታ ሱናሲክ ካባሶን ትሽክፌ ባር ዙታምባሴ ፉኦና። ");
INSERT INTO jnje_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ንቶትን ኤጴ ቴ ባር ታን ደይ ኤጴቶና። ታን ኤጴቴ ባር ታን ዎሲ አባስን ደይ ኤጴቶና። ");
INSERT INTO jnje_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ራጁኡስን ራጁኒ ሜኒ ሱናክ ኤጴቴ ባር ራጁኒ ሜኒ ዋጋሶን ዳናና። ኦኮስን ኦኮኒ ሜኒ ሱናክ ኤጴቴ ባር ኦኮኒ ሜኒ ዋጋሶን ዳናና። ");
INSERT INTO jnje_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ፉቶ ንቶክ ማኬፋውጙዋ፤ ታ ናዎ ስና ሀን ጋሮ ጋሮሳስን እሳይሲክ ኮቾ አካ ኩባያክ እማ ባር ዋግባስ ኣፋ ትሹና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","የሱስ አስሬ ሄፔ ናዎባሳክቶኒክ ኤስ አጃጂሶን ማኬሬ ኮእስናይሴ ኤስታን ኬሴ ታእሶስታ ፋ ካታማሲክቶሲ አሱክናዋ ማኮናክና ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ሀጵቅፌ ዮሀኒስ ታቶኒ ኬር ፌጌዶ ክርስቶስኒ ዎስቶሶን ኦዴሬ ናዎባሳስን ባርኪ ዎስሬ፦ ");
INSERT INTO jnje_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«ኤስ ዮኒር ይስቴ ክርስቶስ ነጝዋ ወደይ ኦምንን ኦዳንሪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","የሱስ ደይ ዎልግሬ፦ «ሀምፋት ቢት ባሮንናዋ ኦደት ባሮንና ዙትራ ዮሀኒስኒክ ማኮት። ");
INSERT INTO jnje_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ኣፍትሹኒ ሜያ ብዮሶነር። ኤግትኒ ሜያ ኩቱሶነር። አዋታቶኒ ሜታኒ ሜያ ፋርሶነር። ኦዶ ኦዮኒ ሜያ ኦዶሶነር። ክቱኒ ሜያ ክቱኒ ካብሶነር። ቱካምኒ ሜያክ ምስራቹኒ ካማስ ማክቶኒር። ");
INSERT INTO jnje_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ታ ቾዋሲክ ቱሳኦኖይ ባር ዙቴሬ ሱስቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ዮሀኒስኒ ዎሲሳክቶ ዎሌ ሀሞቤሲሴ የሱስ ዳራሲክ ዮሀኒስኒ ቾዋሲክ ኤካ ይት ማኮ ኤጲ፦ «አዉ ብያትኪንሶ ኢችማ ዳስ ሲ ኬሴትሪ? ስሩስ ሾርክፋና ሶቦቆሶንኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ወደይ አዉ ብያትኪንሶ ኬሴትሪ? ጋዳ ማያ ማዬ አሱኒንኖሶ? ኤሴኑ ጋዳ ማያ ማዬ ባሶ ታቴ ሜኒ ኬርቱ ፌሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ወደይ አዉ ብያትኪንሶ ኬሴትሪ? ራጁኒኖሶ? ንቶክ ማኬፋውጙዋ፤ ራጁሳታን ደናሎ ስና ባርጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","‹ኤሴ ኡጉኔሶን ሳብሱን ዎስታስን ነ ስናስታ ዜምማ ዎሱናዋ› ይስቴራ ትቼናስ ባሪክዋ። ");
INSERT INTO jnje_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ፉቶ ንቶክ ማኬፋውጙዋ፤ ማሽካሱኪን ኮንቴ አሱኒ ሜኒ ጋነያስን ሀጵቅፌ ዮሀኒስኒስታን ደናሎ ኣነ ካቡየዋ። ስኑንታኖ ሳማኪ ታቶሲ አቴር ስና ባር ዮሀኒስኒስታን አሪኩና። ");
INSERT INTO jnje_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ሀጵቁኒ ዮሀኒስኒ ነያስታን ካብራ ሀሽ ሀውጙ ካርአናኔን ሳማኪ ታቶስ አካማኖን ቱግቴቱ ፋ። ስር ግሩክ ካቤፌ ባሶ ዳኖነ። ");
INSERT INTO jnje_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","«ራጁኒ ሜኒ አሱሴዋ ሙሴኒ ቱማሴ ሀጵቅፌ ዮሀኒስኒ ነያስታ ካርአናኔን ራጅ ማክቴ። ");
INSERT INTO jnje_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ኤሴ ደይ ኤጴቶክ ሾሌፋትነ ዮኒር ይስቴ ኤልያስ ሀን ዮሀኒስዋ። ");
INSERT INTO jnje_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ኦዶኒ ኦዶባ ፌና ባር ኦዶዎዋ። ");
INSERT INTO jnje_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«ኤኪን ሀን ዎን ኒ ኮንቶሶን አዉኔን ሆሱናሪንሶ? ጋባታ ዲሴፋት ዞሞባሶን ቴግሴፋፋ፤ ");
INSERT INTO jnje_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹ኡሉለ ንቶክ ፉግኒ፥ ኣነ ሱሩዌት። ሶሶ ሶሶኒ ኣነ ዋሱዌት› ይሴፋ ናንጎታስንነ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ዮሀኒስ ሙኖይናዋ ዋይንኒ ኡሻ ኡሽኖይና ዬን፦ ‹ኪና አያና ባሳስ ፋርዋ› ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","አሱኒ ና ሜትናዋ ዋይንኒ ኡሻ ኡሸትና ዬን፦ ‹ሙነዋ ዋይንኒ ኡሻ ሹናር ደይ ግርቦ ዙትፌ ባሶናዋ ቦእርኒ ሜና አሲ ኮንዋ› ይሴቴ። ስኒፋናክኑ ማፃፋሲ ፉቶ ስና ዎስቶባሲክ አሪቴዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ኤስታን የሱስ አሪክሮን ቢስቴራ አሪቶኖይ ዉዛ ዛግቴና ካታማሲክቶኒ ሀርሙ ቤያሲክ ኤካ ይት ዌኦ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«ሀይቡነዌ ኮራዝን፥ ሀይቡነዌ ቤቴሳይዳ! ንቶሲ ዛግቴ ቢስቴራ አሪቶኖይ ዉዛስ ጥሮሱክናዋ ስዶናክና ዛግቴ ስንፋናነ ሱሞኒ ማያ ማየሬ ቤድና ቴትቤሲስታ ዎችሬ ሾዎ ዎና ዜምሜ ሀርሙሶነ ካባዌ። ");
INSERT INTO jnje_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ኤሴ ንቶክ ማኬፋዉጝዌ፥ ማጝሱኒ ካእርኒ ዎኖ ኬእኦስ ንቶስታን ትሮሱክናዋ ስዶናክናቱ ካሾ ስናናዌ። ");
INSERT INTO jnje_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ክፍርናሆምነ ደን ሳማ ቴግቶሴ? ዬት ኬእኦኒ ድማስቱ ኬሮታርዌ። ነይስ ዛግቴ ቢስቴራ አሪቶኖይ ዉዛስ ሶዶሙክ ዛግቴ ስንፋናነ ባር ትሹኖይ ሀሽ ሀውጙኔን ካርአ ፎና ካባዌ። ");
INSERT INTO jnje_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ኤሴ ኔክ ማኬፋዉግዌ፤ ማጝሱኒ ካርኒ ዎኖ ነይስታ ካርኒ ኬእኦስታን ሶዶሚክቱ ካሾናዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ኤስ ካባሲክ የሱስ ኤካ ይ፦ «ሳማሴዋ ዳሴ አሲ ዳም አባታሶ! ሀን ባሮን ቴቹምኒ ሜያክናዋ አሩኒ ሜያክንና ኣቻት ሀን ጋሮ ጋሮ ናንጎታሲክ አምማኖን ክስራ ቤስታ ባሪክ ኔን ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ኣ፥ አባታሶ ሀን ባሮን ዛጉታክ ነ ማአ ሳፋራ ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","አባታስ ዙታምባሴ አስን ታክ እምዋ። አባስኔን ኦም ናስን አሪፌር ኦኑ ኣፌዋ። ኤሲስማቶ ደይ ናስኔን ኦም አባስን አሪፌር ኦኑ ኣፌዋ። ናስ አምማኖን ክስሬ ቤሱ ሻካናነ አባስን ኦኑ አሩክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«ንቶ ባአንት ፋይና ሆፒስ ዙቴራ ታክ ዮትዋ። ታ ንቶክ ቤይሳ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ዋንጆናሶን ዎርቲ፤ ታኪን ደይ አሩትዋ። ታ ጋራም ደይ ኬናሽቴርዋ። ካንትሲክ ደይ ቤይሳ ዳናት። ");
INSERT INTO jnje_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ዋንጆናስ ኩልኖር፥ ባአናስ ደይ ካሾዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ኤስ ካባሲክ የሱስ ቤይሳኒ ዎናሲክ ዛጎኒ ፎሻሲ ጋነሲ ካሞ አቴ ሀሚ። ናዎባሳክቶ ማክቴሴቴ ቦርአ ቦና ዛጎሶን ሞኤ ኮያ ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ፌርሳዊኒ ሜያ ኤስ ባሮን ብየፋት፦ «ነ ናዎሳክቶ ቤይሳኒ ዎናሲክ ዛግቶናክ ካልቶ ዉዛሶን ዛግሴድፌዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","የሱስ ደይ ባሶክ ኤካ ይ፦ «ዳዊትናዋ ባርኔን አነ ፌሴ አሱኒ ሜና ማክቴሴፌ ካባሲክ ዳዊት አዉ ዛግናማቶ ኣነ ፌሬቱዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ሀኦሲ ኬር ግሪሬ ማግኒ ሜያክታኖ ባሪክ ስኑን ባርኔን ፌሴ አሱኒ ሜያክ ካልቶ ኮርቶ ዳቦሶን ሜዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ወደይ ማግኒ ሜያ ቤይሳኒ ዎናሶን ኦዳ ቤየ ቤቴሜቅደስ ዎስቶ ዎስቴሴፋቴነ ቦርአ ስንና ኣነ ፋድቴፋ ስንናማቶ ሙሴኒ ቱማስን ኣነ ፌሬቱዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ስኑንታኖ ታ ንቶክ ማኬፋውጙዋ፥ ቤቴሜቅደሲስታን ደናሎ ስና ባር ሀንታ ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‹ፋክያሶንቱ ሾሌፋንታኖ ማኣሶንታዋ› ይፋ ማፃፋሲ ካማ አዉ ስንናማቶ ያዳቴት ስንፋናነ ቦርቤስ ፎንቶ ባሶስታ ማጝሱ ካርአት ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ኤሴ አሱኒ ና ቤይሳኒ ዎናሲክኑ ዳምዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","የሱስ ኤስታን ኬሴ ሀሜ አይሁድኒ ሺጶኒ ኬያሲ ግሪ። ");
INSERT INTO jnje_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ኤስታክ እሳ ኩሹባ ላፋ አሱ ፌር። የሱስኒን ማላቶክ ሾሌት ፌሴ እሳ እሳ አሱኒ ሜያ፦ «ቤይሳኒ ዎናሲክ ሜታኒን ፋቱ ፋቃድቶጝዋ ኣነንሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","የሱስ ባሶክ ዎልግሬ፦ «ንቶ ጋነያስን ፋንቱባ ፋና እሳ አሱ ቤይሳኒ ዎናሲክ ጋዉሲ ጋንደፋናነ ክሱኖር ኦንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","«ኤሴ አሱ ፋንቱስታን ደናሎ ኣካክ ስና ቤይንሪንሶ? ኤስ ባሪ ቦርኣ ቤይሳኒ ዎናሲክ ማአ ዉዛ ዛጉ ኣነ ካልቶዋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ኤሴን ኦርፎ ኩሹባ ላፋ አሱስን፦ «ኩሹኔሶን ዜጵዋ» ይን ዜጲ። እሳ ኩሹስማቶ ደይ ማአ ኩሹ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ስኑንታኖ ፌርሳዊኒ ሜያ ኤስታን ኬሴሬ የሱስኒን ኣካክ ዎርሶነማቶ ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ስኑንታኖ የሱስ ባሶ ማጙ ሳፋራሶን አራት ኤስታን ሻቴ። ሾዎ አሱኒ ሜያ ደይ ባርኔን አነ ሀሜቴ። ሜታኒ ሜያኖን ደይ ዙትሬ ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ባር ኦ ስንናማቶ ክሲሬ ማክሶኖይቴማቶ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ኤስ ባር ደይ ስንናስ ራጁ እሳያስኒ ማፃፋሲ ትቼራ ኩኒ ባር ስናናክዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ኤሴ ታ ኮሪና ዎስትኛታስ ሀን ባርዋ፤ ባሪን ታ ሹናር ደይ ባሪክቱ ግሬፋን፤ አያናናሶን ባሳስታ ዛጉና፤ ባር ፉቶኒ ማጝሱኒ ካርኣሶን ዳራሲክ አዋሱና። ");
INSERT INTO jnje_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ባር ኣፋ ካራካሮና ዉዛ፤ ደይ ኣፋ ቻጋና ዉዛ፤ ካምባስ ጌሮ ኬሳ ኣፋ ኦዶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ሜስቴራ ኤስቶ ሶቦቆሶንኑ፤ ኣፋ ኪርአና ዉዛ፤ ቹዌት ድ ካርኣሶን ኣፋ ትሽኩናዉዛ፤ ኤስ ባሮን ዛጉናስ፤ ፉቶኒ ማጝሱኒ ካርኣሶን ሜሮናኔጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ኣዛብኒ ሜያ ባሳ ሱናሲክቱ አብዲ ዛግሶነ። ");
INSERT INTO jnje_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ኤሴን ኦርፎ አሱኒ ሜያ ኪና አያና ኤጵና ኣፍትሹ ንባ ታቶ አሱኒን ኤጴ ዬሴቴ። የሱስ ደይ ፋትን አሱስ ብያክናዋ ዎሎክና ችሚ። ");
INSERT INTO jnje_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ዳራስ ዙቴሬ ዲንቀሴሬ፦ «ሀን አሱስ ዳዊትኒ ናቴሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ስኑንታኖ ፌርሳዊኒ ሜያ ኦደሴሬ፦ «ሀን ባር ቤልዘቡል ይስቴፋ ኪና አያናሲ ጋኛኒክ ስና ሻካናነ ኪና አያናሶን ኣፋ ክሱና ዉዛ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ስኑንታኖ የሱስ ባሶ ሳፋራሶን አሪፋት ኤካ ይ፦ «ባሬ ባሬ ኦር ኦር ኬሴት ፋ ታቶስ ዙቴራ ትሹቱ ትሹናዋ። ኤሲስማቶ ደይ ባሬ ባሬ ኦር ኦር ኬሴት ፋ ካታማስ ወደይ ኬያስ ኣፋ ችምማ የሮና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ሴጣናስ ሴጣናሶን ኪስር ስንፋናነ ባሬ ባሬ ኦር ኦር ኬሴዋ ኡዋ። ኤሴ ባሪ ታቶስ ኣካክ ችምማ የሮኒሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ኤሴ ታ ቤልዘቡልንክ ኪና አያናሶን ክሳናኔ ንቶ ዞንስፌት ባሶ አዉክ ክሶነሪንሶ? ኤሴ ንቶ ዞንስፌት ባሶኑ ንቶስታ ማጝሱ ካርኤቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ስኑንታኖ ታ ኪና አያናሶን ክስፋናስ ሀኦሲ አያናክ ስንናኔን ሀኦሲ ታቶ ንቶክ ያራ ካርእዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ደይ እሳ አሱ ዜምሜ ሁግናባ ፌና ባሪን ታርእኖይ ባሳ ኬር ግሪሬ ዋግባሶን ቦኦክ ኣካክ ችምንሪንሶ? ሁግናባ ፌና ባሪን ታርእአቱ ኬያስ ፋዪሶን ቦኦክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ታኔን አነ ስኖይ ባር ታን ቱጋኤር፤ ደይ ታኔን አነ ዙቱኖይ ባር ስኬር። ");
INSERT INTO jnje_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ኤስ ባሪ ቦርኣ ታ ንቶክ ማኬፋውጙዋ፤ አሱ ዎስቴፌና ቦርኣሴዋ ሜኣሴ ዙቴራ ፌሹን ኡስቶና። ስኑንታኖ ሀኦሲ ኮርቶ አያናኖን ሜአ ባር ቦርባስ ኣፋ ፌሹን ኡስቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","አሱኒ ናኒታ ሜእኒ ካማ ማኬፌ ባር ቦርባስ ፌሹን ኡስቶና። ስኑንታኖ ኮርቶ አያናስታ ሜእኒ ካማ ማኬፌ ባር ሀን ዳስታኪ ስኑን ዮን ዳስታክ ቦርባስ ኣፋ ፌሹን ኡስቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«እኦስ ዙቴራ ጋንባስታክቱ አሪቴፋ ስንና ቦርአ ማአ እኦንት ፋፋናነ ማአ ጋና ዳናት። እኦስ ማጙ ስንፋናነ ጋንባስ ደይ ማጙቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ንቶ ኡፎን ናንጎታ ማጙ ስንፋት ኣካክ ማአ ዉዛ ዎሎክ ችምትሶ? አሱ ንብባሲ ቱማ ፉእቴ ባሮንቱ ኖኖባሲክ ዎል ሌፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","«ማአ አሱ ንብባሲ ዙትና ማአ ማዝጋቢስታን ማአ ዉዛ ክስፌዋ። ማጙ አሱ ደይ ንብባሲ ዙትና ማጙ ማዝጋቢስታን ማጙ ዉዛ ክስፌዋ ");
INSERT INTO jnje_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ፉቶ ንቶክ ማኬፋውጙዋ፤ አሱኒ ሜያ ዎሉምሴፌ ስኖይ ማጙ ዎላ ዙታምባሴ አሲክ ማጝሱኒ ካርኒ ዎኖ ዎልጉባ እሞነርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ዎል ሌፋታ ካምኔሲክ ኔክ ማጝሱ ካቶና። ደይ ዎል ሌፋታ ካማሲክ ነይስታ ማጝሱ ካቶና።» ");
INSERT INTO jnje_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ኤስ ካባሲክ እሳ እሳ ፌርሳዊኒ ሜናዋ ሙሴኒ ቱማሲ አስሲኛና የሱስኒን፦ «ነ ቢስቴራ አሪቶኖይ ዉዛ ዛግን ብያንክ ሾሌፌንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ስኑንታኖ ባር ዎልግሬ፦ «ማጙ ኮንቶሴዋ አማኖኖይ ኮንቶሴ ቢስቴራ አሪቶኖይ ዉዛቱ ሾሌፋ። ስኑንታኖ ራጁ ዮናስኒ ቢስቴራ አሪቶኖይ ዉዛስኔን ኦማ ቢስቴራ አሪቶኖይ ዉዛ ኣፋ እምቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ዮናስ እኛ ኩርጡሚሲ ካታሲ ኬዝ ዎንነዋ ዋልነ ኩናማቶ አሱኒ ና ደይ ሞጋሲ ኬዝ ዎንነዋ ዋልነ ኩናና። ");
INSERT INTO jnje_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ነኔዌኒ ካታማሲክ አሱኒ ሜያ ዮናስኒ አዋሱሶን ኦደሴሬ ቦርቤሲሲክ ጋቤሴሬ ሀርምሴቴ ቦርአ ማጝሱኒ ካርኒ ዎኖ ሀን ኔኒ ኮንቶስኔን አነ ካብሴሬ ባሶስታ ማጝሱ ካርኦሶነ። ኤሴ ሀሽ ዮናስኒስታን ደናሎ ሀንታ ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ዬሽዳኪ ማሽካ ታቶስ ሶሎሞኒ ቴችማሶን ኦዶክ ዳኒ ድላን ካብራ ያና ቦርአ ማጝሱኒ ካርኒ ዎኖ ሀን ኔኒ ኮንቶስኔን አነ ካብራ ባሶስታ ማጝሱ ካርአናዋ። ኤሴ ሀሽ ሶሎሞኒስታን ደናሎ ሀንታ ፌርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ደይ የሱስ ኤካ ይ፦ «ኪና አያና አሱኒስን ኬስፋና ካባሲክ ቤይሳ ሾሌት አካባ ፎንቶ ድማስቱ ኩትፋ። ስኑንታኖ ሾሌና ቤይሳሶን ኣፋ ዳናና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ኤስታን ‹ዜሞቲ ኬስና ኬያሲ ዎላ ሀማናዋ› ይፋ። ዎላ ዬን ኤስ ኬያሲ ፋ ዉዝባ ፎንቶ ስንና ፉእቴራ ካይምማ ዲፌን ዳንፋ። ");
INSERT INTO jnje_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ኤስታን ደይ ሀማ ባርስታን ደናሎ ማጙ ናፉን ኪና አያና ኤጳ ያራ ግርራ ባርኔን አነ ኤስታ ፋፋ። ኤስ አሱሲክ ዜሞቲ ፎባስታን ኦርፎቲ ፎባስ አካማኖን ማጙ ስንፋ። ኤሲስማቶ ሀን ማጙ ኮንቶስታ ስንኒስ ኤሲስንነ ፋርዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","የሱስ ዳራሲክ ማኬፌን እንቶባሴዋ አይባሳክቶና ባርኔን ኡጰሬ ዎሎክ ሾልሴፋት ጌራካሎ የርሴፌር። ");
INSERT INTO jnje_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ኤስታ ፌሴ አሱኒ ሜያስን እሳይስ የሱስኒን፦ «እንቶኔሴዋ አይኔሳክቶና ኔን ኡጵሶነክ ሾሌፋት ጌሮ የርሴፌርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","የሱስ ደይ ኤስ ማኬ አሱሲክ ዎልግሬ፦ «እንቶናስ ኦንሶ? አይታሳክቶ ደይ ኦኖትናይስንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ኩሹባሶን ናዎባሳክቶኒክ ቤሳት፦ «ኤሴ እንቶናሴዋ አይታሳክቶና ሀኒስዋ፦ ");
INSERT INTO jnje_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ደን ሳማኪ አባታሳ ሳፋራኖን ዛግሴፌ ባሶ ዙቴሬ አይታ፥ ኤትና ደይ እንቶናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","የሱስ ኤስ ዎኖ ኬሩን ኬሴ ባርሲ ቴሻ ድ። ");
INSERT INTO jnje_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ሾዎ ዳራ ባሳ ቴሻ ዙቴና ቦርአ ባር ጎኑስታ ኬሴ ድ። ዳራስ ደይ ዙቴሬ ባርሲ ቴሻ የርሴፌር። ");
INSERT INTO jnje_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ኤስታን ሾዎ ዉዛ ቤሶክ ባሶክ ማኮ ኤጲ፦ «እሳ ቡልኛ ዛላ ቡካናክ ኬሲ። ");
INSERT INTO jnje_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ቡክፌና ካባሲክ እሳ እሳ ዛላስ ኡግናስታ ኬሬ ዎርእ። ካሳሲክቶ ደይ ያራ ኬፕጳ ማ። ");
INSERT INTO jnje_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ኦማስ አካማ ሆእባ ፎንቶ ካኦስታ ኬሬ ዎርእ። አካማ ሆአ ኣፋ ስንና ቦርአ ጌሬጌሬ ካይ። ኤሲስ ደይ ዛላስ ሆኣሲ ስካሌራ ኣነ ግሩዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ስኑንታኖ አዋ ኬስፋና ካባሲክ አልቂ። ታስባ ትሽና ቦርአ ደይ እችሚ። ");
INSERT INTO jnje_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ኦማ ዛላስ ደይ ሴርኣሲ ጋነሲ ኬሬ ዎርእ። ሴርኣስ ካይራ ጌርአ ፉኤ። ");
INSERT INTO jnje_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ኦማ ዛላስ ማአ ዳስታክ ኬሬ ዎርእ። እሳይስ ትያኖን፥ እሳይስ እሱንናስሮን፥ እሳይስ ኬዛስሮን ጋኒ። ");
INSERT INTO jnje_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ኦዶኒ ኦዶባ ፌና ባር ኦዶዎዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ኤስታን ናዎባሳክቶ ባርኪ ታእሴሬ፦ «አዉኒ ቦርአ ዳራሲክ ቤሶክ ማኬፋስሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ባር ደይ ዎልግሬ፦ «ንቶክ ደን ሳማኪ ሀኦሲ ኣቾ ቾዋኖን አሩትክ እምቴዋ። ስኑንታኖ ባሶክ ኣነ እምቶዋዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ፌና ባሪክ ፋይስታ ዳይስቴራ እምቶና ደይ አርኩና። ስኑንታኖ ጋሮ ኪስኩ ፌና ባርኪን ኤስ ባርኪ ፋ ባርኑ ባሳስታን ኦቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ባሶ ብየፌት ብዮኖርኔ ፌሴቴር። ኦደፌት ኦዶኖርኔ ፌሴቴር ደይ ያዳቶኖርኔ ፌሴቴር ስንነቴ ቦርአቱ ቤሶክ ማኬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ኤስ ባሪ ቦርኣ ራጁ እሳያስኒስ፦ « ‹ኦዶሶን ኦደትር፤ ስኑንታኖ ኣነ ያዳቴፌት፤ ብያሶን ቢትር ስኑንታኖ ንብንትስ ኣነ ያዳቴፈቲ። ");
INSERT INTO jnje_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ሀን ዳራሳ ንባ ሙሚዋ፥ ኦዶቤሲስ ደይ ኦየዋ፤ ኣፍቤሲስ ደይ ታልሜዋ፤ ኤካ ስና ሻካናነ ኣፍቤሲሲክ ቢሬ፤ ኦዶቤሲሲክ ኦደሴሬ፤ ንብቤ ሲሲ ያዳቴሬ ታኪ ዎልሴቴን ፋቱና ካባዋ።› «ይስቴራ ማክቴራ ኩኒ ራጂስ ባሶስታ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ስኑንታኖ ንቶ ኣፋስ ብያር፤ ኦዶንትስ ደይ ኦደር ስንና ቦርአ ንቶ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ፉቶክ ንቶክ ማኬፋውጙዋ፤ ሾዎ ራጁኒ ሜናዋ ኦኮኒ ሜና ንቶ ብየፌት ባሮን ብዮነክ ኤናንቴሴሬ ኣነ ብዮቶ። ኦደፌት ባሮን ኤናንቴሴሬ ኣነ ኦዶሶቶ። ");
INSERT INTO jnje_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«ኤሴ ንቶ ዛላሲ ቡክኛኒ ቤሶሲ ኮታኖን ኦዶትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ኡግናስታ ቡክቴ ዛላስ ቤስፋናስ ሀኦሲ ታቶኒ ካማኖን ኦዴሬ ያዳቶኖይ አሱስጝዋ። ደይ ጌሬጌሬ ሴጣና ያራ ንባስን ቡክቴ ካማሶን ኬጵፋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ካኦስታ ቡክቴ ዛላስ ቤስፋናስ ካምባሶን ኦዴሬ ጌሬጌሬ ግራክ ኤጴቴሴፌ አሱስጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ስኑንታኖ ታስባ ኣፋ ስንና ቦርአ ሀኦሲ ካምታን ካብ ቾዋ ሻና ወደይ ካቡግቶ ካርፋና ካባሲክ ጌሬጌሬ ቱሳእሴፌ። ");
INSERT INTO jnje_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ሴርኣሲ ጋነሲ ቡክቴ ዛላስ ቤስፋናስ ካምባሶን ኦዴሬ ኤጴቴሴፌ አሱስዋ። ስኑንታኖ ሀን ዳስታኪ ፎኒ ሳፋራሴዋ ኦቱምኒ ኬሽታናሴ ካምባሶን ጌርአ ጋንባ ፎንቶ ዛግፋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ማአ ዳስታክ ቡክቴ ዛላስ ቤስፋናስ ካምባሶን ኦዴሬ ያዳቴሴፌ አሱስጝዋ። ባር ጋና ጋናር። እሳይስ ትያኖን፥ እሳይስ እሱናስሮን እሳይስ ኬዛስሮን ጋንፋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ደይ የሱስ ኦማ ቤሶ ኤካ ይት ማኬ፦ «ሳማኪ ታቶስ ፎሻስታ ማአ ዛላ ቡካ አሱነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ስኑንታኖ አሱ ዙቴሬ ኩናኔን ኦርፎ ጉማ ዬሬ ዛጎሲ ቃጣቃጣ ቡካት ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ዛጎስ ካይራ ጋንፋና ካባሲክ ቃጣቃጣስ ደይ አነ ኬሳ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ፎሻሲ አባን ዎስትኛኒ ሜያ ባርኪ ሀሜሬ፦ ‹ዳሚሶ፤ ፎሽኔስታ ማአ ዛላታኖሶ ቡክታሪ? ኤኪን ቃጣቃጣ አይን ያስሶ?› ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«ባር ደይ ባሶክ ዎልግሬ፦ ‹ሀን ባሮን ዛግስ ጉማስዋ› ይ። ዎስትኛባሳክቶ ደይ፦ ‹ኤኪን ሀማ ኤስ ቃጣቃጣሶን ዋርአኒክ ሾሌፋቶሶ?› ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«ስኑንታኖ ባር ዎልግሬ፦ ‹ቃጣቃጣሶን ዋርእፌት ካባሲክ ዛጎሶን ደይ ዋርአትር ስንና ቦርአ ኣፋዋ ስናናዉዛ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ቤይፋኒ ካቶና ዎናስ ካርአናኔን አነ ድችፎንዋ። ካርኒ ዎኖ ካርኒ ባሶ፦ ‹ቃጣቃጣሶን ዜምሜ ዋርአት፤ ጌያክ ኪቾናማቶ ባሳ ባሳሲክ ባሳት። ስኑንታኖ ዛጎሶን ቦቶናሲ ጋግትዋ› ኡና» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ደይ የሱስ ኦማ ቤሶ ኤካ ይት ማኬ፦ «ሳማኪ ታቶስ አሱ ኤጴ ታምሜ ቡሎሲ ቡክና ፊእፊኦኒ ጋናነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ባር ዛላ ዙታምባሴ አሲስታን ሀቴር። ስኑንታኖ ድችፋና ካባሲክ አካክልቲ ዙታምባሴ አሲስታን አሪክራ ደይ እኦ ስኒፋ። ካሳሲክቶ ደይ ያራ ዋእባስ ኬባ ኬርአ ዲፋ።» ");
INSERT INTO jnje_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ደይ የሱስ ኦማ ቤሶ ኤካ ይት ማኬ፦ «ሳማኪ ታቶስ እሳ ማሽካሱ ኬዝ ሳፋሬ ቡዋኔን ቱሽና ማሶነ ፋርዋ። ኤስ ማሶስ ደይ ቱሾስ ኬሳናክ ዛግ።» ");
INSERT INTO jnje_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","የሱስ ኤስ ባሮን ዙትሬ ቤሶክ ዳራሲክ ማኬ። ቤሶ ፎንቶኖን እሳ ዉዛነ ኣነ ማኮየ። ");
INSERT INTO jnje_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ኤስ ባርኑ ኤካ ስንናስ ራጁኒኪ ካሞ፦ «ዎሉምናሶን ቤሶክቱ ማኮና። ሀን ዳ ቴስቴናኔን ካብራ ኣቼራ ፋ ዉዛሶን ማኮና» ይስቴራ ትቼ ባር ስናናክዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ኤስታን የሱስ ዳራስን ጌጌሳት ኬር ግሪ። ናዎባሳክቶ ደይ ባርኪ ታእሴሴሬ፦ «ቡሎስታኪ ቃጣቃጣሲ ቤሶኒ ኮታኖን እኖክ ማኮዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","የሱስ ደይ ኤካ ይት ዎልጊ፦ «ማአ ዛላሶን ቡካስ አሱኒ ናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ቡሎስ ሀን ዳስዋ። ማአ ዛላስ ሀኦሲ ታቶኒ ናንጎታዋ። ቃጣቃጣስ ደይ ሴጣንኒ ናንጎታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ቃጣቃጣሶን ቡካስ ጉማ ስና ዳቡሎስዋ። ካርእኒ ዎናስ ደይ ሀን ዳስ ኮአዋ። ካርእኒስ ደይ ሀኦሲ ዎስያኒክቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ኤስ ቃጣቃጣስ ኬጵቴራ ኪቼፋናስማቶ ሀን ዳሲ ኮአክ ደይ ኤሲስማቶቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ኤስ ካባሲክ አሱኒ ና ዎስባሲክቶኖን ዎሱና። ባርኪቶ ደይ ኦሚስን ቦርአ ዎስቶሶነክ ዛግሴፌ ማጙ ሜያኖን ዙትራ ባሳ ታቶስን ኬጳ ክስሶና። ");
INSERT INTO jnje_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ደይ ካዮ ጌያሲ ሀእሶና። ኤስታክ ዋስነዋ አይእኒ ኮየት ፎነ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ስኑንታኖ ኦኮኒ ሜያ አባቤሲሳ ታቶሲ አዋኒማቶ ቻሮሶነ። ኦዶኒ ኦዶባ ፌና ባር ኦዶዎዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ሳማኪ ታቶስ ቡሎስ ኣቸራ ኩን ኦትማነ ፋርዋ። እሳ አሱ ኤስ ኦትማሶን ዳንነ ኣቺ። አካማኖን ግሮባስታን ካብ ቾዋ ሀሜ ፋ ፎባሶን ዙትሬ ክስሬ ዋጋት ኤስ ቡሎሶን ዋጌ።» ");
INSERT INTO jnje_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ሄፕሳ የሱስ ኤካ ይ፦ «ደይ ሳማኪ ታቶስ ኬሹ እንቁ ዋጎክ ሾሌ ናጋደነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ኤስ ናጋዴስ አካማኖን ሾልሱ እንቁሶን ዳኝናይሴ ሀሜ ፋ ዉዝባሶን ዙትሬ ክስሬ ዋጋት ኤስ ባሮን ዋጌ።» ");
INSERT INTO jnje_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ቱስሬ ደይ የሱስ፦ «ኤሲስማቶ ደይ ሳማኪ ታቶስ ባሪሲ ሀእቴፋት ሾዎ ቴሳ ኩርጡሚሶን ዙት ዩጉዶነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ዩጉዶስ ቱምናኔን ኦርፎ ኩርጡሚሶን ኤሸፌ ባሶ ዛትቴ ባርሲ ሀእታ ክስሴፌ። ኤስታን ዲሴሬ ማአ ማኣሶን ኮርሴሬ ማሳሲ ጌደሴፌ። ማጙ ማንጉሶን ደይ ጌሮ ሀእሴፌ። ");
INSERT INTO jnje_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ኤሲስማቶ ሀን ዳሲ ኮአክ ኤካቱ ስናናዋ። ሀኦሲ ዎስያኒክቶ ያራ ቦርእኒ ሜያኖን ኦኮኒ ሜያስን ኮሩና። ");
INSERT INTO jnje_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ማጙኒ ሜያኖን ደይ ካዮ ጌያሲ ሀእሶነ። ኤስታክ ዋስነዋ አይእኒ ኮየት ፎነ ስናና።» ");
INSERT INTO jnje_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ደይ የሱስ፦ «ሀን ባሮን ዙትራ ያዳቴትዮሶ?» ይ። ባሶ ደይ፦ «ኣ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","የሱስ ደይ፦ «ኤሴ ሳማኪ ታቶሲ ኣቾ ቾዋኖን ማእስሬ አሪፌ ቱማሲ አስሲኛስ፤ ኮዳ ኩንፋና ኬያስን ጋድዶ ስናይሴዋ ኩርኡ ስናይሴ ኤጴ ክስፌ ዋግኒ አባነ ፌርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","የሱስ ኤስ ቤሶሲክቶኖን ማኬሬ ኮእስናሴ ኤስታን ኬሴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ኮንቴና ካታማ ናዝሬት ዬሬ አይሁድኒ ሺጶኒ ኬያሲ ዳራስን አሲት ፌር። አሱኒ ሜያ ደይ ዲንቀሴሬ፦ «ሀን አሱስ ሀን ቴችማሴዋ ቢስቴራ አሪቶኖይ ዉዛሴ አስን አይን ኤጴ ዬሶ? ");
INSERT INTO jnje_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ሀን ባር ካርእኛ ዮሴፍኒ ናስቴኖሶ? እንቶባስ ደይ ማራሚታኖሶ? አይባሳክቶ ደይ ያቆብ፥ ዮሴፍ፥ ስሞንናዋ ዩዳናቴኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ኤትባሲክቶ ደይ እኖኔን አነታኖሶ ፋሴናሪ? ኤኪን ሀን አሱስ ኤፋቴና አሩሶን ዙትሬ አይን ዳኒሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ኤስ ባሪ ቦርኣ ባሳ ቾዋሲክ ቱሳእሴሬ ኤጴቶ ቤየቴ። ስኑንታኖ የሱስ፦ «ራጁ ኡልፍና ዳና ቤይፌናስ ኮንቴና ዳስታክናዋ ኬባሲና ኮእባዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ባሶ አማኖ ቤያስታን ካብ ቾዋ ኤስታክ ሾዎ ቢስቴራ አሪቶኖይ ዉዛ ኣነ ዛጉዬ። ");
INSERT INTO jnje_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ኤስ ካባሲክ ጋሊላክ ዳሶን ሀእስፌ ሄሮድስ የሱስኒ ቾዋሲ ዎላኖን ኦደ። ");
INSERT INTO jnje_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ዎስትኛባሳክቶኒክ፦ «ሀኒስ ሀጵቅፌ ዮሀኒስዋ። ባር ኪቱን ካብዋ። ኤስ ባሪ ቦርኣቱ ሀን ቢስቴራ አሪቶኖይ ዉዛስ ባርኪ ካሞ ዛግቴድፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ሄሮድስ አይባ ፍልጶስኒ አሱ ስና ሄሮድያዳኒ ቦርአ ዮሀኒስኒን ኦትሬ ታቶኒ ኬር ታትሬ ፌር። ");
INSERT INTO jnje_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ዮሀኒስ ሄሮድስኒክ፦ «አይኔሳ አሱኖን ኤጳታክ ቱማሲ ካልቶዋ» ይሬ ማኬና ቦርአ። ");
INSERT INTO jnje_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ሄሮድስ ዮሀኒስኒን ዎሩክ ሾሌት ፌር። ስኑንታኖ ዳራስ ዮሀኒስኒን ራጁ ዛግሬቱ ብየፌ ስንና ቦርአ ድጌ። ");
INSERT INTO jnje_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ሄሮድስ ኮንቴና ዎናሶን ኡልፍንስፌና ዎኖ ሄሮድያዳኒ ናዋስ ቴግቴሬ ዬሴ ባሶ ጋነያሲ ሱሩ ሱርራ ሄሮድስኒን ግርሲ። ");
INSERT INTO jnje_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ኤስ ባሪ ቦርኣ ሄሮድስ ባር ሺጴና ዉዛሶን ዙትሬ እማናክ ቴይሬ ዋሬጌ። ");
INSERT INTO jnje_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ናዋስ ደይ እንቶባሲክ ክቴራ፦ «ሀጵቅፌ ዮሀኒስኒ ቴታሶን ሀን ኮራናስ ጌዳ ሀሽ ታክ እማ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ታቶስ ኤስ ቾዋሲክ ሱሜ። ስኑንታኖ ግርና ቴያሲክ ባርኔን አነ ዲሴ ባሶ ቦርአ ኢቼሬ ዮሀኒስኒ ቴታስ ካቴራ እምቶናክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ታቶኒ ኬር ዎስሬ ዮሀኒስኒ ካት። ");
INSERT INTO jnje_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ኤስ ካቴ ቴታሶን ኮራናስ ጌደ ቴሸሬ ናዋሲክ እሜቴ። ባር ደይ ታማ እንቶባሲክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ዮሀኒስኒ ናዎሳክቶ ዬሴሬ ዱግኖባሶን ኤጴ ካባርሴቴ። ሀሜሬ ደይ ኤስ ቾዋሶን የሱስኒክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","የሱስ ዮሀኒስኒ ክቱሶን ኦድናይሴ ጎኑስ ዲሬ ባር ባር ዱክ እሳ ሻቶ ድምሲ ሀሚ። ዳራስ ደይ ኤስ ባሮን ኦደሴቴይሴ ካታማ ካታማባስን ኬሴ ዎቾክ ባርኪ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","የሱስ ጎኑስን ኬሬሬ ሾዎ ዳራኒን ብያት ባሶክ ኬናሽቴ። ሜታኒ ሜያኖን ደይ ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ዋልፋና ካባሲክ ናዎባሳክቶ ባርኪ ታእሴሬ «ሀን ባር ዛቦዋ፥ ጌሮክ ደይ ዋልዋ። ዳራስ ሀምሜ ኬኤሲክቶስን ሙቤሲ ዋግሶነክ ጌጌሱዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ስኑንታኖ የሱስ፦ «ንቶ ባሶ ሙሶኔሶን እሞትታኖ ሀሞነክ ኣነ ሾልስፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ባሶ ደይ፦ «እኖክ ፋዪስ ኡች ሙማ ዳቦነዋ ሄፕ ኩርጡሚነታኖ ኦማ ሀንታክ ኣፋዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ባር ደይ፦ «ኤስ ባሮን ሀጝ ታክ ቴሾትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ዳራስን ሻኣስታ ዱሶነክ አጃጀ። ኤስታን ኡች ሙማ ዳቦሶንናዋ ሄፕ ኩርጡሚሶንና ኤጴ ደን ሳማ ቢሬ ጋላትኒ ሺጶ ሺጴ። ዳቦሶን ደይ ባቴ ናዎባሳክቶኒክ እምን ባሶ ደይ ዳራሲክ ዎሸቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ዙታምቤሲሴ ሜሬ ጋዉሴቴን ናዎባሳክቶ ደይ ፉእቴ ባቶሶን አሲሬ ሄፔ ማሳ ቱማኖን ዙትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ሜሴ አሱኒ ሜያ ማሽካሱሴዋ ናንጎታሴ ፋድቶኖይፌን ኡች ኩም ኣርቃሱ ስኖነ። ");
INSERT INTO jnje_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ኤስታን የሱስ ጌሬጌሬ ናዎባሳክቶኒን፦ «ዳራስን ጌጌሱና ካባኔን ጎኑስ ዲሴራ ዜምማ የሳሎ ፍንትዋ» ይት አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ዳራስን ጌጌስናይሴ ሀኦ ሺጶናክ ባር ባር ደን ኣማስታ ኬሲ። ዋልፋና ካባሲክ የሱስ ባር ባርቱ ኤስታክ ፌር። ");
INSERT INTO jnje_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ኤስ ካባሲክ ጎኑስ ባርሲ ጋነታ ፌን ኤክ ስናስታክ ስሩ ፋር ስንና ቦርአ አካሲ ጉቦ ሽምሲ። ");
INSERT INTO jnje_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ዋሲ እዝግን ሳአትስታክ የሱስ ባሪስታ ኩቲት ናዎባሳክቶኒክ የ። ");
INSERT INTO jnje_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ናዎባሳክቶ ደይ አካስታ ኩቲት ሀሚፌን ብየፋት፦ «ሀን ባር ክታዋ» ይሬ ድጋክ ቻጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","የሱስ ደይ ጌሬጌሬ፦ «ሀሬዋ! ድጎትታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ኤስ ካባሲክ ጴጥሮስ ዎልግሬ፦ «ዳሚሶ! ነ ስኒፋታነ አካስታ ኩቲት ኔኪ ዮናክ ታን አጃጆዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","የሱስ ደይ፦ «ዮዋ» ይ። ኤስታን ጴጥሮስ ጎኑስን ኬሬሬ የሱስኒኪ ሀማናክ አካስታ ኩት። ");
INSERT INTO jnje_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ስኑንታኖ ስሩስ ሁግናኖን ቢሬ ድጌ። ባሪስ ባሪን ኮርእአናክ ሀሚባሴ፦ «ዳምታሶ! ታን ፉአይዋ» ይት ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","የሱስ ጌሬጌሬ ሾሬ ኩሹባሶን ዛቴ፦ «አማንቶነ ዮእና ነ፥ አዉኒ ቦርአ ንብኔስ ኤክ ሀጝ ይትሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","የሱስናዋ ጴጥሮስና ጎኑሲ ግርሴፌ ካባሲክ ስሩስ የሬ። ");
INSERT INTO jnje_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ጎኑሲ ዲሴ ባሶ ደይ ዙቴሬ፦ «ፉቶክ ነ ሀኦኒ ናዋ» ይት የሱስኒክ ሳጋደሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","የሱስናዋ ናዎባሳክቶና ባሪሶን ፍነሬ ጌንሳሬጥ ስንፋ ዳስታክ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ኤስታክ አሱኒ ሜያ የሱስ ስንባሶን አሪሴቴይሴ ብራቶስታ ፋ ዳ ዙታምባሴ አሲስ ዎሴቴን ሜታኒ ሜያኖን ዙትሬ ባርኪ ቴሸሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ሜታኒ ሜያ ማይባሲ ፋሻኖን ታኡክ ሺጵሴት ፌሴቴር። ታእ ባሶ ደይ ዙቴሬ ሜሮቤሲስን ፋርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ኤሴን ኦርፎ የሩሳለሙን ዬሴ ሙሴኒ ቱማሲ አስሲኛናዋ ፌርሳዊኒ ሜና የሱስኒኪ ታእሴሴሬ፦ ");
INSERT INTO jnje_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«ነ ናዎሳክቶ አዉኒ ቦርአ ኩርኡኒ ሜኒ ዱቢዮሶን አቴፌሶ? ሙ ሜሴፌ ካባሲክ ኩሹቤሲሶን ኣነ ማሴሴፌዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","የሱስ ዎልግሬ፦ «ንቶ ዱቢዮሶን ኦዳክዋ እያት አዉኒ ቦርአ ሀኦሲ አጃጅኖን ኣትፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ሀኦስ፦ ‹አባነስንናዋ እንቶኔሶንና ኡልፍንሱዋ። አባባስን ወደይ እንቶባሶን ሜአ ባር ክቱናክ ሾልስፋዋ› ይፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ስኑንታኖ ንቶ እሳ አሱ አባባስን ወደይ እንቶባሶን፦ ‹ታ ንቶክ እማና አሪጋሱሶን ሀኦሲክ ማባ ዛግራ እምጝዋ› እያናነ፤ ");
INSERT INTO jnje_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","‹ኤስ አሱስ አባባስን ወደይ እንቶባሶን ኡልፍንሱናክ ኣነ ሾልስፋዋ› ይፌት። ኤስ ባሪ ቦርኣ ንቶ ዱቢዮሶን ኦዳክዋ እያት ሀኦሲ ካማኖን ኣትፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ስንኖይ ስንነ ቤስቴፌ ንቶ ራጁ ኢሳያስ ኤካ ይሬ ንቶ ቾዋሲክ ማኬና ራጂስ ፉቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","« ‹ሀን ዳራስ ኖኖ ኖኖባሲክቱ ታን ኡልፍንስፌዋ፥ ስኑንታኖ ንብባሲ ታይስታን ዎካዋ። ");
INSERT INTO jnje_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","አሱ ቱሜና ቱማሶን ሀኦኒ ቱማ ዛግሬ አሲሴፋፌ ሽማ ሺጶ ሺጴሴፌዋ› » ይ። ");
INSERT INTO jnje_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ቱስሬ ደይ የሱስ ዳራስን ሀጝ ባርኪ ቴጌሬ፦ «ኦዶትዋ! ደይ ያዳቶትዋ! ");
INSERT INTO jnje_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","አሱኒን ኪንስፋስ ኖኖስን ኬስፋ ባርታኖ ኖኖሲ ግሪፋ ባርታዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ኤስታን ናዎኒ ሜያ ባርኪ ዬሴሬ፦ «ፌርሳዊኒ ሜያ ሀን ነ ማኬታ ካማሶን ኦደሴሬ ንቤሲሲ ኬጅፋን ቱሳእሴቴማቶ አሪቶሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","የሱስ ዎልግሬ፦ «ሳማኪ አባታስ ቶክኖይና አታክልትስ ዙቴራ ዋቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ባሶ ኣፍትሹ ደይ ኣፍትሹኒ ሜያኖን ዞንስር ስንነቴ ቦርአ ቤይትዋ። ኣፍትሹ ኣፍትሹስን ዞንሲፋናነ ሄፐሬ ጋዉሲቱ ጋንዶሶነዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ጴጥሮስ ደይ የሱስኒን፦ «ቤሶሶን ኮታ እኖክ ማኮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","የሱስ ዎልግሬ፦ «ንቶ ደይ ሀሽኔን ካርአ ኣነ ያዳቶዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ኖኖሲ ግሪፋ ባር ዙቴራ ካታሲ ካሞ ኣታ ጌሮ ኬስፋናማቶ ኣነ አሩዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ስኑንታኖ አሱኒ ኖኖስን ኬስፋ ባር ንብስንቱ ኬስፋዋ። አሱኒን ደይ ኪንስፋስ ኤስ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ማጙኖን ሳፋሮ፥ አሱኒን ዎሩ፥ ሶሎ፥ ጌርኬሳ፥ ዊሶ፥ ኤሻ ዛልኒ ማኮ፥ አሱኒ ሱኒ ማጝሱ ዙቴራ አሱኒ ንብስኒቱ ኬስፋዋ ");
INSERT INTO jnje_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","አሱኒን ኪንስፋስ ደይ ኤስ ባርታኖ ኩሹ ማሶኖይ ሙስታዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","የሱስ ኤስታን ኬሴ ትሮስኒ ካታማሲናዋ ሲዶናኒ ካታማስና ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ኤስታክ እሳ ኬነአኪ ማሽካሱ የሱስኒኪ ያራ፦ «ዳዊትኒ ና ዳሚሶ! ናናስ ኪና አያናክ ኦቴራ አካማኖን ሜቴድፋር ስንና ቦርአ ታክ ኬናሽቴፋይዋ» ይት ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ስኑንታኖ የሱስ እሳ ዉዛነ ዎልጉኖይ ሻክ። ኤስ ካባሲክ ናዎባሳክቶ ባርኪ ታእሴሬ፦ «ሀን አሱስ እንኖ ኦርፎሴ ያፋፋ ቻጌት ፋር ስንና ቦርአ ጌጌሲፋይዋ» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","የሱስ ዎልግሬ፦ «ታ ዎስቴራ ያናስ ፋንቱኒማቶ ትሽሬ ፌ እስራኤልኒ ሜያክታኖ ኦምኒ ሜያክ ኣነ ዮትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ስኑንታኖ አሱስ ያራ ዎቾባሲ ካእነራ፦ «ዳሚሶ! ታን አሪጋሳይዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ስኑንታኖ የሱስ ባሪክ ዎልግሬ፦ «ናንጎታሲ ዳቦኖን ኤጴ ካናሲክ ሀእኡ ኣነ ሾልስፋዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ባር ደይ ዎልግራ፦ «ፉቶዋ፥ ዳሚሶ! ካናሲክቶኑ ዳምባይሳክቶኒ ስላዎታን ዝግቴፋ ፉፉንቶሶንቱ ማሴፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ኤስ ካባሲክ የሱስ ዎልግሬ፦ «ሀን አሱሴ! አማንቶኔስ አካማዌ። ሾሌታ ባር ኔክ ስኑግዌ» ይ። ናዉባስ ደይ ኤስ ሳአትስታክ ፋሪ። ");
INSERT INTO jnje_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","የሱስ ኤስታን ካብሬ ጋሊላኪ ባሪሲ ቴሻ ዬሬ ደን ኣማስታ ኬሴ ሀምሜ ድ። ");
INSERT INTO jnje_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ሾዎ አሱኒ ሜያ ላፋሳክቶኒን ኣፍትሹሳክቶኒን ኤጝትስን፥ ንብታቶሳክቶኒንናዋ ኦም ሾዎ ሜታኒ ሜያኖንና ኤጴቴሸሬ ባሳ ዎቾሲ ኩኑሴቴን ባር ደይ ባሶትን ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ኤስ ባሪ ቦርኣ ዳራስ ንብታቶስ ዎል ሌፌን፥ ላፋስ ፋርፌን፥ ኤጝትስ ካንነ ኩትፌን፥ ኣፍትሹስ ቢፌን ቢየሴሬ ዲንቆክ እስራኤልኒ ሀኦሶን ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","የሱስ ናዎባሳክቶኒን ቴጌሬ፦ «ዳራስ ታኔን አነ ኬዝ ዎና ፌሸቴ ስንና ቦርአ ሙሶነ ዉዛ ኣፋ ስንና ቦርአ ባሶክ ኬናሽቴፋዉጝዋ፤ ኡጉንታክ ማካክ ምክሸሬ ጋንዶሶኖይቴማቶ አፉርቤሲሴ ጋፍኩክ ኣነ ሾሌፋትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ናዎባሳክቶ ደይ፦ «ኤኪን ሀን ኤፋቴና ዳራስን ጋኡሱኒ ቱሻ ሀን እችማ ዳስ ሲክ አይን ዳንናሪንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","የሱስ፦ «አፑን ዳቦንሶ ንቶኪክ ፋሪ?» ይ። ባሶ ደይ፦ «ናፉን ሙማ ዳቦነዋ ጋሮ ጋሮ ኪስኩ ኩርጡሚነቱ እኖኪክ ፋርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ኤሴን ኦርፎ ዳራስ ዳስታክ ዱሶነክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ናፉን ሙማ ዳቦሴዋ ጋሮ ጋሮ ኪስኩ ኩርጡሚሴ አሲን ኤጴ ሀኦ ጋላቴፋት ባትቴ ናዎባሳክቶኒክ እሚ። ባሶ ደይ ዳራሲክ ዎሸቴ። ");
INSERT INTO jnje_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ዙታምቤሲሴ ሜሴሬ ጋዉሴቴን ፉእቴ ባቶሶን ናፉን ማሳ ዙትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ሜሴ ባሶ ማሽካሱሴዋ ናንጎታሴ ፋድቶኖይናሮን አቼች ኩም ኣርቃሱ ስኖነ። ");
INSERT INTO jnje_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ዳራስን ጌጌሲናኔን ኦርፎ ጎኑስ ዲሬ ሜግዶን ይስቴ ዲማ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ፌርሳዊኒ ሜናዋ ሴዱቃዊኒ ሜና የሱስኒኪ ዬሴሬ ባሪን ፋታኖክ ሾልሴፋት፦ «ደን ሳማን ቢስቴራ አሪቶኖይ ዉዛ እኖክ ቤሱዋ» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ስኑንታኖ የሱስ ዎልግሬ፦ «ዋልን ሳማስ ሸእን ቢፌት ካባሲክ፦ ‹ኖእሱኒርዋ› ይፌት። ");
INSERT INTO jnje_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ኤእሶ ደይ፦ ‹ሳማስ ጉማል ላ ካራየን ቢየፌት ካባሲክ ሀውጙ አካማ እሮ እችንርዋ› ይፌት። ኤሴ ሳማሲ ግቶኖን አሩክ ችምትር። ስኑንታኖ ነያሲ ቤሶኖን አሩክ ኣነ ችሜፌት? ");
INSERT INTO jnje_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ማጙነዋ አማናምቶኖይ ኮንቶስ ቤሶቱ ሾሌፋዋ? ስኑንታኖ ራጁ ዮናስኒ ቤሶስታን ኦማ ቤሶ ኣፋ እምቶና ዉዛ።» ኤስታን የሱስ ባሶትን ቤየ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ናዎኒ ሜያ ባሪሶን ፍነፌ ካባሲክ ዳቦኒ ኤጳ ዳግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","የሱስ ባሶትን፦ «ኤሴ አሩትዋ፥ ፌርሳዊኒ ሜናዋ ሳዱቃዊኒ ሜና አሲ ማሶስን ቴትንትሶን ኦድትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ባሶ ደይ፦ «ዳቦ ኤጳ ዳጌኒ ቦርአቶጝዋ» ይሴት ባሶትና ባሶትና ዎሉምሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","የሱስ ባሶ ሳፋራሶን አሪፋት፦ «አማንቶኒት ዮእና ንቶ አዉኒ ቦርአ ንቶትና ንቶትና ‹ዳቦ ኤጳ ቤይኒ ቦርአቶጝዋ› ይት ዎሉምሴፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ሀሽኑ ኣነ ያዳቶዌትኖሶ? ኡች ሙማ ዳቦሶን ኡች ኩም አሱሲክ ሆሬን ፉእቴ ባቶሶን አፑን ማሳ ዙትሴትማቶ ኣነ ያዳቶዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ኤሲስማቶ ደይ ናፉን ሙማ ዳቦሶን አቼች ኩም አሱሲክ ሆሬን አፑን ማሳ ዙትሴትማቶ ኣነ ያዳቶዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ኤኪን ታ ማኬናስ ዳቦኒ ቾዋ ስና ቤይባሶን ኣካክ ያዳቶ ቤይትሶ? ሀሽኑ ፌርሳዊኒ ሜናዋ ሴዱካውኒ ሜና አሲ ማሶስን ቴትንትሶን ኦድትዋ?» ");
INSERT INTO jnje_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ኤስታን ናዎባሳክቶ ደይ የሱስ ቴትንትሶን ኦድትዋ ይናስ ዳቦሲ ግሪፋ ማሶስ ስኖይናሮን ፌርሳዊኒ ሜናዋ ሴዱካውኒ ሜና አሲ አሱስን ቴትቤሲሶን ኦዶሶነክ ስንባሶን ያዳቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","የሱስ ፍልጶስ ቄሳሪያ ይስቴፋ ዳ ካርእናይሴ ናዎባሳክቶኒን፦ «አሱኒ ሜያ አሱኒ ናኒን ኦዋ ይሴፌሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ባሶ ደይ፦ «እሳ እሳይስ ‹ሀጵቅፌ ዮሀኒስዋ› ይሴፌ። ኦሚስ ደይ ‹ኤልያስዋ› ይሴፌ። ኦሚስ ‹ኤርምያስዋ ወደይ ራጁኒ ሜያስን እሳይስዋ› ኡሶቱ ይሴድፌዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","የሱስ ደይ፦ «ኤኪን ንቶ ታን ኦዋ ይሴፌትሶ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ስሞን ጴጥሮስ ዎልግሬ፦ «ነ ሀዬዋ ሀኦሲ ና ክርስቶስዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","የሱስ ዎልግሬ፦ «ዮናኒ ና ስሞንኖ! ነ ሱስቶዋ። ሀን ባሮን ኔክ አምማኖን ቤሲስ ሳማክ ፌ አባታስቴኖ አሽነዋ ሀርንነታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ታ ደይ ኔክ ኤካ ይፋዉጝዋ፥ ነ ጴጥሮስዋ ሀን ካእኦስታ ቤቴክርስታንናሶን ኬርአናርዋ። ኤስ ቤቴክርስታኒሶን ክቱኒ ሁግናስ ሜሮናክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ሳማኪ ታቶሲ ጋቾሲክቶኖን ኔክ እማናዋ። ነ ሀን ዳስታኪ ታርእታ ባር ደን ሳማክ ታቶቱ ስናና። ሀን ዳስታኪ ኮትታ ባር ደን ሳማክ ኮቶቱ ስናና።» ");
INSERT INTO jnje_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ኤስታን የሱስ ናዎባሳክቶኒክ ባር ክርስቶስ ስኒባሶን ኦንክኑ ማክሶኖይቴማቶ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ኤስ ዎኖኔን ካብሬ የሱስ ናዎባሳክቶኒክ፦ «የሩሳሌም ሀማናክ ሾልስፋዋ። ኤስታክ ደይ ኩርኡኒ ሜያኪን፥ ማግኒ ጋኛንኪን፥ ሙሴኒ ቱማሲ አስሲኛኒኪን ሻና ታይስታ ካርአና። ደይ ዎርሶነር። ስኑንታኖ ኬዝስናሪ ዎኖ ክቱኒ ካቡና» ኡ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ጴጥሮስ ደይ የሱስኒን ኦር ክስሬ፦ «ዳሚሶ! ሀን ባር እሳንነ ነይስታ ኣፋዋ ካርአናዉዛ» ይት ኬኡ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ስኑንታኖ የሱስ ጴጥሮስኒኪ የርቀሬ፦ «ታይስታን ኤክ ሀማ! ነ ሴጣና! አሱኒሶንታኖ ሀኦሲ ፍቃድኖን ኣነ ሳፋሬፌ ስንና ቦርአ ታክ ቱሳ ስኒትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ኤስን ኦርፎ የሱስ ናዎባሳክቶኒክ፦ «ታኔን አነ ሀማክ ሾሌፌ ባር ቴትባሶን ቤየ ሜስቀልባሶን ዎርኤ ታኔን አነ ዮዎዋ። ");
INSERT INTO jnje_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ካባሶን ፉኦናክ ሾሌፌ ባር ዙቴሬ ትሽኩና። ስኑንታኖ ታ ቦርአ ካባሶን ትሽኪ ባር ዙቴሬ ዳናና። ");
INSERT INTO jnje_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","አሱ ሀን ዳስታኪ ባሪክ ሾልሲ ዉዛሶን ዙትሬ ዳንፋት ካባሶን ትሽክፋናነ አዉ ባሪክ ኬእኒሪንሶ? ወደይ አሱ ካባሲ ሶላክ አሮ ዉዛ ካሱናክ ችምንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","አሱኒ ና አባባሳ ኡልፍናክ ዎሲባስኔን አነ ዮኒርዋ። ኤስ ካባሲክ ዙታምባሴ አሲክ ዎስቶቤስስማቶ ባሶክ ካሱና። ");
INSERT INTO jnje_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ፉቶክ ንቶክ ማኬፋውጙዋ፤ አሱኒ ና ታቶባሲ ኡልፍናክ ዬፌን ብዮነ ካባኔን ሀንታ የሬ ባሶስን ክቱኖይ አሱኒ ሜያ ፌሴቴርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","እሱን ዎናኔን ኦርፎ የሱስ ጴጥሮስኒን፥ ያቆብንናዋ ያቆብኒ አይ ዮሀኒስና አሲን ኤጴ እሳ ድቻ ኣማስታ ባሶ ባሶትን ዞንስሬ ኬስ። ");
INSERT INTO jnje_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ኤስታክ ባሶ ስናክ ግቶባስ ሶልቴራ ስንባስ ደይ አውኒማቶ ቻሬ። ማይባስ ደይ ፎሬራ ቻሬፍኒማቶ ፓልፓሊ። ");
INSERT INTO jnje_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ሙሴናዋ ኤልያስና ደይ የሱስኔን አነ ዎሉምሴፌን ብየሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ኤስታን ጴጥሮስ የሱስኒን፦ «ዳሚሶ! ሀንታ ፎስ እኖክ ማአርዋ። ማእ እያታነ እሳሮን ኔክ፥ እሳሮን ሙሴኒክ፥ እሳሮን ኤልያስኒክ ስንኒ ኬዝ ሀፎ ኬርአናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ጴጥሮስ ኤስ ባሮን ማኬፌን ፓልፓልፋ ሻሩ ያራ ባሶትን ይኒ። ደይ ኤስ ሻሩስን፦ «ባሪክ ግሬፋና ናታስ ሀኒስዋ። ባሪን ኦዶትዋ» ይፋ ካማ ኦድቴ። ");
INSERT INTO jnje_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ናዎባሳክቶ ደይ ኤስ ካማሶን ኦደሴሬ አካማኖን ድጌሴቴ ቦርአ ስንቤሲሲክ ዳስታክ ጋንደሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ስኑንታኖ የሱስ ባሶኪ ታእሴሬ ታእፋት፦ «ካቡትዋ፥ ድጎትታዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ባሶ ደይ ካንነ ብየቴን የሱስኒንታኖ ኦም ኦኒኑ ኣነ ብዮቶ። ");
INSERT INTO jnje_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ኣማስታን ኬርሴፌን የሱስ፦ «አሱኒ ና ክቱኒ ካቡናኔን ሀን ቢት ባሮን ኦኒክኑ ማኮትታዋ» ይሬ ናዎባሳክቶኒን አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ናዎባሳክቶ ደይ፦ «ኤኪን ሙሴኒ ቱማሲ አስሲኛኒ ሜያ አዉኒ ቦርአ ዜምሜ ኤልያስ ዮናክ ሾልስፋዋ ይሴፌሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","የሱስ ዎልግሬ፦ «ፉቶዋ፥ ኤልያስ ዜምሜ ዬሬ ዙታምባሴ አስን ማእሱና። ");
INSERT INTO jnje_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ስኑንታኖ ታ ንቶክ ማኬፋውጙዋ፤ ኤልያስ ስና ዜምሜ የዋ፤ አሱኒ ሜያ ደይ ኣነ አሪሶቶ ስንና ቦርአ ሾልሴቴ ባሮን ዙትሬ ባሳስታ ዛግሴቴ። ኤሲስማቶ ደይ አሱኒ ና ባሶ ኩሹሲ ሻና ኤጴቶናክ ሾልስፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ኤስ ካባሲክ ናዎባሳክቶ የሱስ ማኬና ባር ሀጵቅፌ ዮሀኒስኒ ቾዋሶን ስንናማቶ አርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","የሱስናዋ ኬዝ ናዎባሳክቶና ዳራስኪ ዎል ሌ ዬሴፌ ካባሲክ እሳ አሱ የሱስኒኪ ታእሴሬ ዎቾባሲ ካአነፋት፦ ");
INSERT INTO jnje_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«ዳሚሶ! ናታሲክ ኬናሽቴፋይዋ፤ ኤጳ ሀእፋ ሜሮስ ማጙኖን ሻና ቤስት ፋርዋ። ሾዎ ዎና አካሲናዋ ጌሲና ጋንስርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ነ ናዎስኪ ኤጳ ያን፤ ስኑንታኖ ፋቱክ ኣነ ችሞቶ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","የሱስ ዎልግሬ፦ «ንቶ አማኖኖይ ኤልጛ ኮንቶ፥ ኣጌኔን ካርአንሶ ንቶኔን አነ ፎናሪ? ኣጌኔን ካርአንሶ ንቶትን ፋኩናሪ? ናስን ሀጝ ታክ ቴሾትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","የሱስ ኪና አያናሶን ኬእን ባሳስን ኬሲ። ናስ ደይ ኤስ ካባሲክ ፋሪ። ");
INSERT INTO jnje_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ኤስታን ናዎባሳክቶ ባሶ ባሶ የሱስኒኪ ታእሴሬ፦ «እንኖ ኪና አያናሶን ክሱ ችማ ቤይኒስ አዉኒ ቦርአንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","የሱስ ደይ ዎልግሬ፦ «ንቶ አማንቶስ ዮእና ቦርአዋ። ፉቶ ንቶክ ማኬፋውጙዋ፤ ፍፍኦኒ ጋናኔ ፋ አማንቶንት ፋፋናነ ሀን ኣማሶን ‹ሀንታን ካብራ ኤክ ሀምሜ› እያትነ ሀማናዋ። ንቶክ ችምኖይትዉዛ እሳንነ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ስኑንታኖ ሀን ኤፋቴና ኪና አያናስ ሶሜሬ ሺጶክታኖ ባክ ኣፋዋ ኬሳና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ናዎባሳክቶ ጋሊላክ ዙቴሴሬ ፌሴቴን የሱስ ባሶክ፦ «አሱኒ ና አሱኒ ሜኒ ኩሹሲ አቴሬ እምቶኒርዋ፤ ");
INSERT INTO jnje_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ባሶ ደይ ዎርሶነር፥ ስኑንታኖ ኬዝሲናሪ ዎኖ ኪቱን ካቡና» ይ። ናዎባሳክቶ ኤስ ቾዋሲክ ደይ አካማኖን ሱሜሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","የሱስናዋ ናዎባሳክቶና ክፍርናሆም ካርኤፌ ካባሲክ ቤቴሜቅደስኒ ግርቦ ዙትፌ አሱኒ ሜያ ጴጥሮስኒኪ ታእሴሬ፦ «ንቶ አስሲኛሲ ቤቴሜቅደሲክ ግርብቴፋ ግርቦሶን ኣነ ግርቤፌኖሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ጴጥሮስ ዎልግሬ፦ «ግርቤርዋ» ይ። ኤስታን ጴጥሮስ ኬር ግሪፌና ካባሲክ የሱስ ዜምሜ፦ «ስሞን ጴጥሮስ ኔክ አዉ ስንና ቤስቴፋሶ? ሀን ዳስታኪ ታቴ ሜያ ካራጣ ወደይ ግርቦ ዙትሴፌስ ኦኪኒንሶ? ናንጎትቤሲስኪንጝዋ ወደይ እርባስኪኒንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ጴጥሮስ ደይ፦ «እርባሲክጝዋ» ይሬ ዎልጊ። የሱስ ደይ፦ «ኤሴ ናንጎትቤሲሲክቶ ግርቦ ኣፋ ካሱሶነ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ስኑንታኖ ባሶስታ ቱሳ ስኖይኒማቶ ሀምፋት ኩርጡሚሲ ኤሽምያኖን ባሪስ ሀኡዋ። ኤስታን ዜምማ ኦቴ ኩርጡሚሲ ኖኖኖን ሾእሲፋታ ካባሲክ ብር ዳናታ። ታምማ ደይ ታ ሱናሲክናዋ ነ ሱናሲክና ካሱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ኤስ ካባሲክ ናዎባሳክቶ የሱስኒኪ ታእሴሬ፦ «ሳማኪ ታቶሲ ዙታምባሴ አሲስታን አርክር ኦንሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","የሱስ ደይ፦ እሳ ዳጋ ናዋ ቴጌሬ ባሶ ጋነያሲ ዬት። ");
INSERT INTO jnje_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ኤካ ደይ ይ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፤ ሶልቶ ሻካትነናዋ ሀን ዳጋ ናንጎታስንነ ፌር ስና ሻካትነና ሳማኪ ታቶሲ እሳንነ ኣፋዋ ግሩት ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ኤስ ባሪ ቦርኣ ሀን ዳጋ ናዋሲማቶ ቴትባሶን ዳ ኤጵፌ ባር ደን ሳማኪ ታቶኪ አሪክርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ኤሲስማቶ ሀኒስንነ ፌ ዳጋ ናዋሶን ታ ሱናሲክ ኤጴቴፌ ባር ታን ኤጴቶና።» ");
INSERT INTO jnje_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ደይ ቱስሬ፦ «ኦኑ ሀን ታክ አማነፌ ጋሮ ጋሮሳስን እሳይስን ቱሳእስፌ ባር ዎኒ ሹአ ሱትባስታ ታቴራ ባርሲ ትርእማሲ ሀእቴፋናነ ማአርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","አሱኒ ሜያ ቱሳእኦሶነክ ዛጉኒ ዉዝባሲክ ሀን ዳስ ሀይቡባዉጝዋ! ቱኡሳሱኒ ዉዛስ ኣፋዋ ዮ ቤያና ዉዛ። ስኑንታኖ ኤስ ቱሳሲክ ኡግና ስንኒ አሱስ ሀይቡባዎዋ! ");
INSERT INTO jnje_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ኤስ ባሪ ቦርኣ ዎቾኔስ ወደይ ኩሹኔስ ኔን ቱሳእሱኒር ስንፋናነ ካርአ ሀኡዋ። ሄፕ ኩሹነ ወደይ ሄፕ ዎቾነ ፋፋን ኮእባ ፎንቶ ጌሲ ሀእቶኔስታን ዱጙ ወደይ ኤጚት ስንና ኮእባ ፎንቶ ካ ዳነስ ዋያዋ። ");
INSERT INTO jnje_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ኣፍኔስ ቱሳሱኒር ስንፋናነ ዎእራ ሀኡዋ። ሄፕ ኣፍነ ፋፋን ጌኒ ትርእማሲ ሀቶኔስታን እሳ ኣፍነ ፋፋን ካ ዳንፋታነ ዋያዋ። ");
INSERT INTO jnje_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ደን ሳማክ ባሶክ ሆሬራ ፋሴ ሀኦሲ ዎስያንክቶ ሳማኪ ፌ አባታሳ ስናኖን ዎንና ዎንና ብየቴር ስንና ቦርአ ሀን ጋሮ ጋሮሳስን እሳይስኑ ካሹኖይትማቶ አሩትዋ።  ");
INSERT INTO jnje_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","አሱኒ ና ደይ ዬናስ ትሽ ባሶትን ፉኦክዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ደይ የሱስ፦ «አዉ ስንና ንቶክ ቤስቴፋሶ? እሳ አሱ ትያ ፋንቱባ ፋፋናነናዋ ኤስ ባርስን እሳር ትሽፋናነ እዝግናስሬ እዝግኔሶን ኣማስታ ቤይፋት ትሺ ባሮን ሾሎክ ኣፋኖሶ ሀማና ዉዛ? ");
INSERT INTO jnje_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ፉቶ ንቶክ ማኬፋውጙዋ፤ ዳንፌና ካባሲክ ትሹኖይ እዝግናስሬ እዝግኔስታን ኤስ ትሽራ ቤስቴ ባሪክቱ አካማኖን ግሬፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ኤሲስማቶ ደይ ሀን ጋሮ ጋሮሳስን እሳር ትሹናክ ደን ሳማኪ ፌ አባንትሳ ሳፋራታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ደይ ቱስሬ፦ «አይኔስ ኔን ሚርኤፋናነ ነኔን ባርኔን ፋትስታ ኔን ሚርኤና ባሮን ማኮዋ። ኦደፋናነ ዎልግራ አይነ ዛጉታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ስኑንታኖ ኦዶ ሻካናነ ሄፕ ወደይ ኬዝ ዛልንክቱ ቾዋስ ፉቶ ስንፋ ስንና ቦርአ ሄፕ ወደይ ኬዝ አሱኒን ኤጳ ባርኪ ሀማ። ");
INSERT INTO jnje_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ባሶትን ኦዶ ቤይፋናነ ቤቴክርስታኒሲክ ማኮዋ። ቤቴክርስታኒሶን ደይ ኦዶ ቤይፋናነ ሀኦሶን አማኖኖር ወደይ ቦርእኛ ዛግራ ፋዱዋ። ");
INSERT INTO jnje_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ታ ፉቶክ ንቶክ ማኬፋውጙዋ፤ ሀን ዳስታኪ ታርእኤፌቴ ባር ሳማክ ደይ ታቶቱ ስናናዋ። ሀን ዳስታክ ኮትፌት ባር ሳማክ ደይ ኮቶቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ደይ ንቶክ ማኬፋውጙዋ፤ ንቶስን ሄፒስ ሀን ዳስታኪ ኣፋ ዉዛሲክኑ ስኑን እሳር ስንነ ሺጵሴፋቴነ ሳማክ ፌ አባታስ ባሶክ ዛጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ሄፕ ወደይ ኬዝ ስንነ ታ ሱናሲክ ዙቴሴፌ ድማስታ ታ ባሶ ጋነያስ ፎናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ኤስታን ጴጥሮስ የሱስኒኪ ዬሬ፦ «ዳሚሶ! አይታስ ታን ሚርእኤፋናነ አፑና ዎላ ፌሹን ኡናሪንሶ? ናፉና ዎላኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","የሱስ ዎልግሬ፦ «ናፉና ዎላ ናፉነታኖ ናፉና ዎላ ኮእባዋ ኣፋዋ ኡናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ኤሲስማቶ ደን ሳማኪ ታቶስ ዎስትኛባሳክቶኒ ኩሹሲ ፋ ዋግባሶን ፋዱናክ ሾሌ ታቶነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ኤስ ዋግባሶን ፋዱ ኤጵፌና ካባሲክ አሲር ኩማ መኪልቲ ስንኒ ኮዋ ባሳስታ ፋና እሳ አሱኒን ባርኪ ኤጴ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ኤስ ዎስትኛአስ ካሱና ዋጋ ቱርክፋን ባርኔን አሱባስኔን ናንጎትባስኔን ፋ ዋግባስ ዙቴራ ኬሳ ዋግቴራ ኮዋስ ካስቶናክ ዳምባስ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ስኑንታኖ ዎስትኛአስ ዳምባሳ ዎቾሲ ካአእነሬ፦ ‹ዳሚሶ፥ ታክ ፋኩዋ፥ ዙታምባሴ አስን ካሱናዋ› ይት ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ዳምባስ ደይ ባሪክ ኬናሽቴፋት ጋፍኪ። ኮዋሶን ደይ ካስቶ ቤይ። ");
INSERT INTO jnje_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«ስኑንታኖ ኤስ ዎስትኛስ ኤስታን ኬስሴ ሀምፌን ዎስቶኒ ዞሞባ ስናርኪ ትያ ዲናሪ ልቅስናሪን ዳንነ፦ ‹ልቅስና ዋግናሶን ካሱዋ› ይት ዛቴ ጌርእ። ");
INSERT INTO jnje_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ኤስ ዎስቶኒ ዞሞባ ስና ዎስትኛስ ደይ ዎቾባሲ ካአነሬ፦ ‹ታክ ፋኩዋ፥ ዙታምባሴ አስን ካሱናዋ› ይት ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ስኑንታኖ አሱስ ኣነ ማእ ኡዌ። ኮዋሶን ካሱናኔን ታምሜ ታቶኒ ኬር ታት። ");
INSERT INTO jnje_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ኤስ ስና ባሮን ዎስቶኒ ዞሞባ ስና ኦም ዎስትኛአሳክቶ ባር ዛግና ባሮን ብየፋት አካማኖን ሱሜሴቴ። ሀሜሬ ደይ ስና ባሮን ዙትሬ ዳምቤሲሲክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ኤስታን ዳምባስ ኤስ ዎስትኛስን ቴግስሬ፦ ‹ነ ማጙ ዎስትኛዋ፥ ታን ሺጴን ኤስ ኤፋቴና ኮዋሶን ዙትራ ኔክ ቤይን።› ");
INSERT INTO jnje_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ኤኪን ታ ኔን ፋክናስማቶ ዞሞነ ስና ኤስ ዎስትኛስን ፋኩታክ ኣነ ሾልስፋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ዳምባስ ግእቴሬ ኮዋሶን ዙትሬ ካሱናኔን ሻና ብያናክ ታቶኒ ኬያሶን ሀእስፌ ባሶክ ኣትሬ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«ኤሴ ንቶ ደይ እሳ እሳርኒትስ አይንትሳክቶኒን ንብንትስን ኮእስራ ፌሹን ኡ ሻካትነ ደን ሳማክ ፌ አባታስ ደይ ንቶስታ ኤሲስማቶቱ ዛጉናዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","የሱስ ኤስ ባሮን ማኬሬ ኮእስናኔን ኦርፎ ጋሊላን ኬስሴ ዮርዳኖስኒ የሳሎ ፋ ዩዳኒ ዳስታ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ሾዎ ዳራ ባሳ ኦርፎሴ ሀሜሴቴ። ባሶስን ደይ ሜትቴ አሱኒ ሜያኖን ኤስታክ ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ፌርሳዊኒ ሜያ ደይ ዬሴሬ ባሪን ፋታኖክ ሾልሴፋት፦ «አሱ ስና ቾዋ ኣፋርክ ስኑን አሱባሶን ቴትባ ኮትቴ ጋፍኩናክ ፋቃድቶኖሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","የሱስ ዎልግሬ ኤካ ይ፦ «ሀኦስ ዜምማ ኣርቃርናዋ ማሽካሬ ዛግራ ቴስናማቶ ኣነ ፌሬቱዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‹ኤስ ባሪ ቦርኣ አሱ አባባስንናዋ እንቶባሶንና ቤየ አሱባስኔን እሳር ስናና። ሄፖቤሲሴ ደይ እሳ አቱ ስኖነ› ");
INSERT INTO jnje_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ኤሴ ባሶ ሀንኔን ኤካሎ እሳ አቱታኖ ሄፕ አቱታዋ። ሀኦስ እሳር ዛግና ባሶትን አሱ ኦር ክሱናታዋ» ");
INSERT INTO jnje_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ፌርሳዊኒ ሜያ ደይ ዎልግሬ፦ «ኤኪን ሙሴ አዉኒ ቦርአ ‹ቴትኒ ኮትኒ ትቻ እምሜ ቴትባ ኮቶዋ› ይሬ አጃጀሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","የሱስ ዎልግሬ፦ «ንቶ ንብባሲ ችምኒ ቦርአቱ አሱንትሲክቶኖን ቴትባ ኮታ ጋፍኩትክ ማኬቴኖ ቴሱስታኔን ኤካታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","«ስኑንታኖ ታ ንቶክ ማኬፋውጙዋ፦ ‹እሳ አሱ ጌርኬስን ቾዋክ ስኖይናሮን አሱባሶን ቴትባ ኮቴ ጋፍካት ኦማ አሱ ኤጵፋናነ ጌርኬስዋ።› » ");
INSERT INTO jnje_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ናዎባሳክቶ ደይ፦ «አባነዋ እንቶነ አሲ ቾዋስ ኤካ ስንፋናነ ኤጵነዋ ግሩነ አሲን ቤያስ ማአርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ስኑንታኖ የሱስ ዎልግሬ፦ «እምቴና ባሶክታኖ ሀን ኤፋቴና አሱስ አሱ ዙታምቤሲሴ አሲክ ኣፋ ችምቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","እንቶቤሲስ ኬንስን ኣርቃርቤስ ፎንቶ ስንነ ኮንቴር ፌሴቴር። ደይ አሱ ኣርቃርቤሲሶን ካርእናር ፌሴቴር። ሳማኪ ታቶሲኪዋ እያት ኣርቃርቤስ ፎንቶነ ፌር ስናር ፌሴቴር። ኤጴቶክ ችምኒ ባር ኤጴቶዎዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ኤስታን የሱስ ኩሹባሶን ባርኪቶኒስታ ታእሬ ሺጶናክ አሱኒ ሜያ ዳጋ ናንጎታሶን የሱስኒኪ ኤጴ ዬሴቴ። ስኑንታኖ ናዎባሳክቶ ካለሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ስኑንታኖ የሱስ፦ «ሳማኪ ታቶስ ሀን ናንጎታስንነ ፋዪሲክ ስንና ቦርአ ዳጋ ናንጎታሶን ቤይፋኒ ታክ ዮሶንዋ፥ ካላትታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ኩሹባሶን ናንጎታስታ ታእሬ ሱሳት ኤስታን አቴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","እሳ አሱ የሱስኒክ ዬሬ፦ «አስሲኛኖ! ኮእባ ፎንቶ ካ ዳናናክ አሮ ማአ ዉዛ ዛጉናሪንሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","የሱስ ዎልግሬ፦ «ማአ ዉዝኒ ቾዋ አዉኒሮን ታክ ማምሲፋሶ? ማአር ስናስ እሳ ሀኦስ ኮእባዋ። ካኒ ኬር ግሩክ ሾሌፋታነ አጃጂሲክቶኖን ኦድዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","አሱስ ደይ ዎልግሬ፦ «ኣፋ አጃጂሲክቶንሶ?» ይ። የሱስ ባሪክ፦ «አሱኒ ዎሩታታ፥ ጌርኬሳታታ፥ ዊሶታታ፥ ኤሻ ዛላ ማኮታታ ");
INSERT INTO jnje_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","አባነስንናዋ እንቶኔሶንና ኡልፍንሱ፥ ዎልኮኔስን ቴትኔሶን ሹንፋታስማቶ ሹን» ይፋ አጃጂሲክቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ናኦ አሱስ ደይ፦ «ኤስ ባሮን ዙትራ ኦዳቱ ፋዉጝዋ፥ ኦማ ዮእር ኣምባንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","የሱስ ደይ፦ «ቱም ስናታክ ሾሌፋታነ ሀማ ፋ ዉዝኔሶን ክስራ ዋጌራ ቱካምኒ ሜያክ እማ። ሳማኪ ኦትማ ዳናታዋ፤ ኤካት ዬን ታኔን አነ ሀሚንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ስኑንታኖ ናኦ አሱስ አካማ ኦቱምባ ፋና ቦርአ ኤስ ካማሶን ኦደናይሴ ሱሜት ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","የሱስ ናዎባሳክቶኒክ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፤ ኦቱም አሱኒክ ሳማኪ ታቶሲ ግሩስ አካማኖን ፋያዋ። ");
INSERT INTO jnje_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ደይ ንቶክ ማኬፋውጙዋ፤ ኦቱም አሱ ሀኦሲ ታቶሲ ግሩባስታን ጋላ ማሩፍኒ ካቶሲ ካሞ ኣትፋናነ ካሾዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ናዎባሳክቶ ኤስ ባሮን ኦደሴቴይሴ አካማኖን ዲንቀሴፋት፦ «ኤኪን ኦንሶ ፋሩክ ችምንሪ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","የሱስ ደይ ባሶኪ ብያት፦ «ሀን ባር አሱኒክ ኣፋ ችምቶና ዉዛ። ስኑንታኖ ሀኦሲክ ዙታምባሴ ችምቶናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ኤስ ካባሲክ ጴጥሮስ ዎልግሬ፦ «ኤሴ እንኖ ዙታምባሴ አስን ቤያ ኔክ ዞኑስቴንዋ፤ ኤኪን አዉ ዳኑጌሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","የሱስ ባሶክ ኤካ ይ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፤ አሱኒ ና ኡልፍንኒ ዝግሙባስታ ዱና ጋድዶ ዮን ዳስታኪ፤ ታክ ዞኑስቴሴፌ ንቶ ደይ አስሬ ሄፔ እስራኤልኒ ዝግሞስታ ዱሶትዋ። አስሬ ሄፔ እስራኤልኒ አስቴሴርስታ ደይ ማጝሱ ካርአትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ታ ሱናሲክዋ እያት ኬያሲክቶኖን ወደይ አይሳክቶኒን ወደይ ኤትሲክቶኖን ወደይ አባባስንናዋ እንቶባሶንና ወደይ ናንጎታሶን ወደይ ቡሎሶን ቤያ ባር ዙታምባሴ ትያ ኩሹኖንቱ ዳናናዋ። ኮእባ ፎንቶ ካ ደይ ዳናና። ");
INSERT INTO jnje_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ስኑንታኖ ዜምማ ባሶ ሾዎቤሲስ ኦርፎትር ስኖነ። ኦርፎትር ስና ባሶ ደይ ዜምማር ስኖነ።» ");
INSERT INTO jnje_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ሳማኪ ታቶስ ዋይንኒ አካኪልቲኒ ድማስታ ዎስቴሴፌ ዎስትኛኒ ሾሎክ ኤእሶ ዎንሳክ ኬሳ ዋይንኒ አካኪልቲኒ አባነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ባር ዎስትኛሳክቶኒክ እሳ ዎናክ እሳ ዲናሪ ካሱናክ ዎሌሬ ዋይንኒ አካኪልቲኒ ድማስታ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ደይ ኬዝ ሳአትስታ ኬሴ ኦም ዎስቶ ፎንቶ ሜያ ያቦስታ የርሴ አሱኒ ሜያኖን ቢ። ");
INSERT INTO jnje_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ኤስ ባሶክ ደይ፦ ‹ንቶ ደይ ኤክ ዋይንኒ አካኪልቲሲ ድማስታ ሀምፋት ዎስቶትዋ። ንቶክ ሾልሲ ዋጋሶን ካሱናዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ባሶ ደይ ዋይንኒ አካኪልቲኒ ድምታ ሀሜቴ። ደይ እሱን ሳአትሲናዋ እዝግን ሳአትስታና ኬሴ ኤሲስማቶ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","አሲሬ እሴ ሳአትስታ ደይ ኬሴ ኦም አሱኒ ሜያ የርሴፌኒ ብያት፦ ‹ንቶ ደይ ዎስቶ ፎንቶ ዎናሶን ዙትራ አዉኒ ቦርአ ሀንታ የሬትሪንሶ?› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ባሶ ደይ፦ ‹እኖትን ዎሱሱኒ አሱኒን ቱርክራ የሬኒርዋ› ይሴቴ። ባር ደይ፦ ‹ኤክ ዋይንኒ አካኪልቲኒ ድማስታ ሀምፋት ዎስቶትዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ዋልፋና ካባሲክ ዋይንኒ አካኪልቲሲ ዳም ዎሱስፌ ባሪን፦ ‹ዎስትኛአሳክቶኒን ቴጌራ ኦርፎቲ ባሶስታን ካብግራ ሲናክ ባሶስታ ካርአና ካባኔን ዎስቴሴቴ ዎስቶሲ ዋጋኖን ካሱዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","አሲሬ እስሴ ሳአትክ ዎስቶሲ ግሪ ባሶ ዬሴሬ እሳ እሳርቤሲስ እሳ ዲናሪ ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ዜምሜ ዎስቶሲ ግሪ ባሶ ደይ ዬሴሬ ኦርፎቲ ባሶስታን ዳይቶኖን ኤጶነነ ፋር ስንና ባሶክ ቤስቴ። ስኑንታኖ ባሶ ደይ እሳ እሳርቤሲስ እሳ ዲናሪ ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ዋግቤሲሶን ኤጴቴይሴ ዋይንኒ አካኪልቲሲ አባኒታ ኤካ ይት ኡኚሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹ሀን ኦርፎ ግሪ ባሶ እሳ ሳአትንንቱ ዎሱሴቴ። ዎናሶን ዙትራ ኖእሳክ ኪቼሬ ፌሻ እኖኔን እሳ ክጤ ካስትዋ› ");
INSERT INTO jnje_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ዋይኒሲ አካኪልቲኒ አባ ዎስትኛአሳክቶኒስን እሳይሲክ፦ ‹ዞሞታሶ! ታ ኔን ኣነ ሚርእኦትዋ። ዎናሲክ እሳ ዲናሪ ካሱናክታኖሶ ነኔን አነ ዎል ሌናሪ? ");
INSERT INTO jnje_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ኤሴ ነ ሃእኦሶን ኤጳ ሀማ። ሀን ኔክ እምናስማቶ ኦርፎቲ ባሪክ እማናክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ዋግናስታ ሹናሮን ዛጉናክ ኣፋኖሶ ችማናዉዛ? ወደይ ጋራም አሱ ስንና ቦርአ ነ ታን ኮነቶሶ?› » ");
INSERT INTO jnje_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ኤስታን የሱስ፦ «ዜምማ ባሶ ኦርፎትር ስኖነ፤ ኦርፎቲ ባሶ ደይ ዜምማር ስኖነ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ኤሴን ኦርፎ የሱስ የሩሳሌም ሀሜፌት ኡግናስታክ አሲሬ ሄፔ ናዎባሳክቶኒን ባሶ ባሶትን ባርኪ ታእስሬ፦ ");
INSERT INTO jnje_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«ኤሴ የሩሳሌም ሀማኒርዋ፤ አሱኒ ና ደይ ማግኒ ጋኝኜ ሜያክናዋ ሙሴኒ ቱማሲ አስሲኛኒ ሜያክና አቴሬ እምቶና። ባሶ ደይ ክቱኒ ማጝሱኒ ካርአ ባሳስታ ካርእኦነር። ");
INSERT INTO jnje_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ካኞሶነክ፥ እቾሶነክናዋ ሱቶሶነክና አዛብኒ ሜያክ ኣትሬ እሞነ። ስኑንታኖ ባር ኬዝስናሪ ዎኖ ክቱኒ ካቡናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ኤስታን ዘብደዎስኒ ናንጎትሳ እንቶ ናንጎትስኔን አነ የሱስኒኪ ያራ ስንባ ካእነራ ባር ባሪክ እሳ ዉዛ ዛጉናክ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","የሱስ ደይ፦ «አዉ ሾሌፋትሴ?» ይ። ባር ደይ፦ «ሀን ሄፕ ናጝጎታስ ነ ታቶሲ እሳይስ ኦእታኔስታ፤ እሳይስ ደይ አልዳኔስታ ዱሶናክ ዛጉዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ስኑንታኖ የሱስ ዎልግሬ፦ «ንቶ ሺጴፌት ዉዛሶን ኣነ አሪፌትዌ። ታ ኡሻናክ ፋ ሻናኒ ቶፎሲ ኡሻኖን ኡሻትክ ችማትሮሶ?» ባሶ ደይ፦ «ኣ ችማኒዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ባር ደይ፦ «ታ ሻናኒ ቶፎሲ ኡሻኖን ኡሻትዋ፤ ስኑንታኖ ኦእታናስታናዋ አልዳናስታና ዱሶን አባታስ ሆስና ባሶቴኖ ዱሶነክ ዛጉኒስ ታቴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ኤስ ባሮን ኦዴ ኦም አስር ናዎኒ ሜያ ኤስ ሄፕ አይና አይና አሲስታ ሃሬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ስኑንታኖ የሱስ ባሶትን ባርኪ ቴጌሬ ኤካ ይ፦ «ኣዛብኒ ሜኒ ጋኜ ሜያ ዳራቤሲሳ አእስኛዋ። ባሶትን ዞንሲሴፌ ሜያ ደይ ባሶስታ ሀእሱኒ ሁግናቤስ ፋናማቶ አርሴፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ንቶ ጋነያሲ ኤካ ስናናክ ኣነ ሾልስፋዋ። ስኑንታኖ ኦኑ ንቶስን አርክር ስናናክ ሾሌፋናነ ንቶ ዎስትኛ ስኖዋ። ");
INSERT INTO jnje_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ኤሲስማቶ ደይ ንቶስን ደናሎ ስናክ ሾሌፌ ባር ንቶ ቦዝ ስኖዋ። ");
INSERT INTO jnje_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","አሱኒ ና ደይ ኦሚሲክ ዎስቶናክናዋ ሾዎኒ ሜያኖን ፋቱክ ካባሶን ኣትሬ እማክቱ ዬቴኖ ባሶ ባሪክ ዎስቶሶነክ ኣነ ዮዌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ኤሴን ኦርፎ እያሪኮን ኬሴ ሀሜፌን ሾዎ ዳራ የሱስኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ኤስታክ ደይ ኡጉኒ ቴሽታ ዲሴ ሄፕ ኣፍትሹኒ ሜያ የሱስ ባሶኪ ኤስታ ካሞ ኣትባሶን ኦደሴቴይሴ፦ «ዳሚሶ! ዳዊትኒ ናሶ! እኖክ ፋክፋይዋ!» ይት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ዳራስ ደይ፦ «ሻኩትዋ» ይት ኬእሴቴ። ስኑንታኖ ባሶ፦ «ዳሚሶ! ዳዊትኒ ናሶ! እኖክ ፋክፋይዋ!» ይት ኣታምሲሬ ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","የሱስ ደይ የሬሬ ባሶትን ባርኪ ቴጌሬ፦ «ንቶክ አዉ ዛጉናክ ሾሌፌትሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ባሶ ደይ፦ «ዳሚሶ! ኣፍኒስ ጋቾናክ ዛጋይዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","የሱስ ባሶክ ኬናሽቴፋት ኣፌሲሶን ታእ። ጌሬጌሬ ደይ ኣፍቤሲስ ቢን የሱስኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","የሱስናዋ ናዎባሳክቶና የሩሳሌም ታእሴሴቴ። ዳብራዛይትኒ ኩማስታ ፋ ቤቴፋጌ ይስቴፋ ኬኤስ ካርኤፌ ካባሲክ ናዎባሳስን ሄፕን ኤካ ይት ዎሲ፦ ");
INSERT INTO jnje_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«ኤክ ስኒትስታ ፋ ኬኤሲ ሀሚት፤ ኤስታክ ቱፕቴራ የሬ ሀኛ ናዉባኔን የሬፌኒ ዳናት። ኮታ ታክ ኤጳ ዮሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ኦኑ ‹አዉኒሮን ባርኪቶኖን ኮትፌትሪንሶ?› እያናነ ‹ዳሚስ ባርኪቶኖን ሾሌፋዉጙዋ› ኡት። ባር ደይ ጌሬጌሬ ሀኛሲክቶኖን ጋፍኩና» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ኤስ ባር ደይ ስንናስ ራጁኒ ሜያኪ ካሞ ኤካ ይስቴራ ማክቴ ባር ስናናክዋ። ");
INSERT INTO jnje_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«ፂዮንኒ ካታማ ይስቴፋ የሩሳሌሙክ፦ ‹ነ ታቶስ ጋራም ስንነ፤ ሀኛሲ ናታ ዲሬ፤ ኔኪ ዮኒርዌ› ይራ ማኮት» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ናዎባሳክቶ ደይ ሀሜሬ የሱስ አጃጀናስማቶ ዛጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ሀኛሶን ደይ ናባስኔን ኤጴ ዬሴቴ። ማይቤሲሶን ደይ ሀኛሲክቶኒ ጌሾታ ኩኑሴቴን የሱስ ባርስታ ድ። ");
INSERT INTO jnje_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ዳራሳ ጋነስን ሾዎቤሲስ ማይቤሲሶን ኡግናስታ ይቴ። ኦሚስ ደይ እኦኒ ቶሻ ኪርእታፌ ኡግናስታ ይርእኤት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ስና ዜምማ ባሶትናዋ ኦርፎሴ ሀሜፌ ባሶትና፦ «ሆሳና ዳዊትኒ ናሲክ ስንፋውጝዋ። ዳሚሳ ሱናክ ዬፌ ባር ሱስቶዋ። ሆሳና ደን ሳማክ» ይት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","የሱስ የሩሳሌምኒ ካታማሲ ግሪፌና ካባሲክ አሱኒ ሜያ ዙቴሬ፦ «ሀኒስ ኦንሶ?» ኡክ ሾርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ዳራስ ደይ፦ «ሀኒስ ጋሊላኒ ዳስታክ ፋ ናዝሬትን ካታማስን የ ራጁ የሱስዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ኤሴን ኦርፎ የሱስ ደይ ቤቴሜቅደሲሲ ግሪሬ ክስሬ ዋግሴፌ ባሶትንናዋ ጌሮን ዋግሴፌ ባሶትንና ዙትሬ ካሌ ክስ። ዋጋ ሶለፌ ባሶ ጣራቤዛሶንናዋ ናካሎ ዋግሴፌ ባሶ ኮዳሶንና ሸልግሬ ሀእ። ");
INSERT INTO jnje_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","« ‹ታ ኬያስ ሺጶኒ ኬያ ይስቴራቱ ቴግቶና› ይስቴራ ትቼዋ። ስኑንታኖ ንቶ ቦእኛኒ ሜኒ ዱጋዱግ ዛግሴትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","የሱስ ቤቴሜቅደሲሲ ፌን ኣፍትሹኒ ሜናዋ ኤግትኒ ሜና ባርኪ ዬሴቴን ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ስኑንታኖ ማግኒ ጋኝኜ ሜናዋ ሙሴኒ ቱማሲ አስሲኛስና የሱስ ዛግና ቢስቴራ አሪቶኖይ ዉዛሴዋ ቤቴሜቅደሲሲ «ሆሳና ዳዊትኒ ናሲክ» ይት ቻጌት ፋ ናንጎታሶንና ብየቴሴ ግእቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ባሶ ደይ፦ «ሀን ናንጎታስ ማክሴፋና ባሮን ኣነ ኦደፌኖሶ?» ይሴቴ። የሱስ ደይ፦ «ኦደድፋዉጝዋ፦ ‹ዳጋ ናንጎታስኪንናዋ ታማ ታምፋ ዳጋ ናንጎታሲ ካምስንና ጋላታ ነ ቴታሲክ ሆስትዋ› ይፋ ካማሶን እሳንነ ኣነ ፌሬትራ ብየትኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ባሶትን ቤየ ካታማስን ኬሴ ብታኒያ ይስቴፋ ኬኤስ ሀሜ ኤስታ ሀእ። ");
INSERT INTO jnje_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","የሱስ ኤእሶ ዎንሳክ ዎል ሌ ካታማ ሀሚፌት ማክቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ኡግናስ ቴሽታ ድ እሳ ቤለስኒ እኦ ብያት ኤክ ባርኪ ሀሚን ቶሻ ቶሻታኖ እሳ ጋናነ ኣነ ዳንነ። ኤስታን ኤካ ይ፦ «ሀውጙኔን ኤካሎ ኔኪን እሳ ጋናነ ቤስቶናታዌ» ይ። እኦስ ደይ ኤስ ካባሲክ ጌሬጌሬ እችሚ። ");
INSERT INTO jnje_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ናዎባሳክቶ ኤስ ባሮን ብየፋት፦ «ሀን ቤለሲሲ እኦስ ጌሬጌሬ ኣካክ እችሚሶ!» ይሴት ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","የሱስ ደይ ዎልግሬ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፤ አማንቶኒቲ ፋፋናነናዋ አዉዛክነ ኡ ሻካትነና ሀን ቤለሲስታ ስና ባርነ ፋሮን ዛጉ ኮእባ ስኖይናሮን ሀን ኣማሶንኑ፦ ‹ዋቴራ ዬት ባሪስ ሀእቶዌ› እያትነ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","አማነራ ሺጴፌቲ ባሮን ዙትራ ኤጳቶትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","የሱስ ቤቴሜቅደሲሲ ግሪሬ አሲፌን ማግኒ ጋኝኜ ሜናዋ ዳራሳ ኩርኡኒ ሜና ባርኪ ዬሴሬ፦ «ሀን ባሮን አሮ ሀእሱኒ ሁግናኪንሶ ዛግድፋታሪ? ሀን ሀእሱኒ ሁግናሶን ደይ ኔክ እማስ ኦንሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","የሱስ ዎልግሬ፦ «እሳ ማምሱ ንቶትን ማምሱናዋ። ኤስ ባሮን ታክ ዎልጋትነ ታ ደይ ሀን ባሮን አሮ ሀእሱኒ ሁግናክ ዛግፋናማቶ ንቶክ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ዮሀኒስኒ ሀጵቁስ አይን ያሪንሶ? ሀኦስኪንጝዋ ወደይ አሱኒኪንንሶ?» ይ። ባሶ ደይ ባሶትና ባሶትና ኤካ ይት ሜርኬሴቴ፦ « ‹ሀኦስክጝዋ› እያንነ ‹ኤኪን አዉኒ ቦርአ ባሪክ አማኖ ቤይትሶ?› ይርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ደይ፦ ‹አሱኒክጝዋ› እያንነ አሱ ዙታምባሴ ዮሀኒስኒን ራጁ ዛግሬቱ ብየፌ ቦርአ ዳራስን ድጌንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ኤስታን የሱስኒክ ዎልግሬ፦ «ኣነ አሪፌኒዋ» ይሴቴ። ባር ደይ ዎልግሬ፦ «ኤሴ ታ ደይ አሮ ሀእሱኒ ሁግናክ ሀን ባሮን ዙትራ ዛግፋናማቶ ኣፋዋ ንቶክ ማኮና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ቱስሬ የሱስ ደይ ኤካ ይ፦ «ንቶክ አዉ ስንና ቤስቴፋሶ? እሳ አሱ ሄፕ ናንጎትባ ፌርዋ። እሳይስኪ ታእሴሬ፦ ‹ናታሶ፥ ሀሽ ሀውጙ ሀማ ዋይንኒ አካክልቲሲ ድምታ ዎስቶዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ናስ ደይ ዎልግሬ፦ ‹ቤይን፥ ኣፋ ሀማና ዉዛ› ይ። ስኑንታኖ ኦርፎ ጋቤሬ ዎስቶክ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ደይ ሄፕሳስኪ ታእሴሬ ኤሲስማቶ ማኬን ናስ ዎልግሬ፦ ‹ማእዋ፥ ሀማናዋ ዳምታሶ› ይ። ስኑንታኖ ኣነ ዎስቶክ ሀሜ። ");
INSERT INTO jnje_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ኤሴ ሀን ሄፒሳስን አባባሳ አጃጅኖን ዛግስ ኣፌሪንሶ?» ይ። ባሶ ደይ፦ «ቴሱኒ ባርዋ» ይሴቴ። የሱስ ደይ ኤካ ይ፦ «ፉቶክ ንቶክ ማኬፋውጙዋ፤ ግርቦ ዙትፌ ባሶናዋ ጌርኬሴፌ ባሶትና ሀኦሲ ታቶሲ ግሩክ ንቶስታን ዜሞነዋ። ");
INSERT INTO jnje_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ዮሀኒስ ኦኮኒ ኡግናሶን ንቶክ ቤሱክ ዬን ባሪክ ኣነ አማኖዌት። ስኑንታኖ ግርቦ ዙትፌ ባሶናዋ ጌርኬሴፌ ባሶና ባሪክ አማነሴቴ። ንቶ ኤስ ባሮን ቢራ ቦርእኒትሶን ሀርምራ ኣነ ባሪክ አማኖዌት።» ");
INSERT INTO jnje_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ደይ የሱስ ኤካ ይ፦ «ኦማ ቤሶ ደይ ኦዶትዋ፤ ዋይንኒ ቶኮ ቶካ እሳ አሱ ፌር። ባር ደይ ብራቶባሶን ኦጃ ኦጄ ዋይንኒ ኡሻ ትኡና ዶአ ይሼ ሆሲ። ቶሎ ኬርኤ ቡልኛኒ ሜያክ እማት ኦማ ዳ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ዋይኒስ ጋናና ዎና ካርእፋና ካባሲክ ባሳ ሃኦሶን ኤጴ ዮሶነክ ዎስትኛባሳክቶኒን ቡልኛኒ ሜያኪ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ቡልኛኒ ሜያ ዎስትኛአሳክቶኒን ኤጴ እሳይስን እቸቴ፤ እሳይስን ዎርሴቴ፤ ኦሚስን ደይ ሹአክ እቼቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ዋይንኒ አካክልቲሲ አባ ስናቲስታን ኦም ሾዎ ዎስትኛኒን ደይ ዎሲ። ቡልኛኒ ሜያ ደይ ዜሞቲሲማቶ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ኮእባስታክ ደይ ዋይኒሲ አባ፦ ‹ናታስንቱ ድግሶነዋ› እያት ናባስን ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ስኑንታኖ ቡልኛኒ ሜያ ናስን ብየቴይሴ ባሶትና ባሶትና፦ ‹ፍኦሻሶን ቶኒስ ሀን ባርዋ። ያን ዎራት ፎሻሶን እንኖር ዛጉኒዋ› ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ናስን ደይ ኤጴሬ ዋይኒሲ ፎሽኒ ጌራካሎ ክሴሬ ዎርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«ኤኪን ዋይንኒ አካክልቲሲ ዳም ዬፌና ካባሲክ ኤስ ቡልኛኒ ሜያስታ አዉ ዛጉኒርነ ፋር ስንና ንቶክ ቤስቴፋሶ?» ");
INSERT INTO jnje_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ባሶ ደይ ዎልግሴሬ፦ «ኤስ ማጙ አሱኒ ሜያኖን ማጙ ዎሩ ዎራቱ ዋይኒሲ አካክልቲኒ ድማኖን ዎንባ ዎንባሲክ ጋንባሶን እምኒ ኦም ቡልኛኒ ሜያክ እማናዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ቱስሬ ደይ የሱስ ባሶክ ኮርቶ ማፃፋሲን ኤካ ይ፦ « ‹ሹእኒ ኬያሶን ኦኤፌ ባሶ ካሽሴቴ ሹእኣስ፤ ኬያሲክ ካጃባስታ ዱኒ ሹአ ስንዋ፤ ኤስ ባር ደይ ዳሚስኪንቱ ስንዋ፤ እንኖ ኣፋንሲክኑ ዲንቂዋ› ይስቴራ ትቼ ባሮን ኣነ ፌሬቱዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«ኤስ ባሪ ቦርኣ ንቶክ ማኬፋውጙዋ፤ ሀኦሲ ታቶ ንቶስታን ኦቴራ ጋና ጋኒ ዳራሲክ እምቶኒርዋ።  ");
INSERT INTO jnje_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ኤስ ሹኣስታ ጋንዴ ባር ኤስቶና፤ ሹኣስ ባሳስታ ጋንዶና ባር ዙቴሬ ፍችንቶና። ");
INSERT INTO jnje_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","«ማግኒ ጋኝኜ ሜናዋ ፌርሳዊኒ ሜና ኤስ ቤሶሶን ኦደሴፋት ባሶስታ ማኬናማቶ አርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ኤስ ባሪ ቦርኣ ኤጶሶነክ ሾልሴቴ። ስኑንታኖ ዳራስ ራጁ ዛግሬ ብየት ፌር ስንና ቦርአ ድጌሴቴ።» ");
INSERT INTO jnje_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ሄፕሳ ደይ የሱስ ቤሶክ ኤካ ይት ማኬ፦ ");
INSERT INTO jnje_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«ሳማኪ ታቶስ ናባሲክ ሳርግኒ ኮታ ኮቴ ታቶነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ታቶስ ቴግቴ አሱኒ ሜያ ኮታስኪ ዮሶነክ ዎስትኛባስን ባሶኪ ዎሲ። ስኑንታኖ ባሶ ኮታሲክ ዮሶነክ ኣነ ሾልሶቶ። ");
INSERT INTO jnje_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«ሄፕሳ ደይ ታቶስ ኦም ዎስትኛኒ ሜያኖን ዎስሬ ቴግቴ አሱኒ ሜያኪ ሀምፋት፦ ‹ኤሴ ሳርግኒ ኮታሶን ሆስን፤ ኦሞሩሴዋ ፋሩ ሞናሴ ሹክቴራ ዙታምባሴ ሆሬ። ሀን ሳርግሲ ኮታኪ ዮትዋ› ይራ ማኮት» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ስኑንታኖ ባሶ ሀንታክ ዉዛነ ኡኖይ ቤየሬ እሳይስ ቡሎባሲ፤ ኦሚስ ናጋድባሲ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ኦሚስ ደይ ዎስትኛኒ ሜያኖን ኤጴ ሳልጵስሬ እቼ ዎርሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ኤስታን ታቶስ ግእቴሬ ሜያ ታርኦሳክቶኒን ዎስሬ ኤስ ዎሪ ባሶትን ዎርሶነክ ዛጊ። ካታማቤሲሶን ደይ ጌያክ ኪቾናክ ዛጊ። ");
INSERT INTO jnje_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ኤስታን ዎሲትኝኛባሳክቶኒክ ኤካ ይ፦ «ሳርግኒ ኮታስ ሆሬ፤ ስኑንታኖ ቴግቴ ባሶ ኮታሲክ ሾልሱኖር ስንነቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ኤሴ ኤክ አሪ ኡግናስታ ኬሴፋት ዳንቲ አሱስን ዙትራ ሀን ሳርግኒ ኮታስኪ ቴጎትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ዎስትኛኒ ሜያ ደይ አሪ ኡግናስታ ኬሴሬ ዳነቴ ባሶትን ማጙስን፤ ማኣስን ዙትሬ ቴግሴሬ ሳርግኒ ኬያሶን ቱኒሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«ስኑንታኖ ታቶስ ቴግቴ እርባሳክቶኒን ብያክ ኬር ግሪፌና ካባሲክ ሳርግኒ ማያ ማይኖይ እሳ አሱኒን ኤስታክ ቢ። ");
INSERT INTO jnje_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","«ኤስታን ኤካ ይ፦ ‹ዞሞታሶ፤ ሳርግኒ ማያ ማይኖይ ኣካክ ሀንሲ ግርትሶ?› ይን አሱስ ደይ ሻኪ። ");
INSERT INTO jnje_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«ታቶስ ደይ ዎስትኛባሳክቶኒን፦ ‹ኩሹባሴዋ ዎቾባሴ አስን ታርእአ ጌራካሎ ፋ ታልማሲ ክስራ ሀእኡትዋ። ኤስታክ ዋስነዋ አይኒ ኮይነ ስናናዋ› » ይ። ");
INSERT INTO jnje_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ቱስሬ ደይ የሱስ፦ «ቴግቴ አሱኒ ሜያ ሾዎ፤ ኮርቴስ ደይ ጋሮዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ኤስታን ፌርሳዊኒ ሜያ ሀሜሬ የሱስኒን ዎሉምባስኪ ካሞ ኣካክ ቾዉሲ ጌዶነማቶ ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ባሶ ናዎኒ ሜያኖን ሄሮድስኒ ኬን ስና አሱኒ ሜያኔን የሱስኒኪ ዎሴሬ፦ «አስሲኛኖ! ነ ፉቶኒር ስንታማቶናዋ ሀኦሲ ኡግናኖን ፉቶክ አስሲፋታማቶና አሪፌንዋ። አሱኒ ድጋክ ዛግፋታ ዉዛ ኣፋ። አሱኒን ደይ ኣነ ኮርፌ። ");
INSERT INTO jnje_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ኤሴ እኖክ ማኬቦ፤ ኔክ አዉ ስንና ቤስቴፋሶ? ቄሳርንክ ግርቦኒ ግርቦስ ሾልሱጝዋ ወደይ ሾልሱታንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","የሱስ ባሶ ማንጉሶን አሪፋት፦ «ስኖይ ስንነ ቤስቴሴፌ ንቶ፥ አዉኒሮን ታን ፋታነፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ግርቦ ካስቴፋ ብሪሶን ታክ ቤስቤትሶ!» ይ። ባሶ ደይ እሳ ዲናሪ ቴሸሬ ቤስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ባር ደይ፦ «ሀን ባርስታ ፋ ግቶሴዋ ባርስታክ ፋ ትቻሴ ኦንሪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ባሶ ዎልግሬ፦ «ኬሳርኒርዋ» ይሴቴ። ባር ደይ፦ «ኤሴ ኬሳርኒሶን ኬሳርኒክ ሀኦሲሮን ደይ ሀኦሲክ እምትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ባሶ ደይ ኤስ ባሮን ኦደሴቴይሴ ዎሉምባሲክ ዲንቀሴፋት ባሪን ቤየሬ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ኤስ ዎኖ፦ «ክቱኒ ካቡ ኣፋ» ይሴፌ ሴዱካውን ሜያ የሱስኒኪ ዬሴሬ ኤካ ይት ማሙሴቴ፦ ");
INSERT INTO jnje_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«አስሲኛኖ! ሙሴ፦ ‹እሳ አሱ ናዉባ ኮኑኖይ ክትፋናነ አይባስ ኤስ አሱሶን ኤጴ ኤስ ክት አይባሲክ ዛልባ ፉኦዎዋ› ይዋ። ");
INSERT INTO jnje_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ናፉን አይና አይና እኖክ ፌሴቴር። ባሶስን አሪክስ አሱ ኤጳት ናዋ ኮኑኖይ ክቲ። ኤስ ባሪ ቦርኣ አቴ አይባስ ኤስ አሱሶን ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ኤሲስማቶ ደይ ሄፕሳስ ኬዝሳስ ሀማ ናፉንሳ ካርአናኔን ኤስ አሱሶን ኤጳት ክትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ዙታምቤሲሴ ክትሴቴኔን ኦርፎ ደይ አሱስ ክቲ። ");
INSERT INTO jnje_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ኤሴ ናፉኖቤሲሴ አሱሶን ኤጴቴዋ፥ ክቱኒ ካቡኒ ዎኖ ናፉኒሳስን ኣፌርኪንሶ አሱ ስናናሪ?» ");
INSERT INTO jnje_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","የሱስ ዎልግሬ፦ «ኮርቶ ማፃፋሲክቶኖንናዋ ሀኦሲ ሁግናኖንና ኣነ አሪፌት ስንና ቦርአ ዳጌሴፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ክቱኒ ካብሴፌ ካባሲክ አሱኒ ሜያ ሳማኪ ፋሴ ሀኦሲ ዎስያነ ፌርቱ ስኖነታኖ አሱ ኣፋ ኤጶሶነ ዉዛ ደይ ኣፋ ግሩሶነ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ስኑንታኖ ክቱኒ ካቡኒ ቾዋሲክ ሀኦስ ንቶክ ማኬና ባሮን ኣነ ፌሬቱዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ኤካቱ ይዋ፦ ‹ታ አብራሀምኒ ሀኦ፥ እሳቅኒ ሀኦ፥ ያቆብኒ ሀኦዋ› ኤስ ባሪ ቦርኣ ባር ሀየዉኒ ሜኒ ሀኦታኖ ክቱኒ ሜኒ ሀኦታዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ዳራስ ደይ ኤስ ባሮን ኦደሴሬ አሱባሲክ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","የሱስ ሴዱቃዊኒ ሜያኖን ማክሶነ ዉዛ ቱሩክስሬ ሻኩሶነክ ዛግናማቶ ፌርሳዊኒ ሜያ ኦደሴቴይሴ እሳሪክ ዙቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ባሶስን እሳ ሙሴኒ ቱማሲ አሩ የሱስኒን ፋታኖክ ሾሌፋት ኤካ ይት ማምሲ፦ ");
INSERT INTO jnje_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«አስሲኛኖ! ቱማስን ኣፋ አጃጅስንሶ አርክሪ?» ");
INSERT INTO jnje_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","የሱስ ባሪክ ዎልግሬ፦ «ዳማ ሀኦኔሶን ቱማ ንብኔሲክ፥ ቱማ ካኔሲክ፥ ቱማ ሳፋራኔሲክ ኬሽቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ዙታምባሴ አሲስታን ደናሎነዋ ቴሱኒ አጃጂሴ ኤሲስዋ። ");
INSERT INTO jnje_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ኤሲስንነ ፋ ሄፕሳኒስ ደይ፦ ‹አሱሲን ነ ኔን ኬሽቴፋታሲማቶ ኬሽቶዋ› ይፋ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ቱማሲ አሱነዋ ራጁኒ ሜኒ አሱሴ ኤስ ሄፕ አጃጂስታቱ ካፑቴራ ዛጊዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ፌርሳዊኒ ሜያ ዙቴሴሬ ፌሴቴን የሱስ ኤካ ይት ማምሲ፦ ");
INSERT INTO jnje_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«ክርስቶስኒ ቾዋስ ንቶክ አዉ ስንና ቤስቴፋሶ? ባር ኦኒ ናንሶ?» ባሶ ደይ ዎልግሬ፦ «ዳዊትኒ ናዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","የሱስ ኤካ ይ፦ «ኤኪን ዳዊት ሀኦኒ አያናክ ቱሜ ኣካክ ‹ዳምታ› ይሬ ቴጌሶ? ");
INSERT INTO jnje_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","« ‹ሀኦስ፥ ዳምታስን፤ ጉማኔስን ዎቾኔሲ ስካሎሲ የርእአታክ ዛጉናኔን፤ ሆእታ ቴሽናስታ ዱዋ› ይዋ። ");
INSERT INTO jnje_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«ዳዊት ቴትባሲክ፦ ‹ዳምታ› ይሬ ቴጌናኔን ኤኪን ክርስቶስ ኣካክ ናዉባ ስኒሪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ባሶስን እሳ ካማኑ ዎልጉክ ችማር ኦኑ ኣፌ። ኤስ ዎኖኔን ባሪን ማምሱክ ችማር ኦኑ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ኤሴን ኦርፎ የሱስ ዳራሲክናዋ ናዎባሳክቶኒክና ኤካ ይሬ ማኬ፦ ");
INSERT INTO jnje_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«ሙሴኒ ቱማሲ አስሲኛናዋ ፌርሳዊኒ ሜና ሙሴኒ ኮዳስታክ ዲሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ኤስ ባሪ ቦርኣ ባሶ ማክሴፌ ባሮን ዙትራ ዛግሶት ደይ ኦድት። ስኑንታኖ ባሶ ማክሴፌ ባሮን ዎስቶታ ኣነ ፌሽሴፌ ስንና ቦርአ ዎስቴሴፌ ባሮን ዛጉትታ። ");
INSERT INTO jnje_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ፋያ ደይ ዎርአክ ችምቶኖይ ባአ ታርእኤ አሱኒ ኦጎግታ ዎስሴፌ። ስኑንታኖ ባሶ ኩሹቤሲስ ዋአክኑ ታኡክ እሳንነ ኣነ ሾልሴፌ። ");
INSERT INTO jnje_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","አሱ ባሶትን ብያናክቱ ዎስቶቤሲሶን ዎስቴሴፌ። ኩእርአማቤሲሶን ታግሴሬ ሺጶኒ ካባክ ማይቴፋ ማምቤሲስ ፋሻኖን ደይ ድችሴፌ። ");
INSERT INTO jnje_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ኮታ ማስቴፋናስታ ኡልፍንቶ ድማ፥ አይሁድኒ ሺጶኒ ኬያሲክ ደይ ኡልፍንኒ ኮድታ ዱክቱ ሾልሴፌ። ");
INSERT INTO jnje_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ጋባስታክ አሱ ባሶትን ናጋ ኦሾናክናዋ፦ ‹አስሲኛኖ!› ይሬ ቴግሶነክናቱ ሾልሴፌ። ");
INSERT INTO jnje_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ስኑንታኖ ንቶ አስሲኛኒትስ እሳር ስንና ቦርአናዋ ንቶ ዙታምንትሴ ደይ አይና አይና ስንቲ ቦርአና ‹አስሲኛ› ይስቴራ ቴግቶትታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ደን ሳማኪ ፌ አባንቲስ እሳር ስንና ቦርአ ሀን ዳስታኪ ኦኒንኑ፦ ‹ኣባ› ይራ ቴጎትታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ንቶ አርክ አስሲኛኒትስ እሳ ክርስቶስ ስንና ቦርአ ኦኒክኑ ‹አሪክ አስሲኛ› ይስቴራ ቴግቶትታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ንቶስኒ ደናሎ ስና ባር ንቶ ዎስትኛ ስኖዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ቴትባሶን ደን ቴግፌ ባር ዳ ሀቶና። ቴትባሶን ዳ ሀቴሲፌ ባር ደን ቴጉና።» ");
INSERT INTO jnje_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ደይ የሱስ ኤካ ይ፦ «አሱ ሳማኪ ታቶሲ ግሩኖይናማቶ ጋማላሶን ኩልፍፌ ስኖይ ስንነ ቤስቴፌ ሙሴኒ ቱማሲ አስሲኛኒ ሜናዋ ፌርሳዊኒ ሜና ሃቡንቲዋ! ንቶ ቴታሲክ ግሩክ ኣነ ሾሌፌት ደይ ግሩኒ ባሶትን ኣነ ጌድፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«ንቶ ስኖይ ስንነ ቤስቴፌ ሙሴኒ ቱማሲ አስሲኛኒ ሜናዋ ፌርሳዊኒ ሜና ሺጶኒትሶን ድቹክ ድቻ አሱሲክቶኒ ኬያሶን ማራ ቱሩክስፌት ቦርአ ሃይቡንቲዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«ስኖይ ስንነ ቤስቴፌ ሙሴኒ ቱማሲ አስሲኛኒ ሜናዋ ፌርሳዊኒ ሜና ሀይቡንትዋ። እሳ አሱ ንቶ አማንቶሶን ኤጴቶናክ ዛጉክ ባሪስታናዋ እችማ ዳስታክና ብራቴሴፌት። ማእ ይሬ ኤጴቴናኔን ኦርፎ ንቶስታን ደናሎ ሄፕ ኩሹኖን ጌኒ ትርእማሲ ግሩናክ ሆሬር ዛግሴፌት። ");
INSERT INTO jnje_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«ንቶ ኣፍትሹ ዞንሲሶ! ሀይቡንትዋ! ‹አሱ ቤቴሜቅደሲሲክ ቴይፋናነ ኣፋ አጉና ዉዛ› ይፌት። ስኑንታኖ ‹ቤቴሜቅደሲሲክ ፋ ዋርቄሲክ ቴይፋናነ ኤስ ቴያሲክ ኦቴርዋ› ይፌት። ");
INSERT INTO jnje_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ንቶ ጎዋ ደይ ኣፍትሹ፤ ዋርቄስጝዋ ዋርቄሶን ኮርቶ ዛጊ ቤቴሜቅደስኖሶ ዋያይ? ");
INSERT INTO jnje_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ኤሲስማቶ ደይ፦ ‹አሱ ሾኣሲክ ቴይፋናነ ኣፋ አጉና ዉዛ፤ ስኑንታኖ ባርስታ ኩኒ ማኣሲክ ቴይፋናነ ኤስ ቴያሲክ ኦቴርዋ› ይፌት። ");
INSERT INTO jnje_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ንቶ ኣፍትሹ፤ ማኣስጝዋ ማኣሶን ኮርቶ ዛጊ ሾአሲንሶ ዋያይ? ");
INSERT INTO jnje_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ኤስ ባሪ ቦርኣ ሾኣሲክ ቴይፌ ባር ሾኣሲክናዋ ሾኣስታ ኩኒ ማኣሲክናቱ ቴይፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ቤቴሜቅደሲሲክ ቴይፌ ባር ቤቴሜቅደሲሲክናዋ ባርስታ ፋ ዉዛሲክናቱ ቴይፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ሳማሲክ ቴይፌ ባር ሀኦሲ ዝግሙክናዋ ባርስታ ዲፋ ባርኪናቱ ቴይፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«ስኖይ ስንነ ቤስቴፌ ሙሴኒ ቱማሲ አስሲኛኒ ሜናዋ ፌርሳዊኒ ሜና ሃይቡንቲዋ። አዝማቻኪን፥ እንዝላልክንናዋ ኬሙኒክንና አሲሪስን እሳሮን እምፌት። ስኑንታኖ ቱማሲ ፋ እኛ እኛ ዉዛሲክቶኖን ቤይፌት። ኤስ ባርኪቶ ደይ ፉቶኒ ማጝሱኒ ካርአ፥ ፋክያ፥ አማንቶ አሱ ስንነ ቤስቶስዋ። ኤክ ባሮን ቤይኖይ ሀን ባሮን ደይ ዛጉትክ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ንቶ ኣፍትሹ ዞንስኖ! ኡሽፌት ዉዛስን ኮላቾሶን ናላ ክስራ ሀኣት ጋላነ ፋ እኛ ዉዛሶን ኮርፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«ስኖይ ስንነ ቤስቴፌ ሙሴኒ ቱማሲ አስሲኛናዋ ፌርሳዊኒ ሜና የሬፋዉትዋ። ስካሎቤሲስ ቦኦነዋ ትታንነ ቱማ ፌንቱ ቶፎሴዋ ኮራናሴ አሲ ቱካኖን ካይምስፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ነ ኣፍትሹ ፌሪሳዊ! ዜምማ ቶፎሴዋ ኮራናሴ አሲ ስካሎኖን ማስሳ ካይንኑዋ። ኤስታን ጌራካሎባስኔን ካይማ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«ስኖይ ስንነ ቤስቴፌ ሙሴኒ ቱማሲ አስሲኛኒ ሜናዋ ፌርሳዊኒ ሜና ሃይቡንቲዋ። ስካሎቤሲስ ክቱኒ ሜኒ ሜጋክናዋ ኪናክና ቱማ ፌን ጌራካሎቤሲስ ቦሮክ ማትቴራ ኬሽራ ኩኒ ሞጋስንነ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ኤሲስማቶ ንቶ ደይ ጌሮኪ አሱኒክ ኦኮነ ፌር ስንናቱ ቢስቴፌትዋ። ስኑንታኖ ስካሎንትስ ስኖይ ስንነ ቤስቶክናዋ ማጙክና ቱማ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«ስኖይ ስንነ ቤስቴፌ ሙሴኒ ቱማሲ አስሲኛኒ ሜናዋ ፌርሳዊኒ ሜና ሃይቡንቲዋ። ራጁኒ ሜኒ ሞጋሶን ሹአክ ኬርእኤትር፥ ኦኮኒ ሜኒ ሞጋሶን ደይ ኬሽራ ማእሴትር። ");
INSERT INTO jnje_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","« ‹ዜሞቲ አባኒሳ ሜኒ ነያክ እንኖ ፋኒ ስንፋናነ ራጁኒ ሜኒ ሀንናሶን ባሶኔን አነ ስንና ዉኩኒ ካባታዋ› ይፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ኤሴ ራጁኒ ሜያኖን ዎሪ ባሶ ናንጎታ ስንትሶን ንቶ ቴታሲክ ዛላ ማኬትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ኤሴ ንቶ አባሳክቶ ጋትሴቴ ባሮን ንቶ ኮእስትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ንቶ ዛዋ፥ ኡፎኒ ናንጎታ ጌኒ ትርእማሲ ኬኦስን ኣካክ ኤልላ ኬሳክ ችማቴሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ኤስ ባሪ ቦርኣ ታ ራጁኒ ሜያኖን፥ ቴቹምኒ ሜያኖን፥ አስሲኛኒ ሜያኖን ንቶክ ዎሱናዋ። ባሶትን ደይ ዎርሶት፥ ሱታት፥ አይሁድኒ ሺጶኒ ኬያሲክ እቻት። እሳ ካታማስን ኦማ ካታማስ ካብግራ ኮፍኩት። ");
INSERT INTO jnje_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ኤስ ባሪ ቦርኣ ኦኮ ስና አቤልኒ ሀንናስታን ካብራ ቤቴሜቅደሲሲናዋ ማአ እምቴፋና ሾኣሲ ጋነስና ዎርሴቲ ቤራኪያኒ ና ዛካሪያስኒ ሀንናስታ ካርአናኔን ሀን ዳስታክ ዉክቴ ኦኮኒ ሜኒ ሀንናሲክ ኬኦ ንቶስታ ካርኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ፉቶክ ንቶክ ማኬፋውጙዋ፥ ሀን ኬኦስ ዙታምባሴ ሀን ኮንቶስታ ካርኒርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ቱስሬ ደይ የሱስ፦ «የሩሳሌምነ የሩሳሌምነ! ራጁኒ ሜያኖን ዎሪፋ ነ! ኔኪ ዎስቴሬ የ ባሶትን ሹአክ እችፋ ነ! አኮ ናዉባሲክቶኖን ኮሶባሲ ዙትፋናይሲማቶ ታ ደይ ናንጎትኔሲክቶኖን ዙቱናክ አፑና ዎላ ሾሌንሴ! ስኑንታኖ ንቶ ኣኔ ሾሎዌት። ");
INSERT INTO jnje_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ኤሴ ኬንትስ ኦና ስንናቱ ሀቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ንቶክ ማኬፋውጙዋ፥ ‹ዳሚሳ ሱናክ ዬፌ ባር ሱስቶዋ› ኡትኔን ሀንኔን ኤካሎ ታን ኣፋዋ ብያት ዉዛ።» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","የሱስ ቤቴሜቅደስን ኬሴ ሀሚፌን ናዎባሳክቶ ሹአክ ኬቴ ቤቴሜቅደሲሶን ቤሱክ ባርኪ ታእሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ስኑንታኖ የሱስ ዎልግሬ፦ «ሀን ባሮን ዙትራ ቢትዮሶ? ፉቶ ንቶክ ማኬፋውጙዋ፤ ቦክቶኖይ ሹኣስ ሹኣስታ ዲራ ፉእቶኒር ኣፋዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ባር ዳብራዛይትኒ ኩማስታ ዲፌን ናዎባስ ባሶ ባሶ ባርኪ ታእሴሴሬ፦ «እኖክ ማኮዋ፥ ሀን ባር ኣጌንሶ ስናናሪ? ነ ዮሴዋ ሀን ዳሲ ኮእኒ ቤሶነ ኣምባንሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","የሱስ ዎልግሬ፦ «ኦኑ ንቶትን ኤሻናታዋ! ");
INSERT INTO jnje_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ሾዎቤሲስ ‹ታ ክርስቶስዋ!› ይት ታ ሱናሲክ ዮሶነ። ሾዎቤሲስን ደይ ኤሾነ። ");
INSERT INTO jnje_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ኔቦነዋ ኔቦኒ ኦዱነ ኦዶት። ኤስ ባር ደይ ስናናክ ሾልሱ ስንና ቦርአ ድጎቲታ። ስኑንታኖ ኮእባስ ሀንኔጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ዳራስ ዳራሳታ፤ ታቶስ ታቶስታ ካቡና። ማክነዋ ዳኒ ሾርኮነ ሾዎ ድምሲ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ኤስ ባር ዙቴራ ኮጶኒ ሜሮሲ ኬክቶነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ኤስ ካባሲክ አሱኒ ሜያ ንቶ ሻና ኤጳቶትክ ኣትሬ እሞነ ደይ ዎርሶነ። ታ ሱናስ ቦርአ ዳራ ዙታምባሴ አሲ ስና ኦምቴስቴር ስናቲ። ");
INSERT INTO jnje_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ኤስ ካባሲክ ሾዎኒ ሜያ ቱሳእሴሬ ኦርፎ ዎልሶነ። እሳይስ ኦሚስን ኣትሬ እማና። አሱኒ ሜያ ደይ ባሶትና ባሶትና ዋል ኦምቶሶሶነ። ");
INSERT INTO jnje_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ሾዎ ኤሽ ራጁኒ ሜያ ካብሶነ። ሾዎ ሜያኖን ደይ ኤሾነ። ");
INSERT INTO jnje_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ማንጙሲ ኣታሙታን ካቢ ቾዋ ሾዎኒ ሜኒ ኬሽታናስ ኮቾና። ");
INSERT INTO jnje_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ስኑንታኖ ኮእባ ካርአናኔን ችሜ የሬ ባር ፋሩና። ");
INSERT INTO jnje_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ዳራ ዙታምባሴ አሲክ ዛላ ስናናክ ሀኦሲ ታቶኒ ምስራቹኒ ካማስ ዳ ዙታምባሴ አሲስታ ማክቶና። ኤስ ካባሲክቱ ኮእባስ ዮና። ");
INSERT INTO jnje_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«ኤሴ ራጁ ዳንኤልኒክ ማክቴናስማቶ ‹ኪንሱኒ ማጙ ዉዛስ› ኮርቶ ድማስታ የሬፌኒ ቢፌና ካባሲክ ፌሬትፌ ባር ያዳቶዎዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ኤስ ካባሲክ ዩዳክ ፌሴ ባሶ ደን ኣማስኪ ኤሎሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ኬያሲ ቱክታ ፌ ባር ኬያሲ ፋ ዉዛሶን ኤጳናክ ኬሮናታ። ");
INSERT INTO jnje_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ቡሎታ ፌ ባር ማይባሶን ኤጳናክ ኦርፎ ዎሉናታ። ");
INSERT INTO jnje_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ኤስ ካባሲክ ናኔር አሱሲክቶነዋ ታማ ታኒፋ ባርኪቶነ ሀይቡባውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ኤሴ ኤላቲ ዎናስ ዬሹ ወደይ ቤይሳኒ ዎናክ ስኖይናማቶ ሺጵሶቲ። ");
INSERT INTO jnje_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ኤስ ካባሲክ ሀን ዳስ ቴስቴናኔን ካብራ ሀውጙ ካርአ ስኖር ሀንኔን ኤካሎ ደይ እሳንነ ስኖር አካማ ሻና ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ኤስ ዎናሲክቶ ካዉና ሻኪ ስንፋናነ አሻ ማዮስ ዙቴሬ ፉእቶና ካባታዋ። ስኑንታኖ ኮርቴሬ ፌ አሱኒ ሜኒ ቦርአ ኤስ ዎናሲክቶ ካዉናናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«ኤስ ካባሲክ ኦኑ፦ ‹ኤሴ ክርስቶስ ሀንታ ፌር› ወደይ ‹ኤኬስታ ፌር ይፋናነ አማኖቲታዋ› ");
INSERT INTO jnje_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ኤሽኒ ክርስቶስኒ ሜናዋ ኤሽኒ ራጁኒ ሜና ካብሶነ። ባሶክ ችምቴፋናነ ኮርቴሬ ፌሴ ባሶትንኑ ዳግሱክ አካማ አካማ ቢስቴራ አሪቶኖይ ዉዝነዋ ዲንቅነ ቤሶነ። ");
INSERT INTO jnje_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","«ኤሴ ሀን ባሮን ዙትራ ዜምማ ንቶክ ማኬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ኤስ ባሪ ቦርኣ፦ ‹ኢችማ ዳስ ሲቱ ፌዋ› ይሴፋቴነ ኬሳቲታ። ‹ኣቾ ድምሲቱ ፌዋ› ይሴፋቴነ አማኖቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ካዉና ካዉንና አዋኬስናርኪን አዋግርናርኪ ቢስቴፋናስማቶ አሱኒ ናኒ ዮስ ደይ ኤሲስማቶቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ክቱ ዉዛ ፋናስታቱ አሪካሳስ ዙቴፋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«ኤስ ሻናኒ ዎናሲክቶ ኣትናኔን ኦርፎ ጌሬጌሬ አዋስ ታልሞና፤ አሳስ ደይ ቻሬፍባሶን ካላና፤ ባኩራሲክቶ ደይ ሳማስታን ኬሬ ዎቶና፤ ሳማስታክ ሁግናሲክቶ ሾርኮና። ");
INSERT INTO jnje_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ኤስታን አሱኒ ናኒ ቤሶ ሳማስታክ ቤስቶና። ኤስ ካባሲክ ሀን ዳስታክ ፌ ዳራስ ዙቴሬ ዋስሶነ። አሱኒ ና ደይ አካማ ሁግናክናዋ አካማ ኡልፍናክና ሻሩሲክቶታ ዬፌን ብዮሶነ። ");
INSERT INTO jnje_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","አካማ ማርካታኒ ካማ ኦድሱኒ ሀኦሲ ዎስያሲክቶኖን ዎሱና። ባሶ ደይ ሳማሲ ድልታን ሀማ ድልባስታ ካርአ ፋ አቼች ፋሻሲ ሀሜሬ ባሪክ ኮርቴሬ ፌሴ ባሶትን ዙቱሶነ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ቱስሬ ደይ የሱስ፦ «ሀን ቤለስኒ እኦሲ ቤሶታን ቢራ አሩት። ዋእባስ ቦዴራ ቶሻ ኮትፋና ካባሲክ ቤጋኒ አሳ ታባሶን አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ኤሲስማቶ ንቶ ደይ ኤስ ባሮን ዙትራ ብየፌት ካባሲክ ዎናስ ያራ ፍኝሲ ታእናማቶ አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ፉቶ ንቶክ ማኬፋውጙዋ፤ ኤስ ባር ዙቴራ ስናና ካባኔን ሀን ኮንቶስ ኣፋ ኣታና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ሳማሴዋ ዳሴ ኣታና፤ ስኑንታኖ ካምናሲክቶሴን እሳንነ ኣፋ ኣታና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ደይ የሱስ፦ «ኤስ ዎናሴዋ ኤስ ሳአትሴ አሲን አባስቴኖ ሳማኪ ዎስያስኑ ስኑን ናስኑ ስኖ ኦኑ አሪፌር ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ኖህኒ ነያሲክ ስንናስማቶ አሱኒ ናኒ ዮስ ደይ ኤካቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ኤስ ነያሲክ ትሹኒ አካስታን ዜምማ ኖህ ሜርኬቢሲ ግሪና ዎኖኔን አሱኒ ሜያ ሜትናዋ ኡሼትና፤ ኤጴትናዋ ግርትና ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ትሹኒ አካስ ያራ ዙታምቤሲሴ አሲን ትሽኩናኔን ኣነ አሪሶቶ። አሱኒ ናኒ ዮስ ደይ ኤሲስማቶቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ኤስ ካባሲክ ሄፕ አሱኒ ሜያ ቡሎኒ ድምታ አነ ዎስቶሶነ። እሳይስ ኦቶና፤ እሳይስ ፉእቶና። ");
INSERT INTO jnje_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ሄፕ ማሽካሱ እሳ ድምታ ሜያ ንኦና፤ እሳይስ ኦቶና እሳይስ ፉእቶና። ");
INSERT INTO jnje_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ኤሴ ንቶ ዳሚስ አሮ ሳአትታ ዮናማቶ ኣነ አሩዌት ስንና ቦርአ ጉዝራ ኦድት። ");
INSERT INTO jnje_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ስኑንታኖ እሳ ዉዛ አሩትዋ፤ ኬኤንኒ አባስ ዋላሲ ኣፋ ሳአትስታ ዊስ ዮናማቶ አሪ ስንፋናነ ጉዝሬ ኬባስ ደይ ይሽቶኖይናማቶ ካላና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ኤሲስማቶ አሱኒ ና ደይ ንቶ አሩኖይት ሳአትስታ ዮኒር ስንና ቦርአ ሆሬራ ኦድትዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ደይ የሱስ፦ «ሙቤሲሶን ሾልስናስታክ እሞነክ ዳምባስ ኬርኪ ፌ አሱሳታ ታትሲና አማናምቶ ደይ ንብባሬ የሬ ዎስትኛስ ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ዳምባስ ዬፌና ካባሲክ ኤካ ዛግፌን ዳናና ኤስ ዎስትኛስ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ፉቶ ንቶክ ማኬፋውጙዋ፤ ኤስ ዎስትኛስን ፋ ዋግባ ዙታምባሴ አሲስታቱ ታትሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ስኑንታኖ ኤስ ማጙ ዎስትኛስ፦ ‹ዳምታስ ዎኬቱ ዮናዋ› ይት ንብባሲ ሳፋሬፋናነናዋ፥ ");
INSERT INTO jnje_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ዎስቶኒ ዞሞባ ስና ባሶትን እቻክ ካብፋናነና ዛይኒ ሜያኔን አነ ሜሬ ኡሽፋናነ፤ ");
INSERT INTO jnje_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ኤስ ዎስትኛአሳ ዳም ባር አሩኖይና ዎናሲክናዋ ኦድኖይና ሳአትሲክና ዮና። ");
INSERT INTO jnje_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ኤስ ዎስትኛስን ሄፕክ ካላስሬ እጣባሶን ደይ ስኖይ ስንነ ቤስቴሴፌ ባሶኔን አነ ዛጉና። ኤስታክ ዋስነዋ አይእኒ ኮየት ፎነ ስናና» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ቱስሬ ደይ የሱስ፦ «ኤስ ካባሲክ ሳማኪ ታቶስ ቶንቤሲሶን ኤጴሬ ማሪስን ኤጳክ ሆሬራ ኬሳ አሲር ዱርባ ናንጎታነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ባሶስን ኡቺስ ጎዋ፤ ኡቺስ ደይ ቴቹምባ ፋናር። ");
INSERT INTO jnje_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ጎዋሲክቶ ቶንባሶን ኤጴፋናክኑ ኦማ ፉእታና ዛይት ኣነ ኤጶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ቴቹምባ ፋና ባርኪቶ ቶንስኔን አነ ኦማ ዳይቶ ዛይቲ ኤጴሴ። ");
INSERT INTO jnje_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ማሪስ ዎክባሴ ዙቴሬ አፋእይ ኤጳን ኩነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«ዋሲ ዳኒ ኪጤ ስንፋና ካባሲክ፦ ‹ኤሴ ማሪስ የ ኬሳ ኤጶቲ› ይፋ ዎሞ ኦድቴ። ");
INSERT INTO jnje_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ኤስ ካባሲክ ኤስ ዱርባ ናንጎታሲክቶ ዙቴራ ካቢ ቶንባሶን ሆስሴ። ");
INSERT INTO jnje_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ጎዋ ዱርባ ናንጎታሲክቶ ቴቹምባ ፋና ባሪክቶኪ፦ ‹እንኖ ቶናስ ትሹኒር ስንና ቦርአ ንቶ ዛይትስታን እኖክ እሞትዌ› ይሴ። ");
INSERT INTO jnje_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ስኑንታኖ ቴቹምባ ፋና ዱርባ ናንጎታስ ዎልግራ፦ ‹ንቶክናዋ እኖክና ሆሮኒ ዛይት እኖኪክ ኣፋ፤ ኤክ ሀማ ዋግቴፋና ኬያስን ንቶሮን ዋግሶት› ይሴ። ");
INSERT INTO jnje_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ጎዋ ዱርባ ናንጎታስ ዋጎናክ ሀሜፋና ካባሲክ ማሪስ የ። ሆሬራ ፋ ዱርባ ናንጎታስ ማሪስኔን አነ ሳርግሲ ኮታ ፋናስታ ግርሴቴ፤ ጋማላስ ደይ ኩሉፍቴ። ");
INSERT INTO jnje_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«ኦርፎ ደይ ፉእቴ ዱርባ ናንጎታሲክቶ ያሴራ፦ ‹ዳሚሶ! ዳሚሶ! እኖክ ጋቻይዋ› ይሴ። ");
INSERT INTO jnje_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ስኑንታኖ ባር ዎልግሬ፦ ‹ፉቶ ንቶክ ማኬፋዉግዌ፤ ታ ንቶትን ኣነ አሪፋትዌ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ኤሴ ዎናሴዋ ሳአቲሴ ኣነ አሪፌት ስንና ቦርአ ጉዝራ ኦድት።» ");
INSERT INTO jnje_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ቱስሬ ደይ የሱስ ኦማ ቤሶ ማኬ፦ «ሳማኪ ታቶሲ ግሩኒ ቾዋስ ኤካቱ ስናናዋ፤ ኦማ ዳ ሀማናክ ኬሳ እሳ አሱ ዎስትኛባሳክቶኒን ቴጌሬ ፋ ዋግባሶን እምናይስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ኤስ ዳሚስ እሳ እሳርቤሲሲክ ሁግናባሲማቶ እሳይሲክ ኡች መኪልቲ፤ ሄፕሳሲክ ሄፕ መኪልቲ፥ ኬዝሳሲክ እሳ መኪልቲ እማት ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ኡች መኪልቲ ኤጳ ባር ሀምሜ ናጋደሬ ኦማ ኡች መኪልቲ ቡእስ። ");
INSERT INTO jnje_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ኤሲስማቶ ሄፕ መኪልቲ ኤጳ ባር ሀምሜ ናጋደሬ ኦማ ሄፕ መኪልቲ ቡእስ። ");
INSERT INTO jnje_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ስኑንታኖ እሳ መኪልቲ ኤጳ ባር ዳምባሳ ዋጋኖን ታምሜ ዳሶን ዪሸ ዪቲ። ");
INSERT INTO jnje_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ሾዎ ዎናኔን ኦርፎ ኤስ ዎስትኛአሳክቶኒ ዳም ዬሬ ባሶኔን አነ ዋግባሶን ፋዱ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ኡች መኪልቲ ኤጳ ባር ዬሬ ኦማ ኡች መኪልቲ ቡእስሬ፦ ‹ዳሚሶ! ነ ታክ ኡች መኪልቲቱ እምትዋ፤ ኤሴ ታ ኦማ ኡች መኪልቲ ቡእስጝዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ዳምባስ ደይ፦ ‹ነ ማአሪ ደይ አማናምቶ ዎስትኛዋ፤ ጋሮ ኪስኩ ዉዛሲክ አማናምቶ ስኒት ስንታ ቦርአ ታ አካማ ዉዛስታ ኔን ታትሱናዋ፤ ሀጝ ያራ ዳምኔሳ ግራሲ ግሩዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ሄፕ መኪልቲ ኤጳ ባር ደይ ታእሴሬ፦ ‹ዳሚሶ ሄፕ መኪልቲቱ ታክ እምትዋ፤ ኤሴ ደይ ኦማ ሄፕ መኪልቲ ቡእስጝዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ዳምባስ ደይ፦ ‹ነ ማአሪ ደይ አማናምቶ ዎስትኛ፤ ጋሮ ኪስኩ ዉዛሲክ አማናምቶ ስንታ ቦርአ ታ አካማ ዉዛስታቱ ኔን ታትሱናዋ። ያራ ዳምኔሳ ግራሲ ግሩዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","እሳ መኪልቲ ኤጳ ባር ታእሴሬ፦ ‹ዳሚሶ ቡክኖይታ ድማስታን ካርእታር፤ ስኮኖይታ ድማስታን ዙትታር፤ ነ ኬና ቡዱ አሱ ስኔሶን አሪጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ኤስ ባሪ ቦርኣ ድጌፋቱ ሀማ ደይ ዋግኔሶን ዳሶን ዪሻ ዪትጝዋ። ኤሴዋ፤ ዋግኔስ ሀኒፋዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ዳምባስ ደይ ዎልግሬ፦ ‹ነ ማጙ ደይ አዉጃ ዎስትኛዋ፤ ታ ቡክኖይና ድማስታን ካርእናር፤ ስኮኖይና ድማስታን ዙትናር ስንናሶን አሪታር ስንናኔን፤ ");
INSERT INTO jnje_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ኤሴ ዋግናሶን ናጋደሬ ቡእሱኒ ባሶክ እምት ስንፋናነ ማአር ስናና ካባዋ፤ ኤስታን ታ ደይ ያራ መኪልቲናሶን ቡእባስኔን አኔ ኤጳና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ኤሴ ዋግናሶን ባሳ ኩሹስን ኤጳ አሲር መኪልቲ ፋና ባሪክ እምትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ፋና ባሪክ ዳይስቶና ደይ አርኩና፤ ስኑንታኖ ጋሮ ኪስኩ ፋና ባርኪን ኤስ ፋ ባርኑ ባሳስታን ኦቶና። ");
INSERT INTO jnje_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ሀን ኬእኖይ ዎስትኛስን ኤክ ጌሮ ፋ ታልማሲ ክስራ ሀኡትዋ፤ ኤስታክ ዋስነዋ አይእኒ ኮይነ ስናና› ይ። ");
INSERT INTO jnje_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«አሱኒ ና ሀኦሲ ዎስያ ዙታምባሴኔን አነ ኡልፍንባሲክ ዬፌና ካባሲክ ኡልፍንኒ ዝግሙባስታ ዱና። ");
INSERT INTO jnje_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ዳራ ዙቴሬ ባርኪ ስና ዙቶሶነ። ኬሜሪስ ፋንቱሶን ፍዞስን ኮርፌናሲማቶ ባር ደይ ዳራስን ባሶትና ባሶትና አሲን ኮሩና። ");
INSERT INTO jnje_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ፋንቱሲክቶኖን ሆእታ ቴሽባስታ ፍዞሲክቶኖን ደይ አልዳ ቴሽባስታ ዬቱና። ");
INSERT INTO jnje_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ኤስታን ታቶስ ደይ ሆእትባስታ የሬ ባሶክ ኤካ ኡና፦ ‹አባታስ ሱስና ንቶ ዮትዋ። ሀን ዳስ ቴስቴናኔን ካብራ ንቶክ ሆሬራ ፋ፤ ታቶሶን ኤጳቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ማክቴና ማስቲ፤ እክቴና ኡሽቲ፤ እርባ ስንና ንቶኪ ያና እርባስቲ። ");
INSERT INTO jnje_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","አታቱ ኩትና ማይስቲ፤ ሜትቴና ማምሲቲ፤ ታቴና ያራ ማምሲቲ።› ");
INSERT INTO jnje_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ኦኮኒ ሜያ ደይ ዎልግሬ ኤካ ኡሶነ፦ ‹ዳሚሶ ነ ማክቴን ቢራ ኣጌ ማስኒሶ? ወደይ እክቴን ቢራ ኣጌ ኡሽንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","እርባ ስንና ዬን ኣጌ ኔን እርባስኒሶ? ወደይ አታቱ ኩትፌን ቢራ ኣጌ ኔን ማይስኒሶ? ");
INSERT INTO jnje_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ሜትቴን ወደይ ታቴን ኣጌ ኔኪ ያራ ማምሲኒሶ?› ");
INSERT INTO jnje_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ታቶስ ደይ ዎልግሬ፦ ‹ፉቶክ ንቶክ ማኬፋውጙዋ፤ ዙታምቤሲሴ አሲስታን አቴር ስና ሀን አይታሳክቶኒስን እሳይሲክ ዛግቲ ባር ታክቱ ዛግትዋ› ኡና። ");
INSERT INTO jnje_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ኤስታን አልዳ ቴሻስታ የርሴ ባሶክ ደይ ኤካ ኡና፦ ‹ንቶ ኤርዉቶ፤ ዳቡሎስኒክናዋ ዎስባሲክቶክና ሆሬ ኮእባ ፎንቶ ጌያሲ ሀንታን ሀሚትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ማክቴና ኣነ ማሱዌቲ፤ እክቴና ኣነ ኡሹዌቲ። ");
INSERT INTO jnje_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","እርባ ስንና ያና ኣነ እርባሱዌቲ፤ አቱ አቱ ኩትና ኣነ ማይሱዌቲ፤ ሜትቴና ደይ ታቴና ኣነ ማምሱዌቲ› ");
INSERT INTO jnje_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ባሶ ደይ ዎሉግሴሬ፦ ‹ዳሚሶ ማክቴን ወደይ እክቴን፤ እርባ ስንና ዬን ወደይ አታቱ ስንና ኩትፌን፤ ሜትቴን ወደይ ታቴን ቢራ ኣጌ አሪጋሱ ቤይንሶ?› ኡሶነ። ");
INSERT INTO jnje_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ታቶስ ደይ፦ ‹ፉቶ ንቶክ ማኬፋውጙዋ፤ ዙታምቤሲሴ አሲስታን አቴር ስና ሀን አይታሳክቶኒስን እሳይሲክ ዛጉ ቤይት ባር ታክ ዛጉ ቤይትማቶዋ› ይሬ ዎልጉና። ");
INSERT INTO jnje_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ኤስ ባሪ ቦርኣ ኤስ ባሶ ኮእባ ፎንቶ ኬኦኒ ኬር ሀሞነ፤ ስኑንታኖ ኦኮኒ ሜያ ደይ ኮእባ ፎንቶ ካኒ ኬር ሀሞነ።» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","የሱስ ኤስ ካማሶን ዙትሬ ማኬሬ ኮእስይናሴ ናዎባሳክቶኒክ፦ ");
INSERT INTO jnje_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«ሄፕ ዎናኔን ኦርፎ ፋስካኒ ሄቦስ ስናናማቶ አሪድፌት። አሱኒ ና ደይ ሱቶናክ አቴሬ እምቶኒርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ኤስ ካባሲክ ማግኒ ጋኝኜ ሜናዋ ዳራሳ ኩርኡኒ ሜና ኬያፋ ይስቴፌ ማግኒ ጋኝኜ ሜኒ ጋኝኛአሳ ኦጅኒ ኬርካሎ ዙቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ኤስታክ ደይ የሱስኒን ኣቾ ኡግናክ ኤጶነክናዋ ዎርሶነክና ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ስኑንታኖ፦ «ዳራሳ ጋነሲ ናጋ ትሹና ቦርአ ሄቦኒ ዎናሲክ ኣፋ ስናናዉዛ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","የሱስ ዜሞ ስናክ አዋታቶኒ ሜታን ስና ብታኒያኪ ስሞንኒ ኬርቱ ፌ። ");
INSERT INTO jnje_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ኤስታክ ሙ ሙናክ ታእሴሬ ፌን እሳ ማሽካሱ ዋግባ አካማ ችማ ሽቶ አልባስትሮስ ይስቴ ብልቃድሲ ቱማኖን ኤጳ ባርኪ ያራ ቴትባስታ ዉክ። ");
INSERT INTO jnje_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ናዎባሳክቶ ኤስ ባሮን ቢሬ ሃሬሴፋት፦ «ሀን ሽቶስ አዉኒ ቦርአ ባክ ኬእኖር ስኒሶ? ");
INSERT INTO jnje_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ሀማ አካማ ዋግሲ ዋግቴራ ቱካምኒ ሜያክ እምቶና ካባዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","የሱስ ኤስ ባሮን አሪፋት ኤካ ይ፦ «ባር ታክ ማአ ዉዛቱ ዛጊዋ። አሱሶን አዉኒሮን ሆፕስድፌትሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ቱካምኒ ሜያ ዎንና ዎንና ንቶኔን አነቱ ፎሶነዋ። ስኑንታኖ ታ ዎንና ዎንና ንቶኔን አነ ኣፋዋ ፎና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ባር ሀን ሽቶሶን አቱናስታ ዉክናስ ታ ሞግሲ ካባርቶናክ ሆሱክዋ። ");
INSERT INTO jnje_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ፉቶ ንቶክ ማኬፋውጙዋ፤ አይታክኑ ስኑን ሀን ምስራቹኒ ካማስ ዳ ዙታምባሴ አሲስታክ ማክቴፋና ካባሲክ ባር ታክ ዛግና ባር ደይ ባሮን ሳፋሮኒር ስንና ማክቴቱ ፎናዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ኤስ ካባሲክ አሲኮሮትኪ ዩዳ ይስቴፌ አሲሬ ሄፔ ናዎባሳስን እሳይስ ማግኒ ጋኝኜ ሜያኪ ሀምሜ፦ ");
INSERT INTO jnje_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","«ታ የሱስኒን ኣትራ ንቶክ እማናዋ አዉ ታክ እማትሪንሶ?» ይ። ባሶ ደይ ኬዛስር ሹእኒ ብር እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ኤስ ሳአትስታን ካብሬ ኣትሬ እማና ማአ ኡግና ሾሌት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ኪጣ ማስቴፋና ሄቦሲ ቴሱኒ ዎኖ ናዎባሳክቶ የሱስኒኪ ታእሴሴሬ፦ «ፋስካኒ ሄቦሲ ሜታኡኖን ሙታክ አይ ሆሱኒክ ሾሌፋትሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ባር ደይ፦ «ኤክ ካታማሲ ሀሜፌቲ ካባሲክ ዳናቲ አሱሳ ኬር ሀምፋት፦ ‹አስሲኛስ፦ ሳአትናስ ያራ ካርእ፤ ናዎታሳክቶኔን አነ ፋስካኒ ሄቦስ ሜታኡኖን ኔኪ ኬርቱ ዛጉናዋ ይፌዋ› ኡትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ናዎባሳክቶ ደይ የሱስ አጃጀናስማቶ ዛግሴቴ። ፋስካኒ ሄቦሲ ሜታኡኖን ደይ ሆስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ዋልፋና ካባሲክ የሱስ አሲሬ ሄፔ ናዎባሳክቶኔን አነ ሙክ ዲሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ሜሴፌን የሱስ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፥ ንቶስን እሳይስ ታን ኣትሬ እምኒርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","እሳ እሳርቤሲስ አካማኖን ሱሜሴሬ፦ «ዳሚሶ፤ ታዋ እያቶሶ?» ይሴት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","የሱስ ዎልግሬ፦ «ታኔን አነ ኮራናሲ ዱክፌ ባርቱ ታን ኣትሬ እምኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","አሱኒ ና ባሪክ ትቼናስማቶ ኪቱክ ሀሚኒርዋ። ስኑንታኖ አሱኒ ናኒን ኣትሬ እምኒ ባር ሀይቡባዎዋ። ኤስ አሱስ ኮንቶ ሻኪ ስንፋናነ ባሪክ ዋያዋ» ");
INSERT INTO jnje_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ኣትሬ እምኒ ዩዳ ደይ ዎልግሬ፦ «አስሲኛኖ፤ ታዋ እያቶሶ?» ይ። የሱስ ደይ፦ «ነ ማኬታሲማቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ሜሴፌን የሱስ ቱሻሶን ኤጴ ጋላቴፋት ባትቴ ናዎባሳክቶኒክ፦ «ኤሴዋ፥ ሙትዋ፤ ሀኒስ አሽናስዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ቶፎሶን ደይ ኤጴ ጋላቴፋት፦ «ዙታምኒትሴ ሀን ቶፎስን ኡሽትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ሀኒስ ሾዎ አሱኒ ሜኒ ቦርኣስ ፌሹን ኡስቶናክ ዉክቶኒ ጋድዶ ቴያሲ ሀሪንናስዋ። ");
INSERT INTO jnje_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ስኑንታኖ ንቶክ ማኬፋውጙዋ፤ አባታሳ ታቶሲ ንቶኔን አነ ሀን ጋድዶ ዋይኒን ጋናሲ ኡሻኖን ኡሻናኔን ሀውጙኔን ኤካሎ ሄፕሳ ኣፋዋ ኡሻናዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ጋማ ጋሜቴኔን ኦርፎ ደን ዳብራዛይትኒ ኩማስታ ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ኤስታን የሱስ፦ « ‹ኬሜሪስን እቻና፤ ፋንቱሲ ዎዶ ደይ ሲክቶና› ይስቴራ ትቼራ ፋር ስንና ቦርአ ሀውጙት ዋላሲክ ዙታምኒትሴ ታን ሞርሞትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ስኑንታኖ ክቱኒ ካብናኔን ኦርፎ ንቶስታን ዜምማ ጋሊላ ሀማና» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ጴጥሮስ ዎልግሬ፦ «ኦሚስ ዙቴሬ ኔን ሞርሜሴፌክኑ ታ ኔን ኣፋ ሞርሞና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","የሱስ፦ «ፉቶ ኔክ ማኬፋውጙዋ፤ ሀውጙት ዋላሲክ አኮ ኦሩኖይፌን፤ ኬዛ ዎላ ታን ሞርሞታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ስኑንታኖ ጴጥሮስ ደይ፦ «ነኔን አነ ክቱ ሾልስፋናኔኑ እሳንነ ኣፋዋ ኔን ሞርሞና ዉዛ» ይ። ኦም ናዎባሳክቶ ደይ ኤሲስማቶ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ኤስታን የሱስ ናዎባሳክቶኔን ጌቴሴማኒ ይስቴፋ ድማስታ ሀምሚ። ኤስታክ ናዎባሳክቶኒን፦ «ታ ኤክ ሀማ ሺጶናር ስንና ቦርአ ንቶ ሀንታ ፎትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","የሱስ ጴጥሮስናዋ ሄፕ ዛብደዎስኒ ናንጎትስና ዞንስሬ ሀምሚ። ትርእኦ ባሪን ኤጳን ሱሞ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ኤካ ደይ ይ፦ «ካናስ ክቱታ ካርአናኔን አካማኖን ሱሜዋ። ንቶ ሀንታ ፋፋት ታኔን አነ ችምትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ባሶስታን ጋሮኖን ኤክሴፋት ካአእነሬ ኤካ ይት ሺጴ፦ «አባታሶ፤ ችምቴፋናነ ሀን ሻናኒ ቶፎስ ታይስታን ኣቱጝዋ። ስኑንታኖ ነ ሹንታማቶ ስናናስታኖ ታ ሹንናማቶታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ኤስ ኬዝ ናዎባሳክቶኒክ ዎል ሌ ዬሬ ኩነፌን ዳኒ። ጴጥሮስኒን፦ «ታኔን አነ እሳ ሳአትነ ጉዙክ ኣነ ችሜትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ፋታናሲ ግሩኖይትማቶ ጉዝራ ሺጶትዋ። አያናስ ሆሬራቱ ፋ፥ ስኑንታኖ አሻስ ሆፕያዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ሄፕሳ ደይ ሀምሜ ኤካ ይት ሺጴ፦ «አባታሶ! ሀን ሻናኒ ቶፎሲ ኡሻኖን ኡሽኖይ ፋና ኣታናክ ችምቶኖር ስንፋናነ ነ ሹንታ ባር ስኑጝዋ» ");
INSERT INTO jnje_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ዎል ሌ ዬሬ ካርእን ናዎባሳክቶኒ ኣፋስ አፋይኒክ ፋይፋን ኩነፌን ዳኒ። ");
INSERT INTO jnje_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ደይ ባሶትን ቤየ ሀምሜ ኬዝሳ ኡኮትሲማቶ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ኤስታን ናዎባሳክቶኒክ ዬሬ፦ «ሀሽኔን ካርአ ኩንፌትዮሶ? ደይ ቤይሳ ኤጵትፌትዮሶ? ኤሴ አሱኒ ና ቦርእኒ ሜኒ ኩሹስ አቴሬ እምቶና ሳአትስ ካርእዋ። ");
INSERT INTO jnje_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ካብሴኒ ሀሚንዋ። ታን ኣትሬ እምኒ ባር ታእሴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ኤስ ባሮን ማኬፌን አሲሬ ሄፔ ናዎባሳስን እሳይስ ስና ዩዳ የ። ባርኔን አነ ደይ ሲፎነዋ ሙክነ ኤጶ ሾዎ ዳራ ዬሴቴ። ባሶ ደይ ማግኒ ጋኝኜ ሜያክናዋ ዳራሳ ኩርኡኒ ሜያክና ዎስቴሬ ዬሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ኣትሬ እምኒ ዩዳ፦ «ታ ዳሞና ባሪንቱ ኤጳትዋ» ይሬ ባሶክ ቤሶ እምሜ ፌር። ");
INSERT INTO jnje_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ዩዳ ጌሬጌሬ የሱስኒኪ ታእሴሬ፦ «አስሲኛኖ! ናጋ ኔክ ስንፋውጝዋ» ይት ዳሜ። ");
INSERT INTO jnje_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","የሱስ፦ «ዞሞታሶ! ኤሴ ያታ ቾዋሶን ኮእሱዋ?» ይ። ኤስታን አሱኒ ሜያ የሱስኒኪ ታእሴሴሬ ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ኤስ ካባሲክ የሱስኔን አነ ፌ ባሶስን እሳይስ ኩሹባሶን ሾሬ ሲፎሶን ክስሬ ማግኒ ጋኝኜ ሜኒ ጋኝኛሳ ዎስትኛኒ ኦዶኖን ካጨ። ");
INSERT INTO jnje_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ስኑንታኖ የሱስ ባሪክ ኤካ ይ፦ «ሲፎ ክስፌ ባሶ ዙቴሬ ሲፎክቱ ትሹሶነ ስንና ቦርአ ሲፎኔሶን ዛምባሲ ዎልግራ ጌድዋ። ");
INSERT INTO jnje_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","አባታስን ሺጴፋናነ ባር ሾዎ ኩምሲ ፋድቶኒ ሜያ ታርእኦ ሀኦሲ ዎሲያኖን ዎሱክ ሆፑኒርነ ፋር ስንና ንቶክ ቤስቴፋዎሶ? ");
INSERT INTO jnje_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ኤካ ስናር ስንፋናነ፦ ‹ሻና ኤጴቶናክ ሾልስፋዋ› ይፋ ኮርቶ ማፃፋሲ ካማ ኣካክ ስናናክ ችምኒሪንሶ?» ");
INSERT INTO jnje_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ኤስ ካባሲክ የሱስ ዳራሲክ፦ «ቦእኛኒን ኤጵኒ አሱኒማቶ ሲፎነዋ ሙክነ ኤጳ ታን ኤጳትክ ያትዮሶ? ዎንና ዎንና ቤቴሜቅደሲሲ አሲት ንቶኔን አነ ፋና ካባሲክ ኣነ ታን ኤጴት። ");
INSERT INTO jnje_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ስኑንታኖ ሀን ባር ዙታምባሴ ስንናስ ራጁኒ ሜኒ ማፃፋሲሲ ትቼራ ኩኒ ባር ስናናክዋ» ይ። ኤስ ካባሲክ ናዎባሳክቶ ዙታምቤሲሴ ባሪን ቤየሬ ኤለሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","የሱስኒን ኤጳ አሱኒ ሜያ ማግኒ ጋኝኜ ሜኒ ጋኝኛ ስና ኬያፋንኪ ታሜቴ። ኤስታክ ደይ ሙሴኒ ቱማሲ አስሲኛናዋ ኩርኡኒ ሜና ዙቴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ስኑንታኖ ጴጥሮስ ማግኒ ጋኝኜ ሜኒ ጋኝኛሳ ኦጅኒ ኬርካሎ ካርአናኔን ዎክሶክ ኦርፎባሴ ሀሚ። ስንኒ ቾዋሲ ኮአኖን ብያናክ ኬርካሎ ግሪሬ ታሶኒ ሜያኔን አነ ድ። ");
INSERT INTO jnje_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ማግኒ ጋኝኜ ሜናዋ አይሁድኒ ሾንጎታ ዲሴፌ ባሶትና ዙቴሬ የሱስኒስታ ክቱኒ ማጝሱኒ ካርአ ካቱሶነክ ኤሽ ዛልንን ሾልሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ሾዎ ኤሽ ዛልኒ ሜያ ታእስሴፌክኑ የሱስኒን ክቱታ ካቱኒ ዛላ ኣነ ዳኖቶ። ኮእባስታክ ደይ ሄፕ ዛልኒ ሜያ ታእሴሬ፦ ");
INSERT INTO jnje_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«ሀን አሱስ፦ ‹ቤቴሜቅደሲሶን ቦጋት ኬዝስናሪ ዎኖ ዎልግራ ኬርአናዋ› ይዋ» ይት ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ማግኒ ጋኝኜ ሜኒ ጋኝኛስ ካብሬ፦ «ሀን አሱኒ ሜያ ነይስታ ማክሴፌ ዛላሶን ኣነ ዎልግፌኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ስኑንታኖ የሱስ ሻኪ። ማግኒ ጋኝኜ ሜኒ ጋኝኛስ ደይ፦ «ሀየዋ ሀኦሲ ሱናክ ኔን ቴይስፋዉጝዋ! ነ ሀኦኒ ና ክርስቶስ ስንኔሶን እኖክ ማኮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","የሱስ፦ «ነ ማኬታሲማቶዋ፤ ንቶክ ማኬፋውጙዋ፥ ሀውጙኔን ኤካሎ አሱኒ ና ሁግናባ ፋና ሀኦሲ ሆእትታ ዲፌን ብያትዋ። ኤሲስማቶ ደይ ሳማኪ ሻሩሲክቶታ ዬፌን ብያትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ኤስ ካባሲክ ማግኒ ጋኝኜ ሜኒ ጋኝኛስ ማይባሶን ካራሳት፦ «ሀኦስታ ሜእኒ ካማ ማኬዋ። ንቶኑ ሜእባሶን ኦደትዋ። ሀኒስታን ኦማ ዛላ አዉኒሮን ሾልሱንሪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ኤኪን ንቶክ አዉ ስንና ቤስቴፋሶ? ባሶ ደይ፦ «ክቱቱ ባሪክ ሾልሱዋ» ይት ዎልግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ኤስ ካባሲክ ስኒባ ቱጀሴት፥ ክኤሴት፥ ቦቸሴት፦ ");
INSERT INTO jnje_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«ክርስቶስኖ! ኔን እቻስ ኦንሶ? ራጅ እኖክ ማኬቦ» ይሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ጴጥሮስ ኦጅኒ ኬርካሎ ዲፌን እሳ ኬርኪ ዎስትኛ ባርኪ ታእሴራ፦ «ነ ደይ ጋሊላክ የሱስኔን አነ ፋታርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ስኑንታኖ ጴጥሮስ፦ «ነ ማኬፋታ ባሮን ኣነ አሪፋትዌ» ይት ዙታምቤሲሴ አሲ ስናክ ሞርሜ። ");
INSERT INTO jnje_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ፍኛ ኬስፌን ኦማ ኬርኪ ዎስትኛ ደይ ባሪን ብያት ኤስታ ፌ ባሶክ፦ «ሀን ባር ናዝሬትክ የሱስኔን አነ ፌርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ሄፕሳ ደይ ጴጥሮስ ቴይሬ፦ «ኤስ ማኬፋታ አሱስን ኣነ አሪፋትዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ጋሮ ሳአትኔን ኦርፎ ኤስታ የሬ አሱኒ ሜያ ታእሴሬ ጴጥሮስኒን፦ «ዎሉምኔስ አስሲድፋዋ፥ ፉቶክ ነ ባሶ ጋነያስን እሳይስዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ኤስ ካባሲክ ጴጥሮስ፦ «ታ ኤስ አሱስን ኣነ አሪፋትዋ» ይት ባር ባሪን ዎልግሬ ኤርውክናዋ ቴውክና ካቢ። ኤስታን ጌሬጌሬ አኮ ኦሪ። ");
INSERT INTO jnje_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ጴጥሮስ ደይ፦ «አኮ ኦሩኖይፌን ኬዛ ዎላ ሞርሞታዋ» ይት የሱስ ማኬና ባር ንብባሲ ኬጅፋን፤ ጌራካሎ ኬስሴ ደይ አካማኖን ሱሜሬ ዋሲ። ");
INSERT INTO jnje_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ኤእሶ ዎንሳክ ማግኒ ጋኝኜ ሜናዋ ዳራሳ ኩርኡኒ ሜና ዙቴሬ የሱስኒስታ ክቱኒ ማጝሱኒ ካርአ ካቱሶነክ ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ኤስታን የሱስኒን ታርኤ ኤጴ ታምሜ ሀእስፌ ፕላቶስኒክ ኣትሬ እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","የሱስኒስታ ማጝሱ ካቴናማቶ ኣትሬ እማ ዩዳ ብያት ጋቤ። ኬዛስር ሹኒ ብሪሶን ደይ ማግኒ ጋኝኜ ሜያክናዋ ኩርኡኒ ሜያክና ዎልግሬ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«ካይም አሱስን ክቱክ ኣትሬ እምናሲክ ቦርአ ዎስቴጝዋ» ይ። ስኑንታኖ ባሶ፦ «ኤኪን እኖትን ኣምባ ትርኤ? ነ ግሮዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ዩዳ ደይ ኬዛስር ሹኒ ብሪሶን ቤቴሜቅደሲሲ ታምሜ ሀኣት ሀሜ ጌቴሬ ክቲ። ");
INSERT INTO jnje_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ማግኒ ጋኝኜ ሜያ ኬዛስር ሹኒ ብሪሶን ኤጴሬ፦ «ሀን ባር ሀሪኒ ዋጋ ስንና ቦርአ ቤቴሜቅደሲሲክ እምቴ ዋጋሲ ዎእሱኒክ ሾልሱታዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ኤስታን ሜርኬሴሬ እርባኒ ሞጋ ስናናክ ኮዳ ኦእፌ ባሳ ዳኖን ዋግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ኤስ ባሪ ቦርኣ ኤስ ዳስ ሀሽ ሀውጙኔን ካርአ፦ «ሀሪኒ ዳ» ይስቴራቱ ቴግቴፋ። ");
INSERT INTO jnje_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ኤሲሲክ፦ «እስራኤልኒ ናንጎታሲክቶ ጋማትሴቴ ባሪክ ስንኒ ዋጋ ኬዛስር ሹኒ ብሪሶን ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ዳሚስ ታን አጃጀናስማቶ ኮዳ ኦእፌ ባሳ ዳሲክ ካሴቴ» ይስቴራ ራጁ ኤርምያስኒኪ ካሞ ማክቴ ባር ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","የሱስ ዳ ሀእሲፌ ጵላጦስኒ ስና ታእ። ባር ደይ፦ «ነ አይሁድኒ ታቶኖሶ?» ይት ማምሲ። የሱስ ዎልግሬ፦ «ነ ማኬታሲማቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ማግኒ ሜኒ ጋኝኛክቶናዋ ኩርኡኒ ሜና ባሪን ማላሴፌን እሳ ዉዛነ ኣነ ዎልጉዌ። ");
INSERT INTO jnje_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ኤስታን ፕላቶስ፦ «አፑን ዉዛ ነይስታ ቴሸሬ ማላሴድፌማቶ ኣነ ኦደፌኖሶ?» ");
INSERT INTO jnje_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ዳ ሀእሲፌ ባር አካማኖን ዲንቆናኔን ቴሸሴቴ ማላታሲክ እሳ ካማኑ ኣነ ዎልጉዌ። ");
INSERT INTO jnje_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ዳሶን ሀእሲፌ ባር ፋስካ ፋስካሲክ ዳራስ እሳ ታቶ ኮቶናክ ማምሲናይስማቶ ታቶስ ኮቲን ዶስቴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ኤስ ካባሲክ ማጙባሲክ አርቶ ባርባን ይስቴ ታቶ ፌር። ");
INSERT INTO jnje_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ባሶ ዙቴሬ ፌሴቴን ፕላቶስ፦ «ባርባንንጝዋ ወደይ ክርስቶስ ይስቴ የሱስኒን ኮታናክ ሾሌፌትሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ፕላቶስ ኤካ ይናስ ባሶ ማጙክ ኣትሬ እሞቤሲሶን አሪሬ ፌር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ፕላቶስ ማጝሱኒ ካርኒ ኮዳስታክ ዲፌን ባሳ አሱስ፦ «ሀን አሱሳ ቾዋኖን ዋልን ሚቶክ አካማ ሻና ቢጝዋ። ሀን ካይም አሱሳታ እሳ ዉዛነ ዛጉታታዋ» ይራ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ስኑንታኖ ማግኒ ጋኝኜ ሜናዋ ኩርኡኒ ሜና ባርባን ኮቶናክናዋ የሱስ ዎርቶናክና ማምሱሶነክ ዳራስን ኪትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ዳ ሀእሲፌ ባር ዎልግሬ፦ «ሄፒሳስን ኣፌርን ኮታናክ ሾሌፌትሶ?» ይት ዳራስን ማምሲ። ባሶ ደይ፦ «ባርባንንቱ ኮታታክ ሾሌፌኒዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ፕላቶስ፦ «ኤኪን ክርስቶስ ይስቴፌ የሱስኒን አዉ ዛጉናሪንሶ?» ይ። ዙታምቤሲሴ፦ «ሱቶዎዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ሀእሲፌ ባር፦ «ኣምሶ? ባር ማጝስና ዉዛ ኣምባንሶ?» ይ። ስኑንታኖ ባሶ፦ «ሱቶዎዋ» ይት ቻጋ አሪክስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ፕላቶስ ቢን ናጋ ቱሩክሱኒር ስንባሴ አካ ባሪክ ቴሾሶነክ ዛግሬ ዳራሳ ስና ኩሹባሶን ማሳት፦ «ታ ሀን አሱሳ ሀሪንሲክ ኣፎትዋ። ንቶቱ ማሙስቶኒርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ዳራስ ዙቴሬ፦ «ሀን አሱሳ ሀንና እኖስታናዋ ናንጎትኒስታና ስኑን» ይሬ ዎልግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ኤስ ካባሲክ ባርባኒን ኮቴ ጋፍካት የሱስኒን አላንጋክ እሽሬ ሱቶናክ ኣትሬ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ኤስ ካባሲክ ሀእስፌ ባሳ ሜያ ታርኦሳክቶ የሱስኒን ኤጴ ሀእሲፌ ባሳ ኦጃሲ ኬርካሎ ታሜቴ። ሜያ ታርኦሳክቶኒን ደይ የሱስኒ ብራቶስታ ዙትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ማምባሶን ጋኤፋት ሸአ ማማ ማይስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ሴርእአ ማእሬ ቴትባስታ ጉፍስሴቴ። ሆእታ ኩሹባሲ ሶቦቆኒ ሃሮ ኦትሴፋት ስንባ ካእነሴሬ፦ «አይሁድኒ ታቶኖ! ናጋ ኔክ ስንፋውጝዋ» ይት ካኘሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ቱጀሴት ሃሮሶን ደይ ኩሹባስን ኤጴሬ ቴትባሶን እቸሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ካኘሴቴኔን ኦርፎ ሸአ ማማሶን ጋኤፋት ባሳ ማማሶን ዎልግሬ ማይስሴሬ ሱቶናክ ኤጴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ሀእሲፌ ባሳ ኦጃሲ ኬርካሎን ኬሴፌና ካባሲክ ስሞን ይስቴፌ ቀሬናኪ አሱኒን ዳነሴሬ ሜስቀሊሶን ዎርአናክ ግድስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ኤሴን ኦርፎ ኮትባስ ደይ፦ «ቴትኒ ሜጋ» ይስቴራ ቴግቴፋ ጎልጎታ ካርእኤቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ኤስታክ ትሻ ዎእቶ ዋይንኒ ኡሻ ኡሻናክ እሜቴ። ባር ደይ ቤችሬ ብያት ኡሻናክ ኣኔ ሾሎዌ። ");
INSERT INTO jnje_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ሱቴቴኔን ኦርፎ ማምባስታ እጣ ሀእሴሬ ሃእኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ኤስታ ዲሴፋት ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","«ሀን ባር አይሁድኒ ታቶ የሱስዋ» ይፋ ማላትኒ ትቻ ደን ሜስቀሊሲ ቴታ ዬትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ኤስ ካባሲክ ሄፕ ቦእኛኒን እሳይስን ኦእታ ቴሽባስታ፥ እሳይስን ደይ አልዳ ቴሽባስታ የሱስኔን አነ ሱቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ኤስታ ካሞ ኣትፌ አሱኒ ሜያ ደይ ካሹክ ቴትቤሲሶን ሾርክሴፋፌ ሜኤሴቴ፦ ");
INSERT INTO jnje_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«ቤቴሜቅደሲሶን ቦጋት ኬዝስናሪ ዎኖ ኬርእኒ ነ ኤሴ ቴትኔሶን ፉኦዋ! ሀኦኒ ና ስንፋታነ ሜስቀልስታን ኬሮዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ኤሲስማቶ ደይ ማግኒ ጋኝኜ ሜያ፥ ሙሴኒ ቱማሲ አስሲኛናዋ ኩርኡኒ ሜና እሳሪክ ኤካ ይሴት ካኘት ፌሴቴር፦ ");
INSERT INTO jnje_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«ኦሚስን ፉኤ፥ ስኑንታኖ ቴትባሶን ፉኦክ ኣነ ችሜ። እስራኤልኒ ታቶ ስንፋናነ ሀሽ ሜስቀልስታን ኬሮዎዋ። እንኖ ደይ ባሪክ አማኖኒዋ። ");
INSERT INTO jnje_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ባር ሀኦሲክ አማነዋ። ‹ታ ሀኦኒ ናዋ› ይዋ። ኤሴ ሀኦስ ባሪን ሹናር ስንፋናነ ሀሽ ባሪን ፉኦጝዋ።» ");
INSERT INTO jnje_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ኤሲስማቶ ደይ ባርኔን አነ ሱቴ ቦእኛኒ ሜያ ደይ ሜእኤሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","እሱን ሳአትስታን ካብራ ሀማ እዝግን ሳአት ካርአናኔን ዳ ዙታምባሴ አሲስታ ታልማ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","እዝግን ሳአትስታክ የሱስ፦ «ኤሎሄ! ኤሎሄ! ላማ ሴቤቅታኒ!» ይሬ አካማ ካማክ ቻጊ። ኮትባስ ደይ፦ «ሀኦናሴ! ሀኦናሴ! አዉኒ ቦርአ ታን ቤይሴ» ኡ። ");
INSERT INTO jnje_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ኤስታ የርሴ አሱኒ ሜያ ኦደሴፋት «ሀን ባር ኤልያስኒንቱ ቴጌድፌዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ጌሬጌሬ ባሶስን እሳር ኤልሌ ሴፍኒግ ኤጴቴስሸሬ ሱቃሮ ዋይኒ ቱኒሬ ሶቦቆኒ ሃሮሲ ፋሽታ ዱስሬ ኡሻናክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ስኑንታኖ ኦሚሳክቶ «ቤይትዋ፥ ኤልያስ ዬሬ ባሪን ፉኦባነ ብያኒዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","የሱስ ሄፕሳክ አካማ ካማክ ቻጌ ካባሶን ኣትሬ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ኤስ ካባሲክ ቤቴሜቅደሲሲ ይኑ ደኑን ካብራ ዳ ካርአ ሄፕክ ካራቴ። ዳስ ደይ ሾርኬ። ዳስታኪ ካኦስ ደይ ካላቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ሞጋሲክቶ ደይ ጋቼን ስር ኩንሴ ኮርቶኒ ሜያስን ሾዎኒ ሜያ ክቱን ካብሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ሞጋስን ኬሴሬ የሱስ ክቱን ካብናኔን ኦርፎ ኮርቶ ካታማ የሩሳሌም ግርሴቴ። ኤስታክ ደይ ሾዎ አሱኒ ሜያክ ቤስቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ት ሜያ ታርኦኒ ሜኒ ጋኝኛስናዋ ባርኔን አነ የሱስኒን ኦደት ፌሴ ባሶትና ዳሲ ሾርኮኖናዋ ስና ቾዋሶንና ብየሴቴይሴ አካማኖን ድግሴሬ፦ «ሀን ባር ፉቶክ ሀኦኒ ናዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","የሱስኒን አሪጋሲት ጋሊላን ባሳ ኦርፎሴ ሀማ ሾዎ ማሽካ ሜያ ዎክሶክ የርሴፋት ብየት ኤስታ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ባሶስን ሜግደላዊትኪ ማራሚ፥ ያቆብናዋ ዮሴፍና አሲ እንቶ ማራሚ፥ ዘብደዎስኒ ናንጎቲሳ እንቶ ደይ ኤስታ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ዋልፋና ካባሲክ ዮሴፍ ይስቴ እሳ ኦቱም አሱ አሪማትያስኒ ካታማን የ። ባር ደይ የሱስኒ ናዎ። ");
INSERT INTO jnje_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ኤስ ባር ፕላቶስኒኪ ታእሴሬ የሱስኒ ዱግኖሶን ኤጳናክ ማምሲ። ፕላቶስ ደይ እምቶናክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ዮሴፍ ዱግኖሶን ካይማ ማማክ ዙት። ");
INSERT INTO jnje_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ሹአክ ካቴራ ሆሬራ ኩኒ ዮሴፍኒ ጋድዶ ሞግሲ ታምሜ ካባሬ። ኤስታን ሞጋሲ ኖኖታ እኛ ሹአ ቡካልስሬ ኡካት ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ሜግደላውትኪ ማራሚነዋ ኦማ ማራሚነ ሞጋሲ ስንታ ዲሴፌር። ");
INSERT INTO jnje_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ዎኖትሪክ ቤይሳኒ ዎናሲ ሆሮኔን ኦርፎ ማግኒ ጋኝኜ ሜናዋ ፌርሳዊኒ ሜና እሳሪክ ፕላቶስኒኪ ሀሜሬ ኤካ ይሴቴ፦ ");
INSERT INTO jnje_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«ዳሚሶ! ሀን ኤሽኝኛስ ዜሞ ካክ ፌና ካባሲክ፦ ‹ኬዝስናሪ ዎኖ ክቱን ካቡናርዋ› ይና ባር ንብኒስታ ኬጅዋ። ");
INSERT INTO jnje_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ኤስ ባሪ ቦርኣ ናዎባሳክቶ ዋልን ዬሴሬ ዱግኖሶን ዊሴፋት ዳራሲክ፦ ‹ክቱን ካቢዋ› ኡሶኖይቴማቶ ኬዝ ዎና ካርአናኔን ሞጋሶን ኦዶሶነክ አጃጆዋ። ኤስ ባር ስና ሻካናነ ኦርፎቲ ዳግሱስ ስናትቲስታን አካማኖን ማጙ ስናናዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ፕላቶስ ዎልግሬ፦ «ኦድኒ ሜያ ታርእኦኒ ሜያ ፌሴቴር ስንና ቦርአ ኤጳ ሀምፋት አርፌትማቶ ኦድሱትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ባሶ ደይ ሀሜሬ ሞጋሲ ኖኖኖን ሹአክ ኩልፋት ቱክባስታ ማታማክ እቼ ኦድኒ አሱኒን ኦድስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ቤይሳኒ ዎናስ ኣትናኔን ኦርፎ ቶርባኒስ ቴሱኒ ዎኖ ዎንሳ ሸኡ ፌቴትፋና ካባሲክ ሜግደላውዊትኪ ማራሚነዋ ኦማ ማራሚነ ሞጋሶን ብያክ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ዳሚሳ ዎስያ ደን ሳማን ኬሬና ቦርአ አካማ ዳኒ ሾርኮ ስኒ። ባር ደይ ታእሴራ ሞጋሲ ኡክቴራ ኩንና ሹኣሶን ቡካልሳት ባርስታ ድ። ");
INSERT INTO jnje_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ዳሚሳ ዎስያኒ ግቶ ደይ ካዉናኒማቶ ቻሬት ፋር። ማይባስ ደይ እሮን ሸአኒማቶ ፎሮ። ");
INSERT INTO jnje_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ታሶኒ ሜያ ደይ ዳሚሳ ዎሲያኖን ድጋክ ኮርኪት ክቱነ ፌር ስንነቴ። ");
INSERT INTO jnje_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ስኑንታኖ ዳሚሳ ዎስያ ማሽካ ሜያክ፦ «ንቶ ድጎትታዌ፥ ሱቴ የሱስኒን ሾሌፌትማቶ አሪጝዌ። ");
INSERT INTO jnje_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ባር ሀንታክ ኣፌ፥ ማኬናሲማቶ ክቱን ካቢዌ። ኩንና ድማሶን ሀእኒ ያሴፋት ብዮትዌ። ");
INSERT INTO jnje_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ታፕቴራ ሀምፋት፦ ‹ክቱን ካብዋ፥ ኤክ ጋሊላ ዜምሜ ሀሚንርዋ። ኤስታክ ኡጶትዋ› ይራ ናዎባሳክቶኒክ ማኮትዌ። ኤሴ ታ ንቶክ ማኬን» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ኤስታን ድጋክናዋ አካማ ግራክና ታፕቴሴሬ ሞጋሲ ቴሻን ናዎኒ ሜያክ ማኮክ ኤለሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","የሱስ ኡጉንታክ ባሶክ ኡጰሬ፦ «ናጋ ንቶክ ስንፋውጝዌ» ይ። ባሶ ደይ ባርኪ ታእሴሴሬ ዎቾባሶን ኤጴ ሳጋደሰቴ። ");
INSERT INTO jnje_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ኤስ ካባሲክ የሱስ፦ «ድጎትታዌ! ሀምፋት ጋሊላ ሀሞነክ አይታሳክቶኒክ ማክሶትዌ። ኤስታክ ታን ብዮሶነዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ማሽካ ሜያ ሀሜፌን ሜያ ታርእኦኒ ሜያስን እሳ እሳይስ ካታማሲ ሀሜሬ ስና ቾዋሶን ዙትሬ ማግኒ ጋኝኜ ሜያክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ማግኒ ጋኝኜ ሜያ ኩርኡኒ ሜያኔን ዙቴሬ ሜርኬሴቴኔን ኦርፎ ሜያ ታርኦሳክቶኒክ አካማ ዋጋ እሜፋት ኤካ ይሴቴ፦ ");
INSERT INTO jnje_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","« ‹እንኖ ኩንፌኒ ዋስሲ ናዎባሳክቶ ዬሴሬ ዱግኖሶን ዊስሴቴዋ› ይራ ዳራሲክ ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ሀን ቾዋሶን ሀእሲፌ ባር ኦደፋናነ እንኖ ባሪክ ማእስራ ማኮኒ። ደይ ራክኮ ንቶስታ ካርኖይናማቶ ዛጉኒዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ሜያ ታርኦሳክቶ ዋጋሶን ኤጴፋት ባሶክ ማክቴናስማቶ ዛግሴቴ። ኤስ ቾዋሲ ደይ ሀውጙኔን ካርአ አይሁድኒ ሜኒ ጋነያሲ ማክቴቱ ፋፋ። ");
INSERT INTO jnje_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","አሲሬ እስሴ ናዎባሳክቶ የሱስ ሀሞነክ ማኬን ጋሊላክ ፋ ኣማስታ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","የሱስኒን ብየቴይሴ ባሪክ ሳጋደሰቴቴ። ስኑንታኖ ባሶስን እሳ እሳይስ «ሀን ዉዛስ ፉቶታ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","የሱስ ባሶኪ ታእሴሬ፦ «ሳማክናዋ ሀን ዳስታክና ሀእሱኒ ሁግና ዙቴራ ታክ እምቴዋ፤ ");
INSERT INTO jnje_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ኤሴ ሀምፋት ሀን ዳስታክ ፌ ዳራስን ዙትራ አባ፥ ና፥ ኮርቶ አያናሲ ሱናክ ሀጵቅራ ታ ናዎ ዛጉት፤ ");
INSERT INTO jnje_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ታ ንቶክ አጃጀና ባሮን ዙትሬ ዛግሶነክ አስሱቲ። ታ ሀን ዳሲ ኮአ ካርአናኔን ዎንና ዎንና ንቶኔን አነቱ ፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ሀኒስ ሀኦኒ ና ስና የሱስ ክርስቶስኒ ቾዋሶን ማኬፋ ምስራቹኒ ካማሲ ቴሱዋ። ");
INSERT INTO jnje_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ራጁ ስና ኢሳያስኒ ማፃፋስሲ፦ «ኡጉኔሶን ሳብሱኒ ዎስታርን፤ ነ ስናስታ ዜምማ ዎሱናዋ» ");
INSERT INTO jnje_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ደይ፦ « ‹ዳሚሳ ኡግናኖን ሆሱት፤ ሳብስራ ደይ ማእሱት› ይት፤ ኢችማ ዳስ ሲ ቻግፌ አሱኒ ካማ።» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ኤስ ባሪ ቦርኣ ሀጵቅፌ ዮሀኒስ ኢችማ ዳስ ሲ፦ «ቦርኒትስ ፌሹን ኡስቶናክ ሀርምራ ሀጱቅቶት» ይት ማኬት የ። ");
INSERT INTO jnje_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ዩዳኒ ዳስታክናዋ የሩሳሌምኒ ካታማስና ዙቴሬ አካም ሾዎ አሱኒ ሜያ ዮሀኒስኒኪ ዬሴሬ ቦርቤሲሶን ሀርምፋፌ ዮርዳኖስኒ አካስሲ ባሪክ ሀጱክቴሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ሀጵቅፌ ዮሀኒስኒ ማማስ ደይ ጋላኒ ኤሳክ ውቾኖንቱ ማይፌ። ጌሾባሶን ደይ ታልፋክቱ ታርኤፌ። ሙባስ ደይ ብልጛነዋ ዛቦኒ ኤስስነ። ");
INSERT INTO jnje_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","አሱኒ ሜያክ፦ «ታ ሙግራ ቻኣማባሲ ታርአኖን ኮታክ ሾልሱኖይናር ታይስታን አካማኖን ኡልፍንቶ ታ ኦርፎስታ ዮኒር። ");
INSERT INTO jnje_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ታ ንቶትን አካክቱ ሀጵቁና። ስኑንታኖ ባር ኮርቶ አያናክቱ ንቶትን ሀጵቁና» ይት ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ኤስ ካባሲክ የሱስ ጋሊላኪ ዳስታ ፋ፤ ካታማ ናዝሬቱን ዬሬ ዮርዳኖስኪኪ አካስሲ ዮሀኒስኒክ ሀጱክቴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ጌሬጌሬ የሱስ አካስን ኬስፌና ካባሲክ ሳማስ ጋቼፌንናዋ ሀኦኒ አያና ናካሎኒማቶ ስንና ባሳስታ ኬሬፌንና ቢ። ");
INSERT INTO jnje_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ኤስ ካባሲክ፦ «ሹንፋና ናታ ነዋ። ኔክቱ ታ ግሬፋውጙዋ» ይፋ ካማ ደን ሳማን ኦድቴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ጌሬጌሬ ኮርቶ አያና ባሪን ኢችማ ዳስ ሲ ታሚ። ");
INSERT INTO jnje_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ኢችማ ዳስ ሲ ሴጣናክ ፋታንቴት አቼቻስር ዎና ድ። ቡርኡኒ ጎኞኔንቱ ፌ። ሀኦኒ ዎስያስ ደይ ያራ ባሪን አርጋስሴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ዮሀኒስ ታቶኒ ኬር ግሪናኔን ኦርፎ የሱስ ሀኦሲ ምስራቹኒ ካማኖን ማኬት ጋሊላ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","አሲፌና ካባሲክ ደይ፦ «ዎናስ ኮእ፥ ሀኦሲ ታቶኒ ሀእሱስ ታእሴ። ቦርኒትሶን ሀርምራ ምስራቹኒ ካማሲክ አማኖት» ይት ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","የሱስ ጋሊላኪ ባርሲ ቴሻ ካሞ ኣትፌት ዎስቶቤስ ቁርጡምኒ ኤሻ ስና ስሞንናዋ አይባ እንድርያስና ዩጉዶቤሲሶን አካስሲ ሀእሴፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","የሱስ ደይ ባሶክ፦ «ታኔን አነ ዮትዋ። ኤካት ሀኦሲ ታቶሲ አሱኒን ዙቱትክ ዛጉናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ባሶ ደይ ጌሬጌሬ ዩጉዶቤሲሶን ቤይፋት ባርኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ኤስታን ጋሮኖን ኤክሴፌና ካባሲክ ዛብድዮስኒ ናንጎት ያቆብናዋ አይባ ዮሀኒስና ፌሴቴር። ባሶ ጎኑስታ ዲሴፋት ዩጉዶቤሲሶን ማእሴፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ኤስታን ጌሬጌሬ ሀጝ ባርኪ ዮሶነክ ቴጌ። ባሶ ደይ አባቤስ ዛብድዮስኒን ዎስትኛሳክቶኔን ጎኑስታ ቤይየ ሀኣት ባርኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","የሱስናዋ ናዎባሳክቶና ክፍርናሆም ካታማ ሀሜቴ። ጌሬጌሬ የሱስ ቤይሳኒ ዎናሲክ አይሁድኒ ሺጶኒ ኬያስሲ ግሪሬ አሱ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","የሱስ ሙሴኒ ቱማሲ አስሲኛኒ ሜያ አሲሴፌማቶ ስኖይናሮን ዳሶን ሀእሲፌ ባሶሲማቶ ስንና ቦርአ አሲፌና አሱሲክ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ኤስ ካባሲክ አይሁድኒ ሺጶኒ ኬያስሲ ኪና አያና ኤጵና እሳ አሱ ኤካ ይት ቻጊ፦ ");
INSERT INTO jnje_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«ናዝሬትኪ የሱስኖ! እንኖ ነኔን አዉኒ እሳርኒ ፋሪንሶ? እኖትን ትሽኩታክ ያታሮሶ? ነ ኦ ስንታማቶ ታ አሪፋውጙዋ። ነ ሀኦሲ ኮርቶዋ!» ");
INSERT INTO jnje_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","የሱስ ደይ፦ «እሳ ካማ ኮትኖይ ባሳስን ኬስ!» ይት ችኒሬ ኬእ። ");
INSERT INTO jnje_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ኪና አያናስ አሱስን ጋንስራ ቶኮናክ ዛግራ አካማ ካማክ ቻግጋ ባሳስን ኬስ። ");
INSERT INTO jnje_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","አሱኒ ሜያ ዙቴሬ ዲንቆክ፦ «ሀን ባር ኣምባንሶ? አሮን ጋድዶ አስሱንሶ? ኪና አያናሶን ሀእሱኒ ሁግናክ አጃጀን ባሪኪቶ ደይ አጃጃሜር» ይት ባሶትና ባሶትና ማምሲት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ጌሬጌሬ የሱስኒ ቾዋሲ ዎል ላ ጋሊላኒ ብራቶስታ ፋ፤ ዳ፤ ዙታምባሴ አሲስ ዝእ። ");
INSERT INTO jnje_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ኤስ ካባሲክ የሱስ አይሁድኒ ሺጶኒ ኬያስን ኬስሴ ያቆብኔን ዮሀኒስኔን አነ ስሞንናዋ አንድርያስና አሲ ኬር ግሪ። ");
INSERT INTO jnje_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ኤስታክ ስሞኒ አሱሲ እንቶ ጉምታኒ ሜሮ ሜቴራ ኩንፋር። ባሪ ሜቶሶን ጌሬጌሬ የሱስኒክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","የሱስ ባርኪ ታእሴሬ ኩሹባስሲ ዛትቴ ካብግ። ሜሮስ ደይ ማእን ካብራ ባሶትን እርባሲ። ");
INSERT INTO jnje_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","አዋ ግሪን ታልሜፋና ካባሲክ አሱኒ ሜያ ሜታንኒ ሜያኖንናዋ ኪና አያና ኤጵና ሜያኖንና ዙትሬ የሱስኒኪ ኤጴ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ካታማስሲ ፌ አሱኒ ሜያ ዙታምቤሲሴ ኬያሲ ፎቻታ ዙቴሬ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","የሱስ ሾዎ ቴሳ ሜሮክ ሜቴሬ ፌ ሾዎ አሱኒ ሜያኖን ፋቲ። ሾዎ ኪና አያናሶን ደይ ክሲ። ኪና አያናስኑ ባር ኦ ስንናማቶ አርሴራ ፋሴር ስንና ቦርአ የሱስ እሳ ዉዛነ ማክሶናክ ኣኔ ሾሎዌ። ");
INSERT INTO jnje_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ዎንሳ ዋስሲ ካብሬ ዎኖይፌን የሱስ ኬሩን ኬሴ እሳ ፉችቻ ድማ ሀምሜ ሀኦ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ስሞንናዋ ባርኔን አነ ፌሴ ባሶትና ሾሎክ ካቢ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ዳነሬ፦ «አሱ ዙቴሬ ኔን ሾሌድፌርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","የሱስ ዎልግሬ፦ «ታ ያናስ ኤሲሲክ ስንና ቦርአ ሀንታን ኦማ ታእሶ ድማስታ ፋሴ ካታማስሲ ደይ ሀምፋኒ ካምባሶን ማኮጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","አይሁድኒ ሺጶኒ ኬያስሲ ካምባሶን ማኬት ኪና አያናሶን አሱሳስኒ ኪስት ጋሊላኒ ዳ ዙታምባሴ አስሲ ኩቲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","እሳ አዋታቶኒ ሜታን ባርኪ ዬሬ ካአነፋት፦ «ነ ሹንፋታኔ ታን ፋቱክ ችማታዋ» ይት ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","የሱስ ባሪክ ኬናሽቴፋት ኩሹባሶን ሾሬ አቱባሶን ታፕትሬ፦ «ሹንፋኡጝዋ፥ ካይማ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","አሱስ ደይ ጌሬጌሬ ሜሮባስን ፋሪ። ");
INSERT INTO jnje_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","የሱስ አሱስን ማእስሬ ኪትሬ ጋፍካት፦ ");
INSERT INTO jnje_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«ሀን ባሮን ኦንኒክኑ ማኮኖይታማቶ አሩዋ። ስኑንታኖ ሀምማ ቴትኔሶን ማግሲክ ቤሱዋ። ባሶክ ዛላ ስናናክ ፋሩኔሲክ ሙሴኒ ቱማስ ማኬና ማኣሶን እምማ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ስኑንታኖ አሱስ ኤስታን ኬስናይሴ ስና ቾዋሶን አሱ ዙታምባሴ አሲክ ዎሎክ ካቢ። ኤስ ባሪ ቦርኣ የሱስ አምማኖን ኬስሴ ኣፋ ካታማሲኑ ግሩናክ ኣነ ችሜ። ባክ ጌራካሎ አሱ ፎንቶ ድማ ሀምሜ ድ። አሱኒ ሜያ ደይ ዳ ዳስን ባሪክ ዬሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ጋሮ ዎናኔን ኦርፎ የሱስ ክፍርናሆም ካታማ ዎል ሌ ዬሬ ኬር ፌናማቶ ኦድቴ። ");
INSERT INTO jnje_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ኬያስ ቱምን ፎቻራስ ትርኦናኔን ሾዎ አሱ ዙቴ። የሱስ ደይ ባሶክ ሀኦሲ ካማኖን አሲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","አቼች አሱ እሳ ላፋ አሱኒን ዎርኤ የሱስኒኪ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ዳራ ሾዌና ቦርአ የሱስኒኪ ታእሱክ ኣነ ችሞቶ። ባር ፌና ድማስታኪ ኬያሲ ኣፋኖን ካብጋት ኦፖባሴ የት ኬር ጌደቴ። ");
INSERT INTO jnje_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","የሱስ ባሶ አማንቶሶን ብያት ላፋ አሱስን፦ «ና! ቦርኔስ ፌሹን ይስቴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ኤስታ ዲሴ ሙሴኒ ቱማሲ አሲኛሳስን እሳ እሳይስ ንብቤሲስ፦ ");
INSERT INTO jnje_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«ሀን አሱስ አዉኒ ቦርአ ኤፋቴና ሜእኒ ካማ ማኬፌሶ? እሳ ሀኦስኔን ኦማ ቦርኣሶን ፌሹን ኡክ ችምኒር ኦንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ጌሬጌሬ የሱስ ንቤሲሲ ሳፋራኖን አያናባሲክ አሪፋት ኤካ ይ፦ «ንብኒትስ አዉኒሮን ኤካ ሳፋሬድፌትሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ላፋስን፦ ‹ቦርኔስ ፌሹን ይስቴዋ› ኡስጝዋ ‹ካብራ ኦፖኔሶን ዎርአ ሀምማ› ኡስንሶ ካሾይ? ");
INSERT INTO jnje_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ስኑንታኖ አሱኒ ና ሀን ዳስታኪ ቦርኣሶን ፌሹን ኡክ ሀእሱኒ ሁግናባ ፎባሶን አሩትዋ» እያት ላፋስን፦ ");
INSERT INTO jnje_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«ኔክ ማኬፋውጙዋ፦ ካብራ ኦፖኔሶን ዎርአ ኬኔ ሀምማ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ጌሬጌሬ ካብሬ ኦፖባሶን ዎርኤ አሱ ዙታምባሴ አሲ ስና ኬስሴ ሀሚ። ኤስ ባሪ ቦርኣ አሱኒ ሜያ ዙቴሬ ዲንቀሴት፦ «ኤፋቴና ዉዛ ቢራ ኣነ አሩዌኒዋ!» ይት ሀኦሶን ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","የሱስ ሄፕሳ ዎል ሌ ጋሊላኪ ባርሲ ቴሻ ሀሚ። ሾዎ ዳራ ደይ ዙቴሴሬ ባርኪ ዬሴቴን አስሲ። ");
INSERT INTO jnje_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ኤስታ ካሞ ኣትፌን ግርቦ ዙቴፋናስታ ድ አልፍዮስኒ ና ሌዊኒን ብያት፦ «ታኔን አነ ሀሚኒዋ» ይ። ባር ደይ ካብሬ ባርኔን አነ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ኤሴን ኦርፎ የሱስ ሌዊኒ ኬር ሙ ሜፌን ሾዎ አሱኒ ሜያ ደይ አነ ኤስታ ፌሴቴር። ባሶስን ሾዎ ቦርኒ ሜናዋ ግርቦ ዙትፌ ባሶትና የሱስናዋ ባሳ ናዎኒ ሜና አነ ሙ ሜሴድፌር። ");
INSERT INTO jnje_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ፌርሳዊኒ ሜኒ ኬን ስና ቱማሲ አስሲኛኒ ሜያ የሱስ ግርቦ ዙትፌ ባሶኔንናዋ ቦርኒ ሜያኔንና አነ ሜፌን ብየፋት፦ «ግርቦ ዙትፌ ባሶኔንናዋ ቦርኒ ሜያኔንና አዉኒሮን አነ ሜሬ ኡሽድፌሪንሶ?» ይት ናዎኒ ሜያኖን ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","የሱስ ኤስ ባሮን ኦደፋት፦ «ሜታኒስቴኖ ፋያኒክ ኤትኒ አሱ ኣነ ሾልስፌዋ። ታ ያናስ ቦርኒ ሜያኖን ሀኦስኪ ዎልጉክታኖ ኦኮኒ ሜያክታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ዮሀኒስኒ ናዎስናዋ ፌርሳዊኒ ሜና ሶሜሬ ሺጵሴቴር። እሳ እሳ አሱኒ ሜያ የሱስኒኪ ዬሴሬ፦ «ዮሀኒስኒ ናዎስናዋ ፌርሳዊኒ ናዎስና ሶሜሬ ሺጵሴቴር። ነ ናዎኒ ሜያ ሶሜሬ ሺጶ ቤየፌስ አዉኒ ቦርአንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","የሱስ ደይ ባሶክ ዎልግሬ፦ «ማሪስ ባሶኔን አነ ፌን ሞዝጊቱኒ ሜያ ሶሜሬ ሺጵሶነክ ሾልስፋዎሶ? እንዳነዋ! ማሪስ ባሶኔን አነ ፌን ሶሜሬ ሺጵሶነክ ኣነ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ስኑንታኖ ማሪስ ባሶስታን ኦር ኬሳና ዎና ዮና። ኤስ ካባሲክቱ ሶሜሬ ሺጵሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«ኩርኡ ማማስታ ጋድዶ ኤርቤ ኩንስሬ ዞርፌር ኣፌዋ። ኤስ ባሮ ዛጋናነ ጋድዶ ኤርቤስ ኩርኡ ማያሶን ካራሲርዋ። ካራቶባስ ደይ ዜምማት ባሪስታን አካማቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ኤሲስማቶ ኩርኡ ሀማቶሲ ኦራ ዋይኒን ኡሻ ጌድፌር ኣፌዋ። ጌድፋናነ ዋይኒኒ ኡሻስ ሀማቶሶን ካራሲርዋ። ዋይኒኒ ኡሻስ ደይ ዉክቴር ሀማቶስ ደይ ማጝር። ኤስ ባሪ ቦርኣ ኦራ ዋይኒን ኡሻሲክ ጋድዶ ሀማቶቱ ሾልስፋርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ቤይሳኒ ዎናሲክ የሱስ ፎሻስታ ካሞ ኣትፌን ናዎኒ ሜያ አነ ሀሜፌት ቦና ዛጎ ቡግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ፌርሳዊኒ ሜያ፦ «ነ ናዎኒ ሜያ ቤይሳኒ ዎናሲክ ዛግቶናክ ሾልሱኖይሶን አዉኒሮን ዛግሴፌሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","የሱስ ደይ ዎልግሬ፦ «ዳዊትናዋ ባርኔን አነ ፌሴ አሱኒ ሜና ማክቴሴፌ ካባሲክ አዉ ዛግሴቴማቶ ኣነ ፌሬቱዌትኖሶ። ");
INSERT INTO jnje_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","አብያታር ማግኒ ጋኝኜ ሜኒ ጋኛ ስንነ ፌና ነያሲክ ሀኦሲ ኬር ግሪሬ ማግኒ ሜያክታኖ ኦኑ ሙናክ ሾልሱኖይ ቱሻሶን ሜዋ። ኤስታን ባርኔን አነ ፌሴ ባሶክ ደይ እምዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ደይ የሱስ፦ «ቤይሳኒ ዎና አሱኒክቱ ቴስቴታኖ አሱ ቤይሳኒ ዎኒር ስንነ ኣነ ቴስቶዌዋ። ");
INSERT INTO jnje_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ኤስ ባሪ ቦርኣ አሱኒ ና ቤይሳኒ ዎናሲክኑ ዳምባይዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ደይ የሱስ ዎል ሌ አይሁድኒ ሺጶኒ ኬያሲ ግሪ። ኤስታክ ደይ ኩሹባ ላፋ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","እሳ እሳ ሜያ ማላቶክ ቾዋ ሾልሴፋት፦ «ሀን ቤይሳኒ ዎናሲክ ፋቱኒቶ ብያኒዋ» ይሬ ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","የሱስ ደይ ኩሹባ ላፋ አሱስን፦ «ካብራ ሀጝ ጋነያ ያራ የሮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ኤስታን አሱኒ ሜያክ፦ «ቤይሳኒ ዎናሲክ ማአሮን ዛጉጝዋ ወደይ ማጙኖን ዛጉንሶ፤ ካኒ ፋቱጝዋ ወደይ ዎሩንሶ?፤ ኣፋሪንሶ ፋቃድቴሪ? ማኬቤትሶ?» ይት ማምሲ። ስኑንታኖ ባሶ ሻክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","የሱስ ንብቤሲስ ችማክ ሃሬፋት ብራቶስታ ፌሴ አሱኒ ሜያኖን ግእአክ ብያት አሱስን፦ «ኩሹኔሶን ዜጵዋ» ይ። ባር ደይ ኩሹባሶን ዜጲን ኩሹባስ ፋሪ። ");
INSERT INTO jnje_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ኤስታን ፌርሳዊኒ ሜያ ጌሬጌሬ ኬሴሬ የሱስኒን ኣካክ ዎርሶነማቶ ሄሮድስኒ ኬን ስንነ ባሶኔን አነ ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","የሱስ ናዎባስኔን አነ ጋሊላኒ ባሪሲኪ ሀሚ። ጋሊላኒ ዳስታን ዬሴ ሾዎ አሱኒ ሜያ ኦርፎባሴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ባር ዛግት ፌና ዉዛሶን ዙትሬ ኦደሴፋት ዩዳኒ ዳስታን፥ የሩሳሌምኒ ካታማስን፥ ኤዶምያስኒ ዳስታን፥ ዮርዳኖስኒ አካሲ የሳሎ ፋ ዳስታን፥ ትሮሱናዋ ስዶኑንና አሲ ካታማሲ ብራቶታን የሱስኒኪ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ዳራሳ ሾዎታን ካብ ቾዋ አሱኒ ሜያ ቱግስሴት ፌሴቴር ስንና ቦርአ ጎኑ ባሪክ ሆሱሶነክ ናዎኒ ሜያኖን አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ሾዎ አሱኒን ፋትር ስንና ቦርአ ሜሮቤስ ፋና ባሶ ዙቴሬ ባሪን ታእሬ ፋርሶነክ ትኢርስሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","አሱሳሲ ፋ ኪና አያና የሱስኒን ብየናሴ ስንባ ጋንደራ፦ «ነ ሀኦኒ ናዋ» ይት ቻጌት ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ኪና አያናሲክቶኖን ደይ ባር ኦ ስንናማቶ ማክሶኖይናማቶ ዛግሬ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","የሱስ ኣማስታ ኬስፋት ባር ሹንና ባሳክቶኒን ቴጌ። ባሳክቶ ደይ ባርኪ ዬሴ። ");
INSERT INTO jnje_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","ባርኔን አነ ፎሶነክ፤ ካምባሶን ማክሶነክ ዎሱናክ፤ ኪና አያናሲክቶኖን አሱሳስን ክሱሶነክ ሀእሱኒ ሁግናቤስ ፎናክ አሲሬ ሄፔ አሱኒን ኮራት፦ «ዎሲ» ይሬ ቴጌ። ");
INSERT INTO jnje_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ኤስ ኮርቴሴ አሲሬ ሄፔ አሱሳክቶ «ጳጥሮስ» ይሬ ሱንስና ስሞን ");
INSERT INTO jnje_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","«ቦአርነርጌስ» ኡስ ደይ «ደዶኒ ናንጎት» ይሬ ሱንስና ዛብድዮስኒ ናንጎት ያቆብናዋ ዮሀኒስና፥ ");
INSERT INTO jnje_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","አንድርያስ፥ ፍልጶስ፥ ቤርቴለሜዎስ፥ ማትዎስ፥ ቶማስ፥ እልፍዮስኒ ና ያቆብ፥ ታድዎስ፥ ኮነፌ ባሶኪን ስሞን ");
INSERT INTO jnje_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","የሱስኒን ኣትሬ እማ አስቆሮትኪ ዩዳዋ። ");
INSERT INTO jnje_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ኤሴን ኦርፎ የሱስ ኬር የ። ባርኔን ናዎኒ ሜያኔን ሾዎ አሱኒ ሜያ ሄፕሳ ደይ ዙቴሴቴ ቦርአ ሙኒ ሙክኑ ኣነ ችሞሶቶ። ");
INSERT INTO jnje_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","«የሱስ ንፋሴዋ» ይስቴፋ ዎል ላ ኦደሴፋት ኮንኒ ሜያ ባሪን ኤጳክ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","የሩሳለሙን ዬሴ ሙሴኒ ቱማሲ አስሲኛኒ ሜያ፦ «የሱስ ቤልዘቡል ባሳስሲ ፋርዋ! ኪና አያናሲክቶኖን ክስፌናስ ባሮን ሀእስፋ ባሪክዋ» ይት ዎሉምሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","የሱስ ባሶትን ባርኪ ቴጌሬ ቤሶክ ኤካ ይ፦ «ሴጣናስ ኣካክ ሴጣናሶን ክሱክ ችምንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","እሳ ታቶስ ባሬ ባሬ ኦር ኦር ኬስፋናነ ታቶባስ ዛግራ የሮክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ኤሲስማቶ እሳ ኬር ፌ አሱ ኦር ኦር ኬስፋናነ ዛግሬ ፎክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ኤስ ባሪ ቦርኣ ሴጣናስ ባሬ ባሬ ኦር ኦር ኬስፋናነ ትሹቱ ትሹናታኖ ኣፋ ዛግራ የሮና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«እሳ ዛግ አሱኒ ኬር ግሪሬ ዜምሜ ኤስ ዛግ አሱስን ኤጴ ታርኖይ ኬባስሲ ፋ ፎባሶን ቦኦክ ችምኒር ኣፌዋ። ታርእናነን ኦርፎቱ ቦኦክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«ፉቶ ንቶክ ማኬፋውጙዋ፥ አሱኒ ሜያ ዎስቴሴፌ ቦርኣሴዋ ማክሴፌ ሜኣሴ ዙቴራ ፌሹን ኡስቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ስኑንታኖ ኮርቶ አያናስታ ሜእኒ ካማ ማክሴፌ ባሶ ቦርኣስ ኮእባ ፎንቶኖን ቦርቤሲስ እሳንነ ኣፋ ፌሹን ኡስቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","« ‹ኪና አያና ባሳስሲ ፋርዋ› » ይሴት ፌሴቴር ስንና ቦርአቱ የሱስ ኤስ ባሮን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","የሱስኒ እንቶሴዋ አይባሳክቶና ዬሴሬ ጌራካሎ የርሴፋት ባርኪ ዎስሴሬ ቴግሲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ኤስ ብራቶስታ ዲሴ አሱኒ ሜያ፦ «ነ እንቶኔሴዋ አይኔሳክቶና ጌሮክ ኔን ሾልሴድፌርዋ» ይት ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","የሱስ ዎልግሬ፦ «እንቶና ኦንሶ? አይታሳክቶ ደይ ኦና ኦናንሶ?» ይት ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ብራቶስታ ዲሴ ባሶኪ ቢፌት፦ «ኤሴ እንቶናሴዋ አይታሳክቶና ሀኒስዋ፦ ");
INSERT INTO jnje_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ሀኦስ ፊቃዲኖን ዛግሴፌ ባሶ ዙቴሬ አይታ፥ ኤትና ደይ እንቶናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ሄፕሳ ዎል ሌ የሱስ ባሪሲ ቴሻ ዳራስን አሱክ ካቢ። አካም ሾዎ አሱ ባርኪ ኤስታ ዬሴሬ ዙቴሴቴ ቦርአ የሱስ ጎኑስሲ ግሪሬ ባሪስታ ድ። ዳራስ ዙቴሬ ባርሪ ቴሻ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ቤሶክ ሾዎ ዉዛ ባሶክ አሲ። አሲፌና ካባሲክ ደይ ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«ኦዶትዋ! ቡክኛስ ሜኒ ቡካክ ኬሲ። ");
INSERT INTO jnje_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ቡክፌና ካባሲክ እሳ እሳይስ ኡግናሲ ሀእታ ኬሬ ዎርእ። ካሳስ ደይ ኬጳ ማሴ። ");
INSERT INTO jnje_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ኦማስ ደይ ጋሮ ሆእባ ፋና ካኦስታ ኬሬ ዎርእ። አካማ ሆአ ኣፋ ስንና ቦርአ ጌሬጌሬ ካይ ");
INSERT INTO jnje_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ስኑንታኖ አዋ ኬስፋና ካባሲክ አልቂ። ታስባስ ኣነ ዛጉዋ ስንና ቦርአ እችሚ። ");
INSERT INTO jnje_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ኦማ ዛላስ ደይ ሴርአ ፋና ዳስታ ኬሬ ዎርእ። ሴርኣስ ኬስሳ ጌርና ቦርአ ኣነ ጋና። ");
INSERT INTO jnje_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ኦማስ ማአ ቡሎስታ ኬሬ ዎርአ ባር ካይራ ድቻ ጋና ጋኒ። እሳይስ ኬዛስሮን፥ እሳይስ እሱናስሮን፥ እሳይስ ትያኖን ጋኒ።» ");
INSERT INTO jnje_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ኤስታን ደይ የሱስ፦ «ኦዶኒ ኦዶባ ፌና ባር ኦዶዎዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","የሱስኒ ቴሻ ፌሴ አሱኒ ሜናዋ አሲሬ ሄፔ ናዎባሳክቶና የሱስ ባር ባር ስንፌና ካባሲክ፦ «ቤሶክ ማኬታ ቾዋሲ ኮታ ኣምባንሶ?» ይሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ባር ደይ ዎልግሬ፦ «ንቶክ ሀኦሲ ታቶኒ ኣቾ ቾዋኖን አሩትክ እምቴዋ። ስኑንታኖ ኦምኒ ሜያክ ዙታምባሴ ቤሶክቱ ማክቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ኤስ ባር ደይ፦ « ‹ባሶ ሀኦስኪ ዎልሴቴን ቦርቤሲስ ፌሹን ኡስቶኖይናማቶ፤ ኣፍቤሲሲክ ቢፌት ኣነ ያዳቴሴፌ፤ ኦዶቤሲሲክ ኦደፌት ኣነ ጋሳሲሴፌዋ› » ይስቴናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ደይ የሱስ ባሶክ ኤካ ይ፦ «ሀን ቤሶሶን ንቶ ኣነ አሩዌትኖሶ? ኤካን ኦማ ቤሶሲክቶኖን ዙትራ ኣካክ አሩክ ችምፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ቡክኛስ ካምባሶንቱ ቡክፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ካምባሶን ቡክቴፋና ካባሲክ ኡግናሲ ሀእታ ኬሬ ዎርአ ባር ካምባሶን ኦደሴፌ ካባሲክ ጌሬጌሬ ሴጣና ያራ ኤስ ካማሶን ንቤሲስን ኤጳ ትሽክፋና አሱኒ ሜያዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ኤሲስማቶ ደይ ካኦስታ ቡክቴ ባር ካምባሶን ኦደሴፌ ካባሲክ ጌሬጌሬ ግራክ ኤጴቴሴፌ ባሶዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ስኑንታኖ ኤስ ካባሲክታኖ ባሶሲ ካምባስ ታሳ ኣነ ዛጉዋ። ጋሮ ዎናኔን ኦርፎ ካምባሲ ቦርአ እሳ ራክኮ ወደይ ካቡግቶ ያፋና ካባሲክ ጌሬጌሬ ቱሳኢሴሬ ጋንደሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ሴርአ ፋና ዳስታ ቡክቴ ባር ደይ ካምባሶን ኦደፌ ባሶትጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ስኑንታኖ ሀን ዳስታኪ ፎኒ ቾዋሲ ሳፋራ ኦቱምኒ ኬሽታናሴዋ ኦማ ኦማ ዉዝኒ ኤናንቶሴ ባሶ ንባስሲ ግሪራ ጌሪፋና ቦርአ ጋንቤሲ ፎንቶ ስንነ ፉእቴሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ማአ ሆኣስታ ቡክቴ ባር ደይ ካምባሶን ኦዴሬ ኤጴቴሴፌ አሱኒ ሜያዋ። ኤስ ባሶ እሳይስ ኬዛስሮን፥ እሳይስ እሱናስሮን፥ እሳይስ ትያኖን ጋነፌዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ቱስሬ ደይ፦ «እሳ አሱ ቶና ቶኒሬ ዋሽሺ ወደይ ኩጶኒ ስካሎሲ ዱስፌዎሶ? ቴጋ ድምታታኖሶ ዱስፌናሪ? ");
INSERT INTO jnje_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ኤስ ባሪ ቦርኣ ኣቸራ አምማኖን ኬስኖር ኡክቴራ ቻሬፋስታ ኬስኖይ ዉዛ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ኤሴ ኦዶኒ ኦዶባ ፌና ባር ኦዶዎዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ደይ የሱስ ኤካ ይ፦ «ሀን ቾዋሲክቶኖን ጋሳሲራ ኦዶትዋ! ንቶ ሳፋሬፌት ሳፋሬሲክ ዎል ላ ንቶክ ሳፋርቴራ እምቶናዋ። ኤስ ባርስታኑ ንቶስታ ዳይስቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ፌና ባሪክ ዳይስቴራ እምቴር። ስኑንታኖ ትሽፋናነ ኤስ ባርኪ ፋ ባርኑ ኦቴርዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ደይ የሱስ ቱስሬ ኤካ ይ፦ «ሀኦሲ ታቶ ቡሎስታኪ ዛላ ቡክፌ አሱነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","አሱስ ዋልን ኩንፌ ደይ ዎናኔን ደይ ካብፌ። ኣካክ ስንድፋናማቶ አሩኖይፌን ዛላስ ካይፋ፤ ደይ ድችፋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ቡሎኒ ዳስ ደይ ቴትባክ ዜምማ ካይፋ፤ ኤስታን ኬኦባ ክስፋ። ፎትራ ጋና ጋንፋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ሜያስ ደይ ካትታ ካርኒ ዎና ካርናኔን አሱስ ማጋዳክ ካርአክ ካቢፌ።» ");
INSERT INTO jnje_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ኤካ ደይ ይ፦ «ሀኦሲ ታቶኖን አዉኔን ሆሱንሪንሶ? አሮ ቤሶክ ደይ ሆስራ ማኮናሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ፍእፍኦኒ ጋናነ ፋርዋ፤ ባር ደይ ቡሎስታ ቡክቴፋና ካባሲክ ዳስታ ፋ ዛላ ዙታምባሴ አሲስታን አቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ስኑንታኖ ቡክቴራ ካይናኔን ኦርፎ ጎሩ ቡክቴራ ካይ ዛላ ዙታምባሴ አሲስታን አሪክር ስንፋ። ሳማስታኪ ካሳስ ደይ ዋይእባሲ ኬባ ኬርአ ዱናኔን እኛ እኛ ዋይአ ክስፋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","የሱስ አሱኒ ሜያ ጋሳሲሬ ኦዶክ ችሞኔስንነ ፋሮን ኤፋ ሾዎ ቤሶክ ካምባሶን ባሶክ ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ባር አሲፌና ካባሲክ ቤሶ ፎንቶ ኣነ አሱዌ። ስኑንታኖ ባሶ ባሶ ስንነፌ ካባሲክ ቾዋሶን ዙትሬ ናዎኒ ሜያክ ኮቴ ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ኤስ ዎኖ ዋልን የሱስ ናዎኒ ሜያክ፦ «ሀን ባሪሲ የሳሎ ፍናኒዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ዳራስን ኤስታክ ቤይፋት የሱስ ዲና ጎኑሲ ግሪን ባሪን ኤጴ ሀሜቴ። ኦማ ጎኑሲክቶ ደይ ባርኔን አነ ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","አካማ አካኒ ጉቦሲ እፑዋ ካብራ አካስ ጎኑስሲ ቱማናኔን እፑዋስ ጎኑሶን እቸት ፋር። ");
INSERT INTO jnje_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ኤስ ካባሲክ የሱስ ጎኑሲ ኦርፎሲ ቦክታ ቦክቴሬ ኩንፌር። ናዎኒ ሜያ ባሪን ጉዝግሴሬ፦ «አስሲኛኖ! እንኖ ትሹስ ኔን ኣነ ትርኤፋኖሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ባር ጉዝሬ እፑዋሶን ኬእ። ባሪሶን ደይ፦ «ቤይያ ሻኩ!» ይ። እፑዋሲ ስሩ ደይ ቤይ። አካማ ናጋኑ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","የሱስ ናዎኒ ሜያኖን፦ «አዉኒሮን ኤካ ድጌድፌትሪንሶ? ሀሽኔን አማንቶኒት ኣፋኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","አካማኖን ድጌሴሬ ባሶትና ባሶትና፦ «ኤካኒ እፑዋሴዋ ባሪሴ አጃጃሜናር ሀን ባር ኦንሶ?» ይሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ጋሊላን ባሪሶን ጎኑክ ፍነሬ የሳሎ ጌርጌሴኖንኪ ዳስታክ ካርኤቴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","የሱስ ጎኑስን ኬሮባሴ ጌሬጌሬ ኪና አያና ኤጵና አሱ ሹኢን ሞጋስኒ ኬሴ ባርኪ ኡጰ። ");
INSERT INTO jnje_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ኤስ አሱስ ደይ ሞግን ድምሲቱ ፌፌ። ኦኑ ባሪን ብታን ሻሻራክኑ ታርኤ ዱሱክ ኣነ ችምፌ። ");
INSERT INTO jnje_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ሾዎ ዎና ዎቾኒ ብትታክናዋ ሻሻራክና ታቴት ፌር። ስኑንታኖ ሻሻራሶን ቡግትናዋ ብታሶን ኪርኤትና ፌር። ባሪን ሜሮክ ኦኑ ችምፌር ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ዎንና ዎንና ቶናዋ ዋልና ሹኢን ሞጋስታናዋ ኩማስታና ኩትፋፌ ቻጌት ፌር። አቱባሶን ሹአክ ቡኤ ማዛስት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ኪና አያናስ ዎክሶክ የሱስኒ ቢናይሴ ኤልላ ስኒባ ካአነፋት። ");
INSERT INTO jnje_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ቴጋ ካማክ፦ «አካማኖን ኡልፍንቶ ሀኦሲ ና የሱስኖ! ታኔን አዉነ ፋሪንሶ? ታን ኪቹኖይታማቶ ሀኦሲ ሱናክ ቴዉዋ!» ይት ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ኤስ ባሮን ይናስ የሱስ፦ «ነ ኪና አያና ሀን አሱሳስኒ ኬስ» ይና ቦርአ። ");
INSERT INTO jnje_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","የሱስ ደይ፦ «ሱነ ኦንሶ?» ይሬ ማምሲ። አሱስ ዎልግሬ፦ «እንኖ ሾዎ ስኒ ቦርአ ሱና ለጌዎኒ » ይ። ");
INSERT INTO jnje_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ባርኪቶኖን ዳስታኪ ካሌ ኮፍኩኖይናማቶ ችኒሬ የሱስኒ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ኤስ ዳስታክ ፋ ኩማስ ቴሻ ሾዎ ሙኮኒ ዎዶ ኬምቴድፋር። ");
INSERT INTO jnje_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","«ሀማ ሙኮስ ግሩኒክ እኖትን ጋፍኩዋ» ይት ሺጵሴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","የሱስ ደይ ሀማ ግሩናክ ማኬን ኪና አያናሲክቶ ኬሳ ሙኮሲክቶስ ግር። ሄፕ ኩማ ስኒ ሙኮ ኩማስታን ኤለራ ባሪስ ግርራ ክት። ");
INSERT INTO jnje_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ሙኮሶን ኬምፌ ኬዞሳክቶ ኤለሬ ሀሜ ካታማስናዋ ኬኤስና ስና ቾዋሶን ማክሴቴ። አሱኒ ሜያ ደይ ስና ባሮን ብያክ ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","የሱስኒክ ዬሴቴን ኤስ ሾዎ ኪና አያናስ ኤጵና አሱስ ንብባሲ ዎልን ማያ ማየ ዲፌን ብየቴሴ ድጌሴቴ ");
INSERT INTO jnje_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ኤስ ኪና አያናስ ኤጵና አሱሳ ቾዋኖናዋ ሙኮሲክቶታና ስና ባሮን ዙትሬ ዜምሜ ብያ አሱኒ ሜያ ኤስ ዬሴ ባሶክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ኤስ ካባሲክ ኤስ ዳስታክ ፌ አሱኒ ሜያ የሱስ ዳቤሲስታን ኬሴ ሀማናክ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","የሱስ ጎኑስ ግሪፌና ካባሲክ ኪና አያናስ ባሳስኒ ኬስና አሱስ፦ «ነኔን አነ ሀማናዋ» ይት ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ስኑንታኖ የሱስ ኣነ ማእ ኡዌ። አሱሲክ ዎልግሬ፦ «ኬነ ዎላ ሀምፋት ኬርክ አሱኒ ሜያክ ዳሚስ ኔክ አዉነ ፋ አካማ ዉዛ ዛግናማቶናዋ ኣካክ ኔክ ኬናሽቴናማቶና ማኮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","አሱስ ደይ የሱስ ባርኪ ዛግና ቾዋሶን፦ «አሲር ካታማ» ይስቴፋ ዳስታክ ሀሜ አዋስ። ኦደ ባሶ ዙቴሬ ዲንቀሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","የሱስ ደይ ጎኑክ የሳሎ ሄፕሳ ዎል ሌ ፍንፌና ካባሲክ ሾዎ አሱ ባርስ ቴሻ ባርኪ ኤስታ ዙቴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","አይሁድኒ ሺጶኒ ኬያስ ጋኛአሳስኒ ያይሮስ ይስቴ እሳ አሱ ዬሬ የሱስኒን ቢናይሴ ዎቾባስ ካአነሬ፦ ");
INSERT INTO jnje_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","«አቴ ናናስ አካማኖን ሜቴራ ክቱና አጋት ኩንርዋ። ፋሪራ ካክ ፎናክ ያራ ኩሹኔሶን ባርስታ ታኡዋ» ይሬ ችኒሬ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","የሱስ ደይ ባርኔን አነ ሀሚ። ሾዎ አሱ ኦርፎባሴ ትርኢስሴድፌር። ");
INSERT INTO jnje_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","አሲሬ ሄፔ ነያ ሀሪንባ ዉክቴት ፋና እሳ አሱ ፋር። ");
INSERT INTO jnje_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ሾዎ ኤትኒ አሱኒክ ሀሚፋፋ አካማኖን ራካቴት ዋግባሶን ደይ ኮእስት ፋር። ስኑንታኖ ሜሮባስ አሪክቱ ሀሚታኖ ፋሩክ ኣነ ችማ። ");
INSERT INTO jnje_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ባር የሱስኒ ቾዋሶን ኦደራ ፋር ስንና ቦርአ አሱሳ ጋነሲ ኦርፎ ካሞ ያራ ማምባሶን ታእ። ");
INSERT INTO jnje_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ኤስ ባሮን ዛግናስ፦ «ማምባስታ ታእፋናነ ፋሩናዋ» ይራ ፋር። ");
INSERT INTO jnje_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ኤስ ዉክቴት ፋ ሀርንባስ ጌሬጌሬ የሬ። ሜሮባስኒ ፋርናማቶ አቱባስታክ አሪ። ");
INSERT INTO jnje_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","የሱስ ደይ ጌሬጌሬ ባሳስኒ ሁግና ኬስናማቶ አራት ዳራሳ ጋነሲ የርቀሬ «ማምናስታ ታእስ ኦንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ናዎኒ ሜያ ዎልግሬ፦ «ዳራስ ትርኢስሴፌን ቢፋት፦ ‹ኦንሶ ታን ታእር› ይፋቶሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ስኑንታኖ የሱስ ኤስ ባሮን ዛግስ ኦ ስንናማቶ አሩክ የርቀሬ ቢ። ");
INSERT INTO jnje_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ኤስታን አሱስ ባርኪ ዛግቴ ባሮን አሪና ቦርአ ድጌራ ኮርክት ያራ ስኒባ ካአነራ ፉቶሶን ዙትራ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ባር ደይ፦ «ናናሴ! አማንቶኔስ ኔን ፋትዌ። ማርኦን ሀሜ፤ ሜሮኔስኒ ፋሩዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","የሱስ ኤስ ባሮን ማኬፌና ካባሲክ አይሁድኒ ሺጶኒ ኬያስ ጋኛ ያይሮስኒ ኬሩን ዬሴ አሱኒ ሜያ ባርኪ፦ «ናኔስ ክትዋ። ሀሽ አዉኒሮን አስሲኛስን ሆፕስፋሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ስኑንታኖ የሱስ ኤስ ባሮን ኦደፌት አይሁድኒ ሺጶኒ ኬያስ ጋኛንን፦ «አማኖታኖ ድጎታታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","የሱስ ደይ ጴጥሮስኔን፥ ያቆብኔን፥ ያቆብን አይ ዮሀኒስኔንታኖ ኦም አሱ ባርኔን አነ ሀማናክ ኣነ ማእ ኡዌ። ");
INSERT INTO jnje_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","አይሁድኒ ሺጶኒ ኬያስ ጋኛአሳ ኬር ዬሬ ካርፌና ካባሲክ አሱኒ ሜያ ሳሴትናዋ ዋስትና ቻጋ ኣታምሲሴፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ኬር ግሪሬ፦ «አዉኒ ቦርአ ሳሴት ዋስድፌትሪንሶ? ናዋስ አፋይቶቱ አፋይቴታኖ ኣነ ክቱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","አሱኒ ሜያ ደይ ካኝን ምአ ምኤሴቴ። ስኑንታኖ የሱስ ባሶትን ዙትሬ ኬሩን ካሌ ክሳት ናዋስ አባንናዋ እንቶኖንና ደይ ባርኔን አነ ፌሴ ባሶትን ዞንስሬ ናዋ ፋናስ ግር። ");
INSERT INTO jnje_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ናዋስ ኩሹኖን ደይ ዛቴ፦ «ጣልታ ኩም!» ይ። ኤስ ካማስ ኮታ ደይ፦ «ጋሮ ናዋሴ ካቡዌ ይፋዉጝዌ» ኡ። ");
INSERT INTO jnje_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ባር ደይ ጌሬጌሬ ካብራ ኤክ ሀጝ ኩት። ዎጋባስ ደይ አሲሬ ሄፔ ስናና። ኤስ ባር ስኒፋና ካባሲክ አሱኒ ሜያ አካማኖን ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ስኑንታኖ የሱስ፦ «ስና ቾዋሶን ኦኑ አሩናታ» ይሬ ባሶክ አጃጀፋት ደይ፦ «ናዋስ ሙና ሙ እምት» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","የሱስ ኤስታን ኬሴ ዳባስታ የ። ናዎኒ ሜያ ኦርፎባሴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ቤይሳኒ ዎናሲክ አይሁድኒ ሺጶኒ ኬያስ አስሱ ኤጲ። ሾዎ አሱኒ ሜያ ኦደሴሬ ዲንቀሴት ኤካ ይሴቴ፦ «ሀን አሱስ ሀን ዉዛሶን ዙትሬ አይን ዳንሶ? አሮ አሩኒሶ ሀን ባርኪ እምቴሪ? ሀን ቢስቴራ አሪቶኖይ ዉዛሲክቶኖን ዛግፌናስ ኣካኪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ሀኒስ እኦ ካርፌ ማራሚን ናስቴኖሶ? ያቆብን፥ ዮሳን፥ ዩዳናዋ ስሞና አሲ አይስቴኖሶ? ኤትባሲክቶኑ ሀን እኖኔን አነታኖሶ ፋሴናሪ?» ኤሲሶን ይሴት ኤጴቶ ቤየሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ስኑንታኖ የሱስ፦ «ራጁ ዳባስታክ፥ ኮኒባሳ ጋነስናዋ ኬር አነ ፌና አሱሳ ጋነሲታኖ ኦም ጌሮን አሱሳ ስናክ ኡልፍንቶዋ» ይሬ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ኤስታክ ደይ ጋሮ ሜታን ሜኒስታቱ ኩሹባሶን ታእሬ ፋትቴኖ ኦማ ቢስቴራ አሪቶኖይ ዉዛ ኣነ ዛጉክ ችሜ። ");
INSERT INTO jnje_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ዳራስ አማኖ ቤዮቤሲሲክ ዲንቀ። ኤስታን የሱስ ኬኤ ኬኤስ ኩትፋፌ አሲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","አሲሬ ሄፔ ናዎባሳክቶኒን ሀጝ ባርኪ ቴጌሬ ሄፕ ሄፕ ዛግሬ ዎሲ። ኪና አያናሲክቶታ ሀእሱኒ ሁግና እሚ። ");
INSERT INTO jnje_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ኤስታን ኤካ ይሬ አጃጀ፦ «ሀማት ኡጉንትሲክ ሃሮታኖ ቱሻ ወደይ ሀማቶ ወደይ ታጫአማስታ ብር ኮርእራ ኤጳትታ። ");
INSERT INTO jnje_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ዎቾንትስ ቻማ የርትታኖ ሄፕ ማማ ኤጳትታ። ");
INSERT INTO jnje_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","እሳ አሱኒ ኬር ግሪፌት ካባሲክ ኤስ ካታማስን ኬሳትኔን ኤስታ ፎቲ። ");
INSERT INTO jnje_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","አሱኒ ሜያ ንቶትን ኤጴቶክናዋ ኦዶክና ቤየቴ ድማስታ ዎቾንትስ ቱሎኖን ቴባት ኤስኒ ኬሳ ሀሚት። ኤስ ባር ደይ ባሶስታ ዛላ ስናና።» ");
INSERT INTO jnje_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ኤስታን ኤስ ዎስቴሬ ሀማ ባሶ ደይ ኬሴሬ አሱኒ ሜያክ፦ «ቦርንትሶን ሀርምራ ሀኦሲክ ዎሉት» ይት አሲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ሾዎ ኪና አያና አሱኒስኒ ክሴቴ። ሾዎ ሜታኒን ደይ ዛይት ሙድፋፌ ፋትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","የሱስኒ ሱናስ አሪቴራ ፋር ስንና ቦርአ ታቶ ሄሮድስ ባሳ ቾዋሶን ኦደ። እሳ እሳ ሜያ፦ «ሀጵቅፌ ዮሀኒስ ክቱኒ ካቢ። ኤስ ባሪ ቦርኣ ቢስቴራ አሪቶኖይ ዉዛ ባርኪ ዛግቴድፋር»ይሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ኦሚስ ደይ፦ «ኤልያስዋ» ይሴቴ፤ እሳካዲስ ደይ፦ «ዜሞቲ ራጁኒ ሜያስን እሳሳማቶዋ» ይሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ስኑንታኖ ሄሮድስ ኦዴሬ፦ «ሀን ባር ታ ሱትባሶን ካትና ሀጵቅፌ ዮሀኒስዋ። ኤሴ ባርቱ ክቱኒ ካብርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","ሄሮድስ አይባ ፍልጶስኒ አሱ ስና ሄሮድያዳኖን አሱ ዛግሬ ኤጲ። ሀጵቅፌ ዮሀኒስ ሄሮድስኒን፦ «አይኔሳ አሱኖን ኤጳታክ ኔክ ኣነ ሾልስፋዋ» ይሬ ማኬ። ኤስ ባሪ ቦርኣ ዎስሬ ሀጵቅፌ ዮሀኒስኒን ኦትሬ ታቶኒ ኬር ታት። ");
INSERT INTO jnje_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","ሄሮድስ ሀጵቅፌ ዮሀኒስ ኦኮ ደይ ኮርቶ አሱ ስንናማቶና አሪር ስንና ቦርአ ድጌሬናዋ ኦደትና ፌር። ሄሮድስ ባሳ ዎላሶን ኦደና ኦደና ፋዳሲክ ናየቱ ፌፌ። ስኑንታኖ ግራክቱ ኦደፌ። ኤስ ባሪ ቦርኣ ሄሮድያስ ሀጵቅፌ ዮሀኒስኒን ኤስ ማኬና ዉዛሲክ ሃሬራ ዎሩክ ሾሌፋናክኑ ኣነ ችማ። ");
INSERT INTO jnje_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ሄሮድስ ኮንቴና ዎናሶን ኡልፍንሱክ ዳሶን ሀእሲፌ ባሶክ፤ ታርኦን ጋኛንክናዋ አርቶ ጋሊላክ ሜያክና አካማ ኮታ ኮቴ። ኤስ ባር ደይ ሄሮድያ ሾሌፋና ማአ ዎና ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ሄሮድያዳን ናዋ ኮታስ ማስቴፋና ኬያስ ግርራ ባሶ ስና ሱርት ኤሬስራ ሄሮድስናዋ ባርኔን አነ ፌሴ ባሶትና ግርስ። ታቶስ ደይ ናዋሶን፦ «ነ ሾሌታ ዉዛ አዉኑ ስኑን ታን ማምሱዌ እማናዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ሄፕሳ ደይ፦ «ታቶናስ እሳ ኩኑኖኑ ስኒፋናክ ማምሲታ ባሮን ዙትራ ኔክ እማናዌ» ይሬ ቴይ። ");
INSERT INTO jnje_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ባር ደይ እንቶባሲክ ሀማ፦ «አዉ ማምሱናሴ» ይ። እንቶባስ ደይ፦ «‹ሀጵቅፌ ዮሀኒስኒ ቴታሶን› ይራ ማምሱዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ናዋስ ደይ ጌሬጌሬ ታቶስኪ ዎላ ሀማ፦ «ሀጵቅፌ ዮሀኒስኒ ቴታሶን ሀን ኮራናስ ጌድቴራ ሀሽ ታክ እምቶናክ ሾሌፋኡጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ታቶስ ኤስ ማምሲና ማምሱሲክ አካማኖን ሱሜ። ስኑንታኖ ዜምሜ ቴይና ቦርአ ሙ ሙሶነክ ቴግቴ አሱኒ ሜኒ ስና ናዋሲክ ካላናክ ኣኔ ሾሎዌ። ");
INSERT INTO jnje_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ጌሬጌሬ ታቶስ ኦድፌ ታርኦሳስኒ እሳርን ዮሀኒስኒ ሱታሶን ካርኤ ቴሾናክ ዎሲ። ታርኦስ ደይ ሀሜ ታቶኒ ኬያስኒ ሱትባሶን ካርእ። ");
INSERT INTO jnje_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ካርና ቴታሶን ኮራናስ ጌደ ቴሾስ ናዋሲክ እምን ናዋስ ደይ እንቶባሲክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ዮሀኒስኒ ናዎሳክቶ ኤስ ባሮን ኦደሴቴይሴ ዬሴሬ ዱግኖባሶን ኤጴ ካባርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ዎስኒ ሜያ ዎስቴሬ ሀሜቴስኒ ዎል ሌ ዬሴሬ የሱስኒክ ስና ዙቴሴቴ። ዛግሴቴ ባሮናዋ አሲሴቴ ባሮና ዙትሬ ባርኪ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ባሶክ ዬፌርናዋ ዎል ሌ ሀሚፌ አሱና ሾዎ ስንና ቦርአ ሙን ሙክኑ ሳአት ኣነ ዳኖቶ። ኤስ ባሪ ቦርኣ የሱስ፦ «ንቶ ንቶ እሳ ሻቶ ድምስ ሀምፋት ጋሮ ዎና ቤይሳ ኤጵትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ኤስታን ባሶ ባሶ ጎኑስ ዲሴሬ እሳ ሻቶ ድምስ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ስኑንታኖ ሀሜፌን አሱኒ ሜያ ብየሬ ባሶ ስኖቤሲሶን አሪሴቴ። ኤስታን ካታማ ካታማስን ኬሴሬ ዎቾክ ኤለሬ ባሶ ካርኦኖ ፌሴቴን ዜምሜ ሀሜ ባሶ ኬርሶኔስታ ዙቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","የሱስ ጎኑስን ኬሬፌና ካባሲክ ሾዎ አሱኒ ቢሬ ኬዞባ ፎንቶ ፋንቱነ ፌሴቴር ስኖቤሲሲክ ሱሜ። ኤስታን ሾዎ ዉዛ ባሶትን አሱክ ካቢ። ");
INSERT INTO jnje_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ጌሮክ ድማስ ዋለት ሀሚባሴ ናዎባሳክቶ የሱስኒክ ታእሴሴሬ፦ «ሀን ፋኒ ድማስ ዛቦዋ፤ ጌሮክ ደይ ዋልድፋር፤ ");
INSERT INTO jnje_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ሀን አሱኒ ሜያ ሙሶነ ዉዛ ኣፋ ስንና ቦርአ ብራቶስታ ፋ ቤዴስናዋ ኬኤስና ሀሜሬ ሙቤስ ዋግሶነክ ጌጌሱዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ስኑንታኖ ባር ዎልግሬ፦ «ባሶ ሙሶነ ሙሶን ንቶ እምትዋ» ይ። ባሶ ደይ፦ «ኤካኒ እንኖ ሀማ ሄፕ ትያ ዲናሪ ዙትራ ክስራ ዋጌራ እማንሮሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","የሱስ፦ «አፑን ቱሻንሶ ፋሪ? ሀማ ብየቤትሶ» ይ። ባሶ ደይ ብየሬ፦ «ኡች ሙማ ቱሽነዋ ሄፕ ቁርጡምነቱ ፋርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","የሱስ ደይ ዳራስ ችሮ ኩዋስታ ባግ ባጌ ዱሶነክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ኤስታን ትያ ትያነዋ ኡቻስር ኡቻስሬ ስንነፋፌ ማዳዳክ ዲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","የሱስ ደይ ኡኮት ኡች ሙማ ቱሻሴዋ ሄፕ ቁርጡሚሴ ኤጴ ደን ሳማ ቢሬ ሀኦ ጋላቴፋት ቱሻሶን ባቴ ዳራሲክ ዎሾነክ ናዎባሳክቶኒክ እሚ። ኤሲስማቶ ሄፕ ቁርጡሚሶን እምን ዙታምቤሲሴ አሲክ ሃኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ዙታምቤሲሴ ሜሴሬ ጋዉሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ናዎሳክቶ ደይ ፉእቴ ባቶ ቱሻሴዋ ቁርጡሚሴ አሲን አሲሬ ሄፔ ማሳ ቱማኖን ዙትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ቱሻሶን ሜ ኣርቃሱሳ ፋዳ ኡች ኩም ስናና። ");
INSERT INTO jnje_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","የሱስ ጌሬጌሬ ዳራስን ጌጌሲፌት ናዎባሳክቶኒን ጎኑስ ዲሴሬ የሳሎ ቤቴሳይዳ ፍነሬ ዜምሜ ሀሞነክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ኤሴን ኦርፎ የሱስ ባሶስታን ኦር ኬሴ ሀኦ ሺጶናክ ኣማስታ ኬስ። ");
INSERT INTO jnje_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ዋልፋና ካባሲክ ጎኑስ ባርስ ጋነታቱ ፋ። ኤስ ካባሲክ የሱስ ባር ባር ዳስታክቱ ፌ። ");
INSERT INTO jnje_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ናዎባሳክቶ ስሩ ባሶ ስናስታ ስርድፋር ስንና ቦርአ አካሶን እቼ ፍናክ ራክካሴፌን ቢ። ዋሲ እዝግን ሳአትን ሀማ አሲሬ ሄፔ ሳአትኔን ፋ ካባሲ ባሪስታ ኩቲት ሀጝ ባሶክ የ። ባሶትኑ አቴ ሀማና ካባ። ");
INSERT INTO jnje_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ስኑንታኖ ባሶ ባሪስታ ኩቲት ሀሚፌን ብየሴፋት፦ «ክታዋ» ይሴፋት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ዙታምቤሲሴ ብያት ናይሴቴ። የሱስ ደይ ጌሬጌሬ፦ «ሀሬዋ! ታዋ! ድጎትታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ጎኑስ ግሪሬ ባሶኔን አነ ዱባሴ ስሩስ ቤያ የሬ። ኤስ ባሪ ቦርኣ ናዎሳክቶ አካማኖን ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ንብቤሲስ ያዳቶ ቤያ ፋር ስንና ቦርአ ዜምማት ዛግቴ ቢስቴራ አሪቶኖይ ቱሻስ ቾዋኖን ኣነ አሪሶቶ። ");
INSERT INTO jnje_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ባሪሶን ፍነሬ ጌንሳሬት ይስቴ ዳስታክ ካርኤቴ። ጎኑሶን ኤክ ዳስታክ ታእስሬ ታርኤ ዬትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ጎኑስን ኬርሴፌ ካባሲክ አሱኒ ሜያ ጌሬጌሬ የሱስኒን አሪሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ኤስ ዳ ዙታምባሴ አሲ ብራቶስታ ኤክ ሀጝ ኤለፋፌ የሱስ ፌናስታ ሜታን ሜያኖን ኦፖታ ዎርኤ ቴሸሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ባር ሀሚና ሀሚና ድማ ዙታምባሴ አሲ ኬኤስ፥ ካታማስ፥ ቤዴስ ፌሴ ሜታን ሜያኖን ኤክ ያቦስታ ኤጴታፌ ቴሾ ማይባስ ፋሻኖነ ታኡሶነክ ሺጵሴት ፌሴቴር። ታእ ባሶኑ ዙቴሬ ፋርሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ፌርሳዊኒ ሜናዋ የሩሳለሙን ዬሴ እሳ እሳ ሙሴኒ ቱማሲ አስሲኛስና የሱስኒክ ዬሴሬ ዙቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","የሱስኒ ናዎሳስን እሳ እሳይስ ቱማስማቶ ማስቴራ ካይምኖይ ኩሹክ ሙ ሜሴፌን ብየቴ። ካይምኖይ ኡስ ማስቶኖይ ኩሹ ኡ። ");
INSERT INTO jnje_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ፌርሳዊኒ ሜናዋ ኦም አይሁድኒ ሜና ኩርኡኒ ሜኒ ቱማሶን ኦዳክ ኩሹቤሲሶን ማሶ ሻክሴፋቴነ ኣነ ሜሴፌ። ");
INSERT INTO jnje_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ኤሲስማቶ ደይ ጋባን ዎልሴፌ ካባሲክ ማሶኖይ ኣነ ሜሴፌ። ቱዎሶን፥ ግማሶን፥ ብታክ ዎሱስቴ ኮዳሶና ማሳነ ፋ ኦማ ኦማ ቱማሶኔን ኦደቱ ፌሴፌ። ");
INSERT INTO jnje_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ኤስ ባሪ ቦርኣ ፌርሳዊኒ ሜናዋ ሙሴኒ ቱማሲ አስሲኛስና፦ «ኤኪን ነ ናዎሳክቶ ኩርኡኒ ሜኒ ቱማሶን ቤየፋት አዉኒ ቦርአ ኩሹቤሲሶን ማሶኖይ ሙ ሜሴፌሶ» ይት የሱስኒን ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ስኑንታኖ ባር ዎልግሬ ኤካ ይ፦ «ንቶ ስኖይ ስንነ ቤስቴፌ አሱዋ፤ ራጁ ኢሳያስ ንቶ ቾዋሲክ ማኬፌና ካባሲክ፦ « ‹ሀን ዳራስ ኖኖባ ኖኖባሲክቱ ታን ኡልፍንስፌቴኖ፤ ንብባሲ ታይስታን አካማኖን ዎካዋ። ");
INSERT INTO jnje_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","አሱ ቱሜና ቱማሶን፤ ሀኦኒር ዛግሴሬ አሲሴፋፌ፤ ሽማሲክቱ ታን ኡልፍንስፌዋ› ይሬ ማኬና ባር ፉቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«ንቶ ሀኦሲ አጃጅኖን ቤየፋት አሱኒ ቱማቱ ኦደፌትዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ደይ የሱስ ቱስሬ፦ «ንቶ ቱማሶን ኦዳክዋ እያት ሀኦሲ ቱማኖን ቤያት ማአ ኡጉንት ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ሙሴ፦ ‹አባነስንናዋ እንቶኔሶንና ኡልፍንሱዋ› ደይ፦ ‹አባባስኒ ወደይ እንቶባሶን ሜአ ባር ዎርቶናክ ሾልስፋ› ይፋ። ");
INSERT INTO jnje_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ስኑንታኖ ንቶ ‹እሳ አሱ አባባስኒ ወደይ እንቶባሶን አሪጋሱና ዉዝባ ፋፋናነናዋ ኤስ ባሮን ደይ፦ «ሀን ባር ሀኦሲክ እምና እማዋ» እያናነ፤ ");
INSERT INTO jnje_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","አባባሲክናዋ እንቶባሲክና አሪጋሱ ቤያክ ችማናዋ› ይሴፌት። ");
INSERT INTO jnje_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ኤሲሲክ ቴኤትንትስ ቱማኖን ኦዳክ ሀኦሲ ካማኖን ሻሬፌት። ደይ ኤፋ ኤፋ ሾዎ ዉዛ ዛግሴፌት።» ");
INSERT INTO jnje_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","የሱስ ደይ ዳራስን ሄፕሳ ባርኪ ቴጌሬ፦ «ዙታምንትሴ ጋሳሲራ ታኪን ኦዶትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","አሱኒ ኪንስፋስ አሱኒስኒ ኬስፋ ባርታኖ ጌሮን አሱኒስ ግሪፋ ባር ኣነ ኪንስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ኤሴ ኦዶን ኦዶባ ፌና ባር ኦዶዎዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","የሱስ ዳራስን ቤይፋት ኬር ሀሚፌና ካባሲክ ናዎባሳክቶ ቤሶስ ኮታኖን ማሙሴቴ ");
INSERT INTO jnje_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ባር ደይ ባሶክ ዎልግሬ፦ «ንቶ ደይ ኣነ ጋዝጉዌትኖሶ? ጌሮን አሱኒ ካታስ ግሪፋ ባር እሳንነ አሱኒ ኣነ ኪንስፋ ስንናማቶ ኣነ አሩዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ካታስ ግሪፋ ባር ጌሮቱ ኬስፋታኖ ንብባሲ ኣነ ግሪፋዋ» ይ። ኤካ ኡባሲክ የሱስ ሙ ዙቴራ ካይማ ስኒባሶን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ቱስሬ ደይ፦ «አሱኒን ኪንስፋስ አሱሳ ንብስኒ ኬስፋ ዉዛሲክቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ኤስ ባር ደይ ማጙኖን ሳፋሮ፥ ሶሎ፥ ዊሶ፥ አሱኒ ዎሩ፤ ");
INSERT INTO jnje_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ጌርኬሳ፥ ጆሮ፥ ማጙ፥ ኤሻ፥ ጋፎ፥ ኮና፥ ሀማቶ፥ ቤጋንቶ፥ ግሮናታ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ኤስ ማጙ ዉዛሲክቶ ዙቴራ አሱኒ ንብስኒቱ ኬስፋ። አሱኒን ደይ ኪንስፋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","የሱስ ኤስታን ካብሬ ጢሮስኒ ካታማስ ቴሻ ፋ ኬኤስ ሀሚ። ኤስታ እሳ ኬር ግሪሬ ፎባሶን ኦኑ አሩኖይናማቶ ሾሌ። ስኑንታኖ ኣቾክ ኣነ ችሜ። ");
INSERT INTO jnje_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ጋሮ ናዉባሶን ኪና አያና ኤጵና እሳ ማሽካሱ የሱስኒ ቾዋሶን ኦደፋት ጌሬጌሬ ያራ ዎቾባስ ሳጋደ። ");
INSERT INTO jnje_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","አሱስ ስሮፍንቃውን ሜኒ ኬና ስና ግሪክኒ ካማቱ ዎል ሌፋ። ባር ደይ ናዉባስን ኪና አያናሶን ክሱናክ የሱስኒ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ስኑንታኖ የሱስ፦ «ናንጎታስ ሙኖን ኤጴ ካናክ ሀኡ ማአሪታ። ሻካኒ ናንጎታስ ዜምማ ማራ ጋዉን» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","አሱስ ዎልግራ፦ «ፉቶዋ ዳምታሶ! ካናሲክቶኑ ስላዎስ ስካሎስ ፋፋቱ ናንጎታስ ማፋና ካባሲክ ዝግፋ ፉፉኒቶሶን ማፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ኤስ ባሪ ቦርኣ የሱስ ባርኪ፦ «ኤካ ማኮኔሲክ ኪና አያናስ ናኔስን ኬስዌ፤ ማርኦ ሀሜ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","አሱስ ደይ ኬባ ዎላ ሀማ ካርእን ኪና አያናስ ኬስፋን ናዋስ ፋሪራ ኩጶስታ ኩንፌን ዳኒ። ");
INSERT INTO jnje_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ኤስታን የሱስ ጥሮሱን ኬሴ ስዶን ካሞ አቴ አሲር ካታማ ይስቴፋ ዳስታኪ ጋሊላን ባሪሲክ የ። ");
INSERT INTO jnje_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ኤስታክ እሳ ኦዶባ ኦዮናዋ ባቡላ አሱና አሲን አሱኒ ሜያ የሱስኒክ ኤጴ ዬሴቴ። ኩሹባሶን ደይ ባሳስታ ታኡናክ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","የሱስ አሱስን ዳራሳታን ባር ባሪን ኦር ክስሬ ኩሹባስ ዋአክ ኦዶባስ ጌዳት ቱጃ ቱጀሬ አሱሳ ቴርማኖን ታፕት። ");
INSERT INTO jnje_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ደን ሳማ ካነ ብያት ስካለሬ ሳፋሬሬ «ኤፍታ» ይ። ኮትባስ ደይ «ጋቾ» ኡ። ");
INSERT INTO jnje_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ጌሬጌሬ ኦዶባስ ጋችቼ። ቴሩምባስ ደይ ኮቴ። እሳ ቱሳኦ ፎንቶኖን ማእስሬ ዎል ሌ። ");
INSERT INTO jnje_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","የሱስ፦ «ሀን ባሮን ኦኒክኑ ማኮትታ» ይሬ ኤጴ የ ባሶክ አጃጀ። ስኑንታኖ ባሶ ማኮትታ ይና ባሮን ቤይፋት አሪክስሬ ዎሉምሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","አሱኒ ሜያ አካማኖን ዲንቆክ፦ «ዙታምባሴ አሲን ማአሪ ዛጊዋ። ኦዶ ኦዮኒ ሜያ ኦዶሶነክ፤ ንብታቶኒ ሜያ ዎሉምሶነክ ዛግ!» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ኤስ ዎናሲክ ሾዎ ዳራ ሄፕሳ ደይ ዙቴ። ሙሶነ ሙ ኣፋ ስንና ቦርአ የሱስ ናዎኒ ሜያኖን ባርኪ ቴጌሬ፦ ");
INSERT INTO jnje_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«ዳራስ ሀውጙ ኬዝ ዎና ካርኤ ታኔን አነቱ ፌሴቴ። ሙቤስ ኣፋ ስንና ቦርአ ባሶክ ሳፋሬፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ባሶስኒ እሳ እሳይስ ዎካ ዳኒ ዬሴቴር ስንና ቦርአ አፉር ኬቤስ ጋፍካናነ ኡጉንታ ጎዳ ታቴሴቴርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ናዎባሳክቶ ደይ፦ «ሀን ኢችማ ዳስ ሲ አሱ አይን ቱሻ ዳና ሀን ኤፌቴና ዳራስን ማሱክ ችምንሪንሶ?» ይሬ ዎሉግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","የሱስ፦ «ንቶክ አፑን ቱሻንሶ ፋሪ?» ይሬ ማምሲ። ባሶ ደይ፦ «ናፉን ቱሻቱ ፋርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ዳራስን ዳስታክ ዱሶነክ አጃጀ። ኤስታን ናፉን ሙማ ቱሻሶን ኤጴ ሀኦ ጋላቴፋት ባቴ ዎሾነክ ናዎባሳክቶኒክ እሚ። ባሶ ደይ ዳራሲክ ዎሸቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ባሶክ ጋሮ ቁርጡም ፋር። ኤስ ባርኪ ሀኦሶን ጋላቴፋት ዎሾነክ ናዎባሳክቶኒን አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ናዎሳክቶ ደይ አሱኒ ሜያ ሜሴሬ ጋዉሴቴን ፉእቴ ባቶሶን እኛ እኛ ናፉን ማሳ ቱማኖን ዙትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ቱሻሶን ሜሴ አሱኒ ሜያ አቼች ኩም ስኖነ። ኤስታን ጌጌሲ። ");
INSERT INTO jnje_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ኤሴን ኦርፎ ናዎባሳክቶኔን ጎኑስሲ ዲሴሬ ዳልማኑታ ይስቴፋ ዳስታክ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ፌርሳዊኒ ሜያ የሱስኒክ ዬሴሬ ባርኔን ካራካሮ ኤጴቴ። ፋታኖክ ሾልሴፋት ቢስቴራ አሪቶኖይ ዉዛ ሳማን ቤሱናክ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ባሳ ቴታሲክ አካማኖን ስካለሬ ሳፋሬፋት፦ «ሀን ኮንቶስ አዉኒ ቦርአ ቢስቴራ አሪቶኖይ ዉዛ ሾሌፋሶ? ፉቶክቱ ማኬፋውጙዋ፥ ሀን ኮንቶሲክ እሳ ቢስቴራ አሪቶኖይ ዉዛ ኣፋ እምቶና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ፌርሳዊኒ ሜያኖን ቤይፋት ሄፕስ ዎል ሌ ጎኑስ ዲሬ የሳሎ ፍኒ። ");
INSERT INTO jnje_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ናዎባሳክቶ ቱሻ ኤጴ ሀማ ዳግሴቴ ቦርአ ጎኑስ ፋዪስ እሳ ቱሻታኖ ኦማ ኣፋ። ");
INSERT INTO jnje_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","የሱስ ባሶትን፦ «ፌርሳዊኒ ሜናዋ ሄሮድስና አሲ ማሶስኒ ቴትንትሶን ኦድትዋ» ይሬ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ባሶትና ባሶትና፦ «እኖክ ቱሻ ኣፋ ስንና ቦርአዋ» ይት ዎሉምሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","የሱስ ኤስ ባሶ ሳፋራሶን አሪፋት፦ « ‹ቱሻ እኖክ ኣፋ ስንና ቦርአዋ› ይት ንቶትና ንቶትና አዉኒሮን ዎሉምሴድፌትሪንሶ? ሀሽኔን ኣነ ጋዝጉዌትኖሶ? ኣነ አሩዌትኖሶ? ንብንትስ ያዳቶ ቤይዮሶ? ");
INSERT INTO jnje_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ኣፍንት ፌን ኣነ ብፌትኖሶ? ኦዶንት ፌን ኣነ ኦደፌትኖሶ? ንብንትስ ኣነ ካርፋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ኡች ሙማ ቱሻሶን ኡች ኩም አሱሲክ ባትፋና ካባሲክ ፉእቴ ባቶሶን አፑን ማሳ ካቡግሴትሶ?» ይ። ባሶ ደይ፦ «አሲሬ ሄፔ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ደይ «ናፉን ሙማ ቱሻሶን አቼች ኩም አሱኒክ ባትፋና ካባሲክ ፉእቴ ባቶሶን አፑን ማሳ ካቡግሴትሶ?» ባሶ ደይ፦ «ናፉን» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ባር ደይ፦ «ሀሽኑ ኣነ አሩዌትኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ቤቴሳይዳ ካርኤፌ ካባሲክ አሱኒ ሜያ እሳ ኣፍትሹንን ኤጴ ዬሴሬ የሱስ ታፕቱናክ ደይ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ባር ደይ ኣፍትሹስ ኩሹባስ ዛቴ ኬኤሲ ጌራካሎ ክስሬ ኣፋስ ቱጅፋት ኩሹባሲክ ታእሬ፦ «እሳ ቢድፋ ታ ዉዛ ፋሮሶ?» ይሬ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ኣፍትሹስ ደን ካነ፦ «አሱሳክቶ ኩቲት የሬ እኦኒማቶ ኩትሴድፌን ቢድፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ሄፕሳ የሱስ ኩሹባሶን ኣፋስታ ታእ። ኤስታን አሱስ ማእስሬ ቢ። ፋሪሬ ዎክሶክኔን ፋ ዉዛሶን ዙትሬ ማእስሬ ቢ። ");
INSERT INTO jnje_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ኤስታን የሱስ አሱስን ኬባ ጋፍካት፦ «ኬኤስ ግሩታታ » ይ። ");
INSERT INTO jnje_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","የሱስናዋ ናዎባሳክቶና ኬሳርያኒ ፍልጶስ ይስቴፋ ካታማስ ቴሻ ፋ ኬኤሲክቶስ ሀሜቴ። ኡግናስታክ፦ «አሱኒ ሜያ ታ ኦ ስንናማቶ ማክሴፌሶ?» ይሬ ናዎባሳክቶኒን ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ባሶ ደይ ዎልግሬ፦ «እሳ እሳይስ ሀጵቅፌ ዮሀኒስዋ፤ ኦሚስ ደይ ኤልያስዋ፤ ኦሚስ ደይ ራጁሳስን እሳይስዋ» ይሬቱ ማክሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","«ኤካኒ ንቶኬ፤ ታን ኦ ይፌትሶ?» ይሬ ማምሲ። ጴጥሮስ ዎልግሬ፦ «ነ ክርስቶስዋ » ይ። ");
INSERT INTO jnje_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","የሱስ ባሶክ፦ «ታ ቾዋሶን ኦንክኑ ማኮትታ» ይሬ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","የሱስ ናዎኒ ሜያክ ኤካ ይት አስሱ ኤጲ፦ «አሱኒ ና አካማ ሻና ኤጴቶናክ ሾልስፋዋ። ኩርኡኒ ሜኒ ስናክ፥ ማግኒ ጋኛን ስናክ፥ ሙሴኒ ቱማሲ አስሲኛኒ ሜኒ ስናክ ካሽስቶኒር ደይ ዎርቶኒር። ስኑንታኖ ኬዝ ዎናኔን ኦርፎ ክቱኒ ካቡኒር።» ");
INSERT INTO jnje_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ኤስ ባሮን ደይ አምማኖን ባሶክ ማኬ። ኤስ ካባሲክ ጴጥሮስ የሱስኒን ኦር ኤጴ፦ «ኤካ ኡታታዋ» ይት ኬእ። ");
INSERT INTO jnje_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ስኑንታኖ የሱስ ናዎባሳክቶኒክ የርቀሬ ብያት ጴጥሮስኒን ኤካ ይሬ ኬእ፦ «ነ ሴጣና፥ አሱሳሮንታኖ ሀኦሲሮን ኣነ ሳፋሬፌ ስንና ቦርአ ሄክ ኦርፎና ሀማ።» ");
INSERT INTO jnje_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ኤስታን የሱስ ዳራስን ናዎባሳክቶኔን አነ ቴጌሬ ኤካ ይ፦ «ታኔን አነ ሀማክ ሾሌ ባር ባሳ ቴትን ሳፋራሶን ቤዮዋ። ባሳስታ ካርን ማስቃልን ሻናሶን ዎርኤ ታኔን አነ ሀሞዋ። ");
INSERT INTO jnje_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ካባሶን ፉኦክ ሾሌፌ ባር ዙቴሬ ቱርኩና። ታክናዋ ምስራቹኒ ካማሲክና እያት ካባሶን ቱርክ ባር ዙቴሬ ፋቱና። ");
INSERT INTO jnje_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","አሱ ሀን ዳስታኪ ፋ ዉዛሶን ዙትሬ ዳንፋት ካባሶን ቱርክፋናነ ባርኪ አዉ ኬኢንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","አሱ ካባሶን ፉሮክ አሮ ዋጋ ካሱንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ሀን አማኖኖይናዋ ቦርባሬ የሬ ኮንቶስ ጋነሲ ታክናዋ ታ ካማሲክና ኢቼፌ ባር ዙታምባሴ አሱኒ ና አባባሳ ኡልፍናክ ኮርቶ ዎሲያስኔን አነ ዬፌና ካባሲክ ባርኪ ኢቾና።» ");
INSERT INTO jnje_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ደይ የሱስ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፤ ሀንታ የርሴ አሱኒ ሜያስን ሀኦሲ ታቶ አካማ ሁግናክ ያፌን ቢኖይፌጌዶ ክቱሶኖር እሳ እሳር ፌሴቴርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","እሱን ዎናኔን ኦርፎ የሱስ ጴጥሮስኒን ያቆብንናዋ ዮሀኒስና ደን ቴጋ ኣማስታ ባሶ ባሶትን ኤጴ ኬስ። ኤስታክ ባሶ ስናስታ ግቶባስ ሶልቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ማይባስ ደይ ፓልፓልራ ፎሬ። ሀን ዳስታኪ ማማ ሜእፌ ባር ኦኑ ካይኑክ ችምኖይናርነ ፋር ስንና አካማኖን ፎሬ። ");
INSERT INTO jnje_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ኤስታን ኤልያስናዋ ሙሴና የሱስኔን አነ ዎሉምሴፌን ብየቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ጴጥሮስ የሱስኒክ፦ «አስሲኛኖ! ሀንታ ፎኒስ እኖክ ማአሪዋ። እሳሮን ኔክ እሳሮን ሙሴኒክ እሳሮን ኤልያስኒክ ኬዝ ሀፎ ኬርአንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","አካማኖን ድጌሴቴ ቦርአ ጴጥሮስ ማኬፌና ዉዛሶኑ ኣነ አሩዌ። ");
INSERT INTO jnje_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ሻሩ ያራ ባሶትን ይንን ኤስ ሻሩስ፦ «ኬሽቴፋና ናታስ ሀንፌዋ! ባሪን ኦዶትዋ!» ይፋ ካማ ኦድቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ጌሬጌሬ የርቀሬ ብየቴን የሱስ ባር ባርቴኖ ባሶኔን ኦም ኦኒንኑ ኣነ ብዮቶ። ");
INSERT INTO jnje_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ኣማስታን ኬርሴፌ ካባሲክ የሱስ፦ «አሱኒ ና ክቱኒ ካቡናኔን ሀን ብየት ባሮን ኦንክኑ ማክሶትታዋ» ይሬ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ባሳ ካማሶን ንብቤሲስ ኤጴፋት፦ «ክቱኒ ካቡ ኡስ ኣምባንሶ?» ይሴት ባሶትና ባሶትና ዎሉምሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ባሶ ደይ፦ «ሙሴኒ ቱማሲ አስሲኛኒ ሜያ አዉኒ ቦርአ ‹ኤልያስ ዜምሜ ዮናክ ሾልስፋ ይሴፌሶ?› » ይት ባሪን ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ባር ደይ ዎልግሬ፦ «ኣ፤ ኤልያስ ዜምሜ ዬሬ ዙታምባሴ አሲን ዜጳና። ስኑንታኖ አሱኒ ና አካማ ሻናሶን ኤጴቶናማቶናዋ ካሽስቶናማቶና ትቼናስ አዉኒ ቦርአንሶ? ");
INSERT INTO jnje_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ስኑንታኖ ንቶክ ማኬፋውጙዋ፦ ‹ኤልያስ ደይ የዋ። ባርኪ ትቼናስማቶ ሾልሴቴሶን ዙትሬ ባሳስታ ዛግሴቴ› » ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ኡኮት ፉእቴ ናዎኒ ሜያክ ዎልሴሬ ዬሴፌ ካባሲክ ሾዎ ዳራ ባሶ ብራቶስታ ዙቴሬ ፌሴቴን ሙሴኒ ቱማሲ አስሲኛኒ ሜያ ደይ ባሶኔን ዌኢንሴፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ጌሬጌሬ ዳራስ ዙቴሬ የሱስኒ ብየቴሴ ዲንቀሴቴ። ባርኪ ኤልለ ናጋ ኦሸሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","የሱስ ደይ ባሶክ፦ «አሮ ዉዛንሶን ባሶኔን ካራካርሴድፌትሪ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ዳራሳስን እሳ አሱ ዎልግሬ፦ «አስሲኛኖ! ንባ ታርአ አያና ኤጵና ናታስን ኔክ ቴሸጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ካብፋና ካባሲክ ኤጳቱ ሀእፋ፤ ኖኖባስ ጉሳ ካርኤቱ ሀይባሶ ኮይፌ፤ ደይ ኮጝስር፤ ክሶነክ ነ ናዎሳክቶኒክ ማኬና ኣነ ችሞቶ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","የሱስ ዎልግሬ፦ «አማኖኖይ ኮንቶ ኣጌኔን ንቶኔን አነ ፎናሪንሶ? ኣጌኔን ንቶትን ፋኩናሪንሶ? ሀጝ ታክ ቴሾትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ባሶ ደይ ናስን ባርኪ ቴስሸሴቴን ባሪን ቢናይሴ ኪና አያናስ ጌሬጌሬ ናስን ጋንስራ ቶኮናክ ዛግራ ጉሳ ካርኤት ዳስታክ ቡካለ። ");
INSERT INTO jnje_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","የሱስ ናሳ አባንን፦ «ሀን ባር ኤጵናኔን አፑን ነያንሶ?» ይሬ ማምሲ። አሱስ ደይ ዎልግሬ፦ «ዳግባሴኔጝዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ሾዎ ዎና ትሽኩናክ ጌያስናዋ አካስና ጌዳር። ኔክ ችምቴፋናነ እኖክ ኬናሽቶዋ፤ ደይ አሪጋሱዋ» ይት ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","የሱስ ደይ፦ «ችምፋታነ ይፋቶሶ? አማነፌ ባርኪ ዙታምባሴ ችምቴርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ጌሬጌሬ ናሳ አባ፦ «አማነፋዉጝዋ! አማኖን ሆፕናሶን አሪጋሱዋ» ይት ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","የሱስ ደይ ዳራስ ኩይቴት ዮባሶን ብያት ኪና አያናሶን፦ «ነ ንባ ታቶ፤ ኦዶ ኦዮ አያናስ ናሳስን ኬስ! ሄፕስ ዎላ ግሩኖይታማቶ አጃጀፋን!» ይሬ ኬእ። ");
INSERT INTO jnje_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ናስ አካማኖን ቶኮናክ ዛግራ ቻጋ ኬስ። ሾዎቤሲስ፦ «ክት» ኡሶነኔን ዱግኖነ ፌር ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ስኑንታኖ የሱስ ኩሹባስ ዛቴ ካብግኒ የሬ። ");
INSERT INTO jnje_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","የሱስ ኬር ግርናኔን ኦርፎ ናዎባሳክቶ፦ «እንኖ ክሱክ ሆፕኒስ አዉኒ ቦርአንሶ?» ይሬ ባር ባሪን ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","«ሀን ኤፋስ ሶሞክናዋ ሺጶክና ስና ሻካናነ እሳንነ ኬሳክ ኣፋ ችማናዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","ኤስታን ኬሴሬ ጋሊላ ካሞ አቴ ሀሜቴ። የሱስ ናዎኒ ሜያክ አሲት ፌር ስንና ቦርአ ባር ፌና ድማሶን ኦኑ አሩናክ ኣኔ ሾሎዌ። ኤካ ደይ ይ፦ «አሱኒ ና አሱኒ ሜኒ ኩሹስ አቴሬ እምቶክ ዎርቴሬ ኬዝስናር ዎኖ ክቱኒ ካቡኒር።» ");
INSERT INTO jnje_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ኤስ ቾዋሲ ባሶክ ኣነ ጋሎዋ። ባሪን ማምሱክ ደይ ድጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","የሱስናዋ ናዎባሳክቶና ክፍርናሆም ዬሴቴ። ኬር ግርሴቴኔን ኦርፎ፦ «ንቶትና ንቶትና ኡግናስታ ኣምባንሶ ዎሉምሴትሪ?» ይሬ ባሶትን ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ስኑንታኖ ባሶ ኡጉነ ሀሜፌት፦ «ዙታምባሴ አሲሳታን አሪክር ኦ ስኑገሶ?» ይሴሬ ዎሉምሴቴ ቦርአ ሻክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","የሱስ ደይ ዲፋት አሲሬ ሄፔስኒ ባርኪ ቴጌሬ «ስና ዜምማክ ሾሌፌ ባር ዙታምባሴ አሲ ኦርፎ ስኖ፤ ደይ ዙታምባሴ አሲ ዎስትኛ ስናናክ ሾልስፋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","እሳ ዳጋ ናዋ ቴሸሬ ጋነቤሲስ ዬታት እድሜ፦ ");
INSERT INTO jnje_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«ሀኒስንነ ፋ ዳጋ ናንጎታስን እሳይሶን ታ ሱናሲክ እርባ ዛግሬ ኤጴቴፌ ባር ዙታምባሴ ታን ኤጴቶናዋ። ታን ኤጴቴፌ ባር ደይ ዙቴሬ ታን ዎሲ ባሪንቱ ኤጴቴቴኖ ታንታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ዮሀኒስ የሱስኒክ፦ «አስሲኛኖ! እሳ አሱ ነ ሱናሲክ ኪና አያናሶን ክስፌን ብያት እኖኔን አነ ስና ቤይና ቦርአ ካልንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ስኑንታኖ የሱስ፦ «ታ ሱናሲክ ቢስቴራ አሪቶኖይ ዉዛ ዎስቴፋት ጌሬጌሬ ታይስታ ማጙ ካማ ዎሎክ ችምንር ኣፌ ስንና ቦርአ ካላትታዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","እኖትን ቱጋኦኖይ ባር እኖኔን አነዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ፉቶ ንቶክ ማኬፋውጙዋ፤ ክርስቶስኒር ስኒት ቦርአ ታ ሱናሲክ እሳ ቶፎ አካ ንቶክ እማ ባር ዋግባ ኣፋ ትሹና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ቱስሬ ደይ፦ «ሀን ታክ አማነፋ ጋሮ ጋሮ ናንጎታስን እሳይሶን ቱሳስፌ ባር ዙቴሬ ፋያ ዎኒ ሹአ ሱትባስታ ታቴራ ትርእማሲ ሀቴፋናነ ማአና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ኩሹኔስ ቱሳሳናነ ካርአ ሀኡዋ። ሄፕ ኩሹነ ፋፋን ጌኒ ትርእማሲ ሀቶስታን ኩሹ ዱጙ ስንና ካኒ ኬር ግሩ ማአሪዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ጌኒ ትርእማሲ ቶባስ ክቱኖይናር፤ ጌባስ ትሹኖይናርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ዎቾኔስ ቱሳሳናነ ካርአ ሀኡዋ። ሄፕ ዎቾነ ፋፋን ጌኒ ትርእማሲ ሀቶስታን ዎቾ ፎንቶ ስንና ካኒ ኬር ግሩ ማአሪዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ጌኒ ትርእማሲ ቶባስ ክቱኖይናር፤ ጌባስ ትሹኖይናርዋ ");
INSERT INTO jnje_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ኣፍኔስ ቱሳሳናነ ዎእራ ክሱዋ። ሄፕ ኣፍነ ፋፋን ጌኒ ትርእማሲ ሀቶኔስኔን እሳ ኣፍነ ፋፋን ካኒ ኬር ግሩ ማአሪዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ጌኒ ትርእማሲ ቶባስ ክቱኖይናር ጌባስ ደይ ትሹኖይናርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«ማኣ ዙታምባሴ ካዎክ ሞቸራ ካይምፋናይሲማቶ አሱ ደይ ዙቴሬ ጌያክ ካይማናክ ሾልስፋ። ");
INSERT INTO jnje_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«ካዎ ማአሪዋ፤ ስኑንታኖ ካዎ ካኣርባ ፎንቶ ስንፋናነ አዉክ ካቱትሪንሶ? ካኒትስ ካዎኒ ካኣርአ ፎጝዋ። ንቶትና ንቶትና እሳ ሳፋራክ ፎቲ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","የሱስ ኤስታን ካብሬ ዮርዳኖስኖን ፍንነ ዩዳክ ዳስታክ ሀሚ። ሾዎ አሱ ባርኪ ኤስታ ሄፕሳ ዙቴሴቴን ዜሞቲ ዛግፌናይስማቶ አሲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","እሳ እሳ ፌርሳዊኒ ሜያ ዬሴሬ ባሪን ፋታኖክ፦ «አሱ አሱባሶን ጋፍኩናክ ቱማስ ማኬዎሶ?» ይሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","የሱስ ደይ ዎልግሬ፦ «ሙሴ ንቶክ ኣምባንሶ አጃጀናሪ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ባሶ ደይ፦ «ሙሴ ጋፍኩኒ ትቻሶን እሜ ጋፍኩናክ ማኬዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","የሱስ ዎልግሬ፦ «ንቶ ንብባሲ ችማክቱ ኤስ አጃጂሶን ትችዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ስኑንታኖ ‹ሀኦ ቴስቶስ ቴሱታ ኣርቃርናዋ ማሽካሬ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ኤስ ባሪ ቦርኣ አሱ አባባስንናዋ እንቶባሶንና ቤየ አሱባስኔን እሳር ስኒፌ። ");
INSERT INTO jnje_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ሄፖቤሲሴ እሳ አቱቱ ስኖነ›። ኤስ ባሪ ቦርኣ ባሶ እሳ አቱታኖ ሀንኔን ኤካሎ ሄፕቴዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ሀኦ እሳር ዛግና ባሮን ኤሴ አሱ ኦር ክሱናታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ኬር ግርሴቴኔን ኦርፎ ናዎባሳክቶ ሄፕሳ ኤስ ቾዋሶን ካቡግሴሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","የሱስ ደይ፦ «አሱባሶን ጋፍካት ኦማ አሱ ኤጵፌ ባር አሱባስታ ጌርኬስዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","አሱስ ደይ ቴጎባስኪን ኬሳ ኦምንክ ግሪፋናነ ጌርኬስዋ» ይት ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","የሱስ ጋሮ ጋሮ ናንጎታሶን ታፕቱናክ አሱኒ ሜያ ባርኪ ቴሸሴቴ። ኤስ ቴሸ ባሶትን ደይ ናዎባሳክቶ ካለሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ስኑንታኖ የሱስ ብያት ግኢቴሬ፦ «ጋሮ ጋሮ ናንጎታስ ታክ ዮሶን፤ ቤይት ካላትታ። ሀኦሲ ታቶ ሀን ባርኪቶነ ፋይስርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ፉቶ ንቶክ ማኬፋውጙዋ፤ ሀኦሲ ታቶኖን ዳጋ ናዋነ ፋሮን ዛግሬ ኤጴቶኖይ ባር እሳንነ ኣፋዋ ግሩና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","እድሜ ኩሹባሲክ ታእሬ ሱስ። ");
INSERT INTO jnje_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","የሱስ ኡግና ሀማናክ ኬስፌን እሳ አሱ ባርኪ ኤልለ ዬሬ ስኒባ ካአነፋት፦ «ጋራም አስሲኛኖ! ኮእባ ፎንቶ ካ ዳናናክ አዉ ዛጉናሪንሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","የሱስ ዎልግሬ ኤካ ይ፦ «አዉኒሮን ታን ጋራም ይፋሶ? እሳ ሀኦሲኔን ኦማ ጋራማ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","አጃጂስ ደይ፦ ‹ካ ዎሩታታ፥ ጌርኬሳታታ፥ ዊሶታታ፥ ኤሻ ዛላ ማኮታታ፥ አሱኒን ኤሻታታ፥ አባነስንናዋ እንቶኔሶንና አሲን ኡልፍንሱ› ይፋናማቶ አሪታርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","አሱስ ዎልግሬ፦ «አስሲኛኖ! ኤስ ባሮን ዙትራ ጋሮናሴኔን ኦዳቱ ፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","የሱስ ቢሬ ኬሽቴ፤ ደይ ኤካ ይ፦ «እሳ ዉዛቱ ኔኪን ዮእርዋ። ሀምፋት ፋ ኦቱምኔሶን ዙትራ ክስራ ዋጋት ቱካምኒ ሜያክ እማ። ደን ሳማኪ ኦትማ ዳናታዋ። ኤካት ዬን ታኔን አነ ሀሚንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ስኑንታኖ ኤስ ቾዋሲክ ስኒባስ ካራየ። አካማ ኦቱምባ ፋር ስንና ቦርአ ሱሜት ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","የሱስ የርቀሬ ብያት ናዎኒ ሜያክ፦ «ኦቱምቤስ ፋና ባሶክ ሀኦሲ ታቶስ ግሩ አዉነ ፋሮን ትርኦንሶ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ናዎኒ ሜያ ኤስ ማኬና ካማሲክ ዲንቀሴቴ። ስኑንታኖ የሱስ ቱስሬ፦ «ናንጎትኖ! ሀኦሲ ታቶስ ግሩ አዉነ ፋ ትርኦንሶ! ");
INSERT INTO jnje_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ኦቱም አሱ ሀኦሲ ታቶስ ግሩባስታን ጋላ ማሩፍን ኣፍስ ካሞ ኣትባስቱ ካሾዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ናዎኒ ሜያ ዜሞቲስታን አካማኖን ዲንቀሴፋት ባሶትና ባሶትና፦ «ኤሴኑ ኦ ፋሩክ ችምንሪንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","የሱስ ባሶትን ብያት፦ «ፉቶሲክ ሀን ባር አሱኒክ ኣፋ ችምቶና ዉዛ። ስኑንታኖ ሀኦሲክ ችምቴር። ሀኦሲክ ዙታምባሴ ችምቴርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ጴጥሮስ ደይ፦ «ኤሴኑ እንኖ ዙታምባሴ ቤያ ነኔን አነ ያንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","የሱስ ዎልግሬ፦ «ፉቶክ ንቶክ ማኬፋውጙዋ፤ ታክናዋ ምስራቹኒ ካማሲክና ኬባሶን ወደይ አይባሳክቶኒን ወደይ ኤትባሲክቶኖን ወደይ እንቶባሶን ወደይ አባባስኒ ወደይ ናንጎትባሶን ወደይ ቡሎባሶን ቤያ ባር ዳይስሬ ዳናናዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ሀሽ ሀን ነያሲክ ካቡግቶክ ኬያሶን፥ አይሳክቶኒን፥ ኤትሲክቶኖን፥ እንቶሲክቶኖን፥ ናንጎታሶን፥ ቡሎሶን ትያ ኩሹኖን ዳናና። ዮን ነያሲክ ደይ ኮኢባ ፎንቶ ካ ዳንኖር ኦኑ ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ስኑንታኖ ስና ዜምሜ ፌ ሾዎኒ ሜያ ኦርፎ ዎልሶነ። ኦርፎ ዎል ሌፌ ባሶ ደይ ስና ዜሞነ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ደን የሩሳሌም ሀሚፋ ኡግናሲክ ሀሜፌን የሱስ ስና ዜምሜት ፌር ስንና ቦርአ ናዎባሳክቶ ዲንቀሴቴ። ኦርፎባሴ ሀማ ባሶ ደይ ድግሴት ፌሴቴር። ሄፕስ ደይ አሲሬ ሄፔ ናዎባሳክቶኒን ባርኪ ታእስሬ ባሳስታ ካርአናክ ፋ ቾዋሶን ባሶክ ማኮ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«ኤሴ የሩሳሌም ሀሚንርዋ። አሱኒ ና ማግኒ ጋኛንክናዋ ሙሴኒ ቱማሲ አስሲኛኒ ሜያክና አቴሬ እምቶኒር። ባሶ ደይ ክቱኒ ማጝሱኒ ካርአ ባሳስታ ካርኦነር። አዛብኒ ሜያክ ኣትሬ እሞነር። ");
INSERT INTO jnje_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ባሶ ደይ ካኞነር፥ ቱጆሶነር፥ እቾነር ደይ ዎርሶነር፥ ስኑንታኖ ኬዝ ዎናኔን ኦርፎ ክቱኒ ካቡኒር» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ኤሴን ኦርፎ ዛብድዮስኒ ናንጎት ያቆብናዋ ዮሀኒስና የሱስኒክ ዬሴሬ፦ «አስሲኛኖ! እንኖ ማምሱን ቾዋሶን ዙትራ ዛጉታክ ሾሌፌንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","የሱስ ደይ፦ «ንቶክ አዉ ዛጉናኪንሶ ሾሌፌትሪ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ባሶ ደይ ዎልግሬ፦ «ነ ታቶስ ኡልፍንቶኒ ካባሲክ እሳርኒስ ኦእታ ቴሽኔስታ እሳርኒስ ደይ አልዳ ቴሽኔስታ ዱኒክ ማእ ኡዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ስኑንታኖ የሱስ፦ «ማምሲፌት ባሮን ኣነ አሪፌትዋ። ታ ኡሻናክ ፋ ሻናን ኡሻሶን፤ ታ ሀጱክቶናክ ፋ ሀጱክቶሶን ሀጱክቶትክ ችማትሮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ባሶ ደይ፦ «ኣ፥ ችማናዋ» ይሴቴ። የሱስ፦ «ታ ኡሻናክ ፋ ኡሻሶን ኡሻት፤ ታ ሀጱክቶናክ ፋ ሀጱክቶሶን ሀጱክቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ስኑንታኖ ኦእትናስታናዋ አልድናስታና ዱስ ሆሬና ባሶክታኖ ኤስ ባሮን እምኒስ ታቴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ፉእቴ አሲር ናዎሳክቶ ኦደሴሬ ያቆብኒስታናዋ ዮሀኒስኒስታና ግእቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","የሱስ አሲሬ ሄፔ ናዎሳክቶኒን ባርኪ ቴጌሬ ኤካ ይ፦ «አዛብኒ ሜኒ ጋኛ ይስቴፌ ባሶ ዳራቤሲስን ሁግናክ ሀኢስሴፌማቶ አሪሴፌት። ኤሲስማቶ ደይ ዞንሲሴፌ ባሶ ደይ ኤስ ዳራሳታ ሀእሱኒ ቱማ ሁግናቤስ ፋናማቶና አሪሴፌት። ");
INSERT INTO jnje_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ስኑንታኖ ንቶኪክ ኤካታዋ። ንቶስኒ አሪክር ስናክ ሾሌፌ ባር ንቶ ዎስትኛ ስኖዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ንቶስኒ ኦኑ ዜምማክ ሾሌፌ ባር ዙታምንትሴ አሲ ቦዝ ስኖዋ። ");
INSERT INTO jnje_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ኤሲስማቶ አሱኒ ናስኑ ዎስቶናክናዋ ካባሶን ሾዎኒ ሜያኖን ፉሮክ ኣትሬ እማናክታኖ ባርኪ ዎስቶሶነክና ኣነ ዮዌዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","የሱስ ናዎኒ ሜያኔን እያሪኮ ዬሴቴ። ኤስታን ኬሴፌን ሾዎ ዳራ ባሶኔን አነ ሀሜድፌር። ኡግናስ ሀእታ ደይ ቴሜዎስኒ ና ኣፍትሹ ባርጠሜዎስ ዲፋት ሺጴት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ናዝሬትክ የሱስ ስኒባሶን ኦደናይሴ፦ «ዳዊትኒ ዛላስኒ ኮንቴ የሱስኖ! ታን ማሮዋ» ይት ቻጋ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ሾዎ አሱኒ ሜያ ሻኩናክ ኬእሴቴ። ስኑንታኖ ባር፦ «ዳዊትኒ ዛላስኒ ኮንቴ ናሶ ታክ ኬናሽቶዋ» ይት ኣታምሲሬ ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","የሱስ የሬፋት፦ «ቴጎትዋ!» ይ። ባሶ ደይ ኣፍትሹስኒ፦ «ሀሬዋ! ካቡዋ ኔን ቴጌድፌዋ!» ይት ቴግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ባር ደይ ጌሬጌሬ ካብሬ ቱካስታክ ማይባሶን ሀኣት የሱስኒክ የ። ");
INSERT INTO jnje_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","የሱስ ዎልግሬ፦ «አዉ ኔክ ዛጉናክ ሾሌፋሶ?» ይ። ኣፍትሹስ ደይ፦ «አስሲኛኖ! ብያናክዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","የሱስ ደይ፦ «ሀማ፥ አማንቶኔስ ኔን ፋትዋ» ይ። ጌሬጌሬ ብየት ኡጉነ ባሳ ኦርፎሴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","የሱስናዋ ናዎባሳክቶና የሩሳሌም ታእሴሴፌ ካባሲክ ቤቴፋጌነዋ ብታኒያነ አሲስ ካሞ ዳብራዛይትኒ ኩማስታ ካርኤቴ። ኤስታን ናዎባሳስን ሄፕን ኤካ ይት ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«ኤክ ስኒትስታ ፋ ኬኤስ ሀሚት። ኤስታ ካርኤትሴ ኦኑ ባርስታ ዱኖይና ሀኛን ናዋ ቱፕቴራ የሬፌኒ ዳናት። ኮታ ሀጝ ኤጳ ዮትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ኦኑ፦ ‹አዋጋን ሀን ባሮን ዛግድፌትሪንሶ?› እያናነ ‹ዳሚሲክ ሾልስና ቦርአ፥ ሀሽ ጌሬጌሬ ዎልግሬ ጋፍኩና› » ኡት። ");
INSERT INTO jnje_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ባሶ ደይ ሀሜቴን ሀኛን ናዋ ኡግናስ ቴሽታ ኬን ፎቻታ ቱፕቴራ የሬፌኒ ዳነሬ ኮቴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ኤስታ የርሴ ባሶስኒ እሳ እሳይስ፦ «ሀኛስ ናዋኖን አዉኒሮን ኮትድፌትሪንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ባሶ ደይ የሱስ አጃጀናስማቶ ማክሴቴ። አሱኒ ሜያ ደይ ዎል ሌ ቤየቴ። ");
INSERT INTO jnje_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ናዎሳክቶ ሀኛሶን የሱስኒክ ኤጴ ዬሴቴ። ማይቤሲሶን ጌሾባስታ ኩኑሴቴን ባርስታ ድ። ");
INSERT INTO jnje_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ሾዎ አሱኒ ሜያ ማይቤሲሶን ኡግናስታ ይርኤቴ። ኦሚስ ደይ እኦኒ ቶሻ ኪርኤ ይርኤት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ስና ዜምማ ባሶናዋ ኦርፎባሴ ዬሴፌ ባሶና ዙቴሬ፦ «ሆሳና! ዳሚሳ ሱናክ ዬፌ ባር ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ዳሚሳ ሱናክ ዮን አባን ዳዊትኒ ታቶስ ሱስቶዋ። ሆሳና ደን ሳማኪ» ይት ቻጌት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","የሱስ የሩሳሌምክ ቤቴሜቅደሲሲ ግር። ብራቴሬ ዙታምባሴ አሲን ቢናንኔን ኦርፎ ጌሮክ ዋልድፋር ስንና ቦርአ አሲሬ ሄፔ ናዎባሳክቶኔን ብታኒያ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ዎኖትር ዎኖ ብታኒያን ኬሴፌን የሱስ ማክቴ። ");
INSERT INTO jnje_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ቶሽባሬ የሬ ቤለስኒ እኦ ዎክሶክ ብያት ጋና ባርስኒ ቤስቶኒቶ እያት ባርኪ ሀሚ። ስኑንታኖ ጋንፋና አስባ ስና ቤይና ቦርአ ቶሻ ቶሻታኖ እሳንነ ዳና ጋና ኣፋ። ");
INSERT INTO jnje_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ኤስ ባሪ ቦርኣ ቤለሲሶን፦ «ሀውጙኔን ኤካሎ ኦኑ ኔኪን እሳንነ ጋና ሙናታዌ» ይ። ናዎባሳክቶ ደይ ኤስ ባሮን ኦደሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","የሩሳሌም ካርኤፌ ካባሲክ ቤቴሜቅደሲሲ ኦጅን ኬርካሎ ግሪሬ ኤስታክ ክስሬ ዋግሴፌ ባሶትናዋ ጌሮን ዋግሴፌ ባሶትና ካሌ ክሱ ኤጲ። ዋጋ ሶለት ፌ ባሶ ታራቤዛሶናዋ ናካሎ ዋጌፌ ባሶ ኮዳሶና ሸልግሬ ሀእ። ");
INSERT INTO jnje_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ኤስታን የሱስ፦ «ኦኑ እሳ ዉዛ ዎርኤ ቤቴሜቅደሲሲ ኬርካሎ ግሩናታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ደይ ኤስታ ፌ አሱሲክ አሲፌና ካባሲክ ኤካ ይ፦ «‹ኬናስ ዳራ ዙታምባሴ አሲ ሀኦኒ ሺጶኒ ኬያዋ› ይስቴራ ኣነ ትቾዋኖሶ? ስኑንታኖ ንቶ ቦእኛኒ ዱጋዱግ ዛግትዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ማግኒ ሜኒ ጋኛን ሜናዋ ሙሴኒ ቱማሲ አስሲኛስና ኤስ ባሮን ኦደሴቴ። ዳራስኔን ዙቴሬ ባሳ አሱሲክ ዲንቀት ፌሴቴር ስንና ቦርአ የሱስኒን ድጌሴቴ ኤስ ባሪ ቦርኣ ኣካክ ዎርሶነማቶ ሾልሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ዋልፋና ካባሲክ ደይ የሱስናዋ ናዎባሳክቶና ካታማስን ጌራካሎ ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ኤእሶ ዎኒሳክ ኡጉነ ሀሜፌን ቤለሲስ ታስባስኔን እችማ ዲፌን ብየቴ። ");
INSERT INTO jnje_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ጴጥሮስ ንባስታ ኬጅፋን፦ «አስሲኛኖ! ነ ኤርውታ ቤለሲስ እችምዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","የሱስ ባሶክ ዎልግሬ ኤካ ይ፦ «ሀኦሲክ አማኖትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ፉቶ ንቶክ ማኬፋውጙዋ፤ ኦኑ ንብባሲ ስኑጙጋሶ ኡኖይ ማኮና ባር ዛግቶናማቶ አማነሬ ሀን ኣማሶን፦ ‹ዋቴራ ባሪስ ሀእቶዌ› እያናነ ባርኪ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ኤስ ባሪ ቦርኣ ሺጶክ ማምሲት ዉዛሶን ዙትራ ዳንትር ዛግራ አማኖትዋ ንቶክ ስናና። ");
INSERT INTO jnje_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ሺጴፌት ካባሲክ ደን ሳማኪ ፌ አባንቲስ ቦርንትሶን ፌሹን ኡናክ አሱኒስታ እሳ ቾዉኒት ፋፋናነ ፌሹን ኡትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ስኑንታኖ ንቶ አሱሳ ማጝሱኖን ፌሹን ኡ ሻካትነ ደን ሳማኪ ፌ አባንቲስ ቦርንትሶን ኣፋ ፌሹን ኡናዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ሄፕሳ ደይ የሩሳሌም ዬሴቴ። የሱስ ቤቴሜቅደሲሲ ኩትፌን ማግኒ ጋኛን ሜያ፥ ሙሴኒ ቱማሲ አስሲኛናዋ ኩርኡኒ ሜና ባርኪ ዬሴሬ፦ ");
INSERT INTO jnje_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«ሀን ባሮን አዉኒ ሀእሱኒ ሁግናኪንሶ ዛግኢፋ ዛግድፋታሪ? ወደይ ሀን ባሮን ዛጉታክ ሀእሱኒ ሁግና ኔክ እማር ኦንሶ?» ይት ማምሲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","የሱስ ደይ፦ «ታ እሳ ማምሱ ንቶትን ማምሱናዋ። ኤስ ማምሱናሶን ዎልግፋትነ ታ ደይ ሀን ባሮን አዉኒ ሀእሱኒ ሁግናክ ዛግፋናማቶ ንቶክ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ዮሀኒስኒ ሀጵቁስ ሀኦስኪን ያሪጝዋ ወደይ አሱኒኪኒንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ባሶትና ባሶትና ኤካ ይሴቴ፦ «ሀኦኪን ያር እያንነ ኤኪን አዉኒሮን ባር ማኬና ባሮን አማኖ ቤይትሶ? ኡኒር። ");
INSERT INTO jnje_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ኤሴ አሱኒኪን ኡንሮሶ?» ኤካ ኡሶኖይቴማቶ አሱ ዙቴሬ ዮሀኒስኒን ፉቶሲክ ሀኦኒ ራጁዋ ይሴት ፌሴቴር ስንና ቦርአ ዳራስን ድጌሴቴ ");
INSERT INTO jnje_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","የሱስኒክ ዎልግሬ፦ «ኣነ አሪፌንዋ» ይሴቴ። የሱስ ደይ፦ «ታ ደይ አዉኒ ሀእሱኒ ሁግናክ ሀን ባሮን ዛግፋናማቶ ኣፋዋ ንቶክ ማኮና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ቤሶክ ደይ አሱናክ ካብ፦ «እሳ አሱ ዋይንኒ ሻ ቶኬ፥ ኦጃ ኦጅጀ፥ ጋንባሶን ትኡና ዶአ ዪሸ፥ ቶሎ ኬርእ። ኤስታን ቡልኛን ሜያክ ክራ እማት ዎካ ድማ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ኬጵቶና ዎንባ ካርፋና ካባሲክ ጋንባስታን ኤጴ ዮናክ ዎስትኛስን ቡልኛን ሜያክ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ባሶ ደይ ኤጴ እቸሬ ኩሽኩሽ ጋፉክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ሄፕሳ ኦም ዎስትኛኒን ባሶክ ዎሲ። ኤስ ባሪን ደይ እቼ ቴትባሶን ካርኤሬ ሳልጲስሬ ጋፉክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ቱስሬ ኦምንን ዎሲ፤ ኤስ ባሪን ደይ ዎርሴቴ። ኦም ሾዎኒን ዎስኒ እሳ እሳይስን እቸሴቴ ደይ እሳ እሳይስን ዎርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ፉእቴ እሳ ኬሽቴፌና ናባስኒ፦ ‹ናታስን ባሶክ ዎሳናነ ኡልፍንሱቤስዋ› እያት ዙታምቤሲሴ አሲ ኦርፎስታ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ስኑንታኖ ኤስ ቡልኛን ሜያ ባሶትና ባሶትና፦ ‹ፎኦሻሶን ቶኒስ ሀን ባርዋ! ያን ዎራት ፎሻሶን እንኖር ዛጉንዋ› ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ኤስታን ኤጴ ዎርሴሬ ዋይኒስ ፎሽን ጌራካሎ ሀእሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«ኤሴ ዋይኒስ ዳም አዉ ዛጉንሪንሶ? ዬሬ ቡልኛን ሜያኖን ዎራት ዋይኒስ ፎሻኖን ኦምን ሜያክ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ኤሴ፦ « ‹ሹኢን ኬያሶን ኬርእፌ ባሶ ጎነሴቴ ሹኣስ፤ ሹኢን ኬያስ ካጃታ ዱን ሾልሱ ሹአ ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ኤስ ባርኑ ዳሚስኪንቱ ስኒዋ፤ ቢፌ እኖክኑ አካማኖን ዲንቂዋ!› » ይፋ ትቻሶን ኣነ ፌሬትራ ብየትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ማግኒ ጋኛን ሜያ፥ ሙሴኒ ቱማሲ አስሲኛናዋ ኩርኡኒ ሜና ኤስ ማኬና ቤሶስ ባሶስታ ስኒባሶን አሪሴቴ ቦርአ ባሪን ኤጴ ታርአክ ሾልሴቴ። ስኑንታኖ ዳራስን ድግሴፋት ቤየ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ዎሉምባሲክ ባሪን ኤጳክ እሳ እሳ ፌርሳዊኒ ሜያክናዋ ሄሮድስኒ ኬን ስና ባሶትና የሱስኒክ ዎስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ባርኪ ዬሴሬ፦ «አስሲኛኖ! ነ ፉእቶኒር ስኒታማቶ አሪፌንዋ። አሱኒ ስና ቢራ ኮሩኖይ ወደይ አሱ አዉ ኡና ኡክ ዛግፋታ ዉዛ ኣፋዋ። ፉቶክ ሀኦሲ ኡግናኖንቱ አሲፋትዋ። ማኮዋ፥ ሮምን ታቴ ሜኒ ታቶስኪ ግርቦን እማ ሾልሱጝዋ ወደይ ሾልሱታንሶ? እማንርጝዋ ወደይ ካላንሪንሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ስኑንታኖ ባር ስርቤሲሲክ ማጙኖን አራት፦ «አዉኒ ቦርአ ታን ዎላክ ታካሎክ ሾሌፌትሶ? እሳ ሳንትብ ቴሸን ብዩጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ባሶ ደይ ቴሸሴቴ። የሱስ ደይ፦ «ሀን ግቶሴዋ ትችባሴ ኦንሪንሶ?» ይሬ ማምሲ። ባሶ ደይ፦ «ሮምን ታቴ ሜኒ ታቶሳርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","የሱስ ደይ፦ «ኤሴ ታቶሳሮን ታቶስኪ፤ ሀኦሲሮን ሀኦሲክ እምትዋ» ይ። ዎልጉባሲክ ደይ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","«ክቱኒ ካቡ ኣፋ» ይሴፌ እሳ እሳ ሴዱቃውን ሜያ ባርኪ ዬሴሬ ኤካ ይት ማሙሴቴ፦ ");
INSERT INTO jnje_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«አስሲኛኖ! ‹እሳ አሱ ናዋ ኮኑኖይ አሱባሶን ሀኣት ክትፋናነ አይባስ ደይ ኤስ አሱሶን ኤጴ ዛልባ ስናናክ አይባሲክ ኮኑዎ› ይሬ ሙሴ እኖክ ትች። ");
INSERT INTO jnje_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ኤሴ ናፉን አይን ሜያ ፌሴቴር። ቴሱኒ ባር አሱ ኤጴ ናዋ ኮኑኖይ ክት። ");
INSERT INTO jnje_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ሄፕሳስ ደይ ኤጴ ናዋ ኮኑኖይ ክት። ኤሲስማቶ ኬሳስ ደይ ኤካ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ናፉኖቤሲሴ አሱሶን ኤጴ ናዋ ኮኑኖይ ክትሴቴ። ዙታምቤሲሴ አሲ ኦርፎታ አሱስ ደይ ክት። ");
INSERT INTO jnje_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","አሱሶን ናፉኖቤሲሴ ኤጴቴ ስንና ቦርአ ክቱኒ ካቡኒ ዎኖ ባሶስኒ ኦንክ አሱ ስኒሪንሶ?» ");
INSERT INTO jnje_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","የሱስ ዎልግሬ ኤካ ይ፦ «ትቻሶናዋ ሀኦሲ ሁግናኖንና ኣነ አሪፌት ስንና ቦርአ ዳጌፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ክት ባሶ ክቱኒ ካብሴፌ ካባሲክ ደን ሳማኪ ፋሴ ሀኦሲ ዎስኒማቶቱ ፎሶነታኖ ኤጵነ ግሩነ ኣፋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ስኑንታኖ ክቱኒ ሜያ ክቱኒ ካብሶነማቶ ሀኦሲ፦ ‹ታ አብራሀምኒ ሀኦ፥ ይሳቅኒ ሀኦ፥ ያቆብን ሀኦዋ› ይት ኤስ ሳባሲክ ጌያስ ቾዋክ ማኬፋ ድማስታ ሙሴኒክ ማኬና ባሮን ሙሴኒ ትቻስ ኣነ ፌሬትራ ብየትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ባር ሀየዉን ሜኒ ሀኦታኖ ክቱኒ ሜኒ ሀኦታዋ። ኤስ ባሪ ቦርኣ ንቶ አካማኖን ዳጌፌትዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ሙሴኒ ቱማሲ አስሲኛሳስኒ እሳይስ ባሶ ካራካሮሶን ኦደ። የሱስ ማአሮን ዎልጉባሶን ጋሳሲፋት ባርኪ ዬሬ፦ «ዙታምባሴ አሲስታን ደናሎ ሾልሱ አጃጂስ ኣፋሪንሶ?» ይሬ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","የሱስ ዎልግሬ፦ «አጃጅ ዙታምባሴ አሲስታን ደናሎስ፦ ‹እስራኤልኖ ኦዶዋ! እንኖ ዳማ ሀኦኒስ እሳ ዳማዋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ነ ደይ ቱማ ንብኔሲክ፥ ቱማ ካኔሲክ፥ ቱማ ሳፋራኔሲክ፥ ቱማ ሁግናኔሲክ ዳማ ሀኦኔሶንጝዋ› ይፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ሄፕሳ አጃጂስ ደይ ኤካዋ፦ ‹ዎልኮኔስኒ ነ ኔን ሹንፋጝዋ› ኤሲስታን ደናሎ ኦማ አጃጅ ኣፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ቱማስ አስሲኛ ዎልግሬ፦ «ማአሪዋ፤ አስሲኛኖ! ‹ሀኦሲ እሳርዋ፤ ባርኔን ኦማ ሀኦ ኣፋዋ› ይራ ፉቶክ ዎልግትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ቱኡማ ንባክ፥ ቱማ ሳፋራክ፥ ቱማ ሁግናክ ባሮን ሹን። ደይ ዎልኮኔስኒ ቴትኔሶን ሹንፋታስማቶ ሹና ኪቼፋ ማኣስታናዋ ኦማ ኦማ እማስታና ደናሎዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","አሱስ አሩክ ዎልግናማቶ የሱስ አራት፦ «ነ ሀኦኒ ታቶስን ዎካ ፋታርታዋ» ይ። ኤሴን ኦርፎ ኦኑ ማምሱን ማምሱክ ኣነ ችሜ። ");
INSERT INTO jnje_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","የሱስ ቤቴሜቅደሲሲ አሲፌት ኤካ ይ፦ «ሙሴኒ ቱማሲ አስሲኛኒ ሜያ፦ ‹ክርስቶስ ዳዊትኒ ዛላስኒ ኮንቴ ናዋ› ኣካክ ይሴፌሶ? ");
INSERT INTO jnje_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ዳዊት ቴትባሲክ ኮርቶ አያናክ ዞኑስቴሬ ማኬፌና ካባሲክ፦ « ‹ዳሚስ ዳምታሲክ ጉማኔሳክቶኒን፤ ዎቾኔስ ስካሎስ የርአታክ ዛጉና ካባኔን፤ ኦእታ ቴሽናስታ ዱዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«ዳዊት ቴትባሲክ ‹ዳምታ› ኡቱ ይዋ። ኤካኒ ኣካክ ዳዊትኒ ዛላስኒ ኮንቴ ናባ ስንኒሪንሶ?» ሾዎ ዳራስ ደይ ግራክ ኦደሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","የሱስ አሲፌና ካባሲክ ኤካ ይ፦ «ድቻ ድቻ ማያ ማየ ኤክ ሀጝ ኩቱ፥ ጋባስታክ አሱ ናጋ ኦሾናክ ሾልሴፌ ቱማስ አስሲኛኒ ሜያኪን ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ባሶ አይሁድኒ ሺጶኒ ኬያሲክ ቴጋ ኮዳ፥ ኮታ ማስቴፋናስታ ቴጋ ድማቱ ሾልሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ድቻ ቱካማ አሱሲክቶኖን ፋ ዉዝባሶን ኤጴፌ። ደይ ድቻ ሺጶኒ ሺጶክ ቢስቶክዋ እያት ኤስ ኤፋቴና ዉዛ ዛግሴፌ ባሶ አካማ ማጝሱኒ ካርአቱ ኤጴቶሶነዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","የሱስ እምቴ እማ ዙቴፋና ሳጥኒስ ስኒታ ዲፌን አሱኒ ሜያ ዋጋ ስር ሀእሴፌን ቢ። ሾዎ ኦቱምኒ ሜያ አካማ ዋጋ እሜት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","እሳ ቱካማ ድቻ አሱ ዋግባስ እሳ ዱደ ስና ሄፕ ጋሮ ጋሮ ናስን ሳንትብ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ናዎኒ ሜያኖን ቴጌሬ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፥ ዋግቤሲሶን እማ ባሶ ዙታምቤሲሴ አሲስታን ደናሎ ሀን ቱካማ አሱስ አሪክስራ እምዋ። ");
INSERT INTO jnje_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ዙታምቤሲሴ ባሶክ ሆሬራ ፉእቴሶንቱ እሜቴዋ። ስኑንታኖ ሀን አሱስ ቱካማ ስኒፋት ባርኪ ፋዪሶን ፉኦኖይ ዙትራ እምዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","የሱስ ቤቴሜቅደሲሲኒ ኬስፌን ናዎኒ ሜያስን እሳይስ፦ «አስሲኛኖ! ሀን ሹአሲክቶነዋ ሀን ሹን ኬያሲክቶነ አዉነ ፋ ዲንቂ ስንናማቶ ቢዋ» ይት ማኬ። ");
INSERT INTO jnje_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","የሱስ ደይ ዎልግሬ፦ «ሀን እኛ እኛ ሹን ኬያሲክቶኖን ቢድፋ ቶሶ? ሀን ሹኣሲክቶ እሳ እሳይስታ ዲራ ፉእቶኒር ኣፋዋ። ዙቴራ ቦክቴርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","የሱስ ቤቴሜቅደሲሲ ስኒታ ፋ ዳብራዛይትኒ ኩማስታ ዲፌን ጴጥሮስ፥ ያቆብ፥ ዮሀኒስናዋ አንድርያስና ባሶ ባሶ ባርኪ ታእሴሬ፦ ");
INSERT INTO jnje_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«ሀን ባር ኣጌንሶ ስናናሪ? ሀን ባር ዙታምባሴ ስኒፋና ካባሲክ ቤሶባስ ኣምባንሶ? እኖክ ማኮዋ» ይሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","የሱስ ደይ ኤካ ይ፦ «ኦኑ ንቶትን ኤሽኖይናማቶ ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ሾዎኒ ሜያ፦ ‹ታ ክርስቶስዋ› ይት ታ ሱናሲክ ዮሶነ። ሾዎኒ ሜያኖን ደይ ኤሾነ። ");
INSERT INTO jnje_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ኔቦን ቾዉነዋ ኔቦን ኦዱነ ኦደፌት ካባሲክ ድጎትታዋ። ኤስ ባር ደይ ስናናክ ፋርዋ። ስኑንታኖ ኮእባስ ሀሽታዋ። ");
INSERT INTO jnje_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ዳራስ ዳራሳታ፤ ታቶስ ታቶስታ ካቡና። ሾዎ ድምታ ደይ ዳኒ ሾርኮነዋ ማክነ ስናና። ኤስ ባር ደይ አካማ ኬክቶኒ ቴሱዋ። ");
INSERT INTO jnje_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«ንቶ ደይ ቴትንትሶን ኦድትዋ። ሾንጎን ኩጳማስታ ንቶ አቴራ እምቶት። አይሁድኒ ሺጶኒ ኬያሲክ እቾሶት። ዛላ ስናትክ ታክዋ እያት ሀእስፌ ባሶ ስናናዋ ታቴ ሜና አሲ ስናና የሮት። ");
INSERT INTO jnje_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ኤስ ባር ስኒባስኔን ዜምማ ምስራቹኒ ካማስ ዳራ ዙታምባሴ አሲክ ማክቶናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ንቶትን ኤጴ ኣትሬ እሜፌ ካባሲክ፦ ‹አዉታሶ ማኮኒ?› ኡክ ዜምማ ራካቶትታዋ። ስኑንታኖ ኤስ ካባሲክ ንቶክ እምቶኒ ባሮን ማኮት። ማኮኒስ ደይ ኮርቶ አያናታኖ ንቶቴዋ። ");
INSERT INTO jnje_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","አዪስ አይባስን፥ አባስ ናባስኒ ክቱክ ኣትሬ እማና። ናንጎታስ ኮኒ አባ እንቶስታ ማጙክ ካብሴራ ዎርሶና። ");
INSERT INTO jnje_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","አሱ ዙታምባሴ አሲ ስና ታ ሱናስ ቦርአ ኦምቴስቴር ስናት። ስኑንታኖ ኮእባ ካርአናኔን ችሜ የሬ ባር ፋሩና። ");
INSERT INTO jnje_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«ደይ ዝና ዉዛስ ካይማ ድማሶን ኪንፋ ባርኪ ሾልሱኖይ ድማስታ የሬፌኒ ብያትነ ፌሬትፌ ባር ያዳቶዎዋ። ኤስ ካባሲክ ዩዳክ ፌሴ ባሶ ኣማሲክ ኤሎቶ። ዝናስ ኮርቶ ድማስታ የሬፌኒ ቢፌት ካባሲክ ፌሬትፌ ባር ጋሳሱዎዋ ");
INSERT INTO jnje_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ኬያስ ቱክታ ፌ ባር ዳ ኬሬሬ እሳ ዉዛ ኤጳክ ኬር ግሩናታ። ");
INSERT INTO jnje_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ፎኦሻስታ ፌ ባር ማይባሶን ኤጳናክ ኦርፎ ዎሉናታ። ");
INSERT INTO jnje_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ኤስ ካባሲክ ናኔርሴዋ ናዋ ታንፋ አሱሲክቶነ የሬፋዉጝዋ! ");
INSERT INTO jnje_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ስኑንታኖ ኤስ ዎናስ ዬሹስ ስኖይናማቶ ሺጶት። ");
INSERT INTO jnje_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ኤስ ካባሲክ ሀኦ ቴስና ቴስቶስታን ካብራ ሀሽ ሀውጙኔን ካርአ ቢስቶኖር ወደይ ሀንኔንኑ ስኖይ ሻና ስናና። ");
INSERT INTO jnje_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ዳሚስ ኤስ ዎናሲክቶኖን ካዉንሱ ሻክ ስንፋናነ አሻ ማዮ አሱ ዙታምባሴ ፉእቶና ካባታዋ። ስኑንታኖ ባር ኮርና አሱኒ ሜኒ ቦርአ ዎናሲክቶኖን ካዉንስ። ");
INSERT INTO jnje_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«ኤስ ካባሲክ ኦኑ ስኖ፦ ‹ክርስቶስ ሀንታ ፌርዋ› ወደይ ‹ኤኬስታ ፌርዋ› ይፋናነ አማኖትታ። ");
INSERT INTO jnje_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ኤሽ ክርስቶስኒ ሜናዋ ኤሽ ራጁኒ ሜና ዮሶነር። ኤስ ባሶ ችምቴፋናነ ሀኦ ኮርና ባሶትኑ ዳግሱክ ቤሶነዋ ቢስቴራ አሪቶኖይ ዉዝነ ዛግሶነ። ");
INSERT INTO jnje_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ኤሲሲክቱ ታ ዙታምባሴ አሲን ዜምማ ንቶክ ማኬን ስንና ቦርአ ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«ኤስ ካባሲክ ኤስ ሻናስኔን ኦርፎ፦ ‹አዋስ ታልሞና፤ አሳስ ደይ ኣፋ ቻሮና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ባኩራሲክቶ ሳማን ዝግቶሶና፤ ሳማኪ ፋ ሁግናሲክቶ ደይ ሾርኮና› ");
INSERT INTO jnje_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ኤስ ካባሲክ አሱኒ ና አካማ ሁግናክናዋ ኡልፍናክና ሻሩስ ዬፌን ብዮነ። ");
INSERT INTO jnje_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ባር ደይ ሀኦሲ ዎሲያኖን ዎስሬ ዳ ዳስን፥ ዳስ ድልታን ካብራ ዳስ ኮእታ ካርኤ ፌ ባርኪ ኮርቴ አሱኒ ሜያኖን ዙቱና። ");
INSERT INTO jnje_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«ቤሶሶን ቤለስኒ ኢኦስታን አሩት። ዋኣይባስ ቶሻ ኮታ ቶሽባስ ደይ ቦደፋና ካባሲክ ካዎ ታእሴናማቶ አሪፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ኤሲስማቶ ንቶ ኤስ ባር ዙታምባሴ ስኒን ቢፌት ካባሲክ አሱኒ ናኒ ዮ ታእሴራ ፍኛአሲ ካርናማቶ አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ፉቶ ንቶክ ማኬፋውጙዋ፦ ኤስ ባር ዙታምባሴ ስኖይፌን ሀን ኮንቶስ ኣፋ ኣታና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ሳማሴዋ ዳሴ ኣታና። ስኑንታኖ ካምናሲክቶ ኣፋ ኣታና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«ስኑንታኖ ኤስ ዎናስ ቾዋኖን ወደይ ኤስ ሳአትስ ቾዋኖን አባስቴኖ ሳማኪ ሀኦሲ ዎስያስ ወደይ ናስ ኣነ አሪፌ። ");
INSERT INTO jnje_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ኤስ ዎናስ ኣጌ ስናናማቶ ኣነ አሪፌት ስንና ቦርአ ጉዝራ ኦድት ");
INSERT INTO jnje_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ኤሲስ ደይ ኬባሶን ቤይፋት ኦማ ዳ ሀማ አሱስነ ፋርዋ። ባር ደይ ዎስትኛባሳክቶ ዎስቶሶናክ ዎስቶ ሃኤ እማት ኬያሶን ኦድፌ ባሪን ደይ፦ ‹ጉዝራ ኦድዋ› ይሬ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ኤስ ባሪ ቦርኣ ኬያስ አባ ኣጌ ዮኒርቶ ኣነ አሪፌት ስንና ቦርአ ቴትንትሶን ኦድት። አዉዛክነ ዋልን ወደይ ዳኒ ኪጤ ወደይ አኮ ኦርፌና ካባሲክ ወደይ ዎኒሳ ዋሲ ስናክ ችማና። ");
INSERT INTO jnje_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ዲንቆነ ዬሬ ኩንፌን ዳንኖይናማቶ ጉዙትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","«ንቶክ ማኬናሲማቶ ኦምሲክኔን ዙትራ ‹ጉዙት› ይራ ማኬፋውጙዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","አይሁድኒ ፋስካሴዋ ክጣ ማስቴፋና ሄቦሴ ዛግቶናክ ሄፕ ዎና ፉእቴራ ፋር። ማግኒ ጋኛናዋ ሙሴኒ ቱማሲ አስሲኛስና የሱስኒ ኤጴ ዎርሶነ ማጙኒ ኡግና ሾልሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ስኑንታኖ ባሶ፦ «ዳራስ ፋሶ ካብጉባ፥ ሀን ሄቦስ ኣፋ ዛጉንዉዛ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","የሱስ ብታኒያ ይስቴ ኬኤ ዜሞ አዋታቶኒ ሜታን ስና ስሞን ኬር ዲፌር። ኤስታ ሙን ሙክ ዲፌን እሳ ማሽካሱ ዋግባ አካማ ችማ ሹንቶ ናርዶስኒ ቶሻኪን ዎሱስቴ ሽቶ አልባስትሮስ ይስቴፋ ሹአክ ዎሱስቴ ብልቃድስ ቱማኖን ኤጳ ያ። ብልቃድስ ኡካኖን ሜስራ ሽቶሶን የሱስኒ ቴታስታ ዉክ። ");
INSERT INTO jnje_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ኤስ ስሞን ኬር ዲሴ አሱኒ ሜኒ ጋነያስን እሳ እሳይስ ዛግቴ ባርኪ ግኢቴሴሬ፦ «ሀን ሽቶስ ባክ ዉክቴራ ኬእኖር ስንናስ አዉኒ ቦርአንሶ? ");
INSERT INTO jnje_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ዋግቴፋናነ እሳ ዎግጋ ዎሱስቴ ዎስቶኒ ብርኔን ደናሎ ዋግቴራ ቱካምኒክ እምቶክ ችምቶና ካባዋ» ይሴሴቴ። አሱሶን ደይ ኬእሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ስኑንታኖ የሱስ፦ «ቤይትዋ! አዉኒሮን ባሮን ራክስድፌትሪንሶ? ባር ታክ ማአ ዉዛ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ቱካምኒ ሜያ ዎንና ዎንና ንቶኔን አነቱ ፌሴቴ ስንና ቦርአ ሾሌት ዎኖ አሪጋሱትክ ችማትዋ። ስኑንታኖ ታ ዎንና ዎንና ንቶኔን አነ ኣፋዋ ፎና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ሀን አሱስ ባር ችምናይሶን ታክ ዛጊዋ። አሽናስ ሞግሲ ግሩናክ ሆሱክ ዜምማ ሽቶክ ዎሺ። ");
INSERT INTO jnje_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ታ ፉቶ ንቶክ ማኬፋውጙዋ፤ ሀን ምስራቹኒ ካማስ ዳስ ብራቶታ ዙታምባሴ አሲስታ ማክቴፋና ድማ ኣፋርስታኑ ሀን አሱስ ዛግና ባር ባሮን ሳፋሮንር ስንና ማክቶናዋ።» ");
INSERT INTO jnje_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","አሲሬ ሄፔ ናዎሳስን እሳ አስቆሮትኪ ዩዳ የሱስኒን ኣትሬ እማክ ማግኒ ጋኝኜ ሜያክ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ባሶ ደይ ኤስ ባሮን ኦደሴቴይሴ ግርሴቴ። ዋጋ ደይ እሞነክ አብድ እሜቴ። ኤስ ባሪ ቦርኣ ዩዳ ደይ የሱስኒን ኣትሬ እማና ኡግና ሾሌት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","አይሁድኒ ፋስካኒ ፋንቱ ሹክቴራ ክጣ ማስቴፋና ሄቦስ ቴሱኒ ዎናስታ ናዎኒ ሜያ የሱስኒክ ዬሴሬ፦ «ፋስካ ማስቴፋ ሜታኡሶን ሙታክ አይ ሀማ ሆሱኒክ ሾሌፋሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","የሱስ ደይ ናዎሳስን ሄፒስኒ ዎስሬ፦ «ኤክ ካታማ ሀሚት። ኤስታክ ደይ አካኒ ግማ ዎርኦ አሱኒን ኡጶት። ባሳ ኦርፎሴ ሀሚት። ");
INSERT INTO jnje_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ባር ሀሜ ግርና ኬያስ ግሪፋት ኬያስ አባንን፦ ‹አስሲኛስ፥ ናዎታስኔን አነ ፋስካኒ ሙሶን ሙና እርባኒ ኬያ አይፋሶ?› ይፌዋ ኡት። ");
INSERT INTO jnje_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ባር ሴጌነትስታ ሆሬራ ዪቴራ ድ ታጋ ኬያ ንቶክ ቤሱና። ኤስታ ሆሱት» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ኤስ ናዎሳክቶ ካታማስ ሀሜሬ ማኬናሲማቶ ዳነሬ ፋስካኒ ሙሶን ሆስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ዋልፋና ካባሲክ የሱስ አሲሬ ሄፔ ናዎባስኔን አነ የ። ");
INSERT INTO jnje_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ዲሴፋ ሜሴፌን፦ «ንቶክ ፉቶ ማኬፋውጙዋ፤ ንቶስኒ እሳይስ ሀን ታኔን ሜፌ ባር ታን ኣትሬ እምንር» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ባሶ ደይ ሱሜሴሬ እሳ እሳርቤሲስ፦ «ታ ስኑጙጋታሶ?» ይሴት የሱስኒን ማሙሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","የሱስ ዎልግሬ፦ «አሲሬ ሄፔሳስኒ እሳይስ ሀን ታኔን አነ ኮራናስ ዱክሬ ሜፌ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","አሱኒ ና ባርኪ ትቼናስማቶ ክቱናክ ፋር። ስኑንታኖ አሱኒ ናኒን ኣትሬ እምን ኤስ አሱስ ሀይቡባዎዋ። ኤስ አሱስ ኮንቶ ሻክ ስንፋናነ ማአሪዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ሜሴፌን የሱስ ቱሻሶን ኤጴ ሀኦ ጋላቴፋት ባቴ፦ «ኤሴ፥ ሀኒስ አሽናስዋ» ይሬ ናዎሳክቶኒክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ቱዎሶን ደይ ኤጴ ሀኦ ጋላቴፋት እሚ። ዙቴሬ ኤስ ቶፎስኒ ኡሸቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ኤካ ደይ ይ፦ «ሀን ባር ሾዎኒ ሜያክ ዉክቶኒ ቴያኒ ሀሪንናስዋ። ");
INSERT INTO jnje_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","«ፉቶ ንቶክ ማኬፋውጙዋ፤ ሀኦሲ ታቶኒ ሀኢእሱስ ጋድዶ ዋይኒን ኡሻሶን ኡሻና ካባኔን ሀን ባርስኒ ሄፕስ ኣፋ ኡሻናዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ኤሴን ኦርፎ ጋላትን ጋማ ጋሜሬ ኤክ ዳብራዛይትኒ ኩማስታ ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","የሱስ ናዎባሳክቶኒክ፦ « ‹ኬሜሪስን እቻ ዎሩና፤ ፋንቱሲክቶ ደይ ሲክቶና› ይስቴራ ትቼና ቦርአ ዙቴራ ሀኣት ኤላትዋ። ");
INSERT INTO jnje_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ስኑንታኖ ታ ክቱኒ ካብናኔን ኦርፎ ኤክ ጋሊላ ዜምማ ሀማና» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ጴጥሮስ ደይ፦ «ዙታምቤሲሴ ሀኣት ኤለፌክኑ ታ ኣፋ ኤካ ዛጉና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","የሱስ ደይ፦ «ፉቶ ኔክ ማኬፋውጙዋ፤ ሀውጙ ሀን ዋላሲክ አኮ ሄፓ ዎል ሌ ኦሩኖይፌን ነ ኬዛ ዎላ ሞርሞታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ጴጥሮስ ካምባሶን ችኒሬ፦ «ነኔን አነ ክቱናኑ ስንፋናነ ኣፋ ሞርሞና ዉዛ» ይ። ዙቴሬ ደይ ባሳስማቶ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ኤሴን ኦርፎ፦ «ጌቴሴማኒ» ይስቴ ድምታ ሀሜቴ። የሱስ ናዎኒ ሜያኖን፦ «ታ ኤኬስታ ሺጶና፤ ንቶ ሀንታ ዲፎትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ኤስታን ጴጥሮስኒን፥ ያቆብንን፥ ዮሀኒስኒን ባርኔን አነ ዞንስሬ ሀሚ። አካማኖን ሱሜት ናዮ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ናዎባሳክቶኒክ ደይ፦ «ካናስ ክቱናኔን ካርአ አካማኖን ሱሜዋ። ሀንታ ፋፋት ጉዝራ ኦድትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ጋሮኖን ኤክ ስና ኤክሴሬ ዳስታክ ጋንደሬ ችምቶኒር ስንፋናነ ሻናን ዎናስ ባሳስታን ኣታናማቶ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ኤካ ደይ ይ፦ «ኣባ አባታሶ! ዙቴራ ኔክ ችምቴርዋ። ሀን ኤጳቶናክ ፋ ሻናሶን ታይስታን ዎክሱ። ስኑንታኖ ታ ሾሌና ባር ስኖይናማቶ ነ ሾሌታ ባር ስኑን» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ዎል ሌ ዬሬ ኩነፌን ቢ። ጴጥሮስኒን ደይ፦ «ስሞኖ፤ ኩንታሮሶ? እሳ ሳአትነ ጉዝሬ ኦዳክ ኣነ ችሜኖሶ? ");
INSERT INTO jnje_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ፋታናስ ግሩኖይትማቶ ጉዝራ ሺጶትዋ። አያና ሆሬራቱ ፋ ስኑንታኖ አሻስ ሆፕያዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ኤስታን ዎሌ ደይ ኡኮት ሺጴና ሺጶሶን ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ዎል ሌ ደይ ዬን ኣፌሲስ አፋኢይንክ ፋይና ቦርአ ኩነፌን ቢ። ባርኪ ማክሴፌ ባሮኑ ኣነ አሪሶቶ። ");
INSERT INTO jnje_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ኬሳ ደይ ዬሬ፦ «ሀሽኔን ኩንፌትዮሶ? ሀሽኔን ቤይሳ ኤጵድፌትዮሶ? ኤሴ ሀየ ሆሮናዋ፥ ሳአትስ ካርእ፤ አሱኒ ና ቦርን ሜኒ ኩሹስ አቴሬ እምቶኒር። ");
INSERT INTO jnje_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ካብን ሀሚን፤ ሀሽ ታን ኣትሬ እምን ባር ታእሴ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ጌሬጌሬ ኤስ ባሮን ማኬፌና ካባሲክ አሲሬ ሄፔሳስኒ እሳይስ ዩዳ ስኒፌ ባር የ። ባርኔን አነ ስኮነዋ ሙክነ ኤጶ ማግኒ ጋኛንኪን፥ ሙሴኒ ቱማሲ አስሲኛኒኪን፥ ኩርኡኒ ሜያኪን ዎስቴሬ ዬሴ ሾዎ አሱኒ ሜያ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ኣትሬ እምን ዩዳ ዜምሜ፦ «ታ ዳሞና ባሪንቱ ንቶ ማክራ ኤጳት ኤጳ ሀሚትዋ» ይሬ ቤሶክ ማኬሬ ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ጌሬጌሬ ዬሬ የሱስኒክ ታእሴሬ፦ «አስሲኛኖ!» ይት ዳሜ። ");
INSERT INTO jnje_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ኤስ አነ ዬሴ ባሶ ደይ የሱስኒን ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ኤስታ የሬ ባሶስኒ እሳይስ ሲፎ ዛምባስን ክስሬ ማግኒ ጋኝኜ ሜኒ ጋኛአሳ ዎስትኛኒ ኦዶኖን ካጨ። ");
INSERT INTO jnje_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","የሱስ ደይ፦ «ቦእኛኒን ኤጵንርማቶ ስኮነዋ ሙክነ ኤጳ ታን ኤጳትክ ያትዮሶ? ");
INSERT INTO jnje_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ቤቴሜቅደሲሲ ዎንና ዎንና ንቶኔን አነ ፋፋት አሲፋና ካባሲክ ኣነ ታን ኤጴት። ስኑንታኖ ትቼ ባር ኮኡናክ ሀን ባር ስኒዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ናዎኒ ሜያ ደይ ዙታምቤሲሴ ባሪን ቤይፋት ኤለሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","አቱባስታ ዎርአ ማማ ማዮ እሳ ናኦ አሱ ባሳ ኦርፎሴ ሀሜት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","አሱኒ ሜያ ባሪን ኤጴፌ ካባሲክ ማማሶን ሀኣት አታቱባሴ ኤሊ። ");
INSERT INTO jnje_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","የሱስኒን ማግኒ ጋኝኜ ሜኒ ጋኝኛስክ ኤጴሬ ሀሜቴ። ሙሴኒ ቱማሲ አስሲኛ፥ ኩርኡኒ ሜናዋ ማግኒ ጋኝኜ ሜና ዙቴሬ ኩጲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ጴጥሮስ ማግኒ ጋኝኜ ሜኒ ጋኛአሳ ኦጅን ኬርካሎ ካርአናኔን ዎክሶክ ኦርፎባሴ ሀሚ። ኤስታክ ደይ ዎስትኛኒ ሜያኔን ዲፋት ጌያ ቤስት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ማግኒ ሜኒ ጋኝኛስናዋ ሾሴ ዙቴሴሬ የሱስኒን ዎሩክ ዛልንን ሾልሴሬ ኣነ ዳኖቶ። ");
INSERT INTO jnje_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ሾዎቤሲስ ኤሻ ዛላ ማክሴት ፌሴቴር። ስኑንታኖ ማክሴፌ ዛላስ እሳርባ ፎንቶ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","እሳ እሳ አሱኒ ሜያ ካብሴሬ፦ « ‹ታ ሀን ኩሹክ ኬቴ ቤቴሜቅደሲሶን ቦጋት ኬስናር ዎኖ ኦማ ኩሹክ ኬቶኖሮን ኬርአና› ይፌን ኦደኒዋ» ይት ኤሻ ዛላ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ስኑንታኖ ሀሽኑ ዛልን ሜኒ ካማስ ኣነ እሳር ስና። ");
INSERT INTO jnje_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ማግኒ ጋኝኜ ሜኒ ጋኝኛስ ባሶ ጋነያስን ካብሬ የሱስኒን፦ «ሀን ባሶ ነይስታ ማክሴፌ ዛላስ ኣምባንሶ? እሳሮንኑ ዎልጉ ቤይታሮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ስኑንታኖ ባር ሻክ። እሳሮንኑ ኣነ ዎልጉዌ። ሄፕስኑ ማግኒ ጋኝኜ ሜኒ ጋኝኛስ፦ «ሱስቶ ሀኦሲ ና ክርስቶስ ነኖሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","የሱስ ዎልግሬ፦ «ታዋ፤ አሱኒ ና ሀኦሲ ኦእታ ዲፌናዋ ሳማኪ ሻሩስታ ዬፌና ብያትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ማግኒ ጋኝኜ ሜኒ ጋኝኛስ ማይባሶን ካራሳት፦ «ሀንኔን ኤካሎ ኦማ ዛላ አዉኒሮን ሾልሱንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ሀኦሶን ሜባሶን ኦደትዋ። ንቶክ አዉ ስንና ቤስቴፋሶ?» ይ። ባሶ ዙቴሴሬ፦ «ክቱ ባርኪ ሾልሱዋ» ይት ማጝሱ ካርኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","እሳ እሳይስ ባሳስታ ቱጆ ኤጴቴ። ኣፋሶን ማማክ ኡካት ክኤት፦ «ራጅ እኖክ ማኮዋ» ይሴቴ። ዎስትኛኒ ሜያ ደይ ቦቸት ኤጴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ጴጥሮስ ሃት ኦጅን ኬርካሎ ፌን እሳ ማግኒ ጋኝኜ ሜኒ ጋኛአሳ ኬር ዎስትኛ ያ። ");
INSERT INTO jnje_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ጴጥሮስ ጌያ ቤስፌን ጋሳሲራ ብያት፦ «ነ ደይ ናዝሬትክ የሱስኔን አነ ፋታርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ስኑንታኖ ባር ዎልግሬ፦ «ነ ማኬፋታ ባሮን ታ ኣነ አሩትዌ። ኣነ ጋሳሱት» ይት ሞርሜ። ጌራካሎ ፍኛ ኬስፌና ካባሲክ አኮ ኦር። ");
INSERT INTO jnje_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ኬርክ ዎስትኛስ ሄፕሳ ደይ ቢራ ኤስታ የሬ ባሶክ፦ «ሀኒስ ባሶ ኬጝዋ» ይት ማኬ። ");
INSERT INTO jnje_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ባር ደይ ሄፕሳ፦ «ሞርሜ» ጋሮኖን ፌሬ ኤስታ የሬ አሱኒ ሜያ ጴጥሮስኒን፦ «ፉቶክ ነ ጋሊላክ አሱ ስኒታ ቦርአ ባሶ ኬጝዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ስኑንታኖ ባር፦ «ሀን ማክሴፌት አሱስን ኣነ አሪፋትዋ!» ይት ባሪን ባር ዎልግሬ ኤርውት ቴይ። ");
INSERT INTO jnje_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ጌሬጌሬ ደይ አኮ ሄፕሳ ኦር። ጴጥሮስኒን የሱስ፦ «አኮ ሄፕሳ ዎል ሌ ኦሩኖይፌን ነ ኬዛ ዎላ ሞርሞታዋ» ይና ካማስ ንባስታ ኬጅፋን ሴክቴሬ ዋሲ። ");
INSERT INTO jnje_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ኤሶ ዎኒሳክ ማግኒ ጋኛን ሜያ ኩርኡኒ ሜያኔን፥ ሙሴኒ ቱማሲ አስሲኛናዋ ሾንጎን ሜና ዙቴሬ እሳሪክ ሜርኬሴቴ። ኤሴን ኦርፎ የሱስኒን ታርኤ ታሜ ጵላጦስኒክ ኣትሬ እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ጵላቶስ ደይ፦ «ነ አይሁድኒ ሜኒ ታቶኖሶ?» ይሬ ማምሲ። የሱስ ደይ፦ «ኣ፥ ነ ማኬታስማቶዋ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ማግኒ ሜኒ ጋኛን ሜያ የሱስኒን ሾዎ ቾዋክ ማላሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ጵላጦስ ደይ፦ «እሳሮንነ ኣነ ዎልግፍኖሶ? አፑን ቾዋንሶ ነይስታ ማላሴድፌር» ይሬ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","የሱስ እሳ ዉዛነ ኣነ ዎልጉዌ ስንና ቦርአ ጵላጦስ ዲንቀ። ");
INSERT INTO jnje_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ጵላጦስ ፋስካኒ ሄቦ ሄቦሲክ አሱኒ ሜያ ማሙሴቴ እሳ ታቶኒን ኮቴ ጋፍክት ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ማጙክ ታቶሳታ ካብሴሬ ካኒ ዎሩክ ታቴሬ ፌ አሱኒ ሜያስን እሳ ባርባን ይስቴ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ዳራኒ ሜያ ዬሴሬ፦ «ሀዞዞት ዛግፋታስማቶ እሳ ታቶኒን እኖክ ኮትዋ» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","ጵላጦስ ዎልግሬ ማግኒ ጋኛን ሜያ ኮናክ ኣትሬ እሜቴማቶ አሪና ቦርአ፦ «አይሁድኒ ሜኒ ታቶስን ኮታናክ ሾሌፌትዮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ስኑንታኖ ማግኒ ጋኛን ሜያ የሱስኒን ቤይፋት ባርባንን ኮታናክ ጵላጦስኒን ማሙሶነክ ዳራስን ካቡግሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ጵላጦስ ሄፕሳ ዎልግሬ፦ «ኤኪን አይሁድኒ ሜኒ ታቶዋ ይፌት ባሪን አዉ ዛጉናክ ሾሌፌትሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ዳራኒ ሜያ ደይ፦ «ሱቶዎዋ!» ይት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ጵላጦስ ደይ፦ «ኣምሶ? ዛግና ማጝሱ ኣምባንሶ?» ይ። ስኑንታኖ ባሶ፦ «ሱቶዎዋ!» ይት ቻጋ ኣታምሲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ጵላጦስ ዳራሳ ሳፋራኖን ዛጉክ ሾሌፋት ባርባንን ባሶክ ኮታት የሱስኒን አላንጋክ እቾናክ ዛግሬ ሱቶናክ ኣትሬ እሚ። ");
INSERT INTO jnje_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ታርኦሳክቶ፦ «ፕራቶርዮን» ይስቴፋ ዳ ሀእሲፌ ባሳ ኦጅን ኬርካሎ የሱስኒን ኤጴ ሀሜቴ። ኤስታን ኦም ታርኦን ሜያኖን እሳሪክ ዙትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ሸአ ማያ ማይስሴቴ፤ ደይ ሴርአ ማእሬ ዛዉድ ዛግሬ ቴትባስታ ጉፍስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ኤስታን፦ «አይሁድኒ ታቶኖ! ናጋ ኔክ ስንፋውጝዋ!» ይት ናጋ ኦሸሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ቴትባሶን ሶቦቆክ እቸት፥ ቱጀት ባርኪ ካኣነት ሞሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ካኘሴቴኔን ኦርፎ ሸአ ማያሶን ጋይኣት ባሳ ማያሶን ማይሴሬ ሱቶናክ ኤጴ ሀሜሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","እሳ ኡጉንኒ ዎፍ አለክሳንድሮስናዋ ሩፎስና አሲ አባ ስና ስሞን ይስቴ ቀሬናክ አሱ ቤደን ዬፌን ዳነሬ ሜስቀሊሶን ዎርአናክ ግድስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ኤስታን የሱስኒን ኤጴ ጎልጎታ ይስቴራ ቴግቴፋ ድማስታ ታሜቴ። ኤስ ጎልጎታ ኡስ ደይ፦ «ቴትን ሜጋን ድማ» ኡ። ");
INSERT INTO jnje_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ኤስታክ ደይ ኩምብኔን ዎእቶ ዋይኒን ኡሻ ኡሻናክ እሜሴቴ። ስኑንታኖ ባር ኣነ ኡሼ። ");
INSERT INTO jnje_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ኤስታን ሱቴሴቴ፤ ማይባስታ ደይ እጣ ሀሴሬ ኣኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ኤስ ሱቴሴፌ ካባሲክ ኤእሶ ኬዝ ሳአት። ");
INSERT INTO jnje_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ማላታስ ትቻ፦ «አይሁድኒ ታቶ» ይፋር። ");
INSERT INTO jnje_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ሄፕ ቦእኛኒን ቴሸሴቴ የሱስኔን አነ እሳይስን ኦእታ ቴሽባስታ እሳይስን ደይ ሀልዳ ቴሽባስታ ሱቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ማፃፋሲ፦ «ማጙኒ ሜያኔን ፋድቴዋ» ይና ባር ኮእ። ");
INSERT INTO jnje_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ቴሽባ ኣትፌ ኡጉንኒ ዎፍን ሜያ ቴትቤሲሶን ሾርክት ኤካ ይት ሜኤት ፌሴቴር፦ «ይ፥ ‹ቤቴሜቅደሲሶን ቦጋት ኬዝስናር ዎኖ ኬርአናርዋ› ይ ነኖ! ");
INSERT INTO jnje_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ኤሴ ሀሽ ሜስቀልስታን ኬሬራ ቴትኔሶን ፉኦዋ!» ");
INSERT INTO jnje_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ኤሲስማቶ ማግኒ ጋኛን ሜናዋ ሙሴኒ ቱማሲ አስሲኛስና ባሶትና ባሶትና፦ «ኦሚስን ፉኤ፥ ስኑንታኖ ቴትባሶን ፉኦክ ኣነ ችሜ! ");
INSERT INTO jnje_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ኤሴ ቢራ ባርኪ አማኖኒክ ባር ሙድቶ እስራኤልኒ ታቶስ ሀሽ ሜስቀልስታን ኬሮዎዋ» ይሴት ካኘሴቴ። ባርኔን አነ ሱቴ ቦእኛኒ ሜያ ደይ ባሪን ሜኤት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ቶኒ እሱን ሳአትስታን ካብራ እዝግን ሳአት ካርአና ካባኔን ዳስ ዙቴራ ታልማ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","እዝግን ሳአትስታ የሱስ፦ «ኤሎሄ፥ ኤሎሄ፥ ላማሴቤቅታኒ» ይሬ አካማ ካማክ ቻጊ። ኮትባስ ደይ፦ «ሀኦናሴ! ሀኦናሴ! አዉኒ ቦርአ ታን ቤይፄ?» ኡ። ");
INSERT INTO jnje_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ኤስታ የሬ አሱኒ ሜያስን እሳ እሳይስ ኦደሴሬ፦ «ኦዶትዋ፤ ኤልያስኒንቱ ቴጌድፌዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","እሳር ኤልለ አካ ኤጳክ ችማ ዉዛስ ሀጵቅሬ ሶቦቆታ ዱስሬ ሱትሬ ኡሻናክ የሱስኒክ እማት፦ «ቤይትዋ ሻካኒ ኤልያስ ዬሬ ኬሱንቶ ብያንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","የሱስ አካማ ካማክ ቻጊ፤ ካባስ ደይ ኬስ። ");
INSERT INTO jnje_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ቤቴሜቅደሲሲ ይኑ ደኑን ዳ ሄፕክ ካራቴ። ");
INSERT INTO jnje_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","የሱስኒ ስናስታ የሬ ት ሜኒ ጋኝኛስ ካባስ ኬስባሶን ብያት፦ «ሀን አሱስ ፉቶክ ሀኦኒ ናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","እሳ እሳ ማሽካ ሜያ ደይ ዎክሶክ ብየት ፌሴቴር። ኤስ ባሶስኒ ሜግደላዊትኪ ማራሚ፥ ሳሎሜ፥ ሀቴ ያቆብናዋ ዮሳና አሲ እንቶ ማራሚነ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ባሶ የሱስ ጋሊላክ ፌና ካባሲክ የሱስኔን አነ ሀሜፋፋ አሪጋስት ፋሴር። ኤሲስማቶ የሱስኔን አነ የሩሳሌም ሀማ ኦማ ሾዎ ማሽካሱ ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","ጌሮክ ዋልፋና ካባሲክ አሪማትያሲክ ዮሴፍ ይስቴ አሱ የ። ዮሴፍ ሾንጎ ኬይሴፌ ባሶስኒ እሳይስ ደይ ኡልፍንቶ አሱ። ባር ደይ ሀኦሲ ታቶኖን አብድክ ኦደት ፌር። ዎናስ ቤይሳኒ ዎናስታን ዜምማ ፋ ሆሱኒ ዎና ስንና ቦርአ ድጎኖይ ፕላቶስኒክ ግሪሬ የሱስኒ ዱግኖሶን እማናክ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ፕላቶስ ደይ፦ «ኣካክ ታእን ክትሶ?» ይት ዲንቀ። ት ታርኦን ሜኒ ጋኝኛስን ቴግስሬ፦ «ፉቶክ የሱስ ክትዮሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ት ታርኦን ሜኒ ጋኝኛስኪን ኦደናኔን ኦርፎ ዮሴፍኒክ የሱስኒ ዱግኖሶን እሚ። ");
INSERT INTO jnje_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ዮሴፍ ደይ ክኖን ማማ ዋጌሬ ሜስቀልስታን ዱግኖሶን ኬስሬ ኪምሜ ካቴራ ሆሬ ሹን ሞግሲ ካባሬ። ኤስታን እኛ ሹአ ቡካልስሬ ሞጋስ ኖኖኖን ኡክ። ");
INSERT INTO jnje_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ሜግደላዊትኪ ማራሚነዋ ዮሳን እንቶ ማራሚነ የሱስኒ ዱግኖሶን አይ ካባርሴቴማቶ ብየድፋር። ");
INSERT INTO jnje_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ቤይሳኒ ዎና ኣትናኔን ኦርፎ ሜግደላዊትኪ ማራሚ፥ ሳሎሜ፥ ያቆብን እንቶ ማራሚነ ዬሴሬ የሱስኒ ዱግኖሶን ዎሹክ ሳዋ ዉዛኪን ሆሬ ሽቶ ዋግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ቶርባኒስ ቴሱኒ ዎኖ ኤእሶ አዋ ኬስፋና ካባሲክ ሞጋሲክ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ባሶትና ባሶትና፦ «ሹኣሶን ሞጋስ ኖኖታን እኖክ ቡካልሱኒሪ ኦንሶ?» ይሴት ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ኤስ ባሮን ደይ ይሴቴስ ሹኣስ አካማ እኛ ስንና ቦርአ። ስኑንታኖ ካነ ብየቴን ሹኣስ ቡካለራ ሻቴናማቶ ብየቴ። ");
INSERT INTO jnje_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ሞጋስ ግርሴቴን ፎሮ ማያ ማዮ ናኦ አሱ ኦእታ ዎሉስታ ዲፌን ቢሬ ናይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ኤስ ናኦ አሱስ፦ «ናዮትታ! ሱቴ ናዝሬትክ የሱስኒንቱ ሾሌድፌትማቶ አሪፋዉጝዌ። ባር ካብ፤ ሀንታክ ኣፌ፤ ባሪን ኩኑሴቴ ድማሶን ብዮት። ");
INSERT INTO jnje_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ኤሴ ሀምፋት ናዎኒ ሜያክናዋ ጴጥሮስኒክና፦ ‹ንቶክ ማኬናሲማቶ ንቶስታን ዜምሜ ጋሊላ ሀሚንር። ኤስታክ ብያት› ይራ ማክሶት» ይ። ");
INSERT INTO jnje_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ኤስ ማሽካሱሲክቶ ድጋክ ኮርክሴት ሞጋስኒ ኬሳ ኤለሴ። አካማኖን ድግሴና ቦርአ እሳ ዉዛነ ኦኒክኑ ኣነ ማክሶዋ። ");
INSERT INTO jnje_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","የሱስ ቶርባኒስ ቴሱኒ ዎኖ ኤሶ ክቱኒ ካብናኔን ኦርፎ ዜምሜ ናፉን ኪና አያና ባርስኒ ክስና ሜግደላዊትኪ ማራሚክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ባር ደይ ሀማ ሱሜትናዋ ዋስትና ፌሴ ባሳ ዞንስኒ ሜያክ ኤስ ባሮን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ባሶ ደይ ሀየዉ ስኒባሴዋ ባርኪ ቤስቶባሴ ኦደሴፌ ካባሲክ ኣነ አማንቶሶቶ። ");
INSERT INTO jnje_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ኤሴን ኦርፎ ባሶስኒ ሄፕ ናዎባሳክቶ ቤደ ሀሜፌን የሱስ ኡጉንታክ ኦማ ግቶክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ባሶ ደይ ዎል ሌ ሀሜ ኦም ናዎኒ ሜያክ ማክሴቴ። ኤስ ባሶ ደይ ኣነ አማኖሶቶ። ");
INSERT INTO jnje_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ኤሴን ኦርፎ ደይ አሲሬ እሴስ ሙ ሜሴፌን የሱስ ባሶክ ቤስቴሬ፦ «የሱስ ክቱኒ ካብሬ ካክ ፌ፤ እንኖ ደይ ኣፍኒሲክ ቢን» ይሴሬ ማክሴ ባሶትን አማኖ ቤዮቤሲሲክናዋ ንብቤሲስ ችማክና ባሶትን ኬእ። ");
INSERT INTO jnje_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ቱስሬ ደይ ኤካ ይ፦ «ዳስ ብራቶ ዙታምባሴ አሲስታ ሀሚት። ምስራቹኒ ካማሶን አሱ ዙታምባሴ አሲክ ማኮት። ");
INSERT INTO jnje_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","አማነሬ ሀጱክቴ ባር ፋሩና። ስኑንታኖ አማኖኖይ ባሳስታ ማጝሱ ካቴር። ");
INSERT INTO jnje_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","አማነ ባሶ ሀን ቤሶሶን ዛግሶነ፤ ታ ሱናሲክ ኪና አያናሶን ክሱሶነ፤ ጋድዶ ኖኖክ ዎሉምሶነ። ");
INSERT INTO jnje_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ዛዋሲክቶኖን ኤጶነ፤ ዎሩን ዉዛኑ ኡሸፋቴነ ባሶትን እሳንነ ኣፋ ሚርኦና ዉዛ። ኩሹቤሲሶን ሜታን ሜኒስታ ታኡሶነ ባሶ ደይ ፋርሶነ።» ");
INSERT INTO jnje_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ዳም የሱስ ኤስ ባሮን ናዎኒ ሜያክ ማኬናኔን ኦርፎ ደን ሳማ ሀሚ። ሀኦሲ ሆእታ ቴሽታ ድ። ");
INSERT INTO jnje_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ባሶ ደይ ኬሴሬ ዳ ዳ ዙታምባሴ አሲስ ሀሜፋፌ ማክሴቴ። ዳሚስ ደይ ባሶኔን አነ ዎስቴት ፌር። ቢስቴራ አሪቶኖይ ዉዛን ዛጉክ ማክሴፌ ምስራቹኒ ካማስ ፉቶ ስኒባሶን ቤስት ፌር።");
INSERT INTO jnje_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ኡልፍንቶ ቴዎፍሎስኖ፤ እንኖ ጋነያሲ ስና ቾዋሲክቶኖን ቤሱኒ ትቻ ዜሞ ስናክ ሾዎኒ ሜያ ትችሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ኤስ ትቻሶን ደይ እኖክ ኣቲስ ቴሱባስታን ካብግሬ ኣፋክ ብያ ባሶትናዋ ሀኦሲ ካማኖን ማክሴት ፌሴ ባሶትናዋ፤ ");
INSERT INTO jnje_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ታኑ ታ ቴታሲክ ቴሱባስታን ካብግራ ጋሳሲራ ቢናንኔን ኦርፎ ቶቾሶን ዜሜ ዞንሶባሶን ኦዳ ኔክ ትቹናክ ማአሪ ስንና ቤስቴዋ። ");
INSERT INTO jnje_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ኤስ ባሮን ዛግናስ ነ ኦደታ ቾዋሲ ፉቶ ስኒባሶን አሩታክዋ። ");
INSERT INTO jnje_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ሄሮድስ ዩዳኪ ዳስታክ ታቶ ስና ነያሲክ አብያን ማግኒ ዎስቶ ዎስቴሴፌ ባሶስኒ ስና ዛካሪያስ ይስቴ እሳ ማግ ፌር። ባር ደይ ኣሮን ዛላስን ስና ኤልሳቤት ይስቴ አሱባ ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ሄፖቤሲሴ ሀኦሲ ስና ኦኮ ስንነ ፌሴቴር። ዳሚሳ ካማኖንናዋ ቱማሶንና ዙታምባሴ አሲን ኦዳክ እሳ ሙዳ ፎንቶኖን ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ስኑንታኖ ኤልሳቤት ዛግያ ስንና ቦርአ ኮኑቤስ ኣፋ። ሄፖቤሲሴ ደይ ቁርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","እሳ ዎኖ ዛካሪያስ ባሳ ዎስቶኒ ታራሲክ ቤቴሜቅደሲሲ ማግኒ ዎስቶሶን ዎስቴድፌር። ");
INSERT INTO jnje_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ኡኮት ማግኒ ሜኒ ቱማስማቶ ዳሚሳ ቤቴሜቅደሲሲ ግሪሬ እጣና ኪቹናክ እጣ ባርኪ ካርእ። ");
INSERT INTO jnje_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ቤቴሜቅደሲሲ እጣናስ ኪቼፋና ካባሲክ ዳራ ዙቴሬ ጌራካሎ የሬፋት ሀኦ ሺጴድፌር። ");
INSERT INTO jnje_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ዳሚሳ ዎስያ እጣና ኪቼፋና ሾኣስ ሆእታ ቴሽታ የሬፋት ባሪኪ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ዛካሪያስ ዎሲያሶን ቢናይሴ ናየሬ ድጌ። ");
INSERT INTO jnje_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ስኑንታኖ ዎስያስ፦ «ዛካሪያስኖ ድጎታታዋ! ሺጶኔስ ኦድቴዋ። አሱነ ኤልሳቤት ኣርቃ ናኒን ታኖንር። ሱንባሶን ደይ ‹ዮሀኒስ› ይራ ሱንሱታ። ");
INSERT INTO jnje_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ባሳ ኮንቶስ ኔክ አካማ ግራ ስናናዋ። ሾዎ አሱኒ ሜያ ደይ ባሳ ኮንቶሲክ ግሮሶነዋ፥ ");
INSERT INTO jnje_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ባር ዳሚሳ ስና አሪክርቱ ስናና። ዋይኒን ኡሻ ስኑን ኦማ ዛይሱኒ ኡሻ እሳንነ ኣፋ ኡሻናዉዛ። እንቶባሲ ኬንስ ፌጌዶ ኮርቶ አያናክ ቱምቶና። ");
INSERT INTO jnje_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ባር እስራኤልኒ ዳራሳስን ሾዎቤሲስን ዳማ ሀኦቤሲሲክ ዎልጉና። ");
INSERT INTO jnje_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ባር ራጁ ኤልያስኒሲማቶ ሀኦሲ አያናክናዋ ሁግናክና ዳሚሳ ስና ዜማና። አባን ሜኒ ንባሶን ናንጎትቤሲሲክ፥ አጃጃሞኖይ ባሶትን ካይምኒ ሜኒ ቴችማስ ዎልጉና። ዳራስን ዳሚሲክ ሆሬሬ ፌር ስኖነክ ዛጉና» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ስኑንታኖ ዛካሪያስ ሀኦሲ ዎስያክ፦ «ሀን ባር ፉቶ ስንባሶን አዉክ አሩና? ታ ኩርእን፥ አሱናስ ደይ ዎጋባስ ኮእ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ሀኦሲ ዎስያስ ዎልግራ፦ «ታ ሀኦሲ ስና የሬፋ ጋቡሬልዋ። ሀን ምስራቹሶን ኔክ ማኮናክ ዎስቴራ ያናርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ስኑንታኖ ነ ዎንባስ ካርፋና ካባሲክ ስኒ ካምናሶን አማኖ ቤይታ ቦርአ ሀን ቾዋሲ ስናናኔን ንብታቶቱ ስናታዋ። ዎላ ደይ ኣፋ ችማታ ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ኤስ ካባሲክ አሱኒ ሜያ ዛካሪያስ ኬሳናኔን ኦደት ፌሴቴር። ቤቴሜቅደሲሲን ታእን ኬሳ ቤይባሲክ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ዛካሪያስ ቤቴሜቅደሲሲን ኬስፌና ካባሲክ አሱኒ ሜያኔን ዎሎክ ኣነ ችሜ። ኤስ ባሪ ቦርኣ ቤቴሜቅደሲሲ እሳ ባርኪ ቤስቴ ዉዛ ፋናማቶ አሱኒ ሜያ አርሴቴ። ባር ዎሎኖይ ኩሹባሲክ ቤስት ፌር። ኤሲሲክ ንብታቶ ስንነ ፉእቴ። ");
INSERT INTO jnje_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ዛካሪያስ ቤቴሜቅደሲሲክ ባሳ ታራሲ ዎስቶኒ ዎና ኮኡባሴ ኬባ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ጋሮ ዎናኔን ኦርፎ አሱባ ኤልሳቤት ናኔርቴራ ኡች አሳ ኬባሲ ኣቸራ ድ። ");
INSERT INTO jnje_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ኤካ ደይ ይ፦ «ዳሚስ ሀን ማአ ዉዛሶን ታክ ዛጊዋ። አሱሳ ጋነሲ ፋ ካሽስቶናሶን ትሽኪ።» ");
INSERT INTO jnje_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ኤልሳቤት ናኔርቴናሪ እሱንሳ አሳሲክ ሀኦሲ ዎስያ ስና ጋቡሬሊ ጋሊላኪ ዳስታክ ፋ ናዝሬትን ካታማስ ሀኦስኪን ዎስቴራ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ዎስቴራ ሀሚናስ ዳዊትኒ ዛላስኒ ስና ዮሴፍንክ ቴግቴራ ድ እሳ ዱርባ ናዋኪ። ኤስ ዱርባ ናዋስ ሱና ደይ ማራሚ። ");
INSERT INTO jnje_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ሀኦሲ ዎስያ ባርኪ ያራ፦ «ነ አካማኖን ሱስቶዌ። ናጋ ኔክ ስንፋዉጙዌ። ዳሚስ ነኔን አነቱ ፌዌ» ነ ማሽካሱስ ጋነስን ሱስቶዌ ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ማራሚ ሀኦሲ ዎስያኒ ዎላሲክ አካማኖን ናየፋት፦ «ሀን ባር ኣካት ናጋኒ ኦሾንሶ?» ይት ሳፋሬ። ");
INSERT INTO jnje_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ሀኦሲ ዎስያ ማራሚክ፦ «ሀኦሲ ስና አዳ ዳኒት ስንና ቦርአ ድጎታታዌ። ");
INSERT INTO jnje_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ኤሴ ነ ናኔርቶታርዌ፥ ኣርቃ ናኒን ደይ ታኖታር። ሱንባሶን ደይ ‹የሱስ› ይራ ሱንሱታ። ");
INSERT INTO jnje_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ባር ደይ አካምቱ ስናና። ዙታምባሴ አሲስታን ደናሎ ስና ሀኦኒ ና ይስቴሬቱ ቴግቶና። ዳማ ሀኦሲ አባባ ዳዊትኒ ዝግሞሶን ባርኪ እምንር። ");
INSERT INTO jnje_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ያቆብን ዛላስታ ኮእባ ፎንቶኖን ታቶኒር። ታቶባስኑ ኮእባ ኣፋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ማራሚ ሀኦሲ ዎስያክ ዎልግራ፦ «ታ ዱርባዋ፤ ሀን ባር ኣካክ ስናክ ችምንርን?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ሀኦሲ ዎስያ ዎልግራ፦ «ኮርቶ አያና ነይስታ ዮና። ዙታምባሴ አሲስታን ደናሎ ስና ሀኦሲ ሁግና ደይ ነይስታ ኬሮና። ኤስ ባሪ ቦርኣ ኮንቶኒ ናስ ኮርቶ። ደይ ሀኦኒ ና ኡስቶና። ");
INSERT INTO jnje_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ነ ኮና ስና ኤልሳቤትኑ ኩርኡባስታክ ኣርቃ ናኒ ናኔርቴ። ዛግያ ይስቴ ባር ናኔርቴናኔን ሀኒስ እሱንሳ አስባ። ");
INSERT INTO jnje_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ሀኦሲክ ችምቶኖይ ዉዛ ኣፋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ማራሚ ደይ፦ «ታ ዳሚሳ ቦዛዋ። ኤሴ ነ ማኬታስማቶ ስኑን» ይ። ኤስታን ሀኦሲ ዎስያ ኬሳ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ኤስ ካባሲክ ማራሚ ታፕታኖን ካብራ ኣማስታ ፋ ዩዳኒ ዳስታኪ እሳ ካታማስ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ዛካሪያስኒኪ ኬር ግርራ አሱባ ኤልሳቤትኖን ናጋ ኦሽሼ። ");
INSERT INTO jnje_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ኤልሳቤት ማራሚኒ ናጋሶን ኦደፋና ካባሲክ ካትባሲ ድ ናዋስ ፍልለ። ኤልሳቤት ደይ ኮርቶ አያናክ ቱምቴ። ");
INSERT INTO jnje_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ካምባሶን ደይ ቴግራ፦ «ነ ማሽካሱስ ጋነስን ሱስቶዌ። ኔኪን ኮንቶኒ ባር ደይ ሱስቶዌ። ");
INSERT INTO jnje_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ዳምታሳ እንቶ ታን ማምሱክ ዮባስ አዉነ ፋ አካማ ኡልፍናንባ! ");
INSERT INTO jnje_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ነ ናጋስ ካማኖን ኦደፋና ካባሲክ ካትናሲ ፋ ናዋስ ግራክ ፍልለ። ");
INSERT INTO jnje_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ዳሚስ ማኬና ባሮን ዛጉንር ስንባሶን አማነ ነ አዉነ ፋ ሱስቶኒሴ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ማራሚ ደይ ኤካ ይ፦ «ካናስ ዳሚስን ጋላቶኒር። ");
INSERT INTO jnje_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","ሀኦሲ ካሽስቶ ዎስትኛ ስና ታን ቢና ቦርአ፤ ቱማ ንብናሲ ሳፋራክ ሄትና ስና ሀኦናሲክ ግሮና፤ ሀዉጝኔን ኤካሎ ኮንቶስ ዙቴራ ታን፦ ‹ነ ሱስቶዌ› ኡና። ");
INSERT INTO jnje_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ሁግናባ ፋና ሀኦስ ታክ አካማ ዉዛ ዛግና ቦርአ፤ ሱንባስ ደይ ኮርቶ። ");
INSERT INTO jnje_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ሀኦሶን ድጌፌ ባሶክ፤ ኮንቶስታን ኣታ ኮንቶስታ ካርአ ፋኩና። ");
INSERT INTO jnje_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ችማ ዎርባሲክ ሁግናባሶን ቤሲ፤ ቤጋንቴፌ ባሶትን ንቤሲሲ ሳፋራኖን ጌዳ ስኬ። ");
INSERT INTO jnje_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ዳሶን ሀእስፌ አርክ አርክ ሜያኖን ዝግሞቤሲስታን ኬሲ፤ ስኑንታኖ ካሽስቴፌ ባሶትን ኡልፍናክ ደን ቴግ። ");
INSERT INTO jnje_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ማክታኒ ሜያኖን ማአ ዉዛክ ጋዉሲ፤ ኦቱምኒ ሜያኖን ኩሽኩሽ ካላ ኮፍክ። ");
INSERT INTO jnje_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","አብራሀምኒክናዋ ባሳ ዛላሲክና ኮእባ ፎንቶ ነያ ቤስና ፋኪባሶን ሳፋሮክ፤ ዎስትኛባ ስና እስራኤልኒን አሪጋሲ፤ ኤስ ባሮን ዛግናስ ዜሞቲ አባኒሳክቶኒክ እምና አብድን ካማሶን ኮእሱክዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ማራሚ ደይ ኬዝ አሳ ስኒ ዎና ኤልሳቤትኔን አነ ዲራ ዎላ ኬባ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ኤልሳቤት ኮጶና ዎና ካርእን ኣርቃ ናኒን ኮጰ። ");
INSERT INTO jnje_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ዎልኮባሴዋ ኮንባሲክቶነ ዳሚስ አካማ ፋክያ ባርኪ ዛግናማቶ ኦደሴሬ ባርኔን አነ ግርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ናጝሪንስናሪ ዎኖ ዳግ ናስን ሃርኮኒ ኩንሱክ አሱኒ ሜያ ዬሴቴ። አባባሳ ሱናክ ዛካሪያስ ይሬ ሱንሱክ ሾልሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ስኑንታኖ እንቶባስ፦ «እንዳነ፥ ሱንባ ዮሀኒስ ይስቴሬቱ ሱንቶና» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ባሶ ደይ፦ «ነ ኮኒሳስን ሀን ሱናሲክ ሱንቴር ኣፌዌ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ኤስታን አባባ ዛካሪያስኒን፦ «ናኔስ ኦ ይስቴሬ ሱኑስቶናኪንሶ ሾሌፋታሪ?» ይሬ ኩሹቤሲሲክ ቤስሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ባር ደይ ትቹን ዉዛ እሞነክ ማምሲሬ፦ «ሱንባ ዮሀኒስዋ» ይሬ ትቺ። ዙታምቤሲሴ ኤስ ባርኪ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ጌሬጌሬ ዛካሪያስኒ ቴርማ ኮቴን ሀኦሶን ጋላቴት ዎል ሌ። ");
INSERT INTO jnje_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ኤስ ባርስታን ካብ ቾዋ ዎልኮኒ ሜያ ዙቴሴሬ ድጌሴቴ። ኤስ ዎላስ ቾዋ ዙቴራ ኩማስታ ፋ ዩዳኒ ዳሲ ብራቶታ ዎሉምቴራ ዝእ። ");
INSERT INTO jnje_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ኤስ ባሮን ኦደ ባሶ ዙቴሬ፦ «ሀን ዳግ ና ሀንኔን አዉ ስኑጌሶ?» ይት ባሶትና ባሶትና ማሙሴሴቴ። ኤስ ባር ስንናስ ሀኦሲ አሪጋሱ ዮሀኒስኔን አነ ፋር ስንና ቦርአ። ");
INSERT INTO jnje_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ኤስ ዳግ ናሳ አባ ዛካሪያስ ኮርቶ አያናክ ቱምቴሬ ኤካ ይት ራጅ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«ያራ ዳራባስን ፉሬና ቦርአናዋ አርጋስና ቦርአና ዳማ እስራኤልኒ ሀኦሲክ ጋላታ ስኒፋዉጝ። ");
INSERT INTO jnje_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","ኤስ ባርኑ እቤ ዜምማ፤ ኮርቶ ራጁኒ ሜያኪ ካሞ ማኬናሲማቶ፤ ዎስትኛባ ስና ዳዊትኒ ዛላስን፤ አካም ፋቱኒርን እኖክ ካብግ። ");
INSERT INTO jnje_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ፉኤናስ ደይ፤ ጉማየፌ ባሶ ኩሹስንናዋ፤ ኦምቴሴፌ ባሶ ኩሹስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","ኤስ ባሮን ዛግናስ እንኖ አባን ሜያክ፤ ፋክባሶን ቤሱናክናዋ፤ ግርና ኮርቶ ቴያሶን ዛጉናክናዋ፤ ኤስ ግርና ቴያሶን ደይ ቴይራ እምናስ፤ አባን አብራሀምኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ኤስ አብድን ካማስ፤ ደይ ጉማኒሳ ኩሹስን ብርማዱማ ኬሳ፤ እሳ ድጋ ፎንቶኖን ባርኪ ዎስቴት ፎኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ኤሲስማቶ ደይ ኔኒሶን ዙታምባሴ፤ ሀኦሲ ስና ኮርቶክናዋ ኦኮክና ፎኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ደይ ነ ሀን ዳግ ናሶ፤ ዙታምባሴ አሲ ደናሎ ስና ሀኦሲ ራጁ ኡስቶታዋ፤ ኡግናሶን ሆሱታክ፤ ዳሚሳ ስና ዜምማ ሀማታ። ");
INSERT INTO jnje_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ዳሚስ ደይ ቦርቤሲሶን ፌሹን ኡክ፤ ፋርሶነ ኡግናስ አሩኖን ባሶክ እማና። ");
INSERT INTO jnje_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ሀኦኒስ ፋክርናዋ ኬናሽቴርና፤ ስኒባሲክ ፋሩን ቻሬፋ ደኑን እኖክ ቻሮናክ ዛጉና። ");
INSERT INTO jnje_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ባር ታልማስንናዋ ክቱኒ ትሾስንና ፌ ባሶክ ቻርሱና፤ እንኖ ታሩሶን ደይ ናጋን ኡግናክ ዞንሱናክዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ዳግ ናስ ደይ ድች። ኮርቶ አያናሲክ ደይ ቺሚ። እስራኤልኒ ዳራሲክ አማኖ ቤስቶና ዎና ካርአና ካባኔን ኢችማዳስ ሲ ዲ። ");
INSERT INTO jnje_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ኤስ ካባሲክ ሮማኒ ታቴ ሜኒ ታቶ አጉስቶስ ኬሳር ባሳ ሀእሱሲ ፌ አሱኒ ሜያ ዙቴሬ ዳራኒ ፋዳክ ትቾሶነክ አጃጅ ኬሲ። ");
INSERT INTO jnje_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ኤስ ቴሱኒ ዳራኒ ፋዳ ዛግቴፋና ካባሲክ ኬሜሪዎስ ሶርያኒ ዳሶን ሀእስት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","አሱ እሳርባ እሳርባስ ደይ ሱንባሶን ትቾናክ ኮንቴና ዳስታክ ሀሜት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ዮሴፍ ኮንቴናስ ዳዊትኒ ዛላስን ስንና ቦርአ ጋሊላክ ፋ ናዝሬትክ ካታማስን ካብሬ ዩዳኒ ዳስታኪ ፋ ዳዊት ኮንቴና ካታማ ቤቴለም ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ትቾክ ሀሚናስ ናኔርቴራ ፋ ቴጌሬ ዱስና ናዋ ማራሚኔን። ");
INSERT INTO jnje_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ቤቴለሙክ ፌሴቴን ማራሚ ኮጶና ዎና ካርእ። ");
INSERT INTO jnje_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ኡዙን ናባስ ኤስታ ኮጰ። እርባ ሀእፌና ኬያስ አሱኒክ ኦቴራ ኮእና ቦርአ ማማ ታክስራ ምያ ሙባ ማፋና ማጋሲ ኩንስ። ");
INSERT INTO jnje_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ኤስ ዳስታክ ዋል ዋልን ኖርኦቤሲሶን ኬሜት ሀእሴፌ ኬሜርኒ ሜያ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ባሶክ ደይ ዳሚሳ ዎስያ ዲንቆነ ቤስቴ። ዳሚሳ ኡልፍንኒ ቻሬፋ ባሶ ብራቶስታ ቻርስ። ባሶ ደይ አካማኖን ድጌሴቴ ");
INSERT INTO jnje_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ስኑንታኖ ሀኦሲ ዎስያ ደይ ባሶክ፦ «ሀሬዋ ድጎትታ! አሱ ዙታምባሴ አሲን አካማኖን ግርሱን ማአ ኦዱ ንቶክ ኤጳ ያንዋ። ");
INSERT INTO jnje_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ሀሽ ሀዉጚ ሀን ዳዊትኒ ካታማስ ፋትር ስና ዳም ክርስቶስ ንቶክ ኮንቴዋ። ");
INSERT INTO jnje_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ሀን ባር ንቶክ ማላቶ ስናና፦ ዳግ ና ማማ ታክስቴሬ ሚያ ሙባ ማፋና ማጋሲ ኩንፌን ዳናት» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ጌሬጌሬ ሾዎ ሳማኪ ዎስያ ኤስ ሀኦሲ ዎሲያስኔን አነ ቤስቴሴራ፦ ");
INSERT INTO jnje_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«ደን ሳማኪ ሀኦሲክ ኡልፍና ስንፋውጝዋ! ሀን ዳስታኪ ደይ፤ ሀኦ ሹንፋና አሱኒ ሜያ ዙታምቤሲሴ አሲክ፤ ናጋ ስንፋዉጝዋ» ይት ሀኦሶን ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ሀኦሲ ዎስያሲክቶ ኦር ኬሳ ደን ሳማ ሀሚናኔን ኦርፎ ኬሜሪሳ ባሶትና ባሶትና፦ «ኤሴ ሀን ስና ባሮናዋ ዳሚስ እኖክ ቤስና ዉዛሴ አሲና ብያንክ ቤቴለም ሀሚንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ባሶ ደይ ታፕታክ ሀሜሬ ማራሚኖናዋ ዮሴፍንና ዳነቴ። ዳግ ናስ ደይ ምያ ሙባ ማፋና ማጋስ ኩንፌን ብየቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ዳግ ናስን ደይ ብየቴኔን ኦርፎ ሀኦሲ ዎስያ ባሶክ ማኬና ናሳ ቾዋኖን ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ኤስ ኬሜሪሳክቶ ማኬና ባሮን ኦደ ባሶ ዙቴሬ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ስኑንታኖ ማራሚ ኤስ ቾዋሶን ዙትራ ንብባሲ ኤጳት ሳፋሬት ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ኬሜሪሳክቶ ቾዋስ ዙቴራ ሀኦሲ ዎስያ ባሶክ ማኬናሲማቶ ስኒን ብዮቤሲሲክናዋ ኦዶቤሲሲክና ሀኦሶን ጋላቴትናዋ ኡልፍንስትና ዎል ሌ ሀሜሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ናጝሲንናሪ ዎኖ ናስ ሃርኮ ኩናና ቱማስታ ዜምማ እንቶባ ናኔርቶኖይፌን ሀኦሲ ዎስያ ሱንስና ሱናሲክ «የሱስ» ይሴቴሬ ሱንቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ሙሴኒ ቱማስማቶ ካይምኒ ቱማስ ዛግቶና ዎና ካርእ። ኤስ ባሪ ቦርኣ ዮሴፍናዋ ማራሚነ ዳግ ናስን ዳሚሳ ስና ታእሱክ የሩሳሌም ኤጴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ኤስ ባሮን ኤካ ዛግሴቴስ ዳሚሳ ቱማክ፦ «ኡዙን ስና ኣርቃ ና ዙቴሬ ዳሚሲክ እምቴሬ ኮርቶ ስናናር» ይፋ አጃጅ ትቼራ ፋር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ኤሲሲማቶ ዳሚሳ ቱማሲ፦ «ሄፕ አሜታ ወደይ ሄፕ ናካሎኒ ናዋ ማአ እማክ ሾልሱ» ይፋ አጃጅ ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ኤስ ካባሲክ ስሞን ይስቴ እሳ አሱ የሩሳለሙክ ፌር። ባር ካባሶን ሀኦኪ እሜ ፌ ኦኮ አሱ። እስራኤልኒ ፋሩን አብዲሶን ኦደት ፌር። ኮርቶ አያናስ ደይ ባርኔን ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ባር ዳሚሳ ሙድቶኒን ቢኖይ ክቱኖይናማቶ ኮርቶ አያናስ ባርኪ አምማኖን ቤስራ ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ኤስ ዎኖ ኮርቶ አያናስ ስሞን ካብግራ ቤቴሜቅደሲሲ ሀማናክ ዛግን ሀሚ። ዮሴፍናዋ ማራሚነ ቱማስ ማኬናሲማቶ ዛጉክ ዳግ ናስን ኤጴ ቤቴሜቅደሲሲ ግርሴቴን፥ ");
INSERT INTO jnje_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ስሞን ደይ ዳግ ናስን ኤጴ እድሜ ሀኦሶን ጋላቴት ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«ዳሚሶ! ኤሴ! ታክ እምታ አብድን ካማስ ኮእዋ፤ ሀየ ዎስትኛነ ስና ታን፤ ናጋክ ደን ኔክ ኤጵዋ። ");
INSERT INTO jnje_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ነ ፋቱሶን ኣፍናሲክ ቢጝዋ፤ ");
INSERT INTO jnje_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ኤስ ባር ደይ ዳራ ዙታምባሴ አሲ ስና ሆስታ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ባር አዛብኒ ሜያክ ፉቶሶን አምማኖን ቤሱን ቻሬፍ ስናና፤ ነ ዳራ ስና እስራኤልኒ ሜያክ ኡልፍናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ዮሴፍናዋ ማራሚነ ማክቴ ዳግ ናሳ ቾዋክ ዲንቀሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ስሞን ደይ ባሶትን ሱስናኔን ኦርፎ ዳግ ናሳ እንቶክ፦ «ሀን ዳግ ናስ እስራኤልኒ ሜያክ ሾዎቤሲሲክ ትሹክ፥ ሾዎቤሲሲክ ደይ ፋሩን ኡግናቱ ስናና። ባሪን ሾዎቤሲስ ኤጴቶ ቤዮቤሲስ ቤሶ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ኤስ ባርኪ ሾዎ አሱኒ ንብሲ ኣቸራ ፋ ሳፋራ አምማኖን ኬሳ ቤስቶና። ንብኔሶን ደይ ሱሞን ሲፎስ ካላስራ ኣታና» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ኤስ ካባሲክ ኣሴርን ዛላስኒ ፋኑኤልኒ ናዋ ሃንና ይስቴ እሳ ራጁ ፋር። ባር ደይ አካማኖን ኩርኡ። ቴጎባሴን አነ ናፉናስር ዎግጋ አነ ዲሴፌን ባር ክት። ");
INSERT INTO jnje_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ኤሴን ኦርፎ ዎጋባ ናጝናስሬ አቼቼ ካርአናኔን ዎንና ዎንና ቤቴሜቅደሲሲኒ ትሹኖይ ሶሜራ ሺጴት ሀኦሲክ ዎስቴት ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ባር ደይ ኤስ ካባሲክ ጌሬጌሬ ያራ ሀኦሶን ጋላቴ። ዳግ ናሳ ቾዋኖን የሩሳሌምኒ ፉርቶሶን ኦደት ፌሴ ባሶክ ዙታምቤሲሴ አሲክ ማኬት ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ዮሴፍናዋ ማራሚነ ዳሚሳ ካምስ ማክቴ ቱማሶን ኮእሴቴኔን ኦርፎ ጋሊላክ ዳስታክ ፋ ፌሴፌ ካታማ ናዝሬት ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ዳግ ናስ ደይ ድቸትናዋ ዛግትና ሀሚ። ቴችማክ ደይ ቱሚ። ሀኦሲ ኦትማ ባርኔን አነ ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ዮሴፍናዋ ማራሚነ ዎግጋ ዎጋሲክ አይሁድኒ ፋስካኒ ሄቦሶን ኡልፍንሱክ የሩሳሌም ሀሜት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","የሱስ አሲሬ ሄፔ ዎጋባ ስኒፋና ካባሲክ ዛግቴት ፋናሲማቶ ሄቦሶን ኡልፍንሱክ የሩሳሌም ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ሄቦስ ኮእናኔን ኦርፎ ዮሴፍናዋ ማራሚነ ኬቤስ ዎልሴሬ ሀሜፌ ካባሲክ የሱስ የሩሳለሙክ ፉእቴ። ስኑንታኖ ባሶ ኤስ ባሮ ኣነ አሪሶቶ። ");
INSERT INTO jnje_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ባር ኡጉንኒ ዎፊሴን አነቱ ፌዋ ይሴፋት እሳ ዎን ኒ ኡግና ሀሜቴ። ኤስታን አሪሴፌ ኮንቤሲሲክናዋ ዞሞቤሲሲክና ሾሎክ ካብሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ሾሌሬ ቱሩክሴቴኔን ኦርፎ ዎል ሌ የሩሳሌም ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ኬዝ ዎናኔን ኦርፎ ቤቴሜቅደሲሲ አሲፌ ባሶ ጋነያስ ዲፋት ኦደፌናዋ ማምሱ ማምሲፌና ዳነቴ። ");
INSERT INTO jnje_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ኦደ ባሶ ደይ ዙቴሬ ጋሳሱባሲክናዋ ዎልግፌና ዎልጉሲክና ዲንቀሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ዮሴፍናዋ ማራሚነ ደይ ቤቴሜቅደሲሲ ባሪን ብየቴሴ ዲንቀሴቴ። እንቶባስ ደይ፦ «ናታሶ! አዉኒ ቦርአ እኖትን ኤካ ዛግትሶ? አባኔስኔን ታኔን እኖትን ትርኦ ኤጳን ኔን ሾሌት ፋንርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","የሱስ ዎልግሬ፦ «አዉኒሮን ታን ሾሌፌት? አባታሳ ኬር ፎናክ ሾልሱ ስንናማቶ ኣነ አሩዌትኖ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ስኑንታኖ ባር ማኬና ቾዋሲ ባሶክ ኣነ ጋሎዋ። ");
INSERT INTO jnje_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ኤስታን የሱስ ባሶኔን አነ ዎል ሌ ናዝሬት ሀሚ። ባሶክ ደይ ማእ ይሬ አጃጃሜት ፌር። እንቶባስ ደይ ኤስ ቾዋሶን ዙትራ ንብባሲ ኤጳት ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","የሱስ ደይ ቴችማክ፤ የርአክናዋ አዳክና ሀኦሲ ስናክናዋ አሱሳ ስናክና ድቸት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ሮማኒ ታቶሳ ታቶ ትባርዮስ ታቴና አሲሬ ኡቼ ዎጋሲክ ፐንቴናው ፕላቶስ ዩዳክ ዳሶን ሀእስት ፌር። ሄሮድስ ደይ ጋሊላክ ዳሶን ሀእስት ፌር። ኤሲስማቶ ደይ አይባ ፍልጶስ እቱርያስኖንናዋ ትኮኒዶስኖንና ሀእስር። ልሳንዮስ ደይ አብሳንስኖ ሀእስር። ");
INSERT INTO jnje_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ሃናናዋ ኬያፋና ማግኒ ጋኝኜ ሜኒ ጋኛ፤ ኤስ ካባሲክ ዛካሪያስኒ ና ዮሀኒስ ኢችማ ዳስ ሲ ፌን ሀኦኒ ካማ ባርኪ ያ። ");
INSERT INTO jnje_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ኤስ ባሪ ቦርኣ ዮሀኒስ ዮርዳኖስኒ አካስ ብራቶታ ፋ ዳ ዙታምባሴ አሲስ ኩትፋፌ፦ «ቦርንትስ ፋክያኖን ዳናትክ ሀርምራ ሀጱክቶትዋ» ይት ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ኤስ ባር ደይ ስንናስ ራጁ ኢሳያስ ዮሀኒስኒ ቾዋሲክ ኤካ ይት ትችናስማቶዋ፦ «ኤሴ ሀን ባር ኢችማ ዳስ ሲ ኤካ ይት ቻግፌ አሱኒ ካማዋ፤ ‹ዳሚሳ ኡግናኖን ሆሱት! ኡግናሶን ደይ ሳፕስራ ሆእሱት! ");
INSERT INTO jnje_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ዶኣስ ዙቴራ ካቼራ ቱሙን! ኣማሴዋ ኩማሴ ደይ ዙቴራ ጎሎን! ሀልዳ ኡግናስ ዜጵቶን! ኬቻ ኬቻ ኡግናስ ዳናሮን! ");
INSERT INTO jnje_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","አሱ ዙቴሬ ሀኦሲ ፋቱኖን ብዮ!› » ");
INSERT INTO jnje_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ሀጱክቶክ ዮሀኒስኒክ የ አሱኒ ሜያክ ኤካ ይት ፌር፦ «ንቶ ኡፎን ናንጎታ! ዮናክ ፋ ሀኦሲ ግእስን ኤልላ ኬሳትክ ኦንሶ ንቶክ ማኬሪ? ");
INSERT INTO jnje_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ኤሴ ሀርሙንትሶን ቤስፋ ዎስቶ ዎስቶትታኖ ንብንትስ፦ ‹እንኖ አብራሀምኒ ናንጎታዋ› ይት ቴቴፌት ባሮን ቤይት። ሀኦሲ ሀን ኩኒ ሹኣሲክቶስን ካብግራ አብራሀምኒክ ናንጎታ ዛጉክ ችማናማቶ ንቶክ ማኬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ሀሽ እኦሶን ታስባስ ካርአ ሀኡኒ አንፋላ ሆሬራ ፋርዋ። ኤስ ባሪ ቦርኣ ማአ ጋና ጋኖይ እኦስ ዙቴራ ካቴራ ጌያስ ሀእቶኒርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ዳራስ ደይ ዮሀኒስኒን፦ «ኤኪን አዉ ዛጉንሪንሶ?» ይሬ ማሙሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ዮሀኒስ ዎልግሬ፦ «ሄፕ ማምባ ፌና ባር እሳይሶን ማምባ ፎንቶሲክ እሞዋ። ሙባ ፌና ባር ሙባ ፎንቶሲክ ባጌ እሞዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ግርቦ ዙትፌ ባሶ ደይ ሀጱክቶክ ባርኪ ዬሴሬ፦ «አስሲኛኖ! እንኖ ደይ አዉ ዛጉንሪንሶ?» ይት ማሙሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ባር ደይ፦ «ማክቴ አጃጂስታን ዳይስራ ማምሱትታ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ሜያ ታርኦኒ ሜያ ደይ ዬሴሬ፦ «እንኖ ደይ አዉ ዛጉንሪንሶ?» ይሬ ማሙሴቴ። ባር ደይ ዎልግሬ፦ «አሱሳ ዋጋኖን ሁግናክ ቦኦትታ። ኦኒንኑ ስንፋናነ ኤሻክ ማላቶትታ። ንቶክ እምቴፋ ዎስቶኒ ዋጋስ ሆሮና» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ኤስ ነያሲክ አሱኒ ሜያ ዙቴሬ ክርስቶስኒ ዮሶን አብድክ ኦደት ፌሴቴር። ኤስ ባሪ ቦርኣ ዮሀኒስኒን፦ «ሀን አሱ አዉዛክነ ክርስቶስ ስና ቤዩጝጌሶ?» ይት ንብቤሲስ ሳፋርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ዮሀኒስ ዙታምቤሲሴ አሲክ ኤካ ይ፦ «ታ ንቶትን አካክቱ ሀጵቁና። ስኑንታኖ ታይስታን ደናሎ ቻኣማባሲ ታርአኖኑ ኮታናክ ሾልሱኦናር ዮኒር። ባር ኮርቶ አያናክናዋ ጌያክናቱ ንቶትን ሀጵቁና። ");
INSERT INTO jnje_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ባር ኦዳስታኪ ሜያሶን ሳማ ሀኡናክ ማንሽ ኩሹባስ ፋር። ካይኒናኔን ኦርፎ ካይማ ሜያሶን ቦቶስ ጋግኒር፤ ካድናሶን ደይ ትሹኖይ ጌያክ ኪቹንር» ");
INSERT INTO jnje_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ኤሲስማቶ ዮሀኒስ ሾዎ ኡግናክ ዳራስን ኪትት ሀኦሲ ማአ ኦዱኖን ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ስኑንታኖ ጋሊላኖን ሀእስት ፌ ሄሮድስኒን አይባ ፍልጶስኒ አሱ ሄሮድያዳኖ ኤጵና ቦርአናዋ ኦማ ሾዎ ማጙሱባሲክና ባሪን ኬእ። ");
INSERT INTO jnje_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ሄሮድስ ኤስ ማጙሱባስታ ዳይስሬ ዮሀኒስኒን ታቶኒ ኬር ጌድ። ");
INSERT INTO jnje_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ዳራስ ዙቴሬ ሀጱክቴሬ ኬስናኔን ኦርፎ የሱስ ደይ ሀጱክቴ። ባር ሀኦሶን ሺጴፌን ሳማ ጋችቼ። ");
INSERT INTO jnje_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ኮርቶ አያና ናካሎነ ፋር ስንና ባሳስታ ኬሬ። ኤስ ካባሲክ፦ «ኬሽቴፋና ናታስ ነዋ፤ ኔክቱ ግሬፋውጙዋ» ይፋ ካማ ሳማን ያ። ");
INSERT INTO jnje_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","የሱስ ዳራስ አሱክ ካብፌና ካባሲክ ኬዛስር ዎጋባ ስናና። ዳራሲክ የሱስ ዮሴፍን ና ስንናማቶቱ ቤስቴፋ። ኤሲስ ደይ ዮሴፍ ኤልኒ ና። ");
INSERT INTO jnje_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ኤሊ ማትን ና፤ ማት ሌዊኒ ና፤ ሌዊ ምልኪን ና፤ ምልክ ዮናን ና፤ ዮና ዮሴፍን ና፤ ");
INSERT INTO jnje_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ዮሴፍ ማታትዩን ና፤ ማታትዩ አሞስኒ ና፤ አሞስ ናሆምኒ ና፤ ናሆም ኤስልምኒ ና፤ ኤስልም ናጌን ና፤ ");
INSERT INTO jnje_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ናጌ ማኣትን ና፤ ማኣት ማታትዩን ና፤ ማታትዩ ሴሜይን ና፤ ሴሜይ ዮሴፍን ና፤ ዮሴፍ ዮዳኒ ና፤ ");
INSERT INTO jnje_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ዮዳ ዮናን ና፤ ዮናን ሬስኒ ና፤ ሬስ ዘሩባቤልን ና፤ ዘሩባቤል ሴላትያልኒ ና፤ ሴላትያል ነርኒ ና፤ ");
INSERT INTO jnje_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ነር ምልኪኒ ና፤ ምልክ ሀድን ና፤ ሀድ ኮሳምኒ ና፤ ኮሳም ኤልሞዳምኒ ና፤ ኤልሞዳም ኤርን ና፤ ");
INSERT INTO jnje_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ኤር እያሱኒ ና፤ እያሱ ኤልአዛርኒ ና፤ ኤልአዛር ዩራምኒ ና፤ ዩራም ማታትን ና፤ ማታት ሌዊኒ ና፤ ");
INSERT INTO jnje_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ሌዊ ስሞን ና፤ ስሞን ይሁዳኒ ና፤ ይሁዳ ዮሴፍን ና፤ ዮሴፍ ዮናን ና፤ ዮናን ኤልያኪምኒ ና፤ ");
INSERT INTO jnje_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ኤልያኪም ሜልያን ና፤ ሜልያ ማይናን ና፤ ማይናን ማታትን ና። ማታት ናታን ና፤ ናታ ዳዊትኒ ና። ");
INSERT INTO jnje_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ዳዊት እሴይኒ ና፤ እሴይ እዮቤድን ና፤ እዮቤድ ቦየዝን ና፤ ቦየዝ ሳልሞን ና፤ ሳልሞን ነአሶን ና። ");
INSERT INTO jnje_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ነአሶን አምናዳብን ና፤ አምናዳብ ኣራምን ና፤ ኣራም ኣርንን ና፤ ኣርን ኤስሮምኒ ና፤ ኤስሮም ፋሬስኒ ና፤ ፋሬስ ይሁዳኒ ና፤ ይሁዳ ያቆብኒ ና። ");
INSERT INTO jnje_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ያቆብ ይሳቅኒ ና፤ ይሳቅ አብራሀምኒ ና፤ አብራሀም ታራን ና፤ ታራ ናኮርኒ ና። ");
INSERT INTO jnje_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ናኮር ሴሮህን ና፤ ሴሮህ ሬሁን ና፤ ሬሁ ፌለግን ና፤ ፌለግ ኤቤርኒ ና፤ ኤቤር ሸላህን ና። ");
INSERT INTO jnje_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ሸላህ ካይንኒ ና፤ ካይንኒ አፋርክሳድን ና፤ አፋርክሳድ ሴምን ና፤ ሴም ኖህኒ ና፤ ኖህ ላሜህን ና። ");
INSERT INTO jnje_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ላሜህ ማቱሳላን ና፤ ማቱሳላ ሄኖክኒ ና፤ ሄኖክ ያሬድኒ ና፤ ያሬድ ሜላልኤልኒ ና፤ ሜላልኤል ካይናን ና። ");
INSERT INTO jnje_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ካይናን ሄኖስኒ ና፤ ሄኖስ ሴትን ና፤ ሴት አዳምኒ ና፤ አዳም ሀኦኒ ና ይሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","የሱስ ኮርቶ አያናክ ቱሜ ዮርዳኖሲክ አካስን ዎል። ኤስታን ዛቦ ሀማናክ ኮርቶ አያና ባሪን ዞንሲ። ");
INSERT INTO jnje_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ኢችማ ዳስ ሲ ፌን አቼቻስር ዎና ዳቡሎስ ቦርአ ዎስቶናክ ማምሲ። ኤስ ዎናሲ እሳንነ ኣነ ሙዌ ስንና ቦርአ ኮእባስታ ማክቴ። ");
INSERT INTO jnje_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ዳቡሎስ ደይ የሱስኒን፦ «ኤሴ ነ ሀኦኒ ና ስንፋታነ ሀን ሹኣሶን ቱሻ ስናናክ አጃጆዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","የሱስ ደይ፦ « ‹አሱ ቱሻ ቱሻክ ኣነ ፌፌ› ይስቴራ ትቼራ ፋር» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ኤስታን ደይ ዳቡሎስ የሱስኒን እሳ ቴጋ ድምታ ክሲ። ሀን ዳስታክ ፋ ታቶስኪቶኖን ዙትሬ እሳርጋ ዋልግራ ቤሳት፦ ");
INSERT INTO jnje_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","«ሀን ዳስ ሀእሱሴዋ ኡልፍንባሴ ዙትራ ኔክ እማናዋ። ሀን ባር ዙቴራ ታክ እምቴ ስንና ቦርአ ታ ሾሌና ባርኪ እማክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ኤስ ባሪ ቦርአ ነ ታክ ሳጋደፋታነ ሀን ባር ዙታምባሴ ኔር ስናናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","የሱስ ዎልግሬ፦ « ‹ዳማ ሀኦኔሲክ ሳጋዶ። ባር ባሮን ሺጶ› ይስቴራ ትቼ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ኤሴን ኦርፎ ዳቡሎስ የሱስኒ የሩሳሌም ቤቴሜቅደሲሲ ቴታ ታሜ ዬታት፦ «ነ ሀኦኒ ና ስኒፋታነ ሀንታን ዬት ዳስታክ ፍሌቦ። ");
INSERT INTO jnje_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‹ኔን ኦዶሶናክ ሀኦ ዎሲባሶን አጃጆና። ");
INSERT INTO jnje_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ደይ ዎቾኔስ ሹኣስታ ቱሳኦኖይናማቶ ኩሹቤሲሲክ ቴሬ ኔን ኤጶነዋ› ይስቴራ ትቼራ ፋርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","የሱስ ደይ፦ « ‹ዳማ ሀኦኔሶን ፋታኖታታ› ይስቴራ ትቼራ ፋር» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ዳቡሎስ የሱስኒን ፋታነራ ኮእስናኔን ኦርፎ ካርኦ ዳንነ ዎሉናኔን ኤስ ካባሲክ ቤያ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","የሱስ ኮርቶ አያናን ሁግናክ ቱሜ ዎል ሌ ጋሊላ የ። ባሳ ቾዋሲ ዎላ ኤስ ብራቶስታ ፋ ኬኤሲ ቱሚ። ");
INSERT INTO jnje_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ባር አይሁድኒ ሺጶኒ ኬያሲክቶሲ ባሶትን አሲት ፌር። ዙታምቤሲሴ ባሪን ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ኤሴን ኦርፎ የሱስ ድችና ዳ ናዝሬት የ። ዜሞቲ ዛግት ፌናሲማቶ ቤይሳኒ ዎናሲክ አይሁድኒ ሺጶኒ ኬያስ ሀሚ ሀኦሲ ካማኖን ፌሬቱናክ ካቢ። ");
INSERT INTO jnje_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ራጁ ኢሳያስ ትችና ማፃፋኖን እሜቴ። ዎሬ ኤካ ይስቴራ ትቼ ድማ ዳኒ፦ ");
INSERT INTO jnje_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«ዳሚሳ አያና ታይስታቱ ፋ፤ ቱካምኒ ሜያክ ማአ ምስራቹኒ ኦዱሶን ማኮናክ ታሲ፤ ታቴሬ ፌሴ ሜያ ኮቶሶነክ፤ ኣፍትሹኒ ሜያ ብዮሶነክናዋ፤ ራክኮስ ፌሴ ሜያኖን፤ ብርማዱማ ክሱናክቱ ታን ሙድ። ");
INSERT INTO jnje_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ደይ ዳሚስ ዳራባስን ፋቱና፤ ዎጋሶን አዋጆናክቱ ታን ዎሲ።» ");
INSERT INTO jnje_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ፌሬታት ትቻሶን ብሪሬ ዎስትኛሲክ እማት ድ። አይሁድኒ ሺጶኒ ኬያስ ዲሴ ባሶ ዙቴሬ ባሪን ኮትክሬ ብያ ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ባር ደይ ባሶክ፦ «ሀሽቲ ፌሬቴፌን ኦደት ማፃፋሲ ካማ ሀሽ ሀውጙ ኮእዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ባሶ ዙቴሬ ባሳ ቻዋሶን ማአሪክ ዎሉምሴቴ። ዎል ሌፌና አካማ ኬሹ ካማሲክ ዲንቀሴት፦ «ሀን ባር ዮሴፍን ናስቴኖሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","የሱስ ባሶክ፦ « ‹ነ ሄትኒ አሱኖ፤ ቴትኔሶ ፋቱዋ!› ይፋ ቤሶሶን ታይስታ ማኮትማቶ አሪፋውጙዋ። ኤሲስማቶ ደይ ክፍርናሆሙክ፦ ‹ዛግት ይስቴን ኦደኒ ባሮን ዙትራ ሀን ኮንቴታ ዳስታኪ ደይ ዛጉዋ› ይሴፌት» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ፉቶ ንቶክ ማኬፋውጙዋ፤ ራጁኡስ ኮንቴና ዳስታኪ አሱባስ ባሪን ኣነ ኡልፍንስፌ። ");
INSERT INTO jnje_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«ፉቶሶን ንቶክ ማኮናዋ፤ ራጁ ኤልያስኒ ነያሲክ ኬዝ ዎጋነዋ እሱን አስሳነ እሮ ኣነ እቻ ስንና ቦርአ ዳ ዙታምባሴ አሲስታ አካማ ማካ ስኒ። ኤስ ካባሲክ እስራኤልኒ ዳስታክ ሾዎ ድቻ አሱ ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ስኑንታኖ ኤልያስ ስዶና ይስቴፋ ዳስታክ ፋ ስራፕታ ይስቴፋ ኬኤስ እሳ ድቻ አሱክቱ ዎስቴሬ ሀሚቴኖ ኦማ ኦኒክኑ ኣነ ዎስቴሬ ሀሜ። ");
INSERT INTO jnje_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ኤሲስማቶ ራጁ ኤልሳኒ ነያሲክ እስራኤልኒ ዳስታክ ሾዎ አዋታቶኒ ሜታን ፌሴቴር። ስኑንታኖ ሶርያክ አዋታቶኒ ሜታን ስና ኒማንቱ ፋሪርቴኖ ባሶስኒ ኦኑ ኣነ ፋሩዌ።» ");
INSERT INTO jnje_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","አይሁድኒ ሺጶኒ ኬያስ ዲሴ ባሶ ዙቴሴሬ ኤስ ባሮን ኦደሴቴይሴ አካማኖን ግእቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ካብሴሬኑ የሱስኒ ጉችቼ ዛቴ ካታማስ ጌራካሎ ክሴቴ። ጋዉስ ቱግሬ ሀኡክ ሾልሴፋት ባሶ ካታማስ ኬቴና ኩማስታ ኤጴ ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ስኑንታኖ ባር ባሶ ጋነያሲ ካሞ አቴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ኤስታን የሱስ ጋሊላክ ዳስታክ ፋ ክፍርናሆም ይስቴ ካታማሲ ሀሚ። ኤስታክ ቤይሳኒ ዎናሲክ ዳራስን አሲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","አሲፌና ካባሲክ ሀእሱኒ ሁግናባ ፌና አሱኒማቶ ስንና ቦርአ ዲንቀሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ኤስ አይሁድኒ ሺጶኒ ኬያስ ኪና አያና ኤጵና እሳ አሱ ፌር። ባር ደይ ቻጌት ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«ናዝሬትክ የሱስኖ! እንኖ ነኔን አነ አዉኒ እሳርን ፋሪንሶ? እኖትን ትሽኩታክ ያታሮሶ? ነ ኦ ስኒታማቶ ታ አሪፋውጙዋ፤ ነ ሀኦሲ ኮርቶዋ!»። ");
INSERT INTO jnje_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","የሱስ ኪና አያናሶን፦ «እሳ ካማ ኮትኖይ አሱሳስኒ ኬስ!» ይሬ ኬእ። ኪና አያናስ ዳራሳ ስና አሱስን ጋንስራ እሳንነ ሚርኦኖይ ጋፍኪራ ኬስ። ");
INSERT INTO jnje_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","አሱኒ ሜያ ዙታምቤሲሴ ባሶትና ባሶትና፦ «ሀን ማክቴፋ ካማ አሮ ካማንሶ? አካማ ሀእሱኒ ሁግናክናዋ ካምባስ ግዶክና ኪና አያናሶን ኬእን ባርኪቶ ደይ ጋፍኪራ ኬሳር» ይሴት ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","የሱስ ዛግና ቾዋሲ ዎላ ኤስ ዳሲ ብራቶታ ዎሉምቴራ ዝእ። ");
INSERT INTO jnje_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","የሱስ አይሁድኒ ሺጶኒ ኬያስኒ ኬሴ ስሞኒ ኬር ሀሚ። ኤስታክ ስሞኒ አሱስ እንቶ ጉምታኒ ሜሮ ሜቴራ ኩኒር ስንና ቦርአ፦ «የሱስኒን ፋቱዋ» ይሴሬ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","የሱስ ደይ ባርኪ ቴሻ ታእሴሬ የሬፋት ሜሮስ ባሮ ኮፍኩናክ አጃጀን ሜሮስ ደይ ባሮን ጋፍኪ፤ ዳኩን ካብራ ባሶትን እርባሲ። ");
INSERT INTO jnje_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","አዋ ግሪፋና ካባሲክ አሱኒ ሜያ ሾዎ ቴሳ ሜሮክ ሜቴሬ ፌሴ ሜታን ሜያኖን ዙትሬ የሱስኒክ ኤጴ ዬሴቴ። ባር ደይ እሳ እሳርቤሲሳታ ኩሹባሲክ ታእሬ ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ኪና አያናሲክቶ ደይ ሾዎ አሱኒስን፦ «ነ ሀኦኒ ናዋ!» እያፋ ቻጋ ኬሴት ፋሴር። ባር ሙድቶ ስኒባሶ ኪና አያናሲክቶ አሪሴር ስንና ቦርአ የሱስ፦ «እሳ ካማነ ኮታታታ!» ይሬ ኬእሬ ካሊ። ");
INSERT INTO jnje_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ዎንፋና ካባሲክ የሱስ ኤስታን ኬሴ አሱ ፎንቶ ፉችቻ ድምታ ሀሚ። አሱኒ ሜያ ባሪን ሾሌሬ ዳነሬ፦ «እኖትን ቤያ ሀማታታዋ» ይት ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ስኑንታኖ የሱስ ባሶክ ዎልግሬ፦ «ታ ዎስቴራ ያናስ ኤስ ባርኪ ስንና ቦርአ ሀኦሲ ታቶኒ ምስራቹኒ ካማኖን ኦማ ካታማስ ፌ አሱኒ ሜያክ ሀማ ማኮናክ ሾልሱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ኤስ ባሪ ቦርኣ ዩዳኒ ዳስታክ ፋ አይሁድኒ ሺጶኒ ኬያሲክቶስ ግሪፋፌ ካምባሶን ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","እሳ ዎና የሱስ ጌንሳሬትኪ ባርስ ሀአ ፌን ሾዎ አሱኒ ሜያ ኤክ ባርኪ ታእሴሬ ሀኦሲ ካማኖን ኦዶክ ቱግሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ባር ኤስ ባርሲ ሀአ የሬ ሄፕ ጎኑ ቢ። ኩርጡምሚ ኤሸፌ ባሶ ጎኑስን ኬሬሬ ዩጉዶቤሲሶን ሜእሴድፌር። ");
INSERT INTO jnje_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","የሱስ ስሞኒር ስና ጎኑሲ ግሪ። ስሞኒን፦ «ሀን ጎኑሶን ዳስታኪ ኤክ አካስታ ጋሮኖን ታክ ችክሱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ዎሉምባሶ ኮእስናኔን ኦርፎ ስሞኒን፦ «ጎኑሶን ትርእማሲታ ኤክሳት ነኔን ነ ዞሞኔሳክቶኔን ኩርጡሚሶን ኤሻክ ዩጉዶንትሶን ትርማሲ ሀኡትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ስሞን ዎልግሬ፦ «አስሲኛኖ! ዋላሶን ዙትራ ካቤት ሀእራ እሳንነ ኣነ ዳነኒዋ። ስኑንታኖ ሀሽ ነ ማኬታኔን ኩርጡሚሶን ኤሻክ ዩጉዶሶን አካሲ ሀኡናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ኤስ ባሮን ዛግሶቤሲሴ ዩጉዶስ ካራቶናኔን አካማ ሾዎ ኩርጡምሚ ሆጰቴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ኤስታን ኦማ ጎኑስታ ፌ ዞሞቤሲሳክቶ ዬሴሬ አሪጋሶነክ ግጵሶክ ቴግሴቴ። ባሶ ደይ ዬሴሬ ሄፕ ጎኑሶን አካስ ኮርአናኔን ኩርጡሚክ ቱንሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","ባርናዋ ባሳ ዞሞሳክቶና ዙቴሬ ኤጴቴ ኩርጡሚስ ኣታማክ አካማኖን ዲንቀሴቴ። ስሞን ጴጥሮስ ደይ ስና ቾዋሶን ብያት የሱስኒ ስና ካአነሬ፦ «ዳሚሶ! ታ ቦር ስንና ቦርአ ታይስታን ኤክሶዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ኤሲስማቶ ስሞኒ ዞሞ ስና ዘብደዎስኒ ናንጎትስ ያቆብናዋ ዮሀኒስና ዲንቀሴቴ። የሱስ ስሞኒን፦ «ሀሬዋ ድጎታታ! ሀውጙኔን ኤካሎ አሱኒ ሜያኖን ሀኦስኪ ዙቱኒር ስናታዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ባሶ ደይ ጎኑቤሲሶን አካስን ክስሬ ዳስታክ ኩንሳት ዙታምባሴ አሲን ቤየ የሱስኒ ናዎ ስንነቴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","እሳዋ የሱስ እሳ ካታማስ ፌን አቱባሶን አዋታቶኒ ሜሮ ኮእስና አሱ ባሪን ቢሬ ስኒባ ካአነፋት፦ «ዳሚሶ! ሾሌፋታነ ታን ካይምሱክ ችማታዋ» ይት ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","የሱስ ኩሹባሶን ሾሬ አቱባሶን ታፕትፋት፦ «ሾሌፋዉጙዋ! ፋሩዋ!» ይ። ጌሬጌሬ ሜሮባስኒ ፋሪ። ");
INSERT INTO jnje_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ቱስሬ ደይ የሱስ፦ «ሀን ስና ቾዋሶን ኦንክኑ ማኮታታዋ። ስኑንታኖ ሀምፋት ካይምኔሶን ማግኒክ ቤሱዋ። አሱሲክ ዛላ ስናናክ ካይምኔሶን ቤስፋ ሙሴ አጃጀና ማኣሶን እማ» ይሬ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","የሱስ ዛግና ቾዋሲ ዎላ ዜሞቲስታን ታግ። ሾዎ አሱኒ ሜያ ባርኪን ኦዶክናዋ ሜሮቤሲስኒ ፋሩሶነክና ሾልሴፋት ዙቴሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ስኑንታኖ የሱስ ባር ባር ሾዎ ዎና ሻቶ ድምስ ሀምፋፌ ሺጴት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","እሳ ዎና የሱስ አሱኒ ሜያኖን አሲፌን ፌርሳዊኒ ሜናዋ ሙሴኒ ቱማሲ አስሲኛኒ ሜና ባሳ ቴሻ ዲሴፌር። ኤስ ባሶ ጋሊላናዋ ዩዳክ ኬኤ ዙታምባሴ አሲስና ደይ የሩሳለሙንና ዬሴቴር። የሱስ ሜታኒስን ፋቱና ሀኦሲ ሁግና ባርኔን አነ ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","አሱኒ ሜያ እሳ ላፋ አሱኒን ኩጶታ ዎርኤሬ የሱስኒክ ዬሴቴ። ላፋስን የሱስ ፌና ኬያስ ጌደ ባሳ ስና ኩንሱክ ሾልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ስኑንታኖ አሱሳ ሾዎታን ካብ ቾዋ ላፋ አሱስ ኬር ጌዳክ ኣነ ችሞቶ። ኤስ ባሪ ቦርኣ ኬያስ ቱክታ ኬስፋት ይሮሶን ቦጌ ላፋስ ኩጶባሴ ኬር ጌደ አሱሳ ጋነሲ የሱስኒ ስና ኩኑሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","የሱስ ባሶ አማንቶሶን ብያት ላፋስን፦ «ነ ሀን አሱሶ! ቦርኔስ ፌሹን ይስቴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ሙሴኒ ቱማሲ አስሲኛናዋ ፌርሳዊኒ ሜና፦ «ሀኦስታ ሜእን ካማ ማኬፌስ ሀን ባር ኦንሶ? ቦርኣሶን ፌሹን ኡክ ችምኒስ ሀኦ ባር ባርታኖ ኦም ኦንሶ?» ይት ንቤሲሲ ሳፋርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","የሱስ ደይ ንቤሲሲ ሳፋራኖን አሪፋት፦ «ንብንትሲ አዉኒሮን ኤካ ሳፋሬፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‹ቦርኔስ ፌሹን› ይስቴዋ ኡስታናዋ፦ ‹ካብራ ሀማ› ኡስታና ኣፋሪንሶ? ካሾይ? ");
INSERT INTO jnje_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ስኑንታኖ አሱኒ ና ሀን ዳስታክ ቦርኣሶን ፌሹን ኡና ሀእሱኒ ሁግናባ ፋናማቶ አሩትክ ሾልስፋዋ» እያት ላፋስን፦ «ነ ሀን አሱሶ ካብራ ኩጶኔሶን ዎርአ ኬነ ሀማ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ጌሬጌሬ ላፋስ አሱሳ ስና ካብሬ ኩና ኩጶሶን ዎርኤ ሀኦ ጋላቴት ኬባ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ኤስ ባሮን ብያ አሱኒ ሜያ አካማኖን ዲንቆክናዋ ድጋክና፦ «ሀውጙ ዲንቂ ዉዛ ቢኒ» ይሴት ሀኦሶን ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","የሱስ ኤስታን ኬሴ ሀሚፌና ካባሲክ ሌዊ ይስቴ ግርቦ ዙት አሱ ግርቦ ዙቴፋና ኬያስ ዲፋ ዋጋ ዙትፌን ቢሬ፦ «ታኔን አነ ሀሚንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ሌዊ ፋ ዉዛሶን ዙትሬ ቤይፋት ካብሬ የሱስኔን አነ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ኤስታን ሌዊ ኬባስ የሱስኒክ አካማ ኮታ ሆሲ። ኤስ ኮታስታ ሾዎ ግርቦ ዙትፌ ባሶናዋ ኦም እርባና ቴግቴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ፌርሳዊኒ ሜናዋ ባሶ ኬን ስና ሙሴኒ ቱማሲ አስሲኛና የሱስኒ ናዎሳክቶኒታ፦ «ንቶ አዋጋን ግርቦ ዙትፌ አሱኒ ሜያኔናዋ ቦርእኛኒ ሜያኔና እሳሪክ ማራ ኡሽትፌትሪንሶ?» ይት ኡኚሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","የሱስ ደይ ዎልግሬ፦ «ሜታኒ ሜያክታኖ ፋያንክ ሄትኒ አሱ ኣነ ሾልስፌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ታ ያናይ ቦርን ሜያኖን ሀኦሲክ ዎልጉክታኖ ካይምኒ ሜያኖን ቴጎክ ኣነ ዮትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ባሶ ደይ፦ «ሀጵቅፌ ዮሀኒስኒ ናዎስናዋ ፌርሳዊኒ ሜኒ ናዎሳክቶና ሾዎ ዎና ሶሜሬ ሀኦ ሺጵሴቴር። ስኑንታኖ ነ ናዎሳክቶ አዉኒ ቦርአንሶ ሜሬ ኡሸፌይስ?» ይሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","የሱስ ዎልግሬ፦ «ማሪስ አነ ፌን ሞዝግቱሳክቶ ሶሜሬ ሺጶሶናነ ፋር ስንና ቤስቴፋዎሶ? ");
INSERT INTO jnje_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ስኑንታኖ ማሪ ባሶስታን ኦር ኬሳና ዎና ዮና። ኤስ ካባሲክ ሶሜሬ ሺጶሶነዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ቱስሬ ደይ የሱስ እሳ ቤሶ ባሶክ ማኬ፦ «ጋድዶ ማያስታን ኤርቤ ካርኤ ኩርኡ ማይታ ኩንስሬ ዞርፌር ኣፌ። ዛግቴፋናነ ጋድዶሶን ካራስር። ጋድዶ ኤርቤስ ደይ ኩርኡስኔን እሳር ኣፋ ስናናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ኤሲስማቶ ደይ ኩርኡ ሀማቶስ ጋድዶ ዋይኒን ኡሻ ጌድፌ አሱ ኦኑ ኣፌዋ። ጌድፋናነ ጋድዶ ዋይኒን ኡሻስ ሀማቶሶን ካራስር፤ ባር ደይ ዉክቴር፤ ሀማቶስ ደይ ኬእኖር ስናር። ");
INSERT INTO jnje_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ኦራ ዋይኒን ኡሻሶን ጋድዶ ሀማቶስ ጌዳ ሾልስፋ። ");
INSERT INTO jnje_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ሾዎ ዎና ካጋ ድ ዋይኒን ኡሻሶን ኡሻ አሱ ጋድዶሶን ኡሻናክ ኣነ ሾሌፌ። ‹ካጋ ዋይኒን ኡሻስቱ ማአሪዋ› ኡቱ ኡና» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ቤይሳኒ ዎናክ የሱስ ፎሻስታ ካሞ አቴ ሀምፌን ባሳ ናዎሳክቶ ዛጎኒ ቦና ቡግሬ ሞኤ ኮየቴ። ");
INSERT INTO jnje_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ፌርሳዊኒ ሜያስን እሳ እሳይስ፦ «ቤይሳኒ ዎናክ ዛግቶናክ ሾልሱኖይ ዉዛሶን አዉኒሮን ዛግድፌትሪንሶ?» ይሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","የሱስ ዎልግሬ፦ «ዳዊትናዋ ባርኔን አነ ፌ አሱኒ ሜና ማክቴሴፌ ካባሲክ ባር ዛግና ባሮን ኣነ ፌሬትራ ብየትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ሀኦሲ ኬር ግሪሬ ማግኒ ሜያክታኖ ኦም አሱ ሙኖይና ሀኦኪ እምቶ ቱሻሶን ኤጴ ሜ። ባርኔን ፌሴ ባሶክ ደይ እሚ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ኤስታን የሱስ፦ «አሱኒ ና ቤይሳኒ ዎናስ ዳምዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ኦማ ቤይሳኒ ዎናክ ደይ አይሁድኒ ሺጶኒ ኬያስ ግሪሬ አሲት ፌር። ኤስታ ሆእታ ኩሹባ ላፋ ስና እሳ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ሙሴኒ ቱማሲ አስሲኛናዋ ፌርሳዊኒ ሜና የሱስኒ ማላሶነ ኡግናን ዳናክ ሾልሴፋት፦ «ቤይሳኒ ዎናሲክ አሱኒን ፋቱኒቶ ብያንዋ» ይት ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ስኑንታኖ የሱስ ባሶ ንብባሲ ሳፋራኖን አሪፋት ኩሹባ ላፋ አሱስን፦ «ካብራ ጋነያስ የሮዋ» ይ። ባር ደይ ካብሬ ጋነያስ የሬ። ");
INSERT INTO jnje_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ኤስታን ባሶትን፦ «ታ ንቶትን ማምሱናዋ፤ ቤይሳኒ ዎናሲክ ማአሮን ዛጉጝዋ ወደይ ማጙኖን ዛጉንሶ? ካኒ ፋቱጝዋ ወደይ ትሽኩንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ብራቶባስታ ፌ አሱስ ዙትሬ ቢናንኔን ኦርፎ ላፋ አሱስን፦ «ኩሹኔሶን ዜጵዋ» ይ። ባር ደይ ዜጲን ኩሹባስ ደይ ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ሙሴኒ ቱማሲ አስሲኛናዋ ፌርሳዊኒ ሜና አካማኖን ግእቴሴሬ የሱስኒስታ አዉ ዛግሶነማቶ ባሶትና ባሶትና ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ኤስ ዎናስ የሱስ ሺጶናክ ደን ኣማስታ ኬሲ። ኤስ ዋላሶን ዙትሬ ሀኦሲክ ሺጴት ሀእ። ");
INSERT INTO jnje_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ዎኒፋና ካባሲክ ናዎባሳክቶኒን ባርኪ ቴጌ። ባሶስን አሲሬ ሄፔስን ኮሪሬ፦ «ዎሲ» ይሬ ቴጌ። ");
INSERT INTO jnje_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ባሶ ደይ ጴጥሮስ ይሬ ቴጌና ስሞናዋ አይባ እንድርያስ፥ ያቆብ፥ ዮሀኒስ፥ ፍልጶስ፥ ቤርቴለሜዎስ፥ ");
INSERT INTO jnje_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ማትዎስ፥ ቶማስ፥ እልፍዮስኒ ና ያቆብ፥ ኮነር ይስቴፌ ስሞን፥ ");
INSERT INTO jnje_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ያቆብን ና ይሁዳናዋ ኦርፎ የሱስኒ ኣትሬ እማ አሲኮሮትኪ ይሁዳናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","የሱስ ዎስባሳክቶኔን ኣማስታን ኬሬሬ ጎሎ ዳስታክ የሬ። ናዎኒ ሜያስን ሾዎቤሲስ ደይ ኤስታ ፌሴቴር። ኤሲስማቶ ሾዎ አሱኒ ሜያ ባርኪን ኦዶሶነክናዋ ሜሮቤሲስኒ ፋርሶነክና ዩዳኒ ዳስታክ ፋ የሩሳሌምኒ ካታማ፤ ባርስ ሀእታክ ፋ ካታማ ትሮሱናዋ ስዶናና የ ሾዎ ዳራ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ኪና አያናክ ኦቴሬ ሜቴት ፌሴ ባሶ ደይ ፋርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ሀኦሲ ፋቱኒ ሁግና የሱስኒስን ኬስፋፋ ዙታምቤሲሴ ፋቲት ፋር ስንና ቦርአ ኤስታ ዙቴሬ ፌሴ አሱኒ ሜያ ባሪን ታእሴሬ ፋርሶነክ ሾልሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","የሱስ ናዎባሳክቶኒክ የርቀሬ ብየት ኤካ ይ፦ «ሀኦሲ ታቶኒ ሀእሱ፤ ንቶር ስንና ቦርአ፤ ንቶ ቱካሚስ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ሀሽ ማክቴት ፌ ንቶ፤ ጋዉትር ስንና ቦርአ ሱስቶዋ። ሀሽ ዋሴፌ ንቶ፤ ዎል ምአትር ስንና ቦርአ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«አሱኒ ና ስንና ታ ቦርአ አሱኒ ሜያ ንቶትን ኦምቴሴሬ፥ ኮሪሬ፥ ካሽሴሬናዋ ንቶክ ማጙ ሱና እሜፌ ካባሲክና ንቶ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ሳማኪ ዋግንትስ አካማ ስንና ቦርአ ሀን ባር ዙታምባሴ ንቶስታ ካርፋና ካባሲክ ግሮት ደይ ፍሎት። ዜሞቲ አባቤሲሳክቶ ደይ ራጁኒ ሜያስታ ኤካቱ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«ስኑንታኖ ንቶ ኦቱምኖ! ሀን ዳስታኪ ፎንትሲክ፤ ሾልሱ ዉዛሶን ዳነቲ ቦርአ፤ የሬፋዉትዋ፤ ");
INSERT INTO jnje_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ሀሽ ጋው ንቶ፤ ዎል ማክቶትር ስንና ቦርአ ሀይቡንትዋ፤ ሀሽ ምእፌ ንቶ፤ ዎል ሱሜራ ዋሱትር ስንና ቦርአ፤ ሀይቡንትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«አሱኒ ሜያ ዙቴሬ ማእንትሶን ማክሴፌ ንቶ ሀይቡንትዋ። ባሶ አባስኑ ኤሽኒ ራጁኒ ሜያክ ኤካቱ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«ስኑንታኖ ኦደፌ ንቶክ ኤካ ይፋዉጙዋ፥ ጉማንትስኒ ሹንት። ንቶትን ኦምቴፌ ባሶክ ማአሮን ዛጉት። ");
INSERT INTO jnje_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ንቶትን ኤርውፌ ባሶትን ኤቢሱት። ንቶትን ሚርኤፌ ባሶክ ደይ ሺጶት። ");
INSERT INTO jnje_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","እሳ ጋችኔሶን ቦቻ ባርኪ ሄፕሳሶን ደይ ቦቻናክ ቤሱ። ኮትኔሶን ኤጵፌ ባርኪ ሻምስኔሶን ዳይስራ እማ። ");
INSERT INTO jnje_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ኔኪን ሺጴፌ ባሶክ እማ። ዋግኔሶን ኤጳ ባሪን ኔክ ዎልጉናክ ማምሱታታ። ");
INSERT INTO jnje_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","አሱኒ ሜያ ንቶክ ዛግሶነክ ሾሌፌት ባሮን ንቶ ደይ ኤሲስማቶ ባሶክ ዛጉትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ንቶትን ሹንፌ ባሶትን ሹንፋትነ አሮ ጋድዶ ዉዛ ዳናትሪንሶ? ቦርን ሜያኑ ባሶትን ሹነፌ ባሶትንቱ ሹነፌ። ");
INSERT INTO jnje_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ማአሮን ንቶክ ዛግ ባሶክ ማአሮን ዛግፋትነ አሮ ጋድዶ ዉዛ ዳናትሪንሶ? ቦርን ሜያኑ ኤሲሶንቱ ዛግሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","‹ኮዋ ካሶነዋ› እያት ባሶክ ልቅሳትነ አሮ ጋድዶ ዉዛ ዳናትሪንሶ? ቦርን ሜያኑ ኤስ ልቅስሴቴ ባሮን ዎልግሬ ኤጳሲክ ቦርን ሜያ ቦርን ሜያክቱ ልቀስሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ስኑንታኖ ንቶ ጉማንትሲ ሹንት። ባሶክ ደይ ማአሮን ዛጉት። ‹ዎልግራ ኤጳንዋ› ይራ አብድ ዛጉኖይ ልቀሱት። ኤስ ባሮን ዛጋትነ ዋግንትስ አካማ ስናና። ደይ ዙታምባሴ አሲ ደናሎ ስና ሀኦሲ ናንጎታ ስናት። ሀኦሲ ባሮን ጋላቶኖይ ባሶክኔናዋ ማጙኒ ሜያክኔና ጋራማዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ሳማኪ አባንቲስ ኬናሽቴር ስንና ቦርአ ንቶ ደይ ኬናሽቴር ስኒትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«ኦኒስታኑ ማጝሱ ካርአትታ፤ ንቶስታ ደይ ኣፋ ማጝሱ ካቶና ዉዛ። ንቶ አሱኒስታ ናልጋ ዎስቶትታ፤ ንቶስታ ናልጋ ኣፋ ስናናዉዛ። ፌሹን ኡት ንቶክ ደይ ፌሹን ኡስቶና። ");
INSERT INTO jnje_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","እምትዋ፤ ንቶክ ደይ እምቶና። ሳፋሬራ እምት ሳፋሬሲክ ዎላ ንቶክ ሳፋርቴራ እምቶና። ማአ ሳፋሬክ ቱማ ትቸራ ትርኤራ ዎቶናኔን ሳፋርቴራ ንቶክ እምቶናዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ደይ ሀን ቤሶሶን ኤካ ይት ማኬ፦ «ኣፍትሹ ኣፍትሹን ዞንሱክ ችምንሮሶ? ዞንሲፋናነ ሄፖባሴ አነ ዛቴሬ ጋዉስቱ ጋንዶሶናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","አሪኛአሲ አስሲኛሳታን ደናሎ ኣፋ ስናናዉዛ። ስኑንታኖ ማእስሬ አሪ አሪኛአሲ አስሲኛስነ ፌር ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ነ ኣፋስ የሬ እኛ እኦሶን ቢኖይ አይኔሳ ኣፍስ ኩን ዲማሶን ኣካክ ቢሶ? ");
INSERT INTO jnje_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ነ ኣፋስ የሬ እኦሶን ቢኖይ ኣካክ አይኔስኒ፦ ‹አይታሶ ኣፍኔስ ኩን ዲማሶን ክሱናሮሶ?› ኡክ ችምሶ? ስኖይ ስንነ ቤስቴፌ ነ ዜምማ ኣፍኔስ ኩን እኦሶን ክሱዋ። ኤስታን አይኔሳ ኣፍስ ኩን ዲማሶን ጋሳሲራ ብያክ ችማታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«ማአ እኦስ ማጙ ጋና ኣነ ጋንፋ። ኤሲስማቶ ደይ ማጙ እኦ ማአ ጋና ኣነ ጋንፋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","እኦ ዙታምባሴ ጋምባሲክቱ አሪቴፋ። ሴርአኪን ቤለስኒ ጋና ኣነ ኬጵቴፋ። አላሉስን ዎይኒን ጋና ኣነ ኬጵቴፋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ማአ አሱ ንብባሲ ፋ ማአ ቾዋሶንቱ ክስፌ። ማጙ አሱ ንብባሲ ቱማ ማጙ ቾዋሶንቱ ክስፌ። አሱ ንብባሲ ቱማ ፉእቴ ባሮንቱ ኖኖባሲክ ዎል ሌፌ። ");
INSERT INTO jnje_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«ታ ማኬና ባሮን ዛጉኖይ አዉኒሮን፦ ‹ዳሚሶ! ዳሚሶ!› ይት ታን ቴጌፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ታክ ዮን ባርናዋ ካምናሶን ኦዴሬ ዎስቶታ ፌሽፌ ባርና ኦነ ፌር ስንናማቶ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ባር ዶኣሶን አካማኖን ዪሸ ካኦስታ ኬባሶን ኬርአ አሱነ ፌርዋ። ኦማራ ያራ ኤስ ኬያሶን ቱግን ኤስ ኬያስ ዪሽቴራ ኬቴና ቦርአ ሾርኩናክ ኣነ ችማ። ");
INSERT INTO jnje_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ካምናሶን ኦዴሬ ዎስቶታ ፌሹኖይ ባር ኬባሶን ማእስሬ ይሽኖይ ፉቱስታ ኬርአ አሱነ ፌርዋ። ኦማራስ ያራ ኬያሶን ቱግፋና ካባሲክ ጌሬጌሬ ጋንደ። ጋንዶባስኑ አካማኖን ማጙ ስን» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","የሱስ ኤስ ባሮን ዙታምባሴ ዳራሲክ ማኬሬ ኮእስናኔን ኦርፎ ክፍርናሆም ይስቴፋ ካታማስ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ኤስታክ እሳ ሮማኒ ት ሜያ ታርኦን ሜኒ ጋኛ ፌር። ባር ደይ እሳ ሹንፌና ዎስትኛባ አካማኖን ሜቴሬ ክቱክ ታእሴሬ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ኤስ ት ሜያ ታርኦን ሜኒ ጋኝኛስ የሱስኒ ቾዋሶን ኦደናይሴ አይሁድኒ ኩርኡኒ ሜያኖን፦ «የሱስ ዬሬ ዎስትኛታስኒ ፋቱናክ ሀማ ታክ ሺጶትዋ» ይሬ ባርኪ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","ባሶ የሱስኒኪ ሀሜሬ፦ «ሀን አሱስ ዳራኒስን ሹናር፤ አይሁድኒ ሺጶኒ ኬያ ደይ ኬርእ፤ ኤስ ባሪ ቦርኣ ሀን ባሮን ባሪኪ ዛጉታክ ሾልሱዋ» ይት ችኒሬ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ኤስ ባሪ ቦርኣ የሱስ ባሶኔን አነ ሀሚ። ኬባሲክ ታእሴፌና ካባሲክ ት ሜያ ታርኦን ጋኝኛስ ዞሞባሳክቶኒን የሱስኒክ ኤካ ይት ዎሲ፦ «ዳሚሶ፤ ነ ታክ ኬር ግሩታክ ታ ሾልሱ አሱቴዋ፤ ኩትራ ሆፑታታ። ");
INSERT INTO jnje_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ታ ቴትናሲክኑ ኔክ ዮናክ ሾልሱ አሱቴዋ። ኤስ ባሪ ቦርኣ ኤክ ፋታስታ ፋጌዶ ካማ ማኮዋ፤ ዎስትኛታስ ደይ ፋሩናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ታ ቴትናሲክ ኦም አእስኛኒ ሜኒ ስካሎስ ሀእ አሱዋ። ታ ስካሎስ ደይ ታ አጃጀፋና ሜያ ታርኦን ሜያ ፌሴቴርዋ። እሳይስን፦ ‹ኤክ ሀማ› እያናነ ሀማር፤ ኦሚስን፦ ‹ሀን ዮዋ!› እያናነ ዬር፤ ዎስትኛታስኒ፦ ‹ሀን ባሮን ዛጉዋ› እያናነ ዛግር» ");
INSERT INTO jnje_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","የሱስ ኤስ ባሮን ኦዴሬ ዲንቀ። የርቀሬ ኦርፎባሴ ዬሴፌ አሱኒ ሜያክ፦ «እስራኤልኒ ዳራሳስንኑ ኤፋቴና አማንቶ ኣነ ዳኑትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ዎስቴሬ የሱስኒክ ሀማ አሱኒ ሜያ ት ሜያ ታርኦሳ ጋኛን ኬር ዎል ሌ ዬሴቴን ዎስትኛስ ፋሪሬ ፌን ዳነቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ዎኖትርክ የሱስ ናይን ይስቴፋ እሳ ካታማ ሀሚ። ባሳ ናዎስናዋ ሾዎ ዳራና ባርኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","የሱስ ኤስ ካታማስ ፍኝታ ካርፌና ካባሲክ አሱኒ ሜያ ዱግኖ ዎርኤሬ ካታማስን ኬሴድፌር። ኤስ ክት ባር ደይ እንቶባሲክ እሳ ባር ባር። እንቶባስ ደይ ድቻ አሱ። ሾዎ ኤስ ካታማስ ዳራ ደይ አነ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ዳሚስ ባሮን ቢሬ ኬናሽቴፋት፦ «ሀሬዌ ዋሱታታዌ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ኤስታን የሱስ ኤክ ስና ታርፋት ሳኦሶን ታእ። ዎርአ ባሶ ደይ የርሴቴ። የሱስ ደይ፦ «ሀን ናኦ ናሶ ካቡዋ ይፋዉጙዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ክቱ ናስ ደይ ካብሬ ዎሎ ኤጲ። ኤስታን የሱስ ናሳ እንቶክ፦ «ናነ ሀንፌዌ» ይት እሚ። ");
INSERT INTO jnje_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","አሱኒ ሜያ ዙታምቤሲሴ አካማኖን ድግሴሬ፦ «አካም ራጁ እንኖ ጋነያስን ካብዋ። ሀኦሲ ደይ ባር ዳራስ አሪጋሱክ ያዋ» ይት ሀኦሶን ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","የሱስ ዛግና ቾዋሲ ዎላ ዩዳኒ ዳስታክናዋ ብራቶባስታክ ፋ ዳ ዙታምባሴ አሲስ ኦድቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ሀጵቅፌ ዮሀኒስኒ ናዎሳክቶ የሱስ ዛግና ቾዋሶን ዙትሬ ዮሀኒስኒክ ማክሴቴ። ናዎባሳስን ሄፕን ቴጌሬ፦ ");
INSERT INTO jnje_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«ኤስ ዮኒር ይስቴ ክርስቶስ ነጝዋ ወደይ ኦምንን ኦዳንሪንሶ? ይራ ማምሱትዋ» ይት የሱስኒክ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ባሶ ደይ የሱስኒክ ሀሜሬ፦ « ‹ኤስ ዮኒር ይስቴ ክርስቶስ ነጝዋ ወደይ ኦምንን ኦዳንሪንሶ?› ይራ ማምሱትዋ ይት ሀጵቁን ዮሀኒስ ኔክ ዎስኒ ያንርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","የሱስ ኤስ ካባሲክ አሱኒ ሜያኖን ሾዎ ሜሮኒስናዋ ኪና አያናሶና አሱሳስኒ ክስ። ሾዎ ኣፍትሹን ሜኒ ኣፋሶን ጋች። ");
INSERT INTO jnje_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","የሱስ ዮሀኒስኒኪን ዎስቴሬ ዬሴ ባሶክ፦ «ሀምፋት ቢት ባሮናዋ ኦደት ባሮና ዮሀኒስኒክ ማኮት። ኣፍትሹን ሜያ ብዮሶነ፤ ኤግትፌ ባሶ ካነ ኩቱሶነ፤ አዋታቶኒ ሜታን ሜያ ካይሞነ፤ ኦዶባ ኦዮስ ኦዶና፤ ክቱስ ካቡና፤ ቱካምኒ ሜያክ ደይ ምስራቹኒ ካማስ ማክቶና። ");
INSERT INTO jnje_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ታ ዎስቴፋና ዎስቶሲክ ቱሳኦኖይ ባር ሱስቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ዮሀኒስኒ ዎሲሳክቶ ዎል ሌ ሀሜቴኔን ኦርፎ የሱስ ዮሀኒስኒ ቾዋሶን ዳራሲክ፦ «ስሩ ሾርክፋና ዋጆሶንጝዋ ወደይ አዉ ብያትክ ዛቦ ያትሶ? ");
INSERT INTO jnje_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ወደይ ኬሹ ማያ ማዮ አሱኒ ሜያኖኖሶ? ኤሴ ኬሹ ማያ ማየ ጌኤፌ ባሶ ታቴ ሜኒ ኬርቱ ፌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ኤኪን አዉ ብያትክ ኬሴትሶ? ራጁኒኖሶ? ኤሴ ንቶክ ማኬፋውጙዋ፤ ባር ራጁሳታን ደናሎዋ። ");
INSERT INTO jnje_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","‹ኤሴ ስኔስታ ሀሚፋፌ ኡጉኔሶን ሳፕሱን ዎስታስኒ ነይስታን ዜምማ ዎሱና› ይስቴራ ትቼናስ ባርዋ ");
INSERT INTO jnje_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ታ ንቶክ ማኬፋውጙዋ፤ ማሽካሱ ኮጰና አሱሳ ጋነስን ዮሀኒስኒስታን ደናሎ ኦኑ ኣፌዋ። ስኑንታኖ ሀኦሲ ታቶስ ፌ አሱሳስኒ አቴስ ባሳስታን ደናሎዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ኤስ ባሮን ኦደሴቴይሴ አሱኒ ሜያ ዙቴሬ ግርቦ ዙትፌ ባሶኔን ዮሀኒስኒክ ዬሴሬ ሀጱክቴሴሬ ፌሴቴር ስንና ቦርአ ሀኦሲ ዎስቶ ፉቶ ስኒባሶን አሪሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ስኑንታኖ ፌርሳዊኒ ሜናዋ ሙሴኒ ቱማሲ አስሲኛና ሀኦሲ ሳፋራኖን ቱጋኦኪ ዮሀኒስኒክ ሀጱክቶ ቤየት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","የሱስ ቱስሬ ደይ፦ «ሀን ነያስ ኮኒቶኖን አዉኔን ሆሱናሪንሶ? አዉነ ፌሴቴሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ጋባታ ዲሴፋት ባሬ ባሬ ቴግሴታፋ፦ ‹ማርካታ ፉግኒ ኣነ ሱርሶዌት፤ ሶሴንክ ኣነ ዋሶዌት› ይሴት ካሴፋ ናንጎታስንነ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ሀጵቁን ዮሀኒስ ቱሻ ሙኖይ ዋይኒን ኡሻ ኡሽኖይ ዬን ንቶ፦ ‹ኪና አያና ፋርዋ› ይሴት። ");
INSERT INTO jnje_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","አሱኒ ና ሜትናዋ ኡሸትና ዬን፦ ‹ሀን ባር ሙነዋ ኡሽነ ሹና አሱዋ፤ ደይ ግርቦ ዙትፌ ባሶክናዋ ቦርን ሜና አሲ ዞሞዋ› ይሴት። ");
INSERT INTO jnje_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ቴችማስ ፉቶ ስና ናንጎትባ ዙታምባሴ አሲስታቱ አሪቴፋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ፌርሳዊኒ ሜያስን እሳር የሱስ ሙ ሙናክ ኬባ ቴጌ። የሱስ ደይ አሱሳ ኬር ሀሜ ሙክ ድ። ");
INSERT INTO jnje_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ኤስ ካታማስ እሳ ቦርእኛ አሱ ፋር። ባር ደይ የሱስ ፌርሳዊሳ ኬር ፎባሶን ኦደፋት አልባስትሮስ ይስቴ ሹአክ ዎሱስቴ ብልቃድስ ሽቶ ኤጳ ኤስታ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","የሱስኒ ኦርፎስታ ዎቾባስ ቴሻ የሬፋት ዋስት ሀራፍባሲክ ሃትራ ሶምባሲክ ኩኤት ፋር። ዎቾባሶን ዳሜት ሽቶክ ዎሽት ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","የሱስኒ ባርኪ ኬር ቴጌ ፌርሳዊስ ኤስ ባሮን ብያት፦ «ሀን አሱ ራጁ ስንፋናነ ሀን ባሪን ፎችፋ አሱስ ኦ ስንናማቶናዋ አሮ ቦርባ ፋናማቶና አሩና ካባዋ» ይት ንብባሲ ሳፋሬ። ");
INSERT INTO jnje_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","የሱስ ደይ፦ «ስሞን፤ ታ ኔክ እሳ ማኮና ዉዛ ፋርዋ» ይ። ባር ደይ፦ «አስሲኛኖ፤ ማአሪዋ ማኮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","የሱስ ደይ፦ «እሳ አሱኒኪን ዋጋ ልቀ ሄፕ አሱኒ ሜያ ፌሴቴርዋ። እሳይስ ኡች ትያ ብር፤ ሄፕሳስ ደይ ኡቻስር ብር ልቅሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ዎልግሬ ካሶነ ዋጋ ትሽፋን ኮዋሶን ሄፖቤሲሴ አሲክ ቤይ። ኤካኒ ሄፖቤሲሴ አሲስኒ ልቅስ ባሪን አካማኖን ሹንስ ኣፌሪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ስሞን ደይ፦ «አካማ ኮዋ ባሳስታ ቤይቴና ባርቶጝዋ» ይ። የሱስ ደይ፦ «ዎልግታ ባር ፉቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ኤስታን የሱስ አሱሲክ የርቀፋት ስሞንክ፦ «ሀን አሱሶ ቢቶሶ? ታ ኔክ ኬር ግሪፋና ካባሲክ ኦርጎናሲክ አካኑ ኣነ ቴሾዌ። ስኑንታኖ ባር ዎቾናሶን ሀራፍባሲክ ሃትራ ሶምባሲክ ደይ ኩእ። ");
INSERT INTO jnje_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ታ ኔክ ኬር ግሪፋና ካባሲክ ነ ታን ኣነ ዳሞዌ። ስኑንታኖ ባር ታ ኔክ ኬር ግርናኔን ሀጝ ኦርጎናሶን ዳሞ ኣነ ዬቱዋ። ");
INSERT INTO jnje_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ነ ቴትናሶን ዛይትክ ኣነ ፎችቼ። ስኑንታኖ ባር ኦርጎናሶን ሽቶክ ዎሺ። ");
INSERT INTO jnje_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ኤስ ባሪ ቦርኣ ኔክ ማኬፋውጙዋ፤ ባር አካማኖን ሹና ቦርአ አካማ ቦርባስ ፌሹን ይስቴዋ። ጋሮ ቦርባስ ፌሹን ይስቴና ባር ጋሮኖንቱ ሹንፌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ኤስታን የሱስ አሱሶን፦ «ቦርኔስ ፌሹን ይስቴዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ባርኔን አነ ሙ ሜት ዲሴ ባሶ ደይ፦ «ቦርኣሶን ፌሹን ይፌስ ሀን ባር ኦንሶ?» ይሴት ንብቤሲስ ሳፋርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ስኑንታኖ የሱስ አሱሲክ፦ «አማንቶኔስ ኔን ፋትዌ፤ ማርኦን ሀሜ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ኤሴን ኦርፎ የሱስ ካታማ ካታማስናዋ ኬኤ ኬኤስና ሀምፋፌ ምስራቹኒ ካማሶን አዋጀት ሀኦሲ ታቶኒ ቾዋኖን ማኬት ፌር። አሲሬ ሄፔ ናዎባሳክቶ ደይ አነ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ኤሲስማቶ ኪና አያና ባሶስኒ ኬስና ማሽካሱነዋ ሜሮስንና ፋርሴ ማሽካሱነ አነ ፌሴቴር። ባሶስን ደይ ናፉን ኪና አያና ባርስን ኬስና ሜግደላውት ስኒፋ ማራሚ፤ ");
INSERT INTO jnje_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ታቶ ሄሮድስኒ ኬያሶን ሀእስፌ ኩዛኒ አሱ ዮሀና፥ ሶስንናነዋ ኦማ ሾዎ ማሽካሱነ ደይ ፌሴቴር። ኤስ ባሶ የሱስኒንናዋ ናዎባሳክቶኒና ዋግቤሲሲክ አሪጋሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ሾዎ ዳራ ደይ ካታማ ካታማስን ባርኪ ዬሴሬ ዙቴሴፌ ካባሲክ የሱስ ሀን ቤሶሶን ባሶክ ማኬ፦ ");
INSERT INTO jnje_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«እሳ ቡልኛ ዛላ ቡካናክ ኬሲ። ቡክፌና ካባሲክ እሳ እሳ ዛላስ ኡግናስታ ዝግራ የቴ። ካሳስ ደይ ማ። ");
INSERT INTO jnje_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ኦማ ዛላስ ካኦስታ ዎርእ። ካይፋና ካባሲክ አርባ ትሽና ቦርአ እችሚ። ");
INSERT INTO jnje_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ኦማ ዛላስ ደይ ሴርኣስ ጋነሲ ዎርእ። ሴርኣስ አነ ካይራ ጌርአ ትሽክ። ");
INSERT INTO jnje_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ኦማ ዛላስ ማአ ሆኣስ ዎርእ። ካይራ ድቻ ትያ ኩሹኖን ዳይስራ ጋኒ» ይ። ኤስ ባሮን ማኬሬ ኮእስናሴ ካምባሶን ቴግሬ፦ «ኦዶባ ፌናስ ኦዶዎዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ናዎባሳክቶ የሱስኒን፦ «ሀን ቤሶስ ኮትባ ኣምባንሶ?» ይሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","የሱስ ደይ ኤካ ይሬ ባሶክ ዎልጊ፦ «ሀኦሲ ታቶኒ ኣቾ ቾዋኖን አሩትክ ንቶክ እምቴዋ። ስኑንታኖ ኦምን ሜያክ ቾዋ ዙቴራ ቤሶክቱ ማክቴፋዋ። ባሶ ብየፌት ኣነ ያዳቴሴፌ። ኦደፌት ደይ ኣነ ጋሳሲሴፌ። ");
INSERT INTO jnje_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ቤሶስ ኮታ ሀኒስዋ። ዛላስ ሀኦሲ ካማዋ። ");
INSERT INTO jnje_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ኡግናስ ሀእታ ዎርአ ዛላስ ካምባሶን ኦደፌ አሱኒ ሜያዋ። ስኑንታኖ ባሶ አማነሬ ፋርሶኖይቴማቶ ዳቡሎስ ዬሬ ሀኦሲ ካማኖን ንቤሲስኒ ኤጵፌ። ");
INSERT INTO jnje_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ካኦስታ ዎርአ ባር ካምባሶን ኦደሴፌ ካባሲክ ግራክ ኤጴቴሴፌ ባሶዋ። አማንቶቤሲስ ኤስ ካባሲክ ስኒፋት ታስባ ኣፋ ስንና ቦርአ ፋታና ካርፋና ካባሲክ ታእንንቱ ካደሴፌ። ");
INSERT INTO jnje_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ሴርኣስ ጋነሲ ዎርአ ዛላስ ካምባሶን ኦደፌ ባሶዋ። ስኑንታኖ ሀን ዳስታኪ ፋ ፎኒ ሳፋራክ፥ ኦቱምኒ ዳኒ ሳፋራስናዋ ማአ ፎኒ ጌኣስ ጌርአና ጋንቤስ ፎንቶ ዛግፋ። ");
INSERT INTO jnje_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ማአ ሆኣስ ዎርአ ዛላስ ማአ ቱማ ንባክ ካምባሶን ኦዴሬ ዎስቶታ ፌሽፌ ባሶዋ። ካምባሲክ ዛግሬ ጋና ጋነቴር። ");
INSERT INTO jnje_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«ቶና ቶኒሬ ዋሺ ወደይ ኩጶን ስካሎስ ዱስፌ አሱ ኣፌ። ስኑንታኖ ኬር ግሪፌ አሱ ቻሬፋሶን ብያናክ ቴጋ ድምታ ዱስፌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","አማኖ ኬስኖር ኣቾ፥ አሪቶኖር ቻሬፋስታ ኬስኖይ ኣቾ ዉዛ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ኤሴ ኣካክ ኦዶትማቶ ጋሳሱትዋ። ፌና ባርኪ ዳይስቴራ እምቶና። ስኑንታኖ እሳ ዉዛባ ፎንቶስ ታክ ፋርዋ ይፌና ባርኑ ባሳስታን ኦቴር» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","የሱስኒ እንቶሴዋ አይባሳክቶና ባርኪ ዬሴቴ። ስኑንታኖ ዳራሳ ሾዎታን ካብ ቾዋ ባሪን ኡጶክ ኣነ ችሞቶ። ");
INSERT INTO jnje_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","አሱኒ ሜያ የሱስኒክ፦ «እንቶኔሴዋ አይኔሳክቶና ኔን ብያክ ሾሌሬ ጌሮ የርሴፌዋ» ይሬ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","የሱስ ደይ፦ «እንቶናሴዋ አይታሳክቶና ሀኦሲ ካማኖን ኦደሴሬ ዎስቶታ ፌሽፌ ባሶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","እሳ ዎና የሱስ ባሳ ናዎሳክቶኔን ጎኑስታ ዲፋት፦ «ሀን ባርስ የሳሎ ፍናኒዋ» ይ። ባሶ ደይ ፍናክ ካብሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ባሪስታ ሀሜፌን የሱስ አፋይኒ ኩን። ኤስ ካባሲክ አካስታ አካማ እፑዋ ካቢ። አካ ጎኑስ ቱሜት ሀሚባሴ ዙታምቤሲሴ አሲን ትርኦ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ኤስ ካባሲክ ናዎባሳክቶ፦ «ዳሚሶ! ዳሚሶ! ኮኡኒርዋ!» ይት የሱስኒን ጉዝግሴቴ። ባር ደይ ጉዝሬ እፑዋሴዋ አካስ ጉቦነ አሲን ኬእን ጌሬጌሬ ሻክ ደይ አካማ ናጋ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ኤሴን ኦርፎ የሱስ ባሶክ፦ «አማንቶኒትስ አይፋሶ?» ይ። ስኑንታኖ ባሶትና ባሶትና ድጋክናዋ ዲንቆክና፦ «እፑዋሴዋ አካስ ጉቦነ አጃጃሜናር ሀን ባር ኦንሶ?» ይሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ባሪሶን ፍነሬ ጋሊላክ ዳስ የሳሎ ፋ ጌራሴኖን ካርኤቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","የሱስ ጎኑስን ዳ ኬሬፌና ካባሲክ ኪና አያና ባሳስ ፋና እሳ አሱ ካታማስን ኬሴ ኡጰ። ኤስ አሱስ ማይባሶን ጋኣኤ ሀኣት አታቱ ኩቱ ኤጵና ዎናስ ዎክ። ፌፌናስ ደይ ሞግን ብራቶታታኖ ኬርታ። ");
INSERT INTO jnje_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","የሱስ ኪና አያናሶን አሱሳስን ኬሳናክ ኬእና ቦርአ ባሪን ቢናይሴ ስኒባ ጋንደራ ካምባሶን ቴግራ፦ «ነ ዙታምባሴ አሲስታን ደናሎ ስና ሀኦሲ ና የሱስኖ! ታኔን አዉኒ እሳርነ ፋሪንሶ? አዳራዋ ታን ኪቹታታዋ!» ይት ቻጊ። አካማ ነያ ባሳስ ዲር ስንና ቦርአ ሻሻራክናዋ ዎቾኒ ግኖክና ታቴሬ ኦድቴት ፌር። ስኑንታኖ ሻሻራሶን ቡግት ዎቾኒ ግኖሶን ኪርኤት ፌር። ኪና አያናስ ደይ ዛቦ ኤጳ ሀሜት ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","የሱስ ደይ፦ «ነ ሱነ ኦንሶ?» ይሬ ማምሲ። ሾዎ ኪና አያና ግርራ ፋር ስንና ቦርአ፦ «ለጌዎኒ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ኪና አያናሲክቶ ደይ፦ «እኛ ጋዉስ እኖትን ካላ ጋፍኩታታዋ» ይት የሱስኒን ሺጵሴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ኤስ ድማስታ ፋ ኩማስ ቴሽታ ሾዎ ሙኮ የሬፋት ማድፋር። ኪና አያናሲክቶ፦ «ኤክ ሙኮስ ግሩኒክ አጃጆዋ» ይራ የሱስኒ ሺጵሴ። ባር ደይ፦ «ሀማ ግሩት» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ኪና አያናሲክቶ አሱሳስን ኬሳ ሙኮሲክቶሲ ግርሴ። ሙኮሲክቶ ደይ ኩማስታን ሻራስቴት ባሪሲ ግርራ ኮቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ሙኮሶን ኬምፌ ኬሜሪሳክቶ ስና ቾዋሶን ብየፋት ኤለሬ ሀሜ ካታማ ካታማስናዋ ኬኤ ኬኤስና ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","አሱኒ ሜያ ደይ ዛግቴ ቾዋሶን ብያክ ኬቤስ ኬቤሲስኒ ኬሴሬ የሱስኒክ ዬሴቴ። ሾዎ ኪና አያና ባሳስኒ ኬስና አሱስ ንባ ዎልን ማያ ማየ የሱስኒን ዎቾስ ቴሻ ዲፌን ብየሬ ድጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ሾዎ ኪና አያናስ ባሳስኒ ኬስና አሱስ ኣካክ ፋርናማቶ ኣፋክ ብያ ባሶ አሱኒ ሜያክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ኤሴን ኦርፎ ጌርጌሴኖንኪ አሱኒ ሜያ ዙቴሬ አካማኖን ድግሴቴ ቦርአ የሱስ ኤስታን ሀማናክ ሺጵሴቴ። የሱስ ደይ ጎኑሲ ዲሬ ዎል ሌ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ሾዎ ኪና አያና ባሳስኒ ኬስና አሱስ፦ «ነኔን አነ ሀማናዋ» ይት የሱስኒን ሺጴ። ስኑንታኖ የሱስ ኤካ ይት ማኬሬ ጋፍኪ፦ ");
INSERT INTO jnje_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«ኬነ ዎላ ሀምፋት ሀኦ ኔክ ዛግና ቾዋሶን ዙትራ ማኮዋ» አሱስ ደይ የሱስ ባርኪ ዛግና ቾዋሶን ካታማስ ኩትፋት ማኬት ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ዳራ ዙቴሬ የሱስኒን ኦደት ፌሴቴር ስንና ቦርአ ዎል ሌ ዬፌና ካባሲክ ግራክ ኤጴቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ኤስ ካባሲክ አይሁድኒ ሺጶኒ ኬያስ ጋኛ ሱንባ እያሮስ ይስቴ አሱ የ። የሱስኒ ዎቾስ ጋንደሬ ባርኪ ኬር ሀማናክ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ኔባስ አሲሬ ሄፔ ስና እሳ ማሽካ ናዉባስ ሜቴራ ክቱክ ካርአ ፋር ስንና ቦርአቱ ኤስ ባሮን ዛግ። የሱስ ባርኔን አነ ሀሚፌና ካባሲክ አነ ሀሚፌ ዳራስ ኡግናሶን ትርስሬ ቱግት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","አሲሬ ሄፔ ነያ ባርስኒ ሀና ዉክቴት ፋና እሳ ማሽካሱ ደይ ፋር። ባር ደይ ፋ ዋግባሶን ዙትራ ሄትኒ አሱኒክ ኮእስ። ኦኑ ባሮ ፋቱክ ኣነ ችሜ። ");
INSERT INTO jnje_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ባር ደይ ኦርፎ ካሞ ያራ የሱስኒ ማማስ ፋሻኖን ታእ። ጌሬጌሬ ዉክቴት ፋ ሀርንባስ የሬ። ");
INSERT INTO jnje_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","የሱስ ደይ፦ «ታን ታእ ኦንሶ?» ይሬ ማምሲ። ዙቴሬ፦ «እንኖ ኣነ ታኡዌኒዋ» ይሴቴ። ጴጥሮስ ደይ፦ «ዳሚሶ፥ ዳራ ዙቴሬ ኔን ጋነያ ጌደ ቱግሬ ትርስፌን ቢፋት ታን ታእ ኦንሶ?» ይፋቶሶ። ");
INSERT INTO jnje_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ስኑንታኖ የሱስ፦ «ሁግና ታይስን ኬስናማቶ አሪጙዋ፥ ፉቶሲክ እሳ አሱ ታን ታእዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ማሽካሱስ ደይ ኣቾኖይ ኮርክት ያራ የሱስኒ ስና ሳጋደ። አዉኒሮን ባሪን ታእናማቶናዋ ኣካክ ጌሬጌሬ ፋርናማቶና ዳራ ዙታምባሴ አሲ ስናክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","የሱስ አሱሲክ፦ «ናናሴ አማንቶኔስ ኔን ፋትዌ። ናጋክ ሀሜ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","የሱስ ኤስ ባሮን ማኬፌን እሳ አሱ አይሁድኒ ሺጶኒ ኬያስ ጋኛ እያሮስኒ ኬሩን ዬሬ፦ «ናነ ክትዋ። ሀንኔን ኤካሎ አስሲኛስን ባክ ሆፕሱታታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ስኑንታኖ የሱስ ኤስ ባሮን ኦዴሬ እያሮስኒን፦ «ሀሬዋ! ድጎታታ። አማንቶዋ፥ ናኔስ ፋሩናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","የሱስ እያሮስኒ ኬር ካርፌና ካባሲክ ባርኔን አነ ግሪስ ጴጥሮስ፥ ዮሀኒስ፥ ያቆብናዋ ናዋስ አባኔን እንቶኔንታኖ ኦም ባርኔን ግርሶነክ ኣኔ ሾሎዌ። ");
INSERT INTO jnje_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","አሱ ዙቴሬ፦ «ይ! ይ!» ይት ዋሴድፌር። ስኑንታኖ የሱስ፦ «ዋሱትታ፥ ናዋስ ኩኑቱ ኩኒታኖ ኣነ ክቱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","አሱኒ ሜያ ናዋስ ክቱባሶን አሪሴቴ ቦርአ የሱስኒስታ ምኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ስኑንታኖ የሱስ ኩሹባሶን ዛቴ፦ «ሀን ናዋሴ ካቡዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ናዋስ ደይ ካባ ዎልን ጌሬጌሬ ካብራ ድ። የሱስ ደይ፦ «ሙና ሙባ እሞትዋ» ይሬ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ኮኒ አባስናዋ እንቶሴ ዲንቀሴቴ። ስኑንታኖ የሱስ ስና ቾዋሶን ኦኒክኑ ማክሶኖይቴማቶ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","የሱስ አሲሬ ሄፔ ዎስኒ ሜያኖን ባርኪ ቴጌሬ ኪና አያናሶን አሱኒስኒ ክሶነክናዋ ሜሮ ዙታምባሴ አሲስን ፋቱሶነክና ግዶነዋ ሀእሱኒ ሁግናነ ባሶክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ኤሲስማቶ ደይ ሀኦሲ ታቶኒ ካማኖን አሱ ዙታምባሴ አሲክ ማክሶነክናዋ ሜታን ሜያኖን ፋቱሶነክና ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ኤካ ደይ ይ፦ «ኡጉንትሲክ ስኒ ሃሮ ስኑን፥ ሀማቶ ስኑን፥ ቱሻ ስኑን፥ ዋጋ ስኑን፥ ማይት ባርስታን ኦማኖን ዳይስራ ኤጳ ሀማትታ። ");
INSERT INTO jnje_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ኤስ ግርት ካታማስን ኬሳትኔን ዜምማ ግርት ኬያስ ፎቲ። ");
INSERT INTO jnje_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","አሱኒ ሜያ ንቶትን ኤጴቶ ቤየፋቴነ ኤስታን ኬስፌት ካባሲክ ኦርጎንትስ ቱሎሶን ቴብራ ዎቱት። ኤስ ባር ደይ ባሶስታ ዛላ ስናና» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ዎስኒ ሜያ ደይ ኬሴሬ ምስራቹኒ ካማሶን ማኬት ሜታኒስን ፋቲት ኬኤ ኬኤሲ አቴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","እሳ እሳ አሱኒ ሜያ፦ «ሀጵቅፌ ዮሀኒስ ክቱኒ ካብዋ» ይሴት ፌሴቴር ስንና ቦርአ ጋሊላኪ ዳሶን ሀእስፌ ሄሮድስ የሱስ ዛግና ቾዋሶን ዙትሬ ኦዴሬ ኤጴ አጉናዉዛ ዳጌ። ");
INSERT INTO jnje_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ኤሲስማቶ እሳ እሳ አሱኒ ሜያ፦ «ራጁ ኤልያስ ዎል ሌ የዋ» ይሴቴን፥ ኦሚስ ደይ፦ «ዜሞቲ ራጁኒ ሜያስን እሳይስ ክቱኒ ካብዋ» ይሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ሄሮድስ ደይ፦ «ሀጵቅፌ ዮሀኒስኒን ታ ሱትባሶን ካትራ ዎሪጝዋ። ኤኪን ሀን ኦደፋና ባር ኦንሶ?» ይ። ኣፋሲክ ደይ ብያናክ ሾሌ። ");
INSERT INTO jnje_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ዎስኒ ሜያ ሀሜቴስን ዎል ሌ ዬሴሬ ዛግሴቴ ዉዛሶን ዙትሬ የሱስኒክ ማክሴቴ። ባር ደይ ቤቴሳይዳ ይስቴፋ ካታማስ ቴሻ ፋ ሻቶ ድማ ባሶ ባሶትን ኤጴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ዳራስ ደይ የሱስ አይ ሀሚድፌናማቶ አሪፋት ባሶ ኦርፎሴ ሀሜቴ። የሱስ ደይ ሹነ ሀኦሲ ታቶኒ ቾዋኖን ባሶክ አሲ። ሜሮስኒ ፋሩክ ሾልሴሬ ዬሴ ባሶትን ደይ ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ጌሮ ዋልፋና ካባሲክ አሲሬ ሄፔ ናዎባሳክቶ የሱስኒክ ዬሴሬ፦ «ሀን ፋኒ ድማስ ዛቦዋ። ኤስ ባሪ ቦርኣ ዳራስ ብራቶስታ ፋ ካታማስናዋ ቤደስና ሀሜ ሙነዋ ኩኑን ድምነ ሾልሶነክ ጋፍኩዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","የሱስ ዎልግሬ፦ «ንቶ ሙሶነ ባሮን ባሶክ እምትዋ» ይ። ባሶ ደይ ዎሉግሴሬ፦ «እኖክ ፋዪስ ኡች ሙማ ቱሽነዋ ሄፕ ኩርጡሚነዋ። ኤስ ባር ደይ ሀማ ዋጌራ ዳይሱ ሻካኒነ ሀን ኤፌ ዳራሲክ ኣፋዋ ሆሮና ዉዛ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ኤስታክ ኡች ኩም ስኒ ኣርቃሱ ፌር። የሱስ ናዎባሳክቶኒክ፦ «ኡቻስር ኡቻስር ዛግራ ባግ ባጋ ዱሱትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ባሶ ደይ የሱስ ማኬናሲማቶ ዱስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ኤስታን ኡች ሙማ ቱሻሴዋ ሄፕ ኩርጡሚሴ ካብግሬ ደን ሳማ ካነ ሀኦ ጋላቴፋት ባቴ ዳራሲክ ሃኦነክ ናዎባሳክቶኒክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ዳራ ዙቴሬ ሜሬ ጋዊ፤ ናዎኒ ሜያ ደይ ፉእቴ ባቶሶን ናዎባስ ዙትሴቴን አሲሬ ሄፔ ማሳ ቱማ ካቢ። ");
INSERT INTO jnje_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","እሳ ዎና የሱስ ባር ባር ሀኦ ሺጴፌን ናዎባሳክቶ ባርኪ ዬሴሬ ፌሴቴር። የሱስ ደይ ባሶትን፦ «አሱኒ ሜያ ታን ኦ ይሴፌሶ?» ይሬ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ባሶ ደይ ዎልግሬ፦ «እሳ እሳይስ ሀጵቁን ዮሀኒስዋ። እሳ እሳይስ ኤልያስ፥ ደይ ኦሚስ ዜሞቲ ራጁኒ ሜያስን እሳይስ ክቱኒ ካብዋ ይሴፌዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ባሶክ ደይ፦ «ኤካን ንቶ ታን ኦ ይፌትሶ?» ይሬ ማምሲ። ጴጥሮስ ዎልግሬ፦ «ነ ሀኦኪን ዎስቴሬ የ ክርስቶስዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","የሱስ ባሶክ፦ «ኤስ ባሮን ኦኒክኑ ማኮትታ» ይት ችኒሬ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ቱስሬ ደይ፦ «አሱኒ ና አካማ ሻና ኤጴቶናክ ሾልሱዋ። ኤሲስ ደይ ኩርኡኒ ሜያክ፥ ማግኒ ጋኛንክ፥ ሙሴኒ ቱማሲ አስሲኛኒክ ካሽስቶና ደይ ዎርቶና። ኬስናር ዎኖ ደይ ክቱኒ ካቡና» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ኤስታን ደይ ዙታምቤሲሴ አሲክ፦ «ታኔን አነ ሀማክ ሾሌፌ ባር ኦኑ ስንፋናነ ባሳ ቴትን ቾዋሶን ቤዮ። ዎንና ዎንና ሜስቀልባሶን ዎርኤ ታኔን አነ ዮዎዋ። ");
INSERT INTO jnje_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ካባሶን ፉኦክ ሾሌፌ ባር ዙቴሬ ካባሶን ትሽኩና። ታክዋ እያት ካባሶን ኣትሬ እምፌ ባር ካባሶን ፉኦና። ");
INSERT INTO jnje_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","አሱ ዙቴሬ ሀን ዳስታኪ ኦትማሶን ዳናት ካባሶን ትሽካናነ ወደይ ዮእጋናነ ባርኪ አዉ ኬእንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ኦኑ ስንፋናነ ታክናዋ ታ ካማሲክና ኢቼፌ ባር አሱኒ ና ባሳ ኡልፍንቶሲክናዋ ሳማኪ አባባሳ ኡልፍንቶክና ደይ ኮርቶ ሀኦሲ ዎስያሲክቶኒ ኡልፍናክ ዬፌና ካባሲክ ባርኪ ኢቾና። ");
INSERT INTO jnje_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ፉቶ ንቶክ ማኬፋውጙዋ፥ ሀንታ ዬሴ ባሶ ጋነያስን ሀኦሲ ታቶኖን ብዮኖይ ክቱኖር ፌሴቴርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","የሱስ ኤስ ባሮን ማኬና ናጙሪን ዎናኔን ኦርፎ ጴጥሮስኒን፥ ዮሀኒስናዋ ያቆብንና ዞንስሬ ሀኦ ሺጶናክ እሳ ኣምታ ኬስ። ");
INSERT INTO jnje_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ኤስታክ ሺጴፌን ስኒባስ ግቶባስ ሶልቴ። ማምባስ ደይ ፎሬራ ፓልፓሊ። ");
INSERT INTO jnje_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ጌሬጌሬ ሄፕ አሱ ሙሴናዋ ኤልያስና የሱስኔን ኡጰሬ ዎሉምሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ኡልፍናክ አምማኖን ቤስቴሴሬ የሱስ የሩሳለሙክ ሻና ኤጴቶናማቶናዋ ክቱናማቶና ዎሉምሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ስኑንታኖ ጴጥሮስናዋ ባርኔን አነ ፌ ባሶና አፋይ ኤጳን ኩነቴር። ጉዝሴሬ የሱስኒ ኡልፍናሶንናዋ ባርኔን አነ ዎል ሌት ፌ ሄፕ አሱኒ ሜያኖና ብየቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ኤስ አነ ዎሉምሴት ፌ አሱኒ ሜያ የሱስኒስታን ኦር ኬሴሬ ሀሜፌ ካባሲክ ጴጥሮስ፦ «ዳሚሶ ሀንታ ፎስ እኖክ ማአሪዋ። ኬዝ ሀፎ ሀኡንዋ። እሳር ኔር፥ እሳር ሙሴኒር፥ እሳር ደይ ኤልያስኒር» ይ። ስኑንታኖ አዉ ማኬድፌናማቶ ኣነ አሩዌ። ");
INSERT INTO jnje_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ጴጥሮስ ኤስ ባሮን ማኬፌን ሻሩ ያራ ባሶትን ይኒ። ሻሩስ ይኒፋና ካባሲክ ድጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ሻሩስ ካሞ፦ «ታ ኮርና ናታስ ሀኒስዋ። ባሪን ኦዶትዋ» ይፋ ካማ ያ። ");
INSERT INTO jnje_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ኤስ ካማስ ኦድቴናኔን ኦርፎ የሱስ ባር ባር ቤስቴ። ናዎባሳክቶ ደይ ብየቴ ዉዛሶን ኤስ ካባሲክ ኦኒክኑ ማክሶኖይ ሻክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ዎኖትር ዎኖ ኣማስታን ኬርሴቴኔን ኦርፎ ሾዎ ዳራ የሱስኒክ ሁጰ። ");
INSERT INTO jnje_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ኤስ ዳራሳ ጋነስን እሳ አሱ ኤካ ይት ቻጊ፦ «አስሲኛኖ፥ ሀን ባር ታክ እሳ ናታዋ፤ ያራ ብያታክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ኪና አያናስ ባሪን ቻግሲር። ዳስታክ ጋንስራ ደይ ቶኮናክ ዛግራ ጉሳ ካርአሪ። አቱባሶን ማዛስራ ሚርኤናኔን ኦርፎ አካማ ሻናክ ቤይፋ። ");
INSERT INTO jnje_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ነ ናዎሳክቶ ኤስ ኪና አያናሶን ናሳስን ክሶነክ ሺጴና ኣነ ችሞቶ።» ");
INSERT INTO jnje_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","የሱስ ኤስታ ፌ ዳራስን፦ «አማንቶኒት ፎንቶ ኤሊጛ ኮኒቶ፥ ኣጌኔን ካርአ ንቶኔን አነ ፎናሪ? ኣጌኔን ካርአ ንቶትን ፋ ኩናሪንሶ? ናኔስን ሀጝ ቴሸቦ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ናስ ሀጝ የሱስኒክ ታእሴፌና ካባሲክ ኪና አያናስ ናስን ዳስታክ ጋንስን ቶኬ። ስኑንታኖ የሱስ ኪና አያናሶን ኬእሬ ናስን ፋትሬ አባባሲክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","አሱኒ ሜያ ዙቴሬ ሀኦሲ አካማ ሁግናኖን ብየሴቴ ቦርአ ዲንቀሴቴ። አሱ ዙቴሬ የሱስ ዛግና ዉዛሲክ ዲንቀሴፌን የሱስ ናዎባሳክቶኒክ ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«ሀን ማኬፋና ካማሶን ጋዝግራ ኦዶትዋ። አሱኒ ና አሱኒ ሜኒ ኩሹስ አቴሬ እምቶኒርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ስኑንታኖ ኤስ ባር ማኬና ባር ኣነ ባሶክ ጋሎዋ። ኤስ ዎላስ ኣቾ ቾዋኖን አሪሶነክ ኣነ ችሞቶ። ዎልግሬ ማምሱክ ደይ ድጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ናዎባሳክቶኒ ጋነሲ፦ «እንኖስን ኦንሶ አሪክሪ?» ኡኒ ካራካሮ ካቢ። ");
INSERT INTO jnje_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ስኑንታኖ የሱስ ባሶ ንብባሲ ሳፋራኖን አሪፋት እሳ ጋሮ ናኒን ቴሸሬ ቴሽባ ዬት። ");
INSERT INTO jnje_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ኤስታን ባሶክ፦ «ሀን ጋሮ ናስን ታ ሱናሲክ ኤጴቴ ባር ኦኑ ስንፋናነ ታን ኤጴቶናዋ። ታን ኤጴቴ ባር ዎሲ አባታስን ደይ ኤጴቶናዋ። ንቶ ጋነያስን አቴስ ዙታምንትሴ አሲስታን አሪክርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ዮሀኒስ ደይ የሱስኒን፦ «ዳሚሶ፥ እሳ አሱ ነ ሱናሲክ ኪና አያናሶን አሱኒስኒ ክስፌን ቢራ እኖኔን አነ ስና ቤይና ቦርአ ካልንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","የሱስ ዎልግሬ፦ «ንቶትን ኦምቶኖይ ባር ዙቴሬ ንቶኔን አነ ስንና ቦርአ ካላትታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","የሱስ ደን ሳማ ሀማና ዎና ካርባሴ የሩሳሌም ሀማናክ ቡድሬ ካቢ። ");
INSERT INTO jnje_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ባሳስታን ዜምሜ ስና ሀሚን ዎስኒን ጋፍኪ። ባሶ ደይ ሾልሱሶን ዙትሬ ሆሱሶነክ ሳማሪያኪ ፋ እሳ ኬኤስ ካርኤቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ስኑንታኖ የሩሳሌም ሀሚንር ስኒባሶ አራት አሱኒ ሜያ ኣነ ኤጴቶሶቶ። ");
INSERT INTO jnje_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ናዎባሳስን ያቆብናዋ ዮሀኒስና ኤስ ባሮን ብያት፦ «ዳሚሶ፥ ደን ሳማን ጌያ ኬሬራ ባሶትን ኪቹናክ አጃጆንክ ማእ ኡታሮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ስኑንታኖ የሱስ የርቀሬ ባሶትን ኬእ። አሮ ቴሳ አያና ንቶኔን አነ ፋናማቶ ኣነ አሩዌትዋ። አሱኒ ና ዬናስ አሱኒ ካኒ ፋቱክታኖ ትሽኩክታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ኤስታን ካብሴሬ ኦማ ኬኤስ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","የሱስናዋ ናዎባሳክቶና ኡጉነ ሀሜፌን እሳ አሱ፦ «ነ ሀሚታ ሀሚታስ ነኔን አነ ሀማናክ ሾሌፋኡጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","የሱስ ዎልግሬ፦ «ቦዋሲክቶ ዶእባ ፋርዋ። ካሳስ ደይ ኬባ ፋርዋ፥ ስኑንታኖ አሱኒ ና ቴትባሶኑ ቴሱና ድምባ ኣፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ደይ ኦም አሱኒን፦ «ታኔን ሀሚንዋ» ይ። አሱስ ደይ፦ «ዳሚሶ፥ ዜምማ ሀማ አባታስን ካባሮናክ ማእ ኡዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","የሱስ ዎልግሬ፦ «ክቱኒ ሜያ ክቱቤሲሶን ካባርሶነክ ቤይዋ። ስኑንታኖ ነ ሀማ ሀኦሲ ታቶኒ ቾዋኖን ማኮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ኦም አሱ ደይ፦ «ዳሚሶ ነኔን አነ ሀማናዋ። ስኑንታኖ ዜምማ ሀማ ታክ ኬርክ አሱኒ ሜያኖን ማርኦን ፎቲ ኡናክ ማእ ኡዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","የሱስ ደይ፦ «ጋቹኒ ቦዳ ኤጳት ኦርፎ የርቀፌ አሱ ሀኦሲ ታቶክ ሾልሱቴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ኤሴን ኦርፎ ዳሚስ ኦም ናፉናስሬ ሄፐ አሱኒ ኮሪሬ ባር ሀማና ካታማስናዋ ኬኤ ዙታምባሴ አሲስ ዜምሜ ሀሞነክ ሄፕ ሄፕ ዛግሬ ጋፍኪ። ");
INSERT INTO jnje_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ኤካ ደይ ይ፦ «ኤሴ ፍኦሻስ ታጋዋ። ስኑንታኖ ዙቱኒ ዎስትኛኒ ሜያ ጋሮዋ። ኤስ ባሪ ቦርኣ ፎሻስ አባ ዎስትኛኒ ሜያኖን ዳይስሬ ጋፍኩናክ ሺጶትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ኤሴ ሀሚትዋ! ንቶትን ፋንቱኒማቶ ዛግራ እሪርካስ ጋነሲ ዎሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ኡጉንትሲክ ስኒ ዋግን ካርድድ ስኑን፥ ሀማቶ ስኑን፥ ቻማ ስኑን ኤጳትታ። ኡግናስታ የሬራ ኦኒንኑ ስንፋናነ ናጋ ኦሾትታ። ");
INSERT INTO jnje_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ኣፋ ኬርኑ ግሪፌት ካባሲክ ዜምማ፦ ‹ናጋ ሀን ኬያሲክ ስንፋውጝዋ› ኡት። ");
INSERT INTO jnje_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ኤስ ኬያስ ናጋ ሹና አሱ ፌፋናነ ናጋንትስ ኤስ አሱሳስ ፎና። ኤካ ስና ሻካናነ ናጋንትስ ንቶክቱ ዎሉና። ");
INSERT INTO jnje_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ዎስትኛ ዎስቶባስ ዋጋኖን ዳናናክ ሾልሱዋ። ኤስ ባሪ ቦርኣ ዜምማት ግርት ኬያስ ፋፋት እሜቴ ባሮን ማትናዋ ኡሸትና ፎቲ። እሳ ኬሩን እሳ ኬር ሀማትታ። ");
INSERT INTO jnje_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ኣፋ ካታማስኑ ግሪፌት ካባሲክ አሱኒ ሜያ ንቶትን ኬቤሲስ ኤጴቴሬ እሜቴ ባሮን ሙሶት። ");
INSERT INTO jnje_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ኤስ ካታማስ ፌ ሜታኒሳክቶኒን ፋቱት። ዳራሲክ ደይ፦ ‹ሀኦሲ ታቶ ንቶክ ታእሴዋ› ይት ማኮት። ");
INSERT INTO jnje_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ስኑንታኖ ኣፋ ካታማስ ሀማ ግርን አሱኒ ሜያ ንቶትን ኤጴ ያቦስታ ቤየፋቴነ ኣፋ ካታማን ዳራ ዙቴፌና ቱናስታ ኬስፋት፦ ");
INSERT INTO jnje_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹ዎቾኒስታ ፋ ቱሎሶን ሀን ቱናስታ ቴቡንዋ። ስኑንታኖ ሀኦሲ ታቶ ንቶክ ታባሶን አሩትዋ› ");
INSERT INTO jnje_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ንቶክ ማኬፋውጙዋ፥ ማጝሱኒ ካርን ዎኖ ኤስ ካታማስታክ ካርን ማጝሱኒ ካርኣስታን ሶዶምን ካታማስታ ካርን ማጝሱኒ ካርኣስቱ ካሾዋ። ");
INSERT INTO jnje_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«ሀይቡነዌ ኮራዝን! ሀይቡነዌ ቤቴሳይዳነ! ንቶስታ ዛግቴ ቢስቴራ አሪቶኖይ ዉዛስ ትሮስኒስታናዋ ስዶናኒስታና ዛግቴ ስንፋናነ ዜምሜ እቤ ማጝሱቤሲስኒ ዎልሴሬ ሱሞን ማማ ማየሬ ቤድና ዎችሴሬ ሀርሙሶነ ካባዌ። ");
INSERT INTO jnje_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ኤስ ባሪ ቦርኣ ማጝሱኒ ካርን ዎኖ ንቶስታን ትሮሲክናዋ ስዶናክና ካሾቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ክፍርናሆምነ! ደን ሳማ ቴጉክ ሾሌቶሴ? ዎላ ዬት ኬኦኒ ድማስቱ ኬሮታዌ። ");
INSERT INTO jnje_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","«ንቶትን ኦደ ባር ታን ደይ ኦዶና። ንቶትን ኤጴቶ ቤያ ባር ታን ኣፋ ኤጴቶና ዉዛ። ታን ኤጴቶ ቤያ ባር ደይ ታን ዎሲ ባሪን ኣፋ ኤጴቶና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ዎስቴሬ ሀማ ናፉናስሬ ሄፐ አሱኒ ሜያ ግራክ ዎል ሌ ዬሴቴ። የሱስኒክ ደይ፦ «ዳሚሶ፥ ኪና አያናስኑ ነ ሱናሲክ አጃቼዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","የሱስ ባሶክ ኤካ ይ፦ «ሴጣናስ ካዉንማቶ ደን ሳማን ኬሬ ዎርድፌን ቢጝዋ። ");
INSERT INTO jnje_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ኤሴ ዛዋሴዋ ጋምዛቶሴ አሲን የርአትክ ጉማንትሳ ሁግና ዙታምባሴ አሲስታ ሀእሱኒ ሁግና እምጝዋ። ንቶትን ሚርኦን ዉዛ እሳንነ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ስኑንታኖ ኪና አያናስ ንቶክ አጃቾባሲክ ግሮትታዋ። ሱንትስ ደን ሳማ ትቾባሲክ ግሮትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ኤስ ካባሲክ የሱስ ኮርቶ አያናን ግራክ ቱሜ፦ «ሳማሴዋ ዳሴ አሲ ዳም ስና አባታሶ፥ ሀን ባሮን ዙትራ ቴቹምን ሜያክናዋ አሩና ሜያክና ኣችራ ሀን ዳግ አሱኒ ሜያክ አምማኖን ቤስታ ቦርአ ኔን ጋላቴፋዉጙዋ። ኣ፥ አባታሶ፥ ሀን ባር ነ ማአ ሳፋራሲክ ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«ዙታምባሴ አባታስኪን ታክ እምቴዋ። ናስ ኦ ስንናማቶ አባስቴኖ ኦኑ አሪፌር ኣፌ። ኤሲስማቶ ደይ አባስ ኦ ስንናማቶ ናስ ወደይ ባር አማ ቤሱናክ ሾሌና ባርቴኖ ኦም ኦኑ አሪፌር ኣፌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ደይ የሱስ ናዎባሳክቶኒክ የርቀሬ ባሶ ባሶክ፦ «ሀን ንቶ ቢፌት ባሮን ቢፌ ባሶ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ንቶክ ማኬፋውጙዋ፥ ሾዎ ራጁኒ ሜናዋ ታቴ ሜና ሀን ንቶ ቢፌት ባሮን ብዮነክ ሾልሴት ፌሴቴር። ስኑንታኖ ኣነ ብዮቶ። ንቶ ኦደፌት ባሮን ኦዶሶነክ ሾልሴት ፌሴቴር። ስኑንታኖ ኣነ ኦዶሶቶ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","እሳ ዎኖ ሙሴኒ ቱማሲ አሩ የሱስኒክ የ። ባሪን ፋታኖናክ ሾሌፋት፦ «አስሲኛኖ፥ ኮእባ ፎንቶ ካ ዳናናክ አዉ ዛጉናክ ሾልስፋሶ?» ይሬ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","የሱስ ዎልግሬ፦ «ቱማስ አዉ ይስቴራንሶ ትቼናሪ? ፌሬትራ አሮ አሩ ዳንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","አሱስ ዎልግሬ፦ « ‹ቱማስ ማኬፋናስ ዳማ ሀኦኔሶን ቱማ ንብኔሲክ፥ ቱማ ካኔሲክ፥ ቱማ ሁግናኔሲክናዋ ቱማ ሳፋራኔሲክና ሹጝዋ› ደይ፦ ‹አሱ ዙታምባሴ አሲን ነ ነ ቴታሶን ሹንፋታስማቶ ሹጝዋ› ይስቴራቱ ትቼዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","የሱስ ደይ፦ «ማአሮንቱ ዎልግትዋ። ኤሴ ነ ደይ ኤሲስማቶ ዛጉዋ። ኮእባ ፎንቶ ካ ደይ ዳናታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ስኑንታኖ አሱስ ቴትባሶን ኦኮ ዛጉክ ሾሌፋት፦ «አሱ ዙታምባሴ ኦንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","የሱስ ኤካ ይሬ ዎልጊ፦ «እሳ አሱ የሩሳለሙን ካብሬ እያሪኮ ሀሚፌን ኡጉንታ ቦእኛኒ ሜያ ዳነሬ ማይባሶን ጋኣኤ እቼ ካ ካክ ሀኣት ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ዲንቆነ እሳ ማግ ኤስ ኡግናሲክ ሀማስ እቼሬ ኩን አሱስን ብያት ሻቴሬ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ኤሲስማቶ ደይ እሳ ሌዊ ኤስ ኡግናሲክ ሀማስ ብያት ሻቴሬ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","እሳ ሳማርያን አሱ ኤስ ኡግናሲክ ሀማስ አሱስን ዳኒ። አሱስን ቢናይሴ ባርኪ ኬናሽቴ። ");
INSERT INTO jnje_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ኤክ ባርኪ ታእሴሬ ማዛባስታ ዎይኒን ኡሽነዋ ዛይትነ ዎሽሬ ታርእ። ኤስታን ባሳ ሀኛስታ ዱስሬ እርባኒ ሀእፌና ኬር ታሜ ካት። ኤስታክ ሜታኒሲክ ሾልሱሶን ዛግ። ");
INSERT INTO jnje_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ዎኖትርክ ሄፕ ዲናሪ ክስሬ ኤስ እርባኒ ኬያስ አባንክ እማት፦ ‹ሀን አሱስን ኦዳ ሜትሱዋ። ሀን እምና ባርስታን ደናሎ ዋጋ ክሳታነ ታ ያፋና ካባሲክ ካሱና› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ኤኪን ቦእኛአሳ ኩሹስ እቼሬ ጋንደ አሱሲክ ማአ ዉዛ ዛግስ ኣፌር ስንና ኔክ ቤስቴፋሶ?» ");
INSERT INTO jnje_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ቱማስ አሩ፦ «ኤስ ባርኪ ኬናሽቴሬ አሪጋስ ባርዋ» ይሬ ዎልጊ። የሱስ ደይ፦ «ኤሴ ነ ደይ ሀምፋት ኤሲስማቶ ዛጉዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","የሱስ ባሳ ናዎስኔን ኡጉነ ሀሜሬ እሳ ኬኤስ ካርእ። ኤስ ኬኤስ ማርታ ይስቴ እሳ አሱ ባሪን ኬባ ኤጳ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ባር ደይ ማራሚ ይስቴ ኤትባ ፋር። ማራሚ ደይ የሱስ ማኬፌና ባሮን ኦደት ዎቾባስ ዲፋር። ");
INSERT INTO jnje_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ስኑንታኖ ማርታ ዎስቶባ አሪክና ቦርአ ዲራ ኦዶክ ኣነ ችማ። የሱስኒክ ያራ፦ «ዳሚሶ፥ ኤትናስ ዎስቶሶን ታ ታይስታ ሀኣት ዲፋና ካባሲክ ሻክራ ቢፋ ቶሶ? ታን አሪጋሱናክ ማኮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ስኑንታኖ የሱስ፦ «ማርታነ፥ ማርታነ፥ ሾዎ ዉዛክ ራካቴድፋ ታርዌ። ትርኦ ደይ ኔን ኤጲዌ። ");
INSERT INTO jnje_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ስኑንታኖ ሾልሱስ እሳ ዉዛ ኮእባዌ። ማራሚ ማአ ዉዛ ኮርዌ። ኤስ ባሮን ደይ ባርስታን ኤጵንር ኦኑ ኣፌ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","እሳ ዎኖ የሱስ እሳ ድምታ ሀኦ ሺጴት ፌር። ሺጶባሶን ኮእስፌና ካባሲክ ናዎባሳክቶኒስኒ እሳይስ፦ «ዳሚሶ፥ ዮሀኒስ ናዎባሳክቶኒክ ሀኦኒ ሺጶ አሲናስማቶ ነ ደይ እኖትን ሀኦኒ ሺጶ አሱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","የሱስ ደይ፦ «ሺጴፌት ካባሲክ ኤካ ኡትዋ፦ « ‹ሳማኪ ፌ አባኒሶ፤ ሱኔስ ኡልፍንቴፋዉጙዋ፤ ታቶኔስ ዮጝዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ዎንና ዎንናሲክ ሾልሱ፤ ሙኒሶን እኖክ እማ፤ ");
INSERT INTO jnje_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","እኖትን ሚርኤ ባሶትን፤ ፌሹን ይፌኒሲማቶ፤ ማጝሱኒሶን እኖክ ፌሹን ኡዋ፤ ፋታናስ እኖትን ጌዳታታ› ማንጉስኒ ፉኦታኖ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ቱስሬ ደይ የሱስ ናዎባሳክቶኒክ፦ «እሳ ቤሶ፥ ንቶስኒ እሳር ዞሞባ ፌናር፥ ዋሲ ዳኒ ጋነያክ ዞሞባሲክ ሀሜ፦ ‹ዞሞታሶ ኬዝ ሙማ ቱሻ ታክ ልቀሳይዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","እሳ ዞሞታ ኡግናን ታክ የዋ። ባርኪ እማና ሙ ትሽዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ኤስ ዞሞባስ ኬር ኩኒጌዶ፦ ‹ታን ሆፕሱታታዋ። ጋማላስ ኩሉፍቴዋ። ናንጎትናስ ደይ ታኔን ኩንርዋ። ካብራ እማናክ ኣነ ችሙት ኡንኖሶ?› ");
INSERT INTO jnje_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ንቶክ ማኬፋውጙዋ፤ ዞሞባ ስንና ቦርአ ካብሬ እማ ቤይፌናክ ሽምሱባስ ቦርአ ካብሬ ሾሌና ባሮን ዙትሬ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«ኤስ ባሪ ቦርኣ ታ ደይ ንቶክ ማኮናስ ሀኒስዋ፦ ሺጶት፥ ንቶክ እምቶና። ሾሎት፥ ዳናት። ጋማላሶን ክት፥ ንቶክ ጋቾና። ");
INSERT INTO jnje_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ሺጴፌ ባር ዙቴሬ ኤጴቶና። ሾሌፌ ባር ደይ ዳናና። ጋማላሶን ክፌ ባርኪ ጋቾና። ");
INSERT INTO jnje_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ንቶ ጋነያስን አባ ስኒፋት ናዉባስ ቱሻ ሺጴን ሹአ እምንር ኦንሶ? ኩርጡምሚ ሺጴን ዛዋ እምንር ፎንሮሶ? ");
INSERT INTO jnje_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ወደይ አኮኒ ኬዋ ሺጴን ጋምዛቶ እምንሮሶ? ");
INSERT INTO jnje_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ንቶ ማጙ አሱ ስኒፋት ናንጎትኒትሲክ ማአ ዉዛ እማ አሪፋትነ ሳማኪ ፌ አባንቲስ ኤኪን ሺጴፌ ባሶክ ኮርቶ አያናሶን ኣካክ አሪክስሬ እማ ቤይንሪንሶ?!» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","እሳ ዎና የሱስ ንባ ታርአ ኪና አያና እሳ ንባ ታቶ አሱኒስኒ ክስት ፌር። ኪና አያና ኬስናኔን ኦርፎ አሱስ ዎሎ ኤጲ። ዳራስ ደይ ኤስ ስና ቾዋሲክ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ስኑንታኖ ዳራሳስን እሳ እሳይስ፦ «ኪና አያናሶን ክስፌናስ ባር ጋኛ ስና ቤልዘቡልንክዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ኦሚስ ደይ የሱስኒን ፋታኖክ ደን ሳማን እሳ ማላቶ ቤሱናክ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ስኑንታኖ የሱስ ንብቤሲስ ሳፋራኖን አሪፋት፦ «እሳ ታቶ ባግቴራ ባሬ ባሬ ኦር ኦር ኬስፋናነ ኤስ ታቶስ ትሽርዋ። ኤሲስማቶ ደይ እሳ ኬርክ አሱ ኦር ኦር ኬስፋናነ ጋንደር። ");
INSERT INTO jnje_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ንቶ ታን፦ ‹ባር ኪና አያናሶን ክስፌናስ ባር ጋኛ ስና ቤልዘቡልንክዋ› ይትዋ። ሴጣና ባሬ ባሬ ኦር ኦር ኬሳር ስንፋናነ ታቶባስ ኣካክ የሮኒሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ኤሴ ታ ኪና አያናሶን ክስፋናስ ቤልዘቡልንክ ስንፋናነ ንቶ ናንጎታሲክቶ ኦኒ ሱናክ ክሶጝጋሶ? ኤስ ባሪ ቦርኣ ንቶ ናንጎታስ ንቶስታ ማጝሱ ካርንርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ስኑንታኖ ታ ኪና አያናሶን ክስፋናስ ሀኦኒ ሁግናክ ስንፋናነ ሀኦሲ ታቶ ንቶክ ዮባሶን አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","እሳ ዛግ አሱ ፋ ኔቦን ሜባሶን ዙትሬ ታርኤሬ ኬባሶን ኦድፋናነ ፋ ዋግባስ ማእስራቱ ኦድቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ስኑንታኖ ባሳስታን ደናሎ ችም አሱ ዬሬ ሜሬፋናነ ኤስ ቴቴና ኔቦኒ ሜባሶን ኮስሬ ፋ ዋግባሶን ቦጀሬ ታምሜ ሃአርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ታኔን አነ ስኖይ ባር ታን ኦምቴርዋ። ታኔን አነ ዙቱኖይ ባር ስኬርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«ኪና አያናስ አሱሳስኒ ኬስፋና ካባሲክ ቤይሳ ኤጳና ድማ ሾሌት አካ ፎንቶ ኢችማ ዳስ ሲ ብራቴፋ። ቱርክፋና ካባሲክ፦ ‹ዜሞቲ ኬስና ኬናስ ዎሉናዋ› ይፋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ዎላ ያፋና ካባሲክ ኬያስ ፉእቴራ ሆሬራ ፌን ዳንፋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ኤሴን ኦርፎ ሀማ ኦማ ባርስታን አካማኖን ማንጉሶን ናፉን ዛግራ ኤጳ ያራ ግርራ ዲፋ። ኤስ አሱሲክ ዜምማትስታን ኦርፎቲ ባርቱ አካማኖን ማጙ ስኒፋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","የሱስ ኤስ ባሮን ማኬፌን ዳራሳ ጋነስን እሳ ማሽካሱ ካምባሶን ቴግራ፦ «ኔን ናኔርቴ ማጋሴዋ ታምታ ታማሴ ሱስቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ስኑንታኖ የሱስ ዎልግሬ፦ «ሱስቶስ ሀኦሲ ካማኖን ኦዴሬ ዎስቶታ ፌሽፌ ባሶዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ሾዎ አሱኒ ሜያ ዬሴሬ የሱስኒክ ዙቴሴቴን ኤካ ይ፦ «ሀን ኮኒቶስ ማጙ ኮኒቶዋ። ማላቶ ብያክቱ ሾሌፋ። ስኑንታኖ ራጁ ዮናስን ማላቶስታን ኦማ ማላቶ ኣፋ እምቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ራጁ ዮናስ ነነዌክ አሱኒ ሜያክ ማላቶ ስንናስማቶ አሱኒ ና ደይ ሀን ኮኒቶሲክ ማላቶ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ካዉዳክ ታቶኖ ሶሎሞን ቴችማሶን ኦዶክ ዳስ ድልስን ካብራ ያ። ኤስ ባሪ ቦርኣ ማጝሱኒ ካርን ዎኖ ሀን ኮኒቶስኔን ካብራ ባሶስታ ማጝሱ ካርአና። ስኑንታኖ ሶሎሞኒስታን ደናሎ ሀንታ ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ነነዌክ አሱኒ ሜያ ማጝሱ ካርን ዎኖ ሀን ኮኒቶስኔን ካብሬ ባሶስታ ማጝሱ ካርኦነር። ባሶ ዮናስ ማኬና ሀኦሲ ካማኖን ኦደሴሬ ቦርቤሲስኒ ሀርምሴቴ። ኤሴ ደይ ዮናስንስታን ደናሎ ሀንታ ፌርዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ቶና ቶኒሬ ኣቾ ድምስ ወደይ ጉፕኮስ ዱስፌ አሱ ኣፌ። ስኑንታኖ ኬር ግሪፌ አሱሲክ ቻርሱናክ ቴጋ ድምታቱ ዱስፌ። ");
INSERT INTO jnje_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","አቱኔስ ቶና ኣፍኔስዋ። ኣፍኔስ ፋያ ስንፋናነ አቱነ ዙቴራ ቻሬፋቱ ስናና። ስኑንታኖ ኣፍኔስ ሜታና ስንፋናነ አቱነ ዙቴራ ታልማቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ኤስ ባሪ ቦርኣ ነይስ ፋ ቻሬፋስ ታልሞኖይናማቶ አሩዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ኤሴ አቱነ ዙቴራ ቻሬፋክ ቱማ ታልማ ፎንቶ ስንፋናነ አቱኔስ ዙቴራ ማእስራ ሳምፋ ቶኒማቶቱ ቻሮናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ኤስ ባሮን ማኬፌን እሳ ፌሪሳዊ ሙ ሙናክ የሱስኒን ባርኪ ኬር ቴጌ። ፌርሳዊሳ ኬር ግሪሬ አነ ሙ ሙናክ ድ። ");
INSERT INTO jnje_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","የሱስ ሙ ሙኖይ ዜምሜ ኩሹባሶን ማሶ ቤይና ቦርአ ፌርሳዊስ ዲንቀ። ");
INSERT INTO jnje_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ኤስታን ዳሚስ ባርኪ ኤካ ይ፦ «ንቶ ፌርሳዊስ፥ ቶፎሴዋ ኮራናሴ አሲ ቱካኖንቱ ካይምስራ ማሴፌት። ስኑንታኖ ስካሎንትስ ቦአክናዋ ማጙክና ቱማዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ንቶ ጎዋ፥ ቱካባሶን ቴስ ሀኦሲ ስካሎባሶን ኣነ ቴሱዋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ኤሴ ቶፎንትስ ፋ ባሮናዋ ኮራናንትስ ፋ ባሮና ቱካሚሲክ እምትዋ። ኤስ ካባሲክ ዙታምባሴ ንቶክ ካይማ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«ንቶ ፌርሳዊስ ሀይቡንትዋ! አዝማቻስንናዋ ችራታስንና ኤሲስማቶ ደይ ፉሶ ፉሶ ሳኡሳስኒ አሲሪስን እሳሮን ሀኦኪ እምትር። ስኑንታኖ ፉቶኒ ዎስቶሶናዋ ሀኦሲ ኬሽታናኖና ቤይትዋ። ኤስ ባሮን ዛጋት ሀን ባሮን ቤይት ባር ማአሪታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«ንቶ ፌርሳዊስ ሀይቡንትዋ! አይሁድኒ ሺጶኒ ኬያሲክ ኡልፍንኒ ኮድታ ዱክቱ ሾሌፌት። ጋባስታ ደይ አሱ ንቶትን አሪክሱን ናጋ ኦሾናክ ሾሌፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","አሱኒ ሜያ አሩኖይ ቱካባስታ ኩትሴፌ ሞጋነ ፌር ስኒት ቦርአ ሀይቡንትዋ!» ");
INSERT INTO jnje_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ቱማስ አሩኒስን እሳይስ፦ «አስሲኛኖ፥ ኤካ ኡኔስ እኖትንኑ ሜእትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","የሱስ ዎልግሬ፦ «ቱማሶን አሪፌ ንቶ ደይ ሀይቡንትዋ! አሱ ዎርአክ ችምኖይና ፋያ ባአ አሱኒስታ ዎስትር። ስኑንታኖ ንቶ ቴትንትሲክ ኩሹንትስ ዋአክኑ ኣነ ታእፌት። ");
INSERT INTO jnje_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ኤሲስማቶ ደይ ንቶ አባሳክቶ ዎርሴቴ ራጁኒ ሜኒ ሞጋሶን ጋዳስፌት ቦርአ ሀይቡንትዋ! ");
INSERT INTO jnje_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ኤሴ ንቶ አባሳክቶ ዎርሴቴ ራጁኒ ሜኒ ሞጋሶን ጋዳስፌት ቦርአ ንቶ ደይ ባሶ ዎስቴሴቴ ዎስቶሲክ እሳር ስኒትሶንቱ ቤስፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ኤስ ባሪ ቦርኣ ሀኦሲ ቴችማ ኤካ ይዋ፦ ‹ራጁኒ ሜያኖናዋ ዎስኒ ሜያኖና ዎሱናዋ። ባሶ እሳ እሳይስን ዎርሶነ። ኦሚስን ደይ ካሌ ኮፉክሶነ። ");
INSERT INTO jnje_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ዳ ቴስቴናኔን ካብራ ዉክቴ ራጁኒ ሜኒ ሀንናሲክ ሀን ኮኒቶስ ማሙስቶኒርዋ› ");
INSERT INTO jnje_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ፉቶ ንቶክ ማኬፋውጙዋ፥ አቤልን ሀንናስታኔን ካብራ ሾኣስታናዋ ቤቴሜቅደሲሲ ጋነስና ዉክቴ ዛካሪያስኒ ሀንናስታ ካርአናኔን ሀን ኮኒቶስ ማሙስቶኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«ቱማስ አሪፌ ንቶ ሀይቡንትዋ! አሩኒ ጋማላስ ጋቾኖን ኤጵት፥ ስኑንታኖ ንቶ ቴታሲክ ኣነ ግሩዌት። ግሩን ባሶትን ደይ ካለትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","ኤስታን የሱስኒን ኖኖባስን ኬስፋ ካማሲክ ባሪን ፋታኖክ ሙሴኒ ቱማሲ አስሲኛናዋ ፌርሳዊኒ ሜና ኦምቶክናዋ ሾዎ ማምሱን ማምሱክና ካብሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ኤስ ካባሲክ ሾዎ ኩም ዳራ ዙቴሴቴ። ሾዎቤሲስታን ካቢ ቾዋ ባሶትና ባሶትና ቱግሴት ፌሴቴር። የሱስ ዜምሜ ናዎባሳክቶኒክ ኤካ ይ፦ «ፌርሳዊኒ ሜኒ ማሶስኒ ኤሲስ ደይ ስኖይ ስንነ ቤስቶስኒ ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ጌፕቶ ዉዛስ አምማኖን ኬሳ ኣፋ ቤያና ዉዛ። ኣቾ ዉዛስ ደይ አርቶ ኣፋ ቤያና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ኤስ ባሪ ቦርኣ ታልማስ ዎል ሌት ባር ዙቴራ ቻሬፋስታ ኦድቶና። ኣቾ ድምስ ሳክሴራ ዎል ሌት ባር ደይ ቴጋ ድምታ አማኖ ማክቶና። ");
INSERT INTO jnje_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«ዞሞታ ስና ንቶክ ኤካ ይፋዉጙዋ፥ አሽንትሶን ዎራት ኤሴን ኦርፎ ኦማ ዉዛ ዛጉክ ችሞኖይ ባሶትን ድጎትታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ስኑንታኖ ኦኒን ድጎትክ ሾልስፋናማቶ ንቶክ ማኮናዋ። ዎርናኔን ኦርፎ ጌኒ ትርእማሲ ሀኡክ ሁግናባ ፋና ሀኦሶን ድጎትዋ፤ ኣ ባር ባሮን ድጎትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«ኡች ሜጅማር ሄፕ ዱደስ ዋግቴርታኖሶ? ባርስኒ እሳይስኑ ሀኦሲ ስና ኣነ ዳግቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ንቶ ሶማስ ፋሻኑ ፋድቶዋ። ኤስ ባሪ ቦርኣ ድጎትታዋ፥ ንቶ ሾዎ ሜጅማርስታን ደናሎዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ንቶክ ይፋዉጙዋ፤ አሱኒ ስና ባር ታር ስኒባሶን ዛላ ማኬ ባርኪ አሱኒ ና ደይ ሀኦሲ ዎስያኒ ስናክ ባርኪ ዛል ስንነ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","አሱኒ ስና ታን ሞርሜፌ ባሪን ሀኦሲ ዎስኒ ስናክ ደይ ባሪን ሞርሞናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«አሱኒ ናኒታ ሜእን ካማ ማኬፌ ባር ኦኑ ቦርባስ ፌሹን ኡስቶናዋ። ስኑንታኖ ኮርቶ አያናስታ ሜእን ካማ ማኬፌ ባሳ ቦርባስ ኣፋ ፌሹን ኡስቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«አሱኒ ሜያ ንቶትን አይሁድኒ ሺጶኒ ኬያሲክቶስ ወደይ ጋኘ ሜያክናዋ ዳ ሀእሲፌ ባሶክና ኤጴ ታሜፌ ካባሲክ፦ ‹አዉ ዎሎንታሶ ወደይ ኣካክ ዎልጉንታሶ› ይት ራካቶትታ። ");
INSERT INTO jnje_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ኤስ ካባሲክ ኮርቶ አያናስ ማኮት ባሮን ንቶክ አሱናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ዳራሳ ጋነስን እሳ አሱ የሱስኒን፦ «አስሲኛኖ፥ አይታስ አባኒሳ ካራኖን አይታስ ታክ ሃአናክ ማኮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ስኑንታኖ የሱስ ዎልግሬ፦ «ነ ሀን አሱ፥ ንቶስታ ጋኛ ወደይ አባንትሳ ካራኖን ሃአናክ ዛግ ኦንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ደይ ቱስሬ፦ «አሱኒ ካ ቴቴናስ ዋግን ኣታምታታዋ። ኤስ ባሪ ቦርኣ ኤናንቶስታን ቴትንትሶን ኦድትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ኤስታን ቱስሬ እሳ ቤሶ ኤካ ይት ማኬ፦ «ቡሎባ አካማ ጋና ጋና እሳ ኦቱም አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ኤስ አሱስ ደይ፦ ‹ሀን ኤፋቴና ሜናሶን ዙትራ ጋጋና ድማ ኣፋ ስንና ቦርአ አዉ ዛጉናሪንሶ?› ይት ንብባሲ ሳፋሬ። ");
INSERT INTO jnje_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ደይ ኤካ ይ፦ ‹ፋ ቦቶናሲክቶኖ ዙትራ ቦጋ ሀኣት ኦማ ታጋ ታጋ ቦቶ ማርአ ሜናሶናዋ ፋ ዉዝናሶና ዙትራ ጋጋናዋ› ");
INSERT INTO jnje_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ኤሴን ኦርፎ ታ ታ ቴታሲክ ዎልግሬ፦ ‹ሾዎ ነያ ካርአ ሆሮኒ ኦቱምና ዙትን። ኤሴ ካናሴ ዲራ፥ ሙ፥ ኡሽ፥ ግሮ ኡና› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ስኑንታኖ ሀኦሲ ባሪን፦ ‹ነ ጎዋ፥ ሀውጙት ዋላሲክ ካኔስ ኦቶኒርዋ። ኤሴ ነ ሀን ዙትታ ባር ኦንክ ስኒሪንሶ?› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«ኤሲስማቶ ሀን ዳስታኪ ቴትባሲክ ኦትማ ዙትፌ ባር ሀኦሲ ስና ቱካም ስና አሱስ ኤሲስንነ ፌርዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ኤስታን የሱስ ናዎባሳክቶኒክ፦ «ንቶክ ይፋዉጙዋ፥ ካኒትሲክ ሙት ባሮን ወደይ አቱንትስታ ማያት ባርኪ ትርኦ ኤጳናታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ኤሲስ ደይ ካ ሙስታን፥ አቱ ማያስታን ደናሎዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ካሳሲክቶኖ ቢትዋ፤ ኣነ ቡክፋ፤ ኣነ ካርፋ፤ ሜባሶን ዙትፋና ቦቶባ ኣፋ፤ ስኑንታኖ ሀኦቱ ማስፋር። ንቶ ካሳስታን አካማኖን ደናሎዋ! ");
INSERT INTO jnje_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ንቶስኒ ራካቴሬ ኔባስታ እሳ ዎና ዳይሱክ ችምንር ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ኤስ ካሾ ቾዋሶን ዛጉክ ችምኖይትር ስንናኔን ኦማሲክ አዉኒሮን ትርኦ ንቶትን ኤጵፋሶ? ");
INSERT INTO jnje_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ፉርኣስ ኣካክ ካይራ ድችፋናማቶ ቢትዋ፤ ኣነ ሆፕፋ፤ ኣነ ሱክፋ፤ ስኑንታኖ ሶሎሞንኑ ፋ ኡልፍንቶባሲክ ፉርኣስኒ እሳይስንነ ፋሮኑ ኣነ ማየዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ሀኦሲ ሀውጙ ቢስቴፋት ዎኖ ጌያስ ሀቶኒ ኩዋሶን ኤካ ማይስናኔን አማንቶኒት ዮእና ንቶትን ኣካነ ፋሮን አሪክስራ ማይሱኒ! ");
INSERT INTO jnje_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«ኤስ ባሪ ቦርኣ ንቶ፦ ‹አዉ ሙንሪንሶ? ወደይ አዉ ኡሻኒሪንሶ?› ይት ራካቶትታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ኤስ ባሮን ሀን ዳስታኪ ፌ አሱኒ ሜያ ዙቴሬ ሾሌሴቴር። ስኑንታኖ ሳማኪ ፌ አባንቲስ ኤስ ባር ዙታምባሴ ንቶክ ሾልስፋናማቶ አሪር። ");
INSERT INTO jnje_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ኤስ ባሮን ዛጉስታን ዜምማ ሀኦሲ ታቶኖ ሾሎት። ሾልሱስ ዙቴራ ንቶክ እምቶና። ");
INSERT INTO jnje_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«አባንቲስ ታቶባሶን ንቶክ እማናክ ማአ ሳፋራባ ስንና ቦርአ ንቶ ጋሮ ዎዶ ድጎትታ። ");
INSERT INTO jnje_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ንቶክ ፋዪሶን ክስራ ዋጌራ ቱካሚሲክ እምት። ዊስ ታእሶኖይና ድምታ፥ ኮኝማር ሙኖይና ድምታ፥ ኩርኡኖይ ሀማቶስ፥ ኮኡኖይ ኦትማ ደን ሳማ ኬር ዙቱት። ");
INSERT INTO jnje_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ዋግንትስ ፋናስታ ንብንትስ ደይ ኤስታ ፎና።» ");
INSERT INTO jnje_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ካዉናኖን ቴቤራ ዎስቶክ ሆሮት። ቶኒትስ ደይ ቻሮን። ");
INSERT INTO jnje_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ዳምቤሲስ ሳርግን ኬሩን ዎሉናኔን ኦድፌ ዎስትኛነ ፌር ስኒት። ባሶ ደይ ዳምቤሲስ ዬሬ ጋማላሶን ክፌና ካባሲክ ጌሬጌሬ ጋቻክ ሆሬ ፌ አሱኒ ሜያነ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ዳምቤሲስ ዬፌና ካባሲክ ጉዝሬ ኦደ ፌ ዎስትኛኒ ሜያ ሱስቶዋ። ፉቶክ ማኬፋውጙዋ፥ ዳምቤሲስ ካዉናኖን ቴቤሬ ባሶትን ማዲስ ብራቶታ ዱሱና ደይ እርባሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ዳምቤሲስ ዋሲ ወደይ ዋስኔን ኦርፎ ዬሬ ካርፌና ካባሲክ ጉዝሬ ኦደ ፌሴቴን ዳንፌና ዎስትኛኒ ሜያ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ሀን ባሮን ደይ አሩትዋ፥ ዊስ ኣጌ ዮናማቶ ኬን አባስ አሪ ስንፋናነ ኬባሶን ዪሸ ግሪፌና ካባሲክ ሻክሬ ብያና ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","አሱኒ ና ደይ ሳፋሮኖይት ዎናክቱ ዮና ስንና ቦርአ ንቶ ደይ ሆሬራ ኦድትዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ጴጥሮስ ደይ፦ «ዳሚሶ፥ ሀን ማኬፋታ ቤሶስ እንኖ እኖክጙዋ ወደይ ኦምሲክኔንንሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ዳሚስ ዎልግሬ፦ «ኤሴ ኬርክ አሱ ዙታምቤሲሴ አሲክ ሙቤሲሶን ሾልስፋና ካባስታክ እማናክናዋ ሀእሱናክና ዳሚስ ታስና ንብባሬ የሬ አማናምቶ ዎስትኛ ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ዳምባስ ዎል ሌ ዬሬ ኤስ ማክቴናስማቶ ዛግፌን ዳና ዎስትኛስ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ፉቶ ንቶክ ማኬፋውጙዋ፥ ዳምባስ ፋ ዉዝባ ዙታምባሴ አሲስታቱ ታሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ስኑንታኖ ኤስ ዎስትኛስ፦ ‹ዳምታስ ታእን ኣፋ ዮናዉዛ፥ ዎኪንር› ይት ኡሸት፥ ዛየት ኣርቃ ዎስትኛስንናዋ ማሽካ ዎስትኛአሶንና እቻ ኤጵፌ። ");
INSERT INTO jnje_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ኤስ ዎስትኛአሳ ዳም ባር ሳፋሮኖይና ዎኒታናዋ ኦድኖይና ሳአትታና ዮና። ካጨ ካጨሬ እጣባሶን ደይ አማኖኖይ ባሶኔን ዛጉና። ");
INSERT INTO jnje_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«ዳምባሳ ሳፋራኖን አሪፌጌዶ ሆሮኖይ ወደይ ዳምባስ ሾሌፌና ዉዛሶን ዛጉኖይ ዎስትኛስ ማጙ ኬኦቱ ኤጴቶና። ");
INSERT INTO jnje_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ስኑንታኖ ዳምባሳ ሳፋራኖን አሩኖይ ኬኦታ ካቱኒ ማጝሱ ዛግ ባር ጋሮ ኬኦቱ ኤጴቶና። ሾዎ ዉዛ እምቴና ባርኪን ሾዎ ዉዛቱ ሾልቴፋር። አካማ አዳራ እምቴና ባርኪን አካማቱ ኦድቴፋር።» ");
INSERT INTO jnje_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ታ ሀን ዳስታክ ጌያቱ ኤጳ ያንዋ። ሀሽ ሳም ስንፋናነ ኣካ ግሮና ካባንሶ! ");
INSERT INTO jnje_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ስኑንታኖ ታ ሀጱክቶና ሻናን ሀጱክቶ ፋርዋ። ሀማ ኮኡና ካባኔን ቤይሳና ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ታ ሀን ዳስታክ ናጋ ኤጳ ያናርነ ፋር ስንና ንቶክ ቤስቴፋዎሶ? እንዳነዋ፥ ታ ኤጳ ያናይ ኦር ኦር ክሱታኖ ናጋታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ሀሽ ሀውጙ ካብራ እሳ ኬያስ ፌሴ ኡች አሱኒ ሜያ ኦር ኦር ኬሶነርዋ። ኬዚስ ሄፒሳታ፥ ሄፒስ ኬዚሳታ ካብሬ ዎል ፋሶሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","አባስ ናሳታ፥ ናስ አባሳታ፥ እንቶስ ናዋስታ፥ ናዋስ እንቶስታ፥ እንቶስ ናሳ አሱታ፥ ናሳ አሱ ናሳ እንቶታ ካብሴሬ ዎል ፋሴሬ ኦር ኦር ኬሶነዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ደይ የሱስ ዳራሲክ ኤካ ይ፦ «ሻሩ አዉግሩን ኬስኒ ቢፌት ካባሲክ ጌሬጌሬ፦ ‹ሀሽ ሀውጙ እሮ እችንርዋ› ይፌት። ኤስ ባር ደይ ስኒፋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ስሩ ካዉዳን ካብራ ስርፋና ካባሲክ፦ ‹ሀሽ ሀውጙ ኖእሱኒርዋ› ይፌት። ኤስ ባር ደይ ስኒፋ። ");
INSERT INTO jnje_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ስኖይ ስንነ ቤስቴፌ ንቶ ዳሴዋ ሳማሴ አሲ ግቶኖን ብያክ ስኒ ባሮን አሪትርዋ። ኤካኒ ሀን ፋ ነያስታ ስኒ ባሮን ቢሬ አሩ ኣካክ ሆፕትሶ? ");
INSERT INTO jnje_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ንቶ ቴትንትሲክ ቢራ ፉቶኒ ማጝሱኒ ካርአ አዋጋን ካርአ ቤይትሶ? ");
INSERT INTO jnje_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ጉማነ ኤስ ኔን ማላቴን ጋኛን ስና ታአታክ ሀሚፋታ ካባሲክ ዜምማ ኡጉንታክ ፋጌዶ ጋኖክ ዱዶዋ። ኤኩ ሻካታነ ኔን ዛቴ ጋኝኛስክ ታማርዋ። ጋኝኛስ ደይ ኣትሬ ሜያ ታርኦሲክ እማና። ሜያ ታርኦስ ደይ ታቶኒ ኬር ጌዳና። ");
INSERT INTO jnje_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ኔክ ማኬፋውጙዋ፥ ኮእን ዱዴሶን ካሱኖይ ኤስ ታቶኒ ኬያስኒ ኣፋዋ ኬሳታዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ኤስ ካባሲክ አሱኒ ሜያ የሱስኒክ ዬሴሬ፦ «ጋሊላክ አሱኒ ሜያ ማአ እሜፌን ፕላቶስ ዎሪ፤ ሀርንቤሲሶን ደይ ማኣስኔን አነ ዎእስ» ይት ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","የሱስ ደይ ዎልግሬ፦ «ኤኪን ኤስ ጋሊላክ አሱኒ ሜያ ኦም ጋሊላክ አሱሳታን ደናሎ ቦርቤስ ፋናር ስንነ ንቶክ ቤስቴፌዎሶ? ");
INSERT INTO jnje_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","እንዳነዋ፥ ንቶ ደይ ቦርንትሶን ሀርሙ ሻካትነ ኤሲስማቶቱ ትሹትዋ ይፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ሴለሆምክ ሹን ኬያስ ሻክራ እቻ ዎርና አሲሬ ናግነ አሱኒ ሜኒ ቾዋሶን አዉ ሳፋሬፌትሶ? ባሶ የሩሳሌምክ ፌ አሱኒ ሜያ ዙታምቤሲሴ አሲሳታን ደናሎ ቦርነ ፌር ስንነ ንቶክ ቤስቴፌዎሶ? ");
INSERT INTO jnje_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","እንዳነዋ፤ ንቶ ደይ ቦርንትሶን ሀርሙ ሻካትነ ዙታምንትሴ ኤሲስማቶቱ ትሹትዋ ይፋዉጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","የሱስ ኤካ ይት ሀን ቤሶሶን ማኬ፦ «እሳ አሱ ዋይኒን ፎሽባስታ እሳ ቤለስ ይስቴ እኦባ ፋር። ኤስ ቤለሲስኒ ጋና ኬጳናክ ሀሜ እሳንነ ኣነ ዳንነ። ");
INSERT INTO jnje_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ዋይኒን ፎሻስ ዎስትኛኒክ፦ ‹ኤሴኑ ጋና ኬጳናክ ኬዝ ዎግጋ ሀን ቤለሲሲክ ያራ እሳንነ ኣነ ዳኑትዋ። ኤስ ባሪ ቦርኣ ካርአ ሀኡዋ፥ አዉኒሮን ባክ ዳሶን ማግስድፋሪንሶ?› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ዎስትኛስ ዎልግሬ፦ ‹ዳሚሶ፥ ብራቶባሶን ይሻ ፉቱ ሀእራ ብያናክ ሀንነንትሶን ቤይዋ። ");
INSERT INTO jnje_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ዎነ ጋንፋናነ ማአሪዋ፥ ጋና ሻካናነ ካርአ ሀኡታዋ› » ይ። ");
INSERT INTO jnje_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","የሱስ እሳ ቤይሳኒ ዎናክ አይሁድኒ ሺጶኒ ኬያስ አሲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ኤስታክ አሲሬ ናግነ ዎግጋ ኪና አያና ጌሾባሶን ኩፕስና እሳ ማሽካሱ ፋር። ባር ደይ ካነ ኩቱክ ኣነ ችምፋ። ");
INSERT INTO jnje_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","የሱስ ባሮን ቢሬ ባርኪ ቴጌፋት፦ «ነ ሀን አሱሴ ሜሮኔስኒ ፋርትዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ኩሹባሲክ ታእን ጌሬጌሬ ካና የሬ። ሀኦሶን ደይ ጋላቴ። ");
INSERT INTO jnje_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ስኑንታኖ አይሁድኒ ሺጶኒ ኬያስ ጋኛ የሱስ ቤይሳኒ ዎናሲክ ፋቱባሲክ ግእቴሬ ዳራሲክ፦ «እሱን ዎስቶኒ ዎና ፋርዋ። ኤስ ዎስቶኒ ዎናሲክቶስ ያራ ፋሩትታኖ ቤይሳኒ ዎናሲክታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ዳሚስ ዎልግሬ፦ «ስኖይ ስንነ ቤስቴፌ ንቶ፥ ንቶ ጋነያስን ቤይሳኒ ዎናሲክ ጋቹባሶን ወደይ ሀኛባሶን ቱፕቴናስታን ኮቴ አካኒ ኡሺስ ኤጴ ሀሚኖር ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ሀን ማሽካሱስ አብራሀምኒ ዛላ ስንና ፋጌዶ አሲሬ ናግነ ዎግጋ ኪና አያናክ ታቴራ ፋር። ኤኪን ቤይሳኒ ዎናሲክ ሀን አሱሶን ታቶስን ኮቶናክ ኣነ ሾልስፋኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ኤካ ማኮባሲክ ባሪን ኦምቴፌ ባሶትን ዙቴሬ ኢችሽ። ስኑንታኖ ዳራስ ባር ዎስቴና ዲንቂ ዎስቶሲክ ዙቴሬ ግሬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ኤስታን የሱስ ኤካ ይ፦ «ሀኦሲ ታቶ አዉነ ፋሪንሶ? አዉኔን ሆስራ ንቶክ ማኮናሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","እሳ አሱ ኤጴ ታሜ ቡሎስ ቡክና ፍፍኦኒ ጋናነ ፋርዋ። ባር ደይ ካይራ ድቻ እኦ ስኒ። ካሳስ ደይ ዋባስ ኬባ ኬርአ ድ።» ");
INSERT INTO jnje_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ሄፕሳ ደይ የሱስ ኤካ ይ፦ «ሀኦሲ ታቶኖን አዉኔን ሆሱናሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","እሳ ማሽካሱ ቱሾ ኬሳናክ ዎእስና ማሶነ ፋርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ኤሴን ኦርፎ የሱስ የሩሳሌም ሀሚፌና ካባሲክ ካታማ ካታማስናዋ ኬኤ ኬኤስና ፌ አሱስን አሲት አቴት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","እሳ አሱ ዬሬ፦ «ዳሚሶ፥ ፋሩኒስ ጋሮ አሱ ኮእባኖሶ?» ይ። የሱስ ደይ ኤካ ይሬ ዎልጊ፦ ");
INSERT INTO jnje_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«ቱጎ ፍኚስ ግሩክ ካቦትዋ። ንቶክ ማኬፋውጙዋ፥ ሾዎቤሲስ ግሩክ ሾልሴቴር፥ ስኑንታኖ ግሩክ ኣፋ ችሞሶነ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ኬያስ አባ ካብሬ ጋማላሶን ኩልፍናኔን ኦርፎ ንቶ ጌሮ የሬፋት፦ ‹ዳሚሶ ጋቻይዋ› እያፋ ጋማላሶን ክአት። ባር ደይ፦ ‹ንቶ ኦ ስኒትማቶናዋ አይን ያሴትማቶና ኣነ አሪፋትዋ› ይሬ ዎልጉና። ");
INSERT INTO jnje_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ንቶ ደይ፦ ‹ነኔን አነ ማራ ኡሽኒዋ፥ ዙቶኒ ድማስታክ ደይ እኖትን አስሲትዋ› ኡት። ");
INSERT INTO jnje_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ባር ደይ ሄፕሳ ዎልግሬ፦ ‹ንቶ ኦ ስኒትማቶናዋ አይን ያሴትማቶና ኣነ አሪፋትዋ። ማጙ ዉዛ ዛግፌ ንቶ ታይስታን ዎክትዋ› ኡና። ");
INSERT INTO jnje_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«አብራሀምኒን፥ ይሳቅንን ያቆብንናዋ ራጁኒ ሜያኖና ዙትራ ሀኦሲ ታቶስ ፌሴቴን ብያትዋ። ስኑንታኖ ንቶ ኤክ ጌሮ ሀቴራ ዋስነዋ ሀን ኮይነ ንቶክ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","አሱኒ ሜያ አዋ ኬስናርክናዋ አዋ ግርናርክና፥ ዬሽዳናዋ ካዉዳና ዬሴሬ ሀኦሲ ታቶኒ ኮታኖን ሙሶነክ ታእሶሶነ። ");
INSERT INTO jnje_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ኤሴ ደይ ዜምማ ባሶ ኦርፎ ዎልሴር ስኖነ፤ ኦርፎ ዎልሴ ባሶ ደይ ዜምማር ስኖነ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ኤስ ካባሲክ ፌርሳዊኒ ሜያስን እሳ እሳር ዬሴሬ፦ «ሄሮድስ ኔን ዎሩናክ ሾሌድፌርዋ ካብራ ሀንታን ሀማ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ባር ዎልግሬ፦ «ሀምፋት ኤስ ቦዋሲክ፦ ‹ኤሴኑ ሀውጙናዋ ዎኖና ኪና አያናሶን አሱሳስኒ ክሱናር፥ ሜታን ሜያኖን ፋቱናር፥ ኬስናር ዎኖ ደይ ዎስቶናሶን ኮእሱናር› ይዋ ኡትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ራጁኡስ የሩሳሌምኒ ጌራካሎ ክቱናክ ኣነ ሾልስፋዋ። ኤስ ባሪ ቦርኣ ሀውጙኔን ዎኖኔን ዮኖኔን ኤክ የሩሳሌም ሀማናርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","የሩሳሌም የሩሳሌምነ! ራጁኒ ሜያኖን ዎሪፋ ነ! ኔክ ዎስቴሬ ዬሴ ባሶትን ሹአክ ኬር ነ! አኮ ናዉባሶን ኮሶባስ ስካሎስ ዙትራ ጌፐፋናሲማቶ ናንጎትኔሶን ዙቱክ አፑና ዎላ ሾሌን። ስኑንታኖ ነኔን ዳራኔስኔን ታን ቤየት። ");
INSERT INTO jnje_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ኤሴኑ ኬንትስ ኦና ስንናቱ ፉእቶና። ንቶክ ማኬፋውጙዋ፦ ‹ዳሚሳ ሱናክ ዬፌ ባር ሱስቶዋ› ኡትኔን ሀውጙኔን ኤካሎ ታን ኣፋ ብያት ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","እሳ ቤይሳኒ ዎናክ ፌርሳዊኒ ሜኒ ጋኛአሳስኒ እሳይሲክ የሱስ ሙ ሙናክ ግር። ፌርሳዊኒ ሜያ ባር ዛጉና ዉዛሶን ብዮነክ ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ኤስታክ ደይ እሳ አቱባ ዎልስና ሜታን አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","የሱስ ሙሴኒ ቱማሲ አሩኒ ሜያኖናዋ ፌርሳዊኒ ሜያኖና፦ «ቱማስ ቤይሳኒ ዎናሲክ ሜታኒስኒ ፋቱ ካልፋዋ ወደይ ኣነ ካልፋኒሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ስኑንታኖ ባሶ ሻክሴቴ። የሱስ አሱስን ታእሬ ፋትሬ ጋፍኪ። ");
INSERT INTO jnje_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ደይ የሱስ፦ «ንቶስኒ እሳ አሱ ናዉባ ወደይ ጋቹባ ቤይሳኒ ዎናክ ጋዉ ግሪፋናነ ኤልለ ክሱኖር ኦንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ባሶ ደይ እሳ ዉዛነ ዎልጉክ ኣነ ችሞቶ። ");
INSERT INTO jnje_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","የሱስ ኮታ ሙሶነክ ቴግቴ አሱኒ ሜያ ኡልፍንኒ ድምታ ዱክ ካብሴፌን ብያት ሀን ቤሶሶን ማኬ፦ ");
INSERT INTO jnje_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«እሳ አሱ ሳርግ ኮቴሬ ቴጌፋናነ ኡልፍንኒ ድምታ ዱታታዋ። አዉዛክነ ነይስታን ኡልፍንቶ አሱ ቴግቴሬ ፌር ስናናክ ችማና። ");
INSERT INTO jnje_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ሄፖንትሴ አሲን ቴጌ አሱስ ዬሬ፦ ‹ሀን ኮዳሶን ባርኪ እማ› እያናነ ነ ኢቼት ኬሬራ ዳካሎ ዱታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","«ስኑንታኖ ቴግቴራ ሀሚፋታ ካባሲክ ዳካሎክ ድማስታ ዱዋ። ኔን ቴጌ ባር ዬሬ፦ ‹ዞሞታሶ ካብራ ደናሎክ ኡልፍንቶ ድማስታ ዱዋ› ኡና። ነ ደይ ኤስ ካባሲክ ነኔን አነ ቴግቴ ባሶ ስና ኡልፍና ዳናታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ኤሲስ ደይ ቴትባሶን ደን ቴጉናክ ሾሌፌ ባር ዳ ሀቶና። ቴትባሶን ዳ ሀቴስፌ ባር ደን ቴጉና።» ");
INSERT INTO jnje_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","የሱስ ኮታሶን ሆሲ አሱሲክ ደይ፦ «ሜሽሜታ ወደይ ሜታኡን ኮቴራ ሆስፋ ታ ካባሲክ ኮባሶን ዎልግሬ ካሱክ ኮቴሬ ቴጎን ዞሞኔሳ ክቶኒን፥ አይኔሳ ክቶኒን፥ ኮኔሳክቶኒን ወደይ ኦቱም ዎልኮነሳ ክቶኒን ቴጎታታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ስኑንታኖ ኮታ ሆስፋ ታ ካባሲክ ቱካሚስኒ፥ ኤግትስኒ፥ ላፋስንናዋ ኣፍትሹስንና ቴጎዋ። ");
INSERT INTO jnje_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ባሶ ደይ ኮዋ ካሱክ ኣፋ ችሞነ ዉዛ ስንና ቦርአ ነ ደይ ሱስቶዋ። ኦኮኒ ሜያ ክቱኒ ካብሴፌ ዎኖ ኮባሶን ሀኦሲ ኔክ ካሱናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","የሱስኔን ሙን ሙክ ዲሴ ባሶስኒ እሳይስ ኤስ ባሮን ኦዳት፦ «ሀኦሲ ታቶኒ ኮታኖን ሙክ ዱን ባር ኣካ ሱስቶኒሶ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","የሱስ ደይ፦ «እሳ አሱ አካማ ሜታኡን ኮታ ሆስሬ ሾዎ አሱኒን ቴጌ። ");
INSERT INTO jnje_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ኤስ ኮታስ ማስቶና ሳአትስ ካርፋና ካባሲክ ኮታሶን ሆሲ ባር፦ ‹ኤሴ ዙታምባሴ ሆሬና ቦርአ ዮትዋ› ይሬ ቴጎናክ ዎስትኛባስን ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ስኑንታኖ ዙታምቤሲሴ ኮታሲክ ዮ ቤዮነክ ቾዋ ሾልሴቴ። እሳይስ፦ ‹ዳ ዋጌና ቦርአ ሀማ ብያናክ ሾልሱዋ። ታክ ፋክያ ዛጉዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ኦሚስ ደይ፦ ‹ኡች ካማዳ ጋችዋ ዋጌን ስንና ቦርአ ካማደራ ብያናርዋ። ታክ ፋክያ ዛጉዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ኦሚስ ደይ፦ ‹አሱ ኤጳ ማር ስንና ቦርአ ዮናክ ኣፋ ችማናዉዛ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«ዎስትኛባስ ዎል ሌ ዬሬ ኤስ ባሮን ዳምባሲክ ማኬ። ኤስ ካባሲክ ኬያስ ዳም ግእቴሬ ዎስትኛባስን፦ ‹ታእኒን ኤክ ካታማስ አሪ ኡጉንታናዋ ጋሮ ጋሮ ሻቶስታና ኬስፋት ቱካሚስኒ፥ ላፋስን፥ ኣፍትሹስን ኤግትፌ ባሶትን ሀጝ ቴጌራ ዮዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ዎስትኛስ ዎል ሌ ዬሬ፦ ‹ዳሚሶ፥ ማኬታ ባሮን ዙትራ ዛግንዋ። ስኑንታኖ ሀሽኑ ዱስቶኒ ድማ ፋርዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ኤስ ባሪ ቦርኣ ዳምባስ ዎስትኛስን፦ ‹ኬናስ ቱማናኔን ኤክ ካታማስ ጌራካሎ ፋ አሪ ኡግናስታናዋ ሻቶስታና ኬስፋት ዳንታ አሱስ ዙቴሬ ዬሬ ግርሶነክ ዛጉዋ። ");
INSERT INTO jnje_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ንቶክ ማኬፋውጙዋ፥ ሀን ቴግቴሬ ቤያ አሱኒ ሜያስን እሳ አሱኑ ታ ኮታሶን ኣፋዋ ሙሶነ ዉዛ› » ይ። ");
INSERT INTO jnje_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ሾዎ ዳራ የሱስኒ ኦርፎሴ ሀሜፌን የርቀሬ ባሶክ፦ ");
INSERT INTO jnje_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«ታክ ዮናክ ሾሌ ባር ዙቴሬ አባባስኒ፥ እንቶባሶን፥ አሱባሶን፥ ናንጎትባሶን፥ አይባሳክቶኒን፥ ኤትባሲክቶኖን፥ ካባሶን ጌደ ኦምቶ ሻካናነ ታ ናዎ ስናናክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ባሳ ሜስቀሊሶን ዎርኤ ታ ኦርፎሴ ዮኖይ ባር ናዎታ ስናናክ ኣፋ ችማ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«ንቶስኒ እሳር ሹን ኬያ ኬርአናክ ሾሌፋናነ ኤስ ኬያሶን ኬርኤ ክሱናክ ሆሮኒ ዋጋ ፎባሶን ዜምሜ ዲሬ አዉነ ፋ ዋጋ ኮእሱናማቶ ሳፋሮኖይ አሱ ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ኤስ ባሮ ዛጉ ሻካት ካፕታሶን ዪሸ ኬርኤ ኮእሱ ሆፕፋናነ ኤስ ኬያሶን ብያ አሱ ዙቴሬ ባሪን ካኛርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹ሀን አሱስ ኬርአናክ ካብና ኬያሶን ኬርኤ ኮእሱክ ኣነ ችሜዋ› ይቱ ካኞሶነ። ");
INSERT INTO jnje_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","አሲር ኩም ሜያ ታርኦባ ፌና እሳ ታቶ ሄፓስር ኩም ሜያ ታርኦባ ፌና ኦም ታቶስኔን ኤቴሬ ሜሮክ ሾሌፋናነ ጉማባስን ሜሮባሴዋ ሜሮ ቤይባሴ ዜምሜ ዲሬ ሜርኮኖር ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ኔቤሬ ዎልጉክ ሆፑንር ስንፋናነ ኤስ ኦም ታቶስ ዎካክ ፌን ኩርኡኒ ዎስሬ ጋኖክ ማምሲፌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ኤሲስማቶ ንቶስኒ ፋ ዉዝባሶን ዙትሬ ታክዋ ያት ቤይኖይ ኦኑ ስንፋናነ ናዎታ ስናናክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«ካዎስ ማአሪዋ፤ ስኑንታኖ ካርባሶን ቱርክፋናነ ኣካክ ካርአክ ችምንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ኤስ ኤፋቴና ካዎስ ዳሲክ ታኦ ኣፋ ስናናዉዛ ስንና ቦርአ ኤክ ጌሮ ክስሬቱ ሀእሶነዋ። ኦዶን ኦዶባ ፌና ባር ኦዶዎዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ግርቦ ዙትፌ ባሶትናዋ ቦርን ሜና ኦዶክ ዙቴሴሬ የሱስኒክ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ፌርሳዊኒ ሜናዋ ሙሴኒ ቱማሲ አስሲኛና፦ «ሀን አሱስ ቦርን ሜያኖን ባርኪ ታእስር። ባሶኔን አነ ደይ ሜር» ይት የሱስኒስታ ኡኚሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ኤስ ባሪ ቦርኣ የሱስ ሀን ቤሶሶን ኤካ ይት ባሶክ ማኬ፦ ");
INSERT INTO jnje_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«ንቶ ጋነያስን ትያ ፋንቱባ ፋና እሳ አሱ፥ ኤስ ፋንቱባስን እሳር ትሽፋናነ እዝግናስሬ እዝግኔሶን ፌሽ ድማስታ ሀኣት ትሽ ባሮን ዳናናኔን ሾሎክ ሀሚኖር ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ዳንፌና ካባሲክ ግሬሬ ኦጎግባስታ ዎርኤ ኬባ ዬፌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ሀሜ ኬባ ካርፌና ካባሲክ ዞሞባሳክቶኒናዋ ዎልኮባሳክቶኒና እሳሪክ ቴጌሬ፦ ‹ትሽ ፋንቱናሶን ዳና ቦርአ ታኔን አነ ግሮትዋ› ኡና። ");
INSERT INTO jnje_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ንቶክ ማኬፋውጙዋ፥ ኤሲስማቶ ደይ ሀርምያ ሾልሱኖይና እዝግናስሬ እዝግነ ኦኮኒ ሜያስታን ደናሎ ሀርምሬ ዎልፌ እሳ ቦር አሱሲክ ደን ሳማኪ አካማ ግራ ስኒፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ብርኪን ዎሱስቴ አሲር ሳንትብባ ፋና እሳ ማሽካሱ አሲሪስን እሳይስ ትሽፋናነ ዳናናኔን ቶና ቶኒራ ኬባሶን ፉትራ ሾሎኖይ አሱ ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ዳንፋና ካባሲክ ዞሞባሲክቶኖናዋ ዎልኮባሲክቶኖና እሳሪክ ቴጌራ፦ ‹ትሽ ብርን ሳንትብናሶን ዳና ቦርአ ታኔን አነ ግሮት› ኡና። ");
INSERT INTO jnje_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ንቶክ ማኬፋውጙዋ፥ ሀርሚ እሳ ቦር አሱሲክ ሀኦሲ ዎስኒ ስናክ ኤሲስማቶ ደይ ግራ ስኒፋዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ቱስሬ ደይ የሱስ፦ «ሄፕ ናንጎትባ ፌና እሳ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ሀቴ ናስ አባባስኒ፦ ‹አባታሶ ኦቱምኔስን ታክ ካርኒ ባሮን ሃአ እምማ› ይ። አባስ ደይ ኦቱምባሶን ሄፕ ናንጎትሲክ ሃኢ። ");
INSERT INTO jnje_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ሀቴ ናስ ጋሮ ዎናኔን ኦርፎ ዋግባሶን ኤጴ ዎካ ድማ ሀሚ። ኤስ ሀሚና ድማስታክ ሾሌናማቶ ስኬሬ ዋግባሶን ትሽክ። ");
INSERT INTO jnje_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ፋዪሶን ዙትሬ ኮእስናኔን ኦርፎ ኤስ ዳስታክ አካማ ማካ ግር። ባሪን ደይ ራክኮ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ኤስ ባሪ ቦርኣ ኤስ ዳስታኪ እሳ አሱኒክ ቴቴ። ኤስ አሱስ ደይ ሙኮ ኬማናክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ናስ ደይ ሙኮስ ሙኖን ሙናክ ሾሌት ፌር። ስኑንታኖ ኤስ ባሮኑ ባርኪ እማ አሱ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«ኤስታን ናስ ንብባሲ ኤካ ይት ሳፋሬ፦ ‹አባታሳ ኬርክ ዎስትኛስ አፑኒንሶ ሙ ጋውሬ ፉኤፌሪ? ስኑንታኖ ታ ሀንታክ ማካክ ክቱናርዋ! ");
INSERT INTO jnje_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ካብራ አባታሲክ ሀምፋት አባታሶ፤ ሀኦሴዋ ኔና አሲ ስና ማጙስጙዋ። ");
INSERT INTO jnje_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ሀንኔን ኤካሎ ነ ና ስንና ቴግቶናክ ኣነ ሾልስፋዋ። ስኑንታኖ ዎስትኛነሳስን እሳይስንነ ፌር ዛግራ ኤጳቶዋ› ኡናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ኤስታን ካብ አባባሲክ ሀሚ። አባባስ ደይ ዎክሶክ ዬፌን ቢሬ ኬናሽቴ። ኤክ ባርኪ ኤልለ እድሜ ዳሜ። ");
INSERT INTO jnje_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ናስ፦ ‹አባታሶ፥ ሀኦሴዋ ኔና አሲ ስና ማጙስጙዋ። ሀውጙኔን ኤካሎ ነ ና ስንና ቴግቶናክ ኣነ ሾልስፋዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ስኑንታኖ አባባስ ዎስትኛባሳክቶኒክ ኤካ ይ፦ ‹ታእኒን ኦማስታን ደናሎ ጋዳ ማማ ቴሸራ ማይሱትዋ። ኩሹባስ ደይ ግላ ዬትራ፥ ዎቾባስ ቻማ የቱትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ፋሩ ዝቢቻሶን ቴሸራ ሹክት። ሙን፥ ደይ ግሮን። ");
INSERT INTO jnje_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ሀን ናታስ ክትሬ ፌር። ሀሽ ደይ ካክ ፌር። ትሽሬ ፌር። ሀሽ ደይ ቤስቴ› ይ። ባሶ ደይ ግሮክ ካብሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«ኤስ ካባሲክ አሪክ ናስ ቡሎን ፎሽታቱ ፌ። ዬሬ ኬኤ ታእሴፌና ካባሲክ ሱሩነዋ እልልቹነ አሲ ካማ ኦደ። ");
INSERT INTO jnje_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ዎስትኛአሳስን እሳርን ቴጌሬ፦ ‹ሀን ኦደፋና ዉዛስ ኣምባንሶ?› ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ዎስትኛስ ዎልግሬ፦ ‹አይኔስ ዎል ሌ ዬና ቦርአዋ። አባኔስ ደይ ፋሩ ዝቢቻ ባርኪ ሹክቴዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«አሪክ አይባስ ግእቴሬ ኬር ግሩናክ ኣኔ ሾሎዌ። አባባስ ኬሩን ኬሴ ኬር ግሩናክ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","አሪክ ናስ ዎልግሬ አባባሲክ፦ ‹ኤፋቴና ሾዎ ነያ ኔክ ዎስቴን። ማኬታሶን እሳንነ ኣነ ቤዉት። ዞሞታስኔን አነ ማራ ግሮናክ እሳ ጋሮ ኖርኦኒነ ኣነ እሜዋ። ");
INSERT INTO jnje_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ስኑንታኖ ሀን ናኔስ ኦቱምኔሶን ጌርኬሳ አሱኔን ስኬሬ ትሽካት ዬን ፋሩ ዝብቻ ባርኪ ሹክት› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","አባባስ ደይ፦ ‹ናታሶ፥ ነ ዎንና ዎንና ታኔን አነቱ ፋትዋ። ታር ስና ባር ዙቴራ ኔርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ስኑንታኖ ሀን አይኔስ ክትሬ ፌር። ሀሽ ካክ ፌር። ትሽሬ ፌይስ ሀሽ ደይ ቤስቴ። ኤስ ባሪ ቦርኣ ግሮኒክ ሾልስፋዋ› » ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","የሱስ ናዎባሳክቶኒክ፦ «እሳ ኦቱም አሱ ኦቱምባሶን ሀእሲፌ እሳ ዎስትኛባ ፌር። አሱኒ ሜያ ኦቱም አሱሲክ፦ ‹ሀን ኦቱምኔሶን ሀእሲፌ ባር ኦቱምኔሶን ስኬት ፌርዋ› ይት ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ኤስ ኦቱም አሱስ ኦቱምባሶን ሀእሲፌ ባሪን ቴጌሬ፦ ‹ሀን ኦደፋና ነ ቾዋሲ ኣምባንሶ? ሀንኔን ኤካሎ ታ ኦቱምናሶን ሀእሱታክ ኣፋ ችማታ ዉዛ ስንና ቦርአ ኩሹኔስ ፋ ኦቱምናስ ፋዳኒ ትቻኖን ታክ እማ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ኦቱምባሶን ሀእሲፌ ባር ደይ ንብባሲ፦ ‹ዳምታስ ሀን ዎስቶስኒ ታን ካሌ ክሱንር ስንና ቦርአ አዉ ዛጉናሪንሶ? ቡሎናክ ሁግናና ኣፋ። ሺጶናክ ኢቾናር። ");
INSERT INTO jnje_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","አዉ ዛጉናማቶ አሪጙዋ። ዳምታስ ዎስቶስኒ ታን ክሳናነ ኬቤሲስ ታን ኤጶነክ ዞሞን ሆሱናዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«ኤስታን ዳምባሳ ኮዋ ባሶስታ ፋና አሱኒ ሜያኖን እሳ እሳርቤሲስን ቴጌሬ። ቴሱኒ አሱስን፦ ‹ዳምታሳ ኮዋ አፑኒንሶ ነይስታ ፋሪ?› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ባር ደይ፦ ‹እሳ ትያ ዋሻ ዛይትኒ ኮዋቱ ፋርዋ› ይ። ኦቱምባሶን ሀእሲፌ ባር፦ ‹ኤፋር ፎባሶን ቤስፋ ትቻስ ዉል ኤሴዋ፤ ዲፋት ኡቻስር ዋሻ ዛይትኒ ኮዋ ፋር ይራ ትቹዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ኤስታን ኦሚስን፦ ‹ነይስታ ፋ ኮዋ አፑኒንሶ?› ይ። ባር ደይ፦ ‹ትያ ኩምታሊ ዛጎኒ ኮዋ ፋርዋ› ይ። ኦቱምባሶን ሀእሲፌ ባር፦ ‹ኤፋር ስኒባሶን ቤስፋ ዉልኒ ትቻስ ኤሴዋ፤ ናጝናስር ኩምታል ይራ ትቹዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ዳምባስ አማናሞባ ፎንቶ ዎስትኛስን ሀጡማባሲክ ቴችማኖን ዲንቀ። ሀኦኒ አሱሳታን ደናሎ ሀን ዳስታኪ አሱኒ ሜያ ሀን ዳስታኪ ፎቤሲሲክ ሀጤ ስኖቤሲሶንቱ ቤስፋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«ንቶክ ማኬፋውጙዋ፥ ሀን ዳስታኪ ዋጋስ ኮእፋና ካባሲክ ሳማ ኬሩክ ንቶትን ኤጶነክ ሀን ዋጋሲክ ዞሞንትርን ሆሱትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ጋሮ ዉዛሲክ አማናምቶስ እኛ ዉዛሲክ አማናምቶ ስናና። ጋሮ ዉዛሲክ አማናምቶኖይ ባር እኛ ዉዛሲክ ኣፋዋ አማናምቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ኤሴ ሀን ዳስታኪ ዋጋሲክ አማናምቶ ቤይፋትነ ፉቶኒ ዋጋሶን ኦንሶ አማነሬ ንቶክ እምንሪ? ");
INSERT INTO jnje_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ኦም አሱሳ ዋጋሲክ አማናምቶ ስና ሻካትነ ንቶ ቴትን ዋጋሶን ኦንሶ ንቶክ እምንሪ? ");
INSERT INTO jnje_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«እሳ አሱ ሄፕ ዳምኒክ ቦዝ ስናናክ ኣፌዋ ችማናዉዛ። እሳይስን ኦምቴፋት ሄፕሳስኒ ሹናና። እሳይስን ኡልፍንሱና ሄፕሳስ ካሹና። ሀኦስክናዋ ዋጋ አሲክና ቦዝ ስናክ ኣፋ ችማት ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ፌርሳዊኒ ሜያ ዋጋ ሹነቴር ስንና ቦርአ ኤስ ባሮን ኦዳት የሱስኒን ካኘሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","የሱስ ደይ፦ «ንቶ ቴትንትሶን አሱኒ ስና ኦኮ ዛግፌትዋ። ስኑንታኖ ሀኦሲ ንብንትስ ሳፋራኖን አሪርዋ። አሱኒ ስናክ ኡልፍንቶስ ሀኦሲ ስናክ ኦምቴስቴርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ቱስሬ ደይ የሱስ፦ «ቱማሴዋ ራጁኒ ሜኒ ትቻሴ ዮሀኒስኒስታ ካርአናኔን ማክቴት ፋር። ኤሴን ሀጝ ደይ ሀኦሲ ታቶኒ ምስራቹኒ ካማስ ማክቴድፋር። አሱ ዙቴሬ ደይ ኤስ ሀኦሲ ታቶስ ግሩናክ ካቤድፌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ስኑንታኖ ቱማስኒ እሳ ዱክቶነ ዮኡባስታን ሳማሴዋ ዳሴ ኣትፋናነ ካሾዋ። ");
INSERT INTO jnje_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«አሱባሶን ጋፍካት ኦማ አሱ ኤጵፌ ባር ዙቴሬ ጌርኬሶዋ። ኤሲስማቶ ደይ ቴጎባስኪን ጋፉክቴ አሱሶን ኤጳ ባር ጌርኬሶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ደይ የሱስ ኤካ ይ፦ «ዋግባ ችማ ሸአ ማምነዋ ሴሳ ማምነ ማዮ እሳ ኦቱም አሱ ፌር። ባር ደይ ዎና አካማ ጌአክቱ ፌፌ። ");
INSERT INTO jnje_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","አቱባ ዙቴራ ማዛየና አላዛር ይስቴ ቱካም ኦቱም አሱሳ ፍኝታ ኩንፌር። ");
INSERT INTO jnje_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ኤስ ቱካም አሱስ ኦቱም አሱሳ ማድታን ዝግፋ ፉፉኒቶሶን ሙናክ ሾሌት ፌር። ካናሲክቶ ደይ ያታፋ ማዛባሶን ናሪት ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«ኤስ ቱካሚስ ደይ ክት። ሀኦሲ ዎስያንክቶ ደይ አብራሀምኒ ቴሻ ኤጳ ታም። ኦቱም አሱስ ደይ ክትሬ ካባርቴ። ");
INSERT INTO jnje_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ኬኦኒ ድማስ ፌፋት ካነ ዎክሶክ አብራሀምኒናዋ ባሳ ቴሻ ፌ አላዛርንና ቢ። ");
INSERT INTO jnje_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ኤስ ኦቱም አሱስ፦ ‹አባ አብራሀምኖ፥ ታክ ኬናሽቶዋ። ሀን ጌያስ ውኖስ የሬናር ስንና ቦርአ ኩሹባስ ሳናክ አካ ዱክሬ ቴሩምናሶን ሃቱናክ አላዛርኒን ታክ ዎሱዋ› ይት ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«አብራሀም ዎልግሬ ኤካ ይ፦ ‹ናታሶ፥ ነ ዳስታኪ ፎኔስ ነያክ ማአ ዉዛ ዳንታማቶ ሳፋሮዋ። ስኑንታኖ አላዛር ደይ ዳስታኪ ማጙ ዉዛ ኤጴቴና ቦርአ ሀሽ ባር ሀንታ ማአሪክ ፎና ነ ደይ ሻናስ ፎታ። ");
INSERT INTO jnje_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ኤስ ባርስታን ደናሎ ንቶናዋ እንኖና አሲ ጋነያስ እኛ ጋዉ ፋርዋ። ኤስ ባሪ ቦርኣ እኖኪን ንቶክ ደይ ንቶኪን እኖክ ፍናክ ችምንር ኦኑ ኣፌዋ።› ");
INSERT INTO jnje_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ኦቱም አሱስ ደይ ኤካ ይ፦ ‹ኤሴ አባ አብራሀምኖ፥ አላዛርኒን አባታሳ ኬር ዎሱታክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ኡች አይታ ፌሴቴር ስንና ቦርአ ባሶ ደይ ሀን ሻናን ድማስ ዮሶኖይቴማቶ ሀሜ ማኮዎዋ።› ");
INSERT INTO jnje_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«ስኑንታኖ አብራሀም፦ ‹ባሶክ ሙሴናዋ ራጁኒ ሜና ፌሴቴርዋ። ባሶኪን ኦዶሶቶዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ኦቱም አሱስ ደይ፦ ‹ኤካታዋ አባ አብራሀምኖ፥ እሳ አሱ ክቱኒ ካብሬ ሀሜ ማኬፋናነ ሀርሙሶቤስዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","አብራሀም ደይ፦ ‹ሙሴኒ ትቻሶናዋ ራጁኒ ሜኒ ማፃፋሶና ኦዶ ቤያ ባሶ እሳ አሱ ክቱኒ ካብሬ ሀሜ ማኬፌናክኑ ኣፋዋ ኦዶሶነ ዉዛ።› » ");
INSERT INTO jnje_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","የሱስ ናዎባሳክቶኒክ ኤካ ይ፦ «አሱኒ ሜያኖን ቱሳስራ ቦርአ ዎስቶሶነክ ዛጉንዉዛ ዮ ቤያና ዉዛ ኣፋዋ። ስኑንታኖ ኤስ ቦርኣስ ቱሳኖን ኤጴ ዮን አሱስ የሬፋዎዋ። ");
INSERT INTO jnje_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ኦኑ ሀን ጋሮ ጋሮ ናንጎታስን እሳይሶን ቱሳሱባስታን እኛ ዎኒ ሹአ ሱትባስታ ታቴራ ትርእማሲ ሀቴፋናነ ማአሪዋ። ");
INSERT INTO jnje_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ኤስ ባሪ ቦርኣ ንቶ ቴታሲክ አሩትዋ። አይነ ኔን ሚርኤፋናነ ኬኡዋ። ኤስ ማጝሱባሲክ ጋቤፋናነ ፌሹን ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ዎናስን ናፉና ዎል ሌ ኔን ሚርኤፋናነናዋ ኔክ ዎል ሌ ዬፋፌ፦ ‹ማጝሱናሲክ ጋቤጝዋ› እያናነ ፌሹን ኡዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ዎስባሳክቶ ደይ ዳሚስን፦ «አማንቶኒሶን እኖክ ዳይሳይዋ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ዳሚስ ደይ ዎልግሬ፦ «ፍፍኦኒ ጋናነ ፋ ጋሮ አማንቶኒት ፋፋናነ ሀን ድ ቴያሶን፦ ‹ዋቴራ ዬት ትርእማሲ ቶክቶዌ› ይፋትነ ንቶክ አጃጃምቶናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ንቶ ጋነያስን እሳይስ ቡልኛባ ወደይ ፋንቱሲ ኬሜርባ ፌናር ኤስ ዎስትኛስ ዎስቶባስኒ ዎል ሌ ዬፌና ካባሲክ ጌሬጌሬ፦ ‹ሀጝ ታእሴራ ዲራ ሙኔሶን ሙዋ› ይፌዎሶ? ");
INSERT INTO jnje_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ኤስ ባርስታን ዜምሜ፦ ‹ሜታኡ ታክ ሆሱዋ። ታ ማራ ኡሻናኔን ታርኤራ ታክ ዎስቶዋ። ኤሴን ኦርፎ ነ ደይ ማራ ኡሻታ› ኡታኖሶ ይፌናሪ? ");
INSERT INTO jnje_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ኤኪን ኤስ ዎስትኛባስ ዳምባስ ማኬና ባሮን ማእ ይሬ ዎስቶባሲክ ዳምባስ ጋላቴፌዎሶ? ");
INSERT INTO jnje_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ኤሴ ንቶ ደይ ማክቴ ባሮን ዙትራ ዛግፌት ካባሲክ፦ ‹እንኖ ኬኖይ ዎስትኛዋ፤ ዛጉንክ ሾልስ ዎስቶሶንቱ ዎስቴንዋ› ኡትዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","የሱስ የሩሳሌም ሀማስ ሳማርያነዋ ጋሊላነ አሲ ጋነሲ ካሞ ኣት። ");
INSERT INTO jnje_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","እሳ ኬኤስ ካርፌና ካባሲክ አሲር አዋታቶኒ ሜሮን ሜታን ሜያ ባሪን ሁጵሴሬ ዎክሶክ ዬርሴሴፋት፦ ");
INSERT INTO jnje_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«የሱስ ዳምኒሶ፥ እኖክ ኬናሽቴፋይዋ!» ይሴት ቴጋ ካማክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","የሱስ ባሶትን ብያት፦ «ሀሜፋት አቱንትሶን ማግኒ ሜያክ ቤሱትዋ» ይ። ባሶ ደይ ሀሜፌጌዶ ኡግናስታክ ፋርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ባሶ ጋነያስን እሳይስ ፋሩባሶን ቢናይሴ አካማ ካማክ ቻጌ ሀኦሶን ጋላቴት ዎል ሌ የ። ");
INSERT INTO jnje_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","የሱስኒ ዎቾስ ካአነሬ ጋላቴ። ባር ደይ ሳማሪያኪ አሱ። ");
INSERT INTO jnje_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","የሱስ ኤካ ይ፦ «አዋታቶኒ ሜሮቤሲስኒ ፋሪስ አሲር አሱቴኖሶ? ኤኪን እዝግኒስ አይፌሴቴሶ? ");
INSERT INTO jnje_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ሀን አላጋ አሱስቴኖ ኦም ሀኦሶን ጋላቶክ ዎል ሌ ዬር ኣፌኖሶ?» ");
INSERT INTO jnje_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","የሱስ ኤስ አሱስን፦ «ካብራ ሀማ፤ አማንቶኔስ ኔን ፋትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ፌርሳዊኒ ሜያ የሱስኒን፦ «ሀኦሲ ታቶ ኣጌንሶ ዮናሪ?» ይሬ ማሙሴቴ። ባር ደይ ኤካ ይሬ ዎልጊ፦ «ሀኦሲ ታቶ አሱኒ ሜያ ቢሴፌስንነ ፋ ኡግናክ ኣፋዋ ዮናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ሀንታዋ ወደይ ኤክ ኤስታዋ ኡክ ኣፋ ችሞነ ዉዛ። ሀኦሲ ታቶ ሀን ንቶ ጋነያስቱ ፋዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ቱስሬ የሱስ ናዎባሳክቶኒክ ኤካ ይ፦ «አሱሳ ናኒ ዎናሲክቶስ እሳይሶን ብያክ ካልቶት ዎና ዮና። ስኑንታኖ ኣፋ ብያት ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","አሱኒ ሜያ፦ ‹ክርስቶስ ሀንታቱ ፌዋ ወደይ ኤክ ኤስታቱ ፌዋ› ይሬ ንቶክ ማክሶነ። ባሶ ኦርፎነ ሀማትታ ደይ ዞኑስቶትታ። ");
INSERT INTO jnje_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ካዉና ሳማስታ ካዉና ድላኔን ድላ ካትራ ቻርስፋናሲማቶ አሱኒ ና ዬፌና ዎኖ ኤሲስማቶቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ስኑንታኖ ኤስ ባር ስኒባስኔን ዜምማ አሱኒ ና አካማ ሻና ኤጴቶናክናዋ ሀን ኮኒቶሲክ ደይ ካሽስቶናክና ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ኖህኒ ነያሲክ ስንናስማቶ አሱኒ ና ዬፌና ዎኖ ደይ ኤካቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ኖህ ሜርኬቢስ ግሩና ዎና ካርአናኔን አሱኒ ሜያ ሜትናዋ ኡሸትና፤ ኤጴትናዋ ግርትና ፌሴቴር። ትሽኩን አካስ ያራ ዙታምቤሲሴ አሲን ትሽክ። ");
INSERT INTO jnje_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ሎጥኒ ነያሲክ ደይ ኤሲስማቶቱ ስኒ። አሱኒ ሜያ ሜትናዋ ኡሸትና፤ ኬሩን ክስሬ ዋጌትናዋ ጌሮን ዋጌሬ ዬትና፤ ቶኮ ቶኬትናዋ ኬያ ኬርኤትና ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ስኑንታኖ ሎጥ ሶዶሙን ኬስና ዎኖ ሳማን ጌነዋ ጌኒ ካዮነ ዎቴራ ዙታምቤሲሴ አሲን ትሽክ። ");
INSERT INTO jnje_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","አሱኒ ና ዎል ሌ ዮና ዎኖ ኤካቱ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«ኤስ ዎኖ ኬያስ ቱክታ ፌ ባር ኦኑ ስንፋናነ ኬር ፋ ዉዝባሶን ኤጳናክ ኬሮናታ። ቡሎን ድማስታ ፌ አሱስ ኬር ዎሉናታ። ");
INSERT INTO jnje_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ሎጥኒ አሱስ ስንና ባሮን ሳፋሮት። ");
INSERT INTO jnje_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ካባሶን ፉኦክ ሾሌ ባር ዙታምባሴ ትሽኩና። ስኑንታኖ ካባሶን ኣትሬ እማ ባር ፉኦና። ");
INSERT INTO jnje_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ንቶክ ማኬፋውጙዋ፤ ኤስ ዎኖት ዋላሲክ ሄፕ አሱ እሳ ኩጶታ ኩኖና፤ እሳይስ ኦቶና፤ እሳይስ ፉእቶና። ");
INSERT INTO jnje_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ሄፕ ማሽካሱ እሳ ድምታ ሜያ ንኦና፤ እሳይስ ኦቶና፤ ሄፕሳስ ፉእቶና።  ");
INSERT INTO jnje_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ሄፕ አሱ ቡሎን ድማስታ ዎስቶሶነ፤ እሳይስ ኦቶና፤ ሄፕሳስ ፉእቶና» ");
INSERT INTO jnje_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ናዎኒ ሜያ ደይ፦ «ዳሚሶ፤ ኦቴሬ ሀሞኔስ አይንሶ?» ይት ማሙሴቴ። የሱስ ደይ፦ «አሻ ፋናስታቱ አሪካሳ ዙቴፋዋ» ይት ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","የሱስ ናዎባሳክቶኒክ ሆፑኖይ ዎንና ዎንና ሺጵሶነክ ሾልሱ ስንናማቶ ቤሱክ ሀን ቤሶሶን ኤካ ይት ማኬ፦ ");
INSERT INTO jnje_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«እሳ ካታማስ ሀኦሶን ድጎኖር አሱኒን ደይ ኢቾኖይ እሳ ጋኛ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ኤስ ካታማስ እሳ ድቻ አሱ ፋር። ባር ደይ ጋኝኛስክ ሀሚፋፋ፦ ‹ታናዋ ታ ጉማስና አሲ ጋነሲ ማላታሲክ ማጝሱ ካርዋ› እያፋ ሽምስ። ");
INSERT INTO jnje_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","ጋኝኛስ ደይ ኤስ ካባሲክ ማእ ኣነ ኡዌ። ስኑንታኖ ኦርፎ ንብባሲ ኤካ ይ፦ ‹ሀኦሶን ድጎ ቤይፋናክ ወደይ አሱኒን ኢቾ ቤይፋናክ ሀን ድቻ አሱስ ታን ሽምስት ፋር ስንና ቦርአ ዎንና ዎንና ታን ራክሱኖይናማቶ ባርኪ ማጝሱ ካርአናዋ› » ");
INSERT INTO jnje_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ቱስሬ ደይ ዳሚስ፦ «ማጙ ጋኝኛስ ማኬና ባሮ ያዳቶት። ");
INSERT INTO jnje_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ኤኪን ቶነ ዋልነ ሀኦሲክ ቻጌት ፌሴ ባር ኮርቶ አሱስን ኣፋኖሶ ባሶክ ማጝሱ ካርአናዉዛ? ባሶትን አሪጋሱኖይ ዎኪንሮሶ? ");
INSERT INTO jnje_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ንቶክ ማኬፋውጙዋ፤ ታፕቴራቱ ማጝሱ ካርአናዋ። ስኑንታኖ አሱኒ ና ዎል ሌ ሀን ዳስታክ ዬፌና ካባሲክ አማንቶባ ፋና አሱኒን ዳኑጌሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ቱስሬ የሱስ ቴትቤሲሶን ኦኮ ዛግሬ ቴቶክናዋ ኦሚስን ደይ ካሽሴፌ ባሶክና ሀን ቤሶሶን ማኬ፦ ");
INSERT INTO jnje_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«ሄፕ አሱኒ ሜያ ሺጶክ ቤቴሜቅደስ ሀሜቴ። እሳይስ ፌሪሳዊ፤ ሄፕሳስ ግርቦ ዙት አሱ። ");
INSERT INTO jnje_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«ፌርሳዊስ የሬፋት ንብባሲ ኤካ ይት ሺጴ፦ ‹ሀኦሴ፤ ታ ኦም አሱኒ ሜኒማቶ ቦእኛ፥ ማጙ፥ ጌርኬሳር ስና ቤይና ቦርአ ኔን ጋላቴፋን። ሀን ባርስታን ደናሎ ሀን ግርቦ ዙትፌ ቦርእኛ አሱስነ ፌር ስና ቤይና ቦርአ ኔን ጋላቴፋን። ");
INSERT INTO jnje_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ታ ቶርባኒስኒ ሄፕ ዎና ሶሜናር። ዳንፋናስታን አሲሪስን እሳሮን እምናር› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«ስኑንታኖ ግርቦ ዙትፌ አሱስ ዎክሶክ የሬፋት ደን ሳማ ካነ ብያናክኑ ኣነ ችሜ። ንባሶን ክኤት፦ ‹ሀኦሴ፤ ታ ቦርእኛአሲን ፋኩዌ› ይት ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ንቶክ ማኬፋውጙዋ፤ ፌርሳዊሳታን ደናሎ ሀኦሲ ስና ኦኮ ስንነ ፋድቴሬ ኬባ ሀሚ። ቴትባሶን ደን ቴግፌ ባር ዳ ሀቶና። ስኑንታኖ ቴትባሶን ዳ ሀቴስፌ ባር ደን ቴጉና።» ");
INSERT INTO jnje_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","የሱስ ጋሮ ጋሮ ናንጎታሶን ሱሳናክ ባርኪ ቴሸሴቴ። ናዎባሳክቶ ደይ ኤስ ባሮን ብያት ካለሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ስኑንታኖ የሱስ ጋሮ ጋሮ ናንጎታሶን ባርኪ ቴጌሬ ኤካ ይ፦ «ጋሮ ጋሮ ናንጎታ ታክ ዮኖይናማቶ ካላትታ። ሀኦሲ ታቶ ሀን ባርኪቶነ ፌይሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ንቶክ ፉቶ ማኬፋውጙዋ፤ ሀኦሲ ታቶኖን ሀን ጋሮ ጋሮ ናንጎታስንነ ፋሮን ዛግሬ ኤጴቶኖይ ባር ኣፋዋ ግሩና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","አይሁድኒ ጋኜ ሜያስን እሳይስ፦ «ጋራም አስሲኛኖ፥ ኮእባ ፎንቶ ካክ ዳናክ አዉ ዛጉናሪንሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","የሱስ ኤካ ይሬ ዎልጊ፦ «አዉኒሮን ታን ጋራም ይፋሶ? እሳ ሀኦሲኔን ኦም ጋራም ኦኑ ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‹ጌርኬሳታታ፤ ካ ዎሩታታ፥ ዊሶታታ፥ ኤሻ ዛላ ማኮታታ፥ አባነስንናዋ እንቶኔሶንና ኡልፍንሱ› ይፋ አጃጂሶን አሪታርዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","አሱስ ደይ፦ «ኤስ አጃጂሲክቶኖን ዳግናሴኔን ኦዳቱ ፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","የሱስ ኤስ ባሮን ኦድናይሴ፦ «ኤሴ እሳ ዉዛ ዛጉታ ዉዛቱ ፉእቴርዋ፥ ፋ ዉዝኔሶን ዙትራ ዋጌራ ቱካምኒ ሜያክ እማ። ሳማ ኬሩክ ዳናታዋ። ኤካኒ ታኔን አነ ሀሚንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ስኑንታኖ አሱስ አካማ ኦቱምባ ፋር ስንና ቦርአ ኤስ ባሮን ኦድናይሴ አካማኖን ሱሜ። ");
INSERT INTO jnje_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","የሱስ አሱስ አካማኖን ሱሜናማቶ ብያት ኤካ ይ፦ «አካማ ኦቱምቤስ ፋና ባሶክ ሀኦሲ ታቶስ ግሩ አዉነ ፋ ትርኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ኦቱም አሱ ሀኦሲ ታቶስ ግሩባስታን ጋላ ማሩፍን ኣፍስ ካሞ ኣትባስቱ ካሾዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ኤስ ባሮን ኦደ አሱኒ ሜያ፦ «ኤኪን ኦንሶ ፋሩክ ችምንሪ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ስኑንታኖ የሱስ ዎልግሬ፦ «አሱኒክ ችምቶኖይ ዉዛስ ሀኦሲክ ችምቴርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ጴጥሮስ፦ «ኤሴ እንኖ ፋ ዉዝኒሶን ዙትራ ቤያ ነኔን አነ ያንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","የሱስ ዎልግሬ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፥ ሀኦሲ ታቶክዋ እያት ኬባሶን ወደይ አሱባሶን ወደይ አይባሳክቶኒን ወደይ ኮኒ አባ እንቶሶን ወደይ ናንጎትባሶን ቤያ ባር ሀን ዳስታኪ ሄፕ ኩሹኖን፥ ዮን ነያሲክ ኮእባ ፎንቶ ካ ኤጴቶኖር ኦኑ ኣፌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","የሱስ አሲሬ ሄፔ ናዎባሳክቶኒን ኦር ክሳት ባሶክ ኤካ ይ፦ «ኤሴ ኤክ የሩሳሌም ሀማንርዋ። አሱኒ ናኒ ቾዋሲክ ራጁኒ ሜያክ ካሞ ትቼ ባር ኮኡኒርዋ ");
INSERT INTO jnje_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ባር አዛብኒ ሜያክ ኣትሬ እምቶኒር። ባሶ ደይ ባሪን ካሹሶነ፥ ሜኦሶነ፥ ቱጆሶነ። ");
INSERT INTO jnje_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","እቾሶነ፥ ኤስታን ዎርሶነ። ስኑንታኖ ባር ኬስናር ዎኖ ክቱኒ ካቡና።» ");
INSERT INTO jnje_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ስኑንታኖ ናዎባሳክቶኒክ ኤስ ማኬና ቾዋሲ ዙቴራ ኣነ ጋሎዋ። ባር ማኬና ቾዋሲ ባሶክ ኣቸና ቦርአ አዉ ማኬናማቶ ኣነ አሪሶቶ። ");
INSERT INTO jnje_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","የሱስ እያሪኮ ታእሴፌና ካባሲክ እሳ ኣፍትሹ ኡጉንታ ዲፋት ሺጴድፌር። ");
INSERT INTO jnje_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ኣፍትሹስ ቴሽባ ካሞ ኣትፌ ዳራሳ ካማኖን ኦደፋት፦ «ሀን ባር ኣምባንሶ?» ይሬ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ባሶ ደይ፦ «ናዝሬትክ የሱስቱ ሀንታ ካሞ ኣትፌርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ኣፍትሹስ ደይ፦ «ዳዊትኒ ና የሱስኖ፥ ታን ፋክፋይዋ» ይት ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ስናስታ ሀሜት ፌ አሱኒ ሜያ፦ «ሻኩዋ!» ይት ካለቴ። ስኑንታኖ ባር ካምባሶን ቴግሬ፦ «ዳዊትኒ ናሶ ታን ፋክፋይዋ» ይት ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ኤስታን የሱስ የሬሬ አሱስን፦ «ሀጝ ታክ ዮዋ» ይት አጃጀ። ኣፍትሹስ ባርኪ ታእሴፌና ካባሲክ፦ ");
INSERT INTO jnje_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«ኔክ አዉ ዛጉናኪንሶ ሾሌፋ ታሪ?» ይሬ ማምሲ። ኣፍትሹስ፦ «ዳሚሶ፥ ብያናክቱ ሾሌፋኡጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","የሱስ ደይ፦ «ቢዋ፥ አማንቶኔስ ኔን ፋትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ኣፍትሹስ ጌሬጌሬ ቢ። ሀኦሶን ደይ ጋላቴት የሱስኔን አነ ሀሚ። ዳራስ ዙቴሬ ኤስ ባሮን ብየቴሴ ሀኦሶን ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","የሱስ እያሪኮኒ ካታማስ ካሞ አቴ ሀሚድፌር። ");
INSERT INTO jnje_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ኤስታክ ዛክዎስ ይስቴ ግርቦ ዙትፌ ባሶ ጋኛ ስና ኦቱም አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ባር የሱስ ኣፌር ስንናማቶ ብያናክ ሾሌት ፌር። ስኑንታኖ የርእባ ካዉና ስንና ቦርአ ዳራሳ ሾዎታን ካብ ቾዋ ብያክ ኣነ ችሜ። ");
INSERT INTO jnje_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","የሱስ አቴ ሀማና ኡግናስታ ባሪን ብያክ ስና ኤልለ እሳ ቴን እኦታ ኬስ። ");
INSERT INTO jnje_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","የሱስ ኤስታ ካርፌና ካባሲክ ደን ካነ ብያት፦ «ዛክዎስኖ፥ ታፕቴራ ኬሮዋ፤ ሀሽ ሀውጙ ኔክ ኬር ፌሻናክ ሾልሱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ዛክዎስ ደይ ታፕቴሬ ኬሬሬ ግራክ የሱስኒን ኬባ ኤጴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ኤስ ባሮን ብያ አሱኒ ሜያ ዙቴሬ፦ «ቦር ስና አሱሳ ኬር ሙ ሙናክ ግሪዋ» ይት የሱስኒስታ ኡኚሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ስኑንታኖ ዛክዎስ የሬሬ የሱስኒን፦ «ዳሚሶ፥ ፋ ኦቱምናስ እሳ ኩኑኖን ቱካሚሲክ እማናዋ። አሱኒስታን ኤሻክ ኤጵና ዋጋ ፋፋናነ አቼች ኩሹ ዛግራ ዎልጉናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","የሱስ፦ «አሱኒ ና ትሽ ባሪን ሾሎክናዋ ፉኦክናቱ የዋ። ሀን አሱስ ደይ አብራሀምኒ ና ስንና ቦርአ ሀሽ ሀውጙ ፋሩ ሀን ኬያሲክ ስኒዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ዳራኒ ሜያ ኤስ ባሮን ኦደሴፌን የሱስ እሳ ቤሶ ባሶክ ማኬ። ባር የሩሳሌም ታእሴና ቦርአ አሱኒ ሜያክ ሀኦሲ ታቶ ያራ ካርድፋነ ፋር ስንና ባሶክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ኤስ ባሪ ቦርኣ ኤካ ይ፦ «ታቴሬ ዮናክ ዎካ ዳ ሀማ እሳ ኡልፍንቶ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ሀሚኖይፌጌዶ ዜምሜ ዎስትኛባሳስን አሲርን ቴጌሬ፦ ‹ታ ዎላ ዮናኔን ናጋደራ ቡእሱትዋ› ይት አሲር ሚናን እማት ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ስኑንታኖ ኤስ ዳስ አሱኒ ሜያ ባሪን ኦምቴሴቴ ቦርአ፦ ‹ሀን አሱስ እኖስታ ታቶናክ ኣነ ሾሌፌን› ይሬ ሀሚናኔን ኦርፎ ዎስኒን ዎሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«ስኑንታኖ ኤስ አሱስ ታቴሬ ዳባስታ ዎል ሌ የ። ኤስ ዎስትኛባሲክ እምና ዋጋሶን ናጋደሴሬ አዉነ ፋሮን ቡእስሴቴማቶ አሩናክ ቴግስ። ");
INSERT INTO jnje_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","እሶንሳ ዎስትኛስ ዬሬ፦ ‹ዳሚሶ፥ እምታ ብሪስ አሲሮን ቡኤዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ዳምባስ፦ ‹ነ ማአ ዎስትኛ፥ ማአሮን ዛግትዋ። ጋሮ ዉዛሲክ አማናምቶ ስንና ቤስቴትዋ። አሲር ካታማሶን ሀእሱታክ ሀእሱኒ ሁግና ኔክ እምጝዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ሄፕሳን ዎስትኛስ ደይ ዬሬ፦ ‹ዳሚሶ እምታ ብሪስ ኡቾን ቡኤዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ዳምባስ ደይ፦ ‹ነ ኡች ካታማሶን ሀእሱታክ ታስጝዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«ኦም ዎስትኛስ ደይ ዬሬ ኤካ ይ፦ ‹ዳምታሶ፥ ኤርቤስ ብርራ ኩንስና ብርኔስ ሀንፋዋ። ");
INSERT INTO jnje_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ነ ኩንሱኖይታሶን ኤጵታር፤ ቡክኖይታሶን ደይ ካርታር፤ ነ ኬና ቡዱ አሱ ስኒታ ቦርአ ድጌጝዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ዳምባስ ደይ ኤካ ይ፦ ‹ነ ማጙ ዎስትኛ፥ ሀን ዎሉምኔሲክ ነይስታ ማጝሱ ካርአናዋ። ታ ኩንሱኖይናሶን ኤጳር፥ ቡክኖይናሶን ካርአ ኬና ቡዱ አሱ ስንናሶን አሪታነን፤ ");
INSERT INTO jnje_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ታ ያራ ዋግናሶን ኮኒቶባስኔን ኤጳናክ አዋጋን ባንኪኒ ኬር ኩንሱ ቤይሶ?› ");
INSERT INTO jnje_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ኤስታን ዳሚስ ኤስታ ዬሴ ባሶክ፦ ‹ዋጋሶን ባርኪን ኤጳ አሲር ብር ፋና ባርኪ እምትዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ባሶ ዎልግሬ፦ ‹ዳሚሶ፥ ባርኪ አሲር ብርባ ፋርዋ› ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ዳሚስ ኤካ ይ፦ ‹ንቶክ ማኬፋውጙዋ፥ ፋና ባርኪ ዳይቴራ እምቴርዋ። ስኑንታኖ ፎንቶሳታን ባርኪ ፋ ባርኑ ኦቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ስኑንታኖ ታ ባሶስታ ታቶናክ ሾሎኖይ ታ ጉማሳክቶኒን ሀን ቴሸራ ታክ ስና ዎሩትዋ።› » ");
INSERT INTO jnje_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","የሱስ ኤስ ባሮን ማኬናኔን ኦርፎ ኤክ የሩሳሌም ሀማክ ናዎኒ ሜኒ ስና ዜም። ");
INSERT INTO jnje_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ዳብራዛይትኒ ኩማስ ቴሻ ፋ ቤቴፋጌነዋ ብታኒያነ ስኒፋ ካታማ ታእሴናሴ ናዎባሳስን ሄፕን ኤካ ይሬ ዎሲ፦ ");
INSERT INTO jnje_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«ኤክ ስኒትስታ ፋ ኬኤስ ሀሚትዋ። ኤስታክ ኦኑ ባርስታ ዱኖይና ሀኛን ናዋ ቱፕቴራ የሬፌኒ ዳናት። ኮታ ዮትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ኦኑ፦ ‹አዉኒሮን ኮትፌትሪንሶ?› ይሴሬ ማሙሴፋቴነ፦ ‹ዳሚሲክ ሾልሱ ስንና ቦርአዋ› » ኡት። ");
INSERT INTO jnje_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ዎስቴሬ ሀማ ባሶ የሱስ ማክቴናስማቶ ዳነቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ሀኛስ አባን ሜያ ኮቴፌን ብየሬ፦ «አዉኒሮን ኮትፌትሪንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ባሶ ደይ ዎልግሬ፦ «ዳሚሲክ ሾልሱ ስንና ቦርአዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ኤስታን ሀኛሶን የሱስኒክ ኤጴ ዬሴቴ። ጌሾባስታ ማያ ኩኑሴሬ የሱስ ዱናክ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","አሱኒ ሜያ ባር ሀሚፌና ኡግናስታ ማይቤሲሶን ይርኤት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ዳብራዛይትኒ ኩማስታን ኬሬፋ ኡግናስታ ታእሴሴፌ ካባሲክ ባሳ ናዎኒ ሜያ ቢሴቴ ቢስቴራ አሪቶኖይ ዉዛ ዙታምባሴ አሲክ ግራክ ቱሜሬ ካምቤሲሶን ቴግሬ ሀኦሶን ኤካ ይት ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«ዳሚሳ ሱናክ ዬፌ ታቶስ ሱስቶዋ። ደን ሳማኪ ናጋ፥ ኡልፍና ደይ ቴግራ ፋ ሀኦሲክ ስኑን» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ዳራሳ ጋነሲ ፌ እሳ እሳ ፌርሳዊኒ ሜያ የሱስኒን፦ «አስሲኛኖ፥ ሀን ናዎኔሳክቶ ሻኩሶነክ ዛጉዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ባር ደይ፦ «ንቶክ ማኬፋውጙዋ፥ ባሶ ሻክሴፌክኑ ሹኣሲክቶ ቻጌርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","የሱስ የሩሳሌም ካታማስ ታእሴሬ ካታማሶን ብያት ባርኪ ዋሲ። ");
INSERT INTO jnje_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ኤካ ደይ ይ፦ «ኔክ ናጋ ስኒ ባሮን ሀውጙ ኣምሴ አሪታ! ስኑንታኖ ሀሽ ነ ኣፋስኒ ኣቸዌ። ");
INSERT INTO jnje_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ነ ጉማስ ብራቶኔሶን ኦጅባ ኦጅጀ ጋነያ ጌደ ኔን ሻና ቤሶነ ዎና ዮኒርዌ። ");
INSERT INTO jnje_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ሀኦሲ ኔን ፉኦክ ያና ባሮን ኣነ አሩዌ ስንና ቦርአ ኔናዋ ነ ስካሎስ ፋ ናንጎትኔሲክቶነ አሲን ዎርሶነ። ቦክቶኖይ እሳ ሹአኑ ሹኣስታ ዲራ ኣፋ ቤስቶና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ኤስታን የሱስ ቤቴሜቅደሲሲ ግሪሬ ኤስታክ ናጋደት ፌ ባሶትን ካሌ ክስ። ");
INSERT INTO jnje_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ኤካ ደይ ይ፦ « ‹ታ ኬያስ ሀኦ ሺጵቶና ኬያቱ ስናና› ይስቴራቱ ትቼ። ስኑንታኖ ንቶ ቦእኛኒ ሜኒ ዱጋዱግ ዛግሴት» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","የሱስ ዎንና ዎንና ኤስ ቤቴሜቅደሲሲ አሲት ፌር። ማግኒ ጋኝኜ ሜናዋ ቱማስ አስሲኛና፥ ዳራስን ሀእሲፌ ኦም አሱኒ ሜና ባሪን ዎሩክ ሾልሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ስኑንታኖ ዳራስ ዙቴሬ ባርኪ ታእሴሬ ኦደት ፌሴቴር ስንና ቦርአ እሳ ዉዛነ ዛጉክ ኣነ ችሞቶ። ");
INSERT INTO jnje_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","እሳ ዎኖ የሱስ ቤቴሜቅደሲሲ ዳራስን አሲፌናዋ ምስራቹኒ ካማሶን ማኬፌና ማግኒ ጋኝኜ ሜናዋ ሙሴኒ ቱማሲ አስሲኛና ደይ ኩርኡኒ ሜና ባርኪ ዬሴሬ እሳ ማምሱ ማሙሴቴ፦ ");
INSERT INTO jnje_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«ነ ሀን ባሮን ዛግፋታስ አሮ ሀእሱኒ ሁግናኪንሶ? ወደይ ሀን ባሮን ዛጉታክ ሀእሱኒ ሁግና ኔክ እማስ ኦንሶ ማኬቦ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","የሱስ ደይ ዎልግሬ ኤካ ይ፦ «ታ ደይ እሳ ማምሱ ንቶትን ማምሱናዋ። ንቶ ደይ ዎልጉትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ዮሀኒስ ሀጵቅፌና ባር ደን ሳማንጝዋ ወደይ አሱኒኪንንሶ?» ");
INSERT INTO jnje_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ባሶትና ባሶትና ኤካ ይት ሜርኬሴቴ፦ « ‹ደን ሳማንዋ› እያንነ፦ ‹ኤኪን አዉኒሮን አማኖ ቤይትሶ?› ኡኒር፥ ");
INSERT INTO jnje_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‹አሱኒክጝዋ› እያንነ ዳራስ ዙቴሬ ዮሀኒስ ራጁ ስኒባሶን አማነሴቴር ስንና ቦርአ እኖትን ሹአክ እቸቴርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ኤስታን፦ «አይን ስንናማቶ ኣነ አሩዌንዋ» ይሬ ዎሉግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","የሱስ ደይ ዎልግሬ፦ «ኤሴ ታ ደይ ሀን ባሮን አሮ ሀእሱኒ ሁግናክ ዛግፋናማቶ ንቶክ ኣፋዋ ማኮና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ቱስሬ ደይ የሱስ ሀን ቤሶሶን ኤካ ይት ዳራሲክ ማኬ፦ «እሳ አሱ ዋይኒን አታክልት ቶኬ ቡልኛን ሜያክ ክራባ ካሶነክ እማት ሾዎ ነያ ኦማ ዳ ሀሜ ዎክ። ");
INSERT INTO jnje_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ጋና ዙቶና ዎና ካርፋና ካባሲክ ጋናሶን ኤጳክ ዎስትኛባስን ቡልኛን ሜያክ ዎሲ። ስኑንታኖ ቡልኛን ሜያ ዎስትኛስን እቸሴሬ ኩሽኩሽ ጋፉክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ሄፕሳክ ደይ ኦም ዎስትኛኒን ዎሲ። ባሪን ደይ እቸሴሬ ኢሽሺሬ ኩሽኩሽ ጋፉክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ኬሳክ ደይ ኦም ዎስትኛኒን ዎሲ። ደይ እቼ ማዛስሬ ጌሮ ክሴሬ ሀእሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ዎይኒስ ፎሽን አባ፦ ‹ኤኪን አዉ ዛጉናሪንሶ? ደይ እሳ ኬሽቴፋና ናታስን ዎሱና። አዉዛክነ ባሪን ድጌሬ ኡልፍንሱሶነቶ› ይ። ");
INSERT INTO jnje_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ስኑንታኖ ቡልኛን ሜያ ናስ ብየቴሴ ባሶትና ባሶትና፦ ‹ፍኦሻስ ሀን ባርኪቱ ካርአናዋ፥ ሀን ያን ዎሩኒዋ፥ ኤስታን ፎሻስ እኖክ ስናናዋ› ይት ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ናስን ዋይኒስ ፎሽን ጌራካሎ ክስሬ ዎርሴቴ። ኤሴ ዋይኒስ አታክልትስ አባ ኤስ ቡልኛን ሜያስታ አዉ ዛጉንር ስንና ቤስቴፋሶ? ");
INSERT INTO jnje_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ዋይኒስ አታክልትስ አባ ዬሬ ኤስ ቡልኛን ሜያኖን ዎሩና፤ ዋይኒን ፎሻኖን ኦምንክ እማና።» አሱኒ ሜያ ኤስ ባሮን ኦደሴቴይሴ፦ «ኤስ ባር ኤካ ስናናታዋ!» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ስኑንታኖ የሱስ ባሶክ ብያት ኤካ ይ፦ «ኤሴ ኬያሶን ኬርእፌ ባሶ ካሽሬ ቤየቴ እኦስ ኬያሲክ ዬቶ ስኒዋ» ይስቴራ ትቼ ባር ኣምባንሶ? ");
INSERT INTO jnje_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ኤስ ዬቶስታ ሄጵቴፌ ባር ፉልርዋ። ባሳስታ ጋንደና ባር ኤስቴር። ");
INSERT INTO jnje_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ሙሴኒ ቱማሲ አስሲኛናዋ ማግኒ ጋኛና ማክቴ ቤሶስ ባሶስታ ስኒባሶን አሪሴፋት ኤስ ካባሲክ ባሪን ኤጳክ ሾልሴቴ። ስኑንታኖ ዳራስ ድጌሴቴ ");
INSERT INTO jnje_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ኤስታን የሱስኒን ኤጶነ ካርኦ ሾልሴት ፌሴቴር። ሀእሲፌ ባሳ ኩሹስናዋ ታቶስ ሀእሱኒ ሁግናሲክና ኣትሬ እሞነክ ችኑኒ ካማ ኖኖባስን ኬስፋን ኤጳክ ኦደት ፌሴቴር። ኤስ ባሪ ቦርኣ ማአ አሱነ ፌር ስንነ ባርኪን ቾዋ ኬጵን ኣፎንን ዎሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ኣፎን ሜያ የሱስኒክ ዬሴሬ ኤካ ይሬ ማሙሴቴ፦ «አስሲኛኖ፥ ነ ፉቶሶን ማኬፋታማቶናዋ አስሲፋታማቶና፤ ሀኦሲ ኡግናኖን ደይ እሳ ኮሩባ ፎንቶኖን አሲፋታማቶ አሪፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ኤሴ ሮማኒ ታቴ ሜኒ ታቶ ኬሳርኒክ ግርቦን እማ ሾልሱጝዋ ኣነንሶ?» ");
INSERT INTO jnje_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ስኑንታኖ ባር ንብቤሲስ ማጙ ሳፋራኖን አሪፋት ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«እሳ ዱደ ታክ ቤሱትዋ! ሀን ባርስታ ፋ ግቶሴዋ ትቻሴ ኦንሪንሶ?» ባሶ ደይ፦ «ኬሳርኒርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","የሱስ ዎልግሬ፦ «ኤሴ ኬሳርኒር ስና ባሮን ኬሳርኒክ እምት። ሀኦሲር ስና ባሮን ሀኦሲክ እምት» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ኤስ ማኬና ካማሲክ ዳራሳ ስናክ ባሪን ኤጳክ ኣነ ችሞቶ። ማኬና ዎልጉሲክ ዲንቀሬ ሻክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ክቱኒ ካቡ ኣፋዋ ይሴፌ እሳ እሳ ሴዱክአውን ሜያ የሱስኒክ ዬሴሬ ኤካ ይት ማሙሴቴ፦ ");
INSERT INTO jnje_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«አስሲኛኖ! ‹እሳር አሱ ኤጴ ናዋ ኮኑኖይ ክትፋናነ አይባስ አሱሶን ኤጴ ክት ባርኪ ዛላ ስኒ ናዋ ኮኑዎ› ይሬ ሙሴ ትችዋ። ");
INSERT INTO jnje_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ኤሴ ናፉን አይና አይና ፌሴቴር። አሪክስ አሱ ኤጴ ናዋ ኮኑኖይ ክት። ");
INSERT INTO jnje_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ሄፕሳስ ደይ ኤስ አሱሶን ኤጴ ኮኑኖይ ክት። ");
INSERT INTO jnje_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ኬሳስ ደይ ኤስ አሱሶን ኤጲ። ናፉኖባሴ ኤሲስማቶ ኤስ አሱሶን ኤጴሬ ናንጎታ ኮኑኖይ ክት። ");
INSERT INTO jnje_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ኮእባስታ ደይ አሱስ ክት። ");
INSERT INTO jnje_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ኤሴ ናፉኖቤሲሴ አሱሶን ኤጴቴ። ክቱኒ ካቡኒ ዎኖ ኦኒ አሱኒሶ ስናናሪ?» ");
INSERT INTO jnje_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","የሱስ ባሶክ ዎልግሬ፦ «ሀን ዳስ ናንጎታ አሱ ኤጴቴር ደይ ግርሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ዮን ዳስታክ ፎክ ክቱኒ ካብሶን ባሶ ኣፋ አሱ ኤጶነ ዉዛ ወደይ ግሩሶነ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ሀኦኒ ዎስያነ ፌር ስኖነ ስንና ቦርአ ኣፋ ክቱሶነ ዉዛ። ክቱኒ ካብሴቴ ቦርአ ባሶ ሀኦኒ ናንጎታዋ። ");
INSERT INTO jnje_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ክቱኒ ካቡኒ ቾዋሲክ ሙሴ ሳባስ ኪቾን ቶቾስ ዳሚስን፦ ‹አብራሀምኒ ሀኦ፥ ይሳቅኒ ሀኦ፥ ያቆብኒ ሀኦ› ይሬ ቴጌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ዙታምቤሲሴ ባርኪ ሀየዉ ስንነቴ ቦርአ ባር ሀየዉን ሜኒ ሀኦታኖ ክቱኒ ሜኒ ሀኦታዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ሙሴኒ ቱማሲ አስሲኛኒ ሜያስን እሳ እሳይስ፦ «አስሲኛኖ፥ ነ ማአሮንቱ ማኬትዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ኤሴን ኦርፎ እሳ አሱኑ የሱስኒን ማምሱክ ኣነ ችሞቶ። ");
INSERT INTO jnje_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ኤስታን የሱስ ባሶክ ኤካ ይ፦ «አሱኒ ሜያ ክርስቶስኒ ኣካኪንሶ፦ ‹ዳዊትኒ ናዋ› ይሴፌይስ? ");
INSERT INTO jnje_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","ዳዊት ቴትባሲክ ጋምን ትቻስ ኤካ ይ፦ « ‹ዳሚስ ዳምታሲክ፤ ጉማኔስኒ ዎቾኔስ ስካሎስ፤ የርአታክ ዛጉናኔን፤ ታ ሆእታስታ ዱዋ› ይዋ። ");
INSERT INTO jnje_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«ኤሴ ዳዊት ዳም ይሬ ቴጌናኔን ኣካክ ክርስቶስ ናዉባ ስኒሪንሶ?» ");
INSERT INTO jnje_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","አሱኒ ሜያ ዙቴሬ ኦደሴፌን የሱስ ናዎባሳክቶኒክ ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«ድቻ ማማ ማየሬ ኩትሴፋት ጋባስታ አሱኒ ሜያ ባሶትን ናጋ ኦሾሶነክ ሾልሴት አይሁድኒ ሺጶኒ ኬያስ ደይ ኡልፍንኒ ኮድታ ዱክ፥ ኮታ ማስቴፋናስታ ኡልፍንኒ ድማ ሾልሴፌ ሙሴኒ ቱማሶን አስሲኛኒ ሜያኪን ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ባሶ ድቻ አሱስ ኬያኖን ሜሬ ቱሩክሱክ አሱ ታን ብዮዋ እያት ሺጶቤሲሶን ድችሴፌ። ኤስ ባሶ አካማ ማጝሱኒ ካርአቱ ኤጴቶሶነዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","የሱስ ኦቱምኒ ሜያ ዋጋ ኬጵቴፋና ሳጥኒስ ዋግቤሲሶን ሀእሴፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ኤሲስማቶ እሳ ቱካማ ድቻ አሱ ሄፕ ዱደ እምድፌን ብያት፦ ");
INSERT INTO jnje_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","«ፉቶ ንቶክ ማኬፋውጙዋ፥ ሀን ቱካማ ድቻ አሱስ ዙታምቤሲሴ አሲ ደናሎ እምዋ። ");
INSERT INTO jnje_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","አሱኒ ሜያ ፋ ዋግቤሲስታን ፉእቴሶንቱ እሜቴ። ስኑንታኖ ሀን አሱስ ባርኪ ፋዪሶን ኮእስራቱ እሚ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","እሳ እሳ አሱኒ ሜያ ቤቴሜቅደሲሲ ኬሹ ኬሹ ሹአክናዋ ሀኦሲክ እምቴ ዋጋ አሲክና ኬሽራ ኬቶባሶን ዎሉምሴት ፌሴቴር። ስኑንታኖ የሱስ ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«ሀን ቢፌት ባር ዙታምባሴ ሹኣስ ሹኣስታ ኮፑክቴራ ኬቴናማቶ ቦክቶና ዎና ዮና።» ");
INSERT INTO jnje_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ባሶ ደይ፦ «አስሲኛኖ! ሀን ባር ኣጌንሶ ስናናሪ? ባር ደይ ስናናክ ቤሶባ ኣምባንሶ?» ይሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","የሱስ ኤካ ይሬ ዎልጊ፦ «ዳጎኖይትማቶ አሩትዋ። ሾዎ አሱኒ ሜያ፦ ‹ታ ክርስቶስዋ፥ ዎናስ ታእ› ይት ታ ሱናሲክ ዮሶነ። ስኑንታኖ ንቶ ባሶክ ዞኑስቶትታ። ");
INSERT INTO jnje_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ኔቦስ ኦዱኖናዋ ዳራሳ ማጙ ዎሉምኒ ሾርኮነ አሲን ኦደፌት ካባሲክ ናዎትታ። ኤስ ባር ዜምማ ስናናክ ሾልሱዋ። ስኑንታኖ ኮእባስ ጌሬጌሬ ኣፋ ስናናዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ቱስሬ የሱስ ኤካ ይ፦ «ዳራ ዳራሳታ፥ ታቶ ታቶስታ ካቡና። ");
INSERT INTO jnje_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","አካማ ዳኒ ሾርኮ ስናና። ዳዳስ ደይ ማክነዋ፥ ሾዎ ቴሳ ሜሮነ ስናና። ደን ሳማን አካማ ዴሱ ቤሶ ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ስኑንታኖ ኤስ ባር ዙታምባሴ ስኒባስኔን ዜምማ አሱኒ ሜያ ንቶትን ኤጶነ ደይ ካቡግሶነ። አይሁድኒ ሺጶ ኬርናዋ ታቶኒ ኬርና ኣትሬ እሞነ። ታ ሱናስ ቦርአ ታቶኒ ሜያክናዋ ዳሶን ሀእሲፌ ባሶክና ታሞነ። ");
INSERT INTO jnje_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ኤስ ባር ደይ ታ ሱናሲክ ዛላ ማኮትክ ማአ ኡግና ስናና። ");
INSERT INTO jnje_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ኤሴ ማሙስቶት ማምሱሲክ ‹አዉ ዎልጉንሪንሶ?› ይራ ዜምማ ሳፋሮኖይትማቶ ንብንትስ ኤጵትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ንቶ ጉማስ ዎልጉክናዋ ሜሮክና ችምኖይና ካምነዋ አሩነ ታ ንቶክ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ንቶትን ኮኒ ባሶናዋ አይንትሳክቶና፥ ኮኒትስናዋ ዞሞንትስና ንቶትን ኣትሬ እሞነ። ንቶስኒ እሳ እሳይስ ዎርቶሶነ። ");
INSERT INTO jnje_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ታ ሱናስ ቦርአ አሱ ዙታምባሴ ንቶትን ኦምቶና። ");
INSERT INTO jnje_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ስኑንታኖ ሶምንትስ ጋነስን እሳርንኑ ኣፋ ትሹና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ችሜ የሮክ ካኒትሶን ፉኦትዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ሜያ ታርኦስ ጉማስ የሩሳሌምኖን ብራቴሬ ኩጶባሶን ቢፌት ካባሲክ ባር ትሹናክ ታባሶን አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ኤስ ካባሲክ ዩዳክ ዳስታክ ፌሴ ባሶ ደን ኣማሲክ ኤሎቶ። ካታማስ ፌ ባሶ ኬሶቶ። ጌራካሎ ፌሴ ባሶ ካታማስ ግርሶኔታ። ");
INSERT INTO jnje_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ትቼራ ፋ ራጂስ ዙታምባሴ ኮኡናክ ሀኒስ ጉማን ካስቶኒ ዎናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ኤስ ካባሲክ ናኔር አሱሲክቶነዋ ናዋ ታንፋ ባርኪቶነ ሀይቡባዉጝዋ! ዳስታክ አካማ ሻና ስናና። ዳራሳታ ደይ ሀኦኒ ግኢአ ዮና። ");
INSERT INTO jnje_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ባሶስኒ ሾዎቤሲስ ሲፎክ ካጭቸሬ ክቱሶነ። ቦጅቸሴሬ ደይ ዳዳስ ሀሞነ። ኤስ አዛብኒ ሜኒ ነያስ ኮኡናኔን የሩሳሌም አዛብኒ የቶና።» ");
INSERT INTO jnje_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ቱስሬ ደይ የሱስ ኤካ ይ፦ «አዋስታ፥ አሳስታናዋ ባኩራስታና ዲንቂ ቤሶ ስናና። ባሪሴዋ አካስ ጉቦነ አሲ ዴሱ ካማሲክና ዳ ዙታምባሴ አሲስታ ፌ ዳራስን ትርኦ ኤጳና። ");
INSERT INTO jnje_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ሳማስታክ ቴስቶኒ ሾርኮታን ካብ ቾዋ አሱኒ ሜያ ሀን ዳስታክ ዮን ዉዛሶን ኦዳክ ድጋክ ሾርኮሶነ። ");
INSERT INTO jnje_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ኤስ ካባሲክ አሱኒ ና አካማ ሁግናክናዋ አካማ ኡልፍናክና ሻሩስታ ዬፌን ብዮነ። ");
INSERT INTO jnje_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ንቶ ደይ ኤስ ዉዛሲክቶ ስናናክ ቴስፋና ካባሲክ ፉእቶኒትስ ታእሴና ቦርአ ደን ካና ቢት።» ");
INSERT INTO jnje_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ቱስሬ ደይ የሱስ ኤካ ይት ሀን ቤሶሶን ማኬ፦ «ቤለስኒ እኦሴዋ ኦማ እኦሲክቶኖና ቢትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ቶሻ ኮትን ቢፌት ካባሲክ ቤጋ ታእሴናማቶ አሩት። ");
INSERT INTO jnje_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ኤሲስማቶ ኤስ ዉዛሲክቶ ስኒን ቢፌት ካባሲክ ሀኦሲ ታቶ ታባሶን አሩት። ");
INSERT INTO jnje_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ፉቶ ንቶክ ማኬፋውጙዋ፥ ኤስ ባር ዙታምባሴ ኮኡናኔን ሀን ኮኒቶስ ኣፋ ኣታና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ሳማሴዋ ዳሴ ኣታና። ስኑንታኖ ካምናስ ኣፋ ኣታና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ንብንትስ ኡሻክ፥ ዛያክ፥ ሀን ዳስታኪ ፎሶን ሳፋሮክ ሆፑኖይናማቶ አሩትዋ። ኤስ ባሮን ሻካትነ ኤስ ዎናስ ደይ ዲንቆ ኤሽምኒማቶቱ ንቶትን ኤጳናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ኤስ ዎናስ ሀን ዳስታክ ፌ አሱ ዙታምባሴ አሲን ኤጳና። ");
INSERT INTO jnje_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ኤስ ባሪ ቦርኣ ዮን ማጙ ዉዛስኒ ኣታትክናዋ አሱኒ ናኒ ስና ደይ የሮክ ችማትክና ዎንና ዎንና ችማ ሺጶትዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","የሱስ ዎንና ዎንና ቤቴሜቅደሲሲ አሲፋፌ ዋል ዋልን ዳብራዛይትኒ ኩማስታ ኬሴ ሀእት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","አሱኒ ሜያ ደይ ባርኪን ኦዶክ ኤሶ ኤሶ ቤቴሜቅደሲሲ ሀሜት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","አይሁድኒ ፋስካ ይስቴፋ ክጣኒ ሄቦስ ዛግቶና ዎና ታአ ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ማግኒ ጋኝኜ ሜናዋ ሙሴኒ ቱማሲ አስሲኛና ዳራስን ድግሴፋት የሱስኒን ኣካክ ዎርሶነማቶ ኡግና ሾልሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ሴጣና አሲሬ ሄፔ ናዎባሳ ጋነስን እሳ አስቆሮትኪ ዩዳ ስኒፌ ባሳስ ግር። ");
INSERT INTO jnje_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ኤስታን ዩዳ ማግኒ ጋኝኜ ሜያክናዋ ቤቴሜቅደሲሲ ታሶን ሜኒ አእስኛኒ ሜያክና ሀሜ የሱስኒን ኣካክ ኣትሬ እማናማቶ ሜርኬ። ");
INSERT INTO jnje_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ባሶ ደይ ቾዉባሲክ ግሬሬ ብር ባርኪ እሞነክ ዉል ግርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ኤስ ዉሊሲክ ማእ ይሬ ኣትሬ እማናክ አሱ ፎንቶ ካርኦ ኦደት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ኤሴን ኦርፎ አይሁድኒ ፋስካኒ ፋንቱ ሹክቶና ክጣኒ ሄቦስ ካርእ። ");
INSERT INTO jnje_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","የሱስ፦ «ፋስካኒ ሜታኡሶን ሙንክ ሀማ ሆሱትዋ» ይሬ ጴጥሮስናዋ ዮሀኒስና አሲን ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ባሶ ደይ ዎልግሬ፦ «አይሁድኒ ፋስካኒ ሜታኡሶን አይ ሆሱኒኪንሶ ሾሌፋ ታሪ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ባር ደይ፦ «ኤክ ካታማስ ግሪፌት ካባሲክ አካኒ ግማ ዎርኦ አሱኒ ዳናት። ኦርፎባሴ ሀምፋት ባር ግርና ኬያስ ግሩት። ");
INSERT INTO jnje_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ኤስታን ኬን አባስኒ፦ ‹አስሲኛስ ናዎባስኔን አነ አይሁድኒ ፋስካኒ ሜታኡሶን ሙና እርባኒ ኬያ አይፋሶ?› ይፌዋ ኡት። ");
INSERT INTO jnje_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","አሱስ እርባኒክ ሆሬራ ድ ኬን ቱክታ ኬቴ ኬያ ቤሱና። ንቶ ደይ ኤስታ ሆሱት።» ");
INSERT INTO jnje_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ኤስ ሄፕ ናዎባስ ደይ ሀሜሬ ዙታምባሴ የሱስ ማኬናሲማቶ ስኒን ዳነሬ ሜታኡሶን ኤስታ ሆስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ሜታኡን ሳአትስ ካርፋና ካባሲክ የሱስ ዎስባሳክቶኔን ሙናክ ካሳየሬ ድ። ");
INSERT INTO jnje_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","የሱስ ባሶክ ኤካ ይ፦ «ታይስታ ካርን ሻናሶን ኤጳቶናስኔን ዜምማ ሀን ሜታኡሶን ንቶኔን ሙናክ አካማኖን ሾሌቱ ፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ንቶክ ማኬፋውጙዋ፥ ሀኦሲ ታቶስ ሀን ባር ኣቾ ቾዋሲ ኮኡናኔን ሀን ፋስካኒ ሜታኡሶን ሄፕስ ኣፋ ሙና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ኤስታን ኡሻሶን ቶፎባሴ ኤጴ ሀኦ ጋላቴፋት፦ «ኤሴዋ፥ ዙታምንትሴ ሀን ባሮን ሃኤራ ኡሽትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ንቶክ ማኬፋውጙዋ፥ ሀሽኔን ካብራ ሀኦሲ ታቶ ዮናኔን ሀን ዋይኒስ ኡሻኖን ኣፋዋ ኡሻናዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ቱሻሶን ደይ ኤጴ ሀኦ ጋላቴፋት ባቴ እሜት፦ «ኤሴዋ፥ ሀን ባር ንቶክ እምቶኒ አሽናስዋ። ሀን ባሮን ታን ሳፋሮንር ዛጉትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ሜታኡኔን ኦርፎ ደይ ኡሻሶን ቶፎባሴ ኤጴ፦ «ሀን ኡሻት ባር ታ ንቶክ ዉኩና አሪናስንነ ፋርዋ። ባር ደይ ንቶትን ሀኦኔን አነ ጋንሱኒ ጋድዶ ቴያዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«ስኑንታኖ ታን ኣትሬ እምን አሱሳ ኩሹ ሀን ማዲስታ ታኔንቱ ፋዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","አሱኒ ና ዜምማ ሀኦሲ ካምስ ማክቴራ ኩናሲማቶ ክቱኒር። ስኑንታኖ ባሪን ክቱክ ኣትሬ እምን ባር ሀይቡባዎዋ!» ");
INSERT INTO jnje_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ናዎባሳክቶ ደይ፦ «እንኖ ጋነያስ ሀን ኤፋቴና ዉዛሶን ዛጉኒስ ኦንሶ?» ይሴት ባሶትና ባሶትና ማሙሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ቱስሬ ናዎባሳክቶ ደይ፦ «እንኖ ጋነያስን አሪክር ኦንሶ?» ይት ባሶትና ባሶትና ዌንሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","የሱስ ባሶክ ኤካ ይ፦ «ሀን ዳስ ታቶኒ ሜያ ዳራቤሲሳታ ሀእሱኒ ሁግናቤስ ፋርዋ። ሀእሲፌ ባሶ ደይ ማአሮን ዛግር ይስቴሬቱ ቴግቴሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ስኑንታኖ ንቶ ኤካ ዛጉትታዋ። ንቶስኒ አሪክስ ሀቴር፥ ደይ ሀእሲፌ ባር ዎስትኛነ ፌር ስኖዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ሙክ ሙናክ ታእሴሬ ፌ ባርናዋ የሬፋት ዎሽፌ ባርና አሲስኒ ኦንሶ አሪክሪ? ሙ ሙናክ ታእሴሬ ፌ ባርቴኖሶ? ስኑንታኖ ታ ንቶ ጋነያስ እሳ ዎስትኛነ ፋናርዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ንቶ ታን ሻና ኤጵፋና ካባሲክ ችማ ታኔን የሬትዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","አባታስ ታን ታስናስማቶ ታ ደይ ንቶትን ታሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ታቶናስ ታ ማዲስታን ሙት ደይ ኡሻት። ክናዎስታ ዲፋት አሲሬ ሄፔ እስራኤልኒ ዛላስታ ማጝሱ ካርአትዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ቱስሬ ደይ የሱስ ኤካ ይ፦ «ስሞኖ! ስሞኖ! ሴጣና ንቶትን ዛጎ ስአነ ስአናክ ማምሲዋ። ");
INSERT INTO jnje_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ስኑንታኖ አማንቶኔስ ትሹኖይናማቶ ኔክዋ እያት ሀኦ ሺጴን። ነ ታክ ዎልፋ ታ ካባሲክ አይኔሳክቶኒ ችኑዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ስሞን ዎልግሬ፦ «ዳሚሶ፥ ታ ታቶኒ ኬር ግሩክ፥ ክቱክ ነኔን አነ ሆሬራቱ ፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ስኑንታኖ የሱስ፦ «ጴጥሮስ ሀሽ ሀውጙ አኮ ኦሩኖይፌን ኬዛ ዎላ ታን ሞርሞታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ኤስታን የሱስ ናዎባሳክቶኒን፦ «ዋግን ካርድድ፥ ሀማቶ፥ ቻማ ኤጵኖይትሮን ንቶትን ዎስና ካባሲክ ዮእ ዉዛ ፋሮሶ?» ይ። ባሶ ደይ፦ «እሳንነ ዮእ ዉዛ ኣፋዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","የሱስ ባሶክ ኤካ ይ፦ «ኤሴ ሀሽ ዋግን ካርድድነዋ ሀማቶነ ፋና ባር ኤጶዋ። ሲፎባ ፎንቶስ ማይባሶን ክስሬ ዋጌሬ ሲፎ ዋጎዎ። ");
INSERT INTO jnje_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ንቶክ ማኬፋውጙዋ፥ ታ ቾዋሲክ ዜምማ ትቻስ፦ ‹ማጙኒ ሜያኔን ፋድቴዋ› ይስቴ ባር ኮኡናክ ሾልሱዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ናዎባሳክቶ ደይ፦ «ዳሚሶ፥ ሀንታክ ሄፕ ሲፎ ፋርዋ» ይሴቴ። ባር ደይ፦ «ሆሮናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","የሱስ ኦማ ዎኖት ዛግፌናሲማቶ ዳብራዛይትኒ ኩማስታ ሀሚ። ናዎባሳክቶ ደይ አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ኤስታ ካርኤፌ ካባሲክ፦ «ፋታናስ ግሩኖይትማቶ ሀኦ ሺጶትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ባሶስታን ሹአ ሀቴራ ካርፋናስንነ ፋ ድማ ዎኬ ሀሜ ካአነሬ ኤካ ይት ሺጴ፦ ");
INSERT INTO jnje_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«አባታሶ! ሹንፋታነ ሀን ታ ኤጳቶናክ ፋ ሻናን ቶፎሶን ታይስታን ሻልዋ። ኤስ ባር ደይ ነ ሹንታስማቶ ስኑንታኖ ታ ሹናስማቶታ።» ");
INSERT INTO jnje_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ኤስታን ሀኦሲ ዎስያ ደይ ሳማን ያራ ባሪን ችኒ። ");
INSERT INTO jnje_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ኤስ ካባሲክ አካማኖን ትርኦ ባሪን ኤጳን ሺጴት ፌር። ቻዎባስ ደይ ሀሪኒማቶ ዳስታክ ቶክት ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ሺጶታን ካብሬ ናዎባሲክ ዎል ሌ የ። ባሶ ደይ ሱሞታን ካብ ቾዋ ኩነፌን ዳንነ ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«አዋጋን ኩንትሪንሶ? ፋታናስ ግሩኖይትማቶ ካብራ ሺጶትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","የሱስ ኤስ ባሮ ማኬፌን አሲሬ ሄፔ ናዎባሳስን እሳ ዩዳ ስኒፌ ባር ሾዎ አሱኒ ዞንስሬ ዬሬ ካርእ። ዩዳ ደይ የሱስኒን ዳሞክ ታእሴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ስኑንታኖ የሱስ፦ «ዩዳኖ! አሱኒ ናኒ ዳሞክኖሶ ኣትራ እማታሪ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","የሱስኔን አነ ፌ ናዎኒ ሜያ ኤስ ቾዋሶን ብያት፦ «ዳሚሶ! ሲፎክ ካጮኒሮሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ባሶስኒ እሳይስ ማግኒ ጋኝኜ ሜኒ ጋኛን ዎስትኛአሳ ሆእታ ኦዶኖን ካጨ። ");
INSERT INTO jnje_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ስኑንታኖ የሱስ፦ «ቤይዋ! ሄፕሳ ኤፋቴና ዉዛ ዛጉታታዋ» እያት አሱሳ ኦዶኖን ታእሬ ፋቲ። ");
INSERT INTO jnje_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ኤስታን የሱስ ባሪን ኤጳክ ዬሴ ማግኒ ጋኝኜ ሜያኖን፥ ቤቴሜቅደሲሲ ታሶን ሜያኖን ሀእሲፌ ባሶናዋ ኩርኡኒ ሜያኖና ኤካ ይ፦ «ቦእኛኒ ኤጵን አሱኒማቶ ሲፎነዋ ሙክነ ኤጳ ያሴትዮሶ? ");
INSERT INTO jnje_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ዎንና ዎንና ቤቴሜቅደሲሲ ንቶኔን አነ ፋና ካባሲክ ኣነ ኤጶዌት። ሀየ ሀን ባር ንቶትናዋ ታልማስ ሀእሱነ አሲ ዎናዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ኤስታን የሱስኒን ኤጳ አሱኒ ሜያ ማግኒ ጋኝኜ ሜኒ ጋኛአሳ ኦጅን ኬርካሎ ታሜቴ። ጴጥሮስ ደይ ዎክሶክ ባርኔን አነ ሀሚድፌር። ");
INSERT INTO jnje_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","አሱኒ ሜያ ማጊሳ ኦጅን ኬርካሎ ጌያ ሶኬሬ እሳሪክ ዲፋት ቤስሴድፌር። ጴጥሮስ ደይ ባሶ ጋነያስ ጌኒ ቤሱክ ድ። ");
INSERT INTO jnje_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","እሳ ኬር ዎስትኛ ጴጥሮስ ጌኒ ድያ ዲፌን ጋሳሲራ ብያት፦ «ሀን አሱስ የሱስኔን አነ ፌርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ስኑንታኖ ጴጥሮስ፦ «ነ ሀን አሱሴ! ማኬፋታ ባሪን ኣነ አሪፋትዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ጋሮኖ ፌሬ እሳ አሱ ደይ ቢሬ፦ «ነ ባሶስኒ እሳይስዋ» ይ። ጴጥሮስ፦ «ነ ሀን አሱሶ! ታቴዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ጋሮ ዎናኔን ኦርፎ ኦም አሱ ደይ ጴጥሮስኒ ብያት፦ «ፉቶክ ሀን አሱ ጋሊላክር ስንና ቦርአ ባርኔን አነ ፌርዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ስኑንታኖ ጴጥሮስ፦ «ነ ሀን አሱሶ! ማኬፋታ ባሮን ታ ኣነ አሪፋትዋ።» ኤስ ባሮን ማኬሬ ኮእሱኖይፌን ጌሬጌሬ አኮ ኦር። ");
INSERT INTO jnje_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ኤስ ካባሲክ የሱስ የርቀሬ ጴጥሮስኒን ቢ። ጴጥሮስ፦ «ሀሽ ሀውጙ አኮ ኦሩኖይፌን ኬዛ ዎላ ታን ሞርሞታዋ» ይሬ ዳሚስ ማኬና ካማሶን ያዳቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ኤክ ጌራካሎ ኬሴ አካማኖን ሱሜሬ ዋሲ። ");
INSERT INTO jnje_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ኤስ ካባሲክ የሱስኒን ኤጳት ፌ አሱኒ ሜያ ባሪን ካኘሬ እቸሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ኣፋሶን ኡካት፦ «ኦንሶ ኔን እቻሪ? ራጁ ስኒፋታነ አሪቦ?» ይት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ሾዎ ዉዛ ማኬት ሜኤት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ዎኒፋና ካባሲክ ዳራሳ ኩርኡኒ ሜያ፥ ማግኒ ጋኝኜ ሜናዋ ሙሴኒ ቱማሲ አስሲኛና ዙቴሴቴ። ኤስታን የሱስኒን ኤስ ባሶ ኩጳማስታ ታእስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ኤካ ደይ ይሴቴ፦ «ነ ክርስቶስኖሶ? እኖክ ማኬቦ።» የሱስ ዎልግሬ ኤካ ይ፦ «ማኬፋናክ ኣነ አማነፌት። ");
INSERT INTO jnje_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ማምሲፋናክ ኣነ ዎልግፌት። ");
INSERT INTO jnje_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ስኑንታኖ ሀውጙኔን ካብራ አሱኒ ና ሀኦሲ ሁግናን ሆእታ ኡልፍንቶ ድማስታ ዱኒርዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ኤስ ካባሲክ ዙቴሴሬ፦ «ኤኪን ነ ሀኦኒ ናኖሶ?» ይሴቴ። ባር ደይ፦ «ኣ፥ ስንናሶን ንቶኑ ማክሴትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ባሶ ደይ፦ «ሀንኔን ኤካሎ ኦም ዛል ኣነ ሾልስፌዋ። እንኖኑ ባሳ ኖኖስን ኦደኒዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ኤስታ ፌ አሱኒ ሜያ ዙቴሴሬ ካብ የሱስኒን ኤጴሬ ፕላቶስኒክ ታሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ኤካ ይት ባሪን ማላቴሴቴ፦ «ሀን አሱስ ዳራኒስን ኤሽፌን፥ ኬሳርኒክ ግርቦ ግርብቶኖይናማቶ ካልፌን ደይ፦ ‹ታ ክርስቶስ ታቶዋ› ይፌን ዳኒ።» ");
INSERT INTO jnje_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ፕላቶስ፦ «ነ አይሁድኒ ታቶኖሶ?» ይሬ ማምሲ። የሱስ ደይ፦ «ነ ይታስማቶዋ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ኤስታን ፕላቶስ ማግኒ ጋኛንክናዋ ዳራሲክና ኤካ ይ፦ «ታ ሀን አሱሳታን እሳ ማጝሱነ ኣነ ዳኑትዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ስኑንታኖ ባሶ፦ «ሀን አሱስ ጋሊላን ካብራ ሀንታ ካርአናኔን፥ ዩዳክ ዳ ዙታምባሴ አሲስ ዳራስን ማጙክ ካብግት ፌርዋ» ይሴት ችኒሬ ማላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ፕላቶስ ጋሊላን ይስቴ ባሮን ኦድናይሴ፦ «ሀን ባር ጋሊላክ አሱኖሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","የሱስ ሄሮድስኒ ሀእሱሲኒ ዬር ስኒባሶን ፕላቶስ አራት ሄሮድስኒክ ዎሲ። ኤስ ካባሲክ ሄሮድስ የሩሳሌም ዬሬ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ሄሮድስ የሱስኒን ብያናክ ሾዎ ዎና ሾሌት ፌር ስንና ቦርአ ቢናይሴ አካማኖን ግሬ። የሱስ ዛግት ፌፌና ቢስቴራ አሪቶኖይ ዉዛሶን ዎስቴን ብያናክ ሾሌት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ኤስ ባሪ ቦርኣ የሱስኒን ሾዎ ማምሱ ማምሲ። ስኑንታኖ የሱስ እሳንነ ኣነ ዎልጉዌ። ");
INSERT INTO jnje_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ማግኒ ጋኝኜ ሜናዋ ሙሴኒ ቱማሲ አስሲኛና ችኒሬ ማላቴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ሄሮድስ ሜያ ታርኦባስኔን አነ የሱስኒ ካሽሬ ካኘ ኬሹ ማማ ማይስሬ ዎልግሬ ፕላቶስኒክ ጋፍኪ። ");
INSERT INTO jnje_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ሄሮድስናዋ ፕላቶስና ዜምሜ ፋሴሬ ፌይስ ኤስ ዎኖ ጋነሬ ዞሞ ስንነቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ኤስታን ፕላቶስ ማግኒ ጋኛንን፥ ዳራስን ሀእሲፌ ባሶትናዋ ዳራስና እሳሪክ ዙትሬ ቴጌ። ");
INSERT INTO jnje_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ኤካ ደይ ይ፦ « ‹ሀን አሱ ዳራስን ማጙ ኡግናክ ዞንስዋ› ይራ ታክ ቴሸት። ታ ንቶ ስናክ ቱንራ ንቶ ማኬት ማላታስኒ እሳ ማጝሱ ባሳስታን ኣነ ዳኑት። ");
INSERT INTO jnje_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ኤሲስማቶ ሄሮድስ ደይ እሳ ማጝሱ ኣነ ዳንነ ስንና ቦርአ እኖክ ዎልግሬ ጋፍኪ። ኤሴ ሀን አሱስን ክቱታ ካቱኒ ማጝሱ ኣነ ዛጉዌ። ");
INSERT INTO jnje_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ኤስ ባሪ ቦርኣ ባክ እቻ ኮታናዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ፕላቶስ ሄቦ ሄቦስ ዎናክ እሳ ታቶኒን ባሶክ ኮታር። ");
INSERT INTO jnje_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ኤስታን ዳራ ዙቴሬ እሳሪክ፦ «ሀን አሱስን ትሽካት ባርባንን እኖክ ኮትዋ» ይት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ባርባን ካታማስ ፌ ዳራስን ማጙክ ካብጉባሲክናዋ ካ ዎሩባሲክና ታቴሬ ፌ አሱ። ");
INSERT INTO jnje_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ፕላቶስ የሱስኒን ኮታናክ ሾሌፋት ሄፕሳ ዳራስን ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ስኑንታኖ ዳራስ፦ «ሱትዋ! ሱትዋ!» ይት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ፕላቶስ ኬዝሳ ዎልግሬ፦ «ሀን አሱ ዎስቴና ማጝሱ ኣምባንሶ? ታ ባሪን ክቱታ ካቱኒ ማጝሱ ኣነ ዳኑት ስንና ቦርአ እቻ ኮታናዋ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ስኑንታኖ ባሶ ካምቤሲሶን ቴግሬ፦ «ሱትዋ» ይሴቴ። ባሶ ቻጋስ ደይ ኣታም። ");
INSERT INTO jnje_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ኤስ ባሪ ቦርኣ ፕላቶስ ሾልሴቴሶን ዛግሶነክ ባሶክ ኣትሬ እሚ። ");
INSERT INTO jnje_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ዳራስ ማጙክ ካብግሬናዋ ካ ዎርሬና ታቴሬ ፌ ባርባንን ኮታናክ ማሙሴቴ። ኤስ አሱስን ደይ ባሶክ ኮታት የሱስኒን ሾልሴቴሶን ዛግሶነክ ኣትሬ እሚ። ");
INSERT INTO jnje_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","የሱስኒን ኤጴ ሀሜፌን ኬሬናክ አሱ ስሞን ይስቴ ኡጉንኒ ዎፍ ባላጋርን ካታማ ዬፌን ዳነሬ ሜስቀሊሶን ዎስሬ ባሳ ኦርፎሴ ሀማናክ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ሾዎ ዳራ ደይ የሱስኒ ኦርፎሴ ሀሜድፌር። ኤስ ባሶስኒ ንቤሲሶን ክኤት፥ ዋሴት ፋ ማሽካሱ ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ስኑንታኖ የሱስ ባሶክ የርቀሬ ኤካ ይ፦ «ንቶ የሩሳሌምክ ማሽካሱሴ፥ ንቶ ቴታሲክናዋ ናንጎትኒትሲክና ዋሱትታኖ ታክ ዋሱትታ። ");
INSERT INTO jnje_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ኤሴ፦ ‹ዛግያስ፥ ኮኑኖይ ማጋሴዋ ታኑኖይ ታማሴ ሱስቶ› ኡስቶና ዎና ዮና። ");
INSERT INTO jnje_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ኤስ ካባሲክ አሱኒ ሜያ ኣማሶን፦ ‹እኖስታ ጋንዶዌ› ኩማሶን ደይ፦ ‹እኖትን ኣቹዌ› ኡክ ካቦሶነ ");
INSERT INTO jnje_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ኤሴ ሀን ባሮን ኬዋ እኦስታ ኤካ ዛግቴናኔን እችማስታ አዉ ዛግሶንኮሶ?» ");
INSERT INTO jnje_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ኤሲስማቶ ማጙ ዎስቶ ዎስቴ ሄፕ አሱኒን ደይ የሱስኔን አነ ዎሩክ ኤጴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ኬራንዮ ይስቴ ድማስታ ካርኤቴሴ የሱስኒን ኤስታ ሱቴቴ። ደይ ማጙ ዎስቶ ዎስቴ አሱሳክቶኒን እሳይስን ሆእታስታ፥ ሄፕሳስኒ አልዳስታክ ሱቴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ኤሴን ኦርፎ የሱስ፦ «አባታሶ፥ ዛግሴፌ ባሮን ኣነ አሪሶቶ ስንና ቦርአ ፌሹን ኡዋ» ይ። ሜያ ታርኦን ሜያ ደይ ማይባስታ እጣ ሀሴሬ ሃኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ኤስ ካባሲክ ዳራስ የሬፋ ቢድፌር። ዳራስን ሀእሲፌ ባሶ፦ «ኦሚስን ፉኤ፥ ሀኦ ባሪን ኮርና ክርስቶስ ስንፋናነ ቴትባሶን ፉኤን ብያንዋ» ይት ካኘሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ሜያ ታርኦሳክቶ ደይ ኤሲስማቶ ካኘሴቴ። ባርኪ ታእሴሬ ሱቃሮ ዋይኒን ኡሻ እሜት፦ ");
INSERT INTO jnje_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ኤሲስማቶ ደይ፦ «ነ አይሁድኒ ታቶ ስኒፋታነ ቴትኔሶን ፉኦዋ» ይሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ሱቴና ሜስቀሊስ ቴታ፦ «ሀኒስ አይሁድኒ ታቶዋ» ይፋ ትቻ ትችሬ ዬትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ማጙ ዎስቶ ዎስቴሬ ሱቴ ባሶስኒ እሳይስ የሱስኒን፦ «ነ ክርስቶስቴኖሶ? ኤሴ ቴትኔሶናዋ እኖትና ፉኦዋ» ይት ሜእ። ");
INSERT INTO jnje_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ስኑንታኖ ሄፕሳስ ዎልግሬ ኤካ ይት ኬእ፦ «ነይስታ ክቱኒ ማጝሱ ካቴራ ፌን ሀኦሶን ኣነ ድጌፌኖሶ? ");
INSERT INTO jnje_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","እንኖ ዛግን ማጝሱሲክ ሾልሱ ኬኦ ኤጳ ታድፌኒር። ስኑንታኖ ሀን አሱስ እሳ ማጝሱ ኣነ ማጝሱዌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ቱስሬ የሱስኒን፦ «ዳሚሶ! ታቶ ስንና ያፋታ ካባሲክ ታን ሳፋሮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","የሱስ ዎልግሬ፦ «ኔክ ፉቶ ማኬፋውጙዋ፥ ሀሽ ሀውጙ ታኔን አነ ገነቲ ፎታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ኤስ ካባሲክ ዎናስ እሱን ሳአትን ካብራ እዝግን ካርአናኔን ዳስ ዙቴራ ታልሜ። ");
INSERT INTO jnje_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","አዋስ ታልሜ፤ ቤቴሜቅደሲሲ ይኑ ሄፕክ ካራቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","የሱስ አካማ ቴጋ ካማክ ቻጌ፦ «አባታሶ! ካናሶን ነ ኩሹስ አዳራክ እምጝዋ» ይ። ኤስ ካባሲክ ጌሬጌሬ ካባስ ኬስ። ");
INSERT INTO jnje_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ት ሜያ ታርኦን ጋኝኛስ ስና ቾዋሶን ቢናይሴ፦ «ሀን አሱስ ፉቶክ ኦኮዋ» ይት ሀኦሶን ጋላቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ኤስ ባሮን ብያክ ኤስታ ዙቴሬ ፌ አሱስ ስና ቾዋሶን ዙትሬ ብየቴሴ ንቤሲሶን ክኤት ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","የሱስኒን ታእሶኖን አሪሴፌ ባሶናዋ ጋሊላን ካብሴሬ ባሳ ኦርፎሴ ሀማ ማሽካሱሴ ዙቴሬ ዎክሶክ የርሴፋት ስኒፋ ዉዛሶን ብየት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","አይሁድኒ ሾ ዙቴሴፌ ባሶስኒ እሳ ዮሴፍ ይስቴ ማአ ኦኮ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ኤስ አሱስ የሱስኒስታ ዛግቴ ክቱኒ ማጝሱኒ ካርን ቾዋሲ ኣነ ግሩዌ። ባር ደይ አሪማትያስ ይስቴፋ ዩዳኒ ካታማስ ሀኦሲ ታቶኒ ዮኖን አብድክ ኦደት ፌር። ");
INSERT INTO jnje_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ፕላቶስኒክ ሀሜ የሱስኒ ዱግኖሶን እማናክ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ኤስታን ዱግኖሶን ኬስሬ ማማ ኪምሜ ሹአክ ካቴራ ሆሬ ኦኑ ካባርቶኖይና ሞግሲ ካባሬ። ");
INSERT INTO jnje_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ኤስ ባሮን ዛግናስ ቤይሳኒ ዎን ኒ ሆሮኒ ዎናሲክ። ");
INSERT INTO jnje_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ጋሊላን ካብሴራ የሱስኒ ኦርፎሴ ያ ማሽካሱሲክቶ ዮሴፍኔን ሀሜራ ሞጋሶን ብየ። ዱግኖባስ ደይ ኣካ ካባርቴናማቶ ብየቴ። ");
INSERT INTO jnje_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ኤስታን ኬቤስ ዎልሴሬ ዱግኖሶን ዎሹክ ክማምነዋ ሽቶነ ሆስሴቴ። ቱማስማቶ ቤይሳኒ ዎናሲክ ቤይሳ ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ጉድዳኒ ዎኖ ዎኒሳ ዋሲሴ ማሽካ ሜያ ሆስሴቴ ሽቶሶን ኤጴሬ ኤክ ሞጋሲክ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ሞጋስታ ኡክቴራ ኩን ሹኣስ ቡካለራ ኩንፌን ዳነቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ስኑንታኖ ሞጋስ ሞግሬ ብየቴን የሱስኒ ዱግኖሶን ኣነ ዳኖቶ። ");
INSERT INTO jnje_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ሀን ባር ኣምባንሶ እያት ዲንቀሴፌን አካማኖን ፓልፓሉ ቻሬት የሬ ማያ ማዮ ሄፕ አሱ ባሶ ቴሻ የሬ። ");
INSERT INTO jnje_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ማሽካ ሜያ ድግሴፋት ዳስ ብየፌን አሱሳክቶ ባሶክ ኤካ ይ፦ «ሀየዉ ስና ባሪን አዉኒሮን ክቱኒ ሜኒ ጋነያስን ሾሌድፌትርን? ");
INSERT INTO jnje_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ባር ካብ! ሀንታክ ኣፌ። ጋሊላክ ፌና ካባሲክ አዉ ማኬናማቶ ያዳቶት። ");
INSERT INTO jnje_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹አሱኒ ና ቦርን ሜኒ ኩሹስ አቴሬ እምቶናክ፥ ሱቶናክናዋ ኬስናር ዎኖ ክቱኒ ካቡናክና ሾልሱ› ይሬ ማኬናር ፋር።» ");
INSERT INTO jnje_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ማሽካ ሜያ ደይ የሱስ ማኬና ካማሶን ያዳቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ሞጋስ ኤስታን ዎልሴሬ ብየቴ ባሮን ዙትሬ አሲሬ እሴ ናዎባሲክናዋ ኦም ሜያክና ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ኤስ ባሮን ዎስኒ ሜያክ ማክሴስ ሜግደላዊትኪ ማራሚ፥ ዮሀናነዋ ያቆብና አሲ እንቶ ማራሚ፥ ደይ ኦማ ማሽካ ሜያ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ስኑንታኖ ባሶ ማሽካ ሜያ ማክሴቴ ባር ሚቶነ ፋር ስንና ቤስቴና ቦርአ ኣነ አማንቶሶቶ። ");
INSERT INTO jnje_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ስኑንታኖ ጴጥሮስ ካብ ሞጋሲክ ኤሊ። ኤስታ ካርፋት ስር ሞግሬ ቢን ሴሳ ክኖን ማማስ ባር ባር ኩንፌን ብያት ዲንቀት ዎል ሌ ኬር የ። ");
INSERT INTO jnje_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ኤስ ዎኖ ናዎኒ ሜያስን ሄፕ አሱ ካብሬ የሩሳለሙን አሲሬ ሄፔ ኪሎ ሜትር ዎክባ ፋና ሄማዎስ ይስቴ ኬኤስ ሀሜድፌር። ");
INSERT INTO jnje_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ባሶ ደይ ስና ቾዋሶን ዙታምባሴ ካብግሬ ዎሉምሴድፌር። ");
INSERT INTO jnje_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ኤስ ቾዋሶን ሳፋሬትናዋ ዎል ሌትና ፌሴቴን የሱስ ታእሴሬ ባሶኔን ሀሚድፌር። ");
INSERT INTO jnje_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ስኑንታኖ ኣፍቤሲሲክ ብየፌት ባር ኦ ስንናማቶ ኣነ አሪሶቶ። ");
INSERT INTO jnje_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","የሱስ ደይ፦ «ኡጉነ ሀምፋት ንቶትና ንቶትና ዎል ሌፌት ዉዛስ ኣምባንሶ?» ይ። ባሶ ደይ ሱሜሬ ሻክሬ የሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ባሶስኒ እሳ ኬለዮጳ ይስቴፌ አሱስ ኤካ ይ፦ «ሀጝነታክ ዎናስ ሀን የሩሳለሙክ ስና ቾዋሶን አሩኖይ አሱ ነነቱ እርባዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ባር ደይ፦ «ስና ቾዋሲ ኣምባንሶ?» ይ። ባሶ ደይ ኤካ ይሴቴ፦ «ናዝሬትክ የሱስኒስታ ዛግቴ ባርዋ። ባር ሀኦነዋ አሱ ዙታምባሴ አሲ ስናና ዎስቶክናዋ ካማክና ችም ራጁዋ። ");
INSERT INTO jnje_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ባሪን ማግኒ ጋኛናዋ እኖትን ሀእሲፌ ባሶትና ክቱኒ ማጝሱ ካርኤ ኣትሬ እሜሬ ሱቴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ስኑንታኖ እንኖ እስራኤልኖን ፉሮንርዋ ይራ አብድ ዛግኒስ ባርጝዋ። ኤስ ባር ስንናኔን ሀውጙ ኬዝ ዎናዋ። ");
INSERT INTO jnje_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","እንኖ ጋነያስን እሳ እሳ ማሽካ ሜያ እኖትን ዲንቅሴቴዋ። ባሶ ዎኒሳ ዋሲ ኤክ ሞጋሲክ ሀሜሬ ዱግኖባሶን ቱሩክሴቴ። ዎልሴሬ ባር ሀየዉ ስኒባሶን ማኬ ሀኦኒ ዎስኒ ካማ ኦደሴናማቶ እኖክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","እንኖ ጋነያስን እሳ እሳ ሜያ ኤክ ሞጋሲክ ሀሜ ኤስ ማሽካ ሜያ ማክሴቴስማቶ ስኒን ብየቴ። ስኑንታኖ የሱስኒን ኣነ ብዮቶ።» ");
INSERT INTO jnje_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","የሱስ ደይ ባሶክ፦ «ንቶ ያዳቶኖርናዋ ራጁኒ ሜያ ማክሴቴ ባሮን አማኖክ ንብንትስ ታፕቶኖር። ");
INSERT INTO jnje_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ክርስቶስ ሀን ሻናሶን ኤጴቶናክናዋ ደን ኡልፍንባሲክ ግሩናክ ኣነ ሾልስፋኖ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ኤስታን ሙሴኒ ቱማሲናዋ ራጁኒ ሜኒ ትቻስና ካብግሬ ባርኪ ትቼ ባሮን ኮርቶ ትቻ ዙታምባሴ አሲስኒ ክሳፌ አሲ። ");
INSERT INTO jnje_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ባሶ ሀሜፌ ኬኤስ ታእሴሴፌ ካባሲክ የሱስ አቴ ሀሚንነ ፌር ስንነ ባሶክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ስኑንታኖ ባሶ፦ «ጌሮክ ዋል፥ አዋስ ደይ ግሪድፋር ስንና ቦርአ እኖኔን ሀኡዋ» ይት ችኒሬ ሺጵሴቴ። ባር ደይ ባሶኔን ሀኡክ ኬር ግር። ");
INSERT INTO jnje_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ባሶኔን አነ ሙክ ድ። ቱሻሶን ደይ ኤጴ ጋላቴፋት ባቴ እሚ። ");
INSERT INTO jnje_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ኤስ ካባሲክ ኣፌሲስ ጋቼን የሱስ ስኒባሶን አሪሴቴ። ስኑንታኖ ባር ባሶ ስናን ትሽ። ");
INSERT INTO jnje_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ባሶትና ባሶትና ደይ፦ «ኡግናስታ ፋኒ እኖትን ዎሉምስት ካይማ ትቻስኒ ክሳፌ ማኬን ንብኒሶን ጌኒማቶ ማታኖሶ?» ይሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ኤስ ካባሲክ ካብሴሬ የሩሳሌም ዎል ሌ ሀሜቴ። ኤስታክ አሲሬ እሴ ናዎባስናዋ ባሶኔን ፌሴ ባሶትና አሲን እሳሪክ ዙቴሬ ፌሴቴን ዳነቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ባሶ ደይ፦ «ዳሚስ ፉቶክ ካብዋ! ስሞንክኑ ቤስቴዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ኤስ ሄፕ ናዎኒ ሜያ ኡግናስታ ስና ባሬዋ የሱስ ቱሻሶን ባትፌና ካባሲክ ኣካክ አሪሴቴማቶና ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ኤስ ባሮን ዎሉምሴፌን የሱስ ባር ጋነቤሲስ የሬፋት፦ «ናጋ ንቶክ ስንፋውጝ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ስኑንታኖ ባሶ ናየሬ ክታ ብየቴነ ፋር ስኒፋን ድጋክ ቱሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","የሱስ ደይ ኤካ ይ፦ «አዉኒሮን ናየድፌትሪንሶ? አዋጋን ንብንትስ ማሜፋሶ? ");
INSERT INTO jnje_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ኩሹናሴዋ ዎቾናሴ አሲን ቢት። ታፕትራ ታ ስንናሶን አሩት። ታን ቢፌትስማቶ ክታስ አሽነዋ ሜጋነ ባርኪ ኣፋዋ።» ");
INSERT INTO jnje_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ኤስ ባሮን ማኬፋት ኩሹባሴዋ ዎቾባሴ አሲን ባሶክ ቤስ። ");
INSERT INTO jnje_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ባሶ ደይ ግራክናዋ ዲንቆክና ቱሜፋት ባር ስኒባሶን ኣነ አማኖሶቶ። የሱስ ደይ ኤካ ይ፦ «እሳ ማስቶኒ ዉዛ ፋሮሶ?» ይሬ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ባሶ ደይ ኪቾ ኩርጡምሚ እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ባር ደይ ኤጴ ባሶ ስናክ ሜ። ");
INSERT INTO jnje_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","የሱስ ኤካ ደይ ይ፦ «ንቶኔን አነ ፋና ካባሲክ ሙሴኒ ቱማሲ ራጁኒ ሜኒ ትቻስናዋ ጋምን ትቻስና ታክ ትቼ ባር ዙቴራ ኮኡናክ ሾልሱ ይራ ንቶክ ማኬናስ ሀኒስዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ኤስ ካባሲክ ኮርቶ ትቻሶን ያዳትሶነክ ንቤሲሶን ጋች። ");
INSERT INTO jnje_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ኤካ ደይ ይ፦ «ክርስቶስ ሻና ኤጴቶናማቶናዋ ኬዝስናር ዎኖ ደይ ክቱኒ ካቡናማቶና ዜምማ ትቼራ ፋር። ");
INSERT INTO jnje_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ኤሲስማቶ ደይ የሩሳለሙን ካብራ ዳራ ዙታምባሴ አሲክ ሀርምነዋ ቦርን ፋክነ ባሳ ሱናሲክ አዋስቶኒር ይስቴራ ትቼ። ");
INSERT INTO jnje_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ኤስ ባርኪ ንቶ ዛልዋ። ");
INSERT INTO jnje_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ታ አባታስ ንቶክ እምና አብዲሶን ንቶክ ዎሱና። ንቶ ደይ ደኑን ሁግና እምቶና ካባኔን የሩሳሌም ካታማስ ፎቲ።» ");
INSERT INTO jnje_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ኤሴን ኦርፎ ናዎባሳክቶኒን ኤጴ ብታኒያ ሀሚ። ኩሹባሶን ካብግሬ ባሶትን ሱስ። ");
INSERT INTO jnje_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ሱስፌት ባሶስታን ኦር ኬሴ ደን ሳማ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ባሶ ደይ ባርኪ ካአነሬ አካማ ግራክ የሩሳሌም ዎል ሌ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ሀኦሶን ጋላቴት ዎንና ዎንና ቤቴሜቅደሲሲ ኣነ ትሽሴፌ። ");
INSERT INTO jnje_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ዜምማኔን ካም ፌር። ባር ደይ ሀኦሲክቱ ፌ፤ ካሚስ ደይ ሀኦ፤ ");
INSERT INTO jnje_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ባር ደይ ዜምሜ ሀኦስኔንቱ ፌ። ");
INSERT INTO jnje_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ዙታምባሴ ባሪክቱ ቴስቴ፤ ቴስቴ ዉዛስ ዙቴራ ባርኪ ካሞቱ ቴስቴ፤ እሳ ዉዛኔ ባርኔን ጌራካሎ ቴስቴር ኣፋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ካ ባርኪክ ፋር፤ ኤስ ካስ ደይ አሱኒክ ቻሬፋ ስንና ፋር። ");
INSERT INTO jnje_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ቻሬፋስ ታልማስ ቻርስር፤ ታልማስ ባሮን ኣነ ሜሮዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ሀኦስኪን ዎስቴሬ የ ሱምባ ዮሀኒስ ይስቴ እሳ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ዙታምቤሲሴ ባርኪ ካሞ አማኖሶነክ ባር ቻሬፋሲ ቾዋኖን ዛላ ማኮናክቱ የ። ");
INSERT INTO jnje_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ቻሬፋሲ ቾዋኖን ዛላ ማኮናክቱ ዬቴኖ ባር ቻሬፍቴ። ");
INSERT INTO jnje_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","አሱ ዙታምባሴ አሲክ ቻሱኒ ፉቶኒ ቻሬፋ ሀን ዳስታክ ያድፋር። ");
INSERT INTO jnje_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ሀን ዳስታክ ፌር፤ ሀን ዳስ ባሪክቱ ቴስቴ፤ ስኒፋናክኑ ሀን ዳስ ኣነ ኤጳቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ባሳ ኬን ስና ባሶኪ የ፤ ስኑንታኖ ባሶ ባሪን ኣነ ኤጴቶሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ስኑንታኖ ኤጴቴሴሬ ሱንባሲክ አማነፌ ባሶ ዙቴሬ ሀኦኒ ናንጎታ ስኖነክ ማብት ባሶክ እምቴ። ");
INSERT INTO jnje_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ባሶ ሀኦኒ ናንጎታ ስንነቴስ አሱኒ ቱማክ ወደይ ሀንናኪን ወደይ አሻኪን ወደይ ቴጎኒ ፍቃድክ ኣነ ኮንቶሶቶ። ባሶ ኮንቴሴቴስ ሀኦኪጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ካማስ አሻ ስንና እንኖ ጋነያሲ ሀእ። እንኖ ደይ አባባስክ ፌና ካባሲክ ፋ ኡልፍንባስነ ፋ እሳ ና ባር ባሳ ኡልፍናሶን ቢኒ። ባር ደይ ሀኦኒ ኦቱማክናዋ ፉቶክና ቱሚ። ");
INSERT INTO jnje_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ዮሀኒስ ባሳ ቾዋሶን ዛላ ማኬት፦ « ‹ታ ኦርፎስታ ዮኒ ባር ታኔን ስናክ ፌር። ታይስታን ደይ ደናሎ› ይራ ማኬናስ ባርዋ» ይሬ ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ባሳ ቱማስታን እንኖ ዙታምኒሴ ኦትማስታን ኦትማ ዳይስራ ኤጳታኒ። ");
INSERT INTO jnje_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ቱማስ ሙሴኒኪ ካሞ እምቴ። ስኑንታኖ ኦቱምነዋ ፉቶነ የሱስ ክርስቶስኒኪ ካሞ ያ። ");
INSERT INTO jnje_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ሀኦሶን ብያር ኦኑ ኣፌ። ስኑንታኖ አባን ስና ሀኦሲኔን ፌ እሳ ናስ ባር ባር ሀኦስ ኦ ስንናማቶ እኖክ አምማኖን ቤሲ። ");
INSERT INTO jnje_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","አይሁድኒ ሜኒ አስሲኛኒ ሜያ የሩሳለሙን ማግኒ ሜናዋ ባሶትን አሪጋሴፌ ሌዊኒ ሜና አሲን ዮሀኒስኒኪ ዎስሴሬ፦ «ነ ኦንሶ?» ይሬ ማሙስሴቴ ካባሲክ ማኬና ዛልኒ ካማስ ሀኒስዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ባር ደይ ኣቹኖይ፦ «ዮኒር ይስቴ ሙድቶስ ታቴዋ » ይሬ አምማኖን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ባሶ ደይ፦ «ኤኪን ነ ኦንሶ? ኤልያስኖሶ?» ይሬ ማሙስሴቴ። ባር ደይ፦ «እንዳነዋ» ይሬ ዎልጊ። ባሶ ደይ፦ «ኤኪን ራጁኖሶ?» ይሴቴ። ባር ደይ፦ «እንዳነዋ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ባሶ ደይ፦ «ኤኪን ነ ኦንሶ? እኖትን ዎሲ ባሶክ ሀማ ማኮኒክ ነ ነ ቴታሶን ኦ ይፋትሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ባር፦ «ራጁ እሳያስኒሲ ማክቴናሲማቶ ‹ዳሚሳ ኡግናኖን ዜጵት› ይሬ ኢችማ ዳስ ሲ ቻግፌ አሱሳ ካማ ታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ባሶ ዎስቴሬ ዬሴቴስ ፌርሳዊኒ ሜያኪንዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ባሶ ደይ ዮሀኒስኒን፦ «ኤሴ ነ ክርስቶስ ወደይ ኤልያስ ወደይ ዮኒር ይስቴ ራጁኡስ ስና ሻካታነ አዉኒሮን ሀጵቅድፋታሪንሶ?» ይሴሬ ማሙስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ዮሀኒስ ዎልግሬ፦ «ታ አካክቱ ሀጵቁና። ስኑንታኖ ንቶ አሩኖይትር ጋነንትሲ የሬፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ታ ኦርፎስታ ዮኒ ባሳ ቻእማሲ ታርአኖን ኮታክ ሾልሱኖይናር ባርዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ሀን ባር ዙቴራ ስንናስ ዮሀኒስ ሀጵቅት ፌና ዮርዳኖስኒ አካሲ የሳሎ አዋ ኬስናርኪክ ፋ ብታኒያክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ዎኖትርክ የሱስ ዮሀኒስኒኪ ዬፌን ብያት ኤካ ይ፦ «ኤሴ ሀን ዳስታክ ፌ አሱሳ ቦርአኖን ባሶስታን ትሽኩኒ ሀኦኒ ፋንቱ፤ ");
INSERT INTO jnje_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‹ታ ኦርፎስታ ዮኒ ባር ታኔን ስናክ ፌር። ታይስታን ደይ ደናሎ› ይራ ማኬናስ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ታኑ ኤስ ዮኒ ባሪን ኣነ አሪፋትዋ። ስኑንታኖ ታ አካክ ሀጵቅት ያናስ እስራኤልኒ ሜያ ባሪን አሪሶነክዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ዮሀኒስ ኤካ ይሬ ዛላ ማኬ፦ «ኮርቶ አያና ሳማን ናካሎነ ፋር ስንና ባሳስታ ኬሬፌን ቢን። ");
INSERT INTO jnje_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","አካክ ሀጵቁናክ ታን ዎሲስ ባር፦ ‹ኮርቶ አያና ኬሬፌንናዋ ባሳስታ ዲፌንና ብያታ ባርቱ ኮርቶ አያናክ ሀጵቁኒስዋ› ይራ ማኬና ካባኔን ታኑ ኣነ አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ታ ደይ ቢና ቦርአ ባር ሀኦኒ ና ስኒባሶን ዛላ ማኬንጝዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ዎኖትርክ ዮሀኒስ ሄፕ ናዎባስኔን ኤስታ የሬፌር። ");
INSERT INTO jnje_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","የሱስ ኤስታክ ኣትፌን ዮሀኒስ ብያት፦ «ኤሴ ሀኒስ ሀኦሲ ፋንቱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ሄፕ ዮሀኒስኒ ናዎሳክቶ ዮሀኒስ ኤስ ባሮን ማኬፌን ኦደሴፋት የሱስኒ ኦርፎሴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ባሶ የሱስኒ ኦርፎሴ ሀሜፌን የርእቀሬ ብያት «አዉ ሾሌድፌትሪንሶ?» ይ። ባሶ ደይ፦ «ሬቢ! አይንሶ ፋፋታርሪ?» ይሴቴ። ሬቢ! ኡስ አስሲኛ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ባር ደይ፦ «ያራ ቢትዋ» ይ። ሀሜሬ ፌፌናማቶ ብየሬ ኤስ ዎኖ አነ ፌሸቴ። ኤስ ካባሲክ ደይ ዎናሲ አስር ሳአት ስናና። ");
INSERT INTO jnje_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ዮሀኒስ ማኬና ካማሶን ኦዴሬ ባርኔን አነ ሀሜ ናዎሳስን እሳይስ ስሞን ጴጥሮስኒ አይ ስና አንድርያስ ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ባር ዜምሜ አይባ ስሞኒኪ ሀምሜ፦ «ሜሲስን ዳንኒዋ» ይ። ሜሲ ኡስ ሙድቶ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","የሱስኒኪ ደይ ኤጴ የ። የሱስ ባሪን ቢሬ፦ «ነ ዮንናዓኒ ና ስሞንዋ፥ ነ ሀውጙኔን ኤካሎ ‹ኬፋ› ይስቴራቱ ቴግቶታዋ» ይ። ኮትባስ ደይ «ጴጥሮስ ወደይ እኛ ሹአ» ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ዎኖትሪክ የሱስ ጋሊላ ሀማናክ ሾሌ። ፍልጶስኒን ደይ ዳንነ፦ «ታኔን አነ ሀምንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ፍልጶስ ደይ አንድርያስናዋ ጴጥሮስና አስሲማቶ ቤቴሳይዳኪ ካታማስቱ ፌሴፌ። ");
INSERT INTO jnje_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ፍልጶስ ናትናኤልንን ዳንነ፦ «ሙሴኒ ቱማሲናዋ ራጁኒ ሜያ ባሳ ቾዉባሶን ትችሴቴ ባሪን ዳንጝዋ። ኤሲስ ደይ ዮሴፍኒ ና ናዝሬትክ የሱስዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ናትናኤል ደይ፦ «ናዝሬቱን ማአ ዉዛ ኬሳክ ችምንሮሶ?» ይ። ፍልጶስ፦ «ያራ ቢዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","የሱስ ደይ ናትናኤል ሀጝ ባርኪ ዬፌን ብያት፦ «ፉቶኒ እስራኤልኒ አሱ ሀንፌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ናትናኤል ደይ፦ «ታን አይክ አሪፋትሶ?» ይት ማምሲ። የሱስ ዎልግሬ፦ «ፍልጶስ ቴጎኖይፌን ቤለስኒ እኦሲ ዲሲ ዲፌን ቢጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ናትናኤል ዎልግሬ፦ «አስሲኛኖ! ነ ሀኦኒ ናዋ። ነ እስራኤልኒ ታቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","የሱስ ዎልግሬ፦ « ‹ቤለስኒ እኦሲ ዲሲ ዲፌን ቢጝዋ› ይና ቦርአኖሶ አማነታሪ? ሀኒስታን ደናሎ ዉዛኑ ብያታርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ፉቶክ ንቶክ ማኬፋውጙዋ፤ ሳማስ ጋቼፌን ሀኦሲ ዎስያ ደይ ዳ አሱኒ ናስኪ ኬሬፌንናዋ ኬስፌንና ብያትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ኬስናሪ ዎኖ ጋሊላኒ አዉራጃስ ቃናኒ ካታማሲ ሳርግ ፋር። የሱስኒ እንቶስ ደይ ኤስታክ ፋር። ");
INSERT INTO jnje_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","የሱስናዋ ናዎኒ ሜና ኤስ ሳርግስታ ቴግቴሴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ዋይንኒ ኡሻስ ኮእፋና ካባሲክ የሱስኒ እንቶስ፦ «ዋይንኒ ኡሽቤሲስ ኮእፋንቱ ፌሴቴዋ!» ይራ የሱስኒክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","የሱስ ዎልግሬ፦ «እንቶናሴ! ኤኪን ታን አዉ ዛጉዋ ይፋስሴ? ታ ዎናስ ሀሽኑ ኣነ ካርአዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","የሱስኒ እንቶስ ደይ ዎስትኛኒ ሜያክ፦ «ባር ማኬና ባሮን ዙትራ ዛጉትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","አይሁድኒ ሜያ ማሴሬ ካይምሴፌ ቱማስማቶ እሱን ሹእኒ ዋሻ ኤስታ ዲሴፋር። እሳ እሳርባስ ሄፕ ወደይ ኬዝ ግማ አካቱ ኤጵፋ። ");
INSERT INTO jnje_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","የሱስ ዎስትኛኒ ሜያክ፦ «ዋሻሲክቶሲ አካ ቱኑትዋ» ይን ኖኖባስታኔን ካትሴሬ ቱንሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ኤስታን የሱስ፦ «ሀሽ ክታ ኮታሲ ጋኛኒክ እምትዋ» ይን እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ጋኝኛስ ዋይንኒ ኡሻ ስና አካሶን ቤችሬ ቢሬ አይን ያናማቶ ኣነ አሩዌ። ስኑንታኖ አካሶን ክታ ዎስትኛኒ ሜያ አርሴድፌር። ጋኝኛስ ማሪስን ቴጌሬ ");
INSERT INTO jnje_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«አሱ ዙታምባሴ ዜምሜ ማአ ዋይንኒ ኡሻሶንቱ እምፌ። ኤስታን ኡሼ ዛይሴቴኔን ኦርፎ ማንጉሶን እምፌ። ነ ማአ ዋይንኒ ኡሻሶን ሀሽኔን ዱሳን ዲፋር» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","የሱስ ኤስ ቢስቴራ አሪቶኖይ ዉዛሶን ዜምሜ ጋሊላክ ፋ ቃናክ ዛጉክ ኡልፍንባሶን አምማኖን ቤስ። ናዎኒ ሜያ ደይ ባሪክ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ኤሴን ኦርፎ የሱስ እንቶባስኔን፥ አይባሳክቶኔን፥ ናዎኒ ሜያኔን አነ ክፍርናሆም ኬርሴቴ። ኤስታክ ጋሮ ዎና ዲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","አይሁድኒ ሜኒ ፋስካኒ ሄቦስ ታእሴራ ፋር። የሱስ የሩሳሌም ኬሲ። ");
INSERT INTO jnje_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ቤቴሜቅደሲሲ ያቦስታ ሚያሶን፥ ፋንቱሶን፥ ናካሎሶን ዋግሴፌ ባሶትን ዳኒ። ደይ ኦም ዋጋ ሶለፌ ባሶ ዲሴፋ ዋጋ ሶለሴፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ጋዱኒ አላንጋ ማእሬ ፋንቱሶንናዋ ሚያሶንና ዙትሬ ቤቴሜቅደሲሲ ያቦታን ካሌ ክሲ። ሶልቴፋ ዋግቤሲሶን ደይ ስኬሬ ታራቤዛሶን ሸልግሬ ሀእ። ");
INSERT INTO jnje_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ናካሎ ዋግሴፌ ባሶትን፦ «ሀን ባሮን ሀንታን ኤጳ ኬስትዋ! አባታሳ ኬያኖን ናጋድኒ ኬያ ዛጉትታዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ናዎኒ ሜያ ደይ፦ «ኬኔሲ ቾዋ ታን፤ ሴኪዋ» ይስቴራ ትቼናማቶ ጋሳሲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","አይሁድኒ ሜያ ደይ፦ «ሀን ዛግፋታ ባሪክ አሮ ቢስቴራ አሪቶኖይ ዉዛ እኖክ ቤሱታስሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","የሱስ ዎልግሬ፦ «ሀን ቤቴሜቅደሲሲ ክድስቴ ክዱሳኒኖን ቦጋኒ ታ ኬስናሪ ዎኖ ዎልግራ ኬርአናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","አይሁድኒ ሜያ፦ «ሀን ቤቴሜቅደሲሲ ክድስቴ ክዱሳኒ አቼቻስሬ እሱነ ነያ ኮእስራቱ ኬቴራ ኬስዋ። ኤኪን ነ ኣካክ ኬስናሪ ዎኖ ኬርአታስሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ስኑንታኖ የሱስ ባሳ አቱሶንቱ፦ «ቤቴሜቅደስ ክድስቴ ክዱሳን» ይሬ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ኤስ ባሪ ቦርኣ ሀኦሲ የሱስኒን ክቱን ካብግናኔን ኦርፎ ናዎኒ ሜያ ኤስ ባሮን ማኬናማቶ ንቤሲስታ ኬጅ። ኤስታን ትቻሴዋ የሱስ ማኬና ካማሴ አስን አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","የሱስ ፋስካኒ ሄቦስ ዎኖ የሩሳለሙክ ዛግና ቢስቴራ አሪቶኖይ ዉዛሶን ብየቴ ቦርአ ሾዎ አሱኒ ሜያ ባሪክ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","ባር አሱሳ ንብሲ ፋ ዉዛሶን ዙትሬ አሪር ስንና ቦርአ ኦኑ አሱኒ ቾዋ ባሪክ ማኮናክ ኣነ ሾልስፋ። የሱስ አሱኒ ሜያኖን ዙትሬ አሪፌና ቦርአ ባሶትን ኣነ አማነፌ። ");
INSERT INTO jnje_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ፌርሳዊኒ ኬን ስና አይሁድኒ ጋኝኜ ሜያስን እሳ ንኮድሞስ ይስቴ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ባር እሳ ዎኖ ታልማክ የሱስኒኪ ዬሬ፦ «አስሲኛኖ! ሀኦ ባርኔን ስንና አሱ ስና ሻካናነ ሀን ነ ዛግፋታ ቢስቴራ አሪቶኖይ ዉዛሲክቶኖን ዛጉክ ችምኒር ኣፌዋ። ኤስ ባሪ ቦርኣ ነ ሀኦስኪን የ አስሲኛ ስንታማቶ አሪፌንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","የሱስ ዎልግሬ፦ «ፉቶ ኔክ ማኬፋጝዋ፦ አሱ ሄፕሳ ኮንቶ ሻካናነ ሀኦሲ ታቶኖን ብያናክ ኣፋ ችማናዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ንኮድሞስ ደይ፦ «አሱ ኩርእናኔን ኦርፎ ኣካክ ሄፕሳ ኮንቶክ ችምንሪንሶ? ሄፕሳ እንቶባሲ ኬንሲ ግሪሬ ኮንቶናክ ችምንሮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","የሱስ ዎልግሬ፦ «ፉቶ ኔክ ማኬፋጝዋ፦ አሱ አካክንናዋ ሀኦኒ አያናክንና ኮንቶ ሻካናነ ሀኦሲ ታቶሲ ግሩክ ኣፋዋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","አሱኒኪን ኮንቴ ባር አሱዋ። ስኑንታኖ ሀኦሲ አያናኪን ኮንቴ ባር ሀኦስኪን ጋድዶ ካ ዳኒዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‹ሄፕስ ኮኒቶትክ ሾልሱዋ› ይና ቦርአ ዲንቆታታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ስሩ ሾሌና ድማቱ ሲሪፋዋ። ካምባሶንቱ ኦዶታዋ። ስኑንታኖ አይን ያናማቶናዋ አይ ሀሚድፋናማቶና ኣነ አሪፌዋ። ሀኦሲ አያናኪን ኮንቴ ባር ዙታምባሴ ኤሲስማቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ንኮድሞስ፦ «ሀን ባር ኣካክ ስናናክ ችምንሪንሶ?» ይሬ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","የሱስ ዎልግሬ፦ «ነ አርቶ እስራኤልኒ አስሲኛ ስንና ፋፋት ሀን ባሮን ኣነ አሪፌኖሶ? ");
INSERT INTO jnje_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ፉቶ ኔክ ማኬፋጝዋ፦ አሪፌኒ ባሮንቱ ማኬፌኒዋ፥ ቢኒ ባርኪቱ ዛላ ማኬፌኒዋ። ማኬፌኒ ባሮኑ ኣነ ኤጳ ታፌቲ። ");
INSERT INTO jnje_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ሀን ዳስታኪ ቾዋሶን ማኬና አማኖኖይ ንቶ ደን ሳማኪ ቾዋሶን ማኬፋናነ ኣካክ አማኖትሶ? ");
INSERT INTO jnje_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ደን ሳማን ኬሬ አሱኒ ናስኔን ኦም ደን ሳማ ኬሳር ኦኑ ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ሙሴ ዛቦሲ ብታክ ዎሱስቴ ዛዉኒ ቤሶሶን ሱትናይስማቶ አሱኒ ና ሱቶናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ኤሲስ ደይ አሱኒ ናኒክ አማነፌ ባር ዙታምባሴ ኮእባ ፎንቶ ካባ ፎናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ባሪክ አማነፌ ባር ዙታምባሴ ኮእባ ፎንቶ ካ ዳናናክታኖ ትሹኖይናማቶ ሀኦስ እሳ ናዉባ ባር ባሪን ኣትራ እማ ሀን ዳሶን ባክ ኬሽቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ሀኦ እሳ ናባስን ሀን ዳስታክ ዎስናስ ዳስታክ ማጝሱኒ ካርአክ ስኖይናማቶ ሀን ዳሶን ባርኪ ካሞ ፉኦክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ባሪክ አማነፌ ባሳስታ ማጝሱ ኣፋ ካቶና ዉዛ። ስኑንታኖ አማኖኖይ ባር እሳ ሀኦሲ ና ባር ባሪክ አማኖ ቤይና ቦርአ ማጝሱ ባሳስታ ካቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ቻሬፋስ ሀን ዳስታክ ያ። አሱኒ ሜያ ዎስቶቤሲስ ማጙ ስንና ቦርአ ቻሬፋሶን ቤይፋት ታልማሶን ሹነቴ። ኤሲስቱ ማጝሱኒ ካርኣዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ማንጉሶን ዛግፌ ባር ዙታምባሴ ቻሬፋሶን ኦምቴርዋ። ዎስቶባስ አምማኖን ኬስኖይናማቶ ቻሬፋስሲ ኣነ ዬፌ። ");
INSERT INTO jnje_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ስኑንታኖ ሀኦ ሾሌፋና ዎስቶሶን ዛግፌ ባር ዎስቶባስ ሀኦሲክ አምማኖን ቤስቶናክ ቻሬፋስሲ ዬፌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ኤሴን ኦርፎ የሱስ ናዎኒ ሜያኔን አነ ዩዳኒ ዳ ሀሜሴቴ። ኤስታክ ባሶኔን አነ ፌፋት ሀጵቅድፌር። ");
INSERT INTO jnje_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ዮሀኒስ ደይ ሳሌምኒ ታእሶስታ ፋ ሄኖኑክ ሾዎ አካ ፋሪ ስንና ቦርአ ኤስታክ ሀጵቅት ፌር። አሱኒ ሜያ ሀጱክቶሶንክ ዬፋፌ ሀጱክቴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ኤስ ባር ስንናስ ዮሀኒስ ታቶኒ ኬር ግሩኖይ ፌን። ");
INSERT INTO jnje_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ዮሀኒስኒ ናዎኒ ሜናዋ እሳ አይሁድኒ አሱና አስ ጋነያሲ አይሁድኒ ሜኒ ቱማሲ ፋ ካይምኒ ቾዋሲክ ክሪኪሪ ካቢ። ");
INSERT INTO jnje_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ዮሀኒስኒኪ ዬሴሬ፦ «አስሲኛኖ! ዮርዳኖስኒ አካሲ የሳሎ አዋ ኬስናሩክ ነኔን አነ ፌና ካባሲክ ነ ባሳ ቾዋሶን ዛላ ማኬታ ባር ደይ ሀጵቅድፌርዋ። ሾዎ አሱኒ ሜያ ደይ ባርኪ ሀሜድፌርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ዮሀኒስ ዎልግሬ፦ «ደን ሳማን እምቶኖይፌን አሱ እሳ ዉዛ ኤጴቶክ ኣፋዋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹ዮኒር ይስቴ ሙድቶስ ታቴዋ። ስኑንታኖ ባሳ ስናስታቱ ዎስቴራ ያጝዋ› ይራ ማኬናማቶ ንቶኑ ዛላ ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ማርያስ ማሪሳርዋ፥ ማሪስን አሪጋሱክ አነ ፌ፤ ሙዝግቱስ ማሪሳ ካማኖን ኦደፌና ካባሲክ አካማኖንቱ ግሬፌዋ። ኤስ ግራስ ደይ ታርዋ። ኤስ ግራስ ደይ ሀሽ ስንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ባር አሪክቶናክ፥ ታ ደይ ሀቶናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ደኑን ዮኒ ባር ዙታምባሴ አሲ ደናሎዋ። ሀን ዳስታኪ ባር ሀን ዳስታኪርዋ። ሀን ዳስታኪ ቾዋሶንቱ ማኬፋ። ሳማን ዮኒ ባር ዙታምባሴ አሲ ደናሎዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ቢና ባሮናዋ ኦደና ባሮንናቱ ዛላ ማኬፌ። ስኑንታኖ ዛልባሶን ኦኑ ኣነ ኤጴቴፌ። ");
INSERT INTO jnje_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ማኬፌና ዛልኒ ካምባሶን ኤጴቴ ባር ሀኦሲ ፉቶ ስንባሶን ጋሳሲ። ");
INSERT INTO jnje_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ሀኦሲ አያናባሶን ቱንራ እምፋና ቦርአ ሀኦ ዎስና ባር ሀኦሲ ካማኖንቱ ማኬፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","አባስ ናሲን ኬሽቴር፤ ዙታምባሴ አሲን ደይ ኩሹባሲ እሚ። ");
INSERT INTO jnje_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ናዉባሲክ አማነፌ ባር ዙታምባሴ ኮእባ ፎንቶ ካባ ፋርዋ። ናዉባሲክ አማኖኖይ ባር ሀኦሲ ግአቱ ባሳስታ ፎኒርታኖ ካሶን ኣፋ ዳናና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ፌርሳዊኒ ሜያ የሱስ ዮሀኒስኒታን አርኪስሬ ሾዎ አሱኒ ናዎባ ዛግሬ ሀጵቅት ፌናማቶ ኦደሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ስኑንታኖ ሀጵቂስ የሱስ ስኖይናሮን ናዎባሳክቶቱ ሀጵቅት ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","የሱስ ደይ ኤስ ባሮን አሪናሴ ዩዳኒ አዉራጃሶን ቤይፋት ጋሊላ ሄፕሳ ዎሌ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ሳማርያኒ አዉራጃ ካሞ አቴ ሀማና ባር ሾልስራ ፋር። ");
INSERT INTO jnje_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ኤስ ባሪ ቦርኣ ያቆብ ናዉባ ዮሴፍኒክ እምና ድማሲ ቴሽታ ፋ «ሲካር» ይስቴፋ ሳማርያኒ ካታማሲ የ። ");
INSERT INTO jnje_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ኤስታክ ያቆብኒ አካኒ ዶእአ ፋር። የሱስ ኡጉንነ ኩቱክ ሆፕና ቦርአ ኤስ ዶኣሲ ቴሻ ድ። ኤስ ካባሲክ ዎናስ እሱን ሳአት ስናና። ");
INSERT INTO jnje_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","ናዎኒ ሜያ ደይ ሙኒ ዋጎስ ካታማ ሀሜቴ። ኤስ ካባሲክ ሳማርያን እሳ ማሽካሱ አካኒ ኪታክ ያ። የሱስ ባሪክ፦ «አካ እምን ኡሹጝዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ኤስ አሱስ ደይ፦ «ነ ዩዳኒ አሱ ስንፋት ታ ሳማርያኪ አሱ ስና ታኪን ኣካክ አካ ሺጶታሶ?» ይ። አይሁድኒ ሜያ ሳማርያኪ አሱኒ ሜያኔን አኔ እሳርቤስ ኣፋ ስንና ቦርአቱ ኤስ ባሮን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","የሱስ ዎልግሬ፦ «ሀኦሲ እማኖንናዋ ‹አካ ታክ እምን ኡሹጝዌ› ይስ ኦ ስንናማቶ አራታነ ሺጶኒስ ነዌ። ኤካን ባር ደይ ካኒ አካ ኔክ እማና ካባዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","አሱስ ደይ ዎልግራ ኤካ ይ፦ «ነ አካሶን ክታታ ዉዝነ ኣፋዋ። ዶኣስ ደይ ዬት ዎካዋ። ኤኪን ካኒ አካ አይን ዳናታስሶ? ");
INSERT INTO jnje_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ነ ሀን አካኒ ዶኣሶን እኖክ እማ አባን ያቆብኒስታን አርኩታሮሶ? ባርኔን ናንጎትባስኔን ዋግባስኔን ሀን ባሮንቱ ኡሸቴዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","የሱስ ዎልግሬ፦ «ሀን አካሶን ኡሽፌ ባሶ ዙቴሬ ሄፕሳ ዎል ሌቱ እክቶሶነዌ። ");
INSERT INTO jnje_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ታ እማና አካሶን ኡሽኒ ባሶ ዙቴሬ ኮእባ ፎንቶ ነያ እሳንነ ኣፋዌ እክቶሶነ ዉዛ። ታ እማና አካሶን ኡሽኒ ባሪክ ሀኦኒ አያና ባሳሲ ኮእባ ፎንቶ ካኒ ኮርአቱ ስናና» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","አሱስ ደይ፦ «ሀን አሱሶ! እክቶኖይናማቶናዋ አካኒ ክሲ ሀንታ ዎላ ዮኖይናማቶና ኤስ አካሶን ታክ እማይዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","የሱስ ደይ፦ «ሀምፋት ቴጎኔስን ቴጌራ ዎላ ሀንታ ዮዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","አሱስ ዎልግራ፦ «ቴጎታ ኣፌዋ» ይ። የሱስ፦ « ‹ቴጎታ ኣፌ› ኡኔሲክ ማአሮን ማኬትዌ። ");
INSERT INTO jnje_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ነ ኡች ቴጎንኪ ግርራ ኬስታርዌ። ሀሽ ነኔን አነ ፌ ባርኑ ቴጎነቴ ስንና ቦርአ ማኬታስ ፉቶዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","አሱስ ደይ፦ «ሀን አሱሶ! ነ ራጁ ስንታማቶ አሪጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","እንኖ አባን ሜያ ሀን ኣማሲክቱ ሳጋዴሴቴዋ። ስኑንታኖ ንቶ ደይ ‹አሱኒ ሜያ ሳጋዶሶነክ ሾልስፋናስ የሩሳለሙክዋ› ይሴፌት» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","የሱስ ደይ ኤካ ይ፦ «ሀን አሱሴ፥ ሀን ኣማሲክ ወደይ የሩሳለሙክ አባሲክ ሳጋዶኖኖይት ዎና ዮናማቶ አማኖዌ። ");
INSERT INTO jnje_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ንቶ ሳምራዊኒ ሜያ አሩኖይት ሀኦሲክቱ ሳጋደፌት። ስኑንታኖ ፋሩ ዮናስ አይሁድኒኪን ስንና ቦርአ እንኖ አሪፌኒ ሀኦሲክቱ ሳጋደፌኒ። ");
INSERT INTO jnje_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ስኑንታኖ ፉቶክ ሳጋድሴፌ ባሶ አባሲክናዋ ካይማ አያናሲክና ፉቶክ ሳጋዶሶነ ዎና ዮና። ኤስ ባር ደይ ሀሽ ስንዋ። አባስ ደይ ካኖሶነክ ኤስ ኤፋቴናሶንቱ ሾሌፌ። ");
INSERT INTO jnje_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ሀኦስ ኮርቶ አያናዋ። ባሪክ ሳጋዴሴፌ ባሶ ደይ ኮርቶ አያናክናዋ ፉቶሲክና ሳጋዶሶነክ ሾልሱዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","አሱስ ደይ፦ «ክርስቶስ ይስቴፌ ሜሲስ ዮናማቶ አሪፋውጙዋ። ባር ዬሬ ዙታምባሴ አስን እኖክ ማኮናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","የሱስ ደይ፦ «ሀን ነኔን አነ ዎል ሌፌስ ታ ባርዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ኤስ ካባሲክ ናዎኒ ሜያ ሀሜቴስን ዎልሴሬ ዬሴቴ። የሱስ ማሽካሱስኔን ዎሎባሲክ ዲንቀሴቴ። ስኑንታኖ፦ «አዉ ሾሌድፋትሴ ወደይ አሱስኔን አዋጋን ዎል ሌድፋትሶ?» ይሬ ማምሲር ኦኑ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ኤስታን አሱስ ግማሶን ኤስታክ ቤይፋት ካታማ ሀማ አሱኒ ሜያክ፦ ");
INSERT INTO jnje_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«ታ ዛግና ባሮን ዙትሬ ማኬ አሱስን ያፋት ቢትዋ። ቶግሶ ባር ክርስቶስ ስና ቤዩጝጌሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","አሱኒ ሜያ ደይ ካታማስን ኬሴሬ ባርኪ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ኤስ ካባሲክ ናዎኒ ሜያ፦ «አስሲኛኖ! ማክቴትዋ ሙዋ» ይት ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ስኑንታኖ ባር፦ «ንቶ አሩኖይት ታ ሙና ሙ ታክ ፋርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ኤስ ባሪ ቦርኣ ናዎኒ ሜያ፦ «ባር ሙና ሙ ኤጴ የ አሱ ፌርቴሶ?» ይሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","የሱስ ባሶክ ኤካ ይ፦ «ታ ሙስ ታን ዎሲ ባሳ ሳፋራኖን ዛጉነዋ ዎስቶባሶን ኮእሱነዋ። ");
INSERT INTO jnje_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ንቶ ‹ሜኒ ዙቱ ካርእአናክ አቼች አስሳቱ ፋርዋ› ይፌትታኖሶ? ኤሴ ንቶክ ማኬፋውጙዋ ‹ካንና ሀሽ ሜያስ ካትናማቶ ፎሻሶን ቢትዋ› ይፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ካርእኒ ባር ዎስቶባሲ ዋጋኖን ኤጴቶኒርዋ። ኮእባ ፎንቶ ካክ ስንኒ ጋና ዙቱና። ኤስ ባሪ ቦርኣ ቡክኒ ባርናዋ ካርእኒ ባርና አነ ግርሶነ። ኤሴ ቡክፌስናዋ ካርእፌስና እሳሩክ ግርሶነክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‹እሳይስ ቡካና እሳይስ ደይ ካርእአና› ይፋ ካማስ ሀን ባርስታክ ፉቶ ስንዋ። ");
INSERT INTO jnje_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ታ ንቶ ሆፑኖይትሶን ካርእአትክ ዎስጝዋ። ኦም ሜያ ሆፕሴሴቴ። ስኑንታኖ ንቶ ባሶ ሆፕሴሴቴ ባሮን ዙቲት።» ");
INSERT INTO jnje_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ማሽካሱስ፦ «ታ ዛግና ባሮን ዙትሬ ታክ ማኬዋ» ይራ ማኬና ካማሲክ ኤስ ካታማሲ ፌሴ ሳማርያኪ አሱኒ ሜያስን ሾዎቤሲስ ባሪክ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ሳማሪያኪ አሱኒ ሜያ የሱስኒኪ ዬሴፌ ካባሲክ ሾዎ ዎና ባሶኔን አነ ፎናክ ሺጵሴቴ። ባር ደይ ኤስታ ሄፕ ዎና ፌሽ። ");
INSERT INTO jnje_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","የሱስ ማኬና ካማሲክ ኦም ሾዎ አሱኒ ሜያ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ማሽካሱሲክ ደይ፦ «ሀንኔን ኤካሎ ነ ማኬታ ቦርአ ስኖይናማቶ እንኖ ቴትኒሲክ ኦደኒ ቦርአ ባር ፉቶክኑ ሀን ዳሶን ፋቱኒር ስንናማቶ አሪንዌ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ሄፕ ዎናኔን ኦርፎ ኤስታን ዎሌ ጋሊላ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","የሱስ ዜምሜ «ራጁ ባሳ ዳስታክ ኣነ ኡልፍንቴፌ» ይሬ ማኬናር ፋር። ");
INSERT INTO jnje_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ስኑንታኖ ጋሊላ ካርእፌና ካባሲክ ጋሊላኪ አሱኒ ሜያ ፋስካኒ ሄቦሲክ የሩሳሌም ሀሚፌ ካባሲክ የሱስ ዛግና ቾዋሶን ብየቴ ቦርአ ባሪን ማአሪክ ኤጴቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ኤሴን ኦርፎ የሱስ አካሶን ዋይንኒ ኡሻ ዛግሬ ሶለና ዳ ጋሊላ ቃና ሄፕሳ ዎል ሌ የ። ኤስ ካባሲክ ክፍርናሆሙክ ናባ ሜትቴና እሳ ታቶኒ ሄራሾ ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ሄራሾስ የሱስ ዩዳኒ ጋሊላ ዬናማቶ ኦደ። ናባስ ክቱናክ አካማኖን ሜትቴሬ ፌር ስንና ቦርአ የሱስኒኪ ዬሬ፦ «ክፍርናሆም ኬሬራ ናታስን ፋታይዋ» ይሬ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","የሱስ ደይ፦ «ንቶ ቢስቴራ አሪቶኖይ ዉዝነዋ ዲንቂ ቾዉነ ብያ ሻካትነ እሳንነ ኣነ አማነፌትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ሄራሾስ ደይ፦ «ዳምታሶ! ናታስ ክቱኖይ ፌን ታእኒን ካርእፋይዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","የሱስ ባሪን፦ «ሀማ! ናኔስ ፋሩናዋ» ይ። አሱስ የሱስ ባሪክ ማኬና ካማሶን አማነሬ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ዎል ሌ ሀሚፌን ባሳ ዎስትኛኒ ሜያ ባሪን ሾሎክ ኬሴሬ ኡጉንታ ኡጵሴሬ፦ «ናስ ፋሪዋ» ይሴሬ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ባር፦ «ናስ አፑን ሳአትኪንሶ ፋርናሪ?» ይሬ ማምሲኒ። ባሶ ዎሉግሴሬ፦ «ሀዞ ናፉን ሳአትታክቱ አቱባሲ ጉምታና ጋፍኪዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ናሳ አባ ደይ የሱስ፦ «ናኔስ ፋሩናዋ» ይናስ ኤስ ሳአትስታ ስንናማቶ አሪ። ባርናዋ ኬርኪ አሱኒ ሜያና ደይ አነ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ኤሲስ ደይ የሱስ ዩዳኒ ጋሊላ ዬሬ ዛግና ሄፕሳ ቢስቴራ አሪቶኖይ ዉዛዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ኤሴን ኦርፎ አይሁድኒ ሜኒ ሄቦ ፋር ስንና ቦርአ የሱስ ደን የሩሳሌም ኬስ። ");
INSERT INTO jnje_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","የሩሳለሙክ ፋንቱስ ግሪፋት ኬስፋና ፍኝኛሲ ቴሻ እሳ ኩጲራ ኩኒ አካ ፋር። ኤስ አካስ እብራዊኒ ሜኒ ካማሲክ «ቤቴዛታ» ይስቴራቱ ቴግቴፋ። ባር ደይ ኡች ቱክባስታ ኡክባሬ የሬ ፍኖባ ፋር። ");
INSERT INTO jnje_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ኤስ ፍኖሲ ሾዎ ሜታን፤ ኣፍትሹ፥ ላፋናዋ ኤጝትፌ ሜና ኤስታ ኩንሴፌር። ባሶ ደይ አካሲ ሾርኮኖን ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ኣት ኣታ ዳሚሳ ዎስያ ኩጲራ ኩኒ አካሲ ኬሬታፋ አካሶን ሾርኪት ፋር። ኤስ አካስ ሾርኮኔን ኦርፎ ዜምሜ አካሲ ግሪ አሱ ኣፋ ቴሳ ሜሮስንኑ ፋሪት ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ኤስታክ ኬዛስሬ ናጝነ ነያ ላፋ ስንነ ፌ እሳ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","የሱስ ኤስ አሱስን ኩንፌን ብያት ሀሽኔን ካርእኤ ሾዎ ነያ ኤካክ ፌናማቶ አራት፦ «ፋሩታክ ሾሌፋቶሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ሜታን አሱስ፦ «ዳምታሶ! አካስ ሾርኬፋና ካባሲክ ታን አካሲ ኬሱኒ አሱታ ኣፌዋ፤ ታ ግሩክ ሀምፋና ካባሲክ ኦም አሱ ዜምፌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","የሱስ ደይ፦ «ካብራ ኦፖኔሶን ዎርአ ሀማ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ሜታን አሱስ ጌሬጌሬ ፋሪሬ ኦፖባሶን ዎርኤ ሀሚ። ኤስ ባር ስንናስ ቤይሳኒ ዎናሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","አይሁድኒ ሜያ ፋሪ አሱስን፦ «ሀሽ ሀውጙ ቤይሳኒ ዎና ስንና ቦርአ ኦፖኔሶን ዎርአታክ ኣነ ችምሲፋዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ስኑንታኖ ባር፦ «ታን ፋቲ አሱስ ‹ኦፖኔሶን ዎርአ ሀማ› ይርዋ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ባሶ ደይ፦ « ‹ኦፖኔሶን ዎርአ ሀማ› ይ አሱስ ባር ኦንሶ?» ይሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","የሱስ ኤክሴሬ ዳራሳ ጋነሲ ግሪ ስንና ቦርአ ፋሪ አሱስ ኦ ባሪን ፋትናማቶ ኣነ አሩዌ። ");
INSERT INTO jnje_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ኤሴን ኦርፎ የሱስ ፋትና አሱስን ቤቴሜቅደሲሲ ዳንነ፦ «ኤሴ ሀየ ፋሪትዋ። ሀኒስታን ደናሎ ዉዛ ነይስታ ካርኖይናማቶ ሀንኔን ኤካሎ ቦርአ ዎስቶታታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","አሱስ ሀምሜ አይሁድኒ ሜያክ፦ «ታን ፋትስ የሱስዋ» ይሬ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ቤይሳኒ ዎናሲክ ኤስ ባሮን ዛግና ቦርአ አይሁድኒ ሜያ የሱስ ኬሴ ግሩኖይናማቶ ካላክ ሾልሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ስኑንታኖ የሱስ፦ «አባታስ ሀሽ ሀውጙኔን ካርኤ ዎስቴድፌር። ታ ደይ ዎስቴናርዋ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ኤሴኑ ቤይሳኒ ዎናሶን ኦዳ ቤይባስ ባር ባር ስኖይናማቶ ቴትባሶን ደይ ሀኦሴነን እሳር ዛግሬ፦ «ሀኦስ ታክ አባታዋ» ይና ቦርአ አይሁድኒ ሜያ አካማኖን ዎሩክ ሾልሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ቱስሬ ደይ ባሶክ ኤካ ይ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፥ አባስ ዛግፌን ቢናይሶንታኖ ናስ ቴትባሲክ እሳ ዉዛነ ዛጉናክ ኣፋ ችማናዉዛ። አባስ ዛግፌና ባሮንቱ ዙትሬ ናስ ደይ ዛግፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","አባስ ናስን ኬሽቴር ስንና ቦርአ ባር ዛጉና ባሮን ዙትሬ ቤስፌዋ። ንቶኑ ዲንቆትማቶ ሀኒስታን ደናሎ ዎስቶኑ ቤሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","አባስ ክቱስንኑ ካብግሬ ካ እምፌናሲማቶ ናስ ደይ ሾልሴፌ ባሶክ ካ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","አሱ ዙቴሬ አባስን ኡልፍንሲፌናስማቶ ናስን ደይ ኡልፍንሱናክ ማጝሱሚ ካርኣሶን ዙትሬ ናባሲክ ኣትሬ እሚዋ። ኤስ ባሪ ቦርኣ አባስ ኦኒስታኑ ስንፋናነ ኣፋ ማጝሱ ካርአናዉዛ። ናስን ኡልፍንሱኖይ ባር ዎሲ አባስን ኣፋ ኡልፍንሱናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«ፉቶ ንቶክ ማኬፋውጙዋ፥ ካምናሶን ኦደፌ ባርናዋ ታን ዎሲ ባሪክ አማነፌ ባርና ኮእባ ፎንቶ ካባ ፋርዋ። ባር ክቱኒ ኬሩንቱ ካኒ ኬር ፍኒቴኖ ባሳስታ ኣፋ ማጝሱ ካቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ፉቶ ንቶክ ማኬፋውጙዋ፥ ክቱኒ ሜያ ሀኦሲ ናኒ ካማኖን ኦዶሶነ ዎና ዮናዋ። ዎናስ ደይ ሀሽዋ። ኦደሴፌ ባሶኑ ካክ ፎሶነ። ");
INSERT INTO jnje_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","አባስ ቴትባሲክ ካባ ፋናማቶ ናስ ደይ ቴትባሲክ ካባ ፎናክ እሚዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","አሱኒ ና ስንና ቦርአ ማጝሱኒ ካርኒ ሀእሱኒ ሁግና ኣሪክ እምቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ኤስ ባሪክ ዲንቆትታዋ፥ ሞጋሲ ፌሴ ባሶ ዙቴሬ ካምባሶን ኦዶሶነ ደይ ሞጋስን ኬሶነ ዎና ዮና። ");
INSERT INTO jnje_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ማአሮን ዛግ ባሶ ክቱን ካብሬ ካክ ፎሶነ። ማጙኖን ዛግሴ ባሶ ክቱን ካብሴቴን ባሶስታ ማጝሱ ካቶና። ");
INSERT INTO jnje_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«ታ ታ ቴታሲክ እሳ ዉዛነ ዛጉክ ኣፋ ችማናዉዛ። ማጝሱኒ ካርአናስ አባስኪን ኦደና ባሮን ኮእባዋ። ታን ዎሲ ባሳ ሳፋራሶንታኖ ታ ሳፋራሶን ዛጉክ ኣነ ሾሌፋት ስንና ቦርአ ማጝሱኒ ካርናስ ፉቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ታ ታ ቴታሲሮን ዛላ ማኬፋናነ ካምናሶን ፉቶ ዛግሬ ኤጴቶኒር ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ታክ ዛላ ማኮኒስ አባታስዋ፤ ባርኑ ታክ ማኮና ዛላስ ፉእቶኒር ስንናማቶ አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ንቶ ዮሀንኒሲኪ ዎስኒን ዎስሴት። ዮሀኒስ ደይ ፉቶክ ዛላ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ታ አሱኒ ዛላ ኣነ ሾሌፋት፤ ስኑንታኖ ንቶ ፋሩትክቱ ዮሀኒስ ማኬና ዛላሶን ማኬፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ዮሀኒስ ሳምፋት ቻርሲ ቶናነ ፌርዋ። ንቶ ደይ ጋሮ ዎና ኤስ ቻሬፋሲክ ግሮትክ ሾልሴት። ");
INSERT INTO jnje_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ስንፋናክኑ ታ ቾዋሶን ዮሀኒስኒስታን ደናሎ ማኮኒ ዛል ፋርዋ። ታ ኮእሱናክ አባታስ ታክ እምና ዎስቶ ሀን ዛግፋና ባርዋ። አባታስ ታን ዎሲናማቶ ዛላ ታክ ማኮኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ታን ዎሲ አባስ ታክ ዛላ ማኬዋ። ንቶ ካምባሶን እሳንነ ኣነ ኦዶሶዌት። ግቶባሶንኑ ኣነ ብዮሶዌት። ");
INSERT INTO jnje_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ባር ዎሲ ባሪን አማኖ ቤይቲ ቦርአ ካምባስ ንቶሲ ኣፋ ፎና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ንቶ ባሪክ ኮእባ ፎንቶ ካ ዳናትንነ ፋር ስንና ቤስቴፋን ትቻሶን ዌኤፌትዋ። ኤስ ትቻስኑ ታክቱ ዛላ ማኬፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ስንፋናክኑ ንቶ ካንት ፎናክ ታኪ ዮ ኣነ ሾሌሴፌት። ");
INSERT INTO jnje_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«ታ አሱኒኪን ኡልፍና ኣነ ሾሌፋት። ");
INSERT INTO jnje_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ስኑንታኖ ሀኦሶን ኬሽቶ ንብንትሲ ኣፋ ስንናማቶ አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","አባታሳ ሱናክ የ ታን ኣነ ኤጳቶዌት። ኦሚስ ቴትባሪ ሱናክ ዬን ባሪን ኤጳ ታሴቲር። ");
INSERT INTO jnje_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ንቶትና ንቶትና ዋል ኡልፍና ሾሌት ፌ ንቶ እሳ ሀኦስኪን ቤስቶኒ ኡልፍናሶን ኣነ ሾሌሴፌት ስንና ቦርአ ኣካክ አማኖክ ችማቴሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ታ አባሳ ስና ንቶትን ማላቶናነ ፋር ስንና ንቶክ ቤስቶናታዋ። ንቶትን ማላቶኒስ ንቶ አብዳቴሴፌት ሙሴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ሙሴኒን አማነሴት ስንፋናነ ታን ደይ አማኖቲ ካባዋ። ባር ታ ቾዋሶን ትችሬ ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ትቻሶን አማኖ ሻክፋትነ ካምናሶን ኣካክ አማኖትሪንሶ?» ");
INSERT INTO jnje_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ኤሴን ኦርፎ የሱስ ትቤርያዶስ ይስቴፋ ጋሊላን ባርስ የሳሎ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ሜታን ሜያኖን ፋቱክ ዛግና ቢስቴራ አሪቶኖይ ዉዛ ቢሴቴ ቦርአ ሾዎ ዳራ ባርኪ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","የሱስ ናዎኒ ሜያኔን አነ ኣማስታ ኬሴ ድ። ");
INSERT INTO jnje_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","አይሁድኒ ፋስካኒ ሄቦስ ታእሴራ ፋር። ");
INSERT INTO jnje_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","የሱስ ሾዎ ዳራ ባርኪ ዬሴፌን ካነ ብያት ፍልጶስኒን፦ «ሀን ባሶ ሙሶነክ ቱሻ አይን ዋጎንሪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ባር ዛጉና ባሮን አሪፌት ፍልጶስኒን ፋታኖክ ኤስ ባሮን ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ፍልጶስ፦ «ጋሮ ጋሮኖን እሳ እሳርቤሲስ ሙሶነክ ሄፕ ዲናሪ ትያ ዎና ዎሱስቴ ዎስቶኒ ዋግኒ ብርክ ዋግቴ ቱሻ ኣፋዋ ሆሮና ዉዛ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ናዎባሳክቶኒስን እሳይስ ስሞን ጴጥሮስኒ አይ ስና አንድርያስ የሱስኒክ ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«ኡች ሙማ ቱሽነዋ ሄፕ ኩርጡምሚነ ኤጶ ና ሀንታ ፌርዋ። ስኑንታኖ ኤፌቴና ዳራሲክ አዋግራ ካርኒሪንሶ?» ");
INSERT INTO jnje_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","የሱስ፦ «አሱኒ ሜያ ዱሶነክ ዛጉትዋ» ይ። ኤስታክ አካማ ኩዋ ፋር። ኤስ ዲሴ ባሶስን ኣርቃሱስ ኡች ኩም ስኖነ። ");
INSERT INTO jnje_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","የሱስ ኡች ቱሻሶን ኤጴ ጋላቴፋት ዲሴ ባሶክ ሆሮኒሶን ሃኦሶነክ ናዎኒ ሜያክ እሚ። ኩርጡምሚሶን ደይ ኤሲስማቶ። ");
INSERT INTO jnje_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ሜሴሬ ጋዉሴቴኔን ኦርፎ የሱስ ናዎኒ ሜያኖን፦ «እሳንነ ዝጉኖይናማቶ ፉእታና ባትቶሶን ዙቱትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ባሶ ደይ ማስቴ ኡች ሀጌዉኒ ቱሻስታን ፉእቴ ባትቶ ዙትሬ አስሬ ሄፔ ማሳ ቱኒሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ኤስታን ካብ ቾዋ አሱኒ ሜያ የሱስ ዛግና ቢስቴራ አሪቶኖይ ዉዛሶን ብየቴሴ፦ «ሀን ባር ፉቶክ ሀን ዳስታክ ዮናክ ፌ ራጁኡስዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ኤስ ባሪ ቦርኣ የሱስ ዬሴሬ ባሪን ኤጴሬ ታቶ ዛግሬ ታትሱክ ሾልሴቴማቶ አሪፋት ሄፕሳ ዎል ሌ ባር ባር ደን ኣማስታ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ዋልፋና ካባሲክ ናዎኒ ሜያ ዬት ባሪሲኪ ኬርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ጎኑሲ ዲሴሬ ባርሲ የሳሎ ክፍርናሆም ፍናክ ካብሴቴ። ኤስ ካባሲክ ታልሜራ ፋር። የሱስ ደይ ባሶኪ ኣነ ዮዌ። ");
INSERT INTO jnje_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","አካማ ሁግናባሬ የሬ ስሩ ስሪት ፋር ስንና ቦርአ ባሪስ ሾርኬ። ");
INSERT INTO jnje_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ኡች ወደይ እሱን ኪሎሜትሪነ ፋሮን ሀሜቴኔን ኦርፎ የሱስ አካስታ ታርሬ ኩቲት ጎኑስኪ ታእሴፌና ካባሲክ ባሶ ብያት ድጌሴቴ ");
INSERT INTO jnje_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ስኑንታኖ ባር፦ «ታዋ! ድጎትታ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ባር ጎኑሲ ግሪሬ ዱናክ ሾልሴቴ፤ ጌሬጌሬኑ ጎኑስ ሀምሜ ካርእኦነ ድማስታ ካርእ። ");
INSERT INTO jnje_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ዎኖትሪክ ባሪሲ የሳሎ የሬ ዳራስ እሳ ጎኑ ታኖ ኤስታክ ኦማ ጎኑ ኣፋ ስንናማቶናዋ ናዎኒ ሜያ ባሶ ባሶቱ ሀሜርቴኖ የሱስ ባሶኔን ኣነ ግሩዌ ስንባሶን አሪሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ስኑንታኖ ኦማ ጎኑሲክቶ ጥቤርያዶስኒ ካታማስ የሱስ ሱስና ቱሻሶን ሜሴቴ ድማሲ ቴሻ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","አሱኒ ሜያ ደይ የሱስ ወደይ ናዎኒ ሜያ ኤስታክ ኣፍሳቶ ስንቤሲሶን አራት ጎኑሲክቶሲ ዲሴሬ የሱስኒን ሾልሴት ክፍርናሆም ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ኤስ ባሪሲ ቴሻን ዳነሬ፦ «አስሲኛኖ! ሀንታ ኣጌንሶ ያታሪ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","የሱስ ዎልግሬ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፥ ታን ሾሌቲስ ቱሻ ማራ ጋዉሴት ቦርአታኖ ቢስቴራ አሪቶኖይ ዉዛ ቢት ቦርአታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ትሹኒ ቱሻሲክ ዎስቶትታዋ። ስኑንታኖ አሱኒ ና ንቶክ እማና ኮእባ ፎንቶ ካክ ስንኒ ቱሻሲክ ዎስቶትዋ። አባ ሀኦሲ አሪቶኒ ማታማኖን ባሳስታ እችዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ባሶ ደይ፦ «ኤኪን ሀኦሲ ዎስቶኖን ዎስቶኒክ አዉ ዛጉንክ ሾልስፋሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","የሱስ ዎልግሬ፦ «ኤስ ሀኦሲ ዎስቶ ባር ዎሲና ባሪክ አማኖትክዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ኤስ ባሪ ቦርኣ ባሶ ደይ ኤካ ይሴቴ፦ «ኤሴ፥ እንኖ ቢራ አማኖኒክ ነ አሮ ቢስቴራ አሪቶኖይ ዉዛ ዛጉታስሶ? አዉኑ ዎስቶታስሶ? ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‹ሙሶነክ ደን ሳማን ቱሻ ባሶክ እምዋ› ይስቴራ ትቼናስማቶ አባኒሳክቶ ዛቦሲ ማንና ሜሴቴዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","የሱስ ኤካ ይ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፥ ሳማኒ ቱሻ እማስ ሙሴቴዋ። ፉቶኒ ቱሻ ሳማን እምኒስ አባታስዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ሀኦሲ ቱሻ ባርኑ ሳማን ኬሬሬ ሀን ዳስታክ ፌ አሱኒክ ደይ ካ እምንርዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ባሶ ደይ፦ «ዳምኒሶ! ኤስ ቱሻሶን ዎንና ዎንናቱ እኖክ እማታዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","የሱስ ባሶክ ኤካ ይ፦ «ካ እምኒ ቱሻስ ታዋ። ታኪ ዮኒ ባር እሳንነ ኣፋ ማክቶና ዉዛ። ታክ አማነፌ ባር ዎንና ዎንና እሳንነ ኣፋ እክቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ስኑንታኖ ታን ቢራ አማኖ ቤይንትሲክ ሀን ባሮን ንቶክ ማኬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","አባታስ እምና ባሶ ዙቴሬ ታኪ ዮሶነዋ። ታኪ ዮሶኒ ባሶትን ደይ እሳንነ ጌራካሎ ኣፋ ክሱና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ታ ሾሌና ባሮን ዛጉናክታዋ፥ ታን ዎሲ ባሳ ሳፋራሶን ዛጉናክቱ ሳማን ኬሬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ታን ዎሲ ባሳ ሳፋራስ ደይ ታክ እምና ባሶትን ዙትራ እሳንነ ትሽኩኖይቴማቶ ማጝሱኒ ካርኒ ዎኖ ክቱን ካብጉናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","አባታሳ ሳፋራ ናስን ቢሬ ባሪክ አማነፌ ባሶ ዙቴሴሬ ኮእባ ፎንቶ ካ ዳኖነክዋ። ኤስ ባሶትንኑ ታ ማጝሱኒ ካርኒ ዎኖ ክቱን ካብጉናዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","አይሁድኒ ሜያ ደይ፦ «ሳማን ኬሬ ካኒ ቱሻ ታዋ» ኡባሲክ ኡኚሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ኤካ ደይ ይሴቴ፦ «ሀኒስ አባባስንናዋ እንቶባሶንና አሪፌኒ ዮሴፍኒ ና የሱስቴኖሶ? ኤኪን ኣካክ፦ ‹ሳማንቱ ኬሬጝዋ› ይፌሶ?» ");
INSERT INTO jnje_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","የሱስ ዎልግሬ ኤካ ይ፦ «ንቶትና ንቶትና ኡኙቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ታን ዎሲ አባታስ ዛታናነታኖ ኦኑ ታኪ ዮክ ኣፋዋ ችማናዉዛ። ታ ማጝሱኒ ካርኒ ዎኖ ባሪን ክቱን ካብጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ራጁኒ ትቻሲ፦ ‹ዙታምቤሲሴ ሀኦኪን አሪር ስኖነዋ› ይስቴራ ትቼዋ። ኤሴኑ አባስኪን ኦዴሬ አሪ ባር ዙቴሬ ታኪ ዮናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ሀኦስኪን ስና ሻካናነ አባስንኑ ብያር ኦኑ ኣፌዋ። አባታስኪን ስና ባር ባርቱ ብያርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ፉቶ ንቶክ ማኬፋውጙዋ፤ ታክ አማነፌ ባር ኮእባ ፎንቶ ካባ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ካኒ ቱሻ ታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","አባንትሳክቶ ኢችማ ዳስ ሲ ማና ሜሴቴ። ስኑንታኖ ክትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ሳማን ኬሬ ቱሻስ ሀኒስዋ፥ ኤስ ቱሻሶን ሙን ባር ኣፋ ክቱና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ሳማን ኬሬ ካ እምን ቱሻ ታዋ። አሱ ሀን ቱሻሶን ሜፋናነ ኮእባ ፎንቶ ካክቱ ፎና። ሀን ዳስ አሱኒክ ካ ስናናክ ታ እማና ቱሻስ አሽናስዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","አይሁድኒ ሜያ ደይ፦ «ሀን አሱስ አሽባሶን እኖክ ኣካክ እማክ ችምንሪንሶ?» ይት ባሶትና ባሶትና ማእስሬ ካራካርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","የሱስ ባሶክ ኤካ ይ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፤ አሱሳ ናኒ አሻሶን ሙ ሻካትነ ሀርንባሶን ደይ ኡሻ ሻካትነ ኤስ ማአ ስና አሽናሶን ንቶ ካኒት ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","አሽናሶን ሜፌ ባርናዋ ሀርናሶን ኡሽፌ ባርና ኮእባ ፎንቶ ካባ ፋርዋ። ታ ኮእባስ ዎኖ ባሪን ክቱኒ ካብጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","አሽናስ ፉቶኒ ሙ፥ ሀርናስ ደይ ፉቶኒ ኡሻዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","አሽናሶን ሜፌ ባርናዋ ሀርናሶን ደይ ኡሽፌ ባርና ታኔንቱ ፎና። ታ ደይ ባርኔንቱ ፎና። ");
INSERT INTO jnje_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ሀየዉ አባታስ ታን ዎሲንናማቶ ታ ደይ ባርኪን ካብ ቾዋ ሀየዉ ስንናማቶ ታ አሻሶን ሜፌ ባር ደይ ታኪን ካብ ቾዋ ሀየዉ ስናና። ");
INSERT INTO jnje_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ሳማን ኬሬ ቱሻስ ሀኒስዋ። አባንትሳክቶ ሳማን ኬሬ ቱሻሶን ሜሴሬ ክትሴቴይሲማቶታዋ። ሀን ቱሻሶን ሜፌ ባር ኮእባ ፎንቶ ካክቱ ፎና።» ");
INSERT INTO jnje_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","የሱስ ክፍርናሆሙክ አሲፌና ካባሲክ ሀን ባሮን አይሁድኒ ሺጶኒ ኬያሲክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ናዎኒ ሜያስን ሾዎቤሲስ ኦደሴፋት፦ «ሀን ባር ችማ ዎላዋ። ኦንሶ ኤጴቶክ ችምንሪ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ስኑንታኖ የሱስ ናዎኒ ሜያ ኤስ ካማሲክ ኡኚሴቴማቶ ንብባሲ አሪፋት ኤካ ይ፦ «ሀን ባር ንቶትን ቱሳእሱኒሮሶ? ");
INSERT INTO jnje_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ኤካ አሱኒ ና ዜምሜ ደን ፌናስታ ሀሚፌን ቢፌቲ ካባሲክ አዉ ኡትስሶ? ");
INSERT INTO jnje_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ካ እምፋስ ሀኦሲ አያናዋ፤ አሱኒ ሁግናስ እሳንነ ኣነ ኬእፋዋ። ታ ማኬና ካማስ ካ እምፋ አያናነዋ ካነዋ። ");
INSERT INTO jnje_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ስኑንታኖ ንቶስን አማኖኖር እሳ እሳር ፌሴቴርዋ» የሱስ ባሶስን አማኖኖር ኦ ስንናማቶናዋ ባሪን ኣትሬ እምኒስ ኦ ስንናማቶና ዜምሜኑ አሪሬ ፌር ስንና ቦርአቱ ኤስ ባሮን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ቱስሬ ደይ፦ «አባስኪን እምቶኖይናሮን ኦኑ ታኪ ዮክ ችምኒር ኣፌ ስንና ቦርአቱ ኤስ ባሮን ማኬጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ኤሴን ኦርፎ ናዎኒ ሜያስን ሾዎቤሲስ ኦርፎ ዎልሴሬ ባርኔን አነ ኣነ ሀሞቶ። ");
INSERT INTO jnje_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","የሱስ አሲሬ ሄፔ ናዎባሳክቶኒን፦ «ንቶ ደይ ዎላ ሀማቲክ ሾሌፌትዮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ስሞን ጴጥሮስ፦ «ዳምታሶ፥ ኦኪ ዎላ ሀማንሪንሶ? ኔኪክ ኮእባ ፎንቶ ካ እምፋ ካማ ፋር። ");
INSERT INTO jnje_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ነ ኮርቶ ሀኦሲ ና ስንታማቶ አማነኒ ደይ አሪንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","የሱስ ዎልግሬ፦ «ንቶ አሲሬ ሄፔስን ኮሪስ ታቴኖሶ? ንቶስን እሳይስ ዳቡሎስዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ኤስ ይና ባር ደይ ስሞንኒ ና ስና አስቆሮትኪ ዩዳንጝዋ። አሲሬ ሄፔ ናዎሳስን እሳይስ ስንፌናክኑ ኣትሬ እምኒስ ባር ስንና ቦርአቱ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ኤሴን ኦርፎ አይሁድኒ ሜኒ አእስኛኒ ሜያ የሱስኒን ዎሩክ ሾልሴት ፌሴቴር ስንና ቦርአ ዩዳኒ ዳስታክ ዎል ሌ ሀማሶን ቤይፋት ጋሊላኒ ዳስታክ ኩቲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","አይሁድኒ ሜኒ ሀፎኒ ሄቦስ ታእሴራ ፋር። ");
INSERT INTO jnje_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ኤስታን ባሳ አይኒ ሜያ፦ «ነ ናዎሳክቶ ዛግፋታ ዎስቶሶን ብዮሶነክ ሀንታን ካብራ ዩዳኪ ዳስታ ሀምማ! ");
INSERT INTO jnje_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","አምማኖን አሪቶክ ሾሌፌ አሱ ዎስቶባሶን ኣቾክ ዎስቴፌር ኣፌዋ። ነ ደይ ሀን ዉዛሲክቶኖን ዛግፋታነ ቴትኔሶን ሀን ዳሲ አሱኒክ አምማኖን ቤሱታዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ኤስ ባሮን ይሴቴስ አይባሳክቶኑ ባርክ አማኖ ቤየቴ ቦርአ። ");
INSERT INTO jnje_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","የሱስ ባሶክ ኤካ ይ፦ «ታ ዎናስ ሀሽኑ ኣነ ካርአዋ። ስኑንታኖ ንቶ ዎናስ ዎንና ዎንና ማአ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ሀን ዳስ ንቶትን ኦምቶና ኡግና ኣፋ። ስኑንታኖ ታ ዎስቶቤሲስ ማጙ ስንባሶን ማኬት ፋናር ስንና ቦርአቱ ታን ኦምቴሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ንቶ ደን ሄቦስኪ ሀሚትዋ፤ ታ ዎናስ ሀሽነ ኣነ ካርአ ስንና ቦርአ ደን ሄቦስኪ ኣፋዋ ሀማና ዉዛ» ");
INSERT INTO jnje_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ኤስ ባሮን ማኬፋት ጋሊላክ ፉእቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ስኑንታኖ አይባሳክቶ ሄቦኒ ድማስታ ሀሜቴኔን ኦርፎ የሱስ ደይ አምማኖን ስኖይናማቶ ኣቸሬ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","አይሁድኒ ሜያ፦ «ባርኪ አይንሶ?» ይሴት ሄቦስኪ የ አሱሳ ጋነሲ ሾልሴቴ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ዳራሳ ጋነስንኑ ባሳ ቾዋሲክ አካማኖን ኡኝቸድፋር። እሳ እሳይስ፦ «ባር ማአ አሱዋ» ይ። ኦሚስ፦ «ኣነዋ! ዳራስን ኤሻርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ስኑንታኖ አይሁድኒ ሜኒ ጋኝኜ ሜያኖን ድግሴቴ ቦርአ ኦኑ ባሳ ቾዋሶን አምማኖን ኣነ ዎሎዌ። ");
INSERT INTO jnje_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","የሱስ ሄቦሲ ጋነታክ ደን ቤቴሜቅደሲሲ ሀምሜ አሱ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","አይሁድኒ ሜያ፦ «ሀን አሱስ አስሲኛኒ ሜያኪን አሩኖይናሮን ትቻሶን ኣካክ አሩክ ችምሶ?» ይት ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","የሱስ ዎልግሬ ኤካ ይ፦ «ታ አሲፋና ባርኑ ታኪንታዋ፤ ታን ዎሲ ሀኦስክጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ባሳ ፍቃዲሶን ዛጉክ ሾሌፌር ፌፋናነ ሀን አሱስ ሀኦኪን ወደይ ታ ቴታስኪን ስንባሶን አሩክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ባሳ ቴታስን ማኬፌ ባር ቴትባሪ ኡልፍናሶንቱ ሾሌፌዋ። ስኑንታኖ ዎሲ ባሳ ኡልፍናሶን ሾሌፌ ባር ፉቶኒርዋ። ባሳሲ ደይ ኤሻ ዉዛ ኣፋ። ");
INSERT INTO jnje_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ሙሴ ቱማሶን ንቶክ ኣነ እሜኖሶ? ስኑንታኖ ንቶስን ቱማሶን ዛግፌር እሳንነ ኣፌዋ። ታን ዎሩክ አዉኒሮን ሾሌድፌትሪንሶ?» ");
INSERT INTO jnje_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ዳራስ ዎልግሴሬ፦ «ኪና አያና ነይስሲ ፋርዋ! ደይ ኔን ኦንሶ ዎሩክ ሾሌዲፌሪ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","የሱስ ባሶክ ዎልግሬ ኤካ ይ፦ «እሳ ቢስቴራ አሪቶኖይ ዉዛ ዛግና ንቶ ዙቴራ ዲንቀሴቲ። ");
INSERT INTO jnje_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ሙሴ ሃርኮኒ ኩኑሱኒ ቱምሶን ንቶክ እምዋ። ኤስ ቱማስ ደይ ያናስ አባን ሜያኪንታኖ ሙሴኒኪንታዋ። ንቶኑ ደይ ቤይሳኒ ዎናክ ናንጎታ ሃርኮ ኩንስፌቲ። ");
INSERT INTO jnje_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ኤሴ ሙሴኒ ቱማስ ሻርቶኖይናማቶ ቤይሳኒ ዎናክ ናንጎታ ሃርኮ ኩኒር ስንናኔን ታ አሱኒን ቤይሳኒ ዎናክ ፋትና ቦርአ ታይስታ አዋጋን ግእቴፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ፉቶኒ ማጝሱኒ ካርአ ካርቲታኖ አሱኒ ስንኒ ብያክ ማጝሱ ካርአቲታዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ኤስ ካባ የሩሳለሙክ ፌሴ እሳ እሳ አሱኒ ሜያ ኤካ ይሴቴ፦ «ዎሩክ ሾልሴፌስ ሀን ባርቴኖሶ? ");
INSERT INTO jnje_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ኤሴኑ ባር ሀን አምማኖን ማኬድፌዋ፥ እሳ ዉዛነ ኣነ ማክሶቶዋ። ጋኝኘ ሜያኑ ሀን አሱስ ክርስቶስ ስንናማቶ ፉቶክ አርሴቴታሶ? ");
INSERT INTO jnje_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ስኑንታኖ ሀን ባር ኮንቴና ዳስ አይ ስንናማቶ አርኒርዋ። ክርስቶስ ዬፌና ካባሲክ አይን ስንናማቶ ኦኑ ኣፋ አሩና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","የሱስ ቤቴሜቅደሲሲ አሲፌና ካባሲክ ካምባሶን ቴግሬ ኤካ ይ፦ «ታን ፉቶክ አርሴቲርዋ፤ አይን ያናማቶ ደይ አርሴትርዋ፤ ታ ቴትናክ ኣነ ዮትዋ። ስኑንታኖ ታን ዎሲ ባር ንቶ አሩኖይትሮን ፉእቶኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ባርኪን ያና ቦርአናዋ ባር ታን ዎሲና ቦርአናቱ ታ ባሪን አሪፋውጙዋ» ");
INSERT INTO jnje_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ኤስ ባሪ ቦርኣ ኤጶሶነክ ሾልሴት ፌሴቴር። ስኑንታኖ ባር ኦቶና ዎናስ ኣነ ካርአ ስንና ቦርአ ኦኑ ኤጳክ ኩሹባሶን ኣነ ሾዌ። ");
INSERT INTO jnje_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ስኑንታኖ ዳራሳስን ሾዎቤሲስ ባሪክ አማነሴቴ። ደይ፦ «ኤኪን ክርስቶስ ዬፌና ካባሲክ ሀን ባር ዛግና ቢስቴራ አሪቶኖይ ዉዛሲ ደናሎ ዛጉንጌሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ፌርሳዊኒ ሜያ ባሳ ቾዋሶን ዳራስ ኡኚሴፌን ኦደሴቴ። ማግኒ ጋኝኜ ሜናዋ ፌርሳዊኒ ሜና የሱስኒን ኤጴ ዮሶነክ ቤቴሜቅደስኒ ታሶኒ ሜያኖን ዎሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","የሱስ ደይ ኤካ ይ፦ «ንቶኔን አነ ፎናስ ጋሮ ዎኒሮጝዋ፤ ኤስታን ታን ዎሲ ባርኪ ሀማናርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ንቶ ታን ሾሎቲ፤ ኣፋ ዳናት ዉዛ፤ ታ ፋናስታ ዮክ ኣፋ ችማት ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","አይሁድኒ ሜያ፦ «እንኖ ባሪን ዳንኖይኒ ድማ አይ ሀምንሪንሶ? አዉዛክነ ግሪክኒ ሜኒ ጋነያስ ሲክቴሬ ፌ አይሁድኒ ሜያኪ ሀምሜ አዛብኒ ሜያኖን አሱኒቶጝዋ? ");
INSERT INTO jnje_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹ንቶ ታን ሾሎቲ፤ ኣፋ ዳናት ዉዛ። ታ ፋናስታ ዮክ ኣፋ ችማትዉዛ› ይና ካማስ ኣምባንሶ?» ይት ባሶትና ባሶትና ዎሉምሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ሄቦሲ ኮእኒ ዎኖቲ አርክ ዎናስታ የሱስ የሬፋት ካምባሶን ቴግሬ፦ «ኦኑ እክቴር ፌፋናነ ታኪ ዬፋት ኡሾዋ። ");
INSERT INTO jnje_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ታን አማነፌ ባር ትቻስ ማኬናሲማቶ ካኒ አካኒ ኮርአ ባሳ ንባስን ኬሳናዋ» ይት ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","የሱስ ኤስ ባሮን ማኬናስ ባርክ አማነፌ ባሶ ኤጴቶሶነክ ፋ ሀኦሲ አያናኒ ቾዋሲክዋ። የሱስ ኣነ ኡልፍንቶዌ ስንና ቦርአ ኮርቶ አያናስ ኣነ ኬሮዋ። ");
INSERT INTO jnje_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ዳራሳስን እሳ እሳ ሜያ ኤስ ካማሶን ኦደሴቴይሴ፦ «ሀን ባር ፉቶክ ራጁሶሶ!» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ኦሚስ ደይ፦ «ሀን ባር ሙድቶስዋ» ይሴቴ። ስኑንታኖ ኦሚስ፦ «ክርስቶስ ጋሊላን ኣፋዋ ዮናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ሙድቶስ ዳዊትኒ ዛላስን ኮኒቶናማቶናዋ ዳዊት ፌፌና ካታማ ቤቴለሙን ዮናማቶና ትቻሲ ኣነ ትቾዋኖሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ኤስ ባሪ ቦርኣ ባሳ ቾዋሲክ ዳራሳ ጋነሲ ኦር ኦር ኬሳ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","እሳ እሳይስ ባሪን ኤጳክ ሾልሴቴ። ስኑንታኖ ኤጳክ ኩሹባሶን ባሳስታ ሾር ኦኑ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ኤስታን ቤቴሜቅደስሲ ታሶኒ ሜያ ማግኒ ጋኝኜ ሜያክናዋ ፌርሳዊኒ ሜያክና ዎል ሌ ሀሜቴን ኤካ ይሬ ማሙሴቴ፦ «አዉኒ ቦርአ የሱስኒን ኤጳ ዮ ቤየትሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ቤቴሜቅደስሲ ታሶኒ ሜያ፦ «ኤስ አሱስ ዎል ሌፌናሲማቶ ዎል ሌር ኦኑ ኣፌዋ» ይሬ ዎሉግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ፌርሳዊኒ ሜያ ደይ፦ «ንቶ ደይ ኤሽቴትዮሶ? ");
INSERT INTO jnje_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ሀእሲፌ ባሶስናዋ ፌርሳዊኒ ሜያስና ባርክ አማነር ፌሴቴርታሶ? ");
INSERT INTO jnje_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ሀን ሙሴኒ ቱማሶን አሩኖይ ዳራስ ኤርዉቶዋ» ");
INSERT INTO jnje_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ፌርሳዊኒ ሜያስን ዜሞ ስናክ የሱስኒኪ ሀማ ንቆድሞስ ይስቴፌ ባር፦ ");
INSERT INTO jnje_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«እንኖ ቱማስማቶ ዜምሜ እሳ አሱ ማላቴና ማላታስ ኦድቶኖይፌንናዋ አዉ ዛግናማቶ አሪቶኖይፌንና ማጝሱ ኣነ ካቴፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ባሶ ደይ ዎልግሴሬ፦ «ነ ደይ ጋሊላኪርኖሶ? ራጁ ጋሊላን ኣፋ ካቡና ዉዛ ስንናማቶ ትቻሶን ቱእኒራ አሩዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ኤስታን እሳ እሳርቤሲስ ኬቤሲ ኬቤሲ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ኤስታን የሱስ ዳብራዛይትኒ ኩማስታ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ዎኖትሪ ዎኖ ኤሶ ቤቴሜቅደሲሲ ዎል ሌ የ። ዳራስ ዙቴሬ ባርኪ ዬሴቴ። ባር ደይ ዲፋት ባሶትን አሲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ሙሴኒ ቱማሲ አስሲኛናዋ ፌርሳዊኒ ሜና ጌርኬስፌን ኦቴ ማሽካሱ ቴሸሴሬ ዳራ ዙታምባሴ አሲ ስና ዬትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","የሱስኒክ ደይ ኤካ ይሴቴ፦ «አስሲኛኖ! ሀን አሱስ ጌርኬስፌን ኦቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","እኖክ እምቴ ቱማስ ኤስ ኤካ ዛግፋ አሱስ ሹአክ እቼራ ክቱናክ ሙሴ አጃጀዋ። ነ ሀን ባሪ ቾዋሶን አዉ ኡታስሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ኤስ ባሮን ኤካ ይሴቴስ ባርኪን ማላቶኒ ቾዋ ዳንነ ፋታኖሶነክ ሾልሴፋትዋ። ስኑንታኖ የሱስ ሙግሬ ኩሹባሲ ዋይአክ ዳስታክ ትቹ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ሄፓ ሄፓ ዎልግሬ ማሙሶቤሲሴ ካንነ፦ «ንቶስን ቦርእባ ፎንቶስ ቴሱኒ ሹኣሶን ባሪስታ ሀእሬ እቾዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ሄፕሳ ደይ ሙግሬ ዳስታክ ትች። ");
INSERT INTO jnje_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ባሶ ደይ ኤስ ባሮን ኦደሴቴይሴ ኩርኡሳታን ካብሬ ናኦሳታ ካርኤ እሳ እሳርቤሲስ ኤስታን ሀሜቴ። የሱስ ደይ ዳራ ዙታምባሴ አሲ ስና የሬ ማሽካሱስኔን የሱስኔን ኤስታ ፉእቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","የሱስ ካንነ፦ «ሀን አሱሴ፥ ኔን ማላቴ ባሶ አይ ፌሴቴሴ? ነይስታ ማጝሱ ካርአር እሳንነ ኣፌኖሴ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","አሱስ ደይ፦ «ዳምታሶ! እሳንነ ኣፌዋ» ይ። የሱስ ደይ፦ «ታ ደይ ነይስታ ኣፋዌ ማጝሱ ካርአናዉዛ፤ ሀምሜ፤ ሀውጙኔን ኤካሎ ጌርኬሳታታዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ሄፕሳ ደይ የሱስ ባሶክ፦ «ታ ሀን ዳስታክ ፌ አሱሲክ ቻሬፋዋ። ታኪ ዬፌ ባር ዙታምባሴ ካ እምፋ ቻሬፋሶንቱ ዳናናታኖ ታልማሲ ኣፋ ፎና ዉዛ» ይሬ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ፌርሳዊኒ ሜያ ደይ፦ «ነ ነ ቴታሲክቱ ዛላ ማኬፋትዋ፤ ኤስ ማኬታ ዛላስ ፉቶታዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","የሱስ ዎልግሬ ባሶክ ኤካ ይ፦ «ታ ታ ቴታሲ ቾዋኖን ዛላ ማኬፋናነ አይን ያናማቶናዋ አይ ሀማናማቶና አሪፋኒ ስንና ቦርአ ዛልናስ ፉቶዋ። ስኑንታኖ ንቶ አይን ያናማቶናዋ አይ ሀማናማቶና ኣነ አሪፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ንቶ አሱኒማቶቱ ማጝሱ ካርፌቲ። ታ እሳ አሱኒታኑ ማጝሱ ኣፋ ካርአናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ማጝሱ ካርፋናክኑ ታን ዎሲ አባስ ታኔን አነቱ ፌ ስንና ቦርአናዋ ማጝሱ ካርፋና ካባሲክ ደይ ታ ታ ስና ቤይና ቦርአና ኤስ ማጝሱኒ ካርናስ ፉቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ሄፕ አሱ ማኬና ዛላ ፉቶ ስንናማቶ ንቶ ቱማሲ ትቼራ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ኤስ ባሪ ቦርኣ ታ ቴታሲሮን ታቱ ዛላ ማኮኒርዋ። ታን ዎሲ አባታስ ደይ ታ ቾዋሲክ ዛላ ማኮናዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ባሶ ደይ፦ «ኤኪን አባኔሲን አይንሶ?» ይሴቴ። የሱስ ዎልግሬ፦ «ታን ወደይ አባታስን ፉቶክ ኣነ አሪሴፌትዋ። ታን አርሴት ስንፋናነ አባታስን ደይ አሩት ካባዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","የሱስ ሀን ካማሶን ማኬና ቤቴሜቅደሲሲኪ ዋጋ ዙቴፋና ሳጥኒሲ ቴሻ ዲፋት አሲፌትዋ። ስኑንታኖ ባር ኦቶና ዎናስ ኣነ ካርአ ስንና ቦርአ ኦኑ ባሪን ኣነ ኤጴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","የሱስ ደይ ሄፕሳ፦ «ታ ሀማናርዋ፤ ንቶ ደይ ታን ሾልሶትዋ። ስኑንታኖ ቦርንትሲክ ክቱትር፤ ታ ሀማና ድማሲ ንቶ ዮትክ ኣፋ ችማት ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","አይሁድኒ ሜያ፦ « ‹ታ ሀማና ድማስታ ንቶ ዮሶትክ ኣፋ ችማት ዉዛ› ኡባስ ባር ባሪን ዎሩኒቴሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ባር ደይ ኤካ ይ፦ «ንቶ ሀን ዳስታኪር፤ ታ ደን ሳማኪርዋ። ንቶ ሀን ዳስታኪር፤ ታ ሀን ዳስታኪርቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ኤስ ባሪ ቦርኣቱ፦ ‹ንቶ ቦርንትሲክ ክቱትርዋ› ይራ ማኬጝዋ። ታ ኦ ስንናማቶ አሪራ አማኖ ቤይፋትነ ቦርንትሲክ ክቱትርዋ» ይጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ባሶ ደይ፦ «ኤኪን ነ ኦንሶ?» ይሴቴ። የሱስ ዎልግሬ፦ «ዜምሜኔን ማኬት ፌይስ ታ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ንቶስታ ሾዎ ማኮና ዉዝነዋ ሾዎ ማጝሱ ካርአና ዉዝነ ፋርዋ። ስኑንታኖ ታን ዎሲ ባር ፉቶኒርዋ። ታ ደይ ባርኪን ኦደና ባሮን ሀን ዳስታኪ አሱኒክ ማኬፋውጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","አባሳ ቾዋኖን ማኬናማቶ ባሶ ኣነ አሪሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ኤስ ባሪ ቦርኣ የሱስ ኤካ ይ፦ «ንቶ አሱኒ ናኒን ደን ቴግፌት ካባሲክ ታ ባር ስንናማቶ አሩትዋ። ኤሲስማቶ ደይ አባታስ ታክ አሲና ባሮንቱ ማኬፋንታኖ ታ ታኪን እሳ ዉዛነ ኣነ ዛግፋት ስኒባሶን ያዳቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ታን ዎሲ ባር ታኔን አነዋ። ታ ዎንና ዎንና ዛግፋናስ ባሪን ግርሱክ ስንና ቦርአ ታን ታን ኣነ ቤየዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","የሱስ ኤስ ዉዛሲክቶኖን ማኮባሴ ሾዎቤሲስ ባሪክ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","የሱስ ባርክ አማነሴ አይሁድኒ ሜያክ፦ «ታ ካማሲክ ፋፋትነ ፉቶክ ንቶ ታ ናዎዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ፉቶሶን ደይ አሩትዋ፤ ፉቶስ ደይ ብርማዱምማ ንቶትን ክሱናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ባሶ ዎሉግሴሬ፦ «እንኖ አብራሀምኒ ዛላዋ፤ እሳ አሱኒክኑ እሳንነ ቦዝ ኣነ ስንነንዋ፤ ኣካክ ነ እኖትን ‹ቦዞስን ኬሳትርዋ› ይፋትሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","የሱስ ዎልግሬ ኤካ ይ፦ «ፉቶክ ንቶ ማኬፋውጙዋ፤ ቦርኣሶን ዎስቴፌ ባር ዙቴሬ ቦርእኒ ቦዝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ቦዝ ዎንና ዎንና ኬር ኣነ ዲፌዋ። ናስቱ ዎንና ዎንና ኬር ፌፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ኤሴ ናስ ብርማዱምማ ኪሳናነ ፉቶክ ብርማዱምማ ኬሳቲ። ");
INSERT INTO jnje_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","አብራሀምኒ ዛላ ስንትሶን አሪፋውጙዋ፤ ስኑንታኖ ካምናሶን ኤጳ ቶ ቤየቲ ቦርአ ታን፤ ዎሩትክ ሾሌፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ታ አባታስኪን ቢና ባሮንቱ ማኬፋን፤ ንቶ ደይ አባንቲስኪን ኦደቲ ባሮንቱ ዛግሴፌት።» ");
INSERT INTO jnje_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","አይሁድኒ ሜያ ደይ ባርኪ፦ «እንኖ አባ አብራሀምዋ» ይሴቴ። የሱስ ዎልግሬ ባሶክ፦ «አብራሀምኒ ናንጎታ ስነት ስንፋናነ አብራሀም ዛግፌናሲማቶ ዛጉት ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ታ ሀኦስኪን ኦደና ፉቶሶን ንቶክ ማኬን። ስኑንታኖ ንቶ ታን ዎሩክ ሾሌፌት። አብራሀም ደይ ኤካ ኣነ ዛጉዌ። ");
INSERT INTO jnje_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ንቶ አባንትሳ ዎስቶኖንቱ ዎስቴፌትዋ» ይ። ባሶ ደይ፦ «እንኖ ጌርኬሳክ ኣነ ኮንቶዌንዋ። እሳ አባን ፌርዋ፤ ኤስ ባር ደይ ሀኦስዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","የሱስ ደይ ኤካ ይ፦ «ሀኦሲ አባንት ስኒ ስንፋናነ ታን ሹናቲ ካባዋ። ታ ሀኦስኪን ያና ቦርአ ሀኦስቱ ታን ዎሲርታኖ ታ ቴትናክ ኣነ ዮትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","አዉኒ ቦርአንሶ ታ ዎላሶን ጋሳሱ ቤይፌት? ካምናሶን ኦዶክ ኣነ ሾሌፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ንቶ አባንት ስና ዳቡሎስኒ ናንጎትዋ። አባንት ሾሌፌና ባሮንቱ ዛጉክ ሾሌፌት። ባር ዜምሜኔን ካ ዎሪር። ፉቶ ባርኪክ ኣፋ ስንና ቦርአ ፉቶክ ኣነ የሬፌ። ባር ኤሽኛ፥ ኤሽኒ አባ ስንና ቦርአ ኤሻ ዎል ሌፌና ካባሲክ ቴትባስንቱ ኪሲሬ ዎል ሌፌ። ");
INSERT INTO jnje_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ስኑንታኖ ታ ፉቶ ዎል ሌፋና ቦርአ ንቶ ኣነ አማነፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ንቶስን፦ ‹ቦርአ ዎስቴትዋ› ይሬ ታን ዌኦክ ችምኒር ኦንሶ? ታ ፉቶ ዎል ሌናር ስንፋናነ አዉኒሮን አማኖ ቤይፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ሀኦስኪን ስና ባር ሀኦሲ ካማኖን ኦደር። ንቶ ሀኦስኪን ስና ቤይቲ ቦርአ ኣነ ኦደፌት» ");
INSERT INTO jnje_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","አይሁድኒ ሜያ ዎልግሬ፦ « ‹ነ ሳምራዊዋ፥ ኪና አያና ደይ ነይስ ፋርዋ› ኡኒስ ፉቶታኖሶ ማኬንሪ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","የሱስ ዎልግሬ ኤካ ይ፦ «ታይሲ ኪና አያና ኣፋዋ። ታ አባታስን ኡልፍንስናር፤ ስኑንታኖ ንቶ ታን ካሽትር። ");
INSERT INTO jnje_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ስንፋናክኑ ታ ቴትናሪ ኡልፍናሶን ኣነ ሾሌፋት። ታ ኡልፍናሶን ሾሌፌርናዋ ማጝሱ ካርኒርና ኦም ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ፉቶ ንቶክ ማኬፋውጙዋ፥ ካምናሶን ኦድፌ ባር እሳንነ ኣፋ ክቱና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","አይሁድኒ ሜያ፦ «ነይስ ኪና አያና ፋናማቶ ሀየ አሪንዋ። አብራሀምኑ ክትዋ፤ ራጁኒ ሜያ ደይ ክትሴቴዋ። ስኑንታኖ ነ፦ ‹ካምናሶን ኦድፌ ባር እሳንነ ኣፋ ክቱና ዉዛ› ይፋት። ");
INSERT INTO jnje_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ነ ኪት አባን አብራሀምኒስታን አሪኩታሮሶ? ራጁኒ ሜያ ክትሴቴ። ኤኪን ነ ቴትኔሶን ኦ ኡታስሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","የሱስ ዎልግሬ፦ «ታ ቴትናሶን ኡልፍንስፋናነ ሽማቱ ስናናዋ። ታን ኡልፍንሱኒስ ንቶ፦ ‹ሀኦኒዋ› ይሴፌት አባታስዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ንቶ ባሪን ኣነ አርሴፌትዋ፤ ስኑንታኖ ታ ባሪን ማእስራ አሪናርዋ። ኣነ አሪፋትዋ ይፋናነ ንቶስማቶ ኤሽኛቱ ስናናዋ። ስኑንታኖ ታ ባሪን ማእስራ አሪናርዋ፤ ካምባሶን ደይ ኦድናርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ንቶ አባንት ስና አብራሀም ታ ዎናሶን ቢሬ ግሮናክ አካማኖን ሾልይት ፌር፤ ደይ ቢሬ ግሬ» ");
INSERT INTO jnje_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","አይሁድኒ ሜያ ደይ፦ «ነ ኡቻስር ዎጋነ ካርእኖይፌን አብራሀምኒን ቢቶሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","የሱስ ደይ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፤ አብራሀም ኮንቶኖይ ፌን ታ ፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ኤስታን ባሪን እቻክ ሹአ ካቡግሴቴ፤ ስኑንታኖ የሱስ ኣቸሬ ቤቴሜቅደሲሲን ኬሴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","የሱስ ኡጉንነ ሀምፌት ኣፍትሹ ስንነ ኮንቴ አሱንን ቢ። ");
INSERT INTO jnje_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ናዎኒ ሜያ፦ «አስሲኛኖ! ሀን አሱስ ኣፍትሹ ስንነ ኮንቴናስ ኦ ዎስቴና ቦርእኣሲኪንሶ? ባር ዎስቴና ቦርአሲክጝዋ ወደይ ባሪን ኮኒ አባ እንቶስ ዎስቴሴቴ ቦርእኣሲኪንሶ?» ይሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","የሱስ ኤካ ይሬ ዎልጊ፦ «ሀን አሱስ ኣፍትሹ ስንነ ኮንቴናስ ባር ወደይ ባሪን ኮኒ አባ እንቶስ ዎስቴሴቴ ቦርእኣሲክታዋ። ሀኦሲ ዎስቶ ባርኪ ካሞ አምማኖን ኬስሳ ቤስቶናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ዎናስ ቻሬፍባሴ ፌን ታን ዎሲ ባሳ ዎስቶኖን ዎስቶናክ ሾልስፋዋ። ኦኑ ዎስቶክ ችምኖይና ታልማ ዮኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ሀን ዳስታክ ፋና ካባሲክ ታ ሀን ዳሲ ቻሬፋዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ኤስ ባሮን ማኬፋት ዳስታክ ቱጀሬ ሆአ ቱሽሬ ሃርኣሲክ ኣፍትሹሳ ኣፋኖን ዎሻት፦ ");
INSERT INTO jnje_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","«ኤክ ሀምፋት ስሎም ይስቴፋ ኩጲራ ኩኒ አካሲ ማሶዋ» ይ። ስሎም ኡሲ ኮታ ደይ፦ «ዎስቴሬ ሀማር» ኡ። ኤስ ባሪ ቦርኣ ሀምሜ ደይ ማሴሬ ብየት ዎል ሌ የ። ");
INSERT INTO jnje_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ስናቲ ካባሲክ ሺጴፌን ብየ አሱኒ ሜናዋ ዎልኮባሳክቶና፦ «ሀን አሱስ ዜሞ ስናክ ዲፋት ሺጴፌን ቢኒ ባርቴኖሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","እሳ እሳይስ፦ «ባርዋ» ይሴቴ። ኦሚስ ደይ፦ «እንዳነዋ፤ ግቶባስቱ ባርነ ፌርዋ» ይሴቴ። አሱስ፦ «ኤስ ኣፍትሹስ ታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","አሱኒ ሜያ ደይ፦ «ኤኪን ኣፍኔስ ኣካክ ብያክ ችምሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ባር ዎልግሬ፦ «የሱስ ይስቴፌ አሱስ ሆአ ቱሽሬ ሃርኣሲክ ኣፍናሶን ዎሻት፦ ‹ስሎም ይስቴፋ ኩጲራ ኩኒ አካሲ ሀምማ ማሶዋ› ይን፤ ሀምማ ማሴራ ቢጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","«ኤስ አሱስ አይንሶ ፌናሪ?» ይሴቴ። ባር ደይ፦ «አይ ፌናማቶ ኣነ አሩትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ኤስታን አሱኒ ሜያ ስናክ ኣፍትሹ ስንነ ፌ አሱስን ኤጴሬ ፌርሳዊኒ ሜያኪ ታሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","የሱስ ኤስ አሱሳ ኣፋኖን ሆአ ቱሽሬ ሃርኣሲክ ዎሽሬ ፋትናስ ቤይሳኒ ዎናሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ፌርሳዊኒ ሜያ፦ «ኣካክ ብያክ ችምሶ?» ይሬ ሄፕሳ አሱስን ማሙሴቴ። ባር ደይ፦ «ኣፍናሶን ሆአ ቱሽሬ ሃርኣሲክ ዎሽንቱ ማሴራ ብያክ ችምጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ፌርሳዊኒ ሜያስን እሳ እሳይስ፦ «ሀን አሱስ ቤይሳኒ ዎናሶን ኣነ ኦድፌ ስና ቦርአ ሀኦስኪን ዬርቴዋ» ይሴቴ። ኦሚስ ደይ፦ «ቦርእባ ፌና አሱ ኤፋቴና ቢስቴራ አሪቶኖይ ዉዛ ኣካክ ዛጉክ ችምንሪንሶ?» ይሴቴ። ባሶ ጋነያሲ ደይ ኦር ኦር ኬሳ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ኤስ ባሪ ቦርኣ ፌርሳዊኒ ሜያ ስናክ ኣፍትሹ ስንነ ፌ አሱስን፦ «ኣፍኔስ ብያናክ ዛግ አሱሳ ቾዋኖን ነ አዉ ይፋስሶ?» ይት ደይ ማሙሴቴ። ባር ዎልግሬ፦ «ራጁዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","አይሁድኒ አእስኛኒ ሜያ ኤስ አሱስ ኣፍትሹ ስንናማቶናዋ ኦርፎ ደይ ቢናማቶና ባሳ አባስንናዋ እንቶሶንና ቴግሴሬ ማሙሶነኔን ኣነ አማኖሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","አባስናዋ እንቶሴ አስን ቴግሲሬ፦ «ኣፍትሹ ስንነቱ ኮንቴ ይሴፌት ንቶ ናስ ሀኒስቴኖሶ? ኤኪን ሀሽ ኣካክ ብያክ ችም?» ይሴሬ ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","አባስናዋ እንቶሴ ዎሉግሴሬ፦ «ሀኒስ እንኖ ናዋ፤ ኣፍትሹ ስንነ ኮኒቶባሶንቱ አሪፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ስኑንታኖ ሀሽ ኣካክ ቢናማቶናዋ ኣፋሶን ኦ ፋትናማቶና ኣነ አሪፌንዋ። ባር ቴትባ ችም አሱዋ፤ ባሪን ማምሱትዋ። ባሳ ቾዋሶን ባር ማኮናዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","«ክርስቶስዋ» ይሬ ማኬ አሱ ፌፋናነ አይሁድኒ አእስኛኒ ሜያ አይሁድኒ ዙቶኒ ኬያስን ካሌ ኪሶነክ ዜምሜ ሜርኬሴሬ ፌሴቴር ስንና ቦርአ ባሶትን ድግሴፋቱ ኤካ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ኤስ ባሪ ቦርኣቱ አባስናዋ እንቶሴ፦ «ባር ቴትባ ችም አሱዋ፤ ባሪን ማምሱት» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ኤስታን ስናክ ኣፍትሹ ስንነ ፌ አሱስን ሄፕሳክ ቴጌሴሬ፦ «ነ ፉቶሶን ማኬራ ሀኦሶን ኡልፍንሱዋ። ሀን አሱስ ቦር ስንባሶን እንኖ አሪፌንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ስናክ ኣፍትሹ ስንነ ፌ አሱስ ዎልግሬ፦ «ቦእርባ ፋርቶ ኣፋቶ ኣነ አሪፋትዋ። ታ አሪፋናስ ስናክ ኣፍትሹ ስንናሴዋ ሀሽ ደይ ብያክ ችምናሴ ኮእባዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ባሶ ደይ፦ «ኣምባንሶ ኔክ ዛግናሪ? ኣካኪንሶ ኣፍኔሶን ፋትናሪ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ባር ዎልግሬ፦ «ዜምማ ንቶክ ማኬጝዋ፤ ኦዶክ ኣኔ ሾሎዌት። ሄፕሳ አዉኒሮን ኦዶትክ ሾሌትሶ? ንቶ ደይ ባሳ ናዎ ስናትክ ሾልሴድፌትሮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ባሪን ሜኤት፦ «ነቱ ባሳ ናዎቴኖ እንኖ ሙሴኒ ናዎዋ። ");
INSERT INTO jnje_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ሀኦስ ሙሴኔን አኔ ዎል ሌናማቶ እንኖ አሪፌንዋ። ስኑንታኖ ሀን አሱስ አይን ስንናማቶ ኣነ አሪፌንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","አሱስ ዎልግሬ ኤካ ይ፦ «ሀን አሱስ አይን ስንናማቶ አሩ ሻኩንትስ ዲንቂ ቾዋዋ፤ ስኑንታኖ ኣፍናሶን ፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ሀኦሶን ድጌፌ ባርናዋ ሳፋራባሶን ደይ ዛግፌ ባርና አስን ሀኦስ ኦደርዋ። ስኑንታኖ ቦእርባ ፋና ባሪን ኣነ ኦደፋ ስንናማቶ አርቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ኣፍትሹ ስንነ ኮንቴ አሱኒ ኣፋ ኦኑ ፋትድፌን ዳ ቴስቴናኔን ካብራ ኣነ ኦድቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ሀን አሱስ ሀኦስኪን ስና ሻኪ ስንፋናነ እሳ ዉዛነ ዛጉናክ ኣፋ ችማናዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ባሶ ደይ፦ «ቦርአክ ኮንቴ ነ እኖትን አስሱታሮሶ?» ይሴፋት አይሁድኒ ሺጶኒ ኬያሲ ጌራካሎ ካሌ ክሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","የሱስ ፋሪ አሱስን አይሁድኒ ሺጶኒ ኬያሲ ጌራካሎ ካሌ ክሴሴቴማቶ ኦደ። ደይ ዳንነ፦ «አሱኒ ናንክ አማነፋቶሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ባር ዎልግሬ፦ «ዳምታሶ! ባርክ አማኖናክ ባር ኦንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","የሱስ ደይ፦ «ስና ዜምማ ቢትዋ፤ ሀሽ ደይ ነኔን አነ ዎል ሌፌስ ታ ባርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","አሱስ ደይ፦ «ዳምታሶ! አማኖናዋ» ይት ባርክ ሳጋደ። ");
INSERT INTO jnje_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","የሱስ ደይ፦ «ታ ሀን ዳስታ ያናስ ማጝሱኒ ካርአክዋ። ኣፍትሹ ስና ባሶ ብዮነክ፤ ቢዲፌኒ ይሴፌ ባሶ ደይ ኣፍትሹ ስኖቤሲሶን ቤሱክዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ኤስ ካባሲክ ቴሽባ የርሴ እሳ እሳ ፌርሳዊኒ ሜያ ኤስ ባሮን ኦደሴሬ፦ «ኤካን እንኖ ደይ ኣፍትሹኖሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","የሱስ ደይ ዎልግሬ፦ «ኣፍትሹ ስንነፋትነ ንቶክ ቦርአ ስናና ካባታዋ፤ ስኑንታኖ ‹ቢድፌኒር› ይሴፌቲ ቦርአ ቦርእኒትስኔንቱ ፉእቶትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ደይ የሱስ፦ «ታ ፉቶ ንቶክ ማኬፋውጙዋ፤ ፋንቱሲ ኦላኒ ፍኝሲ ካሞ ግሩኖይ ኦማ ኡግናክ ግሪፌ ባር ዊስዋ፤ ደይ ቦእኛዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ስኑንታኖ ፍኝባሲ ካሞ ግሪፌ ባር ፋንቱሲ ኬሜርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ባርክ ፍኛአሶን ኦድፌ ባር ጋቻና። ፋንቱሲክቶ ደይ ካምባሶን ኦዶና። ባሳ ፋንቱሲክቶኖን ሱንባ ሱንባሲክ ቴጌሬ ክሱና። ");
INSERT INTO jnje_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ባሳ ቴትን ፋንቱሲክቶኖን ዙትሬ ክስናኔን ኦርፎ ባርኪቶኒ ስናስታ ዜማና። ፋንቱሲክቶ ደይ ካምባሶን አሪሴር ስንና ቦርአ ኦርፎባሴ ሀሞና። ");
INSERT INTO jnje_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ስኑንታኖ ኦሚሳ ካማኖን ኣነ አሪሴፋ ስንና ቦርአ ባሳስታን ኤላቱ ኤላናታኖ እሳንነ ኦርፎባሴ ኣፋ ሀማና ዉዛ» ");
INSERT INTO jnje_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","የሱስ ኤስ ቤሶሶን ባሶክ ማኬ። ስኑንታኖ ባሶ ማኬና ዉዛስ አዉ ስንናማቶ ኣነ አሪሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ሄፕሳ ደይ የሱስ ኤካ ይ፦ «ፉቶ ንቶክ ማኬፋውጙዋ፤ ፋንቱሲ ፍኛ ታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ታይስታን ዜምሜ ዬሴ ባሶ ዙቴሬ ዊስ፤ ደይ ቦእኛዋ። ፋንቱሲክቶ ደይ ባሶ ካማሶን ኣነ ኦዶሶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","«ፍኛአስ ታዋ፤ ታኪ ካሞ ግሪፌ ባር ፋሩና፤ ግሩና፥ ኬሳና፥ ፌሽኒ ድማ ደይ ዳናና። ");
INSERT INTO jnje_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ዊሲስ ዊሴሬ ሹኬ ትሽኩናክታኖ ባክ ኣነ ዬፌዋ። ስኑንታኖ ታ ባሶክ ካ ስናናክናዋ ፎቤሲሲክ ቱማ ፉእቴ ካ ዳኖነክናቱ ያጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ታ ማአ ኬሜርዋ፤ ማአ ኬሜሪስ ካባሶን ፋንቱሲክዋ እያት ኣትሬ እማርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ዋጋክ ኬምፌ ባር ፋንቱሲክቶ ባሳር ስና ቤይና ቦርአ እሪርካስ ያፋና ካባሲክ ፋንቱሶን ሀኣት ኤልፌ። እሪርካስ ደይ ፋንቱሶን ኤጲን ኦማስ ደይ ሲክቴፋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ኤስ ኬሜሪስ ዋጋክቱ ኬምፌ ስንና ቦርአ ፋንቱሲክ ኣነ ሳፋሬፌ፤ ደይ ቴትባሲክቱ ኤልፌ። ");
INSERT INTO jnje_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ታ ማአ ኬሜርዋ፤ ታ ፋንቱናሶን አሪናርዋ። ፋንቱናሲክቶ ደይ ታን አሪሴርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ታ ባርኪቶኖን አሪፋናስ አባስ ታን አሪፌናሲማቶናዋ ታ ደይ አባታስን አሪፋናሲማቶዋ። ካናሶን ደይ ፋንቱናሲክዋ እያት ኣትራ እማናርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ሀን ኦላሲ ፎንቶ ጌሮክ ኦማ ፋንቱና ፋሴርዋ። ባርኪቶኖን ደይ ኤጳ ዮናክ ሾልሱዋ። ባርኪቶ ካምናሶን ኦዶሶና። እሳ ዎዶ ደይ ስናና፤ ኬሜሪስ ደይ እሳር ስናና። ");
INSERT INTO jnje_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ሄፕሳ ዎላ ኤጳናክ ካናሶን ደይ ኣትራ እማናር ስንና ቦርአ አባታስ ታን ኬሽቴር። ");
INSERT INTO jnje_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ካናሶን ታ ሹናሲክ ኣትራ እማናዋ፤ ታኪን ደይ ኦኑ ኤጳናክ ኣፋ ችማናዉዛ። ካናሶን ኣትራ እማክናዋ ዎልግራ ደይ ኤጳናክና ሀእሱኒ ሁግናና ፋርዋ። ኤስ አጃጂሶን ደይ ዳንናስ አባታሲክጝዋ» ");
INSERT INTO jnje_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ኤስ ማኬና ባርክ ሄፕሳ አይሁድኒ ሜኒ ጋነያሲ ኦር ኦር ኬሳ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ባሶስን ሾዎቤሲስ፦ «ኪና አያና ባሳሲ ፋርዋ። ንፋሴዋ፤ አዉኒሮን ባሪን ኦደድፌትሪንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ኦሚስ ደይ፦ «ሀን ባሳ ዎላስ ኪና አያና ባሳሲ ፋና አሱኒ ዎላታዋ፤ ኪና አያና ባሳሲ ፋና አሱ ኣፍትሹኒ ኣፋሶን ፋቱናክ ችምንሮሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","የሩሳለሙክ ቤቴሜቅደሲሶን ካይምሱኒ ሄቦስ ኡልፍንቶና ዎናስ ካርእ፤ ኤስ አሳስ ደይ ዬሹ። ");
INSERT INTO jnje_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","የሱስ ቤቴሜቅደሲሲ ሶሎሞኒ ኬስፋ ግሩኒ ዳጋፍዮ ይስቴፋ ድማስታ ኩቲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ኤስ ካባሲክ አይሁድኒ ሜያ የሱስኒን ጋነያ ጌደሬ ኤካ ይሴቴ፦ «ኣጌኔንንሶ ኔን ላጰባቴት ፎንሪ? ነ ሀኦሲ ሙድቶ ስና ክርስቶስ ስኔሶን አማ ዛግራ እኖክ ማኮዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","የሱስ ባሶክ ዎልግሬ ኤካ ይ፦ «ንቶክ ማኬና ባሮን ኣነ አማነሴፌት፤ ታ አባታሳ ሱናክ ዎስቴፋና ዎስቶስ ታ ኦ ስንናማቶ ታክ ዛላዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ስኑንታኖ ንቶ ታ ፋንቱ ስና ቤየቲ ቦርአ ኣነ አማነፌት። ");
INSERT INTO jnje_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ታ ፋንቱሲክቶ ታ ካማሶን ኦደሴርዋ፤ ታ ደይ ባርኪቶኖን አሪናር። ታክ ደይ ዞኑስቴሴር። ");
INSERT INTO jnje_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ታ ኮእባ ፎንቶ ካ ባርኪቶክ እማናርዋ፤ እሳንነ ደይ ኣፋ ትሹሶናዉዛ። ታ ኩሹስን ኦኑ ኣፋ ቦኦና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ባርኪቶኖን ታክ እማ አባታስ ዙታምባሴ አስ ደናሎዋ። አባታሳ ኩሹስንኑ ባርኪቶኖን ቦኦኒር ኦኑ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ታናዋ አባታስና እንኖ እሳርዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ሄፕሳ ደይ አይሁድኒ ሜያ ባሪን እቼ ዎሩክ ሹአ ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","የሱስ ደይ፦ «አባታስኪን ሾዎ ማአ ዎስቶ ንቶክ ቤስን፤ ኤኪን ታን እቻ ዎሩትስ ኣፋ ዎስቶናስኪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","አይሁድኒ ሜያ ደይ ዎልግሬ፦ «እንኖ ኔን እቻ ዎሩኒስ ሀኦስታ ሜእኒ ካማ ማኬታ ቦርአታኖ ማአ ዎስቶነሲክታዋ። ነ አሱ ስና ፋጌዶ ቴትኔሶን ሀኦ ዛግትዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","የሱስ ደይ ኤካ ይ፦ «ንቶ ቱማሲ ‹ሀኦስ ንቶትን› ‹ኮሎዋ› ይጝዋ ይፋር ትቼራ ፋርታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ኤሴ ሀኦሲ ኮርቶ ማፃፋሶን ፌሹክ ኣፋዋ ችምቶና ዉዛ። ሀኦሲ ካማ ያና ባሶትን ሀኦሲ ኮርቶ ካማ ‹ንቶ ኮሎዋ› ይራ ቴጌናኔን፤ ");
INSERT INTO jnje_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ኤኪን አባስ ኮርቶ ዛግና ባርንናዋ ሀን ዳስታክ ዎሲና ባርንና ‹ታ ሀኦኒ ናዋ› ኡባሲክ አዉኒ ቦርአ ‹ሀኦስታ ሜእኒ ካማ ማኬዋ› ይፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ታ ዎስቴፋና ዎስቶስ አባታሳር ስና ሻካናነ ታን አማኖትታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ስኑንታኖ ታ ዎስቴፋና ዎስቶስ አባታሳር ስንፋናነ ታክ አማኖ ቤይፌትክኑ ዎስቶናሲክ አማኖትዋ። ኤስ ባርክ አባስ ታይሲ ፌናማቶናዋ ታ ደይ አባሳሲ ፋናማቶና ማእስራ አርሶትዋ» ");
INSERT INTO jnje_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ባሶ ደይ ሄፕሳ ኤጶነክ ሾልሴቴ፤ ስኑንታኖ ባር ኩሹቤሲስን አቴ ኬሴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ሄፕሳ ደይ የሱስ ዮርዳኖስኒ አካሶን ፍንነ ዜሞቲ ዮሀኒስ ሀጵቅት ፌና ድማስታ ሀምሜ ኤስታ ድ። ");
INSERT INTO jnje_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ሾዎ አሱኒ ሜያ ባርኪ ዬሴሬ፦ «ዮሀኒስ እሳ ቢስቴራ አሪቶኖይ ዉዛነ ኣነ ዛጉዌ፤ ስኑንታኖ ዮሀኒስ ሀን አሱሳ ቾዋኖን ማኬና ዉዛስ ዙታምባሴ ፉቶዋ» ይሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ኤስታክ ደይ ሾዎቤሲስ የሱስኒክ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ብታኒያክ አላዛር ይስቴ እሳ አሱ ሜቴሬ ፌር። ብታኒያ ማራሚነዋ ኤትባ ማርታነ ዲሴፌ ኬኤ። ");
INSERT INTO jnje_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ኤስ ማራሚ ስንፋ ባር ዳሚሳ ዎቾኖን ሽቶ ዎሽራ ደይ ሶምባሲክ ኩአ ባርዋ። ኤስ ሜቴስ ደይ ባሪ አይ ስና አላዛርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ኤቴ ኤቴ ደይ፦ «ዳሚሶ! ኤስ ነ ሹንፋታ ባር ሜቴዋ» ይሴሬ የሱንኪ ዎስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","የሱስ ኤስ ባሮን ኦድናይሴ፦ «ሀን ሜሮስ ባሪን ዎሩኒ ሜሮታዋ፤ ስኑንታኖ ሀኦሲክ ኡልፍና ስናናክናዋ ሀኦሲ ና ደይ ሀን ሜሮሲክ ኡልፍንቶናክናቱ ባር ሜቴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","የሱስ ማርታኖን፤ ኤትባ ማራሚኖንናዋ አይቤስ አላዛርንና ሹናር። ");
INSERT INTO jnje_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ስኑንታኖ የሱስ አላዛርኒ ሜቶኖን ኦደፋት ፌና ድማስታ ሄፕ ዎና ፌሺ። ");
INSERT INTO jnje_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ኤሴን ኦርፎ ናዎኒ ሜያክ፦ «ሄፕሳ ዎላ ዩዳክ ኣ ፍዳስታ ሀሚንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ናዎኒ ሜያ፦ «አስሲኛኖ! ጋሮ ዎናኔን ስናክ አይሁድኒ ሜያ ኔን ሹአክ እቾነክ ሾልሴት ፌሴቴርዋ። ሄፕሳ ደይ ዎላ ኤስታ ሀማታክ ሾሌፋቶሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","የሱስ ዎልግሬ ኤካ ይ፦ «ዎናስ አሲሬ ሄፔ ሳአትታ ታኖሶ ፋናሪ? ዎናክ ኩትፌ ባር ሀን ዳሲ ቻሬፋኖን ቢድፌር ስንና ቦርአ ኣፋዋ ቱሳእኦና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ስኑንታኖ ታልማሲ ኩትፌ ባር ቻሬፋ ባርኪክ ኣፋ ስንና ቦርአ ቱሳእኤርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ኤስ ባሮን ማኬናኔን ኦርፎ፦ «ዞሞኒ ስና አላዛር አፋእይቴዋ። ስኑንታኖ ታ ሀምማ አፋእይኒታን ባሪን ጉዝጉናርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ናዎኒ ሜያ ደይ፦ «ዳሚሶ! አፋእይንን ኩኒር ስንፋናነ ፋሩናዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","የሱስ አላዛር ኪት ስንባሶንቱ ባሶክ አምማኖን ማኬ። ስኑንታኖ አፋይኒን ኩናርነ ፋር ስንናቱ ባሶክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ኤስ ባሪ ቦርኣ የሱስ አምማኖን፦ «አላዛር ኪትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ንቶ አማኖትክ ኤስታ ፎ ቤይናሲክ ንቶክዋ እያት ግሬፋውጙዋ። ስኑንታኖ ሀሽ ካብኒ ባርኪ ሀሚንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ኤስ ካባሲክ «ድድሞስ» ይስቴፌ ቶማስ ኦም ናዎኒ ሜያክ፦ «ካብኒ የሱስኔን አነ ክቱኒክ እንኖ ደይ ሀሚንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","አላዛርኒ ክቱስ ካባርቴናኔን አቼች ዎና ካርፋን የሱስ የ። አሱኒ ሜያ ደይ አላዛር ክቱባሶን የሱስኒክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ብታኒያ የሩሳሌምኒስታን ዎክባስ ኬዝ ኪሎ ሜትር ስናና። ");
INSERT INTO jnje_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ሾዎ አይሁድኒ ሜያ ማርታነዋ ማራሚነ አሲን አይቤስ ክትፋን ባሶትን ችኑክ ዬሴሬ ኤስታ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ማርታ የሱስ ዮባሶን ኦድናይሴ ኡጶናክ ኬሲ። ስኑንታኖ ማራሚ ኬር ዲፋር። ");
INSERT INTO jnje_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ማርታ የሱስኒክ፦ «ዳሚሶ! ነ ሀንታ ፋታር ስንፋናነ አይታስ ክቱና ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ስኑንታኖ ሀሽኑ ነ ሀኦስኪን ሺጴፋታ ባሮን ዙቴራ ኔክ እማናማቶ አሪፋውጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","የሱስ ደይ ባርክ፦ «አይኔስ ክቱን ካቡናዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ማርታ ደይ፦ «ኮእባሲ ዎኖ ክቱን ካቡኒ ካባሲክ ካቡናማቶ አሪፋውጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","የሱስ ደይ ባርክ፦ «ክቱን ካቡነዋ ካነ ታዌ። ታክ አማነፌ ባር ክትፌናክኑ ሀየዉቱ ስናናዌ። ");
INSERT INTO jnje_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ታክ ፌፌ ባርናዋ ታክ አማነፌ ባርና ዙቴሬ እሳንነ ኣፋ ክቱና ዉዛ። ኤስ ባሮን አማነፋቶሴ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ባር ደይ፦ «ኣ ዳሚሶ! ነ ሀን ዳስታ ዮንኒ ሙድቶ ሀኦሲ ና ስንታማቶ ታ አማነፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ማርታ ኤስ ባሮን ማኬፋት ሀምማ ኤትባሶን ኣቾክ ቴጌራ፦ «አስሲኛስ የዌ፤ ኔን ደይ ሾሌድፌርዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ማራሚ ኦደናይሴ ታፕቴራ ካብራ ባርኪ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ኤስ ካባሲክ የሱስ ማርታ ኡጴና ድማስታክቱ ፌቴኖ ሀሽኑ ሀጝ ኬኤሲ ኣነ ግሩዌ። ");
INSERT INTO jnje_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ባሮን ችኑክ ባርኔን አነ ኬር ዲሴ አይሁድኒ ሜያ ማራሚ ታፕቴራ ካብ ኬስባሴ አላዛርኒ ሞጋስኪ ሀምማ ዋሱናክ ሀማርነ ፋር ስንፋን ኦርፎባሴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ማራሚ የሱስ ፌናስታ ሀምማ ቢናይሴ ዎቾባሲ ጋንደራ፦ «ዳሚሶ! ነ ሀንታ ፋታር ስንፋናነ አይታስ ክቱና ካባታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","የሱስ ባር ዋስፌንናዋ ባርኔን አነ ዬሴ አይሁድኒ ሜያ ዋሴፌን ብያት ቴትባሲክኑ አካማኖን ሴክቴሬ ሱሜሬ፤ ");
INSERT INTO jnje_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«አይንሶ ኩንስትሪ ?» ይ። ባሶ ደይ፦ «ዳሚሶ! ያራ ቢዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","የሱስ አራፋ ኬሲሬ ዋሲ። ");
INSERT INTO jnje_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ኤስ ባሪ ቦርኣ አይሁድኒ ሜያ፦ «አዉነ ፋሮን ሹንፌናማቶ ቢትዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ስኑንታኖ ባሶስን እሳ እሳይስ፦ «ኣፍትሹሳ ኣፋኖን ፋቲ ባር ሀን አሱስ ክቱኖይናማቶ ዛጉክ ኣፋኖሶ ችማናዉዛይ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","የሱስ ቴትባሲክ ሄፕሳ ደይ አካማኖን ሴክቴሬ ሱሜፋት ሞጋስኪ ሀሚ። ሞጋስ ደይ እኛ ሹአክ ኡክቴራ ኩኒ ዱጋዱግ። ");
INSERT INTO jnje_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","የሱስ፦ «ሹኣሶን ካብጉትዋ» ይ። ክቲ ባሳ ኤታ ማርታ፦ «ዳሚሶ! ክትናኔን አቼች ዎና ስንና ቦርአ ሀሽ ዘያርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","የሱስ ደይ፦ « ‹አማነፋታነ ሀኦሲ ኡልፍናኖን ብያታዌ› ይራ ኔክ ኣነ ማኮቶሴ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","አሱኒ ሜያ ደይ ሹኣሶን ካቡግሴቴ። ኤሴን ኦርፎ የሱስ ደን ካንነ፦ «አባታሶ! ሺጶናሶን ኦደታ ቦርአ ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ዎንና ዎንና ደይ ሺጶናሶን ኦደፋታማቶ አሪፋውጙዋ። ስኑንታኖ ኤካ ማኬናስ ነ ታን ዎሱኔሶን ሀንታ የርሴ አሱኒ ሜያ አማኖሶነክዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","የሱስ ኤስ ባሮን ማኬፋት፦ «አላዛርኖ! ሀጝ ያራ ኬስዋ» ይሬ አካማ ቴጋ ካማክ ቴጌ። ");
INSERT INTO jnje_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ክት አላዛር ኩሹባሴዋ ዎቾባሴ ዙቴና ኤኮባሴ ኬሲ። ስንባስ ደይ ማማክ ታቴና ኤኮባሴቱ ፋ። የሱስ አሱኒ ሜያክ፦ «ኮታኒ ኩቱዎዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ማራሚኖን ችኑክ ዬሴ አይሁድኒ ሜያስን ሾዎቤሲስ የሱስ ዛግና ባሮን ብየፋት ባሪክ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ስኑንታኖ ባሶስን እሳ እሳይስ ፌርሳዊኒ ሜያኪ ሀሜሬ የሱስ ዛግና ባሮን ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ኤስ ባሪ ቦርኣ ማግኒ ጋኝኜ ሜናዋ ፌርሳዊኒ ሜና ሾንጎስታ ዙቴሴፌ ባሶትን ዙትሴሬ፦ «ሀን አሱስ ሾዎ ቢስቴራ አሪቶኖይ ዉዛ ዛግድፌር ስንና ቦርአ አዉ ዛጋንነ ዋያንሶ? ");
INSERT INTO jnje_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ባክ ቤይፋንነ አሱ ዙቴሬ ባርክ አማኖኒር፤ ሮምኒ ሜያ ደይ ዬሴሬ እንኖ ቤቴሜቅደሲሶንናዋ አሱኒስንና ትሽክሴሴቴርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ስኑንታኖ ኤስ ዎጋሲክ ማግኒ ጋኝኜ ሜኒ ጋኛ ስና ቀያፋ ይስቴፌ ባሶስን እሳይስ፦ «ንቶ እሳንነ ኣነ አሪፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ዳራ ዙቴሬ ትሹባስታን እሳ አሱ ዳራሳ ቴታክ ክትፋናነ ንቶክ ማአር ስንናማቶ ኣነ ያዳቴፌትኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ኤስ ባሮን ደይ ማኬናስ ባሳ ቴታስን ክስሬታዋ። ስኑንታኖ ኤስ ዎጋሲክ ባር ማግኒ ጋኝኜ ሜኒ ጋኛ ስና ቦርአ የሱስ ዳራሳ ቴታክ ክቱናክ ፌናማቶ ቤስፌና ካባሲክቱ ኤስ ራጂሶን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","የሱስ ዳራሳ ቴታክ ክቱናስ አይሁድኒ ዳራኒክ ኮእባ ስኖይናማቶ ሀኦሲክ አማነሴራ ዳዳሲ ሲክቴራ ፋሴ ናጎታሶን ደይ እሳሪክ ዙቱናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ኤስ ዎኖኔን ካብሴሬ የሱስኒን ዎሩክ ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ኤስ ባሪ ቦርኣ የሱስ አይሁድኒ ሜኒ ጋነያሲ አምማኖን ኬሴ ኣነ ኩቱዌ። ስኑንታኖ ኤስን ኬስሴ ዛቦሲ ቴሻ ፋ ዳ ኤፍሬም ይስቴፋ ካታማሲ ሀሚ። ኤስታክ ደይ ናዎኒ ሜያኔን አኔ ድ። ");
INSERT INTO jnje_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","አይሁድኒ ሜኒ ፋስካኒ ሄቦስ ታእሴራ ፋር። ሾዎ አሱኒ ሜያ ኤስ ሄቦስ ካርኖይፌን ዜምሜ ማሴሬ ካይምሜ ሆሮክ ፌሴቴ ዳ ዳስን ደን የሩሳሌም ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","የሱስኒን ሾልሴት ፌሴቴር ስንና ቦርአ ቤቴሜቅደሲሲ የርሴፋት ባሶትና ባሶትና፦ «አዉ ሳፋሬፌትሶ? ሀን ሄቦስታ ዮኒር ስንና ንቶክ ኣነ ቤስቴፋኖሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ማግኒ ጋኝኜ ሜናዋ ፌርሳዊኒ ሜና የሱስኒን ኤጳክ ባር ፌና ድማሶን አሪፌ አሱ ፌፋናነ ባሶክ ማኮናክ አጃጀሴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","አይሁድኒ ፋስካኒ ሄቦስ ዛግቶናክ እሱን ዎና ፉእቴፋና ካባሲክ የሱስ ክቱን ካብግና አላዛር ፌፌና ብታኒያ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ኤስታክ ፌሴ አሱኒ ሜያ ሜታኡ ባርክ ሆስሴቴ። ማርታ ደይ ዎስቶታቱ ፋ። አላዛር ደይ የሱስኔን አነ ሙ ሙሶነክ ታእሴሬ ፌሴ ባሶስን እሳይስዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ኤስ ካባሲክ ማራሚ አካማ ችማ ዋጋክ ዋግቴ ካይማ ናርዶሲክ ዎሱስቴ እሳ ቢልቃድ ቱማ ሽቶ ኤጳ የሱስኒ ዎቾስታ ዉካት ሶምባሲክ ደይ ዎቾባሶን ኩእ። ኬያስ ደይ ናርዶስኒ ሽቶሲ ሳዋክ ቱሚ። ");
INSERT INTO jnje_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ናዎባሳስን እሳይስ የሱስኒን ኣትሬ እምኒ አስቆሮትኪ ዩዳ ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«ሀን ሽቶስ ኬዝ ዲናሪሲ ወደይ እሳ ዎግጋ ዎሱስቴ ዎስቶኒ ዋግሲ ዋግቴራ አዉኒ ቦርአ ቱካምኒክ እምቶ ቤይሶ?» ");
INSERT INTO jnje_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ባር ኤካ ይናስ ቱካምኒክ ሳፋሬሬ ስኖይናሮን ዊስ ስንና ቦርአዋ። ዋጋ ኤጰፌስ ባር ስንና ቦርአ ካርድዲስ ሀእቴፋ ባርስን ኤጴ ዶስቴሬ ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","የሱስ ደይ ኤካ ይ፦ «አሽናስ ካባርቶና ዎኖቲ ባርክቱ ታን ሆሲ ስንና ቦርአ ባሮን ቤይትዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","«ቱካምኒ ሜያ ዎንና ዎንና ንቶኔንቱ ፌሴቴዋ። ስኑንታኖ ታ ንቶኔን ዎንና ዎንና ኣፋ ፎና ዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ኤስ ካባሲክ ሾዎ አይሁድኒ ሜያ የሱስ ብታኒያ ፎባሶን ኦደሴፋት ዬሴቴ። ኤስ ዬሴቴስ የሱስ ባር ባሪን ብያ ስኖያንሮን ክቱኒ ካብ አላዛርኒኔን ብያክቱ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ስኑንታኖ ማግኒ ጋኝኜ ሜያ አላዛርኒን ደይ ዎሩክ ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ኤሲስ ደይ አላዛርኒስታን ካብ ቾዋ አይሁድኒ ሜያስን ሾዎቤሲስ የሱስኒክ አማነሴት ፌሴቴር ስንና ቦርአ። ");
INSERT INTO jnje_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ዎኖትርክ አይሁድኒ ፋስካኒ ሄቦሲክ የ ሾዎ ዳራ የሱስ የሩሳሌም ዮኒር ስንባሶን ኦደሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ኤስ ባሪ ቦርኣ ደያ ኪርኤ ኤጴሬ ባሪን ኡጶክ ኬሴሬ፦ «ሆሳና! ዳሚሳ ሱናክ ዬፌ እስራኤልኒ ታቶስ ሱስቶዋ» ይት ቻጌት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","የሱስ ሀኛን ናዋ ዳንነ ባርስታ ድ። ኤሲስ ደይ፦ ");
INSERT INTO jnje_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«ነ ፂዮንኒ ካታማ የሩሳሌምነ ድጎታታዌ! ኤሴኑ ታቶኔስ ሀኛኒ ናታ ዲሬ ዮኒርዌ።» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ናዎኒ ሜያክ ኤስ ቾዋስ ዜምማ ባሶክ ኣነ ጋሎዋ። ስኑንታኖ የሱስ ኡልፍንቴናኔን ኦርፎ ኤስ ትቻሲ ባርክ ትቼናማቶናዋ ባርክ ዛግቴናማቶ ያዳቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","የሱስ አላዛርኒን ሞጋስን ቴጌሬ ክቱን ካብግፌና ካባሲክ ባርኔን አነ ፌ አሱኒ ሜያ የሱስኒ ቾዋሲክ ዛላ ማክሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ሾዎ አሱኒ ሜያ ባሪን ኡጶክ ዬሴቴስ ኤስ ቢስቴራ አሪቶኖይ ዉዛሶን ዛግናማቶ ኦደሴሬ ፌሴቴር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ኤስታን ፌርሳዊኒ ሜያ ባሶትና ባሶትና፦ «ሀን ዳስታክ ፌ አሱ ዙታምባሴ ባሳ ኦርፎሴ ሀሚዋ! እንኖ እሳ ዉዛኑ ዛጉክ ኣነ ችሜኒ ስንናማቶ ብየቲዮሶ?» ይሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ሄቦሲክ ሀኦኒ ሺጶክ የሩሳሌም ዬሴ ባሶ ጋነያስን እሳ እሳ ግሪክኒ አሱኒ ሜያ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ባሶ ደይ ጋሊላክ ቤቴሳይዳኒ አሱ ስና ፍልጶስኒኪ ሀሜሬ፦ «ዳምኒሶ! የሱስኒን ብያኒክ ሾሌፌንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ፍልጶስ ሀምሜ እንድርያስኒክ ማኬ። እንድርያስናዋ ፍልጶስና ሀሜሬ የሱስኒክ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","የሱስ ባሶክ ዎልግሬ ኤካ ይ፦ «አሱኒ ና ኡልፍንቶና ሳአቲስ ካርእዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ፉቶ ፉቶ ንቶክ ይፋዉጙዋ፥ እሳ ዛጎኒ ጋና ሆኣሲ ዝግራ ክቱ ሻካናነ ባር ባርቱ ፉእቶኒርዋ። ስኑንታኖ ክትራ ካይፋናነ ሾዎ ጋናቱ ጋናናዋ ");
INSERT INTO jnje_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ካባሶን ሹንፌ ባር ትሽክር። ሀን ዳስታክ ካባሶን ኦምቴፌ ባር ኮእባ ፎንቶ ካቱ ባሪን ኦድኒር። ");
INSERT INTO jnje_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ታክ ዎስቶክ ሾሌፌ ባር ታኔን አነ ዮዎዋ። ታ ፋናስታ ዎስትኛታስ ደይ ፎና። ታክ ዎስቴፌ ባሪን ደይ አባታስ ኡልፍንሱና።» ");
INSERT INTO jnje_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ቱስሬ ደይ የሱስ፦ «ሀሽ ካናሶን ትርኦ ኤጲዋ። አዉ ኡናሪንሶ? ‹አባታሶ! ሀን ሳአትስስን ታን ፉአይዋ› ኡናታሶ? ስኑንታኖ ኤካ ኡኖይናማቶ ታ ያናስ ሀን ሻናኒ ሳአትሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","አባታሶ! ነ ሱኔሶን ኡልፍንሱዋ» ይ። ኤሴን ኦርፎ ሳማን፦ «ሱናሶን ኡልፍንስጝዋ፥ ሄፕሳ ደይ ኡልፍንሱናዋ!» ይፋ ካማ ኦድቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ኤስታ የሬ አሱኒ ሜያ ኤስ ባሮን ኦደፋት፦ «ደዶዋ» ይሴቴ። ኦሚስ ደይ፦ «ሀኦሲ ዎስያቱ ባርኪ ዎል ሌርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","የሱስ ደይ፦ «ኤስ ካማስ ኦድቴናስ ንቶክዋ እያታኖ ታክዋ እያትታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","«ሀየ ሀን ዳሲ ማጝሱኒ ካርኒ ሳአትስ ካርእዋ። ሀን ዳሲ አእስኝኛ ስና ሴጣና ጌራካሎ ሀእቶናስ ሀየዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ታ ሀን ዳስታን ደን ቴግፋና ካባሲክ አሱስን ዙትራ ታኪ ዮናክ ዛጉና» ");
INSERT INTO jnje_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","የሱስ አሮ ክቱ ክቱናክ ፌናማቶ ቤሱክቱ ኤስ ካማሶን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ዳራኒ ሜያ ደይ፦ «እንኖ ቱማሲ ኦደኒስ፦ ‹ክርስቶስ ኮእባ ፎንቶ ነያ ፎኒር› ይፋርዋ። ኤኪን ነ፦ ‹አሱኒ ና ደን ቴጉናክ ሾልስፋዋ› ይፋታስ ኣካኪንሶ? ኤስ አሱኒ ናስ ደይ ኦንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","የሱስ ደይ፦ «ሀሽ ጋሮ ዎና ንቶኔን አነ ቻሬፋስ ፋርዋ። ታልማ ንቶትን ኤጵኖይናማቶ ቻሬፋስ ፋና ካባሲክ ኩቱትዋ። ታልማሲ ኩትፌ ባር አይ ሀሚድፌናማቶ ኣነ አሪፌ። ");
INSERT INTO jnje_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ንቶ ቻሬፍኒ ናንጎታ ስኖትክ ቻሬፋስ ፋና ካባሲክ ኤስ ቻሬፋሲክ አማኖሶትዋ» ይ። የሱስ ኤስ ባሮን ማኬናኔን ኦርፎ ባሶስታን ሻቴሬ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","የሱስ ኤፋቴና ሾዎ ቢስቴራ አሪቶኖይ ዉዛ ባሶ ስና ዛግፌናክኑ አይሁድኒ ሜያ ባርክ ኣነ አማኖሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ኤስ ባር ደይ ስንናስ ራጁ ኢሳያስ፦ «ዳሚሶ! ኦንሶ ማኬኒ ካማሶን አማነሪ? ሀኦሲ ሁግና ደይ ኦንክ አምማኖን ቤስቴሶ?» ይሬ ማኬና ካማስ ኮኡናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ሄፕሳ ደይ ራጁ ኢሳያስ ባሶ አማኖ ቤያሲክ ኤካ ይት አምማኖን ማኬ፦ ");
INSERT INTO jnje_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«ኣፌሲሲክ ቢሬናዋ፤ ንብቤሲስ ያዳቴሬና፤ ዎልሶኖይቴማቶናዋ፤ ፋቱኖይናማቶና፤ ሀኦሲ ኣፌሲሶን ትሽክ፤ ንቤሲሶን ደይ ችኒ።» ");
INSERT INTO jnje_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ኢሳያስ ሀን ባሮን ይናስ ባሳ ኡልፍናሶን ቢና ቦርአዋ። ኤስ ባሪ ቦርኣ የሱስኒ ቾዋሲክቱ ኤስ ባሮን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","43","ስኒፋናክኑ አይሁድኒ ሜያኖን ሀእሲፌ ባሶስን ሾዎቤሲስ የሱስኒክ አማነሴቴ። ስኑንታኖ ሀኦስኪን ቤስቴፋ ኡልፍናስታን አሱኒኪን ቤስቴፋ ኡልፍናሶን ሹነሴቴ ቦርአ ፌርሳዊኒ ሜያ አይሁድኒ ሺጶኒ ኬያስን ባሶትን ካልሌ ክሶኖይቴማቶ ድግሴፋት አማኖቤሲሶን አምማኖን ኣነ ማክሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","የሱስ ካምባሶን ቴግሬ ኤካ ይ፦ «ታክ አማነፌ ባር ታክ ኮእባ ስኖይናሮን ታን ዎሲ ባርክ ደይ አማነዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ታን ብያ ባር ታን ዎሲ ባሪን ደይ ብያናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ታክ አማነፌ ባር ዙቴሬ ታልማሲ ፎኖይናማቶ ታ ቻሬፋ ስንና ሀን ዳስታ ያጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ካምናሶን ኦዴሬ ዎስቶታ ፌሹኖይ ባሳስታ ማጝሱ ካርኒስ ታቴዋ። ታ ያናስ ሀን ዳሶን ፉእኦናክታኖ ሀን ዳስታ ማጝሱኒ ካርአክታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ታን ኤጴቶ ቤየ ካምናሶን ደይ ዎስቶታ ፌሹኖይ ባሳስታ ማጝሱ ካርኒር ፌርዋ። ታ ማኬና ካማስ ኮእኒ ዎኖ ባሳስታ ማጝሱ ካርአናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ታ ታኪን ኣነ ማኮትዋ። ስኑንታኖ ታ ኡና ባሮንናዋ ማኮና አጃጂሶንና እማስ ታን ዎሲ አባስዋ። ");
INSERT INTO jnje_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ባሳ አጃጂስ ደይ ኮእባ ፎንቶ ካ ስንናማቶ አሪፋውጙዋ። ኤስ ባሪ ቦርኣ አባስ ታክ ማኬና ባሮንቱ ንቶክ ማኬጝዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ኤስ ዎናስ ደይ አይሁድኒ ፋስካኒ ሄቦስ ዛግቶኖይፌን ዜምማዋ። የሱስ ሀን ዳሶን ቤየ ደን አባባሲክ ሀማና ዎና ካርእባሶን አሪሬ። ሀን ዳስታክ ፌ ባሳር ስና ባሶትን ሹነት ፌር። ደይ ክቱታኑ ካርአናኔን ሹኒ። ");
INSERT INTO jnje_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","የሱስናዋ ባሳ ናዎስና ሜታኡ ሜሴድፌር። ስኑንታኖ ሴጣና ስሞኒ ና አስቆሮትኪ ዩዳኒ ንብባሲ የሱስኒን ኣትሬ እማናክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","አባስ ሀእሱኒ ሁግና ዙታምባሴ አስን ባርክ እምናማቶናዋ ሀኦስኪን ዬናማቶና፤ ደይ ሀኦስኪ ዎል ሌ ሀሚንር ስንናማቶና የሱስ አሪሬ ፌር። ");
INSERT INTO jnje_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ኤስ ባሪ ቦርኣ ሜታኡስታን ካብሬ ቱካስታኪ ማይና ማማሶን ጋእኤ ኩንሳት ኮይጉኒ ማማ ኤጴ ጌሾባስታ ታርኤ። ");
INSERT INTO jnje_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ኤሴን ኦርፎ ጋባቴሲ አካ ጌደ ናዎባሳክቶኒ ዎቾኖን ማሲ። ታርኤና ማማሲክ ደይ ኩእ። ");
INSERT INTO jnje_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ስሞን ጴጥሮስኒን ማሳናክ ዬን ባር ደይ፦ «ዳሚሶ! ነ ታ ዎቾሶን ማሳታሮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","የሱስ ዎልግሬ፦ «ታ ዛግትፋና ባሮን ነ ሀሽ ኣፋዋ አሩታ ዉዛ። ስኑንታኖ ዎልቱ ያዳቶታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ጴጥሮስ ደይ፦ «ነ ታ ዎቾሶን እሳንነ ኣፋዋ ማሳታ ዉዛ!» ይ። የሱስ ደይ፦ «ዎቾኔሶን ማሳ ሻካናነ ታኪክ ሃኦነ ኣፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ስሞን ጴጥሮስ ደይ፦ «ዳሚሶ! ኤካ ስንፋናነ ዎቾናሶን ኮእባ ስኖይናሮን ኩሹናሴዋ ቴትናሴ አስን ጌዳ ማስዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","የሱስ ደይ፦ «አቱባሶን ማሴ ባር አቱባ ዙቴራ ካይማ ስንና ቦርአ ዎቾባሶን ማሶናስታኖ ኦማ ኣነ ሾልስፋዋ። ንቶ ደይ ካይምዋ። ስኑንታኖ ዙታምንትሴ ካይምቴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","የሱስ፦ «ዙታምንትሴ ካይምቴዋ» ይናስ ባሪን ኣትሬ እምኒ ባር ኦ ስንናማቶ አሪሬ ፌር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ባሶ ዎቾሶን ማሴ ኬስናኔን ኦርፎ ማይባሶን ማየ ዎል ሌ ኡኮት ዲናስታ ድ። ኤካ ደይ ይ፦ «ታ አዉ ዛግናማቶ ያዳቴትዮሶ? ");
INSERT INTO jnje_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ንቶ ታን፦ ‹አስሲኛ ወደይ ዳም› ይሴፌት። ታ አስሲኛናዋ ዳምና ስንና ቦርአ ኤስ ማኬትስ ፉቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ኤሴ ታ ንቶ ዳምናዋ አስሲኛና ስንፋት ዎቾንቲሶን ማስናኔን ንቶ ደይ ንቶትና ንቶትና ዎቾንቲሶን ዎሌ ማስሶትክ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ታ ንቶክ ዛግናይስማቶ ንቶ ደይ ዛግሶትክቱ ቤሶ ንቶክ እምጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ፉቶ ንቶክ ማኬፋውጙዋ፥ ዎስትኛ ዳምባሳታን ደናሎ ኣነ ስንፌዋ። ዎስቴሬ ሀምፌ ባር ደይ ባሪን ዎሲ ባሳስታን ደናሎ ኣነ ስንፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ኤስ ባሮን አሪራ ዎስቶታ ፌሻትነ ንቶ ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ሀን ባሮን ማኬፋናስ ዙታምንትሴ አስ ቾዋሲክታዋ። ታ ኮርና ንቶትን አሪፋውጙዋ። ስኑንታኖ ኮርቶ ማፃፋሲ፦ ‹ቱሽናሶን ታኔን አነ ሜ ባር ጉማ ስንነ ታይስታ ካብዋ› ይስቴ ባር ኮኡናክቱ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ሀን ባር ስኖይፌን ዜምማ ንቶክ ማኬና ባር ስንፋና ካባሲክ ታ ክርስቶስ ስንናማቶ አማኖትክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ፉቶ ፉቶ ንቶክ ማኬፋውጙዋ፥ ታ ዎስና ባሪን ኤጴቴፌ ባር ታን ደይ ኤጴቶናዋ። ታን ኤጴቴ ባር ደይ ታን ዎሲ ባሪን ኤጴቶናዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","የሱስ ኤስ ባሮን ማኬናኔን ኦርፎ አያናባሶን ትርእኦ ኤጳን፦ «ፉቶ ፉቶ ንቶክ ማኬፋውጙዋ፥ ንቶስን እሳይስ ታን ኣትሬ እምኒርዋ» ይት አምማኖን ክስሬ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ናዎባሳክቶ ኦኒ ቾዋ ማኬናማቶ ኣነ አሪሶቶ ስንና ቦርአ ኣፌ ኣፌ ብየሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ናዎባሳክቶኒስን የሱስ ሹንፌና እሳ ናዎስ የሱስኒ ቴሻ ካሳየሬ ዲፌር። ");
INSERT INTO jnje_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ስሞን ጴጥሮስ ኤስ ናዎስን ኣፋ ኪርእኤ፦ «ኦኒ ቾዋ ማኬናማቶ ማምሲቦ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ባር ደይ ኤክ የሱስኒኪ ታእሴሬ፦ «ዳሚሶ፥ ኦንሶ ኔን ኣትሬ እምኒሪ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","የሱስ ደይ ዎልግሬ፦ «ሀን ቱሻሶን ኡቶስሲ ዱክራ ቱቹና ባርዋ» ይ። ኤስታን ቱሻሶን ኡቶስሲ ዱክሬ አስቆሮትኪ ስሞኒ ና ስና ዩዳኒክ ቱች። ");
INSERT INTO jnje_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ዩዳ ቱሻሶን ኤጵናኔን ኦርፎ ጌሬጌሬ ሴጣና ባሳስ ግሪ። የሱስ ደይ ዩዳኒን፦ «ኤሴ ዛጉታክ ሾሌታ ባሮን ታእኒን ዛጉዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ስኑንታኖ ኤስታ ሙ ሙሶነክ ካሳየሬ ዲሴ ባሶስን ኤስ የሱስ ማኬፌና ባር አዉ ስንናማቶ አሪር ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ዩዳ ዋጋ ኤጳር ስንና ቦርአ ናዎኒ ሜያስን እሳ እሳይስ የሱስ፦ «ሄቦሲክ ሾልሱ ዉዛሶን ዋጎዋ ወደይ ቱካምኒ ሜያክ እማ እማ» ይናንነ ፋርቱ ስንና ባሶክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ዩዳ ደይ ኤስ ቱሻሶን ኤጵናኔን ኦርፎ ጌሬጌሬ ኬሴ ሀሚ። ኤስ ካባሲክ ደይ ዋሊ። ");
INSERT INTO jnje_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ዩዳ ኬሴ ሀሚናኔን ኦርፎ የሱስ ኤካ ይ፦ «ሀየ አሱኒ ና ኡልፍንቴዋ። ሀኦስ ደይ ባርኪ ካሞ ኡልፍንቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ሀኦስ ባርኪ ካሞ ኡልፍንቴና ቦርአ ሀኦስ ደይ ባሪን ኡልፍንሱናዋ። ጌሬጌሬ ደይ ኡልፍንሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ናንጎትኖ! አካማ ዎና ንቶኔን ኣነ ኣፋ ፎና ዉዛ። ንቶ ደይ ታን ሾልሶቲ። አይሁድኒ አእስኛኒ ሜያክ፦ ‹ታ ሀማና ድማሲ ንቶ ዮትክ ኣፋ ችማት ዉዛ› ይራ ማኬናሲማቶ ሀሽ ንቶክ ደይ ማኬፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ንቶትና ንቶትና ሹኖሶትክ ጋድዶ አጃጅ ንቶክ እማናዋ። ታ ንቶትን ሹናስማቶ ንቶትና ንቶትና ደይ ዎል ሹኖሶት። ");
INSERT INTO jnje_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ንቶትና ንቶትና ዎል ሹነሴፋትነ ታ ናዎ ስንነትማቶ አሱኒ ሜያ ዙቴሴሬ አርሶነዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ስሞን ጴጥሮስ የሱስኒን፦ «ዳሚሶ! አይንሶ ሀማታሪ?» ይሬ ማምሲ። የሱስ ደይ፦ «ሀሽ ታ ሀማና ድማሲ ነ ዮታክ ኣፋዋ ችማታ ዉዛ። ስኑንታኖ ዎሊቱ ዮክ ችማታዋ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ጴጥሮስ ደይ፦ «ዳሚሶ! ሀሽ ነ ኦርፎሴ ዮክ ችማ ቤያናስ አዉኒ ቦርአንሶ? ታ ካናሶንኑ ስኑን ኔክዋ እያት ኣትራ እማናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","የሱስ ኤካ ይሬ ባርክ ዎልጊ፦ «ካኔሶን ታክዋ እያት ኣትራ እማታሮ? ፉቶ ፉቶ ኔክ ማኬፋውጙዋ፥ አጙ ዋሊን አኮ ኦሩኖይፌን ኬዛ ዎላ ታን ሞርሞታዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","የሱስ ኤካ ይ፦ «ንብንቲስ ናዎናታዋ፥ ሀኦሲክ አማኖት። ታክ ደይ አማኖት። ");
INSERT INTO jnje_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ሾዎ ፎኒ ድማ አባታሳ ኬሩክ ፋር። ኤካ ስና ሻካናነ፦ ‹ፎቲ ድማ ንቶክ ሆሱናክ ሀማናርዋ› ይራ ንቶክ ማኮና ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ሀምማ ፎቲ ድማ ሆስናኔን ኦርፎ ታ ፋናስታ ንቶ ደይ ፎትክ ሄፕሳ ዎላ ያራ ንቶትን ኤጳ ሀማናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ታ ሀማና ድማሲ ዞንሱኒ ኡግናሶን ደይ አርሴትር።» ");
INSERT INTO jnje_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ቶማስ፦ «ዳሚሶ! ነ ሀማታ ድማሶን ኣነ አሩዌኒዋ። ኤኪን ኡግናሶን ኣካክ አሩኒሪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","የሱስ ደይ ቶማስኒክ፦ «አባስኪ ዞንሱኒ ኡጉነዋ ፉቶነ ደይ ካነ ታዋ። ታኪ ካሞ ስና ሻካናነ አባስኪ ሀሚኒር ኦኑ ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ታን አርሴቲ ስንፋናነ አባታስን ደይ አሩቲ ካባዋ። ስኑንታኖ ሀውጙኔን ኤካሎ አርሶትዋ። ደይ ባርን ብየትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ፍልጶስ ደይ፦ «ዳሚሶ! አባስን ቤሱዋ፤ እኖክ ሆሮናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","የሱስ ዎልግሬ፦ «ፍልጶስኖ! ኤፋቴና ዎና ንቶኔን አነ ፋና ታን ኣነ አሩዌኖሶ? ታን ብያ ባር አባስን ቢዋ። ኤኪን ኣካክ ነ፦ ‹አባስን እኖክ ቤሱዋ› ይፋስሶ? ");
INSERT INTO jnje_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ታ አባሳሲ ፋናማቶ፥ አባስ ደይ ታይሲ ፌናማቶ ኣነ አማነፌኖሶ? ታ ንቶክ ማኬፋና ካማስ ታ ቴታስኪንታዋ። ስኑንታኖ ዎስቶባሶን ዎስቴፌስ ታይሲ ፌፌ አባስዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ታ አባሳሲ ፋናማቶ፥ አባስ ደይ ታይሲ ፌናማቶ አማኖትዋ። ኤስ ባሮን ሻካትነ ዎስቴና ዎስቶናሲ ቦርአ አማኖት። ");
INSERT INTO jnje_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ፉቶ ፉቶ ንቶክ ማኬፋውጙዋ፥ ታ አባስኪ ሀማናር ስንና ቦርአ ታክ አማነፌ ባር ታ ዎስቴፋና ዎስቶሶን ደይ ዎስቶና። ኤስ ባርስታን ደናሎኖን ደይ ዎስቶና። ");
INSERT INTO jnje_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","አባስ ናባስኪ ካሞ ኡልፍንቶናክ ታ ሱናሲክ ሺጴፌት ሺጶሶ ዙታምባሴ አስን ታ ንቶክ ዛጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ኣፋ ዉዛሶኑ ታ ሱናሲክ ሺጴፋትነ ታ ዛጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«ታን ኬሽቴትር ስንፋናነ አጃጅናሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ታ አባስን ሺጶናዋ። ባር ደይ ኮእባ ፎንቶኖን ንቶኔን አነ ፎኒ ኦማ ንቶትን ችኑኒ ባሮን እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ኤስ ባር ደይ ፉቶኒ አያናስዋ። ሀን ዳስ ብያክናዋ አሩናክና ኣፋ ችማናዉዛ ስንና ቦርአ ኤጴቶክ ኣፋ ችማናዉዛ። ስኑንታኖ ባር ንቶኔን አነ ፋር ደይ ንቶሲ ፎኒር ስንና ቦርአ ንቶ አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«አባባ እንቶባ ፎንቶ ናንጎታስንነ ፋሮን ዛግራ ንቶትን ኣፋ ቤያና ዉዛ። ታ ንቶኪ ዎላ ዮናር። ");
INSERT INTO jnje_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ጋሮ ዎናኔን ኦርፎ ሀን ዳስ ታን ኣፋ ብያና ዉዛ። ስኑንታኖ ሄፕሳ ዎላ ንቶ ታን ብያትርዋ። ታ ሀየዉ ስንና ቦርአ ንቶ ደይ ሀየዉ ስናትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ታ አባሳሲ ፋናማቶ፥ ንቶ ደይ ታይሲ ፋትማቶ፥ ታ ደይ ንቶሲ ፋናማቶ ኤስ ዎኖ አርሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«ታን ኬሽቴፌ ባር አጃጅናሶን ኤጴቴሬ ዎስቶታ ፌሽፌ ባርዋ። አባታስ ደይ ታን ኬሽቴፌ ባሪን ኬሽቶና። ታ ደይ ባሪን ኬሽቶና። ቴትናሶን ደይ ባርክ አምማኖን ክሲራ ቤሱና።» ");
INSERT INTO jnje_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","አስቆሮትኪ ዩዳ ስኖይ ኦም ዩዳ፦ «ዳሚሶ! ሀን ዳሲ አሱኒክ ስኖይናሮን እኖክ ቴትኔሶን አምማኖን ቤሱታስ ኣካኪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","የሱስ ዎልግሬ ኤካ ይ፦ «ታን ኬሽቴፌ ባር ካምናሶን ኦዳርዋ። አባታስ ደይ ባሪን ኬሽቶናዋ። እንኖ ደይ ባርኪ ያራ ባርኔን አነ ፎኒዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ታን ኬሽቶኖይ ባር ካምናሶን ኣነ ኦድፌዋ። ሀን ኦደፌት ካማስ ታን ዎሲ አባሳርታኖ ታርታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«ንቶኔን አነ ፋና ካባሲክ ሀን ባሮን ንቶክ ማኬንዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ስኑንታኖ አባስ ታ ሱናሲክ ዎሱና ንቶትን ችኑኒ ኮርቶ አያናስ ዙታምባሴ አስን ንቶክ አሱናዋ። ታ ንቶክ ማኬና ባሮን ያዳቶትክ ንቶትን ዛጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«ናጋሶን ንቶክ ቤያናዋ። ናጋናሶን ደይ ንቶክ እማናዋ። ታ ንቶክ እማና ናጋስ ሀን ዳስ እምፋና ባርነ ፋርታዋ። ንብንትስ ናዎናታ ደይ ድጎናታ። ");
INSERT INTO jnje_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‹ታ ሀማናር፥ ዎላ ደይ ንቶኪ ዮናር› ይራ ማኬና ባሮን ኦደሴቲ። ታን ኬሽቴትር ስንፋናነ አባስ ታይስታን አሪክር ስንና ቦርአ ታ አባታስክ ሀሚናሲክ ግርሶቲ ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ኤስ ባር ስንፋና ካባሲክ አማኖሶትክ ዜምማ ንቶክ ማኬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ሀን ዳሶን ሀእሲፌ ሴጣኒስ ዮኒር ስንና ቦርአ ሀውጙኔን ኤካሎ አካማኖን ንቶኔን ኣፋ ዎሎና ዉዛ። ባር ታይስታ እሳ ዉዛ ዛጉና ሁግናባ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ስኑንታኖ ታ አባስን ኬሽቴፋናማቶ ሀን ዳስ አሩናክ አባስ ታን አጃጀና ባሮን ዙትራ ዛጉናርዋ። ሀንታን ካብኒ ሀሚንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ቱስሬ ደይ፦ «ታ ዋይኒሲ ቱዛኒማቶዋ። ኤስ ዋይኒሶን ኦድፌስ ደይ አባታስዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ጋና ጋኖይ ታይስታ ፋ፤ ዋይአሶን ዙትሬ ካርኤ ሀኡኒር። ጋና ጋንፋ ዋይኣሶን ደይ ፋኒሬ ማእስራ ጋናናክ ኦዳና። ");
INSERT INTO jnje_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ንቶ ታ ማኬና ካማሲክ ካይም ስንነትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ታኔን አነ ፎቲ። ታ ደይ ንቶኔን አነ ፎና። ዋይኣስ ዋይኒስ ቱዝታ ፎ ሻካናነ ቴትባሲክ ባር ባር ጋና ጋናናክ ኣፋ ችማናዉዛ። ኤሲስማቶ ንቶ ደይ ታኔን አነ ፎ ሻካትነ ጋና ጋናትክ ኣፋ ችማት ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«ታ ዋይንሲክቶኒ ቱዛቶዋ። ንቶ ደይ ባሪ ዋይአዋ። ታኔን አነ ፌፌ ባርናዋ ታ ደይ ባርኔን አነ ፋና ባርናቱ አካማ ጋና ጋኒርዋ። ታ ፎንቶኖን እሳ ዉዛነ ዛጉክ ኣፋ ችማት ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ታኔን አነ ፎኖይ ባር ዋይአሲማቶ ጌራካሎ ሀእቴሬ እችማና። ኤስ ዋይኣስ ደይ ኬጵቴራ ጌሲ ሀእቴራ ኪቾና። ");
INSERT INTO jnje_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","«ታይሲ ፋሴፋትነናዋ ካምናስ ደይ ንቶሲ ፋፋናነና ሾሌቲ ዉዛሶን ዙትራ ሺጴፋትነ ዳናትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","አካማ ጋና ጋንና ታ ናዎ ስንነፋትነ ኤስ ባርክ አባታስ ኡልፍንቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","አባስ ታን ኬሽቴናሲማቶ ታ ደይ ንቶትን ኬሽቶናዋ። ኤስ ባሪ ቦርኣ ታ ኬሽታናሲክ ፎሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ታ አባታሳ አጃጅኖን ዛግናማቶናዋ ኬሽታንባሲክ ደይ ፋፋናማቶና ንቶ ደይ አጃጅናሶን ዛግፋትነ ታ ኬሽታናሲክ ፎሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ሀን ባሮን ንቶክ ማኬናስ ታ ግራስ ንቶሲ ፎናክናዋ ንቶ ግራስ ደይ ቱማ ስናናክናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ታ አጃጂስ ሀኒስዋ፦ ታ ንቶትን ኬሽቴናሲማቶ ንቶ ደይ ዋል ኬሽቶሶትክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","አሱ ካባሶን ዞሞባሲክዋ እያት ኣትሬ እማስታን ደናሎ ኬሽታና ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ንቶ ደይ ታ አጃጀና ባሮን ዛግፋትነ ታ ዞሞዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ዎስትኛስ ዳምባስ ዛግፌና ባሮን ኣነ አሪፌ ስንና ቦርአ ሀውጙኔን ኤካሎ ንቶትን ዎስትኛታ ኣፋ ኡናዉዛ። ስኑንታኖ አባታስኪን ኦደና ባሮን ዙታምባሴ ንቶክ ማኬን ስንና ቦርአ ዞሞታ ይጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ታቱ ንቶትን ኮሪርቴኖ ንቶ ታን ኣነ ኮሩዌትዋ። ሀምማ አካማ ጋና ጋኖትክ፥ ጋንቲስ ደይ ፎናክቱ ታ ንቶትን ታስጝዋ። ኤስ ባሪ ቦርኣ አባስ ታ ሱናሲክ ሺጴት ዉዛሶን ዙትሬ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ኤሴ ታ ንቶትን አጃጀፋናስ ንቶትና ንቶትና ዋል ኬሽቶሶትክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«ሀን ዳስ ንቶትን ኦምቴፋናነ ንቶስታን ዜምማ ታን ኦምቴናማቶ አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ሀን ዳስታኪ አሱኒ ሜኒማቶ ስንነት ስኒፋትነ ባርር ስና ባሶትን ሹናና ካባዋ። ስኑንታኖ ንቶ ሀን ዳስሪ ስና ቤየቲ ቦርአናዋ ታ ደይ ንቶትን ሀን ዳሲ አሱኒስን ኮሪና ቦርአናቱ ሀን ዳስ ንቶትን ኦምቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‹ዎስትኛስ ዳምባሳታን ደናሎ ኣነ ስንፌዋ› ይራ ንቶክ ማኬና ባሮን ጋሳሱትዋ። ታን ሻናሲ ጌዳክ ካልሌ ኮፉክሴቴኔን ንቶትን ደይ ሻናሲ ጌዳክ ካልሌ ኮፉክሴቴርዋ። ካምናሶን ኦደሴፋቴነ ንቶ ካማሶን ደይ ኦዶሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ስኑንታኖ ታን ዎሲ ባሪን ኣነ አርሴፌ ስንና ቦርአ ሀን ባሮን ዙትሬ ታር ስንቲ ቦርአ ንቶስታ ዛግሶነ። ");
INSERT INTO jnje_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ታ ያራ ባሶክ ማኮ ሻኪን ስንፋናነ ባሶስታ ቦርአ ስናና ካባታዋ። ስኑንታኖ ሀሽ ቦርእቤሲሲክ ማክሶነ ዉዛ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ታን ኦምቴፌ ባር አባታስን ደይ ኦምቴር። ");
INSERT INTO jnje_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ኦም አሱ ዎስቶኖይና ዎስቶሶን ባሶ ጋነያሲ ዎስቶ ሻኪን ስንፋናነ ባሶስታ ቦርአ ስናና ካባታዋ። ስኑንታኖ ሀሽ ሀን ባሮን ዙትሬ ብየትኔን ኦርፎ ታንኔን አባታስንኔንቱ ኦምቴሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ኤሲስ ደይ ስንናስ ባሶ ቱማሲ፦ ‹ሽማሲክቱ ታን ኦምቴሴቴዋ› ይስቴራ ትቼ ካማስ ኮኡናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«ስኑንታኖ አባስኪን ዮኒ ባሬዋ ታ ደይ ንቶክ ዎሱና ችኑኒ ፉቶኒ ኮርቶ አያናሴ ያራ ታ ቾዋሲክ ዛላ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ንቶ ደይ ዜምማኔን ካርኣ ታኔን አነ ፋሴትር ስንና ቦርአ ታ ቾዋሲክ ዛላ ማክሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ሀን ባሮን ንቶክ ማኬናስ አማንቶኒትስ ቱሳኦኖይናማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","አይሁድኒ ሺጶኒ ኬያስኒ ንቶትን ካሌ ክሶነ። ኤስ ባርስታን ደናሎ ደይ ንቶትን ዎር ባር ዙታምባሴ ሀኦሲክ ዎስቴሴቴነ ፋሮን ስንና ፋድቶና ዎና ዮና። ");
INSERT INTO jnje_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","አባስኒ ወደይ ታን ኣነ አሪሶቶ ስንና ቦርአቱ ኤስ ባሮን ኤካ ዛግሴፌ። ");
INSERT INTO jnje_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ስኑንታኖ ሀን ባሮን ንቶክ ማኬናስ ኤስ ዎናስ ካርፋና ካባሲክ ታ አዉ ንቶክ ማኬናማቶ ያዳቶትክዋ። ንቶኔን አነ ፋና ቦርአቱ ሀን ባሮን ዙትራ ዜምማ ንቶክ ማኮ ቤይጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«ስኑንታኖ ሀሽ ታን ዎሲ ባርኪ ሀማናርዋ። ንቶስን ደይ፦ ‹አይ ሀማታስሶ?› ይሬ ታን ማምሱኒር ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ስኑንታኖ ሀን ባሮን ንቶክ ማኬና ቦርአ ንብንቲስ ሱሞክ ቱሚዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ስኑንታኖ ፉቶሶን ንቶክ ማኬፋውጙዋ፥ ታ ሀማስ ንቶክ ማአሪዋ። ታ ሀማ ሻካናነ ችኑኒ ኮርቶ አያናስ ንቶኪ ኣፋ ዮናዉዛ። ስኑንታኖ ታ ሀምፋናነ ችኑኒ ኮርቶ አያናሶን ንቶክ ዎሱና። ");
INSERT INTO jnje_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ባር ያራ ሀን ዳሶን ቦርእኒ ቾዋሲክ፥ ኦኮኒ ቾዋሲክ፥ ማጝሱኒ ካርኒ ቾዋሲክ ዌኦና። ");
INSERT INTO jnje_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ታክ አማኖ ቤዮቤሲሲክቱ ቦርኒ ቾዋሲክ ዌኦና። ");
INSERT INTO jnje_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ታ አባሲኪ ሀማናር ስንና ቦርአናዋ ሀውጙኔን ኤካሎ ደይ ታን ኣፋ ብያት ዉዛ ስንና ቦርአናቱ ኦኮኒ ቾዋሲክ ዌኦናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ሀን ዳሶን ሀእሲፌ ባሳስታ ማጝሱ ካቴና ቦርአቱ ማጝሱኒ ካርኒ ቾዋሲክ ዌኦናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«ንቶክ ማኮና ዉዛ አካማ ፋርዋ። ስኑንታኖ ሀሽ ንቶስታ ፋያርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ፉቶ ስና ሀኦሲ ቾዋኖን አምማኖን ክስራ ቤሱኒ አያናስ ያፋና ካባሲክ ፉቶ ዙታምባሴ አስሲ ንቶትን ዞሱናዋ። ባር ኦደፋና ባሮንቱ ንቶክ ማኮናታኖ ባሪ ቴታስን ክስራ ኣፋ ማኮና ዉዛ። ደይ ዮኒ ዉዛሲክቶኖን ንቶክ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ባር ታር ስና ባሪስታንቱ ኤጳ ንቶክ ማኮና ስንና ቦርአ ታን ኡልፍንሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","አባሳር ስና ባር ዙቴራ ታርዋ። ኤስ ባሪ ቦርኣቱ፦ ‹ታር ስና ባሪስታንቱ ኤጳ ንቶክ ማኮናዋ› ይጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«ጋሮ ዎናኔን ኦርፎ ታን ኣፋ ብያት ዉዛ፤ ደይ ጋሮ ዎናኔን ኦርፎ ሄፕሳ ዎል ላ ታን ብያትዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ናዎባሳክቶኒስን እሳ እሳይስ ባሶትና ባሶትና፦ « ‹አባታስክ ደይ ሀማናር ስንና ቦርአ ጋሮ ዎናኔን ኦርፎ ታን ኣፋ ብያት ዉዛ፤ ደይ ጋሮ ዎናኔን ኦርፎ ሄፕሳ ዎል ላ ታን ብያትዋ› ይፌናስ ኣምባንሶ?» ይሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","«ኤሴ ሀን ‹ጋሮ ዎናኔን ኦርፎ› ይፌና ዉዛስ ኣምባንሶ? ማኬፌና ዉዛስ እኖክ ኣነ ጋሎዋዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","የሱስ ደይ ባሪን ማምሱክ ሾልሴቴማቶ አሪፋት ኤካ ይ፦ «ንቶትና ንቶትና ‹ጋሮ ዎናኔን ኦርፎ ታን ኣፋ ብያትዉዛ፤ ደይ ጋሮ ዎናኔን ኦርፎ ታን ብያትዋ› ይና ቦርአኖሶ ዋል ማሙሴፌትሲ? ");
INSERT INTO jnje_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ፉቶ ንቶክ ማኬፋውጙዋ፥ ንቶ ቻግጋ ዋሱትዋ። ስኑንታኖ ሀን ዳስታኪ አሱኒ ሜያ ግርሶነዋ። ንቶ ሱሞትዋ፥ ስኑንታኖ ሱሞንትስ ግራክ ሶልቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ማሽካ አሱ ኮጶኒ ኬክቶኒ ዎንባስ ካርእፋና ካባሲክ ሱሜፋዋ። ስኑንታኖ ናዋ ታነናኔን ኦርፎ ሀን ዳስታክ ናዋ ኮንቴ ስንና ቦርአ ግራባስታን ካቢ ቾዋ ኣታ ሻናባሶን ኣነ ያዳቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ኤሲስማቶ ንቶ ሀሽ ሱሞትርዋ፥ ስኑንታኖ ሄፕሳ ዎል ላ ንቶትን ብያናርዋ። ንብንቲስ ደይ ግሮናዋ። ኤስ ግራንትሶን ደይ ንቶስታን ኤጵኒር ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«ኤስ ዎኖ ታኪን እሳ ዉዛነ ኣፋ ሺጶት ዉዛ። ፉቶ ንቶክ ማኬፋንዋ፥ አባስ ታ ሱናሲክ ሺጵሴፌት ዉዛሶን ዙትሬ ንቶክ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ሀሽኔን ካርአ ታ ሱናሲክ እሳ ዉዛነ ኣነ ሺጶዌትዋ። ግራንቲስ ቱማ ስናናክ ሺጶት ደይ ዳናትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«ኤሴን ሀውጙ ቤሶክቱ ንቶክ ማኬንዋ። ሀንኔን ኤካሎክ ቤሶክ ማኮኖይና ዎና ዮናዋ። ስኑንታኖ አባሳ ቾዋኖን ንቶክ አምማኖን ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ኤስ ዎኖ ታ ሱናሲክ ሺጶት። ታ ደይ፦ ‹አባስን ንቶክ ሺጶናዋ› ኣፋ ኡናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ኤሲስ ደይ አባስ ቴትባሲክ ንቶትን ሹናር ስንና ቦርአዋ። ባር ደይ ሹንፌናስ ታን ሹንት ቦርአናዋ ሀኦስኪን ዮናሶን አማነሴት ቦርአናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","አባስኪን ኬስሳ ሀን ዳስታ ያንዋ። ሄፕሳ ደይ ሀን ዳሶን ቤያ አባታስክ ሀማናርዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ናዎባሳክቶ ደይ፦ «ሀየ ቤሶክ ስኖይናሮን አምማኖን ማኬትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ዙታምባሴ አሪታር ስንና ቦርአ ኦኑ ኔን ማምሱናክ ኣነ ሾልስፋ ስንናማቶ ሀየ አሪንዋ። ኤስ ባር ደይ ነ ሀኦስኪን ያታማቶ አማኖኒክ እኖትን ዛጊዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","የሱስ ኤካ ይሬ ባሶክ ዎልጊ፦ «ፉቶሲክ ሀየ አማነትዮሶ?» ይ ");
INSERT INTO jnje_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","«ኤሴ እሳ እሳርኒትስ ሲክቴራ ኬንት ኬንት ሀማት ዎናሴዋ ታን ታን ቤዮት ዎናሴ ዮናዋ። ኤስ ሳአቲስ ደይ ሀሽ ካርእዋ። ስኑንታኖ አባስ ታኔን አነ ፌና ቦርአ ታታቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ሀን ባሮን ንቶክ ማኬናስ ታኔን አነ ፋፋኒ ናጋስ ንቶክ ፎናክዋ። ሀን ዳስታክ ፋሴፌት ካባሲክ ሻና ንቶስታ ፋርዋ። ስኑንታኖ ሀሬዋ! ታ ሀን ዳሶን ሜሬጝዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","የሱስ ኤስ ባሮን ማኬናኔን ኦርፎ ሳማ ቢሬ ኤካ ይ፦ «አባታሶ! ሀየ ዎናስ ካርእዋ። ታ ነ ናስ ኔን ኡልፍንሱናክ ናኔስን ኡልፍንሱዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ኤሲስ ደይ አሱ ዙታምባሴ አሲስታ ሀእሱኒ ሁግና እምታ ቦርአ ባሪክ እምታ ባሶ ዙታምቤሲሴ አሲክ ኮእባ ፎንቶ ካ እማናክ ባሪን ኡልፍንሳይዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ኮእባ ፎንቶ ካስ ደይ ነ ነ ፉቶኒ ሀኦ ስንነሶንናዋ ዎሲታ የሱስ ክርስቶስኒንና አሩስዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ነ ታክ እምታ ዎስቶሶን ዎስቴራ ኮእስራ ሀን ዳስታክ ኔን ኡልፍንስጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","አባታሶ! ሀን ዳስ ቴስቶኖይፌን ነ ፋታስታ ፋና ካባሲክ ፋ፤ ኡልፍንናሲክ ዎልግራ ታን ኡልፍንሱዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«ሀን ዳስታን ኮሪራ ታክ እምታ ባሶክ ነ ኦ ስንታማቶ ቤስጝዋ። ባሶ ደይ ኔርዋ። ነ ደይ ባሶትን ታክ እምትዋ። ባሶ ደይ ካምኔሶን ኦደሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ታክ እምታ ባር ዙቴራ ኔኪን ስንናማቶ ባሶ ሀየ አርሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ነ ታክ ማኬታ ካማሶን ባሶክ ማኬንዋ። ባሶ ደይ ኤጴቴሴቴዋ። ታ ኔኪን ያናማቶ ደይ ፉቶክ አርሴቴዋ። ነ ታን ዎሲታማቶ ደይ አማነሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«ነ ታክ እማናክ እምታ ናዎኒ ሜያ ኔር ስንነቴ ቦርአቱ ሺጴፋንታኖ ሀን ዳሲክታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ታር ስና ባሶ ዙቴሬ ኔርዋ። ኔር ስና ባሶ ደይ ታርዋ። ታ ደይ ባሶክቱ ኡልፍንቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ሀውጙኔን ኤካሎ ታ ሀን ዳስታ ኣፋ ፎና ዉዛ። ስኑንታኖ ባሶ ሀን ዳስታቱ ፎሶነዋ። ታ ኔኪ ዮናርዋ። ኮርቶ አባታሶ! ሀን ታክ እማናክ እምታ ባሶትን እንኖማቶ እሳር ስኖነክ ነ ታክ እምታ ሱንኔሲክ ኦዳይዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ባሶኔን አነ ፋና ካባሲክ ባሶትን ነ ሱናሲክ ኦድንዋ፤ እማናክ ታክ እምታ ባሶትን ደይ ኦድንዋ። ትቻሲ ካማ ኮኡናክ ትሹኒ ናስቴኖ ባሶስን ኦኑ ኣነ ትሹዌ። ");
INSERT INTO jnje_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ሀየ ኔኪ ዮናርዋ። ታ ግራስ ባሶክ ቱማ ስናናክ ሀን ዳስታ ፋና ካባሲክ ሀን ባሮን ማኬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ታ ካምኔሶን ባሶክ ማኬን። ታ ሀን ዳስታኪር ስና ቤይናስማቶ ባሶ ደይ ሀን ዳስታኪርቴዋ። ኤስ ባሪ ቦርኣቱ ሀን ዳስ ባሶትን ኦምቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ባሶትን ማጙ ስና ባሪስን ኦዳታክታኖ ሀን ዳስታን ጌሮ ክሱታክ ኣፋ ሺጶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ታ ሀን ዳስታኪር ስና ቤይናስማቶ ባሶ ደይ ሀን ዳስታኪርቴዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ፉቶሲክ ባሶትን ኮርቶ ዛጉዋ። ካምኔስ ፉቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ነ ታን ሀን ዳስታ ፌ አሱሲክ ዎሲታስማቶ ታ ደይ ባሶትን ዎስንዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ባሶ ፉቶክ ነ ዎስቶሲክ ቴትቤሲሶን ኣትሬ እሞነክ ታ ታ ቴታሶን ማእአ ዛግራ ባሶክ እምጝዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«ባሶ ካማሲ ቦርአ ታክ አማነሴፌ ባሶክኔንቱ ሺጴድፋንታኖ ናዎታሳክቶኒክ ኮእባታዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ታ ሺጴፋናስ ዙታምቤሲሴ እሳር ስኖነክዋ። ኤስ ባርክ ነ ታን ዎሲታማቶ ሀን ዳስ ደይ አማኖናዋ። ኤሲስ ደይ አባታሶ! ነ ታይሲ ፋታማቶ ታ ደይ ነይስ ፋናማቶ ባሶ ደይ እንኖሲ ፎሶነክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","እንኖ እሳር ስኒስማቶ ባሶ ደይ እሳር ስኖነክ ነ ታክ እምታ ኡልፍናሶን ባሶክ ደይ እምንዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ፉቶክ እሳር ስኖኔስ ደይ ታ ባሶስሲ ነ ደይ ታይሲ ፋታማቶዋ። ኤስ ባርክ ነ ታን ዎሲታማቶናዋ ታን ኬሽቴታስንነ ፋሮን ባሶትን ደይ ኬሽቴታማቶ ሀን ዳስ አሩናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«አባታሶ! ሀን ዳስ ቴስቶኖይፌን ታን ኬሽቴታ ቦርአ ነ ታክ እምታ ኡልፍናሶን ብዮነክ ሀን ነ ታክ እምታ ባሶ ደይ ታ ፋናስታ ታኔን አነ ፎሶነክ ሾሌፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ኦኮ አባታሶ! ሀን ዳስ ኔን ኣነ አሩዋዋ። ስኑንታኖ ታ ኔን አሪናርዋ። ሀን ባሶ ደይ ነ ታን ዎሲታማቶ አርሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ነ ታን ኬሽቴታ ኬሽታናስ ባሶሲ ደይ ስናናክናዋ ታ ደይ ባሶስሲ ፎናክና ባሶ ደይ ኔን አርሶነክ ዛግንዋ። ደይ አርሶነክ ዛጉናዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","የሱስ ኤስ ባሮን ሺጴናኔን ኦርፎ ናዎባሳክቶኔን አነ ቄድሮንኒ ኮጳሲ የሳሎ ሀሚ። የሱስናዋ ናዎባሳክቶና አታክልትሲ ግርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","የሱስናዋ ናዎባሳክቶና ሾዎ ዎና ኤስታ ዙቴሴቴር ስንና ቦርአ ኣትሬ እምኒ ዩዳ ኤስ ድማሶን አሪር። ");
INSERT INTO jnje_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ኤስ ባሪ ቦርኣ ዩዳ ሾዎ ሜያ ታርኦኒ ሜኒ ዙቶኔን አነ ደይ ማግኒ ጋኝኜ ሜያኪንናዋ ፌርሳዊኒ ሜያኪንና ዎስቴሬ ዬሴ ኦድፌ ባሶ አእስኝኛኒ ሜያኖንና ዞንስሬ ኤስታ ሀሚ። ባሶ ደይ ፋኖሲ፥ ቶንነዋ ኔቦኒ ሜነ ኤጳት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","የሱስ ደይ ባሳስታ ካርኒን ባሮን ዙታምባሴ አሪፋት ባሶኪ ሀምሜ፦ «ኦኒንሶ ሾሌትሪ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ባሶ ደይ፦ «ናዝሬትክ የሱስኒንቱ ሾሌፌንዋ» ይሴቴ። ባር ደይ፦ «ታዋ» ይ። ኣትሬ እማ ዩዳ ደይ ባሶኔን አነ የሬፌር። ");
INSERT INTO jnje_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","የሱስ፦ «ታዋ» ኡባሴ ኦርፎቤሲሲክ ሀሜሬ ዳስታክ ጋንደሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","የሱስ ሄፕሳክ ደይ፦ «ኦኒንሶ ሾሌትሪ?» ይሬ ማምሲ። ባሶ ደይ፦ «ናዝሬትክ የሱስኒንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ባር ደይ፦ «ታዋ ይናስካሶ! ኤሴ ሾሌፌቲስ ታን ስንፋናነ ሀን ታኔን አነ ፌሴ ባሶትን ቤይፋኒ ሀሞቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ኤስ ባር ደይ ስንናስ፦ «አባታሶ! ሀን ታክ እምታ ባሶስን እሳርንኑ ኣነ ትሽኩትዋ» ይና ካማስ ኮኡናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ስሞን ጴጥሮስ ኩቴስኮ ኤጴ ፌር ስንና ቦርአ ክስሬ ማግኒ ጋኝኜ ሜኒ ጋኛአሳ ዎስትኛኒ ኦእታ ኦዶኖን ካጨ። ዎስትኛአሳ ሱና ደይ ማልኮስቱ ይስቴፌ። ");
INSERT INTO jnje_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ስኑንታኖ የሱስ ጴጥሮስኒን፦ «ኩቴስኮኔሶን ዛምባሲ ዎልግራ ጌድዋ። አባስ ታክ እምና ሻናኒ ኡሻሶን ኣፋ ኡሻና ዉዛነ ፋር ስንና ኔክ ቤስቴፋዎሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ኤሴን ኦርፎ ሜያ ታርኦስኔን ባሶትን አጃጀፌ ባሶኔንናዋ አይሁድኒ ሜኒ ታሶኒ ሜኒ አእስኝኛኒ ሜና የሱስኒን ኤጴሬ ታርኤቴ። ");
INSERT INTO jnje_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ዜምሜ ሃንናኒኪ ኤጴ ሀሜቴ። ሃናን ኤስ ነያሲክ ሃንና ማግኒ ጋኝኜ ሜኒ ጋኝኛ ስና ኬያፋኒክ ናሽባይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ኬያፋ፦ «ዳራሳ ቴታክ እሳ አሱ ክትፋናነ ማአሪዋ» ይሬ አይሁድኒ ሜያኖን ሀእሲፌ ባሶክ ዜሞ ስናክ ሜካማ እማ አሱ። ");
INSERT INTO jnje_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ስሞን ጴጥሮስናዋ ኦም ናዎስና የሱስኒ ኦርፎሴ ሀሜቴ። ኤስ ኦም ናዎስ ደይ ማግኒ ጋኝኜ ሜኒ ጋኝኛሲክ አርቶ። ኤስ ባሪ ቦርኣ ባር ማግኒ ጋኝኜ ሜኒ ጋኛኒ ኦጅን ኬርካሎ የሱስኔን አነ ግር። ");
INSERT INTO jnje_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ስኑንታኖ ጴጥሮስ ጌራካሎ ኦጃሲ ፍኝኒ ቴሻ የሬፌር። ማግኒ ጋኝኜ ሜኒ ጋኝኛሲክ አርቶ ናዎስ ኬስሴ ኬያሶን ኦድፋ ማሽካ ዎስትኛሲክ ማኬሬ ጴጥሮስኒን ኬርካሎ ጌድ። ");
INSERT INTO jnje_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ኤስ ኬያሶን ኦድፋ ማሽካ ዎስትኛስ ጴጥሮስኒን፦ «ነ ደይ ሀን አሱሳ ናዎሳስን እሳይስቴኖሶ?» ይ። ባር ዎልግሬ፦ «እንዳነዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ጌሮክ ኮቾ ስንና ቦርአ ዎስትኛኒ ሜናዋ ኦድፌ ባሶ አእስኝኛስ ካኦኒ ጌያ ሶኬሬ የርሴፋት ቤሴድፌር። ጴጥሮስ ደይ ባሶኔን አነ የሬፋት ቤስድፌር። ");
INSERT INTO jnje_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ኤስ ካባሲክ ማግኒ ጋኝኜ ሜኒ ጋኝኛስ የሱስኒን ናዎባሳክቶኒ ቾዋኖንናዋ ባሳ አሱሴ አስን ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","የሱስ ደይ ኤካ ይት ዎልጊ፦ «ታ ሀን ዳ ዙታምባሴ አስክ አምማኖንቱ ማኬን። አይሁድኒ ሜያ ዙታምቤሲሴ ዙቴሴፌ አይሁድኒ ሺጶኒ ኬያሲክ ስኑን ወደይ ቤቴሜቅደሲሲ ዎንና ዎንና አሲን። ኣቾክ እሳ ዉዛነ ኣነ ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ኤካኒ አዉኒሮን ታን ማምሲፋስሶ? ማኬፋና ካባሲክ ኦደ ባሶትን ማምሱዋ። ታ ማኬና ባሮን ባሶ አርሴቴርዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","የሱስ ኤስ ባሮን ማኬፌና ካባሲክ ኤስታ የሬ ኦድፌ ባሶ አእስኛአሳስን እሳይስ፦ «ማግኒ ጋኝኜ ሜኒ ጋኝኛሲክ ኤካ ይትኖሶ ዎልጉታሪ?» ይት የሱስኒን ቦች። ");
INSERT INTO jnje_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","የሱስ ደይ፦ «ማጙ ካማ ማኬን ስንፋናነ ኤስ ማኬና ባርክ ዛል ስንና ማኮዋ። ማኬና ባር ፉቶ ስንፋናነ አዉኒ ቦርአ ታን እችፋሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ኤስታን ሃንና የሱስኒን ታቶባሴ ዎልግሬ ማግኒ ጋኝኜ ሜኒ ጋኝኛ ስና ኬያፋኒኪ ጋፍኪ። ");
INSERT INTO jnje_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ስሞን ጴጥሮስ የሬፋት ጌያ ቤስድፌር። ኦም አሱኒ ሜያ ደይ፦ «ነ ሀን አሱሳ ናዎሳስን እሳይስቴኖሶ?» ይሴቴ። ባር ደይ፦ «እንዳነዋ» ይት ሞርሜ። ");
INSERT INTO jnje_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ጴጥሮስ ኦዶባሶን ካጨና ባሳ ኮን ስና ማግኒ ጋኝኜ ሜኒ ጋኝኛአሳ ዎስትኛአሳስን እሳይስ፦ «አታክልትኒ ድማሲ የሱስኔን አነ ፌን ኣነ ብዩቶሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ጴጥሮስ ደይ ሄፕሳ ዎል ሌ ሞርሜ፤ ኤስ ካባሲክ ጌሬጌሬ አኮ ኦሪ። ");
INSERT INTO jnje_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ኤሴን ኦርፎ ኤእሶ ዎንሳክ የሱስኒን ኬያፋኒ ኬሩን ኤጴሬ ዳ ሀእሲፌ ጵላጦስኒ ኦጅኒ ኬርካሎ ታሜቴ። አይሁድኒ ሜያ ፋስካኒ ሄቦሲ ሜታኡኖን ሙሶነክ ሾልሱ ስንና ቦርአ ኪኖኖይቴማቶ ኡክ ዳ ሀእሲፌ ባሳ ኦጅኒ ኬርካሎ ኣነ ግርሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ኤስ ባሪ ቦርኣ ዳ ሀእሲፌ ባር ጌሮ ኬስሴ፦ «ሀን አሱሳታ ማላቴቲ ማላታስ ኣምባንሶ?» ይት ባሶትን ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ባሶ ደይ ዎልግሬ፦ «ሀን አሱስ ማጙ ዉዛ ዛጉ ሻኪ ስንፋናነ ኣትራ ኔክ እማኒ ካባታዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ፕላቶስ ደይ፦ «ንቶ ኤጳ ሀምፋት ቱማኒቲስማቶ ባሳስታ ማጝሱ ካርእትዋ» ይ። አይሁድኒ ሜያ ደይ፦ «እንኖ ቱማሲክ አሱኒን ዎሩ ካልቶዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ኤስ ባር ደይ ስንናስ የሱስ አሮ ክቱ ክቱናማቶ ማኬና ካማስ ኮኡናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ፕላቶስ ሄፕሳ ዎል ሌ ኦጅኒ ኬርካሎ ግሪ። የሱስኒን ባርኪ ቴግስሬ፦ «ነ አይሁድኒ ሜኒ ታቶኖሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","የሱስ ዎልግሬ፦ «ሀን ነ ማኬፋታ ባር ኔኪንጝዋ ወደይ ኦም አሱኒ ሜያ ታ ቾዋሶን ኔክ ማክሴቴሪንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ፕላቶስ ዎልግሬ፦ «ታ አይሁድኖሶ? ኔን ታክ ኣትሬ እማስ ነ ኬን ስና ባሶናዋ ማግኒ ጋኝኛስናዋ። ነ አዉ ማግትስሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","የሱስ ዎልግሬ፦ «ታ ታቶስ ሀን ዳስታኪርታዋ፤ ታቶናስ ሀን ዳስታኪር ስኒ ስንፋናነ አይሁድኒ አእስኛኒ ሜኒ ኩሹሲ አቴራ እምቶኖይናማቶ ታ ሜያ ታርኦኒ ሜያ ኔብሶነ ካባዋ። ስኑንታኖ ታ ታቶስ ሀን ዳስታኪርታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ፕላቶስ ዎልግሬ፦ «ነ ኤኪን ታቶኖሶ?» ይ። የሱስ ደይ፦ «ታ ታቶ ስንናማቶ ነኑ ማኬትዋ። ታ ኮንቴናይሴዋ ሀን ዳስታ ያናይሴ ፉቶሶን አሱኒ ሜያክ ማኮናክዋ። ፉቶስኪን ስና ባር ዙቴሬ ካምናሶን ኦዶናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ፕላቶስ ዎልግሬ፦ «ፉቶ ኣምባንሶ?» ይሬ ማምሲ። ኤስታን ፕላቶስ ሄፕሳ አይሁድኒ ሜያኪ ኬስሴ፦ «ታ እሳ ማጝሱነ ባሳስታን ኣነ ዳኑትዋ። ");
INSERT INTO jnje_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ስኑንታኖ ፋስካኒ ሄቦሲክ እሳ ታቶኒን ታ ንቶክ ኮታና ባር አሪቶዋ። ኤስ ባሪ ቦርኣ አይሁድኒ ሜኒ ታቶስን ንቶክ ኮታናክ ሾሌፌትዮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ስኑንታኖ ባሶ ዙታምቤሲሴ፦ «ባርባኒንቱ ኮታታታኖ የሱስኒንታዋ!» ይሴት ቻጌቴ። ባርባን ደይ ቦእኛዋ። ");
INSERT INTO jnje_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ኤሴን ኦርፎ ፕላቶስ የሱስኒን እችሽ። ");
INSERT INTO jnje_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ሜያ ታርኦባሳክቶ ደይ ሴርአኒ ዛዉድ ማእሬ ቴትባስታ ጉፍሳት ዋይንታጅኒ ማማ ማይሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ባርኪ ዬሴፋፌ፦ «አይሁድኒ ታቶሶ! ናጋ ኔክ ስንፋውጝዋ» ይሴት ቦቼት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ፕላቶስ ሄፕሳ ጌሮ ኬስሴ ባሶክ፦ «ኤሴኑ እሳ ማጝሱ ባሳስታን ኣነ ዳኑት ስንናማቶ አሩቲክ ባሪን ንቶክ ጌሮ ክሱናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","የሱስ ሴርአኒ ዛዉድ ጉፌሬ ዋይንታጅኒ ማማ ማየ ጌራካሎ ኬሲ። ፕላቶስ፦ «ኤሴ አሱስ ሀንፌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ማግኒ ጋኝኜ ሜናዋ ታርኦኒ ሜኒ አእስኛአሲና ብየሬ፦ «ሱትዋ! ሱትዋ!» ይሴት ቻጌሴቴ። ስኑንታኖ ፕላቶስ፦ «ታ እሳ ማጝሱነ ባሳስታን ኣነ ዳኑትዋ። ንቶ ኤጳ ታምፋት ሱትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","አይሁድኒ ሜያ ዎሉግሴሬ፦ «እንኖ ቱማኒ ፋርዋ፤ ሀን አሱስ ባር ባሪን ዎልግሬ፦ ‹ታ ሀኦኒ ና› ይና ቦርአ ኤስ ቱማስማቶ ክቱናክቱ ሾልስፋዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ፕላቶስ ኤስ ባሮን ኦደናይሴ አካማኖን ድጌ። ");
INSERT INTO jnje_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ዎል ሌ ኦጃሲ ኬርካሎ ግሪፋት የሱስኒን፦ «ነ አይንሶ ያታሪ?» ይሬ ማምሲ። ስኑንታኖ የሱስ እሳ ዉዛነ ባሪክ ኣነ ዎልጉዌ። ");
INSERT INTO jnje_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ፕላቶስ ደይ፦ «ታክ ኣነ ማኬፌኖሶ? ታ ኔን ኮታናክ ወደይ ሱታናክ ሀእሱኒ ሁግናና ፋናማቶ ኣነ አሩዌኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","የሱስ ደይ፦ «ሀኦስኪን ሀእሱኒ ሁግና ኔክ እምቶ ሻኪ ስንፋናነ ነ ታይስታ እሳ ሁግናነ ኣፋዋ ፎናዉዛ። ታን ኔክ ኣትሬ እማ አሱስ አካማ ቦርእባ ፋርዋ።» ");
INSERT INTO jnje_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ፕላቶስ ኤስ ባሮ ኦደናይሴ የሱስኒን ኮታናክ ሾሌ። ስኑንታኖ አይሁድኒ ሜያ፦ «ሀን ባሪን ኮታታነ ነ ቄሳርኒ ኬንቴዋ። ቴትባሶን ታቶ ዛግ ባር ዙቴሬ ኬሳርኒ ጉማዋ» ይሴት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ፕላቶስ ኤስ ባሮን ኦዴናይሴ የሱስኒን ጌራካሎ ክሳት፦ «ይቶ ሹአ» ይስቴፋ ድማስታ ማጝሱኒ ካርኒ ኮዳስታክ ድ። ኤስ ድማስ እብራይስትኒ ኖኖክ «ጋባታ» ይስቴራቱ ቴግቴፋ። ");
INSERT INTO jnje_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ፋስካኒ ሄቦሲ ሆሮኒ ዎና ስና ፋር። ዎናስ ደይ እሱን ሳአቲ ስናና። ኤስ ካባሲክ ጵላቶስ አይሁድኒ ሜያክ፦ «ሀንፌዋ ታቶንቲስ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ስኑንታኖ ባሶ፦ «ትሽኩዋ! ትሽኩዋ! ሱትዋ!» ይት ቻጌሴቴ። ፕላቶስ ዎልግሬ፦ «ታቶንትስን ሱታናሮሶ?» ይ። ማግኒ ጋኝኜ ሜያ፦ «ኬሳርቴኖ ኦም ታቶኒ ኣፌዋ» ይሬ ዎሉግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ኤስ ካባሲክ ፕላቶስ የሱስኒን ሱቶናክ ኣትሬ እሚ። ባሶ ደይ የሱስኒን ኤጴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","የሱስ ሜስቀሊሶን ዎርኤ፦ «ቴትኒ ሜጋ» ይስቴፋ ድማስታ ኬሲ። ኤስ ድማስ እብራዊኒ ሜኒ ኖኖክ፦ «ጎልጎታቱ» ይስቴፋ። ");
INSERT INTO jnje_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ኤስታ ታምሜ ሱቴቴ። ባርኔን አነ ኦም ሄፕ አሱኒን፤ እሳይስን አልዳስታ፤ እሳይስን ደይ ሆእታስታ፤ የሱስኒን ጋነያሲ ዛግሬ ሱቴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ፕላቶስ ደይ፦ «ናዝሬትክ የሱስ አይሁድኒ ታቶዋ» ይፋ ትቻ ትችሴሬ ሜስቀሊሲ ቴታ ዬቲ። ");
INSERT INTO jnje_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","የሱስ ሱቴና ድማስ የሩሳሌምኒ ካታማሲክ ታአ ስንና ቦርአ ሾዎ አይሁድኒ ሜያ ኤስ ትቻሶን ፌሬትሴቴ። ትቻስ ደይ ትቼናስ እብራይዊኒ ሜኒ ኖኖክ፤ ሮምኒ ሜኒ ኖኖክናዋ ግሪክኒ ሜኒ ኖኖክናቱ ትቼ። ");
INSERT INTO jnje_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","አይሁድኒ ማግኒ ጋኝኜ ሜያ ጵላጦስኒን፦ «ነ ‹አይሁድኒ ሜኒ ታቶዋ› ይራ ትቹታታዋ። ስኑንታኖ ሀን አሱስ፦ ‹ታ አይሁድኒ ሜኒ ታቶዋ› ይ ይራቱ ትቹታዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ፕላቶስ ደይ፦ «ትችና ባሮን ትችጝዋ» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ሜያ ታርኦሳክቶ የሱስኒን ሱቴቴኔን ኦርፎ ማምባሶን እሳርባ እሳርባሲክ እሳ ኩሹ ባሶክ ካርአናክ አቼች ድምታ ባጌሴቴ። ጋግ ማዮሶን ደይ ኤጴቴ። ኤስ ጋግ ማዮስ ደኑን ካብራ ዬት ካርአ ሽማኖኒክ ዊቼርታኖ ዞቴርታ። ");
INSERT INTO jnje_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ኤስ ባሪ ቦርኣ ሜያ ታርኦሳክቶ ባሶትና ባሶትና፦ «ኦንክ ካርኒርቶ አሩኒክ እጣ ሀኡኒስታኖ ኣፋ ካራሱኒ ዉዛ» ይሴቴ። ኤስ ባር ደይ ስንናስ፦ «ማምናሶን ባሶትና ባሶትና፤ ሃኤሴቴ፤ ማምናስታ እጣ ሀእሴቴ።» ይፋ ትቻሲ ካማ ኮእኡናክ ስንና ቦርአቱ ሜያ ታርኦሳክቶ ደይ ኤካ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","የሱስ ሱቴና ሜስቀሊሲ ቴሽታ እንቶባሴዋ እንቶባስ ኤትነ፤ ክሎፓኒ አሱ ማራሚነዋ ማግደላውትኪ ማራሚነ ኤስታ የርሴፌር። ");
INSERT INTO jnje_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","የሱስኒ እንቶስ ባር ሹንፌና ናዎሳ ቴሻ የሬፌኒ ቢ። ደይ እንቶባሲክ፦ «እንቶናሴ! ናኔስ ሀንፌዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ኤሴን ኦርፎ ናዎስን፦ «እንቶነ ሀንፋዋ» ይ። ኤሴን ኦርፎ ናዎስ ማራሚኖን ኤጴ ኬባ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ኤስታን የሱስ ዙታምባሴ ኮእናማቶ አሪፋት ትቼራ ኩኒ ባር ኮኡናክ፦ «እክቴጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ኤስታክ ሱቃሮ ዋይንኒ ኡሻ ቱማ ዲና ኮዳ ፋር። ዋይንኒ ኡሻሶን አካ ኤጳናክ ችምባ ፍና ዉዛሲ ሀጵቅሬ እኦታ ዱስሬ ኖኖባሲ ቱችሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","የሱስ ዋይንኒ ኡሻሶን ሱትሬ ኡሽናይሴ፦ «ኮእዋ» ይ። ኤስታን ቴትባሶን ዳ ሙግሬ ኪት። ");
INSERT INTO jnje_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ቤይሳኒ ዎናሲ ሆሮኒ ዎና ስንና ቦርአናዋ ኤስ ቤይሳኒ ዎናስ ደይ አካማ ሄቦ ስንና ቦርአና ሱቴሬ የሬ አሱሳ ዱግኖ ቤይሳኒ ዎናሲክ ሜስቀሊስታ ኣነ ፌሽፋ። ኤስ ባሪ ቦርኣ አይሁድኒ ሜኒ አእስኛኒ ሜያ ሱቴሬ የሬ ባሶ ኦርጎሶን ኪርኤ ኬሱሶነክ አጃጆናክ ጵላጦስኒን ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ኤስታን ሜያ ታርኦሳክቶ ዬሴሬ የሱስኔን አነ ሱቴሬ የሬ ቴሱኒ ባሳ ኦርጎኖን ኪርኤሴቴ። ቱስሬ ደይ ሄፕሳሳ ኦርጎኖን ኪርኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ስኑንታኖ የሱስኒኪ ዬሴፌ ካባሲክ ባር ክትናማቶ ብያት ኦርጎባሶን ኣነ ኪርኦቶ። ");
INSERT INTO jnje_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ሜያ ታርኦሳስን እሳይስ ቴሽባሶን ኤቦክ ኬጅን ጌሬጌሬ ሀርንነዋ አካነ ኬሲ። ");
INSERT INTO jnje_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ኤስ ባሮን ብያ ባርቱ ንቶ አማኖትክ ዛላ ማኬርዋ። ማኬና ዛላስ ደይ ፉቶዋ። ማኬፌና ባር ፉቶ ስንናማቶ ባር አርፌዋ። ");
INSERT INTO jnje_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ኤስ ባር ደይ ስንናስ፦ «ባሳ ሜጋስን እሳርንኑ ኣፋ ኪቶና ዉዛ» ይፋ ትቻሲ ካማ ኮኡናክዋ። ");
INSERT INTO jnje_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ደይ ኦማ ትቻስኑ፦ «ኬጀቴ ባሪን አፍቤሲሲክ ብዮነዋ» ይፋዋ። ");
INSERT INTO jnje_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","አይሁድኒ አእስኝኛኒ ሜያኖን ድጌሴፋት ኣቾክ የሱስኒ ናዎ ስና አርማትያስኪ ዮሴፍ የሱስኒ ዱግኖሶን ኤጳናክ ጵላጦስኒን ሺጴ። ፕላቶስ ደይ ኤጳናክ አጃጀ። ኤስታን ዮሴፍ ሀምሜ ዱግኖሶን ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ዜሞ ስናክ ታልማክ የሱስኒኪ የ ንኮድሞስ ፋይባ ኬዛስር ኪሎ ስንኒ ኩምብነዋ ሬትነ ዎእቶ ሳዋ ዉዛ ኤጴ የ። ");
INSERT INTO jnje_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ዮሴፍናዋ ንኮድሞስና የሱስኒ ዱግኖሶን ኤጴ ታምሜ አይሁድኒ ሜኒ ዙቱኒ ቱማስማቶ ሽቶ ዎሽሬ ዎርአ ማማክ ክሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ባር ሱቴና ድማሲ ቶክቴራ ድ አታክልትሲ ቴሽታዋ። ኤስ ቶክቴራ ድ አታክልትሲ ጋነሲ አሱኒ ዱግኖ ግሩኖይና ጋድዶ ሹእኒ ሞጋ ፋር። ");
INSERT INTO jnje_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ቤይሳኒ ዎናሲ ሆሮኒ ዎና ስንና ቦርአናዋ ሞጋስ ደይ ታአ ስንና ቦርአና የሱስኒ ዱግኖሶን ኤስታ ካባርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ጉድዳኒ ዎኖ ሸኡ ፌቴቱኖይፌን ሜግደላዊትኪ ማራሚ ሞጋስኪ ሀሚ። ሞጋስታ ኡክቴራ ኩኒ እኛ ሹኣስ ቡካለራ ኩንፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ባር ኤለት ሀምማ ስሞን ጴጥሮስኒክናዋ የሱስ ሹንፌና ኦም ናዎሲክና፦ «ዳሚሳ ዱግኖኖን ሹእኒ ሞጋስን ኤጴቴዋ። አይ ኩኑስሴቴማቶ ኣነ አሩዌንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ኤስታን ጴጥሮስናዋ ኦም ናዎስና ኬሴሬ ሞጋሲኪ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ሄፖቤሲሴ ኤለት ሀሜቴር። ስኑንታኖ ኦም ናዎስ ጴጥሮስኒስታን ታፕቴሬ ኤልለ ዜምሜ ሞጋሲ ኤስታ ካርእ። ");
INSERT INTO jnje_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ሞግሬ ቢን የሱስ ክምቴና ማማስ ኮእባ ኩንፌን ቢ። ስኑንታኖ ስር ኣነ ግሩዌ። ");
INSERT INTO jnje_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ስሞን ጴጥሮስ ደይ ኦርፎባሴ ዬሬ ሞጋስሲ ግርን ክምቴና ማማስ ኮእባ ኩንፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ደይ ቴትባስታ ማርቴ ማማስ ክምቴ ማማስኔን ስኖይናሮን ቴትባክ ብርቴራ ኦማ ድምታ ኩንፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ኤስታን ደይ ዜምሜ ሞጋስኪ የ ኦም ናዎስ ግሪሬ ቢሬ ደይ አማነ። ");
INSERT INTO jnje_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","«ባር ክቱን ካቡናክ ሾልስፋዋ» ይፋ ትቻሲ ካማኖን ሀሽኑ ኣነ ያዳቶሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ኤሴን ኦርፎ ናዎኒ ሜያ ዎል ሌ ፌሴፌ ድማስታ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ሜግደላዊትኪ ማራሚ ሞጋሲ ጌራካሎ የሬፋት ዋስድፋር። ዋስፋት ሞጋስሲ ሞግራ ቢ። ");
INSERT INTO jnje_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ሄፕ ሀኦኒ ዎስያ ፎሮ ማያ ማየራ የሱስኒ ዱግኖ ኩናስታ እሳይስ ቦክታስታ እሳይስ ቾጎስታ ዲሴፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ባሶ ደይ፦ «ሀን አሱሴ! አዉኒ ቦርአ ዋስድፋታርኒሴ?» ይሴቴ። ባር ዎልግራ፦ «ዳምታሳ ዱግኖኖን ኤጴ ሀሜቴ። አይ ኩኑሴቴማቶ ኣነ አሩትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ኤስ ባሮን እያት ኦርፎባ ዎላ ቢን የሱስ የሬፌኒ ቢ። ስኑንታኖ ባር ስንባሶን ኣነ አሩዋ። ");
INSERT INTO jnje_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","የሱስ፦ «ሀን አሱሴ! አዉኒ ቦርአ ዋስድፋታርኒሴ? ኦንኒንሴ ሾሌድፋታሪ?» ይ። ባር አታክልትኒ ታእሶዋ እያት፦ «ዳሚሶ! ነ ኤጳታነ አይ ኩንስታማቶ ታክ ማኮዋ። ታ ኤጳ ሀማናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","የሱስ ባሮን፦ «ማራሚ» ይ። ባር ደይ ኦርፎ ዎላ እብራይስጢኒ ኖኖክ፦ «ራቡኒ» ይ። ኮትባስ ደይ፦ «አስሲኛኖ» ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","የሱስ፦ «ሀሽነ ደን አባሲክ ኣነ ሀሙት ስንና ቦርአ ታን ታኡታታዌ። ስኑንታኖ አይታሳክቶኒኪ ሀምፋት፦ ‹ታ አባታሲክናዋ አባንትሲክና፥ ሀኦናሲኪናዋ ሀኦንትሲኪና ሀማናርዋ› ይ ይራ ማኮዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ኤስታን ማግደላዊትኪ ማራሚ ሀምማ ናዎኒ ሜያክ፦ «ዳሚስን ቢጝዋ» ይ። ደይ ባር ባሪክ አዉ ማኬናማቶ ባሶክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ኤስ ጉድዳኒ ዎኖ ዋሊን ናዎኒ ሜያ አይሁድኒ ሜኒ አእስኛኒ ሜያኖን ድጌሴቴ ቦርአ ጋማላሲክቶኖን ኩልፋት ዙቴሴሬ ፌሴቴር። የሱስ ዬሬ ባሶ ጋነያስ የሬፋት፦ «ናጋ ንቶክ ስንፋውጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ኤስ ባሮን ማኬፋት ኩሹባሴዋ ቴሽባሴ አስን ባሶክ ቤሲ። ናዎኒ ሜያ ደይ ዳሚስን ብየቴይሴ አካማኖን ግርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","የሱስ ሄፕሳ ደይ፦ «ናጋ ንቶክ ስንፋውጝዋ። አባስ ታን ዎሲንናይስማቶ ታ ደይ ንቶትን ዎሱናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ኤስ ባሮን ማኬፋት ባሶስሲ ፉግኒ፦ «ኮርቶ አያናሶን ኤጴ ቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ንቶ አሱኒ ሜኒ ቦርኣሶን ፌሹን እያትነ ቦርእቤሲስ ፌሹን ኡስቶና። ንቶ አሱኒ ሜኒ ቦርኣሶን ፌሹን ኡ ሻካትነ ኣፋ ፌሹን ኡስቶና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ኤስ ካባሲክ አሲሬ ሄፔሳስን እሳይስ፤ ድድሞስ ይስቴፌ ቶማስ የሱስ ዬና ካባሲክ ባሶኔን አነ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ኦም ናዎኒ ሜያ ቶማስኒክ፦ «ዳሚስን ቢንዋ» ይሴቴ። ስኑንታኖ ባር፦ «ሙስማርክ እቼ ኩሹባስታኪ ሳካሶን ኩሹናሲ ዋይአክ ስር ዙጌራ ቢኖይ ደይ ኩሹናሲ ዋይአክ ቴሽባስታኪ ማዛኖን ታፕትራ ቢኖይ እሳንነ ኣፋዋ አማኖና ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ሄፕሳ ደይ ናጝሪሲናሪ ዎኖ ናዎኒ ሜያ እሳሪክ ፌሴቴር። ቶማስ ደይ ባሶኔን አነ ፌር። ጋማላሲክቶ ደይ ኩሉፍቶባሴ ፌን የሱስ ዬሬ ባሶ ጋነያሲ የሬፋት፦ «ናጋ ንቶክ ስንፋውጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ኤሴን ኦርፎ ቶማስኒን፦ «ኩሹኔሲ ዋይአኖን ቴሸራ ኩሹናሲ ሳካስታ ታእራ ቢዋ። ኩሹኔሶን ቴሸራ ቴሽናስታኪ ማዛሶን ታእራ ቢዋ፤ አማነር ስንታኖ አማኖኖር ስናታታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ቶማስ ደይ፦ «ዳምታሶ! ሀኦናሴ!» ይሬ ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","የሱስ ደይ ቶማስኒን፦ «ነ ቢታ ቦርአቱ አማነትዋ። ቢኖይ አማነፌ ባሶ ሱስቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","የሱስ ሀን ትቻሲ ትቾኖይ ሾዎ ቢስቴራ አሪቶኖይ ዉዛ ናዎኒ ሜያኔን አነ ፌና ካባሲክ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ስኑንታኖ የሱስ ባር ክርስቶስ ሀኦሲ ና ስንባሶን አማኖትክናዋ አማነራ ደይ ባሳ ሱናሲክ ኮእባ ፎንቶ ካ ዳናትክናቱ ሀን ትቻስ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ኤሴን ኦርፎ የሱስ ጋሊላኒ ባርሲ ቴሻክ ሄፕሳ ናዎኒ ሜያክ አምማኖን ቤስቴ። ኤስ ባሶክ አምማኖን ቤስቴናስ ደይ ሀኒሲማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ስሞን ጰጥሮስ፥ «ማኖ» ይስቴፌ ቶማስ፥ ጋሊላክ ፋ ቃናኒ ካታማሲክ ናትናኤል፥ ዛብድዮስኒ ናንጎቲስናዋ ናዎባሳስን ኦም ሄፕ ናዎስና እሳሪክ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ስሞን ጴጥሮስ ባሶክ፦ «ኩርጡሚኒ ኤሻክ ሀሚናርዋ» ይ። ባሶ ደይ፦ «ነኔን አነ ሀማኒዋ» ይሴቴ። ኬሴሬ ደይ ሃማክ ጎኑሲ ግርሴቴ። ስኑንታኖ ኤስ ዋላሲክ እሳርንኑ ኣነ ኤጶሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ዎንፋና ካባሲክ የሱስ ኤስ ባርሲ ሀእታ የሬ። ስኑንታኖ ናዎኒ ሜያ የሱስ ስንባሶን ኣነ አርሶቶ። ");
INSERT INTO jnje_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","የሱስ፦ «ናንጎትኖ! እሳ ኤሽሻ ኤጵቲ ቁርጡምሚ ፋሮሶ?» ይሬ ማምሲ። ባሶ ደይ፦ «ኣፋዋ» ይሬ ዎሉግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ባር ደይ፦ «ዩጉዶሶን ጎኑሲ ኦእታ ቴሽታ ካሞ ሀኡትዋ፤ ኤስታን ዳናቲዋ» ይ። ባሶ ደይ ሀእሴቴ። ሾዎ ቁርጡምሚ ኦቴ ስንና ቦርአ ዛትቴ ኪሱክ ኣነ ችሞቶ። ");
INSERT INTO jnje_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","የሱስ ሹንፌና ናዎስ ጴጥሮስኒን፦ «ዳሚስዋ ቢት!» ይ። ኤስ ባሪ ቦርኣ ስሞን ጴጥሮስ ዳምስ ስንባሶን ኦደናይሴ አታቱባሴ ስንና ቦርአ ማምባሶን ማየ ባሪሲ ግሪ። ");
INSERT INTO jnje_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ስኑንታኖ ኦም ናዎኒ ሜያ ዳስታን ዎኬቴስ እሳ ትያ ሜትርታኖ አካማኖን ኣነ ዎክሶቶ። ቁርጡምሚክ ቱማ ፋ ዩጉዶሶን ዛቴት ጎኑሲ ዲሴሬ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ጎኑስን ኬርሴፌ ካባሲክ ኩርጡምሚ ባርስታ ኩና ካኦኒ ጌነዋ ቱሽነ ብየቴ። ");
INSERT INTO jnje_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","የሱስ፦ «ሀሽቲ ኤሽሻ ኤጵቲ ኩርጡምሚስን ቴሾትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ስሞን ጴጥሮስ ጎኑሲ ግሪሬ እሳ ትሬዋ ኡቻስሬ ኬዜ እኛ እኛ ቁርጡምሚክ ቱማ ፋ ዩጉዶሶን ዛትቴ ዳስታ ክሲ። ኤፋቴና ሾዎ ስንፋናክኑ ዩጉዶስ ኣነ ካራቶዋ። ");
INSERT INTO jnje_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","የሱስ ባሶትን፦ «ያራ ኡፌሹ ሙትዋ» ይ። ዳሚስ ባር ስንባሶን አሪሴቴ ቦርአ ናዎሳስን እሳርንኑ፦ «ነ ኦንሶ?» ይሬ ማምሱክ ችማር ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","የሱስ ዬሬ ቱሻሶን ኤጴ ባሶክ እማት ኬሴ ኩርጡምሚሶን ደይ እሚ። ");
INSERT INTO jnje_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ኤሲስ ደይ የሱስ ክቱን ካብናኔን ኦርፎ ናዎኒ ሜያክ ኬዝሳ ዎል ሌ ኡጶባዋ። ");
INSERT INTO jnje_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ኡፌሹ ሜሴቴኔን ኦርፎ የሱስ ስሞን ጴጥሮስኒን፦ «ዮሀኒስኒ ና ስሞንኖ! ሀን ባሶስታን ደናሎኖን ታን ኬሽቴፋቶሶ?» ይሬ ማምሲ። ባር ደይ ዎልግሬ፦ «ኣ፥ ዳምታሶ! ሹንፋናማቶ ነ አሪታርዋ» ይ። የሱስ ደይ፦ «ጋሮ ጋሮ ፋንቱናሶን ኬምማ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ሄፕሳ ደይ የሱስ፦ «ዮሀኒስኒ ና ስሞንኖ፥ ታን ኬሽቴፋቶሶ?» ይ። «ኣ፥ ዳምታሶ! ሹንፋናማቶ ነ አሪታርዋ» ይ። የሱስ ዎልግሬ፦ «ናኦ ፋንቱናሲክቶኖን ኬምማ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ኬዝሳክ ደይ፦ «ዮሀኒስኒ ና ስሞንኖ ታን ሹንፋቶሶ?» ይ። ኬዝሳክ ደይ፦ «ታን ሹንፋቶሶ?» ይና ቦርአ ጴጥሮስ ሱሜሬ፦ «ዳምታሶ! ነ ዙታምባሴ አስን አሪታርዋ። ሹንፋናማቶ ደይ ነ አሪታርዋ» ይ። የሱስ፦ «ፋንቱናሲክቶኖን ኬምማ። ");
INSERT INTO jnje_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ፉቶ ኔክ ማኬፋጝዋ፦ ነ ናኦ አሱ ስንፋታ ካባሲክ ነ ቴትኔሲክ ጌሾኔሶን ታልፋክ ታርእኤራ ሹንታ ድማ ሀሜት ፋታርዋ። ስኑንታኖ ኩርእፋታ ካባሲክ ኩሹኔሶን ካብግራ ቤሳን ኦም አሱቱ ነን ታትፌርዋ። ነ ሹኖይታ ድማ ደይ ታማናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","የሱስ ኤካ ይናስ ጴጥሮስ አሮ ክቱ ክትሬ ሀኦሶን ኡልፍንሱናማቶቱ ቤስፋዋ። ኤስ ባሮን እያት፦ «ታኔን አነ ሀሚኒዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ጴጥሮስ የርቀሬ የሱስ ሹንፌና ናዎባስ ባሳ ኦርፎሴ ሀሚፌን ቢ። ኤስ ባር ደይ ሜታኡ ማስቴፋና ካባሲክ የሱስኒኪ ታእሴሬ፦ «ዳምታሶ! ኔን ኣትሬ እምኒስ ኦንሶ?» ይሬ ማምሲ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ጴጥሮስ የሱስ ሹንፌና ናዎባስን ብያት የሱስኒን፦ «ሀን አሱስ አዉ ስኒሪንሶ?» ይሬ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","የሱስ፦ «ታ ዎላ ዮና ካባኔን ባር ካክ ፎናክ ሾሌፋናነ ኔን አዉ ትርኤሶ። ነ ታኔን አነ ዬን ሀሚንዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ኤስ ባሪ ቦርኣ ናዎኒ ሜኒ ጋነያስ፦ «ኤስ ናዎስ ኣፋ ክቱና ዉዛ» ይፋ ዎላስ ዝእ። ስኑንታኖ የሱስ፦ «ታ ዎላ ዮና ካባኔን ባር ካክ ፎናክ ሾሌፋናነ ኔን አዉ ትርኤሶ?» ኡቱ ይቴኖ፦ «ኣፋ ክቱና ዉዛ» ኣነ ኡዌ። ");
INSERT INTO jnje_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ኤስ ናዎስ ሀን ቾዋሲክቶኖን ዙትሬ ዛላ ማኬሬ ትችዋ። ባር ማኬና ዛላስ ፉቶ ስንናማቶ አሪፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","የሱስ ዛግና ኦማ ሾዎ ዉዛ ፋር። ታክ ቤስቴፋናይስማቶ ባር ዛግና ዉዛስ ዙቴራ እሳርባ እሳርባሲክ ትቼ ስንፋናነ ኤስ ትቻሶን ሀን ዳስ ቴትባሲክ ዎርአክ ችማና ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ቴዎፍሎስኖ! ዜሞቲ ትችና ትቻስታ የሱስ ዎስቴና ዉዛሴዋ አሲና አሱሴ አሲና ትችጝዋ። ኤስ ትችናስ ደይ ዎስቶባሶን ጃማሬና ዎናስታን ካብግራ፥ ");
INSERT INTO jnje_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ደን ሳማ ሀማና ዎኖኔን ካርአ ዎስቴና ዎስቶሶጝዋ። ደን ሳማ ሀሚናስ ባር ኮርና ዎስባሲክ ኮርቶ አያናሲክ ካሞ አጃጅባሶን እምናኔን ኦርፎዋ። ");
INSERT INTO jnje_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","አካማ ሻናሶን ኤጴቴሬ ክትናኔን ኦርፎ ሀየዉ ስንነ ፎባሶን ሾዎ ኡግናክ አምማኖን ቢስቴ ዛላክ ኬሴ ባሶክ ቤስቴ። አቼቻስር ዎና ኬሴ ቤስቴፋፌ ሀኦሲ ታቶኒ ቾዋኖን ባሶክ አሲ። ");
INSERT INTO jnje_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ባሶኔን አነ ፌና ካባሲክ ኤካ ይሬ አጃጀ፦ «ታ ማኬና አባስኪን እምቴ አብዲሶን ኦድትታኖ የሩሳለሙን ኬሳትታ። ");
INSERT INTO jnje_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ዮሀኒስ አካክቱ ሀጵቅ፤ ስኑንታኖ ንቶ ጋሮ ዎናኔን ኦርፎ ኮርቶ አያናክቱ ሀጱቅቶት» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ባሶ የሱስኔን አነ እሳሪክ ዙቴሬ ፌሴቴን፦ «ዳሚሶ! እስራኤልኒ ታቶሶን ዎልግራ እማታ ዎናስ ሀሽኖሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","የሱስ ደይ ዎልግሬ፦ «አባስ ባሳ ሀእሱኒ ሁግናሲክ ሆስና ዎናሴዋ ነያሴ አሲን ንቶ አሩትክ ኣፋዋ ችማት ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ስኑንታኖ ኮርቶ አያናስ ንቶስታ ኬሬፋና ካባሲክ ሁግና ዳናትዋ። ኤስ ካባሲክ የሩሳለሙክ፥ ዩዳክ፥ ሳማሪያኪናዋ ሀማ ዳኒ ድላ ካርአናኔና ታክ ዛል ስናትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ኤስ ባሮን ማኬናኔን ኦርፎ ባሶ ብየፌን ደን ሳማ ሀሚ። ሻሩስ ደይ ባሪን ኤጳ ኣፌሲስኒ ኣቺ። ");
INSERT INTO jnje_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ባር ደን ሳማ ሀሚፌን ባሶ ደይ ደን ሳማ ኮትክሬ ብየፌን ዲንቆነ ፎሮ ማማ ማዮ ሄፕ አሱ ባሶ ቴሻ የሬፋት፦ ");
INSERT INTO jnje_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«ንቶ ጋሊላክ አሱ! አዋጋን ደን ሳማ ኮትክራ ብየት የሬትሪንሶ? ሀን ደን ሳማ ሀሚፌን ብየት የሱስ ደን ሳማ ሀሚፌን ብየትሲማቶ ዎል ሌ ደይ ዮኒርዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ኤሴን ኦርፎ ዳብራዛይትኒ ኩማስታን የሩሳሌም ዎልሴቴ። ኤስ ዳብራዛይትኒ ኩማስ የሩሳሌምኒስታን ዎክባስ እሳ ቤይሳኒ ዎን ኒ ኩቱኒ ኡግና ስናና። ");
INSERT INTO jnje_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","የሩሳሌም ዬሴሬ ደን ዲሴፌ ሴጌነትስታ ኬሴቴ። ኤስ ኬሴ ባሶ ደይ ጴጥሮስ፥ ዮሀኒስ፥ ያቆብ፥ እንድርያስ፥ ፍልጶስ፥ ቶማስ፥ ቤርቴሎሜዎስ፥ ማትዮስ፥ እልፍዮስኒ ና ያቆብ፥ ኮነር ይስቴፌ ስሞናዋ ያቆብን ና ዩዳና። ");
INSERT INTO jnje_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ኤስ ባሶ ዙታምቤሲሴ እሳሪክ ሀኦኒ ሺጶክ ዎንና ዎንና ዙቴሴት ፌሴቴር። ባሶኔን አነ ደይ እሳ እሳ ማሽካ ሜያ የሱስኒ እንቶ ማራሚ ኤሲስማቶ ደይ የሱስኒ አይን ሜያ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ኤስ ዎኖ ጴጥሮስ ትሬዋ ሄፓስሬ ስኒ አማኝኒ ሜኒ ጋነሲ የሬፋት ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«አይን ሜያነ! የሱስኒን ኤጳ ባሶክ ዞንስ ስና ዩዳኒ ቾዋሲክ ኮርቶ አያናስ ዜምማ ዳዊትኒኪ ካሞ ማኬና ትቻስ ካማ ኮኡናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ዩዳ እንኖስን እሳር ስንነ ፋድቴሬ ሀን እንኖ ዎስቴፌን ዎስቶሶን ዎስቴት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ስኑንታኖ ሀን አሱስ ኤስ ዎስቴና ማጙ ዎስቶባስ ዋጋክ ዳ ዋጌ። ኤስታን ስኒባሲክ ጋንደሬ ኪጤክ ካራቴ። ኬናሽባስ ደይ ፌእቴ። ");
INSERT INTO jnje_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ኤስ ቾዋሲ ደይ የሩሳለሙክ ፌሴ ባሶ ዙታምቤሲሴ አሲክ ኦድቴ። ኤስ ባሪ ቦርኣ ኤስ ዳስ ባሶ ኖኖሲክ፦ ‹አኬልዳማ› ይስቴራ ቴግቴ። ኮትባስ ደይ፦ ‹ሀርንኒ ዳ› ኡ። ");
INSERT INTO jnje_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ኤስ ባር ስንናስ ጋምን ማፃፋሲ፦ « ‹ፎና ኬባስ ኦና ስንፋውጝዋ፤ ኦኑ ባርስ ፎናታዋ› ደይ፦ ‹ባርኪ እምቴ ዎስቶሶን፤ ኦም አሱ ባሳስታን ኤጴ ዎስቶዎዋ።› ይስቴራ ትቼና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«ኤስ ባሪ ቦርኣ ዳም የሱስ እንኖ ጋነያስ ኩቲት ፌና ካባሲክ እኖኔን አነ ፌሴ ባሶስኒ፤ ");
INSERT INTO jnje_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ኤሲስማቶ ደይ ዮሀኒስኒ ሀጵቁስታን ካብራ ዳም የሱስ ደን ሳማ ሀሚና ዎናስታኔን ካርኤ አነ ፌሴ አሱኒ ሜያስን እሳ አሱ እኖኔን አነ ክቱኒ ካቡባስ ቾዋሲክ ዛል ስናናክ ሾልሱዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ኤሴን ኦርፎ ሄፕ አሱኒን ኤጴ ዬሴቴ። ኤስ ባሶ ደይ ባርሳባስ ወደይ እዮስጦስ ይስቴፌ ዮሴፍናዋ ማትያስና። ");
INSERT INTO jnje_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ኤካ ይሴሬ ሺጵሴቴ፦ «አሱ ዙታምባሴ አሲ ንባኖን አሪፌ ዳሚሶ! ሀን ሄፒሳስኒ ኦኒን ኮሪታማቶ ነ እኖክ ቤሱዋ። ");
INSERT INTO jnje_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ሺጴፌኒስ ዩዳ ቤየ ባሳ ቴትን ድማስ ሀሚና ዎስቶሴዋ ዎሲ ስናሶን ኤጴቶኒ ባርና እኖክ ቤሱታክዋ» ");
INSERT INTO jnje_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ኤስታን እጣሶን ሀእሴቴን ማትያስኒክ ኬስ። ኤስ ባሪ ቦርኣ ባር አሲሬ እሴ ዎስኒ ሜያኔን አነ ፋድቴ። ");
INSERT INTO jnje_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ፐንጠኮስቴ ይስቴ ሄቦስ ካርፋና ካባሲክ ናዎኒ ሜያ ዙታምቤሲሴ እሳሪክ እሳ ድምታ ዙቴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ዲንቆ አካማ እፑዋኒ ካማነ ፋ ካማ ደን ሳማን ያ። ባሶ ፌሴቴ ኬያስ ደይ ቱም። ");
INSERT INTO jnje_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ቴርማነ ፋ ጌኒ ዊኖ ባሶክ ቤስቴ። ባግቴ ባግቴራ እሳ እሳርቤሲሳታ ድ። ");
INSERT INTO jnje_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ዙታምቤሲሴ ኮርቶ አያናክ ቱንቴሴቴ። ኮርቶ አያናስ ባሶክ እምና አሩሲማቶ ኦማ ኖኖክ ዎሉምሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ኤስ ካባሲክ ዳ ዳስን ዬሴ ሀኦሶን ድግሴፌ አይሁድኒ ሜያ የሩሳለሙክ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ኤስ ካማሶን ኦደሴፌ ካባሲክ ሾዎ አሱኒ ሜያ ዙቴሴቴ። እሳርቤስ እሳርቤሲስ ባሶ ቴትን ኖኖሲክ ዎሉምሴፌን ኦደሴቴ ቦርአ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ዲንቆክናዋ ዳጆክና ኤካ ይሴቴ፦ «ሀን ኤካ ዎሉምሴፌ ባሶ ዙታምቤሲሴ ጋሊላክ አሱቴኖሶ? ");
INSERT INTO jnje_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ኤኪን እንኖ ዳኒ ኖኖሲክ ዎሉምሴፌን ኦደፌኒስ ኣካንሶ? ");
INSERT INTO jnje_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","እንኖ ፓርቴናክ፥ ሜድክ፥ ኤላምክ፥ ሜሶፐቶምያክ፥ ዩዳክ፥ ኬፐዶክያክ፥ ፓንቶሲክ፥ ኢስያክ፥ ");
INSERT INTO jnje_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ፍርግያክ፥ ፑንፍልያክ፥ ግጵጽክ፥ ኬሬናን ቴሻ ፋ ልብያኒ አዉራጃስቱ ፋፌኒ። እንኖ ሮሙን የ አይሁድኒ ሜናዋ አይሁድ ስና እንኖ ደይ ፋኒር። ");
INSERT INTO jnje_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ኤሲስማቶ ቀርጠስኒ አሱኒ ሜናዋ አራብን አሱኒ ሜና ዙቴሬ ሀኦሲ አካማ ዎስቶኖን እንኖ ቴትን ኖኖሲክ ዎሉምሴፌን ኦደድፌንዋ» ");
INSERT INTO jnje_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ኤስ ባሪ ቦርኣ ዙታምቤሲሴ ዲንቀሴሬ፦ «ሀን ዉዛስ ኣምባንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ስኑንታኖ እሳ እሳይስ፦ «ዋይኒን ኡሻ ኡሸሬ ዛይሴቴዋ» ይት ካኘሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ኤስ ካባሲክ ጴጥሮስ አሲሬ እሴ ዎስኒ ሜያኔን የሬፋት ካምባሶን ቴግሬ ዳራሲክ ኤካ ይት ማኬ፦ «ንቶ ዩዳኒ ዳስታኪ አሱናዋ የሩሳለሙክ ፌሴ ንቶና ዙታምንትሴ ሀን ስና ቾዋሶን አሩክ ሾሌፋትነ ታ ማኬፋና ባሮን ማእስራ ኦዶትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ሀሽ ዎናኔን ኬዝ ሳአት ስንና ቦርአ ንቶ ሳፋሬፌትስማቶ ሀን ባሶ ኣነ ዛይሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ስኑንታኖ ሀን ባር ስንናስ ራጁ እዩኤል ኤካ ይት ማኬና ባር ኮኡናክዋ፦ ");
INSERT INTO jnje_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","« ‹ሀኦሲ ኮእን ዎናሲክቶስ፤ አያናናሶን አሱ ዙታምባሴ አሲስታ ኬሱናዋ፤ ኣርቃስናዋ ማሽካ ናንጎትኒትሴ ራጅ ማክሶነ፤ ናኦኒ ሜያ ደይ ራእ ብዮነ፤ ኩርኡኒ ሜያ ደይ ሚቶ ሚቶሶነ። ");
INSERT INTO jnje_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ኤሲስማቶ ደይ ኤስ ዎናሲክቶስ፤ ኣርቃ ዎስትኛታሳታናዋ፤ ማሽካ ዎስትኛናስታና፤ አያናናሶን ኬሱናዋ፤ ባሶ ደይ ራጅ ማክሶነ። ");
INSERT INTO jnje_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ደን ሳማኪ ዲንቂ ዉዛሲክቶኖን፤ ሀን ዳስታኪ ደይ ቢስቴራ አሪቶኖይ ዉዛ ቤሱናዋ፤ ሀና፥ ጌያ፥ ጌኒ ክኢና ደይ ቤስቶና። ");
INSERT INTO jnje_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","አካማ ደይ ዲንቂ ስና ዳሚሳ ዎና ዮኖይፌን፤ ዜምማ አዋስ ታልሞና፤ አሳስ ደይ ሀንናነ ፋር ስናና። ");
INSERT INTO jnje_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ዳሚሳ ሱናኖን ቴጌፌ ባር ዙቴሬ ፉእቶና› ይዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«እስራኤልኒ አሱኒ ሜኖ! ሀን ካማሶን ኦዶትዋ። ንቶ ቴታሲክ አሪፌትስማቶ ናዝሬትክ የሱስ ባር ኦ ስንናማቶ ሀኦሲ ንቶ ጋነያስ ባርኪ ካሞ ዛግና አካማ አካማ ዎስቶስ፥ ቢስቴራ አሪቶኖይ ዉዛሴዋ ቤሶሴ ፉቶ ስኒባስ አሪቴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ባር ቴትባሲክ ሀኦሲ ዜምማ ኮፓኤና ባርኪናዋ አሪና ባርኪና ንቶክ አቴሬ እምቴዋ። ንቶ ደይ ባሪን ቱማቤስ ፎንቶ ሜኒ ኩሹስ ሱቶናክ ዛግራ ዎርሴት። ");
INSERT INTO jnje_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ስኑንታኖ ክቱስ ባሪን ኤጳ ፉኦናክ ኣነ ችማ ስንና ቦርአ ሀኦሲ ክቱስ ሻናኖን ትሽክራ ባሪን ክቱኒ ካብግ። ");
INSERT INTO jnje_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ዳዊት ደይ ባሳ ቾዋሲክ ኤካ ይ፦ « ‹ዳሚስን ዎንና ዎንና ስንናስታቱ ቢፋዉጝዋ፤ ናዎኖይናማቶ ባር ሆእታ ቴሽናስታቱ ፌዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ኤስ ባሪ ቦርኣ ንብናስ ግሬ፤ ኖኖናስ ደይ ግራክ ቱንኢቴ፤ ኤሲስማቶ አሽናስ ደይ አብድክቱ ፋፋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ካናሶን ኬኦኒ ድማስ ኣፋ ቤያና ዉዛ፤ ኮርቶኔስኒ ደይ፤ ሞጋስ ኩፐ ፉእቶናክ ኣፋ ዛጉታዉዛ። ");
INSERT INTO jnje_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ካኒ ኡግናሶን ታክ አስሲትዋ፤ ነ ታኔን አነ ስኒታ ቦርአ፤ ግራናስ ቱማ ስናና።› ");
INSERT INTO jnje_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«አይታሳክቶኖ! ዜሞቲ አባን ሜኒ ጋነያስን እሳይስ ስና ዳዊት ክትሬ ካባርቴናማቶ፤ ሞግባስ ደይ ሀውጙኔን ካርአ እኖክክ ፋናማቶ አምማኖን ንቶክ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ስኑንታኖ ዳዊት ኤስ ባሮን ማኬናስ ራጁ ስንና ቦርአናዋ ደይ ሀኦሲ ባርኪ፦ ‹ነ ዛላስኒ እሳይስን ነ ዝግሞስታ ዱሱናዋ› ይት ቴያ ግርና አብድን ካማሶን አሪሬ ፌር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ኤስ ባሪ ቦርኣ፦ ‹ክርስቶስ› ኬኦኒ ድማስ ፉእቶኖይናማቶናዋ አሽባስ ደይ ሞጋስ ኩፕኖይናማቶናቱ ዜምሜ ብያት ክቱኒ ካቡና ባር ቾዋሶን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ኤስ የሱስኒን ሀኦሲ ክቱኒ ካብጝዋ። እንኖ ደይ ዙቴራ ኤስ ቾዋሲክ ዛልዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ሀኦሲ ሆእታ ቴሽታ ዱክ ደን ቴግፌና ካባሲክናዋ ኮርቶ አያናስ አብድኖን አባስኪን ኤጵና ካባሲክና ሀን ቢፌት ባሮናዋ ኦደፌት ባሮና ኬስዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","ኤሴ ደን ሳማ ኬሳስ ዳዊት ስና ቤይባሶን ዳዊት ቴትባሲክ ኤካ ይት ማኬዋ፦ « ‹ዳሚስ ዳምታሲክ፤ ጉማኔስኒ ነ ሀእሱኒ ሁግናስ ስካሎስ፤ ዛጉና ካባኔን፤ ሆእታ ቴሽናስታ ዱዋ።› ");
INSERT INTO jnje_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«ኤሴ ሀን ንቶ ሱት የሱስኒን ሀኦሲ ዳም ደይ ክርስቶስ ዛግናማቶ እስራኤልኒ ሜኒ ዳራስ ዙቴሬ ፉቶክ አሩዎዋ!» ");
INSERT INTO jnje_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ዳራስ ደይ ኤስ ባሮን ኦደሴፌ ካባሲክ ንብቤሲስ አካማኖን ሳፋርሴሬ ጴጥሮስኒንናዋ ኦም ዎስኒ ሜያኖንና፦ «አይን ሜያነ! ኤኪን አዉ ዛጉንሪንሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ጴጥሮስ ደይ ኤካ ይ፦ «ሀርሙትዋ፤ ቦርንትስ ደይ ፌሹን ኡስቶናክ እሳ እሳርኒትስ የሱስ ክርስቶስኒ ሱናሲክ ሀጱቅቶት። ሀኦሲ እማ ስና ኮርቶ አያናሶን ኤጳቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","አብድን ካማስ ንቶክናዋ ናንጎትኒትሲክቶክናዋ። ኤሲስማቶ ደይ ዳማ ሀኦሲ ባርኪ ቴጎና ዎክሶክ ፌሴ ባሶ ዙታምቤሲሴ አሲክናዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ደይ ኦማ ሾዎ ካማ ዛላ ማኬት፦ «ሀን ኤልጛ ኮኒቶስታ ዮን ኬኦስኒ ቴትንትሶን ፉኦትዋ» ይሬ ኪት። ");
INSERT INTO jnje_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ባሶስኒ ሾዎቤሲስ ኤስ ካማሶን ኤጴቴሴሬ ሀጱክቴሴቴ። ኤስ ዎኖ ኬዝ ኩም ስኒ አሱኒ ሜያ አማነሬ ዳይቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ባሶ ደይ ዎስኒ ሜኒ አሱሶን ኦደሴሬ እሳሪክ ፎክ፥ ቱሻሶን እሳሪክ ሙክናዋ ሺጶክና ችሜት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ኤስ ካባሲክ ዎስኒ ሜኒ ኩሹስ ሾዎ ቢስቴራ አሪቶኖይ ዉዝነዋ ዲንቅነ ዛግቴት ፋር ስንና ቦርአ አሱ ዙታምባሴ ድጌ። ");
INSERT INTO jnje_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","አማኝኒ ሜያ ዙቴሬ እሳርክቱ ፌሴፌ። ፋ ዉዝቤሲስ ዙቴራ ጋራ። ");
INSERT INTO jnje_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ፋ ዉዝቤሲሶናዋ ኦቱምቤሲሶና ክስሬ ዋጌፋፌ ኤስ ዋጋሶን እሳርባ እሳርባሲክ ሾልስናማቶ ሃኤ እሜት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ዎንና ዎንና ቤቴሜቅደሲሲ ዙቴሴት ፌሴቴር። ኬቤስ ኬቤሲሲክ ደይ ዎል ቴግሴፋፌ እሳሪክ ቱሻሶን ባቴ ግራክናዋ ማአ ንባክና ሜሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ዳሚስን ደይ ጋላቴሴት ፌሴቴር። ዳራ ዙታምባሴ ደይ ባሶትን ኡልፍንስት ፌር። ሀኦሲ ደይ ፋሩን አሱኒ ሜያኖን ዎንና ዎንና ባሶስታ ዳይስት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","እሳ ዎና ጴጥሮስናዋ ዮሀኒስና ሀኦ ሺጵቴፋና ዎን ኒ እዝግን ሳአትስታ ቤቴሜቅደሲሲክ ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ኤስታክ «ጋዳ» ይስቴፋ ቤቴሜቅደሲሲ ፍኝ ፋር። ኤስታክ እንቶባስ ኬንስኒ ላፋ ስንነ ኮንቴ እሳ አሱ ፌር። ባር ደይ ቤቴሜቅደሲሲ ግሪፌ አሱስኪን ዋጋ ሺጶናክ ዎንና ዎንና አሱኒ ሜያ ዎርኤ ቴሾስ ዱስት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ኤስ አሱስ ጴጥሮስናዋ ዮሀኒስና ቤቴሜቅደሲሲ ግርሴፌን ብያት ዋጋ እሞነክ ባሶትን ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ጴጥሮስናዋ ዮሀኒስና አሱሲክ ኮትክሬ ብየፋት ጴጥሮስ፦ «ሀጝ እኖክ ቢዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","አሱስ ደይ ባሶኪን እሳ ዉዛነ እሞነርዋ እያት ኮትክሬ ቢ። ");
INSERT INTO jnje_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ስኑንታኖ ጴጥሮስ፦ «ብርነዋ ዋርቄነ ታክክ ኣፋዋ። ስኑንታኖ ታክ ፋ ባሮን ኔክ እማናዋ። ናዝሬትክ የሱስ ክርስቶስኒ ሱናሲክ ካብራ ኩቱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ሆእታ ኩሹባስ ዛቴ ካብግኒ ጌሬጌሬ ዎቾባሴዋ ኩማርኩሽባሴ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ካብሬ ደይ የሬ። ኩቲት ባሶኔን አነ ቤቴሜቅደሲሲ ግር። ባር ደይ ኩቲት፥ ፍሌት ሀኦሶን ጋላቴት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ዳራሳክቶ ዙታምቤሲሴ ኩትፌናዋ ሀኦሶን ጋላቴፌና ብየቴ። ");
INSERT INTO jnje_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","«ጋዳ ፍኛ» ይስቴራ ቴግቴፋ ቤቴሜቅደሲሲ ፍኝታ ዲፋት ሺጴት ፌ ባር ስንናማቶ አሪሴቴ። ባሳስታክ ስና ቾዋሲክ አካማኖን ዳጀሴሬ ዲንቀሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ፋሪ አሱስ ጴጥሮስኒንናዋ ዮሀኒስንና አሲን ዛታት ፌን ዳራስ ዙቴሬ ዲንቆክ፦ «ሶሎሞን ዳጋፍዮ» ይስቴፋ ድማስታ ባሶክ ኤለት ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ጴጥሮስ አሱኒ ሜያኖን ቢናይሴ ኤካ ይ፦ «እስራኤልኒ ዳራሶ! ሀን ቾዋሲክ አዉኒ ቦርአ ዲንቀድፌትሪንሶ? አዉኒሮን ኮትክራ ቢድፌትሪንሶ? እንኖ ቴትንር ሁግናክ ወደይ ሀኦሶን ድጎኒሲክ ሀን አሱስ ፋሪሬ ኩቱናክ ዛግንርነ ፋር ስንና ንቶክ ቤስቴፋዎሶ? ");
INSERT INTO jnje_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","እንኖ አባን ሜያ አብራሀም ይሳቅናዋ ያቆብና አሲ ሀኦ ባር ና የሱስኒን ኡልፍንስዋ። ስኑንታኖ ንቶ ክቱናክ ጵላጦስኒ ስና ኣትራ ባሪን እሜትዋ። ጵላቶስ ደይ ኮታናክ ሾሌን ንቶ፦ ‹ኣነ ሾሌፌንዋ› ይሴት። ");
INSERT INTO jnje_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ንቶ ኮርቶስንናዋ ኦኮስንና፦ ‹ኣነ ሾሌፌን› ይሴፋት ካ ዎር ባሪን ኮታናክ ሺጵሴት። ");
INSERT INTO jnje_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ካ እምፌ ባሪን ዎርሴት። ስኑንታኖ ሀኦሲ ባሪን ክቱኒ ካብግ። ኤስ ቾዋሲክ እንኖ ዛልዋ። ");
INSERT INTO jnje_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ሀን ቢፌት አሱስናዋ አሪፌት አሱስና ፋሪሬ ችማ ዳናስ የሱስኒ ሱናሲክ ቤስቴ አማንቶሲክዋ። የሱስኒክ አማኖባሲክ ዙታምንትሴ አሲ ስና ቱማ ፋሩ ዳንዋ። ");
INSERT INTO jnje_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«ሀሽኑ አይታሳክቶኖ! ሀን የሱስኒስታ ዛግሴት ባር ንቶትን ሀእሲፌ ባሶስማቶ ቱጋኦኪ ዛግሴትማቶ አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ስኑንታኖ ሀኦሲ ዜምማ ራጁኒ ሜያ ዙታምቤሲሴ አሲክ ካሞ፦ ‹ክርስቶስ› ሻና ኤጴቶናክ ሾልስፋ ይና ካማስ ኤሲሲክ ኮኡናክ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ኤሴ ቦርንትስ ፌሹን ኡስቶናክ ሀርምራ ዳሚሲክ ዎሉትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ዳሚስኪን ሄፕሳ ዎላ ጋድዶ ስናት ዎና ንቶክ ዮናክ ዳሚስ ዜምሜ ኮርና ክርስቶስኒን ንቶክ ዎሱና። ");
INSERT INTO jnje_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ኤስ የሱስ ደን ሳማኪ ፎናስ ሀኦሲ ዜምማ ኮርቶ ራጁኒ ሜያክ ካሞ ማኬናሲማቶ ሀን ዳስ ዙቴራ ሄፕሳ ዎላ ጋድዶ ስንና ዎሱስቶና ካባኔጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ሙሴ ደይ ኤካ ይዋ፦ ‹ዳማ ሀኦሲ ታን ካብግናሲማቶ ንቶ ጋነያስን ራጁኒን ንቶክ ካብጉናዋ። ባር ንቶክ ማኮና ባሮን ዙትራ ኦዶትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ኤስ ራጁኡስን ኦዶ ቤያ ባር ዙቴሬ ዳራሳ ጋነስን ኦር ኬሴ ትሹናዋ።› ");
INSERT INTO jnje_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ሳሙኤልኒስታን ካብሬ ፌሴ ራጁኒ ሜያ ዙቴሬ ሀን ዎናስ ቾዋኖን ኤሲስማቶ ማክሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ራጁኒ ሜያክ ማክቴ አብዲስ ንቶክዋ፤ ኤሲስማቶ ደይ ሀኦሲ አብራሀምኒክ፦ ‹ሀን ዳስታክ ፌ ዳራኒ ሜያ ዙቴሬ ነ ዛላሲክቱ ሱስቶሶነዋ› ይራ አባኒሳክቶኔን አነ ግርና ቴያሲ ካማ ንቶክቱ ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ኤስ ባሪ ቦርኣ ሀኦ ዜምማ ናዉባስን ካብግራ ዎስናስ ንቶክዋ። ኤስ ባሮን ደይ ዛግናስ ንቶ እሳርኒት እሳርኒትስ ማጙ ዎስቶኒትስኒ ዎልን ሱሳናክዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ጴጥሮስናዋ ዮሀኒስና ዳራሲክ ማክሴፌን ማግኒ ሜናዋ ቤቴሜቅደስኒ ታሶን ጋኝኛስና ኤሲስማቶ ደይ ሴዱክአውን ሜያ ባሶክ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ኤስ ሄፕ ዎስኒ ሜያ ዳራሲክ የሱስኒ ክቱኒ ካቡሶን አሱቤሲሲክናዋ ባርኪ ካሞ ክቱኒ ካቡ ፎባሶንና ኮቴ ማክሴቴ ቦርአ አካማኖን ግእቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ኤስ ባሪ ቦርኣ ጴጥሮስናዋ ዮሀኒስና አሲን ኤጴሬ ጌሮክ ዋላ ስንና ቦርአ ዎናናኔን ታቶኒ ኬር ፎሶነክ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ስኑንታኖ ባሳክቶኒ ካማሶን ኦደ ባሶ ጋነያስን ሾዎቤሲስ አማነሴቴ። አማነ አሱኒ ሜኒ ፋዳስ ደይ ኡች ኩማ ስናና። ");
INSERT INTO jnje_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ዎኖትርክ አይሁድኒ ሜኒ ጋኜ ሜናዋ ኩርኡኒ ሜና ደይ ሙሴኒ ቱማሲ አስሲኛኒ ሜያ የሩሳለሙክ ዙቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ዙቴሴ አሱኒ ሜኒ ጋነያስን ማግኒ ጋኝኜ ሜኒ ጋኛ ሃናናዋ ኬያፋና፤ ዮሀኒስናዋ እስኪንድሮስና፤ ማግኒ ጋኝኜ ሜኒ ጋኛአሳ ኬርክ ሜያኔን ዙቴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ባሶ ደይ ጴጥሮስናዋ ዮሀኒስና አሲን ጋነቤሲስ ዬታት፦ «ሀን ባሮን ዛግሴትስ አሮ ሁግናክ ወደይ ኦኒ ሱናኪንሶ?» ይት ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ኤስ ካባሲክ ጴጥሮስ ኮርቶ አያናክ ቱንቴሬ ኤካ ይት ዎልጊ፦ «ዳራሳ አእስኛናዋ ኩርኡኒ ሜያነ! ");
INSERT INTO jnje_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ሀሽ ሀውጙ እንኖ ማሙስቶኒስ እሳ ላፋ አሱሳታ ዛግቴ ማአ ዎስቶሴዋ ኣካክ ፋርናማቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ሀን አሱስ ፋሪሬ ንቶ ስና የሬናስ ንቶ ሱትን ሀኦሲ ደይ ክቱኒ ካብግና ናዝሬትክ የሱስ ክርስቶስኒ ሱናሲክ ስንናማቶ ንቶናዋ እስራኤልኒ ዳራ ዙታምባሴ አሲክና አርቶ ስኑጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ኬያሶን ኬርእፌ ንቶ ካሽራ ሀእት ሹኣስ ባርዋ፤ ባር ደይ ካጃስታ ዱን ሹአዋ። ");
INSERT INTO jnje_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ኤስ ባሪ ቦርኣ ፋሩ ኦማ ኦኒክኑ ኣፋዋ። እንኖ ፋሩንክ ሾልስና ሀኦሲ አሱኒክ እምና ሱና ባርኔን ኦማ ሳማኔን ዳኩክ ኦኑ ኣፌዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ሾንጎን ሜያ ጴጥሮስናዋ ዮሀኒስና ድጋ ፎንቶኖን ማክሶቤሲሶን ብየቴሴ አሩቤስ ፎንቶ አሱ ስኖቤሲሶን አሪሴቴር ስንና ቦርአ ዲንቀሴቴ። የሱስኔን አነ ፌሴር ስኖቤሲሶን ደይ አሪሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ፋር አሱስ ጴጥሮስኔን ዮሀኒስኔን አነ የሬፌኒ ብያት ማክሶነ ዉዛ ቱሩክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ኤስታን ሾንጎስታን ኬሶነክ ዛግሴፋት ኤካ ይት ሜርኬሴቴ፦ ");
INSERT INTO jnje_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«ኤኪን ሀን አሱሳክቶኒስታ አዉ ዛጉንሪንሶ? የሩሳለሙክ ፌ አሱ ዙታምባሴ አሲክ ባሶ ዛግሴቴ ቢስቴራ አሪቶኖይ ዉዛስ አርቶ ስኒዋ። ኤስ ባሪ ቦርኣ ሞርሞንክ ኣፋዋ ችማኒ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ስኑንታኖ ሀን ቾዋሲ ዳራሳ ጋነሲ ታጉኖይናማቶ ሀውጙኔን ኤካሎ ሀን የሱስኒ ሱናሶን ካብግሬ ኦንክኑ ማክሶኖይቴማቶ ዴሲራ ካላንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ኤስታን ባሶትን ቴግሴሬ የሱስኒ ሱናሲክ እሳንነ ማክሶኖይቴማቶ ወደይ አሱሶኖይቴማቶ ችኒሬ አጃጀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ስኑንታኖ ጴጥሮስናዋ ዮሀኒስና ዎልግሬ ኤካ ይሴቴ፦ «ሀኦሲክ አጃጃሞስታን ንቶክ አጃጃሞንክ ሀኦሲ ስናክ ሾልሱኖሶ? ንቶ ቴትንትሲክ ማኬቤትሶ። ");
INSERT INTO jnje_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","እንኖ ቢን ባሮናዋ ኦደኒ ባሮና ማኮ ኣፋ ቤያንዉዛ» ");
INSERT INTO jnje_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ዳራሳ ጋኘ ሜናዋ ሾጝጎስታ ዲሴፌ ባሶና ጴጥሮስኒንናዋ ዮሀኒስንና ኬኡክ እሳ ቾዋነ ዳኖ ቤዮቤሲሲክ ደይ ዳራስን ድግሴፋት ሄፕስ ደይ ዴሲሬ ኮቴ ጋፉክሴቴ። ኤስ ባሮን ደይ ዛግሴቴስ ዳራስ ዙቴሬ ስና ቾዋሲክ ሀኦሶን ጋላቴት ፌር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ኤስ ቢስቴራ አሪቶኖይ ዉዛሲክ ፋር አሱስ ዎጋባስ አቼቻስርኔን ደናሎ። ");
INSERT INTO jnje_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ጴጥሮስናዋ ዮሀኒስና ኮቴሴቴኔን ኦርፎ አማኝ ስና ዞሞቤሲሲክ ዬሴሬ ማግኒ ጋኝኜ ሜናዋ ኩርኡኒ ሜና ማክሴቴ ባሮን ዙትሬ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ባሶ ደይ ኤስ ባሮን ኦደሴቴይሴ እሳሪክ ካምቤሲሶን ቴግሬ ሀኦሲክ ኤካ ይት ሺጵሴቴ፦ «ሳማሴዋ ዳሴ፤ ባሪሴዋ ስሩክ ፋ ቴስቶሴ አሲን ዙትሬ ቴስ ዳሚሶ! ");
INSERT INTO jnje_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ኮርቶ አያናሲክ ካሞ ዎስትኛነ ስና አባን ዳዊትኒ ናኖስ፦ « ‹አዛብኒ ሜያ አዉኒሮን ግእቴሴቴሶ? ዳራስ አዉኒሮን ሽማክ ኮፓኤሴቴሶ? ");
INSERT INTO jnje_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ዳስታክ ፌ ታቴ ሜያ ሆሬሴሬ፤ ዳሶን ሀእሲፌ ባሶ ደይ እሳሪክ ዙቴሴሬ፤ ዳሚሳታንናዋ ባሳ ሙድቶሳታና ካብሴቴ።› ይራ ማኬ ሀኦሲ ነዌ። ");
INSERT INTO jnje_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«ፉቶሲክ ሄሮድስናዋ ፐንቴናው ጵላቶስና ኣዛቢስኔን እስራኤልኒ ዳራስኔን ሀን ካታማስ ሙድቶ ዛግታ ኮርቶ ዎስትኛነ የሱስኒስታ ካብሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ኤስ ባር ደይ ኤካ ስንናስ ነ ዜምማ ነ ሁግናሲክናዋ ነ ፍቃድሲክና ኮፓኤታ ባሮን ኮእሶነክዋ። ");
INSERT INTO jnje_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ሀሽኑ ዳምኒሶ፤ ፎኮራቤሲሶን ቢዋ። ዎስትኛኔሳክቶ ካምኔሶን ድጋ ፎንቶኖን ማክሶነክ ችማ ባሶክ እማ። ");
INSERT INTO jnje_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ኮርቶ ዎስትኛነ የሱስኒ ሱናሲክ ሜታን ሜያ ፋርሶነክናዋ ቢስቴራ አሪቶኖይ ዉዝነ፤ ዲንቅነ ዛግቶናክ ኩሹኔሶን ሾጞዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ሺጵሴቴኔን ኦርፎ ዙቴሴሬ ፌሴቴ ድማስ ሾርኬ። ዙታምቤሲሴ ኮርቶ አያናክ ቱንቴሴቴ። ሀኦሲ ካማኖን ድጋ ፎንቶኖን ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","አማኝኒ ሜያ ዙቴሬ እሳ ንባክናዋ እሳ ሳፋራክናቱ ፌሴፌ። ኦኑ፦ «ሀኒስ ታርዋ» ይፌና ዉዛ ኣፋ። ፋ ዉዝቤሲስ ዙቴራ ጋራ። ");
INSERT INTO jnje_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ዎስኒ ሜያ ደይ ዳም የሱስኒ ክቱኒ ካቡሶን አካማ ሁግናክ ዛላ ማክሴት ፌሴቴር። ዙታምቤሲሴ አሲስታ አካማ ሀኦኒ ኦትማ ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ዳሶን ወደይ ኬያሶን ዋጌፋፌ ዋግቤሲሶን እሳ ባርስታቱ ቴሸሴፌ ስንና ቦርአ ጋነቤሲስ እሳ ራካታ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ዋጋሶን ቴሸሬ ዎስኒ ሜያክ እሜት ፌሴቴር። እሳ እሳርቤሲሲክ ሾልስናስንነ ፋሮን ሃኤት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ኮንቴና ዳባስ ቆጲሮስ ስና ዮሴፍ ይስቴ እሳ ሌዊ ፌር። ዎስኒ ሜያ ባሪን፦ «ባርናባስ» ይሬቱ ቴግሴፌ። ኮትባስ ደይ፦ «ችኑኒ ና» ኡ። ");
INSERT INTO jnje_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ባር ደይ ዳባሶን ዋጌሬ ዋጋሶን ቴሸሬ ዎስኒ ሜያክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ሀናንያ ይስቴ እሳ አሱ አሱባ ሳጵራኔን ዳ ክስሬ ዋግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","አሱባስ አሪፌኒ ኤስ ዳ ዋግቴና ዋጋስኒ ፉኤፋት ታሜ ዎስኒ ሜኒ ዎቾስ ኩንስ። ");
INSERT INTO jnje_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ስኑንታኖ ጴጥሮስ፦ «ሀናንያኖ! ኮርቶ አያናሶን ኤሻታክናዋ ዳስ ዋግታን ፉኦታክና አዉኒ ቦርአ ሴጣና ንብኔሲ ግርሶ። ");
INSERT INTO jnje_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ክስራ ዋጎኖይፌን ዳስ ኔርታኖሶ? ክስራ ዋጌታኔን ኦርፎ ዋጋስ ኔርታኖሶ? ኤኪን አዉኒ ቦርአ ሀን ዉዛሶን ንብኔሲ ሳፋሬትሶ? ሀኦሶንቱ ኤሽታኖ አሱኒንታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ሀናንያ ኤስ ካማሶን ኦደናይሴ ኬሬ ዎርኤ ክት። ኤስ ባሮን ኦደ አሱኒ ሜያ ዙቴሬ አካማኖን ድጌሴቴ ");
INSERT INTO jnje_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ናኦኒ ሜያ ካብሴሬ ክቱባሶን ኪምሜ ካባርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ኬዝ ሳአትኔን ኦርፎ አሱባስ ቴጎባሳታ ስና ቾዋሶን አሩኖይ ያራ ካርእ። ");
INSERT INTO jnje_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ጴጥሮስ ደይ፦ «ማኬቤ፤ ዳንትሶን ዋግሴትስ ሀን ዋጋስኖሴ?» ይ። ባር ደይ ዎልግራ፦ «ኣ፤ ሀን ባርስቱ ዋጌንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ጴጥሮስ ደይ፦ «ዳሚሳ አያናኖን ፋታኖክ ኣካክ እሳሪክ ሜርኬትሴ? ኤሴ ቴጎኔስኒ ካባሬ አሱኒ ሜኒ ዎቾስ ሀን ፍኚስቱ ፋዌ። ኔን ደይ ኤጴ ካባርሶነርዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ባር ደይ ጌሬጌሬ ዎቾባስ ኬሬ ዎርአ ክት። አሱኒ ሜያ ደይ ግርሴቴን ክትራ ኩንፌን ዳንነ ታሜ ቴጎባሳ ሞግን ቴሻ ካባርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ቤቴክርስታኒስናዋ ኤስ ባሮን ኦደ አሱኒ ሜያ ዙታምቤሲሴ አሲስታና አካማ ድጋ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ዳራሳ ጋነሲ ሾዎ ቢስቴራ አሪቶኖይ ዉዝነዋ ዲንቅነ ዎስኒ ሜኒ ኩሹስ ዛግቴት ፋር። ዙቴሬ እሳ ንባክ ሶሎሞን ዳጋፍዮ ይስቴፋ ድማስታ ዙቴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ባሶኔን ኦም አሱ ባሶስ ዎእቶክ ኦኑ ችምፌር ኣፌ። ስኑንታኖ ዳራስ አካማኖን ኡልፍንስት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ዳሚሲክ አማነፌ ኣርቃርናዋ ማሽካሬ አካማኖን ዳይቴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ጴጥሮስ ኤስታ ካሞ ሀሚፌና ካባሲክ ይራራባስኑ ሜታን ሜያስታ ካሞ ኣታናክ ሜታን ሜያኖን ኦፖታናዋ ሳኦታና ዎርኤ ኡጉንታ ክስሬ ኩንስት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","አሱኒ ሜያ የሩሳሌምኒ ብራቶስታ ፋሴ ካታማሲክቶስኒ ሜታን ሜያኖናዋ ኪና አያና ኤጳን ሜቴት ፌ ባሶትና ኤጴ ዬሴት ፌሴቴር። ሜታን ሜያ ደይ ዙቴሬ ፋርት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ማግኒ ጋኝኜ ሜኒ ጋኝኛስናዋ ባርኔን አነ ፌሴ ሴዱቃውን ሜኒ ኬን ስና ባሶና ዙቴሬ ኮናክ ዎስኒ ሜያስታ ካብሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ዎስኒ ሜያኖን ኤጴሬ ዳራሳ ታቶኒ ኬር ጌደሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ስኑንታኖ ዳሚሳ ዎስያ ዋሲ ታቶኒ ኬያሶን ጋችቻ ባሶትን ክሳት፦ ");
INSERT INTO jnje_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«ሀምፋት ቤቴሜቅደሲሲ የሬፋት ሀን ካኒ ካማሶን ዙትራ ዳራሲክ ማኮትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ዎስኒ ሜያ ደይ ዎኒፋና ካባሲክ ባሶክ ማክቴናስማቶ ቤቴሜቅደሲሲ ሀሜ አሲሴቴ። ማግኒ ጋኝኜ ሜኒ ጋኝኛስናዋ ባርኔን አነ ፌ ባሶትና ዬሴሬ ሾንጎስታ ዲሴፌ ባሶትናዋ አይሁድኒ ኩርኡኒ ሜያኖና እሳሪክ ዙትሴቴ። ዎስኒ ሜያኖን ደይ ኤጴ ዮሶነክ አሱኒን ታቶኒ ኬር ዎስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ስኑንታኖ ታሶን ሜኒ አእስኛኒ ሜያ ታቶኒ ኬር ሀሜሬ ኣነ ዳኖቶ። ዎል ሌ ዬሴሬ ደይ፦ ");
INSERT INTO jnje_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«ታቶኒ ኬያስ ጋማላ ማእስራ ኩሉፍቴራ የሬር፤ ታሶስ ደይ ፍኝባስታ የርሴፌኒ ቢን። ስኑንታኖ ጋችቻ ግርራ ኦኒንኑ ኣነ ዳነኒ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ቤቴሜቅደስኒ ታሶን ሜያኖን አጃጀፌ ባርናዋ ማግኒ ጋኝኜ ሜና ኤስ ባሮን ኦደሴቴይሴ፦ «ሀን ባር አዉታሶ?» ይሴት ስና ዉዛሲክ ኤጴ ማክሶነ ዉዛ ትሽ። ");
INSERT INTO jnje_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ኤስ ካባሲክ እሳ አሱ ዬሬ፦ «ታቶኒ ኬር ታትት አሱሳክቶ ቤቴሜቅደሲሲ የርሴፋት ዳራስን አሲድፌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ኤስታን ታሶሳ ጋኛናዋ ባሳ ዎስትኛስና ሀሜ ባሶትን ኤጴ ዬሴቴ። ስኑንታኖ ዳራስ ሹአክ ባሶትን እችኖይናማቶ ድግሴፋት ሁግናክ ኣነ ኤጶቶ። ");
INSERT INTO jnje_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ዎስኒ ሜያኖን ኤጴቴሾ ሾንጎስ ስና ዬትሴቴ። ማግኒ ጋኝኜ ሜኒ ጋኝኛስ ኤካ ይት ማምሲ፦ ");
INSERT INTO jnje_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«ሀን ሱናሲክ ዳራስን አሱኖይትማቶ ካላ ፋኒር፤ ስኑንታኖ ንቶ የሩሳሌምኒ ዳራስን አስሲራ ኮእስት፤ ደይ የሱስኒን ዎሪስ እንኖ ዛግራ ባሳ ሀንናሲክ ማሙስቶኒክ ሾልሴፌት!» ");
INSERT INTO jnje_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ጴጥሮስናዋ ኦም ዎስሳክቶና ዎልግሬ፦ «አሱኒክ አጃጃሞስታን ሀኦሲክ አጃጃሞንክቱ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ንቶ እኦስታ ሱታ ዎርሴት የሱስኒን አባኒሳ ሀኦ ባሪን ክቱኒ ካብጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ባር ደይ እስራኤልኒ ዳራሲክ ሀርምነዋ ቦርኣሶን ፌሹን ኡነ እማናክ ሀኦሲ ባሪን ዙታምባሴ አሲ ዞንስናዋ ፋቱኒርና ዛግራ ኦእትባስታ ዱናክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","እንኖ ደይ ኤስ ቾዋሲክ ዛልዋ። ሀኦሲክ አጃጃሜፌ ባሶክ እምና ኮርቶ አያናስ ደይ ዛላዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ሾንጎስታ ዲሴ ባሶ ደይ ኤስ ባሮን ኦደሴቴይሴ አካማኖን ሃሬሴሬ ባሶትን ዎሩክ ሾልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ስኑንታኖ ዳራ ዙታምባሴ አሲ ስና ኡልፍንቶ ቱማስ አስሲኛ ጋማልያ ይስቴ ሾንጎስታ ዲሴፌ ባሶስኒ እሳ ፈሪሳው ካብሬ ዎስኒ ሜያኖን ጌሮ ክሶነክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ኤስታን ሾንጎስታ ዲሴፌ ባሶክ ኤካ ይ፦ «እስራኤልኒ አሱኒ ሜያነ! ሀን አሱሳክቶኒስታ ዛጉትክ ሳፋሬት ባርስታን ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ዜሞ ስናክ ቴዎዳስ ይስቴ አሱ ቴትባሶን እኝ ዛግሬ ካብን አቼች ት አሱ ደይ ባርኪ ዞኑስቴሴቴ። ስኑንታኖ ባር ዎርቴ። ባርኔን ዞኑስቴ አሱሳክቶ ደይ ሲክቴ። ኮፓኤና ዉዛስ ደይ ባክ ትሽራ ፉእቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ኤሴን ኦርፎ ደይ ዳራኒ ፋዳ ዛግቴና ካባሲክ ጋሊላክ ዩዳ ካብሬ ሾዎ ዳራኒን ባርኪ ዞኑስቶናክ ዛግ። ኤስ አሱስ ደይ ዎርቴ። ባርኪ ዞኑስቴ ባሶ ደይ ሲክቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ኤስ ባሪ ቦርኣ ሀሽ ታ ንቶክ ማኬፋናስ ሀን አሱሳክቶኒን ቤያትክናዋ ባሶስታን ሻቶትክናዋ። ሀን ዎስቶቤሲስ አሱኒኪን ስንፋናነ ትሹቱ ትሹና። ");
INSERT INTO jnje_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ስኑንታኖ ሀኦስኪን ስንፋናነ ባሶትን ዬቱትክ ኣፋ ችማት ዉዛ። ደይ ሀኦሲኔን ፋሴር ስናትታዋ» ይ። ባሶ ደይ ባሳ ኪቶሶን ኤጴቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ዎስኒ ሜያኖን ሀጝ ባሶክ ቴግሴሬ እቻት የሱስኒ ሱናሶን ቴግሴሬ ማክሶኖይቴማቶ ኬእሬ ጋፉክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ስኑንታኖ ዎስኒ ሜያ የሱስኒ ሱናሲክ ካሽስቶስ ሾልሱ ዛግሬ ፋድሴቴ ቦርአ ሾንጎስ ስና ግሬት ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ዎንና ዎንና ቤቴሜቅደሲሲናዋ ኬያ ኬያስና የሱስ ክርስቶስኒ ቾዋሲክ አሱሶናዋ ምስራቹኒ ካማሶን ማኮሶና ኣነ ዬቱሶቶ። ");
INSERT INTO jnje_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ኤስ ዎናስ አማኝኒ ሜኒ ፋዳስ ዳይቴት ሀሚባሴ። ግሪክኒ ኖኖ ዎል ሌፌ አይሁድኒ ሜያ ዩዳክ አይሁድኒ ሜያስታ ኡኚሴቴ። ኤስ ኡኚሴቴስ ዎንና ዎንና ሃቸፋ አሪጋሱን እማስ ባሶ ድቻ አሱሲክቶክ ቤይቴራ ፋር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ኤስታን አሲሬ ሄፔ ዎስኒ ሜያ አማኝኒ ሜያኖን ዙትሬ ኤካ ይሴቴ፦ «ሙን ሃአክዋ እያት ሀኦሲ ካማኖን ማኮ ቤያንክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ኤሴ አይን ሜያነ፤ ንቶ ጋነያስን ማአ አማላቤስ ፋና ኮርቶ አያናክናዋ ቴችማክና ቱም ናፉን አሱኒን ኮራን ሀን ዎስቶሶን ዎስቶሶነክ እምንዋ። ");
INSERT INTO jnje_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ስኑንታኖ እንኖ ሺጶክናዋ ካማሶን ማኮክና ችማኒ።» ");
INSERT INTO jnje_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ኤስ ካማስ ዙታምቤሲሴ አሲን ግርስ። ኤስታን አማንቶክናዋ ኮርቶ አያናክና ቱንኢቶ እስጥፋኖስኒን፥ ፍልጶስኒን፥ ፕሮኮሮስኒን፥ ንካሮስኒን፥ ትሞናኒን፥ ፐርሜናኒን፥ አይሁድኒ ሜያስ ግሪሬ ፌ አንሶኪያክ ንኮላዎስኒን ኮርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ኤስ ባሶትን ቴሸሬ ዎስኒ ሜኒ ስና ዬትሴቴ። ዎስኒ ሜያ ደይ ሺጵሴቴኔን ኦርፎ ኩሹቤሲሶን ባሶስታ ታእሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ሀኦሲ ካማ ደይ ታግት ሀሚና ቦርአ አማነ አሱሳ ፋዳ የሩሳለሙክ አካማኖን ዳይቴት ሀሚ። ማግኒ ሜያስን ደይ ሾዎቤሲስ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","እስጥፋኖስ ሀኦኒ ኦትማክናዋ ሁግናክና ቱሜ ዳራሳ ጋነሲ ዲንቅነዋ ቢስቴራ አሪቶኖይ ዉዝነ ዛግት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ኤስ ካባሲክ፦ «ብርማዱማ ኬሳ አሱኒ ሜኒ ዙቶኒ ኬያ» ይስቴራ ቴግቴፋ አይሁድኒ ሺጶኒ ኬያስ አሱኒ ሜያ፤ ቀሬናክ አሱኒ ሜናዋ እስኪንድሪያክ አሱኒ ሜና፤ ክልቅያናዋ ኢስያና እሳ እሳ አሱኒ ሜያ ካብሴሬ እስጥፋኖስኔን አነ ካራካርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ስኑንታኖ እስጥፋኖስ ማኬት ፌና ቴችማሶናዋ አያናሶና ዬቱክ ኣነ ችሞቶ። ");
INSERT INTO jnje_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ኤስታን ደይ፦ «እስጥፋኖስ ሙሴኒስታናዋ ሀኦሲታና ሜእን ካማ ማኬፌን ኦደኒዋ» ኡኒ አሱኒ ሜያኖን ኣቾክ ካቡግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ኤካክ ዳራስን፥ ኩርኡኒ ሜያኖን፥ ቱማስ አስሲኛኒ ሜያኖን ባሳስታ ካቡግሴቴ። እስጥፋኖስኒን ኤጴሬ ሾንጎስ ስና ታእስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ባሳስታ ኤሻ ዛላ ማኮኒ አሱኒን ኤጴ ዬሴቴ። ባሶ ደይ፦ «ሀን አሱስ ሀን ቤቴሜቅደሲሲታናዋ ቱማስታና ሜእን ካማ ማኮሶን ኣነ ቤየ። ");
INSERT INTO jnje_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ደይ፦ ‹ሀን ናዝሬትክ የሱስ ሀን ቤቴሜቅደሲሶን ቦግንር፤ ሙሴ እምና ቱማሶን ደይ ሶሎንር› ይሬ ማኬፌን ኦደኒ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ኤስ ካባሲክ ሾንጎስታ ዲሴ ባሶ ዙቴሬ እስጥፋኖስኒን ኮትክሬ ብየቴን ስኒባስ ሀኦኒ ዎስኒ ስናነ ፋር ስንና ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ማግኒ ጋኝኜ ሜኒ ጋኝኛስ እስጥፋኖስኒን፦ «ሀን ነይስታ ማክቴፋ ቾዋሲ ፉቶኖሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","እስጥፋኖስ ዎልግሬ ኤካ ይ፦ «አይታሳክቶናዋ አባታሳክቶና ኦዶትዋ! አባን አብራሀም ካራን ዱክ ሀሚኖይ ዜምሜ ሜሴፐቶምያክ ፌን ኡልፍንቶ ሀኦሲ ባርኪ አምማኖን ቤስቴራ፦ ");
INSERT INTO jnje_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹ዳኔስታንናዋ ኮኔሳስንና ኬሳ ታ ቤሱና ድማስ ሀማ› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ኤስ ካባሲክ ኬለዳዊኒ ሜኒ ዳስታኪ ኬሴ ሀሜ ካራን ድ። ኤስታን አባባ ክትናኔን ኦርፎ ሀሽ ሀን ንቶ ፋፌት ዳስታክ ሀኦ ባሪን ቴሸዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ሀኦሲ ሀንታክ ዎቾባሶንኑ ዬቱና ድማ ባርኪ ኣነ እማ። ስኑንታኖ ሀን ዳሶን ባርኪናዋ ባርኔን ኦርፎክ ዛልባሲክና እማናክ ሀኦ ቴያ ግሪዋ። ኤስ ቴያሶን ግሪናስ አብራሀም ናዉባስን ኮኑኖጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ዛልባስ ደይ አላጋ ዳስታክ ፎናማቶናዋ አቼች ትያ ዎግጋ ቦዛ ዛግሴሬ ሚርአክ ሀእሱሶነማቶና ማኬራ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ኤስታን ደይ፦ ‹ቦዞክ የርኤ ሀእሲ ዳራሳታ ማጝሱ ካርአናር። ኤሴን ኦርፎ ብርማዱማ ኬሴሬ ታን ሺጵሶነ› ይራ ሀኦሲ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ኤስታክ ደይ ሃርኮኒ ኩን ቴያሶን ባርኪ እሚ። ኤስ ባሪ ቦርኣ አብራሀም እሳቅኒን ኮንቴናር ናጝሪንሲናሪ ዎኖ ሃርኮ ኩንስ። ኤሲስማቶ ደይ እሳቅ ናባ ያቆብንን ሃርኮ ኩንስ። ያቆብ ደይ አሲሬ ሄፔ ዛላስ አባ ስና ናንጎትባሶን ሃርኮ ኩንስ። ");
INSERT INTO jnje_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«ያቆብን ናንጎትስ ዮሴፍኒስታ ኮነሴሬ ቦዝ ስናናክ ግጵጽ ዋግሴቴ። ስኑንታኖ ሀኦሲ ባርኔን አነቱ ፋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ባሳስታ ካርአ ሻና ዙታምባሴ አሲስኒ ባሪን ክስ። ግጵጽክ ታቶ ፌሬኦን ስና አዳነዋ ቴቹምነ እሚ። ፌሬኦን ደይ ግጵጽኒስታናዋ ፋ ዉዝባስታና ሀእሱኒር ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ኤስ ካባሲክ ግጵጽኒስታናዋ ኬነአኒስታና ማክነዋ አካማ ሻናነ ስኒ። አባኒሳክቶ ደይ ሙሶነ ሙ ቱሩክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ያቆብ ደይ ግጵጽክ ሜያ ፎባሶን ኦዴሬ ዜምሜ አባኒሳክቶኒን ግጵጽ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ሄፕሳ ዎል ሌ ሀሜፌ ካባሲክ ዮሴፍ አይባሳክቶኒክ አምማኖን ክስሬ ማኬ። ፌሬኦን ደይ ዮሴፍን ኮኒ ስኖቤሲሶን አሪ። ");
INSERT INTO jnje_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ኤሴን ኦርፎ ዮሴፍ ዎስሬ አባባ ያቆብንናዋ ባሳ ኮኒ ሜያኖና ባርኪ ዮሶነክ ዛግ። ባሶ ደይ ፋድቤሲስ ናፉናስሬ ኡቼ። ");
INSERT INTO jnje_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ኤስታን ያቆብ ግጵጽ ሀሚ። ባርናዋ አባኒሳክቶና ኤስታክ ክትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ክቱቤሲስ ደይ ሴኬም ኦቴራ ሀማ አብራሀም ሄሞርን ናንጎታስኪን ባሳ ብሪሲክ ዋጌና ሞጋስ ካባርቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ሀኦሲ አብራሀምኒክ ቴያክ እምና አብዲስ ኮኡናክ ታእሴት ያፋና ካባሲክ ግጵጽክ ፌ ዳራኒሳ ፋዳ አሪክት ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ኤስ ባር ደይ ስንናስ ዮሴፍን አሩኖይ ኦም ታቶ ግጵጽክ ታቴና ዎኖኔጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ኤስ ኦራ ታቶስ ዳራኒስን ማጙክ ካብሬ አባኒሳክቶኒን ሻና ቤስ። ዳጋ ናንጎትቤሲስ ክቱናክናዋ ኤክ ጌሮ ክሴሬ ሀእሶነክና አባኒሳክቶኒን ግድስ። ");
INSERT INTO jnje_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ኤስ ካባሲክ ሙሴ ኮንቴ። ባር ደይ ሀኦሲ ስና ኬሹ ዳግ ና ስኒ። ኬዝ አሳ አባባሳ ኬር ዲሬ ድች። ");
INSERT INTO jnje_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ጌሮ ኬሴ ኩንስሴቴን ታቶ ፌሬኦን ናዋስ ዳና ኤጳ ባር ና ዛግራ ድች። ");
INSERT INTO jnje_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ሙሴ ደይ ግጵጽኒ ሜኒ ቴችማሶን ዙትሬ አሪ። ዎላክናዋ ዎስቶክና ችም አሱ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«አቼቻስር ዎጋባ ስኒፋና ካባሲክ አይባ ስና እስራኤልኒ ናንጎታሶን ማምሱናክ ንብባሲ ሳፋሬ። ");
INSERT INTO jnje_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","እሳ ግጵጽኒ አሱ ባሳ አዪስን ሚርኤፌን ዳንነ ግጵጽኒ አሱስን ዎሩክ ጉማ ካስቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ባሳ ኬን ስና ባሶ ሀኦሲ ባርኪ ካሞ ባሶትን ብርማዱማ ክሱንር ዛግሬ ቢሴድፌርነ ፋር ስንናቱ ባርኪ ቤስቴድፋ። ስኑንታኖ ባሶ ኤስ ባሮን ኣነ አሪሶቶ። ");
INSERT INTO jnje_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ዎኖትርክ ሄፕ እስራኤልኒ አሱ ባርና ባርና ፋሴፌን ዳንነ ጋንሱናክ ሾሌፋት፦ ‹ንቶ አይና አይናዋ፥ አዉኒ ቦርአ ንቶትና ንቶትና ፋሴድፌትሪንሶ?› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ኤስ ዞሞባስኒ ሚርኤት ፌ ባር ሙሴኒን ኤክ ቱግሬ፦ ‹ነ እኖስታ ማጝሱ ካርአታክናዋ ሀእሱታክና ዛግስ ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ሀዞት ግጵጽኒ አሱስን ዎርታስማቶ ታን ደይ ዎሩታክ ሾሌድፋታሮሶ?› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ሙሴ ኤስ ባሮን ኦድናይሴ ምድያምኒ ዳ ጉዝዘ ሀምሜ ድ። ኤስታክ ሄፕ ኣርቃ ናንጎትንን ኮኒ። ");
INSERT INTO jnje_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«ሙሴ ኤስ ዳስታኪ አቼቻስር ዎግጋ ቱምፋና ካባሲክ ሲናክ ኣማስ ቴሻ ፋ ዛቦሲክ ሳባስ ሳሜት ፋ ጌያስ ውኖስ ሀኦኒ ዎስያ ባርኪ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ሙሴ ኤስ ቢና ቾዋሲክ ዲንቀት ኤክ ባርኪ ታእሴ። ኤስታን ኤካ ይፋ ዳሚሳ ካማኖን ደይ ኦደ፦ ");
INSERT INTO jnje_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹ታ ነ አባሳክቶን ሀኦዋ፥ አብራሀምኒ ሀኦ፥ ይሳቅኒ ሀኦ፥ ያቆብን ሀኦዋ› ሙሴ ደይ ድጋክ ብያናክኑ ኣነ ችሜ። ");
INSERT INTO jnje_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ዳሚስ ደይ ኤካ ይ፦ ‹የሬታ ድማስ ኮርቶ ዳ ስንና ቦርአ ዎቾኔስን ቻማኔሶን ክሱዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ግጵጽክ ፌ ዳራታሳ ሻናኖን ፉቶክ ቢጝዋ። ራኮቤሲስ ቻጋኖን ኦደጝዋ። ኤስ ባሪ ቦርኣ ፉኦናክ ኬሬጝዋ። ሀሽኑ ሀን ዮዋ። ኔን ዎልግራ ግጵጽ ዎሱናዋ።› ");
INSERT INTO jnje_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","« ‹እኖስታ ማጝሱ ካርአታክናዋ ሀእሱታክና ኦንሶ ኔን ዛግሪ?› ይት ኦምቴሴቴ። ስኑንታኖ ሀኦሲ ኤስ ሙሴኒን ሳባስ ቤስቴ ሀኦሲ ዎስያሲክ ካሞ ሀእሱኒርናዋ ፉሮንርና ዛግራ ባሶክ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ኤስ አሱስ ደይ ግጵጽክ ዳስታክ ሸአ ባሪስታናዋ ኢችማ ዳስ ሲና ዲንቅነዋ ቢስቴራ አሪቶኖይ ዉዝነ ዛግት አቼቻስር ዎግጋ ባሶትን ዞንስ። ");
INSERT INTO jnje_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‹ዳማ ሀኦኒትስ ታን ካብግናሲማቶ ንቶ ጋነያስን ራጁኒን ንቶክ ካብጉናዋ› ይሬ እስራኤልኒ ሜያክ ማኬስ ኤስ ሙሴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ኢችማ ዳስ ሲ እስራኤልኒ ማባራስኔን አነ፤ ሲናክ ኣማስታ ማኬ ሀኦሲ ዎስያኔን አነ ኤሲስማቶ ደይ አባኒሳክቶኔን አነ ፌይስ ሙሴዋ። ካኒ ካማሶን ደይ ኤጴ እኖክ ኣቲስ ኤስ ሙሴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«ስኑንታኖ አባኒሳክቶ ባሪን ኦምቶቱ ኦምቴሴቴታኖ ኣነ አጃጃሞሶቶ። ንብቤሲስ ደይ ግጵጽ ዎል ሌ ኬሮክ ሳፋርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ኣሮንን ደይ፦ ‹ግጵጽኒ እኖትን ዞንስሬ ክስ ሙሴኒስታ አዉ ካርናማቶ ኣነ አሩዌን ስንና ቦርአ እንኖ ስናስታ ዜምማ ዞንሱኒ ሀኦሲክቶኖን እኖክ ዎስቶዋ› ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ኤስ ካባሲክ አላቃኒ ግቶክ ኮሎ ኦኤ ማኣአ እሜቴ። ኩሹቤሲስ ዎስቶክ ደይ ግርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ስኑንታኖ ሀኦ ባሶስታን ኦር ኬስ። ሳማስታ ፋ ባኩራሲክ ካኣኖሶነክ ኣትራ እሚ። ኤሲስ ደይ ራጁኒ ሜያክ ካሞ፦ « ‹ንቶ እስራኤልኒ ሜያነ! አቼቻስር ዎግጋ ዛቦሲክ ሹክት ዋጋሴዋ ማኣኣሴ ታክኖሶ? ");
INSERT INTO jnje_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ኤጳ ሀሚትስ ሞሎኪን ዱርካኒሴዋ፤ ሬፋም ይስቴ ሀኦኒትስ ባኩራኒ ሱራሴዋ፤ ኤስ ባር ደይ ኩሹንትሲክ ዎስቴራ፤ ባርኪ ካኣነት ፋቲ ሀኦኒትስዋ፤ ታ ደይ ባብሎን ኤካሎክ ካቡግቶትክ፤ ንቶትን ዛጉና ይስቴራ ትቼናስማቶዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«እንኖ አባን ሜያ ኢችማ ዳስ ሲ ዛልን ዱርካኒቤስ ፋርዋ። ኤስ ዱርካኒሶን ሀኦሲ ባርኪ ማኬናስማቶናዋ ቤስናስማቶና ዎስቴስ ሙሴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ሀኦሲ ባሶ ስናስታን ካላ ኤልስና አዛብኒ ሜኒ ዳሶን ኤጴፌ ካባሲክ እያሱኔን አነ ዱርካኒሶን ኤጴ ግርሴቴ። ዳዊትኒ ነያስ ካርአናኔን ኤስታ ድ። ");
INSERT INTO jnje_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ዳዊት ሀኦሲ ስና ኡልፍና ዳንነ ያቆብን ሀኦሲ ሀኡና ኬያ ኬርአናክ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ስኑንታኖ ሀኦሲክ ኤስ ኬያሶን ኬርኣስ ሶሎሞንዋ። ");
INSERT INTO jnje_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ስኑንታኖ ዙታምባሴ አሲስታን ደናሎ ስና ሀኦሲ አሱኒ ኩሹክ ኬቴ ኬስ ኣነ ዲፋ። ኤስ ባር ደይ ራጁኒኪ ካሞ፦ ");
INSERT INTO jnje_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","« ‹ሳማስ ታ ዝግሙዋ፤ ሀን ዳስ ደይ ዎቾናስ የርአና ድማዋ፤ ኤኪን አዉነ ፋ ኬያንሶ ታክ ኬርአትሪ? ቤይሳ ኤጳና ኬያስ ደይ አዉነ ፋሪንሶ?› » ይፌ ዳሚስ። ");
INSERT INTO jnje_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","«ሀን ባሮን ዙትራ ዎስቴስ፤ ታ ኩሹስታኖሶ?» ይፋዋ ሀኦሲ። ");
INSERT INTO jnje_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«ንቶ ኤልጝ አሱኒ ሜያ፥ ንብንት ታቶ፥ ኦዶንትስ ኦዶኖር፥ ንቶ ደይ ንቶ አባን ሜኒማቶ ኮርቶ አያናሶን ዎንና ዎንና ኦምቴትር። ");
INSERT INTO jnje_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ራጁኒ ሜያስን ንቶ አባን ሜያ ካብጉሶኖይቴር ኦንሶ? ባሶ ኦኮሳ ዮኖን ዜምሜ ማክሴ ባሶትን ዎርሴሴቴ። ንቶ ደይ ሀሽ ሀን ኦኮስን ኣትሬ እማክ ዎርሴት። ");
INSERT INTO jnje_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ንቶ ሀኦሲ ዎስያክ ካሞ ማክቴ ቱማሶን ኤጳ ታሴት። ስኑንታኖ ኣነ ኦደት።» ");
INSERT INTO jnje_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ሾንጎስታ ዲሴ ባሶ ኤስ ባሮን ኦደሴቴይሴ አካማኖን ሃሬሴሬ እስጥፋኖስኒስታ ሀኣኢቤሲሶን ካርምሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ስኑንታኖ እስጥፋኖስ ኮርቶ አያናክ ቱሜ ደን ሳማ ኮትክሬ ሀኦሲ ኡልፍናኖን ቢ። የሱስኒን ደይ ሀኦሲ ሆእታ ቴሽታ የሬፌኒ ቢ። ");
INSERT INTO jnje_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ኤስታን፦ «ሳማ ጋቼፋኒ አሱኒ ና ሀኦሲ ኦእታ የሬፌኒ ቢድፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ኤስ ካባሲክ አካማ ካማክ ቻጌቴ። ኦዶቤሲሶን ኡኬሬ ኤክ ባርኪ ኤለቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ባሪን ኤጴ ካታማስን ክሴሬ ሹአክ እቸሴቴ። ዛልኒ ሜያ ደይ ማይቤሲሶን ኦዳናክ ኤጴ ታሜ ሳዉል ይስቴፌ እሳ ናኦ አሱኒ ዎቾስ ኩኑሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","እስጥፋኖስኒን እቸሴፌን፦ «ዳም የሱስኖ! ካናሶን ኔክ ኤጵዋ» ይት ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ካአነሬ ደይ አካማ ካማክ፦ «ዳሚሶ ሀን ቦርቤሲሶ ባሶስታ ፋዱታታዋ» ይት ቻጊ። ኤስ ባሮን ይናኔን ኦርፎ ክት። ");
INSERT INTO jnje_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ሳዉል እስጥፋኖስ ዎርቶባሲክ ግሬ። ኤስ ካባሲክ የሩሳለሙክ ፋ ቤቴክርስታኒስታ ካቡግቶ ካቢ። ዎስኒ ሜያ ባሶ ባሶቴኖ ኦም አማኝኒ ሜያ ዙቴሬ ዩዳናዋ ሳማሪያኪ ዳ ዙታምባሴ አሲስ ሲክቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ሺጶክ ችሜ ፌ አሱኒ ሜያ እስጥፋኖስኒን ዱግኖሶን ካባርሴቴ። ባርኪ ደይ አካማኖን ዋሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ስኑንታኖ ሳዉል ቤቴክርስታኒሶን ትሽኩክ ካቤት ፌር። ኬያ ኬያስ ግሪፋፌ ኣርቃ ክርስታናስናዋ ማሽካ ክርስታናሶና ዛቴ ክሲታፌ ታቶኒ ኬር ጌደት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ሲክቴ አማኝኒ ሜያ ሀሜቴ ሀሜቴ ዳስ ካምባሶን ማክሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ፍልጶስ ደይ ሳማርያን ካታማስ ሀሜ ክርስቶስኒ ቾዋሶን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ሾዎ ዳራ ደይ ፍልጶስ ማኬና ባሮን ኦደትናዋ ዛግፌና ቢስቴራ አሪቶኖይ ዉዛሶና ብየፋት ጋሳሲሬ ባሪን ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ኪና አያናሲክቶ ደይ አካማ ካማክ ቻጌት ሾዎ አሱኒስኒ ኬሴት ፋር። ሾዎ ላፋናዋ ኤግትና ፋርሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ኤስ ባሪ ቦርኣ ኤስ ካታማስ አካማ ግራ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ኤስ ካታማስ ስሞን ይስቴ እሳ አሱ ቶልፋታ ቶልፋቴፋፌ ሳማሪያኪ ዳራስን ዲንቂስት ፌር፦ ደይ፦ «ታ አሪክቶ አሱዋ» እያፌ ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ጋሮሳታን ካብግሬ ጋይማሳታ ካርኤ ፌ አሱ ዙቴሬ፦ «ሀን አሱ አሪክቶ ይስቴራ ቴግቴፋ ሀኦኒ ሁግናዋ» ይሴት ጋሳሲሬ ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ኤስ ጋሳሲሬ ኦደሴፌስ ሾዎ ዎና ቶልፋታክ ባሶትን ዲንቂስት ፌር ስንና ቦርአ። ");
INSERT INTO jnje_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ስኑንታኖ ፍልጶስ ሀኦሲ ታቶሶናዋ የሱስ ክርስቶስኒ ሱናሶና ማኬና ምስራቹኒ ካማሶንና ኦደሴሬ ኣርቃስ ማሽካስ አማነሬ ሀጱክቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ቶልፋቱ ስሞኑ አማነሬ ሀጱክቴሬ ፍልጶስኔን አነ እሳር ስኒ። ዛግቴት ፋ ዲንቂሴዋ አካማ ቢስቴራ አሪቶኖይ ዉዛሶን ቢሬ ዲንቀት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","የሩሳለሙክ ፌ ዎስኒ ሜያ ሳማሪያኪ ዳራስ ሀኦሲ ካማኖን ኤጴቶሶቤሲሶን ኦደፋት ጴጥሮስኒንናዋ ዮሀኒስንና አሲን ሳማርያ ዎሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ጴጥሮስናዋ ዮሀኒስና ደይ ሀሜሬ ሳማሪያኪ አሱኒ ሜያ ኮርቶ አያና ኤጴቶሶነክ ሀኦ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ኤሲስ ደይ ዳምኒ የሱስኒ ሱናሲክቱ ሀጱክቴሴቴታኖ ኮርቶ አያና ባሶስታ ኣነ ኬሮዋ። ");
INSERT INTO jnje_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ኤስታን ጴጥሮስናዋ ዮሀኒስና ኩሹቤሲሶን ባሶስታ ታኡቤሲሴ ኮርቶ አያና ኤጴቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ዎስኒ ሜያ ኩሹቤሲሶን አሱኒ ሜያስታ ታእሴቴን ኮርቶ አያና እምቶባሶን ብያት ስሞን ዋጋ ኤጴቴሸሬ፦ ");
INSERT INTO jnje_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«ታ ደይ ኩሹናሶን ታኡና አሱኒ ሜያ ኮርቶ አያና ኤጴቶሶነክ ሀን ሀእሱኒ ሁግናሶን ታክ እምትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ስኑንታኖ ጴጥሮስ፦ «ሀኦሲ እማኖን ዋግኔሲክ ዋጎታክ ሳፋሬታ ቦርአ ዋግኔስ ነኔን አነ ትሹጝዋ! ");
INSERT INTO jnje_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ንብኔሲ ሀኦሲ ስና ማጙ ስንና ቦርአ ሀን ዎስቶስ ግርራ ዎስቶታ ድምነዋ እጣነ ኔክ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ኤሴ ሀን ማጙኔስን ሀርምራ ዳሚሲክ ዎሉዋ። አዉዛክነ ሀን ንብኔሲ ማጙ ሳፋራኖን ፌሹን ኡንትቶ ሺጶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ነ ሱቃሮ ኮናክ ቱማ ፋታማቶናዋ ቦርኣሲክ ታቴራ ፋታማቶቱ ቢድፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ስሞን ደይ፦ «ሀን ማክሴት ባርስኒ እሳርንኑ ታይስታ ካርኖይናማቶ ንቶ ዎላ ዳሚስን ታክ ሺጶትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ጴጥሮስናዋ ዮሀኒስና ዛላ ማክሴሬናዋ ዳሚሳ ካማኖን ማክሴቴኔን ኦርፎ ሾዎ ሳማርያን ኬኤስ ሀሜፋፌ ምስራቹኒ ካማሶን ማክሴት የሩሳሌም ዎል ሌ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ዳሚሳ ዎስያ ፍልጶስኒን፦ «ካብራ የሩሳለሙን ጋዛ ካትፋ ዛቦሲክ ኡግና ካዉዳ ዎላ ሀማ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ባር ደይ ካብሬ ሀሚ። ህንዳኬ ይስቴፋ እቶጲያኒ ታቶስ ፎኖናዋ ዋግባሶና ሀእሲፌ እሳ ጃንዳራባ እቶጲያኒ አሱ ሀኦኪ ካኖክ የሩሳሌም ዬሬ ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ኤስ ጃንዳራባስ ዎል ሌ ዳባ ሀሚፌና ካባሲክ ሴሬጌላታ ዲፋት ራጁ እሳያስኒ ትቻሶን ፌሬትት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ኤስታን ኮርቶ አያናስ ፍልጶስኒን፦ «ኤክ ሴራጋላሲክ ታእሴራ ኡጶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ኤስታን ፍልጶስ ደይ ታፕቴሬ ኤክ ሴሬጌላሲክ ሀሚፌን እቶጲያኒ አሱስ ራጁ እሳያስኒ ትቻሶን ፌሬትፌን ኦዳት፦ «ሀን ፌሬትፋ ታ ባር ኔክ ጋለድፋሮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","እቶጲያኒ ጃንዳራባስ ደይ ዎልግሬ፦ «ታክ ኮቴ ማኮኒ አሱ ፎንቶኖን ኣካክ ታክ ጋሎንሪንሶ?» እያት ፍልጶስኒን፦ «ሀን ሴሬጌላስታ ኬሳ ታኔን አነ ዱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ጃንዳራባስ ደይ ፌሬትት ፌና ትቻስ ኤካቱ ይፋ፦ «ባር ሹክቶክ ዛቴራ ሀማ ፋንቱነ ፌር፤ ኤሳባሶን ካርፌ ባሶ ስና ሻክፌ ፋንቱሳማቶ ካምባሶን ኣነ ኮቴ። ");
INSERT INTO jnje_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ሳልጳቴ፤ ደይ ፉቶኒ ማጝሱኒ ካርአ ባርኪ ኣነ ካቶዋ፤ ካባስ ሀን ዳስታኪ ካልቴራ ትሽና ቦርአ፤ ሀን ኮኒቶስ ቾዋኖን ኦ ማኮክ ችምንሪንሶ?» ");
INSERT INTO jnje_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ጃንዳራባስ ደይ ዎልግሬ ፍልጶስኒን፦ «ራጁኡስ ሀን ባሮን ኦኒ ቾዋንሶ ማኬናሪ? ባሳ ቴትንርንዋ ወደይ ኦም አሱኒሪንሶ? ታክ ማካይዋ» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ፍልጶስ ደይ ኤስ ትቻስታን ካብሬ የሱስኒ ቾዋሶን ማኬት ፋ ሀኦሲ ካማኖን ኮቴ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ሀሜሬ እሳ አካኒ ቴሻ ካርኤቴን ጃንዳራባስ፦ «ኤሴ ሀንታ አካ ፋርዋ፥ ሀጱክቶናክ ካልኒ ዉዛ ኣምባንሶ?» ይ።  ");
INSERT INTO jnje_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ፍልጶስ ዎልግሬ፦ «ቱኡማ ንብኔሲክ አማነፋታነ ሀጱክቶክ ችማታዋ» ይ። ጃንዳራባስ ደይ፦ «የሱስ ክርስቶስ ሀኦኒ ና ስንናማቶ አማነፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ጃንዳራባስ ሴራጋላስ የሮናክ አጃጀ። ሄፖቤሲሴ ዬት አካስ ኬርሴቴን ፍልጶስ ጃንዳራባስኒ ሀጵቅ። ");
INSERT INTO jnje_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","አካስን ኬሴፌ ካባሲክ ዳሚሳ አያና ፍልጶስኒን ኤጳ ሀሚ። ጃንዳራባስ ደይ ፍልጶስኒን ኤሴን ኦርፎ ኣነ ብየ። ግሬት ኡጉንባሶን ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ስኑንታኖ ፍልጶስ አዛጦኑክ ቢስቴ። ቅሳርያ ሀሜ ካርአናኔን ኣትፌና ካታማ ካታማስ ምስራቹኒ ካማኖን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ኤስ ካባሲክ ሳዉል ዳሚሳ ናዎኒ ሜያኖን ዎሩናክ ዴሲት ማግኒ ጋኝኜ ሜኒ ጋኝኛስክ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ዳሚሳ ኡግናክ ዞኑስቴፌ ሜያኖን ኣርቃስናዋ ማሽካሶና ዳንፌና ካባሲክ ታርታፌ የሩሳሌም ቴሾክ ችማናማቶ ደማስኮክ ፋ አይሁድኒ ሺጶኒ ኬያሲክቶክ ትቻ እምቶናክ ማግኒ ሜያኖን ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ደማስኮ ሀሜ ካርፌና ካባሲክ ብራቶባስታ ደን ሳማን ዲንቆነ ቻሬፋ ፓልፓሊ። ");
INSERT INTO jnje_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ኤስ ካባሲክ ባር ዳ ኬሬ ጋንደ። ኤስታን፦ «ሳዉልኖ፥ ሳዉልኖ፥ አዉኒ ቦርአ ታን ካብግድፋ?» ይፋ ካማ ኦደ። ");
INSERT INTO jnje_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ሳዉል ደይ፦ «ዳሚሶ! ነ ኦንሶ?» ይ። ባር ደይ ዎልግሬ፦ «ታ ሀን ነ ካብግፋታ የሱስዋ። ");
INSERT INTO jnje_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ስኑንታኖ ሀሽ ካብራ ኤክ ካታማስ ሀማ። ዛጉታክ ሾልሱሶን ኤስታክ ኔክ ማክሶነዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ሳዉልኔን አነ ሀማ አሱኒ ሜያ ካማሶን ኦደሴቴ። ስኑንታኖ ኦኒንኑ ኣነ ብዮቶ ስንና ቦርአ ማክሶነ ዉዛ ትሽፋን ሻክሴሬ የርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ሳዉል ደይ ጋንደና ድማስታን ካቢ። ስኑንታኖ ኣፋሶን ዎይን ብያናክ ኣነ ችማ። ኤስ ባሪ ቦርኣ አሱኒ ሜያ ኩሹባሶን ዛቴ ዞንሲት ደማስኮ ካታማ ኤጴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ኬዝ ዎና ካርአናኔን ኣፍትሹ ስንነ ሙ ሙኖይናዋ ኡሽኖይና ድ። ");
INSERT INTO jnje_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ኤስ ካባሲክ ደማስኮክ ሀናንያ ይስቴ እሳ ዳሚሳ ናዎ ፌር። ዳሚስ ራእክ፦ «ሀናንያኖ!» ይሬ ቴጌ። ባር ደይ፦ «አቤትዋ፤ ዳሚሶ ሀንታቱ ፋዉጝዋ» ይት ኮይ። ");
INSERT INTO jnje_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ዳሚስ ደይ ባርኪ ኤካ ይ፦ «ካብራ ዜጵቶ ይስቴፋ ኡግናሲክ ሀማ። ኤስታክ ይሁዳ ይስቴፌ አሱሳ ኬር ሳዉል ይስቴ እሳ ቴርሴሲክ አሱስን ሾሎዋ። ሀሽ ባር ሺጶታቱ ፌዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ሳዉል ደይ ሀናንያ ይስቴ አሱ ዬሬ ኩሹባሶን ኣፋስታ ታፌና ካባሲክ ብያናማቶ ራእክ ቢ። ");
INSERT INTO jnje_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ስኑንታኖ ሀናንያ ዎልግሬ ኤካ ይ፦ «ዳምታሶ! ሀን አሱስ የሩሳለሙክ ፌሴ አማኝሳታ አካማ ሻና ካትናማቶ ታ ሾዎ አሱኒኪን ኦደጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ሀሽኑ ሀን ደማስኮክ ፌሴ ነ ሱናሶን ቴጌሴፌ ባሶትን ዙታምቤሲሴ አሲን ታርአናክ ማግኒ ጋኝኛክቶኒኪን ፍቃድ ኤጲዋ» ");
INSERT INTO jnje_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ዳሚስ ደይ ሀናንያኒክ ኤካ ይ፦ «ባር አዛብኒ ሜኒ ስና፤ ታቴ ሜኒ ስናናዋ እስራኤልኒ ዳራሳ ስናና ታ ሱናሶን ዎርን ታ ኮርና ኮርቶ ኮዳና ስንና ቦርአ ባርኪ ሀማ። ");
INSERT INTO jnje_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ታ ሱናሲክ አዉነ ፋ ሻና ኤጴቶናክ ፌናማቶ ታ ባርኪ አምማኖን ቤሱናዋ» ");
INSERT INTO jnje_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ኤስታን ሀናንያ ሀሜ ኤስ ባር ፌና ኬያስ ግር። ኩሹባሶን ሳዉልኒስታ ታእሬ፦ «አይታ ሳዉልኖ! ሀን ያፌን ኡግናስታ አምማኖን ኔክ ኡጰ ዳም የሱስ ኣፍኔስ ብያናክናዋ ኮርቶ አያናክ ቱንቶታክና ታን ኔክ ዎስዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ጌሬጌሬ ሳዉልን ኣፋስታን እኦኒ ጎጛነ ፋ ዉዛ ዝግን ብያክ ችም፤ ደይ ካብሬ ሀጱክቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ሙ ደይ ሜሬ ችም። ደማስኮክ ፌሴ ናዎኒ ሜያኔን አነ ጋሮ ዎና ድ። ");
INSERT INTO jnje_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ጌሬጌሬ ሳዉል ደማስኮክ፦ «የሱስ ሀኦኒ ናዋ» ይት አይሁድኒ ሺጶኒ ኬያሲክቶስ አሱ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ኦደ ባሶ ደይ ዙቴሬ ዲንቆክ፦ «ሀን አሱስ የሩሳለሙክ ሀን ሱናሶን ቴጌፌ ባሶትን ዙታምቤሲሴ አሲን ትሽክት ፌ ባርቴኖሶ? ደይ ሀን ዬናስ ባሶትን ታርኤ ማግኒ ጋኝኛክቶኒክ ታሜ እማክታኖሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ስኑንታኖ ሳዉል ዜሞቲስታን ዳይስሬ ችሜት ሀሚ። ደማስኮ ፌ አይሁድኒ ሜያ የሱስ ባር ክርስቶስ ስንናማቶ ኮቴ አሱባሲክ ማክሶነ ዉዛ ቱርክስት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ሾዎ ዎናኔን ኦርፎ አይሁድኒ ሜያ ሳዉልን ዎሩክ ሜርኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ስኑንታኖ ባር ባሶ ማጙ ሜካማሶን አሪ። ባሶ ደይ ባሪን ዎሩክ ቶነ ዋልነ ባር ኬስፌና ካታማስ ፍኛአሲ ክቶኖን ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ስኑንታኖ ባሳ ናዎሳክቶ ዋሲ ካታማስ ሹን ኦጃስ ካቶስ ካሞ ሳዉልንን ማሳስ ዱስሬ ኬስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ሳዉል የሩሳሌም ሀሜ ካርኤ ኤስታክ ፌሴ ዳሚሳ ናዎኔን አነ ዎእቶናክ ሾሌ። ስኑንታኖ ሳዉል ክርስቶስኒን አማኖባስ ፉቶ ስንና ባሶክ ኣነ ቤስቶዋ ስንና ቦርአ ዙቴሬ ድጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ስኑንታኖ ባርናባስ ሳዉልንን ዎስኒ ሜያክ ኤጴ ታሜ ኡጉንታክ ፌን ዳሚስ ኣካክ ባርኪ አምማኖን ኡጰናማቶ፤ ባርኔን ደይ ዎል ሌናማቶናዋ ደማስኮክ ዳሚሳ ሱናኖን ኣካክ ድጋባ ፎንቶኖን አሲናማቶና ባሶክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ኤስ ባሪ ቦርኣ ሳዉል ባሶኔን አነ ፌፋት የሩሳሌምኒስ ብራቴፋፌ ዳሚሳ ሱናክ ደይ ድጋባ ፎንቶኖን ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ግሪክኒ ኖኖ ዎል ሌሴፌ አይሁድኒ ሜያኔን ዎል ሌፋፌ ካራካሬት ፌር። ስኑንታኖ ባሶ ባሪን ዎሩክ ሆሬሴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","አይን ሜያ ኤስ ባሮን አሪሴቴይሴ ቅሳርያ ኤጴ ሀሜቴ። ኤስታን ቴርሴስ ሀማናክ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ኤስ ካባሲክ ዩዳክ፥ ጋሊላክናዋ ሳማሪያኪና ፋ ቤቴክርስታኒስ ናጋ ዳኒ። ዳሚስን ኡልፍንስትናዋ ኮርቶ አያናሲክ ችሜትና ፋድባስ ደይ ዳይቴት ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ጴጥሮስ ዳዳስ ብራቴት ፌና ካባሲክ ልዳ ይስቴ ዳስታክ ፌሴ አማኝኒ ሜያክ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ኤስታክ ደይ ኤንያ ይስቴ አሱ ናጙሪን ዎግጋ ላፋ ስንነ ሜቴሬ ኩጶታ ኩንፌን ዳኒ። ");
INSERT INTO jnje_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ጴጥሮስ ደይ፦ «ኤንያኖ! የሱስ ክርስቶስ ኔን ፋቱናዋ፤ ካብራ ኩጶኔሶን ይርዋ» ይን ባር ደይ ጌሬጌሬ ካቢ። ");
INSERT INTO jnje_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ልዳኒስናዋ ሴሮናኔስና ፌሴ አሱኒ ሜያ ዙቴሬ ባሪን ብየፋት ዳሚሲክ ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","እዮጰን ዳስታኪ ደይ ጣብታ ይስቴ እሳ አማኝ ፋር። ሱንባስ ኮታ ደይ ግሪክኒ ኖኖክ «ዶርቃ» ኡ። «ዶርቃ» ኡስ ደይ «ግሙዋ» ኡ። ባር ደይ ዎንና ዎንና ማአ ዎስቶ ዛጉክ ቱካምኒ ሜያኖን አሪጋስት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ኤስ ካባሲክ ባር ሜቴራ ክት። አሱኒ ሜያ ደይ ዱግኖሶን ማሴ ሴጌነትስታ ኩኑሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ልዳ እዮጰክ ታአ ስንና ቦርአ እዮጰክ ፌሴ ናዎኒ ሜያ ጴጥሮስ ልዳክ ፎባሶን ኦደሴቴይሴ ሄፕ አሱኒ ዎሴሬ፦ «አዳራዋ ታፕቴራ እኖክ ያፋይዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ኤስ ባሪ ቦርኣ ጴጥሮስ ካብሬ ዎስኔን አነ ሀሜ ኤስታ ካርፌና ካባሲክ ሴጌነትስ ባሪን ኤጴ ሀሜቴ። ድቻ አሱሲክቶ ዙቴራ ዶርቃ ካክ ፋና ካባሲክ ዎስቴና ዎኒዳቦሴዋ ማማሴ አሲን ቤሳፋ ዋሴት ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ስኑንታኖ ጴጥሮስ ዙታምቤሲሴ አሲን ኬሩን ክሳት ካአነሬ ሺጴ። ኤክ ዱግኖሲክ የርቀሬ፦ «ጣብታነ ካቡዌ» ይ። ባር ደይ ኣፋሶን ዎራ ጴጥሮስኒን ቢናይሴ ካና ድ። ");
INSERT INTO jnje_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ባር ኩሹባሶን ሾሬ ዛቴ ካብግ። ድቻ ማሽካሱሲክቶክናዋ ኦም አማኝኒ ሜያኖና ቴጌሬ ናዋሶን ካባሬሬሮን ባሶ ስና ታእስ። ");
INSERT INTO jnje_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ኤስ ቾዋሲ እዮጰክ ዳስታክ ዙታምባሴ አሲስ ዝእራ አርቴ። ሾዎ አሱኒ ሜያ ደይ ዳሚሲክ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ጴጥሮስ ስሞን ይስቴ እሳ ዎማ ካአ አሱኔን አነ እዮጰክ ሾዎ ዎና ድ። ");
INSERT INTO jnje_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ቅሳርያ ይስቴ ዳ ዲፌ ሱንባ ቆርነለዎስ ይስቴ እሳ አሱ ፌር። ባር ደይ ሮማኒ ሜኒ ታቶስ ስካሎስ ፋ እጣልያን ቶራይ ይስቴፋ ባርስ ት ሜኒ ጋኛ። ");
INSERT INTO jnje_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ባር ደይ ባሳ ኬር ፌሴ አሱኒ ሜያኔን ሀኦሶን ሺጶክናዋ ድጋክና ኤሲስማቶ ደይ ቱካምኒ ሜያክ አካማ እማ እሜት ፌር። ዎንና ዎንና ደይ ሀኦሲክ ሺጴት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","እሳዋ እዝግን ሳአት ካርፋና ካባሲክ ሀኦኒ ዎስያ ባርኪ ያራ፦ «ቆርነለዎስኖ!» ይራ ቴጌፌን አምማኖን ራእክ ቢ። ");
INSERT INTO jnje_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ቆርነለዎስ ሀኦሲ ዎሲያኖን ኮትክ ብያት ናየሬ፦ «ዳሚሶ! ኣምባንሶ?» ይ። ሀኦሲ ዎስያ ደይ ኤካ ይ፦ «ሺጶነሴዋ ቱካምኒ ሜያክ እምፋታ እምኔሴ ሀኦሲ ስና ኔን ሳፋሮንር ስንና ደን ሀሚዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ሀሽኑ አሱኒ ሜያኖን ኤክ እዮጰ ዎስራ ጴጥሮስ ይስቴ ስሞንን ቴግሱዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ባር ሀሽ ባኣሪሲ ቴሻ ፌ ጎጎ ካፌ ስሞን ኬር እርባ ስንነ ዲፌዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ቆርነለዎስኒክ ሀን ዎሲያሶን ማኬ ሀኦሲ ዎስያ ኬሳ ሀሚናኔን ኦርፎ ዎስትኛባሳክቶኒስኒ ሄፕናዋ ቆርነለዎስ ሀእሲፌና ባሶስኒ ሀኦሶን ድጌፌ እሳ ሜያታርኦንና ቴጌሬ ");
INSERT INTO jnje_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ዙታምባሴ አሲን ባሶክ ማኬናኔን ኦርፎ ባሶትን እዮጰ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ዎኖትር ዎኖ ዎስቴሬ ሀማ አሱኒ ሜያ ካታማሲክ ታእሴሴፌ ካባሲክ እሱን ሳአትክ ጴጥሮስ ሀኦ ሺጶናክ ሴጌነትስታ ኬስ። ");
INSERT INTO jnje_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ኤስ ካባሲክ ጴጥሮስ ማክቴሬ ሙ ሙናክ ሾሌ። ሙ ባርኪ ሆሬፌን ባር ሻክሬ ዲፋት ራእ ቢ። ");
INSERT INTO jnje_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ቢና ራእስ ደይ ሳማስ ጋቼፋኒ እሳ እኛ ይኑነ ፋ ዉዛ ሳማስ አቼች ፋሽባስታ ኦቴራ ዳስታክ ኬሬፌን ቢ። ");
INSERT INTO jnje_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ኤስ ይኑስታ ደይ አቼች ዎቾባሬ የሬ ካባሬ የሬ ዉዛ ዎቾባ ፎንቶ ዳስታክ ንባሲክ ዛይፋ ቴስቶሴዋ ደን ሳማስታክ ፉልፋ ካሳሲክቶነ ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ኤስ ካባሲክ፦ «ጴጥሮስ ካብራ ሀን ባርኪቶኖን ሹካ ሙዋ» ይፋ ካማ ኦደ። ");
INSERT INTO jnje_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ስኑንታኖ ጴጥሮስ፦ «ዳሚሶ! ኣፋዋ ስናናዉዛ። ታ ካይማ ስኖይ ዉዛ ወደይ ኪና ዉዛ ማራ ኣነ ብዩትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ደይ፦ «ሀኦሲ ካይምስና ባሮን ነ ኪናዋ ኡታክ ኣነ ሾልስፋዋ» ይፋ ካማስ ሄፕሳ ባርኪ ያ። ");
INSERT INTO jnje_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ኤስ ባር ደይ ኬዛ ዎላ ማክቴናኔን ኦርፎ ኤስ ኤርቤስንነ ፋ ዉዛስ ጌሬጌሬ ዎላ ደን ሳማ ኦቴራ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ጴጥሮስ ቢና ራእስ ኮታ «አዉታሶ?» ይት ንብባሲ ሳፋሬፌን፤ ቆርነለዎስ ዎስና አሱኒ ሜያ ስሞን ኬያሶን ሾሌሬ ዳንነ ዬሴሬ ኬያስ ፍኝታ የርሴፌር። ");
INSERT INTO jnje_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ቴጌሬ ደይ «ጴጥሮስ» ይስቴ ስሞን እርባ ስንነ ፌናስ ሀንታኖሶ?። ");
INSERT INTO jnje_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ጴጥሮስ ራእስ ቾዋኖን ሳፋሬት ፌን ኮርቶ አያናስ ባርኪ ኤካ ይ፦ «ኤሴ ኬዝ አሱ ኔን ሾልሴድፌዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ባሶትን ታቱ ዎስር ስንና ቦርአ ኤክ ሀጝ ኡኖይ ካብራ ባሶኔን ኣነ ሀማ።» ");
INSERT INTO jnje_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ጴጥሮስ ኬሬሬ፦ «ሾልሴፌት አሱስ ታዋ። ያት ቾዋሲ ኣምባንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ባሶ ደይ፦ «ት ሜያ ታርኦን ሜያኖን ሀእሲፌ ቆርነለዎስ ይስቴፌ ባርኪንቱ ዎስቴራ ያንዋ። ባር ደይ አይሁድኒ ዳራስ ዙቴሬ ባሪን ኡልፍንስና ሀኦሶን ድጌ ማአ አሱዋ። ኔን ባርኪ ኬር ቴጌሬ ነ ማኬታ ባሮን ኦዶናክ ኮርቶ ሀኦኒ ዎስያስ ባርኪ ማኬዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ጴጥሮስ ደይ ኤስ ዎስቴሬ የ አሱኒ ሜያኖን ኬር ጌደ እርባስሬ ሀእሶነ ድማ ደይ ሺጴሬ ሀእስ። ሄፕስናር ዎኖ ካብሬ ባሶኔን አነ ሀሚ። እዮጰክ ፌሴ እሳ እሳ አይን ሜያ ባርኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ዎኖትር ዎኖ ኬሳርያ ካርኤቴ። ቆርነለዎስ ደይ ባሳ ኮኒስናዋ ታእሶ ዞሞባስና አሲን ዙትሬ ቴጌሬ ባሶኔን አነ ኦደት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ጴጥሮስ ኬር ግሪፌና ካባሲክ ቆርነለዎስ ባርኪ ታእሴሬ ዎቾባስ ካነ። ");
INSERT INTO jnje_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ስኑንታኖ ጴጥሮስ፦ «ካቡዋ ታ ደይ ነዪስማቶ አሱዋ» ይት ካብግ። ");
INSERT INTO jnje_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ጴጥሮስ ባሪን ዎሉምስት አነ ኬር ግሪፌና ካባሲክ ሾዎ አሱኒ ሜያ ዙቴሬ ፌሴቴን ቢ። ");
INSERT INTO jnje_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ባሶክ ደይ ኤካ ይ፦ «እሳ አይሁድኒ ሜኒ አሱ ኦም አዛብኒ ሜኒ አሱኔን አነ እሳር ስንነ ፎናክ ወደይ ኬባስ ግሩኖይናማቶ እንኖ ቱማሲክ ኣነ ሾልስፋ ስንናማቶ ንቶ ቴትንትሲክኑ አሪሴትርዋ። ስኑንታኖ ታ ኦኒንኑ ኪን ወደይ ካይም ኡኖይናማቶ ሀኦሲ ታክ አምማኖን ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ኤስ ባሪ ቦርኣ ታክ ዎስፌት ካባሲክ ኤክ ሀጝ ኡኖይቱ ካብራ ያንዋ። ኤሴ አዉኒ ቦርአ ታን ቴጌትማቶ አሩናክ ሾሌፋዉጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ቆርነለዎስ ደይ ኤካ ይ፦ «አቼች ዎናኔን ስናክ ሀን እዝግን ሳአትስታክ ኬናስ ሺጴፋና ዲንቆነ እሳ ቻሬት የሬ ማማ ማዮ አሱ ዬሬ ስና የሬ። ");
INSERT INTO jnje_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ኤካ ደይ ይ፦ ‹ቆርነለዎስኖ! ሀኦሲ ሺጶኔሶን ኦደዋ። ቱካምኒ ሜያክ እምፋታ እምኔስ ሳፋርቴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ኤሴ ኤክ እዮጰ ዎስኒ ሜያኖን ዎስራ ጴጥሮስ ይስቴፌ ስሞንን ቴጎዋ። ባር ባርስ ቴሻ ፌ ጎጎ ካፌ ስሞን ኬር እርባ ስንነ ዲፌዋ› ");
INSERT INTO jnje_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ኤስታን ታ ደይ ጌሬጌሬ ኔክ ዎስኒ ሜያኖን ዎስጝዋ። ነ ደይ ዮነሲክ ማአሮንቱ ዛግትዋ። ኤሴ እንኖ ዙታምኒሴ አሲክ ሀኦሲ ማኮታክ አጃጀና ባሮን ዙትራ ኦዶንክና ሀኦሲ ስና ዙቴራ ፋንዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ጴጥሮስ ደይ ኤካ ይት ማኮ ኤጲ፦ «ፉቶሲክ ሀኦሲ ኦኒንኑ ኣነ ኮሪፋ ስንናማቶ አሪጙዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ስኑንታኖ ኣፋ ዳኒ አሱኑ ስኒፌናክ ሀኦሶን ድጌፌ ባርናዋ ፉቶ ስና ቾዋሶን ዛግፌ አሱስና ሀኦሲ ሹናርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ሀኦሲ እስራኤልኒ ዳራሲክ ካምባሶን ዎሱባስ አሪቶዋ። አሱ ዙታምባሴ አሲ ዳም ስና የሱስኒኪ ካሞ ናጋሶን ማኬት ያስ ሀኦስዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ዮሀኒስኒ ሀጵቁን ቾዋሶን ማኬና ዎናስታን ካብራ ጋሊላን ሀማ ዩዳኒ ዳስታክ ካርአ ስና ዉዛሶን አሪሴድፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ደይ ሀኦሲ ናዝሬትክ የሱስኒን ኮርቶ አያናክ ሙድናማቶናዋ ሁግና ባርኪ እምናማቶና አሪሴድፌትዋ። ሀኦሲ ደይ ባርኔን አነ ፋና ቦርአ ማአ ዉዛሶን ዛግትናዋ ዳቡሎስ ኤጵና ባሶትን ዙትሬ ፋቲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ዩዳኒ ዳስታክናዋ የሩሳሌምኒ ካታማስና ባር ዛግና ቾዋሲክ እንኖ ዙታምኒሴ ዛልዋ። ስኑንታኖ አሱኒ ሜያ ባሪን እኦታ ሱቴሬ ዎርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ስኑንታኖ ሀኦሲ ኬዝስናር ዎኖ ክቱኒ ካብራ አምማኖን ቤስቶናክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","አምማኖን ቤስቴናስ ደይ ዜምሜ ሀኦ ኮርና ባሶክታኖ ዳራ ዙታምባሴ አሲክታዋ። ባር ክቱኒ ካብናኔን ኦርፎ ባርኔን አነ ሜሬ ኡሻ እንኖ ዛልዋ። ");
INSERT INTO jnje_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ሀን ባሮን ዙትራ ዳራሲክ ማኮኒክ ባር ሀየዉን ሜያስታናዋ ክቱኒ ሜያስታና ማጝሱ ካርአናክ ሀኦሲ ባሪን ታስናስ ባር ስኒባሶን ዛላ ማኮኒክ ባር እኖትን አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ባርኪ አማነፌ ባር ዙታምባሴ ሱንባሲክ ቦርአኒ ፌሹን ኡሶን ኤጴቶሶነማቶ ራጁኒ ሜያ ዙቴሬ ዛላ ማክሴቴዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ጴጥሮስ ኤስ ባሮን ማኬፌን ካምባሶን ኦደ ባሶ ዙታምቤሲሴ አሲስታ ኮርቶ አያናስ ኬሬ። ");
INSERT INTO jnje_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ጴጥሮስኔን አነ ዬሴ ሃርኮ ኩን አይሁድኒ አማኝኒ ሜያ አዛብኒ ሜያኑ ኮርቶ አያናሶን ኤጴቶሶቤሲሲክ ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","አዛብኒ ሜያክ ኮርቶ አያናስ እምቴናማቶ አሪሴቴስ ባሶ ኦማ ኖኖክ ዎሉምሴፌናዋ ሀኦሶን ጋላቴሴፌና ኦደሴቴ ቦርአዋ። ኤስ ካባሲክ ጴጥሮስ፦ ");
INSERT INTO jnje_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«ሀን አሱኒ ሜያ እንኖሲማቶ ኮርቶ አያናሶን ኤጴቴሴቴዋ። ኤካኒ ባሶ አካክ ሀጱክቶሶኖይቴማቶ ካልኒር ኦንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ኤስታን የሱስ ክርስቶስኒ ሱናሲክ ሀጱክቶሶነክ አጃጀ። ኤሴን ኦርፎ ጴጥሮስ ጋሮ ዎናኖን ባሶኔን አነ ፎናክ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ዩዳክ ፌሴ ዎስኒ ሜናዋ አይን ሜና አዛብኒ ሜያ ሀኦሲ ካማኖን ኤጴቴሴቴማቶ ኦደሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ጴጥሮስ የሩሳሌም ዎል ሌ ዬፌና ካባሲክ ሃርኮ ኩኑ ሾልሱ ስንናማቶ አማነሴፌ አይሁድኒ ሜኒ ክርስታናን ሜያ ጴጥሮስኒን፦ ");
INSERT INTO jnje_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«አዉኒ ቦርአ ሃርኮ ኩኑንኖይ አሱኒ ሜኒ ኬር ግርራ ባሶኔን አነ ሙ ማድፋታርሶ?» ይት ዌኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ስኑንታኖ ጴጥሮስ ኤካ ይት እሳርባ እሳርባሲክ ዙታምባሴ አሲን ኮቴ ባሶክ ማኬ፦ ");
INSERT INTO jnje_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«ታ እዮጰን ካታማስ ሀኦኒ ሺጶታ ፋና ራእ ቢን። ኤስ ቢና ራእስ ደይ እኛ ይኑን ማማነ ፋ ዉዛ አቼች ፋሽባስታን ኦቴራ ደን ሳማን ታ ፋና ድማስታ ኬሬድፌን ቢን። ");
INSERT INTO jnje_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ኤስ ባሮን ኮትክራ ቢፋና ኤስ ይኑን ማማስታ አቼች ዎቾባሬ ዬሬ ካባሬ የሬ ዉዛ ቡርኡኒ ጎኞ፥ ንባክ ዳስታክ ዛይፋ ቴስቶሴዋ ሳማስታክ ፉልፋ ካሳሴ አሲን ቢን። ");
INSERT INTO jnje_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‹ጴጥሮስኖ! ካብራ ሀን ባሮን ሹካ ሙዋ› ይፋ ካማ ኦደኒ። ");
INSERT INTO jnje_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ስኑንታኖ ዳሚሶ! ታክ ኣፋዋ ስናናዉዛ፤ ታ ኪና ዉዛ ወደይ ዝና ዉዛ ኖኖናስ ማራ ኣነ ብዩትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ሄፕሳ ደይ፦ ‹ሀኦሲ ካይማ ዛግና ባሮን ነ ኪናዋ ኡታክ ኣነ ሾልስፋዋ› ይፋ ካማሶን ደን ሳማን ኦደኒ። ");
INSERT INTO jnje_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ኤስ ባር ደይ ኬዛ ዎላ ስንናኔን ኦርፎ ኤስ ማማነ ፋ ዉዛስ ዙታምባሴ ዎላ ደን ሳማ ኦቴራ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ኤስ ካባሲክ ቅሳርያን ኬዝ አሱ ታክ ዎስቴሬ ታ ፋና ኬያስ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","እሳሮንኑ ኤክ ሀጝ ኡኖይ ባሶኔን ሀማናክ ኮርቶ አያናስ ታክ ማኬ። ሀን እሱን አይን ሜያ ደይ ታኔን አነቱ ፌሴቴ። ባሶኔን አነ ደይ ቆርኖሎስኒ ኬር ግርን። ");
INSERT INTO jnje_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ባር ደይ ሀኦኒ ዎስያ ባርኪ ኬር ግርራ ዬሬ ፌን ቢናማቶናዋ ‹ኤክ እዮጰ አሱኒን ዎስራ ጴጥሮስ ይስቴፌ ስሞንን ቴግሱዋ፥ ባር ደይ ");
INSERT INTO jnje_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ዬሬ ኔናዋ ነ ኬር ፌሴ አሱኒ ሜና ዙቴሬ ፋሩሶነ ካማ ኔክ ማኮናዋ› ይት ባርኪ ማኬናማቶ እኖክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ታ ደይ ማኬፋና ካባሲክ ኮርቶ አያናስ ዜምማ እኖስታ ኬሬናሲማቶ ባሶስታ ደይ ኬሬ። ");
INSERT INTO jnje_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ኤስ ካባሲክ፦ ‹ዮሀኒስ አካክቱ ሀጵቅዋ። ስኑንታኖ ንቶ ኮርቶ አያናክቱ ሀጱክቶትዋ› ይት ዳሚስ ማኬና ካማሶን ያዳቴን። ");
INSERT INTO jnje_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","እንኖ ዳምኒ የሱስ ክርስቶስኒን አማነፌን ካባሲክ ሀኦሲ እኖክ እምና ኤስ እማሶን ባሶክ ደይ እምናኔን ኤካኒ ሀኦሶን ካላክ ችምንር ታ ኦንሶ?» ");
INSERT INTO jnje_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ባሶ ደይ ኤስ ባሮን ኦደሴቴይሴ ኤጴ ማክሶነ ዉዛ ቱሩክሴፋት ሻክሴቴ። «ኤሴ ሀኦሲ አዛብኒ ሜያ ጋድዶ ካስ ዎልሶነክ ባሶትን ዛጉን ቦርኣስኒ ሀርምያሶን ባሶክ እምዋ» ኡክ ሀኦሶን ጋላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","እስጥፋኖስ ሹአክ እቼሬ ክትና ካባሲክ ካርአ ሻናሲክ ሲክቴ አማኝኒ ሜያ ፊንቀ፥ ኮጵሮስ፤ ሀማ አንሶኪያ ካርአና ካባኔን ሀሜቴ። ሀኦሲ ካማኖን አይሁድኒ ሜያታኖ ኦም አሱኒ ሜያክ ኣነ ማክሶቶ። ");
INSERT INTO jnje_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ስኑንታኖ ኮፕሮሱንናዋ ኬሬናና ዬሴ እሳ እሳ አማኝኒ ሜያ አንሶኪያ ሀሜፌ ካባሲክ ግሪክኒ ሜያክኔን ዳም የሱስኒ ማአ ኦዱኖን ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ዳሚስ ደይ ሁግናባሲክ ባሶትን አሪጋስት ፌር። ሾዎ አሱኒ ሜያ ደይ አማነሬ ዳሚሲክ ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","የሩሳለሙክ ፋ ቤቴክርስታኒስ ኤስ ባሮን ኦደናይሴ ባርናባስኒን አንሶኪያ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ባር ደይ ሀሜ ሀኦሲ ኦቱምባሶን ዳራባሲክ ኣካክ እምናማቶ ቢናይሴ ግሬ። ዙታምቤሲሴ ቱማ ንባክ አማነሬ ዳሚሲክ ችሜ የርሶነክ ኪት። ");
INSERT INTO jnje_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ኤሲስ ደይ ባርናባስ ኮርቶ አያናክናዋ አማንቶክና ቱሜ ፌ ማአ አሱ ስንና ቦርአ ፋድቤስ ሾዎ አሱኒ ሜያ ዳሚሲክ ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ኤሴን ኦርፎ ባርናባስ ሳዉልንን ሾሎናክ ቴርሴስ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ዳንናይሴ ኤክ አንሶኪያ ኤጴ ሀሚ። ሄፖቤሲሴ እሳ ዎግጋ ቤቴክርስታኒስኔን አነ እሳሪክ ሾዎ አሱኒ ሜያኖን አሲሴቴ። ኤስ ዎናስታኔን ካብራ ናዎኒ ሜያ፦ «ክርስታና» ይስቴሬ ቴግእቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ኤስ ካባሲክ እሳ እሳ ራጁኒ ሜያ የሩሳለሙን ካብሬ አንሶኪያ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ባሶ ጋነያስን እሳይስ፦ «አጋቦስ» ይስቴፌ ባር ካብሬ ዳ ዙታምባሴ አሲስ አካማ ማካ ስንናናማቶ ኮርቶ አያናስ ማኬን ራጅ ማኬ። ኤስ ባር ደይ ስንናስ ኬላዉዶስ ኬሳርኒ ታቶ ስንና ነያሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ኤስ ባሪ ቦርኣ አንሶኪያክ ፌሴፌ አማኝኒ ሜያ ዩዳክ ፌሴ አዪሳክቶኒክ ስኒ አሪጋሱ እሳ እሳርቤሲሴ ችሜቴማቶ ዋጋ ክሴሬ ባሶክ እምቶናክ ዎል ሌሬ ቡግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ኤስ አሪጋሱን ዋጋሶን ደይ ባርናባስኒክናዋ ሳዉልንክና ቤቴክርስታኒስ ኩርኡኒ ሜያክ ዎስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ኤስ ነያሲክ ሄሮድስ ይስቴፌ ታቶስ እሳ እሳ አማኝኒ ሜያኖን ካብጉ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ዮሀኒስኒ አይ ያቆብንን ሲፎክ ዎርቶናክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ኤስ ዉዛስ አይሁድኒ ሜያኖን ግርስንናማቶ ቢናይሴ ጴጥሮስኒን ደይ ኦትሬ ታት። ኤስ ባር ስንናስ አይሁድኒ ሜያ ክጣኒ ሄቦስ ኡልፍንቶና ዎናሲክቶስዋ። ");
INSERT INTO jnje_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ጴጥሮስኒን ኦትናኔን ኦርፎ ታቶኒ ኬር ጌድ። አይሁድኒ ፋስካኒ ሄቦስ ኣትናኔን ኦርፎ ዳራሳ ስና ታእሱናኔን አቼች አቼች ስኒፋፌ ኦዶነክ አቼች ሜያ ታርኦን ሜያክ ኣትሬ እሚ። ");
INSERT INTO jnje_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ኤስታን ጴጥሮስ ታቶኒ ኬያስ ኦድቴት ፌር። ስኑንታኖ ቤቴክርስታኒስ ዛግራ ባሳ ቾዋሲክ ሀኦሲክ ሺጴት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ዎኖትር ዎኖ ሄሮድስ ጴጥሮስኒን ዳራሲክ ታእሱናክ ሆሬሬ ፌን ኤስ ዋላሲክ ጴጥሮስ ሄፕ ሻሻራክ ታቴሬ ሄፕ ሜያ ታርኦን ሜኒ ጋነሲ ኩንፌር። ኦም ታሶሳክቶ ታቶኒ ኬያስ ፍኛኖን ኦደት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ኤስ ካባሲክ ዳሚሳ ዎስያ አምማኖን ቤስቴ። ታቶኒ ኬያስ ደይ ቻሬፋስ ቻሬ። ሀኦሲ ዎስያ ጴጥሮስኒ ቴሻሶን ታኡክ ኑሲክራ፦ «ታፕቴራ ካቡዋ» ይ። ኤስ ካባሲክ ሻሻራስ ኩሹባስን ዝግ። ");
INSERT INTO jnje_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ሀኦሲ ዎስያ ደይ፦ «ማምኔሶን ማያ ቻማኔሶን የርዋ» ይ። ጴጥሮስ ደይ ሀኦሲ ዎስያ ማክቴናስማቶ ዛግ። ኤስታን ሀኦሲ ዎስያስ፦ «ዎርአ ማምኔሶን ማያ ታኔን አነ ዮዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ጴጥሮስ ደይ ኬሴ ባርኔን አነ ሀሚ። ስኑንታኖ ራእ ቢድፌነ ፋር ስንናቱ ባርኪ ቤስቴታኖ ሀኦሲ ዎስያስ ዛግና ባር አምማ ስንና ባርኪ ኣነ ቤስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ቴሱኒሴዋ ሄፕሳን ታሶስንና አቴሬ ኤክ ካታማስ ታምፋ ብታን ጋማላሲክ ካርኤቴ። ጋማላስ ደይ ቴትባክ ጋቼን ባሶ ደይ ኬሴሬ እሳ ጋሮ ኡግናክ ሀሜቴ። ዲንቆክ ሀኦሲ ዎስያ ጴጥሮስኒስታን ኦር ኬሳ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ጴጥሮስ ንብባሲ ዎል ሌ፦ «ዳሚስ ዎሲባሶን ዎስሬ ሄሮድስኒ ኩሹስንናዋ አይሁድ ታይስታ ሳፋሬና ቾዋሲና ክስናማቶ ሀሽ አሪጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ኤስ ባሮ አሪናኔን ኦርፎ ሾዎ አሱኒ ሜያ እሳሪክ ዙቴሴሬ ሺጵሴት ፌሴቴ ማርቆስ ይስቴ ዮሀኒስኒ እንቶ ማራሚን ኬር ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ኤስታ ካርኤ ኬያስ ጋማላኖን ክእን ሮዳ ይስቴ እሳ ኬር ዎስትኛ ኦ ስንናማቶ ጋሳሱክ ጋማላሲክ ታእሴ። ");
INSERT INTO jnje_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ጴጥሮስኒ ካማ ስኒባሶ አራት ግራባስ ኣታምታን ካብራ ጋማላሶን ጋችኖይ ኦርፎ ዎላ ኤልላ፦ «ጴጥሮስ ፍኝ የሬፌ» ይራ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","አሱኒ ሜያ ደይ፦ «ንፋሴትዌ፥ ኣካ ኤካ ስናና» ይሴቴ። ስኑንታኖ ባር ፉቶ ስኒባሶ ጋሳሲራ ማኬ። ባሶ ዎልግሬ፦ «ባሳ ዎስያስዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ጴጥሮስ ቱስ ቱስሬ ጋማላሶን ክእ። ባሶ ጋማላሶን ጋችቼ ብያት ዲንቀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ባር ሻኩሶነክ ዛጋት ዳሚስ ታቶኒ ኬሩን ኣካክ ባሪን ክስናማቶ ማኬ። ኤስታን፦ «ታ ኬሳሶን ያቆብኒክናዋ አይሳክቶኒክና ማኮት» እያት ኦማ ድማ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ዎኖ ኤኢሶትርክ ሜያ ታርኦሳክቶ፦ «ጴጥሮስ አይ ሀሚሶ» ይሴት ጋነቤሲስ እኛ ሾርኮ ካቢ። ");
INSERT INTO jnje_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ሄሮድስ ጴጥሮስኒን ሾሌሬ ቱርክፋት ታሶን ሜያኖን ቱንሬ ማምሲናኔን ኦርፎ ዎርቶሶነክ አጃጀ። ኤሴን ኦርፎ ሄሮድስ ዩዳኒ ቅሳርያ ሀሜ ኤስታ ድ። ");
INSERT INTO jnje_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ሄሮድስ ትሮሲክናዋ ስዶናክና ፌ አሱኒ ሜያኔን ፋሴሬ ፌር። ዳቤሲስ ሙ ዳንፋናይ ታቶሳ ሀእሱስን ስንና ቦርአ ታቶሳ ኤራሾ ስና ብላስቶስኒኪን አሪጋሱን ሜካማ ዳናኔን ኦርፎ እሳሪክ ታቶስኔን አነ ጋኖክ ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ኦቴ ዎናስታ ሄሮድስ ታቶኒ ማያሶን ማየ ታቶኒ ዝግሙስታ ዲፋት ዳራሲክ ዎል ሌ። ");
INSERT INTO jnje_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ዳራስ ደይ፦ «ሀን ባር ሀኦኒ ካማታኖ አሱኒ ካማታዋ» ይት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ሄሮድስ ሀኦሲክ ኡልፍና እማ ቤይና ቦርአ ዳሚሳ ዎስያ ጌሬጌሬ እችን ቶዋክ ማስቴሬ ክት። ");
INSERT INTO jnje_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ስኑንታኖ ሀኦሲ ካማ ድቸትናዋ ታግትና ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ባርናባስናዋ ሳዉልና ዎስቶቤሲሶን ኮእስሬ የሩሳለሙን ዎልሴቴ። ማርቆስ ይስቴፌ ዮሀኒስኒን ዞንስሬ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","አንሶኪያ ፋ ቤቴክርስታኒስ ራጁኒ ሜናዋ ካምባስ አስሲኛና ፌሴቴር። ባሶ ደይ ባርናባስ፥ ካራ ይስቴፌ ስሞን፥ ኬሬናክ ሉክዮስ፥ አቼችሳ ዳሶን ሀእሲፌ ሄሮድስኒ ዞሞ ምናሄናዋ ሳዉልና ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ኤስ ባሶ ዳሚሲክ ዎስቴትናዋ ሶሜሬ ሺጵሴትና ፌሴቴን ኮርቶ አያና፦ «ባርናባስናዋ ሳዉልና አሲን ታ ቴጌና ዎስቶሲክ ኦር ክሱት» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ባሶ ሶሜሬ ሺጵሴፋት ኩሹቤሲሶን ባሶስታ ታእሬ ሺጵሴቴኔን ኦርፎ ጋፉክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ባርናባስናዋ ሳዉልንና ደይ ኮርቶ አያናስ ዎስን ኤክ ሴለዉክያ ኬሴቴ። ኤስታን ደይ ሜርኬብክ ቆጵሮስ ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ስልማናክ ፌሴቴ ካባሲክ ሀኦሲ ካማኖን አይሁድኒ ሺጶኒ ኬያሲ ማክሴቴ። ዮሀኒስ ደይ ባሶትን አሪጋስት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ኮጵሮስ ይስቴፋ አካክ ብራቶ ዳሶን ፍነሬ ፓፉ ካርኤፌ ካባሲክ ቤርያሱስ ይስቴ እሳ አይሁዳዊ ስና ቶልፋቱንን ዳነቴ፤ ባር ደይ ኤሽኛ ራጁ። ");
INSERT INTO jnje_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ባር ደይ ሴርግዮስ ጳዉሎስ ይስቴ ዳሶን ሀእሲፌ እሳ አሩ አሱስኔን አነቱ ፌፌ። ኤስ ዳ ሀእሲፌ አሱስ ሀኦኒ ካማ ኦዶናክ ሾሌሬ ባርናባስኒንናዋ ሳዉልንና ባርኪ ቴግስ። ");
INSERT INTO jnje_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ስኑንታኖ ሱንባስ ኮታ ሄልማስ ስና ቶልፋቱስ ዳሶን ሀእሲፌ አሱስ አማኖኖይናማቶ ሾሌፋት ባሶትን ቱጋኤ። ");
INSERT INTO jnje_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ጳዉሎስ ስኒፌ ሳዉል ኮርቶ አያናክ ቱሜ ኮትክ ብያት፦ ");
INSERT INTO jnje_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«ነ ማአ ዉዛስ ጉማ! ኤሽነዋ ማጙነ ነይስ ቱምና ሴጣን ና። ዜጵቶ ዳሚሳ ኡግናኖን ኤልጝሱሶን ኣፋኖሶ ቤያታ ዉዛ? ");
INSERT INTO jnje_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ዳሚሳ ኩሹ ኔን ኬእን ኣፍትሹ ስናታር። ጋሮ ዎኒሮን አዉኒ ቻሬፋ ኣፋ ብያታዉዛ» ይ። ጌሬጌሬ ክናነዋ ታሉምነ ባሳስታ ኬሬ። ኩሹባሶን ኤጴ ዞንሱኒ አሱኒ ሾሎክ ኤክ ሀጝ ኩት። ");
INSERT INTO jnje_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ዳሶን ሀእሲፌ አሱስ ስና ቾዋሶን ብያት ዳሚሳ አሩኖ ዲንቆክ አማነ። ");
INSERT INTO jnje_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ጳዉሎስናዋ ዞሞባሳክቶና ጳፉን ካብሴሬ ፕንፍልያ ፋ ፐርጌን ሀሜቴ። ኤስታን ዮሀኒስ ባሶስታን ኦር ኬሴ ዎል ሌ የሩሳሌም ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ስኑንታኖ ባሶ ፐርጌኑን ካብሴሬ ፕሲድያ ፋ አንሶኪያ ሀሜቴ። ባይሳኒ ዎናሲክ አይሁድኒ ሺጶኒ ኬያስ ግርሴሬ ዲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ሙሴኒ ቱማሴዋ ራጁኒ ሜኒ ትቻሴ ፌሬቴናኔን ኦርፎ አይሁድኒ ሺጶኒ ኬያሶን ሀእሲፌ ባሶ፦ «አይን ሜኖ፤ ዳራስ ሜርኮኒ ካማ ንቶክ ፋፋናነ ማኮትዋ» ይት ዎሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ጳዉሎስ ዳኩን ካብሬ ኩሹኒ ቤሱክ፦ «እስራኤልኒ አሱኒ ሜያነ፥ ሀኦሶን ድጌፌ ንቶ ዙቴራ ኦዶትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ሀን እስራኤልኒ ዳራሳ ሀኦ አባኒሳክቶኒን ኮሪ። ግጵጽኒ ዳስታክ ፌሴቴን ደይ ደን ቴግ። ዎርባስ ሁግናክ ኤስታን ክስ። ");
INSERT INTO jnje_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","አቼቻስር ዎግጋ ዛቦሲክ ባሶትን ፋኪ። ");
INSERT INTO jnje_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ኬነአክ ዳስታክ ፋ ናፉን ታቶስኪቶኖን ትሽካት ዳቤሲሶን ባር ዳራስ ዋራሶናክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ኤስ ባር ዙቴራ አቼች ትሬዋ ኡቻስሬ ዎጋሲክቱ ኮእ። ኤሴን ኦርፎ ራጁ ሳሙኤልኒስታ ካርአናኔን ሀእሱኒ ኤራሸ ሜያኖን እሚ። ");
INSERT INTO jnje_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ኤስታን ዳራስ ታቶ ባሶስታ ታቶናክ ሺጵሴቴ። ሀኦሲ ደይ ብንያምኒ ኬናስን ቂስኒ ና ሳዉልን እምን አቼቻስር ዎግጋ ባሶትን ሀእሲ። ");
INSERT INTO jnje_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ሳዉልን ኬስናኔን ኦርፎ ዳዊትኒን ባሶክ ታስ። ባሪን ደይ፦ ‹ታ ንባነ ፌርናዋ ታ ሾሌናሶን ዙትሬ ዛጉን እሴይኒ ና ዳዊትኒን ዳንጝዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ሀኦ ግርና ቴያስማቶ ኤስ አሱሳ ዛልታን ፋትር ስና የሱስኒን እስራኤልክ ቴሸ። ");
INSERT INTO jnje_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","የሱስ ዮኖይፌን ዜምማ ዮሀኒስ እስራኤልኒ ዳራ ዙቴሬ ሀርምሬ ሀጱክቶሶነክ ማኬሬ ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ዮሀኒስ ዎሲባሶን ኮእስናሴ፦ ‹ታ ኦ ስንና ንቶክ ቤስቴፋንሶ? ታ ባርቴዋ። ስኑንታኖ ኦርጎባስ ቻእማኒ ታርአኖኑ ኮታክ ችምኖይናር ታኔን ኦርፎ ዮኒርዋ› ይት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","አብራሀምኒ ዛላስኒ ኮንቴ አይ ስና ንቶናዋ እንኖ ጋነያስ ሀኦሶን ድጌፌ ባሶ ዙታምቤሲሴ አሲክ ሀን ፋሩን ካማ ዎስቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ስኑንታኖ የሩሳሌምክ አሱኒ ሜናዋ ባሶትን ሀእሲፌ ባሶትና የሱስኒን ኣነ አሪሶቶ። ቤይሳ ቤይሳኒ ዎናሲክ ፌሬቴፋ ራጁኒ ሜኒ ትቻስ ካማ ኮኡናክ ባሳስታ ማጝሱ ካርኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ባሪን ክቱታ ካቱኒ እሳ ማጝሱነ ቱሩክሴፌክኑ ጵላቶስ ክቱኒ ማጝሱ ባሳስታ ካርአናክ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ባርኪ ትቼ ባሮን ዙትሬ ኮእሴቴኔን ኦርፎ ሜስቀልስታን ኬስሴሬ ሞጋስ ካባርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ስኑንታኖ ሀኦ ባሪን ክቱኒ ካብግ። ");
INSERT INTO jnje_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ጋሊላን ካብሴሬ የሩሳሌም ካርአናኔን ባርኔን አነ ዬሴ ባሶክ ሾዎ ዎና ቢስቴ። ባሶ ደይ ሀሽ ዳራሳ ስና ዛልዋ። ");
INSERT INTO jnje_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","እንኖ ደይ ሀኦ አባን ሜያክ ግርና ቴያኒ ካማሶን ንቶክ ማኬን። ");
INSERT INTO jnje_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","የሱስኒ ክቱኒ ካብጉባሲክ ባሶክ ግርና ቴያኒ ካማሶን ናንጎትቤስ ስና እኖክ ዛግ። ኤሲስ ደይ ሄፕሳ ጋምን ትቻስ ኤካ ይስቴራ ትቼራ ፋር፦ « ‹ነ ታክ ናታዋ፤ ታ ኔን ሀሽ ሀውጙ ኮኒን።› ");
INSERT INTO jnje_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ባር ደይ ኣነ ኩፐ ስናማቶናዋ፤ ሀኦሲ ክቱኒ ካብጉባሶና ጋሳሱክ፤ ‹ኮርቶ አማናምቴራ ፋ ኤባሶን፤ ዳዊትኒክ ግርና አብዲሶን ንቶክ እማና› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«ኤሲስማቶ ኦማ ድምታ፦ « ‹ኮርቶኔስ ኩፓናክ ኣፋ ዛጉታዉዛ› ይፋዋ። ");
INSERT INTO jnje_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«ዳዊት ባሳ ነያሲክ ሀኦሲ ሳፋራኖን ዎስቴናኔን ኦርፎ ክት። አባባሳክቶኔን ካባርቴ፤ አሽባስ ደይ ኩፕ። ");
INSERT INTO jnje_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ስኑንታኖ ሀኦ ክቱኒ ካብግና ባር ኣነ ኩፐ። ");
INSERT INTO jnje_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","ኤሴ አይታሳክቶኖ፤ ቦርን ፋክያ ቤስቴፋናስ የሱስኒኪ ካሞ ስኒባስ ንቶክ ማክቴ ባሮን አሩት። ባርኪ አማነፌ ባር ዙቴሬ ሙሴኒ ቱማሲክ ዳኖኖይና ኦኮሶን ዳናና። ");
INSERT INTO jnje_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","ኤስ ባሪ ቦርኣ ራጁኒ ሜያክ ካሞ፦ ‹ካኝፌ ንቶ ቢትዋ፤ ዲንቆት፥ ትሹት፥ ኦኑ ንቶክ ማኬፌናክ አማኖኖይት ዎስቶ ንቶ ነያሲክ ዎስቶና› » ይሴቴ ባር ካርኖይናማቶ ቴትንትሶን አሩት። ");
INSERT INTO jnje_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ጳዉሎስናዋ ባርናባስና አይሁድኒ ሺጶኒ ኬያስኒ ኬሴፌ ካባሲክ አሱኒ ሜያ ኤስ ዉዛሶን ዮን ቤይሳኒ ዎናሲክ ሄፕስ ዎል ሌ ማክሶነክ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ዙቶስ ቦክቴናኔን ኦርፎ ሾዎ አይሁድኒ ሜናዋ አማኖክ ባሶስ ዎእቴሬ ሀኦ ሺጵሴፌ አሱኒ ሜና ጳዉሎስኒንናዋ ባርናባስንና አሲ ኦርፎሴ ሀሜቴ። ባሳክቶ ደይ ሀኦሲ ኦትማክ ችሜ ፎሶነክ ሜካማ እሜ። ");
INSERT INTO jnje_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ሄፕሳን ቤይሳኒ ዎናሲክ ካታማሲክ ዳራሳስን አሪክ ስናር ሀኦሲ ካማኖን ኦዶክ ዙቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","አይሁድኒ ሜያ አካም ዳራኒ ብየቴሴ ኮነሴቴ። ጳዉሎስኒ ዎላሶን ቱጋኦኪ ሜኤሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ስኑንታኖ ጳዉሎስናዋ ባርናባስና ድጋ ፎንቶኖን፦ «ሀኦሲ ካማ ዜምማ ንቶክ ማክቶናክ ሾልሱዋ። ስኑንታኖ ንቶ ካሽሴት። ደይ ኮእባ ፎንቶ ካ ንቶክ ሾልሱኖይናማቶ ቴትንትስታ ማጝሱ ካርኤት ቦርአ እንኖ አዛብኒ ሜያክ ሀሚንርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ዳሚስ ካምባስ፦ ‹ፋሩን ካማሶን ዳስ ድልታኔን ካቱታክ አዛብኒ ሜያክኔን ቻሬፋ ዛግንዋ› ይሬ እኖትን አጃጀ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","አዛብኒ ሜያ ኤስ ባሮን ኦደሴቴይሴ ግርሴሬ ዳሚሳ ካማክ ኡልፍና እሜሴቴ። ኮእባ ፎንቶ ካክ ሆሬ ባሶ ዙቴሬ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ዳሚሳ ካማ ኤስ ብራቶስታ ፋ ዳ ዙታምባሴ አሲስታ ዝእ። ");
INSERT INTO jnje_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ስኑንታኖ አይሁድኒ ሜያ ሀኦሶን ሺጶክ ደይ ኡልፍንቶ ማሽካ ሜያኖናዋ ካታማስ ፌሴ ኦቱም አሱኒ ሜያኖና ጳዉሎስኒስታናዋ ባርናባስኒስታና ካቡግሴሬ ዳቤሲስታን ካሌ ክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ጳዉሎስናዋ ባርናባስና ዎቾቤሲስታክ ቱሎኖን ቴባት ኢቆንዮን ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","አማነ ባሶ ደይ ግራክናዋ ኮርቶ አያናክና ቱሜሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","እኮኒዮኑክ ጳዉሎስናዋ ባርናባስና ሀዞዞትሲማቶ አይሁድኒ ሺጶኒ ኬያሲ ግርሴሬ ማእስሬ ማክሴቴ ቦርአ አይሁድኒስንናዋ ግሪክኒስና አካም ሾዎ አሱ አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ስኑንታኖ አማኖኖይ አይሁድኒ ሜያ አዛብኒ ሜያኖን ካቡግሴሬ አይኒ ሜያኖን ኦምቶሶነክ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ጳዉሎስናዋ ባርናባስና ዳሚሳ ቾዋኖን ድጋ ፎንቶኖን ማክሴት ሾዎ ዎና እኮኒዮን ዲሴቴ። ዳሚስ ደይ ማክሴቴ ሀኦሲ ኦቱምኒ ካማኖን ቢስቴራ አሪቶኖይ ቤሶክናዋ ዲንቂ ዎስቶክና አምማኖን ቤስት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ካታማሲ ፌ ዳራስ ሄፕክ ባግቴሬ እሳ ኩኑስ አይሁድኒ ሜያኔን፥ እሳ ኩኑስ ደይ ዎስኒ ሜያኔን ስኒ። ");
INSERT INTO jnje_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ኤስ ካባሲክ አዛብኒ ሜናዋ አይሁድኒን ሀእሲፌ ባሶትና እሳሪክ ስንነሬ ዎስኒ ሜያኖን ሹአክ እቻክ ሾልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ባሶ ኤስ ባሮን አሪሴቴሴ ልኮኒያኒ አዉራጃስ ፋሴ ልስጥራ፥ ዳርቤ ይስቴፋ ካታማሲክቶስናዋ ብራቶባስታና ሻቴሬ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ኤስታክ ሀኦሲ ካማኖን ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ልስትራክ ኮንቴናኔን ኩትሬ ቢኖይ ዎቾባ ላፋ አሱ ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ኤስ አሱስ ጳዉሎስኒ ዎላሶን ኦደድፌር። ጳዉሎስ ኮትክሬ ባርኪ ብያት ፋሩናክ አማንቶባ ፎባሶን አራት አካማ ካማክ፦ ");
INSERT INTO jnje_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","«ካብራ ዎቾኔሲክ የሮዋ» ይን ጌሬጌሬ ፍልለሬ ካቢ ታሪት ኩት። ");
INSERT INTO jnje_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ዳራስ ጳዉሎስ ዛግና ቾዋሶን ብየቴይሴ ልካኦንያዊኒ ሜኒ ካማክ፦ «ሀኦሲክቶ አሱነ ፋር ስንና እንኖ ጋነያሲ ኬሬዋ!» ይት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ባርናባስኒን ደይ ድያ ይሴቴ። አሪክሮን ማኬድፌር ጳዉሎስ ስንና ቦርአ ሄርሜን ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ካታማሲ ጌራካሎታ ፋ ድያኒን ቤቴሜቅደሲሲ ማግ ኦሞሩነዋ ታቶ ፉርአነ ኤጴ ካታማሲ ፍኝታ ዳራስኔን አነ ባሶክ ማአ እማክ ሾሌ። ");
INSERT INTO jnje_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ዎስኒ ሜያ ባርናባስናዋ ጳዉሎስና ኤስ ባሮን ኦደሴቴይሴ ማይቤሲሶን ካራስሴሬ ዳራሳ ጋነሲ ኤለሴቴ። ካምቤሲሶን ቴግሴሬ፦ ");
INSERT INTO jnje_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«ንቶ ሀን ባሮን አዋጋን ኤካ ዛግድፌትሪንሶ? እንኖ ንቶነ ፌ አሱዋ። ንቶ ሀን ፎንቶ ዉዛስን ኬስሳ ሳማሶን፥ ዳሶን፥ አካሴዋ ስር ኩኒ ቴስቶሶን ዙትራ ቴሲ ሀየዋ ሀኦስኪ ዎሉትክቱ ካምባሶን ንቶክ ማኬፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ሀኦስ ኣታ ነያሲ ዳራኒ ሜያ ዙቴሬ ቴትቤስሪ ኡግናክ ሀሞነክ ሻክራ ቤይ። ");
INSERT INTO jnje_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ስኑንታኖ ባር ዛልባሶን ማኬፋ ማአ ዎስቶሶን ዎስቶ ኣነ ቤያ፤ ሳማን እሮ እቻናክ ዛግ፤ ማራሶን ባሶክ እም፤ ሙክናዋ ግራክና ንቤሲሶን ጋዉስ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ኤስ ባሮን ዙትሬ ማክሴፌክኑ አካማ ካቦክቱ ዳራኒ ሜያ ማአ ባሶክ እሞኖይቴማቶ ካለቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ስኑንታኖ አይሁድኒ ሜያ አንሶኪያናዋ እኮኒዮክና ዬሴሬ ዳራስን ኤሽሴሬ ጳዉሎስኒን ሹአክ እቾሶነ ዛግሴቴ። ኤስታን ክትዋ እያት ቦኮስሬ ካታማሲን ጌራካሎ ክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ስኑንታኖ ናዎኒ ሜያ ጋነያ ጌዴ ፌሴቴን ካብሬ ካታማስሲ ግሪ። ዎኖትሪክ ባርናባስኔን አነ ደርቤ ሀሚ። ደይ ኣንሶኪያ ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ጳዉሎስናዋ ባርናባስና ደርቤክ ሀኦሲ ካማኖን ማክሴሬ ሾዎ አሱኒን አማንስሴቴኔን ኦርፎ ልስጥራነዋ እኮኖዮነ አሲስ አቴ ጵስድያ ፋ አንሶኪያ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ናዎኒ ሜያኖን ዛጉክ፥ ሀኦሲክ ችምሜ ፎሶነክ ሜርኬሴት፦ «ሀኦሲ ታቶሲ ግሩኒክ ሾዎ ሻና ኤጳቶኒክ ሾልስፋዋ» ይት አሲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ቤቴክርስታኒሲክቶኒ ኩርኡኒ ሜያኖን ኮሪሬ ታስሴቴኔን ኦርፎ ሶሜሬ ሺጵሴፋት አማነሴቴ ዳሚሲክ አዳራ እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ጵስድያ ካሞ አቴሬ ጵንፍልያ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ጴርጋሞኑክ ካምባሶን ማክሴቴኔን ኦርፎ አታልያ ኬርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ኤስታክ ዎስቴሴቴ ዎስቶሶን ሀኦሲ ኦትማክ ኮእስሴሬ ባሶክ አዳራ እማት አንሶኪያ ሜርኬብክ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ሀምሜ ካርኤ ቤቴክርስታኒሲ ፌ አማኝኒ ሜያክ ሀኦ ባሶኔን አነ ፋፋት ዛግና ባሮን ዙታምባሴ አሲናዋ አዛብኒ ሜያ ደይ ፋሩኒ ኡግና ጋቾባሶን ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ናዎኒ ሜያኔን አነ ሾዎ ዎና ኤስታ ዲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","እሳ እሳ አሱኒ ሜያ ዩዳን አንሶኪያ ሀሜሬ፦ «ሙሴኒ ቱማሲማቶ ሃርኮ ኩኑ ቤይፋትነ ፋሩትክ ኣፋ ችማት ዉዛ» ይሴት አይኒ ሜያኖን አሱክ ጃማርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ኤስ ባሪክ ጳዉሎስናዋ ባርናባስና ባሶኔን አነ አካማ ችማ ክሪክሪ ዛግሴቴ። ኤስታን ጳዉሎስናዋ ባርናባስና አንፆክያክ ፌሴ ኦም አማኝኒ ሜያኔን አነ ስንነሬ የሩሳሌም ሀሜሬ ኤስ ቾዋሶን ዎስኒ ሜያክናዋ ኩርኡኒ ሜያክና ማክሶነክ ዛግቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ቤቴክርስታኒስ ኡጉንቤሲሲክ አሪጋሴቴን አዛብኒ ሜኒ ሀኦስኪ ዎሉኖን ማክሴት ፌንቀነዋ ሳማርያነ አሲስ አቴሴቴ። ኦደ አይኒ ሜያ ዙቴሴሬ ግርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","የሩሳሌም ካርኤሴፌ ካባሲክ ቤቴክርስታኒስ፥ ዎስኒ ሜናዋ ኩርኡኒ ሜና አነ ስንነ ኤጴቴ። ባሶ ደይ ሀኦ ባሶኔን አነ ስንና ዎስቴና ዎስቶሶን ዙትሬ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ፌርሳዊኒ ኬናስን አማነ ባሶ እሳ እሳይስ ካብሴሬ፦ «አዛብኒ ሜያ ሃርኮ ኩኖሶነክናዋ ሙሴኒ ቱማሶን ኦዶነክና ዛጉ ሾልሱዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ዎስኒ ሜናዋ ኩርኡኒ ሜና ኤስ ቾዋሶን ቱእኑሶነክ ዙቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","አካማኖን ካራካርሴቴኔን ኦርፎ ጴጥሮስ ካብሬ ባሶክ፦ «አይኒ ሜያነ፤ ሀኦ ሾዎ ዎናኔን ስናክ ንቶ ጋነያሲን ታን ኮሪራ አዛብኒ ሜያ ሀኦሲ ካማኖን ታኪን ኦዴሬ አማኖሶነክ ዛጉባሶን አሪሴፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","አሱሳ ንባኖን አርፋ ሀኦሲ ኮርቶ አያናኖን እኖክ እምናሲማቶ ባሶክ ደይ እምማ ባሶትን ኤጳ ቶባሶን ቤሲ። ");
INSERT INTO jnje_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ንቤሲሶን አማንቶክ ካይንና ቦርአ ባሶትናዋ እኖትና አሲ ጋነያሲ ኣነ ድሎዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ኤሴ አባኒሳክቶናዋ እኖትና ዎርአክ ችምኖይኒ ዋንጆሶን ናዎኒ ሜኒ ኦጎግታ ዎሱክ ሀሽ አዉኒ ቦርአ ሀኦሶን ሽምስድፌትሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","እንኖኑ ፋሩኒስ ባሶሲማቶ ዳምኒ የሱስኒ ኦትማሲክ አማኖክዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ኤስታን ዳራስ ዙቴሬ ሻኪ። ባርናባስናዋ ጳዉሎስና ሀኦ ባሶኪ ካሞ አዛብኒ ሜኒ ጋነያሲ ዛግና ቢስቴራ አሪቶኖይ ዲንቂ ቾዋሶን ማክሴቴን ኦደሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ባሶ ደይ ማክሴሬ ኮእስሴቴኔን ኦርፎ ያቆብ ካብሬ፦ «አይኒ ሜያነ፤ ኤሴ ኦዶትዋ! ");
INSERT INTO jnje_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ሀኦስ ባሪክ ቴግቶኒ ዳራኒን ባሶ ጋነያስን ኮሩናክ ቴሱስታ አዛብኒ ሜያክ ኣካክ ያናማቶ ስሞን እኖክ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ራጁኒ ሜያኪ ካሞ ደይ፦ ");
INSERT INTO jnje_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","« ‹ኤሴን ኦርፎ ዎሉናዋ፤ ቦግቴ ዳዊትኒ ኬያሶን ዎልግራ ኬርአና፤ ቦግቴራ ጋንደ ባሮን ደይ ዎልግራ ዬቱና፤ ሄፕስኑ ደይ ዎልግራ ኬርአና። ");
INSERT INTO jnje_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","ኤስ ባሮን ደይ ዛጉናስ፤ ፉእቴ አሱኒ ሜናዋ፤ ታ ሱናሲክ ቴግቴ አዛብኒ ሜና፤ ዙቴሬ ታ ዳሚስን ሾልሶነክዋ፤ ዜምማኔን ሀን ባር ዙቴራ አሪቶናክ ዛጊስ፤ ታ ዳሚስዋ› ይስቴ ባርኔን እሳርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«ኤስ ባሪ ቦርኣ ታ ሳፋራስ ሀኦሲክ ዎል አዛብኒ ሜያኖን ሽምሱኖይኒማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ኤስ ባርስታን ‹ኮሎሲክ ማአ ስንና እምቶክ ኪና ሙሶን ሙትታ፤ ጌርኬሳስታን ዎክት፤ ጌቴራ ክት ባሮን ሙትታ፤ ሀና ሙትታ› ይራ ባሶክ ትቹንክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","እቤኔን ሙሴኒ ቱማሲ ቤይሳ ቤይሳኒ ዎናሲክ አይሁድኒ ሺጶኒ ኬያስ ፌሬቴት ፋር፤ ካምባስ ደይ ካታማ ካታማስና ማክቴርዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ኤሴን ኦርፎ ዎስኒ ሜናዋ ኩርኡኒ ሜና ቤቴክርስታንን ሜያኔን አነ ስንነሬ ጋነቤሲስኒ ጋሮ አሱኒን ኮርሴሬ ጳዉሎስናዋ ባርናባስና አነ አንሶኪያ ዎሱሶነክ ቡግሴቴ። አይን ሜኒ ጋነያስ ማአ ሀእሱባሲክ አርቶ ስና ቤርሳባስ ይስቴ ዩዳኒንናዋ ስላስኒንና ኮርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ትቼ ትቻሶን ጳዉሎስኒክናዋ ባርናባስኒክና ዎስሴቴ፤ ኤስ ባር ደይ ኤካ ይፋር፦ «አይን ሜያ፤ ዎስኒ ሜናዋ ኩርኡኒ ሜና አዛብኒ ሜኒ ኬናስን አማነሬ አንሶኪያክ፤ ሶርያክ፤ ክልቅያ ፌሴ አይኒሳክቶኖ! ናጋ ንቶክ ኦሸፌንዋ» ");
INSERT INTO jnje_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","እሳ እሳ አሱኒ ሜያ እንኖ አጃጆኖይንሮን እንኖስን ኬሴሬ ማክሴቴ ባርኪ ንቶ ንባሶን ሾሩክሴቴማቶናዋ ራክስሴቴማቶና ኦደኒዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ኤስ ባሪ ቦርኣ እሳሪክ ዙቴራ ዎል ሌንኔን ኦርፎ አሱኒ ሜያኖን ኮሪራ ሹንቶ አይን ባርናባስኔን ጳዉሎስኔን አነ ንቶክ ዎሱክ እሳር ስኒ። ");
INSERT INTO jnje_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ባርናባስናዋ ጳዉሎስና ዳምኒ የሱስኒ ሱናሲክ ካቤሲሶን ኣትሬ እማ አሱዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ንቶክ ትችኒስ ባሮን ካማክ ኮቴ ማክሶነክ ዩዳኒንናዋ ስላስኒንና ዎስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ሀን ሾልሱ ቾዋስኔን ኦማ ባአ ንቶስታ ዎሱኖይንማቶ ኮርቶ አያናሴዋ እኖትና ማአሪ ስንናማቶ ቢንዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ኤሲስ ደይ ኮሎሲክ እምቴራ ኪና ሙ ሙትታ፤ ሀና ሙትታ፥ ጌቴራ ክት ዋግን አሻ ሙትታ፥ ጌርኬስታን ዎክት፤ ኤስ ኤፋቴና ዉዛ ዙታምባሴ አሲስኒ ቴትንትሶን ኦዳትነ ማአሮን ዛግትዋ፤ ማርኦጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ዎስቴ አሱኒ ሜያ ደይ፦ «ማርኦጝዋ» እያት አንሶኪያ ሀሜቴ፤ ክርስታናን ሜያኖን እሳሪክ ዙትሬ ትቻሶን እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ባሶ ደይ ትቻሶን ኤጴሬ ፌሬትሴቴኔን ኦርፎ ዳነቴ ማአ ሜካማሲክ ግርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ዩዳናዋ ስላስና ቴትቤሲሲክ ራጁ ስንነቴ ቦርአ አይን ሜያኖን አካማኖን ሜርኬሬ ዛግሴቴ ደይ ችኒሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ኤስታ ጋሮ ዎና ዲሴቴኔን ኦርፎ አይን ሜያ «ማአሮን ሀሞት» ይሴቴን ዎል ሌ ባሶትን ዎሲ ባሶክ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ስኑንታኖ ስላስ ኤስታ ፉእቶናክ ሾሌ። ");
INSERT INTO jnje_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ጳዉሎስናዋ ባርናባስና ኦም ሾዎ አማኝ ሜያኔን ዳሚሳ ካማኖን አስሲትናዋ ማኬትና አንሶኪያ ጋሮ ዎና ዲሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ጋሮ ዎናኔን ኦርፎ ጳዉሎስ ባርናባስኒ፦ «ካብን ዳሚሳ ካማኖን ማኬን ማኬን ካታማስ ዎላ ሀማ አይን ሜያኖን ማምሱንዋ፤ ኣካ ፌሴቴማቶ ደይ ብያንዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ባርናባስ ደይ ማርቆስ ይስቴፌ ዮሀኒስ ባሶኔን አነ ሀማናክ ሾሌ። ");
INSERT INTO jnje_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ስኑንታኖ ማርቆስ ስናክ ዜምሜ ባሶኔን አነ ዎስቶስ ሀማ ቤይፋት ፕንጲልያክ ኦር ኬሴ የሩሳሌም ሀሚና ቦርአ ጳዉሎስ ባሪን ኤጴ ሀማክ ኣኔ ሾሎዌ። ");
INSERT INTO jnje_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ኤስታን ባሶትና ባሶትና አሲ ጋነያስ ክርክር ካብን ኦር ኦር ኬሴቴ። ኤስ ባሪ ቦርኣ ባርናባስ ማርቆስኒን ኤጴ ሜርኬብክ ኮጲሮስ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ስኑንታኖ ጳዉሎስ ደይ ስላስኒን ኮሪ። አይን ሜያ ደይ ጳዉሎስኒን ዳሚሳ ኦትማክ አዳራ እሜቴኔን ኦርፎ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ቤቴክርስታኒሲክቶኖን ችኒት ሶርያነዋ ክልቅያነ አሲስ ካሞ አቴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ጳዉሎስ ደርቤናዋ ልስትራነ ስኒፋ ዳስታክ ሀሚ። ኤስታክ ትሞትዮስ ይስቴ አማኝ አሱ ፌር። እንቶባስ አይሁድኒ ሜኒ ክርስታና። ስኑንታኖ አባባስ ግሪክኒ ዳኒ አሱ። ");
INSERT INTO jnje_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ትሞትዮስ ልስትራነዋ ኢቆንዮነ አሲስ ፌ አይን ሜኒ ጋነያስ ማአሪክቱ አሪቴፌ። ");
INSERT INTO jnje_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ጳዉሎስ ትሞትዮስኒን ኤጴ ባርኔን አነ ሀማናክ ሾሌፋት ኤስ ብራቶስታ ፌ አይሁድኒ ሜኒ ቦርአ ትሞትዮስኒን ሃርኮ ኩንስ። ኤስ ባሮን ደይ ዛግናስ ኤስታ ፌሴ አይሁድኒ ሜያ ዙቴሬ ትሞትዮስኒ አባስ ግሪክኒ ዳኒ አሱ ስኒባሶን አሪሴሬ ፌሴቴር ስንና ቦርአ። ");
INSERT INTO jnje_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ባሶ ደይ እሳ ካታማስን ኬሴ ኦማ ካታማስ ሀሜፌ ካባሲክ የሩሳለሙክ ፌሴ ዎስኒ ሜናዋ ኩርኡኒ ሜና ዎሉምሴሬ ኣትሴቴ ስትሪሶን አማኝኒ ሜያክ አሲሴት ፌሴቴር። ደይ ዎስቶታ ፌሹሶነክ ማክሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ኤስ ባሪ ቦርኣ ቤቴክርስታኒሲክቶ አማንቶቤሲሲክ ችሜሬ ፋድቤሲስ ደይ ዎንና ዎንናሲክ ዳይቴት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ጳዉሎስናዋ ባርኔን አነ ፌ ባሶና ኢስያክ ካምባሶን ማክሶኖይቴማቶ ኮርቶ አያናስ ካልና ቦርአ ፍርግያነዋ ጋላትያኒስ ካሞ አቴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ሚስያን ድላስታ ካርኤፌ ካባሲክ ብታኒያ ሀሞነክ ካብሴቴ። ስኑንታኖ የሱስኒ አያናስ ኤስታ ካሞ ሀሞኖይቴማቶ ካል። ");
INSERT INTO jnje_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ኤስ ባሪ ቦርኣ ሚስያ ካሞ አቴ ትሮአዳ ኬርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ኤስታን ዋልን እሳ ሜቀዶኒያኒ አሱ የሬፋት፦ «ሀጝ ሜቀዶንያ ፍንፋት እኖትን አሪጋሱዋ» ይፌን ጳዉሎስ ራእክ ቢ። ");
INSERT INTO jnje_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ጳዉሎስ ኤስ ራእሶን ቢናንኔን ኦርፎ ጌሬጌሬ ሜቀዶንያ ሀማክ ሾሌን። ኤሲስ ደይ ሜቀዶንያክ ፌሴ አሱኒ ሜያክ ምስራቹኒ ካማሶን ማኮኒክ ሀኦሲ እኖትን ቴጌነ ፋር ስንና ቤስቴና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ትሮአዳን ሜርኬብስ ዲራ ሳሞትራቀ ሀሚን። ዎኖትር ዎኖ ደይ ናጱለ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ኤስታን ካብራ ሀማ ፍልጲስዩስ ካርን። ፍልጲስዩስ ደይ ሜቀዶኒያኒ ካታማ ስኒፋት ሮማኒ ሀኢእሱስ ስካሎስ ፋ ዋራዳኒ ካትማዋ። ኤስ ካታማስ ጋሮ ዎና ዲን። ");
INSERT INTO jnje_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ቤይሳኒ ዎኖ ደይ ሺጶክ ዙቴሴፌ ድማ ካታማስ ጌራካሎታ ፋ ዎርአ አካስ ሀእታ ስንናማቶ ሳፋሬን ቦርአ ኤስታ ሀሚን። ኤስታ ዲፋት ዙቴሴራ ፋሴ ማሽካሱሲክቶክ ሀኦሲ ካማኖን ማኬን። ");
INSERT INTO jnje_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ኦደት ፋሴ ማሽካሱሲክቶስኒ ልድያ ይስቴ እሳ አሱ ፋር። ባር ደይ ሀኦሶን ሺጴ አሱ። ትያትሮን ካታማስን ኮንቴ ዋንታጅን ማምን ናጋደ። ዳሚስ ንባሶን ጋችና ቦርአ ጳዉሎስ ማኬፌና ካማሶን ጋሳሲራ ኦደት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ባሬዋ ባር ኬርክ ባሶትና ዙቴሬ ሀጱክቴሴቴኔን ኦርፎ፦ «ዳሚሲክ አማኖናሶን ጋሳሲራ አሪሴትኔን ታክ ኬር ያራ ዱትዋ» ይት ችኒራ ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","እሳዋ ሺጶኒ ድማስታ ሀሚፌን ሀኔንት ስኒ ዉዛ ዎል ሌፋ ኪና አያና ኤጵና ኬር ዎስትኛ ስና እሳ ዱርባ ናዋ እኖክ ኡጰ። ባር ደይ ቶልፋትባሲክ ባሮን ሀእሲፌ ባሶክ አካማ ዋጋ ዳኖነክ ዛግት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ባር ጳዉሎስኒንናዋ እኖትንና አሲ ኦርፎሴ ያፋፋ፦ «ሀን ባሶ ፋሩን ኡግናሶን ንቶክ ማክሴት ፌሴ ዙታምባሴ አሲ ደናሎ ስና ሀኦሲ ዎስትኛኒ ሜያዋ!» ይት ቻጌት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ኤስ ባሮን ደይ ሾዎ ዎና ዛግ። ስኑንታኖ ጳዉሎስ ሃሬሬ የርቀሬ ኪና አያናሶን፦ «የሱስ ክርስቶስኒ ሱናሲክ ባርስኒ ኬሳታክ አጃጀፋን!» ይ። ኪና አያናስ ደይ ኤስ ካባሲክ ኬስ። ");
INSERT INTO jnje_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ባሮን ሀእሲፌ ባሶ ቡአ ዳነፌ አብድቤሲስ ኬሳ ሀምባሶን ብየቴይሴ ጳዉሎስኒንናዋ ስላስኒንና ኤጴቴ። ዛቴ ደይ ያቦስታ ታሜ ጋኘ ሜኒ ስና ታእስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ሮማኒ ዳሶን ሀእስሴፌ ባሶክ ታእስሬ ኤካ ይሴቴ፦ «ሀን ባሶ አይሁድ ሜኒ ኬጝዋ! ካታማኒሶን ደይ ናጋ ቱሩክስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","እንኖ ሮምኪ አሱ ኤጳቶኒክ ወደይ ዛጉንክ ሾልሱኖይ ስትሪሶንቱ ማክሴፌ።» ");
INSERT INTO jnje_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ዳራስ ደይ እሳሪክ ጳዉሎስኒንናዋ ስላስንና አሲስታ ካብሴቴ። ዳ ሀእስሴፌ ባሶ ደይ ማይቤሲሶን ጋኤሬ ሃሮክ እቾሶነክ አጃጀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","አካማኖን እቸሴቴኔን ኦርፎ ታቶኒ ኬር ጌደሴቴ። ታሶስ ማእስሬ ኦዳናክ አጃጀሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ታሶስ ደይ ኤስ አጃጂሶን ኤጵናኔን ኦርፎ ታቶኒ ኬያስ ኬርካሎ ፋ ኬያስ ባግቶስ ጌደ ዎቾቤሲሶን ግኖስ ጌደ ስፐ ታርእ። ");
INSERT INTO jnje_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ዋሲ ዳኒ ኪጤክ ጳዉሎስናዋ ስላስና ሺጶክናዋ ጋማክና ሀኦሶን ጋላቴሴት ፌሴቴር። ኤስ ካባሲክ ኦም ታቶኒ ሜያ ደይ ባሶትን ኦደሴድፌር። ");
INSERT INTO jnje_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ዲንቆነ ታቶኒ ኬያስ ካፕታ ሾርኮናኔን አካማ ዳኒ ሾርኮ ስኒ። ታቶኒ ኬያስ ጋማላ ዙቴራ ጋችቼ። ታቶኒ ሜኒ ሻሻራስ ደይ ባክ ኮቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ታሶስ አፋይኒታን ጉዝሬ ታቶኒ ኬያስ ጋማላ ጋቾባሶን ቢናይሴ ታቶኒ ሜያ አቴ ኬሴቴነ ፋር ስንና ባርኪ ቤስቴፋን ባር ባሪን ዎልግሬ ዎሩናክ ስኮባሶን ቦኮስሬ ክስ። ");
INSERT INTO jnje_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ስኑንታኖ ጳዉሎስ ካምባሶን ቴግሬ ቻጌ፦ «እንኖ ዙታምኒሴ ሀንታቱ ፋንዋ፥ ነ ነይስታ ማጙ ዉዛ ዛጉታታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ታሶስ ቶና ኤጴ ዮሶነክ ቴጌሬ ኤልለ ኬርካሎ ግር። ኮርክት ደይ ጳዉሎስናዋ ስላስና አሲ ዎቾስ ጋንደሬ ሳጋደ። ");
INSERT INTO jnje_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ባሶትን ጌሮ ክሳት፦ «ዳምኒ ሜያነ! ፋሩናክ አዉ ዛጉናክ ሾልስፋሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ባሶ ደይ፦ «ዳም የሱስኒክ አማኖዋ፤ ኔናዋ ኔክ ኬርክ አሱኒ ሜና ፋርሶነዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ኤስታን ዳሚሳ ካማኖን ባርኪናዋ ባርኪ ኬር ፌሴ ባሶ ዙታምቤሲሴ አሲክና ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ኤስ ሳአትስታክ ታሶስ ዋሲ ጳዉሎስኒንናዋ ስላስኒንና አሲን ኤጴ ታሜ ማዛቤሲሶን ማስ። ጌሬጌሬ ደይ ባርናዋ ባርኪ ኬር ፌሴ ባሶትና ዙቴሬ ሀጱክቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ኤሴን ኦርፎ ታቶኒ ኬያሶን ታሶስ ጳዉሎስኒንናዋ ስላስኒንና ኬባ ኤጴ ታሜ ሙ ማስ። ሀኦሶን አማነና ቦርአ ባሳ ኬርክ አሱኒ ሜያኔን ዙቴሬ ግሬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ዎኒፋና ካባሲክ ዳሶን ሀእሲፌ ባሶ፦ «ታቶኒ ሜያኖን ኮታ ጋፍኩትዋ» ይት ባሶ ፖልሲኒን ዎሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ታሶስ ባር ደይ፦ «ዳሶን ሀእሲፌ ባሶ ኮቶትክ ፖልሲኒን ዎስሴቴ ስንና ቦርአ ኬሳ ናጋክ ሀሚትዋ» ይት ጳዉሎስኒክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ስኑንታኖ ጳዉሎስ፦ «እንኖ ሮምኪ አሱ ስንና ፋኒ ዳራሳ ስናክ ማጝሱ ካርባ ፎንቶኖን ያቦስታ እቸሬ እኖትን ታቶኒ ኬር ጌደቴ። ሀሽ ደይ ኣቾክ እኖትን ታቶኒ ኬሩን ክሱክ ሾልሴፌሶ? ኤስ ባር ኣፋዋ ስናናዉዛ ባሶ ዬሴሬ እኖትን ኮቴ ክሶቶዋ!» ይት ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ፖልሲኒ ሜያ ኤስ ካማሶን ዳሶን ሀእሲፌ ባሶክ ማክሴቴ። ዳሶን ሀእሲፌ ባሶ ጳዉሎስናዋ ስላስና ሮምኪ አሱ ስኖቤሲሶን አሪሴቴይሴ ድጌሴቴ ");
INSERT INTO jnje_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ዬሴሬ ደይ ማጝስኒ ይሴሬ ታቶኒ ኬሩን ባሶትን ክሴቴ፤ ካታማስን ደይ ኬሴ ሀሞነክ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ጳዉሎስናዋ ስላስና ታቶኒ ኬሩን ኬሴሬ ልድያኒ ኬር ሀሜቴ። ኤስታክ ሀሜ አይን ሜያኖን ዳነሬ ችኒሴፋት ካታማሶን ጋፍክሬ ኬሴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ጳዉሎስናዋ ስላስና አንፍጶልያነዋ አጶሎንያነ አሲስ ካሞ አቴ ቴሴሎንቀ ሀሜቴ። ኤስታክ አይሁድኒ ሺጶኒ ኬያ ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ጳዉሎስ ሀዞዞት ዛግፌናሲማቶ አይሁድኒ ሺጶኒ ኬያስ ግር። ኬዝ ቤይሳኒ ዎና ስኒሮን ኮርቶ ማፃፋሲኒ ክሳፌ ዳራሲክ ኮትቴ ማኬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ክርስቶስ ሻናሶን ኤጴቶናክናዋ ክቱኒ ካቡናክ ሾልሱ ስንናማቶ ኮቴ ማኬት፦ «ሀን ታ ንቶክ ማኬፋና የሱስ ባር ክርስቶስዋ» ይት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ኤስታን አይሁድኒስን እሳ እሳይስ ካምባሶን ኦደሴሬ ጳዉሎስኔን ስላስኔን አነ እሳር ስንነቴ። ፋድቤስ አካም ሾዎ ሀኦሶን ሺጵሴፌ አዛብኒ ሜናዋ ሾዎ አርቶ ማሽካ ሜነ ካምባሶን ኦደሴሬ ባሶኔን አነ እሳር ስንነቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ስኑንታኖ አይሁድኒ ሜያ ኮነሴሬ ናጋ ትሽኩን ዎስቶቤስ ፎንቶ አሱኒ ሜያኖን ዙትሬ ባሶስታ ካቡግሴቴ። ካታማስ ደይ ናጋ ትሹናክ ዛግሴቴ። ጳዉሎስኒንናዋ ስላስኒንና አሲን ዳራሲክ ኣትሬ እማክ እያሶንኒ ኬያሶን ኬጲሬ ዙቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ስኑንታኖ ባሶትን ኣነ ዳኖቶ ስንና ቦርአ እያሶንናዋ አይን ሜያስን እሳ እሳይስን ዛቴ ካታማስ ፌ ጋኜ ሜኒ ስና ታሜፋት፦ «ሀን አሱኒ ሜያ ሀን ዳሶን ዙትሬ ናጋ ቱርክስ፤ ሀሽ ደይ ሀንታ ዬሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","እያሶንኒ ደይ ባሶትን ኤጴቴዋ፦ ‹የሱስ ይስቴ ኦም ታቶ ፌርዋ› ይሴፋፌ ኬሳርኒ አጃጂሶን ቱጋሴድፌዋ» ");
INSERT INTO jnje_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ዳራስናዋ ካታማሶን ሀእሲፌ ባሶትና ኤስ ባሮን ኦደሴቴይሴ ሻጳሬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ኤስታን እያሶንናዋ ኦም ሜያኖና ዋሲ ቴግሶነክ ዛግሴሬ ጋፉክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","አይን ሜያ ጌሬጌሬ ጳዉሎስኒንናዋ ስላስኒንና ዋልን ቤርያ ሀሞነክ ዛግሴቴ። ኤስታ ካርኤቴይሴ ደይ አይሁድኒ ሺጶኒ ኬያስ ግርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ቤርያክ ፌ አሱኒ ሜያ ቴሴሎንቀክ አሱኒ ሜያስታን ማአ ያዳትቤስ ፋር ስንና ቦርአ ካምባሶን ማአሪክ ኤጴቴሴቴ። ኤስ ካማስ ፉቶ ስኒባሶን አሪሴሬ ዎንና ዎንና ኮርቶ ማፃፋሶን ፌሬሬ ብየት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ኤስ ባሪ ቦርኣ ባሶስኒ ሾዎስ አማነሴቴ። ደይ ሾዎ ግሪክኒ ዳኒ ኦቱምባ ፋና ማሽካ ሜናዋ ኣርቃ ሜና አማነሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ስኑንታኖ ቴሴሎንቀክ ፌሴ አይሁድኒ ሜያ ጳዉሎስ ሀኦሲ ካማኖን ቤርያክ ማኬናማቶ አሪሴቴይሴ ኤስታ ሀሜሬ ዳራስን ማጙክ ካብግሬ ፋሶ ካቡግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ኤስ ካባሲክ አይን ሜያ ጌሬጌሬ ጳዉሎስኒን ኤክ ባርስ ቴሻ ሀማናክ ዛግሴቴ። ስኑንታኖ ስላስናዋ ትሞትዮስና ቤርያክ ፉእቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ጳዉሎስኒን ኤጴ ኬሳ ባሶ ደይ ባሪን አቴና ካትሴቴ። ኤስታን ስላስናዋ ትሞትዮስና ታፕቴሬ ታክ ዮሶቶዋ ይፋ ጳዉሎስኒ አጃጂሶን ኤጴ ቤርያ ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ጳዉሎስ አቴናክ ስላስኒናዋ ትሞትዮስኒና ኦድፌን ካታማስ ኮሎ ቱማ ፌን ብያት አያናባሲክ ሃሬ። ");
INSERT INTO jnje_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ኤስ ባሪ ቦርኣ አይሁድኒ ሺጶኒ ኬያስኒ አይሁድኒ ሜያኔናዋ ሀኦሶን ሺጵሴፌ አሱኒ ሜያኔና ጋባስታ ዎንና ዎንና ዳንፌና አሱሳክቶነን ዌእኒት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ኤጲኮሮስኒ ሜና ይስቴፌ ባሶናዋ እስቶኮስኒ ሜና ይስቴ ባሶና ባርኪ ዬሴፋፌ ዌእኒት ፌሴቴር። እሳ እሳ ሜያ፦ «ሀን ስኖይ ዎላ ዎል ሌፌ ባር አዉናክ ሾሌፌሶ?» ይሴቴን ኦምን ሜያ ደይ፦ «ጋድዶ ኮሎስ ቾዋኖንቱ ማኬፌዋ» ይት ፌሴቴር። ኤስ ባሮን ደይ ማኬሴቴስ ጳዉሎስ የሱስኒንናዋ ክቱኒ ካቡኒ ኦዱሶንና ማኬና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ኤስ ባሪ ቦርኣ ጳዉሎስኒን አሪዮስፋጎስ ይስቴ ድማስታ ዙቴራ ፋ ሾንጎስታ ኤጴ ሀምፋት ኤካ ይሴቴ፦ «ሀን ነ ማኬፋታ ጋድዶ አሱስ አዉ ስንናማቶ አሩኒክ እኖክ ማኮዋ? ");
INSERT INTO jnje_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","እሳ እሳ ጋድዶ ጋድዶ ዉዛ ኔኪን እንኖ ኦደኒ ስንና ቦርአ ኤስ ባር አዉ ስንናማቶ አሩኒክ ሾሌፌንዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ኤስ ባሮን ይሴ አቴናክ አሱኒ ሜናዋ አቴናክ ፌሴ እርባኒ ሜና ጋድዶ ጋድዶ ዉዛ ዎሎክናዋ ኦዶክና ዎኒቤሲሶን ኣቱ ሹነሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ኤስ ካባሲክ ጳዉሎስ አሪዮስፋጎሱክ ዙቴራ ፋ ሾንጎስ ጋነሲ የሬፋት ኤካ ይ፦ «ሀን አቴናክ አሱኒ ሜያነ! ንቶ ሾዎ ሁግናክ ሀይማኖትንትሶን ዛግራ ኤጴፌትማቶ ቢጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ንቶ ካታማስ ብራቴፋት ሀኦ ሺጴፌት ድማሶን ቢፋና ካባሲክ፦ ‹አሪቶኖይ ሀኦኪ› ይስቴራ ትቼራ ፋና ሾአሶን ዳንጝዋ። ኤሴ ታ ንቶክ ማኮናስ ኤስ አሩኖይ ሺጴፌት ሀኦሶጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ኤስ ባር ሀን ዳሴዋ ሀን ዳስታክ ፋ ቴስቶ ዙታምባሴ አሲን ዙትራ ቴሲስ ሳማሴዋ ዳሴ አሲ ዳማዋ። ባር አሱኒ ኩሹ ኬርና ቤቴሜቅደሲሲ ኣነ ፋፋዋ። ");
INSERT INTO jnje_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ካሶናዋ ካትፌን ባሮና ደይ ኦማ ዉዛሲክቶኖኑ ዙትራ አሱኒክ እምኒስ ባር ስንና ቦርአ እሳ ዉዛነ ባርኪን ኣነ ዮእፋዋ። አሱኒ አሪጋሱ ደይ ባርኪ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ኔቤሲሶናዋ ፎሶነ ዳስ ድላኖንና ድለራ እሚ። አሱኒ ዛላሶን ዙትራ እሳ አሱኒኪንቱ ቴስ። ሀን ዳ ዙታምባሴ አሲስታ ደይ ፎሶነክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ኤስ ባሮን ዛግናስ ደይ አሱኒ ሜያ ሀኦሶን ሾሌሬ ቱንሬ አዉዛክነ ባሮን ዳናክ ችሞነክዋ። ስኒፋናክኑ ባር እሳርን እሳርኒሳታን ዎካታዋ። ");
INSERT INTO jnje_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","« ‹ካ ዳኒስ፤ ሾርኬራ ኩትፌኒስ፤ ደይ ፋፌኒ ፎስኑ ባርኪዋ› ኤሲስ ደይ፤ ንቶስኒ ጋማ አሪሴፌ ንቶ አሩኒ ሜያ ‹እንኖ ዙታምኒሴ ሀኦሲ ናንጎታዋ› ይሴቴይስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«ኤሴ እንኖ ሀኦኒ ናንጎታ ስኒኔን ባር አሱኒ ቴችማክናዋ ዋርቄክና፥ ብርክ፥ ወደይ ሹአክ ዎሱስቴ ግቶ ዛግራ ሳፋሮንክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ኤሴ ሀኦሲ አሱኒ ሜያ ዜሞቲ ዳግን ነያሲክ ዛግሴቴ ባሮን ባክ ኣትራ ሀሽ ዳዳስ ፌ አሱ ዙቴሬ ሀርሙሶነክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ባር ኮርና አሱሲክ ካሞ ሀን ዳ ዙታምባሴ አሲስታ ፉቶክ ማጝሱ ካርአና ዎና ዱስ። ኤስ ባሮን ቤስናስ ኤስ ኮርና አሱስን ክቱኒ ካቡባሲክዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","«ክቱኒ ካቡ» ይፋ ካማሶን ኦደሴቴይሴ እሳ እሳይስ ካኘሴቴ። ስኑንታኖ ኦሚስ፦ «ሀን ቾዋሶን ሄፕሳ ኔኪን ኦዶንክ ሾሌፌንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ኤሴን ኦርፎ ጳዉሎስ ባሶ ጋነያስን ኬሴ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ስኑንታኖ እሳ እሳ አሱኒ ሜያ ጳዉሎስ ማኬና ቾዋሶን ኤጴቴሬ አማነሴቴ። አማነ ባሶስኒ አሪዮስፋጎስኒ ሾንጎታ ዲሴፌ ባሶ ድዮናስዩስ ይስቴ አሱናዋ ደማርስ ይስቴ እሳ ማሽካሱነ ደይ ኦም አሱኒ ሜያ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ኤሴን ኦርፎ ጳዉሎስ አቴናን ካብሬ ቆሮንጦስ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ኤስታክ ጳንቶሲክ አሱ ስና አቅላ ይስቴ እሳ አይሁድኒ ሜኒ አሱኒን ዳኒ። ባር ደይ፦ «አይሁድ ዙቴሬ ሮሙን ኬሶ» ይት ሮምኪ ታቴ ሜኒ ታቶ ቀላዉዶስ አጃጀና ቦርአ አሱባ ጵርስቅላኔን እጣልያን ዬናስ ታአ ዎናዋ። ኤስ ባሪ ቦርኣ ጳዉሎስ ባሶትን ሀሜ ዎል አሪ። ");
INSERT INTO jnje_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ባር ደይ ባሶስማቶ ዱርካኒ ዞርር ስንና ቦርአ ባሶኔን አነ ዲፋት ዎስቴት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ቤይሳኒ ቤይሳኒ ዎናሲክ አይሁድኒ ሺጶኒ ኬያስ ሀሚፋፌ አይሁድኒ ሜያክናዋ ግሪክኒ ሜያክና አማኖሶነክ ካቤት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ስላስናዋ ትሞትዮስና ሜቀዶኒያኒ ዬሴፌ ካባሲክ ጳዉሎስ፦ «የሱስ ባር ክርስቶስዋ» ይት አይሁድኒ ሜያክ ማእስሬ ዛላ ማኬት ዎናሲክቶኖን ኣትት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ስኑንታኖ አይሁድኒ ሜያ ባሪን ቱጋኤሴሬ ሜኤሴፌ ካባሲክ ማምባስ ቱሎኖን ቴብሬ፦ «ኤሴ ንቶ ሀንናስ ቴትንትስታዋ፤ ታ ኣፋ ማሙስቶናዉዛ። ሀንኔን ኤካሎ አዛብኒ ሜያክቱ ሀማናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ኤስታን ኬሴ ትቶስ እዮስጦስ ይስቴ አሱኒ ኬር ሀሚ። ኤስ አሱስ ሀኦሶን ሺጴት ፌር። ኬባስ ደይ አይሁድኒ ሺጶኒ ኬያስ ቴሻ። ");
INSERT INTO jnje_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ቀርስጶስ ይስቴ አይሁድኒ ሺጶኒ ኬያስ ጋኛ ደይ ባርኪ ኬርክ ሜያኔን ዙቴሬ ዳሚስን አማነሴቴ። ሾዎ ቆሮንጦሲክ አሱኒ ሜያ ደይ ጳዉሎስ ማኬፌን ኦደሴሬ አማነሬ ሀጱክቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ዳሚስ ደይ ዋልን ጳዉሎስኒን ራእክ ኡጰሬ ኤካ ይ፦ «ድጎታታዋ! ማኮዋ! ደይ ሻኩታታ! ");
INSERT INTO jnje_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ታ ነኔን አነቱ ፋዉጝዋ። ሀን ካታማስ ሾዎ አሱታ ፌርዋ። ኦኑ ስንፋናነ ነይስታ እሳ ሚርኦን ዉዛ ካቱክ ኣፋ ችማናዉዛ።» ");
INSERT INTO jnje_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ኤስታን ጳዉሎስ ሀኦሲ ካማኖን አሲት እሳ ዎጋነዋ እሱን አስሳነ ኤስታ ድ። ");
INSERT INTO jnje_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ጋልዮስ አካያኖን ሀእሱናክ ታቴፌና ካባሲክ አይሁድኒ ሜያ እሳር ስንነሬ ጳዉሎስኒስታ ካብሴቴ። ጳዉሎስኒን ኤጴ ማጝሱ ካቴፋና ሾንጎስታ ታሜፋት፦ ");
INSERT INTO jnje_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«ሀን አሱስ ቱማሶን ቱጋኦን ሁግናክ አሱኒ ሜያ ሀኦሶን ሺጵሶነክ ዛግት ፌርዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ጳዉሎስ ዎልጉባ ማኮናክ ሆሬፌና ካባሲክ ጋልዮስ አይሁድኒ ማያክ ኤካ ይ፦ «ንቶ አይሁድኒ ኬን ስና ሜያነ! ንቶስታ ሚርአ ወደይ ፋያ ማጝሱ ዛግቴ ስንፋናነ ማላትንትሶን ንብራ ኦዶና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ስኑንታኖ ሜርኬት ካምንትሲክናዋ፥ ሱንትሲክና ደይ ቱማኒትሲክናቱ ማላቴድፌት ስንናኔን ቴትንትስ ግሮዋ። ታ ሀን ባርስ ግርራ ማጝሱ ካርአናክ ኣነ ሾሌፋትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ኤካ ይሬ ማጝሱኒ ካርን ሾስታን ባሶትን ክስ። ");
INSERT INTO jnje_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ኤስ ካባሲክ አሱ ዙቴሬ አይሁድኒ ሺጶኒ ኬያስ ጋኛ ስና ሶስቴንሴንን ኤጴ ሾንጎስታ እቸሴቴ። ኤስ ባር ዙቴራ ስኒፋና ካባሲክ ጋልዮስ ኣነ ካሌ ሻክሬ ቢ። ");
INSERT INTO jnje_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ጳዉሎስ ሾዎ ዎና ቆሮንጦሱክ አይን ሜያኔን ዲናኔን ኦርፎ፦ «ማርኦን» እያት ሜርኬብስ ዲሬ ሶርያ ሀሚ። ጵርስቅላናዋ አቅላነ ደይ ባርኔን አነ ፌሴቴር። ጳዉሎስ ግባባ ፋና ቦርአ ኪንክሪያ ይስቴ ድማስታ ሶምባሶን ፊትቴ። ");
INSERT INTO jnje_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ኤፌሶን ካርኤፌ ካባሲክ ጵርስቅላንናዋ አቅላኖና ኤስታ ፎሶነክ ዛግ። ስኑንታኖ ባር አይሁድኒ ሺጶኒ ኬያስ ግሪሬ አይሁድኒ ሜያኔን ዎል ሌት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ሾዎ ዎና ባሶኔን አነ ፎናክ ሾልሴቴን ባር ኣነ ማእ ኡዌ። ");
INSERT INTO jnje_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ስኑንታኖ ባር፦ «ሀኦ እያናነ ሄፕሳ ዎላ ዮና» እያት ኤፌሶኑን ኬሴ ሜርኬብስ ዲሬ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ቅሳርያ ካርፋት የሩሳሌም ሀሜ አማኝኒ ሜያኖን ናጋ ኦሸፋት ዬት ዎል ሌ አንሶኪያ ኬሬ። ");
INSERT INTO jnje_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","አንሶኪያክ ጋሮ ዎና ድ። ኤሴን ኦርፎ ካብሬ ጋላትያነዋ ፍርግያነ አሲስ ኩትፋፌ አማኝኒ ሜያኖን ችሞነክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ኮኒቶባ እስኪንድሪያኪር ስና አጵሎስ ይስቴ አይሁድኒ ዳኒ አሱ ኤፌሶን የ። ባር ደይ ኮርቶ ማፃፋሶን ማእስሬ አሩ፤ ደይ ማአ ዎሉምኒ አሩባ ፌና አሱ። ");
INSERT INTO jnje_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ኤስ አሱስ ዳሚሳ ኡግናኖን ማእስሬ አሲት ደይ አያናሲክ ኪቼት የሱስኒ ቾዋሶን ማኬት ፌር። ስኑንታኖ ባር አሪፌናስ ዮሀኒስኒ ሀጵቁሶን ኮእባዋ ");
INSERT INTO jnje_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ባር ድጋባ ፎንቶኖን አይሁድኒ ሺጶኒ ኬያስ ኮቴ ማኮ ኤጲ። ስኑንታኖ ጵርሲክላናዋ አቅላነ ኦደሴቴይሴ ኬቤስ ኤጴ ታሜ ሀኦሲ ኡግናኖን ማእስሬ ኮቴ ባርኪ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","አጵሎስ አካያ ሀማናክ ሳፋሬፌና ካባሲክ አይን ሜያ ደይ ኤስ ባሳ ሳፋራሶን ችኒሴሬ አካያክ ፌ አይን ሜያ ማአሪክ ባሪን ኤጴቶሶነክ ትቻ ትችሬ እሜቴ። ኤስታ ሀሜ ሀኦሲ ኦትማክ አማኝ ስንነ ፌ ባሶትን አካማኖን አሪጋስ። ");
INSERT INTO jnje_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","የሱስ ባር ክርስቶስ ስኒባሶን ኮርቶ ማፃፋሲኒ ክስሬ ማኬፋፌ አካማ ዌኢኑክ አይሁድኒ ሜያኖን ማኬሬ ሜሬት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","አጵሎስ ቆሮንጦሱክ ፌና ካባሲክ ጳዉሎስ ቱካክ ዳስታክ ካሞ አቴ ኤፌሶን ሀሜ ካርእ። ኤስታክ ፋድቤስ ጋሮ አማኝኒ ሜያኖን ዳንነ፦ ");
INSERT INTO jnje_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«አማነፌት ካባሲክ ኮርቶ አያናሶን ኤጳ ታሴትዮሶ?» ይት ማምሲ። ባሶ ደይ፦ «ኣነ ኤጳቶዌንዋ። ኮርቶ አያናስ ፎባሶንኑ ኣነ ኦዶዌኒዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ጳዉሎስ ደይ፦ «ኤካኒ አሮ ሀጱቅቶኒሶን ሀጱቅቴትሪ?» ይ። ባሶ ደይ፦ «ዮሀኒስኒ ሀጱቅቶሶጝዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ጳዉሎስ ደይ፦ «ዮሀኒስኒ ሀጵቁስ ቦርን ሀርምንርዋ። ዳራሲክ ደይ ማኬናስ፦ ‹ታ ኦርፎሴ ዮን ባርኪ አማኖት› ይት ፌር። ኤስ ባር ደይ የሱስዋ!» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ኤስ ባሮን ኦደሴቴይሴ ዳም የሱስኒ ሱናሲክ ሀጱክቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ጳዉሎስ ኩሹባሶን ባሶስታ ታእፌና ካባሲክ ኮርቶ አያናስ ባሶስታ ኬሬን ጋድዶ ኖኖ ዎሉምሴሴቴ። ራጅ ደይ ማኮ ኤጴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ኤስ አሱኒ ሜኒ ፋዳስ ደይ አሲሬ ሄፔ ስናና። ");
INSERT INTO jnje_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ጳዉሎስ አይሁድኒ ሺጶኒ ኬያስ ሀሜ ኬዝ አሳ ስኒሮን ድጋባ ፎንቶኖን ሀኦሲ ታቶኒ ቾዋኖን ማኬትናዋ አሲትና ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ስኑንታኖ እሳ እሳ ሜያ ንቤሲሶን ካለሬ ዳሚሳ ኡግናኖን ዳራሳ ስና ሜኤት ኣፋዋ አማኖኒዉዛ ይሴፌ ካባሲክ ባሶስታን ዎክ። አማኝ ሜያኖን ደይ ባሶ ባሶትን ኦር ክስሬ ጥራኖስኒ ኬርክ አሱኒ ኬያስ ዎንና ዎንና አሲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ጳዉሎስ ኤስ ባሮን ዛግናስ ሄፕ ዎግጋ ስናና። ኤስ ካባሲክ ኢስያክ ፌሴ አይሁድኒ ሜናዋ አዛብኒ ሜና ዙቴሬ ዳሚሳ ካማኖን ኦዶሶነክ ችሜሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ሀኦሲ ጳዉሎስኒኪ ካሞ አካማ ቢስቴራ አሪቶኖይ ዉዛ ዛግት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","አቱባስ ታእና ማማሴዋ ኩሹኒ ማራብባሴ አሲን ኤጴ ታሜ ሜታን ሜያስታ ኩኑሴቴን ሜታን ሜያ ሜሮቤሲስኒ ፋርት ፌሴቴር። ኪና አያናስ ደይ አሱሳስኒ ኬሴት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ኪና አያናሶን አሱሳስኒ ክሴት ኩትሴ እሳ እሳ አይሁድኒ ሜያ፦ «ጳዉሎስ ማኬፌና ዳም የሱስኒ ሱናሲክ ንቶትን አጃጀፌን» ኡክ ኪና አያናሶን አሱሳስኒ ክሱክ ካቤት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","አይሁድ ስና ማግኒ ጋኛአሳስኒ እሳ አስቀዋኒ ናፉን ናንጎትስ ደይ ኤሲስማቶ ዛግሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ስኑንታኖ ኪና አያናስ ዎልግራ፦ «የሱስኒን አሪፋኒ፤ ጳዉሎስኒን ቾዋሶን አሪፋኒ፤ ንቶ ኦንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ኪና አያናስ ኤጵና አሱስ ደይ ፍልለሬ ባሶትን ኤጴ ባሶስታ ችም ደይ ሜሬ። ማዛየሬናዋ አታቱና ኬሩን ኤልለ ኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ኤስ ዉዛስ ደይ ኤፌሶኑክ ፌሴ አይሁድናዋ አዛብኒ ሜና አሲክ አሪቴና ቦርአ ዙታምቤሲሴ ድጌሴቴ። ዳም የሱስኒ ሱናስ አካማኖን ኡልፍንቶ ስኒ። ");
INSERT INTO jnje_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","አማነ ባሶስኒ ደይ ሾዎ አሱ ማጙ ዎስቶቤሲሶን አምማኖን ክስሬ ሀርምፋፌ ዬሴት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ሾዎ ቶልፋቱን ሜያ ደይ ቶልፋትን ማፃፋቤሲሶን ዙትሬ ዳራ ዙታምቤሲሴ አሲ ስና ኪችሴቴ። ኤስ ቶልፋትን ማፃፋሲ ዋጋ ደይ ጋሚማትቴን ኡቻስር ኩማ ሹኢን ብር ስኒ። ");
INSERT INTO jnje_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ኤሲስማቶ ዳሚሳ ካማ አካማ ሁግናክ ታግትናዋ ሜሬትና ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ኤስ ባር ዙቴራ ስንናኔን ኦርፎ ጳዉሎስ ሜቀዶንያነዋ አካያነ አሲስ አቴ የሩሳሌም ሀማናክ አያናባስ ሳፋሬፋት፦ «ኤስታ ካርኤቴኔን ኦርፎ ሮም ሀማክቱ ሾልሱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ኤስታን ባሪን አሪጋሴፌ ባሶስኒ ሄፕን ትሞትዮስናዋ ኤራስጦስኒና አሲን ሜቀዶንያ ዎሳት ባር ቴትባሲክ ጋሮ ዎና ኢስያክ ድ። ");
INSERT INTO jnje_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ኤስ ካባሲክ ዳሚሳ ኡጉንታን ካብ ቾዋ ኤፌሶኑክ ናጋ ትሽ። ");
INSERT INTO jnje_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ድሜጥሮስ ይስቴ ብር ዉክፌ አሱስ አሪጠምስኒ ቤቴሜቅደሲሲ ግቶ ብርክ ዎስቴፋፌ ብር ዉክፌ ባሶክ አካማ ቡአ ዳኖነክ ዛግት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ኤስ ባሪ ቦርኣ ኤስ አሱስ ብር ዉክፌ ባሶትናዋ ባሳስንነ ፋ ዎስቶቤስ ፋና ባሶትና እሳ ድማ ዙትሬ ኤካ ይ፦ «አሱኒ ሜያነ! እንኖ ኦትማ ዳንፌኒስ ሀን ዎስቶሲክ ስንናማቶ አሪፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ሀን ጳዉሎስ፦ ‹ኩሹክ ዎሱስቴ ግቶስ ባር ሀኦታዋ› ይ ኤፌሶኑክ ኮእባ ስኖይናሮን ጋሮ ዳቱ ፉእቴታኖ ኢስያኖን ዙታምባሴ አሲን ሾዎ ዳራኒን አሲናማቶናዋ አማኖሶነክ ዛግናማቶና ንቶ ቢት ደይ ኦደትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ኤስ ኤፋቴና ኡግናሲክ እንኖ ዎስቶስ ካሽስቴርዋ። ኤስ ባር ኮእባ ስኖይናሮን ኢስያነዋ ዳ ዙታምባሴ አሲስ ፌ አሱ ዙቴሬ ሺጴፌና አሪክ ሀኦ አሪጠምስኒ ቤቴሜቅደሲሲ ኬእኖር ስንና ፉቶባዋ። ባር አሪክቶስ ደይ ሻርቴርዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","አሱኒ ሜያ ደይ ኤስ ባሮን ኦደሴቴይሴ ግኢቴሴሬ፦ «ኤፌሶንክ አሪጠምስ አሪክቶዋ» ይት ቻጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ካታማስ ዙቴራ ናጋ ቱርክ። ሜቀዶንያክ አሱኒ ሜያ ደይ ሄፕ ጳዉሎስኒ ዞሞ ስና ጋይዮስናዋ አሪስትሮኮስና አሲን ዛቴሬ ዳራሳ ዙቶኒ ድማስታ ኤለቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ጳዉሎስ ዳራሳ ዙቶታ ሀማናክ ሾሌት ፌር። ስኑንታኖ ናዎኒ ሜያ ካለሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ኢስያኒ ዳሶን ሀእሲፌ ባሳ ዞሞ ስና ባሶስኒ እሳ እሳይስ ጳዉሎስኒክ ኣቾክ አሱኒን ዎስሬ፦ «ዳራሳ ዙቶኒ ድምታ ሀማ አምማኖን ኬሳ ቤስቶታታዋ» ይት ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ዳራሳ ጋነሲ አካማ ቡንቾ ካብና ቦርአ አሪክ ስናስ አዉኒሮን ዙቴናማቶ ኣነ አሩዌ። ኤስ ባሪ ቦርኣ እሳይስ እሳ ዉዛ ኦሚስ ደይ ኦማ ዉዛ ማኬት ቻጌት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","አይሁድኒ ሜያስን እስኪንድር ይስቴ አሱስን ቱግሬ ቴሾ ዳራሳ ስና ዬትሴቴ። ዳራሳ ጋነስን እሳ እሳይስ ማእስሬ ዌኑናክ ችኒሬ ኪትሴቴ። ባር ደይ ዳራስ ሻኩናክ ኩሹባሲክ ቤስሬ ባሶክ ዎሎናክ ሆሬ። ");
INSERT INTO jnje_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ስኑንታኖ ባር አይሁድኒ ሜኒ ኬን ስኒባሶን አሪሴቴይሴ ዙቴሬ እሳ ካማክ፦ «ኤፌሶንክ አሪጠምስ አሪክቶዋ» ይት ሄፕ ሳአት ስኒሮን ቻጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ኮእባስታክ ካታማስ ሀእሱኒ ትቻሶን ትችፌ ባር ዳራስ ሻኩናክ ዛጋት፦ «ንቶ ኤፌሶን አሱኒ ሜያነ! ኤፌሶን ካታማስ ፌ ዳራስ አሪክቶ አሪጠምስኒ ቤቴሜቅደሲሴዋ ሳማን ኬሬ እኛ ሹኣሴ አሲን ኦድፌናማቶ አሱ ዙታምባሴ አሲክ አሪቶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ኤስ ባሮን ሞርሞንር ኦኑ ኣፌ ስንና ቦርአ ሻኩትክናዋ ታፕቴራ እሳ ማጙ ዉዛ ዛጉኖይትማቶ ቴትንትሶን ኦዳትክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ቤቴሜቅደሲሶን ቦኦክናዋ ሀኦኒሶን ሜእኖይ አሱኒ ሜያኖን ኤጳ ሀንታ ያሴትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ድሜጥሮስናዋ ባርኔን አነ ፌሴ ብር ዉክፌ ባሶትና ማላቶሶነ አሱ ፌፋናነ ማጝሱ ካቶና ዎናስ ፋርዋ። ዳሶን ሀእሲፌ ባሶ ፌሴቴር ስንና ቦርአ ኤስታክ ማላሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ኦማ ሾሌፌእ ዉዛ ፋፋናነ ቱማስ ሾንጎን ዙቶታ ቢስቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ሀኒስታን ኦማ ሀውጙት ዛግሴት ዉዛስ፦ ‹ፋሶ ካብጝዋ› ይስቴራ ማሙስቶኖይንማቶ ድጌንዋ። ወደይ ‹ሀን ካብ ፋሶስ አዉኒ ቦርአ ካብሶ?› ይስቴራ ማሙስቴፋንነ ዎልጉኒ ማልስ ኣፋዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ኤስ ባሮን ማኬፋት ዙቴሬ ፌ ዳራስን ቦክቶሶነክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ናጋን ትሹስ ኮቸናኔን ኦርፎ ጳዉሎስ አማኝኒ ሜያኖን እሳሪክ ዙትሬ ኪትሬ ችናት፦ «ማኣርኦኒ ዱት» እያት ባሶስታን ኦር ኬሴ ሜቀዶንያ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ኤስ ኣትፌና ድማ ድማስ አማኝኒ ሜያኖን ሾዎ ኪቶ ኪትሬ ችኒናኔን ኦርፎ ግሪክኒ ዳ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ኤስታ ኬዝ አሳ ዲናኔን ኦርፎ ሜርኬብ ዲሬ ሶርያ ሀማናክ ሳፋሬ። ስኑንታኖ አይሁድኒ ሜያ ባሳስታ ቾዋ ሾልሴቴማቶ አሪናይሴ ሜቀዶንያ ካሞ ዎል ሌ ዮናክ ሆሬሬ ካቢ። ");
INSERT INTO jnje_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ፓይሮስኒ ና ቤርያክ ሱስጳጥሮስ ቴሴሎንቀክ አሪስትሮኮስናዋ ስኮኒዱስና ደርቤኒክ ጋይዮስ፥ ትሞትዮስ፥ ኢስያክ ጥቂቆስናዋ ትሮፌሞስና አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ኤስ ባሶ ስና ዜምሜ ሀሜፋት ጥሮአዳክ እኖትን ኦደሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ስኑንታኖ እንኖ ክጣኒ ሄቦስ ኣትናኔን ኦርፎ ፍልጲስዩሱኒ ሜርኬብ ዲራ ኡች ዎናክ ባሶ ፌሴቴ ጥሮአዳ ካርአ ኤስታ ናፉን ዎና ዲን። ");
INSERT INTO jnje_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ጉድዳኒ ዎኖ እሳሪክ ዳሚሳ ሜታኡኖን ሙንክ ዙቴራ ዲፌን ካባሲክ ጳዉሎስ ዎኖትርክ ሀማናክ ሾልሱ ስንና ቦርአ ባሶኔን ዎል ሌት ፌር። ዋሲ ዳኒ ኪጤ ካርአናኔን ዎሉምባሶን ድች። ");
INSERT INTO jnje_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","እንኖ ዙቴራ ፋኒ ፎቂስ ሾዎ ቶና ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","አዉጠክስ ይስቴ እሳ ናኦ ና ማስኮትስታ ዲፌሪ?፥ ጳዉሎስ ዎሉምባሶን ድችና ቦርአ ኤስ ናኦ ናስን አካማ አፋይ ኤጳን ፎቂስታን ጋንደ። አሱኒ ሜያ ደይ ክትሬ ኩንፌን ካቡግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ስኑንታኖ ጳዉሎስ ኬሬሬ ናስን ሙግሬ እድምፋት፦ «ካባ ፋርዋ ድጎትታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ጳዉሎስ ዎል ሌ ደን ፎቂስታ ኬሴ አማኝኒ ሜያኔን ዳሚሳ ሜታኡኖን ባቴ ሜ። ዎናና ካባኔን አሱኒ ሜያኔን ዎል ሌናኔን ኦርፎ ካብሬ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","አሱኒ ሜያ ደይ ፋር ናስን ኤጴ ኬር ሀሜቴ። ኤስ ባርኪ ደይ አካማኖን ግሬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","እንኖ ጳዉሎስኒን ሜርኬብስ ዱሱኒክ ሾሌን ቦርአ ዜምማ ሜርኬብ ዲራ ኣሶን ሀሚን። ኤስ ባሮን ደይ ዛግኒስ ጳዉሎስ ዎቾክ ሀማናክ ሾሌና ቦርአ። ");
INSERT INTO jnje_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ኣሶኑክ ኡጰፌን ካባሲክ ሜርኬብስ ዱናክ ዛግራ ምጥልን ባርኔን አነ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ዎኖትር ዎኖ ካብራ ሜርኬብስ ዲራ ክዩንኒ ስናስታ ፋ ድማስታ ካርን። ዎኖትር ዎኖ ሳሞን ፍና ዎኖትር ዎኖ ምልጥ ካርን። ");
INSERT INTO jnje_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ጳዉሎስ ኢስያክ ሾዎ ዎና ዱክ ኣኔ ሾሎዌ ስንና ቦርአ ኤፌሶን ሻቶኖይ አቴ ሀሚ። ኤስ ባሮን ዛግናስ ፐንጠኮስቴኒ ሄቦሲክ የሩሳሌም ሀሜ ኣቱናክ ሾሌት ፌር ስንና ቦርአ። ");
INSERT INTO jnje_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ጳዉሎስ ምልጥኑን አሱኒን ኤፌሶን ዎስሬ ቤቴክርስታንን ኩርኡኒ ሜያኖን ቴግስ። ");
INSERT INTO jnje_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ባርኪ ዬሴቴን ኤካ ይ፦ «ሀን ኢስያ ያና ዎናኔን ዎንና ዎንና ንቶኔን አነ ኣካክ ኣትናማቶ ንቶ ቴትንትሲክ አሪፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","አይሁድኒ ሜኒ ቾዉኒ ሾሎስታን ካብ ቾዋ ሻና ታይስታ ካትሴፌክኑ ፉቶኒ ጋራማክናዋ ሀራፋክና ዳሚሲክ ዎስቴት ፋናርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ያቦስታ ስኑን ንቶ ኬንት ኬንትስ ንቶክ ሾልስፋይሶን ዙትራቱ አሲንታኖ እሳ ዉዛነ ማኮኖይ ኣነ ፉኦትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","አይሁድኒ ሜናዋ አዛብኒ ሜና ቦርቤሲሶን ሀርምሬ ሀኦሲክ ዎልሶነክናዋ ዳምኒ የሱስኒን አማኖሶነክና ማእስራ ባሶክ ማኬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ሀሽኑ ታ ኤስታ ሀሚፋና ካባሲክ አዉ ታይስታ ካርኒቶ አሩኖይ ኮርቶ አያናክ አጃቼራ የሩሳሌም ሀሚናርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ስኑንታኖ ካታማ ካታማስ ታቶነዋ ራኮነ ታይስታ ካርአና ባሮን ኮርቶ አያናስ ታክ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ሀኦሲ ኦቱምኒ ምስራቹኒ ካማኖን ማኮናክ ዳም የሱስኒኪን ኤጵና ባርኪ ዎስቶኒ ግዲሶን ኮእሳናነ ካናስ ታክ ኬኒር ይራ ኣፋዋ ፋዱና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ሀሽ ሀውጙኔን ካርአ ንቶ ጋነያስ ኩትፋፋ ሀኦሲ ታቶኒ ካማኖን ማኬቱ ፋዉጝዋ። ስኑንታኖ ሀንኔን ኤካሎክ ኦኑ ታን ኣፋ ብያና ዉዛ ስንናማቶ አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ኤስ ባሪ ቦርኣ ንቶስኒ እሳር ትሽፌናክኑ ታ ኣፋ ማሙስቶናዉዛ ይት ሀሽ ሀውጙት ዎናስታ ንቶክ ማኬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ሀኦሲ ፍቃድኖን ዙትራቱ ንቶክ ማኬንታኖ እሳ ፉኤና ዉዛ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ንቶትን ቤቴክርስታንን ኩርኡ ዛግራ ኮርቶ አያናስ ኮሪ። ኤሴ ንቶ ቴታሲክናዋ ኬምፌት ዎዶሲክና ቴትንትሶን አሩትዋ። ሀኦሲ ባር ናሳ ሀንናክ ዋጌና ቤቴክርስታኒሶን ማእስራ ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ታ ሀሚናኔን ኦርፎ ዎዶሲክ ኬናሽቶኖይ ኬና ቡዱ እሪርካስነ ፌ አሱኒ ሜያ ዮሶነማቶ አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ኤሲስማቶ እሳ እሳ አሱኒ ሜያ ንቶ ጋነያስን ካብሴሬ ኤልጝአ አስሱ አስሲሬ አማኝኒ ሜያኖን ባሶኪ ዎልጉሶነርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ኤስ ባሪ ቦርኣ እሳ እሳርኒትሲክ ኬዝ ዎግጋ ቶነዋ ዋልነ አራፍናሶን ዉክት ንቶትን ኪትናማቶ ያዳቴፋት ጉዙት። ");
INSERT INTO jnje_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ሀሽኑ ኮርቶኒ ሜያኔን አነ ርስት ንቶክ እማናክ ችምኒ ሀኦስክናዋ ኦቱምባስ ካማክ ንቶትን ችኒራ ዬቱን ባርኪ ንቶትን ኣትራ አዳራ እምጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ታ ኦኒክኑ ብር፥ ዋርቄ ወደይ ማማ ኤጳቶናክ ኣነ ፋንቶት። ");
INSERT INTO jnje_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ኩሹናሲክ ዎስቶ ዎስቴፋት ታክናዋ ታኔን ፌ ዞሞታሳክቶኒና አሪጋስት ፋናማቶ ንቶ አሪድፌት። ");
INSERT INTO jnje_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‹ኤጴቴሴፌ ባሳስታን እምፌ ባር ሱስቶዋ› ይፋ ዳም የሱስኒ ካማኖን ሳፋሮክ ኩሹኒሲክ ዎስቴት ሆፕን ሜያኖን አሪጋሱኒክ ሾልሱ ስንናማቶ ሾዎ ኡግናክ ንቶክ ቤስፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ኤስ ባሮን እያት ካአነሬ ባሶኔን ሺጴ። ");
INSERT INTO jnje_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ዙቴሬ አካማኖን ዋሴሬ ጳዉሎስኒን እድሜ ዳሜሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","አሪክሮን ሱሞሶነክ ዛግስ «ሀንኔን ኤካሎ ታን ኣፋ ብያት ዉዛ» ይና ቦርአ። ኤስታን ሜርኬብ ዲስቴፋና ድማስታ ዞንስሬ ጌጌስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ባሶስታን ኦር ኬሴ ሀሚንኔን ኦርፎ ሜርኬብስ ዲራ ቆስ ይስቴ ድምታ ሀሚን፤ ዎኖትርክ ሩድ ይስቴ ድምታ ሀሚን፤ ኤስታን ፓጥራ ይስቴፋ ካታማስ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ኤስታን ፊንቀ ስኒፋ ዳ ሀማ ሜርኬብ ዳና ባርስ ዲራ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ኮጲሮስኖን አልዳ ቴሽኒስታ ብያት ሶርያ ሀማ ሜርኬቢስ ዎርና ባኣሶን ኬስፋና ጥሮሲክ ዎደቢሲክ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ኤስታክ አማኝኒ ሜያኖን ሾሌራ ዳና ናፉን ዎና ዲን። ባሶ ደይ ኮርቶ አያናክ ቱንቴሴሬ ፓዉሎኒን፦ «የሩሳሌም ሀማታታዋ» ይት ማኬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ኤስታክ ፎኒ ዎናስ ኮኡባሴ አማኝኒ ሜያስታን ኦር ኬሳ ኡጉኒሶን ሀሚን። ዙታምቤሲሴ አሱቤሲሴኔን ናንጎትቤስሴኔን ኬሴሬ ካታማስ ጌራካሎ ካርአናኔን እኖትን ጌጌስሴቴ። ባርስ ቴሻ ካአነራ ባሶኔን አነ ሺጴን። ");
INSERT INTO jnje_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ኤስታን ባሶትን ማርኦን እያት እንኖ ሜርኬቢስ ግርራ ዲን። ባሶ ደይ ዎል ሌ ኬቤስ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","እንኖ ጥሮሱን ካብራ ፐንቴለማይስ ካርን። ኤስታክ አማኝኒ ሜያኔን ኡጰራ ናጋ ኦሸፋት ባሶኔን አነ እሳ ዎና ፌሽን። ");
INSERT INTO jnje_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ዎኖትር ዎኖ ኤስታን ኬሳ ቅሳርያ ሀሚን። ኤስታክ ናፉን ዳቆኝሳስን እሳር ስና ፍልጶስ ይስቴፌ ዎጌላዊሳ ኬር ግርራ ባርኔን አነ ዲን። ");
INSERT INTO jnje_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ባርኪ ኬር ራጅ ማክሴፋ አቼች ዱርባ ናንጎትባ ፋሴር። ");
INSERT INTO jnje_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ሾዎ ዎና ኤስታ ዲፌን አጋቦስ ይስቴ ራጁ ዩዳኒ እኖክ የ። ");
INSERT INTO jnje_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ኤስ ራጁኡስ እኖክ ዬሬ ጳዉሎስኒ ታልፋሶን ኤጴ ባሳ ቴትን ኩሹሶናዋ ዎቾሶንና ታርኣት፦ «ኮርቶ አያናስ ሀን ታልፋስ አባንን የሩሳለሙክ ፌሴ አይሁድኒ ሜያ ሀኒሲማቶ ታርኤሬ አዛብኒ ሜያክ ኣትሬ እሞነርዋ ይፋዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ኤስ ባሮን ኦደኒሴ እኖትንናዋ ኤስታ ፌሴ ባሶትና ጳዉሎስ የሩሳሌም ሀሚኖይናማቶ ሺጴን። ");
INSERT INTO jnje_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ስኑንታኖ ጳዉሎስ ዎልግሬ፦ «ኤካ ዋሲራ አዉኒሮን ንብናሶን ሾርክፌትሶ? ታ ዳም የሱስኒ ሱናሲክ የሩሳለሙክ ታቶ ኮእባ ስኖይናሮን ክቱኑ ስንፋናነ ሆሬራቱ ፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ኪትን ኪቶሶን ኤጴቶ ቤይባሴ፦ «ኤሴ ዳሚስ ይና ባር ስኑጝዋ» እያት ቤይን። ");
INSERT INTO jnje_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ኤስታክ ጋሮ ዎና ዲኒኔን ኦርፎ ባአኒሶን ታርአ ሆስራ የሩሳሌም ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ቅሳርያክ ፌሴ አማኝኒ ሜያስን እሳ እሳይስ እኖኔን አነ ዬሴቴ። ባሶ ደይ ባርኪ ኬር ቤይሳ ኤጳንክ ምናሶን ኬር እኖትን ዞንሲሴቴ። ባር ደይ ዜምሜ አማነሬ ፌ ኮጲሮሲክ አሱሳስኒ እሳይስ። ");
INSERT INTO jnje_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ሀማ የሩሳሌም ካርፌን ካባሲክ አማኝኒ ሜያ እኖትን ግራክ ኤጴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ዎኖትር ዎኖ ጳዉሎስ እኖኔን አነ ያቆብንክ ኬር ሀሚ። ኤስታክ ደይ ኩርኡኒ ሜያ ዙቴሬ ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ጳዉሎስ ደይ ናጋ ኦሸናኔን ኦርፎ ሀኦሲ ባርኪ ካሞ አዛብኒ ሜኒ ጋነያስ ዛግና ዉዛሶን እሳርባ እሳርባሲክ ባሶክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ኤስ ባሮን ኦደሴቴይሴ ሀኦሶን ጋላቴሴቴ። ጳዉሎስኒን ደይ ኤካ ይሴቴ፦ «አይኒሶ! ሾዎ ኩማክ ፋድቶኒ አይሁድኒ ሜያ አማነሴቴማቶናዋ ዙታምቤሲሴ ደይ ሙሴኒ ቱማሲክ ማአ ኮናቤስ ፋናማቶ አሪፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ነ አዛብኒ ሜኒ ጋነያስ ፌሴ አይሁድኒ ሜያኖን፦ ‹ናንጎትኒትሶን ሃርኮ ኩንሱትታ ወደይ ቱማሶን ዛጉትታ› ይት አሱኔሲክ ሙሴኒ ቱማሶን ዛግሶቤዮነክ ዛግታርዋ ይስቴት ፋ ዎላሶን ኦደሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ኤሴ አዉ ዛግፋንነ ማአሪ? ነ ዮሶን ፉቶሲክ ኦደሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ኤስ ባሪ ቦርኣ ሀን እንኖ ኔክ ማኬፌን ባሮን ዛጉዋ። ግባቤስ ፋና አቼች አሱ እኖኔን አነ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ባሶትን ኤጳ ቤቴሜቅደስ ሀምፋት ቴትኔሶን ካይምሱዋ። ሶምቤሲሶን ደይ ፊቶሶነክ ቤቴሜቅደሲሲክ እምቴፋ እምን ዋጋሶን ባሶክ ካሱዋ። ኤስ ባሮን ዛጋታነ ነይስታ ዎሉምቴ ዎላስ ዙቴራ ሽማ ስኒባሴዋ ነኑ ቴትኔሲክ ደይ ቱማሲክ አጃጃሜ አሱ ስኒታማቶ ዙታምባሴ አሩናዋ። ");
INSERT INTO jnje_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ስኑንታኖ አዛብኒ ሜያስን አማነ ባሶክ፦ ‹ኮሎሲክ ማአ እምቴ ኪና ሙሶን ሙትታ፥ ሀንናሶን ሙትታ፥ ጌቴራ ክት ዋጋስ አሻኖን ሙትታ፥ ጌርኬሳስን ዎክት› ይፋ ትቻሶን ዎል ሌራ ቡግራ ባሶክ ጋፍኪንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ኤሴን ኦርፎ ጳዉሎስ አሱኒ ሜያኖን ኤጴ ዎኖትርክ ባሶኔን አነ ቴትባሶን ካይምስ፤ ካይምሶነ ዎናስ ኣጌ ስናናማቶናዋ ኤስ ዎኖ እሳ እሳርቤሲሳ ቴታክ እምቴፋ ግባኒ ማኣስ ዋጋ ኣጌ ካስቶናማቶ ያዳሱክ ቤቴሜቅደሲሲ ግር። ");
INSERT INTO jnje_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ናፉንሳ ዎናስ ኮኡናክ ካርፋና ካባሲክ ኢስያኒ ዬሴ አይሁድኒ ሜያ ጳዉሎስኒን ቤቴሜቅደሲሲ ብየቴ ቦርአ ዳራስን ዙትሬ ባሳስታ ካብግሴሬ ኤጴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«እስራኤልኒ አሱኒ ሜያነ!፥ እኖትን አሪጋሱትዋ፥ ዳራኒስንናዋ ቱማኒሶና፥ ደይ ዳ ዳስ ፌ አሱ ዙታምባሴ አሲን አሲት ፌይስ ሀን አሱስዋ። ኤስ ባር ባርኪኑ ቤይኖይ አዛብኒ ሜያኖን ቤቴሜቅደሲሲ ጌድፋፌ ሀን ካይማ ድማሶን ኪንስዋ» ይት ቻጌሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ኤስ ባሮን ማኬሴቴስ ዜሞ ስናክ ኤፌሶንክ ትሮፌሞስ ባርኔን አነ ካታማስ ኩትፌን ብየቴ ቦርአ ባሪን ጳዉሎስ ቤቴሜቅደሲሲ ኤጴ ግርነ ፋር ስንና ባሶክ ቤስቴራ ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ካታማስ ዙቴራ ናጋ ቱርክ። ዳራ ደይ ዙቴሬ እሳሪክ ኤልለ ዬሬ ጳዉሎስኒን ኤጴ ዛቴ ቤቴሜቅደሲሲኒ ክሴቴ። ጌሬጌሬ ቤቴሜቅደሲሲ ጋማላኖን ኩሉፍቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","አሱኒ ሜያ ጳዉሎስኒን ዎሩክ ሾልሴፌ ካባሲክ፦ «የሩሳሌምኒ ካታማ ዙታምባሴ አሲስ ናጋ ትሽዋ» ይፋ ዎስያስ ሮማኒ ሜያ ታርኦን ሜያኖን አጃጀፌ ጋኝኛስክ ሀማ ካርእ። ");
INSERT INTO jnje_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ኤስታን ባር ሜያ ታርኦሳክቶኒናዋ ት ሜኒ ጋኝኛክቶኒና ኤጴ ኤለት ሀሜ ካርእ። አሱኒ ሜያ ደይ ሜያ ታርኦን ሜያኖን አጃጀፌ ጋኝኛስንናዋ ሜያ ታርኦን ሜያኖና ብየቴይሴ ጳዉሎስኒን እቻሶን ቤየቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ኤስ ካባሲክ ሜያ ታርኦን ሜያኖን አጃጀፌ ጋኝኛስ ታእሴሬ ኤጴ ጳዉሎስኒን ሄፕ ሻሻራክ ታቶናክ አጃጀ። ኤሴን ኦርፎ ባር ኦ ስንናማቶናዋ አዉ ዛግናማቶና ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ዳራኒ ሜያ ደይ እሳ እሳይስ እሳ ዉዛ ይስቴን ኦሚስ ደይ ኦማ ዉዛ ማኬት ቻጌት ፌሴቴር። ሜያ ታርኦን ሜያኖን አጃጀፌ ባር ዳራሳ ቻጋታን ካብ ቾዋ ፉቶ ስና ዉዛሶን አሩናክ ኣነ ችሜ ስንና ቦርአ ጳዉሎስኒን ሜያ ታርኦን ሜኒ ኬኤ ኤጴ ሀሞነክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ጳዉሎስ ጌፋስታ ካርፌና ካባሲክ ዳራስ ዙቴሬ አካማ ግእአክ ካብሴሬ ባሪን ሚርኦን ዉዛ ባሳስታ ካቱሶነክ ፌሴቴር ስንና ቦርአ ሜያ ታርኦሳክቶ ባሪን ዎርኤ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ዳራስ ደይ፦ «ዎርቶዎዋ» ይት ኦርፎሴ ቻጌት ባርኔን አነ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ሜያ ታርኦሳክቶ ባሪን ኤጴ ሀሜሬ ፌሴፌ ድማስታ ካርኤፌ ካባሲክ ጳዉሎስ ሜያ ታርኦን ሜያኖን አጃጀፌ ጋኝኛስን፦ «ታ እሳ ዉዛ ኔክ ማኮናክ ማእ ኡታሮሶ?» ይ። አጃጀፌ ጋኝኛስ ደይ፦ «ግሪክኒ ኖኖ አሪፋቶሶ? ");
INSERT INTO jnje_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ኤካኒ ዜሞ ስናክ ዳራ ኑሩናክ ዛግሬ ካ ዎር አቼች ኩም አሱኒ ሜያኖን ኤጴ ዛቦ ሀማ ግጵጽኒ አሱስ ነቴኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ጳዉሎስ ደይ፦ «ታ ክልቅያ ፋ አርቶ ቴርሴስኒ ካታማስን ኮንቴ አይሁዳዊዋ። አዳራዋ ዳራሲክ ማኮናክ ማእ ኡታክ ማምሲፋዉጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ባር ደይ ማኮዋ ኡባሴ ጳዉሎስ ጌፋስታ የሬፋት ኩሹባሶን ካብግሬ ዳራስ ሻኩናክ ዛግ። ዳራስ ደይ ሻክ። ጳዉሎስ እብራይስትን ኖኖክ ኤካ ይት ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«ንቶ አይታሳክቶናዋ አባታሳክቶና! ሀሽ ንቶክ ማኮና ዎልጉኒ ዎሉምናሶን ኦዶትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","እብራይስትን ኖኖክ ማኬፌን ኦደሴቴይሴ አካማኖን ሻክሴቴ። ኤስታን ጳዉሎስ ደይ ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«ታ ክልቅያክ ፋ ቴርሴሲክ ካታማስን ኮንቴ አይሁዳዊዋ፤ ስኑንታኖ ድችናስ ሀን የሩሳሌምኒ ካታማስዋ፤ ታን አሲስ ጋማልያ ስኒፌ አሱስዋ፤ አባን ሜኒ ቱማሶን ማእስራ አሪራ ደይ ሀን ንቶ ዛግፌትስማቶ ሀሽኑ ሀኦሲክ አካማኖን ኮነ አሱዋ። ");
INSERT INTO jnje_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ሀን ኡግናሲክ ዞኑስቴፌ ባሶትን ክቱታ ካርኦነ ካኣብግት ፋናር። ኣርቃስንናዋ ማሽካሶና ታኣርታፋ ኣትራ ታቶኒ ኬር እሜት ፋናር። ");
INSERT INTO jnje_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ኤስ ባር ፉቶ ስኒባሶን ማግኒ ጋኝኜ ሜኒ ጋኝኛስናዋ ኩርኡኒ ሜኒ ሾንጎሴ ታክ ዛልዋ። ኤሲስማቶ ደይ ደማስኮክ ፌሴ ሀን አሱኒ ሜያኖን ታርአ የሩሳሌም ቴሸራ ኬኦ ዳኖነክ ደማስኮክ ፌሴ አይሁድ ስና አይን ሜያክ ትችሴቴ ትቻሶን ኤጵናስ ሀን ባሶክጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«ታ ደማስኮ ሀሜት ካታማሲክ ታእሴፋና ካባሲክ ቶስታ ዲንቆነ አካማ ቻሬፋ ሳማን ብራቶናስታ ፓልፓልት ቻሬ። ");
INSERT INTO jnje_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ኤስ ካባሲክ ዳስታክ ኬሬ ጋንደራ፦ ‹ሳዉልኖ! ሳዉልኖ! አዉኒ ቦርአ ታን ካብግድኢፋታርሶ?› ይፋ ካማ ኦደኒ። ");
INSERT INTO jnje_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ታ ደይ፦ ‹ዳሚሶ! ነ ኦንሶ?› ይን። ባር ደይ፦ ‹ታ ሀን ነ ካብግፋታ ናዝሬትክ የሱስዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ታኔን አነ ፌሴ ባሶ ኤስ ቻሬፋሶንቱ ብየቴታኖ ባር ታን ዎሉምስፌና ካማሶን ኣነ ኦዶሶቶ። ");
INSERT INTO jnje_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ታ ደይ፦ ‹ዳሚሶ! አዉ ዛጉናሪንሶ?› ይና ዳሚስ ደይ፦ ‹ካብራ ደማስኮ ሀማ፤ ዛጉታክ ሾልስ ባር ዙቴራ ኤስታክ ኔክ ማክቶናዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ኤስ ቻሬፋስ ፓልፓሉታን ካብ ቾዋ ብያናክ ኣነ ችሙት ስንና ቦርአ ታኔን አነ ፌሴ አሱኒ ሜያ ኩሹናስ ዛቴሬ ዞንሲት ደማስኮ ካትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ኤስታክ ሀናንያ ይስቴ እሳ አሱ ፌር። ባር ደይ አይሁድኒ ሜኒ ስናክ ኡልፍንቶ፤ ቱማሲክ ሀእ አያንቱ አሱ። ");
INSERT INTO jnje_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ባር ዬሬ ቴሽና የሬፋት፦ ‹አይታ ሳዉልኖ! ኣፍኔስ ብዩጝዋ!› ይ። ኣፍናስ ደይ ኤስ ካባሲክ ጌሬጌሬ ጋችቼ፤ ባሪን ደይ ቢን። ");
INSERT INTO jnje_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ባር ደይ ታክ ኤካ ይ፦ ‹አባኒሳክቶን ሀኦ ባር ሳፋራሶን አሩታክ፥ ኦኮስን ብያታክናዋ ደይ ካምባሶን ኖኖባስን ኦዶታክና ኔን ዜምማ ኮርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ኤስ ባሮን ደይ ዛግናስ ቢታ ባሮናዋ ኦደታ ባሮና አሱ ዙታምባሴ አሲ ስና ባርኪ ዛል ስናታክዋ። ");
INSERT INTO jnje_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ኤካኒ ሀሽ አዉ ኦዳት ዲታሪን? ካብራ ባሳ ሱናሶን ቴጎክ ሀጱክቴራ ቦርኔስኒ ካይምዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ኤሴን ኦርፎ የሩሳሌም ዎላ ሀማ ቤቴሜቅደሲሲ ሀኦ ሺጴፋት ቴሜስጦክ ራእ ቢን። ");
INSERT INTO jnje_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ዳሚስ ደይ ቤስቴሬ፦ ‹ነ ታ ቾዋሲክ ማኮታ ዛላሶን ኣፋ ኤጴቶሶነ ዉዛ ስንና ቦርአ ታፕቴራ የሩሳለሙን ኬስዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ታ ደይ ኤካ ይን፦ ‹ዳሚሶ! አይሁድኒ ሺጶኒ ኬያ ዙታምባሴ አሲስ ሀሚፋፋ ኔክ አማነፌ ባሶትን ዙትራ ኤጳ ታቶኒ ኬር ጌድናማቶናዋ እችናማቶና ባሶ ቴትቤሲሲክ አሪሴድፌዋ። ");
INSERT INTO jnje_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ኔክ ዛል ስና እስጥፋኖስኒን ዎርሴፌ ካባሲክ ታ ደይ ባሶኔን አነ እሳር ስና ቴሽቤስ የሬፋት ባሶ ማያሶን ኦደት ፋናርዋ› ");
INSERT INTO jnje_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ዳሚስ ደይ፦ ‹ዎካ ዳክ ፌሴ አዛብኒ ሜያክ ኔን ዎሱናር ስንና ቦርአ ካብራ ሀማ› » ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ኤስታኔን ካርኤ ዳራስ ዙቴሬ ጳዉሎስ ማኬና ዎላሶን ኦደሴት ፌሴቴር። ኤስታን ካምቤሲሶን ቴግሴሬ፦ «ሀን ኤፌቴና አሱ ካክ ፎናክ ኣነ ሾልስፋ ስንና ቦርአ ዳስታኪ ትሹዎዋ» ይት ቻጌቴ። ");
INSERT INTO jnje_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ባሶ ደይ ቻጌት፤ ማይቤሲሶን ክስሬ ስሩስታ ብራስት፤ ቱሎሶን ደን ሳማ ቡኬት ፌሴቴር። ");
INSERT INTO jnje_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","አጃጀፌ ጋኝኛስ ኤስ ባሮን ቢናይሴ ጳዉሎስኒን ሜያ ታርኦን ሜያ ፌሴፌ ድማስ ኤጴ ሀሞነክ አጃጀ። ዳራስ ባሳስታ አዉኒ ቦርአ ኤፋሮን ቻጌቴማቶ አሩናክ እቼት ማሙስቶናክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ስኑንታኖ ታልፋክ ታርኤሬ እቾነክ ሆሬሴፌ ካባሲክ ጳዉሎስ ቴሽባ የሬ ት ሜኒ ጋኛክ፦ «ሮምኒ አሱንን ማጝሱ ካርኖይፌን እቻትክ ሾልሱኖሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ት ሜኒ ጋኝኛስ ኤስ ባሮን ኦደናይሴ አጃጀፌ ጋኝኛስክ ሀሜ፦ «ሀን አሱስ ሮምኪ ዳኒ አሱዋ፤ አዉ ዛጉታክንሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ኤስ ባሪ ቦርኣ አጃጀፌ ጋኝኛስ ጳዉሎስኒክ ታእሴሬ፦ «ነ ሮምኪ ዳኒ አሱኖሶ? ታክ ማኬቦ» ይ። ጳዉሎስ ደይ፦ «ኣ፥ ታ ሮምኪ ዳኒ አሱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","አጃጀፌ ጋኝኛስ፦ «ታ ሮምኪ አሱ ስናናክ አካማ ዋጋቱ ካስራ ዋጌጝዋ» ይ። ስኑንታኖ ጳዉሎስ፦ «ታ ሮምን ዳስታክቱ ኮንቴጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ኤስታን ባሪን ቱኡኑክ ሆሬሬ ፌሴ ባሶ ባሳስታን ኦር ኬሴ ሀሜቴ። ጋኝኛስ ደይ ሮምኪ አሱ ስኒባሶን አሪናይሴ ሻሻራክ ታቶናክ አጃጆባሲክ ድጌ። ");
INSERT INTO jnje_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ዎኖትር ዎኖ አጃጀፌ ጋኝኛስ አይሁድኒ ሜያ ጳዉሎስኒን ማላሴቴ ቾዋ ፉቶባስ አዉ ስንናማቶ አሩናክ ሾሌ። ኤስታን ማግኒ ጋኝኜ ሜያኖናዋ ሾንጎታ ዲሴፌ ባሶትና ዙቶሶነክ አጃጀ። ጳዉሎስኒን ታቶኒ ኬሩን ኮፂሬ ቴሸ ባሶ ስና ታእስ። ");
INSERT INTO jnje_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ጳዉሎስ ሾንጎስታ ዲሴ ባሶትን ኮትክሬ ብያት፦ «አይታሳክቶኖ! ታ ሀውጙኔን ካርአ ሀኦሲ ስና ፋና ፎናስ ማአ ካኑክዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ሀናንያ ስኒፌ ማግኒ ጋኝኜ ሜኒ ጋኛ ጳዉሎስኒ ቴሻ የሬ አሱኒ ሜያኖን ጳዉሎስኒ ኖኖሶን እቾሶነክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ኤስ ካባሲክ ጳዉሎስ ሀናንያንን፦ «ነ ቦሮ ማትራ ድ ሳዋነ ፋታርዋ፤ ሀኦሲ ኔን እችንርዋ! ነ ቱማስማቶ ማጝሱ ካርአታክ ዲፋት ኬሳ ቱማስኔን ጌራካሎ ታን እቾሶነክ አጃጆታሮሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ኤስታ የርሴ አሱኒ ሜያ፦ «ሀኦሲ ማግኒ ጋኝኜ ሜኒ ጋኝኛስን ሜፋቶሶ?» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ጳዉሎስ ደይ፦ «አይታሳክቶኖ! ማግኒ ጋኝኜ ሜኒ ጋኛ ስኒባሶን ኣነ አሩትዋ። ሀኦሲ ካምስ፦ ‹ዳራስን ሀእሲፌ ባሶስታ ማጙ ካማ ማኮታታዋ› ይስቴራ ትቼራ ፋርዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ስኑንታኖ ጳዉሎስ ኤስታ የሬ ባሶስኒ እሳ ኩኑስ ሴዱቃው፤ እሳ ኩኑስ ፌሪሳዊ ስኖቤሲሶን አሪፋት፦ «አይታሳክቶኖ! ታ ፌርሳዊኒ ሜኒ ኬናስን ኮንቴ ፌርሳዊዋ። ሀሽ ታ ማጝሱ ካርቴፋና ድማስታ ታእሴናስ እምቴ አብድሲክናዋ ክቱኒ ካቡኒ ቾዋሲክናዋ» ይት ዙቶስ ስና ካምባሶን ቴግሬ ቻጊ። ");
INSERT INTO jnje_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ኤስ ባሮን ማኮባሴ ፌርሳዊኒ ሜናዋ ሴዱቃውን ሜና አሲ ጋነያስ ፋሶ ካብን ሾንጎስ ሄፕክ ባግቴ። ");
INSERT INTO jnje_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ሴዱቃውን ሜያ፦ «ክቱኒ ካቡ ኣፋ፤ ሀኦሲ ዎስያ ደይ ኣፋ፤ አያናስ ደይ ኣፋ» ይፋር፤ ስኑንታኖ ፌርሳዊኒ ሜያ፦ «ኤስ ባር ዙታምባሴ ፋርዋ» ይሬቱ አማነሴፌ። ");
INSERT INTO jnje_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ኤስ ባሪ ቦርኣ ናጋን ትሹ ስኒ። ፌርሳዊኒ ሜኒ ጋነያስን እሳ እሳ ሙሴኒ ቱማሶን አሲፌ ባሶ ካብሴሬ፦ «ሀን አሱሳታ እሳ ማጝሱነ ኣነ ዳነኒዋ። አዉዛክነ አያና ወደይ ሀኦኒ ዎስያ ባርኪ ማኬ ስናናዋ» ይት ችኒሬ ዌንሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ፋሶስ አሪክት ዮባሴ አሱኒ ሜያ ጳዉሎስኒን ቡኤ ትሹክሶኖይቴማቶ አጃጀፌ ባር ድጌፋት ሜያ ታርኦን ሜያ ሀሜሬ አሱኒ ሜኒ ጋነያስን ክስሬ ቴሸሬ ሜያ ታርኦን ሜያ ፌሴፌ ድማስታ ኤጴ ሀሞነክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ዎኖትር ዎኖ ዋልን ዳሚስ ጳዉሎስኒ ቴሻ የሬፋት፦ «ድጎታታዋ! የሩሳለሙክ ታ ቾዋሶን ማኬታስማቶ ሮም ደይ ሀማ ታ ቾዋሶን ማኮታክ ሾልሱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ዎኒፋና ካባሲክ አይሁድኒ ሜያ ዙቴሴሬ፦ «ጳዉሎስኒን ዎሩኖይ ሙ ኣፋ ሙን ዉዛ ደይ አካ ኣፋ ኡሻኒ ዉዛ» ይት ቴይሴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ኤስ ባሮን ሜርኬስ አቼቻስር አሱኔን ደናሎ። ");
INSERT INTO jnje_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ኤስ ባሶ ደይ ማግኒ ጋኝኜ ሜያክናዋ ኩርኡኒ ሜያክና ሀሜሬ፦ «ጳዉሎስኒን ዎሩንኔን፦ ‹ሙ ኣፋ ሙን ዉዛ› ይት ችኒራ ቴይኒዋ። ");
INSERT INTO jnje_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ንቶ ደይ ሾንጎስኔን አነ እሳር ስንና ባሳ ቾዋሶን ማእስሬ ቱኑት ዉዛ ፋርነ ፋር ዛግራ ጳዉሎስኒን ንቶክ ታእሱናክ አጃጀፌ ባሪን ማምሱትዋ። እንኖ ደይ ሀንታ ካርኖይፌን ዎሩኒክ ሆሬንዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ስኑንታኖ ጳዉሎስኒ ኤኤት ና ኤስ ሜካማሶን ኦደፋት ሜያ ታርኦን ሜኒ ኬኤ ሀሜ ጳዉሎስኒክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ጳዉሎስ ደይ ት ሜኒ ጋኛአሳስኒ እሳርን ቴጌሬ፦ «ሀን ናስ አጃጀፌ ጋኝኛስክ ማኮና ዉዛ ፋር ስንና ቦርአ ጋኛስኔን ኡጵሱዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ት ሜኒ ጋኝኛስ ደይ ናስን ታሜ አጃጀፌ ጋኝኛስክ ካትፋት፦ «ሀን ናስ ኔክ ማኮና ዉዛ ፋር ስንና ቦርአ ታቶ ስንና ጳዉሎስ ታን ቴጌሬ ኔክ ኤጳ ዮናክ ሺጴዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","አጃጀፌ ጋኝኛስ ደይ ናስን ኩሹባስ ዛቴ ኤክሴፋት፦ «ታክ ማኮታ ዉዛስ ኣምባንሶ?» ይት ማምሲ። ");
INSERT INTO jnje_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ናስ ደይ ኤካ ይ፦ «አይሁድኒ ሜያ ጳዉሎስኒ ቾዋሶን ችኒሬ ቱኑሶነርነ ፋር ዛግሴሬ ዎኖ ሾንጎስ ስና ታእሱታክ ኔን ማምሱሶነክ ሜርኬሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ስኑንታኖ ነ ማእ ኡታታዋ። ጳዉሎስኒን ዎሩንኔን ሙ ኣፋ ሙን ዉዛ አካ ደይ ኣፋዋ ኡሻኒ ዉዛ ይሴሬ ቴይሴቴ አቼቻስርኔን ደናሎ አሱ ባሪን ዎሩክ ኦደድፌርዋ። ሀሽ ባሶ ኦደሴት ፌሴቴስ ነ ዎልጉሶጝዋ» ");
INSERT INTO jnje_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","አጃጀፌ ጋኝኛስ፦ «ሀን ታክ ማኬታ ቾዋሶን ኦንክኑ ማኮታታዋ» እያት ናስን ጋፍኪ። ");
INSERT INTO jnje_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ኤሴን ኦርፎ አጃጀፌ ጋኝኛስ ት ሜኒ ጋኛአሳስኒ ሄፕን ቴጌሬ፦ «ዋልን ኬዝ ሳአትስታ ቅሳርያ ሀሚን ሄፕ ት ሜያ ታርኦንናዋ፥ ናፉናስር ፋዛ ኤልሱኒ አሱኒና፥ ደይ ሄፕ ት ኤቦ ፎኪን አሱኒን ሆሱትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ጳዉሎስኒክ ፋዛሲክቶኖን ሆስራ ዳሶን ሀእሲፌ ፍልክስኒክ ናጋክ ካርአናክ ዛጉትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ኤካ ይፋ ትቻ ደይ ትችሬ፦ ");
INSERT INTO jnje_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«ቀላኡደዎስ ሉስዮስኒኪን አሪክቶ ዳሶን ሀእሲፌ ፍልክስኖ! ናጋ ኔክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ሀን አሱስን አይሁድኒ ሜያ ዎርሶነ ካባዋ። ስኑንታኖ ባር ሮምኪ ዳኒ አሱ ስኒባሶን አሪና ቦርአ ሜያ ታርኦን ሜያኔን አነ ኤስታ ካርአ ፉኤጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ባሪን አዉኒ ቾዋክ ማላሴቴማቶ አሩናክ ሾሌፋት ባሶ ሾንጎስታ ታእስኒ። ");
INSERT INTO jnje_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ማላሴቴስ ደይ ባሶ ቱማሶን ቢፋ ቾዋሲክ ስኒባሶን አሪጙዋ። ስኑንታኖ ክቱታ ካቱኒ ወደይ ባሪን ታቶኒ ኬር ጌድኒ ቾዋታዋ። ");
INSERT INTO jnje_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ሀን አሱስን ዎሩክ ኮፓሴሬ ሆሬሴቴማቶ ኦደናይሴ ጌሬጌሬ ኔክ ጋፍክጝዋ። ማላቴሴ ባሶ ማላትቤሲሶን ኔክ ስና ታእሱሶነክ ማኬጝዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ኤስታን ሜያ ታርኦን ሜያ ባሶክ ማክቴናስማቶ ጳዉሎስኒን ዋልን ኤጴ ታሜ አንትጳትርስኒክ ካትሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ዎኖትር ዎኖ ፋዛ ኤልስፌ አሱኒ ሜያ ጳዉሎስኔን አነ ሀሞነክ ዛግፋት ሜያ ታርኦን ሜያ ፌሴፌ ድማሲ ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ፋዛ ኤልስፌ አሱኒ ሜያ ደይ ቅሳርያ ካርኤቴይሴ ትቻሶን ዳሶን ሀእሲፌ ባርኪ እሜፋት ጳዉሎስኒን ደይ ስኒባ ታእስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ዳሶን ሀእሲፌ ባር ትቻሶን ፌሬትናኔን ኦርፎ ጳዉሎስኒን፦ «ነ! አይክ ዳኒ አሱኒሶ?» ይት ማምሲ። ቅልክያክ ዳኒ አሱ ስኒባሶን አሪናይሴ፦ ");
INSERT INTO jnje_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«ኔን ማላቴሴፌ ባሶ ዬሴፋቴን ቾዉኔሶን ባሶኪን ደይ ኦዶናዋ» ይ። ሄሮድስኒ ማሳራስ ኦድቴሬ ፎናክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ኡች ዎናኔን ኦርፎ ማግኒ ጋኝኜ ሜኒ ጋኛ ሀናንያ እሳ እሳ ኩርኡኒ ሜያኔን ቴርቴሉስ ይስቴ ዎብስኔን አነ ቄሳሪያ ሀሚ። ባሶ ደይ ጳዉሎስኒ ቾዋሶን ዳሶን ሀእሲፌ ፍልክስኒክ ሀሜሬ ማላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ጳዉሎስ ቴግቴሬ ዬፌና ካባሲክ ቴርቴሉስ ኤካ ይት ማላቶናክ ካብሬ፦ «ኡልፍንቶ ፍልክስኖ! ኔክ ካሞ አካማ ናጋ ዳንዋ፥ ሀን ነ ማአ ሀእሱሲክ ዳራኒስ ፎባስ ሶልቴዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","አካማኖን ኡልፍንቶ ፍልክስኖ! ሀን ማአ ዎስቶኔሶን ዳ ዳስንናዋ ኣጌነ ኣጌነና አካማ ጋላታክቱ ኤጳ ታፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ስኑንታኖ ሀኒስታን ደናሎ ኔን ሆፕሱኖይናሮን ካዉንባሴ ኔክ ማኮና ባሮን ጋራማክ እኖትን ኦዶታክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ሀን አሱስ እኖስታ ማጙ ሜሮ ስኒዋ። ሀን ዳ ዙታምባሴ አሲስ ፌ አይሁድኒ ሜኒ ጋነያስ ናጋ ትሽክ። ናዝራውን ሜያ ይስቴፌ ባሶክ ዞንሲቤስዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ደይ ቤትሜቅደሲሶን ኪኑክ ካቤፌን ኤጵንዋ። ቱማኒስማቶ ማጝሱ ካርአንክ ሾሌራ ፋኒር። ");
INSERT INTO jnje_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ስኑንታኖ ሜያ ታርኦን ሜያኖን አጃጀፌ ጋኛ ሉስዩስ ዬሬ አካማ ሁግናክ እንኖ ኩሹስን ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ባሪን ማላቴሴፌ ባሶትን ደይ ኔክ ዮሶነክ አጃጀ ነ ቴትኔሲክ ባሪን ቱንራ ሀን እንኖ ባሪን ማላቴን ቾዋሶን ዙትራ አሩታክ ችማታዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","አይሁድኒ ሜያ ደይ፦ «ሀን ቾዋሲ ዙቴራ ፉቶዋ» ይሴት ማላታሲክ እሳር ስንነቴ። ");
INSERT INTO jnje_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ዳሶን ሀእሲፌ ፍልክስ ጳዉሎስ ማኮናክ ኩሹባሶን ካብግሬ ቤስ። ጳዉሎስ ደይ ኤካ ይት ማኮ ኤጲ፦ «ሾዎ ነያ ሀን ዳራሳታ ማጝሱ ካርኤት ፋታማቶ አሪናር ስንና ቦርአ ታይስታ ማላቴ ማላታስ ዎልጉኖን ኔክ ማኮናስ ግራክዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ሀኦኒ ሺጶክ የሩሳሌም ሀሚናኔን አሲሬ ሄፔ ዎናስታን ኣነ ዳይቶዋ ስንናማቶ ነ ቴትኔሲክ አሩታክ ችማታዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ቤቴሜቅደሲሲ ስኑን አይሁድኒ ሺጶኒ ኬያስ ወደይ ካታማስ ኦኔንኑ ዌእኒፋና ወደይ ዳራስ ናጋ ቱርኩናክ ዛግፋና ታን ኣነ ዳኖቶ። ");
INSERT INTO jnje_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ሀሽ ታን ማላቴሴቴ ቾዋሲክ እሳ ዛላ ኔክ ታእሱሶነክ ኣፋ ችሞነ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ስኑንታኖ ሀን ባሮን ኔክ ማኮናክ ሾሌፋዉጙዋ፤ ባሶ ኤሽኒ ኡግና ይሴፌ ኤስ ኡግናሲክ ታ እንኖ አባን ሜኒ ሀኦሶንቱ ሺጴፋዉጙዋ። ሙሴኒ ቱማሲ ትቼ ባሮናዋ ራጁኒ ሜያክ ካሞ ማክቴ ባሮና ዙትራ አማነናርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ባሶ ደይ አብድ ዛግሴፌይስማቶ ታ ደይ ኦኮኒ ሜናዋ ኦኮ ስኖይ ሜና ክቱኒ ካብሶነማቶ ሀኦሲክ አብድ ዛግፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ኤስ ባሪ ቦርኣ ታ ሀኦሲ ስናክናዋ አሱኒ ስናክና ካይማ ንብና ፎናክ ዎንና ዎንና ዱደፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","የሩሳለሙን ኬስናኔን ሀጝ ሾዎ ዎግጋ ኣትናኔን ኦርፎ ዳራታሲክ ስኒ አሪጋሱን ዋግነዋ ሀኦሲክ እምቶኒ እማሶን እማናክ ያጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ቤቴሜቅደሲሲክ ደይ ካይምኒ ስትሪሶን ዛግት ፋናቱ ዳነቴዋ። ኤስ ካባሲክ ታኔን አነ ዳራስ ኣፌ። ደይ ናጋን ትሹስ ኣነ ካቡዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ስኑንታኖ ኢስያኒ ዬሴ አይሁድኒ ሜያ ኤስታ ፌሴቴር። ባሶ ታይስታ ማላቶሶነ ቾዋ ፋፋናነ ኔክ ስና ታእሴሬ ማላቶሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","«ኤሴን ኦርፎ ሾንጎስ ስና ታእፋና ካባሲክ ዳነቴ ማጝሱ ፋፋናነ ማክሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ባሶ ጋነያስ የሬፋት፦ ‹ክቱኒ ሜኒ ክቱኒ ካቡ ፋርዋ ኡናሲክቱ ሀሽ ሀውጙ ማጝሱ ታይስታ ካቶናክ ንቶ ስና ታእጝዋ› ይት ቴጋ ካማክ ቻጋ ማኬጝዋ። ኤሲስታኖ ኦማ ዛግና ዉዛ ኣፋዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ስኑንታኖ ፍልክስ ዳሚሳ ኡግናኖን ማእስሬ አሪሬ ፌር ስንና ቦርአ፦ «ሜያ ታርኦን ሜያኖን አጃጀፌ ጋኛ ሉስዮስ ዬፌና ካባሲክ ንቶ ቾዋሶን ኮእሱናዋ» እያት ጋፍኪ። ");
INSERT INTO jnje_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ጳዉሎስኒን ኦደት ፌ ት ሜያ ታርኦስኒ፦ «ብርማዱማ ካልኖይ ማእስራ ኦድዋ፤ ደይ ኮኒባሳክቶ ባርኪ ሾልስ ዉዛ ኤጴ ዬሴፌ ካባሲክ ካላታታዋ» ይት አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ጋሮ ዎናኔን ኦርፎ ፍልክስ አይሁዳዊ ስና አሱባ ድሩስላኔን አነ የ። ጳዉሎስኒን ቴግስሬ ክርስቶስ የሱስኒክ አምማኖን ቾዋሶን ማኬን ኦደ። ");
INSERT INTO jnje_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ጳዉሎስ ኦኮኒ ቾዋሶንናዋ ቴትን ሀእሱሴ አሲ ቾዋኖና ደይ ዮን ማጝሱኒ ካርኣስ ቾዋኖን ማኮባሴ ፍልክስ ድጌሬ፦ «ሀሽ ሀንታን ሀማ፤ ታክ ሆእትና ዎኖኔን ዎስራ ቴግሱናዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ፍልክስ ጳዉሎስኒኪን ዋጋ ሙናክ አብድ ዛግት ፌር። ኤስ ባሪ ቦርኣ ሾዎ ዎና ቴግስፋፌ ዎሉምስት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ሄፕ ዎጋኔን ኦርፎ ፖርቅዮስ ፍስቶስ ፍልክስኒ ኮዳስታክ ሀእሱኒር ስንነ ታቴ። ፍልክስ አይሁድኒ ሜያኖን ግርሱናክ ሾሌፋት ጳዉሎስኒን ኮታ ቤይ። ");
INSERT INTO jnje_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ፍስቶስ ሀእሲፌና አዉራጃስ ግሪሬ ኬዝ ዎና ኣትናኔን ኦርፎ ቂሳርያን የሩሳሌም ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ኤስታክ ማግኒ ጋኝኜ ሜናዋ እሳ እሳ አይሁድኒ ሜያኖን ዞንስፌ ባሶና ጳዉሎስኒን ማላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ጳዉሎስኒን ኡጉንታ ኦደ ዎርሶነክ ሾልሴፋት ፍስቶስኒክ፦ «ጳዉሎስኒን የሩሳሌም ኦትሬ ቴሾክ እኖክ ማአ ዉዛ ዛጉዋ» ይት ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ስኑንታኖ ፍስቶስ ዎልግሬ፦ «ጳዉሎስ ቅሳርያክ ታቶኒ ኬር ኦድቴቱ ፌዋ፤ ታ ደይ ሀሽ ታፕቴራ ኤስታ ሀሚናርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ኤሴ ንቶትን ሀእሲፌ ሜያ ታኔን አነ ቅሳርያ ሀሞቶዋ፤ ኤስታክ ጳዉሎስ ዛግና ማጝሱ ፋፋናነ ማላቶሶቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ፍስቶስ ደይ ናጙሪን ወደይ አሲር ዎና ስኒሮን ባሶኔን አነ ኣትናኔን ኦርፎ ቅሳርያ ሀሚ። ዎኖትር ዎኖ ማጝሱኒ ካርን ኮዳስታክ ዲፋት ጳዉሎስኒን ታእሱሶነክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ጳዉሎስ ታእሴፌና ካባሲክ የሩሳለሙን የ አይሁድኒ ሜያ ጋነያ ጌደ የርሴፋት ሾዎ ዛልባ ፎንቶ ፋያ ማላታ ባሳስታ ማላቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ጳዉሎስ ደይ፦ «አይሁድኒ ቱማስታ ስኑን ቤቴሜቅደስስታ ወደይ ቀሳርኒስታ እሳ ዛግና ማጝሱ ኣፋ» ይት ማላታስ ዎልጉኖን ዎልጊ። ");
INSERT INTO jnje_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ፍስቶስ አይሁድኒ ሜያኖን ግርሱክ ሾሌፋት ጳዉሎስኒን፦ «የሩሳሌም ሀምፋት ሀን ቾዋሲክ ማጝሱ ካቶናክ ታክ ስና ታአታክ ሾሌፋቶሶ?» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ስኑንታኖ ጳዉሎስ ዎልግሬ፦ «ታይስታ ማጝሱ ካርአክ ችምኒ ቄሳርን ማጝሱኒ ካርን ኮዳስ ስና የሬፋዉጝዋ። ነ ማእስራ አሪፋታሲማቶ አይሁድኒ ሜያስታ እሳ ማጝሱነ ኣነ ካቱትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ኤሴ ሚርአነዋ ክቱታ ካቱኒ ማጝሱነ ዛግን ስንፋናነ ክቱኒ ፉእቶና ኣፋ ኡናዉዛ። ስኑንታኖ ባሶ ማላታስ ሽማ ስንፋናነ ታን ባሶክ ኣትሬ እማናክ ኦኑ ኣፋ ችማናዉዛ። ቾዉናስ ቄሳርን ስና ቢስቶጝዋ» ይንዋ። ");
INSERT INTO jnje_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ኤስ ካባሲክ ፍስቶስ ባርኔን አነ ሜርኬሴፌ ባሶኔን አነ ሜርኬሬ፦ «ይግባኝ ይታኔን ቀሳርንክ ሀማታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ጋሮ ዎናኔን ኦርፎ ታቶ አግርጳናዋ ቤርንቀና ፍስቶስኒን «ኤኩ ናጋክ ያታ» ኡክ ቅሳርያ ዬሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ኤስታክ ሾዎ ዎና ዲሴቴ ቦርአ ፍስቶስ ጳዉሎስኒ ቾዋሶን ኤካ ይት ታቶ አግርጳንክ ማኬ፦ «ፍልክስ ታትሬ ኩንስና እሳ አሱ ሀንታቱ ፌ። ");
INSERT INTO jnje_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ታ የሩሳለሙክ ፋና ካባሲክ ማግኒ ጋኛናዋ አይሁድኒ ኩርኡኒ ሜና ሀን አሱሳ ቾዋኖን ማላቴሴሬ ባሳስታ ማጝሱ ካርአናክ ታን ማሙሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ስኑንታኖ ታ፦ ‹ማላቴ አሱስ ማላቴ ባሶ ስና የሬሬ ማላቴና ማላታስ ዎልጉኖን እምኖይፌን ማላቴ ባሪን ኣትሬ እማ ሮማኒ ሜኒ ዱቢዮታዋ› ይራ ባሶክ ዎልግጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ኤስታን ማላቴሴ ባሶ ሀንታ ዙቴሴፌ ካባሲክ ታ ደይ ዎክኖይ ዎኖትር ዎኖ ማጝሱኒ ካርን ኮዳስታክ ዲፋት ኤስ አሱስን ታእሱሶነክ አጃጀን። ");
INSERT INTO jnje_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ማላቴሴ ባሶ ደይ ቴሽባ የርሴፋት ማክሴፌ ካባሲክ ታ ሳፋሬናስንነ ፋ ማጙ ዉዛ እሳንነ ባሳስታ ኣነ ማክሶቶ። ");
INSERT INTO jnje_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ስኑንታኖ ባርኔን አነ ዌእኒት ፌሴቴስ ባሶ ቴትን ሀይማኖትሲክናዋ ጳዉሎስ ‹ሀየዉዋ› ይፌና ክት የሱስኒ ቾዋሲክናዋ። ");
INSERT INTO jnje_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ታ ደይ ሀን ኤፋቴና ቾዋሶን ቱኑ ታን ራክስና ቦርአ፦ ጳዉሎስኒን፦ ‹የሩሳሌም ሀሚፋኒ ኤስታክ ሀን ቾዋሲክ ማጝሱ ነይስታ ካርአናክ ሾሌፋቶሶ?› ይን። ");
INSERT INTO jnje_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ስኑንታኖ ጳዉሎስ ቾዉባስ ቀሳርንክክ ቢስቶናክ ሾሌፋት፦ ‹ይግባኝ› ኡባሲክ ኤስታ ጋፍኩናኔን ታቴሬ ፎናክ አጃጀን።» ");
INSERT INTO jnje_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","አግርጳ ፍስቶስኒን፦ «ታ ሀን አሱስ ማኬፌን ኦዶናክ ሾሌፋዉጙዋ» ይ። ፍስቶስ ደይ፦ «ዎኖ ማኬፌን ኦዶታዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ኤስታን ዎኖትር ዎኖ አግርጳናዋ ቤርንቀና አካማ ኡልፍናክ ሜያ ታርኦን ሜኒ ጋኝኛክቶኒክናዋ ካታማስ ፌ አርቶ ሜያክና ጌፕቴሬ ዬሴሬ ማጝሱኒ ካርን አዳራሽስ ግርሴቴ። ኤሴን ኦርፎ ፍስቶስ ጳዉሎስኒን ቴግስ። ");
INSERT INTO jnje_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ፍስቶስ ደይ፦ «ታቶ አግርጳኖ! ንቶ እኖኔን አነ ፌ አሱኒ ሜያ ዙቴሬ! ‹ሀን አሱስ ሀንኔን ኤካሎክ ካክ ፎናክ ኣነ ሾልስፋ› ይት ቻጌት የሩሳለሙክናዋ ሀን ቂሳርያክ ፌሴ አይሁድኒ ሜያ ባሳስታ ማጝሱ ካርአናክ ታን ማሙሴቴ አሱስ ሀንፌዋ። ");
INSERT INTO jnje_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ስኑንታኖ ታ ባሪን ክቱታ ካቱኒ ማጝሱ ኣነ ዳኑት። ባር ደይ፦ ‹ቾዉናስ ቄኤሳአርንክ ቢስቶጝዋ› ይና ቦርአ ኤስታ ዎሱናክ ሆሬን። ");
INSERT INTO jnje_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ስኑንታኖ ባሳ ቾዋሲክ ዳምታሲክ ትቹና አማ ዉዛ ኣፋዋ። ኤስታን ቱኡንራ ቢንኔን ኦርፎ ትቹና ዉዛ ዳናናቶ እያት ንቶ ስና አሪክሮን ደይ ታቶ አግርጳኖ! ኔክ ስና ታእስጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","እሳ ታቶ ደናሎ ፌ ታቶስኪ ዎስቴሬ ሀሚፌና ካባሲክ ማላቴና ማላታስ ቾዋኖን አማ ዛጉ ቤያ ማአሪ ስንና ታክ ኣነ ቤስቶዋዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","አግርጳ ደይ ጳዉሎስኒን፦ «ቾዉኔሶን ማኮታክ ችማታዋ» ይ። ጳዉሎስ ኩሹባሶን ካብግሬ ማላቴና ማላታስ ዎልጉኖን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«ታቶ አግርጳኖ! አይሁድኒ ሜያ ታን ማላቴሴቴ ማላታ ዙታምባሴ አሲክ ዎልጉባሶን ሀሽ ሀውጙ ኔክ ስና እምፋና ካባሲክ ታ ታ ቴታሲክ አካማኖንቱ ግሬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ኤሲስ ደይ ነ አይሁድኒ ሜኒ ስትርሴዋ ካራካሮሴ አሲን ማእስራ አሪታርዋ። ኤስ ባሪ ቦርኣ ፋክያክ ታን ኦዶታክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«ጋሮናሴኔን ኣካክ ፋናማቶ አይሁድኒ ሜያ ዙቴሬ አሪሴቴርዋ። ቴሱስታን ካብግራ ዳራታሳ ጋነስናዋ የሩሳለሙክና ፋና ፎናሶን አሪሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ታ ቾዋሲክ ዛላ ማክሶነክ ማእ ይሴፋቴነ ሀይማኖትኒሶን አካማኖን ዛግሬ ኦደፌ ፌርሳዊኒ ሜኒ ኬን ስንና ፋናማቶ ቴሱስታኔን ካብሬ አሪሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ስኑንታኖ ሀሽ ማጝሱ ታይስታ ካቶናክ ሀንታ የሬናስ ሀኦሲ አባኒሳክቶኒክ እምና ቴያኒ ካማሲክ አብድ ዛግፋና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ኤስ አብዲስታ ካርኦነክ አሲሬ ሄፔ እንኖ አሲቴሴሪስ ሀኦሶን ቶነ ዋልነ ችሜ ሺጶክ ኦደድፌር። ታቶኖ! ታን አይሁድኒ ሜያ ማላቴሴቴስ ኤስ አብዲሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ሀኦሲ ክቱኒ ሜያኖን ክቱኒ ካብጉኒር ስኒባስ አዉኒ ቦርአ ንቶክ አማንቶባ ፎንቶ ቾዋ ስኒሶ? ");
INSERT INTO jnje_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«ታ ደይ ታ ቴታሲክ ናዝሬትክ የሱስኒ ሱናሶን ችምናስንነ ፋሮን ቱጋኦኪ ሾልሱ ስንናማቶ ሳፋሬት ፋናር። ");
INSERT INTO jnje_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","የሩሳለሙክ ዛግናስ ኤሲሶጝዋ። ማግኒ ጋኝኜ ሜያኪን ኤጵና ሀእሱኒ ሁግናሲክ አማኝኒ ሜያስን ሾዎኒን ታቶኒ ኬር ታትን። ባሶትን ዎርሴፌ ካባሲክ ባሶኔን አነ እሳር ስኒን። ");
INSERT INTO jnje_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ሾዎ ዎና አይሁድኒ ሺጶኒ ኬያ ኬያስ ሀሚፋፋ ኬኦ ኤጴቶሶነክናዋ ዳሚሳታ ሜኤእን ካማ ማክሶነክና ካቤት ፋናር። ባሶስታ አካማኖን ሃሬራ ኦማ ጌሮን ካታማስኑ ሀሚፋፋ ካብግት ፋናር። ");
INSERT INTO jnje_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«ሀን ቾዋሲክ ማግኒ ጋኝኜ ሜያኪን ሀእሱኒ ሁግናነዋ አጃጅነ ኤጳ ደማስኮ ሀሚድፋናር። ");
INSERT INTO jnje_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ታቶኖ! ኡጉናስታ ፋና ቶስታ አዋስ ቻሬፋታን ደናሎ ስና ቻሬፋ ቢን። ኤስ ቻሬፋስ ብራቶናስታናዋ ታኔን አነ ሀሜት ፌሴ ባሶ ብራቶስታና ሳማን ቻሬ። ");
INSERT INTO jnje_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ዙታምኒሴ ዳስታክ ጋንደራ ኩንፌን አይሁድኒ ሜኒ ኖኖክ፦ ‹ሳዉልኖ! ሳዉልኖ! አዉኒሮን ታን ካብግድፋ? ካሞ ብታስታ የርአና እያታነ ቴትነሶንቱ ሚርኦታዋ› ይፋ ካማሶን ኦደኒ። ");
INSERT INTO jnje_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ታ ደይ፦ ‹ዳሚሶ! ነ ኦንሶ?› ይን። ባር ደይ፦ ‹ታ ነ ካብግፋታ የሱስዋ፤ ");
INSERT INTO jnje_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ስኑንታኖ ሀሽ ካብራ ዎቾኔሲክ የሮዋ። ታ ኔክ ቤስቴናስ ቢታ ታ ዉዛሲክናዋ ሀንኔን ደይ ኔክ ቤሱናክ ፋ ዉዛሲክና ዎስትኛታ ስና ዛላ ታክ ማኮታክቱ ኔን ታስህጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","እስራኤልኒ ዳራሳ ኩሹስንናዋ ኔን ዎሱና አዛብኒ ሜኒ ዳራሳ ኩሹስንና ኔን ኦዳና። ");
INSERT INTO jnje_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ኣፍቤሲሶን ጋቻታክናዋ ታልማስኒ ቻሬፋስታ ክሱታክና ደይ ሴጣናስ ሀእሱኒ ስካሎስኒ ሀኦሲክ ዎልጉታክና ኔን ዛጉናዋ። ባሶ ደይ ቦርቤሲስ ፋክያኖን ዳኖነ። ታክ አማኖቤሲሲክ ደይ ኮርቶ ስና ባሶኔን ርስት ዳኖነ።› ");
INSERT INTO jnje_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«ታቶ አግርጳኖ! ሳማን ታክ ቤስቴ ራእሲክ ኣነ አጃጃሞ ቤዩትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ስኑንታኖ ዜምማ ደማስኮክ ፌሴ አሱኒ ሜያክ ኤስታን ደይ የሩሳለሙክናዋ ዩዳኒ ዳ ዙታምባሴ አሲስ ፌ ባሶክና ኤሲስማቶ ደይ አዛብኒ ሜያ ሀርሙሶነክ ማኬን። ሀርሙሶቤሲሶን ቤስፋ ዎስቶ ዎስቶሶነክ አዋስጝዋ ");
INSERT INTO jnje_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ኤስ ባሪ ቦርኣ አይሁድኒ ሜያ ቤቴሜቅደሲሲክ ታን ኤጴ ዎሩክ ካብሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ሀሽ ሀውጙኔን ካርአ ሀኦሲ አሪጋሱ ታይስታን ኣነ ትሹዋ። ኤስ ባሪ ቦርኣ ጋሮሲክናዋ ጋይማሲክና ሀን ፉቶሶን ማኬት ሀንታ የሬፋዉጝዋ። ራጁኒ ሜናዋ ሙሴና ዜምሜ ኤካ ስናና ይሴሬ ማክሴቴ ባሮን ማኬናስታኖ ኦማ እሳ ዉዛነ ኣነ ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ባሶ ደይ፦ ‹ክርስቶስ ሻናሶን ኤጴቶና፤ ክቱኒ ካቡሲክ ደይ ቴሱኒር ስንነ ቻሬፋሶን እስራኤልኒ ዳራሲክናዋ አዛብኒ ሜያክና አምማኖን ቤሱና› ይሴሬቱ ማክሴቴዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ጳዉሎስ ኤስ ባሮን ማኬፌን ፍስቶስ፦ «ጳዉሎስኖ! ንፋሴትዋ። አካማኖን አሩኔስ ንፋሶ ስናታክ ኔን ዛጊዋ» ይት ቻጌ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ስኑንታኖ ጳዉሎስ፦ «አካማኖን ኡልፍንቶ ፍስቶስኖ! ፉቶሴዋ ፉቶ ስና ባሮንቱ ማኬንታኖ ኣነ ንፋሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ባሳ ስና አምማኖን ማኬና ታቶስ ሀን ባሮን አሪፌዋ። ኤስ ባር ደይ ኣቾኖር ስና ቤይና ቦርአ ታቶስ አሩናማቶ አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ታቶ አግርጳኖ! ራጁኒ ሜያኖን አማኔስ ታታኖሶ? ነ ደይ አማነፋታማቶ አሪፋውጙዋ» ");
INSERT INTO jnje_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","አግርጳ ደይ ጳዉሎስኒን፦ «ሀን ጋሮ ካብሳስ ታን ክርስታና ዛጉታክ ሾሌድፋታርዋ ብ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ጳዉሎስ ደይ፦ «ጋሮ ካባሲክ ስኑን አካማ ካባክ ነ ነ ስኖይታሮን ሀሽ ሀውጙ ታ ዎላሶን ኦደ ባሶ ዙቴሬ ሀን ታቶናስታኖ ታነ ፌር ስኖነክ ሀኦሶን ሺጴፋዉጙዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ኤሴን ኦርፎ ታቶ አግርጳ፤ ዳሶን ሀእሲፌ ባርናዋ ቤርንቀኖንና ደይ ባሶኔን አነ ዲሴ አሱኒ ሜያ ዙቴሴሬ ካብሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ኤስታን ኬሴሬ ሀሜፌት ባሶትና ባሶትና፦ «ሀን አሱስን ክቱታ ወደይ ታቶክ ካቱኒ እሳ ዉዛነ ኣነ ዛጉዌዋ» ይት ዎሉምሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","አግርጳ ደይ ፍስቶስኒን፦ «ሀን አሱስ፦ ቀሳርንክ ይግባኝ ኡ ሻክ ስንፋናነ ባክ ኮታና ካባዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ሜርኬብክ ኢጣልያ ሀማንክ ዎናስ ካቶባሴ ጳዉሎስኒንናዋ ኦም ታቶኒ ሜያኖንና፤ ታቶሳ ታቶኒ ሜያ ታርኦሳክቶኒስኒ እሳ ዩልዮስ ይስቴ ት ሜኒ ጋኝኛስክ ታሜ እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ኢስያኒ ባርስ ሀእታ ፋሴ ዎደቢሲክ ሀሚፋ አድራምጥዮኒ ሜርኬቢስ ዲራ ሀሚን። ቴሴሎንቀክ ፌፌ ሜቀዶኒያኒ ዳኒ አሱ ስና አሪስትሮኮስ ደይ እኖኔን አነ ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ዎኖትር ዎኖ ስዶና ሀማ ካርን፥ ዩልዮስ ጳዉሎስኒክ ኬናሽቴፋት ጳዉሎስ ሀሜ ዞሞባስኪን ባርኪ ሾልስ አሪጋሱ ኤጴ ዮናክ ፍቃድ እሚ። ");
INSERT INTO jnje_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ኤስታን ካብራ ስሩስ ኤክ ስኒስታክ ስርት ፋር ስንና ቦርአ ባርስ ጋነሲ ኩን ዳ ኮጲሮስኖን ቴቴራ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ቅልቅያነዋ ፕንፍልያነ አሲ ቴሻ ፋ ባሪሶን ፍንኔን ኦርፎ ልቅያክ ፋ ሙራ ይስቴፋ ካታማስ ካርን። ");
INSERT INTO jnje_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ኤስታክ ት ሜኒ ጋኝኛስ እጣልያ ሀማ እስኪንድርያኒ ሜርኬብ ዳንነ ባርስ ዱኒክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ሾዎ ዎና ንቢ ንቢ ኩትራ አካማ ራኮክ ቀንዶስ ይስቴፋ ካታማስ ካርን። ስሩስ ኤክ ስና ሀሚኖይንማቶ ካልና ቦርአ ስልሞናኒ ቴሻ ካሞ ኣታ ባርስ ጋነሲ ኩን ዳ ቀርጠስኖን ቴቴራ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","አካማ ራኮክ ቴሽባ ቴሽባሴ ኣትንኔን ኦርፎ ላስያ ይስቴፋ ካታማስ ቴሻ ፋ «ማአ ዎደቢ» ይስቴፋ ድማስታ ካርን። ");
INSERT INTO jnje_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ኩትፌን ኩቱኒስ ፋያ ስንና ቦርአናዋ ሶሞን ዎናስ ኣትና ቦርአና ኤስ ካባሲክ ሜርኬብክ ኩቱስ አዳጋ ስንና ቦርአ ጳዉሎስ አሱኒ ሜያክ ኤካ ይ፦ ");
INSERT INTO jnje_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«አሱኒ ሜያነ! ሀንኔን ኤካሎክ ፋ ኩቱኒስ አካማ አዳጋ ፋር ስንናቱ ታክ ቤስቴድፋዋ። ፌቸ ባአሲታናዋ ሜርኬቢስታና ኮእባ ስኖይናሮን አሱኒ ካታኑ አካማ አዳጋነዋ ትሹነ ካርንርዋ» ");
INSERT INTO jnje_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ስኑንታኖ ት ሜኒ ጋኝኛስ ጳዉሎስ ማኬና ባርስታን ሜርኬቢስ ፌ አሱስን አጃጀፌ ባርናዋ ሜርኬቢስ አባንናቱ ኦደድፌር። ");
INSERT INTO jnje_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ኤስ ዎደቢስታ ዬሹሶን ኣቱክ ማጙ ስኒባሲክ ዬሾ ኤስታ የሮክ ኣነ ማእፋ ስንና ቦርአ ሾዎ አሱኒ ሜያ፦ «ሀማ ችምቴፋናነ ካዉዳን አዉግሩክናዋ ዬሽዳን አዉግሩክና ፋ ፌንቀ ይስቴፋ ቀርጠስኒ ዌደብሲክ ካርኤሬ ዬሹሶን ኣቱን» ይሴሬ ማክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ጋሮ ካዉዳን ስሩስ ስርፌን ብየቴይሴ ባሶ ሳፋሬቴስንነ ፋር ስንና ባሶክ ቤስቴፋን ሜርኬቢስ የሮናክ ዛግፋ ባሮን ካቡግሴሬ ሀማክ ካብሴቴ። ዌደቢስታን ካብሴሬ ቀርጠስ ካሞ ቴሽባ ቴሽባሴ አቴ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ስኑንታኖ ዎክኖይፌን «ዬሽዳን አዉኬሳክ እፑዋ» ይስቴ ሁግናባ ፋና እፑዋ ባርስ ጋነያስ ኩን ዳስታኪ ካብራ ባሪሲክ ያ። ");
INSERT INTO jnje_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ሜርኬቢስ እፑዋሲክ ቱግቴራ እፑዋሶን ቱግሬ ሀማክ ኣነ ችማ ስንና ቦርአ ሻክራ እፑዋሲክ ቱግቴት ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","«ቀዳ» ይስቴ ባርስ ጋነሲ ኩን ዳሶን ቴቴራ ሀሚፌን ካባሲክ አካማ ራኮክ ሜርኬቢስ ጎኑኖን ማእስራ ዛታ ሜርኬቢሶን ፉኦክ ችምኒ። ");
INSERT INTO jnje_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ሜርኬቢስ ዲሴ ባሶ ጎኑሶን ሀጝ ሜርኬብሲክ ዛቴ ክሴቴኔን ኦርፎ ሜርኬቢስ ብራቶኖን ጋዱክ ታርኤሴቴ። ሜርኬቢስ፦ «ሱርትስ» ይስቴ ፉቱኒ ዳስታክ ጋንዶኖይቴማቶ ድግሴፋት ሻራሶን ኬስሴፋቴን ስሩስ ሜርኬቢሶን ካልኒ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","እፑዋስ አካማኖን እኖስታ ችሜት ሀሚና ቦርአ ዎኖትር ዎኖ ሜርኬቢስታ ፌቸ ባኣሶን ኬስሴሬ ባሪስ ሀኡ ኤጴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ኬዝስናር ዎኖ ሜርኬብሲክ ኬን ኮዳሶን ኩሹቤሲሲክ ክሴሬ ሀእሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ሾዎ ዎና አዋ ወደይ ባኩራ ኣነ ቢስቶዋ ስኒባሲክ ስሩስ እኖስታ ችሜት ሀሚና ቦርአ፦ «ሀንኔን ኤካሎክ ኣፋዋ ፉእቶኒ ዉዛ» ይት አብድ ቡግን። ");
INSERT INTO jnje_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","አሱኒ ሜያ ደይ እሳ ሙነ ሙኖይ ሾዎ ዎና ዲሴቴ። ኤስ ባሪ ቦርኣ ጳዉሎስ ባሶ ጋነያስ የሬፋት ኤካ ይ፦ «አሱኒ ሜያነ! ታ ማኬና ባሮን ኦደራ ቀርጠሱን ካቡ ቤየት ስንፋናነ ሀን አዳጋሴዋ ትሹሴ ንቶስታ ካርአና ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ሀሽኑ ሀን ሜርኬቢስ ባር ባርቱ ሚርአሞንታኖ ንቶስኒ ኦኑ ትሹንር ኣፌዋ። ኤስ ባሪ ቦርኣ ‹ሀሬዋ ድጎትታዋ› ይት ንቶትን ችኒፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ኣታ ዋላሲክ ባርር ስና ታ ሺጴፋና ሀኦሲ ዎስና ዎስባስ ቴሽና የሬፋት፦ ");
INSERT INTO jnje_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹ጳዉሎስኖ! ድጎታታዋ፤ ቄሳርን ስና የሮታክ ሾልሱዋ። ነኔን አነ ሀሚፌ ባሶትን ደይ ዙትራ ሀኦሲ ኔክዋ እያት ክቱኒ ፉኦኒርዋ› ይት ታክ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ኤስ ባሪ ቦርኣ አሱኒ ሜያነ! ድጎትታዋ! ታክ ማኬና ባሮን ዙታምባሴ አሲን ዛጉናማቶ ሀኦሲክ አማነፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ስኒፋናክኑ ስሩስ እሳ ባሪን ጋነሲ ኩን ዳስ ሀእታ ታማ እኖትን ሀኡና።» ");
INSERT INTO jnje_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","አሲሬ አቼቼ ስንናር ዎኖ ዋልን አድርያን ይስቴ ባርስ ጋነያታ ስሩሲክ ኤክና ሀጝና ቱግቴት ሀሚፌን ዋሲ ዳኒ ክጠስታክ ሜርኬቢስታክ ዎስትኛኒ ሜያ ጎሎ ዳስታክ ካርኤቴነ ፋር ስንና ባሶክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ኤስ ባሪ ቦርኣ ባርስ ትርማኖን ሆስሬ ቢን ጋዱሶን ባርስ ሀእሴቴን አቼቻስር ሜትር ስኒ። ጋሮኖን ፌሴሬ ሄፕሳ ደይ ሆስሬ ብያክ ጋዱሶን ሀእሴቴን ኬዛስር ሜትር ስኒ። ");
INSERT INTO jnje_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ሜርኬቢስ ባርስ ሀእታ ፋ ሹኣስኔን ሄጵቶኖይናማቶ ድግሴፋት ሜርኬቢስ ኦርፎታ ሜርኬቢሶን ዬቱን ዉዛ አቼቾኒ ባሪስ ኬስሴቴ። ኤስታን ዋላስ ዎናናክ ሺጵሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ሜርኬቢሲክ ዎስትኛኒ ሜያ ስሩን ኬሳክ ሾልሴቴ ቦርአ ሜርኬቢሶን ዬቱን ዉዛሶን ኤክ ስናስታ ሀኡኒርነ ፌር ስንነሬ ጎኑሶን ባሪስ ሀእሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ኤስ ካባሲክ ጳዉሎስ ት ሜኒ ጋኝኛስናዋ ታርኦን ሜያኖና፦ «ሀን ሜርኬቢስ ፌሴ ባሶ ሜርኬቢስ ሻክሴሬ ዱ ሻክሴፋቴነ ንቶ ፉእቶክ ኣፋ ችማት ዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ኤስታን ታርኦን ሜያ ጎኑሶን ኤጳ ጋዱሶን ካርኤቴን ጎኑስ አካስታ ኩና ሀማናክ ጋፉክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ዋላስ ዎናናክፋና ካባሲክ ጳዉሎስ ዙታምቤሲሴ ሙ ሙሶነክ ሺጴ። ኤካ ደይ ይ፦ «እሳ ዉዛነ ሙኖይ አፉርንትሴ አሲሬ አቼቼ ዎና ካርትዋ። ");
INSERT INTO jnje_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ኤስ ባሪ ቦርኣ ሙ ሙትክ ሺጴፋዉጙዋ። ኤስ ባር ደይ ካክ ፎትክ ንቶትን ችኑናዋ እሳ ሚርአኑ ንቶስታ ኣፋ ካርአናዉዛ» ይ። ");
INSERT INTO jnje_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ኤስ ባሮን ይናኔን ኦርፎ ቱሻ ኤጴ ዙታምቤሲሴ አሲ ስና ሀኦ ጋላቴፋት ባቴ ሙ ኤጲ። ");
INSERT INTO jnje_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ኤስ ካባሲክ ዙታምቤሲሴ ችማ ዳነሬ ሙ ኤጴ ሜሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ሜርኬቢስ ፌ እንኖ ዙታምኒሴ ሄፕ ትሬዋ ናፉናስሬ እሱነ አሱ። ");
INSERT INTO jnje_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ዙታምቤሲሴ ሜሴሬ ጋዉሴቴኔን ኦርፎ ማርካብስታ ፌቸ ዛጎሶን ባሪስ ሀኡክ ሜርኬቢስ ባአ ካሾናክ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ዎኒፋና ካባሲክ ሀሜ ካርኤቴ ድማሶን ኣነ አሪሶቶ። ስኑንታኖ ፉቱሲ ቴሽታ ፋ ባርስ ቱጎ ዳ ብየቴ። ችምቴፋናነ ሜርኬቢሶን ቱግሬ ኤስታ ካቱክ ሾልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ሜርኬቢሶን ዬትፋ ጋዱሶን ኮቴሬ ባሪስ ጋፉክሴቴ። ኤስ ካባሲክ ሜርኬቢሶን ካልፋ ባር ጋዱሶን ኮቴቴ። ሀጝካሎክ ፋ ሻራሶን ስሩሲክ ደን ቴግሬ ባርስ ሀእታ ካሞ አቴ ኬሳክ ሀሜቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ስኑንታኖ ሜርኬቢስ ቱልቴራ ድ ፉቱስታ ሄጵቴና ቦርአ ዬት ቱክና ሸልግቴ። ሜርኬቢስ ስኒባሲክ ፉቱሲ ኬጃ ዲና ቦርአ ሾርኮ ቤይ። ስኑንታኖ ኦርፎባስ እፑዋስ ቱጉታን ካብ ቾዋ ሜስቴት ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ታቶኒ ሜያስን እሳርንኑ አካስ እቸሬ ኬሴ ትሹኖይናማቶ ታርኦን ሜያ ዎሩክ ሾልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ስኑንታኖ ት ሜኒ ጋኝኛስ ጳዉሎስኒን ፉኦናክ ሾሌና ቦርአ ባሶ ሳፋራሶን ኣነ ኤጴቶዌ። ኤስ ባርስታን አካኒ እቼ ፍና ችሜፌ ባሶ ሜርኬቢስኒ ኬሴሬ ባርስ ፍለፋፌ ዜምሜ ዳስታክ ኬሶነክ አጃጀ። ");
INSERT INTO jnje_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ፉእቴ ባሶ ደይ ሜርኬቢስ ዞዳኖናዋ ሜርኬቢስ ሜስቶኒ ካቶስ ካሞና ኬሶነክ አጃጀ። ኤካክ ዙታምቤሲሴ ማአሪክ ዳስታክ ካርኤቴ። ");
INSERT INTO jnje_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ማአሪክ ዳስታክ ካርንኔን ኦርፎ ኤስ ባርስ ጋነሲ ኩን ዳስ ማልታ ይስቴፋናማቶ አሪን። ");
INSERT INTO jnje_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ኤስ ዳስታክ ፌ አሱኒ ሜያ አካማ ዲንቂ ማኣአ እኖክ ዛግሴቴ። ኤስ ካባሲክ እሮ እችን ኮቸድፋር ስንና ቦርአ ጌያ ሶኬሬ ዙታምኒሴ ቤሱንክ ዛግሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ስኑንታኖ ጳዉሎስ ዋአ ዙትሬ ጌያስ ሀእፌን ጌያስ ጉሙታን ካብ ቾዋ ኡፎ ኬሳ ኩሹባሶን ሳርአ ሄሬቴራ የሬ። ");
INSERT INTO jnje_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ኤስ ዳስታክ ፌ አሱኒ ሜያ ጳዉሎስኒ ኩሹስታ ኡፎስ ሄሬቴራ የሬፌኒ ብየቴይሴ ባሶትና ባሶትና ዎል፦ «ሀን አሱስ ፉቶክ ካ ዎራት የ አሱዋ! ባሪስታክ አካኒ ጉቦስን ናጋክ ኬስፌናክኑ ኦኮ ሀኦሲ ኬኦስኒ አቴ ካክ ፎናክ ኣነ ችሜዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ስኑንታኖ ጳዉሎስ ኡፎሶን ጌያስ ቴብሬ ሀእ። ኡፎስ ሳርአ ባሪን እሳንነ ኣነ ሚርኦዋ። ");
INSERT INTO jnje_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","አሱኒ ሜያ ደይ፦ «ሀሽቱ አቱባስ ዎልሱና ወደይ ጌሬጌሬ ክትሬ ጋንዶና» ይሴት ኦደሴት ፌሴቴር። ስኑንታኖ አካማ ሳአት ኦደሴፌክኑ ባሳስታ እሳ ሚርአ ኣነ ካርአ ስንናማቶ ብየቴይሴ ሳፋራቤሲሶን ሶለሴሬ፦ «ሀን ባር ሀኦዋ» ይሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ኤስ ፋኒ ድማስ ቴሻ ባርስ ጋነሲ ኩን ዳስ አእስኛ ፑፐልዮስኒ ዳ ፋር። ኤስ አሱስ እኖትን ባርኪ ኬር ኤጴ ኬዝ ዎና ማአሪክ እርባስ። ");
INSERT INTO jnje_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ፑፐልዮስኒ አባ ጉምታነዋ ኬን እችነ ሜራን ኩንፌር። ጳዉሎስ ኤስ አሱሲክ ኬር ግሪሬ ኩሹባሶን ታእሬ ሺጴን ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ኤስ ባር ስንናኔን ኦርፎ ባርስ ጋነሲ ኩን ዳስታክ ፌሴፌ ኦም ሜታን ሜያ ዬሴሬ ፋርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ሾዎ እማ ደይ እኖክ ኤጴ ዬሴቴ። ኡልፍንሱቤሲሶን ደይ እኖክ ቤሴቴ። ኤስታን ካብፌኒ ካባሲክ ኡጉኒሲክ ሾልስ ዉዛሶን ሜርኬቢስ ኩኑሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ኬዝ አሳ ዲኒኔን ኦርፎ ኤስ ዬሹሶን ባርስ ጋነሲ ኩን ዳስታክ ኔታ እስኪንድርያኒ ሜርኬቢስ ዲራ ሀሚን። ኤስ ሜርኬቢስታ ድዮስቆሮስ ይስቴ ማኖ ሀኦኒ ግቶ ባርስታ ፋር። ");
INSERT INTO jnje_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ሴራኩሲክ ካታማስ ካርአ ኬዝ ዎና ኤስታ ዲን። ");
INSERT INTO jnje_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ኤስታን ባሪሶን ብራቴራ ሀማ ሬግዩንኒ ካታማ ካርኒ። ኤስታክ እሳ ዎና ኣትንኔን ኦርፎ ካዉዳን ስሩስ ስርና ቦርአ ሄፕስናር ዎኖ ፑትዮሉስ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ኤስታክ አይን ሜያኖን ዳና ባሶኔን አነ ናፉን ዎና ዱኒክ እኖትን ሺጵሴቴ። ኤሴን ኦርፎ ሮም ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ሮሙክ ፌሴ አይን ሜያ እንኖ ዮሶን ኦደሴቴይሴ ሀምማ አፍዩስኒ ጋባስታናዋ ኬዝ ሀኡኒ ድማስታና ካርኤሬ እኖትን ኤጳክ ዬሴቴ። ጳዉሎስ ባሶትን ቢናይሴ ሀኦሶን ጋላቴሬ ንብባሲ ችማ ዳኒ። ");
INSERT INTO jnje_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ሮም ግሪፌን ካባሲክ ጳዉሎስኒን ኦድኒ ታርኦ እምቴን ባር ባር ፎናክ ፍቃድ እምቴ። ");
INSERT INTO jnje_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ኬዝ ዎናኔን ኦርፎ ጳዉሎስ ኤስታ ፌሴ አይሁድኒ ሜኒ ጋይማ ሜያኖን ባርኪ ቴግስ። ባሶ ዙቴሴፌ ካባሲክ ኤካ ይ፦ «አይታሳክቶኖ! ታ እስራኤልኒ ዳራሳታናዋ አባን ሜኒ ቱማስታና ዛግና ማጝሱ እሳ ዉዛነ ኣፋዋ። ስኑንታኖ የሩሳለሙክ ታቴራ ሮማኒ ሜኒ ኩሹስ አቴራ እምቴጝዋ። ");
INSERT INTO jnje_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ሮምን ሜያ ታን ቱንሴቴኔን ኦርፎ ክቱታ ካቱኒ ማጝሱ ኣነ ዳኖቶ ስንና ቦርአ ባክ ኮቶነክ ሳፋርሴቴ። ");
INSERT INTO jnje_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ስኑንታኖ አይሁድኒ ሜያ ባክ ኮትናሶን ቱጋኦቤሲሴ ቀሳርንክ፦ ‹ይግባኝ› ኡናክ ግድ ስኒዋ። ስኒፋናክኑ ዳራታስን ማላቶናክታዋ። ");
INSERT INTO jnje_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ሀሽኑ ንቶትን ቴግስናስ ንቶትን ብያናክናዋ ሀን ባሮን ደይ ንቶክ ማኮናክናዋ። ታ ሀን ሻሻራሲክ ታቴናስ እስራኤልኒ ሜያክ እምቴ አብዲሲክዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ባሶ ደይ ኤካ ይት ዎሉግሴቴ፦ «ዩዳኒ ዳስታኪ ነ ቾዋሲክ ትቼ ትቻ ኣነ እኖክ ካርአዋ። ሀንታ ዬሴ ባሶስኒ ኦኑ ነ ቾዋሲክ ማጙ ዉዛ ዎል ሌር ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ስኑንታኖ ሀን ነ ፋታ ሀይማኖትሶን ዳዳስ አሱኒ ሜያ ቱጋሴፌማቶ አሪፌንዋ። ኤስ ባሪ ቦርኣ ነ ሳፋራስ አዉ ስንናማቶ ኔኪን ኦዶንክ ሾሌፌንዋ።» ");
INSERT INTO jnje_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ዎና ዱስሴሬ ሾዎ አሱ ስንነሬ ባርኪ ኬር ዬሴቴ። ባር ደይ ኤሶን ካብራ ሀማ ዋልን ካርአና ካባኔን ሀኦሲ ታቶኒ ቾዋኖን ማኬ። ባሶትን አማንሱክ ሙሴኒ ቱማሲናዋ ራጁኒ ሜኒ ማፃፋሲና ክስሬ የሱስኒ ቾዋሶን አምማኖን ባሶክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","እሳ እሳ አሱኒ ሜያ ማኬና ካማሶን አማነሴቴ። ስኑንታኖ ኦሚስ ኣነ አማኖሶቶ። ");
INSERT INTO jnje_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ባሶ ደይ ባሶትና ባሶትና ኣነ እሳ ንባ ስኖቶ። ስኒፋናክኑ ኦር ኦር ኬሶኖይ ፌሴቴን ጳዉሎስ ኮእባስታ ኤካ ይ፦ «ኮርቶ አያናስ ራጁ እሳያስኒኪ ካሞ ንቶ አባን ሜያክ ማኬና ባር ፉቶዋ። ");
INSERT INTO jnje_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","« ‹ኤክ ዳራሲክ ሀምፋት፤ ኦዶሶን ኦደሴትር፥ ስኑንታኖ ኣነ ያዳቴሴፌት፤ ብያሶን ቢትር፥ ስኑንታኖ ጋዝግራ ኣነ ቢፌት፤፤ ንብንትስ ደይ ኣነ ኩንስፌት። ");
INSERT INTO jnje_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ሀን ዳራሳ ንባ ሙምዋ፤ ኦዶቤሲስ ደይ ኦየዋ፤ ኣፍቤሲስ ደይ ስሜዋ፤ ኤካ ስና ሻክ ስንፋናነ ኣፍቤሲሲክ ብየሬ፤ ኦዶቤሲሲክ ኦዴሬ፤ ንቤሲሲክ ያዳቴሴሬ ታክ ዎልሴቴን፤ ታ ደይ ባሶትን ፋቱና ካባዋ› ይ። ");
INSERT INTO jnje_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«ኤሴ ሀን ሀኦሲ ፋቱኒ ዎስያ አዛብኒ ሜያክ ዎስቴናማቶ አሩትዋ። ባሶ ደይ ማእ ይሴሬ ኤጴቶሶነ» ");
INSERT INTO jnje_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ጳዉሎስ ኤስ ባሮን ማኮባሴ አይሁድኒ ሜያ ባሶትና ባሶትና አካማኖን ዌኤንሴት ኬሴ ሀሜቴ ");
INSERT INTO jnje_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ጳዉሎስ ክራ ኤጵና ኬያስ ሄፕ ዎግጋ ድ። ባርኪ ኬር ዬሴፌ አሱኒ ሜያኖን ዙትሬ ኬባስ ኤጴት ፌር። ");
INSERT INTO jnje_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ኦኑ ባሪን ካልኖይናሮን ሀኦሲ ታቶኖን ማኬት ዳም የሱስ ክርስቶስኒ ቾዋሶን ድጋ ፎንቶኖን አሲት ፌር። ");
INSERT INTO jnje_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ክርስቶስ የሱስኒ ዎስትኛ ደይ ዎሲ ስናናክ ቴግቴሬ ሀኦሲ ምስራቹኒ ካማኖን ማኮናክ ኮርቴሬ ፌ ጳዉሎስኒኪን ዎስቴ ዎስያ። ");
INSERT INTO jnje_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ኤስ ምስራቹኒ ካማስ ሀኦሲ ራጁኒ ሜያኪ ካሞ ኮርቶ ማፃፋሲክቶሲ ዜምሜ እምና አብድን ካማስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ኤስ ምስራቹኒ ካማስ ሀኦሲ ና አሻክ ዳዊትኒ ዛላስን ኮንቶባሶንቱ ማኬፋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ኤሲስማቶ ደይ ዳምኒ የሱስ ክርስቶስ ኮርቶ አያናክናዋ አካማ ሁግናክና ክቱን ካቡባሲክ ሀኦኒ ና ስንባስ አርቴ። ");
INSERT INTO jnje_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ክርስቶስኒ ሱናሲክ አዛብኒ ሜያ ዙቴሬ አማኖሶነክናዋ አጃጃሞሶነክና ዛጉክ ባርኪ ካሞ ዎሲ ስንነ ቴግቶኒ ሀኦኒ ኦትማ ዳናኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ንቶ ደይ የሱስ ክርስቶስኒር ስናትክ ሀኦሲ ቴጌና አዛብኒ ሜያስን እሳይስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ኤስ ባሪ ቦርኣ ሀኦሲክ ሹንቴሬናዋ ባሪ ኮርቶ ዳራ ስናትክ ቴግቴሬ ፌ ሮማንኪ አሱኒ ሜያክ ዙቴሬ፦ አባን ስና ሀኦስ፤ ዳም የሱስ ክርስቶስኒ ኦትማሴዋ ናጋሴ ንቶክ ስንፋውጝ። ");
INSERT INTO jnje_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ንቶ አማንቶሲ ዎላ ሀን ዳስታክ ዙቴራ ኦድቴና ቦርአ ዙታምባሴ አሲስታን ዜምማ የሱስ ክርስቶስኒኪ ካሞ ዙታምኒቲሴ አሲክ ሀኦናሶን ጋላቴፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ዎንና ዎንና ሺጴት ፋናማቶ ናሳ ቾዋኖን ማኬፋ ምስራቹኒ ካማሶን ማኮክ ቱማ ንብናሲክ ዎስቴፋና ሀኦሲ ታክ ዛላዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ሀሽ ደይ ኮእባስታክ ንቶኪ ዮናክ ሀኦሲ ፍቃድ ስንና ኡጉናስ ካናናክ ዎንና ዎንና ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","አማንቶክ ችምማ ፎትክ ዛጉኒ አያናኒ እማ ንቶክ ሃአናክ ንቶትን ብያናክ ካልቴንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ኤሲስ ደይ ታ ንቶ አማንቶሲክ ንቶ ደይ ታ አማንቶሲክ እኖትና እኖትና ዎል ችማኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","አይታሳክቶኖ! ኦም አዛብኒ ሜኒ ጋነያሲ ሾዎ አማኝኒ ዳንናይሲማቶ ንቶ ጋነያስን ደይ አማኝኒን ዳናናክ ሾሌት ፋናርዋ። ስኑንታኖ ንቶኪ ዮናክ ሾዎ ዎና ሆሬራ ኬስና ሀሽኔን ካርአ ታክ ስና ቤይናማቶ አሩትክ ሾሌፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ግሪክኒ አሱ ስና ባሶትናዋ ግሪክኒ አሱ ስኖይ ባሶትና፥ አሪ ባሶትናዋ አሩኖይ ባሶትና አሲክ ማኮናክ አዳራ ታይስታ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ኤስ ባሪ ቦርኣ ሮሙክ ፌሴ ንቶክ ምስራቹኒ ካማሶን ማኮናክ አካማኖንቱ ሾሌጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ታ ምስራቹኒ ካማሲክ ኣፋ ኢቾናዉዛ። ምስራቹኒ ካማስ ዜምማ አይሁድኒ ሜያክ ደይ አዛብኒ ሜያክናዋ፤ ኤሲስማቶ ደይ አማነሴፌ ባሶትን ዙትራ ፋቱክ ችምኒ ሀኦኒ ሁግናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ኦኮስ አማንቶክቱ ካ ዳናና ይስቴራ ትቼዋ። ሀኦሲ ኦኮ ደይ ምስራቹኒ ካማሲክ አምማኖን ኬሳ ቤስቴና ቦርአ ቴሱስታን ካብራ ሀምማ ኮእባ ካርአና ካባኔን አሱ ኦኮ ስናናስ አማንቶክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","አሱኒ ሜያ ማጙቤሲሲክ ፉቶስ አርቶኖይናማቶ ዛግሴፌ። ሀኦሶን ድጎ ቤዮቤሲሲክናዋ ማጙቤሲሲ ቦርአና ዙታምቤሲሴ አሲስታ ሀኦኒ ግኢአ ሳማን ዮኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ባሶትን ኬኡናስ ሀኦሲ ቾዋኖን አርሶነክ ሾልሲ ባሮን ሀኦስ ባሶክ አምማኖን ቤስን አርሴሬ ፌሴቴር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ሀን ዳስ ቴስቴናኔን ካብራ አሱኒ ሜያክ ቤስቶኖይ ሀኦሲ ሃላ ኮእባ ፎንቶ ሁግናባሴዋ ባር ሀኦ ስንባሴ ቴስና ቴስቶስኪ ካሞ አምማኖን ኬሳ ቤስቴና ቦርአ አሱኒ ሜያ ማጝስሴፌ ማጝሱሲክ ቴቶነ ዉዝቤስ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ባሶ ሀኦሶን አርሴሬ ፌሴፌት ባር ሀኦ ስንባሲክ ሾልሱ ኡልፍንነዋ ጋላትነ ባርክ ኣነ እሞሶቶ። ሳፋራቤሲሲክ ኬእኖር ስንነቴ። ያዳቶኖይ ንብቤሲስ ደይ ታልሜ። ");
INSERT INTO jnje_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","«ቴቹምኒ ፋር» ይሴፌት ጎዋ ስንነቴ። ");
INSERT INTO jnje_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ኮእባ ፎንቶ ሀኦሶን ኡልፍንሱስታን ኣትኒ ዉዛ ስንና አሱኒ ግቶክ፥ ካሳክ፥ አቼች ዎቾባ ፋና ዋጋክ ወደይ ዳስታ ቦኮቴፋ ቴስቶሲ ግቶክ ዎሱስቴ ሱራሲክ ኡልፍና እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ኤስ ባሪ ቦርኣ ባሶትና ባሶትና ባሶ አሻስታ ኢቹ ዉዛ ዛግሶነክ ሀኦስ ኪናክ ቱማ ማጙ ኤናንቶቤሲሲክ አጃጃሞሶነክ ኣትራ ባሶትን እሚዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ኤስ ባር ደይ ስንናስ ሀኦሲ ፉቶኖን ኤሻክ ሶልሴሬ ቴሲ ባሮን ቤይፋት ቴስቶሶን ሀኦ ዛግሴሬ ሺጵሴቴ ቦርአናዋ ባርክ ደይ ዎስቴሴቴ ቦርአናዋ። ስኑንታኖ ሀኦስ ኮእባ ፎንቶኖን ጋላታምቶዋ። ኣሚን። ");
INSERT INTO jnje_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","አሱኒ ሜያ ኤስ ባሮን ዛግሴቴ ቦርአ ሀኦሲ ባሶክ ስኖይ ኢቹ ኤናንቶቤሲሲክ ኣትራ እሚ። ማሽካ አሱቤሲሲክቶ አርቴራ ፋ ኣርቃሱስኔን አነ ኩኑሶን ቤይፋት አርቶኖይ ኡግናክ ሶልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ኤሲስማቶ ደይ ኣርቃሱኒ ሜያ አርቴራ ፋ ማሽካሱስኔን ኩኑሶን ቤየ ባሶትና ባሶትና እጋክ ኪቼሴቴ። ኤስ ባሪ ቦርኣ ኣርቃሱኒ ሜያ ኣርቃሱስኔን ኢቹ ዉዛ ዛግሴቴ። ኤስ ማጙ ዎስቶቤሲሲክ ሾልሲ ኬኦ ባሶስታ ካርእን ኤጴቶሶነርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","አሱኒ ሜያ ሀኦሶን አሩክ ሾሎ ቤየቴ ቦርአ ኢቹ ዉዛ ዛግሶነክ ሀኦስ ኬእኖይ ካኑክ ባሶትን ኣትራ እሚ። ");
INSERT INTO jnje_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ኤስ ባሪ ቦርኣ ሚርኦክ፥ ማጝሱክ፥ ትታናክ፥ ኑሩክ፥ ኮናክ፥ ካኒ ዎሩክ፥ ፋሶክ፥ ኤሽሹክ፥ ማጙ ሳፋራክኔን ቱምሜ ፌር ስንነቴ። ኤሲስማቶ ደይ ሀማትር ስኖነ። ");
INSERT INTO jnje_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","አሱኒ ሱና ማጝስር፤ ሀኦሶን ኦምቴር፤ አሱኒን ኡልፍንሱኖር፤ ቤጋንቶ፤ ታነ ፌ አሱ ኣፌ ይር፤ ማጙ ዉዛ ዎስቶ ሾሌር፤ አባ እንቶቤሲሲክ አጃጃሞኖርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ያዳትቤስ ፎንቶ፤ ዉል ቦኬር፤ ኬሽታምቤስ ፎንቶ ኬና ቡዱዋ። ");
INSERT INTO jnje_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","«ኤስ ባሮን ዛግፌ ባሶ ዙቴሬ ክቱሶነክቱ ሾልስፋዋ» ይፋ ሀኦሲ ቱማኖን አሪሴፌት ኤስ ባሮን ዙትሬ ዛግሴፌዋ። ዛጉ ኮእባ ስኖይናሮን ኤሲስማቶ ዛግሴፌ ባሶትን ደይ ችኒሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ኦም አሱኒስታ ማጝሱ ካርፌ ነ ቴትኔሲክ ቴቶታ ዉዝነ ኣፋዋ። ኦም አሱሳታ ማጝሱ ካርፋታ ካባሲክ ቴትኔስታቱ ማጝሱ ካርድፋትዋ። ነ አሱኒስታ ማጝሱ ካርፋት ኤስ አሱስ ዛግፌና ባሮንቱ ነ ደይ ዛግድፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ኤስ ባሮን ዛግሴፌ ባሶስታ ሀኦስ ሾልሱ ማጝሱ ካርፋናማቶ አርፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ኤሴ ሀን አሱሶ! ነ ኤካ ዛግሴፌ አሱኒ ሜያስታ ማጝሱ ካርፋት፤ ባሶ ዛግሴፌ ባሮን ዛግፋታ ካባሲክ ሀኦሲ ማጝሱኒ ካርእስን ኣትታ ኬሳታርነ ፋሮሶ? ");
INSERT INTO jnje_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ወደይ ሀኦስ ማአክ ፋክሬ ኦድባሲ ፋክያ ኔክ ኣታሙባሶን ካሽቶሶ? ሀኦሲ ማእባሶን አሪክስናስ ሀርሙታክ ኔን ዞንሱናክ ስንናማቶ ኣነ አሩዌኖሶ? ");
INSERT INTO jnje_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ኤሴ ነ ሀርሙ ቤይኔሲክናዋ ጢቂ ኤጵኔሲክና ደይ ሀኦሲ ግነዋ ፉቶኒ ማጝሱኒ ካርነ ያፋና ዎኖ ነይስታ ካርኒ ኬኦስ አርኩናክቱ ዛግፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ሀኦሲ እሳርባ እሳርባሲክ ዎስቶባስማቶ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ማአ ዎስቶሶን ችሜ ዎስቴት ኡልፍና፤ አዳነዋ ኮእባ ፎንቶ ፎነ ሾልሴፌ ባሶክ ኮእባ ፎንቶ ካ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ስኑንታኖ ባሶ ቴታሲክ ኬእኒ ዉዛ ሾልሴፌ ባሶክ፥ ፉቶሲክ አጃጃሞኖይ ማንጙሲክ አጃጃሜ ባሶስታ ሀኦኒ ግእነዋ ሀኦኒ ማጝሱኒ ካርነ ዮና። ");
INSERT INTO jnje_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ማጙ ዉዛ ዛግሴፌ አይሁድኒ ሜያስታ ስኑን አዛብኒ ሜያስታ ሻናነዋ ራኮነ ዮና። ");
INSERT INTO jnje_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ስኑንታኖ ማአ ዉዛ ዎስቴሴፌ ባሶ አይሁድኒ ሜያክ ስኑን አዛብኒ ሜያክ ጋላታ፥ ኡልፍንናዋ ናጋነ እምቶና። ");
INSERT INTO jnje_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ሀኦ አሱኒ ሜኒ ጋነሲ ኣነ ኮሪፋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ሙሴኒኪ ካሞ እምቴ ቱማቤስ ፎንቶ ቦርአ ዎስቴሴፌ ባሶ ዙቴሬ ሙሴኒኪ ካሞ እምቴ ቱምቤስ ኣፋ ስንፋናክኑ ትሽሴቴርዋ። ስኑንታኖ ቱማቤስ ፌን ቦርአ ዎስቴሴፌ ባሶስታ ኤስ ቱማስማቶ ማጝሱ ካቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ኤስ ባሪ ቦርኣ ሀኦሲ ስናክ ኦኮ ስኒስ ቱማሶን ኦዴሬ ዎስቶታ ፌሽፌ ባሶቴኖ ኦዴሬ ዎስቶታ ፌሹኖይ ባሶቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ሙሴኒኪ ካሞ እምቴ ቱምቤስ ፎንቶ አዛብኒ ሜያ ቴስቶቤሲሲክ ቱማስ አጃጀፋና ባሮንቱ ዛግሴፌ። ኤስ ባሪ ቦርኣ ቱማቤስ ትሽፋናክኑ ንብቤሲስ ፋ ቱማሲክ ዛግሶነክ ሾልስ ባሮን አሪሴቴር። ");
INSERT INTO jnje_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ኤስ ባር ደይ ቤስፋናስ ቱማስ አጃጀፋና ባር ዙቴራ ባሶ ንብባሲ ፋር ስንባሶንዋ። ደይ ካኑቤሲስ ዛላ ማኬርዋ። እሳ እሳ ዎኖ ካኑቤሲስ ባሶትን ዌኤርዋ፤ እሳ እሳ ዎኖ ደይ ኣነ ዌኤፋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ኤስ ባር ደይ አምማኖን ኬስሳ ቤስቶናስ ሀን ማኬፋና ምስራቹኒ ካማሲክ ሀኦስ ክርስቶስ የሱስኒኪ ካሞ አሱኒ ሜያ ዎስቴሴፌ ኣቾ ዉዛስታ ማጝሱ ካርፋና ዎኖዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ነ ደይ፦ «ታ አይሁድዋ» እያት ቱማሲክ ቴቴፋት። ሀኦሲር ስኔሲክ ደይ ጌእፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ነ ሀኦሲ ፍቃድኖን አሪታር። ቱማሶን ደይ አሪታር ስንና ቦርአ ማአሮን ዛጉሶን አርታርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ታ፦ «ኣፍትሹኒ ሜያኖን ዞንስናር፤ ታልማሲ ፌ ባሶክ ደይ ቻሬፍዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","አሩኖይ ባሶክ ሌጅ እምናር፤ ዳጋ ናንጎታሶን አስሲናርዋ» ይፋት። ኤሲስማቶ ደይ፦ «ቱማሲ አሩክናዋ ፉቶክና ቱምማ ፋናርዋ» ይፋት። ");
INSERT INTO jnje_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ኤካ ኦሚስን አስፋት ነ ቴታሶን አዉኒ ቦርአ አስሱ ቤይትሶ? ነ፦ «ዊሶትታ» ይፋት ዊሴፋቶሶ? ");
INSERT INTO jnje_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ነ፦ «ጌርኬሳትታ» ይፋት ጌርኬስፋቶሶ? ነ ኮእሎሶን ኦምቴፋት ቤቴሜቅደሲሶን ቦኤፋቶሶ? ");
INSERT INTO jnje_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ነ ሀኦሲ ቱማኖን አሩክ ጌኢት፤ ስኑንታኖ ባር ቱማሶን ቦኮክ ሀኦሲክ ኡልፍና ኣነ እምፌ። ");
INSERT INTO jnje_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ኤሲስ ደይ፦ «ንቶ አይሁድኒ ሜኒ ቦርአ ሀኦሲ ሱና አዛብኒ ስናክ ሜቸፋ» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ሃርኮኒ ኩናስ ዋግባ ፎናስ ቱማሶን ዛግታር ስንፋናነዋ። ስኑንታኖ ቱማሶን ቦኬታር ስንፋናነ ሃርኮ ኩንኔስ ሃርኮ ኩኖይታር ስንናቱ ፋድቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ኤስ ባሪ ቦርኣ ሃርኮ ኩኖይ አዛብኒ ሜኒ ኬንሲ ቱማሲ አጃጅኖን ዛጊር ስንፋናነ ሃርኮ ኩኑ ቤይባስ ሃርኮ ኩኒ ስንናታኖሶ ፋድቶናሪ? ");
INSERT INTO jnje_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ነ ትቼራ ፋ፤ ቱማነ ፌን ደይ ሃርኮ ኩናር ስንፋት ቱማሶን ቦኬር ስንፋታነ አሻክ ሃርኮ ኩኖይ ስንፋት ቱማሶን ዛግፌ አዛብኒ ሜኒ ኬኒስ ነይስታ ማጝሱ ካርእኤቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ኤሴ ሱናክ አይሁድ ስና ባር ፉቶኒ አይሁድቴዋ። ኤሲስማቶ ጌሮክ ቢስቴፋ አሽኒ ሃርኮኒ ኩኑስ ፉቶኒ ሃርኮኒ ኩኑታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ፉቶኒ አይሁድ ስካሎባሲክ አይሁድ ስና ባርዋ። ፉቶኒ ሃርኮኒ ኩኑስ ሀኦኒ አያናክ ስንፋ ንብኒ ሃርኮኒ ኩኑታኖ ቱማሲ ትቼናስማቶ አሽኒ ሃርኮኒ ኩኑስታዋ። ኤስ ኤፌቴና አሱስ ደይ ጋላታ ኤጴቴፌናስ ሀኦስኪንታኖ አሱኒኪንታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ኤኪን አይሁድ ስናስ አዉ ኬእንሪንሶ? ሃርኮኒ ኩኑስ ዋግባ ኣምባንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ፉቶሲክ አይሁድ ስና ሾዎ ኡግናክ ኬአርዋ፤ አሪክ ቾዋስ ሀኦሲ ካምባሶን አይሁድኒ ሜያክ አዳራ እምባስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ኤኪን አይሁድኒ ሜያስን እሳ እሳ ሜያ አማንቶቤስ ፎንቶ ስንነፋቴነ ባሶ አማኖ ቤያስ ሀኦሲ አማናምቶኖን ዋግባ ቱሩክሱንሮሶ? ");
INSERT INTO jnje_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","እሳንነ ኣፋ ቱሩክሱና ዉዛ! «ካምኔስታን ካቢ ቾዋ ነ ፉቶ ስናታዋ፤ ጉማኔስን ደይ ማላቴራ ዳዎታዋ።» ይስቴራ ትቼናስማቶ አሱ ዙቴሬ ኤሽኛ ስንፌናክኑ ሀኦስ ፉቶ ስኑንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ስኑንታኖ እንኖ ማጝሱስ ሀኦሲ ኦኮኖን ቤሱኒር ስንፋናነ አዉ ኡንሪንሶ? ሀኦስ እንኖ ማጝሱሲ ቦርአ እኖትን ኬእፋናነ ባር ፉቶኒ ማጝሱ ኣነ ካርፋ ኡኖሶ? ሀን ባሮን ማኬፋናስ አሱኒ ሳፋራንማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","እሳንነ ኤካታዋ፤ ኤካ ስንፋናነ ሀኦስ ኣካክ ሀን ዳስታ ማጝሱ ካርኒሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ስኑንታኖ ታ ኤሽኛ ስናስ ሀኦሲ ፉቶኖን አምማኖን ቤስራ ኡልፍንባሲ አሪኩኖን ቤሱኒር ስንፋናነ ኤኪን ታ ቦርእኛኒማቶ አዉኒ ቦርአ ታይስታ ማጝሱ ካቶኒሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","እሳ እሳ አሱኒ ሜያ፦ «ማአ ዉዛ ዳናኒክ ማጙ ዉዛ ዛጉኒዋ» ይራ አስሲናርነ ፋሮን ዛግሬቱ ታን ማላቴሴፌዋ። ኤስ ባሪ ቦርኣ ኤስ ኤፌቴና አሱኒ ሜያስታ ካቶኒ ማጝሱስ ልኪዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ኤኪን እንኖ አይሁዲስ አዛብኒ ሜያስታን ደናሎ ስንኒ ኡኖሶ? እሳንነ እንዳነዋ። አሱኒ ሜያ ዙቴሬ አይሁድ ስኖቶ ኣዛብ ስንነፌክኑ ቦርእቤስ ፋናር ስንነቴማቶቱ ዜምማ ንቶክ አስጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ማፃፋሲ፦ «እሳ ኦኮ አሱኑ ኣፌ፤ እሳርንኑ ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ያዳትባ ፌናር ኦኑ ኣፌ፤ ሀኦሶን ሾሌፌር እሳርንኑ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ዙታምቤሲሴ ኡግናስታን ሻቴሴቴ። እሳሪክ ኬእኖር ስንነቴ፤ ማአሮን ዛግፌር ኦኑ ኣፌ፤ እሳርንኑ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","አሱኒ ሚርኦኒ ማጙ ካማ ማኮክ፤ ኖኖቤሲስ ጋቼራ ኩኒ ሞጋነ ፋርዋ፤ ቴሩምቤሲሲክቱ ኤሽሴፌዋ፤ ቴሩምቤሲስ ዎላ ደይ ዛዉኒ ኬዋንማቶ አሱኒ ሚርእኤርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ኖኖቤሲስ ኤርውያክናዋ ሱቃሮክና ቱማ ፋር። ");
INSERT INTO jnje_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ዎቾቤሲስ አሱኒን ዎሩክ ታፕቴር። ");
INSERT INTO jnje_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ኡጉቤሲስታ ትሹነዋ ሻንቱነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ናጋኒ ኡግናሶን ኣነ አርሴፌ። ");
INSERT INTO jnje_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ሀኦሶን ኣነ ድግሴፌ» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ሙሴኒ ቱማሲ አጃጅ ማኬፋናስ ቱማስ ዳካሎ ፌሴ ባሶትን ስንናማቶ አሪፌንዋ። ኤስ ባሪ ቦርኣ አሱኒ ሜያ ኤጴ ማክሶነ ዉዛ ትሽና ቦርአቱ ሻክሴፌዋ። ዳ ዙታምባሴ ሀኦሲ ማጝሱኒ ካርእኒ ስካሎሲቱ ፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ኤስ ባሪ ቦርኣ ኦኑ ሀኦሲ ስና ቱማሶን ዛጉክ ኣፋ ኦኮ ስናናዉዛ። ቱማስኪ ካሞቱ ቦርኣስ አርቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ስኑንታኖ ሀሽ ሀኦስ አሱኒ ሜያኖን ኦኮ ዛጉና ኡግናስ ቱማስ ሾልሱኖይናሮን አምማኖን ኬስሳ ቤስቴዋ። ኤሲስ ደይ ሙሴኒ ቱማሲናዋ ራጁኒ ሜያክና ዛላ ማክቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ኤስ ባሪ ቦርኣ ሀኦስ እሳ ኮሩባ ፎንቶኖን የሱስ ክርስቶስኒክ አማነፌ ባሶ ዙቴሬ ኦኮ ስኖነክ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","አሱኒ ሜያ ዙቴሬ ቦርአ ዎስቴሴቴ፤ ሀኦሲ ኡልፍና ደይ ባሶስታን ዮእ። ");
INSERT INTO jnje_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ኤስ ባሪ ቦርኣ አሱኒ ሜያ ዙቴሬ ክርስቶስ የሱስ ዛግና ፉሪሲኪ ካሞ ሀኦሲ ኦትማክቱ ባክ ኦኮ ስኖነዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","ሀኦስ የሱስ ክርስቶስኒን ማእአ ዛግራ እምናስ ባርክ አማነፌ ባሶ ዙቴሬ ሀርንባሲክ ቦርእቤሲስ ፋክያኖን ዳኖነክዋ። ሀኦስ ኤስ ባሮን ዛግናስ ፋኪባሲክ ዜሞቲ ዛግቴ ቦርኣሶን ኬኡኖይ ቤይናስ ባሪ ፉቶኒ ማጝሱኒ ካርኣሶን አምማኖን ኪሲራ ቤሱናክዋ። ሀን ነያሲክ ደይ ሀኦ ቴትባሲክ ኦኮ ስንባሶን ቤስናስ የሱስ ክርስቶስኒክ አማነፌ ባሶትን ዙትራ ኦኮ ዛጉባሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ኤኪን ቴቶኒ ዉዝኒ ፋሮሶ? እሳ ዉዛክኑ ቴቶኒክ ኣፋዋ ችማኒዉዛ። ቴቶ ቤያኒስ አዉኒ ቦርአንሶ? ሙሴኒ ቱማሶን ዛግፌኒ ቦርአኖሶ? እንዳነዋ። ስኑንታኖ አማንቶሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ኤስ ባሪ ቦርኣ ሀኦስ አሱ ኦኮ ስናናክ ዛግፋናስ ባሪ ቱማስ አጃጅኖን ዛግና ቦርአ ስኖይናሮን አማንቶክ ስንባሶንቱ ያዳቴፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ወደይ ሀኦስ አይሁድኒ ሜኒር ኮእባኖሶ? አዛብኒ ሜያክ ደይ ሀኦታኖሶ? ፉቶሲክ አዛብኒ ሜያክ ደይ ሀኦዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ሀኦስ እሳርዋ፤ አይሁድኒ ሜያኖን ስኑን አዛብኒ ሜያኖን አማንቶሲክ ኦኮ ዛጉኒስ ደይ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ኤኪን አማንቶኒ ቦርአ ቱማሶን ሻሮኒር ኡኖሶ? እንዳነዋ፤ ማእሲራ ዛግራቱ ኦዳንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ኤሴ አሻክ አባን ስና አብራሀም ዳኒዋ ኡኒ ዉዛ ኣምባንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","አብራሀም ኦኮ ስንናስ ዎስቶክ ስኒ ስንፋናነ ቴቶና ዉዛ ዳናና ካባዋ። ስኑንታኖ ሀኦሲ ስና ቴቶክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ኮርቶ ማፃፋሲ፦ «አብራሀም ሀኦሶን አማንቴ፥ አማንቶባስ ደይ ኦኮ ስንና ፋድቴ» ይፋታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ዎስቶ ዎስቴፌ አሱ ባርክ ሾልሱ ዎስቶኒ ዋጋሶንቱ ዳኒቴኖ ባክ እምቴ እማታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ዎስቶክ ዳናናዋ ኡኖይ ቦእርኒ ሜያኖን ኦኮ ዛግፋ ሀኦሲክ አማነፋናነ አማንቶባስ ኦኮ ስንናቱ ፋድቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ዳዊት ቴትባሲክ ሀኦሲ ዎስቶ ፎንቶኖን ኦኮ ዛግራ ፋድና አሱስ አዉነ ፋሮን ሱስቶ ስንባሶን ቤሱክ፦ ");
INSERT INTO jnje_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«ማጝሱቤሲስ ‹ፌሹን› ይስቴና ባሶናዋ፤ ቦርቤሲስ ትሽክቴና አሱኒ ሜና ሱስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ዳሚስ ቦርባሶን ፋዱኖይና አሱ ሱስቶዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ኤኪን ዳዊት ማኬና ኤስ ሱስቶስ ሃርኮ ኩነ ባሶክ ኮእባጝዋ ወደይ ሃርኮ ኩንኖይ ባሶክኔኒንሶ? ሃርኮ ኩንኖይ ባሶክኔጝዋ። አብራሀም ሀኦሲክ አማነና ቦርአ አማንቶባስ ደይ ኦኮ ስንና ፋድቴዋ ይንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ኤኪን አብራሀም አማንቶባስ ኦኮ ስንና ፋድቴናስ ኣጌንሶ? ሃርኮ ኩንኖይፌንጝዋ ወደይ ሃርኮ ኩንፋኒንሶ? ሃርኮ ኩንኖይፌንታኖ ሃርኮ ኩናኔንታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","አብራሀም ዜምሜ ሃርኮ ኩንኖይፌን አማንቶባስ ኦኮ ስንና ፋድቴናማቶ አሩና ማላቶ ስናናክቱ ሃርኮ ኩኒዋ። ኤስ ባሪ ቦርኣ አብራሀም ሃርኮ ኩንኖይ አማኖኒ ባሶክናዋ አማንቶቤሲስ ኦኮ ስንና ፋድቶና ባሶ ዙታምቤሲሴ አሲክና አባዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ኤሲስማቶ አብራሀም ሃርኮ ኩነ ባሶክ ደይ አባዋ። ሃርኮ ኩነ ባሶክ አባ ስንናስ ደይ ሃርኮ ኩነቴ ቦርአ ኮእባ ስንኖይናሮን ባር ሃርኮ ኩንፌና ካባሲክ ፋ አማንቶባሲክ ዞኑስቴሴፌ ባሶክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","አብራሀምኒክናዋ ባሳ ዛላሲክና ሀን ዳሶን ዋራሶናክ ሀኦስ አብድ እምናስ አማንቶክ ዳና ኦኮሲክታኖ ቱማሶን ዛግና ቦርአታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","አብዲሶን ዋራሶኒስ ቱማሶን ዛግ ባስሶ ስንነፋቴነ አማንቶስ ዋግባ ኣፋ ፎና ዉዛ። አብዲስ ደይ ዋግባ ፎንቶቱ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ቱማስ ሀኦኒ ግእአቱ ኤጳ ያፋ። ስኑንታኖ ቱማ ትሽፋናነ ቱማሶን ዛጉኖይ ኣትቴ ኬሳ ኣፋ ፎና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ኤስ ባሪ ቦርኣ አብዲ የሬናስ አማንቶስታዋ። ኤስ አብዲስ ደይ አብራሀምኒ ዛላ ዙትራ ሀኦሲ ኦትማክ እምቴር ስንባስ ኤስ ባርክ አርቴዋ። ኤሲስ ደይ ቱማሲክ ዞኑስቴፌ አሱኒ ሜያክ ኮእባ ስንኖይናሮን አብራሀምኒስማቶ አማነ ባሶ ዙታምቤሲሴ አሲክዋ። ኤስ ባሪክ አብራሀም እንኖ ዙታምኒሴ አሲክ አባዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","አብራሀምኒ ቾዋሲክ፦ «ኔን ሾዎ አሱኒ ዛላክ አባ ዛግንዋ» ይስቴራ ትቼዋ። ኤስ አብዲስ አብራሀምኒክ እምቴናስ ክት አሱኒ ሜያኖን ክቱኒ ካብግፋ ሀኦስክናዋ ፎንቶሶን ፋር ዛግፋ ሀኦሲክና አማነና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","አብራሀም ዛልኔስ አካማኖን ሾዎና ይስቴራ ማክቴናስማቶ ሾዎ አሱኒ ዛላክ አባ ስናናክ አብድክ አማነናስ እሳ አብድ ዛጉክ ችምቶኖይና ዉዛሶጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","አብራሀም ዎጋባስ ትያ ካርአ ፋር ስንና ቦርአ አሽባሲክ ሆፕሬ ክቱነ ፌር ስንነ ፌር። ኮኑክ ደይ ኣፋ ችማናዉዛ ስንናማቶናዋ አሱባ ሳራ ደይ ኣፋ ኮኑና ዉዛ ስንናማቶና አሪፌናክኑ አማንቶባሲክ ኣነ ሆፑዌ። ");
INSERT INTO jnje_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","አማንቶባሲክ ዛግ ስንነቱ ሀኦሲክ ኡልፍና እሚቴኖ ሀኦስ እምና አብዲሲክ እሳንነ ኤክ ሀጝ ኣነ ኡዌ። ");
INSERT INTO jnje_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ሀኦስ ባር እምና አብዲሶን ዛጉኒር ስንናማቶ ቱማ ንባክ አማነሬ ፌር። ");
INSERT INTO jnje_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ኤስ ባሪ ቦርኣቱ አብራሀምኒ አማንቶስ ኦኮ ስንና ፋድቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ስኑንታኖ «ኦኮ ስንነ ፋድቴ» ይስቴራ ትቼ ካማስ ትቼናስ አብራሀምኒክ ኮእባ ስኖይናሮን፤ ");
INSERT INTO jnje_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","እኖክኔንጝዋ፤ ዳም የሱስኒን ክቱን ካብግ ሀኦሲክ አማነፌ እኖክ ደይ አማንቶኒስ ኦኮ ስንናቱ ፋድቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ኤስ ዳም የሱስ እንኖ ቦርኣሲክ ክቱክ አቴሬ እምቴሬ እኖትን ደይ ኦኮ ዛጉክ ክቱን ካቢስ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ኤሴ እንኖ ኦኮ ስናሶን ዳንኒስ አማንቶክ ስንና ቦርአ ዳምኒ የሱስ ክርስቶስኒኪ ካሞ ሀኦሲኔን አነ ናጋኒ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ሀን አማንቶክ ዛግራ ፋኒ ሀኦሲ ኦትማሲ ግሪኒስ ባርክ ስንና ቦርአ አብድክ ሀኦሲ ኡልፍናኖን ሃእኤር ስንኒሲክ ቴቴፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ኤስ ባር ባር ስኖይናሮን ሻናሲን ችማ ቤስቴር ስንናማቶ አርኒ ቦርአ ኤጳ ታፌኒ ሻናሲክ ደይ ቴቴፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ፋክያሲክ ፋታናሶን ችምማ፤ ችማስን ደይ አብድ ቤስቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","እኖክ እምቴ ኮርቶ አያናሲኪ ካሞ ሀኦሲ ኬሽታና ንብኒሲ ቱምና ቦርአ እኖክ እምቴ አብዲስ ኣፋ ኢሹና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","እንኖ ሆፕ ስንና ፋኒ ሀኦሲ ዎና ካርፋና ካባሲክ ክርስቶስ ቦርእኒ ሜያክ ክትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ኦኮኒ ኤድደ ክቱኒ አሱኒን ዳና አካማኖን ራኮዋ፤ ስንፋናክኑ ማአ አሱኒ ኤድደ ክቱክ ችምኒ አሱ አዉዛክነ ቤስቶናክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ስኑንታኖ እንኖ ቦርእባሬ የሬ አሱ ስንና ፋኒ ክርስቶስ እንኖ ኤዴስ ክትዋ። ኤስ ባር ደይ ሀኦስ እኖትን ኬሽቴና ኬሽታምባስ አዉነ ፋ አካማ ስንናማቶቱ ቤስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ኤሴ እንኖ ኦኮ ስንኒስ የሱስ ክርስቶስኒ ሀንናሲክ ስንፋናነ ደይ ዳይስራ ሀኦሲ ግእስን ፉእቶክ ችማኒስ ደይ ባርኪ ካሞዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","እንኖ ሀኦሲ ጉማ ስንና ፋኒ ባሪ ናሳ ክቱክ ባርኔን አነ ጋነኒዋ። ሀሽ ሀኦሲኔን አነ ጋነንኔን ኦርፎ ደይ ዳይስራ ባሳ ካሲኪ ካሞ ፋሩኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ኤስ ባር ኮእባ ስኖይናሮን፤ ሀኦሲኔን አነ ጋኖሶን ዳንኒስ የሱስ ክርስቶስኒኪ ካሞ ሀኦሲክ ቴቶኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","እሳ አሱኒኪ ካሞ ሀን ዳስታ ቦርአ ያ። ኤስ ቦርኣሲኪ ካሞ ደይ ክቱ ያ። ኤሲስማቶ ደይ አሱ ዙቴሬ ዎስቴና ቦርእባሲክ ክቱ አሱ ዙታምባሴ አሲስታ ያ። ");
INSERT INTO jnje_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ሙሴኒ ቱማስ እምቶኖይፌን ዜምማ ቦርአ ሀን ዳስታክ ፋርዋ። ስኑንታኖ ቱማስ ትሽፋናነ ቦርኣስ ቦርአነ ፋር ስንና ኣነ ፋድቴፋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ስኑንታኖ አዳምኒስማቶ ቱማሶን ኣታክ ቦርአ ዎስቶኖይ አሱኒ ሜያኖኑ ፉኦኖይናሮን ክቱ አዳምኒስታን ካብራ ሙሴኒኪ ካርአ አሱ ዙታምባሴ አሲስታ ሀእሱኒ ሁግናባ ዳኒዋ። ኤስ አዳም ሀኔንት ዮኒ ክርስቶስኒክ ቤሶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ስኑንታኖ ሀኦሲ ኦትማኒ እማስ አሱሳ ቦርእኒማቶታዋ። እሳ አሱኒ ቦርኣሲክ ሾዎኒ ሜያ ክትሴቴማቶ ደይ ሀኦሲ ኦትማክናዋ እሳ የሱስ ክርስቶስኒኪ ካሞ ቤስቴ ሀኦሲ እማክ ሾዎኒ ሜያክ ዳይስቴራ እምቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ኤሲስማቶ ባክ ሀኦስ እምና ባሪ እማስ ቴሸና ኦትማስ ጋና እሳ አሱሳ ቦርአ ኤጳ ያና ጋናስነ ፋርታዋ። እሳ አሱሳ ቦርአክ እምቴ ማጝሱኒ ካርኣስ ኬኦቱ ኤጳ ያዋ። ሾዎ ቦርኣሲክ ባክ እምቴ እማስ ኦኮ ኤጳ ያ። ");
INSERT INTO jnje_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","እሳ አሱሳ ቦርኣሲክ ክቱ አሱ ዙታምባሴ አሲሳታ ሀእሱኒ ሁግና ዳንናኔን ቱማ ፉእቴ ሀኦሲ እማኖን ኤጴ ኦኮ ስነ ባሶ ዙቴሬ እሳ አሱ ስና የሱስ ክርስቶስኒኪ ካሞ ሜሬሬ ካክ ታትቶሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ኤሴ እሳ አዳምኒ ቦርኣስ ኬኦኒ ማጝሱኒ ካርአ አሱ ዙታምባሴ አሲስታ ኤጳ ያናማቶ እሳ ክርስቶስኒ ኦኮ ዎስቶስ ሾዎኒ ሜያኖን ኬኦስን ብርማዱምማ ክስራ ካ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","እሳ አሱ ስና አዳምኒ አጃጃምቶ ቤያሲክ ሾዎኒ ሜያ ቦርቤሲ ፋናር ስንነቴማቶ እሳ አሱ ስና ክርስቶስኒ አጃጃምቶሲክ ሾዎኒ ሜያ ኦኮ ስኖነዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ቦርአ አሪኩናክቱ ቱማሴ ያዋ። ስኑንታኖ ቦርኣስ አርክናማቶ ሀኦሲ ኦትማ ደይ አካማኖን አርክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ኤስ ባር ደይ ስንናስ ቦርኣስ ክቱስኪ ካሞ አሱ ዙታምባሴ አሲስታ ታቴናማቶ ዳምኒ የሱስ ክርስቶስኒኪ ካሞ ኮእባ ፎንቶ ካ ቤስቶናክ ሀኦሲ ኦትማ ኦኮሶን እማናክ ታቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ኤካ አዉ ኡንስሶ? ሀኦሲ ኦትማ አርኩናክ ቦርአ ዎስቴት ፎንሮሶ? ");
INSERT INTO jnje_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","እንዳነዋ፤ እንኖ ቦርኣሲክ ክትኒ፤ ኤኪን ኣካክ ቦርአ ዎስቴት ፎንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ክርስቶስ የሱስኔን አነ እሳር ስናክ ሀጱክቴ እንኖ ዙቴራ ባር ክትናሲማቶ ክቱባሶን ቤሱክ ሀጱክቶኒሶን ኣነ አሩዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ሀጱክቶክ ባርኔን አነ ካባርቴፌኒ ካባሲክ ባሳ ክቱሶን ቤስኒዋ። ኤስ ባሪ ቦርኣ ክርስቶስ አባሳ ኡልፍናክ ክቱኒ ካብናማቶ እንኖ ደይ ጋድዶ ካክ ፎኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ክቱባሲክ ኤካክ ባርኔን አነ እሳር ስኒኔን ኤሲስማቶ ክቱን ካቡባሲክ ደይ ባርኔን አነ እሳር ስናኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","እኖስታ ሁግና ዳና ቦርኣስ ትሹናክናዋ ቦርኣሲ ቦዝ ስንነ ፎኒስ ፌሻናክና ኩርኡ ቴስቶኒስ ክርስቶስኔን አነ ሱቴናማቶ አርፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ክት አሱ ቦርኣሲ ሀእሱኒ ስካሎስን ብርማዱምማ ኬስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ኤሲስማቶ ክርስቶስኔን አነ ክትፋንነ ባርኔን አነ ደይ ካክ ፎኒማቶ አምነፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ክርስቶስ ክቱን ካቡባሲክ ሄፕሳ ኣፋ ክቱና ዉዛ ስንናማቶናዋ ክቱስ ደይ ባሳስታ ሀእሱኒ ሁግናባ ኣፋ ስንናማቶና አርፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ባር ክትፌና ካባሲክ ቦርአ ባሳስታ ሀእሱኒ ሁግናባ ፎኖይናማቶ ሄፕሳ ደይ ዎሉኖይናማቶ ዛግሬ እሳርጋ ክትዋ። ሀሽኑ ካክ ፌና ፎባስ ሀኦሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ኤሴ ንቶ ክት አሱነ ፋሮን ቦርኣስኒ ኦር ኬሴትማቶናዋ ክርስቶስ የሱስኒኪ ካሞ ደይ ሀኦሲክ ካክ ፋትማቶና ፋዱት። ");
INSERT INTO jnje_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ኤሴ ቦርኣስ ክቱኒ አቱንትስታ ሀእሱኒ ሁግናባ ፎናክናዋ አሽኒ ኤናንቶሲክና አጃጃሜር ስና ንቶትን ዛጉናክ ማእ ኡትታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ኤሲስማቶ አቱንትሲ ብልትኖን ማጙ ዉዛ ዎስቶኒ ኮዳ ዛግራ ቦርኣሲክ አጃጃሞናክ ዛጉትታዋ። ስኑንታኖ ክቱን ካብራ ሀየዉ ስንነትማቶ ዛግራ ቴትንትሶን ሀኦሲክ እምትዋ። አቱንትሲ ብልትኖን ዙትራ ኦኮ ስና ዉዛሶን ዎስቶኒ ኮዳ ዛግራ ሀኦሲክ አጃጃሞናክ ዛጉትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ሀሽ ንቶ ፋሴቲ ፎስ ሀኦሲ ኦቱማኒ ስካሎስታኖ ቱማሲ ዳካሎሲ ስና ቤይና ቦርአ ቦርኣስ ንቶትን ሀእሱናክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ኤካ አዉ ኡንሪንሶ? ሙሴኒ ቱማሲ ስካሎስ ስንኒስ ፌሽፋን ሀኦሲ ኦቱማኒ ስካሎሲ ስንኒ ቦርአ ቦርኣሶን ዎስቶኒ ኡኖሶ? እሳንነ እንዳነዋ! ");
INSERT INTO jnje_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","እሳ አሱኒክ ቦዝባ ስንፋት አጃጃሞክ ቴትንትሶን እምፌቲ ካባሲክ ኤስ አጃጃሜፌቲ አሱሲክ ባሳ ቦዝ ስንትሶን አርሴፌትዋ። ኤሲስማቶ ቦርኣሲክ አጃጃሜፋትነ ክቱ ንቶስታ ኤጳ ዮኒ ቦርኣሲክ ቦዝባይቱ ስናትዋ። ስኑንታኖ ሀኦሲክ አጃጃሜፋትነ ኦኮ ስና ዉዛሶን ዳናትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ንቶ ዜሞ ስናክ ቦርኣሲ ቦዝ ስንናቱ ፋሴትዋ። ስኑንታኖ ሀሽ ኤጳ ታት አሩሶን ንብንትሲ ካሞ አጃጃሞንትሲክ ሀኦሲክ ጋላታ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ቦርኣሲክ ቦዝ ስናስን ብርማዱማ ኬሳ ኦኮ ስና ዉዛሲ ቦዝ ስነትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ታ ሀን ኤካ አሱኒክ ጋሎ ስንና ኖኖክ ማኬፋናስ ንቶ ሳፋራሲ ሆፕታን ካብ ቾዋክዋ። ዜሞ ስናክ አቱንትሲ ብልት ዙቴራ ኪንነዋ ማጙነ አሲ ቦዛ ዛግራ እሜሴትማቶ ሀሽ ደይ አቱንትሲ ብልትኖን ዙትራ ኮርቶ ስናናክ ኦኮሲ ቦዛ ዛግራ እምትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ቦርእኒ ቦዝ ስንና ፋቲ ካባሲክ ኦኮ ስና ዉዛሶን ዛጉትክ ግድንቲ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ኤኪን ኤስ ካባሲክ አሮ ኬኒን ዉዛ ዳንቲሶ? ሀሽ ንቶትን ኢቹኒ ዉዛታኖ እሳ ኬእኒ ዉዛ ኣነ ዳነትዋ። ኤስ ባር ኮእኣስ ደይ ክቱዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ስኑንታኖ ሀሽ ቦርኣሲክ ቦዝ ስናስን ብርማዱማ ኬሳ ሀኦሲ ቦዝ ስንትሲክ ዳናቲ ቡኣስ ኮርቶ ስናዋ። ኤስ ኮርቶ ስናሲ ኮአ ደይ ኮእባ ፎንቶ ካስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ቦርኣሲ ዎስቶስን ቤስቶኒ ዋጋስ ክቱዋ። ስኑንታኖ ሀኦስኪን እምቶኒ እማስ ዳምኒ ክርስቶስ የሱስኒኪ ካሞ ኮእባ ፎንቶ ካስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","አይታሳክቶኖ! ሀን ባሮን ኣነ አሩዌትኖሶ? ማኬፋናስ ቱማሶን አሪፌ አሱኒ ሜያክዋ። ቱማስ አሱኒስታ ሀእሱኒ ሁግናባ ፎናስ አሱ ካክ ፌፌና ካባሲክ ኮእባዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","እሳ ቤሶ ንቶክ ማኮናዋ፤ ግርራ ድ አሱ ቴጎባስ ካክ ፌና ካባሲክ ባርኔን አነ ቱማሲክ ታቴራ ዲርዋ። ስኑንታኖ ቴጎባስ ክትፋናነ ኤስ ታቴና ቱማስን ብርማዱምማ ኬስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ኤስ ባሪ ቦርኣ ቴጎባስ ካክ ፌን ኦምኒኪ ግሪፋናነ ሶሌዋ ይስቴፋዋ። ስኑንታኖ ቴጎባስ ክትፋናነ ባርኔን አነ ታቴና ቱማስን ብርማዱምማ ኬሲ ስንና ቦርአ ኦም አሱኒኪ ግሪፋናነ ሶሌ ኣፋ ኡስቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","አይታሳክቶኖ! ንቶ ቾዋስ ደይ ኤሲስማቶዋ። ንቶ ክርስቶስኒ አቱኒ ብልት ስንነቲ ቦርአ ክቱክ ኦር ኬሳስነ ፋሮን ቱማስን ኦር ኬስትዋ። ኤስ ባሪ ቦርኣ ሀኦሲክ ዎስቶክ ጋና ጋናትክ ክቱን ካብ ክርስቶስኒ ኬን ስንነትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","አሽኒ ፍቃዲሲክ ፋኒ ካባሲክ ቱማስ ካብግፋና ማጙ ኤናንቶሲክ ክቱኒ ጋና ጋናኒክ አቱኒሲ ብልትሲ ዎስቴት ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ስኑንታኖ ሀሽ እኖትን ታርእአ ፋ ቱማስን ክትራ ኦር ኬስኒ ቦርአ ቱማስ ታቶስን ብርማዱምማ ኬስኒዋ። ኤስ ባሪ ቦርኣ ሀንኔን ኤካሎ እንኖሲ ዎስቶኒስ ጋድዶ ስና ኮርቶ አያናሲ ኡግናክታኖ ዜምማቲ ትቼ ኩርኡ ቱማሲ ኡግናክታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ኤሴ አዉ ኡንሪንሶ? ቱማስ ቴትባሲክ ቦርአኖሶ? እሳንነ እንዳነዋ፤ ስኑንታኖ ቦርአ አዉ ስንናማቶ አሩናክ ዛግስ ቱማስዋ። ቱማስ «ኤናንቶታታዋ» ኡ ሻኪ ስንፋናነ ኤናንቶስ አዉ ስንናማቶ አሩና ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ቦርኣስ ቱማስኪን ያ አጃጂሲክ ኡግና ዳና ኤናንቶ ታይሲ ፎናክ ዛጊዋ። ስኑንታኖ ቱማስ ትሽፋናነ ቦርኣስ ክቱ ዉዛዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ዜምማ ቱማስ እምቶኖይፌን ታ ሀየዉ ስንናቱ ፋፋዉጝዋ። ስኑንታኖ ቱማሲ አጃጅ ያናኔን ኦርፎ ታ ክትፋና ቦርኣሲ ካ ዳንኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ካ፤ እማናክ እምቴ ቱማሲ አጃጅ ታይስታ ክቱ ኤጳ ያዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ቦርኣስ ቱማሲ አጃጂስኪ ካሞ ኡግና ዳና ታን ኤሽዋ። አጃጂስኪ ካሞ ደይ ታን ዎሪዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ቱማስ ኮርቶዋ፤ አጃጂስ ደይ ኮርቶዋ፥ ደይ ፉቶነዋ ማአረነዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ኤኪን ሀን ማአር ስና ዉዛስ ታይስታ ክቱ ኤጳ ያ ኡኖሶ? እንዳነዋ! ስኑንታኖ ቦርኣስ ቦርአ ስንና አምማኖን ቤስቶናክ ማአ ዉዛስኪ ካሞ ክቱ ታይስታ ኤጳ ያዋ። ኤሲሲክ ቦርኣሲ አጃጂኪ ካሞ ቦርኣስ አዉነ ፋ ማጙ ስንናማቶ አሪርቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ቱማስ ሀኦስኪን ያር ስንናማቶ አሪፌንዋ። ስኑንታኖ ታ ቦርኣሲክ ቦዝ ስናናክ ኬሴ ዋግቴ አሻ ማዮ አሱዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ታ ዛግፋና ባሮን ኣነ አሪፋትዋ። ሹንፋና ዉዛሶን ዛጉ ሻካቱ ኦምቴፋና ዉዛሶን ዛግጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ኤሴ ታ ዛግፋናስ ዛጉክ ሾሎኖይና ዉዛሶን ስንናኔን ቱማሲ ማአር ስንባሶን አምማኖን ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ዛጉክ ሾሎኖይና ዉዛሶን ዛግፋስ ታይሲ ፋ ቦርኣስታኖ ታቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ታይሲ ወደይ አሽናሲ ፋ ሃላስ እሳንነ ማአ ዉዛ ኣፋ ስንናማቶ አሪፋኒዋ። ማአ ዉዝኒ ዛጉክ ሾሌፋናክኑ ኤስ ማአ ዉዛሶን ዛጉክ ኣነ ችምፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ዛጉናክ ሾሌፋና ማአ ዉዛሶን ኣነ ዛግፋት። ስኑንታኖ ዛጉክ ሾሎኖይና ማጙ ዉዛሶንቱ ዛግፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ዛጉናክ ሾሎኖይና ማጙ ዉዛሶን ዛጊር ስንናኔን ኤስ ባሮን ዛግፋስ ታይሲ ፋ ቦርኣስታኖ ታቴዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ኤስ ባሪ ቦርኣ ኦማ ቱማ ታይስታ ዎስቴት ፋናማቶቱ ቢጝዋ። ማአ ዉዛሶን ዛጉናክ ሾሌፋት ማጙ ዉዛሶን ዛጉናክ ቱግቴፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ስካሎናሲ ሀኦሲ ቱማክቱ ግሬፋን። ");
INSERT INTO jnje_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ስኑንታኖ ካኑናሲ ፋ ቱማስኔን አነ ኔቤፋፋ አቱናሲ ብልትሲ ዎስቴፋ ቦርኣሲ ቱማክ ታቶ ታን ዛግፋ ኦማ ቴስቶኒ ሳፋራ ታይሲ ፋናማቶ ቢጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ታ አዉነ ፋሮን ሚርእአም አሱንሶ? ሀን ክቱሲ ታምፋ አሽናሲን ኦ ታን ፉእኦናክ ችምንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ዳምኒ የሱስ ክርስቶስኒኪ ካሞ ሀኦሲክ ጋላታ ስንፋውጝዋ። ኤሴ ታ ቴትናሲ ካኑክ ሀኦሲ ቱማክ አጃጃሜር ስንፋት አሽናሲ ሃላክ ቦርኣሲክ አጃጃሜር ስንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ኤስ ባሪ ቦርኣ ክርስቶስ የሱስኒክ ፌሴ ባሶ ሀየ ኣፋ ባሶስታ ማጝሱ ካቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ክርስቶስ የሱስኒኪ ካሞ ቤስቴፋ ካ እምፋ ኮርቶ አያናሲ ቱማ ቦርኣስንናዋ ክቱስንና ብርማዱምማ ታን ክስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","አሱኒ ሃላኒ ሆፕታን ካብ ቾዋ ቱማስ ዛጉክ ችምኖይናሶን ሀኦስ ዛጊዋ። ሀኦ ባሪ ናስን ቦርእባ ፋና አሱነ ፌር ዛግራ ቦርኣሲክ ዎሲዋ። አሽባሲክ ደይ ቦርኣሶን ማጝሱ ካርኤ ትሽክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ኤስ ባሮን ደይ ዛግናስ አሽኒ ሳፋራክ ስንኖይናሮን አያናኒ ሳፋራስማቶ ፌፌ እኖኪ ካሞ ፉቶ ስና ቱማሲ አጃጅ ዎስቶታ ፌሻናክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","አሽኒ ሳፋራሲማቶ ፌሴፌ ባሶ አሽኒ ሳፋራሶንቱ ሳፋርሴፌዋ። ስኑንታኖ አያናኒ ሳፋራሲማቶ ፌሴፌ ባሶ አያናኒ ሳፋራሶንቱ ሳፋሬሴፌውኣ። ");
INSERT INTO jnje_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","አሽኒ ዉዛ ስና ባሮን ሳፋሮስ ክቱቱ ኤጳ ያፋውዋ። ስኑንታኖ አያናኒ ዉዛ ስና ባሮን ሳፋሮስ ካነዋ ናጋነቱ እምፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","አሽኒ ዉዛ ስና ባሮን ሳፋሬፌ አሱ ሀኦሲ ቱማክ ኣነ አጃጃሜፌዋ፤ አጃጃሞናክ ደይ ኣፋ ችማናዉዛ ስንና ቦርአ ሀኦሲ ጉማዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","አሽኒ ኤናንቶክ ዞኑስቴሴፌ ባሶ ሀኦሶን ግርሱክ ኣፋ ችሞነ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ስኑንታኖ ንቶ ሀኦሲ አያና ስካሎንትትቲሲ ፋር ስንፋናነ አያናኒ ሳፋራሲክታኖ አሽኒ ኤናንቶሲማቶ ኣፋ ፎቲ ዉዛ። ክርስቶስኒ አያና ባሳስ ፎንቶ አሱ ክርስቶስኒ ኬንቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ስኑንታኖ ክርስቶስ ንቶሲ ፌፋናነ አዉነ ፋሮንኑ አቱንቲስ ቦርኣስታን ካብ ቾዋ ክቱኒር ስኒፋናክኑ ሀኦስ ንቶትን ኦኮ ዛግና ቦርአ አያናንቲስ ሀየዋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","የሱስኒን ክቱን ካብግ ሀኦሲ አያና ንቶስሲ ፋር ስንፋናነ ክርስቶስኒን ክቱን ካብግ ሀኦሲ ንቶስሲ ፋ አያናባስኪ ካሞ ክቱኒ አቱንቲሲክ ካ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ኤስ ባሪ ቦርኣ አይታሳክቶኖ! ግድሱኒ ዉዛ እኖስታ ፋርዋ፤ ስኑንታኖ ኤስ ግድሱኒ ዉዛስ አሽኒ ሳፋራሲክ ፎኒክታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","አሽኒ ሳፋራክ ፋፋትነ ክትቲርዋ። ስኑንታኖ ኮርቶ አያናሲ ሁግናክ አሽኒ ዎስቶኒትሶን ዎራትነ ካክ ፎትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ሀኦሲ አያናክ ዞኑስቴፌ ባሶ ዙቴሬ ሀኦሲ ናንጎታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ኤስ ባሪ ቦርኣ፦ «ኣባ! አባኒሶ!» ይራ ቴጌራ ናዉባ ስናት አያናቱ ኤጳ ታትታኖ ድጋክ ፎክ ሄፕሳ ዎላ ቦዝ ስንኒ አያና ኣነ ኤጳቶዌትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ሀኦሲ አያና እንኖ አያናስኔን አነ ስና ሀኦሲ ናንጎታ ስኒሶን እኖክ ዛላ ማኬፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ኤሴ ሀኦሲ ናንጎታ ስንፋኒነ ባሪር ስና ባሮን ዙትራ ዋራሶንዋ፤ ክርስቶስኔን አነ ደይ ዋራሶኒርዋ፤ ሀሽ ባሳ ሻናሶን ሃኤር ስንፋኒነ ዎሊ ደይ ኡልፍናባሶን ሃኤር ስናንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ሀሽቲ ፋ ሻናስ ሀንኔንቲ እኖክ አምማኖን ቤስቶናክ ፋ ኡልፍናስኔን አነ ሆስፌኒ ካባሲክ እሳ ዉዛኔንኑ ሆሱኒክ ኣፋ ችማኒ ዉዛ ዛግራቱ ፋድፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ቴስቶ ዙቴራ ሀኦሲ ናንጎታኒ አምማኖን ኬስሴ ቤስቶሶንቱ አካማ ካልታናክ ኦድትፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ቴስቶ ዙታምባሴ ኬእኖር ስናናክ ማጝሱ ባሪስታ ካቴዋ። ኤሲስ ደይ ባሪ ቴትን ሹናክ ስኖይናሮን አብድክ ኦዳናክ ዛግ ሀኦሲ ፍቃድክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ኤስ አብዲስ ደይ ቴስቶ ዙታምባሴ ቴትባሲክ ትሹኒ ቦዞስን ብርማዱምማ ኬሳ ሀኦሲ ናንጎታክ ሆሬራ ፋ ብርማዱምማነዋ ኡልፍንነ አሲን ሃኤር ስናናማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ቴስቶ ዙታምባሴ እሳሪክ ሀውጙኔን ካርአ ኬክቶኒ ሜሮክ ኦቴራ ሃነት ፎባሶን አርፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ስኑንታኖ ሃነት ፋ ቴስቶ ባር ባር ኮእባታዋ፤ ቴሱኒ እማ ስና ኮርቶ አያናሶን ኤጴቴ እንኖኑ ደይ አቱኒሲ ፉር ስና ሀኦስ አምማኖን ክስራ ቤሱናክ ፋ ሀኦሲ ናንጎታ ስናሶን አብድክ ኦደት ስካሎኪ አቱኒሲ ሃነቱ ፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","እንኖ ፋሪስ ደይ ኤስ አብዲሲክዋ፤ ስኑንታኖ አብድ ዛግፌኒ ዉዛስ አፋክ ቢስቴር ስንፋናነ አብድ ስንባስ ፌሻርዋ። ኣፋክ ቢስቴፋ ባሮን ኦ አብድ ዛጉኒሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ስኑንታኖ ኣፋክ ቢፌኒ ዉዛሶን አብድ ዛግፋንነ ፋክያክ ኦዳኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ኤሲስማቶ ኣካክ ሺጶኒክ ችማኒማቶ ኣነ አሪፌኒ ስንና ቦርአ ኮርቶ አያናስ ሆፕኒሶን አርጋሱናዋ። ኮርቶ አያናስ ቴትባሲክ ካማክ ዎሎክ ችምኖይኒ ሃኖክ እኖክ ኖኖነፋይዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","አሱሳ ንባኖን ቱእኒራ ቢፋ ሀኦስ ኮርቶ አያናሲ ሳፋራ አዉ ስንናማቶ አሪፋዋ። ኮርቶ አያናስ ኮርቶኒ ሜያክ ኖነፋናስ ሀኦሲ ፍቃድኒማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ሀኦሶን ሹንፌ ባሶክናዋ ባሪ ሳፋራስማቶ ቴግቴ አሱኒ ሜያክና ሀኦሲ ዙታምባሴ አስን ማአሪክ ዛጉናማቶ አሪፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ኤስ ባር ደይ ስናስ ዜምማ አሪና ባሶ ናሳ ግቶኖንናዋ ናስ ደይ ሾዎ አይኒ ሜኒ ጋነያስን ኡዛ ስናናክ ሀኦስ ዜምማ ኮፓኤና ወደይ ቡግና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ዜምማ ኮሪና ባሶትን ቴጌ፤ ቴጌና ባሶትን ኦኮ ዛግ፤ ኦኮ ዛግና ባሶትን ደይ ኡልፍንሲ። ");
INSERT INTO jnje_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ኤኪን ሀን ዉዛሶን አዉ ኡንሪንሶ? ሀኦስ እኖኔን አነ ስንፋናነ ኦ እኖትን ቱጋኦክ ችምንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ሀኦስ ባሪ ናሲክ ኬናሽቶኖይ እኖክዋ እያት ኣትራ እምናኔን ኣካክ ዙታምባሴ አስን ናባስኔን አነ ዋግባ ፎንቶኖን እኖክ እማ ቤይንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ሀኦሲ ኮርና ባሶትን ኦ ማላቶክ ችምንሪንሶ? ኦኮ ዛጉኒስ ሀኦስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ኦንሶ ባሶስታ ማጝሱ ካርንሪ? ክርስቶስ የሱስ ባሶስታ ማጝሱ ካርኒሮሶ? ባር እኖክዋ እያት ክት፤ ክቱን ካብሬ አባ ሀኦሲ ሆእታ ቴሽታ ድ፤ እኖክ ናትፌስ ደይ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ክርስቶስኒ ኬሽታናስታን እኖትን ኦር ክሱናክ ችምኒስ ኦንሶ? ራኮኖሶ? ወደይ ሻናኖሶ? ካቡግቶኖሶ? ወደይ ማክቶኖሶ? አታቱ ስናኖሶ? ወደይ አዳጋኖሶ? ወደይ ሲፎኖሶ? ");
INSERT INTO jnje_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ኤስ ደይ፦ «ነ ቦርአ ዎናሶን ዙትራ ክቱስኔን አነ ኔቤፌንዋ፤ ሹክቶኒ ፋንቱሲክቶኒማቶ ፋድቴፌኒዋ።» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ኤሴ እኖትን ሹና ክርስቶስኒክ ኤስ ዉዛሶን ዙትራ ሜሬራ እኖትን ኔቤራ ሜሬፋ ዉዛ ዙታምባሴ አሲስታን ደናሎ ስናንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ኤስ ባሪ ቦርኣ ክቱስኑ ስኑን፥ ካስኑ ስኑን፥ ሀኦሲ ዎስያኑ ስኑን፥ ሀእሱኒ ሁግናቤስ ፋና ባሶኑ ስኖቶ፥ ሀሽቲ ፋ ባርኒ ስኑን፥ ሀንኔንቲ ዮኒ ባርኒ ስኑን፥ ሁግናባ ፋና ባርኒ ስኑን፥ ");
INSERT INTO jnje_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ቴጋስኑ ስኑን፥ ዳክሶስኑ ስኑን፥ ኣፋ ቴስቶስኑ ስኑን ዳምኒ ክርስቶስ የሱስኒኪን ዳኒ ሀኦሲ ኬሽታናታን ኦር ክሱኒ ዉዛ ኣፋ ስንናማቶ ጋሳሲራቱ ፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ክርስቶስኔን አነ ፋፋትቱ ፉቶሶን ማኬፋንዋ፤ ኣፋ ደይ ኤሻና ዉዛ። ሀኦሲ ኮርቶ አያናክ ዞኑስቴፋ ካኑናስ ደይ ኣፋ ኤሻና ዉዛ ስንናማቶ ታክ ዛላ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","አካማ ሱሞነዋ ኮኡኖይ ራክኮነ ንብናሲ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","አሻክ ኮኒታ ስና እንኖ ሜያክዋ እያት ታ ክርስቶስኒስታን ኦር ኬሳ ሀኦሲ ኤርዊያ ታይስታ ካርፋናነ ሹናና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ባሶ እስራኤልኒ ሜያዋ፤ ሀኦስ ደይ ባሶትን ናንጎትባ ዛጊዋ። ኡልፍንባሶን ባሶክ አምማኖን ክስራ ቤስዋ። ባሶኔን አነ ደይ ቴያ ግሪዋ፤ ቱማሶን ደይ ባሶክ እሚ። ፉቶኒ ሀኦኒ ሺጶሲ ስትርኖን ባሶክ ቤሲ፤ አብድን ካምባሶን ደይ ባሶክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ባሶ ኮንቶቤሲሲክ አሲቴሴሪኒ አባን ሜያኪን ዬሴቴርዋ። ክርስቶስ ደይ አሻክ ዬናስ ባሶ ዛላስንዋ። ባር ዙታምባሴ አሲ ደናሎዋ፤ ኮእባ ፎንቶኖን ደይ ሱስቶ ሀኦዋ፤ ኣሚን! ");
INSERT INTO jnje_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","እስራኤልኒ ዛላ ዙቴራ ፉቶኒ እስራኤልኒ ሜያታ ስና ቤይና ቦርአ ሀኦሲ ካማ ሻርቴዋ ኡታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ኤሲስማቶ ደይ አብራሀምኒ ዛላ ዙቴራ አብራሀምኒ ናንጎታዋ ኡታዋ። ሀኦሲ አብራሀምኒን፦ «ዛልኔስ ቴግቶናስ ይሳቅኒኪ ካሞዋ» ይና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ኤስ ባሪ ቦርኣ አሻክ አብራሀምኒኪን ኮንቴሴቴ ቦርአ ሀኦኒ ናንጎታታዋ። ስኑንታኖ ዛላ ስንና ፋድቶኒስ አብድን ካማሲ ናንጎታስ ኮእባዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ኤስ ባር ደይ ሀኦስ እምና አብድን ካማስ፦ «ሀውጙት ዎግጋ ሀን ካባስታ ኔኪ ዮናዋ፤ ሳራ ደይ ኣርቃ ናኒን ኮጶናዋ» ይፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ኤስ ባር ኮእባ ስኖይናሮን ርብቃ አሲቴሴሪኒ አባን ስና ይሳቅኒን ማኖ ናንጎትንን ናኔርቴፋና ካባሲክ፤ ");
INSERT INTO jnje_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","ሀኦሲ ኮሩ ዎስቶክ ስኖይናሮን ቴጎክ ስንባሶን አምማኖን ቤሱናክ ሄፕ ናንጎቲስ ኮንቶባስኔን ዜምማ ወደይ ማአሮንናዋ ማጙኖንና ዛግሶቤሲስኔን ስናክ ሀኦስ ርብቃክ፦ «አሪክስ ሀቴሲክ ሀኢር ስናናዌ» ይ። ");
INSERT INTO jnje_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ኤሲስ ደይ፦ «ያቆብኒን ሹኒን ስኑንታኖ ኤሳዉኒን ኦምቴን» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ኤኪን አዉ ኡንሪንሶ? ሀኦ ኮሪር ኡክ ችማኒሮሶ? እሳንነ ሀኦሲ ኮሪር ኡክ ኣፋዋ ችማኒዉዛ። ");
INSERT INTO jnje_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ሀኦስ ሙሴኒን፦ «ፌሹን ኡናክ ሾሌና ባሶትን ፌሹን ኡና፤ ኬናሽቶናክ ሾሌና ባሶትን ኬናሽቶናዋ» ይዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ኤሴ ሀን ባር ቤስቴፋናስ አሱኒ ፍቃድክናዋ ዎስቶክና ስኖይናሮን ሀኦሲ ፋክያክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ኤስ ባሪ ቦርኣ ኮርቶ ማፃፋሲ ግጵጽኒ ታቶሳ ቾዋክ፦ «ኔኪ ካሞ ሁግናናሶን ቤሱናክናዋ ሱናስ ደይ ዳ ዙታምባሴ አሲስ አሪቶናክና ዛጉናክ ኔን ታስጝዋ» ይፋ ካማ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ኤስ ባሪ ቦርኣ ሀኦሲ ፋኩናክ ሾሌና ባሶትን ፋኩናዋ፤ ሾሌና ባሶትን ደይ ንቤሲሲ ችማናክ ዛጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ኤስ ባሪ ቦርኣ፦ «ሀኦሲ ፍቃድኖን ኦኑ ቱጋኦክ ኣፋ ችማናዉዛ። ኤኪን ባር አሱኒ ሜያኖን ማጙ ዎስቶቤሲሲክ አዉኒ ቦርአ ዌእኤፋሶ?» ይራ ታን ማምሱታር ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ነ ሀን አሱሶ! ሀኦሲኔን ካራካሮታክ ነ ኦንሶ? ኮዳስ ባሮን ሆእፌ ባሪን፦ «አዉኒሮን ታን ኤካ ዛግራ ዎስቴስሶ?» ኡናክ ችምኒሮሶ? ");
INSERT INTO jnje_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ኮዳሶን ሆእፌ ባር እሳ ቴሳ ሆኣስን እሳ ኮዳሶን ኡልፍናኒር፥ ኦማሶን ደይ ስኖይ ዎስቶታ ፌሻናክ ዛግሬ ዎስቶናክ ማብቲባ ኣፋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ሀኦሲ ግእባሶን ቤሱክናዋ ሁግናባሶን አምማኖን ክስራ ቤሱናክና ሾሌፋት ትሹክ ሆሬራ ፋ ግእኒ አሱሳክቶኒክ አካማኖን ፋኪ ስንፋናነካሶ? ");
INSERT INTO jnje_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ደይ ዜምማ ኡልፍናክ ሆስና ፌሹን ይና አሱኒ ሜያክ ኡልፍንባሲ አሪኩኖን አምማኖን ክስራ ቤሱናክ ስንፋናነካሶ? ");
INSERT INTO jnje_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ፌሹን ይና አሱኒ ሜያ ደይ አይሁድኒ ሜያስን ኮእባ ስኖይናሮን አዛብኒ ሜያስን ደይ ቴጌዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ኤስ ባር ደይ ራጁ ሆሴኒኪ ካሞ ኤካ ይስቴናማቶዋ፦ «ታ ዳራ ስኖይ ባሶትን፦ ‹ዳራታ› ይራ ቴጎናዋ፤ ሹንቶኖይ ዳራስን ደይ፤ ‹ሹንቶ› ይራ ቴጎናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ባሶ ‹ታ ዳራቴ› ይስቴሬ ቴግቴሴቴ ድማስታ፤ ‹ሀየዋ ሀኦሲ ናንጎታ› ይስቴሬ ቴግቶሶነዋ።» ");
INSERT INTO jnje_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ራጁ ኢሳያስ ደይ እስራኤልኒ ቾዋሲክ ኤካ ይት ካምባሶን ቴግሬ ቻግጌ ማኬዋ፦ «እስራኤልኒ ናንጎታስ ፋዳ ባሃሪኒ ፉቱኒማቶ አሪክፋናክኑ ባሶስን ፋሩቶኒስ ጋሮ ሜያ ኮእቤስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ዳሚስ ዎክኖይ ታፕታክ ሀን ዳስታ ማጝሱ ካርአናዋ» ");
INSERT INTO jnje_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ኤሲስማቶ ኢሳያስ፦ «ዙታምባሴ አሲ ደናሎ ስና ዳሚስ፤ እኖክ ዛላ ፉኦ ሻኪ ስንፋናነ፤ ሶዶምኒ ካታማሴዋ፤ ጋሞራኒ ካታማሴ ትሽናስማቶ፤ እንኖ ደይ ትሹኒ ካባዋ» ይት ዜምሜ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ኤኪን አዉ ኡንሪንሶ? ኦኮ ስና ዉዛሶን ዳናክ ዎስቶኖይ አዛብኒ ሜያ ኦኮ ዉዛሶን ዳነቴዋ፤ ኤስ ኦኮ ዉዛስ ደይ አማንቶክ ቤስቴፋ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ስኑንታኖ ኦኮ ስና ዉዛሶን ዳናኒክ ዛግፋ ቱማሲክ ዞኑስቴት ፌ እስራኤልኒ ሜያ ቱማሶን ኦዳክ ኣነ ችሞቶ ስንና ቦርአ ኦኮስኪ ሀምሜ ኣነ ካርኦቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ኤስ ባር አዉኒ ቦርአ ኤካ ስኒሶ? ኦኮ ስና ዉዛሲኪ ሀምሜ ካርአ ቤየቴስ ባሶ ኦኮ ስና ዉዛሶን ዳናክ ሾልሴቴስ አማንቶክ ስኖይናሮን ዎስቶክ ስንና ቦርአዋ። ኤስ ባሪ ቦርኣ ቱሳእሱኒ ሹኣሲክ ቱሳኤሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ኤሲስ ደይ፦ «ኤሴ አሱኒ ሜያኖን ቱሳእሱን ሹአ ፅዮኑክ ዱሱናዋ፤ ኤስ ሹኣስ አሱኒ ሜያኖን ቱሳእስራ ጋንሱኒ ካኦዋ። ባሪክ አማነፌ ባር ኣፋ ኢቾናዉዛ።» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","አይታሳክቶኖ! ንብናሲ ፋ አካማ ካልታናሴዋ ሀኦስኪ ታእስት ፋና ሺጶናሴ እስራኤልኒ ሜያ ፋርሶነክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","አሩስ ልኪ ስና ቤይባስታኖ ባሶ ሀኦሲክ ካምባሲማቶ ፎኒ ኮና ባሶስሲ ፋናማቶ ታ ቴትናሲክ ዛላ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ሀኦስ አሱኒ ሜያኖን ኦኮ ዛጉና ኡግናሶን ኣነ አሩሶቶ ስንና ቦርአ ቴትቤሲስክ ኦኮኒ ኡግናሲክቱ ዞኑስቴቴታኖ ሀኦሲ ኦኮ ኡግናክ ኣነ ዞኑስቶሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","አማነፌ አሱ ዙቴሬ አማንቶክ ኦኮ ስናናክ ሙሴኒ ቱማሲ ክርስቶስኒስታ የሬዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ቱማሶን ኦዳክ ቤስቴፋ ኦኮሲክ ሙሴኒ ማፃፋሲ፦ «ቱማሶን ዛግፌ ባር ዙቴሬ ካክ ፎናዋ» ይፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ስኑንታኖ ሀኦስ አሱኒ ሜያኖን አማንቶክ ኦኮ ዛጉባስ ኤካ ይስቴራ ትቼዋ፦ «ንብኔሲ ኦ ሳማ ኬስኒሪንሶ?» ኡታታዋ። ኤስ ባር ደይ ክርስቶስኒን ኬሱክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ወደይ ንብኔሲ «ትርኦኒ ድማሲ ኦ ኬሮንሪንሶ?» ኡታታዋ። ኤሲስ ደይ ክርስቶስኒን ክቱኒ ካብጉዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ደይ ኤካ ይስቴራ ትቼዋ፦ «ሀኦሲ ካማ ቴሽነቱ ፋዋ። ደይ ኖኖኔሲንናዋ ንብኔሲናቱ ፋዋ» ኤስ ካማስ ደይ እንኖ ማኬፌን አማንቶኒ ካማስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","የሱስ ዳም ስንባሶን ኖኖኔሲክ ዛላ ማኬፋታነናዋ ሀኦስ ባሪን ክቱን ካብግናማቶ ንብኔሲ አማነፋታነና ፋሩታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","አሱ ንብባሲ አማነሬ ኦኮ ስናና፤ ኖኖባሲክ ደይ ዛላ ማኬሬ ፋሩናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ኮርቶ ማፃፋሲ፦ «ባርኪ አማነፌ ባር ዙቴሬ ኣፋ ኢቾናዉዛ» ይስቴናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ኤሴ እሳ ዳሚስ ዙታምባሴ አሲ ዳም ስንና ቦርአ አይሁድኒ ሜኒ ጋነያስናዋ አዛብኒ ሜኒ ጋነያስና ኦር ኦርባ ኣፋዋ። ባር፤ ባርኪ ሺጵሴፌ ባሶ ዙታምቤሲሴ አሲክ ኦቱምባሶን ዳይስሬ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","«ዳሚሳ ሱናኖን ቴጌፌ ባር ዙቴሬ ፋሩናዋ» ይስቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ስኑንታኖ ባሪን አማኖኖይ ኣካክ ቴግሶክ ችሞነሪን? ባሳ ቾዋሶን ኦዶኖይ ኣካክ አማኖሶነሪን? አስሲኛ ፎንቶኖን ደይ ኣካክ ኦዶክ ችሞነሪን? ");
INSERT INTO jnje_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","አስሲኛኒ ሜያ ዎስቴሬ ሀሞኖይ ኣካክ ካምባሶን አስሱክ ችሞነሪን? ኤሲስ ደይ፦ «ምስራቹኒ ኦዱሶን ማክሴፌ ባሶ ዮሲ ኣካ ግርስፋሶ!» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ስኑንታኖ ኢሳያስ፦ «ዳሚሶ! ማኬኒ ኦዱሶን ኦንሶ አማነሪ?» ይሬ ማኬናሲማቶ ምስራቹኒ ኦዱሶን ኤጴቴሴ ባሶ ዙታምቤሲሴታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ኤሴ አማንቶ ቤስቴፋናስ ምስራቹኒ ኦዱሶን ኦዶክዋ። ኤስ ኦዱስ ደይ ክርስቶስኒ ቾዋሲክ ማክቴፋ ካማስዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ሻካኒ ማምሱጝዋ፤ ኤኪን ባሶ ካምባሶን ኣነ ኦዶሶቶ ኡኖሶ? ኮርቶ ማፃፋሲ፦ «ካምቤሲስ ዳ ዙታምባሴ አሲስ ኦድቴ፤ ማኬሴቴ ካማስ ዳስ ድልታ ካርእ» ይስቴራ ትቼናስማቶ ፉቶሲክ ኦደሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ሻካኒ ማምሱጝዋ፤ ደይ እስራኤልኒ ሜያ ካምባሶን ኣነ አርሶቶ ኡኖሶ? ኤካ ኡስቶኖይናማቶ ሙሴ ዜምሜ፦ «ካሽስቶ ዳራስን፤ ኮኖትክ ዛግራ ጋቢስሱናዋ፤ ያዳቶኖይ ዳራሲክ ደይ ንቶትን ሃርሱና» ይዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ራጁ ኢሳያስ ደይ፦ «ታን ሾልሶኖይ ባሶክ ቤስቴን፤ ‹ሀኦስኪ አይንሶ?› ይሬ ማምሱኖይ ባሶክ አምማኖን ቤስቴን» ይት ድጎኖይ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ስኑንታኖ እስራኤልኒ ሜኒ ቾዋሲክ፦ «አጃጃሞኖይ ዳራስናዋ ኑሪፌ ዳራስና ታኪ ዮናክ ዎናሶን ዙትራ ኩሹናሶን ሾን» ይፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ሻካኒ ደይ ማምሱጝዋ፤ ሀኦሲ ዳራባስን ሀእዮሶ? እሳንነ ኣነ ሀኡዋዋ። ታ ቴትናሲክ እስራኤልኒ ዳኒ አሱዋ፤ አብራሀምኒ ዛላ ስና ብንያምኒ ኬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ሀኦስ ዜምማ ኮርና ዳራስን ኣነ ሀኡዋዋ። ኮርቶ ማፃፋሲ ኤልያስኒ ቾዋሲክ አዉ ይናማቶ ኣነ ያዳቶዌትኖሶ? ደይ ኤልያስ እስራኤልኒ ዳራስን አዉ ይሬ ማላቴናማቶ ኣነ አሩዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ኤስ ካባሲክ ኤልያስ፦ «ዳሚሶ! ራጁነሳክቶኒን ዎርሴቴዋ፤ ሾአኔሲክቶኖን ቦጌሴቴ፤ ታ ደይ ታ ታ ፉእቴጝዋ፥ ታን ደይ ዎርሶነክ ሾልሴድፌርዋ» ይት ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ስኑንታኖ ሀኦስ አዉ ይራንሶ ባርክ ዎልግናሪ?፦ «ባል ይስቴፋ ኮሎሲክ ካኖኖር ናፉን ኩም አሱኒን ታክ ፉእኤጝዋ» ይዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ሀን ነያሲክ ደይ ስንፋናክኑ ሀኦሲ ኦትማክ ኮርቴሬ ፉእቴር ጋሮ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ኤሴ ባሪ ኮሩስ ሀኦሲ ኦትማክ ስንፋናነ ዎስቶክታዋ ኡዋ፤ ዎስቶክ ስኒ ስንፋናነ ሀኦሲ ኦትማ ፉእቶኒር ስናና ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ኤኪን ጋንባስ አዉ ስንሶ? እስራኤልኒ ሜያ ሾሌሴቴ ባሮን ኣነ ዳኖቶዋ፤ ስኑንታኖ ኮርቴሴ ባሶ ዳነቴ፤ ፉእቴ ባሶ ደይ ንቤሲሶን ችኒሴቴ። ");
INSERT INTO jnje_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ኤሲስ ደይ፦ «ሀኦስ ንቤሲሶን ሙምሲ፤ ኤስ ባሪ ቦርኣ ሀውጙኔን ካርአ ኣፍቤስ ቢኖይናማቶ፤ ኦዶቤስ ደይ ኦዶኖይናማቶ ሲኒዋ» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ዳዊት ደይ፦ «ማድቤሲስ ኤጵፋ ኤሽምያ፤ ጋንሱኒ ዶአ ስና ባሶትን ራክሲፋዉጝዋ፤ ዛግሴቴ ማጝጉስ ባሶስታ ካርፋዉጝዋ፤ ");
INSERT INTO jnje_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ኣፍቤስ ቢኖር ስንና ታልሜፋውጝዋ፤ ጌሾቤሲስ ራኮክ፤ ዎንና ዎንና ኩፑፋዉጝዋ» ይዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ሻካኒ ደይ ማምሱጝዋ፤ አይሁድኒ ሜያ ጋንደሴቴስ ሄፕሳ ዎል ሌ ካብሶኖይቴማቶኖሶ? እንዳነዋ! አይሁድኒ ማጝሱሲ ቦርአ አዛብኒ ሜያ ፋሩ ዳነቴዋ። ኤስ ባር ደይ ስንናስ አይሁድኒ ሜያ አዛብኒ ሜያስታ ኮኖሶነክ ዛጉክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ስኑንታኖ አይሁድኒ ሜኒ ቦርኣስ ሀን ዳሲክ ኤባ ቤስቶናክ ዛጊዋ። ባሶ ጋንዶስ አዛብኒ ሜያክ ኤባ ስኒዋ። አይሁድኒ ሜያ ፋርሴቴ ስንፋናነ ኤባቤስሲ አዉነ ፋ አካማ ስናና ካባንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ኤሴ ሀሽ ማኮናስ ኣዛብ ስና ንቶክዋ፥ አዛብኒ ሜኒ ዎሲ ስንናማቶ ዎስቴፋና ዎስቶስ ኡልፍና ስንናቱ ታክ ቤስቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ኤስ ባሮን ደይ ዛግናስ ታ ኮን ስና አይሁድኒ ሜያኖን ኮኖሶነክ ዛጉናክዋ። ኤስ ባርክ ደይ አዉዛክነ ባሶስን እሳ እሳርን ፋቱክ ችማና ስናናዋ ኡክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ሀኦ ባሶትን ሀእፋና ካባሲክ ኦማ ሀን ዳሲ ዳራስ ሀኦሲኔን አነ ጋነናኔን ሀኦሲ ባሶትን ኤጳ ታፋና ካባሲክ አዉ ስናና ስንና ንቶክ ቤስቴፋሶ? ኤስ ባር ደይ ክቱን ካቡነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","እሳ ቴሳ ቱሾስን ቴሱኒ ባር ሀኦሲክ እምቴራ ኮርቶ ስንፋናነ፥ ቱሾስ ዙቴራ ኮርቶዋ፤ ኤሲስማቶ እሳ እኦስ ታስባስ ኮርቶ ስንፋናነ ዋይእባስ ደይ ኮርቶቱ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ጎርጉ ድ ቡናሲ ዋይአኒማቶ ስና አይሁድኒ ሜያ ካቴሬ ሀቴሴቴኔን ንቶ ቡርእኡ ድ ቡናሲ እኦኒ ዋይእኒማቶ ስና ኣዛቢስ ባሶ ኤደሲ ግሪራ ኤስ ታሳስ እምፋና ኤባሶን ሃኤር ስንፋትነ፤ ");
INSERT INTO jnje_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ንቶ አዛብኒ ሜያ፤ ዋይአሲማቶ ካቴሬ ሀቴ አይሁድኒ ሜያስታ ጌአቲታዋ፥ ስኑንታኖ ንቶ ጌኤፋትነ ዋእአ ዋእአ ስንነት ቦርአ ታሳስቱ ንቶትን ዎርአስታኖ ንቶ ታሳሶን ዎርአክ ኣፋ ችማት ዉዛ ስንናማቶ ያዳቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ስኑንታኖ፦ «ዋአሲክቶ ኪቴራ ጋንደናስ ታ ባሪ ኤደሲ ግሩናክዋ» ኡቲ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ልኪዋ! ባሶ ካቴሬ ጋንደሴቴስ አማኖ ቤዮቤስሲክዋ። ስኑንታኖ ንቶ ችማ ዬሬቲስ አማነሴት ቦርአዋ። ኤሴ ድጎትስታኖ ጌአትክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ሀኦስ ቴስቶቤሲሲክ ዋይአ ስና አይሁድኒ ሜያክ ኬናሽቶ ሻካናነ ንቶክ ደይ ኣፋ ኬናሽቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ኤሴ ሀኦሲ ጋራማኖንናዋ ዴሱባሶንና ቢትዋ። ዴሱባሶን ቤስፋናስ ጋንደ ባሶስታዋ። ስኑንታኖ ጋራምባሶን ቤስፋናስ ንቶስታዋ። ኤስ ባሮን ደይ ዛግናስ ባር ጋራማሲክ ችምማ የሬፋትነዋ። ችምማ የሮ ሻካትነ ንቶ ደይ ካቴራ ጋንደሴትርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","አይሁድኒ ሜያ አማኖ ቤዮቤሲስን ዎልሴፋቴነ ዜሞቲ ካቴሴቴ ድምቤሲስታ ዎልሶነዋ። ሀኦስ ዜሞቲ ድምቤሲስታ ባሶትን ዎልጉናክ ደይ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ስኑንታኖ ንቶ አዛብኒ ሜያ ቴስቶንትሲክ ቡርእኡ ድ ቡናሲ ዋአ ስንና ፋኒ ንቶ ጎርጉ ድ ቡና ስኖይ ድማስታ ቶክቶ ችምቴትኔን ሀን ባሶ ቴስቶቤሲሲክ ጎርጉኪ ቡንኒ ዋአ ስና አይሁድኒ ሜያ ዎል ሌ ዜሞቲ ድምቤሲስታ ኣካክ ቶክቶ ቤዮነሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","አይታሳክቶኖ!፦ «እንኖ አሩዋ» ይት ቴቶቲታዋ። ታ ንቶክ ማኮና እሳ ኣቾ ቾዋ ፋርዋ፤ ኤሲስ ደይ እስራኤልኒ ሜያስን እሳ እሳይስ ንብቤሲስ ችምናስ ሀኦስ ቴጌና አዛብኒ ሜያ ዙቴሬ ሀኦስኪ ዎልሶነ ካባኔጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ኤሴ ኤስ ባርክ እስራኤልኒ ዳራኒ ሜያ ዙቴሬ ፋሩሶነዋ። ኤካ ደይ ይስቴራ ትቼዋ፤ «ፋቱኒር ፂዮኑን ዮናዋ፤ ያቆብን ዛላ ዙታምባሴ አሲስን ማንጉሶን ውዛሶን ትሽኩናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ቦርእቤሲሶን ትሽክፋና ካባሲክ፤ ባሶኔን አነ ግሩና፤ ቴያኒ ካማስ ሀኒስዋ።» ");
INSERT INTO jnje_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","እስራኤልኒ ሜያ ምስራቹኒ ካማሶን ኤጴቶ ቤዮቤሲሲክ ንቶ አዛብኒ ሜያኖን ፋራዶክ ባሶ ሀኦሲ ጉማ ስንነቴዋ። ስኑንታኖ ሀኦስ ባሶትን ኮሩባስታን ካብ ቾዋ አሲቴሴሪስ አባኒ ሜኒ ቦርአ ባሶ ሀኦሲ ዞሞዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ሀኦስ ኮሪራ ኦቱምባሲ እማኖን ባሶክ እምናኔን ኦርፎ ዛግና ዉዛሲክ ሳፋራባሲክ ኣነ ጋቤፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ንቶ አዛብኒ ሜያ ዜሞ ሀኦሲክ አጃጃሞኖር ስንና ፋትርዋ። ስኑንታኖ ሀሽ አይሁድኒ ሜያ አጃጃሞ ቤየቴ ቦርአ ንቶ ፋክያ ዳነትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ንቶ ፋክያ ዳነሴትስነ ፋሮን ባሶ ደይ ፋክያ ዳኖነክ ሀሽ ባሶ ሀኦሲክ አጃጃሞኖር ስንነቴ። ");
INSERT INTO jnje_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ሀኦሲ ፋክባሶን አሱ ዙታምባሴ አሲክ ቤሱናክዋ እያት አሱኒ ሜያኖን ዙትራ አጃጃሞ ቤዮቤሲሲክ ታቶ ስኖነክ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ሀኦሲ ቴቹምነዋ አሩነ አዉነ ፋሮን አካማንሶ! ማጝሱኒ ካርባስ ደይ ቱእኑስቶኖርዋ፤ ኡጉንባስ ደይ ኣነ አሪቴፋዋ! ");
INSERT INTO jnje_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","«ዳሚሳ ሳፋራኖን አሪፌር ኦንሶ? ባሪን ኪቱኒር ኦንሶ?» ");
INSERT INTO jnje_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","«ሀኦሲክ ልቄሳት ልቄሲና ባሮን ዎልግሬ ኤጵኒር ኦንሶ?» ");
INSERT INTO jnje_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ዙታምባሴ ያናስ ባርኪን፥ ባርኪ ካሞናዋ ባርኪንናዋ። ኮእባ ፎንቶኖን ባሪክ ኡልፍና ስንፋውጝዋ፤ ኣሚን! ");
INSERT INTO jnje_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ኤሴ አይታሳክቶኖ! አቱንቲሶን ሀኦሶን ግርሱኒ ሀየዋ እማነዋ ኮርቶ ማአነ ዛግራ ሀኦሲክ እማትክ ሀኦሲ ጋራማክ ሺጵፋዉጝዋ። ኤስ ባር ደይ ማአ ንብንትስን ኬስፋ ፉቶኒ ሀኦኒ ሺጶሴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ማአ ዉዛሴዋ ግርሱኒ ዉዛሴ ደይ ቱማ ስና ሀኦሲ ፍቃድኖን አሩ ችማትክ ካኑንትሶን ጋድዶሱክ ንብንቲሲ ሳፋራክ ሶልቶትታኖ ሀን ዳስታኪ አሱኒ ሜያነ ፌር ስናቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ደይ እሳ እሳርኒቲስ ሀኦስ ንቶክ እምና አማንቶሲማቶ ሹጳክ ሳፋሮትታኖ ንቶክ ሾልስስታን ደናሎ ቴትንትሲክ ቤጋንቶክ ሳፋሮቲታ ይራ ታክ እምቴ ሀኦሲ ኦትማክ ማኬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","እሳ አቱኒስታ ሾዎ ብልቲ ፋርዋ፥ ኤስ አቱኒሲ ብልት ደይ ቴትባ ቴትባሲክ ኦማ ኦማ ዎስቶባ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ኤሲስማቶ ደይ እንኖ ሾዎ ስንፋት ክርስቶስኒክ እሳ አቱ ስንኒዋ። እሳ አቱኒ ብልት ስንኒ ቦርአ እኖትና እኖትና ደይ እሳርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ኤስ ባሪ ቦርኣ ሀኦስ ኦቱምባሲክ እኖክ እምና ሾዎ ቴሳ እማሶን ዎስቶታ ፌሹንዋ። ኤስ እኖክ እምቴ እማስ ሀኦሲ ካማኖን አዋሱ ስንፋናነ አማንቶኒስማቶ ሀኦሲ ካማኖን አዋሱኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","እኖክ እምቴ እማስ ኦምኒ ሜያኖን አርጋሱ ስንፋናነ ችምማ አሪጋሱኒዋ። እኖክ እምቴ እማስ አሱኒን አስሱ ስንፋናነ ማእስራ አስሱኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","እኖክ እምቴ እማስ ችኑ ስንፋናነ ችኑንዋ፥ እኖክ እምቴ እማስ አሱኒክ እማ ስንፋናነ ማአ ንባክ እማንዋ። እኖክ እምቴ እማስ ሀእሱ ስንፋናነ ችማ ሀእሱኒዋ፥ እኖክ እምቴ እማስ ኬናሽቶ ስንፋናነ ኤስ ባሮን ደይ ግራክ ዛጉንዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ስንኖይ ስንና ቤስቶኒ ኡባ ፎንቶኖን ፉቶኒ ኬሽታናንት ፎንዋ። ማጙ ዉዛሶን ኦምቶት፥ ማአ ስና ዉዛስኔን አነ እሳር ስንት። ");
INSERT INTO jnje_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ንቶትና ንቶትና አይና አይና አሲ ኬሽታናሲክ ዎል ሹኖት። ንቶትና ንቶትና ዎል ኡልፍንሱክ ታፕቶት። ");
INSERT INTO jnje_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ሆፑኖይ ጉዙ አያናሲክ ዞኑስቴራ ዳሚሲክ ዎስቶት። ");
INSERT INTO jnje_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","አብዲሲክ ግሮትዋ፥ ሻና ያና ዎኖ ፋኩት። ዎንና ዎንና ሽጶት። ");
INSERT INTO jnje_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","አማኝ አይኝኒ ሜያኖን ራኮቤስሲሲክ አሪጋሱት። እርባ ስንነ የ ባሶትን ኤጳ እርባሱት። ");
INSERT INTO jnje_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ንቶትን ካብግፌ ባሶትን ሱስት፥ ሱስትታኖ ኤርዉቲታ። ");
INSERT INTO jnje_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ግሬፌ ባሶኔን አነ ግርሶት፥ ዋስሴፌ ባሶኔን አነ ዋሱሶት። ");
INSERT INTO jnje_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ንቶትና ንቶትና እሳ ሳፋራክ እሳር ስንና ፎቲ። ቴትንትሶን ቴጉክ ቤጋንቶሶን ቤይያ ቱካምኒ ሜያኔን አነ እሳሪክ ፎሶት፥ ቴትንትሲክ እንኖ አሩዋ ኡትታ። ");
INSERT INTO jnje_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","አሱ ዙታምባሴ አስ ስናክ ማአር ስና ዉዛሶን ዛጉትታኖ አሱኒ ሜያ ንቶስታ ማጙ ዉዛ ዛግሴፌ ካባሲክ ዎልግራ ማጙ ዉዛ ባሶስታ ዛጉትታ። ");
INSERT INTO jnje_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ንቶክ ችምቴር ስንፋናነ አሱ ዙታምባሴኔን አነ ናጋክ ፎትክ ንቶኪን ሾልሲ ዉዛሶን ዙትራ ዛጉሶት። ");
INSERT INTO jnje_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ኮንታሳክቶኖ! ግአሶን ሀኦሲክ ቤይትታኖ ንቶ ዎል ላ ጉማ ካስቶትታ፦ «ጉማ ካስቶኒስናዋ ጉማኒ ቆዋሶን ዎልጉኒስና ታዋ ይፋዋ ዳማ ሀኦስ» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ኤስ ባሪ ቦርኣ ጉማኒ ካስቶስታን ጉማኔስ ማክቴፋናነ ማሱ እክቴፋናነ ደይ ኡሹ፥ ኤስ ባሮን ዛጉኔሲክ ቴትባስታ ኢችቻንኒ ጌያ ዎቱታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ማጙ ዉዛሶን ማአሪክ ሜሮታኖ ማጙ ዉዛሲክ ሜርቶታታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ኣፋ ሀእሱሲኑ ስኑን እምቴፋናስ ሀኦሲ ፍቃድክ ስንና ቦርአናዋ ሀሽ ደይ ፌሴ አእስኛኒ ሜያ ታቴሴቴስ ሀኦሲክ ስንና ቦርአና አሱ ዙቴሬ ባሳ ደናሎክ ሀእሲፌ ባሶክ አጃጃሞናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ኤስ ባሪ ቦርኣ ሀእሲፌ ባሶትን ቱጋኤፌ ባር ዙቴሬ ሀኦሲ አጃጅኖንቱ ቱጋኤፌዋ፥ አጃጃሞ ቤይፌ ባር ደይ ባሳስታቱ ኬኦ ኤጴ ዬፌዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ሀእሲፌ ባሶ ድግቴሴፌስ ማጙ ዉዛ ዛግሴፌ ባሶክታኖ ማአ ዉዛ ዛግሴፌ ባሶክታዋ። ሀእሲፌ ባሶትን ድጎ ቤያ ሾሌፋቶሶ? ኤሴ ማአ ዉዛ ዛጉዋ፥ ባሶኪን ደይ ጋላታ ዳናታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ሀእሲፌ ባር ኔክ ማአ ዉዛ ዛጉናክ ታትቴ ሀኦኒ ዎስትኛዋ። ሀእሲፌ ባር ሲፎ ታርኤናስ ሽማክ ስና ቤይና ቦርአ ማጙ ዉዛ ዛግታር ስኒፋታነ ባሪን ድጎዋ። ባር ማጙ ዉዛ ዛግፌ ባሶትን ኬኡክናዋ ሀኦሲ ጉማኒ ካስቶኖን ቤሱናክና ሀኦሲ ዎስትኛዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ኤስ ባሪ ቦርኣ ደይ ሀኦሲ ኬእኦኖን ድጎስ ኮእባ ስኖይናሮን፥ ሃላንትስ ንቶትን ዌኦና ቦርአ ሀእሲፌ ባሶክ ሀኡ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ግርቦ ካስፌትስ ደይ ኤስ ባሪ ቦርኣዋ፤ ሀእሲፌ ባሶ ኤስ ዎስቶሶን ዎስቴሴፌስ ሀኦሲክ ዎስቶክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","እሳርባ እሳርባሲክ ሾልስ ዉዛሶን ዛጉትዋ። ግርቦ ግርቦትክ ሾልስና ባርክ ግርቦ ግርቦት፤ ካራጣ ሾልስና ባርክ ካራጣ ካሱት፤ ድጎትክ ደይ ሾልስና ባሪን ድጎት፤ ኡልፍና ሾልስና ባርክ ኡልፍና እምት። ");
INSERT INTO jnje_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ንቶትና ንቶና ዎል ኬሽቶሶትታኖ ኦኒ ኮዋኑ ንቶስታ ፎናታዋ፤ ኤስ ባሪ ቦርኣ አሱስን ዙትሬ ሹንፌ ባር ቱማሶን ዛግዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«ጌርኬሳታታ፥ ዎሩታታ፥ ዊሶታታ፥ ኤናንቶታታ» ይፋ አጃጅሴዋ ኦማ ኦማ አጃጂሲክቶነ ዙቴራ፦ «አሱ ዙታምባሴ አሲን ነ ነ ቴታሶን ሹንፋታይስማቶ ሹጝዋ» ይፋ እሳ አጃጂሲ ዙቴራ ግሪዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","አሱስን ሹንፌ ባር ኤስ ሹና አሱሳታ ማጙ ዉዛ ኣነ ዛግፌዋ። ኤስ ባሪ ቦርኣ አሱኒን ሹንፌ ባር አጃጂሶን ዙትሬ ዛጊዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ኤሴ አፋይኒታን ጉዙት ዎናስ ሀሽ ካርእናማቶ አሩትዋ። ዜሞቲ አማነኒ ዎናስታን ሀሽቲ ፋሩኒ ዎናስ ማእስራ ያራ እኖኪ ካርእዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ዋላስ ኣትድፋር፤ ዎናስ ደይ ያራ ታእ፤ ኤስ ባሪ ቦርኣ ታልማሲ ዎስቶኖን ቤያ ቻሬፋሲ ኔቦኒ ሜያሶን ማያኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ያሆክናዋ ኡሼ ዛዎክና ጌርኬሳክናዋ ዎጆቾክና ፋሶክናዋ ማጙ ኮናክና ስኖይናሮን ዎናሲ ቻሬፋሲ ፌፌ አሱኒ ሜኒማቶ ማአሪክ ፎሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ኤስ ባሪ ቦርኣ ዳም የሱስ ክርስቶስኒን ማይትታኖ አሽንትሲ ካልታናኖን ቱኑክ ሳፋሮቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ንቶ ጋነያሲ አማንቶባሲሲክ ሆፕ ስና አሱስን ኤጳቶትታኖ ባሳ ቴትኒ ሳፋራስታ ካራካሮቲታ። ");
INSERT INTO jnje_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","እሳ ቤሶ ብያኒዋ፦ እሳ አሱ ቤስቴ ዉዛሶን ዙትሬ ሙናክ ችኑኒ አማንቶባ ፎና ሲናናዋ። ስኑንታኖ አማንቶባሲክ ዛጉ ቤያ ባር ቶክቴ ቶኮ ባር ባሮንቱ ሜፌዋ፤ ");
INSERT INTO jnje_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ባሪን ሀኦስ ኤጳታ ስንና ቦርአ ቤስቴ ዉዛሶን ዙትሬ ሜፌ ባር ሙኖይ ባሪን ካሹናታዋ፤ ሙኖይ ባር ደይ ሜፌ ባሳስታ ማጝሱ ካርአናታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ኤካን ኦም አሱሳ ዎስትኛኒታ ማጝሱ ካርእፌስ ነ ኦንሶ? ባር የሬፌናክ ወደይ ጋንደፌናክ ዳምባሳ ግሮዋ፤ ደይ ዳሚስ ባሪን ዬቱክ ችማና ስንና ቦርአ ችሜ የሮናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ኤሲስማቶ እሳ ዎናስ ኦማ ዎናስታን ደናሎ ኡልፍንቶ ዛግሬ ሳፋሬፌር ፎናክ ችማና ስናናዋ፤ ኦሚስ ደይ ዎናስ ዙቴራ እሳ ኪጤ ኡልፍንባቱ ፋርታኖ ዎናሲክቶኒ ጋነስን ኦርባ ኦርባ ኣፋዋ ይሬቱ ሳፋሬፌ ሲናናዋ። ኤሴ ኤስ ባርነ ፋ ዉዛሲክ አሱ እሳርባ እሳርባሲክ ንብባሲ ሳፋሬናይስማቶ ዛጉዎዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","እሳ ዎናሶን ኦማ ዎናስታን ደናሎ ዛግሬ ኡልፍንስፌር ፌፋናነ ዳሚሳ ኡልፍናክዋ እያትዋ። ቤስቴ ሙሶን ዙትሬ ሜፌ ባር ዳሚሳ ኡልፍናክዋ እያቱ ሜፌዋ፥ ሜፌና ሙሲክ ደይ ዳሚስን ጋላቴፌ። ቤስቴ ሙሶን ዙትሬ ሙኖይ ባር ዳሚሳ ኡልፍናክዋ እያት ኣነ ሜፌዋ። ኤስ ሙ ቤይባሲክ ደይ ሀኦሶን ጋላቴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","እንኖስን ቴትባሲክ ክትፌር ወደይ ቴትባሲክ ካክ ፌፌር ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ፋፋኒነ ዳሚሲክቱ ፎኒ፤ ኪትፋንነ ደይ ዳሚሲክቱ ኪቱኒ። ኤስ ባሪ ቦርኣ ክትፌኒክ ካክ ፋፌኒክ እንኖ ቴትኒሲክኑ ዳሚሳርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ኤስ ባሪ ቦርኣ ክርስቶስ ክትሬ ክቱን ካብናስ ሀየዉኒ ሜያክናዋ ክቱኒ ሜያክና ዳም ስናናክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ኤካን ነ አይኔሳታ አዋጋን ማጝሱ ካርእፋስሶ? ወደይ አዋጋን አይኔስን ካሽፋስሶ? እንኖ ዙታምኒሴ ሀኦሲ ማጝሱኒ ካርእኒ ኮዳሲ ስንታ ዬሮኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ደይ ማፃፋስሲ፦ « ‹ታ ሀየዋዋ› ይፋዋ ሀኦስ፤ ኬኣስ ዙቴራ ታ ስና ካኖናዋ፤ ቴርማስ ደይ፤ ታ ሀኦ ስንናማቶ ታክ ዛላ ማኮናዋ» ይስቴራ ትቼና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ኤስ ባሪ ቦርኣ እንኖ እሳርኒ እሳርኒስ ቴትኒሲ ዎስቶክ ሀኦሲ ስና ታአ ዎልጉባ እማኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ኤስ ባሪ ቦርኣ እሳርኒስ ኦሚሳታ ማጝሱ ካርእአንታዋ፤ ስኑንታኖ ኦኑ አይባሳ ኡጉንታ ጋንሱኒ ዉዛ ወደይ ቱሳ ዱሱኖይናማቶ ቴትባሶን ኦዶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","እሳ ዉዛ ዝናዋ ይሬ ሳፋሬፌ አሱ ኤስ ዉዛስ ባርክቱ ዝና ስናናታኖ ኣፍፋ ዉዛስኑ ቴትባሲክ ኪና ስና ቤይናማቶ ታ ዳም የሱንኪ ካሞ ማእስራ አሪጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ነ ማፋታ ሙሲ ቦርአ አይኔሲክ ቱሳ ስናታር ስንፋናነ ኬሽታናስ ነይስ ኣፋዋ ኡዋ፤ ኤስ ባሪ ቦርኣ ክርስቶስ ባርክ ክትና አሱስን ማፋታ ሙሲ ቦርአ ትሹናክ ዛጉታታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ኤሴ ንቶኪክ ማአሪ ስና ዉዛሶን ኦምኒ ሜያ ካሹሶነክ ዛጉቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ሀኦሲ ታቶ ኮርቶ አያናክ ቤስቴፋ ኦኮ፥ ናጋነዋ ግራነታኖ ሙነዋ ኡሽነ አሲ ቾዋታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ኤሲስማቶ ክርስቶስኒክ ዎስቴፌ አሱ ሀኦሶንቱ ግርስፌ፥ አሱኒ ስናክ ደይ ጋላታምቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ኤስ ባሪ ቦርኣ ናጋስ ቤስቴፋና ዉዛሶንናዋ እኖትና እኖትና ዎል ችማኒ ዉዛሶንና ሾሎኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ሙኒ ቦርአ ሀኦሲ ዎስቶኖን ቦጋኒታዋ። ሙስ ዙቴራ ካይማዋ፤ ስኑንታኖ ኦም አሱስን ቱሳሱን ሙሶን ሙስ ልኪታዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ኤስ ባሪ ቦርኣ አይኔስን ቱሳእሱኖይታማቶ አሻ ሙ ቤያ ወደይ ዋይንኒ ኡሻ ኡሻ ቤያ ወደይ ኣፍፋ ቱሳእሱኒ ዉዛ ዛጉ ቤያስ ማአሪዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ኤሴ ሀን አማንቶኔስ ኔናዋ ሀኦሴ አሲ ጋነያሲ ስንኑጝዋ፥ ልኪዋ ይሬ አማነና ዉዛሶን ዛግን ካኑባስ ዌኦኖይና አሱ ጋላታምቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ስኑንታኖ አዉዛክነ ይፌት ሜፌ አሱስ ዛግና ዉዛስ አማንቶክ ስና ቤይና ቦርአ ማጝሱ ባሳስታ ካቴርዋ፥ አማንቶክ ዛግቶኖይ ዉዛስ ዙቴራ ደይ ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","አማንቶክ ችም ስና እንኖ ሆፕኒ ሜኒ ሆፕያሶን ዎርአኒክቱ ሾልስፋታኖ እንኖ ቴትኒሶን ግርሱኒክ ኣነ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","እሳርን እሳርኒስ ኦም አሱስን አማንቶባሲክ ችማናክ ባርክ ኬእኒ ዉዛሴዋ ባሪን ግርሱኒ ዉዛሴ አስን ዛጉኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ክርስቶስ ቴትባሶን ኣነ ግርሱዌዋ፤ ስኑንታኖ ኮርቶ ማፃፋስሲ፦ «አሱኒ ሜያ ኔን ሜኤቴ ሜኣስ ታይስታቱ ካርእዋ» ይፋ ካማ ባሳስታ ካርእዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ኮርቶ ማፃፋሲን ዳንፌኒ ፋክያሴዋ ችኑሴ አብድን ፎናክ ዜምማ ትቼናስ እኖትን አሱክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ፋክነዋ ችኑነ እምፋ ሀኦስ ንቶትና ንቶትና ዎል ክርስቶስ የሱስኒ ቤሶሲክ ዞኑስቶትክ ኦሚስኔን እሳር ስንነ ፎሶን ንቶክ እማጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ኤስ ባር ስንናስ ዳምኒ የሱስ ክርስቶስኒ አባ ሀኦሶን እሳ ንባክናዋ እሳ ካማክና ኡልፍንሱትክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ክርስቶስ ሀኦሲ ኡልፍናክ ንቶትን ኤጴቴናማቶ፥ ንቶ ዙታምንትሴ ደይ እሳይስ ኦሚስን ኤጳቶሶት። ");
INSERT INTO jnje_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ሀን ታ ማኬፋናስ ሀኦስ ዜምማ አባን ሜያክ ግሪና ቴያኒ ካማስ ኮኡናክ ሀኦሲ ፉቶክዋ እያት ክርስቶስ አይሁድኒ ሜኒ ዎስትኛ ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ደይ አዛብኒ ሜያ ሀኦሶን ፋኪባሲክ ጋላቶሶነክዋ። ትቻስስ፦ «ኤስ ባሪ ቦርኣ አዛብኒ ሜኒ ጋነያሲ፤ ኔን ጋላቶናዋ፤ ሱኔሲክ ደይ ጋማክ ጋላታ እማናዋ» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ደይ፦ «ንቶ አዛብኒ ሜያነ! ሀኦሲ ዳራኔን አነ ግሮትዋ» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ሄፕሳ ደይ፦ «አዛብኒ ሜያነ! ዙቴራ ዳሚስን ጋላቶትዋ፤ ዳራስ ደይ ዙቴራ ዳሚስን ጋላቶትዋ» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ኤሲስማቶ ደይ ራጁ ኢሳያስ ደይ፦ «እሴይኒ ዛላስን ኮንቶኒር ዮና፤ አዛብኒ ሜኒ ዞንሲ ስናናክ ካቡና፤ ባሶ ደይ አብድቤሲሶ ባሳስታ ዛግክሶነ» ይፋዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ንቶ አብዲስ ኮርቶ አያናሲ ሁግናክ ድቼት ሀማናክ አብድን ሀኦሶን አማንቶንቲሲክ ግራነዋ ናጋነ አስን ቱንራ ንቶክ እማጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","አይታሳክቶኖ! ማአክ ቱማ ንቶ፤ ቱማ አሩክ ቱሜሴቲስ፤ እሳይስ ኦሚስን ኪቱክ ችማትክ ስንናማቶ ታ አሪጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ሀኦ ታክ እምና ኦትማሲማቶ ንቶትን ያዳሱናክ ሾሌፋት እሳ እሳ ቾዋ ድጋባ ፎንቶኖን ትችጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ሀን ሀኦሲ ኦትማ ታክ እምቴናስ ሀኦሲ ምስራቹኒ ካማኖን አዛብኒ ሜያክ ማኮናክ ማግኒማቶ ስና ክርስቶስ የሱስኒክ ዎስቶናክዋ። ኤሲስ ደይ አዛብኒ ሜያ ኮርቶ አያናክ ኮርቴሴሬናዋ ሀኦሶን ደይ ግርሱኒ ማአ ስንነሬና ታእሶሶነክቱ ዎስቴድፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ኤስ ባሪ ቦርኣ ክርስቶስ የሱስኒኪ ካሞ ሀኦሲክ ዎስቶናክ ችምናሲክ ቴቴፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","አዛብኒ ሜያ አጃጃሜር ስኖነክ ዛጉናክ ክርስቶስ ታ ካማሲክናዋ ታ ዎስቶሲኪ ካሞና ዎስቴና ዉዛሶንታኖ ኦማ እሳ ዉዛነ ማኮናክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ኤሲስማቶ ደይ አካማ አካማ ቢስቴራ አሪቶኖይ ዉዛሲክናዋ ዲንቂ ዎስቶሲክቶክና ደይ ኮርቶ አያናሲ ሁግናክና የሩሳለሙን ካብራ ኤልዋርቆኒ ብራቶስታ ካርአ ክርስቶስኒ ምስራቹኒ ካማሶን ማኬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ዎንና ዎንና ካልቴፋናስ ደይ ኦም አሱ ካፑትና ካፕታስታ ኬርአናክ ስኖይናሮን ክርስቶስኒ ሱናስ ቴግቶኖይና ድማ ዙታምባሴ አሲስ ምስራቹኒ ካማሶን ማኮናክዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ኤሲስ ደይ፦ «ዜሞ ስናክ ባሳ ቾዋሶን ማክቶኖይና አሱኒ ሜያ ብዮነ፤ ባሳ ቾዋሶን ኦዶኖይ ባሶ ደይ ያዳቶሶነ» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ሀሽኔን ካርአ ንቶኪ ዮኖይናማቶ ሾዎ ዎና ካልቴጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ስኑንታኖ ሀሽ ሀን ብራቶስታ ፋሴ ዳስታክ ዎስቶናሶን ኮእስና ቦርአ፤ ደይ ሾዎ ነያስታን ካብራ ንቶትን ብያናክ አካማኖን ካልቴት ፋናር ስንና ቦርአ፥ ");
INSERT INTO jnje_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","እስፐን ሀሚፋና ካባሲክ ሻቴራ ንቶትን ብያናክ ኮፓኤጝዋ። ጋሮ ዎናኖን ንቶኔን አነ ግራክ ኣትናኔን ኦርፎ ኡጉናሲክ ስንኒ አሪጋሱ ታክ ዛጉትማቶ አብድ ዛግፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ስኑንታኖ ሀሽ ሀኦኒ አሱኒ ሜያክ እምቶኒ አሪጋሱኒ ዋጋ ኤጳ የሩሳሌም ሀሚናርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ኤሲስ ደይ ሜቀዶንያክናዋ አክያክና ፌሴ ሀኦኒ አሱኒ ሜያ የሩሳለሙክ ፌሴ ቱካምኒ ሜያክ እምቶኒ አሪጋሱኒ ዋጋ ዎስሶነክ ቡግሬ ካብሴቴ ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ኤስ አሪጋሱሶን ባሶ ፍቃድክ እሜቴስ ግድ ስንና ቦርአዋ። አዛብኒ ሜያ አይሁድኒ ሜያኔን አነ አያናኒ ኤባ ሃእኤር ስንነቴኔን አዛብኒ ሜያ አሽኒ ፎቤሲሲክ አይሁድኒ ሜያኖን አሪጋሱሶነክ ግድዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ኤስ ባሪ ቦርኣ ሀን ዙቴ አሪጋሱኒ ዋጋሶን የሩሳሌም ኤጳ ታማ እምናኔን ኦርፎ ንቶኪ ካሞ እስፐን ሀማናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ንቶኪ ያፋና ካባሲክ ክርስቶስኒ ኤባሶን ዮኡባ ፎንቶ ቱማኖን ኤጳ ዮናማቶ አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","አይታሳክቶኖ! ታ ሀኦኒ ሺጶክ ካቤፋና ካቦናሲክ ታን አሪጋሱትማቶ ዳምኒ የሱስ ክርስቶስኒክናዋ ኮርቶ አያናሲ ኬሽታናክና ንቶትን ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ኤስ ሺጶንቲስ ደይ ዩዳኒ ዳስታክ ፌሴ አማኖኖይ አሱኒ ሜኒ ኩሹስን ታ ፉእቶናክናዋ የሩሳለሙክ ፋ ዎስቶናሶን ሀኦኒ አሱኒ ሜያ ኤጴቶሶነማቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ኤስ ባር ደይ ስንናኔን ኦርፎ ሀኦ እያናነ ግራክ ንቶኪ ያራ ንቶኔን አነ ሀላጋልፋቶናክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ናጋኒ ሀኦስ ዙታምንትስኔን አነ ስንፋውጝዋ፤ ኣሚን! ");
INSERT INTO jnje_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ኪንክራያስኒ ካታማስሲ ፋ ቤቴክርስታኒሲ ዎስቴት ፋ ፌቤን አማናምቶ ኤትኒ ስንባሶን አሩትክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ባር ታንናዋ ኦም ሾዎ አሱኒ ሜያኖንና አሪጋሲር ስንና ቦርአ አማኝኒ እርባኒ ሜያኖን ኤጴቶ ሾልሲፋናይስማቶ ዳሚሳ ሱናክ ኤጳ ታራ ባርክ ሾልሲ ዉዛ ዙታምባሴ አስክ አሪጋሱትክ አዳራ ይፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ክርስቶስ የሱስኒ ዎስቶሲክ ታኔን አነ እሳር ስንነ ዎስቴት ፌሴ ፕርሲቂላኒክናዋ አቅላኒክና ናጋናሶን ማክሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ባሶ ደይ ዜሞ ስናክ ታ ኤድደ ክቱክኑ ስንፋናክ ሆሬሬ ፌሴቴርዋ። ኤስ ባርክ ደይ ባሶትን ጋላቴፋዉጙዋ። ታ ታ ታ ስኖይናሮን ኣዛብ ስንነፋት ክርስታና ስና አማኝኒ ሜኒ ቤቴክርስታኒሲክቶኔን ባሶትን ጋላቴሴድፌዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ባሶኪ ኬር ሀኦኒ ሺጶክ ዙቴሴፌ አማኝኒ ሜያክ ናጋናሶን ማክሶትዋ። ኢስያኒ ዳስታክ ዜምሜ ክርስቶስኒክ አማነ ባርክናዋ ሹንፋና ኤጴነቶስኒክና ናጋናሶን ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ንቶክ አካማኖን ሆፕ ማራሚክ ናጋሶን ማኮትውኣ። ");
INSERT INTO jnje_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ታኔን አነ ታቴሬ ፌሴ ባሶክናዋ ዎስኒ ሜኒ ጋነያስሲክ አርቶ ስና አይሁድ ስና ኮንታሳክቶኒክና ደይ አንድሮንኮስኒክናዋ ዩንያስኒክና ናጋናሶን ማኮትዋ። ባሶ ክርስቶስኒክ አማኖቤሲሲክ ታይስታን ዜምሜ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ዳሚሲክ ሹንፋና አምፕልያቶስኒክ ናጋናሶን ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ክርስቶስኒ ዎስቶሲክ እኖኔን አነ እሳር ስና ኡርባኖስኒክናዋ ሹንፋና እስታኩስኒክና ናጋናሶን ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ክርስቶስኒክ ፋ አማንቶባስ ፋታንቴራ ዛላ ማክቴና አጰልስኒክ ናጋናሶን ማኮትዋ። አሪስቶቡሎስኒ ኬርኪ ሜያ ስና ባሶክ ደይ ናጋናሶን ማኮትውኣ። ");
INSERT INTO jnje_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","አይሁድ ስና ኮኒታ ሄሮድያንክ ናጋናሶን ማኮትዋ። ናርሲኒ ኬሩክ ዳሚሲክ አማነሬ ፌሴ ሜያክ ናጋናሶን ማኮትውኣ። ");
INSERT INTO jnje_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ዳሚሳ ዎስቶክ ሆፕት ፋሴ ማሽካ ሜያክ፤ ትሩፋይክናዋ ትሩፎሳክና ናጋናሶን ማኮትዋ። ዳሚሳ ዎስቶክ አካማኖን ሆፕት ፋ ባሬዋ ክርስቶስኒክ ታ ባሮን ሹንፋና ፐርሲሲክ ናጋናሶን ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ዳሚሳ ዎስቶኖን ዎስቶክ አካማኖን አርቶ ስና ሩፎስኒክ ናጋናሶን ማኮትዋ። ታን ደይ ናዉባ ዛግራ ሹንፋ እንቶባሲክ ናጋናሶን ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","አሲንክርቶስኒክናዋ ፌሌጎኒክና፥ ሄርሜስኒክ፥ ፓትሮባስኒክ፥ ሄርማስኒክ ደይ፥ ባሶኔን አነ ፌሴ አይኒ ሜያክ ናጋናሶን ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ፍሎጎስኒክ፥ ዩልያክ፥ ነርያኒክናዋ ኤትባሲክና ናጋናሶን ማኮትዋ። ኤሲስማቶ ደይ ኦሉምፓስኒክናዋ ባሶኔን አነ ፌሴ አማኝኒ ሜያ ዙታምቤሲሴ አሲክና ናጋናሶን ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ኮርቶ ዳሞክ ናጋ ዎል ኦሽሾሶት። ክርስቶስኒ ቤቴክርስታኒሲክቶ ዙቴራ ናጋ ንቶክ ማክሴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","አይታሳክቶኖ! ኤጳ ታሴቲ አሱሶን ቱእጋኤር ስንነሬ ንቶ ጋነያስሲ ኦር ኦር ኬስነዋ ራክኮነ ኤጴ ዬሴፌ አሱኒ ሜያስታን ቴትንትሶን ኦድትዋ። ባሶስታን ደይ ዎክትዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ኤስ ኤፌቴና አሱኒ ሜያ ቴትቤሲስሮንታኖ ዳምኒ ክርስቶስኒክ ኣነ ዎስቴሴፌዋ። ሹጳ ዎላክናዋ ጌእስሬ ቴጎክና ጋራምኒ ሜኒ ንባሶን ኤሽሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ምስራቹኒ ካማሲክ አጃጃሜር ስኒቲሶን አሱ ዙታምባሴ አሲ ስናክ አርቴ ስንባሲክ ግሬፋናክኑ ማአር ስና ዉዛሲክ ቴቹም፤ ማጙ ስና ዉዛሲክ ደይ ጋራም ስናትክቱ ሾሌፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ኤስ ባሮን ዛግፋትነ ናጋኒ ሀኦስ ታአ ዎናሲ ሴጣናሶን ዎቾንቲሲ ስካሎሲ የርአ ኤሱናዋ። ዳምኒ የሱስኒ ኦትማስ ንቶኔን አነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ታኔን አነ ዎስቴፌ ትሞትዮስ ናጋ ንቶክ ማኬዋ። ኤሲስማቶ አይሁድ ስና ኮንታ ሉቅዮስ፥ እያሶንናዋ ሶስፓትሮስና ናጋ ንቶክ ማክሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ሀን ዎሲያሶን ትች ታ ጠርትዮስ ደይ ዳሚሲክ ናጋ ንቶክ ማኬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ታናዋ ሀንታክ ፋ ቤቴክርስታኒሲክቶኖን ዙትሬ እርባሲፌ ጋዮስ ናጋ ንቶክ ማኬድፌዋ። ካታማሲ ዋጋኖን ኩንስፌ ኤራስቶስ ደይ አይኒ ስና ቆአሪቶስ ናጋ ንቶክ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ዳምኒ የሱስ ክርስቶስኒ ኦትማስ ዙታምኒቲስኔን አነ ስንፋውጝዋ፤ ኣሚን! ");
INSERT INTO jnje_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","እቤኔን ኣቸራ ፋ፥ ሀሽ ደይ አምማኖን ኬሳ ፉቶኒ ኣቾ ቾዋሲኪ ካሞ ታ ማኬፋና የሱስ ክርስቶስኒ ቾዋሲክ ማኬፋ ምስራቹኒ ካማሲክ አማንቶኒትሲክ ችምማ የሮትክ ንቶትን ዛጉናክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ስኑንታኖ ሀሽ ኤስ ፉቶስ አምማኖን ኬስሳ ቤስቴዋ፥ ኮእባ ፎንቶ ሀኦሲ አጃጅክ ዙታምቤሲሴ አማነሬ አጃጃሞሶነክ ራጁኒ ሜኒ ማፃፋስኪ ካሞ ዳራስ ዙቴሬ አርሶነክ ዛግቴዋ። ");
INSERT INTO jnje_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ባር ባር ቴቹምባ ፋና እሳ ሀኦሲክ፥ የሱስ ክርስቶስኒኪ ካሞ ኮእባ ፎንቶኖን ጋላታ ስንፋውጝዋ፤ ኣሚን!");
INSERT INTO jnje_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ሀኦሲ ፍቃድክ ክርስቶስ የሱስኒ ዎሲ ስናናክ ቴግቴ ጳዉሎስናዋ አይኒ ስና ሶስቴኒሲክና፤ ");
INSERT INTO jnje_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ቆሮንጦስኒ ካታማሲ ፋ ሀኦሲ ቤቴክርስታኒክ፤ ባሪሲ ፌሴ ክርስቶስ የሱስኒክ ኮርቶ ስነ ባሶክናዋ ኮርቶ ስኖነክ ቴግቴ ባሶክና፤ ኤሲስማቶ ድማ ድማሲ ባሶክናዋ እኖክና ዳም ስና ዳምኒ የሱስ ክርስቶስኒ ሱናሶን ቴግሴፌ ባሶ ዙታምቤሲሴ አሲክ፤ ");
INSERT INTO jnje_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","አባን ስና ሀኦስክናዋ ዳም የሱስ ክርስቶስኒክና ኦቱምነዋ ናጋነ ንቶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ክርስቶስ የሱስኒኪ ካሞ ሀኦስ ኦቱምባሶን ንቶክ እምና ቦርአ ዎንና ዎንና ሀኦናሶን ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ዙታምባሴ አሲክ ዎላክ ስኑን አሩክ ክርስቶስ የሱስኒክ ኦቱም ስንነትዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ክርስቶስኒ ቾዋሲክ ማኬን ዛላስ ንቶኪክ ዛግራቱ ፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ኤስ ባሪ ቦርኣ ዳምኒ የሱስ ክርስቶስኒ አምማኖን ዮሶን ኦደት ፋሴፌት ካባሲክ ሀኦሲ አያናን እማስኒ እሳርንኑ ንቶክ ኣፋ ዮኡና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ዳምኒ የሱስ ክርስቶስ ዎል ሌ ዮና ዎኖ ዝኒት ፎንቶ ስንና ኮእባስታ ካርአናኔን ችማ ፎትክ ንቶትን ዛጋዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ናባ ስንና ዳምኒ የሱስ ክርስቶስኔን አነ እሳርኒት ፎናክ ንቶትን ቴጌ ሀኦሲ አማናምቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","አይታሳክቶኖ! «ንቶ ጋነያሲ ኦር ኦር ኬሳ ፎናታዋ፤ ዙታምኒትሴ እሳ ንባክናዋ እሳ ሳፋራክና ችምማ ፎትዋ» ይራ ዳምኒ የሱስ ክርስቶስኒ ሱናሲክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","አይታሳክቶኖ! ንቶ ጋነያሲ ፋሶ ፋናማቶ ኬሎኤኒ ኬር ፌሴ ሜያኪን ኦደጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ኤሲስ ደይ ንቶ እሳ እሳርኒትስ፦ «ታ፤ ጳዉሎስኒር፥ ታ፤ አጵሎስኒር፥ ታ፤ ጴጥሮስኒር፥ ታ፤ ክርስቶስኒርዋ» ይሴፌት። ");
INSERT INTO jnje_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ኤካን ክርስቶስ ባግቴዎሶ? ጳዉሎስ ንቶክዋ እያት ሱቴዎሶ? ወደይ ሀጱክቴሴቲስ ጳዉሎስኒ ሱናሲኮሶ? ");
INSERT INTO jnje_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ታ፤ ቀርስፖስንናዋ ጋዮስንናታኖ ንቶስን ኦኒንኑ ኣነ ሀጵቁት ስንና ቦርአ ሀኦናሶን ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ኤስ ባሪ ቦርኣ፦ «ታ፤ ጳዉሎስኒ ሱናሲክ ሀጱክቴጝዋ» ይሬ ማኮክ ችምኒር ኦኑ ኣፌዋ።  ");
INSERT INTO jnje_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ፉቶዋ፤ እስጥፋኖስኒ ኬርኪ ሜያኖን ሀጵቅጝዋ፤ ኤስ ባሶኔን ኦም ሀጵቅና አስሱ ፎባሶን ኣነ ያዳቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ክርስቶስ ታን ዎሲናስ ምስራቹኒ ካማሶን ማኮናክታኖ ሀጵቁናክታዋ፤ ክርስቶስኒ ሜስቀሊስ ሽማ ስንና ፉእቶኖይናማቶ ምስራቹኒ ካማሶን ማኬፋናስ አሱኒ ቴችማክ ቤስቴ ዎላክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ሜስቀሊሲ ካማ ትሹኒ ባሶክ ጎዉምማ ስንናቱ ፋድቴፋ፤ ስኑንታኖ ፋሩኒ እኖክ ሀኦኒ ሁግናዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","«ቴቹምኒ ሜኒ ቴችማሶን ትሽኩና፤ አሩኒ ሜኒ አሩሶን ሽማ ዛጉናዋ» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ኤካን ቴቹም አይፌሶ? ቱማሲ አሩ ደይ አይ ፌሶ? ሀን ነያሲ ቱእኒኚኛስ አይ ፌሶ? ሀኦስ ሀን ዳስታኪ ቴችማሶን ጎዉምማ ኣነ ዛጉዋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ሀን ዳስታኪ አሱኒ ሜያ ባሶ ቴትኒ ቴችማሲክ ሀኦሶን አሩ ችሞኖይቴማቶ ሀኦስ ቴቹምባሲክ ኩልፍዋ። ስኑንታኖ ጎዋንማቶ ፋድቴፌ እንኖ ማኬፌኒ ምስራቹኒ ካማሲክ አማነፌ ባሶትን ፋቱናክ ሀኦሲ ፍቃድ ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ኣጌኑ ስንፋናነ አይሁድኒ ሜያ ቢስቴራ አሪቶኖይ ዉዛ ብያ ሾልሴቴርዋ፤ ግሪክኒ ሜያ ደይ ቴችማቱ ሾልሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ስኑንታኖ እንኖ ክርስቶስ እኖክዋ እያት ሱቶባሶንቱ ማኬፌኒዋ፤ ኤስ ባር ደይ አይሁድኒ ሜያክ ቱሳ፤ ግሪክኒ ሜያክ ደይ ጎዉምማዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ስኑንታኖ ቴግቴ ባሶክ አይሁድ ስኖቶ ግሪክኒ ሜያክ ክርስቶስ ሀኦሲ ሁግናነዋ ቴቹምነዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ኤሲስ ደይ ሀኦሲ ጎዉምማ አሱኒ ሜኒ ቴችማስታን ደናሎዋ፤ ሀኦሲ ሆፕያ ደይ አሱኒ ሜኒ ሁግናስታን ደናሎዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","አይታሳክቶኖ! ሀኦስ ንቶትን ቴጌና ካባሲክ አዉነ ፌ አስሱ ስንነትማቶ ያዳቶትዋ። አሱኒ ሳፋራስማቶ ንቶ ጋነያስን ሾዎኒ ሜያ ቴቹም ወደይ ችም ወደይ አርቶ አስሱ ኣፍሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ስኑንታኖ ሀኦስ ቴቹምኒ ሜያኖን ኢሹናክ ሀን ዳስታኪ ጎዋንማቶ ፋድቴሴፌ አሱኒ ሜያኖን ኮሪዋ፤ ችምኒ ሜያኖን ኢሹናክ ሀን ዳስታኪ ፌሴ ሆፕኒማቶ ስንነ ፋድቴሴፌ ባሶትን ኮሪዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ሀኦስ ሀን ዳስታኪ አሱኒ ሜኒ ስንናክ ኡልፍንቶ ይስቴ ዉዛሲክቶኖን ኡልፍንቶኖር ስንባሶን ቤሱናክ፤ ሀን ዳስታኪ ዳካሎ ስና ባሮንናዋ ካሽስቶ ባሮንና ደይ ሽማ ስንና ዉዛሶን ኮሪዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ኤስ ባሮን ደይ ዛግናስ ኦኑ ሀኦሲ ስንናክ ባሳ ቴትኒ ሳፋራሲክ ቴቶኖይናማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ስኑንታኖ ሀኦስ ንቶትን ክርስቶስ የሱስኔን አነ እሳርኒት ፎናክ ዛግዋ። ኤስ ባሪ ቦርኣ ሀኦስ ክርስቶስ የሱስኒን እኖክ ቴቹምኒ፤ ኦኮኒ፥ ኮርቶኒናዋ ፉሪና ዛግራ እኖክ እሚዋ። ");
INSERT INTO jnje_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ኤሴ ማፃፋስሲ ደይ፦ «ቴቴፌ ባር ዳሚሲክ ቴቶዎዋ» ይስቴራ ትቼናማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","አይታሳክቶኖ! ታ፤ ንቶኪ ያና ካባሲክ ሀኦሲ ኣቾ ቾዋኖን ማኬናስ ዎሉምኒ ችማክ ወደይ አካማ ቴቹምኒ ቤሱክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ንቶኔን አነ ፋና ካባሲክ የሱስ ክርስቶስንናዋ ኤሲስ ደይ ሜስቀሊስታ ሱቴሬ ክቱባሶንታኖ ኦማ እሳ ዉዛኑ አሩኖይናማቶ ቡግራ ፋናር። ");
INSERT INTO jnje_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ኤስ ባሪ ቦርኣ ንቶኔን ፋና ካባሲክ ሆፕ ስንና ድጋክናዋ አካማ ቆርኩክናቱ ፋኒ። ");
INSERT INTO jnje_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ዎሉምናሴዋ ማኮናሴ አሱኒ ቴችማክናዋ ዎሉምኒ ካቱክ ስኖይናሮን ሀኦሲ አያናኒ ሁግናኖን አምማኖን ቤሱክዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ኤስ ባሮን ደይ ዛግናስ አማንቶኒቲስ አሱኒ ቴቹምታ ካፑቴር ስኖይናሮን ሀኦኒ ሁግናክ ቴቶናክዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ስኑንታኖ አያናክ ፎክ ችም አሱኒ ሜያክ ቴችማክቱ ማኬፌን፤ ስንፋናክኑ ማኬፌኒስ ደይ ሀን ዳስታኪ ቴችማክ ወደይ ትሹኒ ሜኒ ሀን ዳሶን ሀእስሴፌ ባሶ ቴችማክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ስኑንታኖ እንኖ ማኬፌኒስ ሀኦስ ዜምማ ሾዎ ነያኔን እንኖ ኡልፍናሲክ ሆስና ባሬዋ ኣቼራ ፋ ሀኦሲ ኣቾ ቾዉኒ ቴችማኖንዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ሀን ዳሶን ሀእሲፌ ባሶ ጋነያስን ሀን ቴችማሶን አሪር ኦኑ ኣፌ፤ አርሴቴ ስንፋናነ ኡልፍንኒ ዳሚስን ሱቶሶነ ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ስኑንታኖ ማፃፋስሲ፦ «ኣፋ ብኖይናሶን፤ ኦዶ ኦዶኖይናሶን፥ አሱኒ ንባ ሳፋሮኖይናሶን፤ ሀኦሶን ሹንፌ ባሶክ ሆሲዋ» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ስኑንታኖ እኖክ ሀኦሲ አያንባሲክ ካሞ ኣቾ ቾዋሶን አምማኖን ቤስዋ። ሀኦሲ አያና አካማኖን ኣቾ ስና ሀኦሲ ቾዋኖኑ ፉኦኖይ ዙትራ ቱእኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","አሱኒ ቾዋሲክ ስናር ስንፋናነ ባሳ ቴትኒ አያናስታኖ ኦማ ባሳሲ ፋ ሳፋራሶን አሪፌር ኦንሶ? ኤሲስማቶ ሀኦሲ አያናታኖ ሀኦሲ ሳፋራኖን አሩኒር ኦኑ ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ሀኦስኪን እምቴ ዉዛሶን አሩኒክ ሀኦሲ አያናኖንቱ ኤጳታኒታኖ ሀን ዳሲ አያናኖን ኣነ ኤጳቶዌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ኤስ ባር ደይ አያናኒ ዉዛሶን አያናክ ፌሴፌ ባሶክ ማኬፌኒስ አሱኒኪን ቤስቴፋ ቴችማሲክ ስኖይናሮን ሀኦኒ አያናስኪን ቤስቴፋ ቴችማሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ስኑንታኖ ሀኦሲ አያና ባሳሲ ትሽፋን አሻክ ፌፌ አስሱ ሀኦኒ አያናስኪን እምቴፋ ዉዛሲክቶኖን ኣፋ ኤጴቶና ዉዛ። ኤስ እምቴ እማሶን ቱኡኒፌናስ ሀኦሲ አያናኪ ካሞ ስንና ቦርአ ኤስ አሱስ ያዳቶናክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ስኑንታኖ ሀኦኒ አያና ባሳሲ ፋና ባር ዙታምባሴ አስን ቱእኒር። ስኑንታኖ ባር ቴትባሲክ ኦንክኑ ኣነ ቱእንቴፌ። ");
INSERT INTO jnje_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ኤሲስ ደይ፦ «ዳሚሳ ሳፋራኖን፤ ኦ አሩክ ችምንሪንሶ? ባሪን ኪቱክ ችምንር ኦንሶ?» ይስቴራ ትቼናስማቶ፥ ስንፋናክኑ ክርስቶስኒ ንብባሲ እንኖሲ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","አይታሳክቶኖ! ታ፤ ንቶትን አስፋና ካባሲክ አሽኒ ሳፋራክ ክርስቶስኒኪ ሀሽኑ ችምማ የሮኖይ ዳጋ ናንጎታ ስንነትማቶታኖ ሀኦኒ ካማክ ፌሴፌ ባሶሲማቶ ዛግራታዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ችማ ሙኒ ሙክ ችምኖይ ዳጋ ናንጎታ ስነት ቦርአ ታ፤ ንቶትን ሻቦታኖ ችማ ሙ ኣነ ማሱትዋ፤ ሀሽኑ ስንፋናክ ንቶ ችማ ሙኒ ሙክ አነ ችሜትዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ንቶ ሀሽኑ አሽኒ ሳፋራክ ፌ አሱዋ፤ ንቶትና ንቶትና አስሲ ዎል ኮኖነዋ ካራካሮነ ፋር ስንና ቦርአ አሽኒ ሳፋራክ ፌር ስንትታኖሶ? ዎስቴት ፋሴቲ ዎስቶስ ደይ ባክ አሱኒማቶታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","እሳር፦ «ታ፤ ጳዉሎስኒርዋ» ኦሚስ ደይ፦ «ታ፤ አጵሎስኒርዋ» ይፌና ካባሲክ ባክ ሀን ዳስታኪ አስሱ ስኒትሶንታኖሶ ቤሲፋናሪ? ");
INSERT INTO jnje_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ሻካፎት አጲሎስ ኣምቤንሶ? ጳዉሎስ ኣምቤንሶ? ባሶ ንቶ አማኖትክ ዛግ ዎስትኛዋ፤ እሳ እሳርቤሲስ ዎስቴሴፌስ ዳሚሲክ ባሶክ እምና ዎስቶሶጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ታ፤ ቶኪን፤ አጵሎስ አካ ኡሽ፤ ስኑንታኖ ድቺስ ሀኦስዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ኤስ ባሪ ቦርኣ ዎስቶሲክ አሪክሮን ሾልሱ ስናስ ድች ሀኦስታኖ ቶካ ባር ስኖ አካ ኡሽ ባር እሳ ዉዛታዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ቶካ ባር ስኖ አካ ኡሽ ባር እሳ ባርዋ፤ እሳ እሳርባስ ዎስቶባስማቶ ቴትባሲ ዋጋኖን ኤጴቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","እንኖ ንቶኔን አነ ሀኦሲክ ዎስቴ ዎስትኛዋ፤ ንቶ ደይ ሀኦሲ ፎሽነዋ ሀኦሲ ሹእኒ ኬነዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ሀኦስ ታክ እምና ባሪ ኦትማሲማቶ እሳ ሀጤ ሹእኒ ኬያ ኬርእፌ ኬርእኛንማቶ ካፑታ ኩንስንዋ፤ ኦሚስ ደይ ታ፤ ካፑትና ካፕታስታቱ ኬርአናዋ። ስኑንታኖ እሳርባ እሳርባስ ኤስ ባርስታ ኣካክ ኬርአናማቶ አሩናክ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","እሳርጋ ካፑቴ ካፕታስታን ኦኑ ኦማ ካፕታ ካፑታናክ ኣፋ ችማናዉዛ፤ ኤስ ካፕታስ ደይ የሱስ ክርስቶስዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ኦኑ ኤስ ካፕታስታ ዋርቄክ ወደይ ብሪክ፤ ማአ ኡልፍንቶ ሹአክ ወደይ እኦክ፤ ሻአክ ወደይ አጋዳክ ኬርአር ፌፋናነ፤ ");
INSERT INTO jnje_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","አስሱ እሳ እሳርባሳ ዎስቶ አምማኖን ኬስሳ ቤስቶና ማጝሱኒ ካርኒ ዎናስ ዮናዋ፤ ኤስ ዎኖ እሳ እሳርባሳ ዎስቶ አዉነፋር ስንናማቶ ጌያክ ፋታንቴራ ቢስቶና። ");
INSERT INTO jnje_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","እሳ ሹኒ ኬያ ኬርእኛአስ ካፑትና ካፕታስታ ዎስቴና ዎስቶስ ጌያክ ፋታንቴራ ኪቾኖይ ፉእቴፋናነ ሹኒ ኬያሶን ኬርአ ባር ዋግባሶን ዳናናዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ዎስቶባስ ጌያክ ኪቼና ኬርእኛአስ ዳናና ዋግባሶን ቱርኩናዋ፤ ስኑንታኖ ባር ቴትባሲክ ጌያሲ ካሞ ኣትፋት ኪቾኖይ ፉእቴ አሱኒማቶ ስንኔ ፋሩናዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ሀኦሲ ቤቴሜቅደስ ስኒትማቶናዋ ሀኦሲ አያና ደይ ንቶስሲ ፋፋናማቶና ኣነ አሩዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ኤሴ ኦኑ ሀኦሲ ቤቴሜቅደስኖን ቦጋናነ ሀኦስ ባሪን ቦጋርዋ፤ ሀኦሲ ቤቴሜቅደስ ኮርቶዋ፤ ኤስ ቤቴሜቅደሲሲ ደይ ንቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ንቶስን ኦኑ ቴትባሶን ኤሻናታዋ፤ ሀን ዳስታኪ ቴቹምኒ ጌፋሲክ ቴቹም ስንነ ቤስቴር ፌፋናነ ሀኦሲ ፉቶ ቴችማኖን ዳናናክ ቴትባሶን ጎዋ ዛግሬ ፋዱዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ሀን ዳስታኪ ቴችማስ ሀኦሲ ስናክ ጎዉምማዋ፤ ኤሲስ ደይ ማፃፋስሲ፦ «ሀኦስ ቴቹምኒ ሜያኖን ማጙቤሲሲክ ባሶትን ኤሽሚያ ስንና ኤጳናዋ» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ኤሲስማቶ ደይ፦ «ዳሚስ ቴቹምኒ ሜኒ ሳፋራስ ሽማ ስንናማቶ አሪፌኒዋ» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ኤስ ባሪ ቦርኣ ዙታምባሴ ንቶር ስንና ቦርአ ኦኑ አሱኒክ ቴቶናታዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ጳዉሎስ ስንፌናክ አጲሎስ ስንፌናክ ጴጥሮስ ስንፌናክ ሀን ዳስኑ ስንፋናክ ካስኑ ክቱስኑ፤ ሀሽቲ ፋ ባርኑ ስኑን ዮኒ ባር ዙታምባሴ ንቶርዋ። ");
INSERT INTO jnje_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ስኑንታኖ ንቶ ክርስቶስኒር፤ ክርስቶስ ደይ ሀኦኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ኤሴ አስሱ ዙታምባሴ እኖትን ክርስቶስኒ ዎስትኛ ስንኒማቶናዋ ሀኦሲ ኣቾ ቾዋኖን አምማኖን ክስሬ ማኮኒ ሀእሱኒ ሁግና እምቴና አዳራ ኤጶ አስሱ ዛግሬ ፋዱናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","አዳራ ኤጳ አሱኒ ሜያ አማናምቶ ስነሬ ቤስቶሶነክቱ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ታ፤ ቾዋሲክ ስንፋናነ ንቶኑ ታይስታ ማጝሱ ካርኤፌትክ ወደይ ኦም አስሱ ታይስታ ማጝሱ ካርፌናክ እሳ ግድና ኣፋዋ። ፉቶሲክ ታ፤ ታ፤ ቴታሲክ ታይስታ ማጝሱ ካርአናክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ታ፤ አሪፋናሲማቶ ስንፋናነ ካኑናስ ኣነ ታን ዋቃሴፋዋ፤ ስኑንታኖ ታይስታ ማጝሱ ካርኒስ ዳሚስ ኮእባዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ኤስ ባሪ ቦርኣ ዎንባስ ካርኖይፌን ወደይ ዳሚስ ማጝሱኒ ካርአክ ዮኖይፌን ኦኒስታኑ ማጝሱ ካርአቲታዋ፤ ባር ዬና ዎኖ ታልማሲ ኣቸራ ፋ ኣቾ ቾዋሶን ቻሬፋስታ ክሱናዋ። አሱኒ ሜኒ ንብባሲ ኣቸራ ፋ ሳፋራሶን አምማኖን ክሱናዋ፤ ኤስ ካባሲክቱ አስሱ እሳ እሳርባሲክ ሀኦስኪን ሾልሱ ጋላታ ዳናናዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","አይን ሜያነ! ንቶክ ኬእኒ ዉዛሲክዋ እያት ሀን ቾዋሲክ ታናዋ አጲሎስኒንና ቤሶ ዛግራ ማኬጝዋ፤ ኤስ ባሮን ደይ ዛግናስ፦ «ትቼ ባሪስታን ኣታታታዋ» ይፋ ኪቶሶን እኖኪን አሩትክዋ እያትዋ። ኤስ ባሪ ቦርኣ እሳ አሱኒክ ቴቴፋት ኦሚስን ካሹትክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ነ፤ ኦሚሳታን አዉክ አርኩታስሶ? ኦሚስኪን ኤጳቶኖታ ዉዛ ኣምባንሶ? ኤካን ዙታምባሴ አስን ኤጳ ታታስ ኦሚስኪን ስንናኔን ኦሚስኪን ኤጴቶኖይ አሱኒማቶ አዉኒሮን ቴቴፋስሶ? ");
INSERT INTO jnje_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ሀሽኑ ንቶክ ሾልሲ ዉዛሶን ዙትራ ዳንትዋ! ሀሽኑ ደይ ኦቱም ስንነትዋ! እኖስታን ኦር ኬስሳ ታቶ ስንትዋ! ፉቶክ ታቶ ስነት ስንፋናነ እንኖ ደይ ንቶኔን አነ ታቶኒር ስንና ቦርአ ማአሪ ስንናና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ኤስ ባሪ ቦርኣ ሀኦሲ ዎሲ ስና እኖትን ክቱኒ ማጝሱኒ ካርአ ባሶስታ ካቴን ዎርቶሶነ ድማ ኦቴሬ ሀሜፌ አሱኒ ሜኒ ጋነያስን ኮእኒስ እንኖ ስንማቶቱ ታክ ቤስቴፋዋ። ኤስ ባርስታን ካብ ቾዋ ሀን ዳ ዙታምባሴ አሲስ ሀኦኒ ዎስያኑ ስንፋናክ አሱኒ ሜኒ ስንናክኑ ስንፋናክ ቢስቶኒ ዉዝንማቶ ስንና ቤስቴፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","እንኖ ክርስቶስኒክዋ እያት ጎዋ ስንኒዋ፤ ስኑንታኖ ንቶ ክርስቶስኒኪ ካሞ ቴቹምኒ ሜያ ስንነትዋ፤ ኤሲስማቶ እንኖ ሆፕን ሜያ ስንኒዋ፤ ስኑንታኖ ንቶ ደይ ችምቤሲ ፋና ሜያ ስንነትዋ፤ ንቶ ደይ ኡልፍንቶ ስንነትዋ፤ ስኑንታኖ እንኖ ሳልጳቴር ስንኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ኤስ ሳአትስ ካርአና ካባኔን ማክቴፌኒ፤ እክቴፌኒ፤ አታቱ ስንፌኒ፤ እቼፌኒ፤ ዱኒ ኬያ ቱርኩክ ራካቴፌኒ። ");
INSERT INTO jnje_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","እንኖ ቴትኒ ኩሹሲክ ዎስቶክ ሆፕፌኒ፤ እኖትን ኤርውሴፌን ኤቢስፌኒ፤ ካብግሴፌን ፋክፌኒ፤ ");
INSERT INTO jnje_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","እኖትን ሜእኤፌንናዋ ሱንኒሶን ማጝስሴፌንና ማአሮን ባሶክ ዎልግፌኒ፤ ኤሴን ሀውጙ ካርአ ሀን ዳስታክ ሀእቶ ዉዝነዋ ፉትቴራ ሀእቴ ዲምነ ስንኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ታ፤ ሀን ባሮን ንቶክ ትችናስ ሹንቶ ናንጎትና ስንነትማቶ ዛግራ ኪቱናክታኖ ንቶትን ኢሽሹናክዋ እያታዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","አዉኑ ስኑን ክርስቶስኒኪ ካሞ ሾዎ ዞንስንቲ ፌፌናክኑ ሾዎ አባንት ኣፌዋ፤ ስኑንታኖ ታ፤ ንቶትን ክርስቶስ የሱስኒ ምስራቹኒ ካማሲክ ኮንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ኤስ ባሪ ቦርኣ ታ፤ ቤሶሲክ ዞኑስቶትክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ኤስ ቾዋሲክ ሹንቶናዋ አማናምቶና ስንና ደይ ዳሚሲክ ናታ ስና ትሞትዮስኒን ንቶኪ ዎስጝዋ። ዳ፤ ዳስንናዋ ሾዎ ቤቴክርስታኒስንና ታ፤ አሲፋናይሲማቶ ባር ታ፤ ክርስቶስኒኪ ካሞ ዳና ጋድዶ ካሲ አጃጅኖን ንቶክ ያዳሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ንቶስን እሳ እሳይስ ንቶትን ብያክ ዮ ቤያናርነ ፋር ስንና ባሶክ ቤስቴፋን ቤጋንቶክ ቱሜሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ስኑንታኖ ዳሚሳ ፍቃድ ስንፋናነ ሀን ታአ ዎናስሲ ንቶኪ ዮናዋ። ኤስ ካባሲክ ኤስ ቤጋንቴሴፌ ባሶ ዎላሶን ኮእባ ስኖይናሮን ሁግናቤስሶንኑ አሩናክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ሀኦሲ ታቶ ዎሉምኒ ቾዋታዋ፤ ስኑንታኖ ሀኦኒ ሁግናዋ። ");
INSERT INTO jnje_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ሾሌፌትስ ኣምባንሶ? ኬኦኒ ሃሮ ኤጳ ንቶኪ ዮናክጝዋ ወደይ ኬሽታናክናዋ ጋራምኒ አያናክና ዮናኪ ሾሌፌትሪ? ");
INSERT INTO jnje_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ንቶ ጋነያሲ ኢቹ ሶሎኒ ዝና ፋናማቶ ዎሉምቴድፋርዋ። ኤስ ኤፋቴና ሶሎኒ ዝናስ አዛብኒ ሜኒ ጋነያስኑ ኣነ ዛግቴፋዋ። ኤሲስ ደይ ቱሽኒ እንቶባሶን አስሱ ዛግሬ ኤጳ አስሱ ንቶ ጋነያሲ ፌርዋ ይስቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ኤካን ኤስ ኤፋቴና ኢቹ ቾዋ ንቶ ጋነያሲ ፌን አዉኒሮን ቤጋንቴፌትሶ? ኤሲስታን ሀን ቾዋሲክ ሱሞትክ ኣነ ሾልሱዋኖሶ? ኤስ ኤፋቴና ዎስቶሶን ዛግ አሱስን ንቶ ጋነያስን ኦር ክሱትዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","አዉነ ፋሮን ታ፤ አሻክ ንቶኔን አነ ፎ ቤይፋናክኑ አያናክ ንቶኔን አነቱ ፋዉጝዋ፤ ንቶኔን አነ ፋናሪማቶ ስንና ኤስ ኤፌቴና ዎስቶሶን ዛግ አሱሳታ ዳሚሳ ሱናክ ማጝሱ ካርእጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ዙቴሴፌት ካባሲክ ታ፤ ደይ ዳም የሱስኒ ሁግናሲክ ንቶ ጋነያሲ አያናክ ፋናር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ቦርአክ ቱሜ ፌ ሀን አሱሳ አሻ ትሹናክ ሴጣናሲክ ኣትራ እማትክ ሾልሱዋ። ኤስ ባሮን ደይ ዛጉሶቲስ ዳም የሱስ ማጝሱኒ ካርአክ ዬፌና ዎኖ ኤስ አሱሳ ካ ፋሩናክዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ኤሴ ቴቶንትስ ማአርታዋ፤ ኪስኩ ማሶስ አካማ ቱሾሶን ክስፋናማቶ ኣነ አሪፌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ሀሽቲ ስንትስማቶ ማሶባ ፎንቶ ኦራ ቱሾንማቶ ስንናትክ ሀጅፋ ድ ማሶሶን ትሽኩትዋ። እኖክ ፋስካኒ ፋንቱ ስንና ክርስቶስ ሹክቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ኤስ ባሪ ቦርኣ ማጙነዋ ቤጋንቶነ አስክ ቱምማ ሀጅራ ድ ማሶሲክ ስኖይናሮን ማሶባ ፎንቶ ጋራማክናዋ ፉቶክና ቂጣኒ ኤቦሶን ኡልፍንሱኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ዜሞቲ ንቶክ ትችና ዎስያሲክ ሶለፌ ባሶኔን አነ እሳር ስንናትታ ይራ ፋናርዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ኤስ ባሮን ደይ ይናስ ዙቲ ኤጳ ሀን ዳስታኪ ሶልሴፌ ሜያኔን ወደይ ጆርሴፌ ባሶኔን ወደይ ዊስኒ ሜያኔን ወደይ ኮልሎ ሺጲሴፌ ሜያኔን አነ ፎቲታ ኡናታዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ስኑንታኖ ታ፤ ሀሽ ትችና አማኝኒ ሜያ ይስቴፋት ሶለሴፌ ባሶኪን ወደይ ጆሬሴፌ ባሶኪን ወደይ ኮልሎ ሺጵሴፌ ባሶኪን ወደይ አሱኒ ሱና ማጝስሴፌ ባሶኪን ወደይ ዛየሴፌ ባሶኪን ወደይ ቦኤሴፌ ባሶኔን አነ እሳር ስንናትታዋ ኡናዋ። ኤስ ኤፌቴና አሱኒ ሜያኔን አነ ሙኑ አነ ሙቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ክርስታናኒ ሜኒ ማባራሲ ጌራካሎ ፌሴ አሱኒ ሜያስታ ማጝሱ ካርኒስ ታ፤ ኦንሶ? ክርስታናኒ ሜኒ ኬርካሎ ፌሴ አሱኒ ሜኒ ቾዋሲክ ንቶ ቴትንትሲክ ማጝሱኒ ካርአ ችምቲርታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ጌሮክ ፌሴ አሱኒ ሜኒ ቾዋሲክ ማጝሱ ካርኒስ ሀኦስዋ፤ ኤሴ ማፃፋሲ፦ «ማጙ አሱስን ንቶ ጋነያስን ኦር ክሱትዋ» ይፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ንቶስን እሳይስ ክርስታና ስና አይባስኔን አነ ፋሴፋናነ ቾዉባሶን ክርስታናኒ ሜያ ብዮነክ ዛጉስታን ማላቶናክ አማኖኖይ ሜኒ ሾንጎስታ ሀማናክ ኣካክ ችምሶ? ");
INSERT INTO jnje_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ሀኦኒ አሱኒ ሜያ ሀን ዳስታክ ማጝሱ ካርኦነማቶ ኣነ አሩዌትኖሶ? ኤካን ሀን ዳስታክ ማጝሱ ካርአትር ስንፌን ሀን ጋሮ ዉዛሶን ማጝሱኒ ካርአ ሆፑትሮሶ? ");
INSERT INTO jnje_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ሀኦኒ ዎስያስታኑ ማጝሱ ካርአኒር ስንናማቶ ኣነ አሩዌትኖሶ? ኤካን ሀን ዳስታኪ ቾዋሲክ ኣካክ ዳይስራ ማጝሱ ካርአ ቤያኒርንሶ? ");
INSERT INTO jnje_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ኤሴ ንቶትና ንቶትና ዎል ፋሴፋትነ ክርስታናኒ ሜኒ ማባራስኔን ጌራካሎ ስና ካሽስቶ አሱኒ ሜኒ ስና ቾዉንትሶን ኣካክ ታእሱትሶ? ");
INSERT INTO jnje_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ሀን ባሮን ማኬናስ ኢችሹክዋ እያትዋ። ሻካፎቲ ንቶ ጋነያሲ አይኒ ሜያኖን ማጝሱኒ ካርአ ችምኒ አሩባ ፋና አስሱ ኣፌኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ስኑንታኖ አይ አይባስን ማላቴሬ አማኖኖይ ሜኒ ማጝሱ ካርኒ ኬር ኤጴ ሀማስ ሾልሱኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ኤሴ ንቶ ጋነያሲ ንቶትና ንቶትና ዎል ማላቴራ ካራካሬት ፎንቲስ ቴትባሲክ ሳልጲናዋ። ኤስ ባርስታን ንቶ ሚርአሜፋቲነታኖሶ ዋያይ? ኤሲስማቶ ንቶ ኤሽቴፋትነ ዋያታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ስኑንታኖ ንቶ አይንቲ ስና ክርስታናኒ ሜያስታኑ ሚርእኦነዋ ኤሽሹነ ካትድፌትርዋ። ");
INSERT INTO jnje_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ጃልሲፌ ባሶ ሀኦሲ ታቶሲ ኣፋ ግርሶነ ዉዛ ስንናማቶ ኣነ አሪፌትኖሶ? ኤስ ቾዋሲክ ኤሽቶቲታዋ፤ እግፌ ባሶ፤ ሶለፌ ባሶ ወደይ ኮልሎ ሺጵሴፌ ባሶ ወደይ ጌርኬሴፌ ባሶ ወደይ ኣርቃርና ኣርቃርና ዎል ኤጴፌ ባሶ፤ ");
INSERT INTO jnje_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ወደይ ዊስኒ ሜያ፥ ወደይ ጆርቱኒ ሜያ፥ ወደይ ዛይኒ ሜያ፥ ወደይ አሱኒ ሱና ማጝስሴፌ ሜያ፥ ወደይ ቦእኛኒ ሜያ ሀኦሲ ታቶሲ ኣፋ ግርሶነ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ንቶስን እሳ እሳይስ ኤሲስማቶ ስንና ፋሴትርዋ። ስኑንታኖ ሀሽ ዳምኒ የሱስ ክርስቶስኒ ሱናሲክናዋ ሀኦኒሲ አያናክና ቦርኒትስን ማስቴራ ካይምትዋ፤ ሀኦሲክ ኮርቴ ኮርቶ ዳራ ስነት ደይ ኦኮ ስንትዋ። ");
INSERT INTO jnje_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","«ዙታምባሴ ታክ ፋቃድቴዋ፤ ስኑንታኖ ዙታምባሴ ታክ ኣፋ ኬአናዉዛ፤ ዙታምባሴ ታክ ፋቃድቴዋ፤ ስኑንታኖ ኣፋ ዉዛሲክኑ ቦዛ ስንና ኣፋ ሀእኡና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ሙስ ካትንርዋ፤ ካታስ ደይ ሙኒርዋ» ኤካን፤ ሀኦሲ ሙሶን ጌዳ ካታሶን ጌዳ ትሽኩኒርዋ። ስኑንታኖ አቱኒስ ዳምኒ የሱስኒርዋ፥ ዳም የሱስ ደይ እንኖ አቱኒስር ስንና ቦርአ አቱኒስ ጌርኬሳሲ ዎስቶኖን ዎስቶናክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ሀኦስ ዳም የሱስኒን ክቱን ካብግዋ፤ እኖትን ደይ ሁግናባሲክ ክቱን ካብጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","አቱንቲስ ክርስቶስኒ አቱኒ ባግቶ ስንናማቶ አሪትርታኖሶ? ኤካን ክርስቶስኒ አቱሶን ኤጳ ታምማ ሶለፋ ማሽካሱሲ አቱስኔን አነ እሳር ስናናክ ዛጉ ሾልሱኖሶ? እሳንነ ኣነ ሾልስፋዋ! ");
INSERT INTO jnje_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ሶለፋ ማሽካሱስኔን አነ ኩንፌ አስሱ ባርኔን አነ እሳ አቱ ስንባሶን አሪትርታኖሶ? «ሄፖቤሲሴ እሳ አቱ ስኖነዋ» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ስኑንታኖ ዳም የሱስኔን አነ እሳር ስንፌ ባር ባርኔን አነ አያናሲክ እሳር ስንፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ኤስ ባሪ ቦርኣ ጌርኬሳስታን ዎክትዋ፤ አስሱ ዛግፌና ቦርኣስ ዙቴራ አቱባስታን ጌራካሎቱ ዛግፌዋ፤ ስኑንታኖ ጌርኬስፌ አሱስ ባሳ ቴትኒ አቱስታቱ ቦርአ ዎስቴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ንቶ አቱስ ሀኦስኪን ኤጳ ታቲ ባሬዋ ንቶሲ ፋ ኮርቶ አያናሲ ቤቴሜቅደስ ስንናማቶ አሪቲርታኖሶ? ኤሴ ንቶ ሀኦሲርቴኖ ንቶ ንቶ ቴትኒርቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ባር ንቶትን ዋጋክቱ ዋጌዋ፤ ኤስ ባሪ ቦርኣ አቱንትሲክ ሀኦሶን ኡልፍንሱትዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ንቶ ታክ ትችቲ ቾዋሲክ አስሱ ማሽካሱኔን አነ ኩኑ ሻካናነ ማአሪዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ስኑንታኖ ጌርኬሳስታን ዎካክ ኣርቃሱ እሳርባ እሳርባስ ቴትባሪ አሱባ ፎጝዋ፤ ማሽካሱ እሳርባ እሳርባስ ቴትባሪ ቴጎባይ ፎዎዎ። ");
INSERT INTO jnje_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ቴጎ አሱባሲክ ዛጉናክ ሾልሲ ባሮን ካላናታ፤ ኤሲስማቶ አሱስ ደይ ቴጎባሲክ ሾልሲ ባሮን ካላናታ። ");
INSERT INTO jnje_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ማሽካአሱስ አቱባስ ባር ባርሪርታዋ፤ ቴጎሳርኔንጝዋ፤ ኤሴ ደይ ቴጎ አቱባስ ባር ባሳርታዋ፤ አሱባስርኔንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ችምማ ሀኦኒ ሺጶክ ሄፖንቲሴ ንቶትና ንቶትና ዎል ሜርኬራ ጋሮ ዎኒሮን ስና ሻካናነ ኦር ኬስሳ እሳይስ ኦሚሳ ማብትኖን ካላናታዋ። ኤስ ባሪ ቦርኣ ቴትንትሶን ኦዳ ሆፕራ ሴጣናክ ፋታንቶኖይትማቶ ዎላ እሳሪክ ፎትዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ሀን ባሮን ይፋናስ ደይ አጃጅኒማቶ ስኖይናሮን ኪቶዋ እያትዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","አስሱ ዙቴሬ ታይሲማቶ አስሱ ኤጵኖይ ፌፋናነ ሹናና ካባዋ። ስኑንታኖ እሳርባ እሳርባሲክ ሀኦስ ኦማ ኦማ እማቱ እምዋ፤ እሳይሲክ እሳ ቴሳ እማ እሚ፥ ኦሚሲክ ደይ ኦማ ቴሳ እማ እሚዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ግሩኖይ ባክ ዲሴ ባሶናዋ ቴጎቤስ ክትና ማሽካሱሲክቶነ አሲክ ይፋናስ ደይ ኤሲስዋ፤ ግሩኖይ ታማቶ ስንነ ፋሴፋቴነ ማአሪዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ስኑንታኖ አሽኒ ኤናንቶክ ኪቾስታን ኤጳ ዋያ ስንና ቦርአ ቴትቤሲሶን ሀእሱ ሆፕሴፋቴነ ኤጶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ኤጳ ባሶክ ደይ እማና አጃጂስ ሀንስዋ፤ ኤስ አጃጂስ ደይ ዳሚሳርታኖ ታርታዋ፤ ግሪ አስሱ ቴጎባሳታን ኦር ኬሳናታዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ኦር ኬስፋናነ ግሩኖይናማቶ ቴትባክ ባክ ዱን ወደይ ቴጎባስኔን አነ ጋኖን፤ ኤሲስማቶ ቴጎ አሱባሶን ኮፍኩናታዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ስኑንታኖ ኦምኒ ሜያክ ዳሚስ ስኖይናሮን ታ፤ ቴትናሲክ ይፋናስ ኤካዋ፤ እሳ ክርስታና ስንና አስሱ ክርስታና ስኖይ አሱባ ፋፋናነናዋ ባርኔን አነ ፎናክ ሾሌፋናነና ጋፍኩናታዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ክርስታና ስና ማሽካሱ ክርስታና ስኖይ ቴጎባይ ፌፋናነናዋ ባር ባርኔን አነ ፎናክ ሾሌፋናነና ባሮን ኮፍኩናታ። ");
INSERT INTO jnje_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ክርስታና ስኖይ ቴጎስ ክርስታና ስና አሱባሲ ቦርአ ሀኦኒ አስሱ ስንናናዋ፤ ክርስታና ስኖይ አሱስ ደይ ክርስታና ስና ቴጎባይሳ ቦርአ ሀኦኒ አስሱ ስንናናዋ፤ ኤካ ስና ሻካናነ ንቶ ናንጎታስ ሀኦኒ ናንጎታ ስናናክ ኣፋ ችማናዉዛ። ስኑንታኖ ኤስ ባርክ ፋሴፋትነ ናንጎትኒትስ ሀኦኒ ናንጎታዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ክርስታና ስኖይ ባር ኦር ኬሳናክ ሾሌፋናነ ኦር ኬሶዋ፤ ስኑንታኖ ኤስ ባርኪ ክርስታና ስንና ቴጎስ ስኖ ክርስታና ስንና አሱስ ኣፋ ቾዋክኑ ግድክ ኣፋ ኦድቶና ዉዛ። ሀኦሲ እኖትን ቴጌናስ ናጋክ ፎኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ነ፤ ክርስታና ማሽካሱሴ፤ ክርስታና ስኖይ ቴጎኔስን አዉዛክነ ፉኦታቶ አዉ አሪፋስሴ? ነ፤ ክርስታና ስና ኣርቃሱሶ! ክርስታና ስንኖይ አሱኔሶን አዉዛክነ ፉኦታቶ አዉ አሪፋስሶ? ");
INSERT INTO jnje_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","እሳ እሳርባሲክ ዳሚስ ባርክ እምና እማሲክናዋ ሀኦስ ባሪን ቴጌና ካባሲክ ፌና ፎሲክና ፎዎዋ። ቤቴክርስታኒሲክቶክ እምና ቱማስ ኤሲስዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ኦኑ ሃርኮ ኩናኔን ኦርፎ ቴግቴር ስንፋናነ ሃርኮ ኩኖይነ ፌር ስንነ ሳፋሮናታዋ። ሃርኮ ኩኖይ ቴግቴር ስንፋናነ ሃርኮ ኩናናክ ሾሎናታዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ሃርኮኒ ኩና ስኑን ኩኑ ቤያ ዋግባ ኣፋዋ። አርክ ዉዛስ ሀኦሲ አጃጅኖን ኦዳስዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ኤስ ባሪ ቦርኣ አስሱ እሳ እሳርባሲክ ሀኦሲ ባሪን ቴጌና ካባሲክ ፌናማቶ ችምሜ ፎዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ሀኦስ ኔን ቴጌና ካባሲክ ቦዝ ስንና ፋታሮሶ? ስንፋታነዎ ግድባ ኣፋዋ ራካቶታታዋ። ስኑንታኖ ብርማዱምማ ኬስኒ እጣ ዳንፋታነ ኤስ እጣስ ነይስታን ኣታናታዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ቦዝ ስንነ ፌን ዳሚሲክ ቴግቴ አሱስ ዳሚሲክ ብርማዱምማ ዳኒዋ። ኤሲስማቶ ደይ ብርማዱምማ ኬሴ ፌን ቴግቴ አሱስ ክርስቶስኒ ቦዝዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ዋጋክ ዋግቴት ቦርአ አሱኒ ቦዝ ስንናትታዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ኤስ ባሪ ቦርኣ አይታሳክቶኖ! አስሱ እሳ እሳርባሲክ ቴግቴፌና ካባሲክ ፌና ፎስማቶ ሀኦሴን አነ ዛግሬ ፎዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ግሩኖይ ወደይ ኤጵኖይ ዲሴ ባሶ ቾዋሲክ ዳሚስኪን ኤጵና አጃጅ ኣፋዋ። ስኑንታኖ ዳሚሳ ፋክያክ አማናምቶ አስሱ ስንናማቶ ታ፤ ኪቶሶን እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ሀሽቲ ፋኒ ዎናስ ራኮኒ ዎና ስንና ቦርአ አስሱ ኤጵኖይ ወደይ ግሩኖይ ባክ ፎባስ ማአሪነ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ስንፋናክኑ አስሱ ኤጲት ስንፋታነ ጋፍኩክ ሾሎታታዋ፤ አስሱ ኣነ ኤጴ ስንፋታነ ኤጳክ ሽሎታታዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ስኑንታኖ ነ፤ አስሱ ኤጳታነ ቦርአ ስኒርዋ ኡታዋ። ኤሲስማቶ እሳ ዱርባ ናዋ ግሪፋናነ ቦርአ ስኒርዋ ኡታዋ። ስኑንታኖ አስሱ ኤጵፌ ባሶ ሀን ዳስታኪ ሾዎ ፎኒ ራክኮ ባሶትን ኤጳርዋ። ታ፤ ሳፋራስ ደይ ኤስ ራኮስን ፉእቶትክዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","አይኒ ሜያነ! ታ፤ ንቶክ ማኮናስ ሀንስዋ፤ ዎናስ ካዉኒዋ፤ ሀንኔን ኤካሎክ አሱባ ፌና ባር አሱባ ፎንቶኒማቶ ስንነ ፎዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ዋስሴፌ ባሶ ዋሱኖይ ባሶይሲማቶ ስኖቶዋ፤ ግርሴፌ ባሶ ግሮሶኖይ ባሶነ ፌር ስንነ ፎሶቶዋ። ኮዳ ዋግሴፌ ባሶ እሳ ኮዳቤሲ ፎንቶ ዛግሬ ፋዱሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ሀን ዳስታኪ ባሶክ ኬእፋ ዉዛሶን ባሶክ ኬእኖር ዛግሬ ፋዱሶቶዋ። ሀሽቲ ፋ ሀን ዳስታኪ ዉዛስ ኣታርዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ኤስ ባሪ ቦርኣ እሳ ሳፋራክኑ ራካቶኖይ ፎሶትክ ሾሌፋዉጙዋ። አስሱ ኤጵኖይ ባር ዳሚስን ግርሱና ዉዛቱ ሾሌፌ ስንና ቦርአ ሳፋራባሶን ዳሚሲክ ሾልሱ ዎስቶታቱ ፌሽፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ስኑንታኖ አስሱ ኤጳ ባር አሱባሶን ግርሱክ ሀን ዳስታክ ፋ ዉዛሶንቱ ሳፋሬፌ። ");
INSERT INTO jnje_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ኤስ ባርክ ሳፋራባስ ሄፕክ ባግቴዋ ኡዋ። ኤሲስማቶ ግሩኖይ ማሽካሱስ ወደይ ዱርባ ናዋ አሽባሲክናዋ ካባሲክና ኮርቴራ ዳሚሳር ስንናክ ሾሌፋና ቦርአ ሳፋራባሶን ዳሚሲክ ሾልሱ ዎስቶስታቱ ፌሽፋዋ። ስኑንታኖ ግሪራ ድ ማሽካሱስ ቴጎባስን ግርሱናክ ሾሌፋና ቦርአ ሳፋሬፋና ሳፋራስ ሀን ዳስታኪ ዉዛሶጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ታ፤ ንቶክ ሀን ባሮን ማኬፋናስ ብርማዱምማንትሶን ካላክ ስኖይናሮን ንቶክ ኬአናዋ ኡክዋ። ታ፤ ሳፋራናስ ደይ ንቶ ማአ ፎ ፎትክናዋ ሳፋራንቲስ ባግቶኖይናሮን ቱማ ንባክ ዳሚሲክ ዎስቶትክናዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","እሳ አስሱ ቴጌሬ ዱስና ዱርባ ናዋሶን ኤጳ ቤያናክ ቡግናኔን ኦርፎ ኤስ ባሮን ዛጉባስ ናዋሲክ ማአሮን ኣነ ዛጉዌ ስንባሶን ሳፋሬፋናነ ባሮን ኤጳናክ ፋ ሳፋራባስ ዛጋ ስንፋናነ ባሶ ኤጵነ ግሩነ ዛጉስ ማአሪ ስንና ባሪክ ቤስቴፋናነ ኤስ ሾሌናሲማቶ ኤጳናነ ቦርአ ኣፍ ስንናናዉዛ፤ ኤጶዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ስኑንታኖ እሳ አስሱ ንብባሲ ዛግፋናነ ግድሱኒ ዉዛ ትሽፋናነ ባር ሾሌና ባሮን ዬቱክ ችምፋናነናዋ ቴጌና ናዋሶን ኤጳ ቤያናክ ቡግፋናነና ማአሮንቱ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ኤስ ባሪ ቦርኣ አስሱ ኤጳ ባር ማአሮንቱ ዛግ፤ ስኑንታኖ ኤጵኖይ ባር ደይ አካማኖን ማአሮንቱ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ግሪራ ድ አሱስ ቴጎባስ ካክ ፌናኔን ኤጵነ ግሩነ አሲ ቱማሲክ ታቴራ ፋርዋ። ስኑንታኖ ቴጎባስ ክትፋናነ ኦርፎ ባር ሾሌና አሱኒኪ ግሩናክ ብርማዱማባ ፋርዋ፤ ስንፋናክኑ ግሩና አሱስ ክርስታና ስናናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ስኑንታኖ ታ፤ ሳፋራሲክ ግሩኖይ ባክ ዲፋናነቱ አሪክሮን ግሬራ ፎናዋ። ሀኦሲ አያና ታይሲ ፋርነ ፋር ስንናቱ ታክ ቤስቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ኮሎክ ሹክቴ አሽኒ ቾዋሲክ ስንፋናነ ፉቶሲክ ዙታምኒሴ አሩኒ ፋርዋ፤ አሩስ ጌእስር፤ ስኑንታኖ ኬሽታናስ ችኒር። ");
INSERT INTO jnje_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","«አሩና ፋርዋ» ይት ሳፋሬፌ አስሱ ፌፋናነ አሩናክ ሾልስንናስንነ ፋሮን ሀሽኑ ኣነ አሩዌዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ስኑንታኖ ሀኦሶን ሹንፌ አሱስ ሀኦሲ ስንናክ አርቶ ስንናናዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ኤስ ባሪ ቦርኣ ኮሎክ ሹክቴ አሻሶን ሙኒ ቾዋሲክ ስንፋናነ ኮሎስ ቴትባሲክ ካባ ፎንቶ ስንናማቶናዋ እሳ ሀኦስታኖ ኦማ ሀኦ ኣፋ ስንናማቶ አሪፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","አዉኑ ስንፋናክ ሀኦ ስኖይ ሀኦ ይስቴራ ቴግቴፋ ሾዎ ሀኦነዋ ሾዎ ዳምኒ ሜና ደን ሳማክ ስኑን ሀን ዳስታክ ፌሴቴር ይስቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ስኑንታኖ ዙታምባሴ አሲን ቴሲስ እሳ አባ ሀኦ ኮእባ እኖክ ፋርዋ፤ እንኖ ደይ ባሪር ስንኒዋ። ኤሲስማቶ ዙታምባሴ ባርኪ ካሞ ቴስቴናማቶናዋ እንኖ ደይ ባርክ ፋፌኒ እሳ ዳም የሱስ ክርስቶስ ኮእባዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ስኑንታኖ ኤስ ባሮን አርሴፌስ አሱኒ ሜያ ዙታምባሴቴዋ፤ እሳ እሳይስ ሀሽኑ ኮሎኒ ሺጶ ዶስቴሴቴ ቦርአ አሻሶን ሜሴፌስ ኮሎ ሹክቴር ዛግሬዋ። ኤስ ባሪ ቦርኣ ካኑቤሲስ ሆፕያ ስንና ቦርአ ኪነፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ኤሴ ሀኦስኪ ታእሱኒስ ሙስታዋ፤ ሙቤይፌኒክ እኖክ ዮኡኒ ዉዝኒ ኣፋዋ፤ ማፌኒክ ቡእሱኒ ዉዛኒ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ስንፋናክኑ ሀን ብርማዱምማንቲስ አማንቶክ ዛጉኖይ አሱኒ ሜያክ ቱሳ ስኖይናማቶ ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","«አሩና ፋርዋ» እያት ኮሎክ ሹክቴ ባሮን ኮሎ ሺጵቴፋና ድማስታ ማፌን አማንቶባሲክ ዛጉኖይ አስሱ ኔን ቢፋናነ ኤስ ዎስቴታ ዎስቶኔስ አሱስ ኮሎክ ሹክቴ አሻሶን ሙናክ ዛግታርታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ኤስ ባሪ ቦርኣ ነ፦ «ታ፤ አሩዋ» ኡኔሲክ ክርስቶስ ክትና ባሪንናዋ አማንቶባሲክ ዛጉኖይ ክርስታናስንና ትሽክርዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ኤሲሲክ ክርስታና አይንትሳክቶኒን ሚርእኦክናዋ ሆፕያ ካኑቤሲሶን ማዛሱክና ክርስቶስኒን ሚርእኤፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ኤስ ባሪ ቦርኣ ሙስ ክርስታና አይታስን ቱሳእሱኒር ስንፋናነ አይታስን ቱሳእሱናስኔን እሳንነ አሻ ኣፋዋ ሙና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ታ፤ ብርማዱምማና ፋና አሱቴኖሶ? ታ፤ ዎስቴኖሶ? ዳምኒ የሱስኒን ኣነ ብዩቶሶ? ዳሚስኪ ካሞ ሆፕናሲ ጋና ንቶቴኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ዳሚሲክ ታ፤ ዎሲ ስንናሶን ቤስፋ ማታም ንቶ ስንነት ቦርአ ኦምን ሜያክ ዎሲ ስና ቤይፋናክኑ ንቶክ ፉቶሲክ ታ፤ ዎሲዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","«ዎሲ ስንኒ ማብትነ ኣፋዋ» ይሬ ታን ፋፌሲድፌር ፌሴፋቴነ ማኮና ዎልጉስ ሀንኒስዋ፤ ");
INSERT INTO jnje_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ኤካን እንኖ ሙንክናዋ ኡሻኒክና ማብትኒ ኣፋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ኦማ ዎስኒ ሜኒማቶናዋ ዳሚሳ አይኒ ሜኒማቶና ደይ ኬፋኒሲማቶ አማነ አስሱ ዞንስሬ ኩቱክ ማብትኒ ኣፋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ወደይ ዎስቶኒ ዎስቶክ ካቤት ፎ ሾልሲናስ ባርናባስኒክናዋ ታክና ኮእባኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ዳሞዛባ ፎንቶኖን ቴትባሪ ዋጋክ ሜያ ታርኦ ስንነ ዎስቶኒር ኦንሶ? ዋይኒ ቶኬ ጋንባሶን ሙኖር ኦንሶ? ምያ ኬምፌጌዶ ሚባሲ ሻቦኖን ኡሽኖር ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ሀን ባሮን ማኬፋናስ አሱኒ ሳፋራኒማቶኖሶ? ቱማስ ደይ ኤካ ኣነ ማኬፋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","«ሜያሶን እችፋ ጋቹዋሲ ኖኖኖን ታርአታታዋ» ይስቴራ ሙሴኒ ቱማስሲ ትቼዋ፤ ኤካን ሀኦስ ኤስ ባሮን ይናስ ጋቹዋሲክቶክ ሳፋሬፋትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ሀኦስ ኤስ ባሮን ይናስ እኖክ ሳፋሬና ቦርአታኖሶ? ቡለፌ ቡልኝኛሲ አብድክ ቡሎናክ ሜያሶን እችፌ ባር አብድክ እቻናክ፤ ዙታምባሴ ሃኦባሶን ዳናናክ ኤስ ትቼ ባር ፉቶሲክ እንኖ ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","እንኖ ንቶስሲ ሀኦሲ ቾዋኖን ቡካት ንቶ አሽኒ ኤባሶን ካርአንነ አካማ ዉዛ ስንባኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ኦምኒ ሜያ ሀን ዉዛሶን ንቶኪን ሃኦሶንነ ማብትቤስ ፋር ስንናኔን ኤካን እንኖ ኣካክ ኤስ ባሪስታን ደናሎ ማብትኒ ፎ ቤይኒሪን? ስኑንታኖ እንኖ ሀን ማብትሶን ኣነ ኤጳ ኬኤኒዋ። ኤስ ባሮን ዛግኒስ ደይ ክርስቶስኒ ምስራቹኒ ካማሲ ታግት ሀማስታን የሮኖይናማቶ ሳፋሮክ ዙታምባሴ አስን ፋክራ ችማኒ ኡክዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ቤቴሜቅደሲሲ ዎስቴሴፌ ባሶ ሙቤሲሶን ቤቴሜቅደሲሲን ዳነሴፌማቶናዋ ሾኣስታ ማአ እሜፌ ባሶ ደይ ኤስ ማኣስታን ሃእኤሬ ሜሴፌማቶና ንቶ አሪቲርታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ኤሲስማቶ ደይ ምስራቹኒ ካማሶን ማክሴፌ ባሶ ሙቤሲሶን ኤስ ዎስቴሴፌ ዎስቶስን ዳኖነማቶ ዳሚስ አጃጀዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ስኑንታኖ ታ፤ ኤስ ማብትሲክቶስን እሳሮንኑ ኣነ ኤጳቶትዋ። ሀን ባሮን ትችናስ ኤስ ማብትናስ አዉኒሮን ዛግቶኖይ ፉእቴሶ ኡክታዋ። አስሱ ታ፤ ቴቴና ቴቶናሶን ሽማ ዛጉባስታን ክትፋናነ ታክ ዋያዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ምስራቹኒ ካማሶን ማኮናሲክ ኣፋ ቴቶና ዉዛ፤ ማኬፋናስ ግድ ስንና ቦርአዋ። ምስራቹኒ ካማሶን ማኮ ቤይፋናነ ሀይቡታጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ምስራቹኒ ካማሶን አስሱ ታን ግድሱኖይናሮን ሹናክ ማኬፋናነ ሆፕናስ ዋግባ ፎናዋ። ስኑንታኖ ግድክ ዛግፋናነ ታክ እምቴ አዳራሶንቱ ኮእስንታኖ ኦማ ዛግና ዉዛ ፋር ኡታዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ኤካን፥ ሆፕናሲ ዋጋ ኣምባንሶ? ኤሴ ሆፕናሲ ዋጋ ምስራቹኒ ካማሶን ማኮናሲክ ታክ ፋ ማብትናሶን ቤይፋት ምስራቹኒ ካማሲ ማኮኒ ዎስቶናሲክ ካስቶኒ ዋጋ ፎንቶኖን ባክ ማኮናስዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ታ፤ ኦኒክንኑ ቦዝ ስኖይ ብርማዱምማ ኬሴ ፌ አሱዋ፤ ስኑንታኖ ታክ ችምቴናይሲማቶ ሾዎኒ ሜያኖን ዎልጉክዋ እያት ዙታምቤሲሴ አሲ ቦዝ ስንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","አይሁድኒ ሜያኔን ስንፋና ካባሲክ አይሁድኒ ሜያኖን ፉኦናክዋ ኢያት አይሁድ ስኒንዋ፤ ታ፤ ቱማሲ ዳካሎ ስና ቤይፋናክኑ ቱማሲ ዳካሎ ፌሴ ባሶትን ፉኦናክዋ እያት ቱማሲ ዳካሎ ፌሴ አሱኒ ሜኒማቶ ስኒንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ታ፤ ቴትናሲክ ሀኦሲ ቱማ ፌናርናዋ ክርስቶስኒ ቱማሲ ስካሎሲ ፌ አስሱ ስንፋናክኑ ቱማቤሲ ፎንቶ አዛብኒ ሜያኖን ፉኦክዋ እያት ቱማባ ፎንቶ አሱኒማቶ ስኒንዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","አማንቶክ ሆፕ ስና ባሶትን ፉኦክዋ እያት ሆፕኒ ሜያነ ፌር ስኒንጝዋ። ታክ ችምቴናስነ ፋሮን እሳ እሳይስን ፉኦክዋ እያት ዙታምቤሲሴኔን አነ ዙታምባሴ አሲን ስኒንዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ኤስ ባሮን ዙትራ ኤካ ዛግናስ ምስራቹኒ ካማሲ ኤባኖን ሃአክ ምስራቹኒ ካማሲክዋ እያትዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ኣቶ ኣቶኒ ኤላሶን ዙታምቤሲሴ ኤለፌሲማቶናዋ ኤስ ኤልላ ባሶስን እሳ ባር ባር ዎሱማሶን ኤጴቴፌናማቶና አሪቲርታኖሶ? ኤስ ባሪ ቦርኣ ንቶ ደይ ዎሱማሶን ኤጴቶክ ኤልትዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ሃቶ ሃቶኒ ኤላክ ሆሬሴፌ ባሶ ዙቴሬ አካማኖን ፋያ ሌጅቱ ኤጴፌዋ፤ ባሶ ኤካ ሆፕሴፌስ ትሹኒ ኡልፍናኒ ዎሱማሶን ዳኖሶነክዋ። ስኑንታኖ እንኖ ሆፕፌኒስ ትሹኖይ ኮእባ ፎንቶኖን ፎኒ ኡልፍንኒ ዎሱማሶን ዳናኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ኤስ ባሪ ቦርኣ ታ፤ ሀምሜ ካርአና ድማሶን አሩኖይ አሱኒማቶ ሽማኖን ኣፋ ኤላና ዉዛ። ስሩሶን ጉምሜ ክእፌ አሱኒማቶ ባክ ኣፋ ካቦና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ኤስ ባሪ ቦርኣ ኦምኒ ሜያኖን ኣቶ ኣቶስሲ ቴጌናኔን ኦርፎ ታ፤ ቴትናሲክ ሀእቴር ስኖይናማቶ አቱናሶን ኬእራ ታክ አጃጃሞናክ ዛጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","አይታሳክቶኖ! አባኒሳክቶ ሻሩስ ዳካሎ ዞኑስቴሴቴማቶናዋ ዙታምቤሲሴ ሸአ ባሪሶን ፍነቴይሲማቶና ንቶትን ያዳሱናክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ሙሴኔን አነ እሳር ስንናክ ኤስ ሻሩስናዋ ባሪስና ሀጱቅቴሴቴ። ");
INSERT INTO jnje_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ዙታምቤሲሴ እሳ ቴሳ አያናኒ ሙሶን ሜሴቴ። ");
INSERT INTO jnje_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ዙታምቤሲሴ እሳ ቴሳ አያናኒ ኡሻሶን ኡሸቴ። ኡሸቴስ ደይ ባሶትን ቱስቴት ፋ አያናኒ ካኦስን ኬሳ ባሮንጝዋ፤ ኤስ ካኦስ ደይ ክርስቶስዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ስንፋናክኑ ሀኦስ ሾዎኒ ሜያክ ኣነ ግሮዋ፤ ኤስ ባሪ ቦርኣ ዱግኖቤሲስ ዛቦሲ ሀእቴራ ፉእቴ። ");
INSERT INTO jnje_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ባሶ ማጙ ዉዛ ኤናንቴሴቴስማቶ እንኖ ደይ ማጙ ዉዛሶን ኤናንቶኖይንማቶ ሀን ባር ዙታምባሴ እኖክ ቴትንትሶን ኦድት ኡኒ ቤሶ ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","«አሱኒ ሜያ ሙሶነክናዋ ኡሾነክና ዲሴቴ፤ ልክኔን ደናሎ ኡሸሼ ሱርሬ ቤጨቆክ ካብሴቴ» ይስቴራ ባሶ ቾዋሲክ ትቼናስማቶ ባሶ ኮእሎክ ሺጵሴቴስማቶ ንቶ ደይ ኮልሎ ሺጶትታዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ባሶስን እሳ እሳ ሜያ ጌርኬሴሬ ቦርአ ዎስቴሴቴስማቶ እንኖ ደይ ጌርኬስን ቦርአ ዎስቶኒታዋ። ባሶ ኤስ ባሮን ዛግሶቤሲሲክ ባሶስን እሳ ዎናሲ ሄፓስሬ ኬዜ ኩም አሱኒ ሜያ ክትሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ባሶስን እሳ እሳይስ ዳሚስን ፋታነሴቴይሲማቶናዋ ዛዋክ ዱፕቴሬ ክትሴቴማቶና እንኖ ደይ ክርስቶስኒን ፋታኖኒታዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ባሶስን እሳ እሳይስ ኡኚሴቴ ቦርአ ቤቶ ኤጳ ያ ሀኦሲ ዎሲያክ ትሽሴቴማቶ ንቶ ደይ ኡኙትታዋ ");
INSERT INTO jnje_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ኤስ ባር ዙቴራ ባሶስታ ካርእናስ እኖክ ቴትንትሶን ኦድት ኡኒ ቤሶ ስናናክዋ። ትቼናስ ደይ ነያሲ ኮእታ ፌ እኖትን ኬኡክዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ኤስ ባሪ ቦርኣ የሬርነ ፌር ስንነ ቤስቴፌ ባር ጋንዶኖይናማቶ ቴትባሶን ኦዶዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","አሱኒስታ ካርፋ ፋታናስታኖ ኦማ ፋታና ኣነ ንቶስታ ካርአዋ፤ ሀኦስ አማናምቶዋ፤ ኤስ ባሪ ቦርኣ ንቶ ግዶስታን ደናሎ ስና ፋታና ንቶስታ ካርአናክ ኣፋ ፋቃዶናውዛ። ፋታንቴፌት ካባሲክ ደይ ፋኩት ሁግና ንቶክ እምማ ፋታናስን ኬሳት ኡግና ንቶክ ሆሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ኤሴ ኮንታሳክቶኖ! ኮእሎሶን ሺጶስታን ዎክትዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ሀን ባሮን ደይ ንቶክ ማኬፋናስ ያዳትኒት ፌናር ስነት ቦርአዋ። ኤስ ባሪ ቦርኣ ታ፤ ማኬፋና ባሮን ንቶ ማጝሱ ካርእትዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","እንኖ ሀኦሶን ጋላቶክ ሃኤፌኒ ኤባን ቶፎስ ክርስቶስኒ ሀንናስኔን አነ እሳርባ ፋርታኖሶ? ባቴራ ሃኦኒ ክጣስ ደይ ክርስቶስኒ አሻስኔን አነ እሳርባ ፋርታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ክጣስ እሳር ስንባሲክ እንኖ ደይ ሀን እሳ ክጣሶን ሃኦኒር ስንናኔን አዉነ ፋሮን ሾዎ ስንፌኒክኑ እንኖ እሳ አቱዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ኤሴ እስራኤልኒ ዳራስ ዛግና ባሮን ቢትዋ፤ እምቴፋ ማኣሶን ሜሴፌ ባሶ ሾአሲኔን አነ እሳርቤስ ኣፋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ኤካን፤ ኤስ ባሮን ይፌኒስ ኮእሎሲክ ሹክቴ አሻስ ዋግባ ፋር ኡናኖሶ? ወደይ ኮእሎስ ቴትባሲክ ዋግባ ፋና ዉዛዋ ኡናኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","እንዳነዋ! አዛብኒ ሜያ ማአ እሜፌስ ሀኦሲክ ስኖይናሮን ክታሲክዋ። ኤስ ባሪ ቦርኣ ንቶ ክታስኔን አነ እሳርኒት ፎናክ ኣነ ሾሌፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ዳሚሳ ቶፎስን ኡሽፋት ደይ ክታሲ ቶፎስን ኡሻትክ ኣፋ ችማት ዉዛ። ዳሚሳ ማድታን ሃኤር ስንፋት ክታሲ ማድታን ሃኤር ስናትክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ኤካን ኤስ ባሮን ዛጉኒሲክ ዳሚስ ኮኖናክ ዛጉንሮሶ? እንኖ ባሳስታን ደናሎኖን ችም ስናኒሮሶ? ");
INSERT INTO jnje_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ዙታምባሴ ፋቃድቴዋ፤ ስኑንታኖ ዙታምባሴ ኣፋ ኬአናዉዛ፤ ዙታምባሴ ፋቃድቴዋ ስኑንታኖ ዙታምባሴ ኣነ ኬፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","አስሱ እሳ እሳርባስ ኦምሲክኔን ኬእኒ ዉዛ ሳፋሮዎቴኖ ባር ባሪክ ኬእኒሶን ኮእባ ሾሎናታዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ካኑንትስሲ ሳፋሮ ሻካት ጋባስታ ዋግቴፋ ኣፋ አሻሶን ላጰባቶኖይ ሙትዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ዳሴዋ ባሪስታ ፋ ባሬ ዙቴራ ዳሚሳርዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","አማኖኖይ አስሱ ሙ ንቶትን ማሱናክ ቴጌፋናነ ሀማትክ ደይ ሾሌፋትነ ቴሸና ሙሶን ካኑንትስሲ ሳፋሮ ሻካት ላጰባቶኖይ ሙትዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ስኑንታኖ እሳ አስሱ፦ «ሀን አሻስ ኮእሎክ ሹክቴ አሻዋ» እያናነ ኤስ ባሮን ማኬ አሱሳ ቦርአናዋ ካኑንትሲ ቦርአና አሻሶን ሙትታ። ");
INSERT INTO jnje_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ካኑ ይፋናስ አሱሳ ካኑኖን ኡናታኖ ንቶ ካኑሶን ኡናታዋ። ኤካን ኦም አሱሳ ካኑኒ ቦርአ ታ፤ ብርማዱምማስታ ማጝሱ ካርአናስ አዉኒ ቦርአንሶ? ");
INSERT INTO jnje_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ታ፤ ሀኦሶን ጋላቴት ሙ ማፋናነ ሀኦሶን ጋላቴና ዉዛሲክ አዉኒ ቦርአ ዋቃስቶናስሶ? ");
INSERT INTO jnje_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ኤሴ ማፌት ባርክ ስኑን ኡሽፌት ባርክ ወደይ ኣፍፋ ዉዛሶንኑ ዛግፌት ካባሲክ ዙታምባሴ አሲን ሀኦሲ ኡልፍናክ ዛጉትዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","አይሁድኒ ሜያኖን ስኑን አዛብኒ ሜያኖን ስኑን ሀኦሲ ቤቴክርስታንኖን ስኑን ቱሳእሱትታዋ። ");
INSERT INTO jnje_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ታ፤ ዙታምቤሲሴ ፉእቶሶነክ ደይ ኦምኒ ሜያክ ኬእኒሶንታኖ ታክ ኬእኒ ባሮን ኮእባ ሾሎኖይ አሱኒክ ዙትራ ዛግፋና ዉዛ ዙታምባሴ አሲክ ግርሲፋናስማቶ ንቶ ደይ ኤሲስማቶ ዛጉት። ");
INSERT INTO jnje_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ታ፤ ክርስቶስኒ ቤሶሲክ ዞኑስቴናማቶ ንቶ ደይ ታ፤ ቤሶሲክ ዞኑስቶት። ");
INSERT INTO jnje_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ዙታምባሴ አሲክ ታን ያዳቴፌት ቦርአናዋ ታ፤ ንቶክ አሲና አሱሶን ማእስራ ኤጵት ቦርአና ንቶትን ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ስኑንታኖ ኣርቃሱ ዙታምባሴ አሲ ቴት ክርስቶስዋ፤ ማሽካሱሲ ቴት ደይ ኣርቃሱ፤ ክርስቶስኒ ቴት ደይ አባ ሀኦስ ስንባሶን አሩትክ ሾሌፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ቴትባሶን ጉፌሬ ሀኦ ሺጴፌ ወደይ ራጅኒ ካማ ማኬፌ ኣርቃሱ ዙታምባሴ ቴትባሶንቱ ሳልጲስፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ኤሲስማቶ ደይ ቴትባሶን ጉፎኖይ ሀኦ ሺጴፋ ማሽካአሱስ ወደይ ራጅኒ ካማ ማኬፋ ባር ባር ደይ ቴታሶንቱ ሳልጲስፋዋ። ቴትባሶን ጉፎኖይ ማሽካሱስ ሶምባሶን ፊቴናሪማቶቱ ፋድቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ማሽካ አስሱ ቴትባሶን ጉፎ ሻካናነ ሶምባሶን ካቶጝዋ። ስኑንታኖ ሶምባሶን ካቶ ወደይ ፊቶ ባሮን ሳልጲሱኒ ዉዛ ስንፋናነ ቴትባሶን ጉፎጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ኣርቃሱ ቴትባሶን ጉፎናክ ኣነ ሾልስፋዋ፤ ኣርቃሱ ሀኦሲ ቤሶነዋ ሀኦሲ ኡልፍንነዋ። ስኑንታኖ ማሽካሱስ ኣርቃሱሳ ኡልፍናዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ማሽካሱስ ኣርቃአሱኒኪንቱ ቤስቴታኖ ኣርቃሱ ማሽካሱንኪን ኣነ ቤስቶዌዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ኤሲስማቶ ማሽካሱስ ኣርቃሱሲክቱ ቴስቴታኖ ኣርቃሱ ማሽካሱሲክ ኣነ ቴስቶየዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ኤስ ባሪ ቦርኣናዋ ሀኦኒ ዎሲያኒ ቦርአና ማሽካሱስ ሀእሱኒ ሁግናኒ ማላቶ ስና ጉፎሶን ቴትባስታ ዱሱንዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ዳሚሲክ ፋ ካኒሲክ ማሽካሱስ ኣርቃሱ ፎንቶኖን ኣፋ ፎና ዉዛ፤ ኣርቃሱስ ደይ ማሽካሱ ፎንቶኖን ኣፋ ፎና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ማሽካሱስ ኣርቃሱንኪን ቤስቴናማቶ ኣርቃሱስ ደይ ማሽካርኪንቱ ኮንቴፌዋ። ስኑንታኖ ኣርቃሱ ስኖ ማሽካሱ ደይ ኦማ ዉዛስኑ ዙቴራ ቤስቴፋናስ ሀኦስክጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ኤሴ ንቶ ቴትንትሲክ ማጝሱ ካርእትዋ፤ ማሽካሱ ቴትባሶን ጉፎኖይ ሀኦኒ ሺጶባስ ሾልሱኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ኣርቃሱ ሶምባሶን ድችፋናነ ሳልጲና ስንናማቶ ቴስቶስ ቴትባሲክ ኣነ አሲፋኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ስኑንታኖ ማሽካሱሲክ ሶማ ድቹናክ እምቴናስ ቴትባሶን ኡካናክ ስንና ቦርአ ሶምባሶን ድችፋናነ ባርክ ኡልፍንባዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ሀን ቾዋሲክ ካራካሮናክ ሾሌ አስሱ ፌፋናነ እንኖ ስንፌኒክ ወደይ ኦማ ሀኦሲ ቤቴክርስታኒሲክቶ ስኑን ኤስ ባርስታን ኦማ ዶስቴኒ ዉዝኒ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ስኑንታኖ ዙቴፌት ካባሲክ ሚርእአኒትታኖ ማአሪር ስና ቤይና ቦርአ ሀን አጃጂሶን እምፋናስ ጋላቴፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ዙታምባሴ አሲስታን ዜምማ እሳ ኩጳማክ ዙቴሴፌት ካባሲክ ንቶ ጋነያሲ ኦር ኦር ኬሳ ፋናማቶ ኦደጝዋ። ኤስ ኦደና ዉዛስን ባግጋ ፉቶ ስንናማቶ አማነፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ፉቶ ስና ባሶ ኦ ስንነቴማቶ ኦር ኮርቴሬ አርቶሶነክ ንቶ ጋነያሲ ኦር ኦር ኬሳ ፎባስ ግድዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","እሳሪክ ኩጲፌት ካባሲክ ማፌትስ ዳሚሳ ሜታኡታዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ማፌት ካባሲክ እሳይስ ኦሚስን ኦድኖይ ባር ባር ሜፌዋ፤ ኤስ ባርክ እሳይስ ማክቴፌን ኦሚስ ዛየፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ሻካፎት ዲራ ሙት ኬነዋ ዲራ ኡሻት ኬነ ቱርኪትዮሶ? ወደይ ሀኦሲ ቤቴክርስታኒኖን ካሽሺትዮሶ? ወደይ እሳ ዉዝቤስ ፎንቶ ቱካምኒ ሜያኖን እችሹትኮሶ? ኤሴ አዉ ንቶክ ኡናሪንሶ? ኤስ ባሪ ቦርኣ ሀን ቾዋሲክ ንቶትን ጋላቶናሮሶ? እሳንነ ኣፋዋ ጋላቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ዳሚስኪን ኤጵና ባሮን ንቶክ ኣትራ እምጝዋ። ዳም የሱስ አቴሬ እምቴና ዋላሲክ ክጣሶን ካብግሬ፤ ");
INSERT INTO jnje_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ጋላትኒ ሺጶ ሺጴናኔን ኦርፎ ባትቴ፦ «ሀን ባር ንቶክ ስንኒ አቱናስዋ፤ ኤስ ባሮን ታን ያዳቶኒር ዛግራ ሙትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ኤሲስማቶ ደይ ሜታኡስኔን ኦርፎ ቶፎሶን ካብግሬ፦ «ሀን ቶፎስ ሀሪንናሲክ ስንኒ ጋድዶ ቴያስዋ፤ ሀን ቶፎስን ኡሽፌት ካባሲክ ኤስ ባሮን ታን ያዳቶኒር ዛግራ ኡሽትዋ» ይ። ");
INSERT INTO jnje_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ሀን ክጣሶን ማፌት ካባሲክናዋ ሀን ቶፎስን ኡሽፌት ካባሲክና ዎንና ዎንና ዳሚስ ዮናኔን ክቱባሶን ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ኤሴ ኦኑ ሙናክ ሾልሱኖይፌን ዳሚሳ ክጣኖን ሜፋናነናዋ ዳሚሳ ቶፎስን ኡሽፋናነና፤ ዳሚሳ አሽነዋ ሀሪንነ አሲን ሀቴስሲና ቦርአ ማሙስቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ኤስ ባሪ ቦርኣ ኣፌ አሱኑ ሀን ክጣሶን ሙባስታንናዋ ሀን ቶፎሲን ኡሽባስታንና ዜምሜ ቴትባሶን ቱኑዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ኣፌ አሱኑ ዳሚሳ አቱ አዉ ስንናማቶ ማእስሬ አሩኖይ ዳሚሳ ሜታኡኖን ሜፋናነናዋ ዳሚሳ ቶፎስን ኡሽፋናነና ባሳ ቴታስታ ማጝሱኒ ካርአቱ ኤጴ ዮናዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ንቶ ጋነያስን ሾዎኒ ሜያ ሆፕሴቴሴዋ ሜቴሴቴሴ ደይ እሳ እሳ ሜያ ክትሴቴስኑ ኤስ ባሪ ቦርኣዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","እንኖ ቴታስታ ማጝሱ ካርኒ ስንናፋናነ ማጝሱኒ ካርኣሲ ስካሎሲ ጋንዶኒ ካባታዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ስኑንታኖ ሀንኔን ሀን ዳስኔን አነ ማጝሱ እኖስታ ካቶኖይናማቶ ሀሽ ዳሚስ ማጝሱ ካርኤ እኖትን ኬእዲፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ኤስ ባሪ ቦርኣ አይታሳክቶኖ! ዳሚሳ ሜታኡኒ ሙክ ዙቴፌት ካባሲክ ንቶትና ንቶትና ዋል ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ዙቴፌት ዙቶስ ማጝሱ ንቶስታ ካቶናክ ዛጉኒር ስኖይናሮን ንቶ ጋነያስን ማክቴር ፌፋናነ ኬባሲክ ሀምሜ ሙዎዋ። ፉእቴ ዉዛሲክ ንቶኪ ያና ዎኖ ኦማ ስትሪ ንቶክ እማናዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","አይታሳክቶኖ! ሀሽ ደይ ኮርቶ አያናኒ እማሶን አሩትማቶ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","አማንቶንት ፎንቶ ስንና ፋቲ ካባሲክ አሩኖይት ዉዛሲክ ዞኑስቴራ ዎላ ችምኖይ ኮእሎስኪ ሀሜት ፋትር ስንናማቶ አሪፌት። ");
INSERT INTO jnje_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ኤስ ባሪ ቦርኣ ሀኦኒ አያናክ ዞኑስቴፌት የሱስኒን ኤርዉቶዋ ሁኒር ኦኑ ኣፌዋ። ኤሲስማቶ ኮርቶ አያናክ ስንና ሻካናነ ኦኑ «የሱስ ዳምማዋ» ይፌር ኣፌ ስንናማቶ ታ፤ ንቶክ ማኬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ኦም ኦማ ኮርቶ አያናኒ እማ ፋርዋ። ስኑንታኖ ኮርቶ አያናስ እሳርዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ኦም ኦማ ሀኦኒ ዎስቶ ፋርዋ፤ ስኑንታኖ ዳሚስ እሳርዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","ኦማ ኦማ ዎስቶ ፋርዋ፤ ስኑንታኖ ዙታምባሴ አሲን ዙትራ ዛግፋስ እሳ ሀኦስዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","እሳርባ እሳርባሲክ ኮርቶ አያናሶን አምማኖን ኮቴ ማኮኒ እማ እምፋናስ ዙታምኒሴ አሲክ ኬእአናዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ኮርቶ አያናስ እሳይሲክ ቴችማክ ማኮኒ ችማ እማር፤ ኦሚሲክ ደይ ኤስ አያናስ አሩክ ዎሎኒ ችማ እማር። ");
INSERT INTO jnje_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ኤስ እሳ አያናስ እሳይሲክ አማንቶ እማር፤ ኦሚሲክ ደይ ፋቱኒ እማ እማር። ");
INSERT INTO jnje_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ኤሲስማቶ እሳይሲክ ቢስቴራ አሪቶኖይ ዉዛ ዛጉኒ ሁግና እማር፤ ኦሚሲክ ደይ ራጅ ማኮኒ ችማ እማር፤ ኦሚሲክ ደይ ኤስ እማሲክቶ ኮርቶ አያናስኪን ወደይ ኪና አያናስኪን ስንባሶን ኮሪሬ አሩኒ ችማ እማር፤ ኤሲስማቶ ደይ እሳይሲክ ኦማ ኦማ ኖኖክ ዎሎኒ ችማ እማር፤ ኦሚሲክ ደይ ኦማ ኦማ ኖኖክ ዎሉምቴ ባሮን ኮትቴ ማኮኒ ችማ እምር። ");
INSERT INTO jnje_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ስኑንታኖ ኤስ ባሮን ዙትራ ዛግፋስ ኤስ እሳ ኮርቶ አያናስዋ። ኮርቶ አያናስ ሾሌናማቶ አስሱ እሳ እሳርባሲክ ኦማ ኦማ እማ እምፋ ");
INSERT INTO jnje_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","እሳ አሱስ ሾዎ አቱኒ ብልትባ ፋር። አቱሲ ብልት ሾዎ ስንና ፋናስ ኤስ እሳ አቱስታዋ። ኤሲስማቶ ክርስቶስ ሾዎ አቱኒ ብልትባ ፋና እሳ አቱንማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","አይሁድ ስንፌኒክ፤ ግሪክኒ አስሱ ስንፌኒክ፤ ቦዝ ስንፌንክ፤ ብርማዱምማ ኬሳ አስሱ ስንፌንክ እንኖ ዙታምኒሴ እሳ አቱ ስንናንክ ኮርቶ አያናሲክ ሀጱቅቴንዋ። ዙታምኒሴ ደይ ኤስ እሳ አያናስኪን ኡሽኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","እሳ አቱ ዎሱስቴናስ ሾዎ አቱኒ ብልትስኪንታኖ እሳ አቱ ባር ባርኪን ኮእባታዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ዎቾስ፦ «ታ፤ ኩሹ ስንና ሻኪና ቦርአ አቱኒ ብልትታዋ» እያናነ ኤካን፤ ኤካ ኡባሲክ አቱኒ ብልት ስንባስ ፌሽንሮሶ? ");
INSERT INTO jnje_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ኦዶስ ደይ፦ «ታ፤ ኣፋ ስና ሻኪና ቦርአ አቱኒ ብልት ኣፋ ስንናናዉዛ» እያናነ፤ ኤካን ኤስ ኤካ ኡባሲክ አቱኒ ብልት ስንባስ ፌሽንሮሶ? ");
INSERT INTO jnje_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","እሳ አቱስ ዙቴራ ኣፋ ኣፋ ስኒ ስንፋናነ አዉክ ኦድቶና ካባንሶ? እሳ አቱ ዙታምባሴ ኦዶ ኦዶ ስኒ ስንፋናነ አዉክ ሳዉስቴራ ቢስቶና ካባንሶ? ");
INSERT INTO jnje_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ስኑንታኖ ሀሽ ሀኦስ ባር ሾሌናማቶ እሳ አቱሲ ብልት አቱሲክ ሾልሲ ድምባስታ ኤጳ ዱናክ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ዙታምባሴ እሳ ብልት ስኒ ስንፋናነ ቱምማ አቱ አይን ቤስቶና ካባንሶ! ");
INSERT INTO jnje_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ስኑንታኖ ሀሽ ሾዎ ብልት ፋፋናክኑ አቱስ እሳርዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ኣፋስ ኩሹሶን፦ «ነ፤ ታክ ኣነ ሾልስፌዌ!» ኡናክ ኣፋ ችማናዉዛ። ቴታስ ደይ ዎቾሶን፦ «ነ፤ ታክ ኣነ ሾልስፌዌ!» ኡናክ ኣፋ ችማናዉዛ፤ ");
INSERT INTO jnje_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ኤስ ባርስታን አካማኖን ሆፕያነ ፋር ስንና ቤስቴፋ አቱሲ ብልትሲክቶኒ ኦማስታን ደናሎኖን ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ጋሮ ኡልፍንባ ፋርነ ፋር ስንና ቤስቴፋ አቱሲ ብልትኒክቶክ አሪክሮን ኡልፍና እምኒርዋ። ብያክ ኢቹነ ፋር ስንና ቤስቴፋ አቱሲ ብልትኒክቶክኑ አሪክሮን ኡልፍና እምማ ኦድፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ስኑንታኖ ብያክ ኢቾኖይኒ አቱሲ ብልትኒክቶክ ኤስ ባር ዙታምባሴ ኣነ ሾልስፋ። ስንፋናክኑ ሀኦስ ብያክ ኢቹነ ፋር ስንና ቤስቴፋ አቱኒሲ ብልትኖን አሪክሮን ኡልፍናክ ኦድቶናማቶ ዛግራቱ አቱሲ ብልትሲ ኬእዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ኤስ ባሮን ደይ ዛግናስ አቱሲ ብልትኒ ጋነያሲ ኦር ኦር ኬሳ ፎኖይናሮን ባሬ ባሬ ዋል ሳፋሮናክዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","እሳ አቱሲ ብልት ራካቴፌን ኦማ አቱሲ ብልትኒክቶ ዙታምባሴ ደይ አነቱ ራካቴፋዋ። እሳ አቱሲ ብልት ኡልፍንቴፋና ካባሲክ ኦማ አቱሲ ብልትኒክቶ ደይ አነ ግሬፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ንቶ ደይ ክርስቶስኒ አቱኒ ብልትዋ፤ እሳ እሳርኒትስ ባሳ አቱሲ ብልትዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ኤስ ባሪ ቦርኣ ሀኦስ አስሱ እሳ እሳርባስን ቤቴክርስታኒሲ ኦማ ኦማ ዎስቶባ ፎናማቶ ዛጊዋ። ኤስ ባርክ ዜምማ ዎስኒ ሜያኖን፤ ሄፕሳስታክ ራጁኒ ሜያኖን፤ ኬዝሳስታክ አስሲኛኒ ሜያኖን ዛግራ ታትሲዋ። ቱስራ ደይ ቢስቴራ አሪቶኖይ ዉዛ ዛጉኒ ባሶትን፤ ቱስራ ደይ ፋቱኒ እማ ባሶክ እምቴና ባሶትን፤ አሱኒኒ አሪጋሱኒ እማ ባሶክ እምቴና ባሶትን፤ ሀእሱኒ ሜያኖንናዋ ኦማ ኦማ ኖኖክ ዎሉምሶኒ አሱኒ ሜያኖንና ሆሲዋ። ");
INSERT INTO jnje_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ዙታምቤሲሴ ዎሲኖሶ? ዙታምቤሲሴ ራጁኖሶ? ዙታምቤሲሴ አስሲኛኖሶ? ዙታምባሴ ቢስቴራ አሪቶኖይ ዉዛ ዛግሴቴሮሶ? ");
INSERT INTO jnje_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ዙታምቤሲሴ አሲክ ፋቱኒ እማ ባሶኪ ፋሮሶ? ዙታምቤሲሴ ኦማ ኦማ ኖኖክ ማክሶነ አሩቤስ ፋሮሶ? ");
INSERT INTO jnje_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ኤስ ባሪ ቦርኣ ዙታምባሴ አሲስታን ደናሎ ስና እማሲክቶኖን ዳናትክ ችምማ ሾሎትዋ። ሀሽ ደይ ዙታምባሴ አሲስታን ደናሎ ስና ኡግናሶን ንቶክ ቤሱናዋ። ሀሽ ደይ ዙታምባሴ አሲስታን ደናሎ ስንና እማሶን ቤሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","አሱኒ ሜኒ ኖኖክናዋ ሀኦሲ ዎስኒ ኖኖክና ዎል ሌፋናክኑ ኬሽታና ታይሲ ትሽፋናነ ሾሩክቴን ሲክል ሲክልት ግልፋ ብትታ ወደይ አሽቀ ስኒጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ራጅ ማኮኒ እማ ታክ እምቴፋናነናዋ ኣቾ ዉዛሶን ዙትራ አሪፋናነና ደይ አሩ ዙቴራ ታክ ፋፋናነ፤ ኣማሶን እሳ ድምታን ኦማ ድምታ ዋርአ ታምኒ አማንቶና ፋፋን ኬሽታና ታይሲ ትሽፋናነና ሽማ ስኒጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ታክ ፋ ዉዛሶን ዙትራ ቱካምኒ ሜያክ ሃእፋናነ፤ አሽናስኑ ፉእቶኖይናሮን ጌያክ ኪቾናክ ኣትራ እማና ኬሽታና ታይሲ ትሽፋናነ ኣፋ ታክ ኬእአናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ኬሽታናስ ፋክር፤ ኬሽታናስ ማአሮን ዛግር፤ ኬሽታናስ ኮኖኒክ ኣነ ዛግፋ፤ ኬሽታንባ ፋና አስሱ ባሳ ቴታሲክ ኣነ ቴቴፌ፤ ኬሽታንባ ፋና አስሱ ኣነ ቤጋንቴፌ። ");
INSERT INTO jnje_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ኬሽታናስ ስትርባ ፎንቶ ኣነ ዛግፋ፤ ኬሽታንባ ፋና አስሱ ባርክ ኬእኒ ባር ባሮን ኣነ ሾሌፌ፤ ኬሽታንባ ፋና አስሱ ኣነ ሃሬፌ፤ ኬሽታንባ ፋና አስሱ ሚርእአሜፌናክኑ ሚርእአምባሶን ኣነ ፋድፌ። ");
INSERT INTO jnje_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ኬሽታንባ ፋና አስሱ ፉቶ ስንና ዉዛስታቱ ግሬፌቴኖ ፉቶ ስኖይ ዉዛሲክ ኣነ ግሬፌ። ");
INSERT INTO jnje_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ኬሽታንባ ፋና አስሱ ዙታምባሴ አሲን ችማር፤ ዙታምባሴ አሲክ አማነር፤ ዙታምባሴ አሲን አብድ ዛግር፤ ዙታምባሴ አሲክ ዛግሬ የሬር። ");
INSERT INTO jnje_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ኬሽታምባ ፋና አስሱ ኣጌነ ኣጌነ ኣነ ጋንደፌ፤ ራጅ ማኮኒ እማስ ኣታር፤ ኦማ ኦማ ኖኖክ ዎሎኒ ችማስ ኣታር፤ አሩስኑ ስንፋናነ ኣታር። ");
INSERT INTO jnje_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","አሪፌኒ ባር ስኑን ራጅ ማኬፌኒ ባር ባጋዋ። ");
INSERT INTO jnje_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ስኑንታኖ ፉቶ እሳ ኤሽባ ፎንቶ ዉዛስ ያፋና ካባሲክ ባግቶ ስና ባር ፌሻናዋ። ");
INSERT INTO jnje_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ዳጋ ናዋ ስንና ፋና ካባሲክ ዳጋ ናኒማቶ ዎል ሌት ፋናር፤ ደይ ዳጋ ናኒማቶ ሳፋሬት ፋናር፥ ዳጋ ናኒማቶ ቱእኒት ፋናር፥ ስኑንታኖ ጋይማ አስሱ ስንፋና ካባሲክ ዳጋ ናኒ አማላናሶን ቤይጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ሀሽ እንካሊሲ ቢፌንስማቶ ጣቃጣቃስቱ ቢድፌንዋ። ስኑንታኖ ኤስ ካባሲክ አምማኖን ብያንዋ። ሀሽ አሪፋናስ ባግጋዋ፤ ስኑንታኖ ኤስ ካባሲክ ሀኦስ ታን አሪፋናስነ ፋሮን ቱማ አሩና ፎናዋ። ");
INSERT INTO jnje_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ኤሴ አማንቶ፥ አብድ፥ ኬሽታናስ ኬዞባሴ ዛግራ ፎናዋ፤ ስኑንታኖ ሀን ባርኪቶኒ ጋነያስን አርኪስ ኬሽታናስዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ኤሴ ኬሽታናሲክ ዞኑስቶትዋ፤ ኮርቶ አያናስ እማኖን አሪክሮን ራጅኒ ማኮስ እማኖን ማእስራ ሾሎት። ");
INSERT INTO jnje_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ኦማ ኦማ ኖኖክ ዎል ሌፌ ባር ሀኦሲክታኖ አሱኒክ ኣነ ማኬፌ። ኣቾ ስንና ቾዋሶን ኮርቶ አያናስ ሁግናክ ማክቴፋና ቦርአ ኤስ ማክቴ ካማሶን አሪፌር ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ስኑንታኖ ራጂሶን ማኬፌ ባር ኦሚስን ዬቱክ፥ ዛጉክናዋ ችኑክና አሱኒ ሜያክ ማኬፌ። ");
INSERT INTO jnje_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ኦማ ኦማ ኖኖክ ዎል ሌፌ አሱስ ባሳ ቴታሶንቱ ዛግፌ፤ ስኑንታኖ ራጅ ማኬፌ ባር ክርስታናን ሜኒ ማባራሶንቱ ዛግፌ። ");
INSERT INTO jnje_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ዙታምንትሴ ኦማ ኦማ ኖኖክ ዎል ሌፋትነ ሹናና ካባዋ። ስኑንታኖ ኤስ ባርስታን ማእስራ ሹናናስ ራጂሶን ማኬፋትነዋ። ክርስታናኒ ሜኒ ማባራስ ዛጉናክ ኦማ ኦማ ኖኖክ ዎል ሌፌ አሱሳ ዎላኖን ኮትቴ ማኮኒ አስሱ ትሽፋናነ ራጅ ማኬፌ ባር ደናሎዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ኤሴ አይኒ ሜያነ! ንቶኪ ያፋና ካባሲክ ኦማ ኦማ ኖኖክ ማኬት ያፋናነ አዉ ንቶክ ኬእንሪንሶ? ኤስ ባርስታን ንቶክ ኬእኒስ ሀኦሲ ኣቾ ቾዋኖን አምማኖን ክስሬ ማኮሶን፥ አሩሶን፥ ራጅኒ ማኮሶን፥ አሱሶን ኤጳ ያፋናነዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ኡሉሌኒማቶናዋ ካማኒማቶና ፋሴ ካባ ፎንቶ ሱሩኒ ኮዳሲክቶኑ ኦማ ኦማ ግልኒ ካማ እማናክ ማእስቴራ ዱስቶ ሻካናነ እምፋና ቴቾኒ ካማ አዉ ስንናማቶ ኣካክ አርቶኒሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ቱቱሩስ አርቶኖይ ካማክ ፉግቴፋናነ ኔቦክ ኦንሶ ሆሮንሪ? ");
INSERT INTO jnje_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ኤሲስማቶ ጋድዶ ኖኖክ ዎል ሌፌት ካባሲክ አምማ ስና ካማክ ማኮ ሻካትነ ዎል ሌፌት ባሮን ኦ አሩክ ችምንሪንሶ? ስሩሲክ ማኬድፌትሪነ ፋርቱ ስንናትዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ኤሴ ሀን ዳስታክ ሾዎ ቴሳ ኖኖ ፋርዋ፤ ኮትባ ፎንቶ ኖኖ ደይ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ኤሴ ታ፤ ዎሉምቴፋ ዎላሲ ኮታኖን አሩኖይናር ስንፋናነ ዎል ሌፌ አሱሲክ እርባቱ ስንናናዋ፤ ባር ደይ ታክ እርባቱ ስንናናዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ንቶ ደይ ኮርቶ አያናሲ እማኒክቶኖን አካማኖን ሾሌት ፋትር ስንና ቦርአ አሪክሮን ሾሎትክ ሾልስንናስ ቤትክርስታኒሶን ዛግፋ እማሲክቶ ሾዎናክዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ኤስ ባሪ ቦርኣ ኦማ ኦማ ኖኖክ ዎል ሌፌ አስሱ ኮትቴ ማኮኒ ችምባ ፎናክ ሺጶዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ታ፤ ኦማ ኦማ ኖኖክ ሺጴፋናነ አያናሲቱ ሺጴፋርታኖ ካኑናስ ጋንባ ፎንቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ኤካ አዉ ዛጉናክ ሾልስፋሶ? አያናሲክ ሺጶና፤ ካኑናሲክ ደይ ሺጶናዋ፤ ደይ አያናሲክ ጋማ ጋሜናርዋ፤ ካኑናሲክ ደይ ጋማ ጋሜናርዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ኤካ ስና ሻካናነ ነ አያናክ ሀኦሶን ጋላቴፋታ ካባሲክ ነ፤ ማኬፋታ ባሮን አሩኖይ እርባ አስሱ ጋላትኒ ሺጶኔሲክ፦ «ኣሚን» ኡክ ኣካክ ችምንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ፉቶሲክ ነ፤ ሺጴታ ጋላትኒ ሺጶስ ማአሪክዋ። ስኑንታኖ ኦም አሱስን ኣፋ ዛግጉናዉዛ ");
INSERT INTO jnje_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ታ፤ ንቶ ዙታምኒትሴ አሲስታን ደናሎኖን ኦማ ኦማ ኖኖክ ዎል ሌፋና ቦርአ ሀኦናሶን ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ስኑንታኖ ኦማ ኦማ ኖኖክ ሾዎ ካማክ ፋድቶኒ ካማ ማኮናስኔን ኦም ሜያኖን አሱክዋ እያት ቤቴክርስታኒሲክ ኡች ካማ አርቶ ኖኖክ ካኑናሲክ ማኮናክቱ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","አይታሳክቶኖ! ማጙ ዉዛሲክ ዳጋ ናንጎታ ስንትታኖ ሳፋራንትሲክ ዳጋ ናንጎትኒማቶ ስንናቲታዋ። ኤስ ባሮን ሻካት ሳፋራንትሲክ አሩ ስንትዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ኤሲስ ደይ፦ « ‹ኦማ ኦማ ኖኖክ ዎል ሌፌ አሱኒ ሜናዋ፤ አላጋ አሱኒ ሜኒ ኖኖክና፤ ሀን ዳራሲክ ማኬፋውጙዋ፤ ኤስ ባርኑ ስንፋናክ ኣፋ ታን ኦዶሶነ ዉዛ› ይፋዋ ዳማ ሀኦስ» ይስቴራ ቱማስሲ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ኤስ ባሪ ቦርኣ ኦማ ኦማ ኖኖክ ዎላሲ ማላቶ ስንናስ አማኖኖይ አሱኒ ሜያክታኖ አማነሴፌ አሱኒ ሜያክታዋ። ስኑንታኖ ራጅኒ ካማ ማኮስ ማላቶ ስንናስ አማነሴፌ አሱኒ ሜያክታኖ አማኖኖይ አሱኒ ሜያክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","ኤሴ ቤቴክርስታኒን አማኝኒ ሜያ ዙቴሴፌ ካባሲክ እሳ እሳርቤሲስ ኦማ ኦማ ኖኖክ ዎል ሌሴፋቴነናዋ አሩኖር ወደይ አማኖኖይ አሱኒ ሜያ ዬሴፋቴነና ኤስ ማክሴፌ ባሶትን፦ «ሀን አሱኒ ሜያ ንፋሴሴቴዋ» ኣፋኖሶ ኡሶነዉዛይ? ");
INSERT INTO jnje_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ስኑንታኖ ዙቴሬ ራጅኒ ካማ ማኬፋናነናዋ አማኖኖር ወደይ አሩኖይ አሱ ዬፋናነና ኦደና ካማ ዙታምባሴ አሲክ ዋቃስቴርዋ። ኤሲስማቶ ደይ ኦደና ካማ ዙታምባሴ አሲክ ማጝሱ ባሳስታ ካቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ንብባሲ ኣቸራ ፋ ዉዛስ ደይ አምማኖን ኬስሳ ቤስቴርዋ፤ ስንባሲክ ደይ ጋንደሬ፦ «ፉቶሲክ ሀኦስ ባሶ ጋነያስዋ!» ይት ሀኦሲክ ሳጋዶናዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","አይኒ ሜያነ! ኤሴ አዉ ዛጉኒክ ሾልስፋሶ? ሺጶክ ዙቴሴፌት ካባሲክ ንቶስን እሳይሲክ ጋማ ፋር፤ እሳይሲክ አስሱ ፋር፤ እሳይሲክ ኣቾ ስና ዉዛሶን አምማኖን ክሲሬ ቤሱ ፋር፤ እሳይሲክ ኦማ ኦማ ኖኖክ ዎሎ ፋር፤ እሳይሲክ ማክቴ ባሮን ኮትቴ ማኮ ፋር። ኤስ እማስ ዙቴራ ክርስታናኒ ሜያኖን ዛግጉኒር ስናናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ኦማ ኦማ ኖኖክ ማኮኒ አሱኒ ሜያ ፌሴፋቴነ ሄፕ ወደይ አሪክፋናነ ኬዝ ስንነ ታራ ታራ ማክሶቶ፥። ባሶ ማክሴቴ ባሮን ኦም አስሱ ኮትቴ ማኮዎ። ");
INSERT INTO jnje_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ስኑንታኖ ኮትቴ ማኮኒ አሱ ትሽፋናነ ኦማ ኦማ ኖኖክ ማኬሴፌ ባሶ ዙቶኒ ድማስታክ ሻኩሶቶ። ባሶ ቴታሲክናዋ ሀኦሲክና ኮእባ ማክሶቶ። ");
INSERT INTO jnje_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ራጁኒ ሜያ ሄፕ ወደይ ኬዝ ስንነሬ ማክሶቶ፤ ኦሚስ ደይ ማክቴ ባሮን ኦደሴሬ ማእስሬ ማዛንሶቶ። ");
INSERT INTO jnje_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ዙቶስታ ዲሴ ኦም አሱ እሳ ዉዛ ቤስቴፋናነ ቴሱኒ ማኬት ፌ ባር ሻኩዎ። ");
INSERT INTO jnje_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","እሳ እሳርባስ አሩናክናዋ ዛጉናክና ዙታምኒትሴ ታራ ታራ ሀኦሲ ዎሲያኖን ማኮ ችማትዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ራጁኒ ሜኒ ራጅኒ አያናስ ራጁኒ ሜያክ አጃጃሜርዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ሀኦኒ ዳራ ስና ቤቴክርስታኒሲክቶ ዙታምባሴ አሲስ ዛግቴፋናይስማቶ ሀኦስ ናጋኒ ሀኦታኖ ሳስኒ ሀኦታዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ማሽካ ሜያ ሀኦ ሺጶክ ዙቶኒ ካባሲክ ሻኩሶቶ። ቱማስ ባሶትን አጃጀፋናይስማቶ አጃጃሞሶነክታኖ ማክሶነክ ኣነ አጃጆዋዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","እሳ እሳ ዉዛ አሩክ ሾልሴፋቴነ ኬቤሲሲክ ቴጎቤሲስን ማሙሶቶ፤ ሺጶኒ ዙቶስታክ ማሽካሱ ዎል ሌፋናነ ኢቹዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ሻካፎት ሀኦሲ ካማ ንቶኪንኖሶ? ወደይ ሀኦሲ ካማ ያራ ካርእናስ ንቶ ንቶክኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ታ፤ ራጁዋ ወደይ አያናኒ እማ ታይሲ ፋርዋ ይፌ አሱ ፌፋናነ ሀን ትችናስ ዳሚሳ አጃጅ ስንባሶን አሩዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ኤስ ባሮን አሩኖር ፌፋናነ ባር ደይ ኣነ አርቴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ኤስ ባሪ ቦርኣ አይኒ ሜያነ! ራጅኒ ማኮሶን ማእስራ ሾሎትዋ፤ ኦማ ኦማ ኖኖክ ዎላሶን ደይ ካላቲታ። ");
INSERT INTO jnje_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ስኑንታኖ ዙታምባሴ ሾልሲናማቶናዋ ስትሪክና ስኑን። ");
INSERT INTO jnje_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ሀሽ ደይ አይኒ ሜያነ! አሲና ምስራቹኒ ካማሶን ያዳሱናክ ሾሌፋዉጙዋ፥ ኤስ ምስራቹኒ ካማስ ደይ ንቶ ኤጳ ታሴት ባሬዋ ዛግራ ዬርሴት ባሬዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ታ፤ ንቶትን አሲና ምስራቹኒ ካማሶን ማእስራ ኤጳትነ ባርክቱ ፋሩትዋ፥ ኤካ ስና ሻካናነ አማንቶኒትስ ሽማሲክ ሲናርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ታ፤ ኤጳታና ቴሱኒ ጌፋስታ ፋ ባሮን ንቶክ ኣትጝዋ፥ ታ፤ ንቶክ ኣትና ዉዛስ ኮርቶ ማፃፋስሲ ትቼናስማቶ ክርስቶስ እንኖ ቦርኣሲክ ክት፤ ");
INSERT INTO jnje_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ካባርቴ፤ ኮርቶ ማፃፋስሲ ትቼናስማቶ ኬዝስንናሪ ዎኖ ክቱን ካብ ይፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ባር ጴጥሮስኒክ ቤስቴ፥ ኦርፎ ደይ አሲሬ ሄፕ ዎስኒ ሜያክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ኡች ትያስታን ደናሎ ስና ባሳ ዞንሲሲክ እሳርጋ ቤስቴ፤ ባሶስን ሾዎቤሲስ ሀሽ ሀውጙ ካርኤ ካክ ፌሴቴርዋ። ስኑንታኖ እሳ እሳይስ ደይ ክትሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ኤሴን ኦርፎ ያቆብኒክ ቤስቴ፥ ዎስኒ ሜያ ዙታምቤሲሴ አሲክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ኮእአሲታክ ናሱነ ፌር ስና ታክ ደይ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","ታ፤ ሀኦሲ ቤቴክርስታኒኖን ቤትራ ትሽኪት ፋናር ስንና ቦርአ ዎስኒ ሜያ ዙታምቤሲሴ አሲስን ሀቴር ደይ ዎሲ ይስቴራ ቴግቶናክ ሾልሱኖይናርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ስኑንታኖ ታ፤ ሀሽ ስንና ባሮን ስንናስ ሀኦሲ ኦትማክዋ። ታክ እምቴ ኦትማስ ጋንባ ፎንቶኖን ኣነ ፉእቶዋ። ኤስ ባሪስታን ኣትታ ኦሚኒ ሜያስታን አርክሮን ዎስቶክ ሆፕን። ስኑንታኖ ኤስ ባሮን ዛግስ ታኔን አነ ፋ ሀኦሲ ኦትማታኖ ታቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ኤሴ ታ፤ ስንፋናክ ወደይ ባሶ ስንነፌክ አሲፌኒስ ኤስ ባሮጝዋ፤ ንቶ ደይ አማነቲስ ኤስ ባሮጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ስኑንታኖ ክርስቶስ ክቱን ካብናማቶ ማኬኒ ስንፋናነ ንቶስን እሳ እሳ ሜያ ክቱን ካቡ ኣፋዋ ኣካክ ይሴፌሶ? ");
INSERT INTO jnje_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","ክቱን ካቡ ትሽፋናነ ክርስቶስ ክቱን ኣነ ካቡዌ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ክርስቶስ ክቱን ካቡ ሻካናነ እንኖ አስሱስ ስኑን ንቶ አማንቶስ ሽማሲክ ስንባዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ደይ ሀኦስ ክርስቶስኒን ክቱን ካብጝዋ ይሬ አስሱኒሲክ ኤሽኛ ሀኦኒ ዛል ስንኒ ኡዋ። ኤሴ ክት አሱኒ ሜያ ክቱን ካቡ ሻክሴፋቴነ ሀኦስ ክርስቶስኒን ደይ ክቱን ኣነ ካብጉዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ክት አሱኒ ሜያ ክቱን ካቡ ሻክሴፋቴነ ክርስቶስ ክቱን ኣነ ካቡዌዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ክርስቶስ ክቱን ኣነ ካቡዌ ስንፋናናነ አማንቶኒትስ ሽማሲክዋ ኡዋ። ንቶ ደይ ሀሽኑ ቦርኣስቱ ፋሴት ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ክርስቶስኒክ አማነሬ ክት ባሶ ትሽሴቴዋ ኡዋ፦ ");
INSERT INTO jnje_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ክርስቶስኒክ አብድ ዛግፌኒስ ሀን ዳስታኪ ካክ ኮእባ ስንፋናነ አሱ ዙታምባሴ አሲስን አርክሮን እኖክ ሱሞኒ አስሱ ስንናኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ስኑንታኖ ክርስቶስ ክት ባሶክ ክቱን ካቡኒ ኡዛ ስንነ ፉቶክ ክቱን ካብዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","ክቱ ያናስ እሳ አሱኒኪ ካሞ ስንናማቶ ክቱን ካቡስ ደይ እሳ አሱኒኪ ካሞ ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","አዳምኒ ቦርአ አሱ ዙታምባሴ ክትፌናማቶ ደይ ክርስቶስኒ ቦርአ አስሱ ዙታምባሴ ካ ዳናናዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ስኑንታኖ ኤስ ባር ደይ ስንናናስ እሳርባ እሳርባስ ታራባሲክዋ። ክርስቶስ ክቱን ካቡባሲክ ኡዛዋ። ሀንኔን ደይ ክርስቶስ ዬፌና ካባሲክ ባሳር ስና ባሶ ደይ ክቱኒን ካብሶነርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ቱስሬ ደይ ባር ሀእሱሶንናዋ ሀእሱኒ ሁግናሶንና ደይ ግዶሶን ዙትሬ ትሽካት ታቶሶን አባ ሀኦሲክ እምፌና ካባሲክ ሀን ዳስ ኮአ ስንናናዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ሀኦስ ጉማባስን ዙትራ ሀእሱባሲ ስካሎሲ ዛጉና ካባኔን ክርስቶስ ታትቶናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ሜርቴራ ኮእባስታክ ትሹኒስ ጉማኒ ስና ክቱስዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","«ሀኦሲ ዙታምባሴ አሲን ሀእሱባሲ ስካሎሲ ዛጊዋ» ይፋር ትቼዋ። ስኑንታኖ፦ «ዙታምባሴ ሀእሱባሲ ስካሎሲ ዛግ» ኡስ ዙታምባሴ አስን ሀእሱባሲ ስካሎሲ ዛግ አባ ሀኦሶን ኣነ ዳይስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ዉዛ ዙታምባሴ ክርስቶስኒ ሀእሱኒ ስካሎሲ ስንናኔን ኦርፎ አባ ሀኦስ ዙትራ ዙታምባሴ አሲስታ ስናናክ ናስ ቴትባሲክ ዙታምባሴ አሲን ሀእሱባሲ ስካሎሲ ዛግ አባ ሀኦሲ ሀእሱኒ ስካሎሲ ስንናናዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","ኤሴ ክት አሱኒ ሜያ ክቱን ካብሶ ሻክሶነር ስንፋናነ ክት አሱኒ ሜኒ ቾዋሲክ ሀጱቅቴሴፌ ባሶ ዙቴሬ ቡእቤሲስ ኣምባንሶ? ክት አሱኒ ሜያ እሳንነ ኣፋ ክቱን ካብሶነ ዉዛ ስንፋናነ አሱኒ ሜያ ባሶ ኤዴ አዉኒሮን ሀጱቅቴሴፌሶ? ");
INSERT INTO jnje_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","እንኖኑ ስንፌኒክ ሳአት ሳአትሲክ አዳጋታ ካቱኒ ዉዛክ አቴራ ኦድቴት ፋኒስ አዉኒ ቦርአንሶ? ");
INSERT INTO jnje_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","አይኒ ሜያነ! ታክ ዎንና ዎንና ክቱ ኡጰርዋ፤ ሀን ባሮን ንቶክ ማኬፋናስ ዳምኒ የሱስ ክርስቶስኒኪ ካሞ ንቶስታ ፋ ቴቶናስ ፉቶ ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","አሱኒ ሳፋራስማቶ ታ፤ ኤፌሶኑክ ጎኞስኔን አነ ካቦናስ ታክ ኬእናስ ኣምባንሶ? ክቱኒ ሜያ ክቱኒ ካቡ ሻክሶነር ስንነፋቴነ፦ «ዎኖ ክቱኒር ስንና ቦርአ ሀን ያኒ ሙኒ፤ ኡሽኒ» ይስቴናይስማቶ ስንኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ኤሽቶትታዋ፤ «ማጙ ዞሞስ ማአ አማላሶን ማጝስርዋ» ");
INSERT INTO jnje_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ሀጝ ንብንትሲክ ዎሉትዋ፤ ቦርኣሶን ደይ ዎስቶትታዋ፤ ንቶ ጋነያሲ እሳ እሳ ሜያ ሀኦሶን አሩኖር ፌሴቴርዋ። ሀን ባሮን ኤካ ይፋናስ ንቶ ኢቾሶትክዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ስኑንታኖ እሳ አሱ፦ «ክት አሱኒ ሜያ ካብሶኔስ ኣካኪንሶ? ክቱን ካብሴፌ ካባሲክ ፎኒ አቱቤሲስ አዉነ ፋሪንሶ?» ይሬ ማምሱና ስንናናዋ፦ ");
INSERT INTO jnje_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","ነ፤ ጎዋ! ቡክታ ሜያስ ክቱ ሻካናነ ካባ ኣፋ ፎና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","ነ፤ ቡክፋታ ካባሲክ አካክልትሶን ኣነ ቶኬዋ፤ ስኑንታኖ ዛላስ አዉዛክነ ዛጎ ወደይ ኦማ ዉዛ ስናናክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ስኑንታኖ ሀኦሲ ሾሌናማቶ ዛላሲክ አቱባ እምፋዋ። ዛላስ እሳ እሳርባሲክ ኦማ ኦማ አቱ እምፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","አሻ ዙቴራ እሳ ቴሳታዋ፤ አሱኒ አሻስ እሳ ቴሳዋ፤ ካባሬ የሬ ዋጋሲ አሻ ደይ ኦማ ቴሳዋ፤ ካሳሲክቶኒ አሻ ኦማ ቴሳዋ፤ ኩርጡሚሲ አሻ ደይ ኦማ ቴሳዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ኤሲስማቶ ደይ ሳማኪ አቱ ፋር፤ ሀን ዳስታኪ አቱ ደይ ፋርዋ። ስኑንታኖ ሳማኪ አቱሲ ኡልፍና እሳ ቴሳዋ፤ ሀን ዳስታኪ አቱሲ ኡልፍና ደይ ኦማ ቴሳዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","አዋሲ ኡልፍና እሳ ቴሳ፤ አሳሲ ኡልፍና ደይ ኦማ ቴሳውኣ፤ ባኩራስ ኡልፍና ደይ ኦማ ቴሳ፤ እሳ ባኩራስ ኦማ ባኩራስታን ኦማ ኡልፍንባ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","ክቱን ካቡኒ አሱኒ ሜኒ ቾዋስ ሀን ባርነ ፋርዋ። ኩፕኒ አቱቱ ቡክቴፋርዋ፤ ኩፓ ትሹኖር ሀየዋ አቱቱ ስንና ካቡናዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ሳልጲናክ ቡክቴ ባር ኡልፍናክቱ ካቡናዋ፤ ሆፕያ ስንና ቡክቴ ባር ሁግናባሬ የሬር ስንናቱ ካቡናዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","አሽኒ አቱ ስንና ቡክቴ ባር አያናኒ አቱ ስንናቱ ካቡናዋ። አሽኒ አቱ ፋናኔን አያናኒ አቱ ደይ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ኤስ ባሪ ቦርኣ፦ «ቴሱኒ አሱ አዳም ሀየዉ ቴስቶ ስኒዋ» ይስቴራ ትቼዋ። ስኑንታኖ ኮእኒ አዳም ስንና ክርስቶስ ደይ ካ እምኒ አያና ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ስኑንታኖ ቴሱስታ የይስ አሻ ማዮቴኖ አያናኒስቴዋ። አያናኒስ ዬናስ አሻ ማዮስኔን ኦርፎዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ቴሱኒ አሱስ ቴስቴናስ ሀን ዳስክር ስንና ቦርአ ሀን ዳስታኪርዋ፤ ሄፕሳኒ አሱ ዬናስ ሳማጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ሀን ዳስታኪር ስንና ባሶ ሀን ዳስታኪ ቴስቴ ባሳይሲማቶዋ። ሳማን ስንና ባሶ ሳማን የ ባሳይሲማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ሀን ዳስታኪ አሱሳ ግቶነ ፌር ስንማቶ ደይ ሳማኪ አሱሳ ግቶነ ፌር ስንናኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","አይኒ ሜያነ! ታ፤ ንቶክ ማኬፋናስ ሀኒስዋ፤ አሻሴዋ ሀንናሴ ሀኦሲ ታቶኖን ኣፋ ኤጳቶና ዉዛ። ኤሲስማቶ ደይ ክቱኒ አቱስ ክቱኖይ ሀየዋ አቱሶን ኣፋ ኤጳቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ኤሴ እሳ ኣቾ ዉዛ ንቶክ ማኮናዋ፤ እንኖ ዙታምኒሴ ኣፋዋ ክቱኒ ዉዛ፤ ስኑንታኖ ዙታምኒሴ ሶልቶኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ሶልቶኒስ ደይ ኮእኒ ቱቱሩስ ፉግቴፋና ካባሲክ ኣፍኒ ዋልጋት ይፕግፌስነ ፋሮን እሳርጋክዋ። ቱቱሩስ ፉግቶና፤ ክት አሱኒ ሜያ ደይ ክቱኖር ሀየዉ ስንነሬ ክቱኒ ካብሶነ፤ እንኖ ደይ ሶልቶኒ። ");
INSERT INTO jnje_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","ሀን ኩፕን ባር ኩፕኖይሶን ሀን ክቱኒ ባር ክቱኖይሶን ማያናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ኤስ ኩፕኒ ባር ኩፕኖይሶን ሀን ክቱኒ ባር ክቱኖይሶን ማይፋና ካባሲክ፦ «ክቱስ ትሺ ደይ ሜርቴ!» ይስቴራ ትቼ ባር ኮኡናዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ኤሲስማቶ ደይ፦ «ክቱሴ! ሜሬሬ ካቡኔስ አይፋሴ? ክቱሴ! አሱኒ ሚርኤፋታ ሁግናኔስ አይፋሴ?» ይስቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","ክቱሲ ኬጅኒ ሁግናስ ቦርኣስዋ፤ ቦርኣሲ ሁግና ደይ ቱማስዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ስኑንታኖ ዳምኒ የሱስ ክርስቶስኒኪ ካሞ ሜሮኒክ ዛግፋ ሀኦሲክ ጋላታ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ኤስ ባሪ ቦርኣ ሹንቶ አይታሳክቶኖ! ዛግራ የሮትዋ፤ እሳ ዉዛክኑ ስንፋናነ ሾርኮትታዋ፤ ዳሚሳ ዎስቶክ ሆፕፌት ባር ሽማሲክ ስና ቤይባሶን አሪራ ዬቱኖይ ዎንና ዎንና ዳሚሳ ዎስቶኖን ዎስቶክ ችምትዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","አማኝኒክ ዛግቴፋ ዋግኒ ክሱኒ ቾዋሲክ ጋላትያኒ ቤቴክርስታኒሲክቶክ አጃጀናስማቶ ንቶ ደይ ኤካ ዛጉትዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","ታ፤ ያፋና ካባሲክ ዋግኒ ክሱ ዛግቶኖይናማቶ ጉዳ ጉዳሲ ዎኖ ንቶ ጋነያስን እሳ እሳርባሲክ ዳንፌና ዋጋስታን ክስሬ ኦር ኩንሱዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ታ፤ ንቶኪ ያፋና ካባሲክ ንቶ ኮሪራ እሜቲ አሱኒ ሜያ ክስሴቲ ዋጋሶን ኤጴ የሩሳሌም ሀሞነክ ጌጌሱኒ ትቻኔን አነ ዎሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ሾልሲፋናነ ታ፤ ደይ ባሶኔን ሀማና፤ ባሶ ደይ ታኔን አነ ሀማክ ችሞነ። ");
INSERT INTO jnje_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","ሜቀዶንያ ካሞ ሀማናክ ኮፓኤና ቦርአ ኤስታ ካሞ ኣትፋና ካባሲክ ንቶኪ ዮናዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ሀማና ድማ ኣፋሪስኑ ኡጉናሲክ ስንኒ አሪጋሱ ታክ ዛጉትክ አዉዛክነ ንቶኪ ኤስታ ጋሮ ዎና ፎና ስናና፤ አዉዛክነ ደይ ዬሹሶን ንቶኔን አነ ኣቱና ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ሀሽ ኤስታ ካሞ ኣትፋና ካባሲክ ንቶትን ብያናክ ኣነ ሾሎትዋ፤ ዳሚሳ ፍቃድ ስንፋናነ ጋሮኖን ድቻ ዎና ንቶኔን አነ ፎናማቶ አብድ ዛግፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ስኑንታኖ ፐንጠኮስቴኒ ሄቦስ ካርአናኔን ኤፌሶኑክቱ ፎናዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ሾዎ ዎስቶኒ ኡግና ታክ ጋችቼ፤ ስኑንታኖ ቱጋእኤፌ ሜያ ሾዎዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ትሞትዮስ ንቶኪ ዬፌና ካባሲክ ድጋባ ፎንቶኖን ንቶኔን አነ ፎናክ ባሪን አሪጋሱት። ባር ደይ ታይሲማቶ ዳሚሳ ዎስቶኖንቱ ዎስቴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ኤስ ባሪ ቦርኣ ኦኑ ባሪን ካሹኖይናማቶ ባር አይኒ ሜያኔን አነ ታኪ ዎል ሌ ዮናክ ኦደት ፋናር ስንና ቦርአ ታኪ ናጋክ ዎል ሌ ዮናክ ኡጉንባሲክ ሾልሲ ባሮን ባሪክ አሪጋሱትዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","አይኒ ስንና አጵሎስ ኦም አይኒ ሜያኔን አነ ንቶትን ዬሴሬ ብዮሶነክ ማእስራ ሺጴራ ፋናርዋ። ስኑንታኖ ባር ሀሽ ንቶኪ ዮክ ኣኔ ሾሎዌዋ፤ ባርክ ማእና ዎኖ ዮናዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ጉዙት፤ አማንቶክ ዛግራ የሮት፤ ችምት፤ ዛጉት። ");
INSERT INTO jnje_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ዛግፌት ባሮን ዙትራ ኬሽታናክ ዛጉት። ");
INSERT INTO jnje_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","አይኒ ሜያነ! እስጥፋኖስኒ ኬርኪ ሜያ አካያኒ ዳስታኪ ቴሱኒ አማኝኒ ሜያ ስንነቴማቶናዋ አማኝኒ ሜያኖን ዎስቶክ ቴትቤሲሶን ኣትሬ እሜቴማቶና አሪሴዲፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ኤስ ኤፍፌቴና አሱኒ ሜያክናዋ ባሶኔን አነ ዎስቶክ ሆፕት ፌሴፌ ባሶ ዙታምቤሲሴ አሲክና አጃጃሞሶትክ ማእስራ ያዳሲፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","እስጥፋኖስኒክናዋ ፌርዶናጥስንክና ደይ አካይቆስንና ባሶ ታኪ ዮስ ታን ግርሲዋ። ንቶ ታኔን አነ ኡጶ ሻኩንትሲክ ባሶ ንቶ ኤድደ ታክ ዮእ ባሮን ቱኒሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ባሶናዋ ታናዋ ንቶትና አሲ አያናሲክ ቤይሳ እሜቴ። ኤስ ባሪ ቦርኣ ኤስ ባሶነ ፌ አሱኒ ሜያ ኡልፍንቶሶነክ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","ኢስያክ ፋ ቤቴክርስታኒሲክቶ ናጋ ንቶክ ኦሽሼሴቴዋ። አቀላነዋ ፕርስቅላነ፤ ደይ ኬቤሲስ ዙቴሴፌ ክርስታናኒ ሜያ ደይ ዙቴሬ ንቤሲስን ካብ ናጋ ንቶክ ዳሚሳ ሱናክ ኦሽሼሴቴውኣ። ");
INSERT INTO jnje_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","ሀንታክ ፌሴ ክርስታናኒ ሜያ ዙቴሬ ንቶክ ናጋ ኦሽሼሴቴዋ፤ ኮርቶ ዳሞክ ናጋ ዎል ኦሽሾሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","ታ ጳዉሎስ ሀን ናጋኒ ትቻሶን ኩሹናሲክቱ ትችጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ዳሚስን ሹኖር ፌፋናነ ኤርዉቴር ስኖዋ! ዳምኒሶ! ዮዋ! ");
INSERT INTO jnje_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ዳም የሱስኒ ኦትማስ ንቶኔን አነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ኬሽታናስ ክርስቶስ የሱስኒኪ ካሞ ዙታምኒትስኔን አነ ስንፋውጝዋ፤ ኣሚን!");
INSERT INTO jnje_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ሀኦሲ ፍቃድክ የሱስ ክርስቶስኒ ዎሲ ስና ጳዉሎስኒክንናዋ አይኒ ስና ትሞትዮስኒክና፤ ቆሮንጦስሱክ ፋ ቤቴክርስታኒሲክናዋ ኤሲስማቶ አካያኒ ዳ ዙታምባሴ አሲስታ ፌሴ ክርስታናን ሜያ ዙታምቤሲሴ አሲክና፤ ");
INSERT INTO jnje_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","አባን ስንና ሀኦኒስኪን፤ ዳም የሱስ ክርስቶስኒኪን ሀኦሲ ኦቱምነዋ ናጋነ ንቶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ፋኪን አባሲክናዋ እኖክ ችማሶን ዙትራ እምፋ ባርኪና ደይ ዳምኒ የሱስ ክርስቶስኒ አባ ሀኦሲክ ጋላታ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","እንኖ ሀኦስኪን ዳንፌኒ ችማሲክ ሻናስ ፌሴ ባሶ ዙታምቤሲሴ አሲን ችኑኒክ ሀኦሲ እኖስታ ካርፋ ሻና ዙታምባሴ አሲክ እኖትን ችኒፋ። ");
INSERT INTO jnje_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ክርስቶስኒ ሻናስ ሾዎኖን ሃኤኒሲማቶ ባሳ ችኑሶን ደይ ዳይስራ ዳናኒ። ");
INSERT INTO jnje_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","እንኖ ሻናሶን ኤጳ ታፌን ካባሲክ ንቶ ችምነዋ ፋሩነ አሲን ዳነቲ። እንኖ ችምፌኒ ካባሲክ ንቶ ደይ እንኖ ኤጳታኒ ሻናስንነ ፋዪሶን ፋክያክ ኤጳ ታራ ችማትዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","እኖስታ ካርአ ሻናሶን ሃኤትስነ ፋሮን እንኖ ችማሶን ደይ ሃኦትማቶ አሪፌኒ ቦርአ ንቶስታ ፋ አብድኒስ አካማዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","አይኒ ሜያነ! ኢስያኪ ዳስታክ ፋኒ ካባሲክ እኖስታ ካርአ ሻናሶን አሩሶትክ ሾሌፌንዋ። ኤስ እኖስታ ካርአ ሻናስ ዎርአክ ችምኖይኒ ፋያ ስንና ቦርአ ካክ ፎኒ አብዲስኑ እኖስታን ቡድራቱ ፋ። ");
INSERT INTO jnje_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ኤሲስማቶ ክቱኒ ማጝሱኒ ካርአ እኖስታ ካቴናርነ ፋር ስንናቱ እኖክ ቤስቴ፥ ኤስ ባር ዙታምባሴ እኖስታ ካርአናስ አማነፌኒስ ክቱኒ ሜያኖን ክቱኒ ካብግፋ ሀኦሶንታኖ እንኖ ሁግናሲክታ ስንና ቤይባሶን ያዳቶኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ኤስ ባሪ ቦርኣ ባር ክቱታ ካቱኒ አዳጋስኒ እኖትን ፉኤ፤ ደይ ፉኦና፤ ሀንኔን ደይ እኖትን ፉኦናማቶ አብድኒስ ባሳስታዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ንቶ ደይ እኖትን ሺጶኒትሲክ አሪጋሱትክ ሾልስፋዋ። አካማ ሺጶሲክ እንኖ ሀኦሲ አሪጋሱኖን ዳንፌኒ ካባሲክ ሾዎ አሱኒ ሜያ ደይ እንኖ ቦርአ ሀኦሶን ጋላቴሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ኤሴ እንኖ ቴቶኒክ ሾልሲ ዉዛስ ሀኒስዋ፤ ኤስ ባር ደይ ፉቶ ስኒባሶን ካኑኒስ እኖክ ዛላዋ፤ ኦም አሱኒ ሜያክናዋ አሪክሮን ደይ ንቶኔን አነ ፋ እሳርኒስ ሀኦስኪን ዳኒ ኮርቶሴዋ ማኣሴ አሲስታቱ ዛግራ የሬ። ኤስ ባር ደይ ስንናስ ሀኦሲ ኦትማክታኖ አሱኒ ቴችማክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ፌሬትራ ያዳቶትክ ችማት ዉዛሶንቱ ትችኒታኖ እሳንነ ኦማ ዉዛ ኣነ ትቹዌንዋ። ዙታምባሴ አሲን ያዳቶትክ ችማትማቶ አብድ ዛግፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","ሀሽ እንኖ ቾዋሲክ አሪፌትስ ባጋዋ፤ ስኑንታኖ ኦርፎ ማእስራ ያዳቶትማቶ አብድ ዛግፋዉጝዋ። ኤስ ባሪ ቦርኣ ዳም የሱስ ዮና ዎኖ እንኖ ንቶክ ቴቴፌኒስማቶ ንቶ ደይ እኖክ ቴቶት። ");
INSERT INTO jnje_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ኤስ ባሮን ማእስራ አሪና ቦርአ ሄፕ ኩሹኖን ንቶክ ኬአናክዋ እያት ዜምማ ንቶትን ያራ ብያናክ ኮፓኤራ ፋናር። ");
INSERT INTO jnje_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ንቶትን ብያናክ ኮፓኤናስ ሜቀዶንያ ሀሚፋና ካባሲክናዋ ኤስታን ዎላ ያፋና ካባሲክናዋ። ኤሲሲክ ዩዳኒ ዳ ሀማና ኡጉናሲክ ታን አሪጋሱትክ ሳፋሬራ ፋናርዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ኤስ ባሮን ኮፓኤራ ካብፋና ካባሲክ አዉ ዛጉናክ ሾልስንናማቶ አሩኖይ ኤክ ሀጝ ይት ፌ አሱነ ፌር ስንና ንቶክ ቤስቴዎሶ? ወደይ ኤስ ባሮን ኮፓኦናሲክ፦ «ኤ! ወደይ እንዳነ» ይት ኤክ ሀጝ ኡክ አሱኒ ሳፋራክ ዛግናርነ ፋር ስንና ንቶክ ቤስቴዎሶ? ");
INSERT INTO jnje_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","ሀኦስ አማናምቶ ስንና ቦርአ እንኖ ደይ ንቶክ ማኬፌኒስ፦ «ኤ! ደይ እንዳነ!» ይፋ ኤክ ሀጝ ኡኒ ካማክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","ታናዋ ስላስንና ደይ ትሞትዮስ ሀኦሲ ና የሱስ ክርስቶስኒን ንቶክ ማኬኒስ ዎንና ዎንና፦ «ኤ!» ይፋ ካማክ ኮእባታኖ፦ «ኤ! ወደይ እንዳነ» ይፋ ኤክ ሀጝ ኡኒ ካማሲክ ኣፋ ስናናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ሀኦስ እኖክ እምና አብዲስ ዙቴራ፦ «ኤ!» ስንናናስ ክርስቶስኒኪ ካሞዋ፤ ኤስ ባሪ ቦርኣቱ ሀኦሲ ኡልፍናክ ክርስቶስኒኪ ካሞ፦ «ኣሚን» ይፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","እኖትንናዋ ንቶትና ክርስቶስኒክ ችማ የሮኒክ ዛግስ ሀኦስዋ፤ ዎስቶክ እኖትን ኮሪስ ደይ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ባሳር ስኒሲክ ዛላ ስኒ ማታማሶን እኖስታ እቻ ባሬዋ ሀንኔን እኖክ እምቶኒ ኦትማሲክ ንብኒስ ኮርቶ አያናባሶን ዋሲ ዛግራ እኖክ እማስ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","ታ ዎላ ቆሮንጦስ ዮ ቤይናስ ንቶ ሱሞትክ ኣፋ ዛጉና ዉዛ ይራ ንቶክ ኬናሽቴፋትዋ፤ ኤስ ባርኪ ደይ ሀኦሲ ታክ ዛላዋ። ");
INSERT INTO jnje_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ንቶ አማንቶኒትሲክ ችም ስንነት ቦርአ ንቶትን ግርሱንክ ንቶኔን አነ ዎስቶኒስታኖ አማንቶኒትሲክ ኣፋ ንቶትን አጃጆኒ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ኤሴ ንቶ ሱሞትክ ዛጉኖይናማቶ ሳፋሮክ ንቶትን ብያክ ዎላ ኣፋ ዮናዉዛ ይራ ቡጊን። ");
INSERT INTO jnje_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","አዉነ ፋሮን ታ ንቶ ሱሞትክ ዛጉ ቤይፋናክኑ ንቶቴኖ ኦም ታን ግርሱንር ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ዜምማ ንቶክ ኤካ ትችናስ ንቶኪ ያፋና ካባሲክ ታን ግርሱሶነክ ሾልስና ባሶ ታ ሱሞናክ ዛግሶኖይቴማቶ እያትዋ። ታ ግራስ ንቶ ዙታምንትሴ አሲ ግራ ስኒባሶን አማነፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","አካማ ሱሞክናዋ ንብናስ ራካቴራና ደይ አካማ ሀራፋ ዋስት ሀን ትቻሶን ትችናስ አካማኖን ንቶትን ሹናር ስንናማቶ አሩትክ እያታኖ ንቶ ሱሞትክ ዛጉናክ ይራታዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","አሱኒን ሱሞናክ ዛግር ኦኑ ፌፋናነ ሱሞናክ ዛግናስ ታን ታን ስኖይናሮን ዙታምንትሴ አሲጝዋ፤ ቾዋሶን አሪክስንናርታዋ፤ ንቶ ጋነያስኑ ሾዎኒ ሜያኖንቱ ሱሞሶነክ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ኤስ ኤፌ አሱሲክ ንቶ ጋነያስን ሾዎኒ ሜያ ባሳስታ ማጝሱ ካርኤቴ ኬኦስ ባርክ ሆሮናዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ኤስ ባሪ ቦርኣ ኤስ አሱስ አካማኖን ሱሞባስታን ካብ ቾዋ አብድ ቡጉኖይናማቶ ፌሹን ይራ ባሪን ችኑትክ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ኤሲስማቶ ባሪን ሹንትር ስኒትሶን ሄፕሳ ዎላ ባርክ ቤሱትክ ንቶትን ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ኤስ ዎሲያሶን ደይ ንቶክ ትችናስ ፋታንቴራ ዙታምባሴ አሲክ አጃጃሜር ስኒትሶን አሩናክ ሾሌፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","ንቶ ፌሹን ይሴት አሱስን ታ ደይ ባርክ ፌሹን ኡናዋ። ፌሹን ኡና ሚርአባ ፋፋናነ ታ ክርስቶስኒ ስንናክ ባሪን ፌሹን ኡናስ ንቶ ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ኤስ ባሮን ደይ ዛግፌኒስ ሴጣናስ ኮፖኖን አሪፌኒ ቦርአ ሴጣናስ እኖትን ኤሽኖይናማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ኤሴን ኦርፎ ክርስቶስኒ ምስራቹኒ ካማሶን ማኮናክ ጥሮአዳ ሀሚፋና ካባሲክ ዳሚስ ታጋ ዎስቶኒ ኡግና ታክ ጋች። ");
INSERT INTO jnje_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ስኑንታኖ አይታ ትቶኒን ኣነ ዳኑት ስንና ቦርአ አያናናስ ቤይሳ ኣነ ዳና። ኤስ ባሪ ቦርኣ ኤስታ ፌሴ ክርስታናኒ ሜያኖን ማርኦ ዱት እያት ሜቀዶንያ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ስኑንታኖ ዎንና ዎንና ክርስቶስ ሜሬና ባርክ እኖትን ዞንስራ ማአ ሳዉባሬ የሬ ሽቶኒማቶ ክርስቶስኒ ቾዋሲክ ፋ አሩሶን ዳዳሲ ካቱኒክ ዛግፋ ሀኦሲክ ጋላታ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","እንኖ ፋሩኒ ባሶክ ስኒፋናክ ትሹን ባሶክ ማአ ሳዉባ ፋናር ስንና ክርስቶስኒኪ ካሞ ሀኦሲክ ታእኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","እንኖ እሳይሲክ ዎሪፋ ክቱኒ ሳዋ ሳዉንር፤ ኦሚሲክ ካ እምፋ ካኒ ሳዋ ሳዉንር፤ ኤካኒ ሀን ዎስቶሲክ ሆሮ ስኒር ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","እንኖ ሀኦሲ ካማኖን ናጋድን ኮዳ ዛግሬ ሸልግሬ ናጋደሴፌ ሾዎ ሜኒማቶታዋ፤ ስኑንታኖ ሀኦስኪን ዎስቴ ማአ ዎሲ ስንና ክርስቶስኒኪ ካሞ ሀኦሲ ስንና ማኬፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ሄፕሳ ዎላ እንኖ ቴትኒሶን ጋላቶኒክ ካቡንሮሶ? ወደይ እሳ እሳ ሜያ ዛግሴፌስማቶ ንቶክ ወደይ ንቶኪን ትቼ አሪጋሱን ትቻ እኖክ ሾልሱንጋሶ? ");
INSERT INTO jnje_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","አሱ ዙቴሬ አሪፌናሴዋ ፌሬቲት ፌናሴ እንኖ ንብባሲ ትቼ እንኖ አሪጋሱን ትቻስ ንቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","ንቶ ደይ እንኖ ዎስቶሲክ ዬሴ ክርስቶስኒ ዎስያ ስኒትስ አማዋ። ሀን ዎስያስ ትቼናስ ሀየዋ ሀኦሲ አያናክታኖ ካላምክታዋ። ኤሲስማቶ አሱኒ ዳናራ ንባስታታኖ ዳናራ ሹኣስታ ትቼርታዋ። ");
INSERT INTO jnje_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ኤስ ባሮን ማኬናስ ክርስቶስኒኪ ካሞ ሀኦስታ አማንቶኒ ፋር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ዎስቶኒሶን ኮእሱክ ችማንክ ሆሮ ዛጉኒስ ሀኦስታኖ እንኖ ቴትኒሲክ እሳ ዉዛነ ዛጉንክ ችምኒ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ጋድዶ ቴያሲ ዎስትኛ ስናኒክ ሁግና እኖክ እማስ ባርዋ። ኤሲስ ደይ ማላቶክ ትቼ ቱማሲክ ስኖይናሮን ኮርቶ አያናስ አሪጋሱክዋ። ማልላቶክ ትቼ ቱማስ ክቱ ቴሸር። ስኑንታኖ ኮርቶ አያናስ ካ እማር። ");
INSERT INTO jnje_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ቱማ ቱምቴናስ ዳናራ ሹኣስታ ማልላቶክዋ። ቱማስ እምቴና ካባሲክ ፋ ቻሬፋስ ትሽት ሀማር ስኒፋናክኑ እስራኤልኒ ዳራስ ሙሴኒ ስናሶን ማእስሬ ብያክ ኣነ ችሞቶ። ኤሴ ክቱሶን ኤጳ ያ ቱማስ ኤፋቴና ኡልፍናክ ያናኔን፥ ");
INSERT INTO jnje_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ኤካን ኮርቶ አያናስኪ ካሞ ቤስቴ ዎስቶስ አካማኖን ኡልፍንባ ኣፋኖ ፎና ዉዛ? ");
INSERT INTO jnje_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","አሱኒ ሜያ ቦር ስንነቴ ዎስቶስ ኤፋቴናሮን ኡልፍንባ ፋር ስንናኔን አሱኒ ሜያ ኦኮ ስኖነ ዎስቶስ ኣካክ አካማኖን ኡልፍንባ ፎ ቤይንሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ኦርፎቲ ኡልፍናስ አካማኖን አሪክር ስንባስታን ካብ ቾዋ ኣታ ኡልፍናስ እሳንነ ኣፋነ ፋር ስንናቱ ፋድቶና። ");
INSERT INTO jnje_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ኤስ ጣቅጣቂት ሀማ ባር ኤፋቴና ኡልፍንባ ፋር ስንናኔን ኮእባ ፎንቶኖን ችምማ ፎኒ ባር ኣካክ አካማኖን ኡልፍንባ ፎ ቤይንርን? ");
INSERT INTO jnje_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ኤፋቴና አብድን ፋና ቦርአቱ ድጎ ቤይፌን። ");
INSERT INTO jnje_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ሆፕት ሀማ ሙሴኒ ስንናስ ፓልፓሉ ትሹና ካባኔን እስራኤልኒ ሜያ ቢሶኖይቴማቶ ስኒባሶን ኡኬት ፌር፥ ስኑንታኖ እንኖ ኤሲስማቶቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ባሶ ንብባሲ ፉቶሲክ ታችዋ፥ ሀሽ ሀውጙኔን ካርአ ኩርኡ ቴያሲ ማፃፋኖን ፌሬትሴፌ ካባሲክ ንብቤሲስ ኤስ ይኑሲክ ጌፕቶቤሲሴቱ ፌሴቴዋ፥ ኤስ ይኑስ ትሹናስ ክርስቶስኒኪ ካሞ ኮእባዋ። ");
INSERT INTO jnje_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ሀሽኔን ካርአ ቱማስ ማፃፋኖን ፌሬትሴፌ ካባሲክ ንብቤሲስ ኤስ ይኑሲክ ጌፕቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ስኑንታኖ አስሱ ዳሚሲክ ዎልፌና ካባሲክቱ ኤስ ይኑስ ካቡና። ");
INSERT INTO jnje_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ዳሚስ አያናዋ፤ ዳሚሳ አያና ፋና ድማስታክ ብርማዱማስ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","እንኖ ዙታምኒሴ ጌፕቶኖይ ስንናክ ፋፋት እንካሊስ ቢስቴፋናስማቶ ዳሚሳ ኡልፍናኖን ፓልፓልግራ ቤሱንዋ። እንኖ አያና ስንና ዳሚሳ ግቶኖን ስንነ ቤስቶክ ኡልፍናስታን ኡልፍናታ ሶልቶኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ሀኦስ ፋኪባሲክ ሀን ባሪ ዎስቶሶን እኖክ እምና ቦርአ አብድ ኣፋ ቡጉንዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ኣቾ ስና ባሮንናዋ ኢቹ ስና ዉዛሶንና ቤይኒ፥ ጃልሱክ ኣፋ ዎስቶኒዉዛ፥ ሀኦሲ ካማኖን ደይ ኣፋ ሶሎን ዉዛ፥ ኤስ ባርስታን ፉቶሶን አምማኖን ክስራቱ ቤሱኒ፥ ቴትኒሶን አሱ ዙታምባሴ አሲ ካኑክ ሀኦሲ ስና አምማ ዛግፌኒ። ");
INSERT INTO jnje_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","እንኖ አሲኒ ምስራቹኒ ካማስ አዉዛክነ ኣቾ ስንፋናክኑ ኣቸናስ ትሹኒ ባሶክዋ። ");
INSERT INTO jnje_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","ሀን ዳሲ አእስኛ ስና ሴጣናስ አማኖኖይ አሱኒ ሜኒ ንባሶን ታርእ፥ ኤስ ባሪ ቦርኣ ሀኦሲ ግቶክ አምማኖን ቤስቴ ክርስቶስኒ ኡልፍናኒ ምስራቹኒ ካማስ ቻርሱና ቻሬፋሶን ቢዮሶኖይቴማቶ ዛጊ። ");
INSERT INTO jnje_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","እንኖ አሲፌኒስ የሱስ ክርስቶስ ዳም ስንባሶንናዋ እንኖ ቴትኒሲክ የሱስኒ ቾዋሲክ ንቶ ዎስትኛ ስኒሶንታኖ እንኖ ቴታስ ቾዋኖን ኣፋ ማኮኒ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","«ቻሬፋስ ታልማስን ኬሳ ቻሮን» ይራ ማኬ ሀኦስ ክርስቶስኒ ግቶሲክ ቻርስፋ ሀኦሲ ኡልፍናኖን አሩኒ ቻሬፋ እኖክ እማናክ ቻሬፍባስ ንብኒስ ቻሮናክ ዛጊ። ");
INSERT INTO jnje_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ስኑንታኖ ሀን ዙታምባሴ አሲስታን ደናሎ ስና ሁግናስ ሀኦሲርታኖ እንኖር ስና ቤይባሶን አሪቶናክ ሀን ኡልፍንቶ ዉዛሶን ሆቾ ኮዳስ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ሻናስ ዳ ዳስን እኖስታ ካርፋ፤ ስኑንታኖ ኣፋ ሜርቶኒ ዉዛ፤ ሾዎ ዎና ዛጉንዉዛ ትሽፋ፤ ስኑንታኖ አብድ ኣነ ቡግፌን። ");
INSERT INTO jnje_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ጉማኒስ እኖትን ካሌ ኮፉክሴፌ፤ ስኑንታኖ ዋዳጃኒን ቱርክራ ኣነ ብየኒ፤ እቼራ ሀቴት ፋኒር፤ ስኑንታኖ ኣነ ክትፌኒ። ");
INSERT INTO jnje_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","የሱስኒ ካስ እንኖ አቱስታ አምማኖን ኬሳ ቤስቶናክ የሱስኒ ክቱሶን እንኖ ደይ አቱኒስታ ዎንና ዎንና ዎርኣ ኩትፌኒ። ");
INSERT INTO jnje_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","የሱስኒ ካስ ክቱኒ አቱኒስታ አምማኖን ኬሳ ቤስቶናክ ሀየዉ ስና እንኖ የሱስኒ ቾዋሲክ ዎንና ዎንና ክቱክ አቴራ እምቴኒር። ");
INSERT INTO jnje_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ኤስ ባሪ ቦርኣ ክቱስ እኖስታ ዎስቴድፋር፤ ስኑንታኖ ካስ ንቶሲ ዎስቴድፋር። ");
INSERT INTO jnje_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ስኒፋናክኑ፦ «አማነን፤ ኤስ ባሪ ቦርኣ ደይ ማኬን» ይስቴራ ትቼናስማቶ እንኖ ደይ ኤስ እሳ አማንቶኒ አያናስ እንኖሲ ፋና ቦርአ አማነፌኒ፤ ደይ ኤስ ባሪ ቦርኣ ማኬፌኒ። ");
INSERT INTO jnje_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ዳም የሱስኒን ክቱን ካብግ ሀኦስ እኖትን ደይ የሱስኔን አነ ክቱን ካብጉናማቶናዋ ንቶኔን አነ ደይ ባሪ ስና ዬቱናማቶና አሪፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ኤስ ባር ዙታምባሴ ንቶክ ኬእኒር ስንና ሀኦሲ ኦትማ ቱማ ፉእቴራ ሾዎ አሱኒ ሜያክ ካርፋና ካባሲክ ሀኦሲክ ስንኒ ጋላታስ አሪኩናክዋ። ");
INSERT INTO jnje_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ኤስ ባሪ ቦርኣ አብድ ኣፋ ቡጉንዉዛ፤ አዉነ ፋሮን ጌሮኪ አቱኒስ ትሽፋናክኑ ስርኪ አቱኒስ ዎንና ዎንና ጋድዶ ስንናቱ ፋ። ");
INSERT INTO jnje_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","ሀን ካሾሴዋ ሀሽቲ ካባስሬ ስና ሻናኒስ ባርክ ክጣቶኒ ዉዛባ ፎንቶ ኮእኒ አካማ ኡልፍናሶን ዳናኒክ ዛጉና። ");
INSERT INTO jnje_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","እንኖ ኦደት ፋኒስ ቢስቶኖይ ዉዛሶንታኖ ቢስቴፋ ዉዛሶንታዋ፤ ቢስቴፋ ባር ሀሽትርዋ፤ ስኑንታኖ ቢስቶኖይ ባር ኮእባ ፎንቶስዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","ሀን ዱርካኒሲማቶ ሀሽቲ ካብኒር ስንና ሀን ዳስታኪ አሽኒስ ቦግቴፋና ካባሲክ አሱኒ ኩሹክ ኬቶኖር ሀኦኒ ኩሹክ ኬቴ ኮእባ ፎንቶ ፎኒ ኬያ ሳማኪ ፋናማቶ አሪፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ኤስ ካባኔን ሳማኪ አቱሶን ማያኒክ ካልቶክ ካቤት ፋኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ኤስ ባሮን ማይፌኒ ካባሲክ አታቱ ስንና ኣፋ ቤስቶኒ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ሀን ዳስታኪ ዱርካኒሲማቶ ስና አቱኒሲክ ፋኒ ካባሲክ ፋይፋን ሃነት ፋኒርዋ፤ ሃነት ፋኒስ ክቱስ ካክ ሶልቶናክ ሳማኪ አቱሶን ማያኒክታኖ ሀን ዳስታኪ አሽኒስታን ኦር ኬሳኒክ ሾሌፋታዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ኤስ ባርክ እኖትን ሆሲስ ሀኦስዋ፤ ኤስ ባርስታን ደናሎ እኖክ እምቶኒዉዛ ዙታምባሴ አሲክ ኦቶ ስናናክ አያናባሶን እኖክ እማስ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ሀን ዳስታክ አሻክ ፋኒ ካባሲክ ዳሚሳታን ዎካ ፎኒሶን አሪፌኒክኑ ዎንና ዎንና ባርኪቱ አማነፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","እንኖ ፋፌኒ ፎስ ዳሚስን አማንቶክታኖ ባሪን ቢራታዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","አሽኒስታን ኦር ኬሳ ዳሚሲክ ፋ ኬኒሲ ፎስ እኖክ ማአሪዋ፤ ኤስ ባሪ ቦርኣ አማንቶክቱ ፋፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ሀን አሽኒስኔን ፋፌኒክ ወደይ ኦር ኬስፌኒክ እንኖ ሾሌኒስ ዳሚስን ግርሱዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","አሱ እሳርባ እሳርባሲክ ሀን ዳስታክ ፌና ካባሲክ ማጙ ዎስቶ ስኑን ማአ ዎስቶባሲክ ዋግባሶን ኤጴቶናክ እንኖ ዙታምኒሴ ክርስቶስኒ ማጝሱኒ ካርኒ ኮዳስ ስና ታአኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ዳሚስን ድጎስ አዉ ስንናማቶ አሪፌኒ ቦርአ አሱኒ ሜያ ኤጴቶሶነክ ዛጊፌኒ። እንኖ ኦ ስኒማቶ ሀኦስ አሪፋዋ፤ ንቶ ደይ ንብንትስ እንኖ ኦ ስኒማቶ አሪሴፌትማቶ አብድ ዛጊፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ንብቤሲስ ፋ ባርክ ስኖይናሮን ቢስቴፋ ባርክ ቴቴሴፌ ባሶክ ዎልጉ እማ ችማትክቱ እኖክ ቴቶትክ ዛጉንታኖ ሄፕሳ ዎላ እንኖ እኖትን ንቶ ስና ኣፋ ጋላቶኒ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ንፋሶ ስኒፌንክ ሀኦሲክዋ እያትዋ፤ ካኑባሬ የሬ አሱ ስኒፌንክ ንቶክዋ እያትዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","እሳርጋ ክርስቶስ አሱ ዙታምባሴ አሲክ ክቱባሶንናዋ ዙቴሬ ክትሴቴማቶ አሪኒ ቦርአና ክርስቶስኒ ኬሽታናስ ዎስቶኒክ ግድሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ካክ ፌሴ ባሶ ክት ባርኪንናዋ ክቱኒ ደይ ካብ ባርክና ፎሶነክታኖ ሀንኔን ኤካሎክ ባሶ ቴታሲክ ፎሶኖይቴማቶ ክርስቶስ ዙታምቤሲሴ አሲክ ክት። ");
INSERT INTO jnje_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ሀንኔን ኤካሎክ እንኖ ኦኒንኑ አሽኒ ሳፋራክ ኣፋዋ ብያንዉዛ። ዜሞ ስናክ ክርስቶስኒን ማዛነኒስ ባክ አሱኒማቶ አሽኒ ኣፋክ ስንፋናነ ዮኒ ዎናሲክ ኤካ ኣፋ ማዛኖንዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ኤስ ባሪ ቦርኣ ኦኑ ክርስቶስኒር ስንፋናነ ጋድዶ ቴስቶዋ፤ ኩርኡ ቴስቶስ ኣት ኤስ ባሪ ኤዴስ ጋድዶ ቴስቶ ግሪ። ");
INSERT INTO jnje_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","ኤስ ባር ዙታምባሴ ስንናስ እኖትን ባርኔን አነ ክርስቶስኒኪ ካሞ ጋንስራ ጋንሱኒ ዎስቶ እኖክ እማ ሀኦስክጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ኤሲስ ደይ ሀኦስ ክርስቶስኒኪ ካሞ ሀን ዳስታኪ አሱኒ ሜያኖን ዙትራ ባርኔን አነ ጋንሲ ኡዋ። ማጝሱቤሲሶን ኣነ ፋዱዋ፤ ደይ አሱስን ዳሚስኔን አነ ጋንሱኒ ካማ እኖክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ሀኦስ አሱኒ ሜያኖን እኖኪ ካሞ ቴጎኒር ስንና ቦርአ እንኖ ክርስቶስኒ ካማሲ አምባሳደርዋ። ኤስ ባሪ ቦርኣቱ፦ «ሀኦሲኔን ጋኖት» ይራ ክርስቶስኒ ሱናሲክ ሺጴፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","እንኖ ክርስቶስኒኪ ካሞ ሀኦሲ ኦኮኖን ሃኤር ስናኒክ ሀኦሲ ቦርባ ፎንቶ ክርስቶስኒን እንኖ ቦርኣሶን ባር ዎርአናክ ዛጊ። ");
INSERT INTO jnje_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ሀኦስኔን አነ ዎስቴት ፋኒር ስኒስማቶ ንቶ ኤጳ ታቲ ሀኦሲ ኦትማኖን ኬእኖር ዛግራ ፉኦትታዋ ይራ ሺጴፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","ሀኦሲ፦ «ሾልሱ ሳአትስታ ኔን ኦደን፤ ፋሩኒ ዎናስታ ኔን አሪጋስንን!» ይፋና ቦርአ። «ኤሴ ሾልሱ ዎናስ ሀሽዋ፤ ፋሩኒ ዎናስ ደይ ሀሽዋ።» ");
INSERT INTO jnje_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","እንኖ ዎስቴፌኒ ሀኦሲ ዎስቶ ካሽስቶኖይናማቶ እሳ ዉዛክነ ኦኒክኑ ቱሳ ኣፋ ሲናኒዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ኤስ ባርስታን ሻናሶንናዋ ራክኮሶንና ደይ ትርኦሶን ፋክት ሀኦኒ ዎስትኛኒማቶ ቴትኒሶን ዙታምባሴ አሲክ ሀኦሲክ ታእስድፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ሀኦኒ ዎስትኛ ስንኒሶን አምማኖን ክስራ ቤሱኒስ እቾክ፥ ታቶክ፥ ራካቶክ፥ ዎስቶ ዎስቴሬ ሆፑክ አፋይኒን ቱርኩክናዋ ማክቶክናዋ። ");
INSERT INTO jnje_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ኤሲስማቶ ደይ ካይማክ፥ አሩክ፥ ፋክያክ፥ ማአክ፥ ኮርቶ አያናሲክ ዞኑስቶክናዋ ታነ ፌ አሱ ኣፌ ኡባ ፎንቶ ኬሽታናክና፤ ");
INSERT INTO jnje_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ፉቶኒ ካማሲክናዋ ሀኦሲ ሁግናክና ኦኮሶን አልዳ ኩሹክናዋ ሆእታ ኩሹክና ኔቦኒ ሜያ ዛግራ ኤጳ፤ ");
INSERT INTO jnje_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","ኡልፍናክናዋ ሳልጲናክና፥ ዋቃስቶክናዋ ጋላትኒ ዳናክናቱ ፋኒ። ፉቶኒር ስንና ፋኒ ኤሻር ይስቴኒ። ");
INSERT INTO jnje_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","አርቶ ስንና ፋኒ አሪቶኖር ስኒ፤ ክትሴቴዋ ይስቴፌንክ ሀየዉ ስንናቱ ቤስቴፌኒ፥ እቼፌኒክኑ ኣነ ዎርቶዌኒ። ");
INSERT INTO jnje_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ሱሞ እኖስታ ካርፋናክኑ ዎንና ዎንና ግሬት ፋኒር፤ ቱካም ስንና ፋጌዶ ሾዎኒ ሜያኖን ኦቱም ዛግኒር፤ እሳ ዉዝኒ ፎንቶ ስንና ፋፌኒክ ዙታምባሴ እኖኪክ ፋር። ");
INSERT INTO jnje_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ንቶ ቆሮንጦስሱክ ፌሴ አሱኒ ሜያነ! ኤሴ አምማኖን ንቶክ ማኬኒዋ፤ ንብኒሶን ታግራ ንቶክ ጋችኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","ንቶቱ ኬሽታንትሶን ካለቴኖ እንኖ ኬሽታኒሶን ኣነ ካለኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","አባ ናንጎትባሲክ ማኬፌናይስማቶ ማኬፋት ኬሳ እንኖ ንብኒሶን ታግራ ስርኪ ሳፋራኒሶን አምማኖን ጋችቻ ቤስኒስማቶ ንቶ ደይ ኤካ ዛጉት። ");
INSERT INTO jnje_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","ስንኖይ ኡግናክ አማኖኖይ አሱኒ ሜያኔን አነ እሳ ዋንጆሲ ግሩትታዋ። ኦኮነዋ ቦርነ ኣካክ እሳር ስንናክ ችምኒሪንሶ? ቻሬፋሴዋ ታልማሴ ኣካክ እሳ ዳ ፎክ ችምኒሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ክርስቶስንናዋ ዳቡሎስና ኣካክ እሳር ስናክ ችሞነሪንሶ? አማነ ባሶትናዋ አማኖኖይ ባሶትና ኣካክ እሳር ስናክ ችሞነሪንሶ? ");
INSERT INTO jnje_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","ሀኦሲ ቤቴሜቅደሲ ኮእሎሲክቶኔን አነ አዉኒ እሳርባ ፋሪንሶ? ሀኦስ ደይ፤ «ፎና ድማሶን ዳራታሳ ጋነሲ ዛጉና፤ ባሶኔን አነ ፎና፤ ታ ባሶክ ሀኦቤስ ስናና፤ ባሶ ደይ ታክ ዳራታ ስኖነ።» ይራ ማኬናሲማቶ እንኖ ሀየዋ ሀኦሲ ቤቴሜቅደስዋ። ");
INSERT INTO jnje_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ደይ ዳሚስ፦ «ባሶ ጋነያስን ኮርቴራ ኦር ኬስት፤ ዝና ስና ዉዛሶን ታኡትታ፤ ታ ደይ ንቶትን ኤጳቶና፤ ");
INSERT INTO jnje_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ታ ንቶክ አባ ስናና፤ ንቶ ደይ ታክ ኣርቃ ናንጎትናዋ፤ ማሽካ ናንጎትነ ስናቲ፤ ይፋዋ ዙታምባሴ አሲን ችምፋ ሀኦስ» ይዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ኤሴ ኮኒታሳክቶኖ! ኤስ አብዲስ ዙታምባሴ እምቴናስ እኖክ ስንና ቦርአ አሻሶንናዋ አያናሶንና አሲን ኪንሱኒ ዉዛስን ቴትኒሶን ካይምሱኒዋ፤ ሀኦሶን ድጎክ ደይ ኮርቶ ስንኒሶን ቱማ ስናናክ ዛጉኒ። ");
INSERT INTO jnje_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ንብንትስን እኖትን ኤጳቶትዋ፤ እንኖ ኦኒንኑ ኣነ ሚርኦዌኒዋ፤ ኦኒንኑ ማጙሲ ኣነ ዞንሱዌኒ፤ ኦንክኑ ኤጳ እኖክ ኬአናክ ኣነ ዛጉዌኒ። ");
INSERT INTO jnje_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ኤስ ባሮን ይፋናስ ንቶስታ ማጝሱ ካርአናክታዋ፤ ዜሞ ስናክ ማኬናሲማቶ ንቶ እንኖ ንባስቱ ፋሴትዋ፤ ኤስ ባሪ ቦርኣ ካክ ስኑን ክቱክ ንቶስታን ኣፋ ኦር ኬሳኒ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ንቶስታ ፋ አማንቶናስ አካማዋ፤ ንቶስታ ቴቴፋና ቴቶስ እኛዋ፤ ንቶኪ ካሞቱ ችማ ዳንፋዉጝዋ፤ እኖስታ ካርፋ ሻና ዙታምባሴ አሲክ አካማኖንቱ ግሬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ሜቀዶንያ ሀምማ ካርፌኒ ካባሲክኑ ሾዎ ኡግናን ራክኮ እኖስታ ካርናስታኖ እሳ ቤይሳ ኣነ ዳነኒ፤ ጌሮክ ፋሶ ንብኒሲክ ደይ ድጋቱ እኖስታ ካርአር። ");
INSERT INTO jnje_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ስኑንታኖ ሱሜ ባሶትን ችኒፋ ሀኦስ ትቶኒ ዮሲክ እኖትን ችኒ። ");
INSERT INTO jnje_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ችምኒስ ባር ዬና ባር ባርክ ስኖይናማቶ ንቶ ባሪን ችኒት ባሮን ኦደኒ ቦርአኔጝዋ። ንቶ ታክ ሳፋሬት ፋሴት ካልታናሴዋ ሱሞሴ አሲን እኖክ ማኬና ካባሲክ ዳይስራ ግሬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","ዜሞ ስናክ ንቶክ ትችና ዎስያስ ንቶ ሱሞትክ ዛግር ስኒፋናክኑ ኤስ ዎሲያሶን ትቹናሲክ ኣፋ ጋቦና ዉዛ፤ ጋቤፋናክኑ ጋቤናስ ትችና ዎስያስ ንቶትን ጋሮ ዎን ኒሮን ሱሞትክ ዛግና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","ስኑንታኖ ሀሽ ግሬጝዋ፤ ኤስ ግሬናስ ንቶ ሱሞትክ ዛግና ቦርአ ስኖይናማቶ ሱሜቲ ሱሞሲክ ሀርሚት ቦርአዋ፤ ኤሴ ሱሞንትስ ሀኦሲ ፍቃድኒማቶ ስንና ቦርአ እንኖ እሳንነ ኣነ ንቶትን ሚርኦዌንዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","ሀኦሲ ፍቃድንማቶ ስና ሱሞስ ፋሩኒ ኡግናሲክ ዞንስፋ ሀርሙክ ቤስቴፋ ሶልቶሶን ቴሸፋና ቦርአ ኣነ ጋቢስፋዋ። ስኑንታኖ ሀን ዳስታኪ ሱሞስ ክቱቱ ኤጳ ያፋ። ");
INSERT INTO jnje_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ሀን ሱሞንትስ ሀኦሲ ፍቃድክ ስንባሲክ ኣካነ ፋ ማምሱኒ ዎልጉሶን፥ ኣካነ ፋ ችማሶን፥ ኣካነ ፋ ታእኒን ግቶሶን፥ ኣካነ ፋ ድጋሶን፥ ኣካነ ፋ ካልታናሶን፥ ኣካነ ፋ ኮናሶን፥ ኣካነ ፋ ኬኦ ንቶስታ ኤጳ ያናማቶ ጋሳሲራ ቢትዋ። ንቶ ደይ ዙታምባሴ አሲክ ኤስ ቾዋሲ ኣፍሴትዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","ኤስ ባሪ ቦርኣ አዉነ ፋሮንኑ ንቶክ ትችፋናክ ታ ንቶክ ትችናስ እንኖ ቾዋሲክ ፋ ችማስ ሀኦሲ ስና አምማ ስናናክዋ እያታኖ ሚርኤ አሱሲክናዋ ሚርአሜ አሱሲክና እያታዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ችማ ዳኒስታን ደናሎ ቲቶ ዳንና ግራሲክ ዳይስራ ግሬኒዋ፤ ኤስ ግሬኒስ ደይ ዙታምኒትሴ ቲቶኒን ችኒሴት ቦርአናዋ አያናባስ ቤይሳ ዳናናክ ዛግሴት ቦርአናዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","ንቶስታ ፋ ቴቶናሶን ትቶኒክ ማኬራ ፋናር። ንቶ ደይ ታ ኢቾናክ ኣነ ዛጉዌት። እንኖ ዎንና ዎንና ንቶክ ፉቶሶን ማኬት ፋኒር። ኤሲስ ደይ ንቶ ቾዋሶን ቲቶኒክ ማኬኒ ቴቶኒስ ፉቶ ስንባስ አርቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ዙታምኒትሴ አጃጃሜትር ስንትማቶናዋ፤ ድጋክ፥ ኮርኩክና ደይ ኤጳ ታትማቶና ቲቶ ያዳቴፌና ካባሲክ ንቶክ ፋ ኬሽታምባስ አካማ ስንዋ። ");
INSERT INTO jnje_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","ታ ደይ ዙታምባሴ አሲክ ንቶትን አማንቶክ ችምናሲክ ዳይስራ ግሬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","አይኒ ሜያነ! ሜቀዶንያክ ፋሴ ቤቴክርስታኒሲክቶክ ሀኦስ እምና ባሪ ኦትማሶን አሩሶትክ ሾሌፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","ባሶ ሾዎ ሻናክ ፋታንቴሴቴዋ። ስኑንታኖ ግራቤሲስ አካማዋ፤ አካማኖን ቱካም ስንነፌክኑ አካማ እማቱ እሜቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","ችሜቴስነ ፋሮንናዋ ባሶ ችማስታን ደናሎ ፍቃድቤሲሲክ እሜቴማቶ ታ ዛል ስንናናዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ዩዳክ ፌሴ ክርስታናኒ ሜያኖን አሪጋሱኒ ሁግና ካልኖይኒማቶ ማእስሬቱ ሺጵስቴ። ");
INSERT INTO jnje_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","ባሶ ዛግሴቴስ እንኖ ኦድኒ ባርስታን ደናሎዋ። ዜምሜ ቴትቤሲሶን ዳሚሲክ እሜቴ፤ ቱስሬ ደይ ሀኦሲ ፍቃድክ ቴትቤሲሶን እኖክ እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","ሀን ዎስቶሶን ዜምሜ ዎስቴስ ቲቶ ስንና ቦርአ ሀሽኑ ኤስ እምኒ ዎስቶኒትሶን ታሜ ኮእባስታ ካቱናክ ባሪን ሺጴኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","ንቶ አማንቶክ፥ ዎላክ፥ አሩክ፥ ችሜ ዎስቶክ፥ እኖክ ደይ ቤስሴት ኬሽታና ዙታምባሴ አሲ ደናሎ ስንት፤ ሀን እምኒ ዎስቶሲክ ደይ ደናሎ ስንትዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ኤሴ ሀን ባሮን ማኬፋናስ ንቶትን አጃጆናክታዋ። ስኑንታኖ ኦምኒ ሜያ እሜፌ እማሴዋ ንቶ እሜፌት እማሴ አሲን ሆስራ ንቶ ኬሽታናስ ፉቶ ስንባሶን አሩናክዋ እያትዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","ንቶ ዳምኒ የሱስ ክርስቶስኒ ኦትማሶን አሪሴትርዋ። ባር አዉነ ፋሮን ኦቱም ስኒፌናክ ባሳ ቱካም ስንናሲክ ንቶ ኦቱም ስናትክ ባር ንቶክ እያትዋ ቱካም ስኒ። ");
INSERT INTO jnje_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ኤስ ቾዋሲክ ንቶክ ማአር ስንና ታክ ቤስቴ ኪቶ ንቶክ እምፋዉጝዋ። ኣታ ዎጋሲክ እማ ኮእባ ስኖይናሮን ኤስ ባሮን ዜምሜ ዛጉክ ሾሌስ ንቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ኤስ ባሪ ቦርኣ አሱኒክ እማክ ሾሌት ሳፋራኒትስ ዎስቶታ ፌሻ ኮእባስታ ካርአናክ ንቶ ችምትስነ ፋሮን ኤስ ሳፋሬት ባሮን ሀሽ ዛጉት። ");
INSERT INTO jnje_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","አሱኒክ እማናክ ማአ ፍቃድባ ፋፋናነ ኤስ አሱሳ እማ ኦድቴራ ታስቴር ስናናስ ባሳ ሁግናስንነ ፋሮን እማናነታኖ ባርኪ ፎንቶሶን እምፌና ካባሲክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","ኤስ ባሮ ይፋናስ ንቶ ዙታምንትሴ እሳ ኪጤ ስናትክታኖ ንቶ እማክ ራካቴፌኒ ኦም ሜያ ቤይሳ ዳኖቶዋ እያታዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","ንቶ ራካቴፌት ካባሲክ ባሶ ኦትማስ ንቶ ራክኮሲክ አሪጋሱናክ ሀሽ ንቶ ኦትማስ ባሶ ራክኮሶን አሪጋሱኒር ስኑን፤ ኤስ ባርክ ንቶ ጋነያስ እሳ ኪጤ ስና ፎና። ");
INSERT INTO jnje_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ኤሲስ ደይ፦ «አካማኖን ዙት ባርክ ኣነ ፉእቶዋ፤ ጋሮኖን ዙት ባርክ ደይ ኣነ ዮኡዋ» ይስቴራ ትቼናሲማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","ታ ንቶክ ሳፋሬፋናስነ ፋሮን ቲቶ ደይ ንባስን ንቶክ ሳፋሮናክ ዛጊ ሀኦሲክ ጋላታ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ቲቶ ንቶኪ ዬናስ ባሳ ቴትኒ ፍቃድክ ግራክቱ ካብሬ ዬቴኖ እንኖ ባሪን ሺጴኒ ባር ባርክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ምስራቹኒ ካማሶን ማኮባሲክ ቤቴክርስታኒሲክቶ ዙታምባሴ አሲስ ጋላታምቶ አዪስን ባርኔን አነ ጋፍኩኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","ኤስ ባርስታን ደናሎ ኤስ አዪስ እንኖ ሀን ማአ ዎስቶሶን ዳሚሳ ኡልፍናክ ዎስቴራ ዛግፌኒ ካባሲክናዋ ዎስቶኒክ ፋ ማአ ፍቃድኒሶንና ማኬን እኖኔን አነ ሀምሜ ኤስ ዎስቶሲ አሪጋ ስናናክ ቤቴክርስታኒሲክቶስን ኮርቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ሀን አሱኒክ እምቶናክ ዙቴ ዋጋሶን ኤጳ ኩንስፌኒ ካባሲክ እሳ ዉዛክነ እንኖ ሀማቶኖይኒማቶ ቴትኒሶን ኦድትፌኒር። ");
INSERT INTO jnje_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","እንኖ አላማስ ዳሚሳ ስናክ ኮእባ ስኖይናሮን አሱኒ ሜኒ ስናክ ደይ ማአር ስና ዉዛሶን ዛጉዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ሾዎ ዎና ሾዎ ኡግናክ ፋታንቴሬ ችም ስንነ ቤስቴ አይኒስን ትቶኔን አነ ንቶኪ ዎስኒስ ኤስ ባሪ ቦርኣዋ፥ ባር ንቶስታ ፋ አማንቶባስ አካማ ስንና ቦርአ ሀሽ ሀን ዎስቶሶን አሪጋሱናክ ፋ ሳፋርባስ ዜሞቲስታን አካማዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ቲቶኒ ቾዋሶን አሩክ ሾልስፋናነ ንቶትን አሪጋሱናክ ታኔን አነ ዎስቴት ፌ ዎስቶኒ ዞሞታዋ፥ ባርኔን አነ ዮሶን ኦም አይኒ ሜኒ ቾዋሲክ ስንፋናነ ባሶ ቤቴክርስታኒሲክቶኒ ኤዴ ስንነ ክርስቶስኒ ኡልፍናሲክ የርሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","ኤስ ባሪ ቦርኣ ኬሽታንትሶን ባሶክ ቤሱቲ፤ ኤስ ባርክ ኬሽታኒትሴዋ ንቶስታ ፋ እንኖ ቴቶኒሴ ኬእኖር ስና ቤይባሶን ቤቴክርስታኒሲክቶ ዙታምባሴ አሲክ ቤሱትዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","ዩዳክ ፌሴ ክርስታናን ሜያክ ዛግቴፋ ዋግኒ ቾዋሲክ ንቶክ ትቹናክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","«አካያክ ፌሴ አሱኒ ሜያ ኣታ ዎጋስታን ካብግሬ አሪጋሱክ ሆሬሬ ፌሴቴርዋ» ይራ ሜቀዶንያክ አሱኒ ሜያክ ንቶ ቾዋሲክ ቴቴፋናስ ችምንትሶን አሪፋና ቦርአዋ። ንቶ ችማስ ኦም አሱኒ ሜያኖን እሞሶነክ ካብጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","ሀን ዉዛሲክ ንቶስታ ፋ እንኖ ቴቶስ ኬእኖር ስንና ፉእቶኖይናማቶ ሀን አይን ሜያኖን ንቶክ ዎሱናዋ። ንቶ ደይ ዜሞቲ ታ ማኬናሲማቶ ሆሬራ ኦዶቲ። ");
INSERT INTO jnje_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","ሜቀዶንያክ አሱኒ ሜያ ታኔን አነ ንቶክ ዬሴፌ ካባሲክ ሆሮኖይ ዲፌን ብየፋቴነ እንኖ ንቶስታ ቴቴፌን ቴቶሲክ ኢቼኒርዋ፥ ንቶኑ አካማኖንቱ ኢቾትዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","ኤስ ባሪ ቦርኣ እማትክ ማኬት ካምኒትሲማቶ ኤስ እማሶን ዜምማ ሆሱትክ ንቶትን ያዳሱሶነክ ሀን አይን ሜያ ታይስታን ዜምሜ ንቶክ ዮሶነ ባር ሾልሱ ስንና ታክ ቤስቴዋ። ኤስ ባርኪ ታ ያፋና ካባሲክ እማት እማስ ሆሬራ ፎና፤ ንቶ ደይ እማትስ ግድክ ስኖይናሮን ፍቃድንትሲክ ስኒባሶንቱ ቤስፋ። ");
INSERT INTO jnje_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","«ጋሮኖን ቡካ ባር ጋሮ ሜያቱ ዙትፌ፤ አካማኖን ቡካ ባር አካማ ሜያቱ ዙትፌ» ይስቴ ባሮን ያዳቶት። ");
INSERT INTO jnje_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ኤስ ባሪ ቦርኣ ሀኦ ሹንፋናስ ግራክ እምፌ ባሪን ስንና ቦርአ አስሱ እሳርባ እሳርባሲክ ንብባሲ እማናክ ሾሌና ባሮን ግራክ እሞቴኖ ኤክ ሀጝ ኡክ ወደይ ግድክ እማናታ። ");
INSERT INTO jnje_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ዎንና ዎንና ዉዛ ዙታምባሴ አሲክ ቴትንትሶን ችማ ማአ ዎስቶ ዙታምባሴ አሲስታ ፌሹ ችማትክ ሀኦስ ኤባባሶን አሪክስራ እማናክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","«ኤሲስ ደይ ቱካምኒ ሜያክ ጋራማክ እም፤ ኦኮባስ ደይ ኮእባ ፎንቶኖን ፎና» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","ቡክፌ ባርኪ ዛላ፤ ሙን ባርኪ ቱሻ እምፋ ሀኦሲ ቡካት ዛላሶን አሪክስራ ንቶክ እማናዋ፤ ጋራማክ እምት እማስ ጋናኖን ደይ አሪክሱና። ");
INSERT INTO jnje_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","ንቶ እሜቲ እማስ እኖክ ካሞ እምቶና አሱኒ ሜያ ዙቴሬ ሀኦሶን ጋላቶሶነክ ዎንና ዎንና እማትክ ሀኦሲ ዉዛ ዙታምቤሲሴ አሲክ ኦቱም ስንናትክ ዛጋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","ኤስ እምፌት እምኒ ዎስቶስ ክርስታናኒ ሜያኖን ራክኮስን ክሱባስታን ደናሎ አሱኒ ሜያ ሀኦሲክ አካማ ጋላታ እሞሶነክ ዛግርዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","ሀን ንቶ እምፌት እምኒ ዎስቶስ ክርስቶስኒ ምስራቹኒ ካማሲክ አጃጃሜራ አማናምቶ ስኒፋት ባሶክ ስኑን ኦሚሲክ እሜትማቶ ቤሱባሲክ ዙታምቤሲሴ ሀኦሶን ጋላቴሴድፌዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ባሶ ደይ ሀኦስ ንቶክ እምና አካማ ኦቱምባስታን ካብ ቾዋ ንቶትን ኬሽቴሴፌ ቦርአ ንቶክ ሺጵሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","አሱኒ ካማክ ዎሉምቶናክ ችምቶኖይ ባሪ እማሲክ ሀኦሲክ ጋላታ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","ታ ጳዉሎስ ንቶ ስና ፋና ካባሲክ ኢቼር ይስቴን። ስኑንታኖ ንቶስታን ዎክፋና ካባሲክ ኢቾኖር ይስቴን፤ ክርስቶስኒ ጋራማሲክናዋ ማኣሲክና ንቶትን ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","ንቶትን ሺጴፋናስ ንቶኪ ያፋና ካባሲክ ድጎኖይ ማኮናክ ታን ዛጉትክዋ፤ ስኑንታኖ አሽኒ ሳፋራክ ኩቲት ፋኒር ዛግሬ ሳፋርሴፌ እሳ እሳ አሱኒ ሜኒ ስናክ ድጎኖይ ማኮናክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","አዉነ ፋሮንኑ ሀን ዳስታክ ፋፌኒክ ኔቤፌኒ ኔቦስ ሀን ዳስታኪ ኔቦሲማቶታዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","ኤስ ኔቦኒ ሜኒስ ደይ ጎስማሶን ቦጋኒክ ሀኦኒ ሁግናባ ፋናርታኖ ሀን ዳስታኪ ኔቦኒ ሜያስነ ፋርታዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","ሀኦሶን አሩኒ ቾዋስታ ቱሳ ስንና ካብፋ ዌኑሴዋ ቤጋንቶሴ አስን ቦጋኒ፤ አሱሳ ሳፋራኖን ዙትራ ቦጀራ ክርስቶስኒክ አጃጃሞናክ ዛጉኒ። ");
INSERT INTO jnje_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","ንቶ አጃጃሞስ ቱማ ስንፋና ካባሲክ አጃጃሞ ቤያሶን ዙትራ ኬኡክ ሆሬር ሲናኒ። ");
INSERT INTO jnje_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","ንቶ ቢፌትስ ጌሮክ ቤስቴፋ ባሮን ኮእባዋ፤ ኦኑ ታ ክርስቶስኒር ይሬ ባሪክ አማነፋናነ ሄፕሳ ዎል ሌ ሳፋሮዎዋ። እንኖ ደይ ባሳይሲማቶ ክርስቶስኒር ስኒማቶ ያዳቶዎ። ");
INSERT INTO jnje_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ዳሚስ እኖክ እምና ሀእሱኒ ሁግናሲክ አካማኖን ቴቴፋናነ ኣፋዋ ኢቾናዉዛ። ሀን ሀእሱኒ ሁግናስ እኖክ እምቴናስ ንቶትን ችኑኒክታኖ ቦጋኒክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","ዎስናሲክ ንቶትን ዴሱናርነ ፋር ስንና ንቶክ ቤስቶናታዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","እሳ እሳ ሜያ፦ «ጳዉሎስኒ ዎስያሲክቶ ፋያ ደይ ችማዋ። ስኑንታኖ ባር ቴትባሲክ እኖኔን አነ ፌና ካባሲክ ሆፕ ዎሉምባስ ደይ ካሽስቶዋ» ይሴት ፌሴቴር ስናና። ");
INSERT INTO jnje_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","ኤስ ባሮን ይሴፌ አሱኒ ሜያ እንኖ ዎክሶክ ፋጌዶ ዎስያኒሲክ ማኬፌኒ ባሬዋ ታእሶኖን ንቶኔን አነ ፋጌዶ ዎስቴፌኒ ባሬ አሲ ጋነሲ ኦር ኦር ኬስባ ኣፋ ስኒባሶን ያዳትሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ስኑንታኖ ቴትቤሲሶን ጋላቴሴፌ እሳ እሳ አሱኒ ሜያኔን አነ ፋድቶኒክ ወደይ ሆሱኒክ ኣፋ ችማኒ ዉዛ። ስኑንታኖ ባሶ ቴትቤሲሶን ዎልግሬ ቴትቤሲስኔን አነ ማዛኖቤሲሲክናዋ ሆሱቤሲሲክና ባሶ ያዳትሴ አሱቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","ስኑንታኖ እንኖ ንቶክ ካርአንኔን ሀኦሲ እኖክ እምና ዎስቶስ ድላክቱ ቴቴፌንታኖ ቴቶኒክ ሾልስስታን ደናሎ ኣነ ቴቴፌን። ");
INSERT INTO jnje_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","ንቶ ደይ ፋትስ እንኖ ዎስቶኒ ድላስ ስንና ቦርአ ክርስቶስኒ ምስራቹኒ ካማሶን አሱክ ንቶክ ያፌን ካባሲክ ኤስ ድላስን ኣነ ኣታ ኬሴንዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ኤስ ባሪ ቦርኣ ሀኦሲ እኖክ ድለራ እምና ድላስታን ኣታ ኦምን ሜያ ዎስቴሴቴ ዎስቶሲክ ኣፋ ቴቶኒዉዛ፥ ኤስ ባርስታን አማንቶኒትስ ድቻናክናዋ እንኖ ዎስቶስ ደይ ሀኦሲ እኖክ ድለና ድላ ንቶ ጋነያስ ዳይስራ ታጉናክና አብድ ዛግድፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ኤሴ ኦም አሱሳ ዎስቶኒ ድላስ ግርራ ዜሞቲ ዎሱስቴ ዎስቶሲክ ቴቶኖይ ንቶስታን ኤካሎ ፋሴ ዳሲክቶሲ ምስራቹኒ ካማሶን ማኮ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","ስኑንታኖ፦ «ቴቴፌ ባር ዳሚሲክ ቴቶዎዋ»። ");
INSERT INTO jnje_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","ኤሲስ ደይ አስሱ ጋላታ ዳናናክ ችምፌናስ ዳሚስ ባሪን ጋላቴፌና ካባሲክታኖ አስሱ ባር ባሪን ዎልግሬ ጋላቴፌና ካባሲክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","ጋሮ ጎዋናሶን ታክ ፋኩሶትማቶ አብዲ ዛግፋዉጝዋ፤ አዳራዋ ታን ፋኩትዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","እሳ ዱርባ ናዋ ዱርቡማባሴ ፌን ቴጎሲክ ቴጌቴፋናይሲማቶ ታ ደይ ንቶትን ክርስቶስኒክ ቴጌራ ዱስና ቦርአ ንቶ ቾዋሲክ አያናኒ ኮና ኮነፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","ዛዋስ ማጙባሲክ ሄዋኖን ዳግሲናስማቶ ንቶ ሳፋራስ ደይ አዉዛክነ ማጝራ ክርስቶስኒክ ፋ ማአ ደይ ካይማ ስና አማናምቶኒትሶን ቤያትቶ እያት ድጌፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","እሳ አሱ ንቶኪ ዬሬ እንኖ ንቶክ ማኬኒ ባሮን ስኖይናሮን ኦም የሱስኒን ንቶክ ማኬፋናነ ወደይ ንቶ ኤጳ ታት አያናሶን ስኖይናሮን ኦማ አያና ኤጳ ታሴፋትነ ወደይ ኤጳ ታት ምስራቹኒ ካማሶን ስንኖይናሮን ኦማ ምስራቹኒ ካማ ኤጳ ታሴፋትነ ሻክራ ሜርቴትዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","ስኑንታኖ ታ ሀን እኝ እኝ ዎስኒ ሜኒ ጋነያስን እሳ ዉዛክነ ሀቴር ስንና ታክ ኣነ ቤስቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","ዎሉምኒ ቴችማሲክ አሩ ስና ቤይፋናክኑ አሩና ኣነ ሀቶዋ። ኤስ ባሮን ደይ ሾዎ ኡግናክ ንቶክ አምማኖን ክስራ ማኬኒዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","ታ ሀኦሲ ምስራቹኒ ካማሶን ዳሞዛ ታክ ካስቶኖይናሮን ንቶክ ማኮናሴዋ ንቶትን ቴጉናክ ታ ቴታሶን ሀቴሱናሴ አዉዛክነ ቦርአ ስንና ታይስታ ፋድቴታሶ? ");
INSERT INTO jnje_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","ንቶክ ዎስቶክ ኦማ ቤቴክርስታኒሲክቶኪን አሪጋሱኒ ዋጋ ኤጵናሲክ ባሶትን ቦኤጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ንቶኔን አነ ፋና ራክኮ ታይስታ ካርፋና ካባሲክ ሜቀዶኒያን ዬሴ አይኒ ሜያ ታክ ሾልሱ ስና ዉዛ ዙታምባሴ አሲክ አሪጋሲት ፌሴቴር ስንና ቦርአ ኦኒስታኑ ኣነ ባአ ስኑት። ሀሽ ሀውጙኔን ካርአ ንቶስታ እሳ ዉዛክነ ኣነ ባአ ስኑት። ሀንኔንኑ ደይ ንቶስታ ኣፋ ባአ ስናናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","ክርስቶስኒ ፉቶስ ታይሲ ፎባሲክ ቴቶኖይናማቶ ታን ዛጉንዉዛ አካያክ ዳስታክ ኦኑ ኣፌ። ");
INSERT INTO jnje_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","ኤስ ባር አዉኒ ቦርአንሶ? ንቶትን ሹና ቤይና ቦርአኖሶ? ንቶትን ሹንፋናማቶ ሀኦስ አሪፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","ኤሴ ኦም ዎስኒ ሜያ፦ «እንኖ ባሶሲማቶ ዎስቴኒር» ይት ቴቴሴፌ ቾዋሶን ትሽኩክ ሀሽቲ ዛግት ፋና ባሮን ሀንኔን ደይ ዛጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","ኤስ ኤፌቴና አሱኒ ሜያ ክርስቶስኒ ዎስኒ ሜያነ ፌር ስንነ ቤስቶክ ቴትቤሲሶን ሶልሴፌ ኤሽቱ ዎሲናዋ ኤሽሴፌ ዎስትኛኒ ሜያናዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ኤስ ባር ደይ ዲንቂሱኒ ዉዛታዋ፥ ሴጣናስኑ ቻሬፍኒ ዎስያ ስንና ቤስቶክ ቴትባሶን ሶለርዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ኤስ ባሪ ቦርኣ ሀን ሴጣናሲ ዎስትኛኒ ሜያ ኦኮ ዎስትኛኒ ሜያኖን ስንነ ቤስቶክ ቴትቤሲሶን ሶልሴፌክ ኣፋ ዲንቅስሱና ዉዛ ስናናዛ። ኮእባስታክ ዎስቶቤሲሲ ዋጋኖን ዳኖነ። ");
INSERT INTO jnje_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","«ኦኒክኑ ታ ጎዋነ ፌር ስንና ባርክ ቤስቶናታ» ይራ ሄፕሳ ደይ ማኬፋውጙዋ። ጎዋ ስንና ንቶክ ቤስቴፋናክኑ ጋሮኖን ቴቶናክ ጎዋነ ፌር ዛግራ ፋዱትዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","ኤሲስማቶ ቴቶክ ማኬፋና ካባሲክ ኤስ ማኬፋና ባር ዳሚሳ ፍቃድኒማቶ ስኖይናማቶ ጎዋነ ፌር ስንናዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","ሾዎኒ ሜያ አሽኒ ቾዋሲክ ቴቴሴፌ ቦርአ ታ ደይ ቴቴፋን። ");
INSERT INTO jnje_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","ንቶ ቴቹምኒት ፋናር ስኒትማቶ ጎዋኒ ሜያኖን ግራክ ፋኩቲ። ");
INSERT INTO jnje_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ኤሲስማቶ ኦኑ ንቶትን ቦዝኒማቶ ዛጋናነ፤ ኦኑ ንቶሶን ሜፋናነ፤ ኦኑ ንቶይሶን ባሳር ዛጋናነ፤ ኦኑ ንቶትን ካሽፋናነ፤ ኦኑ ጋችኒትሶን ቦቻናነ ፋክፌት። ");
INSERT INTO jnje_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","ታን ኢሹኒር ስንፋናክኑ ሀን ዉዛሲክቶኖን ዛጉክ ችም ስና ቤይንማቶ ንቶክ አምማኖን ማኮናዋ። ስኑንታኖ ኦኑ ችሜ ቴቶኒር ፌፋናነ ታ ደይ ባሳሲማቶ ችማ ቴቶናዋ። ኤስ ባሮን ይፋናስ ሀሽኑ ጎዋኒማቶ ስንናዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","ባሶ እብራዊኒ ሜያኖሶ? ታ ደይ እብራውዋ። ባሶ እስራኤልኒ ሜያኖሶ? ታ ደይ እስራኤላዊዋ፤ ባሶ አብራሀምኒ ዛላሲክኖሶ? ታ ደይ አብራሀምኒ ዛላስንዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","ባሶ ክርስቶስኒ ዎስትኛኖሶ? ታ ደይ ባሶስታን ደናሎ ክርስቶስኒ ዎስትኛዋ፤ ሀን ባሮን ማኬፋናስ ንፋሶነ ፌር ስንናዋ፤ ባሶስታን ደናሎ ሾዎ ዎና ዎስቶክ ሆፕን፥ ሾዎ ዎና ታቴን፥ ሾዎ ዎና ሱስቴን፥ ሾዎ ዎና ክቱታ ካርእን። ");
INSERT INTO jnje_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","አይሁድኒ ሜያ ኡቻ ዎል ሌ ኬዛስሬ እዝግነ ኬዛስሬ እዝግነኖን አላንጋክ ታን ሱስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","ኬዛ ዎላ ሃሮክ እቼን፤ እሳርጋ ሹአክ እቼን፤ ኬዛ ዎላ ማርካብኒ አዳጋ ታይስታ ካርእ፤ እሳ ዋልነዋ እሳ ዎንነ ባሪስታቱ ፋኒ። ");
INSERT INTO jnje_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","ኡጉንኒ ኩቱናሲ ኣታማታክ ዎርአ አካኒ አዳጋ ደይ ቦእኛኒ ሜኒ አዳጋ ታይስታ ካርእ። አይሁድ ስና ታ ኬኒሲክንናዋ አዛብኒ ሜያክንና አዳጋ ታይስታ ካርእ፤ ካታማስንናዋ ኢችማ ዳስ ሲንና ደይ ባርስታን አዳጋ ታይስታ ካርእ፤ ኤሲስማቶ ደይ ኤሽ አማኝኒ ሜያኪን አዳጋ ታይስታ ካርእ። ");
INSERT INTO jnje_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","ሾዎ ዎስቶነዋ ሆፕነ ታይስታ ፋር፤ ሾዎ ዎና አፋይኒ ቱርኪን፤ ማካክናዋ አካኒ እክታናክና ራካቴን፤ ሾዎ ዎና ሙ ቱርኪን፤ ኮቾነዋ አታቱ ኩቱነ ታይስታ ካርእ። ");
INSERT INTO jnje_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","ኦማሶኔን ዙትራ ፋዱኖይ ቤቴክርስታኒሲክቶ ዙታምባሴ አሲ ቾዋኖን ዎንና ዎንና ሳፋሮክ ራካቴት ፋናር። ");
INSERT INTO jnje_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","እሳ አሱ ሆፕፌና ካባሲክ ታ ደይ አነ ሆፑኖይና ዎና ኣጌንሶ? እሳ አሱ ቦርኣሲክ ቱሳኤፌና ካባሲክ ታ ደይ ሃሮኖይና ዎና ኣጌንሶ? ");
INSERT INTO jnje_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ቴቶክ ሾልሲር ስንፋናነ ታ ቴቶናስ ሆፕናሶን ቤስፋ ዉዛሲክቶክዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","ኮእባ ፎንቶኖን ጋላትባ ፋና ዳምኒ የሱስኒ አባ ሀኦሲ ታ ኣፋ ኤሻና ዉዛ ስንናማቶ አርፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","ደማስኮኒ ካታማስ ፋና ካባሲክ ታቶ አሬታስን ሀእሱኒ ስካሎስ ፌ አእሲኛሲ ታን ኤጴ ታርአናክ ሾሌፋት ካታማሲ ፍኛኖን ታሶኒ ሜያክ ኦድስት ፌር። ");
INSERT INTO jnje_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","ስኑንታኖ አሱኒ ሜያ ማሳሲ ዱስሬ ኦጃሲ ማስኮትሲ ካሞ ኬስሴቴን ኤስ አእሲኛሳ ኩሹስን ኣታ ኬስኒ። ");
INSERT INTO jnje_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","አዉነ ፋሮን ቴቶስ ኬአና ዉዝባ ትሽፋናክኑ ቴቶ ሾልስፋናነ ዳሚስ ታክ እምና አምማኖን ቤስና ዉዛሴዋ ራእሴ አሲክ ቴቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","ክርስቶስኒር ስንና እሳ አሱኒን አሪፋውጙዋ፥ ኤስ አሱስ አሲሬ አቼቼ ዎጋኔን ስናክ ኬሳ ሳማስታ ኦቴሬ ሀሜ ካርእ፥ (ኦቴሬ ሀምሚናስ ደይ አሽባስነንጝዋ ወደይ ኣነቶ? ኣነ አሩት፥ ሀኦስቱ አሪፋር።) ");
INSERT INTO jnje_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","ስኑንታኖ ኤስ አሱስ ኦቴሬ ሀምናማቶ አሪፋውጙዋ። አሽባስነንጝዋ ወደይ ኣነቶ? ኣነ አሩት፥ ሀኦስቱ አሪፋር። ");
INSERT INTO jnje_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","ባር ኦቴሬ ገነቲ ሀምሜ አሱኒ ካማክ ማክቶክናዋ አሱ ዎሎናክና ችምኖይና ዉዛሶን ኦደ። ");
INSERT INTO jnje_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","ኤስ ኤፌቴናስነ ፌ አሱሲክቱ ቴቶና፥ ስኑንታኖ ታ ቾዋሲክ ሆፕናስታን ኦማ ቴቶና ዉዝና ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","ኤካኒ ታ ፉቶሶን ማኬፋና ቦርአ ቴቶናክ ሾሌፋናነ ጎዋ ኣፋ ስንናናዉዛ። ስኑንታኖ ኦኑ ታይስታን ቢና ባርስታንናዋ ታኪን ደይ ኦደና ባርስታንና ደናሎኖን ግምት እምኖይናማቶዋ እያት ቴቶሶን ቤይፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","ሀን ታክ አምማኖን ኬሳ ቤስቴ እኛ እኛ ዉዛሲክቶታን ካብ ቾዋ ቴቴራ ጌእኖይናማቶ አሽናሶን ሴርኒማቶ ኬጅኒ ሻና ታክ እምቴ፥ ኤስ ባር ደይ ሴጣናሲ ዎሲያ ስንና ታን ኬጅጃ ራክስት ጌእኖይናማቶ ዛግፋ። ");
INSERT INTO jnje_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","ሀን ባር ታይስታን ካቡናክ ዳሚሲኪ ኬዛ ዎላ ሺጴን። ");
INSERT INTO jnje_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","ስኑንታኖ ባር፦ «ታ ሁግናስ ማእሲራ ነይስታ ዎስቶናስ ነ ሆፕያሲኪ ካሞ ስንና ቦርአ ኦቱምናስ ኔክ ሆሮናዋ» ይ። ኤስ ባሪ ቦርኣ ክርስቶስኒ ሁግናስ ታይሲ ፎናክ ኣጌኑ ስንፋናክ ሆፕናሲክ ግሬት ቴቶናክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ታ ሁግና ዳንፋናስ ሆፕፋና ካባሲክ ስንና ቦርአ ክርስቶስኒክዋ እያት ሆፕፋና ካባሲክ፥ ሜቸፋና ካባሲክ፥ ራካቴፋና ካባሲክ፤ ካቡግቴፋና ካባሲክ፤ ሻና ቢፋና ካባሲክናቱ ግሬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","ጎዋኒማቶ ስኒን! ኤካ ስናናክ ዛጊስ ንቶዋ፥ ባክ ስንፋናነ ታ ቾዋሲክ ማኮኒስ ንቶዋ፥ ታ ኦ ስንናማቶ አሪቶኖይ አሱ ስኒፋናክኑ አርቶ ይስቴ ዎስኒ ሜያስታን እሳ ዉዛክኑ ኣፋዋ ሀቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","ታ ፉቶኒ ዎሲ ስንናሶን አሲፋ ዉዛሲክቶ ማላቶሴዋ ዲንቂ ዉዛሲክቶነ ደይ ቢስቴራ አሪቶኖይ ዉዛሴ ታ ንቶ ጋነያሲ ፋና ካባሲክ ፋክያክ ዎስቴና ዎስቶሲክቶዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","ንቶስታ ባአ ስንኖይ ፎናስታኖ ኦማ ቤቴክርስታኒሲክቶስን ንቶትን አዉኪንሶ ሀቴስናሪ? ኤስ ባር ደይ ማጝሱ ስንና ቤስቴፋናነ ታክ ፌሹን ኡትዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","ንቶኪ ዮናክ ሆሬሬ ካቡናስ ሀኒስ ኬዝሳዋ። ታ ንቶስታ ባአ ስናናክ ኣነ ሾሌፋትዋ፥ ታ ንቶኪን ሾሌፋናስ ንቶትንታኖ ዋግንትሶንታዋ። ናንጎትቤሲሲክ ኦትማ ዙቱሶነክ ሾልስፋናስ ኮኒ አባስናዋ እንቶሴታኖ ናንጎታስ ኮኒ አባሲክናዋ እንቶሲክና ኦትማ ኣነ ዙትፋዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","ንቶ ቾዋሲክ ዋግናሶን ኮእባታዋ ቴትናሶንኑ ኣትራ እምፋናነ አካማኖንቱ ታን ግርስፋዋ፥ ኤካኒ ታ ኤፋሮን ንቶትን ሹናኔን ንቶ ታን ሹናትስ ኪስኩኖኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","ኤስ ባር ስኑን ሀን ባር ስኒፋናክ ታ ንቶስታ ባአ ኣነ ስኑትዋ፥ ኤካኒ ጃልሱክናዋ ኤሹክና ንቶትን አጃጀናርነ ፋር ስንናቱ ንቶክ ቤስቴፋ። ");
INSERT INTO jnje_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","ንቶኪ ዎስኒ አሱሳስን እሳይሲኪ ካሞኑ ኤጳ ታክ ኬእኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","ቲቶ ንቶኪ ዮናክ ሺጴጝዋ፥ ኤስ አይኒስን ደይ ባርኔን አነ ዎስኒ፥ ኤካን ቲቶ ንቶኪን ቦኤዎሶ? ታናዋ ባርንና ንቶኪ ዎስቴኒስ እሳ አያናሲክታኖሶ? ታሩኒስ ደይ እሳርታኖሶ? ");
INSERT INTO jnje_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","ንቶ ዙታምንትሴ ሀሽኔን ካርአ ሳፋሬት ፋሴትስ እንኖ ንቶ ስናክ እንኖ ቾዋሲክ ቴትኒሶን ኦዳክ ቱጋኤት ፋኒር ዛግራኖሶ? እንኖ ክርስቶስኒስ ፋፋት ማኬፌኒስ ሀኦሲ ስናክዋ። ኮኒታሳክቶኖ! እንኖ ሀን ባሮን ዙትራ ማኬት ፋኒስ ንቶትን ችኑኒክዋ እያትዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","ታ ንቶኪ ያፋና ካባሲክ አዉዛክነ ንቶ ታክ ስናትክ ሾሌፋናይስማቶ ስንኖይትሮን፥ ታ ደይ ንቶ ሾሌፌትይሲማቶ ስንኖይናሮን ኡጶኒቶ እያት ድጌፋዉጝዋ፥ ኤሲስማቶ ንቶኪክ ፋሶ፥ ኮና፥ ግእአ፥ ማጙክ ካቡ፥ አሱኒ ሱንኒ ማጝሱ፥ አሱኒን ሀማቶ፥ ቤጋንቶነዋ ሳስንነ ፎኒቶ እያት ድጌፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","ሄፕሳ ዎላ ንቶኪ ያፋና ካባሲክ ሀኦናስ አዉዛክነ ንቶ ስና ታን ሳልፕሱኒቶ እያት ድጌፋዉጝዋ፥ ዜሞ ስናክ ቦርአ ዎስቴሴሬ፥ ኤስ ዎስቴሴቴ ዝናሲክ፥ ጌርኬሴቴ ባርክ፥ ጋፎ ስኖቤሲሲክ ሀርሙ ቤያ አሱኒ ሜኒ ቦርአ ሱሞናትቶ እያቱ ድጌፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","ኤሴ ንቶኪ ሀኒስ ኬዝሳ ዎል ሌ ዮናዋ፥ ኣጌኑ ቾዋ ዙታምባሴ ፉቶ ስንናማቶ አሪቴፋናስ ሄፕ ወደይ ኬዝ ዛልንክዋ። ");
INSERT INTO jnje_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","ሄፕሳ ዎላ ንቶትን ብያናክ ያና ካባሲክ ቴትንትሶን ኦዳትክ ማኬራ ፋናር፥ ሀሽኑ ደይ ዎክሶክ ፋፋት ዜሞቲ ቦርአ ዎስቴ ባሶክናዋ ኦምን ሜያክና ቴትቤሲሶን ኦዶሶነክ ማኬፋውጙዋ፥ ሀሽ ንቶክ ዎላ ያፋና ካባሲክ ኦንክኑ ኣፋ ኬናሽቶና ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","ኤሲስ ደይ ታክ ካሞ ማኬፌስ ክርስቶስ ስኒባሶን ጋሳሱክ ሾሎንትሲክዋ። ባር ንቶ ጋነያሲ ሁግናባ ፌናርቴኖ ሆፕቴዋ። ");
INSERT INTO jnje_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","ባር ማስቃልስታ ሱቴሬ ክትናስ ሆፕያክ ስኒፋናክኑ ሀሽ ሀኦሲ ሁግናክ ሀየዉ ስንነ ፌዋ። እንኖ ደይ ባርኔን አነ ሆፕ ስኒዋ፤ ስኑንታኖ ንቶኔን አነ ፋ እሳርኒሲክ ባርኔን አነ ሃየዉ ስንና ፎኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","አማንቶኒትሲክ ዛግ ስኒትሶን አሩሶትክ ቴትንትሶን ቢትዋ፥ ቴትንትሶን ፋታኖት፥ የሱስ ክርስቶስ ንቶስ ፌናማቶ ኣነ ጋሳሱዌትኖሶ? ኤስ ባር ስንና ሻካናነ ፋታናሲክ ጋንደትዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","እንኖ ፋታናሲክ ጋንዶ ቤይንሶን ጋሳሱትማቶ አብድ ዛግፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","ማጙ ዉዛ ዛጉኖይትማቶ ሀኦሲክ ሺጴፌንዋ፥ ኤስ ሺጴፌኒስ ደይ አዉነ ፋሮን እንኖ ችም ስንና ቤስቶ ቤይፌንክኑ ንቶ ዎንና ዎንና ማአሪ ስንና ዉዛሶን ዛጉሶትክታኖ እንኖ ችም ስኒሶን ንቶክ ቤሱንክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","እንኖ ፉቶኒ ቾዋሲክቱ ዎስቴፌንታኖ ፉቶስኔን አነ እሳር ስኖይዉዛ ኣነ ዎስቴፌን። ");
INSERT INTO jnje_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","ስኑንታኖ እንኖ ሆፕ ስኒፋን ንቶ ችም ስንነፌት ካባሲክ ግሬፌንዋ፥ እንኖ ሺጶስ ንቶ ዮኡንቲ ፎንቶ ስንናትክዋ። ");
INSERT INTO jnje_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","ሀን ዎሲያሶን ንቶስታን ዎካ ፋጌዶ ትችናስ ኤስ ባሪ ቦርኣዋ፥ ኤስ ባርኪ ታ ንቶኪ ያፋና ካባሲክ ዳሚስ ታክ እማና ሀእሱኒ ሁግናሲክ ንቶትን ኣፋዋ ራክሱናዉዛ፥ ዳሚስ ሀእሱኒ ሁግና ታክ እምናስ ንቶትን ችኑናክታኖ ንቶትን ቦጋናክታዋ። ");
INSERT INTO jnje_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","ኮእባስታክ አይታሳክቶኖ! ማርኦጝዋ፤ ፋቲ ፎንትሶን ማእሱትዋ፥ ኪቶናሶን ኤጳቶት፥ ንቶትና ንቶትና እሳር ስንቲ፥ ናጋክ ደይ ፎሶቲ፥ ኬሽታን ሀኦሴዋ ናጋን ሀኦሴ ንቶኔን አነ ስናና። ");
INSERT INTO jnje_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","ኮርቶ ዳሞክ ዎል ዳሜሴት ናጋ ኦሾሶቲ፥ ");
INSERT INTO jnje_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","አማኝኒ ሜያ ዙቴሬ ናጋ ንቶክ ዎስሴቴ። ");
INSERT INTO jnje_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","ዳምኒ የሱስ ክርስቶስኒ ኦትማስ፥ ሀኦሲ ኬሽታና፥ ኮርቶ አያናስ እሳር ስንና ንቶ ዙታምንትስኔን አነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","አሱኒኪን ወደይ አሱኒኪ ካሞ ዎስቴ ዎስያክ ስኖይናሮን የሱስ ክርስቶስኒክንናዋ ባሪን ክቱን ካብግ አባ ሀኦስኪንና ዎሲ ስንነ ዎስቴ ታ ጳዉሎስኒኪን፤ ");
INSERT INTO jnje_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","ደይ ታኔን አነ ፌሴ አይኒ ሜያ ዙታምቤሲሴ አሲስኪን ጋላትያክ ፋሴ ቤቴክርስታኒሲክቶክ ዎስቴ ናጋ፥ ");
INSERT INTO jnje_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","አባኒ ስና ሀኦኒስኪን ዳም የሱስ ክርስቶስኒኪን ሀኦሲ ኦትምነዋ ናጋነ ንቶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","ሀን ማጙ ነያሲን እኖትን ፉኦናክ ሀኦኒሲ ፍቃዲኒማቶናዋ አባኒሳ ፍቃድኒማቶና የሱስ ክርስቶስ ሾዎ ቦርኒሲክ ቴትባሶን ኣትሬ እሚ። ");
INSERT INTO jnje_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ኮእባኔን ኮእባ ፎንቶኖን አባ ሀኦሲክ ኡልፍና ስንፋውጝዋ! ኣሚን። ");
INSERT INTO jnje_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","ክርስቶስኒ ኦትማሲክ ንቶትን ቴጌ ሀኦስኪን ኤካ ታፕቴራ ኦር ኬስኒትሴዋ ኦማ ምስራቹኒ ካማሲክ ዎሉንቲሴ ታን ዲንቅስሲዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ኤስ ባሮን ይናስ ንቶትን ዳግስሴሬናዋ ክርስቶስኒ ምስራቹኒ ካማሶን ኤልጝሱክ ሾልሴፌ እሳ እሳ ሜያ ፌሴቴር ስንና ቦርአታኖ ኦማ ምስራቹኒ ካማ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ስኑንታኖ እንኖኑ ስንፌኒክ ወደይ ሳማኪ ሀኦሲ ዎስያኑ ስንፋናክ እንኖ ማኬኒ ምስራቹኒ ካማስታን ኦማ ምስራቹኒ ካማ ንቶክ ማኬፋናነ ኤርዉቶ ስኖዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","ዜሞ ስናክ ማኬናሲማቶ ሀሽ ደይ ሄፕሳ ማኬፋውጙዋ፤ ንቶ ኤጳ ታሴት ምስራቹኒ ካማስታን ኦማ ምስራቹኒ ካማ ኦኑ ንቶክ ማኬፋናነ ኤርዉቶ ስኖዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ኤካን ታ፤ ሾሌፋናስ አሱ ታን ጋላቶናኮሶ? ወደይ ሀኦሲ ታን ጋላቶናኮሶ? ወደይ አሱኒን ግርሱናክ ሾሌናር ስንና ንቶክ ቤስቴዎሶ? አሱኒ ሜያኖን ግርሱናክ ሾሌት ፋናር ስንናፋናነ ክርስቶስኒ ዎስትኛ ስና ቤያና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","አይታሳክቶኖ! ታ፤ ንቶክ ማኬና ምስራቹኒ ካማስ አሱኒኪን ቤስቴር ስና ቤይናማቶ አሪሶትክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","ሀን ምስራቹኒ ካማሶን የሱስ ክርስቶስቱ ታክ አምማኖን ክስሬ ቤስትቴኖ ኣፌ አሱኒክኑ ኣነ ኤጱት ወደይ ኣፌ አሱኑ ታን ኣነ አስሱዌዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","ዜሞ አይሁድኒ አማንቶሲክ ዞኑስቴፋና ካባሲክ ኣካክ ፋናማቶ ንቶ ኦደሴትዋ፥ ሀኦሲ ቤቴክርታኒሶን አካማኖን ካብግራ ትሽኩናክ ካቤት ፋናርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","አይሁድኒ አማንቶሶን ኦዳክ ኤስ ነያሲክ ፌሴ አይሁድኒ ሜያ ዙታምቤሲሴ አሲስታን ታ፤ ደናሎዋ፤ አባን ሜኒ ዱቢዮሲክ ደይ አካማኖን ኮነት ፋናርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","ስኑንታኖ ኮንቶናስኔን ዜምማ ሀኦስ ታን ኮሪዋ፤ ኦቱምባሲክ ደይ ታን ቴጌዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","አዛብኒ ሜያክ ናሳ ቾዋኒ ምስራቹኒ ካማሶን ማኮናክ ሀኦስ ናባስን ታክ አምማኖን ቤሱናክ ቡግና ካባሲክ ጌሬጌሬ ኦኔንኑ ኣነ ሜርኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","ወደይ ታይስታን ዜምሜ ዎሲ ስና ባሶትን ኡጶናክ የሩሳሌም ኣነ ሀሙትዋ። ስኑንታኖ ዜምማ አራባኒ ሜኒ ዳቱ ሀሚንዋ። ሄፕሳ ደይ ደማስኮ ዎልንዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","ቱስራ ደይ ኬዝ ዎጋኔን ኦርፎ ኬፋ ይስቴፌ ጴጥሮስኒን ብያናክ የሩሳሌም ሀሚንዋ። ኤስታክ ደይ ባርኔን አነ አሲሬ ኡቼ ዎና ዲንዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","ዳሚሳ አይ ያቆብንንቱ ቢንታኖ ኦም ዎሲኒ ሜያስን ኦኒንኑ ኣነ ብዩትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ሀን ታ፤ ንቶክ ትችፋና ባር ኤሻ ስና ቤይባሶን ሀኦሲ ስና ንቶክ ችኒራ ማኬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","ኤሴን ኦርፎ ሶርያኒ ዳስታናዋ ቅልቅያኒ ዳስታናቱ ሀሚንዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","ዩዳኒ ዳስታክ ፋሴ ክርስቶስኒ ቤቴክርስታኒሲክቶ ታኔን አነ ኣፌ ኣፌ ቢሬ ኣነ አሪሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","ባሶ ኦደሴቴስ፦ «ኤስ ዜሞቲ እኖትን ካብግት ፌ አሱስ ኤስ ትሽኩናክ ካብና አማንቶሶን ሀሽ ዎል ሌ ማኬድፌዋ» ይፋ ካማሶን ኮእባዋ። ");
INSERT INTO jnje_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","ታ፤ ቦርአ ሀኦሶን ጋላቴሴት ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","አሲሬ አቼቼ ዎጋኔን ኦርፎ ባርናባስኔን አነ ሄፕሳ ዎላ የሩሳሌም ሀሚንዋ። ቲቶኒን ደይ ኤጳቱ ሀሚን። ");
INSERT INTO jnje_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","ሀምናስ ደይ ሀኦስ ታክ አምማኖን ቤስንናማቶዋ። ዜሞ ስናክ ዎስቴና ባር ስኑን ሀሽቲ ዎስቶና ባር ኬእኖር ስንና ፉእቶኖይናማቶ ኡክ አዛብኒ ሜያክ ምስራቹኒ ካማሶን አካም አካም ዞንስኒ ሜያክ ማኬንዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","ታኔን አነ ፌ ቲቶ አዉነ ፋሮንኑ ግሪክኒ ዳኒ አሱ ስንፌናክ ሃርኮ ኩናናክ ኣነ ግድሲስቶዌ። ");
INSERT INTO jnje_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","ስኑንታኖ እንኖ ጋነያሲ ኣቾክ አትቴ ግሪ እሳ እሳ ኤሽኛ አይኒ ሜያ ክርስቶስኒስታ ፋ ብርማዱምማኒሶን ኣፎክናዋ ቦዞስሲ ዎልጉክና ሳፋሬሴፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","ስኑንታኖ እንኖ ምስራቹኒ ካማሲ ፉቶ ንቶስሲ ዛግራ ፎጝዋ እያት ጋሮ ካባኖንኑ ባሶክ ኣነ ኩሹ እሜኒዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","ስኑንታኖ ኤስ ዞንሲ ስንነቴማቶ አርቶ ሜያክ ሀኦስ አሱኒ ስና ቢራ ኣነ ማጝሱ ኮሪፋ ስንና ቦርአ ባሶ ቾዋሲክ ግድና ኣፋዋ፤ ኤስ ዞንስኒ ሜያ ይስቴ ባሶ ታክ እሳ ዉዛ ኣነ ዳይሱሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","ኤሲስማቶ ሀኦስ ጴጥሮስኒን አይሁድኒ ሜያክ ምስራቹኒ ካማሶን ማኮናክ ዎስቴናሲናስኔፋሮን ታን ደይ ምስራቹኒ ካማሶን አዛብኒ ሜያክ ማኮናክ ዎስናማቶ ያዳቴንዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","ኤስ ባሪ ቦርኣ ጴጥሮስ አይሁድኒ ሜኒ ዎሲ ስንነ ዎስቶናክ ዛግ ሀኦስ ታን ደይ አዛብኒ ሜኒ ዎሲ ስንና ዎስቶናክ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ዬቶ ስንነ አሪቴሴፌ ዞንስኒ ሜያ ያቆብ፥ ጴጥሮስናዋ ዮሀኒስና ሀኦስ ኦቱምባሲክ ሀን ኦማ ዎስቶኒ እጣ ታክ እምቴናማቶ አርሴቴይሴ ታክናዋ ባርናባስኒክና እሳር ስንቤሲሶን ቤስፋ ማላቶ ስና ሆእታ ኩሹቤሲሶን እኖክ እሜቴዋ። እንኖ አዛብኒ ሜያኪ ሀማኒክ፤ ባሶ ደይ አይሁድኒ ሜያኪ ሀሞነክ ማእ ይሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ባሶ ጋነያሲ ፌሴ ቱካምኒ ሜያኖን ያዳቶኒክ አዳራ ይሴቴዋ፤ ኤስ ባር ደይ ታ፤ ሾሌፋና ዉዛስዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ጴጥሮስ አንሶኪያ ዬፌና ካባሲክ አምማኖን ዳጌሬ ፌር ስንና ቦርአ ስነ ስነ ኡጰራ ባሪን ኬእንዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","ያቆብንኪን እሳ እሳ አሱኒ ሜያ አንሶኪያ ዮሶኖይ ፌሴቴን ዜምማ አዛብኒ ሜኒ ጋነያስን አማነ ባሶኔን አነ ሜት ኡሼት ፌር፤ ስኑንታኖ ባሶ ዬሴቴኔን ኦርፎ «አዛብኒ ሜኒ ኬን ስነፋት አማነ ባሶ ሃርኮ ኩኑሶነክ ሾልሱዋ» ይሴፌ ባሶትን ድጌፋት ኦርፎ ዎል ሌ አዛብኒ ሜያስታን ኦር ኬሲ። ");
INSERT INTO jnje_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","ኦም አይሁድኒ ሜኒ ኬን ስና ክርስታናኒ ሜያ ጴጥሮስ ታነ ፌር ኣፌ ኡስኔን እሳር ስነቴዋ፤ ባርናባስኑ ፉእቶኖይናሮን ታነ ፌ አሱ ኣፌ ኡሲ ግሪሬ ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","ባሶ ዎስቶስ ምስራቹኒ ካማሲ ፉቶኔን እሳር ስንና ቤይባሶን ቢናይሴ ጴጥሮስኒን፦ «ነ፤ አይሁድኒ ሜኒ ኬን ስንና ፋጌዶ አዛብኒ ሜኒ ስትሪሲክ ፋታርዋ፤ ኤካን አዛብኒ ሜያ አይሁድኒ ሜኒ ስትሪሲክ ፎሶነክ አዉኒሮን ግድሲሲፋስሶ?» ይራ ዙታምቤሲሴ አሲ ስና ኬእንዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","ፉቶሲክ እንኖ ኮንቶኒሲክ አይሁድዋ፤ እንኖ ቦርእኒ ሜያ ስና አዛብኒ ሜያቴዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","ስኑንታኖ አሱ ኦኮ ስንፌናስ የሱስ ክርስቶስኒን አማኖክታኖ ቱማሶን ዛጉክ ስኖይናማቶ አሪፌኒዋ፤ እንኖ ደይ ቱማሶን ዛጉክ ስኖይናሮን ክርስቶስኒክ አማነራ ኦኮ ስናኒክቱ የሱስ ክርስቶስኒን አማነኒዋ። ኦኑ ቱማሶን ዛጉክ ኦኮ ኣፋ ስንናናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","ክርስቶስኒክ ኦኮ ስናኒክ ሾልሲናኔን እንኖ ቴትኒሲክ ቦርእኛ ስንኒሶንቱ ቤስፋዋ፤ ኤካን ክርስቶስ ቦርኣሲክ ዎስትኛኖሶ? እሳንነ እንዳነዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","ታ፤ ቴትናሲክ ቦግና ቱማስ ስትሪኖን ዎልግራ ኬርአናር ስንፋናነ ታ፤ ዎል ላ ቴትናሲክ ቱማሶን ቦጋ አሱ ስንጝዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","ሀኦሲክ ፎናክ ቱማስኪ ካሞ ክትራ ቱማስታን ኦር ኬስጝዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ታ፤ ክርስቶስኔን አነ ሱቴናርነ ፋር ዛግራ ፋድኒ ስንና ቦርአ ሀንኔን ኤካሎክ ክርስቶስ ታይስቱ ፎናታኖ ታ፤ ታ ቴትኒ ካክ ፎናርታዋ። ሀሽ አሻክ ፋና ካስ ታን ሹና ባርኪናዋ ታክዋ እያት ቴትባሶን ኣትሬ እማ ሀኦሲ ናኒክና አማኖክ ቤስቴፋ ካሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ሀኦሲ ኦትማኖን ኬእኖር ዛግራ ኣፋ ሀኡናዉዛ፤ አሱ ኦኮ ስንፌናስ ቱማሶን ዛጉክ ስንፋናነ ክርስቶስኒ ክቱስ ኬእኖር ስኒዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","ንቶ ጎዋ ጋላትያኪ አሱኒ ሜያነ! ኦንሶ ንቶስታ ቶልፋታ ዎስቴሪ? ዜሞ ስናክ የሱስ ክርስቶስ ሜስቀሊስታ ሱቴሬ ስኒትስታ አምማኖን ቤስቴት ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ንቶኪን አሩናክ ሾሌናስ ኤስ ባሮን ኮእባዋ። ሻካፎታ፤ ኮርቶ አያናሶን ኤጳ ታሴቲስ ቱማሶን ዛጉክጝዋ ወደይ ምስራቹኒ ካማሶን ኦዴሬ አማኖኪንሶ? ");
INSERT INTO jnje_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","ንቶ ሀኦሲ አያናክ ጃማሬፋት ሀሽ አሽኒ ካቦክ ኮእሱቲክ ሾልሴትዋ። ንቶ ኤስታኔን ካርአ ጎዎዋዋ! ");
INSERT INTO jnje_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","ምስራቹኒ ካማሲ ቦርአ ኤጳ ታሴቲ ሻና ዙታምባሴ ኬእኖር ስንና ፉእቴ ኡኖሶ? አሻክ ዛግሴት ስንፋናነ ፉቶሲክቱ ኬእኖር ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","ሀኦስ አያናባሶን ንቶክ እምናሴዋ ንቶኪክ ደይ ቢስቴራ አሪቶኖይ ዉዛ ዛግቴናስ ቱማሶን ኦደሴቲ ቦርአኖሶ? ወደይ ምስራቹኒ ካማሶን ኦደራ አማነሴት ቦርአኖሶ? ");
INSERT INTO jnje_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","ኤሴ አብራሀምኒን ቢትዋ፦ «ሀኦሲክ አማነ፤ አማንቶባስ ደይ ኦኮ ስንና ባሪክ ፋድቴዋ» ይስቴራ ትቼናስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","አማነፌ ባሶ ዙቴሬ አብራሀምኒ ናንጎትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","ሀኦስ አዛብኒ ሜያኖን አማንቶክ ኦኮ ዛጉናማቶ ኮርቶ ማፃፋስሲ ዜምማ ብያት፦ «ዳራስ ዙቴሬ ኔኪ ካሞቱ ኤቢስቶሶነዋ» ኡክ ዜምማ አብራሀምኒክ ምስራቹኒ ካማሶን ኦድሲዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","ኤስ ባሪ ቦርኣ አማነፌ ባሶ ዙቴሬ አማነ አብራሀምኔን አነ ኤቢስቶሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","«ቱማስ ትቼና ማፃፋስሲ ፋ አጃጅ ዙታምባሴ አሲን ኦዳክ ፎኖይ ባርናዋ ዎስቶታ ፌሹኖይ ባርና ኤርዉቶዋ» ይስቴራ ትቼና ቦርአ ቱማሶን ኦዳክ ኦኮ ሲናኒ ይሴፌ ባሶ ዙቴሬ ኤርዉቶዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","«ስኑንታኖ ኦኮስ አማንቶክቱ ካ ዳናናዋ» ይስቴራ ትቼናሲማቶ ቱማሶን ኦዳክ ኣፌ አሱኑ ሀኦሲ ስና ኦኮ ስና ኣፋ ችማናዉዛ ስንባስ አማዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","ቱማስ አማንቶስታ ካፑቴራ ዬሬርታዋ። ኤሲስማቶ ደይ፦ «አሱ ቱማሲክ ፎ ችማናስ ቱማሲ አጃጅኒክቶኖን ዙትሬ ዛግፋናነዋ» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","«እኦስታ ሱቴሬ ክትፌ አሱ ዙቴሬ ኤርዉቶዋ» ይስቴራ ትቼና ቦርአ ክርስቶስ እኖክ ኤርዉቶ አሱኒማቶ ስንነ ቱማስ እኖስታ ኤጳ ዮና ኤርውያስን ፉሬዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","ኤስ ባር ደይ ስንናስ ሀኦስ አብራሀምኒክ እምና ኤባስ ክርስቶስ የሱስኒኪ ካሞ አዛብኒ ሜያክ ካርአናክዋ፤ ኤሲስ ደይ እንኖ ሀኦስ ንቶክ እማናዋ ይና ኮርቶ አያናሶን አማንቶክ ኤጳቶኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","አይታሳክቶኖ! ኤሴ ሀን ዉዛሶን አሱ ዶስቴና ዉዛስኔን አነ ሆሱትዋ፥ እሳ አሱ ግሪና ቴያኒ ካማስኑ ዎሉምቴራ ቡድናኔን ኦርፎ ኦኑ ሻሮናክ ወደይ ዳይሱናክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","ሀኦስ አብራሀምኒክናዋ ባሳ ዛላሲክቶክና አብድኒ ካማ እምናስ ሀኒሲማቶዋ፤ ማፃፋስሲ አብድኒ ካማስ አብራሀምኔን ኦርፎ እምቴናስ ሾዎኒ ሜያክ ስንናማቶ ዛግራ «ዛልኔሲክቶክ» ኣነ ይፋዋ፥ ስኑንታኖ እሳሪክ ስንናሪማቶ ዛግራ «ዛልኔሲክቱ» ይፋዋ፥ ኤስ «ዛልኔስ» ይስቴ ባር ክርስቶስዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","ኤሴ ታ፤ ማኬፋናስ ኤሲሶጝዋ፥ አቼች ትሬ ኬዛስሬ ዎጋኔን ኦርፎ ዜምማ ሀኦስ እምና ቴያኒ ካማሶን ሻሮክ አብድን ካማሶን ትሽኩናክ ኣፋ ችማናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","ርስት ዋራስቴፋናስ ቱማስኪ ካሞ ስኒ ስንፋናነ ሀኦስ እምና አብድኒ ካማስኪ ካሞ ስንባስ ፌሻና ካባዋ። ስኑንታኖ ሀኦስ አብራሀም ዋራሶናክ ዛግናስ አብድኒ ካማስኪ ካሞዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","ኤካን ቱማስ እምቴናስ አዉኒ ቦርአንሶ? ቱማ ዳይስቴናስ አብራሀምኒክ አብድኒ ካማክ እምቴናስ ዛላስ ዮና ካባኔን ማጙ ዎስቶስ አዉ ስንናማቶ ቤሱናክዋ። ቱማስ ሀኦኒ ዎስያኪ ካሞ እምቴን ዎስቶታ ፌሽናስ ጋነያሲ ፌ እሳ አሱኒኪ ካሞዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","ስኑንታኖ ጋነያስታ ፌ ባር ሄፖቤሲሴ አስክታኖ እሳይሲክ ኮእባ ኣነ ዎስቴፌዋ። ስኑንታኖ ሀኦስ እሳርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","ኤሴ ቱማስ ሀኦሲ አብድኒ ካማኖን ቱጋኤሮሶ? እሳንነ ኣነ ቱጋኤፋዋ! ካ እምፋ ቱማ እምቴ ስንፋናነ ኦኮ ስናስ ቱማሲኪ ካሞ ቤስቶና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","ስኑንታኖ የሱስ ክርስቶስኒን አማንቶክ ቤስቴፋ አብድኒ ካማሶን አማነሴፌ ባሶክ እምቶናክ ኮርቶ ማፃፋስ ማኬፋናይስማቶ ሀን ዳ ዙታምባሴ ቦርአክ ሀእኡክ ቦርኣሲክ ታቴራ ፋር ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","አማንቶስ ዮኖይፌን ዜምማ ቱማሲ ትሾሲ ኦድቴራ ፋኒርዋ፤ ኤስ ባር ደይ አማንቶስ ዮና ካባኔን ቱማሲ ኦድኒ ስካሎስቱ ፋኒዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","ኤስ ባሪ ቦርኣቱ አማንቶክ ኦኮ ስናኒክ ክርስቶስ ዮና ካባኔን እንኖ ቱማሲክ ዞኑስቴት ፋኒዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","ስኑንታኖ ሀሽ አማንቶስ ያና ቦርአ ቱማሲ ኦድኒ ስካሎሲ ፎኒስ ፌሽዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","ክርስቶስ የሱስኒክ አማኖክ ንቶ ዙታምኒትሴ ሀኦኒ ናንጎታዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ሀጱክቶክ ክርስቶስኔን አነ እሳር ስና ንቶ ዙታምንትሴ ክርስቶስኒን ማማ ዛግራ ማይትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ዙታምኒትሴ ክርስቶስ የሱስኒክ እሳር ስነት ቦርአ አይሁድኒ ሜኒ ጋነያስናዋ ግሪክኒ ሜኒ ጋነያስና፥ ቦዝኒ ሜኒ ጋነያስናዋ ብርማዱማቤሲ ፌና አሱኒ ሜኒ ጋነያስና ደይ ኣርቃሱናዋ ማሽካሱኔ አሲ ጋነያሲ እሳንነ ኦር ኦር ኬስባ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","ኤሴ ክርስቶስኒር ስንፋትነ ንቶ አብራሀምኒ ዛላዋ፥ አብድኒ ካማሲማቶ ደይ ዋራሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ሀሽኑ ታ ንቶክ ማኮናስ ሀኒስዋ፥ ዋራሶኒ ባር ዳግ ና ስንነ ፌና ካባሲክ ኦትማ ዙታምባሴ አሲ አባ ስንፌናክኑ ቦዝ ስንናስታን እሳንነ ኣነ ኦር ኬሴዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","ስኑንታኖ አባባስ ባርክ ዱስና ዎናስ ዮና ካባኔን ኦድኒ ባሶ ስካሎስናዋ ባሪን ማስፌ ባሶ ስካሎሲቱ ፎናዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","ኤሲስማቶ እንኖ አያናኒ ቾዋሲክ ዳጋ ናንጎታነ ፌር ስንና ፋኒ ካባሲክ ሀን ዳስታኪ ፎኒ ስትሪሲክ ሀኡክ ቦዝ ስንና ፋኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","ስኑንታኖ ኤስ ማክቴ ነያስ ያራ ካርእባሴ ሀኦስ ናዉባስን እኖክ ዎሲ፥ ባር ደይ ማሽካሱስኪንቱ ኮንቴዋ፥ ደይ ቱማሲ ስካሎሲ ኮንቴ። ");
INSERT INTO jnje_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","ኤስ ባሮን ዛግናስ ቱማሲ ስካሎስ ፌሴ ባሶትን ፉሮናክናዋ እኖትን ደይ ሀኦኒ ናንጎታ ስናኒክ ዛጉናክናዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","ሀኦኒ ናንጎታ ስንኒሲክ ሀኦሶን «ኣባ! ኣባ!» ይት ቴጌፋ ናዉባሳ አያናኖን እንኖ ንብባሲ ዎሲ። ");
INSERT INTO jnje_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ኤስ ባሪ ቦርኣ ሀንኔን ኤካሎክ ነ ናቴኖ ቦዝቴዋ። ባሪ ና ስንታንኔን ሀኦሲር ሲና ባሮን ዙትራ ዋራሴታርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","ዜሞ ስናክ ሀኦሶን አሩ ቤየቲ ቦርአ አማላባሲክ ሀኦ ስኖይ ባሪክ ቦዛ ስንና ሀእት ፋሴትርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","ስኑንታኖ ሀሽ ሀኦሶን አርሴትዋ፥ ኤስ ባርስታን ደናሎ ደይ ሀኦስ ንቶትን አሪዋ። ኤካን ኤስ ሆፕያሲኪናዋ ኬእኖይ ሀን ዳስታኪ ስትሪሲኪና ኣካክ ዎልሴትሶ? ኣካክ ሄፕሳ ዎላ ባርኪቶኒ ቦዛ ስናትክ ሾልሴፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","ኮርቴራ ኬሳ ዎናሲክቶክኔዋ አሳሲክቶክኔ ደይ ዎጋሲ ባግቶክናዋ ዎጋሲክቶኖንና ኦዳክ፤ ፎንቶ ኡልፍንኔ እሜፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","ንቶ ጋነያሲ ዎስቶክ ሆፕና ሆፕናስ ዙቴራ ኬእኖር ስንና ፉእቶኒቶ እያት ድጌፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","አይኒ ሜያነ! ታ ንቶነ ፌር ስንና ቦርአ ንቶ ደይ ታነ ፌር ስንትዋ ይራ ሺጴፋዉጙዋ። ንቶ ታን እሳንነ ኣነ ሚርእኦዌትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","ቴሱኒ ካባስታክ ምስራቹኒ ካማሶን ንቶክ ማኮናክ ችምናስ ሜቴራ ፋና ካባሲክ ስንናማቶ አርሴድፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","አዉነ ፋሮን ሜሮናስ ንቶስታ ፋታና ስንፋናክኑ ኣነ ታን ካሽሹዌትዋ፥ ወደይ ኣነ ታን ኦምቶዌትዋ። ኤስ ባርስታን ሀኦሲ ዎሲያኖን ኤጳ ታፌትስነ ፋሮንቱ ታን ኤጳ ታሴትዋ። ኤሲስማቶ ክርስቶስ የሱስኒን ኤጳ ታሴትማቶ ታን ደይ ኤጳ ታሴትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","ዜሞ ስናቲ ፋ ግራንቲስ ዙቴራ አይንሶ ሀምናሪ? ንቶክ ችምቴፋናነ ኣፍንትሲክቶኖንኑ ክስራ ታክ እማትክ ፋትማቶ ታ ቴትናሲክ ዛላ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","ኤካን ሀሽ ፉቶሶን ንቶክ ማኬና ቦርአ ጉማ ስንና ንቶክ ቤስቴኖሶ? ");
INSERT INTO jnje_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","ኦም አሱኒ ሜያ ንቶ ቾዋሲክ ራካቴሴሬ ሳፋርሴቴርዋ፥ ስኑንታኖ ኤስ ባሮን ዛግሴፌስ ማአሪክታዋ፤ ባሶ ሾልሴፌስ ንቶ እኖስታን ኦር ኬሳትክናዋ ባሶክ ማእስራ ሳፋሮትክናዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","አላማባስ ማእኒር ስንፋናነ ማአሪዋ፥ ስኑንታኖ ሀን ችምኒትስ ታ ንቶኔን አነ ፋና ካባሲክ ኮእባ ስንናናታዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ናንጎትናሴ! ክርስቶስ ንቶ ፎስሲ አምማኖን ኬሴ ቤስቶና ካባኔን ንቶ ቾዋሲክ ታን ሄፕሳ ዎላ ኮጶኒ ኬክቶስታቱ ፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","ዜሞቲስታን ኦማ ኡግናክ ሀሽ ንቶ ጋነያሲ ፋራ ዎል ሌፋናነ ኣካ ሹናና ካባንሶ? ስኑንታኖ አዉ ዛጉናክ ሾልሲናማቶ አሩናክ ታን ዳግሳን ራካቴጝዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","ቱማሲ ስካሎሲ ሀእር ስንነ ፎክ ሾሌፌ ንቶ! ኤሴ ታክ ማኬቤትሶ! ቱማስ ማኬፋና ባሮን ኣነ ኦደፌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","ኮርቶ ማፃፋስሲ አብራሀም ሄፕ ናንጎትባ ፋር፥ እሳይስ ኮንቴናስ ቦዛስኪን ኦሚስ ደይ ኮንቴናስ ብርማዱንማባ ፋና አሱባስኪን ይስቴራ ትቼናይስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","ቦዛስኪን ኮንቴ ናስ አሽኒ ዱቢዮሲማቶቱ ኮንቴዋ፥ ስኑንታኖ ብርማዱምማባ ፋና አሱባስኪን ኮንቴ ባር እምቴ አብድኒ ካማስኪንቱ ኮንቴዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","ኤስ ሄፕ ማሽካሱሲክቶ ሄፕ ቴያኒ ካማሲ ቤሶዋ፥ ሲናኒ ኣማስታን ስና ቴያሲ ቤሶ አጋርዋ፥ ባር ናንጎትባሲክቶኖን ኮኒናስ ቦዛ ስኖነክዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","አጋር አራባኒ ሜኒ ዳስታክ ፋ ሲናኒ ኣማሲክ ቤሶዋ፥ ኤስ ባሪክ ሀሽቲ ፋ የሩሳሌምኔን አነ ሆሱስቴርዋ፥ ባር ናንጎትባስኔን አነ ቦዞስቱ ፋፋዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","ስኑንታኖ ደን ሳማኪር ስና የሩሳሌም ብርማዱምማባ ፋርዋ፥ ባር እንኖ ዙታምኒሴ አሲክ እንቶኒዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","«ነ ታኖኖይ ዛግያሴ፤ ግሮዌ! ኬክቴራ ቢኖይ ነ እልሱዌ! ቴጎባ ፋና ማሽካሱስታን ቴጎባ ፎንቶ አሱስ ሾዎ ናንጎትባ ፋርዋ» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","አይታሳክቶኖ! ንቶ ደይ ይሳቅኒስማቶ አብድኒ ካማሲ ናንጎትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","ስኑንታኖ ኤስ ካባሲክ አሽኒ ፍቃድክ ኮንቴ ባር አያናኒ ፍቃድክ ኮንቴ ባሪን ካብግናሲማቶ ሀሽ ሀውጙኑ ደይ ኤሲስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","ስኑንታኖ ኮርቶ ማፃፋስሲ ማኬፋናስ አዉንሶ?፦ «ቦዛስኪን ኮንቴ ናስ ብርማዱምማ ፋና ባርኪን ኮንቴ ባርኔን አነ ኣፋ ዋራሶናዉዛ ስንና ቦርአ ቦዛሶን ናዉባስኔን አነ ኬሩን ክሱዋ» ይፋዋ። ");
INSERT INTO jnje_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","ኤስ ባሪ ቦርኣ አይታሳክቶኖ! እንኖ ብርማዱምማባ ፋና አሱሲ ናንጎታታኖ ቦዛሲ ናንጎታታዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","ክርስቶስ እኖትን ብርማዱምማ ኪስናስ ብርማዱምማክ ፎኒክዋ። ኤስ ባሪ ቦርኣ ችምማ የሮትዋ፥ ሄፕሳ ዎል ላ ቦዞኒ ዋንጆሲ ካማቶቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","ኤሴ ታ ጳዉሎስ ንቶክ ማኮናስ ሀኒስዋ፥ «ሃርኮኒ ኩኑ ሾልሱዋ» ይራ ሃርኮ ኩነሴፋትነ ክርስቶስ ንቶክ እሳንነ ኣፋ ኬእአናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","«ሃርኮኒ ኩኑ ታክ ሾልሱዋ» ይሬ ሃርኮ ኩንፌ ባር ዙቴሬ «ቱማሶን ዙትሬ ኦዳናክ ሾልሱዋ» ይራ ሄፕሳ አምማኖን ማኬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","ቱማሶን ኦዳክ ኦኮ ስናክ ሾሌፌ ንቶ ዙታምንትሴ ክርስቶስታን ኦር ኬሴትዋ፥ ሀኦሲ ኦቱምታን ደይ አካማኖን ዎኬሴትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","ስኑንታኖ እንኖ ሀኦሲ አያናክ ኦኮ ስናሲ አብድኖን አማንቶክ ኦደት ፋኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","ኤሲስ ደይ ክርስቶስ የሱስኒክ ፌፌ ባርክ ኬሽታናስታ ካፑቴራ ዎስቴፋ አማንቶስታኖ ሃርኮኒ ኩና ስኑን ሃርኮኒ ኩኑ ቤያ እሳንነ ኣፋ ኬእአናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","ማአሮን ኩቲት ፋሴትርዋ፤ ኤካን ሀሽ ፉቶሲክ አጃጃሞኖይትማቶ ንቶትን ካላስ ኦንሶ? ");
INSERT INTO jnje_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ኤስ ኤፋቴና ኪቶስኪ ንቶትን ቴጌ ሀኦስኪን ያርታዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","ኤሲስ ደይ፦ «ጋሮ ማሶስ ቱሾሶን ዙትራ ኬሳናክ ዛግርዋ» ይስቴፋናይሲማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","ስኑንታኖ ሀን ባርስታን ኦማ ሳፋራንት ኣፋ ፎና ዉዛ ስንናማቶ አሪራ ዳሚሲክ አማነፋዉጝዋ፤ ንቶትን ዳግሲፌር ኦኑ ፌፋናነ ኬእኦባሶን ኤጴቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","አይታሳክቶኖ! ታ ሀሽኔን ካርአ ማኬት ፋናስ፦ «ፋሩክ ሃርኮኒ ኩኑ ሾልሱዋ» ይት ማኬን ስንፋናነ አዉኒ ቦርአ ታን ካቡግሴፌሶ? ኤካ ስኒ ስንፋናነ ክርስቶስኒ ማስቃሊስ አሱኒ ሜያክ ቱሳ ስንባስ ፌሻና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","ኤሴ ሀን ንቶትን ዳግስት ፌሴ አሱኒ ሜያ ሾልሴፋቴነ ሃርኮኒ ኩና ኮእባ ስኖይናሮን ባሶ ቴትቤሲሲክ ኣርቃርቤሲሶን ዱኡባስሲ ካርእኤ ሀእኡሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","አይታሳክቶኖ! ንቶ ብርማዱምማክ ፎሶትክቱ ቴግቴቲዋ። ስኑንታኖ እሳይስ ኦሚስን ኬሽታናክ ባሪክ ዎስቶዎቴኖ ኤስ ብርማዱምማንቲስ አሽንትሲ ኤናንቶኖን ዛጉኒር ስንናናታዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","ቱማስ ዙቴራ፦ «ነ ኔን ሹንፋታሲማቶ አሱስን ሹንዋ» ይፋ እሳ ካማሲክቱ ኮእፋዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","ስኑንታኖ ንቶትና ንቶትና ዎል ሳርኤትናዋ ፋሴትና ፋሴትር ስንፋናነ ንቶትና ንቶትና ትሹኖይትማቶ ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","ኤሴ አያናሲክ ዞኑስቴራ ፎትዋ፤ አሻሲ ኤናንቶኖን እሳንነ ዛጉትታዋ ይፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","አሻሲ ኤናንቶ አያናሲ ኤናንቶኔን ቱጋኤር። አያናሴዋ አሻሴ ባሬ ባሬ ዎል ቱጋእኤር። ኤስ ባሪ ቦርኣ ንቶ ሾሌቲ ባሮን ዛጉትክ ኣፋ ችማት ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","ስኑንታኖ አያናሲክ ዞኑስቴፋትነ ቱማሲክ ሀእር ኣፋ ስናትዉዛ፥ ");
INSERT INTO jnje_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","አሽኒ ዎስቶስ አሪቶዋ። ኤስ ባርኪቶ ደይ ጌርኬሳ፥ ኪና፥ ጋፎ፥ ");
INSERT INTO jnje_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ኮእሎኒ ሺጶ፥ ቶልፋታ፥ ጉማዎ፥ ፋስሶ፥ ኮና፥ ግእአ፥ ቴትኒ ሹና፥ ኦር ኦር ኬሳ፥ አሱኒታ ማጙ ዉዝኒ ዎስቶ፥ ");
INSERT INTO jnje_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ኪቻና፥ ዛይያ፥ ጌርኬስኒ ሱሩ፤ ኤስ ኤፋቴናስነ ፋሴርዋ። ዜሞ ስንናክ ቴትንትሶን ኦድትዋ ይራ ማኬናሲማቶ ሀሽኑ ደይ ቴትንትሶን ኦዳትክ ማኬፋውጙዋ። ኤስ ኤፋቴና ዉዛሲክቶኖን ዛግሴፌ አሱኒ ሜያ ሀኦሲ ታቶኖን ኣፋ ዋራሶነ ዉዛ። ");
INSERT INTO jnje_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","ስኑንታኖ አያናሲ ጋና፦ ኬሽታና፥ ግራ፥ ናጋ፥ ፋክያ፥ ማአ፥ ማአሮን ዛጉ፥ አማናምቶ ስና፥ ");
INSERT INTO jnje_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ጋራማ፥ ቴትኒ ሀእሱዋ። ኤስ ኤፋቴና ዉዛሲክቶኖን ካልኒ ቱማ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","ክርስቶስ የሱስኒር ስና ባሶ አሻሶን ባሪ ኢጉሶንናዋ ባሪ ኤናንቶሶንና ሱቴሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","አያናሲክ ፋኒር ስንፋናነ አያናሲክ ዞኑስቶኒዋ። ");
INSERT INTO jnje_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","እሳይስ ኦሚስን ማጙ ዉዛክ ካብግት እኖትና እኖትና ዎል ኮነፋፋ ባክ ኬእኖይ ዉዛክ ቴቶኒታዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","አይኒ ሜያነ! እሳ አሱ ዳጌሬ እሳ ማጝጙ ዉዛ ዎስቴሬ ቤስቴፋናነ አያናክ ፌፌ ንቶ ጋራማክ ዎልጉትክ ሾልስፋዋ፥ ስኑንታኖ ነ ደይ ኤስ ኤፋ ፋታናስሲ ጋንዶኖይታማቶ ቴትኔሶን ኦድዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","ንቶስን እሳይስ ኦሚሳ ፋያ ባአኖን ዎርኦዋ፤ ኤስ ባሪክ ክርስቶስኒ ቱማሶን ዛግር ስናትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","ኣፌ አሱኑ እሳ ዉዛ ስንኖይ ታ ደናሎዋ ይረ በስተፋናነ ቴትባሶንቱ ኤሽድፌዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","አሱ እሳ እሳርባስ ቴትባሲ ዎስቶኖን ቱእኒሬ ቴትባሶን ፋታኖዎዋ። ኤሴን ኦርፎ ቴትባሶን ኦም አሱስኔን አነ ሆሱክ ስንኖይናሮን ቴትባሲክ ቴቶናዉዝባ ዳናናዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","ኤስ ባሪ ቦርኣ አሱ እሳርባ እሳርባስ ቴትባሲ ባአኖን ዎርአናክቱ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","ካማሶን አሪት ፌ አሱስ አስሲኛስኔን አነ ማአ ዉዛሶን ዙትሬ ሃኦናዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","ቴትንቲሶን ኤሻቲታዋ፤ አሱ ቡክና ባሮንቱ ካርፌ ስንና ቦርአ ሀኦስታ ኮሳዎቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","አሽባሶን ግርሱናክ ቡክፌ ባር አሽባስኪን ክቱቱ ካርአና፤ አያናሶን ግርሱናክ ቡክፌ ባር አያናስኪን ኮእባ ፎንቶ ካቱ ካርአና ");
INSERT INTO jnje_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","አብድ ቡጉ ሻካኒነ ዎንባስ ካርፋና ካባሲክ ማራሶን ካርአኒር ስንና ቦርአ ማአ ዎስቶሶን ዎስቶስታን አዉጃዎኒታዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ማአ ካባ ዳንፌኒ ካባሲክ አሱ ዙታምባሴ አሲክ አሪክሮን ደይ አማነሴፌ አሱኒ ሜያክ ማአ ዉዛሶን ዛጉኒዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","አዉነ ፋ እኛ እኛ ማላቶክ ሀን ባሮን ኩሹናሲክ ትችናማቶ ቢትዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","ሃርኮ ኩናትክ ንቶትን ግድስሴፌ ባሶ ጌሮክ ማአር ስንነ ቤስቶክ ሾልሴፌ አሱኒ ሜያዋ። ኤስ ባሮን ዛግሴፌስ ክርስቶስኒ ማስቃልሲ ቦርአ ካቡግቶ ባሶስታ ካርኖይናማቶ ኮእባዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","ባሶ ንቶ አሻሲክ ቴቶክዋ እያቱ ሃርኮ ኩናትክ ሾልሴቴታኖ ሃርኮ ኩና ባሶኑ ቴትቤሲሲክ ቱማሶን ኣነ ዛግሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","ዳምኒ የሱስ ክርስቶስኒ ማስቃሊስታን ኦማ ቴቶና ቴቶስ ታይስታን ዎኩጝዋ። ሀን ማስቃሊሲክ ሀን ዳስ ታክ ሱቴ፤ ታ ደይ ሀን ዳሲክ ሱቴን። ");
INSERT INTO jnje_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","ኤስ ባሪ ቦርኣ ሃርኮኒ ኩኑ ስኑን ሃርኮኒ ኩኑ ቤያ ኬአና ዉዝባ ኣፋዋ፤ ኬእኒስ ጋድዶ ቴስቶ ስናስዋ ");
INSERT INTO jnje_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","ሀን አጃጂሲክ ዞኑስቴሴፌ ባሶ ዙታምቤሲሴ አሲክናዋ ሀኦኒ ኬን ስና እስራኤልኒ ሜያክና ናጋነዋ ፋክነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","አቱናስታኪ ፋ እቾኒ ሳካስ የሱስኒ ዎስትኛ ስንናሶን ቤስፋና ቦርአ ሀንኔን ኤካሎክ ኦኑ ታን ራክሱናታ። ");
INSERT INTO jnje_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","አይኒ ሜያነ! ዳምኒ የሱስ ክርስቶስኒ ኦትማስ አያናንትስኔን አነ ስንፋውጝዋ! ኣሚን። ");
INSERT INTO jnje_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","ሀኦኒ ፍቃድክ የሱስ ክርስቶስኒ ዎሲ ስና ጳዉሎስኒኪን፥ የሱስ ክርስቶስኒክ አማናምቶ ስና ኤፌሶኑክ ፌሴ ኮርቶኒ ሜያክ፥ ");
INSERT INTO jnje_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","አባ ሀኦኒስኪንናዋ ዳም የሱስ ክርስቶስኒክንና ኦቱማሴዋ ናጋሴ ንቶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","ደን ሳማኪ ፋ አያናኒ ኤባ ዙታምባሴ አሲክ ክርስቶስኒኪ ካሞ እኖትን ኤቢስ ዳምኒ የሱስ ክርስቶስኒ አባ ስና ሀኦሲክ ጋላታ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","ኮርቶናዋ ዝናባ ፎንቶና ስናኒክ ሀን ዳስ ቴስቶኖይፌን ዜምማ ክርስቶስኒኪ ካሞ እኖትን ኮሪዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","ሀኦኒ ማአ ፍቃድ ስኒን የሱስ ክርስቶስኒኪ ካሞ ባሪ ናንጎታ ስንናኒክ ዜምማ ኬሽታንባሲክ እኖትን ኮሪዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","ኤስ ባሮን ደይ ዛግናስ ሹንቶ ናዉባስኪ ካሞ ባክ እኖክ እምና ኡልፍንቶ ኦቱምባስ ጋላታምቶናክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","ኤስ ባሮን ደይ ዛግናስ ሀኦሲ ኦቱምኒ አርኩታን ካብ ቾዋ እኖትን ሹና ናዉባሳ ሀንናክ ፉርቴራ ሚርአኒሲ ፋክያኖን ዳንኒዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ቴችማ ዙታምባሴ አሲክናዋ ያዳታክና፤ ");
INSERT INTO jnje_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","ሀኦስ አላማባሲክ ክርስቶስኒኪ ካሞ ዜምማ ኮፓኤናማቶ ፍቃድባሲ ኣቾ ቾዋኖን አሩኒክ ዛግዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","ዎንባስ ካርፋና ካባሲክ ዎስቶታ ፌሹና ኮፖባስ ሳማክናዋ ሀን ዳስታክና ፋሴ ቴስቶ ዙታምባሴ እሳሪክ እሳ ክርስቶስኒ ሀእሱኒ ስካሎሲ ስናናክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","ዙታምባሴ አሲን ፍቃድባሲ ኪቶኒማቶ ዎስቴፋ ሀኦስ ዜምማ እኖክ ኮፓኤና ኮፖሲማቶ ክርስቶስኒኪ ካሞ ባሳ ኬን ስንናኒክ እኖትን ኮሪዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ኤስ ባር ደይ ስንናስ ክርስቶስኒን አብድኒ ዛጉኒክ ቴሱኒር ስና እኖኪ ካሞ ሀኦሲ ኡልፍና ጋላታምቶናክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","ንቶ ደይ ፉቶኒ ካማሶን፤ ኤስ ባር ደይ ፋሩኒ ምስራቹኒ ካማሶን ኦደራ አማነቲ ካባሲክ ንቶክ አብድ ግርቴ ኮርቶ አያናሲክ ማታማ እቼትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","ኤስ አያናስ ኡልፍንባሲክ ጋላታ ስናናክ ሀኦ ባሪር ስና ባሶትን ዙትራ ፉሮና ካባኔን ዳናኒክ ፋ ርስትኒሲክ ካብድዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","ኤስ ባሪ ቦርኣ ዳምኒ የሱስኒክ ፋ አማንቶኒትሴዋ ኮርቶኒ ሜያ ዙታምቤሲሴ አሲክ ፋ ኬሽታንትሴ አስን ኦደራ፥ ");
INSERT INTO jnje_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ሺጶናሲክ ንቶትን ያዳቴት ንቶ ቦርአ ሀኦናሶን ጋላቶሶን ኣነ ቤዩት። ");
INSERT INTO jnje_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ኡልፍንኒ አባ ዳምኒ የሱስ ክርስቶስኒ ሀኦሶን ማእስራ አሩሶትክ ቴቹምነዋ አምማ ክስሬ ቢኒ አያናሴ ንቶክ እምቶናክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","ኤሲስማቶ አዉነ ፋ አብድክ ቴግቴሴትማቶናዋ ኮርቶኒ ሜያ ዋራሶነክ ፋ ኡልፍንቶ ርስትስ አዉነ ፋ አካማ ስንናማቶን አሩሶትክና ንብንትሲ ኣፋ ጋቾናክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","20","ሆሱስቶኖይ አካማ ሁግናባስ አማነፌ እኖክ አዉነ ፋ እኛ ስንባሶን አሩትክ ሺጴፋዉጙዋ፥ ኤስ አካማ ሁግናሶን ዎስቶክ ቤሲናስ ክቱን ካብግራ ሳማኪ ድማስታ ኦእታ ቴሽባስታ ዱስና ናውባ ክርስቶስኒኪ ካሞዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","አባ ሀኦስ ክርስቶስኒን ሳማኪ ኦእታ ቴሽባስታ ዱሲናስ ኣፋ ሀእሱታናዋ ሀእሱኒ ሁግናስታና ደይ ሁግናነዋ ዳም ስናሲ ደናሎነ ደይ ኤሲስማቶ ሀን ዳስታክ ኮእባ ስኖይናሮን ዮኒ ዳስታክ ሱናኔን ደናሎ ስና ሱና እማዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","ሀኦስ ዙታምባሴ ባሳ ሀእሱሲ ስካሎሲ ሀእኡናክ ዛጊዋ። ቤቴክርስታኒሲክ ደይ ዙታምባሴ አሲስታን ደናሎ ስናናክ ቴት ዛግዋ። ");
INSERT INTO jnje_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","ቤቴክርስታኒስ ደይ ባር ዙታምባሴ አሲን ኣፋ ኡግናክኑ ዙትሬ ቱንፌና ባሳ ቱማ አቱባስዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","ንቶ ቦርኒትሲክናዋ ማጝሱኒትሲክና ክትራ ፋሴትርዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","ኤስ ካባሲክ ሀን ዳስታኪ ማጙ ኡግናሲክ ፋቲ ፋሴትር፤ ኤሲስማቶ ደይ ሳማስታክ ፋሴ ኪና አያናሲ ሁግናኖን ሀእስፋ ባርክ አጃጃሜት ፋሴትርዋ። ኤስ ባር ደይ ሀኦሲክ አጃጃሞ ቤያ አሱኒ ሜያስታ ዎስቴት ፋ አያናስዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","እንኖ ዙታምኒሴ ዜሞ ስናክ ባሶ ጋነያሲ አሽኒሲ ፍቃድክናዋ ካኑኒሲ ሳፋራክና ዞኑስቴት አሽኒሲ ኤናንቶክቱ ፋት ፋኒዋ፥ ኦም ሜኒማቶ ደይ ቴስቶኒሲክ ሀኦሲ ግእኒ ስካሎሲቱ ፋኒዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","ስኑንታኖ ሀኦሲ ፋክያ አካማ ስንና ቦርአናዋ እኖክ ፋ ኬሽታንባስ ደይ አካማ ስንባስታን ካብ ቾዋ፤ ");
INSERT INTO jnje_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ማጝሱኒሲክ ክትራ ፋፌኒክኑ ሀኦስ ክርስቶስኔን አነ ፎኒክ ዛግዋ፤ ንቶ ደይ ፋርሴቲስ ሀን ሀኦሲ ኦትማክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","ሀኦስ ክርስቶስ የሱስኒኪ ካሞ ባርኔን አነ ክቱን ካብግራ ሳማኪ ድማስታ እኖትን ዱሲዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","ኤስ ባሮን ደይ ዛግናስ የሱስ ክርስቶስኒኪ ካሞ እኖክ አምማኖን ቤሲና ጋራምባሴዋ ሆሶባ ፎንቶ ኦቱምባሴ አሲ አርኩኖን ዮኒ ነያሲክ እኖክ ቤሱናክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","ንቶ ፋሪሴቲስ አማንቶሲኪ ካሞ ሀኦሲ ኦትማክዋ፥ ኤስ ባር ደይ ሀኦኒ እማታኖ ንቶ ዎስቶሲክ ቤስቴርታዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","ኦኑ ቴቶኖይናማቶ ፋሩኒ ኦትማስ ቤስቴናስ ዎስቶሲክታዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","እንኖ ሀኦስ ዜምማ ሆስና ማአ ዎስቶሶን ዎስቶኒክ የሱስ ክርስቶስኒኪ ካሞ ሄፕሳ ቴስቴ ሀኦሲ ቴስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ኤስ ባሪ ቦርኣ ዜሞ ንቶ ኮንቶንትሲክ ኣዛብ ስንና ፋሴትርዋ፥ አይሁድኒ ሜያ አሱኒ ኩሹክ ሃርኮ ኩኖቤሲሲክ ቴቴፋፌ ንቶትን ሃርኮ ኩኖር ይት ፌሴቴር ስንናማቶ ያዳቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","ንቶ እስራኤልኒ ዳራሳ ኬን ስንኖርዋ፤ አብድኒ ቴያኒ ካማሲክ እርባ ስንና ሀን ዳስታክ ደይ እሳ አብድንት ፎንቶ ስንና፤ ሀኦሲኔን አነ ፎኖር፤ ክርስቶስኒስታን ደይ ኦር ኬስሳ ፋሴትር ስንናትማቶ ያዳቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","ስኑንታኖ ሀሽ ንቶ ዜሞ ስናክ ዎክካ ፋሴት ባሮን ሀሽ የሱስ ክርስቶስኒኪ ካሞ ባሳ ሀንናሲክ ታእሴትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","እኖትን ኦር ክሲ ፋስሶኒ ሳዋሶን ቦጌ አይሁድኒ ሜያኖንናዋ አዛብኒ ሜያኖንና እሳር ዛግሬ እንኖክ ናጋኒ ስናስ ክርስቶስዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","ሄፕ ዳራስን ባርኔን አነ እሳር ዛግሬ እሳ ጋድዶ ዳራኒን ቴሱናክ ቱማሲ አጃጅሲክቶኖንናዋ ስትሪሲክቶኖንና አሽባሲክ ሻሬሬ ናጋ ዛግዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","ማስቃሊስታ ክቱክ ጉማ ስናሶን ትሽክዋ። ሄፖቤሲሴ አሲን እሳ ብልት ዛግሬ ሀኦሲኔን አነ ጋንሲ። ");
INSERT INTO jnje_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","ዬሬ ደይ ዎክኬ ፌ ንቶክናዋ ታእሴሬ ፌሴ አይሁድኒ ሜያክና ናጋኒ ምስራቹኒ ካማሶን ማኬ። ");
INSERT INTO jnje_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","እንኖ ዙታምኒሴ ባርኪ ካሞ እሳ አያናሲክ ዞኑስቴራ አባሲኪ ታአኒዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","ኤስ ባሪ ቦርኣ ንቶ ኮርቶኒ ሜያኔን አነ እሳ ዳኒ አሱዋ። ደይ ሀኦኒ ኬርኪ ሜያቴኖ ሀንኔን ኤካሎክ ንቶ እርባ ወደይ ኦጎቴዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","ዎስኒ ሜኒ ካፕታስታንናዋ ራጁኒ ሜኒ ካፕታስታና ካፑቴራ የሬቲርዋ። ካጃስታ ዲፋ ሹኣስ ደይ የሱስ ክርስቶስዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","ሹእኒ ኬያስ ዙታምባሴ ኤስ ሹኣሲክ ኬቴራ ዳሚሳ ቤቴሜቅደስ ስናናክ ድችፋዋ። ");
INSERT INTO jnje_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","ሀኦስ አያናባሲክ ንቶስሲ ፎና ሹእኒ ኬያ ስናትክ ንቶ ደይ ክርስቶስኒክ ኬቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","ኤስ ባሪ ቦርኣ ታ ጳዉሎስ የሱስ ክርስቶስኒክ ታቶ ስንናስ ንቶ አዛብኒ ሜያክዋ እያትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","ንቶክ ኬኡጝዋ እያት ሀኦስ ኦቱምባሲክ ታክ እምና ዎስቶሶን ፉቶክ ኦደሴትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","ዜምማ ካዉናኖን ንቶክ ትችናሲማቶ ሀኦሲ ኣቾ ቾዋሶን አምማኖን ክስራ ራእክ ታክ ቤስዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ሀን ንቶክ ትችና ባሮን ፌሬትሴፌት ካባሲክ ታ ያዳቴና ክርስቶስኒ ኣቾ ቾዋሶን ንቶ ደይ ያዳቶክ ችማትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","ኤስ ኣቾ ቾዋስ ደይ ሀኦሲ አያናክ ኮርቶ ስና ዎስኒ ሜያክናዋ ራጁኒ ሜያክና ሀሽቲ አምማኖን ኬስሳ ቤስቴናስንነ ፋሮን ኣታ ነያስሲ ፌሴ አሱኒ ሜያክ ኣነ አምማኖን ኬስሳ ቤስቶዋዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","ኤስ ባር ደይ ኤክካ ስንናስ አዛብኒ ሜያ አይሁድኒ ሜያኔን አነ ሪስትባሶን ዋራሶነክናዋ እሳ አቱኒ ብልት ስንነ ሀኦስ እምና አብድኒ ምስራቹኒ ካማስኪ ካሞ ደይ የሱስ ክርስቶስኒኪ ካሞ ሃኤር ስኖቤሲሶንቱ ቤሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","ሀኦስ ሁግናባሲ ዎስቶኒማቶ ታክ እምና ባሪ ኦትማሲ እማክ ታ ደይ ሀን ምስራቹኒ ካማሲ ዎስትኛ ስንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","ታ ኮርቶኒ ሜያ ዙታምቤሲሴ አሲስታን ሀቴር ስንፋናክኑ ድልባ ፎንቶ ክርስቶስኒ ኦቱም ስንናሶን አዛብኒ ሜያክ አዋሱናክ ሀኦሲ ኦትማክ ሀን ዎስቶስ ታክ እምቴዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","ኤሲስማቶ ደይ ኣታ ነያሲክ ዙታምባሴ አሲን ቴሲ ሀኦስኪ ኣቸራ ፋ ኣቾ ሀኦሲ ኮፖ አዉ ስንናማቶ አሱ ዙታምባሴ አሲክ አምማኖን ክስራ ማኮናክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","ኤስ ባር ደይ ስንናስ ሀሽቲ ካባሲክ ቤቴክርስታኒስኪ ካሞ ሳማክ ፌሴ ጋኝኛሳክቶናዋ አእስኛአሳክቶና ሀኦሲ ቴችማኖን ግቶባ ግቶባሲክ አርሶነክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","ሀኦስ ዳምኒ የሱስ ክርስቶስኒኪ ካሞ ሀን ባሮን ዛግናስ ኮእባ ፎንቶ ኮፖባሲማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","ክርስቶስኒር ስንኒሲክናዋ ባርክ አማኖኒሲክና ሀኦሲ ስናክ ድጋ ፎንቶኖንናዋ ባሪክ አማንቶክ ታአክና ችማ ዳንኒዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","ታ ንቶ ቦርአ ኤጳታት ፋና ሻናስ ንቶክ ኡልፍኒት ስንና ቦርአ አብድ ቡጉትታዋ ይራ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","ኤሴ አባ ሀኦሲ ስና ኬእናሲክ ካእነራ ሺጴፋናስ ሀን ባሪ ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","ሳማክናዋ ሀን ዳስታክና ፌሴ ሀኦኒ ኬርኪ ሜያ እሳርቤስ እሳርቤሲስ ፉቶኒ ሱንቶሶነ ሱንቤሲሶን ዳነቴስ ሀኦስክጝዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","ሀኦስ ስርኪ አቱንቲሶን ችኑኒ ሁግናክ አያናባሲኪ ካሞ ኡልፍንባሲ ኦቱምታን ንቶክ እማናክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ኤሲስማቶ ደይ ክርስቶስ አማንቶክ ንብንትስሲ ፎናክናዋ ንቶ ደይ ታሳ ፎካ ኬሽታናክ ችምሜ የሬር ስንናትክናዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","19","ዮኡባ ፎንቶ ሀኦሲ ቱምታ ካርአ ቱምቶትክ ታግባሴዋ ድችባሴዋ ደይ ቴግባሴዋ ዶእኦባሴ አሱኒ አሩስታን ደናሎ ስና ክርስቶስኒ ኬሽታናሶን ኮርቶኒ ሜያኔን አነ ያዳቶ ችማትክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","ኤስ ባሪ ቦርኣ እኖስሲ ዎስቴት ፋ ሁግናባስኪ ካሞ ማምሲፌኒ ባሪስታንናዋ ሳፋሬፌኒ ባርስታንና ደናሎኖን አካማኖን ዳይሲራ ዛጉናክ ችምፋ ሀኦሲክ፤ ");
INSERT INTO jnje_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","ቤቴክርስታኒስኪ ካሞናዋ የሱስ ክርስቶስኒኪ ካሞና ኮንቶ ዙታምባሴ አሲክ ኮእባ ፎንቶኖን ኡልፍና ስንፋውጝዋ! ኣሚን! ");
INSERT INTO jnje_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","ኤሴ ዳሚሳ ዎስቶኖን ዎስቴና ቦርአ ታቴሬ ፌ ታ! ንቶ ቴግቴት ቴግቶሲክ ሾልሲ ፎሶን ፎሶትክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","ኬሽታናክ ንቶትና ንቶትና ዎል ፋክያክ ዎንና ዎንና ሹጳክ፥ ጋራማክ ችምማ ፎሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","ናጋክ ዛቴራ ሀኦኒ አያናስኪን ቤስቴፋ እሳር ስንናሶን ኦዳትክ ችምትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","ቴግቴሴፌት ካባሲክ እሳ አብዲሲክ ቴግቴሴትማቶ እሳ አቱነዋ እሳ አያናነ፤ ");
INSERT INTO jnje_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","እሳ ዳም፥ እሳ አማንቶ፤ እሳ ሀጱክቶ፤ ");
INSERT INTO jnje_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","ዙታምባሴ አሲስታን ደናሎ ስና ባር፥ ዙታምባሴ አሲሲ ዎስቴፋ ባር፤ ዙታምባሴ አሲሲ ፋፋር ዙታምባሴ አሲ አባ ስና እሳ ሀኦስ ደይ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ስኑንታኖ ክርስቶስ እማናክ ሾሌናሲማቶ እሳርኒ እሳርኒሲክ ሀኦሲ ኦትማኒ እማኖን እኖክ እምቴዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","ኤሲስ ደይ፦ «ደን ኬስፌና ካባሲክ፤ ሾዎ ቦጆ ቦጀ አሱኒ ሜያክ ደይ እማ እሚ» ይስቴናይስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","ኤካን፦ «ደን ሳማ ኬሲ» ይፋ ካማስ ዜምማ ሀን ዳስታክ ደይ ዬት ዳስሲ ኬሬ ኡ ስና ሻካናነ አዉ ኡንሶ? ");
INSERT INTO jnje_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","ሀን ዬት ኬሬ ባር ኤስ ዙታምባሴ አሲን ቱኑክ ሳማሲክቶ ዙታምባሴ አሲ ደናሎ ኬሳስ ደይ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","ባር ደይ እሳ እሳይስን ዎሲ፥ እሳ እሳይስን ራጁ፥ እሳ እሳይስን ምስራቹኒ ካማሶን ማክሶኒር፥ እሳ እሳይስን አማኝኒ ሜያኖን ኬሜርናዋ አስሲኛኒ ሜና ስኖነክ እማሲክቶኖን ባሶክ እሚዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ኤስ ባሮን ደይ ዛግናስ ክርስቶስኒ አቱ ስና ቤቴክርስታኒሲክቶኖን ችኑናክዋ፤ አማኝኒ ሜያኖን ደይ ዎስቶክ ሆሱናክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ኤሲስማቶ ደይ ሀኦሲ ናኒን አሩክ፥ አማኖክ ቤስቴፋ እሳር ስንናስታ ካርአ፥ ክርስቶስ ቱም ስንናስንነ ፋሮን እንኖ ደይ ቱም ስንናኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","ሀውጙኔን ኤካሎክ አሱኒ ሜኒ ጃልኒ ኤሽሹሲክናዋ ኤሻሲክና ሆሬ ዳግስፋ አስሱሲ ስሩክ ኤክ ሀጝ ሾርኬት ዳጋ ናንጎታ ኣፋ ስንናንዉዛ። ");
INSERT INTO jnje_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","ኤስ ባርስታን ፉቶሶን ኬሽታናክ ማኬት ዉዛ ዙታምባሴ አሲክ ቴት ስና ክርስቶስኒኪ ድቻንዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","ሾዎ አቱኒ ብልትስ እሳስ ባሪስታ ኡጰፋናስ ክርስቶስኒክዋ። አቱስ ዙታምባሴ ደይ እሳ ባሪስታ ዛቴናስ ኬኦባ ኬኦባሲክዋ። ኤስ ባሪ ቦርኣ አቱ እሳርባ እሳርባሲ ብልይቲ ባሪክ እምቴ ዎስቶሶን ማእስራ ዎስቴፋና ካባሲክ አቱስ ዙቴራ ድችፋዋ፥ ኬሽታናሲክ ደይ ችምማ የሬፋዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","ሀውጙኔን ኤካሎክ ሳፋራቤስ ኬእኖር ስና አዛብኒ ሜኒማቶ ፎቲታዋ ይራ ዳሚሳ ሱናክ ንቶትን ኪትፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","ባሶ ካኑስ ታልሜ፤ ንቤሲሲ ሙሙታን ካብ ቾዋ አሩቤይቤሲሲክ ሀኦሲ ካስታን ኦር ኬሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","ኢቻንኒ ካኑቤሲስ ትሽና ቦርአ ኪና ዉዛሲክቶኖን ዙትሬ ዛጉክ ቴትቤሲሶን አሽኒ ኤናንቶቤሲሲክ ኣትሬ እሜቴ። ");
INSERT INTO jnje_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","ስኑንታኖ ንቶ ክርስቶስኒ ቾዋሶን አርሴትስ ኤካታዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ፉቶሲክ ባሳ ቾዋሶን ኦደሴትዋ፤ የሱስኒሲ ፋ ፉቶሶን ባርኪን አሪሴትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ኤስ ባሪ ቦርኣ ንቶትን ኤሽሺራ ቦርኣስሲ ዞንስፋ ኤናንቶስ ዜምማት ፋቲ ማጙ ፎሶን፤ ኩርኡ ቴስቶኒ አማላሶን ኤናንቶባስኔን አነ ክስራ ሀኡትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","ካኑንቲሲ አያናክ ጋድዶ ስንትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ፉቶኒ ኦኮሲክናዋ ኮርቶሲክና ሀኦሲ ግቶክ ቴስቴ ጋድዶ አቱሶን ማይትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ኤስ ባሪ ቦርኣ ኤሻ ዎላ ዎሎቲታ። ዙታምኒሴ እሳ አቱሲ ብልት ስንኒ ቦርአ እኖትና እኖትና ፉቶ ስና ውዛሶንቱ ዎሎኒ። ");
INSERT INTO jnje_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","ግእቶት፥ ስኑንታኖ ኤስ ግእኣሲክ ቦርኣሶን ዎስቶትታ፥ ግእንትስ ኬሮኖይፌን ወደይ ኮቾኖይፌን አዋ ግሩናታ። ");
INSERT INTO jnje_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","ዳቡሎስኒክ ደይ ግሩና ካቶ ቤሱትታ። ");
INSERT INTO jnje_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","ዜሞ ዊሴት ፌ ባር ሀንኔን ኤካሎክ ዊሶናታ። ኤስ ባርስታን ቱካምኒ ሜያክ እማና ዋግባ ፎናክ ባር ቴትባሲክ ማአ ዎስቶ ስና ባሮን ዎስቶዎ። ");
INSERT INTO jnje_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","ኦደፌ ባሶትን ግርሲራ ዛግጉኒ ካማታኖ ኖኖቲስን እሳንነ ማጙ ካማ ኬሳናታ። ");
INSERT INTO jnje_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","ፉርቶቲ ዎናሲክ ማታማ እቼሴት ኮርቶ ሀኦሲ አያና ሱሞናክ ዛጉትታ። ");
INSERT INTO jnje_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","ሱቃሮ ስና፥ ሃሪ፥ ግእአ፥ ሳሳ ሜእነዋ ኣፋ ማጙ ዉዛስኑ ዙቴራ ንቶስታን ዎኩን። ");
INSERT INTO jnje_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","ኤስ ባሪስታን ንቶትና ንቶትና ዎል ማአር ደይ አሱኒክ ሳፋሬር፥ ኬናሽቴር ስንት፥ ሀኦስ ክርስቶስኒኪ ካሞ ንቶትን ፌሹን ይናሲማቶ ንቶ ደይ ንቶትና ንቶትና ዎል ፌሹን ኡሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ኤሴ ሹንቶ ናንጎትኒማቶ ንቶ ደይ ሀኦሲ ኡግናክ ዞኑስቶት። ");
INSERT INTO jnje_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","ክርስቶስ እኖትን ሹናሲማቶናዋ ሀኦሶን ግርሱኒ ሳዉባ ፋና ማባነዋ ማአነ ዛግሬ ካባሶን እኖክ ኣትሬ እምናማቶና ንቶ ደይ ኬሽታናክ ፎሶት። ");
INSERT INTO jnje_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","ኤስ ኤፋቴና ዉዛስ ክርስታናኒ ሜያክ ኣነ ማእፋ ስንና ቦርአ ጌርኬሳ ወደይ ኣፋ ቴሳ ዝናስኑ ስኑን ወደይ ጆርቱ ስናስ ዎሉምባስኑ ንቶ ጋነያስሲ ኦድቶናክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","ኤስ ባርስታን ሀኦሲክ ጋላታ እምትታኖ አሱ ግስቶናክናዋ ጎዋኒ ሜኒ ዎላክና ወደይ ካኝኒ ዎልነ ዎሎትክ ኣነ ሾልሲፋዋ፥ ኤስ ኤፋቴና ዉዛስ ንቶክ ማእባ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","ጌርኬሳ ስኑን ወደይ አዉነ ፋ ዝና ስና ዎስቶ ዛግት ፌ አሱ ፌፋናነ ወደይ ኮልኦኒ ሺጶነ ፋ ጆራ ስኑን ክርስቶስኒክናዋ ሀኦሲ ታቶስንና ርስትባ ኣፋ ሲንናማቶ አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","ሀን ዉዛሲክቶኒ ቦርአ አጃጃሞኖይ አሱኒ ሜያስታ ሀኦኒ ግእአ ዮኒር ስንና ቦርአ ኦኑ ኬኖይ ዎላክ ንቶትን ኤሻናታዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","ኤስ ባሪ ቦርኣ አጃጃሞኖይ አሱኒ ሜያኔን አነ እሳር ስናቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","ዜሞ ንቶ ታልማሲቱ ፋፌትዋ፥ ስኑንታኖ ሀሽ ዳሚሳር ስንነት ቦርአ ንቶ ቻሬፍዋ። ኤስ ባሪ ቦርኣ ቻሬፋስሲ ፌሴ አሱኒ ሜኒማቶ ፎሶት። ");
INSERT INTO jnje_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","ቻሬፋሲ ጋና ቤስቴፋናስ ማአሮን ዛጉክናዋ ኦኮ ስና ዉዛሲክናዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ኤስ ባሪ ቦርኣ ዳሚስን ግርሱኒ ዉዛስ አዉ ስንናማቶ ቱእኑሶት። ");
INSERT INTO jnje_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","ቻሬፋስታ አምማኖን ኬሳ ቤስቶናክ ዛጉትታኖ ጋንባ ፎንቶ ስና ታሉምኒ ዎስቶስኔን አነ እሳር ስናትታዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","ታልማሲ ፌሴፌ አሱኒ ሜያ ኣቾኖን ዛግሴፌ ዉዛሲ ዎላክኑ ኢቹዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","ዙታምባሴ ቻሬፋስታ ኬስፋና ካባሲክ ፉቶኒ ግቶባስ አምማኖን ኬስሳ ቤስቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","አምማኖን ኬስሳ ቤስቴፋ ባር ዙታምባሴ ቻሬፋዋ። ኤስ ባሪ ቦርኣ «አፋይቴሬ ፌ ነ ጉዙዋ! ክቱን ደይ ካቡዋ! ክርስቶስ ደይ ኔክ ቻርሱናዋ» ይስቴዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","ኤሴ ኣካክ ፎትማቶ ማእስራ ያዳቶትዋ። ቴቹምኒ ሜኒማቶታኖ ጎዋኒ ሜኒማቶ ፎቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","ዎናሲክቶ ማጙ ስንና ቦርአ ኣጌነ ኣጌነ ዎናሶን ዎስቶታ ፌሹት። ");
INSERT INTO jnje_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","ኤስ ባሪ ቦርኣ ዳሚሳ ፍቃድ አዉ ስንናማቶ ያዳቶትታኖ ጎዋ ስንናትታዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","ትሹኒ ኡግናስሲ ንቶትን ታምኒር ስንና ቦርአ ዋይንኒ ኡሻክ ዛዎትታ። ኤስ ባርስታን ኮርቶ አያናሲክ ቱምቶት። ");
INSERT INTO jnje_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","ጋማክናዋ ዌእሶክና፥ አያናኒ ቴቾክ ንቶትና ንቶትና ዎል ዎልሎሶት፥ ዌእሶክናዋ ጋማክና ቱማ ንብንትሲክ ዳሚስን ጋላቶት። ");
INSERT INTO jnje_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ዳምኒ የሱስ ክርስቶስኒ ሱናሲክ ዉዛ ዙታምባሴ አሲክ አባ ስና ሀኦሶን ዎንና ዎንና ጋላቶት። ");
INSERT INTO jnje_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","ክርስቶስኒ ኡልፍናሲክዋ እያት ንቶስን እሳይስ ኦሚሲክ አጃጃሞዎ። ");
INSERT INTO jnje_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","ኬሪኛኒ ሜያነ! ዳም የሱስኒክ አጃጃሜፌትሲማቶ ቴጎንትሳክቶኒክ አጃጃሞት። ");
INSERT INTO jnje_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","ክርስቶስ ቤቴክርስታኒሲክ ቴት ስንናማቶናዋ አቱባ ስና ቤቴክርስታኒሶን ፋቱኒር ሲንናማቶና ቴጎስ ደይ አሱባሲክ ቴትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","ቤቴክርስታኒስ ክርስቶስኒክ አጃጃሜፋናማቶ ኬሪኛአሲክቶ ደይ ዙታምባሴ አሲክ ቴጎቤሲሲክ አጃጃሞሶቶ። ");
INSERT INTO jnje_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","ቴጎኒ ሜያነ! ክርስቶስ ቤቴክርታኒሶን ሹናማቶናዋ ቴትባሶን ደይ ባሪክዋ እያት ኣትሬ እምናማቶና ንቶ ደይ ኬሪኛትሲክቶኖን ሹንትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","ክርስቶስ ኤስ ባሮን ዛግናስ ቤቴክርስትኒሶን ኮርቶ ዛጉናክ ሾሌፋትዋ። ኮርቶ ዛግናስ ደይ ካምባስኪ ካሞ አካክ ማስሴዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ኤስ ባሪክ ኪና ወደይ ኣፍሲኪ ካራዎ ወደይ ኤስ ባርነ ፋ ኦማ ማጙ ዉዛ ባሪስታ ቤስቶኖይናማቶ ኮርቶ፤ ሙዳባ ፎንቶ ጋዳ ዛግሬ ባርኪ ታእሱናክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","ኤሲስማቶ ቴጎኒ ሜያ ባሶ ቴትቤሲሶን ሹነፌይሲማቶ ኬሪኛቤሲሲክቶኖን ሹኖነክ ሾልሱዋ፥ አሱባሶን ሹንፌ ባር ቴትባሶንቱ ሹንፌዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","ባሳ ቴትኒ አቱሶን ኦምቴፌ አሱ ኦኑ ኣፌዋ፤ ኤስ ባሪስታን ኦማ ክርስቶስ ቤቴክርስታኒሲክ ዛግፌናይሲማቶ ባሳ ቴታሶን ማሲር፥ ደይ ፌሬር። ");
INSERT INTO jnje_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","እንኖ ደይ ክርስቶስኒ አቱኒ ብልትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","ኤስ ባሪ ቦርኣ «አሱ እንቶባሶንናዋ አባባስንና ቤየ ኬሪኛባስኔን አነ ታጵቴፌ፥ ሄፖቤሲሴ ደይ እሳ አቱ ስነፌዋ» ይስቴራ ትቼዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","ሀን ኣቾ ቾዋስ አካማኖን እኛዋ። ኤስ ባሮን ይናስ ክርስቶስኒንናዋ ቤቴክርስታኒሶንና ቤሶ ዛግሬ ቤሱክዋ። ");
INSERT INTO jnje_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","ስኑንታኖ ሀን ዉዛስ ንቶትን ደይ ብያር ስንና ቦርአ ቴጎስ ኬሪኛባስ ባሳ ቴታሶን ሹንፌናሲማቶ ሹኖ፥ ኬሪኛስ ደይ ቴጎባይስን ኡልፍንሱንዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ናንጎታሲክቶነ! ሾልሲር ስንና ቦርአ ዳሚሲክዋ እያት ኮኒ አባ እንቶኒትሲክ አጃጃሞሶት። ");
INSERT INTO jnje_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","«አባኔስንናዋ እንቶኔሶንና ኡልፍንሱ» ይፋ አጃጂስ ቴሱኒርዋ፤ ኤስ አጃጂስ ደይ፦ ");
INSERT INTO jnje_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","«ዙታምባሴ ኔክ ማአር ስናናክ፤ ሀን ዳስታክ ደይ ዎጋኔስ ድቻናክዋ» ይፋ አብድኒ ካምባ ፋናርዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","ንቶ ደይ ኮኒ አባናዋ እንቶኒ ሜያነ! ዳሚሳ ስትሪኖን አሱክ፥ ካኑክናዋ ኬእኡክና ድቹትታኖ ናንጎትኒትሶን ሃርሱክ ጂናኦሶናክ ዛጉትታ። ");
INSERT INTO jnje_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","ንቶ ቦዝኒ ሜኖ! ሀን ዳስታክ ንቶ ዳም ስና ባሶክ ድጋክናዋ ኮርኩክና አጃጃሞሶትዋ፥ ክርስቶስኒክ አጃጃሜፌትስንነ ፋሮን ማአ ንባክ አጃጃሞሶት። ");
INSERT INTO jnje_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","አጃጃሞቲስ ደይ ሀኦሲ ፍቃድኖን ንባስን ካብ ሳፋራክ ዎስቴሴፌ ክርስቶስኒ ዎስትኛሳማቶታኖ አሱኒን ግርሱክዋ እያት ቢስቶክ ዛጉትታዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","አሱኒክ ስኖይናሮን ዳሚሲክ ዎስቴት ፋትማቶ ዛግራ ግራክ ዎስቶት። ");
INSERT INTO jnje_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","ቦዝ ስንፌናክ ብርማዱ እሳ እሳርባስ ዎስቴና ማአ ዎስቶሲ ዎሱማኖን ዳሚስኪን ኤጴቶናማቶ አርፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","ዳምኒ ሜያነ! አሱኒ ስና ቢሬ ቴሹኖይ ንቶር ስና ዳሚስንናዋ ባሶር ስና ዳሚስንና ሳማክ ፌናማቶ ያዳቶክ ፎኮሮንትሶን ቤይፋት ቦዝኒቲሳክቶኒክ ማአ ዉዛ ዛጉትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","ኤሴ ሀን ባርስታን ፉእቴ ባሪክ ዳሚሲክናዋ ባሳ አካማ ሁግናሲክና ችምትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","ዳቡሎስኒ ማጙ ዎስቶሶን ቱጋኦ ችማትክ ሀኦሲ ኔቦኒ ሜያሶን ዙትራ ማይትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","እንኖ ኔቤፌኒ ኔቦስ አሱኒ ሜያኔን አነ ስኖይናሮን ሀን ታልማ ዳስታክ ዎስቴት ፌሴ ሀእሲፌ ባሶ፤ አእስኛኒ ሜናዋ ሀን ዳስታኪ ሁግናስኔንና ደይ ደን ሳማኪ ፋሴ ኪና አያናሲክቶኒ ታርኦስኔንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","ኤስ ባሪ ቦርኣ ማጙ ዎናሲክ ጉማንትሳ ሁግናኖን ዎልጉክ ችማትክናዋ ዙታምባሴ አሲን ዎስቶታ ፌሽራ ዛግራ የሮ ችማትክና ሀኦሲ ኔቦኒ ሜያኖን ዙትራ ካብጉትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","ኤሴ ፉቶሶን ዝናራ ዛግራ ጌሾንቲስታ ታርኤራ፤ ኦኮሶን ንባስታኪ ጥሩሪ ዛግራ ማይትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","ናጋኒ ምስራቹኒ ካማሶን ቻእማኒማቶ ዛግራ የርእአ ሆሬራ የሮትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","ኤስ ባርስታን ደናሎ ጌኒማቶ ሳምማ ዎባዎብቴት ፋ ዳቡሎስኒ ማጙኒ ዬጋሶን ዙትራ ትሽኩ ችማት አማንቶሶን ጌባኒማቶ ዛግራ ኤጵትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","ፋሩሶን ጉፍታ ዛግራ ቴትንትስታ ጉፎትዋ፤ ኤሲስማቶ ደይ ኮርቶ አያናስኪን ቤስቴፋ ሲፎሶን፤ ኤስ ባር ደይ ሀኦሲ ካማኖን ኤጵትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","ዎንና ዎንና ኮርቶ አያናሲክ ዞኑስቶክ ሺጶነዋ ማምሱነ አሲን ሀኦስኪ ታእሱት። ኤስ ባርክ ኮርቶኒ ሜያክ ጉዝራ ችምማ ሺጶት። ");
INSERT INTO jnje_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","ምስራቹኒ ካማሲ ዎሲ ስንናሲክ ሻሻራክ ታቴና ባሪ ኣቾ ቾዋኖን ድጋ ፎንቶኖን አምማኖን ክስራ ማኮናክ ካማ ታክ እምቶናክ ታክ ሺጶት። ");
INSERT INTO jnje_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","ኤስ ባሪ ቦርኣ ምስራቹኒ ካማሶን ማኮናክ ሾልሲናሲማቶ ድጋ ፎንቶኖን ማኮናክ ታክ ሺጶትዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","ሹንቶ አይኒስንናዋ ዳም የሱስኒ ዎስቶሲክ አማናምቶ ዎስትኛ ስና ትቂቆስ ታ ቾዋስ ኣካ ስንናማቶናዋ አዉ ዎስቴት ፋናማቶና ዙታምባሴ አሲን ንቶክ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ኤስ ባሪ ቦርኣ እንኖ ኣካክ ፋኒማቶ አሩትክናዋ ንቶትን ደይ ችኑናዎዋ እያቱ ባሪን ንቶኪ ዎስጝዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","ሀኦ አባሲክንናዋ ዳም የሱስ ክርስቶስኒኪንና ናጋነዋ ኬሽታንነ ደይ አማንቶስኔን አነ አይኒ ሜያክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","ማጁኖይ ወደይ ኮኡኖይ ኬሽታናሲክ ዳምኒ የሱስ ክርስቶስኒን ሹንፌ ባሶ ዙታምቤሲሴ አሲክ ባሳ ኦትማስ ባሶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","የሱስ ክርስቶስኒ ዎስትኛኒ ሜያ ስና ጳዉሎስኒኪንናዋ ትሞትዮስኒክንና ፍልጵስዩስኒ ካታማሲ ፌሴፌ የሱስ ክርስቶስኒክ አማነሬ ሀኦኒ አሱ ስና ባሶ ዙታምቤሲሴ አሲክ ደይ ቤቴክርስታኒሶን ሀእሲፌ ኩርኡኒ ሜያክናዋ ዳቆኝኚኒ ሜያክክና፥ ");
INSERT INTO jnje_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","አባኒስና ሀኦስኪንናዋ ዳም የሱስ ክርስቶስኪንና ኦቱምነዋ ናጋነ ንቶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","ንቶትን ያዳቴፋና ካባሲክ ዎንና ዎንና ሀኦናሶን ጋላቴፋዉጙዋ፥ ");
INSERT INTO jnje_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","ንቶ ዙታምኒትሴ አሲክ ሺጴፋና ካባ ዙታምባሴ አሲክ ሺጴፋና ሺጶናስ ግራክ ቱምቶዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","ቴሱኒ ዎናስታን ካብራ ሀሽ ሀውጙ ካርአና ካባኔን ምስራቹኒ ካማሶን ማኮክ ዎስቶናሶን አርጋሲር ስንነት ቦርአ ሀኦሶን ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","ሀን ማአ ዎስቶሶን ዎስቶትክ ዛግ ሀኦሲ፥ የሱስ ክርስቶስ ዎል ሌ ዮና ኮእኒ ዎናስታ ካቱናማቶ ማእስራ አርፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","ሀሽ ታቶኒ ኬር ፋና ካባሲክናዋ ታቶኒ ኬር ግሩኖይ ፋና ካባሲክና ምስራቹኒ ካማሲ ፉቶኖን ኦዳናክናዋ ኤስ ባሮን ደይ ችኑናክና ሀኦስ ኦቱምባሲክ ታክ እምና እጣሶን ንቶ ዙታምኒትሴ ሃኤር ስንነት ቦርአ ዎንና ዎንና ንብናሲቱ ፋሴትዋ። ኤስ ባሪ ቦርኣ ንቶ ቾዋሲክ ታክ ቤስቴት ፋ ባር ልኪዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","የሱስ ክርስቶስኒ ኬሽታናሲክ ንቶ ዙታምኒትሴ አሲን አዉነ ፋሮን ካልቴት ፋናማቶ ሀኦስ ታክ ዛላዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","ኬሽታኒትስ አሩክናዋ ያዳታክና ቱማ ስንና ድቼት ሀማናክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","ኤሲስ ደይ ማአር ስና ዉዛስ አዉ ስንናማቶ ቱንእራ አሩትክናዋ፥ ክርስቶስ ዎል ሌ ዮና ዎኖ ካይምናዋ ዝናንት ፎንቶና ስንና ቤስቶትክዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","ኤስ ባርክ ካኒትስ የሱስ ክርስቶስኒኪን ቤስቴፋ ኦኮ ስንና ዉዛሲክ ቱማር ስና ሀኦሲክ ኡልፍነዋ ጋላትነ እማር ስናትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","አይኒ ሜያነ! ታይስታ ካርአ ዉዛስ ምስራቹኒ ካማስ ማእስራ ታጉናክ ዛግናማቶ አሩትክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","ታ ደይ ታቴናስ ክርስቶስኒክ ዎስቴና ቦርአ ስንናማቶ ታቴ ሜኒ ማሳራሶን ኦደፌ ታሶኒ ሜናዋ ኦም አሱኒ ሜና ዙትቴሬ አርሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","ታ ታቶኒ ኬር ግሩሲ ቦርአ አማነሬ ፌ አይኒ ሜያስን ሾዎቤሲስ ዳሚሲክ ቴቶሶነክ ስኒዋ። ኤስ ባሪ ቦርኣ ሀኦሲ ካማኖን ድጋ ፎንቶኖን ማኮክ ዜሞቲስታን ዳይስሬ ችማ ዳነቴዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","ስኑንታኖ እሳ እሳ ሜያ ክርስቶስኒ ምስራቹኒ ካማሶን ማክሴፌስ ኮናክዋ፥ ኦምኒ ሜያ ደይ ታይስቱ ሜሮ ኡኒ ሳፋራክዋ፥ ስኑንታኖ ኦምኒ ሜያ ደይ ምስራቹኒ ካማሶን ማክሴፌስ ማአ ንባክዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","ኤስ ባሶ ሀኦሲ ካማኖን ማአ ንባክ ማክሴፌስ ኬሽታናክዋ፥ ባሶ ደይ ታ ምስራቹኒ ካማስ ፉቶ ትሹኖይናማቶ እያት ሀንታ ሀእቴናማቶ አርሴቴ ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","ስኑንታኖ ኤክ ባሶ ክርስቶስኒ ቾዋሶን ኤልጝሲሬ ማክሴፌስ ማአ ንባክ ስኖይናሮን ቴትኒ ሹናክናዋ ታ ታቶስታ ኦማ ራክኮ ዳይሱሶነክ ሳፋርሴፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","ማአ ንባክ ስኑን ማጙ ንባክ ክርስቶስ ማክቶባሲክ አካማኖን ግሬፋውጙዋ፤ ሀንኔን ደይ ግሮናርዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","ኤስ ግሬፋናስ ደይ ንቶ ሺጶሲክናዋ የሱስ ክርስቶስኒ አያናስ አሪጋሱሲክና ብርማዱምማ ኬሳናማቶ አሪፋና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","እሳንነ ኣፋ ኢቾናዉዛ ስንናማቶ አብድክቱ ኦድትፋዉጝዋ። ስኑንታኖ ዎንና ዎንና ዛግትፋናሲማቶናዋ ሀውጙ ደይ ካክ ፋፋናክ ወደይ ክትፋናክ ክርስቶስ ታይሲ ኡልፍንቶናዋ ይራ ድጎኖይ ማኬፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","ኤስ ባሪ ቦርኣ ታክ ካ ኡስ ክርስቶስኒክ ፎስዋ። ክቱስ ደይ ታክ ቡአዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","ስኑንታኖ ሀንታክ ካክ ፎኒሪ ስንፋናነ ጋንባሬ ዬሬ ዎስቶ ዎስቶናክ ሾልስፋዋ፥ ስንፋናክኑ ካክ ፎስታንናዋ ክቱስታንና ኣኣፋሮን ኮሩናማቶ ኣነ አሩትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","ኤስ ሄፕ ሳፋራሲክ ራካቴድፋን። እሳ ሀሚናሪክ ክርስቶስኔን አነ ፎስ ዙታምባሴ አሲስታን ደናሎ ስንና ቦርአ ሀን ካስታን ኦር ኬስሳ ክርስቶስኔን አነ ፎናክ ካልቴፋዉጝዋ፥ ኤሲስ ደይ ክርስቶስኔን አነ ፎስ አካማኖን ማአር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","ኦማ ኡግናክ ካክ ፎናስ ንቶክ አካማኖን ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","ኤስ ባሪክ ቴቶክ ክቱታስን ፉእቴራ አማንቶኒስ ድቻትክናዋ ግራ ዳናትክና ንቶ ዙታምኒትስኔን አነ ፎና ባሮን አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","ታ ሄፕሳ ዎል ላ ንቶኪ ያፋና ካባሲክ ታ ቦርአ ፋ ቴቶኒትስ የሱስ ክርስቶስኔን አነ ፎንትሲክ አርኩናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ኤሴ ዙታምባሴ አሲስታን ካንቲሲክ ክርስቶስኒ ምስራቹኒ ካማሲክ ሾልሱ ፎ ፎቲዋ። ኤስ ባር ደይ ታ ያራ ቢፋናክ ወደይ ዎክፋናክ እሳ አላማክ ችምሜ ዬሮንትሶንናዋ ምስራቹኒ ካማሶን እሳሪክ ካቱክ ካቦንትሶንና ኦዶናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","ንቶትን ቱጋእሴፌ ባሶትን እሳንነ ድጎቲታዋ፥ ስኑንታኖ ኤስ ችምኒትስ ባሶክ ትሹኒ ቤሶ ስንፋና ካባሲክ ንቶክ ሀኦስኪን እምቴ ፋሩኒ ቤስቶዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","ክርስቶስኒክ ዎስቶትክ እምቴ እጣስ ባሪክ አማኖትክ ኮእባ ስንኖይናሮን ባሳ ቾዋሲክ ሻና ኤጳቶትክነጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","ኤስ ባሪ ቦርኣቱ ሀሽ ታኔን አነ ሻናሶን ሃኤር ስንነትዋ፥ ኤስ ሻናስ ደይ ዜሞ ስናክ ታይስታ ካርእን ብየቲ ባሬዋ ሀሽኑ ደይ ታይስታ ካርኤት ፋናማቶ ኦደት ፋሴት ባሬዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","ንቶትና ንቶትና ክርስቶስኒክ ዎል ችኒት ፎስ ፋፋናነ፤ ኬሽታንባሲክ ደይ ችሜት ፋሴትር ስንፋናነ ደይ ኮርቶ አያናስኔን አነ እሳርኒት ፋፋናነ፥ ደይ ንቶትና ንቶትና ዎል ማአ ዉዛ ዛጉነዋ ኬናሽቶነ ቤሲፋትነ፤ ");
INSERT INTO jnje_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ኤስ ባሪ ቦርኣ ሳፋራክ፥ ኬሽታናክ፥ አያናክናዋ ማኣ አላማክና እሳር ስንና ታ ግራስ ቱማ ስናናክ ዛጉትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","ቴትኒ ዳ ኤጳ ኦም አሱኒ ሜያ ንቶስታን ዋያ ስንነቴማቶ ፋዱትታኖ ቴትኒሶን ሹናክ ወደይ «ታነ ፌ አስሱ ኣፌ» ይፋ ቴቶክ እሳ ዉዛነ ዛጉትታዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","ኤሲስማቶ አሱ እሳርባ እሳርባስ ባሳ ቴታክ ኬእኒ ዉዛሶን ኮእባ ስኖይናሮን ኦም አሱሲክ ኬእኒ ዉዛሶን ሳፋሮዎዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","ኤስ ባሪክ ክርስቶስ የሱስኒስሲ ፋ ሳፋራስ ንቶስሲ ደይ ፎናክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","ባር ሀኦኒ ሃላክ ፌፌት ሀኦስኔን አነ እሳ ኪጤ ስንኒ፤ ሀኦኒ ሃላሶን ሁግናክ ኤጳናክ ኣነ ሾሎዌ። ");
INSERT INTO jnje_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ኤስ ባርስታን ባርኪክ ፋ ኡልፍናሶን ዙትሬ ቤይየ፤ ቦዝኒማቶ ስንነ ቤስቴ፤ አሱኒማቶ ደይ ቤስቴሬ ኮንቴ፤ አሱኒ ግቶክ አምማኖን ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","ቴትባሶን ደይ ዳ ኤጲ፤ ክቱታ ካርአና ካባኔን፤ ኤስ ባርኑ ማስቃሊስታ ሱቴሬ፤ ክቱና ካባኔን አጃጃሜር ስኒ። ");
INSERT INTO jnje_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","ኤስ ባሪ ቦርኣ፤ ሀኦስ ዙታምባሴ አሲ ደናሎ፤ ባሪን ደን ቴግ። ሱና ዙታምባሴ አሲስታን ደናሎ፤ ስና ሱና ባሪክ እሚ። ");
INSERT INTO jnje_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ኤስ ባሪ ቦርኣ የሱስኒ ሱናሲ ኡልፍናክ፤ ሳማክናዋ ዳክና፤ ደይ ዳሲ ስካሎሲ ፋሴ ባርኪቶ ዙቴራ፤ ኬእባሲክ ባሪክ ካኖናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","አሱኒ ሜኒ ቴርማስ ደይ ዙቴራ፦ «የሱስ ክርስቶስ ዳምዋ» ይራ ዛልኒ ማኮክ አባ ሀኦሲክ ኡልፍና እምናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","ኮኒታሳክቶኖ! ታ ንቶኔን አነ ፋና ካባሲክ ዎንና ዎንና አጃጃሜር ስንነትሲማቶ ሀሽ ታ ንቶስታን ዎክፋና ካባሲክ ኤስ ባሪስታን ደናሎኖን አጃጃሜር ስንናትክ ያዳሲፋዉጝዋ፥ ኤስ ባሪ ቦርኣ እሳ እሳርኒትስ ፋሩንትሶን ቤስፋ ዎስቶሶን ድጋክናዋ ኡልፍናክና ችምማ ዎስቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","ኤስ ባሪ ቦርኣ ባር ስናናክ ሾሌፋና ባሮን ሾሎትክናዋ ዛጉትክና ንቶስሲ ዎስቴት ፋይስ ሀኦስዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","ኣፍፋ ዎስቶስኑ ዎስቴፌት ካባሲክ ኡኙሶቲታ ወደይ ካራካሮሶቲታ። ");
INSERT INTO jnje_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","ኤስ ባር ደይ ስንፋናነ ሀን ኤልጛ ማጙ ኮኒቶሲ ጋነሲ ዝናነዋ ሙዳነ ፎንቶ ካይም ሀኦኒ ናንጎታ ስንና ሀን ዳስታክ ባኩራኒማቶ ቻርሱትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","ኤስ ባር ደይ ስንናናስ ካ ቤስቴፋና ካማሶን ዬቱኖይ ማእስራ ኤጳትነዋ። ኤሲስማቶ ኤልናሴዋ ዎስቶናሴ ኬእኖር ስንና ፉእቶኖይናማቶ ክርስቶስ ዎል ሌ ዬፌና ካባሲክ ቴቶና ዉዝና ፋርዋ ኡዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","ሀኦሲክ ዎስቶኒትሴዋ አማኖንቲሴ አሲ ማኣስታ ታ ካስ ደይ ዳይስቴራ ማአ ስንና እምቴፋናነኑ ግሬፋውጙዋ። ንቶ ደይ ታ ግራሶን ሃኤር ስናትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","ኤሲስማቶ ንቶ ደይ ግሬራ ታን ደይ ግራንትሶን ሃኤር ዛጉትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","ታ ንቶ ቾዋሶን ኦደራ ግሮናክ ትሞትዮስኒን ታፕቴራ ንቶኪ ዎሱ ችማናክ ዳም የሱስኒክ አብድ ዛግፋንዋ ");
INSERT INTO jnje_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","ንቶ ቾዋሲክ ንባስን ሳፋሬፌስ ትሞትዮስቴኖ ኦም አሱታ ታክ ኣፌዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","ስኑንታኖ ኦም አሱኒ ሜያ ባሶ ቴታክ ኬእኒ ዉዛሶንቱ ዛጉክ ኤለፌታኖ የሱስ ክርስቶስኒ ዎስቶሲክ ግድቤስ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ትሞትዮስ አማናምቶ አስሱ ስኒባስ ፋታንቴራ ዛላ ማክቴር ስንናማቶ ታኔን አነ ደይ አባናዋ ናና አሲማቶ እሳር ስንና ምስራቹኒ ካማሶን አስሱክ አነ ዎስቴት ፋኒማቶ ንቶ ቴትንትሲክ አርሴትርዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","ኤስ ባሪ ቦርኣ ታ፤ ቾዋስ አይታ ሀምማ ካርእኒቶ አሪናኔን ኦርፎ ትሞትዮስኒን ታፕቴራ ንቶኪ ዎሱናማቶ አብድ ዛግፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","ኤሲስማቶኑ ታ ቴትናሲክ ንቶኪ ዮ ችማናክ ዳሚስ ታን አርጋሱናዋ ይራ አማነፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","ኤሲስማቶ ታክ ሾልሲ ዉዛ ዙታምባሴ አሲክ ታን አሪጋሱናክ ዎስሴት አይታ ኤጳፍሮድቱስኒን ዎልግራ ንቶኪ ዎሱና ባር ሾልሱ ስንና ታክ ቤስቴዋ፤ ባር ታኔን አነ ታርኤሬ የሬ ሜያ ታርኦናዋ ዎስቶኒ ዞሞታና ስንነ ዎስቴት ፌ አሱዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","ባሪን ንቶኪ ዎሱናስ ባር ንቶ ዙታምንትሴ አሲን ብያናክ ካልቴትና ቦርአናዋ ባሳ ሜቶሶን ደይ ንቶ ኦደሴቲ ቦርአ ድጌሬ ሳፋሬት ፌና ቦርአናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ፉቶሲክ ባር አካማኖን ሜቴሬ ክቱናክ ካርእዋ፤ ስኑንታኖ ሀኦስ ባሪክ ፋክያ ዛጊዋ። ኤስ ባር ደይ ባር ባሪክ ኮእባ ስኖይናሮን ሱሞስታ ሱሞ ታይስታ ኮፑክቶኖይናማቶ ታክኔንቱ ሀኦስ ፋክያ ዛጊዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","ኤስ ባሪ ቦርኣ ባሪን ቢራ ግሮሶትክናዋ ታ ሱሞስ ደይ ካሾናክናቱ ባሪን ንቶኪ ዎሱናዋ ይራ አካማኖን ሾሌጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ኤሴ ዳሚስን አማነሬ ፌ አሱ ስንና ቦርአ ግራክ ኤጳቶትዋ፥ ባርነ ፌ ኦም ሜያኖን ዙትራ ኡልፍንሱትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","ንቶ ታእሴራ ቤስቴራ ታክ ዛጉ ቤየቲ አርጋሱሶን ባር ታክ ቱኑክዋ እያት ክርስቶስኒ ዎስቶሲ ቦርአ ካባሶንኑ ኬሽቶኖይ ክቱታ ካትሬ ፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","ኮእባስታክ አይታሳክቶኖ! ዳሚሲክ ግሮትዋ። ኤስ ዜሞቲ ንቶክ ትችና ዉዛሶን ሄፕሳ ደይ ዎልግራ ንቶክ ትችፋናነ ታን ኣነ ኦምሱዋዋ። ኤስ ባር ደይ ንቶትን ኤሻስን ኦዳናክ ችማናክዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","ካንኒማቶ ሃነት ፌሴ ማጙ ዉዛሶን ዛግሴፌ ባሶስታን ቴትንትሶን ኦድት፥ ሃርኮ ኩኑ ሾልሱዋ ይሴፌ ባሶስታን ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","እንኖ ሀኦሶን አያናክ ሺጴት ፋኒስ ጌሮኪ ቢስቶኒ ስትሪሲክ ስኖይናሮን የሱስ ክርስቶስ ባር ባሪክ ቴቴት ፋኒር ስንና ቦርአ ፉቶሲክ ሃርኮ ኩንዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","ቴቶክ ሾልስር ስንፋናነ ታ ሾዎ ዉዛክ ቴቶናክ ችማናዋ፤ ጌሮኪ ቤስቴፋ ስትሪሲክ ቴቴፌ አሱ ፌፋናነ ታ ባሳስታን ደናሎኖን ቴቶና ዉዝና ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","ታ ኮንቴናሪ ናጝንሲናሪ ዎኖቱ ሃርኮ ኩንኒዋ፤ ኮንቶናሲክ ደይ ብንያምኒ አስቴሴሪስን ስና እስራኤላዊዋ፥ ኤስ ባርስታን ካብ ቾዋ ታ እሳ ሙዳባ ፎንቶ እብራዊዋ፥ አይሁድኒ ቱማሲ ኦድኒ ቾዋሲክ ስንፋናነ ታ ፌርሳዊዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","አይሁድኒ ሜኒ ሀይማኖትሲ ቾውኒ ኮኖክ ስንፋናነ ቤቴክርስታኒሶን ቦጌት ፋናርዋ፥ ቱማሶን ኦድደ ኦኮ ስንኒ ቾዋሲክ ስንፋናነ ዝናባ ፎንቶኖንቱ ፋፋጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","ኤስ ዜሞ ስንናክ ታክ ኬእኒርዋ ይራ አማነት ፋና ዉዛሲክቶ ዙቴራ ክርስቶስኒ ቾዋሲክዋ እያት ኬእኖይ ዉዛ ዛግራቱ ፋድጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","ኤስ ባርስታን ኦማ ዳምታ የሱስ ክርስቶስኒን አሩስታን ደናሎ ኦማ ዉዛ ኣፋ ስንናማቶ አማነፋና ቦርአ ዙታምባሴ አሲን ኬእኖር ዛግራቱ ፋድጝዋ፤ ባሪክዋ እያት ዙታምባሴ አሲን ቱርኪን፤ ክርስቶስኒን ዳናክዋ እያት ዙታምባሴ አሲን ዲማ ዛግራ ፋድን። ");
INSERT INTO jnje_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","ኤሲስ ደይ ቱማሲማቶ ፋ ታ ኦኮሶን ቤይፋት አማንቶሲማቶ ፋ ሀኦሲ ኦኮኖን ክርስቶስኒን አማንቶክ ዳናናክናዋ ባርኔን አነ ደይ ፎናክናቱ ዛግንዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","ክርስቶስኒንናዋ ክርስቶስኒ ክቱን ካቡኒ ሁግናሶንና አሩናክና፥ ሻናባሶን ደይ ሃኤር ስናናክናዋ ክቱባሲክኑ ደይ ባሳይሲማቶ ስናናክናቱ ካልቴፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","ኤሲስማቶ ደይ ክትናኔን ኦርፎ ካብራ ካክ ፎና ባሮን አብድ ዛግፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","ሀን ባሮን ዙትራ ሀሽኑ ኣነ ኤጱትዋ፥ ወደይ ሀን ባሪክቶ ዙታምባሴ አስን ዳንጝዋ ኡክ ኣፋ ችማናዉዛ። ስኑንታኖ የሱስ ክርስቶስ ታን ባሳር ዛግሬ ታክ ሆሲና ዎሱማሶን ዳናናክ ኤክ ስና ኤላናክቱ ዱዶናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","አይኒ ሜያነ! ሀሽኑ ታ ሀምማ ካርእጝዋ ይራ ኣፋዋ ፋዱናዉዛ፥ ስኑንታኖ እሳ ዉዛቱ ዛጉናዋ፥ ኦርፎናክ ፋ ባሮን ዳጌት ስንናስታኪ ፋ ባርኪ ሀምማ ካርአናክ ሾጞናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","ዎሱማናሶን ዳናናክ ስንናስታ ፋ ኮእኒ ድማስታ ሀምማ ካርአናክ ኤላናዋ። ኤስ ዎሱማስ ደይ ሀኦስ ክርስቶስ የሱስኒኪ ካሞ ታክ ደን ሳማክ እማና ኮእባ ፎንቶ ካስዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ኤሴ አያናኒ ፎሲክ ችማ እንኖ ኤስ ኤፋቴና ያዳታስ እኖኪክ ፎናክ ሾልሱዋ፤ ንቶትን ኦር ኦር ክሱኒ ሳፋራ ጋነንትስሲ ፋፋናነ ኤስ ሳፋራሶን ሀኦስ አምማ ንቶክ ዛጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ኣፍፋርኑ ስኑን ሀኦስ እኖክ አምማኖን ቤስና ፉቶሲክ ኤክ ስና ሀማኒዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","አይታሳክቶኖ! ታ፤ ቤስና ዛልፋሲክ ዞኑስቶትክ ማእ ኡትዋ፥ እንኖ ቤሲኒ ዛልፋሲክ ዞኑስቴሴፌ ባሶትን ደይ ማእስራ ቢትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","ዜሞ ስናክ ሾዎ ካባ ንቶክ ማኬናሲማቶ ሀሽኑ ደይ ሀራፍናሶን ዉኪት ማኮናዋ፥ ሾዎኒ ሜያ ፌሴፌ ፎቤሲሲክ ክርስቶስኒ ሜስቀሊሲ ጉማ ስነቴዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","ካትቤሲስ ባሶክ ሀኦቤስዋ፤ ኢቹ ዉዛስ ባሶክ ኡልፍንቤስዋ፥ ሳፋራቤሲስ ደይ ሀን ዳስታኪርዋ፥ ኤስ ባሪ ቦርኣ ባሶ ኮኣስ ደይ ትሹዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","ስኑንታኖ እንኖ ዳኒስ ደን ሳማዋ። ደኑን ዮኒ ፋትር ስና ዳም የሱስ ክርስቶስኒንቱ ካልታናክ ኦደት ፋኒዋ። ");
INSERT INTO jnje_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","ባር ሀን ኩፕኒ አቱኒሶን ሶሎክ ባሳ ኡልፍንኒ አቱሲማቶ ስናናክ ዛጉናዋ፤ ኤስ ባሮን ደይ ዛጉናስ ዙታምባሴ አሲን ሀእሱኒ ሁግናባሲ ስካሎሲ ዛጉናክ ባሪን ችኒፋ ሁግናባሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","ሹንፋና ንቶ፤ ካልቴፋና ግራናሴዋ ቴቶናሴ ስና አይታሳክቶኖ! ዳሚሲክ ችምማ የሮትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ኤዎድያነዋ ሲንጥክያነ ባሬ ባሬ ዳሚሲክ ኤቴ ኤቴ እሳር ስንነራ ፎሶናክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","ኤስታክ ፌ አማንቶ ዎስቶኒ ዞሞታ ስና ነ ደይ ኤስ ማሽካሱሲክቶኖን አርጋሱታክ ሺጴፋዉጙዋ። ኤስ ማሽካሱሲክቶ ታኔን አነ ቀለሜንቶስኔንናዋ ሱንቤሲስ ካኒ ማፃፋስሲ ትቼና ኦም ዎስቶኒ ዞሞታሳክቶኔንና አነ ስነራ ምስራቹኒ ካማሶን ካቱክ ካቤሴዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ዳሚሳር ስነቲ ቦርአ ዎንና ዎንና ግሮትዋ። ሄፕሳ ዎላ ደይ «ግሮት» ይፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","ጋራምኒትስ አስሱ ዙታምባሴ አሲክ አርቴር ስኑን። ዳሚስ ዎል ሌ ዮናክ ታእሴዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","ኤስ ባሪ ቦርኣ ዙታምባሴ አሲክ ሺጶክ፥ ኖነሬ ሺጶክናዋ፥ ጋላታክና ሀኦሲ ስና ታእሱትታኖ እሳ ዉዛክኑ ራካቶቲታዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","አሱኒ ያዳታ ዙታምባሴ አሲስታን ደናሎ ስና ሀኦሲ ናጋ ንብንትሶንናዋ ካኑንትሶንና የሱስ ክርስቶስኔን አነ ስነቲ ቦርአ ንቶትን ኦዳናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","ካኑንቲስ ሀን ባር ዙታምባሴ አሲስታን ደናሎ ስና ባሪክናዋ ጋላትባሬ የሬ ማአ ዉዛሲክቶክና ቱምማ ፋር ስኑንዋ። ኮእባስታክ ደይ አይኒ ሜያነ! ፉቶ ስና ባሮን፥ ኡልፍንባ ፋና ባሮን፥ ልኪ ስና ባሮን፥ ካይማ ስና ባሮን፥ ግርሱኒ ውዛ ስና ባሮንናዋ ማአር ስና ዉዛሶንና ዙትራ ሳፋሮትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","ታኪን አርሴት ባሮንናዋ ኤጳ ታሴት ባሮንና ደይ ታኪን ኦደሴት ባሮንናዋ ብየሴት ባሮንና ዙትራ ዛጉትዋ። ናጋኒ ሀኦስ ንቶኔን አነ ደይ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","ሾዎ ዎናኔን ኦርፎ ሄፕሳ ታ ራክኮሶን ሳፋሬሴቲ ቦርአ ዳሚሲክ አካማ ግራ ግሬጝዋ። ኤስ ባሮን ደይ ይናስ ሳፋሬት ባሮን ዎስቴሬ ቤሱክ ማአ ኡግና ኣነ ዳነትዋ ኡናታኖ ታ ራክኮሶን ሳፋሮ ቤይትዋ ኡናታዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","ደይ ኤስ ባሮን ይፋናስ ቱርኪና ቦርአታዋ፤ ታ፦ «ታክ ፋ ባር ሆሮና» ኡሶን አሪራ ፋናርዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","ኤስ ባሪ ቦርኣ ዳናሶን ስኑን ቱርኩሶን አሪናርዋ። ኣፍፋ ድማስታንኑ ስኑን ኣፍፋ ካባስታክኑ ሜሬ ጋዉነዋ ማክቶነ አሲን ደይ ዳንነዋ ቱርኩነ አሲ ቾዋኖን አሪንዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","ሁግና ታክ እምፌ ክርስቶስኒክ ዙታምባሴ አሲን ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","ስኑንታኖ ንቶ ራኮናሶን አርጋሲር ስነቲ ቦርአ ማአ ውዛቱ ዛግሴትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","ምስራቹኒ ካማሶን ማኮናክ ቴሲራ ሜቀዶኒያ ኬስፋና ካባሲክ ንቶ ፍልጲስዩሱክ ፌሴ ቤቴክርስታኒስቴኖ እማክ ስኑን ኤጳክ ታኔን አነ እሳር ስንነ ዎስቴር ኦም ቤቴክርስታኒ ኣፋ ስንናማቶ ንቶ ቴትንትሲክ አርሴትርዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ቴሴሎንቄክ ፋና ካባሲክ ታክ ሾልሱ ዉዛሶን አርሴራ ሄፓ ሄፓ ዎል ላ ታን አርጋስሴትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","ኤስ ባሮን ደይ ኡናስ ንቶ እማሶን ኤጳናክ አካማኖን ሾሌና ቦርኣ ስኖይናሮን አሱኒክ እምኒትሲ ጋና አርኩናክ ሾሌፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","ታክ ሾልሲ ኣባሮንናዋ ታክ ሾልሲ ባርስታን ደናሎኖንና ጋፉክሴት እማሶን አፍሮድቱስኒ ኩሹስን ኤጲጝዋ። ኤስ ንቶ እማሲ ማአ ሳዉባ ፋና ማኣሲማቶ ሀኦስ ኤጳ ታራ ደይ ግሮናርዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","ኤስ ባሪ ቦርኣ ሀኦናስ ኦቱምባሲ አርኩኒማቶ የሱስ ክርስቶስኒኪ ካሞ ንቶክ ሾልሲ ባሮን ዙትራ ንቶክ ቱኑናዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","አባኒሲክናዋ ሀኦኒሲክና ኮእባ ፎንቶኖን ኡልፍና ባሪክ ስንፋውጝዋ፤ ኣሚን። ");
INSERT INTO jnje_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","አማኝኒ ሜያ ዙታምቤሲሴ አሲክ የሱስ ክርስቶስኒ ሱናሲክ ናጋ ካቱትዋ። ታኔን አነ ፌሴ አይኒ ሜያ ደይ ናጋ ዎስሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","ኦም አማኝኒ ሜያ ዙቴሬ አርክሮን ደይ ሮምኪ ታቴ ሜኒ ታቶሳ ኬርኪ ሜያ ስና ባሶ ናጋ ዎስሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","ዳም የሱስ ክርስቶስኒ ኦትማስ ንቶኔን አነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","ሀኦኒ ሳፋራሲክ የሱስ ክርስቶስኒ ዎሲ ስና ጳዉሎሲኪንናዋ አይኒ ስና ትሞትዮስኒኪንና። ");
INSERT INTO jnje_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","ቆላሲያሱክ ፌሴ ክርስቶስኔን አነ ፎክ አማናምቶ ስና አማኝኒ ሜያክ አባኒ ስና ሀኦስኪን ኦቱምነዋ ናጋነ ንቶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","ንቶክ ሺጴፌኒ ካባሲክ ዳም የሱስ ክርስቶስኒ አባ ስና ሀኦሶን ዎንና ዎንና ጋላቴፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","የሱስ ክርስቶስኒስታ ፋ አማንቶኒትሴዋ አማኝኒ ሜያ ዙታምቤሲሴ አሲክ ቤሴስቲ ኬሽታናሴ አሲን ኦደኒዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","ፉቶኒ ካማ ስና ምስራቹኒ ካማስ ዜምማ ንቶኪ ካርፋና ካባሲክ ኤስ ባርስሲ ፋ አብዲሶን ኦደትዋ፥ ኤስ ባሪ ቦርኣ አማንቶኒትሴዋ ኬሽታንኒቲሴ ካፑቴራ የሬናስ ደን ሳማኪ ሆሬራ ንቶትን ኦድኒ አብዲስታዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","ንቶ ምስራቹኒ ካማሶን ኦደሴቲ ዎኖኔንናዋ ሀኦሲ ኦትማ ፉቶ ስንናማቶ አሪቲ ዎኖኔንና ካብግራ ሀን ምስራቹኒ ካማስ ንቶ ጋነያሲክ ዳ ዙታምባሴ አሲስ ጋንባ ጋነት ደይ ታግቱ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","ኤሲስ ደይ እንኖ ኤዴ አማንቶ ክርስቶስኒ ዎስትኛ ስንና እኖኔን አነ ደይ ዎስቴፌ ሹንቶ ኤጳፍራ ንቶክ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","ኤሲስማቶ ደይ ባር ሀኦሲ አያናክ ንቶክ እምቴ ኬሽታናሲክ ንቶትና ንቶትና ዎል ኬሽቴት ፋትማቶ እኖክ ማኬዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","ኤስ ባሪ ቦርኣ እንኖ ኤስ ባሮን ኦደኒ ዎናስታን ካብግራ ንቶ አያናኒ ፎሲ ቴችማክናዋ ያዳታክና ሀኦሲ ሳፋራኖን ጋሳሱክ ቱማ አሩኒት ፎናክ ንቶክ ሀኦሶን ሺጶ ኣነ ቤየኒዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","ኤሲስማቶ ደይ ዳሚሲክ ሾልሱ ስና ፎ ፋራ ባሪን ግርሱትክ ደይ ማአሪ ስና ዎስቶኒ ዎስቶክ ጋና ጋናትክናዋ ሀኦሶን አሩክ ድቼት ሀማትክናቱ ሺጴፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","ዳሚስ አካማ ቴጋ ሁግናባሲክ ችምባሶን ዙትሬ ንቶክ እሞዎዋ። ዙታምባሴ አሲን ፋክያክ ችምማ ግራክ ሆሬሬ ፌር ስንናትክ ንቶትን ዛጋዎዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","ደይ ቻሬፋሲ ታቶሲ ኮርቶኒ ሜያኔን አነ ሃኦ ዳናትክ ንቶትን ዛግ አባ ሀኦሶን ጋላቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","ባር ታልማሲ ሀእሱኒ ሁግናስን ፉኤራ ሹንቶ ባሪ ናሳ ታቶሲ ግሩኒክ ዛግ። ");
INSERT INTO jnje_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","ባር እኖትን ፉሬን ቦርኒሲ ፋክያኖን ዳንኒዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","ክርስቶስ ቢስቶኖይ ሀኦሲክ ፉቶኒ ቤሶዋ። ባር ቴስቴ ቴስቶ ዙታምባሴ አሲስታን ደናሎ ደይ ኡዙንዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","ደን ሳማክናዋ ሀን ዳስታክና ፋ ባር ቢስቴፋ ባሬዋ ቢስቶኖይ ባሬ፥ ሳማኪ ሁግናሴዋ ዞንስፌ ባሶትና፥ ጋኜ ሜናዋ ሀእሱኒ ሁግናቤስ ፋና ባሶትና ዙታምቤሲሴ ቴስቴሴቴስ ባርክዋ፥ ሀኦስ ዙታምባሴ አሲን ቴስናስ ባርኪ ካሞናዋ ባርኪክናዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","ክርስቶስ ዙታምባሴ አሲስታን ዜምሜ ፌርዋ። ስና ቾዋ ዙታምባሴ ዎል ኤጴራ የሬናስ ባርክዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","ባር ባሳ አቱ ስና ቤቴክርስታኒሲ ቴትዋ። ዙታምባሴ አሲክ ስና ዜምማር ስናናክ ክቱን ካቡባሲክ ደይ ቴሱኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","ኤስ ባር ደይ ባሪ ቱማ ውዛስ ናባሳታ ፎናክ አባ ሀኦሲ ፍቃድዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","ባርኪ ካሞ ደን ሳማኮ ስኑን ሀን ዳስታክ ፋሴ ዉዛሲክቶኖን ዙትሬ ሀኦሲኔን አነ ጋንሲዋ። ማስቃሊስታ ዉክቴ ናባሳ ሀንናክ ናጋ ዛግዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","ንቶ ደይ ዜምማ ሀኦስታን ዎካ ፋሴትርዋ። ንብንትስ ደይ ማጙ ሳፋራክናዋ ማጙ ዎስቶኒትሲክና ካብ ቾዋ ሀኦሲ ጉማ ስንና ፋሴትርዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","ስኑንታኖ ሀሽ ንቶ ኮርቶኒ ሜናዋ ካይምኒ ሜና፥ ደይ ዝናባ ፎንቶ አሱ ዛግራ ስንባ ታእሱናክ ናባስ አሻክ ክቱባስታን ካብ ቾዋ ሀኦስ ባርኔን አነ ንቶትን ጋንስዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","ኤስ ባር ደይ ስናናስ ምስራቹኒ ካማስኪ ካሞ ቤስቴ አብዲሲክ አማንቶክ ዛግራ ዬሬፋትነ ኮእባዋ። ኤስ ኦደት ምስራቹኒ ካማስ ሀን ዳ ዙታምባሴ አሲስታ ፌሴ አሱኒ ሜያክ ማክቴ ባርዋ። ታ ጳዉሎስ ደይ ሀን ምስራቹኒ ካማሲክቱ ዎስትኛ ስንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ሀሽ ንቶ ቦርአ ኤጳታና ሻናሲክ ግሬፋውጙዋ። ባሳ አቱ ስና ቤቴክርስታኒሲክ ክርስቶስ ኤጴቴና ሻናስን ዮእ ባሮን አሽናሲክ ቱኑናዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","ሀኦሲ ካማኖን ዙትራ ንቶክ አምማኖን ኮታ ማኮናክ ሀኦስኪን ታክ እምቴ አዳራሲማቶ ቤቴክርስታኒሲክ ዎስትኛ ስንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","ኣታ ነያሲክ ሀኦሲ ካማ ኮንቶሲክ ኣቼራቱ ፋዋ። ስኑንታኖ ሀሽ ሀኦስ አማነፌ ባሶ ዙታምቤሲሴ አሲክ አምማኖን ክስራ ቤስዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","ሀኦስ ደይ ኮርቶኒ ሜያክ አምማኖን ክስራ ቤሱናክ ሾሌናስ ሀን ኣቾ ቾዋሲ ኡልፍንኒ ኦትማስ ኣዛብ ስና ንቶ ጋነያስሲ አዉነ ፋ አካማ ስንባሶንጝዋ። ኤስ ኣቾ ቾዋስ ደይ አብድክ ኦዴት ፋኒ ኡልፍናስ ቤስቴፋና ክርስቶስ ንቶስሲ ፎባስዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","አሱ እሳርባ እሳርባስ ክርስቶስኒክ ችምሜ የሬ አሱ ስንነ ቤስቶናክ ዛጉኒክ አሱ ዙታምባሴ አሲክ ቴችማሶን ዙትራ አሱኒክናዋ ኬኡክናቱ ክርስቶስኒ ቾዋሶን ማኬፌንዋ። ");
INSERT INTO jnje_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","ሀኦሲ አካማ ሁግናባሲክ ታይሲ ዎስቴት ፋና ቦርአ ኤስ ሁግናስኪ ካሞ ኤስ አላማባስ ኮኡናክ ካቤት አካማኖን ሆፕድፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","ንቶክናዋ ሎዶቅያክ ፌሴ አሱኒ ሜኒ ቦርአና ኤሲስማቶ ደይ ኣፌ ኣፌ ኡጰራ ቢኖይኒ አሱኒ ሜያክኔን አዉነ ፋ አካማ ካቦ ዛግት ፋናማቶ አሩትክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","ካቤት ፋናስ ደይ ንብቤሲስ ችማ ዳናናክናዋ ኬሽታናክ እሳር ስኖነክና ደይ ፉቶኒ ያዳታ ዳነሬ ሀኦሲ ኣቾ ቾዋ ስና ክርስቶስኒን አርሶነክዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","ቴችማሴዋ አሩኒ ኦትማሴ ኣቸራ ፋናስ ክርስቶስኒሲዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","ኤስ ባሮን ደይ ንቶክ ማኬፋናስ ኦኑ ሺማ ዎላክ ንቶትን ኤሽኖይናማቶዋ እያትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","አሻክ ንቶስታን ዎክፋናክኑ አያናክ ንቶኔንቱ ፋዉጝዋ። ስትሪክ ፎንትሴዋ ክርስቶስኒስታ ፋ ችማ አማንቶኒትሴ አስን ብያት ግሬጝዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","ዳም የሱስ ክርስቶስኒን ኤጳ ታሴትማቶ ደይ ባርኔን አነ እሳሪክ ፎሶት። ");
INSERT INTO jnje_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","ባሳስታ ካፑቴራናዋ ችማና አርሴት አሩሲማቶ አማንቶኒትሲክ ችምማ ፎሶት። ቱምማ ፉእቴ ጋላታ ባርኪ እሞት። ");
INSERT INTO jnje_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","ክርስቶስኒስታ ካፑቶኖይ አሱኒ ሜኒ ቱማስታናዋ ሀን ዳስታኪ ኬኖይ ሲትርስታና ካፑታራ የሬ ደይ አሱ ክሲና ሺማ ኤሻክ ኦኑ ንቶትን ኤሽኖይናማቶ ቴትንትሶን ኦድትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","ሀኦሲ ኦ ስንናማቶ ቱማ ፋናስ ክርስቶስኒስዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","ንቶ ደይ ቱማ ካ ዳነትስ ቴስቶ ዙታምባሴ አሲስታ ሀእሱነዋ ሀእሱኒ ሁግናስ ቴት ስንና ክርስቶስኒክጝዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","ባርክ አማንቶኒትሲክ ሃርኮ ኩነትዋ። ኤስ ኩነት ሃርኮስ ቦርባ ፋና አማላሶን ትሽኩክ ክርስቶስኒኪ ካሞ ዛግቴ ዉዛታኖ አሱኒ ኩሹክ ዛግቴ ዉዛታዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","ሀጱክቴሴፌት ካባሲክ ክርስቶስኔን አነ ካባርቴሴትዋ። ባርኔን አነ ደይ ክቱኒ ካብሴትዋ፤ ክቱን ካብሴትስ ደይ ክርስቶስኒን ክቱኒ ካብግ ሀኦሲ ሁግናክ አማነሴት ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","ቦርአ ዎስቴሴት ቦርአናዋ ቦርባ ፋና አሽንቲስ ክርስቶስኒን አማኖክ ሃርኮ ኩኑ ቤይና ቦርአና አያናክ ክቱ ስንና ፋሴትር። ስኑንታኖ ሀሽ ሀኦስ ክርስቶስኔን አነ ንቶትን ሀየዋ ዛጊዋ። ቦርንትሶን ደይ ዙትራ ፌሹን ይዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","ባር ኤስ እኖትን ማላቴት ፋ ባሬዋ እኖትን ቱጋኤት ፋ ቱማሲኪ ኮዋኒ ትቻኖን ዙትሬ ኩኤ ትሽኪዋ። ማስቃልስታ ሙስማርሲክ እቼሬ ሱቴሬ እኖስታን ካብግዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","ሁግናሲክቶኖንናዋ ሀእሲፌ ባሶትንና ማስቃሊሲክ ሜሬሬ ታርኤሴቴ ሜኒ ታርኦሶን ኮትሲናኔን ኦርፎ ኩሹ እማር ስኖቤሲሶን አምማኖን ኬሳ ቢስቶናክ ዛግዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","ኤሴ ሙክ ወደይ ኡሻክ ኤቦሶን ኡልፍንሱክ ወደይ ቴስራ ቤሲ አሳሶን ወደይ ቤይሳኒ ዎናሶን ኡልፍንሱኒ ቾዋሲክ ኦኑ ንቶስታ ማጝሱ ካርአናታዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","ኤስ ባር ዙታምባሴ ሀኔንት ዮኒ ባሪ ይራራዋ። ስኑንታኖ ፉቶስ ክርስቶስዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","ስንኖይ ጋራምነዋ ሀኦሲ ዎሲያኖን ሺጶክ ቴቴፌ ባሶ ዋግባ ፎንቶ ዛግሬ ንቶትን ፉእሶኖይቴማቶ ቴትንትሶን ኦድትዋ። ኤስ ኤፌ አሱስ ቢፌና ራእሲክ ቴትባሶን ደን ቴግፋት ስንኖይ ሺማ አሽኒ ሳፋራክ ቤጋንቴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","ኤስ ኤፌ አሱስ ቴት ስና ክርስቶስኔን አነ እሳርባ ኣፋዋ። አቱ ዙታምባሴ አሲክ ኬኦባ ኬኦባሲክናዋ ታስባ ታስባሲክና እሳ ዳ ቱስራ ማሲፋስ ቴታስዋ። አቱ ዙታምባሴ ድቻናክ ሀኦስ ዛግፋናስ ኤሲስማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","ክርስቶስኔን አነ ክትራ ሀን ዳስታኪ ኬኖይ ስትሪስን ኦር ኬሴትኔን ሀሽ አዉኒ ቦርአ ሀን ዳስታኪ ዉዛስን ኦር ኬስኖይነ ፌር ስንና ኤፋቴና አጃጂሲክ ሀእፌትሶ? ");
INSERT INTO jnje_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","ኤስ አጃጂስ ደይ፦ «ኤጳታታ፥ ቤቹታታ፥ ዞጉታታ» ይፋ ባርዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","ኤስ ባር ዙታምባሴ አሱ ቱሜና ስትሪነዋ አስሱነ አሲስታ ካፑቴራ የሬር ስንና ቦርአ ዎስቶታ ፌሽናኔን ኦርፎ ትሹኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","ኤስ አጃጂሲክቶ አሱኒ ንብታን ካብ ሺጶነዋ ስንኖይ ጋራምነ ደይ አቱኒ ሚርእኦክ የሬር ስንና ቦርአ ቴቹምባ ፋርነ ፋር ስንና ቤስቶናክ ችማናዋ። ስኑንታኖ አሽኒ ካልታናሶን ኦዳክ እሳርነ ኣነ ኬእፋዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","ኤሴ ክርስቶስኔን አነ ክቱን ካብሴትኔን ክርስቶስ ሀኦሲ ኦእታ ቴሽታ ዲና ድማስታ ደን ሳማኪ ፋ ዉዛሲክቶኖን ሾሎትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","ዎንና ዎንና ደን ሳማኪ ፋሴ ዉዛሲክቶኖን ሳፋሮትታኖ ሀን ዳስታኪ ፋ ዉዛሲክቶኖን ሳፋሮትታዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","ንቶ ቦርባ ፋና አሽኒትሲክ ክትቲዋ፤ ካንትስ ክርስቶስኒኪ ካሞ ሀኦስኪ ኣቼዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","ካንት ስና ክርስቶስ ዬፌና ካባሲክ ንቶ ደይ ባርኔን አነ ኡልፍናክ አምማኖን ኬስሳ ቤስቶትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","ኤስ ባሪ ቦርኣ ንቶስሲ ፋሴ ሀን ዳስታኪ ፎኒ ኤናንቶሶን ዙትራ ዎሩትዋ፥ ኤስ ባርኪቶ ደይ፦ «ጌርኬሳ፥ ኪና ዎስቶ፥ እጉ፥ ማጙ ካልታና፥ ኮልኦኒ ሺጶነ ፋ ኤናንቶስዋ» ");
INSERT INTO jnje_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","ኤስ ዉዛሲክቶኒ ቦርአ ሀኦሲ ግኢአ ሀኦሲክ አጃጃሞኖይ አሱኒ ሜያስታ ዮኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","ንቶ ቴትንትሲክ ደይ ዜሞ ስናክ ኤስ ዉዛሲክቶኖን ዛግት ፋሴትርዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","ስኑንታኖ ሀሽ ግአሶን፥ ሃሪሶን፥ ኑሩሶን፥ አሱኒ ሱንኒ ማጝሱሶን ንቶስን ትሽኩትዋ፤ ኢቹ ዎላኑ ኖኖንትስን ኬሳናታዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","ኩርኡ አማላሶን ዎስቶባስኔን አነ ጋአኣ ሀእሴት ቦርአ ንቶትና ንቶትና ኤሻ ዎላ ዎሎትታዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","ቴሲ ሀኦሲ ግቶክ፤ አሩክ፤ ጋድዶ ስነት ሀምፋ ጋድዶ አማላሶን ማይትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","ኤስ ጋድዶ ካስሲ ግሪክኒ ዳኒ አሱ ወደይ አይሁድኒ ዳኒ አሱ፥ ሃርኮ ኩና አሱ ወደይ ሃርኮ ኩኖይ አሱ አሩባ ፎንቶ ወደይ አሩባ ፌናር፥ ሀኦ አሩኖር፥ ብርማዱምማባ ፌናር ወደይ ብርማዱምማባ ፎንቶ አሱሳ ጋነያሲ ኮርቶባ ኣፋዋ። ክርስቶስ ዙታምባሴ አሲክዋ፥ ደይ ክርስቶስ ዙታምባሴ አሲስቱ ፌፌዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","ኤሴ ሀኦስ ኮሪና ንቶትናዋ ኮርቶኒ ሜና፥ ሀኦሲክ ሹንቶ ስነትስማቶ ኬናሽቶሶን፥ ጋራማሶን፥ ቴትኒ ዳ ኤጳሶን፥ ማኣሶን ፋክያሶን ማይትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","ንቶትና ንቶትና ዎል ችኒት ንቶስን እሳይስ ኦሚሳታ ግእቴና ዉዛ ፋፋናነ ዎል ፌሹን ኡትዋ። ዳሚስ ንቶትን ፌሹን ይናሲማቶ ንቶ ደይ ዎል ፌሹን ኡትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","ኤስ ባርስታን ደናሎ ዙታምባሴ አሲን ዙትራ ታርአ ዮኡባ ፎንቶኖን እሳር ዛግፋ ኬሽታናሶን ማይትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","እሳ አቱኒ ብልት ስንና ፉቶክ ቴግቴቲስ ሀን ናጋሲክ ስንና ቦርአ ክርስቶስኒ ናጋስ ንቶ ንባስሲ ታትቶን፤ ሀኦሶን ደይ ጋላቴር ስኒት። ");
INSERT INTO jnje_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","ክርስቶስኒ ካማስ ንቶ ንብባሲ ቱምማ ፎን፤ ቴችማክ ንቶትና ንቶትና ዎል አሩት፤ ደይ ሜርኮት፤ ጋማክናዋ ካጵሱክና ደይ ካይማ ዌእሶክ ሀኦሶን ፉቶክ ንብንትስን ጋላቴት ጋማ ጋሞሶት። ");
INSERT INTO jnje_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","የሱስኒኪ ካሞ አባ ሀኦሶን ጋላቴት ካማክናዋ ዎስቶክና ዛግፌት ባሮን ዙትራ ዳም የሱስኒ ሱናሲክ ዛጉት። ኤስ ባርክ አባ ሀኦሶን ጋላቶት። ");
INSERT INTO jnje_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","ኬሪኝኛኒ ሜያነ! አማኝኒ ሜያክ ሾልሱ ስንና ቦርአ ቴጎንትሳክቶኒክ አጃጃሞሶት። ");
INSERT INTO jnje_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","ቴጎኒ ሜያነ! ኬሪኝኛንትሲክቶኖን ሹንትዋ። ባሶስታ ኬና ቡዱትታዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","ናንጎታሲክቶነ! ኤስ ባር ዳሚስን ግርሱኒ ዉዛ ዙታምባሴ አሲክ ኮኒ አባንትሲክናዋ እንቶኒትሲክና አጃጃሞሶት። ");
INSERT INTO jnje_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","ኮኒ አባኒ ሜናዋ ኮኒ እንቶኒ ሜያነ! አብድ ቡጉሶኖይናማቶ ናንጎትኒትሲክቶኖን ሃርሱሶትታ። ");
INSERT INTO jnje_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","ቦዝኒ ሜያነ! ሀን ዳስታክ ፌሴ ዳምኒትሲክ ስና ቾዋ ዙታምባሴ አሲክ አጃጃሞሶት። ኤስ አጃጃሞሶንትስ ደይ ባሶ ንቶትን ብየፌ ቦርአ አሱኒን ግርሱክ ስኖይናሮን ዳሚኒን ድጎክናዋ ማአ ንባክና ስኑንዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","ዛግፌት ባሮን ዙትራ አሱኒክ ስኖይናሮን ዳሚሲክ ዛግፌትስነ ፋሮን ቱማ ንባክ ዛጉት። ");
INSERT INTO jnje_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","ኤስ ባርክ ዳሚስ ርስትባሶን ዎሱማ ዛግሬ ንቶክ እማናማቶ አሪፌትዋ። ዎስቴት ፋቲስ ዳም ክርስቶስኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","ሀኦሲ ስና ቴሽሹ ኣፋ ስንና ቦርአ ማጙ ዎስቶ ዎስቴፌ ባር ዎስቴና ማጙ ዎስቶባሲ ዋጋኖን ኤጴቶናዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","ዳምኒ ሜያነ! ንቶ ደይ ደን ሳማክ ንቶ ዳም ፌናማቶ አሪራ ቦዝኒትሳክቶኒን ማአሪክናዋ እሳ ቂጤክና ሀእሱትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","ሀኦሲክ ችምማ ጋላቶክ ዬቱኖይ ሺጶት። ");
INSERT INTO jnje_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","ኤስ ባርኔን አነ ሀኦሲ ካማኖን ማኮኒ ኡግና እኖክ ጋቻናክናዋ ታ፤ ባሳ ቦርአ ታቴራ ፋና ክርስቶስኒ ኣቾ ቾዋሶን ማኮ ችማኒክና እኖክ ሺጵሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","ታ፤ ደይ ማኮናክ ሾልሲናስማቶ ካምባሶን አምማኖን ማኮናክ ታክ ሺጶትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","ኣፍፋ ኡግናክኑ ስኑን አማኖኖይ አሱኒ ሜኒ ጋነያስሲ ቴችማክ ፎሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","አሱ እሳርባ እሳርባሲክ ሾልሱ ዎልጉ እማ ችማትክ ዎንና ዎንና ዎሉምኒትስ ማአ ካርእአ ስኑንዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","ትቂቆስ ታ፤ ቾዋሶን ዙትሬ ንቶክ ማኮናዋ። ባር ሹንቶ አይ ደይ አማናምቶ ዎስትኛዋ፥ ታኔን አነ ደይ ዳሚሳ ዎስቶኒ ዞሞታዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","ባሪን ንቶኪ ዎሲናስ እንኖ ቾዋሶን ንቶክ ማኮናክናዋ ንቶ ንባሶን ችኑናክናዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","ባርኔን አነ ደይ ንቶ ኬን ስና አማናምቶ ደይ ሹንቶ አይ ስና ኦነስሞስ ንቶኪ ዮኒርዋ። ባሶ ዬሴፋት ሀንታ ፋ ቾዋሶን ዙትሬ ንቶክ ማክሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","ታኔን አነ ታቴሬ ፌ አሪስትሮኮስ ደይ ናጋ ንቶትን ኦቸድፌርዋ። ዜሞ፦ «ንቶኪ ዬፌና ካባሲክ ኤጳቶትዋ» ይት ማኬና ባርናባስኒ እሽኒ ና ስና ማርቆስ ደይ ናጋ ንቶክ ኦቸድፌዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","እዩስጦስ ይስቴሬ ቴግቴፌ እያሱ ናጋ ንቶክ ኦቸድፌ። ሀኦሲ ታቶኒ ዎስቶኖን ታኔን አነ ዎስቴሴፌ አሱኒ ሜኒ ጋነያስን አይሁድኒ ሜኒ ኬን ስና ባሶሲን ኤስ ባሶ ኮእቤስዋ፤ ታን ደይ ችኒሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","ንቶ ኬን ስና የሱስ ክርስቶስኒ ዎስትኛ ኤጳፍራ ንቶክ ናጋ ኦቸድፌዋ፤ ካይማ ፎሲክ ችምማ ዬሮትክናዋ ሀኦሲ ሳፋራኖን ዙትራ ኮእሱትክና ባር ዎንና ዎንና ንቶክ ሺጴድፌርዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","ንቶ ቦርአ ሎዶቅያኒ ካታማሲናዋ ይራፖልስኒ ካታማሲና ፌሴ አሱኒ ሜያክ አካማኖን ሆፕት ፎባሶን ታ ዛላ ማኮናዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","ሹንቶ ሀኪሚ ስና ሉቃስናዋ ዴማስና ንቶክ ናጋ ኦሸሴድፌዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","ሎዶቅያክ ፌሴ አማኝኒ ሜያክ፥ ንፉምያ ይስቴፋ ማሽካሱሲክናዋ ባሪ ኬያሲ ፋ ቤቴክርስታኒሲክና ናጋናሶን ካቱትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","ሀን ትቻሶን ንቶ ፌሬትትኔን ኦርፎ ሎዶቅያክ ፋ ቤቴክርስታኒሲ ፌሬቶናክ ዛጉትዋ፤ ንቶ ደይ ሎዶቅያን ንቶኪ ዎስቴ ዎሲያሶን ፌሬቱሶት። ");
INSERT INTO jnje_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","አሪክጳስኒክ ደይ፦ «ዳሚስኪን ኔክ እምቴ ዎስቶሶን ኮእሱታክ ችምዋ» ይራ ማኮትዋ። ");
INSERT INTO jnje_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","ሀን ናጋኒ ትቻሶን ኩሹናሲክ ትቺስ ታ፤ ጳዉሎስዋ። ታ፤ ሻሻራክ ታቴራ ፋናማቶ ያዳቶትዋ። ሀኦሲ ኦትማ ንቶኔን አነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","አባ ሀኦሶንናዋ ዳም የሱስ ክርስቶስኒንና አማነሬ ቴሴሎንቄኪ ቤቴክርስታኒስ ፌሴ አማኝኒ ሜያክ ጳዉሎስኒኪን፥ ስላስኒክንናዋ ጢሞትዮስኒክንና ዎስቴ ዎስያ። ሀኦሲ ኦቱምነዋ ናጋነ ንቶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","እንኖ ዎንና ዎንና ሺጶኒሲክ ንቶትን ያዳቴፋፋ ሀኦሶን ጋላቴት ፋኒር። ");
INSERT INTO jnje_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","ሀኦኒሲ ስናክናዋ አባኒሳ ስናክና አማንቶኒትስ ዎስቴፋና ዎስቶስ፤ ኬሽታናክ ዛግሴፌት ባሬዋ ዳምኒ የሱስ ክርስቶስኒስታ ፋ ንቶ አብዲሶን ፋኪያክ ኦደት ፎንትሲክ ዎንና ዎንና ያዳቴት ፋኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","ሀኦሲክ ሹንቶ አይኒ ሜያነ! ሀኦስ ንቶትን ኮሪናማቶ እንኖ አርፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","እንኖ ምስራቹኒ ካማሶን ንቶክ ማኬኒስ ዎል ላ ዎል ላክ ስኖይናሮን ሁግናክናዋ ኮርቶ አያናክና ደይ ምስራቹኒ ካማሲ ቾዋ ፉቶ ስንባሶን ማእስሬ አሩክዋ። ንቶኔን አነ ፋኒ ካባሲክ ንቶክዋ እያት ኣካክ ፋኒማቶ ንቶ አርሴድፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","ሾዎ ሻና ንቶስታ ካርፋናክኑ ኮርቶ አያናስኪን ቤስቴ ግራሲኪ ካሞ ካምባሶን ኤጳ ታራ እኖትንናዋ ዳም የሱስ ክርስቶስኒ ኡግናሲክና ዞኑስቴር ስነትዋ። ");
INSERT INTO jnje_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","ኤስ ባሪ ቦርኣ ሜቀዶንያክናዋ አኪያክና ፌሴ አማኝኒ ሜያ ዙታምቤሲሴ አሲክ ማአ ቤሶ ስነትዋ። ");
INSERT INTO jnje_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","ዳሚሳ ካማ ንቶኪን ኬሳ ኦድቴናስ ሜቀዶንያክናዋ አኪያክና ኮእባ ስኖይናሮን ሀኦስታ ፋ ንቶ አማንቶስ ዳ ዙታምባሴ አሲስ አሪቴራ ፋርዋ። ኤስ ባሪ ቦርኣ ሀን ቾዋሲክ እንኖ እሳ ዉዛነ ማኮኒክ ኣነ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","ንቶኪ ያፌኒ ካባሲክ እኖትን ኣካክ ኤጳ ታሴትማቶ፤ ሀየዋ ደይ ፉቶ ስና ሀኦሲክ ዎስቶክ ኮልኦኒ ሺጶስን ኦር ኬስሳ ሀኦስኪ ኣካክ ዎልሴትማቶ ኤስ አሱኒ ሜያ ቴትቤሲሲክ ዛላ ስኖነዋ። ");
INSERT INTO jnje_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","ኤሲስማቶ ሀኦስ ክቱን ካብግና ባሪን ዮኒ ግአሲን እኖትን ፉኦኒ ናዉባ የሱስ ክርስቶስኒ ሳማን ዮሶን ኦደት ፋኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","አይኒ ሜያነ! እንኖ ንቶኪ ዮስ ኬኤኖይ ዉዛ ስንና ቤይናማቶ ንቶ ቴትንትሲክ አሪሴፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","ንቶ አሪሴፌትሲማቶ ዜሞ ፍልጲስዩስ ካታማሲ ፋኒ ካባሲክ ሻናነዋ ሜእነ እኖስታ ካርእዋ። ስኑንታኖ አካማ ቱጋኦ እኖስታ ካርፋናክኑ ምስራቹኒ ካማሶን ንቶክ ማኮኒክ ሀኦኒስ እኖክ ሁግና እምዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","እንኖ ንቶትን ኪትኒስ ዳግሱክ ወደይ ማጙ ኡግናክ ዞኑስቴራታዋ። ንቶትን ኤሹኒክ ዛግኒ ዉዛ እሳርነ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","ኤሲስታን ሀኦስ እኖክ ግሬራናዋ ምስራቹኒ ካማሶን እኖክ አዳራክ እምናስ እኖትን አማነራ ስንና ቦርአቱ ማኬፌንዋ። ኤስ ባሮን ደይ ዛግፌኒስ ንብኒሶን ፋታነራ ቢፋ ሀኦሶን ግርሱኒ ኡክታኖ አሱኒን ግርሱኒክታዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","እሳ ዎናክኑ ኤሽሹክ ወደይ ዋግኒ ኬኤሽታና እኖትን ኤጳን ማኬኒ ዎና ኣፋ ስንናማቶ ንቶ ቴትንትሲክ አሪድፌትዋ። ሀኦስ ደይ እኖክ ዛላዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","ንቶኪን ስኑን ኦምንክኑ ኡልፍና ኣኔ ሾሎዌንዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","እንኖ ክርስቶስኒ ዎሲ ስኒስማቶ እኖክ ሾልሲ ዉዛሶን ንቶኪን ማምሲራ ኤጳክ ችማኒ ካባዋ። ስኑንታኖ ናንጎትባሲክቶኖን ማእስራ ኦድፋ እንቶኒማቶቱ ጋራማክ ንቶ ጋነያስ ኩትኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","ኤሲስማቶ አካማኖን ንቶትን ሹንፌኒ ቦርአ ሀኦሲ ምስራቹኒ ካማኖን ንቶክ ማኮ ኮእባ ስኖይናሮን ካኒሶንኑ ንቶክ እማኒክ ሆሬራቱ ፋኒዋ፤ ንቶ እንኖ ስናክ ሹንቶ ስንና ፋትር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","አይኒ ሜያነ! ኣካክ ዎስቴኒማቶናዋ ኣካክ ሆፕኒማቶና ንቶ አሪሴፌትዋ። ሀኦሲ ምስራቹኒ ካማኖን ንቶክ ማኬፌኒ ካባሲክ ንቶስን ኦኒስታኑ ባአ ስኖይኒማቶ ዎነዋ ዋልነ ዎስቶክ ሆፕት ፋኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","ንቶ አማኝኒ ሜኒ ጋነያሲ ፋኒ ካባሲክ እንኖ ፎስ አዉነ ፋ ኮርቶክናዋ ኦኮ ዝናባ ፎንቶ ካክና ፋኒማቶ ንቶ ዛልዋ፤ ሀኦሲ ደይ እኖክ ዛላዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","አባ ናንጎትባሲክ ዛግፌናይስማቶ እንኖ ደይ ንቶ እሳርኒት እሳርኒትሲክ ዛግኒማቶ ንቶ አሪሴትርዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","ዎንና ዎንና ንቶትን ኪትትናዋ ችኒትና፤ ሀኦሲ ታቶኖንናዋ ኡልፍንባሶንና ሃኦሶትክ ንቶትን ቴጌ ሀኦስ ግሮና ፎ ፎሶትክ አዳራ ይኒማቶ አሪሴድፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","እኖኪን ኦደሴት ሀኦሲ ካማኖን ኤጳ ታፌት ካባሲክ ንቶሲ ዎስቴት ፋ ሀን ሀኦሲ ካማኖን አሱኒ ካምኒማቶ ስኖይናሮን ፉቶኒ ሀኦሲ ካማ ዛግራቱ ኤጳ ታሴትዋ። ፉቶሲክ ደይ ሀኦኒ ካማዋ፤ ኤስ ባርክ ደይ ሀኦሶን ዬቱኖይ ጋላቴፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","አይኒ ሜያነ! ንቶ ደይ ዩዳኒ ዳስታክ ፌሴ የሱስ ክርስቶስኒኪ ካሞ ሀኦሲ ቤቴክርስታኒሲክቶኒ ኡግናክ ዞኑስቴሴትዋ። ባሶ አይሁድኒ ሜያኪ ካሞ ሻና ባሶስታ ካርናሲማቶ ንቶስታ ደይ ንቶ ኬን ስና ባሶኪን ሻና ካርእዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","አይሁድኒ ሜያ ዳም የሱስኒንናዋ ራጁኒ ሜያኖንና ዎርሴቴ። እኖትን ደይ ካብግሬ ጋፉክሴስ ባሶዋ። ባሶ ሀኦሶን ግርሱኖር አሱ ዙታምባሴ አሲን ኦምቴ ሜያዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","አዛብኒ ሜያ ፋርሶነ ካማሶንኑ ማኮኖይኒማቶቱ እኖትን ካለፌዋ። ኤስ ኤፋ ዉዛ ዛግት ቦርኣስታ ኦማ ቦርአ ዳይሲት ሀሜቴር። ኤስ ባሪ ቦርኣቱ ኮእባስታክ ሀኦሲ ግኢአ ባሶስታ ያዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","ስኑንታኖ አይኒ ሜያነ! እንኖ አያናክ ስኖይናሮን አሻክ ጋሮ ዎና ንቶስታን ዎክፌኒክኑ ንቶክ ፋ ካልታንናስ አካማ ስንና ቦርአ ሾዎ ዎና ኣፌ ኣፌ ንቶትን ብያኒክ አካማኖን ካቤኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","ንቶኪ ደይ ዮኒክ ሾሌት ፋኒር፤ ኤስ ባርስታንኑ ታ ጳዉሎስ ሾዎ ዎና ንቶኪ ዮናክ ሄፓ ሄፓ ሾሌን። ስኑንታኖ ሴጣናስ ንቶኪ ዮኖይናማቶ እኖትን ካሊ። ");
INSERT INTO jnje_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","ኤካን አብድኒስ ወደይ ግራኒስ ወደይ ዳምኒስ የሱስ ዬፌና ካባሲክ ባሳ ስናክ ቴቶኒ አክሊልኒስ ንቶቴኤኖሶ? ");
INSERT INTO jnje_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","ፉቶሲክ ኡልፍኒሴዋ ግራኒሴ እኖክ ንቶዋ። ");
INSERT INTO jnje_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","ኤስ ባሪ ቦርኣ ሀንኔን ኤካሎክ ፋኩክ ኣነ ችሜኒ ስንና ቦርአ አቴናኒ ካታማሲ እንኖ እንኖ ፎኒክ ማአሪ ስንና እኖክ ቤስቴ። ");
INSERT INTO jnje_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","አማንቶኒትሲክ ችምማ የሮትክ ንቶትን ኪቱናክ እንኖ አይ ደይ ሀኦሲ ዎስትኛ ስንነ ክርስቶስኒ ምስራቹኒ ካማሶን ማኮክ እኖክ ዎስቶኒ ዞሞ ስና ጢሞትዮስኒን ዎስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","ኤሲስ ደይ ንቶስታ ካርአ ሻናሲክ ሾርኮኖይትማቶ ንቶትን ዛጉና። ኤስ ሻናስ እኖክ ሆሬራ እምቴር ስንባሶን ንቶ ቴትንትሲክ አርሴትር። ");
INSERT INTO jnje_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","ኤሲስማቶኑ እንኖ ንቶኔን አነ ፋኒ ካባሲክ ሻና እኖስታ ካርአናማቶ ዜምማ ንቶክ ማኬኒዋ። ኤስ ሻናስ አርሴፌትስማቶ እኖስታ ካርእዋ። ");
INSERT INTO jnje_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","ኤስ ባሪ ቦርኣ ሀንኔን ኤካሎክ ፋኪያክ ኦዳናክ ኣነ ችሙት ስንና ቦርአ ንቶ አማንቶሲ ቾዋኖን አሩናክ ሾሌፋቱ ጢሞትዮስኒን ንቶኪ ዎስጝዋ። ኤስ ባሪን ንቶኪ ዎስናስ አዉዛክነ ሴጣና ኦማ ኡግናክ ንቶትን ፋትታነ ስናና ደይ እንኖ ዎስቶስ ደይ ኬእኖር ስንና ፉቶኒርዋ ይራ ድጌና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","ስኑንታኖ ሀሽ ጢሞትዮስ ንቶኪን ዎል ሌ እንኖኪ ዬሬ ንቶ አማንቶሲ ቾዋኖንናዋ ንቶ ኬሽታናሴ አሲክ ግሮኒ ኦዱ እኖክ ማኬ። ኤሲስማቶ ደይ ንቶ ዎንና ዎንና ማአሪክ እኖትን ሳፋሬት ፋሴቲማቶናዋ እንኖ ንቶትን ብያኒክ ካልቴት ፋኒሲማቶ ንቶ ደይ እኖትን ብያቲክ ካልቴት ፋትማቶና እኖክ ማኬ። ");
INSERT INTO jnje_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","ኤስ ባሪ ቦርኣ አይኒ ሜያነ! እንኖ ፋኒስ ራክኮሲናዋ ሻናስና ስኒፋናክኑ ንቶ አማንቶሲክ እንኖ ችማ ዳንኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","ንቶ ዳም የሱስኒክ ችምሜ ፎስ እኖክ ካኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","ኤሴ ሀሽ ንቶ ቾዋሲክ ጋላታ እምፌኒ። ንቶ ቦርአ ባሳ ስና ፋ ግራኒሲክ ሀኦኒሶን ጋላቴፌኒ። ");
INSERT INTO jnje_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","ዎነዋ ዋልነ አካማ ችማ ሺጶክ ሺጴት ፋኒስ ኣፌ ኣፌ ብያኒክናዋ አማንቶኒትሲ ዮእ ዉዛሶን ቱኑ ችማኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","ሀሽኑ ሀኦኒሴዋ አባኒስና፤ ዳምኒ የሱስ ቴትባሲክ ንቶኪ ዮኒክ ኡጉኒሶን ካናዎዋ። ");
INSERT INTO jnje_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","እንኖ ንቶትን ኬሽቴት ፋኒሲማቶ ዳሚስ ንቶትና ንቶትና ደይ ኦምኒ ሜያክኔን ፋ ኬሽታንኒቲስ ድቻናክናዋ ቱምማ ፉእቶናክና ዛጋዎዋ። ");
INSERT INTO jnje_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","ኤስ ባርክ ዳምኒ የሱስ ኮርቶኒ ሜያኔን አነ ዬፌና ካባሲክ ሀኦኒሲ ስናክናዋ አባኒሳ ስናክና ንብኒቲስ ሙዳባ ፎንቶ ኮርቶ ስናናክ ንቶትን ችኑናዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","ኮእባስታክ ደይ አይኒ ሜያነ! ሀኦሶን ግርሱትክ ኣካክ ፎትክ ሾልሲፋናማቶ እኖኪን አሪትዋ፤ ሀሽ ደይ ፎትስ ኤሲስማቶዋ፤ ዳም የሱስኒ ሱናሲክ ንቶትን ሺጴፌንሴዋ ኪትፌኒሴ ዜሞ ስናክ ዛግቲ ባርስታን ደናሎኖን ዳይስራ ዛጉትክዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","ዳም የሱስኒ ሱናሲክ አሮ አጃጅ ንቶክ እምኒማቶ አሪሴድፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","ሀኦሲ ፍቃድ ንቶ ኮርቶትክናዋ ጌርኬሳስታን ዎካትክናዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","ንቶስን አሱ ዙታምባሴ አሱባስኔን አነ ኮርቶክናዋ ኡልፍናክና ኦዳና ባሮን አሩዎዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","ሀኦሶን አሩኖይ አሱኒ ሜኒማቶ እጉኒ ኤናንቶንቲ ፎናታዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","ሀን ዉዛሲክ ኦኑ አቴ ኦም አይባስን ሚርኦናታዋ። ዜሞ ስናክ ንቶክ ማኬኒሲማቶናዋ ቴትንትሶን ኦዳትክ ዛግኒሲማቶና ኤስ ኤፋቴና ዉዛሶን ዛግሴፌ ባሶትን ዳሚስ ኬእርዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","ሀኦስ እኖትን ቴጌናስ ኮርቶ ፎ ፎኒክታኖ ኪና ፎ ፎኒክታዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","ኤስ ባሪ ቦርኣ ሀን ኪቶሶን ቱጋኤፌ ባር ቱጋኤናስ ኮርቶ አያናባሶን ንቶክ እምኒ ሀኦሶንታኖ አሱኒንታዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","ንቶትና ንቶትና ኬሽቶኒ ቾዋሶን ንቶ ቴትኒትሲክ ሀኦስኪን አሪሴቲ ስንና ቦርአ ሀን ቾዋሲክ ኦኑ ትቹናክ ኣነ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","ሜቀዶንያክ ዳ ዙታምባሴ አሲስታ ፌሴ አይኒ ሜያኖን ዙትራ ኬሽቴሴትር፤ ስንፋናክኑ አይኒ ሜያነ! ሀሽ ንቶትን ኪትፌኒስ ኤሲስታን ደናሎኖን ዳይስራ ኬሽቶሶትክዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","ሻክሬ ፎክ ካቦትክናዋ ንቶ ቴትኒ ቾዋሶን ሳፋሮትክ ደይ ዜሞ ስናክ ንቶትን አጃጀኒሲማቶ ንቶ ቴትኒ ኩሹሲክ ዎስቶትክዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","ኤስ ባርክ አማኖኖይ አሱኒ ሜኒ ስናክ ኡልፍንቴር ስናትዋ። ኦኒስታኑ ቴቴር ኣፋ ስናትዉዛ። ");
INSERT INTO jnje_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","አይኒ ሜያነ! ክቲ አሱኒ ሜኒ ቾዋሲክ አብድቤስ ፎንቶ አሱኒ ሜኒማቶ ሱሞኖይትማቶ ፉቶሶን አሩሶትክ ሾሌፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","የሱስ ክትናማቶናዋ ክቱን ደይ ካብናማቶና አማነፌኒዋ፤ ኤስ ባሪ ቦርኣ የሱስኒክ አማነሬ ክት ባሶትን ሀኦስ ባርኔን አነ ቴሾናዋ። ");
INSERT INTO jnje_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","ዳሚስኪን ኤጳታኒ ካማሲማቶ ንቶክ ማኬፌኒስ ኤሲሶጝዋ። ዳሚስ ዮና ካባኔን ሀየዉ ስንነ ፎኒ እንኖ ክት ባሶትን ኣፋዋ ዜምማኒዉዛ። ");
INSERT INTO jnje_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","አጃጅኒ ካማክ፤ ሀኦሲ ዎስኒ ጋኛኒ ካማክ፤ ደይ ሀኦኒ ማርካታ ኦድቶና፤ ዳሚስ ደይ ቴትባሲክ ኤስ ባሶክ ጌፕቴሬ ሳማን ኬሮና። ክርስቶስኒን አማነሬ ክት ባሶ ዜምሜ ካብሶነ። ");
INSERT INTO jnje_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","ኤሴን ኦርፎ ካክ ፌ እንኖ ዳሚስኔን አነ ስሩስታ ኡጶክ ባሶኔን አነ ሻሩስታ ደን ኦቶኒ፥ ኮእባ ፎንቶኖን ደይ ዳሚስኔን አነ ፎኒ። ");
INSERT INTO jnje_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","ኤስ ባሪ ቦርኣ ሀን ካማሲክ ንቶትና ንቶትና ዎል ችሞት። ");
INSERT INTO jnje_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","አይኒ ሜያነ! ኤስ ባር ስናና ነያሴዋ ሳአትሴ አሲን እሳ ዉዛነ ንቶክ ትቹናክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","ዳሚሳ ዎና ዮናስ ዊስ ዋላክ ዬፌናይሲማቶ ስንባሶን ንቶ ቴትንትሲክ ማእስራ አርሴፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","አሱኒ ሜያ፦ «ዙታምባሴ ናጋ ደይ ማአር» ይሴፌን ናኔር አሱሶን ኬክቶ ኤጵፋናሲማቶ ትሹኒ ዎናስ ዲንቆነ ባሶስታ ዮናዋ። እሳንነ ኣፋ አትቴ ኬሶነዉዛ። ");
INSERT INTO jnje_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","ስኑንታኖ አይኒ ሜያነ! ንቶ ፋሴቲስ ታልማሲታዋ። ኤስ ባሪ ቦርኣ ኤስ ዎናስ ዊስኒማቶ ኣፋ ንቶስታ ዮናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","ንቶ ዙታምንትሴ ቻሬፋስ ፌ አሱዋ፤ ደይ ዎን ኒ አሱዋ። እንኖ ዋላሲ ወደይ ታልማሲ ፌ አሱቴዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","ኤስ ባሪ ቦርኣ ጉዙኒዋ፥ ቴትኒሶን ሀእሱክ እኖክ ፋዪስ ሆሮና ኡክ ፎኒስታኖ ኦም አሱኒ ሜኒማቶ አፋይቶኒዉዛ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","አፋይቴሴፌ ባሶ ዋልንቱ አፋይቴሴፌ። ዛየሴፌ ባሶ ደይ ዋልንቱ ዛየሴፌ። ");
INSERT INTO jnje_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","ስኑንታኖ እንኖ ቻሬፋሲ ፌ አሱ ስንኒ ቦርአ ቴትኒሶን ሀእሱክ እኖክ ፋዪስ ሆሮና ኡክ ፎኒ፤ አማንቶሶንናዋ ኬሽታናሶንና ጥሩርኒማቶ ዛግራ ማያኒ፤ ፋሩኒ አብዲሶን ቴታስታኪ ብትታኒ ጉፍታሲማቶ ዛግራ ጉፎኒ። ");
INSERT INTO jnje_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","ሀኦስ እኖትን ቴጌናስ ባሪ ግኣሲክ ትሹኒክ ስንኖይናሮን ዳምኒ የሱስ ክርስቶስኒኪ ካሞ እንኖ ፋሩ ዳናኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","ክርስቶስ እንኖ ቦርአ ክትናስ ካክ ፋፌኒክ ወደይ ክትፌኒክ ባርኔን አነ ፎኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","ኤስ ባሪ ቦርኣ ሀሽቲ ዛግት ፋሴትሲማቶ ንቶትና ንቶትና ችኑሶት ደይ ዛጉሶት። ");
INSERT INTO jnje_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","አይኒ ሜያነ! ንቶ ጋነያሲ ዳሚሳ ዎስቶክ ሆፕት ፌሴ ባሶትን፥ ዳሚሲኪ ካሞ ንቶ ጋኜ ሜያኖንናዋ ንቶትን ኪትፌ ባሶትንና ኡልፍንሱሶትክ ንቶትን ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","ዎስቶቤሲስታን ካብ ቾዋ ባሶትን አካማ ኬሽታናክ ኡልፍንሱሶት። ንቶ ደይ ንቶትና ንቶትና ናጋክ ፎሶት። ");
INSERT INTO jnje_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","አይኒ ሜያነ! አዉጃኒ ሜያኖን ኬኡት፤ ድጌፌ ባሶትን ችኑት፤ ሆፕኒ ሜያኖን አርጋሱት፤ አሱ ዙታምባሴ አሲን ፋኩት። ");
INSERT INTO jnje_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","ኣፌ አሱኑ ስንፌናክ ማጙ ዉዛሲ ኤድደ ማጙ ዉዛ ዎልጉኖይናማቶ ቴትንትሶን ኦድት። ኤስ ባርስታን ዎንና ዎንና ንቶትና ንቶትናኑ ስንፋናክ ኦም አሱኒ ሜያክ ዙትራ ማአ ዉዛ ዛጉቲክ ካቦት። ");
INSERT INTO jnje_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","ዎንና ዎንና ግሮት። ");
INSERT INTO jnje_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","ዬቱኖይ ሺጶት። ");
INSERT INTO jnje_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","ስና ቾዋ ዙታምባሴ አሲክ ሀኦሶን ጋላቶት፤ የሱስ ክርስቶስኒኪ ካሞ ፋ ካኒትሲክ ሀኦስ ንቶኪን ሾሌፋናስ ኤሲሶጝዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","ኮርቶ አያናሲ ጌያኖን ኡቹትታ። ");
INSERT INTO jnje_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","ራጅኒ ዎሲያሶን ካሹትታ። ");
INSERT INTO jnje_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","ቾዋ ዙታምባሴ አሲን ፋትታኖት፤ ማአሪ ስና ባሮን ኤጳቶት። ");
INSERT INTO jnje_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","ማጙ ስና ዉዛ ዙታምባሴ አሲስታን ዎክት። ");
INSERT INTO jnje_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","ናጋኒ ሀኦስ ባር ቴትባሲክ ስና ቾዋ ዙታምባሴ አሲክ ንቶትን ኮርቶ ዛጋዉጝዋ። አያናንትስ፥ ካኒትሴዋ አቱንትሴ ዙቴራ ዳምኒ የሱስ ክርስቶስ ዬፌና ዎኖ ዝናባ ፎንቶ ስንና ኦድቴራ ፎን። ");
INSERT INTO jnje_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","ኤስ ንቶትን ቴጌ ባር አማንቶ ስንና ቦርአ ሀን ባሮን ዛጉናዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","አይኒ ሜያነ! እኖክ ደይ ሺጶሶት። ");
INSERT INTO jnje_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","አይኒ ሜያኖን ዙትራ ኮርቶ ስንና ዳሞክ ናጋ ኦሽሾሶት። ");
INSERT INTO jnje_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","ሀን ዎሲያስ አማኝኒ ሜያ ዙታምቤሲሴ አሲክ ፌሬቶናክ ዳሚሳ ሱናክ አዳራ ይፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","ዳምኒ የሱስ ክርስቶስኒ ኦትማስ ንቶኔን አነ ስንፋውጝዋ፤ ኣሚን!");
INSERT INTO jnje_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","አባ ሀኦሲር ስና ባሶትናዋ ዳምኒ የሱስ ክርስቶስኒር ስና ቴሴሎንቄኒ ቤቴክርስታኒሲ ፌሴ አማኝኒ ሜያክ ጳዉሎስኒኪን፤ ስላስኒኪንናዋ ጢሞትዮስኒኪንና ዎስቴ ዎሲያ፤ ");
INSERT INTO jnje_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","አባ ሀኦኒስኪንናዋ ዳም የሱስ ክርስቶስኒኪንና ኦቱምነዋ ናጋነ ንቶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","አይኒ ሜያነ! አማንቶኒትስ ዎንና ዎንና ድቼት ሀሚባሲክናዋ ንቶትና ንቶትና አሲ ኬሽታናስ ደይ ዳይሲት ሀሚድፋር ስንና ቦርአ ሀኦሶን ማእስራ ጋላቶኒክ ሾልሱዋ። ");
INSERT INTO jnje_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","ኤስ ባሪ ቦርኣ አዉነ ፋሮንኑ አካማ ራኮነዋ ሻናነ ንቶስታ ካርፋናክኑ ንቶ ኣካክ ፋክሴትማቶናዋ አማንቶኒትሲክ ደይ ኣካክ ችሜሴትማቶና ሀኦኒ ቤቴክርስታኒሲክቶኒ ጋነያሲ ፋኒ ካባሲክ ንቶክቱ ቴቴፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","ኤስ ባር ዙታምባሴ ቤሲፋናስ ሀኦሲ ማጝሱኒ ካርአ ፉቶ ስንባሶንናዋ ሻና ኤጳ ታሴቲ ሀኦሲ ታቶሲ ግሩክ ችምሜ ሆሬሬ ፌር ዛጉክዋ። ");
INSERT INTO jnje_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","ሀኦስ ፉቶክ ማጝሱ ካርአር ስንና ቦርአ ንቶስታ ሻና ካትሴፌ ባሶስታ ሻና ቴሾክ ዋግቤሲሶን ካሱናዋ። ");
INSERT INTO jnje_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","ሀሽ ሻና ኤጴቴሴ ንቶክ ደይ እኖኔን አነ ቤይሳ እማናዋ። ኤስ ባር ደይ ስንናናስ ዳም የሱስ አካማ ሁግናቤሲ ፋና ዎስባሲክቶኔን አነ ሳማን ዬፌና ካባሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","ኤስ ካባሲክ ሳሜት ድ ጌያክ ሀኦሶን አሩኖይ ባሶትንናዋ ዳምኒ የሱስ ክርስቶስኒ ምስራቹኒ ካማሲክ አጃጃሞኖይ ባሶትንና ኬኡና። ");
INSERT INTO jnje_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","ባሶ ዳሚሳ ስንታናዋ አካማ ሁግናባሲ ኡልፍንታና ኦር ኬሴሬ ኮእባ ፎንቶ ትሹኒ ኬኦ ኤጴቶሶነ። ");
INSERT INTO jnje_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","ኤስ ዎኖ ዳሚስ ኮርቶኒ ሜያክ ኡልፍንቶናክናዋ ባሪክ አማነፌ ባሶ ዙታምቤሲሴ አሲክ ዲንቆስቶናክና ዬፌና ካባሲክዋ። ንቶ ደይ እንኖ ማኬኒ ዛላሶን ኤጳ ታራ አማነሴት ቦርአ ኮርቶኒ ሜያኔን አነቱ ፋድቶሶትዋ። ");
INSERT INTO jnje_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","ኤስ ባሮን ሳፋሮክ ንቶ ቾዋሲክ ዎንና ዎንና ዬቱኖይ ሺጴት ፋኒስ ሀኦኒስ ንቶትን ቴጌና ቴጎሲክ ሆሬር ስንናትክናዋ ማአሮን ዛጉክ ፋ ፍቃድንትሴዋ አማንቶኒ ዎስቶኒትሶንና ዙትሬ ሁግናባሲክ ኮእሱናክዋ። ");
INSERT INTO jnje_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","ኤሲስማቶ ደይ ዳምኒ የሱስ ክርስቶስኒ ሱናስ ንቶክ ኡልፍንቶናክናዋ ንቶ ደይ ሀኦኒ ስንና ዳምኒ የሱስኒ ኦትማሲክ ካፑቴራ ባሪክ ኡልፍንቶትክናቱ ሺጴፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","አይኒ ሜያነ! ዳምኒ የሱስ ክርስቶስኒ ዮሴዋ እንኖ ደይ ባርኔን አነ ስናኒክ ዙቶኒ ባሪ ቾዋሲክቱ ንቶትን ሺጴፌኒስ፤ ");
INSERT INTO jnje_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","ራጅክ ወደይ ካማክ ማክቴናሲማቶ ወደይ እኖኪን ትቼ ዎስያነ ፋሮን ዛግራ፦ «ዳሚስ ዎል ሌ ዮና ዎናስ ካርእ» ይት ካኑንትስ ሾርኮናታ ወደይ ናዎናታዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","ኦኑ ኣፋ ኡግናክኑ ንቶትን ኤሻናታዋ፤ ዜምማ ሞርሞስ ዮኖይፌን፤ ጌኒ ኬር ግሩኒ ማጙ ዎስቶኒ አሱስ አምማኖን ኬሴ ቤስቶኖይፌን ኤስ ዎናስ ኣፋ ዮናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","ኤስ ማጙ ዎስቶኒ አሱስ ሀኦ ይስቴራ ሺጵቴፋ ባሪኪቶ ዙታምባሴ አሲስታን ደናሎ ቴትባሶን ቴጉና። ባር ደይ፦ «ታ ሀኦ» ይት ሀኦሲ ቤቴሜቅደሲሲኑ ደይ ዲሬ አዋስቶናክ ዛጉና። ");
INSERT INTO jnje_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","ንቶኔን አነ ፋና ካባሲክ ኤስ ዉዛሶን ንቶክ ማኬና ባሮን ኣነ ያዳቶዌትኖሶ? ");
INSERT INTO jnje_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","ዎንባስ ካርእን አምማኖን ኬሴ ቤስቶና ዎና ካርአና ካባኔን ሀሽ አምማኖን ኬሴ ቤስቶኖይናማቶ ባሪን አዉ ካልናማቶ ንቶ አርሴድፌትዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","ማጙ ዎስቶሲ ኣቾ ሁግና ሀሽኑ ዎስቴቱ ፋ፤ ስኑንታኖ ሀሽ ባሮን ካልኒር ፋርዋ፤ ኤስ ባር ደይ ስናናስ ኤስ ባሮን ካልፋ ባር ኡግናስታን ሻቶና ካባኔጝዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","ኤሴን ኦርፎ ዳም የሱስ ኖኖባስን ካትፌና ካታሲክ ትሽኩና ባሬዋ አዳክ ዮባሲክ ትሽኩና ማጙ ዎስቶኒ አሱስና አምማኖን ኬሴ ቤስቶና። ");
INSERT INTO jnje_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","ኤስ ማጙ ዎስቶኒ አሱስ ዮናስ ሴጣናኒ ሁግናክ ዳግሱኒ ቢስቴራ አርቶኖይ ዉዝነዋ ቤሶነ ደይ ዲንቂ ዉዛክቶነ አሲን ዛጉክዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","ኤሲስማቶ ኤስ ትሹኒ አሱኒ ሜያኖን ኤሻናስ ሾዎ ቴሳ ማጙ ዉዛሲክቶኖን ዛግትዋ። ኤስ አሱኒ ሜያ ትሾኔስ ደይ ፋርሶነክ ዛጉኒ ፉቶሶን ሹንነ ኤጴቶ ቤየቴ ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","ኤስ ባሪ ቦርኣ ሀኦስ ኤሻሲክ አማኖሶነክ ዳግሱኒ ሁግና ባሶስታ ዎሱና። ");
INSERT INTO jnje_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","ኤስ ባር ደይ ስናናስ ፉቶሶን ኣፋ አማኖኒዉዛ ይሴፋት ቦርቤሲሲክ ግርሴፌ ባሶ ዙታምቤሲሴ አሲስታ ማጝሱ ካቶናክዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","ዳሚሲክ ሹንቶ አይኒ ሜያነ! እንኖ ዎንና ዎንና ንቶ ቦርአ ሀኦሶን ጋላቶኒክ ሾልስፋዋ፤ ሀኦስ አያናባሲክ ኮርቶ ዛግና ቦርአናዋ ፉቶሲክ አማነራ ፋሩሶትክ ዜምማ ንቶትን ኮርና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","ዳምኒ የሱስ ክርስቶስኒ ኡልፍናሶን ሃኦሶትክቱ እንኖ ንቶክ ማኬኒ ምስራቹኒ ካማስኪ ካሞ ንቶትን ቴጌዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","ኤስ ባሪ ቦርአ አይታሳክቶኖ! ችምማ የሮትዋ፤ ካምኒሲክ ስኑን ዎስኒሲክ እንኖ ንቶክ ማኬኒ አሱሶን ዛግራ ኤጶትዋ። ");
INSERT INTO jnje_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","ዳምኒ የሱስ ክርስቶስናዋ እኖትን ሹንና፤ ኦቱምባሲክ ኮእባ ፎንቶ ችማሶን፤ ማአ አብዲሶን እኖክ እማ አባ ሀኦኒሴ፤ ");
INSERT INTO jnje_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","ማአር ስና ዉዛሶን ዙትራ ዛጉትክናዋ ማኮትክና ንብንትሶን ችናዉጝዋ፤ ማአ ዉዛሶን ዙትራ ዛጉትክናዋ ዎሎትክና ንቶትን ችናዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","ኮእባስታክ ደይ አይኒ ሜያነ! ንቶኪክ ስንናይሲማቶ ዳሚሳ ካማ ታፕቴራ ዝእኡናክናዋ ኡልፍንቶናክና እኖክ ሺጶትዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","ኤሲሲማቶ ደይ ካምባሶን ኦዴ ባሶ ዙታምቤሲሴ አማኖሶነርቴዋ፤ ኤስ ባሪ ቦርኣ ኤልጝ አሱኒ ሜያኪንናዋ ማጙ አሱኒ ሜያኪንና ፉእቶኒክ እኖክ ሺጶትዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","ስኑንታኖ ዳሚስ አማናምቶዋ፤ ባር ንቶትን ችኑና፤ ሴጣናስኪን ደይ ንቶትን ኦዳናዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","ንቶክ አጃጀኒ ባሮን ሀሽ ስኑን ሀንኔን ዛግሶትማቶ ዳሚሲክ ንቶትን አማነፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","ዳሚስ ንብንትሶን ሀኦሲ ኬሽታናሲክናዋ ክርስቶስኒ ፋክያሲክና ንቶትን ዞንሳዎዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","አይኒ ሜያነ! ዎስቶ ኮቴፌ ባሶስታንናዋ እኖኪን ማክቴ አሱሲማቶ ፎኖይ ክርስታና ዙታምባሴ አሲስታንና ኦር ኬሳትክ ዳም የሱስ ክርስቶስኒ ሱናሲክ ንቶትን አጃጀፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","እንኖ ቤስኒ ቤሶሲክ ዞኑስቶትክ ሾልሲፋናማቶ ንቶ ቴትንትሲክ አርሴፌትዋ። እንኖ ንቶኔን አነ ፋኒ ካባሲክ ዎስቶ ኮታ አሱ ኣነ ስነኒዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","ደይ ኣፌ አሱኒ ቱሻኑ ባክ ኣነ ሙዌኒዋ፤ ስኑንታኖ ንቶስን ኦኒስታኑ ባአ ስኖይኒማቶ ዋላክናዋ ዎናክና ሆፕትናዋ ካቤትና ዎስቴት ፋኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","ኤስ ባሮን ዛግኒስ እንኖ ቤስኒ ቤሶሲክ ዞኑስቶት ኡክታኖ ንቶኪን እኖክ አርጋሱ ዳናኒክ ማብትን ትሽፋንታዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","ንቶኔን አነ ፋኒ ካባሲክ፦ «ዎስቶ ሹኖይ ባር ሙናታዋ» ይፋ ቱማ ንቶክ እማ ፋኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","ኤስ ባሮን ይኒስ ንቶ ጋነያስሲ እሳ እሳ ሜያ ዎስቶኒ ኮትኛ ፌሴቴር ስንናማቶ ኦደፋትዋ፤ ኤስ አሱኒ ሜያ ባሶትን ትርኦኖይ ዉዛሲ ግርሴፋፌ ኦምኒ ሜያኖን ራክሱታኖ ኣነ ዎስቴሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","ኤስ ኤፌቴና አሱኒ ሜያ ዲሬ ዎስቶሶነክናዋ ፎቤሲሲክ ሾልሱሶን ዳኖነክና ዳም የሱስ ክርስቶስኒ ሱናሲክ ባሶትን አጃጀፌኒ፤ ደይ ኪትፌኒ። ");
INSERT INTO jnje_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","ስኑንታኖ ንቶ አይኒ ሜያነ! ማአ ዎስቶኒ ዎስቶስቶሲክ ምክሾትታዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","ሀን ንቶክ ማኬኒ ኪቶሶን ኤጴቶኖይ አሱ ፌፋናነ ኤስ አሱስን ጋሳሱትዋ፤ ዎስቶባሲክ ኢቾናክ ባርኔን አነ እሳር ስናትታዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","ስኑንታኖ አይ ዛግራ ኬኡትታኖ ጉማ ዛግራ ፋዱትታዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","ናጋኒ ዳሚስ ቴትባሲክ ዎንና ዎንና ዙታምባሴ አሲክ ንቶክ ናጋሶን እማዎዋ፤ ዳሚስ ዙታምኒትስኔን አነ ስንፋዎዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","ሀን ናጋ ኦሽሾኒ ትቻሶን ኩሹናሲክ ትቺስ ታ ጳዉሎስዋ፤ ታ ዎሲያ ዙታምባሴ አሲሲ ፋ ማላቶስ ሀኒስዋ፤ ትችፋናስ ደይ ኤካዋ። ");
INSERT INTO jnje_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","ዳምኒ የሱስ ክርስቶስኒ ኦትማስ ዙታምኒትሴኔን አነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","እንኖትን ፋቲ ሀኦሲክ፤ አብድኒ ስና የሱስ ክርስቶስኒ አጃጂሲክ የሱስ ክርስቶስኒ ዎሲ ስና ጳዉሎስኒኪን፤ ");
INSERT INTO jnje_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","አማኖክ ፉቶኒ ናታ ስና ትሞትዮስኒክ አባኒ ስና ሀኦስኪን ደይ ዳምኒ የሱስ ክርስቶስኒ ኦትማሴዋ ፋክያሴ ደይ ናጋሴ ኔክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","ሜቀዶኒያ ሀምፋት ኔክ አዳራ ይናማቶ ኤስታ ፌሴ እሳ እሳ አሱኒ ሜያ ኤሻ አስሱ አሱኖይቴማቶ ዛጉታክ ኤፌሶኑክ «ዱዋ» ይጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","ኬእኖይ ቶቾነዋ ኮእባ ፎንቶ ስና ኮንቶኒ ፋዳሲ ዎልሴሬ ግርሶኖይቴማቶ አጃጆዋ። ኤስ ዉዛሲክቶ ክሪኪርቱ ኤጳ ያፋታኖ አማኖክ ዛግቴፋ ሀኦሲ ዎስቶክ ኣነ ኬእፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","ሀን አጃጅሲ አላማ ደይ ካይማ ንብስን፤ ማአ ካኑስን፥ ፉቶኒ አማንቶታን ቤስቴ ኬሽታናዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","እሳ እሳ አሱኒ ሜያ ሀን ኤፋቴና ቾዋስታን ኦር ኬሴሬ ኬእኖይ ዎላሲ ዎልሴቴ። ");
INSERT INTO jnje_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","ኤስ ባሮን ዛግሴፌስ ቱማሲ አሲኛ ስናክ ሾልሴፋትዋ። ስኑንታኖ ማክሴፌ ባሮን ኣነ አርሴፌ ወደይ እንኖ ፉቶዋ ይሴፌ ዉዛሶን ኣነ ያዳቴሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","አሱ ማእሲሬ ዎስቴፋናነ ቱማስ ማአር ስንባሶን አርፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","ኤሲስማቶ ደይ ቱማስ ቱምቴናስ ማአ አሱኒ ሜያክ ስና ሻኪናማቶ አርፌኒዋ። ቱማ ቱምቴናስ ማጙኒ ሜያክናዋ ቱማሲ ፎንቶ ዉዛሶን ዛግሴፌ ባሶክ፤ ሀኦሶን ሺጶ ቤይፌ ቦርኒ ሜያክ፤ ኮርቶቤስ ፎንቶ ሀኦሲ ካምኒማቶ ፎሶን ካሺፌ ባሶክ፤ አባ እንቶሶን ዎርሴፌ ባሶክናዋ ካ ዎርሴፌ ባሶክናዋ ");
INSERT INTO jnje_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","ኤሲስማቶ ደይ ጌርኬሴፌ ባሶክናዋ ኣርቃርና ኣርቃርና ዎል ኤጴፌ ባሶክና፤ አሱኒን ኡኬ ኤጴ ታሜ ዋግሴፌ ናጋደኒ ሜናዋ ኤሽቱኒ ሜናዋ። ኤሻክ ቴይፌ ባሶክናዋ ፉቶኒ አሱሶን አልዳ ዛግሴፌ ባሶክዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","ፉቶኒ አሱስ ሀኦስ ታክ አዳራክ እምና ኡልፍንቶ ምስራቹኒ ካማስኔን እሳርባ ፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","ታን ዎስቶክ ኮሪሬ አማናምቶ አስሱ ዛግሬ ፋድሬ ታክ ሁግና እማ ዳምኒ የሱስ ክርስቶስኒን ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","አዉነ ፋሮኑ ዜሞ ስናክ ክርስቶስኒን ሜአሪ፤ ካብግር፤ ሳልጲሲር ስንፋናክኑ ባር ታክ ፋኪ። ባር ደይ ታክ ፋኪናስ ታ ኤስ ዉዛሲክቶኖን ዙትራ አሩኖይናዋ አማኖኖይና ዛግናር ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","ሀኦኒሲ ኦትማ የሱስ ክርስቶስኒኪን ስና አማንቶሴዋ ኬሽታናሴ አነ ዳይስቴራ ታክ እምቴ። ");
INSERT INTO jnje_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","«የሱስ ክርስቶስ ቦርኒ ሜያኖን ፋቱክቱ ሀን ዳስታ የዋ» ይፋ ካማስ ፉቶነዋ አሱ ዙቴሬ ኤጴቶናክ ሾልሱዋ። ቦርእኒ ሜያሲን አሪክሮን ቦርእባ ፌናስ ታዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","ስኑንታኖ ታክ ፋኪያ ዛግቴዋ። ፋኪያ ዛግቴናስ የሱስ ክርስቶስ ኮእባ ፎንቶ ፋኪባሶን አሱ ዙታምባሴ አሲስታን አሪክሮን ቦርእ ስና ታይስታ ቤሱባሲክዋ። ኤሲስ ደይ ባርክ አማነፌ ባሶ ኮእባ ፎንቶ ካ ዳኖሶኒ ባሶክ ቤሶ ስናናክዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","ኤስ ባሪ ቦርኣ ኮእባ ፎንቶ ታቶ፤ ክቱኖይ ባሪክ፥ ቢስቶኖይ ባሪክ፤ እሳ ሀኦሲክ ኡልፍነዋ ጋላትነ ሀውጙኔን ካብራ ሀማ ኮእባ ፎንቶኖን ስንፋውጝዋ! ኣሚን። ");
INSERT INTO jnje_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","ናታ ትሞትዮስኖ! ዜሞ ስናክ ኔክ ራጅክ ማክቴናሲማቶ ሀን አጃጂሶን አዳራክ ኔክ እማናዋ። ኤስ ራጅሲክ ዞኑስቴፋት ማአ ኔቦ ኔቦዋ። ");
INSERT INTO jnje_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","አማኖነዋ ማአ ካኑነ ኔክ ፋፋዉጝዋ። እሳ እሳ አሱኒ ሜያ ካኑቤሲሶን ኦዶኖይ ሜርኬቢሶን እፑዋስ ካልላ ትሽክፋናሲማቶ አማንቶቤሲሶን ትሽክሴቴ። ");
INSERT INTO jnje_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","ኤስ ባሶስን ሄሜነዎስናዋ እስኪንድርና ፌሴቴርዋ። ባሶ ሀኦስታ ሜእኒ ካማ ማክሶኖይቴማቶ አርሶነክ ሴጣናሲክ ኣትራ እምጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","ሀኦሶን ሺጶክናዋ ኡልፍንባሬ የሬ ካክና ማምሱ፥ ሺጶ፥ ናቱነዋ ጋላትነ አሱ ዙታምባሴ አሲክ ዛግቶናክ ኪትፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","ሀኦሶን ድጎክናዋ ማአ አማላክን ዞኑስቶክና፤ ናጋክናዋ ኮቾኖን ፎኒክ ደይ አርክሮን ታቶኒ ሜያክናዋ ሀእሱኒ ሁግናቤሲ ፋና ቴጋ ድማስታ ፌሴ ባሶክ ዙትራ ሺጶቲ። ");
INSERT INTO jnje_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","ኤስ ኤፋ ሺጶስ እኖትን ፋቲ ሀኦሲ ስና ማአር ደይ ግርሱ ዉዛዋ ");
INSERT INTO jnje_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","ሀኦሲ ሳፋራ አሱኒ ሜያ ዙቴሬ ፋርሶነክናዋ ፉቶሶን አርሶነክዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","ሀኦስ እሳርዋ፤ ጋነያሲ ፌፋት ሀኦሴዋ አሱስንና አሲን ጋንስፌስ ደይ እሳርዋ። ኤስ ባር ደይ አሱ ስና የሱስ ክርስቶስዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","አሱኒ ሜያኖን ዙትሬ ቦርቤሲስን ፉሮክ ቴትባሶን ፉሪ ዛግሬ እማስ ደይ ባርዋ። ኤሲስ ደይ ፉቶኒ ዎንባ ካርፋና ካባሲክ ሀኦሲ ፋቱኒ ዎስቶሶን ቤስፋ ዛላዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","ታ ደይ አማንቶኒ ካማሶንናዋ ፉቶኒ ካማሶንና ማኮክ ዎሲናዋ አስኛና ስንና አዛብኒ ሜያክ ዎስቴናስ ኤስ ባሪ ቦርኣዋ። ኤስ ባሮን ደይ ማኬፋና ካባሲክ ፉቶሶንቱ ማኬፋንታኖ ኤሻኖንታዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","ኤሴ ኣፍፋ ድማስታኑ ፌ ኣርቃሱኒ ሜያ ግእነዋ ፋሶነ ቤየ ቴትቤሲሶን ሀኦሲክ ኮሪሬ ኩሹብሲሶን ካቡግሴሬ ሺጶሶነክ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","ኤሲስማቶ ደይ ማሽካ ሜያ ሶምቤሲሶን ኬሹክ ወደይ ዋርቄክ ወደይ እንቁክ ወደይ ዋግባ ችማ ማምኒ ማያክ ስኖይናሮን ድጋክናዋ ቴትኒ ዳ ኤጳክና ባሶክ ሾልሱ ስና ማማ ማዮቶ። ");
INSERT INTO jnje_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","ሀኦሶን ሺጴፌኒ ይሴፌ ማሽካ ሜያ ዛግሶነክ ሾልሱ ኡግናክ ማአ ዎስቶክ ቴትቤሲሶን ኬሹሶቶ። ");
INSERT INTO jnje_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","ማሽካ አሱ ድጎክናዋ አጃጃሞክና አሩን። ");
INSERT INTO jnje_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","ማሽካ አሱ ኣርቃሱኒን አሱናክ ወደይ ኣርቃሱሳታ ሀእሱኒ ሁግናባ ፎናክ ታ ኣፋ ማእ ኡናዉዛ። ባር ሻኩናክቱ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","ዜምሜ ቴስቴስ አዳምዋ፤ ኦርፎቱ ሄዋን ደይ ቴስቴዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","ደይ ኤሽቴስናዋ ሀኦሲ ቱማኖን ኣታስና ማሽካስታኖ አዳምቴዋ። ");
INSERT INTO jnje_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","ስኑንታኖ ማሽካሱ አማኖክናዋ ኬሽታናክና ደይ ኮርቶክ ቴትባሶን ኦድዳ ፋራ ናኒ ኮጶክቱ ፋሩናዋ። ");
INSERT INTO jnje_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","እሳ አሱ፦ «ቤቴክርስታንኒ ኩርኡ ስናናክ ሾሌፋናነ ኡልፍንቶ ዎስቶቱ ካልቴፌዋ» ይፋ ካማስ ፉቶዋ። ");
INSERT INTO jnje_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","ኤስ ባሪ ቦርኣ ቤቴክርስታንንኒ ኩርኡ ስና አሱ ዝናባ ፎንቶ፥ እሳ አሱኒ ቴጎ፥ ማአሪክ ፌፌር፥ ቴትባሶን ሀእሲር፥ ሾልሱ ኡግናሲክ ዎስቴር፥ እርባኒ ኤጳር፥ አሱክ ችምባ ፌናር፤ ");
INSERT INTO jnje_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","ዛዮኖር፥ ክርክር ሹንኖር፥ ጋራም፥ ቾዋ ሾሎኖር፥ ዋጋ ኬሽቶኖር፤ ");
INSERT INTO jnje_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","ባሳ ኬርኪ አሱኒ ሜያኖን ማእስሬ ሀእሱክ ችማር፥ ናንጎትባሲክ ሾልሱ ኡልፍና እሜት አጃጃሜር ስናናክቱ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","አሱ ባሳ ኬርኪ አሱኒ ሜያኖን ሀእሱክ ችምኖር ስንፋናነ ሀኦኒ ቤቴክርስታኒሶን ኣካክ ሀእሱክ ችምኒርን? ");
INSERT INTO jnje_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","ቤጋንቶክ ቴትባሶን ቴግሬ ዳቡሎስኒስታ ማጝሱ ካቴናሲማቶ ስንኖይናማቶ ጋድዶ አማኚስ ቤቴክርስታኒሲ ዞንሲ ስናናታዋ። ");
INSERT INTO jnje_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","ዝናክናዋ ሴጣናኒ ኤሽምያሲ ግሩኖይናማቶና አማኖኖይ አሱኒ ሜኒ ስና ማአ ሱንባ ፎናክ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","ኤሲስማቶ ዳቆኝኒ ሜያ ኡልፍንቶናዋ ዎሉምቤሲሲክ ዛግ፤ አካማ ዋይኒን ኡሻ ኡሽኖር፤ ዋጋ ጆሮኖር ስኖነክቱ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","ደይ አማንቶኒ ኣቾ ቾዋሶን ካይማ ካኑክ ኦዳር ስናናክ ሾልስፋ። ");
INSERT INTO jnje_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","ባሶ ደይ ዜምሜ ፋታንቶሶቶ፤ ኤስታን ዝናቤስ ፎንቶ ስነሬ ቤስቴሴፋቴነ ዳቆኝ ስንነ ዎስቶሶቶ። ");
INSERT INTO jnje_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","ኤሲስማቶ አሱቤሲሲክቶ ኡልፍንቶ፤ አሱኒን ሀማቶኖር፤ ማአሪክ ፋር፤ ዙታምባሴ አሲስታክ አማናምቴር ስናናክ ሾልሲፋ። ");
INSERT INTO jnje_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","ዳቆኝኒ ሜያ እሳ እሳርቤሲስ እሳ አሱኒ ቴጎ ስኖነክ ሾልሲፋ። ናንጎትቤሲሶንናዋ ኬርኪ ባሶትንና ማአሪክ ሀእሱሶነክቱ ሾልሲፋ። ");
INSERT INTO jnje_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","ዳቆኝኒ ዎስቶሶን ማአሪክ ዎስቴሴፌ ባሶክ አካማ ኡልፍናቱ ሾልሲፋዋ። የሱስ ክርስቶስኒስታ ፋ አማንቶቤሲሲክ ደይ ድጋ ፎንቶኖን ማኮኒ ችማ ዳኖሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","ኔኪ ዮናክ አብዲ ዛግፋናክኑ ሀን አጃጂሶን ኔክ ትችፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","ኤስ ባሮን ደይ ትቺናስ ታ ዎክፋናክኑ አሱኒ ሜያ ሀኦሲ ኬሩክ ኣካክ ፎሶነማቶ አሩታክዋ። ኬያስ ደይ ሀየዋ ሀኦሲ ቤቴክርስታኒዋ። ባር ደይ ፉቶኒ ዬቶነዋ ካፑትነዋ። ");
INSERT INTO jnje_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","ፉቶኒ ሀይማኖቲሲ ኣቾ ቾዋ ኤክ ሀጝ ኡባ ፎንቶኖን አካማዋ። ኤስ ባር ደይ ሀኦስ፦ «አሱ ስንነ አምማኖን ቤስቴ፤ ፉቶ ስንባስ አያናክ አርቴ፤ ሀኦኒ ዎሲያክ ቤስቴ፤ ዳራ ዙታምባሴ አሲክ ማክቴ፤ ሀን ዳስታኪ ፌ አሱኒ ሜያ አማነሴቴ፤ ኡልፍናክ ደን ሳማ ሀሚ» ይፋርዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","ኮርቶ አያናስ አምማኖን፦ «ኦርፎስታኪ ነያሲ እሳ እሳ አሱኒ ሜያ ኤሽቱ ዳግሲፋ አያናሶንናዋ ኪናስ አሱክና ዞኑስቴሴሬ ሀይማኖትቤሲሶን ሞርሞሶነዋ» ይፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","ኤስ ኤፋቴና አስሱሲ ኮርአ ታነ ፌ አሱ ኣፌ ኡሲ፤ ኤሻኖን ዎል ሌሴፌ ካባሲክ ኪቹ ብታክ ኪቼርነ ፋሮን ታቻ ካኑቤስ ፋና አሱኒ ሜያክጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","ኤስ ኤፌቴና አሱኒ ሜያ ኤጵነ ግሩነ አሲን ካለቱ ፌሴፌዋ። አማነፌ ባሶናዋ ፉቶሶን አርሴፌ ባሶና ባሮን ጋላቴሴት ሙሶነክ ሀኦስ ቴስና ሙሶን፦ «ሙትታ» ይት ካለፌ። ");
INSERT INTO jnje_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","ሀኦስ ቴስና ሙስ ዙቴራ ማአርዋ። ጋላታክ ኤጴቴሴፋቴነ ሀእቶኒ ዉዛ እሳንነ ኣፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","ሀኦሲ ካማክናዋ ሺጶክና ካይማ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","ሀን አሩሶን አማኝኒ ሜያክ አስሳታነ የሱስ ክርስቶስኒ ማአ ዎስትኛ ስናታዋ። ኤስ ፉቶኒ ካማሲክ ዞኑስቴፋታነ ድችኔሶን አምማኖን ቤሱታዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","ሀኦሶን ሺጶ ስንኖይ ሀን ዳስታኪ ቶቾስታን ዎክዋ። ሀኦሶን ሺጶክ ቴትኔስ ዶስቶናክ ዛጉዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","አቱ ችማናክ ዛግፋ አሱሲክ ቴትኔስ ዶስቶናክ ዛጉ ኬእፋናስ ጋሮኖንጝዋ። ስኑንታኖ ሀኦሶን ሺጶክ ቴትኔስ ዶስቶናክ ዛጉስ ሀሽቲ ባሪክናዋ ዮኒ ካሲክና አብድባ ፋር ስንና ቦርአ ዙታምባሴ አሲክ ኬእአርዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","ሀን ካማስ አሱ ዙቴሬ ኤጴቶናክ ሾልሱ ደይ ፉቶ ዎላዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","እንኖ አሱ ዙታምባሴ አሲን አርክሮን ደይ አማነፌ ባሶትን ዙትራ ፋቱኒ ሀየዋ ሀኦሲክ አብድ ዛግኒር ስንና ቦርአ ዎስቶክ ሆፕፌኒ ደይ ካቤፌኒዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","ሀን ዉዛሲክቶኖን አጃጆ ደይ አስሱ። ");
INSERT INTO jnje_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","ናኦ አሱ ስንታ ቦርአ ኦኑ ኔን ካሹናታ። ስኑንታኖ ዎላክ፥ ፎክ፥ ኬሽታናክ፥ አማኖክናዋ ኮርቶክና አማነሴፌ ሜያክ ቤሶ ስጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","ታ ዮና ካባኔን ኮርቶ ማፃፋሶን አሱኒ ሜያክ ፌሬቱክ፤ ማኮክናዋ አሱክና ችምማ። ");
INSERT INTO jnje_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","ኔክ ራጅ ማክቴና ዎኖኔንናዋ ቤቴክርስታኒሲ ኩርኡኒ ሜና ነይስታ ኩሹቤሲሶን ታእሬ ሺጴሴቴ ዎኖት ኔክ እምቴ ሀኦሲ ኦቱምኒ እማኖን ዳጎታታዋ። ");
INSERT INTO jnje_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","ነ ድቻሶን አሱኒ ሜያ ዙቴሬ ብዮነክ ኤስ ዉዛስታ ችምማ። ኤስ ዉዛሲክቶኖን ዎስቶታ ፌሹክ አቱኔሶን ዙትራ ባሶክ እምማ። ");
INSERT INTO jnje_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","ነ ቴታሲክናዋ አሲፋታ አሱሲክና አሩዋ። ኤስ ዉዛሲክቶታ ችምማ። ኤስ ባሮን ዛጋታነ ቴትኔሶንናዋ ኦደፌ ባሶትንና ፉኦታዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","ኩርኡ አሱስን አባ ዛግራ ኪቱታኖ ኬኡታታዋ። ናኦ ኣርቃሱኒ ሜያኖን አይኒ ሜያ ዛግራ ኤጵዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","ኤሲስማቶ ኩርኡ ሜያኖን እንቶ ዛግራ ደይ ናኦ ማሽካ ናንጎታሶን ኤት ዛግራ ማአ ካይማክ ቢዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","ቴጎቤሲ ክትፋን ፉቶክ አርጋሱ ሾልሲና ድቻ አሱሲክቶኖን ኡልፍንሱዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","ኣፋ ቴጎባ ክትና ድቻ አሱሲ ናንጎትባ ወደይ ናባሲ ናንጎትባ ፋፋናነ ኤስ ናንጎታስ ዜምማ ኬርክ ሜያኖን አርጋሱናክ፤ ኮኒ ባሶክናዋ አፖኒ ሜያክና ድችሴቴ ኮዋሶን ዎልጉናክ ሀኦኒ ካምኒማቶ ሾልሱ ስንባሶን አሩሶንዋ። ኤስ ባር ደይ ሀኦሶን ግርሱኒ ዉዛዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","ድቻ ስንና ቴትባክ ፋፋ አሱስ አብድባሶን ሀኦስታ ዛግራ ዋላክናዋ ዎናክና ሀኦኒ አርጋሱ ዳናናክ ሺጶክ ችምማ ፎንዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","ስኑንታኖ ሀን ዳስታኪ ፎኒ ግራሶን ሾሌፋ ድቻ አሱ የሮባሴ ፋጌዶ ክቱዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","ዝና ፎንቶ ስንነ ፎሶነክ አሱኒ ሜያኖን አሱዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","እሳ አሱ ባሳ ቴትኒ ኮኒስን ወደይ አርክሮን ታእሶ ባሳ ኬርኪ አሱኒ ሜያኖን አርጋሱኖር ስንፋናነ ሀይማኖትባሶን ሞርሜ አሱዋ፤ ደይ አማኖኖይ አሱሳታን ደናሎ ማጙዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","ዎጋባስ እሱናስሬኔን ዳካሎ ስና ቴጎባስ ክትና አሱሶን ድቻ አሱሲክቶኒ ፋዳሲ ትቹታታዋ። ደይ እሳ ቴጎኒኪ ግርራ ፋር ስናናክ ሾልሲፋ። ");
INSERT INTO jnje_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","ባር ናንጎትኒ ድቹክ፤ እርባኒን ኤጴቶክ፥ አማኝኒ ሜኒ ዎቾ ማሳክ፥ ራክኮሲ ፌሴ ባሶትን አርጋሱክናዋ ማአ አማላክና ቴትባሶን እማክና ማአ ዎስቶክ አርቶ ስናናክቱ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","ባሶ አሽኒ ኤናንቶስ ባሶትን ሜሬራ ክርስቶስኒስታ ፋ ኬሽታንቤሲስ ዮእፋና ካባሲክ ቴጎኒኪ ግሩክ ሾልሴቴር ስንና ቦርአ ናኦ ድቻ አሱሲክቶኖን ማዝጋቢስ ትቹታታዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","ኤስ ድቻ አሱሲክቶ ዜሞቲ ግርሴቴ ቴያሶን ኦዳ ቤየቴር ስንና ቦርአ ባሶስታ ማጝሱ ካቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","ኤስ ባርስታን ደይ ዎስቶኒ ኮታክ አርሴቴር፤ ኤስ ባር ኮእባ ስኖይናሮን እሳ ኬሩን እሳ ኬር ሀሜፋፌ ባሶክ ሾልሱኖይ ዎል ላ ዎል ሌሴት ሀማቴትናዋ አሱኒ ቾዉሲ ግርሴር ስነቴር። ");
INSERT INTO jnje_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","ኤስ ባሪ ቦርኣ ናኦ ስንነ ፌሴቴን ቴጎቤስ ክትና ማሽካ ሜያ ግርሴሬ ናንጎታ ኮኑሶነክ፤ ኬቤሲሶን ሀእሱሶነክ ኪትፋንዋ። ኤስ ባሪክ ጉማስ ሱንኒ ማጝሱኒ ኡግና ቱርኩናዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","ዜሞ ስናክ ቴጎባ ክትና እሳ እሳ ማሽካ ሜያ ሴጣናሲክ ዞኑስቴሴሬ አማንቶኒ ኡግናስታን ሻቴሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","ክርስታና ስና እሳ አሱ ኬባሲክ ቴጎባ ክትና ድቻ አሱሲክቶ ፋሴፋናነ ቤቴክርስታኒሲክ ባአ ስኖኖይቴማቶ ኤስ አሱሲክቶኖን አርጋሱን። ኤካክ ቤቴክርስታኒስ አርጋሱኒ አሱባ ፎንቶ ድቻ አሱሲክቶኖን አርጋሱክ ችማናዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","ቤቴክርስታኒሶን ማእስሬ ሀእሲፌ ባሶ አርክሮን ደይ ካምባሶን ማኮክናዋ አሱክና ሆፕሴፌ ኩርኡኒ ሜያክ አካማ ኡልፍና ባሶክ ሾልሲርዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","ኮርቶ ማፃፋስሲ፦ «ሜያ እችፋ ጋችዋሲ ኖኖኖን ታርአታታ» ይስቴዋ። ኤሲስማቶ ደይ፦ «ዎስትኛሲክ ዳሞዛባ ካስቶናክ ሾልሲር» ይፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","ሄፕ ወደይ ኬዝ አሱኒ ሜያ ዛላ ማኮሶኖይቴሮን ቤቴክርስታንኒ ኩርኡሳታ ካእርፋ ማላታሶን ኤጳቶታታዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","ኦምኒ ሜያ ድግሶነክ ቦርአ ዎስቴ አሱስን አስሱ ዙታምባሴ አሲ ስናክ ኬእኡዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","ዛግፋታ ዉዛ ዙታምባሴ አሲስታ እሳይስን ኦሚሳታን አርክሱኖይ ወደይ ኦኒንኑ ኮሩኖይ ሀን ኪትፋና ባሮን ዛጉታክ ሀኦሲ ስናክናዋ የሱስ ክርስቶስኒክ ኮርቴ ሀኦሲ ዎስኒ ስናክና አዳራ ይፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","ኩሹኔሶን አሱኒስታ ታእሬ ታትሱክ ታፕቶታታዋ። ቴትኔሶን ካይማክ ኦድታኖ ኦም አሱኒ ሜያኔን ቦርኒ ዎስቶስኔን አነ እሳር ስንናታታዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","ካትኔሲ ሜሮሲክናዋ ዎንና ዎንና ሜሬፋ ሜሮኔሲክና ጋሮ ዋይኒን ኡሻ ኡሽታኖ አካ አካ ኡሻታታዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","እሳ እሳ አሱኒ ሜኒ ቦርኣስ አማ ስንባሲክ ታእኒን ማጝሱ ካቶኒር ስንባሶን ቤስፋዋ። ስኑንታኖ ኦም አሱኒ ሜኒ ቦርኣስ አምማኖን ቤስቴፋናስ ዎካዋ። ");
INSERT INTO jnje_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","ኤሲስማቶ ማአ ዎስቶስ ደይ አምማዋ፤ አምማ ስንኖይ ባር ደይ ኣቸራ ኣፋ ፉእቶናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","ሀኦሲ ሱንነዋ እንኖ አስሱሴ ሜቾኖይናማቶ ቦዝኒ ሜያ ዙቴሬ ዳምቤሲሳክቶኒክ ሾልሲፋናማቶ ኡልፍንሱሶቶ። ");
INSERT INTO jnje_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","ዳምቤሲስ አማኝ ስነ ቦዝኒ ሜያ ዳም የሱስኒኪ ካሞ አይ ስነቴ ቦርአ ካሹሶሶኔታዋ። ኤስ ባርስታን ዎሲቴሴፌ ዎስቶስታን ቡአ ዳነፌ ዳምኒ ሜያ አማኝ ደይ ሹንቶ አይኒ ሜያ ስነቴ ቦርአ ዜሞቲስታን አርክስሬ ባሶክ ዎስቶሶቶ። ነ ደይ አሱታክናዋ ኪቱታክና ሾልሲናስ ኤሲሶጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","ፉቶኒ ሀኦሶን ሺጶኒ አሱስነን አነ እሳር ስና ባሮን፤ ዳምኒ የሱስ ክርስቶስኒ ካይማ ካማሶን ቤይፋት ኦማ አስሱ አሲፌ ባር፤ ");
INSERT INTO jnje_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","ኤስ አሱስ ቤጋንቶክ ክቴ እሳ ዉዛኑ ኣነ አርፌዋ። ስኑንታኖ ስንኖይ ካምኒ ካራካሮነዋ ፋሶነ አሲ ማጙ ኤናንቶቱ ባሳስ ፋርዋ። ኤስ ባር ደይ ማጙ ኮና፥ ፋሶ፥ ሜአ፥ ማጙ ላጰባቶነ፤ ");
INSERT INTO jnje_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","ኤስ ዉዛሲክቶ ደይ ፉቶሶን ኦምቴ አሱኒ ሜኒ ጋነያሲ ዛግቴፋ ቡዱኖይ ክርክርሶንቱ ኤጳ ያፋዋ። ኤስ ኤፌቴና አሱኒ ሜያ ሀኦሶን ሺጶስ ባሶክ ኦቱምኒ ዳንኒ ኡግና ስንናቱ ቤስቴፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","ስኑንታኖ፦ «ፋዪስ ታክ ሆሮና» ይፌ አሱሳ ሀኦኒ ሺጶስ ባሪክ አካማ ቡአባዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","እንኖ ሀን ዳስታክ እሳ ዉዛነ ኣነ ኤጳ ዮዌኒዋ። እሳ ዉዛ ደይ ኤጴ ሀን ዳስታን ኤጳ ሀማኒር ኣፋ። ");
INSERT INTO jnje_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","ኤስ ባሪ ቦርኣ ሙነዋ ማምነ እኖክ ፋፋናነ ሆሮናዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","ስኑንታኖ ኦቱም አሱ ስናክ ሾልሴፌ ሜያ ፋታናሲቱ ጋንደሴፌዋ። አሱኒ ሜያኖን ማጝስራ ትሽክፋ ኬእኖይ አካማ ማጙ ኤናንቶኒ ኤሽምያሲክቱ ኦቴሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","እሳ እሳ ሜያ ኤስ ባሮን ኤናንቴሴሬ ሀይማኖትስታን ሻቴሴሬ አካማ ሻናሲ ጋንደሴቴዋ። ኤስ ባር ደይ ስንፋናስ ብርኒ ሹናስ ማጙ ዙታምባሴ አሲ ቱዛ ስንና ቦርአዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","ሀኦኒ አሱኖ! ነ ኤስ ባር ዙታምባሴ አሲስታን ሻቶዋ። ኦኮ ስናሶን፥ ፉቶኒ ሀኦሲ ካምኒማቶ ፎሶን፥ አማንቶሶን፥ ኬሽታናሶን፥ ፋክያሶን፥ ችምሜ የሮሶንናዋ ጋራማሶንና ሾሎዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","ማአ አማንቶኒ ኔቦሶን ኔቦዋ። ሾዎ ዛልኒ ሜኒ ስና ፉቶኒ ዛላ ማኬታ ኮእባ ፎንቶ ካሶን ዛግራ ኤጵዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","ዙታምባሴ አሲክ ካ እምፋ ሀኦሲክናዋ ፐንቴናው ጵላጦስኒ ስና ማአ አማንቶክ ዛላ ማኬ የሱስ ክርስቶስኒ ስናክና ኔን አጃጀፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","ዳምኒ የሱስ ክርስቶስ አምማኖን ቤስቶና ካባኔን ሀን አጃጂሶን ኪናነዋ ዝንነ ፎንቶና ስንና ኦድዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","ኤስ ክርስቶስኒ አማ ቤስቶስ ሱስቶነዋ ባር ባር አእስኛ ስና ታቶኒ ሜኒ ታቶ፥ ዳምኒ ሜኒ ዳም ስና ባር ዱስና ዎናስታክ ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","ባር ባርቱ ክቱኖርዋ፤ ኦኑ ታኤ ብያክ ችምኖይና ቻሬፋሲቱ ፌፌዋ። ባሪን ብያር እሳር ኦኑ ኣፌ፤ ኦኑ ደይ ባሪን ብያናክ ኣፋ ችማናዉዛ። ኡልፍነዋ ኮእባ ፎንቶ ሁግናነ ባሪክ ስንፋውጝ፥ ኣሚን። ");
INSERT INTO jnje_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","ሀን ዳስታኪ ኦቱምኒ ሜያ ትሹኒ ኦቱምቤሲሲክ ጌእኦኖይቴማቶ ወደይ አብድቤሲሶን ስንኖይ ኦትማስታ ዛግሶኖይቴማቶ አጃጆዋ። አብድቤሲስ እኖትን ግርሱናክ ዙታምባሴ አሲን አርክስራ እምፋ ሀኦስታ ዛግሶነክ አጃጆዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","ደይ ማአ ዎስቶ ዎስቶሶነክ ባሶክ ፋ ባሮን ደይ ሃእኤ እማክ ማእ ኡሶነክ አጃጆዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","ኤስ ባሪክ ፉቶ ስና ካሶን ዳኖነክ ዮኒ ነያሲክ ደይ ዛጋ ካፑትባ ፋና ኦትማ ባሶ ቴታሲክ ዙቱሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","ትሞትዮስኖ! አዳራክ ኔክ እምቴ ባሮን ኦድዋ፤ ሀኦሶን ኡልፍንሱኖር ባክ ዎላስንናዋ ቱጋኦክ ኤሽኒ አሩ ስና ቴችማስን ዎክዋ። ");
INSERT INTO jnje_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","ኤስ ኤፋቴና አሩኒ ፋር ይሴት ፌሴ እሳ እሳ አሱኒ ሜያ ኤስ ባሮን ዛጉክ አማንቶኒ ኡግናስታን ሻቴሴቴዋ። ሀኦሲ ኦትማ ንቶኔን አነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","የሱስ ክርስቶስኒኪን ቤስቴ ካኒ አብዲሲክ ሀኦሲ ፍቃድክ የሱስ ክርስቶስኒ ዎሲ ስና ጳዉሎስኒኪን ዎስቴ ዎሲያ፤ ");
INSERT INTO jnje_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","ሹንቶ ናታ ጢሞትዮስኒክ፤ አባ ሀኦኒሲክንናዋ ዳምኒ የሱስ ክርስቶስኒክንና ኦቱምነዋ ፋክነ ደይ ናጋነ ኔክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","ዎንና ዎንና ዎንነዋ ዋልነ ሺጶናሲክ ኔን ሳፋሬፋና ካባሲክ ታ አባኒ ሜያ ዛግሴቴሲማቶ ታ ደይ ካይማ ካኑክ ባሪክ ዎስቴፋና ሀኦሶን ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","አራፍኔሶን ያዳቴድፋዉጝዋ፤ ኤስ ባሪ ቦርኣ አካማኖን ግሮናክ ኔን ብያናክ ካልቴፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","ኔኪክ ፋ ፉቶኒ አማንቶሶን ያዳቴድፋንዋ። ኤፋቴና አማንቶስ ዜምማ አፋነ ሎይድያኪክ ደይ እንቶነ ኤዉንቄኪክቱ ፋዋ። ኔኪክ ደይ ፋናማቶ አሪጙዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","ኤስ ባሪ ቦርኣ ኩሹናሶን ነይስታ ታእፋና ካባሲክ ኔክ እምቴ ጌኒማቶ ስንና ነይሲ ፋ ሀኦሲ እማኖን ሄፕሳ ዎልግራ ጌኒማቶ ሳምማ ዳይሲት ሀማናክ ያዳሲፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","ሀኦ እኖክ እምና እማስ ሁግናኒር፥ ኬሽታኒር፥ ደይ ቴትኒ ሀእሱኒ ኮርቶ አያናታኖ ድጋኒ አያናታዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","ኤሴ ዳምኒሳ ቾዋኖን ማኮሶን ኢቾታታዋ። ባሳ ቦርአ ታቴሬ ፌ ታክ ደይ ኢቾታታዋ። ስኑንታኖ ሀኦ ኔክ እማና ሁግናሲክ ምስራቹኒ ካማሲ ቦርአ ዮኒ ሻናሶን ኤጳቶዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","ባር እንኖ ዛግኒ ማአ ዎስቶክ ስንኖይናማቶ ቴትባሲ ሹናክናዋ ኦቱምባሲክና እኖትን ፋቲዋ። ኮርቶ ስንና ፎኒክ እኖትን ቴጌ። ኤስ ኦትማሶን ነያኔን ስናክ የሱስ ክርስቶስኒኪ ካሞ እኖክ እሚዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","ኤስ ኦትማስ ደይ እኖትን ፋቲ የሱስ ክርስቶስ ዮባሲክ አምማኖን ቤስቴ። ባር ክቱሲ ሁግናኖን ትሽክሬ ምስራቹኒ ካማሲኪ ካሞ ክቱኖይ ኮእባ ፎንቶ ካ አምማኖን እኖክ ቤሲ። ");
INSERT INTO jnje_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","ታ ደይ ኤስ ምስራቹኒ ካማሶን ማኮኒ ዎሲ፤ አስኛ ስንና ቴግቴን። ");
INSERT INTO jnje_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","ሀን ራክኮሶን ኤጳታት ፋናስ ደይ ኤስ ባሪ ቦርኣዋ። ስኑንታኖ ኦኒን አማነናማቶ አሪፋና ቦርአ ኣፋ ኢቾናዉዛ። ታ እምና አዳራሶን ክርስቶስ ዎል ሌ ዮና ካባኔን ባር ኦዳ ችማናማቶ አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","ታኪን አሪታ አማናምቶ ካማሶን ቤሶ ዛግራ የሱስ ክርስቶስኒክ ፋ አማንቶሲክናዋ ኬሽታናሲክና ኦድዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","እንኖሲ ፋፋ ኮርቶ አያናስኪ ካሞ ኔክ እምቴ ማአ አዳራሶን ኦድዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","ኢስያኒ አዉራጃሲ ፌ ባሶ ዙቴሬ ታን ቤየ ሀሜቴማቶ አርፋትዋ። ባሶ ጋነያስን ፍጌሉስናዋ ሄርሞጌነስና ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","ዳሚስ ኦነስፎርኒ ኬርኪ ሜያክ ፋክባሶን እማዎዋ። ባር ሾዎ ዎና ታን ችኒ። ታቶናሲክኑ ኣነ ኢቾዌ። ");
INSERT INTO jnje_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","ሮምኪ ካታማ ዬና ካባሲክ ደይ ሾሌፌ ሾሌፌቱ ታን ዳኒ። ");
INSERT INTO jnje_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","ማጝሱኒ ካርኒ ዎኖ ዳሚስ ፋክባሶን እማዎዋ። ኤፌሶኑክ ፋና ካባሲክ አዉነ ፋሮን ታን አርጋሲናማቶ ነ ቴትኔሲክ ማእስራ አሪፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","ኤሴ ናታሶ! የሱስ ክርስቶስኒኪን ቤስቴፋ ኦትማሲክ ችምዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","ሾዎ ዛልኒ ሜኒ ስናክ ታኪን አሪታ አሩሶን ኦምኒ ሜያኖን አሱክ ችምኒ ባሶክናዋ አማናምቶ አሱኒ ሜያክና አዳራ እምማ። ");
INSERT INTO jnje_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","ነ ደይ የሱስ ክርስቶስኒ ማአ ሜያ ታርኦ ስንና ታኔን አነ ሻናሶን ኤጳቶዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","ታርኦ ስንነ ዎስቴፌ አሱ ሜያ ታርኦሳ ጋኛኒን ግርሱክ ሆሮ ስናናክቱ ሾልሲፋታኖ ታርኦስ ቴትባሪ ዎስቶሲ ኣነ ግሪፌዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","ኤሲስማቶ ደይ ኣቶ ኣቶ ኤልፌ አሱ ቱምባሲማቶ ኤልላ ሻካናነ ሜሬሬ ኤስ ሜሬና ባሪ ዎሱማ ኣፋ ዳናናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","ዎስቶክ ሆፕፌ ቡልኛአስ ዎስቴና ጋናስን ቴሱኒሶን ዳናናክ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","ዳሚስ ዙታምባሴ አሲክ ያዳታ ኔክ እማና ስንና ቦርአ ታ ማኬፋና ባሮን ማእስራ ያዳቶዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","ክቱን ካብ ባርናዋ ዳዊትኒ ዛላስን ስና የሱስ ክርስቶስኒን ያዳቶዋ። ታ ማኬፋና ምስራቹኒ ካማስ ኤሲስዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","ኤስ ምስራቹኒ ካማሲ ቦርአ ማጝሲ አሱኒማቶ ሻሻራክ ታቴራ ሻና ኤጳ ታድፋጝዋ። ስኑንታኖ ሀኦሲ ካማ ኣፋዋ ታቶናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","ኤስ ባሪ ቦርኣ ባሶ ደይ የሱስ ክርስቶስኒኪክ ፋ ፋሩሲኪ ካሞ ቤስቴፋ ኮእባ ፎንቶ ኡልፍና ዳኖነክ ሀኦ ኮሪና አሱኒ ሜያክዋ እያት ዙታምባሴ አሲን ፋክፋንዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","ኤካ ይፋ ካማስ አማንቶዋ፤ «ባርኔን አነ ክትፋኒነ፤ ባርኔን አነ ደይ ካክ ፎኒዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","ፋኪያክ ችምማ የሬፋኒነ፤ ባርኔን አነ ደይ ታቶኒዋ፤ ሞርሜፋኒነ ባር ደይ፤ እኖትን ሞርሞናዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","እንኖ አማናምቶ አሱ፤ ስና ሻካኒነ፤ ባር ቴትባሶን፤ ኣፋ ሞርሞናዉዛ ስንና ቦርአ፤ ኣጌኑ አማናምቶ ስንነቱ ፎናዋ።» ");
INSERT INTO jnje_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","ሀን ቾዋሶን ያዳትሶነክ ዛጉዋ። ካምታን ካብ ቾዋ ካራካርሶኖይቴማቶ ሀኦሲ ስና ቴትቤሲሶን ኦዶሶነክ ዛጉዋ። ኤስ ካምኒ ካራካሮስ ኦደሴፌ አሱኒ ሜያኖንቱ ትሽኩናታኖ እሳ ዉዛክኑ ኣነ ኬእፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","ፉቶኒ ሀኦሲ ካማኖን ልኪክ ካትፌ አሱኒማቶናዋ ዎስቶባሲክ ኢቾኖይ ዎስትኛ ስንና ቴትኔሶን ሀኦሲ ስና ታእሱክና ደይ ግርሲ አሱ ስናታክ ዱዶዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","ሀን ዳስታኪ ቾዉነዋ ሽማ ስና ዎላስታን ዎክዋ። ኤስ ኤፋቴና ዎላስ አሱኒ ሜያኖን ሀኦስታን ዳይስሬ ዎኮሶነክቱ ዛግፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","ኤስ ባሶ አስሱስ ፋሩኖይ ማዛኒማቶቱ ታግትቱ ሀምፋዋ። ኤስ ባሶ ጋነያሲን ሄሜነዎስናዋ ፍልቶስና ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","ኤስ አሱኒ ሜያ፦ «ክቱን ካቡ ዜሞ ስንናክቱ ስኒዋ» ይት ካራካሮክ ፉቶስታን ዎኬቴዋ። ደይ እሳ እሳ አሱኒ ሜኒ አማንቶሶን ሾርኪሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","ስኑንታኖ «ዳሚስ ባሳር ስና ባሶትን አሪፌዋ» ኤሲስማቶኑ፦ «ዳሚሳ ሱናኖን ቴጌፌ ባሶ ዙቴሬ ማጙስታን ዎኮሶቶ» ይስቴራ ትቼራ ሾርኮኖይ ሀኦሲ ካፕታስታ ማታማክ እቼዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","እኛ ኬያሲ ዋርቄክናዋ ብሪክና ዎሱስቴ ኮዳ ኮእባ ስንኖይናሮን እኦኪን ዎሱስቴ ኮዳነዋ ኦቸ ኮዳነቱ ፋሴር። ኤስ ባርስን እሳ እሳይስ ኡልፍንቶ ዎስቶክ፤ እሳ እሳይስ ኡልፍንባ ፎንቶ ዎስቶታቱ ፌሽፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","ኤስ ማጙ ዉዛስን ኮርቴሬ ኬሴ ካይም ስንነ ፌፌ አሱ ኡልፍንቶ ዎስቶታ ፌሽፋ ኮዳስነ ፌር ስናናዋ። ማአ ዎስቶክ ሆሬ ባር ዳሚሲክ ኮርቶ ስንነ ፌሬ ኬእኒ ኮዳ ስናና። ");
INSERT INTO jnje_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","ናኦኒ ሜኒ ማጙ ኤናንቶስታን ዎክዋ። ካይማ ንባክ ዳሚስን ቴግሴፌ አሱኒ ሜያኔን አነ ስንና ኦኮሶን፥ አማንቶሶን፥ ኬሽታናሶን፥ ናጋሶን ሾሎዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","ቾዋ ኤጳ ዮናማቶ አሪራ ጎዋ ስናስታንናዋ ኬእኖይ ሽማ ካራካሮስታንና ዎክዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","ዳምኒ ዎስትኛ ስና አሱ ዙታምባሴ አሲክ ጋራም፥ አሱክ ችማርናዋ ፋኪርና ስናናክቱ ሾልሲፋታኖ ፋሶናክ ኣነ ሾልስፋዋ። ");
INSERT INTO jnje_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","ባር ቱጋኤሴፌ ባሶትን ጋራማክ ኪትር ስናናክ ሾልሲፋዋ። አዉዛክነ ፉቶሶን አርሶነክ ሀኦስ ሀርሚን ኡግና ባሶክ እማናክ ችማና። ");
INSERT INTO jnje_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","ኤሲስማቶ ንቤሲሲኪ ዎልሴሬ ዳቡሎስ ባሳ ፍቃዲሶን ዛግሶነክ ባሶትን ኤጵኒ ኤሽምያስን አቴ ኬሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","ኮእኒ ዎኖ ራክሱኒ ዎና ዮናማቶ አሩዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","አሱኒ ሜያ ቴትቤሲሶን ኬሽቴር፥ ዋግኒ ዳናክ ጆሬር፥ ጌኤሴር፥ ቤጋንቴር፥ ሜኤሴር፥ አባ እንቶሲክ አጃጃሞኖር፥ ጋላትቤስ ፎንቶ፥ ኮርቶቤስ ፎንቶ፥ ");
INSERT INTO jnje_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","ኬሽታንቤስ ፎንቶ፥ ፌሹን ኡሶኖር፥ አሱኒ ሱና ማጝስሴር፥ ቴትቤሲሶን ሀእሱኖር፥ ኬና ቡዱ፥ ማአር ስና ዉዛሶን ኦምቴሴር፥ ");
INSERT INTO jnje_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","ሞርሜሴር፥ ቴትቤሲ ኦድኖር፥ ቤጋንቶክ ቱምሜ ፌሴር፥ ሀኦሶን ሹናስታን አሽቤሲሶን ግርሱ ሹናር ስኖነ። ");
INSERT INTO jnje_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","ሀኦሶን ሺጴድፌርነ ፌር ስንነቱ ቤስቴሴፌ፤ ስኑንታኖ ሀኦሲ ሺጶኒ ሁግናኖን ሞርሜሴፌ። ኤስ ኤፌቴና አሱኒ ሜያስታን ዎክዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","ኤስ አሱኒ ሜያ ኬያ ኬያስ አቴ ግሪሴፋፌ ሾዎ ቦርቤስ ቱልቴራ ፋና ሾዎ ቴሳ እጋክ ዞኑስቴሴፋ ሆፕያ አያናቤስ ፋና ማሽካሱሶን ባሶ ሀእሱሲ ዛግሴፌ አሱኒ ሜያነ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","ኤስ ኤፋቴና ማሽካሱሲክቶ ዎንና ዎንናቱ አርሴሴፌ፤ ስኑንታኖ ፉቶሶን አሩታ ካርአክ ኣነ ችሜሴፌ። ");
INSERT INTO jnje_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","እያነስናዋ እያንቤሬስና ሙሴኒን ቱጋሴሴቴማቶ ሀን ባሶ ካኑቤሲስ ማጝራ አማንቶኒ ቾዋሲክ ጋንደሴሬ ፌሴቴር ስንና ቦርአቱ ፉቶሶን ቱጋኤሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","እያነስናዋ እያንቤሬስና አሲ ጎዋስስ አምማኖን ቤስቴናማቶ ሀን ባሶ ጎዋስ ደይ አሱ ዙታምባሴ አሲ ስና አምማኖን ቤስቶኒር ስንና ቦርአ ኣፋ ዎስቶታ ፌሻናዉዛ። ");
INSERT INTO jnje_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","ስኑንታኖ ነ ታ አስሱሶን፥ ታ ፎሶን፥ ታ አላማሶን፥ ታ አማንቶሶን፥ ታ ፋክያሶን፥ ታ ኬሽታናሶን፥ ኤጵና ባሪክ ችምሜ የሮናሶን አሪፋትዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","ኤሲስማቶ ደይ ካቡግቶናሶንናዋ ኤጳታና ሻናናሶንና አሪፋትዋ። አንሶኪያክናዋ እኮኒዮክና፥ ደይ ልስትራክ ታይስታ ካርአ ቾዋሴዋ ፋኪያክ ኤጳታና ካቡግቶሴ አሪፋትዋ። ስኑንታኖ ዳሚስ ዙታምባሴ አሲስን ታን ፉኤዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","ፉቶክ ክርስቶስ የሱስኒር ስንነ ሀኦሶን ግርሲሬ ፎክ ሾልሴፌ ባሶ ዙቴሬ ካቡግቴሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","ስኑንታኖ ማጙ አሱኒ ሜናዋ ኤሽቱኒ ሜና አሱኒ ሜያኖን ኤሸትናዋ ቴትቤሲሲክ ዳጌሴትና ማጙስታ ማጙ ዳይሲሴትቱ ሀሜፌዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","ስኑንታኖ ነ ኦኪን አሪታማቶ አሪታር ስንና ቦርአ ኤስ አሪታ ባርክናዋ አማነታ ፉቶሲክና ዛጉዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","ዳግኔስታኔን ካብራ የሱስ ክርስቶስኒክ አማኖክ ፋሩ ቤስቴፋናማቶ ቴችማ እምፋ ኮርቶ ማፃፋሲክቶኖን አሪትዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","ኮርቶ ማፃፋሲክቶ ዙቴራ ሀኦሲ አያናኒ ዞንሲያክቱ ትቼርዋ። ኤስ ባር ደይ ፉቶሶን አሱክ፤ ዳጌ ባሶትን ኬኡክ፤ ዳጌት ፎሶን ካኑክናዋ ማአ ፎክ ስንኒ ኡግና እማክ ኬአርዋ። ");
INSERT INTO jnje_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","ኤስ ኬእፋናስ ደይ ሀኦኒ አሱ ዛግ ስናናክናዋ ኣፋ ማአ ዎስቶሶን ደይ ዎስቶክ ሆሬር ስንነ ቤስቶናክዋ። ");
INSERT INTO jnje_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","ሀኦሲ ስናክናዋ ደይ ታቶባሶን ዬትፌና ካባሲክና ሀየዉኒ ሜያስታናዋ ክቱኒ ሜያስታና ማጝሱ ካርኒ የሱስ ክርስቶስኒ ስና አዳራ ይፋን። ");
INSERT INTO jnje_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","ካምባሶን ማኮ፤ ማእፋናክ ማጝፋናክ ኣጌኑ ስኑን ችምማ ዎስቶዋ፤ አስሲት፥ ኬእትናዋ ኪትትና፤ ፋኪያክናዋ አስሱክና ችምዋ። ");
INSERT INTO jnje_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","አሱኒ ሜያክ ካ እምፋ አስሱሶን ኦዶክ ኦምቶሶነ ዎና ዮና። ስኑንታኖ ባሶ ሾልሴፌ ዉዛሶን ማኮኒ አስኛቤሲርን ዙቱሶነ። ");
INSERT INTO jnje_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","ኤስ ባሪ ቦርኣ ፉቶሲ ቾዋኖን ኦዶ ቤየፋት ራጅኒ ኦዶክ ሾልሴፌዋ። ");
INSERT INTO jnje_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","ስኑንታኖ ነ ዙታምባሴ አሲስታን ቴትኔሶን ኦድ። ሻናኒ ኤጴቶክ ዛጉ፤ ምስራቹኒ ካማንሲ ማኮኒ ዎስቶሶን ዎስቶ። ኔክ እምቴ ዎስቶሶን ዙትራ ኮእሱ። ");
INSERT INTO jnje_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","ታ ማአ ስናናክ ሆሬራቱ ፋን፤ ሀን ዳስታን ደይ ኦር ኬሳ ሀማና ዎና ካርእ። ");
INSERT INTO jnje_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","ኔቦሶን ማአሪክ ኔቤን፤ ኣታቶኒ ኤላሶን ኮእባ ካርአ ኤልን፤ አማንቶናሶን ኦድን። ");
INSERT INTO jnje_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","ሀንኔን ኤካሎ ኦኮኒ አክሊልስቱ ታክ ሆሬራ ፋር። ኤስ አክልሊሶን ፉቶክ ማጝሱ ካርፌ ዳሚስ ኤስ ካባሲክ ታክ እማና። እማናስ ደይ ታክ ኮእባ ስንኖይናሮን ባሳ አምማኖን ቤስቶሶን ካልቴሴፌ ባሶክኔጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","ታፕቴራ ሀጝ ታኪ ዮታክ ዱዶዋ። ");
INSERT INTO jnje_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","ዴማስ ሀን ዳስታኪ ፋ ዉዛሶን ሹንነ ታይስታን ኦር ኬስሴ ቴሴሎንቄ ሀሚ፤ ኬርቅጤስ ጋላትያ ሀሚ፤ ትቶ ደይ ድልማትያ ሀሚ። ");
INSERT INTO jnje_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","ታኔን አነ ፌይስ ሉቃስ ኮእባዋ። ማርቆስ ሀኦሲ ዎስቶክ ኬኒር ስንና ቦርአ ሾሌራ ታክ ኤጳ ዮዋ። ");
INSERT INTO jnje_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","ጥቂቆስኒን ኤፌሶን ዎስጝዋ። ");
INSERT INTO jnje_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","ያፋታ ካባሲክ ትሮአዳክ ካርፑስኒኪ ኤስታ ኩንስና ኮምቦርታናሶን ታክ ኤጳ ዮዋ። ማፃፋሲክቶኖን አሪክሮን ደይ ብራናን ማፃፋሶን ታክ ኤጳ ዮዋ። ");
INSERT INTO jnje_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","ብታ ክፌ እስኪንድር አካማ ሚርአ ታይስታ ካት። ዳሚስ ዎስቶባስማቶ ባርኪ ካሱና። ");
INSERT INTO jnje_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","ባር እንኖ ማኬፌን ባሮን ማእስሬ ቱጋኤር ስንና ቦርአ ነኑ ቴትኔሶን ባሳስታን ኦድዋ። ");
INSERT INTO jnje_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","ታ ማላቴና ቾዋሲክ ቴሱኒ ማልሲሶን ዎልግፋና ካባሲክ ዙታምቤሲሴቱ ታይስታን ዎኬቴታኖ ታኔን አነ የሬሬ ታን አሪጋስር ኦኑ ኣፌ። ኤስ ባሮን ደይ ሀኦሲ ማጝሱ ዛግራ ባሶስታ ፋዱናታ። ");
INSERT INTO jnje_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","ስኑንታኖ ዎስያስ ታክ ካሞ ዙቴራ ማክቶናክናዋ አዛብኒ ሜያ ዙቴሬ ኦዶሶነክ ዳሚስ ታኔን አነ ስንነ ታን ችኒ። ኤቶሳ ኖኖስን ደይ ፉቴን። ");
INSERT INTO jnje_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","ዳሚስ ማጙ ዉዛ ዙታምባሴ አሲስኒ ታን ፉኦና። ሳማኪ ፋ ታቶባስታ ታን ታሜ ካቱና። ባርኪ ኮእባ ፎንቶኖን ኡልፍና ስንፋውጝዋ! ኣሚን። ");
INSERT INTO jnje_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","ፕርስቅላክናዋ አቅላክና፤ ኦነስፎርምኒ ኬርክ ሜያክ ናጋናሶን ማኮ። ");
INSERT INTO jnje_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","ኤራስቶስ ቆሮንጦስ ካታማ ፉእቴ፤ ትሮፎሞስ ሜትቴና ቦርአ ምልጥን ቤያ ያን። ");
INSERT INTO jnje_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","ዬሹ ግሩኖይፌን ታክ ታፕቴሬ ዮክ ዱዶዋ። ኤዉቡሉስ፥ ጱደስ፥ ልኖስ፥ ክላዉድያነዋ አማኝኒ ሜነ ዙቴሬ ናጋ ማክሴድፌ። ");
INSERT INTO jnje_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","ዳሚስ ነኔን አነ ስኖ። ሀኦሲ ኦትማ ንቶኔን አነ ስንፋውጝ። ");
INSERT INTO jnje_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","ሀኦስ ኮርና አሱኒ ሜያኖን አማንቶቤሲሲክ ችሞነክናዋ አማንቶኒ ቾዋሶን ደይ ፉቶኒ አያናክ ፎሶን አርሶነክና ዛጉክ ሀኦሲ ቦዝናዋ የሱስ ክርስቶስኒ ዎሲ ስና ጳዉሎስኒኪን ዎስቴ ዎሲያ። ");
INSERT INTO jnje_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","ኤስ አማንቶስ ኮእባ ፎንቶ ካኒ አብዲስታ ካፑቴራ የሬርዋ፤ ኤሽኖይ ሀኦስስ ሀን ካሶን እማናክ ሾዎ ነያኔን ስናክ ዜምማ ቴያ እኖክ ግሪዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","ኤስ ነያስ ካርፋና ካባሲክ እኖትን ፋቲ ሀኦሲ አጃጅኒማቶ ታክ እምቴ አዳራሲክ ምስራቹኒ ካማሶን ማኮናክ ሀኦስ ካምባሶን ታክ አምማኖን ክስራ ቤሲዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","እኖክ ጋራ ስና አማንቶሲክ ፉቶኒ ናታ ስና ትቶኒክ፤ አባ ሀኦስኪንናዋ እኖትን ፋቲ የሱስ ክርስቶስኒኪንና ኦቱማሴዋ ናጋሴ ንቶክ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","ኔን ቀርጠሱክ ፎታክ ዛግናስ፤ ማእስቶኖይ ዉዛሲክቶኖን ማእሱታክናዋ ታ ኔን አጃጀናሲማቶ ቤቴክርስታኒስ ኩርኡኒ ሜያኖን ካታማ ካታማሲ ታትሱታክዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","ቤቴክርስታንኒ ኩርኡ ስንኒ አሱ ካሽስቶኖርናዋ እሳ አሱኒ ቴጎ ስናር፤ ጋፎ ስንኖርናዋ አጃጃምቶ ቤያክና ሀማቶኖይ ናንጎትባ ፋናር ስናናክቱ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","ቤቴክርስታንኒ ኩርኡስ ሀኦሲ ዎስቶኖን አዳራክ ኤጳት ፌር ስንና ቦርአ ካሽስቶኖር ስናናክቱ ሾልሲፋዋ። ኤሲስማቶ ደይ ጌእኖር፥ ታእኖን ግእቶኖር፥ ዛዎኖር፥ ፋሶኖር፥ ዋግኒ ጆራባ ፎንቶ ስናናክቱ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","ኤስ ባርስታን ኦማ ኬባሲክ እርባኒን እርባሱክ፤ ማአር ስና ዉዛሶን ሹናር፤ ቴትባሶን ሀእሲር፤ ቴትባሲክ ማአር፤ ሀኦሲ ዎስቶክ ቴትባሶን ኮሪር፤ ታክ ፋ ፎናስ ሆሬ ይሬ ፎክ ችማር ስናናክቱ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","ፉቶኒ አሱሶን አስሲት፤ ኪቱክናዋ ቱጋኤሴፌ ባሶክ ዎልጉባ እማ ችማታክ ነ አሪታ አሩኒ ካማሲክ ችምማ የሮዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","ሾዎ አሱኒ ሜያ አይሁድኒ ኬን ስና አማኝኒ ሜያ፤ ሃርኮ ኩንሱኒ ስትሪሲክ ሀምኖር፤ አጃጃሞኖር፤ ሽማሲክ ሳሴትናዋ ኤሸትና ፌሴ አሱኒ ሜያ ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","ኤስ ባሶ ሻኩሶነክ ዛጉንክቱ ሾልሲፋዋ፤ ባሶ ስንኖይ ኡግናክ ዳኖሶነክ ሾልሱኖይ ዉዛሲክቶኖን አሲፋፌ አሱሳ ኬያኖን ዙታምባሴ አሲን ሾርኪት ፌሴቴርዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","ባሶ ጋነያስን ባሶ ራጁ ስና ባር፦ «ቀርጠስኪ አሱኒ ሜያ ኣጌኑ ስንፋናክ ኤሽኛ ደይ ማጙ ጎኞ፤ ዎስቶ ኮትኛ ደይ ጆርቱዋ» ይዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","ኤስ ዛላስ ደይ ፉቶዋ፤ ኤስ ባሪ ቦርኣ ቱማ አማንቶቤስ ፎናክ ባሶትን ኬእኡዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","አይሁድኒ ሜኒ ቶቾሶን ኤጴቶሶኖይቴማቶናዋ ፉቶሶን ቱጋእሴፌ ባሶ አጃጂሶን ኦዶሶኖይቴማቶና ማእስራ ኬእኡዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","ካይምኒ ሜያክ ዙታምባሴ ካይማዋ። ስኑንታኖ ኪና ዉዛ ዎስቴሴፌ ሜያክናዋ አማኖ ቤየፌ አሱኒ ሜያክና ካይማ ስና ዉዛ እሳንነ ኣፋዋ። ኤሲስማቶ ደይ ካኑቤሲስ ስኑን ያዳትቤሲስ ኪናዋ። ");
INSERT INTO jnje_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","«ሀኦሶን አርፌኒዋ» ይሴቴርዋ፤ ስኑንታኖ ዎስቶቤሲሲክቱ ሞርሜሴፌዋ፤ ኤስ ባሶ ሳልጳቱ፤ አጃጃምቶኖር ደይ ማአ ዎስቶ ዎስቶክ ችሞኖይ አሱኒ ሜያዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","ስኑንታኖ ነ ፉቶ ስና አስሱሶን አስሱዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","ኩርኡ ኣርቃሱኒ ሜያ ባሶክ ፋ ፎቤሲሲክ ፌሴር፤ ኡልፍንቤሲሶን ኦዳር፤ ቴትቤሲሶን ሀኡኖር፤ አማንቶክናዋ ኬሽታናክና ደይ ፋኪያክ ዛግ ስኖነክ ኪቱዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","ኤሲስማቶ ኩርኡ ማሽካ ሜያ አማላቤሲስክ ማአር፤ ኡልፍንቶ ስንነ ፎሶነክታኖ አሱስን ሀማትሴት ኡሽኒ ሱሲክ ኦድቶሶኖይቴማቶ ማአ አሱሶን አሱሶነክ ባሶትን ኪቱዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","ኤሲስማቶ ደይ ናኦ ማሽካሱሲክቶ ቴጎቤሲስንናዋ ናንጎትቤስሶንና ኬሽቶሶነክ፤ ");
INSERT INTO jnje_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","ቴትቤሲሶን ኦዳክ ካይማ፤ ማአር ደይ ቴጎቤሲሲክ አጃጃምቴር ስኖነክ አሱሶቶዋ። ኤስ ባሮን ደይ ዛጉሶኔስ ሀኦሲ ካማ ካሽስቶኖይናማቶዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","ኤሲስማቶ ደይ ጋይማ ሜያ ቴትቤሲሶን ሀእሱሶነክ ኪቱዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","ነ ደይ ማአ ዉዛ ስና ባሮን ዛግት ቾዋ ዙታምባሴ አሲክ ባሶክ ቤሶ ስጝዋ። አሱኔሲክ ደይ ፉቶሶን፥ አማናምቶ ስንኔሶን ባሶክ አምማኖን ቤሱዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","ካሽስቶኖይ ማአ ዎሉምኔሶን አምማኖን ባሶክ ኪሲራ ቤሱዋ። ኤስ ባሮን ደይ ዛጉክ ቱጋእሴፌ ባሶ እኖስታ ማጙ ዉዛ ቱሩክሴፌ ካባሲክ ኢቾሶነዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","ቦዝኒ ሜያ ደይ ዳምቤሲሲክ አጃጃሞሶነክ፤ ቾዋ ዙታምባሴ አሲክ ግርሱሶቶታኖ ማጙ ካማ ዎልጉሶነታዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","ደይ ዳምቤሲሳ ዋጋኖን ዊሶሶኖይቴማቶ ኪቱዋ፤ ኤስ ባርስታን ደይ እኖትን ፋቲ ሀኦሲ አስሱኖን ቾዋ ዙታምባሴ አሲክ ኡልፍንቶናክ ዎንና ዎንና ዮኡባ ፎንቶ አማናምቶቤሲሶን ቤሱሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","አሱ ዙታምባሴ አሲን ፋቱኒ ሀኦሲ ኦትማ አምማኖን ኬሳ ቤስቴዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","ኤስ ሀኦሲ ኦትማ ደይ ሞርሞሶንናዋ አሻሲ ኤናንቶሶንና ቤያ ቴትኒሶን ኦድዳ ሀኦሶን ግርሱኒ ፎ ሀን ዳስታክ ፎኒክቱ እኖትን አስሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","ኤሲስማቶ ኤቢስቶ አብድኒሶን ደይ አሪክቶ ሀኦኒስ፤ እኖትን ፋቲ የሱስ ክርስቶስኒ ኡልፍናክ ዮሶን ኦድትፌኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","ክርስቶስ ማጙ ዉዛ ዙታምባሴ አሲስን እኖትን ፉኦናክናዋ ማአ ዎስቶሶን ዎስቶክ ችምማ ባሪክ ኮርቴራ ኬሳ ካይም ዳራ ስናኒክናቱ ባር እኖትን ካይኑናክ ቴትባሶን ኣትሬ እሚዋ። ");
INSERT INTO jnje_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","ኤሴ፤ ኤስ ዉዛሲክቶኖን አስሱዋ፤ ቱማ ሀእሱኒ ሁግናክ ኪቱ፤ ደይ ኬእኡ፤ ኦኑ ኔን ካሹናታዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","አሱኒ ሜያ ዙታምቤሲሴ ባሶትን ሀእሲፌ ጋኜ ሜያክ ሹፕጴ ሀኡሶነክናዋ አጃጃሞሶነክና፤ ማአ ዎስቶሶን ዙታምባሴ አሲን ዎስቶክ ሆሬር ስኖሶነክና ማኮዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","ኦኒስታኑ ስንፋናክ ማጙ ዎል ላ ዎሉምሶኖይቴማቶ ዛግራ ማኮዋ። ኤስ ባርስታን ደናሎ አሱኔን አነ ፋሶኖይ ጋራም፤ ፉቶኒ ቴትኒ ዳ ኤጳሶን አሱ ዙታምባሴ አሲክ ቤሲር ስኖቶዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","እንኖ ደይ ዜሞ ስናክ ያዳትኒ ፎንቶ፥ አጃጃምቶኖር፥ ኡጉኒሶን ዳጌር፥ ኦማ ኦማ ኤናንቶክ አሽኒ ግራክ ሀእት ማጙክናዋ አሱኒስታ ማጙ ዉዛ ሳፋሬትና እኖትና እኖትና ዎል ፋሴት ፋኒርዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","ስኑንታኖ እኖክ ኤትኒ ስና ሀኦሲ ማእነዋ ኬሽታናክ ቱማ ኬናሽቶባሴ አምማኖን ኬስሳ ቤስቴፋና ካባሲክ፤ ");
INSERT INTO jnje_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","እንኖ ዎስቴኒ ኦኮ ዎስቶኒሲክ ስኖይናሮን ባር ፋኪባሲክ እኖትን ፉኤዋ። እኖትን ፉኤናስ ደይ ሄፕሳ ኮንቴሬ ማሶክናዋ ኮርቶ አያናሲኪ ካሞ ቤስቴ ጋድዶ ስናሲክዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","ሀኦስ ጋራምባሲክ እኖትን ፉኤ የሱስ ክርስቶስኒኪ ካሞ አያናባሶን እኖክ ዳይስራ ዉኪዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","ኤስ ባሮን ደይ ዛግናስ እንኖ ባሪ ኦትማሲክ ኦኮ ስንና አብድክ ኦደት ፋኒ ኮእባ ፎንቶ ካሶን ዋራሶኒክዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","ኤስ ባር ደይ አማናምቶ ዎል ላዋ፤ ሀኦሲክ አማነ አሱኒ ሜያ ማአ ዎስቶሶን ዎስቶክ ችሞነክ ሀን ባሮን ዙትራ ባሶክ ዛግራ ማኮታክ ሾሌፋዉጙዋ። ኤስ ዉዛሲክቶ ማአር ደይ አሱ እሳርባ እሳርባሲክ ኬአርዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","ስኑንታኖ ጎዋኒ ሜኒ ካራካሮስን፤ ኮንቶኒ ቱዝኒ ፋዱኖን፤ ፋሶሶን፤ ቱማሲ ቾዋክ ካብፋ ፋሶሲን ቴትኔሶን ኦድዋ። ኤስ ዉዛሲክቶ ኬእኖር ደይ ዋግባ ፎንቶዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","ኦር ኦር ኬሳሶን ኤጴ ዬፌ አሱስን እሳርጋ ኪቱ፤ ሄፕሳ ደይ ኬእታኔን ኦርፎ ባሳስታን ዎክዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","ኤስ ኤፌ አሱስ ኤልጝ ደይ ቦርእኛዋ። ባር ባሳስታ ዎልግሬ ማጝሱ ካርእ ስንናማቶ አሩዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","አሪጠማስኒን ወደይ ጥቂቆስኒን ኔኪ ዎስፋና ካባሲክ ታፕቴራ ታ ፋና ድማ ንቆጲልዮን ዮዋ። ታ ሀን ዬሹሶን ኤስታ ኣቱናክ ቡግጝዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","ቱማሶን አሪፌ ዜናስኒንናዋ አጵሎስንና ኡጉንኒ ኩቱክ ካብሶነክ ዛጉዋ። ባሶክ ሾልሲ ዉዛ ዙታምባሴ አሲን አርጋሱዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","እንኖ አስሱስ ደይ ጋንቤስ ፎንቶ ስንነ ፉእቶሶኖይቴማቶናዋ ፎኒ ራክኮሶን ችምሜ ኣታክ ችሞሶነክና ማአ ዎስቶሶን ዎስቶሶነክ አሩሶቶዋ። ");
INSERT INTO jnje_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","ታኔን አነ ፌሴ ባሶ ዙታምቤሲሴ ናጋ ኔክ ዎሴቴዋ። አማንቶሲክ እኖኔን አነ ሃኤር ስና እኖትን ሹንፌ ባሶክ ዙትራ ናጋኒሶን ካቱዋ። ሀኦሲ ኦትማ ዙታምኒትሴኔን አነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","ክርስቶስ የሱስኒ ቾዋሲክ ታቶ ስና ጳዉሎስኒኪንናዋ አይኒ ስና ትሞትዮስኒኪንና፥ ሹንቶ አይኒስክንናዋ እኖኔን አነ ዎስቴፌ ፍልሞናኒክና፦ ");
INSERT INTO jnje_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","ኤሲስማቶ ደይ ኔኪ ኬር ዙቴሴፌ አማኝኒ ሜያክ ኤትኒ ስና አፍብያክ እኖኔን አነ ክርስቶስኒ ሜያ ታርኦ ስና አርክጳስኒክ፤ ");
INSERT INTO jnje_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","አባ ሀኦኒስኪን፤ ዳምኒ የሱስ ክርስቶስኒ ኦትማሴዋ ናጋሴ ንቶክ ስንፋውጝ። ");
INSERT INTO jnje_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","ሺጶናሲክ ኔን ሳፋሬት ዎንና ዎንና ሀኦናሶን ጋላቴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","ዳምኒ የሱስኒስታ ፋ አማንቶነሴዋ አማኝኒ ሜያክ ፋ ኬሽታንኔሴ አሲን ኦደጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","ክርስቶስኒር ስናሲክ ዳንኒ ማአ ዉዛስ ዙታምባሴ አስን አምማኖን አሩታክ አማንቶኔሶን ኦምኒ ሜያ ሃአ ችማታክ ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","አይታሶ! አማኝኒ ሜኒ ንብባስ ነይስታ ቤይሳ ዳንና ቦርአ ኬሽታኔስታን ታ አካማ ግራነዋ ችምነ ዳንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","ኤስ ባሪ ቦርኣቱ ዎስቶኔሶን ኮእሱዋ ይራ ኔን አጃጆክ ክርስቶስኒኪ ካሞ ችማ ዳንጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","ስንፋናክኑ ኤስ ባሮን ዛጉስታን የሱስ ክርስቶስኒ ቾዋሲክ ታቶ ስና ታ ኩርኡ ጳዉሎስ ኬሽታናክ ሺጶሶንቱ ሾሌፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","ታ፤ ታቶኒ ኬር ፋጌዶ ዳንና ናታ ስና ኦነስሞስኒ ቾዋሲክ ኔን ሺጴፋዉጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","ዜሞ ስናክ ኦነስሞስ ኔክ ኬእኖር ስንነ ፌር፤ ስኑንታኖ ሀሽ ኔክነን ታክኔን ኬእኒር ስኒዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","ባሪን ኔኪ ዎልግራ ዎስጝዋ፤ ባሪን ኔኪ ዎሲናስ ታ ንባሲ ሳፋራኖን ዛግጉኒ አሱኒን ዛግራቱ ፋድፋዉጝዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","ምስራቹኒ ካማሲ ቦርአ ታቴራ ፋና ካባሲክ ነ ኤዴ ስንነ ታን አርጋሱናክ ባር ታኔን አነ ፌፋናነ ግሮና ካባዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","ስኑንታኖ ነ ዛግፋታ ማአ ዎስቶስ ሹናክታኖ ግድክ ስኖይናማቶዋ እያት ነኔን አነ ሜርኮኖይ እሳ ዉዛነ ዛጉክ ኣነ ሾሎትዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","ኦነስሞስ ጋሮ ዎን ኒሮን ነይስታን ኦር ኬስናስ አዉዛክነ ሀውጙኔን ኤካሎ ነይስታን ኦር ኬስኖይ ነኔን አነ ፎና ስናናዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","ስኑንታኖ ሀውጙኔን ኤካሎ ባር ነኔን አነ ፎናስ ቦዝኒማቶ ስኖይናሮን ቦዚሳታን ደናሎ ሹንቶ አይ ስንነዋ። ባር ታክ ሹንቶ አይታዋ፤ ስኑንታኖ አሻክ ፌና ካባሲክ ዎስቴፌና ዎስቶስ ኔክ ኬእኒር ስንና ቦርአ አያናባሲክ ደይ ክርስቶስኒኪ ካሞ አይነ ስንና ቦርአ ኔክ አሪክሮን ሹንቶዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","ኤሴ ታን አይ ዛግራ ፋድታነ ባሪን ደይ ታነ ፌር ዛግራ ፋድራ ኤጳቶዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","ባር ኔን ሚርእኤና ዉዛ ወደይ ኮዋ ፋፋናነ ኤስ ኮዋሶን ታይስታ ፋዱዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","ታ፤ ጳዉሎስ ኮዋሶን ኔክ ካሱና ይራ ሃን ትቻሶን ኩሹናሲክ ኔክ ትችጝዋ። ስንፋናክ ካኔሲ ቾዋክ ነኑ ቴትኔሲክ ታ፤ ኮዋ ነይስታ ፋናማቶ ታ ኔን ያዳሱናክ ኣነ ሾልሲፋዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","ኤሴ አይታሶ! ሀን ማአ ዉዛሶን ታክ ዛጉታክ ዳሚሳ ሱናክ ሺጴፋዉጙዋ። አዳራዋ ክርስቶስኒክዋ እያት ንብናሲክ ቤይሳ እማይዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","ሀን ባሮን ኔክ ትችናስ ማእ ኡታር ስኔሶን አማነፋና ቦርአዋ። ታ ኔን ማምሲናስታን ደናሎኖን ዳይሲራ ዛጉታማቶ አሪፋውጙዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","ኤስ ባርስታን ደናሎ ሀኦስ ሺጶኒትሶን ኦደራ ንቶኪ ዮናክ ዛጉናክ አብድና ፋር ስንና ቦርአ ቤይሳ ኤጳና ኬያ ታክ ሆሱዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","ክርስቶስ የሱስኒ ቦርአ ታኔን አነ ታቴሬ ፌ ኤጳፍራ ኔክ ናጋ ዎሲዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","ኤሲስማቶ ደይ ታኔን አነ ዎስቴሴፌ ሜያ፦ ማርቆስ፥ አርስትሮኮስ፥ ዴማስናዋ ሉቃስና ናጋ ኔክ ዎሴቴዋ። ");
INSERT INTO jnje_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","ዳምኒ የሱስ ክርስቶስኒ ኦትማስ ንቶኔን አነ ስንፋውጝዋ። ");
INSERT INTO jnje_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","ሀኦስ ዜሞቲ 